Twapake is a utility for Slackware and Slackware based operating
systems only.

## Features

* print a list of N packages sorted by installed date to STDOUT.
* print a "twapake snapshot", a list of packages sorted by
* installed date in a log file (/var/log/twapake/$date_twapake.log).
* can remove the last N installed packages.
* ...


## Download

Sources tarballs and SlackBuild can be found there:

https://framagit.org/fredg/twapake/tree/master/


## Purpose
Twapake can be usefull when:

* making a daily snapshot with the help of a cron job,
* if you are getting into troubles, it will be easy to see which new packages
  have been installed since time T,
* you like testing a lot off packages, some of them making you install a bunch
  of extra libs,
* you can print a twapake snapshot before your testing party and, after. The
  diff will give you the list of what you have to remove to retrieve a clean
  system,
* you want to see what are the last 5 installed packages,
* you want to remove the last 6 installed packages.


### What is a twapkake snapshot (twapake --logfile)


It's a file /var/log/twapake/$date_twapake.log

```
Twapake snapshot on Sun Apr  2 17:46:45 2017
========================================================================

Installed dates		Packages (total: 1067)
-------------------	---------------------------------------------
2017-04-02 15:55:31	twapake-0.5.1-noarch-1_SBo
2017-04-02 15:15:21	perl-Curses-UI-0.9609-x86_64-1ponce
2017-04-02 15:15:14	perl-Curses-1.28-x86_64-1ponce
2017-04-02 13:51:58	password-store-1.6.5-noarch-1ponce
2017-04-02 13:51:56	pwgen-2.07-x86_64-1ponce
2017-04-02 13:51:52	xclip-0.12-x86_64-1ponce
2017-04-02 09:47:39	samba-4.6.2-x86_64-1
2017-04-02 09:47:25	nano-2.8.0-x86_64-1
2017-04-02 09:46:19	mozilla-firefox-l10n-fr-52.0.2-x86_64-1alien
2017-04-01 17:23:53	txt2tags-r1172-x86_64-1ponce
2017-03-31 19:21:36	xfce4-notifyd-0.3.6-x86_64-1
2017-03-31 19:21:34	pkg-config-0.29.2-x86_64-1
2017-03-31 19:21:33	openssh-7.5p1-x86_64-1
2017-03-31 19:21:31	mozilla-firefox-52.0.2-x86_64-1
...
..
.
```

For a less detailed list (twapake -i)

```
twapake-0.5.1-noarch-1_SBo
perl-Curses-UI-0.9609-x86_64-1ponce
perl-Curses-1.28-x86_64-1ponce
password-store-1.6.5-noarch-1ponce
pwgen-2.07-x86_64-1ponce
xclip-0.12-x86_64-1ponce
samba-4.6.2-x86_64-1
nano-2.8.0-x86_64-1
mozilla-firefox-l10n-fr-52.0.2-x86_64-1alien
...
..
.
```

You can choose the number of packages to be printed:

    twapake -i -n 5 : last 5 installed packages


### Removing last installed packages

    twapake -r -n 5 : remove the last 5 installed packages
