/*
 * Copyright (C) 2003-2013 Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <strings.h>
#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

/* Aewm and Sithwm output support */
static void aewm(struct group *root, int level, const char *use_term, const int aewm_type)
{
    int i;
    struct item *item;
    if (root == (struct group *)NULL) {
	return;
    }
    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	}
	printf("menu \"%s\"\n", root->name);
    }

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    aewm(item->data, level+1, use_term, aewm_type);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (app != NULL) {
		for (i=0; i<level; i++) {
		    printf(" ");
		}
		/* Aewm output supports quit, Sithwm does not */
		if ((aewm_type == 0) && (app->restart)) {
		    if (strncasecmp(app->restart, "quit", 4) == 0) {
			printf(" cmd \"%s\" \"killall aesession\"\n", app->name);
		    }
		} else if (!app->restart) {
		    if (app->terminal != NULL) {
			printf(" cmd \"%s\" \"%s -e %s\"\n", app->name, use_term, app->exec);
		    } else {
			printf(" cmd \"%s\" \"%s\"\n", app->name, app->exec);
		    }
		}
	    }
	}
	item++;
    }
    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	}
	printf("end\n");
    }
}

void output_aewm(struct group *root, const char *use_term, const int aewm_type)
{
    aewm(root, 0, use_term, aewm_type);
}
