/*
 * Copyright (C) 2003-2015 Tommy Scheunemann
 *
 * Modify:  2015/20/01  Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <strings.h>
#include <string.h>

extern const char *root_menu_name;

/*
 * Outputs on stdout the Amiwm configuration
 */

void output_amiwm(struct group *root, const char *use_term)
{
    struct item *item;
    if (root->name != root_menu_name) {
	printf("ToolItem \"%s\" {\n", root->name);
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;

	    /* Amiwm seems to have no restart or quit function and an ending & needs to be removed */

	    if (! app->restart) {
		char *b;
		int l;
		b = app->exec;
		l = strlen(b);

		printf("ToolItem \"%s\" \"", app->name);

		/* terminal option set, prepend the terminal call */
		if (app->terminal) {
		    printf("%s -e ", use_term);
		}

		/* continue with the command output */
		while (l > 0 && b[l - 1] == ' ') {
		    l--;
		}
		if (l > 0 && b[l - 1] == '&') {
		    l--;
		}
		for (; l > 0; l--,b++) {
		    putchar(*b);
		}
		printf("\"\n");
	    }
	}
	item++;
    }
    if (root->name != root_menu_name) {
	printf("}\n\n");
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    output_amiwm(item->data, use_term);
	}
	item++;
    }
    return;
}
