/* blackbox.c  -*- C -*-
 *
 * Created: 1999/06/02 Jos Romildo Malaquias <romildo@iceb.ufop.br>
 *
 * Modify:  2015/20/01 Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2014/07/29 Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2003/12/23 Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2000/01/31 Igor Homyakov <comandore@mail.ru>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * Functions needed for producing Blackbox configuration
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <strings.h>

/* Return valid menu item  */
char* valid_string (char *str);

/*
 * Outputs on stdout a blackbox-compatible configuration
 */
void output_blackbox(struct group *root, int level, const char *use_term)
{
    struct item *item;
    int sp;

    if (root == (struct group *)NULL) {
	return;
    }

    if (level > 0) {
	for (sp = 0; sp < level; sp++) putchar(' ');
    }

    printf("[submenu] (%s)\n", valid_string(root->name));

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *subgroup = (struct group *)item->data;
	    output_blackbox(subgroup, level + 1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;

	    app = (struct package *)item->data;
	    if (app->restart) {
		if (strncasecmp(app->restart, "restart", 7) == 0) {
		    printf("[restart] (%s)\n", app->name);
		} else if (strncasecmp(app->restart, "quit", 4) == 0) {
		    printf("[exit] (%s)\n", app->name);
		} else {
		    printf("[restart] (%s) {%s}\n", app->name, app->exec);
		}
	    } else {
		if (app->name && app->exec && app->__package) {
		    /* this removes ending '&' that should not be there */
		    char *b;
		    int l;
		    b = app->exec;
		    l = strlen(b);

		    for (sp = 0; sp <= level; sp++) putchar(' ');
		    printf("[exec] (%s) {", valid_string(app->name));

		    if (app->terminal) {
			printf("%s -e ", use_term);
		    }
		    while (l > 0 && b[l - 1] == ' ') {
			l--;
		    }
		    if (l > 0 && b[l - 1] == '&') {
			l--;
		    }
		    for (; l > 0; l--,b++) {
			putchar(*b);
		    }
		    printf("}\n");
		}
	    }
	}
	item++;
    }
    if (level > 0) {
	for (sp = 0; sp < level; sp++) putchar(' ');
    }

    printf("[end]\n");
}
