/*
 * Copyright (C) 2002-2015 Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <strings.h>

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

extern unsigned int flags;

/* Fvwm requires submenus defined before they are used - Wmconfig uses a "reverse" output */
void output_fvwm(struct group *root, const char *use_term)
{
    struct item *item;
    if (root == (struct group *)NULL) {
	return;
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    output_fvwm(item->data, use_term);
	}
	item++;
    }

    item = root->items;

    /* Here we finally create menus */
    printf("PopUp \"%s\"\n Title \"%s\"\n", root->name, root->name);
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *tmp;
	    tmp = (struct group *)item->data;
	    printf(" PopUp \"%s\" %s\n", tmp->name, tmp->name);
	} else if (item->type == ITEM_APP) {
	    /* Here we create the menu items */
	    struct package *app;
	    app = (struct package *)item->data;
	    if (app->restart) {
		if (strncasecmp(app->restart, "restart", 7) == 0) {
		    /* restart pseudo item */
		    printf(" Restart \"%s\" fvwm\n", app->name);
		} else if (strncasecmp(app->restart, "quit", 4) == 0) {
		    /* quit pseudo item */
		    printf(" Quit \"%s\"\n", app->name);
		} else {
		    /* restart another WM */
		    printf(" Restart \"%s\" %s\n", app->name, app->restart);
		}
	    } else {
		if (app->name && app->exec && app->terminal) {
		    /* Terminal required */
		    printf(" Exec \"%s\" exec %s -e %s\n", app->name, use_term, app->exec);
		} else if (app->name && app->exec) {
		    /* Normal menu item */
		    printf(" Exec \"%s\" exec %s\n", app->name, app->exec);
		}
	    }
	}
	item++;
    }
    printf("EndPopup\n\n");
    return;
}
