/*
 * Copyright (C) 2002-2015 Tommy Scheunemann
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <strings.h>

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

/* Golem Window manager output function */
static void golem(struct group *root, int level,const char *use_term)
{
    int i;
    struct item *item;
    if (root == (struct group *)NULL)
	return;
    /* print seperators for submenus */
    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	}
	printf("param \"submenu\" \"%s\" {\n", root->name);
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    golem(item->data, level+1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (app != NULL) {
		/* seperator for submenus */
		for (i=0; i<level; i++) {
		    printf(" ");
		}
		/* restart and quit functions */
		if (app->restart) {
		    if (strncasecmp(app->restart, "restart", 7) == 0) {
			/* restart Golem */
			printf(" param \"restart\" \"%s\"\n", app->name);
		    } else if (strncasecmp(app->restart, "quit", 4) == 0) {
			/* quit Golem */
			printf(" param \"exit\" \"%s\"\n", app->name);
		    } else {
		        /* restart another WM */
			printf(" param \"restart\" \"%s\" { param \"dat\" \"%s\"; }\n", app->name, app->exec);
		    }
		} else {
		    if (app->terminal) {
			/* include terminal in menu item */
			printf(" param \"command\" \"%s\" { param \"dat\" \"exec %s -e %s\"; }\n", app->name, use_term, app->exec);
		    } else {
			/* normal menu item */
			printf(" param \"command\" \"%s\" { param \"dat\" \"exec %s\"; }\n", app->name, app->exec);
		    }
		}
	    }
	}
	item++;
    }
    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	}
	printf("}\n");
    }
}

void output_golem(struct group *root,const char *use_term)
{
    golem(root, 0, use_term);
}
