/*
 * Copyright (C) 2002-2015 Tommy Scheunemann
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"
#include <stdio.h>
#include <strings.h>

extern unsigned int flags;

void output_mlvwm(struct group *root,const char *use_term)
{
    struct item *item;
    char *root_name;
    if (root == (struct group *)NULL) {
	return;
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU)
	    output_mlvwm(item->data, use_term);
	item++;
    }

    item = root->items;
    root_name = single_string(root->name);
    printf("Menu %s, Label \"%s\"\n", root_name, root_name);
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *tmp;
	    tmp = (struct group *)item->data;
	    printf(" \"%s\", SubMenu %s\n", tmp->name, single_string(tmp->name));
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (app->name && app->exec) {
		if (app->restart) {
		    if (strncasecmp(app->restart, "restart", 7) == 0) {
			printf(" \"%s\" Action Restart mlvwm\n", app->name);
		    } else if (strncasecmp(app->restart, "quit", 4) == 0) {
			printf(" \"%s\" Action Exit\n", app->name);
		    } else {
			printf(" \"%s\" Action Restart %s\n", app->name, app->exec);
		    }
		} else {
		    if (app->terminal != NULL) {
			if ((app->mini_icon != NULL) || ((!is_set(NO_MINI_ICONS)) && (!is_set(NO_ICONS)))) {
			    printf(" \"%s\" Icon %s, Action Exec \"%s\" exec %s -e %s\n", app->name, app->mini_icon, app->name, use_term, app->exec);
			} else {
			    printf(" \"%s\", Action Exec \"%s\" exec %s -e %s\n", app->name, app->name, use_term, app->exec);
			}
		    } else {
			if ((app->mini_icon != NULL) || (is_set(NO_MINI_ICONS))) {
			    printf(" \"%s\" Icon %s, Action Exec \"%s\" exec %s\n", app->name, app->mini_icon, app->name, app->exec);
			} else {
			    printf(" \"%s\" Action Exec \"%s\" exec %s\n", app->name, app->name, app->exec);
			}
		    }
		}
	    }
	}
	item++;
    }
    printf("END\n\n");
    return;
}
