/*
 * Copyright (C) 2002-2014 Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"
#include <stdio.h>
#include <strings.h>

extern unsigned int flags;

/* Sawfish requires submenus defined before they are used - Wmconfig uses a "reverse" output */
void output_sawfish_menu(struct group *root,const char *use_term)
{
    struct item *item;
    if (root == (struct group *)NULL) {
	return;
    }

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    output_sawfish(item->data, use_term);
	}
	item++;
    }

    item = root->items;
    /* Here we finally create menus */
    printf("(defvar %s\n\t(list\n", single_string(root->name));
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *tmp;
	    tmp = (struct group *)item->data;
	    printf("\t'(\"%s\" . %s)\n", tmp->name, single_string(tmp->name));
	} else if (item->type == ITEM_APP) {
	    /* Here we create the menu items */
	    struct package *app;
	    app = (struct package *)item->data;
	    if (app->restart) {
		if (strncasecmp(app->restart, "restart", 7) == 0) {
		    /* restart pseudo item */
		    printf("\t'(\"%s\" restart)\n", app->name);
		} else if (strncasecmp(app->restart, "quit", 4) == 0) {
		    /* quit pseudo item */
		    printf("\t'(\"%s\" quit)\n", app->name);
		} else {
		    /* restart another WM */
		    printf("\t'(\"%s\" (progn (setq saved-command-line-args '(\"%s\")) (restart)))\n", app->name, app->restart);
		}
	    } else {
		if (app->name && app->exec && app->terminal) {
		    /* Terminal required */
		    printf("\t'(\"%s\" (system \"exec %s -e %s\"))\n", app->name, use_term, app->exec);
		} else if (app->name && app->exec) {
		    /* Normal menu item */
		    printf("\t'(\"%s\" (system \"exec %s\"))\n", app->name, app->exec);
		}
	    }
	}
	item++;
    }
    printf("))\n");
    return;
}

void output_sawfish(struct group *root,const char *use_term)
{
    printf("(provide '%s)\n", single_string(root->name));
    output_sawfish_menu(root, use_term);
}
