/**
 * @file	externalopm.cpp
 * @brief	O OPM tNX̓̒`s܂
 */

#include "compiler.h"
#include "externalopm.h"

/**
 * RXgN^
 * @param[in] pChip `bv
 */
CExternalOpm::CExternalOpm(IExternalChip* pChip)
	: m_pChip(pChip)
{
	memset(m_cAlgorithm, 0, sizeof(m_cAlgorithm));
	memset(m_cTtl, 0x7f, sizeof(m_cTtl));
}

/**
 * fXgN^
 */
CExternalOpm::~CExternalOpm()
{
	delete m_pChip;
}

/**
 * `bv ^Cv𓾂
 * @return `bv ^Cv
 */
IExternalChip::ChipType CExternalOpm::GetChipType()
{
	return m_pChip->GetChipType();
}

/**
 * Zbg
 */
void CExternalOpm::Reset()
{
	memset(m_cAlgorithm, 0, sizeof(m_cAlgorithm));
	memset(m_cTtl, 0x7f, sizeof(m_cTtl));
	m_pChip->Reset();
}

/**
 * WX^
 * @param[in] nAddr AhX
 * @param[in] cData f[^
 */
void CExternalOpm::WriteRegister(UINT nAddr, UINT8 cData)
{
	if ((nAddr & 0xe0) == 0x60)					// ttl
	{
		m_cTtl[nAddr & 0x1f] = cData;
	}
	else if ((nAddr & 0xf8) == 0x20)			// algorithm
	{
		m_cAlgorithm[nAddr & 7] = cData;
	}
	WriteRegisterInner(nAddr, cData);
}

/**
 * bZ[W
 * @param[in] nMessage bZ[W
 * @param[in] nParameter p[^
 * @return 
 */
INTPTR CExternalOpm::Message(UINT nMessage, INTPTR nParameter)
{
	switch (nMessage)
	{
		case kMute:
			Mute(nParameter != 0);
			break;
	}
	return 0;
}

/**
 * ~[g
 * @param[in] bMute ~[g
 */
void CExternalOpm::Mute(bool bMute) const
{
	const int nVolume = (bMute) ? -127 : 0;
	for (UINT ch = 0; ch < 8; ch++)
	{
		SetVolume(ch, nVolume);
	}
}

/**
 * WX^()
 * @param[in] nAddr AhX
 * @param[in] cData f[^
 */
void CExternalOpm::WriteRegisterInner(UINT nAddr, UINT8 cData) const
{
	m_pChip->WriteRegister(nAddr, cData);
}

/**
 * H[ݒ
 * @param[in] nChannel `l
 * @param[in] nVolume H[l
 */
void CExternalOpm::SetVolume(UINT nChannel, int nVolume) const
{
	/*! ASY Xbg }XN */
	static const UINT8 s_opmask[] = {0x08, 0x08, 0x08, 0x08, 0x0c, 0x0e, 0x0e, 0x0f};
	UINT8 cMask = s_opmask[m_cAlgorithm[nChannel] & 7];

	int nOffset = nChannel;
	do
	{
		if (cMask & 1)
		{
			int nTtl = (m_cTtl[nOffset] & 0x7f) - nVolume;
			if (nTtl < 0)
			{
				nTtl = 0;
			}
			else if (nTtl > 0x7f)
			{
				nTtl = 0x7f;
			}
			WriteRegisterInner(0x60 + nOffset, static_cast<UINT8>(nTtl));
		}
		nOffset += 8;
		cMask >>= 1;
	} while (cMask != 0);
}
