/**
 * @file	externalchipmanager.cpp
 * @brief	O`bvǗNX̓̒`s܂
 */

#include "compiler.h"
#include "externalchipmanager.h"
#include <algorithm>
#include "externalopl3.h"
#include "externalopm.h"
#include "externalopna.h"

/*! B̃CX^Xł */
CExternalChipManager CExternalChipManager::sm_instance;

/**
 * RXgN^
 */
CExternalChipManager::CExternalChipManager()
{
}

/**
 * 
 */
void CExternalChipManager::Initialize()
{
}

/**
 * 
 */
void CExternalChipManager::Deinitialize()
{
	std::vector<IExternalChip*>::iterator it = m_chips.begin();
	while (it != m_chips.end())
	{
		IExternalChip* pChip = *it;
		it = m_chips.erase(it);

		pChip->Reset();
		delete pChip;
	}

	m_c86ctl.Deinitialize();
	m_scci.Deinitialize();
}

/**
 * `bvm
 * @param[in] nChipType `bv ^Cv
 * @param[in] nClock `bv NbN
 * @return CX^X
 */
IExternalChip* CExternalChipManager::GetInterface(IExternalChip::ChipType nChipType, UINT nClock)
{
	IExternalChip* pChip = GetInterfaceInner(nChipType, nClock);
	if (pChip == NULL)
	{
		switch (nChipType)
		{
			case IExternalChip::kAY8910:
				pChip = GetInterface(IExternalChip::kYM2203, nClock);
				break;

			case IExternalChip::kYM2203:
				pChip = GetInterface(IExternalChip::kYMF288, nClock * 2);
				break;

			case IExternalChip::kYMF288:
				pChip = GetInterface(IExternalChip::kYM2608, nClock);
				break;

			case IExternalChip::kYM3438:
				pChip = GetInterface(IExternalChip::kYMF288, nClock);
				break;

			case IExternalChip::kY8950:
				pChip = GetInterface(IExternalChip::kYM3812, nClock);
				break;

			case IExternalChip::kYM3812:
				pChip = GetInterface(IExternalChip::kYMF262, nClock * 4);
				break;

			default:
				break;
		}
	}
	return pChip;
}

/**
 * `bvm (Inner)
 * @param[in] nChipType `bv ^Cv
 * @param[in] nClock `bv NbN
 * @return CX^X
 */
IExternalChip* CExternalChipManager::GetInterfaceInner(IExternalChip::ChipType nChipType, UINT nClock)
{
	IExternalChip* pChip = NULL;

	/* G.I.M.I.C / C86BOX */
	if (pChip == NULL)
	{
		pChip = m_c86ctl.GetInterface(nChipType, nClock);
	}

	/* SPFM Light */
	if (pChip == NULL)
	{
		pChip = m_scci.GetInterface(nChipType, nClock);
	}

	/* bsO */
	if (pChip)
	{
		switch (nChipType)
		{
			case IExternalChip::kAY8910:
				pChip = new CExternalPsg(pChip);
				break;

			case IExternalChip::kYM2203:
			case IExternalChip::kYM2608:
			case IExternalChip::kYM3438:
			case IExternalChip::kYMF288:
				pChip = new CExternalOpna(pChip);
				break;

			case IExternalChip::kYM3812:
			case IExternalChip::kYMF262:
			case IExternalChip::kY8950:
				pChip = new CExternalOpl3(pChip);
				break;

			case IExternalChip::kYM2151:
				pChip = new CExternalOpm(pChip);
				break;

			default:
				break;
		}
	}
	if (pChip)
	{
		m_chips.push_back(pChip);
	}
	return pChip;
}

/**
 * `bv
 * @param[in] pChip `bv
 */
void CExternalChipManager::Release(IExternalChip* pChip)
{
	std::vector<IExternalChip*>::iterator it = std::find(m_chips.begin(), m_chips.end(), pChip);
	if (it != m_chips.end())
	{
		m_chips.erase(it);
		pChip->Reset();
		delete pChip;
	}
}

/**
 * Zbg
 */
void CExternalChipManager::Reset()
{
	for (std::vector<IExternalChip*>::iterator it = m_chips.begin(); it != m_chips.end(); ++it)
	{
		(*it)->Reset();
	}
}

/**
 * ~[g
 * @param[in] bMute ~[g
 */
void CExternalChipManager::Mute(bool bMute)
{
	for (std::vector<IExternalChip*>::iterator it = m_chips.begin(); it != m_chips.end(); ++it)
	{
		(*it)->Message(IExternalChip::kMute, static_cast<INTPTR>(bMute));
	}
}
