/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
this.version = "1.0.2";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.aniboom.com/";
	this.ID = "aniboom.com";
	this.caption = "Aniboom";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "http://www.aniboom.com/animations/player/handlers/animationDetails.aspx?mode=&movieid=%1";
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get the video title
	result.title = copyBetween(html, "<meta name=\"title\" content=\"", "\" />");
	// video URL
	var videoId = copyBetween(html, 'animationId=', '"');
	// download the file with the real url
	var info = http.downloadWebpage(strFormat(URL_GET_FLV, videoId));
	// get the video url
	result.URL = cleanUrl(copyBetween(info, "flv=", "&"));
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x02,0x04,0x49,0x44,0x41,0x54,0x78,0xda,0x95,0x93,0x4f,0x48,0x1b,
		0x51,0x10,0xc6,0x9f,0x7a,0x08,0x34,0x14,0x11,0x85,0x5e,0x7b,0xf1,0xd2,0x73,0x0e,
		0x9e,0x3c,0x48,0xf1,0x20,0xde,0x3c,0xf5,0xd4,0x52,0xd4,0x5a,0xa5,0x1e,0xc4,0x7a,
		0x28,0x14,0x11,0x04,0xa9,0x2d,0xb9,0xd4,0x5e,0xec,0x21,0x4a,0xb5,0x15,0x85,0x0a,
		0x29,0xc6,0x6c,0xd4,0xd2,0xee,0xda,0x64,0x4d,0xfc,0x43,0x6a,0x24,0xa5,0x98,0x6c,
		0x0d,0x31,0xa9,0x21,0x09,0xa9,0x09,0x62,0x74,0x93,0xaf,0x6f,0x16,0x79,0x41,0x70,
		0x8b,0x1d,0xf8,0xd8,0xd9,0x99,0x79,0xbf,0x19,0x06,0x86,0xc1,0xc4,0x4a,0xe5,0x32,
		0x4e,0xce,0x4b,0x24,0xc3,0x37,0x33,0x53,0xc0,0x84,0xba,0x87,0x9b,0xb3,0x1b,0x24,
		0xf2,0xff,0x0f,0xa0,0x25,0x8f,0xd0,0x34,0xff,0x0d,0x55,0xd3,0x5e,0x12,0xf9,0x14,
		0xbb,0x3e,0xc0,0xfe,0x79,0x03,0xf5,0x1f,0xfc,0x60,0x53,0x5e,0x12,0xf9,0x14,0xbb,
		0x1e,0x40,0x4b,0x65,0xd0,0x22,0xed,0x5d,0x3c,0x16,0xa2,0x18,0xe5,0xfe,0x0d,0xd0,
		0xf5,0x12,0xec,0xf2,0x8e,0xe8,0x5e,0xf7,0xde,0x4f,0x12,0x53,0x50,0x8e,0x6a,0x4c,
		0x01,0x3f,0xe3,0x49,0xb4,0xaf,0x86,0x45,0xd7,0x6e,0x6f,0x84,0x24,0xfe,0x29,0x47,
		0x35,0xa6,0x00,0x87,0xe7,0x8b,0xe8,0xd8,0xc0,0x3b,0x86,0xf6,0xa3,0x24,0xf2,0xc5,
		0x44,0x54,0x73,0x25,0x20,0x1c,0x3d,0x40,0xdb,0xe2,0x2e,0xd8,0xab,0xaf,0x60,0x6f,
		0x14,0x3c,0x51,0x22,0x38,0xce,0xe7,0x91,0x2f,0x14,0xf0,0x34,0xf0,0x0b,0xd5,0xaf,
		0x15,0xb0,0xe7,0x6b,0x68,0x9b,0x09,0x22,0x1c,0x39,0xb8,0x0c,0x28,0x9e,0x9d,0xc1,
		0xb1,0xea,0x87,0xb5,0xd7,0x03,0xf6,0xc0,0x05,0xd6,0xeb,0xc6,0x3d,0x47,0x10,0x0b,
		0x2b,0x3e,0xec,0xc7,0x92,0xf0,0x6b,0x09,0xdc,0x1e,0x55,0x8c,0x9c,0xb5,0x47,0x82,
		0x63,0x49,0xa5,0x37,0x15,0x40,0x2c,0x91,0x44,0x87,0x93,0x6f,0xbe,0x73,0x99,0x8a,
		0x84,0x6e,0xf5,0xaf,0xa1,0xf5,0xc5,0x3a,0x86,0x26,0x25,0xb4,0xda,0x03,0x22,0xde,
		0x31,0xb1,0x8d,0xd8,0xc5,0x2e,0x98,0xae,0xeb,0x70,0x45,0x12,0xb0,0x4e,0xf9,0xc0,
		0xc6,0xf9,0xf8,0x03,0x7c,0x8a,0x87,0x15,0x50,0x15,0xd7,0x8d,0x6e,0x09,0xb5,0x8f,
		0x3d,0x22,0x66,0x7d,0x24,0xc1,0xb5,0x15,0x03,0xbd,0x65,0xe9,0x4c,0x06,0xcd,0xcb,
		0x21,0x63,0x49,0x35,0xd3,0x3e,0x0c,0xca,0x21,0x6c,0x6a,0x29,0x8c,0x2d,0x04,0x60,
		0x1b,0x96,0x51,0xd7,0xb7,0x82,0x6a,0x01,0xac,0xa8,0x79,0x4c,0x45,0x3a,0x9d,0x01,
		0x8b,0xfe,0x4e,0xc1,0xf2,0x4e,0x35,0x00,0x8d,0x1f,0xb7,0xe1,0x54,0xb7,0xc4,0x82,
		0xb2,0x7f,0x0a,0x98,0x74,0xaa,0xb8,0xff,0x36,0x88,0x3b,0xcf,0x64,0x58,0x3a,0xdd,
		0x02,0x60,0xe9,0x72,0xe3,0x87,0x76,0x08,0x16,0x4f,0x67,0x61,0xfb,0xf4,0xdd,0x38,
		0x9a,0xa1,0xa5,0x75,0x64,0x73,0x39,0x00,0x15,0x2b,0xf3,0x4b,0xcc,0x1d,0x17,0xa0,
		0x6c,0x86,0xf0,0x72,0x4e,0xc6,0xdd,0x71,0x7e,0x60,0x3d,0x1e,0xd8,0x46,0xf8,0x7d,
		0xc4,0x8f,0xc0,0xa8,0xe0,0x54,0xe7,0x67,0xcb,0x75,0xce,0x65,0x62,0x02,0x56,0xa4,
		0x13,0x2f,0xea,0x38,0xe5,0x5f,0xfa,0xff,0x0b,0xc7,0x4f,0x45,0x1f,0xa1,0xc5,0xc8,
		0xb6,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}