// License: GPL

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.0a";
	this.author = "anonymous";
	this.website = "http://www.ardmediathek.de/";
	this.ID = "ardmediathek.de";
	this.caption = "ARD Mediathek";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	var result = new VideoDefinition();

	var http = new Http();
	var site = http.downloadWebpage(url);
	var title = copyBetween(site, '<title>', '</title>');
	result.title = trim_title(title.toString());

	print(url);
	print('============');
	print('<title>'+title+'</title>');

	var s = /mediaCollection\.addMediaStream\((\d),\s*(\d),\s*"(.*?)",\s*"(.*?)"\)/g;
	var e;
	var options = [];
	var i = 1;
	var bestquality = -1;
	var best;
	// Loop over all linked streams and find the one with the best quality.
	// Quality values seem to be 0, 1 and 2 where 2 is the best quality.
	// Note: 'l' in the url is not 'low' but 'large' (quality 2).
	while (e = s.exec(site)) {
		var o = {
			quality: e[2],
			tcUrl: e[3],
			playpath: e[4],
		};
		print(i + ' quality: '+o.quality+' tcUrl: '+o.tcUrl+' playpath: '+o.playpath);
		var type = o.tcUrl.substr(0,4);
		if (type == 'rtmp') {
			options.push(o);
			if (o.quality > bestquality) {
				bestquality = o.quality;
				best = o;
			}
		}
		i++;
	}
	if (best == null) return null;
	result.URL = best.tcUrl + best.playpath;
	result.rtmpPlayPath = best.playpath;
	result.extension = '.mp4';
	print('url: '+result.URL);
	print('playpath: '+result.rtmpPlayPath);
	return result;
}

/**
 * Formats the title a little nicer.
 *
 * If the title does not match the expected format, it does nothing and returns
 * the original string.
 */
function trim_title(t) {
	t = t.replace(/^ARD Mediathek:\s*/, '');	// remove website name at the beginning
	t = t.replace(/\s*\|[ a-z]{0,40}$/i, '');   // remove channel name at the end (separated by '|' symbol)
	t = t.replace(/\s*-\s*([a-z]{2})[a-z]*,\s*(\d{1,2})\.(\d{1,2})\.(\d{4})$/i, ' ($1 $2.$3.$4)'); // reformat the date
	return t;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x00,0x06,0x62,0x4b,0x47,0x44,0x00,0xfe,0x00,0xfe,0x00,0xfe,0xeb,
		0x18,0xd4,0x82,0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x00,0x48,0x00,
		0x00,0x00,0x48,0x00,0x46,0xc9,0x6b,0x3e,0x00,0x00,0x00,0x09,0x76,0x70,0x41,0x67,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x5c,0xc6,0xad,0xc3,0x00,0x00,0x02,
		0x4a,0x49,0x44,0x41,0x54,0x38,0xcb,0x85,0x93,0x6b,0x48,0x13,0x60,0x18,0x85,0x1f,
		0x6d,0xb0,0xa5,0x78,0x8b,0x22,0x99,0xfd,0x59,0x5a,0x22,0x3a,0x53,0x0a,0x9c,0xa2,
		0xdd,0x17,0xa5,0x19,0x8a,0x41,0x38,0x28,0x43,0x33,0x28,0x28,0x31,0x8b,0x02,0x85,
		0xc8,0xf2,0x87,0x10,0x43,0xba,0x52,0x09,0x41,0x84,0x06,0x5d,0xb0,0x88,0x34,0x2f,
		0xe5,0xcc,0x34,0x2f,0x69,0x3a,0x50,0x31,0xcb,0xc4,0x98,0x8e,0x62,0x0c,0x0c,0x73,
		0x4c,0x7d,0xfb,0x31,0x98,0xcd,0xeb,0x81,0xef,0xcf,0xfb,0x9d,0x73,0xbe,0x17,0xce,
		0xf9,0xbc,0x58,0x04,0xb9,0xe7,0x6f,0xc8,0xfb,0xe6,0x1e,0x7e,0xd9,0x27,0x70,0x3a,
		0xa7,0x51,0xaf,0x0b,0x62,0x57,0xe2,0x16,0x1e,0x5c,0x3f,0xeb,0x35,0x9f,0xeb,0x31,
		0x38,0x77,0xf9,0xbe,0xdc,0x79,0x54,0x4d,0x4c,0xd4,0x46,0xd2,0xf7,0xeb,0x88,0x8e,
		0xd0,0x00,0xd0,0xdb,0x3f,0x4c,0x4d,0x43,0x27,0xad,0xdd,0x83,0xe4,0x1a,0xf6,0x71,
		0xb3,0xe4,0xd4,0x02,0x23,0x0e,0x1e,0xbb,0x22,0x6a,0xad,0x41,0xaa,0xdf,0x75,0xca,
		0x52,0xa8,0x35,0x75,0x89,0x5a,0x6b,0x10,0x7d,0x66,0x91,0x30,0xff,0xe5,0xc0,0x88,
		0x23,0x32,0x34,0x32,0xb6,0xa8,0xb0,0xa7,0x6f,0x58,0x8a,0x8d,0x95,0x62,0xb1,0xda,
		0xc4,0x62,0xb5,0x89,0x5a,0x6b,0x90,0x33,0x85,0x77,0xe7,0x4c,0x54,0x9a,0x74,0xa9,
		0x35,0x75,0x79,0x88,0x2c,0x56,0x9b,0x94,0x57,0xbc,0x15,0x7d,0x66,0x91,0xa8,0x34,
		0xe9,0x42,0xd0,0x1e,0x69,0x6c,0x31,0x8b,0x88,0x48,0x63,0x8b,0xd9,0x35,0x03,0x14,
		0xd9,0xf9,0x65,0x32,0x3c,0x32,0x86,0x7e,0x7b,0x2c,0x93,0x7f,0x1d,0xbc,0x69,0xe8,
		0xe0,0xc9,0xcb,0x26,0x1a,0x3e,0xf6,0x62,0x1f,0xff,0x0d,0xb3,0x80,0x37,0xa0,0x54,
		0xa2,0x50,0xac,0x02,0x60,0x47,0x7c,0x14,0x49,0xba,0x48,0xd6,0xa7,0x24,0x88,0xa2,
		0xa9,0xd5,0x4c,0xde,0xc9,0x34,0x00,0xd2,0x72,0xae,0x51,0xf7,0xa2,0xd1,0xb5,0x96,
		0x8f,0x12,0x94,0x4a,0x96,0xc2,0x21,0x7d,0x1c,0xa5,0xb7,0x9f,0xe1,0xfd,0xd3,0x6a,
		0x23,0x3c,0x34,0xc4,0x7d,0x91,0x71,0xf4,0x00,0xa5,0xc6,0x3c,0x54,0x81,0xfe,0x2c,
		0x87,0xf0,0xd0,0x10,0xfe,0x4c,0x4e,0xa1,0x00,0x98,0x99,0x99,0x05,0xe0,0xe9,0xbd,
		0x4b,0x04,0xf8,0xf9,0x32,0xf0,0x75,0x94,0x8b,0x57,0x1f,0xb2,0x12,0x44,0x04,0xef,
		0xb5,0x6b,0xfc,0x19,0xfa,0x31,0x06,0x40,0x80,0x9f,0x2f,0x00,0x53,0x0e,0xe7,0x8a,
		0xe2,0xef,0x23,0xe3,0xf8,0xf9,0xae,0xc6,0x7b,0x67,0x7c,0x14,0xaf,0xea,0xda,0x96,
		0x67,0x3b,0x1c,0xae,0xf3,0x1f,0x5e,0xd7,0x77,0x10,0x17,0xbb,0x79,0x2e,0xc6,0xe6,
		0xf6,0x3e,0x77,0x84,0xdd,0xe6,0x6f,0x42,0x70,0xb2,0xa0,0x4c,0x14,0x82,0x93,0x25,
		0x7a,0xf7,0x69,0x29,0x36,0x56,0x8a,0xcd,0x3e,0x21,0x22,0x22,0xad,0x9f,0xfb,0xdd,
		0x31,0xba,0xbb,0xaf,0xd6,0x1a,0xc4,0x62,0xb5,0xb9,0x0d,0xc2,0x74,0x39,0x92,0x9d,
		0x5f,0x26,0xb5,0xa6,0x2e,0x71,0x4e,0xcf,0x78,0xf4,0x63,0xc3,0xd6,0x2c,0x39,0x9e,
		0x67,0xf4,0x6c,0xa3,0x2e,0xb5,0x40,0x42,0xb7,0x65,0x79,0x6c,0x32,0x1f,0xcd,0xed,
		0x7d,0x12,0xa6,0xcb,0x11,0x5d,0x6a,0x81,0x5b,0xec,0xf1,0x29,0xb2,0xf3,0xcb,0xa4,
		0xa2,0xca,0xc4,0xde,0xa4,0x18,0x32,0x52,0x12,0xd8,0xa4,0x71,0xc5,0x3b,0x30,0x34,
		0x4a,0x55,0xcd,0x27,0xea,0x3f,0x7c,0xe1,0x70,0x4a,0x02,0x8f,0x6f,0x5d,0xf0,0x5a,
		0xd4,0xc0,0xdd,0x85,0x13,0x25,0xd2,0xd6,0x3d,0x88,0xcd,0x3e,0x01,0x40,0xa0,0x8f,
		0x8a,0xf8,0xb8,0x48,0x9e,0x97,0x17,0x2e,0xe0,0xff,0x03,0x73,0xaa,0x6f,0xef,0x40,
		0xb8,0x7e,0xa1,0x00,0x00,0x00,0x25,0x74,0x45,0x58,0x74,0x64,0x61,0x74,0x65,0x3a,
		0x63,0x72,0x65,0x61,0x74,0x65,0x00,0x32,0x30,0x31,0x32,0x2d,0x30,0x31,0x2d,0x32,
		0x36,0x54,0x30,0x32,0x3a,0x31,0x36,0x3a,0x32,0x34,0x2b,0x30,0x31,0x3a,0x30,0x30,
		0xa6,0x7c,0xb1,0xf3,0x00,0x00,0x00,0x25,0x74,0x45,0x58,0x74,0x64,0x61,0x74,0x65,
		0x3a,0x6d,0x6f,0x64,0x69,0x66,0x79,0x00,0x32,0x30,0x31,0x30,0x2d,0x30,0x31,0x2d,
		0x32,0x30,0x54,0x30,0x32,0x3a,0x32,0x31,0x3a,0x30,0x35,0x2b,0x30,0x31,0x3a,0x30,
		0x30,0x35,0x8c,0xd8,0x9a,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,
		0x82);
}
