/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "2.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.badjojo.com/";
	this.ID = "badjojo.com";
	this.caption = "BadJojo";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_INFO = "http://www.badjojo.com/noheader.php?action=getVideoStyle&videoId=%1";
	// init result
	var result = new VideoDefinition();
	// get videoId
	var videoId = copyBetween(url, ".com/", "/");
	// download information
	var http = new Http();
	var info = http.downloadWebpage(strFormat(URL_GET_INFO, videoId));
	// get video info
	result.title = copyBetween(info, "Title:", "Video ID:");
	result.URL = copyBetween(info, "Video file:", "*/");
	// return the video information
	return result;
}

function searchVideos(keyWord, pageIndex)
{
	const URL_SEARCH = "http://www.badjojo.com/?q=%1&p=%2";
	const HTML_SEARCH_START = '<div class="results_body" >';
	const HTML_SEARCH_FINISH = '<div class="pagination">';
	const HTML_SEARCH_START_ITEM = '<div class="thumbSearch">';
	const HTML_SEARCH_END_ITEM = '</div> <!-- // end results_body -->';
	// replace all spaces for "+"
	keyWord = strReplace(keyWord, " ", "+");
	// init search results object
	var searchResults = new SearchResults();
	// init http object
	var http = new Http();
	var html = http.downloadWebpage(strFormat(URL_SEARCH, keyWord, pageIndex));
	// get the search summary -- No summary --
	searchResults.setSummary("");
	// get results html block
	var htmlResults = copyBetween(html, HTML_SEARCH_START, HTML_SEARCH_FINISH);
	// if we found some results then...
	if (htmlResults != "")
	{
		var block = "";
		// iterate over results
		while ((block = copyBetween(htmlResults, HTML_SEARCH_START_ITEM, HTML_SEARCH_END_ITEM)) != "")
		{
			parseResultItem(searchResults, block);
			htmlResults = strRemove(htmlResults, 0, block.toString().length);
		}
	}
	// return search results
	return searchResults;
}

function parseResultItem(searchResults, html)
{
	var videoUrl, imageUrl, title, description, duration, rating;
	// get info from html block
	videoUrl = copyBetween(html, '<a  href="', '"');
	imageUrl = copyBetween(html, '<img src="', '"');
	title = copyBetween(html, '<div class="title">', '</div>') + "~";
	title = copyBetween(title, ')">', "~");
	description = copyBetween(html, '<div class="url">', '</div>');
	duration = convertToSeconds(copyBetween(html, '<span>', '</span>'));
	rating = 0.0;
	// add to results list
	searchResults.addSearchResult(videoUrl, imageUrl, title, description, duration, rating);
}

function convertToSeconds(text)
{
	// how many ":" exists?
	var count = getTokenCount(text, ":");
	// get mins and seconds
	var h = new Number(h = count == 3 ? getToken(text, ":", 0) * 3600 : 0);
	var m = new Number(getToken(text, ":", count - 2) * 60);
	var s = new Number(getToken(text, ":", count - 1));
	// convert h:m:s to seconds
	return h + m + s;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x0e,0x08,0x03,0x00,0x00,0x00,0x28,0x96,0xdd,
		0xe3,0x00,0x00,0x00,0x7b,0x50,0x4c,0x54,0x45,0x11,0x54,0x65,0x15,0x53,0x68,0x13,
		0x54,0x66,0x15,0x54,0x65,0x16,0x55,0x67,0x13,0x54,0x68,0x15,0x54,0x66,0x12,0x55,
		0x66,0x16,0x54,0x69,0x14,0x55,0x6b,0x13,0x54,0x6a,0x14,0x56,0x66,0x12,0x54,0x6a,
		0x12,0x55,0x65,0x14,0x55,0x69,0x13,0x56,0x69,0x16,0x53,0x66,0x16,0x52,0x6a,0x17,
		0x54,0x69,0x15,0x53,0x6a,0x16,0x53,0x68,0x16,0x53,0x65,0x14,0x55,0x67,0x12,0x55,
		0x68,0xff,0xfe,0xff,0xff,0xff,0xff,0x15,0x52,0x67,0x13,0x55,0x6b,0x13,0x55,0x65,
		0xfe,0xfe,0xff,0xfe,0xff,0xff,0x13,0x56,0x67,0x17,0x53,0x6b,0x11,0x53,0x69,0x12,
		0x53,0x67,0x17,0x54,0x66,0x12,0x53,0x65,0x16,0x54,0x6b,0x14,0x53,0x65,0x15,0x56,
		0x68,0x15,0x52,0x65,0x69,0x33,0x4a,0x28,0x00,0x00,0x00,0x9a,0x49,0x44,0x41,0x54,
		0x08,0x1d,0x05,0xc1,0x09,0x62,0xc2,0x30,0x0c,0x04,0x40,0xad,0xf0,0xca,0x8e,0xea,
		0x18,0x43,0x52,0x07,0x95,0x42,0xcf,0xb4,0xfc,0xff,0x85,0xcc,0x88,0x40,0x0f,0x89,
		0x96,0x0b,0x26,0xf5,0x17,0x81,0x13,0xa4,0x5b,0xd5,0xd9,0x9b,0x8b,0xf2,0xd8,0x6b,
		0xe3,0xc9,0xce,0x58,0xdc,0xc4,0xd0,0x57,0xa6,0x57,0x3a,0x06,0xe6,0x49,0x12,0x2b,
		0x7d,0x83,0x8c,0x8c,0xb3,0x41,0xc8,0x96,0xb6,0x4b,0xc4,0xdb,0x70,0xab,0x45,0xcc,
		0xd9,0x11,0x57,0x8b,0xcc,0x93,0x65,0x79,0x87,0x53,0x6f,0x71,0x57,0x14,0x1a,0x44,
		0x3f,0x92,0xf7,0xd0,0x25,0x3e,0xbf,0x8e,0x80,0xac,0xce,0xcc,0xb8,0xc4,0xcc,0x52,
		0xf9,0x2d,0x8d,0xe5,0xe7,0x97,0x63,0x6a,0xfb,0x5f,0x2f,0x90,0xe5,0xff,0xd1,0xac,
		0x71,0x6d,0xf3,0x4e,0x42,0xc8,0x1d,0x0b,0x3b,0x0e,0x57,0xef,0x19,0x62,0x1c,0xdc,
		0x54,0x57,0x82,0xc9,0xf5,0x09,0x43,0x26,0x08,0xcd,0x96,0x66,0xa4,0xb3,0x00,0x00,
		0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
