/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.4";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.caught-on-tape.tv/";
	this.ID = ".caught-on-tape.tv";
	this.caption = "Caught On Tape";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// video information
	var result = new VideoDefinition();
	// download xml
	var http = new Http();
	var html = http.downloadWebpageEx(url, false);
	// check if is an embeded youtube video
	if (strIndexOf(html, "http://www.youtube.com/") != -1)
		return getVideoFromYoutube(html);
	else if (strIndexOf(html, "http://www.veoh.com/") != -1)
		return getVideoFromVeoh(html);
	else if (strIndexOf(html, "http://www.dailymotion.com/") != -1)
		return getVideoFromDailymotion(html);
	else
		return new VideoDefinition();
}

function getVideoFromYoutube(html)
{
	// check if youtube plugin is installed
	if (isPluginInstalled("youtube") == true)
	{
		var youtubeUrl = copyBetween(html, 'SWFObject("', '&amp;');
		return executePlugin("youtube", youtubeUrl);
	}
	else // youtube plugin not installed
		return new VideoDefinition();
}

function getVideoFromVeoh(html)
{
	// check if youtube plugin is installed
	if (isPluginInstalled("veoh") == true)
	{
		var veohUrl = copyBetween(html, 'SWFObject("', '"');
		veohUrl = strReplace(veohUrl, "&amp;", "&");
		return executePlugin("veoh", veohUrl);
	}
	else // youtube plugin not installed
		return new VideoDefinition();
}

function getVideoFromDailymotion(html)
{
	const VIDEO_URL = "http://www.dailymotion.com/video/";
	// check if youtube plugin is installed
	if (isPluginInstalled("dailymotion") == true)
	{
		var videoId = copyBetween(html, 'SWFObject("', '"');
		videoId = copyBetween(videoId, "swf/", "?");
		return executePlugin("dailymotion", VIDEO_URL + videoId);
	}
	else // youtube plugin not installed
		return new VideoDefinition();
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x02,0x26,0x49,0x44,0x41,0x54,0x78,0xda,0x95,0x93,0xcb,0x6e,0xda,
		0x50,0x10,0x86,0xfb,0x02,0xbd,0xa8,0x2f,0xd0,0x3e,0x4d,0x9f,0xa2,0x9b,0x4a,0x55,
		0x16,0x5d,0x54,0x7d,0x8c,0x4a,0x59,0x77,0x41,0xd5,0x4d,0x53,0x12,0x12,0x15,0x62,
		0x63,0x73,0x6d,0xa9,0x13,0x9b,0x26,0x80,0x03,0x46,0x02,0x1c,0x40,0xa4,0x12,0x81,
		0x02,0x29,0xe6,0x1e,0x41,0xb8,0xfd,0x50,0xcf,0xa1,0x18,0x59,0x64,0x53,0x4b,0xbf,
		0x46,0xf6,0x99,0xf9,0xfc,0x9f,0x99,0x73,0x1e,0x2c,0x97,0x4b,0xac,0x45,0x4f,0xbf,
		0xdf,0x47,0x26,0x93,0x85,0xf4,0x43,0x42,0x28,0xf4,0x0d,0x91,0x48,0x04,0x69,0x4d,
		0x43,0xa7,0xd3,0xa5,0x65,0xca,0xb3,0xc9,0x02,0x4c,0x26,0x13,0xe4,0xf3,0x79,0x88,
		0x82,0x08,0x9f,0xcf,0x0f,0x45,0x89,0x22,0x95,0xd2,0xcc,0xa8,0x98,0xef,0x3e,0xf0,
		0x3c,0x8f,0x54,0x32,0x49,0x79,0xdb,0x80,0xf1,0x78,0x8c,0xd3,0x53,0x19,0x1c,0xc7,
		0x23,0x69,0x26,0xdd,0xf6,0xba,0xe8,0x07,0xdf,0xa3,0xb5,0xfb,0x62,0x15,0x5b,0x2d,
		0xa8,0xea,0x05,0x5b,0x0f,0x06,0x83,0x94,0xbf,0x01,0xcc,0xe7,0x73,0x14,0x0a,0x05,
		0x78,0xbd,0x82,0x69,0xb3,0x83,0xc1,0x60,0x80,0x81,0xc6,0xa3,0xfa,0xf2,0x29,0x53,
		0x7d,0xe7,0x11,0xee,0x8c,0x32,0x83,0x34,0x1a,0x0d,0xd3,0x89,0x17,0xf2,0xc9,0x09,
		0xa8,0x8e,0x01,0x7a,0xbd,0x1e,0xb3,0x5c,0xa9,0x54,0x31,0x1a,0x8d,0x30,0x1c,0x0e,
		0x71,0x57,0xd3,0x51,0x7f,0xfb,0x9c,0x00,0xe4,0x82,0xc0,0x04,0x60,0x2a,0x95,0x4a,
		0x70,0x7f,0x75,0xe3,0xa6,0x51,0x5f,0x01,0x8a,0xc5,0x22,0x01,0x68,0x6f,0x96,0xc8,
		0x22,0xc1,0xc6,0xea,0x3e,0x73,0xd4,0xed,0x76,0xd1,0x6e,0xb7,0x19,0xc0,0x30,0x0c,
		0x08,0x82,0x80,0xef,0xe1,0xf0,0x0a,0x70,0x76,0x76,0x8e,0x58,0x2c,0x8e,0xd9,0x6c,
		0x46,0xb6,0x58,0x9c,0x4e,0xa7,0xb8,0x95,0x1d,0x68,0x7f,0x7a,0x8d,0x61,0x2e,0x4c,
		0x93,0xb1,0x41,0x64,0x59,0xc1,0xe1,0xfe,0xc1,0x0a,0x20,0x49,0x12,0xb2,0xd9,0x2c,
		0xe8,0x59,0x2c,0x16,0x14,0xa8,0xc8,0xea,0x41,0xe3,0xdd,0x33,0x8c,0xdb,0x35,0xd0,
		0x56,0x69,0x2b,0xeb,0x86,0x3a,0x3f,0xef,0xad,0x00,0xd1,0x68,0x14,0xf1,0x78,0xc2,
		0x36,0x1a,0xfa,0x3b,0x15,0xd7,0x76,0x9e,0xb0,0x26,0xce,0xeb,0x19,0x72,0x41,0x00,
		0xcb,0x81,0x73,0xef,0x1f,0x20,0x97,0xd3,0xe1,0xf7,0x07,0xee,0x05,0x50,0xb1,0xf1,
		0xe6,0x21,0x16,0x37,0xba,0xad,0x17,0x34,0x31,0x81,0xe3,0x36,0x53,0x10,0x45,0x1f,
		0x9a,0xcd,0xa6,0x0d,0xf0,0xe7,0xd5,0x63,0x2a,0xde,0x02,0x5c,0x5d,0xfd,0x82,0xeb,
		0xc0,0x85,0xca,0xf5,0xf5,0xe6,0x1c,0x68,0x5a,0x0a,0x82,0x20,0x52,0xf3,0xe8,0x23,
		0x75,0xff,0x5e,0x00,0x4d,0x80,0xce,0xc1,0x47,0x87,0x83,0x72,0xed,0x27,0x31,0x14,
		0x0a,0xb1,0x93,0xa6,0xeb,0xfa,0x1a,0x60,0x41,0xd0,0x2c,0x42,0xd3,0xd2,0x6c,0xdd,
		0xe3,0x39,0xc6,0x91,0xcb,0x85,0xfc,0x65,0x7e,0x03,0x58,0x43,0x12,0xb1,0x38,0x4b,
		0x48,0xff,0x94,0xa0,0xf3,0x1f,0x2c,0x89,0x1e,0x37,0x9c,0x5f,0x9c,0x10,0x39,0x8e,
		0x59,0x57,0x55,0x15,0x4a,0xf4,0x9c,0x41,0xb6,0x6e,0x23,0xd9,0x54,0x64,0x19,0xc7,
		0x26,0xc8,0x75,0x78,0xc4,0x14,0x08,0x04,0xf0,0xbb,0x5a,0xb1,0x6e,0x6b,0xb9,0xbc,
		0x81,0x30,0xc0,0x7f,0xca,0x82,0xc4,0x12,0x2a,0xfe,0x02,0xad,0x9a,0x7b,0xf3,0xd4,
		0x38,0xd1,0x2c,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
