/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "crapmaster & Xesc & Technology 2014";
	this.website = "http://www.homemade-voyeur.com";
	this.ID = "homemade-voyeur.com";
	this.caption = "homemade voyeur";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// video information
	var result = new VideoDefinition();

	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);

	// get video title
	result.title = copyBetween(html, '<h2 class="he2"><span>', '</span></h2>');

	// get the video  url
	var videoUrl = copyBetween(html, "var playlist = [ { url: '", "' } ]");

	result.URL=cleanUrl(videoUrl);

	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x20,0x08,0x06,0x00,0x00,0x00,0x73,0x7a,0x7a,
		0xf4,0x00,0x00,0x00,0x01,0x73,0x52,0x47,0x42,0x00,0xae,0xce,0x1c,0xe9,0x00,0x00,
		0x00,0x06,0x62,0x4b,0x47,0x44,0x00,0xff,0x00,0xff,0x00,0xff,0xa0,0xbd,0xa7,0x93,
		0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,0x13,
		0x01,0x00,0x9a,0x9c,0x18,0x00,0x00,0x00,0x07,0x74,0x49,0x4d,0x45,0x07,0xdb,0x07,
		0x0b,0x13,0x20,0x09,0x23,0x34,0x9c,0x72,0x00,0x00,0x08,0x24,0x49,0x44,0x41,0x54,
		0x58,0xc3,0xc5,0x97,0x4b,0x88,0xa4,0x57,0x15,0xc7,0x7f,0xdf,0xb3,0x1e,0x5d,0xd5,
		0x55,0xd5,0xd5,0x55,0xd5,0xd5,0xd3,0x3d,0xe3,0x4c,0x66,0x24,0x89,0x89,0x18,0xf1,
		0x11,0xa3,0x09,0x89,0x48,0x90,0x24,0x42,0x14,0x85,0x6c,0x8c,0x09,0x48,0x16,0x2e,
		0xdc,0x18,0x5d,0x86,0xec,0x5c,0x08,0x09,0x2e,0x14,0x94,0x20,0x42,0x02,0x2e,0x23,
		0x24,0x51,0x92,0x28,0x4a,0x24,0x10,0x02,0xe3,0x44,0xc4,0x49,0xc8,0xf4,0x30,0xe9,
		0xe9,0x77,0x55,0x75,0x57,0xd7,0xfb,0xfb,0xee,0xd3,0xc5,0x57,0x5d,0xd5,0x35,0xdd,
		0xae,0xfd,0xe0,0x50,0xdc,0x7b,0xee,0xb9,0xf7,0x7f,0xcf,0xf9,0x9f,0x73,0x6e,0xc1,
		0xff,0xf9,0x73,0x00,0x5e,0xfa,0xf3,0xfb,0xf6,0xed,0x77,0xdf,0xe7,0xc5,0x67,0x9f,
		0xa6,0x5e,0xc8,0xf2,0xf6,0xe5,0x8f,0x78,0xf1,0x95,0xd7,0x78,0xf6,0xc9,0xc7,0xf9,
		0xda,0x3d,0x97,0xf8,0xc9,0x0b,0xaf,0xb0,0x7f,0xd8,0xe3,0x97,0x3f,0x7d,0x9a,0x4a,
		0x3e,0x0d,0xc0,0xaf,0x5f,0xfd,0x3b,0x8d,0x6e,0xc4,0xf3,0x3f,0xf8,0x26,0x3f,0x7f,
		0xf9,0x0d,0xb2,0xe9,0x14,0x81,0xef,0x01,0xd0,0x3a,0xec,0xf1,0xe0,0x17,0xee,0xe4,
		0x81,0xbb,0x2f,0xce,0x1c,0x76,0x65,0x6d,0x8b,0xd7,0xfe,0x71,0x99,0xc5,0x62,0x9e,
		0x61,0x2c,0xb9,0xb0,0xba,0x8c,0x0f,0x70,0xa1,0x5e,0x26,0xe3,0x41,0xbd,0x90,0xc5,
		0x00,0x9f,0xbd,0x6d,0x15,0x23,0x05,0xb7,0x9f,0xad,0x11,0x02,0x77,0x9f,0x5f,0xe6,
		0x2f,0xef,0x7d,0x40,0x25,0x9f,0x26,0xd6,0x90,0xf2,0xe0,0xe2,0xf2,0x22,0xe7,0x57,
		0x7c,0x62,0x21,0xa9,0x97,0xb2,0xfc,0xe2,0xf7,0x7f,0xc4,0x75,0x3c,0xa2,0x38,0xe6,
		0x5b,0x0f,0x7e,0x89,0xb3,0xe5,0xf9,0x13,0xb7,0xad,0xcc,0xa7,0xd9,0xdd,0xdb,0xe5,
		0xe5,0x57,0xdf,0x24,0x9d,0x4a,0xf1,0xab,0xe7,0x7e,0x84,0x0b,0x20,0xad,0x43,0x18,
		0x86,0xc4,0xc0,0x50,0xc1,0x40,0x68,0xe6,0xd2,0x21,0x03,0x69,0xd0,0xc0,0xa7,0xcf,
		0x9f,0xa5,0x3f,0x8c,0xd8,0xeb,0x0b,0x62,0x03,0x12,0x68,0x75,0x06,0x9c,0x5b,0x39,
		0x83,0xe7,0x07,0x3c,0xf5,0xd8,0x43,0x3c,0xfe,0xd0,0xbd,0x00,0xd4,0xab,0x0b,0xfc,
		0xec,0xa9,0x6f,0xf3,0xa9,0xe5,0x2a,0xca,0x30,0x23,0x2b,0xd5,0x32,0xcf,0x3d,0xf3,
		0x04,0xf9,0x6c,0x9a,0xef,0x3d,0x7c,0x1f,0x0f,0xdc,0x7d,0x31,0x01,0x10,0x2b,0x8b,
		0x36,0x96,0x81,0x82,0x81,0x82,0xa1,0xb2,0x18,0x60,0xa4,0x2c,0x1d,0x05,0xd5,0x5a,
		0x0d,0xa9,0x14,0x6b,0x9b,0x4d,0x84,0x85,0xae,0x84,0x66,0xa7,0x4f,0xbe,0x90,0x23,
		0x36,0xc9,0xed,0xee,0xbb,0xe7,0x0e,0x00,0x3c,0x3f,0x20,0x56,0xc9,0x64,0x6c,0x66,
		0x45,0x19,0x70,0x3c,0x8f,0x5c,0x2e,0xcb,0xfd,0x9f,0xbf,0x13,0x20,0x01,0x10,0x69,
		0x8b,0xb6,0x0e,0x7d,0x01,0x03,0x01,0x43,0x09,0xd6,0x26,0xbf,0x9d,0x08,0xd2,0xb9,
		0x3c,0xf9,0xdc,0x1c,0x57,0x6f,0x6c,0x21,0x80,0xbd,0x8e,0x64,0x10,0x2b,0xc2,0x8c,
		0x33,0x71,0xef,0xd9,0xe5,0x25,0xf2,0xd9,0x90,0x41,0xbf,0x4f,0xeb,0xb0,0x77,0x2a,
		0xe1,0xb4,0x0b,0x8d,0x76,0x8f,0x54,0x98,0xe2,0xe2,0xb9,0xd5,0x29,0x80,0x58,0x59,
		0x2c,0x0e,0xc2,0x01,0xe1,0x80,0xc4,0x1f,0x03,0xb0,0xf4,0x62,0x50,0x0e,0xd4,0x97,
		0x96,0xf8,0xf0,0xfa,0x3a,0x23,0x0d,0x9b,0xcd,0x43,0x1c,0xcf,0xc7,0x38,0x20,0x74,
		0xe2,0xb5,0x4a,0x79,0x81,0x4a,0x79,0x81,0x41,0x14,0xf3,0xc9,0x4e,0x13,0x65,0x12,
		0xdd,0x71,0x01,0xb8,0xbe,0xb1,0x47,0x29,0x9f,0x65,0xa1,0x98,0x07,0x48,0x48,0x18,
		0x1b,0x97,0xde,0x60,0xc0,0x07,0x57,0x37,0xd0,0x06,0xba,0xdd,0x2e,0xca,0x58,0x86,
		0x0a,0xfa,0xc2,0x22,0x1c,0x87,0x33,0x2b,0xab,0x5c,0xbe,0xf2,0x01,0x9d,0x18,0x36,
		0x1b,0x07,0x84,0xe9,0x39,0xfa,0x16,0x3c,0xad,0x91,0x1a,0xb2,0xb9,0x90,0x95,0xda,
		0x22,0x57,0xd7,0xd6,0xf9,0xf8,0xe6,0x0e,0xda,0x05,0xa9,0xf5,0x2d,0x3e,0xf0,0xf8,
		0x78,0x7d,0x93,0x95,0x5a,0x19,0xdf,0x67,0x0a,0x40,0x39,0x3e,0xad,0xd6,0x01,0xaf,
		0xbf,0xf5,0x37,0xac,0xb5,0x08,0x21,0x90,0x52,0x32,0xd4,0x10,0x48,0x8b,0xa7,0x1d,
		0xca,0x4b,0xcb,0x74,0xba,0xef,0xb0,0x77,0xa8,0x68,0xb4,0xbb,0xe4,0xf2,0x05,0xda,
		0x11,0x64,0x8c,0x0b,0x40,0x1a,0x38,0x7f,0x6e,0x05,0xde,0xbd,0xcc,0x8d,0x8d,0x5d,
		0xba,0x12,0xc4,0x58,0x77,0xf4,0xc5,0x16,0xd6,0x6e,0xee,0xf2,0x99,0x4b,0xe7,0x88,
		0x6d,0x52,0x04,0x7c,0x80,0xce,0x30,0x62,0xe9,0xcc,0x19,0xbe,0xfb,0xe4,0x93,0x68,
		0x05,0xdd,0x4e,0x87,0x3f,0xfc,0xee,0xb7,0x74,0x23,0x8d,0x93,0x36,0x80,0x26,0x53,
		0xac,0x60,0x2d,0x7c,0xb2,0xb5,0x4b,0x67,0x30,0xa2,0xb4,0xb4,0x42,0x7b,0x08,0x95,
		0x30,0xe1,0x41,0xac,0x60,0x75,0xb9,0x4e,0x3a,0x95,0x62,0x7d,0x67,0x8f,0x66,0x3b,
		0x66,0x3e,0x1b,0x22,0xed,0x94,0x27,0x07,0x5d,0xc5,0x5e,0x6b,0x9f,0x47,0xbf,0xfe,
		0x55,0x86,0x12,0x08,0x8e,0x48,0xa8,0x2c,0xca,0x58,0x0e,0x06,0x96,0xf6,0x40,0x72,
		0x38,0x94,0x18,0x12,0x0e,0xf4,0xa5,0xa5,0x1b,0x69,0x4c,0x2a,0x47,0x36,0x97,0xe7,
		0xe3,0x6b,0x6b,0xc4,0xd2,0xe0,0xa4,0xf3,0x1c,0x46,0x20,0xa4,0x46,0x48,0x4d,0x3f,
		0x82,0x7a,0xad,0x4a,0xa9,0x30,0x47,0xbb,0x7d,0xc8,0xe6,0x6e,0x03,0xed,0x39,0x13,
		0x3d,0xc0,0x56,0xf3,0x90,0x48,0x2a,0x6a,0xb5,0x1a,0xa3,0x38,0xe1,0xdb,0x38,0x0b,
		0x40,0x1b,0xe8,0x09,0x4b,0x57,0x5a,0x06,0xd2,0x62,0x6d,0x42,0xae,0xbe,0x84,0x9e,
		0xb4,0x8c,0x8c,0x47,0xb1,0x52,0xe7,0xfa,0x47,0x57,0x91,0x78,0x08,0x2f,0x43,0x4f,
		0x80,0xb2,0x0e,0xca,0x3a,0x0c,0x0c,0x14,0x8a,0x25,0xca,0xc5,0x02,0x83,0x28,0xe6,
		0xfa,0xe6,0x0e,0x30,0xd5,0x03,0xdc,0xd8,0xdc,0x25,0x9b,0x0a,0xc9,0xcf,0x17,0x18,
		0x0a,0x83,0xe0,0x98,0x07,0xb4,0xb5,0xf4,0x45,0x22,0x43,0x65,0xa7,0x59,0x20,0x0c,
		0x03,0x61,0xe9,0x09,0xcb,0x7c,0xfd,0x1c,0xbb,0xeb,0xd7,0xd0,0x6e,0xc0,0x50,0xbb,
		0xf4,0xc4,0x94,0xe1,0x32,0x36,0x78,0xe9,0x90,0x5a,0xad,0x86,0x16,0x31,0x9f,0xdc,
		0xdc,0x24,0x3e,0x96,0x01,0xd2,0x81,0xb5,0x9b,0x9b,0x54,0x16,0x4a,0x04,0x29,0x37,
		0x99,0x37,0x63,0x0e,0x08,0xed,0x60,0xad,0xc3,0x50,0x82,0xd1,0x10,0x49,0xb0,0xe3,
		0x42,0xc4,0x78,0xce,0x43,0x11,0x14,0x6a,0x78,0x9e,0x8f,0x37,0x57,0x62,0x10,0x6b,
		0x42,0xcf,0x47,0xa8,0x29,0xd3,0x83,0x94,0xcb,0xf2,0xf2,0x32,0xbe,0xeb,0xb2,0xb1,
		0xb5,0x4b,0x67,0x64,0x31,0x63,0x7d,0xa0,0x5d,0x6e,0x6e,0x6c,0x71,0x76,0xf5,0x4c,
		0x72,0xb8,0xd2,0xc4,0xda,0x1d,0x7b,0x40,0x2a,0xa4,0x88,0x18,0x19,0x87,0x91,0x71,
		0x89,0xb4,0x45,0x46,0x03,0x22,0x0d,0x91,0x71,0x19,0x69,0xcb,0x40,0x28,0x6c,0x7a,
		0x9e,0x7c,0xe5,0x0c,0x64,0x8a,0x0c,0x84,0x66,0xa8,0x41,0x58,0x77,0x22,0x23,0x61,
		0xa9,0xd5,0x96,0x08,0xd3,0x19,0x9a,0xfb,0x07,0xb4,0x0e,0x7a,0x13,0x5d,0xbb,0xaf,
		0xd9,0x6f,0x77,0xa8,0x2f,0xaf,0x32,0x12,0x16,0x61,0x5d,0x22,0x7d,0x54,0x88,0x86,
		0x3d,0xdc,0x20,0x45,0xf7,0xa0,0x85,0x9b,0x0b,0xe8,0x34,0x77,0x49,0xe5,0x4a,0x74,
		0x1b,0xdb,0xd8,0x4c,0x80,0x9b,0x9b,0xc3,0xc9,0x66,0x08,0x16,0x16,0xa8,0xde,0x75,
		0x1f,0x41,0xb9,0x06,0x99,0x14,0x6e,0x0e,0x22,0x65,0x26,0xd2,0x97,0xb0,0x58,0xad,
		0x91,0xcb,0x65,0xe9,0x74,0xbb,0x6c,0x37,0x9a,0xb8,0xbe,0x87,0x72,0x5c,0x1a,0xfb,
		0x6d,0xa2,0x38,0x62,0xb1,0x5a,0xa3,0x2f,0x13,0x3b,0xa1,0xc7,0x21,0xf8,0xf1,0x13,
		0xf7,0xf2,0xef,0x7f,0xd5,0x79,0xe9,0x37,0x2f,0xe0,0x07,0x01,0x9e,0x1f,0x00,0xb0,
		0xf1,0xde,0xeb,0x6c,0xbc,0xf7,0xfa,0xb4,0x94,0x2a,0x49,0xbf,0x3f,0xa4,0xa6,0x9b,
		0x3c,0xfa,0xd8,0x23,0x8c,0x62,0x85,0x34,0xd3,0x3c,0x97,0xb1,0x22,0x93,0x2f,0x50,
		0x2a,0x96,0x58,0xbf,0x71,0x83,0xcd,0xed,0x1d,0x2e,0xdc,0x76,0x01,0x80,0xcd,0xdd,
		0x3d,0x5c,0x2f,0x20,0x93,0x2f,0x30,0x8a,0x55,0x92,0xba,0x47,0x00,0xe2,0x31,0x21,
		0x94,0x36,0x14,0x4a,0xf3,0x3c,0xf5,0xc3,0x67,0xf0,0x3c,0x7f,0xa6,0x88,0x64,0xd3,
		0x21,0x7f,0x7d,0xfb,0x2d,0xde,0xfc,0xd3,0x1b,0x08,0x6d,0x89,0x8d,0x43,0xac,0xec,
		0x89,0x7a,0x9f,0xc9,0x84,0x2c,0x56,0x97,0xb8,0xbe,0xb6,0xc6,0xd6,0xd6,0x36,0xb1,
		0x49,0x32,0x60,0x73,0x6b,0x9b,0x52,0xa9,0x88,0x1b,0x04,0x8c,0x46,0xe2,0x24,0x00,
		0xa9,0xa7,0x9b,0x39,0x61,0x06,0xc7,0xf3,0xd0,0xc7,0x4a,0xa9,0xf2,0x03,0xdc,0x20,
		0x9c,0x8c,0x85,0x05,0x79,0xf2,0x7c,0x3c,0x0b,0x95,0xa5,0x65,0x7c,0xcf,0x63,0xaf,
		0xd1,0xa0,0x3b,0x14,0xa4,0x33,0x21,0x3b,0x3b,0x3b,0x94,0xab,0xf5,0x19,0xbb,0x58,
		0x1d,0x01,0x50,0xcc,0xb8,0x72,0x18,0x2b,0x3c,0x7f,0x76,0x77,0x2b,0x2d,0x91,0x9a,
		0x2e,0x1a,0x49,0x8b,0xd0,0x27,0x11,0x58,0x69,0x29,0x54,0xeb,0x84,0x99,0x0c,0xdd,
		0xc3,0x03,0x0e,0x3a,0x3d,0xe6,0xdd,0x05,0x0e,0xf7,0x5b,0x5c,0xba,0xe3,0xae,0x19,
		0xbb,0xc0,0x4c,0x9a,0x11,0x28,0x63,0xf1,0x48,0x6e,0x2c,0x8c,0xc5,0xbb,0x65,0x73,
		0x6f,0x7c,0x76,0xe0,0xda,0xa4,0x6e,0x18,0x4e,0x05,0xa0,0x63,0x4d,0xae,0x58,0x66,
		0x2e,0x97,0x63,0xd0,0xef,0xd3,0xde,0x6f,0xe1,0x86,0x69,0xa4,0x88,0x98,0x2f,0xd7,
		0x18,0xc5,0x1a,0x3d,0xb6,0x9b,0x09,0x81,0xb2,0x2e,0x9a,0xe4,0x4d,0x27,0x8d,0x83,
		0xc6,0x99,0x7d,0x3c,0x1a,0x07,0x79,0xac,0xb9,0x45,0xc6,0x41,0x68,0xe7,0x94,0xa6,
		0xaf,0xf1,0x33,0x79,0xe6,0x8b,0x0b,0xb4,0x9b,0x4d,0x9a,0xcd,0x16,0xd6,0x4f,0xe3,
		0x7a,0x01,0x61,0xbe,0xc4,0x48,0xe8,0xa3,0xa7,0x28,0x81,0x9e,0x14,0xa2,0xd9,0xdb,
		0xc4,0xda,0xe2,0xda,0x5b,0x6e,0xa7,0x66,0x87,0xb1,0x4a,0xd6,0x9d,0xf6,0xa5,0xd2,
		0x69,0xe6,0x17,0xaa,0x38,0xf6,0x3f,0xec,0x37,0x1a,0x28,0x0b,0xa9,0xb9,0x79,0xdc,
		0x54,0x96,0x38,0x8a,0x26,0xeb,0xfc,0x19,0x12,0x1a,0x83,0x87,0x46,0xd9,0xf1,0xd3,
		0xc9,0x01,0x7b,0x8c,0x84,0x8e,0x61,0xc2,0xfa,0x48,0x5b,0x84,0x61,0xa6,0x0a,0xce,
		0x7a,0x0b,0xf2,0x8b,0x75,0x52,0x61,0x48,0xe7,0xa0,0xc1,0x68,0xd8,0x23,0x5f,0xa9,
		0x9f,0xb0,0x99,0xf1,0xc0,0x31,0x7e,0x11,0x6b,0x83,0x87,0x7b,0xd4,0x2a,0x92,0x4d,
		0x6f,0xb9,0xad,0xd0,0x16,0x85,0x7b,0x2a,0x00,0x2b,0x34,0x73,0xe5,0x1a,0x6e,0x2a,
		0x43,0x67,0x7f,0x0f,0xad,0x24,0x9f,0xfb,0xc6,0x77,0x4e,0xd8,0x88,0xe3,0x00,0x8e,
		0x67,0x41,0xac,0x5c,0x5c,0x3b,0x1b,0x5f,0xeb,0x3b,0xb7,0x00,0x70,0x88,0x95,0x73,
		0x2a,0x00,0x1f,0x4d,0x30,0x5f,0x26,0x95,0xc9,0x12,0x8f,0x86,0xf8,0x41,0x40,0xa6,
		0x58,0x65,0x14,0x4b,0xd4,0x31,0x1b,0xef,0x38,0x00,0x7d,0x0a,0xa1,0xcc,0xf1,0x3a,
		0xa0,0x93,0xec,0xf0,0x5d,0x07,0x69,0x92,0xb1,0xd1,0xa7,0x87,0x40,0x68,0x8d,0x9f,
		0x9a,0x23,0x5d,0xac,0x12,0xf5,0xaf,0x91,0x2a,0x96,0x09,0xe6,0x8a,0x28,0x65,0x66,
		0x6c,0xb4,0x1a,0xfb,0x58,0x02,0xca,0x4c,0x5d,0x20,0x2d,0xc4,0x4a,0x23,0xc7,0x45,
		0x23,0x91,0xe4,0xd1,0x92,0x18,0x6a,0xa4,0xb5,0xb7,0xe8,0x67,0xc5,0xf8,0x29,0x72,
		0x0b,0x35,0x54,0x34,0x22,0x53,0xa8,0x60,0xfd,0xd4,0xc9,0x3d,0x27,0xed,0xd8,0x42,
		0xac,0x65,0xb2,0xb9,0x54,0xc4,0x52,0xe2,0xfa,0xe1,0x6c,0x08,0x8c,0x83,0x11,0xf1,
		0xd8,0x1b,0x1a,0x61,0xa6,0x0f,0x8d,0x53,0x79,0x60,0x1c,0x32,0xa5,0xa5,0xa4,0x3c,
		0x2f,0x54,0x91,0x8e,0x8f,0xb2,0x62,0xd6,0x53,0x76,0xec,0x01,0x1b,0xc0,0xa8,0xd3,
		0x4e,0x36,0x17,0x43,0x86,0x83,0x21,0x7e,0x2a,0x3b,0xf9,0x47,0x63,0x9c,0x00,0x65,
		0x2d,0xfd,0x83,0x3d,0x3c,0x3f,0x20,0xea,0xb4,0x50,0xd6,0x26,0xf3,0xe3,0x35,0x42,
		0x19,0x84,0x32,0xd3,0xb1,0x90,0xa4,0x4a,0x35,0xfc,0x74,0x86,0xb0,0x50,0x45,0x59,
		0x7b,0xe2,0x9f,0x52,0xac,0x48,0x2a,0xcf,0xa5,0xfb,0x9f,0x78,0xfe,0xe6,0xbb,0xaf,
		0x21,0x87,0x03,0xb4,0x88,0x19,0xb6,0xb6,0x71,0xc2,0x34,0x61,0xbe,0x84,0xe3,0x38,
		0x0c,0x0e,0x1b,0x6c,0x5f,0x79,0x87,0xd6,0xb5,0x7f,0xe2,0xb8,0x2e,0xa3,0x83,0x06,
		0x2a,0x1a,0xe0,0xe7,0x0a,0x04,0xe9,0x2c,0xe6,0x58,0xf8,0xac,0xb5,0x58,0x6b,0x01,
		0x8b,0x75,0x3d,0xba,0xeb,0x1f,0x52,0xbd,0xfd,0x8b,0x04,0x99,0x3c,0x5a,0xab,0x89,
		0xde,0x5a,0x8b,0x9f,0x0e,0x99,0xb4,0xbc,0x95,0x2f,0x3f,0x82,0x33,0xee,0x80,0x5a,
		0x8c,0x00,0x08,0xb3,0x73,0xb8,0x81,0x43,0xd4,0xf3,0x49,0x15,0x16,0xb9,0xf4,0xf0,
		0xf7,0xa7,0xee,0x1b,0x0d,0x93,0x35,0xf9,0xec,0xff,0x0c,0x43,0x98,0xcf,0x52,0xb9,
		0xf3,0x2b,0xcc,0x55,0x57,0xf1,0xb3,0x01,0x3e,0xc1,0x6c,0xe7,0x2c,0xc0,0x7f,0x01,
		0x94,0x31,0xf6,0xca,0x17,0x1e,0xf0,0x93,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,
		0xae,0x42,0x60,0x82);
}