/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.2";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://videos.streetfire.net/";
	this.ID = "videos.streetfire.net";
	this.caption = "StreetFire";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "http://%1.streetfire.net/flv/%2/%3-.flv";
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get the video title
	var title = copyBetween(html, "<title>", "</title>").toString();
	title = strRemove(title, title.lastIndexOf("-"), title.length);
	// set video title
	result.title = title;
	// get the video subdomain (we assume which the video subdomain is the same as preview subdomain)
	var subDomain = copyBetween(html, '[img]http://', '.');
	// get the video hash
	var videoHash = copyBetween(html, 'vidiac.swf?video=', '"');
	// get video sub-dir
	var subDir = strCopy(videoHash, 0, 3);
	// build final video url
	result.URL = strFormat(URL_GET_FLV, subDomain, subDir, videoHash);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x00,0xb3,0x49,0x44,0x41,0x54,0x78,0xda,0xd5,0x93,0xbd,0x09,0xc3,
		0x30,0x10,0x46,0x35,0x82,0x20,0x9d,0xbb,0x34,0x59,0x40,0x0b,0x68,0x13,0x7b,0x84,
		0xa0,0x09,0x5c,0xbb,0x08,0x6e,0xd5,0xa9,0xcb,0x0c,0x2e,0x82,0xba,0xd4,0x5a,0x43,
		0x53,0x7c,0xb9,0x8b,0x39,0x12,0xd0,0x0f,0x81,0x34,0xc9,0xc1,0x43,0xc5,0xe9,0x7b,
		0x92,0x0e,0xa4,0x00,0x7c,0xc5,0xbf,0x0a,0xa4,0x1a,0x02,0x84,0x69,0xc2,0xc5,0x98,
		0x26,0xc7,0x61,0x80,0xf7,0x5e,0x04,0x65,0xd8,0x2b,0xd5,0xc4,0x30,0x24,0xa9,0x3d,
		0x01,0xdb,0xb2,0x74,0xc3,0x23,0xa1,0xb5,0x06,0x55,0x29,0xb8,0xad,0x6b,0x37,0x3c,
		0x13,0x8a,0xb8,0x86,0x80,0x94,0x12,0xf3,0xb2,0xdc,0x43,0xe0,0x0d,0x5d,0xc1,0x81,
		0x70,0xce,0x21,0xc6,0xf8,0x24,0xe7,0xbc,0xcf,0x80,0x8d,0x67,0x6a,0x32,0x33,0xaf,
		0x15,0x4e,0x84,0xb5,0x56,0xc2,0x72,0xfa,0x2e,0xe0,0xc6,0x1b,0x3c,0x20,0x59,0x05,
		0x09,0x0b,0xe5,0x0c,0x04,0xba,0x16,0x6f,0xe8,0x22,0xe1,0x9a,0xa0,0x15,0x2a,0xde,
		0x5d,0x17,0x7c,0x58,0xbf,0xf7,0x99,0x1e,0x15,0x1d,0xbe,0xb6,0x0d,0xe4,0x38,0x34,
		0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
