/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.tangle.com/";
	this.ID = "tangle.com";
	this.caption = "Tangle";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "http://xml.tangle.com/playlist/media/video/%1"; //"http://xml.tangle.com/xml/xml_v4.php?vkey=%1&cc=%2";
	// video information
	var result = new VideoDefinition();
	// get the vkey
	var vkey = getUrlParam(url, "viewkey");
	// download webpage
	var http = new Http();
	var xml = http.downloadWebpage(strFormat(URL_GET_FLV, vkey));
	// get video information
	result.title = copyBetween(xml, "<title><![CDATA[", "]]></title>");
	result.URL = copyBetween(xml, "<filelocation>", "</filelocation>");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x01,0x86,0x49,0x44,0x41,0x54,0x38,0x8d,0x63,0xa8,0x3c,0xcf,0xf0,
		0x1f,0x1f,0xae,0x3a,0xcf,0xf4,0x6b,0xd2,0x75,0x83,0xb3,0x7b,0x9e,0x35,0xd4,0xbd,
		0xfb,0xf1,0x40,0xf6,0xff,0xff,0xff,0x0c,0xc8,0x98,0x81,0x90,0x01,0x48,0xf8,0x6f,
		0xfb,0x15,0x99,0x47,0xa7,0x5e,0xcf,0x49,0xfc,0xfd,0xf7,0x17,0x23,0x39,0x06,0x80,
		0x71,0xc3,0x05,0xbe,0x0f,0x47,0x5f,0x4d,0xca,0x86,0x19,0x02,0x37,0xa0,0xfa,0x02,
		0xcb,0xff,0x69,0x77,0xf4,0xfe,0xcf,0xbe,0x67,0x86,0x82,0xa7,0xde,0xd6,0xfd,0xdf,
		0x7c,0x59,0x00,0xc5,0x90,0xa6,0x4b,0x42,0xaf,0x6e,0x7f,0xdc,0xe3,0x88,0x62,0x40,
		0xc3,0x25,0xee,0xff,0x87,0xdf,0x97,0xfc,0xbf,0xf0,0xb5,0x13,0x05,0x9f,0xff,0xd2,
		0xfe,0xff,0xd0,0xfb,0xa2,0xff,0xd3,0x80,0x06,0x01,0xc3,0x03,0x6e,0xc8,0xac,0x5b,
		0x0e,0x7b,0x41,0xae,0x20,0x68,0x00,0x0c,0x9f,0xfc,0x58,0xfb,0xbf,0xf7,0xba,0x3c,
		0xdc,0x80,0xba,0x0b,0x5c,0x9f,0x9f,0x7e,0xbd,0xa0,0x4d,0xb4,0x01,0x20,0xbc,0xe1,
		0x79,0x38,0x22,0x76,0xce,0x31,0xfd,0x39,0xfe,0x6a,0x5a,0x3a,0x4e,0x03,0xce,0x7f,
		0xe9,0xf8,0x7f,0xee,0x4b,0x1b,0x8a,0x01,0xfb,0xde,0xe6,0xfe,0xaf,0xbb,0xc8,0x09,
		0x37,0x64,0xff,0xf3,0xb6,0x72,0xbc,0x2e,0xd8,0xfa,0x32,0xfe,0xff,0x82,0x07,0x76,
		0xff,0x8f,0x7e,0xa8,0x20,0x6c,0x00,0x08,0x6f,0x7b,0x99,0x80,0x62,0xc0,0x39,0x60,
		0x00,0xb6,0x5f,0x15,0x07,0x1a,0xce,0xf3,0x7f,0xc9,0x23,0xd7,0xff,0x2b,0x1e,0x7b,
		0xe2,0xf6,0x02,0x08,0x4f,0xbc,0xa9,0xf6,0xff,0xd4,0xa7,0x06,0x14,0x43,0x36,0xbf,
		0x88,0xfe,0x5f,0x7d,0x9e,0x19,0x28,0xcf,0xf8,0xbf,0xe6,0x02,0x2b,0x66,0x20,0x4e,
		0xbc,0xae,0x77,0x1e,0x29,0xd9,0xfe,0x9f,0x75,0xd7,0x18,0xe8,0x95,0x52,0x70,0x18,
		0x80,0x0c,0x38,0xfb,0xb9,0xe5,0x7f,0xd7,0x35,0x29,0x8c,0x04,0x05,0x8f,0xc6,0x6b,
		0xef,0x37,0x79,0xd7,0x5f,0xe0,0xf9,0x84,0x2c,0xd9,0x72,0x45,0x08,0x9e,0xa8,0x40,
		0x09,0xa9,0xfe,0x12,0x17,0xee,0x84,0x04,0x32,0x65,0xef,0xf3,0x96,0x0a,0x90,0x93,
		0xc8,0x4a,0xca,0x20,0x02,0xc4,0x39,0xf2,0x72,0x42,0x76,0xf3,0x65,0xb1,0xe7,0xa0,
		0x4c,0x43,0x52,0x66,0x42,0xce,0x9a,0xaf,0xbf,0xdf,0x52,0xde,0xf1,0xb4,0xaa,0x65,
		0xc2,0x75,0x9d,0x4b,0xa0,0x6c,0x4c,0x4c,0x76,0x06,0x00,0xb2,0x1f,0xa1,0xb5,0x1d,
		0x17,0xf8,0xfa,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
