/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jdk.Exported;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.EventSettings;
import jdk.jfr.FlightRecorder;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;

@Exported
public final class Recording
implements Closeable {
    private final PlatformRecording internal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Recording(Map<String, String> map) {
        PlatformRecorder platformRecorder;
        PlatformRecorder platformRecorder2 = platformRecorder = FlightRecorder.getFlightRecorder().getInternal();
        synchronized (platformRecorder2) {
            this.internal = platformRecorder.newRecording(map);
            this.internal.setRecording(this);
            if (this.internal.getRecording() != this) {
                throw new InternalError("Internal recording not properly setup");
            }
        }
    }

    public Recording() {
        this(new HashMap<String, String>());
    }

    public Recording(Configuration configuration) {
        this(configuration.getSettings());
    }

    public void start() {
        this.internal.start();
    }

    public void scheduleStart(Duration duration) {
        Objects.requireNonNull(duration);
        this.internal.scheduleStart(duration);
    }

    public boolean stop() {
        return this.internal.stop("Stopped by user");
    }

    public Map<String, String> getSettings() {
        return new HashMap<String, String>(this.internal.getSettings());
    }

    public long getSize() {
        return this.internal.getSize();
    }

    public Instant getStopTime() {
        return this.internal.getStopTime();
    }

    public Instant getStartTime() {
        return this.internal.getStartTime();
    }

    public long getMaxSize() {
        return this.internal.getMaxSize();
    }

    public Duration getMaxAge() {
        return this.internal.getMaxAge();
    }

    public String getName() {
        return this.internal.getName();
    }

    public void setSettings(Map<String, String> map) {
        Objects.requireNonNull(map);
        Map<String, String> map2 = Utils.sanitizeNullFreeStringMap(map);
        this.internal.setSettings(map2);
    }

    public RecordingState getState() {
        return this.internal.getState();
    }

    @Override
    public void close() {
        this.internal.close();
    }

    public Recording copy(boolean bl) {
        return this.internal.newCopy(bl);
    }

    public void dump(Path path) throws IOException {
        Objects.requireNonNull(path);
        this.internal.dump(new WriteableUserPath(path));
    }

    public boolean isToDisk() {
        return this.internal.isToDisk();
    }

    public void setMaxSize(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Max size of recording can't be negative");
        }
        this.internal.setMaxSize(l);
    }

    public void setMaxAge(Duration duration) {
        if (duration != null && duration.isNegative()) {
            throw new IllegalArgumentException("Max age of recording can't be negative");
        }
        this.internal.setMaxAge(duration);
    }

    public void setDestination(Path path) throws IOException {
        this.internal.setDestination(path != null ? new WriteableUserPath(path) : null);
    }

    public Path getDestination() {
        WriteableUserPath writeableUserPath = this.internal.getDestination();
        if (writeableUserPath == null) {
            return null;
        }
        return writeableUserPath.getPotentiallyMaliciousOriginal();
    }

    public long getId() {
        return this.internal.getId();
    }

    public void setName(String string) {
        Objects.requireNonNull(string);
        this.internal.setName(string);
    }

    public void setDumpOnExit(boolean bl) {
        this.internal.setDumpOnExit(bl);
    }

    public boolean getDumpOnExit() {
        return this.internal.getDumpOnExit();
    }

    public void setToDisk(boolean bl) {
        this.internal.setToDisk(bl);
    }

    public InputStream getStream(Instant instant, Instant instant2) throws IOException {
        if (instant != null && instant2 != null && instant2.isBefore(instant)) {
            throw new IllegalArgumentException("End time of requested stream must not be before start time");
        }
        return this.internal.open(instant, instant2);
    }

    public Duration getDuration() {
        return this.internal.getDuration();
    }

    public void setDuration(Duration duration) {
        this.internal.setDuration(duration);
    }

    public EventSettings enable(String string) {
        Objects.requireNonNull(string);
        RecordingSettings recordingSettings = new RecordingSettings(this, string);
        recordingSettings.with("enabled", "true");
        return recordingSettings;
    }

    public EventSettings disable(String string) {
        Objects.requireNonNull(string);
        RecordingSettings recordingSettings = new RecordingSettings(this, string);
        recordingSettings.with("enabled", "false");
        return recordingSettings;
    }

    public EventSettings enable(Class<? extends Event> clazz) {
        Objects.requireNonNull(clazz);
        RecordingSettings recordingSettings = new RecordingSettings(this, clazz);
        recordingSettings.with("enabled", "true");
        return recordingSettings;
    }

    public EventSettings disable(Class<? extends Event> clazz) {
        Objects.requireNonNull(clazz);
        RecordingSettings recordingSettings = new RecordingSettings(this, clazz);
        recordingSettings.with("enabled", "false");
        return recordingSettings;
    }

    PlatformRecording getInternal() {
        return this.internal;
    }

    private void setSetting(String string, String string2) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        this.internal.setSetting(string, string2);
    }

    private static class RecordingSettings
    extends EventSettings {
        private final Recording recording;
        private final String identifier;

        RecordingSettings(Recording recording, String string) {
            this.recording = recording;
            this.identifier = string;
        }

        RecordingSettings(Recording recording, Class<? extends Event> clazz) {
            Utils.ensureValidEventSubclass(clazz);
            this.recording = recording;
            this.identifier = String.valueOf(Type.getTypeId(clazz));
        }

        @Override
        public EventSettings with(String string, String string2) {
            Objects.requireNonNull(string2);
            this.recording.setSetting(this.identifier + "#" + string, string2);
            return this;
        }

        @Override
        public Map<String, String> toMap() {
            return this.recording.getSettings();
        }
    }
}

