/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class ChunkedOutputStream
extends PrintStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final int CRLF_SIZE = CRLF.length;
    private static final byte[] FOOTER = CRLF;
    private static final int FOOTER_SIZE = CRLF_SIZE;
    private static final byte[] EMPTY_CHUNK_HEADER = ChunkedOutputStream.getHeader(0);
    private static final int EMPTY_CHUNK_HEADER_SIZE = ChunkedOutputStream.getHeaderSize(0);
    private byte[] buf;
    private int size;
    private int count;
    private int spaceInCurrentChunk;
    private PrintStream out;
    private int preferredChunkDataSize;
    private int preferedHeaderSize;
    private int preferredChunkGrossSize;
    private byte[] completeHeader;

    private static int getHeaderSize(int n) {
        return Integer.toHexString(n).length() + CRLF_SIZE;
    }

    private static byte[] getHeader(int n) {
        try {
            String string = Integer.toHexString(n);
            byte[] byArray = string.getBytes("US-ASCII");
            byte[] byArray2 = new byte[ChunkedOutputStream.getHeaderSize(n)];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[i];
            }
            byArray2[byArray.length] = CRLF[0];
            byArray2[byArray.length + 1] = CRLF[1];
            return byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public ChunkedOutputStream(PrintStream printStream) {
        this(printStream, 4096);
    }

    public ChunkedOutputStream(PrintStream printStream, int n) {
        super(printStream);
        this.out = printStream;
        if (n <= 0) {
            n = 4096;
        }
        if (n > 0) {
            int n2 = n - ChunkedOutputStream.getHeaderSize(n) - FOOTER_SIZE;
            if (ChunkedOutputStream.getHeaderSize(n2 + 1) < ChunkedOutputStream.getHeaderSize(n)) {
                ++n2;
            }
            n = n2;
        }
        this.preferredChunkDataSize = n > 0 ? n : 4096 - ChunkedOutputStream.getHeaderSize(4096) - FOOTER_SIZE;
        this.preferedHeaderSize = ChunkedOutputStream.getHeaderSize(this.preferredChunkDataSize);
        this.preferredChunkGrossSize = this.preferedHeaderSize + this.preferredChunkDataSize + FOOTER_SIZE;
        this.completeHeader = ChunkedOutputStream.getHeader(this.preferredChunkDataSize);
        this.buf = new byte[this.preferredChunkGrossSize];
        this.reset();
    }

    private void flush(boolean bl) {
        if (this.spaceInCurrentChunk == 0) {
            this.out.write(this.buf, 0, this.preferredChunkGrossSize);
            this.out.flush();
            this.reset();
        } else if (bl) {
            if (this.size > 0) {
                int n = this.preferedHeaderSize - ChunkedOutputStream.getHeaderSize(this.size);
                System.arraycopy(ChunkedOutputStream.getHeader(this.size), 0, this.buf, n, ChunkedOutputStream.getHeaderSize(this.size));
                this.buf[this.count++] = FOOTER[0];
                this.buf[this.count++] = FOOTER[1];
                this.out.write(this.buf, n, this.count - n);
            } else {
                this.out.write(EMPTY_CHUNK_HEADER, 0, EMPTY_CHUNK_HEADER_SIZE);
            }
            this.out.flush();
            this.reset();
        }
    }

    @Override
    public boolean checkError() {
        return this.out.checkError();
    }

    private void ensureOpen() {
        if (this.out == null) {
            this.setError();
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = n2;
        int n4 = n;
        do {
            if (n3 >= this.spaceInCurrentChunk) {
                for (int i = 0; i < this.completeHeader.length; ++i) {
                    this.buf[i] = this.completeHeader[i];
                }
                System.arraycopy(byArray, n4, this.buf, this.count, this.spaceInCurrentChunk);
                n4 += this.spaceInCurrentChunk;
                n3 -= this.spaceInCurrentChunk;
                this.count += this.spaceInCurrentChunk;
                this.buf[this.count++] = FOOTER[0];
                this.buf[this.count++] = FOOTER[1];
                this.spaceInCurrentChunk = 0;
                this.flush(false);
                if (!this.checkError()) continue;
                break;
            }
            System.arraycopy(byArray, n4, this.buf, this.count, n3);
            this.count += n3;
            this.size += n3;
            this.spaceInCurrentChunk -= n3;
            n3 = 0;
        } while (n3 > 0);
    }

    @Override
    public synchronized void write(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public synchronized void reset() {
        this.count = this.preferedHeaderSize;
        this.size = 0;
        this.spaceInCurrentChunk = this.preferredChunkDataSize;
    }

    public int size() {
        return this.size;
    }

    @Override
    public synchronized void close() {
        this.ensureOpen();
        if (this.size > 0) {
            this.flush(true);
        }
        this.flush(true);
        this.out = null;
    }

    @Override
    public synchronized void flush() {
        this.ensureOpen();
        if (this.size > 0) {
            this.flush(true);
        }
    }
}

