/******************************************************************************
 ------------- Copyright (c) 2009-2016 H a r a l d  A c h i t z ---------------
 ---------- < h a r a l d dot a c h i t z at g m a i l dot c o m > ------------
 ---- This Source Code Form is subject to the terms of the Mozilla Public -----
 ---- License, v. 2.0. If a copy of the MPL was not distributed with this -----
 ---------- file, You can obtain one at http://mozilla.org/MPL/2.0/. ----------
 ******************************************************************************/


  /************************************************************************
              !!!!  THIS FILE IS AUTOGENERATED BY CMAKE !!!!
    *************************************************************************/

#ifndef SL3_CONFIG
#define SL3_CONFIG


// TODO this has to look like here https://gcc.gnu.org/wiki/Visibility

#if defined(_WIN32) && defined(_MSC_VER)
    #if defined(LIBSL3_DLL)
        #define LIBSL3_API __declspec(dllexport)
    #elif defined(LINK_SL3_DLL)
        #define LIBSL3_API __declspec(dllimport)
    #else
        #define LIBSL3_API
    #endif
#else    
    #define LIBSL3_API
#endif

//#define LIBSL3_API

/**
    \namespace sl3
    \brief Namespace of libSL3.

    The namespace where the library defines it's elements.

*/
namespace sl3
{

  static constexpr int MAJOR_VERSION = 1 ;
  static constexpr int MINOR_VERSION = 1 ;
  static constexpr int PATCH_VERSION = 19003 ;

  static constexpr bool build_internal_sqlite3 = true;

  /**
   * \brief sqlite version string at compile time
   *
   * if this library was linked against an installed version of sqlite
   * this function can be used to determinate if the system library has
   * been updated.
   * \sa sqliteRuntimeVersion()
   *
   * \return version string at compile time
   */
  const char* sqliteCompiledVersion();

  /**
   * \brief sqlite version number at compile time
   *
   * if this library was linked against an installed version of sqlite
   * this function can be used to determinate if the system library has
   * been updated.
   * \sa sqliteRuntimeVersionNumber()
   *
   * \return version number at compile time
   */
  int sqliteCompiledVersionNumber();


  /**
   * \brief sqlite version string at runtime
   *
   * if this library was linked against an installed version of sqlite
   * this function can be used to determinate if the system library has
   * been updated.
   * \sa sqliteCompiledVersion()
   *
   * \return version string currently used
   */
  const char* sqliteRuntimeVersion();

  /**
   * \brief sqlite version number at compile time
   *
   * if this library was linked against an installed version of sqlite
   * this function can be used to determinate if the system library has
   * been updated.
   * \sa sqliteCompiledVersionNumber()
   *
   * \return sqlite version number currently used
   */
  int sqliteRuntimeVersionNumber();


  /**
   * \brief returns value of SQLITE_THREADSAFE compilation option
   *
   *  see http://www.sqlite.org/compile.html about additional informations
   *
   * \return 0 or 1 or 2
   */
  int sqliteThreadSafeCompileOption();


}


#endif
