﻿using System;
using System.ComponentModel;
using System.Xml;
using AGS.Types.Enums;

namespace AGS.Types
{
    public class LogGroups
    {
        LogLevel _loglevel_main = LogLevel.Error;
        LogLevel _loglevel_game = LogLevel.Error;
        LogLevel _loglevel_script = LogLevel.Info;
        LogLevel _loglevel_sprcache = LogLevel.None;
        LogLevel _loglevel_manobj = LogLevel.None;
        LogLevel _loglevel_sdl = LogLevel.None;
        LogLevel _loglevel_plugin = LogLevel.Info;

        public void SetDefaults()
        {
            _loglevel_main = LogLevel.Error;
            _loglevel_game = LogLevel.Error;
            _loglevel_script = LogLevel.Info;
            _loglevel_sprcache = LogLevel.None;
            _loglevel_manobj = LogLevel.None;
            _loglevel_sdl = LogLevel.None;
            _loglevel_plugin = LogLevel.Info;
        }

        [TypeConverter(typeof(EnumTypeConverter))]
        [Description("Define the log level of Main engine, which gives information on general ags behavior.")]
        public LogLevel Main
        {
            get { return _loglevel_main;  }
            set { _loglevel_main = value; }
        }

        // Game log group
        [TypeConverter(typeof(EnumTypeConverter))]
        [Description("Define the log level of game related methods, which gives information on internal Engine API and behavior.")]
        public LogLevel Game
        {
            get { return _loglevel_game;  }
            set { _loglevel_game = value; }
        }

        // Script log group
        [DisplayName("Script")]
        [Description("Define the log level of messages generated by user script, using System.Log method.")]
        [TypeConverter(typeof(EnumTypeConverter))]
        public LogLevel Script
        {
            get { return _loglevel_script;  }
            set { _loglevel_script = value; }
        }

        // Plugin log group
        [TypeConverter(typeof(EnumTypeConverter))]
        [Description("Define the log level of messages generated by game plugins.")]
        public LogLevel Plugin
        {
            get { return _loglevel_plugin; }
            set { _loglevel_plugin = value; }
        }

        // Sprite Cache log group
        [DisplayName("Sprite Cache")]
        [Browsable(false)]
        [Description("Define the log level of messages generated by sprite cache messages.")]
        [TypeConverter(typeof(EnumTypeConverter))]
        public LogLevel SpriteCache
        {
            get { return _loglevel_sprcache; }
        }

        // Managed Objects log group
        [DisplayName("Managed Objects")]
        [Browsable(false)]
        [Description("Define the log level of messages generated by managed objects.")]
        [TypeConverter(typeof(EnumTypeConverter))]
        public LogLevel ManObj
        {
            get { return _loglevel_manobj; }
        }

        [DisplayName("SDL")]
        [Browsable(false)]
        [Description("Define the log level of messages generated by SDL backend.")]
        [TypeConverter(typeof(EnumTypeConverter))]
        public LogLevel SDL
        {
            get { return _loglevel_sdl; }
        }

        public LogLevel GetGroupLevel(LogGroup group)
        {
            switch (group)
            {
                case LogGroup.Main:
                    return Main;
                case LogGroup.Game:
                    return Game;
                case LogGroup.Script:
                    return Script;
                case LogGroup.SprCache:
                    return SpriteCache;
                case LogGroup.ManObj:
                    return ManObj;
                case LogGroup.SDL:
                    return SDL;
                case LogGroup.Plugin:
                    return Plugin;
            }
            return LogLevel.None;
        }
        public void FromXml(XmlNode node)
        {
            SerializeUtils.DeserializeFromXML(this, node);
        }

        public void ToXml(XmlTextWriter writer)
        {
            SerializeUtils.SerializeToXML(this, writer);
        }
    }
}
