/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IRCException;
import com.ircclouds.irc.api.domain.messages.ChanPartMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractChannelPartListener {
    private Map<String, Callback<String>> callbacks = new HashMap<String, Callback<String>>();

    public void submit(String aChannelName, Callback<String> aCallback) {
        this.callbacks.put(aChannelName, aCallback);
    }

    public void onChannelPart(ChanPartMessage aMsg) {
        Callback<String> _callback = this.callbacks.remove(aMsg.getChannelName());
        if (_callback != null) {
            _callback.onSuccess(aMsg.getChannelName());
        }
        this.deleteChannel(aMsg.getChannelName());
    }

    public void onServerMessage(ServerNumericMessage aServerMessage) {
        String _chan;
        if (aServerMessage.getNumericCode() == 403 && this.callbacks.containsKey(_chan = aServerMessage.getText().split(" ")[0])) {
            this.callbacks.remove(_chan).onFailure(new IRCException(aServerMessage.getText()));
        }
    }

    protected abstract void deleteChannel(String var1);
}

