/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.bccontrib.params.ParametersForSkein;
import org.jitsi.impl.neomedia.transform.srtp.BaseSRTPCryptoContext;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.ByteArrayBuffer;

public class SRTCPCryptoContext
extends BaseSRTPCryptoContext {
    private int receivedIndex = 0;
    private int sentIndex = 0;

    public SRTCPCryptoContext(int ssrc) {
        super(ssrc);
    }

    public SRTCPCryptoContext(int ssrc, byte[] masterK, byte[] masterS, SRTPPolicy policy) {
        super(ssrc, masterK, masterS, policy);
    }

    boolean checkReplay(int index) {
        long delta = index - this.receivedIndex;
        if (delta > 0L) {
            return true;
        }
        if (-delta > 64L) {
            return false;
        }
        return (this.replayWindow >> (int)(-delta) & 1L) == 0L;
    }

    private void computeIv(byte label) {
        for (int i = 0; i < 14; ++i) {
            this.ivStore[i] = this.masterSalt[i];
        }
        this.ivStore[7] = (byte)(this.ivStore[7] ^ label);
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
    }

    public SRTCPCryptoContext deriveContext(int ssrc) {
        return new SRTCPCryptoContext(ssrc, this.masterKey, this.masterSalt, this.policy);
    }

    public synchronized void deriveSrtcpKeys() {
        this.computeIv((byte)3);
        this.cipherCtr.init(this.masterKey);
        Arrays.fill(this.masterKey, (byte)0);
        Arrays.fill(this.encKey, (byte)0);
        this.cipherCtr.process(this.encKey, 0, this.policy.getEncKeyLength(), this.ivStore);
        if (this.authKey != null) {
            this.computeIv((byte)4);
            Arrays.fill(this.authKey, (byte)0);
            this.cipherCtr.process(this.authKey, 0, this.policy.getAuthKeyLength(), this.ivStore);
            switch (this.policy.getAuthType()) {
                case 1: {
                    this.mac.init((CipherParameters)new KeyParameter(this.authKey));
                    break;
                }
                case 2: {
                    this.mac.init((CipherParameters)new ParametersForSkein((CipherParameters)new KeyParameter(this.authKey), 512, this.tagStore.length * 8));
                }
            }
            Arrays.fill(this.authKey, (byte)0);
        }
        this.computeIv((byte)5);
        Arrays.fill(this.saltKey, (byte)0);
        this.cipherCtr.process(this.saltKey, 0, this.policy.getSaltKeyLength(), this.ivStore);
        Arrays.fill(this.masterSalt, (byte)0);
        if (this.cipherF8 != null) {
            this.cipherF8.init(this.encKey, this.saltKey);
        }
        this.cipherCtr.init(this.encKey);
        Arrays.fill(this.encKey, (byte)0);
    }

    public void processPacketAESCM(ByteArrayBuffer pkt, int index) {
        int ssrc = (int)RawPacket.getRTCPSSRC(pkt);
        this.ivStore[0] = this.saltKey[0];
        this.ivStore[1] = this.saltKey[1];
        this.ivStore[2] = this.saltKey[2];
        this.ivStore[3] = this.saltKey[3];
        this.ivStore[4] = (byte)(ssrc >> 24 & 0xFF ^ this.saltKey[4]);
        this.ivStore[5] = (byte)(ssrc >> 16 & 0xFF ^ this.saltKey[5]);
        this.ivStore[6] = (byte)(ssrc >> 8 & 0xFF ^ this.saltKey[6]);
        this.ivStore[7] = (byte)(ssrc & 0xFF ^ this.saltKey[7]);
        this.ivStore[8] = this.saltKey[8];
        this.ivStore[9] = this.saltKey[9];
        this.ivStore[10] = (byte)(index >> 24 & 0xFF ^ this.saltKey[10]);
        this.ivStore[11] = (byte)(index >> 16 & 0xFF ^ this.saltKey[11]);
        this.ivStore[12] = (byte)(index >> 8 & 0xFF ^ this.saltKey[12]);
        this.ivStore[13] = (byte)(index & 0xFF ^ this.saltKey[13]);
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
        int payloadOffset = 8;
        int payloadLength = pkt.getLength() - payloadOffset;
        this.cipherCtr.process(pkt.getBuffer(), pkt.getOffset() + payloadOffset, payloadLength, this.ivStore);
    }

    public void processPacketAESF8(ByteArrayBuffer pkt, int index) {
        this.ivStore[0] = 0;
        this.ivStore[1] = 0;
        this.ivStore[2] = 0;
        this.ivStore[3] = 0;
        this.ivStore[4] = (byte)((index |= Integer.MIN_VALUE) >> 24);
        this.ivStore[5] = (byte)(index >> 16);
        this.ivStore[6] = (byte)(index >> 8);
        this.ivStore[7] = (byte)index;
        System.arraycopy(pkt.getBuffer(), pkt.getOffset(), this.ivStore, 8, 8);
        int payloadOffset = 8;
        int payloadLength = pkt.getLength() - (4 + this.policy.getAuthTagLength());
        this.cipherF8.process(pkt.getBuffer(), pkt.getOffset() + payloadOffset, payloadLength, this.ivStore);
    }

    public synchronized boolean reverseTransformPacket(ByteArrayBuffer pkt) {
        int index;
        boolean decrypt = false;
        int tagLength = this.policy.getAuthTagLength();
        int indexEflag = RawPacket.getSRTCPIndex(pkt, tagLength);
        if ((indexEflag & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            decrypt = true;
        }
        if (!this.checkReplay(index = indexEflag & Integer.MAX_VALUE)) {
            return false;
        }
        if (this.policy.getAuthType() != 0) {
            pkt.readRegionToBuff(pkt.getLength() - tagLength, tagLength, this.tempStore);
            pkt.shrink(tagLength + 4);
            this.authenticatePacketHMAC(pkt, indexEflag);
            int nonEqual = 0;
            for (int i = 0; i < tagLength; ++i) {
                nonEqual |= this.tempStore[i] ^ this.tagStore[i];
            }
            if (nonEqual != 0) {
                return false;
            }
        }
        if (decrypt) {
            if (this.policy.getEncType() == 1 || this.policy.getEncType() == 3) {
                this.processPacketAESCM(pkt, index);
            } else if (this.policy.getEncType() == 2 || this.policy.getEncType() == 4) {
                this.processPacketAESF8(pkt, index);
            }
        }
        this.update(index);
        return true;
    }

    public synchronized void transformPacket(ByteArrayBuffer pkt) {
        boolean encrypt = false;
        if (this.policy.getEncType() == 1 || this.policy.getEncType() == 3) {
            this.processPacketAESCM(pkt, this.sentIndex);
            encrypt = true;
        } else if (this.policy.getEncType() == 2 || this.policy.getEncType() == 4) {
            this.processPacketAESF8(pkt, this.sentIndex);
            encrypt = true;
        }
        int index = 0;
        if (encrypt) {
            index = this.sentIndex | Integer.MIN_VALUE;
        }
        pkt.grow(4 + this.policy.getAuthTagLength());
        if (this.policy.getAuthType() != 0) {
            this.authenticatePacketHMAC(pkt, index);
            pkt.append(this.rbStore, 4);
            pkt.append(this.tagStore, this.policy.getAuthTagLength());
        }
        ++this.sentIndex;
        this.sentIndex &= Integer.MAX_VALUE;
    }

    private void update(int index) {
        int delta = this.receivedIndex - index;
        if (delta > 0) {
            this.replayWindow <<= delta;
            this.replayWindow |= 1L;
        } else {
            this.replayWindow |= (long)(1 << delta);
        }
        this.receivedIndex = index;
    }
}

