/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public final class JNIUtils {
    private static final Pattern DYLIB_PATTERN = Pattern.compile("\\.dylib$");

    public static void loadLibrary(String libname, ClassLoader classLoader) {
        JNIUtils.loadLibrary(libname, null, classLoader);
    }

    public static void loadLibrary(String libname, Class clazz) {
        JNIUtils.loadLibrary(libname, clazz, clazz.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibrary(String libname, Class clazz, ClassLoader classLoader) {
        try {
            if (clazz == null) {
                System.loadLibrary(libname);
                return;
            }
            JNIUtils.loadNativeInClassloader(libname, clazz, false);
        }
        catch (UnsatisfiedLinkError ulerr) {
            File embedded;
            libname = System.mapLibraryName(libname);
            if (Platform.isMac()) {
                libname = DYLIB_PATTERN.matcher(libname).replaceFirst(".jnilib");
            }
            try {
                embedded = Native.extractFromResourcePath((String)("/" + Platform.RESOURCE_PREFIX + "/" + libname), (ClassLoader)classLoader);
            }
            catch (IOException ioex) {
                throw ulerr;
            }
            try {
                if (clazz != null) {
                    JNIUtils.loadNativeInClassloader(embedded.getAbsolutePath(), clazz, true);
                } else {
                    System.load(embedded.getAbsolutePath());
                }
            }
            finally {
                if (embedded.getName().startsWith("jna") && !embedded.delete()) {
                    embedded.deleteOnExit();
                }
            }
        }
    }

    private static void loadNativeInClassloader(String lib, Class clazz, boolean isAbsolute) {
        try {
            Method loadLibrary0 = Runtime.getRuntime().getClass().getDeclaredMethod(isAbsolute ? "load0" : "loadLibrary0", Class.class, String.class);
            loadLibrary0.setAccessible(true);
            loadLibrary0.invoke((Object)Runtime.getRuntime(), clazz, lib);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.loadLibrary(lib);
        }
    }

    private JNIUtils() {
    }
}

