/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

public class RateStatistics {
    private long accumulatedCount;
    private final long[] buckets;
    private int oldestIndex;
    private long oldestTime;
    private final float scale;

    public RateStatistics(int windowSizeMs) {
        this(windowSizeMs, 8000.0f);
    }

    public RateStatistics(int windowSizeMs, float scale) {
        this.buckets = new long[windowSizeMs + 1];
        this.scale = scale / (float)(this.buckets.length - 1);
    }

    private synchronized void eraseOld(long nowMs) {
        long newOldestTime = nowMs - (long)this.buckets.length + 1L;
        if (newOldestTime <= this.oldestTime) {
            return;
        }
        while (this.oldestTime < newOldestTime) {
            long countInOldestBucket = this.buckets[this.oldestIndex];
            this.accumulatedCount -= countInOldestBucket;
            this.buckets[this.oldestIndex] = 0L;
            if (++this.oldestIndex >= this.buckets.length) {
                this.oldestIndex = 0;
            }
            ++this.oldestTime;
            if (this.accumulatedCount != 0L) continue;
            break;
        }
        this.oldestTime = newOldestTime;
    }

    public synchronized long getRate() {
        return this.getRate(System.currentTimeMillis());
    }

    public synchronized long getRate(long nowMs) {
        this.eraseOld(nowMs);
        return (long)((float)this.accumulatedCount * this.scale + 0.5f);
    }

    public synchronized long getAccumulatedCount() {
        return this.getAccumulatedCount(System.currentTimeMillis());
    }

    public synchronized long getAccumulatedCount(long nowMs) {
        this.eraseOld(nowMs);
        return this.accumulatedCount;
    }

    public synchronized void update(int count, long nowMs) {
        if (nowMs < this.oldestTime) {
            return;
        }
        this.eraseOld(nowMs);
        int nowOffset = (int)(nowMs - this.oldestTime);
        int index = this.oldestIndex + nowOffset;
        if (index >= this.buckets.length) {
            index -= this.buckets.length;
        }
        int n = index;
        this.buckets[n] = this.buckets[n] + (long)count;
        this.accumulatedCount += (long)count;
    }
}

