/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.RAFile;

public class DataFileCacheSession
extends DataFileCache {
    public DataFileCacheSession(Database database, String string) {
        super(database, string);
        this.logEvents = false;
    }

    @Override
    protected void initParams(Database database, String string, boolean bl) {
        this.dataFileName = string + ".data.tmp";
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.cachedRowPadding = this.dataFileScale = 64;
        this.initialFreePos = this.dataFileScale;
        this.maxCacheRows = 2048;
        this.maxCacheBytes = this.maxCacheRows * 1024;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale;
    }

    @Override
    public void open(boolean bl) {
        try {
            this.dataFile = new RAFile(this.database, this.dataFileName, false, false, false);
            this.fileFreePosition = this.initialFreePos;
            this.initBuffers();
            this.spaceManager = new DataSpaceManagerSimple(this);
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent("Failed to open Session RA file", throwable);
            this.release();
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    @Override
    protected void setFileModified() {
    }

    @Override
    public void close() {
        this.writeLock.lock();
        try {
            this.clear();
            if (this.dataFile != null) {
                this.dataFile.close();
                this.dataFile = null;
                this.fa.removeElement(this.dataFileName);
            }
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent("Failed to close Session RA file", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustStoreCount(int n) {
        this.writeLock.lock();
        try {
            this.storeCount += n;
            if (this.storeCount == 0) {
                this.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected void clear() {
        Iterator iterator = this.cache.getIterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            row.setInMemory(false);
            row.destroy();
        }
        this.cache.clear();
        this.fileStartFreePosition = this.fileFreePosition = this.initialFreePos;
        this.initBuffers();
    }
}

