/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.io.Serializable;
import java.util.Arrays;
import org.dhcp4java.DHCPPacket;

public class HardwareAddress
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final byte hardwareType;
    private final byte[] hardwareAddress;
    private static final byte HTYPE_ETHER = 1;

    public HardwareAddress(byte[] macAddr) {
        this.hardwareType = 1;
        this.hardwareAddress = macAddr;
    }

    public HardwareAddress(byte hType, byte[] macAddr) {
        this.hardwareType = hType;
        this.hardwareAddress = macAddr;
    }

    public HardwareAddress(String macHex) {
        this(DHCPPacket.hex2Bytes(macHex));
    }

    public HardwareAddress(byte hType, String macHex) {
        this(hType, DHCPPacket.hex2Bytes(macHex));
    }

    public byte getHardwareType() {
        return this.hardwareType;
    }

    public byte[] getHardwareAddress() {
        return (byte[])this.hardwareAddress.clone();
    }

    public int hashCode() {
        return this.hardwareType ^ Arrays.hashCode(this.hardwareAddress);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HardwareAddress)) {
            return false;
        }
        HardwareAddress hwAddr = (HardwareAddress)obj;
        return this.hardwareType == hwAddr.hardwareType && Arrays.equals(this.hardwareAddress, hwAddr.hardwareAddress);
    }

    public String getHardwareAddressHex() {
        return DHCPPacket.bytes2Hex(this.hardwareAddress);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(28);
        if (this.hardwareType != 1) {
            sb.append(this.hardwareType).append("/");
        }
        for (int i = 0; i < this.hardwareAddress.length; ++i) {
            if ((this.hardwareAddress[i] & 0xFF) < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(this.hardwareAddress[i] & 0xFF, 16));
            if (i >= this.hardwareAddress.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public static HardwareAddress getHardwareAddressByString(String macStr) {
        if (macStr == null) {
            throw new NullPointerException("macStr is null");
        }
        String[] macAdrItems = macStr.split(":");
        if (macAdrItems.length != 6) {
            throw new IllegalArgumentException("macStr[" + macStr + "] has not 6 items");
        }
        byte[] macBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            int val = Integer.parseInt(macAdrItems[i], 16);
            if (val < -128 || val > 255) {
                throw new IllegalArgumentException("Value is out of range:" + macAdrItems[i]);
            }
            macBytes[i] = (byte)val;
        }
        return new HardwareAddress(macBytes);
    }
}

