/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauth;

import com.google.gdata.client.authn.oauth.OAuthException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class OAuthHttpClient {
    public String getResponse(URL url) throws OAuthException {
        return this.getResponse(url, null);
    }

    public String getResponse(URL url, Map<String, String> headers) throws OAuthException {
        try {
            String inputLine;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    connection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        catch (IOException e) {
            throw new OAuthException("Error getting HTTP response", e);
        }
    }
}

