//! @file mathlib-arpack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 82 subprograms from ARPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CGETV0 CSORTC DNAUPD DSAUPD DSTATN IVOUT  SNAUPD SSAUPD SSTATN ZNAUP2
// CMOUT  CSTATN DNCONV DSCONV DSTATS SECOND SNCONV SSCONV SSTATS ZNAUPD
// CNAITR CVOUT  DNEIGH DSEIGT DSTQRB SGETV0 SNEIGH SSEIGT SSTQRB ZNEIGH
// CNAPPS DGETV0 DNEUPD DSESRT DVOUT  SLAQRB SNEUPD SSESRT SVOUT  ZNEUPD
// CNAUP2 DLAQRB DNGETS DSEUPD ICNTEQ SMOUT  SNGETS SSEUPD ZGETV0 ZNGETS
// CNAUPD DMOUT  DSAITR DSGETS ICOPY  SNAITR SSAITR SSGETS ZMOUT  ZSORTC
// CNEIGH DNAITR DSAPPS DSORTC ISET   SNAPPS SSAPPS SSORTC ZNAITR ZSTATN
// CNEUPD DNAPPS DSAUP2 DSORTR ISWAP  SNAUP2 SSAUP2 SSORTR ZNAPPS ZVOUT
// CNGETS DNAUP2

// ARPACK, the ARnoldi PACKage, is a numerical software library written in FORTRAN 
// 77 for solving large scale eigenvalue problems. The package is designed to 
// compute a few eigenvalues and corresponding eigenvectors of large sparse or 
// structured matrices, using the Implicitly Restarted Arnoldi Method (IRAM) or, 
// in the case of symmetric matrices, the corresponding variant of the Lanczos 
// algorithm. It is used by many popular numerical computing environments such as 
// SciPy, Mathematica, GNU Octave and MATLAB to provide this functionality.

// The license for ARPACK Fortran source code is:
//
// BSD Software License
// 
// Pertains to ARPACK and P_ARPACK
// 
// Copyright (c) 1996-2008 Rice University.  
// Developed by D.C. Sorensen, R.B. Lehoucq, C. Yang, and K. Maschhoff.
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
// 
// - Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer. 
//   
// - Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer listed
//   in this license in the documentation and/or other materials
//   provided with the distribution.
//   
// - Neither the name of the copyright holders nor the names of its
//   contributors may be used to endorse or promote products derived from
//   this software without specific prior written permission.
//   
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT  
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT  
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "g"
#define _dc_1 "i"
#define _dc_2 "c"
#define _dc_3 "n"
#define _dc_4 "_getv0: re-orthonalization ; rnorm0 is"
#define _dc_5 "_getv0: re-orthonalization ; rnorm is"
#define _dc_6 "_getv0: b-norm of initial / restarted starting vector"
#define _dc_7 "_getv0: initial / restarted starting vector"
#define _dc_8 "o"
#define _dc_9 "l"
#define _dc_10 "-"
#define _dc_11 " "
#define _dc_12 "           "
#define _dc_13 "         "
#define _dc_14 "          "
#define _dc_15 "             "
#define _dc_16 "            "
#define _dc_17 "                  "
#define _dc_18 " row"
#define _dc_19 ":"
#define _dc_20 "("
#define _dc_21 ","
#define _dc_22 ")  "
#define _dc_23 ")"
#define _dc_24 "safe minimum"
#define _dc_25 "precision"
#define _dc_26 "_naitr: generating arnoldi vector number"
#define _dc_27 "_naitr: b-norm of the current residual is"
#define _dc_28 "_naitr: ****** restart at step ******"
#define _dc_29 "general"
#define _dc_30 "_naitr: re-orthogonalization; wnorm and rnorm are"
#define _dc_31 "_naitr: j-th column of h"
#define _dc_32 "_naitr: iterative refinement for arnoldi residual"
#define _dc_33 "_naitr: iterative refinement ; rnorm and rnorm1 are"
#define _dc_34 "1"
#define _dc_35 "_naitr: final upper hessenberg matrix h of order k+np"
#define _dc_36 "all"
#define _dc_37 "_napps: shift number."
#define _dc_38 "_napps: value of the shift "
#define _dc_39 "_napps: matrix splitting at row/column no."
#define _dc_40 "_napps: matrix splitting with shift number."
#define _dc_41 "_napps: off diagonal element."
#define _dc_42 "_napps: start of current block "
#define _dc_43 "_napps: end of current block "
#define _dc_44 "a"
#define _dc_45 "_napps: sigmak = (e_{kev+p}^t*q)*e_{kev}"
#define _dc_46 "_napps: betak = e_{kev+1}^t*h*e_{kev}"
#define _dc_47 "_napps: order of the final hessenberg matrix "
#define _dc_48 "_napps: updated hessenberg matrix h for next iteration"
#define _dc_49 "epsilon-machine"
#define _dc_50 "_naup2: **** start of major iteration number ****"
#define _dc_51 "_naup2: the length of the current arnoldi factorization"
#define _dc_52 "_naup2: extend the arnoldi factorization by"
#define _dc_53 "_naup2: corresponding b-norm of the residual"
#define _dc_54 "_naup2: nev, np, nconv are"
#define _dc_55 "_naup2: the eigenvalues of h"
#define _dc_56 "_naup2: ritz estimates of the current ncv ritz values"
#define _dc_57 "_naup2: eigenvalues computed by _neigh:"
#define _dc_58 "_naup2: ritz estimates computed by _neigh:"
#define _dc_59 "lm"
#define _dc_60 "sm"
#define _dc_61 "lr"
#define _dc_62 "sr"
#define _dc_63 "li"
#define _dc_64 "si"
#define _dc_65 "_naup2: sorted eigenvalues"
#define _dc_66 "_naup2: sorted ritz estimates."
#define _dc_67 "_naup2: no. of \"converged\" ritz values at this iter."
#define _dc_68 "_naup2: nev and np are"
#define _dc_69 "_naup2: \"wanted\" ritz values "
#define _dc_70 "_naup2: ritz estimates of the \"wanted\" values "
#define _dc_71 "_naup2: the number of shifts to apply "
#define _dc_72 "_naup2: values of the shifts"
#define _dc_73 "_naup2: ritz estimates of the shifts"
#define _dc_74 "_naup2: b-norm of residual for compressed factorization"
#define _dc_75 "_naup2: compressed upper hessenberg matrix h"
#define _dc_76 "epsmach"
#define _dc_77 "_naupd: number of update iterations taken"
#define _dc_78 "_naupd: number of wanted \"converged\" ritz values"
#define _dc_79 "_naupd: the final ritz values"
#define _dc_80 "_naupd: associated ritz estimates"
#define _dc_81 "     "
#define _dc_82 "============================================="
#define _dc_83 "= complex implicit arnoldi update code      ="
#define _dc_84 "= version number: "
#define _dc_85 " 2.3"
#define _dc_86 "                     "
#define _dc_87 " ="
#define _dc_88 "= version date:   "
#define _dc_89 " 07/31/96"
#define _dc_90 "                "
#define _dc_91 "= summary of timing statistics              ="
#define _dc_92 "total number update iterations             = "
#define _dc_93 "total number of op*x operations            = "
#define _dc_94 "total number of b*x operations             = "
#define _dc_95 "total number of reorthogonalization steps  = "
#define _dc_96 "total number of iterative refinement steps = "
#define _dc_97 "total number of restart steps              = "
#define _dc_98 "total time in user op*x operation          = "
#define _dc_99 "total time in user b*x operation           = "
#define _dc_100 "total time in arnoldi update routine       = "
#define _dc_101 "total time in naup2 routine                = "
#define _dc_102 "total time in basic arnoldi iteration loop = "
#define _dc_103 "total time in reorthogonalization phase    = "
#define _dc_104 "total time in (re)start vector generation  = "
#define _dc_105 "total time in hessenberg eig. subproblem   = "
#define _dc_106 "total time in getting the shifts           = "
#define _dc_107 "total time in applying the shifts          = "
#define _dc_108 "total time in convergence testing          = "
#define _dc_109 "total time in computing final ritz vectors = "
#define _dc_110 "_neigh: entering upper hessenberg matrix h "
#define _dc_111 "_neigh: last row of the schur matrix for h"
#define _dc_112 "right"
#define _dc_113 "back"
#define _dc_114 "_neigh: last row of the eigenvector matrix for h"
#define _dc_115 "_neigh: the eigenvalues of h"
#define _dc_116 "_neigh: ritz estimates for the eigenvalues of h"
#define _dc_117 "p"
#define _dc_118 "s"
#define _dc_119 "regulr"
#define _dc_120 "shifti"
#define _dc_121 "_neupd: ritz values passed in from _naupd."
#define _dc_122 "_neupd: ritz estimates passed in from _naupd."
#define _dc_123 "_neupd: ritz values after calling _ngets."
#define _dc_124 "_neupd: ritz value indices after calling _ngets."
#define _dc_125 "_neupd: number of specified eigenvalues"
#define _dc_126 "_neupd: number of \"converged\" eigenvalues"
#define _dc_127 "_neupd: eigenvalues of h"
#define _dc_128 "_neupd: last row of the schur vector matrix"
#define _dc_129 "_neupd: the upper triangular matrix "
#define _dc_130 "none"
#define _dc_131 "v"
#define _dc_132 "_neupd: eigenvalues of h--reordered"
#define _dc_133 "_neupd: triangular matrix after re-ordering"
#define _dc_134 "notranspose"
#define _dc_135 "select"
#define _dc_136 "_neupd: last row of the eigenvector matrix for t"
#define _dc_137 "_neupd: the eigenvector matrix for t"
#define _dc_138 "upper"
#define _dc_139 "no transpose"
#define _dc_140 "non-unit"
#define _dc_141 "_neupd: untransformed ritz values."
#define _dc_142 "_neupd: ritz estimates of the untransformed ritz values."
#define _dc_143 "_neupd: converged ritz values."
#define _dc_144 "_neupd: associated ritz estimates."
#define _dc_145 "_ngets: kev is"
#define _dc_146 "_ngets: np is"
#define _dc_147 "_ngets: eigenvalues of current h matrix "
#define _dc_148 "_ngets: ritz estimates of the current kev+np ritz values"
#define _dc_149 " - "
#define _dc_150 "t"
#define _dc_151 "    "
#define _dc_152 "  "
#define _dc_153 "       "
#define _dc_154 "      "
#define _dc_155 "_naitr: re-orthonalization; wnorm and rnorm are"
#define _dc_156 "_napps: the real part of the shift "
#define _dc_157 "_napps: the imaginary part of the shift "
#define _dc_158 "left"
#define _dc_159 "_naup2: nev, np, numcnv, nconv are"
#define _dc_160 "_naup2: real part of the eigenvalues of h"
#define _dc_161 "_naup2: imaginary part of the eigenvalues of h"
#define _dc_162 "_naup2: real part of the eig computed by _neigh:"
#define _dc_163 "_naup2: imag part of the eig computed by _neigh:"
#define _dc_164 "_naup2: ritz eistmates computed by _neigh:"
#define _dc_165 "_naup2: sorted real part of the eigenvalues"
#define _dc_166 "_naup2: sorted imaginary part of the eigenvalues"
#define _dc_167 "_naup2: \"wanted\" ritz values -- real part"
#define _dc_168 "_naup2: \"wanted\" ritz values -- imag part"
#define _dc_169 "_naup2: real part of the shifts"
#define _dc_170 "_naup2: imaginary part of the shifts"
#define _dc_171 "_naupd: real part of the final ritz values"
#define _dc_172 "_naupd: imaginary part of the final ritz values"
#define _dc_173 "= nonsymmetric implicit arnoldi update code ="
#define _dc_174 " 2.4"
#define _dc_175 "r"
#define _dc_176 "_neigh: real part of the eigenvalues of h"
#define _dc_177 "_neigh: imaginary part of the eigenvalues of h"
#define _dc_178 "realpt"
#define _dc_179 "imagpt"
#define _dc_180 "_neupd: real part of ritz values passed in from _naupd."
#define _dc_181 "_neupd: imag part of ritz values passed in from _naupd."
#define _dc_182 "_neupd: real part of ritz values after calling _ngets."
#define _dc_183 "_neupd: imag part of ritz values after calling _ngets."
#define _dc_184 "_neupd: real part of the eigenvalues of h"
#define _dc_185 "_neupd: imaginary part of the eigenvalues of h"
#define _dc_186 "_neupd: the upper quasi-triangular matrix "
#define _dc_187 "_neupd: real part of the eigenvalues of h--reordered"
#define _dc_188 "_neupd: imag part of the eigenvalues of h--reordered"
#define _dc_189 "_neupd: quasi-triangular matrix after re-ordering"
#define _dc_190 "_neupd: untransformed real part of the ritz valuess."
#define _dc_191 "_neupd: untransformed imag part of the ritz valuess."
#define _dc_192 "_neupd: ritz estimates of untransformed ritz values."
#define _dc_193 "_neupd: real parts of converged ritz values."
#define _dc_194 "_neupd: imag parts of converged ritz values."
#define _dc_195 "_ngets: eigenvalues of current h matrix -- real part"
#define _dc_196 "_ngets: eigenvalues of current h matrix -- imag part"
#define _dc_197 "safmin"
#define _dc_198 "_saitr: generating arnoldi vector no."
#define _dc_199 "_saitr: b-norm of the current residual ="
#define _dc_200 "_saitr: ****** restart at step ******"
#define _dc_201 "_saitr: re-orthonalization ; wnorm and rnorm are"
#define _dc_202 "_saitr: iterative refinement for arnoldi residual"
#define _dc_203 "_saitr: iterative refinement ; rnorm and rnorm1 are"
#define _dc_204 "_saitr: main diagonal of matrix h of step k+np."
#define _dc_205 "_saitr: sub diagonal of matrix h of step k+np."
#define _dc_206 "_sapps: deflation at row/column no."
#define _dc_207 "_sapps: occured before shift number."
#define _dc_208 "_sapps: the corresponding off diagonal element"
#define _dc_209 "_sapps: sigmak of the updated residual vector"
#define _dc_210 "_sapps: betak of the updated residual vector"
#define _dc_211 "_sapps: updated main diagonal of h for next iteration"
#define _dc_212 "_sapps: updated sub diagonal of h for next iteration"
#define _dc_213 "_saup2: **** start of major iteration number ****"
#define _dc_214 "_saup2: the length of the current lanczos factorization"
#define _dc_215 "_saup2: extend the lanczos factorization by"
#define _dc_216 "_saup2: current b-norm of residual for factorization"
#define _dc_217 "_saup2: nev, np, nconv are"
#define _dc_218 "_saup2: the eigenvalues of h"
#define _dc_219 "_saup2: ritz estimates of the current ncv ritz values"
#define _dc_220 "be"
#define _dc_221 "sa"
#define _dc_222 "la"
#define _dc_223 "_saup2: sorted ritz values."
#define _dc_224 "_saup2: sorted ritz estimates."
#define _dc_225 "_saup2: no. of \"converged\" ritz values at this iter."
#define _dc_226 "_saup2: nev and np are"
#define _dc_227 "_saup2: \"wanted\" ritz values."
#define _dc_228 "_saup2: ritz estimates of the \"wanted\" values "
#define _dc_229 "_saup2: the number of shifts to apply "
#define _dc_230 "_saup2: shifts selected"
#define _dc_231 "_saup2: corresponding ritz estimates"
#define _dc_232 "_saup2: b-norm of residual for nev factorization"
#define _dc_233 "_saup2: main diagonal of compressed h matrix"
#define _dc_234 "_saup2: subdiagonal of compressed h matrix"
#define _dc_235 "_saupd: number of update iterations taken"
#define _dc_236 "_saupd: number of \"converged\" ritz values"
#define _dc_237 "_saupd: final ritz values"
#define _dc_238 "_saupd: corresponding error bounds"
#define _dc_239 "=========================================="
#define _dc_240 "= symmetric implicit arnoldi update code ="
#define _dc_241 "= version number:"
#define _dc_242 "                   "
#define _dc_243 "= version date:  "
#define _dc_244 "              "
#define _dc_245 "= summary of timing statistics           ="
#define _dc_246 "total time in saup2 routine                = "
#define _dc_247 "total time in trid eigenvalue subproblem   = "
#define _dc_248 "_seigt: main diagonal of matrix h"
#define _dc_249 "_seigt: sub diagonal of matrix h"
#define _dc_250 "_seigt: last row of the eigenvector matrix for h"
#define _dc_251 "buckle"
#define _dc_252 "cayley"
#define _dc_253 "_seupd: ritz values passed in from _saupd."
#define _dc_254 "_seupd: ritz estimates passed in from _saupd."
#define _dc_255 "_seupd: ritz values after calling _sgets."
#define _dc_256 "_seupd: ritz value indices after calling _sgets."
#define _dc_257 "_seupd: number of specified eigenvalues"
#define _dc_258 "_seupd: number of \"converged\" eigenvalues"
#define _dc_259 "identity"
#define _dc_260 "_seupd: ncv ritz values of the final h matrix"
#define _dc_261 "_seupd: last row of the eigenvector matrix for h"
#define _dc_262 "_seupd: the eigenvalues of h--reordered"
#define _dc_263 "transpose"
#define _dc_264 "_seupd: untransformed converged ritz values"
#define _dc_265 "_seupd: ritz estimates of the untransformed ritz values"
#define _dc_266 "_seupd: converged ritz values"
#define _dc_267 "_seupd: associated ritz estimates"
#define _dc_268 "_sgets: kev is"
#define _dc_269 "_sgets: np is"
#define _dc_270 "_sgets: eigenvalues of current h matrix"
#define _dc_271 "_sgets: associated ritz estimates"
#define _dc_272 "e"
#define _dc_273 "b"
#define _dc_274 "f"
static FORMAT *__fmt_a = NULL;
typedef char char_1[2];
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
typedef char char_127[128];
#define __ncalls 83
static CALLS __calls[__ncalls] = {
  {"cgetv0", 0}, // subroutine
  {"cmout", 0}, // subroutine
  {"cnaitr", 0}, // subroutine
  {"cnapps", 0}, // subroutine
  {"cnaup2", 0}, // subroutine
  {"cnaupd", 0}, // subroutine
  {"cneigh", 0}, // subroutine
  {"cneupd", 0}, // subroutine
  {"cngets", 0}, // subroutine
  {"csortc", 0}, // subroutine
  {"cstatn", 0}, // subroutine
  {"cvout", 0}, // subroutine
  {"dgetv0", 0}, // subroutine
  {"dlaqrb", 0}, // subroutine
  {"dmout", 0}, // subroutine
  {"dnaitr", 0}, // subroutine
  {"dnapps", 0}, // subroutine
  {"dnaup2", 0}, // subroutine
  {"dnaupd", 0}, // subroutine
  {"dnconv", 0}, // subroutine
  {"dneigh", 0}, // subroutine
  {"dneupd", 0}, // subroutine
  {"dngets", 0}, // subroutine
  {"dsaitr", 0}, // subroutine
  {"dsapps", 0}, // subroutine
  {"dsaup2", 0}, // subroutine
  {"dsaupd", 0}, // subroutine
  {"dsconv", 0}, // subroutine
  {"dseigt", 0}, // subroutine
  {"dsesrt", 0}, // subroutine
  {"dseupd", 0}, // subroutine
  {"dsgets", 0}, // subroutine
  {"dsortc", 0}, // subroutine
  {"dsortr", 0}, // subroutine
  {"dstatn", 0}, // subroutine
  {"dstats", 0}, // subroutine
  {"dstqrb", 0}, // subroutine
  {"dvout", 0}, // subroutine
  {"icnteq", 0}, // integer*4 function
  {"icopy", 0}, // subroutine
  {"iset", 0}, // subroutine
  {"iswap", 0}, // subroutine
  {"ivout", 0}, // subroutine
  {"second", 0}, // subroutine
  {"sgetv0", 0}, // subroutine
  {"slaqrb", 0}, // subroutine
  {"smout", 0}, // subroutine
  {"snaitr", 0}, // subroutine
  {"snapps", 0}, // subroutine
  {"snaup2", 0}, // subroutine
  {"snaupd", 0}, // subroutine
  {"snconv", 0}, // subroutine
  {"sneigh", 0}, // subroutine
  {"sneupd", 0}, // subroutine
  {"sngets", 0}, // subroutine
  {"ssaitr", 0}, // subroutine
  {"ssapps", 0}, // subroutine
  {"ssaup2", 0}, // subroutine
  {"ssaupd", 0}, // subroutine
  {"ssconv", 0}, // subroutine
  {"sseigt", 0}, // subroutine
  {"ssesrt", 0}, // subroutine
  {"sseupd", 0}, // subroutine
  {"ssgets", 0}, // subroutine
  {"ssortc", 0}, // subroutine
  {"ssortr", 0}, // subroutine
  {"sstatn", 0}, // subroutine
  {"sstats", 0}, // subroutine
  {"sstqrb", 0}, // subroutine
  {"svout", 0}, // subroutine
  {"zgetv0", 0}, // subroutine
  {"zmout", 0}, // subroutine
  {"znaitr", 0}, // subroutine
  {"znapps", 0}, // subroutine
  {"znaup2", 0}, // subroutine
  {"znaupd", 0}, // subroutine
  {"zneigh", 0}, // subroutine
  {"zneupd", 0}, // subroutine
  {"zngets", 0}, // subroutine
  {"zsortc", 0}, // subroutine
  {"zstatn", 0}, // subroutine
  {"zvout", 0}, // subroutine
  {NULL, 0}
};

static struct {
  int_4 logfil_, ndigit_, mgetv0_, msaupd_, msaup2_, msaitr_, mseigt_, msapps_, msgets_, mseupd_, mnaupd_, mnaup2_, 
  mnaitr_, mneigh_, mnapps_, mngets_, mneupd_, mcaupd_, mcaup2_, mcaitr_, mceigh_, mcapps_, mcgets_, mceupd_;
} debug_;
static struct {
  int_4 nopx_, nbx_, nrorth_, nitref_, nrstrt_;
  real_4 tsaupd_, tsaup2_, tsaitr_, tseigt_, tsgets_, tsapps_, tsconv_, tnaupd_, tnaup2_, tnaitr_, tneigh_, tngets_, 
  tnapps_, tnconv_, tcaupd_, tcaup2_, tcaitr_, tceigh_, tcgets_, tcapps_, tcconv_, tmvopx_, tmvbx_, tgetv0_, titref_, 
  trvec_;
} timing_;
prototype int_4 _cgetv0 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ itry_, logical_4 _p_ initv_, int_4 _p_ n_, int_4 _p_ 
j_, complex_8 _p_ v_, int_4 _p_ ldv_, complex_8 _p_ resid_, real_4 _p_ rnorm_, int_4 _p_ ipntr_, complex_8 _p_ workd_, 
int_4 _p_ ierr_);
prototype int_4 _cmout (int_4 _p_ lout_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ 
idigit_, char _p_ ifmt_);
prototype int_4 _cnaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ nb_, 
complex_8 _p_ resid_, real_4 _p_ rnorm_, complex_8 _p_ v_, int_4 _p_ ldv_, complex_8 _p_ h_, int_4 _p_ ldh_, int_4 _p_ 
ipntr_, complex_8 _p_ workd_, int_4 _p_ info_);
prototype int_4 _cnapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, complex_8 _p_ shift_, complex_8 _p_ v_, int_4 _p_ 
ldv_, complex_8 _p_ h_, int_4 _p_ ldh_, complex_8 _p_ resid_, complex_8 _p_ q_, int_4 _p_ ldq_, complex_8 _p_ workl_, 
complex_8 _p_ workd_);
prototype int_4 _cnaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, 
real_4 _p_ tol_, complex_8 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, 
complex_8 _p_ v_, int_4 _p_ ldv_, complex_8 _p_ h_, int_4 _p_ ldh_, complex_8 _p_ ritz_, complex_8 _p_ bounds_, 
complex_8 _p_ q_, int_4 _p_ ldq_, complex_8 _p_ workl_, int_4 _p_ ipntr_, complex_8 _p_ workd_, real_4 _p_ rwork_, 
int_4 _p_ info_);
prototype int_4 _cnaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_
, complex_8 _p_ resid_, int_4 _p_ ncv_, complex_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, 
complex_8 _p_ workd_, complex_8 _p_ workl_, int_4 _p_ lworkl_, real_4 _p_ rwork_, int_4 _p_ info_);
prototype int_4 _cneigh (real_4 _p_ rnorm_, int_4 _p_ n_, complex_8 _p_ h_, int_4 _p_ ldh_, complex_8 _p_ ritz_, 
complex_8 _p_ bounds_, complex_8 _p_ q_, int_4 _p_ ldq_, complex_8 _p_ workl_, real_4 _p_ rwork_, int_4 _p_ ierr_);
prototype int_4 _cneupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, complex_8 _p_ d_, complex_8 _p_ 
z_, int_4 _p_ ldz_, complex_8 _p_ sigma_, complex_8 _p_ workev_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 
_p_ nev_, real_4 _p_ tol_, complex_8 _p_ resid_, int_4 _p_ ncv_, complex_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, 
int_4 _p_ ipntr_, complex_8 _p_ workd_, complex_8 _p_ workl_, int_4 _p_ lworkl_, real_4 _p_ rwork_, int_4 _p_ info_);
prototype int_4 _cngets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, complex_8 _p_ ritz_, 
complex_8 _p_ bounds_);
prototype int_4 _csortc (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, complex_8 _p_ x_, complex_8 _p_ y_);
prototype int_4 _cstatn (void);
prototype int_4 _cvout (int_4 _p_ lout_, int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ idigit_, char _p_ ifmt_);
prototype int_4 _dgetv0 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ itry_, logical_4 _p_ initv_, int_4 _p_ n_, int_4 _p_ 
j_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ resid_, real_8 _p_ rnorm_, int_4 _p_ ipntr_, real_8 _p_ workd_, int_4 _p_ 
ierr_);
prototype int_4 _dlaqrb (logical_4 _p_ wantt_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, real_8 _p_ h_, int_4 _p_ 
ldh_, real_8 _p_ wr_, real_8 _p_ wi_, real_8 _p_ z_, int_4 _p_ info_);
prototype int_4 _dmout (int_4 _p_ lout_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ idigit_, 
char _p_ ifmt_);
prototype int_4 _dnaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ nb_, 
real_8 _p_ resid_, real_8 _p_ rnorm_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, 
real_8 _p_ workd_, int_4 _p_ info_);
prototype int_4 _dnapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, real_8 _p_ shiftr_, real_8 _p_ shifti_, real_8 
_p_ v_, int_4 _p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ resid_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ 
workl_, real_8 _p_ workd_);
prototype int_4 _dnaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, 
real_8 _p_ tol_, real_8 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, real_8 _p_ 
v_, int_4 _p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ ritzr_, real_8 _p_ ritzi_, real_8 _p_ bounds_, real_8 _p_ 
q_, int_4 _p_ ldq_, real_8 _p_ workl_, int_4 _p_ ipntr_, real_8 _p_ workd_, int_4 _p_ info_);
prototype int_4 _dnaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_
, real_8 _p_ resid_, int_4 _p_ ncv_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_8 _p_ 
workd_, real_8 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_);
prototype int_4 _dnconv (int_4 _p_ n_, real_8 _p_ ritzr_, real_8 _p_ ritzi_, real_8 _p_ bounds_, real_8 _p_ tol_, int_4 
_p_ nconv_);
prototype int_4 _dneigh (real_8 _p_ rnorm_, int_4 _p_ n_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ ritzr_, real_8 _p_ 
ritzi_, real_8 _p_ bounds_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ workl_, int_4 _p_ ierr_);
prototype int_4 _dneupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, real_8 _p_ dr_, real_8 _p_ di_, 
real_8 _p_ z_, int_4 _p_ ldz_, real_8 _p_ sigmar_, real_8 _p_ sigmai_, real_8 _p_ workev_, char _p_ bmat_, int_4 _p_ n_
, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_, real_8 _p_ resid_, int_4 _p_ ncv_, real_8 _p_ v_, int_4 _p_ ldv_, 
int_4 _p_ iparam_, int_4 _p_ ipntr_, real_8 _p_ workd_, real_8 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_);
prototype int_4 _dngets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, real_8 _p_ ritzr_, real_8 
_p_ ritzi_, real_8 _p_ bounds_, real_8 _p_ shiftr_, real_8 _p_ shifti_);
prototype int_4 _dsaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ mode_, 
real_8 _p_ resid_, real_8 _p_ rnorm_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, 
real_8 _p_ workd_, int_4 _p_ info_);
prototype int_4 _dsapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, real_8 _p_ shift_, real_8 _p_ v_, int_4 _p_ ldv_, 
real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ resid_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ workd_);
prototype int_4 _dsaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, 
real_8 _p_ tol_, real_8 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, real_8 _p_ 
v_, int_4 _p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ ritz_, real_8 _p_ bounds_, real_8 _p_ q_, int_4 _p_ ldq_, 
real_8 _p_ workl_, int_4 _p_ ipntr_, real_8 _p_ workd_, int_4 _p_ info_);
prototype int_4 _dsaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_
, real_8 _p_ resid_, int_4 _p_ ncv_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_8 _p_ 
workd_, real_8 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_);
prototype int_4 _dsconv (int_4 _p_ n_, real_8 _p_ ritz_, real_8 _p_ bounds_, real_8 _p_ tol_, int_4 _p_ nconv_);
prototype int_4 _dseigt (real_8 _p_ rnorm_, int_4 _p_ n_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ eig_, real_8 _p_ 
bounds_, real_8 _p_ workl_, int_4 _p_ ierr_);
prototype int_4 _dsesrt (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ na_, real_8 _p_ 
a_, int_4 _p_ lda_);
prototype int_4 _dseupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, real_8 _p_ d_, real_8 _p_ z_, 
int_4 _p_ ldz_, real_8 _p_ sigma_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_, 
real_8 _p_ resid_, int_4 _p_ ncv_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_8 _p_ 
workd_, real_8 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_);
prototype int_4 _dsgets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, real_8 _p_ ritz_, real_8 
_p_ bounds_, real_8 _p_ shifts_);
prototype int_4 _dsortc (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_8 _p_ xreal_, real_8 _p_ ximag_, 
real_8 _p_ y_);
prototype int_4 _dsortr (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_8 _p_ x1_, real_8 _p_ x2_);
prototype int_4 _dstatn (void);
prototype int_4 _dstats (void);
prototype int_4 _dstqrb (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dvout (int_4 _p_ lout_, int_4 _p_ n_, real_8 _p_ sx_, int_4 _p_ idigit_, char _p_ ifmt_);
prototype int_4 _icnteq (int_4 _p_ n_, int_4 _p_ array_, int_4 _p_ value_);
prototype int_4 _icopy (int_4 _p_ n_, int_4 _p_ lx_, int_4 _p_ incx_, int_4 _p_ ly_, int_4 _p_ incy_);
prototype int_4 _iset (int_4 _p_ n_, int_4 _p_ value_, int_4 _p_ array_, int_4 _p_ inc_);
prototype int_4 _iswap (int_4 _p_ n_, int_4 _p_ sx_, int_4 _p_ incx_, int_4 _p_ sy_, int_4 _p_ incy_);
prototype int_4 _ivout (int_4 _p_ lout_, int_4 _p_ n_, int_4 _p_ ix_, int_4 _p_ idigit_, char _p_ ifmt_);
prototype int_4 _second (real_4 _p_ t_);
prototype int_4 _sgetv0 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ itry_, logical_4 _p_ initv_, int_4 _p_ n_, int_4 _p_ 
j_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ resid_, real_4 _p_ rnorm_, int_4 _p_ ipntr_, real_4 _p_ workd_, int_4 _p_ 
ierr_);
prototype int_4 _slaqrb (logical_4 _p_ wantt_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, real_4 _p_ h_, int_4 _p_ 
ldh_, real_4 _p_ wr_, real_4 _p_ wi_, real_4 _p_ z_, int_4 _p_ info_);
prototype int_4 _smout (int_4 _p_ lout_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ idigit_, 
char _p_ ifmt_);
prototype int_4 _snaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ nb_, 
real_4 _p_ resid_, real_4 _p_ rnorm_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, 
real_4 _p_ workd_, int_4 _p_ info_);
prototype int_4 _snapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, real_4 _p_ shiftr_, real_4 _p_ shifti_, real_4 
_p_ v_, int_4 _p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ resid_, real_4 _p_ q_, int_4 _p_ ldq_, real_4 _p_ 
workl_, real_4 _p_ workd_);
prototype int_4 _snaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, 
real_4 _p_ tol_, real_4 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, real_4 _p_ 
v_, int_4 _p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ ritzr_, real_4 _p_ ritzi_, real_4 _p_ bounds_, real_4 _p_ 
q_, int_4 _p_ ldq_, real_4 _p_ workl_, int_4 _p_ ipntr_, real_4 _p_ workd_, int_4 _p_ info_);
prototype int_4 _snaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_
, real_4 _p_ resid_, int_4 _p_ ncv_, real_4 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_4 _p_ 
workd_, real_4 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_);
prototype int_4 _snconv (int_4 _p_ n_, real_4 _p_ ritzr_, real_4 _p_ ritzi_, real_4 _p_ bounds_, real_4 _p_ tol_, int_4 
_p_ nconv_);
prototype int_4 _sneigh (real_4 _p_ rnorm_, int_4 _p_ n_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ ritzr_, real_4 _p_ 
ritzi_, real_4 _p_ bounds_, real_4 _p_ q_, int_4 _p_ ldq_, real_4 _p_ workl_, int_4 _p_ ierr_);
prototype int_4 _sneupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, real_4 _p_ dr_, real_4 _p_ di_, 
real_4 _p_ z_, int_4 _p_ ldz_, real_4 _p_ sigmar_, real_4 _p_ sigmai_, real_4 _p_ workev_, char _p_ bmat_, int_4 _p_ n_
, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_, real_4 _p_ resid_, int_4 _p_ ncv_, real_4 _p_ v_, int_4 _p_ ldv_, 
int_4 _p_ iparam_, int_4 _p_ ipntr_, real_4 _p_ workd_, real_4 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_);
prototype int_4 _sngets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, real_4 _p_ ritzr_, real_4 
_p_ ritzi_, real_4 _p_ bounds_, real_4 _p_ shiftr_, real_4 _p_ shifti_);
prototype int_4 _ssaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ mode_, 
real_4 _p_ resid_, real_4 _p_ rnorm_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, 
real_4 _p_ workd_, int_4 _p_ info_);
prototype int_4 _ssapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, real_4 _p_ shift_, real_4 _p_ v_, int_4 _p_ ldv_, 
real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ resid_, real_4 _p_ q_, int_4 _p_ ldq_, real_4 _p_ workd_);
prototype int_4 _ssaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, 
real_4 _p_ tol_, real_4 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, real_4 _p_ 
v_, int_4 _p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ ritz_, real_4 _p_ bounds_, real_4 _p_ q_, int_4 _p_ ldq_, 
real_4 _p_ workl_, int_4 _p_ ipntr_, real_4 _p_ workd_, int_4 _p_ info_);
prototype int_4 _ssaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_
, real_4 _p_ resid_, int_4 _p_ ncv_, real_4 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_4 _p_ 
workd_, real_4 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_);
prototype int_4 _ssconv (int_4 _p_ n_, real_4 _p_ ritz_, real_4 _p_ bounds_, real_4 _p_ tol_, int_4 _p_ nconv_);
prototype int_4 _sseigt (real_4 _p_ rnorm_, int_4 _p_ n_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ eig_, real_4 _p_ 
bounds_, real_4 _p_ workl_, int_4 _p_ ierr_);
prototype int_4 _ssesrt (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_4 _p_ x_, int_4 _p_ na_, real_4 _p_ 
a_, int_4 _p_ lda_);
prototype int_4 _sseupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, real_4 _p_ d_, real_4 _p_ z_, 
int_4 _p_ ldz_, real_4 _p_ sigma_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_, 
real_4 _p_ resid_, int_4 _p_ ncv_, real_4 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_4 _p_ 
workd_, real_4 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_);
prototype int_4 _ssgets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, real_4 _p_ ritz_, real_4 
_p_ bounds_, real_4 _p_ shifts_);
prototype int_4 _ssortc (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_4 _p_ xreal_, real_4 _p_ ximag_, 
real_4 _p_ y_);
prototype int_4 _ssortr (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_4 _p_ x1_, real_4 _p_ x2_);
prototype int_4 _sstatn (void);
prototype int_4 _sstats (void);
prototype int_4 _sstqrb (int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ z_, real_4 _p_ work_, int_4 _p_ info_);
prototype int_4 _svout (int_4 _p_ lout_, int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ idigit_, char _p_ ifmt_);
prototype int_4 _zgetv0 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ itry_, logical_4 _p_ initv_, int_4 _p_ n_, int_4 _p_ 
j_, complex_16 _p_ v_, int_4 _p_ ldv_, complex_16 _p_ resid_, real_8 _p_ rnorm_, int_4 _p_ ipntr_, complex_16 _p_ 
workd_, int_4 _p_ ierr_);
prototype int_4 _zmout (int_4 _p_ lout_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ 
idigit_, char _p_ ifmt_);
prototype int_4 _znaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ nb_, 
complex_16 _p_ resid_, real_8 _p_ rnorm_, complex_16 _p_ v_, int_4 _p_ ldv_, complex_16 _p_ h_, int_4 _p_ ldh_, int_4 
_p_ ipntr_, complex_16 _p_ workd_, int_4 _p_ info_);
prototype int_4 _znapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, complex_16 _p_ shift_, complex_16 _p_ v_, int_4 
_p_ ldv_, complex_16 _p_ h_, int_4 _p_ ldh_, complex_16 _p_ resid_, complex_16 _p_ q_, int_4 _p_ ldq_, complex_16 _p_ 
workl_, complex_16 _p_ workd_);
prototype int_4 _znaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, 
real_8 _p_ tol_, complex_16 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, 
complex_16 _p_ v_, int_4 _p_ ldv_, complex_16 _p_ h_, int_4 _p_ ldh_, complex_16 _p_ ritz_, complex_16 _p_ bounds_, 
complex_16 _p_ q_, int_4 _p_ ldq_, complex_16 _p_ workl_, int_4 _p_ ipntr_, complex_16 _p_ workd_, real_8 _p_ rwork_, 
int_4 _p_ info_);
prototype int_4 _znaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_
, complex_16 _p_ resid_, int_4 _p_ ncv_, complex_16 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, 
complex_16 _p_ workd_, complex_16 _p_ workl_, int_4 _p_ lworkl_, real_8 _p_ rwork_, int_4 _p_ info_);
prototype int_4 _zneigh (real_8 _p_ rnorm_, int_4 _p_ n_, complex_16 _p_ h_, int_4 _p_ ldh_, complex_16 _p_ ritz_, 
complex_16 _p_ bounds_, complex_16 _p_ q_, int_4 _p_ ldq_, complex_16 _p_ workl_, real_8 _p_ rwork_, int_4 _p_ ierr_);
prototype int_4 _zneupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, complex_16 _p_ d_, complex_16 
_p_ z_, int_4 _p_ ldz_, complex_16 _p_ sigma_, complex_16 _p_ workev_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, 
int_4 _p_ nev_, real_8 _p_ tol_, complex_16 _p_ resid_, int_4 _p_ ncv_, complex_16 _p_ v_, int_4 _p_ ldv_, int_4 _p_ 
iparam_, int_4 _p_ ipntr_, complex_16 _p_ workd_, complex_16 _p_ workl_, int_4 _p_ lworkl_, real_8 _p_ rwork_, int_4 
_p_ info_);
prototype int_4 _zngets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, complex_16 _p_ ritz_, 
complex_16 _p_ bounds_);
prototype int_4 _zsortc (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, complex_16 _p_ x_, complex_16 _p_ y_);
prototype int_4 _zstatn (void);
prototype int_4 _zvout (int_4 _p_ lout_, int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ idigit_, char _p_ ifmt_);
int_4 _cgetv0 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ itry_, logical_4 _p_ initv_, int_4 _p_ n_, int_4 _p_ j_, 
complex_8 _p_ v_, int_4 _p_ ldv_, complex_8 _p_ resid_, real_4 _p_ rnorm_, int_4 _p_ ipntr_, complex_8 _p_ workd_, 
int_4 _p_ ierr_)
{
  static int_4 idist_, iseed_[4], iter_, msglvl_, jj_;
  static logical_4 first_, inits_, orth_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, rnorm0_;
  static complex_8 cnorm_;
  int_4 _data_k_0, $2_, $5_;
  real_4 $0_, $1_, $8_, $9_;
  complex_8 $3_, $4_, $6_, $7_;
  extern int_4 _ccopy ();
  extern int_4 _cgemv ();
  extern int_4 _clarnv ();
  extern real_4 _scnrm2 ();
  extern real_4 _slapy2 ();
  extern complex_8 _cdotc ();
#define _data_n_0 1
  static logical_4 _data_l_0[_data_n_0] = {
    TRUE
  };
  if (__calls[0].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    inits_ = _data_l_0[_data_k_0++];
  }
  if (inits_) {
    iseed_[0] = 1;
    iseed_[1] = 3;
    iseed_[2] = 5;
    iseed_[3] = 7;
    inits_ = FALSE;
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mgetv0_;
    (*ierr_) = 0;
    iter_ = 0;
    first_ = FALSE;
    orth_ = FALSE;
    if (! ((*initv_))) {
      idist_ = 2;
      (void) _clarnv (&idist_, iseed_, n_, resid_);
    }
    (void) _second (&t2_);
    if ((strcasecmp (bmat_, _dc_0) == 0)) {
      timing_.nopx_ = timing_.nopx_ + 1;
      ipntr_[0] = 1;
      ipntr_[1] = (*n_) + 1;
      (void) _ccopy (n_, resid_, &_k1, workd_, &_k1);
      (*ido_) = -1;
      goto _l9000;
    }
  }
  if (first_) {
    goto _l20;
  }
  if (orth_) {
    goto _l40;
  }
  (void) _second (&t3_);
  timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  (void) _second (&t2_);
  first_ = TRUE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _ccopy (n_, &workd_[(*n_) + 1 - 1], &_k1, resid_, &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _ccopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l20:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  first_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _cdotc (n_, resid_, &_k1, workd_, &_k1);
    rnorm0_ = sqrtf (_slapy2 (($0_ = (real_4) (crealf (cnorm_)), &$0_), ($1_ = cimagf (cnorm_), &$1_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm0_ = _scnrm2 (n_, resid_, &_k1);
  }
  (*rnorm_) = rnorm0_;
  if ((*j_) == 1) {
    goto _l50;
  }
  orth_ = TRUE;
  _l30:;
  (void) _cgemv (_dc_2, n_, ($2_ = (*j_) - 1, &$2_), ($3_ = CMPLXF (1.0, 0.0), &$3_), v_, ldv_, workd_, &_k1, ($4_ = 
  CMPLXF (0.0, 0.0), &$4_), &workd_[(*n_) + 1 - 1], &_k1);
  (void) _cgemv (_dc_3, n_, ($5_ = (*j_) - 1, &$5_), ($6_ = CMPLXF (-1.0, 0.0), &$6_), v_, ldv_, &workd_[(*n_) + 1 - 1], 
  &_k1, ($7_ = CMPLXF (1.0, 0.0), &$7_), resid_, &_k1);
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _ccopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _ccopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l40:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _cdotc (n_, resid_, &_k1, workd_, &_k1);
    (*rnorm_) = sqrtf (_slapy2 (($8_ = (real_4) (crealf (cnorm_)), &$8_), ($9_ = cimagf (cnorm_), &$9_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _scnrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _svout (&debug_.logfil_, &_k1, &rnorm0_, &debug_.ndigit_, _dc_4);
    (void) _svout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_5);
  }
  if ((*rnorm_) > 0.717 * rnorm0_) {
    goto _l50;
  }
  iter_ = iter_ + 1;
  if (iter_ <= 1) {
    rnorm0_ = (*rnorm_);
    goto _l30;
  }
  else {
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = CMPLXF (0.0, 0.0);
    }
    (*rnorm_) = 0.0;
    (*ierr_) = -1;
  }
  _l50:;
  if (msglvl_ > 0) {
    (void) _svout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_6);
  }
  if (msglvl_ > 2) {
    (void) _cvout (&debug_.logfil_, n_, resid_, &debug_.ndigit_, _dc_7);
  }
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tgetv0_ = timing_.tgetv0_ + (t1_ - t0_);
  _l9000:;
  __calls[0].calls++;
  return 0;
}

int_4 _cmout (int_4 _p_ lout_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ idigit_, char 
_p_ ifmt_)
{
  static int_4 i_, j_, ndigit_, k1_, k2_, lll_;
  static char_1 icol_[3];
  static char_127 line_;
  int_4 _data_k_1, $u_0_, __fcnt, __rc, $u_3_, _k_5, $u_6_, $u_7_, $u_8_, _k_10, $u_11_, $u_12_, $u_13_, _k_15, $u_16_, 
  $u_17_, $u_18_, _k_20, $u_21_, $u_22_, _k_24, $u_25_, $u_26_, $u_27_, $u_28_, $u_29_, _k_31, $u_32_, $u_33_, $u_34_, 
  $u_35_, _k_37, $u_38_, $u_39_, $u_40_, $u_41_, _k_43, $u_44_, $u_45_, $u_46_;
  char_1 _p_ _arr_4, _p_ _arr_9, _p_ _arr_14, _p_ _arr_19, _p_ _arr_23, _p_ _arr_30, _p_ _arr_36, _p_ _arr_42;
  char_127 $1_, $2_;
  static FORMAT $f_9999_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_9998_[] = {
    FMT_TEXT, _dc_12, _dc_12,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_13, _dc_13,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_13, _dc_13,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_13, _dc_13,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_13, _dc_13,
    NULL, NULL, NULL
  };
  static FORMAT $f_9997_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_12, _dc_12,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_12, _dc_12,
    FMT_TEXT, _dc_12, _dc_12,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_12, _dc_12,
    FMT_TEXT, _dc_12, _dc_12,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_12, _dc_12,
    FMT_TEXT, _dc_12, _dc_12,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_12, _dc_12,
    NULL, NULL, NULL
  };
  static FORMAT $f_9996_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_15, _dc_15,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_15, _dc_15,
    FMT_TEXT, _dc_15, _dc_15,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_15, _dc_15,
    FMT_TEXT, _dc_15, _dc_15,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_15, _dc_15,
    NULL, NULL, NULL
  };
  static FORMAT $f_9995_[] = {
    FMT_TEXT, _dc_16, _dc_16,
    FMT_TEXT, _dc_17, _dc_17,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_17, _dc_17,
    FMT_TEXT, _dc_17, _dc_17,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_17, _dc_17,
    NULL, NULL, NULL
  };
  static FORMAT $f_9994_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9984_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9993_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9983_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9992_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9982_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9991_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_23, _dc_23,
    NULL, NULL, NULL
  };
  static FORMAT $f_9990_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  static FORMAT $f_9974_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9964_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9954_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9944_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9973_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9963_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9953_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9972_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9962_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9952_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9971_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9961_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
#define _data_n_1 3
  static char_1 _data_l_1[_data_n_1] = {
    _dc_2,
    _dc_8,
    _dc_9
  };
  if (__calls[1].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    bufcpy (icol_[0], _data_l_1[_data_k_1++], 1);
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    bufcpy (icol_[1], _data_l_1[_data_k_1++], 1);
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    bufcpy (icol_[2], _data_l_1[_data_k_1++], 1);
  }
  lll_ = _min ((int_4) strlen (ifmt_), 80);
  for (i_ = 1; i_ <= lll_; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_10);
  }
  for (i_ = lll_ + 1; i_ <= 80; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_11);
  }
  $u_0_ = (*lout_);
  _fcheck ("arpack:cmout:54", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:cmout:54", $u_0_));
    __fcnt += 3;
  }
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:cmout:54", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], ifmt_, CHARACTER, 0);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:cmout:54", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:cmout:54", $u_0_));
    __fcnt += 3;
  }
  bufcpy ($2_, _bufsub ((char *) $1_, (char *) line_, 1, lll_), 127);
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:cmout:54", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], $2_, CHARACTER, 127);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:cmout:54", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:cmout:54", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  _l9999:;
  if ((*m_) <= 0 || (*n_) <= 0 || (*lda_) <= 0) {
    goto _l0;
  }
  ndigit_ = (*idigit_);
  if ((*idigit_) == 0) {
    ndigit_ = 4;
  }
  if ((*idigit_) < 0) {
    ndigit_ = -(*idigit_);
    if (ndigit_ <= 4) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_3_ = (*lout_);
        _fcheck ("arpack:cmout:72", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:cmout:72", $u_3_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_4 = (char_1 _p_) icol_, _k_5 = 0; _k_5 < 3; _arr_4++, _k_5++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_3_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_3_, _ioerr_write ("arpack:cmout:72", $u_3_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], _arr_4, CHARACTER, 1);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:cmout:72", $u_3_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:cmout:72", $u_3_));
              __fcnt += 3;
            }
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:cmout:72", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:cmout:72", $u_3_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:cmout:72", $u_3_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_3_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if (k1_ != (*n_)) {
            $u_6_ = (*lout_);
            _fcheck ("arpack:cmout:75", $u_6_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
              __fcnt += 3;
            }
            if ($f_9994_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_6_].unit, "\n");
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
            __fcnt += 3;
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9994_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_6_].unit, "\n");
                while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
              __fcnt += 3;
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
                __fcnt += 3;
              }
              if ($f_9994_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_6_].unit, "\n");
                while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
              __fcnt += 3;
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:cmout:75", $u_6_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_6_);
          }
          else {
            $u_7_ = (*lout_);
            _fcheck ("arpack:cmout:77", $u_7_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
              __fcnt += 3;
            }
            if ($f_9984_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_7_].unit, "\n");
              while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
            __fcnt += 3;
            while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
              if ($f_9984_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9984_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_7_].unit, "\n");
                while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
              __fcnt += 3;
              while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                if ($f_9984_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
                __fcnt += 3;
              }
              if ($f_9984_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_7_].unit, "\n");
                while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
              __fcnt += 3;
              while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                if ($f_9984_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:cmout:77", $u_7_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_7_);
          }
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_8_ = (*lout_);
        _fcheck ("arpack:cmout:85", $u_8_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:cmout:85", $u_8_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_9 = (char_1 _p_) icol_, _k_10 = 0; _k_10 < 3; _arr_9++, _k_10++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_8_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_8_, _ioerr_write ("arpack:cmout:85", $u_8_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], _arr_9, CHARACTER, 1);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:cmout:85", $u_8_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:cmout:85", $u_8_));
              __fcnt += 3;
            }
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:cmout:85", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:cmout:85", $u_8_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:cmout:85", $u_8_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_8_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if (k1_ != (*n_)) {
            $u_11_ = (*lout_);
            _fcheck ("arpack:cmout:88", $u_11_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
              __fcnt += 3;
            }
            if ($f_9993_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_11_].unit, "\n");
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
            __fcnt += 3;
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9993_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_11_].unit, "\n");
                while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
              __fcnt += 3;
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
                __fcnt += 3;
              }
              if ($f_9993_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_11_].unit, "\n");
                while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
              __fcnt += 3;
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:cmout:88", $u_11_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_11_);
          }
          else {
            $u_12_ = (*lout_);
            _fcheck ("arpack:cmout:90", $u_12_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
              __fcnt += 3;
            }
            if ($f_9983_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_12_].unit, "\n");
              while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
            __fcnt += 3;
            while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
              if ($f_9983_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9983_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_12_].unit, "\n");
                while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
              __fcnt += 3;
              while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                if ($f_9983_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
                __fcnt += 3;
              }
              if ($f_9983_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_12_].unit, "\n");
                while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
              __fcnt += 3;
              while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                if ($f_9983_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_12_, _ioerr_write ("arpack:cmout:90", $u_12_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_12_);
          }
        }
      }
    }
    else if (ndigit_ <= 8) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_13_ = (*lout_);
        _fcheck ("arpack:cmout:98", $u_13_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_13_, _ioerr_write ("arpack:cmout:98", $u_13_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_14 = (char_1 _p_) icol_, _k_15 = 0; _k_15 < 3; _arr_14++, _k_15++) {
            if ($f_9996_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_13_].unit, "\n");
              while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_13_, _ioerr_write ("arpack:cmout:98", $u_13_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], _arr_14, CHARACTER, 1);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:cmout:98", $u_13_));
            __fcnt += 3;
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              if ($f_9996_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_13_, _ioerr_write ("arpack:cmout:98", $u_13_));
              __fcnt += 3;
            }
          }
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_13_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_13_, _ioerr_write ("arpack:cmout:98", $u_13_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_13_, _ioerr_write ("arpack:cmout:98", $u_13_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:cmout:98", $u_13_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_13_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if (k1_ != (*n_)) {
            $u_16_ = (*lout_);
            _fcheck ("arpack:cmout:101", $u_16_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
              __fcnt += 3;
            }
            if ($f_9992_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_16_].unit, "\n");
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
            __fcnt += 3;
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9992_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_16_].unit, "\n");
                while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
              __fcnt += 3;
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
                __fcnt += 3;
              }
              if ($f_9992_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_16_].unit, "\n");
                while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
              __fcnt += 3;
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_16_, _ioerr_write ("arpack:cmout:101", $u_16_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_16_);
          }
          else {
            $u_17_ = (*lout_);
            _fcheck ("arpack:cmout:103", $u_17_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
              __fcnt += 3;
            }
            if ($f_9982_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_17_].unit, "\n");
              while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
            __fcnt += 3;
            while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
              if ($f_9982_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9982_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_17_].unit, "\n");
                while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
              __fcnt += 3;
              while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                if ($f_9982_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
                __fcnt += 3;
              }
              if ($f_9982_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_17_].unit, "\n");
                while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
              __fcnt += 3;
              while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                if ($f_9982_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_17_, _ioerr_write ("arpack:cmout:103", $u_17_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_17_);
          }
        }
      }
    }
    else {
      for (k1_ = 1; k1_ <= (*n_); (k1_)++) {
        $u_18_ = (*lout_);
        _fcheck ("arpack:cmout:110", $u_18_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:cmout:110", $u_18_));
          __fcnt += 3;
        }
        for (_arr_19 = (char_1 _p_) icol_, _k_20 = 0; _k_20 < 3; _arr_19++, _k_20++) {
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_18_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:cmout:110", $u_18_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], _arr_19, CHARACTER, 1);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:cmout:110", $u_18_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:cmout:110", $u_18_));
            __fcnt += 3;
          }
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_18_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:cmout:110", $u_18_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_18_, _ioerr_write ("arpack:cmout:110", $u_18_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:cmout:110", $u_18_));
          __fcnt += 3;
        }
        _write_eol ($u_18_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_21_ = (*lout_);
          _fcheck ("arpack:cmout:112", $u_21_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_21_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_21_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((k1_ - 1))], COMPLEX, 8);
          _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_21_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((k1_ - 1))], COMPLEX, -8);
          _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cmout:112", $u_21_));
            __fcnt += 3;
          }
          _write_eol ($u_21_);
        }
      }
    }
  }
  else {
    if (ndigit_ <= 4) {
      for (k1_ = 1; (4 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 4) {
        k2_ = _min ((*n_), k1_ + 3);
        $u_22_ = (*lout_);
        _fcheck ("arpack:cmout:125", $u_22_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_22_, _ioerr_write ("arpack:cmout:125", $u_22_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_23 = (char_1 _p_) icol_, _k_24 = 0; _k_24 < 3; _arr_23++, _k_24++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_22_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_22_, _ioerr_write ("arpack:cmout:125", $u_22_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], _arr_23, CHARACTER, 1);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:cmout:125", $u_22_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("arpack:cmout:125", $u_22_));
              __fcnt += 3;
            }
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_22_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("arpack:cmout:125", $u_22_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_22_, _ioerr_write ("arpack:cmout:125", $u_22_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:cmout:125", $u_22_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_22_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if ((k1_ + 3) <= (*n_)) {
            $u_25_ = (*lout_);
            _fcheck ("arpack:cmout:128", $u_25_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
              __fcnt += 3;
            }
            if ($f_9974_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_25_].unit, "\n");
              while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
            __fcnt += 3;
            while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
              if ($f_9974_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9974_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_25_].unit, "\n");
                while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
              __fcnt += 3;
              while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                if ($f_9974_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
                __fcnt += 3;
              }
              if ($f_9974_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_25_].unit, "\n");
                while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
              __fcnt += 3;
              while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                if ($f_9974_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_25_, _ioerr_write ("arpack:cmout:128", $u_25_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_25_);
          }
          else if ((k1_ + 3 - (*n_)) == 1) {
            $u_26_ = (*lout_);
            _fcheck ("arpack:cmout:130", $u_26_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
              __fcnt += 3;
            }
            if ($f_9964_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_26_].unit, "\n");
              while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
            __fcnt += 3;
            while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
              if ($f_9964_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9964_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_26_].unit, "\n");
                while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
              __fcnt += 3;
              while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                if ($f_9964_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
                __fcnt += 3;
              }
              if ($f_9964_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_26_].unit, "\n");
                while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
              __fcnt += 3;
              while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                if ($f_9964_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_26_, _ioerr_write ("arpack:cmout:130", $u_26_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_26_);
          }
          else if ((k1_ + 3 - (*n_)) == 2) {
            $u_27_ = (*lout_);
            _fcheck ("arpack:cmout:132", $u_27_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
              __fcnt += 3;
            }
            if ($f_9954_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_27_].unit, "\n");
              while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
            __fcnt += 3;
            while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
              if ($f_9954_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9954_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_27_].unit, "\n");
                while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
              __fcnt += 3;
              while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                if ($f_9954_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
                __fcnt += 3;
              }
              if ($f_9954_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_27_].unit, "\n");
                while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
              __fcnt += 3;
              while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                if ($f_9954_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_27_, _ioerr_write ("arpack:cmout:132", $u_27_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_27_);
          }
          else if ((k1_ + 3 - (*n_)) == 3) {
            $u_28_ = (*lout_);
            _fcheck ("arpack:cmout:134", $u_28_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
              __fcnt += 3;
            }
            if ($f_9944_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_28_].unit, "\n");
              while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
            __fcnt += 3;
            while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
              if ($f_9944_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9944_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_28_].unit, "\n");
                while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
              __fcnt += 3;
              while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                if ($f_9944_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
                __fcnt += 3;
              }
              if ($f_9944_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_28_].unit, "\n");
                while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
              __fcnt += 3;
              while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                if ($f_9944_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_28_, _ioerr_write ("arpack:cmout:134", $u_28_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_28_);
          }
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_29_ = (*lout_);
        _fcheck ("arpack:cmout:142", $u_29_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_29_, _ioerr_write ("arpack:cmout:142", $u_29_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_30 = (char_1 _p_) icol_, _k_31 = 0; _k_31 < 3; _arr_30++, _k_31++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_29_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_29_, _ioerr_write ("arpack:cmout:142", $u_29_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], _arr_30, CHARACTER, 1);
            _write_err (__rc, $u_29_, _ioerr_write ("arpack:cmout:142", $u_29_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_29_, _ioerr_write ("arpack:cmout:142", $u_29_));
              __fcnt += 3;
            }
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_29_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_29_, _ioerr_write ("arpack:cmout:142", $u_29_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_29_, _ioerr_write ("arpack:cmout:142", $u_29_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_29_, _ioerr_write ("arpack:cmout:142", $u_29_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_29_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if ((k1_ + 2) <= (*n_)) {
            $u_32_ = (*lout_);
            _fcheck ("arpack:cmout:145", $u_32_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
              __fcnt += 3;
            }
            if ($f_9973_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_32_].unit, "\n");
              while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
            __fcnt += 3;
            while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
              if ($f_9973_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9973_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_32_].unit, "\n");
                while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
              __fcnt += 3;
              while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                if ($f_9973_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
                __fcnt += 3;
              }
              if ($f_9973_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_32_].unit, "\n");
                while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
              __fcnt += 3;
              while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                if ($f_9973_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_32_, _ioerr_write ("arpack:cmout:145", $u_32_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_32_);
          }
          else if ((k1_ + 2 - (*n_)) == 1) {
            $u_33_ = (*lout_);
            _fcheck ("arpack:cmout:147", $u_33_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
              __fcnt += 3;
            }
            if ($f_9963_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_33_].unit, "\n");
              while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
            __fcnt += 3;
            while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
              if ($f_9963_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9963_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_33_].unit, "\n");
                while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
              __fcnt += 3;
              while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                if ($f_9963_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
                __fcnt += 3;
              }
              if ($f_9963_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_33_].unit, "\n");
                while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
              __fcnt += 3;
              while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                if ($f_9963_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_33_, _ioerr_write ("arpack:cmout:147", $u_33_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_33_);
          }
          else if ((k1_ + 2 - (*n_)) == 2) {
            $u_34_ = (*lout_);
            _fcheck ("arpack:cmout:149", $u_34_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
              __fcnt += 3;
            }
            if ($f_9953_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_34_].unit, "\n");
              while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
            __fcnt += 3;
            while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
              if ($f_9953_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9953_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_34_].unit, "\n");
                while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
              __fcnt += 3;
              while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                if ($f_9953_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
                __fcnt += 3;
              }
              if ($f_9953_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_34_].unit, "\n");
                while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
              __fcnt += 3;
              while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                if ($f_9953_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_34_, _ioerr_write ("arpack:cmout:149", $u_34_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_34_);
          }
        }
      }
    }
    else if (ndigit_ <= 8) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_35_ = (*lout_);
        _fcheck ("arpack:cmout:157", $u_35_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_35_, _ioerr_write ("arpack:cmout:157", $u_35_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_36 = (char_1 _p_) icol_, _k_37 = 0; _k_37 < 3; _arr_36++, _k_37++) {
            if ($f_9996_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_35_].unit, "\n");
              while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_35_, _ioerr_write ("arpack:cmout:157", $u_35_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], _arr_36, CHARACTER, 1);
            _write_err (__rc, $u_35_, _ioerr_write ("arpack:cmout:157", $u_35_));
            __fcnt += 3;
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              if ($f_9996_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_35_, _ioerr_write ("arpack:cmout:157", $u_35_));
              __fcnt += 3;
            }
          }
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_35_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_35_, _ioerr_write ("arpack:cmout:157", $u_35_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_35_, _ioerr_write ("arpack:cmout:157", $u_35_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_35_, _ioerr_write ("arpack:cmout:157", $u_35_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_35_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if ((k1_ + 2) <= (*n_)) {
            $u_38_ = (*lout_);
            _fcheck ("arpack:cmout:160", $u_38_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
              __fcnt += 3;
            }
            if ($f_9972_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_38_].unit, "\n");
              while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
            __fcnt += 3;
            while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
              if ($f_9972_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9972_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_38_].unit, "\n");
                while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
              __fcnt += 3;
              while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                if ($f_9972_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
                __fcnt += 3;
              }
              if ($f_9972_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_38_].unit, "\n");
                while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
              __fcnt += 3;
              while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                if ($f_9972_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_38_, _ioerr_write ("arpack:cmout:160", $u_38_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_38_);
          }
          else if ((k1_ + 2 - (*n_)) == 1) {
            $u_39_ = (*lout_);
            _fcheck ("arpack:cmout:162", $u_39_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
              __fcnt += 3;
            }
            if ($f_9962_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_39_].unit, "\n");
              while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
            __fcnt += 3;
            while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
              if ($f_9962_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9962_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_39_].unit, "\n");
                while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
              __fcnt += 3;
              while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                if ($f_9962_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
                __fcnt += 3;
              }
              if ($f_9962_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_39_].unit, "\n");
                while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
              __fcnt += 3;
              while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                if ($f_9962_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_39_, _ioerr_write ("arpack:cmout:162", $u_39_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_39_);
          }
          else if ((k1_ + 2 - (*n_)) == 2) {
            $u_40_ = (*lout_);
            _fcheck ("arpack:cmout:164", $u_40_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
              __fcnt += 3;
            }
            if ($f_9952_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_40_].unit, "\n");
              while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
            __fcnt += 3;
            while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
              if ($f_9952_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9952_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_40_].unit, "\n");
                while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
              __fcnt += 3;
              while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                if ($f_9952_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
                __fcnt += 3;
              }
              if ($f_9952_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_40_].unit, "\n");
                while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
              __fcnt += 3;
              while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                if ($f_9952_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_40_, _ioerr_write ("arpack:cmout:164", $u_40_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_40_);
          }
        }
      }
    }
    else {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_41_ = (*lout_);
        _fcheck ("arpack:cmout:172", $u_41_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_41_, _ioerr_write ("arpack:cmout:172", $u_41_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_42 = (char_1 _p_) icol_, _k_43 = 0; _k_43 < 3; _arr_42++, _k_43++) {
            if ($f_9995_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_41_].unit, "\n");
              while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("arpack:cmout:172", $u_41_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], _arr_42, CHARACTER, 1);
            _write_err (__rc, $u_41_, _ioerr_write ("arpack:cmout:172", $u_41_));
            __fcnt += 3;
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              if ($f_9995_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_41_, _ioerr_write ("arpack:cmout:172", $u_41_));
              __fcnt += 3;
            }
          }
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_41_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_41_, _ioerr_write ("arpack:cmout:172", $u_41_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_41_, _ioerr_write ("arpack:cmout:172", $u_41_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_41_, _ioerr_write ("arpack:cmout:172", $u_41_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_41_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if ((k1_ + 1) <= (*n_)) {
            $u_44_ = (*lout_);
            _fcheck ("arpack:cmout:175", $u_44_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
              __fcnt += 3;
            }
            if ($f_9971_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_44_].unit, "\n");
              while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
            __fcnt += 3;
            while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
              if ($f_9971_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9971_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
              __fcnt += 3;
              while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                if ($f_9971_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
                __fcnt += 3;
              }
              if ($f_9971_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
              __fcnt += 3;
              while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                if ($f_9971_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("arpack:cmout:175", $u_44_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_44_);
          }
          else {
            $u_45_ = (*lout_);
            _fcheck ("arpack:cmout:177", $u_45_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
              __fcnt += 3;
            }
            if ($f_9961_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_45_].unit, "\n");
              while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
            __fcnt += 3;
            while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
              if ($f_9961_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9961_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_45_].unit, "\n");
                while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 8);
              _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
              __fcnt += 3;
              while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                if ($f_9961_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
                __fcnt += 3;
              }
              if ($f_9961_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_45_].unit, "\n");
                while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -8);
              _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
              __fcnt += 3;
              while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                if ($f_9961_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_45_, _ioerr_write ("arpack:cmout:177", $u_45_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_45_);
          }
        }
      }
    }
  }
  $u_46_ = (*lout_);
  _fcheck ("arpack:cmout:183", $u_46_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9990_[__fcnt] != NULL && $f_9990_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_46_, $f_9990_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_46_, _ioerr_write ("arpack:cmout:183", $u_46_));
    __fcnt += 3;
  }
  _write_eol ($u_46_);
  _l9998:;
  _l9997:;
  _l9996:;
  _l9995:;
  _l9994:;
  _l9984:;
  _l9993:;
  _l9983:;
  _l9992:;
  _l9982:;
  _l9991:;
  _l9990:;
  _l9974:;
  _l9964:;
  _l9954:;
  _l9944:;
  _l9973:;
  _l9963:;
  _l9953:;
  _l9972:;
  _l9962:;
  _l9952:;
  _l9971:;
  _l9961:;
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _cnaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ nb_, complex_8 _p_ 
resid_, real_4 _p_ rnorm_, complex_8 _p_ v_, int_4 _p_ ldv_, complex_8 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, 
complex_8 _p_ workd_, int_4 _p_ info_)
{
  static int_4 ierr_, i_, infol_, ipj_, irj_, ivj_, iter_, itry_, j_, msglvl_, jj_;
  static logical_4 first_, orth1_, orth2_, rstart_, step3_, step4_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, rtemp_[2], ovfl_, smlnum_, tst1_, ulp_, unfl_, betaj_, temp1_, rnorm1_, 
  wnorm_;
  static complex_8 cnorm_;
  int_4 _data_k_2, $11_, $19_, $24_, $27_, $28_;
  logical_4 $0_;
  real_4 $1_, $2_, $3_, $4_, $9_, $10_, $17_, $18_, $20_, $21_, $22_, $23_, $25_, $26_;
  complex_8 $5_, $6_, $7_, $8_, $12_, $13_, $14_, $15_, $16_;
  extern int_4 _caxpy ();
  extern int_4 _ccopy ();
  extern int_4 _csscal ();
  extern int_4 _cgemv ();
  extern int_4 _slabad ();
  extern complex_8 _cdotc ();
  extern real_4 _slamch ();
  extern real_4 _scnrm2 ();
  extern real_4 _clanhs ();
  extern real_4 _slapy2 ();
#define _data_n_2 1
  static logical_4 _data_l_2[_data_n_2] = {
    TRUE
  };
  if (__calls[2].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    first_ = _data_l_2[_data_k_2++];
  }
  if (first_) {
    unfl_ = _slamch (_dc_24);
    ovfl_ = (real_4) (crealf (CMPLXF (1.0, 0.0) / unfl_));
    (void) _slabad (&unfl_, &ovfl_);
    ulp_ = _slamch (_dc_25);
    smlnum_ = unfl_ * ((*n_) / ulp_);
    first_ = FALSE;
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mcaitr_;
    (*info_) = 0;
    step3_ = FALSE;
    step4_ = FALSE;
    rstart_ = FALSE;
    orth1_ = FALSE;
    orth2_ = FALSE;
    j_ = (*k_) + 1;
    ipj_ = 1;
    irj_ = ipj_ + (*n_);
    ivj_ = irj_ + (*n_);
  }
  if (step3_) {
    goto _l50;
  }
  if (step4_) {
    goto _l60;
  }
  if (orth1_) {
    goto _l70;
  }
  if (orth2_) {
    goto _l90;
  }
  if (rstart_) {
    goto _l30;
  }
  _l1000:;
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_26);
    (void) _svout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_27);
  }
  betaj_ = (*rnorm_);
  if ((*rnorm_) > 0.0) {
    goto _l40;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_28);
  }
  betaj_ = 0.0;
  timing_.nrstrt_ = timing_.nrstrt_ + 1;
  itry_ = 1;
  _l20:;
  rstart_ = TRUE;
  (*ido_) = 0;
  _l30:;
  (void) _cgetv0 (ido_, bmat_, &itry_, ($0_ = FALSE, &$0_), n_, &j_, v_, ldv_, resid_, rnorm_, ipntr_, workd_, &ierr_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if (ierr_ < 0) {
    itry_ = itry_ + 1;
    if (itry_ <= 3) {
      goto _l20;
    }
    (*info_) = j_ - 1;
    (void) _second (&t1_);
    timing_.tcaitr_ = timing_.tcaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    goto _l9000;
  }
  _l40:;
  (void) _ccopy (n_, resid_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
  if ((*rnorm_) >= unfl_) {
    temp1_ = 1.0 / (*rnorm_);
    (void) _csscal (n_, &temp1_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
    (void) _csscal (n_, &temp1_, &workd_[ipj_ - 1], &_k1);
  }
  else {
    (void) _clascl (_dc_29, &i_, &i_, rnorm_, ($1_ = 1.0, &$1_), n_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], n_, &infol_);
    (void) _clascl (_dc_29, &i_, &i_, rnorm_, ($2_ = 1.0, &$2_), n_, &_k1, &workd_[ipj_ - 1], n_, &infol_);
  }
  step3_ = TRUE;
  timing_.nopx_ = timing_.nopx_ + 1;
  (void) _second (&t2_);
  (void) _ccopy (n_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1, &workd_[ivj_ - 1], &_k1);
  ipntr_[0] = ivj_;
  ipntr_[1] = irj_;
  ipntr_[2] = ipj_;
  (*ido_) = 1;
  goto _l9000;
  _l50:;
  (void) _second (&t3_);
  timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  step3_ = FALSE;
  (void) _ccopy (n_, &workd_[irj_ - 1], &_k1, resid_, &_k1);
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    step4_ = TRUE;
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _ccopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l60:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  step4_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _cdotc (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    wnorm_ = sqrtf (_slapy2 (($3_ = (real_4) (crealf (cnorm_)), &$3_), ($4_ = cimagf (cnorm_), &$4_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    wnorm_ = _scnrm2 (n_, resid_, &_k1);
  }
  (void) _cgemv (_dc_2, n_, &j_, ($5_ = CMPLXF (1.0, 0.0), &$5_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($6_ = CMPLXF (0.0, 
  0.0), &$6_), &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1);
  (void) _cgemv (_dc_3, n_, &j_, ($7_ = CMPLXF (-1.0, 0.0), &$7_), v_, ldv_, &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1, ($8_ 
  = CMPLXF (1.0, 0.0), &$8_), resid_, &_k1);
  if (j_ > 1) {
    h_[j_ - 1 + ((*ldh_)) * ((j_ - 1 - 1))] = CMPLXF (betaj_, 0.0);
  }
  (void) _second (&t4_);
  orth1_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _ccopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _ccopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l70:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  orth1_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _cdotc (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    (*rnorm_) = sqrtf (_slapy2 (($9_ = (real_4) (crealf (cnorm_)), &$9_), ($10_ = cimagf (cnorm_), &$10_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _scnrm2 (n_, resid_, &_k1);
  }
  if ((*rnorm_) > 0.717 * wnorm_) {
    goto _l100;
  }
  iter_ = 0;
  timing_.nrorth_ = timing_.nrorth_ + 1;
  _l80:;
  if (msglvl_ > 2) {
    rtemp_[0] = wnorm_;
    rtemp_[1] = (*rnorm_);
    (void) _svout (&debug_.logfil_, ($11_ = 2, &$11_), rtemp_, &debug_.ndigit_, _dc_30);
    (void) _cvout (&debug_.logfil_, &j_, &h_[0 + ((*ldh_)) * ((j_ - 1))], &debug_.ndigit_, _dc_31);
  }
  (void) _cgemv (_dc_2, n_, &j_, ($12_ = CMPLXF (1.0, 0.0), &$12_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($13_ = CMPLXF 
  (0.0, 0.0), &$13_), &workd_[irj_ - 1], &_k1);
  (void) _cgemv (_dc_3, n_, &j_, ($14_ = CMPLXF (-1.0, 0.0), &$14_), v_, ldv_, &workd_[irj_ - 1], &_k1, ($15_ = CMPLXF 
  (1.0, 0.0), &$15_), resid_, &_k1);
  (void) _caxpy (&j_, ($16_ = CMPLXF (1.0, 0.0), &$16_), &workd_[irj_ - 1], &_k1, &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1)
  ;
  orth2_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _ccopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _ccopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l90:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _cdotc (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    rnorm1_ = sqrtf (_slapy2 (($17_ = (real_4) (crealf (cnorm_)), &$17_), ($18_ = cimagf (cnorm_), &$18_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm1_ = _scnrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 0 && iter_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_32);
    if (msglvl_ > 2) {
      rtemp_[0] = (*rnorm_);
      rtemp_[1] = rnorm1_;
      (void) _svout (&debug_.logfil_, ($19_ = 2, &$19_), rtemp_, &debug_.ndigit_, _dc_33);
    }
  }
  if (rnorm1_ > 0.717 * (*rnorm_)) {
    (*rnorm_) = rnorm1_;
  }
  else {
    timing_.nitref_ = timing_.nitref_ + 1;
    (*rnorm_) = rnorm1_;
    iter_ = iter_ + 1;
    if (iter_ <= 1) {
      goto _l80;
    }
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = CMPLXF (0.0, 0.0);
    }
    (*rnorm_) = 0.0;
  }
  _l100:;
  rstart_ = FALSE;
  orth2_ = FALSE;
  (void) _second (&t5_);
  timing_.titref_ = timing_.titref_ + (t5_ - t4_);
  j_ = j_ + 1;
  if (j_ > (*k_) + (*np_)) {
    (void) _second (&t1_);
    timing_.tcaitr_ = timing_.tcaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    for (i_ = _max (1, (*k_)); i_ <= (*k_) + (*np_) - 1; (i_)++) {
      tst1_ = _slapy2 (($20_ = (real_4) (crealf (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))])), &$20_), ($21_ = cimagf (h_[i_ - 1 + 
      ((*ldh_)) * ((i_ - 1))]), &$21_)) + _slapy2 (($22_ = (real_4) (crealf (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))])), 
      &$22_), ($23_ = cimagf (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]), &$23_));
      if (tst1_ == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
        tst1_ = _clanhs (_dc_34, ($24_ = (*k_) + (*np_), &$24_), h_, ldh_, &workd_[(*n_) + 1 - 1]);
      }
      if (_slapy2 (($25_ = (real_4) (crealf (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))])), &$25_), ($26_ = cimagf (h_[i_ + 1 - 1 
        + ((*ldh_)) * ((i_ - 1))]), &$26_)) <= _max (ulp_ * tst1_, smlnum_)) {
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = CMPLXF (0.0, 0.0);
      }
    }
    if (msglvl_ > 2) {
      (void) _cmout (&debug_.logfil_, ($27_ = (*k_) + (*np_), &$27_), ($28_ = (*k_) + (*np_), &$28_), h_, ldh_, 
      &debug_.ndigit_, _dc_35);
    }
    goto _l9000;
  }
  goto _l1000;
  _l9000:;
  __calls[2].calls++;
  return 0;
}

int_4 _cnapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, complex_8 _p_ shift_, complex_8 _p_ v_, int_4 _p_ ldv_, 
complex_8 _p_ h_, int_4 _p_ ldh_, complex_8 _p_ resid_, complex_8 _p_ q_, int_4 _p_ ldq_, complex_8 _p_ workl_, 
complex_8 _p_ workd_)
{
  static int_4 i_, iend_, istart_, j_, jj_, kplusp_, msglvl_;
  static logical_4 first_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, c_, ovfl_, smlnum_, ulp_, unfl_, tst1_;
  static complex_8 cdum_, f_, g_, h11_, h21_, r_, s_, sigma_, t_;
  int_4 _data_k_3, $2_, $5_, $7_, $8_, $11_;
  real_4 $3_, $4_;
  complex_8 $0_, $1_, $6_, $9_, $10_, $12_, $13_;
  extern int_4 _caxpy ();
  extern int_4 _ccopy ();
  extern int_4 _cgemv ();
  extern int_4 _cscal ();
  extern int_4 _clacpy ();
  extern int_4 _clartg ();
  extern int_4 _claset ();
  extern int_4 _slabad ();
  extern real_4 _clanhs ();
  extern real_4 _slamch ();
  extern real_4 _slapy2 ();
#define _data_n_3 1
  static logical_4 _data_l_3[_data_n_3] = {
    TRUE
  };
  if (__calls[3].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    first_ = _data_l_3[_data_k_3++];
  }
  if (first_) {
    unfl_ = _slamch (_dc_24);
    ovfl_ = (real_4) (crealf (CMPLXF (1.0, 0.0) / unfl_));
    (void) _slabad (&unfl_, &ovfl_);
    ulp_ = _slamch (_dc_25);
    smlnum_ = unfl_ * ((*n_) / ulp_);
    first_ = FALSE;
  }
  (void) _second (&t0_);
  msglvl_ = debug_.mcapps_;
  kplusp_ = (*kev_) + (*np_);
  (void) _claset (_dc_36, &kplusp_, &kplusp_, ($0_ = CMPLXF (0.0, 0.0), &$0_), ($1_ = CMPLXF (1.0, 0.0), &$1_), q_, ldq_)
  ;
  if ((*np_) == 0) {
    goto _l9000;
  }
  for (jj_ = 1; jj_ <= (*np_); (jj_)++) {
    sigma_ = shift_[jj_ - 1];
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_37);
      (void) _cvout (&debug_.logfil_, &_k1, &sigma_, &debug_.ndigit_, _dc_38);
    }
    istart_ = 1;
    _l20:;
    for (i_ = istart_; i_ <= kplusp_ - 1; (i_)++) {
      tst1_ = ({complex_8 cdum__1_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) + _abs (cimagf 
      (cdum__1_));}) + ({complex_8 cdum__1_ = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]; _abs ((real_4) (crealf 
      (cdum__1_))) + _abs (cimagf (cdum__1_));});
      if (tst1_ == 0.0) {
        tst1_ = _clanhs (_dc_34, ($2_ = kplusp_ - jj_ + 1, &$2_), h_, ldh_, workl_);
      }
      if (_abs ((real_4) (crealf (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))]))) <= _max (ulp_ * tst1_, smlnum_)) {
        if (msglvl_ > 0) {
          (void) _ivout (&debug_.logfil_, &_k1, &i_, &debug_.ndigit_, _dc_39);
          (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_40);
          (void) _cvout (&debug_.logfil_, &_k1, &h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))], &debug_.ndigit_, _dc_41);
        }
        iend_ = i_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = CMPLXF (0.0, 0.0);
        goto _l40;
      }
    }
    iend_ = kplusp_;
    _l40:;
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &istart_, &debug_.ndigit_, _dc_42);
      (void) _ivout (&debug_.logfil_, &_k1, &iend_, &debug_.ndigit_, _dc_43);
    }
    if (istart_ == iend_ || istart_ > (*kev_)) {
      goto _l100;
    }
    h11_ = h_[istart_ - 1 + ((*ldh_)) * ((istart_ - 1))];
    h21_ = h_[istart_ + 1 - 1 + ((*ldh_)) * ((istart_ - 1))];
    f_ = h11_ - sigma_;
    g_ = h21_;
    for (i_ = istart_; i_ <= iend_ - 1; (i_)++) {
      (void) _clartg (&f_, &g_, &c_, &s_, &r_);
      if (i_ > istart_) {
        h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = r_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = CMPLXF (0.0, 0.0);
      }
      for (j_ = i_; j_ <= kplusp_; (j_)++) {
        t_ = c_ * h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] + s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
        h_[i_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = -conjf (s_) * h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] + c_ * h_[i_ + 1 - 1 + 
        ((*ldh_)) * ((j_ - 1))];
        h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] = t_;
      }
      for (j_ = 1; j_ <= _min (i_ + 2, iend_); (j_)++) {
        t_ = c_ * h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] + conjf (s_) * h_[j_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))];
        h_[j_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))] = -s_ * h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] + c_ * h_[j_ - 1 + ((*ldh_)) * ((i_ 
        + 1 - 1))];
        h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] = t_;
      }
      for (j_ = 1; j_ <= _min (i_ + jj_, kplusp_); (j_)++) {
        t_ = c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + conjf (s_) * q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))];
        q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))] = -s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ 
        + 1 - 1))];
        q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] = t_;
      }
      if (i_ < iend_ - 1) {
        f_ = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))];
        g_ = h_[i_ + 2 - 1 + ((*ldh_)) * ((i_ - 1))];
      }
    }
    _l100:;
    istart_ = iend_ + 1;
    if (iend_ < kplusp_) {
      goto _l20;
    }
  }
  for (j_ = 1; j_ <= (*kev_); (j_)++) {
    if ((real_4) (crealf (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))])) < 0.0 || cimagf (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 
      1))]) != 0.0) {
      t_ = h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] / _slapy2 (($3_ = (real_4) (crealf (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 
      1))])), &$3_), ($4_ = cimagf (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))]), &$4_));
      (void) _cscal (($5_ = kplusp_ - j_ + 1, &$5_), ($6_ = conjf (t_), &$6_), &h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))], 
      ldh_);
      (void) _cscal (($7_ = _min (j_ + 2, kplusp_), &$7_), &t_, &h_[0 + ((*ldh_)) * ((j_ + 1 - 1))], &_k1);
      (void) _cscal (($8_ = _min (j_ + (*np_) + 1, kplusp_), &$8_), &t_, &q_[0 + ((*ldq_)) * ((j_ + 1 - 1))], &_k1);
      h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = CMPLXF ((real_4) (crealf (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))])), 0.0);
    }
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    tst1_ = ({complex_8 cdum__1_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) + _abs (cimagf 
    (cdum__1_));}) + ({complex_8 cdum__1_ = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]; _abs ((real_4) (crealf 
    (cdum__1_))) + _abs (cimagf (cdum__1_));});
    if (tst1_ == 0.0) {
      tst1_ = _clanhs (_dc_34, kev_, h_, ldh_, workl_);
    }
    if ((real_4) (crealf (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))])) <= _max (ulp_ * tst1_, smlnum_)) {
      h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = CMPLXF (0.0, 0.0);
    }
  }
  if ((real_4) (crealf (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))])) > 0.0) {
    (void) _cgemv (_dc_3, n_, &kplusp_, ($9_ = CMPLXF (1.0, 0.0), &$9_), v_, ldv_, &q_[0 + ((*ldq_)) * (((*kev_) + 1 - 
    1))], &_k1, ($10_ = CMPLXF (0.0, 0.0), &$10_), &workd_[(*n_) + 1 - 1], &_k1);
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    (void) _cgemv (_dc_3, n_, ($11_ = kplusp_ - i_ + 1, &$11_), ($12_ = CMPLXF (1.0, 0.0), &$12_), v_, ldv_, &q_[0 + 
    ((*ldq_)) * (((*kev_) - i_ + 1 - 1))], &_k1, ($13_ = CMPLXF (0.0, 0.0), &$13_), workd_, &_k1);
    (void) _ccopy (n_, workd_, &_k1, &v_[0 + ((*ldv_)) * ((kplusp_ - i_ + 1 - 1))], &_k1);
  }
  (void) _clacpy (_dc_44, n_, kev_, &v_[0 + ((*ldv_)) * ((kplusp_ - (*kev_) + 1 - 1))], ldv_, v_, ldv_);
  if ((real_4) (crealf (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))])) > 0.0) {
    (void) _ccopy (n_, &workd_[(*n_) + 1 - 1], &_k1, &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1);
  }
  (void) _cscal (n_, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], resid_, &_k1);
  if ((real_4) (crealf (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))])) > 0.0) {
    (void) _caxpy (n_, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))], &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1, 
    resid_, &_k1);
  }
  if (msglvl_ > 1) {
    (void) _cvout (&debug_.logfil_, &_k1, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_45);
    (void) _cvout (&debug_.logfil_, &_k1, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_46);
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_47);
    if (msglvl_ > 2) {
      (void) _cmout (&debug_.logfil_, kev_, kev_, h_, ldh_, &debug_.ndigit_, _dc_48);
    }
  }
  _l9000:;
  (void) _second (&t1_);
  timing_.tcapps_ = timing_.tcapps_ + (t1_ - t0_);
  __calls[3].calls++;
  return 0;
}

int_4 _cnaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, real_4 _p_ 
tol_, complex_8 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, complex_8 _p_ v_, 
int_4 _p_ ldv_, complex_8 _p_ h_, int_4 _p_ ldh_, complex_8 _p_ ritz_, complex_8 _p_ bounds_, complex_8 _p_ q_, int_4 
_p_ ldq_, complex_8 _p_ workl_, int_4 _p_ ipntr_, complex_8 _p_ workd_, real_4 _p_ rwork_, int_4 _p_ info_)
{
  static int_4 ierr_, iter_, kplusp_, msglvl_, nconv_, nevbef_, nev0_, np0_, nptemp_, i_, j_, kp_[3];
  static logical_4 cnorm_, getv0_, initv_, update_, ushift_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, rnorm_, eps23_, rtemp_;
  static complex_8 cmpnorm_;
  static char_3 wprime_;
  int_4 $4_, $12_;
  logical_4 $5_, $8_, $11_;
  real_4 $0_, $1_, $2_, $3_, $6_, $7_, $9_, $10_, $13_, $14_;
  extern int_4 _ccopy ();
  extern complex_8 _cdotc ();
  extern real_4 _scnrm2 ();
  extern real_4 _slamch ();
  extern real_4 _slapy2 ();
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mcaup2_;
    nev0_ = (*nev_);
    np0_ = (*np_);
    kplusp_ = (*nev_) + (*np_);
    nconv_ = 0;
    iter_ = 0;
    eps23_ = _slamch (_dc_49);
    eps23_ = powl (eps23_, 6.6666667e-1);
    getv0_ = TRUE;
    update_ = FALSE;
    ushift_ = FALSE;
    cnorm_ = FALSE;
    if ((*info_) != 0) {
      initv_ = TRUE;
      (*info_) = 0;
    }
    else {
      initv_ = FALSE;
    }
  }
  if (getv0_) {
    (void) _cgetv0 (ido_, bmat_, &_k1, &initv_, n_, &_k1, v_, ldv_, resid_, &rnorm_, ipntr_, workd_, info_);
    if ((*ido_) != 99) {
      goto _l9000;
    }
    if (rnorm_ == 0.0) {
      (*info_) = -9;
      goto _l1100;
    }
    getv0_ = FALSE;
    (*ido_) = 0;
  }
  if (update_) {
    goto _l20;
  }
  if (ushift_) {
    goto _l50;
  }
  if (cnorm_) {
    goto _l100;
  }
  (void) _cnaitr (ido_, bmat_, n_, &_k0, nev_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  _l1000:;
  iter_ = iter_ + 1;
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &iter_, &debug_.ndigit_, _dc_50);
  }
  (*np_) = kplusp_ - (*nev_);
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, nev_, &debug_.ndigit_, _dc_51);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_52);
  }
  (*ido_) = 0;
  _l20:;
  update_ = TRUE;
  (void) _cnaitr (ido_, bmat_, n_, nev_, np_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  update_ = FALSE;
  if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_53);
  }
  (void) _cneigh (&rnorm_, &kplusp_, h_, ldh_, ritz_, bounds_, q_, ldq_, workl_, rwork_, &ierr_);
  if (ierr_ != 0) {
    (*info_) = -8;
    goto _l1200;
  }
  (*nev_) = nev0_;
  (*np_) = np0_;
  (void) _ccopy (&kplusp_, ritz_, &_k1, &workl_[(kplusp_ * kplusp_) + 1 - 1], &_k1);
  (void) _ccopy (&kplusp_, bounds_, &_k1, &workl_[(kplusp_ * kplusp_) + kplusp_ + 1 - 1], &_k1);
  (void) _cngets (ishift_, which_, nev_, np_, ritz_, bounds_);
  nconv_ = 0;
  for (i_ = 1; i_ <= (*nev_); (i_)++) {
    rtemp_ = _max (eps23_, _slapy2 (($0_ = (real_4) (crealf (ritz_[(*np_) + i_ - 1])), &$0_), ($1_ = cimagf (ritz_[(*np_) + 
    i_ - 1]), &$1_)));
    if (_slapy2 (($2_ = (real_4) (crealf (bounds_[(*np_) + i_ - 1])), &$2_), ($3_ = cimagf (bounds_[(*np_) + i_ - 1]), 
      &$3_)) <= (*tol_) * rtemp_) {
      nconv_ = nconv_ + 1;
    }
  }
  if (msglvl_ > 2) {
    kp_[0] = (*nev_);
    kp_[1] = (*np_);
    kp_[2] = nconv_;
    (void) _ivout (&debug_.logfil_, ($4_ = 3, &$4_), kp_, &debug_.ndigit_, _dc_54);
    (void) _cvout (&debug_.logfil_, &kplusp_, ritz_, &debug_.ndigit_, _dc_55);
    (void) _cvout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_56);
  }
  nptemp_ = (*np_);
  for (j_ = 1; j_ <= nptemp_; (j_)++) {
    if (bounds_[j_ - 1] == CMPLXF (0.0, 0.0)) {
      (*np_) = (*np_) - 1;
      (*nev_) = (*nev_) + 1;
    }
  }
  if ((nconv_ >= nev0_) || (iter_ > (*mxiter_)) || ((*np_) == 0)) {
    if (msglvl_ > 4) {
      (void) _cvout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + 1 - 1], &debug_.ndigit_, _dc_57);
      (void) _cvout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + kplusp_ + 1 - 1], &debug_.ndigit_, _dc_58);
    }
    h_[2 + ((*ldh_)) * ((0))] = CMPLXF (rnorm_, 0.0);
    if ((strcasecmp (which_, _dc_59) == 0)) {
      bufcpy (wprime_, _dc_60, 3);
    }
    if ((strcasecmp (which_, _dc_60) == 0)) {
      bufcpy (wprime_, _dc_59, 3);
    }
    if ((strcasecmp (which_, _dc_61) == 0)) {
      bufcpy (wprime_, _dc_62, 3);
    }
    if ((strcasecmp (which_, _dc_62) == 0)) {
      bufcpy (wprime_, _dc_61, 3);
    }
    if ((strcasecmp (which_, _dc_63) == 0)) {
      bufcpy (wprime_, _dc_64, 3);
    }
    if ((strcasecmp (which_, _dc_64) == 0)) {
      bufcpy (wprime_, _dc_63, 3);
    }
    (void) _csortc (wprime_, ($5_ = TRUE, &$5_), &kplusp_, ritz_, bounds_);
    for (j_ = 1; j_ <= nev0_; (j_)++) {
      rtemp_ = _max (eps23_, _slapy2 (($6_ = (real_4) (crealf (ritz_[j_ - 1])), &$6_), ($7_ = cimagf (ritz_[j_ - 1]), &$7_)))
      ;
      bounds_[j_ - 1] = bounds_[j_ - 1] / rtemp_;
    }
    bufcpy (wprime_, _dc_59, 3);
    (void) _csortc (wprime_, ($8_ = TRUE, &$8_), &nev0_, bounds_, ritz_);
    for (j_ = 1; j_ <= nev0_; (j_)++) {
      rtemp_ = _max (eps23_, _slapy2 (($9_ = (real_4) (crealf (ritz_[j_ - 1])), &$9_), ($10_ = cimagf (ritz_[j_ - 1]), 
      &$10_)));
      bounds_[j_ - 1] = bounds_[j_ - 1] * rtemp_;
    }
    (void) _csortc (which_, ($11_ = TRUE, &$11_), &nconv_, ritz_, bounds_);
    if (msglvl_ > 1) {
      (void) _cvout (&debug_.logfil_, &kplusp_, ritz_, &debug_.ndigit_, _dc_65);
      (void) _cvout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_66);
    }
    if (iter_ > (*mxiter_) && nconv_ < nev0_) {
      (*info_) = 1;
    }
    if ((*np_) == 0 && nconv_ < nev0_) {
      (*info_) = 2;
    }
    (*np_) = nconv_;
    goto _l1100;
  }
  else if ((nconv_ < nev0_) && ((*ishift_) == 1)) {
    nevbef_ = (*nev_);
    (*nev_) = (*nev_) + _min (nconv_, (*np_) / 2);
    if ((*nev_) == 1 && kplusp_ >= 6) {
      (*nev_) = kplusp_ / 2;
    }
    else if ((*nev_) == 1 && kplusp_ > 3) {
      (*nev_) = 2;
    }
    (*np_) = kplusp_ - (*nev_);
    if (nevbef_ < (*nev_)) {
      (void) _cngets (ishift_, which_, nev_, np_, ritz_, bounds_);
    }
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_67);
    if (msglvl_ > 1) {
      kp_[0] = (*nev_);
      kp_[1] = (*np_);
      (void) _ivout (&debug_.logfil_, ($12_ = 2, &$12_), kp_, &debug_.ndigit_, _dc_68);
      (void) _cvout (&debug_.logfil_, nev_, &ritz_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_69);
      (void) _cvout (&debug_.logfil_, nev_, &bounds_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_70);
    }
  }
  if ((*ishift_) == 0) {
    ushift_ = TRUE;
    (*ido_) = 3;
    goto _l9000;
  }
  _l50:;
  ushift_ = FALSE;
  if ((*ishift_) != 1) {
    (void) _ccopy (np_, workl_, &_k1, ritz_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_71);
    (void) _cvout (&debug_.logfil_, np_, ritz_, &debug_.ndigit_, _dc_72);
    if ((*ishift_) == 1) {
      (void) _cvout (&debug_.logfil_, np_, bounds_, &debug_.ndigit_, _dc_73);
    }
  }
  (void) _cnapps (n_, nev_, np_, ritz_, v_, ldv_, h_, ldh_, resid_, q_, ldq_, workl_, workd_);
  cnorm_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _ccopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _ccopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l100:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cmpnorm_ = _cdotc (n_, resid_, &_k1, workd_, &_k1);
    rnorm_ = sqrtf (_slapy2 (($13_ = (real_4) (crealf (cmpnorm_)), &$13_), ($14_ = cimagf (cmpnorm_), &$14_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm_ = _scnrm2 (n_, resid_, &_k1);
  }
  cnorm_ = FALSE;
  if (msglvl_ > 2) {
    (void) _svout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_74);
    (void) _cmout (&debug_.logfil_, nev_, nev_, h_, ldh_, &debug_.ndigit_, _dc_75);
  }
  goto _l1000;
  _l1100:;
  (*mxiter_) = iter_;
  (*nev_) = nconv_;
  _l1200:;
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tcaup2_ = t1_ - t0_;
  _l9000:;
  __calls[4].calls++;
  return 0;
}

int_4 _cnaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_, 
complex_8 _p_ resid_, int_4 _p_ ncv_, complex_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, complex_8 
_p_ workd_, complex_8 _p_ workl_, int_4 _p_ lworkl_, real_4 _p_ rwork_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, iq_, ishift_, iupd_, iw_, ldh_, ldq_, levec_, mode_, msglvl_, mxiter_, nb_, nev0_, 
  next_, np_, ritz_, j_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 __fcnt, __rc;
  extern real_4 _slamch ();
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_83, _dc_83,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_84, _dc_84,
    FMT_TEXT, _dc_85, _dc_85,
    FMT_TEXT, _dc_86, _dc_86,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_88, _dc_88,
    FMT_TEXT, _dc_89, _dc_89,
    FMT_TEXT, _dc_90, _dc_90,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_91, _dc_91,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_1100_[] = {
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_92, _dc_92,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_93, _dc_93,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_94, _dc_94,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_96, _dc_96,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_97, _dc_97,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_98, _dc_98,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_99, _dc_99,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_101, _dc_101,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_102, _dc_102,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_103, _dc_103,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_104, _dc_104,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_105, _dc_105,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_106, _dc_106,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_107, _dc_107,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_108, _dc_108,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_109, _dc_109,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  if ((*ido_) == 0) {
    (void) _cstatn ();
    (void) _second (&t0_);
    msglvl_ = debug_.mcaupd_;
    ierr_ = 0;
    ishift_ = iparam_[0];
    mxiter_ = iparam_[2];
    nb_ = 1;
    iupd_ = 1;
    mode_ = iparam_[6];
    if ((*n_) <= 0) {
      ierr_ = -1;
    }
    else if ((*nev_) <= 0) {
      ierr_ = -2;
    }
    else if ((*ncv_) <= (*nev_) || (*ncv_) > (*n_)) {
      ierr_ = -3;
    }
    else if (mxiter_ <= 0) {
      ierr_ = -4;
    }
    else if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_61) != 0) 
      && (strcasecmp (which_, _dc_62) != 0) && (strcasecmp (which_, _dc_63) != 0) && (strcasecmp (which_, _dc_64) != 0)) {
      ierr_ = -5;
    }
    else if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
      ierr_ = -6;
    }
    else if ((*lworkl_) < 3 * ((*ncv_) * (*ncv_)) + 5 * (*ncv_)) {
      ierr_ = -7;
    }
    else if (mode_ < 1 || mode_ > 3) {
      ierr_ = -10;
    }
    else if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
      ierr_ = -11;
    }
    if (ierr_ != 0) {
      (*info_) = ierr_;
      (*ido_) = 99;
      goto _l9000;
    }
    if (nb_ <= 0) {
      nb_ = 1;
    }
    if ((*tol_) <= 0.0e+0) {
      (*tol_) = _slamch (_dc_76);
    }
    if (ishift_ != 0 && ishift_ != 1 && ishift_ != 2) {
      ishift_ = 1;
    }
    np_ = (*ncv_) - (*nev_);
    nev0_ = (*nev_);
    for (j_ = 1; j_ <= 3 * ((*ncv_) * (*ncv_)) + 5 * (*ncv_); (j_)++) {
      workl_[j_ - 1] = CMPLXF (0.0, 0.0);
    }
    ldh_ = (*ncv_);
    ldq_ = (*ncv_);
    ih_ = 1;
    ritz_ = ih_ + ldh_ * (*ncv_);
    bounds_ = ritz_ + (*ncv_);
    iq_ = bounds_ + (*ncv_);
    iw_ = iq_ + ldq_ * (*ncv_);
    next_ = iw_ + ((*ncv_) * (*ncv_)) + 3 * (*ncv_);
    ipntr_[3] = next_;
    ipntr_[4] = ih_;
    ipntr_[5] = ritz_;
    ipntr_[6] = iq_;
    ipntr_[7] = bounds_;
    ipntr_[13] = iw_;
  }
  (void) _cnaup2 (ido_, bmat_, n_, which_, &nev0_, &np_, tol_, resid_, &mode_, &iupd_, &ishift_, &mxiter_, v_, ldv_, 
  &workl_[ih_ - 1], &ldh_, &workl_[ritz_ - 1], &workl_[bounds_ - 1], &workl_[iq_ - 1], &ldq_, &workl_[iw_ - 1], ipntr_, 
  workd_, rwork_, info_);
  if ((*ido_) == 3) {
    iparam_[7] = np_;
  }
  if ((*ido_) != 99) {
    goto _l9000;
  }
  iparam_[2] = mxiter_;
  iparam_[4] = np_;
  iparam_[8] = timing_.nopx_;
  iparam_[9] = timing_.nbx_;
  iparam_[10] = timing_.nrorth_;
  if ((*info_) < 0) {
    goto _l9000;
  }
  if ((*info_) == 2) {
    (*info_) = 3;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &mxiter_, &debug_.ndigit_, _dc_77);
    (void) _ivout (&debug_.logfil_, &_k1, &np_, &debug_.ndigit_, _dc_78);
    (void) _cvout (&debug_.logfil_, &np_, &workl_[ritz_ - 1], &debug_.ndigit_, _dc_79);
    (void) _cvout (&debug_.logfil_, &np_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_80);
  }
  (void) _second (&t1_);
  timing_.tcaupd_ = t1_ - t0_;
  if (msglvl_ > 0) {
    _fcheck ("arpack:cnaupd:623", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:623", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _fcheck ("arpack:cnaupd:624", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &mxiter_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nopx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nbx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrorth_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nitref_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrstrt_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvopx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvbx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tcaupd_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tcaup2_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tcaitr_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.titref_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tgetv0_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tceigh_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tcgets_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tcapps_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tcconv_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.trvec_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:cnaupd:624", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _l1000:;
    _l1100:;
  }
  _l9000:;
  __calls[5].calls++;
  return 0;
}

int_4 _cneigh (real_4 _p_ rnorm_, int_4 _p_ n_, complex_8 _p_ h_, int_4 _p_ ldh_, complex_8 _p_ ritz_, complex_8 _p_ 
bounds_, complex_8 _p_ q_, int_4 _p_ ldq_, complex_8 _p_ workl_, real_4 _p_ rwork_, int_4 _p_ ierr_)
{
  static int_4 j_, msglvl_;
  static logical_4 select_[1];
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, temp_;
  static complex_8 vl_[1];
  logical_4 $2_, $3_;
  real_4 $4_;
  complex_8 $0_, $1_;
  extern int_4 _clacpy ();
  extern int_4 _clahqr ();
  extern int_4 _ctrevc ();
  extern int_4 _ccopy ();
  extern int_4 _csscal ();
  extern real_4 _scnrm2 ();
  (void) _second (&t0_);
  msglvl_ = debug_.mceigh_;
  if (msglvl_ > 2) {
    (void) _cmout (&debug_.logfil_, n_, n_, h_, ldh_, &debug_.ndigit_, _dc_110);
  }
  (void) _clacpy (_dc_36, n_, n_, h_, ldh_, workl_, n_);
  (void) _claset (_dc_36, n_, n_, ($0_ = CMPLXF (0.0, 0.0), &$0_), ($1_ = CMPLXF (1.0, 0.0), &$1_), q_, ldq_);
  (void) _clahqr (($2_ = TRUE, &$2_), ($3_ = TRUE, &$3_), n_, &_k1, n_, workl_, ldh_, ritz_, &_k1, n_, q_, ldq_, ierr_);
  if ((*ierr_) != 0) {
    goto _l9000;
  }
  (void) _ccopy (n_, &q_[(*n_) - 1 - 1 + ((*ldq_)) * ((0))], ldq_, bounds_, &_k1);
  if (msglvl_ > 1) {
    (void) _cvout (&debug_.logfil_, n_, bounds_, &debug_.ndigit_, _dc_111);
  }
  (void) _ctrevc (_dc_112, _dc_113, select_, n_, workl_, n_, vl_, n_, q_, ldq_, n_, n_, &workl_[(*n_) * (*n_) + 1 - 1], 
  rwork_, ierr_);
  if ((*ierr_) != 0) {
    goto _l9000;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = _scnrm2 (n_, &q_[0 + ((*ldq_)) * ((j_ - 1))], &_k1);
    (void) _csscal (n_, ($4_ = 1.0 / temp_, &$4_), &q_[0 + ((*ldq_)) * ((j_ - 1))], &_k1);
  }
  if (msglvl_ > 1) {
    (void) _ccopy (n_, &q_[(*n_) - 1 + ((*ldq_)) * ((0))], ldq_, workl_, &_k1);
    (void) _cvout (&debug_.logfil_, n_, workl_, &debug_.ndigit_, _dc_114);
  }
  (void) _ccopy (n_, &q_[(*n_) - 1 + ((*ldq_)) * ((0))], n_, bounds_, &_k1);
  (void) _csscal (n_, rnorm_, bounds_, &_k1);
  if (msglvl_ > 2) {
    (void) _cvout (&debug_.logfil_, n_, ritz_, &debug_.ndigit_, _dc_115);
    (void) _cvout (&debug_.logfil_, n_, bounds_, &debug_.ndigit_, _dc_116);
  }
  (void) _second (&t1_);
  timing_.tceigh_ = timing_.tceigh_ + (t1_ - t0_);
  _l9000:;
  __calls[6].calls++;
  return 0;
}

int_4 _cneupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, complex_8 _p_ d_, complex_8 _p_ z_, int_4 
_p_ ldz_, complex_8 _p_ sigma_, complex_8 _p_ workev_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, 
real_4 _p_ tol_, complex_8 _p_ resid_, int_4 _p_ ncv_, complex_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ 
ipntr_, complex_8 _p_ workd_, complex_8 _p_ workl_, int_4 _p_ lworkl_, real_4 _p_ rwork_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, ihbds_, iheig_, nconv_, invsub_, iuptri_, iwev_, j_, ldh_, ldq_, mode_, msglvl_, 
  ritz_, wr_, k_, irz_, ibd_, outncv_, iq_, np_, numcnv_, jj_, ishift_;
  static logical_4 reord_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, conds_, sep_, rtemp_, eps23_;
  static complex_8 rnorm_, temp_, vl_[1];
  static char_7 type_;
  int_4 $4_;
  logical_4 $7_, $8_;
  real_4 $0_, $1_, $2_, $3_;
  complex_8 $5_, $6_, $9_, $10_, $11_, $12_;
  extern int_4 _ccopy ();
  extern int_4 _cgeru ();
  extern int_4 _cgeqr2 ();
  extern int_4 _clacpy ();
  extern int_4 _cunm2r ();
  extern int_4 _ctrmm ();
  extern int_4 _clahqr ();
  extern real_4 _scnrm2 ();
  extern real_4 _slamch ();
  extern real_4 _slapy2 ();
  extern complex_8 _cdotc ();
  msglvl_ = debug_.mceupd_;
  mode_ = iparam_[6];
  nconv_ = iparam_[4];
  (*info_) = 0;
  eps23_ = _slamch (_dc_49);
  eps23_ = powl (eps23_, 6.6666667e-1);
  ierr_ = 0;
  if (nconv_ <= 0) {
    ierr_ = -14;
  }
  else if ((*n_) <= 0) {
    ierr_ = -1;
  }
  else if ((*nev_) <= 0) {
    ierr_ = -2;
  }
  else if ((*ncv_) <= (*nev_) + 1 || (*ncv_) > (*n_)) {
    ierr_ = -3;
  }
  else if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_61) != 0) 
    && (strcasecmp (which_, _dc_62) != 0) && (strcasecmp (which_, _dc_63) != 0) && (strcasecmp (which_, _dc_64) != 0)) {
    ierr_ = -5;
  }
  else if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
    ierr_ = -6;
  }
  else if ((*lworkl_) < 3 * ((*ncv_) * (*ncv_)) + 4 * (*ncv_)) {
    ierr_ = -7;
  }
  else if (((strcasecmp (howmny_, _dc_44) != 0) && (strcasecmp (howmny_, _dc_117) != 0) && (strcasecmp (howmny_, _dc_118) 
    != 0)) && (*rvec_)) {
    ierr_ = -13;
  }
  else if ((strcasecmp (howmny_, _dc_118) == 0)) {
    ierr_ = -12;
  }
  if (mode_ == 1 || mode_ == 2) {
    bufcpy (type_, _dc_119, 7);
  }
  else if (mode_ == 3) {
    bufcpy (type_, _dc_120, 7);
  }
  else {
    ierr_ = -10;
  }
  if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
    ierr_ = -11;
  }
  if (ierr_ != 0) {
    (*info_) = ierr_;
    goto _l9000;
  }
  ih_ = ipntr_[4];
  ritz_ = ipntr_[5];
  iq_ = ipntr_[6];
  bounds_ = ipntr_[7];
  ldh_ = (*ncv_);
  ldq_ = (*ncv_);
  iheig_ = bounds_ + ldh_;
  ihbds_ = iheig_ + ldh_;
  iuptri_ = ihbds_ + ldh_;
  invsub_ = iuptri_ + ldh_ * (*ncv_);
  ipntr_[8] = iheig_;
  ipntr_[10] = ihbds_;
  ipntr_[11] = iuptri_;
  ipntr_[12] = invsub_;
  wr_ = 1;
  iwev_ = wr_ + (*ncv_);
  irz_ = ipntr_[13] + (*ncv_) * (*ncv_);
  ibd_ = irz_ + (*ncv_);
  rnorm_ = workl_[ih_ + 2 - 1];
  workl_[ih_ + 2 - 1] = CMPLXF (0.0, 0.0);
  if (msglvl_ > 2) {
    (void) _cvout (&debug_.logfil_, ncv_, &workl_[irz_ - 1], &debug_.ndigit_, _dc_121);
    (void) _cvout (&debug_.logfil_, ncv_, &workl_[ibd_ - 1], &debug_.ndigit_, _dc_122);
  }
  if ((*rvec_)) {
    reord_ = FALSE;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      workl_[bounds_ + j_ - 1 - 1] = j_;
      select_[j_ - 1] = FALSE;
    }
    np_ = (*ncv_) - (*nev_);
    ishift_ = 0;
    (void) _cngets (&ishift_, which_, nev_, &np_, &workl_[irz_ - 1], &workl_[bounds_ - 1]);
    if (msglvl_ > 2) {
      (void) _cvout (&debug_.logfil_, ncv_, &workl_[irz_ - 1], &debug_.ndigit_, _dc_123);
      (void) _cvout (&debug_.logfil_, ncv_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_124);
    }
    numcnv_ = 0;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      rtemp_ = _max (eps23_, _slapy2 (($0_ = (real_4) (crealf (workl_[irz_ + (*ncv_) - j_ - 1])), &$0_), ($1_ = cimagf 
      (workl_[irz_ + (*ncv_) - j_ - 1]), &$1_)));
      jj_ = (int_4) (crealf (workl_[bounds_ + (*ncv_) - j_ - 1]));
      if (numcnv_ < nconv_ && _slapy2 (($2_ = (real_4) (crealf (workl_[ibd_ + jj_ - 1 - 1])), &$2_), ($3_ = cimagf 
        (workl_[ibd_ + jj_ - 1 - 1]), &$3_)) <= (*tol_) * rtemp_) {
        select_[jj_ - 1] = TRUE;
        numcnv_ = numcnv_ + 1;
        if (jj_ > (*nev_)) {
          reord_ = TRUE;
        }
      }
    }
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &numcnv_, &debug_.ndigit_, _dc_125);
      (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_126);
    }
    if (numcnv_ != nconv_) {
      (*info_) = -15;
      goto _l9000;
    }
    (void) _ccopy (($4_ = ldh_ * (*ncv_), &$4_), &workl_[ih_ - 1], &_k1, &workl_[iuptri_ - 1], &_k1);
    (void) _claset (_dc_36, ncv_, ncv_, ($5_ = CMPLXF (0.0, 0.0), &$5_), ($6_ = CMPLXF (1.0, 0.0), &$6_), &workl_[invsub_ - 
    1], &ldq_);
    (void) _clahqr (($7_ = TRUE, &$7_), ($8_ = TRUE, &$8_), ncv_, &_k1, ncv_, &workl_[iuptri_ - 1], &ldh_, &workl_[iheig_ - 
    1], &_k1, ncv_, &workl_[invsub_ - 1], &ldq_, &ierr_);
    (void) _ccopy (ncv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
    if (ierr_ != 0) {
      (*info_) = -8;
      goto _l9000;
    }
    if (msglvl_ > 1) {
      (void) _cvout (&debug_.logfil_, ncv_, &workl_[iheig_ - 1], &debug_.ndigit_, _dc_127);
      (void) _cvout (&debug_.logfil_, ncv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_128);
      if (msglvl_ > 3) {
        (void) _cmout (&debug_.logfil_, ncv_, ncv_, &workl_[iuptri_ - 1], &ldh_, &debug_.ndigit_, _dc_129);
      }
    }
    if (reord_) {
      (void) _ctrsen (_dc_130, _dc_131, select_, ncv_, &workl_[iuptri_ - 1], &ldh_, &workl_[invsub_ - 1], &ldq_, 
      &workl_[iheig_ - 1], &nconv_, &conds_, &sep_, workev_, ncv_, &ierr_);
      if (ierr_ == 1) {
        (*info_) = 1;
        goto _l9000;
      }
      if (msglvl_ > 2) {
        (void) _cvout (&debug_.logfil_, ncv_, &workl_[iheig_ - 1], &debug_.ndigit_, _dc_132);
        if (msglvl_ > 3) {
          (void) _cmout (&debug_.logfil_, ncv_, ncv_, &workl_[iuptri_ - 1], &ldq_, &debug_.ndigit_, _dc_133);
        }
      }
    }
    (void) _ccopy (ncv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
    if ((strcasecmp (type_, _dc_119) == 0)) {
      (void) _ccopy (&nconv_, &workl_[iheig_ - 1], &_k1, d_, &_k1);
    }
    (void) _cgeqr2 (ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, &workev_[(*ncv_) + 1 - 1], &ierr_);
    (void) _cunm2r (_dc_112, _dc_134, n_, ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, v_, ldv_, &workd_[(*n_) + 1 
    - 1], &ierr_);
    (void) _clacpy (_dc_36, n_, &nconv_, v_, ldv_, z_, ldz_);
    for (j_ = 1; j_ <= nconv_; (j_)++) {
      if ((real_4) (crealf (workl_[invsub_ + (j_ - 1) * ldq_ + j_ - 1 - 1])) < (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
        (void) _cscal (&nconv_, ($9_ = CMPLXF (-1.0, 0.0), &$9_), &workl_[iuptri_ + j_ - 1 - 1], &ldq_);
        (void) _cscal (&nconv_, ($10_ = CMPLXF (-1.0, 0.0), &$10_), &workl_[iuptri_ + (j_ - 1) * ldq_ - 1], &_k1);
      }
    }
    if ((strcasecmp (howmny_, _dc_44) == 0)) {
      for (j_ = 1; j_ <= (*ncv_); (j_)++) {
        if (j_ <= nconv_) {
          select_[j_ - 1] = TRUE;
        }
        else {
          select_[j_ - 1] = FALSE;
        }
      }
      (void) _ctrevc (_dc_112, _dc_135, select_, ncv_, &workl_[iuptri_ - 1], &ldq_, vl_, &_k1, &workl_[invsub_ - 1], &ldq_, 
      ncv_, &outncv_, workev_, rwork_, &ierr_);
      if (ierr_ != 0) {
        (*info_) = -9;
        goto _l9000;
      }
      for (j_ = 1; j_ <= nconv_; (j_)++) {
        rtemp_ = _scnrm2 (ncv_, &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
        rtemp_ = (real_4) (crealf (CMPLXF (1.0, 0.0))) / rtemp_;
        (void) _csscal (ncv_, &rtemp_, &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
        workev_[j_ - 1] = _cdotc (&j_, &workl_[ihbds_ - 1], &_k1, &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
      }
      if (msglvl_ > 2) {
        (void) _ccopy (&nconv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
        (void) _cvout (&debug_.logfil_, &nconv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_136);
        if (msglvl_ > 3) {
          (void) _cmout (&debug_.logfil_, ncv_, ncv_, &workl_[invsub_ - 1], &ldq_, &debug_.ndigit_, _dc_137);
        }
      }
      (void) _ccopy (&nconv_, workev_, &_k1, &workl_[ihbds_ - 1], &_k1);
      (void) _ctrmm (_dc_112, _dc_138, _dc_139, _dc_140, n_, &nconv_, ($11_ = CMPLXF (1.0, 0.0), &$11_), &workl_[invsub_ - 
      1], &ldq_, z_, ldz_);
    }
  }
  else {
    (void) _ccopy (&nconv_, &workl_[ritz_ - 1], &_k1, d_, &_k1);
    (void) _ccopy (&nconv_, &workl_[ritz_ - 1], &_k1, &workl_[iheig_ - 1], &_k1);
    (void) _ccopy (&nconv_, &workl_[bounds_ - 1], &_k1, &workl_[ihbds_ - 1], &_k1);
  }
  if ((strcasecmp (type_, _dc_119) == 0)) {
    if ((*rvec_)) {
      (void) _cscal (ncv_, &rnorm_, &workl_[ihbds_ - 1], &_k1);
    }
  }
  else {
    if ((*rvec_)) {
      (void) _cscal (ncv_, &rnorm_, &workl_[ihbds_ - 1], &_k1);
    }
    for (k_ = 1; k_ <= (*ncv_); (k_)++) {
      temp_ = workl_[iheig_ + k_ - 1 - 1];
      workl_[ihbds_ + k_ - 1 - 1] = workl_[ihbds_ + k_ - 1 - 1] / temp_ / temp_;
    }
  }
  if ((strcasecmp (type_, _dc_120) == 0)) {
    for (k_ = 1; k_ <= nconv_; (k_)++) {
      d_[k_ - 1] = CMPLXF (1.0, 0.0) / workl_[iheig_ + k_ - 1 - 1] + (*sigma_);
    }
  }
  if ((strcasecmp (type_, _dc_119) != 0) && msglvl_ > 1) {
    (void) _cvout (&debug_.logfil_, &nconv_, d_, &debug_.ndigit_, _dc_141);
    (void) _cvout (&debug_.logfil_, &nconv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_142);
  }
  else if (msglvl_ > 1) {
    (void) _cvout (&debug_.logfil_, &nconv_, d_, &debug_.ndigit_, _dc_143);
    (void) _cvout (&debug_.logfil_, &nconv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_144);
  }
  if ((*rvec_) && (strcasecmp (howmny_, _dc_44) == 0) && (strcasecmp (type_, _dc_120) == 0)) {
    for (j_ = 1; j_ <= nconv_; (j_)++) {
      if (workl_[iheig_ + j_ - 1 - 1] != CMPLXF (0.0, 0.0)) {
        workev_[j_ - 1] = workl_[invsub_ + (j_ - 1) * ldq_ + (*ncv_) - 1 - 1] / workl_[iheig_ + j_ - 1 - 1];
      }
    }
    (void) _cgeru (n_, &nconv_, ($12_ = CMPLXF (1.0, 0.0), &$12_), resid_, &_k1, workev_, &_k1, z_, ldz_);
  }
  _l9000:;
  __calls[7].calls++;
  return 0;
}

int_4 _cngets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, complex_8 _p_ ritz_, complex_8 _p_ 
bounds_)
{
  static int_4 msglvl_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 $1_, $3_, $4_;
  logical_4 $0_, $2_;
  (void) _second (&t0_);
  msglvl_ = debug_.mcgets_;
  (void) _csortc (which_, ($0_ = TRUE, &$0_), ($1_ = (*kev_) + (*np_), &$1_), ritz_, bounds_);
  if ((*ishift_) == 1) {
    (void) _csortc (_dc_60, ($2_ = TRUE, &$2_), np_, bounds_, ritz_);
  }
  (void) _second (&t1_);
  timing_.tcgets_ = timing_.tcgets_ + (t1_ - t0_);
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_145);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_146);
    (void) _cvout (&debug_.logfil_, ($3_ = (*kev_) + (*np_), &$3_), ritz_, &debug_.ndigit_, _dc_147);
    (void) _cvout (&debug_.logfil_, ($4_ = (*kev_) + (*np_), &$4_), bounds_, &debug_.ndigit_, _dc_148);
  }
  __calls[8].calls++;
  return 0;
}

int_4 _csortc (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, complex_8 _p_ x_, complex_8 _p_ y_)
{
  static int_4 i_, igap_, j_;
  static real_4 temp1_, temp2_;
  static complex_8 temp_;
  real_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern real_4 _slapy2 ();
  igap_ = (*n_) / 2;
  if ((strcasecmp (which_, _dc_59) == 0)) {
    _l10:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l20:;
      if (j_ < 0) {
        goto _l30;
      }
      temp1_ = _slapy2 (($0_ = (real_4) (crealf (x_[j_])), &$0_), ($1_ = cimagf (x_[j_]), &$1_));
      temp2_ = _slapy2 (($2_ = (real_4) (crealf (x_[j_ + igap_])), &$2_), ($3_ = cimagf (x_[j_ + igap_]), &$3_));
      if (temp1_ > temp2_) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l30;
      }
      j_ = j_ - igap_;
      goto _l20;
      _l30:;
    }
    igap_ = igap_ / 2;
    goto _l10;
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    _l40:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l50:;
      if (j_ < 0) {
        goto _l60;
      }
      temp1_ = _slapy2 (($4_ = (real_4) (crealf (x_[j_])), &$4_), ($5_ = cimagf (x_[j_]), &$5_));
      temp2_ = _slapy2 (($6_ = (real_4) (crealf (x_[j_ + igap_])), &$6_), ($7_ = cimagf (x_[j_ + igap_]), &$7_));
      if (temp1_ < temp2_) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l60;
      }
      j_ = j_ - igap_;
      goto _l50;
      _l60:;
    }
    igap_ = igap_ / 2;
    goto _l40;
  }
  else if ((strcasecmp (which_, _dc_61) == 0)) {
    _l70:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l80:;
      if (j_ < 0) {
        goto _l90;
      }
      if ((real_4) (crealf (x_[j_])) > (real_4) (crealf (x_[j_ + igap_]))) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l90;
      }
      j_ = j_ - igap_;
      goto _l80;
      _l90:;
    }
    igap_ = igap_ / 2;
    goto _l70;
  }
  else if ((strcasecmp (which_, _dc_62) == 0)) {
    _l100:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l110:;
      if (j_ < 0) {
        goto _l120;
      }
      if ((real_4) (crealf (x_[j_])) < (real_4) (crealf (x_[j_ + igap_]))) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l120;
      }
      j_ = j_ - igap_;
      goto _l110;
      _l120:;
    }
    igap_ = igap_ / 2;
    goto _l100;
  }
  else if ((strcasecmp (which_, _dc_63) == 0)) {
    _l130:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l140:;
      if (j_ < 0) {
        goto _l150;
      }
      if (cimagf (x_[j_]) > cimagf (x_[j_ + igap_])) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l150;
      }
      j_ = j_ - igap_;
      goto _l140;
      _l150:;
    }
    igap_ = igap_ / 2;
    goto _l130;
  }
  else if ((strcasecmp (which_, _dc_64) == 0)) {
    _l160:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l170:;
      if (j_ < 0) {
        goto _l180;
      }
      if (cimagf (x_[j_]) < cimagf (x_[j_ + igap_])) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l180;
      }
      j_ = j_ - igap_;
      goto _l170;
      _l180:;
    }
    igap_ = igap_ / 2;
    goto _l160;
  }
  _l9000:;
  __calls[9].calls++;
  return 0;
}

int_4 _cstatn (void)
{
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  timing_.nopx_ = 0;
  timing_.nbx_ = 0;
  timing_.nrorth_ = 0;
  timing_.nitref_ = 0;
  timing_.nrstrt_ = 0;
  timing_.tcaupd_ = 0.0;
  timing_.tcaup2_ = 0.0;
  timing_.tcaitr_ = 0.0;
  timing_.tceigh_ = 0.0;
  timing_.tcgets_ = 0.0;
  timing_.tcapps_ = 0.0;
  timing_.tcconv_ = 0.0;
  timing_.titref_ = 0.0;
  timing_.tgetv0_ = 0.0;
  timing_.trvec_ = 0.0;
  timing_.tmvopx_ = 0.0;
  timing_.tmvbx_ = 0.0;
  __calls[10].calls++;
  return 0;
}

int_4 _cvout (int_4 _p_ lout_, int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ idigit_, char _p_ ifmt_)
{
  static int_4 i_, ndigit_, k1_, k2_, lll_;
  static char_127 line_;
  int_4 $u_0_, __fcnt, __rc, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_, $u_10_, $u_11_, $u_12_, $u_13_, $u_14_, 
  $u_15_, $u_16_, $u_17_, $u_18_, $u_19_, $u_20_, $u_21_, $u_22_;
  char_127 $1_, $2_;
  static FORMAT $f_9999_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_9998_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9997_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9988_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9987_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9978_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9977_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9968_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9958_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9957_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9956_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9955_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9948_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9947_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9946_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9938_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9937_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9936_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9928_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9927_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9994_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  lll_ = _min ((int_4) strlen (ifmt_), 80);
  for (i_ = 1; i_ <= lll_; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_10);
  }
  for (i_ = lll_ + 1; i_ <= 80; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_11);
  }
  $u_0_ = (*lout_);
  _fcheck ("arpack:cvout:47", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:cvout:47", $u_0_));
    __fcnt += 3;
  }
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:cvout:47", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], ifmt_, CHARACTER, 0);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:cvout:47", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:cvout:47", $u_0_));
    __fcnt += 3;
  }
  bufcpy ($2_, _bufsub ((char *) $1_, (char *) line_, 1, lll_), 127);
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:cvout:47", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], $2_, CHARACTER, 127);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:cvout:47", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:cvout:47", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  _l9999:;
  if ((*n_) <= 0) {
    goto _l0;
  }
  ndigit_ = (*idigit_);
  if ((*idigit_) == 0) {
    ndigit_ = 4;
  }
  if ((*idigit_) < 0) {
    ndigit_ = -(*idigit_);
    if (ndigit_ <= 4) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        if (k1_ != (*n_)) {
          $u_3_ = (*lout_);
          _fcheck ("arpack:cvout:66", $u_3_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
            __fcnt += 3;
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
            __fcnt += 3;
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_3_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
              __fcnt += 3;
            }
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_3_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:cvout:66", $u_3_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_3_);
        }
        else {
          $u_4_ = (*lout_);
          _fcheck ("arpack:cvout:69", $u_4_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
            __fcnt += 3;
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_4_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
            __fcnt += 3;
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_4_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_4_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
              __fcnt += 3;
            }
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_4_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_4_, _ioerr_write ("arpack:cvout:69", $u_4_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_4_);
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        if (k1_ != (*n_)) {
          $u_5_ = (*lout_);
          _fcheck ("arpack:cvout:77", $u_5_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
            __fcnt += 3;
          }
          if ($f_9988_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_5_].unit, "\n");
            while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
          __fcnt += 3;
          while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
            if ($f_9988_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
            __fcnt += 3;
          }
          if ($f_9988_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_5_].unit, "\n");
            while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
          __fcnt += 3;
          while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
            if ($f_9988_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9988_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_5_].unit, "\n");
              while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
            __fcnt += 3;
            while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
              if ($f_9988_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
              __fcnt += 3;
            }
            if ($f_9988_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_5_].unit, "\n");
              while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
            __fcnt += 3;
            while ($f_9988_[__fcnt] != NULL && $f_9988_[__fcnt] == FMT_TEXT) {
              if ($f_9988_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_5_, $f_9988_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_5_, _ioerr_write ("arpack:cvout:77", $u_5_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_5_);
        }
        else {
          $u_6_ = (*lout_);
          _fcheck ("arpack:cvout:80", $u_6_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
            __fcnt += 3;
          }
          if ($f_9987_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
          __fcnt += 3;
          while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
            if ($f_9987_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
            __fcnt += 3;
          }
          if ($f_9987_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
          __fcnt += 3;
          while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
            if ($f_9987_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9987_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_6_].unit, "\n");
              while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
            __fcnt += 3;
            while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
              if ($f_9987_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
              __fcnt += 3;
            }
            if ($f_9987_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_6_].unit, "\n");
              while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
            __fcnt += 3;
            while ($f_9987_[__fcnt] != NULL && $f_9987_[__fcnt] == FMT_TEXT) {
              if ($f_9987_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_6_, $f_9987_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:cvout:80", $u_6_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_6_);
        }
      }
    }
    else if (ndigit_ <= 8) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        if (k1_ != (*n_)) {
          $u_7_ = (*lout_);
          _fcheck ("arpack:cvout:88", $u_7_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
            __fcnt += 3;
          }
          if ($f_9978_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
          __fcnt += 3;
          while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
            if ($f_9978_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
            __fcnt += 3;
          }
          if ($f_9978_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
          __fcnt += 3;
          while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
            if ($f_9978_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9978_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_7_].unit, "\n");
              while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
            __fcnt += 3;
            while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
              if ($f_9978_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
              __fcnt += 3;
            }
            if ($f_9978_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_7_].unit, "\n");
              while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
            __fcnt += 3;
            while ($f_9978_[__fcnt] != NULL && $f_9978_[__fcnt] == FMT_TEXT) {
              if ($f_9978_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_7_, $f_9978_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:cvout:88", $u_7_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_7_);
        }
        else {
          $u_8_ = (*lout_);
          _fcheck ("arpack:cvout:91", $u_8_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
            __fcnt += 3;
          }
          if ($f_9977_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
          __fcnt += 3;
          while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
            if ($f_9977_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
            __fcnt += 3;
          }
          if ($f_9977_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
          __fcnt += 3;
          while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
            if ($f_9977_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9977_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_8_].unit, "\n");
              while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
            __fcnt += 3;
            while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
              if ($f_9977_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
              __fcnt += 3;
            }
            if ($f_9977_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_8_].unit, "\n");
              while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
            __fcnt += 3;
            while ($f_9977_[__fcnt] != NULL && $f_9977_[__fcnt] == FMT_TEXT) {
              if ($f_9977_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_8_, $f_9977_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:cvout:91", $u_8_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_8_);
        }
      }
    }
    else {
      for (k1_ = 1; k1_ <= (*n_); (k1_)++) {
        $u_9_ = (*lout_);
        _fcheck ("arpack:cvout:97", $u_9_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
          __fcnt += 3;
        }
        if ($f_9968_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
        __fcnt += 3;
        while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
          if ($f_9968_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
          __fcnt += 3;
        }
        if ($f_9968_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
        __fcnt += 3;
        while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
          if ($f_9968_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
          __fcnt += 3;
        }
        if ($f_9968_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
        __fcnt += 3;
        while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
          if ($f_9968_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
          __fcnt += 3;
        }
        if ($f_9968_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
        __fcnt += 3;
        while ($f_9968_[__fcnt] != NULL && $f_9968_[__fcnt] == FMT_TEXT) {
          if ($f_9968_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_9968_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:cvout:97", $u_9_));
          __fcnt += 3;
        }
        _write_eol ($u_9_);
      }
    }
  }
  else {
    if (ndigit_ <= 4) {
      for (k1_ = 1; (4 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 4) {
        k2_ = _min ((*n_), k1_ + 3);
        if ((k1_ + 3) <= (*n_)) {
          $u_10_ = (*lout_);
          _fcheck ("arpack:cvout:110", $u_10_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
            __fcnt += 3;
          }
          if ($f_9958_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_10_].unit, "\n");
            while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
          __fcnt += 3;
          while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
            if ($f_9958_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
            __fcnt += 3;
          }
          if ($f_9958_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_10_].unit, "\n");
            while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
          __fcnt += 3;
          while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
            if ($f_9958_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9958_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_10_].unit, "\n");
              while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
            __fcnt += 3;
            while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
              if ($f_9958_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
              __fcnt += 3;
            }
            if ($f_9958_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_10_].unit, "\n");
              while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
            __fcnt += 3;
            while ($f_9958_[__fcnt] != NULL && $f_9958_[__fcnt] == FMT_TEXT) {
              if ($f_9958_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_10_, $f_9958_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:cvout:110", $u_10_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_10_);
        }
        else if ((k1_ + 3 - (*n_)) == 1) {
          $u_11_ = (*lout_);
          _fcheck ("arpack:cvout:113", $u_11_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
            __fcnt += 3;
          }
          if ($f_9957_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_11_].unit, "\n");
            while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
          __fcnt += 3;
          while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
            if ($f_9957_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
            __fcnt += 3;
          }
          if ($f_9957_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_11_].unit, "\n");
            while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
          __fcnt += 3;
          while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
            if ($f_9957_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9957_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_11_].unit, "\n");
              while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
            __fcnt += 3;
            while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
              if ($f_9957_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
              __fcnt += 3;
            }
            if ($f_9957_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_11_].unit, "\n");
              while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
            __fcnt += 3;
            while ($f_9957_[__fcnt] != NULL && $f_9957_[__fcnt] == FMT_TEXT) {
              if ($f_9957_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_11_, $f_9957_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:cvout:113", $u_11_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_11_);
        }
        else if ((k1_ + 3 - (*n_)) == 2) {
          $u_12_ = (*lout_);
          _fcheck ("arpack:cvout:116", $u_12_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
            __fcnt += 3;
          }
          if ($f_9956_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_12_].unit, "\n");
            while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
          __fcnt += 3;
          while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
            if ($f_9956_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
            __fcnt += 3;
          }
          if ($f_9956_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_12_].unit, "\n");
            while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
          __fcnt += 3;
          while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
            if ($f_9956_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9956_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_12_].unit, "\n");
              while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
            __fcnt += 3;
            while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
              if ($f_9956_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
              __fcnt += 3;
            }
            if ($f_9956_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_12_].unit, "\n");
              while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
            __fcnt += 3;
            while ($f_9956_[__fcnt] != NULL && $f_9956_[__fcnt] == FMT_TEXT) {
              if ($f_9956_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_12_, $f_9956_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:cvout:116", $u_12_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_12_);
        }
        else if ((k1_ + 3 - (*n_)) == 1) {
          $u_13_ = (*lout_);
          _fcheck ("arpack:cvout:119", $u_13_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
            __fcnt += 3;
          }
          if ($f_9955_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_13_].unit, "\n");
            while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
          __fcnt += 3;
          while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
            if ($f_9955_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
            __fcnt += 3;
          }
          if ($f_9955_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_13_].unit, "\n");
            while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
          __fcnt += 3;
          while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
            if ($f_9955_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9955_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_13_].unit, "\n");
              while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
            __fcnt += 3;
            while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
              if ($f_9955_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
              __fcnt += 3;
            }
            if ($f_9955_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_13_].unit, "\n");
              while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
            __fcnt += 3;
            while ($f_9955_[__fcnt] != NULL && $f_9955_[__fcnt] == FMT_TEXT) {
              if ($f_9955_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_13_, $f_9955_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_13_, _ioerr_write ("arpack:cvout:119", $u_13_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_13_);
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        if ((k1_ + 2) <= (*n_)) {
          $u_14_ = (*lout_);
          _fcheck ("arpack:cvout:127", $u_14_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
            __fcnt += 3;
          }
          if ($f_9948_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_14_].unit, "\n");
            while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
          __fcnt += 3;
          while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
            if ($f_9948_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
            __fcnt += 3;
          }
          if ($f_9948_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_14_].unit, "\n");
            while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
          __fcnt += 3;
          while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
            if ($f_9948_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9948_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_14_].unit, "\n");
              while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
            __fcnt += 3;
            while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
              if ($f_9948_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
              __fcnt += 3;
            }
            if ($f_9948_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_14_].unit, "\n");
              while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
            __fcnt += 3;
            while ($f_9948_[__fcnt] != NULL && $f_9948_[__fcnt] == FMT_TEXT) {
              if ($f_9948_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_14_, $f_9948_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_14_, _ioerr_write ("arpack:cvout:127", $u_14_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_14_);
        }
        else if ((k1_ + 2 - (*n_)) == 1) {
          $u_15_ = (*lout_);
          _fcheck ("arpack:cvout:130", $u_15_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
            __fcnt += 3;
          }
          if ($f_9947_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_15_].unit, "\n");
            while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
          __fcnt += 3;
          while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
            if ($f_9947_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
            __fcnt += 3;
          }
          if ($f_9947_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_15_].unit, "\n");
            while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
          __fcnt += 3;
          while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
            if ($f_9947_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9947_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_15_].unit, "\n");
              while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
            __fcnt += 3;
            while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
              if ($f_9947_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
              __fcnt += 3;
            }
            if ($f_9947_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_15_].unit, "\n");
              while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
            __fcnt += 3;
            while ($f_9947_[__fcnt] != NULL && $f_9947_[__fcnt] == FMT_TEXT) {
              if ($f_9947_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_15_, $f_9947_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_15_, _ioerr_write ("arpack:cvout:130", $u_15_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_15_);
        }
        else if ((k1_ + 2 - (*n_)) == 2) {
          $u_16_ = (*lout_);
          _fcheck ("arpack:cvout:133", $u_16_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
            __fcnt += 3;
          }
          if ($f_9946_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_16_].unit, "\n");
            while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
          __fcnt += 3;
          while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
            if ($f_9946_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
            __fcnt += 3;
          }
          if ($f_9946_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_16_].unit, "\n");
            while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
          __fcnt += 3;
          while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
            if ($f_9946_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9946_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_16_].unit, "\n");
              while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
            __fcnt += 3;
            while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
              if ($f_9946_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
              __fcnt += 3;
            }
            if ($f_9946_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_16_].unit, "\n");
              while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
            __fcnt += 3;
            while ($f_9946_[__fcnt] != NULL && $f_9946_[__fcnt] == FMT_TEXT) {
              if ($f_9946_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_16_, $f_9946_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:cvout:133", $u_16_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_16_);
        }
      }
    }
    else if (ndigit_ <= 8) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        if ((k1_ + 2) <= (*n_)) {
          $u_17_ = (*lout_);
          _fcheck ("arpack:cvout:141", $u_17_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
            __fcnt += 3;
          }
          if ($f_9938_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_17_].unit, "\n");
            while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
          __fcnt += 3;
          while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
            if ($f_9938_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
            __fcnt += 3;
          }
          if ($f_9938_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_17_].unit, "\n");
            while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
          __fcnt += 3;
          while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
            if ($f_9938_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9938_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_17_].unit, "\n");
              while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
            __fcnt += 3;
            while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
              if ($f_9938_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
              __fcnt += 3;
            }
            if ($f_9938_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_17_].unit, "\n");
              while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
            __fcnt += 3;
            while ($f_9938_[__fcnt] != NULL && $f_9938_[__fcnt] == FMT_TEXT) {
              if ($f_9938_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_17_, $f_9938_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:cvout:141", $u_17_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_17_);
        }
        else if ((k1_ + 2 - (*n_)) == 1) {
          $u_18_ = (*lout_);
          _fcheck ("arpack:cvout:144", $u_18_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
            __fcnt += 3;
          }
          if ($f_9937_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_18_].unit, "\n");
            while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
          __fcnt += 3;
          while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
            if ($f_9937_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
            __fcnt += 3;
          }
          if ($f_9937_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_18_].unit, "\n");
            while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
          __fcnt += 3;
          while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
            if ($f_9937_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9937_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_18_].unit, "\n");
              while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
            __fcnt += 3;
            while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
              if ($f_9937_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
              __fcnt += 3;
            }
            if ($f_9937_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_18_].unit, "\n");
              while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
            __fcnt += 3;
            while ($f_9937_[__fcnt] != NULL && $f_9937_[__fcnt] == FMT_TEXT) {
              if ($f_9937_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_18_, $f_9937_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:cvout:144", $u_18_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_18_);
        }
        else if ((k1_ + 2 - (*n_)) == 2) {
          $u_19_ = (*lout_);
          _fcheck ("arpack:cvout:147", $u_19_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
            __fcnt += 3;
          }
          if ($f_9936_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_19_].unit, "\n");
            while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
          __fcnt += 3;
          while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
            if ($f_9936_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
            __fcnt += 3;
          }
          if ($f_9936_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_19_].unit, "\n");
            while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
          __fcnt += 3;
          while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
            if ($f_9936_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9936_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_19_].unit, "\n");
              while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
            __fcnt += 3;
            while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
              if ($f_9936_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
              __fcnt += 3;
            }
            if ($f_9936_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_19_].unit, "\n");
              while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
            __fcnt += 3;
            while ($f_9936_[__fcnt] != NULL && $f_9936_[__fcnt] == FMT_TEXT) {
              if ($f_9936_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_19_, $f_9936_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("arpack:cvout:147", $u_19_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_19_);
        }
      }
    }
    else {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        if ((k1_ + 2) <= (*n_)) {
          $u_20_ = (*lout_);
          _fcheck ("arpack:cvout:155", $u_20_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
            __fcnt += 3;
          }
          if ($f_9928_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_20_].unit, "\n");
            while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
          __fcnt += 3;
          while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
            if ($f_9928_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
            __fcnt += 3;
          }
          if ($f_9928_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_20_].unit, "\n");
            while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
          __fcnt += 3;
          while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
            if ($f_9928_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9928_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_20_].unit, "\n");
              while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
            __fcnt += 3;
            while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
              if ($f_9928_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
              __fcnt += 3;
            }
            if ($f_9928_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_20_].unit, "\n");
              while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
            __fcnt += 3;
            while ($f_9928_[__fcnt] != NULL && $f_9928_[__fcnt] == FMT_TEXT) {
              if ($f_9928_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_20_, $f_9928_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_20_, _ioerr_write ("arpack:cvout:155", $u_20_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_20_);
        }
        else if ((k1_ + 2 - (*n_)) == 1) {
          $u_21_ = (*lout_);
          _fcheck ("arpack:cvout:158", $u_21_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
            __fcnt += 3;
          }
          if ($f_9927_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_21_].unit, "\n");
            while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], &k1_, INTEGER, 4);
          _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
          __fcnt += 3;
          while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
            if ($f_9927_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
            __fcnt += 3;
          }
          if ($f_9927_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_21_].unit, "\n");
            while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], &k2_, INTEGER, 4);
          _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
          __fcnt += 3;
          while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
            if ($f_9927_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
            __fcnt += 3;
          }
          for (i_ = k1_; i_ <= k2_; i_++) {
            if ($f_9927_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_21_].unit, "\n");
              while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, 8);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
            __fcnt += 3;
            while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
              if ($f_9927_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
              __fcnt += 3;
            }
            if ($f_9927_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_21_].unit, "\n");
              while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], &cx_[i_ - 1], COMPLEX, -8);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
            __fcnt += 3;
            while ($f_9927_[__fcnt] != NULL && $f_9927_[__fcnt] == FMT_TEXT) {
              if ($f_9927_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_21_, $f_9927_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:cvout:158", $u_21_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_21_);
        }
      }
    }
  }
  $u_22_ = (*lout_);
  _fcheck ("arpack:cvout:164", $u_22_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_22_, _ioerr_write ("arpack:cvout:164", $u_22_));
    __fcnt += 3;
  }
  _write_eol ($u_22_);
  goto _l0;
  _l9998:;
  _l9997:;
  _l9988:;
  _l9987:;
  _l9978:;
  _l9977:;
  _l9968:;
  _l9958:;
  _l9957:;
  _l9956:;
  _l9955:;
  _l9948:;
  _l9947:;
  _l9946:;
  _l9938:;
  _l9937:;
  _l9936:;
  _l9928:;
  _l9927:;
  _l9994:;
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _dgetv0 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ itry_, logical_4 _p_ initv_, int_4 _p_ n_, int_4 _p_ j_, 
real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ resid_, real_8 _p_ rnorm_, int_4 _p_ ipntr_, real_8 _p_ workd_, int_4 _p_ 
ierr_)
{
  static int_4 idist_, iseed_[4], iter_, msglvl_, jj_;
  static logical_4 first_, inits_, orth_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 rnorm0_;
  int_4 _data_k_4, $0_, $3_;
  real_8 $1_, $2_, $4_, $5_;
  extern int_4 _dlarnv ();
  extern int_4 _dcopy ();
  extern int_4 _dgemv ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
#define _data_n_4 1
  static logical_4 _data_l_4[_data_n_4] = {
    TRUE
  };
  if (__calls[12].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    inits_ = _data_l_4[_data_k_4++];
  }
  if (inits_) {
    iseed_[0] = 1;
    iseed_[1] = 3;
    iseed_[2] = 5;
    iseed_[3] = 7;
    inits_ = FALSE;
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mgetv0_;
    (*ierr_) = 0;
    iter_ = 0;
    first_ = FALSE;
    orth_ = FALSE;
    if (! ((*initv_))) {
      idist_ = 2;
      (void) _dlarnv (&idist_, iseed_, n_, resid_);
    }
    (void) _second (&t2_);
    if ((strcasecmp (bmat_, _dc_0) == 0)) {
      timing_.nopx_ = timing_.nopx_ + 1;
      ipntr_[0] = 1;
      ipntr_[1] = (*n_) + 1;
      (void) _dcopy (n_, resid_, &_k1, workd_, &_k1);
      (*ido_) = -1;
      goto _l9000;
    }
  }
  if (first_) {
    goto _l20;
  }
  if (orth_) {
    goto _l40;
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  }
  (void) _second (&t2_);
  first_ = TRUE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _dcopy (n_, &workd_[(*n_) + 1 - 1], &_k1, resid_, &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l20:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  first_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm0_ = _ddot (n_, resid_, &_k1, workd_, &_k1);
    rnorm0_ = sqrt (_abs (rnorm0_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm0_ = _dnrm2 (n_, resid_, &_k1);
  }
  (*rnorm_) = rnorm0_;
  if ((*j_) == 1) {
    goto _l50;
  }
  orth_ = TRUE;
  _l30:;
  (void) _dgemv (_dc_150, n_, ($0_ = (*j_) - 1, &$0_), ($1_ = 1.0, &$1_), v_, ldv_, workd_, &_k1, ($2_ = 0.0, &$2_), 
  &workd_[(*n_) + 1 - 1], &_k1);
  (void) _dgemv (_dc_3, n_, ($3_ = (*j_) - 1, &$3_), ($4_ = -1.0, &$4_), v_, ldv_, &workd_[(*n_) + 1 - 1], &_k1, ($5_ = 
  1.0, &$5_), resid_, &_k1);
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _dcopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l40:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (*rnorm_) = _ddot (n_, resid_, &_k1, workd_, &_k1);
    (*rnorm_) = sqrt (_abs ((*rnorm_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _dnrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _dvout (&debug_.logfil_, &_k1, &rnorm0_, &debug_.ndigit_, _dc_4);
    (void) _dvout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_5);
  }
  if ((*rnorm_) > 0.717 * rnorm0_) {
    goto _l50;
  }
  iter_ = iter_ + 1;
  if (iter_ <= 5) {
    rnorm0_ = (*rnorm_);
    goto _l30;
  }
  else {
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = 0.0;
    }
    (*rnorm_) = 0.0;
    (*ierr_) = -1;
  }
  _l50:;
  if (msglvl_ > 0) {
    (void) _dvout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_6);
  }
  if (msglvl_ > 3) {
    (void) _dvout (&debug_.logfil_, n_, resid_, &debug_.ndigit_, _dc_7);
  }
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tgetv0_ = timing_.tgetv0_ + (t1_ - t0_);
  _l9000:;
  __calls[12].calls++;
  return 0;
}

int_4 _dlaqrb (logical_4 _p_ wantt_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, real_8 _p_ h_, int_4 _p_ ldh_, 
real_8 _p_ wr_, real_8 _p_ wi_, real_8 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, itn_, its_, j_, k_, l_, m_, nh_, nr_;
  static real_8 cs_, h00_, h10_, h11_, h12_, h21_, h22_, h33_, h33s_, h43h34_, h44_, h44s_, ovfl_, s_, smlnum_, sn_, sum_
  , t1_, t2_, t3_, tst1_, ulp_, unfl_, v1_, v2_, v3_, v_[3], work_[1];
  int_4 $0_, $1_, $2_;
  extern real_8 _dlamch ();
  extern real_8 _dlanhs ();
  extern int_4 _dcopy ();
  extern int_4 _dlabad ();
  extern int_4 _dlanv2 ();
  extern int_4 _dlarfg ();
  extern int_4 _drot ();
  (*info_) = 0;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*ilo_) == (*ihi_)) {
    wr_[(*ilo_) - 1] = h_[(*ilo_) - 1 + ((*ldh_)) * (((*ilo_) - 1))];
    wi_[(*ilo_) - 1] = 0.0;
    goto _l0;
  }
  for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  z_[(*n_) - 1] = 1.0;
  nh_ = (*ihi_) - (*ilo_) + 1;
  unfl_ = _dlamch (_dc_24);
  ovfl_ = 1.0 / unfl_;
  (void) _dlabad (&unfl_, &ovfl_);
  ulp_ = _dlamch (_dc_25);
  smlnum_ = unfl_ * (nh_ / ulp_);
  if ((*wantt_)) {
    i1_ = 1;
    i2_ = (*n_);
    for (i_ = 1; i_ <= i2_ - 2; (i_)++) {
      h_[i1_ + i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = 0.0;
    }
  }
  else {
    for (i_ = 1; i_ <= (*ihi_) - (*ilo_) - 1; (i_)++) {
      h_[(*ilo_) + i_ + 1 - 1 + ((*ldh_)) * (((*ilo_) + i_ - 1 - 1))] = 0.0;
    }
  }
  itn_ = 30 * nh_;
  i_ = (*ihi_);
  _l10:;
  l_ = (*ilo_);
  if (i_ < (*ilo_)) {
    goto _l150;
  }
  for (its_ = 0; its_ <= itn_; (its_)++) {
    for (k_ = i_; k_ >= l_ + 1; (k_)--) {
      tst1_ = _abs (h_[k_ - 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))]) + _abs (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1))]);
      if (tst1_ == 0.0) {
        tst1_ = _dlanhs (_dc_34, ($0_ = i_ - l_ + 1, &$0_), &h_[l_ - 1 + ((*ldh_)) * ((l_ - 1))], ldh_, work_);
      }
      if (_abs (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))]) <= _max (ulp_ * tst1_, smlnum_)) {
        goto _l30;
      }
    }
    _l30:;
    l_ = k_;
    if (l_ > (*ilo_)) {
      h_[l_ - 1 + ((*ldh_)) * ((l_ - 1 - 1))] = 0.0;
    }
    if (l_ >= i_ - 1) {
      goto _l140;
    }
    if (! ((*wantt_))) {
      i1_ = l_;
      i2_ = i_;
    }
    if (its_ == 10 || its_ == 20) {
      s_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))]) + _abs (h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 2 - 1))]);
      h44_ = 0.75 * s_;
      h33_ = h44_;
      h43h34_ = -0.4375 * s_ * s_;
    }
    else {
      h44_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
      h33_ = h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))];
      h43h34_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] * h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))];
    }
    for (m_ = i_ - 2; m_ >= l_; (m_)--) {
      h11_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1))];
      h22_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h21_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))];
      h12_ = h_[m_ - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h44s_ = h44_ - h11_;
      h33s_ = h33_ - h11_;
      v1_ = (h33s_ * h44s_ - h43h34_) / h21_ + h12_;
      v2_ = h22_ - h11_ - h33s_ - h44s_;
      v3_ = h_[m_ + 2 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      s_ = _abs (v1_) + _abs (v2_) + _abs (v3_);
      v1_ = v1_ / s_;
      v2_ = v2_ / s_;
      v3_ = v3_ / s_;
      v_[0] = v1_;
      v_[1] = v2_;
      v_[2] = v3_;
      if (m_ == l_) {
        goto _l50;
      }
      h00_ = h_[m_ - 1 - 1 + ((*ldh_)) * ((m_ - 1 - 1))];
      h10_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1 - 1))];
      tst1_ = _abs (v1_) * (_abs (h00_) + _abs (h11_) + _abs (h22_));
      if (_abs (h10_) * (_abs (v2_) + _abs (v3_)) <= ulp_ * tst1_) {
        goto _l50;
      }
    }
    _l50:;
    for (k_ = m_; k_ <= i_ - 1; (k_)++) {
      nr_ = _min (3, i_ - k_ + 1);
      if (k_ > m_) {
        (void) _dcopy (&nr_, &h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))], &_k1, v_, &_k1);
      }
      (void) _dlarfg (&nr_, &v_[0], &v_[1], &_k1, &t1_);
      if (k_ > m_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = v_[0];
        h_[k_ + 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = 0.0;
        if (k_ < i_ - 1) {
          h_[k_ + 2 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = 0.0;
        }
      }
      else if (m_ > l_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = -h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))];
      }
      v2_ = v_[1];
      t2_ = t1_ * v2_;
      if (nr_ == 3) {
        v3_ = v_[2];
        t3_ = t1_ * v3_;
        for (j_ = k_; j_ <= i2_; (j_)++) {
          sum_ = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + v2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] + v3_ * h_[k_ + 2 - 1 + 
          ((*ldh_)) * ((j_ - 1))];
          h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t1_;
          h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t2_;
          h_[k_ + 2 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 2 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t3_;
        }
        for (j_ = i1_; j_ <= _min (k_ + 3, i_); (j_)++) {
          sum_ = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + v2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] + v3_ * h_[j_ - 1 + 
          ((*ldh_)) * ((k_ + 2 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_ * t1_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * t2_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 2 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 2 - 1))] - sum_ * t3_;
        }
        sum_ = z_[k_ - 1] + v2_ * z_[k_ + 1 - 1] + v3_ * z_[k_ + 2 - 1];
        z_[k_ - 1] = z_[k_ - 1] - sum_ * t1_;
        z_[k_ + 1 - 1] = z_[k_ + 1 - 1] - sum_ * t2_;
        z_[k_ + 2 - 1] = z_[k_ + 2 - 1] - sum_ * t3_;
      }
      else if (nr_ == 2) {
        for (j_ = k_; j_ <= i2_; (j_)++) {
          sum_ = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + v2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
          h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t1_;
          h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t2_;
        }
        for (j_ = i1_; j_ <= i_; (j_)++) {
          sum_ = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + v2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_ * t1_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * t2_;
        }
        sum_ = z_[k_ - 1] + v2_ * z_[k_ + 1 - 1];
        z_[k_ - 1] = z_[k_ - 1] - sum_ * t1_;
        z_[k_ + 1 - 1] = z_[k_ + 1 - 1] - sum_ * t2_;
      }
    }
  }
  (*info_) = i_;
  goto _l0;
  _l140:;
  if (l_ == i_) {
    wr_[i_ - 1] = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
    wi_[i_ - 1] = 0.0;
  }
  else if (l_ == i_ - 1) {
    (void) _dlanv2 (&h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))], &h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))], &h_[i_ - 1 + 
    ((*ldh_)) * ((i_ - 1 - 1))], &h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))], &wr_[i_ - 1 - 1], &wi_[i_ - 1 - 1], &wr_[i_ - 1], 
    &wi_[i_ - 1], &cs_, &sn_);
    if ((*wantt_)) {
      if (i2_ > i_) {
        (void) _drot (($1_ = i2_ - i_, &$1_), &h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))], ldh_, &h_[i_ - 1 + ((*ldh_)) * ((i_ 
        + 1 - 1))], ldh_, &cs_, &sn_);
      }
      (void) _drot (($2_ = i_ - i1_ - 1, &$2_), &h_[i1_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))], &_k1, &h_[i1_ - 1 + ((*ldh_)) * 
      ((i_ - 1))], &_k1, &cs_, &sn_);
      sum_ = cs_ * z_[i_ - 1 - 1] + sn_ * z_[i_ - 1];
      z_[i_ - 1] = cs_ * z_[i_ - 1] - sn_ * z_[i_ - 1 - 1];
      z_[i_ - 1 - 1] = sum_;
    }
  }
  itn_ = itn_ - its_;
  i_ = l_ - 1;
  goto _l10;
  _l150:;
  _l0:;
  __calls[13].calls++;
  return 0;
}

int_4 _dmout (int_4 _p_ lout_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ idigit_, char _p_ 
ifmt_)
{
  static int_4 i_, j_, k1_, k2_, lll_, ndigit_;
  static char_1 icol_[3];
  static char_127 line_;
  int_4 _data_k_5, $u_0_, __fcnt, __rc, $u_3_, _k_5, $u_6_, $u_7_, _k_9, $u_10_, $u_11_, _k_13, $u_14_, $u_15_, _k_17, 
  $u_18_, $u_19_, _k_21, $u_22_, $u_23_, _k_25, $u_26_, $u_27_, _k_29, $u_30_, $u_31_, _k_33, $u_34_, $u_35_;
  char_1 _p_ _arr_4, _p_ _arr_8, _p_ _arr_12, _p_ _arr_16, _p_ _arr_20, _p_ _arr_24, _p_ _arr_28, _p_ _arr_32;
  char_127 $1_, $2_;
  static FORMAT $f_9999_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_9998_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  static FORMAT $f_9997_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    NULL, NULL, NULL
  };
  static FORMAT $f_9996_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    NULL, NULL, NULL
  };
  static FORMAT $f_9995_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    NULL, NULL, NULL
  };
  static FORMAT $f_9994_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9993_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9992_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9991_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%22e","%22.13.0e",
    FMT_REAL,"%22e","%22.13.0e",
    FMT_REAL,"%22e","%22.13.0e",
    FMT_REAL,"%22e","%22.13.0e",
    FMT_REAL,"%22e","%22.13.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9990_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
#define _data_n_5 3
  static char_1 _data_l_5[_data_n_5] = {
    _dc_2,
    _dc_8,
    _dc_9
  };
  if (__calls[14].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    bufcpy (icol_[0], _data_l_5[_data_k_5++], 1);
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    bufcpy (icol_[1], _data_l_5[_data_k_5++], 1);
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    bufcpy (icol_[2], _data_l_5[_data_k_5++], 1);
  }
  lll_ = _min ((int_4) strlen (ifmt_), 80);
  for (i_ = 1; i_ <= lll_; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_10);
  }
  for (i_ = lll_ + 1; i_ <= 80; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_11);
  }
  $u_0_ = (*lout_);
  _fcheck ("arpack:dmout:60", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:dmout:60", $u_0_));
    __fcnt += 3;
  }
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:dmout:60", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], ifmt_, CHARACTER, 0);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:dmout:60", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:dmout:60", $u_0_));
    __fcnt += 3;
  }
  bufcpy ($2_, _bufsub ((char *) $1_, (char *) line_, 1, lll_), 127);
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:dmout:60", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], $2_, CHARACTER, 127);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:dmout:60", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:dmout:60", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  _l9999:;
  if ((*m_) <= 0 || (*n_) <= 0 || (*lda_) <= 0) {
    goto _l0;
  }
  ndigit_ = (*idigit_);
  if ((*idigit_) == 0) {
    ndigit_ = 4;
  }
  if ((*idigit_) < 0) {
    ndigit_ = -(*idigit_);
    if (ndigit_ <= 4) {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_3_ = (*lout_);
        _fcheck ("arpack:dmout:78", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:dmout:78", $u_3_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_4 = (char_1 _p_) icol_, _k_5 = 0; _k_5 < 3; _arr_4++, _k_5++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_3_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_3_, _ioerr_write ("arpack:dmout:78", $u_3_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], _arr_4, CHARACTER, 1);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:dmout:78", $u_3_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:dmout:78", $u_3_));
              __fcnt += 3;
            }
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:dmout:78", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:dmout:78", $u_3_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:dmout:78", $u_3_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_3_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_6_ = (*lout_);
          _fcheck ("arpack:dmout:80", $u_6_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:dmout:80", $u_6_));
            __fcnt += 3;
          }
          if ($f_9994_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:dmout:80", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:dmout:80", $u_6_));
          __fcnt += 3;
          while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
            if ($f_9994_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:dmout:80", $u_6_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9994_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_6_].unit, "\n");
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:dmout:80", $u_6_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:dmout:80", $u_6_));
            __fcnt += 3;
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:dmout:80", $u_6_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_6_);
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (4 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 4) {
        k2_ = _min ((*n_), k1_ + 3);
        $u_7_ = (*lout_);
        _fcheck ("arpack:dmout:87", $u_7_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:dmout:87", $u_7_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_8 = (char_1 _p_) icol_, _k_9 = 0; _k_9 < 3; _arr_8++, _k_9++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_7_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:dmout:87", $u_7_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], _arr_8, CHARACTER, 1);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:dmout:87", $u_7_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:dmout:87", $u_7_));
              __fcnt += 3;
            }
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:dmout:87", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:dmout:87", $u_7_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:dmout:87", $u_7_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_7_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_10_ = (*lout_);
          _fcheck ("arpack:dmout:89", $u_10_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:dmout:89", $u_10_));
            __fcnt += 3;
          }
          if ($f_9993_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_10_].unit, "\n");
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:dmout:89", $u_10_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:dmout:89", $u_10_));
          __fcnt += 3;
          while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
            if ($f_9993_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:dmout:89", $u_10_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9993_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_10_].unit, "\n");
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_10_, _ioerr_write ("arpack:dmout:89", $u_10_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:dmout:89", $u_10_));
            __fcnt += 3;
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:dmout:89", $u_10_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_10_);
        }
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_11_ = (*lout_);
        _fcheck ("arpack:dmout:96", $u_11_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_11_, _ioerr_write ("arpack:dmout:96", $u_11_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_12 = (char_1 _p_) icol_, _k_13 = 0; _k_13 < 3; _arr_12++, _k_13++) {
            if ($f_9996_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_11_].unit, "\n");
              while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:dmout:96", $u_11_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], _arr_12, CHARACTER, 1);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:dmout:96", $u_11_));
            __fcnt += 3;
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              if ($f_9996_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:dmout:96", $u_11_));
              __fcnt += 3;
            }
          }
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_11_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:dmout:96", $u_11_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_11_, _ioerr_write ("arpack:dmout:96", $u_11_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:dmout:96", $u_11_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_11_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_14_ = (*lout_);
          _fcheck ("arpack:dmout:98", $u_14_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:dmout:98", $u_14_));
            __fcnt += 3;
          }
          if ($f_9992_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_14_].unit, "\n");
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_14_, _ioerr_write ("arpack:dmout:98", $u_14_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_14_, _ioerr_write ("arpack:dmout:98", $u_14_));
          __fcnt += 3;
          while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
            if ($f_9992_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:dmout:98", $u_14_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9992_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_14_].unit, "\n");
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_14_, _ioerr_write ("arpack:dmout:98", $u_14_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:dmout:98", $u_14_));
            __fcnt += 3;
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_14_, _ioerr_write ("arpack:dmout:98", $u_14_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_14_);
        }
      }
    }
    else {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_15_ = (*lout_);
        _fcheck ("arpack:dmout:105", $u_15_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_15_, _ioerr_write ("arpack:dmout:105", $u_15_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_16 = (char_1 _p_) icol_, _k_17 = 0; _k_17 < 3; _arr_16++, _k_17++) {
            if ($f_9995_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_15_].unit, "\n");
              while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_15_, _ioerr_write ("arpack:dmout:105", $u_15_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], _arr_16, CHARACTER, 1);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:dmout:105", $u_15_));
            __fcnt += 3;
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              if ($f_9995_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_15_, _ioerr_write ("arpack:dmout:105", $u_15_));
              __fcnt += 3;
            }
          }
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_15_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_15_, _ioerr_write ("arpack:dmout:105", $u_15_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_15_, _ioerr_write ("arpack:dmout:105", $u_15_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:dmout:105", $u_15_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_15_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_18_ = (*lout_);
          _fcheck ("arpack:dmout:107", $u_18_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:dmout:107", $u_18_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_18_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:dmout:107", $u_18_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:dmout:107", $u_18_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:dmout:107", $u_18_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9991_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_18_].unit, "\n");
              while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_18_, _ioerr_write ("arpack:dmout:107", $u_18_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:dmout:107", $u_18_));
            __fcnt += 3;
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              if ($f_9991_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:dmout:107", $u_18_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_18_);
        }
      }
    }
  }
  else {
    if (ndigit_ <= 4) {
      for (k1_ = 1; (10 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 10) {
        k2_ = _min ((*n_), k1_ + 9);
        $u_19_ = (*lout_);
        _fcheck ("arpack:dmout:120", $u_19_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_19_, _ioerr_write ("arpack:dmout:120", $u_19_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_20 = (char_1 _p_) icol_, _k_21 = 0; _k_21 < 3; _arr_20++, _k_21++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_19_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_19_, _ioerr_write ("arpack:dmout:120", $u_19_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], _arr_20, CHARACTER, 1);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:dmout:120", $u_19_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("arpack:dmout:120", $u_19_));
              __fcnt += 3;
            }
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_19_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("arpack:dmout:120", $u_19_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_19_, _ioerr_write ("arpack:dmout:120", $u_19_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:dmout:120", $u_19_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_19_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_22_ = (*lout_);
          _fcheck ("arpack:dmout:122", $u_22_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:dmout:122", $u_22_));
            __fcnt += 3;
          }
          if ($f_9994_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_22_].unit, "\n");
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("arpack:dmout:122", $u_22_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_22_, _ioerr_write ("arpack:dmout:122", $u_22_));
          __fcnt += 3;
          while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
            if ($f_9994_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:dmout:122", $u_22_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9994_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_22_].unit, "\n");
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_22_, _ioerr_write ("arpack:dmout:122", $u_22_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:dmout:122", $u_22_));
            __fcnt += 3;
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("arpack:dmout:122", $u_22_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_22_);
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (8 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 8) {
        k2_ = _min ((*n_), k1_ + 7);
        $u_23_ = (*lout_);
        _fcheck ("arpack:dmout:129", $u_23_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_23_, _ioerr_write ("arpack:dmout:129", $u_23_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_24 = (char_1 _p_) icol_, _k_25 = 0; _k_25 < 3; _arr_24++, _k_25++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_23_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_23_, _ioerr_write ("arpack:dmout:129", $u_23_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], _arr_24, CHARACTER, 1);
            _write_err (__rc, $u_23_, _ioerr_write ("arpack:dmout:129", $u_23_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_23_, _ioerr_write ("arpack:dmout:129", $u_23_));
              __fcnt += 3;
            }
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_23_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_23_, _ioerr_write ("arpack:dmout:129", $u_23_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_23_, _ioerr_write ("arpack:dmout:129", $u_23_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_23_, _ioerr_write ("arpack:dmout:129", $u_23_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_23_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_26_ = (*lout_);
          _fcheck ("arpack:dmout:131", $u_26_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_26_, _ioerr_write ("arpack:dmout:131", $u_26_));
            __fcnt += 3;
          }
          if ($f_9993_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_26_].unit, "\n");
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:dmout:131", $u_26_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_26_, _ioerr_write ("arpack:dmout:131", $u_26_));
          __fcnt += 3;
          while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
            if ($f_9993_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_26_, _ioerr_write ("arpack:dmout:131", $u_26_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9993_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_26_].unit, "\n");
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_26_, _ioerr_write ("arpack:dmout:131", $u_26_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_26_, _ioerr_write ("arpack:dmout:131", $u_26_));
            __fcnt += 3;
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:dmout:131", $u_26_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_26_);
        }
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (6 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 6) {
        k2_ = _min ((*n_), k1_ + 5);
        $u_27_ = (*lout_);
        _fcheck ("arpack:dmout:138", $u_27_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_27_, _ioerr_write ("arpack:dmout:138", $u_27_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_28 = (char_1 _p_) icol_, _k_29 = 0; _k_29 < 3; _arr_28++, _k_29++) {
            if ($f_9996_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_27_].unit, "\n");
              while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_27_, _ioerr_write ("arpack:dmout:138", $u_27_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], _arr_28, CHARACTER, 1);
            _write_err (__rc, $u_27_, _ioerr_write ("arpack:dmout:138", $u_27_));
            __fcnt += 3;
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              if ($f_9996_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:dmout:138", $u_27_));
              __fcnt += 3;
            }
          }
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_27_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:dmout:138", $u_27_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_27_, _ioerr_write ("arpack:dmout:138", $u_27_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_27_, _ioerr_write ("arpack:dmout:138", $u_27_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_27_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_30_ = (*lout_);
          _fcheck ("arpack:dmout:140", $u_30_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_30_, _ioerr_write ("arpack:dmout:140", $u_30_));
            __fcnt += 3;
          }
          if ($f_9992_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_30_].unit, "\n");
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_30_, _ioerr_write ("arpack:dmout:140", $u_30_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_30_, _ioerr_write ("arpack:dmout:140", $u_30_));
          __fcnt += 3;
          while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
            if ($f_9992_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_30_, _ioerr_write ("arpack:dmout:140", $u_30_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9992_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_30_].unit, "\n");
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_30_, _ioerr_write ("arpack:dmout:140", $u_30_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_30_, _ioerr_write ("arpack:dmout:140", $u_30_));
            __fcnt += 3;
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_30_, _ioerr_write ("arpack:dmout:140", $u_30_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_30_);
        }
      }
    }
    else {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_31_ = (*lout_);
        _fcheck ("arpack:dmout:147", $u_31_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_31_, _ioerr_write ("arpack:dmout:147", $u_31_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_32 = (char_1 _p_) icol_, _k_33 = 0; _k_33 < 3; _arr_32++, _k_33++) {
            if ($f_9995_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_31_].unit, "\n");
              while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_31_, _ioerr_write ("arpack:dmout:147", $u_31_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], _arr_32, CHARACTER, 1);
            _write_err (__rc, $u_31_, _ioerr_write ("arpack:dmout:147", $u_31_));
            __fcnt += 3;
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              if ($f_9995_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_31_, _ioerr_write ("arpack:dmout:147", $u_31_));
              __fcnt += 3;
            }
          }
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_31_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_31_, _ioerr_write ("arpack:dmout:147", $u_31_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_31_, _ioerr_write ("arpack:dmout:147", $u_31_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_31_, _ioerr_write ("arpack:dmout:147", $u_31_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_31_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_34_ = (*lout_);
          _fcheck ("arpack:dmout:149", $u_34_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("arpack:dmout:149", $u_34_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_34_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:dmout:149", $u_34_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_34_, _ioerr_write ("arpack:dmout:149", $u_34_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("arpack:dmout:149", $u_34_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9991_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_34_].unit, "\n");
              while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_34_, _ioerr_write ("arpack:dmout:149", $u_34_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_34_, _ioerr_write ("arpack:dmout:149", $u_34_));
            __fcnt += 3;
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              if ($f_9991_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:dmout:149", $u_34_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_34_);
        }
      }
    }
  }
  $u_35_ = (*lout_);
  _fcheck ("arpack:dmout:154", $u_35_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9990_[__fcnt] != NULL && $f_9990_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_35_, $f_9990_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_35_, _ioerr_write ("arpack:dmout:154", $u_35_));
    __fcnt += 3;
  }
  _write_eol ($u_35_);
  _l9998:;
  _l9997:;
  _l9996:;
  _l9995:;
  _l9994:;
  _l9993:;
  _l9992:;
  _l9991:;
  _l9990:;
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _dnaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ nb_, real_8 _p_ 
resid_, real_8 _p_ rnorm_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, real_8 _p_ 
workd_, int_4 _p_ info_)
{
  static int_4 ierr_, i_, infol_, ipj_, irj_, ivj_, iter_, itry_, j_, msglvl_, jj_;
  static logical_4 first_, orth1_, orth2_, rstart_, step3_, step4_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 betaj_, ovfl_, temp1_, rnorm1_, smlnum_, tst1_, ulp_, unfl_, wnorm_, xtemp_[2];
  int_4 _data_k_6, $7_, $13_, $14_, $15_, $16_;
  logical_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $8_, $9_, $10_, $11_, $12_;
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern int_4 _dscal ();
  extern int_4 _dgemv ();
  extern int_4 _dlabad ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern real_8 _dlanhs ();
  extern real_8 _dlamch ();
#define _data_n_6 1
  static logical_4 _data_l_6[_data_n_6] = {
    TRUE
  };
  if (__calls[15].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    first_ = _data_l_6[_data_k_6++];
  }
  if (first_) {
    unfl_ = _dlamch (_dc_24);
    ovfl_ = 1.0 / unfl_;
    (void) _dlabad (&unfl_, &ovfl_);
    ulp_ = _dlamch (_dc_25);
    smlnum_ = unfl_ * ((*n_) / ulp_);
    first_ = FALSE;
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mnaitr_;
    (*info_) = 0;
    step3_ = FALSE;
    step4_ = FALSE;
    rstart_ = FALSE;
    orth1_ = FALSE;
    orth2_ = FALSE;
    j_ = (*k_) + 1;
    ipj_ = 1;
    irj_ = ipj_ + (*n_);
    ivj_ = irj_ + (*n_);
  }
  if (step3_) {
    goto _l50;
  }
  if (step4_) {
    goto _l60;
  }
  if (orth1_) {
    goto _l70;
  }
  if (orth2_) {
    goto _l90;
  }
  if (rstart_) {
    goto _l30;
  }
  _l1000:;
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_26);
    (void) _dvout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_27);
  }
  betaj_ = (*rnorm_);
  if ((*rnorm_) > 0.0) {
    goto _l40;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_28);
  }
  betaj_ = 0.0;
  timing_.nrstrt_ = timing_.nrstrt_ + 1;
  itry_ = 1;
  _l20:;
  rstart_ = TRUE;
  (*ido_) = 0;
  _l30:;
  (void) _dgetv0 (ido_, bmat_, &itry_, ($0_ = FALSE, &$0_), n_, &j_, v_, ldv_, resid_, rnorm_, ipntr_, workd_, &ierr_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if (ierr_ < 0) {
    itry_ = itry_ + 1;
    if (itry_ <= 3) {
      goto _l20;
    }
    (*info_) = j_ - 1;
    (void) _second (&t1_);
    timing_.tnaitr_ = timing_.tnaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    goto _l9000;
  }
  _l40:;
  (void) _dcopy (n_, resid_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
  if ((*rnorm_) >= unfl_) {
    temp1_ = 1.0 / (*rnorm_);
    (void) _dscal (n_, &temp1_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
    (void) _dscal (n_, &temp1_, &workd_[ipj_ - 1], &_k1);
  }
  else {
    (void) _dlascl (_dc_29, &i_, &i_, rnorm_, ($1_ = 1.0, &$1_), n_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], n_, &infol_);
    (void) _dlascl (_dc_29, &i_, &i_, rnorm_, ($2_ = 1.0, &$2_), n_, &_k1, &workd_[ipj_ - 1], n_, &infol_);
  }
  step3_ = TRUE;
  timing_.nopx_ = timing_.nopx_ + 1;
  (void) _second (&t2_);
  (void) _dcopy (n_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1, &workd_[ivj_ - 1], &_k1);
  ipntr_[0] = ivj_;
  ipntr_[1] = irj_;
  ipntr_[2] = ipj_;
  (*ido_) = 1;
  goto _l9000;
  _l50:;
  (void) _second (&t3_);
  timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  step3_ = FALSE;
  (void) _dcopy (n_, &workd_[irj_ - 1], &_k1, resid_, &_k1);
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    step4_ = TRUE;
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l60:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  step4_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    wnorm_ = _ddot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    wnorm_ = sqrt (_abs (wnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    wnorm_ = _dnrm2 (n_, resid_, &_k1);
  }
  (void) _dgemv (_dc_150, n_, &j_, ($3_ = 1.0, &$3_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($4_ = 0.0, &$4_), &h_[0 + 
  ((*ldh_)) * ((j_ - 1))], &_k1);
  (void) _dgemv (_dc_3, n_, &j_, ($5_ = -1.0, &$5_), v_, ldv_, &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1, ($6_ = 1.0, &$6_), 
  resid_, &_k1);
  if (j_ > 1) {
    h_[j_ - 1 + ((*ldh_)) * ((j_ - 1 - 1))] = betaj_;
  }
  (void) _second (&t4_);
  orth1_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _dcopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l70:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  orth1_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (*rnorm_) = _ddot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    (*rnorm_) = sqrt (_abs ((*rnorm_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _dnrm2 (n_, resid_, &_k1);
  }
  if ((*rnorm_) > 0.717 * wnorm_) {
    goto _l100;
  }
  iter_ = 0;
  timing_.nrorth_ = timing_.nrorth_ + 1;
  _l80:;
  if (msglvl_ > 2) {
    xtemp_[0] = wnorm_;
    xtemp_[1] = (*rnorm_);
    (void) _dvout (&debug_.logfil_, ($7_ = 2, &$7_), xtemp_, &debug_.ndigit_, _dc_155);
    (void) _dvout (&debug_.logfil_, &j_, &h_[0 + ((*ldh_)) * ((j_ - 1))], &debug_.ndigit_, _dc_31);
  }
  (void) _dgemv (_dc_150, n_, &j_, ($8_ = 1.0, &$8_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($9_ = 0.0, &$9_), &workd_[irj_ 
  - 1], &_k1);
  (void) _dgemv (_dc_3, n_, &j_, ($10_ = -1.0, &$10_), v_, ldv_, &workd_[irj_ - 1], &_k1, ($11_ = 1.0, &$11_), resid_, 
  &_k1);
  (void) _daxpy (&j_, ($12_ = 1.0, &$12_), &workd_[irj_ - 1], &_k1, &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1);
  orth2_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _dcopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l90:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm1_ = _ddot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    rnorm1_ = sqrt (_abs (rnorm1_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm1_ = _dnrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 0 && iter_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_32);
    if (msglvl_ > 2) {
      xtemp_[0] = (*rnorm_);
      xtemp_[1] = rnorm1_;
      (void) _dvout (&debug_.logfil_, ($13_ = 2, &$13_), xtemp_, &debug_.ndigit_, _dc_33);
    }
  }
  if (rnorm1_ > 0.717 * (*rnorm_)) {
    (*rnorm_) = rnorm1_;
  }
  else {
    timing_.nitref_ = timing_.nitref_ + 1;
    (*rnorm_) = rnorm1_;
    iter_ = iter_ + 1;
    if (iter_ <= 1) {
      goto _l80;
    }
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = 0.0;
    }
    (*rnorm_) = 0.0;
  }
  _l100:;
  rstart_ = FALSE;
  orth2_ = FALSE;
  (void) _second (&t5_);
  timing_.titref_ = timing_.titref_ + (t5_ - t4_);
  j_ = j_ + 1;
  if (j_ > (*k_) + (*np_)) {
    (void) _second (&t1_);
    timing_.tnaitr_ = timing_.tnaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    for (i_ = _max (1, (*k_)); i_ <= (*k_) + (*np_) - 1; (i_)++) {
      tst1_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]);
      if (tst1_ == 0.0) {
        tst1_ = _dlanhs (_dc_34, ($14_ = (*k_) + (*np_), &$14_), h_, ldh_, &workd_[(*n_) + 1 - 1]);
      }
      if (_abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))]) <= _max (ulp_ * tst1_, smlnum_)) {
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = 0.0;
      }
    }
    if (msglvl_ > 2) {
      (void) _dmout (&debug_.logfil_, ($15_ = (*k_) + (*np_), &$15_), ($16_ = (*k_) + (*np_), &$16_), h_, ldh_, 
      &debug_.ndigit_, _dc_35);
    }
    goto _l9000;
  }
  goto _l1000;
  _l9000:;
  __calls[15].calls++;
  return 0;
}

int_4 _dnapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, real_8 _p_ shiftr_, real_8 _p_ shifti_, real_8 _p_ v_, 
int_4 _p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ resid_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ workl_, 
real_8 _p_ workd_)
{
  static int_4 i_, iend_, ir_, istart_, j_, jj_, kplusp_, msglvl_, nr_;
  static logical_4 cconj_, first_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 c_, f_, g_, h11_, h12_, h21_, h22_, h32_, ovfl_, r_, s_, sigmai_, sigmar_, smlnum_, ulp_, unfl_, u_[3], 
  t_, tau_, tst1_;
  int_4 _data_k_7, $2_, $3_, $4_, $6_, $8_, $12_;
  real_8 $0_, $1_, $5_, $7_, $9_, $10_, $11_, $13_, $14_;
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern int_4 _dscal ();
  extern int_4 _dlacpy ();
  extern int_4 _dlarfg ();
  extern int_4 _dlarf ();
  extern int_4 _dlaset ();
  extern int_4 _dlabad ();
  extern int_4 _dlartg ();
  extern real_8 _dlamch ();
  extern real_8 _dlanhs ();
  extern real_8 _dlapy2 ();
#define _data_n_7 1
  static logical_4 _data_l_7[_data_n_7] = {
    TRUE
  };
  if (__calls[16].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    first_ = _data_l_7[_data_k_7++];
  }
  if (first_) {
    unfl_ = _dlamch (_dc_24);
    ovfl_ = 1.0 / unfl_;
    (void) _dlabad (&unfl_, &ovfl_);
    ulp_ = _dlamch (_dc_25);
    smlnum_ = unfl_ * ((*n_) / ulp_);
    first_ = FALSE;
  }
  (void) _second (&t0_);
  msglvl_ = debug_.mnapps_;
  kplusp_ = (*kev_) + (*np_);
  (void) _dlaset (_dc_36, &kplusp_, &kplusp_, ($0_ = 0.0, &$0_), ($1_ = 1.0, &$1_), q_, ldq_);
  if ((*np_) == 0) {
    goto _l9000;
  }
  cconj_ = FALSE;
  for (jj_ = 1; jj_ <= (*np_); (jj_)++) {
    sigmar_ = shiftr_[jj_ - 1];
    sigmai_ = shifti_[jj_ - 1];
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_37);
      (void) _dvout (&debug_.logfil_, &_k1, &sigmar_, &debug_.ndigit_, _dc_156);
      (void) _dvout (&debug_.logfil_, &_k1, &sigmai_, &debug_.ndigit_, _dc_157);
    }
    if (cconj_) {
      cconj_ = FALSE;
      goto _l110;
    }
    else if (jj_ < (*np_) && _abs (sigmai_) > 0.0) {
      cconj_ = TRUE;
    }
    else if (jj_ == (*np_) && _abs (sigmai_) > 0.0) {
      (*kev_) = (*kev_) + 1;
      goto _l110;
    }
    istart_ = 1;
    _l20:;
    for (i_ = istart_; i_ <= kplusp_ - 1; (i_)++) {
      tst1_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]);
      if (tst1_ == 0.0) {
        tst1_ = _dlanhs (_dc_34, ($2_ = kplusp_ - jj_ + 1, &$2_), h_, ldh_, workl_);
      }
      if (_abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))]) <= _max (ulp_ * tst1_, smlnum_)) {
        if (msglvl_ > 0) {
          (void) _ivout (&debug_.logfil_, &_k1, &i_, &debug_.ndigit_, _dc_39);
          (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_40);
          (void) _dvout (&debug_.logfil_, &_k1, &h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))], &debug_.ndigit_, _dc_41);
        }
        iend_ = i_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = 0.0;
        goto _l40;
      }
    }
    iend_ = kplusp_;
    _l40:;
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &istart_, &debug_.ndigit_, _dc_42);
      (void) _ivout (&debug_.logfil_, &_k1, &iend_, &debug_.ndigit_, _dc_43);
    }
    if (istart_ == iend_) {
      goto _l100;
    }
    if (istart_ + 1 == iend_ && _abs (sigmai_) > 0.0) {
      goto _l100;
    }
    h11_ = h_[istart_ - 1 + ((*ldh_)) * ((istart_ - 1))];
    h21_ = h_[istart_ + 1 - 1 + ((*ldh_)) * ((istart_ - 1))];
    if (_abs (sigmai_) <= 0.0) {
      f_ = h11_ - sigmar_;
      g_ = h21_;
      for (i_ = istart_; i_ <= iend_ - 1; (i_)++) {
        (void) _dlartg (&f_, &g_, &c_, &s_, &r_);
        if (i_ > istart_) {
          if (r_ < 0.0) {
            r_ = -r_;
            c_ = -c_;
            s_ = -s_;
          }
          h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = r_;
          h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = 0.0;
        }
        for (j_ = i_; j_ <= kplusp_; (j_)++) {
          t_ = c_ * h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] + s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
          h_[i_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = -s_ * h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] + c_ * h_[i_ + 1 - 1 + ((*ldh_)) * 
          ((j_ - 1))];
          h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] = t_;
        }
        for (j_ = 1; j_ <= _min (i_ + 2, iend_); (j_)++) {
          t_ = c_ * h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] + s_ * h_[j_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))] = -s_ * h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] + c_ * h_[j_ - 1 + ((*ldh_)) * ((i_ 
          + 1 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] = t_;
        }
        for (j_ = 1; j_ <= _min (i_ + jj_, kplusp_); (j_)++) {
          t_ = c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))];
          q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))] = -s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ 
          + 1 - 1))];
          q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] = t_;
        }
        if (i_ < iend_ - 1) {
          f_ = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))];
          g_ = h_[i_ + 2 - 1 + ((*ldh_)) * ((i_ - 1))];
        }
      }
    }
    else {
      h12_ = h_[istart_ - 1 + ((*ldh_)) * ((istart_ + 1 - 1))];
      h22_ = h_[istart_ + 1 - 1 + ((*ldh_)) * ((istart_ + 1 - 1))];
      h32_ = h_[istart_ + 2 - 1 + ((*ldh_)) * ((istart_ + 1 - 1))];
      s_ = 2.0 * sigmar_;
      t_ = _dlapy2 (&sigmar_, &sigmai_);
      u_[0] = (h11_ * (h11_ - s_) + t_ * t_) / h21_ + h12_;
      u_[1] = h11_ + h22_ - s_;
      u_[2] = h32_;
      for (i_ = istart_; i_ <= iend_ - 1; (i_)++) {
        nr_ = _min (3, iend_ - i_ + 1);
        (void) _dlarfg (&nr_, &u_[0], &u_[1], &_k1, &tau_);
        if (i_ > istart_) {
          h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = u_[0];
          h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = 0.0;
          if (i_ < iend_ - 1) {
            h_[i_ + 2 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = 0.0;
          }
        }
        u_[0] = 1.0;
        (void) _dlarf (_dc_158, &nr_, ($3_ = kplusp_ - i_ + 1, &$3_), u_, &_k1, &tau_, &h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))], 
        ldh_, workl_);
        ir_ = _min (i_ + 3, iend_);
        (void) _dlarf (_dc_112, &ir_, &nr_, u_, &_k1, &tau_, &h_[0 + ((*ldh_)) * ((i_ - 1))], ldh_, workl_);
        (void) _dlarf (_dc_112, &kplusp_, &nr_, u_, &_k1, &tau_, &q_[0 + ((*ldq_)) * ((i_ - 1))], ldq_, workl_);
        if (i_ < iend_ - 1) {
          u_[0] = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))];
          u_[1] = h_[i_ + 2 - 1 + ((*ldh_)) * ((i_ - 1))];
          if (i_ < iend_ - 2) {
            u_[2] = h_[i_ + 3 - 1 + ((*ldh_)) * ((i_ - 1))];
          }
        }
      }
    }
    _l100:;
    istart_ = iend_ + 1;
    if (iend_ < kplusp_) {
      goto _l20;
    }
    _l110:;
  }
  for (j_ = 1; j_ <= (*kev_); (j_)++) {
    if (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] < 0.0) {
      (void) _dscal (($4_ = kplusp_ - j_ + 1, &$4_), ($5_ = -1.0, &$5_), &h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))], ldh_);
      (void) _dscal (($6_ = _min (j_ + 2, kplusp_), &$6_), ($7_ = -1.0, &$7_), &h_[0 + ((*ldh_)) * ((j_ + 1 - 1))], &_k1);
      (void) _dscal (($8_ = _min (j_ + (*np_) + 1, kplusp_), &$8_), ($9_ = -1.0, &$9_), &q_[0 + ((*ldq_)) * ((j_ + 1 - 1))], 
      &_k1);
    }
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    tst1_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]);
    if (tst1_ == 0.0) {
      tst1_ = _dlanhs (_dc_34, kev_, h_, ldh_, workl_);
    }
    if (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] <= _max (ulp_ * tst1_, smlnum_)) {
      h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = 0.0;
    }
  }
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))] > 0.0) {
    (void) _dgemv (_dc_3, n_, &kplusp_, ($10_ = 1.0, &$10_), v_, ldv_, &q_[0 + ((*ldq_)) * (((*kev_) + 1 - 1))], &_k1, 
    ($11_ = 0.0, &$11_), &workd_[(*n_) + 1 - 1], &_k1);
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    (void) _dgemv (_dc_3, n_, ($12_ = kplusp_ - i_ + 1, &$12_), ($13_ = 1.0, &$13_), v_, ldv_, &q_[0 + ((*ldq_)) * 
    (((*kev_) - i_ + 1 - 1))], &_k1, ($14_ = 0.0, &$14_), workd_, &_k1);
    (void) _dcopy (n_, workd_, &_k1, &v_[0 + ((*ldv_)) * ((kplusp_ - i_ + 1 - 1))], &_k1);
  }
  (void) _dlacpy (_dc_44, n_, kev_, &v_[0 + ((*ldv_)) * ((kplusp_ - (*kev_) + 1 - 1))], ldv_, v_, ldv_);
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))] > 0.0) {
    (void) _dcopy (n_, &workd_[(*n_) + 1 - 1], &_k1, &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1);
  }
  (void) _dscal (n_, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], resid_, &_k1);
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))] > 0.0) {
    (void) _daxpy (n_, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))], &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1, 
    resid_, &_k1);
  }
  if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &_k1, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_45);
    (void) _dvout (&debug_.logfil_, &_k1, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_46);
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_47);
    if (msglvl_ > 2) {
      (void) _dmout (&debug_.logfil_, kev_, kev_, h_, ldh_, &debug_.ndigit_, _dc_48);
    }
  }
  _l9000:;
  (void) _second (&t1_);
  timing_.tnapps_ = timing_.tnapps_ + (t1_ - t0_);
  __calls[16].calls++;
  return 0;
}

int_4 _dnaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, real_8 _p_ 
tol_, real_8 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, real_8 _p_ v_, int_4 
_p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ ritzr_, real_8 _p_ ritzi_, real_8 _p_ bounds_, real_8 _p_ q_, int_4 
_p_ ldq_, real_8 _p_ workl_, int_4 _p_ ipntr_, real_8 _p_ workd_, int_4 _p_ info_)
{
  static int_4 ierr_, iter_, j_, kplusp_, msglvl_, nconv_, nevbef_, nev0_, np0_, nptemp_, numcnv_, kp_[4];
  static logical_4 cnorm_, getv0_, initv_, update_, ushift_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 rnorm_, temp_, eps23_;
  static char_3 wprime_;
  int_4 $0_, $5_;
  logical_4 $1_, $2_, $3_, $4_;
  extern int_4 _dcopy ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern real_8 _dlapy2 ();
  extern real_8 _dlamch ();
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mnaup2_;
    eps23_ = _dlamch (_dc_49);
    eps23_ = pow (eps23_, 6.6666666666666667e-1);
    nev0_ = (*nev_);
    np0_ = (*np_);
    kplusp_ = (*nev_) + (*np_);
    nconv_ = 0;
    iter_ = 0;
    getv0_ = TRUE;
    update_ = FALSE;
    ushift_ = FALSE;
    cnorm_ = FALSE;
    if ((*info_) != 0) {
      initv_ = TRUE;
      (*info_) = 0;
    }
    else {
      initv_ = FALSE;
    }
  }
  if (getv0_) {
    (void) _dgetv0 (ido_, bmat_, &_k1, &initv_, n_, &_k1, v_, ldv_, resid_, &rnorm_, ipntr_, workd_, info_);
    if ((*ido_) != 99) {
      goto _l9000;
    }
    if (rnorm_ == 0.0) {
      (*info_) = -9;
      goto _l1100;
    }
    getv0_ = FALSE;
    (*ido_) = 0;
  }
  if (update_) {
    goto _l20;
  }
  if (ushift_) {
    goto _l50;
  }
  if (cnorm_) {
    goto _l100;
  }
  (void) _dnaitr (ido_, bmat_, n_, &_k0, nev_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  _l1000:;
  iter_ = iter_ + 1;
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &iter_, &debug_.ndigit_, _dc_50);
  }
  (*np_) = kplusp_ - (*nev_);
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, nev_, &debug_.ndigit_, _dc_51);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_52);
  }
  (*ido_) = 0;
  _l20:;
  update_ = TRUE;
  (void) _dnaitr (ido_, bmat_, n_, nev_, np_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  update_ = FALSE;
  if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_53);
  }
  (void) _dneigh (&rnorm_, &kplusp_, h_, ldh_, ritzr_, ritzi_, bounds_, q_, ldq_, workl_, &ierr_);
  if (ierr_ != 0) {
    (*info_) = -8;
    goto _l1200;
  }
  (void) _dcopy (&kplusp_, ritzr_, &_k1, &workl_[(kplusp_ * kplusp_) + 1 - 1], &_k1);
  (void) _dcopy (&kplusp_, ritzi_, &_k1, &workl_[(kplusp_ * kplusp_) + kplusp_ + 1 - 1], &_k1);
  (void) _dcopy (&kplusp_, bounds_, &_k1, &workl_[(kplusp_ * kplusp_) + 2 * kplusp_ + 1 - 1], &_k1);
  (*nev_) = nev0_;
  (*np_) = np0_;
  numcnv_ = (*nev_);
  (void) _dngets (ishift_, which_, nev_, np_, ritzr_, ritzi_, bounds_, workl_, &workl_[(*np_) + 1 - 1]);
  if ((*nev_) == nev0_ + 1) {
    numcnv_ = nev0_ + 1;
  }
  (void) _dcopy (nev_, &bounds_[(*np_) + 1 - 1], &_k1, &workl_[2 * (*np_) + 1 - 1], &_k1);
  (void) _dnconv (nev_, &ritzr_[(*np_) + 1 - 1], &ritzi_[(*np_) + 1 - 1], &workl_[2 * (*np_) + 1 - 1], tol_, &nconv_);
  if (msglvl_ > 2) {
    kp_[0] = (*nev_);
    kp_[1] = (*np_);
    kp_[2] = numcnv_;
    kp_[3] = nconv_;
    (void) _ivout (&debug_.logfil_, ($0_ = 4, &$0_), kp_, &debug_.ndigit_, _dc_159);
    (void) _dvout (&debug_.logfil_, &kplusp_, ritzr_, &debug_.ndigit_, _dc_160);
    (void) _dvout (&debug_.logfil_, &kplusp_, ritzi_, &debug_.ndigit_, _dc_161);
    (void) _dvout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_56);
  }
  nptemp_ = (*np_);
  for (j_ = 1; j_ <= nptemp_; (j_)++) {
    if (bounds_[j_ - 1] == 0.0) {
      (*np_) = (*np_) - 1;
      (*nev_) = (*nev_) + 1;
    }
  }
  if ((nconv_ >= numcnv_) || (iter_ > (*mxiter_)) || ((*np_) == 0)) {
    if (msglvl_ > 4) {
      (void) _dvout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + 1 - 1], &debug_.ndigit_, _dc_162);
      (void) _dvout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + kplusp_ + 1 - 1], &debug_.ndigit_, _dc_163);
      (void) _dvout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + kplusp_ * 2 + 1 - 1], &debug_.ndigit_, _dc_164)
      ;
    }
    h_[2 + ((*ldh_)) * ((0))] = rnorm_;
    if ((strcasecmp (which_, _dc_59) == 0)) {
      bufcpy (wprime_, _dc_62, 3);
    }
    if ((strcasecmp (which_, _dc_60) == 0)) {
      bufcpy (wprime_, _dc_61, 3);
    }
    if ((strcasecmp (which_, _dc_61) == 0)) {
      bufcpy (wprime_, _dc_60, 3);
    }
    if ((strcasecmp (which_, _dc_62) == 0)) {
      bufcpy (wprime_, _dc_59, 3);
    }
    if ((strcasecmp (which_, _dc_63) == 0)) {
      bufcpy (wprime_, _dc_60, 3);
    }
    if ((strcasecmp (which_, _dc_64) == 0)) {
      bufcpy (wprime_, _dc_59, 3);
    }
    (void) _dsortc (wprime_, ($1_ = TRUE, &$1_), &kplusp_, ritzr_, ritzi_, bounds_);
    if ((strcasecmp (which_, _dc_59) == 0)) {
      bufcpy (wprime_, _dc_60, 3);
    }
    if ((strcasecmp (which_, _dc_60) == 0)) {
      bufcpy (wprime_, _dc_59, 3);
    }
    if ((strcasecmp (which_, _dc_61) == 0)) {
      bufcpy (wprime_, _dc_62, 3);
    }
    if ((strcasecmp (which_, _dc_62) == 0)) {
      bufcpy (wprime_, _dc_61, 3);
    }
    if ((strcasecmp (which_, _dc_63) == 0)) {
      bufcpy (wprime_, _dc_64, 3);
    }
    if ((strcasecmp (which_, _dc_64) == 0)) {
      bufcpy (wprime_, _dc_63, 3);
    }
    (void) _dsortc (wprime_, ($2_ = TRUE, &$2_), &kplusp_, ritzr_, ritzi_, bounds_);
    for (j_ = 1; j_ <= numcnv_; (j_)++) {
      temp_ = _max (eps23_, _dlapy2 (&ritzr_[j_ - 1], &ritzi_[j_ - 1]));
      bounds_[j_ - 1] = bounds_[j_ - 1] / temp_;
    }
    bufcpy (wprime_, _dc_61, 3);
    (void) _dsortc (wprime_, ($3_ = TRUE, &$3_), &numcnv_, bounds_, ritzr_, ritzi_);
    for (j_ = 1; j_ <= numcnv_; (j_)++) {
      temp_ = _max (eps23_, _dlapy2 (&ritzr_[j_ - 1], &ritzi_[j_ - 1]));
      bounds_[j_ - 1] = bounds_[j_ - 1] * temp_;
    }
    (void) _dsortc (which_, ($4_ = TRUE, &$4_), &nconv_, ritzr_, ritzi_, bounds_);
    if (msglvl_ > 1) {
      (void) _dvout (&debug_.logfil_, &kplusp_, ritzr_, &debug_.ndigit_, _dc_165);
      (void) _dvout (&debug_.logfil_, &kplusp_, ritzi_, &debug_.ndigit_, _dc_166);
      (void) _dvout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_66);
    }
    if (iter_ > (*mxiter_) && nconv_ < numcnv_) {
      (*info_) = 1;
    }
    if ((*np_) == 0 && nconv_ < numcnv_) {
      (*info_) = 2;
    }
    (*np_) = nconv_;
    goto _l1100;
  }
  else if ((nconv_ < numcnv_) && ((*ishift_) == 1)) {
    nevbef_ = (*nev_);
    (*nev_) = (*nev_) + _min (nconv_, (*np_) / 2);
    if ((*nev_) == 1 && kplusp_ >= 6) {
      (*nev_) = kplusp_ / 2;
    }
    else if ((*nev_) == 1 && kplusp_ > 3) {
      (*nev_) = 2;
    }
    (*np_) = kplusp_ - (*nev_);
    if (nevbef_ < (*nev_)) {
      (void) _dngets (ishift_, which_, nev_, np_, ritzr_, ritzi_, bounds_, workl_, &workl_[(*np_) + 1 - 1]);
    }
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_67);
    if (msglvl_ > 1) {
      kp_[0] = (*nev_);
      kp_[1] = (*np_);
      (void) _ivout (&debug_.logfil_, ($5_ = 2, &$5_), kp_, &debug_.ndigit_, _dc_68);
      (void) _dvout (&debug_.logfil_, nev_, &ritzr_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_167);
      (void) _dvout (&debug_.logfil_, nev_, &ritzi_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_168);
      (void) _dvout (&debug_.logfil_, nev_, &bounds_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_70);
    }
  }
  if ((*ishift_) == 0) {
    ushift_ = TRUE;
    (*ido_) = 3;
    goto _l9000;
  }
  _l50:;
  ushift_ = FALSE;
  if ((*ishift_) == 0) {
    (void) _dcopy (np_, workl_, &_k1, ritzr_, &_k1);
    (void) _dcopy (np_, &workl_[(*np_) + 1 - 1], &_k1, ritzi_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_71);
    (void) _dvout (&debug_.logfil_, np_, ritzr_, &debug_.ndigit_, _dc_169);
    (void) _dvout (&debug_.logfil_, np_, ritzi_, &debug_.ndigit_, _dc_170);
    if ((*ishift_) == 1) {
      (void) _dvout (&debug_.logfil_, np_, bounds_, &debug_.ndigit_, _dc_73);
    }
  }
  (void) _dnapps (n_, nev_, np_, ritzr_, ritzi_, v_, ldv_, h_, ldh_, resid_, q_, ldq_, workl_, workd_);
  cnorm_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _dcopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l100:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm_ = _ddot (n_, resid_, &_k1, workd_, &_k1);
    rnorm_ = sqrt (_abs (rnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm_ = _dnrm2 (n_, resid_, &_k1);
  }
  cnorm_ = FALSE;
  if (msglvl_ > 2) {
    (void) _dvout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_74);
    (void) _dmout (&debug_.logfil_, nev_, nev_, h_, ldh_, &debug_.ndigit_, _dc_75);
  }
  goto _l1000;
  _l1100:;
  (*mxiter_) = iter_;
  (*nev_) = numcnv_;
  _l1200:;
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tnaup2_ = t1_ - t0_;
  _l9000:;
  __calls[17].calls++;
  return 0;
}

int_4 _dnaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_, real_8 
_p_ resid_, int_4 _p_ ncv_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_8 _p_ workd_, 
real_8 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, iq_, ishift_, iupd_, iw_, ldh_, ldq_, levec_, mode_, msglvl_, mxiter_, nb_, nev0_, 
  next_, np_, ritzi_, ritzr_, j_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 __rc_0, __fcnt, __rc;
  extern real_8 _dlamch ();
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_173, _dc_173,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_84, _dc_84,
    FMT_TEXT, _dc_174, _dc_174,
    FMT_TEXT, _dc_86, _dc_86,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_88, _dc_88,
    FMT_TEXT, _dc_89, _dc_89,
    FMT_TEXT, _dc_90, _dc_90,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_91, _dc_91,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_1100_[] = {
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_92, _dc_92,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_93, _dc_93,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_94, _dc_94,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_96, _dc_96,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_97, _dc_97,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_98, _dc_98,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_99, _dc_99,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_101, _dc_101,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_102, _dc_102,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_103, _dc_103,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_104, _dc_104,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_105, _dc_105,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_106, _dc_106,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_107, _dc_107,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_108, _dc_108,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_109, _dc_109,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  if ((*ido_) == 0) {
    (void) _dstatn ();
    (void) _second (&t0_);
    msglvl_ = debug_.mnaupd_;
    ierr_ = 0;
    ishift_ = iparam_[0];
    mxiter_ = iparam_[2];
    nb_ = 1;
    iupd_ = 1;
    mode_ = iparam_[6];
    _fcheck ("arpack:dnaupd:500", 6, action_write, form_formatted);
    __rc_0 = _vif_printf (6, "%s", which_, CHARACTER, 3);
    _write_err (__rc_0, 6, _ioerr_write ("arpack:dnaupd:500", 6));
    _write_eol (6);
    if ((*n_) <= 0) {
      ierr_ = -1;
    }
    else if ((*nev_) <= 0) {
      ierr_ = -2;
    }
    else if ((*ncv_) <= (*nev_) + 1 || (*ncv_) > (*n_)) {
      ierr_ = -3;
    }
    else if (mxiter_ <= 0) {
      ierr_ = -4;
    }
    else if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_61) != 0) 
      && (strcasecmp (which_, _dc_62) != 0) && (strcasecmp (which_, _dc_63) != 0) && (strcasecmp (which_, _dc_64) != 0)) {
      ierr_ = -5;
    }
    else if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
      ierr_ = -6;
    }
    else if ((*lworkl_) < 3 * ((*ncv_) * (*ncv_)) + 6 * (*ncv_)) {
      ierr_ = -7;
    }
    else if (mode_ < 1 || mode_ > 4) {
      ierr_ = -10;
    }
    else if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
      ierr_ = -11;
    }
    else if (ishift_ < 0 || ishift_ > 1) {
      ierr_ = -12;
    }
    if (ierr_ != 0) {
      (*info_) = ierr_;
      (*ido_) = 99;
      goto _l9000;
    }
    if (nb_ <= 0) {
      nb_ = 1;
    }
    if ((*tol_) <= 0.0) {
      (*tol_) = _dlamch (_dc_76);
    }
    np_ = (*ncv_) - (*nev_);
    nev0_ = (*nev_);
    for (j_ = 1; j_ <= 3 * ((*ncv_) * (*ncv_)) + 6 * (*ncv_); (j_)++) {
      workl_[j_ - 1] = 0.0;
    }
    ldh_ = (*ncv_);
    ldq_ = (*ncv_);
    ih_ = 1;
    ritzr_ = ih_ + ldh_ * (*ncv_);
    ritzi_ = ritzr_ + (*ncv_);
    bounds_ = ritzi_ + (*ncv_);
    iq_ = bounds_ + (*ncv_);
    iw_ = iq_ + ldq_ * (*ncv_);
    next_ = iw_ + ((*ncv_) * (*ncv_)) + 3 * (*ncv_);
    ipntr_[3] = next_;
    ipntr_[4] = ih_;
    ipntr_[5] = ritzr_;
    ipntr_[6] = ritzi_;
    ipntr_[7] = bounds_;
    ipntr_[13] = iw_;
  }
  (void) _dnaup2 (ido_, bmat_, n_, which_, &nev0_, &np_, tol_, resid_, &mode_, &iupd_, &ishift_, &mxiter_, v_, ldv_, 
  &workl_[ih_ - 1], &ldh_, &workl_[ritzr_ - 1], &workl_[ritzi_ - 1], &workl_[bounds_ - 1], &workl_[iq_ - 1], &ldq_, 
  &workl_[iw_ - 1], ipntr_, workd_, info_);
  if ((*ido_) == 3) {
    iparam_[7] = np_;
  }
  if ((*ido_) != 99) {
    goto _l9000;
  }
  iparam_[2] = mxiter_;
  iparam_[4] = np_;
  iparam_[8] = timing_.nopx_;
  iparam_[9] = timing_.nbx_;
  iparam_[10] = timing_.nrorth_;
  if ((*info_) < 0) {
    goto _l9000;
  }
  if ((*info_) == 2) {
    (*info_) = 3;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &mxiter_, &debug_.ndigit_, _dc_77);
    (void) _ivout (&debug_.logfil_, &_k1, &np_, &debug_.ndigit_, _dc_78);
    (void) _dvout (&debug_.logfil_, &np_, &workl_[ritzr_ - 1], &debug_.ndigit_, _dc_171);
    (void) _dvout (&debug_.logfil_, &np_, &workl_[ritzi_ - 1], &debug_.ndigit_, _dc_172);
    (void) _dvout (&debug_.logfil_, &np_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_80);
  }
  (void) _second (&t1_);
  timing_.tnaupd_ = t1_ - t0_;
  if (msglvl_ > 0) {
    _fcheck ("arpack:dnaupd:653", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:653", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _fcheck ("arpack:dnaupd:654", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &mxiter_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nopx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nbx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrorth_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nitref_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrstrt_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvopx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvbx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnaupd_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnaup2_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnaitr_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.titref_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tgetv0_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tneigh_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tngets_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnapps_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnconv_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.trvec_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dnaupd:654", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _l1000:;
    _l1100:;
  }
  _l9000:;
  __calls[18].calls++;
  return 0;
}

int_4 _dnconv (int_4 _p_ n_, real_8 _p_ ritzr_, real_8 _p_ ritzi_, real_8 _p_ bounds_, real_8 _p_ tol_, int_4 _p_ 
nconv_)
{
  static int_4 i_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 temp_, eps23_;
  extern real_8 _dlapy2 ();
  extern real_8 _dlamch ();
  (void) _second (&t0_);
  eps23_ = _dlamch (_dc_49);
  eps23_ = pow (eps23_, 6.6666666666666667e-1);
  (*nconv_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    temp_ = _max (eps23_, _dlapy2 (&ritzr_[i_ - 1], &ritzi_[i_ - 1]));
    if (bounds_[i_ - 1] <= (*tol_) * temp_) {
      (*nconv_) = (*nconv_) + 1;
    }
  }
  (void) _second (&t1_);
  timing_.tnconv_ = timing_.tnconv_ + (t1_ - t0_);
  __calls[19].calls++;
  return 0;
}

int_4 _dneigh (real_8 _p_ rnorm_, int_4 _p_ n_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ ritzr_, real_8 _p_ ritzi_, 
real_8 _p_ bounds_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ workl_, int_4 _p_ ierr_)
{
  static int_4 i_, iconj_, msglvl_;
  static logical_4 select_[1];
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 temp_, vl_[1];
  logical_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern int_4 _dlacpy ();
  extern int_4 _dtrevc ();
  extern real_8 _dlapy2 ();
  extern real_8 _dnrm2 ();
  (void) _second (&t0_);
  msglvl_ = debug_.mneigh_;
  if (msglvl_ > 2) {
    (void) _dmout (&debug_.logfil_, n_, n_, h_, ldh_, &debug_.ndigit_, _dc_110);
  }
  (void) _dlacpy (_dc_36, n_, n_, h_, ldh_, workl_, n_);
  (void) _dlaqrb (($0_ = TRUE, &$0_), n_, &_k1, n_, workl_, n_, ritzr_, ritzi_, bounds_, ierr_);
  if ((*ierr_) != 0) {
    goto _l9000;
  }
  if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, n_, bounds_, &debug_.ndigit_, _dc_111);
  }
  (void) _dtrevc (_dc_175, _dc_44, select_, n_, workl_, n_, vl_, n_, q_, ldq_, n_, n_, &workl_[(*n_) * (*n_) + 1 - 1], 
  ierr_);
  if ((*ierr_) != 0) {
    goto _l9000;
  }
  iconj_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_abs (ritzi_[i_ - 1]) <= 0.0) {
      temp_ = _dnrm2 (n_, &q_[0 + ((*ldq_)) * ((i_ - 1))], &_k1);
      (void) _dscal (n_, ($1_ = 1.0 / temp_, &$1_), &q_[0 + ((*ldq_)) * ((i_ - 1))], &_k1);
    }
    else {
      if (iconj_ == 0) {
        temp_ = _dlapy2 (($2_ = _dnrm2 (n_, &q_[0 + ((*ldq_)) * ((i_ - 1))], &_k1), &$2_), ($3_ = _dnrm2 (n_, &q_[0 + ((*ldq_)) 
        * ((i_ + 1 - 1))], &_k1), &$3_));
        (void) _dscal (n_, ($4_ = 1.0 / temp_, &$4_), &q_[0 + ((*ldq_)) * ((i_ - 1))], &_k1);
        (void) _dscal (n_, ($5_ = 1.0 / temp_, &$5_), &q_[0 + ((*ldq_)) * ((i_ + 1 - 1))], &_k1);
        iconj_ = 1;
      }
      else {
        iconj_ = 0;
      }
    }
  }
  (void) _dgemv (_dc_150, n_, n_, ($6_ = 1.0, &$6_), q_, ldq_, bounds_, &_k1, ($7_ = 0.0, &$7_), workl_, &_k1);
  if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, n_, workl_, &debug_.ndigit_, _dc_114);
  }
  iconj_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_abs (ritzi_[i_ - 1]) <= 0.0) {
      bounds_[i_ - 1] = (*rnorm_) * _abs (workl_[i_ - 1]);
    }
    else {
      if (iconj_ == 0) {
        bounds_[i_ - 1] = (*rnorm_) * _dlapy2 (&workl_[i_ - 1], &workl_[i_ + 1 - 1]);
        bounds_[i_ + 1 - 1] = bounds_[i_ - 1];
        iconj_ = 1;
      }
      else {
        iconj_ = 0;
      }
    }
  }
  if (msglvl_ > 2) {
    (void) _dvout (&debug_.logfil_, n_, ritzr_, &debug_.ndigit_, _dc_176);
    (void) _dvout (&debug_.logfil_, n_, ritzi_, &debug_.ndigit_, _dc_177);
    (void) _dvout (&debug_.logfil_, n_, bounds_, &debug_.ndigit_, _dc_116);
  }
  (void) _second (&t1_);
  timing_.tneigh_ = timing_.tneigh_ + (t1_ - t0_);
  _l9000:;
  __calls[20].calls++;
  return 0;
}

int_4 _dneupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, real_8 _p_ dr_, real_8 _p_ di_, real_8 _p_ 
z_, int_4 _p_ ldz_, real_8 _p_ sigmar_, real_8 _p_ sigmai_, real_8 _p_ workev_, char _p_ bmat_, int_4 _p_ n_, char _p_ 
which_, int_4 _p_ nev_, real_8 _p_ tol_, real_8 _p_ resid_, int_4 _p_ ncv_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ 
iparam_, int_4 _p_ ipntr_, real_8 _p_ workd_, real_8 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, ihbds_, iheigr_, iheigi_, iconj_, nconv_, invsub_, iuptri_, iwev_, iwork_[1], j_, k_, 
  ldh_, ldq_, mode_, msglvl_, outncv_, ritzr_, ritzi_, wri_, wrr_, irr_, iri_, ibd_, ishift_, numcnv_, np_, jj_;
  static logical_4 reord_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 conds_, rnorm_, sep_, temp_, vl_[1], temp1_, eps23_;
  static char_7 type_;
  int_4 $0_;
  logical_4 $3_, $4_;
  real_8 $1_, $2_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_;
  extern int_4 _dcopy ();
  extern int_4 _dger ();
  extern int_4 _dgeqr2 ();
  extern int_4 _dlacpy ();
  extern int_4 _dlahqr ();
  extern int_4 _dlaset ();
  extern int_4 _dorm2r ();
  extern int_4 _dtrevc ();
  extern int_4 _dtrmm ();
  extern int_4 _dtrsen ();
  extern int_4 _dscal ();
  extern real_8 _dlapy2 ();
  extern real_8 _dnrm2 ();
  extern real_8 _dlamch ();
  msglvl_ = debug_.mneupd_;
  mode_ = iparam_[6];
  nconv_ = iparam_[4];
  (*info_) = 0;
  eps23_ = _dlamch (_dc_49);
  eps23_ = pow (eps23_, 6.6666666666666667e-1);
  ierr_ = 0;
  if (nconv_ <= 0) {
    ierr_ = -14;
  }
  else if ((*n_) <= 0) {
    ierr_ = -1;
  }
  else if ((*nev_) <= 0) {
    ierr_ = -2;
  }
  else if ((*ncv_) <= (*nev_) + 1 || (*ncv_) > (*n_)) {
    ierr_ = -3;
  }
  else if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_61) != 0) 
    && (strcasecmp (which_, _dc_62) != 0) && (strcasecmp (which_, _dc_63) != 0) && (strcasecmp (which_, _dc_64) != 0)) {
    ierr_ = -5;
  }
  else if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
    ierr_ = -6;
  }
  else if ((*lworkl_) < 3 * ((*ncv_) * (*ncv_)) + 6 * (*ncv_)) {
    ierr_ = -7;
  }
  else if (((strcasecmp (howmny_, _dc_44) != 0) && (strcasecmp (howmny_, _dc_117) != 0) && (strcasecmp (howmny_, _dc_118) 
    != 0)) && (*rvec_)) {
    ierr_ = -13;
  }
  else if ((strcasecmp (howmny_, _dc_118) == 0)) {
    ierr_ = -12;
  }
  if (mode_ == 1 || mode_ == 2) {
    bufcpy (type_, _dc_119, 7);
  }
  else if (mode_ == 3 && (*sigmai_) == 0.0) {
    bufcpy (type_, _dc_120, 7);
  }
  else if (mode_ == 3) {
    bufcpy (type_, _dc_178, 7);
  }
  else if (mode_ == 4) {
    bufcpy (type_, _dc_179, 7);
  }
  else {
    ierr_ = -10;
  }
  if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
    ierr_ = -11;
  }
  if (ierr_ != 0) {
    (*info_) = ierr_;
    goto _l9000;
  }
  ih_ = ipntr_[4];
  ritzr_ = ipntr_[5];
  ritzi_ = ipntr_[6];
  bounds_ = ipntr_[7];
  ldh_ = (*ncv_);
  ldq_ = (*ncv_);
  iheigr_ = bounds_ + ldh_;
  iheigi_ = iheigr_ + ldh_;
  ihbds_ = iheigi_ + ldh_;
  iuptri_ = ihbds_ + ldh_;
  invsub_ = iuptri_ + ldh_ * (*ncv_);
  ipntr_[8] = iheigr_;
  ipntr_[9] = iheigi_;
  ipntr_[10] = ihbds_;
  ipntr_[11] = iuptri_;
  ipntr_[12] = invsub_;
  wrr_ = 1;
  wri_ = (*ncv_) + 1;
  iwev_ = wri_ + (*ncv_);
  irr_ = ipntr_[13] + (*ncv_) * (*ncv_);
  iri_ = irr_ + (*ncv_);
  ibd_ = iri_ + (*ncv_);
  rnorm_ = workl_[ih_ + 2 - 1];
  workl_[ih_ + 2 - 1] = 0.0;
  if (msglvl_ > 2) {
    (void) _dvout (&debug_.logfil_, ncv_, &workl_[irr_ - 1], &debug_.ndigit_, _dc_180);
    (void) _dvout (&debug_.logfil_, ncv_, &workl_[iri_ - 1], &debug_.ndigit_, _dc_181);
    (void) _dvout (&debug_.logfil_, ncv_, &workl_[ibd_ - 1], &debug_.ndigit_, _dc_122);
  }
  if ((*rvec_)) {
    reord_ = FALSE;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      workl_[bounds_ + j_ - 1 - 1] = j_;
      select_[j_ - 1] = FALSE;
    }
    np_ = (*ncv_) - (*nev_);
    ishift_ = 0;
    (void) _dngets (&ishift_, which_, nev_, &np_, &workl_[irr_ - 1], &workl_[iri_ - 1], &workl_[bounds_ - 1], workl_, 
    &workl_[np_ + 1 - 1]);
    if (msglvl_ > 2) {
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[irr_ - 1], &debug_.ndigit_, _dc_182);
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[iri_ - 1], &debug_.ndigit_, _dc_183);
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_124);
    }
    numcnv_ = 0;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      temp1_ = _max (eps23_, _dlapy2 (&workl_[irr_ + (*ncv_) - j_ - 1], &workl_[iri_ + (*ncv_) - j_ - 1]));
      jj_ = workl_[bounds_ + (*ncv_) - j_ - 1];
      if (numcnv_ < nconv_ && workl_[ibd_ + jj_ - 1 - 1] <= (*tol_) * temp1_) {
        select_[jj_ - 1] = TRUE;
        numcnv_ = numcnv_ + 1;
        if (jj_ > (*nev_)) {
          reord_ = TRUE;
        }
      }
    }
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &numcnv_, &debug_.ndigit_, _dc_125);
      (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_126);
    }
    if (numcnv_ != nconv_) {
      (*info_) = -15;
      goto _l9000;
    }
    (void) _dcopy (($0_ = ldh_ * (*ncv_), &$0_), &workl_[ih_ - 1], &_k1, &workl_[iuptri_ - 1], &_k1);
    (void) _dlaset (_dc_36, ncv_, ncv_, ($1_ = 0.0, &$1_), ($2_ = 1.0, &$2_), &workl_[invsub_ - 1], &ldq_);
    (void) _dlahqr (($3_ = TRUE, &$3_), ($4_ = TRUE, &$4_), ncv_, &_k1, ncv_, &workl_[iuptri_ - 1], &ldh_, &workl_[iheigr_ 
    - 1], &workl_[iheigi_ - 1], &_k1, ncv_, &workl_[invsub_ - 1], &ldq_, &ierr_);
    (void) _dcopy (ncv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
    if (ierr_ != 0) {
      (*info_) = -8;
      goto _l9000;
    }
    if (msglvl_ > 1) {
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[iheigr_ - 1], &debug_.ndigit_, _dc_184);
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[iheigi_ - 1], &debug_.ndigit_, _dc_185);
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_128);
      if (msglvl_ > 3) {
        (void) _dmout (&debug_.logfil_, ncv_, ncv_, &workl_[iuptri_ - 1], &ldh_, &debug_.ndigit_, _dc_186);
      }
    }
    if (reord_) {
      (void) _dtrsen (_dc_130, _dc_131, select_, ncv_, &workl_[iuptri_ - 1], &ldh_, &workl_[invsub_ - 1], &ldq_, 
      &workl_[iheigr_ - 1], &workl_[iheigi_ - 1], &nconv_, &conds_, &sep_, &workl_[ihbds_ - 1], ncv_, iwork_, &_k1, &ierr_);
      if (ierr_ == 1) {
        (*info_) = 1;
        goto _l9000;
      }
      if (msglvl_ > 2) {
        (void) _dvout (&debug_.logfil_, ncv_, &workl_[iheigr_ - 1], &debug_.ndigit_, _dc_187);
        (void) _dvout (&debug_.logfil_, ncv_, &workl_[iheigi_ - 1], &debug_.ndigit_, _dc_188);
        if (msglvl_ > 3) {
          (void) _dmout (&debug_.logfil_, ncv_, ncv_, &workl_[iuptri_ - 1], &ldq_, &debug_.ndigit_, _dc_189);
        }
      }
    }
    (void) _dcopy (ncv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
    if ((strcasecmp (type_, _dc_119) == 0)) {
      (void) _dcopy (&nconv_, &workl_[iheigr_ - 1], &_k1, dr_, &_k1);
      (void) _dcopy (&nconv_, &workl_[iheigi_ - 1], &_k1, di_, &_k1);
    }
    (void) _dgeqr2 (ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, &workev_[(*ncv_) + 1 - 1], &ierr_);
    (void) _dorm2r (_dc_112, _dc_134, n_, ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, v_, ldv_, &workd_[(*n_) + 1 
    - 1], &ierr_);
    (void) _dlacpy (_dc_36, n_, &nconv_, v_, ldv_, z_, ldz_);
    for (j_ = 1; j_ <= nconv_; (j_)++) {
      if (workl_[invsub_ + (j_ - 1) * ldq_ + j_ - 1 - 1] < 0.0) {
        (void) _dscal (&nconv_, ($5_ = -1.0, &$5_), &workl_[iuptri_ + j_ - 1 - 1], &ldq_);
        (void) _dscal (&nconv_, ($6_ = -1.0, &$6_), &workl_[iuptri_ + (j_ - 1) * ldq_ - 1], &_k1);
      }
    }
    if ((strcasecmp (howmny_, _dc_44) == 0)) {
      for (j_ = 1; j_ <= (*ncv_); (j_)++) {
        if (j_ <= nconv_) {
          select_[j_ - 1] = TRUE;
        }
        else {
          select_[j_ - 1] = FALSE;
        }
      }
      (void) _dtrevc (_dc_112, _dc_135, select_, ncv_, &workl_[iuptri_ - 1], &ldq_, vl_, &_k1, &workl_[invsub_ - 1], &ldq_, 
      ncv_, &outncv_, workev_, &ierr_);
      if (ierr_ != 0) {
        (*info_) = -9;
        goto _l9000;
      }
      iconj_ = 0;
      for (j_ = 1; j_ <= nconv_; (j_)++) {
        if (workl_[iheigi_ + j_ - 1 - 1] == 0.0) {
          temp_ = _dnrm2 (ncv_, &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
          (void) _dscal (ncv_, ($7_ = 1.0 / temp_, &$7_), &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
        }
        else {
          if (iconj_ == 0) {
            temp_ = _dlapy2 (($8_ = _dnrm2 (ncv_, &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1), &$8_), ($9_ = _dnrm2 (ncv_, 
            &workl_[invsub_ + j_ * ldq_ - 1], &_k1), &$9_));
            (void) _dscal (ncv_, ($10_ = 1.0 / temp_, &$10_), &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
            (void) _dscal (ncv_, ($11_ = 1.0 / temp_, &$11_), &workl_[invsub_ + j_ * ldq_ - 1], &_k1);
            iconj_ = 1;
          }
          else {
            iconj_ = 0;
          }
        }
      }
      (void) _dgemv (_dc_150, ncv_, &nconv_, ($12_ = 1.0, &$12_), &workl_[invsub_ - 1], &ldq_, &workl_[ihbds_ - 1], &_k1, 
      ($13_ = 0.0, &$13_), workev_, &_k1);
      iconj_ = 0;
      for (j_ = 1; j_ <= nconv_; (j_)++) {
        if (workl_[iheigi_ + j_ - 1 - 1] != 0.0) {
          if (iconj_ == 0) {
            workev_[j_ - 1] = _dlapy2 (&workev_[j_ - 1], &workev_[j_ + 1 - 1]);
            workev_[j_ + 1 - 1] = workev_[j_ - 1];
            iconj_ = 1;
          }
          else {
            iconj_ = 0;
          }
        }
      }
      if (msglvl_ > 2) {
        (void) _dcopy (ncv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
        (void) _dvout (&debug_.logfil_, ncv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_136);
        if (msglvl_ > 3) {
          (void) _dmout (&debug_.logfil_, ncv_, ncv_, &workl_[invsub_ - 1], &ldq_, &debug_.ndigit_, _dc_137);
        }
      }
      (void) _dcopy (&nconv_, workev_, &_k1, &workl_[ihbds_ - 1], &_k1);
      (void) _dgeqr2 (ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, &workev_[(*ncv_) + 1 - 1], &ierr_);
      (void) _dorm2r (_dc_112, _dc_134, n_, ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, z_, ldz_, &workd_[(*n_) + 1 
      - 1], &ierr_);
      (void) _dtrmm (_dc_112, _dc_138, _dc_139, _dc_140, n_, &nconv_, ($14_ = 1.0, &$14_), &workl_[invsub_ - 1], &ldq_, z_, 
      ldz_);
    }
  }
  else {
    (void) _dcopy (&nconv_, &workl_[ritzr_ - 1], &_k1, dr_, &_k1);
    (void) _dcopy (&nconv_, &workl_[ritzi_ - 1], &_k1, di_, &_k1);
    (void) _dcopy (&nconv_, &workl_[ritzr_ - 1], &_k1, &workl_[iheigr_ - 1], &_k1);
    (void) _dcopy (&nconv_, &workl_[ritzi_ - 1], &_k1, &workl_[iheigi_ - 1], &_k1);
    (void) _dcopy (&nconv_, &workl_[bounds_ - 1], &_k1, &workl_[ihbds_ - 1], &_k1);
  }
  if ((strcasecmp (type_, _dc_119) == 0)) {
    if ((*rvec_)) {
      (void) _dscal (ncv_, &rnorm_, &workl_[ihbds_ - 1], &_k1);
    }
  }
  else {
    if ((strcasecmp (type_, _dc_120) == 0)) {
      if ((*rvec_)) {
        (void) _dscal (ncv_, &rnorm_, &workl_[ihbds_ - 1], &_k1);
      }
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        temp_ = _dlapy2 (&workl_[iheigr_ + k_ - 1 - 1], &workl_[iheigi_ + k_ - 1 - 1]);
        workl_[ihbds_ + k_ - 1 - 1] = _abs (workl_[ihbds_ + k_ - 1 - 1]) / temp_ / temp_;
      }
    }
    else if ((strcasecmp (type_, _dc_178) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
      }
    }
    else if ((strcasecmp (type_, _dc_179) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
      }
    }
    if ((strcasecmp (type_, _dc_120) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        temp_ = _dlapy2 (&workl_[iheigr_ + k_ - 1 - 1], &workl_[iheigi_ + k_ - 1 - 1]);
        workl_[iheigr_ + k_ - 1 - 1] = workl_[iheigr_ + k_ - 1 - 1] / temp_ / temp_ + (*sigmar_);
        workl_[iheigi_ + k_ - 1 - 1] = -workl_[iheigi_ + k_ - 1 - 1] / temp_ / temp_ + (*sigmai_);
      }
      (void) _dcopy (&nconv_, &workl_[iheigr_ - 1], &_k1, dr_, &_k1);
      (void) _dcopy (&nconv_, &workl_[iheigi_ - 1], &_k1, di_, &_k1);
    }
    else if ((strcasecmp (type_, _dc_178) == 0) || (strcasecmp (type_, _dc_179) == 0)) {
      (void) _dcopy (&nconv_, &workl_[iheigr_ - 1], &_k1, dr_, &_k1);
      (void) _dcopy (&nconv_, &workl_[iheigi_ - 1], &_k1, di_, &_k1);
    }
  }
  if ((strcasecmp (type_, _dc_120) == 0) && msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &nconv_, dr_, &debug_.ndigit_, _dc_190);
    (void) _dvout (&debug_.logfil_, &nconv_, di_, &debug_.ndigit_, _dc_191);
    (void) _dvout (&debug_.logfil_, &nconv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_192);
  }
  else if ((strcasecmp (type_, _dc_119) == 0) && msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &nconv_, dr_, &debug_.ndigit_, _dc_193);
    (void) _dvout (&debug_.logfil_, &nconv_, di_, &debug_.ndigit_, _dc_194);
    (void) _dvout (&debug_.logfil_, &nconv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_144);
  }
  if ((*rvec_) && (strcasecmp (howmny_, _dc_44) == 0) && (strcasecmp (type_, _dc_120) == 0)) {
    iconj_ = 0;
    for (j_ = 1; j_ <= nconv_; (j_)++) {
      if (workl_[iheigi_ + j_ - 1 - 1] == 0.0) {
        workev_[j_ - 1] = workl_[invsub_ + (j_ - 1) * ldq_ + (*ncv_) - 1 - 1] / workl_[iheigr_ + j_ - 1 - 1];
      }
      else if (iconj_ == 0) {
        temp_ = _dlapy2 (&workl_[iheigr_ + j_ - 1 - 1], &workl_[iheigi_ + j_ - 1 - 1]);
        workev_[j_ - 1] = (workl_[invsub_ + (j_ - 1) * ldq_ + (*ncv_) - 1 - 1] * workl_[iheigr_ + j_ - 1 - 1] + workl_[invsub_ 
        + j_ * ldq_ + (*ncv_) - 1 - 1] * workl_[iheigi_ + j_ - 1 - 1]) / temp_ / temp_;
        workev_[j_ + 1 - 1] = (workl_[invsub_ + j_ * ldq_ + (*ncv_) - 1 - 1] * workl_[iheigr_ + j_ - 1 - 1] - workl_[invsub_ + 
        (j_ - 1) * ldq_ + (*ncv_) - 1 - 1] * workl_[iheigi_ + j_ - 1 - 1]) / temp_ / temp_;
        iconj_ = 1;
      }
      else {
        iconj_ = 0;
      }
    }
    (void) _dger (n_, &nconv_, ($15_ = 1.0, &$15_), resid_, &_k1, workev_, &_k1, z_, ldz_);
  }
  _l9000:;
  __calls[21].calls++;
  return 0;
}

int_4 _dngets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, real_8 _p_ ritzr_, real_8 _p_ ritzi_, 
real_8 _p_ bounds_, real_8 _p_ shiftr_, real_8 _p_ shifti_)
{
  static int_4 msglvl_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 $1_, $3_, $5_, $7_, $9_, $11_, $13_, $15_, $16_, $17_;
  logical_4 $0_, $2_, $4_, $6_, $8_, $10_, $12_, $14_;
  (void) _second (&t0_);
  msglvl_ = debug_.mngets_;
  if ((strcasecmp (which_, _dc_59) == 0)) {
    (void) _dsortc (_dc_61, ($0_ = TRUE, &$0_), ($1_ = (*kev_) + (*np_), &$1_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    (void) _dsortc (_dc_62, ($2_ = TRUE, &$2_), ($3_ = (*kev_) + (*np_), &$3_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_61) == 0)) {
    (void) _dsortc (_dc_59, ($4_ = TRUE, &$4_), ($5_ = (*kev_) + (*np_), &$5_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_62) == 0)) {
    (void) _dsortc (_dc_60, ($6_ = TRUE, &$6_), ($7_ = (*kev_) + (*np_), &$7_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_63) == 0)) {
    (void) _dsortc (_dc_59, ($8_ = TRUE, &$8_), ($9_ = (*kev_) + (*np_), &$9_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_64) == 0)) {
    (void) _dsortc (_dc_60, ($10_ = TRUE, &$10_), ($11_ = (*kev_) + (*np_), &$11_), ritzr_, ritzi_, bounds_);
  }
  (void) _dsortc (which_, ($12_ = TRUE, &$12_), ($13_ = (*kev_) + (*np_), &$13_), ritzr_, ritzi_, bounds_);
  if ((ritzr_[(*np_) + 1 - 1] - ritzr_[(*np_) - 1]) == 0.0 && (ritzi_[(*np_) + 1 - 1] + ritzi_[(*np_) - 1]) == 0.0) {
    (*np_) = (*np_) - 1;
    (*kev_) = (*kev_) + 1;
  }
  if ((*ishift_) == 1) {
    (void) _dsortc (_dc_62, ($14_ = TRUE, &$14_), np_, bounds_, ritzr_, ritzi_);
  }
  (void) _second (&t1_);
  timing_.tngets_ = timing_.tngets_ + (t1_ - t0_);
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_145);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_146);
    (void) _dvout (&debug_.logfil_, ($15_ = (*kev_) + (*np_), &$15_), ritzr_, &debug_.ndigit_, _dc_195);
    (void) _dvout (&debug_.logfil_, ($16_ = (*kev_) + (*np_), &$16_), ritzi_, &debug_.ndigit_, _dc_196);
    (void) _dvout (&debug_.logfil_, ($17_ = (*kev_) + (*np_), &$17_), bounds_, &debug_.ndigit_, _dc_148);
  }
  __calls[22].calls++;
  return 0;
}

int_4 _dsaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ mode_, real_8 _p_ 
resid_, real_8 _p_ rnorm_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, real_8 _p_ 
workd_, int_4 _p_ info_)
{
  static int_4 i_, ierr_, ipj_, irj_, ivj_, iter_, itry_, j_, msglvl_, infol_, jj_;
  static logical_4 first_, orth1_, orth2_, rstart_, step3_, step4_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 rnorm1_, wnorm_, safmin_, temp1_, xtemp_[2];
  int_4 _data_k_8, $9_, $14_, $17_, $18_;
  logical_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $10_, $11_, $12_, $13_, $15_, $16_;
  extern int_4 _dcopy ();
  extern int_4 _dscal ();
  extern int_4 _dgemv ();
  extern int_4 _dlascl ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern real_8 _dlamch ();
#define _data_n_8 1
  static logical_4 _data_l_8[_data_n_8] = {
    TRUE
  };
  if (__calls[23].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    first_ = _data_l_8[_data_k_8++];
  }
  if (first_) {
    first_ = FALSE;
    safmin_ = _dlamch (_dc_197);
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.msaitr_;
    (*info_) = 0;
    step3_ = FALSE;
    step4_ = FALSE;
    rstart_ = FALSE;
    orth1_ = FALSE;
    orth2_ = FALSE;
    j_ = (*k_) + 1;
    ipj_ = 1;
    irj_ = ipj_ + (*n_);
    ivj_ = irj_ + (*n_);
  }
  if (step3_) {
    goto _l50;
  }
  if (step4_) {
    goto _l60;
  }
  if (orth1_) {
    goto _l70;
  }
  if (orth2_) {
    goto _l90;
  }
  if (rstart_) {
    goto _l30;
  }
  _l1000:;
  if (msglvl_ > 2) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_198);
    (void) _dvout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_199);
  }
  if ((*rnorm_) > 0.0) {
    goto _l40;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_200);
  }
  timing_.nrstrt_ = timing_.nrstrt_ + 1;
  itry_ = 1;
  _l20:;
  rstart_ = TRUE;
  (*ido_) = 0;
  _l30:;
  (void) _dgetv0 (ido_, bmat_, &itry_, ($0_ = FALSE, &$0_), n_, &j_, v_, ldv_, resid_, rnorm_, ipntr_, workd_, &ierr_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if (ierr_ < 0) {
    itry_ = itry_ + 1;
    if (itry_ <= 3) {
      goto _l20;
    }
    (*info_) = j_ - 1;
    (void) _second (&t1_);
    timing_.tsaitr_ = timing_.tsaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    goto _l9000;
  }
  _l40:;
  (void) _dcopy (n_, resid_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
  if ((*rnorm_) >= safmin_) {
    temp1_ = 1.0 / (*rnorm_);
    (void) _dscal (n_, &temp1_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
    (void) _dscal (n_, &temp1_, &workd_[ipj_ - 1], &_k1);
  }
  else {
    (void) _dlascl (_dc_29, &i_, &i_, rnorm_, ($1_ = 1.0, &$1_), n_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], n_, &infol_);
    (void) _dlascl (_dc_29, &i_, &i_, rnorm_, ($2_ = 1.0, &$2_), n_, &_k1, &workd_[ipj_ - 1], n_, &infol_);
  }
  step3_ = TRUE;
  timing_.nopx_ = timing_.nopx_ + 1;
  (void) _second (&t2_);
  (void) _dcopy (n_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1, &workd_[ivj_ - 1], &_k1);
  ipntr_[0] = ivj_;
  ipntr_[1] = irj_;
  ipntr_[2] = ipj_;
  (*ido_) = 1;
  goto _l9000;
  _l50:;
  (void) _second (&t3_);
  timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  step3_ = FALSE;
  (void) _dcopy (n_, &workd_[irj_ - 1], &_k1, resid_, &_k1);
  if ((*mode_) == 2) {
    goto _l65;
  }
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    step4_ = TRUE;
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l60:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  step4_ = FALSE;
  _l65:;
  if ((*mode_) == 2) {
    wnorm_ = _ddot (n_, resid_, &_k1, &workd_[ivj_ - 1], &_k1);
    wnorm_ = sqrt (_abs (wnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_0) == 0)) {
    wnorm_ = _ddot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    wnorm_ = sqrt (_abs (wnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    wnorm_ = _dnrm2 (n_, resid_, &_k1);
  }
  if ((*mode_) != 2) {
    (void) _dgemv (_dc_150, n_, &j_, ($3_ = 1.0, &$3_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($4_ = 0.0, &$4_), &workd_[irj_ 
    - 1], &_k1);
  }
  else if ((*mode_) == 2) {
    (void) _dgemv (_dc_150, n_, &j_, ($5_ = 1.0, &$5_), v_, ldv_, &workd_[ivj_ - 1], &_k1, ($6_ = 0.0, &$6_), &workd_[irj_ 
    - 1], &_k1);
  }
  (void) _dgemv (_dc_3, n_, &j_, ($7_ = -1.0, &$7_), v_, ldv_, &workd_[irj_ - 1], &_k1, ($8_ = 1.0, &$8_), resid_, &_k1)
  ;
  h_[j_ - 1 + ((*ldh_)) * ((1))] = workd_[irj_ + j_ - 1 - 1];
  if (j_ == 1 || rstart_) {
    h_[j_ - 1 + ((*ldh_)) * ((0))] = 0.0;
  }
  else {
    h_[j_ - 1 + ((*ldh_)) * ((0))] = (*rnorm_);
  }
  (void) _second (&t4_);
  orth1_ = TRUE;
  iter_ = 0;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _dcopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l70:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  orth1_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (*rnorm_) = _ddot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    (*rnorm_) = sqrt (_abs ((*rnorm_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _dnrm2 (n_, resid_, &_k1);
  }
  if ((*rnorm_) > 0.717 * wnorm_) {
    goto _l100;
  }
  timing_.nrorth_ = timing_.nrorth_ + 1;
  _l80:;
  if (msglvl_ > 2) {
    xtemp_[0] = wnorm_;
    xtemp_[1] = (*rnorm_);
    (void) _dvout (&debug_.logfil_, ($9_ = 2, &$9_), xtemp_, &debug_.ndigit_, _dc_201);
  }
  (void) _dgemv (_dc_150, n_, &j_, ($10_ = 1.0, &$10_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($11_ = 0.0, &$11_), 
  &workd_[irj_ - 1], &_k1);
  (void) _dgemv (_dc_3, n_, &j_, ($12_ = -1.0, &$12_), v_, ldv_, &workd_[irj_ - 1], &_k1, ($13_ = 1.0, &$13_), resid_, 
  &_k1);
  if (j_ == 1 || rstart_) {
    h_[j_ - 1 + ((*ldh_)) * ((0))] = 0.0;
  }
  h_[j_ - 1 + ((*ldh_)) * ((1))] = h_[j_ - 1 + ((*ldh_)) * ((1))] + workd_[irj_ + j_ - 1 - 1];
  orth2_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _dcopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l90:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm1_ = _ddot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    rnorm1_ = sqrt (_abs (rnorm1_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm1_ = _dnrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 0 && iter_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_202);
    if (msglvl_ > 2) {
      xtemp_[0] = (*rnorm_);
      xtemp_[1] = rnorm1_;
      (void) _dvout (&debug_.logfil_, ($14_ = 2, &$14_), xtemp_, &debug_.ndigit_, _dc_203);
    }
  }
  if (rnorm1_ > 0.717 * (*rnorm_)) {
    (*rnorm_) = rnorm1_;
  }
  else {
    timing_.nitref_ = timing_.nitref_ + 1;
    (*rnorm_) = rnorm1_;
    iter_ = iter_ + 1;
    if (iter_ <= 1) {
      goto _l80;
    }
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = 0.0;
    }
    (*rnorm_) = 0.0;
  }
  _l100:;
  rstart_ = FALSE;
  orth2_ = FALSE;
  (void) _second (&t5_);
  timing_.titref_ = timing_.titref_ + (t5_ - t4_);
  if (h_[j_ - 1 + ((*ldh_)) * ((0))] < 0.0) {
    h_[j_ - 1 + ((*ldh_)) * ((0))] = -h_[j_ - 1 + ((*ldh_)) * ((0))];
    if (j_ < (*k_) + (*np_)) {
      (void) _dscal (n_, ($15_ = -1.0, &$15_), &v_[0 + ((*ldv_)) * ((j_ + 1 - 1))], &_k1);
    }
    else {
      (void) _dscal (n_, ($16_ = -1.0, &$16_), resid_, &_k1);
    }
  }
  j_ = j_ + 1;
  if (j_ > (*k_) + (*np_)) {
    (void) _second (&t1_);
    timing_.tsaitr_ = timing_.tsaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    if (msglvl_ > 1) {
      (void) _dvout (&debug_.logfil_, ($17_ = (*k_) + (*np_), &$17_), &h_[0 + ((*ldh_)) * ((1))], &debug_.ndigit_, _dc_204);
      if ((*k_) + (*np_) > 1) {
        (void) _dvout (&debug_.logfil_, ($18_ = (*k_) + (*np_) - 1, &$18_), &h_[1 + ((*ldh_)) * ((0))], &debug_.ndigit_, 
        _dc_205);
      }
    }
    goto _l9000;
  }
  goto _l1000;
  _l9000:;
  __calls[23].calls++;
  return 0;
}

int_4 _dsapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, real_8 _p_ shift_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 
_p_ h_, int_4 _p_ ldh_, real_8 _p_ resid_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ workd_)
{
  static int_4 i_, iend_, istart_, itop_, j_, jj_, kplusp_, msglvl_;
  static logical_4 first_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 a1_, a2_, a3_, a4_, big_, c_, epsmch_, f_, g_, r_, s_;
  int_4 _data_k_9, $5_, $8_;
  real_8 $0_, $1_, $2_, $3_, $4_, $6_, $7_;
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern int_4 _dscal ();
  extern int_4 _dlacpy ();
  extern int_4 _dlartg ();
  extern int_4 _dlaset ();
  extern int_4 _dgemv ();
  extern real_8 _dlamch ();
#define _data_n_9 1
  static logical_4 _data_l_9[_data_n_9] = {
    TRUE
  };
  if (__calls[24].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    first_ = _data_l_9[_data_k_9++];
  }
  if (first_) {
    epsmch_ = _dlamch (_dc_49);
    first_ = FALSE;
  }
  itop_ = 1;
  (void) _second (&t0_);
  msglvl_ = debug_.msapps_;
  kplusp_ = (*kev_) + (*np_);
  (void) _dlaset (_dc_36, &kplusp_, &kplusp_, ($0_ = 0.0, &$0_), ($1_ = 1.0, &$1_), q_, ldq_);
  if ((*np_) == 0) {
    goto _l9000;
  }
  for (jj_ = 1; jj_ <= (*np_); (jj_)++) {
    istart_ = itop_;
    _l20:;
    for (i_ = istart_; i_ <= kplusp_ - 1; (i_)++) {
      big_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((1))]);
      if (h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] <= epsmch_ * big_) {
        if (msglvl_ > 0) {
          (void) _ivout (&debug_.logfil_, &_k1, &i_, &debug_.ndigit_, _dc_206);
          (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_207);
          (void) _dvout (&debug_.logfil_, &_k1, &h_[i_ + 1 - 1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_208);
        }
        h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] = 0.0;
        iend_ = i_;
        goto _l40;
      }
    }
    iend_ = kplusp_;
    _l40:;
    if (istart_ < iend_) {
      f_ = h_[istart_ - 1 + ((*ldh_)) * ((1))] - shift_[jj_ - 1];
      g_ = h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))];
      (void) _dlartg (&f_, &g_, &c_, &s_, &r_);
      a1_ = c_ * h_[istart_ - 1 + ((*ldh_)) * ((1))] + s_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))];
      a2_ = c_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))] + s_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((1))];
      a4_ = c_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((1))] - s_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))];
      a3_ = c_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))] - s_ * h_[istart_ - 1 + ((*ldh_)) * ((1))];
      h_[istart_ - 1 + ((*ldh_)) * ((1))] = c_ * a1_ + s_ * a2_;
      h_[istart_ + 1 - 1 + ((*ldh_)) * ((1))] = c_ * a4_ - s_ * a3_;
      h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))] = c_ * a3_ + s_ * a4_;
      for (j_ = 1; j_ <= _min (istart_ + jj_, kplusp_); (j_)++) {
        a1_ = c_ * q_[j_ - 1 + ((*ldq_)) * ((istart_ - 1))] + s_ * q_[j_ - 1 + ((*ldq_)) * ((istart_ + 1 - 1))];
        q_[j_ - 1 + ((*ldq_)) * ((istart_ + 1 - 1))] = -s_ * q_[j_ - 1 + ((*ldq_)) * ((istart_ - 1))] + c_ * q_[j_ - 1 + 
        ((*ldq_)) * ((istart_ + 1 - 1))];
        q_[j_ - 1 + ((*ldq_)) * ((istart_ - 1))] = a1_;
      }
      for (i_ = istart_ + 1; i_ <= iend_ - 1; (i_)++) {
        f_ = h_[i_ - 1 + ((*ldh_)) * ((0))];
        g_ = s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))];
        h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] = c_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))];
        (void) _dlartg (&f_, &g_, &c_, &s_, &r_);
        if (r_ < 0.0) {
          r_ = -r_;
          c_ = -c_;
          s_ = -s_;
        }
        h_[i_ - 1 + ((*ldh_)) * ((0))] = r_;
        a1_ = c_ * h_[i_ - 1 + ((*ldh_)) * ((1))] + s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))];
        a2_ = c_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] + s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((1))];
        a3_ = c_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] - s_ * h_[i_ - 1 + ((*ldh_)) * ((1))];
        a4_ = c_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((1))] - s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))];
        h_[i_ - 1 + ((*ldh_)) * ((1))] = c_ * a1_ + s_ * a2_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((1))] = c_ * a4_ - s_ * a3_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] = c_ * a3_ + s_ * a4_;
        for (j_ = 1; j_ <= _min (i_ + jj_, kplusp_); (j_)++) {
          a1_ = c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))];
          q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))] = -s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ 
          + 1 - 1))];
          q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] = a1_;
        }
      }
    }
    istart_ = iend_ + 1;
    if (h_[iend_ - 1 + ((*ldh_)) * ((0))] < 0.0) {
      h_[iend_ - 1 + ((*ldh_)) * ((0))] = -h_[iend_ - 1 + ((*ldh_)) * ((0))];
      (void) _dscal (&kplusp_, ($2_ = -1.0, &$2_), &q_[0 + ((*ldq_)) * ((iend_ - 1))], &_k1);
    }
    if (iend_ < kplusp_) {
      goto _l20;
    }
    for (i_ = itop_; i_ <= kplusp_ - 1; (i_)++) {
      if (h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] > 0.0) {
        goto _l90;
      }
      itop_ = itop_ + 1;
    }
    _l90:;
  }
  for (i_ = itop_; i_ <= kplusp_ - 1; (i_)++) {
    big_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((1))]);
    if (h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] <= epsmch_ * big_) {
      if (msglvl_ > 0) {
        (void) _ivout (&debug_.logfil_, &_k1, &i_, &debug_.ndigit_, _dc_206);
        (void) _dvout (&debug_.logfil_, &_k1, &h_[i_ + 1 - 1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_208);
      }
      h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] = 0.0;
    }
  }
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))] > 0.0) {
    (void) _dgemv (_dc_3, n_, &kplusp_, ($3_ = 1.0, &$3_), v_, ldv_, &q_[0 + ((*ldq_)) * (((*kev_) + 1 - 1))], &_k1, ($4_ = 
    0.0, &$4_), &workd_[(*n_) + 1 - 1], &_k1);
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    (void) _dgemv (_dc_3, n_, ($5_ = kplusp_ - i_ + 1, &$5_), ($6_ = 1.0, &$6_), v_, ldv_, &q_[0 + ((*ldq_)) * (((*kev_) - 
    i_ + 1 - 1))], &_k1, ($7_ = 0.0, &$7_), workd_, &_k1);
    (void) _dcopy (n_, workd_, &_k1, &v_[0 + ((*ldv_)) * ((kplusp_ - i_ + 1 - 1))], &_k1);
  }
  (void) _dlacpy (_dc_36, n_, kev_, &v_[0 + ((*ldv_)) * (((*np_) + 1 - 1))], ldv_, v_, ldv_);
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))] > 0.0) {
    (void) _dcopy (n_, &workd_[(*n_) + 1 - 1], &_k1, &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1);
  }
  (void) _dscal (n_, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], resid_, &_k1);
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))] > 0.0) {
    (void) _daxpy (n_, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))], &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1, resid_, 
    &_k1);
  }
  if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &_k1, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_209);
    (void) _dvout (&debug_.logfil_, &_k1, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_210);
    (void) _dvout (&debug_.logfil_, kev_, &h_[0 + ((*ldh_)) * ((1))], &debug_.ndigit_, _dc_211);
    if ((*kev_) > 1) {
      (void) _dvout (&debug_.logfil_, ($8_ = (*kev_) - 1, &$8_), &h_[1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_212);
    }
  }
  (void) _second (&t1_);
  timing_.tsapps_ = timing_.tsapps_ + (t1_ - t0_);
  _l9000:;
  __calls[24].calls++;
  return 0;
}

int_4 _dsaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, real_8 _p_ 
tol_, real_8 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, real_8 _p_ v_, int_4 
_p_ ldv_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ ritz_, real_8 _p_ bounds_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 
_p_ workl_, int_4 _p_ ipntr_, real_8 _p_ workd_, int_4 _p_ info_)
{
  static int_4 ierr_, iter_, j_, kplusp_, msglvl_, nconv_, nevbef_, nev0_, np0_, nptemp_, nevd2_, nevm2_, kp_[3];
  static logical_4 cnorm_, getv0_, initv_, update_, ushift_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 rnorm_, temp_, eps23_;
  static char_3 wprime_;
  int_4 $0_, $2_, $3_, $8_, $9_;
  logical_4 $1_, $4_, $5_, $6_, $7_;
  extern int_4 _dcopy ();
  extern int_4 _dswap ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern real_8 _dlamch ();
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.msaup2_;
    eps23_ = _dlamch (_dc_49);
    eps23_ = pow (eps23_, 6.6666666666666667e-1);
    nev0_ = (*nev_);
    np0_ = (*np_);
    kplusp_ = nev0_ + np0_;
    nconv_ = 0;
    iter_ = 0;
    getv0_ = TRUE;
    update_ = FALSE;
    ushift_ = FALSE;
    cnorm_ = FALSE;
    if ((*info_) != 0) {
      initv_ = TRUE;
      (*info_) = 0;
    }
    else {
      initv_ = FALSE;
    }
  }
  if (getv0_) {
    (void) _dgetv0 (ido_, bmat_, &_k1, &initv_, n_, &_k1, v_, ldv_, resid_, &rnorm_, ipntr_, workd_, info_);
    if ((*ido_) != 99) {
      goto _l9000;
    }
    if (rnorm_ == 0.0) {
      (*info_) = -9;
      goto _l1200;
    }
    getv0_ = FALSE;
    (*ido_) = 0;
  }
  if (update_) {
    goto _l20;
  }
  if (ushift_) {
    goto _l50;
  }
  if (cnorm_) {
    goto _l100;
  }
  (void) _dsaitr (ido_, bmat_, n_, &_k0, &nev0_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  _l1000:;
  iter_ = iter_ + 1;
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &iter_, &debug_.ndigit_, _dc_213);
  }
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, nev_, &debug_.ndigit_, _dc_214);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_215);
  }
  (*ido_) = 0;
  _l20:;
  update_ = TRUE;
  (void) _dsaitr (ido_, bmat_, n_, nev_, np_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  update_ = FALSE;
  if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_216);
  }
  (void) _dseigt (&rnorm_, &kplusp_, h_, ldh_, ritz_, bounds_, workl_, &ierr_);
  if (ierr_ != 0) {
    (*info_) = -8;
    goto _l1200;
  }
  (void) _dcopy (&kplusp_, ritz_, &_k1, &workl_[kplusp_ + 1 - 1], &_k1);
  (void) _dcopy (&kplusp_, bounds_, &_k1, &workl_[2 * kplusp_ + 1 - 1], &_k1);
  (*nev_) = nev0_;
  (*np_) = np0_;
  (void) _dsgets (ishift_, which_, nev_, np_, ritz_, bounds_, workl_);
  (void) _dcopy (nev_, &bounds_[(*np_) + 1 - 1], &_k1, &workl_[(*np_) + 1 - 1], &_k1);
  (void) _dsconv (nev_, &ritz_[(*np_) + 1 - 1], &workl_[(*np_) + 1 - 1], tol_, &nconv_);
  if (msglvl_ > 2) {
    kp_[0] = (*nev_);
    kp_[1] = (*np_);
    kp_[2] = nconv_;
    (void) _ivout (&debug_.logfil_, ($0_ = 3, &$0_), kp_, &debug_.ndigit_, _dc_217);
    (void) _dvout (&debug_.logfil_, &kplusp_, ritz_, &debug_.ndigit_, _dc_218);
    (void) _dvout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_219);
  }
  nptemp_ = (*np_);
  for (j_ = 1; j_ <= nptemp_; (j_)++) {
    if (bounds_[j_ - 1] == 0.0) {
      (*np_) = (*np_) - 1;
      (*nev_) = (*nev_) + 1;
    }
  }
  if ((nconv_ >= nev0_) || (iter_ > (*mxiter_)) || ((*np_) == 0)) {
    if ((strcasecmp (which_, _dc_220) == 0)) {
      bufcpy (wprime_, _dc_221, 3);
      (void) _dsortr (wprime_, ($1_ = TRUE, &$1_), &kplusp_, ritz_, bounds_);
      nevd2_ = nev0_ / 2;
      nevm2_ = nev0_ - nevd2_;
      if ((*nev_) > 1) {
        (void) _dswap (($2_ = _min (nevd2_, (*np_)), &$2_), &ritz_[nevm2_ + 1 - 1], &_k1, &ritz_[_max (kplusp_ - nevd2_ + 1, 
        kplusp_ - (*np_) + 1) - 1], &_k1);
        (void) _dswap (($3_ = _min (nevd2_, (*np_)), &$3_), &bounds_[nevm2_ + 1 - 1], &_k1, &bounds_[_max (kplusp_ - nevd2_ + 
        1, kplusp_ - (*np_) + 1) - 1], &_k1);
      }
    }
    else {
      if ((strcasecmp (which_, _dc_59) == 0)) {
        bufcpy (wprime_, _dc_60, 3);
      }
      if ((strcasecmp (which_, _dc_60) == 0)) {
        bufcpy (wprime_, _dc_59, 3);
      }
      if ((strcasecmp (which_, _dc_222) == 0)) {
        bufcpy (wprime_, _dc_221, 3);
      }
      if ((strcasecmp (which_, _dc_221) == 0)) {
        bufcpy (wprime_, _dc_222, 3);
      }
      (void) _dsortr (wprime_, ($4_ = TRUE, &$4_), &kplusp_, ritz_, bounds_);
    }
    for (j_ = 1; j_ <= nev0_; (j_)++) {
      temp_ = _max (eps23_, _abs (ritz_[j_ - 1]));
      bounds_[j_ - 1] = bounds_[j_ - 1] / temp_;
    }
    bufcpy (wprime_, _dc_222, 3);
    (void) _dsortr (wprime_, ($5_ = TRUE, &$5_), &nev0_, bounds_, ritz_);
    for (j_ = 1; j_ <= nev0_; (j_)++) {
      temp_ = _max (eps23_, _abs (ritz_[j_ - 1]));
      bounds_[j_ - 1] = bounds_[j_ - 1] * temp_;
    }
    if ((strcasecmp (which_, _dc_220) == 0)) {
      bufcpy (wprime_, _dc_222, 3);
      (void) _dsortr (wprime_, ($6_ = TRUE, &$6_), &nconv_, ritz_, bounds_);
    }
    else {
      (void) _dsortr (which_, ($7_ = TRUE, &$7_), &nconv_, ritz_, bounds_);
    }
    h_[0 + ((*ldh_)) * ((0))] = rnorm_;
    if (msglvl_ > 1) {
      (void) _dvout (&debug_.logfil_, &kplusp_, ritz_, &debug_.ndigit_, _dc_223);
      (void) _dvout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_224);
    }
    if (iter_ > (*mxiter_) && nconv_ < (*nev_)) {
      (*info_) = 1;
    }
    if ((*np_) == 0 && nconv_ < nev0_) {
      (*info_) = 2;
    }
    (*np_) = nconv_;
    goto _l1100;
  }
  else if (nconv_ < (*nev_) && (*ishift_) == 1) {
    nevbef_ = (*nev_);
    (*nev_) = (*nev_) + _min (nconv_, (*np_) / 2);
    if ((*nev_) == 1 && kplusp_ >= 6) {
      (*nev_) = kplusp_ / 2;
    }
    else if ((*nev_) == 1 && kplusp_ > 2) {
      (*nev_) = 2;
    }
    (*np_) = kplusp_ - (*nev_);
    if (nevbef_ < (*nev_)) {
      (void) _dsgets (ishift_, which_, nev_, np_, ritz_, bounds_, workl_);
    }
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_225);
    if (msglvl_ > 1) {
      kp_[0] = (*nev_);
      kp_[1] = (*np_);
      (void) _ivout (&debug_.logfil_, ($8_ = 2, &$8_), kp_, &debug_.ndigit_, _dc_226);
      (void) _dvout (&debug_.logfil_, nev_, &ritz_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_227);
      (void) _dvout (&debug_.logfil_, nev_, &bounds_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_228);
    }
  }
  if ((*ishift_) == 0) {
    ushift_ = TRUE;
    (*ido_) = 3;
    goto _l9000;
  }
  _l50:;
  ushift_ = FALSE;
  if ((*ishift_) == 0) {
    (void) _dcopy (np_, workl_, &_k1, ritz_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_229);
    (void) _dvout (&debug_.logfil_, np_, workl_, &debug_.ndigit_, _dc_230);
    if ((*ishift_) == 1) {
      (void) _dvout (&debug_.logfil_, np_, bounds_, &debug_.ndigit_, _dc_231);
    }
  }
  (void) _dsapps (n_, nev_, np_, ritz_, v_, ldv_, h_, ldh_, resid_, q_, ldq_, workd_);
  cnorm_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _dcopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _dcopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l100:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm_ = _ddot (n_, resid_, &_k1, workd_, &_k1);
    rnorm_ = sqrt (_abs (rnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm_ = _dnrm2 (n_, resid_, &_k1);
  }
  cnorm_ = FALSE;
  if (msglvl_ > 2) {
    (void) _dvout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_232);
    (void) _dvout (&debug_.logfil_, nev_, &h_[0 + ((*ldh_)) * ((1))], &debug_.ndigit_, _dc_233);
    (void) _dvout (&debug_.logfil_, ($9_ = (*nev_) - 1, &$9_), &h_[1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_234);
  }
  goto _l1000;
  _l1100:;
  (*mxiter_) = iter_;
  (*nev_) = nconv_;
  _l1200:;
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tsaup2_ = t1_ - t0_;
  _l9000:;
  __calls[25].calls++;
  return 0;
}

int_4 _dsaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_, real_8 
_p_ resid_, int_4 _p_ ncv_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_8 _p_ workd_, 
real_8 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, iq_, ishift_, iupd_, iw_, ldh_, ldq_, msglvl_, mxiter_, mode_, nb_, nev0_, next_, np_
  , ritz_, j_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 __fcnt, __rc;
  extern real_8 _dlamch ();
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_239, _dc_239,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_240, _dc_240,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_241, _dc_241,
    FMT_TEXT, _dc_174, _dc_174,
    FMT_TEXT, _dc_242, _dc_242,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_243, _dc_243,
    FMT_TEXT, _dc_89, _dc_89,
    FMT_TEXT, _dc_244, _dc_244,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_239, _dc_239,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_245, _dc_245,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_239, _dc_239,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_1100_[] = {
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_92, _dc_92,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_93, _dc_93,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_94, _dc_94,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_96, _dc_96,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_97, _dc_97,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_98, _dc_98,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_99, _dc_99,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_246, _dc_246,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_102, _dc_102,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_103, _dc_103,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_104, _dc_104,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_247, _dc_247,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_106, _dc_106,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_107, _dc_107,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_108, _dc_108,
    FMT_REAL,"%12f","%12.6f",
    NULL, NULL, NULL
  };
  if ((*ido_) == 0) {
    (void) _dstats ();
    (void) _second (&t0_);
    msglvl_ = debug_.msaupd_;
    ierr_ = 0;
    ishift_ = iparam_[0];
    mxiter_ = iparam_[2];
    nb_ = 1;
    iupd_ = 1;
    mode_ = iparam_[6];
    if ((*n_) <= 0) {
      ierr_ = -1;
    }
    else if ((*nev_) <= 0) {
      ierr_ = -2;
    }
    else if ((*ncv_) <= (*nev_) || (*ncv_) > (*n_)) {
      ierr_ = -3;
    }
    np_ = (*ncv_) - (*nev_);
    if (mxiter_ <= 0) {
      ierr_ = -4;
    }
    if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_222) != 0) && 
      (strcasecmp (which_, _dc_221) != 0) && (strcasecmp (which_, _dc_220) != 0)) {
      ierr_ = -5;
    }
    if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
      ierr_ = -6;
    }
    if ((*lworkl_) < ((*ncv_) * (*ncv_)) + 8 * (*ncv_)) {
      ierr_ = -7;
    }
    if (mode_ < 1 || mode_ > 5) {
      ierr_ = -10;
    }
    else if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
      ierr_ = -11;
    }
    else if (ishift_ < 0 || ishift_ > 1) {
      ierr_ = -12;
    }
    else if ((*nev_) == 1 && (strcasecmp (which_, _dc_220) == 0)) {
      ierr_ = -13;
    }
    if (ierr_ != 0) {
      (*info_) = ierr_;
      (*ido_) = 99;
      goto _l9000;
    }
    if (nb_ <= 0) {
      nb_ = 1;
    }
    if ((*tol_) <= 0.0) {
      (*tol_) = _dlamch (_dc_76);
    }
    np_ = (*ncv_) - (*nev_);
    nev0_ = (*nev_);
    for (j_ = 1; j_ <= ((*ncv_) * (*ncv_)) + 8 * (*ncv_); (j_)++) {
      workl_[j_ - 1] = 0.0;
    }
    ldh_ = (*ncv_);
    ldq_ = (*ncv_);
    ih_ = 1;
    ritz_ = ih_ + 2 * ldh_;
    bounds_ = ritz_ + (*ncv_);
    iq_ = bounds_ + (*ncv_);
    iw_ = iq_ + ((*ncv_) * (*ncv_));
    next_ = iw_ + 3 * (*ncv_);
    ipntr_[3] = next_;
    ipntr_[4] = ih_;
    ipntr_[5] = ritz_;
    ipntr_[6] = bounds_;
    ipntr_[10] = iw_;
  }
  (void) _dsaup2 (ido_, bmat_, n_, which_, &nev0_, &np_, tol_, resid_, &mode_, &iupd_, &ishift_, &mxiter_, v_, ldv_, 
  &workl_[ih_ - 1], &ldh_, &workl_[ritz_ - 1], &workl_[bounds_ - 1], &workl_[iq_ - 1], &ldq_, &workl_[iw_ - 1], ipntr_, 
  workd_, info_);
  if ((*ido_) == 3) {
    iparam_[7] = np_;
  }
  if ((*ido_) != 99) {
    goto _l9000;
  }
  iparam_[2] = mxiter_;
  iparam_[4] = np_;
  iparam_[8] = timing_.nopx_;
  iparam_[9] = timing_.nbx_;
  iparam_[10] = timing_.nrorth_;
  if ((*info_) < 0) {
    goto _l9000;
  }
  if ((*info_) == 2) {
    (*info_) = 3;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &mxiter_, &debug_.ndigit_, _dc_235);
    (void) _ivout (&debug_.logfil_, &_k1, &np_, &debug_.ndigit_, _dc_236);
    (void) _dvout (&debug_.logfil_, &np_, &workl_[ritz_ - 1], &debug_.ndigit_, _dc_237);
    (void) _dvout (&debug_.logfil_, &np_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_238);
  }
  (void) _second (&t1_);
  timing_.tsaupd_ = t1_ - t0_;
  if (msglvl_ > 0) {
    _fcheck ("arpack:dsaupd:650", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:650", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _fcheck ("arpack:dsaupd:651", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &mxiter_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nopx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nbx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrorth_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nitref_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrstrt_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvopx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvbx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsaupd_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsaup2_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsaitr_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.titref_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tgetv0_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tseigt_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsgets_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsapps_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsconv_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:dsaupd:651", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _l1000:;
    _l1100:;
  }
  _l9000:;
  __calls[26].calls++;
  return 0;
}

int_4 _dsconv (int_4 _p_ n_, real_8 _p_ ritz_, real_8 _p_ bounds_, real_8 _p_ tol_, int_4 _p_ nconv_)
{
  static int_4 i_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 temp_, eps23_;
  extern real_8 _dlamch ();
  (void) _second (&t0_);
  eps23_ = _dlamch (_dc_49);
  eps23_ = pow (eps23_, 6.6666666666666667e-1);
  (*nconv_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    temp_ = _max (eps23_, _abs (ritz_[i_ - 1]));
    if (bounds_[i_ - 1] <= (*tol_) * temp_) {
      (*nconv_) = (*nconv_) + 1;
    }
  }
  (void) _second (&t1_);
  timing_.tsconv_ = timing_.tsconv_ + (t1_ - t0_);
  __calls[27].calls++;
  return 0;
}

int_4 _dseigt (real_8 _p_ rnorm_, int_4 _p_ n_, real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ eig_, real_8 _p_ bounds_, 
real_8 _p_ workl_, int_4 _p_ ierr_)
{
  static int_4 i_, k_, msglvl_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 $0_, $1_;
  extern int_4 _dcopy ();
  (void) _second (&t0_);
  msglvl_ = debug_.mseigt_;
  if (msglvl_ > 0) {
    (void) _dvout (&debug_.logfil_, n_, &h_[0 + ((*ldh_)) * ((1))], &debug_.ndigit_, _dc_248);
    if ((*n_) > 1) {
      (void) _dvout (&debug_.logfil_, ($0_ = (*n_) - 1, &$0_), &h_[1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_249);
    }
  }
  (void) _dcopy (n_, &h_[0 + ((*ldh_)) * ((1))], &_k1, eig_, &_k1);
  (void) _dcopy (($1_ = (*n_) - 1, &$1_), &h_[1 + ((*ldh_)) * ((0))], &_k1, workl_, &_k1);
  (void) _dstqrb (n_, eig_, workl_, bounds_, &workl_[(*n_) + 1 - 1], ierr_);
  if ((*ierr_) != 0) {
    goto _l9000;
  }
  if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, n_, bounds_, &debug_.ndigit_, _dc_250);
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    bounds_[k_ - 1] = (*rnorm_) * _abs (bounds_[k_ - 1]);
  }
  (void) _second (&t1_);
  timing_.tseigt_ = timing_.tseigt_ + (t1_ - t0_);
  _l9000:;
  __calls[28].calls++;
  return 0;
}

int_4 _dsesrt (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ na_, real_8 _p_ a_, int_4 
_p_ lda_)
{
  static int_4 i_, igap_, j_;
  static real_8 temp_;
  extern int_4 _dswap ();
  igap_ = (*n_) / 2;
  if ((strcasecmp (which_, _dc_221) == 0)) {
    _l10:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l20:;
      if (j_ < 0) {
        goto _l30;
      }
      if (x_[j_] < x_[j_ + igap_]) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          (void) _dswap (na_, &a_[0 + ((*lda_)) * ((j_))], &_k1, &a_[0 + ((*lda_)) * ((j_ + igap_))], &_k1);
        }
      }
      else {
        goto _l30;
      }
      j_ = j_ - igap_;
      goto _l20;
      _l30:;
    }
    igap_ = igap_ / 2;
    goto _l10;
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    _l40:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l50:;
      if (j_ < 0) {
        goto _l60;
      }
      if (_abs (x_[j_]) < _abs (x_[j_ + igap_])) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          (void) _dswap (na_, &a_[0 + ((*lda_)) * ((j_))], &_k1, &a_[0 + ((*lda_)) * ((j_ + igap_))], &_k1);
        }
      }
      else {
        goto _l60;
      }
      j_ = j_ - igap_;
      goto _l50;
      _l60:;
    }
    igap_ = igap_ / 2;
    goto _l40;
  }
  else if ((strcasecmp (which_, _dc_222) == 0)) {
    _l70:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l80:;
      if (j_ < 0) {
        goto _l90;
      }
      if (x_[j_] > x_[j_ + igap_]) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          (void) _dswap (na_, &a_[0 + ((*lda_)) * ((j_))], &_k1, &a_[0 + ((*lda_)) * ((j_ + igap_))], &_k1);
        }
      }
      else {
        goto _l90;
      }
      j_ = j_ - igap_;
      goto _l80;
      _l90:;
    }
    igap_ = igap_ / 2;
    goto _l70;
  }
  else if ((strcasecmp (which_, _dc_59) == 0)) {
    _l100:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l110:;
      if (j_ < 0) {
        goto _l120;
      }
      if (_abs (x_[j_]) > _abs (x_[j_ + igap_])) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          (void) _dswap (na_, &a_[0 + ((*lda_)) * ((j_))], &_k1, &a_[0 + ((*lda_)) * ((j_ + igap_))], &_k1);
        }
      }
      else {
        goto _l120;
      }
      j_ = j_ - igap_;
      goto _l110;
      _l120:;
    }
    igap_ = igap_ / 2;
    goto _l100;
  }
  _l9000:;
  __calls[29].calls++;
  return 0;
}

int_4 _dseupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, real_8 _p_ d_, real_8 _p_ z_, int_4 _p_ 
ldz_, real_8 _p_ sigma_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_, real_8 _p_ 
resid_, int_4 _p_ ncv_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_8 _p_ workd_, real_8 
_p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, ihb_, ihd_, iq_, iw_, j_, k_, ldh_, ldq_, mode_, msglvl_, nconv_, next_, ritz_, irz_, 
  ibd_, np_, ishift_, leftptr_, rghtptr_, numcnv_, jj_;
  static logical_4 reord_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 bnorm2_, rnorm_, temp_, temp1_, eps23_;
  static char_7 type_;
  int_4 $0_;
  logical_4 $1_, $3_;
  real_8 $2_, $4_, $5_;
  extern int_4 _dcopy ();
  extern int_4 _dger ();
  extern int_4 _dgeqr2 ();
  extern int_4 _dlacpy ();
  extern int_4 _dorm2r ();
  extern int_4 _dscal ();
  extern int_4 _dsteqr ();
  extern real_8 _dnrm2 ();
  extern real_8 _dlamch ();
  msglvl_ = debug_.mseupd_;
  mode_ = iparam_[6];
  nconv_ = iparam_[4];
  (*info_) = 0;
  if (nconv_ == 0) {
    goto _l9000;
  }
  ierr_ = 0;
  if (nconv_ <= 0) {
    ierr_ = -14;
  }
  if ((*n_) <= 0) {
    ierr_ = -1;
  }
  if ((*nev_) <= 0) {
    ierr_ = -2;
  }
  if ((*ncv_) <= (*nev_) || (*ncv_) > (*n_)) {
    ierr_ = -3;
  }
  if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_222) != 0) && 
    (strcasecmp (which_, _dc_221) != 0) && (strcasecmp (which_, _dc_220) != 0)) {
    ierr_ = -5;
  }
  if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
    ierr_ = -6;
  }
  if (((strcasecmp (howmny_, _dc_44) != 0) && (strcasecmp (howmny_, _dc_117) != 0) && (strcasecmp (howmny_, _dc_118) != 
    0)) && (*rvec_)) {
    ierr_ = -15;
  }
  if ((*rvec_) && (strcasecmp (howmny_, _dc_118) == 0)) {
    ierr_ = -16;
  }
  if ((*rvec_) && (*lworkl_) < ((*ncv_) * (*ncv_)) + 8 * (*ncv_)) {
    ierr_ = -7;
  }
  if (mode_ == 1 || mode_ == 2) {
    bufcpy (type_, _dc_119, 7);
  }
  else if (mode_ == 3) {
    bufcpy (type_, _dc_120, 7);
  }
  else if (mode_ == 4) {
    bufcpy (type_, _dc_251, 7);
  }
  else if (mode_ == 5) {
    bufcpy (type_, _dc_252, 7);
  }
  else {
    ierr_ = -10;
  }
  if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
    ierr_ = -11;
  }
  if ((*nev_) == 1 && (strcasecmp (which_, _dc_220) == 0)) {
    ierr_ = -12;
  }
  if (ierr_ != 0) {
    (*info_) = ierr_;
    goto _l9000;
  }
  ih_ = ipntr_[4];
  ritz_ = ipntr_[5];
  bounds_ = ipntr_[6];
  ldh_ = (*ncv_);
  ldq_ = (*ncv_);
  ihd_ = bounds_ + ldh_;
  ihb_ = ihd_ + ldh_;
  iq_ = ihb_ + ldh_;
  iw_ = iq_ + ldh_ * (*ncv_);
  next_ = iw_ + 2 * (*ncv_);
  ipntr_[3] = next_;
  ipntr_[7] = ihd_;
  ipntr_[8] = ihb_;
  ipntr_[9] = iq_;
  irz_ = ipntr_[10] + (*ncv_);
  ibd_ = irz_ + (*ncv_);
  eps23_ = _dlamch (_dc_49);
  eps23_ = pow (eps23_, 6.6666666666666667e-1);
  rnorm_ = workl_[ih_ - 1];
  if ((strcasecmp (bmat_, _dc_1) == 0)) {
    bnorm2_ = rnorm_;
  }
  else if ((strcasecmp (bmat_, _dc_0) == 0)) {
    bnorm2_ = _dnrm2 (n_, workd_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _dvout (&debug_.logfil_, ncv_, &workl_[irz_ - 1], &debug_.ndigit_, _dc_253);
    (void) _dvout (&debug_.logfil_, ncv_, &workl_[ibd_ - 1], &debug_.ndigit_, _dc_254);
  }
  if ((*rvec_)) {
    reord_ = FALSE;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      workl_[bounds_ + j_ - 1 - 1] = j_;
      select_[j_ - 1] = FALSE;
    }
    np_ = (*ncv_) - (*nev_);
    ishift_ = 0;
    (void) _dsgets (&ishift_, which_, nev_, &np_, &workl_[irz_ - 1], &workl_[bounds_ - 1], workl_);
    if (msglvl_ > 2) {
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[irz_ - 1], &debug_.ndigit_, _dc_255);
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_256);
    }
    numcnv_ = 0;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      temp1_ = _max (eps23_, _abs (workl_[irz_ + (*ncv_) - j_ - 1]));
      jj_ = workl_[bounds_ + (*ncv_) - j_ - 1];
      if (numcnv_ < nconv_ && workl_[ibd_ + jj_ - 1 - 1] <= (*tol_) * temp1_) {
        select_[jj_ - 1] = TRUE;
        numcnv_ = numcnv_ + 1;
        if (jj_ > (*nev_)) {
          reord_ = TRUE;
        }
      }
    }
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &numcnv_, &debug_.ndigit_, _dc_257);
      (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_258);
    }
    if (numcnv_ != nconv_) {
      (*info_) = -17;
      goto _l9000;
    }
    (void) _dcopy (($0_ = (*ncv_) - 1, &$0_), &workl_[ih_ + 1 - 1], &_k1, &workl_[ihb_ - 1], &_k1);
    (void) _dcopy (ncv_, &workl_[ih_ + ldh_ - 1], &_k1, &workl_[ihd_ - 1], &_k1);
    (void) _dsteqr (_dc_259, ncv_, &workl_[ihd_ - 1], &workl_[ihb_ - 1], &workl_[iq_ - 1], &ldq_, &workl_[iw_ - 1], &ierr_)
    ;
    if (ierr_ != 0) {
      (*info_) = -8;
      goto _l9000;
    }
    if (msglvl_ > 1) {
      (void) _dcopy (ncv_, &workl_[iq_ + (*ncv_) - 1 - 1], &ldq_, &workl_[iw_ - 1], &_k1);
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[ihd_ - 1], &debug_.ndigit_, _dc_260);
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[iw_ - 1], &debug_.ndigit_, _dc_261);
    }
    if (reord_) {
      leftptr_ = 1;
      rghtptr_ = (*ncv_);
      if ((*ncv_) == 1) {
        goto _l30;
      }
      _l20:;
      if (select_[leftptr_ - 1]) {
        leftptr_ = leftptr_ + 1;
      }
      else if (! (select_[rghtptr_ - 1])) {
        rghtptr_ = rghtptr_ - 1;
      }
      else {
        temp_ = workl_[ihd_ + leftptr_ - 1 - 1];
        workl_[ihd_ + leftptr_ - 1 - 1] = workl_[ihd_ + rghtptr_ - 1 - 1];
        workl_[ihd_ + rghtptr_ - 1 - 1] = temp_;
        (void) _dcopy (ncv_, &workl_[iq_ + (*ncv_) * (leftptr_ - 1) - 1], &_k1, &workl_[iw_ - 1], &_k1);
        (void) _dcopy (ncv_, &workl_[iq_ + (*ncv_) * (rghtptr_ - 1) - 1], &_k1, &workl_[iq_ + (*ncv_) * (leftptr_ - 1) - 1], 
        &_k1);
        (void) _dcopy (ncv_, &workl_[iw_ - 1], &_k1, &workl_[iq_ + (*ncv_) * (rghtptr_ - 1) - 1], &_k1);
        leftptr_ = leftptr_ + 1;
        rghtptr_ = rghtptr_ - 1;
      }
      if (leftptr_ < rghtptr_) {
        goto _l20;
      }
      _l30:;
    }
    if (msglvl_ > 2) {
      (void) _dvout (&debug_.logfil_, ncv_, &workl_[ihd_ - 1], &debug_.ndigit_, _dc_262);
    }
    (void) _dcopy (&nconv_, &workl_[ihd_ - 1], &_k1, d_, &_k1);
  }
  else {
    (void) _dcopy (&nconv_, &workl_[ritz_ - 1], &_k1, d_, &_k1);
    (void) _dcopy (ncv_, &workl_[ritz_ - 1], &_k1, &workl_[ihd_ - 1], &_k1);
  }
  if ((strcasecmp (type_, _dc_119) == 0)) {
    if ((*rvec_)) {
      (void) _dsesrt (_dc_222, rvec_, &nconv_, d_, ncv_, &workl_[iq_ - 1], &ldq_);
    }
    else {
      (void) _dcopy (ncv_, &workl_[bounds_ - 1], &_k1, &workl_[ihb_ - 1], &_k1);
    }
  }
  else {
    (void) _dcopy (ncv_, &workl_[ihd_ - 1], &_k1, &workl_[iw_ - 1], &_k1);
    if ((strcasecmp (type_, _dc_120) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihd_ + k_ - 1 - 1] = 1.0 / workl_[ihd_ + k_ - 1 - 1] + (*sigma_);
      }
    }
    else if ((strcasecmp (type_, _dc_251) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihd_ + k_ - 1 - 1] = (*sigma_) * workl_[ihd_ + k_ - 1 - 1] / (workl_[ihd_ + k_ - 1 - 1] - 1.0);
      }
    }
    else if ((strcasecmp (type_, _dc_252) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihd_ + k_ - 1 - 1] = (*sigma_) * (workl_[ihd_ + k_ - 1 - 1] + 1.0) / (workl_[ihd_ + k_ - 1 - 1] - 1.0);
      }
    }
    (void) _dcopy (&nconv_, &workl_[ihd_ - 1], &_k1, d_, &_k1);
    (void) _dsortr (_dc_222, ($1_ = TRUE, &$1_), &nconv_, &workl_[ihd_ - 1], &workl_[iw_ - 1]);
    if ((*rvec_)) {
      (void) _dsesrt (_dc_222, rvec_, &nconv_, d_, ncv_, &workl_[iq_ - 1], &ldq_);
    }
    else {
      (void) _dcopy (ncv_, &workl_[bounds_ - 1], &_k1, &workl_[ihb_ - 1], &_k1);
      (void) _dscal (ncv_, ($2_ = bnorm2_ / rnorm_, &$2_), &workl_[ihb_ - 1], &_k1);
      (void) _dsortr (_dc_222, ($3_ = TRUE, &$3_), &nconv_, d_, &workl_[ihb_ - 1]);
    }
  }
  if ((*rvec_) && (strcasecmp (howmny_, _dc_44) == 0)) {
    (void) _dgeqr2 (ncv_, &nconv_, &workl_[iq_ - 1], &ldq_, &workl_[iw_ + (*ncv_) - 1], &workl_[ihb_ - 1], &ierr_);
    (void) _dorm2r (_dc_112, _dc_134, n_, ncv_, &nconv_, &workl_[iq_ - 1], &ldq_, &workl_[iw_ + (*ncv_) - 1], v_, ldv_, 
    &workd_[(*n_) + 1 - 1], &ierr_);
    (void) _dlacpy (_dc_36, n_, &nconv_, v_, ldv_, z_, ldz_);
    for (j_ = 1; j_ <= (*ncv_) - 1; (j_)++) {
      workl_[ihb_ + j_ - 1 - 1] = 0.0;
    }
    workl_[ihb_ + (*ncv_) - 1 - 1] = 1.0;
    (void) _dorm2r (_dc_158, _dc_263, ncv_, &_k1, &nconv_, &workl_[iq_ - 1], &ldq_, &workl_[iw_ + (*ncv_) - 1], 
    &workl_[ihb_ - 1], ncv_, &temp_, &ierr_);
  }
  else if ((*rvec_) && (strcasecmp (howmny_, _dc_118) == 0)) {
  }
  if ((strcasecmp (type_, _dc_119) == 0) && (*rvec_)) {
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      workl_[ihb_ + j_ - 1 - 1] = rnorm_ * _abs (workl_[ihb_ + j_ - 1 - 1]);
    }
  }
  else if ((strcasecmp (type_, _dc_119) != 0) && (*rvec_)) {
    (void) _dscal (ncv_, &bnorm2_, &workl_[ihb_ - 1], &_k1);
    if ((strcasecmp (type_, _dc_120) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihb_ + k_ - 1 - 1] = _abs (workl_[ihb_ + k_ - 1 - 1]) / (workl_[iw_ + k_ - 1 - 1] * workl_[iw_ + k_ - 1 - 1]);
      }
    }
    else if ((strcasecmp (type_, _dc_251) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihb_ + k_ - 1 - 1] = (*sigma_) * _abs (workl_[ihb_ + k_ - 1 - 1]) / ($4_ = (workl_[iw_ + k_ - 1 - 1] - 1.0), $4_ 
        * $4_);
      }
    }
    else if ((strcasecmp (type_, _dc_252) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihb_ + k_ - 1 - 1] = _abs (workl_[ihb_ + k_ - 1 - 1] / workl_[iw_ + k_ - 1 - 1] * (workl_[iw_ + k_ - 1 - 1] - 
        1.0));
      }
    }
  }
  if ((strcasecmp (type_, _dc_119) != 0) && msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &nconv_, d_, &debug_.ndigit_, _dc_264);
    (void) _dvout (&debug_.logfil_, &nconv_, &workl_[ihb_ - 1], &debug_.ndigit_, _dc_265);
  }
  else if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &nconv_, d_, &debug_.ndigit_, _dc_266);
    (void) _dvout (&debug_.logfil_, &nconv_, &workl_[ihb_ - 1], &debug_.ndigit_, _dc_267);
  }
  if ((*rvec_) && ((strcasecmp (type_, _dc_120) == 0) || (strcasecmp (type_, _dc_252) == 0))) {
    for (k_ = 0; k_ <= nconv_ - 1; (k_)++) {
      workl_[iw_ + k_ - 1] = workl_[iq_ + k_ * ldq_ + (*ncv_) - 1 - 1] / workl_[iw_ + k_ - 1];
    }
  }
  else if ((*rvec_) && (strcasecmp (type_, _dc_251) == 0)) {
    for (k_ = 0; k_ <= nconv_ - 1; (k_)++) {
      workl_[iw_ + k_ - 1] = workl_[iq_ + k_ * ldq_ + (*ncv_) - 1 - 1] / (workl_[iw_ + k_ - 1] - 1.0);
    }
  }
  if ((strcasecmp (type_, _dc_119) != 0)) {
    (void) _dger (n_, &nconv_, ($5_ = 1.0, &$5_), resid_, &_k1, &workl_[iw_ - 1], &_k1, z_, ldz_);
  }
  _l9000:;
  __calls[30].calls++;
  return 0;
}
int_4 _dsgets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, real_8 _p_ ritz_, real_8 _p_ bounds_, 
real_8 _p_ shifts_)
{
  static int_4 kevd2_, msglvl_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 $1_, $2_, $3_, $5_, $7_, $8_;
  logical_4 $0_, $4_, $6_;
  extern int_4 _dswap ();
  extern int_4 _dcopy ();
  (void) _second (&t0_);
  msglvl_ = debug_.msgets_;
  if ((strcasecmp (which_, _dc_220) == 0)) {
    (void) _dsortr (_dc_222, ($0_ = TRUE, &$0_), ($1_ = (*kev_) + (*np_), &$1_), ritz_, bounds_);
    kevd2_ = (*kev_) / 2;
    if ((*kev_) > 1) {
      (void) _dswap (($2_ = _min (kevd2_, (*np_)), &$2_), ritz_, &_k1, &ritz_[_max (kevd2_, (*np_)) + 1 - 1], &_k1);
      (void) _dswap (($3_ = _min (kevd2_, (*np_)), &$3_), bounds_, &_k1, &bounds_[_max (kevd2_, (*np_)) + 1 - 1], &_k1);
    }
  }
  else {
    (void) _dsortr (which_, ($4_ = TRUE, &$4_), ($5_ = (*kev_) + (*np_), &$5_), ritz_, bounds_);
  }
  if ((*ishift_) == 1 && (*np_) > 0) {
    (void) _dsortr (_dc_60, ($6_ = TRUE, &$6_), np_, bounds_, ritz_);
    (void) _dcopy (np_, ritz_, &_k1, shifts_, &_k1);
  }
  (void) _second (&t1_);
  timing_.tsgets_ = timing_.tsgets_ + (t1_ - t0_);
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_268);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_269);
    (void) _dvout (&debug_.logfil_, ($7_ = (*kev_) + (*np_), &$7_), ritz_, &debug_.ndigit_, _dc_270);
    (void) _dvout (&debug_.logfil_, ($8_ = (*kev_) + (*np_), &$8_), bounds_, &debug_.ndigit_, _dc_271);
  }
  __calls[31].calls++;
  return 0;
}

int_4 _dsortc (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_8 _p_ xreal_, real_8 _p_ ximag_, real_8 _p_ y_
)
{
  static int_4 i_, igap_, j_;
  static real_8 temp_, temp1_, temp2_;
  extern real_8 _dlapy2 ();
  igap_ = (*n_) / 2;
  if ((strcasecmp (which_, _dc_59) == 0)) {
    _l10:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l20:;
      if (j_ < 0) {
        goto _l30;
      }
      temp1_ = _dlapy2 (&xreal_[j_], &ximag_[j_]);
      temp2_ = _dlapy2 (&xreal_[j_ + igap_], &ximag_[j_ + igap_]);
      if (temp1_ > temp2_) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l30;
      }
      j_ = j_ - igap_;
      goto _l20;
      _l30:;
    }
    igap_ = igap_ / 2;
    goto _l10;
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    _l40:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l50:;
      if (j_ < 0) {
        goto _l60;
      }
      temp1_ = _dlapy2 (&xreal_[j_], &ximag_[j_]);
      temp2_ = _dlapy2 (&xreal_[j_ + igap_], &ximag_[j_ + igap_]);
      if (temp1_ < temp2_) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l60;
      }
      j_ = j_ - igap_;
      goto _l50;
      _l60:;
    }
    igap_ = igap_ / 2;
    goto _l40;
  }
  else if ((strcasecmp (which_, _dc_61) == 0)) {
    _l70:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l80:;
      if (j_ < 0) {
        goto _l90;
      }
      if (xreal_[j_] > xreal_[j_ + igap_]) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l90;
      }
      j_ = j_ - igap_;
      goto _l80;
      _l90:;
    }
    igap_ = igap_ / 2;
    goto _l70;
  }
  else if ((strcasecmp (which_, _dc_62) == 0)) {
    _l100:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l110:;
      if (j_ < 0) {
        goto _l120;
      }
      if (xreal_[j_] < xreal_[j_ + igap_]) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l120;
      }
      j_ = j_ - igap_;
      goto _l110;
      _l120:;
    }
    igap_ = igap_ / 2;
    goto _l100;
  }
  else if ((strcasecmp (which_, _dc_63) == 0)) {
    _l130:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l140:;
      if (j_ < 0) {
        goto _l150;
      }
      if (_abs (ximag_[j_]) > _abs (ximag_[j_ + igap_])) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l150;
      }
      j_ = j_ - igap_;
      goto _l140;
      _l150:;
    }
    igap_ = igap_ / 2;
    goto _l130;
  }
  else if ((strcasecmp (which_, _dc_64) == 0)) {
    _l160:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l170:;
      if (j_ < 0) {
        goto _l180;
      }
      if (_abs (ximag_[j_]) < _abs (ximag_[j_ + igap_])) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l180;
      }
      j_ = j_ - igap_;
      goto _l170;
      _l180:;
    }
    igap_ = igap_ / 2;
    goto _l160;
  }
  _l9000:;
  __calls[32].calls++;
  return 0;
}

int_4 _dsortr (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_8 _p_ x1_, real_8 _p_ x2_)
{
  static int_4 i_, igap_, j_;
  static real_8 temp_;
  igap_ = (*n_) / 2;
  if ((strcasecmp (which_, _dc_221) == 0)) {
    _l10:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l20:;
      if (j_ < 0) {
        goto _l30;
      }
      if (x1_[j_] < x1_[j_ + igap_]) {
        temp_ = x1_[j_];
        x1_[j_] = x1_[j_ + igap_];
        x1_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = x2_[j_];
          x2_[j_] = x2_[j_ + igap_];
          x2_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l30;
      }
      j_ = j_ - igap_;
      goto _l20;
      _l30:;
    }
    igap_ = igap_ / 2;
    goto _l10;
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    _l40:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l50:;
      if (j_ < 0) {
        goto _l60;
      }
      if (_abs (x1_[j_]) < _abs (x1_[j_ + igap_])) {
        temp_ = x1_[j_];
        x1_[j_] = x1_[j_ + igap_];
        x1_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = x2_[j_];
          x2_[j_] = x2_[j_ + igap_];
          x2_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l60;
      }
      j_ = j_ - igap_;
      goto _l50;
      _l60:;
    }
    igap_ = igap_ / 2;
    goto _l40;
  }
  else if ((strcasecmp (which_, _dc_222) == 0)) {
    _l70:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l80:;
      if (j_ < 0) {
        goto _l90;
      }
      if (x1_[j_] > x1_[j_ + igap_]) {
        temp_ = x1_[j_];
        x1_[j_] = x1_[j_ + igap_];
        x1_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = x2_[j_];
          x2_[j_] = x2_[j_ + igap_];
          x2_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l90;
      }
      j_ = j_ - igap_;
      goto _l80;
      _l90:;
    }
    igap_ = igap_ / 2;
    goto _l70;
  }
  else if ((strcasecmp (which_, _dc_59) == 0)) {
    _l100:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l110:;
      if (j_ < 0) {
        goto _l120;
      }
      if (_abs (x1_[j_]) > _abs (x1_[j_ + igap_])) {
        temp_ = x1_[j_];
        x1_[j_] = x1_[j_ + igap_];
        x1_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = x2_[j_];
          x2_[j_] = x2_[j_ + igap_];
          x2_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l120;
      }
      j_ = j_ - igap_;
      goto _l110;
      _l120:;
    }
    igap_ = igap_ / 2;
    goto _l100;
  }
  _l9000:;
  __calls[33].calls++;
  return 0;
}

int_4 _dstatn (void)
{
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  timing_.nopx_ = 0;
  timing_.nbx_ = 0;
  timing_.nrorth_ = 0;
  timing_.nitref_ = 0;
  timing_.nrstrt_ = 0;
  timing_.tnaupd_ = 0.0;
  timing_.tnaup2_ = 0.0;
  timing_.tnaitr_ = 0.0;
  timing_.tneigh_ = 0.0;
  timing_.tngets_ = 0.0;
  timing_.tnapps_ = 0.0;
  timing_.tnconv_ = 0.0;
  timing_.titref_ = 0.0;
  timing_.tgetv0_ = 0.0;
  timing_.trvec_ = 0.0;
  timing_.tmvopx_ = 0.0;
  timing_.tmvbx_ = 0.0;
  __calls[34].calls++;
  return 0;
}

int_4 _dstats (void)
{
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  timing_.nopx_ = 0;
  timing_.nbx_ = 0;
  timing_.nrorth_ = 0;
  timing_.nitref_ = 0;
  timing_.nrstrt_ = 0;
  timing_.tsaupd_ = 0.0;
  timing_.tsaup2_ = 0.0;
  timing_.tsaitr_ = 0.0;
  timing_.tseigt_ = 0.0;
  timing_.tsgets_ = 0.0;
  timing_.tsapps_ = 0.0;
  timing_.tsconv_ = 0.0;
  timing_.titref_ = 0.0;
  timing_.tgetv0_ = 0.0;
  timing_.trvec_ = 0.0;
  timing_.tmvopx_ = 0.0;
  timing_.tmvbx_ = 0.0;
  __calls[35].calls++;
  return 0;
}

int_4 _dstqrb (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, icompz_, ii_, iscale_, j_, jtot_, k_, l_, l1_, lend_, lendm1_, lendp1_, lendsv_, lm1_, lsv_, m_, mm_, 
  mm1_, nm1_, nmaxit_;
  static real_8 anorm_, b_, c_, eps_, eps2_, f_, g_, p_, r_, rt1_, rt2_, s_, safmax_, safmin_, ssfmax_, ssfmin_, tst_;
  int_4 $0_, $1_, $2_, $3_, $4_, $9_, $10_, $11_, $12_;
  real_8 $5_, $6_, $7_, $8_;
  extern real_8 _dlamch ();
  extern real_8 _dlanst ();
  extern real_8 _dlapy2 ();
  extern int_4 _dlae2 ();
  extern int_4 _dlaev2 ();
  extern int_4 _dlartg ();
  extern int_4 _dlascl ();
  extern int_4 _dlasr ();
  extern int_4 _dlasrt ();
  (*info_) = 0;
  icompz_ = 2;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*n_) == 1) {
    if (icompz_ == 2) {
      z_[0] = 1.0;
    }
    goto _l0;
  }
  eps_ = _dlamch (_dc_272);
  eps2_ = (eps_ * eps_);
  safmin_ = _dlamch (_dc_118);
  safmax_ = 1.0 / safmin_;
  ssfmax_ = sqrt (safmax_) / 3.0;
  ssfmin_ = sqrt (safmin_) / eps2_;
  if (icompz_ == 2) {
    for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
      z_[j_ - 1] = 0.0;
    }
    z_[(*n_) - 1] = 1.0;
  }
  nmaxit_ = (*n_) * 30;
  jtot_ = 0;
  l1_ = 1;
  nm1_ = (*n_) - 1;
  _l10:;
  if (l1_ > (*n_)) {
    goto _l160;
  }
  if (l1_ > 1) {
    e_[l1_ - 1 - 1] = 0.0;
  }
  if (l1_ <= nm1_) {
    for (m_ = l1_; m_ <= nm1_; (m_)++) {
      tst_ = _abs (e_[m_ - 1]);
      if (tst_ == 0.0) {
        goto _l30;
      }
      if (tst_ <= (sqrt (_abs (d_[m_ - 1])) * sqrt (_abs (d_[m_ + 1 - 1]))) * eps_) {
        e_[m_ - 1] = 0.0;
        goto _l30;
      }
    }
  }
  m_ = (*n_);
  _l30:;
  l_ = l1_;
  lsv_ = l_;
  lend_ = m_;
  lendsv_ = lend_;
  l1_ = m_ + 1;
  if (lend_ == l_) {
    goto _l10;
  }
  anorm_ = _dlanst (_dc_1, ($0_ = lend_ - l_ + 1, &$0_), &d_[l_ - 1], &e_[l_ - 1]);
  iscale_ = 0;
  if (anorm_ == 0.0) {
    goto _l10;
  }
  if (anorm_ > ssfmax_) {
    iscale_ = 1;
    (void) _dlascl (_dc_0, &_k0, &_k0, &anorm_, &ssfmax_, ($1_ = lend_ - l_ + 1, &$1_), &_k1, &d_[l_ - 1], n_, info_);
    (void) _dlascl (_dc_0, &_k0, &_k0, &anorm_, &ssfmax_, ($2_ = lend_ - l_, &$2_), &_k1, &e_[l_ - 1], n_, info_);
  }
  else if (anorm_ < ssfmin_) {
    iscale_ = 2;
    (void) _dlascl (_dc_0, &_k0, &_k0, &anorm_, &ssfmin_, ($3_ = lend_ - l_ + 1, &$3_), &_k1, &d_[l_ - 1], n_, info_);
    (void) _dlascl (_dc_0, &_k0, &_k0, &anorm_, &ssfmin_, ($4_ = lend_ - l_, &$4_), &_k1, &e_[l_ - 1], n_, info_);
  }
  if (_abs (d_[lend_ - 1]) < _abs (d_[l_ - 1])) {
    lend_ = lsv_;
    l_ = lendsv_;
  }
  if (lend_ > l_) {
    _l40:;
    if (l_ != lend_) {
      lendm1_ = lend_ - 1;
      for (m_ = l_; m_ <= lendm1_; (m_)++) {
        tst_ = ($5_ = _abs (e_[m_ - 1]), $5_ * $5_);
        if (tst_ <= (eps2_ * _abs (d_[m_ - 1])) * _abs (d_[m_ + 1 - 1]) + safmin_) {
          goto _l60;
        }
      }
    }
    m_ = lend_;
    _l60:;
    if (m_ < lend_) {
      e_[m_ - 1] = 0.0;
    }
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l80;
    }
    if (m_ == l_ + 1) {
      if (icompz_ > 0) {
        (void) _dlaev2 (&d_[l_ - 1], &e_[l_ - 1], &d_[l_ + 1 - 1], &rt1_, &rt2_, &c_, &s_);
        work_[l_ - 1] = c_;
        work_[(*n_) - 1 + l_ - 1] = s_;
        tst_ = z_[l_ + 1 - 1];
        z_[l_ + 1 - 1] = c_ * tst_ - s_ * z_[l_ - 1];
        z_[l_ - 1] = s_ * tst_ + c_ * z_[l_ - 1];
      }
      else {
        (void) _dlae2 (&d_[l_ - 1], &e_[l_ - 1], &d_[l_ + 1 - 1], &rt1_, &rt2_);
      }
      d_[l_ - 1] = rt1_;
      d_[l_ + 1 - 1] = rt2_;
      e_[l_ - 1] = 0.0;
      l_ = l_ + 2;
      if (l_ <= lend_) {
        goto _l40;
      }
      goto _l140;
    }
    if (jtot_ == nmaxit_) {
      goto _l140;
    }
    jtot_ = jtot_ + 1;
    g_ = (d_[l_ + 1 - 1] - p_) / (2.0 * e_[l_ - 1]);
    r_ = _dlapy2 (&g_, ($6_ = 1.0, &$6_));
    g_ = d_[m_ - 1] - p_ + (e_[l_ - 1] / (g_ + _sign (r_, g_)));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    mm1_ = m_ - 1;
    for (i_ = mm1_; i_ >= l_; (i_)--) {
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      (void) _dlartg (&g_, &f_, &c_, &s_, &r_);
      if (i_ != m_ - 1) {
        e_[i_ + 1 - 1] = r_;
      }
      g_ = d_[i_ + 1 - 1] - p_;
      r_ = (d_[i_ - 1] - g_) * s_ + 2.0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ + 1 - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      if (icompz_ > 0) {
        work_[i_ - 1] = c_;
        work_[(*n_) - 1 + i_ - 1] = -s_;
      }
    }
    if (icompz_ > 0) {
      mm_ = m_ - l_ + 1;
      (void) _dlasr (_dc_175, _dc_131, _dc_273, &_k1, &mm_, &work_[l_ - 1], &work_[(*n_) - 1 + l_ - 1], &z_[l_ - 1], &_k1);
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[l_ - 1] = g_;
    goto _l40;
    _l80:;
    d_[l_ - 1] = p_;
    l_ = l_ + 1;
    if (l_ <= lend_) {
      goto _l40;
    }
    goto _l140;
  }
  else {
    _l90:;
    if (l_ != lend_) {
      lendp1_ = lend_ + 1;
      for (m_ = l_; m_ >= lendp1_; (m_)--) {
        tst_ = ($7_ = _abs (e_[m_ - 1 - 1]), $7_ * $7_);
        if (tst_ <= (eps2_ * _abs (d_[m_ - 1])) * _abs (d_[m_ - 1 - 1]) + safmin_) {
          goto _l110;
        }
      }
    }
    m_ = lend_;
    _l110:;
    if (m_ > lend_) {
      e_[m_ - 1 - 1] = 0.0;
    }
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l130;
    }
    if (m_ == l_ - 1) {
      if (icompz_ > 0) {
        (void) _dlaev2 (&d_[l_ - 1 - 1], &e_[l_ - 1 - 1], &d_[l_ - 1], &rt1_, &rt2_, &c_, &s_);
        tst_ = z_[l_ - 1];
        z_[l_ - 1] = c_ * tst_ - s_ * z_[l_ - 1 - 1];
        z_[l_ - 1 - 1] = s_ * tst_ + c_ * z_[l_ - 1 - 1];
      }
      else {
        (void) _dlae2 (&d_[l_ - 1 - 1], &e_[l_ - 1 - 1], &d_[l_ - 1], &rt1_, &rt2_);
      }
      d_[l_ - 1 - 1] = rt1_;
      d_[l_ - 1] = rt2_;
      e_[l_ - 1 - 1] = 0.0;
      l_ = l_ - 2;
      if (l_ >= lend_) {
        goto _l90;
      }
      goto _l140;
    }
    if (jtot_ == nmaxit_) {
      goto _l140;
    }
    jtot_ = jtot_ + 1;
    g_ = (d_[l_ - 1 - 1] - p_) / (2.0 * e_[l_ - 1 - 1]);
    r_ = _dlapy2 (&g_, ($8_ = 1.0, &$8_));
    g_ = d_[m_ - 1] - p_ + (e_[l_ - 1 - 1] / (g_ + _sign (r_, g_)));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    lm1_ = l_ - 1;
    for (i_ = m_; i_ <= lm1_; (i_)++) {
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      (void) _dlartg (&g_, &f_, &c_, &s_, &r_);
      if (i_ != m_) {
        e_[i_ - 1 - 1] = r_;
      }
      g_ = d_[i_ - 1] - p_;
      r_ = (d_[i_ + 1 - 1] - g_) * s_ + 2.0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      if (icompz_ > 0) {
        work_[i_ - 1] = c_;
        work_[(*n_) - 1 + i_ - 1] = s_;
      }
    }
    if (icompz_ > 0) {
      mm_ = l_ - m_ + 1;
      (void) _dlasr (_dc_175, _dc_131, _dc_274, &_k1, &mm_, &work_[m_ - 1], &work_[(*n_) - 1 + m_ - 1], &z_[m_ - 1], &_k1);
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[lm1_ - 1] = g_;
    goto _l90;
    _l130:;
    d_[l_ - 1] = p_;
    l_ = l_ - 1;
    if (l_ >= lend_) {
      goto _l90;
    }
    goto _l140;
  }
  _l140:;
  if (iscale_ == 1) {
    (void) _dlascl (_dc_0, &_k0, &_k0, &ssfmax_, &anorm_, ($9_ = lendsv_ - lsv_ + 1, &$9_), &_k1, &d_[lsv_ - 1], n_, info_)
    ;
    (void) _dlascl (_dc_0, &_k0, &_k0, &ssfmax_, &anorm_, ($10_ = lendsv_ - lsv_, &$10_), &_k1, &e_[lsv_ - 1], n_, info_);
  }
  else if (iscale_ == 2) {
    (void) _dlascl (_dc_0, &_k0, &_k0, &ssfmin_, &anorm_, ($11_ = lendsv_ - lsv_ + 1, &$11_), &_k1, &d_[lsv_ - 1], n_, 
    info_);
    (void) _dlascl (_dc_0, &_k0, &_k0, &ssfmin_, &anorm_, ($12_ = lendsv_ - lsv_, &$12_), &_k1, &e_[lsv_ - 1], n_, info_);
  }
  if (jtot_ < nmaxit_) {
    goto _l10;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (e_[i_ - 1] != 0.0) {
      (*info_) = (*info_) + 1;
    }
  }
  goto _l190;
  _l160:;
  if (icompz_ == 0) {
    (void) _dlasrt (_dc_1, n_, d_, info_);
  }
  else {
    for (ii_ = 2; ii_ <= (*n_); (ii_)++) {
      i_ = ii_ - 1;
      k_ = i_;
      p_ = d_[i_ - 1];
      for (j_ = ii_; j_ <= (*n_); (j_)++) {
        if (d_[j_ - 1] < p_) {
          k_ = j_;
          p_ = d_[j_ - 1];
        }
      }
      if (k_ != i_) {
        d_[k_ - 1] = d_[i_ - 1];
        d_[i_ - 1] = p_;
        p_ = z_[k_ - 1];
        z_[k_ - 1] = z_[i_ - 1];
        z_[i_ - 1] = p_;
      }
    }
  }
  _l190:;
  _l0:;
  __calls[36].calls++;
  return 0;
}

int_4 _dvout (int_4 _p_ lout_, int_4 _p_ n_, real_8 _p_ sx_, int_4 _p_ idigit_, char _p_ ifmt_)
{
  static int_4 i_, k1_, k2_, lll_, ndigit_;
  static char_127 line_;
  int_4 $u_0_, __fcnt, __rc, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_, $u_10_, $u_11_;
  char_127 $1_, $2_;
  static FORMAT $f_9999_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_9998_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9997_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9996_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9995_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%24e","%24.13.0e",
    FMT_REAL,"%24e","%24.13.0e",
    FMT_REAL,"%24e","%24.13.0e",
    FMT_REAL,"%24e","%24.13.0e",
    FMT_REAL,"%24e","%24.13.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9994_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  lll_ = _min ((int_4) strlen (ifmt_), 80);
  for (i_ = 1; i_ <= lll_; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_10);
  }
  for (i_ = lll_ + 1; i_ <= 80; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_11);
  }
  $u_0_ = (*lout_);
  _fcheck ("arpack:dvout:51", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:dvout:51", $u_0_));
    __fcnt += 3;
  }
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:dvout:51", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], ifmt_, CHARACTER, 0);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:dvout:51", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:dvout:51", $u_0_));
    __fcnt += 3;
  }
  bufcpy ($2_, _bufsub ((char *) $1_, (char *) line_, 1, lll_), 127);
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:dvout:51", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], $2_, CHARACTER, 127);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:dvout:51", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:dvout:51", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  _l9999:;
  if ((*n_) <= 0) {
    goto _l0;
  }
  ndigit_ = (*idigit_);
  if ((*idigit_) == 0) {
    ndigit_ = 4;
  }
  if ((*idigit_) < 0) {
    ndigit_ = -(*idigit_);
    if (ndigit_ <= 4) {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_3_ = (*lout_);
        _fcheck ("arpack:dvout:69", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
          __fcnt += 3;
        }
        if ($f_9998_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_3_].unit, "\n");
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
        __fcnt += 3;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          if ($f_9998_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
          __fcnt += 3;
        }
        if ($f_9998_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_3_].unit, "\n");
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
        __fcnt += 3;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          if ($f_9998_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &sx_[i_ - 1], REAL, 8);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:dvout:69", $u_3_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_3_);
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (4 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 4) {
        k2_ = _min ((*n_), k1_ + 3);
        $u_4_ = (*lout_);
        _fcheck ("arpack:dvout:74", $u_4_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
          __fcnt += 3;
        }
        if ($f_9997_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
        __fcnt += 3;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          if ($f_9997_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
          __fcnt += 3;
        }
        if ($f_9997_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
        __fcnt += 3;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          if ($f_9997_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_4_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &sx_[i_ - 1], REAL, 8);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:dvout:74", $u_4_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_4_);
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_5_ = (*lout_);
        _fcheck ("arpack:dvout:79", $u_5_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
          __fcnt += 3;
        }
        if ($f_9996_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
        __fcnt += 3;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          if ($f_9996_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
          __fcnt += 3;
        }
        if ($f_9996_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
        __fcnt += 3;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          if ($f_9996_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_5_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], &sx_[i_ - 1], REAL, 8);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:dvout:79", $u_5_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_5_);
      }
    }
    else {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_6_ = (*lout_);
        _fcheck ("arpack:dvout:84", $u_6_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
          __fcnt += 3;
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_6_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
          __fcnt += 3;
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_6_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], &sx_[i_ - 1], REAL, 8);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:dvout:84", $u_6_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_6_);
      }
    }
  }
  else {
    if (ndigit_ <= 4) {
      for (k1_ = 1; (10 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 10) {
        k2_ = _min ((*n_), k1_ + 9);
        $u_7_ = (*lout_);
        _fcheck ("arpack:dvout:96", $u_7_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
          __fcnt += 3;
        }
        if ($f_9998_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_7_].unit, "\n");
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
        __fcnt += 3;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          if ($f_9998_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
          __fcnt += 3;
        }
        if ($f_9998_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_7_].unit, "\n");
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
        __fcnt += 3;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          if ($f_9998_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], &sx_[i_ - 1], REAL, 8);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:dvout:96", $u_7_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_7_);
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (8 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 8) {
        k2_ = _min ((*n_), k1_ + 7);
        $u_8_ = (*lout_);
        _fcheck ("arpack:dvout:101", $u_8_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
          __fcnt += 3;
        }
        if ($f_9997_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_8_].unit, "\n");
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
        __fcnt += 3;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          if ($f_9997_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
          __fcnt += 3;
        }
        if ($f_9997_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_8_].unit, "\n");
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
        __fcnt += 3;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          if ($f_9997_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], &sx_[i_ - 1], REAL, 8);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:dvout:101", $u_8_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_8_);
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (6 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 6) {
        k2_ = _min ((*n_), k1_ + 5);
        $u_9_ = (*lout_);
        _fcheck ("arpack:dvout:106", $u_9_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
          __fcnt += 3;
        }
        if ($f_9996_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
        __fcnt += 3;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          if ($f_9996_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
          __fcnt += 3;
        }
        if ($f_9996_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
        __fcnt += 3;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          if ($f_9996_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_9_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], &sx_[i_ - 1], REAL, 8);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:dvout:106", $u_9_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_9_);
      }
    }
    else {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_10_ = (*lout_);
        _fcheck ("arpack:dvout:111", $u_10_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
          __fcnt += 3;
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_10_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
          __fcnt += 3;
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_10_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_10_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], &sx_[i_ - 1], REAL, 8);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:dvout:111", $u_10_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_10_);
      }
    }
  }
  $u_11_ = (*lout_);
  _fcheck ("arpack:dvout:115", $u_11_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_11_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_11_, _ioerr_write ("arpack:dvout:115", $u_11_));
    __fcnt += 3;
  }
  _write_eol ($u_11_);
  goto _l0;
  _l9998:;
  _l9997:;
  _l9996:;
  _l9995:;
  _l9994:;
  _l0:;
  __calls[37].calls++;
  return 0;
}

int_4 _icnteq (int_4 _p_ n_, int_4 _p_ array_, int_4 _p_ value_)
{
  static int_4 k_, i_;
  int_4 icnteq_;
  k_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (array_[i_ - 1] == (*value_)) {
      k_ = k_ + 1;
    }
  }
  icnteq_ = k_;
  __calls[38].calls++;
  return icnteq_;
}

int_4 _icopy (int_4 _p_ n_, int_4 _p_ lx_, int_4 _p_ incx_, int_4 _p_ ly_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ly_[iy_ - 1] = lx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ly_[i_ - 1] = lx_[i_ - 1];
  }
  _l0:;
  __calls[39].calls++;
  return 0;
}

int_4 _iset (int_4 _p_ n_, int_4 _p_ value_, int_4 _p_ array_, int_4 _p_ inc_)
{
  static int_4 i_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    array_[i_ - 1] = (*value_);
  }
  __calls[40].calls++;
  return 0;
}

int_4 _iswap (int_4 _p_ n_, int_4 _p_ sx_, int_4 _p_ incx_, int_4 _p_ sy_, int_4 _p_ incy_)
{
  static int_4 stemp_, i_, ix_, iy_, m_, mp1_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = sx_[ix_ - 1];
    sx_[ix_ - 1] = sy_[iy_ - 1];
    sy_[iy_ - 1] = stemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 3);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    stemp_ = sx_[i_ - 1];
    sx_[i_ - 1] = sy_[i_ - 1];
    sy_[i_ - 1] = stemp_;
  }
  if ((*n_) < 3) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (3 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 3) {
    stemp_ = sx_[i_ - 1];
    sx_[i_ - 1] = sy_[i_ - 1];
    sy_[i_ - 1] = stemp_;
    stemp_ = sx_[i_ + 1 - 1];
    sx_[i_ + 1 - 1] = sy_[i_ + 1 - 1];
    sy_[i_ + 1 - 1] = stemp_;
    stemp_ = sx_[i_ + 2 - 1];
    sx_[i_ + 2 - 1] = sy_[i_ + 2 - 1];
    sy_[i_ + 2 - 1] = stemp_;
  }
  _l0:;
  __calls[41].calls++;
  return 0;
}

int_4 _ivout (int_4 _p_ lout_, int_4 _p_ n_, int_4 _p_ ix_, int_4 _p_ idigit_, char _p_ ifmt_)
{
  static int_4 i_, ndigit_, k1_, k2_, lll_;
  static char_127 line_;
  int_4 $u_0_, __fcnt, __rc, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_, $u_10_, $u_11_;
  char_127 $1_, $2_;
  static FORMAT $f_2000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_1000_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%5d","%5d",
    NULL, NULL, NULL
  };
  static FORMAT $f_1001_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%7d","%7d",
    NULL, NULL, NULL
  };
  static FORMAT $f_1002_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%11d","%11d",
    NULL, NULL, NULL
  };
  static FORMAT $f_1003_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%15d","%15d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%15d","%15d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%15d","%15d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%15d","%15d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%15d","%15d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%15d","%15d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%15d","%15d",
    NULL, NULL, NULL
  };
  static FORMAT $f_1004_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  lll_ = _min ((int_4) strlen (ifmt_), 80);
  for (i_ = 1; i_ <= lll_; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_10);
  }
  for (i_ = lll_ + 1; i_ <= 80; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_11);
  }
  $u_0_ = (*lout_);
  _fcheck ("arpack:ivout:41", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_2000_[__fcnt] != NULL && $f_2000_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_2000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:ivout:41", $u_0_));
    __fcnt += 3;
  }
  if ($f_2000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_2000_[__fcnt] != NULL && $f_2000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_2000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:ivout:41", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_2000_[__fcnt + 2], ifmt_, CHARACTER, 0);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:ivout:41", $u_0_));
  __fcnt += 3;
  while ($f_2000_[__fcnt] != NULL && $f_2000_[__fcnt] == FMT_TEXT) {
    if ($f_2000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_2000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:ivout:41", $u_0_));
    __fcnt += 3;
  }
  bufcpy ($2_, _bufsub ((char *) $1_, (char *) line_, 1, lll_), 127);
  if ($f_2000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_2000_[__fcnt] != NULL && $f_2000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_2000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:ivout:41", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_2000_[__fcnt + 2], $2_, CHARACTER, 127);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:ivout:41", $u_0_));
  __fcnt += 3;
  while ($f_2000_[__fcnt] != NULL && $f_2000_[__fcnt] == FMT_TEXT) {
    if ($f_2000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_2000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:ivout:41", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  _l2000:;
  if ((*n_) <= 0) {
    goto _l0;
  }
  ndigit_ = (*idigit_);
  if ((*idigit_) == 0) {
    ndigit_ = 4;
  }
  if ((*idigit_) < 0) {
    ndigit_ = -(*idigit_);
    if (ndigit_ <= 4) {
      for (k1_ = 1; (10 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 10) {
        k2_ = _min ((*n_), k1_ + 9);
        $u_3_ = (*lout_);
        _fcheck ("arpack:ivout:58", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
          __fcnt += 3;
        }
        if ($f_1000_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_3_].unit, "\n");
          while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
        __fcnt += 3;
        while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
          if ($f_1000_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
          __fcnt += 3;
        }
        if ($f_1000_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_3_].unit, "\n");
          while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
        __fcnt += 3;
        while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
          if ($f_1000_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_1000_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], &ix_[i_ - 1], INTEGER, 4);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
          __fcnt += 3;
          while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
            if ($f_1000_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:ivout:58", $u_3_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_3_);
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (7 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 7) {
        k2_ = _min ((*n_), k1_ + 6);
        $u_4_ = (*lout_);
        _fcheck ("arpack:ivout:64", $u_4_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
          __fcnt += 3;
        }
        if ($f_1001_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
        __fcnt += 3;
        while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
          if ($f_1001_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
          __fcnt += 3;
        }
        if ($f_1001_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
        __fcnt += 3;
        while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
          if ($f_1001_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_1001_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_4_].unit, "\n");
            while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], &ix_[i_ - 1], INTEGER, 4);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
          __fcnt += 3;
          while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
            if ($f_1001_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_4_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:ivout:64", $u_4_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_4_);
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_5_ = (*lout_);
        _fcheck ("arpack:ivout:70", $u_5_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
          __fcnt += 3;
        }
        if ($f_1002_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
        __fcnt += 3;
        while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
          if ($f_1002_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
          __fcnt += 3;
        }
        if ($f_1002_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
        __fcnt += 3;
        while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
          if ($f_1002_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_1002_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_5_].unit, "\n");
            while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], &ix_[i_ - 1], INTEGER, 4);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
          __fcnt += 3;
          while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
            if ($f_1002_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_5_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:ivout:70", $u_5_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_5_);
      }
    }
    else {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_6_ = (*lout_);
        _fcheck ("arpack:ivout:76", $u_6_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
          __fcnt += 3;
        }
        if ($f_1003_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_6_].unit, "\n");
          while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
        __fcnt += 3;
        while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
          if ($f_1003_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
          __fcnt += 3;
        }
        if ($f_1003_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_6_].unit, "\n");
          while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
        __fcnt += 3;
        while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
          if ($f_1003_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_1003_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], &ix_[i_ - 1], INTEGER, 4);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
          __fcnt += 3;
          while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
            if ($f_1003_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:ivout:76", $u_6_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_6_);
      }
    }
  }
  else {
    if (ndigit_ <= 4) {
      for (k1_ = 1; (20 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 20) {
        k2_ = _min ((*n_), k1_ + 19);
        $u_7_ = (*lout_);
        _fcheck ("arpack:ivout:89", $u_7_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
          __fcnt += 3;
        }
        if ($f_1000_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_7_].unit, "\n");
          while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
        __fcnt += 3;
        while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
          if ($f_1000_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
          __fcnt += 3;
        }
        if ($f_1000_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_7_].unit, "\n");
          while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
        __fcnt += 3;
        while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
          if ($f_1000_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_1000_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], &ix_[i_ - 1], INTEGER, 4);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
          __fcnt += 3;
          while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
            if ($f_1000_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:ivout:89", $u_7_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_7_);
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (15 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 15) {
        k2_ = _min ((*n_), k1_ + 14);
        $u_8_ = (*lout_);
        _fcheck ("arpack:ivout:95", $u_8_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
          __fcnt += 3;
        }
        if ($f_1001_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_8_].unit, "\n");
          while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
        __fcnt += 3;
        while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
          if ($f_1001_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
          __fcnt += 3;
        }
        if ($f_1001_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_8_].unit, "\n");
          while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
        __fcnt += 3;
        while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
          if ($f_1001_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_1001_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], &ix_[i_ - 1], INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
          __fcnt += 3;
          while ($f_1001_[__fcnt] != NULL && $f_1001_[__fcnt] == FMT_TEXT) {
            if ($f_1001_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_1001_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:ivout:95", $u_8_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_8_);
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (10 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 10) {
        k2_ = _min ((*n_), k1_ + 9);
        $u_9_ = (*lout_);
        _fcheck ("arpack:ivout:101", $u_9_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
          __fcnt += 3;
        }
        if ($f_1002_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
        __fcnt += 3;
        while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
          if ($f_1002_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
          __fcnt += 3;
        }
        if ($f_1002_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
        __fcnt += 3;
        while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
          if ($f_1002_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_1002_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_9_].unit, "\n");
            while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], &ix_[i_ - 1], INTEGER, 4);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
          __fcnt += 3;
          while ($f_1002_[__fcnt] != NULL && $f_1002_[__fcnt] == FMT_TEXT) {
            if ($f_1002_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_9_, $f_1002_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:ivout:101", $u_9_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_9_);
      }
    }
    else {
      for (k1_ = 1; (7 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 7) {
        k2_ = _min ((*n_), k1_ + 6);
        $u_10_ = (*lout_);
        _fcheck ("arpack:ivout:107", $u_10_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
          __fcnt += 3;
        }
        if ($f_1003_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_10_].unit, "\n");
          while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
        __fcnt += 3;
        while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
          if ($f_1003_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
          __fcnt += 3;
        }
        if ($f_1003_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_10_].unit, "\n");
          while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
        __fcnt += 3;
        while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
          if ($f_1003_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_1003_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_10_].unit, "\n");
            while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], &ix_[i_ - 1], INTEGER, 4);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
          __fcnt += 3;
          while ($f_1003_[__fcnt] != NULL && $f_1003_[__fcnt] == FMT_TEXT) {
            if ($f_1003_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_10_, $f_1003_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:ivout:107", $u_10_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_10_);
      }
    }
  }
  $u_11_ = (*lout_);
  _fcheck ("arpack:ivout:111", $u_11_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1004_[__fcnt] != NULL && $f_1004_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_11_, $f_1004_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_11_, _ioerr_write ("arpack:ivout:111", $u_11_));
    __fcnt += 3;
  }
  _write_eol ($u_11_);
  _l1000:;
  _l1001:;
  _l1002:;
  _l1003:;
  _l1004:;
  _l0:;
  __calls[42].calls++;
  return 0;
}

int_4 _second (real_4 _p_ t_)
{
  static real_8 tt_;
  (void) _cputim (&tt_);
  (*t_) = (real_4) (tt_);
  __calls[43].calls++;
  return 0;
}

int_4 _sgetv0 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ itry_, logical_4 _p_ initv_, int_4 _p_ n_, int_4 _p_ j_, 
real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ resid_, real_4 _p_ rnorm_, int_4 _p_ ipntr_, real_4 _p_ workd_, int_4 _p_ 
ierr_)
{
  static int_4 idist_, iseed_[4], iter_, msglvl_, jj_;
  static logical_4 first_, inits_, orth_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, rnorm0_;
  int_4 _data_k_10, $0_, $3_;
  real_4 $1_, $2_, $4_, $5_;
  extern int_4 _slarnv ();
  extern int_4 _scopy ();
  extern int_4 _sgemv ();
  extern real_4 _sdot ();
  extern real_4 _snrm2 ();
#define _data_n_10 1
  static logical_4 _data_l_10[_data_n_10] = {
    TRUE
  };
  if (__calls[44].calls == 0) {
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    inits_ = _data_l_10[_data_k_10++];
  }
  if (inits_) {
    iseed_[0] = 1;
    iseed_[1] = 3;
    iseed_[2] = 5;
    iseed_[3] = 7;
    inits_ = FALSE;
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mgetv0_;
    (*ierr_) = 0;
    iter_ = 0;
    first_ = FALSE;
    orth_ = FALSE;
    if (! ((*initv_))) {
      idist_ = 2;
      (void) _slarnv (&idist_, iseed_, n_, resid_);
    }
    (void) _second (&t2_);
    if ((strcasecmp (bmat_, _dc_0) == 0)) {
      timing_.nopx_ = timing_.nopx_ + 1;
      ipntr_[0] = 1;
      ipntr_[1] = (*n_) + 1;
      (void) _scopy (n_, resid_, &_k1, workd_, &_k1);
      (*ido_) = -1;
      goto _l9000;
    }
  }
  if (first_) {
    goto _l20;
  }
  if (orth_) {
    goto _l40;
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  }
  (void) _second (&t2_);
  first_ = TRUE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _scopy (n_, &workd_[(*n_) + 1 - 1], &_k1, resid_, &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l20:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  first_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm0_ = _sdot (n_, resid_, &_k1, workd_, &_k1);
    rnorm0_ = sqrtf (_abs (rnorm0_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm0_ = _snrm2 (n_, resid_, &_k1);
  }
  (*rnorm_) = rnorm0_;
  if ((*j_) == 1) {
    goto _l50;
  }
  orth_ = TRUE;
  _l30:;
  (void) _sgemv (_dc_150, n_, ($0_ = (*j_) - 1, &$0_), ($1_ = 1.0, &$1_), v_, ldv_, workd_, &_k1, ($2_ = 0.0, &$2_), 
  &workd_[(*n_) + 1 - 1], &_k1);
  (void) _sgemv (_dc_3, n_, ($3_ = (*j_) - 1, &$3_), ($4_ = -1.0, &$4_), v_, ldv_, &workd_[(*n_) + 1 - 1], &_k1, ($5_ = 
  1.0, &$5_), resid_, &_k1);
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _scopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l40:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (*rnorm_) = _sdot (n_, resid_, &_k1, workd_, &_k1);
    (*rnorm_) = sqrtf (_abs ((*rnorm_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _snrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _svout (&debug_.logfil_, &_k1, &rnorm0_, &debug_.ndigit_, _dc_4);
    (void) _svout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_5);
  }
  if ((*rnorm_) > 0.717 * rnorm0_) {
    goto _l50;
  }
  iter_ = iter_ + 1;
  if (iter_ <= 5) {
    rnorm0_ = (*rnorm_);
    goto _l30;
  }
  else {
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = 0.0;
    }
    (*rnorm_) = 0.0;
    (*ierr_) = -1;
  }
  _l50:;
  if (msglvl_ > 0) {
    (void) _svout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_6);
  }
  if (msglvl_ > 3) {
    (void) _svout (&debug_.logfil_, n_, resid_, &debug_.ndigit_, _dc_7);
  }
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tgetv0_ = timing_.tgetv0_ + (t1_ - t0_);
  _l9000:;
  __calls[44].calls++;
  return 0;
}

int_4 _slaqrb (logical_4 _p_ wantt_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, real_4 _p_ h_, int_4 _p_ ldh_, 
real_4 _p_ wr_, real_4 _p_ wi_, real_4 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, itn_, its_, j_, k_, l_, m_, nh_, nr_;
  static real_4 cs_, h00_, h10_, h11_, h12_, h21_, h22_, h33_, h33s_, h43h34_, h44_, h44s_, ovfl_, s_, smlnum_, sn_, sum_
  , t1_, t2_, t3_, tst1_, ulp_, unfl_, v1_, v2_, v3_, v_[3], work_[1];
  int_4 $0_, $1_, $2_;
  extern real_4 _slamch ();
  extern real_4 _slanhs ();
  extern int_4 _scopy ();
  extern int_4 _slabad ();
  extern int_4 _slanv2 ();
  extern int_4 _slarfg ();
  extern int_4 _srot ();
  (*info_) = 0;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*ilo_) == (*ihi_)) {
    wr_[(*ilo_) - 1] = h_[(*ilo_) - 1 + ((*ldh_)) * (((*ilo_) - 1))];
    wi_[(*ilo_) - 1] = 0.0;
    goto _l0;
  }
  for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  z_[(*n_) - 1] = 1.0;
  nh_ = (*ihi_) - (*ilo_) + 1;
  unfl_ = _slamch (_dc_24);
  ovfl_ = 1.0 / unfl_;
  (void) _slabad (&unfl_, &ovfl_);
  ulp_ = _slamch (_dc_25);
  smlnum_ = unfl_ * (nh_ / ulp_);
  if ((*wantt_)) {
    i1_ = 1;
    i2_ = (*n_);
    for (i_ = 1; i_ <= i2_ - 2; (i_)++) {
      h_[i1_ + i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = 0.0;
    }
  }
  else {
    for (i_ = 1; i_ <= (*ihi_) - (*ilo_) - 1; (i_)++) {
      h_[(*ilo_) + i_ + 1 - 1 + ((*ldh_)) * (((*ilo_) + i_ - 1 - 1))] = 0.0;
    }
  }
  itn_ = 30 * nh_;
  i_ = (*ihi_);
  _l10:;
  l_ = (*ilo_);
  if (i_ < (*ilo_)) {
    goto _l150;
  }
  for (its_ = 0; its_ <= itn_; (its_)++) {
    for (k_ = i_; k_ >= l_ + 1; (k_)--) {
      tst1_ = _abs (h_[k_ - 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))]) + _abs (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1))]);
      if (tst1_ == 0.0) {
        tst1_ = _slanhs (_dc_34, ($0_ = i_ - l_ + 1, &$0_), &h_[l_ - 1 + ((*ldh_)) * ((l_ - 1))], ldh_, work_);
      }
      if (_abs (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))]) <= _max (ulp_ * tst1_, smlnum_)) {
        goto _l30;
      }
    }
    _l30:;
    l_ = k_;
    if (l_ > (*ilo_)) {
      h_[l_ - 1 + ((*ldh_)) * ((l_ - 1 - 1))] = 0.0;
    }
    if (l_ >= i_ - 1) {
      goto _l140;
    }
    if (! ((*wantt_))) {
      i1_ = l_;
      i2_ = i_;
    }
    if (its_ == 10 || its_ == 20) {
      s_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))]) + _abs (h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 2 - 1))]);
      h44_ = 0.75 * s_;
      h33_ = h44_;
      h43h34_ = -0.4375 * s_ * s_;
    }
    else {
      h44_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
      h33_ = h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))];
      h43h34_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] * h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))];
    }
    for (m_ = i_ - 2; m_ >= l_; (m_)--) {
      h11_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1))];
      h22_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h21_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))];
      h12_ = h_[m_ - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h44s_ = h44_ - h11_;
      h33s_ = h33_ - h11_;
      v1_ = (h33s_ * h44s_ - h43h34_) / h21_ + h12_;
      v2_ = h22_ - h11_ - h33s_ - h44s_;
      v3_ = h_[m_ + 2 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      s_ = _abs (v1_) + _abs (v2_) + _abs (v3_);
      v1_ = v1_ / s_;
      v2_ = v2_ / s_;
      v3_ = v3_ / s_;
      v_[0] = v1_;
      v_[1] = v2_;
      v_[2] = v3_;
      if (m_ == l_) {
        goto _l50;
      }
      h00_ = h_[m_ - 1 - 1 + ((*ldh_)) * ((m_ - 1 - 1))];
      h10_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1 - 1))];
      tst1_ = _abs (v1_) * (_abs (h00_) + _abs (h11_) + _abs (h22_));
      if (_abs (h10_) * (_abs (v2_) + _abs (v3_)) <= ulp_ * tst1_) {
        goto _l50;
      }
    }
    _l50:;
    for (k_ = m_; k_ <= i_ - 1; (k_)++) {
      nr_ = _min (3, i_ - k_ + 1);
      if (k_ > m_) {
        (void) _scopy (&nr_, &h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))], &_k1, v_, &_k1);
      }
      (void) _slarfg (&nr_, &v_[0], &v_[1], &_k1, &t1_);
      if (k_ > m_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = v_[0];
        h_[k_ + 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = 0.0;
        if (k_ < i_ - 1) {
          h_[k_ + 2 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = 0.0;
        }
      }
      else if (m_ > l_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = -h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))];
      }
      v2_ = v_[1];
      t2_ = t1_ * v2_;
      if (nr_ == 3) {
        v3_ = v_[2];
        t3_ = t1_ * v3_;
        for (j_ = k_; j_ <= i2_; (j_)++) {
          sum_ = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + v2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] + v3_ * h_[k_ + 2 - 1 + 
          ((*ldh_)) * ((j_ - 1))];
          h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t1_;
          h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t2_;
          h_[k_ + 2 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 2 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t3_;
        }
        for (j_ = i1_; j_ <= _min (k_ + 3, i_); (j_)++) {
          sum_ = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + v2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] + v3_ * h_[j_ - 1 + 
          ((*ldh_)) * ((k_ + 2 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_ * t1_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * t2_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 2 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 2 - 1))] - sum_ * t3_;
        }
        sum_ = z_[k_ - 1] + v2_ * z_[k_ + 1 - 1] + v3_ * z_[k_ + 2 - 1];
        z_[k_ - 1] = z_[k_ - 1] - sum_ * t1_;
        z_[k_ + 1 - 1] = z_[k_ + 1 - 1] - sum_ * t2_;
        z_[k_ + 2 - 1] = z_[k_ + 2 - 1] - sum_ * t3_;
      }
      else if (nr_ == 2) {
        for (j_ = k_; j_ <= i2_; (j_)++) {
          sum_ = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + v2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
          h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t1_;
          h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t2_;
        }
        for (j_ = i1_; j_ <= i_; (j_)++) {
          sum_ = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + v2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_ * t1_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * t2_;
        }
        sum_ = z_[k_ - 1] + v2_ * z_[k_ + 1 - 1];
        z_[k_ - 1] = z_[k_ - 1] - sum_ * t1_;
        z_[k_ + 1 - 1] = z_[k_ + 1 - 1] - sum_ * t2_;
      }
    }
  }
  (*info_) = i_;
  goto _l0;
  _l140:;
  if (l_ == i_) {
    wr_[i_ - 1] = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
    wi_[i_ - 1] = 0.0;
  }
  else if (l_ == i_ - 1) {
    (void) _slanv2 (&h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))], &h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))], &h_[i_ - 1 + 
    ((*ldh_)) * ((i_ - 1 - 1))], &h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))], &wr_[i_ - 1 - 1], &wi_[i_ - 1 - 1], &wr_[i_ - 1], 
    &wi_[i_ - 1], &cs_, &sn_);
    if ((*wantt_)) {
      if (i2_ > i_) {
        (void) _srot (($1_ = i2_ - i_, &$1_), &h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))], ldh_, &h_[i_ - 1 + ((*ldh_)) * ((i_ 
        + 1 - 1))], ldh_, &cs_, &sn_);
      }
      (void) _srot (($2_ = i_ - i1_ - 1, &$2_), &h_[i1_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))], &_k1, &h_[i1_ - 1 + ((*ldh_)) * 
      ((i_ - 1))], &_k1, &cs_, &sn_);
      sum_ = cs_ * z_[i_ - 1 - 1] + sn_ * z_[i_ - 1];
      z_[i_ - 1] = cs_ * z_[i_ - 1] - sn_ * z_[i_ - 1 - 1];
      z_[i_ - 1 - 1] = sum_;
    }
  }
  itn_ = itn_ - its_;
  i_ = l_ - 1;
  goto _l10;
  _l150:;
  _l0:;
  __calls[45].calls++;
  return 0;
}

int_4 _smout (int_4 _p_ lout_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ idigit_, char _p_ 
ifmt_)
{
  static int_4 i_, j_, ndigit_, k1_, k2_, lll_;
  static char_1 icol_[3];
  static char_127 line_;
  int_4 _data_k_11, $u_0_, __fcnt, __rc, $u_3_, _k_5, $u_6_, $u_7_, _k_9, $u_10_, $u_11_, _k_13, $u_14_, $u_15_, _k_17, 
  $u_18_, $u_19_, _k_21, $u_22_, $u_23_, _k_25, $u_26_, $u_27_, _k_29, $u_30_, $u_31_, _k_33, $u_34_, $u_35_;
  char_1 _p_ _arr_4, _p_ _arr_8, _p_ _arr_12, _p_ _arr_16, _p_ _arr_20, _p_ _arr_24, _p_ _arr_28, _p_ _arr_32;
  char_127 $1_, $2_;
  static FORMAT $f_9999_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_9998_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_151, _dc_151,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  static FORMAT $f_9997_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_152, _dc_152,
    NULL, NULL, NULL
  };
  static FORMAT $f_9996_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    FMT_TEXT, _dc_153, _dc_153,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_151, _dc_151,
    NULL, NULL, NULL
  };
  static FORMAT $f_9995_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_154, _dc_154,
    NULL, NULL, NULL
  };
  static FORMAT $f_9994_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9993_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9992_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9991_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%22e","%22.13.0e",
    FMT_REAL,"%22e","%22.13.0e",
    FMT_REAL,"%22e","%22.13.0e",
    FMT_REAL,"%22e","%22.13.0e",
    FMT_REAL,"%22e","%22.13.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9990_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
#define _data_n_11 3
  static char_1 _data_l_11[_data_n_11] = {
    _dc_2,
    _dc_8,
    _dc_9
  };
  if (__calls[46].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    bufcpy (icol_[0], _data_l_11[_data_k_11++], 1);
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    bufcpy (icol_[1], _data_l_11[_data_k_11++], 1);
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    bufcpy (icol_[2], _data_l_11[_data_k_11++], 1);
  }
  lll_ = _min ((int_4) strlen (ifmt_), 80);
  for (i_ = 1; i_ <= lll_; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_10);
  }
  for (i_ = lll_ + 1; i_ <= 80; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_11);
  }
  $u_0_ = (*lout_);
  _fcheck ("arpack:smout:50", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:smout:50", $u_0_));
    __fcnt += 3;
  }
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:smout:50", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], ifmt_, CHARACTER, 0);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:smout:50", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:smout:50", $u_0_));
    __fcnt += 3;
  }
  bufcpy ($2_, _bufsub ((char *) $1_, (char *) line_, 1, lll_), 127);
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:smout:50", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], $2_, CHARACTER, 127);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:smout:50", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:smout:50", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  _l9999:;
  if ((*m_) <= 0 || (*n_) <= 0 || (*lda_) <= 0) {
    goto _l0;
  }
  ndigit_ = (*idigit_);
  if ((*idigit_) == 0) {
    ndigit_ = 4;
  }
  if ((*idigit_) < 0) {
    ndigit_ = -(*idigit_);
    if (ndigit_ <= 4) {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_3_ = (*lout_);
        _fcheck ("arpack:smout:68", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:smout:68", $u_3_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_4 = (char_1 _p_) icol_, _k_5 = 0; _k_5 < 3; _arr_4++, _k_5++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_3_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_3_, _ioerr_write ("arpack:smout:68", $u_3_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], _arr_4, CHARACTER, 1);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:smout:68", $u_3_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:smout:68", $u_3_));
              __fcnt += 3;
            }
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:smout:68", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:smout:68", $u_3_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:smout:68", $u_3_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_3_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_6_ = (*lout_);
          _fcheck ("arpack:smout:70", $u_6_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:smout:70", $u_6_));
            __fcnt += 3;
          }
          if ($f_9994_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:smout:70", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:smout:70", $u_6_));
          __fcnt += 3;
          while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
            if ($f_9994_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:smout:70", $u_6_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9994_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_6_].unit, "\n");
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:smout:70", $u_6_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 4);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:smout:70", $u_6_));
            __fcnt += 3;
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:smout:70", $u_6_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_6_);
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (4 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 4) {
        k2_ = _min ((*n_), k1_ + 3);
        $u_7_ = (*lout_);
        _fcheck ("arpack:smout:77", $u_7_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:smout:77", $u_7_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_8 = (char_1 _p_) icol_, _k_9 = 0; _k_9 < 3; _arr_8++, _k_9++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_7_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:smout:77", $u_7_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], _arr_8, CHARACTER, 1);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:smout:77", $u_7_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:smout:77", $u_7_));
              __fcnt += 3;
            }
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:smout:77", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:smout:77", $u_7_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:smout:77", $u_7_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_7_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_10_ = (*lout_);
          _fcheck ("arpack:smout:79", $u_10_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:smout:79", $u_10_));
            __fcnt += 3;
          }
          if ($f_9993_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_10_].unit, "\n");
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:smout:79", $u_10_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:smout:79", $u_10_));
          __fcnt += 3;
          while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
            if ($f_9993_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:smout:79", $u_10_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9993_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_10_].unit, "\n");
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_10_, _ioerr_write ("arpack:smout:79", $u_10_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 4);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:smout:79", $u_10_));
            __fcnt += 3;
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_10_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:smout:79", $u_10_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_10_);
        }
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_11_ = (*lout_);
        _fcheck ("arpack:smout:86", $u_11_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_11_, _ioerr_write ("arpack:smout:86", $u_11_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_12 = (char_1 _p_) icol_, _k_13 = 0; _k_13 < 3; _arr_12++, _k_13++) {
            if ($f_9996_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_11_].unit, "\n");
              while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:smout:86", $u_11_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], _arr_12, CHARACTER, 1);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:smout:86", $u_11_));
            __fcnt += 3;
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              if ($f_9996_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:smout:86", $u_11_));
              __fcnt += 3;
            }
          }
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_11_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:smout:86", $u_11_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_11_, _ioerr_write ("arpack:smout:86", $u_11_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_11_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:smout:86", $u_11_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_11_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_14_ = (*lout_);
          _fcheck ("arpack:smout:88", $u_14_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:smout:88", $u_14_));
            __fcnt += 3;
          }
          if ($f_9992_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_14_].unit, "\n");
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_14_, _ioerr_write ("arpack:smout:88", $u_14_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_14_, _ioerr_write ("arpack:smout:88", $u_14_));
          __fcnt += 3;
          while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
            if ($f_9992_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:smout:88", $u_14_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9992_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_14_].unit, "\n");
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_14_, _ioerr_write ("arpack:smout:88", $u_14_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 4);
            _write_err (__rc, $u_14_, _ioerr_write ("arpack:smout:88", $u_14_));
            __fcnt += 3;
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_14_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_14_, _ioerr_write ("arpack:smout:88", $u_14_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_14_);
        }
      }
    }
    else {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_15_ = (*lout_);
        _fcheck ("arpack:smout:95", $u_15_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_15_, _ioerr_write ("arpack:smout:95", $u_15_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_16 = (char_1 _p_) icol_, _k_17 = 0; _k_17 < 3; _arr_16++, _k_17++) {
            if ($f_9995_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_15_].unit, "\n");
              while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_15_, _ioerr_write ("arpack:smout:95", $u_15_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], _arr_16, CHARACTER, 1);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:smout:95", $u_15_));
            __fcnt += 3;
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              if ($f_9995_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_15_, _ioerr_write ("arpack:smout:95", $u_15_));
              __fcnt += 3;
            }
          }
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_15_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_15_, _ioerr_write ("arpack:smout:95", $u_15_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_15_, _ioerr_write ("arpack:smout:95", $u_15_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_15_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_15_, _ioerr_write ("arpack:smout:95", $u_15_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_15_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_18_ = (*lout_);
          _fcheck ("arpack:smout:97", $u_18_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:smout:97", $u_18_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_18_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:smout:97", $u_18_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:smout:97", $u_18_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:smout:97", $u_18_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9991_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_18_].unit, "\n");
              while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_18_, _ioerr_write ("arpack:smout:97", $u_18_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 4);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:smout:97", $u_18_));
            __fcnt += 3;
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              if ($f_9991_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_18_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:smout:97", $u_18_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_18_);
        }
      }
    }
  }
  else {
    if (ndigit_ <= 4) {
      for (k1_ = 1; (10 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 10) {
        k2_ = _min ((*n_), k1_ + 9);
        $u_19_ = (*lout_);
        _fcheck ("arpack:smout:110", $u_19_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_19_, _ioerr_write ("arpack:smout:110", $u_19_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_20 = (char_1 _p_) icol_, _k_21 = 0; _k_21 < 3; _arr_20++, _k_21++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_19_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_19_, _ioerr_write ("arpack:smout:110", $u_19_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], _arr_20, CHARACTER, 1);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:smout:110", $u_19_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("arpack:smout:110", $u_19_));
              __fcnt += 3;
            }
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_19_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("arpack:smout:110", $u_19_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_19_, _ioerr_write ("arpack:smout:110", $u_19_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_19_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_19_, _ioerr_write ("arpack:smout:110", $u_19_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_19_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_22_ = (*lout_);
          _fcheck ("arpack:smout:112", $u_22_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:smout:112", $u_22_));
            __fcnt += 3;
          }
          if ($f_9994_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_22_].unit, "\n");
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("arpack:smout:112", $u_22_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_22_, _ioerr_write ("arpack:smout:112", $u_22_));
          __fcnt += 3;
          while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
            if ($f_9994_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:smout:112", $u_22_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9994_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_22_].unit, "\n");
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_22_, _ioerr_write ("arpack:smout:112", $u_22_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 4);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:smout:112", $u_22_));
            __fcnt += 3;
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_22_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("arpack:smout:112", $u_22_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_22_);
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (8 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 8) {
        k2_ = _min ((*n_), k1_ + 7);
        $u_23_ = (*lout_);
        _fcheck ("arpack:smout:119", $u_23_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_23_, _ioerr_write ("arpack:smout:119", $u_23_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_24 = (char_1 _p_) icol_, _k_25 = 0; _k_25 < 3; _arr_24++, _k_25++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_23_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_23_, _ioerr_write ("arpack:smout:119", $u_23_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], _arr_24, CHARACTER, 1);
            _write_err (__rc, $u_23_, _ioerr_write ("arpack:smout:119", $u_23_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_23_, _ioerr_write ("arpack:smout:119", $u_23_));
              __fcnt += 3;
            }
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_23_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_23_, _ioerr_write ("arpack:smout:119", $u_23_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_23_, _ioerr_write ("arpack:smout:119", $u_23_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_23_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_23_, _ioerr_write ("arpack:smout:119", $u_23_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_23_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_26_ = (*lout_);
          _fcheck ("arpack:smout:121", $u_26_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_26_, _ioerr_write ("arpack:smout:121", $u_26_));
            __fcnt += 3;
          }
          if ($f_9993_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_26_].unit, "\n");
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:smout:121", $u_26_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_26_, _ioerr_write ("arpack:smout:121", $u_26_));
          __fcnt += 3;
          while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
            if ($f_9993_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_26_, _ioerr_write ("arpack:smout:121", $u_26_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9993_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_26_].unit, "\n");
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_26_, _ioerr_write ("arpack:smout:121", $u_26_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 4);
            _write_err (__rc, $u_26_, _ioerr_write ("arpack:smout:121", $u_26_));
            __fcnt += 3;
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_26_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:smout:121", $u_26_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_26_);
        }
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (6 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 6) {
        k2_ = _min ((*n_), k1_ + 5);
        $u_27_ = (*lout_);
        _fcheck ("arpack:smout:128", $u_27_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_27_, _ioerr_write ("arpack:smout:128", $u_27_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_28 = (char_1 _p_) icol_, _k_29 = 0; _k_29 < 3; _arr_28++, _k_29++) {
            if ($f_9996_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_27_].unit, "\n");
              while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_27_, _ioerr_write ("arpack:smout:128", $u_27_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], _arr_28, CHARACTER, 1);
            _write_err (__rc, $u_27_, _ioerr_write ("arpack:smout:128", $u_27_));
            __fcnt += 3;
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              if ($f_9996_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:smout:128", $u_27_));
              __fcnt += 3;
            }
          }
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_27_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:smout:128", $u_27_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_27_, _ioerr_write ("arpack:smout:128", $u_27_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_27_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_27_, _ioerr_write ("arpack:smout:128", $u_27_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_27_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_30_ = (*lout_);
          _fcheck ("arpack:smout:130", $u_30_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_30_, _ioerr_write ("arpack:smout:130", $u_30_));
            __fcnt += 3;
          }
          if ($f_9992_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_30_].unit, "\n");
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_30_, _ioerr_write ("arpack:smout:130", $u_30_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_30_, _ioerr_write ("arpack:smout:130", $u_30_));
          __fcnt += 3;
          while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
            if ($f_9992_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_30_, _ioerr_write ("arpack:smout:130", $u_30_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9992_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_30_].unit, "\n");
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_30_, _ioerr_write ("arpack:smout:130", $u_30_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 4);
            _write_err (__rc, $u_30_, _ioerr_write ("arpack:smout:130", $u_30_));
            __fcnt += 3;
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_30_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_30_, _ioerr_write ("arpack:smout:130", $u_30_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_30_);
        }
      }
    }
    else {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_31_ = (*lout_);
        _fcheck ("arpack:smout:137", $u_31_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_31_, _ioerr_write ("arpack:smout:137", $u_31_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_32 = (char_1 _p_) icol_, _k_33 = 0; _k_33 < 3; _arr_32++, _k_33++) {
            if ($f_9995_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_31_].unit, "\n");
              while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_31_, _ioerr_write ("arpack:smout:137", $u_31_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], _arr_32, CHARACTER, 1);
            _write_err (__rc, $u_31_, _ioerr_write ("arpack:smout:137", $u_31_));
            __fcnt += 3;
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              if ($f_9995_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_31_, _ioerr_write ("arpack:smout:137", $u_31_));
              __fcnt += 3;
            }
          }
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_31_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_31_, _ioerr_write ("arpack:smout:137", $u_31_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_31_, _ioerr_write ("arpack:smout:137", $u_31_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_31_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_31_, _ioerr_write ("arpack:smout:137", $u_31_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_31_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_34_ = (*lout_);
          _fcheck ("arpack:smout:139", $u_34_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("arpack:smout:139", $u_34_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_34_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:smout:139", $u_34_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_34_, _ioerr_write ("arpack:smout:139", $u_34_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("arpack:smout:139", $u_34_));
            __fcnt += 3;
          }
          for (j_ = k1_; j_ <= k2_; j_++) {
            if ($f_9991_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_34_].unit, "\n");
              while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_34_, _ioerr_write ("arpack:smout:139", $u_34_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], REAL, 4);
            _write_err (__rc, $u_34_, _ioerr_write ("arpack:smout:139", $u_34_));
            __fcnt += 3;
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              if ($f_9991_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_34_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:smout:139", $u_34_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_34_);
        }
      }
    }
  }
  $u_35_ = (*lout_);
  _fcheck ("arpack:smout:144", $u_35_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9990_[__fcnt] != NULL && $f_9990_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_35_, $f_9990_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_35_, _ioerr_write ("arpack:smout:144", $u_35_));
    __fcnt += 3;
  }
  _write_eol ($u_35_);
  _l9998:;
  _l9997:;
  _l9996:;
  _l9995:;
  _l9994:;
  _l9993:;
  _l9992:;
  _l9991:;
  _l9990:;
  _l0:;
  __calls[46].calls++;
  return 0;
}

int_4 _snaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ nb_, real_4 _p_ 
resid_, real_4 _p_ rnorm_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, real_4 _p_ 
workd_, int_4 _p_ info_)
{
  static int_4 ierr_, i_, infol_, ipj_, irj_, ivj_, iter_, itry_, j_, msglvl_, jj_;
  static logical_4 first_, orth1_, orth2_, rstart_, step3_, step4_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, betaj_, ovfl_, temp1_, rnorm1_, smlnum_, tst1_, ulp_, unfl_, wnorm_, 
  xtemp_[2];
  int_4 _data_k_12, $7_, $13_, $14_, $15_, $16_;
  logical_4 $0_;
  real_4 $1_, $2_, $3_, $4_, $5_, $6_, $8_, $9_, $10_, $11_, $12_;
  extern int_4 _saxpy ();
  extern int_4 _scopy ();
  extern int_4 _sscal ();
  extern int_4 _sgemv ();
  extern int_4 _slabad ();
  extern real_4 _sdot ();
  extern real_4 _snrm2 ();
  extern real_4 _slanhs ();
  extern real_4 _slamch ();
#define _data_n_12 1
  static logical_4 _data_l_12[_data_n_12] = {
    TRUE
  };
  if (__calls[47].calls == 0) {
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    first_ = _data_l_12[_data_k_12++];
  }
  if (first_) {
    unfl_ = _slamch (_dc_24);
    ovfl_ = 1.0 / unfl_;
    (void) _slabad (&unfl_, &ovfl_);
    ulp_ = _slamch (_dc_25);
    smlnum_ = unfl_ * ((*n_) / ulp_);
    first_ = FALSE;
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mnaitr_;
    (*info_) = 0;
    step3_ = FALSE;
    step4_ = FALSE;
    rstart_ = FALSE;
    orth1_ = FALSE;
    orth2_ = FALSE;
    j_ = (*k_) + 1;
    ipj_ = 1;
    irj_ = ipj_ + (*n_);
    ivj_ = irj_ + (*n_);
  }
  if (step3_) {
    goto _l50;
  }
  if (step4_) {
    goto _l60;
  }
  if (orth1_) {
    goto _l70;
  }
  if (orth2_) {
    goto _l90;
  }
  if (rstart_) {
    goto _l30;
  }
  _l1000:;
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_26);
    (void) _svout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_27);
  }
  betaj_ = (*rnorm_);
  if ((*rnorm_) > 0.0) {
    goto _l40;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_28);
  }
  betaj_ = 0.0;
  timing_.nrstrt_ = timing_.nrstrt_ + 1;
  itry_ = 1;
  _l20:;
  rstart_ = TRUE;
  (*ido_) = 0;
  _l30:;
  (void) _sgetv0 (ido_, bmat_, &itry_, ($0_ = FALSE, &$0_), n_, &j_, v_, ldv_, resid_, rnorm_, ipntr_, workd_, &ierr_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if (ierr_ < 0) {
    itry_ = itry_ + 1;
    if (itry_ <= 3) {
      goto _l20;
    }
    (*info_) = j_ - 1;
    (void) _second (&t1_);
    timing_.tnaitr_ = timing_.tnaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    goto _l9000;
  }
  _l40:;
  (void) _scopy (n_, resid_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
  if ((*rnorm_) >= unfl_) {
    temp1_ = 1.0 / (*rnorm_);
    (void) _sscal (n_, &temp1_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
    (void) _sscal (n_, &temp1_, &workd_[ipj_ - 1], &_k1);
  }
  else {
    (void) _slascl (_dc_29, &i_, &i_, rnorm_, ($1_ = 1.0, &$1_), n_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], n_, &infol_);
    (void) _slascl (_dc_29, &i_, &i_, rnorm_, ($2_ = 1.0, &$2_), n_, &_k1, &workd_[ipj_ - 1], n_, &infol_);
  }
  step3_ = TRUE;
  timing_.nopx_ = timing_.nopx_ + 1;
  (void) _second (&t2_);
  (void) _scopy (n_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1, &workd_[ivj_ - 1], &_k1);
  ipntr_[0] = ivj_;
  ipntr_[1] = irj_;
  ipntr_[2] = ipj_;
  (*ido_) = 1;
  goto _l9000;
  _l50:;
  (void) _second (&t3_);
  timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  step3_ = FALSE;
  (void) _scopy (n_, &workd_[irj_ - 1], &_k1, resid_, &_k1);
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    step4_ = TRUE;
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l60:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  step4_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    wnorm_ = _sdot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    wnorm_ = sqrtf (_abs (wnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    wnorm_ = _snrm2 (n_, resid_, &_k1);
  }
  (void) _sgemv (_dc_150, n_, &j_, ($3_ = 1.0, &$3_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($4_ = 0.0, &$4_), &h_[0 + 
  ((*ldh_)) * ((j_ - 1))], &_k1);
  (void) _sgemv (_dc_3, n_, &j_, ($5_ = -1.0, &$5_), v_, ldv_, &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1, ($6_ = 1.0, &$6_), 
  resid_, &_k1);
  if (j_ > 1) {
    h_[j_ - 1 + ((*ldh_)) * ((j_ - 1 - 1))] = betaj_;
  }
  (void) _second (&t4_);
  orth1_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _scopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l70:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  orth1_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (*rnorm_) = _sdot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    (*rnorm_) = sqrtf (_abs ((*rnorm_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _snrm2 (n_, resid_, &_k1);
  }
  if ((*rnorm_) > 0.717 * wnorm_) {
    goto _l100;
  }
  iter_ = 0;
  timing_.nrorth_ = timing_.nrorth_ + 1;
  _l80:;
  if (msglvl_ > 2) {
    xtemp_[0] = wnorm_;
    xtemp_[1] = (*rnorm_);
    (void) _svout (&debug_.logfil_, ($7_ = 2, &$7_), xtemp_, &debug_.ndigit_, _dc_155);
    (void) _svout (&debug_.logfil_, &j_, &h_[0 + ((*ldh_)) * ((j_ - 1))], &debug_.ndigit_, _dc_31);
  }
  (void) _sgemv (_dc_150, n_, &j_, ($8_ = 1.0, &$8_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($9_ = 0.0, &$9_), &workd_[irj_ 
  - 1], &_k1);
  (void) _sgemv (_dc_3, n_, &j_, ($10_ = -1.0, &$10_), v_, ldv_, &workd_[irj_ - 1], &_k1, ($11_ = 1.0, &$11_), resid_, 
  &_k1);
  (void) _saxpy (&j_, ($12_ = 1.0, &$12_), &workd_[irj_ - 1], &_k1, &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1);
  orth2_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _scopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l90:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm1_ = _sdot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    rnorm1_ = sqrtf (_abs (rnorm1_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm1_ = _snrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 0 && iter_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_32);
    if (msglvl_ > 2) {
      xtemp_[0] = (*rnorm_);
      xtemp_[1] = rnorm1_;
      (void) _svout (&debug_.logfil_, ($13_ = 2, &$13_), xtemp_, &debug_.ndigit_, _dc_33);
    }
  }
  if (rnorm1_ > 0.717 * (*rnorm_)) {
    (*rnorm_) = rnorm1_;
  }
  else {
    timing_.nitref_ = timing_.nitref_ + 1;
    (*rnorm_) = rnorm1_;
    iter_ = iter_ + 1;
    if (iter_ <= 1) {
      goto _l80;
    }
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = 0.0;
    }
    (*rnorm_) = 0.0;
  }
  _l100:;
  rstart_ = FALSE;
  orth2_ = FALSE;
  (void) _second (&t5_);
  timing_.titref_ = timing_.titref_ + (t5_ - t4_);
  j_ = j_ + 1;
  if (j_ > (*k_) + (*np_)) {
    (void) _second (&t1_);
    timing_.tnaitr_ = timing_.tnaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    for (i_ = _max (1, (*k_)); i_ <= (*k_) + (*np_) - 1; (i_)++) {
      tst1_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]);
      if (tst1_ == 0.0) {
        tst1_ = _slanhs (_dc_34, ($14_ = (*k_) + (*np_), &$14_), h_, ldh_, &workd_[(*n_) + 1 - 1]);
      }
      if (_abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))]) <= _max (ulp_ * tst1_, smlnum_)) {
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = 0.0;
      }
    }
    if (msglvl_ > 2) {
      (void) _smout (&debug_.logfil_, ($15_ = (*k_) + (*np_), &$15_), ($16_ = (*k_) + (*np_), &$16_), h_, ldh_, 
      &debug_.ndigit_, _dc_35);
    }
    goto _l9000;
  }
  goto _l1000;
  _l9000:;
  __calls[47].calls++;
  return 0;
}

int_4 _snapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, real_4 _p_ shiftr_, real_4 _p_ shifti_, real_4 _p_ v_, 
int_4 _p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ resid_, real_4 _p_ q_, int_4 _p_ ldq_, real_4 _p_ workl_, 
real_4 _p_ workd_)
{
  static int_4 i_, iend_, ir_, istart_, j_, jj_, kplusp_, msglvl_, nr_;
  static logical_4 cconj_, first_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, c_, f_, g_, h11_, h12_, h21_, h22_, h32_, ovfl_, r_, s_, sigmai_, sigmar_, 
  smlnum_, ulp_, unfl_, u_[3], t_, tau_, tst1_;
  int_4 _data_k_13, $2_, $3_, $4_, $6_, $8_, $12_;
  real_4 $0_, $1_, $5_, $7_, $9_, $10_, $11_, $13_, $14_;
  extern int_4 _saxpy ();
  extern int_4 _scopy ();
  extern int_4 _sscal ();
  extern int_4 _slacpy ();
  extern int_4 _slarfg ();
  extern int_4 _slarf ();
  extern int_4 _slaset ();
  extern int_4 _slabad ();
  extern int_4 _slartg ();
  extern real_4 _slamch ();
  extern real_4 _slanhs ();
  extern real_4 _slapy2 ();
#define _data_n_13 1
  static logical_4 _data_l_13[_data_n_13] = {
    TRUE
  };
  if (__calls[48].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    first_ = _data_l_13[_data_k_13++];
  }
  if (first_) {
    unfl_ = _slamch (_dc_24);
    ovfl_ = 1.0 / unfl_;
    (void) _slabad (&unfl_, &ovfl_);
    ulp_ = _slamch (_dc_25);
    smlnum_ = unfl_ * ((*n_) / ulp_);
    first_ = FALSE;
  }
  (void) _second (&t0_);
  msglvl_ = debug_.mnapps_;
  kplusp_ = (*kev_) + (*np_);
  (void) _slaset (_dc_36, &kplusp_, &kplusp_, ($0_ = 0.0, &$0_), ($1_ = 1.0, &$1_), q_, ldq_);
  if ((*np_) == 0) {
    goto _l9000;
  }
  cconj_ = FALSE;
  for (jj_ = 1; jj_ <= (*np_); (jj_)++) {
    sigmar_ = shiftr_[jj_ - 1];
    sigmai_ = shifti_[jj_ - 1];
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_37);
      (void) _svout (&debug_.logfil_, &_k1, &sigmar_, &debug_.ndigit_, _dc_156);
      (void) _svout (&debug_.logfil_, &_k1, &sigmai_, &debug_.ndigit_, _dc_157);
    }
    if (cconj_) {
      cconj_ = FALSE;
      goto _l110;
    }
    else if (jj_ < (*np_) && _abs (sigmai_) > 0.0) {
      cconj_ = TRUE;
    }
    else if (jj_ == (*np_) && _abs (sigmai_) > 0.0) {
      (*kev_) = (*kev_) + 1;
      goto _l110;
    }
    istart_ = 1;
    _l20:;
    for (i_ = istart_; i_ <= kplusp_ - 1; (i_)++) {
      tst1_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]);
      if (tst1_ == 0.0) {
        tst1_ = _slanhs (_dc_34, ($2_ = kplusp_ - jj_ + 1, &$2_), h_, ldh_, workl_);
      }
      if (_abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))]) <= _max (ulp_ * tst1_, smlnum_)) {
        if (msglvl_ > 0) {
          (void) _ivout (&debug_.logfil_, &_k1, &i_, &debug_.ndigit_, _dc_39);
          (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_40);
          (void) _svout (&debug_.logfil_, &_k1, &h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))], &debug_.ndigit_, _dc_41);
        }
        iend_ = i_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = 0.0;
        goto _l40;
      }
    }
    iend_ = kplusp_;
    _l40:;
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &istart_, &debug_.ndigit_, _dc_42);
      (void) _ivout (&debug_.logfil_, &_k1, &iend_, &debug_.ndigit_, _dc_43);
    }
    if (istart_ == iend_) {
      goto _l100;
    }
    if (istart_ + 1 == iend_ && _abs (sigmai_) > 0.0) {
      goto _l100;
    }
    h11_ = h_[istart_ - 1 + ((*ldh_)) * ((istart_ - 1))];
    h21_ = h_[istart_ + 1 - 1 + ((*ldh_)) * ((istart_ - 1))];
    if (_abs (sigmai_) <= 0.0) {
      f_ = h11_ - sigmar_;
      g_ = h21_;
      for (i_ = istart_; i_ <= iend_ - 1; (i_)++) {
        (void) _slartg (&f_, &g_, &c_, &s_, &r_);
        if (i_ > istart_) {
          if (r_ < 0.0) {
            r_ = -r_;
            c_ = -c_;
            s_ = -s_;
          }
          h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = r_;
          h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = 0.0;
        }
        for (j_ = i_; j_ <= kplusp_; (j_)++) {
          t_ = c_ * h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] + s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
          h_[i_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = -s_ * h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] + c_ * h_[i_ + 1 - 1 + ((*ldh_)) * 
          ((j_ - 1))];
          h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] = t_;
        }
        for (j_ = 1; j_ <= _min (i_ + 2, iend_); (j_)++) {
          t_ = c_ * h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] + s_ * h_[j_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))] = -s_ * h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] + c_ * h_[j_ - 1 + ((*ldh_)) * ((i_ 
          + 1 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] = t_;
        }
        for (j_ = 1; j_ <= _min (i_ + jj_, kplusp_); (j_)++) {
          t_ = c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))];
          q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))] = -s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ 
          + 1 - 1))];
          q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] = t_;
        }
        if (i_ < iend_ - 1) {
          f_ = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))];
          g_ = h_[i_ + 2 - 1 + ((*ldh_)) * ((i_ - 1))];
        }
      }
    }
    else {
      h12_ = h_[istart_ - 1 + ((*ldh_)) * ((istart_ + 1 - 1))];
      h22_ = h_[istart_ + 1 - 1 + ((*ldh_)) * ((istart_ + 1 - 1))];
      h32_ = h_[istart_ + 2 - 1 + ((*ldh_)) * ((istart_ + 1 - 1))];
      s_ = 2.0 * sigmar_;
      t_ = _slapy2 (&sigmar_, &sigmai_);
      u_[0] = (h11_ * (h11_ - s_) + t_ * t_) / h21_ + h12_;
      u_[1] = h11_ + h22_ - s_;
      u_[2] = h32_;
      for (i_ = istart_; i_ <= iend_ - 1; (i_)++) {
        nr_ = _min (3, iend_ - i_ + 1);
        (void) _slarfg (&nr_, &u_[0], &u_[1], &_k1, &tau_);
        if (i_ > istart_) {
          h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = u_[0];
          h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = 0.0;
          if (i_ < iend_ - 1) {
            h_[i_ + 2 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = 0.0;
          }
        }
        u_[0] = 1.0;
        (void) _slarf (_dc_158, &nr_, ($3_ = kplusp_ - i_ + 1, &$3_), u_, &_k1, &tau_, &h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))], 
        ldh_, workl_);
        ir_ = _min (i_ + 3, iend_);
        (void) _slarf (_dc_112, &ir_, &nr_, u_, &_k1, &tau_, &h_[0 + ((*ldh_)) * ((i_ - 1))], ldh_, workl_);
        (void) _slarf (_dc_112, &kplusp_, &nr_, u_, &_k1, &tau_, &q_[0 + ((*ldq_)) * ((i_ - 1))], ldq_, workl_);
        if (i_ < iend_ - 1) {
          u_[0] = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))];
          u_[1] = h_[i_ + 2 - 1 + ((*ldh_)) * ((i_ - 1))];
          if (i_ < iend_ - 2) {
            u_[2] = h_[i_ + 3 - 1 + ((*ldh_)) * ((i_ - 1))];
          }
        }
      }
    }
    _l100:;
    istart_ = iend_ + 1;
    if (iend_ < kplusp_) {
      goto _l20;
    }
    _l110:;
  }
  for (j_ = 1; j_ <= (*kev_); (j_)++) {
    if (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] < 0.0) {
      (void) _sscal (($4_ = kplusp_ - j_ + 1, &$4_), ($5_ = -1.0, &$5_), &h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))], ldh_);
      (void) _sscal (($6_ = _min (j_ + 2, kplusp_), &$6_), ($7_ = -1.0, &$7_), &h_[0 + ((*ldh_)) * ((j_ + 1 - 1))], &_k1);
      (void) _sscal (($8_ = _min (j_ + (*np_) + 1, kplusp_), &$8_), ($9_ = -1.0, &$9_), &q_[0 + ((*ldq_)) * ((j_ + 1 - 1))], 
      &_k1);
    }
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    tst1_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]);
    if (tst1_ == 0.0) {
      tst1_ = _slanhs (_dc_34, kev_, h_, ldh_, workl_);
    }
    if (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] <= _max (ulp_ * tst1_, smlnum_)) {
      h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = 0.0;
    }
  }
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))] > 0.0) {
    (void) _sgemv (_dc_3, n_, &kplusp_, ($10_ = 1.0, &$10_), v_, ldv_, &q_[0 + ((*ldq_)) * (((*kev_) + 1 - 1))], &_k1, 
    ($11_ = 0.0, &$11_), &workd_[(*n_) + 1 - 1], &_k1);
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    (void) _sgemv (_dc_3, n_, ($12_ = kplusp_ - i_ + 1, &$12_), ($13_ = 1.0, &$13_), v_, ldv_, &q_[0 + ((*ldq_)) * 
    (((*kev_) - i_ + 1 - 1))], &_k1, ($14_ = 0.0, &$14_), workd_, &_k1);
    (void) _scopy (n_, workd_, &_k1, &v_[0 + ((*ldv_)) * ((kplusp_ - i_ + 1 - 1))], &_k1);
  }
  (void) _slacpy (_dc_44, n_, kev_, &v_[0 + ((*ldv_)) * ((kplusp_ - (*kev_) + 1 - 1))], ldv_, v_, ldv_);
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))] > 0.0) {
    (void) _scopy (n_, &workd_[(*n_) + 1 - 1], &_k1, &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1);
  }
  (void) _sscal (n_, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], resid_, &_k1);
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))] > 0.0) {
    (void) _saxpy (n_, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))], &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1, 
    resid_, &_k1);
  }
  if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &_k1, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_45);
    (void) _svout (&debug_.logfil_, &_k1, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_46);
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_47);
    if (msglvl_ > 2) {
      (void) _smout (&debug_.logfil_, kev_, kev_, h_, ldh_, &debug_.ndigit_, _dc_48);
    }
  }
  _l9000:;
  (void) _second (&t1_);
  timing_.tnapps_ = timing_.tnapps_ + (t1_ - t0_);
  __calls[48].calls++;
  return 0;
}

int_4 _snaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, real_4 _p_ 
tol_, real_4 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, real_4 _p_ v_, int_4 
_p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ ritzr_, real_4 _p_ ritzi_, real_4 _p_ bounds_, real_4 _p_ q_, int_4 
_p_ ldq_, real_4 _p_ workl_, int_4 _p_ ipntr_, real_4 _p_ workd_, int_4 _p_ info_)
{
  static int_4 ierr_, iter_, j_, kplusp_, msglvl_, nconv_, nevbef_, nev0_, np0_, nptemp_, numcnv_, kp_[4];
  static logical_4 cnorm_, getv0_, initv_, update_, ushift_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, rnorm_, temp_, eps23_;
  static char_3 wprime_;
  int_4 $0_, $5_;
  logical_4 $1_, $2_, $3_, $4_;
  extern int_4 _scopy ();
  extern real_4 _sdot ();
  extern real_4 _snrm2 ();
  extern real_4 _slapy2 ();
  extern real_4 _slamch ();
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mnaup2_;
    eps23_ = _slamch (_dc_49);
    eps23_ = powl (eps23_, 6.6666667e-1);
    nev0_ = (*nev_);
    np0_ = (*np_);
    kplusp_ = (*nev_) + (*np_);
    nconv_ = 0;
    iter_ = 0;
    getv0_ = TRUE;
    update_ = FALSE;
    ushift_ = FALSE;
    cnorm_ = FALSE;
    if ((*info_) != 0) {
      initv_ = TRUE;
      (*info_) = 0;
    }
    else {
      initv_ = FALSE;
    }
  }
  if (getv0_) {
    (void) _sgetv0 (ido_, bmat_, &_k1, &initv_, n_, &_k1, v_, ldv_, resid_, &rnorm_, ipntr_, workd_, info_);
    if ((*ido_) != 99) {
      goto _l9000;
    }
    if (rnorm_ == 0.0) {
      (*info_) = -9;
      goto _l1100;
    }
    getv0_ = FALSE;
    (*ido_) = 0;
  }
  if (update_) {
    goto _l20;
  }
  if (ushift_) {
    goto _l50;
  }
  if (cnorm_) {
    goto _l100;
  }
  (void) _snaitr (ido_, bmat_, n_, &_k0, nev_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  _l1000:;
  iter_ = iter_ + 1;
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &iter_, &debug_.ndigit_, _dc_50);
  }
  (*np_) = kplusp_ - (*nev_);
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, nev_, &debug_.ndigit_, _dc_51);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_52);
  }
  (*ido_) = 0;
  _l20:;
  update_ = TRUE;
  (void) _snaitr (ido_, bmat_, n_, nev_, np_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  update_ = FALSE;
  if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_53);
  }
  (void) _sneigh (&rnorm_, &kplusp_, h_, ldh_, ritzr_, ritzi_, bounds_, q_, ldq_, workl_, &ierr_);
  if (ierr_ != 0) {
    (*info_) = -8;
    goto _l1200;
  }
  (void) _scopy (&kplusp_, ritzr_, &_k1, &workl_[(kplusp_ * kplusp_) + 1 - 1], &_k1);
  (void) _scopy (&kplusp_, ritzi_, &_k1, &workl_[(kplusp_ * kplusp_) + kplusp_ + 1 - 1], &_k1);
  (void) _scopy (&kplusp_, bounds_, &_k1, &workl_[(kplusp_ * kplusp_) + 2 * kplusp_ + 1 - 1], &_k1);
  (*nev_) = nev0_;
  (*np_) = np0_;
  numcnv_ = (*nev_);
  (void) _sngets (ishift_, which_, nev_, np_, ritzr_, ritzi_, bounds_, workl_, &workl_[(*np_) + 1 - 1]);
  if ((*nev_) == nev0_ + 1) {
    numcnv_ = nev0_ + 1;
  }
  (void) _scopy (nev_, &bounds_[(*np_) + 1 - 1], &_k1, &workl_[2 * (*np_) + 1 - 1], &_k1);
  (void) _snconv (nev_, &ritzr_[(*np_) + 1 - 1], &ritzi_[(*np_) + 1 - 1], &workl_[2 * (*np_) + 1 - 1], tol_, &nconv_);
  if (msglvl_ > 2) {
    kp_[0] = (*nev_);
    kp_[1] = (*np_);
    kp_[2] = numcnv_;
    kp_[3] = nconv_;
    (void) _ivout (&debug_.logfil_, ($0_ = 4, &$0_), kp_, &debug_.ndigit_, _dc_159);
    (void) _svout (&debug_.logfil_, &kplusp_, ritzr_, &debug_.ndigit_, _dc_160);
    (void) _svout (&debug_.logfil_, &kplusp_, ritzi_, &debug_.ndigit_, _dc_161);
    (void) _svout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_56);
  }
  nptemp_ = (*np_);
  for (j_ = 1; j_ <= nptemp_; (j_)++) {
    if (bounds_[j_ - 1] == 0.0) {
      (*np_) = (*np_) - 1;
      (*nev_) = (*nev_) + 1;
    }
  }
  if ((nconv_ >= numcnv_) || (iter_ > (*mxiter_)) || ((*np_) == 0)) {
    if (msglvl_ > 4) {
      (void) _svout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + 1 - 1], &debug_.ndigit_, _dc_162);
      (void) _svout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + kplusp_ + 1 - 1], &debug_.ndigit_, _dc_163);
      (void) _svout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + kplusp_ * 2 + 1 - 1], &debug_.ndigit_, _dc_164)
      ;
    }
    h_[2 + ((*ldh_)) * ((0))] = rnorm_;
    if ((strcasecmp (which_, _dc_59) == 0)) {
      bufcpy (wprime_, _dc_62, 3);
    }
    if ((strcasecmp (which_, _dc_60) == 0)) {
      bufcpy (wprime_, _dc_61, 3);
    }
    if ((strcasecmp (which_, _dc_61) == 0)) {
      bufcpy (wprime_, _dc_60, 3);
    }
    if ((strcasecmp (which_, _dc_62) == 0)) {
      bufcpy (wprime_, _dc_59, 3);
    }
    if ((strcasecmp (which_, _dc_63) == 0)) {
      bufcpy (wprime_, _dc_60, 3);
    }
    if ((strcasecmp (which_, _dc_64) == 0)) {
      bufcpy (wprime_, _dc_59, 3);
    }
    (void) _ssortc (wprime_, ($1_ = TRUE, &$1_), &kplusp_, ritzr_, ritzi_, bounds_);
    if ((strcasecmp (which_, _dc_59) == 0)) {
      bufcpy (wprime_, _dc_60, 3);
    }
    if ((strcasecmp (which_, _dc_60) == 0)) {
      bufcpy (wprime_, _dc_59, 3);
    }
    if ((strcasecmp (which_, _dc_61) == 0)) {
      bufcpy (wprime_, _dc_62, 3);
    }
    if ((strcasecmp (which_, _dc_62) == 0)) {
      bufcpy (wprime_, _dc_61, 3);
    }
    if ((strcasecmp (which_, _dc_63) == 0)) {
      bufcpy (wprime_, _dc_64, 3);
    }
    if ((strcasecmp (which_, _dc_64) == 0)) {
      bufcpy (wprime_, _dc_63, 3);
    }
    (void) _ssortc (wprime_, ($2_ = TRUE, &$2_), &kplusp_, ritzr_, ritzi_, bounds_);
    for (j_ = 1; j_ <= numcnv_; (j_)++) {
      temp_ = _max (eps23_, _slapy2 (&ritzr_[j_ - 1], &ritzi_[j_ - 1]));
      bounds_[j_ - 1] = bounds_[j_ - 1] / temp_;
    }
    bufcpy (wprime_, _dc_61, 3);
    (void) _ssortc (wprime_, ($3_ = TRUE, &$3_), &numcnv_, bounds_, ritzr_, ritzi_);
    for (j_ = 1; j_ <= numcnv_; (j_)++) {
      temp_ = _max (eps23_, _slapy2 (&ritzr_[j_ - 1], &ritzi_[j_ - 1]));
      bounds_[j_ - 1] = bounds_[j_ - 1] * temp_;
    }
    (void) _ssortc (which_, ($4_ = TRUE, &$4_), &nconv_, ritzr_, ritzi_, bounds_);
    if (msglvl_ > 1) {
      (void) _svout (&debug_.logfil_, &kplusp_, ritzr_, &debug_.ndigit_, _dc_165);
      (void) _svout (&debug_.logfil_, &kplusp_, ritzi_, &debug_.ndigit_, _dc_166);
      (void) _svout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_66);
    }
    if (iter_ > (*mxiter_) && nconv_ < numcnv_) {
      (*info_) = 1;
    }
    if ((*np_) == 0 && nconv_ < numcnv_) {
      (*info_) = 2;
    }
    (*np_) = nconv_;
    goto _l1100;
  }
  else if ((nconv_ < numcnv_) && ((*ishift_) == 1)) {
    nevbef_ = (*nev_);
    (*nev_) = (*nev_) + _min (nconv_, (*np_) / 2);
    if ((*nev_) == 1 && kplusp_ >= 6) {
      (*nev_) = kplusp_ / 2;
    }
    else if ((*nev_) == 1 && kplusp_ > 3) {
      (*nev_) = 2;
    }
    (*np_) = kplusp_ - (*nev_);
    if (nevbef_ < (*nev_)) {
      (void) _sngets (ishift_, which_, nev_, np_, ritzr_, ritzi_, bounds_, workl_, &workl_[(*np_) + 1 - 1]);
    }
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_67);
    if (msglvl_ > 1) {
      kp_[0] = (*nev_);
      kp_[1] = (*np_);
      (void) _ivout (&debug_.logfil_, ($5_ = 2, &$5_), kp_, &debug_.ndigit_, _dc_68);
      (void) _svout (&debug_.logfil_, nev_, &ritzr_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_167);
      (void) _svout (&debug_.logfil_, nev_, &ritzi_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_168);
      (void) _svout (&debug_.logfil_, nev_, &bounds_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_70);
    }
  }
  if ((*ishift_) == 0) {
    ushift_ = TRUE;
    (*ido_) = 3;
    goto _l9000;
  }
  _l50:;
  ushift_ = FALSE;
  if ((*ishift_) == 0) {
    (void) _scopy (np_, workl_, &_k1, ritzr_, &_k1);
    (void) _scopy (np_, &workl_[(*np_) + 1 - 1], &_k1, ritzi_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_71);
    (void) _svout (&debug_.logfil_, np_, ritzr_, &debug_.ndigit_, _dc_169);
    (void) _svout (&debug_.logfil_, np_, ritzi_, &debug_.ndigit_, _dc_170);
    if ((*ishift_) == 1) {
      (void) _svout (&debug_.logfil_, np_, bounds_, &debug_.ndigit_, _dc_73);
    }
  }
  (void) _snapps (n_, nev_, np_, ritzr_, ritzi_, v_, ldv_, h_, ldh_, resid_, q_, ldq_, workl_, workd_);
  cnorm_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _scopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l100:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm_ = _sdot (n_, resid_, &_k1, workd_, &_k1);
    rnorm_ = sqrtf (_abs (rnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm_ = _snrm2 (n_, resid_, &_k1);
  }
  cnorm_ = FALSE;
  if (msglvl_ > 2) {
    (void) _svout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_74);
    (void) _smout (&debug_.logfil_, nev_, nev_, h_, ldh_, &debug_.ndigit_, _dc_75);
  }
  goto _l1000;
  _l1100:;
  (*mxiter_) = iter_;
  (*nev_) = numcnv_;
  _l1200:;
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tnaup2_ = t1_ - t0_;
  _l9000:;
  __calls[49].calls++;
  return 0;
}

int_4 _snaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_, real_4 
_p_ resid_, int_4 _p_ ncv_, real_4 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_4 _p_ workd_, 
real_4 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, iq_, ishift_, iupd_, iw_, ldh_, ldq_, levec_, mode_, msglvl_, mxiter_, nb_, nev0_, 
  next_, np_, ritzi_, ritzr_, j_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 __fcnt, __rc;
  extern real_4 _slamch ();
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_173, _dc_173,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_84, _dc_84,
    FMT_TEXT, _dc_174, _dc_174,
    FMT_TEXT, _dc_86, _dc_86,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_88, _dc_88,
    FMT_TEXT, _dc_89, _dc_89,
    FMT_TEXT, _dc_90, _dc_90,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_91, _dc_91,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_1100_[] = {
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_92, _dc_92,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_93, _dc_93,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_94, _dc_94,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_96, _dc_96,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_97, _dc_97,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_98, _dc_98,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_99, _dc_99,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_101, _dc_101,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_102, _dc_102,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_103, _dc_103,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_104, _dc_104,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_105, _dc_105,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_106, _dc_106,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_107, _dc_107,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_108, _dc_108,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_109, _dc_109,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  if ((*ido_) == 0) {
    (void) _sstatn ();
    (void) _second (&t0_);
    msglvl_ = debug_.mnaupd_;
    ierr_ = 0;
    ishift_ = iparam_[0];
    mxiter_ = iparam_[2];
    nb_ = 1;
    iupd_ = 1;
    mode_ = iparam_[6];
    if ((*n_) <= 0) {
      ierr_ = -1;
    }
    else if ((*nev_) <= 0) {
      ierr_ = -2;
    }
    else if ((*ncv_) <= (*nev_) + 1 || (*ncv_) > (*n_)) {
      ierr_ = -3;
    }
    else if (mxiter_ <= 0) {
      ierr_ = -4;
    }
    else if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_61) != 0) 
      && (strcasecmp (which_, _dc_62) != 0) && (strcasecmp (which_, _dc_63) != 0) && (strcasecmp (which_, _dc_64) != 0)) {
      ierr_ = -5;
    }
    else if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
      ierr_ = -6;
    }
    else if ((*lworkl_) < 3 * ((*ncv_) * (*ncv_)) + 6 * (*ncv_)) {
      ierr_ = -7;
    }
    else if (mode_ < 1 || mode_ > 4) {
      ierr_ = -10;
    }
    else if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
      ierr_ = -11;
    }
    else if (ishift_ < 0 || ishift_ > 1) {
      ierr_ = -12;
    }
    if (ierr_ != 0) {
      (*info_) = ierr_;
      (*ido_) = 99;
      goto _l9000;
    }
    if (nb_ <= 0) {
      nb_ = 1;
    }
    if ((*tol_) <= 0.0) {
      (*tol_) = _slamch (_dc_76);
    }
    np_ = (*ncv_) - (*nev_);
    nev0_ = (*nev_);
    for (j_ = 1; j_ <= 3 * ((*ncv_) * (*ncv_)) + 6 * (*ncv_); (j_)++) {
      workl_[j_ - 1] = 0.0;
    }
    ldh_ = (*ncv_);
    ldq_ = (*ncv_);
    ih_ = 1;
    ritzr_ = ih_ + ldh_ * (*ncv_);
    ritzi_ = ritzr_ + (*ncv_);
    bounds_ = ritzi_ + (*ncv_);
    iq_ = bounds_ + (*ncv_);
    iw_ = iq_ + ldq_ * (*ncv_);
    next_ = iw_ + ((*ncv_) * (*ncv_)) + 3 * (*ncv_);
    ipntr_[3] = next_;
    ipntr_[4] = ih_;
    ipntr_[5] = ritzr_;
    ipntr_[6] = ritzi_;
    ipntr_[7] = bounds_;
    ipntr_[13] = iw_;
  }
  (void) _snaup2 (ido_, bmat_, n_, which_, &nev0_, &np_, tol_, resid_, &mode_, &iupd_, &ishift_, &mxiter_, v_, ldv_, 
  &workl_[ih_ - 1], &ldh_, &workl_[ritzr_ - 1], &workl_[ritzi_ - 1], &workl_[bounds_ - 1], &workl_[iq_ - 1], &ldq_, 
  &workl_[iw_ - 1], ipntr_, workd_, info_);
  if ((*ido_) == 3) {
    iparam_[7] = np_;
  }
  if ((*ido_) != 99) {
    goto _l9000;
  }
  iparam_[2] = mxiter_;
  iparam_[4] = np_;
  iparam_[8] = timing_.nopx_;
  iparam_[9] = timing_.nbx_;
  iparam_[10] = timing_.nrorth_;
  if ((*info_) < 0) {
    goto _l9000;
  }
  if ((*info_) == 2) {
    (*info_) = 3;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &mxiter_, &debug_.ndigit_, _dc_77);
    (void) _ivout (&debug_.logfil_, &_k1, &np_, &debug_.ndigit_, _dc_78);
    (void) _svout (&debug_.logfil_, &np_, &workl_[ritzr_ - 1], &debug_.ndigit_, _dc_171);
    (void) _svout (&debug_.logfil_, &np_, &workl_[ritzi_ - 1], &debug_.ndigit_, _dc_172);
    (void) _svout (&debug_.logfil_, &np_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_80);
  }
  (void) _second (&t1_);
  timing_.tnaupd_ = t1_ - t0_;
  if (msglvl_ > 0) {
    _fcheck ("arpack:snaupd:652", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:652", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _fcheck ("arpack:snaupd:653", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &mxiter_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nopx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nbx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrorth_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nitref_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrstrt_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvopx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvbx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnaupd_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnaup2_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnaitr_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.titref_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tgetv0_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tneigh_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tngets_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnapps_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tnconv_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.trvec_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:snaupd:653", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _l1000:;
    _l1100:;
  }
  _l9000:;
  __calls[50].calls++;
  return 0;
}

int_4 _snconv (int_4 _p_ n_, real_4 _p_ ritzr_, real_4 _p_ ritzi_, real_4 _p_ bounds_, real_4 _p_ tol_, int_4 _p_ 
nconv_)
{
  static int_4 i_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, temp_, eps23_;
  extern real_4 _slapy2 ();
  extern real_4 _slamch ();
  (void) _second (&t0_);
  eps23_ = _slamch (_dc_49);
  eps23_ = powl (eps23_, 6.6666667e-1);
  (*nconv_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    temp_ = _max (eps23_, _slapy2 (&ritzr_[i_ - 1], &ritzi_[i_ - 1]));
    if (bounds_[i_ - 1] <= (*tol_) * temp_) {
      (*nconv_) = (*nconv_) + 1;
    }
  }
  (void) _second (&t1_);
  timing_.tnconv_ = timing_.tnconv_ + (t1_ - t0_);
  __calls[51].calls++;
  return 0;
}

int_4 _sneigh (real_4 _p_ rnorm_, int_4 _p_ n_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ ritzr_, real_4 _p_ ritzi_, 
real_4 _p_ bounds_, real_4 _p_ q_, int_4 _p_ ldq_, real_4 _p_ workl_, int_4 _p_ ierr_)
{
  static int_4 i_, iconj_, msglvl_;
  static logical_4 select_[1];
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, temp_, vl_[1];
  logical_4 $0_;
  real_4 $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern int_4 _slacpy ();
  extern int_4 _strevc ();
  extern real_4 _slapy2 ();
  extern real_4 _snrm2 ();
  (void) _second (&t0_);
  msglvl_ = debug_.mneigh_;
  if (msglvl_ > 2) {
    (void) _smout (&debug_.logfil_, n_, n_, h_, ldh_, &debug_.ndigit_, _dc_110);
  }
  (void) _slacpy (_dc_36, n_, n_, h_, ldh_, workl_, n_);
  (void) _slaqrb (($0_ = TRUE, &$0_), n_, &_k1, n_, workl_, n_, ritzr_, ritzi_, bounds_, ierr_);
  if ((*ierr_) != 0) {
    goto _l9000;
  }
  if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, n_, bounds_, &debug_.ndigit_, _dc_111);
  }
  (void) _strevc (_dc_175, _dc_44, select_, n_, workl_, n_, vl_, n_, q_, ldq_, n_, n_, &workl_[(*n_) * (*n_) + 1 - 1], 
  ierr_);
  if ((*ierr_) != 0) {
    goto _l9000;
  }
  iconj_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_abs (ritzi_[i_ - 1]) <= 0.0) {
      temp_ = _snrm2 (n_, &q_[0 + ((*ldq_)) * ((i_ - 1))], &_k1);
      (void) _sscal (n_, ($1_ = 1.0 / temp_, &$1_), &q_[0 + ((*ldq_)) * ((i_ - 1))], &_k1);
    }
    else {
      if (iconj_ == 0) {
        temp_ = _slapy2 (($2_ = _snrm2 (n_, &q_[0 + ((*ldq_)) * ((i_ - 1))], &_k1), &$2_), ($3_ = _snrm2 (n_, &q_[0 + ((*ldq_)) 
        * ((i_ + 1 - 1))], &_k1), &$3_));
        (void) _sscal (n_, ($4_ = 1.0 / temp_, &$4_), &q_[0 + ((*ldq_)) * ((i_ - 1))], &_k1);
        (void) _sscal (n_, ($5_ = 1.0 / temp_, &$5_), &q_[0 + ((*ldq_)) * ((i_ + 1 - 1))], &_k1);
        iconj_ = 1;
      }
      else {
        iconj_ = 0;
      }
    }
  }
  (void) _sgemv (_dc_150, n_, n_, ($6_ = 1.0, &$6_), q_, ldq_, bounds_, &_k1, ($7_ = 0.0, &$7_), workl_, &_k1);
  if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, n_, workl_, &debug_.ndigit_, _dc_114);
  }
  iconj_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_abs (ritzi_[i_ - 1]) <= 0.0) {
      bounds_[i_ - 1] = (*rnorm_) * _abs (workl_[i_ - 1]);
    }
    else {
      if (iconj_ == 0) {
        bounds_[i_ - 1] = (*rnorm_) * _slapy2 (&workl_[i_ - 1], &workl_[i_ + 1 - 1]);
        bounds_[i_ + 1 - 1] = bounds_[i_ - 1];
        iconj_ = 1;
      }
      else {
        iconj_ = 0;
      }
    }
  }
  if (msglvl_ > 2) {
    (void) _svout (&debug_.logfil_, n_, ritzr_, &debug_.ndigit_, _dc_176);
    (void) _svout (&debug_.logfil_, n_, ritzi_, &debug_.ndigit_, _dc_177);
    (void) _svout (&debug_.logfil_, n_, bounds_, &debug_.ndigit_, _dc_116);
  }
  (void) _second (&t1_);
  timing_.tneigh_ = timing_.tneigh_ + (t1_ - t0_);
  _l9000:;
  __calls[52].calls++;
  return 0;
}

int_4 _sneupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, real_4 _p_ dr_, real_4 _p_ di_, real_4 _p_ 
z_, int_4 _p_ ldz_, real_4 _p_ sigmar_, real_4 _p_ sigmai_, real_4 _p_ workev_, char _p_ bmat_, int_4 _p_ n_, char _p_ 
which_, int_4 _p_ nev_, real_4 _p_ tol_, real_4 _p_ resid_, int_4 _p_ ncv_, real_4 _p_ v_, int_4 _p_ ldv_, int_4 _p_ 
iparam_, int_4 _p_ ipntr_, real_4 _p_ workd_, real_4 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, ihbds_, iheigr_, iheigi_, iconj_, nconv_, invsub_, iuptri_, iwev_, iwork_[1], j_, k_, 
  ldh_, ldq_, mode_, msglvl_, outncv_, ritzr_, ritzi_, wri_, wrr_, irr_, iri_, ibd_, ishift_, numcnv_, np_, jj_;
  static logical_4 reord_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, conds_, rnorm_, sep_, temp_, vl_[1], temp1_, eps23_;
  static char_7 type_;
  int_4 $0_;
  logical_4 $3_, $4_;
  real_4 $1_, $2_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_;
  extern int_4 _scopy ();
  extern int_4 _sger ();
  extern int_4 _sgeqr2 ();
  extern int_4 _slacpy ();
  extern int_4 _slahqr ();
  extern int_4 _slaset ();
  extern int_4 _sorm2r ();
  extern int_4 _strevc ();
  extern int_4 _strmm ();
  extern int_4 _strsen ();
  extern int_4 _sscal ();
  extern real_4 _slapy2 ();
  extern real_4 _snrm2 ();
  extern real_4 _slamch ();
  msglvl_ = debug_.mneupd_;
  mode_ = iparam_[6];
  nconv_ = iparam_[4];
  (*info_) = 0;
  eps23_ = _slamch (_dc_49);
  eps23_ = powl (eps23_, 6.6666667e-1);
  ierr_ = 0;
  if (nconv_ <= 0) {
    ierr_ = -14;
  }
  else if ((*n_) <= 0) {
    ierr_ = -1;
  }
  else if ((*nev_) <= 0) {
    ierr_ = -2;
  }
  else if ((*ncv_) <= (*nev_) + 1 || (*ncv_) > (*n_)) {
    ierr_ = -3;
  }
  else if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_61) != 0) 
    && (strcasecmp (which_, _dc_62) != 0) && (strcasecmp (which_, _dc_63) != 0) && (strcasecmp (which_, _dc_64) != 0)) {
    ierr_ = -5;
  }
  else if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
    ierr_ = -6;
  }
  else if ((*lworkl_) < 3 * ((*ncv_) * (*ncv_)) + 6 * (*ncv_)) {
    ierr_ = -7;
  }
  else if (((strcasecmp (howmny_, _dc_44) != 0) && (strcasecmp (howmny_, _dc_117) != 0) && (strcasecmp (howmny_, _dc_118) 
    != 0)) && (*rvec_)) {
    ierr_ = -13;
  }
  else if ((strcasecmp (howmny_, _dc_118) == 0)) {
    ierr_ = -12;
  }
  if (mode_ == 1 || mode_ == 2) {
    bufcpy (type_, _dc_119, 7);
  }
  else if (mode_ == 3 && (*sigmai_) == 0.0) {
    bufcpy (type_, _dc_120, 7);
  }
  else if (mode_ == 3) {
    bufcpy (type_, _dc_178, 7);
  }
  else if (mode_ == 4) {
    bufcpy (type_, _dc_179, 7);
  }
  else {
    ierr_ = -10;
  }
  if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
    ierr_ = -11;
  }
  if (ierr_ != 0) {
    (*info_) = ierr_;
    goto _l9000;
  }
  ih_ = ipntr_[4];
  ritzr_ = ipntr_[5];
  ritzi_ = ipntr_[6];
  bounds_ = ipntr_[7];
  ldh_ = (*ncv_);
  ldq_ = (*ncv_);
  iheigr_ = bounds_ + ldh_;
  iheigi_ = iheigr_ + ldh_;
  ihbds_ = iheigi_ + ldh_;
  iuptri_ = ihbds_ + ldh_;
  invsub_ = iuptri_ + ldh_ * (*ncv_);
  ipntr_[8] = iheigr_;
  ipntr_[9] = iheigi_;
  ipntr_[10] = ihbds_;
  ipntr_[11] = iuptri_;
  ipntr_[12] = invsub_;
  wrr_ = 1;
  wri_ = (*ncv_) + 1;
  iwev_ = wri_ + (*ncv_);
  irr_ = ipntr_[13] + (*ncv_) * (*ncv_);
  iri_ = irr_ + (*ncv_);
  ibd_ = iri_ + (*ncv_);
  rnorm_ = workl_[ih_ + 2 - 1];
  workl_[ih_ + 2 - 1] = 0.0;
  if (msglvl_ > 2) {
    (void) _svout (&debug_.logfil_, ncv_, &workl_[irr_ - 1], &debug_.ndigit_, _dc_180);
    (void) _svout (&debug_.logfil_, ncv_, &workl_[iri_ - 1], &debug_.ndigit_, _dc_181);
    (void) _svout (&debug_.logfil_, ncv_, &workl_[ibd_ - 1], &debug_.ndigit_, _dc_122);
  }
  if ((*rvec_)) {
    reord_ = FALSE;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      workl_[bounds_ + j_ - 1 - 1] = j_;
      select_[j_ - 1] = FALSE;
    }
    np_ = (*ncv_) - (*nev_);
    ishift_ = 0;
    (void) _sngets (&ishift_, which_, nev_, &np_, &workl_[irr_ - 1], &workl_[iri_ - 1], &workl_[bounds_ - 1], workl_, 
    &workl_[np_ + 1 - 1]);
    if (msglvl_ > 2) {
      (void) _svout (&debug_.logfil_, ncv_, &workl_[irr_ - 1], &debug_.ndigit_, _dc_182);
      (void) _svout (&debug_.logfil_, ncv_, &workl_[iri_ - 1], &debug_.ndigit_, _dc_183);
      (void) _svout (&debug_.logfil_, ncv_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_124);
    }
    numcnv_ = 0;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      temp1_ = _max (eps23_, _slapy2 (&workl_[irr_ + (*ncv_) - j_ - 1], &workl_[iri_ + (*ncv_) - j_ - 1]));
      jj_ = workl_[bounds_ + (*ncv_) - j_ - 1];
      if (numcnv_ < nconv_ && workl_[ibd_ + jj_ - 1 - 1] <= (*tol_) * temp1_) {
        select_[jj_ - 1] = TRUE;
        numcnv_ = numcnv_ + 1;
        if (jj_ > (*nev_)) {
          reord_ = TRUE;
        }
      }
    }
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &numcnv_, &debug_.ndigit_, _dc_125);
      (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_126);
    }
    if (numcnv_ != nconv_) {
      (*info_) = -15;
      goto _l9000;
    }
    (void) _scopy (($0_ = ldh_ * (*ncv_), &$0_), &workl_[ih_ - 1], &_k1, &workl_[iuptri_ - 1], &_k1);
    (void) _slaset (_dc_36, ncv_, ncv_, ($1_ = 0.0, &$1_), ($2_ = 1.0, &$2_), &workl_[invsub_ - 1], &ldq_);
    (void) _slahqr (($3_ = TRUE, &$3_), ($4_ = TRUE, &$4_), ncv_, &_k1, ncv_, &workl_[iuptri_ - 1], &ldh_, &workl_[iheigr_ 
    - 1], &workl_[iheigi_ - 1], &_k1, ncv_, &workl_[invsub_ - 1], &ldq_, &ierr_);
    (void) _scopy (ncv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
    if (ierr_ != 0) {
      (*info_) = -8;
      goto _l9000;
    }
    if (msglvl_ > 1) {
      (void) _svout (&debug_.logfil_, ncv_, &workl_[iheigr_ - 1], &debug_.ndigit_, _dc_184);
      (void) _svout (&debug_.logfil_, ncv_, &workl_[iheigi_ - 1], &debug_.ndigit_, _dc_185);
      (void) _svout (&debug_.logfil_, ncv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_128);
      if (msglvl_ > 3) {
        (void) _smout (&debug_.logfil_, ncv_, ncv_, &workl_[iuptri_ - 1], &ldh_, &debug_.ndigit_, _dc_186);
      }
    }
    if (reord_) {
      (void) _strsen (_dc_130, _dc_131, select_, ncv_, &workl_[iuptri_ - 1], &ldh_, &workl_[invsub_ - 1], &ldq_, 
      &workl_[iheigr_ - 1], &workl_[iheigi_ - 1], &nconv_, &conds_, &sep_, &workl_[ihbds_ - 1], ncv_, iwork_, &_k1, &ierr_);
      if (ierr_ == 1) {
        (*info_) = 1;
        goto _l9000;
      }
      if (msglvl_ > 2) {
        (void) _svout (&debug_.logfil_, ncv_, &workl_[iheigr_ - 1], &debug_.ndigit_, _dc_187);
        (void) _svout (&debug_.logfil_, ncv_, &workl_[iheigi_ - 1], &debug_.ndigit_, _dc_188);
        if (msglvl_ > 3) {
          (void) _smout (&debug_.logfil_, ncv_, ncv_, &workl_[iuptri_ - 1], &ldq_, &debug_.ndigit_, _dc_189);
        }
      }
    }
    (void) _scopy (ncv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
    if ((strcasecmp (type_, _dc_119) == 0)) {
      (void) _scopy (&nconv_, &workl_[iheigr_ - 1], &_k1, dr_, &_k1);
      (void) _scopy (&nconv_, &workl_[iheigi_ - 1], &_k1, di_, &_k1);
    }
    (void) _sgeqr2 (ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, &workev_[(*ncv_) + 1 - 1], &ierr_);
    (void) _sorm2r (_dc_112, _dc_134, n_, ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, v_, ldv_, &workd_[(*n_) + 1 
    - 1], &ierr_);
    (void) _slacpy (_dc_36, n_, &nconv_, v_, ldv_, z_, ldz_);
    for (j_ = 1; j_ <= nconv_; (j_)++) {
      if (workl_[invsub_ + (j_ - 1) * ldq_ + j_ - 1 - 1] < 0.0) {
        (void) _sscal (&nconv_, ($5_ = -1.0, &$5_), &workl_[iuptri_ + j_ - 1 - 1], &ldq_);
        (void) _sscal (&nconv_, ($6_ = -1.0, &$6_), &workl_[iuptri_ + (j_ - 1) * ldq_ - 1], &_k1);
      }
    }
    if ((strcasecmp (howmny_, _dc_44) == 0)) {
      for (j_ = 1; j_ <= (*ncv_); (j_)++) {
        if (j_ <= nconv_) {
          select_[j_ - 1] = TRUE;
        }
        else {
          select_[j_ - 1] = FALSE;
        }
      }
      (void) _strevc (_dc_112, _dc_135, select_, ncv_, &workl_[iuptri_ - 1], &ldq_, vl_, &_k1, &workl_[invsub_ - 1], &ldq_, 
      ncv_, &outncv_, workev_, &ierr_);
      if (ierr_ != 0) {
        (*info_) = -9;
        goto _l9000;
      }
      iconj_ = 0;
      for (j_ = 1; j_ <= nconv_; (j_)++) {
        if (workl_[iheigi_ + j_ - 1 - 1] == 0.0) {
          temp_ = _snrm2 (ncv_, &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
          (void) _sscal (ncv_, ($7_ = 1.0 / temp_, &$7_), &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
        }
        else {
          if (iconj_ == 0) {
            temp_ = _slapy2 (($8_ = _snrm2 (ncv_, &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1), &$8_), ($9_ = _snrm2 (ncv_, 
            &workl_[invsub_ + j_ * ldq_ - 1], &_k1), &$9_));
            (void) _sscal (ncv_, ($10_ = 1.0 / temp_, &$10_), &workl_[invsub_ + (j_ - 1) * ldq_ - 1], &_k1);
            (void) _sscal (ncv_, ($11_ = 1.0 / temp_, &$11_), &workl_[invsub_ + j_ * ldq_ - 1], &_k1);
            iconj_ = 1;
          }
          else {
            iconj_ = 0;
          }
        }
      }
      (void) _sgemv (_dc_150, ncv_, &nconv_, ($12_ = 1.0, &$12_), &workl_[invsub_ - 1], &ldq_, &workl_[ihbds_ - 1], &_k1, 
      ($13_ = 0.0, &$13_), workev_, &_k1);
      iconj_ = 0;
      for (j_ = 1; j_ <= nconv_; (j_)++) {
        if (workl_[iheigi_ + j_ - 1 - 1] != 0.0) {
          if (iconj_ == 0) {
            workev_[j_ - 1] = _slapy2 (&workev_[j_ - 1], &workev_[j_ + 1 - 1]);
            workev_[j_ + 1 - 1] = workev_[j_ - 1];
            iconj_ = 1;
          }
          else {
            iconj_ = 0;
          }
        }
      }
      if (msglvl_ > 2) {
        (void) _scopy (ncv_, &workl_[invsub_ + (*ncv_) - 1 - 1], &ldq_, &workl_[ihbds_ - 1], &_k1);
        (void) _svout (&debug_.logfil_, ncv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_136);
        if (msglvl_ > 3) {
          (void) _smout (&debug_.logfil_, ncv_, ncv_, &workl_[invsub_ - 1], &ldq_, &debug_.ndigit_, _dc_137);
        }
      }
      (void) _scopy (&nconv_, workev_, &_k1, &workl_[ihbds_ - 1], &_k1);
      (void) _sgeqr2 (ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, &workev_[(*ncv_) + 1 - 1], &ierr_);
      (void) _sorm2r (_dc_112, _dc_134, n_, ncv_, &nconv_, &workl_[invsub_ - 1], &ldq_, workev_, z_, ldz_, &workd_[(*n_) + 1 
      - 1], &ierr_);
      (void) _strmm (_dc_112, _dc_138, _dc_139, _dc_140, n_, &nconv_, ($14_ = 1.0, &$14_), &workl_[invsub_ - 1], &ldq_, z_, 
      ldz_);
    }
  }
  else {
    (void) _scopy (&nconv_, &workl_[ritzr_ - 1], &_k1, dr_, &_k1);
    (void) _scopy (&nconv_, &workl_[ritzi_ - 1], &_k1, di_, &_k1);
    (void) _scopy (&nconv_, &workl_[ritzr_ - 1], &_k1, &workl_[iheigr_ - 1], &_k1);
    (void) _scopy (&nconv_, &workl_[ritzi_ - 1], &_k1, &workl_[iheigi_ - 1], &_k1);
    (void) _scopy (&nconv_, &workl_[bounds_ - 1], &_k1, &workl_[ihbds_ - 1], &_k1);
  }
  if ((strcasecmp (type_, _dc_119) == 0)) {
    if ((*rvec_)) {
      (void) _sscal (ncv_, &rnorm_, &workl_[ihbds_ - 1], &_k1);
    }
  }
  else {
    if ((strcasecmp (type_, _dc_120) == 0)) {
      if ((*rvec_)) {
        (void) _sscal (ncv_, &rnorm_, &workl_[ihbds_ - 1], &_k1);
      }
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        temp_ = _slapy2 (&workl_[iheigr_ + k_ - 1 - 1], &workl_[iheigi_ + k_ - 1 - 1]);
        workl_[ihbds_ + k_ - 1 - 1] = _abs (workl_[ihbds_ + k_ - 1 - 1]) / temp_ / temp_;
      }
    }
    else if ((strcasecmp (type_, _dc_178) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
      }
    }
    else if ((strcasecmp (type_, _dc_179) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
      }
    }
    if ((strcasecmp (type_, _dc_120) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        temp_ = _slapy2 (&workl_[iheigr_ + k_ - 1 - 1], &workl_[iheigi_ + k_ - 1 - 1]);
        workl_[iheigr_ + k_ - 1 - 1] = workl_[iheigr_ + k_ - 1 - 1] / temp_ / temp_ + (*sigmar_);
        workl_[iheigi_ + k_ - 1 - 1] = -workl_[iheigi_ + k_ - 1 - 1] / temp_ / temp_ + (*sigmai_);
      }
      (void) _scopy (&nconv_, &workl_[iheigr_ - 1], &_k1, dr_, &_k1);
      (void) _scopy (&nconv_, &workl_[iheigi_ - 1], &_k1, di_, &_k1);
    }
    else if ((strcasecmp (type_, _dc_178) == 0) || (strcasecmp (type_, _dc_179) == 0)) {
      (void) _scopy (&nconv_, &workl_[iheigr_ - 1], &_k1, dr_, &_k1);
      (void) _scopy (&nconv_, &workl_[iheigi_ - 1], &_k1, di_, &_k1);
    }
  }
  if ((strcasecmp (type_, _dc_120) == 0) && msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &nconv_, dr_, &debug_.ndigit_, _dc_190);
    (void) _svout (&debug_.logfil_, &nconv_, di_, &debug_.ndigit_, _dc_191);
    (void) _svout (&debug_.logfil_, &nconv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_192);
  }
  else if ((strcasecmp (type_, _dc_119) == 0) && msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &nconv_, dr_, &debug_.ndigit_, _dc_193);
    (void) _svout (&debug_.logfil_, &nconv_, di_, &debug_.ndigit_, _dc_194);
    (void) _svout (&debug_.logfil_, &nconv_, &workl_[ihbds_ - 1], &debug_.ndigit_, _dc_144);
  }
  if ((*rvec_) && (strcasecmp (howmny_, _dc_44) == 0) && (strcasecmp (type_, _dc_120) == 0)) {
    iconj_ = 0;
    for (j_ = 1; j_ <= nconv_; (j_)++) {
      if (workl_[iheigi_ + j_ - 1 - 1] == 0.0) {
        workev_[j_ - 1] = workl_[invsub_ + (j_ - 1) * ldq_ + (*ncv_) - 1 - 1] / workl_[iheigr_ + j_ - 1 - 1];
      }
      else if (iconj_ == 0) {
        temp_ = _slapy2 (&workl_[iheigr_ + j_ - 1 - 1], &workl_[iheigi_ + j_ - 1 - 1]);
        workev_[j_ - 1] = (workl_[invsub_ + (j_ - 1) * ldq_ + (*ncv_) - 1 - 1] * workl_[iheigr_ + j_ - 1 - 1] + workl_[invsub_ 
        + j_ * ldq_ + (*ncv_) - 1 - 1] * workl_[iheigi_ + j_ - 1 - 1]) / temp_ / temp_;
        workev_[j_ + 1 - 1] = (workl_[invsub_ + j_ * ldq_ + (*ncv_) - 1 - 1] * workl_[iheigr_ + j_ - 1 - 1] - workl_[invsub_ + 
        (j_ - 1) * ldq_ + (*ncv_) - 1 - 1] * workl_[iheigi_ + j_ - 1 - 1]) / temp_ / temp_;
        iconj_ = 1;
      }
      else {
        iconj_ = 0;
      }
    }
    (void) _sger (n_, &nconv_, ($15_ = 1.0, &$15_), resid_, &_k1, workev_, &_k1, z_, ldz_);
  }
  _l9000:;
  __calls[53].calls++;
  return 0;
}

int_4 _sngets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, real_4 _p_ ritzr_, real_4 _p_ ritzi_, 
real_4 _p_ bounds_, real_4 _p_ shiftr_, real_4 _p_ shifti_)
{
  static int_4 msglvl_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 $1_, $3_, $5_, $7_, $9_, $11_, $13_, $15_, $16_, $17_;
  logical_4 $0_, $2_, $4_, $6_, $8_, $10_, $12_, $14_;
  (void) _second (&t0_);
  msglvl_ = debug_.mngets_;
  if ((strcasecmp (which_, _dc_59) == 0)) {
    (void) _ssortc (_dc_61, ($0_ = TRUE, &$0_), ($1_ = (*kev_) + (*np_), &$1_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    (void) _ssortc (_dc_62, ($2_ = TRUE, &$2_), ($3_ = (*kev_) + (*np_), &$3_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_61) == 0)) {
    (void) _ssortc (_dc_59, ($4_ = TRUE, &$4_), ($5_ = (*kev_) + (*np_), &$5_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_62) == 0)) {
    (void) _ssortc (_dc_60, ($6_ = TRUE, &$6_), ($7_ = (*kev_) + (*np_), &$7_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_63) == 0)) {
    (void) _ssortc (_dc_59, ($8_ = TRUE, &$8_), ($9_ = (*kev_) + (*np_), &$9_), ritzr_, ritzi_, bounds_);
  }
  else if ((strcasecmp (which_, _dc_64) == 0)) {
    (void) _ssortc (_dc_60, ($10_ = TRUE, &$10_), ($11_ = (*kev_) + (*np_), &$11_), ritzr_, ritzi_, bounds_);
  }
  (void) _ssortc (which_, ($12_ = TRUE, &$12_), ($13_ = (*kev_) + (*np_), &$13_), ritzr_, ritzi_, bounds_);
  if ((ritzr_[(*np_) + 1 - 1] - ritzr_[(*np_) - 1]) == 0.0 && (ritzi_[(*np_) + 1 - 1] + ritzi_[(*np_) - 1]) == 0.0) {
    (*np_) = (*np_) - 1;
    (*kev_) = (*kev_) + 1;
  }
  if ((*ishift_) == 1) {
    (void) _ssortc (_dc_62, ($14_ = TRUE, &$14_), np_, bounds_, ritzr_, ritzi_);
  }
  (void) _second (&t1_);
  timing_.tngets_ = timing_.tngets_ + (t1_ - t0_);
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_145);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_146);
    (void) _svout (&debug_.logfil_, ($15_ = (*kev_) + (*np_), &$15_), ritzr_, &debug_.ndigit_, _dc_195);
    (void) _svout (&debug_.logfil_, ($16_ = (*kev_) + (*np_), &$16_), ritzi_, &debug_.ndigit_, _dc_196);
    (void) _svout (&debug_.logfil_, ($17_ = (*kev_) + (*np_), &$17_), bounds_, &debug_.ndigit_, _dc_148);
  }
  __calls[54].calls++;
  return 0;
}

int_4 _ssaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ mode_, real_4 _p_ 
resid_, real_4 _p_ rnorm_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, real_4 _p_ 
workd_, int_4 _p_ info_)
{
  static int_4 i_, ierr_, ipj_, irj_, ivj_, iter_, itry_, j_, msglvl_, infol_, jj_;
  static logical_4 first_, orth1_, orth2_, rstart_, step3_, step4_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, rnorm1_, wnorm_, safmin_, temp1_, xtemp_[2];
  int_4 _data_k_14, $9_, $14_, $17_, $18_;
  logical_4 $0_;
  real_4 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $10_, $11_, $12_, $13_, $15_, $16_;
  extern int_4 _scopy ();
  extern int_4 _sscal ();
  extern int_4 _sgemv ();
  extern int_4 _slascl ();
  extern real_4 _sdot ();
  extern real_4 _snrm2 ();
  extern real_4 _slamch ();
#define _data_n_14 1
  static logical_4 _data_l_14[_data_n_14] = {
    TRUE
  };
  if (__calls[55].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    first_ = _data_l_14[_data_k_14++];
  }
  if (first_) {
    first_ = FALSE;
    safmin_ = _slamch (_dc_197);
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.msaitr_;
    (*info_) = 0;
    step3_ = FALSE;
    step4_ = FALSE;
    rstart_ = FALSE;
    orth1_ = FALSE;
    orth2_ = FALSE;
    j_ = (*k_) + 1;
    ipj_ = 1;
    irj_ = ipj_ + (*n_);
    ivj_ = irj_ + (*n_);
  }
  if (step3_) {
    goto _l50;
  }
  if (step4_) {
    goto _l60;
  }
  if (orth1_) {
    goto _l70;
  }
  if (orth2_) {
    goto _l90;
  }
  if (rstart_) {
    goto _l30;
  }
  _l1000:;
  if (msglvl_ > 2) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_198);
    (void) _svout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_199);
  }
  if ((*rnorm_) > 0.0) {
    goto _l40;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_200);
  }
  timing_.nrstrt_ = timing_.nrstrt_ + 1;
  itry_ = 1;
  _l20:;
  rstart_ = TRUE;
  (*ido_) = 0;
  _l30:;
  (void) _sgetv0 (ido_, bmat_, &itry_, ($0_ = FALSE, &$0_), n_, &j_, v_, ldv_, resid_, rnorm_, ipntr_, workd_, &ierr_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if (ierr_ < 0) {
    itry_ = itry_ + 1;
    if (itry_ <= 3) {
      goto _l20;
    }
    (*info_) = j_ - 1;
    (void) _second (&t1_);
    timing_.tsaitr_ = timing_.tsaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    goto _l9000;
  }
  _l40:;
  (void) _scopy (n_, resid_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
  if ((*rnorm_) >= safmin_) {
    temp1_ = 1.0 / (*rnorm_);
    (void) _sscal (n_, &temp1_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
    (void) _sscal (n_, &temp1_, &workd_[ipj_ - 1], &_k1);
  }
  else {
    (void) _slascl (_dc_29, &i_, &i_, rnorm_, ($1_ = 1.0, &$1_), n_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], n_, &infol_);
    (void) _slascl (_dc_29, &i_, &i_, rnorm_, ($2_ = 1.0, &$2_), n_, &_k1, &workd_[ipj_ - 1], n_, &infol_);
  }
  step3_ = TRUE;
  timing_.nopx_ = timing_.nopx_ + 1;
  (void) _second (&t2_);
  (void) _scopy (n_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1, &workd_[ivj_ - 1], &_k1);
  ipntr_[0] = ivj_;
  ipntr_[1] = irj_;
  ipntr_[2] = ipj_;
  (*ido_) = 1;
  goto _l9000;
  _l50:;
  (void) _second (&t3_);
  timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  step3_ = FALSE;
  (void) _scopy (n_, &workd_[irj_ - 1], &_k1, resid_, &_k1);
  if ((*mode_) == 2) {
    goto _l65;
  }
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    step4_ = TRUE;
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l60:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  step4_ = FALSE;
  _l65:;
  if ((*mode_) == 2) {
    wnorm_ = _sdot (n_, resid_, &_k1, &workd_[ivj_ - 1], &_k1);
    wnorm_ = sqrtf (_abs (wnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_0) == 0)) {
    wnorm_ = _sdot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    wnorm_ = sqrtf (_abs (wnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    wnorm_ = _snrm2 (n_, resid_, &_k1);
  }
  if ((*mode_) != 2) {
    (void) _sgemv (_dc_150, n_, &j_, ($3_ = 1.0, &$3_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($4_ = 0.0, &$4_), &workd_[irj_ 
    - 1], &_k1);
  }
  else if ((*mode_) == 2) {
    (void) _sgemv (_dc_150, n_, &j_, ($5_ = 1.0, &$5_), v_, ldv_, &workd_[ivj_ - 1], &_k1, ($6_ = 0.0, &$6_), &workd_[irj_ 
    - 1], &_k1);
  }
  (void) _sgemv (_dc_3, n_, &j_, ($7_ = -1.0, &$7_), v_, ldv_, &workd_[irj_ - 1], &_k1, ($8_ = 1.0, &$8_), resid_, &_k1)
  ;
  h_[j_ - 1 + ((*ldh_)) * ((1))] = workd_[irj_ + j_ - 1 - 1];
  if (j_ == 1 || rstart_) {
    h_[j_ - 1 + ((*ldh_)) * ((0))] = 0.0;
  }
  else {
    h_[j_ - 1 + ((*ldh_)) * ((0))] = (*rnorm_);
  }
  (void) _second (&t4_);
  orth1_ = TRUE;
  iter_ = 0;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _scopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l70:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  orth1_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (*rnorm_) = _sdot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    (*rnorm_) = sqrtf (_abs ((*rnorm_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _snrm2 (n_, resid_, &_k1);
  }
  if ((*rnorm_) > 0.717 * wnorm_) {
    goto _l100;
  }
  timing_.nrorth_ = timing_.nrorth_ + 1;
  _l80:;
  if (msglvl_ > 2) {
    xtemp_[0] = wnorm_;
    xtemp_[1] = (*rnorm_);
    (void) _svout (&debug_.logfil_, ($9_ = 2, &$9_), xtemp_, &debug_.ndigit_, _dc_201);
  }
  (void) _sgemv (_dc_150, n_, &j_, ($10_ = 1.0, &$10_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($11_ = 0.0, &$11_), 
  &workd_[irj_ - 1], &_k1);
  (void) _sgemv (_dc_3, n_, &j_, ($12_ = -1.0, &$12_), v_, ldv_, &workd_[irj_ - 1], &_k1, ($13_ = 1.0, &$13_), resid_, 
  &_k1);
  if (j_ == 1 || rstart_) {
    h_[j_ - 1 + ((*ldh_)) * ((0))] = 0.0;
  }
  h_[j_ - 1 + ((*ldh_)) * ((1))] = h_[j_ - 1 + ((*ldh_)) * ((1))] + workd_[irj_ + j_ - 1 - 1];
  orth2_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _scopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l90:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm1_ = _sdot (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    rnorm1_ = sqrtf (_abs (rnorm1_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm1_ = _snrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 0 && iter_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_202);
    if (msglvl_ > 2) {
      xtemp_[0] = (*rnorm_);
      xtemp_[1] = rnorm1_;
      (void) _svout (&debug_.logfil_, ($14_ = 2, &$14_), xtemp_, &debug_.ndigit_, _dc_203);
    }
  }
  if (rnorm1_ > 0.717 * (*rnorm_)) {
    (*rnorm_) = rnorm1_;
  }
  else {
    timing_.nitref_ = timing_.nitref_ + 1;
    (*rnorm_) = rnorm1_;
    iter_ = iter_ + 1;
    if (iter_ <= 1) {
      goto _l80;
    }
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = 0.0;
    }
    (*rnorm_) = 0.0;
  }
  _l100:;
  rstart_ = FALSE;
  orth2_ = FALSE;
  (void) _second (&t5_);
  timing_.titref_ = timing_.titref_ + (t5_ - t4_);
  if (h_[j_ - 1 + ((*ldh_)) * ((0))] < 0.0) {
    h_[j_ - 1 + ((*ldh_)) * ((0))] = -h_[j_ - 1 + ((*ldh_)) * ((0))];
    if (j_ < (*k_) + (*np_)) {
      (void) _sscal (n_, ($15_ = -1.0, &$15_), &v_[0 + ((*ldv_)) * ((j_ + 1 - 1))], &_k1);
    }
    else {
      (void) _sscal (n_, ($16_ = -1.0, &$16_), resid_, &_k1);
    }
  }
  j_ = j_ + 1;
  if (j_ > (*k_) + (*np_)) {
    (void) _second (&t1_);
    timing_.tsaitr_ = timing_.tsaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    if (msglvl_ > 1) {
      (void) _svout (&debug_.logfil_, ($17_ = (*k_) + (*np_), &$17_), &h_[0 + ((*ldh_)) * ((1))], &debug_.ndigit_, _dc_204);
      if ((*k_) + (*np_) > 1) {
        (void) _svout (&debug_.logfil_, ($18_ = (*k_) + (*np_) - 1, &$18_), &h_[1 + ((*ldh_)) * ((0))], &debug_.ndigit_, 
        _dc_205);
      }
    }
    goto _l9000;
  }
  goto _l1000;
  _l9000:;
  __calls[55].calls++;
  return 0;
}

int_4 _ssapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, real_4 _p_ shift_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 
_p_ h_, int_4 _p_ ldh_, real_4 _p_ resid_, real_4 _p_ q_, int_4 _p_ ldq_, real_4 _p_ workd_)
{
  static int_4 i_, iend_, istart_, itop_, j_, jj_, kplusp_, msglvl_;
  static logical_4 first_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, a1_, a2_, a3_, a4_, big_, c_, epsmch_, f_, g_, r_, s_;
  int_4 _data_k_15, $5_, $8_;
  real_4 $0_, $1_, $2_, $3_, $4_, $6_, $7_;
  extern int_4 _saxpy ();
  extern int_4 _scopy ();
  extern int_4 _sscal ();
  extern int_4 _slacpy ();
  extern int_4 _slartg ();
  extern int_4 _slaset ();
  extern int_4 _sgemv ();
  extern real_4 _slamch ();
#define _data_n_15 1
  static logical_4 _data_l_15[_data_n_15] = {
    TRUE
  };
  if (__calls[56].calls == 0) {
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    first_ = _data_l_15[_data_k_15++];
  }
  if (first_) {
    epsmch_ = _slamch (_dc_49);
    first_ = FALSE;
  }
  itop_ = 1;
  (void) _second (&t0_);
  msglvl_ = debug_.msapps_;
  kplusp_ = (*kev_) + (*np_);
  (void) _slaset (_dc_36, &kplusp_, &kplusp_, ($0_ = 0.0, &$0_), ($1_ = 1.0, &$1_), q_, ldq_);
  if ((*np_) == 0) {
    goto _l9000;
  }
  for (jj_ = 1; jj_ <= (*np_); (jj_)++) {
    istart_ = itop_;
    _l20:;
    for (i_ = istart_; i_ <= kplusp_ - 1; (i_)++) {
      big_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((1))]);
      if (h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] <= epsmch_ * big_) {
        if (msglvl_ > 0) {
          (void) _ivout (&debug_.logfil_, &_k1, &i_, &debug_.ndigit_, _dc_206);
          (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_207);
          (void) _svout (&debug_.logfil_, &_k1, &h_[i_ + 1 - 1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_208);
        }
        h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] = 0.0;
        iend_ = i_;
        goto _l40;
      }
    }
    iend_ = kplusp_;
    _l40:;
    if (istart_ < iend_) {
      f_ = h_[istart_ - 1 + ((*ldh_)) * ((1))] - shift_[jj_ - 1];
      g_ = h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))];
      (void) _slartg (&f_, &g_, &c_, &s_, &r_);
      a1_ = c_ * h_[istart_ - 1 + ((*ldh_)) * ((1))] + s_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))];
      a2_ = c_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))] + s_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((1))];
      a4_ = c_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((1))] - s_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))];
      a3_ = c_ * h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))] - s_ * h_[istart_ - 1 + ((*ldh_)) * ((1))];
      h_[istart_ - 1 + ((*ldh_)) * ((1))] = c_ * a1_ + s_ * a2_;
      h_[istart_ + 1 - 1 + ((*ldh_)) * ((1))] = c_ * a4_ - s_ * a3_;
      h_[istart_ + 1 - 1 + ((*ldh_)) * ((0))] = c_ * a3_ + s_ * a4_;
      for (j_ = 1; j_ <= _min (istart_ + jj_, kplusp_); (j_)++) {
        a1_ = c_ * q_[j_ - 1 + ((*ldq_)) * ((istart_ - 1))] + s_ * q_[j_ - 1 + ((*ldq_)) * ((istart_ + 1 - 1))];
        q_[j_ - 1 + ((*ldq_)) * ((istart_ + 1 - 1))] = -s_ * q_[j_ - 1 + ((*ldq_)) * ((istart_ - 1))] + c_ * q_[j_ - 1 + 
        ((*ldq_)) * ((istart_ + 1 - 1))];
        q_[j_ - 1 + ((*ldq_)) * ((istart_ - 1))] = a1_;
      }
      for (i_ = istart_ + 1; i_ <= iend_ - 1; (i_)++) {
        f_ = h_[i_ - 1 + ((*ldh_)) * ((0))];
        g_ = s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))];
        h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] = c_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))];
        (void) _slartg (&f_, &g_, &c_, &s_, &r_);
        if (r_ < 0.0) {
          r_ = -r_;
          c_ = -c_;
          s_ = -s_;
        }
        h_[i_ - 1 + ((*ldh_)) * ((0))] = r_;
        a1_ = c_ * h_[i_ - 1 + ((*ldh_)) * ((1))] + s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))];
        a2_ = c_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] + s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((1))];
        a3_ = c_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] - s_ * h_[i_ - 1 + ((*ldh_)) * ((1))];
        a4_ = c_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((1))] - s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((0))];
        h_[i_ - 1 + ((*ldh_)) * ((1))] = c_ * a1_ + s_ * a2_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((1))] = c_ * a4_ - s_ * a3_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] = c_ * a3_ + s_ * a4_;
        for (j_ = 1; j_ <= _min (i_ + jj_, kplusp_); (j_)++) {
          a1_ = c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))];
          q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))] = -s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ 
          + 1 - 1))];
          q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] = a1_;
        }
      }
    }
    istart_ = iend_ + 1;
    if (h_[iend_ - 1 + ((*ldh_)) * ((0))] < 0.0) {
      h_[iend_ - 1 + ((*ldh_)) * ((0))] = -h_[iend_ - 1 + ((*ldh_)) * ((0))];
      (void) _sscal (&kplusp_, ($2_ = -1.0, &$2_), &q_[0 + ((*ldq_)) * ((iend_ - 1))], &_k1);
    }
    if (iend_ < kplusp_) {
      goto _l20;
    }
    for (i_ = itop_; i_ <= kplusp_ - 1; (i_)++) {
      if (h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] > 0.0) {
        goto _l90;
      }
      itop_ = itop_ + 1;
    }
    _l90:;
  }
  for (i_ = itop_; i_ <= kplusp_ - 1; (i_)++) {
    big_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((1))]) + _abs (h_[i_ + 1 - 1 + ((*ldh_)) * ((1))]);
    if (h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] <= epsmch_ * big_) {
      if (msglvl_ > 0) {
        (void) _ivout (&debug_.logfil_, &_k1, &i_, &debug_.ndigit_, _dc_206);
        (void) _svout (&debug_.logfil_, &_k1, &h_[i_ + 1 - 1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_208);
      }
      h_[i_ + 1 - 1 + ((*ldh_)) * ((0))] = 0.0;
    }
  }
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))] > 0.0) {
    (void) _sgemv (_dc_3, n_, &kplusp_, ($3_ = 1.0, &$3_), v_, ldv_, &q_[0 + ((*ldq_)) * (((*kev_) + 1 - 1))], &_k1, ($4_ = 
    0.0, &$4_), &workd_[(*n_) + 1 - 1], &_k1);
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    (void) _sgemv (_dc_3, n_, ($5_ = kplusp_ - i_ + 1, &$5_), ($6_ = 1.0, &$6_), v_, ldv_, &q_[0 + ((*ldq_)) * (((*kev_) - 
    i_ + 1 - 1))], &_k1, ($7_ = 0.0, &$7_), workd_, &_k1);
    (void) _scopy (n_, workd_, &_k1, &v_[0 + ((*ldv_)) * ((kplusp_ - i_ + 1 - 1))], &_k1);
  }
  (void) _slacpy (_dc_36, n_, kev_, &v_[0 + ((*ldv_)) * (((*np_) + 1 - 1))], ldv_, v_, ldv_);
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))] > 0.0) {
    (void) _scopy (n_, &workd_[(*n_) + 1 - 1], &_k1, &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1);
  }
  (void) _sscal (n_, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], resid_, &_k1);
  if (h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))] > 0.0) {
    (void) _saxpy (n_, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))], &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1, resid_, 
    &_k1);
  }
  if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &_k1, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_209);
    (void) _svout (&debug_.logfil_, &_k1, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_210);
    (void) _svout (&debug_.logfil_, kev_, &h_[0 + ((*ldh_)) * ((1))], &debug_.ndigit_, _dc_211);
    if ((*kev_) > 1) {
      (void) _svout (&debug_.logfil_, ($8_ = (*kev_) - 1, &$8_), &h_[1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_212);
    }
  }
  (void) _second (&t1_);
  timing_.tsapps_ = timing_.tsapps_ + (t1_ - t0_);
  _l9000:;
  __calls[56].calls++;
  return 0;
}

int_4 _ssaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, real_4 _p_ 
tol_, real_4 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, real_4 _p_ v_, int_4 
_p_ ldv_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ ritz_, real_4 _p_ bounds_, real_4 _p_ q_, int_4 _p_ ldq_, real_4 
_p_ workl_, int_4 _p_ ipntr_, real_4 _p_ workd_, int_4 _p_ info_)
{
  static int_4 ierr_, iter_, j_, kplusp_, msglvl_, nconv_, nevbef_, nev0_, np0_, nptemp_, nevd2_, nevm2_, kp_[3];
  static logical_4 cnorm_, getv0_, initv_, update_, ushift_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, rnorm_, temp_, eps23_;
  static char_3 wprime_;
  int_4 $0_, $2_, $3_, $8_, $9_;
  logical_4 $1_, $4_, $5_, $6_, $7_;
  extern int_4 _scopy ();
  extern int_4 _sswap ();
  extern real_4 _sdot ();
  extern real_4 _snrm2 ();
  extern real_4 _slamch ();
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.msaup2_;
    eps23_ = _slamch (_dc_49);
    eps23_ = powl (eps23_, 6.6666667e-1);
    nev0_ = (*nev_);
    np0_ = (*np_);
    kplusp_ = nev0_ + np0_;
    nconv_ = 0;
    iter_ = 0;
    getv0_ = TRUE;
    update_ = FALSE;
    ushift_ = FALSE;
    cnorm_ = FALSE;
    if ((*info_) != 0) {
      initv_ = TRUE;
      (*info_) = 0;
    }
    else {
      initv_ = FALSE;
    }
  }
  if (getv0_) {
    (void) _sgetv0 (ido_, bmat_, &_k1, &initv_, n_, &_k1, v_, ldv_, resid_, &rnorm_, ipntr_, workd_, info_);
    if ((*ido_) != 99) {
      goto _l9000;
    }
    if (rnorm_ == 0.0) {
      (*info_) = -9;
      goto _l1200;
    }
    getv0_ = FALSE;
    (*ido_) = 0;
  }
  if (update_) {
    goto _l20;
  }
  if (ushift_) {
    goto _l50;
  }
  if (cnorm_) {
    goto _l100;
  }
  (void) _ssaitr (ido_, bmat_, n_, &_k0, &nev0_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  _l1000:;
  iter_ = iter_ + 1;
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &iter_, &debug_.ndigit_, _dc_213);
  }
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, nev_, &debug_.ndigit_, _dc_214);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_215);
  }
  (*ido_) = 0;
  _l20:;
  update_ = TRUE;
  (void) _ssaitr (ido_, bmat_, n_, nev_, np_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  update_ = FALSE;
  if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_216);
  }
  (void) _sseigt (&rnorm_, &kplusp_, h_, ldh_, ritz_, bounds_, workl_, &ierr_);
  if (ierr_ != 0) {
    (*info_) = -8;
    goto _l1200;
  }
  (void) _scopy (&kplusp_, ritz_, &_k1, &workl_[kplusp_ + 1 - 1], &_k1);
  (void) _scopy (&kplusp_, bounds_, &_k1, &workl_[2 * kplusp_ + 1 - 1], &_k1);
  (*nev_) = nev0_;
  (*np_) = np0_;
  (void) _ssgets (ishift_, which_, nev_, np_, ritz_, bounds_, workl_);
  (void) _scopy (nev_, &bounds_[(*np_) + 1 - 1], &_k1, &workl_[(*np_) + 1 - 1], &_k1);
  (void) _ssconv (nev_, &ritz_[(*np_) + 1 - 1], &workl_[(*np_) + 1 - 1], tol_, &nconv_);
  if (msglvl_ > 2) {
    kp_[0] = (*nev_);
    kp_[1] = (*np_);
    kp_[2] = nconv_;
    (void) _ivout (&debug_.logfil_, ($0_ = 3, &$0_), kp_, &debug_.ndigit_, _dc_217);
    (void) _svout (&debug_.logfil_, &kplusp_, ritz_, &debug_.ndigit_, _dc_218);
    (void) _svout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_219);
  }
  nptemp_ = (*np_);
  for (j_ = 1; j_ <= nptemp_; (j_)++) {
    if (bounds_[j_ - 1] == 0.0) {
      (*np_) = (*np_) - 1;
      (*nev_) = (*nev_) + 1;
    }
  }
  if ((nconv_ >= nev0_) || (iter_ > (*mxiter_)) || ((*np_) == 0)) {
    if ((strcasecmp (which_, _dc_220) == 0)) {
      bufcpy (wprime_, _dc_221, 3);
      (void) _ssortr (wprime_, ($1_ = TRUE, &$1_), &kplusp_, ritz_, bounds_);
      nevd2_ = nev0_ / 2;
      nevm2_ = nev0_ - nevd2_;
      if ((*nev_) > 1) {
        (void) _sswap (($2_ = _min (nevd2_, (*np_)), &$2_), &ritz_[nevm2_ + 1 - 1], &_k1, &ritz_[_max (kplusp_ - nevd2_ + 1, 
        kplusp_ - (*np_) + 1) - 1], &_k1);
        (void) _sswap (($3_ = _min (nevd2_, (*np_)), &$3_), &bounds_[nevm2_ + 1 - 1], &_k1, &bounds_[_max (kplusp_ - nevd2_ + 
        1, kplusp_ - (*np_) + 1) - 1], &_k1);
      }
    }
    else {
      if ((strcasecmp (which_, _dc_59) == 0)) {
        bufcpy (wprime_, _dc_60, 3);
      }
      if ((strcasecmp (which_, _dc_60) == 0)) {
        bufcpy (wprime_, _dc_59, 3);
      }
      if ((strcasecmp (which_, _dc_222) == 0)) {
        bufcpy (wprime_, _dc_221, 3);
      }
      if ((strcasecmp (which_, _dc_221) == 0)) {
        bufcpy (wprime_, _dc_222, 3);
      }
      (void) _ssortr (wprime_, ($4_ = TRUE, &$4_), &kplusp_, ritz_, bounds_);
    }
    for (j_ = 1; j_ <= nev0_; (j_)++) {
      temp_ = _max (eps23_, _abs (ritz_[j_ - 1]));
      bounds_[j_ - 1] = bounds_[j_ - 1] / temp_;
    }
    bufcpy (wprime_, _dc_222, 3);
    (void) _ssortr (wprime_, ($5_ = TRUE, &$5_), &nev0_, bounds_, ritz_);
    for (j_ = 1; j_ <= nev0_; (j_)++) {
      temp_ = _max (eps23_, _abs (ritz_[j_ - 1]));
      bounds_[j_ - 1] = bounds_[j_ - 1] * temp_;
    }
    if ((strcasecmp (which_, _dc_220) == 0)) {
      bufcpy (wprime_, _dc_222, 3);
      (void) _ssortr (wprime_, ($6_ = TRUE, &$6_), &nconv_, ritz_, bounds_);
    }
    else {
      (void) _ssortr (which_, ($7_ = TRUE, &$7_), &nconv_, ritz_, bounds_);
    }
    h_[0 + ((*ldh_)) * ((0))] = rnorm_;
    if (msglvl_ > 1) {
      (void) _svout (&debug_.logfil_, &kplusp_, ritz_, &debug_.ndigit_, _dc_223);
      (void) _svout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_224);
    }
    if (iter_ > (*mxiter_) && nconv_ < (*nev_)) {
      (*info_) = 1;
    }
    if ((*np_) == 0 && nconv_ < nev0_) {
      (*info_) = 2;
    }
    (*np_) = nconv_;
    goto _l1100;
  }
  else if (nconv_ < (*nev_) && (*ishift_) == 1) {
    nevbef_ = (*nev_);
    (*nev_) = (*nev_) + _min (nconv_, (*np_) / 2);
    if ((*nev_) == 1 && kplusp_ >= 6) {
      (*nev_) = kplusp_ / 2;
    }
    else if ((*nev_) == 1 && kplusp_ > 2) {
      (*nev_) = 2;
    }
    (*np_) = kplusp_ - (*nev_);
    if (nevbef_ < (*nev_)) {
      (void) _ssgets (ishift_, which_, nev_, np_, ritz_, bounds_, workl_);
    }
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_225);
    if (msglvl_ > 1) {
      kp_[0] = (*nev_);
      kp_[1] = (*np_);
      (void) _ivout (&debug_.logfil_, ($8_ = 2, &$8_), kp_, &debug_.ndigit_, _dc_226);
      (void) _svout (&debug_.logfil_, nev_, &ritz_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_227);
      (void) _svout (&debug_.logfil_, nev_, &bounds_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_228);
    }
  }
  if ((*ishift_) == 0) {
    ushift_ = TRUE;
    (*ido_) = 3;
    goto _l9000;
  }
  _l50:;
  ushift_ = FALSE;
  if ((*ishift_) == 0) {
    (void) _scopy (np_, workl_, &_k1, ritz_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_229);
    (void) _svout (&debug_.logfil_, np_, workl_, &debug_.ndigit_, _dc_230);
    if ((*ishift_) == 1) {
      (void) _svout (&debug_.logfil_, np_, bounds_, &debug_.ndigit_, _dc_231);
    }
  }
  (void) _ssapps (n_, nev_, np_, ritz_, v_, ldv_, h_, ldh_, resid_, q_, ldq_, workd_);
  cnorm_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _scopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _scopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l100:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    rnorm_ = _sdot (n_, resid_, &_k1, workd_, &_k1);
    rnorm_ = sqrtf (_abs (rnorm_));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm_ = _snrm2 (n_, resid_, &_k1);
  }
  cnorm_ = FALSE;
  if (msglvl_ > 2) {
    (void) _svout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_232);
    (void) _svout (&debug_.logfil_, nev_, &h_[0 + ((*ldh_)) * ((1))], &debug_.ndigit_, _dc_233);
    (void) _svout (&debug_.logfil_, ($9_ = (*nev_) - 1, &$9_), &h_[1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_234);
  }
  goto _l1000;
  _l1100:;
  (*mxiter_) = iter_;
  (*nev_) = nconv_;
  _l1200:;
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tsaup2_ = t1_ - t0_;
  _l9000:;
  __calls[57].calls++;
  return 0;
}

int_4 _ssaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_, real_4 
_p_ resid_, int_4 _p_ ncv_, real_4 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_4 _p_ workd_, 
real_4 _p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, iq_, ishift_, iupd_, iw_, ldh_, ldq_, msglvl_, mxiter_, mode_, nb_, nev0_, next_, np_
  , ritz_, j_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 __fcnt, __rc;
  extern real_4 _slamch ();
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_239, _dc_239,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_240, _dc_240,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_241, _dc_241,
    FMT_TEXT, _dc_174, _dc_174,
    FMT_TEXT, _dc_242, _dc_242,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_243, _dc_243,
    FMT_TEXT, _dc_89, _dc_89,
    FMT_TEXT, _dc_244, _dc_244,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_239, _dc_239,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_245, _dc_245,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_239, _dc_239,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_1100_[] = {
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_92, _dc_92,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_93, _dc_93,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_94, _dc_94,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_96, _dc_96,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_97, _dc_97,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_98, _dc_98,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_99, _dc_99,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_246, _dc_246,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_102, _dc_102,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_103, _dc_103,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_104, _dc_104,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_247, _dc_247,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_106, _dc_106,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_107, _dc_107,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_108, _dc_108,
    FMT_REAL,"%12f","%12.6f",
    NULL, NULL, NULL
  };
  if ((*ido_) == 0) {
    (void) _sstats ();
    (void) _second (&t0_);
    msglvl_ = debug_.msaupd_;
    ierr_ = 0;
    ishift_ = iparam_[0];
    mxiter_ = iparam_[2];
    nb_ = 1;
    iupd_ = 1;
    mode_ = iparam_[6];
    if ((*n_) <= 0) {
      ierr_ = -1;
    }
    else if ((*nev_) <= 0) {
      ierr_ = -2;
    }
    else if ((*ncv_) <= (*nev_) || (*ncv_) > (*n_)) {
      ierr_ = -3;
    }
    np_ = (*ncv_) - (*nev_);
    if (mxiter_ <= 0) {
      ierr_ = -4;
    }
    if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_222) != 0) && 
      (strcasecmp (which_, _dc_221) != 0) && (strcasecmp (which_, _dc_220) != 0)) {
      ierr_ = -5;
    }
    if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
      ierr_ = -6;
    }
    if ((*lworkl_) < ((*ncv_) * (*ncv_)) + 8 * (*ncv_)) {
      ierr_ = -7;
    }
    if (mode_ < 1 || mode_ > 5) {
      ierr_ = -10;
    }
    else if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
      ierr_ = -11;
    }
    else if (ishift_ < 0 || ishift_ > 1) {
      ierr_ = -12;
    }
    else if ((*nev_) == 1 && (strcasecmp (which_, _dc_220) == 0)) {
      ierr_ = -13;
    }
    if (ierr_ != 0) {
      (*info_) = ierr_;
      (*ido_) = 99;
      goto _l9000;
    }
    if (nb_ <= 0) {
      nb_ = 1;
    }
    if ((*tol_) <= 0.0) {
      (*tol_) = _slamch (_dc_76);
    }
    np_ = (*ncv_) - (*nev_);
    nev0_ = (*nev_);
    for (j_ = 1; j_ <= ((*ncv_) * (*ncv_)) + 8 * (*ncv_); (j_)++) {
      workl_[j_ - 1] = 0.0;
    }
    ldh_ = (*ncv_);
    ldq_ = (*ncv_);
    ih_ = 1;
    ritz_ = ih_ + 2 * ldh_;
    bounds_ = ritz_ + (*ncv_);
    iq_ = bounds_ + (*ncv_);
    iw_ = iq_ + ((*ncv_) * (*ncv_));
    next_ = iw_ + 3 * (*ncv_);
    ipntr_[3] = next_;
    ipntr_[4] = ih_;
    ipntr_[5] = ritz_;
    ipntr_[6] = bounds_;
    ipntr_[10] = iw_;
  }
  (void) _ssaup2 (ido_, bmat_, n_, which_, &nev0_, &np_, tol_, resid_, &mode_, &iupd_, &ishift_, &mxiter_, v_, ldv_, 
  &workl_[ih_ - 1], &ldh_, &workl_[ritz_ - 1], &workl_[bounds_ - 1], &workl_[iq_ - 1], &ldq_, &workl_[iw_ - 1], ipntr_, 
  workd_, info_);
  if ((*ido_) == 3) {
    iparam_[7] = np_;
  }
  if ((*ido_) != 99) {
    goto _l9000;
  }
  iparam_[2] = mxiter_;
  iparam_[4] = np_;
  iparam_[8] = timing_.nopx_;
  iparam_[9] = timing_.nbx_;
  iparam_[10] = timing_.nrorth_;
  if ((*info_) < 0) {
    goto _l9000;
  }
  if ((*info_) == 2) {
    (*info_) = 3;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &mxiter_, &debug_.ndigit_, _dc_235);
    (void) _ivout (&debug_.logfil_, &_k1, &np_, &debug_.ndigit_, _dc_236);
    (void) _svout (&debug_.logfil_, &np_, &workl_[ritz_ - 1], &debug_.ndigit_, _dc_237);
    (void) _svout (&debug_.logfil_, &np_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_238);
  }
  (void) _second (&t1_);
  timing_.tsaupd_ = t1_ - t0_;
  if (msglvl_ > 0) {
    _fcheck ("arpack:ssaupd:650", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:650", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _fcheck ("arpack:ssaupd:651", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &mxiter_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nopx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nbx_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrorth_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nitref_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.nrstrt_, INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvopx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tmvbx_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsaupd_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsaup2_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsaitr_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.titref_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tgetv0_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tseigt_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsgets_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsapps_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    if ($f_1100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_1100_[__fcnt + 2], &timing_.tsconv_, REAL, 4);
    _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
    __fcnt += 3;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      if ($f_1100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("arpack:ssaupd:651", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _l1000:;
    _l1100:;
  }
  _l9000:;
  __calls[58].calls++;
  return 0;
}

int_4 _ssconv (int_4 _p_ n_, real_4 _p_ ritz_, real_4 _p_ bounds_, real_4 _p_ tol_, int_4 _p_ nconv_)
{
  static int_4 i_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, temp_, eps23_;
  extern real_4 _slamch ();
  (void) _second (&t0_);
  eps23_ = _slamch (_dc_49);
  eps23_ = powl (eps23_, 6.6666667e-1);
  (*nconv_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    temp_ = _max (eps23_, _abs (ritz_[i_ - 1]));
    if (bounds_[i_ - 1] <= (*tol_) * temp_) {
      (*nconv_) = (*nconv_) + 1;
    }
  }
  (void) _second (&t1_);
  timing_.tsconv_ = timing_.tsconv_ + (t1_ - t0_);
  __calls[59].calls++;
  return 0;
}

int_4 _sseigt (real_4 _p_ rnorm_, int_4 _p_ n_, real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ eig_, real_4 _p_ bounds_, 
real_4 _p_ workl_, int_4 _p_ ierr_)
{
  static int_4 i_, k_, msglvl_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 $0_, $1_;
  extern int_4 _scopy ();
  (void) _second (&t0_);
  msglvl_ = debug_.mseigt_;
  if (msglvl_ > 0) {
    (void) _svout (&debug_.logfil_, n_, &h_[0 + ((*ldh_)) * ((1))], &debug_.ndigit_, _dc_248);
    if ((*n_) > 1) {
      (void) _svout (&debug_.logfil_, ($0_ = (*n_) - 1, &$0_), &h_[1 + ((*ldh_)) * ((0))], &debug_.ndigit_, _dc_249);
    }
  }
  (void) _scopy (n_, &h_[0 + ((*ldh_)) * ((1))], &_k1, eig_, &_k1);
  (void) _scopy (($1_ = (*n_) - 1, &$1_), &h_[1 + ((*ldh_)) * ((0))], &_k1, workl_, &_k1);
  (void) _sstqrb (n_, eig_, workl_, bounds_, &workl_[(*n_) + 1 - 1], ierr_);
  if ((*ierr_) != 0) {
    goto _l9000;
  }
  if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, n_, bounds_, &debug_.ndigit_, _dc_250);
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    bounds_[k_ - 1] = (*rnorm_) * _abs (bounds_[k_ - 1]);
  }
  (void) _second (&t1_);
  timing_.tseigt_ = timing_.tseigt_ + (t1_ - t0_);
  _l9000:;
  __calls[60].calls++;
  return 0;
}

int_4 _ssesrt (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_4 _p_ x_, int_4 _p_ na_, real_4 _p_ a_, int_4 
_p_ lda_)
{
  static int_4 i_, igap_, j_;
  static real_4 temp_;
  extern int_4 _sswap ();
  igap_ = (*n_) / 2;
  if ((strcasecmp (which_, _dc_221) == 0)) {
    _l10:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l20:;
      if (j_ < 0) {
        goto _l30;
      }
      if (x_[j_] < x_[j_ + igap_]) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          (void) _sswap (na_, &a_[0 + ((*lda_)) * ((j_))], &_k1, &a_[0 + ((*lda_)) * ((j_ + igap_))], &_k1);
        }
      }
      else {
        goto _l30;
      }
      j_ = j_ - igap_;
      goto _l20;
      _l30:;
    }
    igap_ = igap_ / 2;
    goto _l10;
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    _l40:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l50:;
      if (j_ < 0) {
        goto _l60;
      }
      if (_abs (x_[j_]) < _abs (x_[j_ + igap_])) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          (void) _sswap (na_, &a_[0 + ((*lda_)) * ((j_))], &_k1, &a_[0 + ((*lda_)) * ((j_ + igap_))], &_k1);
        }
      }
      else {
        goto _l60;
      }
      j_ = j_ - igap_;
      goto _l50;
      _l60:;
    }
    igap_ = igap_ / 2;
    goto _l40;
  }
  else if ((strcasecmp (which_, _dc_222) == 0)) {
    _l70:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l80:;
      if (j_ < 0) {
        goto _l90;
      }
      if (x_[j_] > x_[j_ + igap_]) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          (void) _sswap (na_, &a_[0 + ((*lda_)) * ((j_))], &_k1, &a_[0 + ((*lda_)) * ((j_ + igap_))], &_k1);
        }
      }
      else {
        goto _l90;
      }
      j_ = j_ - igap_;
      goto _l80;
      _l90:;
    }
    igap_ = igap_ / 2;
    goto _l70;
  }
  else if ((strcasecmp (which_, _dc_59) == 0)) {
    _l100:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l110:;
      if (j_ < 0) {
        goto _l120;
      }
      if (_abs (x_[j_]) > _abs (x_[j_ + igap_])) {
        temp_ = x_[j_];
        x_[j_] = x_[j_ + igap_];
        x_[j_ + igap_] = temp_;
        if ((*apply_)) {
          (void) _sswap (na_, &a_[0 + ((*lda_)) * ((j_))], &_k1, &a_[0 + ((*lda_)) * ((j_ + igap_))], &_k1);
        }
      }
      else {
        goto _l120;
      }
      j_ = j_ - igap_;
      goto _l110;
      _l120:;
    }
    igap_ = igap_ / 2;
    goto _l100;
  }
  _l9000:;
  __calls[61].calls++;
  return 0;
}

int_4 _sseupd (logical_4 _p_ rvec_, char _p_ howmny_, logical_4 _p_ select_, real_4 _p_ d_, real_4 _p_ z_, int_4 _p_ 
ldz_, real_4 _p_ sigma_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_4 _p_ tol_, real_4 _p_ 
resid_, int_4 _p_ ncv_, real_4 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, real_4 _p_ workd_, real_4 
_p_ workl_, int_4 _p_ lworkl_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, ihb_, ihd_, iq_, iw_, j_, k_, ldh_, ldq_, mode_, msglvl_, nconv_, next_, ritz_, irz_, 
  ibd_, np_, ishift_, leftptr_, rghtptr_, numcnv_, jj_;
  static logical_4 reord_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_, bnorm2_, rnorm_, temp_, temp1_, eps23_;
  static char_7 type_;
  int_4 $0_;
  logical_4 $1_, $3_;
  real_4 $2_, $4_, $5_;
  extern int_4 _scopy ();
  extern int_4 _sger ();
  extern int_4 _sgeqr2 ();
  extern int_4 _slacpy ();
  extern int_4 _sorm2r ();
  extern int_4 _sscal ();
  extern int_4 _ssteqr ();
  extern real_4 _snrm2 ();
  extern real_4 _slamch ();
  msglvl_ = debug_.mseupd_;
  mode_ = iparam_[6];
  nconv_ = iparam_[4];
  (*info_) = 0;
  if (nconv_ == 0) {
    goto _l9000;
  }
  ierr_ = 0;
  if (nconv_ <= 0) {
    ierr_ = -14;
  }
  if ((*n_) <= 0) {
    ierr_ = -1;
  }
  if ((*nev_) <= 0) {
    ierr_ = -2;
  }
  if ((*ncv_) <= (*nev_) || (*ncv_) > (*n_)) {
    ierr_ = -3;
  }
  if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_222) != 0) && 
    (strcasecmp (which_, _dc_221) != 0) && (strcasecmp (which_, _dc_220) != 0)) {
    ierr_ = -5;
  }
  if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
    ierr_ = -6;
  }
  if (((strcasecmp (howmny_, _dc_44) != 0) && (strcasecmp (howmny_, _dc_117) != 0) && (strcasecmp (howmny_, _dc_118) != 
    0)) && (*rvec_)) {
    ierr_ = -15;
  }
  if ((*rvec_) && (strcasecmp (howmny_, _dc_118) == 0)) {
    ierr_ = -16;
  }
  if ((*rvec_) && (*lworkl_) < ((*ncv_) * (*ncv_)) + 8 * (*ncv_)) {
    ierr_ = -7;
  }
  if (mode_ == 1 || mode_ == 2) {
    bufcpy (type_, _dc_119, 7);
  }
  else if (mode_ == 3) {
    bufcpy (type_, _dc_120, 7);
  }
  else if (mode_ == 4) {
    bufcpy (type_, _dc_251, 7);
  }
  else if (mode_ == 5) {
    bufcpy (type_, _dc_252, 7);
  }
  else {
    ierr_ = -10;
  }
  if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
    ierr_ = -11;
  }
  if ((*nev_) == 1 && (strcasecmp (which_, _dc_220) == 0)) {
    ierr_ = -12;
  }
  if (ierr_ != 0) {
    (*info_) = ierr_;
    goto _l9000;
  }
  ih_ = ipntr_[4];
  ritz_ = ipntr_[5];
  bounds_ = ipntr_[6];
  ldh_ = (*ncv_);
  ldq_ = (*ncv_);
  ihd_ = bounds_ + ldh_;
  ihb_ = ihd_ + ldh_;
  iq_ = ihb_ + ldh_;
  iw_ = iq_ + ldh_ * (*ncv_);
  next_ = iw_ + 2 * (*ncv_);
  ipntr_[3] = next_;
  ipntr_[7] = ihd_;
  ipntr_[8] = ihb_;
  ipntr_[9] = iq_;
  irz_ = ipntr_[10] + (*ncv_);
  ibd_ = irz_ + (*ncv_);
  eps23_ = _slamch (_dc_49);
  eps23_ = powl (eps23_, 6.6666667e-1);
  rnorm_ = workl_[ih_ - 1];
  if ((strcasecmp (bmat_, _dc_1) == 0)) {
    bnorm2_ = rnorm_;
  }
  else if ((strcasecmp (bmat_, _dc_0) == 0)) {
    bnorm2_ = _snrm2 (n_, workd_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _svout (&debug_.logfil_, ncv_, &workl_[irz_ - 1], &debug_.ndigit_, _dc_253);
    (void) _svout (&debug_.logfil_, ncv_, &workl_[ibd_ - 1], &debug_.ndigit_, _dc_254);
  }
  if ((*rvec_)) {
    reord_ = FALSE;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      workl_[bounds_ + j_ - 1 - 1] = j_;
      select_[j_ - 1] = FALSE;
    }
    np_ = (*ncv_) - (*nev_);
    ishift_ = 0;
    (void) _ssgets (&ishift_, which_, nev_, &np_, &workl_[irz_ - 1], &workl_[bounds_ - 1], workl_);
    if (msglvl_ > 2) {
      (void) _svout (&debug_.logfil_, ncv_, &workl_[irz_ - 1], &debug_.ndigit_, _dc_255);
      (void) _svout (&debug_.logfil_, ncv_, &workl_[bounds_ - 1], &debug_.ndigit_, _dc_256);
    }
    numcnv_ = 0;
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      temp1_ = _max (eps23_, _abs (workl_[irz_ + (*ncv_) - j_ - 1]));
      jj_ = workl_[bounds_ + (*ncv_) - j_ - 1];
      if (numcnv_ < nconv_ && workl_[ibd_ + jj_ - 1 - 1] <= (*tol_) * temp1_) {
        select_[jj_ - 1] = TRUE;
        numcnv_ = numcnv_ + 1;
        if (jj_ > (*nev_)) {
          reord_ = TRUE;
        }
      }
    }
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &numcnv_, &debug_.ndigit_, _dc_257);
      (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_258);
    }
    if (numcnv_ != nconv_) {
      (*info_) = -17;
      goto _l9000;
    }
    (void) _scopy (($0_ = (*ncv_) - 1, &$0_), &workl_[ih_ + 1 - 1], &_k1, &workl_[ihb_ - 1], &_k1);
    (void) _scopy (ncv_, &workl_[ih_ + ldh_ - 1], &_k1, &workl_[ihd_ - 1], &_k1);
    (void) _ssteqr (_dc_259, ncv_, &workl_[ihd_ - 1], &workl_[ihb_ - 1], &workl_[iq_ - 1], &ldq_, &workl_[iw_ - 1], &ierr_)
    ;
    if (ierr_ != 0) {
      (*info_) = -8;
      goto _l9000;
    }
    if (msglvl_ > 1) {
      (void) _scopy (ncv_, &workl_[iq_ + (*ncv_) - 1 - 1], &ldq_, &workl_[iw_ - 1], &_k1);
      (void) _svout (&debug_.logfil_, ncv_, &workl_[ihd_ - 1], &debug_.ndigit_, _dc_260);
      (void) _svout (&debug_.logfil_, ncv_, &workl_[iw_ - 1], &debug_.ndigit_, _dc_261);
    }
    if (reord_) {
      leftptr_ = 1;
      rghtptr_ = (*ncv_);
      if ((*ncv_) == 1) {
        goto _l30;
      }
      _l20:;
      if (select_[leftptr_ - 1]) {
        leftptr_ = leftptr_ + 1;
      }
      else if (! (select_[rghtptr_ - 1])) {
        rghtptr_ = rghtptr_ - 1;
      }
      else {
        temp_ = workl_[ihd_ + leftptr_ - 1 - 1];
        workl_[ihd_ + leftptr_ - 1 - 1] = workl_[ihd_ + rghtptr_ - 1 - 1];
        workl_[ihd_ + rghtptr_ - 1 - 1] = temp_;
        (void) _scopy (ncv_, &workl_[iq_ + (*ncv_) * (leftptr_ - 1) - 1], &_k1, &workl_[iw_ - 1], &_k1);
        (void) _scopy (ncv_, &workl_[iq_ + (*ncv_) * (rghtptr_ - 1) - 1], &_k1, &workl_[iq_ + (*ncv_) * (leftptr_ - 1) - 1], 
        &_k1);
        (void) _scopy (ncv_, &workl_[iw_ - 1], &_k1, &workl_[iq_ + (*ncv_) * (rghtptr_ - 1) - 1], &_k1);
        leftptr_ = leftptr_ + 1;
        rghtptr_ = rghtptr_ - 1;
      }
      if (leftptr_ < rghtptr_) {
        goto _l20;
      }
      _l30:;
    }
    if (msglvl_ > 2) {
      (void) _svout (&debug_.logfil_, ncv_, &workl_[ihd_ - 1], &debug_.ndigit_, _dc_262);
    }
    (void) _scopy (&nconv_, &workl_[ihd_ - 1], &_k1, d_, &_k1);
  }
  else {
    (void) _scopy (&nconv_, &workl_[ritz_ - 1], &_k1, d_, &_k1);
    (void) _scopy (ncv_, &workl_[ritz_ - 1], &_k1, &workl_[ihd_ - 1], &_k1);
  }
  if ((strcasecmp (type_, _dc_119) == 0)) {
    if ((*rvec_)) {
      (void) _ssesrt (_dc_222, rvec_, &nconv_, d_, ncv_, &workl_[iq_ - 1], &ldq_);
    }
    else {
      (void) _scopy (ncv_, &workl_[bounds_ - 1], &_k1, &workl_[ihb_ - 1], &_k1);
    }
  }
  else {
    (void) _scopy (ncv_, &workl_[ihd_ - 1], &_k1, &workl_[iw_ - 1], &_k1);
    if ((strcasecmp (type_, _dc_120) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihd_ + k_ - 1 - 1] = 1.0 / workl_[ihd_ + k_ - 1 - 1] + (*sigma_);
      }
    }
    else if ((strcasecmp (type_, _dc_251) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihd_ + k_ - 1 - 1] = (*sigma_) * workl_[ihd_ + k_ - 1 - 1] / (workl_[ihd_ + k_ - 1 - 1] - 1.0);
      }
    }
    else if ((strcasecmp (type_, _dc_252) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihd_ + k_ - 1 - 1] = (*sigma_) * (workl_[ihd_ + k_ - 1 - 1] + 1.0) / (workl_[ihd_ + k_ - 1 - 1] - 1.0);
      }
    }
    (void) _scopy (&nconv_, &workl_[ihd_ - 1], &_k1, d_, &_k1);
    (void) _ssortr (_dc_222, ($1_ = TRUE, &$1_), &nconv_, &workl_[ihd_ - 1], &workl_[iw_ - 1]);
    if ((*rvec_)) {
      (void) _ssesrt (_dc_222, rvec_, &nconv_, d_, ncv_, &workl_[iq_ - 1], &ldq_);
    }
    else {
      (void) _scopy (ncv_, &workl_[bounds_ - 1], &_k1, &workl_[ihb_ - 1], &_k1);
      (void) _sscal (ncv_, ($2_ = bnorm2_ / rnorm_, &$2_), &workl_[ihb_ - 1], &_k1);
      (void) _ssortr (_dc_222, ($3_ = TRUE, &$3_), &nconv_, d_, &workl_[ihb_ - 1]);
    }
  }
  if ((*rvec_) && (strcasecmp (howmny_, _dc_44) == 0)) {
    (void) _sgeqr2 (ncv_, &nconv_, &workl_[iq_ - 1], &ldq_, &workl_[iw_ + (*ncv_) - 1], &workl_[ihb_ - 1], &ierr_);
    (void) _sorm2r (_dc_112, _dc_134, n_, ncv_, &nconv_, &workl_[iq_ - 1], &ldq_, &workl_[iw_ + (*ncv_) - 1], v_, ldv_, 
    &workd_[(*n_) + 1 - 1], &ierr_);
    (void) _slacpy (_dc_36, n_, &nconv_, v_, ldv_, z_, ldz_);
    for (j_ = 1; j_ <= (*ncv_) - 1; (j_)++) {
      workl_[ihb_ + j_ - 1 - 1] = 0.0;
    }
    workl_[ihb_ + (*ncv_) - 1 - 1] = 1.0;
    (void) _sorm2r (_dc_158, _dc_263, ncv_, &_k1, &nconv_, &workl_[iq_ - 1], &ldq_, &workl_[iw_ + (*ncv_) - 1], 
    &workl_[ihb_ - 1], ncv_, &temp_, &ierr_);
  }
  else if ((*rvec_) && (strcasecmp (howmny_, _dc_118) == 0)) {
  }
  if ((strcasecmp (type_, _dc_119) == 0) && (*rvec_)) {
    for (j_ = 1; j_ <= (*ncv_); (j_)++) {
      workl_[ihb_ + j_ - 1 - 1] = rnorm_ * _abs (workl_[ihb_ + j_ - 1 - 1]);
    }
  }
  else if ((strcasecmp (type_, _dc_119) != 0) && (*rvec_)) {
    (void) _sscal (ncv_, &bnorm2_, &workl_[ihb_ - 1], &_k1);
    if ((strcasecmp (type_, _dc_120) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihb_ + k_ - 1 - 1] = _abs (workl_[ihb_ + k_ - 1 - 1]) / (workl_[iw_ + k_ - 1 - 1] * workl_[iw_ + k_ - 1 - 1]);
      }
    }
    else if ((strcasecmp (type_, _dc_251) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihb_ + k_ - 1 - 1] = (*sigma_) * _abs (workl_[ihb_ + k_ - 1 - 1]) / ($4_ = (workl_[iw_ + k_ - 1 - 1] - 1.0), $4_ 
        * $4_);
      }
    }
    else if ((strcasecmp (type_, _dc_252) == 0)) {
      for (k_ = 1; k_ <= (*ncv_); (k_)++) {
        workl_[ihb_ + k_ - 1 - 1] = _abs (workl_[ihb_ + k_ - 1 - 1] / workl_[iw_ + k_ - 1 - 1] * (workl_[iw_ + k_ - 1 - 1] - 
        1.0));
      }
    }
  }
  if ((strcasecmp (type_, _dc_119) != 0) && msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &nconv_, d_, &debug_.ndigit_, _dc_264);
    (void) _svout (&debug_.logfil_, &nconv_, &workl_[ihb_ - 1], &debug_.ndigit_, _dc_265);
  }
  else if (msglvl_ > 1) {
    (void) _svout (&debug_.logfil_, &nconv_, d_, &debug_.ndigit_, _dc_266);
    (void) _svout (&debug_.logfil_, &nconv_, &workl_[ihb_ - 1], &debug_.ndigit_, _dc_267);
  }
  if ((*rvec_) && ((strcasecmp (type_, _dc_120) == 0) || (strcasecmp (type_, _dc_252) == 0))) {
    for (k_ = 0; k_ <= nconv_ - 1; (k_)++) {
      workl_[iw_ + k_ - 1] = workl_[iq_ + k_ * ldq_ + (*ncv_) - 1 - 1] / workl_[iw_ + k_ - 1];
    }
  }
  else if ((*rvec_) && (strcasecmp (type_, _dc_251) == 0)) {
    for (k_ = 0; k_ <= nconv_ - 1; (k_)++) {
      workl_[iw_ + k_ - 1] = workl_[iq_ + k_ * ldq_ + (*ncv_) - 1 - 1] / (workl_[iw_ + k_ - 1] - 1.0);
    }
  }
  if ((strcasecmp (type_, _dc_119) != 0)) {
    (void) _sger (n_, &nconv_, ($5_ = 1.0, &$5_), resid_, &_k1, &workl_[iw_ - 1], &_k1, z_, ldz_);
  }
  _l9000:;
  __calls[62].calls++;
  return 0;
}

int_4 _ssgets (int_4 _p_ ishift_, char _p_ which_, int_4 _p_ kev_, int_4 _p_ np_, real_4 _p_ ritz_, real_4 _p_ bounds_, 
real_4 _p_ shifts_)
{
  static int_4 kevd2_, msglvl_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 $1_, $2_, $3_, $5_, $7_, $8_;
  logical_4 $0_, $4_, $6_;
  extern int_4 _sswap ();
  extern int_4 _scopy ();
  (void) _second (&t0_);
  msglvl_ = debug_.msgets_;
  if ((strcasecmp (which_, _dc_220) == 0)) {
    (void) _ssortr (_dc_222, ($0_ = TRUE, &$0_), ($1_ = (*kev_) + (*np_), &$1_), ritz_, bounds_);
    kevd2_ = (*kev_) / 2;
    if ((*kev_) > 1) {
      (void) _sswap (($2_ = _min (kevd2_, (*np_)), &$2_), ritz_, &_k1, &ritz_[_max (kevd2_, (*np_)) + 1 - 1], &_k1);
      (void) _sswap (($3_ = _min (kevd2_, (*np_)), &$3_), bounds_, &_k1, &bounds_[_max (kevd2_, (*np_)) + 1 - 1], &_k1);
    }
  }
  else {
    (void) _ssortr (which_, ($4_ = TRUE, &$4_), ($5_ = (*kev_) + (*np_), &$5_), ritz_, bounds_);
  }
  if ((*ishift_) == 1 && (*np_) > 0) {
    (void) _ssortr (_dc_60, ($6_ = TRUE, &$6_), np_, bounds_, ritz_);
    (void) _scopy (np_, ritz_, &_k1, shifts_, &_k1);
  }
  (void) _second (&t1_);
  timing_.tsgets_ = timing_.tsgets_ + (t1_ - t0_);
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_268);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_269);
    (void) _svout (&debug_.logfil_, ($7_ = (*kev_) + (*np_), &$7_), ritz_, &debug_.ndigit_, _dc_270);
    (void) _svout (&debug_.logfil_, ($8_ = (*kev_) + (*np_), &$8_), bounds_, &debug_.ndigit_, _dc_271);
  }
  __calls[63].calls++;
  return 0;
}

int_4 _ssortc (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_4 _p_ xreal_, real_4 _p_ ximag_, real_4 _p_ y_
)
{
  static int_4 i_, igap_, j_;
  static real_4 temp_, temp1_, temp2_;
  extern real_4 _slapy2 ();
  igap_ = (*n_) / 2;
  if ((strcasecmp (which_, _dc_59) == 0)) {
    _l10:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l20:;
      if (j_ < 0) {
        goto _l30;
      }
      temp1_ = _slapy2 (&xreal_[j_], &ximag_[j_]);
      temp2_ = _slapy2 (&xreal_[j_ + igap_], &ximag_[j_ + igap_]);
      if (temp1_ > temp2_) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l30;
      }
      j_ = j_ - igap_;
      goto _l20;
      _l30:;
    }
    igap_ = igap_ / 2;
    goto _l10;
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    _l40:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l50:;
      if (j_ < 0) {
        goto _l60;
      }
      temp1_ = _slapy2 (&xreal_[j_], &ximag_[j_]);
      temp2_ = _slapy2 (&xreal_[j_ + igap_], &ximag_[j_ + igap_]);
      if (temp1_ < temp2_) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l60;
      }
      j_ = j_ - igap_;
      goto _l50;
      _l60:;
    }
    igap_ = igap_ / 2;
    goto _l40;
  }
  else if ((strcasecmp (which_, _dc_61) == 0)) {
    _l70:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l80:;
      if (j_ < 0) {
        goto _l90;
      }
      if (xreal_[j_] > xreal_[j_ + igap_]) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l90;
      }
      j_ = j_ - igap_;
      goto _l80;
      _l90:;
    }
    igap_ = igap_ / 2;
    goto _l70;
  }
  else if ((strcasecmp (which_, _dc_62) == 0)) {
    _l100:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l110:;
      if (j_ < 0) {
        goto _l120;
      }
      if (xreal_[j_] < xreal_[j_ + igap_]) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l120;
      }
      j_ = j_ - igap_;
      goto _l110;
      _l120:;
    }
    igap_ = igap_ / 2;
    goto _l100;
  }
  else if ((strcasecmp (which_, _dc_63) == 0)) {
    _l130:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l140:;
      if (j_ < 0) {
        goto _l150;
      }
      if (_abs (ximag_[j_]) > _abs (ximag_[j_ + igap_])) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l150;
      }
      j_ = j_ - igap_;
      goto _l140;
      _l150:;
    }
    igap_ = igap_ / 2;
    goto _l130;
  }
  else if ((strcasecmp (which_, _dc_64) == 0)) {
    _l160:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l170:;
      if (j_ < 0) {
        goto _l180;
      }
      if (_abs (ximag_[j_]) < _abs (ximag_[j_ + igap_])) {
        temp_ = xreal_[j_];
        xreal_[j_] = xreal_[j_ + igap_];
        xreal_[j_ + igap_] = temp_;
        temp_ = ximag_[j_];
        ximag_[j_] = ximag_[j_ + igap_];
        ximag_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = y_[j_];
          y_[j_] = y_[j_ + igap_];
          y_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l180;
      }
      j_ = j_ - igap_;
      goto _l170;
      _l180:;
    }
    igap_ = igap_ / 2;
    goto _l160;
  }
  _l9000:;
  __calls[64].calls++;
  return 0;
}

int_4 _ssortr (char _p_ which_, logical_4 _p_ apply_, int_4 _p_ n_, real_4 _p_ x1_, real_4 _p_ x2_)
{
  static int_4 i_, igap_, j_;
  static real_4 temp_;
  igap_ = (*n_) / 2;
  if ((strcasecmp (which_, _dc_221) == 0)) {
    _l10:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l20:;
      if (j_ < 0) {
        goto _l30;
      }
      if (x1_[j_] < x1_[j_ + igap_]) {
        temp_ = x1_[j_];
        x1_[j_] = x1_[j_ + igap_];
        x1_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = x2_[j_];
          x2_[j_] = x2_[j_ + igap_];
          x2_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l30;
      }
      j_ = j_ - igap_;
      goto _l20;
      _l30:;
    }
    igap_ = igap_ / 2;
    goto _l10;
  }
  else if ((strcasecmp (which_, _dc_60) == 0)) {
    _l40:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l50:;
      if (j_ < 0) {
        goto _l60;
      }
      if (_abs (x1_[j_]) < _abs (x1_[j_ + igap_])) {
        temp_ = x1_[j_];
        x1_[j_] = x1_[j_ + igap_];
        x1_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = x2_[j_];
          x2_[j_] = x2_[j_ + igap_];
          x2_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l60;
      }
      j_ = j_ - igap_;
      goto _l50;
      _l60:;
    }
    igap_ = igap_ / 2;
    goto _l40;
  }
  else if ((strcasecmp (which_, _dc_222) == 0)) {
    _l70:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l80:;
      if (j_ < 0) {
        goto _l90;
      }
      if (x1_[j_] > x1_[j_ + igap_]) {
        temp_ = x1_[j_];
        x1_[j_] = x1_[j_ + igap_];
        x1_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = x2_[j_];
          x2_[j_] = x2_[j_ + igap_];
          x2_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l90;
      }
      j_ = j_ - igap_;
      goto _l80;
      _l90:;
    }
    igap_ = igap_ / 2;
    goto _l70;
  }
  else if ((strcasecmp (which_, _dc_59) == 0)) {
    _l100:;
    if (igap_ == 0) {
      goto _l9000;
    }
    for (i_ = igap_; i_ <= (*n_) - 1; (i_)++) {
      j_ = i_ - igap_;
      _l110:;
      if (j_ < 0) {
        goto _l120;
      }
      if (_abs (x1_[j_]) > _abs (x1_[j_ + igap_])) {
        temp_ = x1_[j_];
        x1_[j_] = x1_[j_ + igap_];
        x1_[j_ + igap_] = temp_;
        if ((*apply_)) {
          temp_ = x2_[j_];
          x2_[j_] = x2_[j_ + igap_];
          x2_[j_ + igap_] = temp_;
        }
      }
      else {
        goto _l120;
      }
      j_ = j_ - igap_;
      goto _l110;
      _l120:;
    }
    igap_ = igap_ / 2;
    goto _l100;
  }
  _l9000:;
  __calls[65].calls++;
  return 0;
}

int_4 _sstatn (void)
{
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  timing_.nopx_ = 0;
  timing_.nbx_ = 0;
  timing_.nrorth_ = 0;
  timing_.nitref_ = 0;
  timing_.nrstrt_ = 0;
  timing_.tnaupd_ = 0.0;
  timing_.tnaup2_ = 0.0;
  timing_.tnaitr_ = 0.0;
  timing_.tneigh_ = 0.0;
  timing_.tngets_ = 0.0;
  timing_.tnapps_ = 0.0;
  timing_.tnconv_ = 0.0;
  timing_.titref_ = 0.0;
  timing_.tgetv0_ = 0.0;
  timing_.trvec_ = 0.0;
  timing_.tmvopx_ = 0.0;
  timing_.tmvbx_ = 0.0;
  __calls[66].calls++;
  return 0;
}

int_4 _sstats (void)
{
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  timing_.nopx_ = 0;
  timing_.nbx_ = 0;
  timing_.nrorth_ = 0;
  timing_.nitref_ = 0;
  timing_.nrstrt_ = 0;
  timing_.tsaupd_ = 0.0;
  timing_.tsaup2_ = 0.0;
  timing_.tsaitr_ = 0.0;
  timing_.tseigt_ = 0.0;
  timing_.tsgets_ = 0.0;
  timing_.tsapps_ = 0.0;
  timing_.tsconv_ = 0.0;
  timing_.titref_ = 0.0;
  timing_.tgetv0_ = 0.0;
  timing_.trvec_ = 0.0;
  timing_.tmvopx_ = 0.0;
  timing_.tmvbx_ = 0.0;
  __calls[67].calls++;
  return 0;
}

int_4 _sstqrb (int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ z_, real_4 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, icompz_, ii_, iscale_, j_, jtot_, k_, l_, l1_, lend_, lendm1_, lendp1_, lendsv_, lm1_, lsv_, m_, mm_, 
  mm1_, nm1_, nmaxit_;
  static real_4 anorm_, b_, c_, eps_, eps2_, f_, g_, p_, r_, rt1_, rt2_, s_, safmax_, safmin_, ssfmax_, ssfmin_, tst_;
  int_4 $0_, $1_, $2_, $3_, $4_, $9_, $10_, $11_, $12_;
  real_4 $5_, $6_, $7_, $8_;
  extern real_4 _slamch ();
  extern real_4 _slanst ();
  extern real_4 _slapy2 ();
  extern int_4 _slae2 ();
  extern int_4 _slaev2 ();
  extern int_4 _slartg ();
  extern int_4 _slascl ();
  extern int_4 _slasr ();
  extern int_4 _slasrt ();
  (*info_) = 0;
  icompz_ = 2;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*n_) == 1) {
    if (icompz_ == 2) {
      z_[0] = 1.0;
    }
    goto _l0;
  }
  eps_ = _slamch (_dc_272);
  eps2_ = (eps_ * eps_);
  safmin_ = _slamch (_dc_118);
  safmax_ = 1.0 / safmin_;
  ssfmax_ = sqrtf (safmax_) / 3.0;
  ssfmin_ = sqrtf (safmin_) / eps2_;
  if (icompz_ == 2) {
    for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
      z_[j_ - 1] = 0.0;
    }
    z_[(*n_) - 1] = 1.0;
  }
  nmaxit_ = (*n_) * 30;
  jtot_ = 0;
  l1_ = 1;
  nm1_ = (*n_) - 1;
  _l10:;
  if (l1_ > (*n_)) {
    goto _l160;
  }
  if (l1_ > 1) {
    e_[l1_ - 1 - 1] = 0.0;
  }
  if (l1_ <= nm1_) {
    for (m_ = l1_; m_ <= nm1_; (m_)++) {
      tst_ = _abs (e_[m_ - 1]);
      if (tst_ == 0.0) {
        goto _l30;
      }
      if (tst_ <= (sqrtf (_abs (d_[m_ - 1])) * sqrtf (_abs (d_[m_ + 1 - 1]))) * eps_) {
        e_[m_ - 1] = 0.0;
        goto _l30;
      }
    }
  }
  m_ = (*n_);
  _l30:;
  l_ = l1_;
  lsv_ = l_;
  lend_ = m_;
  lendsv_ = lend_;
  l1_ = m_ + 1;
  if (lend_ == l_) {
    goto _l10;
  }
  anorm_ = _slanst (_dc_1, ($0_ = lend_ - l_ + 1, &$0_), &d_[l_ - 1], &e_[l_ - 1]);
  iscale_ = 0;
  if (anorm_ == 0.0) {
    goto _l10;
  }
  if (anorm_ > ssfmax_) {
    iscale_ = 1;
    (void) _slascl (_dc_0, &_k0, &_k0, &anorm_, &ssfmax_, ($1_ = lend_ - l_ + 1, &$1_), &_k1, &d_[l_ - 1], n_, info_);
    (void) _slascl (_dc_0, &_k0, &_k0, &anorm_, &ssfmax_, ($2_ = lend_ - l_, &$2_), &_k1, &e_[l_ - 1], n_, info_);
  }
  else if (anorm_ < ssfmin_) {
    iscale_ = 2;
    (void) _slascl (_dc_0, &_k0, &_k0, &anorm_, &ssfmin_, ($3_ = lend_ - l_ + 1, &$3_), &_k1, &d_[l_ - 1], n_, info_);
    (void) _slascl (_dc_0, &_k0, &_k0, &anorm_, &ssfmin_, ($4_ = lend_ - l_, &$4_), &_k1, &e_[l_ - 1], n_, info_);
  }
  if (_abs (d_[lend_ - 1]) < _abs (d_[l_ - 1])) {
    lend_ = lsv_;
    l_ = lendsv_;
  }
  if (lend_ > l_) {
    _l40:;
    if (l_ != lend_) {
      lendm1_ = lend_ - 1;
      for (m_ = l_; m_ <= lendm1_; (m_)++) {
        tst_ = ($5_ = _abs (e_[m_ - 1]), $5_ * $5_);
        if (tst_ <= (eps2_ * _abs (d_[m_ - 1])) * _abs (d_[m_ + 1 - 1]) + safmin_) {
          goto _l60;
        }
      }
    }
    m_ = lend_;
    _l60:;
    if (m_ < lend_) {
      e_[m_ - 1] = 0.0;
    }
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l80;
    }
    if (m_ == l_ + 1) {
      if (icompz_ > 0) {
        (void) _slaev2 (&d_[l_ - 1], &e_[l_ - 1], &d_[l_ + 1 - 1], &rt1_, &rt2_, &c_, &s_);
        work_[l_ - 1] = c_;
        work_[(*n_) - 1 + l_ - 1] = s_;
        tst_ = z_[l_ + 1 - 1];
        z_[l_ + 1 - 1] = c_ * tst_ - s_ * z_[l_ - 1];
        z_[l_ - 1] = s_ * tst_ + c_ * z_[l_ - 1];
      }
      else {
        (void) _slae2 (&d_[l_ - 1], &e_[l_ - 1], &d_[l_ + 1 - 1], &rt1_, &rt2_);
      }
      d_[l_ - 1] = rt1_;
      d_[l_ + 1 - 1] = rt2_;
      e_[l_ - 1] = 0.0;
      l_ = l_ + 2;
      if (l_ <= lend_) {
        goto _l40;
      }
      goto _l140;
    }
    if (jtot_ == nmaxit_) {
      goto _l140;
    }
    jtot_ = jtot_ + 1;
    g_ = (d_[l_ + 1 - 1] - p_) / (2.0 * e_[l_ - 1]);
    r_ = _slapy2 (&g_, ($6_ = 1.0, &$6_));
    g_ = d_[m_ - 1] - p_ + (e_[l_ - 1] / (g_ + _sign (r_, g_)));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    mm1_ = m_ - 1;
    for (i_ = mm1_; i_ >= l_; (i_)--) {
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      (void) _slartg (&g_, &f_, &c_, &s_, &r_);
      if (i_ != m_ - 1) {
        e_[i_ + 1 - 1] = r_;
      }
      g_ = d_[i_ + 1 - 1] - p_;
      r_ = (d_[i_ - 1] - g_) * s_ + 2.0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ + 1 - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      if (icompz_ > 0) {
        work_[i_ - 1] = c_;
        work_[(*n_) - 1 + i_ - 1] = -s_;
      }
    }
    if (icompz_ > 0) {
      mm_ = m_ - l_ + 1;
      (void) _slasr (_dc_175, _dc_131, _dc_273, &_k1, &mm_, &work_[l_ - 1], &work_[(*n_) - 1 + l_ - 1], &z_[l_ - 1], &_k1);
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[l_ - 1] = g_;
    goto _l40;
    _l80:;
    d_[l_ - 1] = p_;
    l_ = l_ + 1;
    if (l_ <= lend_) {
      goto _l40;
    }
    goto _l140;
  }
  else {
    _l90:;
    if (l_ != lend_) {
      lendp1_ = lend_ + 1;
      for (m_ = l_; m_ >= lendp1_; (m_)--) {
        tst_ = ($7_ = _abs (e_[m_ - 1 - 1]), $7_ * $7_);
        if (tst_ <= (eps2_ * _abs (d_[m_ - 1])) * _abs (d_[m_ - 1 - 1]) + safmin_) {
          goto _l110;
        }
      }
    }
    m_ = lend_;
    _l110:;
    if (m_ > lend_) {
      e_[m_ - 1 - 1] = 0.0;
    }
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l130;
    }
    if (m_ == l_ - 1) {
      if (icompz_ > 0) {
        (void) _slaev2 (&d_[l_ - 1 - 1], &e_[l_ - 1 - 1], &d_[l_ - 1], &rt1_, &rt2_, &c_, &s_);
        tst_ = z_[l_ - 1];
        z_[l_ - 1] = c_ * tst_ - s_ * z_[l_ - 1 - 1];
        z_[l_ - 1 - 1] = s_ * tst_ + c_ * z_[l_ - 1 - 1];
      }
      else {
        (void) _slae2 (&d_[l_ - 1 - 1], &e_[l_ - 1 - 1], &d_[l_ - 1], &rt1_, &rt2_);
      }
      d_[l_ - 1 - 1] = rt1_;
      d_[l_ - 1] = rt2_;
      e_[l_ - 1 - 1] = 0.0;
      l_ = l_ - 2;
      if (l_ >= lend_) {
        goto _l90;
      }
      goto _l140;
    }
    if (jtot_ == nmaxit_) {
      goto _l140;
    }
    jtot_ = jtot_ + 1;
    g_ = (d_[l_ - 1 - 1] - p_) / (2.0 * e_[l_ - 1 - 1]);
    r_ = _slapy2 (&g_, ($8_ = 1.0, &$8_));
    g_ = d_[m_ - 1] - p_ + (e_[l_ - 1 - 1] / (g_ + _sign (r_, g_)));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    lm1_ = l_ - 1;
    for (i_ = m_; i_ <= lm1_; (i_)++) {
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      (void) _slartg (&g_, &f_, &c_, &s_, &r_);
      if (i_ != m_) {
        e_[i_ - 1 - 1] = r_;
      }
      g_ = d_[i_ - 1] - p_;
      r_ = (d_[i_ + 1 - 1] - g_) * s_ + 2.0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      if (icompz_ > 0) {
        work_[i_ - 1] = c_;
        work_[(*n_) - 1 + i_ - 1] = s_;
      }
    }
    if (icompz_ > 0) {
      mm_ = l_ - m_ + 1;
      (void) _slasr (_dc_175, _dc_131, _dc_274, &_k1, &mm_, &work_[m_ - 1], &work_[(*n_) - 1 + m_ - 1], &z_[m_ - 1], &_k1);
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[lm1_ - 1] = g_;
    goto _l90;
    _l130:;
    d_[l_ - 1] = p_;
    l_ = l_ - 1;
    if (l_ >= lend_) {
      goto _l90;
    }
    goto _l140;
  }
  _l140:;
  if (iscale_ == 1) {
    (void) _slascl (_dc_0, &_k0, &_k0, &ssfmax_, &anorm_, ($9_ = lendsv_ - lsv_ + 1, &$9_), &_k1, &d_[lsv_ - 1], n_, info_)
    ;
    (void) _slascl (_dc_0, &_k0, &_k0, &ssfmax_, &anorm_, ($10_ = lendsv_ - lsv_, &$10_), &_k1, &e_[lsv_ - 1], n_, info_);
  }
  else if (iscale_ == 2) {
    (void) _slascl (_dc_0, &_k0, &_k0, &ssfmin_, &anorm_, ($11_ = lendsv_ - lsv_ + 1, &$11_), &_k1, &d_[lsv_ - 1], n_, 
    info_);
    (void) _slascl (_dc_0, &_k0, &_k0, &ssfmin_, &anorm_, ($12_ = lendsv_ - lsv_, &$12_), &_k1, &e_[lsv_ - 1], n_, info_);
  }
  if (jtot_ < nmaxit_) {
    goto _l10;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (e_[i_ - 1] != 0.0) {
      (*info_) = (*info_) + 1;
    }
  }
  goto _l190;
  _l160:;
  if (icompz_ == 0) {
    (void) _slasrt (_dc_1, n_, d_, info_);
  }
  else {
    for (ii_ = 2; ii_ <= (*n_); (ii_)++) {
      i_ = ii_ - 1;
      k_ = i_;
      p_ = d_[i_ - 1];
      for (j_ = ii_; j_ <= (*n_); (j_)++) {
        if (d_[j_ - 1] < p_) {
          k_ = j_;
          p_ = d_[j_ - 1];
        }
      }
      if (k_ != i_) {
        d_[k_ - 1] = d_[i_ - 1];
        d_[i_ - 1] = p_;
        p_ = z_[k_ - 1];
        z_[k_ - 1] = z_[i_ - 1];
        z_[i_ - 1] = p_;
      }
    }
  }
  _l190:;
  _l0:;
  __calls[68].calls++;
  return 0;
}

int_4 _svout (int_4 _p_ lout_, int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ idigit_, char _p_ ifmt_)
{
  static int_4 i_, ndigit_, k1_, k2_, lll_;
  static char_127 line_;
  int_4 $u_0_, __fcnt, __rc, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_, $u_10_, $u_11_;
  char_127 $1_, $2_;
  static FORMAT $f_9999_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_9998_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9997_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    FMT_REAL,"%14e","%14.5.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9996_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    FMT_REAL,"%18e","%18.9.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9995_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_149, _dc_149,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%24e","%24.13.0e",
    FMT_REAL,"%24e","%24.13.0e",
    FMT_REAL,"%24e","%24.13.0e",
    FMT_REAL,"%24e","%24.13.0e",
    FMT_REAL,"%24e","%24.13.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_9994_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  lll_ = _min ((int_4) strlen (ifmt_), 80);
  for (i_ = 1; i_ <= lll_; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_10);
  }
  for (i_ = lll_ + 1; i_ <= 80; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_11);
  }
  $u_0_ = (*lout_);
  _fcheck ("arpack:svout:41", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:svout:41", $u_0_));
    __fcnt += 3;
  }
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:svout:41", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], ifmt_, CHARACTER, 0);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:svout:41", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:svout:41", $u_0_));
    __fcnt += 3;
  }
  bufcpy ($2_, _bufsub ((char *) $1_, (char *) line_, 1, lll_), 127);
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:svout:41", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], $2_, CHARACTER, 127);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:svout:41", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:svout:41", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  _l9999:;
  if ((*n_) <= 0) {
    goto _l0;
  }
  ndigit_ = (*idigit_);
  if ((*idigit_) == 0) {
    ndigit_ = 4;
  }
  if ((*idigit_) < 0) {
    ndigit_ = -(*idigit_);
    if (ndigit_ <= 4) {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_3_ = (*lout_);
        _fcheck ("arpack:svout:59", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
          __fcnt += 3;
        }
        if ($f_9998_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_3_].unit, "\n");
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
        __fcnt += 3;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          if ($f_9998_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
          __fcnt += 3;
        }
        if ($f_9998_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_3_].unit, "\n");
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
        __fcnt += 3;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          if ($f_9998_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &sx_[i_ - 1], REAL, 4);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:svout:59", $u_3_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_3_);
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (4 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 4) {
        k2_ = _min ((*n_), k1_ + 3);
        $u_4_ = (*lout_);
        _fcheck ("arpack:svout:64", $u_4_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
          __fcnt += 3;
        }
        if ($f_9997_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
        __fcnt += 3;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          if ($f_9997_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
          __fcnt += 3;
        }
        if ($f_9997_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
        __fcnt += 3;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          if ($f_9997_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_4_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], &sx_[i_ - 1], REAL, 4);
          _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_4_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("arpack:svout:64", $u_4_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_4_);
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_5_ = (*lout_);
        _fcheck ("arpack:svout:69", $u_5_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
          __fcnt += 3;
        }
        if ($f_9996_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
        __fcnt += 3;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          if ($f_9996_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
          __fcnt += 3;
        }
        if ($f_9996_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
        __fcnt += 3;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          if ($f_9996_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_5_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], &sx_[i_ - 1], REAL, 4);
          _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_5_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("arpack:svout:69", $u_5_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_5_);
      }
    }
    else {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_6_ = (*lout_);
        _fcheck ("arpack:svout:74", $u_6_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
          __fcnt += 3;
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_6_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
          __fcnt += 3;
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_6_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], &sx_[i_ - 1], REAL, 4);
          _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:svout:74", $u_6_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_6_);
      }
    }
  }
  else {
    if (ndigit_ <= 4) {
      for (k1_ = 1; (10 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 10) {
        k2_ = _min ((*n_), k1_ + 9);
        $u_7_ = (*lout_);
        _fcheck ("arpack:svout:86", $u_7_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
          __fcnt += 3;
        }
        if ($f_9998_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_7_].unit, "\n");
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
        __fcnt += 3;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          if ($f_9998_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
          __fcnt += 3;
        }
        if ($f_9998_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_7_].unit, "\n");
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
        __fcnt += 3;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          if ($f_9998_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], &sx_[i_ - 1], REAL, 4);
          _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:svout:86", $u_7_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_7_);
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (8 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 8) {
        k2_ = _min ((*n_), k1_ + 7);
        $u_8_ = (*lout_);
        _fcheck ("arpack:svout:91", $u_8_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
          __fcnt += 3;
        }
        if ($f_9997_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_8_].unit, "\n");
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
        __fcnt += 3;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          if ($f_9997_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
          __fcnt += 3;
        }
        if ($f_9997_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_8_].unit, "\n");
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
        __fcnt += 3;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          if ($f_9997_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], &sx_[i_ - 1], REAL, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:svout:91", $u_8_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_8_);
      }
    }
    else if (ndigit_ <= 10) {
      for (k1_ = 1; (6 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 6) {
        k2_ = _min ((*n_), k1_ + 5);
        $u_9_ = (*lout_);
        _fcheck ("arpack:svout:96", $u_9_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
          __fcnt += 3;
        }
        if ($f_9996_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
        __fcnt += 3;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          if ($f_9996_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
          __fcnt += 3;
        }
        if ($f_9996_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_9_].unit, "\n");
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
        __fcnt += 3;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          if ($f_9996_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_9_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], &sx_[i_ - 1], REAL, 4);
          _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_9_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("arpack:svout:96", $u_9_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_9_);
      }
    }
    else {
      for (k1_ = 1; (5 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 5) {
        k2_ = _min ((*n_), k1_ + 4);
        $u_10_ = (*lout_);
        _fcheck ("arpack:svout:101", $u_10_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
          __fcnt += 3;
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_10_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
          __fcnt += 3;
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_10_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], &k2_, INTEGER, 4);
        _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_10_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], &sx_[i_ - 1], REAL, 4);
          _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_10_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_10_, _ioerr_write ("arpack:svout:101", $u_10_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_10_);
      }
    }
  }
  $u_11_ = (*lout_);
  _fcheck ("arpack:svout:105", $u_11_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_11_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_11_, _ioerr_write ("arpack:svout:105", $u_11_));
    __fcnt += 3;
  }
  _write_eol ($u_11_);
  goto _l0;
  _l9998:;
  _l9997:;
  _l9996:;
  _l9995:;
  _l9994:;
  _l0:;
  __calls[69].calls++;
  return 0;
}

int_4 _zgetv0 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ itry_, logical_4 _p_ initv_, int_4 _p_ n_, int_4 _p_ j_, 
complex_16 _p_ v_, int_4 _p_ ldv_, complex_16 _p_ resid_, real_8 _p_ rnorm_, int_4 _p_ ipntr_, complex_16 _p_ workd_, 
int_4 _p_ ierr_)
{
  static int_4 idist_, iseed_[4], iter_, msglvl_, jj_;
  static logical_4 first_, inits_, orth_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 rnorm0_;
  static complex_16 cnorm_;
  int_4 _data_k_16, $2_, $5_;
  real_8 $0_, $1_, $8_, $9_;
  complex_16 $3_, $4_, $6_, $7_;
  extern int_4 _zcopy ();
  extern int_4 _zgemv ();
  extern int_4 _zlarnv ();
  extern real_8 _dznrm2 ();
  extern real_8 _dlapy2 ();
  extern complex_16 _zdotc ();
#define _data_n_16 1
  static logical_4 _data_l_16[_data_n_16] = {
    TRUE
  };
  if (__calls[70].calls == 0) {
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    inits_ = _data_l_16[_data_k_16++];
  }
  if (inits_) {
    iseed_[0] = 1;
    iseed_[1] = 3;
    iseed_[2] = 5;
    iseed_[3] = 7;
    inits_ = FALSE;
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mgetv0_;
    (*ierr_) = 0;
    iter_ = 0;
    first_ = FALSE;
    orth_ = FALSE;
    if (! ((*initv_))) {
      idist_ = 2;
      (void) _zlarnv (&idist_, iseed_, n_, resid_);
    }
    (void) _second (&t2_);
    if ((strcasecmp (bmat_, _dc_0) == 0)) {
      timing_.nopx_ = timing_.nopx_ + 1;
      ipntr_[0] = 1;
      ipntr_[1] = (*n_) + 1;
      (void) _zcopy (n_, resid_, &_k1, workd_, &_k1);
      (*ido_) = -1;
      goto _l9000;
    }
  }
  if (first_) {
    goto _l20;
  }
  if (orth_) {
    goto _l40;
  }
  (void) _second (&t3_);
  timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  (void) _second (&t2_);
  first_ = TRUE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _zcopy (n_, &workd_[(*n_) + 1 - 1], &_k1, resid_, &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _zcopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l20:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  first_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _zdotc (n_, resid_, &_k1, workd_, &_k1);
    rnorm0_ = sqrt (_dlapy2 (($0_ = (real_8) (creal (cnorm_)), &$0_), ($1_ = cimag (cnorm_), &$1_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm0_ = _dznrm2 (n_, resid_, &_k1);
  }
  (*rnorm_) = rnorm0_;
  if ((*j_) == 1) {
    goto _l50;
  }
  orth_ = TRUE;
  _l30:;
  (void) _zgemv (_dc_2, n_, ($2_ = (*j_) - 1, &$2_), ($3_ = CMPLX (1.0, 0.0), &$3_), v_, ldv_, workd_, &_k1, ($4_ = CMPLX 
  (0.0, 0.0), &$4_), &workd_[(*n_) + 1 - 1], &_k1);
  (void) _zgemv (_dc_3, n_, ($5_ = (*j_) - 1, &$5_), ($6_ = CMPLX (-1.0, 0.0), &$6_), v_, ldv_, &workd_[(*n_) + 1 - 1], 
  &_k1, ($7_ = CMPLX (1.0, 0.0), &$7_), resid_, &_k1);
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _zcopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _zcopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l40:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _zdotc (n_, resid_, &_k1, workd_, &_k1);
    (*rnorm_) = sqrt (_dlapy2 (($8_ = (real_8) (creal (cnorm_)), &$8_), ($9_ = cimag (cnorm_), &$9_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _dznrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _dvout (&debug_.logfil_, &_k1, &rnorm0_, &debug_.ndigit_, _dc_4);
    (void) _dvout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_5);
  }
  if ((*rnorm_) > 0.717 * rnorm0_) {
    goto _l50;
  }
  iter_ = iter_ + 1;
  if (iter_ <= 1) {
    rnorm0_ = (*rnorm_);
    goto _l30;
  }
  else {
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = CMPLX (0.0, 0.0);
    }
    (*rnorm_) = 0.0;
    (*ierr_) = -1;
  }
  _l50:;
  if (msglvl_ > 0) {
    (void) _dvout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_6);
  }
  if (msglvl_ > 2) {
    (void) _zvout (&debug_.logfil_, n_, resid_, &debug_.ndigit_, _dc_7);
  }
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tgetv0_ = timing_.tgetv0_ + (t1_ - t0_);
  _l9000:;
  __calls[70].calls++;
  return 0;
}

int_4 _zmout (int_4 _p_ lout_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ idigit_, char 
_p_ ifmt_)
{
  static int_4 i_, j_, ndigit_, k1_, k2_, lll_;
  static char_1 icol_[3];
  static char_127 line_;
  int_4 _data_k_17, $u_0_, __fcnt, __rc, $u_3_, _k_5, $u_6_, $u_7_, $u_8_, _k_10, $u_11_, $u_12_, $u_13_, _k_15, $u_16_, 
  $u_17_, $u_18_, _k_20, $u_21_, $u_22_, _k_24, $u_25_, $u_26_, $u_27_, $u_28_, $u_29_, _k_31, $u_32_, $u_33_, $u_34_, 
  $u_35_, _k_37, $u_38_, $u_39_, $u_40_, $u_41_, _k_43, $u_44_, $u_45_, $u_46_;
  char_1 _p_ _arr_4, _p_ _arr_9, _p_ _arr_14, _p_ _arr_19, _p_ _arr_23, _p_ _arr_30, _p_ _arr_36, _p_ _arr_42;
  char_127 $1_, $2_;
  static FORMAT $f_9999_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_9998_[] = {
    FMT_TEXT, _dc_12, _dc_12,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_13, _dc_13,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_13, _dc_13,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_13, _dc_13,
    FMT_TEXT, _dc_13, _dc_13,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_13, _dc_13,
    NULL, NULL, NULL
  };
  static FORMAT $f_9997_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_12, _dc_12,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_12, _dc_12,
    FMT_TEXT, _dc_12, _dc_12,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_12, _dc_12,
    FMT_TEXT, _dc_12, _dc_12,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_12, _dc_12,
    FMT_TEXT, _dc_12, _dc_12,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_12, _dc_12,
    NULL, NULL, NULL
  };
  static FORMAT $f_9996_[] = {
    FMT_TEXT, _dc_14, _dc_14,
    FMT_TEXT, _dc_15, _dc_15,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_15, _dc_15,
    FMT_TEXT, _dc_15, _dc_15,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_15, _dc_15,
    FMT_TEXT, _dc_15, _dc_15,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_15, _dc_15,
    NULL, NULL, NULL
  };
  static FORMAT $f_9995_[] = {
    FMT_TEXT, _dc_16, _dc_16,
    FMT_TEXT, _dc_17, _dc_17,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_17, _dc_17,
    FMT_TEXT, _dc_17, _dc_17,
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_CHAR,"%1s","%-1s",
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_17, _dc_17,
    NULL, NULL, NULL
  };
  static FORMAT $f_9994_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9984_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9993_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9983_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9992_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9982_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9991_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_23, _dc_23,
    NULL, NULL, NULL
  };
  static FORMAT $f_9990_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  static FORMAT $f_9974_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9964_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9954_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9944_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%10e","%10.3.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9973_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9963_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9953_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%12e","%12.5.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9972_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9962_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9952_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%14e","%14.7.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9971_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
  static FORMAT $f_9961_[] = {
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_18, _dc_18,
    FMT_INT,"%4d","%4d",
    FMT_TEXT, _dc_19, _dc_19,
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_TEXT, _dc_20, _dc_20,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_21, _dc_21,
    FMT_REAL,"%20e","%20.13.0e",
    FMT_TEXT, _dc_22, _dc_22,
    NULL, NULL, NULL
  };
#define _data_n_17 3
  static char_1 _data_l_17[_data_n_17] = {
    _dc_2,
    _dc_8,
    _dc_9
  };
  if (__calls[71].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    bufcpy (icol_[0], _data_l_17[_data_k_17++], 1);
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    bufcpy (icol_[1], _data_l_17[_data_k_17++], 1);
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    bufcpy (icol_[2], _data_l_17[_data_k_17++], 1);
  }
  lll_ = _min ((int_4) strlen (ifmt_), 80);
  for (i_ = 1; i_ <= lll_; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_10);
  }
  for (i_ = lll_ + 1; i_ <= 80; (i_)++) {
    bufrep ((char *) &(line_[i_ - 1]), _dc_11);
  }
  $u_0_ = (*lout_);
  _fcheck ("arpack:zmout:54", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:zmout:54", $u_0_));
    __fcnt += 3;
  }
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:zmout:54", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], ifmt_, CHARACTER, 0);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:zmout:54", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:zmout:54", $u_0_));
    __fcnt += 3;
  }
  bufcpy ($2_, _bufsub ((char *) $1_, (char *) line_, 1, lll_), 127);
  if ($f_9999_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("arpack:zmout:54", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], $2_, CHARACTER, 127);
  _write_err (__rc, $u_0_, _ioerr_write ("arpack:zmout:54", $u_0_));
  __fcnt += 3;
  while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
    if ($f_9999_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("arpack:zmout:54", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  _l9999:;
  if ((*m_) <= 0 || (*n_) <= 0 || (*lda_) <= 0) {
    goto _l0;
  }
  ndigit_ = (*idigit_);
  if ((*idigit_) == 0) {
    ndigit_ = 4;
  }
  if ((*idigit_) < 0) {
    ndigit_ = -(*idigit_);
    if (ndigit_ <= 4) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_3_ = (*lout_);
        _fcheck ("arpack:zmout:72", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:zmout:72", $u_3_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_4 = (char_1 _p_) icol_, _k_5 = 0; _k_5 < 3; _arr_4++, _k_5++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_3_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_3_, _ioerr_write ("arpack:zmout:72", $u_3_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], _arr_4, CHARACTER, 1);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:zmout:72", $u_3_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:zmout:72", $u_3_));
              __fcnt += 3;
            }
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_3_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_3_, _ioerr_write ("arpack:zmout:72", $u_3_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_3_, _ioerr_write ("arpack:zmout:72", $u_3_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_3_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("arpack:zmout:72", $u_3_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_3_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if (k1_ != (*n_)) {
            $u_6_ = (*lout_);
            _fcheck ("arpack:zmout:75", $u_6_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
              __fcnt += 3;
            }
            if ($f_9994_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_6_].unit, "\n");
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
            __fcnt += 3;
            while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
              if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9994_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_6_].unit, "\n");
                while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
              __fcnt += 3;
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
                __fcnt += 3;
              }
              if ($f_9994_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_6_].unit, "\n");
                while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
              __fcnt += 3;
              while ($f_9994_[__fcnt] != NULL && $f_9994_[__fcnt] == FMT_TEXT) {
                if ($f_9994_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_6_, $f_9994_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_6_, _ioerr_write ("arpack:zmout:75", $u_6_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_6_);
          }
          else {
            $u_7_ = (*lout_);
            _fcheck ("arpack:zmout:77", $u_7_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
              __fcnt += 3;
            }
            if ($f_9984_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_7_].unit, "\n");
              while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
            __fcnt += 3;
            while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
              if ($f_9984_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9984_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_7_].unit, "\n");
                while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
              __fcnt += 3;
              while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                if ($f_9984_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
                __fcnt += 3;
              }
              if ($f_9984_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_7_].unit, "\n");
                while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
              __fcnt += 3;
              while ($f_9984_[__fcnt] != NULL && $f_9984_[__fcnt] == FMT_TEXT) {
                if ($f_9984_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_7_, $f_9984_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_7_, _ioerr_write ("arpack:zmout:77", $u_7_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_7_);
          }
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_8_ = (*lout_);
        _fcheck ("arpack:zmout:85", $u_8_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:zmout:85", $u_8_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_9 = (char_1 _p_) icol_, _k_10 = 0; _k_10 < 3; _arr_9++, _k_10++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_8_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_8_, _ioerr_write ("arpack:zmout:85", $u_8_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], _arr_9, CHARACTER, 1);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:zmout:85", $u_8_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:zmout:85", $u_8_));
              __fcnt += 3;
            }
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("arpack:zmout:85", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("arpack:zmout:85", $u_8_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("arpack:zmout:85", $u_8_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_8_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if (k1_ != (*n_)) {
            $u_11_ = (*lout_);
            _fcheck ("arpack:zmout:88", $u_11_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
              __fcnt += 3;
            }
            if ($f_9993_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_11_].unit, "\n");
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
            __fcnt += 3;
            while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
              if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9993_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_11_].unit, "\n");
                while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
              __fcnt += 3;
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
                __fcnt += 3;
              }
              if ($f_9993_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_11_].unit, "\n");
                while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
              __fcnt += 3;
              while ($f_9993_[__fcnt] != NULL && $f_9993_[__fcnt] == FMT_TEXT) {
                if ($f_9993_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_11_, $f_9993_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_11_, _ioerr_write ("arpack:zmout:88", $u_11_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_11_);
          }
          else {
            $u_12_ = (*lout_);
            _fcheck ("arpack:zmout:90", $u_12_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
              __fcnt += 3;
            }
            if ($f_9983_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_12_].unit, "\n");
              while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
            __fcnt += 3;
            while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
              if ($f_9983_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9983_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_12_].unit, "\n");
                while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
              __fcnt += 3;
              while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                if ($f_9983_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
                __fcnt += 3;
              }
              if ($f_9983_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_12_].unit, "\n");
                while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
              __fcnt += 3;
              while ($f_9983_[__fcnt] != NULL && $f_9983_[__fcnt] == FMT_TEXT) {
                if ($f_9983_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_12_, $f_9983_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_12_, _ioerr_write ("arpack:zmout:90", $u_12_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_12_);
          }
        }
      }
    }
    else if (ndigit_ <= 8) {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_13_ = (*lout_);
        _fcheck ("arpack:zmout:98", $u_13_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_13_, _ioerr_write ("arpack:zmout:98", $u_13_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_14 = (char_1 _p_) icol_, _k_15 = 0; _k_15 < 3; _arr_14++, _k_15++) {
            if ($f_9996_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_13_].unit, "\n");
              while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_13_, _ioerr_write ("arpack:zmout:98", $u_13_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], _arr_14, CHARACTER, 1);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:zmout:98", $u_13_));
            __fcnt += 3;
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              if ($f_9996_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_13_, _ioerr_write ("arpack:zmout:98", $u_13_));
              __fcnt += 3;
            }
          }
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_13_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_13_, _ioerr_write ("arpack:zmout:98", $u_13_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_13_, _ioerr_write ("arpack:zmout:98", $u_13_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_13_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_13_, _ioerr_write ("arpack:zmout:98", $u_13_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_13_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if (k1_ != (*n_)) {
            $u_16_ = (*lout_);
            _fcheck ("arpack:zmout:101", $u_16_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
              __fcnt += 3;
            }
            if ($f_9992_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_16_].unit, "\n");
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
            __fcnt += 3;
            while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
              if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9992_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_16_].unit, "\n");
                while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
              __fcnt += 3;
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
                __fcnt += 3;
              }
              if ($f_9992_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_16_].unit, "\n");
                while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
              __fcnt += 3;
              while ($f_9992_[__fcnt] != NULL && $f_9992_[__fcnt] == FMT_TEXT) {
                if ($f_9992_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_16_, $f_9992_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_16_, _ioerr_write ("arpack:zmout:101", $u_16_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_16_);
          }
          else {
            $u_17_ = (*lout_);
            _fcheck ("arpack:zmout:103", $u_17_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
              __fcnt += 3;
            }
            if ($f_9982_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_17_].unit, "\n");
              while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
            __fcnt += 3;
            while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
              if ($f_9982_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9982_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_17_].unit, "\n");
                while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
              __fcnt += 3;
              while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                if ($f_9982_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
                __fcnt += 3;
              }
              if ($f_9982_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_17_].unit, "\n");
                while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
              __fcnt += 3;
              while ($f_9982_[__fcnt] != NULL && $f_9982_[__fcnt] == FMT_TEXT) {
                if ($f_9982_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_17_, $f_9982_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_17_, _ioerr_write ("arpack:zmout:103", $u_17_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_17_);
          }
        }
      }
    }
    else {
      for (k1_ = 1; k1_ <= (*n_); (k1_)++) {
        $u_18_ = (*lout_);
        _fcheck ("arpack:zmout:110", $u_18_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:zmout:110", $u_18_));
          __fcnt += 3;
        }
        for (_arr_19 = (char_1 _p_) icol_, _k_20 = 0; _k_20 < 3; _arr_19++, _k_20++) {
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_18_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_18_, _ioerr_write ("arpack:zmout:110", $u_18_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], _arr_19, CHARACTER, 1);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:zmout:110", $u_18_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:zmout:110", $u_18_));
            __fcnt += 3;
          }
        }
        if ($f_9995_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_18_].unit, "\n");
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("arpack:zmout:110", $u_18_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], &k1_, INTEGER, 4);
        _write_err (__rc, $u_18_, _ioerr_write ("arpack:zmout:110", $u_18_));
        __fcnt += 3;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          if ($f_9995_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_18_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_18_, _ioerr_write ("arpack:zmout:110", $u_18_));
          __fcnt += 3;
        }
        _write_eol ($u_18_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          $u_21_ = (*lout_);
          _fcheck ("arpack:zmout:112", $u_21_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_21_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_21_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((k1_ - 1))], COMPLEX, 16);
          _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
            __fcnt += 3;
          }
          if ($f_9991_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_21_].unit, "\n");
            while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((k1_ - 1))], COMPLEX, -16);
          _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
          __fcnt += 3;
          while ($f_9991_[__fcnt] != NULL && $f_9991_[__fcnt] == FMT_TEXT) {
            if ($f_9991_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_21_, $f_9991_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_21_, _ioerr_write ("arpack:zmout:112", $u_21_));
            __fcnt += 3;
          }
          _write_eol ($u_21_);
        }
      }
    }
  }
  else {
    if (ndigit_ <= 4) {
      for (k1_ = 1; (4 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 4) {
        k2_ = _min ((*n_), k1_ + 3);
        $u_22_ = (*lout_);
        _fcheck ("arpack:zmout:125", $u_22_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_22_, _ioerr_write ("arpack:zmout:125", $u_22_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_23 = (char_1 _p_) icol_, _k_24 = 0; _k_24 < 3; _arr_23++, _k_24++) {
            if ($f_9998_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_22_].unit, "\n");
              while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_22_, _ioerr_write ("arpack:zmout:125", $u_22_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], _arr_23, CHARACTER, 1);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:zmout:125", $u_22_));
            __fcnt += 3;
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              if ($f_9998_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("arpack:zmout:125", $u_22_));
              __fcnt += 3;
            }
          }
          if ($f_9998_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_22_].unit, "\n");
            while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("arpack:zmout:125", $u_22_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_22_, _ioerr_write ("arpack:zmout:125", $u_22_));
          __fcnt += 3;
          while ($f_9998_[__fcnt] != NULL && $f_9998_[__fcnt] == FMT_TEXT) {
            if ($f_9998_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_22_, $f_9998_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_22_, _ioerr_write ("arpack:zmout:125", $u_22_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_22_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if ((k1_ + 3) <= (*n_)) {
            $u_25_ = (*lout_);
            _fcheck ("arpack:zmout:128", $u_25_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
              __fcnt += 3;
            }
            if ($f_9974_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_25_].unit, "\n");
              while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
            __fcnt += 3;
            while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
              if ($f_9974_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9974_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_25_].unit, "\n");
                while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
              __fcnt += 3;
              while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                if ($f_9974_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
                __fcnt += 3;
              }
              if ($f_9974_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_25_].unit, "\n");
                while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
              __fcnt += 3;
              while ($f_9974_[__fcnt] != NULL && $f_9974_[__fcnt] == FMT_TEXT) {
                if ($f_9974_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_25_, $f_9974_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_25_, _ioerr_write ("arpack:zmout:128", $u_25_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_25_);
          }
          else if ((k1_ + 3 - (*n_)) == 1) {
            $u_26_ = (*lout_);
            _fcheck ("arpack:zmout:130", $u_26_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
              __fcnt += 3;
            }
            if ($f_9964_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_26_].unit, "\n");
              while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
            __fcnt += 3;
            while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
              if ($f_9964_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9964_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_26_].unit, "\n");
                while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
              __fcnt += 3;
              while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                if ($f_9964_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
                __fcnt += 3;
              }
              if ($f_9964_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_26_].unit, "\n");
                while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
              __fcnt += 3;
              while ($f_9964_[__fcnt] != NULL && $f_9964_[__fcnt] == FMT_TEXT) {
                if ($f_9964_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_26_, $f_9964_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_26_, _ioerr_write ("arpack:zmout:130", $u_26_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_26_);
          }
          else if ((k1_ + 3 - (*n_)) == 2) {
            $u_27_ = (*lout_);
            _fcheck ("arpack:zmout:132", $u_27_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
              __fcnt += 3;
            }
            if ($f_9954_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_27_].unit, "\n");
              while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
            __fcnt += 3;
            while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
              if ($f_9954_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9954_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_27_].unit, "\n");
                while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
              __fcnt += 3;
              while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                if ($f_9954_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
                __fcnt += 3;
              }
              if ($f_9954_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_27_].unit, "\n");
                while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
              __fcnt += 3;
              while ($f_9954_[__fcnt] != NULL && $f_9954_[__fcnt] == FMT_TEXT) {
                if ($f_9954_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_27_, $f_9954_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_27_, _ioerr_write ("arpack:zmout:132", $u_27_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_27_);
          }
          else if ((k1_ + 3 - (*n_)) == 3) {
            $u_28_ = (*lout_);
            _fcheck ("arpack:zmout:134", $u_28_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
              __fcnt += 3;
            }
            if ($f_9944_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_28_].unit, "\n");
              while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
            __fcnt += 3;
            while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
              if ($f_9944_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9944_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_28_].unit, "\n");
                while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
              __fcnt += 3;
              while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                if ($f_9944_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
                __fcnt += 3;
              }
              if ($f_9944_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_28_].unit, "\n");
                while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
              __fcnt += 3;
              while ($f_9944_[__fcnt] != NULL && $f_9944_[__fcnt] == FMT_TEXT) {
                if ($f_9944_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_28_, $f_9944_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_28_, _ioerr_write ("arpack:zmout:134", $u_28_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_28_);
          }
        }
      }
    }
    else if (ndigit_ <= 6) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_29_ = (*lout_);
        _fcheck ("arpack:zmout:142", $u_29_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_29_, _ioerr_write ("arpack:zmout:142", $u_29_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_30 = (char_1 _p_) icol_, _k_31 = 0; _k_31 < 3; _arr_30++, _k_31++) {
            if ($f_9997_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_29_].unit, "\n");
              while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_29_, _ioerr_write ("arpack:zmout:142", $u_29_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], _arr_30, CHARACTER, 1);
            _write_err (__rc, $u_29_, _ioerr_write ("arpack:zmout:142", $u_29_));
            __fcnt += 3;
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              if ($f_9997_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_29_, _ioerr_write ("arpack:zmout:142", $u_29_));
              __fcnt += 3;
            }
          }
          if ($f_9997_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_29_].unit, "\n");
            while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_29_, _ioerr_write ("arpack:zmout:142", $u_29_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_29_, _ioerr_write ("arpack:zmout:142", $u_29_));
          __fcnt += 3;
          while ($f_9997_[__fcnt] != NULL && $f_9997_[__fcnt] == FMT_TEXT) {
            if ($f_9997_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_29_, $f_9997_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_29_, _ioerr_write ("arpack:zmout:142", $u_29_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_29_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if ((k1_ + 2) <= (*n_)) {
            $u_32_ = (*lout_);
            _fcheck ("arpack:zmout:145", $u_32_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
              __fcnt += 3;
            }
            if ($f_9973_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_32_].unit, "\n");
              while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
            __fcnt += 3;
            while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
              if ($f_9973_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9973_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_32_].unit, "\n");
                while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
              __fcnt += 3;
              while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                if ($f_9973_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
                __fcnt += 3;
              }
              if ($f_9973_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_32_].unit, "\n");
                while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
              __fcnt += 3;
              while ($f_9973_[__fcnt] != NULL && $f_9973_[__fcnt] == FMT_TEXT) {
                if ($f_9973_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_32_, $f_9973_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_32_, _ioerr_write ("arpack:zmout:145", $u_32_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_32_);
          }
          else if ((k1_ + 2 - (*n_)) == 1) {
            $u_33_ = (*lout_);
            _fcheck ("arpack:zmout:147", $u_33_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
              __fcnt += 3;
            }
            if ($f_9963_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_33_].unit, "\n");
              while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
            __fcnt += 3;
            while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
              if ($f_9963_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9963_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_33_].unit, "\n");
                while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
              __fcnt += 3;
              while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                if ($f_9963_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
                __fcnt += 3;
              }
              if ($f_9963_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_33_].unit, "\n");
                while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
              __fcnt += 3;
              while ($f_9963_[__fcnt] != NULL && $f_9963_[__fcnt] == FMT_TEXT) {
                if ($f_9963_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_33_, $f_9963_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_33_, _ioerr_write ("arpack:zmout:147", $u_33_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_33_);
          }
          else if ((k1_ + 2 - (*n_)) == 2) {
            $u_34_ = (*lout_);
            _fcheck ("arpack:zmout:149", $u_34_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
              __fcnt += 3;
            }
            if ($f_9953_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_34_].unit, "\n");
              while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
            __fcnt += 3;
            while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
              if ($f_9953_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9953_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_34_].unit, "\n");
                while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
              __fcnt += 3;
              while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                if ($f_9953_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
                __fcnt += 3;
              }
              if ($f_9953_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_34_].unit, "\n");
                while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
              __fcnt += 3;
              while ($f_9953_[__fcnt] != NULL && $f_9953_[__fcnt] == FMT_TEXT) {
                if ($f_9953_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_34_, $f_9953_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_34_, _ioerr_write ("arpack:zmout:149", $u_34_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_34_);
          }
        }
      }
    }
    else if (ndigit_ <= 8) {
      for (k1_ = 1; (3 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 3) {
        k2_ = _min ((*n_), k1_ + 2);
        $u_35_ = (*lout_);
        _fcheck ("arpack:zmout:157", $u_35_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_35_, _ioerr_write ("arpack:zmout:157", $u_35_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_36 = (char_1 _p_) icol_, _k_37 = 0; _k_37 < 3; _arr_36++, _k_37++) {
            if ($f_9996_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_35_].unit, "\n");
              while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_35_, _ioerr_write ("arpack:zmout:157", $u_35_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], _arr_36, CHARACTER, 1);
            _write_err (__rc, $u_35_, _ioerr_write ("arpack:zmout:157", $u_35_));
            __fcnt += 3;
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              if ($f_9996_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_35_, _ioerr_write ("arpack:zmout:157", $u_35_));
              __fcnt += 3;
            }
          }
          if ($f_9996_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_35_].unit, "\n");
            while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_35_, _ioerr_write ("arpack:zmout:157", $u_35_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_35_, _ioerr_write ("arpack:zmout:157", $u_35_));
          __fcnt += 3;
          while ($f_9996_[__fcnt] != NULL && $f_9996_[__fcnt] == FMT_TEXT) {
            if ($f_9996_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_35_, $f_9996_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_35_, _ioerr_write ("arpack:zmout:157", $u_35_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_35_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if ((k1_ + 2) <= (*n_)) {
            $u_38_ = (*lout_);
            _fcheck ("arpack:zmout:160", $u_38_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
              __fcnt += 3;
            }
            if ($f_9972_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_38_].unit, "\n");
              while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
            __fcnt += 3;
            while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
              if ($f_9972_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9972_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_38_].unit, "\n");
                while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
              __fcnt += 3;
              while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                if ($f_9972_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
                __fcnt += 3;
              }
              if ($f_9972_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_38_].unit, "\n");
                while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
              __fcnt += 3;
              while ($f_9972_[__fcnt] != NULL && $f_9972_[__fcnt] == FMT_TEXT) {
                if ($f_9972_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_38_, $f_9972_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_38_, _ioerr_write ("arpack:zmout:160", $u_38_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_38_);
          }
          else if ((k1_ + 2 - (*n_)) == 1) {
            $u_39_ = (*lout_);
            _fcheck ("arpack:zmout:162", $u_39_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
              __fcnt += 3;
            }
            if ($f_9962_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_39_].unit, "\n");
              while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
            __fcnt += 3;
            while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
              if ($f_9962_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9962_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_39_].unit, "\n");
                while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
              __fcnt += 3;
              while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                if ($f_9962_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
                __fcnt += 3;
              }
              if ($f_9962_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_39_].unit, "\n");
                while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
              __fcnt += 3;
              while ($f_9962_[__fcnt] != NULL && $f_9962_[__fcnt] == FMT_TEXT) {
                if ($f_9962_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_39_, $f_9962_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_39_, _ioerr_write ("arpack:zmout:162", $u_39_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_39_);
          }
          else if ((k1_ + 2 - (*n_)) == 2) {
            $u_40_ = (*lout_);
            _fcheck ("arpack:zmout:164", $u_40_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
              __fcnt += 3;
            }
            if ($f_9952_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_40_].unit, "\n");
              while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
            __fcnt += 3;
            while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
              if ($f_9952_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9952_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_40_].unit, "\n");
                while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
              __fcnt += 3;
              while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                if ($f_9952_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
                __fcnt += 3;
              }
              if ($f_9952_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_40_].unit, "\n");
                while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
              __fcnt += 3;
              while ($f_9952_[__fcnt] != NULL && $f_9952_[__fcnt] == FMT_TEXT) {
                if ($f_9952_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_40_, $f_9952_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_40_, _ioerr_write ("arpack:zmout:164", $u_40_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_40_);
          }
        }
      }
    }
    else {
      for (k1_ = 1; (2 > 0 ? k1_ <= (*n_) : k1_ >= (*n_)); k1_ += 2) {
        k2_ = _min ((*n_), k1_ + 1);
        $u_41_ = (*lout_);
        _fcheck ("arpack:zmout:172", $u_41_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_41_, _ioerr_write ("arpack:zmout:172", $u_41_));
          __fcnt += 3;
        }
        for (i_ = k1_; i_ <= k2_; i_++) {
          for (_arr_42 = (char_1 _p_) icol_, _k_43 = 0; _k_43 < 3; _arr_42++, _k_43++) {
            if ($f_9995_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_41_].unit, "\n");
              while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("arpack:zmout:172", $u_41_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], _arr_42, CHARACTER, 1);
            _write_err (__rc, $u_41_, _ioerr_write ("arpack:zmout:172", $u_41_));
            __fcnt += 3;
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              if ($f_9995_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_41_, _ioerr_write ("arpack:zmout:172", $u_41_));
              __fcnt += 3;
            }
          }
          if ($f_9995_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_41_].unit, "\n");
            while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_41_, _ioerr_write ("arpack:zmout:172", $u_41_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_41_, _ioerr_write ("arpack:zmout:172", $u_41_));
          __fcnt += 3;
          while ($f_9995_[__fcnt] != NULL && $f_9995_[__fcnt] == FMT_TEXT) {
            if ($f_9995_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_41_, $f_9995_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_41_, _ioerr_write ("arpack:zmout:172", $u_41_));
            __fcnt += 3;
          }
        }; // implied DO 
        _write_eol ($u_41_);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          if ((k1_ + 1) <= (*n_)) {
            $u_44_ = (*lout_);
            _fcheck ("arpack:zmout:175", $u_44_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
              __fcnt += 3;
            }
            if ($f_9971_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_44_].unit, "\n");
              while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
            __fcnt += 3;
            while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
              if ($f_9971_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9971_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
              __fcnt += 3;
              while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                if ($f_9971_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
                __fcnt += 3;
              }
              if ($f_9971_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
              __fcnt += 3;
              while ($f_9971_[__fcnt] != NULL && $f_9971_[__fcnt] == FMT_TEXT) {
                if ($f_9971_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_9971_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("arpack:zmout:175", $u_44_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_44_);
          }
          else {
            $u_45_ = (*lout_);
            _fcheck ("arpack:zmout:177", $u_45_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
              __fcnt += 3;
            }
            if ($f_9961_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_45_].unit, "\n");
              while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
            __fcnt += 3;
            while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
              if ($f_9961_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
              __fcnt += 3;
            }
            for (j_ = k1_; j_ <= k2_; j_++) {
              if ($f_9961_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_45_].unit, "\n");
                while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, 16);
              _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
              __fcnt += 3;
              while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                if ($f_9961_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
                __fcnt += 3;
              }
              if ($f_9961_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_45_].unit, "\n");
                while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], &a_[i_ - 1 + ((*lda_)) * ((j_ - 1))], COMPLEX, -16);
              _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
              __fcnt += 3;
              while ($f_9961_[__fcnt] != NULL && $f_9961_[__fcnt] == FMT_TEXT) {
                if ($f_9961_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_45_, $f_9961_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_45_, _ioerr_write ("arpack:zmout:177", $u_45_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_45_);
          }
        }
      }
    }
  }
  $u_46_ = (*lout_);
  _fcheck ("arpack:zmout:183", $u_46_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_9990_[__fcnt] != NULL && $f_9990_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_46_, $f_9990_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_46_, _ioerr_write ("arpack:zmout:183", $u_46_));
    __fcnt += 3;
  }
  _write_eol ($u_46_);
  _l9998:;
  _l9997:;
  _l9996:;
  _l9995:;
  _l9994:;
  _l9984:;
  _l9993:;
  _l9983:;
  _l9992:;
  _l9982:;
  _l9991:;
  _l9990:;
  _l9974:;
  _l9964:;
  _l9954:;
  _l9944:;
  _l9973:;
  _l9963:;
  _l9953:;
  _l9972:;
  _l9962:;
  _l9952:;
  _l9971:;
  _l9961:;
  _l0:;
  __calls[71].calls++;
  return 0;
}

int_4 _znaitr (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ np_, int_4 _p_ nb_, complex_16 _p_ 
resid_, real_8 _p_ rnorm_, complex_16 _p_ v_, int_4 _p_ ldv_, complex_16 _p_ h_, int_4 _p_ ldh_, int_4 _p_ ipntr_, 
complex_16 _p_ workd_, int_4 _p_ info_)
{
  static int_4 ierr_, i_, infol_, ipj_, irj_, ivj_, iter_, itry_, j_, msglvl_, jj_;
  static logical_4 first_, orth1_, orth2_, rstart_, step3_, step4_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 rtemp_[2], ovfl_, smlnum_, tst1_, ulp_, unfl_, betaj_, temp1_, rnorm1_, wnorm_;
  static complex_16 cnorm_;
  int_4 _data_k_18, $11_, $19_, $24_, $27_, $28_;
  logical_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $9_, $10_, $17_, $18_, $20_, $21_, $22_, $23_, $25_, $26_;
  complex_16 $5_, $6_, $7_, $8_, $12_, $13_, $14_, $15_, $16_;
  extern int_4 _zaxpy ();
  extern int_4 _zcopy ();
  extern int_4 _zdscal ();
  extern int_4 _zgemv ();
  extern int_4 _dlabad ();
  extern complex_16 _zdotc ();
  extern real_8 _dlamch ();
  extern real_8 _dznrm2 ();
  extern real_8 _zlanhs ();
  extern real_8 _dlapy2 ();
#define _data_n_18 1
  static logical_4 _data_l_18[_data_n_18] = {
    TRUE
  };
  if (__calls[72].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    first_ = _data_l_18[_data_k_18++];
  }
  if (first_) {
    unfl_ = _dlamch (_dc_24);
    ovfl_ = (real_8) (creal (CMPLX (1.0, 0.0) / unfl_));
    (void) _dlabad (&unfl_, &ovfl_);
    ulp_ = _dlamch (_dc_25);
    smlnum_ = unfl_ * ((*n_) / ulp_);
    first_ = FALSE;
  }
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mcaitr_;
    (*info_) = 0;
    step3_ = FALSE;
    step4_ = FALSE;
    rstart_ = FALSE;
    orth1_ = FALSE;
    orth2_ = FALSE;
    j_ = (*k_) + 1;
    ipj_ = 1;
    irj_ = ipj_ + (*n_);
    ivj_ = irj_ + (*n_);
  }
  if (step3_) {
    goto _l50;
  }
  if (step4_) {
    goto _l60;
  }
  if (orth1_) {
    goto _l70;
  }
  if (orth2_) {
    goto _l90;
  }
  if (rstart_) {
    goto _l30;
  }
  _l1000:;
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_26);
    (void) _dvout (&debug_.logfil_, &_k1, rnorm_, &debug_.ndigit_, _dc_27);
  }
  betaj_ = (*rnorm_);
  if ((*rnorm_) > 0.0) {
    goto _l40;
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_28);
  }
  betaj_ = 0.0;
  timing_.nrstrt_ = timing_.nrstrt_ + 1;
  itry_ = 1;
  _l20:;
  rstart_ = TRUE;
  (*ido_) = 0;
  _l30:;
  (void) _zgetv0 (ido_, bmat_, &itry_, ($0_ = FALSE, &$0_), n_, &j_, v_, ldv_, resid_, rnorm_, ipntr_, workd_, &ierr_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if (ierr_ < 0) {
    itry_ = itry_ + 1;
    if (itry_ <= 3) {
      goto _l20;
    }
    (*info_) = j_ - 1;
    (void) _second (&t1_);
    timing_.tcaitr_ = timing_.tcaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    goto _l9000;
  }
  _l40:;
  (void) _zcopy (n_, resid_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
  if ((*rnorm_) >= unfl_) {
    temp1_ = 1.0 / (*rnorm_);
    (void) _zdscal (n_, &temp1_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1);
    (void) _zdscal (n_, &temp1_, &workd_[ipj_ - 1], &_k1);
  }
  else {
    (void) _zlascl (_dc_29, &i_, &i_, rnorm_, ($1_ = 1.0, &$1_), n_, &_k1, &v_[0 + ((*ldv_)) * ((j_ - 1))], n_, &infol_);
    (void) _zlascl (_dc_29, &i_, &i_, rnorm_, ($2_ = 1.0, &$2_), n_, &_k1, &workd_[ipj_ - 1], n_, &infol_);
  }
  step3_ = TRUE;
  timing_.nopx_ = timing_.nopx_ + 1;
  (void) _second (&t2_);
  (void) _zcopy (n_, &v_[0 + ((*ldv_)) * ((j_ - 1))], &_k1, &workd_[ivj_ - 1], &_k1);
  ipntr_[0] = ivj_;
  ipntr_[1] = irj_;
  ipntr_[2] = ipj_;
  (*ido_) = 1;
  goto _l9000;
  _l50:;
  (void) _second (&t3_);
  timing_.tmvopx_ = timing_.tmvopx_ + (t3_ - t2_);
  step3_ = FALSE;
  (void) _zcopy (n_, &workd_[irj_ - 1], &_k1, resid_, &_k1);
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    step4_ = TRUE;
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _zcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l60:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  step4_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _zdotc (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    wnorm_ = sqrt (_dlapy2 (($3_ = (real_8) (creal (cnorm_)), &$3_), ($4_ = cimag (cnorm_), &$4_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    wnorm_ = _dznrm2 (n_, resid_, &_k1);
  }
  (void) _zgemv (_dc_2, n_, &j_, ($5_ = CMPLX (1.0, 0.0), &$5_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($6_ = CMPLX (0.0, 
  0.0), &$6_), &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1);
  (void) _zgemv (_dc_3, n_, &j_, ($7_ = CMPLX (-1.0, 0.0), &$7_), v_, ldv_, &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1, ($8_ = 
  CMPLX (1.0, 0.0), &$8_), resid_, &_k1);
  if (j_ > 1) {
    h_[j_ - 1 + ((*ldh_)) * ((j_ - 1 - 1))] = CMPLX (betaj_, 0.0);
  }
  (void) _second (&t4_);
  orth1_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _zcopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _zcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l70:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  orth1_ = FALSE;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _zdotc (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    (*rnorm_) = sqrt (_dlapy2 (($9_ = (real_8) (creal (cnorm_)), &$9_), ($10_ = cimag (cnorm_), &$10_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (*rnorm_) = _dznrm2 (n_, resid_, &_k1);
  }
  if ((*rnorm_) > 0.717 * wnorm_) {
    goto _l100;
  }
  iter_ = 0;
  timing_.nrorth_ = timing_.nrorth_ + 1;
  _l80:;
  if (msglvl_ > 2) {
    rtemp_[0] = wnorm_;
    rtemp_[1] = (*rnorm_);
    (void) _dvout (&debug_.logfil_, ($11_ = 2, &$11_), rtemp_, &debug_.ndigit_, _dc_30);
    (void) _zvout (&debug_.logfil_, &j_, &h_[0 + ((*ldh_)) * ((j_ - 1))], &debug_.ndigit_, _dc_31);
  }
  (void) _zgemv (_dc_2, n_, &j_, ($12_ = CMPLX (1.0, 0.0), &$12_), v_, ldv_, &workd_[ipj_ - 1], &_k1, ($13_ = CMPLX (0.0, 
  0.0), &$13_), &workd_[irj_ - 1], &_k1);
  (void) _zgemv (_dc_3, n_, &j_, ($14_ = CMPLX (-1.0, 0.0), &$14_), v_, ldv_, &workd_[irj_ - 1], &_k1, ($15_ = CMPLX 
  (1.0, 0.0), &$15_), resid_, &_k1);
  (void) _zaxpy (&j_, ($16_ = CMPLX (1.0, 0.0), &$16_), &workd_[irj_ - 1], &_k1, &h_[0 + ((*ldh_)) * ((j_ - 1))], &_k1);
  orth2_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _zcopy (n_, resid_, &_k1, &workd_[irj_ - 1], &_k1);
    ipntr_[0] = irj_;
    ipntr_[1] = ipj_;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _zcopy (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
  }
  _l90:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cnorm_ = _zdotc (n_, resid_, &_k1, &workd_[ipj_ - 1], &_k1);
    rnorm1_ = sqrt (_dlapy2 (($17_ = (real_8) (creal (cnorm_)), &$17_), ($18_ = cimag (cnorm_), &$18_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm1_ = _dznrm2 (n_, resid_, &_k1);
  }
  if (msglvl_ > 0 && iter_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &j_, &debug_.ndigit_, _dc_32);
    if (msglvl_ > 2) {
      rtemp_[0] = (*rnorm_);
      rtemp_[1] = rnorm1_;
      (void) _dvout (&debug_.logfil_, ($19_ = 2, &$19_), rtemp_, &debug_.ndigit_, _dc_33);
    }
  }
  if (rnorm1_ > 0.717 * (*rnorm_)) {
    (*rnorm_) = rnorm1_;
  }
  else {
    timing_.nitref_ = timing_.nitref_ + 1;
    (*rnorm_) = rnorm1_;
    iter_ = iter_ + 1;
    if (iter_ <= 1) {
      goto _l80;
    }
    for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
      resid_[jj_ - 1] = CMPLX (0.0, 0.0);
    }
    (*rnorm_) = 0.0;
  }
  _l100:;
  rstart_ = FALSE;
  orth2_ = FALSE;
  (void) _second (&t5_);
  timing_.titref_ = timing_.titref_ + (t5_ - t4_);
  j_ = j_ + 1;
  if (j_ > (*k_) + (*np_)) {
    (void) _second (&t1_);
    timing_.tcaitr_ = timing_.tcaitr_ + (t1_ - t0_);
    (*ido_) = 99;
    for (i_ = _max (1, (*k_)); i_ <= (*k_) + (*np_) - 1; (i_)++) {
      tst1_ = _dlapy2 (($20_ = (real_8) (creal (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))])), &$20_), ($21_ = cimag (h_[i_ - 1 + 
      ((*ldh_)) * ((i_ - 1))]), &$21_)) + _dlapy2 (($22_ = (real_8) (creal (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))])), 
      &$22_), ($23_ = cimag (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]), &$23_));
      if (tst1_ == (real_8) (creal (CMPLX (0.0, 0.0)))) {
        tst1_ = _zlanhs (_dc_34, ($24_ = (*k_) + (*np_), &$24_), h_, ldh_, &workd_[(*n_) + 1 - 1]);
      }
      if (_dlapy2 (($25_ = (real_8) (creal (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))])), &$25_), ($26_ = cimag (h_[i_ + 1 - 1 + 
        ((*ldh_)) * ((i_ - 1))]), &$26_)) <= _max (ulp_ * tst1_, smlnum_)) {
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = CMPLX (0.0, 0.0);
      }
    }
    if (msglvl_ > 2) {
      (void) _zmout (&debug_.logfil_, ($27_ = (*k_) + (*np_), &$27_), ($28_ = (*k_) + (*np_), &$28_), h_, ldh_, 
      &debug_.ndigit_, _dc_35);
    }
    goto _l9000;
  }
  goto _l1000;
  _l9000:;
  __calls[72].calls++;
  return 0;
}

int_4 _znapps (int_4 _p_ n_, int_4 _p_ kev_, int_4 _p_ np_, complex_16 _p_ shift_, complex_16 _p_ v_, int_4 _p_ ldv_, 
complex_16 _p_ h_, int_4 _p_ ldh_, complex_16 _p_ resid_, complex_16 _p_ q_, int_4 _p_ ldq_, complex_16 _p_ workl_, 
complex_16 _p_ workd_)
{
  static int_4 i_, iend_, istart_, j_, jj_, kplusp_, msglvl_;
  static logical_4 first_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 c_, ovfl_, smlnum_, ulp_, unfl_, tst1_;
  static complex_16 cdum_, f_, g_, h11_, h21_, r_, s_, sigma_, t_;
  int_4 _data_k_19, $2_, $5_, $7_, $8_, $11_;
  real_8 $3_, $4_;
  complex_16 $0_, $1_, $6_, $9_, $10_, $12_, $13_;
  extern int_4 _zaxpy ();
  extern int_4 _zcopy ();
  extern int_4 _zgemv ();
  extern int_4 _zscal ();
  extern int_4 _zlacpy ();
  extern int_4 _zlartg ();
  extern int_4 _zlaset ();
  extern int_4 _dlabad ();
  extern real_8 _zlanhs ();
  extern real_8 _dlamch ();
  extern real_8 _dlapy2 ();
#define _data_n_19 1
  static logical_4 _data_l_19[_data_n_19] = {
    TRUE
  };
  if (__calls[73].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    first_ = _data_l_19[_data_k_19++];
  }
  if (first_) {
    unfl_ = _dlamch (_dc_24);
    ovfl_ = (real_8) (creal (CMPLX (1.0, 0.0) / unfl_));
    (void) _dlabad (&unfl_, &ovfl_);
    ulp_ = _dlamch (_dc_25);
    smlnum_ = unfl_ * ((*n_) / ulp_);
    first_ = FALSE;
  }
  (void) _second (&t0_);
  msglvl_ = debug_.mcapps_;
  kplusp_ = (*kev_) + (*np_);
  (void) _zlaset (_dc_36, &kplusp_, &kplusp_, ($0_ = CMPLX (0.0, 0.0), &$0_), ($1_ = CMPLX (1.0, 0.0), &$1_), q_, ldq_);
  if ((*np_) == 0) {
    goto _l9000;
  }
  for (jj_ = 1; jj_ <= (*np_); (jj_)++) {
    sigma_ = shift_[jj_ - 1];
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_37);
      (void) _zvout (&debug_.logfil_, &_k1, &sigma_, &debug_.ndigit_, _dc_38);
    }
    istart_ = 1;
    _l20:;
    for (i_ = istart_; i_ <= kplusp_ - 1; (i_)++) {
      tst1_ = ({complex_16 cdum__1_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]; _abs ((real_8) (creal (cdum__1_))) + _abs (cimag 
      (cdum__1_));}) + ({complex_16 cdum__1_ = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]; _abs ((real_8) (creal 
      (cdum__1_))) + _abs (cimag (cdum__1_));});
      if (tst1_ == 0.0) {
        tst1_ = _zlanhs (_dc_34, ($2_ = kplusp_ - jj_ + 1, &$2_), h_, ldh_, workl_);
      }
      if (_abs ((real_8) (creal (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))]))) <= _max (ulp_ * tst1_, smlnum_)) {
        if (msglvl_ > 0) {
          (void) _ivout (&debug_.logfil_, &_k1, &i_, &debug_.ndigit_, _dc_39);
          (void) _ivout (&debug_.logfil_, &_k1, &jj_, &debug_.ndigit_, _dc_40);
          (void) _zvout (&debug_.logfil_, &_k1, &h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))], &debug_.ndigit_, _dc_41);
        }
        iend_ = i_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = CMPLX (0.0, 0.0);
        goto _l40;
      }
    }
    iend_ = kplusp_;
    _l40:;
    if (msglvl_ > 2) {
      (void) _ivout (&debug_.logfil_, &_k1, &istart_, &debug_.ndigit_, _dc_42);
      (void) _ivout (&debug_.logfil_, &_k1, &iend_, &debug_.ndigit_, _dc_43);
    }
    if (istart_ == iend_ || istart_ > (*kev_)) {
      goto _l100;
    }
    h11_ = h_[istart_ - 1 + ((*ldh_)) * ((istart_ - 1))];
    h21_ = h_[istart_ + 1 - 1 + ((*ldh_)) * ((istart_ - 1))];
    f_ = h11_ - sigma_;
    g_ = h21_;
    for (i_ = istart_; i_ <= iend_ - 1; (i_)++) {
      (void) _zlartg (&f_, &g_, &c_, &s_, &r_);
      if (i_ > istart_) {
        h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = r_;
        h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = CMPLX (0.0, 0.0);
      }
      for (j_ = i_; j_ <= kplusp_; (j_)++) {
        t_ = c_ * h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] + s_ * h_[i_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
        h_[i_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = -conj (s_) * h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] + c_ * h_[i_ + 1 - 1 + 
        ((*ldh_)) * ((j_ - 1))];
        h_[i_ - 1 + ((*ldh_)) * ((j_ - 1))] = t_;
      }
      for (j_ = 1; j_ <= _min (i_ + 2, iend_); (j_)++) {
        t_ = c_ * h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] + conj (s_) * h_[j_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))];
        h_[j_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))] = -s_ * h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] + c_ * h_[j_ - 1 + ((*ldh_)) * ((i_ 
        + 1 - 1))];
        h_[j_ - 1 + ((*ldh_)) * ((i_ - 1))] = t_;
      }
      for (j_ = 1; j_ <= _min (i_ + jj_, kplusp_); (j_)++) {
        t_ = c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + conj (s_) * q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))];
        q_[j_ - 1 + ((*ldq_)) * ((i_ + 1 - 1))] = -s_ * q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] + c_ * q_[j_ - 1 + ((*ldq_)) * ((i_ 
        + 1 - 1))];
        q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] = t_;
      }
      if (i_ < iend_ - 1) {
        f_ = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))];
        g_ = h_[i_ + 2 - 1 + ((*ldh_)) * ((i_ - 1))];
      }
    }
    _l100:;
    istart_ = iend_ + 1;
    if (iend_ < kplusp_) {
      goto _l20;
    }
  }
  for (j_ = 1; j_ <= (*kev_); (j_)++) {
    if ((real_8) (creal (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))])) < 0.0 || cimag (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))]) 
      != 0.0) {
      t_ = h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] / _dlapy2 (($3_ = (real_8) (creal (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 
      1))])), &$3_), ($4_ = cimag (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))]), &$4_));
      (void) _zscal (($5_ = kplusp_ - j_ + 1, &$5_), ($6_ = conj (t_), &$6_), &h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))], ldh_)
      ;
      (void) _zscal (($7_ = _min (j_ + 2, kplusp_), &$7_), &t_, &h_[0 + ((*ldh_)) * ((j_ + 1 - 1))], &_k1);
      (void) _zscal (($8_ = _min (j_ + (*np_) + 1, kplusp_), &$8_), &t_, &q_[0 + ((*ldq_)) * ((j_ + 1 - 1))], &_k1);
      h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = CMPLX ((real_8) (creal (h_[j_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))])), 0.0);
    }
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    tst1_ = ({complex_16 cdum__1_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))]; _abs ((real_8) (creal (cdum__1_))) + _abs (cimag 
    (cdum__1_));}) + ({complex_16 cdum__1_ = h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))]; _abs ((real_8) (creal 
    (cdum__1_))) + _abs (cimag (cdum__1_));});
    if (tst1_ == 0.0) {
      tst1_ = _zlanhs (_dc_34, kev_, h_, ldh_, workl_);
    }
    if ((real_8) (creal (h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))])) <= _max (ulp_ * tst1_, smlnum_)) {
      h_[i_ + 1 - 1 + ((*ldh_)) * ((i_ - 1))] = CMPLX (0.0, 0.0);
    }
  }
  if ((real_8) (creal (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))])) > 0.0) {
    (void) _zgemv (_dc_3, n_, &kplusp_, ($9_ = CMPLX (1.0, 0.0), &$9_), v_, ldv_, &q_[0 + ((*ldq_)) * (((*kev_) + 1 - 1))], 
    &_k1, ($10_ = CMPLX (0.0, 0.0), &$10_), &workd_[(*n_) + 1 - 1], &_k1);
  }
  for (i_ = 1; i_ <= (*kev_); (i_)++) {
    (void) _zgemv (_dc_3, n_, ($11_ = kplusp_ - i_ + 1, &$11_), ($12_ = CMPLX (1.0, 0.0), &$12_), v_, ldv_, &q_[0 + 
    ((*ldq_)) * (((*kev_) - i_ + 1 - 1))], &_k1, ($13_ = CMPLX (0.0, 0.0), &$13_), workd_, &_k1);
    (void) _zcopy (n_, workd_, &_k1, &v_[0 + ((*ldv_)) * ((kplusp_ - i_ + 1 - 1))], &_k1);
  }
  (void) _zlacpy (_dc_44, n_, kev_, &v_[0 + ((*ldv_)) * ((kplusp_ - (*kev_) + 1 - 1))], ldv_, v_, ldv_);
  if ((real_8) (creal (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))])) > 0.0) {
    (void) _zcopy (n_, &workd_[(*n_) + 1 - 1], &_k1, &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1);
  }
  (void) _zscal (n_, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], resid_, &_k1);
  if ((real_8) (creal (h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))])) > 0.0) {
    (void) _zaxpy (n_, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))], &v_[0 + ((*ldv_)) * (((*kev_) + 1 - 1))], &_k1, 
    resid_, &_k1);
  }
  if (msglvl_ > 1) {
    (void) _zvout (&debug_.logfil_, &_k1, &q_[kplusp_ - 1 + ((*ldq_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_45);
    (void) _zvout (&debug_.logfil_, &_k1, &h_[(*kev_) + 1 - 1 + ((*ldh_)) * (((*kev_) - 1))], &debug_.ndigit_, _dc_46);
    (void) _ivout (&debug_.logfil_, &_k1, kev_, &debug_.ndigit_, _dc_47);
    if (msglvl_ > 2) {
      (void) _zmout (&debug_.logfil_, kev_, kev_, h_, ldh_, &debug_.ndigit_, _dc_48);
    }
  }
  _l9000:;
  (void) _second (&t1_);
  timing_.tcapps_ = timing_.tcapps_ + (t1_ - t0_);
  __calls[73].calls++;
  return 0;
}

int_4 _znaup2 (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, int_4 _p_ np_, real_8 _p_ 
tol_, complex_16 _p_ resid_, int_4 _p_ mode_, int_4 _p_ iupd_, int_4 _p_ ishift_, int_4 _p_ mxiter_, complex_16 _p_ v_, 
int_4 _p_ ldv_, complex_16 _p_ h_, int_4 _p_ ldh_, complex_16 _p_ ritz_, complex_16 _p_ bounds_, complex_16 _p_ q_, 
int_4 _p_ ldq_, complex_16 _p_ workl_, int_4 _p_ ipntr_, complex_16 _p_ workd_, real_8 _p_ rwork_, int_4 _p_ info_)
{
  static int_4 ierr_, iter_, kplusp_, msglvl_, nconv_, nevbef_, nev0_, np0_, nptemp_, i_, j_, kp_[3];
  static logical_4 cnorm_, getv0_, initv_, update_, ushift_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  static real_8 rnorm_, eps23_, rtemp_;
  static complex_16 cmpnorm_;
  static char_3 wprime_;
  int_4 $4_, $12_;
  logical_4 $5_, $8_, $11_;
  real_8 $0_, $1_, $2_, $3_, $6_, $7_, $9_, $10_, $13_, $14_;
  extern int_4 _zcopy ();
  extern complex_16 _zdotc ();
  extern real_8 _dznrm2 ();
  extern real_8 _dlamch ();
  extern real_8 _dlapy2 ();
  if ((*ido_) == 0) {
    (void) _second (&t0_);
    msglvl_ = debug_.mcaup2_;
    nev0_ = (*nev_);
    np0_ = (*np_);
    kplusp_ = (*nev_) + (*np_);
    nconv_ = 0;
    iter_ = 0;
    eps23_ = _dlamch (_dc_49);
    eps23_ = pow (eps23_, 6.6666666666666667e-1);
    getv0_ = TRUE;
    update_ = FALSE;
    ushift_ = FALSE;
    cnorm_ = FALSE;
    if ((*info_) != 0) {
      initv_ = TRUE;
      (*info_) = 0;
    }
    else {
      initv_ = FALSE;
    }
  }
  if (getv0_) {
    (void) _zgetv0 (ido_, bmat_, &_k1, &initv_, n_, &_k1, v_, ldv_, resid_, &rnorm_, ipntr_, workd_, info_);
    if ((*ido_) != 99) {
      goto _l9000;
    }
    if (rnorm_ == 0.0) {
      (*info_) = -9;
      goto _l1100;
    }
    getv0_ = FALSE;
    (*ido_) = 0;
  }
  if (update_) {
    goto _l20;
  }
  if (ushift_) {
    goto _l50;
  }
  if (cnorm_) {
    goto _l100;
  }
  (void) _znaitr (ido_, bmat_, n_, &_k0, nev_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  _l1000:;
  iter_ = iter_ + 1;
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &iter_, &debug_.ndigit_, _dc_50);
  }
  (*np_) = kplusp_ - (*nev_);
  if (msglvl_ > 1) {
    (void) _ivout (&debug_.logfil_, &_k1, nev_, &debug_.ndigit_, _dc_51);
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_52);
  }
  (*ido_) = 0;
  _l20:;
  update_ = TRUE;
  (void) _znaitr (ido_, bmat_, n_, nev_, np_, mode_, resid_, &rnorm_, v_, ldv_, h_, ldh_, ipntr_, workd_, info_);
  if ((*ido_) != 99) {
    goto _l9000;
  }
  if ((*info_) > 0) {
    (*np_) = (*info_);
    (*mxiter_) = iter_;
    (*info_) = -9999;
    goto _l1200;
  }
  update_ = FALSE;
  if (msglvl_ > 1) {
    (void) _dvout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_53);
  }
  (void) _zneigh (&rnorm_, &kplusp_, h_, ldh_, ritz_, bounds_, q_, ldq_, workl_, rwork_, &ierr_);
  if (ierr_ != 0) {
    (*info_) = -8;
    goto _l1200;
  }
  (*nev_) = nev0_;
  (*np_) = np0_;
  (void) _zcopy (&kplusp_, ritz_, &_k1, &workl_[(kplusp_ * kplusp_) + 1 - 1], &_k1);
  (void) _zcopy (&kplusp_, bounds_, &_k1, &workl_[(kplusp_ * kplusp_) + kplusp_ + 1 - 1], &_k1);
  (void) _zngets (ishift_, which_, nev_, np_, ritz_, bounds_);
  nconv_ = 0;
  for (i_ = 1; i_ <= (*nev_); (i_)++) {
    rtemp_ = _max (eps23_, _dlapy2 (($0_ = (real_8) (creal (ritz_[(*np_) + i_ - 1])), &$0_), ($1_ = cimag (ritz_[(*np_) + 
    i_ - 1]), &$1_)));
    if (_dlapy2 (($2_ = (real_8) (creal (bounds_[(*np_) + i_ - 1])), &$2_), ($3_ = cimag (bounds_[(*np_) + i_ - 1]), &$3_)) 
      <= (*tol_) * rtemp_) {
      nconv_ = nconv_ + 1;
    }
  }
  if (msglvl_ > 2) {
    kp_[0] = (*nev_);
    kp_[1] = (*np_);
    kp_[2] = nconv_;
    (void) _ivout (&debug_.logfil_, ($4_ = 3, &$4_), kp_, &debug_.ndigit_, _dc_54);
    (void) _zvout (&debug_.logfil_, &kplusp_, ritz_, &debug_.ndigit_, _dc_55);
    (void) _zvout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_56);
  }
  nptemp_ = (*np_);
  for (j_ = 1; j_ <= nptemp_; (j_)++) {
    if (bounds_[j_ - 1] == CMPLX (0.0, 0.0)) {
      (*np_) = (*np_) - 1;
      (*nev_) = (*nev_) + 1;
    }
  }
  if ((nconv_ >= nev0_) || (iter_ > (*mxiter_)) || ((*np_) == 0)) {
    if (msglvl_ > 4) {
      (void) _zvout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + 1 - 1], &debug_.ndigit_, _dc_57);
      (void) _zvout (&debug_.logfil_, &kplusp_, &workl_[(kplusp_ * kplusp_) + kplusp_ + 1 - 1], &debug_.ndigit_, _dc_58);
    }
    h_[2 + ((*ldh_)) * ((0))] = CMPLX (rnorm_, 0.0);
    if ((strcasecmp (which_, _dc_59) == 0)) {
      bufcpy (wprime_, _dc_60, 3);
    }
    if ((strcasecmp (which_, _dc_60) == 0)) {
      bufcpy (wprime_, _dc_59, 3);
    }
    if ((strcasecmp (which_, _dc_61) == 0)) {
      bufcpy (wprime_, _dc_62, 3);
    }
    if ((strcasecmp (which_, _dc_62) == 0)) {
      bufcpy (wprime_, _dc_61, 3);
    }
    if ((strcasecmp (which_, _dc_63) == 0)) {
      bufcpy (wprime_, _dc_64, 3);
    }
    if ((strcasecmp (which_, _dc_64) == 0)) {
      bufcpy (wprime_, _dc_63, 3);
    }
    (void) _zsortc (wprime_, ($5_ = TRUE, &$5_), &kplusp_, ritz_, bounds_);
    for (j_ = 1; j_ <= nev0_; (j_)++) {
      rtemp_ = _max (eps23_, _dlapy2 (($6_ = (real_8) (creal (ritz_[j_ - 1])), &$6_), ($7_ = cimag (ritz_[j_ - 1]), &$7_)));
      bounds_[j_ - 1] = bounds_[j_ - 1] / rtemp_;
    }
    bufcpy (wprime_, _dc_59, 3);
    (void) _zsortc (wprime_, ($8_ = TRUE, &$8_), &nev0_, bounds_, ritz_);
    for (j_ = 1; j_ <= nev0_; (j_)++) {
      rtemp_ = _max (eps23_, _dlapy2 (($9_ = (real_8) (creal (ritz_[j_ - 1])), &$9_), ($10_ = cimag (ritz_[j_ - 1]), &$10_)))
      ;
      bounds_[j_ - 1] = bounds_[j_ - 1] * rtemp_;
    }
    (void) _zsortc (which_, ($11_ = TRUE, &$11_), &nconv_, ritz_, bounds_);
    if (msglvl_ > 1) {
      (void) _zvout (&debug_.logfil_, &kplusp_, ritz_, &debug_.ndigit_, _dc_65);
      (void) _zvout (&debug_.logfil_, &kplusp_, bounds_, &debug_.ndigit_, _dc_66);
    }
    if (iter_ > (*mxiter_) && nconv_ < nev0_) {
      (*info_) = 1;
    }
    if ((*np_) == 0 && nconv_ < nev0_) {
      (*info_) = 2;
    }
    (*np_) = nconv_;
    goto _l1100;
  }
  else if ((nconv_ < nev0_) && ((*ishift_) == 1)) {
    nevbef_ = (*nev_);
    (*nev_) = (*nev_) + _min (nconv_, (*np_) / 2);
    if ((*nev_) == 1 && kplusp_ >= 6) {
      (*nev_) = kplusp_ / 2;
    }
    else if ((*nev_) == 1 && kplusp_ > 3) {
      (*nev_) = 2;
    }
    (*np_) = kplusp_ - (*nev_);
    if (nevbef_ < (*nev_)) {
      (void) _zngets (ishift_, which_, nev_, np_, ritz_, bounds_);
    }
  }
  if (msglvl_ > 0) {
    (void) _ivout (&debug_.logfil_, &_k1, &nconv_, &debug_.ndigit_, _dc_67);
    if (msglvl_ > 1) {
      kp_[0] = (*nev_);
      kp_[1] = (*np_);
      (void) _ivout (&debug_.logfil_, ($12_ = 2, &$12_), kp_, &debug_.ndigit_, _dc_68);
      (void) _zvout (&debug_.logfil_, nev_, &ritz_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_69);
      (void) _zvout (&debug_.logfil_, nev_, &bounds_[(*np_) + 1 - 1], &debug_.ndigit_, _dc_70);
    }
  }
  if ((*ishift_) == 0) {
    ushift_ = TRUE;
    (*ido_) = 3;
    goto _l9000;
  }
  _l50:;
  ushift_ = FALSE;
  if ((*ishift_) != 1) {
    (void) _zcopy (np_, workl_, &_k1, ritz_, &_k1);
  }
  if (msglvl_ > 2) {
    (void) _ivout (&debug_.logfil_, &_k1, np_, &debug_.ndigit_, _dc_71);
    (void) _zvout (&debug_.logfil_, np_, ritz_, &debug_.ndigit_, _dc_72);
    if ((*ishift_) == 1) {
      (void) _zvout (&debug_.logfil_, np_, bounds_, &debug_.ndigit_, _dc_73);
    }
  }
  (void) _znapps (n_, nev_, np_, ritz_, v_, ldv_, h_, ldh_, resid_, q_, ldq_, workl_, workd_);
  cnorm_ = TRUE;
  (void) _second (&t2_);
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    timing_.nbx_ = timing_.nbx_ + 1;
    (void) _zcopy (n_, resid_, &_k1, &workd_[(*n_) + 1 - 1], &_k1);
    ipntr_[0] = (*n_) + 1;
    ipntr_[1] = 1;
    (*ido_) = 2;
    goto _l9000;
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    (void) _zcopy (n_, resid_, &_k1, workd_, &_k1);
  }
  _l100:;
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    (void) _second (&t3_);
    timing_.tmvbx_ = timing_.tmvbx_ + (t3_ - t2_);
  }
  if ((strcasecmp (bmat_, _dc_0) == 0)) {
    cmpnorm_ = _zdotc (n_, resid_, &_k1, workd_, &_k1);
    rnorm_ = sqrt (_dlapy2 (($13_ = (real_8) (creal (cmpnorm_)), &$13_), ($14_ = cimag (cmpnorm_), &$14_)));
  }
  else if ((strcasecmp (bmat_, _dc_1) == 0)) {
    rnorm_ = _dznrm2 (n_, resid_, &_k1);
  }
  cnorm_ = FALSE;
  if (msglvl_ > 2) {
    (void) _dvout (&debug_.logfil_, &_k1, &rnorm_, &debug_.ndigit_, _dc_74);
    (void) _zmout (&debug_.logfil_, nev_, nev_, h_, ldh_, &debug_.ndigit_, _dc_75);
  }
  goto _l1000;
  _l1100:;
  (*mxiter_) = iter_;
  (*nev_) = nconv_;
  _l1200:;
  (*ido_) = 99;
  (void) _second (&t1_);
  timing_.tcaup2_ = t1_ - t0_;
  _l9000:;
  __calls[74].calls++;
  return 0;
}

int_4 _znaupd (int_4 _p_ ido_, char _p_ bmat_, int_4 _p_ n_, char _p_ which_, int_4 _p_ nev_, real_8 _p_ tol_, 
complex_16 _p_ resid_, int_4 _p_ ncv_, complex_16 _p_ v_, int_4 _p_ ldv_, int_4 _p_ iparam_, int_4 _p_ ipntr_, 
complex_16 _p_ workd_, complex_16 _p_ workl_, int_4 _p_ lworkl_, real_8 _p_ rwork_, int_4 _p_ info_)
{
  static int_4 bounds_, ierr_, ih_, iq_, ishift_, iupd_, iw_, ldh_, ldq_, levec_, mode_, msglvl_, mxiter_, nb_, nev0_, 
  next_, np_, ritz_, j_;
  static real_4 t0_, t1_, t2_, t3_, t4_, t5_;
  int_4 __fcnt, __rc;
  extern real_8 _dlamch ();
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_83, _dc_83,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_84, _dc_84,
    FMT_TEXT, _dc_85, _dc_85,
    FMT_TEXT, _dc_86, _dc_86,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_88, _dc_88,
    FMT_TEXT, _dc_89, _dc_89,
    FMT_TEXT, _dc_90, _dc_90,
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_91, _dc_91,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_1100_[] = {
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_92, _dc_92,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_93, _dc_93,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_94, _dc_94,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_96, _dc_96,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_97, _dc_97,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_98, _dc_98,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_99, _dc_99,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_101, _dc_101,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_102, _dc_102,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_103, _dc_103,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_104, _dc_104,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_105, _dc_105,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_106, _dc_106,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_107, _dc_107,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_108, _dc_108,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT, _dc_109, _dc_109,
    FMT_REAL,"%12f","%12.6f",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  if ((*ido_) == 0) {
    (void) _zstatn ();
    (void) _second (&t0_);
    msglvl_ = debug_.mcaupd_;
    ierr_ = 0;
    ishift_ = iparam_[0];
    mxiter_ = iparam_[2];
    nb_ = 1;
    iupd_ = 1;
    mode_ = iparam_[6];
    if ((*n_) <= 0) {
      ierr_ = -1;
    }
    else if ((*nev_) <= 0) {
      ierr_ = -2;
    }
    else if ((*ncv_) <= (*nev_) || (*ncv_) > (*n_)) {
      ierr_ = -3;
    }
    else if (mxiter_ <= 0) {
      ierr_ = -4;
    }
    else if ((strcasecmp (which_, _dc_59) != 0) && (strcasecmp (which_, _dc_60) != 0) && (strcasecmp (which_, _dc_61) != 0) 
      && (strcasecmp (which_, _dc_62) != 0) && (strcasecmp (which_, _dc_63) != 0) && (strcasecmp (which_, _dc_64) != 0)) {
      ierr_ = -5;
    }
    else if ((strcasecmp (bmat_, _dc_1) != 0) && (strcasecmp (bmat_, _dc_0) != 0)) {
      ierr_ = -6;
    }
    else if ((*lworkl_) < 3 * ((*ncv_) * (*ncv_)) + 5 * (*ncv_)) {
      ierr_ = -7;
    }
    else if (mode_ < 1 || mode_ > 3) {
      ierr_ = -10;
    }
    else if (mode_ == 1 && (strcasecmp (bmat_, _dc_0) == 0)) {
      ierr_ = -11;
    }
    if (ierr_ != 0) {
      (*info_) = ierr_;
      (*ido_) = 99;
      goto _l9000;
    }
    if (nb_ <= 0) {
      nb_ = 1;
    }
    if ((*tol_) <= 0.0e+0) {
      (*tol_) = _dlamch (_dc_76);
    }
    if (ishift_ != 0 && ishift_ != 1 && ishift_ != 2) {
      ishift_ = 1;
    }
    np_ = (*ncv_) - (*nev_);
    nev0_ = (*nev_);
    for (j_ = 1; j_ <= 3 * ((*ncv_) * (*ncv_)) + 5 * (*ncv_); (j_)++) {
      workl_[j_ - 1] = CMPLX (0.0, 0.0);
    }
    ldh_ = (*ncv_);
    ldq_ = (*ncv_);
    ih_ = 1;
    ritz_ = ih_ + ldh_ * (*ncv_);
    bounds_ = ritz_ + (*ncv_);
    iq_ = bounds_ + (*ncv_);
    iw_ = iq_ + ldq_ * (*ncv_);
    next_ = iw_ + ((*ncv_) * (*ncv_)) + 3 * (*ncv_);
    ipntr_[3] = next_;