//! @file mathlib-blas.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 148 subprograms from BLAS

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CAXPY  CHERK  CTPSV  DROT   DSYR2K IZAMAX SROTG  STBMV  ZGEMM  ZROTG
// CCOPY  CHPMV  CTRMM  DROTG  DSYRK  SASUM  SROTM  STBSV  ZGEMV  ZSCAL
// CDOTC  CHPR   CTRMV  DROTM  DTBMV  SAXPY  SROTMG STPMV  ZGERC  ZSWAP
// CDOTU  CHPR2  CTRSM  DROTMG DTBSV  SCABS1 SSBMV  STPSV  ZGERU  ZSYMM
// CGBMV  CROTG  CTRSV  DSBMV  DTPMV  SCASUM SSCAL  STRMM  ZHBMV  ZSYR2K
// CGEMM  CSCAL  DASUM  DSCAL  DTPSV  SCNRM2 SSPMV  STRMV  ZHEMM  ZSYRK
// CGEMV  CSROT  DAXPY  DSDOT  DTRMM  SCOPY  SSPR   STRSM  ZHEMV  ZTBMV
// CGERC  CSSCAL DCABS1 DSPMV  DTRMV  SDOT   SSPR2  STRSV  ZHER   ZTBSV
// CGERU  CSWAP  DCOPY  DSPR   DTRSM  SDSDOT SSWAP  ZAXPY  ZHER2  ZTPMV
// CHBMV  CSYMM  DDOT   DSPR2  DTRSV  SGBMV  SSYMM  ZCOPY  ZHER2K ZTPSV
// CHEMM  CSYR2K DGBMV  DSWAP  DZASUM SGEMM  SSYMV  ZDOTC  ZHERK  ZTRMM
// CHEMV  CSYRK  DGEMM  DSYMM  DZNRM2 SGEMV  SSYR   ZDOTU  ZHPMV  ZTRMV
// CHER   CTBMV  DGEMV  DSYMV  ICAMAX SGER   SSYR2  ZDROT  ZHPR   ZTRSM
// CHER2  CTBSV  DGER   DSYR   IDAMAX SNRM2  SSYR2K ZDSCAL ZHPR2  ZTRSV
// CHER2K CTPMV  DNRM2  DSYR2  ISAMAX SROT   SSYRK  ZGBMV

// Miscellaneous routines from SLATEC, not in other packages as BLAS,
// EISPACK, FISHPACK, FFTPACK, FNLIB, LINPACK etcetera.
// 
// Source: netlib.org/slatec/
// 
// For VIF, all source file have been formatted and labels have been renumbered.

// The license for BLAS Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "n"
#define _dc_1 "t"
#define _dc_2 "c"
#define _dc_3 "cgbmv "
#define _dc_4 "cgemm "
#define _dc_5 "cgemv "
#define _dc_6 "cgerc "
#define _dc_7 "cgeru "
#define _dc_8 "u"
#define _dc_9 "l"
#define _dc_10 "chbmv "
#define _dc_11 "r"
#define _dc_12 "chemm "
#define _dc_13 "chemv "
#define _dc_14 "cher2 "
#define _dc_15 "cher2k"
#define _dc_16 "cher  "
#define _dc_17 "cherk "
#define _dc_18 "chpmv "
#define _dc_19 "chpr2 "
#define _dc_20 "chpr  "
#define _dc_21 "csymm "
#define _dc_22 "csyr2k"
#define _dc_23 "csyrk "
#define _dc_24 "ctbmv "
#define _dc_25 "ctbsv "
#define _dc_26 "ctpmv "
#define _dc_27 "ctpsv "
#define _dc_28 "ctrmm "
#define _dc_29 "ctrmv "
#define _dc_30 "ctrsm "
#define _dc_31 "ctrsv "
#define _dc_32 "dgbmv "
#define _dc_33 "dgemm "
#define _dc_34 "dgemv "
#define _dc_35 "dger  "
#define _dc_36 "dsbmv "
#define _dc_37 "dspmv "
#define _dc_38 "dspr2 "
#define _dc_39 "dspr  "
#define _dc_40 "dsymm "
#define _dc_41 "dsymv "
#define _dc_42 "dsyr2 "
#define _dc_43 "dsyr2k"
#define _dc_44 "dsyr  "
#define _dc_45 "dsyrk "
#define _dc_46 "dtbmv "
#define _dc_47 "dtbsv "
#define _dc_48 "dtpmv "
#define _dc_49 "dtpsv "
#define _dc_50 "dtrmm "
#define _dc_51 "dtrmv "
#define _dc_52 "dtrsm "
#define _dc_53 "dtrsv "
#define _dc_54 "sgbmv "
#define _dc_55 "sgemm "
#define _dc_56 "sgemv "
#define _dc_57 "sger  "
#define _dc_58 "ssbmv "
#define _dc_59 "sspmv "
#define _dc_60 "sspr2 "
#define _dc_61 "sspr  "
#define _dc_62 "ssymm "
#define _dc_63 "ssymv "
#define _dc_64 "ssyr2 "
#define _dc_65 "ssyr2k"
#define _dc_66 "ssyr  "
#define _dc_67 "ssyrk "
#define _dc_68 "stbmv "
#define _dc_69 "stbsv "
#define _dc_70 "stpmv "
#define _dc_71 "stpsv "
#define _dc_72 "strmm "
#define _dc_73 "strmv "
#define _dc_74 "strsm "
#define _dc_75 "strsv "
#define _dc_76 "zgbmv "
#define _dc_77 "zgemm "
#define _dc_78 "zgemv "
#define _dc_79 "zgerc "
#define _dc_80 "zgeru "
#define _dc_81 "zhbmv "
#define _dc_82 "zhemm "
#define _dc_83 "zhemv "
#define _dc_84 "zher2 "
#define _dc_85 "zher2k"
#define _dc_86 "zher  "
#define _dc_87 "zherk "
#define _dc_88 "zhpmv "
#define _dc_89 "zhpr2 "
#define _dc_90 "zhpr  "
#define _dc_91 "zsymm "
#define _dc_92 "zsyr2k"
#define _dc_93 "zsyrk "
#define _dc_94 "ztbmv "
#define _dc_95 "ztbsv "
#define _dc_96 "ztpmv "
#define _dc_97 "ztpsv "
#define _dc_98 "ztrmm "
#define _dc_99 "ztrmv "
#define _dc_100 "ztrsm "
#define _dc_101 "ztrsv "
static FORMAT *__fmt_a = NULL;
typedef char char_1[2];
typedef char char_7[8];
#define __ncalls 149
static CALLS __calls[__ncalls] = {
  {"caxpy", 0}, // subroutine
  {"ccopy", 0}, // subroutine
  {"cdotc", 0}, // complex*8 function
  {"cdotu", 0}, // complex*8 function
  {"cgbmv", 0}, // subroutine
  {"cgemm", 0}, // subroutine
  {"cgemv", 0}, // subroutine
  {"cgerc", 0}, // subroutine
  {"cgeru", 0}, // subroutine
  {"chbmv", 0}, // subroutine
  {"chemm", 0}, // subroutine
  {"chemv", 0}, // subroutine
  {"cher2", 0}, // subroutine
  {"cher2k", 0}, // subroutine
  {"cher", 0}, // subroutine
  {"cherk", 0}, // subroutine
  {"chpmv", 0}, // subroutine
  {"chpr2", 0}, // subroutine
  {"chpr", 0}, // subroutine
  {"crotg", 0}, // subroutine
  {"cscal", 0}, // subroutine
  {"csrot", 0}, // subroutine
  {"csscal", 0}, // subroutine
  {"cswap", 0}, // subroutine
  {"csymm", 0}, // subroutine
  {"csyr2k", 0}, // subroutine
  {"csyrk", 0}, // subroutine
  {"ctbmv", 0}, // subroutine
  {"ctbsv", 0}, // subroutine
  {"ctpmv", 0}, // subroutine
  {"ctpsv", 0}, // subroutine
  {"ctrmm", 0}, // subroutine
  {"ctrmv", 0}, // subroutine
  {"ctrsm", 0}, // subroutine
  {"ctrsv", 0}, // subroutine
  {"dasum", 0}, // real*8 function
  {"daxpy", 0}, // subroutine
  {"dcabs1", 0}, // real*8 function
  {"dcopy", 0}, // subroutine
  {"ddot", 0}, // real*8 function
  {"dgbmv", 0}, // subroutine
  {"dgemm", 0}, // subroutine
  {"dgemv", 0}, // subroutine
  {"dger", 0}, // subroutine
  {"dnrm2", 0}, // real*8 function
  {"drot", 0}, // subroutine
  {"drotg", 0}, // subroutine
  {"drotm", 0}, // subroutine
  {"drotmg", 0}, // subroutine
  {"dsbmv", 0}, // subroutine
  {"dscal", 0}, // subroutine
  {"dsdot", 0}, // real*8 function
  {"dspmv", 0}, // subroutine
  {"dspr2", 0}, // subroutine
  {"dspr", 0}, // subroutine
  {"dswap", 0}, // subroutine
  {"dsymm", 0}, // subroutine
  {"dsymv", 0}, // subroutine
  {"dsyr2", 0}, // subroutine
  {"dsyr2k", 0}, // subroutine
  {"dsyr", 0}, // subroutine
  {"dsyrk", 0}, // subroutine
  {"dtbmv", 0}, // subroutine
  {"dtbsv", 0}, // subroutine
  {"dtpmv", 0}, // subroutine
  {"dtpsv", 0}, // subroutine
  {"dtrmm", 0}, // subroutine
  {"dtrmv", 0}, // subroutine
  {"dtrsm", 0}, // subroutine
  {"dtrsv", 0}, // subroutine
  {"dzasum", 0}, // real*8 function
  {"dznrm2", 0}, // real*8 function
  {"icamax", 0}, // integer*4 function
  {"idamax", 0}, // integer*4 function
  {"isamax", 0}, // integer*4 function
  {"izamax", 0}, // integer*4 function
  {"sasum", 0}, // real*4 function
  {"saxpy", 0}, // subroutine
  {"scabs1", 0}, // real*4 function
  {"scasum", 0}, // real*4 function
  {"scnrm2", 0}, // real*4 function
  {"scopy", 0}, // subroutine
  {"sdot", 0}, // real*4 function
  {"sdsdot", 0}, // real*4 function
  {"sgbmv", 0}, // subroutine
  {"sgemm", 0}, // subroutine
  {"sgemv", 0}, // subroutine
  {"sger", 0}, // subroutine
  {"snrm2", 0}, // real*4 function
  {"srot", 0}, // subroutine
  {"srotg", 0}, // subroutine
  {"srotm", 0}, // subroutine
  {"srotmg", 0}, // subroutine
  {"ssbmv", 0}, // subroutine
  {"sscal", 0}, // subroutine
  {"sspmv", 0}, // subroutine
  {"sspr2", 0}, // subroutine
  {"sspr", 0}, // subroutine
  {"sswap", 0}, // subroutine
  {"ssymm", 0}, // subroutine
  {"ssymv", 0}, // subroutine
  {"ssyr2", 0}, // subroutine
  {"ssyr2k", 0}, // subroutine
  {"ssyr", 0}, // subroutine
  {"ssyrk", 0}, // subroutine
  {"stbmv", 0}, // subroutine
  {"stbsv", 0}, // subroutine
  {"stpmv", 0}, // subroutine
  {"stpsv", 0}, // subroutine
  {"strmm", 0}, // subroutine
  {"strmv", 0}, // subroutine
  {"strsm", 0}, // subroutine
  {"strsv", 0}, // subroutine
  {"zaxpy", 0}, // subroutine
  {"zcopy", 0}, // subroutine
  {"zdotc", 0}, // complex*16 function
  {"zdotu", 0}, // complex*16 function
  {"zdrot", 0}, // subroutine
  {"zdscal", 0}, // subroutine
  {"zgbmv", 0}, // subroutine
  {"zgemm", 0}, // subroutine
  {"zgemv", 0}, // subroutine
  {"zgerc", 0}, // subroutine
  {"zgeru", 0}, // subroutine
  {"zhbmv", 0}, // subroutine
  {"zhemm", 0}, // subroutine
  {"zhemv", 0}, // subroutine
  {"zher2", 0}, // subroutine
  {"zher2k", 0}, // subroutine
  {"zher", 0}, // subroutine
  {"zherk", 0}, // subroutine
  {"zhpmv", 0}, // subroutine
  {"zhpr2", 0}, // subroutine
  {"zhpr", 0}, // subroutine
  {"zrotg", 0}, // subroutine
  {"zscal", 0}, // subroutine
  {"zswap", 0}, // subroutine
  {"zsymm", 0}, // subroutine
  {"zsyr2k", 0}, // subroutine
  {"zsyrk", 0}, // subroutine
  {"ztbmv", 0}, // subroutine
  {"ztbsv", 0}, // subroutine
  {"ztpmv", 0}, // subroutine
  {"ztpsv", 0}, // subroutine
  {"ztrmm", 0}, // subroutine
  {"ztrmv", 0}, // subroutine
  {"ztrsm", 0}, // subroutine
  {"ztrsv", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _caxpy (int_4 _p_ n_, complex_8 _p_ ca_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 
_p_ incy_);
prototype int_4 _ccopy (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_);
prototype complex_8 _cdotc (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_);
prototype complex_8 _cdotu (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_);
prototype int_4 _cgbmv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_8 _p_ alpha_
, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ 
incy_);
prototype int_4 _cgemm (char _p_ transa_, char _p_ transb_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ 
alpha_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ beta_, complex_8 _p_ c_, 
int_4 _p_ ldc_);
prototype int_4 _cgemv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 _p_ 
lda_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _cgerc (int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 
_p_ y_, int_4 _p_ incy_, complex_8 _p_ a_, int_4 _p_ lda_);
prototype int_4 _cgeru (int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 
_p_ y_, int_4 _p_ incy_, complex_8 _p_ a_, int_4 _p_ lda_);
prototype int_4 _chbmv (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 _p_ 
lda_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _chemm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ 
a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _chemv (char _p_ uplo_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 
_p_ x_, int_4 _p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _cher2 (char _p_ uplo_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, 
complex_8 _p_ y_, int_4 _p_ incy_, complex_8 _p_ a_, int_4 _p_ lda_);
prototype int_4 _cher2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, complex_8 
_p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, real_4 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _cher (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 
_p_ a_, int_4 _p_ lda_);
prototype int_4 _cherk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, complex_8 _p_ 
a_, int_4 _p_ lda_, real_4 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _chpmv (char _p_ uplo_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ ap_, complex_8 _p_ x_, int_4 
_p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _chpr2 (char _p_ uplo_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, 
complex_8 _p_ y_, int_4 _p_ incy_, complex_8 _p_ ap_);
prototype int_4 _chpr (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 
_p_ ap_);
prototype int_4 _crotg (complex_8 _p_ ca_, complex_8 _p_ cb_, real_4 _p_ c_, complex_8 _p_ s_);
prototype int_4 _cscal (int_4 _p_ n_, complex_8 _p_ ca_, complex_8 _p_ cx_, int_4 _p_ incx_);
prototype int_4 _csrot (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_, real_4 
_p_ c_, real_4 _p_ s_);
prototype int_4 _csscal (int_4 _p_ n_, real_4 _p_ sa_, complex_8 _p_ cx_, int_4 _p_ incx_);
prototype int_4 _cswap (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_);
prototype int_4 _csymm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ 
a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _csyr2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, complex_8 
_p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _csyrk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, complex_8 
_p_ a_, int_4 _p_ lda_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _ctbmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ a_, 
int_4 _p_ lda_, complex_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _ctbsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ a_, 
int_4 _p_ lda_, complex_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _ctpmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_8 _p_ ap_, complex_8 _p_ 
x_, int_4 _p_ incx_);
prototype int_4 _ctpsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_8 _p_ ap_, complex_8 _p_ 
x_, int_4 _p_ incx_);
prototype int_4 _ctrmm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, 
complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _ctrmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_
, complex_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _ctrsm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, 
complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _ctrsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_
, complex_8 _p_ x_, int_4 _p_ incx_);
prototype real_8 _dasum (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_);
prototype int_4 _daxpy (int_4 _p_ n_, real_8 _p_ da_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_)
;
prototype real_8 _dcabs1 (complex_16 _p_ z_);
prototype int_4 _dcopy (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_);
prototype real_8 _ddot (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_);
prototype int_4 _dgbmv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ alpha_, 
real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _dgemm (char _p_ transa_, char _p_ transb_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_
, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ beta_, real_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _dgemv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ lda_, 
real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _dger (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ y_, 
int_4 _p_ incy_, real_8 _p_ a_, int_4 _p_ lda_);
prototype real_8 _dnrm2 (int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _drot (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_, real_8 _p_ c_, 
real_8 _p_ s_);
prototype int_4 _drotg (real_8 _p_ da_, real_8 _p_ db_, real_8 _p_ c_, real_8 _p_ s_);
prototype int_4 _drotm (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_, real_8 _p_ 
dparam_);
prototype int_4 _drotmg (real_8 _p_ dd1_, real_8 _p_ dd2_, real_8 _p_ dx1_, real_8 _p_ dy1_, real_8 _p_ dparam_);
prototype int_4 _dsbmv (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ lda_, 
real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _dscal (int_4 _p_ n_, real_8 _p_ da_, real_8 _p_ dx_, int_4 _p_ incx_);
prototype real_8 _dsdot (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_);
prototype int_4 _dspmv (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ ap_, real_8 _p_ x_, int_4 _p_ incx_
, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _dspr2 (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ y_, 
int_4 _p_ incy_, real_8 _p_ ap_);
prototype int_4 _dspr (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ ap_)
;
prototype int_4 _dswap (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_);
prototype int_4 _dsymm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ beta_, real_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _dsymv (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ x_, 
int_4 _p_ incx_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_);
prototype int_4 _dsyr2 (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ y_, 
int_4 _p_ incy_, real_8 _p_ a_, int_4 _p_ lda_);
prototype int_4 _dsyr2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ beta_, real_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _dsyr (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ a_, 
int_4 _p_ lda_);
prototype int_4 _dsyrk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ beta_, real_8 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _dtbmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _dtbsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _dtpmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_8 _p_ ap_, real_8 _p_ x_, 
int_4 _p_ incx_);
prototype int_4 _dtpsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_8 _p_ ap_, real_8 _p_ x_, 
int_4 _p_ incx_);
prototype int_4 _dtrmm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, 
real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _dtrmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, 
real_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _dtrsm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, 
real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _dtrsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, 
real_8 _p_ x_, int_4 _p_ incx_);
prototype real_8 _dzasum (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_);
prototype real_8 _dznrm2 (int_4 _p_ n_, complex_16 _p_ x_, int_4 _p_ incx_);
prototype int_4 _icamax (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_);
prototype int_4 _idamax (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_);
prototype int_4 _isamax (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_);
prototype int_4 _izamax (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_);
prototype real_4 _sasum (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_);
prototype int_4 _saxpy (int_4 _p_ n_, real_4 _p_ sa_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_)
;
prototype real_4 _scabs1 (complex_8 _p_ z_);
prototype real_4 _scasum (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_);
prototype real_4 _scnrm2 (int_4 _p_ n_, complex_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _scopy (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_);
prototype real_4 _sdot (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_);
prototype real_4 _sdsdot (int_4 _p_ n_, real_4 _p_ sb_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ 
incy_);
prototype int_4 _sgbmv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ alpha_, 
real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_);
prototype int_4 _sgemm (char _p_ transa_, char _p_ transb_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_
, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ beta_, real_4 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _sgemv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ lda_, 
real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_);
prototype int_4 _sger (int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ y_, 
int_4 _p_ incy_, real_4 _p_ a_, int_4 _p_ lda_);
prototype real_4 _snrm2 (int_4 _p_ n_, real_4 _p_ x_, int_4 _p_ incx_);
prototype int_4 _srot (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_, real_4 _p_ c_, 
real_4 _p_ s_);
prototype int_4 _srotg (real_4 _p_ sa_, real_4 _p_ sb_, real_4 _p_ c_, real_4 _p_ s_);
prototype int_4 _srotm (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_, real_4 _p_ 
sparam_);
prototype int_4 _srotmg (real_4 _p_ sd1_, real_4 _p_ sd2_, real_4 _p_ sx1_, real_4 _p_ sy1_, real_4 _p_ sparam_);
prototype int_4 _ssbmv (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ lda_, 
real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_);
prototype int_4 _sscal (int_4 _p_ n_, real_4 _p_ sa_, real_4 _p_ sx_, int_4 _p_ incx_);
prototype int_4 _sspmv (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ ap_, real_4 _p_ x_, int_4 _p_ incx_
, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_);
prototype int_4 _sspr2 (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ y_, 
int_4 _p_ incy_, real_4 _p_ ap_);
prototype int_4 _sspr (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ ap_)
;
prototype int_4 _sswap (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_);
prototype int_4 _ssymm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ a_, 
int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ beta_, real_4 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _ssymv (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ x_, 
int_4 _p_ incx_, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_);
prototype int_4 _ssyr2 (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ y_, 
int_4 _p_ incy_, real_4 _p_ a_, int_4 _p_ lda_);
prototype int_4 _ssyr2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, real_4 _p_ a_, 
int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ beta_, real_4 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _ssyr (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ a_, 
int_4 _p_ lda_);
prototype int_4 _ssyrk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, real_4 _p_ a_, 
int_4 _p_ lda_, real_4 _p_ beta_, real_4 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _stbmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ a_, 
int_4 _p_ lda_, real_4 _p_ x_, int_4 _p_ incx_);
prototype int_4 _stbsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ a_, 
int_4 _p_ lda_, real_4 _p_ x_, int_4 _p_ incx_);
prototype int_4 _stpmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_4 _p_ ap_, real_4 _p_ x_, 
int_4 _p_ incx_);
prototype int_4 _stpsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_4 _p_ ap_, real_4 _p_ x_, 
int_4 _p_ incx_);
prototype int_4 _strmm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, 
real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _strmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, 
real_4 _p_ x_, int_4 _p_ incx_);
prototype int_4 _strsm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, 
real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _strsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, 
real_4 _p_ x_, int_4 _p_ incx_);
prototype int_4 _zaxpy (int_4 _p_ n_, complex_16 _p_ za_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, 
int_4 _p_ incy_);
prototype int_4 _zcopy (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ incy_);
prototype complex_16 _zdotc (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ incy_);
prototype complex_16 _zdotu (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ incy_);
prototype int_4 _zdrot (int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ incx_, complex_16 _p_ cy_, int_4 _p_ incy_, real_8 
_p_ c_, real_8 _p_ s_);
prototype int_4 _zdscal (int_4 _p_ n_, real_8 _p_ da_, complex_16 _p_ zx_, int_4 _p_ incx_);
prototype int_4 _zgbmv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_16 _p_ 
alpha_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, 
int_4 _p_ incy_);
prototype int_4 _zgemm (char _p_ transa_, char _p_ transb_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ 
alpha_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ beta_, complex_16 _p_ c_, 
int_4 _p_ ldc_);
prototype int_4 _zgemv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ a_, int_4 
_p_ lda_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 _p_ incy_);
prototype int_4 _zgerc (int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, 
complex_16 _p_ y_, int_4 _p_ incy_, complex_16 _p_ a_, int_4 _p_ lda_);
prototype int_4 _zgeru (int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, 
complex_16 _p_ y_, int_4 _p_ incy_, complex_16 _p_ a_, int_4 _p_ lda_);
prototype int_4 _zhbmv (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, complex_16 _p_ a_, int_4 _p_ 
lda_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 _p_ incy_);
prototype int_4 _zhemm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 
_p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _zhemv (char _p_ uplo_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ a_, int_4 _p_ lda_, 
complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 _p_ incy_);
prototype int_4 _zher2 (char _p_ uplo_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, 
complex_16 _p_ y_, int_4 _p_ incy_, complex_16 _p_ a_, int_4 _p_ lda_);
prototype int_4 _zher2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, complex_16 
_p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, real_8 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _zher (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 
_p_ a_, int_4 _p_ lda_);
prototype int_4 _zherk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, complex_16 _p_ 
a_, int_4 _p_ lda_, real_8 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _zhpmv (char _p_ uplo_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ ap_, complex_16 _p_ x_, 
int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 _p_ incy_);
prototype int_4 _zhpr2 (char _p_ uplo_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, 
complex_16 _p_ y_, int_4 _p_ incy_, complex_16 _p_ ap_);
prototype int_4 _zhpr (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 
_p_ ap_);
prototype int_4 _zrotg (complex_16 _p_ ca_, complex_16 _p_ cb_, real_8 _p_ c_, complex_16 _p_ s_);
prototype int_4 _zscal (int_4 _p_ n_, complex_16 _p_ za_, complex_16 _p_ zx_, int_4 _p_ incx_);
prototype int_4 _zswap (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ incy_);
prototype int_4 _zsymm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 
_p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _zsyr2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, complex_16 
_p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _zsyrk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, complex_16 
_p_ a_, int_4 _p_ lda_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_);
prototype int_4 _ztbmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ x_, int_4 _p_ incx_);
prototype int_4 _ztbsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ x_, int_4 _p_ incx_);
prototype int_4 _ztpmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_16 _p_ ap_, complex_16 
_p_ x_, int_4 _p_ incx_);
prototype int_4 _ztpsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_16 _p_ ap_, complex_16 
_p_ x_, int_4 _p_ incx_);
prototype int_4 _ztrmm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, 
complex_16 _p_ alpha_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _ztrmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ 
lda_, complex_16 _p_ x_, int_4 _p_ incx_);
prototype int_4 _ztrsm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, 
complex_16 _p_ alpha_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _ztrsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ 
lda_, complex_16 _p_ x_, int_4 _p_ incx_);
int_4 _caxpy (int_4 _p_ n_, complex_8 _p_ ca_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if (_scabs1 (ca_) == 0.0e+0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    cy_[iy_ - 1] = cy_[iy_ - 1] + (*ca_) * cx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    cy_[i_ - 1] = cy_[i_ - 1] + (*ca_) * cx_[i_ - 1];
  }
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _ccopy (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    cy_[iy_ - 1] = cx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    cy_[i_ - 1] = cx_[i_ - 1];
  }
  _l0:;
  __calls[1].calls++;
  return 0;
}

complex_8 _cdotc (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  static complex_8 ctemp_;
  complex_8 cdotc_;
  ctemp_ = CMPLXF (0.0, 0.0);
  cdotc_ = CMPLXF (0.0, 0.0);
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = ctemp_ + conjf (cx_[ix_ - 1]) * cy_[iy_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  cdotc_ = ctemp_;
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = ctemp_ + conjf (cx_[i_ - 1]) * cy_[i_ - 1];
  }
  cdotc_ = ctemp_;
  _l0:;
  __calls[2].calls++;
  return cdotc_;
}

complex_8 _cdotu (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  static complex_8 ctemp_;
  complex_8 cdotu_;
  ctemp_ = CMPLXF (0.0, 0.0);
  cdotu_ = CMPLXF (0.0, 0.0);
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = ctemp_ + cx_[ix_ - 1] * cy_[iy_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  cdotu_ = ctemp_;
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = ctemp_ + cx_[i_ - 1] * cy_[i_ - 1];
  }
  cdotu_ = ctemp_;
  _l0:;
  __calls[3].calls++;
  return cdotu_;
}

int_4 _cgbmv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_8 _p_ alpha_, 
complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ 
incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kup1_, kx_, ky_, lenx_, leny_;
  static logical_4 noconj_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 1;
  }
  else if ((*m_) < 0) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*kl_) < 0) {
    info_ = 4;
  }
  else if ((*ku_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*kl_) + (*ku_) + 1)) {
    info_ = 8;
  }
  else if ((*incx_) == 0) {
    info_ = 10;
  }
  else if ((*incy_) == 0) {
    info_ = 13;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_3, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == CMPLXF (0.0, 0.0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  if (_lsame (trans_, _dc_0)) {
    lenx_ = (*n_);
    leny_ = (*m_);
  }
  else {
    lenx_ = (*m_);
    leny_ = (*n_);
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - (lenx_ - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - (leny_ - 1) * (*incy_);
  }
  if ((*beta_) != CMPLXF (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = CMPLXF (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = CMPLXF (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    goto _l0;
  }
  kup1_ = (*ku_) + 1;
  if (_lsame (trans_, _dc_0)) {
    jx_ = kx_;
    if ((*incy_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          k_ = kup1_ - j_;
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            y_[i_ - 1] = y_[i_ - 1] + temp_ * a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          iy_ = ky_;
          k_ = kup1_ - j_;
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            y_[iy_ - 1] = y_[iy_ - 1] + temp_ * a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        if (j_ > (*ku_)) {
          ky_ = ky_ + (*incy_);
        }
      }
    }
  }
  else {
    jy_ = ky_;
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = CMPLXF (0.0, 0.0);
        k_ = kup1_ - j_;
        if (noconj_) {
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            temp_ = temp_ + a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
        }
        else {
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            temp_ = temp_ + conjf (a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
          }
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = CMPLXF (0.0, 0.0);
        ix_ = kx_;
        k_ = kup1_ - j_;
        if (noconj_) {
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            temp_ = temp_ + a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
        }
        else {
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            temp_ = temp_ + conjf (a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
        if (j_ > (*ku_)) {
          kx_ = kx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _cgemm (char _p_ transa_, char _p_ transb_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, 
complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ 
ldc_)
{
  static int_4 i_, info_, j_, l_, ncola_, nrowa_, nrowb_;
  static logical_4 conja_, conjb_, nota_, notb_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  nota_ = _lsame (transa_, _dc_0);
  notb_ = _lsame (transb_, _dc_0);
  conja_ = _lsame (transa_, _dc_2);
  conjb_ = _lsame (transb_, _dc_2);
  if (nota_) {
    nrowa_ = (*m_);
    ncola_ = (*k_);
  }
  else {
    nrowa_ = (*k_);
    ncola_ = (*m_);
  }
  if (notb_) {
    nrowb_ = (*k_);
  }
  else {
    nrowb_ = (*n_);
  }
  info_ = 0;
  if ((! (nota_)) && (! (conja_)) && (! (_lsame (transa_, _dc_1)))) {
    info_ = 1;
  }
  else if ((! (notb_)) && (! (conjb_)) && (! (_lsame (transb_, _dc_1)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 8;
  }
  else if ((*ldb_) < _max (1, nrowb_)) {
    info_ = 10;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 13;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_4, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((((*alpha_) == CMPLXF (0.0, 0.0)) || ((*k_) == 0)) && ((*beta_) == CMPLXF (1.0, 
    0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    if ((*beta_) == CMPLXF (0.0, 0.0)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (notb_) {
    if (nota_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLXF (0.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLXF (1.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
            temp_ = (*alpha_) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else if (conja_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + conjf (a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  else if (nota_) {
    if (conjb_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLXF (0.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLXF (1.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLXF (0.0, 0.0)) {
            temp_ = (*alpha_) * conjf (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLXF (0.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLXF (1.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLXF (0.0, 0.0)) {
            temp_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
  }
  else if (conja_) {
    if (conjb_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + conjf (a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * conjf (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + conjf (a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  else {
    if (conjb_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * conjf (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _cgemv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 _p_ lda_, 
complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_, lenx_, leny_;
  static logical_4 noconj_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 1;
  }
  else if ((*m_) < 0) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  else if ((*incy_) == 0) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_5, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == CMPLXF (0.0, 0.0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  if (_lsame (trans_, _dc_0)) {
    lenx_ = (*n_);
    leny_ = (*m_);
  }
  else {
    lenx_ = (*m_);
    leny_ = (*n_);
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - (lenx_ - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - (leny_ - 1) * (*incy_);
  }
  if ((*beta_) != CMPLXF (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = CMPLXF (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = CMPLXF (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    jx_ = kx_;
    if ((*incy_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            y_[i_ - 1] = y_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          iy_ = ky_;
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            y_[iy_ - 1] = y_[iy_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  else {
    jy_ = ky_;
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = CMPLXF (0.0, 0.0);
        if (noconj_) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
        }
        else {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = temp_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
          }
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = CMPLXF (0.0, 0.0);
        ix_ = kx_;
        if (noconj_) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
        }
        else {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = temp_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[6].calls++;
  return 0;
}

int_4 _cgerc (int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ y_, 
int_4 _p_ incy_, complex_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, j_, jy_, kx_;
  static complex_8 temp_;
  extern int_4 _xerbla ();
  info_ = 0;
  if ((*m_) < 0) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_6, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((*alpha_) == CMPLXF (0.0, 0.0))) {
    goto _l0;
  }
  if ((*incy_) > 0) {
    jy_ = 1;
  }
  else {
    jy_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*incx_) == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != CMPLXF (0.0, 0.0)) {
        temp_ = (*alpha_) * conjf (y_[jy_ - 1]);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  else {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*m_) - 1) * (*incx_);
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != CMPLXF (0.0, 0.0)) {
        temp_ = (*alpha_) * conjf (y_[jy_ - 1]);
        ix_ = kx_;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
          ix_ = ix_ + (*incx_);
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  _l0:;
  __calls[7].calls++;
  return 0;
}

int_4 _cgeru (int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ y_, 
int_4 _p_ incy_, complex_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, j_, jy_, kx_;
  static complex_8 temp_;
  extern int_4 _xerbla ();
  info_ = 0;
  if ((*m_) < 0) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_7, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((*alpha_) == CMPLXF (0.0, 0.0))) {
    goto _l0;
  }
  if ((*incy_) > 0) {
    jy_ = 1;
  }
  else {
    jy_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*incx_) == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != CMPLXF (0.0, 0.0)) {
        temp_ = (*alpha_) * y_[jy_ - 1];
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  else {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*m_) - 1) * (*incx_);
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != CMPLXF (0.0, 0.0)) {
        temp_ = (*alpha_) * y_[jy_ - 1];
        ix_ = kx_;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
          ix_ = ix_ + (*incx_);
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _chbmv (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 _p_ lda_, 
complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kplus1_, kx_, ky_, l_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*k_) < 0) {
    info_ = 3;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  else if ((*incy_) == 0) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_10, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == CMPLXF (0.0, 0.0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != CMPLXF (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = CMPLXF (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = CMPLXF (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    goto _l0;
  }
  if (_lsame (uplo_, _dc_8)) {
    kplus1_ = (*k_) + 1;
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        l_ = kplus1_ - j_;
        for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_4) (crealf (a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))])) + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        ix_ = kx_;
        iy_ = ky_;
        l_ = kplus1_ - j_;
        for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_4) (crealf (a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))])) + (*alpha_) * temp2_
        ;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        if (j_ > (*k_)) {
          kx_ = kx_ + (*incx_);
          ky_ = ky_ + (*incy_);
        }
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_4) (crealf (a_[0 + ((*lda_)) * ((j_ - 1))]));
        l_ = 1 - j_;
        for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_4) (crealf (a_[0 + ((*lda_)) * ((j_ - 1))]));
        l_ = 1 - j_;
        ix_ = jx_;
        iy_ = jy_;
        for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[9].calls++;
  return 0;
}

int_4 _chemm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 
_p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 upper_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (side_, _dc_9)) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (_lsame (side_, _dc_9))) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_12, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == CMPLXF (0.0, 0.0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    if ((*beta_) == CMPLXF (0.0, 0.0)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (_lsame (side_, _dc_9)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = CMPLXF (0.0, 0.0);
          for (k_ = 1; k_ <= i_ - 1; (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * conjf (a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]);
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * (real_4) (crealf (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))])) + (*alpha_) * 
            temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * (real_4) (crealf (a_[i_ 
            - 1 + ((*lda_)) * ((i_ - 1))])) + (*alpha_) * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = (*m_); i_ >= 1; (i_)--) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = CMPLXF (0.0, 0.0);
          for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * conjf (a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]);
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * (real_4) (crealf (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))])) + (*alpha_) * 
            temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * (real_4) (crealf (a_[i_ 
            - 1 + ((*lda_)) * ((i_ - 1))])) + (*alpha_) * temp2_;
          }
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      temp1_ = (*alpha_) * (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      else {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
      }
      for (k_ = 1; k_ <= j_ - 1; (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
      for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
        }
        else {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
    }
  }
  _l0:;
  __calls[10].calls++;
  return 0;
}

int_4 _chemv (char _p_ uplo_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ x_, 
int_4 _p_ incx_, complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 5;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  else if ((*incy_) == 0) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_13, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == CMPLXF (0.0, 0.0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != CMPLXF (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = CMPLXF (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = CMPLXF (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    goto _l0;
  }
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        ix_ = kx_;
        iy_ = ky_;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        ix_ = jx_;
        iy_ = jy_;
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _cher2 (char _p_ uplo_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ y_, 
int_4 _p_ incy_, complex_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_14, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == CMPLXF (0.0, 0.0))) {
    goto _l0;
  }
  if (((*incx_) != 1) || ((*incy_) != 1)) {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*n_) - 1) * (*incx_);
    }
    if ((*incy_) > 0) {
      ky_ = 1;
    }
    else {
      ky_ = 1 - ((*n_) - 1) * (*incy_);
    }
    jx_ = kx_;
    jy_ = ky_;
  }
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != CMPLXF (0.0, 0.0)) || (y_[j_ - 1] != CMPLXF (0.0, 0.0))) {
          temp1_ = (*alpha_) * conjf (y_[j_ - 1]);
          temp2_ = conjf ((*alpha_) * x_[j_ - 1]);
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
          }
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_4) (crealf (x_[j_ 
          - 1] * temp1_ + y_[j_ - 1] * temp2_));
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != CMPLXF (0.0, 0.0)) || (y_[jy_ - 1] != CMPLXF (0.0, 0.0))) {
          temp1_ = (*alpha_) * conjf (y_[jy_ - 1]);
          temp2_ = conjf ((*alpha_) * x_[jx_ - 1]);
          ix_ = kx_;
          iy_ = ky_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_
            ;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_4) (crealf 
          (x_[jx_ - 1] * temp1_ + y_[jy_ - 1] * temp2_));
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != CMPLXF (0.0, 0.0)) || (y_[j_ - 1] != CMPLXF (0.0, 0.0))) {
          temp1_ = (*alpha_) * conjf (y_[j_ - 1]);
          temp2_ = conjf ((*alpha_) * x_[j_ - 1]);
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_4) (crealf (x_[j_ 
          - 1] * temp1_ + y_[j_ - 1] * temp2_));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
          }
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != CMPLXF (0.0, 0.0)) || (y_[jy_ - 1] != CMPLXF (0.0, 0.0))) {
          temp1_ = (*alpha_) * conjf (y_[jy_ - 1]);
          temp2_ = conjf ((*alpha_) * x_[jx_ - 1]);
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_4) (crealf 
          (x_[jx_ - 1] * temp1_ + y_[jy_ - 1] * temp2_));
          ix_ = jx_;
          iy_ = jy_;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_
            ;
          }
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _cher2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, complex_8 _p_ a_, 
int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, real_4 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_2)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_15, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == CMPLXF (0.0, 0.0)) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    if (upper_) {
      if ((*beta_) == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      if ((*beta_) == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLXF (0.0, 0.0)) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLXF (0.0, 
            0.0))) {
            temp1_ = (*alpha_) * conjf (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
            temp2_ = conjf ((*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))]);
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
            c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_4) (crealf (a_[j_ 
            - 1 + ((*lda_)) * ((l_ - 1))] * temp1_ + b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_));
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLXF (0.0, 0.0)) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLXF (0.0, 
            0.0))) {
            temp1_ = (*alpha_) * conjf (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
            temp2_ = conjf ((*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))]);
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
            c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_4) (crealf (a_[j_ 
            - 1 + ((*lda_)) * ((l_ - 1))] * temp1_ + b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_));
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp1_ = CMPLXF (0.0, 0.0);
          temp2_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + conjf (a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + conjf (b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if (i_ == j_) {
            if ((*beta_) == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
              c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf ((*alpha_) * temp1_ + conjf ((*alpha_)) * temp2_));
            }
            else {
              c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_4) 
              (crealf ((*alpha_) * temp1_ + conjf ((*alpha_)) * temp2_));
            }
          }
          else {
            if ((*beta_) == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + conjf ((*alpha_)) * temp2_;
            }
            else {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + conjf 
              ((*alpha_)) * temp2_;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp1_ = CMPLXF (0.0, 0.0);
          temp2_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + conjf (a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + conjf (b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if (i_ == j_) {
            if ((*beta_) == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
              c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf ((*alpha_) * temp1_ + conjf ((*alpha_)) * temp2_));
            }
            else {
              c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_4) 
              (crealf ((*alpha_) * temp1_ + conjf ((*alpha_)) * temp2_));
            }
          }
          else {
            if ((*beta_) == (real_4) (crealf (CMPLXF (0.0, 0.0)))) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + conjf ((*alpha_)) * temp2_;
            }
            else {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + conjf 
              ((*alpha_)) * temp2_;
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[13].calls++;
  return 0;
}

int_4 _cher (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ a_, 
int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_16, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == (real_4) (crealf (CMPLXF (0.0, 0.0))))) {
    goto _l0;
  }
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (uplo_, _dc_8)) {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * conjf (x_[j_ - 1]);
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
          }
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_4) (crealf (x_[j_ 
          - 1] * temp_));
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * conjf (x_[jx_ - 1]);
          ix_ = kx_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_4) (crealf 
          (x_[jx_ - 1] * temp_));
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  else {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * conjf (x_[j_ - 1]);
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_4) (crealf (temp_ 
          * x_[j_ - 1]));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
          }
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * conjf (x_[jx_ - 1]);
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_4) (crealf (temp_ 
          * x_[jx_ - 1]));
          ix_ = jx_;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ix_ = ix_ + (*incx_);
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
          }
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _cherk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, complex_8 _p_ a_, int_4 
_p_ lda_, real_4 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static real_4 rtemp_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_2)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_17, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == 0.0) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if (upper_) {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != (complex_8) (0.0)) {
            temp_ = (*alpha_) * conjf (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))]);
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
            c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_4) (crealf (temp_ 
            * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]));
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != (complex_8) (0.0)) {
            temp_ = (*alpha_) * conjf (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))]);
            c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_4) (crealf (temp_ 
            * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))]));
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + conjf (a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        rtemp_ = 0.0;
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          rtemp_ = (real_4) (crealf (rtemp_ + conjf (a_[l_ - 1 + ((*lda_)) * ((j_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))]))
          ;
        }
        if ((*beta_) == 0.0) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * rtemp_;
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * rtemp_ + (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 
          1))]));
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        rtemp_ = 0.0;
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          rtemp_ = (real_4) (crealf (rtemp_ + conjf (a_[l_ - 1 + ((*lda_)) * ((j_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))]))
          ;
        }
        if ((*beta_) == 0.0) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * rtemp_;
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * rtemp_ + (*beta_) * (real_4) (crealf (c_[j_ - 1 + ((*ldc_)) * ((j_ - 
          1))]));
        }
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + conjf (a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[15].calls++;
  return 0;
}

int_4 _chpmv (char _p_ uplo_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ ap_, complex_8 _p_ x_, int_4 _p_ incx_, 
complex_8 _p_ beta_, complex_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kk_, kx_, ky_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 6;
  }
  else if ((*incy_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_18, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == CMPLXF (0.0, 0.0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != CMPLXF (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = CMPLXF (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = CMPLXF (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    goto _l0;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        k_ = kk_;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + conjf (ap_[k_ - 1]) * x_[i_ - 1];
          k_ = k_ + 1;
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_4) (crealf (ap_[kk_ + j_ - 1 - 1])) + (*alpha_) * temp2_;
        kk_ = kk_ + j_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        ix_ = kx_;
        iy_ = ky_;
        for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + conjf (ap_[k_ - 1]) * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_4) (crealf (ap_[kk_ + j_ - 1 - 1])) + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_4) (crealf (ap_[kk_ - 1]));
        k_ = kk_ + 1;
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + conjf (ap_[k_ - 1]) * x_[i_ - 1];
          k_ = k_ + 1;
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
        kk_ = kk_ + ((*n_) - j_ + 1);
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLXF (0.0, 0.0);
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_4) (crealf (ap_[kk_ - 1]));
        ix_ = jx_;
        iy_ = jy_;
        for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + conjf (ap_[k_ - 1]) * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + ((*n_) - j_ + 1);
      }
    }
  }
  _l0:;
  __calls[16].calls++;
  return 0;
}

int_4 _chpr2 (char _p_ uplo_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ y_, 
int_4 _p_ incy_, complex_8 _p_ ap_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kk_, kx_, ky_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_19, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == CMPLXF (0.0, 0.0))) {
    goto _l0;
  }
  if (((*incx_) != 1) || ((*incy_) != 1)) {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*n_) - 1) * (*incx_);
    }
    if ((*incy_) > 0) {
      ky_ = 1;
    }
    else {
      ky_ = 1 - ((*n_) - 1) * (*incy_);
    }
    jx_ = kx_;
    jy_ = ky_;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != CMPLXF (0.0, 0.0)) || (y_[j_ - 1] != CMPLXF (0.0, 0.0))) {
          temp1_ = (*alpha_) * conjf (y_[j_ - 1]);
          temp2_ = conjf ((*alpha_) * x_[j_ - 1]);
          k_ = kk_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
            k_ = k_ + 1;
          }
          ap_[kk_ + j_ - 1 - 1] = (real_4) (crealf (ap_[kk_ + j_ - 1 - 1])) + (real_4) (crealf (x_[j_ - 1] * temp1_ + y_[j_ - 1] 
          * temp2_));
        }
        else {
          ap_[kk_ + j_ - 1 - 1] = (real_4) (crealf (ap_[kk_ + j_ - 1 - 1]));
        }
        kk_ = kk_ + j_;
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != CMPLXF (0.0, 0.0)) || (y_[jy_ - 1] != CMPLXF (0.0, 0.0))) {
          temp1_ = (*alpha_) * conjf (y_[jy_ - 1]);
          temp2_ = conjf ((*alpha_) * x_[jx_ - 1]);
          ix_ = kx_;
          iy_ = ky_;
          for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
          ap_[kk_ + j_ - 1 - 1] = (real_4) (crealf (ap_[kk_ + j_ - 1 - 1])) + (real_4) (crealf (x_[jx_ - 1] * temp1_ + y_[jy_ - 
          1] * temp2_));
        }
        else {
          ap_[kk_ + j_ - 1 - 1] = (real_4) (crealf (ap_[kk_ + j_ - 1 - 1]));
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != CMPLXF (0.0, 0.0)) || (y_[j_ - 1] != CMPLXF (0.0, 0.0))) {
          temp1_ = (*alpha_) * conjf (y_[j_ - 1]);
          temp2_ = conjf ((*alpha_) * x_[j_ - 1]);
          ap_[kk_ - 1] = (real_4) (crealf (ap_[kk_ - 1])) + (real_4) (crealf (x_[j_ - 1] * temp1_ + y_[j_ - 1] * temp2_));
          k_ = kk_ + 1;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
            k_ = k_ + 1;
          }
        }
        else {
          ap_[kk_ - 1] = (real_4) (crealf (ap_[kk_ - 1]));
        }
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != CMPLXF (0.0, 0.0)) || (y_[jy_ - 1] != CMPLXF (0.0, 0.0))) {
          temp1_ = (*alpha_) * conjf (y_[jy_ - 1]);
          temp2_ = conjf ((*alpha_) * x_[jx_ - 1]);
          ap_[kk_ - 1] = (real_4) (crealf (ap_[kk_ - 1])) + (real_4) (crealf (x_[jx_ - 1] * temp1_ + y_[jy_ - 1] * temp2_));
          ix_ = jx_;
          iy_ = jy_;
          for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_;
          }
        }
        else {
          ap_[kk_ - 1] = (real_4) (crealf (ap_[kk_ - 1]));
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
  }
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _chpr (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ ap_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_20, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == (real_4) (crealf (CMPLXF (0.0, 0.0))))) {
    goto _l0;
  }
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * conjf (x_[j_ - 1]);
          k_ = kk_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp_;
            k_ = k_ + 1;
          }
          ap_[kk_ + j_ - 1 - 1] = (real_4) (crealf (ap_[kk_ + j_ - 1 - 1])) + (real_4) (crealf (x_[j_ - 1] * temp_));
        }
        else {
          ap_[kk_ + j_ - 1 - 1] = (real_4) (crealf (ap_[kk_ + j_ - 1 - 1]));
        }
        kk_ = kk_ + j_;
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * conjf (x_[jx_ - 1]);
          ix_ = kx_;
          for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
          ap_[kk_ + j_ - 1 - 1] = (real_4) (crealf (ap_[kk_ + j_ - 1 - 1])) + (real_4) (crealf (x_[jx_ - 1] * temp_));
        }
        else {
          ap_[kk_ + j_ - 1 - 1] = (real_4) (crealf (ap_[kk_ + j_ - 1 - 1]));
        }
        jx_ = jx_ + (*incx_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * conjf (x_[j_ - 1]);
          ap_[kk_ - 1] = (real_4) (crealf (ap_[kk_ - 1])) + (real_4) (crealf (temp_ * x_[j_ - 1]));
          k_ = kk_ + 1;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp_;
            k_ = k_ + 1;
          }
        }
        else {
          ap_[kk_ - 1] = (real_4) (crealf (ap_[kk_ - 1]));
        }
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
          temp_ = (*alpha_) * conjf (x_[jx_ - 1]);
          ap_[kk_ - 1] = (real_4) (crealf (ap_[kk_ - 1])) + (real_4) (crealf (temp_ * x_[jx_ - 1]));
          ix_ = jx_;
          for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ix_ = ix_ + (*incx_);
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp_;
          }
        }
        else {
          ap_[kk_ - 1] = (real_4) (crealf (ap_[kk_ - 1]));
        }
        jx_ = jx_ + (*incx_);
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
  }
  _l0:;
  __calls[18].calls++;
  return 0;
}

int_4 _crotg (complex_8 _p_ ca_, complex_8 _p_ cb_, real_4 _p_ c_, complex_8 _p_ s_)
{
  static real_4 norm_, scale_;
  static complex_8 alpha_;
  real_4 $0_, $1_;
  if (cabsf ((*ca_)) != 0.0) {
    goto _l10;
  }
  (*c_) = 0.0;
  (*s_) = CMPLXF (1.0, 0.0);
  (*ca_) = (*cb_);
  goto _l20;
  _l10:;
  scale_ = cabsf ((*ca_)) + cabsf ((*cb_));
  norm_ = scale_ * sqrtf (($0_ = (cabsf ((*ca_) / scale_)), $0_ * $0_) + ($1_ = (cabsf ((*cb_) / scale_)), $1_ * $1_));
  alpha_ = (*ca_) / cabsf ((*ca_));
  (*c_) = cabsf ((*ca_)) / norm_;
  (*s_) = alpha_ * conjf ((*cb_)) / norm_;
  (*ca_) = alpha_ * norm_;
  _l20:;
  __calls[19].calls++;
  return 0;
}

int_4 _cscal (int_4 _p_ n_, complex_8 _p_ ca_, complex_8 _p_ cx_, int_4 _p_ incx_)
{
  static int_4 i_, nincx_;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    cx_[i_ - 1] = (*ca_) * cx_[i_ - 1];
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    cx_[i_ - 1] = (*ca_) * cx_[i_ - 1];
  }
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _csrot (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_, real_4 _p_ c_, 
real_4 _p_ s_)
{
  static int_4 i_, ix_, iy_;
  static complex_8 ctemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = (*c_) * cx_[ix_ - 1] + (*s_) * cy_[iy_ - 1];
    cy_[iy_ - 1] = (*c_) * cy_[iy_ - 1] - (*s_) * cx_[ix_ - 1];
    cx_[ix_ - 1] = ctemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = (*c_) * cx_[i_ - 1] + (*s_) * cy_[i_ - 1];
    cy_[i_ - 1] = (*c_) * cy_[i_ - 1] - (*s_) * cx_[i_ - 1];
    cx_[i_ - 1] = ctemp_;
  }
  _l0:;
  __calls[21].calls++;
  return 0;
}

int_4 _csscal (int_4 _p_ n_, real_4 _p_ sa_, complex_8 _p_ cx_, int_4 _p_ incx_)
{
  static int_4 i_, nincx_;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    cx_[i_ - 1] = CMPLXF ((*sa_) * (real_4) (crealf (cx_[i_ - 1])), (*sa_) * cimagf (cx_[i_ - 1]));
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    cx_[i_ - 1] = CMPLXF ((*sa_) * (real_4) (crealf (cx_[i_ - 1])), (*sa_) * cimagf (cx_[i_ - 1]));
  }
  _l0:;
  __calls[22].calls++;
  return 0;
}

int_4 _cswap (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  static complex_8 ctemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = cx_[ix_ - 1];
    cx_[ix_ - 1] = cy_[iy_ - 1];
    cy_[iy_ - 1] = ctemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = cx_[i_ - 1];
    cx_[i_ - 1] = cy_[i_ - 1];
    cy_[i_ - 1] = ctemp_;
  }
  _l0:;
  __calls[23].calls++;
  return 0;
}

int_4 _csymm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ a_, int_4 
_p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 upper_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (side_, _dc_9)) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (_lsame (side_, _dc_9))) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_21, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == CMPLXF (0.0, 0.0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    if ((*beta_) == CMPLXF (0.0, 0.0)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (_lsame (side_, _dc_9)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = CMPLXF (0.0, 0.0);
          for (k_ = 1; k_ <= i_ - 1; (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((i_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[i_ - 1 + ((*lda_)) * 
            ((i_ - 1))] + (*alpha_) * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = (*m_); i_ >= 1; (i_)--) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = CMPLXF (0.0, 0.0);
          for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((i_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[i_ - 1 + ((*lda_)) * 
            ((i_ - 1))] + (*alpha_) * temp2_;
          }
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      else {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
      }
      for (k_ = 1; k_ <= j_ - 1; (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
      for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
    }
  }
  _l0:;
  __calls[24].calls++;
  return 0;
}

int_4 _csyr2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, complex_8 _p_ a_, 
int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static complex_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_1)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_22, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == CMPLXF (0.0, 0.0)) || ((*k_) == 0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    if (upper_) {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLXF (0.0, 0.0)) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLXF (1.0, 0.0)) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLXF (0.0, 0.0)) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLXF (0.0, 
            0.0))) {
            temp1_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            temp2_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= j_; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLXF (0.0, 0.0)) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLXF (1.0, 0.0)) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLXF (0.0, 0.0)) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLXF (0.0, 
            0.0))) {
            temp1_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            temp2_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = j_; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp1_ = CMPLXF (0.0, 0.0);
          temp2_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + (*alpha_) * 
            temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp1_ = CMPLXF (0.0, 0.0);
          temp2_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + (*alpha_) * 
            temp2_;
          }
        }
      }
    }
  }
  _l0:;
  __calls[25].calls++;
  return 0;
}

int_4 _csyrk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ alpha_, complex_8 _p_ a_, 
int_4 _p_ lda_, complex_8 _p_ beta_, complex_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_1)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_23, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == CMPLXF (0.0, 0.0)) || ((*k_) == 0)) && ((*beta_) == CMPLXF (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    if (upper_) {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*beta_) == CMPLXF (0.0, 0.0)) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLXF (0.0, 0.0)) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLXF (1.0, 0.0)) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLXF (0.0, 0.0)) {
            temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= j_; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLXF (0.0, 0.0)) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLXF (1.0, 0.0)) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLXF (0.0, 0.0)) {
            temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = j_; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp_ = CMPLXF (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLXF (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _ctbmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ a_, int_4 _p_ 
lda_, complex_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kplus1_, kx_, l_;
  static logical_4 noconj_, nounit_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 7;
  }
  else if ((*incx_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_24, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            l_ = kplus1_ - j_;
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            l_ = kplus1_ - j_;
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
          if (j_ > (*k_)) {
            kx_ = kx_ + (*incx_);
          }
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            l_ = 1 - j_;
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            l_ = 1 - j_;
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
          if (((*n_) - j_) >= (*k_)) {
            kx_ = kx_ - (*incx_);
          }
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          l_ = kplus1_ - j_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              temp_ = temp_ + conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          kx_ = kx_ - (*incx_);
          ix_ = kx_;
          l_ = kplus1_ - j_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              temp_ = temp_ + conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          l_ = 1 - j_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (a_[0 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              temp_ = temp_ + conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          kx_ = kx_ + (*incx_);
          ix_ = kx_;
          l_ = 1 - j_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (a_[0 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              temp_ = temp_ + conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[27].calls++;
  return 0;
}

int_4 _ctbsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ a_, int_4 _p_ 
lda_, complex_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kplus1_, kx_, l_;
  static logical_4 noconj_, nounit_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 7;
  }
  else if ((*incx_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_25, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            l_ = kplus1_ - j_;
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          kx_ = kx_ - (*incx_);
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            ix_ = kx_;
            l_ = kplus1_ - j_;
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            l_ = 1 - j_;
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          kx_ = kx_ + (*incx_);
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            ix_ = kx_;
            l_ = 1 - j_;
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          l_ = kplus1_ - j_;
          if (noconj_) {
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / conjf (a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          l_ = kplus1_ - j_;
          if (noconj_) {
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / conjf (a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          if (j_ > (*k_)) {
            kx_ = kx_ + (*incx_);
          }
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          l_ = 1 - j_;
          if (noconj_) {
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / conjf (a_[0 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          l_ = 1 - j_;
          if (noconj_) {
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - conjf (a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / conjf (a_[0 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          if (((*n_) - j_) >= (*k_)) {
            kx_ = kx_ - (*incx_);
          }
        }
      }
    }
  }
  _l0:;
  __calls[28].calls++;
  return 0;
}

int_4 _ctpmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_8 _p_ ap_, complex_8 _p_ x_, int_4 
_p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static logical_4 noconj_, nounit_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_26, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            k_ = kk_;
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * ap_[k_ - 1];
              k_ = k_ + 1;
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * ap_[kk_ + j_ - 1 - 1];
            }
          }
          kk_ = kk_ + j_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * ap_[k_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * ap_[kk_ + j_ - 1 - 1];
            }
          }
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + j_;
        }
      }
    }
    else {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            k_ = kk_;
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * ap_[k_ - 1];
              k_ = k_ - 1;
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * ap_[k_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          k_ = kk_ - 1;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * ap_[kk_ - 1];
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              temp_ = temp_ + ap_[k_ - 1] * x_[i_ - 1];
              k_ = k_ - 1;
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (ap_[kk_ - 1]);
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              temp_ = temp_ + conjf (ap_[k_ - 1]) * x_[i_ - 1];
              k_ = k_ - 1;
            }
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ - j_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * ap_[kk_ - 1];
            }
            for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
              ix_ = ix_ - (*incx_);
              temp_ = temp_ + ap_[k_ - 1] * x_[ix_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (ap_[kk_ - 1]);
            }
            for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
              ix_ = ix_ - (*incx_);
              temp_ = temp_ + conjf (ap_[k_ - 1]) * x_[ix_ - 1];
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - j_;
        }
      }
    }
    else {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          k_ = kk_ + 1;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * ap_[kk_ - 1];
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              temp_ = temp_ + ap_[k_ - 1] * x_[i_ - 1];
              k_ = k_ + 1;
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (ap_[kk_ - 1]);
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              temp_ = temp_ + conjf (ap_[k_ - 1]) * x_[i_ - 1];
              k_ = k_ + 1;
            }
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * ap_[kk_ - 1];
            }
            for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
              ix_ = ix_ + (*incx_);
              temp_ = temp_ + ap_[k_ - 1] * x_[ix_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (ap_[kk_ - 1]);
            }
            for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
              ix_ = ix_ + (*incx_);
              temp_ = temp_ + conjf (ap_[k_ - 1]) * x_[ix_ - 1];
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
    }
  }
  _l0:;
  __calls[29].calls++;
  return 0;
}

int_4 _ctpsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_8 _p_ ap_, complex_8 _p_ x_, int_4 
_p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static logical_4 noconj_, nounit_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_27, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[j_ - 1];
            k_ = kk_ - 1;
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * ap_[k_ - 1];
              k_ = k_ - 1;
            }
          }
          kk_ = kk_ - j_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
              ix_ = ix_ - (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * ap_[k_ - 1];
            }
          }
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - j_;
        }
      }
    }
    else {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[j_ - 1];
            k_ = kk_ + 1;
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * ap_[k_ - 1];
              k_ = k_ + 1;
            }
          }
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
              ix_ = ix_ + (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * ap_[k_ - 1];
            }
          }
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          k_ = kk_;
          if (noconj_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - ap_[k_ - 1] * x_[i_ - 1];
              k_ = k_ + 1;
            }
            if (nounit_) {
              temp_ = temp_ / ap_[kk_ + j_ - 1 - 1];
            }
          }
          else {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - conjf (ap_[k_ - 1]) * x_[i_ - 1];
              k_ = k_ + 1;
            }
            if (nounit_) {
              temp_ = temp_ / conjf (ap_[kk_ + j_ - 1 - 1]);
            }
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ + j_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          if (noconj_) {
            for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
              temp_ = temp_ - ap_[k_ - 1] * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / ap_[kk_ + j_ - 1 - 1];
            }
          }
          else {
            for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
              temp_ = temp_ - conjf (ap_[k_ - 1]) * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / conjf (ap_[kk_ + j_ - 1 - 1]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + j_;
        }
      }
    }
    else {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          k_ = kk_;
          if (noconj_) {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - ap_[k_ - 1] * x_[i_ - 1];
              k_ = k_ - 1;
            }
            if (nounit_) {
              temp_ = temp_ / ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          else {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - conjf (ap_[k_ - 1]) * x_[i_ - 1];
              k_ = k_ - 1;
            }
            if (nounit_) {
              temp_ = temp_ / conjf (ap_[kk_ - (*n_) + j_ - 1]);
            }
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          if (noconj_) {
            for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
              temp_ = temp_ - ap_[k_ - 1] * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          else {
            for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
              temp_ = temp_ - conjf (ap_[k_ - 1]) * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / conjf (ap_[kk_ - (*n_) + j_ - 1]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
    }
  }
  _l0:;
  __calls[30].calls++;
  return 0;
}

int_4 _ctrmm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, complex_8 
_p_ alpha_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 lside_, noconj_, nounit_, upper_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  lside_ = _lsame (side_, _dc_9);
  if (lside_) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  noconj_ = _lsame (transa_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (lside_)) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((! (_lsame (transa_, _dc_0))) && (! (_lsame (transa_, _dc_1))) && (! (_lsame (transa_, _dc_2)))) {
    info_ = 3;
  }
  else if ((! (_lsame (diag_, _dc_8))) && (! (_lsame (diag_, _dc_0)))) {
    info_ = 4;
  }
  else if ((*m_) < 0) {
    info_ = 5;
  }
  else if ((*n_) < 0) {
    info_ = 6;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_28, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
      }
    }
    goto _l0;
  }
  if (lside_) {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (k_ = 1; k_ <= (*m_); (k_)++) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
              temp_ = (*alpha_) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= k_ - 1; (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))]
                ;
              }
              if (nounit_) {
                temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (k_ = (*m_); k_ >= 1; (k_)--) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
              temp_ = (*alpha_) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = k_ + 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = (*m_); i_ >= 1; (i_)--) {
            temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (noconj_) {
              if (nounit_) {
                temp_ = temp_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
              }
              for (k_ = 1; k_ <= i_ - 1; (k_)++) {
                temp_ = temp_ + a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
            }
            else {
              if (nounit_) {
                temp_ = temp_ * conjf (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]);
              }
              for (k_ = 1; k_ <= i_ - 1; (k_)++) {
                temp_ = temp_ + conjf (a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (noconj_) {
              if (nounit_) {
                temp_ = temp_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
              }
              for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
                temp_ = temp_ + a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
            }
            else {
              if (nounit_) {
                temp_ = temp_ * conjf (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]);
              }
              for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
                temp_ = temp_ + conjf (a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
        }
      }
    }
  }
  else {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          for (k_ = 1; k_ <= j_ - 1; (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
              temp_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
              temp_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (k_ = 1; k_ <= (*n_); (k_)++) {
          for (j_ = 1; j_ <= k_ - 1; (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != CMPLXF (0.0, 0.0)) {
              if (noconj_) {
                temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              else {
                temp_ = (*alpha_) * conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
              }
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          temp_ = (*alpha_);
          if (nounit_) {
            if (noconj_) {
              temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            }
            else {
              temp_ = temp_ * conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
            }
          }
          if (temp_ != CMPLXF (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
      else {
        for (k_ = (*n_); k_ >= 1; (k_)--) {
          for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != CMPLXF (0.0, 0.0)) {
              if (noconj_) {
                temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              else {
                temp_ = (*alpha_) * conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
              }
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          temp_ = (*alpha_);
          if (nounit_) {
            if (noconj_) {
              temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            }
            else {
              temp_ = temp_ * conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
            }
          }
          if (temp_ != CMPLXF (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[31].calls++;
  return 0;
}

int_4 _ctrmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, 
complex_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static logical_4 noconj_, nounit_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_29, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              temp_ = temp_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              ix_ = ix_ - (*incx_);
              temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              ix_ = ix_ - (*incx_);
              temp_ = temp_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              temp_ = temp_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              ix_ = ix_ + (*incx_);
              temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              ix_ = ix_ + (*incx_);
              temp_ = temp_ + conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[32].calls++;
  return 0;
}

int_4 _ctrsm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, complex_8 
_p_ alpha_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 lside_, noconj_, nounit_, upper_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  lside_ = _lsame (side_, _dc_9);
  if (lside_) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  noconj_ = _lsame (transa_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (lside_)) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((! (_lsame (transa_, _dc_0))) && (! (_lsame (transa_, _dc_1))) && (! (_lsame (transa_, _dc_2)))) {
    info_ = 3;
  }
  else if ((! (_lsame (diag_, _dc_8))) && (! (_lsame (diag_, _dc_0)))) {
    info_ = 4;
  }
  else if ((*m_) < 0) {
    info_ = 5;
  }
  else if ((*n_) < 0) {
    info_ = 6;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_30, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*alpha_) == CMPLXF (0.0, 0.0)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
      }
    }
    goto _l0;
  }
  if (lside_) {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != CMPLXF (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = (*m_); k_ >= 1; (k_)--) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = 1; i_ <= k_ - 1; (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[i_ 
                - 1 + ((*lda_)) * ((k_ - 1))];
              }
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != CMPLXF (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = 1; k_ <= (*m_); (k_)++) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = k_ + 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[i_ 
                - 1 + ((*lda_)) * ((k_ - 1))];
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (noconj_) {
              for (k_ = 1; k_ <= i_ - 1; (k_)++) {
                temp_ = temp_ - a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
              if (nounit_) {
                temp_ = temp_ / a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
              }
            }
            else {
              for (k_ = 1; k_ <= i_ - 1; (k_)++) {
                temp_ = temp_ - conjf (a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
              if (nounit_) {
                temp_ = temp_ / conjf (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]);
              }
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = (*m_); i_ >= 1; (i_)--) {
            temp_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (noconj_) {
              for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
                temp_ = temp_ - a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
              if (nounit_) {
                temp_ = temp_ / a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
              }
            }
            else {
              for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
                temp_ = temp_ - conjf (a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
              if (nounit_) {
                temp_ = temp_ / conjf (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]);
              }
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
          }
        }
      }
    }
  }
  else {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != CMPLXF (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = 1; k_ <= j_ - 1; (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] * b_[i_ 
                - 1 + ((*ldb_)) * ((k_ - 1))];
              }
            }
          }
          if (nounit_) {
            temp_ = CMPLXF (1.0, 0.0) / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if ((*alpha_) != CMPLXF (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] * b_[i_ 
                - 1 + ((*ldb_)) * ((k_ - 1))];
              }
            }
          }
          if (nounit_) {
            temp_ = CMPLXF (1.0, 0.0) / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (k_ = (*n_); k_ >= 1; (k_)--) {
          if (nounit_) {
            if (noconj_) {
              temp_ = CMPLXF (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            }
            else {
              temp_ = CMPLXF (1.0, 0.0) / conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
            }
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
          for (j_ = 1; j_ <= k_ - 1; (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != CMPLXF (0.0, 0.0)) {
              if (noconj_) {
                temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              else {
                temp_ = conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
              }
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          if ((*alpha_) != CMPLXF (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
      else {
        for (k_ = 1; k_ <= (*n_); (k_)++) {
          if (nounit_) {
            if (noconj_) {
              temp_ = CMPLXF (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            }
            else {
              temp_ = CMPLXF (1.0, 0.0) / conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
            }
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
          for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != CMPLXF (0.0, 0.0)) {
              if (noconj_) {
                temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              else {
                temp_ = conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
              }
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          if ((*alpha_) != CMPLXF (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[33].calls++;
  return 0;
}

int_4 _ctrsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, 
complex_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static logical_4 noconj_, nounit_;
  static complex_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_31, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              ix_ = ix_ - (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLXF (0.0, 0.0)) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLXF (0.0, 0.0)) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              ix_ = ix_ + (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          if (noconj_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          ix_ = kx_;
          temp_ = x_[jx_ - 1];
          if (noconj_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          if (noconj_) {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          ix_ = kx_;
          temp_ = x_[jx_ - 1];
          if (noconj_) {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[34].calls++;
  return 0;
}

real_8 _dasum (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_)
{
  static int_4 i_, m_, mp1_, nincx_;
  static real_8 dtemp_;
  real_8 dasum_;
  extern real_8 _dabs ();
  real_8 __dabs (real_8 _p_ __x__) {return _abs (*__x__);}
  dasum_ = 0.0;
  dtemp_ = 0.0;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    dtemp_ = dtemp_ + __dabs (&dx_[i_ - 1]);
  }
  dasum_ = dtemp_;
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 6);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    dtemp_ = dtemp_ + __dabs (&dx_[i_ - 1]);
  }
  if ((*n_) < 6) {
    goto _l60;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (6 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 6) {
    dtemp_ = dtemp_ + __dabs (&dx_[i_ - 1]) + __dabs (&dx_[i_ + 1 - 1]) + __dabs (&dx_[i_ + 2 - 1]) + __dabs (&dx_[i_ + 3 - 
    1]) + __dabs (&dx_[i_ + 4 - 1]) + __dabs (&dx_[i_ + 5 - 1]);
  }
  _l60:;
  dasum_ = dtemp_;
  _l0:;
  __calls[35].calls++;
  return dasum_;
}

int_4 _daxpy (int_4 _p_ n_, real_8 _p_ da_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_, m_, mp1_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*da_) == 0.0e0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    dy_[iy_ - 1] = dy_[iy_ - 1] + (*da_) * dx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 4);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    dy_[i_ - 1] = dy_[i_ - 1] + (*da_) * dx_[i_ - 1];
  }
  if ((*n_) < 4) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (4 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 4) {
    dy_[i_ - 1] = dy_[i_ - 1] + (*da_) * dx_[i_ - 1];
    dy_[i_ + 1 - 1] = dy_[i_ + 1 - 1] + (*da_) * dx_[i_ + 1 - 1];
    dy_[i_ + 2 - 1] = dy_[i_ + 2 - 1] + (*da_) * dx_[i_ + 2 - 1];
    dy_[i_ + 3 - 1] = dy_[i_ + 3 - 1] + (*da_) * dx_[i_ + 3 - 1];
  }
  _l0:;
  __calls[36].calls++;
  return 0;
}
real_8 _dcabs1 (complex_16 _p_ z_)
{
  real_8 dcabs1_;
  dcabs1_ = _abs ((real_8) (creal ((*z_)))) + _abs (cimag ((*z_)));
  __calls[37].calls++;
  return dcabs1_;
}

int_4 _dcopy (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_, m_, mp1_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    dy_[iy_ - 1] = dx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 7);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    dy_[i_ - 1] = dx_[i_ - 1];
  }
  if ((*n_) < 7) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (7 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 7) {
    dy_[i_ - 1] = dx_[i_ - 1];
    dy_[i_ + 1 - 1] = dx_[i_ + 1 - 1];
    dy_[i_ + 2 - 1] = dx_[i_ + 2 - 1];
    dy_[i_ + 3 - 1] = dx_[i_ + 3 - 1];
    dy_[i_ + 4 - 1] = dx_[i_ + 4 - 1];
    dy_[i_ + 5 - 1] = dx_[i_ + 5 - 1];
    dy_[i_ + 6 - 1] = dx_[i_ + 6 - 1];
  }
  _l0:;
  __calls[38].calls++;
  return 0;
}
real_8 _ddot (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_, m_, mp1_;
  static real_8 dtemp_;
  real_8 ddot_;
  ddot_ = 0.0;
  dtemp_ = 0.0;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    dtemp_ = dtemp_ + dx_[ix_ - 1] * dy_[iy_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  ddot_ = dtemp_;
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 5);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    dtemp_ = dtemp_ + dx_[i_ - 1] * dy_[i_ - 1];
  }
  if ((*n_) < 5) {
    goto _l60;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (5 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 5) {
    dtemp_ = dtemp_ + dx_[i_ - 1] * dy_[i_ - 1] + dx_[i_ + 1 - 1] * dy_[i_ + 1 - 1] + dx_[i_ + 2 - 1] * dy_[i_ + 2 - 1] + 
    dx_[i_ + 3 - 1] * dy_[i_ + 3 - 1] + dx_[i_ + 4 - 1] * dy_[i_ + 4 - 1];
  }
  _l60:;
  ddot_ = dtemp_;
  _l0:;
  __calls[39].calls++;
  return ddot_;
}

int_4 _dgbmv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ alpha_, real_8 _p_ 
a_, int_4 _p_ lda_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kup1_, kx_, ky_, lenx_, leny_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 1;
  }
  else if ((*m_) < 0) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*kl_) < 0) {
    info_ = 4;
  }
  else if ((*ku_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*kl_) + (*ku_) + 1)) {
    info_ = 8;
  }
  else if ((*incx_) == 0) {
    info_ = 10;
  }
  else if ((*incy_) == 0) {
    info_ = 13;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_32, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    lenx_ = (*n_);
    leny_ = (*m_);
  }
  else {
    lenx_ = (*m_);
    leny_ = (*n_);
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - (lenx_ - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - (leny_ - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  kup1_ = (*ku_) + 1;
  if (_lsame (trans_, _dc_0)) {
    jx_ = kx_;
    if ((*incy_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          k_ = kup1_ - j_;
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            y_[i_ - 1] = y_[i_ - 1] + temp_ * a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          iy_ = ky_;
          k_ = kup1_ - j_;
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            y_[iy_ - 1] = y_[iy_ - 1] + temp_ * a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        if (j_ > (*ku_)) {
          ky_ = ky_ + (*incy_);
        }
      }
    }
  }
  else {
    jy_ = ky_;
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = 0.0;
        k_ = kup1_ - j_;
        for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
          temp_ = temp_ + a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = 0.0;
        ix_ = kx_;
        k_ = kup1_ - j_;
        for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
          temp_ = temp_ + a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
        if (j_ > (*ku_)) {
          kx_ = kx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[40].calls++;
  return 0;
}

int_4 _dgemm (char _p_ transa_, char _p_ transb_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, real_8 
_p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ beta_, real_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, ncola_, nrowa_, nrowb_;
  static logical_4 nota_, notb_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  nota_ = _lsame (transa_, _dc_0);
  notb_ = _lsame (transb_, _dc_0);
  if (nota_) {
    nrowa_ = (*m_);
    ncola_ = (*k_);
  }
  else {
    nrowa_ = (*k_);
    ncola_ = (*m_);
  }
  if (notb_) {
    nrowb_ = (*k_);
  }
  else {
    nrowb_ = (*n_);
  }
  info_ = 0;
  if ((! (nota_)) && (! (_lsame (transa_, _dc_2))) && (! (_lsame (transa_, _dc_1)))) {
    info_ = 1;
  }
  else if ((! (notb_)) && (! (_lsame (transb_, _dc_2))) && (! (_lsame (transb_, _dc_1)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 8;
  }
  else if ((*ldb_) < _max (1, nrowb_)) {
    info_ = 10;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 13;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_33, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((((*alpha_) == 0.0) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if ((*beta_) == 0.0) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (notb_) {
    if (nota_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
            temp_ = (*alpha_) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  else {
    if (nota_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0) {
            temp_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[41].calls++;
  return 0;
}

int_4 _dgemv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ 
x_, int_4 _p_ incx_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_, lenx_, leny_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 1;
  }
  else if ((*m_) < 0) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  else if ((*incy_) == 0) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_34, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    lenx_ = (*n_);
    leny_ = (*m_);
  }
  else {
    lenx_ = (*m_);
    leny_ = (*n_);
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - (lenx_ - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - (leny_ - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    jx_ = kx_;
    if ((*incy_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            y_[i_ - 1] = y_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          iy_ = ky_;
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            y_[iy_ - 1] = y_[iy_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  else {
    jy_ = ky_;
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = 0.0;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = 0.0;
        ix_ = kx_;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[42].calls++;
  return 0;
}

int_4 _dger (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ y_, int_4 _p_ 
incy_, real_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, j_, jy_, kx_;
  static real_8 temp_;
  extern int_4 _xerbla ();
  info_ = 0;
  if ((*m_) < 0) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_35, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if ((*incy_) > 0) {
    jy_ = 1;
  }
  else {
    jy_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*incx_) == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != 0.0) {
        temp_ = (*alpha_) * y_[jy_ - 1];
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  else {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*m_) - 1) * (*incx_);
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != 0.0) {
        temp_ = (*alpha_) * y_[jy_ - 1];
        ix_ = kx_;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
          ix_ = ix_ + (*incx_);
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  _l0:;
  __calls[43].calls++;
  return 0;
}

real_8 _dnrm2 (int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 ix_;
  static real_8 absxi_, norm_, scale_, ssq_;
  real_8 $0_, $1_;
  real_8 dnrm2_;
  if ((*n_) < 1 || (*incx_) < 1) {
    norm_ = 0.0;
  }
  else if ((*n_) == 1) {
    norm_ = _abs (x_[0]);
  }
  else {
    scale_ = 0.0;
    ssq_ = 1.0;
    for (ix_ = 1; ((*incx_) > 0 ? ix_ <= 1 + ((*n_) - 1) * (*incx_) : ix_ >= 1 + ((*n_) - 1) * (*incx_)); ix_ += (*incx_)) 
      {
      if (x_[ix_ - 1] != 0.0) {
        absxi_ = _abs (x_[ix_ - 1]);
        if (scale_ < absxi_) {
          ssq_ = 1.0 + ssq_ * ($0_ = (scale_ / absxi_), $0_ * $0_);
          scale_ = absxi_;
        }
        else {
          ssq_ = ssq_ + ($1_ = (absxi_ / scale_), $1_ * $1_);
        }
      }
    }
    norm_ = scale_ * sqrt (ssq_);
  }
  dnrm2_ = norm_;
  __calls[44].calls++;
  return dnrm2_;
}

int_4 _drot (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_, real_8 _p_ c_, real_8 _p_ 
s_)
{
  static int_4 i_, ix_, iy_;
  static real_8 dtemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    dtemp_ = (*c_) * dx_[ix_ - 1] + (*s_) * dy_[iy_ - 1];
    dy_[iy_ - 1] = (*c_) * dy_[iy_ - 1] - (*s_) * dx_[ix_ - 1];
    dx_[ix_ - 1] = dtemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    dtemp_ = (*c_) * dx_[i_ - 1] + (*s_) * dy_[i_ - 1];
    dy_[i_ - 1] = (*c_) * dy_[i_ - 1] - (*s_) * dx_[i_ - 1];
    dx_[i_ - 1] = dtemp_;
  }
  _l0:;
  __calls[45].calls++;
  return 0;
}

int_4 _drotg (real_8 _p_ da_, real_8 _p_ db_, real_8 _p_ c_, real_8 _p_ s_)
{
  static real_8 r_, roe_, scale_, z_;
  real_8 $0_, $1_, $2_, $3_;
  extern real_8 _dabs ();
  extern real_8 _dsign ();
  extern real_8 _dsqrt ();
  real_8 __dabs (real_8 _p_ __x__) {return _abs (*__x__);}
  real_8 __dsign (real_8 _p_ __x__, real_8 _p_ __y__) {return _sign (*__x__, *__y__);}
  real_8 __dsqrt (real_8 _p_ __x__) {return sqrt (*__x__);}
  roe_ = (*db_);
  if (__dabs (da_) > __dabs (db_)) {
    roe_ = (*da_);
  }
  scale_ = __dabs (da_) + __dabs (db_);
  if (scale_ != 0.0e0) {
    goto _l10;
  }
  (*c_) = 1.0;
  (*s_) = 0.0;
  r_ = 0.0;
  z_ = 0.0;
  goto _l20;
  _l10:;
  r_ = scale_ * __dsqrt (($2_ = ($0_ = ((*da_) / scale_), $0_ * $0_) + ($1_ = ((*db_) / scale_), $1_ * $1_), &$2_));
  r_ = __dsign (($3_ = 1.0, &$3_), &roe_) * r_;
  (*c_) = (*da_) / r_;
  (*s_) = (*db_) / r_;
  z_ = 1.0;
  if (__dabs (da_) > __dabs (db_)) {
    z_ = (*s_);
  }
  if (__dabs (db_) >= __dabs (da_) && (*c_) != 0.0e0) {
    z_ = 1.0e0 / (*c_);
  }
  _l20:;
  (*da_) = r_;
  (*db_) = z_;
  __calls[46].calls++;
  return 0;
}

int_4 _drotm (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_, real_8 _p_ dparam_)
{
  static int_4 i_, kx_, ky_, nsteps_;
  static real_8 dflag_, dh11_, dh12_, dh21_, dh22_, two_, w_, z_, zero_;
  int_4 _data_k_0;
  real_8 $0_, $1_;
#define _data_n_0 2
  static real_8 _data_l_0[_data_n_0] = {
    0.0e0,
    2.0e0
  };
  if (__calls[47].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    zero_ = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_ = _data_l_0[_data_k_0++];
  }
  dflag_ = dparam_[0];
  if ((*n_) <= 0 || (dflag_ + two_ == zero_)) {
    goto _l140;
  }
  if (! (((*incx_) == (*incy_) && (*incx_) > 0))) {
    goto _l70;
  }
  nsteps_ = (*n_) * (*incx_);
  $0_ = dflag_;
  if ($0_ < 0) {
    goto _l50;
  } else if ($0_ == 0) {
    goto _l10;
  } else {
    goto _l30;
  }
  _l10:;
  dh12_ = dparam_[3];
  dh21_ = dparam_[2];
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nsteps_ : i_ >= nsteps_); i_ += (*incx_)) {
    w_ = dx_[i_ - 1];
    z_ = dy_[i_ - 1];
    dx_[i_ - 1] = w_ + z_ * dh12_;
    dy_[i_ - 1] = w_ * dh21_ + z_;
  }
  goto _l140;
  _l30:;
  dh11_ = dparam_[1];
  dh22_ = dparam_[4];
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nsteps_ : i_ >= nsteps_); i_ += (*incx_)) {
    w_ = dx_[i_ - 1];
    z_ = dy_[i_ - 1];
    dx_[i_ - 1] = w_ * dh11_ + z_;
    dy_[i_ - 1] = -w_ + dh22_ * z_;
  }
  goto _l140;
  _l50:;
  dh11_ = dparam_[1];
  dh12_ = dparam_[3];
  dh21_ = dparam_[2];
  dh22_ = dparam_[4];
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nsteps_ : i_ >= nsteps_); i_ += (*incx_)) {
    w_ = dx_[i_ - 1];
    z_ = dy_[i_ - 1];
    dx_[i_ - 1] = w_ * dh11_ + z_ * dh12_;
    dy_[i_ - 1] = w_ * dh21_ + z_ * dh22_;
  }
  goto _l140;
  _l70:;
  kx_ = 1;
  ky_ = 1;
  if ((*incx_) < 0) {
    kx_ = 1 + (1 - (*n_)) * (*incx_);
  }
  if ((*incy_) < 0) {
    ky_ = 1 + (1 - (*n_)) * (*incy_);
  }
  $1_ = dflag_;
  if ($1_ < 0) {
    goto _l120;
  } else if ($1_ == 0) {
    goto _l80;
  } else {
    goto _l100;
  }
  _l80:;
  dh12_ = dparam_[3];
  dh21_ = dparam_[2];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_ = dx_[kx_ - 1];
    z_ = dy_[ky_ - 1];
    dx_[kx_ - 1] = w_ + z_ * dh12_;
    dy_[ky_ - 1] = w_ * dh21_ + z_;
    kx_ = kx_ + (*incx_);
    ky_ = ky_ + (*incy_);
  }
  goto _l140;
  _l100:;
  dh11_ = dparam_[1];
  dh22_ = dparam_[4];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_ = dx_[kx_ - 1];
    z_ = dy_[ky_ - 1];
    dx_[kx_ - 1] = w_ * dh11_ + z_;
    dy_[ky_ - 1] = -w_ + dh22_ * z_;
    kx_ = kx_ + (*incx_);
    ky_ = ky_ + (*incy_);
  }
  goto _l140;
  _l120:;
  dh11_ = dparam_[1];
  dh12_ = dparam_[3];
  dh21_ = dparam_[2];
  dh22_ = dparam_[4];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_ = dx_[kx_ - 1];
    z_ = dy_[ky_ - 1];
    dx_[kx_ - 1] = w_ * dh11_ + z_ * dh12_;
    dy_[ky_ - 1] = w_ * dh21_ + z_ * dh22_;
    kx_ = kx_ + (*incx_);
    ky_ = ky_ + (*incy_);
  }
  _l140:;
  __calls[47].calls++;
  return 0;
}

int_4 _drotmg (real_8 _p_ dd1_, real_8 _p_ dd2_, real_8 _p_ dx1_, real_8 _p_ dy1_, real_8 _p_ dparam_)
{
  static int_4 igo_;
  static real_8 dflag_, dh11_, dh12_, dh21_, dh22_, dp1_, dp2_, dq1_, dq2_, dtemp_, du_, gam_, gamsq_, one_, rgamsq_, 
  two_, zero_;
  int_4 _data_k_1, _data_k_2;
  real_8 $0_;
  extern real_8 _dabs ();
#define _data_n_1 3
  static real_8 _data_l_1[_data_n_1] = {
    0.0e0,
    1.0e0,
    2.0e0
  };
#define _data_n_2 3
  static real_8 _data_l_2[_data_n_2] = {
    4096.0e0,
    16777216.0e0,
    5.9604645e-8
  };
  real_8 __dabs (real_8 _p_ __x__) {return _abs (*__x__);}
  if (__calls[48].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    zero_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    one_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    two_ = _data_l_1[_data_k_1++];
  }
  if (__calls[48].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    gam_ = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    gamsq_ = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    rgamsq_ = _data_l_2[_data_k_2++];
  }
  if (! ((*dd1_) < zero_)) {
    goto _l10;
  }
  goto _l60;
  _l10:;
  dp2_ = (*dd2_) * (*dy1_);
  if (! (dp2_ == zero_)) {
    goto _l20;
  }
  dflag_ = -two_;
  goto _l260;
  _l20:;
  dp1_ = (*dd1_) * (*dx1_);
  dq2_ = dp2_ * (*dy1_);
  dq1_ = dp1_ * (*dx1_);
  if (! (__dabs (&dq1_) > __dabs (&dq2_))) {
    goto _l40;
  }
  dh21_ = -(*dy1_) / (*dx1_);
  dh12_ = dp2_ / dp1_;
  du_ = one_ - dh12_ * dh21_;
  if (! (du_ <= zero_)) {
    goto _l30;
  }
  goto _l60;
  _l30:;
  dflag_ = zero_;
  (*dd1_) = (*dd1_) / du_;
  (*dd2_) = (*dd2_) / du_;
  (*dx1_) = (*dx1_) * du_;
  goto _l100;
  _l40:;
  if (! (dq2_ < zero_)) {
    goto _l50;
  }
  goto _l60;
  _l50:;
  dflag_ = one_;
  dh11_ = dp1_ / dp2_;
  dh22_ = (*dx1_) / (*dy1_);
  du_ = one_ + dh11_ * dh22_;
  dtemp_ = (*dd2_) / du_;
  (*dd2_) = (*dd1_) / du_;
  (*dd1_) = dtemp_;
  (*dx1_) = (*dy1_) * du_;
  goto _l100;
  _l60:;
  dflag_ = -one_;
  dh11_ = zero_;
  dh12_ = zero_;
  dh21_ = zero_;
  dh22_ = zero_;
  (*dd1_) = zero_;
  (*dd2_) = zero_;
  (*dx1_) = zero_;
  goto _l220;
  _l70:;
  if (! (dflag_ >= zero_)) {
    goto _l90;
  }
  if (! (dflag_ == zero_)) {
    goto _l80;
  }
  dh11_ = one_;
  dh22_ = one_;
  dflag_ = -one_;
  goto _l90;
  _l80:;
  dh21_ = -one_;
  dh12_ = one_;
  dflag_ = -one_;
  _l90:;
  switch (igo_) {
    default:
    case 12: goto _l120;
    case 15: goto _l150;
    case 18: goto _l180;
    case 21: goto _l210;
  }
  _l100:;
  _l110:;
  if (! ((*dd1_) <= rgamsq_)) {
    goto _l130;
  }
  if ((*dd1_) == zero_) {
    goto _l160;
  }
  igo_ = 12;
  goto _l70;
  _l120:;
  (*dd1_) = (*dd1_) * (gam_ * gam_);
  (*dx1_) = (*dx1_) / gam_;
  dh11_ = dh11_ / gam_;
  dh12_ = dh12_ / gam_;
  goto _l110;
  _l130:;
  _l140:;
  if (! ((*dd1_) >= gamsq_)) {
    goto _l160;
  }
  igo_ = 15;
  goto _l70;
  _l150:;
  (*dd1_) = (*dd1_) / (gam_ * gam_);
  (*dx1_) = (*dx1_) * gam_;
  dh11_ = dh11_ * gam_;
  dh12_ = dh12_ * gam_;
  goto _l140;
  _l160:;
  _l170:;
  if (! (__dabs (dd2_) <= rgamsq_)) {
    goto _l190;
  }
  if ((*dd2_) == zero_) {
    goto _l220;
  }
  igo_ = 18;
  goto _l70;
  _l180:;
  (*dd2_) = (*dd2_) * (gam_ * gam_);
  dh21_ = dh21_ / gam_;
  dh22_ = dh22_ / gam_;
  goto _l170;
  _l190:;
  _l200:;
  if (! (__dabs (dd2_) >= gamsq_)) {
    goto _l220;
  }
  igo_ = 21;
  goto _l70;
  _l210:;
  (*dd2_) = (*dd2_) / (gam_ * gam_);
  dh21_ = dh21_ * gam_;
  dh22_ = dh22_ * gam_;
  goto _l200;
  _l220:;
  $0_ = dflag_;
  if ($0_ < 0) {
    goto _l250;
  } else if ($0_ == 0) {
    goto _l230;
  } else {
    goto _l240;
  }
  _l230:;
  dparam_[2] = dh21_;
  dparam_[3] = dh12_;
  goto _l260;
  _l240:;
  dparam_[1] = dh11_;
  dparam_[4] = dh22_;
  goto _l260;
  _l250:;
  dparam_[1] = dh11_;
  dparam_[2] = dh21_;
  dparam_[3] = dh12_;
  dparam_[4] = dh22_;
  _l260:;
  dparam_[0] = dflag_;
  __calls[48].calls++;
  return 0;
}

int_4 _dsbmv (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ 
x_, int_4 _p_ incx_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kplus1_, kx_, ky_, l_;
  static real_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*k_) < 0) {
    info_ = 3;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  else if ((*incy_) == 0) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_36, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  if (_lsame (uplo_, _dc_8)) {
    kplus1_ = (*k_) + 1;
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        l_ = kplus1_ - j_;
        for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        ix_ = kx_;
        iy_ = ky_;
        l_ = kplus1_ - j_;
        for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        if (j_ > (*k_)) {
          kx_ = kx_ + (*incx_);
          ky_ = ky_ + (*incy_);
        }
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * a_[0 + ((*lda_)) * ((j_ - 1))];
        l_ = 1 - j_;
        for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * a_[0 + ((*lda_)) * ((j_ - 1))];
        l_ = 1 - j_;
        ix_ = jx_;
        iy_ = jy_;
        for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[49].calls++;
  return 0;
}

int_4 _dscal (int_4 _p_ n_, real_8 _p_ da_, real_8 _p_ dx_, int_4 _p_ incx_)
{
  static int_4 i_, m_, mp1_, nincx_;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    dx_[i_ - 1] = (*da_) * dx_[i_ - 1];
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 5);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    dx_[i_ - 1] = (*da_) * dx_[i_ - 1];
  }
  if ((*n_) < 5) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (5 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 5) {
    dx_[i_ - 1] = (*da_) * dx_[i_ - 1];
    dx_[i_ + 1 - 1] = (*da_) * dx_[i_ + 1 - 1];
    dx_[i_ + 2 - 1] = (*da_) * dx_[i_ + 2 - 1];
    dx_[i_ + 3 - 1] = (*da_) * dx_[i_ + 3 - 1];
    dx_[i_ + 4 - 1] = (*da_) * dx_[i_ + 4 - 1];
  }
  _l0:;
  __calls[50].calls++;
  return 0;
}

real_8 _dsdot (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_)
{
  static int_4 i_, kx_, ky_, ns_;
  real_8 dsdot_;
  dsdot_ = 0.0;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == (*incy_) && (*incx_) > 0) {
    goto _l20;
  }
  kx_ = 1;
  ky_ = 1;
  if ((*incx_) < 0) {
    kx_ = 1 + (1 - (*n_)) * (*incx_);
  }
  if ((*incy_) < 0) {
    ky_ = 1 + (1 - (*n_)) * (*incy_);
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    dsdot_ = dsdot_ + (real_8) (sx_[kx_ - 1]) * (real_8) (sy_[ky_ - 1]);
    kx_ = kx_ + (*incx_);
    ky_ = ky_ + (*incy_);
  }
  goto _l0;
  _l20:;
  ns_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= ns_ : i_ >= ns_); i_ += (*incx_)) {
    dsdot_ = dsdot_ + (real_8) (sx_[i_ - 1]) * (real_8) (sy_[i_ - 1]);
  }
  _l0:;
  __calls[51].calls++;
  return dsdot_;
}

int_4 _dspmv (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ ap_, real_8 _p_ x_, int_4 _p_ incx_, real_8 
_p_ beta_, real_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kk_, kx_, ky_;
  static real_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 6;
  }
  else if ((*incy_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_37, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        k_ = kk_;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + ap_[k_ - 1] * x_[i_ - 1];
          k_ = k_ + 1;
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * ap_[kk_ + j_ - 1 - 1] + (*alpha_) * temp2_;
        kk_ = kk_ + j_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        ix_ = kx_;
        iy_ = ky_;
        for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + ap_[k_ - 1] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * ap_[kk_ + j_ - 1 - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * ap_[kk_ - 1];
        k_ = kk_ + 1;
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + ap_[k_ - 1] * x_[i_ - 1];
          k_ = k_ + 1;
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
        kk_ = kk_ + ((*n_) - j_ + 1);
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * ap_[kk_ - 1];
        ix_ = jx_;
        iy_ = jy_;
        for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + ap_[k_ - 1] * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + ((*n_) - j_ + 1);
      }
    }
  }
  _l0:;
  __calls[52].calls++;
  return 0;
}
int_4 _dspr2 (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ y_, int_4 _p_ 
incy_, real_8 _p_ ap_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kk_, kx_, ky_;
  static real_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_38, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if (((*incx_) != 1) || ((*incy_) != 1)) {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*n_) - 1) * (*incx_);
    }
    if ((*incy_) > 0) {
      ky_ = 1;
    }
    else {
      ky_ = 1 - ((*n_) - 1) * (*incy_);
    }
    jx_ = kx_;
    jy_ = ky_;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != 0.0) || (y_[j_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[j_ - 1];
          temp2_ = (*alpha_) * x_[j_ - 1];
          k_ = kk_;
          for (i_ = 1; i_ <= j_; (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
            k_ = k_ + 1;
          }
        }
        kk_ = kk_ + j_;
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != 0.0) || (y_[jy_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[jy_ - 1];
          temp2_ = (*alpha_) * x_[jx_ - 1];
          ix_ = kx_;
          iy_ = ky_;
          for (k_ = kk_; k_ <= kk_ + j_ - 1; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != 0.0) || (y_[j_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[j_ - 1];
          temp2_ = (*alpha_) * x_[j_ - 1];
          k_ = kk_;
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
            k_ = k_ + 1;
          }
        }
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != 0.0) || (y_[jy_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[jy_ - 1];
          temp2_ = (*alpha_) * x_[jx_ - 1];
          ix_ = jx_;
          iy_ = jy_;
          for (k_ = kk_; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
  }
  _l0:;
  __calls[53].calls++;
  return 0;
}

int_4 _dspr (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ ap_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_39, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[j_ - 1];
          k_ = kk_;
          for (i_ = 1; i_ <= j_; (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp_;
            k_ = k_ + 1;
          }
        }
        kk_ = kk_ + j_;
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          ix_ = kx_;
          for (k_ = kk_; k_ <= kk_ + j_ - 1; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
        }
        jx_ = jx_ + (*incx_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[j_ - 1];
          k_ = kk_;
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp_;
            k_ = k_ + 1;
          }
        }
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          ix_ = jx_;
          for (k_ = kk_; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
        }
        jx_ = jx_ + (*incx_);
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
  }
  _l0:;
  __calls[54].calls++;
  return 0;
}

int_4 _dswap (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_, m_, mp1_;
  static real_8 dtemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    dtemp_ = dx_[ix_ - 1];
    dx_[ix_ - 1] = dy_[iy_ - 1];
    dy_[iy_ - 1] = dtemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 3);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    dtemp_ = dx_[i_ - 1];
    dx_[i_ - 1] = dy_[i_ - 1];
    dy_[i_ - 1] = dtemp_;
  }
  if ((*n_) < 3) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (3 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 3) {
    dtemp_ = dx_[i_ - 1];
    dx_[i_ - 1] = dy_[i_ - 1];
    dy_[i_ - 1] = dtemp_;
    dtemp_ = dx_[i_ + 1 - 1];
    dx_[i_ + 1 - 1] = dy_[i_ + 1 - 1];
    dy_[i_ + 1 - 1] = dtemp_;
    dtemp_ = dx_[i_ + 2 - 1];
    dx_[i_ + 2 - 1] = dy_[i_ + 2 - 1];
    dy_[i_ + 2 - 1] = dtemp_;
  }
  _l0:;
  __calls[55].calls++;
  return 0;
}

int_4 _dsymm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ 
lda_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ beta_, real_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 upper_;
  static real_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (side_, _dc_9)) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (_lsame (side_, _dc_9))) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_40, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if ((*beta_) == 0.0) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (_lsame (side_, _dc_9)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = 0.0;
          for (k_ = 1; k_ <= i_ - 1; (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((i_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[i_ - 1 + ((*lda_)) * 
            ((i_ - 1))] + (*alpha_) * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = (*m_); i_ >= 1; (i_)--) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = 0.0;
          for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((i_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[i_ - 1 + ((*lda_)) * 
            ((i_ - 1))] + (*alpha_) * temp2_;
          }
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      else {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
      }
      for (k_ = 1; k_ <= j_ - 1; (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
      for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
    }
  }
  _l0:;
  __calls[56].calls++;
  return 0;
}

int_4 _dsymv (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ x_, int_4 _p_ 
incx_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_;
  static real_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 5;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  else if ((*incy_) == 0) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_41, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        ix_ = kx_;
        iy_ = ky_;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
        ix_ = jx_;
        iy_ = jy_;
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[57].calls++;
  return 0;
}

int_4 _dsyr2 (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ y_, int_4 _p_ 
incy_, real_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_;
  static real_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_42, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if (((*incx_) != 1) || ((*incy_) != 1)) {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*n_) - 1) * (*incx_);
    }
    if ((*incy_) > 0) {
      ky_ = 1;
    }
    else {
      ky_ = 1 - ((*n_) - 1) * (*incy_);
    }
    jx_ = kx_;
    jy_ = ky_;
  }
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != 0.0) || (y_[j_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[j_ - 1];
          temp2_ = (*alpha_) * x_[j_ - 1];
          for (i_ = 1; i_ <= j_; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != 0.0) || (y_[jy_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[jy_ - 1];
          temp2_ = (*alpha_) * x_[jx_ - 1];
          ix_ = kx_;
          iy_ = ky_;
          for (i_ = 1; i_ <= j_; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_
            ;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != 0.0) || (y_[j_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[j_ - 1];
          temp2_ = (*alpha_) * x_[j_ - 1];
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != 0.0) || (y_[jy_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[jy_ - 1];
          temp2_ = (*alpha_) * x_[jx_ - 1];
          ix_ = jx_;
          iy_ = jy_;
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_
            ;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[58].calls++;
  return 0;
}

int_4 _dsyr2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ 
lda_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ beta_, real_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static real_8 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_1))) && (! (_lsame (trans_, _dc_2)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_43, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == 0.0) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if (upper_) {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != 0.0) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0)) {
            temp1_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            temp2_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= j_; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != 0.0) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0)) {
            temp1_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            temp2_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = j_; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp1_ = 0.0;
          temp2_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + (*alpha_) * 
            temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp1_ = 0.0;
          temp2_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + (*alpha_) * 
            temp2_;
          }
        }
      }
    }
  }
  _l0:;
  __calls[59].calls++;
  return 0;
}

int_4 _dsyr (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ a_, int_4 _p_ 
lda_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_44, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (uplo_, _dc_8)) {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[j_ - 1];
          for (i_ = 1; i_ <= j_; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
          }
        }
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          ix_ = kx_;
          for (i_ = 1; i_ <= j_; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  else {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[j_ - 1];
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
          }
        }
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          ix_ = jx_;
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  _l0:;
  __calls[60].calls++;
  return 0;
}

int_4 _dsyrk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, real_8 _p_ a_, int_4 _p_ 
lda_, real_8 _p_ beta_, real_8 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_1))) && (! (_lsame (trans_, _dc_2)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_45, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == 0.0) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if (upper_) {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != 0.0) {
            temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= j_; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != 0.0) {
            temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = j_; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[61].calls++;
  return 0;
}

int_4 _dtbmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ 
lda_, real_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kplus1_, kx_, l_;
  static logical_4 nounit_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 7;
  }
  else if ((*incx_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_46, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            l_ = kplus1_ - j_;
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            l_ = kplus1_ - j_;
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
          if (j_ > (*k_)) {
            kx_ = kx_ + (*incx_);
          }
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            l_ = 1 - j_;
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            l_ = 1 - j_;
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
          if (((*n_) - j_) >= (*k_)) {
            kx_ = kx_ - (*incx_);
          }
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          l_ = kplus1_ - j_;
          if (nounit_) {
            temp_ = temp_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
            temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          kx_ = kx_ - (*incx_);
          ix_ = kx_;
          l_ = kplus1_ - j_;
          if (nounit_) {
            temp_ = temp_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
            temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ - (*incx_);
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          l_ = 1 - j_;
          if (nounit_) {
            temp_ = temp_ * a_[0 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
            temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          kx_ = kx_ + (*incx_);
          ix_ = kx_;
          l_ = 1 - j_;
          if (nounit_) {
            temp_ = temp_ * a_[0 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
            temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[62].calls++;
  return 0;
}

int_4 _dtbsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ 
lda_, real_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kplus1_, kx_, l_;
  static logical_4 nounit_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 7;
  }
  else if ((*incx_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_47, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            l_ = kplus1_ - j_;
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          kx_ = kx_ - (*incx_);
          if (x_[jx_ - 1] != 0.0) {
            ix_ = kx_;
            l_ = kplus1_ - j_;
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            l_ = 1 - j_;
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          kx_ = kx_ + (*incx_);
          if (x_[jx_ - 1] != 0.0) {
            ix_ = kx_;
            l_ = 1 - j_;
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          l_ = kplus1_ - j_;
          for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          if (nounit_) {
            temp_ = temp_ / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          l_ = kplus1_ - j_;
          for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          if (j_ > (*k_)) {
            kx_ = kx_ + (*incx_);
          }
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          l_ = 1 - j_;
          for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          if (nounit_) {
            temp_ = temp_ / a_[0 + ((*lda_)) * ((j_ - 1))];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          l_ = 1 - j_;
          for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ - (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / a_[0 + ((*lda_)) * ((j_ - 1))];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          if (((*n_) - j_) >= (*k_)) {
            kx_ = kx_ - (*incx_);
          }
        }
      }
    }
  }
  _l0:;
  __calls[63].calls++;
  return 0;
}

int_4 _dtpmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_8 _p_ ap_, real_8 _p_ x_, int_4 _p_ 
incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static logical_4 nounit_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_48, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            k_ = kk_;
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * ap_[k_ - 1];
              k_ = k_ + 1;
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * ap_[kk_ + j_ - 1 - 1];
            }
          }
          kk_ = kk_ + j_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * ap_[k_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * ap_[kk_ + j_ - 1 - 1];
            }
          }
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + j_;
        }
      }
    }
    else {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            k_ = kk_;
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * ap_[k_ - 1];
              k_ = k_ - 1;
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * ap_[k_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          if (nounit_) {
            temp_ = temp_ * ap_[kk_ - 1];
          }
          k_ = kk_ - 1;
          for (i_ = j_ - 1; i_ >= 1; (i_)--) {
            temp_ = temp_ + ap_[k_ - 1] * x_[i_ - 1];
            k_ = k_ - 1;
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ - j_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (nounit_) {
            temp_ = temp_ * ap_[kk_ - 1];
          }
          for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
            ix_ = ix_ - (*incx_);
            temp_ = temp_ + ap_[k_ - 1] * x_[ix_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - j_;
        }
      }
    }
    else {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          if (nounit_) {
            temp_ = temp_ * ap_[kk_ - 1];
          }
          k_ = kk_ + 1;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            temp_ = temp_ + ap_[k_ - 1] * x_[i_ - 1];
            k_ = k_ + 1;
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (nounit_) {
            temp_ = temp_ * ap_[kk_ - 1];
          }
          for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ix_ = ix_ + (*incx_);
            temp_ = temp_ + ap_[k_ - 1] * x_[ix_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
    }
  }
  _l0:;
  __calls[64].calls++;
  return 0;
}

int_4 _dtpsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_8 _p_ ap_, real_8 _p_ x_, int_4 _p_ 
incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static logical_4 nounit_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_49, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[j_ - 1];
            k_ = kk_ - 1;
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * ap_[k_ - 1];
              k_ = k_ - 1;
            }
          }
          kk_ = kk_ - j_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
              ix_ = ix_ - (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * ap_[k_ - 1];
            }
          }
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - j_;
        }
      }
    }
    else {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[j_ - 1];
            k_ = kk_ + 1;
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * ap_[k_ - 1];
              k_ = k_ + 1;
            }
          }
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
              ix_ = ix_ + (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * ap_[k_ - 1];
            }
          }
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          k_ = kk_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - ap_[k_ - 1] * x_[i_ - 1];
            k_ = k_ + 1;
          }
          if (nounit_) {
            temp_ = temp_ / ap_[kk_ + j_ - 1 - 1];
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ + j_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
            temp_ = temp_ - ap_[k_ - 1] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / ap_[kk_ + j_ - 1 - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + j_;
        }
      }
    }
    else {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          k_ = kk_;
          for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - ap_[k_ - 1] * x_[i_ - 1];
            k_ = k_ - 1;
          }
          if (nounit_) {
            temp_ = temp_ / ap_[kk_ - (*n_) + j_ - 1];
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
            temp_ = temp_ - ap_[k_ - 1] * x_[ix_ - 1];
            ix_ = ix_ - (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / ap_[kk_ - (*n_) + j_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
    }
  }
  _l0:;
  __calls[65].calls++;
  return 0;
}

int_4 _dtrmm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ 
alpha_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 lside_, nounit_, upper_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  lside_ = _lsame (side_, _dc_9);
  if (lside_) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  nounit_ = _lsame (diag_, _dc_0);
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (lside_)) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((! (_lsame (transa_, _dc_0))) && (! (_lsame (transa_, _dc_1))) && (! (_lsame (transa_, _dc_2)))) {
    info_ = 3;
  }
  else if ((! (_lsame (diag_, _dc_8))) && (! (_lsame (diag_, _dc_0)))) {
    info_ = 4;
  }
  else if ((*m_) < 0) {
    info_ = 5;
  }
  else if ((*n_) < 0) {
    info_ = 6;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_50, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = 0.0;
      }
    }
    goto _l0;
  }
  if (lside_) {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (k_ = 1; k_ <= (*m_); (k_)++) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
              temp_ = (*alpha_) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= k_ - 1; (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))]
                ;
              }
              if (nounit_) {
                temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (k_ = (*m_); k_ >= 1; (k_)--) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
              temp_ = (*alpha_) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = k_ + 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = (*m_); i_ >= 1; (i_)--) {
            temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (nounit_) {
              temp_ = temp_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
            for (k_ = 1; k_ <= i_ - 1; (k_)++) {
              temp_ = temp_ + a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (nounit_) {
              temp_ = temp_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
            for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
              temp_ = temp_ + a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
        }
      }
    }
  }
  else {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          for (k_ = 1; k_ <= j_ - 1; (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != 0.0) {
              temp_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != 0.0) {
              temp_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (k_ = 1; k_ <= (*n_); (k_)++) {
          for (j_ = 1; j_ <= k_ - 1; (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
              temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
          }
          if (temp_ != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
      else {
        for (k_ = (*n_); k_ >= 1; (k_)--) {
          for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
              temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
          }
          if (temp_ != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[66].calls++;
  return 0;
}

int_4 _dtrmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ 
x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static logical_4 nounit_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_51, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ - 1; i_ >= 1; (i_)--) {
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ - 1; i_ >= 1; (i_)--) {
            ix_ = ix_ - (*incx_);
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ix_ = ix_ + (*incx_);
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[67].calls++;
  return 0;
}

int_4 _dtrsm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ 
alpha_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 lside_, nounit_, upper_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  lside_ = _lsame (side_, _dc_9);
  if (lside_) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  nounit_ = _lsame (diag_, _dc_0);
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (lside_)) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((! (_lsame (transa_, _dc_0))) && (! (_lsame (transa_, _dc_1))) && (! (_lsame (transa_, _dc_2)))) {
    info_ = 3;
  }
  else if ((! (_lsame (diag_, _dc_8))) && (! (_lsame (diag_, _dc_0)))) {
    info_ = 4;
  }
  else if ((*m_) < 0) {
    info_ = 5;
  }
  else if ((*n_) < 0) {
    info_ = 6;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_52, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = 0.0;
      }
    }
    goto _l0;
  }
  if (lside_) {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = (*m_); k_ >= 1; (k_)--) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = 1; i_ <= k_ - 1; (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[i_ 
                - 1 + ((*lda_)) * ((k_ - 1))];
              }
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = 1; k_ <= (*m_); (k_)++) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = k_ + 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[i_ 
                - 1 + ((*lda_)) * ((k_ - 1))];
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            for (k_ = 1; k_ <= i_ - 1; (k_)++) {
              temp_ = temp_ - a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
            if (nounit_) {
              temp_ = temp_ / a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = (*m_); i_ >= 1; (i_)--) {
            temp_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
              temp_ = temp_ - a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
            if (nounit_) {
              temp_ = temp_ / a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
          }
        }
      }
    }
  }
  else {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = 1; k_ <= j_ - 1; (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != 0.0) {
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] * b_[i_ 
                - 1 + ((*ldb_)) * ((k_ - 1))];
              }
            }
          }
          if (nounit_) {
            temp_ = 1.0 / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != 0.0) {
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] * b_[i_ 
                - 1 + ((*ldb_)) * ((k_ - 1))];
              }
            }
          }
          if (nounit_) {
            temp_ = 1.0 / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (k_ = (*n_); k_ >= 1; (k_)--) {
          if (nounit_) {
            temp_ = 1.0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
          for (j_ = 1; j_ <= k_ - 1; (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
      else {
        for (k_ = 1; k_ <= (*n_); (k_)++) {
          if (nounit_) {
            temp_ = 1.0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
          for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[68].calls++;
  return 0;
}

int_4 _dtrsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ 
x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static logical_4 nounit_;
  static real_8 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_53, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              ix_ = ix_ - (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              ix_ = ix_ + (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          if (nounit_) {
            temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          if (nounit_) {
            temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ - (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[69].calls++;
  return 0;
}

real_8 _dzasum (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  static real_8 stemp_;
  real_8 dzasum_;
  dzasum_ = 0.0;
  stemp_ = 0.0;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = stemp_ + _dcabs1 (&zx_[ix_ - 1]);
    ix_ = ix_ + (*incx_);
  }
  dzasum_ = stemp_;
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = stemp_ + _dcabs1 (&zx_[i_ - 1]);
  }
  dzasum_ = stemp_;
  _l0:;
  __calls[70].calls++;
  return dzasum_;
}

real_8 _dznrm2 (int_4 _p_ n_, complex_16 _p_ x_, int_4 _p_ incx_)
{
  static int_4 ix_;
  static real_8 norm_, scale_, ssq_, temp_;
  real_8 $0_, $1_, $2_, $3_;
  real_8 dznrm2_;
  if ((*n_) < 1 || (*incx_) < 1) {
    norm_ = 0.0;
  }
  else {
    scale_ = 0.0;
    ssq_ = 1.0;
    for (ix_ = 1; ((*incx_) > 0 ? ix_ <= 1 + ((*n_) - 1) * (*incx_) : ix_ >= 1 + ((*n_) - 1) * (*incx_)); ix_ += (*incx_)) 
      {
      if ((real_8) (creal (x_[ix_ - 1])) != 0.0) {
        temp_ = _abs ((real_8) (creal (x_[ix_ - 1])));
        if (scale_ < temp_) {
          ssq_ = 1.0 + ssq_ * ($0_ = (scale_ / temp_), $0_ * $0_);
          scale_ = temp_;
        }
        else {
          ssq_ = ssq_ + ($1_ = (temp_ / scale_), $1_ * $1_);
        }
      }
      if (cimag (x_[ix_ - 1]) != 0.0) {
        temp_ = _abs (cimag (x_[ix_ - 1]));
        if (scale_ < temp_) {
          ssq_ = 1.0 + ssq_ * ($2_ = (scale_ / temp_), $2_ * $2_);
          scale_ = temp_;
        }
        else {
          ssq_ = ssq_ + ($3_ = (temp_ / scale_), $3_ * $3_);
        }
      }
    }
    norm_ = scale_ * sqrt (ssq_);
  }
  dznrm2_ = norm_;
  __calls[71].calls++;
  return dznrm2_;
}

int_4 _icamax (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  static real_4 smax_;
  int_4 icamax_;
  icamax_ = 0;
  if ((*n_) < 1 || (*incx_) <= 0) {
    goto _l0;
  }
  icamax_ = 1;
  if ((*n_) == 1) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  smax_ = _scabs1 (&cx_[0]);
  ix_ = ix_ + (*incx_);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (_scabs1 (&cx_[ix_ - 1]) <= smax_) {
      goto _l5;
    }
    icamax_ = i_;
    smax_ = _scabs1 (&cx_[ix_ - 1]);
    _l5:;
    ix_ = ix_ + (*incx_);
  }
  goto _l0;
  _l20:;
  smax_ = _scabs1 (&cx_[0]);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (_scabs1 (&cx_[i_ - 1]) <= smax_) {
      goto _l30;
    }
    icamax_ = i_;
    smax_ = _scabs1 (&cx_[i_ - 1]);
    _l30:;
  }
  _l0:;
  __calls[72].calls++;
  return icamax_;
}

int_4 _idamax (int_4 _p_ n_, real_8 _p_ dx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  static real_8 dmax_;
  int_4 idamax_;
  extern real_8 _dabs ();
  real_8 __dabs (real_8 _p_ __x__) {return _abs (*__x__);}
  idamax_ = 0;
  if ((*n_) < 1 || (*incx_) <= 0) {
    goto _l0;
  }
  idamax_ = 1;
  if ((*n_) == 1) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  dmax_ = __dabs (&dx_[0]);
  ix_ = ix_ + (*incx_);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (__dabs (&dx_[ix_ - 1]) <= dmax_) {
      goto _l5;
    }
    idamax_ = i_;
    dmax_ = __dabs (&dx_[ix_ - 1]);
    _l5:;
    ix_ = ix_ + (*incx_);
  }
  goto _l0;
  _l20:;
  dmax_ = __dabs (&dx_[0]);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (__dabs (&dx_[i_ - 1]) <= dmax_) {
      goto _l30;
    }
    idamax_ = i_;
    dmax_ = __dabs (&dx_[i_ - 1]);
    _l30:;
  }
  _l0:;
  __calls[73].calls++;
  return idamax_;
}

int_4 _isamax (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  static real_4 smax_;
  int_4 isamax_;
  isamax_ = 0;
  if ((*n_) < 1 || (*incx_) <= 0) {
    goto _l0;
  }
  isamax_ = 1;
  if ((*n_) == 1) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  smax_ = _abs (sx_[0]);
  ix_ = ix_ + (*incx_);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (_abs (sx_[ix_ - 1]) <= smax_) {
      goto _l5;
    }
    isamax_ = i_;
    smax_ = _abs (sx_[ix_ - 1]);
    _l5:;
    ix_ = ix_ + (*incx_);
  }
  goto _l0;
  _l20:;
  smax_ = _abs (sx_[0]);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (_abs (sx_[i_ - 1]) <= smax_) {
      goto _l30;
    }
    isamax_ = i_;
    smax_ = _abs (sx_[i_ - 1]);
    _l30:;
  }
  _l0:;
  __calls[74].calls++;
  return isamax_;
}

int_4 _izamax (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  static real_8 smax_;
  int_4 izamax_;
  izamax_ = 0;
  if ((*n_) < 1 || (*incx_) <= 0) {
    goto _l0;
  }
  izamax_ = 1;
  if ((*n_) == 1) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  smax_ = _dcabs1 (&zx_[0]);
  ix_ = ix_ + (*incx_);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (_dcabs1 (&zx_[ix_ - 1]) <= smax_) {
      goto _l5;
    }
    izamax_ = i_;
    smax_ = _dcabs1 (&zx_[ix_ - 1]);
    _l5:;
    ix_ = ix_ + (*incx_);
  }
  goto _l0;
  _l20:;
  smax_ = _dcabs1 (&zx_[0]);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (_dcabs1 (&zx_[i_ - 1]) <= smax_) {
      goto _l30;
    }
    izamax_ = i_;
    smax_ = _dcabs1 (&zx_[i_ - 1]);
    _l30:;
  }
  _l0:;
  __calls[75].calls++;
  return izamax_;
}

real_4 _sasum (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_)
{
  static int_4 i_, m_, mp1_, nincx_;
  static real_4 stemp_;
  real_4 sasum_;
  sasum_ = 0.0;
  stemp_ = 0.0;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    stemp_ = stemp_ + _abs (sx_[i_ - 1]);
  }
  sasum_ = stemp_;
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 6);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    stemp_ = stemp_ + _abs (sx_[i_ - 1]);
  }
  if ((*n_) < 6) {
    goto _l60;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (6 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 6) {
    stemp_ = stemp_ + _abs (sx_[i_ - 1]) + _abs (sx_[i_ + 1 - 1]) + _abs (sx_[i_ + 2 - 1]) + _abs (sx_[i_ + 3 - 1]) + _abs 
    (sx_[i_ + 4 - 1]) + _abs (sx_[i_ + 5 - 1]);
  }
  _l60:;
  sasum_ = stemp_;
  _l0:;
  __calls[76].calls++;
  return sasum_;
}

int_4 _saxpy (int_4 _p_ n_, real_4 _p_ sa_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_, m_, mp1_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*sa_) == 0.0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sy_[iy_ - 1] = sy_[iy_ - 1] + (*sa_) * sx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 4);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    sy_[i_ - 1] = sy_[i_ - 1] + (*sa_) * sx_[i_ - 1];
  }
  if ((*n_) < 4) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (4 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 4) {
    sy_[i_ - 1] = sy_[i_ - 1] + (*sa_) * sx_[i_ - 1];
    sy_[i_ + 1 - 1] = sy_[i_ + 1 - 1] + (*sa_) * sx_[i_ + 1 - 1];
    sy_[i_ + 2 - 1] = sy_[i_ + 2 - 1] + (*sa_) * sx_[i_ + 2 - 1];
    sy_[i_ + 3 - 1] = sy_[i_ + 3 - 1] + (*sa_) * sx_[i_ + 3 - 1];
  }
  _l0:;
  __calls[77].calls++;
  return 0;
}
real_4 _scabs1 (complex_8 _p_ z_)
{
  real_4 scabs1_;
  scabs1_ = _abs ((real_4) (crealf ((*z_)))) + _abs (cimagf ((*z_)));
  __calls[78].calls++;
  return scabs1_;
}

real_4 _scasum (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_)
{
  static int_4 i_, nincx_;
  static real_4 stemp_;
  real_4 scasum_;
  scasum_ = 0.0;
  stemp_ = 0.0;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    stemp_ = stemp_ + _abs ((real_4) (crealf (cx_[i_ - 1]))) + _abs (cimagf (cx_[i_ - 1]));
  }
  scasum_ = stemp_;
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = stemp_ + _abs ((real_4) (crealf (cx_[i_ - 1]))) + _abs (cimagf (cx_[i_ - 1]));
  }
  scasum_ = stemp_;
  _l0:;
  __calls[79].calls++;
  return scasum_;
}

real_4 _scnrm2 (int_4 _p_ n_, complex_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 ix_;
  static real_4 norm_, scale_, ssq_, temp_;
  real_4 $0_, $1_, $2_, $3_;
  real_4 scnrm2_;
  if ((*n_) < 1 || (*incx_) < 1) {
    norm_ = 0.0;
  }
  else {
    scale_ = 0.0;
    ssq_ = 1.0;
    for (ix_ = 1; ((*incx_) > 0 ? ix_ <= 1 + ((*n_) - 1) * (*incx_) : ix_ >= 1 + ((*n_) - 1) * (*incx_)); ix_ += (*incx_)) 
      {
      if ((real_4) (crealf (x_[ix_ - 1])) != 0.0) {
        temp_ = _abs ((real_4) (crealf (x_[ix_ - 1])));
        if (scale_ < temp_) {
          ssq_ = 1.0 + ssq_ * ($0_ = (scale_ / temp_), $0_ * $0_);
          scale_ = temp_;
        }
        else {
          ssq_ = ssq_ + ($1_ = (temp_ / scale_), $1_ * $1_);
        }
      }
      if (cimagf (x_[ix_ - 1]) != 0.0) {
        temp_ = _abs (cimagf (x_[ix_ - 1]));
        if (scale_ < temp_) {
          ssq_ = 1.0 + ssq_ * ($2_ = (scale_ / temp_), $2_ * $2_);
          scale_ = temp_;
        }
        else {
          ssq_ = ssq_ + ($3_ = (temp_ / scale_), $3_ * $3_);
        }
      }
    }
    norm_ = scale_ * sqrtf (ssq_);
  }
  scnrm2_ = norm_;
  __calls[80].calls++;
  return scnrm2_;
}

int_4 _scopy (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_, m_, mp1_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sy_[iy_ - 1] = sx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 7);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    sy_[i_ - 1] = sx_[i_ - 1];
  }
  if ((*n_) < 7) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (7 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 7) {
    sy_[i_ - 1] = sx_[i_ - 1];
    sy_[i_ + 1 - 1] = sx_[i_ + 1 - 1];
    sy_[i_ + 2 - 1] = sx_[i_ + 2 - 1];
    sy_[i_ + 3 - 1] = sx_[i_ + 3 - 1];
    sy_[i_ + 4 - 1] = sx_[i_ + 4 - 1];
    sy_[i_ + 5 - 1] = sx_[i_ + 5 - 1];
    sy_[i_ + 6 - 1] = sx_[i_ + 6 - 1];
  }
  _l0:;
  __calls[81].calls++;
  return 0;
}
real_4 _sdot (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_, m_, mp1_;
  static real_4 stemp_;
  real_4 sdot_;
  stemp_ = 0.0;
  sdot_ = 0.0;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = stemp_ + sx_[ix_ - 1] * sy_[iy_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  sdot_ = stemp_;
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 5);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    stemp_ = stemp_ + sx_[i_ - 1] * sy_[i_ - 1];
  }
  if ((*n_) < 5) {
    goto _l60;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (5 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 5) {
    stemp_ = stemp_ + sx_[i_ - 1] * sy_[i_ - 1] + sx_[i_ + 1 - 1] * sy_[i_ + 1 - 1] + sx_[i_ + 2 - 1] * sy_[i_ + 2 - 1] + 
    sx_[i_ + 3 - 1] * sy_[i_ + 3 - 1] + sx_[i_ + 4 - 1] * sy_[i_ + 4 - 1];
  }
  _l60:;
  sdot_ = stemp_;
  _l0:;
  __calls[82].calls++;
  return sdot_;
}

real_4 _sdsdot (int_4 _p_ n_, real_4 _p_ sb_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_)
{
  static int_4 i_, kx_, ky_, ns_;
  static real_8 dsdot_;
  real_4 sdsdot_;
  dsdot_ = (*sb_);
  if ((*n_) <= 0) {
    goto _l30;
  }
  if ((*incx_) == (*incy_) && (*incx_) > 0) {
    goto _l40;
  }
  kx_ = 1;
  ky_ = 1;
  if ((*incx_) < 0) {
    kx_ = 1 + (1 - (*n_)) * (*incx_);
  }
  if ((*incy_) < 0) {
    ky_ = 1 + (1 - (*n_)) * (*incy_);
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    dsdot_ = dsdot_ + (real_8) (sx_[kx_ - 1]) * (real_8) (sy_[ky_ - 1]);
    kx_ = kx_ + (*incx_);
    ky_ = ky_ + (*incy_);
  }
  _l30:;
  sdsdot_ = dsdot_;
  goto _l0;
  _l40:;
  ns_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= ns_ : i_ >= ns_); i_ += (*incx_)) {
    dsdot_ = dsdot_ + (real_8) (sx_[i_ - 1]) * (real_8) (sy_[i_ - 1]);
  }
  sdsdot_ = dsdot_;
  _l0:;
  __calls[83].calls++;
  return sdsdot_;
}

int_4 _sgbmv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ alpha_, real_4 _p_ 
a_, int_4 _p_ lda_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kup1_, kx_, ky_, lenx_, leny_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 1;
  }
  else if ((*m_) < 0) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*kl_) < 0) {
    info_ = 4;
  }
  else if ((*ku_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*kl_) + (*ku_) + 1)) {
    info_ = 8;
  }
  else if ((*incx_) == 0) {
    info_ = 10;
  }
  else if ((*incy_) == 0) {
    info_ = 13;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_54, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    lenx_ = (*n_);
    leny_ = (*m_);
  }
  else {
    lenx_ = (*m_);
    leny_ = (*n_);
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - (lenx_ - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - (leny_ - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  kup1_ = (*ku_) + 1;
  if (_lsame (trans_, _dc_0)) {
    jx_ = kx_;
    if ((*incy_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          k_ = kup1_ - j_;
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            y_[i_ - 1] = y_[i_ - 1] + temp_ * a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          iy_ = ky_;
          k_ = kup1_ - j_;
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            y_[iy_ - 1] = y_[iy_ - 1] + temp_ * a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        if (j_ > (*ku_)) {
          ky_ = ky_ + (*incy_);
        }
      }
    }
  }
  else {
    jy_ = ky_;
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = 0.0;
        k_ = kup1_ - j_;
        for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
          temp_ = temp_ + a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = 0.0;
        ix_ = kx_;
        k_ = kup1_ - j_;
        for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
          temp_ = temp_ + a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
        if (j_ > (*ku_)) {
          kx_ = kx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[84].calls++;
  return 0;
}

int_4 _sgemm (char _p_ transa_, char _p_ transb_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, real_4 
_p_ a_, int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ beta_, real_4 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, ncola_, nrowa_, nrowb_;
  static logical_4 nota_, notb_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  nota_ = _lsame (transa_, _dc_0);
  notb_ = _lsame (transb_, _dc_0);
  if (nota_) {
    nrowa_ = (*m_);
    ncola_ = (*k_);
  }
  else {
    nrowa_ = (*k_);
    ncola_ = (*m_);
  }
  if (notb_) {
    nrowb_ = (*k_);
  }
  else {
    nrowb_ = (*n_);
  }
  info_ = 0;
  if ((! (nota_)) && (! (_lsame (transa_, _dc_2))) && (! (_lsame (transa_, _dc_1)))) {
    info_ = 1;
  }
  else if ((! (notb_)) && (! (_lsame (transb_, _dc_2))) && (! (_lsame (transb_, _dc_1)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 8;
  }
  else if ((*ldb_) < _max (1, nrowb_)) {
    info_ = 10;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 13;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_55, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((((*alpha_) == 0.0) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if ((*beta_) == 0.0) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (notb_) {
    if (nota_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
            temp_ = (*alpha_) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  else {
    if (nota_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0) {
            temp_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[85].calls++;
  return 0;
}

int_4 _sgemv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ 
x_, int_4 _p_ incx_, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_, lenx_, leny_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 1;
  }
  else if ((*m_) < 0) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  else if ((*incy_) == 0) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_56, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    lenx_ = (*n_);
    leny_ = (*m_);
  }
  else {
    lenx_ = (*m_);
    leny_ = (*n_);
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - (lenx_ - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - (leny_ - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    jx_ = kx_;
    if ((*incy_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            y_[i_ - 1] = y_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          iy_ = ky_;
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            y_[iy_ - 1] = y_[iy_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  else {
    jy_ = ky_;
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = 0.0;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = 0.0;
        ix_ = kx_;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[86].calls++;
  return 0;
}

int_4 _sger (int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ y_, int_4 _p_ 
incy_, real_4 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, j_, jy_, kx_;
  static real_4 temp_;
  extern int_4 _xerbla ();
  info_ = 0;
  if ((*m_) < 0) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_57, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if ((*incy_) > 0) {
    jy_ = 1;
  }
  else {
    jy_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*incx_) == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != 0.0) {
        temp_ = (*alpha_) * y_[jy_ - 1];
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  else {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*m_) - 1) * (*incx_);
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != 0.0) {
        temp_ = (*alpha_) * y_[jy_ - 1];
        ix_ = kx_;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
          ix_ = ix_ + (*incx_);
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  _l0:;
  __calls[87].calls++;
  return 0;
}

real_4 _snrm2 (int_4 _p_ n_, real_4 _p_ x_, int_4 _p_ incx_)
{
  static int_4 ix_;
  static real_4 absxi_, norm_, scale_, ssq_;
  real_4 $0_, $1_;
  real_4 snrm2_;
  if ((*n_) < 1 || (*incx_) < 1) {
    norm_ = 0.0;
  }
  else if ((*n_) == 1) {
    norm_ = _abs (x_[0]);
  }
  else {
    scale_ = 0.0;
    ssq_ = 1.0;
    for (ix_ = 1; ((*incx_) > 0 ? ix_ <= 1 + ((*n_) - 1) * (*incx_) : ix_ >= 1 + ((*n_) - 1) * (*incx_)); ix_ += (*incx_)) 
      {
      if (x_[ix_ - 1] != 0.0) {
        absxi_ = _abs (x_[ix_ - 1]);
        if (scale_ < absxi_) {
          ssq_ = 1.0 + ssq_ * ($0_ = (scale_ / absxi_), $0_ * $0_);
          scale_ = absxi_;
        }
        else {
          ssq_ = ssq_ + ($1_ = (absxi_ / scale_), $1_ * $1_);
        }
      }
    }
    norm_ = scale_ * sqrtf (ssq_);
  }
  snrm2_ = norm_;
  __calls[88].calls++;
  return snrm2_;
}

int_4 _srot (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_, real_4 _p_ c_, real_4 _p_ 
s_)
{
  static int_4 i_, ix_, iy_;
  static real_4 stemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = (*c_) * sx_[ix_ - 1] + (*s_) * sy_[iy_ - 1];
    sy_[iy_ - 1] = (*c_) * sy_[iy_ - 1] - (*s_) * sx_[ix_ - 1];
    sx_[ix_ - 1] = stemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = (*c_) * sx_[i_ - 1] + (*s_) * sy_[i_ - 1];
    sy_[i_ - 1] = (*c_) * sy_[i_ - 1] - (*s_) * sx_[i_ - 1];
    sx_[i_ - 1] = stemp_;
  }
  _l0:;
  __calls[89].calls++;
  return 0;
}

int_4 _srotg (real_4 _p_ sa_, real_4 _p_ sb_, real_4 _p_ c_, real_4 _p_ s_)
{
  static real_4 r_, roe_, scale_, z_;
  real_4 $0_, $1_;
  roe_ = (*sb_);
  if (_abs ((*sa_)) > _abs ((*sb_))) {
    roe_ = (*sa_);
  }
  scale_ = _abs ((*sa_)) + _abs ((*sb_));
  if (scale_ != 0.0) {
    goto _l10;
  }
  (*c_) = 1.0;
  (*s_) = 0.0;
  r_ = 0.0;
  z_ = 0.0;
  goto _l20;
  _l10:;
  r_ = scale_ * sqrtf (($0_ = ((*sa_) / scale_), $0_ * $0_) + ($1_ = ((*sb_) / scale_), $1_ * $1_));
  r_ = _sign (1.0, roe_) * r_;
  (*c_) = (*sa_) / r_;
  (*s_) = (*sb_) / r_;
  z_ = 1.0;
  if (_abs ((*sa_)) > _abs ((*sb_))) {
    z_ = (*s_);
  }
  if (_abs ((*sb_)) >= _abs ((*sa_)) && (*c_) != 0.0) {
    z_ = 1.0 / (*c_);
  }
  _l20:;
  (*sa_) = r_;
  (*sb_) = z_;
  __calls[90].calls++;
  return 0;
}

int_4 _srotm (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_, real_4 _p_ sparam_)
{
  static int_4 i_, kx_, ky_, nsteps_;
  static real_4 sflag_, sh11_, sh12_, sh21_, sh22_, two_, w_, z_, zero_;
  int_4 _data_k_3;
  real_4 $0_, $1_;
#define _data_n_3 2
  static real_4 _data_l_3[_data_n_3] = {
    0.0e0,
    2.0e0
  };
  if (__calls[91].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    zero_ = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    two_ = _data_l_3[_data_k_3++];
  }
  sflag_ = sparam_[0];
  if ((*n_) <= 0 || (sflag_ + two_ == zero_)) {
    goto _l140;
  }
  if (! (((*incx_) == (*incy_) && (*incx_) > 0))) {
    goto _l70;
  }
  nsteps_ = (*n_) * (*incx_);
  $0_ = sflag_;
  if ($0_ < 0) {
    goto _l50;
  } else if ($0_ == 0) {
    goto _l10;
  } else {
    goto _l30;
  }
  _l10:;
  sh12_ = sparam_[3];
  sh21_ = sparam_[2];
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nsteps_ : i_ >= nsteps_); i_ += (*incx_)) {
    w_ = sx_[i_ - 1];
    z_ = sy_[i_ - 1];
    sx_[i_ - 1] = w_ + z_ * sh12_;
    sy_[i_ - 1] = w_ * sh21_ + z_;
  }
  goto _l140;
  _l30:;
  sh11_ = sparam_[1];
  sh22_ = sparam_[4];
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nsteps_ : i_ >= nsteps_); i_ += (*incx_)) {
    w_ = sx_[i_ - 1];
    z_ = sy_[i_ - 1];
    sx_[i_ - 1] = w_ * sh11_ + z_;
    sy_[i_ - 1] = -w_ + sh22_ * z_;
  }
  goto _l140;
  _l50:;
  sh11_ = sparam_[1];
  sh12_ = sparam_[3];
  sh21_ = sparam_[2];
  sh22_ = sparam_[4];
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nsteps_ : i_ >= nsteps_); i_ += (*incx_)) {
    w_ = sx_[i_ - 1];
    z_ = sy_[i_ - 1];
    sx_[i_ - 1] = w_ * sh11_ + z_ * sh12_;
    sy_[i_ - 1] = w_ * sh21_ + z_ * sh22_;
  }
  goto _l140;
  _l70:;
  kx_ = 1;
  ky_ = 1;
  if ((*incx_) < 0) {
    kx_ = 1 + (1 - (*n_)) * (*incx_);
  }
  if ((*incy_) < 0) {
    ky_ = 1 + (1 - (*n_)) * (*incy_);
  }
  $1_ = sflag_;
  if ($1_ < 0) {
    goto _l120;
  } else if ($1_ == 0) {
    goto _l80;
  } else {
    goto _l100;
  }
  _l80:;
  sh12_ = sparam_[3];
  sh21_ = sparam_[2];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_ = sx_[kx_ - 1];
    z_ = sy_[ky_ - 1];
    sx_[kx_ - 1] = w_ + z_ * sh12_;
    sy_[ky_ - 1] = w_ * sh21_ + z_;
    kx_ = kx_ + (*incx_);
    ky_ = ky_ + (*incy_);
  }
  goto _l140;
  _l100:;
  sh11_ = sparam_[1];
  sh22_ = sparam_[4];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_ = sx_[kx_ - 1];
    z_ = sy_[ky_ - 1];
    sx_[kx_ - 1] = w_ * sh11_ + z_;
    sy_[ky_ - 1] = -w_ + sh22_ * z_;
    kx_ = kx_ + (*incx_);
    ky_ = ky_ + (*incy_);
  }
  goto _l140;
  _l120:;
  sh11_ = sparam_[1];
  sh12_ = sparam_[3];
  sh21_ = sparam_[2];
  sh22_ = sparam_[4];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_ = sx_[kx_ - 1];
    z_ = sy_[ky_ - 1];
    sx_[kx_ - 1] = w_ * sh11_ + z_ * sh12_;
    sy_[ky_ - 1] = w_ * sh21_ + z_ * sh22_;
    kx_ = kx_ + (*incx_);
    ky_ = ky_ + (*incy_);
  }
  _l140:;
  __calls[91].calls++;
  return 0;
}

int_4 _srotmg (real_4 _p_ sd1_, real_4 _p_ sd2_, real_4 _p_ sx1_, real_4 _p_ sy1_, real_4 _p_ sparam_)
{
  static int_4 igo_;
  static real_4 gam_, gamsq_, one_, rgamsq_, sflag_, sh11_, sh12_, sh21_, sh22_, sp1_, sp2_, sq1_, sq2_, stemp_, su_, 
  two_, zero_;
  int_4 _data_k_4, _data_k_5;
  real_4 $0_;
#define _data_n_4 3
  static real_4 _data_l_4[_data_n_4] = {
    0.0e0,
    1.0e0,
    2.0e0
  };
#define _data_n_5 3
  static real_4 _data_l_5[_data_n_5] = {
    4096.0e0,
    1.67772e7,
    5.96046e-8
  };
  if (__calls[92].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    zero_ = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    one_ = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    two_ = _data_l_4[_data_k_4++];
  }
  if (__calls[92].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    gam_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    gamsq_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    rgamsq_ = _data_l_5[_data_k_5++];
  }
  if (! ((*sd1_) < zero_)) {
    goto _l10;
  }
  goto _l60;
  _l10:;
  sp2_ = (*sd2_) * (*sy1_);
  if (! (sp2_ == zero_)) {
    goto _l20;
  }
  sflag_ = -two_;
  goto _l260;
  _l20:;
  sp1_ = (*sd1_) * (*sx1_);
  sq2_ = sp2_ * (*sy1_);
  sq1_ = sp1_ * (*sx1_);
  if (! (_abs (sq1_) > _abs (sq2_))) {
    goto _l40;
  }
  sh21_ = -(*sy1_) / (*sx1_);
  sh12_ = sp2_ / sp1_;
  su_ = one_ - sh12_ * sh21_;
  if (! (su_ <= zero_)) {
    goto _l30;
  }
  goto _l60;
  _l30:;
  sflag_ = zero_;
  (*sd1_) = (*sd1_) / su_;
  (*sd2_) = (*sd2_) / su_;
  (*sx1_) = (*sx1_) * su_;
  goto _l100;
  _l40:;
  if (! (sq2_ < zero_)) {
    goto _l50;
  }
  goto _l60;
  _l50:;
  sflag_ = one_;
  sh11_ = sp1_ / sp2_;
  sh22_ = (*sx1_) / (*sy1_);
  su_ = one_ + sh11_ * sh22_;
  stemp_ = (*sd2_) / su_;
  (*sd2_) = (*sd1_) / su_;
  (*sd1_) = stemp_;
  (*sx1_) = (*sy1_) * su_;
  goto _l100;
  _l60:;
  sflag_ = -one_;
  sh11_ = zero_;
  sh12_ = zero_;
  sh21_ = zero_;
  sh22_ = zero_;
  (*sd1_) = zero_;
  (*sd2_) = zero_;
  (*sx1_) = zero_;
  goto _l220;
  _l70:;
  if (! (sflag_ >= zero_)) {
    goto _l90;
  }
  if (! (sflag_ == zero_)) {
    goto _l80;
  }
  sh11_ = one_;
  sh22_ = one_;
  sflag_ = -one_;
  goto _l90;
  _l80:;
  sh21_ = -one_;
  sh12_ = one_;
  sflag_ = -one_;
  _l90:;
  switch (igo_) {
    default:
    case 12: goto _l120;
    case 15: goto _l150;
    case 18: goto _l180;
    case 21: goto _l210;
  }
  _l100:;
  _l110:;
  if (! ((*sd1_) <= rgamsq_)) {
    goto _l130;
  }
  if ((*sd1_) == zero_) {
    goto _l160;
  }
  igo_ = 12;
  goto _l70;
  _l120:;
  (*sd1_) = (*sd1_) * (gam_ * gam_);
  (*sx1_) = (*sx1_) / gam_;
  sh11_ = sh11_ / gam_;
  sh12_ = sh12_ / gam_;
  goto _l110;
  _l130:;
  _l140:;
  if (! ((*sd1_) >= gamsq_)) {
    goto _l160;
  }
  igo_ = 15;
  goto _l70;
  _l150:;
  (*sd1_) = (*sd1_) / (gam_ * gam_);
  (*sx1_) = (*sx1_) * gam_;
  sh11_ = sh11_ * gam_;
  sh12_ = sh12_ * gam_;
  goto _l140;
  _l160:;
  _l170:;
  if (! (_abs ((*sd2_)) <= rgamsq_)) {
    goto _l190;
  }
  if ((*sd2_) == zero_) {
    goto _l220;
  }
  igo_ = 18;
  goto _l70;
  _l180:;
  (*sd2_) = (*sd2_) * (gam_ * gam_);
  sh21_ = sh21_ / gam_;
  sh22_ = sh22_ / gam_;
  goto _l170;
  _l190:;
  _l200:;
  if (! (_abs ((*sd2_)) >= gamsq_)) {
    goto _l220;
  }
  igo_ = 21;
  goto _l70;
  _l210:;
  (*sd2_) = (*sd2_) / (gam_ * gam_);
  sh21_ = sh21_ * gam_;
  sh22_ = sh22_ * gam_;
  goto _l200;
  _l220:;
  $0_ = sflag_;
  if ($0_ < 0) {
    goto _l250;
  } else if ($0_ == 0) {
    goto _l230;
  } else {
    goto _l240;
  }
  _l230:;
  sparam_[2] = sh21_;
  sparam_[3] = sh12_;
  goto _l260;
  _l240:;
  sparam_[1] = sh11_;
  sparam_[4] = sh22_;
  goto _l260;
  _l250:;
  sparam_[1] = sh11_;
  sparam_[2] = sh21_;
  sparam_[3] = sh12_;
  sparam_[4] = sh22_;
  _l260:;
  sparam_[0] = sflag_;
  __calls[92].calls++;
  return 0;
}

int_4 _ssbmv (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ 
x_, int_4 _p_ incx_, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kplus1_, kx_, ky_, l_;
  static real_4 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*k_) < 0) {
    info_ = 3;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  else if ((*incy_) == 0) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_58, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  if (_lsame (uplo_, _dc_8)) {
    kplus1_ = (*k_) + 1;
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        l_ = kplus1_ - j_;
        for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        ix_ = kx_;
        iy_ = ky_;
        l_ = kplus1_ - j_;
        for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        if (j_ > (*k_)) {
          kx_ = kx_ + (*incx_);
          ky_ = ky_ + (*incy_);
        }
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * a_[0 + ((*lda_)) * ((j_ - 1))];
        l_ = 1 - j_;
        for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * a_[0 + ((*lda_)) * ((j_ - 1))];
        l_ = 1 - j_;
        ix_ = jx_;
        iy_ = jy_;
        for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[93].calls++;
  return 0;
}

int_4 _sscal (int_4 _p_ n_, real_4 _p_ sa_, real_4 _p_ sx_, int_4 _p_ incx_)
{
  static int_4 i_, m_, mp1_, nincx_;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    sx_[i_ - 1] = (*sa_) * sx_[i_ - 1];
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 5);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    sx_[i_ - 1] = (*sa_) * sx_[i_ - 1];
  }
  if ((*n_) < 5) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (5 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 5) {
    sx_[i_ - 1] = (*sa_) * sx_[i_ - 1];
    sx_[i_ + 1 - 1] = (*sa_) * sx_[i_ + 1 - 1];
    sx_[i_ + 2 - 1] = (*sa_) * sx_[i_ + 2 - 1];
    sx_[i_ + 3 - 1] = (*sa_) * sx_[i_ + 3 - 1];
    sx_[i_ + 4 - 1] = (*sa_) * sx_[i_ + 4 - 1];
  }
  _l0:;
  __calls[94].calls++;
  return 0;
}

int_4 _sspmv (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ ap_, real_4 _p_ x_, int_4 _p_ incx_, real_4 
_p_ beta_, real_4 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kk_, kx_, ky_;
  static real_4 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 6;
  }
  else if ((*incy_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_59, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        k_ = kk_;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + ap_[k_ - 1] * x_[i_ - 1];
          k_ = k_ + 1;
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * ap_[kk_ + j_ - 1 - 1] + (*alpha_) * temp2_;
        kk_ = kk_ + j_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        ix_ = kx_;
        iy_ = ky_;
        for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + ap_[k_ - 1] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * ap_[kk_ + j_ - 1 - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * ap_[kk_ - 1];
        k_ = kk_ + 1;
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + ap_[k_ - 1] * x_[i_ - 1];
          k_ = k_ + 1;
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
        kk_ = kk_ + ((*n_) - j_ + 1);
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * ap_[kk_ - 1];
        ix_ = jx_;
        iy_ = jy_;
        for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + ap_[k_ - 1] * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + ((*n_) - j_ + 1);
      }
    }
  }
  _l0:;
  __calls[95].calls++;
  return 0;
}
int_4 _sspr2 (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ y_, int_4 _p_ 
incy_, real_4 _p_ ap_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kk_, kx_, ky_;
  static real_4 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_60, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if (((*incx_) != 1) || ((*incy_) != 1)) {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*n_) - 1) * (*incx_);
    }
    if ((*incy_) > 0) {
      ky_ = 1;
    }
    else {
      ky_ = 1 - ((*n_) - 1) * (*incy_);
    }
    jx_ = kx_;
    jy_ = ky_;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != 0.0) || (y_[j_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[j_ - 1];
          temp2_ = (*alpha_) * x_[j_ - 1];
          k_ = kk_;
          for (i_ = 1; i_ <= j_; (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
            k_ = k_ + 1;
          }
        }
        kk_ = kk_ + j_;
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != 0.0) || (y_[jy_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[jy_ - 1];
          temp2_ = (*alpha_) * x_[jx_ - 1];
          ix_ = kx_;
          iy_ = ky_;
          for (k_ = kk_; k_ <= kk_ + j_ - 1; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != 0.0) || (y_[j_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[j_ - 1];
          temp2_ = (*alpha_) * x_[j_ - 1];
          k_ = kk_;
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
            k_ = k_ + 1;
          }
        }
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != 0.0) || (y_[jy_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[jy_ - 1];
          temp2_ = (*alpha_) * x_[jx_ - 1];
          ix_ = jx_;
          iy_ = jy_;
          for (k_ = kk_; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
  }
  _l0:;
  __calls[96].calls++;
  return 0;
}

int_4 _sspr (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ ap_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_61, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[j_ - 1];
          k_ = kk_;
          for (i_ = 1; i_ <= j_; (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp_;
            k_ = k_ + 1;
          }
        }
        kk_ = kk_ + j_;
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          ix_ = kx_;
          for (k_ = kk_; k_ <= kk_ + j_ - 1; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
        }
        jx_ = jx_ + (*incx_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[j_ - 1];
          k_ = kk_;
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp_;
            k_ = k_ + 1;
          }
        }
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          ix_ = jx_;
          for (k_ = kk_; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
        }
        jx_ = jx_ + (*incx_);
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
  }
  _l0:;
  __calls[97].calls++;
  return 0;
}

int_4 _sswap (int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ incx_, real_4 _p_ sy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_, m_, mp1_;
  static real_4 stemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = sx_[ix_ - 1];
    sx_[ix_ - 1] = sy_[iy_ - 1];
    sy_[iy_ - 1] = stemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  m_ = _imod ((*n_), 3);
  if (m_ == 0) {
    goto _l40;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    stemp_ = sx_[i_ - 1];
    sx_[i_ - 1] = sy_[i_ - 1];
    sy_[i_ - 1] = stemp_;
  }
  if ((*n_) < 3) {
    goto _l0;
  }
  _l40:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; (3 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 3) {
    stemp_ = sx_[i_ - 1];
    sx_[i_ - 1] = sy_[i_ - 1];
    sy_[i_ - 1] = stemp_;
    stemp_ = sx_[i_ + 1 - 1];
    sx_[i_ + 1 - 1] = sy_[i_ + 1 - 1];
    sy_[i_ + 1 - 1] = stemp_;
    stemp_ = sx_[i_ + 2 - 1];
    sx_[i_ + 2 - 1] = sy_[i_ + 2 - 1];
    sy_[i_ + 2 - 1] = stemp_;
  }
  _l0:;
  __calls[98].calls++;
  return 0;
}

int_4 _ssymm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ 
lda_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ beta_, real_4 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 upper_;
  static real_4 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (side_, _dc_9)) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (_lsame (side_, _dc_9))) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_62, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if ((*beta_) == 0.0) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (_lsame (side_, _dc_9)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = 0.0;
          for (k_ = 1; k_ <= i_ - 1; (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((i_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[i_ - 1 + ((*lda_)) * 
            ((i_ - 1))] + (*alpha_) * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = (*m_); i_ >= 1; (i_)--) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = 0.0;
          for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((i_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[i_ - 1 + ((*lda_)) * 
            ((i_ - 1))] + (*alpha_) * temp2_;
          }
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      else {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
      }
      for (k_ = 1; k_ <= j_ - 1; (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
      for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
    }
  }
  _l0:;
  __calls[99].calls++;
  return 0;
}

int_4 _ssymv (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ x_, int_4 _p_ 
incx_, real_4 _p_ beta_, real_4 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_;
  static real_4 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 5;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  else if ((*incy_) == 0) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_63, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == 0.0) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != 1.0) {
    if ((*incy_) == 1) {
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = 0.0;
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == 0.0) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = 0.0;
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == 0.0) {
    goto _l0;
  }
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        ix_ = kx_;
        iy_ = ky_;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = 0.0;
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = 0.0;
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
        ix_ = jx_;
        iy_ = jy_;
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[100].calls++;
  return 0;
}

int_4 _ssyr2 (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ y_, int_4 _p_ 
incy_, real_4 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_;
  static real_4 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_64, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if (((*incx_) != 1) || ((*incy_) != 1)) {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*n_) - 1) * (*incx_);
    }
    if ((*incy_) > 0) {
      ky_ = 1;
    }
    else {
      ky_ = 1 - ((*n_) - 1) * (*incy_);
    }
    jx_ = kx_;
    jy_ = ky_;
  }
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != 0.0) || (y_[j_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[j_ - 1];
          temp2_ = (*alpha_) * x_[j_ - 1];
          for (i_ = 1; i_ <= j_; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != 0.0) || (y_[jy_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[jy_ - 1];
          temp2_ = (*alpha_) * x_[jx_ - 1];
          ix_ = kx_;
          iy_ = ky_;
          for (i_ = 1; i_ <= j_; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_
            ;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != 0.0) || (y_[j_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[j_ - 1];
          temp2_ = (*alpha_) * x_[j_ - 1];
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != 0.0) || (y_[jy_ - 1] != 0.0)) {
          temp1_ = (*alpha_) * y_[jy_ - 1];
          temp2_ = (*alpha_) * x_[jx_ - 1];
          ix_ = jx_;
          iy_ = jy_;
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_
            ;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[101].calls++;
  return 0;
}

int_4 _ssyr2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ 
lda_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ beta_, real_4 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static real_4 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_1))) && (! (_lsame (trans_, _dc_2)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_65, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == 0.0) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if (upper_) {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != 0.0) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0)) {
            temp1_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            temp2_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= j_; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != 0.0) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0)) {
            temp1_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            temp2_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = j_; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp1_ = 0.0;
          temp2_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + (*alpha_) * 
            temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp1_ = 0.0;
          temp2_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + (*alpha_) * 
            temp2_;
          }
        }
      }
    }
  }
  _l0:;
  __calls[102].calls++;
  return 0;
}

int_4 _ssyr (char _p_ uplo_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ a_, int_4 _p_ 
lda_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_66, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == 0.0)) {
    goto _l0;
  }
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (uplo_, _dc_8)) {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[j_ - 1];
          for (i_ = 1; i_ <= j_; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
          }
        }
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          ix_ = kx_;
          for (i_ = 1; i_ <= j_; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  else {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[j_ - 1];
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
          }
        }
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != 0.0) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          ix_ = jx_;
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  _l0:;
  __calls[103].calls++;
  return 0;
}

int_4 _ssyrk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ alpha_, real_4 _p_ a_, int_4 _p_ 
lda_, real_4 _p_ beta_, real_4 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_1))) && (! (_lsame (trans_, _dc_2)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_67, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == 0.0) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if (upper_) {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != 0.0) {
            temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= j_; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != 0.0) {
            temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = j_; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[104].calls++;
  return 0;
}

int_4 _stbmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ a_, int_4 _p_ 
lda_, real_4 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kplus1_, kx_, l_;
  static logical_4 nounit_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 7;
  }
  else if ((*incx_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_68, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            l_ = kplus1_ - j_;
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            l_ = kplus1_ - j_;
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
          if (j_ > (*k_)) {
            kx_ = kx_ + (*incx_);
          }
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            l_ = 1 - j_;
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            l_ = 1 - j_;
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
          if (((*n_) - j_) >= (*k_)) {
            kx_ = kx_ - (*incx_);
          }
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          l_ = kplus1_ - j_;
          if (nounit_) {
            temp_ = temp_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
            temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          kx_ = kx_ - (*incx_);
          ix_ = kx_;
          l_ = kplus1_ - j_;
          if (nounit_) {
            temp_ = temp_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
            temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ - (*incx_);
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          l_ = 1 - j_;
          if (nounit_) {
            temp_ = temp_ * a_[0 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
            temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          kx_ = kx_ + (*incx_);
          ix_ = kx_;
          l_ = 1 - j_;
          if (nounit_) {
            temp_ = temp_ * a_[0 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
            temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[105].calls++;
  return 0;
}

int_4 _stbsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ a_, int_4 _p_ 
lda_, real_4 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kplus1_, kx_, l_;
  static logical_4 nounit_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 7;
  }
  else if ((*incx_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_69, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            l_ = kplus1_ - j_;
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          kx_ = kx_ - (*incx_);
          if (x_[jx_ - 1] != 0.0) {
            ix_ = kx_;
            l_ = kplus1_ - j_;
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            l_ = 1 - j_;
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          kx_ = kx_ + (*incx_);
          if (x_[jx_ - 1] != 0.0) {
            ix_ = kx_;
            l_ = 1 - j_;
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          l_ = kplus1_ - j_;
          for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          if (nounit_) {
            temp_ = temp_ / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          l_ = kplus1_ - j_;
          for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          if (j_ > (*k_)) {
            kx_ = kx_ + (*incx_);
          }
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          l_ = 1 - j_;
          for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          if (nounit_) {
            temp_ = temp_ / a_[0 + ((*lda_)) * ((j_ - 1))];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          l_ = 1 - j_;
          for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ - (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / a_[0 + ((*lda_)) * ((j_ - 1))];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          if (((*n_) - j_) >= (*k_)) {
            kx_ = kx_ - (*incx_);
          }
        }
      }
    }
  }
  _l0:;
  __calls[106].calls++;
  return 0;
}

int_4 _stpmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_4 _p_ ap_, real_4 _p_ x_, int_4 _p_ 
incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static logical_4 nounit_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_70, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            k_ = kk_;
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * ap_[k_ - 1];
              k_ = k_ + 1;
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * ap_[kk_ + j_ - 1 - 1];
            }
          }
          kk_ = kk_ + j_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * ap_[k_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * ap_[kk_ + j_ - 1 - 1];
            }
          }
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + j_;
        }
      }
    }
    else {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            k_ = kk_;
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * ap_[k_ - 1];
              k_ = k_ - 1;
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * ap_[k_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          if (nounit_) {
            temp_ = temp_ * ap_[kk_ - 1];
          }
          k_ = kk_ - 1;
          for (i_ = j_ - 1; i_ >= 1; (i_)--) {
            temp_ = temp_ + ap_[k_ - 1] * x_[i_ - 1];
            k_ = k_ - 1;
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ - j_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (nounit_) {
            temp_ = temp_ * ap_[kk_ - 1];
          }
          for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
            ix_ = ix_ - (*incx_);
            temp_ = temp_ + ap_[k_ - 1] * x_[ix_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - j_;
        }
      }
    }
    else {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          if (nounit_) {
            temp_ = temp_ * ap_[kk_ - 1];
          }
          k_ = kk_ + 1;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            temp_ = temp_ + ap_[k_ - 1] * x_[i_ - 1];
            k_ = k_ + 1;
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (nounit_) {
            temp_ = temp_ * ap_[kk_ - 1];
          }
          for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ix_ = ix_ + (*incx_);
            temp_ = temp_ + ap_[k_ - 1] * x_[ix_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
    }
  }
  _l0:;
  __calls[107].calls++;
  return 0;
}

int_4 _stpsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_4 _p_ ap_, real_4 _p_ x_, int_4 _p_ 
incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static logical_4 nounit_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_71, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[j_ - 1];
            k_ = kk_ - 1;
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * ap_[k_ - 1];
              k_ = k_ - 1;
            }
          }
          kk_ = kk_ - j_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
              ix_ = ix_ - (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * ap_[k_ - 1];
            }
          }
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - j_;
        }
      }
    }
    else {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[j_ - 1];
            k_ = kk_ + 1;
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * ap_[k_ - 1];
              k_ = k_ + 1;
            }
          }
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
              ix_ = ix_ + (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * ap_[k_ - 1];
            }
          }
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          k_ = kk_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - ap_[k_ - 1] * x_[i_ - 1];
            k_ = k_ + 1;
          }
          if (nounit_) {
            temp_ = temp_ / ap_[kk_ + j_ - 1 - 1];
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ + j_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
            temp_ = temp_ - ap_[k_ - 1] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / ap_[kk_ + j_ - 1 - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + j_;
        }
      }
    }
    else {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          k_ = kk_;
          for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - ap_[k_ - 1] * x_[i_ - 1];
            k_ = k_ - 1;
          }
          if (nounit_) {
            temp_ = temp_ / ap_[kk_ - (*n_) + j_ - 1];
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
            temp_ = temp_ - ap_[k_ - 1] * x_[ix_ - 1];
            ix_ = ix_ - (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / ap_[kk_ - (*n_) + j_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
    }
  }
  _l0:;
  __calls[108].calls++;
  return 0;
}

int_4 _strmm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ 
alpha_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 lside_, nounit_, upper_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  lside_ = _lsame (side_, _dc_9);
  if (lside_) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  nounit_ = _lsame (diag_, _dc_0);
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (lside_)) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((! (_lsame (transa_, _dc_0))) && (! (_lsame (transa_, _dc_1))) && (! (_lsame (transa_, _dc_2)))) {
    info_ = 3;
  }
  else if ((! (_lsame (diag_, _dc_8))) && (! (_lsame (diag_, _dc_0)))) {
    info_ = 4;
  }
  else if ((*m_) < 0) {
    info_ = 5;
  }
  else if ((*n_) < 0) {
    info_ = 6;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_72, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = 0.0;
      }
    }
    goto _l0;
  }
  if (lside_) {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (k_ = 1; k_ <= (*m_); (k_)++) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
              temp_ = (*alpha_) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= k_ - 1; (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))]
                ;
              }
              if (nounit_) {
                temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (k_ = (*m_); k_ >= 1; (k_)--) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
              temp_ = (*alpha_) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = k_ + 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = (*m_); i_ >= 1; (i_)--) {
            temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (nounit_) {
              temp_ = temp_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
            for (k_ = 1; k_ <= i_ - 1; (k_)++) {
              temp_ = temp_ + a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (nounit_) {
              temp_ = temp_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
            for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
              temp_ = temp_ + a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
        }
      }
    }
  }
  else {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          for (k_ = 1; k_ <= j_ - 1; (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != 0.0) {
              temp_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != 0.0) {
              temp_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (k_ = 1; k_ <= (*n_); (k_)++) {
          for (j_ = 1; j_ <= k_ - 1; (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
              temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
          }
          if (temp_ != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
      else {
        for (k_ = (*n_); k_ >= 1; (k_)--) {
          for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
              temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
          }
          if (temp_ != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[109].calls++;
  return 0;
}

int_4 _strmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ 
x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static logical_4 nounit_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_73, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            temp_ = x_[j_ - 1];
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ - 1; i_ >= 1; (i_)--) {
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ - 1; i_ >= 1; (i_)--) {
            ix_ = ix_ - (*incx_);
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ix_ = ix_ + (*incx_);
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[110].calls++;
  return 0;
}

int_4 _strsm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ 
alpha_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 lside_, nounit_, upper_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  lside_ = _lsame (side_, _dc_9);
  if (lside_) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  nounit_ = _lsame (diag_, _dc_0);
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (lside_)) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((! (_lsame (transa_, _dc_0))) && (! (_lsame (transa_, _dc_1))) && (! (_lsame (transa_, _dc_2)))) {
    info_ = 3;
  }
  else if ((! (_lsame (diag_, _dc_8))) && (! (_lsame (diag_, _dc_0)))) {
    info_ = 4;
  }
  else if ((*m_) < 0) {
    info_ = 5;
  }
  else if ((*n_) < 0) {
    info_ = 6;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_74, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = 0.0;
      }
    }
    goto _l0;
  }
  if (lside_) {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = (*m_); k_ >= 1; (k_)--) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = 1; i_ <= k_ - 1; (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[i_ 
                - 1 + ((*lda_)) * ((k_ - 1))];
              }
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = 1; k_ <= (*m_); (k_)++) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != 0.0) {
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = k_ + 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[i_ 
                - 1 + ((*lda_)) * ((k_ - 1))];
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            for (k_ = 1; k_ <= i_ - 1; (k_)++) {
              temp_ = temp_ - a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
            if (nounit_) {
              temp_ = temp_ / a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = (*m_); i_ >= 1; (i_)--) {
            temp_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
              temp_ = temp_ - a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
            if (nounit_) {
              temp_ = temp_ / a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
          }
        }
      }
    }
  }
  else {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = 1; k_ <= j_ - 1; (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != 0.0) {
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] * b_[i_ 
                - 1 + ((*ldb_)) * ((k_ - 1))];
              }
            }
          }
          if (nounit_) {
            temp_ = 1.0 / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != 0.0) {
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] * b_[i_ 
                - 1 + ((*ldb_)) * ((k_ - 1))];
              }
            }
          }
          if (nounit_) {
            temp_ = 1.0 / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (k_ = (*n_); k_ >= 1; (k_)--) {
          if (nounit_) {
            temp_ = 1.0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
          for (j_ = 1; j_ <= k_ - 1; (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
      else {
        for (k_ = 1; k_ <= (*n_); (k_)++) {
          if (nounit_) {
            temp_ = 1.0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
          for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          if ((*alpha_) != 1.0) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[111].calls++;
  return 0;
}

int_4 _strsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ 
x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static logical_4 nounit_;
  static real_4 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_75, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != 0.0) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != 0.0) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              ix_ = ix_ - (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != 0.0) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != 0.0) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              ix_ = ix_ + (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          if (nounit_) {
            temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
          if (nounit_) {
            temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
            temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ - (*incx_);
          }
          if (nounit_) {
            temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[112].calls++;
  return 0;
}

int_4 _zaxpy (int_4 _p_ n_, complex_16 _p_ za_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ 
incy_)
{
  static int_4 i_, ix_, iy_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if (_dcabs1 (za_) == 0.0e0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zy_[iy_ - 1] = zy_[iy_ - 1] + (*za_) * zx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zy_[i_ - 1] = zy_[i_ - 1] + (*za_) * zx_[i_ - 1];
  }
  _l0:;
  __calls[113].calls++;
  return 0;
}

int_4 _zcopy (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zy_[iy_ - 1] = zx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zy_[i_ - 1] = zx_[i_ - 1];
  }
  _l0:;
  __calls[114].calls++;
  return 0;
}

complex_16 _zdotc (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  static complex_16 ztemp_;
  complex_16 zdotc_;
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  ztemp_ = CMPLX (0.0, 0.0);
  zdotc_ = CMPLX (0.0, 0.0);
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ztemp_ = ztemp_ + __dconjg (&zx_[ix_ - 1]) * zy_[iy_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  zdotc_ = ztemp_;
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ztemp_ = ztemp_ + __dconjg (&zx_[i_ - 1]) * zy_[i_ - 1];
  }
  zdotc_ = ztemp_;
  _l0:;
  __calls[115].calls++;
  return zdotc_;
}

complex_16 _zdotu (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  static complex_16 ztemp_;
  complex_16 zdotu_;
  ztemp_ = CMPLX (0.0, 0.0);
  zdotu_ = CMPLX (0.0, 0.0);
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ztemp_ = ztemp_ + zx_[ix_ - 1] * zy_[iy_ - 1];
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  zdotu_ = ztemp_;
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ztemp_ = ztemp_ + zx_[i_ - 1] * zy_[i_ - 1];
  }
  zdotu_ = ztemp_;
  _l0:;
  __calls[116].calls++;
  return zdotu_;
}

int_4 _zdrot (int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ incx_, complex_16 _p_ cy_, int_4 _p_ incy_, real_8 _p_ c_, 
real_8 _p_ s_)
{
  static int_4 i_, ix_, iy_;
  static complex_16 ctemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = (*c_) * cx_[ix_ - 1] + (*s_) * cy_[iy_ - 1];
    cy_[iy_ - 1] = (*c_) * cy_[iy_ - 1] - (*s_) * cx_[ix_ - 1];
    cx_[ix_ - 1] = ctemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ctemp_ = (*c_) * cx_[i_ - 1] + (*s_) * cy_[i_ - 1];
    cy_[i_ - 1] = (*c_) * cy_[i_ - 1] - (*s_) * cx_[i_ - 1];
    cx_[i_ - 1] = ctemp_;
  }
  _l0:;
  __calls[117].calls++;
  return 0;
}

int_4 _zdscal (int_4 _p_ n_, real_8 _p_ da_, complex_16 _p_ zx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zx_[ix_ - 1] = CMPLX ((*da_), 0.0) * zx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zx_[i_ - 1] = CMPLX ((*da_), 0.0) * zx_[i_ - 1];
  }
  _l0:;
  __calls[118].calls++;
  return 0;
}

int_4 _zgbmv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_16 _p_ alpha_, 
complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 
_p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kup1_, kx_, ky_, lenx_, leny_;
  static logical_4 noconj_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 1;
  }
  else if ((*m_) < 0) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*kl_) < 0) {
    info_ = 4;
  }
  else if ((*ku_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*kl_) + (*ku_) + 1)) {
    info_ = 8;
  }
  else if ((*incx_) == 0) {
    info_ = 10;
  }
  else if ((*incy_) == 0) {
    info_ = 13;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_76, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == CMPLX (0.0, 0.0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  if (_lsame (trans_, _dc_0)) {
    lenx_ = (*n_);
    leny_ = (*m_);
  }
  else {
    lenx_ = (*m_);
    leny_ = (*n_);
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - (lenx_ - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - (leny_ - 1) * (*incy_);
  }
  if ((*beta_) != CMPLX (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = CMPLX (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = CMPLX (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    goto _l0;
  }
  kup1_ = (*ku_) + 1;
  if (_lsame (trans_, _dc_0)) {
    jx_ = kx_;
    if ((*incy_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          k_ = kup1_ - j_;
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            y_[i_ - 1] = y_[i_ - 1] + temp_ * a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          iy_ = ky_;
          k_ = kup1_ - j_;
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            y_[iy_ - 1] = y_[iy_ - 1] + temp_ * a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
        if (j_ > (*ku_)) {
          ky_ = ky_ + (*incy_);
        }
      }
    }
  }
  else {
    jy_ = ky_;
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = CMPLX (0.0, 0.0);
        k_ = kup1_ - j_;
        if (noconj_) {
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            temp_ = temp_ + a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
        }
        else {
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            temp_ = temp_ + __dconjg (&a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
          }
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = CMPLX (0.0, 0.0);
        ix_ = kx_;
        k_ = kup1_ - j_;
        if (noconj_) {
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            temp_ = temp_ + a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
        }
        else {
          for (i_ = _max (1, j_ - (*ku_)); i_ <= _min ((*m_), j_ + (*kl_)); (i_)++) {
            temp_ = temp_ + __dconjg (&a_[k_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
        if (j_ > (*ku_)) {
          kx_ = kx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[119].calls++;
  return 0;
}

int_4 _zgemm (char _p_ transa_, char _p_ transb_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, 
complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 
_p_ ldc_)
{
  static int_4 i_, info_, j_, l_, ncola_, nrowa_, nrowb_;
  static logical_4 conja_, conjb_, nota_, notb_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  nota_ = _lsame (transa_, _dc_0);
  notb_ = _lsame (transb_, _dc_0);
  conja_ = _lsame (transa_, _dc_2);
  conjb_ = _lsame (transb_, _dc_2);
  if (nota_) {
    nrowa_ = (*m_);
    ncola_ = (*k_);
  }
  else {
    nrowa_ = (*k_);
    ncola_ = (*m_);
  }
  if (notb_) {
    nrowb_ = (*k_);
  }
  else {
    nrowb_ = (*n_);
  }
  info_ = 0;
  if ((! (nota_)) && (! (conja_)) && (! (_lsame (transa_, _dc_1)))) {
    info_ = 1;
  }
  else if ((! (notb_)) && (! (conjb_)) && (! (_lsame (transb_, _dc_1)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 8;
  }
  else if ((*ldb_) < _max (1, nrowb_)) {
    info_ = 10;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 13;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_77, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((((*alpha_) == CMPLX (0.0, 0.0)) || ((*k_) == 0)) && ((*beta_) == CMPLX (1.0, 
    0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    if ((*beta_) == CMPLX (0.0, 0.0)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (notb_) {
    if (nota_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLX (0.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLX (1.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
            temp_ = (*alpha_) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else if (conja_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  else if (nota_) {
    if (conjb_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLX (0.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLX (1.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLX (0.0, 0.0)) {
            temp_ = (*alpha_) * __dconjg (&b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLX (0.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLX (1.0, 0.0)) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLX (0.0, 0.0)) {
            temp_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
  }
  else if (conja_) {
    if (conjb_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * __dconjg (&b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  else {
    if (conjb_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * __dconjg (&b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[120].calls++;
  return 0;
}

int_4 _zgemv (char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ a_, int_4 _p_ lda_, 
complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_, lenx_, leny_;
  static logical_4 noconj_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 1;
  }
  else if ((*m_) < 0) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  else if ((*incy_) == 0) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_78, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == CMPLX (0.0, 0.0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  if (_lsame (trans_, _dc_0)) {
    lenx_ = (*n_);
    leny_ = (*m_);
  }
  else {
    lenx_ = (*m_);
    leny_ = (*n_);
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - (lenx_ - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - (leny_ - 1) * (*incy_);
  }
  if ((*beta_) != CMPLX (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = CMPLX (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = CMPLX (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= leny_; (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    jx_ = kx_;
    if ((*incy_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            y_[i_ - 1] = y_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * x_[jx_ - 1];
          iy_ = ky_;
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            y_[iy_ - 1] = y_[iy_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            iy_ = iy_ + (*incy_);
          }
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  else {
    jy_ = ky_;
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = CMPLX (0.0, 0.0);
        if (noconj_) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
          }
        }
        else {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = temp_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
          }
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp_ = CMPLX (0.0, 0.0);
        ix_ = kx_;
        if (noconj_) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
        }
        else {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = temp_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
            ix_ = ix_ + (*incx_);
          }
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp_;
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[121].calls++;
  return 0;
}

int_4 _zgerc (int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ y_, 
int_4 _p_ incy_, complex_16 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, j_, jy_, kx_;
  static complex_16 temp_;
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if ((*m_) < 0) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_79, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((*alpha_) == CMPLX (0.0, 0.0))) {
    goto _l0;
  }
  if ((*incy_) > 0) {
    jy_ = 1;
  }
  else {
    jy_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*incx_) == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != CMPLX (0.0, 0.0)) {
        temp_ = (*alpha_) * __dconjg (&y_[jy_ - 1]);
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  else {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*m_) - 1) * (*incx_);
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != CMPLX (0.0, 0.0)) {
        temp_ = (*alpha_) * __dconjg (&y_[jy_ - 1]);
        ix_ = kx_;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
          ix_ = ix_ + (*incx_);
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  _l0:;
  __calls[122].calls++;
  return 0;
}

int_4 _zgeru (int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ y_, 
int_4 _p_ incy_, complex_16 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, j_, jy_, kx_;
  static complex_16 temp_;
  extern int_4 _xerbla ();
  info_ = 0;
  if ((*m_) < 0) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_80, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || ((*alpha_) == CMPLX (0.0, 0.0))) {
    goto _l0;
  }
  if ((*incy_) > 0) {
    jy_ = 1;
  }
  else {
    jy_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*incx_) == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != CMPLX (0.0, 0.0)) {
        temp_ = (*alpha_) * y_[jy_ - 1];
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  else {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*m_) - 1) * (*incx_);
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (y_[jy_ - 1] != CMPLX (0.0, 0.0)) {
        temp_ = (*alpha_) * y_[jy_ - 1];
        ix_ = kx_;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
          ix_ = ix_ + (*incx_);
        }
      }
      jy_ = jy_ + (*incy_);
    }
  }
  _l0:;
  __calls[123].calls++;
  return 0;
}

int_4 _zhbmv (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, complex_16 _p_ a_, int_4 _p_ lda_, 
complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kplus1_, kx_, ky_, l_;
  static complex_16 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*k_) < 0) {
    info_ = 3;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  else if ((*incy_) == 0) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_81, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == CMPLX (0.0, 0.0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != CMPLX (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = CMPLX (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = CMPLX (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    goto _l0;
  }
  if (_lsame (uplo_, _dc_8)) {
    kplus1_ = (*k_) + 1;
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        l_ = kplus1_ - j_;
        for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_8) (creal (a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))])) + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        ix_ = kx_;
        iy_ = ky_;
        l_ = kplus1_ - j_;
        for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_8) (creal (a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))])) + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        if (j_ > (*k_)) {
          kx_ = kx_ + (*incx_);
          ky_ = ky_ + (*incy_);
        }
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_8) (creal (a_[0 + ((*lda_)) * ((j_ - 1))]));
        l_ = 1 - j_;
        for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_8) (creal (a_[0 + ((*lda_)) * ((j_ - 1))]));
        l_ = 1 - j_;
        ix_ = jx_;
        iy_ = jy_;
        for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[124].calls++;
  return 0;
}

int_4 _zhemm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 upper_;
  static complex_16 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  if (_lsame (side_, _dc_9)) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (_lsame (side_, _dc_9))) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_82, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == CMPLX (0.0, 0.0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    if ((*beta_) == CMPLX (0.0, 0.0)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (_lsame (side_, _dc_9)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = CMPLX (0.0, 0.0);
          for (k_ = 1; k_ <= i_ - 1; (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * __dconjg (&a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]);
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * (real_8) (creal (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))])) + (*alpha_) * 
            temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * (real_8) (creal (a_[i_ 
            - 1 + ((*lda_)) * ((i_ - 1))])) + (*alpha_) * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = (*m_); i_ >= 1; (i_)--) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = CMPLX (0.0, 0.0);
          for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * __dconjg (&a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]);
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * (real_8) (creal (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))])) + (*alpha_) * 
            temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * (real_8) (creal (a_[i_ 
            - 1 + ((*lda_)) * ((i_ - 1))])) + (*alpha_) * temp2_;
          }
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      temp1_ = (*alpha_) * (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      else {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
      }
      for (k_ = 1; k_ <= j_ - 1; (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
      for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
        }
        else {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
    }
  }
  _l0:;
  __calls[125].calls++;
  return 0;
}

int_4 _zhemv (char _p_ uplo_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ x_
, int_4 _p_ incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_;
  static complex_16 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 5;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  else if ((*incy_) == 0) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_83, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == CMPLX (0.0, 0.0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != CMPLX (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = CMPLX (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = CMPLX (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    goto _l0;
  }
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        ix_ = kx_;
        iy_ = ky_;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        ix_ = jx_;
        iy_ = jy_;
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
          temp2_ = temp2_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[126].calls++;
  return 0;
}

int_4 _zher2 (char _p_ uplo_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ 
y_, int_4 _p_ incy_, complex_16 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, kx_, ky_;
  static complex_16 temp1_, temp2_;
  complex_16 $0_, $1_, $2_, $3_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_84, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == CMPLX (0.0, 0.0))) {
    goto _l0;
  }
  if (((*incx_) != 1) || ((*incy_) != 1)) {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*n_) - 1) * (*incx_);
    }
    if ((*incy_) > 0) {
      ky_ = 1;
    }
    else {
      ky_ = 1 - ((*n_) - 1) * (*incy_);
    }
    jx_ = kx_;
    jy_ = ky_;
  }
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != CMPLX (0.0, 0.0)) || (y_[j_ - 1] != CMPLX (0.0, 0.0))) {
          temp1_ = (*alpha_) * __dconjg (&y_[j_ - 1]);
          temp2_ = __dconjg (($0_ = (*alpha_) * x_[j_ - 1], &$0_));
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
          }
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_8) (creal (x_[j_ - 
          1] * temp1_ + y_[j_ - 1] * temp2_));
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != CMPLX (0.0, 0.0)) || (y_[jy_ - 1] != CMPLX (0.0, 0.0))) {
          temp1_ = (*alpha_) * __dconjg (&y_[jy_ - 1]);
          temp2_ = __dconjg (($1_ = (*alpha_) * x_[jx_ - 1], &$1_));
          ix_ = kx_;
          iy_ = ky_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_
            ;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_8) (creal (x_[jx_ 
          - 1] * temp1_ + y_[jy_ - 1] * temp2_));
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != CMPLX (0.0, 0.0)) || (y_[j_ - 1] != CMPLX (0.0, 0.0))) {
          temp1_ = (*alpha_) * __dconjg (&y_[j_ - 1]);
          temp2_ = __dconjg (($2_ = (*alpha_) * x_[j_ - 1], &$2_));
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_8) (creal (x_[j_ - 
          1] * temp1_ + y_[j_ - 1] * temp2_));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
          }
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != CMPLX (0.0, 0.0)) || (y_[jy_ - 1] != CMPLX (0.0, 0.0))) {
          temp1_ = (*alpha_) * __dconjg (&y_[jy_ - 1]);
          temp2_ = __dconjg (($3_ = (*alpha_) * x_[jx_ - 1], &$3_));
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_8) (creal (x_[jx_ 
          - 1] * temp1_ + y_[jy_ - 1] * temp2_));
          ix_ = jx_;
          iy_ = jy_;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_
            ;
          }
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
      }
    }
  }
  _l0:;
  __calls[127].calls++;
  return 0;
}

int_4 _zher2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, real_8 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static complex_16 temp1_, temp2_;
  complex_16 $0_, $1_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_2)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_85, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == CMPLX (0.0, 0.0)) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    if (upper_) {
      if ((*beta_) == (real_8) (creal (CMPLX (0.0, 0.0)))) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      if ((*beta_) == (real_8) (creal (CMPLX (0.0, 0.0)))) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == (real_8) (creal (CMPLX (0.0, 0.0)))) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLX (0.0, 0.0)) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLX (0.0, 
            0.0))) {
            temp1_ = (*alpha_) * __dconjg (&b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
            temp2_ = __dconjg (($0_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))], &$0_));
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
            c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_8) (creal (a_[j_ - 
            1 + ((*lda_)) * ((l_ - 1))] * temp1_ + b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_));
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == (real_8) (creal (CMPLX (0.0, 0.0)))) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLX (0.0, 0.0)) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLX (0.0, 
            0.0))) {
            temp1_ = (*alpha_) * __dconjg (&b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))]);
            temp2_ = __dconjg (($1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))], &$1_));
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
            c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_8) (creal (a_[j_ - 
            1 + ((*lda_)) * ((l_ - 1))] * temp1_ + b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_));
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp1_ = CMPLX (0.0, 0.0);
          temp2_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + __dconjg (&b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if (i_ == j_) {
            if ((*beta_) == (real_8) (creal (CMPLX (0.0, 0.0)))) {
              c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal ((*alpha_) * temp1_ + __dconjg (alpha_) * temp2_));
            }
            else {
              c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_8) 
              (creal ((*alpha_) * temp1_ + __dconjg (alpha_) * temp2_));
            }
          }
          else {
            if ((*beta_) == (real_8) (creal (CMPLX (0.0, 0.0)))) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + __dconjg (alpha_) * temp2_;
            }
            else {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + __dconjg 
              (alpha_) * temp2_;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp1_ = CMPLX (0.0, 0.0);
          temp2_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + __dconjg (&b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if (i_ == j_) {
            if ((*beta_) == (real_8) (creal (CMPLX (0.0, 0.0)))) {
              c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal ((*alpha_) * temp1_ + __dconjg (alpha_) * temp2_));
            }
            else {
              c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_8) 
              (creal ((*alpha_) * temp1_ + __dconjg (alpha_) * temp2_));
            }
          }
          else {
            if ((*beta_) == (real_8) (creal (CMPLX (0.0, 0.0)))) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + __dconjg (alpha_) * temp2_;
            }
            else {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + __dconjg 
              (alpha_) * temp2_;
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[128].calls++;
  return 0;
}

int_4 _zher (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ a_, 
int_4 _p_ lda_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_86, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == (real_8) (creal (CMPLX (0.0, 0.0))))) {
    goto _l0;
  }
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (uplo_, _dc_8)) {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * __dconjg (&x_[j_ - 1]);
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
          }
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_8) (creal (x_[j_ - 
          1] * temp_));
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * __dconjg (&x_[jx_ - 1]);
          ix_ = kx_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_8) (creal (x_[jx_ 
          - 1] * temp_));
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  else {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * __dconjg (&x_[j_ - 1]);
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_8) (creal (temp_ * 
          x_[j_ - 1]));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[i_ - 1] * temp_;
          }
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * __dconjg (&x_[jx_ - 1]);
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) + (real_8) (creal (temp_ * 
          x_[jx_ - 1]));
          ix_ = jx_;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ix_ = ix_ + (*incx_);
            a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + x_[ix_ - 1] * temp_;
          }
        }
        else {
          a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = (real_8) (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]));
        }
        jx_ = jx_ + (*incx_);
      }
    }
  }
  _l0:;
  __calls[129].calls++;
  return 0;
}

int_4 _zherk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ alpha_, complex_16 _p_ a_, int_4 
_p_ lda_, real_8 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static real_8 rtemp_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_2)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_87, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == 0.0) || ((*k_) == 0)) && ((*beta_) == 1.0))) {
    goto _l0;
  }
  if ((*alpha_) == 0.0) {
    if (upper_) {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
      }
    }
    else {
      if ((*beta_) == 0.0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != (complex_16) (0.0)) {
            temp_ = (*alpha_) * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((l_ - 1))]);
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
            c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_8) (creal (temp_ * 
            a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]));
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == 0.0) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = 0.0;
          }
        }
        else if ((*beta_) != 1.0) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))]));
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != (complex_16) (0.0)) {
            temp_ = (*alpha_) * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((l_ - 1))]);
            c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))])) + (real_8) (creal (temp_ * 
            a_[j_ - 1 + ((*lda_)) * ((l_ - 1))]));
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        rtemp_ = 0.0;
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          rtemp_ = (real_8) (creal (rtemp_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((j_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 
          1))]));
        }
        if ((*beta_) == 0.0) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * rtemp_;
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * rtemp_ + (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 
          1))]));
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        rtemp_ = 0.0;
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          rtemp_ = (real_8) (creal (rtemp_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((j_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 
          1))]));
        }
        if ((*beta_) == 0.0) {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * rtemp_;
        }
        else {
          c_[j_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * rtemp_ + (*beta_) * (real_8) (creal (c_[j_ - 1 + ((*ldc_)) * ((j_ - 
          1))]));
        }
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          temp_ = 0.0;
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + __dconjg (&a_[l_ - 1 + ((*lda_)) * ((i_ - 1))]) * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == 0.0) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[130].calls++;
  return 0;
}

int_4 _zhpmv (char _p_ uplo_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ ap_, complex_16 _p_ x_, int_4 _p_ 
incx_, complex_16 _p_ beta_, complex_16 _p_ y_, int_4 _p_ incy_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kk_, kx_, ky_;
  static complex_16 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 6;
  }
  else if ((*incy_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_88, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || (((*alpha_) == CMPLX (0.0, 0.0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    kx_ = 1;
  }
  else {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  if ((*incy_) > 0) {
    ky_ = 1;
  }
  else {
    ky_ = 1 - ((*n_) - 1) * (*incy_);
  }
  if ((*beta_) != CMPLX (1.0, 0.0)) {
    if ((*incy_) == 1) {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = CMPLX (0.0, 0.0);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = (*beta_) * y_[i_ - 1];
        }
      }
    }
    else {
      iy_ = ky_;
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = CMPLX (0.0, 0.0);
          iy_ = iy_ + (*incy_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          y_[iy_ - 1] = (*beta_) * y_[iy_ - 1];
          iy_ = iy_ + (*incy_);
        }
      }
    }
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    goto _l0;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        k_ = kk_;
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + __dconjg (&ap_[k_ - 1]) * x_[i_ - 1];
          k_ = k_ + 1;
        }
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_8) (creal (ap_[kk_ + j_ - 1 - 1])) + (*alpha_) * temp2_;
        kk_ = kk_ + j_;
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        ix_ = kx_;
        iy_ = ky_;
        for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + __dconjg (&ap_[k_ - 1]) * x_[ix_ - 1];
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
        }
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_8) (creal (ap_[kk_ + j_ - 1 - 1])) + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[j_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        y_[j_ - 1] = y_[j_ - 1] + temp1_ * (real_8) (creal (ap_[kk_ - 1]));
        k_ = kk_ + 1;
        for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
          y_[i_ - 1] = y_[i_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + __dconjg (&ap_[k_ - 1]) * x_[i_ - 1];
          k_ = k_ + 1;
        }
        y_[j_ - 1] = y_[j_ - 1] + (*alpha_) * temp2_;
        kk_ = kk_ + ((*n_) - j_ + 1);
      }
    }
    else {
      jx_ = kx_;
      jy_ = ky_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        temp1_ = (*alpha_) * x_[jx_ - 1];
        temp2_ = CMPLX (0.0, 0.0);
        y_[jy_ - 1] = y_[jy_ - 1] + temp1_ * (real_8) (creal (ap_[kk_ - 1]));
        ix_ = jx_;
        iy_ = jy_;
        for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
          ix_ = ix_ + (*incx_);
          iy_ = iy_ + (*incy_);
          y_[iy_ - 1] = y_[iy_ - 1] + temp1_ * ap_[k_ - 1];
          temp2_ = temp2_ + __dconjg (&ap_[k_ - 1]) * x_[ix_ - 1];
        }
        y_[jy_ - 1] = y_[jy_ - 1] + (*alpha_) * temp2_;
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + ((*n_) - j_ + 1);
      }
    }
  }
  _l0:;
  __calls[131].calls++;
  return 0;
}

int_4 _zhpr2 (char _p_ uplo_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ 
y_, int_4 _p_ incy_, complex_16 _p_ ap_)
{
  static int_4 i_, info_, ix_, iy_, j_, jx_, jy_, k_, kk_, kx_, ky_;
  static complex_16 temp1_, temp2_;
  complex_16 $0_, $1_, $2_, $3_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  else if ((*incy_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_89, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == CMPLX (0.0, 0.0))) {
    goto _l0;
  }
  if (((*incx_) != 1) || ((*incy_) != 1)) {
    if ((*incx_) > 0) {
      kx_ = 1;
    }
    else {
      kx_ = 1 - ((*n_) - 1) * (*incx_);
    }
    if ((*incy_) > 0) {
      ky_ = 1;
    }
    else {
      ky_ = 1 - ((*n_) - 1) * (*incy_);
    }
    jx_ = kx_;
    jy_ = ky_;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != CMPLX (0.0, 0.0)) || (y_[j_ - 1] != CMPLX (0.0, 0.0))) {
          temp1_ = (*alpha_) * __dconjg (&y_[j_ - 1]);
          temp2_ = __dconjg (($0_ = (*alpha_) * x_[j_ - 1], &$0_));
          k_ = kk_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
            k_ = k_ + 1;
          }
          ap_[kk_ + j_ - 1 - 1] = (real_8) (creal (ap_[kk_ + j_ - 1 - 1])) + (real_8) (creal (x_[j_ - 1] * temp1_ + y_[j_ - 1] * 
          temp2_));
        }
        else {
          ap_[kk_ + j_ - 1 - 1] = (real_8) (creal (ap_[kk_ + j_ - 1 - 1]));
        }
        kk_ = kk_ + j_;
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != CMPLX (0.0, 0.0)) || (y_[jy_ - 1] != CMPLX (0.0, 0.0))) {
          temp1_ = (*alpha_) * __dconjg (&y_[jy_ - 1]);
          temp2_ = __dconjg (($1_ = (*alpha_) * x_[jx_ - 1], &$1_));
          ix_ = kx_;
          iy_ = ky_;
          for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_;
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
          }
          ap_[kk_ + j_ - 1 - 1] = (real_8) (creal (ap_[kk_ + j_ - 1 - 1])) + (real_8) (creal (x_[jx_ - 1] * temp1_ + y_[jy_ - 1] 
          * temp2_));
        }
        else {
          ap_[kk_ + j_ - 1 - 1] = (real_8) (creal (ap_[kk_ + j_ - 1 - 1]));
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if (((*incx_) == 1) && ((*incy_) == 1)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[j_ - 1] != CMPLX (0.0, 0.0)) || (y_[j_ - 1] != CMPLX (0.0, 0.0))) {
          temp1_ = (*alpha_) * __dconjg (&y_[j_ - 1]);
          temp2_ = __dconjg (($2_ = (*alpha_) * x_[j_ - 1], &$2_));
          ap_[kk_ - 1] = (real_8) (creal (ap_[kk_ - 1])) + (real_8) (creal (x_[j_ - 1] * temp1_ + y_[j_ - 1] * temp2_));
          k_ = kk_ + 1;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp1_ + y_[i_ - 1] * temp2_;
            k_ = k_ + 1;
          }
        }
        else {
          ap_[kk_ - 1] = (real_8) (creal (ap_[kk_ - 1]));
        }
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((x_[jx_ - 1] != CMPLX (0.0, 0.0)) || (y_[jy_ - 1] != CMPLX (0.0, 0.0))) {
          temp1_ = (*alpha_) * __dconjg (&y_[jy_ - 1]);
          temp2_ = __dconjg (($3_ = (*alpha_) * x_[jx_ - 1], &$3_));
          ap_[kk_ - 1] = (real_8) (creal (ap_[kk_ - 1])) + (real_8) (creal (x_[jx_ - 1] * temp1_ + y_[jy_ - 1] * temp2_));
          ix_ = jx_;
          iy_ = jy_;
          for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ix_ = ix_ + (*incx_);
            iy_ = iy_ + (*incy_);
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp1_ + y_[iy_ - 1] * temp2_;
          }
        }
        else {
          ap_[kk_ - 1] = (real_8) (creal (ap_[kk_ - 1]));
        }
        jx_ = jx_ + (*incx_);
        jy_ = jy_ + (*incy_);
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
  }
  _l0:;
  __calls[132].calls++;
  return 0;
}

int_4 _zhpr (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ ap_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if ((*n_) < 0) {
    info_ = 2;
  }
  else if ((*incx_) == 0) {
    info_ = 5;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_90, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((*alpha_) == (real_8) (creal (CMPLX (0.0, 0.0))))) {
    goto _l0;
  }
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  kk_ = 1;
  if (_lsame (uplo_, _dc_8)) {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * __dconjg (&x_[j_ - 1]);
          k_ = kk_;
          for (i_ = 1; i_ <= j_ - 1; (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp_;
            k_ = k_ + 1;
          }
          ap_[kk_ + j_ - 1 - 1] = (real_8) (creal (ap_[kk_ + j_ - 1 - 1])) + (real_8) (creal (x_[j_ - 1] * temp_));
        }
        else {
          ap_[kk_ + j_ - 1 - 1] = (real_8) (creal (ap_[kk_ + j_ - 1 - 1]));
        }
        kk_ = kk_ + j_;
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * __dconjg (&x_[jx_ - 1]);
          ix_ = kx_;
          for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp_;
            ix_ = ix_ + (*incx_);
          }
          ap_[kk_ + j_ - 1 - 1] = (real_8) (creal (ap_[kk_ + j_ - 1 - 1])) + (real_8) (creal (x_[jx_ - 1] * temp_));
        }
        else {
          ap_[kk_ + j_ - 1 - 1] = (real_8) (creal (ap_[kk_ + j_ - 1 - 1]));
        }
        jx_ = jx_ + (*incx_);
        kk_ = kk_ + j_;
      }
    }
  }
  else {
    if ((*incx_) == 1) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * __dconjg (&x_[j_ - 1]);
          ap_[kk_ - 1] = (real_8) (creal (ap_[kk_ - 1])) + (real_8) (creal (temp_ * x_[j_ - 1]));
          k_ = kk_ + 1;
          for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
            ap_[k_ - 1] = ap_[k_ - 1] + x_[i_ - 1] * temp_;
            k_ = k_ + 1;
          }
        }
        else {
          ap_[kk_ - 1] = (real_8) (creal (ap_[kk_ - 1]));
        }
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
    else {
      jx_ = kx_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
          temp_ = (*alpha_) * __dconjg (&x_[jx_ - 1]);
          ap_[kk_ - 1] = (real_8) (creal (ap_[kk_ - 1])) + (real_8) (creal (temp_ * x_[jx_ - 1]));
          ix_ = jx_;
          for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
            ix_ = ix_ + (*incx_);
            ap_[k_ - 1] = ap_[k_ - 1] + x_[ix_ - 1] * temp_;
          }
        }
        else {
          ap_[kk_ - 1] = (real_8) (creal (ap_[kk_ - 1]));
        }
        jx_ = jx_ + (*incx_);
        kk_ = kk_ + (*n_) - j_ + 1;
      }
    }
  }
  _l0:;
  __calls[133].calls++;
  return 0;
}

int_4 _zrotg (complex_16 _p_ ca_, complex_16 _p_ cb_, real_8 _p_ c_, complex_16 _p_ s_)
{
  static real_8 norm_, scale_;
  static complex_16 alpha_;
  real_8 $1_, $3_, $4_;
  complex_16 $0_, $2_;
  extern real_8 _cdabs ();
  extern complex_16 _dconjg ();
  extern real_8 _dsqrt ();
  real_8 __cdabs (complex_16 _p_ __x__) {return cabs (*__x__);}
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  real_8 __dsqrt (real_8 _p_ __x__) {return sqrt (*__x__);}
  if (__cdabs (ca_) != 0.0e0) {
    goto _l10;
  }
  (*c_) = 0.0;
  (*s_) = CMPLX (1.0, 0.0);
  (*ca_) = (*cb_);
  goto _l20;
  _l10:;
  scale_ = __cdabs (ca_) + __cdabs (cb_);
  norm_ = scale_ * __dsqrt (($4_ = ($1_ = (__cdabs (($0_ = (*ca_) / CMPLX (scale_, 0.0), &$0_))), $1_ * $1_) + ($3_ = 
  (__cdabs (($2_ = (*cb_) / CMPLX (scale_, 0.0), &$2_))), $3_ * $3_), &$4_));
  alpha_ = (*ca_) / __cdabs (ca_);
  (*c_) = __cdabs (ca_) / norm_;
  (*s_) = alpha_ * __dconjg (cb_) / norm_;
  (*ca_) = alpha_ * norm_;
  _l20:;
  __calls[134].calls++;
  return 0;
}

int_4 _zscal (int_4 _p_ n_, complex_16 _p_ za_, complex_16 _p_ zx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  if ((*n_) <= 0 || (*incx_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zx_[ix_ - 1] = (*za_) * zx_[ix_ - 1];
    ix_ = ix_ + (*incx_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zx_[i_ - 1] = (*za_) * zx_[i_ - 1];
  }
  _l0:;
  __calls[135].calls++;
  return 0;
}

int_4 _zswap (int_4 _p_ n_, complex_16 _p_ zx_, int_4 _p_ incx_, complex_16 _p_ zy_, int_4 _p_ incy_)
{
  static int_4 i_, ix_, iy_;
  static complex_16 ztemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ztemp_ = zx_[ix_ - 1];
    zx_[ix_ - 1] = zy_[iy_ - 1];
    zy_[iy_ - 1] = ztemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ztemp_ = zx_[i_ - 1];
    zx_[i_ - 1] = zy_[i_ - 1];
    zy_[i_ - 1] = ztemp_;
  }
  _l0:;
  __calls[136].calls++;
  return 0;
}

int_4 _zsymm (char _p_ side_, char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 upper_;
  static complex_16 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (side_, _dc_9)) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (_lsame (side_, _dc_9))) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((*m_) < 0) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_91, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0) || (((*alpha_) == CMPLX (0.0, 0.0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    if ((*beta_) == CMPLX (0.0, 0.0)) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
        }
      }
    }
    goto _l0;
  }
  if (_lsame (side_, _dc_9)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = CMPLX (0.0, 0.0);
          for (k_ = 1; k_ <= i_ - 1; (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((i_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[i_ - 1 + ((*lda_)) * 
            ((i_ - 1))] + (*alpha_) * temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = (*m_); i_ >= 1; (i_)--) {
          temp1_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          temp2_ = CMPLX (0.0, 0.0);
          for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
            c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[k_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[k_ - 1 + ((*lda_)) * ((i_ - 
            1))];
            temp2_ = temp2_ + b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((i_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * a_[i_ - 1 + ((*lda_)) * 
            ((i_ - 1))] + (*alpha_) * temp2_;
          }
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = temp1_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      else {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
      }
      for (k_ = 1; k_ <= j_ - 1; (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
      for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
        if (upper_) {
          temp1_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
        }
        else {
          temp1_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp1_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 
          1))];
        }
      }
    }
  }
  _l0:;
  __calls[137].calls++;
  return 0;
}

int_4 _zsyr2k (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static complex_16 temp1_, temp2_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_1)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldb_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 12;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_92, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == CMPLX (0.0, 0.0)) || ((*k_) == 0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    if (upper_) {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLX (0.0, 0.0)) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLX (1.0, 0.0)) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLX (0.0, 0.0)) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLX (0.0, 
            0.0))) {
            temp1_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            temp2_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= j_; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLX (0.0, 0.0)) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLX (1.0, 0.0)) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if ((a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLX (0.0, 0.0)) || (b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))] != CMPLX (0.0, 
            0.0))) {
            temp1_ = (*alpha_) * b_[j_ - 1 + ((*ldb_)) * ((l_ - 1))];
            temp2_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = j_; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] * 
              temp1_ + b_[i_ - 1 + ((*ldb_)) * ((l_ - 1))] * temp2_;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp1_ = CMPLX (0.0, 0.0);
          temp2_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + (*alpha_) * 
            temp2_;
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp1_ = CMPLX (0.0, 0.0);
          temp2_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp1_ = temp1_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[l_ - 1 + ((*ldb_)) * ((j_ - 1))];
            temp2_ = temp2_ + b_[l_ - 1 + ((*ldb_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp1_ + (*alpha_) * temp2_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + (*alpha_) * temp1_ + (*alpha_) * 
            temp2_;
          }
        }
      }
    }
  }
  _l0:;
  __calls[138].calls++;
  return 0;
}

int_4 _zsyrk (char _p_ uplo_, char _p_ trans_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ alpha_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ beta_, complex_16 _p_ c_, int_4 _p_ ldc_)
{
  static int_4 i_, info_, j_, l_, nrowa_;
  static logical_4 upper_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  if (_lsame (trans_, _dc_0)) {
    nrowa_ = (*n_);
  }
  else {
    nrowa_ = (*k_);
  }
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 1;
  }
  else if ((! (_lsame (trans_, _dc_0))) && (! (_lsame (trans_, _dc_1)))) {
    info_ = 2;
  }
  else if ((*n_) < 0) {
    info_ = 3;
  }
  else if ((*k_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 7;
  }
  else if ((*ldc_) < _max (1, (*n_))) {
    info_ = 10;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_93, &info_);
    goto _l0;
  }
  if (((*n_) == 0) || ((((*alpha_) == CMPLX (0.0, 0.0)) || ((*k_) == 0)) && ((*beta_) == CMPLX (1.0, 0.0)))) {
    goto _l0;
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    if (upper_) {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*beta_) == CMPLX (0.0, 0.0)) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    goto _l0;
  }
  if (_lsame (trans_, _dc_0)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLX (0.0, 0.0)) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLX (1.0, 0.0)) {
          for (i_ = 1; i_ <= j_; (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLX (0.0, 0.0)) {
            temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = 1; i_ <= j_; (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if ((*beta_) == CMPLX (0.0, 0.0)) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        else if ((*beta_) != CMPLX (1.0, 0.0)) {
          for (i_ = j_; i_ <= (*n_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
        for (l_ = 1; l_ <= (*k_); (l_)++) {
          if (a_[j_ - 1 + ((*lda_)) * ((l_ - 1))] != CMPLX (0.0, 0.0)) {
            temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((l_ - 1))];
            for (i_ = j_; i_ <= (*n_); (i_)++) {
              c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((l_ - 1))]
              ;
            }
          }
        }
      }
    }
  }
  else {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= j_; (i_)++) {
          temp_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = j_; i_ <= (*n_); (i_)++) {
          temp_ = CMPLX (0.0, 0.0);
          for (l_ = 1; l_ <= (*k_); (l_)++) {
            temp_ = temp_ + a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          if ((*beta_) == CMPLX (0.0, 0.0)) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
          else {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = (*alpha_) * temp_ + (*beta_) * c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[139].calls++;
  return 0;
}

int_4 _ztbmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ a_, int_4 _p_ 
lda_, complex_16 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kplus1_, kx_, l_;
  static logical_4 noconj_, nounit_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 7;
  }
  else if ((*incx_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_94, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            l_ = kplus1_ - j_;
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            l_ = kplus1_ - j_;
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
          if (j_ > (*k_)) {
            kx_ = kx_ + (*incx_);
          }
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            l_ = 1 - j_;
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            l_ = 1 - j_;
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
          if (((*n_) - j_) >= (*k_)) {
            kx_ = kx_ - (*incx_);
          }
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          l_ = kplus1_ - j_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              temp_ = temp_ + __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          kx_ = kx_ - (*incx_);
          ix_ = kx_;
          l_ = kplus1_ - j_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              temp_ = temp_ + __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          l_ = 1 - j_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&a_[0 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              temp_ = temp_ + __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          kx_ = kx_ + (*incx_);
          ix_ = kx_;
          l_ = 1 - j_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              temp_ = temp_ + a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&a_[0 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              temp_ = temp_ + __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[140].calls++;
  return 0;
}

int_4 _ztbsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ a_, int_4 _p_ 
lda_, complex_16 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kplus1_, kx_, l_;
  static logical_4 noconj_, nounit_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*k_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < ((*k_) + 1)) {
    info_ = 7;
  }
  else if ((*incx_) == 0) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_95, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            l_ = kplus1_ - j_;
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          kx_ = kx_ - (*incx_);
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            ix_ = kx_;
            l_ = kplus1_ - j_;
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            for (i_ = j_ - 1; i_ >= _max (1, j_ - (*k_)); (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            l_ = 1 - j_;
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          kx_ = kx_ + (*incx_);
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            ix_ = kx_;
            l_ = 1 - j_;
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            for (i_ = j_ + 1; i_ <= _min ((*n_), j_ + (*k_)); (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kplus1_ = (*k_) + 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          l_ = kplus1_ - j_;
          if (noconj_) {
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          l_ = kplus1_ - j_;
          if (noconj_) {
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = _max (1, j_ - (*k_)); i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&a_[kplus1_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          if (j_ > (*k_)) {
            kx_ = kx_ + (*incx_);
          }
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          l_ = 1 - j_;
          if (noconj_) {
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&a_[0 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          l_ = 1 - j_;
          if (noconj_) {
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / a_[0 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = _min ((*n_), j_ + (*k_)); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - __dconjg (&a_[l_ + i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&a_[0 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          if (((*n_) - j_) >= (*k_)) {
            kx_ = kx_ - (*incx_);
          }
        }
      }
    }
  }
  _l0:;
  __calls[141].calls++;
  return 0;
}

int_4 _ztpmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_16 _p_ ap_, complex_16 _p_ x_, 
int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static logical_4 noconj_, nounit_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_96, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            k_ = kk_;
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * ap_[k_ - 1];
              k_ = k_ + 1;
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * ap_[kk_ + j_ - 1 - 1];
            }
          }
          kk_ = kk_ + j_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * ap_[k_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * ap_[kk_ + j_ - 1 - 1];
            }
          }
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + j_;
        }
      }
    }
    else {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            k_ = kk_;
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * ap_[k_ - 1];
              k_ = k_ - 1;
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * ap_[k_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          k_ = kk_ - 1;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * ap_[kk_ - 1];
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              temp_ = temp_ + ap_[k_ - 1] * x_[i_ - 1];
              k_ = k_ - 1;
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&ap_[kk_ - 1]);
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              temp_ = temp_ + __dconjg (&ap_[k_ - 1]) * x_[i_ - 1];
              k_ = k_ - 1;
            }
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ - j_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * ap_[kk_ - 1];
            }
            for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
              ix_ = ix_ - (*incx_);
              temp_ = temp_ + ap_[k_ - 1] * x_[ix_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&ap_[kk_ - 1]);
            }
            for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
              ix_ = ix_ - (*incx_);
              temp_ = temp_ + __dconjg (&ap_[k_ - 1]) * x_[ix_ - 1];
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - j_;
        }
      }
    }
    else {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          k_ = kk_ + 1;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * ap_[kk_ - 1];
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              temp_ = temp_ + ap_[k_ - 1] * x_[i_ - 1];
              k_ = k_ + 1;
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&ap_[kk_ - 1]);
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              temp_ = temp_ + __dconjg (&ap_[k_ - 1]) * x_[i_ - 1];
              k_ = k_ + 1;
            }
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * ap_[kk_ - 1];
            }
            for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
              ix_ = ix_ + (*incx_);
              temp_ = temp_ + ap_[k_ - 1] * x_[ix_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&ap_[kk_ - 1]);
            }
            for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
              ix_ = ix_ + (*incx_);
              temp_ = temp_ + __dconjg (&ap_[k_ - 1]) * x_[ix_ - 1];
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
    }
  }
  _l0:;
  __calls[142].calls++;
  return 0;
}

int_4 _ztpsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_16 _p_ ap_, complex_16 _p_ x_, 
int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, k_, kk_, kx_;
  static logical_4 noconj_, nounit_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*incx_) == 0) {
    info_ = 7;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_97, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[j_ - 1];
            k_ = kk_ - 1;
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * ap_[k_ - 1];
              k_ = k_ - 1;
            }
          }
          kk_ = kk_ - j_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (k_ = kk_ - 1; k_ >= kk_ - j_ + 1; (k_)--) {
              ix_ = ix_ - (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * ap_[k_ - 1];
            }
          }
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - j_;
        }
      }
    }
    else {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[j_ - 1];
            k_ = kk_ + 1;
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * ap_[k_ - 1];
              k_ = k_ + 1;
            }
          }
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / ap_[kk_ - 1];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (k_ = kk_ + 1; k_ <= kk_ + (*n_) - j_; (k_)++) {
              ix_ = ix_ + (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * ap_[k_ - 1];
            }
          }
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + ((*n_) - j_ + 1);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      kk_ = 1;
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          k_ = kk_;
          if (noconj_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - ap_[k_ - 1] * x_[i_ - 1];
              k_ = k_ + 1;
            }
            if (nounit_) {
              temp_ = temp_ / ap_[kk_ + j_ - 1 - 1];
            }
          }
          else {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - __dconjg (&ap_[k_ - 1]) * x_[i_ - 1];
              k_ = k_ + 1;
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&ap_[kk_ + j_ - 1 - 1]);
            }
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ + j_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          if (noconj_) {
            for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
              temp_ = temp_ - ap_[k_ - 1] * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / ap_[kk_ + j_ - 1 - 1];
            }
          }
          else {
            for (k_ = kk_; k_ <= kk_ + j_ - 2; (k_)++) {
              temp_ = temp_ - __dconjg (&ap_[k_ - 1]) * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&ap_[kk_ + j_ - 1 - 1]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
          kk_ = kk_ + j_;
        }
      }
    }
    else {
      kk_ = ((*n_) * ((*n_) + 1)) / 2;
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          k_ = kk_;
          if (noconj_) {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - ap_[k_ - 1] * x_[i_ - 1];
              k_ = k_ - 1;
            }
            if (nounit_) {
              temp_ = temp_ / ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          else {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - __dconjg (&ap_[k_ - 1]) * x_[i_ - 1];
              k_ = k_ - 1;
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&ap_[kk_ - (*n_) + j_ - 1]);
            }
          }
          x_[j_ - 1] = temp_;
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = kx_;
          if (noconj_) {
            for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
              temp_ = temp_ - ap_[k_ - 1] * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / ap_[kk_ - (*n_) + j_ - 1];
            }
          }
          else {
            for (k_ = kk_; k_ >= kk_ - ((*n_) - (j_ + 1)); (k_)--) {
              temp_ = temp_ - __dconjg (&ap_[k_ - 1]) * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&ap_[kk_ - (*n_) + j_ - 1]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
          kk_ = kk_ - ((*n_) - j_ + 1);
        }
      }
    }
  }
  _l0:;
  __calls[143].calls++;
  return 0;
}

int_4 _ztrmm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, complex_16 
_p_ alpha_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 lside_, noconj_, nounit_, upper_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  lside_ = _lsame (side_, _dc_9);
  if (lside_) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  noconj_ = _lsame (transa_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (lside_)) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((! (_lsame (transa_, _dc_0))) && (! (_lsame (transa_, _dc_1))) && (! (_lsame (transa_, _dc_2)))) {
    info_ = 3;
  }
  else if ((! (_lsame (diag_, _dc_8))) && (! (_lsame (diag_, _dc_0)))) {
    info_ = 4;
  }
  else if ((*m_) < 0) {
    info_ = 5;
  }
  else if ((*n_) < 0) {
    info_ = 6;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_98, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
      }
    }
    goto _l0;
  }
  if (lside_) {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (k_ = 1; k_ <= (*m_); (k_)++) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
              temp_ = (*alpha_) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= k_ - 1; (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))]
                ;
              }
              if (nounit_) {
                temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (k_ = (*m_); k_ >= 1; (k_)--) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
              temp_ = (*alpha_) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = k_ + 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = (*m_); i_ >= 1; (i_)--) {
            temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (noconj_) {
              if (nounit_) {
                temp_ = temp_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
              }
              for (k_ = 1; k_ <= i_ - 1; (k_)++) {
                temp_ = temp_ + a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
            }
            else {
              if (nounit_) {
                temp_ = temp_ * __dconjg (&a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]);
              }
              for (k_ = 1; k_ <= i_ - 1; (k_)++) {
                temp_ = temp_ + __dconjg (&a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (noconj_) {
              if (nounit_) {
                temp_ = temp_ * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
              }
              for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
                temp_ = temp_ + a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
            }
            else {
              if (nounit_) {
                temp_ = temp_ * __dconjg (&a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]);
              }
              for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
                temp_ = temp_ + __dconjg (&a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * temp_;
          }
        }
      }
    }
  }
  else {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          for (k_ = 1; k_ <= j_ - 1; (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
              temp_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = (*alpha_);
          if (nounit_) {
            temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
          }
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          }
          for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
              temp_ = (*alpha_) * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (k_ = 1; k_ <= (*n_); (k_)++) {
          for (j_ = 1; j_ <= k_ - 1; (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != CMPLX (0.0, 0.0)) {
              if (noconj_) {
                temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              else {
                temp_ = (*alpha_) * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
              }
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          temp_ = (*alpha_);
          if (nounit_) {
            if (noconj_) {
              temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            }
            else {
              temp_ = temp_ * __dconjg (&a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
            }
          }
          if (temp_ != CMPLX (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
      else {
        for (k_ = (*n_); k_ >= 1; (k_)--) {
          for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != CMPLX (0.0, 0.0)) {
              if (noconj_) {
                temp_ = (*alpha_) * a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              else {
                temp_ = (*alpha_) * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
              }
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          temp_ = (*alpha_);
          if (nounit_) {
            if (noconj_) {
              temp_ = temp_ * a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            }
            else {
              temp_ = temp_ * __dconjg (&a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
            }
          }
          if (temp_ != CMPLX (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[144].calls++;
  return 0;
}

int_4 _ztrmv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, 
complex_16 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static logical_4 noconj_, nounit_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_99, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[j_ - 1];
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            temp_ = x_[jx_ - 1];
            ix_ = kx_;
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              x_[ix_ - 1] = x_[ix_ - 1] + temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              temp_ = temp_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              ix_ = ix_ - (*incx_);
              temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              ix_ = ix_ - (*incx_);
              temp_ = temp_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              temp_ = temp_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[jx_ - 1];
          ix_ = jx_;
          if (noconj_) {
            if (nounit_) {
              temp_ = temp_ * a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              ix_ = ix_ + (*incx_);
              temp_ = temp_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
            }
          }
          else {
            if (nounit_) {
              temp_ = temp_ * __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              ix_ = ix_ + (*incx_);
              temp_ = temp_ + __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[145].calls++;
  return 0;
}

int_4 _ztrsm (char _p_ side_, char _p_ uplo_, char _p_ transa_, char _p_ diag_, int_4 _p_ m_, int_4 _p_ n_, complex_16 
_p_ alpha_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, info_, j_, k_, nrowa_;
  static logical_4 lside_, noconj_, nounit_, upper_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  lside_ = _lsame (side_, _dc_9);
  if (lside_) {
    nrowa_ = (*m_);
  }
  else {
    nrowa_ = (*n_);
  }
  noconj_ = _lsame (transa_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  upper_ = _lsame (uplo_, _dc_8);
  info_ = 0;
  if ((! (lside_)) && (! (_lsame (side_, _dc_11)))) {
    info_ = 1;
  }
  else if ((! (upper_)) && (! (_lsame (uplo_, _dc_9)))) {
    info_ = 2;
  }
  else if ((! (_lsame (transa_, _dc_0))) && (! (_lsame (transa_, _dc_1))) && (! (_lsame (transa_, _dc_2)))) {
    info_ = 3;
  }
  else if ((! (_lsame (diag_, _dc_8))) && (! (_lsame (diag_, _dc_0)))) {
    info_ = 4;
  }
  else if ((*m_) < 0) {
    info_ = 5;
  }
  else if ((*n_) < 0) {
    info_ = 6;
  }
  else if ((*lda_) < _max (1, nrowa_)) {
    info_ = 9;
  }
  else if ((*ldb_) < _max (1, (*m_))) {
    info_ = 11;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_100, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*alpha_) == CMPLX (0.0, 0.0)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
      }
    }
    goto _l0;
  }
  if (lside_) {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != CMPLX (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = (*m_); k_ >= 1; (k_)--) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = 1; i_ <= k_ - 1; (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[i_ 
                - 1 + ((*lda_)) * ((k_ - 1))];
              }
            }
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != CMPLX (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = 1; k_ <= (*m_); (k_)++) {
            if (b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
              if (nounit_) {
                b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              for (i_ = k_ + 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))] * a_[i_ 
                - 1 + ((*lda_)) * ((k_ - 1))];
              }
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            temp_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (noconj_) {
              for (k_ = 1; k_ <= i_ - 1; (k_)++) {
                temp_ = temp_ - a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
              if (nounit_) {
                temp_ = temp_ / a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
              }
            }
            else {
              for (k_ = 1; k_ <= i_ - 1; (k_)++) {
                temp_ = temp_ - __dconjg (&a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
              if (nounit_) {
                temp_ = temp_ / __dconjg (&a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]);
              }
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = (*m_); i_ >= 1; (i_)--) {
            temp_ = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            if (noconj_) {
              for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
                temp_ = temp_ - a_[k_ - 1 + ((*lda_)) * ((i_ - 1))] * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
              if (nounit_) {
                temp_ = temp_ / a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
              }
            }
            else {
              for (k_ = i_ + 1; k_ <= (*m_); (k_)++) {
                temp_ = temp_ - __dconjg (&a_[k_ - 1 + ((*lda_)) * ((i_ - 1))]) * b_[k_ - 1 + ((*ldb_)) * ((j_ - 1))];
              }
              if (nounit_) {
                temp_ = temp_ / __dconjg (&a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]);
              }
            }
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
          }
        }
      }
    }
  }
  else {
    if (_lsame (transa_, _dc_0)) {
      if (upper_) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if ((*alpha_) != CMPLX (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = 1; k_ <= j_ - 1; (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] * b_[i_ 
                - 1 + ((*ldb_)) * ((k_ - 1))];
              }
            }
          }
          if (nounit_) {
            temp_ = CMPLX (1.0, 0.0) / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if ((*alpha_) != CMPLX (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
          for (k_ = j_ + 1; k_ <= (*n_); (k_)++) {
            if (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] * b_[i_ 
                - 1 + ((*ldb_)) * ((k_ - 1))];
              }
            }
          }
          if (nounit_) {
            temp_ = CMPLX (1.0, 0.0) / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
            }
          }
        }
      }
    }
    else {
      if (upper_) {
        for (k_ = (*n_); k_ >= 1; (k_)--) {
          if (nounit_) {
            if (noconj_) {
              temp_ = CMPLX (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            }
            else {
              temp_ = CMPLX (1.0, 0.0) / __dconjg (&a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
            }
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
          for (j_ = 1; j_ <= k_ - 1; (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != CMPLX (0.0, 0.0)) {
              if (noconj_) {
                temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              else {
                temp_ = __dconjg (&a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
              }
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          if ((*alpha_) != CMPLX (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
      else {
        for (k_ = 1; k_ <= (*n_); (k_)++) {
          if (nounit_) {
            if (noconj_) {
              temp_ = CMPLX (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
            }
            else {
              temp_ = CMPLX (1.0, 0.0) / __dconjg (&a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
            }
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
          for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
            if (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] != CMPLX (0.0, 0.0)) {
              if (noconj_) {
                temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
              }
              else {
                temp_ = __dconjg (&a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
              }
              for (i_ = 1; i_ <= (*m_); (i_)++) {
                b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - temp_ * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))]
                ;
              }
            }
          }
          if ((*alpha_) != CMPLX (1.0, 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))] = (*alpha_) * b_[i_ - 1 + ((*ldb_)) * ((k_ - 1))];
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[146].calls++;
  return 0;
}

int_4 _ztrsv (char _p_ uplo_, char _p_ trans_, char _p_ diag_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, 
complex_16 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, info_, ix_, j_, jx_, kx_;
  static logical_4 noconj_, nounit_;
  static complex_16 temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  info_ = 0;
  if (! (_lsame (uplo_, _dc_8)) && ! (_lsame (uplo_, _dc_9))) {
    info_ = 1;
  }
  else if (! (_lsame (trans_, _dc_0)) && ! (_lsame (trans_, _dc_1)) && ! (_lsame (trans_, _dc_2))) {
    info_ = 2;
  }
  else if (! (_lsame (diag_, _dc_8)) && ! (_lsame (diag_, _dc_0))) {
    info_ = 3;
  }
  else if ((*n_) < 0) {
    info_ = 4;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    info_ = 6;
  }
  else if ((*incx_) == 0) {
    info_ = 8;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_101, &info_);
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  noconj_ = _lsame (trans_, _dc_1);
  nounit_ = _lsame (diag_, _dc_0);
  if ((*incx_) <= 0) {
    kx_ = 1 - ((*n_) - 1) * (*incx_);
  }
  else if ((*incx_) != 1) {
    kx_ = 1;
  }
  if (_lsame (trans_, _dc_0)) {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_ + ((*n_) - 1) * (*incx_);
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (i_ = j_ - 1; i_ >= 1; (i_)--) {
              ix_ = ix_ - (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ - (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[j_ - 1] != CMPLX (0.0, 0.0)) {
            if (nounit_) {
              x_[j_ - 1] = x_[j_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[j_ - 1];
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = x_[i_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          if (x_[jx_ - 1] != CMPLX (0.0, 0.0)) {
            if (nounit_) {
              x_[jx_ - 1] = x_[jx_ - 1] / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
            temp_ = x_[jx_ - 1];
            ix_ = jx_;
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              ix_ = ix_ + (*incx_);
              x_[ix_ - 1] = x_[ix_ - 1] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          jx_ = jx_ + (*incx_);
        }
      }
    }
  }
  else {
    if (_lsame (uplo_, _dc_8)) {
      if ((*incx_) == 1) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          temp_ = x_[j_ - 1];
          if (noconj_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        jx_ = kx_;
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          ix_ = kx_;
          temp_ = x_[jx_ - 1];
          if (noconj_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              temp_ = temp_ - __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ + (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ + (*incx_);
        }
      }
    }
    else {
      if ((*incx_) == 1) {
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          temp_ = x_[j_ - 1];
          if (noconj_) {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[i_ - 1];
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[j_ - 1] = temp_;
        }
      }
      else {
        kx_ = kx_ + ((*n_) - 1) * (*incx_);
        jx_ = kx_;
        for (j_ = (*n_); j_ >= 1; (j_)--) {
          ix_ = kx_;
          temp_ = x_[jx_ - 1];
          if (noconj_) {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
          else {
            for (i_ = (*n_); i_ >= j_ + 1; (i_)--) {
              temp_ = temp_ - __dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * x_[ix_ - 1];
              ix_ = ix_ - (*incx_);
            }
            if (nounit_) {
              temp_ = temp_ / __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
            }
          }
          x_[jx_ - 1] = temp_;
          jx_ = jx_ - (*incx_);
        }
      }
    }
  }
  _l0:;
  __calls[147].calls++;
  return 0;
}

