//! @file mathlib-eispack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 82 subprograms from EISPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// BAKVEC CDIV   COMLR  ELMBAK HTRIB3 MINFIT RATQR  RGORT  RSPP   TQLRAT
// BALANC CG     COMLR2 ELMHES HTRIBK ORTBAK REBAK  RS     RST    TRBAK1
// BALBAK CGLR   COMQR  ELTRAN HTRID3 ORTHES REBAKB RSB    RT     TRBAK3
// BANDR  CGQR   COMQR2 EPSLON HTRIDI ORTRAN REDUC  RSG    SSPEV  TRED1
// BANDV  CH     CORTB  FIGI   IMTQL1 QZHES  REDUC2 RSGAB  SVD    TRED2
// BISECT CH3    CORTH  FIGI2  IMTQL2 QZIT   RG     RSGBA  TINVIT TRED3
// BQR    CINVIT CSROOT HQR    IMTQLV QZVAL  RGELM  RSM    TQL1   TRIDIB
// CBABK2 COMBAK EISDOC HQR2   INVIT  QZVEC  RGG    RSP    TQL2   TSTURM
// CBAL   COMHES

// EISPACK is a collection of double-precision Fortran subroutines that
// compute the eigenvalues and eigenvectors of nine classes of matrices:
// complex general, complex Hermitian, real general, real symmetric, real
// symmetric banded, real symmetric tridiagonal, special real
// tridiagonal, generalized real, and generalized real symmetric matices.
// In addition, two routines are included that use singular value
// decomposition to solve certain least-squares problems. 
// 
// Originally written around 1972–1973,[1] EISPACK, like LINPACK and MINPACK, 
// originated from Argonne National Laboratory, has always been free, and 
// aims to be portable, robust and reliable. The library drew heavily on 
// algorithms developed by James Wilkinson, which were originally implemented 
// in ALGOL. Brian Smith led a team at Argonne developing EISPACK, initially 
// by translating these algorithms into FORTRAN. Jack Dongarra joined the 
// team as an undergraduate intern at Argonne, and later went on to create 
// LAPACK, which has largely superseded EISPACK and LINPACK. 
// 
// This version of EISPACK is adapted for VIF.
// Adaptations are trivial, concerning choosing alternative names for
// variable names that coincided with intrinsic functions.
// 
// Source: netlib.org/eispack/

// The license for EISPACK Fortran source code is:
//
// EISPACK, like LINPACK and MINPACK, originated from Argonne National Laboratory 
// and has always been free. EISPACK did not have a copyright notice or involved 
// any kind of license. The term "open source" was not yet widely used at the time.
// 
// Source: netlib.org/eispack/
// 
// This particular version is John Burkardt's adaptation of original EISPACK code.
// John Burkardt released his version under GNU LGPL.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 " "
#define _dc_1 "RSPP - Fatal error!"
#define _dc_2 "  Error return from RATQR."
#define _dc_3 "  Error return from TINVIT."
#define _dc_4 "SLATEC"
#define _dc_5 "SSPEV"
#define _dc_6 "N .GT. LDV."
#define _dc_7 "N .LT. 1"
static FORMAT *__fmt_a = NULL;
typedef char char_1[2];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
#define __ncalls 83
static CALLS __calls[__ncalls] = {
  {"bakvec", 0}, // subroutine
  {"balanc", 0}, // subroutine
  {"balbak", 0}, // subroutine
  {"bandr", 0}, // subroutine
  {"bandv", 0}, // subroutine
  {"bisect", 0}, // subroutine
  {"bqr", 0}, // subroutine
  {"cbabk2", 0}, // subroutine
  {"cbal", 0}, // subroutine
  {"cdiv", 0}, // subroutine
  {"cg", 0}, // subroutine
  {"cglr", 0}, // subroutine
  {"cgqr", 0}, // subroutine
  {"ch3", 0}, // subroutine
  {"ch", 0}, // subroutine
  {"cinvit", 0}, // subroutine
  {"combak", 0}, // subroutine
  {"comhes", 0}, // subroutine
  {"comlr2", 0}, // subroutine
  {"comlr", 0}, // subroutine
  {"comqr2", 0}, // subroutine
  {"comqr", 0}, // subroutine
  {"cortb", 0}, // subroutine
  {"corth", 0}, // subroutine
  {"csroot", 0}, // subroutine
  {"eisdoc", 0}, // subroutine
  {"elmbak", 0}, // subroutine
  {"elmhes", 0}, // subroutine
  {"eltran", 0}, // subroutine
  {"epslon", 0}, // real*8 function
  {"figi2", 0}, // subroutine
  {"figi", 0}, // subroutine
  {"hqr2", 0}, // subroutine
  {"hqr", 0}, // subroutine
  {"htrib3", 0}, // subroutine
  {"htribk", 0}, // subroutine
  {"htrid3", 0}, // subroutine
  {"htridi", 0}, // subroutine
  {"imtql1", 0}, // subroutine
  {"imtql2", 0}, // subroutine
  {"imtqlv", 0}, // subroutine
  {"invit", 0}, // subroutine
  {"minfit", 0}, // subroutine
  {"ortbak", 0}, // subroutine
  {"orthes", 0}, // subroutine
  {"ortran", 0}, // subroutine
  {"qzhes", 0}, // subroutine
  {"qzit", 0}, // subroutine
  {"qzval", 0}, // subroutine
  {"qzvec", 0}, // subroutine
  {"ratqr", 0}, // subroutine
  {"rebakb", 0}, // subroutine
  {"rebak", 0}, // subroutine
  {"reduc2", 0}, // subroutine
  {"reduc", 0}, // subroutine
  {"rgelm", 0}, // subroutine
  {"rg", 0}, // subroutine
  {"rgg", 0}, // subroutine
  {"rgort", 0}, // subroutine
  {"rsb", 0}, // subroutine
  {"rs", 0}, // subroutine
  {"rsgab", 0}, // subroutine
  {"rsgba", 0}, // subroutine
  {"rsg", 0}, // subroutine
  {"rsm", 0}, // subroutine
  {"rsp", 0}, // subroutine
  {"rspp", 0}, // subroutine
  {"rst", 0}, // subroutine
  {"rt", 0}, // subroutine
  {"sspev", 0}, // subroutine
  {"svd", 0}, // subroutine
  {"tinvit", 0}, // subroutine
  {"tql1", 0}, // subroutine
  {"tql2", 0}, // subroutine
  {"tqlrat", 0}, // subroutine
  {"trbak1", 0}, // subroutine
  {"trbak3", 0}, // subroutine
  {"tred1", 0}, // subroutine
  {"tred2", 0}, // subroutine
  {"tred3", 0}, // subroutine
  {"tridib", 0}, // subroutine
  {"tsturm", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _bakvec (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ e_, int_4 _p_ m_, real_8 _p_ z_, int_4 
_p_ ierr_);
prototype int_4 _balanc (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ scale_)
;
prototype int_4 _balbak (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ scale_, int_4 _p_ m_, 
real_8 _p_ z_);
prototype int_4 _bandr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ mb_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 
_p_ e2_, logical_4 _p_ matz_, real_8 _p_ z_);
prototype int_4 _bandv (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ mbw_, real_8 _p_ a_, real_8 _p_ e21_, int_4 _p_ m_, 
real_8 _p_ w_, real_8 _p_ z_, int_4 _p_ ierr_, int_4 _p_ nv_, real_8 _p_ rv_, real_8 _p_ rv6_);
prototype int_4 _bisect (int_4 _p_ n_, real_8 _p_ eps1_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, real_8 _p_ lb_, 
real_8 _p_ ub_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ w_, int_4 _p_ ind_, int_4 _p_ ierr_, real_8 _p_ rv4_, real_8 
_p_ rv5_);
prototype int_4 _bqr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ mb_, real_8 _p_ a_, real_8 _p_ t_, real_8 _p_ r_, int_4 
_p_ ierr_, int_4 _p_ nv_, real_8 _p_ rv_);
prototype int_4 _cbabk2 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ scale_, int_4 _p_ m_, 
real_8 _p_ zr_, real_8 _p_ zi_);
prototype int_4 _cbal (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, int_4 _p_ low_, int_4 _p_ igh_, 
real_8 _p_ scale_);
prototype int_4 _cdiv (real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ br_, real_8 _p_ bi_, real_8 _p_ cr_, real_8 _p_ ci_);
prototype int_4 _cg (int_4 _p_ nm_, int_4 _p_ n_, real_4 _p_ ar_, real_4 _p_ ai_, real_4 _p_ wr_, real_4 _p_ wi_, int_4 
_p_ matz_, real_4 _p_ zr_, real_4 _p_ zi_, real_4 _p_ fv1_, real_4 _p_ fv2_, real_4 _p_ fv3_, int_4 _p_ ierr_);
prototype int_4 _cglr (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ wr_, real_8 _p_ wi_, 
int_4 _p_ matz_, real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fv1_, int_4 _p_ iv1_, int_4 _p_ ierr_);
prototype int_4 _cgqr (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ wr_, real_8 _p_ wi_, 
int_4 _p_ matz_, real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fv1_, real_8 _p_ fv2_, real_8 _p_ fv3_, int_4 _p_ ierr_);
prototype int_4 _ch3 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ zr_, 
real_8 _p_ zi_, real_8 _p_ fv1_, real_8 _p_ fv2_, real_8 _p_ fm1_, int_4 _p_ ierr_);
prototype int_4 _ch (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ w_, int_4 _p_ matz_, 
real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fv1_, real_8 _p_ fv2_, real_8 _p_ fm1_, int_4 _p_ ierr_);
prototype int_4 _cinvit (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ wr_, real_8 _p_ wi_, 
logical_4 _p_ select_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ zr_, real_8 _p_ zi_, int_4 _p_ ierr_, real_8 _p_ rm1_, 
real_8 _p_ rm2_, real_8 _p_ rv1_, real_8 _p_ rv2_);
prototype int_4 _combak (int_4 _p_ nm_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ar_, real_8 _p_ ai_, int_4 _p_ int_, 
int_4 _p_ m_, real_8 _p_ zr_, real_8 _p_ zi_);
prototype int_4 _comhes (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ar_, real_8 _p_ ai_, 
int_4 _p_ int_);
prototype int_4 _comlr2 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, int_4 _p_ int_, real_8 _p_ hr_, 
real_8 _p_ hi_, real_8 _p_ wr_, real_8 _p_ wi_, real_8 _p_ zr_, real_8 _p_ zi_, int_4 _p_ ierr_);
prototype int_4 _comlr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ hr_, real_8 _p_ hi_, 
real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ ierr_);
prototype int_4 _comqr2 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ortr_, real_8 _p_ 
orti_, real_8 _p_ hr_, real_8 _p_ hi_, real_8 _p_ wr_, real_8 _p_ wi_, real_8 _p_ zr_, real_8 _p_ zi_, int_4 _p_ ierr_)
;
prototype int_4 _comqr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ hr_, real_8 _p_ hi_, 
real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ ierr_);
prototype int_4 _cortb (int_4 _p_ nm_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ ortr_
, real_8 _p_ orti_, int_4 _p_ m_, real_8 _p_ zr_, real_8 _p_ zi_);
prototype int_4 _corth (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ar_, real_8 _p_ ai_, 
real_8 _p_ ortr_, real_8 _p_ orti_);
prototype int_4 _csroot (real_8 _p_ xr_, real_8 _p_ xi_, real_8 _p_ yr_, real_8 _p_ yi_);
prototype int_4 _eisdoc (void);
prototype int_4 _elmbak (int_4 _p_ nm_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, int_4 _p_ int_, int_4 _p_ m_, 
real_8 _p_ z_);
prototype int_4 _elmhes (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, int_4 _p_ int_);
prototype int_4 _eltran (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, int_4 _p_ int_, 
real_8 _p_ z_);
prototype real_8 _epslon (real_8 _p_ x_);
prototype int_4 _figi2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, int_4 
_p_ ierr_);
prototype int_4 _figi (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, int_4 
_p_ ierr_);
prototype int_4 _hqr2 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ h_, real_8 _p_ wr_, 
real_8 _p_ wi_, real_8 _p_ z_, int_4 _p_ ierr_);
prototype int_4 _hqr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ h_, real_8 _p_ wr_, 
real_8 _p_ wi_, int_4 _p_ ierr_);
prototype int_4 _htrib3 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ tau_, int_4 _p_ m_, real_8 _p_ zr_, 
real_8 _p_ zi_);
prototype int_4 _htribk (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ tau_, int_4 _p_ m_, 
real_8 _p_ zr_, real_8 _p_ zi_);
prototype int_4 _htrid3 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, 
real_8 _p_ tau_);
prototype int_4 _htridi (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ d_, real_8 _p_ e_, 
real_8 _p_ e2_, real_8 _p_ tau_);
prototype int_4 _imtql1 (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, int_4 _p_ ierr_);
prototype int_4 _imtql2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, int_4 _p_ ierr_);
prototype int_4 _imtqlv (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, real_8 _p_ w_, int_4 _p_ ind_, 
int_4 _p_ ierr_, real_8 _p_ rv1_);
prototype int_4 _invit (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ wr_, real_8 _p_ wi_, logical_4 _p_ 
select_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ z_, int_4 _p_ ierr_, real_8 _p_ rm1_, real_8 _p_ rv1_, real_8 _p_ rv2_
);
prototype int_4 _minfit (int_4 _p_ nm_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ ip_, real_8 
_p_ b_, int_4 _p_ ierr_, real_8 _p_ rv1_);
prototype int_4 _ortbak (int_4 _p_ nm_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, real_8 _p_ ort_, int_4 _p_ m_, 
real_8 _p_ z_);
prototype int_4 _orthes (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, real_8 _p_ ort_);
prototype int_4 _ortran (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, real_8 _p_ ort_, 
real_8 _p_ z_);
prototype int_4 _qzhes (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, logical_4 _p_ matz_, real_8 _p_ z_);
prototype int_4 _qzit (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ eps1_, logical_4 _p_ matz_
, real_8 _p_ z_, int_4 _p_ ierr_);
prototype int_4 _qzval (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfr_, real_8 _p_ alfi_, 
real_8 _p_ beta_, logical_4 _p_ matz_, real_8 _p_ z_);
prototype int_4 _qzvec (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfr_, real_8 _p_ alfi_, 
real_8 _p_ beta_, real_8 _p_ z_);
prototype int_4 _ratqr (int_4 _p_ n_, real_8 _p_ eps1_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, int_4 _p_ m_, 
real_8 _p_ w_, int_4 _p_ ind_, real_8 _p_ bd_, logical_4 _p_ type_, int_4 _p_ idef_, int_4 _p_ ierr_);
prototype int_4 _rebakb (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ b_, real_8 _p_ dl_, int_4 _p_ m_, real_8 _p_ z_);
prototype int_4 _rebak (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ b_, real_8 _p_ dl_, int_4 _p_ m_, real_8 _p_ z_);
prototype int_4 _reduc2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ dl_, int_4 _p_ ierr_);
prototype int_4 _reduc (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ dl_, int_4 _p_ ierr_);
prototype int_4 _rgelm (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ matz_, 
real_8 _p_ z_, int_4 _p_ iv1_, real_8 _p_ fv1_, int_4 _p_ ierr_);
prototype int_4 _rg (int_4 _p_ nm_, int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ wr_, real_4 _p_ wi_, int_4 _p_ matz_, 
real_4 _p_ z_, int_4 _p_ iv1_, real_4 _p_ fv1_, int_4 _p_ ierr_);
prototype int_4 _rgg (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfr_, real_8 _p_ alfi_, 
real_8 _p_ beta_, int_4 _p_ matz_, real_8 _p_ z_, int_4 _p_ ierr_);
prototype int_4 _rgort (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ matz_, 
real_8 _p_ z_, real_8 _p_ ort_, real_8 _p_ fv1_, int_4 _p_ ierr_);
prototype int_4 _rsb (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ mb_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 
_p_ z_, real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_);
prototype int_4 _rs (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, real_8 
_p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_);
prototype int_4 _rsgab (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ w_, int_4 _p_ matz_, 
real_8 _p_ z_, real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_);
prototype int_4 _rsgba (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ w_, int_4 _p_ matz_, 
real_8 _p_ z_, real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_);
prototype int_4 _rsg (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ w_, int_4 _p_ matz_, real_8 
_p_ z_, real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_);
prototype int_4 _rsm (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ m_, real_8 _p_ z_, real_8 
_p_ fwork_, int_4 _p_ iwork_, int_4 _p_ ierr_);
prototype int_4 _rsp (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ nv_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 
_p_ z_, real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_);
prototype int_4 _rspp (int_4 _p_ n_, int_4 _p_ nv_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, int_4 
_p_ ierr_, int_4 _p_ m_, logical_4 _p_ type_);
prototype int_4 _rst (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ w_, real_8 _p_ e_, int_4 _p_ matz_, real_8 _p_ z_, int_4 
_p_ ierr_);
prototype int_4 _rt (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, real_8 
_p_ fv1_, int_4 _p_ ierr_);
prototype int_4 _sspev (real_4 _p_ a_, int_4 _p_ n_, real_4 _p_ e_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ work_, 
int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _svd (int_4 _p_ nm_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, logical_4 _p_ matu_, 
real_8 _p_ u_, logical_4 _p_ matv_, real_8 _p_ v_, int_4 _p_ ierr_, real_8 _p_ rv1_);
prototype int_4 _tinvit (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, int_4 _p_ m_, 
real_8 _p_ w_, int_4 _p_ ind_, real_8 _p_ z_, int_4 _p_ ierr_, real_8 _p_ rv1_, real_8 _p_ rv2_, real_8 _p_ rv3_, 
real_8 _p_ rv4_, real_8 _p_ rv6_);
prototype int_4 _tql1 (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, int_4 _p_ ierr_);
prototype int_4 _tql2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, int_4 _p_ ierr_);
prototype int_4 _tqlrat (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e2_, int_4 _p_ ierr_);
prototype int_4 _trbak1 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ e_, int_4 _p_ m_, real_8 _p_ z_);
prototype int_4 _trbak3 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ nv_, real_8 _p_ a_, int_4 _p_ m_, real_8 _p_ z_);
prototype int_4 _tred1 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_);
prototype int_4 _tred2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_);
prototype int_4 _tred3 (int_4 _p_ n_, int_4 _p_ nv_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_);
prototype int_4 _tridib (int_4 _p_ n_, real_8 _p_ eps1_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, real_8 _p_ lb_, 
real_8 _p_ ub_, int_4 _p_ m11_, int_4 _p_ m_, real_8 _p_ w_, int_4 _p_ ind_, int_4 _p_ ierr_, real_8 _p_ rv4_, real_8 
_p_ rv5_);
prototype int_4 _tsturm (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ eps1_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, 
real_8 _p_ lb_, real_8 _p_ ub_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ w_, real_8 _p_ z_, int_4 _p_ ierr_, real_8 _p_ 
rv1_, real_8 _p_ rv2_, real_8 _p_ rv3_, real_8 _p_ rv4_, real_8 _p_ rv5_, real_8 _p_ rv6_);
int_4 _bakvec (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ e_, int_4 _p_ m_, real_8 _p_ z_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  (*ierr_) = 0;
  if ((*m_) == 0) {
    goto _l1001;
  }
  e_[0] = 1.0;
  if ((*n_) == 1) {
    goto _l1001;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (e_[i_ - 1] != 0.0e0) {
      goto _l80;
    }
    if (t_[i_ - 1 + ((*nm_)) * ((0))] != 0.0e0 || t_[i_ - 1 - 1 + ((*nm_)) * ((2))] != 0.0e0) {
      goto _l1000;
    }
    e_[i_ - 1] = 1.0;
    goto _l100;
    _l80:;
    e_[i_ - 1] = e_[i_ - 1 - 1] * e_[i_ - 1] / t_[i_ - 1 - 1 + ((*nm_)) * ((2))];
    _l100:;
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 2; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * e_[i_ - 1];
    }
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = 2 * (*n_) + i_;
  _l1001:;
  __calls[0].calls++;
  return 0;
}

int_4 _balanc (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ scale_)
{
  static int_4 i_, j_, k_, l_, m_, jj_, iexc_;
  static logical_4 noconv_;
  static real_8 c_, f_, g_, r_, s_, b2_, radix_;
  radix_ = 16.0;
  b2_ = radix_ * radix_;
  k_ = 1;
  l_ = (*n_);
  goto _l100;
  _l20:;
  scale_[m_ - 1] = j_;
  if (j_ == m_) {
    goto _l50;
  }
  for (i_ = 1; i_ <= l_; (i_)++) {
    f_ = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((m_ - 1))];
    a_[i_ - 1 + ((*nm_)) * ((m_ - 1))] = f_;
  }
  for (i_ = k_; i_ <= (*n_); (i_)++) {
    f_ = a_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
    a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = a_[m_ - 1 + ((*nm_)) * ((i_ - 1))];
    a_[m_ - 1 + ((*nm_)) * ((i_ - 1))] = f_;
  }
  _l50:;
  switch (iexc_) {
    default:
    case 1: goto _l80;
    case 2: goto _l130;
  }
  _l80:;
  if (l_ == 1) {
    goto _l280;
  }
  l_ = l_ - 1;
  _l100:;
  for (jj_ = 1; jj_ <= l_; (jj_)++) {
    j_ = l_ + 1 - jj_;
    for (i_ = 1; i_ <= l_; (i_)++) {
      if (i_ == j_) {
        goto _l110;
      }
      if (a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] != 0.0e0) {
        goto _l120;
      }
      _l110:;
    }
    m_ = l_;
    iexc_ = 1;
    goto _l20;
    _l120:;
  }
  goto _l140;
  _l130:;
  k_ = k_ + 1;
  _l140:;
  for (j_ = k_; j_ <= l_; (j_)++) {
    for (i_ = k_; i_ <= l_; (i_)++) {
      if (i_ == j_) {
        goto _l150;
      }
      if (a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] != 0.0e0) {
        goto _l170;
      }
      _l150:;
    }
    m_ = k_;
    iexc_ = 2;
    goto _l20;
    _l170:;
  }
  for (i_ = k_; i_ <= l_; (i_)++) {
    scale_[i_ - 1] = 1.0;
  }
  _l190:;
  noconv_ = FALSE;
  for (i_ = k_; i_ <= l_; (i_)++) {
    c_ = 0.0;
    r_ = 0.0;
    for (j_ = k_; j_ <= l_; (j_)++) {
      if (j_ == i_) {
        goto _l200;
      }
      c_ = c_ + _abs (a_[j_ - 1 + ((*nm_)) * ((i_ - 1))]);
      r_ = r_ + _abs (a_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      _l200:;
    }
    if (c_ == 0.0e0 || r_ == 0.0e0) {
      goto _l270;
    }
    g_ = r_ / radix_;
    f_ = 1.0;
    s_ = c_ + r_;
    _l210:;
    if (c_ >= g_) {
      goto _l220;
    }
    f_ = f_ * radix_;
    c_ = c_ * b2_;
    goto _l210;
    _l220:;
    g_ = r_ * radix_;
    _l230:;
    if (c_ < g_) {
      goto _l240;
    }
    f_ = f_ / radix_;
    c_ = c_ / b2_;
    goto _l230;
    _l240:;
    if ((c_ + r_) / f_ >= 0.95e0 * s_) {
      goto _l270;
    }
    g_ = 1.0e0 / f_;
    scale_[i_ - 1] = scale_[i_ - 1] * f_;
    noconv_ = TRUE;
    for (j_ = k_; j_ <= (*n_); (j_)++) {
      a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * g_;
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] * f_;
    }
    _l270:;
  }
  if (noconv_) {
    goto _l190;
  }
  _l280:;
  (*low_) = k_;
  (*igh_) = l_;
  __calls[1].calls++;
  return 0;
}

int_4 _balbak (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ scale_, int_4 _p_ m_, real_8 _p_ 
z_)
{
  static int_4 i_, j_, k_, ii_;
  static real_8 s_;
  if ((*m_) == 0) {
    goto _l200;
  }
  if ((*igh_) == (*low_)) {
    goto _l120;
  }
  for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
    s_ = scale_[i_ - 1];
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * s_;
    }
  }
  _l120:;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = ii_;
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l140;
    }
    if (i_ < (*low_)) {
      i_ = (*low_) - ii_;
    }
    k_ = (int_4) (_aintd (scale_[i_ - 1]));
    if (k_ == i_) {
      goto _l140;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      s_ = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = s_;
    }
    _l140:;
  }
  _l200:;
  __calls[2].calls++;
  return 0;
}

int_4 _bandr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ mb_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, 
logical_4 _p_ matz_, real_8 _p_ z_)
{
  static int_4 j_, k_, l_, r_, i1_, i2_, j1_, j2_, kr_, mr_, m1_, n2_, r1_, ugl_, maxl_, maxr_;
  static real_8 g_, u_, b1_, b2_, c2_, f1_, f2_, s2_, dmin_, dminrt_;
  int_4 $0_;
  dmin_ = _up_real_8 (2.0e0, -64);
  dminrt_ = _up_real_8 (2.0e0, -32);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    d_[j_ - 1] = 1.0;
  }
  if (! ((*matz_))) {
    goto _l60;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (k_ = 1; k_ <= (*n_); (k_)++) {
      z_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = 0.0;
    }
    z_[j_ - 1 + ((*nm_)) * ((j_ - 1))] = 1.0;
  }
  _l60:;
  m1_ = (*mb_) - 1;
  $0_ = m1_ - 1;
  if ($0_ < 0) {
    goto _l900;
  } else if ($0_ == 0) {
    goto _l800;
  } else {
    goto _l70;
  }
  _l70:;
  n2_ = (*n_) - 2;
  for (k_ = 1; k_ <= n2_; (k_)++) {
    maxr_ = _min (m1_, (*n_) - k_);
    for (r1_ = 2; r1_ <= maxr_; (r1_)++) {
      r_ = maxr_ + 2 - r1_;
      kr_ = k_ + r_;
      mr_ = (*mb_) - r_;
      g_ = a_[kr_ - 1 + ((*nm_)) * ((mr_ - 1))];
      a_[kr_ - 1 - 1 + ((*nm_)) * ((0))] = a_[kr_ - 1 - 1 + ((*nm_)) * ((mr_ + 1 - 1))];
      ugl_ = k_;
      for (j_ = kr_; (m1_ > 0 ? j_ <= (*n_) : j_ >= (*n_)); j_ += m1_) {
        j1_ = j_ - 1;
        j2_ = j1_ - 1;
        if (g_ == 0.0e0) {
          goto _l600;
        }
        b1_ = a_[j1_ - 1 + ((*nm_)) * ((0))] / g_;
        b2_ = b1_ * d_[j1_ - 1] / d_[j_ - 1];
        if (_abs (b1_) > 1.0e0) {
          u_ = 1.0e0 / b1_;
          s2_ = u_ / (u_ + b2_);
        }
        else {
          s2_ = 1.0e0 / (1.0e0 + b1_ * b2_);
        }
        if (s2_ >= 0.5e0) {
          goto _l450;
        }
        b1_ = g_ / a_[j1_ - 1 + ((*nm_)) * ((0))];
        b2_ = b1_ * d_[j_ - 1] / d_[j1_ - 1];
        c2_ = 1.0e0 - s2_;
        d_[j1_ - 1] = c2_ * d_[j1_ - 1];
        d_[j_ - 1] = c2_ * d_[j_ - 1];
        f1_ = 2.0e0 * a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))];
        f2_ = b1_ * a_[j1_ - 1 + ((*nm_)) * (((*mb_) - 1))];
        a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))] = -b2_ * (b1_ * a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))] - a_[j_ - 1 + ((*nm_)) * 
        (((*mb_) - 1))]) - f2_ + a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))];
        a_[j1_ - 1 + ((*nm_)) * (((*mb_) - 1))] = b2_ * (b2_ * a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))] + f1_) + a_[j1_ - 1 + 
        ((*nm_)) * (((*mb_) - 1))];
        a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))] = b1_ * (f2_ - f1_) + a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))];
        for (l_ = ugl_; l_ <= j2_; (l_)++) {
          i2_ = (*mb_) - j_ + l_;
          u_ = a_[j1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))] + b2_ * a_[j_ - 1 + ((*nm_)) * ((i2_ - 1))];
          a_[j_ - 1 + ((*nm_)) * ((i2_ - 1))] = -b1_ * a_[j1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))] + a_[j_ - 1 + ((*nm_)) * ((i2_ - 
          1))];
          a_[j1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))] = u_;
        }
        ugl_ = j_;
        a_[j1_ - 1 + ((*nm_)) * ((0))] = a_[j1_ - 1 + ((*nm_)) * ((0))] + b2_ * g_;
        if (j_ == (*n_)) {
          goto _l350;
        }
        maxl_ = _min (m1_, (*n_) - j1_);
        for (l_ = 2; l_ <= maxl_; (l_)++) {
          i1_ = j1_ + l_;
          i2_ = (*mb_) - l_;
          u_ = a_[i1_ - 1 + ((*nm_)) * ((i2_ - 1))] + b2_ * a_[i1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))];
          a_[i1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))] = -b1_ * a_[i1_ - 1 + ((*nm_)) * ((i2_ - 1))] + a_[i1_ - 1 + ((*nm_)) * ((i2_ 
          + 1 - 1))];
          a_[i1_ - 1 + ((*nm_)) * ((i2_ - 1))] = u_;
        }
        i1_ = j_ + m1_;
        if (i1_ > (*n_)) {
          goto _l350;
        }
        g_ = b2_ * a_[i1_ - 1 + ((*nm_)) * ((0))];
        _l350:;
        if (! ((*matz_))) {
          goto _l500;
        }
        for (l_ = 1; l_ <= (*n_); (l_)++) {
          u_ = z_[l_ - 1 + ((*nm_)) * ((j1_ - 1))] + b2_ * z_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
          z_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = -b1_ * z_[l_ - 1 + ((*nm_)) * ((j1_ - 1))] + z_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
          z_[l_ - 1 + ((*nm_)) * ((j1_ - 1))] = u_;
        }
        goto _l500;
        _l450:;
        u_ = d_[j1_ - 1];
        d_[j1_ - 1] = s2_ * d_[j_ - 1];
        d_[j_ - 1] = s2_ * u_;
        f1_ = 2.0e0 * a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))];
        f2_ = b1_ * a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))];
        u_ = b1_ * (f2_ - f1_) + a_[j1_ - 1 + ((*nm_)) * (((*mb_) - 1))];
        a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))] = b2_ * (b1_ * a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))] - a_[j1_ - 1 + ((*nm_)) * 
        (((*mb_) - 1))]) + f2_ - a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))];
        a_[j1_ - 1 + ((*nm_)) * (((*mb_) - 1))] = b2_ * (b2_ * a_[j1_ - 1 + ((*nm_)) * (((*mb_) - 1))] + f1_) + a_[j_ - 1 + 
        ((*nm_)) * (((*mb_) - 1))];
        a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))] = u_;
        for (l_ = ugl_; l_ <= j2_; (l_)++) {
          i2_ = (*mb_) - j_ + l_;
          u_ = b2_ * a_[j1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))] + a_[j_ - 1 + ((*nm_)) * ((i2_ - 1))];
          a_[j_ - 1 + ((*nm_)) * ((i2_ - 1))] = -a_[j1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))] + b1_ * a_[j_ - 1 + ((*nm_)) * ((i2_ - 
          1))];
          a_[j1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))] = u_;
        }
        ugl_ = j_;
        a_[j1_ - 1 + ((*nm_)) * ((0))] = b2_ * a_[j1_ - 1 + ((*nm_)) * ((0))] + g_;
        if (j_ == (*n_)) {
          goto _l480;
        }
        maxl_ = _min (m1_, (*n_) - j1_);
        for (l_ = 2; l_ <= maxl_; (l_)++) {
          i1_ = j1_ + l_;
          i2_ = (*mb_) - l_;
          u_ = b2_ * a_[i1_ - 1 + ((*nm_)) * ((i2_ - 1))] + a_[i1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))];
          a_[i1_ - 1 + ((*nm_)) * ((i2_ + 1 - 1))] = -a_[i1_ - 1 + ((*nm_)) * ((i2_ - 1))] + b1_ * a_[i1_ - 1 + ((*nm_)) * ((i2_ 
          + 1 - 1))];
          a_[i1_ - 1 + ((*nm_)) * ((i2_ - 1))] = u_;
        }
        i1_ = j_ + m1_;
        if (i1_ > (*n_)) {
          goto _l480;
        }
        g_ = a_[i1_ - 1 + ((*nm_)) * ((0))];
        a_[i1_ - 1 + ((*nm_)) * ((0))] = b1_ * a_[i1_ - 1 + ((*nm_)) * ((0))];
        _l480:;
        if (! ((*matz_))) {
          goto _l500;
        }
        for (l_ = 1; l_ <= (*n_); (l_)++) {
          u_ = b2_ * z_[l_ - 1 + ((*nm_)) * ((j1_ - 1))] + z_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
          z_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = -z_[l_ - 1 + ((*nm_)) * ((j1_ - 1))] + b1_ * z_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
          z_[l_ - 1 + ((*nm_)) * ((j1_ - 1))] = u_;
        }
        _l500:;
      }
      _l600:;
    }
    if (_imod (k_, 64) != 0) {
      goto _l700;
    }
    for (j_ = k_; j_ <= (*n_); (j_)++) {
      if (d_[j_ - 1] >= dmin_) {
        goto _l650;
      }
      maxl_ = _max (1, (*mb_) + 1 - j_);
      for (l_ = maxl_; l_ <= m1_; (l_)++) {
        a_[j_ - 1 + ((*nm_)) * ((l_ - 1))] = dminrt_ * a_[j_ - 1 + ((*nm_)) * ((l_ - 1))];
      }
      if (j_ == (*n_)) {
        goto _l630;
      }
      maxl_ = _min (m1_, (*n_) - j_);
      for (l_ = 1; l_ <= maxl_; (l_)++) {
        i1_ = j_ + l_;
        i2_ = (*mb_) - l_;
        a_[i1_ - 1 + ((*nm_)) * ((i2_ - 1))] = dminrt_ * a_[i1_ - 1 + ((*nm_)) * ((i2_ - 1))];
      }
      _l630:;
      if (! ((*matz_))) {
        goto _l645;
      }
      for (l_ = 1; l_ <= (*n_); (l_)++) {
        z_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = dminrt_ * z_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      _l645:;
      a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))] = dmin_ * a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))];
      d_[j_ - 1] = d_[j_ - 1] / dmin_;
      _l650:;
    }
    _l700:;
  }
  _l800:;
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    e_[j_ - 1] = sqrt (d_[j_ - 1]);
  }
  if (! ((*matz_))) {
    goto _l840;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (k_ = 2; k_ <= (*n_); (k_)++) {
      z_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = e_[k_ - 1] * z_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
    }
  }
  _l840:;
  u_ = 1.0;
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))] = u_ * e_[j_ - 1] * a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))];
    u_ = e_[j_ - 1];
    e2_[j_ - 1] = (a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))] * a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))]);
    a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))] = d_[j_ - 1] * a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))];
    d_[j_ - 1] = a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))];
    e_[j_ - 1] = a_[j_ - 1 + ((*nm_)) * ((m1_ - 1))];
  }
  d_[0] = a_[0 + ((*nm_)) * (((*mb_) - 1))];
  e_[0] = 0.0;
  e2_[0] = 0.0;
  goto _l1001;
  _l900:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    d_[j_ - 1] = a_[j_ - 1 + ((*nm_)) * (((*mb_) - 1))];
    e_[j_ - 1] = 0.0;
    e2_[j_ - 1] = 0.0;
  }
  _l1001:;
  __calls[3].calls++;
  return 0;
}

int_4 _bandv (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ mbw_, real_8 _p_ a_, real_8 _p_ e21_, int_4 _p_ m_, real_8 _p_ w_, 
real_8 _p_ z_, int_4 _p_ ierr_, int_4 _p_ nv_, real_8 _p_ rv_, real_8 _p_ rv6_)
{
  static int_4 i_, j_, k_, r_, ii_, ij_, jj_, kj_, mb_, m1_, ij1_, its_, kj1_, m21_, maxj_, maxk_, group_;
  static real_8 u_, v_, uk_, xu_, x0_, x1_, eps2_, eps3_, eps4_, norm_, order_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  if ((*m_) == 0) {
    goto _l1001;
  }
  mb_ = (*mbw_);
  if ((*e21_) < 0.0e0) {
    mb_ = ((*mbw_) + 1) / 2;
  }
  m1_ = mb_ - 1;
  m21_ = m1_ + mb_;
  order_ = 1.0e0 - _abs ((*e21_));
  for (r_ = 1; r_ <= (*m_); (r_)++) {
    its_ = 1;
    x1_ = w_[r_ - 1];
    if (r_ != 1) {
      goto _l100;
    }
    norm_ = 0.0;
    for (j_ = 1; j_ <= mb_; (j_)++) {
      jj_ = mb_ + 1 - j_;
      kj_ = jj_ + m1_;
      ij_ = 1;
      v_ = 0.0;
      for (i_ = jj_; i_ <= (*n_); (i_)++) {
        v_ = v_ + _abs (a_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
        if ((*e21_) >= 0.0e0) {
          goto _l40;
        }
        v_ = v_ + _abs (a_[ij_ - 1 + ((*nm_)) * ((kj_ - 1))]);
        ij_ = ij_ + 1;
        _l40:;
      }
      norm_ = _max (norm_, v_);
    }
    if ((*e21_) < 0.0e0) {
      norm_ = 0.5e0 * norm_;
    }
    if (norm_ == 0.0e0) {
      norm_ = 1.0;
    }
    eps2_ = 1.0e-3 * norm_ * _abs (order_);
    eps3_ = _epslon (&norm_);
    uk_ = (*n_);
    uk_ = sqrt (uk_);
    eps4_ = uk_ * eps3_;
    _l80:;
    group_ = 0;
    goto _l120;
    _l100:;
    if (_abs (x1_ - x0_) >= eps2_) {
      goto _l80;
    }
    group_ = group_ + 1;
    if (order_ * (x1_ - x0_) <= 0.0e0) {
      x1_ = x0_ + order_ * eps3_;
    }
    _l120:;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      ij_ = i_ + _min (0, i_ - m1_) * (*n_);
      kj_ = ij_ + mb_ * (*n_);
      ij1_ = kj_ + m1_ * (*n_);
      if (m1_ == 0) {
        goto _l180;
      }
      for (j_ = 1; j_ <= m1_; (j_)++) {
        if (ij_ > m1_) {
          goto _l125;
        }
        if (ij_ > 0) {
          goto _l130;
        }
        rv_[ij1_ - 1] = 0.0;
        ij1_ = ij1_ + (*n_);
        goto _l130;
        _l125:;
        rv_[ij_ - 1] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        _l130:;
        ij_ = ij_ + (*n_);
        ii_ = i_ + j_;
        if (ii_ > (*n_)) {
          goto _l150;
        }
        jj_ = mb_ - j_;
        if ((*e21_) >= 0.0e0) {
          goto _l140;
        }
        ii_ = i_;
        jj_ = mb_ + j_;
        _l140:;
        rv_[kj_ - 1] = a_[ii_ - 1 + ((*nm_)) * ((jj_ - 1))];
        kj_ = kj_ + (*n_);
        _l150:;
      }
      _l180:;
      rv_[ij_ - 1] = a_[i_ - 1 + ((*nm_)) * ((mb_ - 1))] - x1_;
      rv6_[i_ - 1] = eps4_;
      if (order_ == 0.0e0) {
        rv6_[i_ - 1] = z_[i_ - 1 + ((*nm_)) * ((r_ - 1))];
      }
    }
    if (m1_ == 0) {
      goto _l600;
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      ii_ = i_ + 1;
      maxk_ = _min (i_ + m1_ - 1, (*n_));
      maxj_ = _min ((*n_) - i_, m21_ - 2) * (*n_);
      for (k_ = i_; k_ <= maxk_; (k_)++) {
        kj1_ = k_;
        j_ = kj1_ + (*n_);
        jj_ = j_ + maxj_;
        for (kj_ = j_; ((*n_) > 0 ? kj_ <= jj_ : kj_ >= jj_); kj_ += (*n_)) {
          rv_[kj1_ - 1] = rv_[kj_ - 1];
          kj1_ = kj_;
        }
        rv_[kj1_ - 1] = 0.0;
      }
      if (i_ == (*n_)) {
        goto _l580;
      }
      u_ = 0.0;
      maxk_ = _min (i_ + m1_, (*n_));
      maxj_ = _min ((*n_) - ii_, m21_ - 2) * (*n_);
      for (j_ = i_; j_ <= maxk_; (j_)++) {
        if (_abs (rv_[j_ - 1]) < _abs (u_)) {
          goto _l450;
        }
        u_ = rv_[j_ - 1];
        k_ = j_;
        _l450:;
      }
      j_ = i_ + (*n_);
      jj_ = j_ + maxj_;
      if (k_ == i_) {
        goto _l520;
      }
      kj_ = k_;
      for (ij_ = i_; ((*n_) > 0 ? ij_ <= jj_ : ij_ >= jj_); ij_ += (*n_)) {
        v_ = rv_[ij_ - 1];
        rv_[ij_ - 1] = rv_[kj_ - 1];
        rv_[kj_ - 1] = v_;
        kj_ = kj_ + (*n_);
      }
      if (order_ != 0.0e0) {
        goto _l520;
      }
      v_ = rv6_[i_ - 1];
      rv6_[i_ - 1] = rv6_[k_ - 1];
      rv6_[k_ - 1] = v_;
      _l520:;
      if (u_ == 0.0e0) {
        goto _l580;
      }
      for (k_ = ii_; k_ <= maxk_; (k_)++) {
        v_ = rv_[k_ - 1] / u_;
        kj_ = k_;
        for (ij_ = j_; ((*n_) > 0 ? ij_ <= jj_ : ij_ >= jj_); ij_ += (*n_)) {
          kj_ = kj_ + (*n_);
          rv_[kj_ - 1] = rv_[kj_ - 1] - v_ * rv_[ij_ - 1];
        }
        if (order_ == 0.0e0) {
          rv6_[k_ - 1] = rv6_[k_ - 1] - v_ * rv6_[i_ - 1];
        }
      }
      _l580:;
    }
    _l600:;
    for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
      i_ = (*n_) + 1 - ii_;
      maxj_ = _min (ii_, m21_);
      if (maxj_ == 1) {
        goto _l620;
      }
      ij1_ = i_;
      j_ = ij1_ + (*n_);
      jj_ = j_ + (maxj_ - 2) * (*n_);
      for (ij_ = j_; ((*n_) > 0 ? ij_ <= jj_ : ij_ >= jj_); ij_ += (*n_)) {
        ij1_ = ij1_ + 1;
        rv6_[i_ - 1] = rv6_[i_ - 1] - rv_[ij_ - 1] * rv6_[ij1_ - 1];
      }
      _l620:;
      v_ = rv_[i_ - 1];
      if (_abs (v_) >= eps3_) {
        goto _l625;
      }
      if (order_ == 0.0e0) {
        (*ierr_) = -r_;
      }
      v_ = _sign (eps3_, v_);
      _l625:;
      rv6_[i_ - 1] = rv6_[i_ - 1] / v_;
    }
    xu_ = 1.0;
    if (order_ == 0.0e0) {
      goto _l870;
    }
    if (group_ == 0) {
      goto _l700;
    }
    for (jj_ = 1; jj_ <= group_; (jj_)++) {
      j_ = r_ - group_ - 1 + jj_;
      xu_ = 0.0;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        xu_ = xu_ + rv6_[i_ - 1] * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        rv6_[i_ - 1] = rv6_[i_ - 1] - xu_ * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
    }
    _l700:;
    norm_ = 0.0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      norm_ = norm_ + _abs (rv6_[i_ - 1]);
    }
    if (norm_ >= 0.1e0) {
      goto _l840;
    }
    if (its_ >= (*n_)) {
      goto _l830;
    }
    its_ = its_ + 1;
    xu_ = eps4_ / (uk_ + 1.0e0);
    rv6_[0] = eps4_;
    for (i_ = 2; i_ <= (*n_); (i_)++) {
      rv6_[i_ - 1] = xu_;
    }
    rv6_[its_ - 1] = rv6_[its_ - 1] - eps4_ * uk_;
    goto _l600;
    _l830:;
    (*ierr_) = -r_;
    xu_ = 0.0;
    goto _l870;
    _l840:;
    u_ = 0.0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      u_ = _pythag (&u_, &rv6_[i_ - 1]);
    }
    xu_ = 1.0e0 / u_;
    _l870:;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((r_ - 1))] = rv6_[i_ - 1] * xu_;
    }
    x0_ = x1_;
  }
  _l1001:;
  __calls[4].calls++;
  return 0;
}

int_4 _bisect (int_4 _p_ n_, real_8 _p_ eps1_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, real_8 _p_ lb_, real_8 _p_ 
ub_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ w_, int_4 _p_ ind_, int_4 _p_ ierr_, real_8 _p_ rv4_, real_8 _p_ rv5_)
{
  static int_4 i_, j_, k_, l_, p_, q_, r_, s_, ii_, m1_, m2_, tag_, isturm_;
  static real_8 u_, v_, t1_, t2_, xu_, x0_, x1_, tst1_, tst2_;
  real_8 $0_, $1_;
  (*ierr_) = 0;
  tag_ = 0;
  t1_ = (*lb_);
  t2_ = (*ub_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ == 1) {
      goto _l20;
    }
    tst1_ = _abs (d_[i_ - 1]) + _abs (d_[i_ - 1 - 1]);
    tst2_ = tst1_ + _abs (e_[i_ - 1]);
    if (tst2_ > tst1_) {
      goto _l40;
    }
    _l20:;
    e2_[i_ - 1] = 0.0;
    _l40:;
  }
  p_ = 1;
  q_ = (*n_);
  x1_ = (*ub_);
  isturm_ = 1;
  goto _l320;
  _l60:;
  (*m_) = s_;
  x1_ = (*lb_);
  isturm_ = 2;
  goto _l320;
  _l80:;
  (*m_) = (*m_) - s_;
  if ((*m_) > (*mm_)) {
    goto _l980;
  }
  q_ = 0;
  r_ = 0;
  _l100:;
  if (r_ == (*m_)) {
    goto _l1001;
  }
  tag_ = tag_ + 1;
  p_ = q_ + 1;
  xu_ = d_[p_ - 1];
  x0_ = d_[p_ - 1];
  u_ = 0.0;
  for (q_ = p_; q_ <= (*n_); (q_)++) {
    x1_ = u_;
    u_ = 0.0;
    v_ = 0.0;
    if (q_ == (*n_)) {
      goto _l110;
    }
    u_ = _abs (e_[q_ + 1 - 1]);
    v_ = e2_[q_ + 1 - 1];
    _l110:;
    xu_ = _min (d_[q_ - 1] - (x1_ + u_), xu_);
    x0_ = _max (d_[q_ - 1] + (x1_ + u_), x0_);
    if (v_ == 0.0e0) {
      goto _l140;
    }
  }
  _l140:;
  x1_ = _epslon (($0_ = _max (_abs (xu_), _abs (x0_)), &$0_));
  if ((*eps1_) <= 0.0e0) {
    (*eps1_) = -x1_;
  }
  if (p_ != q_) {
    goto _l180;
  }
  if (t1_ > d_[p_ - 1] || d_[p_ - 1] >= t2_) {
    goto _l940;
  }
  m1_ = p_;
  m2_ = p_;
  rv5_[p_ - 1] = d_[p_ - 1];
  goto _l900;
  _l180:;
  x1_ = x1_ * (q_ - p_ + 1);
  (*lb_) = _max (t1_, xu_ - x1_);
  (*ub_) = _min (t2_, x0_ + x1_);
  x1_ = (*lb_);
  isturm_ = 3;
  goto _l320;
  _l200:;
  m1_ = s_ + 1;
  x1_ = (*ub_);
  isturm_ = 4;
  goto _l320;
  _l220:;
  m2_ = s_;
  if (m1_ > m2_) {
    goto _l940;
  }
  x0_ = (*ub_);
  isturm_ = 5;
  for (i_ = m1_; i_ <= m2_; (i_)++) {
    rv5_[i_ - 1] = (*ub_);
    rv4_[i_ - 1] = (*lb_);
  }
  k_ = m2_;
  _l250:;
  xu_ = (*lb_);
  for (ii_ = m1_; ii_ <= k_; (ii_)++) {
    i_ = m1_ + k_ - ii_;
    if (xu_ >= rv4_[i_ - 1]) {
      goto _l260;
    }
    xu_ = rv4_[i_ - 1];
    goto _l280;
    _l260:;
  }
  _l280:;
  if (x0_ > rv5_[k_ - 1]) {
    x0_ = rv5_[k_ - 1];
  }
  _l300:;
  x1_ = (xu_ + x0_) * 0.5e0;
  if ((x0_ - xu_) <= _abs ((*eps1_))) {
    goto _l420;
  }
  tst1_ = 2.0e0 * (_abs (xu_) + _abs (x0_));
  tst2_ = tst1_ + (x0_ - xu_);
  if (tst2_ == tst1_) {
    goto _l420;
  }
  _l320:;
  s_ = p_ - 1;
  u_ = 1.0;
  for (i_ = p_; i_ <= q_; (i_)++) {
    if (u_ != 0.0e0) {
      goto _l325;
    }
    v_ = _abs (e_[i_ - 1]) / _epslon (($1_ = 1.0, &$1_));
    if (e2_[i_ - 1] == 0.0e0) {
      v_ = 0.0;
    }
    goto _l330;
    _l325:;
    v_ = e2_[i_ - 1] / u_;
    _l330:;
    u_ = d_[i_ - 1] - x1_ - v_;
    if (u_ < 0.0e0) {
      s_ = s_ + 1;
    }
  }
  switch (isturm_) {
    default:
    case 1: goto _l60;
    case 2: goto _l80;
    case 3: goto _l200;
    case 4: goto _l220;
    case 5: goto _l360;
  }
  _l360:;
  if (s_ >= k_) {
    goto _l400;
  }
  xu_ = x1_;
  if (s_ >= m1_) {
    goto _l380;
  }
  rv4_[m1_ - 1] = x1_;
  goto _l300;
  _l380:;
  rv4_[s_ + 1 - 1] = x1_;
  if (rv5_[s_ - 1] > x1_) {
    rv5_[s_ - 1] = x1_;
  }
  goto _l300;
  _l400:;
  x0_ = x1_;
  goto _l300;
  _l420:;
  rv5_[k_ - 1] = x1_;
  k_ = k_ - 1;
  if (k_ >= m1_) {
    goto _l250;
  }
  _l900:;
  s_ = r_;
  r_ = r_ + m2_ - m1_ + 1;
  j_ = 1;
  k_ = m1_;
  for (l_ = 1; l_ <= r_; (l_)++) {
    if (j_ > s_) {
      goto _l910;
    }
    if (k_ > m2_) {
      goto _l940;
    }
    if (rv5_[k_ - 1] >= w_[l_ - 1]) {
      goto _l915;
    }
    for (ii_ = j_; ii_ <= s_; (ii_)++) {
      i_ = l_ + s_ - ii_;
      w_[i_ + 1 - 1] = w_[i_ - 1];
      ind_[i_ + 1 - 1] = ind_[i_ - 1];
    }
    _l910:;
    w_[l_ - 1] = rv5_[k_ - 1];
    ind_[l_ - 1] = tag_;
    k_ = k_ + 1;
    goto _l920;
    _l915:;
    j_ = j_ + 1;
    _l920:;
  }
  _l940:;
  if (q_ < (*n_)) {
    goto _l100;
  }
  goto _l1001;
  _l980:;
  (*ierr_) = 3 * (*n_) + 1;
  _l1001:;
  (*lb_) = t1_;
  (*ub_) = t2_;
  __calls[5].calls++;
  return 0;
}

int_4 _bqr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ mb_, real_8 _p_ a_, real_8 _p_ t_, real_8 _p_ r_, int_4 _p_ ierr_, 
int_4 _p_ nv_, real_8 _p_ rv_)
{
  static int_4 i_, j_, k_, l_, m_, ii_, ik_, jk_, jm_, kj_, kk_, km_, ll_, mk_, mn_, mz_, m1_, m2_, m3_, m4_, ni_, its_, 
  kj1_, m21_, m31_, imult_;
  static real_8 f_, g_, q_, s_, tst1_, tst2_, scale_;
  real_8 $0_, $1_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  m1_ = _min ((*mb_), (*n_));
  m_ = m1_ - 1;
  m2_ = m_ + m_;
  m21_ = m2_ + 1;
  m3_ = m21_ + m_;
  m31_ = m3_ + 1;
  m4_ = m31_ + m2_;
  mn_ = m_ + (*n_);
  mz_ = (*mb_) - m1_;
  its_ = 0;
  _l40:;
  g_ = a_[(*n_) - 1 + ((*nm_)) * (((*mb_) - 1))];
  if (m_ == 0) {
    goto _l360;
  }
  f_ = 0.0;
  for (k_ = 1; k_ <= m_; (k_)++) {
    mk_ = k_ + mz_;
    f_ = f_ + _abs (a_[(*n_) - 1 + ((*nm_)) * ((mk_ - 1))]);
  }
  if (its_ == 0 && f_ > (*r_)) {
    (*r_) = f_;
  }
  tst1_ = (*r_);
  tst2_ = tst1_ + f_;
  if (tst2_ <= tst1_) {
    goto _l360;
  }
  if (its_ == 30) {
    goto _l1000;
  }
  its_ = its_ + 1;
  if (f_ > 0.25e0 * (*r_) && its_ < 5) {
    goto _l90;
  }
  f_ = a_[(*n_) - 1 + ((*nm_)) * (((*mb_) - 1 - 1))];
  if (f_ == 0.0e0) {
    goto _l70;
  }
  q_ = (a_[(*n_) - 1 - 1 + ((*nm_)) * (((*mb_) - 1))] - g_) / (2.0e0 * f_);
  s_ = _pythag (&q_, ($0_ = 1.0, &$0_));
  g_ = g_ - f_ / (q_ + _sign (s_, q_));
  _l70:;
  (*t_) = (*t_) + g_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    a_[i_ - 1 + ((*nm_)) * (((*mb_) - 1))] = a_[i_ - 1 + ((*nm_)) * (((*mb_) - 1))] - g_;
  }
  _l90:;
  for (k_ = m31_; k_ <= m4_; (k_)++) {
    rv_[k_ - 1] = 0.0;
  }
  for (ii_ = 1; ii_ <= mn_; (ii_)++) {
    i_ = ii_ - m_;
    ni_ = (*n_) - ii_;
    if (ni_ < 0) {
      goto _l230;
    }
    l_ = _max (1, 2 - i_);
    for (k_ = 1; k_ <= m3_; (k_)++) {
      rv_[k_ - 1] = 0.0;
    }
    for (k_ = l_; k_ <= m1_; (k_)++) {
      km_ = k_ + m_;
      mk_ = k_ + mz_;
      rv_[km_ - 1] = a_[ii_ - 1 + ((*nm_)) * ((mk_ - 1))];
    }
    ll_ = _min (m_, ni_);
    if (ll_ == 0) {
      goto _l135;
    }
    for (k_ = 1; k_ <= ll_; (k_)++) {
      km_ = k_ + m21_;
      ik_ = ii_ + k_;
      mk_ = (*mb_) - k_;
      rv_[km_ - 1] = a_[ik_ - 1 + ((*nm_)) * ((mk_ - 1))];
    }
    _l135:;
    ll_ = m2_;
    imult_ = 0;
    _l140:;
    kj_ = m4_ - m1_;
    for (j_ = 1; j_ <= ll_; (j_)++) {
      kj_ = kj_ + m1_;
      jm_ = j_ + m3_;
      if (rv_[jm_ - 1] == 0.0e0) {
        goto _l170;
      }
      f_ = 0.0;
      for (k_ = 1; k_ <= m1_; (k_)++) {
        kj_ = kj_ + 1;
        jk_ = j_ + k_ - 1;
        f_ = f_ + rv_[kj_ - 1] * rv_[jk_ - 1];
      }
      f_ = f_ / rv_[jm_ - 1];
      kj_ = kj_ - m1_;
      for (k_ = 1; k_ <= m1_; (k_)++) {
        kj_ = kj_ + 1;
        jk_ = j_ + k_ - 1;
        rv_[jk_ - 1] = rv_[jk_ - 1] - rv_[kj_ - 1] * f_;
      }
      kj_ = kj_ - m1_;
      _l170:;
    }
    if (imult_ != 0) {
      goto _l280;
    }
    f_ = rv_[m21_ - 1];
    s_ = 0.0;
    rv_[m4_ - 1] = 0.0;
    scale_ = 0.0;
    for (k_ = m21_; k_ <= m3_; (k_)++) {
      scale_ = scale_ + _abs (rv_[k_ - 1]);
    }
    if (scale_ == 0.0e0) {
      goto _l210;
    }
    for (k_ = m21_; k_ <= m3_; (k_)++) {
      s_ = s_ + ($1_ = (rv_[k_ - 1] / scale_), $1_ * $1_);
    }
    s_ = scale_ * scale_ * s_;
    g_ = -_sign (sqrt (s_), f_);
    rv_[m21_ - 1] = g_;
    rv_[m4_ - 1] = s_ - f_ * g_;
    kj_ = m4_ + m2_ * m1_ + 1;
    rv_[kj_ - 1] = f_ - g_;
    for (k_ = 2; k_ <= m1_; (k_)++) {
      kj_ = kj_ + 1;
      km_ = k_ + m2_;
      rv_[kj_ - 1] = rv_[km_ - 1];
    }
    _l210:;
    for (k_ = l_; k_ <= m1_; (k_)++) {
      km_ = k_ + m_;
      mk_ = k_ + mz_;
      a_[ii_ - 1 + ((*nm_)) * ((mk_ - 1))] = rv_[km_ - 1];
    }
    _l230:;
    l_ = _max (1, m1_ + 1 - i_);
    if (i_ <= 0) {
      goto _l300;
    }
    for (k_ = 1; k_ <= m21_; (k_)++) {
      rv_[k_ - 1] = 0.0;
    }
    ll_ = _min (m1_, ni_ + m1_);
    for (kk_ = 1; kk_ <= ll_; (kk_)++) {
      k_ = kk_ - 1;
      km_ = k_ + m1_;
      ik_ = i_ + k_;
      mk_ = (*mb_) - k_;
      rv_[km_ - 1] = a_[ik_ - 1 + ((*nm_)) * ((mk_ - 1))];
    }
    ll_ = m1_;
    imult_ = 1;
    goto _l140;
    _l280:;
    for (k_ = l_; k_ <= m1_; (k_)++) {
      mk_ = k_ + mz_;
      a_[i_ - 1 + ((*nm_)) * ((mk_ - 1))] = rv_[k_ - 1];
    }
    _l300:;
    if (l_ > 1) {
      l_ = l_ - 1;
    }
    kj1_ = m4_ + l_ * m1_;
    for (j_ = l_; j_ <= m2_; (j_)++) {
      jm_ = j_ + m3_;
      rv_[jm_ - 1] = rv_[jm_ + 1 - 1];
      for (k_ = 1; k_ <= m1_; (k_)++) {
        kj1_ = kj1_ + 1;
        kj_ = kj1_ - m1_;
        rv_[kj_ - 1] = rv_[kj1_ - 1];
      }
    }
  }
  goto _l40;
  _l360:;
  (*t_) = (*t_) + g_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    a_[i_ - 1 + ((*nm_)) * (((*mb_) - 1))] = a_[i_ - 1 + ((*nm_)) * (((*mb_) - 1))] - g_;
  }
  for (k_ = 1; k_ <= m1_; (k_)++) {
    mk_ = k_ + mz_;
    a_[(*n_) - 1 + ((*nm_)) * ((mk_ - 1))] = 0.0;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = (*n_);
  _l1001:;
  __calls[6].calls++;
  return 0;
}

int_4 _cbabk2 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ scale_, int_4 _p_ m_, real_8 _p_ 
zr_, real_8 _p_ zi_)
{
  static int_4 i_, j_, k_, ii_;
  static real_8 s_;
  if ((*m_) == 0) {
    goto _l200;
  }
  if ((*igh_) == (*low_)) {
    goto _l120;
  }
  for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
    s_ = scale_[i_ - 1];
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * s_;
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * s_;
    }
  }
  _l120:;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = ii_;
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l140;
    }
    if (i_ < (*low_)) {
      i_ = (*low_) - ii_;
    }
    k_ = (int_4) (_aintd (scale_[i_ - 1]));
    if (k_ == i_) {
      goto _l140;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      s_ = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = s_;
      s_ = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = s_;
    }
    _l140:;
  }
  _l200:;
  __calls[7].calls++;
  return 0;
}

int_4 _cbal (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ 
scale_)
{
  static int_4 i_, j_, k_, l_, m_, jj_, iexc_;
  static logical_4 noconv_;
  static real_8 c_, f_, g_, r_, s_, b2_, radix_;
  radix_ = 16.0;
  b2_ = radix_ * radix_;
  k_ = 1;
  l_ = (*n_);
  goto _l100;
  _l20:;
  scale_[m_ - 1] = j_;
  if (j_ == m_) {
    goto _l50;
  }
  for (i_ = 1; i_ <= l_; (i_)++) {
    f_ = ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ar_[i_ - 1 + ((*nm_)) * ((m_ - 1))];
    ar_[i_ - 1 + ((*nm_)) * ((m_ - 1))] = f_;
    f_ = ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ai_[i_ - 1 + ((*nm_)) * ((m_ - 1))];
    ai_[i_ - 1 + ((*nm_)) * ((m_ - 1))] = f_;
  }
  for (i_ = k_; i_ <= (*n_); (i_)++) {
    f_ = ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
    ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = ar_[m_ - 1 + ((*nm_)) * ((i_ - 1))];
    ar_[m_ - 1 + ((*nm_)) * ((i_ - 1))] = f_;
    f_ = ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
    ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = ai_[m_ - 1 + ((*nm_)) * ((i_ - 1))];
    ai_[m_ - 1 + ((*nm_)) * ((i_ - 1))] = f_;
  }
  _l50:;
  switch (iexc_) {
    default:
    case 1: goto _l80;
    case 2: goto _l130;
  }
  _l80:;
  if (l_ == 1) {
    goto _l280;
  }
  l_ = l_ - 1;
  _l100:;
  for (jj_ = 1; jj_ <= l_; (jj_)++) {
    j_ = l_ + 1 - jj_;
    for (i_ = 1; i_ <= l_; (i_)++) {
      if (i_ == j_) {
        goto _l110;
      }
      if (ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))] != 0.0e0 || ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))] != 0.0e0) {
        goto _l120;
      }
      _l110:;
    }
    m_ = l_;
    iexc_ = 1;
    goto _l20;
    _l120:;
  }
  goto _l140;
  _l130:;
  k_ = k_ + 1;
  _l140:;
  for (j_ = k_; j_ <= l_; (j_)++) {
    for (i_ = k_; i_ <= l_; (i_)++) {
      if (i_ == j_) {
        goto _l150;
      }
      if (ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] != 0.0e0 || ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] != 0.0e0) {
        goto _l170;
      }
      _l150:;
    }
    m_ = k_;
    iexc_ = 2;
    goto _l20;
    _l170:;
  }
  for (i_ = k_; i_ <= l_; (i_)++) {
    scale_[i_ - 1] = 1.0;
  }
  _l190:;
  noconv_ = FALSE;
  for (i_ = k_; i_ <= l_; (i_)++) {
    c_ = 0.0;
    r_ = 0.0;
    for (j_ = k_; j_ <= l_; (j_)++) {
      if (j_ == i_) {
        goto _l200;
      }
      c_ = c_ + _abs (ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))]) + _abs (ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))]);
      r_ = r_ + _abs (ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))]) + _abs (ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      _l200:;
    }
    if (c_ == 0.0e0 || r_ == 0.0e0) {
      goto _l270;
    }
    g_ = r_ / radix_;
    f_ = 1.0;
    s_ = c_ + r_;
    _l210:;
    if (c_ >= g_) {
      goto _l220;
    }
    f_ = f_ * radix_;
    c_ = c_ * b2_;
    goto _l210;
    _l220:;
    g_ = r_ * radix_;
    _l230:;
    if (c_ < g_) {
      goto _l240;
    }
    f_ = f_ / radix_;
    c_ = c_ / b2_;
    goto _l230;
    _l240:;
    if ((c_ + r_) / f_ >= 0.95e0 * s_) {
      goto _l270;
    }
    g_ = 1.0e0 / f_;
    scale_[i_ - 1] = scale_[i_ - 1] * f_;
    noconv_ = TRUE;
    for (j_ = k_; j_ <= (*n_); (j_)++) {
      ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * g_;
      ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * g_;
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))] * f_;
      ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))] * f_;
    }
    _l270:;
  }
  if (noconv_) {
    goto _l190;
  }
  _l280:;
  (*low_) = k_;
  (*igh_) = l_;
  __calls[8].calls++;
  return 0;
}

int_4 _cdiv (real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ br_, real_8 _p_ bi_, real_8 _p_ cr_, real_8 _p_ ci_)
{
  static real_8 s_, ars_, ais_, brs_, bis_;
  s_ = _abs ((*br_)) + _abs ((*bi_));
  ars_ = (*ar_) / s_;
  ais_ = (*ai_) / s_;
  brs_ = (*br_) / s_;
  bis_ = (*bi_) / s_;
  s_ = (brs_ * brs_) + (bis_ * bis_);
  (*cr_) = (ars_ * brs_ + ais_ * bis_) / s_;
  (*ci_) = (ais_ * brs_ - ars_ * bis_) / s_;
  __calls[9].calls++;
  return 0;
}

int_4 _cg (int_4 _p_ nm_, int_4 _p_ n_, real_4 _p_ ar_, real_4 _p_ ai_, real_4 _p_ wr_, real_4 _p_ wi_, int_4 _p_ matz_
, real_4 _p_ zr_, real_4 _p_ zi_, real_4 _p_ fv1_, real_4 _p_ fv2_, real_4 _p_ fv3_, int_4 _p_ ierr_)
{
  static int_4 is1_, is2_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _cbal (nm_, n_, ar_, ai_, &is1_, &is2_, fv1_);
  (void) _corth (nm_, n_, &is1_, &is2_, ar_, ai_, fv2_, fv3_);
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _comqr (nm_, n_, &is1_, &is2_, ar_, ai_, wr_, wi_, ierr_);
  goto _l50;
  _l20:;
  (void) _comqr2 (nm_, n_, &is1_, &is2_, fv2_, fv3_, ar_, ai_, wr_, wi_, zr_, zi_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _cbabk2 (nm_, n_, &is1_, &is2_, fv1_, n_, zr_, zi_);
  _l50:;
  __calls[10].calls++;
  return 0;
}

int_4 _cglr (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ 
matz_, real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fv1_, int_4 _p_ iv1_, int_4 _p_ ierr_)
{
  static int_4 is1_, is2_;
  if ((*nm_) < (*n_)) {
    (*ierr_) = 10 * (*n_);
    goto _l0;
  }
  (void) _cbal (nm_, n_, ar_, ai_, &is1_, &is2_, fv1_);
  (void) _comhes (nm_, n_, &is1_, &is2_, ar_, ai_, iv1_);
  if ((*matz_) == 0) {
    (void) _comlr (nm_, n_, &is1_, &is2_, ar_, ai_, wr_, wi_, ierr_);
  }
  else {
    (void) _comlr2 (nm_, n_, &is1_, &is2_, iv1_, ar_, ai_, wr_, wi_, zr_, zi_, ierr_);
    if ((*ierr_) != 0) {
      goto _l0;
    }
    (void) _cbabk2 (nm_, n_, &is1_, &is2_, fv1_, n_, zr_, zi_);
  }
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _cgqr (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ 
matz_, real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fv1_, real_8 _p_ fv2_, real_8 _p_ fv3_, int_4 _p_ ierr_)
{
  static int_4 is1_, is2_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _cbal (nm_, n_, ar_, ai_, &is1_, &is2_, fv1_);
  (void) _corth (nm_, n_, &is1_, &is2_, ar_, ai_, fv2_, fv3_);
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _comqr (nm_, n_, &is1_, &is2_, ar_, ai_, wr_, wi_, ierr_);
  goto _l50;
  _l20:;
  (void) _comqr2 (nm_, n_, &is1_, &is2_, fv2_, fv3_, ar_, ai_, wr_, wi_, zr_, zi_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _cbabk2 (nm_, n_, &is1_, &is2_, fv1_, n_, zr_, zi_);
  _l50:;
  __calls[12].calls++;
  return 0;
}

int_4 _ch3 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ zr_, real_8 _p_ zi_, 
real_8 _p_ fv1_, real_8 _p_ fv2_, real_8 _p_ fm1_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _htrid3 (nm_, n_, a_, w_, fv1_, fv2_, fm1_);
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _tqlrat (n_, w_, fv2_, ierr_);
  goto _l50;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      zr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
    zr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = 1.0;
  }
  (void) _tql2 (nm_, n_, w_, fv1_, zr_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _htrib3 (nm_, n_, a_, fm1_, n_, zr_, zi_);
  _l50:;
  __calls[13].calls++;
  return 0;
}

int_4 _ch (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ zr_, 
real_8 _p_ zi_, real_8 _p_ fv1_, real_8 _p_ fv2_, real_8 _p_ fm1_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _htridi (nm_, n_, ar_, ai_, w_, fv1_, fv2_, fm1_);
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _tqlrat (n_, w_, fv2_, ierr_);
  goto _l50;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      zr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
    zr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = 1.0;
  }
  (void) _tql2 (nm_, n_, w_, fv1_, zr_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _htribk (nm_, n_, ar_, ai_, fm1_, n_, zr_, zi_);
  _l50:;
  __calls[14].calls++;
  return 0;
}

int_4 _cinvit (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ wr_, real_8 _p_ wi_, logical_4 
_p_ select_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ zr_, real_8 _p_ zi_, int_4 _p_ ierr_, real_8 _p_ rm1_, real_8 _p_ 
rm2_, real_8 _p_ rv1_, real_8 _p_ rv2_)
{
  static int_4 i_, j_, k_, s_, ii_, mp_, uk_, ip1_, its_, km1_;
  static real_8 x_, y_, eps3_, norm_, normv_, growto_, ilambd_, rlambd_, ukroot_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  uk_ = 0;
  s_ = 1;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (! (select_[k_ - 1])) {
      goto _l980;
    }
    if (s_ > (*mm_)) {
      goto _l1000;
    }
    if (uk_ >= k_) {
      goto _l200;
    }
    for (uk_ = k_; uk_ <= (*n_); (uk_)++) {
      if (uk_ == (*n_)) {
        goto _l140;
      }
      if (ar_[uk_ + 1 - 1 + ((*nm_)) * ((uk_ - 1))] == 0.0e0 && ai_[uk_ + 1 - 1 + ((*nm_)) * ((uk_ - 1))] == 0.0e0) {
        goto _l140;
      }
    }
    _l140:;
    norm_ = 0.0;
    mp_ = 1;
    for (i_ = 1; i_ <= uk_; (i_)++) {
      x_ = 0.0;
      for (j_ = mp_; j_ <= uk_; (j_)++) {
        x_ = x_ + _pythag (&ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))], &ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      }
      if (x_ > norm_) {
        norm_ = x_;
      }
      mp_ = i_;
    }
    if (norm_ == 0.0e0) {
      norm_ = 1.0;
    }
    eps3_ = _epslon (&norm_);
    ukroot_ = uk_;
    ukroot_ = sqrt (ukroot_);
    growto_ = 0.1e0 / ukroot_;
    _l200:;
    rlambd_ = wr_[k_ - 1];
    ilambd_ = wi_[k_ - 1];
    if (k_ == 1) {
      goto _l280;
    }
    km1_ = k_ - 1;
    goto _l240;
    _l220:;
    rlambd_ = rlambd_ + eps3_;
    _l240:;
    for (ii_ = 1; ii_ <= km1_; (ii_)++) {
      i_ = k_ - ii_;
      if (select_[i_ - 1] && _abs (wr_[i_ - 1] - rlambd_) < eps3_ && _abs (wi_[i_ - 1] - ilambd_) < eps3_) {
        goto _l220;
      }
    }
    wr_[k_ - 1] = rlambd_;
    _l280:;
    mp_ = 1;
    for (i_ = 1; i_ <= uk_; (i_)++) {
      for (j_ = mp_; j_ <= uk_; (j_)++) {
        rm1_[i_ - 1 + ((*n_)) * ((j_ - 1))] = ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        rm2_[i_ - 1 + ((*n_)) * ((j_ - 1))] = ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))] = rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))] - rlambd_;
      rm2_[i_ - 1 + ((*n_)) * ((i_ - 1))] = rm2_[i_ - 1 + ((*n_)) * ((i_ - 1))] - ilambd_;
      mp_ = i_;
      rv1_[i_ - 1] = eps3_;
    }
    if (uk_ == 1) {
      goto _l420;
    }
    for (i_ = 2; i_ <= uk_; (i_)++) {
      mp_ = i_ - 1;
      if (_pythag (&rm1_[i_ - 1 + ((*n_)) * ((mp_ - 1))], &rm2_[i_ - 1 + ((*n_)) * ((mp_ - 1))]) <= _pythag (&rm1_[mp_ - 1 + 
        ((*n_)) * ((mp_ - 1))], &rm2_[mp_ - 1 + ((*n_)) * ((mp_ - 1))])) {
        goto _l360;
      }
      for (j_ = mp_; j_ <= uk_; (j_)++) {
        y_ = rm1_[i_ - 1 + ((*n_)) * ((j_ - 1))];
        rm1_[i_ - 1 + ((*n_)) * ((j_ - 1))] = rm1_[mp_ - 1 + ((*n_)) * ((j_ - 1))];
        rm1_[mp_ - 1 + ((*n_)) * ((j_ - 1))] = y_;
        y_ = rm2_[i_ - 1 + ((*n_)) * ((j_ - 1))];
        rm2_[i_ - 1 + ((*n_)) * ((j_ - 1))] = rm2_[mp_ - 1 + ((*n_)) * ((j_ - 1))];
        rm2_[mp_ - 1 + ((*n_)) * ((j_ - 1))] = y_;
      }
      _l360:;
      if (rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] == 0.0e0 && rm2_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] == 0.0e0) {
        rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] = eps3_;
      }
      (void) _cdiv (&rm1_[i_ - 1 + ((*n_)) * ((mp_ - 1))], &rm2_[i_ - 1 + ((*n_)) * ((mp_ - 1))], &rm1_[mp_ - 1 + ((*n_)) * 
      ((mp_ - 1))], &rm2_[mp_ - 1 + ((*n_)) * ((mp_ - 1))], &x_, &y_);
      if (x_ == 0.0e0 && y_ == 0.0e0) {
        goto _l400;
      }
      for (j_ = i_; j_ <= uk_; (j_)++) {
        rm1_[i_ - 1 + ((*n_)) * ((j_ - 1))] = rm1_[i_ - 1 + ((*n_)) * ((j_ - 1))] - x_ * rm1_[mp_ - 1 + ((*n_)) * ((j_ - 1))] + 
        y_ * rm2_[mp_ - 1 + ((*n_)) * ((j_ - 1))];
        rm2_[i_ - 1 + ((*n_)) * ((j_ - 1))] = rm2_[i_ - 1 + ((*n_)) * ((j_ - 1))] - x_ * rm2_[mp_ - 1 + ((*n_)) * ((j_ - 1))] - 
        y_ * rm1_[mp_ - 1 + ((*n_)) * ((j_ - 1))];
      }
      _l400:;
    }
    _l420:;
    if (rm1_[uk_ - 1 + ((*n_)) * ((uk_ - 1))] == 0.0e0 && rm2_[uk_ - 1 + ((*n_)) * ((uk_ - 1))] == 0.0e0) {
      rm1_[uk_ - 1 + ((*n_)) * ((uk_ - 1))] = eps3_;
    }
    its_ = 0;
    _l660:;
    for (ii_ = 1; ii_ <= uk_; (ii_)++) {
      i_ = uk_ + 1 - ii_;
      x_ = rv1_[i_ - 1];
      y_ = 0.0;
      if (i_ == uk_) {
        goto _l700;
      }
      ip1_ = i_ + 1;
      for (j_ = ip1_; j_ <= uk_; (j_)++) {
        x_ = x_ - rm1_[i_ - 1 + ((*n_)) * ((j_ - 1))] * rv1_[j_ - 1] + rm2_[i_ - 1 + ((*n_)) * ((j_ - 1))] * rv2_[j_ - 1];
        y_ = y_ - rm1_[i_ - 1 + ((*n_)) * ((j_ - 1))] * rv2_[j_ - 1] - rm2_[i_ - 1 + ((*n_)) * ((j_ - 1))] * rv1_[j_ - 1];
      }
      _l700:;
      (void) _cdiv (&x_, &y_, &rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))], &rm2_[i_ - 1 + ((*n_)) * ((i_ - 1))], &rv1_[i_ - 1], 
      &rv2_[i_ - 1]);
    }
    its_ = its_ + 1;
    norm_ = 0.0;
    normv_ = 0.0;
    for (i_ = 1; i_ <= uk_; (i_)++) {
      x_ = _pythag (&rv1_[i_ - 1], &rv2_[i_ - 1]);
      if (normv_ >= x_) {
        goto _l760;
      }
      normv_ = x_;
      j_ = i_;
      _l760:;
      norm_ = norm_ + x_;
    }
    if (norm_ < growto_) {
      goto _l840;
    }
    x_ = rv1_[j_ - 1];
    y_ = rv2_[j_ - 1];
    for (i_ = 1; i_ <= uk_; (i_)++) {
      (void) _cdiv (&rv1_[i_ - 1], &rv2_[i_ - 1], &x_, &y_, &zr_[i_ - 1 + ((*nm_)) * ((s_ - 1))], &zi_[i_ - 1 + ((*nm_)) * 
      ((s_ - 1))]);
    }
    if (uk_ == (*n_)) {
      goto _l940;
    }
    j_ = uk_ + 1;
    goto _l900;
    _l840:;
    if (its_ >= uk_) {
      goto _l880;
    }
    x_ = ukroot_;
    y_ = eps3_ / (x_ + 1.0e0);
    rv1_[0] = eps3_;
    for (i_ = 2; i_ <= uk_; (i_)++) {
      rv1_[i_ - 1] = y_;
    }
    j_ = uk_ - its_ + 1;
    rv1_[j_ - 1] = rv1_[j_ - 1] - eps3_ * x_;
    goto _l660;
    _l880:;
    j_ = 1;
    (*ierr_) = -k_;
    _l900:;
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      zr_[i_ - 1 + ((*nm_)) * ((s_ - 1))] = 0.0;
      zi_[i_ - 1 + ((*nm_)) * ((s_ - 1))] = 0.0;
    }
    _l940:;
    s_ = s_ + 1;
    _l980:;
  }
  goto _l1001;
  _l1000:;
  if ((*ierr_) != 0) {
    (*ierr_) = (*ierr_) - (*n_);
  }
  if ((*ierr_) == 0) {
    (*ierr_) = -(2 * (*n_) + 1);
  }
  _l1001:;
  (*m_) = s_ - 1;
  __calls[15].calls++;
  return 0;
}

int_4 _combak (int_4 _p_ nm_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ar_, real_8 _p_ ai_, int_4 _p_ int_, int_4 _p_ 
m_, real_8 _p_ zr_, real_8 _p_ zi_)
{
  static int_4 i_, j_, la_, mm_, mp_, kp1_, mp1_;
  static real_8 xr_, xi_;
  if ((*m_) == 0) {
    goto _l200;
  }
  la_ = (*igh_) - 1;
  kp1_ = (*low_) + 1;
  if (la_ < kp1_) {
    goto _l200;
  }
  for (mm_ = kp1_; mm_ <= la_; (mm_)++) {
    mp_ = (*low_) + (*igh_) - mm_;
    mp1_ = mp_ + 1;
    for (i_ = mp1_; i_ <= (*igh_); (i_)++) {
      xr_ = ar_[i_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
      xi_ = ai_[i_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
      if (xr_ == 0.0e0 && xi_ == 0.0e0) {
        goto _l110;
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + xr_ * zr_[mp_ - 1 + ((*nm_)) * ((j_ - 1))] 
        - xi_ * zi_[mp_ - 1 + ((*nm_)) * ((j_ - 1))];
        zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + xr_ * zi_[mp_ - 1 + ((*nm_)) * ((j_ - 1))] 
        + xi_ * zr_[mp_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      _l110:;
    }
    i_ = int_[mp_ - 1];
    if (i_ == mp_) {
      goto _l140;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      xr_ = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[mp_ - 1 + ((*nm_)) * ((j_ - 1))];
      zr_[mp_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_;
      xi_ = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zi_[mp_ - 1 + ((*nm_)) * ((j_ - 1))];
      zi_[mp_ - 1 + ((*nm_)) * ((j_ - 1))] = xi_;
    }
    _l140:;
  }
  _l200:;
  __calls[16].calls++;
  return 0;
}

int_4 _comhes (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ar_, real_8 _p_ ai_, int_4 _p_ 
int_)
{
  static int_4 i_, j_, m_, la_, kp1_, mm1_, mp1_;
  static real_8 xr_, xi_, yr_, yi_;
  int_4 inte_[((*igh_))];
  la_ = (*igh_) - 1;
  kp1_ = (*low_) + 1;
  if (la_ < kp1_) {
    goto _l200;
  }
  for (m_ = kp1_; m_ <= la_; (m_)++) {
    mm1_ = m_ - 1;
    xr_ = 0.0;
    xi_ = 0.0;
    i_ = m_;
    for (j_ = m_; j_ <= (*igh_); (j_)++) {
      if (_abs (ar_[j_ - 1 + ((*nm_)) * ((mm1_ - 1))]) + _abs (ai_[j_ - 1 + ((*nm_)) * ((mm1_ - 1))]) <= _abs (xr_) + _abs 
        (xi_)) {
        goto _l100;
      }
      xr_ = ar_[j_ - 1 + ((*nm_)) * ((mm1_ - 1))];
      xi_ = ai_[j_ - 1 + ((*nm_)) * ((mm1_ - 1))];
      i_ = j_;
      _l100:;
    }
    inte_[m_ - 1] = i_;
    if (i_ == m_) {
      goto _l130;
    }
    for (j_ = mm1_; j_ <= (*n_); (j_)++) {
      yr_ = ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ar_[m_ - 1 + ((*nm_)) * ((j_ - 1))];
      ar_[m_ - 1 + ((*nm_)) * ((j_ - 1))] = yr_;
      yi_ = ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ai_[m_ - 1 + ((*nm_)) * ((j_ - 1))];
      ai_[m_ - 1 + ((*nm_)) * ((j_ - 1))] = yi_;
    }
    for (j_ = 1; j_ <= (*igh_); (j_)++) {
      yr_ = ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = ar_[j_ - 1 + ((*nm_)) * ((m_ - 1))];
      ar_[j_ - 1 + ((*nm_)) * ((m_ - 1))] = yr_;
      yi_ = ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = ai_[j_ - 1 + ((*nm_)) * ((m_ - 1))];
      ai_[j_ - 1 + ((*nm_)) * ((m_ - 1))] = yi_;
    }
    _l130:;
    if (xr_ == 0.0e0 && xi_ == 0.0e0) {
      goto _l180;
    }
    mp1_ = m_ + 1;
    for (i_ = mp1_; i_ <= (*igh_); (i_)++) {
      yr_ = ar_[i_ - 1 + ((*nm_)) * ((mm1_ - 1))];
      yi_ = ai_[i_ - 1 + ((*nm_)) * ((mm1_ - 1))];
      if (yr_ == 0.0e0 && yi_ == 0.0e0) {
        goto _l160;
      }
      (void) _cdiv (&yr_, &yi_, &xr_, &xi_, &yr_, &yi_);
      ar_[i_ - 1 + ((*nm_)) * ((mm1_ - 1))] = yr_;
      ai_[i_ - 1 + ((*nm_)) * ((mm1_ - 1))] = yi_;
      for (j_ = m_; j_ <= (*n_); (j_)++) {
        ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - yr_ * ar_[m_ - 1 + ((*nm_)) * ((j_ - 1))] + 
        yi_ * ai_[m_ - 1 + ((*nm_)) * ((j_ - 1))];
        ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - yr_ * ai_[m_ - 1 + ((*nm_)) * ((j_ - 1))] - 
        yi_ * ar_[m_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      for (j_ = 1; j_ <= (*igh_); (j_)++) {
        ar_[j_ - 1 + ((*nm_)) * ((m_ - 1))] = ar_[j_ - 1 + ((*nm_)) * ((m_ - 1))] + yr_ * ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))] - 
        yi_ * ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
        ai_[j_ - 1 + ((*nm_)) * ((m_ - 1))] = ai_[j_ - 1 + ((*nm_)) * ((m_ - 1))] + yr_ * ai_[j_ - 1 + ((*nm_)) * ((i_ - 1))] + 
        yi_ * ar_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
      _l160:;
    }
    _l180:;
  }
  _l200:;
  __calls[17].calls++;
  return 0;
}

int_4 _comlr2 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, int_4 _p_ int_, real_8 _p_ hr_, real_8 _p_ 
hi_, real_8 _p_ wr_, real_8 _p_ wi_, real_8 _p_ zr_, real_8 _p_ zi_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, l_, m_, en_, ii_, jj_, ll_, mm_, nn_, im1_, ip1_, itn_, its_, mp1_, enm1_, iend_;
  static real_8 si_, sr_, ti_, tr_, xi_, xr_, yi_, yr_, zzi_, zzr_, norm_, tst1_, tst2_;
  real_8 $0_, $1_, $2_, $3_;
  (*ierr_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
      if (i_ == j_) {
        zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 1.0;
      }
    }
  }
  iend_ = (*igh_) - (*low_) - 1;
  if (iend_ <= 0) {
    goto _l180;
  }
  for (ii_ = 1; ii_ <= iend_; (ii_)++) {
    i_ = (*igh_) - ii_;
    ip1_ = i_ + 1;
    for (k_ = ip1_; k_ <= (*igh_); (k_)++) {
      zr_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = hr_[k_ - 1 + ((*nm_)) * ((i_ - 1 - 1))];
      zi_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = hi_[k_ - 1 + ((*nm_)) * ((i_ - 1 - 1))];
    }
    j_ = int_[i_ - 1];
    if (i_ == j_) {
      goto _l160;
    }
    for (k_ = i_; k_ <= (*igh_); (k_)++) {
      zr_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = zr_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
      zi_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = zi_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
      zr_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = 0.0;
      zi_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = 0.0;
    }
    zr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 1.0;
    _l160:;
  }
  _l180:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l200;
    }
    wr_[i_ - 1] = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    wi_[i_ - 1] = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    _l200:;
  }
  en_ = (*igh_);
  tr_ = 0.0;
  ti_ = 0.0;
  itn_ = 30 * (*n_);
  _l220:;
  if (en_ < (*low_)) {
    goto _l680;
  }
  its_ = 0;
  enm1_ = en_ - 1;
  _l240:;
  for (ll_ = (*low_); ll_ <= en_; (ll_)++) {
    l_ = en_ + (*low_) - ll_;
    if (l_ == (*low_)) {
      goto _l300;
    }
    tst1_ = _abs (hr_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs (hi_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs 
    (hr_[l_ - 1 + ((*nm_)) * ((l_ - 1))]) + _abs (hi_[l_ - 1 + ((*nm_)) * ((l_ - 1))]);
    tst2_ = tst1_ + _abs (hr_[l_ - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs (hi_[l_ - 1 + ((*nm_)) * ((l_ - 1 - 1))]);
    if (tst2_ == tst1_) {
      goto _l300;
    }
  }
  _l300:;
  if (l_ == en_) {
    goto _l660;
  }
  if (itn_ == 0) {
    goto _l1000;
  }
  if (its_ == 10 || its_ == 20) {
    goto _l320;
  }
  sr_ = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  si_ = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  xr_ = hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 1))] * hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))] - hi_[enm1_ - 1 + ((*nm_)) * 
  ((en_ - 1))] * hi_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))];
  xi_ = hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 1))] * hi_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))] + hi_[enm1_ - 1 + ((*nm_)) * 
  ((en_ - 1))] * hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))];
  if (xr_ == 0.0e0 && xi_ == 0.0e0) {
    goto _l340;
  }
  yr_ = (hr_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))] - sr_) / 2.0e0;
  yi_ = (hi_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))] - si_) / 2.0e0;
  (void) _csroot (($0_ = (yr_ * yr_) - (yi_ * yi_) + xr_, &$0_), ($1_ = 2.0e0 * yr_ * yi_ + xi_, &$1_), &zzr_, &zzi_);
  if (yr_ * zzr_ + yi_ * zzi_ >= 0.0e0) {
    goto _l310;
  }
  zzr_ = -zzr_;
  zzi_ = -zzi_;
  _l310:;
  (void) _cdiv (&xr_, &xi_, ($2_ = yr_ + zzr_, &$2_), ($3_ = yi_ + zzi_, &$3_), &xr_, &xi_);
  sr_ = sr_ - xr_;
  si_ = si_ - xi_;
  goto _l340;
  _l320:;
  sr_ = _abs (hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 2 - 1))]);
  si_ = _abs (hi_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hi_[enm1_ - 1 + ((*nm_)) * ((en_ - 2 - 1))]);
  _l340:;
  for (i_ = (*low_); i_ <= en_; (i_)++) {
    hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - sr_;
    hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - si_;
  }
  tr_ = tr_ + sr_;
  ti_ = ti_ + si_;
  its_ = its_ + 1;
  itn_ = itn_ - 1;
  xr_ = _abs (hr_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hi_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))]);
  yr_ = _abs (hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hi_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]);
  zzr_ = _abs (hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))]) + _abs (hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))]);
  for (mm_ = l_; mm_ <= enm1_; (mm_)++) {
    m_ = enm1_ + l_ - mm_;
    if (m_ == l_) {
      goto _l420;
    }
    yi_ = yr_;
    yr_ = _abs (hr_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]) + _abs (hi_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]);
    xi_ = zzr_;
    zzr_ = xr_;
    xr_ = _abs (hr_[m_ - 1 - 1 + ((*nm_)) * ((m_ - 1 - 1))]) + _abs (hi_[m_ - 1 - 1 + ((*nm_)) * ((m_ - 1 - 1))]);
    tst1_ = zzr_ / yi_ * (zzr_ + xr_ + xi_);
    tst2_ = tst1_ + yr_;
    if (tst2_ == tst1_) {
      goto _l420;
    }
  }
  _l420:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; i_ <= en_; (i_)++) {
    im1_ = i_ - 1;
    xr_ = hr_[im1_ - 1 + ((*nm_)) * ((im1_ - 1))];
    xi_ = hi_[im1_ - 1 + ((*nm_)) * ((im1_ - 1))];
    yr_ = hr_[i_ - 1 + ((*nm_)) * ((im1_ - 1))];
    yi_ = hi_[i_ - 1 + ((*nm_)) * ((im1_ - 1))];
    if (_abs (xr_) + _abs (xi_) >= _abs (yr_) + _abs (yi_)) {
      goto _l460;
    }
    for (j_ = im1_; j_ <= (*n_); (j_)++) {
      zzr_ = hr_[im1_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[im1_ - 1 + ((*nm_)) * ((j_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzr_;
      zzi_ = hi_[im1_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[im1_ - 1 + ((*nm_)) * ((j_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzi_;
    }
    (void) _cdiv (&xr_, &xi_, &yr_, &yi_, &zzr_, &zzi_);
    wr_[i_ - 1] = 1.0;
    goto _l480;
    _l460:;
    (void) _cdiv (&yr_, &yi_, &xr_, &xi_, &zzr_, &zzi_);
    wr_[i_ - 1] = -1.0;
    _l480:;
    hr_[i_ - 1 + ((*nm_)) * ((im1_ - 1))] = zzr_;
    hi_[i_ - 1 + ((*nm_)) * ((im1_ - 1))] = zzi_;
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - zzr_ * hr_[im1_ - 1 + ((*nm_)) * ((j_ - 
      1))] + zzi_ * hi_[im1_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - zzr_ * hi_[im1_ - 1 + ((*nm_)) * ((j_ - 
      1))] - zzi_ * hr_[im1_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
  }
  for (j_ = mp1_; j_ <= en_; (j_)++) {
    xr_ = hr_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
    xi_ = hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
    hr_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = 0.0;
    hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = 0.0;
    if (wr_[j_ - 1] <= 0.0e0) {
      goto _l580;
    }
    for (i_ = 1; i_ <= j_; (i_)++) {
      zzr_ = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzr_;
      zzi_ = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzi_;
    }
    for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
      zzr_ = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzr_;
      zzi_ = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzi_;
    }
    _l580:;
    for (i_ = 1; i_ <= j_; (i_)++) {
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] + xr_ * hr_[i_ - 1 + ((*nm_)) * ((j_ 
      - 1))] - xi_ * hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] + xr_ * hi_[i_ - 1 + ((*nm_)) * ((j_ 
      - 1))] + xi_ * hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
    for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] + xr_ * zr_[i_ - 1 + ((*nm_)) * ((j_ 
      - 1))] - xi_ * zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] + xr_ * zi_[i_ - 1 + ((*nm_)) * ((j_ 
      - 1))] + xi_ * zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
  }
  goto _l240;
  _l660:;
  hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] + tr_;
  wr_[en_ - 1] = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] + ti_;
  wi_[en_ - 1] = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  en_ = enm1_;
  goto _l220;
  _l680:;
  norm_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      tr_ = _abs (hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))]) + _abs (hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      if (tr_ > norm_) {
        norm_ = tr_;
      }
    }
  }
  hr_[0 + ((*nm_)) * ((0))] = norm_;
  if ((*n_) == 1 || norm_ == 0.0e0) {
    goto _l1001;
  }
  for (nn_ = 2; nn_ <= (*n_); (nn_)++) {
    en_ = (*n_) + 2 - nn_;
    xr_ = wr_[en_ - 1];
    xi_ = wi_[en_ - 1];
    hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 1.0;
    hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 0.0;
    enm1_ = en_ - 1;
    for (ii_ = 1; ii_ <= enm1_; (ii_)++) {
      i_ = en_ - ii_;
      zzr_ = 0.0;
      zzi_ = 0.0;
      ip1_ = i_ + 1;
      for (j_ = ip1_; j_ <= en_; (j_)++) {
        zzr_ = zzr_ + hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * hr_[j_ - 1 + ((*nm_)) * ((en_ - 1))] - hi_[i_ - 1 + ((*nm_)) * ((j_ 
        - 1))] * hi_[j_ - 1 + ((*nm_)) * ((en_ - 1))];
        zzi_ = zzi_ + hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * hi_[j_ - 1 + ((*nm_)) * ((en_ - 1))] + hi_[i_ - 1 + ((*nm_)) * ((j_ 
        - 1))] * hr_[j_ - 1 + ((*nm_)) * ((en_ - 1))];
      }
      yr_ = xr_ - wr_[i_ - 1];
      yi_ = xi_ - wi_[i_ - 1];
      if (yr_ != 0.0e0 || yi_ != 0.0e0) {
        goto _l765;
      }
      tst1_ = norm_;
      yr_ = tst1_;
      _l760:;
      yr_ = 0.01e0 * yr_;
      tst2_ = norm_ + yr_;
      if (tst2_ > tst1_) {
        goto _l760;
      }
      _l765:;
      (void) _cdiv (&zzr_, &zzi_, &yr_, &yi_, &hr_[i_ - 1 + ((*nm_)) * ((en_ - 1))], &hi_[i_ - 1 + ((*nm_)) * ((en_ - 1))]);
      tr_ = _abs (hr_[i_ - 1 + ((*nm_)) * ((en_ - 1))]) + _abs (hi_[i_ - 1 + ((*nm_)) * ((en_ - 1))]);
      if (tr_ == 0.0e0) {
        goto _l780;
      }
      tst1_ = tr_;
      tst2_ = tst1_ + 1.0e0 / tst1_;
      if (tst2_ > tst1_) {
        goto _l780;
      }
      for (j_ = i_; j_ <= en_; (j_)++) {
        hr_[j_ - 1 + ((*nm_)) * ((en_ - 1))] = hr_[j_ - 1 + ((*nm_)) * ((en_ - 1))] / tr_;
        hi_[j_ - 1 + ((*nm_)) * ((en_ - 1))] = hi_[j_ - 1 + ((*nm_)) * ((en_ - 1))] / tr_;
      }
      _l780:;
    }
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l840;
    }
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
    _l840:;
  }
  for (jj_ = (*low_); jj_ <= (*n_); (jj_)++) {
    j_ = (*n_) + (*low_) - jj_;
    m_ = _min (j_, (*igh_));
    for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
      zzr_ = 0.0;
      zzi_ = 0.0;
      for (k_ = (*low_); k_ <= m_; (k_)++) {
        zzr_ = zzr_ + zr_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * hr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - zi_[i_ - 1 + ((*nm_)) * ((k_ 
        - 1))] * hi_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
        zzi_ = zzi_ + zr_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * hi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + zi_[i_ - 1 + ((*nm_)) * ((k_ 
        - 1))] * hr_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzr_;
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzi_;
    }
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = en_;
  _l1001:;
  __calls[18].calls++;
  return 0;
}

int_4 _comlr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ hr_, real_8 _p_ hi_, real_8 _p_ 
wr_, real_8 _p_ wi_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, l_, m_, en_, ll_, mm_, im1_, itn_, its_, mp1_, enm1_;
  static real_8 si_, sr_, ti_, tr_, xi_, xr_, yi_, yr_, zzi_, zzr_, tst1_, tst2_;
  real_8 $0_, $1_, $2_, $3_;
  (*ierr_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l200;
    }
    wr_[i_ - 1] = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    wi_[i_ - 1] = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    _l200:;
  }
  en_ = (*igh_);
  tr_ = 0.0;
  ti_ = 0.0;
  itn_ = 30 * (*n_);
  _l220:;
  if (en_ < (*low_)) {
    goto _l1001;
  }
  its_ = 0;
  enm1_ = en_ - 1;
  _l240:;
  for (ll_ = (*low_); ll_ <= en_; (ll_)++) {
    l_ = en_ + (*low_) - ll_;
    if (l_ == (*low_)) {
      goto _l300;
    }
    tst1_ = _abs (hr_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs (hi_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs 
    (hr_[l_ - 1 + ((*nm_)) * ((l_ - 1))]) + _abs (hi_[l_ - 1 + ((*nm_)) * ((l_ - 1))]);
    tst2_ = tst1_ + _abs (hr_[l_ - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs (hi_[l_ - 1 + ((*nm_)) * ((l_ - 1 - 1))]);
    if (tst2_ == tst1_) {
      goto _l300;
    }
  }
  _l300:;
  if (l_ == en_) {
    goto _l660;
  }
  if (itn_ == 0) {
    goto _l1000;
  }
  if (its_ == 10 || its_ == 20) {
    goto _l320;
  }
  sr_ = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  si_ = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  xr_ = hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 1))] * hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))] - hi_[enm1_ - 1 + ((*nm_)) * 
  ((en_ - 1))] * hi_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))];
  xi_ = hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 1))] * hi_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))] + hi_[enm1_ - 1 + ((*nm_)) * 
  ((en_ - 1))] * hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))];
  if (xr_ == 0.0e0 && xi_ == 0.0e0) {
    goto _l340;
  }
  yr_ = (hr_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))] - sr_) / 2.0e0;
  yi_ = (hi_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))] - si_) / 2.0e0;
  (void) _csroot (($0_ = (yr_ * yr_) - (yi_ * yi_) + xr_, &$0_), ($1_ = 2.0e0 * yr_ * yi_ + xi_, &$1_), &zzr_, &zzi_);
  if (yr_ * zzr_ + yi_ * zzi_ >= 0.0e0) {
    goto _l310;
  }
  zzr_ = -zzr_;
  zzi_ = -zzi_;
  _l310:;
  (void) _cdiv (&xr_, &xi_, ($2_ = yr_ + zzr_, &$2_), ($3_ = yi_ + zzi_, &$3_), &xr_, &xi_);
  sr_ = sr_ - xr_;
  si_ = si_ - xi_;
  goto _l340;
  _l320:;
  sr_ = _abs (hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 2 - 1))]);
  si_ = _abs (hi_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hi_[enm1_ - 1 + ((*nm_)) * ((en_ - 2 - 1))]);
  _l340:;
  for (i_ = (*low_); i_ <= en_; (i_)++) {
    hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - sr_;
    hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - si_;
  }
  tr_ = tr_ + sr_;
  ti_ = ti_ + si_;
  its_ = its_ + 1;
  itn_ = itn_ - 1;
  xr_ = _abs (hr_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hi_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))]);
  yr_ = _abs (hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hi_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]);
  zzr_ = _abs (hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))]) + _abs (hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))]);
  for (mm_ = l_; mm_ <= enm1_; (mm_)++) {
    m_ = enm1_ + l_ - mm_;
    if (m_ == l_) {
      goto _l420;
    }
    yi_ = yr_;
    yr_ = _abs (hr_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]) + _abs (hi_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]);
    xi_ = zzr_;
    zzr_ = xr_;
    xr_ = _abs (hr_[m_ - 1 - 1 + ((*nm_)) * ((m_ - 1 - 1))]) + _abs (hi_[m_ - 1 - 1 + ((*nm_)) * ((m_ - 1 - 1))]);
    tst1_ = zzr_ / yi_ * (zzr_ + xr_ + xi_);
    tst2_ = tst1_ + yr_;
    if (tst2_ == tst1_) {
      goto _l420;
    }
  }
  _l420:;
  mp1_ = m_ + 1;
  for (i_ = mp1_; i_ <= en_; (i_)++) {
    im1_ = i_ - 1;
    xr_ = hr_[im1_ - 1 + ((*nm_)) * ((im1_ - 1))];
    xi_ = hi_[im1_ - 1 + ((*nm_)) * ((im1_ - 1))];
    yr_ = hr_[i_ - 1 + ((*nm_)) * ((im1_ - 1))];
    yi_ = hi_[i_ - 1 + ((*nm_)) * ((im1_ - 1))];
    if (_abs (xr_) + _abs (xi_) >= _abs (yr_) + _abs (yi_)) {
      goto _l460;
    }
    for (j_ = im1_; j_ <= en_; (j_)++) {
      zzr_ = hr_[im1_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[im1_ - 1 + ((*nm_)) * ((j_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzr_;
      zzi_ = hi_[im1_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[im1_ - 1 + ((*nm_)) * ((j_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzi_;
    }
    (void) _cdiv (&xr_, &xi_, &yr_, &yi_, &zzr_, &zzi_);
    wr_[i_ - 1] = 1.0;
    goto _l480;
    _l460:;
    (void) _cdiv (&yr_, &yi_, &xr_, &xi_, &zzr_, &zzi_);
    wr_[i_ - 1] = -1.0;
    _l480:;
    hr_[i_ - 1 + ((*nm_)) * ((im1_ - 1))] = zzr_;
    hi_[i_ - 1 + ((*nm_)) * ((im1_ - 1))] = zzi_;
    for (j_ = i_; j_ <= en_; (j_)++) {
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - zzr_ * hr_[im1_ - 1 + ((*nm_)) * ((j_ - 
      1))] + zzi_ * hi_[im1_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - zzr_ * hi_[im1_ - 1 + ((*nm_)) * ((j_ - 
      1))] - zzi_ * hr_[im1_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
  }
  for (j_ = mp1_; j_ <= en_; (j_)++) {
    xr_ = hr_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
    xi_ = hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
    hr_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = 0.0;
    hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = 0.0;
    if (wr_[j_ - 1] <= 0.0e0) {
      goto _l580;
    }
    for (i_ = l_; i_ <= j_; (i_)++) {
      zzr_ = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzr_;
      zzi_ = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzi_;
    }
    _l580:;
    for (i_ = l_; i_ <= j_; (i_)++) {
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] + xr_ * hr_[i_ - 1 + ((*nm_)) * ((j_ 
      - 1))] - xi_ * hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] + xr_ * hi_[i_ - 1 + ((*nm_)) * ((j_ 
      - 1))] + xi_ * hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
  }
  goto _l240;
  _l660:;
  wr_[en_ - 1] = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] + tr_;
  wi_[en_ - 1] = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] + ti_;
  en_ = enm1_;
  goto _l220;
  _l1000:;
  (*ierr_) = en_;
  _l1001:;
  __calls[19].calls++;
  return 0;
}

int_4 _comqr2 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ortr_, real_8 _p_ orti_, real_8 
_p_ hr_, real_8 _p_ hi_, real_8 _p_ wr_, real_8 _p_ wi_, real_8 _p_ zr_, real_8 _p_ zi_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, l_, m_, en_, ii_, ll_, nn_, ip1_, itn_, its_, lp1_, enm1_, iend_;
  static real_8 si_, sr_, ti_, tr_, xi_, xr_, yi_, yr_, zzi_, zzr_, norm_, tst1_, tst2_;
  int_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $5_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    zr_[j_ - 1 + ((*nm_)) * ((j_ - 1))] = 1.0;
  }
  iend_ = (*igh_) - (*low_) - 1;
  $0_ = iend_;
  if ($0_ < 0) {
    goto _l180;
  } else if ($0_ == 0) {
    goto _l150;
  } else {
    goto _l105;
  }
  _l105:;
  for (ii_ = 1; ii_ <= iend_; (ii_)++) {
    i_ = (*igh_) - ii_;
    if (ortr_[i_ - 1] == 0.0e0 && orti_[i_ - 1] == 0.0e0) {
      goto _l140;
    }
    if (hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] == 0.0e0 && hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] == 0.0e0) {
      goto _l140;
    }
    norm_ = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * ortr_[i_ - 1] + hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * orti_[i_ - 
    1];
    ip1_ = i_ + 1;
    for (k_ = ip1_; k_ <= (*igh_); (k_)++) {
      ortr_[k_ - 1] = hr_[k_ - 1 + ((*nm_)) * ((i_ - 1 - 1))];
      orti_[k_ - 1] = hi_[k_ - 1 + ((*nm_)) * ((i_ - 1 - 1))];
    }
    for (j_ = i_; j_ <= (*igh_); (j_)++) {
      sr_ = 0.0;
      si_ = 0.0;
      for (k_ = i_; k_ <= (*igh_); (k_)++) {
        sr_ = sr_ + ortr_[k_ - 1] * zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + orti_[k_ - 1] * zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
        si_ = si_ + ortr_[k_ - 1] * zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - orti_[k_ - 1] * zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      sr_ = sr_ / norm_;
      si_ = si_ / norm_;
      for (k_ = i_; k_ <= (*igh_); (k_)++) {
        zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + sr_ * ortr_[k_ - 1] - si_ * orti_[k_ - 1];
        zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + sr_ * orti_[k_ - 1] + si_ * ortr_[k_ - 1];
      }
    }
    _l140:;
  }
  _l150:;
  l_ = (*low_) + 1;
  for (i_ = l_; i_ <= (*igh_); (i_)++) {
    ll_ = _min (i_ + 1, (*igh_));
    if (hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] == 0.0e0) {
      goto _l170;
    }
    norm_ = _pythag (&hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))], &hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))]);
    yr_ = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] / norm_;
    yi_ = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] / norm_;
    hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] = norm_;
    hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] = 0.0;
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      si_ = yr_ * hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - yi_ * hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = yr_ * hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + yi_ * hi_[i_ - 1 + ((*nm_)) * ((j_ - 
      1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = si_;
    }
    for (j_ = 1; j_ <= ll_; (j_)++) {
      si_ = yr_ * hi_[j_ - 1 + ((*nm_)) * ((i_ - 1))] + yi_ * hr_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      hr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = yr_ * hr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] - yi_ * hi_[j_ - 1 + ((*nm_)) * ((i_ - 
      1))];
      hi_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = si_;
    }
    for (j_ = (*low_); j_ <= (*igh_); (j_)++) {
      si_ = yr_ * zi_[j_ - 1 + ((*nm_)) * ((i_ - 1))] + yi_ * zr_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      zr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = yr_ * zr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] - yi_ * zi_[j_ - 1 + ((*nm_)) * ((i_ - 
      1))];
      zi_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = si_;
    }
    _l170:;
  }
  _l180:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l200;
    }
    wr_[i_ - 1] = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    wi_[i_ - 1] = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    _l200:;
  }
  en_ = (*igh_);
  tr_ = 0.0;
  ti_ = 0.0;
  itn_ = 30 * (*n_);
  _l220:;
  if (en_ < (*low_)) {
    goto _l680;
  }
  its_ = 0;
  enm1_ = en_ - 1;
  _l240:;
  for (ll_ = (*low_); ll_ <= en_; (ll_)++) {
    l_ = en_ + (*low_) - ll_;
    if (l_ == (*low_)) {
      goto _l300;
    }
    tst1_ = _abs (hr_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs (hi_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs 
    (hr_[l_ - 1 + ((*nm_)) * ((l_ - 1))]) + _abs (hi_[l_ - 1 + ((*nm_)) * ((l_ - 1))]);
    tst2_ = tst1_ + _abs (hr_[l_ - 1 + ((*nm_)) * ((l_ - 1 - 1))]);
    if (tst2_ == tst1_) {
      goto _l300;
    }
  }
  _l300:;
  if (l_ == en_) {
    goto _l660;
  }
  if (itn_ == 0) {
    goto _l1000;
  }
  if (its_ == 10 || its_ == 20) {
    goto _l320;
  }
  sr_ = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  si_ = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  xr_ = hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 1))] * hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))];
  xi_ = hi_[enm1_ - 1 + ((*nm_)) * ((en_ - 1))] * hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))];
  if (xr_ == 0.0e0 && xi_ == 0.0e0) {
    goto _l340;
  }
  yr_ = (hr_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))] - sr_) / 2.0e0;
  yi_ = (hi_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))] - si_) / 2.0e0;
  (void) _csroot (($1_ = (yr_ * yr_) - (yi_ * yi_) + xr_, &$1_), ($2_ = 2.0e0 * yr_ * yi_ + xi_, &$2_), &zzr_, &zzi_);
  if (yr_ * zzr_ + yi_ * zzi_ >= 0.0e0) {
    goto _l310;
  }
  zzr_ = -zzr_;
  zzi_ = -zzi_;
  _l310:;
  (void) _cdiv (&xr_, &xi_, ($3_ = yr_ + zzr_, &$3_), ($4_ = yi_ + zzi_, &$4_), &xr_, &xi_);
  sr_ = sr_ - xr_;
  si_ = si_ - xi_;
  goto _l340;
  _l320:;
  sr_ = _abs (hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 2 - 1))]);
  si_ = 0.0;
  _l340:;
  for (i_ = (*low_); i_ <= en_; (i_)++) {
    hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - sr_;
    hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - si_;
  }
  tr_ = tr_ + sr_;
  ti_ = ti_ + si_;
  its_ = its_ + 1;
  itn_ = itn_ - 1;
  lp1_ = l_ + 1;
  for (i_ = lp1_; i_ <= en_; (i_)++) {
    sr_ = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))];
    hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] = 0.0;
    norm_ = _pythag (($5_ = _pythag (&hr_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))], &hi_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 
    1))]), &$5_), &sr_);
    xr_ = hr_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] / norm_;
    wr_[i_ - 1 - 1] = xr_;
    xi_ = hi_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] / norm_;
    wi_[i_ - 1 - 1] = xi_;
    hr_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] = norm_;
    hi_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] = 0.0;
    hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] = sr_ / norm_;
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      yr_ = hr_[i_ - 1 - 1 + ((*nm_)) * ((j_ - 1))];
      yi_ = hi_[i_ - 1 - 1 + ((*nm_)) * ((j_ - 1))];
      zzr_ = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zzi_ = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[i_ - 1 - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * yr_ + xi_ * yi_ + hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * zzr_;
      hi_[i_ - 1 - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * yi_ - xi_ * yr_ + hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * zzi_;
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzr_ - xi_ * zzi_ - hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * yr_;
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzi_ + xi_ * zzr_ - hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * yi_;
    }
  }
  si_ = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  if (si_ == 0.0e0) {
    goto _l540;
  }
  norm_ = _pythag (&hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))], &si_);
  sr_ = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] / norm_;
  si_ = si_ / norm_;
  hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = norm_;
  hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 0.0;
  if (en_ == (*n_)) {
    goto _l540;
  }
  ip1_ = en_ + 1;
  for (j_ = ip1_; j_ <= (*n_); (j_)++) {
    yr_ = hr_[en_ - 1 + ((*nm_)) * ((j_ - 1))];
    yi_ = hi_[en_ - 1 + ((*nm_)) * ((j_ - 1))];
    hr_[en_ - 1 + ((*nm_)) * ((j_ - 1))] = sr_ * yr_ + si_ * yi_;
    hi_[en_ - 1 + ((*nm_)) * ((j_ - 1))] = sr_ * yi_ - si_ * yr_;
  }
  _l540:;
  for (j_ = lp1_; j_ <= en_; (j_)++) {
    xr_ = wr_[j_ - 1 - 1];
    xi_ = wi_[j_ - 1 - 1];
    for (i_ = 1; i_ <= j_; (i_)++) {
      yr_ = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      yi_ = 0.0;
      zzr_ = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zzi_ = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == j_) {
        goto _l560;
      }
      yi_ = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = xr_ * yi_ + xi_ * yr_ + hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * zzi_;
      _l560:;
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = xr_ * yr_ - xi_ * yi_ + hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * zzr_;
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzr_ + xi_ * zzi_ - hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * yr_;
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzi_ - xi_ * zzr_ - hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * yi_;
    }
    for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
      yr_ = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      yi_ = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      zzr_ = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zzi_ = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = xr_ * yr_ - xi_ * yi_ + hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * zzr_;
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = xr_ * yi_ + xi_ * yr_ + hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * zzi_;
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzr_ + xi_ * zzi_ - hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * yr_;
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzi_ - xi_ * zzr_ - hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * yi_;
    }
  }
  if (si_ == 0.0e0) {
    goto _l240;
  }
  for (i_ = 1; i_ <= en_; (i_)++) {
    yr_ = hr_[i_ - 1 + ((*nm_)) * ((en_ - 1))];
    yi_ = hi_[i_ - 1 + ((*nm_)) * ((en_ - 1))];
    hr_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = sr_ * yr_ - si_ * yi_;
    hi_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = sr_ * yi_ + si_ * yr_;
  }
  for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
    yr_ = zr_[i_ - 1 + ((*nm_)) * ((en_ - 1))];
    yi_ = zi_[i_ - 1 + ((*nm_)) * ((en_ - 1))];
    zr_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = sr_ * yr_ - si_ * yi_;
    zi_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = sr_ * yi_ + si_ * yr_;
  }
  goto _l240;
  _l660:;
  hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] + tr_;
  wr_[en_ - 1] = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] + ti_;
  wi_[en_ - 1] = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  en_ = enm1_;
  goto _l220;
  _l680:;
  norm_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      tr_ = _abs (hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))]) + _abs (hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      if (tr_ > norm_) {
        norm_ = tr_;
      }
    }
  }
  if ((*n_) == 1 || norm_ == 0.0e0) {
    goto _l1001;
  }
  for (nn_ = 2; nn_ <= (*n_); (nn_)++) {
    en_ = (*n_) + 2 - nn_;
    xr_ = wr_[en_ - 1];
    xi_ = wi_[en_ - 1];
    hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 1.0;
    hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 0.0;
    enm1_ = en_ - 1;
    for (ii_ = 1; ii_ <= enm1_; (ii_)++) {
      i_ = en_ - ii_;
      zzr_ = 0.0;
      zzi_ = 0.0;
      ip1_ = i_ + 1;
      for (j_ = ip1_; j_ <= en_; (j_)++) {
        zzr_ = zzr_ + hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * hr_[j_ - 1 + ((*nm_)) * ((en_ - 1))] - hi_[i_ - 1 + ((*nm_)) * ((j_ 
        - 1))] * hi_[j_ - 1 + ((*nm_)) * ((en_ - 1))];
        zzi_ = zzi_ + hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * hi_[j_ - 1 + ((*nm_)) * ((en_ - 1))] + hi_[i_ - 1 + ((*nm_)) * ((j_ 
        - 1))] * hr_[j_ - 1 + ((*nm_)) * ((en_ - 1))];
      }
      yr_ = xr_ - wr_[i_ - 1];
      yi_ = xi_ - wi_[i_ - 1];
      if (yr_ != 0.0e0 || yi_ != 0.0e0) {
        goto _l765;
      }
      tst1_ = norm_;
      yr_ = tst1_;
      _l760:;
      yr_ = 0.01e0 * yr_;
      tst2_ = norm_ + yr_;
      if (tst2_ > tst1_) {
        goto _l760;
      }
      _l765:;
      (void) _cdiv (&zzr_, &zzi_, &yr_, &yi_, &hr_[i_ - 1 + ((*nm_)) * ((en_ - 1))], &hi_[i_ - 1 + ((*nm_)) * ((en_ - 1))]);
      tr_ = _abs (hr_[i_ - 1 + ((*nm_)) * ((en_ - 1))]) + _abs (hi_[i_ - 1 + ((*nm_)) * ((en_ - 1))]);
      if (tr_ == 0.0e0) {
        goto _l780;
      }
      tst1_ = tr_;
      tst2_ = tst1_ + 1.0e0 / tst1_;
      if (tst2_ > tst1_) {
        goto _l780;
      }
      for (j_ = i_; j_ <= en_; (j_)++) {
        hr_[j_ - 1 + ((*nm_)) * ((en_ - 1))] = hr_[j_ - 1 + ((*nm_)) * ((en_ - 1))] / tr_;
        hi_[j_ - 1 + ((*nm_)) * ((en_ - 1))] = hi_[j_ - 1 + ((*nm_)) * ((en_ - 1))] / tr_;
      }
      _l780:;
    }
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l840;
    }
    for (j_ = i_ + 1; j_ <= (*n_); (j_)++) {
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
    _l840:;
  }
  for (j_ = (*n_); j_ >= (*low_) + 1; (j_)--) {
    m_ = _min (j_, (*igh_));
    for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
      zzr_ = 0.0;
      zzi_ = 0.0;
      for (k_ = (*low_); k_ <= m_; (k_)++) {
        zzr_ = zzr_ + zr_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * hr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - zi_[i_ - 1 + ((*nm_)) * ((k_ 
        - 1))] * hi_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
        zzi_ = zzi_ + zr_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * hi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + zi_[i_ - 1 + ((*nm_)) * ((k_ 
        - 1))] * hr_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzr_;
      zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zzi_;
    }
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = en_;
  _l1001:;
  __calls[20].calls++;
  return 0;
}

int_4 _comqr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ hr_, real_8 _p_ hi_, real_8 _p_ 
wr_, real_8 _p_ wi_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, l_, en_, ll_, itn_, its_, lp1_, enm1_;
  static real_8 si_, sr_, ti_, tr_, xi_, xr_, yi_, yr_, zzi_, zzr_, norm_, tst1_, tst2_;
  real_8 $0_, $1_, $2_, $3_, $4_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  if ((*low_) == (*igh_)) {
    goto _l180;
  }
  l_ = (*low_) + 1;
  for (i_ = l_; i_ <= (*igh_); (i_)++) {
    ll_ = _min (i_ + 1, (*igh_));
    if (hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] == 0.0e0) {
      goto _l170;
    }
    norm_ = _pythag (&hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))], &hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))]);
    yr_ = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] / norm_;
    yi_ = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] / norm_;
    hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] = norm_;
    hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] = 0.0;
    for (j_ = i_; j_ <= (*igh_); (j_)++) {
      si_ = yr_ * hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - yi_ * hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = yr_ * hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + yi_ * hi_[i_ - 1 + ((*nm_)) * ((j_ - 
      1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = si_;
    }
    for (j_ = (*low_); j_ <= ll_; (j_)++) {
      si_ = yr_ * hi_[j_ - 1 + ((*nm_)) * ((i_ - 1))] + yi_ * hr_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      hr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = yr_ * hr_[j_ - 1 + ((*nm_)) * ((i_ - 1))] - yi_ * hi_[j_ - 1 + ((*nm_)) * ((i_ - 
      1))];
      hi_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = si_;
    }
    _l170:;
  }
  _l180:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l200;
    }
    wr_[i_ - 1] = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    wi_[i_ - 1] = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    _l200:;
  }
  en_ = (*igh_);
  tr_ = 0.0;
  ti_ = 0.0;
  itn_ = 30 * (*n_);
  _l220:;
  if (en_ < (*low_)) {
    goto _l1001;
  }
  its_ = 0;
  enm1_ = en_ - 1;
  _l240:;
  for (ll_ = (*low_); ll_ <= en_; (ll_)++) {
    l_ = en_ + (*low_) - ll_;
    if (l_ == (*low_)) {
      goto _l300;
    }
    tst1_ = _abs (hr_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs (hi_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs 
    (hr_[l_ - 1 + ((*nm_)) * ((l_ - 1))]) + _abs (hi_[l_ - 1 + ((*nm_)) * ((l_ - 1))]);
    tst2_ = tst1_ + _abs (hr_[l_ - 1 + ((*nm_)) * ((l_ - 1 - 1))]);
    if (tst2_ == tst1_) {
      goto _l300;
    }
  }
  _l300:;
  if (l_ == en_) {
    goto _l660;
  }
  if (itn_ == 0) {
    goto _l1000;
  }
  if (its_ == 10 || its_ == 20) {
    goto _l320;
  }
  sr_ = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  si_ = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  xr_ = hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 1))] * hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))];
  xi_ = hi_[enm1_ - 1 + ((*nm_)) * ((en_ - 1))] * hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))];
  if (xr_ == 0.0e0 && xi_ == 0.0e0) {
    goto _l340;
  }
  yr_ = (hr_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))] - sr_) / 2.0e0;
  yi_ = (hi_[enm1_ - 1 + ((*nm_)) * ((enm1_ - 1))] - si_) / 2.0e0;
  (void) _csroot (($0_ = (yr_ * yr_) - (yi_ * yi_) + xr_, &$0_), ($1_ = 2.0e0 * yr_ * yi_ + xi_, &$1_), &zzr_, &zzi_);
  if (yr_ * zzr_ + yi_ * zzi_ >= 0.0e0) {
    goto _l310;
  }
  zzr_ = -zzr_;
  zzi_ = -zzi_;
  _l310:;
  (void) _cdiv (&xr_, &xi_, ($2_ = yr_ + zzr_, &$2_), ($3_ = yi_ + zzi_, &$3_), &xr_, &xi_);
  sr_ = sr_ - xr_;
  si_ = si_ - xi_;
  goto _l340;
  _l320:;
  sr_ = _abs (hr_[en_ - 1 + ((*nm_)) * ((enm1_ - 1))]) + _abs (hr_[enm1_ - 1 + ((*nm_)) * ((en_ - 2 - 1))]);
  si_ = 0.0;
  _l340:;
  for (i_ = (*low_); i_ <= en_; (i_)++) {
    hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - sr_;
    hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hi_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - si_;
  }
  tr_ = tr_ + sr_;
  ti_ = ti_ + si_;
  its_ = its_ + 1;
  itn_ = itn_ - 1;
  lp1_ = l_ + 1;
  for (i_ = lp1_; i_ <= en_; (i_)++) {
    sr_ = hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))];
    hr_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] = 0.0;
    norm_ = _pythag (($4_ = _pythag (&hr_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))], &hi_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 
    1))]), &$4_), &sr_);
    xr_ = hr_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] / norm_;
    wr_[i_ - 1 - 1] = xr_;
    xi_ = hi_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] / norm_;
    wi_[i_ - 1 - 1] = xi_;
    hr_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] = norm_;
    hi_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] = 0.0;
    hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] = sr_ / norm_;
    for (j_ = i_; j_ <= en_; (j_)++) {
      yr_ = hr_[i_ - 1 - 1 + ((*nm_)) * ((j_ - 1))];
      yi_ = hi_[i_ - 1 - 1 + ((*nm_)) * ((j_ - 1))];
      zzr_ = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zzi_ = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      hr_[i_ - 1 - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * yr_ + xi_ * yi_ + hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * zzr_;
      hi_[i_ - 1 - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * yi_ - xi_ * yr_ + hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * zzi_;
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzr_ - xi_ * zzi_ - hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * yr_;
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzi_ + xi_ * zzr_ - hi_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] * yi_;
    }
  }
  si_ = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  if (si_ == 0.0e0) {
    goto _l540;
  }
  norm_ = _pythag (&hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))], &si_);
  sr_ = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] / norm_;
  si_ = si_ / norm_;
  hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = norm_;
  hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 0.0;
  _l540:;
  for (j_ = lp1_; j_ <= en_; (j_)++) {
    xr_ = wr_[j_ - 1 - 1];
    xi_ = wi_[j_ - 1 - 1];
    for (i_ = l_; i_ <= j_; (i_)++) {
      yr_ = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      yi_ = 0.0;
      zzr_ = hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      zzi_ = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == j_) {
        goto _l560;
      }
      yi_ = hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))];
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = xr_ * yi_ + xi_ * yr_ + hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * zzi_;
      _l560:;
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = xr_ * yr_ - xi_ * yi_ + hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * zzr_;
      hr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzr_ + xi_ * zzi_ - hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * yr_;
      hi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = xr_ * zzi_ - xi_ * zzr_ - hi_[j_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] * yi_;
    }
  }
  if (si_ == 0.0e0) {
    goto _l240;
  }
  for (i_ = l_; i_ <= en_; (i_)++) {
    yr_ = hr_[i_ - 1 + ((*nm_)) * ((en_ - 1))];
    yi_ = hi_[i_ - 1 + ((*nm_)) * ((en_ - 1))];
    hr_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = sr_ * yr_ - si_ * yi_;
    hi_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = sr_ * yi_ + si_ * yr_;
  }
  goto _l240;
  _l660:;
  wr_[en_ - 1] = hr_[en_ - 1 + ((*nm_)) * ((en_ - 1))] + tr_;
  wi_[en_ - 1] = hi_[en_ - 1 + ((*nm_)) * ((en_ - 1))] + ti_;
  en_ = enm1_;
  goto _l220;
  _l1000:;
  (*ierr_) = en_;
  _l1001:;
  __calls[21].calls++;
  return 0;
}

int_4 _cortb (int_4 _p_ nm_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ ortr_, real_8 
_p_ orti_, int_4 _p_ m_, real_8 _p_ zr_, real_8 _p_ zi_)
{
  static int_4 i_, j_, la_, mm_, mp_, kp1_, mp1_;
  static real_8 h_, gi_, gr_;
  if ((*m_) == 0) {
    goto _l200;
  }
  la_ = (*igh_) - 1;
  kp1_ = (*low_) + 1;
  if (la_ < kp1_) {
    goto _l200;
  }
  for (mm_ = kp1_; mm_ <= la_; (mm_)++) {
    mp_ = (*low_) + (*igh_) - mm_;
    if (ar_[mp_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))] == 0.0e0 && ai_[mp_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))] == 0.0e0) {
      goto _l140;
    }
    h_ = ar_[mp_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))] * ortr_[mp_ - 1] + ai_[mp_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))] * orti_[mp_ 
    - 1];
    mp1_ = mp_ + 1;
    for (i_ = mp1_; i_ <= (*igh_); (i_)++) {
      ortr_[i_ - 1] = ar_[i_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
      orti_[i_ - 1] = ai_[i_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      gr_ = 0.0;
      gi_ = 0.0;
      for (i_ = mp_; i_ <= (*igh_); (i_)++) {
        gr_ = gr_ + ortr_[i_ - 1] * zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + orti_[i_ - 1] * zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        gi_ = gi_ + ortr_[i_ - 1] * zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - orti_[i_ - 1] * zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      gr_ = gr_ / h_;
      gi_ = gi_ / h_;
      for (i_ = mp_; i_ <= (*igh_); (i_)++) {
        zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + gr_ * ortr_[i_ - 1] - gi_ * orti_[i_ - 1];
        zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zi_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + gr_ * orti_[i_ - 1] + gi_ * ortr_[i_ - 1];
      }
    }
    _l140:;
  }
  _l200:;
  __calls[22].calls++;
  return 0;
}

int_4 _corth (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ 
ortr_, real_8 _p_ orti_)
{
  static int_4 i_, j_, m_, ii_, jj_, la_, mp_, kp1_;
  static real_8 f_, g_, h_, fi_, fr_, scale_;
  extern real_8 _pythag ();
  la_ = (*igh_) - 1;
  kp1_ = (*low_) + 1;
  if (la_ < kp1_) {
    goto _l200;
  }
  for (m_ = kp1_; m_ <= la_; (m_)++) {
    h_ = 0.0;
    ortr_[m_ - 1] = 0.0;
    orti_[m_ - 1] = 0.0;
    scale_ = 0.0;
    for (i_ = m_; i_ <= (*igh_); (i_)++) {
      scale_ = scale_ + _abs (ar_[i_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]) + _abs (ai_[i_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]);
    }
    if (scale_ == 0.0e0) {
      goto _l180;
    }
    mp_ = m_ + (*igh_);
    for (ii_ = m_; ii_ <= (*igh_); (ii_)++) {
      i_ = mp_ - ii_;
      ortr_[i_ - 1] = ar_[i_ - 1 + ((*nm_)) * ((m_ - 1 - 1))] / scale_;
      orti_[i_ - 1] = ai_[i_ - 1 + ((*nm_)) * ((m_ - 1 - 1))] / scale_;
      h_ = h_ + ortr_[i_ - 1] * ortr_[i_ - 1] + orti_[i_ - 1] * orti_[i_ - 1];
    }
    g_ = sqrt (h_);
    f_ = _pythag (&ortr_[m_ - 1], &orti_[m_ - 1]);
    if (f_ == 0.0e0) {
      goto _l103;
    }
    h_ = h_ + f_ * g_;
    g_ = g_ / f_;
    ortr_[m_ - 1] = (1.0e0 + g_) * ortr_[m_ - 1];
    orti_[m_ - 1] = (1.0e0 + g_) * orti_[m_ - 1];
    goto _l105;
    _l103:;
    ortr_[m_ - 1] = g_;
    ar_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))] = scale_;
    _l105:;
    for (j_ = m_; j_ <= (*n_); (j_)++) {
      fr_ = 0.0;
      fi_ = 0.0;
      for (ii_ = m_; ii_ <= (*igh_); (ii_)++) {
        i_ = mp_ - ii_;
        fr_ = fr_ + ortr_[i_ - 1] * ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + orti_[i_ - 1] * ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        fi_ = fi_ + ortr_[i_ - 1] * ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - orti_[i_ - 1] * ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      fr_ = fr_ / h_;
      fi_ = fi_ / h_;
      for (i_ = m_; i_ <= (*igh_); (i_)++) {
        ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - fr_ * ortr_[i_ - 1] + fi_ * orti_[i_ - 1];
        ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - fr_ * orti_[i_ - 1] - fi_ * ortr_[i_ - 1];
      }
    }
    for (i_ = 1; i_ <= (*igh_); (i_)++) {
      fr_ = 0.0;
      fi_ = 0.0;
      for (jj_ = m_; jj_ <= (*igh_); (jj_)++) {
        j_ = mp_ - jj_;
        fr_ = fr_ + ortr_[j_ - 1] * ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - orti_[j_ - 1] * ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        fi_ = fi_ + ortr_[j_ - 1] * ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + orti_[j_ - 1] * ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      fr_ = fr_ / h_;
      fi_ = fi_ / h_;
      for (j_ = m_; j_ <= (*igh_); (j_)++) {
        ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - fr_ * ortr_[j_ - 1] - fi_ * orti_[j_ - 1];
        ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + fr_ * orti_[j_ - 1] - fi_ * ortr_[j_ - 1];
      }
    }
    ortr_[m_ - 1] = scale_ * ortr_[m_ - 1];
    orti_[m_ - 1] = scale_ * orti_[m_ - 1];
    ar_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))] = -g_ * ar_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))];
    ai_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))] = -g_ * ai_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))];
    _l180:;
  }
  _l200:;
  __calls[23].calls++;
  return 0;
}

int_4 _csroot (real_8 _p_ xr_, real_8 _p_ xi_, real_8 _p_ yr_, real_8 _p_ yi_)
{
  static real_8 s_, tr_, ti_;
  extern real_8 _pythag ();
  tr_ = (*xr_);
  ti_ = (*xi_);
  s_ = sqrt (0.5e0 * (_pythag (&tr_, &ti_) + _abs (tr_)));
  if (tr_ >= 0.0e0) {
    (*yr_) = s_;
  }
  if (ti_ < 0.0e0) {
    s_ = -s_;
  }
  if (tr_ <= 0.0e0) {
    (*yi_) = s_;
  }
  if (tr_ < 0.0e0) {
    (*yr_) = 0.5e0 * (ti_ / (*yi_));
  }
  if (tr_ > 0.0e0) {
    (*yi_) = 0.5e0 * (ti_ / (*yr_));
  }
  __calls[24].calls++;
  return 0;
}

int_4 _eisdoc (void)
{
  __calls[25].calls++;
  return 0;
}

int_4 _elmbak (int_4 _p_ nm_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, int_4 _p_ int_, int_4 _p_ m_, real_8 _p_ 
z_)
{
  static int_4 i_, j_, la_, mm_, mp_, kp1_, mp1_;
  static real_8 x_;
  if ((*m_) == 0) {
    goto _l200;
  }
  la_ = (*igh_) - 1;
  kp1_ = (*low_) + 1;
  if (la_ < kp1_) {
    goto _l200;
  }
  for (mm_ = kp1_; mm_ <= la_; (mm_)++) {
    mp_ = (*low_) + (*igh_) - mm_;
    mp1_ = mp_ + 1;
    for (i_ = mp1_; i_ <= (*igh_); (i_)++) {
      x_ = a_[i_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
      if (x_ == 0.0e0) {
        goto _l110;
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + x_ * z_[mp_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      _l110:;
    }
    i_ = int_[mp_ - 1];
    if (i_ == mp_) {
      goto _l140;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      x_ = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[mp_ - 1 + ((*nm_)) * ((j_ - 1))];
      z_[mp_ - 1 + ((*nm_)) * ((j_ - 1))] = x_;
    }
    _l140:;
  }
  _l200:;
  __calls[26].calls++;
  return 0;
}

int_4 _elmhes (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, int_4 _p_ int_)
{
  static int_4 i_, j_, m_, la_, kp1_, mm1_, mp1_;
  static real_8 x_, y_;
  int_4 inte_[((*igh_))];
  la_ = (*igh_) - 1;
  kp1_ = (*low_) + 1;
  if (la_ < kp1_) {
    goto _l200;
  }
  for (m_ = kp1_; m_ <= la_; (m_)++) {
    mm1_ = m_ - 1;
    x_ = 0.0;
    i_ = m_;
    for (j_ = m_; j_ <= (*igh_); (j_)++) {
      if (_abs (a_[j_ - 1 + ((*nm_)) * ((mm1_ - 1))]) <= _abs (x_)) {
        goto _l100;
      }
      x_ = a_[j_ - 1 + ((*nm_)) * ((mm1_ - 1))];
      i_ = j_;
      _l100:;
    }
    inte_[m_ - 1] = i_;
    if (i_ == m_) {
      goto _l130;
    }
    for (j_ = mm1_; j_ <= (*n_); (j_)++) {
      y_ = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[m_ - 1 + ((*nm_)) * ((j_ - 1))];
      a_[m_ - 1 + ((*nm_)) * ((j_ - 1))] = y_;
    }
    for (j_ = 1; j_ <= (*igh_); (j_)++) {
      y_ = a_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = a_[j_ - 1 + ((*nm_)) * ((m_ - 1))];
      a_[j_ - 1 + ((*nm_)) * ((m_ - 1))] = y_;
    }
    _l130:;
    if (x_ == 0.0e0) {
      goto _l180;
    }
    mp1_ = m_ + 1;
    for (i_ = mp1_; i_ <= (*igh_); (i_)++) {
      y_ = a_[i_ - 1 + ((*nm_)) * ((mm1_ - 1))];
      if (y_ == 0.0e0) {
        goto _l160;
      }
      y_ = y_ / x_;
      a_[i_ - 1 + ((*nm_)) * ((mm1_ - 1))] = y_;
      for (j_ = m_; j_ <= (*n_); (j_)++) {
        a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - y_ * a_[m_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      for (j_ = 1; j_ <= (*igh_); (j_)++) {
        a_[j_ - 1 + ((*nm_)) * ((m_ - 1))] = a_[j_ - 1 + ((*nm_)) * ((m_ - 1))] + y_ * a_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
      _l160:;
    }
    _l180:;
  }
  _l200:;
  __calls[27].calls++;
  return 0;
}

int_4 _eltran (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, int_4 _p_ int_, real_8 _p_ 
z_)
{
  static int_4 i_, j_, kl_, mm_, mp_, mp1_;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    z_[j_ - 1 + ((*nm_)) * ((j_ - 1))] = 1.0;
  }
  kl_ = (*igh_) - (*low_) - 1;
  if (kl_ < 1) {
    goto _l200;
  }
  for (mm_ = 1; mm_ <= kl_; (mm_)++) {
    mp_ = (*igh_) - mm_;
    mp1_ = mp_ + 1;
    for (i_ = mp1_; i_ <= (*igh_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((mp_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
    }
    i_ = int_[mp_ - 1];
    if (i_ == mp_) {
      goto _l140;
    }
    for (j_ = mp_; j_ <= (*igh_); (j_)++) {
      z_[mp_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    z_[i_ - 1 + ((*nm_)) * ((mp_ - 1))] = 1.0;
    _l140:;
  }
  _l200:;
  __calls[28].calls++;
  return 0;
}

real_8 _epslon (real_8 _p_ x_)
{
  static real_8 a_, b_, c_, eps_;
  real_8 epslon_;
  a_ = 1.3333333333333333;
  _l10:;
  b_ = a_ - 1.0e0;
  c_ = b_ + b_ + b_;
  eps_ = _abs (c_ - 1.0e0);
  if (eps_ == 0.0e0) {
    goto _l10;
  }
  epslon_ = eps_ * _abs ((*x_));
  __calls[29].calls++;
  return epslon_;
}

int_4 _figi2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  static real_8 h_;
  real_8 $0_;
  (*ierr_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    if (i_ == 1) {
      goto _l70;
    }
    h_ = t_[i_ - 1 + ((*nm_)) * ((0))] * t_[i_ - 1 - 1 + ((*nm_)) * ((2))];
    $0_ = h_;
    if ($0_ < 0) {
      goto _l900;
    } else if ($0_ == 0) {
      goto _l60;
    } else {
      goto _l80;
    }
    _l60:;
    if (t_[i_ - 1 + ((*nm_)) * ((0))] != 0.0e0 || t_[i_ - 1 - 1 + ((*nm_)) * ((2))] != 0.0e0) {
      goto _l1000;
    }
    e_[i_ - 1] = 0.0;
    _l70:;
    z_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = 1.0;
    goto _l90;
    _l80:;
    e_[i_ - 1] = sqrt (h_);
    z_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = z_[i_ - 1 - 1 + ((*nm_)) * ((i_ - 1 - 1))] * e_[i_ - 1] / t_[i_ - 1 - 1 + ((*nm_)) 
    * ((2))];
    _l90:;
    d_[i_ - 1] = t_[i_ - 1 + ((*nm_)) * ((1))];
  }
  goto _l1001;
  _l900:;
  (*ierr_) = (*n_) + i_;
  goto _l1001;
  _l1000:;
  (*ierr_) = 2 * (*n_) + i_;
  _l1001:;
  __calls[30].calls++;
  return 0;
}

int_4 _figi (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, int_4 _p_ ierr_)
{
  static int_4 i_;
  real_8 $0_;
  (*ierr_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ == 1) {
      goto _l90;
    }
    e2_[i_ - 1] = t_[i_ - 1 + ((*nm_)) * ((0))] * t_[i_ - 1 - 1 + ((*nm_)) * ((2))];
    $0_ = e2_[i_ - 1];
    if ($0_ < 0) {
      goto _l1000;
    } else if ($0_ == 0) {
      goto _l60;
    } else {
      goto _l80;
    }
    _l60:;
    if (t_[i_ - 1 + ((*nm_)) * ((0))] == 0.0e0 && t_[i_ - 1 - 1 + ((*nm_)) * ((2))] == 0.0e0) {
      goto _l80;
    }
    (*ierr_) = -(3 * (*n_) + i_);
    _l80:;
    e_[i_ - 1] = sqrt (e2_[i_ - 1]);
    _l90:;
    d_[i_ - 1] = t_[i_ - 1 + ((*nm_)) * ((1))];
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = (*n_) + i_;
  _l1001:;
  __calls[31].calls++;
  return 0;
}

int_4 _hqr2 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ h_, real_8 _p_ wr_, real_8 _p_ wi_
, real_8 _p_ z_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, l_, m_, en_, ii_, jj_, ll_, mm_, na_, nn_, itn_, its_, mp2_, enm2_;
  static logical_4 notlas_;
  static real_8 p_, q_, r_, s_, t_, w_, x_, y_, ra_, sa_, vi_, vr_, zz_, norm_, tst1_, tst2_;
  real_8 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  (*ierr_) = 0;
  norm_ = 0.0;
  k_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = k_; j_ <= (*n_); (j_)++) {
      norm_ = norm_ + _abs (h_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
    }
    k_ = i_;
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l50;
    }
    wr_[i_ - 1] = h_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    wi_[i_ - 1] = 0.0;
    _l50:;
  }
  en_ = (*igh_);
  t_ = 0.0;
  itn_ = 30 * (*n_);
  _l60:;
  if (en_ < (*low_)) {
    goto _l340;
  }
  its_ = 0;
  na_ = en_ - 1;
  enm2_ = na_ - 1;
  _l70:;
  for (ll_ = (*low_); ll_ <= en_; (ll_)++) {
    l_ = en_ + (*low_) - ll_;
    if (l_ == (*low_)) {
      goto _l100;
    }
    s_ = _abs (h_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs (h_[l_ - 1 + ((*nm_)) * ((l_ - 1))]);
    if (s_ == 0.0e0) {
      s_ = norm_;
    }
    tst1_ = s_;
    tst2_ = tst1_ + _abs (h_[l_ - 1 + ((*nm_)) * ((l_ - 1 - 1))]);
    if (tst2_ == tst1_) {
      goto _l100;
    }
  }
  _l100:;
  x_ = h_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  if (l_ == en_) {
    goto _l270;
  }
  y_ = h_[na_ - 1 + ((*nm_)) * ((na_ - 1))];
  w_ = h_[en_ - 1 + ((*nm_)) * ((na_ - 1))] * h_[na_ - 1 + ((*nm_)) * ((en_ - 1))];
  if (l_ == na_) {
    goto _l280;
  }
  if (itn_ == 0) {
    goto _l1000;
  }
  if (its_ != 10 && its_ != 20) {
    goto _l130;
  }
  t_ = t_ + x_;
  for (i_ = (*low_); i_ <= en_; (i_)++) {
    h_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = h_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - x_;
  }
  s_ = _abs (h_[en_ - 1 + ((*nm_)) * ((na_ - 1))]) + _abs (h_[na_ - 1 + ((*nm_)) * ((enm2_ - 1))]);
  x_ = 0.75e0 * s_;
  y_ = x_;
  w_ = -0.4375e0 * s_ * s_;
  _l130:;
  its_ = its_ + 1;
  itn_ = itn_ - 1;
  for (mm_ = l_; mm_ <= enm2_; (mm_)++) {
    m_ = enm2_ + l_ - mm_;
    zz_ = h_[m_ - 1 + ((*nm_)) * ((m_ - 1))];
    r_ = x_ - zz_;
    s_ = y_ - zz_;
    p_ = (r_ * s_ - w_) / h_[m_ + 1 - 1 + ((*nm_)) * ((m_ - 1))] + h_[m_ - 1 + ((*nm_)) * ((m_ + 1 - 1))];
    q_ = h_[m_ + 1 - 1 + ((*nm_)) * ((m_ + 1 - 1))] - zz_ - r_ - s_;
    r_ = h_[m_ + 2 - 1 + ((*nm_)) * ((m_ + 1 - 1))];
    s_ = _abs (p_) + _abs (q_) + _abs (r_);
    p_ = p_ / s_;
    q_ = q_ / s_;
    r_ = r_ / s_;
    if (m_ == l_) {
      goto _l150;
    }
    tst1_ = _abs (p_) * (_abs (h_[m_ - 1 - 1 + ((*nm_)) * ((m_ - 1 - 1))]) + _abs (zz_) + _abs (h_[m_ + 1 - 1 + ((*nm_)) * 
    ((m_ + 1 - 1))]));
    tst2_ = tst1_ + _abs (h_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]) * (_abs (q_) + _abs (r_));
    if (tst2_ == tst1_) {
      goto _l150;
    }
  }
  _l150:;
  mp2_ = m_ + 2;
  for (i_ = mp2_; i_ <= en_; (i_)++) {
    h_[i_ - 1 + ((*nm_)) * ((i_ - 2 - 1))] = 0.0;
    if (i_ == mp2_) {
      goto _l160;
    }
    h_[i_ - 1 + ((*nm_)) * ((i_ - 3 - 1))] = 0.0;
    _l160:;
  }
  for (k_ = m_; k_ <= na_; (k_)++) {
    notlas_ = k_ != na_;
    if (k_ == m_) {
      goto _l170;
    }
    p_ = h_[k_ - 1 + ((*nm_)) * ((k_ - 1 - 1))];
    q_ = h_[k_ + 1 - 1 + ((*nm_)) * ((k_ - 1 - 1))];
    r_ = 0.0;
    if (notlas_) {
      r_ = h_[k_ + 2 - 1 + ((*nm_)) * ((k_ - 1 - 1))];
    }
    x_ = _abs (p_) + _abs (q_) + _abs (r_);
    if (x_ == 0.0e0) {
      goto _l260;
    }
    p_ = p_ / x_;
    q_ = q_ / x_;
    r_ = r_ / x_;
    _l170:;
    s_ = _sign (sqrt (p_ * p_ + q_ * q_ + r_ * r_), p_);
    if (k_ == m_) {
      goto _l180;
    }
    h_[k_ - 1 + ((*nm_)) * ((k_ - 1 - 1))] = -s_ * x_;
    goto _l190;
    _l180:;
    if (l_ != m_) {
      h_[k_ - 1 + ((*nm_)) * ((k_ - 1 - 1))] = -h_[k_ - 1 + ((*nm_)) * ((k_ - 1 - 1))];
    }
    _l190:;
    p_ = p_ + s_;
    x_ = p_ / s_;
    y_ = q_ / s_;
    zz_ = r_ / s_;
    q_ = q_ / p_;
    r_ = r_ / p_;
    if (notlas_) {
      goto _l225;
    }
    for (j_ = k_; j_ <= (*n_); (j_)++) {
      p_ = h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + q_ * h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))];
      h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - p_ * x_;
      h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] - p_ * y_;
    }
    j_ = _min (en_, k_ + 3);
    for (i_ = 1; i_ <= j_; (i_)++) {
      p_ = x_ * h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + y_ * h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))];
      h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - p_;
      h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] - p_ * q_;
    }
    for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
      p_ = x_ * z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + y_ * z_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))];
      z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - p_;
      z_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] = z_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] - p_ * q_;
    }
    goto _l255;
    _l225:;
    for (j_ = k_; j_ <= (*n_); (j_)++) {
      p_ = h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + q_ * h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] + r_ * h_[k_ + 2 - 1 + ((*nm_)) * 
      ((j_ - 1))];
      h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - p_ * x_;
      h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] - p_ * y_;
      h_[k_ + 2 - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ + 2 - 1 + ((*nm_)) * ((j_ - 1))] - p_ * zz_;
    }
    j_ = _min (en_, k_ + 3);
    for (i_ = 1; i_ <= j_; (i_)++) {
      p_ = x_ * h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + y_ * h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] + zz_ * h_[i_ - 1 + ((*nm_)) 
      * ((k_ + 2 - 1))];
      h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - p_;
      h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] - p_ * q_;
      h_[i_ - 1 + ((*nm_)) * ((k_ + 2 - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ + 2 - 1))] - p_ * r_;
    }
    for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
      p_ = x_ * z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + y_ * z_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] + zz_ * z_[i_ - 1 + ((*nm_)) 
      * ((k_ + 2 - 1))];
      z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - p_;
      z_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] = z_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] - p_ * q_;
      z_[i_ - 1 + ((*nm_)) * ((k_ + 2 - 1))] = z_[i_ - 1 + ((*nm_)) * ((k_ + 2 - 1))] - p_ * r_;
    }
    _l255:;
    _l260:;
  }
  goto _l70;
  _l270:;
  h_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = x_ + t_;
  wr_[en_ - 1] = h_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  wi_[en_ - 1] = 0.0;
  en_ = na_;
  goto _l60;
  _l280:;
  p_ = (y_ - x_) / 2.0e0;
  q_ = p_ * p_ + w_;
  zz_ = sqrt (_abs (q_));
  h_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = x_ + t_;
  x_ = h_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  h_[na_ - 1 + ((*nm_)) * ((na_ - 1))] = y_ + t_;
  if (q_ < 0.0e0) {
    goto _l320;
  }
  zz_ = p_ + _sign (zz_, p_);
  wr_[na_ - 1] = x_ + zz_;
  wr_[en_ - 1] = wr_[na_ - 1];
  if (zz_ != 0.0e0) {
    wr_[en_ - 1] = x_ - w_ / zz_;
  }
  wi_[na_ - 1] = 0.0;
  wi_[en_ - 1] = 0.0;
  x_ = h_[en_ - 1 + ((*nm_)) * ((na_ - 1))];
  s_ = _abs (x_) + _abs (zz_);
  p_ = x_ / s_;
  q_ = zz_ / s_;
  r_ = sqrt (p_ * p_ + q_ * q_);
  p_ = p_ / r_;
  q_ = q_ / r_;
  for (j_ = na_; j_ <= (*n_); (j_)++) {
    zz_ = h_[na_ - 1 + ((*nm_)) * ((j_ - 1))];
    h_[na_ - 1 + ((*nm_)) * ((j_ - 1))] = q_ * zz_ + p_ * h_[en_ - 1 + ((*nm_)) * ((j_ - 1))];
    h_[en_ - 1 + ((*nm_)) * ((j_ - 1))] = q_ * h_[en_ - 1 + ((*nm_)) * ((j_ - 1))] - p_ * zz_;
  }
  for (i_ = 1; i_ <= en_; (i_)++) {
    zz_ = h_[i_ - 1 + ((*nm_)) * ((na_ - 1))];
    h_[i_ - 1 + ((*nm_)) * ((na_ - 1))] = q_ * zz_ + p_ * h_[i_ - 1 + ((*nm_)) * ((en_ - 1))];
    h_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = q_ * h_[i_ - 1 + ((*nm_)) * ((en_ - 1))] - p_ * zz_;
  }
  for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
    zz_ = z_[i_ - 1 + ((*nm_)) * ((na_ - 1))];
    z_[i_ - 1 + ((*nm_)) * ((na_ - 1))] = q_ * zz_ + p_ * z_[i_ - 1 + ((*nm_)) * ((en_ - 1))];
    z_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = q_ * z_[i_ - 1 + ((*nm_)) * ((en_ - 1))] - p_ * zz_;
  }
  goto _l330;
  _l320:;
  wr_[na_ - 1] = x_ + p_;
  wr_[en_ - 1] = x_ + p_;
  wi_[na_ - 1] = zz_;
  wi_[en_ - 1] = -zz_;
  _l330:;
  en_ = enm2_;
  goto _l60;
  _l340:;
  if (norm_ == 0.0e0) {
    goto _l1001;
  }
  for (nn_ = 1; nn_ <= (*n_); (nn_)++) {
    en_ = (*n_) + 1 - nn_;
    p_ = wr_[en_ - 1];
    q_ = wi_[en_ - 1];
    na_ = en_ - 1;
    $0_ = q_;
    if ($0_ < 0) {
      goto _l710;
    } else if ($0_ == 0) {
      goto _l600;
    } else {
      goto _l800;
    }
    _l600:;
    m_ = en_;
    h_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 1.0;
    if (na_ == 0) {
      goto _l800;
    }
    for (ii_ = 1; ii_ <= na_; (ii_)++) {
      i_ = en_ - ii_;
      w_ = h_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - p_;
      r_ = 0.0;
      for (j_ = m_; j_ <= en_; (j_)++) {
        r_ = r_ + h_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * h_[j_ - 1 + ((*nm_)) * ((en_ - 1))];
      }
      if (wi_[i_ - 1] >= 0.0e0) {
        goto _l630;
      }
      zz_ = w_;
      s_ = r_;
      goto _l700;
      _l630:;
      m_ = i_;
      if (wi_[i_ - 1] != 0.0e0) {
        goto _l640;
      }
      t_ = w_;
      if (t_ != 0.0e0) {
        goto _l635;
      }
      tst1_ = norm_;
      t_ = tst1_;
      _l632:;
      t_ = 0.01e0 * t_;
      tst2_ = norm_ + t_;
      if (tst2_ > tst1_) {
        goto _l632;
      }
      _l635:;
      h_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = -r_ / t_;
      goto _l680;
      _l640:;
      x_ = h_[i_ - 1 + ((*nm_)) * ((i_ + 1 - 1))];
      y_ = h_[i_ + 1 - 1 + ((*nm_)) * ((i_ - 1))];
      q_ = (wr_[i_ - 1] - p_) * (wr_[i_ - 1] - p_) + wi_[i_ - 1] * wi_[i_ - 1];
      t_ = (x_ * s_ - zz_ * r_) / q_;
      h_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = t_;
      if (_abs (x_) <= _abs (zz_)) {
        goto _l650;
      }
      h_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))] = (-r_ - w_ * t_) / x_;
      goto _l680;
      _l650:;
      h_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))] = (-s_ - y_ * t_) / zz_;
      _l680:;
      t_ = _abs (h_[i_ - 1 + ((*nm_)) * ((en_ - 1))]);
      if (t_ == 0.0e0) {
        goto _l700;
      }
      tst1_ = t_;
      tst2_ = tst1_ + 1.0e0 / tst1_;
      if (tst2_ > tst1_) {
        goto _l700;
      }
      for (j_ = i_; j_ <= en_; (j_)++) {
        h_[j_ - 1 + ((*nm_)) * ((en_ - 1))] = h_[j_ - 1 + ((*nm_)) * ((en_ - 1))] / t_;
      }
      _l700:;
    }
    goto _l800;
    _l710:;
    m_ = na_;
    if (_abs (h_[en_ - 1 + ((*nm_)) * ((na_ - 1))]) <= _abs (h_[na_ - 1 + ((*nm_)) * ((en_ - 1))])) {
      goto _l720;
    }
    h_[na_ - 1 + ((*nm_)) * ((na_ - 1))] = q_ / h_[en_ - 1 + ((*nm_)) * ((na_ - 1))];
    h_[na_ - 1 + ((*nm_)) * ((en_ - 1))] = -(h_[en_ - 1 + ((*nm_)) * ((en_ - 1))] - p_) / h_[en_ - 1 + ((*nm_)) * ((na_ - 
    1))];
    goto _l730;
    _l720:;
    (void) _cdiv (($1_ = 0.0, &$1_), ($2_ = -h_[na_ - 1 + ((*nm_)) * ((en_ - 1))], &$2_), ($3_ = h_[na_ - 1 + ((*nm_)) * 
    ((na_ - 1))] - p_, &$3_), &q_, &h_[na_ - 1 + ((*nm_)) * ((na_ - 1))], &h_[na_ - 1 + ((*nm_)) * ((en_ - 1))]);
    _l730:;
    h_[en_ - 1 + ((*nm_)) * ((na_ - 1))] = 0.0;
    h_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 1.0;
    enm2_ = na_ - 1;
    if (enm2_ == 0) {
      goto _l800;
    }
    for (ii_ = 1; ii_ <= enm2_; (ii_)++) {
      i_ = na_ - ii_;
      w_ = h_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - p_;
      ra_ = 0.0;
      sa_ = 0.0;
      for (j_ = m_; j_ <= en_; (j_)++) {
        ra_ = ra_ + h_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * h_[j_ - 1 + ((*nm_)) * ((na_ - 1))];
        sa_ = sa_ + h_[i_ - 1 + ((*nm_)) * ((j_ - 1))] * h_[j_ - 1 + ((*nm_)) * ((en_ - 1))];
      }
      if (wi_[i_ - 1] >= 0.0e0) {
        goto _l770;
      }
      zz_ = w_;
      r_ = ra_;
      s_ = sa_;
      goto _l795;
      _l770:;
      m_ = i_;
      if (wi_[i_ - 1] != 0.0e0) {
        goto _l780;
      }
      (void) _cdiv (($4_ = -ra_, &$4_), ($5_ = -sa_, &$5_), &w_, &q_, &h_[i_ - 1 + ((*nm_)) * ((na_ - 1))], &h_[i_ - 1 + 
      ((*nm_)) * ((en_ - 1))]);
      goto _l790;
      _l780:;
      x_ = h_[i_ - 1 + ((*nm_)) * ((i_ + 1 - 1))];
      y_ = h_[i_ + 1 - 1 + ((*nm_)) * ((i_ - 1))];
      vr_ = (wr_[i_ - 1] - p_) * (wr_[i_ - 1] - p_) + wi_[i_ - 1] * wi_[i_ - 1] - q_ * q_;
      vi_ = (wr_[i_ - 1] - p_) * 2.0e0 * q_;
      if (vr_ != 0.0e0 || vi_ != 0.0e0) {
        goto _l784;
      }
      tst1_ = norm_ * (_abs (w_) + _abs (q_) + _abs (x_) + _abs (y_) + _abs (zz_));
      vr_ = tst1_;
      _l783:;
      vr_ = 0.01e0 * vr_;
      tst2_ = tst1_ + vr_;
      if (tst2_ > tst1_) {
        goto _l783;
      }
      _l784:;
      (void) _cdiv (($6_ = x_ * r_ - zz_ * ra_ + q_ * sa_, &$6_), ($7_ = x_ * s_ - zz_ * sa_ - q_ * ra_, &$7_), &vr_, &vi_, 
      &h_[i_ - 1 + ((*nm_)) * ((na_ - 1))], &h_[i_ - 1 + ((*nm_)) * ((en_ - 1))]);
      if (_abs (x_) <= _abs (zz_) + _abs (q_)) {
        goto _l785;
      }
      h_[i_ + 1 - 1 + ((*nm_)) * ((na_ - 1))] = (-ra_ - w_ * h_[i_ - 1 + ((*nm_)) * ((na_ - 1))] + q_ * h_[i_ - 1 + ((*nm_)) 
      * ((en_ - 1))]) / x_;
      h_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))] = (-sa_ - w_ * h_[i_ - 1 + ((*nm_)) * ((en_ - 1))] - q_ * h_[i_ - 1 + ((*nm_)) 
      * ((na_ - 1))]) / x_;
      goto _l790;
      _l785:;
      (void) _cdiv (($8_ = -r_ - y_ * h_[i_ - 1 + ((*nm_)) * ((na_ - 1))], &$8_), ($9_ = -s_ - y_ * h_[i_ - 1 + ((*nm_)) * 
      ((en_ - 1))], &$9_), &zz_, &q_, &h_[i_ + 1 - 1 + ((*nm_)) * ((na_ - 1))], &h_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))]);
      _l790:;
      t_ = _max (_abs (h_[i_ - 1 + ((*nm_)) * ((na_ - 1))]), _abs (h_[i_ - 1 + ((*nm_)) * ((en_ - 1))]));
      if (t_ == 0.0e0) {
        goto _l795;
      }
      tst1_ = t_;
      tst2_ = tst1_ + 1.0e0 / tst1_;
      if (tst2_ > tst1_) {
        goto _l795;
      }
      for (j_ = i_; j_ <= en_; (j_)++) {
        h_[j_ - 1 + ((*nm_)) * ((na_ - 1))] = h_[j_ - 1 + ((*nm_)) * ((na_ - 1))] / t_;
        h_[j_ - 1 + ((*nm_)) * ((en_ - 1))] = h_[j_ - 1 + ((*nm_)) * ((en_ - 1))] / t_;
      }
      _l795:;
    }
    _l800:;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l840;
    }
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = h_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
    _l840:;
  }
  for (jj_ = (*low_); jj_ <= (*n_); (jj_)++) {
    j_ = (*n_) + (*low_) - jj_;
    m_ = _min (j_, (*igh_));
    for (i_ = (*low_); i_ <= (*igh_); (i_)++) {
      zz_ = 0.0;
      for (k_ = (*low_); k_ <= m_; (k_)++) {
        zz_ = zz_ + z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * h_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zz_;
    }
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = en_;
  _l1001:;
  __calls[32].calls++;
  return 0;
}

int_4 _hqr (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ h_, real_8 _p_ wr_, real_8 _p_ wi_, 
int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, l_, m_, en_, ll_, mm_, na_, itn_, its_, mp2_, enm2_;
  static logical_4 notlas_;
  static real_8 p_, q_, r_, s_, t_, w_, x_, y_, zz_, norm_, tst1_, tst2_;
  (*ierr_) = 0;
  norm_ = 0.0;
  k_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = k_; j_ <= (*n_); (j_)++) {
      norm_ = norm_ + _abs (h_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
    }
    k_ = i_;
    if (i_ >= (*low_) && i_ <= (*igh_)) {
      goto _l50;
    }
    wr_[i_ - 1] = h_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    wi_[i_ - 1] = 0.0;
    _l50:;
  }
  en_ = (*igh_);
  t_ = 0.0;
  itn_ = 30 * (*n_);
  _l60:;
  if (en_ < (*low_)) {
    goto _l1001;
  }
  its_ = 0;
  na_ = en_ - 1;
  enm2_ = na_ - 1;
  _l70:;
  for (ll_ = (*low_); ll_ <= en_; (ll_)++) {
    l_ = en_ + (*low_) - ll_;
    if (l_ == (*low_)) {
      goto _l100;
    }
    s_ = _abs (h_[l_ - 1 - 1 + ((*nm_)) * ((l_ - 1 - 1))]) + _abs (h_[l_ - 1 + ((*nm_)) * ((l_ - 1))]);
    if (s_ == 0.0e0) {
      s_ = norm_;
    }
    tst1_ = s_;
    tst2_ = tst1_ + _abs (h_[l_ - 1 + ((*nm_)) * ((l_ - 1 - 1))]);
    if (tst2_ == tst1_) {
      goto _l100;
    }
  }
  _l100:;
  x_ = h_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  if (l_ == en_) {
    goto _l270;
  }
  y_ = h_[na_ - 1 + ((*nm_)) * ((na_ - 1))];
  w_ = h_[en_ - 1 + ((*nm_)) * ((na_ - 1))] * h_[na_ - 1 + ((*nm_)) * ((en_ - 1))];
  if (l_ == na_) {
    goto _l280;
  }
  if (itn_ == 0) {
    goto _l1000;
  }
  if (its_ != 10 && its_ != 20) {
    goto _l130;
  }
  t_ = t_ + x_;
  for (i_ = (*low_); i_ <= en_; (i_)++) {
    h_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = h_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - x_;
  }
  s_ = _abs (h_[en_ - 1 + ((*nm_)) * ((na_ - 1))]) + _abs (h_[na_ - 1 + ((*nm_)) * ((enm2_ - 1))]);
  x_ = 0.75e0 * s_;
  y_ = x_;
  w_ = -0.4375e0 * s_ * s_;
  _l130:;
  its_ = its_ + 1;
  itn_ = itn_ - 1;
  for (mm_ = l_; mm_ <= enm2_; (mm_)++) {
    m_ = enm2_ + l_ - mm_;
    zz_ = h_[m_ - 1 + ((*nm_)) * ((m_ - 1))];
    r_ = x_ - zz_;
    s_ = y_ - zz_;
    p_ = (r_ * s_ - w_) / h_[m_ + 1 - 1 + ((*nm_)) * ((m_ - 1))] + h_[m_ - 1 + ((*nm_)) * ((m_ + 1 - 1))];
    q_ = h_[m_ + 1 - 1 + ((*nm_)) * ((m_ + 1 - 1))] - zz_ - r_ - s_;
    r_ = h_[m_ + 2 - 1 + ((*nm_)) * ((m_ + 1 - 1))];
    s_ = _abs (p_) + _abs (q_) + _abs (r_);
    p_ = p_ / s_;
    q_ = q_ / s_;
    r_ = r_ / s_;
    if (m_ == l_) {
      goto _l150;
    }
    tst1_ = _abs (p_) * (_abs (h_[m_ - 1 - 1 + ((*nm_)) * ((m_ - 1 - 1))]) + _abs (zz_) + _abs (h_[m_ + 1 - 1 + ((*nm_)) * 
    ((m_ + 1 - 1))]));
    tst2_ = tst1_ + _abs (h_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]) * (_abs (q_) + _abs (r_));
    if (tst2_ == tst1_) {
      goto _l150;
    }
  }
  _l150:;
  mp2_ = m_ + 2;
  for (i_ = mp2_; i_ <= en_; (i_)++) {
    h_[i_ - 1 + ((*nm_)) * ((i_ - 2 - 1))] = 0.0;
    if (i_ == mp2_) {
      goto _l160;
    }
    h_[i_ - 1 + ((*nm_)) * ((i_ - 3 - 1))] = 0.0;
    _l160:;
  }
  for (k_ = m_; k_ <= na_; (k_)++) {
    notlas_ = k_ != na_;
    if (k_ == m_) {
      goto _l170;
    }
    p_ = h_[k_ - 1 + ((*nm_)) * ((k_ - 1 - 1))];
    q_ = h_[k_ + 1 - 1 + ((*nm_)) * ((k_ - 1 - 1))];
    r_ = 0.0;
    if (notlas_) {
      r_ = h_[k_ + 2 - 1 + ((*nm_)) * ((k_ - 1 - 1))];
    }
    x_ = _abs (p_) + _abs (q_) + _abs (r_);
    if (x_ == 0.0e0) {
      goto _l260;
    }
    p_ = p_ / x_;
    q_ = q_ / x_;
    r_ = r_ / x_;
    _l170:;
    s_ = _sign (sqrt (p_ * p_ + q_ * q_ + r_ * r_), p_);
    if (k_ == m_) {
      goto _l180;
    }
    h_[k_ - 1 + ((*nm_)) * ((k_ - 1 - 1))] = -s_ * x_;
    goto _l190;
    _l180:;
    if (l_ != m_) {
      h_[k_ - 1 + ((*nm_)) * ((k_ - 1 - 1))] = -h_[k_ - 1 + ((*nm_)) * ((k_ - 1 - 1))];
    }
    _l190:;
    p_ = p_ + s_;
    x_ = p_ / s_;
    y_ = q_ / s_;
    zz_ = r_ / s_;
    q_ = q_ / p_;
    r_ = r_ / p_;
    if (notlas_) {
      goto _l225;
    }
    for (j_ = k_; j_ <= en_; (j_)++) {
      p_ = h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + q_ * h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))];
      h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - p_ * x_;
      h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] - p_ * y_;
    }
    j_ = _min (en_, k_ + 3);
    for (i_ = l_; i_ <= j_; (i_)++) {
      p_ = x_ * h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + y_ * h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))];
      h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - p_;
      h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] - p_ * q_;
    }
    goto _l255;
    _l225:;
    for (j_ = k_; j_ <= en_; (j_)++) {
      p_ = h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + q_ * h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] + r_ * h_[k_ + 2 - 1 + ((*nm_)) * 
      ((j_ - 1))];
      h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - p_ * x_;
      h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*nm_)) * ((j_ - 1))] - p_ * y_;
      h_[k_ + 2 - 1 + ((*nm_)) * ((j_ - 1))] = h_[k_ + 2 - 1 + ((*nm_)) * ((j_ - 1))] - p_ * zz_;
    }
    j_ = _min (en_, k_ + 3);
    for (i_ = l_; i_ <= j_; (i_)++) {
      p_ = x_ * h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + y_ * h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] + zz_ * h_[i_ - 1 + ((*nm_)) 
      * ((k_ + 2 - 1))];
      h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - p_;
      h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ + 1 - 1))] - p_ * q_;
      h_[i_ - 1 + ((*nm_)) * ((k_ + 2 - 1))] = h_[i_ - 1 + ((*nm_)) * ((k_ + 2 - 1))] - p_ * r_;
    }
    _l255:;
    _l260:;
  }
  goto _l70;
  _l270:;
  wr_[en_ - 1] = x_ + t_;
  wi_[en_ - 1] = 0.0;
  en_ = na_;
  goto _l60;
  _l280:;
  p_ = (y_ - x_) / 2.0e0;
  q_ = p_ * p_ + w_;
  zz_ = sqrt (_abs (q_));
  x_ = x_ + t_;
  if (q_ < 0.0e0) {
    goto _l320;
  }
  zz_ = p_ + _sign (zz_, p_);
  wr_[na_ - 1] = x_ + zz_;
  wr_[en_ - 1] = wr_[na_ - 1];
  if (zz_ != 0.0e0) {
    wr_[en_ - 1] = x_ - w_ / zz_;
  }
  wi_[na_ - 1] = 0.0;
  wi_[en_ - 1] = 0.0;
  goto _l330;
  _l320:;
  wr_[na_ - 1] = x_ + p_;
  wr_[en_ - 1] = x_ + p_;
  wi_[na_ - 1] = zz_;
  wi_[en_ - 1] = -zz_;
  _l330:;
  en_ = enm2_;
  goto _l60;
  _l1000:;
  (*ierr_) = en_;
  _l1001:;
  __calls[33].calls++;
  return 0;
}

int_4 _htrib3 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ tau_, int_4 _p_ m_, real_8 _p_ zr_, real_8 _p_ 
zi_)
{
  static int_4 i_, j_, k_, l_;
  static real_8 h_, s_, si_;
  if ((*m_) == 0) {
    goto _l200;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = -zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * tau_[1 + (2) * ((k_ - 1))];
      zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * tau_[0 + (2) * ((k_ - 1))];
    }
  }
  if ((*n_) == 1) {
    goto _l200;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    l_ = i_ - 1;
    h_ = a_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    if (h_ == 0.0e0) {
      goto _l140;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      s_ = 0.0;
      si_ = 0.0;
      for (k_ = 1; k_ <= l_; (k_)++) {
        s_ = s_ + a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] 
        * zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
        si_ = si_ + a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + a_[k_ - 1 + ((*nm_)) * ((i_ - 
        1))] * zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      s_ = (s_ / h_) / h_;
      si_ = (si_ / h_) / h_;
      for (k_ = 1; k_ <= l_; (k_)++) {
        zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - s_ * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - 
        si_ * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
        zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - si_ * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + 
        s_ * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
    }
    _l140:;
  }
  _l200:;
  __calls[34].calls++;
  return 0;
}

int_4 _htribk (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ tau_, int_4 _p_ m_, real_8 _p_ 
zr_, real_8 _p_ zi_)
{
  static int_4 i_, j_, k_, l_;
  static real_8 h_, s_, si_;
  if ((*m_) == 0) {
    goto _l200;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = -zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * tau_[1 + (2) * ((k_ - 1))];
      zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * tau_[0 + (2) * ((k_ - 1))];
    }
  }
  if ((*n_) == 1) {
    goto _l200;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    l_ = i_ - 1;
    h_ = ai_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    if (h_ == 0.0e0) {
      goto _l140;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      s_ = 0.0;
      si_ = 0.0;
      for (k_ = 1; k_ <= l_; (k_)++) {
        s_ = s_ + ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - ai_[i_ - 1 + ((*nm_)) * ((k_ - 
        1))] * zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
        si_ = si_ + ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + ai_[i_ - 1 + ((*nm_)) * ((k_ - 
        1))] * zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      s_ = (s_ / h_) / h_;
      si_ = (si_ / h_) / h_;
      for (k_ = 1; k_ <= l_; (k_)++) {
        zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = zr_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - s_ * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - 
        si_ * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
        zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = zi_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - si_ * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + 
        s_ * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
    }
    _l140:;
  }
  _l200:;
  __calls[35].calls++;
  return 0;
}

int_4 _htrid3 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, real_8 _p_ 
tau_)
{
  static int_4 i_, j_, k_, l_, ii_, jm1_, jp1_;
  static real_8 f_, g_, h_, fi_, gi_, hh_, si_, scale_;
  extern real_8 _pythag ();
  tau_[0 + (2) * (((*n_) - 1))] = 1.0;
  tau_[1 + (2) * (((*n_) - 1))] = 0.0;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 1 - ii_;
    l_ = i_ - 1;
    h_ = 0.0;
    scale_ = 0.0;
    if (l_ < 1) {
      goto _l130;
    }
    for (k_ = 1; k_ <= l_; (k_)++) {
      scale_ = scale_ + _abs (a_[i_ - 1 + ((*nm_)) * ((k_ - 1))]) + _abs (a_[k_ - 1 + ((*nm_)) * ((i_ - 1))]);
    }
    if (scale_ != 0.0e0) {
      goto _l140;
    }
    tau_[0 + (2) * ((l_ - 1))] = 1.0;
    tau_[1 + (2) * ((l_ - 1))] = 0.0;
    _l130:;
    e_[i_ - 1] = 0.0;
    e2_[i_ - 1] = 0.0;
    goto _l290;
    _l140:;
    for (k_ = 1; k_ <= l_; (k_)++) {
      a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] / scale_;
      a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] / scale_;
      h_ = h_ + a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] 
      * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
    }
    e2_[i_ - 1] = scale_ * scale_ * h_;
    g_ = sqrt (h_);
    e_[i_ - 1] = scale_ * g_;
    f_ = _pythag (&a_[i_ - 1 + ((*nm_)) * ((l_ - 1))], &a_[l_ - 1 + ((*nm_)) * ((i_ - 1))]);
    if (f_ == 0.0e0) {
      goto _l160;
    }
    tau_[0 + (2) * ((l_ - 1))] = (a_[l_ - 1 + ((*nm_)) * ((i_ - 1))] * tau_[1 + (2) * ((i_ - 1))] - a_[i_ - 1 + ((*nm_)) * 
    ((l_ - 1))] * tau_[0 + (2) * ((i_ - 1))]) / f_;
    si_ = (a_[i_ - 1 + ((*nm_)) * ((l_ - 1))] * tau_[1 + (2) * ((i_ - 1))] + a_[l_ - 1 + ((*nm_)) * ((i_ - 1))] * tau_[0 + 
    (2) * ((i_ - 1))]) / f_;
    h_ = h_ + f_ * g_;
    g_ = 1.0e0 + g_ / f_;
    a_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = g_ * a_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
    a_[l_ - 1 + ((*nm_)) * ((i_ - 1))] = g_ * a_[l_ - 1 + ((*nm_)) * ((i_ - 1))];
    if (l_ == 1) {
      goto _l270;
    }
    goto _l170;
    _l160:;
    tau_[0 + (2) * ((l_ - 1))] = -tau_[0 + (2) * ((i_ - 1))];
    si_ = tau_[1 + (2) * ((i_ - 1))];
    a_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = g_;
    _l170:;
    f_ = 0.0;
    for (j_ = 1; j_ <= l_; (j_)++) {
      g_ = 0.0;
      gi_ = 0.0;
      if (j_ == 1) {
        goto _l190;
      }
      jm1_ = j_ - 1;
      for (k_ = 1; k_ <= jm1_; (k_)++) {
        g_ = g_ + a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] 
        * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
        gi_ = gi_ - a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] + a_[k_ - 1 + ((*nm_)) * ((j_ - 
        1))] * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l190:;
      g_ = g_ + a_[j_ - 1 + ((*nm_)) * ((j_ - 1))] * a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      gi_ = gi_ - a_[j_ - 1 + ((*nm_)) * ((j_ - 1))] * a_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      jp1_ = j_ + 1;
      if (l_ < jp1_) {
        goto _l220;
      }
      for (k_ = jp1_; k_ <= l_; (k_)++) {
        g_ = g_ + a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] 
        * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
        gi_ = gi_ - a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] - a_[j_ - 1 + ((*nm_)) * ((k_ - 
        1))] * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l220:;
      e_[j_ - 1] = g_ / h_;
      tau_[1 + (2) * ((j_ - 1))] = gi_ / h_;
      f_ = f_ + e_[j_ - 1] * a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - tau_[1 + (2) * ((j_ - 1))] * a_[j_ - 1 + ((*nm_)) * ((i_ - 
      1))];
    }
    hh_ = f_ / (h_ + h_);
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      g_ = e_[j_ - 1] - hh_ * f_;
      e_[j_ - 1] = g_;
      fi_ = -a_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      gi_ = tau_[1 + (2) * ((j_ - 1))] - hh_ * fi_;
      tau_[1 + (2) * ((j_ - 1))] = -gi_;
      a_[j_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[j_ - 1 + ((*nm_)) * ((j_ - 1))] - 2.0e0 * (f_ * g_ + fi_ * gi_);
      if (j_ == 1) {
        goto _l260;
      }
      jm1_ = j_ - 1;
      for (k_ = 1; k_ <= jm1_; (k_)++) {
        a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] - f_ * e_[k_ - 1] - g_ * a_[i_ - 1 + ((*nm_)) * 
        ((k_ - 1))] + fi_ * tau_[1 + (2) * ((k_ - 1))] + gi_ * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
        a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - f_ * tau_[1 + (2) * ((k_ - 1))] - g_ * a_[k_ 
        - 1 + ((*nm_)) * ((i_ - 1))] - fi_ * e_[k_ - 1] - gi_ * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l260:;
    }
    _l270:;
    for (k_ = 1; k_ <= l_; (k_)++) {
      a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = scale_ * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = scale_ * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
    }
    tau_[1 + (2) * ((l_ - 1))] = -si_;
    _l290:;
    d_[i_ - 1] = a_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    a_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = scale_ * sqrt (h_);
  }
  __calls[36].calls++;
  return 0;
}

int_4 _htridi (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ 
e2_, real_8 _p_ tau_)
{
  static int_4 i_, j_, k_, l_, ii_, jp1_;
  static real_8 f_, g_, h_, fi_, gi_, hh_, si_, scale_;
  extern real_8 _pythag ();
  tau_[0 + (2) * (((*n_) - 1))] = 1.0;
  tau_[1 + (2) * (((*n_) - 1))] = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    d_[i_ - 1] = ar_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
  }
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 1 - ii_;
    l_ = i_ - 1;
    h_ = 0.0;
    scale_ = 0.0;
    if (l_ < 1) {
      goto _l130;
    }
    for (k_ = 1; k_ <= l_; (k_)++) {
      scale_ = scale_ + _abs (ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))]) + _abs (ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))]);
    }
    if (scale_ != 0.0e0) {
      goto _l140;
    }
    tau_[0 + (2) * ((l_ - 1))] = 1.0;
    tau_[1 + (2) * ((l_ - 1))] = 0.0;
    _l130:;
    e_[i_ - 1] = 0.0;
    e2_[i_ - 1] = 0.0;
    goto _l290;
    _l140:;
    for (k_ = 1; k_ <= l_; (k_)++) {
      ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] / scale_;
      ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))] / scale_;
      h_ = h_ + ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + ai_[i_ - 1 + ((*nm_)) * ((k_ - 
      1))] * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
    }
    e2_[i_ - 1] = scale_ * scale_ * h_;
    g_ = sqrt (h_);
    e_[i_ - 1] = scale_ * g_;
    f_ = _pythag (&ar_[i_ - 1 + ((*nm_)) * ((l_ - 1))], &ai_[i_ - 1 + ((*nm_)) * ((l_ - 1))]);
    if (f_ == 0.0e0) {
      goto _l160;
    }
    tau_[0 + (2) * ((l_ - 1))] = (ai_[i_ - 1 + ((*nm_)) * ((l_ - 1))] * tau_[1 + (2) * ((i_ - 1))] - ar_[i_ - 1 + ((*nm_)) 
    * ((l_ - 1))] * tau_[0 + (2) * ((i_ - 1))]) / f_;
    si_ = (ar_[i_ - 1 + ((*nm_)) * ((l_ - 1))] * tau_[1 + (2) * ((i_ - 1))] + ai_[i_ - 1 + ((*nm_)) * ((l_ - 1))] * tau_[0 
    + (2) * ((i_ - 1))]) / f_;
    h_ = h_ + f_ * g_;
    g_ = 1.0e0 + g_ / f_;
    ar_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = g_ * ar_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
    ai_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = g_ * ai_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
    if (l_ == 1) {
      goto _l270;
    }
    goto _l170;
    _l160:;
    tau_[0 + (2) * ((l_ - 1))] = -tau_[0 + (2) * ((i_ - 1))];
    si_ = tau_[1 + (2) * ((i_ - 1))];
    ar_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = g_;
    _l170:;
    f_ = 0.0;
    for (j_ = 1; j_ <= l_; (j_)++) {
      g_ = 0.0;
      gi_ = 0.0;
      for (k_ = 1; k_ <= j_; (k_)++) {
        g_ = g_ + ar_[j_ - 1 + ((*nm_)) * ((k_ - 1))] * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + ai_[j_ - 1 + ((*nm_)) * ((k_ - 
        1))] * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
        gi_ = gi_ - ar_[j_ - 1 + ((*nm_)) * ((k_ - 1))] * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + ai_[j_ - 1 + ((*nm_)) * ((k_ - 
        1))] * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      jp1_ = j_ + 1;
      if (l_ < jp1_) {
        goto _l220;
      }
      for (k_ = jp1_; k_ <= l_; (k_)++) {
        g_ = g_ + ar_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - ai_[k_ - 1 + ((*nm_)) * ((j_ - 
        1))] * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
        gi_ = gi_ - ar_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - ai_[k_ - 1 + ((*nm_)) * ((j_ - 
        1))] * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l220:;
      e_[j_ - 1] = g_ / h_;
      tau_[1 + (2) * ((j_ - 1))] = gi_ / h_;
      f_ = f_ + e_[j_ - 1] * ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - tau_[1 + (2) * ((j_ - 1))] * ai_[i_ - 1 + ((*nm_)) * ((j_ 
      - 1))];
    }
    hh_ = f_ / (h_ + h_);
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = ar_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      g_ = e_[j_ - 1] - hh_ * f_;
      e_[j_ - 1] = g_;
      fi_ = -ai_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      gi_ = tau_[1 + (2) * ((j_ - 1))] - hh_ * fi_;
      tau_[1 + (2) * ((j_ - 1))] = -gi_;
      for (k_ = 1; k_ <= j_; (k_)++) {
        ar_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = ar_[j_ - 1 + ((*nm_)) * ((k_ - 1))] - f_ * e_[k_ - 1] - g_ * ar_[i_ - 1 + 
        ((*nm_)) * ((k_ - 1))] + fi_ * tau_[1 + (2) * ((k_ - 1))] + gi_ * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
        ai_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = ai_[j_ - 1 + ((*nm_)) * ((k_ - 1))] - f_ * tau_[1 + (2) * ((k_ - 1))] - g_ * 
        ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))] - fi_ * e_[k_ - 1] - gi_ * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
    }
    _l270:;
    for (k_ = 1; k_ <= l_; (k_)++) {
      ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = scale_ * ar_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = scale_ * ai_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
    }
    tau_[1 + (2) * ((l_ - 1))] = -si_;
    _l290:;
    hh_ = d_[i_ - 1];
    d_[i_ - 1] = ar_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    ar_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = hh_;
    ai_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = scale_ * sqrt (h_);
  }
  __calls[37].calls++;
  return 0;
}

int_4 _imtql1 (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, l_, m_, ii_, mml_;
  static real_8 b_, c_, f_, g_, p_, r_, s_, tst1_, tst2_;
  real_8 $0_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  if ((*n_) == 1) {
    goto _l1001;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    e_[i_ - 1 - 1] = e_[i_ - 1];
  }
  e_[(*n_) - 1] = 0.0;
  for (l_ = 1; l_ <= (*n_); (l_)++) {
    j_ = 0;
    _l105:;
    for (m_ = l_; m_ <= (*n_); (m_)++) {
      if (m_ == (*n_)) {
        goto _l120;
      }
      tst1_ = _abs (d_[m_ - 1]) + _abs (d_[m_ + 1 - 1]);
      tst2_ = tst1_ + _abs (e_[m_ - 1]);
      if (tst2_ == tst1_) {
        goto _l120;
      }
    }
    _l120:;
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l215;
    }
    if (j_ == 30) {
      goto _l1000;
    }
    j_ = j_ + 1;
    g_ = (d_[l_ + 1 - 1] - p_) / (2.0e0 * e_[l_ - 1]);
    r_ = _pythag (&g_, ($0_ = 1.0, &$0_));
    g_ = d_[m_ - 1] - p_ + e_[l_ - 1] / (g_ + _sign (r_, g_));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    mml_ = m_ - l_;
    for (ii_ = 1; ii_ <= mml_; (ii_)++) {
      i_ = m_ - ii_;
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      r_ = _pythag (&f_, &g_);
      e_[i_ + 1 - 1] = r_;
      if (r_ == 0.0e0) {
        goto _l210;
      }
      s_ = f_ / r_;
      c_ = g_ / r_;
      g_ = d_[i_ + 1 - 1] - p_;
      r_ = (d_[i_ - 1] - g_) * s_ + 2.0e0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ + 1 - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[l_ - 1] = g_;
    e_[m_ - 1] = 0.0;
    goto _l105;
    _l210:;
    d_[i_ + 1 - 1] = d_[i_ + 1 - 1] - p_;
    e_[m_ - 1] = 0.0;
    goto _l105;
    _l215:;
    if (l_ == 1) {
      goto _l250;
    }
    for (ii_ = 2; ii_ <= l_; (ii_)++) {
      i_ = l_ + 2 - ii_;
      if (p_ >= d_[i_ - 1 - 1]) {
        goto _l270;
      }
      d_[i_ - 1] = d_[i_ - 1 - 1];
    }
    _l250:;
    i_ = 1;
    _l270:;
    d_[i_ - 1] = p_;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = l_;
  _l1001:;
  __calls[38].calls++;
  return 0;
}

int_4 _imtql2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, l_, m_, ii_, mml_;
  static real_8 b_, c_, f_, g_, p_, r_, s_, tst1_, tst2_;
  real_8 $0_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  if ((*n_) == 1) {
    goto _l1001;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    e_[i_ - 1 - 1] = e_[i_ - 1];
  }
  e_[(*n_) - 1] = 0.0;
  for (l_ = 1; l_ <= (*n_); (l_)++) {
    j_ = 0;
    _l105:;
    for (m_ = l_; m_ <= (*n_); (m_)++) {
      if (m_ == (*n_)) {
        goto _l120;
      }
      tst1_ = _abs (d_[m_ - 1]) + _abs (d_[m_ + 1 - 1]);
      tst2_ = tst1_ + _abs (e_[m_ - 1]);
      if (tst2_ == tst1_) {
        goto _l120;
      }
    }
    _l120:;
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l240;
    }
    if (j_ == 30) {
      goto _l1000;
    }
    j_ = j_ + 1;
    g_ = (d_[l_ + 1 - 1] - p_) / (2.0e0 * e_[l_ - 1]);
    r_ = _pythag (&g_, ($0_ = 1.0, &$0_));
    g_ = d_[m_ - 1] - p_ + e_[l_ - 1] / (g_ + _sign (r_, g_));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    mml_ = m_ - l_;
    for (ii_ = 1; ii_ <= mml_; (ii_)++) {
      i_ = m_ - ii_;
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      r_ = _pythag (&f_, &g_);
      e_[i_ + 1 - 1] = r_;
      if (r_ == 0.0e0) {
        goto _l210;
      }
      s_ = f_ / r_;
      c_ = g_ / r_;
      g_ = d_[i_ + 1 - 1] - p_;
      r_ = (d_[i_ - 1] - g_) * s_ + 2.0e0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ + 1 - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      for (k_ = 1; k_ <= (*n_); (k_)++) {
        f_ = z_[k_ - 1 + ((*nm_)) * ((i_ + 1 - 1))];
        z_[k_ - 1 + ((*nm_)) * ((i_ + 1 - 1))] = s_ * z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] + c_ * f_;
        z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = c_ * z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] - s_ * f_;
      }
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[l_ - 1] = g_;
    e_[m_ - 1] = 0.0;
    goto _l105;
    _l210:;
    d_[i_ + 1 - 1] = d_[i_ + 1 - 1] - p_;
    e_[m_ - 1] = 0.0;
    goto _l105;
    _l240:;
  }
  for (ii_ = 2; ii_ <= (*n_); (ii_)++) {
    i_ = ii_ - 1;
    k_ = i_;
    p_ = d_[i_ - 1];
    for (j_ = ii_; j_ <= (*n_); (j_)++) {
      if (d_[j_ - 1] >= p_) {
        goto _l260;
      }
      k_ = j_;
      p_ = d_[j_ - 1];
      _l260:;
    }
    if (k_ == i_) {
      goto _l300;
    }
    d_[k_ - 1] = d_[i_ - 1];
    d_[i_ - 1] = p_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      p_ = z_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      z_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = z_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
      z_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = p_;
    }
    _l300:;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = l_;
  _l1001:;
  __calls[39].calls++;
  return 0;
}

int_4 _imtqlv (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, real_8 _p_ w_, int_4 _p_ ind_, int_4 _p_ 
ierr_, real_8 _p_ rv1_)
{
  static int_4 i_, j_, k_, l_, m_, ii_, mml_, tag_;
  static real_8 b_, c_, f_, g_, p_, r_, s_, tst1_, tst2_;
  real_8 $0_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  k_ = 0;
  tag_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = d_[i_ - 1];
    if (i_ != 1) {
      rv1_[i_ - 1 - 1] = e_[i_ - 1];
    }
  }
  e2_[0] = 0.0;
  rv1_[(*n_) - 1] = 0.0;
  for (l_ = 1; l_ <= (*n_); (l_)++) {
    j_ = 0;
    _l105:;
    for (m_ = l_; m_ <= (*n_); (m_)++) {
      if (m_ == (*n_)) {
        goto _l120;
      }
      tst1_ = _abs (w_[m_ - 1]) + _abs (w_[m_ + 1 - 1]);
      tst2_ = tst1_ + _abs (rv1_[m_ - 1]);
      if (tst2_ == tst1_) {
        goto _l120;
      }
      if (e2_[m_ + 1 - 1] == 0.0e0) {
        goto _l125;
      }
    }
    _l120:;
    if (m_ <= k_) {
      goto _l130;
    }
    if (m_ != (*n_)) {
      e2_[m_ + 1 - 1] = 0.0;
    }
    _l125:;
    k_ = m_;
    tag_ = tag_ + 1;
    _l130:;
    p_ = w_[l_ - 1];
    if (m_ == l_) {
      goto _l215;
    }
    if (j_ == 30) {
      goto _l1000;
    }
    j_ = j_ + 1;
    g_ = (w_[l_ + 1 - 1] - p_) / (2.0e0 * rv1_[l_ - 1]);
    r_ = _pythag (&g_, ($0_ = 1.0, &$0_));
    g_ = w_[m_ - 1] - p_ + rv1_[l_ - 1] / (g_ + _sign (r_, g_));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    mml_ = m_ - l_;
    for (ii_ = 1; ii_ <= mml_; (ii_)++) {
      i_ = m_ - ii_;
      f_ = s_ * rv1_[i_ - 1];
      b_ = c_ * rv1_[i_ - 1];
      r_ = _pythag (&f_, &g_);
      rv1_[i_ + 1 - 1] = r_;
      if (r_ == 0.0e0) {
        goto _l210;
      }
      s_ = f_ / r_;
      c_ = g_ / r_;
      g_ = w_[i_ + 1 - 1] - p_;
      r_ = (w_[i_ - 1] - g_) * s_ + 2.0e0 * c_ * b_;
      p_ = s_ * r_;
      w_[i_ + 1 - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
    }
    w_[l_ - 1] = w_[l_ - 1] - p_;
    rv1_[l_ - 1] = g_;
    rv1_[m_ - 1] = 0.0;
    goto _l105;
    _l210:;
    w_[i_ + 1 - 1] = w_[i_ + 1 - 1] - p_;
    rv1_[m_ - 1] = 0.0;
    goto _l105;
    _l215:;
    if (l_ == 1) {
      goto _l250;
    }
    for (ii_ = 2; ii_ <= l_; (ii_)++) {
      i_ = l_ + 2 - ii_;
      if (p_ >= w_[i_ - 1 - 1]) {
        goto _l270;
      }
      w_[i_ - 1] = w_[i_ - 1 - 1];
      ind_[i_ - 1] = ind_[i_ - 1 - 1];
    }
    _l250:;
    i_ = 1;
    _l270:;
    w_[i_ - 1] = p_;
    ind_[i_ - 1] = tag_;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = l_;
  _l1001:;
  __calls[40].calls++;
  return 0;
}

int_4 _invit (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ wr_, real_8 _p_ wi_, logical_4 _p_ select_, int_4 
_p_ mm_, int_4 _p_ m_, real_8 _p_ z_, int_4 _p_ ierr_, real_8 _p_ rm1_, real_8 _p_ rv1_, real_8 _p_ rv2_)
{
  static int_4 i_, j_, k_, l_, s_, ii_, ip_, mp_, ns_, n1_, uk_, ip1_, its_, km1_;
  static real_8 t_, w_, x_, y_, eps3_, norm_, normv_, growto_, ilambd_, rlambd_, ukroot_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  uk_ = 0;
  s_ = 1;
  ip_ = 0;
  n1_ = (*n_) - 1;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (wi_[k_ - 1] == 0.0e0 || ip_ < 0) {
      goto _l100;
    }
    ip_ = 1;
    if (select_[k_ - 1] && select_[k_ + 1 - 1]) {
      select_[k_ + 1 - 1] = FALSE;
    }
    _l100:;
    if (! (select_[k_ - 1])) {
      goto _l960;
    }
    if (wi_[k_ - 1] != 0.0e0) {
      s_ = s_ + 1;
    }
    if (s_ > (*mm_)) {
      goto _l1000;
    }
    if (uk_ >= k_) {
      goto _l200;
    }
    for (uk_ = k_; uk_ <= (*n_); (uk_)++) {
      if (uk_ == (*n_)) {
        goto _l140;
      }
      if (a_[uk_ + 1 - 1 + ((*nm_)) * ((uk_ - 1))] == 0.0e0) {
        goto _l140;
      }
    }
    _l140:;
    norm_ = 0.0;
    mp_ = 1;
    for (i_ = 1; i_ <= uk_; (i_)++) {
      x_ = 0.0;
      for (j_ = mp_; j_ <= uk_; (j_)++) {
        x_ = x_ + _abs (a_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      }
      if (x_ > norm_) {
        norm_ = x_;
      }
      mp_ = i_;
    }
    if (norm_ == 0.0e0) {
      norm_ = 1.0;
    }
    eps3_ = _epslon (&norm_);
    ukroot_ = uk_;
    ukroot_ = sqrt (ukroot_);
    growto_ = 0.1e0 / ukroot_;
    _l200:;
    rlambd_ = wr_[k_ - 1];
    ilambd_ = wi_[k_ - 1];
    if (k_ == 1) {
      goto _l280;
    }
    km1_ = k_ - 1;
    goto _l240;
    _l220:;
    rlambd_ = rlambd_ + eps3_;
    _l240:;
    for (ii_ = 1; ii_ <= km1_; (ii_)++) {
      i_ = k_ - ii_;
      if (select_[i_ - 1] && _abs (wr_[i_ - 1] - rlambd_) < eps3_ && _abs (wi_[i_ - 1] - ilambd_) < eps3_) {
        goto _l220;
      }
    }
    wr_[k_ - 1] = rlambd_;
    ip1_ = k_ + ip_;
    wr_[ip1_ - 1] = rlambd_;
    _l280:;
    mp_ = 1;
    for (i_ = 1; i_ <= uk_; (i_)++) {
      for (j_ = mp_; j_ <= uk_; (j_)++) {
        rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))] = rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))] - rlambd_;
      mp_ = i_;
      rv1_[i_ - 1] = eps3_;
    }
    its_ = 0;
    if (ilambd_ != 0.0e0) {
      goto _l520;
    }
    if (uk_ == 1) {
      goto _l420;
    }
    for (i_ = 2; i_ <= uk_; (i_)++) {
      mp_ = i_ - 1;
      if (_abs (rm1_[mp_ - 1 + ((*n_)) * ((i_ - 1))]) <= _abs (rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))])) {
        goto _l360;
      }
      for (j_ = mp_; j_ <= uk_; (j_)++) {
        y_ = rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))];
        rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] = rm1_[j_ - 1 + ((*n_)) * ((mp_ - 1))];
        rm1_[j_ - 1 + ((*n_)) * ((mp_ - 1))] = y_;
      }
      _l360:;
      if (rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] == 0.0e0) {
        rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] = eps3_;
      }
      x_ = rm1_[mp_ - 1 + ((*n_)) * ((i_ - 1))] / rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))];
      if (x_ == 0.0e0) {
        goto _l400;
      }
      for (j_ = i_; j_ <= uk_; (j_)++) {
        rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] = rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] - x_ * rm1_[j_ - 1 + ((*n_)) * ((mp_ - 1))];
      }
      _l400:;
    }
    _l420:;
    if (rm1_[uk_ - 1 + ((*n_)) * ((uk_ - 1))] == 0.0e0) {
      rm1_[uk_ - 1 + ((*n_)) * ((uk_ - 1))] = eps3_;
    }
    _l440:;
    for (ii_ = 1; ii_ <= uk_; (ii_)++) {
      i_ = uk_ + 1 - ii_;
      y_ = rv1_[i_ - 1];
      if (i_ == uk_) {
        goto _l480;
      }
      ip1_ = i_ + 1;
      for (j_ = ip1_; j_ <= uk_; (j_)++) {
        y_ = y_ - rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] * rv1_[j_ - 1];
      }
      _l480:;
      rv1_[i_ - 1] = y_ / rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))];
    }
    goto _l740;
    _l520:;
    ns_ = (*n_) - s_;
    z_[0 + ((*nm_)) * ((s_ - 1 - 1))] = -ilambd_;
    z_[0 + ((*nm_)) * ((s_ - 1))] = 0.0;
    if ((*n_) == 2) {
      goto _l550;
    }
    rm1_[0 + ((*n_)) * ((2))] = -ilambd_;
    z_[0 + ((*nm_)) * ((s_ - 1 - 1))] = 0.0;
    if ((*n_) == 3) {
      goto _l550;
    }
    for (i_ = 4; i_ <= (*n_); (i_)++) {
      rm1_[0 + ((*n_)) * ((i_ - 1))] = 0.0;
    }
    _l550:;
    for (i_ = 2; i_ <= uk_; (i_)++) {
      mp_ = i_ - 1;
      w_ = rm1_[mp_ - 1 + ((*n_)) * ((i_ - 1))];
      if (i_ < (*n_)) {
        t_ = rm1_[mp_ - 1 + ((*n_)) * ((i_ + 1 - 1))];
      }
      if (i_ == (*n_)) {
        t_ = z_[mp_ - 1 + ((*nm_)) * ((s_ - 1 - 1))];
      }
      x_ = rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] * rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] + t_ * t_;
      if (w_ * w_ <= x_) {
        goto _l580;
      }
      x_ = rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] / w_;
      y_ = t_ / w_;
      rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] = w_;
      if (i_ < (*n_)) {
        rm1_[mp_ - 1 + ((*n_)) * ((i_ + 1 - 1))] = 0.0;
      }
      if (i_ == (*n_)) {
        z_[mp_ - 1 + ((*nm_)) * ((s_ - 1 - 1))] = 0.0;
      }
      for (j_ = i_; j_ <= uk_; (j_)++) {
        w_ = rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))];
        rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] = rm1_[j_ - 1 + ((*n_)) * ((mp_ - 1))] - x_ * w_;
        rm1_[j_ - 1 + ((*n_)) * ((mp_ - 1))] = w_;
        if (j_ < n1_) {
          goto _l555;
        }
        l_ = j_ - ns_;
        z_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = z_[mp_ - 1 + ((*nm_)) * ((l_ - 1))] - y_ * w_;
        z_[mp_ - 1 + ((*nm_)) * ((l_ - 1))] = 0.0;
        goto _l560;
        _l555:;
        rm1_[i_ - 1 + ((*n_)) * ((j_ + 2 - 1))] = rm1_[mp_ - 1 + ((*n_)) * ((j_ + 2 - 1))] - y_ * w_;
        rm1_[mp_ - 1 + ((*n_)) * ((j_ + 2 - 1))] = 0.0;
        _l560:;
      }
      rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))] = rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))] - y_ * ilambd_;
      if (i_ < n1_) {
        goto _l570;
      }
      l_ = i_ - ns_;
      z_[mp_ - 1 + ((*nm_)) * ((l_ - 1))] = -ilambd_;
      z_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((l_ - 1))] + x_ * ilambd_;
      goto _l640;
      _l570:;
      rm1_[mp_ - 1 + ((*n_)) * ((i_ + 2 - 1))] = -ilambd_;
      rm1_[i_ - 1 + ((*n_)) * ((i_ + 2 - 1))] = rm1_[i_ - 1 + ((*n_)) * ((i_ + 2 - 1))] + x_ * ilambd_;
      goto _l640;
      _l580:;
      if (x_ != 0.0e0) {
        goto _l600;
      }
      rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] = eps3_;
      if (i_ < (*n_)) {
        rm1_[mp_ - 1 + ((*n_)) * ((i_ + 1 - 1))] = 0.0;
      }
      if (i_ == (*n_)) {
        z_[mp_ - 1 + ((*nm_)) * ((s_ - 1 - 1))] = 0.0;
      }
      t_ = 0.0;
      x_ = eps3_ * eps3_;
      _l600:;
      w_ = w_ / x_;
      x_ = rm1_[mp_ - 1 + ((*n_)) * ((mp_ - 1))] * w_;
      y_ = -t_ * w_;
      for (j_ = i_; j_ <= uk_; (j_)++) {
        if (j_ < n1_) {
          goto _l610;
        }
        l_ = j_ - ns_;
        t_ = z_[mp_ - 1 + ((*nm_)) * ((l_ - 1))];
        z_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = -x_ * t_ - y_ * rm1_[j_ - 1 + ((*n_)) * ((mp_ - 1))];
        goto _l615;
        _l610:;
        t_ = rm1_[mp_ - 1 + ((*n_)) * ((j_ + 2 - 1))];
        rm1_[i_ - 1 + ((*n_)) * ((j_ + 2 - 1))] = -x_ * t_ - y_ * rm1_[j_ - 1 + ((*n_)) * ((mp_ - 1))];
        _l615:;
        rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] = rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] - x_ * rm1_[j_ - 1 + ((*n_)) * ((mp_ - 1))] + 
        y_ * t_;
      }
      if (i_ < n1_) {
        goto _l630;
      }
      l_ = i_ - ns_;
      z_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((l_ - 1))] - ilambd_;
      goto _l640;
      _l630:;
      rm1_[i_ - 1 + ((*n_)) * ((i_ + 2 - 1))] = rm1_[i_ - 1 + ((*n_)) * ((i_ + 2 - 1))] - ilambd_;
      _l640:;
    }
    if (uk_ < n1_) {
      goto _l650;
    }
    l_ = uk_ - ns_;
    t_ = z_[uk_ - 1 + ((*nm_)) * ((l_ - 1))];
    goto _l655;
    _l650:;
    t_ = rm1_[uk_ - 1 + ((*n_)) * ((uk_ + 2 - 1))];
    _l655:;
    if (rm1_[uk_ - 1 + ((*n_)) * ((uk_ - 1))] == 0.0e0 && t_ == 0.0e0) {
      rm1_[uk_ - 1 + ((*n_)) * ((uk_ - 1))] = eps3_;
    }
    _l660:;
    for (ii_ = 1; ii_ <= uk_; (ii_)++) {
      i_ = uk_ + 1 - ii_;
      x_ = rv1_[i_ - 1];
      y_ = 0.0;
      if (i_ == uk_) {
        goto _l700;
      }
      ip1_ = i_ + 1;
      for (j_ = ip1_; j_ <= uk_; (j_)++) {
        if (j_ < n1_) {
          goto _l670;
        }
        l_ = j_ - ns_;
        t_ = z_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
        goto _l675;
        _l670:;
        t_ = rm1_[i_ - 1 + ((*n_)) * ((j_ + 2 - 1))];
        _l675:;
        x_ = x_ - rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] * rv1_[j_ - 1] + t_ * rv2_[j_ - 1];
        y_ = y_ - rm1_[j_ - 1 + ((*n_)) * ((i_ - 1))] * rv2_[j_ - 1] - t_ * rv1_[j_ - 1];
      }
      _l700:;
      if (i_ < n1_) {
        goto _l710;
      }
      l_ = i_ - ns_;
      t_ = z_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
      goto _l715;
      _l710:;
      t_ = rm1_[i_ - 1 + ((*n_)) * ((i_ + 2 - 1))];
      _l715:;
      (void) _cdiv (&x_, &y_, &rm1_[i_ - 1 + ((*n_)) * ((i_ - 1))], &t_, &rv1_[i_ - 1], &rv2_[i_ - 1]);
    }
    _l740:;
    its_ = its_ + 1;
    norm_ = 0.0;
    normv_ = 0.0;
    for (i_ = 1; i_ <= uk_; (i_)++) {
      if (ilambd_ == 0.0e0) {
        x_ = _abs (rv1_[i_ - 1]);
      }
      if (ilambd_ != 0.0e0) {
        x_ = _pythag (&rv1_[i_ - 1], &rv2_[i_ - 1]);
      }
      if (normv_ >= x_) {
        goto _l760;
      }
      normv_ = x_;
      j_ = i_;
      _l760:;
      norm_ = norm_ + x_;
    }
    if (norm_ < growto_) {
      goto _l840;
    }
    x_ = rv1_[j_ - 1];
    if (ilambd_ == 0.0e0) {
      x_ = 1.0e0 / x_;
    }
    if (ilambd_ != 0.0e0) {
      y_ = rv2_[j_ - 1];
    }
    for (i_ = 1; i_ <= uk_; (i_)++) {
      if (ilambd_ != 0.0e0) {
        goto _l800;
      }
      z_[i_ - 1 + ((*nm_)) * ((s_ - 1))] = rv1_[i_ - 1] * x_;
      goto _l820;
      _l800:;
      (void) _cdiv (&rv1_[i_ - 1], &rv2_[i_ - 1], &x_, &y_, &z_[i_ - 1 + ((*nm_)) * ((s_ - 1 - 1))], &z_[i_ - 1 + ((*nm_)) * 
      ((s_ - 1))]);
      _l820:;
    }
    if (uk_ == (*n_)) {
      goto _l940;
    }
    j_ = uk_ + 1;
    goto _l900;
    _l840:;
    if (its_ >= uk_) {
      goto _l880;
    }
    x_ = ukroot_;
    y_ = eps3_ / (x_ + 1.0e0);
    rv1_[0] = eps3_;
    for (i_ = 2; i_ <= uk_; (i_)++) {
      rv1_[i_ - 1] = y_;
    }
    j_ = uk_ - its_ + 1;
    rv1_[j_ - 1] = rv1_[j_ - 1] - eps3_ * x_;
    if (ilambd_ == 0.0e0) {
      goto _l440;
    }
    goto _l660;
    _l880:;
    j_ = 1;
    (*ierr_) = -k_;
    _l900:;
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((s_ - 1))] = 0.0;
      if (ilambd_ != 0.0e0) {
        z_[i_ - 1 + ((*nm_)) * ((s_ - 1 - 1))] = 0.0;
      }
    }
    _l940:;
    s_ = s_ + 1;
    _l960:;
    if (ip_ == -1) {
      ip_ = 0;
    }
    if (ip_ == 1) {
      ip_ = -1;
    }
  }
  goto _l1001;
  _l1000:;
  if ((*ierr_) != 0) {
    (*ierr_) = (*ierr_) - (*n_);
  }
  if ((*ierr_) == 0) {
    (*ierr_) = -(2 * (*n_) + 1);
  }
  _l1001:;
  (*m_) = s_ - 1 - (int_4) (_abs (ip_));
  __calls[41].calls++;
  return 0;
}

int_4 _minfit (int_4 _p_ nm_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ ip_, real_8 _p_ b_, 
int_4 _p_ ierr_, real_8 _p_ rv1_)
{
  static int_4 i_, j_, k_, l_, ii_, i1_, kk_, k1_, ll_, l1_, m1_, its_;
  static real_8 c_, f_, g_, h_, s_, x_, y_, z_, tst1_, tst2_, scale_;
  real_8 $0_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  g_ = 0.0;
  scale_ = 0.0;
  x_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    l_ = i_ + 1;
    rv1_[i_ - 1] = scale_ * g_;
    g_ = 0.0;
    s_ = 0.0;
    scale_ = 0.0;
    if (i_ > (*m_)) {
      goto _l210;
    }
    for (k_ = i_; k_ <= (*m_); (k_)++) {
      scale_ = scale_ + _abs (a_[k_ - 1 + ((*nm_)) * ((i_ - 1))]);
    }
    if (scale_ == 0.0e0) {
      goto _l210;
    }
    for (k_ = i_; k_ <= (*m_); (k_)++) {
      a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] / scale_;
      s_ = s_ + (a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))]);
    }
    f_ = a_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    g_ = -_sign (sqrt (s_), f_);
    h_ = f_ * g_ - s_;
    a_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = f_ - g_;
    if (i_ == (*n_)) {
      goto _l160;
    }
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      s_ = 0.0;
      for (k_ = i_; k_ <= (*m_); (k_)++) {
        s_ = s_ + a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * a_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      f_ = s_ / h_;
      for (k_ = i_; k_ <= (*m_); (k_)++) {
        a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + f_ * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
    }
    _l160:;
    if ((*ip_) == 0) {
      goto _l190;
    }
    for (j_ = 1; j_ <= (*ip_); (j_)++) {
      s_ = 0.0;
      for (k_ = i_; k_ <= (*m_); (k_)++) {
        s_ = s_ + a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * b_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      f_ = s_ / h_;
      for (k_ = i_; k_ <= (*m_); (k_)++) {
        b_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + f_ * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
    }
    _l190:;
    for (k_ = i_; k_ <= (*m_); (k_)++) {
      a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = scale_ * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
    }
    _l210:;
    w_[i_ - 1] = scale_ * g_;
    g_ = 0.0;
    s_ = 0.0;
    scale_ = 0.0;
    if (i_ > (*m_) || i_ == (*n_)) {
      goto _l290;
    }
    for (k_ = l_; k_ <= (*n_); (k_)++) {
      scale_ = scale_ + _abs (a_[i_ - 1 + ((*nm_)) * ((k_ - 1))]);
    }
    if (scale_ == 0.0e0) {
      goto _l290;
    }
    for (k_ = l_; k_ <= (*n_); (k_)++) {
      a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] / scale_;
      s_ = s_ + (a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))]);
    }
    f_ = a_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
    g_ = -_sign (sqrt (s_), f_);
    h_ = f_ * g_ - s_;
    a_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = f_ - g_;
    for (k_ = l_; k_ <= (*n_); (k_)++) {
      rv1_[k_ - 1] = a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] / h_;
    }
    if (i_ == (*m_)) {
      goto _l270;
    }
    for (j_ = l_; j_ <= (*m_); (j_)++) {
      s_ = 0.0;
      for (k_ = l_; k_ <= (*n_); (k_)++) {
        s_ = s_ + a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      for (k_ = l_; k_ <= (*n_); (k_)++) {
        a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] + s_ * rv1_[k_ - 1];
      }
    }
    _l270:;
    for (k_ = l_; k_ <= (*n_); (k_)++) {
      a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = scale_ * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
    }
    _l290:;
    x_ = _max (x_, _abs (w_[i_ - 1]) + _abs (rv1_[i_ - 1]));
  }
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 1 - ii_;
    if (i_ == (*n_)) {
      goto _l390;
    }
    if (g_ == 0.0e0) {
      goto _l360;
    }
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = (a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] / a_[i_ - 1 + ((*nm_)) * ((l_ - 1))]) / g_;
    }
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      s_ = 0.0;
      for (k_ = l_; k_ <= (*n_); (k_)++) {
        s_ = s_ + a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * a_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      for (k_ = l_; k_ <= (*n_); (k_)++) {
        a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + s_ * a_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
    }
    _l360:;
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
      a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
    _l390:;
    a_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = 1.0;
    g_ = rv1_[i_ - 1];
    l_ = i_;
  }
  if ((*m_) >= (*n_) || (*ip_) == 0) {
    goto _l510;
  }
  m1_ = (*m_) + 1;
  for (i_ = m1_; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*ip_); (j_)++) {
      b_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
  }
  _l510:;
  tst1_ = x_;
  for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
    k1_ = (*n_) - kk_;
    k_ = k1_ + 1;
    its_ = 0;
    _l520:;
    for (ll_ = 1; ll_ <= k_; (ll_)++) {
      l1_ = k_ - ll_;
      l_ = l1_ + 1;
      tst2_ = tst1_ + _abs (rv1_[l_ - 1]);
      if (tst2_ == tst1_) {
        goto _l565;
      }
      tst2_ = tst1_ + _abs (w_[l1_ - 1]);
      if (tst2_ == tst1_) {
        goto _l540;
      }
    }
    _l540:;
    c_ = 0.0;
    s_ = 1.0;
    for (i_ = l_; i_ <= k_; (i_)++) {
      f_ = s_ * rv1_[i_ - 1];
      rv1_[i_ - 1] = c_ * rv1_[i_ - 1];
      tst2_ = tst1_ + _abs (f_);
      if (tst2_ == tst1_) {
        goto _l565;
      }
      g_ = w_[i_ - 1];
      h_ = _pythag (&f_, &g_);
      w_[i_ - 1] = h_;
      c_ = g_ / h_;
      s_ = -f_ / h_;
      if ((*ip_) == 0) {
        goto _l560;
      }
      for (j_ = 1; j_ <= (*ip_); (j_)++) {
        y_ = b_[l1_ - 1 + ((*nm_)) * ((j_ - 1))];
        z_ = b_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        b_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] = y_ * c_ + z_ * s_;
        b_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = -y_ * s_ + z_ * c_;
      }
      _l560:;
    }
    _l565:;
    z_ = w_[k_ - 1];
    if (l_ == k_) {
      goto _l650;
    }
    if (its_ == 30) {
      goto _l1000;
    }
    its_ = its_ + 1;
    x_ = w_[l_ - 1];
    y_ = w_[k1_ - 1];
    g_ = rv1_[k1_ - 1];
    h_ = rv1_[k_ - 1];
    f_ = 0.5e0 * (((g_ + z_) / h_) * ((g_ - z_) / y_) + y_ / h_ - h_ / y_);
    g_ = _pythag (&f_, ($0_ = 1.0, &$0_));
    f_ = x_ - (z_ / x_) * z_ + (h_ / x_) * (y_ / (f_ + _sign (g_, f_)) - h_);
    c_ = 1.0;
    s_ = 1.0;
    for (i1_ = l_; i1_ <= k1_; (i1_)++) {
      i_ = i1_ + 1;
      g_ = rv1_[i_ - 1];
      y_ = w_[i_ - 1];
      h_ = s_ * g_;
      g_ = c_ * g_;
      z_ = _pythag (&f_, &h_);
      rv1_[i1_ - 1] = z_;
      c_ = f_ / z_;
      s_ = h_ / z_;
      f_ = x_ * c_ + g_ * s_;
      g_ = -x_ * s_ + g_ * c_;
      h_ = y_ * s_;
      y_ = y_ * c_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        x_ = a_[j_ - 1 + ((*nm_)) * ((i1_ - 1))];
        z_ = a_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
        a_[j_ - 1 + ((*nm_)) * ((i1_ - 1))] = x_ * c_ + z_ * s_;
        a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = -x_ * s_ + z_ * c_;
      }
      z_ = _pythag (&f_, &h_);
      w_[i1_ - 1] = z_;
      if (z_ == 0.0e0) {
        goto _l580;
      }
      c_ = f_ / z_;
      s_ = h_ / z_;
      _l580:;
      f_ = c_ * g_ + s_ * y_;
      x_ = -s_ * g_ + c_ * y_;
      if ((*ip_) == 0) {
        goto _l600;
      }
      for (j_ = 1; j_ <= (*ip_); (j_)++) {
        y_ = b_[i1_ - 1 + ((*nm_)) * ((j_ - 1))];
        z_ = b_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        b_[i1_ - 1 + ((*nm_)) * ((j_ - 1))] = y_ * c_ + z_ * s_;
        b_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = -y_ * s_ + z_ * c_;
      }
      _l600:;
    }
    rv1_[l_ - 1] = 0.0;
    rv1_[k_ - 1] = f_;
    w_[k_ - 1] = x_;
    goto _l520;
    _l650:;
    if (z_ >= 0.0e0) {
      goto _l700;
    }
    w_[k_ - 1] = -z_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = -a_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
    }
    _l700:;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = k_;
  _l1001:;
  __calls[42].calls++;
  return 0;
}

int_4 _ortbak (int_4 _p_ nm_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, real_8 _p_ ort_, int_4 _p_ m_, real_8 _p_ 
z_)
{
  static int_4 i_, j_, la_, mm_, mp_, kp1_, mp1_;
  static real_8 g_;
  if ((*m_) == 0) {
    goto _l200;
  }
  la_ = (*igh_) - 1;
  kp1_ = (*low_) + 1;
  if (la_ < kp1_) {
    goto _l200;
  }
  for (mm_ = kp1_; mm_ <= la_; (mm_)++) {
    mp_ = (*low_) + (*igh_) - mm_;
    if (a_[mp_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))] == 0.0e0) {
      goto _l140;
    }
    mp1_ = mp_ + 1;
    for (i_ = mp1_; i_ <= (*igh_); (i_)++) {
      ort_[i_ - 1] = a_[i_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      g_ = 0.0;
      for (i_ = mp_; i_ <= (*igh_); (i_)++) {
        g_ = g_ + ort_[i_ - 1] * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      g_ = (g_ / ort_[mp_ - 1]) / a_[mp_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
      for (i_ = mp_; i_ <= (*igh_); (i_)++) {
        z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + g_ * ort_[i_ - 1];
      }
    }
    _l140:;
  }
  _l200:;
  __calls[43].calls++;
  return 0;
}

int_4 _orthes (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, real_8 _p_ ort_)
{
  static int_4 i_, j_, m_, ii_, jj_, la_, mp_, kp1_;
  static real_8 f_, g_, h_, scale_;
  la_ = (*igh_) - 1;
  kp1_ = (*low_) + 1;
  if (la_ < kp1_) {
    goto _l200;
  }
  for (m_ = kp1_; m_ <= la_; (m_)++) {
    h_ = 0.0;
    ort_[m_ - 1] = 0.0;
    scale_ = 0.0;
    for (i_ = m_; i_ <= (*igh_); (i_)++) {
      scale_ = scale_ + _abs (a_[i_ - 1 + ((*nm_)) * ((m_ - 1 - 1))]);
    }
    if (scale_ == 0.0e0) {
      goto _l180;
    }
    mp_ = m_ + (*igh_);
    for (ii_ = m_; ii_ <= (*igh_); (ii_)++) {
      i_ = mp_ - ii_;
      ort_[i_ - 1] = a_[i_ - 1 + ((*nm_)) * ((m_ - 1 - 1))] / scale_;
      h_ = h_ + ort_[i_ - 1] * ort_[i_ - 1];
    }
    g_ = -_sign (sqrt (h_), ort_[m_ - 1]);
    h_ = h_ - ort_[m_ - 1] * g_;
    ort_[m_ - 1] = ort_[m_ - 1] - g_;
    for (j_ = m_; j_ <= (*n_); (j_)++) {
      f_ = 0.0;
      for (ii_ = m_; ii_ <= (*igh_); (ii_)++) {
        i_ = mp_ - ii_;
        f_ = f_ + ort_[i_ - 1] * a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      f_ = f_ / h_;
      for (i_ = m_; i_ <= (*igh_); (i_)++) {
        a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - f_ * ort_[i_ - 1];
      }
    }
    for (i_ = 1; i_ <= (*igh_); (i_)++) {
      f_ = 0.0;
      for (jj_ = m_; jj_ <= (*igh_); (jj_)++) {
        j_ = mp_ - jj_;
        f_ = f_ + ort_[j_ - 1] * a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      f_ = f_ / h_;
      for (j_ = m_; j_ <= (*igh_); (j_)++) {
        a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - f_ * ort_[j_ - 1];
      }
    }
    ort_[m_ - 1] = scale_ * ort_[m_ - 1];
    a_[m_ - 1 + ((*nm_)) * ((m_ - 1 - 1))] = scale_ * g_;
    _l180:;
  }
  _l200:;
  __calls[44].calls++;
  return 0;
}

int_4 _ortran (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ low_, int_4 _p_ igh_, real_8 _p_ a_, real_8 _p_ ort_, real_8 _p_ 
z_)
{
  static int_4 i_, j_, kl_, mm_, mp_, mp1_;
  static real_8 g_;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    z_[j_ - 1 + ((*nm_)) * ((j_ - 1))] = 1.0;
  }
  kl_ = (*igh_) - (*low_) - 1;
  if (kl_ < 1) {
    goto _l200;
  }
  for (mm_ = 1; mm_ <= kl_; (mm_)++) {
    mp_ = (*igh_) - mm_;
    if (a_[mp_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))] == 0.0e0) {
      goto _l140;
    }
    mp1_ = mp_ + 1;
    for (i_ = mp1_; i_ <= (*igh_); (i_)++) {
      ort_[i_ - 1] = a_[i_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
    }
    for (j_ = mp_; j_ <= (*igh_); (j_)++) {
      g_ = 0.0;
      for (i_ = mp_; i_ <= (*igh_); (i_)++) {
        g_ = g_ + ort_[i_ - 1] * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      g_ = (g_ / ort_[mp_ - 1]) / a_[mp_ - 1 + ((*nm_)) * ((mp_ - 1 - 1))];
      for (i_ = mp_; i_ <= (*igh_); (i_)++) {
        z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + g_ * ort_[i_ - 1];
      }
    }
    _l140:;
  }
  _l200:;
  __calls[45].calls++;
  return 0;
}

int_4 _qzhes (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, logical_4 _p_ matz_, real_8 _p_ z_)
{
  static int_4 i_, j_, k_, l_, lb_, l1_, nk1_, nm1_, nm2_;
  static real_8 r_, s_, t_, u1_, u2_, v1_, v2_, rho_;
  if (! ((*matz_))) {
    goto _l10;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    z_[j_ - 1 + ((*nm_)) * ((j_ - 1))] = 1.0;
  }
  _l10:;
  if ((*n_) <= 1) {
    goto _l170;
  }
  nm1_ = (*n_) - 1;
  for (l_ = 1; l_ <= nm1_; (l_)++) {
    l1_ = l_ + 1;
    s_ = 0.0;
    for (i_ = l1_; i_ <= (*n_); (i_)++) {
      s_ = s_ + _abs (b_[i_ - 1 + ((*nm_)) * ((l_ - 1))]);
    }
    if (s_ == 0.0e0) {
      goto _l100;
    }
    s_ = s_ + _abs (b_[l_ - 1 + ((*nm_)) * ((l_ - 1))]);
    r_ = 0.0;
    for (i_ = l_; i_ <= (*n_); (i_)++) {
      b_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((l_ - 1))] / s_;
      r_ = r_ + (b_[i_ - 1 + ((*nm_)) * ((l_ - 1))] * b_[i_ - 1 + ((*nm_)) * ((l_ - 1))]);
    }
    r_ = _sign (sqrt (r_), b_[l_ - 1 + ((*nm_)) * ((l_ - 1))]);
    b_[l_ - 1 + ((*nm_)) * ((l_ - 1))] = b_[l_ - 1 + ((*nm_)) * ((l_ - 1))] + r_;
    rho_ = r_ * b_[l_ - 1 + ((*nm_)) * ((l_ - 1))];
    for (j_ = l1_; j_ <= (*n_); (j_)++) {
      t_ = 0.0;
      for (i_ = l_; i_ <= (*n_); (i_)++) {
        t_ = t_ + b_[i_ - 1 + ((*nm_)) * ((l_ - 1))] * b_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      t_ = -t_ / rho_;
      for (i_ = l_; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * b_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
      }
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      t_ = 0.0;
      for (i_ = l_; i_ <= (*n_); (i_)++) {
        t_ = t_ + b_[i_ - 1 + ((*nm_)) * ((l_ - 1))] * a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      t_ = -t_ / rho_;
      for (i_ = l_; i_ <= (*n_); (i_)++) {
        a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * b_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
      }
    }
    b_[l_ - 1 + ((*nm_)) * ((l_ - 1))] = -s_ * r_;
    for (i_ = l1_; i_ <= (*n_); (i_)++) {
      b_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = 0.0;
    }
    _l100:;
  }
  if ((*n_) == 2) {
    goto _l170;
  }
  nm2_ = (*n_) - 2;
  for (k_ = 1; k_ <= nm2_; (k_)++) {
    nk1_ = nm1_ - k_;
    for (lb_ = 1; lb_ <= nk1_; (lb_)++) {
      l_ = (*n_) - lb_;
      l1_ = l_ + 1;
      s_ = _abs (a_[l_ - 1 + ((*nm_)) * ((k_ - 1))]) + _abs (a_[l1_ - 1 + ((*nm_)) * ((k_ - 1))]);
      if (s_ == 0.0e0) {
        goto _l150;
      }
      u1_ = a_[l_ - 1 + ((*nm_)) * ((k_ - 1))] / s_;
      u2_ = a_[l1_ - 1 + ((*nm_)) * ((k_ - 1))] / s_;
      r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_), u1_);
      v1_ = -(u1_ + r_) / r_;
      v2_ = -u2_ / r_;
      u2_ = v2_ / v1_;
      for (j_ = k_; j_ <= (*n_); (j_)++) {
        t_ = a_[l_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * a_[l1_ - 1 + ((*nm_)) * ((j_ - 1))];
        a_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[l_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
        a_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
      }
      a_[l1_ - 1 + ((*nm_)) * ((k_ - 1))] = 0.0;
      for (j_ = l_; j_ <= (*n_); (j_)++) {
        t_ = b_[l_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * b_[l1_ - 1 + ((*nm_)) * ((j_ - 1))];
        b_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[l_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
        b_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
      }
      s_ = _abs (b_[l1_ - 1 + ((*nm_)) * ((l1_ - 1))]) + _abs (b_[l1_ - 1 + ((*nm_)) * ((l_ - 1))]);
      if (s_ == 0.0e0) {
        goto _l150;
      }
      u1_ = b_[l1_ - 1 + ((*nm_)) * ((l1_ - 1))] / s_;
      u2_ = b_[l1_ - 1 + ((*nm_)) * ((l_ - 1))] / s_;
      r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_), u1_);
      v1_ = -(u1_ + r_) / r_;
      v2_ = -u2_ / r_;
      u2_ = v2_ / v1_;
      for (i_ = 1; i_ <= l1_; (i_)++) {
        t_ = b_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] + u2_ * b_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
        b_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] + t_ * v1_;
        b_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((l_ - 1))] + t_ * v2_;
      }
      b_[l1_ - 1 + ((*nm_)) * ((l_ - 1))] = 0.0;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        t_ = a_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] + u2_ * a_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
        a_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] + t_ * v1_;
        a_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((l_ - 1))] + t_ * v2_;
      }
      if (! ((*matz_))) {
        goto _l150;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        t_ = z_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] + u2_ * z_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
        z_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((l1_ - 1))] + t_ * v1_;
        z_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((l_ - 1))] + t_ * v2_;
      }
      _l150:;
    }
  }
  _l170:;
  __calls[46].calls++;
  return 0;
}

int_4 _qzit (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ eps1_, logical_4 _p_ matz_, real_8 
_p_ z_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, l_, en_, k1_, k2_, ld_, ll_, l1_, na_, ish_, itn_, its_, km1_, lm1_, enm2_, lor1_, enorn_;
  static logical_4 notlas_;
  static real_8 r_, s_, t_, a1_, a2_, a3_, ep_, sh_, u1_, u2_, u3_, v1_, v2_, v3_, ani_, a11_, a12_, a21_, a22_, a33_, 
  a34_, a43_, a44_, bni_, b11_, b12_, b22_, b33_, b34_, b44_, epsa_, epsb_, anorm_, bnorm_;
  real_8 $0_;
  (*ierr_) = 0;
  anorm_ = 0.0;
  bnorm_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ani_ = 0.0;
    if (i_ != 1) {
      ani_ = _abs (a_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))]);
    }
    bni_ = 0.0;
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      ani_ = ani_ + _abs (a_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      bni_ = bni_ + _abs (b_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
    }
    if (ani_ > anorm_) {
      anorm_ = ani_;
    }
    if (bni_ > bnorm_) {
      bnorm_ = bni_;
    }
  }
  if (anorm_ == 0.0e0) {
    anorm_ = 1.0;
  }
  if (bnorm_ == 0.0e0) {
    bnorm_ = 1.0;
  }
  ep_ = (*eps1_);
  if (ep_ > 0.0e0) {
    goto _l50;
  }
  ep_ = _epslon (($0_ = 1.0, &$0_));
  _l50:;
  epsa_ = ep_ * anorm_;
  epsb_ = ep_ * bnorm_;
  lor1_ = 1;
  enorn_ = (*n_);
  en_ = (*n_);
  itn_ = 30 * (*n_);
  _l60:;
  if (en_ <= 2) {
    goto _l1001;
  }
  if (! ((*matz_))) {
    enorn_ = en_;
  }
  its_ = 0;
  na_ = en_ - 1;
  enm2_ = na_ - 1;
  _l70:;
  ish_ = 2;
  for (ll_ = 1; ll_ <= en_; (ll_)++) {
    lm1_ = en_ - ll_;
    l_ = lm1_ + 1;
    if (l_ == 1) {
      goto _l95;
    }
    if (_abs (a_[l_ - 1 + ((*nm_)) * ((lm1_ - 1))]) <= epsa_) {
      goto _l90;
    }
  }
  _l90:;
  a_[l_ - 1 + ((*nm_)) * ((lm1_ - 1))] = 0.0;
  if (l_ < na_) {
    goto _l95;
  }
  en_ = lm1_;
  goto _l60;
  _l95:;
  ld_ = l_;
  _l100:;
  l1_ = l_ + 1;
  b11_ = b_[l_ - 1 + ((*nm_)) * ((l_ - 1))];
  if (_abs (b11_) > epsb_) {
    goto _l120;
  }
  b_[l_ - 1 + ((*nm_)) * ((l_ - 1))] = 0.0;
  s_ = _abs (a_[l_ - 1 + ((*nm_)) * ((l_ - 1))]) + _abs (a_[l1_ - 1 + ((*nm_)) * ((l_ - 1))]);
  u1_ = a_[l_ - 1 + ((*nm_)) * ((l_ - 1))] / s_;
  u2_ = a_[l1_ - 1 + ((*nm_)) * ((l_ - 1))] / s_;
  r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_), u1_);
  v1_ = -(u1_ + r_) / r_;
  v2_ = -u2_ / r_;
  u2_ = v2_ / v1_;
  for (j_ = l_; j_ <= enorn_; (j_)++) {
    t_ = a_[l_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * a_[l1_ - 1 + ((*nm_)) * ((j_ - 1))];
    a_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[l_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
    a_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
    t_ = b_[l_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * b_[l1_ - 1 + ((*nm_)) * ((j_ - 1))];
    b_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[l_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
    b_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[l1_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
  }
  if (l_ != 1) {
    a_[l_ - 1 + ((*nm_)) * ((lm1_ - 1))] = -a_[l_ - 1 + ((*nm_)) * ((lm1_ - 1))];
  }
  lm1_ = l_;
  l_ = l1_;
  goto _l90;
  _l120:;
  a11_ = a_[l_ - 1 + ((*nm_)) * ((l_ - 1))] / b11_;
  a21_ = a_[l1_ - 1 + ((*nm_)) * ((l_ - 1))] / b11_;
  if (ish_ == 1) {
    goto _l140;
  }
  if (itn_ == 0) {
    goto _l1000;
  }
  if (its_ == 10) {
    goto _l155;
  }
  b22_ = b_[l1_ - 1 + ((*nm_)) * ((l1_ - 1))];
  if (_abs (b22_) < epsb_) {
    b22_ = epsb_;
  }
  b33_ = b_[na_ - 1 + ((*nm_)) * ((na_ - 1))];
  if (_abs (b33_) < epsb_) {
    b33_ = epsb_;
  }
  b44_ = b_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
  if (_abs (b44_) < epsb_) {
    b44_ = epsb_;
  }
  a33_ = a_[na_ - 1 + ((*nm_)) * ((na_ - 1))] / b33_;
  a34_ = a_[na_ - 1 + ((*nm_)) * ((en_ - 1))] / b44_;
  a43_ = a_[en_ - 1 + ((*nm_)) * ((na_ - 1))] / b33_;
  a44_ = a_[en_ - 1 + ((*nm_)) * ((en_ - 1))] / b44_;
  b34_ = b_[na_ - 1 + ((*nm_)) * ((en_ - 1))] / b44_;
  t_ = 0.5e0 * (a43_ * b34_ - a33_ - a44_);
  r_ = t_ * t_ + a34_ * a43_ - a33_ * a44_;
  if (r_ < 0.0e0) {
    goto _l150;
  }
  ish_ = 1;
  r_ = sqrt (r_);
  sh_ = -t_ + r_;
  s_ = -t_ - r_;
  if (_abs (s_ - a44_) < _abs (sh_ - a44_)) {
    sh_ = s_;
  }
  for (ll_ = ld_; ll_ <= enm2_; (ll_)++) {
    l_ = enm2_ + ld_ - ll_;
    if (l_ == ld_) {
      goto _l140;
    }
    lm1_ = l_ - 1;
    l1_ = l_ + 1;
    t_ = a_[l_ - 1 + ((*nm_)) * ((l_ - 1))];
    if (_abs (b_[l_ - 1 + ((*nm_)) * ((l_ - 1))]) > epsb_) {
      t_ = t_ - sh_ * b_[l_ - 1 + ((*nm_)) * ((l_ - 1))];
    }
    if (_abs (a_[l_ - 1 + ((*nm_)) * ((lm1_ - 1))]) <= _abs (t_ / a_[l1_ - 1 + ((*nm_)) * ((l_ - 1))]) * epsa_) {
      goto _l100;
    }
  }
  _l140:;
  a1_ = a11_ - sh_;
  a2_ = a21_;
  if (l_ != ld_) {
    a_[l_ - 1 + ((*nm_)) * ((lm1_ - 1))] = -a_[l_ - 1 + ((*nm_)) * ((lm1_ - 1))];
  }
  goto _l160;
  _l150:;
  a12_ = a_[l_ - 1 + ((*nm_)) * ((l1_ - 1))] / b22_;
  a22_ = a_[l1_ - 1 + ((*nm_)) * ((l1_ - 1))] / b22_;
  b12_ = b_[l_ - 1 + ((*nm_)) * ((l1_ - 1))] / b22_;
  a1_ = ((a33_ - a11_) * (a44_ - a11_) - a34_ * a43_ + a43_ * b34_ * a11_) / a21_ + a12_ - a11_ * b12_;
  a2_ = (a22_ - a11_) - a21_ * b12_ - (a33_ - a11_) - (a44_ - a11_) + a43_ * b34_;
  a3_ = a_[l1_ + 1 - 1 + ((*nm_)) * ((l1_ - 1))] / b22_;
  goto _l160;
  _l155:;
  a1_ = 0.0;
  a2_ = 1.0;
  a3_ = 1.1605;
  _l160:;
  its_ = its_ + 1;
  itn_ = itn_ - 1;
  if (! ((*matz_))) {
    lor1_ = ld_;
  }
  for (k_ = l_; k_ <= na_; (k_)++) {
    notlas_ = k_ != na_ && ish_ == 2;
    k1_ = k_ + 1;
    k2_ = k_ + 2;
    km1_ = _max (k_ - 1, l_);
    ll_ = _min (en_, k1_ + ish_);
    if (notlas_) {
      goto _l190;
    }
    if (k_ == l_) {
      goto _l170;
    }
    a1_ = a_[k_ - 1 + ((*nm_)) * ((km1_ - 1))];
    a2_ = a_[k1_ - 1 + ((*nm_)) * ((km1_ - 1))];
    _l170:;
    s_ = _abs (a1_) + _abs (a2_);
    if (s_ == 0.0e0) {
      goto _l70;
    }
    u1_ = a1_ / s_;
    u2_ = a2_ / s_;
    r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_), u1_);
    v1_ = -(u1_ + r_) / r_;
    v2_ = -u2_ / r_;
    u2_ = v2_ / v1_;
    for (j_ = km1_; j_ <= enorn_; (j_)++) {
      t_ = a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * a_[k1_ - 1 + ((*nm_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
      a_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
      t_ = b_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * b_[k1_ - 1 + ((*nm_)) * ((j_ - 1))];
      b_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
      b_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
    }
    if (k_ != l_) {
      a_[k1_ - 1 + ((*nm_)) * ((km1_ - 1))] = 0.0;
    }
    goto _l240;
    _l190:;
    if (k_ == l_) {
      goto _l200;
    }
    a1_ = a_[k_ - 1 + ((*nm_)) * ((km1_ - 1))];
    a2_ = a_[k1_ - 1 + ((*nm_)) * ((km1_ - 1))];
    a3_ = a_[k2_ - 1 + ((*nm_)) * ((km1_ - 1))];
    _l200:;
    s_ = _abs (a1_) + _abs (a2_) + _abs (a3_);
    if (s_ == 0.0e0) {
      goto _l260;
    }
    u1_ = a1_ / s_;
    u2_ = a2_ / s_;
    u3_ = a3_ / s_;
    r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_ + u3_ * u3_), u1_);
    v1_ = -(u1_ + r_) / r_;
    v2_ = -u2_ / r_;
    v3_ = -u3_ / r_;
    u2_ = v2_ / v1_;
    u3_ = v3_ / v1_;
    for (j_ = km1_; j_ <= enorn_; (j_)++) {
      t_ = a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * a_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] + u3_ * a_[k2_ - 1 + ((*nm_)) * 
      ((j_ - 1))];
      a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
      a_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
      a_[k2_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k2_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v3_;
      t_ = b_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * b_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] + u3_ * b_[k2_ - 1 + ((*nm_)) * 
      ((j_ - 1))];
      b_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
      b_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[k1_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
      b_[k2_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[k2_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v3_;
    }
    if (k_ == l_) {
      goto _l220;
    }
    a_[k1_ - 1 + ((*nm_)) * ((km1_ - 1))] = 0.0;
    a_[k2_ - 1 + ((*nm_)) * ((km1_ - 1))] = 0.0;
    _l220:;
    s_ = _abs (b_[k2_ - 1 + ((*nm_)) * ((k2_ - 1))]) + _abs (b_[k2_ - 1 + ((*nm_)) * ((k1_ - 1))]) + _abs (b_[k2_ - 1 + 
    ((*nm_)) * ((k_ - 1))]);
    if (s_ == 0.0e0) {
      goto _l240;
    }
    u1_ = b_[k2_ - 1 + ((*nm_)) * ((k2_ - 1))] / s_;
    u2_ = b_[k2_ - 1 + ((*nm_)) * ((k1_ - 1))] / s_;
    u3_ = b_[k2_ - 1 + ((*nm_)) * ((k_ - 1))] / s_;
    r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_ + u3_ * u3_), u1_);
    v1_ = -(u1_ + r_) / r_;
    v2_ = -u2_ / r_;
    v3_ = -u3_ / r_;
    u2_ = v2_ / v1_;
    u3_ = v3_ / v1_;
    for (i_ = lor1_; i_ <= ll_; (i_)++) {
      t_ = a_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] + u2_ * a_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + u3_ * a_[i_ - 1 + ((*nm_)) * 
      ((k_ - 1))];
      a_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] + t_ * v1_;
      a_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + t_ * v2_;
      a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + t_ * v3_;
      t_ = b_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] + u2_ * b_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + u3_ * b_[i_ - 1 + ((*nm_)) * 
      ((k_ - 1))];
      b_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] + t_ * v1_;
      b_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + t_ * v2_;
      b_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + t_ * v3_;
    }
    b_[k2_ - 1 + ((*nm_)) * ((k_ - 1))] = 0.0;
    b_[k2_ - 1 + ((*nm_)) * ((k1_ - 1))] = 0.0;
    if (! ((*matz_))) {
      goto _l240;
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      t_ = z_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] + u2_ * z_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + u3_ * z_[i_ - 1 + ((*nm_)) * 
      ((k_ - 1))];
      z_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((k2_ - 1))] + t_ * v1_;
      z_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + t_ * v2_;
      z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + t_ * v3_;
    }
    _l240:;
    s_ = _abs (b_[k1_ - 1 + ((*nm_)) * ((k1_ - 1))]) + _abs (b_[k1_ - 1 + ((*nm_)) * ((k_ - 1))]);
    if (s_ == 0.0e0) {
      goto _l260;
    }
    u1_ = b_[k1_ - 1 + ((*nm_)) * ((k1_ - 1))] / s_;
    u2_ = b_[k1_ - 1 + ((*nm_)) * ((k_ - 1))] / s_;
    r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_), u1_);
    v1_ = -(u1_ + r_) / r_;
    v2_ = -u2_ / r_;
    u2_ = v2_ / v1_;
    for (i_ = lor1_; i_ <= ll_; (i_)++) {
      t_ = a_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + u2_ * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      a_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + t_ * v1_;
      a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + t_ * v2_;
      t_ = b_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + u2_ * b_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      b_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + t_ * v1_;
      b_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + t_ * v2_;
    }
    b_[k1_ - 1 + ((*nm_)) * ((k_ - 1))] = 0.0;
    if (! ((*matz_))) {
      goto _l260;
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      t_ = z_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + u2_ * z_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      z_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((k1_ - 1))] + t_ * v1_;
      z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] + t_ * v2_;
    }
    _l260:;
  }
  goto _l70;
  _l1000:;
  (*ierr_) = en_;
  _l1001:;
  if ((*n_) > 1) {
    b_[(*n_) - 1 + ((*nm_)) * ((0))] = epsb_;
  }
  __calls[47].calls++;
  return 0;
}

int_4 _qzval (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfr_, real_8 _p_ alfi_, real_8 _p_ 
beta_, logical_4 _p_ matz_, real_8 _p_ z_)
{
  static int_4 i_, j_, en_, na_, nn_, isw_;
  static real_8 c_, d_, e_, r_, s_, t_, an_, a1_, a2_, bn_, cq_, cz_, di_, dr_, ei_, ti_, tr_, u1_, u2_, v1_, v2_, a1i_, 
  a11_, a12_, a2i_, a21_, a22_, b11_, b12_, b22_, sqi_, sqr_, ssi_, ssr_, szi_, szr_, a11i_, a11r_, a12i_, a12r_, a22i_, 
  a22r_, epsb_;
  epsb_ = b_[(*n_) - 1 + ((*nm_)) * ((0))];
  isw_ = 1;
  for (nn_ = 1; nn_ <= (*n_); (nn_)++) {
    en_ = (*n_) + 1 - nn_;
    na_ = en_ - 1;
    if (isw_ == 2) {
      goto _l505;
    }
    if (en_ == 1) {
      goto _l410;
    }
    if (a_[en_ - 1 + ((*nm_)) * ((na_ - 1))] != 0.0e0) {
      goto _l420;
    }
    _l410:;
    alfr_[en_ - 1] = a_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
    if (b_[en_ - 1 + ((*nm_)) * ((en_ - 1))] < 0.0e0) {
      alfr_[en_ - 1] = -alfr_[en_ - 1];
    }
    beta_[en_ - 1] = _abs (b_[en_ - 1 + ((*nm_)) * ((en_ - 1))]);
    alfi_[en_ - 1] = 0.0;
    goto _l510;
    _l420:;
    if (_abs (b_[na_ - 1 + ((*nm_)) * ((na_ - 1))]) <= epsb_) {
      goto _l455;
    }
    if (_abs (b_[en_ - 1 + ((*nm_)) * ((en_ - 1))]) > epsb_) {
      goto _l430;
    }
    a1_ = a_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
    a2_ = a_[en_ - 1 + ((*nm_)) * ((na_ - 1))];
    bn_ = 0.0;
    goto _l435;
    _l430:;
    an_ = _abs (a_[na_ - 1 + ((*nm_)) * ((na_ - 1))]) + _abs (a_[na_ - 1 + ((*nm_)) * ((en_ - 1))]) + _abs (a_[en_ - 1 + 
    ((*nm_)) * ((na_ - 1))]) + _abs (a_[en_ - 1 + ((*nm_)) * ((en_ - 1))]);
    bn_ = _abs (b_[na_ - 1 + ((*nm_)) * ((na_ - 1))]) + _abs (b_[na_ - 1 + ((*nm_)) * ((en_ - 1))]) + _abs (b_[en_ - 1 + 
    ((*nm_)) * ((en_ - 1))]);
    a11_ = a_[na_ - 1 + ((*nm_)) * ((na_ - 1))] / an_;
    a12_ = a_[na_ - 1 + ((*nm_)) * ((en_ - 1))] / an_;
    a21_ = a_[en_ - 1 + ((*nm_)) * ((na_ - 1))] / an_;
    a22_ = a_[en_ - 1 + ((*nm_)) * ((en_ - 1))] / an_;
    b11_ = b_[na_ - 1 + ((*nm_)) * ((na_ - 1))] / bn_;
    b12_ = b_[na_ - 1 + ((*nm_)) * ((en_ - 1))] / bn_;
    b22_ = b_[en_ - 1 + ((*nm_)) * ((en_ - 1))] / bn_;
    e_ = a11_ / b11_;
    ei_ = a22_ / b22_;
    s_ = a21_ / (b11_ * b22_);
    t_ = (a22_ - e_ * b22_) / b22_;
    if (_abs (e_) <= _abs (ei_)) {
      goto _l431;
    }
    e_ = ei_;
    t_ = (a11_ - e_ * b11_) / b11_;
    _l431:;
    c_ = 0.5e0 * (t_ - s_ * b12_);
    d_ = c_ * c_ + s_ * (a12_ - e_ * b12_);
    if (d_ < 0.0e0) {
      goto _l480;
    }
    e_ = e_ + (c_ + _sign (sqrt (d_), c_));
    a11_ = a11_ - e_ * b11_;
    a12_ = a12_ - e_ * b12_;
    a22_ = a22_ - e_ * b22_;
    if (_abs (a11_) + _abs (a12_) < _abs (a21_) + _abs (a22_)) {
      goto _l432;
    }
    a1_ = a12_;
    a2_ = a11_;
    goto _l435;
    _l432:;
    a1_ = a22_;
    a2_ = a21_;
    _l435:;
    s_ = _abs (a1_) + _abs (a2_);
    u1_ = a1_ / s_;
    u2_ = a2_ / s_;
    r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_), u1_);
    v1_ = -(u1_ + r_) / r_;
    v2_ = -u2_ / r_;
    u2_ = v2_ / v1_;
    for (i_ = 1; i_ <= en_; (i_)++) {
      t_ = a_[i_ - 1 + ((*nm_)) * ((en_ - 1))] + u2_ * a_[i_ - 1 + ((*nm_)) * ((na_ - 1))];
      a_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((en_ - 1))] + t_ * v1_;
      a_[i_ - 1 + ((*nm_)) * ((na_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((na_ - 1))] + t_ * v2_;
      t_ = b_[i_ - 1 + ((*nm_)) * ((en_ - 1))] + u2_ * b_[i_ - 1 + ((*nm_)) * ((na_ - 1))];
      b_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((en_ - 1))] + t_ * v1_;
      b_[i_ - 1 + ((*nm_)) * ((na_ - 1))] = b_[i_ - 1 + ((*nm_)) * ((na_ - 1))] + t_ * v2_;
    }
    if (! ((*matz_))) {
      goto _l450;
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      t_ = z_[i_ - 1 + ((*nm_)) * ((en_ - 1))] + u2_ * z_[i_ - 1 + ((*nm_)) * ((na_ - 1))];
      z_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((en_ - 1))] + t_ * v1_;
      z_[i_ - 1 + ((*nm_)) * ((na_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((na_ - 1))] + t_ * v2_;
    }
    _l450:;
    if (bn_ == 0.0e0) {
      goto _l475;
    }
    if (an_ < _abs (e_) * bn_) {
      goto _l455;
    }
    a1_ = b_[na_ - 1 + ((*nm_)) * ((na_ - 1))];
    a2_ = b_[en_ - 1 + ((*nm_)) * ((na_ - 1))];
    goto _l460;
    _l455:;
    a1_ = a_[na_ - 1 + ((*nm_)) * ((na_ - 1))];
    a2_ = a_[en_ - 1 + ((*nm_)) * ((na_ - 1))];
    _l460:;
    s_ = _abs (a1_) + _abs (a2_);
    if (s_ == 0.0e0) {
      goto _l475;
    }
    u1_ = a1_ / s_;
    u2_ = a2_ / s_;
    r_ = _sign (sqrt (u1_ * u1_ + u2_ * u2_), u1_);
    v1_ = -(u1_ + r_) / r_;
    v2_ = -u2_ / r_;
    u2_ = v2_ / v1_;
    for (j_ = na_; j_ <= (*n_); (j_)++) {
      t_ = a_[na_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * a_[en_ - 1 + ((*nm_)) * ((j_ - 1))];
      a_[na_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[na_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
      a_[en_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[en_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
      t_ = b_[na_ - 1 + ((*nm_)) * ((j_ - 1))] + u2_ * b_[en_ - 1 + ((*nm_)) * ((j_ - 1))];
      b_[na_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[na_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v1_;
      b_[en_ - 1 + ((*nm_)) * ((j_ - 1))] = b_[en_ - 1 + ((*nm_)) * ((j_ - 1))] + t_ * v2_;
    }
    _l475:;
    a_[en_ - 1 + ((*nm_)) * ((na_ - 1))] = 0.0;
    b_[en_ - 1 + ((*nm_)) * ((na_ - 1))] = 0.0;
    alfr_[na_ - 1] = a_[na_ - 1 + ((*nm_)) * ((na_ - 1))];
    alfr_[en_ - 1] = a_[en_ - 1 + ((*nm_)) * ((en_ - 1))];
    if (b_[na_ - 1 + ((*nm_)) * ((na_ - 1))] < 0.0e0) {
      alfr_[na_ - 1] = -alfr_[na_ - 1];
    }
    if (b_[en_ - 1 + ((*nm_)) * ((en_ - 1))] < 0.0e0) {
      alfr_[en_ - 1] = -alfr_[en_ - 1];
    }
    beta_[na_ - 1] = _abs (b_[na_ - 1 + ((*nm_)) * ((na_ - 1))]);
    beta_[en_ - 1] = _abs (b_[en_ - 1 + ((*nm_)) * ((en_ - 1))]);
    alfi_[en_ - 1] = 0.0;
    alfi_[na_ - 1] = 0.0;
    goto _l505;
    _l480:;
    e_ = e_ + c_;
    ei_ = sqrt (-d_);
    a11r_ = a11_ - e_ * b11_;
    a11i_ = ei_ * b11_;
    a12r_ = a12_ - e_ * b12_;
    a12i_ = ei_ * b12_;
    a22r_ = a22_ - e_ * b22_;
    a22i_ = ei_ * b22_;
    if (_abs (a11r_) + _abs (a11i_) + _abs (a12r_) + _abs (a12i_) < _abs (a21_) + _abs (a22r_) + _abs (a22i_)) {
      goto _l482;
    }
    a1_ = a12r_;
    a1i_ = a12i_;
    a2_ = -a11r_;
    a2i_ = -a11i_;
    goto _l485;
    _l482:;
    a1_ = a22r_;
    a1i_ = a22i_;
    a2_ = -a21_;
    a2i_ = 0.0;
    _l485:;
    cz_ = sqrt (a1_ * a1_ + a1i_ * a1i_);
    if (cz_ == 0.0e0) {
      goto _l487;
    }
    szr_ = (a1_ * a2_ + a1i_ * a2i_) / cz_;
    szi_ = (a1_ * a2i_ - a1i_ * a2_) / cz_;
    r_ = sqrt (cz_ * cz_ + szr_ * szr_ + szi_ * szi_);
    cz_ = cz_ / r_;
    szr_ = szr_ / r_;
    szi_ = szi_ / r_;
    goto _l490;
    _l487:;
    szr_ = 1.0;
    szi_ = 0.0;
    _l490:;
    if (an_ < (_abs (e_) + ei_) * bn_) {
      goto _l492;
    }
    a1_ = cz_ * b11_ + szr_ * b12_;
    a1i_ = szi_ * b12_;
    a2_ = szr_ * b22_;
    a2i_ = szi_ * b22_;
    goto _l495;
    _l492:;
    a1_ = cz_ * a11_ + szr_ * a12_;
    a1i_ = szi_ * a12_;
    a2_ = cz_ * a21_ + szr_ * a22_;
    a2i_ = szi_ * a22_;
    _l495:;
    cq_ = sqrt (a1_ * a1_ + a1i_ * a1i_);
    if (cq_ == 0.0e0) {
      goto _l497;
    }
    sqr_ = (a1_ * a2_ + a1i_ * a2i_) / cq_;
    sqi_ = (a1_ * a2i_ - a1i_ * a2_) / cq_;
    r_ = sqrt (cq_ * cq_ + sqr_ * sqr_ + sqi_ * sqi_);
    cq_ = cq_ / r_;
    sqr_ = sqr_ / r_;
    sqi_ = sqi_ / r_;
    goto _l500;
    _l497:;
    sqr_ = 1.0;
    sqi_ = 0.0;
    _l500:;
    ssr_ = sqr_ * szr_ + sqi_ * szi_;
    ssi_ = sqr_ * szi_ - sqi_ * szr_;
    i_ = 1;
    tr_ = cq_ * cz_ * a11_ + cq_ * szr_ * a12_ + sqr_ * cz_ * a21_ + ssr_ * a22_;
    ti_ = cq_ * szi_ * a12_ - sqi_ * cz_ * a21_ + ssi_ * a22_;
    dr_ = cq_ * cz_ * b11_ + cq_ * szr_ * b12_ + ssr_ * b22_;
    di_ = cq_ * szi_ * b12_ + ssi_ * b22_;
    goto _l503;
    _l502:;
    i_ = 2;
    tr_ = ssr_ * a11_ - sqr_ * cz_ * a12_ - cq_ * szr_ * a21_ + cq_ * cz_ * a22_;
    ti_ = -ssi_ * a11_ - sqi_ * cz_ * a12_ + cq_ * szi_ * a21_;
    dr_ = ssr_ * b11_ - sqr_ * cz_ * b12_ + cq_ * cz_ * b22_;
    di_ = -ssi_ * b11_ - sqi_ * cz_ * b12_;
    _l503:;
    t_ = ti_ * dr_ - tr_ * di_;
    j_ = na_;
    if (t_ < 0.0e0) {
      j_ = en_;
    }
    r_ = sqrt (dr_ * dr_ + di_ * di_);
    beta_[j_ - 1] = bn_ * r_;
    alfr_[j_ - 1] = an_ * (tr_ * dr_ + ti_ * di_) / r_;
    alfi_[j_ - 1] = an_ * t_ / r_;
    if (i_ == 1) {
      goto _l502;
    }
    _l505:;
    isw_ = 3 - isw_;
    _l510:;
  }
  b_[(*n_) - 1 + ((*nm_)) * ((0))] = epsb_;
  __calls[48].calls++;
  return 0;
}

int_4 _qzvec (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfr_, real_8 _p_ alfi_, real_8 _p_ 
beta_, real_8 _p_ z_)
{
  static int_4 i_, j_, k_, m_, en_, ii_, jj_, na_, nn_, isw_, enm2_;
  static real_8 d_, q_, r_, s_, t_, w_, x_, y_, di_, dr_, ra_, rr_, sa_, ti_, tr_, t1_, t2_, w1_, x1_, zz_, z1_, alfm_, 
  almi_, almr_, betm_, epsb_;
  real_8 $0_, $1_;
  epsb_ = b_[(*n_) - 1 + ((*nm_)) * ((0))];
  isw_ = 1;
  for (nn_ = 1; nn_ <= (*n_); (nn_)++) {
    en_ = (*n_) + 1 - nn_;
    na_ = en_ - 1;
    if (isw_ == 2) {
      goto _l795;
    }
    if (alfi_[en_ - 1] != 0.0e0) {
      goto _l710;
    }
    m_ = en_;
    b_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 1.0;
    if (na_ == 0) {
      goto _l800;
    }
    alfm_ = alfr_[m_ - 1];
    betm_ = beta_[m_ - 1];
    for (ii_ = 1; ii_ <= na_; (ii_)++) {
      i_ = en_ - ii_;
      w_ = betm_ * a_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - alfm_ * b_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
      r_ = 0.0;
      for (j_ = m_; j_ <= en_; (j_)++) {
        r_ = r_ + (betm_ * a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - alfm_ * b_[i_ - 1 + ((*nm_)) * ((j_ - 1))]) * b_[j_ - 1 + 
        ((*nm_)) * ((en_ - 1))];
      }
      if (i_ == 1 || isw_ == 2) {
        goto _l630;
      }
      if (betm_ * a_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] == 0.0e0) {
        goto _l630;
      }
      zz_ = w_;
      s_ = r_;
      goto _l690;
      _l630:;
      m_ = i_;
      if (isw_ == 2) {
        goto _l640;
      }
      t_ = w_;
      if (w_ == 0.0e0) {
        t_ = epsb_;
      }
      b_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = -r_ / t_;
      goto _l700;
      _l640:;
      x_ = betm_ * a_[i_ - 1 + ((*nm_)) * ((i_ + 1 - 1))] - alfm_ * b_[i_ - 1 + ((*nm_)) * ((i_ + 1 - 1))];
      y_ = betm_ * a_[i_ + 1 - 1 + ((*nm_)) * ((i_ - 1))];
      q_ = w_ * zz_ - x_ * y_;
      t_ = (x_ * s_ - zz_ * r_) / q_;
      b_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = t_;
      if (_abs (x_) <= _abs (zz_)) {
        goto _l650;
      }
      b_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))] = (-r_ - w_ * t_) / x_;
      goto _l690;
      _l650:;
      b_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))] = (-s_ - y_ * t_) / zz_;
      _l690:;
      isw_ = 3 - isw_;
      _l700:;
    }
    goto _l800;
    _l710:;
    m_ = na_;
    almr_ = alfr_[m_ - 1];
    almi_ = alfi_[m_ - 1];
    betm_ = beta_[m_ - 1];
    y_ = betm_ * a_[en_ - 1 + ((*nm_)) * ((na_ - 1))];
    b_[na_ - 1 + ((*nm_)) * ((na_ - 1))] = -almi_ * b_[en_ - 1 + ((*nm_)) * ((en_ - 1))] / y_;
    b_[na_ - 1 + ((*nm_)) * ((en_ - 1))] = (almr_ * b_[en_ - 1 + ((*nm_)) * ((en_ - 1))] - betm_ * a_[en_ - 1 + ((*nm_)) * 
    ((en_ - 1))]) / y_;
    b_[en_ - 1 + ((*nm_)) * ((na_ - 1))] = 0.0;
    b_[en_ - 1 + ((*nm_)) * ((en_ - 1))] = 1.0;
    enm2_ = na_ - 1;
    if (enm2_ == 0) {
      goto _l795;
    }
    for (ii_ = 1; ii_ <= enm2_; (ii_)++) {
      i_ = na_ - ii_;
      w_ = betm_ * a_[i_ - 1 + ((*nm_)) * ((i_ - 1))] - almr_ * b_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
      w1_ = -almi_ * b_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
      ra_ = 0.0;
      sa_ = 0.0;
      for (j_ = m_; j_ <= en_; (j_)++) {
        x_ = betm_ * a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] - almr_ * b_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        x1_ = -almi_ * b_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
        ra_ = ra_ + x_ * b_[j_ - 1 + ((*nm_)) * ((na_ - 1))] - x1_ * b_[j_ - 1 + ((*nm_)) * ((en_ - 1))];
        sa_ = sa_ + x_ * b_[j_ - 1 + ((*nm_)) * ((en_ - 1))] + x1_ * b_[j_ - 1 + ((*nm_)) * ((na_ - 1))];
      }
      if (i_ == 1 || isw_ == 2) {
        goto _l770;
      }
      if (betm_ * a_[i_ - 1 + ((*nm_)) * ((i_ - 1 - 1))] == 0.0e0) {
        goto _l770;
      }
      zz_ = w_;
      z1_ = w1_;
      r_ = ra_;
      s_ = sa_;
      isw_ = 2;
      goto _l790;
      _l770:;
      m_ = i_;
      if (isw_ == 2) {
        goto _l780;
      }
      tr_ = -ra_;
      ti_ = -sa_;
      _l773:;
      dr_ = w_;
      di_ = w1_;
      _l775:;
      if (_abs (di_) > _abs (dr_)) {
        goto _l777;
      }
      rr_ = di_ / dr_;
      d_ = dr_ + di_ * rr_;
      t1_ = (tr_ + ti_ * rr_) / d_;
      t2_ = (ti_ - tr_ * rr_) / d_;
      switch (isw_) {
        default:
        case 1: goto _l787;
        case 2: goto _l782;
      }
      _l777:;
      rr_ = dr_ / di_;
      d_ = dr_ * rr_ + di_;
      t1_ = (tr_ * rr_ + ti_) / d_;
      t2_ = (ti_ * rr_ - tr_) / d_;
      switch (isw_) {
        default:
        case 1: goto _l787;
        case 2: goto _l782;
      }
      _l780:;
      x_ = betm_ * a_[i_ - 1 + ((*nm_)) * ((i_ + 1 - 1))] - almr_ * b_[i_ - 1 + ((*nm_)) * ((i_ + 1 - 1))];
      x1_ = -almi_ * b_[i_ - 1 + ((*nm_)) * ((i_ + 1 - 1))];
      y_ = betm_ * a_[i_ + 1 - 1 + ((*nm_)) * ((i_ - 1))];
      tr_ = y_ * ra_ - w_ * r_ + w1_ * s_;
      ti_ = y_ * sa_ - w_ * s_ - w1_ * r_;
      dr_ = w_ * zz_ - w1_ * z1_ - x_ * y_;
      di_ = w_ * z1_ + w1_ * zz_ - x1_ * y_;
      if (dr_ == 0.0e0 && di_ == 0.0e0) {
        dr_ = epsb_;
      }
      goto _l775;
      _l782:;
      b_[i_ + 1 - 1 + ((*nm_)) * ((na_ - 1))] = t1_;
      b_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))] = t2_;
      isw_ = 1;
      if (_abs (y_) > _abs (w_) + _abs (w1_)) {
        goto _l785;
      }
      tr_ = -ra_ - x_ * b_[i_ + 1 - 1 + ((*nm_)) * ((na_ - 1))] + x1_ * b_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))];
      ti_ = -sa_ - x_ * b_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))] - x1_ * b_[i_ + 1 - 1 + ((*nm_)) * ((na_ - 1))];
      goto _l773;
      _l785:;
      t1_ = (-r_ - zz_ * b_[i_ + 1 - 1 + ((*nm_)) * ((na_ - 1))] + z1_ * b_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))]) / y_;
      t2_ = (-s_ - zz_ * b_[i_ + 1 - 1 + ((*nm_)) * ((en_ - 1))] - z1_ * b_[i_ + 1 - 1 + ((*nm_)) * ((na_ - 1))]) / y_;
      _l787:;
      b_[i_ - 1 + ((*nm_)) * ((na_ - 1))] = t1_;
      b_[i_ - 1 + ((*nm_)) * ((en_ - 1))] = t2_;
      _l790:;
    }
    _l795:;
    isw_ = 3 - isw_;
    _l800:;
  }
  for (jj_ = 1; jj_ <= (*n_); (jj_)++) {
    j_ = (*n_) + 1 - jj_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      zz_ = 0.0;
      for (k_ = 1; k_ <= j_; (k_)++) {
        zz_ = zz_ + z_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * b_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = zz_;
    }
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    d_ = 0.0;
    if (isw_ == 2) {
      goto _l920;
    }
    if (alfi_[j_ - 1] != 0.0e0) {
      goto _l945;
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      if (_abs (z_[i_ - 1 + ((*nm_)) * ((j_ - 1))]) > d_) {
        d_ = _abs (z_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      }
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] / d_;
    }
    goto _l950;
    _l920:;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      r_ = _abs (z_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))]) + _abs (z_[i_ - 1 + ((*nm_)) * ((j_ - 1))]);
      if (r_ != 0.0e0) {
        r_ = r_ * sqrt (($0_ = (z_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] / r_), $0_ * $0_) + ($1_ = (z_[i_ - 1 + ((*nm_)) * ((j_ 
        - 1))] / r_), $1_ * $1_));
      }
      if (r_ > d_) {
        d_ = r_;
      }
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1 - 1))] / d_;
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] / d_;
    }
    _l945:;
    isw_ = 3 - isw_;
    _l950:;
  }
  __calls[49].calls++;
  return 0;
}

int_4 _ratqr (int_4 _p_ n_, real_8 _p_ eps1_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, int_4 _p_ m_, real_8 _p_ w_
, int_4 _p_ ind_, real_8 _p_ bd_, logical_4 _p_ type_, int_4 _p_ idef_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, ii_, jj_, k1_, jdef_;
  static real_8 f_, p_, q_, r_, s_, ep_, qp_, err_, tot_, delta_;
  real_8 $0_, $1_, $2_;
  (*ierr_) = 0;
  jdef_ = (*idef_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = d_[i_ - 1];
  }
  if ((*type_)) {
    goto _l40;
  }
  j_ = 1;
  goto _l400;
  _l40:;
  err_ = 0.0;
  s_ = 0.0;
  tot_ = w_[0];
  q_ = 0.0;
  j_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    p_ = q_;
    if (i_ == 1) {
      goto _l60;
    }
    if (p_ > _epslon (($0_ = _abs (d_[i_ - 1]) + _abs (d_[i_ - 1 - 1]), &$0_))) {
      goto _l80;
    }
    _l60:;
    e2_[i_ - 1] = 0.0;
    _l80:;
    bd_[i_ - 1] = e2_[i_ - 1];
    if (e2_[i_ - 1] == 0.0e0) {
      j_ = j_ + 1;
    }
    ind_[i_ - 1] = j_;
    q_ = 0.0;
    if (i_ != (*n_)) {
      q_ = _abs (e_[i_ + 1 - 1]);
    }
    tot_ = _min (w_[i_ - 1] - p_ - q_, tot_);
  }
  if (jdef_ == 1 && tot_ < 0.0e0) {
    goto _l140;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = w_[i_ - 1] - tot_;
  }
  goto _l160;
  _l140:;
  tot_ = 0.0;
  _l160:;
  for (k_ = 1; k_ <= (*m_); (k_)++) {
    _l180:;
    tot_ = tot_ + s_;
    delta_ = w_[(*n_) - 1] - s_;
    i_ = (*n_);
    f_ = _abs (_epslon (&tot_));
    if ((*eps1_) < f_) {
      (*eps1_) = f_;
    }
    if (delta_ > (*eps1_)) {
      goto _l190;
    }
    if (delta_ < (-(*eps1_))) {
      goto _l1000;
    }
    goto _l300;
    _l190:;
    if (k_ == (*n_)) {
      goto _l210;
    }
    k1_ = k_ + 1;
    for (j_ = k1_; j_ <= (*n_); (j_)++) {
      if (bd_[j_ - 1] <= ($2_ = (_epslon (($1_ = w_[j_ - 1] + w_[j_ - 1 - 1], &$1_))), $2_ * $2_)) {
        bd_[j_ - 1] = 0.0;
      }
    }
    _l210:;
    f_ = bd_[(*n_) - 1] / delta_;
    qp_ = delta_ + f_;
    p_ = 1.0;
    if (k_ == (*n_)) {
      goto _l260;
    }
    k1_ = (*n_) - k_;
    for (ii_ = 1; ii_ <= k1_; (ii_)++) {
      i_ = (*n_) - ii_;
      q_ = w_[i_ - 1] - s_ - f_;
      r_ = q_ / qp_;
      p_ = p_ * r_ + 1.0e0;
      ep_ = f_ * r_;
      w_[i_ + 1 - 1] = qp_ + ep_;
      delta_ = q_ - ep_;
      if (delta_ > (*eps1_)) {
        goto _l220;
      }
      if (delta_ < (-(*eps1_))) {
        goto _l1000;
      }
      goto _l300;
      _l220:;
      f_ = bd_[i_ - 1] / q_;
      qp_ = delta_ + f_;
      bd_[i_ + 1 - 1] = qp_ * ep_;
    }
    _l260:;
    w_[k_ - 1] = qp_;
    s_ = qp_ / p_;
    if (tot_ + s_ > tot_) {
      goto _l180;
    }
    (*ierr_) = 5 * (*n_) + k_;
    s_ = 0.0;
    delta_ = qp_;
    for (j_ = k_; j_ <= (*n_); (j_)++) {
      if (w_[j_ - 1] > delta_) {
        goto _l280;
      }
      i_ = j_;
      delta_ = w_[j_ - 1];
      _l280:;
    }
    _l300:;
    if (i_ < (*n_)) {
      bd_[i_ + 1 - 1] = bd_[i_ - 1] * f_ / qp_;
    }
    ii_ = ind_[i_ - 1];
    if (i_ == k_) {
      goto _l340;
    }
    k1_ = i_ - k_;
    for (jj_ = 1; jj_ <= k1_; (jj_)++) {
      j_ = i_ - jj_;
      w_[j_ + 1 - 1] = w_[j_ - 1] - s_;
      bd_[j_ + 1 - 1] = bd_[j_ - 1];
      ind_[j_ + 1 - 1] = ind_[j_ - 1];
    }
    _l340:;
    w_[k_ - 1] = tot_;
    err_ = err_ + _abs (delta_);
    bd_[k_ - 1] = err_;
    ind_[k_ - 1] = ii_;
  }
  if ((*type_)) {
    goto _l1001;
  }
  f_ = bd_[0];
  e2_[0] = 2.0;
  bd_[0] = f_;
  j_ = 2;
  _l400:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = -w_[i_ - 1];
  }
  jdef_ = -jdef_;
  switch (j_) {
    default:
    case 1: goto _l40;
    case 2: goto _l1001;
  }
  _l1000:;
  (*ierr_) = 6 * (*n_) + 1;
  _l1001:;
  __calls[50].calls++;
  return 0;
}

int_4 _rebakb (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ b_, real_8 _p_ dl_, int_4 _p_ m_, real_8 _p_ z_)
{
  static int_4 i_, j_, k_, i1_, ii_;
  static real_8 x_;
  if ((*m_) == 0) {
    goto _l200;
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
      i1_ = (*n_) - ii_;
      i_ = i1_ + 1;
      x_ = dl_[i_ - 1] * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == 1) {
        goto _l80;
      }
      for (k_ = 1; k_ <= i1_; (k_)++) {
        x_ = x_ + b_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * z_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      _l80:;
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = x_;
    }
  }
  _l200:;
  __calls[51].calls++;
  return 0;
}

int_4 _rebak (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ b_, real_8 _p_ dl_, int_4 _p_ m_, real_8 _p_ z_)
{
  static int_4 i_, j_, k_, i1_, ii_;
  static real_8 x_;
  if ((*m_) == 0) {
    goto _l200;
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
      i_ = (*n_) + 1 - ii_;
      i1_ = i_ + 1;
      x_ = z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == (*n_)) {
        goto _l80;
      }
      for (k_ = i1_; k_ <= (*n_); (k_)++) {
        x_ = x_ - b_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * z_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      _l80:;
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = x_ / dl_[i_ - 1];
    }
  }
  _l200:;
  __calls[52].calls++;
  return 0;
}

int_4 _reduc2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ dl_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, i1_, j1_, nn_;
  static real_8 x_, y_;
  (*ierr_) = 0;
  nn_ = (int_4) (_abs ((*n_)));
  if ((*n_) < 0) {
    goto _l100;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    i1_ = i_ - 1;
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      x_ = b_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == 1) {
        goto _l40;
      }
      for (k_ = 1; k_ <= i1_; (k_)++) {
        x_ = x_ - b_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * b_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l40:;
      if (j_ != i_) {
        goto _l60;
      }
      if (x_ <= 0.0e0) {
        goto _l1000;
      }
      y_ = sqrt (x_);
      dl_[i_ - 1] = y_;
      goto _l80;
      _l60:;
      b_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = x_ / y_;
      _l80:;
    }
  }
  _l100:;
  for (i_ = 1; i_ <= nn_; (i_)++) {
    i1_ = i_ + 1;
    for (j_ = 1; j_ <= i_; (j_)++) {
      x_ = a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] * dl_[j_ - 1];
      if (j_ == i_) {
        goto _l140;
      }
      j1_ = j_ + 1;
      for (k_ = j1_; k_ <= i_; (k_)++) {
        x_ = x_ + a_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * b_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      _l140:;
      if (i_ == nn_) {
        goto _l180;
      }
      for (k_ = i1_; k_ <= nn_; (k_)++) {
        x_ = x_ + a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * b_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      _l180:;
      a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = x_;
    }
  }
  for (i_ = 1; i_ <= nn_; (i_)++) {
    i1_ = i_ + 1;
    y_ = dl_[i_ - 1];
    for (j_ = 1; j_ <= i_; (j_)++) {
      x_ = y_ * a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == nn_) {
        goto _l280;
      }
      for (k_ = i1_; k_ <= nn_; (k_)++) {
        x_ = x_ + a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * b_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
      _l280:;
      a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = x_;
    }
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = 7 * (*n_) + 1;
  _l1001:;
  __calls[53].calls++;
  return 0;
}

int_4 _reduc (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ dl_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, i1_, j1_, nn_;
  static real_8 x_, y_;
  (*ierr_) = 0;
  nn_ = (int_4) (_abs ((*n_)));
  if ((*n_) < 0) {
    goto _l100;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    i1_ = i_ - 1;
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      x_ = b_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == 1) {
        goto _l40;
      }
      for (k_ = 1; k_ <= i1_; (k_)++) {
        x_ = x_ - b_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * b_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l40:;
      if (j_ != i_) {
        goto _l60;
      }
      if (x_ <= 0.0e0) {
        goto _l1000;
      }
      y_ = sqrt (x_);
      dl_[i_ - 1] = y_;
      goto _l80;
      _l60:;
      b_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = x_ / y_;
      _l80:;
    }
  }
  _l100:;
  for (i_ = 1; i_ <= nn_; (i_)++) {
    i1_ = i_ - 1;
    y_ = dl_[i_ - 1];
    for (j_ = i_; j_ <= nn_; (j_)++) {
      x_ = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == 1) {
        goto _l180;
      }
      for (k_ = 1; k_ <= i1_; (k_)++) {
        x_ = x_ - b_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * a_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l180:;
      a_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = x_ / y_;
    }
  }
  for (j_ = 1; j_ <= nn_; (j_)++) {
    j1_ = j_ - 1;
    for (i_ = j_; i_ <= nn_; (i_)++) {
      x_ = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      if (i_ == j_) {
        goto _l240;
      }
      i1_ = i_ - 1;
      for (k_ = j_; k_ <= i1_; (k_)++) {
        x_ = x_ - a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * b_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l240:;
      if (j_ == 1) {
        goto _l280;
      }
      for (k_ = 1; k_ <= j1_; (k_)++) {
        x_ = x_ - a_[j_ - 1 + ((*nm_)) * ((k_ - 1))] * b_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      _l280:;
      a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = x_ / dl_[i_ - 1];
    }
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = 7 * (*n_) + 1;
  _l1001:;
  __calls[54].calls++;
  return 0;
}

int_4 _rgelm (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ matz_, real_8 _p_ 
z_, int_4 _p_ iv1_, real_8 _p_ fv1_, int_4 _p_ ierr_)
{
  static int_4 is1_, is2_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _balanc (nm_, n_, a_, &is1_, &is2_, fv1_);
  (void) _elmhes (nm_, n_, &is1_, &is2_, a_, iv1_);
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _hqr (nm_, n_, &is1_, &is2_, a_, wr_, wi_, ierr_);
  goto _l50;
  _l20:;
  (void) _eltran (nm_, n_, &is1_, &is2_, a_, iv1_, z_);
  (void) _hqr2 (nm_, n_, &is1_, &is2_, a_, wr_, wi_, z_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _balbak (nm_, n_, &is1_, &is2_, fv1_, n_, z_);
  _l50:;
  __calls[55].calls++;
  return 0;
}

int_4 _rg (int_4 _p_ nm_, int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ wr_, real_4 _p_ wi_, int_4 _p_ matz_, real_4 _p_ z_, 
int_4 _p_ iv1_, real_4 _p_ fv1_, int_4 _p_ ierr_)
{
  static int_4 is1_, is2_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _balanc (nm_, n_, a_, &is1_, &is2_, fv1_);
  (void) _elmhes (nm_, n_, &is1_, &is2_, a_, iv1_);
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _hqr (nm_, n_, &is1_, &is2_, a_, wr_, wi_, ierr_);
  goto _l50;
  _l20:;
  (void) _eltran (nm_, n_, &is1_, &is2_, a_, iv1_, z_);
  (void) _hqr2 (nm_, n_, &is1_, &is2_, a_, wr_, wi_, z_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _balbak (nm_, n_, &is1_, &is2_, fv1_, n_, z_);
  _l50:;
  __calls[56].calls++;
  return 0;
}

int_4 _rgg (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfr_, real_8 _p_ alfi_, real_8 _p_ 
beta_, int_4 _p_ matz_, real_8 _p_ z_, int_4 _p_ ierr_)
{
  static logical_4 tf_;
  real_8 $0_, $1_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  if ((*matz_) != 0) {
    goto _l20;
  }
  tf_ = FALSE;
  (void) _qzhes (nm_, n_, a_, b_, &tf_, z_);
  (void) _qzit (nm_, n_, a_, b_, ($0_ = 0.0, &$0_), &tf_, z_, ierr_);
  (void) _qzval (nm_, n_, a_, b_, alfr_, alfi_, beta_, &tf_, z_);
  goto _l50;
  _l20:;
  tf_ = TRUE;
  (void) _qzhes (nm_, n_, a_, b_, &tf_, z_);
  (void) _qzit (nm_, n_, a_, b_, ($1_ = 0.0, &$1_), &tf_, z_, ierr_);
  (void) _qzval (nm_, n_, a_, b_, alfr_, alfi_, beta_, &tf_, z_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _qzvec (nm_, n_, a_, b_, alfr_, alfi_, beta_, z_);
  _l50:;
  __calls[57].calls++;
  return 0;
}

int_4 _rgort (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ matz_, real_8 _p_ 
z_, real_8 _p_ ort_, real_8 _p_ fv1_, int_4 _p_ ierr_)
{
  static int_4 is1_, is2_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _balanc (nm_, n_, a_, &is1_, &is2_, fv1_);
  (void) _orthes (nm_, n_, &is1_, &is2_, a_, ort_);
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _hqr (nm_, n_, &is1_, &is2_, a_, wr_, wi_, ierr_);
  goto _l50;
  _l20:;
  (void) _ortran (nm_, n_, &is1_, &is2_, a_, ort_, z_);
  (void) _hqr2 (nm_, n_, &is1_, &is2_, a_, wr_, wi_, z_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _balbak (nm_, n_, &is1_, &is2_, fv1_, n_, z_);
  _l50:;
  __calls[58].calls++;
  return 0;
}

int_4 _rsb (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ mb_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, 
real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_)
{
  static logical_4 tf_;
  if ((*n_) <= (*nm_)) {
    goto _l5;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l5:;
  if ((*mb_) > 0) {
    goto _l10;
  }
  (*ierr_) = 12 * (*n_);
  goto _l50;
  _l10:;
  if ((*mb_) <= (*n_)) {
    goto _l15;
  }
  (*ierr_) = 12 * (*n_);
  goto _l50;
  _l15:;
  if ((*matz_) != 0) {
    goto _l20;
  }
  tf_ = FALSE;
  (void) _bandr (nm_, n_, mb_, a_, w_, fv1_, fv2_, &tf_, z_);
  (void) _tqlrat (n_, w_, fv2_, ierr_);
  goto _l50;
  _l20:;
  tf_ = TRUE;
  (void) _bandr (nm_, n_, mb_, a_, w_, fv1_, fv1_, &tf_, z_);
  (void) _tql2 (nm_, n_, w_, fv1_, z_, ierr_);
  _l50:;
  __calls[59].calls++;
  return 0;
}

int_4 _rs (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, real_8 _p_ fv1_, 
real_8 _p_ fv2_, int_4 _p_ ierr_)
{
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _tred1 (nm_, n_, a_, w_, fv1_, fv2_);
  (void) _tql1 (n_, w_, fv1_, ierr_);
  goto _l50;
  _l20:;
  (void) _tred2 (nm_, n_, a_, w_, fv1_, z_);
  (void) _tql2 (nm_, n_, w_, fv1_, z_, ierr_);
  _l50:;
  __calls[60].calls++;
  return 0;
}

int_4 _rsgab (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, 
real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_)
{
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _reduc2 (nm_, n_, a_, b_, fv2_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _tred1 (nm_, n_, a_, w_, fv1_, fv2_);
  (void) _tqlrat (n_, w_, fv2_, ierr_);
  goto _l50;
  _l20:;
  (void) _tred2 (nm_, n_, a_, w_, fv1_, z_);
  (void) _tql2 (nm_, n_, w_, fv1_, z_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _rebak (nm_, n_, b_, fv2_, n_, z_);
  _l50:;
  __calls[61].calls++;
  return 0;
}

int_4 _rsgba (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, 
real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_)
{
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _reduc2 (nm_, n_, a_, b_, fv2_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _tred1 (nm_, n_, a_, w_, fv1_, fv2_);
  (void) _tqlrat (n_, w_, fv2_, ierr_);
  goto _l50;
  _l20:;
  (void) _tred2 (nm_, n_, a_, w_, fv1_, z_);
  (void) _tql2 (nm_, n_, w_, fv1_, z_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _rebakb (nm_, n_, b_, fv2_, n_, z_);
  _l50:;
  __calls[62].calls++;
  return 0;
}

int_4 _rsg (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, 
real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_)
{
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  (void) _reduc (nm_, n_, a_, b_, fv2_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _tred1 (nm_, n_, a_, w_, fv1_, fv2_);
  (void) _tqlrat (n_, w_, fv2_, ierr_);
  goto _l50;
  _l20:;
  (void) _tred2 (nm_, n_, a_, w_, fv1_, z_);
  (void) _tql2 (nm_, n_, w_, fv1_, z_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _rebak (nm_, n_, b_, fv2_, n_, z_);
  _l50:;
  __calls[63].calls++;
  return 0;
}

int_4 _rsm (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ m_, real_8 _p_ z_, real_8 _p_ fwork_, 
int_4 _p_ iwork_, int_4 _p_ ierr_)
{
  static int_4 k1_, k2_, k3_, k4_, k5_, k6_, k7_, k8_;
  (*ierr_) = 10 * (*n_);
  if ((*n_) > (*nm_) || (*m_) > (*nm_)) {
    goto _l50;
  }
  k1_ = 1;
  k2_ = k1_ + (*n_);
  k3_ = k2_ + (*n_);
  k4_ = k3_ + (*n_);
  k5_ = k4_ + (*n_);
  k6_ = k5_ + (*n_);
  k7_ = k6_ + (*n_);
  k8_ = k7_ + (*n_);
  if ((*m_) > 0) {
    goto _l10;
  }
  (void) _tred1 (nm_, n_, a_, w_, &fwork_[k1_ - 1], &fwork_[k2_ - 1]);
  (void) _tqlrat (n_, w_, &fwork_[k2_ - 1], ierr_);
  goto _l50;
  _l10:;
  (void) _tred1 (nm_, n_, a_, &fwork_[k1_ - 1], &fwork_[k2_ - 1], &fwork_[k3_ - 1]);
  (void) _imtqlv (n_, &fwork_[k1_ - 1], &fwork_[k2_ - 1], &fwork_[k3_ - 1], w_, iwork_, ierr_, &fwork_[k4_ - 1]);
  (void) _tinvit (nm_, n_, &fwork_[k1_ - 1], &fwork_[k2_ - 1], &fwork_[k3_ - 1], m_, w_, iwork_, z_, ierr_, &fwork_[k4_ - 
  1], &fwork_[k5_ - 1], &fwork_[k6_ - 1], &fwork_[k7_ - 1], &fwork_[k8_ - 1]);
  (void) _trbak1 (nm_, n_, a_, &fwork_[k2_ - 1], m_, z_);
  _l50:;
  __calls[64].calls++;
  return 0;
}

int_4 _rsp (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ nv_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, 
real_8 _p_ fv1_, real_8 _p_ fv2_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  if ((*n_) <= (*nm_)) {
    goto _l5;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l5:;
  if ((*nv_) >= ((*n_) * ((*n_) + 1)) / 2) {
    goto _l10;
  }
  (*ierr_) = 20 * (*n_);
  goto _l50;
  _l10:;
  (void) _tred3 (n_, nv_, a_, w_, fv1_, fv2_);
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _tqlrat (n_, w_, fv2_, ierr_);
  goto _l50;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      z_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
    z_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = 1.0;
  }
  (void) _tql2 (nm_, n_, w_, fv1_, z_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _trbak3 (nm_, n_, nv_, a_, n_, z_);
  _l50:;
  __calls[65].calls++;
  return 0;
}

int_4 _rspp (int_4 _p_ n_, int_4 _p_ nv_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, int_4 _p_ ierr_
, int_4 _p_ m_, logical_4 _p_ type_)
{
  static int_4 idef_;
  static real_8 eps1_;
  int_4 __fcnt, __rc;
  char_1 $0_, $3_;
  char_31 $1_, $2_, $4_, $5_;
  int_4 iwork_[((*n_))];
  real_8 bd_[((*n_))], d_[((*n_))], e_[((*n_))], e2_[((*n_))], work1_[((*n_))], work2_[((*n_))], work3_[((*n_))], 
  work4_[((*n_))], work6_[((*n_))];
  static FORMAT $f_100029_[] = {
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100030_[] = {
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100031_[] = {
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100037_[] = {
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100038_[] = {
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100039_[] = {
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  idef_ = 0;
  (void) _tred3 (n_, nv_, a_, d_, e_, e2_);
  eps1_ = 0.0;
  (void) _ratqr (n_, &eps1_, d_, e_, e2_, m_, w_, iwork_, bd_, type_, &idef_, ierr_);
  if ((*ierr_) != 0) {
    _fcheck ("eispack:rspp:102", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:102", 6));
      __fcnt += 3;
    }
    bufcpy ($0_, _dc_0, 1);
    if ($f_100029_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:102", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100029_[__fcnt + 2], $0_, CHARACTER, 1);
    _write_err (__rc, 6, _ioerr_write ("eispack:rspp:102", 6));
    __fcnt += 3;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      if ($f_100029_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:102", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _fcheck ("eispack:rspp:103", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:103", 6));
      __fcnt += 3;
    }
    bufcpy ($1_, _dc_1, 31);
    if ($f_100030_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:103", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100030_[__fcnt + 2], $1_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("eispack:rspp:103", 6));
    __fcnt += 3;
    while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
      if ($f_100030_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:103", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    _fcheck ("eispack:rspp:104", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:104", 6));
      __fcnt += 3;
    }
    bufcpy ($2_, _dc_2, 31);
    if ($f_100031_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:104", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100031_[__fcnt + 2], $2_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("eispack:rspp:104", 6));
    __fcnt += 3;
    while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
      if ($f_100031_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:104", 6));
      __fcnt += 3;
    }
    _write_eol (6);
    goto _l0;
  }
  if ((*matz_) != 0) {
    (void) _tinvit (n_, n_, d_, e_, e2_, m_, w_, iwork_, z_, ierr_, work1_, work2_, work3_, work4_, work6_);
    if ((*ierr_) != 0) {
      _fcheck ("eispack:rspp:114", 6, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:114", 6));
        __fcnt += 3;
      }
      bufcpy ($3_, _dc_0, 1);
      if ($f_100037_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[6].unit, "\n");
        while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (6, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 6, _ioerr_write ("eispack:rspp:114", 6));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (6, $f_100037_[__fcnt + 2], $3_, CHARACTER, 1);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:114", 6));
      __fcnt += 3;
      while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
        if ($f_100037_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (6, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:114", 6));
        __fcnt += 3;
      }
      _write_eol (6);
      _fcheck ("eispack:rspp:115", 6, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100038_[__fcnt] != NULL && $f_100038_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100038_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:115", 6));
        __fcnt += 3;
      }
      bufcpy ($4_, _dc_1, 31);
      if ($f_100038_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[6].unit, "\n");
        while ($f_100038_[__fcnt] != NULL && $f_100038_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (6, $f_100038_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 6, _ioerr_write ("eispack:rspp:115", 6));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (6, $f_100038_[__fcnt + 2], $4_, CHARACTER, 31);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:115", 6));
      __fcnt += 3;
      while ($f_100038_[__fcnt] != NULL && $f_100038_[__fcnt] == FMT_TEXT) {
        if ($f_100038_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (6, $f_100038_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:115", 6));
        __fcnt += 3;
      }
      _write_eol (6);
      _fcheck ("eispack:rspp:116", 6, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100039_[__fcnt] != NULL && $f_100039_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100039_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:116", 6));
        __fcnt += 3;
      }
      bufcpy ($5_, _dc_3, 31);
      if ($f_100039_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[6].unit, "\n");
        while ($f_100039_[__fcnt] != NULL && $f_100039_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (6, $f_100039_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 6, _ioerr_write ("eispack:rspp:116", 6));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (6, $f_100039_[__fcnt + 2], $5_, CHARACTER, 31);
      _write_err (__rc, 6, _ioerr_write ("eispack:rspp:116", 6));
      __fcnt += 3;
      while ($f_100039_[__fcnt] != NULL && $f_100039_[__fcnt] == FMT_TEXT) {
        if ($f_100039_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (6, $f_100039_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("eispack:rspp:116", 6));
        __fcnt += 3;
      }
      _write_eol (6);
      goto _l0;
    }
    (void) _trbak3 (n_, n_, nv_, a_, m_, z_);
  }
  _l0:;
  __calls[66].calls++;
  return 0;
}

int_4 _rst (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ w_, real_8 _p_ e_, int_4 _p_ matz_, real_8 _p_ z_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _imtql1 (n_, w_, e_, ierr_);
  goto _l50;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      z_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
    z_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = 1.0;
  }
  (void) _imtql2 (nm_, n_, w_, e_, z_, ierr_);
  _l50:;
  __calls[67].calls++;
  return 0;
}

int_4 _rt (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, int_4 _p_ matz_, real_8 _p_ z_, real_8 _p_ fv1_, 
int_4 _p_ ierr_)
{
  if ((*n_) <= (*nm_)) {
    goto _l10;
  }
  (*ierr_) = 10 * (*n_);
  goto _l50;
  _l10:;
  if ((*matz_) != 0) {
    goto _l20;
  }
  (void) _figi (nm_, n_, a_, w_, fv1_, fv1_, ierr_);
  if ((*ierr_) > 0) {
    goto _l50;
  }
  (void) _imtql1 (n_, w_, fv1_, ierr_);
  goto _l50;
  _l20:;
  (void) _figi2 (nm_, n_, a_, w_, fv1_, z_, ierr_);
  if ((*ierr_) != 0) {
    goto _l50;
  }
  (void) _imtql2 (nm_, n_, w_, fv1_, z_, ierr_);
  _l50:;
  __calls[68].calls++;
  return 0;
}

int_4 _sspev (real_4 _p_ a_, int_4 _p_ n_, real_4 _p_ e_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ work_, int_4 _p_ 
job_, int_4 _p_ info_)
{
  static int_4 i_, j_, m_;
  int_4 $0_;
  if ((*n_) > (*ldv_)) {
    (void) _xermsg (_dc_4, _dc_5, _dc_6, &_k1, &_k1);
  }
  if ((*n_) > (*ldv_)) {
    goto _l0;
  }
  if ((*n_) < 1) {
    (void) _xermsg (_dc_4, _dc_5, _dc_7, ($0_ = 2, &$0_), &_k1);
  }
  if ((*n_) < 1) {
    goto _l0;
  }
  e_[0] = a_[0];
  (*info_) = 0;
  if ((*n_) == 1) {
    goto _l0;
  }
  if ((*job_) != 0) {
    goto _l20;
  }
  (void) _tred3 (n_, &_k1, a_, e_, &work_[0], &work_[(*n_) + 1 - 1]);
  (void) _tqlrat (n_, e_, &work_[(*n_) + 1 - 1], info_);
  goto _l0;
  _l20:;
  (void) _tred3 (n_, &_k1, a_, e_, &work_[0], &work_[0]);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      v_[i_ - 1 + ((*ldv_)) * ((j_ - 1))] = 0.0;
    }
    v_[i_ - 1 + ((*ldv_)) * ((i_ - 1))] = 1.0;
  }
  (void) _imtql2 (ldv_, n_, e_, work_, v_, info_);
  m_ = (*n_);
  if ((*info_) != 0) {
    m_ = (*info_) - 1;
  }
  (void) _trbak3 (ldv_, n_, &_k1, a_, &m_, v_);
  _l0:;
  __calls[69].calls++;
  return 0;
}

int_4 _svd (int_4 _p_ nm_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_, logical_4 _p_ matu_, real_8 _p_ u_
, logical_4 _p_ matv_, real_8 _p_ v_, int_4 _p_ ierr_, real_8 _p_ rv1_)
{
  static int_4 i_, j_, k_, l_, ii_, i1_, kk_, k1_, ll_, l1_, mn_, its_;
  static real_8 c_, f_, g_, h_, s_, x_, y_, z_, tst1_, tst2_, scale_;
  real_8 $0_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      u_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
    }
  }
  g_ = 0.0;
  scale_ = 0.0;
  x_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    l_ = i_ + 1;
    rv1_[i_ - 1] = scale_ * g_;
    g_ = 0.0;
    s_ = 0.0;
    scale_ = 0.0;
    if (i_ > (*m_)) {
      goto _l210;
    }
    for (k_ = i_; k_ <= (*m_); (k_)++) {
      scale_ = scale_ + _abs (u_[k_ - 1 + ((*nm_)) * ((i_ - 1))]);
    }
    if (scale_ == 0.0e0) {
      goto _l210;
    }
    for (k_ = i_; k_ <= (*m_); (k_)++) {
      u_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = u_[k_ - 1 + ((*nm_)) * ((i_ - 1))] / scale_;
      s_ = s_ + (u_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * u_[k_ - 1 + ((*nm_)) * ((i_ - 1))]);
    }
    f_ = u_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
    g_ = -_sign (sqrt (s_), f_);
    h_ = f_ * g_ - s_;
    u_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = f_ - g_;
    if (i_ == (*n_)) {
      goto _l190;
    }
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      s_ = 0.0;
      for (k_ = i_; k_ <= (*m_); (k_)++) {
        s_ = s_ + u_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * u_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      f_ = s_ / h_;
      for (k_ = i_; k_ <= (*m_); (k_)++) {
        u_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = u_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + f_ * u_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
    }
    _l190:;
    for (k_ = i_; k_ <= (*m_); (k_)++) {
      u_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = scale_ * u_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
    }
    _l210:;
    w_[i_ - 1] = scale_ * g_;
    g_ = 0.0;
    s_ = 0.0;
    scale_ = 0.0;
    if (i_ > (*m_) || i_ == (*n_)) {
      goto _l290;
    }
    for (k_ = l_; k_ <= (*n_); (k_)++) {
      scale_ = scale_ + _abs (u_[i_ - 1 + ((*nm_)) * ((k_ - 1))]);
    }
    if (scale_ == 0.0e0) {
      goto _l290;
    }
    for (k_ = l_; k_ <= (*n_); (k_)++) {
      u_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = u_[i_ - 1 + ((*nm_)) * ((k_ - 1))] / scale_;
      s_ = s_ + (u_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * u_[i_ - 1 + ((*nm_)) * ((k_ - 1))]);
    }
    f_ = u_[i_ - 1 + ((*nm_)) * ((l_ - 1))];
    g_ = -_sign (sqrt (s_), f_);
    h_ = f_ * g_ - s_;
    u_[i_ - 1 + ((*nm_)) * ((l_ - 1))] = f_ - g_;
    for (k_ = l_; k_ <= (*n_); (k_)++) {
      rv1_[k_ - 1] = u_[i_ - 1 + ((*nm_)) * ((k_ - 1))] / h_;
    }
    if (i_ == (*m_)) {
      goto _l270;
    }
    for (j_ = l_; j_ <= (*m_); (j_)++) {
      s_ = 0.0;
      for (k_ = l_; k_ <= (*n_); (k_)++) {
        s_ = s_ + u_[j_ - 1 + ((*nm_)) * ((k_ - 1))] * u_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
      for (k_ = l_; k_ <= (*n_); (k_)++) {
        u_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = u_[j_ - 1 + ((*nm_)) * ((k_ - 1))] + s_ * rv1_[k_ - 1];
      }
    }
    _l270:;
    for (k_ = l_; k_ <= (*n_); (k_)++) {
      u_[i_ - 1 + ((*nm_)) * ((k_ - 1))] = scale_ * u_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
    }
    _l290:;
    x_ = _max (x_, _abs (w_[i_ - 1]) + _abs (rv1_[i_ - 1]));
  }
  if (! ((*matv_))) {
    goto _l410;
  }
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 1 - ii_;
    if (i_ == (*n_)) {
      goto _l390;
    }
    if (g_ == 0.0e0) {
      goto _l360;
    }
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      v_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = (u_[i_ - 1 + ((*nm_)) * ((j_ - 1))] / u_[i_ - 1 + ((*nm_)) * ((l_ - 1))]) / g_;
    }
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      s_ = 0.0;
      for (k_ = l_; k_ <= (*n_); (k_)++) {
        s_ = s_ + u_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * v_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      for (k_ = l_; k_ <= (*n_); (k_)++) {
        v_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = v_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + s_ * v_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
    }
    _l360:;
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      v_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
      v_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
    _l390:;
    v_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = 1.0;
    g_ = rv1_[i_ - 1];
    l_ = i_;
  }
  _l410:;
  if (! ((*matu_))) {
    goto _l510;
  }
  mn_ = (*n_);
  if ((*m_) < (*n_)) {
    mn_ = (*m_);
  }
  for (ii_ = 1; ii_ <= mn_; (ii_)++) {
    i_ = mn_ + 1 - ii_;
    l_ = i_ + 1;
    g_ = w_[i_ - 1];
    if (i_ == (*n_)) {
      goto _l430;
    }
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      u_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    _l430:;
    if (g_ == 0.0e0) {
      goto _l475;
    }
    if (i_ == mn_) {
      goto _l460;
    }
    for (j_ = l_; j_ <= (*n_); (j_)++) {
      s_ = 0.0;
      for (k_ = l_; k_ <= (*m_); (k_)++) {
        s_ = s_ + u_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * u_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      f_ = (s_ / u_[i_ - 1 + ((*nm_)) * ((i_ - 1))]) / g_;
      for (k_ = i_; k_ <= (*m_); (k_)++) {
        u_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = u_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + f_ * u_[k_ - 1 + ((*nm_)) * ((i_ - 1))];
      }
    }
    _l460:;
    for (j_ = i_; j_ <= (*m_); (j_)++) {
      u_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = u_[j_ - 1 + ((*nm_)) * ((i_ - 1))] / g_;
    }
    goto _l490;
    _l475:;
    for (j_ = i_; j_ <= (*m_); (j_)++) {
      u_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
    _l490:;
    u_[i_ - 1 + ((*nm_)) * ((i_ - 1))] = u_[i_ - 1 + ((*nm_)) * ((i_ - 1))] + 1.0e0;
  }
  _l510:;
  tst1_ = x_;
  for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
    k1_ = (*n_) - kk_;
    k_ = k1_ + 1;
    its_ = 0;
    _l520:;
    for (ll_ = 1; ll_ <= k_; (ll_)++) {
      l1_ = k_ - ll_;
      l_ = l1_ + 1;
      tst2_ = tst1_ + _abs (rv1_[l_ - 1]);
      if (tst2_ == tst1_) {
        goto _l565;
      }
      tst2_ = tst1_ + _abs (w_[l1_ - 1]);
      if (tst2_ == tst1_) {
        goto _l540;
      }
    }
    _l540:;
    c_ = 0.0;
    s_ = 1.0;
    for (i_ = l_; i_ <= k_; (i_)++) {
      f_ = s_ * rv1_[i_ - 1];
      rv1_[i_ - 1] = c_ * rv1_[i_ - 1];
      tst2_ = tst1_ + _abs (f_);
      if (tst2_ == tst1_) {
        goto _l565;
      }
      g_ = w_[i_ - 1];
      h_ = _pythag (&f_, &g_);
      w_[i_ - 1] = h_;
      c_ = g_ / h_;
      s_ = -f_ / h_;
      if (! ((*matu_))) {
        goto _l560;
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        y_ = u_[j_ - 1 + ((*nm_)) * ((l1_ - 1))];
        z_ = u_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
        u_[j_ - 1 + ((*nm_)) * ((l1_ - 1))] = y_ * c_ + z_ * s_;
        u_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = -y_ * s_ + z_ * c_;
      }
      _l560:;
    }
    _l565:;
    z_ = w_[k_ - 1];
    if (l_ == k_) {
      goto _l650;
    }
    if (its_ == 30) {
      goto _l1000;
    }
    its_ = its_ + 1;
    x_ = w_[l_ - 1];
    y_ = w_[k1_ - 1];
    g_ = rv1_[k1_ - 1];
    h_ = rv1_[k_ - 1];
    f_ = 0.5e0 * (((g_ + z_) / h_) * ((g_ - z_) / y_) + y_ / h_ - h_ / y_);
    g_ = _pythag (&f_, ($0_ = 1.0, &$0_));
    f_ = x_ - (z_ / x_) * z_ + (h_ / x_) * (y_ / (f_ + _sign (g_, f_)) - h_);
    c_ = 1.0;
    s_ = 1.0;
    for (i1_ = l_; i1_ <= k1_; (i1_)++) {
      i_ = i1_ + 1;
      g_ = rv1_[i_ - 1];
      y_ = w_[i_ - 1];
      h_ = s_ * g_;
      g_ = c_ * g_;
      z_ = _pythag (&f_, &h_);
      rv1_[i1_ - 1] = z_;
      c_ = f_ / z_;
      s_ = h_ / z_;
      f_ = x_ * c_ + g_ * s_;
      g_ = -x_ * s_ + g_ * c_;
      h_ = y_ * s_;
      y_ = y_ * c_;
      if (! ((*matv_))) {
        goto _l575;
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        x_ = v_[j_ - 1 + ((*nm_)) * ((i1_ - 1))];
        z_ = v_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
        v_[j_ - 1 + ((*nm_)) * ((i1_ - 1))] = x_ * c_ + z_ * s_;
        v_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = -x_ * s_ + z_ * c_;
      }
      _l575:;
      z_ = _pythag (&f_, &h_);
      w_[i1_ - 1] = z_;
      if (z_ == 0.0e0) {
        goto _l580;
      }
      c_ = f_ / z_;
      s_ = h_ / z_;
      _l580:;
      f_ = c_ * g_ + s_ * y_;
      x_ = -s_ * g_ + c_ * y_;
      if (! ((*matu_))) {
        goto _l600;
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        y_ = u_[j_ - 1 + ((*nm_)) * ((i1_ - 1))];
        z_ = u_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
        u_[j_ - 1 + ((*nm_)) * ((i1_ - 1))] = y_ * c_ + z_ * s_;
        u_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = -y_ * s_ + z_ * c_;
      }
      _l600:;
    }
    rv1_[l_ - 1] = 0.0;
    rv1_[k_ - 1] = f_;
    w_[k_ - 1] = x_;
    goto _l520;
    _l650:;
    if (z_ >= 0.0e0) {
      goto _l700;
    }
    w_[k_ - 1] = -z_;
    if (! ((*matv_))) {
      goto _l700;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      v_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = -v_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
    }
    _l700:;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = k_;
  _l1001:;
  __calls[70].calls++;
  return 0;
}

int_4 _tinvit (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, int_4 _p_ m_, real_8 _p_ w_, 
int_4 _p_ ind_, real_8 _p_ z_, int_4 _p_ ierr_, real_8 _p_ rv1_, real_8 _p_ rv2_, real_8 _p_ rv3_, real_8 _p_ rv4_, 
real_8 _p_ rv6_)
{
  static int_4 i_, j_, p_, q_, r_, s_, ii_, ip_, jj_, its_, tag_, group_;
  static real_8 u_, v_, uk_, xu_, x0_, x1_, eps2_, eps3_, eps4_, norm_, order_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  if ((*m_) == 0) {
    goto _l1001;
  }
  tag_ = 0;
  order_ = 1.0e0 - e2_[0];
  q_ = 0;
  _l100:;
  p_ = q_ + 1;
  for (q_ = p_; q_ <= (*n_); (q_)++) {
    if (q_ == (*n_)) {
      goto _l140;
    }
    if (e2_[q_ + 1 - 1] == 0.0e0) {
      goto _l140;
    }
  }
  _l140:;
  tag_ = tag_ + 1;
  s_ = 0;
  for (r_ = 1; r_ <= (*m_); (r_)++) {
    if (ind_[r_ - 1] != tag_) {
      goto _l920;
    }
    its_ = 1;
    x1_ = w_[r_ - 1];
    if (s_ != 0) {
      goto _l510;
    }
    xu_ = 1.0;
    if (p_ != q_) {
      goto _l490;
    }
    rv6_[p_ - 1] = 1.0;
    goto _l870;
    _l490:;
    norm_ = _abs (d_[p_ - 1]);
    ip_ = p_ + 1;
    for (i_ = ip_; i_ <= q_; (i_)++) {
      norm_ = _max (norm_, _abs (d_[i_ - 1]) + _abs (e_[i_ - 1]));
    }
    eps2_ = 1.0e-3 * norm_;
    eps3_ = _epslon (&norm_);
    uk_ = q_ - p_ + 1;
    eps4_ = uk_ * eps3_;
    uk_ = eps4_ / sqrt (uk_);
    s_ = p_;
    _l505:;
    group_ = 0;
    goto _l520;
    _l510:;
    if (_abs (x1_ - x0_) >= eps2_) {
      goto _l505;
    }
    group_ = group_ + 1;
    if (order_ * (x1_ - x0_) <= 0.0e0) {
      x1_ = x0_ + order_ * eps3_;
    }
    _l520:;
    v_ = 0.0;
    for (i_ = p_; i_ <= q_; (i_)++) {
      rv6_[i_ - 1] = uk_;
      if (i_ == p_) {
        goto _l560;
      }
      if (_abs (e_[i_ - 1]) < _abs (u_)) {
        goto _l540;
      }
      xu_ = u_ / e_[i_ - 1];
      rv4_[i_ - 1] = xu_;
      rv1_[i_ - 1 - 1] = e_[i_ - 1];
      rv2_[i_ - 1 - 1] = d_[i_ - 1] - x1_;
      rv3_[i_ - 1 - 1] = 0.0;
      if (i_ != q_) {
        rv3_[i_ - 1 - 1] = e_[i_ + 1 - 1];
      }
      u_ = v_ - xu_ * rv2_[i_ - 1 - 1];
      v_ = -xu_ * rv3_[i_ - 1 - 1];
      goto _l580;
      _l540:;
      xu_ = e_[i_ - 1] / u_;
      rv4_[i_ - 1] = xu_;
      rv1_[i_ - 1 - 1] = u_;
      rv2_[i_ - 1 - 1] = v_;
      rv3_[i_ - 1 - 1] = 0.0;
      _l560:;
      u_ = d_[i_ - 1] - x1_ - xu_ * v_;
      if (i_ != q_) {
        v_ = e_[i_ + 1 - 1];
      }
      _l580:;
    }
    if (u_ == 0.0e0) {
      u_ = eps3_;
    }
    rv1_[q_ - 1] = u_;
    rv2_[q_ - 1] = 0.0;
    rv3_[q_ - 1] = 0.0;
    _l600:;
    for (ii_ = p_; ii_ <= q_; (ii_)++) {
      i_ = p_ + q_ - ii_;
      rv6_[i_ - 1] = (rv6_[i_ - 1] - u_ * rv2_[i_ - 1] - v_ * rv3_[i_ - 1]) / rv1_[i_ - 1];
      v_ = u_;
      u_ = rv6_[i_ - 1];
    }
    if (group_ == 0) {
      goto _l700;
    }
    j_ = r_;
    for (jj_ = 1; jj_ <= group_; (jj_)++) {
      _l630:;
      j_ = j_ - 1;
      if (ind_[j_ - 1] != tag_) {
        goto _l630;
      }
      xu_ = 0.0;
      for (i_ = p_; i_ <= q_; (i_)++) {
        xu_ = xu_ + rv6_[i_ - 1] * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      for (i_ = p_; i_ <= q_; (i_)++) {
        rv6_[i_ - 1] = rv6_[i_ - 1] - xu_ * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
    }
    _l700:;
    norm_ = 0.0;
    for (i_ = p_; i_ <= q_; (i_)++) {
      norm_ = norm_ + _abs (rv6_[i_ - 1]);
    }
    if (norm_ >= 1.0e0) {
      goto _l840;
    }
    if (its_ == 5) {
      goto _l830;
    }
    if (norm_ != 0.0e0) {
      goto _l740;
    }
    rv6_[s_ - 1] = eps4_;
    s_ = s_ + 1;
    if (s_ > q_) {
      s_ = p_;
    }
    goto _l780;
    _l740:;
    xu_ = eps4_ / norm_;
    for (i_ = p_; i_ <= q_; (i_)++) {
      rv6_[i_ - 1] = rv6_[i_ - 1] * xu_;
    }
    _l780:;
    for (i_ = ip_; i_ <= q_; (i_)++) {
      u_ = rv6_[i_ - 1];
      if (rv1_[i_ - 1 - 1] != e_[i_ - 1]) {
        goto _l800;
      }
      u_ = rv6_[i_ - 1 - 1];
      rv6_[i_ - 1 - 1] = rv6_[i_ - 1];
      _l800:;
      rv6_[i_ - 1] = u_ - rv4_[i_ - 1] * rv6_[i_ - 1 - 1];
    }
    its_ = its_ + 1;
    goto _l600;
    _l830:;
    (*ierr_) = -r_;
    xu_ = 0.0;
    goto _l870;
    _l840:;
    u_ = 0.0;
    for (i_ = p_; i_ <= q_; (i_)++) {
      u_ = _pythag (&u_, &rv6_[i_ - 1]);
    }
    xu_ = 1.0e0 / u_;
    _l870:;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((r_ - 1))] = 0.0;
    }
    for (i_ = p_; i_ <= q_; (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((r_ - 1))] = rv6_[i_ - 1] * xu_;
    }
    x0_ = x1_;
    _l920:;
  }
  if (q_ < (*n_)) {
    goto _l100;
  }
  _l1001:;
  __calls[71].calls++;
  return 0;
}

int_4 _tql1 (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, l_, m_, ii_, l1_, l2_, mml_;
  static real_8 c_, c2_, c3_, dl1_, el1_, f_, g_, h_, p_, r_, s_, s2_, tst1_, tst2_;
  real_8 $0_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  if ((*n_) == 1) {
    goto _l1001;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    e_[i_ - 1 - 1] = e_[i_ - 1];
  }
  f_ = 0.0;
  tst1_ = 0.0;
  e_[(*n_) - 1] = 0.0;
  for (l_ = 1; l_ <= (*n_); (l_)++) {
    j_ = 0;
    h_ = _abs (d_[l_ - 1]) + _abs (e_[l_ - 1]);
    if (tst1_ < h_) {
      tst1_ = h_;
    }
    for (m_ = l_; m_ <= (*n_); (m_)++) {
      tst2_ = tst1_ + _abs (e_[m_ - 1]);
      if (tst2_ == tst1_) {
        goto _l120;
      }
    }
    _l120:;
    if (m_ == l_) {
      goto _l210;
    }
    _l130:;
    if (j_ == 30) {
      goto _l1000;
    }
    j_ = j_ + 1;
    l1_ = l_ + 1;
    l2_ = l1_ + 1;
    g_ = d_[l_ - 1];
    p_ = (d_[l1_ - 1] - g_) / (2.0e0 * e_[l_ - 1]);
    r_ = _pythag (&p_, ($0_ = 1.0, &$0_));
    d_[l_ - 1] = e_[l_ - 1] / (p_ + _sign (r_, p_));
    d_[l1_ - 1] = e_[l_ - 1] * (p_ + _sign (r_, p_));
    dl1_ = d_[l1_ - 1];
    h_ = g_ - d_[l_ - 1];
    if (l2_ > (*n_)) {
      goto _l145;
    }
    for (i_ = l2_; i_ <= (*n_); (i_)++) {
      d_[i_ - 1] = d_[i_ - 1] - h_;
    }
    _l145:;
    f_ = f_ + h_;
    p_ = d_[m_ - 1];
    c_ = 1.0;
    c2_ = c_;
    el1_ = e_[l1_ - 1];
    s_ = 0.0;
    mml_ = m_ - l_;
    for (ii_ = 1; ii_ <= mml_; (ii_)++) {
      c3_ = c2_;
      c2_ = c_;
      s2_ = s_;
      i_ = m_ - ii_;
      g_ = c_ * e_[i_ - 1];
      h_ = c_ * p_;
      r_ = _pythag (&p_, &e_[i_ - 1]);
      e_[i_ + 1 - 1] = s_ * r_;
      s_ = e_[i_ - 1] / r_;
      c_ = p_ / r_;
      p_ = c_ * d_[i_ - 1] - s_ * g_;
      d_[i_ + 1 - 1] = h_ + s_ * (c_ * g_ + s_ * d_[i_ - 1]);
    }
    p_ = -s_ * s2_ * c3_ * el1_ * e_[l_ - 1] / dl1_;
    e_[l_ - 1] = s_ * p_;
    d_[l_ - 1] = c_ * p_;
    tst2_ = tst1_ + _abs (e_[l_ - 1]);
    if (tst2_ > tst1_) {
      goto _l130;
    }
    _l210:;
    p_ = d_[l_ - 1] + f_;
    if (l_ == 1) {
      goto _l250;
    }
    for (ii_ = 2; ii_ <= l_; (ii_)++) {
      i_ = l_ + 2 - ii_;
      if (p_ >= d_[i_ - 1 - 1]) {
        goto _l270;
      }
      d_[i_ - 1] = d_[i_ - 1 - 1];
    }
    _l250:;
    i_ = 1;
    _l270:;
    d_[i_ - 1] = p_;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = l_;
  _l1001:;
  __calls[72].calls++;
  return 0;
}

int_4 _tql2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, k_, l_, m_, ii_, l1_, l2_, mml_;
  static real_8 c_, c2_, c3_, dl1_, el1_, f_, g_, h_, p_, r_, s_, s2_, tst1_, tst2_;
  real_8 $0_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  if ((*n_) == 1) {
    goto _l1001;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    e_[i_ - 1 - 1] = e_[i_ - 1];
  }
  f_ = 0.0;
  tst1_ = 0.0;
  e_[(*n_) - 1] = 0.0;
  for (l_ = 1; l_ <= (*n_); (l_)++) {
    j_ = 0;
    h_ = _abs (d_[l_ - 1]) + _abs (e_[l_ - 1]);
    if (tst1_ < h_) {
      tst1_ = h_;
    }
    for (m_ = l_; m_ <= (*n_); (m_)++) {
      tst2_ = tst1_ + _abs (e_[m_ - 1]);
      if (tst2_ == tst1_) {
        goto _l120;
      }
    }
    _l120:;
    if (m_ == l_) {
      goto _l220;
    }
    _l130:;
    if (j_ == 30) {
      goto _l1000;
    }
    j_ = j_ + 1;
    l1_ = l_ + 1;
    l2_ = l1_ + 1;
    g_ = d_[l_ - 1];
    p_ = (d_[l1_ - 1] - g_) / (2.0e0 * e_[l_ - 1]);
    r_ = _pythag (&p_, ($0_ = 1.0, &$0_));
    d_[l_ - 1] = e_[l_ - 1] / (p_ + _sign (r_, p_));
    d_[l1_ - 1] = e_[l_ - 1] * (p_ + _sign (r_, p_));
    dl1_ = d_[l1_ - 1];
    h_ = g_ - d_[l_ - 1];
    if (l2_ > (*n_)) {
      goto _l145;
    }
    for (i_ = l2_; i_ <= (*n_); (i_)++) {
      d_[i_ - 1] = d_[i_ - 1] - h_;
    }
    _l145:;
    f_ = f_ + h_;
    p_ = d_[m_ - 1];
    c_ = 1.0;
    c2_ = c_;
    el1_ = e_[l1_ - 1];
    s_ = 0.0;
    mml_ = m_ - l_;
    for (ii_ = 1; ii_ <= mml_; (ii_)++) {
      c3_ = c2_;
      c2_ = c_;
      s2_ = s_;
      i_ = m_ - ii_;
      g_ = c_ * e_[i_ - 1];
      h_ = c_ * p_;
      r_ = _pythag (&p_, &e_[i_ - 1]);
      e_[i_ + 1 - 1] = s_ * r_;
      s_ = e_[i_ - 1] / r_;
      c_ = p_ / r_;
      p_ = c_ * d_[i_ - 1] - s_ * g_;
      d_[i_ + 1 - 1] = h_ + s_ * (c_ * g_ + s_ * d_[i_ - 1]);
      for (k_ = 1; k_ <= (*n_); (k_)++) {
        h_ = z_[k_ - 1 + ((*nm_)) * ((i_ + 1 - 1))];
        z_[k_ - 1 + ((*nm_)) * ((i_ + 1 - 1))] = s_ * z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] + c_ * h_;
        z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = c_ * z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] - s_ * h_;
      }
    }
    p_ = -s_ * s2_ * c3_ * el1_ * e_[l_ - 1] / dl1_;
    e_[l_ - 1] = s_ * p_;
    d_[l_ - 1] = c_ * p_;
    tst2_ = tst1_ + _abs (e_[l_ - 1]);
    if (tst2_ > tst1_) {
      goto _l130;
    }
    _l220:;
    d_[l_ - 1] = d_[l_ - 1] + f_;
  }
  for (ii_ = 2; ii_ <= (*n_); (ii_)++) {
    i_ = ii_ - 1;
    k_ = i_;
    p_ = d_[i_ - 1];
    for (j_ = ii_; j_ <= (*n_); (j_)++) {
      if (d_[j_ - 1] >= p_) {
        goto _l260;
      }
      k_ = j_;
      p_ = d_[j_ - 1];
      _l260:;
    }
    if (k_ == i_) {
      goto _l300;
    }
    d_[k_ - 1] = d_[i_ - 1];
    d_[i_ - 1] = p_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      p_ = z_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
      z_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = z_[j_ - 1 + ((*nm_)) * ((k_ - 1))];
      z_[j_ - 1 + ((*nm_)) * ((k_ - 1))] = p_;
    }
    _l300:;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = l_;
  _l1001:;
  __calls[73].calls++;
  return 0;
}

int_4 _tqlrat (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e2_, int_4 _p_ ierr_)
{
  static int_4 i_, j_, l_, m_, ii_, l1_, mml_;
  static real_8 b_, c_, f_, g_, h_, p_, r_, s_, t_;
  real_8 $0_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  if ((*n_) == 1) {
    goto _l1001;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    e2_[i_ - 1 - 1] = e2_[i_ - 1];
  }
  f_ = 0.0;
  t_ = 0.0;
  e2_[(*n_) - 1] = 0.0;
  for (l_ = 1; l_ <= (*n_); (l_)++) {
    j_ = 0;
    h_ = _abs (d_[l_ - 1]) + sqrt (e2_[l_ - 1]);
    if (t_ > h_) {
      goto _l105;
    }
    t_ = h_;
    b_ = _epslon (&t_);
    c_ = b_ * b_;
    if (c_ != 0.0e0) {
      goto _l105;
    }
    for (i_ = l_; i_ <= (*n_); (i_)++) {
      h_ = _abs (d_[i_ - 1]) + sqrt (e2_[i_ - 1]);
      if (h_ > t_) {
        t_ = h_;
      }
    }
    b_ = _epslon (&t_);
    c_ = b_ * b_;
    _l105:;
    for (m_ = l_; m_ <= (*n_); (m_)++) {
      if (e2_[m_ - 1] <= c_) {
        goto _l120;
      }
    }
    _l120:;
    if (m_ == l_) {
      goto _l210;
    }
    _l130:;
    if (j_ == 30) {
      goto _l1000;
    }
    j_ = j_ + 1;
    l1_ = l_ + 1;
    s_ = sqrt (e2_[l_ - 1]);
    g_ = d_[l_ - 1];
    p_ = (d_[l1_ - 1] - g_) / (2.0e0 * s_);
    r_ = _pythag (&p_, ($0_ = 1.0, &$0_));
    d_[l_ - 1] = s_ / (p_ + _sign (r_, p_));
    h_ = g_ - d_[l_ - 1];
    for (i_ = l1_; i_ <= (*n_); (i_)++) {
      d_[i_ - 1] = d_[i_ - 1] - h_;
    }
    f_ = f_ + h_;
    g_ = d_[m_ - 1];
    if (g_ == 0.0e0) {
      g_ = b_;
    }
    h_ = g_;
    s_ = 0.0;
    mml_ = m_ - l_;
    for (ii_ = 1; ii_ <= mml_; (ii_)++) {
      i_ = m_ - ii_;
      p_ = g_ * h_;
      r_ = p_ + e2_[i_ - 1];
      e2_[i_ + 1 - 1] = s_ * r_;
      s_ = e2_[i_ - 1] / r_;
      d_[i_ + 1 - 1] = h_ + s_ * (h_ + d_[i_ - 1]);
      g_ = d_[i_ - 1] - e2_[i_ - 1] / g_;
      if (g_ == 0.0e0) {
        g_ = _epslon (&d_[i_ - 1]);
      }
      h_ = g_ * (p_ / r_);
    }
    e2_[l_ - 1] = s_ * g_;
    d_[l_ - 1] = h_;
    if (h_ == 0.0e0) {
      goto _l210;
    }
    if (_abs (e2_[l_ - 1]) <= _abs (c_ / h_)) {
      goto _l210;
    }
    e2_[l_ - 1] = h_ * e2_[l_ - 1];
    if (e2_[l_ - 1] != 0.0e0) {
      goto _l130;
    }
    _l210:;
    p_ = d_[l_ - 1] + f_;
    if (l_ == 1) {
      goto _l250;
    }
    for (ii_ = 2; ii_ <= l_; (ii_)++) {
      i_ = l_ + 2 - ii_;
      if (p_ >= d_[i_ - 1 - 1]) {
        goto _l270;
      }
      d_[i_ - 1] = d_[i_ - 1 - 1];
    }
    _l250:;
    i_ = 1;
    _l270:;
    d_[i_ - 1] = p_;
  }
  goto _l1001;
  _l1000:;
  (*ierr_) = l_;
  _l1001:;
  __calls[74].calls++;
  return 0;
}

int_4 _trbak1 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ e_, int_4 _p_ m_, real_8 _p_ z_)
{
  static int_4 i_, j_, k_, l_;
  static real_8 s_;
  if ((*m_) == 0) {
    goto _l200;
  }
  if ((*n_) == 1) {
    goto _l200;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    l_ = i_ - 1;
    if (e_[i_ - 1] == 0.0e0) {
      goto _l140;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      s_ = 0.0;
      for (k_ = 1; k_ <= l_; (k_)++) {
        s_ = s_ + a_[i_ - 1 + ((*nm_)) * ((k_ - 1))] * z_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      s_ = (s_ / a_[i_ - 1 + ((*nm_)) * ((l_ - 1))]) / e_[i_ - 1];
      for (k_ = 1; k_ <= l_; (k_)++) {
        z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] + s_ * a_[i_ - 1 + ((*nm_)) * ((k_ - 1))];
      }
    }
    _l140:;
  }
  _l200:;
  __calls[75].calls++;
  return 0;
}

int_4 _trbak3 (int_4 _p_ nm_, int_4 _p_ n_, int_4 _p_ nv_, real_8 _p_ a_, int_4 _p_ m_, real_8 _p_ z_)
{
  static int_4 i_, j_, k_, l_, ik_, iz_;
  static real_8 h_, s_;
  if ((*m_) == 0) {
    goto _l200;
  }
  if ((*n_) == 1) {
    goto _l200;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    l_ = i_ - 1;
    iz_ = (i_ * l_) / 2;
    ik_ = iz_ + i_;
    h_ = a_[ik_ - 1];
    if (h_ == 0.0e0) {
      goto _l140;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      s_ = 0.0;
      ik_ = iz_;
      for (k_ = 1; k_ <= l_; (k_)++) {
        ik_ = ik_ + 1;
        s_ = s_ + a_[ik_ - 1] * z_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      s_ = (s_ / h_) / h_;
      ik_ = iz_;
      for (k_ = 1; k_ <= l_; (k_)++) {
        ik_ = ik_ + 1;
        z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - s_ * a_[ik_ - 1];
      }
    }
    _l140:;
  }
  _l200:;
  __calls[76].calls++;
  return 0;
}

int_4 _tred1 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_)
{
  static int_4 i_, j_, k_, l_, ii_, jp1_;
  static real_8 f_, g_, h_, scale_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    d_[i_ - 1] = a_[(*n_) - 1 + ((*nm_)) * ((i_ - 1))];
    a_[(*n_) - 1 + ((*nm_)) * ((i_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((i_ - 1))];
  }
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 1 - ii_;
    l_ = i_ - 1;
    h_ = 0.0;
    scale_ = 0.0;
    if (l_ < 1) {
      goto _l130;
    }
    for (k_ = 1; k_ <= l_; (k_)++) {
      scale_ = scale_ + _abs (d_[k_ - 1]);
    }
    if (scale_ != 0.0e0) {
      goto _l140;
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      d_[j_ - 1] = a_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
      a_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    _l130:;
    e_[i_ - 1] = 0.0;
    e2_[i_ - 1] = 0.0;
    goto _l300;
    _l140:;
    for (k_ = 1; k_ <= l_; (k_)++) {
      d_[k_ - 1] = d_[k_ - 1] / scale_;
      h_ = h_ + d_[k_ - 1] * d_[k_ - 1];
    }
    e2_[i_ - 1] = scale_ * scale_ * h_;
    f_ = d_[l_ - 1];
    g_ = -_sign (sqrt (h_), f_);
    e_[i_ - 1] = scale_ * g_;
    h_ = h_ - f_ * g_;
    d_[l_ - 1] = f_ - g_;
    if (l_ == 1) {
      goto _l285;
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      e_[j_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = d_[j_ - 1];
      g_ = e_[j_ - 1] + a_[j_ - 1 + ((*nm_)) * ((j_ - 1))] * f_;
      jp1_ = j_ + 1;
      if (l_ < jp1_) {
        goto _l220;
      }
      for (k_ = jp1_; k_ <= l_; (k_)++) {
        g_ = g_ + a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * d_[k_ - 1];
        e_[k_ - 1] = e_[k_ - 1] + a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * f_;
      }
      _l220:;
      e_[j_ - 1] = g_;
    }
    f_ = 0.0;
    for (j_ = 1; j_ <= l_; (j_)++) {
      e_[j_ - 1] = e_[j_ - 1] / h_;
      f_ = f_ + e_[j_ - 1] * d_[j_ - 1];
    }
    h_ = f_ / (h_ + h_);
    for (j_ = 1; j_ <= l_; (j_)++) {
      e_[j_ - 1] = e_[j_ - 1] - h_ * d_[j_ - 1];
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = d_[j_ - 1];
      g_ = e_[j_ - 1];
      for (k_ = j_; k_ <= l_; (k_)++) {
        a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - f_ * e_[k_ - 1] - g_ * d_[k_ - 1];
      }
    }
    _l285:;
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = d_[j_ - 1];
      d_[j_ - 1] = a_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
      a_[l_ - 1 + ((*nm_)) * ((j_ - 1))] = a_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      a_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = f_ * scale_;
    }
    _l300:;
  }
  __calls[77].calls++;
  return 0;
}

int_4 _tred2 (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_)
{
  static int_4 i_, j_, k_, l_, ii_, jp1_;
  static real_8 f_, g_, h_, hh_, scale_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      z_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = a_[j_ - 1 + ((*nm_)) * ((i_ - 1))];
    }
    d_[i_ - 1] = a_[(*n_) - 1 + ((*nm_)) * ((i_ - 1))];
  }
  if ((*n_) == 1) {
    goto _l510;
  }
  for (ii_ = 2; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 2 - ii_;
    l_ = i_ - 1;
    h_ = 0.0;
    scale_ = 0.0;
    if (l_ < 2) {
      goto _l130;
    }
    for (k_ = 1; k_ <= l_; (k_)++) {
      scale_ = scale_ + _abs (d_[k_ - 1]);
    }
    if (scale_ != 0.0e0) {
      goto _l140;
    }
    _l130:;
    e_[i_ - 1] = d_[l_ - 1];
    for (j_ = 1; j_ <= l_; (j_)++) {
      d_[j_ - 1] = z_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
      z_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
    goto _l290;
    _l140:;
    for (k_ = 1; k_ <= l_; (k_)++) {
      d_[k_ - 1] = d_[k_ - 1] / scale_;
      h_ = h_ + d_[k_ - 1] * d_[k_ - 1];
    }
    f_ = d_[l_ - 1];
    g_ = -_sign (sqrt (h_), f_);
    e_[i_ - 1] = scale_ * g_;
    h_ = h_ - f_ * g_;
    d_[l_ - 1] = f_ - g_;
    for (j_ = 1; j_ <= l_; (j_)++) {
      e_[j_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = d_[j_ - 1];
      z_[j_ - 1 + ((*nm_)) * ((i_ - 1))] = f_;
      g_ = e_[j_ - 1] + z_[j_ - 1 + ((*nm_)) * ((j_ - 1))] * f_;
      jp1_ = j_ + 1;
      if (l_ < jp1_) {
        goto _l220;
      }
      for (k_ = jp1_; k_ <= l_; (k_)++) {
        g_ = g_ + z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * d_[k_ - 1];
        e_[k_ - 1] = e_[k_ - 1] + z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] * f_;
      }
      _l220:;
      e_[j_ - 1] = g_;
    }
    f_ = 0.0;
    for (j_ = 1; j_ <= l_; (j_)++) {
      e_[j_ - 1] = e_[j_ - 1] / h_;
      f_ = f_ + e_[j_ - 1] * d_[j_ - 1];
    }
    hh_ = f_ / (h_ + h_);
    for (j_ = 1; j_ <= l_; (j_)++) {
      e_[j_ - 1] = e_[j_ - 1] - hh_ * d_[j_ - 1];
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = d_[j_ - 1];
      g_ = e_[j_ - 1];
      for (k_ = j_; k_ <= l_; (k_)++) {
        z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - f_ * e_[k_ - 1] - g_ * d_[k_ - 1];
      }
      d_[j_ - 1] = z_[l_ - 1 + ((*nm_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*nm_)) * ((j_ - 1))] = 0.0;
    }
    _l290:;
    d_[i_ - 1] = h_;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    l_ = i_ - 1;
    z_[(*n_) - 1 + ((*nm_)) * ((l_ - 1))] = z_[l_ - 1 + ((*nm_)) * ((l_ - 1))];
    z_[l_ - 1 + ((*nm_)) * ((l_ - 1))] = 1.0;
    h_ = d_[i_ - 1];
    if (h_ == 0.0e0) {
      goto _l380;
    }
    for (k_ = 1; k_ <= l_; (k_)++) {
      d_[k_ - 1] = z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] / h_;
    }
    for (j_ = 1; j_ <= l_; (j_)++) {
      g_ = 0.0;
      for (k_ = 1; k_ <= l_; (k_)++) {
        g_ = g_ + z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] * z_[k_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      for (k_ = 1; k_ <= l_; (k_)++) {
        z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] = z_[k_ - 1 + ((*nm_)) * ((j_ - 1))] - g_ * d_[k_ - 1];
      }
    }
    _l380:;
    for (k_ = 1; k_ <= l_; (k_)++) {
      z_[k_ - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
    }
  }
  _l510:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    d_[i_ - 1] = z_[(*n_) - 1 + ((*nm_)) * ((i_ - 1))];
    z_[(*n_) - 1 + ((*nm_)) * ((i_ - 1))] = 0.0;
  }
  z_[(*n_) - 1 + ((*nm_)) * (((*n_) - 1))] = 1.0;
  e_[0] = 0.0;
  __calls[78].calls++;
  return 0;
}

int_4 _tred3 (int_4 _p_ n_, int_4 _p_ nv_, real_8 _p_ a_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_)
{
  static int_4 i_, j_, k_, l_, ii_, iz_, jk_, jm1_;
  static real_8 f_, g_, h_, hh_, scale_;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 1 - ii_;
    l_ = i_ - 1;
    iz_ = (i_ * l_) / 2;
    h_ = 0.0;
    scale_ = 0.0;
    if (l_ < 1) {
      goto _l130;
    }
    for (k_ = 1; k_ <= l_; (k_)++) {
      iz_ = iz_ + 1;
      d_[k_ - 1] = a_[iz_ - 1];
      scale_ = scale_ + _abs (d_[k_ - 1]);
    }
    if (scale_ != 0.0e0) {
      goto _l140;
    }
    _l130:;
    e_[i_ - 1] = 0.0;
    e2_[i_ - 1] = 0.0;
    goto _l290;
    _l140:;
    for (k_ = 1; k_ <= l_; (k_)++) {
      d_[k_ - 1] = d_[k_ - 1] / scale_;
      h_ = h_ + d_[k_ - 1] * d_[k_ - 1];
    }
    e2_[i_ - 1] = scale_ * scale_ * h_;
    f_ = d_[l_ - 1];
    g_ = -_sign (sqrt (h_), f_);
    e_[i_ - 1] = scale_ * g_;
    h_ = h_ - f_ * g_;
    d_[l_ - 1] = f_ - g_;
    a_[iz_ - 1] = scale_ * d_[l_ - 1];
    if (l_ == 1) {
      goto _l290;
    }
    jk_ = 1;
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = d_[j_ - 1];
      g_ = 0.0;
      jm1_ = j_ - 1;
      if (jm1_ < 1) {
        goto _l220;
      }
      for (k_ = 1; k_ <= jm1_; (k_)++) {
        g_ = g_ + a_[jk_ - 1] * d_[k_ - 1];
        e_[k_ - 1] = e_[k_ - 1] + a_[jk_ - 1] * f_;
        jk_ = jk_ + 1;
      }
      _l220:;
      e_[j_ - 1] = g_ + a_[jk_ - 1] * f_;
      jk_ = jk_ + 1;
    }
    f_ = 0.0;
    for (j_ = 1; j_ <= l_; (j_)++) {
      e_[j_ - 1] = e_[j_ - 1] / h_;
      f_ = f_ + e_[j_ - 1] * d_[j_ - 1];
    }
    hh_ = f_ / (h_ + h_);
    for (j_ = 1; j_ <= l_; (j_)++) {
      e_[j_ - 1] = e_[j_ - 1] - hh_ * d_[j_ - 1];
    }
    jk_ = 1;
    for (j_ = 1; j_ <= l_; (j_)++) {
      f_ = d_[j_ - 1];
      g_ = e_[j_ - 1];
      for (k_ = 1; k_ <= j_; (k_)++) {
        a_[jk_ - 1] = a_[jk_ - 1] - f_ * e_[k_ - 1] - g_ * d_[k_ - 1];
        jk_ = jk_ + 1;
      }
    }
    _l290:;
    d_[i_ - 1] = a_[iz_ + 1 - 1];
    a_[iz_ + 1 - 1] = scale_ * sqrt (h_);
  }
  __calls[79].calls++;
  return 0;
}

int_4 _tridib (int_4 _p_ n_, real_8 _p_ eps1_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, real_8 _p_ lb_, real_8 _p_ 
ub_, int_4 _p_ m11_, int_4 _p_ m_, real_8 _p_ w_, int_4 _p_ ind_, int_4 _p_ ierr_, real_8 _p_ rv4_, real_8 _p_ rv5_)
{
  static int_4 i_, j_, k_, l_, p_, q_, r_, s_, ii_, m1_, m2_, m22_, tag_, isturm_;
  static real_8 u_, v_, t1_, t2_, xu_, x0_, x1_, tst1_, tst2_;
  int_4 $1_, $2_;
  real_8 $0_, $3_, $4_;
  (*ierr_) = 0;
  tag_ = 0;
  xu_ = d_[0];
  x0_ = d_[0];
  u_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x1_ = u_;
    u_ = 0.0;
    if (i_ != (*n_)) {
      u_ = _abs (e_[i_ + 1 - 1]);
    }
    xu_ = _min (d_[i_ - 1] - (x1_ + u_), xu_);
    x0_ = _max (d_[i_ - 1] + (x1_ + u_), x0_);
    if (i_ == 1) {
      goto _l20;
    }
    tst1_ = _abs (d_[i_ - 1]) + _abs (d_[i_ - 1 - 1]);
    tst2_ = tst1_ + _abs (e_[i_ - 1]);
    if (tst2_ > tst1_) {
      goto _l40;
    }
    _l20:;
    e2_[i_ - 1] = 0.0;
    _l40:;
  }
  x1_ = (*n_);
  x1_ = x1_ * _epslon (($0_ = _max (_abs (xu_), _abs (x0_)), &$0_));
  xu_ = xu_ - x1_;
  t1_ = xu_;
  x0_ = x0_ + x1_;
  t2_ = x0_;
  p_ = 1;
  q_ = (*n_);
  m1_ = (*m11_) - 1;
  if (m1_ == 0) {
    goto _l75;
  }
  isturm_ = 1;
  _l50:;
  v_ = x1_;
  x1_ = xu_ + (x0_ - xu_) * 0.5e0;
  if (x1_ == v_) {
    goto _l980;
  }
  goto _l320;
  _l60:;
  $1_ = s_ - m1_;
  if ($1_ < 0) {
    goto _l65;
  } else if ($1_ == 0) {
    goto _l73;
  } else {
    goto _l70;
  }
  _l65:;
  xu_ = x1_;
  goto _l50;
  _l70:;
  x0_ = x1_;
  goto _l50;
  _l73:;
  xu_ = x1_;
  t1_ = x1_;
  _l75:;
  m22_ = m1_ + (*m_);
  if (m22_ == (*n_)) {
    goto _l90;
  }
  x0_ = t2_;
  isturm_ = 2;
  goto _l50;
  _l80:;
  $2_ = s_ - m22_;
  if ($2_ < 0) {
    goto _l65;
  } else if ($2_ == 0) {
    goto _l85;
  } else {
    goto _l70;
  }
  _l85:;
  t2_ = x1_;
  _l90:;
  q_ = 0;
  r_ = 0;
  _l100:;
  if (r_ == (*m_)) {
    goto _l1001;
  }
  tag_ = tag_ + 1;
  p_ = q_ + 1;
  xu_ = d_[p_ - 1];
  x0_ = d_[p_ - 1];
  u_ = 0.0;
  for (q_ = p_; q_ <= (*n_); (q_)++) {
    x1_ = u_;
    u_ = 0.0;
    v_ = 0.0;
    if (q_ == (*n_)) {
      goto _l110;
    }
    u_ = _abs (e_[q_ + 1 - 1]);
    v_ = e2_[q_ + 1 - 1];
    _l110:;
    xu_ = _min (d_[q_ - 1] - (x1_ + u_), xu_);
    x0_ = _max (d_[q_ - 1] + (x1_ + u_), x0_);
    if (v_ == 0.0e0) {
      goto _l140;
    }
  }
  _l140:;
  x1_ = _epslon (($3_ = _max (_abs (xu_), _abs (x0_)), &$3_));
  if ((*eps1_) <= 0.0e0) {
    (*eps1_) = -x1_;
  }
  if (p_ != q_) {
    goto _l180;
  }
  if (t1_ > d_[p_ - 1] || d_[p_ - 1] >= t2_) {
    goto _l940;
  }
  m1_ = p_;
  m2_ = p_;
  rv5_[p_ - 1] = d_[p_ - 1];
  goto _l900;
  _l180:;
  x1_ = x1_ * (q_ - p_ + 1);
  (*lb_) = _max (t1_, xu_ - x1_);
  (*ub_) = _min (t2_, x0_ + x1_);
  x1_ = (*lb_);
  isturm_ = 3;
  goto _l320;
  _l200:;
  m1_ = s_ + 1;
  x1_ = (*ub_);
  isturm_ = 4;
  goto _l320;
  _l220:;
  m2_ = s_;
  if (m1_ > m2_) {
    goto _l940;
  }
  x0_ = (*ub_);
  isturm_ = 5;
  for (i_ = m1_; i_ <= m2_; (i_)++) {
    rv5_[i_ - 1] = (*ub_);
    rv4_[i_ - 1] = (*lb_);
  }
  k_ = m2_;
  _l250:;
  xu_ = (*lb_);
  for (ii_ = m1_; ii_ <= k_; (ii_)++) {
    i_ = m1_ + k_ - ii_;
    if (xu_ >= rv4_[i_ - 1]) {
      goto _l260;
    }
    xu_ = rv4_[i_ - 1];
    goto _l280;
    _l260:;
  }
  _l280:;
  if (x0_ > rv5_[k_ - 1]) {
    x0_ = rv5_[k_ - 1];
  }
  _l300:;
  x1_ = (xu_ + x0_) * 0.5e0;
  if ((x0_ - xu_) <= _abs ((*eps1_))) {
    goto _l420;
  }
  tst1_ = 2.0e0 * (_abs (xu_) + _abs (x0_));
  tst2_ = tst1_ + (x0_ - xu_);
  if (tst2_ == tst1_) {
    goto _l420;
  }
  _l320:;
  s_ = p_ - 1;
  u_ = 1.0;
  for (i_ = p_; i_ <= q_; (i_)++) {
    if (u_ != 0.0e0) {
      goto _l325;
    }
    v_ = _abs (e_[i_ - 1]) / _epslon (($4_ = 1.0, &$4_));
    if (e2_[i_ - 1] == 0.0e0) {
      v_ = 0.0;
    }
    goto _l330;
    _l325:;
    v_ = e2_[i_ - 1] / u_;
    _l330:;
    u_ = d_[i_ - 1] - x1_ - v_;
    if (u_ < 0.0e0) {
      s_ = s_ + 1;
    }
  }
  switch (isturm_) {
    default:
    case 1: goto _l60;
    case 2: goto _l80;
    case 3: goto _l200;
    case 4: goto _l220;
    case 5: goto _l360;
  }
  _l360:;
  if (s_ >= k_) {
    goto _l400;
  }
  xu_ = x1_;
  if (s_ >= m1_) {
    goto _l380;
  }
  rv4_[m1_ - 1] = x1_;
  goto _l300;
  _l380:;
  rv4_[s_ + 1 - 1] = x1_;
  if (rv5_[s_ - 1] > x1_) {
    rv5_[s_ - 1] = x1_;
  }
  goto _l300;
  _l400:;
  x0_ = x1_;
  goto _l300;
  _l420:;
  rv5_[k_ - 1] = x1_;
  k_ = k_ - 1;
  if (k_ >= m1_) {
    goto _l250;
  }
  _l900:;
  s_ = r_;
  r_ = r_ + m2_ - m1_ + 1;
  j_ = 1;
  k_ = m1_;
  for (l_ = 1; l_ <= r_; (l_)++) {
    if (j_ > s_) {
      goto _l910;
    }
    if (k_ > m2_) {
      goto _l940;
    }
    if (rv5_[k_ - 1] >= w_[l_ - 1]) {
      goto _l915;
    }
    for (ii_ = j_; ii_ <= s_; (ii_)++) {
      i_ = l_ + s_ - ii_;
      w_[i_ + 1 - 1] = w_[i_ - 1];
      ind_[i_ + 1 - 1] = ind_[i_ - 1];
    }
    _l910:;
    w_[l_ - 1] = rv5_[k_ - 1];
    ind_[l_ - 1] = tag_;
    k_ = k_ + 1;
    goto _l920;
    _l915:;
    j_ = j_ + 1;
    _l920:;
  }
  _l940:;
  if (q_ < (*n_)) {
    goto _l100;
  }
  goto _l1001;
  _l980:;
  (*ierr_) = 3 * (*n_) + isturm_;
  _l1001:;
  (*lb_) = t1_;
  (*ub_) = t2_;
  __calls[80].calls++;
  return 0;
}

int_4 _tsturm (int_4 _p_ nm_, int_4 _p_ n_, real_8 _p_ eps1_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ e2_, real_8 _p_ 
lb_, real_8 _p_ ub_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ w_, real_8 _p_ z_, int_4 _p_ ierr_, real_8 _p_ rv1_, 
real_8 _p_ rv2_, real_8 _p_ rv3_, real_8 _p_ rv4_, real_8 _p_ rv5_, real_8 _p_ rv6_)
{
  static int_4 i_, j_, k_, p_, q_, r_, s_, ii_, ip_, jj_, m1_, m2_, its_, group_, isturm_;
  static real_8 u_, v_, t1_, t2_, uk_, xu_, x0_, x1_, eps2_, eps3_, eps4_, norm_, tst1_, tst2_;
  real_8 $0_, $1_;
  extern real_8 _pythag ();
  (*ierr_) = 0;
  t1_ = (*lb_);
  t2_ = (*ub_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (i_ == 1) {
      goto _l20;
    }
    tst1_ = _abs (d_[i_ - 1]) + _abs (d_[i_ - 1 - 1]);
    tst2_ = tst1_ + _abs (e_[i_ - 1]);
    if (tst2_ > tst1_) {
      goto _l40;
    }
    _l20:;
    e2_[i_ - 1] = 0.0;
    _l40:;
  }
  p_ = 1;
  q_ = (*n_);
  x1_ = (*ub_);
  isturm_ = 1;
  goto _l320;
  _l60:;
  (*m_) = s_;
  x1_ = (*lb_);
  isturm_ = 2;
  goto _l320;
  _l80:;
  (*m_) = (*m_) - s_;
  if ((*m_) > (*mm_)) {
    goto _l980;
  }
  q_ = 0;
  r_ = 0;
  _l100:;
  if (r_ == (*m_)) {
    goto _l1001;
  }
  p_ = q_ + 1;
  xu_ = d_[p_ - 1];
  x0_ = d_[p_ - 1];
  u_ = 0.0;
  for (q_ = p_; q_ <= (*n_); (q_)++) {
    x1_ = u_;
    u_ = 0.0;
    v_ = 0.0;
    if (q_ == (*n_)) {
      goto _l110;
    }
    u_ = _abs (e_[q_ + 1 - 1]);
    v_ = e2_[q_ + 1 - 1];
    _l110:;
    xu_ = _min (d_[q_ - 1] - (x1_ + u_), xu_);
    x0_ = _max (d_[q_ - 1] + (x1_ + u_), x0_);
    if (v_ == 0.0e0) {
      goto _l140;
    }
  }
  _l140:;
  x1_ = _epslon (($0_ = _max (_abs (xu_), _abs (x0_)), &$0_));
  if ((*eps1_) <= 0.0e0) {
    (*eps1_) = -x1_;
  }
  if (p_ != q_) {
    goto _l180;
  }
  if (t1_ > d_[p_ - 1] || d_[p_ - 1] >= t2_) {
    goto _l940;
  }
  r_ = r_ + 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    z_[i_ - 1 + ((*nm_)) * ((r_ - 1))] = 0.0;
  }
  w_[r_ - 1] = d_[p_ - 1];
  z_[p_ - 1 + ((*nm_)) * ((r_ - 1))] = 1.0;
  goto _l940;
  _l180:;
  u_ = q_ - p_ + 1;
  x1_ = u_ * x1_;
  (*lb_) = _max (t1_, xu_ - x1_);
  (*ub_) = _min (t2_, x0_ + x1_);
  x1_ = (*lb_);
  isturm_ = 3;
  goto _l320;
  _l200:;
  m1_ = s_ + 1;
  x1_ = (*ub_);
  isturm_ = 4;
  goto _l320;
  _l220:;
  m2_ = s_;
  if (m1_ > m2_) {
    goto _l940;
  }
  x0_ = (*ub_);
  isturm_ = 5;
  for (i_ = m1_; i_ <= m2_; (i_)++) {
    rv5_[i_ - 1] = (*ub_);
    rv4_[i_ - 1] = (*lb_);
  }
  k_ = m2_;
  _l250:;
  xu_ = (*lb_);
  for (ii_ = m1_; ii_ <= k_; (ii_)++) {
    i_ = m1_ + k_ - ii_;
    if (xu_ >= rv4_[i_ - 1]) {
      goto _l260;
    }
    xu_ = rv4_[i_ - 1];
    goto _l280;
    _l260:;
  }
  _l280:;
  if (x0_ > rv5_[k_ - 1]) {
    x0_ = rv5_[k_ - 1];
  }
  _l300:;
  x1_ = (xu_ + x0_) * 0.5e0;
  if ((x0_ - xu_) <= _abs ((*eps1_))) {
    goto _l420;
  }
  tst1_ = 2.0e0 * (_abs (xu_) + _abs (x0_));
  tst2_ = tst1_ + (x0_ - xu_);
  if (tst2_ == tst1_) {
    goto _l420;
  }
  _l320:;
  s_ = p_ - 1;
  u_ = 1.0;
  for (i_ = p_; i_ <= q_; (i_)++) {
    if (u_ != 0.0e0) {
      goto _l325;
    }
    v_ = _abs (e_[i_ - 1]) / _epslon (($1_ = 1.0, &$1_));
    if (e2_[i_ - 1] == 0.0e0) {
      v_ = 0.0;
    }
    goto _l330;
    _l325:;
    v_ = e2_[i_ - 1] / u_;
    _l330:;
    u_ = d_[i_ - 1] - x1_ - v_;
    if (u_ < 0.0e0) {
      s_ = s_ + 1;
    }
  }
  switch (isturm_) {
    default:
    case 1: goto _l60;
    case 2: goto _l80;
    case 3: goto _l200;
    case 4: goto _l220;
    case 5: goto _l360;
  }
  _l360:;
  if (s_ >= k_) {
    goto _l400;
  }
  xu_ = x1_;
  if (s_ >= m1_) {
    goto _l380;
  }
  rv4_[m1_ - 1] = x1_;
  goto _l300;
  _l380:;
  rv4_[s_ + 1 - 1] = x1_;
  if (rv5_[s_ - 1] > x1_) {
    rv5_[s_ - 1] = x1_;
  }
  goto _l300;
  _l400:;
  x0_ = x1_;
  goto _l300;
  _l420:;
  rv5_[k_ - 1] = x1_;
  k_ = k_ - 1;
  if (k_ >= m1_) {
    goto _l250;
  }
  norm_ = _abs (d_[p_ - 1]);
  ip_ = p_ + 1;
  for (i_ = ip_; i_ <= q_; (i_)++) {
    norm_ = _max (norm_, _abs (d_[i_ - 1]) + _abs (e_[i_ - 1]));
  }
  eps2_ = 1.0e-3 * norm_;
  eps3_ = _epslon (&norm_);
  uk_ = q_ - p_ + 1;
  eps4_ = uk_ * eps3_;
  uk_ = eps4_ / sqrt (uk_);
  group_ = 0;
  s_ = p_;
  for (k_ = m1_; k_ <= m2_; (k_)++) {
    r_ = r_ + 1;
    its_ = 1;
    w_[r_ - 1] = rv5_[k_ - 1];
    x1_ = rv5_[k_ - 1];
    if (k_ == m1_) {
      goto _l520;
    }
    if (x1_ - x0_ >= eps2_) {
      group_ = -1;
    }
    group_ = group_ + 1;
    if (x1_ <= x0_) {
      x1_ = x0_ + eps3_;
    }
    _l520:;
    v_ = 0.0;
    for (i_ = p_; i_ <= q_; (i_)++) {
      rv6_[i_ - 1] = uk_;
      if (i_ == p_) {
        goto _l560;
      }
      if (_abs (e_[i_ - 1]) < _abs (u_)) {
        goto _l540;
      }
      xu_ = u_ / e_[i_ - 1];
      rv4_[i_ - 1] = xu_;
      rv1_[i_ - 1 - 1] = e_[i_ - 1];
      rv2_[i_ - 1 - 1] = d_[i_ - 1] - x1_;
      rv3_[i_ - 1 - 1] = 0.0;
      if (i_ != q_) {
        rv3_[i_ - 1 - 1] = e_[i_ + 1 - 1];
      }
      u_ = v_ - xu_ * rv2_[i_ - 1 - 1];
      v_ = -xu_ * rv3_[i_ - 1 - 1];
      goto _l580;
      _l540:;
      xu_ = e_[i_ - 1] / u_;
      rv4_[i_ - 1] = xu_;
      rv1_[i_ - 1 - 1] = u_;
      rv2_[i_ - 1 - 1] = v_;
      rv3_[i_ - 1 - 1] = 0.0;
      _l560:;
      u_ = d_[i_ - 1] - x1_ - xu_ * v_;
      if (i_ != q_) {
        v_ = e_[i_ + 1 - 1];
      }
      _l580:;
    }
    if (u_ == 0.0e0) {
      u_ = eps3_;
    }
    rv1_[q_ - 1] = u_;
    rv2_[q_ - 1] = 0.0;
    rv3_[q_ - 1] = 0.0;
    _l600:;
    for (ii_ = p_; ii_ <= q_; (ii_)++) {
      i_ = p_ + q_ - ii_;
      rv6_[i_ - 1] = (rv6_[i_ - 1] - u_ * rv2_[i_ - 1] - v_ * rv3_[i_ - 1]) / rv1_[i_ - 1];
      v_ = u_;
      u_ = rv6_[i_ - 1];
    }
    if (group_ == 0) {
      goto _l700;
    }
    for (jj_ = 1; jj_ <= group_; (jj_)++) {
      j_ = r_ - group_ - 1 + jj_;
      xu_ = 0.0;
      for (i_ = p_; i_ <= q_; (i_)++) {
        xu_ = xu_ + rv6_[i_ - 1] * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
      for (i_ = p_; i_ <= q_; (i_)++) {
        rv6_[i_ - 1] = rv6_[i_ - 1] - xu_ * z_[i_ - 1 + ((*nm_)) * ((j_ - 1))];
      }
    }
    _l700:;
    norm_ = 0.0;
    for (i_ = p_; i_ <= q_; (i_)++) {
      norm_ = norm_ + _abs (rv6_[i_ - 1]);
    }
    if (norm_ >= 1.0e0) {
      goto _l840;
    }
    if (its_ == 5) {
      goto _l960;
    }
    if (norm_ != 0.0e0) {
      goto _l740;
    }
    rv6_[s_ - 1] = eps4_;
    s_ = s_ + 1;
    if (s_ > q_) {
      s_ = p_;
    }
    goto _l780;
    _l740:;
    xu_ = eps4_ / norm_;
    for (i_ = p_; i_ <= q_; (i_)++) {
      rv6_[i_ - 1] = rv6_[i_ - 1] * xu_;
    }
    _l780:;
    for (i_ = ip_; i_ <= q_; (i_)++) {
      u_ = rv6_[i_ - 1];
      if (rv1_[i_ - 1 - 1] != e_[i_ - 1]) {
        goto _l800;
      }
      u_ = rv6_[i_ - 1 - 1];
      rv6_[i_ - 1 - 1] = rv6_[i_ - 1];
      _l800:;
      rv6_[i_ - 1] = u_ - rv4_[i_ - 1] * rv6_[i_ - 1 - 1];
    }
    its_ = its_ + 1;
    goto _l600;
    _l840:;
    u_ = 0.0;
    for (i_ = p_; i_ <= q_; (i_)++) {
      u_ = _pythag (&u_, &rv6_[i_ - 1]);
    }
    xu_ = 1.0e0 / u_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((r_ - 1))] = 0.0;
    }
    for (i_ = p_; i_ <= q_; (i_)++) {
      z_[i_ - 1 + ((*nm_)) * ((r_ - 1))] = rv6_[i_ - 1] * xu_;
    }
    x0_ = x1_;
  }
  _l940:;
  if (q_ < (*n_)) {
    goto _l100;
  }
  goto _l1001;
  _l960:;
  (*ierr_) = 4 * (*n_) + r_;
  goto _l1001;
  _l980:;
  (*ierr_) = 3 * (*n_) + 1;
  _l1001:;
  (*lb_) = t1_;
  (*ub_) = t2_;
  __calls[81].calls++;
  return 0;
}

