//! @file mathlib-fftpack4.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 68 subprograms from FFTPACK4

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CFFTB  COSQB1 DCOSQF DSINQB DZFFTI PASSB3 PASSF5 RADF3  RFFTF1 SINT
// CFFTB1 COSQF  DCOSQI DSINQF EZFFT1 PASSB4 RADB2  RADF4  RFFTI  SINT1
// CFFTF  COSQF1 DCOST  DSINQI EZFFTB PASSB5 RADB3  RADF5  RFFTI1 SINTI
// CFFTF1 COSQI  DCOSTI DSINT  EZFFTF PASSF  RADB4  RADFG  SINQB  ZFFTB
// CFFTI  COST   DFFTB  DSINTI EZFFTI PASSF2 RADB5  RFFTB  SINQF  ZFFTF
// CFFTI1 COSTI  DFFTF  DZFFTB PASSB  PASSF3 RADBG  RFFTB1 SINQI  ZFFTI
// COSQB  DCOSQB DFFTI  DZFFTF PASSB2 PASSF4 RADF2  RFFTF

// Source: netlib.org/fftpack
// 
// DFFTPACK is a Double precision clone by Hugh C. Pumphrey of 
// FFTPACK version 4 april 1985.
// 
// The original FFTPACK was public domain, so dfftpack is public domain
// too. It is released in the hope it will be useful to someone. There is 
// no warranty of any sort covering this software.

// The license for FFTPACK4 Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
static FORMAT *__fmt_a = NULL;
#define __ncalls 69
static CALLS __calls[__ncalls] = {
  {"cfftb1", 0}, // subroutine
  {"cfftb", 0}, // subroutine
  {"cfftf1", 0}, // subroutine
  {"cfftf", 0}, // subroutine
  {"cffti1", 0}, // subroutine
  {"cffti", 0}, // subroutine
  {"cosqb1", 0}, // subroutine
  {"cosqb", 0}, // subroutine
  {"cosqf1", 0}, // subroutine
  {"cosqf", 0}, // subroutine
  {"cosqi", 0}, // subroutine
  {"cost", 0}, // subroutine
  {"costi", 0}, // subroutine
  {"dcosqb", 0}, // subroutine
  {"dcosqf", 0}, // subroutine
  {"dcosqi", 0}, // subroutine
  {"dcost", 0}, // subroutine
  {"dcosti", 0}, // subroutine
  {"dfftb", 0}, // subroutine
  {"dfftf", 0}, // subroutine
  {"dffti", 0}, // subroutine
  {"dsinqb", 0}, // subroutine
  {"dsinqf", 0}, // subroutine
  {"dsinqi", 0}, // subroutine
  {"dsint", 0}, // subroutine
  {"dsinti", 0}, // subroutine
  {"dzfftb", 0}, // subroutine
  {"dzfftf", 0}, // subroutine
  {"dzffti", 0}, // subroutine
  {"ezfft1", 0}, // subroutine
  {"ezfftb", 0}, // subroutine
  {"ezfftf", 0}, // subroutine
  {"ezffti", 0}, // subroutine
  {"passb2", 0}, // subroutine
  {"passb3", 0}, // subroutine
  {"passb4", 0}, // subroutine
  {"passb5", 0}, // subroutine
  {"passb", 0}, // subroutine
  {"passf2", 0}, // subroutine
  {"passf3", 0}, // subroutine
  {"passf4", 0}, // subroutine
  {"passf5", 0}, // subroutine
  {"passf", 0}, // subroutine
  {"radb2", 0}, // subroutine
  {"radb3", 0}, // subroutine
  {"radb4", 0}, // subroutine
  {"radb5", 0}, // subroutine
  {"radbg", 0}, // subroutine
  {"radf2", 0}, // subroutine
  {"radf3", 0}, // subroutine
  {"radf4", 0}, // subroutine
  {"radf5", 0}, // subroutine
  {"radfg", 0}, // subroutine
  {"rfftb1", 0}, // subroutine
  {"rfftb", 0}, // subroutine
  {"rfftf1", 0}, // subroutine
  {"rfftf", 0}, // subroutine
  {"rffti1", 0}, // subroutine
  {"rffti", 0}, // subroutine
  {"sinqb", 0}, // subroutine
  {"sinqf", 0}, // subroutine
  {"sinqi", 0}, // subroutine
  {"sint1", 0}, // subroutine
  {"sint", 0}, // subroutine
  {"sinti", 0}, // subroutine
  {"zfftb", 0}, // subroutine
  {"zfftf", 0}, // subroutine
  {"zffti", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _cfftb1 (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, int_4 _p_ ifac_);
prototype int_4 _cfftb (int_4 _p_ n_, complex_8 _p_ c_, real_4 _p_ wsave_);
prototype int_4 _cfftf1 (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, int_4 _p_ ifac_);
prototype int_4 _cfftf (int_4 _p_ n_, complex_8 _p_ c_, real_4 _p_ wsave_);
prototype int_4 _cffti1 (int_4 _p_ n_, real_8 _p_ wa_, int_4 _p_ ifac_);
prototype int_4 _cffti (int_4 _p_ n_, real_4 _p_ wsave_);
prototype int_4 _cosqb1 (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ w_, real_8 _p_ xh_);
prototype int_4 _cosqb (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_);
prototype int_4 _cosqf1 (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ w_, real_8 _p_ xh_);
prototype int_4 _cosqf (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_);
prototype int_4 _cosqi (int_4 _p_ n_, real_4 _p_ wsave_);
prototype int_4 _cost (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_);
prototype int_4 _costi (int_4 _p_ n_, real_4 _p_ wsave_);
prototype int_4 _dcosqb (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_);
prototype int_4 _dcosqf (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_);
prototype int_4 _dcosqi (int_4 _p_ n_, real_8 _p_ wsave_);
prototype int_4 _dcost (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_);
prototype int_4 _dcosti (int_4 _p_ n_, real_8 _p_ wsave_);
prototype int_4 _dfftb (int_4 _p_ n_, real_8 _p_ r_, real_8 _p_ wsave_);
prototype int_4 _dfftf (int_4 _p_ n_, real_8 _p_ r_, real_8 _p_ wsave_);
prototype int_4 _dffti (int_4 _p_ n_, real_8 _p_ wsave_);
prototype int_4 _dsinqb (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_);
prototype int_4 _dsinqf (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_);
prototype int_4 _dsinqi (int_4 _p_ n_, real_8 _p_ wsave_);
prototype int_4 _dsint (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_);
prototype int_4 _dsinti (int_4 _p_ n_, real_8 _p_ wsave_);
prototype int_4 _dzfftb (int_4 _p_ n_, real_8 _p_ r_, real_8 _p_ azero_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ 
wsave_);
prototype int_4 _dzfftf (int_4 _p_ n_, real_8 _p_ r_, real_8 _p_ azero_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ 
wsave_);
prototype int_4 _dzffti (int_4 _p_ n_, real_8 _p_ wsave_);
prototype int_4 _ezfft1 (int_4 _p_ n_, real_8 _p_ wa_, int_4 _p_ ifac_);
prototype int_4 _ezfftb (int_4 _p_ n_, real_4 _p_ r_, real_4 _p_ azero_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ 
wsave_);
prototype int_4 _ezfftf (int_4 _p_ n_, real_4 _p_ r_, real_4 _p_ azero_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ 
wsave_);
prototype int_4 _ezffti (int_4 _p_ n_, real_4 _p_ wsave_);
prototype int_4 _passb2 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_);
prototype int_4 _passb3 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ 
wa2_);
prototype int_4 _passb4 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ 
wa2_, real_8 _p_ wa3_);
prototype int_4 _passb5 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ 
wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _passb (int_4 _p_ nac_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, 
real_8 _p_ c1_, real_8 _p_ c2_, real_8 _p_ ch_, real_8 _p_ ch2_, real_8 _p_ wa_);
prototype int_4 _passf2 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_);
prototype int_4 _passf3 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ 
wa2_);
prototype int_4 _passf4 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ 
wa2_, real_8 _p_ wa3_);
prototype int_4 _passf5 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ 
wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _passf (int_4 _p_ nac_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, 
real_8 _p_ c1_, real_8 _p_ c2_, real_8 _p_ ch_, real_8 _p_ ch2_, real_8 _p_ wa_);
prototype int_4 _radb2 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_);
prototype int_4 _radb3 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_
);
prototype int_4 _radb4 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_
, real_8 _p_ wa3_);
prototype int_4 _radb5 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_
, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _radbg (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ c1_, 
real_8 _p_ c2_, real_8 _p_ ch_, real_8 _p_ ch2_, real_8 _p_ wa_);
prototype int_4 _radf2 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_);
prototype int_4 _radf3 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_
);
prototype int_4 _radf4 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_
, real_8 _p_ wa3_);
prototype int_4 _radf5 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_
, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _radfg (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ c1_, 
real_8 _p_ c2_, real_8 _p_ ch_, real_8 _p_ ch2_, real_8 _p_ wa_);
prototype int_4 _rfftb1 (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, int_4 _p_ ifac_);
prototype int_4 _rfftb (int_4 _p_ n_, real_4 _p_ r_, real_4 _p_ wsave_);
prototype int_4 _rfftf1 (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, int_4 _p_ ifac_);
prototype int_4 _rfftf (int_4 _p_ n_, real_4 _p_ r_, real_4 _p_ wsave_);
prototype int_4 _rffti1 (int_4 _p_ n_, real_8 _p_ wa_, int_4 _p_ ifac_);
prototype int_4 _rffti (int_4 _p_ n_, real_4 _p_ wsave_);
prototype int_4 _sinqb (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_);
prototype int_4 _sinqf (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_);
prototype int_4 _sinqi (int_4 _p_ n_, real_4 _p_ wsave_);
prototype int_4 _sint1 (int_4 _p_ n_, real_8 _p_ war_, real_8 _p_ was_, real_8 _p_ xh_, real_8 _p_ x_, int_4 _p_ ifac_)
;
prototype int_4 _sint (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_);
prototype int_4 _sinti (int_4 _p_ n_, real_4 _p_ wsave_);
prototype int_4 _zfftb (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ wsave_);
prototype int_4 _zfftf (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ wsave_);
prototype int_4 _zffti (int_4 _p_ n_, real_8 _p_ wsave_);
int_4 _cfftb1 (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, int_4 _p_ ifac_)
{
  static int_4 nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, idot_, idl1_, ix2_, ix3_, ix4_, nac_, n2_, i_;
  nf_ = ifac_[1];
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = ifac_[k1_ + 2 - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    idot_ = ido_ + ido_;
    idl1_ = idot_ * l1_;
    if (ip_ != 4) {
      goto _l103;
    }
    ix2_ = iw_ + idot_;
    ix3_ = ix2_ + idot_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _passb4 (&idot_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l102;
    _l101:;
    (void) _passb4 (&idot_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    _l102:;
    na_ = 1 - na_;
    goto _l115;
    _l103:;
    if (ip_ != 2) {
      goto _l106;
    }
    if (na_ != 0) {
      goto _l104;
    }
    (void) _passb2 (&idot_, &l1_, c_, ch_, &wa_[iw_ - 1]);
    goto _l105;
    _l104:;
    (void) _passb2 (&idot_, &l1_, ch_, c_, &wa_[iw_ - 1]);
    _l105:;
    na_ = 1 - na_;
    goto _l115;
    _l106:;
    if (ip_ != 3) {
      goto _l109;
    }
    ix2_ = iw_ + idot_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _passb3 (&idot_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l108;
    _l107:;
    (void) _passb3 (&idot_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    _l108:;
    na_ = 1 - na_;
    goto _l115;
    _l109:;
    if (ip_ != 5) {
      goto _l112;
    }
    ix2_ = iw_ + idot_;
    ix3_ = ix2_ + idot_;
    ix4_ = ix3_ + idot_;
    if (na_ != 0) {
      goto _l110;
    }
    (void) _passb5 (&idot_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    goto _l111;
    _l110:;
    (void) _passb5 (&idot_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    _l111:;
    na_ = 1 - na_;
    goto _l115;
    _l112:;
    if (na_ != 0) {
      goto _l113;
    }
    (void) _passb (&nac_, &idot_, &ip_, &l1_, &idl1_, c_, c_, c_, ch_, ch_, &wa_[iw_ - 1]);
    goto _l114;
    _l113:;
    (void) _passb (&nac_, &idot_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, c_, c_, &wa_[iw_ - 1]);
    _l114:;
    if (nac_ != 0) {
      na_ = 1 - na_;
    }
    _l115:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * idot_;
  }
  if (na_ == 0) {
    goto _l0;
  }
  n2_ = (*n_) + (*n_);
  for (i_ = 1; i_ <= n2_; (i_)++) {
    c_[i_ - 1] = ch_[i_ - 1];
  }
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _cfftb (int_4 _p_ n_, complex_8 _p_ c_, real_4 _p_ wsave_)
{
  static int_4 iw1_, iw2_;
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  iw2_ = iw1_ + (*n_) + (*n_);
  (void) _cfftb1 (n_, c_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw2_ - 1]);
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _cfftf1 (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, int_4 _p_ ifac_)
{
  static int_4 nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, idot_, idl1_, ix2_, ix3_, ix4_, nac_, n2_, i_;
  nf_ = ifac_[1];
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = ifac_[k1_ + 2 - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    idot_ = ido_ + ido_;
    idl1_ = idot_ * l1_;
    if (ip_ != 4) {
      goto _l103;
    }
    ix2_ = iw_ + idot_;
    ix3_ = ix2_ + idot_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _passf4 (&idot_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l102;
    _l101:;
    (void) _passf4 (&idot_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    _l102:;
    na_ = 1 - na_;
    goto _l115;
    _l103:;
    if (ip_ != 2) {
      goto _l106;
    }
    if (na_ != 0) {
      goto _l104;
    }
    (void) _passf2 (&idot_, &l1_, c_, ch_, &wa_[iw_ - 1]);
    goto _l105;
    _l104:;
    (void) _passf2 (&idot_, &l1_, ch_, c_, &wa_[iw_ - 1]);
    _l105:;
    na_ = 1 - na_;
    goto _l115;
    _l106:;
    if (ip_ != 3) {
      goto _l109;
    }
    ix2_ = iw_ + idot_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _passf3 (&idot_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l108;
    _l107:;
    (void) _passf3 (&idot_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    _l108:;
    na_ = 1 - na_;
    goto _l115;
    _l109:;
    if (ip_ != 5) {
      goto _l112;
    }
    ix2_ = iw_ + idot_;
    ix3_ = ix2_ + idot_;
    ix4_ = ix3_ + idot_;
    if (na_ != 0) {
      goto _l110;
    }
    (void) _passf5 (&idot_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    goto _l111;
    _l110:;
    (void) _passf5 (&idot_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    _l111:;
    na_ = 1 - na_;
    goto _l115;
    _l112:;
    if (na_ != 0) {
      goto _l113;
    }
    (void) _passf (&nac_, &idot_, &ip_, &l1_, &idl1_, c_, c_, c_, ch_, ch_, &wa_[iw_ - 1]);
    goto _l114;
    _l113:;
    (void) _passf (&nac_, &idot_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, c_, c_, &wa_[iw_ - 1]);
    _l114:;
    if (nac_ != 0) {
      na_ = 1 - na_;
    }
    _l115:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * idot_;
  }
  if (na_ == 0) {
    goto _l0;
  }
  n2_ = (*n_) + (*n_);
  for (i_ = 1; i_ <= n2_; (i_)++) {
    c_[i_ - 1] = ch_[i_ - 1];
  }
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _cfftf (int_4 _p_ n_, complex_8 _p_ c_, real_4 _p_ wsave_)
{
  static int_4 iw1_, iw2_;
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  iw2_ = iw1_ + (*n_) + (*n_);
  (void) _cfftf1 (n_, c_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw2_ - 1]);
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _cffti1 (int_4 _p_ n_, real_8 _p_ wa_, int_4 _p_ ifac_)
{
  static int_4 ntryh_[4], nl_, nf_, j_, ntry_, nq_, nr_, i_, ib_, l1_, k1_, ip_, ld_, l2_, ido_, idot_, ipm_, i1_, ii_;
  static real_8 tpi_, argh_, fi_, argld_, arg_;
  int_4 _data_k_0, $0_, $1_;
#define _data_n_0 4
  static int_4 _data_l_0[_data_n_0] = {
    3,
    4,
    2,
    5
  };
  if (__calls[4].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    ntryh_[0] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    ntryh_[1] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    ntryh_[2] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    ntryh_[3] = _data_l_0[_data_k_0++];
  }
  nl_ = (*n_);
  nf_ = 0;
  j_ = 0;
  _l101:;
  j_ = j_ + 1;
  $0_ = j_ - 4;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ntry_ = ntryh_[j_ - 1];
  goto _l104;
  _l103:;
  ntry_ = ntry_ + 2;
  _l104:;
  nq_ = nl_ / ntry_;
  nr_ = nl_ - ntry_ * nq_;
  $1_ = nr_;
  if ($1_ < 0) {
    goto _l101;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  nf_ = nf_ + 1;
  ifac_[nf_ + 2 - 1] = ntry_;
  nl_ = nq_;
  if (ntry_ != 2) {
    goto _l107;
  }
  if (nf_ == 1) {
    goto _l107;
  }
  for (i_ = 2; i_ <= nf_; (i_)++) {
    ib_ = nf_ - i_ + 2;
    ifac_[ib_ + 2 - 1] = ifac_[ib_ + 1 - 1];
  }
  ifac_[2] = 2;
  _l107:;
  if (nl_ != 1) {
    goto _l104;
  }
  ifac_[0] = (*n_);
  ifac_[1] = nf_;
  tpi_ = 6.2831853071795865;
  argh_ = tpi_ / (real_4) ((*n_));
  i_ = 2;
  l1_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = ifac_[k1_ + 2 - 1];
    ld_ = 0;
    l2_ = l1_ * ip_;
    ido_ = (*n_) / l2_;
    idot_ = ido_ + ido_ + 2;
    ipm_ = ip_ - 1;
    for (j_ = 1; j_ <= ipm_; (j_)++) {
      i1_ = i_;
      wa_[i_ - 1 - 1] = 1.0;
      wa_[i_ - 1] = 0.0;
      ld_ = ld_ + l1_;
      fi_ = 0.0;
      argld_ = (real_4) (ld_) * argh_;
      for (ii_ = 4; (2 > 0 ? ii_ <= idot_ : ii_ >= idot_); ii_ += 2) {
        i_ = i_ + 2;
        fi_ = fi_ + 1.0e0;
        arg_ = fi_ * argld_;
        wa_[i_ - 1 - 1] = cos (arg_);
        wa_[i_ - 1] = sin (arg_);
      }
      if (ip_ <= 5) {
        goto _l109;
      }
      wa_[i1_ - 1 - 1] = wa_[i_ - 1 - 1];
      wa_[i1_ - 1] = wa_[i_ - 1];
      _l109:;
    }
    l1_ = l2_;
  }
  __calls[4].calls++;
  return 0;
}

int_4 _cffti (int_4 _p_ n_, real_4 _p_ wsave_)
{
  static int_4 iw1_, iw2_;
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  iw2_ = iw1_ + (*n_) + (*n_);
  (void) _cffti1 (n_, &wsave_[iw1_ - 1], &wsave_[iw2_ - 1]);
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _cosqb1 (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ w_, real_8 _p_ xh_)
{
  static int_4 ns2_, np2_, i_, modn_, k_, kc_;
  static real_8 xim1_;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xim1_ = x_[i_ - 1 - 1] + x_[i_ - 1];
    x_[i_ - 1] = x_[i_ - 1] - x_[i_ - 1 - 1];
    x_[i_ - 1 - 1] = xim1_;
  }
  x_[0] = x_[0] + x_[0];
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    x_[(*n_) - 1] = x_[(*n_) - 1] + x_[(*n_) - 1];
  }
  (void) _dfftb (n_, x_, xh_);
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    xh_[k_ - 1] = w_[k_ - 1 - 1] * x_[kc_ - 1] + w_[kc_ - 1 - 1] * x_[k_ - 1];
    xh_[kc_ - 1] = w_[k_ - 1 - 1] * x_[k_ - 1] - w_[kc_ - 1 - 1] * x_[kc_ - 1];
  }
  if (modn_ == 0) {
    x_[ns2_ + 1 - 1] = w_[ns2_ - 1] * (x_[ns2_ + 1 - 1] + x_[ns2_ + 1 - 1]);
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    x_[k_ - 1] = xh_[k_ - 1] + xh_[kc_ - 1];
    x_[kc_ - 1] = xh_[k_ - 1] - xh_[kc_ - 1];
  }
  x_[0] = x_[0] + x_[0];
  __calls[6].calls++;
  return 0;
}

int_4 _cosqb (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_)
{
  static real_4 tsqrt2_, x1_;
  int_4 $0_;
  tsqrt2_ = 2.8284271;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  x_[0] = 4.0 * x_[0];
  goto _l0;
  _l102:;
  x1_ = 4.0 * (x_[0] + x_[1]);
  x_[1] = tsqrt2_ * (x_[0] - x_[1]);
  x_[0] = x1_;
  goto _l0;
  _l103:;
  (void) _cosqb1 (n_, x_, wsave_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[7].calls++;
  return 0;
}

int_4 _cosqf1 (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ w_, real_8 _p_ xh_)
{
  static int_4 ns2_, np2_, k_, kc_, modn_, i_;
  static real_8 xim1_;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    xh_[k_ - 1] = x_[k_ - 1] + x_[kc_ - 1];
    xh_[kc_ - 1] = x_[k_ - 1] - x_[kc_ - 1];
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    xh_[ns2_ + 1 - 1] = x_[ns2_ + 1 - 1] + x_[ns2_ + 1 - 1];
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    x_[k_ - 1] = w_[k_ - 1 - 1] * xh_[kc_ - 1] + w_[kc_ - 1 - 1] * xh_[k_ - 1];
    x_[kc_ - 1] = w_[k_ - 1 - 1] * xh_[k_ - 1] - w_[kc_ - 1 - 1] * xh_[kc_ - 1];
  }
  if (modn_ == 0) {
    x_[ns2_ + 1 - 1] = w_[ns2_ - 1] * xh_[ns2_ + 1 - 1];
  }
  (void) _dfftf (n_, x_, xh_);
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xim1_ = x_[i_ - 1 - 1] - x_[i_ - 1];
    x_[i_ - 1] = x_[i_ - 1 - 1] + x_[i_ - 1];
    x_[i_ - 1 - 1] = xim1_;
  }
  __calls[8].calls++;
  return 0;
}

int_4 _cosqf (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_)
{
  static real_4 sqrt2_, tsqx_;
  int_4 $0_;
  sqrt2_ = 1.4142136;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l103;
  }
  _l101:;
  tsqx_ = sqrt2_ * x_[1];
  x_[1] = x_[0] - tsqx_;
  x_[0] = x_[0] + tsqx_;
  _l102:;
  goto _l0;
  _l103:;
  (void) _cosqf1 (n_, x_, wsave_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[9].calls++;
  return 0;
}

int_4 _cosqi (int_4 _p_ n_, real_4 _p_ wsave_)
{
  static int_4 k_;
  static real_4 pih_, dt_, fk_;
  pih_ = 1.5707963;
  dt_ = pih_ / (*n_);
  fk_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = cosf (fk_ * dt_);
  }
  (void) _rffti (n_, &wsave_[(*n_) + 1 - 1]);
  __calls[10].calls++;
  return 0;
}

int_4 _cost (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, modn_, i_;
  static real_4 x1h_, x1p3_, tx2_, c1_, t1_, t2_, xim2_, xi_;
  int_4 $0_;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l106;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  x1h_ = x_[0] + x_[1];
  x_[1] = x_[0] - x_[1];
  x_[0] = x1h_;
  goto _l0;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  x1p3_ = x_[0] + x_[2];
  tx2_ = x_[1] + x_[1];
  x_[1] = x_[0] - x_[2];
  x_[0] = x1p3_ + tx2_;
  x_[2] = x1p3_ - tx2_;
  goto _l0;
  _l103:;
  c1_ = x_[0] - x_[(*n_) - 1];
  x_[0] = x_[0] + x_[(*n_) - 1];
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = x_[k_ - 1] + x_[kc_ - 1];
    t2_ = x_[k_ - 1] - x_[kc_ - 1];
    c1_ = c1_ + wsave_[kc_ - 1] * t2_;
    t2_ = wsave_[k_ - 1] * t2_;
    x_[k_ - 1] = t1_ - t2_;
    x_[kc_ - 1] = t1_ + t2_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    x_[ns2_ + 1 - 1] = x_[ns2_ + 1 - 1] + x_[ns2_ + 1 - 1];
  }
  (void) _rfftf (&nm1_, x_, &wsave_[(*n_) + 1 - 1]);
  xim2_ = x_[1];
  x_[1] = c1_;
  for (i_ = 4; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xi_ = x_[i_ - 1];
    x_[i_ - 1] = x_[i_ - 2 - 1] - x_[i_ - 1 - 1];
    x_[i_ - 1 - 1] = xim2_;
    xim2_ = xi_;
  }
  if (modn_ != 0) {
    x_[(*n_) - 1] = xim2_;
  }
  _l106:;
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _costi (int_4 _p_ n_, real_4 _p_ wsave_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_;
  static real_4 pi_, dt_, fk_;
  if ((*n_) <= 3) {
    goto _l0;
  }
  pi_ = 3.1415927;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  dt_ = pi_ / nm1_;
  fk_ = 0.0;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = 2.0 * sinf (fk_ * dt_);
    wsave_[kc_ - 1] = 2.0 * cosf (fk_ * dt_);
  }
  (void) _rffti (&nm1_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _dcosqb (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_)
{
  static real_8 tsqrt2_, x1_;
  int_4 _data_k_1, $0_;
#define _data_n_1 1
  static real_8 _data_l_1[_data_n_1] = {
    2.8284271247461900976e0
  };
  if (__calls[13].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    tsqrt2_ = _data_l_1[_data_k_1++];
  }
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  x_[0] = 4.0e0 * x_[0];
  goto _l0;
  _l102:;
  x1_ = 4.0e0 * (x_[0] + x_[1]);
  x_[1] = tsqrt2_ * (x_[0] - x_[1]);
  x_[0] = x1_;
  goto _l0;
  _l103:;
  (void) _cosqb1 (n_, x_, wsave_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[13].calls++;
  return 0;
}

int_4 _dcosqf (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_)
{
  static real_8 sqrt2_, tsqx_;
  int_4 _data_k_2, $0_;
#define _data_n_2 1
  static real_8 _data_l_2[_data_n_2] = {
    1.4142135623730950488e0
  };
  if (__calls[14].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    sqrt2_ = _data_l_2[_data_k_2++];
  }
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l103;
  }
  _l101:;
  tsqx_ = sqrt2_ * x_[1];
  x_[1] = x_[0] - tsqx_;
  x_[0] = x_[0] + tsqx_;
  _l102:;
  goto _l0;
  _l103:;
  (void) _cosqf1 (n_, x_, wsave_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _dcosqi (int_4 _p_ n_, real_8 _p_ wsave_)
{
  static int_4 k_;
  static real_8 pih_, dt_, fk_;
  int_4 _data_k_3;
#define _data_n_3 1
  static real_8 _data_l_3[_data_n_3] = {
    1.57079632679489661923e0
  };
  if (__calls[15].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    pih_ = _data_l_3[_data_k_3++];
  }
  dt_ = pih_ / (real_4) ((*n_));
  fk_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    fk_ = fk_ + 1.0e0;
    wsave_[k_ - 1] = cos (fk_ * dt_);
  }
  (void) _dffti (n_, &wsave_[(*n_) + 1 - 1]);
  __calls[15].calls++;
  return 0;
}

int_4 _dcost (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, modn_, i_;
  static real_8 x1h_, x1p3_, tx2_, c1_, t1_, t2_, xim2_, xi_;
  int_4 $0_;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l106;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  x1h_ = x_[0] + x_[1];
  x_[1] = x_[0] - x_[1];
  x_[0] = x1h_;
  goto _l0;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  x1p3_ = x_[0] + x_[2];
  tx2_ = x_[1] + x_[1];
  x_[1] = x_[0] - x_[2];
  x_[0] = x1p3_ + tx2_;
  x_[2] = x1p3_ - tx2_;
  goto _l0;
  _l103:;
  c1_ = x_[0] - x_[(*n_) - 1];
  x_[0] = x_[0] + x_[(*n_) - 1];
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = x_[k_ - 1] + x_[kc_ - 1];
    t2_ = x_[k_ - 1] - x_[kc_ - 1];
    c1_ = c1_ + wsave_[kc_ - 1] * t2_;
    t2_ = wsave_[k_ - 1] * t2_;
    x_[k_ - 1] = t1_ - t2_;
    x_[kc_ - 1] = t1_ + t2_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    x_[ns2_ + 1 - 1] = x_[ns2_ + 1 - 1] + x_[ns2_ + 1 - 1];
  }
  (void) _dfftf (&nm1_, x_, &wsave_[(*n_) + 1 - 1]);
  xim2_ = x_[1];
  x_[1] = c1_;
  for (i_ = 4; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xi_ = x_[i_ - 1];
    x_[i_ - 1] = x_[i_ - 2 - 1] - x_[i_ - 1 - 1];
    x_[i_ - 1 - 1] = xim2_;
    xim2_ = xi_;
  }
  if (modn_ != 0) {
    x_[(*n_) - 1] = xim2_;
  }
  _l106:;
  _l0:;
  __calls[16].calls++;
  return 0;
}

int_4 _dcosti (int_4 _p_ n_, real_8 _p_ wsave_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_;
  static real_8 pi_, dt_, fk_;
  int_4 _data_k_4;
#define _data_n_4 1
  static real_8 _data_l_4[_data_n_4] = {
    3.14159265358979323846e0
  };
  if (__calls[17].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    pi_ = _data_l_4[_data_k_4++];
  }
  if ((*n_) <= 3) {
    goto _l0;
  }
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  dt_ = pi_ / (real_4) (nm1_);
  fk_ = 0.0;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    fk_ = fk_ + 1.0e0;
    wsave_[k_ - 1] = 2.0e0 * sin (fk_ * dt_);
    wsave_[kc_ - 1] = 2.0e0 * cos (fk_ * dt_);
  }
  (void) _dffti (&nm1_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _dfftb (int_4 _p_ n_, real_8 _p_ r_, real_8 _p_ wsave_)
{
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _rfftb1 (n_, r_, wsave_, &wsave_[(*n_) + 1 - 1], &wsave_[2 * (*n_) + 1 - 1]);
  _l0:;
  __calls[18].calls++;
  return 0;
}

int_4 _dfftf (int_4 _p_ n_, real_8 _p_ r_, real_8 _p_ wsave_)
{
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _rfftf1 (n_, r_, wsave_, &wsave_[(*n_) + 1 - 1], &wsave_[2 * (*n_) + 1 - 1]);
  _l0:;
  __calls[19].calls++;
  return 0;
}

int_4 _dffti (int_4 _p_ n_, real_8 _p_ wsave_)
{
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _rffti1 (n_, &wsave_[(*n_) + 1 - 1], &wsave_[2 * (*n_) + 1 - 1]);
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _dsinqb (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_)
{
  static int_4 ns2_, k_, kc_;
  static real_8 xhold_;
  if ((*n_) > 1) {
    goto _l101;
  }
  x_[0] = 4.0e0 * x_[0];
  goto _l0;
  _l101:;
  ns2_ = (*n_) / 2;
  for (k_ = 2; (2 > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += 2) {
    x_[k_ - 1] = -x_[k_ - 1];
  }
  (void) _dcosqb (n_, x_, wsave_);
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = (*n_) - k_;
    xhold_ = x_[k_ - 1];
    x_[k_ - 1] = x_[kc_ + 1 - 1];
    x_[kc_ + 1 - 1] = xhold_;
  }
  _l0:;
  __calls[21].calls++;
  return 0;
}

int_4 _dsinqf (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_)
{
  static int_4 ns2_, k_, kc_;
  static real_8 xhold_;
  if ((*n_) == 1) {
    goto _l0;
  }
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = (*n_) - k_;
    xhold_ = x_[k_ - 1];
    x_[k_ - 1] = x_[kc_ + 1 - 1];
    x_[kc_ + 1 - 1] = xhold_;
  }
  (void) _dcosqf (n_, x_, wsave_);
  for (k_ = 2; (2 > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += 2) {
    x_[k_ - 1] = -x_[k_ - 1];
  }
  _l0:;
  __calls[22].calls++;
  return 0;
}

int_4 _dsinqi (int_4 _p_ n_, real_8 _p_ wsave_)
{
  (void) _dcosqi (n_, wsave_);
  __calls[23].calls++;
  return 0;
}

int_4 _dsint (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ wsave_)
{
  static int_4 np1_, iw1_, iw2_, iw3_;
  np1_ = (*n_) + 1;
  iw1_ = (*n_) / 2 + 1;
  iw2_ = iw1_ + np1_;
  iw3_ = iw2_ + np1_;
  (void) _sint1 (n_, x_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw2_ - 1], &wsave_[iw3_ - 1]);
  __calls[24].calls++;
  return 0;
}

int_4 _dsinti (int_4 _p_ n_, real_8 _p_ wsave_)
{
  static int_4 ns2_, np1_, k_;
  static real_8 pi_, dt_;
  int_4 _data_k_5;
#define _data_n_5 1
  static real_8 _data_l_5[_data_n_5] = {
    3.14159265358979323846e0
  };
  if (__calls[25].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    pi_ = _data_l_5[_data_k_5++];
  }
  if ((*n_) <= 1) {
    goto _l0;
  }
  ns2_ = (*n_) / 2;
  np1_ = (*n_) + 1;
  dt_ = pi_ / (real_4) (np1_);
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    wsave_[k_ - 1] = 2.0e0 * sin (k_ * dt_);
  }
  (void) _dffti (&np1_, &wsave_[ns2_ + 1 - 1]);
  _l0:;
  __calls[25].calls++;
  return 0;
}

int_4 _dzfftb (int_4 _p_ n_, real_8 _p_ r_, real_8 _p_ azero_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ wsave_)
{
  static int_4 ns2_, i_;
  int_4 $0_;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  r_[0] = (*azero_);
  goto _l0;
  _l102:;
  r_[0] = (*azero_) + a_[0];
  r_[1] = (*azero_) - a_[0];
  goto _l0;
  _l103:;
  ns2_ = ((*n_) - 1) / 2;
  for (i_ = 1; i_ <= ns2_; (i_)++) {
    r_[2 * i_ - 1] = 0.5e0 * a_[i_ - 1];
    r_[2 * i_ + 1 - 1] = -0.5e0 * b_[i_ - 1];
  }
  r_[0] = (*azero_);
  if (_imod ((*n_), 2) == 0) {
    r_[(*n_) - 1] = a_[ns2_ + 1 - 1];
  }
  (void) _dfftb (n_, r_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _dzfftf (int_4 _p_ n_, real_8 _p_ r_, real_8 _p_ azero_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ wsave_)
{
  static int_4 i_, ns2_, ns2m_;
  static real_8 cf_, cfm_;
  int_4 $0_;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  (*azero_) = r_[0];
  goto _l0;
  _l102:;
  (*azero_) = 0.5e0 * (r_[0] + r_[1]);
  a_[0] = 0.5e0 * (r_[0] - r_[1]);
  goto _l0;
  _l103:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    wsave_[i_ - 1] = r_[i_ - 1];
  }
  (void) _dfftf (n_, wsave_, &wsave_[(*n_) + 1 - 1]);
  cf_ = 2.0e0 / (real_4) ((*n_));
  cfm_ = -cf_;
  (*azero_) = 0.5e0 * cf_ * wsave_[0];
  ns2_ = ((*n_) + 1) / 2;
  ns2m_ = ns2_ - 1;
  for (i_ = 1; i_ <= ns2m_; (i_)++) {
    a_[i_ - 1] = cf_ * wsave_[2 * i_ - 1];
    b_[i_ - 1] = cfm_ * wsave_[2 * i_ + 1 - 1];
  }
  if (_imod ((*n_), 2) == 1) {
    goto _l0;
  }
  a_[ns2_ - 1] = 0.5e0 * cf_ * wsave_[(*n_) - 1];
  b_[ns2_ - 1] = 0.0;
  _l0:;
  __calls[27].calls++;
  return 0;
}

int_4 _dzffti (int_4 _p_ n_, real_8 _p_ wsave_)
{
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _ezfft1 (n_, &wsave_[2 * (*n_) + 1 - 1], &wsave_[3 * (*n_) + 1 - 1]);
  _l0:;
  __calls[28].calls++;
  return 0;
}

int_4 _ezfft1 (int_4 _p_ n_, real_8 _p_ wa_, int_4 _p_ ifac_)
{
  static int_4 ntryh_[4], nl_, nf_, j_, ntry_, nq_, nr_, i_, ib_, is_, nfm1_, l1_, k1_, ip_, l2_, ido_, ipm_, ii_;
  static real_8 tpi_, argh_, arg1_, ch1_, sh1_, dch1_, dsh1_, ch1h_;
  int_4 _data_k_6, _data_k_7, $0_, $1_;
#define _data_n_6 4
  static int_4 _data_l_6[_data_n_6] = {
    4,
    2,
    3,
    5
  };
#define _data_n_7 1
  static real_8 _data_l_7[_data_n_7] = {
    6.28318530717958647692e0
  };
  if (__calls[29].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ntryh_[0] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ntryh_[1] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ntryh_[2] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ntryh_[3] = _data_l_6[_data_k_6++];
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    tpi_ = _data_l_7[_data_k_7++];
  }
  nl_ = (*n_);
  nf_ = 0;
  j_ = 0;
  _l101:;
  j_ = j_ + 1;
  $0_ = j_ - 4;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ntry_ = ntryh_[j_ - 1];
  goto _l104;
  _l103:;
  ntry_ = ntry_ + 2;
  _l104:;
  nq_ = nl_ / ntry_;
  nr_ = nl_ - ntry_ * nq_;
  $1_ = nr_;
  if ($1_ < 0) {
    goto _l101;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  nf_ = nf_ + 1;
  ifac_[nf_ + 2 - 1] = ntry_;
  nl_ = nq_;
  if (ntry_ != 2) {
    goto _l107;
  }
  if (nf_ == 1) {
    goto _l107;
  }
  for (i_ = 2; i_ <= nf_; (i_)++) {
    ib_ = nf_ - i_ + 2;
    ifac_[ib_ + 2 - 1] = ifac_[ib_ + 1 - 1];
  }
  ifac_[2] = 2;
  _l107:;
  if (nl_ != 1) {
    goto _l104;
  }
  ifac_[0] = (*n_);
  ifac_[1] = nf_;
  argh_ = tpi_ / (real_4) ((*n_));
  is_ = 0;
  nfm1_ = nf_ - 1;
  l1_ = 1;
  if (nfm1_ == 0) {
    goto _l0;
  }
  for (k1_ = 1; k1_ <= nfm1_; (k1_)++) {
    ip_ = ifac_[k1_ + 2 - 1];
    l2_ = l1_ * ip_;
    ido_ = (*n_) / l2_;
    ipm_ = ip_ - 1;
    arg1_ = (real_4) (l1_) * argh_;
    ch1_ = 1.0;
    sh1_ = 0.0;
    dch1_ = cos (arg1_);
    dsh1_ = sin (arg1_);
    for (j_ = 1; j_ <= ipm_; (j_)++) {
      ch1h_ = dch1_ * ch1_ - dsh1_ * sh1_;
      sh1_ = dch1_ * sh1_ + dsh1_ * ch1_;
      ch1_ = ch1h_;
      i_ = is_ + 2;
      wa_[i_ - 1 - 1] = ch1_;
      wa_[i_ - 1] = sh1_;
      if (ido_ < 5) {
        goto _l109;
      }
      for (ii_ = 5; (2 > 0 ? ii_ <= ido_ : ii_ >= ido_); ii_ += 2) {
        i_ = i_ + 2;
        wa_[i_ - 1 - 1] = ch1_ * wa_[i_ - 3 - 1] - sh1_ * wa_[i_ - 2 - 1];
        wa_[i_ - 1] = ch1_ * wa_[i_ - 2 - 1] + sh1_ * wa_[i_ - 3 - 1];
      }
      _l109:;
      is_ = is_ + ido_;
    }
    l1_ = l2_;
  }
  _l0:;
  __calls[29].calls++;
  return 0;
}

int_4 _ezfftb (int_4 _p_ n_, real_4 _p_ r_, real_4 _p_ azero_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ wsave_)
{
  static int_4 ns2_, i_;
  int_4 $0_;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  r_[0] = (*azero_);
  goto _l0;
  _l102:;
  r_[0] = (*azero_) + a_[0];
  r_[1] = (*azero_) - a_[0];
  goto _l0;
  _l103:;
  ns2_ = ((*n_) - 1) / 2;
  for (i_ = 1; i_ <= ns2_; (i_)++) {
    r_[2 * i_ - 1] = .5 * a_[i_ - 1];
    r_[2 * i_ + 1 - 1] = -.5 * b_[i_ - 1];
  }
  r_[0] = (*azero_);
  if (_imod ((*n_), 2) == 0) {
    r_[(*n_) - 1] = a_[ns2_ + 1 - 1];
  }
  (void) _rfftb (n_, r_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[30].calls++;
  return 0;
}

int_4 _ezfftf (int_4 _p_ n_, real_4 _p_ r_, real_4 _p_ azero_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ wsave_)
{
  static int_4 i_, ns2_, ns2m_;
  static real_4 cf_, cfm_;
  int_4 $0_;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  (*azero_) = r_[0];
  goto _l0;
  _l102:;
  (*azero_) = .5 * (r_[0] + r_[1]);
  a_[0] = .5 * (r_[0] - r_[1]);
  goto _l0;
  _l103:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    wsave_[i_ - 1] = r_[i_ - 1];
  }
  (void) _rfftf (n_, wsave_, &wsave_[(*n_) + 1 - 1]);
  cf_ = 2.0 / (*n_);
  cfm_ = -cf_;
  (*azero_) = .5 * cf_ * wsave_[0];
  ns2_ = ((*n_) + 1) / 2;
  ns2m_ = ns2_ - 1;
  for (i_ = 1; i_ <= ns2m_; (i_)++) {
    a_[i_ - 1] = cf_ * wsave_[2 * i_ - 1];
    b_[i_ - 1] = cfm_ * wsave_[2 * i_ + 1 - 1];
  }
  if (_imod ((*n_), 2) == 0) {
    a_[ns2_ - 1] = .5 * cf_ * wsave_[(*n_) - 1];
  }
  _l0:;
  __calls[31].calls++;
  return 0;
}

int_4 _ezffti (int_4 _p_ n_, real_4 _p_ wsave_)
{
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _ezfft1 (n_, &wsave_[2 * (*n_) + 1 - 1], &wsave_[3 * (*n_) + 1 - 1]);
  _l0:;
  __calls[32].calls++;
  return 0;
}

int_4 _passb2 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_)
{
  static int_4 k_, i_;
  static real_8 tr2_, ti2_;
  if ((*ido_) > 2) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + cc_[0 + ((*ido_)) 
    * ((1) + (2) * ((k_ - 1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[0 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[0 + ((*ido_)) 
    * ((1) + (2) * ((k_ - 1)))];
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + cc_[1 + ((*ido_)) 
    * ((1) + (2) * ((k_ - 1)))];
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[1 + ((*ido_)) 
    * ((1) + (2) * ((k_ - 1)))];
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 2; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + 
      cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + cc_[i_ - 
      1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * ti2_ + wa1_[i_ - 1] * tr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * tr2_ - wa1_[i_ - 1] * ti2_;
    }
  }
  _l0:;
  __calls[33].calls++;
  return 0;
}

int_4 _passb3 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 k_, i_;
  static real_8 taur_, taui_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_8;
#define _data_n_8 2
  static real_8 _data_l_8[_data_n_8] = {
    -0.5e0,
    0.86602540378443864676e0
  };
  if (__calls[34].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    taur_ = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    taui_ = _data_l_8[_data_k_8++];
  }
  if ((*ido_) != 2) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))];
    cr2_ = cc_[0 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * tr2_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + tr2_;
    ti2_ = cc_[1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))];
    ci2_ = cc_[1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * ti2_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + ti2_;
    cr3_ = taui_ * (cc_[0 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))]);
    ci3_ = taui_ * (cc_[1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))]);
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr2_ + ci3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci2_ - cr3_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 2; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))]
      ;
      cr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * tr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + 
      tr2_;
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))];
      ci2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * ti2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + ti2_;
      cr3_ = taui_ * (cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (3) * ((k_ 
      - 1)))]);
      ci3_ = taui_ * (cc_[i_ - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 
      1)))]);
      dr2_ = cr2_ - ci3_;
      dr3_ = cr2_ + ci3_;
      di2_ = ci2_ + cr3_;
      di3_ = ci2_ - cr3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * di2_ + wa1_[i_ - 1] * dr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * dr2_ - wa1_[i_ - 1] * di2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * di3_ + wa2_[i_ - 1] * dr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * dr3_ - wa2_[i_ - 1] * di3_;
    }
  }
  _l0:;
  __calls[34].calls++;
  return 0;
}

int_4 _passb4 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 
_p_ wa3_)
{
  static int_4 k_, i_;
  static real_8 ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  if ((*ido_) != 2) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    ti2_ = cc_[1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    tr4_ = cc_[1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))];
    ti3_ = cc_[1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    tr1_ = cc_[0 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    tr2_ = cc_[0 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    ti4_ = cc_[0 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    tr3_ = cc_[0 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = tr2_ - tr3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ti2_ - ti3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = tr1_ + tr4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = tr1_ - tr4_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ti1_ + ti4_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ti1_ - ti4_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 2; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ti1_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
      ti3_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
      tr4_ = cc_[i_ - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))];
      tr1_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))]
      ;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))]
      ;
      ti4_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))]
      ;
      tr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
      cr3_ = tr2_ - tr3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
      ci3_ = ti2_ - ti3_;
      cr2_ = tr1_ + tr4_;
      cr4_ = tr1_ - tr4_;
      ci2_ = ti1_ + ti4_;
      ci4_ = ti1_ - ti4_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * cr2_ - wa1_[i_ - 1] * ci2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * ci2_ + wa1_[i_ - 1] * cr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * cr3_ - wa2_[i_ - 1] * ci3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * ci3_ + wa2_[i_ - 1] * cr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 1 - 1] * cr4_ - wa3_[i_ - 1] * ci4_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 1 - 1] * ci4_ + wa3_[i_ - 1] * cr4_;
    }
  }
  _l0:;
  __calls[35].calls++;
  return 0;
}

int_4 _passb5 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 
_p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 k_, i_;
  static real_8 tr11_, ti11_, tr12_, ti12_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, cr2_, ci2_, cr3_, ci3_, cr5_, 
  ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_9;
#define _data_n_9 4
  static real_8 _data_l_9[_data_n_9] = {
    0.3090169943749474241e0,
    0.95105651629515357212e0,
    -0.8090169943749474241e0,
    0.58778525229247312917e0
  };
  if (__calls[36].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    tr11_ = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    ti11_ = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    tr12_ = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    ti12_ = _data_l_9[_data_k_9++];
  }
  if ((*ido_) != 2) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    ti2_ = cc_[1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    ti4_ = cc_[1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
    ti3_ = cc_[1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
    tr5_ = cc_[0 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    tr2_ = cc_[0 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    tr4_ = cc_[0 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
    tr3_ = cc_[0 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr2_ + tr3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + ti2_ + ti3_;
    cr2_ = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * ti2_ + tr11_ * ti3_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci5_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = cr2_ + ci5_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr5_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci3_ + cr4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr3_ - ci4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = cr3_ + ci4_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ci3_ - cr4_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = ci2_ - cr5_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 2; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ti5_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
      ti4_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
      ti3_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
      tr5_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))]
      ;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))]
      ;
      tr4_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))]
      ;
      tr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + 
      tr2_ + tr3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + ti2_ + 
      ti3_;
      cr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * tr2_ + tr12_ * tr3_;
      ci2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * ti2_ + tr12_ * ti3_;
      cr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * tr2_ + tr11_ * tr3_;
      ci3_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * ti2_ + tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      dr3_ = cr3_ - ci4_;
      dr4_ = cr3_ + ci4_;
      di3_ = ci3_ + cr4_;
      di4_ = ci3_ - cr4_;
      dr5_ = cr2_ + ci5_;
      dr2_ = cr2_ - ci5_;
      di5_ = ci2_ - cr5_;
      di2_ = ci2_ + cr5_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * dr2_ - wa1_[i_ - 1] * di2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * di2_ + wa1_[i_ - 1] * dr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * dr3_ - wa2_[i_ - 1] * di3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * di3_ + wa2_[i_ - 1] * dr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 1 - 1] * dr4_ - wa3_[i_ - 1] * di4_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 1 - 1] * di4_ + wa3_[i_ - 1] * dr4_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = wa4_[i_ - 1 - 1] * dr5_ - wa4_[i_ - 1] * di5_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = wa4_[i_ - 1 - 1] * di5_ + wa4_[i_ - 1] * dr5_;
    }
  }
  _l0:;
  __calls[36].calls++;
  return 0;
}

int_4 _passb (int_4 _p_ nac_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ 
c1_, real_8 _p_ c2_, real_8 _p_ ch_, real_8 _p_ ch2_, real_8 _p_ wa_)
{
  static int_4 idot_, nt_, ipp2_, ipph_, idp_, j_, jc_, k_, i_, idl_, inc_, l_, lc_, ik_, idlj_, idij_, idj_;
  static real_8 war_, wai_;
  idot_ = (*ido_) / 2;
  nt_ = (*ip_) * (*idl1_);
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  idp_ = (*ip_) * (*ido_);
  if ((*ido_) < (*l1_)) {
    goto _l106;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 1; i_ <= (*ido_); (i_)++) {
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((j_ - 1) + ((*ip_)) * ((k_ - 
        1)))] + cc_[i_ - 1 + ((*ido_)) * ((jc_ - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((j_ - 1) + ((*ip_)) * ((k_ - 
        1)))] - cc_[i_ - 1 + ((*ido_)) * ((jc_ - 1) + ((*ip_)) * ((k_ - 1)))];
      }
    }
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1)))];
    }
  }
  goto _l112;
  _l106:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((j_ - 1) + ((*ip_)) * ((k_ - 
        1)))] + cc_[i_ - 1 + ((*ido_)) * ((jc_ - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((j_ - 1) + ((*ip_)) * ((k_ - 
        1)))] - cc_[i_ - 1 + ((*ido_)) * ((jc_ - 1) + ((*ip_)) * ((k_ - 1)))];
      }
    }
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1)))];
    }
  }
  _l112:;
  idl_ = 2 - (*ido_);
  inc_ = 0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    idl_ = idl_ + (*ido_);
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))] + wa_[idl_ - 1 - 1] * ch2_[ik_ - 1 + 
      ((*idl1_)) * ((1))];
      c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] = wa_[idl_ - 1] * ch2_[ik_ - 1 + ((*idl1_)) * (((*ip_) - 1))];
    }
    idlj_ = idl_;
    inc_ = inc_ + (*ido_);
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = idlj_ + inc_;
      if (idlj_ > idp_) {
        idlj_ = idlj_ - idp_;
      }
      war_ = wa_[idlj_ - 1 - 1];
      wai_ = wa_[idlj_ - 1];
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] + war_ * ch2_[ik_ - 1 + ((*idl1_)) * 
        ((j_ - 1))];
        c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] + wai_ * ch2_[ik_ - 1 + ((*idl1_)) * 
        ((jc_ - 1))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      ch2_[ik_ - 1 + ((*idl1_)) * ((0))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))] + ch2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ik_ = 2; (2 > 0 ? ik_ <= (*idl1_) : ik_ >= (*idl1_)); ik_ += 2) {
      ch2_[ik_ - 1 - 1 + ((*idl1_)) * ((j_ - 1))] = c2_[ik_ - 1 - 1 + ((*idl1_)) * ((j_ - 1))] - c2_[ik_ - 1 + ((*idl1_)) * 
      ((jc_ - 1))];
      ch2_[ik_ - 1 - 1 + ((*idl1_)) * ((jc_ - 1))] = c2_[ik_ - 1 - 1 + ((*idl1_)) * ((j_ - 1))] + c2_[ik_ - 1 + ((*idl1_)) * 
      ((jc_ - 1))];
      ch2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))] + c2_[ik_ - 1 - 1 + ((*idl1_)) * ((jc_ 
      - 1))];
      ch2_[ik_ - 1 + ((*idl1_)) * ((jc_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))] - c2_[ik_ - 1 - 1 + ((*idl1_)) * 
      ((jc_ - 1))];
    }
  }
  (*nac_) = 1;
  if ((*ido_) == 2) {
    goto _l0;
  }
  (*nac_) = 0;
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    c2_[ik_ - 1 + ((*idl1_)) * ((0))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))];
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      c1_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
    }
  }
  if (idot_ > (*l1_)) {
    goto _l127;
  }
  idij_ = 0;
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    idij_ = idij_ + 2;
    for (i_ = 4; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] - wa_[idij_ - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((j_ - 1)))] + wa_[idij_ - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  goto _l0;
  _l127:;
  idj_ = 2 - (*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    idj_ = idj_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = idj_;
      for (i_ = 4; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] - wa_[idij_ - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((j_ - 1)))] + wa_[idij_ - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  _l0:;
  __calls[37].calls++;
  return 0;
}

int_4 _passf2 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_)
{
  static int_4 k_, i_;
  static real_8 tr2_, ti2_;
  if ((*ido_) > 2) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + cc_[0 + ((*ido_)) 
    * ((1) + (2) * ((k_ - 1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[0 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[0 + ((*ido_)) 
    * ((1) + (2) * ((k_ - 1)))];
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + cc_[1 + ((*ido_)) 
    * ((1) + (2) * ((k_ - 1)))];
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[1 + ((*ido_)) 
    * ((1) + (2) * ((k_ - 1)))];
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 2; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + 
      cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + cc_[i_ - 
      1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * ti2_ - wa1_[i_ - 1] * tr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * tr2_ + wa1_[i_ - 1] * ti2_;
    }
  }
  _l0:;
  __calls[38].calls++;
  return 0;
}

int_4 _passf3 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 k_, i_;
  static real_8 taur_, taui_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_10;
#define _data_n_10 2
  static real_8 _data_l_10[_data_n_10] = {
    -0.5e0,
    -0.86602540378443864676e0
  };
  if (__calls[39].calls == 0) {
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    taur_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    taui_ = _data_l_10[_data_k_10++];
  }
  if ((*ido_) != 2) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))];
    cr2_ = cc_[0 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * tr2_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + tr2_;
    ti2_ = cc_[1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))];
    ci2_ = cc_[1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * ti2_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + ti2_;
    cr3_ = taui_ * (cc_[0 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))]);
    ci3_ = taui_ * (cc_[1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))]);
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr2_ + ci3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci2_ - cr3_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 2; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))]
      ;
      cr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * tr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + 
      tr2_;
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))];
      ci2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * ti2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + ti2_;
      cr3_ = taui_ * (cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (3) * ((k_ 
      - 1)))]);
      ci3_ = taui_ * (cc_[i_ - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 
      1)))]);
      dr2_ = cr2_ - ci3_;
      dr3_ = cr2_ + ci3_;
      di2_ = ci2_ + cr3_;
      di3_ = ci2_ - cr3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * di2_ - wa1_[i_ - 1] * dr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * dr2_ + wa1_[i_ - 1] * di2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * di3_ - wa2_[i_ - 1] * dr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * dr3_ + wa2_[i_ - 1] * di3_;
    }
  }
  _l0:;
  __calls[39].calls++;
  return 0;
}

int_4 _passf4 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 
_p_ wa3_)
{
  static int_4 k_, i_;
  static real_8 ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  if ((*ido_) != 2) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    ti2_ = cc_[1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    tr4_ = cc_[1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    ti3_ = cc_[1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    tr1_ = cc_[0 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    tr2_ = cc_[0 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    ti4_ = cc_[0 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))];
    tr3_ = cc_[0 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = tr2_ - tr3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ti2_ - ti3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = tr1_ + tr4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = tr1_ - tr4_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ti1_ + ti4_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ti1_ - ti4_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 2; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ti1_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
      ti3_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
      tr4_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
      tr1_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))]
      ;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))]
      ;
      ti4_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))]
      ;
      tr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
      cr3_ = tr2_ - tr3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
      ci3_ = ti2_ - ti3_;
      cr2_ = tr1_ + tr4_;
      cr4_ = tr1_ - tr4_;
      ci2_ = ti1_ + ti4_;
      ci4_ = ti1_ - ti4_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * cr2_ + wa1_[i_ - 1] * ci2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * ci2_ - wa1_[i_ - 1] * cr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * cr3_ + wa2_[i_ - 1] * ci3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * ci3_ - wa2_[i_ - 1] * cr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 1 - 1] * cr4_ + wa3_[i_ - 1] * ci4_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 1 - 1] * ci4_ - wa3_[i_ - 1] * cr4_;
    }
  }
  _l0:;
  __calls[40].calls++;
  return 0;
}

int_4 _passf5 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 
_p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 k_, i_;
  static real_8 tr11_, ti11_, tr12_, ti12_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, cr2_, ci2_, cr3_, ci3_, cr5_, 
  ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_11;
#define _data_n_11 4
  static real_8 _data_l_11[_data_n_11] = {
    0.3090169943749474241e0,
    -0.95105651629515357212e0,
    -0.8090169943749474241e0,
    -0.58778525229247312917e0
  };
  if (__calls[41].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    tr11_ = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    ti11_ = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    tr12_ = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    ti12_ = _data_l_11[_data_k_11++];
  }
  if ((*ido_) != 2) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    ti2_ = cc_[1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    ti4_ = cc_[1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
    ti3_ = cc_[1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
    tr5_ = cc_[0 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    tr2_ = cc_[0 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    tr4_ = cc_[0 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
    tr3_ = cc_[0 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr2_ + tr3_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + ti2_ + ti3_;
    cr2_ = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * ti2_ + tr11_ * ti3_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci5_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = cr2_ + ci5_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr5_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci3_ + cr4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr3_ - ci4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = cr3_ + ci4_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ci3_ - cr4_;
    ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = ci2_ - cr5_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 2; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ti5_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
      ti4_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[i_ - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
      ti3_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[i_ - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
      tr5_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))]
      ;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))]
      ;
      tr4_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[i_ - 1 - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))]
      ;
      tr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[i_ - 1 - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + 
      tr2_ + tr3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + ti2_ + 
      ti3_;
      cr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * tr2_ + tr12_ * tr3_;
      ci2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * ti2_ + tr12_ * ti3_;
      cr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * tr2_ + tr11_ * tr3_;
      ci3_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * ti2_ + tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      dr3_ = cr3_ - ci4_;
      dr4_ = cr3_ + ci4_;
      di3_ = ci3_ + cr4_;
      di4_ = ci3_ - cr4_;
      dr5_ = cr2_ + ci5_;
      dr2_ = cr2_ - ci5_;
      di5_ = ci2_ - cr5_;
      di2_ = ci2_ + cr5_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * dr2_ + wa1_[i_ - 1] * di2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 1 - 1] * di2_ - wa1_[i_ - 1] * dr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * dr3_ + wa2_[i_ - 1] * di3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 1 - 1] * di3_ - wa2_[i_ - 1] * dr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 1 - 1] * dr4_ + wa3_[i_ - 1] * di4_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 1 - 1] * di4_ - wa3_[i_ - 1] * dr4_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = wa4_[i_ - 1 - 1] * dr5_ + wa4_[i_ - 1] * di5_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = wa4_[i_ - 1 - 1] * di5_ - wa4_[i_ - 1] * dr5_;
    }
  }
  _l0:;
  __calls[41].calls++;
  return 0;
}

int_4 _passf (int_4 _p_ nac_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ 
c1_, real_8 _p_ c2_, real_8 _p_ ch_, real_8 _p_ ch2_, real_8 _p_ wa_)
{
  static int_4 idot_, nt_, ipp2_, ipph_, idp_, j_, jc_, k_, i_, idl_, inc_, l_, lc_, ik_, idlj_, idij_, idj_;
  static real_8 war_, wai_;
  idot_ = (*ido_) / 2;
  nt_ = (*ip_) * (*idl1_);
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  idp_ = (*ip_) * (*ido_);
  if ((*ido_) < (*l1_)) {
    goto _l106;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 1; i_ <= (*ido_); (i_)++) {
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((j_ - 1) + ((*ip_)) * ((k_ - 
        1)))] + cc_[i_ - 1 + ((*ido_)) * ((jc_ - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((j_ - 1) + ((*ip_)) * ((k_ - 
        1)))] - cc_[i_ - 1 + ((*ido_)) * ((jc_ - 1) + ((*ip_)) * ((k_ - 1)))];
      }
    }
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1)))];
    }
  }
  goto _l112;
  _l106:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((j_ - 1) + ((*ip_)) * ((k_ - 
        1)))] + cc_[i_ - 1 + ((*ido_)) * ((jc_ - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((j_ - 1) + ((*ip_)) * ((k_ - 
        1)))] - cc_[i_ - 1 + ((*ido_)) * ((jc_ - 1) + ((*ip_)) * ((k_ - 1)))];
      }
    }
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1)))];
    }
  }
  _l112:;
  idl_ = 2 - (*ido_);
  inc_ = 0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    idl_ = idl_ + (*ido_);
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))] + wa_[idl_ - 1 - 1] * ch2_[ik_ - 1 + 
      ((*idl1_)) * ((1))];
      c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] = -wa_[idl_ - 1] * ch2_[ik_ - 1 + ((*idl1_)) * (((*ip_) - 1))];
    }
    idlj_ = idl_;
    inc_ = inc_ + (*ido_);
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = idlj_ + inc_;
      if (idlj_ > idp_) {
        idlj_ = idlj_ - idp_;
      }
      war_ = wa_[idlj_ - 1 - 1];
      wai_ = wa_[idlj_ - 1];
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] + war_ * ch2_[ik_ - 1 + ((*idl1_)) * 
        ((j_ - 1))];
        c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] - wai_ * ch2_[ik_ - 1 + ((*idl1_)) * 
        ((jc_ - 1))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      ch2_[ik_ - 1 + ((*idl1_)) * ((0))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))] + ch2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ik_ = 2; (2 > 0 ? ik_ <= (*idl1_) : ik_ >= (*idl1_)); ik_ += 2) {
      ch2_[ik_ - 1 - 1 + ((*idl1_)) * ((j_ - 1))] = c2_[ik_ - 1 - 1 + ((*idl1_)) * ((j_ - 1))] - c2_[ik_ - 1 + ((*idl1_)) * 
      ((jc_ - 1))];
      ch2_[ik_ - 1 - 1 + ((*idl1_)) * ((jc_ - 1))] = c2_[ik_ - 1 - 1 + ((*idl1_)) * ((j_ - 1))] + c2_[ik_ - 1 + ((*idl1_)) * 
      ((jc_ - 1))];
      ch2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))] + c2_[ik_ - 1 - 1 + ((*idl1_)) * ((jc_ 
      - 1))];
      ch2_[ik_ - 1 + ((*idl1_)) * ((jc_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))] - c2_[ik_ - 1 - 1 + ((*idl1_)) * 
      ((jc_ - 1))];
    }
  }
  (*nac_) = 1;
  if ((*ido_) == 2) {
    goto _l0;
  }
  (*nac_) = 0;
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    c2_[ik_ - 1 + ((*idl1_)) * ((0))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))];
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      c1_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
    }
  }
  if (idot_ > (*l1_)) {
    goto _l127;
  }
  idij_ = 0;
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    idij_ = idij_ + 2;
    for (i_ = 4; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] + wa_[idij_ - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((j_ - 1)))] - wa_[idij_ - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  goto _l0;
  _l127:;
  idj_ = 2 - (*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    idj_ = idj_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = idj_;
      for (i_ = 4; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] + wa_[idij_ - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((j_ - 1)))] - wa_[idij_ - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  _l0:;
  __calls[42].calls++;
  return 0;
}

int_4 _radb2 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_8 tr2_, ti2_;
  int_4 $0_;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + cc_[(*ido_) - 1 + 
    ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[0 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[(*ido_) - 1 + 
    ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + 
      cc_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] - cc_[ic_ 
      - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] + cc_[ic_ - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))];
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 2 - 1] * tr2_ - wa1_[i_ - 1 - 1] * ti2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 2 - 1] * ti2_ + wa1_[i_ - 1 - 1] * tr2_;
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[(*ido_) - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] 
    + cc_[(*ido_) - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))];
    ch_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = -(cc_[0 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))] + cc_[0 
    + ((*ido_)) * ((1) + (2) * ((k_ - 1)))]);
  }
  _l107:;
  _l0:;
  __calls[43].calls++;
  return 0;
}
int_4 _radb3 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_8 taur_, taui_, tr2_, cr2_, ci3_, ti2_, ci2_, cr3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_12;
#define _data_n_12 2
  static real_8 _data_l_12[_data_n_12] = {
    -0.5e0,
    0.86602540378443864676e0
  };
  if (__calls[44].calls == 0) {
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    taur_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    taui_ = _data_l_12[_data_k_12++];
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[(*ido_) - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] + cc_[(*ido_) - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 
    1)))];
    cr2_ = cc_[0 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * tr2_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + tr2_;
    ci3_ = taui_ * (cc_[0 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))]);
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr2_ + ci3_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))] + cc_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))]
      ;
      cr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * tr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + 
      tr2_;
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))] - cc_[ic_ - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))];
      ci2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + taur_ * ti2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] + ti2_;
      cr3_ = taui_ * (cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))] - cc_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (3) * 
      ((k_ - 1)))]);
      ci3_ = taui_ * (cc_[i_ - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))] + cc_[ic_ - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 
      1)))]);
      dr2_ = cr2_ - ci3_;
      dr3_ = cr2_ + ci3_;
      di2_ = ci2_ + cr3_;
      di3_ = ci2_ - cr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 2 - 1] * dr2_ - wa1_[i_ - 1 - 1] * di2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 2 - 1] * di2_ + wa1_[i_ - 1 - 1] * dr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 2 - 1] * dr3_ - wa2_[i_ - 1 - 1] * di3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 2 - 1] * di3_ + wa2_[i_ - 1 - 1] * dr3_;
    }
  }
  _l0:;
  __calls[44].calls++;
  return 0;
}

int_4 _radb4 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 
_p_ wa3_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_8 sqrt2_, tr1_, tr2_, tr3_, tr4_, ti1_, ti2_, ti3_, ti4_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  int_4 _data_k_13, $0_;
#define _data_n_13 1
  static real_8 _data_l_13[_data_n_13] = {
    1.4142135623730950488e0
  };
  if (__calls[45].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    sqrt2_ = _data_l_13[_data_k_13++];
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr1_ = cc_[0 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[(*ido_) - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    tr2_ = cc_[0 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[(*ido_) - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    tr3_ = cc_[(*ido_) - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[(*ido_) - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 
    1)))];
    tr4_ = cc_[0 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = tr1_ - tr4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = tr2_ - tr3_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = tr1_ + tr4_;
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ti1_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[ic_ - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[ic_ - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
      ti3_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] - cc_[ic_ - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))];
      tr4_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] + cc_[ic_ - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))];
      tr1_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[ic_ - 1 - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))]
      ;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[ic_ - 1 - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))]
      ;
      ti4_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] - cc_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))]
      ;
      tr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] + cc_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
      cr3_ = tr2_ - tr3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
      ci3_ = ti2_ - ti3_;
      cr2_ = tr1_ - tr4_;
      cr4_ = tr1_ + tr4_;
      ci2_ = ti1_ + ti4_;
      ci4_ = ti1_ - ti4_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 2 - 1] * cr2_ - wa1_[i_ - 1 - 1] * ci2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 2 - 1] * ci2_ + wa1_[i_ - 1 - 1] * cr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 2 - 1] * cr3_ - wa2_[i_ - 1 - 1] * ci3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 2 - 1] * ci3_ + wa2_[i_ - 1 - 1] * cr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 2 - 1] * cr4_ - wa3_[i_ - 1 - 1] * ci4_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 2 - 1] * ci4_ + wa3_[i_ - 1 - 1] * cr4_;
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[0 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))];
    ti2_ = cc_[0 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] - cc_[0 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))];
    tr1_ = cc_[(*ido_) - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] - cc_[(*ido_) - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 
    1)))];
    tr2_ = cc_[(*ido_) - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] + cc_[(*ido_) - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 
    1)))];
    ch_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr2_;
    ch_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sqrt2_ * (tr1_ - ti1_);
    ch_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ti2_ + ti2_;
    ch_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = -sqrt2_ * (tr1_ + ti1_);
  }
  _l107:;
  _l0:;
  __calls[45].calls++;
  return 0;
}

int_4 _radb5 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 
_p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_8 tr11_, ti11_, tr12_, ti12_, ti5_, ti4_, tr2_, tr3_, cr2_, cr3_, ci5_, ci4_, ti2_, ti3_, tr5_, tr4_, ci2_, 
  ci3_, cr5_, cr4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_14;
#define _data_n_14 4
  static real_8 _data_l_14[_data_n_14] = {
    0.3090169943749474241e0,
    0.95105651629515357212e0,
    -0.8090169943749474241e0,
    0.58778525229247312917e0
  };
  if (__calls[46].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    tr11_ = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    ti11_ = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    tr12_ = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    ti12_ = _data_l_14[_data_k_14++];
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[0 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))];
    ti4_ = cc_[0 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))] + cc_[0 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))];
    tr2_ = cc_[(*ido_) - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] + cc_[(*ido_) - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 
    1)))];
    tr3_ = cc_[(*ido_) - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))] + cc_[(*ido_) - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 
    1)))];
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr2_ + tr3_;
    cr2_ = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * tr2_ + tr12_ * tr3_;
    cr3_ = cc_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci5_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr3_ - ci4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = cr3_ + ci4_;
    ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = cr2_ + ci5_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ti5_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[ic_ - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))];
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[ic_ - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))];
      ti4_ = cc_[i_ - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))] + cc_[ic_ - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
      ti3_ = cc_[i_ - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))] - cc_[ic_ - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))];
      tr5_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] - cc_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))]
      ;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] + cc_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))]
      ;
      tr4_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))] - cc_[ic_ - 1 - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))]
      ;
      tr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))] + cc_[ic_ - 1 - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))]
      ;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + 
      tr2_ + tr3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + ti2_ + 
      ti3_;
      cr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * tr2_ + tr12_ * tr3_;
      ci2_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr11_ * ti2_ + tr12_ * ti3_;
      cr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * tr2_ + tr11_ * tr3_;
      ci3_ = cc_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] + tr12_ * ti2_ + tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      dr3_ = cr3_ - ci4_;
      dr4_ = cr3_ + ci4_;
      di3_ = ci3_ + cr4_;
      di4_ = ci3_ - cr4_;
      dr5_ = cr2_ + ci5_;
      dr2_ = cr2_ - ci5_;
      di5_ = ci2_ - cr5_;
      di2_ = ci2_ + cr5_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 2 - 1] * dr2_ - wa1_[i_ - 1 - 1] * di2_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = wa1_[i_ - 2 - 1] * di2_ + wa1_[i_ - 1 - 1] * dr2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 2 - 1] * dr3_ - wa2_[i_ - 1 - 1] * di3_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = wa2_[i_ - 2 - 1] * di3_ + wa2_[i_ - 1 - 1] * dr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 2 - 1] * dr4_ - wa3_[i_ - 1 - 1] * di4_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = wa3_[i_ - 2 - 1] * di4_ + wa3_[i_ - 1 - 1] * dr4_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = wa4_[i_ - 2 - 1] * dr5_ - wa4_[i_ - 1 - 1] * di5_;
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = wa4_[i_ - 2 - 1] * di5_ + wa4_[i_ - 1 - 1] * dr5_;
    }
  }
  _l0:;
  __calls[46].calls++;
  return 0;
}

int_4 _radbg (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ c1_, real_8 _p_ 
c2_, real_8 _p_ ch_, real_8 _p_ ch2_, real_8 _p_ wa_)
{
  static int_4 idp2_, nbd_, ipp2_, ipph_, k_, i_, j_, jc_, j2_, ic_, l_, lc_, ik_, is_, idij_;
  static real_8 tpi_, arg_, dcp_, dsp_, ar1_, ai1_, ar1h_, dc2_, ds2_, ar2_, ai2_, ar2h_;
  int_4 _data_k_15;
#define _data_n_15 1
  static real_8 _data_l_15[_data_n_15] = {
    6.28318530717958647692e0
  };
  if (__calls[47].calls == 0) {
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    tpi_ = _data_l_15[_data_k_15++];
  }
  arg_ = tpi_ / (real_4) ((*ip_));
  dcp_ = cos (arg_);
  dsp_ = sin (arg_);
  idp2_ = (*ido_) + 2;
  nbd_ = ((*ido_) - 1) / 2;
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  if ((*ido_) < (*l1_)) {
    goto _l103;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1)))];
    }
  }
  goto _l106;
  _l103:;
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[i_ - 1 + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1)))];
    }
  }
  _l106:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[(*ido_) - 1 + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * 
      ((k_ - 1)))] + cc_[(*ido_) - 1 + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
      ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[0 + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1)))] 
      + cc_[0 + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1)))];
    }
  }
  if ((*ido_) == 1) {
    goto _l116;
  }
  if (nbd_ < (*l1_)) {
    goto _l112;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ic_ = idp2_ - i_;
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((2 * j_ - 1 - 1) + 
        ((*ip_)) * ((k_ - 1)))] + cc_[ic_ - 1 - 1 + ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((2 * j_ - 1 - 1) + 
        ((*ip_)) * ((k_ - 1)))] - cc_[ic_ - 1 - 1 + ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * 
        ((k_ - 1)))] - cc_[ic_ - 1 + ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * 
        ((k_ - 1)))] + cc_[ic_ - 1 + ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
      }
    }
  }
  goto _l116;
  _l112:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((2 * j_ - 1 - 1) + 
        ((*ip_)) * ((k_ - 1)))] + cc_[ic_ - 1 - 1 + ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((2 * j_ - 1 - 1) + 
        ((*ip_)) * ((k_ - 1)))] - cc_[ic_ - 1 - 1 + ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * 
        ((k_ - 1)))] - cc_[ic_ - 1 + ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * 
        ((k_ - 1)))] + cc_[ic_ - 1 + ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))];
      }
    }
  }
  _l116:;
  ar1_ = 1.0;
  ai1_ = 0.0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    ar1h_ = dcp_ * ar1_ - dsp_ * ai1_;
    ai1_ = dcp_ * ai1_ + dsp_ * ar1_;
    ar1_ = ar1h_;
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))] + ar1_ * ch2_[ik_ - 1 + ((*idl1_)) * ((1))]
      ;
      c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] = ai1_ * ch2_[ik_ - 1 + ((*idl1_)) * (((*ip_) - 1))];
    }
    dc2_ = ar1_;
    ds2_ = ai1_;
    ar2_ = ar1_;
    ai2_ = ai1_;
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      ar2h_ = dc2_ * ar2_ - ds2_ * ai2_;
      ai2_ = dc2_ * ai2_ + ds2_ * ar2_;
      ar2_ = ar2h_;
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] + ar2_ * ch2_[ik_ - 1 + ((*idl1_)) * 
        ((j_ - 1))];
        c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] + ai2_ * ch2_[ik_ - 1 + ((*idl1_)) * 
        ((jc_ - 1))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      ch2_[ik_ - 1 + ((*idl1_)) * ((0))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))] + ch2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] - 
      c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
      ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] + 
      c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
    }
  }
  if ((*ido_) == 1) {
    goto _l132;
  }
  if (nbd_ < (*l1_)) {
    goto _l128;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] - c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] + c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 
        1)))] + c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 
        1)))] - c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
      }
    }
  }
  goto _l132;
  _l128:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] - c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] + c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 
        1)))] + c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 
        1)))] - c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
      }
    }
  }
  _l132:;
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    c2_[ik_ - 1 + ((*idl1_)) * ((0))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))];
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
    }
  }
  if (nbd_ > (*l1_)) {
    goto _l139;
  }
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    idij_ = is_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] - wa_[idij_ - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((j_ - 1)))] + wa_[idij_ - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  goto _l143;
  _l139:;
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = is_;
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] - wa_[idij_ - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((j_ - 1)))] + wa_[idij_ - 1] * ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  _l143:;
  _l0:;
  __calls[47].calls++;
  return 0;
}

int_4 _radf2 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_8 tr2_, ti2_;
  int_4 $0_;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + cc_[0 + ((*ido_)) 
    * ((k_ - 1) + ((*l1_)) * ((1)))];
    ch_[(*ido_) - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] - cc_[0 + 
    ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      tr2_ = wa1_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] + wa1_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
      ti2_ = wa1_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] - wa1_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
      ch_[i_ - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + ti2_;
      ch_[ic_ - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))] = ti2_ - cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))];
      ch_[i_ - 1 - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + 
      tr2_;
      ch_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] - 
      tr2_;
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*ido_)) * ((1) + (2) * ((k_ - 1)))] = -cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
    ch_[(*ido_) - 1 + ((*ido_)) * ((0) + (2) * ((k_ - 1)))] = cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))]
    ;
  }
  _l107:;
  _l0:;
  __calls[48].calls++;
  return 0;
}
int_4 _radf3 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_8 taur_, taui_, cr2_, dr2_, di2_, dr3_, di3_, ci2_, tr2_, ti2_, tr3_, ti3_;
  int_4 _data_k_16;
#define _data_n_16 2
  static real_8 _data_l_16[_data_n_16] = {
    -0.5e0,
    0.86602540378443864676e0
  };
  if (__calls[49].calls == 0) {
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    taur_ = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    taui_ = _data_l_16[_data_k_16++];
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    cr2_ = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] + cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
    ch_[0 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + cr2_;
    ch_[0 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))] = taui_ * (cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] - cc_[0 + 
    ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))]);
    ch_[(*ido_) - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + taur_ * 
    cr2_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      dr2_ = wa1_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] + wa1_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
      di2_ = wa1_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] - wa1_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
      dr3_ = wa2_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] + wa2_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
      di3_ = wa2_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] - wa2_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
      cr2_ = dr2_ + dr3_;
      ci2_ = di2_ + di3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + 
      cr2_;
      ch_[i_ - 1 + ((*ido_)) * ((0) + (3) * ((k_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + ci2_;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + taur_ * cr2_;
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + taur_ * ci2_;
      tr3_ = taui_ * (di2_ - di3_);
      ti3_ = taui_ * (dr3_ - dr2_);
      ch_[i_ - 1 - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))] = tr2_ + tr3_;
      ch_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] = tr2_ - tr3_;
      ch_[i_ - 1 + ((*ido_)) * ((2) + (3) * ((k_ - 1)))] = ti2_ + ti3_;
      ch_[ic_ - 1 + ((*ido_)) * ((1) + (3) * ((k_ - 1)))] = ti3_ - ti2_;
    }
  }
  _l0:;
  __calls[49].calls++;
  return 0;
}

int_4 _radf4 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 
_p_ wa3_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_8 hsqt2_, tr1_, tr2_, cr2_, ci2_, cr3_, ci3_, cr4_, ci4_, tr4_, ti1_, ti4_, ti2_, ti3_, tr3_;
  int_4 _data_k_17, $0_;
#define _data_n_17 1
  static real_8 _data_l_17[_data_n_17] = {
    0.7071067811865475244e0
  };
  if (__calls[50].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    hsqt2_ = _data_l_17[_data_k_17++];
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr1_ = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] + cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))];
    tr2_ = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
    ch_[0 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] = tr1_ + tr2_;
    ch_[(*ido_) - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] = tr2_ - tr1_;
    ch_[(*ido_) - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] - cc_[0 + 
    ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
    ch_[0 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] - cc_[0 + ((*ido_)) 
    * ((k_ - 1) + ((*l1_)) * ((1)))];
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      cr2_ = wa1_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] + wa1_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
      ci2_ = wa1_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] - wa1_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
      cr3_ = wa2_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] + wa2_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
      ci3_ = wa2_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] - wa2_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
      cr4_ = wa3_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] + wa3_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))];
      ci4_ = wa3_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] - wa3_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))];
      tr1_ = cr2_ + cr4_;
      tr4_ = cr4_ - cr2_;
      ti1_ = ci2_ + ci4_;
      ti4_ = ci2_ - ci4_;
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + ci3_;
      ti3_ = cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] - ci3_;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + cr3_;
      tr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] - cr3_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] = tr1_ + tr2_;
      ch_[ic_ - 1 - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] = tr2_ - tr1_;
      ch_[i_ - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] = ti1_ + ti2_;
      ch_[ic_ - 1 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] = ti1_ - ti2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] = ti4_ + tr3_;
      ch_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] = tr3_ - ti4_;
      ch_[i_ - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] = tr4_ + ti3_;
      ch_[ic_ - 1 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] = tr4_ - ti3_;
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = -hsqt2_ * (cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] + cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 
    1) + ((*l1_)) * ((3)))]);
    tr1_ = hsqt2_ * (cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] - cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) 
    + ((*l1_)) * ((3)))]);
    ch_[(*ido_) - 1 + ((*ido_)) * ((0) + (4) * ((k_ - 1)))] = tr1_ + cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
    ((0)))];
    ch_[(*ido_) - 1 + ((*ido_)) * ((2) + (4) * ((k_ - 1)))] = cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] 
    - tr1_;
    ch_[0 + ((*ido_)) * ((1) + (4) * ((k_ - 1)))] = ti1_ - cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
    ch_[0 + ((*ido_)) * ((3) + (4) * ((k_ - 1)))] = ti1_ + cc_[(*ido_) - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
  }
  _l107:;
  _l0:;
  __calls[50].calls++;
  return 0;
}

int_4 _radf5 (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, real_8 _p_ ch_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 
_p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_8 tr11_, ti11_, tr12_, ti12_, cr2_, ci5_, cr3_, ci4_, dr2_, di2_, dr3_, di3_, dr4_, di4_, dr5_, di5_, cr5_, 
  ci2_, cr4_, ci3_, tr2_, ti2_, tr3_, ti3_, tr5_, ti5_, tr4_, ti4_;
  int_4 _data_k_18;
#define _data_n_18 4
  static real_8 _data_l_18[_data_n_18] = {
    0.3090169943749474241e0,
    0.95105651629515357212e0,
    -0.8090169943749474241e0,
    0.58778525229247312917e0
  };
  if (__calls[51].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    tr11_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    ti11_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    tr12_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    ti12_ = _data_l_18[_data_k_18++];
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    cr2_ = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] + cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
    ci5_ = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] - cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
    cr3_ = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] + cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
    ci4_ = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] - cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
    ch_[0 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + cr2_ + cr3_;
    ch_[(*ido_) - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + tr11_ * 
    cr2_ + tr12_ * cr3_;
    ch_[0 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] = ti11_ * ci5_ + ti12_ * ci4_;
    ch_[(*ido_) - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))] = cc_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + tr12_ * 
    cr2_ + tr11_ * cr3_;
    ch_[0 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))] = ti12_ * ci5_ - ti11_ * ci4_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      dr2_ = wa1_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] + wa1_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
      di2_ = wa1_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))] - wa1_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1)))];
      dr3_ = wa2_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] + wa2_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
      di3_ = wa2_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))] - wa2_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2)))];
      dr4_ = wa3_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] + wa3_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))];
      di4_ = wa3_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))] - wa3_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3)))];
      dr5_ = wa4_[i_ - 2 - 1] * cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] + wa4_[i_ - 1 - 1] * cc_[i_ - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))];
      di5_ = wa4_[i_ - 2 - 1] * cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))] - wa4_[i_ - 1 - 1] * cc_[i_ - 1 - 1 + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4)))];
      cr2_ = dr2_ + dr5_;
      ci5_ = dr5_ - dr2_;
      cr5_ = di2_ - di5_;
      ci2_ = di2_ + di5_;
      cr3_ = dr3_ + dr4_;
      ci4_ = dr4_ - dr3_;
      cr4_ = di3_ - di4_;
      ci3_ = di3_ + di4_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + 
      cr2_ + cr3_;
      ch_[i_ - 1 + ((*ido_)) * ((0) + (5) * ((k_ - 1)))] = cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + ci2_ + 
      ci3_;
      tr2_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + tr11_ * cr2_ + tr12_ * cr3_;
      ti2_ = cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + tr11_ * ci2_ + tr12_ * ci3_;
      tr3_ = cc_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + tr12_ * cr2_ + tr11_ * cr3_;
      ti3_ = cc_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))] + tr12_ * ci2_ + tr11_ * ci3_;
      tr5_ = ti11_ * cr5_ + ti12_ * cr4_;
      ti5_ = ti11_ * ci5_ + ti12_ * ci4_;
      tr4_ = ti12_ * cr5_ - ti11_ * cr4_;
      ti4_ = ti12_ * ci5_ - ti11_ * ci4_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] = tr2_ + tr5_;
      ch_[ic_ - 1 - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] = tr2_ - tr5_;
      ch_[i_ - 1 + ((*ido_)) * ((2) + (5) * ((k_ - 1)))] = ti2_ + ti5_;
      ch_[ic_ - 1 + ((*ido_)) * ((1) + (5) * ((k_ - 1)))] = ti5_ - ti2_;
      ch_[i_ - 1 - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))] = tr3_ + tr4_;
      ch_[ic_ - 1 - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))] = tr3_ - tr4_;
      ch_[i_ - 1 + ((*ido_)) * ((4) + (5) * ((k_ - 1)))] = ti3_ + ti4_;
      ch_[ic_ - 1 + ((*ido_)) * ((3) + (5) * ((k_ - 1)))] = ti4_ - ti3_;
    }
  }
  _l0:;
  __calls[51].calls++;
  return 0;
}

int_4 _radfg (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ c1_, real_8 _p_ 
c2_, real_8 _p_ ch_, real_8 _p_ ch2_, real_8 _p_ wa_)
{
  static int_4 ipph_, ipp2_, idp2_, nbd_, ik_, j_, k_, is_, idij_, i_, jc_, l_, lc_, j2_, ic_;
  static real_8 tpi_, arg_, dcp_, dsp_, ar1_, ai1_, ar1h_, dc2_, ds2_, ar2_, ai2_, ar2h_;
  int_4 _data_k_19;
#define _data_n_19 1
  static real_8 _data_l_19[_data_n_19] = {
    6.28318530717958647692e0
  };
  if (__calls[52].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    tpi_ = _data_l_19[_data_k_19++];
  }
  arg_ = tpi_ / (real_4) ((*ip_));
  dcp_ = cos (arg_);
  dsp_ = sin (arg_);
  ipph_ = ((*ip_) + 1) / 2;
  ipp2_ = (*ip_) + 2;
  idp2_ = (*ido_) + 2;
  nbd_ = ((*ido_) - 1) / 2;
  if ((*ido_) == 1) {
    goto _l119;
  }
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    ch2_[ik_ - 1 + ((*idl1_)) * ((0))] = c2_[ik_ - 1 + ((*idl1_)) * ((0))];
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
    }
  }
  if (nbd_ > (*l1_)) {
    goto _l107;
  }
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    idij_ = is_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * c1_[i_ - 1 - 1 + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] + wa_[idij_ - 1] * c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((j_ - 1)))] - wa_[idij_ - 1] * c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  goto _l111;
  _l107:;
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = is_;
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * c1_[i_ - 1 - 1 + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] + wa_[idij_ - 1] * c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
        ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = wa_[idij_ - 1 - 1] * c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((j_ - 1)))] - wa_[idij_ - 1] * c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  _l111:;
  if (nbd_ < (*l1_)) {
    goto _l115;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] + ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] - ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 
        1)))] + ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1)))] - ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  goto _l121;
  _l115:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] + ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        c1_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] - ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 
        1)))] + ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        c1_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1)))] - ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  goto _l121;
  _l119:;
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    c2_[ik_ - 1 + ((*idl1_)) * ((0))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))];
  }
  _l121:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] = ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))] + 
      ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
      c1_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] = ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))] - 
      ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
    }
  }
  ar1_ = 1.0;
  ai1_ = 0.0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    ar1h_ = dcp_ * ar1_ - dsp_ * ai1_;
    ai1_ = dcp_ * ai1_ + dsp_ * ar1_;
    ar1_ = ar1h_;
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      ch2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] = c2_[ik_ - 1 + ((*idl1_)) * ((0))] + ar1_ * c2_[ik_ - 1 + ((*idl1_)) * ((1))]
      ;
      ch2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] = ai1_ * c2_[ik_ - 1 + ((*idl1_)) * (((*ip_) - 1))];
    }
    dc2_ = ar1_;
    ds2_ = ai1_;
    ar2_ = ar1_;
    ai2_ = ai1_;
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      ar2h_ = dc2_ * ar2_ - ds2_ * ai2_;
      ai2_ = dc2_ * ai2_ + ds2_ * ar2_;
      ar2_ = ar2h_;
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        ch2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] = ch2_[ik_ - 1 + ((*idl1_)) * ((l_ - 1))] + ar2_ * c2_[ik_ - 1 + ((*idl1_)) * 
        ((j_ - 1))];
        ch2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] = ch2_[ik_ - 1 + ((*idl1_)) * ((lc_ - 1))] + ai2_ * c2_[ik_ - 1 + ((*idl1_)) * 
        ((jc_ - 1))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      ch2_[ik_ - 1 + ((*idl1_)) * ((0))] = ch2_[ik_ - 1 + ((*idl1_)) * ((0))] + c2_[ik_ - 1 + ((*idl1_)) * ((j_ - 1))];
    }
  }
  if ((*ido_) < (*l1_)) {
    goto _l132;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      cc_[i_ - 1 + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))];
    }
  }
  goto _l135;
  _l132:;
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[i_ - 1 + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0)))];
    }
  }
  _l135:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[(*ido_) - 1 + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((j_ - 1)))];
      cc_[0 + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[0 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))]
      ;
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  if (nbd_ < (*l1_)) {
    goto _l141;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ic_ = idp2_ - i_;
        cc_[i_ - 1 - 1 + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((j_ - 1)))] + ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        cc_[ic_ - 1 - 1 + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((j_ - 1)))] - ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        cc_[i_ - 1 + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] + ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        cc_[ic_ - 1 + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1)))] - ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  goto _l0;
  _l141:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        cc_[i_ - 1 - 1 + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((j_ - 1)))] + ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        cc_[ic_ - 1 - 1 + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((j_ - 1)))] - ch_[i_ - 1 - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        cc_[i_ - 1 + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1)))] + ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1)))];
        cc_[ic_ - 1 + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1)))] = ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1)))] - ch_[i_ - 1 + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1)))];
      }
    }
  }
  _l0:;
  __calls[52].calls++;
  return 0;
}

int_4 _rfftb1 (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, int_4 _p_ ifac_)
{
  static int_4 nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, idl1_, ix2_, ix3_, ix4_, i_;
  nf_ = ifac_[1];
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = ifac_[k1_ + 2 - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    idl1_ = ido_ * l1_;
    if (ip_ != 4) {
      goto _l103;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _radb4 (&ido_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l102;
    _l101:;
    (void) _radb4 (&ido_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    _l102:;
    na_ = 1 - na_;
    goto _l115;
    _l103:;
    if (ip_ != 2) {
      goto _l106;
    }
    if (na_ != 0) {
      goto _l104;
    }
    (void) _radb2 (&ido_, &l1_, c_, ch_, &wa_[iw_ - 1]);
    goto _l105;
    _l104:;
    (void) _radb2 (&ido_, &l1_, ch_, c_, &wa_[iw_ - 1]);
    _l105:;
    na_ = 1 - na_;
    goto _l115;
    _l106:;
    if (ip_ != 3) {
      goto _l109;
    }
    ix2_ = iw_ + ido_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _radb3 (&ido_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l108;
    _l107:;
    (void) _radb3 (&ido_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    _l108:;
    na_ = 1 - na_;
    goto _l115;
    _l109:;
    if (ip_ != 5) {
      goto _l112;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    ix4_ = ix3_ + ido_;
    if (na_ != 0) {
      goto _l110;
    }
    (void) _radb5 (&ido_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    goto _l111;
    _l110:;
    (void) _radb5 (&ido_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    _l111:;
    na_ = 1 - na_;
    goto _l115;
    _l112:;
    if (na_ != 0) {
      goto _l113;
    }
    (void) _radbg (&ido_, &ip_, &l1_, &idl1_, c_, c_, c_, ch_, ch_, &wa_[iw_ - 1]);
    goto _l114;
    _l113:;
    (void) _radbg (&ido_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, c_, c_, &wa_[iw_ - 1]);
    _l114:;
    if (ido_ == 1) {
      na_ = 1 - na_;
    }
    _l115:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * ido_;
  }
  if (na_ == 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    c_[i_ - 1] = ch_[i_ - 1];
  }
  _l0:;
  __calls[53].calls++;
  return 0;
}

int_4 _rfftb (int_4 _p_ n_, real_4 _p_ r_, real_4 _p_ wsave_)
{
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _rfftb1 (n_, r_, wsave_, &wsave_[(*n_) + 1 - 1], &wsave_[2 * (*n_) + 1 - 1]);
  _l0:;
  __calls[54].calls++;
  return 0;
}

int_4 _rfftf1 (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, int_4 _p_ ifac_)
{
  static int_4 nf_, na_, l2_, iw_, k1_, kh_, ip_, l1_, ido_, idl1_, ix2_, ix3_, ix4_, i_;
  nf_ = ifac_[1];
  na_ = 1;
  l2_ = (*n_);
  iw_ = (*n_);
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    kh_ = nf_ - k1_;
    ip_ = ifac_[kh_ + 3 - 1];
    l1_ = l2_ / ip_;
    ido_ = (*n_) / l2_;
    idl1_ = ido_ * l1_;
    iw_ = iw_ - (ip_ - 1) * ido_;
    na_ = 1 - na_;
    if (ip_ != 4) {
      goto _l102;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _radf4 (&ido_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l110;
    _l101:;
    (void) _radf4 (&ido_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l110;
    _l102:;
    if (ip_ != 2) {
      goto _l104;
    }
    if (na_ != 0) {
      goto _l103;
    }
    (void) _radf2 (&ido_, &l1_, c_, ch_, &wa_[iw_ - 1]);
    goto _l110;
    _l103:;
    (void) _radf2 (&ido_, &l1_, ch_, c_, &wa_[iw_ - 1]);
    goto _l110;
    _l104:;
    if (ip_ != 3) {
      goto _l106;
    }
    ix2_ = iw_ + ido_;
    if (na_ != 0) {
      goto _l105;
    }
    (void) _radf3 (&ido_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l110;
    _l105:;
    (void) _radf3 (&ido_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l110;
    _l106:;
    if (ip_ != 5) {
      goto _l108;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    ix4_ = ix3_ + ido_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _radf5 (&ido_, &l1_, c_, ch_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    goto _l110;
    _l107:;
    (void) _radf5 (&ido_, &l1_, ch_, c_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    goto _l110;
    _l108:;
    if (ido_ == 1) {
      na_ = 1 - na_;
    }
    if (na_ != 0) {
      goto _l109;
    }
    (void) _radfg (&ido_, &ip_, &l1_, &idl1_, c_, c_, c_, ch_, ch_, &wa_[iw_ - 1]);
    na_ = 1;
    goto _l110;
    _l109:;
    (void) _radfg (&ido_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, c_, c_, &wa_[iw_ - 1]);
    na_ = 0;
    _l110:;
    l2_ = l1_;
  }
  if (na_ == 1) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    c_[i_ - 1] = ch_[i_ - 1];
  }
  _l0:;
  __calls[55].calls++;
  return 0;
}

int_4 _rfftf (int_4 _p_ n_, real_4 _p_ r_, real_4 _p_ wsave_)
{
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _rfftf1 (n_, r_, wsave_, &wsave_[(*n_) + 1 - 1], &wsave_[2 * (*n_) + 1 - 1]);
  _l0:;
  __calls[56].calls++;
  return 0;
}

int_4 _rffti1 (int_4 _p_ n_, real_8 _p_ wa_, int_4 _p_ ifac_)
{
  static int_4 ntryh_[4], nl_, nf_, j_, ntry_, nq_, nr_, i_, ib_, is_, nfm1_, l1_, k1_, ip_, ld_, l2_, ido_, ipm_, ii_;
  static real_8 tpi_, argh_, argld_, fi_, arg_;
  int_4 _data_k_20, $0_, $1_;
#define _data_n_20 4
  static int_4 _data_l_20[_data_n_20] = {
    4,
    2,
    3,
    5
  };
  if (__calls[57].calls == 0) {
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ntryh_[0] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ntryh_[1] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ntryh_[2] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ntryh_[3] = _data_l_20[_data_k_20++];
  }
  nl_ = (*n_);
  nf_ = 0;
  j_ = 0;
  _l101:;
  j_ = j_ + 1;
  $0_ = j_ - 4;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ntry_ = ntryh_[j_ - 1];
  goto _l104;
  _l103:;
  ntry_ = ntry_ + 2;
  _l104:;
  nq_ = nl_ / ntry_;
  nr_ = nl_ - ntry_ * nq_;
  $1_ = nr_;
  if ($1_ < 0) {
    goto _l101;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  nf_ = nf_ + 1;
  ifac_[nf_ + 2 - 1] = ntry_;
  nl_ = nq_;
  if (ntry_ != 2) {
    goto _l107;
  }
  if (nf_ == 1) {
    goto _l107;
  }
  for (i_ = 2; i_ <= nf_; (i_)++) {
    ib_ = nf_ - i_ + 2;
    ifac_[ib_ + 2 - 1] = ifac_[ib_ + 1 - 1];
  }
  ifac_[2] = 2;
  _l107:;
  if (nl_ != 1) {
    goto _l104;
  }
  ifac_[0] = (*n_);
  ifac_[1] = nf_;
  tpi_ = 6.2831853071795865;
  argh_ = tpi_ / (real_4) ((*n_));
  is_ = 0;
  nfm1_ = nf_ - 1;
  l1_ = 1;
  if (nfm1_ == 0) {
    goto _l0;
  }
  for (k1_ = 1; k1_ <= nfm1_; (k1_)++) {
    ip_ = ifac_[k1_ + 2 - 1];
    ld_ = 0;
    l2_ = l1_ * ip_;
    ido_ = (*n_) / l2_;
    ipm_ = ip_ - 1;
    for (j_ = 1; j_ <= ipm_; (j_)++) {
      ld_ = ld_ + l1_;
      i_ = is_;
      argld_ = (real_4) (ld_) * argh_;
      fi_ = 0.0;
      for (ii_ = 3; (2 > 0 ? ii_ <= ido_ : ii_ >= ido_); ii_ += 2) {
        i_ = i_ + 2;
        fi_ = fi_ + 1.0e0;
        arg_ = fi_ * argld_;
        wa_[i_ - 1 - 1] = cos (arg_);
        wa_[i_ - 1] = sin (arg_);
      }
      is_ = is_ + ido_;
    }
    l1_ = l2_;
  }
  _l0:;
  __calls[57].calls++;
  return 0;
}

int_4 _rffti (int_4 _p_ n_, real_4 _p_ wsave_)
{
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _rffti1 (n_, &wsave_[(*n_) + 1 - 1], &wsave_[2 * (*n_) + 1 - 1]);
  _l0:;
  __calls[58].calls++;
  return 0;
}

int_4 _sinqb (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_)
{
  static int_4 ns2_, k_, kc_;
  static real_4 xhold_;
  if ((*n_) > 1) {
    goto _l101;
  }
  x_[0] = 4.0 * x_[0];
  goto _l0;
  _l101:;
  ns2_ = (*n_) / 2;
  for (k_ = 2; (2 > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += 2) {
    x_[k_ - 1] = -x_[k_ - 1];
  }
  (void) _cosqb (n_, x_, wsave_);
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = (*n_) - k_;
    xhold_ = x_[k_ - 1];
    x_[k_ - 1] = x_[kc_ + 1 - 1];
    x_[kc_ + 1 - 1] = xhold_;
  }
  _l0:;
  __calls[59].calls++;
  return 0;
}

int_4 _sinqf (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_)
{
  static int_4 ns2_, k_, kc_;
  static real_4 xhold_;
  if ((*n_) == 1) {
    goto _l0;
  }
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = (*n_) - k_;
    xhold_ = x_[k_ - 1];
    x_[k_ - 1] = x_[kc_ + 1 - 1];
    x_[kc_ + 1 - 1] = xhold_;
  }
  (void) _cosqf (n_, x_, wsave_);
  for (k_ = 2; (2 > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += 2) {
    x_[k_ - 1] = -x_[k_ - 1];
  }
  _l0:;
  __calls[60].calls++;
  return 0;
}

int_4 _sinqi (int_4 _p_ n_, real_4 _p_ wsave_)
{
  (void) _cosqi (n_, wsave_);
  __calls[61].calls++;
  return 0;
}

int_4 _sint1 (int_4 _p_ n_, real_8 _p_ war_, real_8 _p_ was_, real_8 _p_ xh_, real_8 _p_ x_, int_4 _p_ ifac_)
{
  static int_4 i_, np1_, ns2_, k_, kc_, modn_;
  static real_8 sqrt3_, xhold_, t1_, t2_;
  int_4 _data_k_21, $0_;
#define _data_n_21 1
  static real_8 _data_l_21[_data_n_21] = {
    1.73205080756887729352e0
  };
  if (__calls[62].calls == 0) {
    _data_k_21 = 0;
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    sqrt3_ = _data_l_21[_data_k_21++];
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    xh_[i_ - 1] = war_[i_ - 1];
    war_[i_ - 1] = x_[i_ - 1];
  }
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  xh_[0] = xh_[0] + xh_[0];
  goto _l106;
  _l102:;
  xhold_ = sqrt3_ * (xh_[0] + xh_[1]);
  xh_[1] = sqrt3_ * (xh_[0] - xh_[1]);
  xh_[0] = xhold_;
  goto _l106;
  _l103:;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  x_[0] = 0.0;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = xh_[k_ - 1] - xh_[kc_ - 1];
    t2_ = was_[k_ - 1] * (xh_[k_ - 1] + xh_[kc_ - 1]);
    x_[k_ + 1 - 1] = t1_ + t2_;
    x_[kc_ + 1 - 1] = t2_ - t1_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    x_[ns2_ + 2 - 1] = 4.0e0 * xh_[ns2_ + 1 - 1];
  }
  (void) _rfftf1 (&np1_, x_, xh_, war_, ifac_);
  xh_[0] = 0.5e0 * x_[0];
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xh_[i_ - 1 - 1] = -x_[i_ - 1];
    xh_[i_ - 1] = xh_[i_ - 2 - 1] + x_[i_ - 1 - 1];
  }
  if (modn_ != 0) {
    goto _l106;
  }
  xh_[(*n_) - 1] = -x_[(*n_) + 1 - 1];
  _l106:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = war_[i_ - 1];
    war_[i_ - 1] = xh_[i_ - 1];
  }
  __calls[62].calls++;
  return 0;
}

int_4 _sint (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ wsave_)
{
  static int_4 np1_, ns2_, kw_, k_, kc_, modn_, nf_, i_;
  static real_4 sqrt3_, xh_, t1_, t2_;
  int_4 $0_;
  sqrt3_ = 1.7320508;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  x_[0] = x_[0] + x_[0];
  goto _l0;
  _l102:;
  xh_ = sqrt3_ * (x_[0] + x_[1]);
  x_[1] = sqrt3_ * (x_[0] - x_[1]);
  x_[0] = xh_;
  goto _l0;
  _l103:;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  wsave_[0] = 0.0;
  kw_ = np1_;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kw_ = kw_ + 1;
    kc_ = np1_ - k_;
    t1_ = x_[k_ - 1] - x_[kc_ - 1];
    t2_ = wsave_[kw_ - 1] * (x_[k_ - 1] + x_[kc_ - 1]);
    wsave_[k_ + 1 - 1] = t1_ + t2_;
    wsave_[kc_ + 1 - 1] = t2_ - t1_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    wsave_[ns2_ + 2 - 1] = 4.0 * x_[ns2_ + 1 - 1];
  }
  nf_ = np1_ + ns2_ + 1;
  (void) _rfftf (&np1_, wsave_, &wsave_[nf_ - 1]);
  x_[0] = .5 * wsave_[0];
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    x_[i_ - 1 - 1] = -wsave_[i_ - 1];
    x_[i_ - 1] = x_[i_ - 2 - 1] + wsave_[i_ - 1 - 1];
  }
  if (modn_ != 0) {
    goto _l0;
  }
  x_[(*n_) - 1] = -wsave_[(*n_) + 1 - 1];
  _l0:;
  __calls[63].calls++;
  return 0;
}

int_4 _sinti (int_4 _p_ n_, real_4 _p_ wsave_)
{
  static int_4 np1_, ns2_, ks_, kf_, k_;
  static real_4 pi_, dt_, fk_;
  if ((*n_) <= 1) {
    goto _l0;
  }
  pi_ = 3.1415927;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  dt_ = pi_ / np1_;
  ks_ = (*n_) + 2;
  kf_ = ks_ + ns2_ - 1;
  fk_ = 0.0;
  for (k_ = ks_; k_ <= kf_; (k_)++) {
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = 2.0 * sinf (fk_ * dt_);
  }
  (void) _rffti (&np1_, &wsave_[kf_ + 1 - 1]);
  _l0:;
  __calls[64].calls++;
  return 0;
}

int_4 _zfftb (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ wsave_)
{
  static int_4 iw1_, iw2_;
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  iw2_ = iw1_ + (*n_) + (*n_);
  (void) _cfftb1 (n_, c_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw2_ - 1]);
  _l0:;
  __calls[65].calls++;
  return 0;
}

int_4 _zfftf (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ wsave_)
{
  static int_4 iw1_, iw2_;
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  iw2_ = iw1_ + (*n_) + (*n_);
  (void) _cfftf1 (n_, c_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw2_ - 1]);
  _l0:;
  __calls[66].calls++;
  return 0;
}

int_4 _zffti (int_4 _p_ n_, real_8 _p_ wsave_)
{
  static int_4 iw1_, iw2_;
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  iw2_ = iw1_ + (*n_) + (*n_);
  (void) _cffti1 (n_, &wsave_[iw1_ - 1], &wsave_[iw2_ - 1]);
  _l0:;
  __calls[67].calls++;
  return 0;
}

