//! @file mathlib-fftpack5.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 220 subprograms from FFTPACK5

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// C1F2KB CMF2KF COSTB1 DCFFT2 DCOSQM DMRADF DRFFT1 DSINTM MRFTI1 RFFTI1
// C1F2KF CMF3KB COSTF1 DCFFTM DCOSQM DMRADF DRFFT2 DSINTM MSNTB1 RFFTMB
// C1F3KB CMF3KF COSTMB DCFFTM DCOST1 DMRADF DRFFT2 DTABLE MSNTF1 RFFTMF
// C1F3KF CMF4KB COSTMF DCFFTM DCOST1 DMRADF DRFFT2 DW2R   R1F2KB RFFTMI
// C1F4KB CMF4KF COSTMI DCMF2K DCOST1 DMRFTB DRFFTB FACTOR R1F2KF SINQ1B
// C1F4KF CMF5KB DC1F2K DCMF2K DCOSTB DMRFTF DRFFTF MCFTI1 R1F3KB SINQ1F
// C1F5KB CMF5KF DC1F2K DCMF3K DCOSTF DMRFTI DRFFTI MCSQB1 R1F3KF SINQ1I
// C1F5KF CMFGKB DC1F3K DCMF3K DCOSTM DMSNTB DRFFTM MCSQF1 R1F4KB SINQMB
// C1FGKB CMFGKF DC1F3K DCMF4K DCOSTM DMSNTF DRFFTM MCSTB1 R1F4KF SINQMF
// C1FGKF CMFM1B DC1F4K DCMF4K DCOSTM DR1F2K DRFFTM MCSTF1 R1F5KB SINQMI
// C1FM1B CMFM1F DC1F4K DCMF5K DFACTO DR1F2K DSINQ1 MRADB2 R1F5KF SINT1B
// C1FM1F COSQ1B DC1F5K DCMF5K DMCFTI DR1F3K DSINQ1 MRADB3 R1FGKB SINT1F
// CFFT1B COSQ1F DC1F5K DCMFGK DMCSQB DR1F3K DSINQ1 MRADB4 R1FGKF SINT1I
// CFFT1F COSQ1I DC1FGK DCMFGK DMCSQF DR1F4K DSINQM MRADB5 R2W    SINTB1
// CFFT1I COSQB1 DC1FGK DCMFM1 DMCSTB DR1F4K DSINQM MRADBG RFFT1B SINTF1
// CFFT2B COSQF1 DC1FM1 DCMFM1 DMCSTF DR1F5K DSINQM MRADF2 RFFT1F SINTMB
// CFFT2F COSQMB DC1FM1 DCOSQ1 DMRADB DR1F5K DSINT1 MRADF3 RFFT1I SINTMF
// CFFT2I COSQMF DCFFT1 DCOSQ1 DMRADB DR1FGK DSINT1 MRADF4 RFFT2B SINTMI
// CFFTMB COSQMI DCFFT1 DCOSQ1 DMRADB DR1FGK DSINT1 MRADF5 RFFT2F TABLES
// CFFTMF COST1B DCFFT1 DCOSQB DMRADB DR2W   DSINTB MRADFG RFFT2I W2R
// CFFTMI COST1F DCFFT2 DCOSQF DMRADB DRFFT1 DSINTF MRFTB1 RFFTB1 XERCON
// CMF2KB COST1I DCFFT2 DCOSQM DMRADF DRFFT1 DSINTM MRFTF1 RFFTF1 XERFFT

// Source: https://people.sc.fsu.edu/~jburkardt/f77_src/fftpack5.1/fftpack5.1.html
// 
// FFTPACK5.1, a FORTRAN77 code which computes the Fast Fourier Transform, by Paul Swarztrauber and 
// Dick Valent.
// 
// Special features include:
// 
//     Real or complex data can be handled;
//     Separate routines for forward analysis (data => Fourier coefficients) and backward analysis 
// (Fourier coefficients => data);
//     Sine and cosine transform routines;
//     Quarter wave sine and cosine transform routines;
//     The amount of data is NOT required to be a power of 2.
// 
// Routines in the library come in groups of three:
// 
//     An initialization routine;
//     The forward computational routine (data to FFT coefficients);
//     The backward computational routine (FFT coefficients to data).
// 
// The following table shows how the names of the routines in each group:
// 
// Initialization      Forward      Backward      Purpose
// CFFT1I              CFFT1F       CFFT1B        FFT for complex 1D data
// CFFT2I              CFFT2F       CFFT2B        FFT for complex 2D data
// CFFTMI              CFFTMF       CFFTMB        FFT for complex multi-D data
// COSQ1I              COSQ1F       COSQ1B        Even function 1D quarter-cosine FFT
// COSQMI              COSQMF       COSQMB        Even function 1D quarter-cosine FFT
// COST1I              COST1F       COST1B        Even function 1D cosine FFT
// COSTMI              COSTMF       COSTMB        Even function 1D cosine FFT
// RFFT1I              RFFT1F       RFFT1B        FFT for real 1D data
// RFFT2I              RFFT2F       RFFT2B        FFT for real 2D data
// RFFTMI              RFFTMF       RFFTMB        FFT for real multi-D data
// SINQ1I              SINQ1F       SINQ1B        Even function 1D quarter-sine FFT
// SINQMI              SINQMF       SINQMB        Even function 1D quarter-sine FFT
// SINT1I              SINT1F       SINT1B        Even function 1D sine FFT
// SINTMI              SINTMF       SINTMB        Even function 1D sine FFT
// 
// Bugfixes from FFTPACK 5.0 to FFTPACK 5.1
// 
// The functionality of FFTPACK 5.1 is identical with the previous version 5.0.
// The following bugfixes have been applied:
// 
// Corrected index error for high-level routines [CR]FFT[12][BFI] requiring WSAVE array, and all 
// dependent routines to which LWSAVE is passed. Namely, in LWSAV = L + LOG(REAL(INT(L))) + 4 
// definitions, the summand term LOG(REAL(INT(L))) has been corrected to LOG(REAL(INT(L)/LOG(2.)).
// 
// Corrected index error in routime C1FM1F at label 56, where array offset was declared 1 that should 
// have been 2. This resulted in C1FFTF transforms of length N calculated incorrectly, where N is any 
// prime .GT. 5, or N=7*M, M .GE. 6.
// 
// Corrected RFFT2x routines by rewriting them. The backward transform followed by forward now returns 
// identity. Input argument LENSAV must be be at least L + 3*M + INT(LOG(REAL(L))/LOG(2.)) + 
// 2*INT(LOG(REAL(M))/LOG(2.)) +12. Previously, the required value was smaller.

// The license for FFTPACK5 Fortran source code is:
//
// Source: https://people.sc.fsu.edu/~jburkardt/f77_src/fftpack5.1/fftpack5.1.html
// 
// Licensed under the GNU General Public License (GPL).
// Copyright (C) 1995-2004, Scientific Computing Division,
// University Corporation for Atmospheric Research.
// 

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "DCFFT1B "
#define _dc_1 "DCFFT1F "
#define _dc_2 "DCFFTMI "
#define _dc_3 "DCFFT2B"
#define _dc_4 "DCFFT2F"
#define _dc_5 "DCFFT2I"
#define _dc_6 "DCFFTMB "
#define _dc_7 "DCFFTMF "
#define _dc_8 "DCOSQ1B"
#define _dc_9 "DCOSQ1F"
#define _dc_10 "DCOSQ1I"
#define _dc_11 "DCOSQB1"
#define _dc_12 "DCOSQF1"
#define _dc_13 "DCOSQMB"
#define _dc_14 "DCOSQMF"
#define _dc_15 "DCOSQMI"
#define _dc_16 "DCOST1B"
#define _dc_17 "DCOST1F"
#define _dc_18 "DCOST1I"
#define _dc_19 "DCOSTB1"
#define _dc_20 "DCOSTF1"
#define _dc_21 "DCOSTMB"
#define _dc_22 "DCOSTMF"
#define _dc_23 "DCOSTMI"
#define _dc_24 "DMCSQB1"
#define _dc_25 "DMCSQF1"
#define _dc_26 "DMCSTB1"
#define _dc_27 "DMCSTF1"
#define _dc_28 "DMSNTB1"
#define _dc_29 "DMSNTF1"
#define _dc_30 "DRFFT1B "
#define _dc_31 "DRFFT1F "
#define _dc_32 "DRFFT1I "
#define _dc_33 "DRFFT2F"
#define _dc_34 "DRFFT2B"
#define _dc_35 "DRFFT2I"
#define _dc_36 "DRFFTMB "
#define _dc_37 "DRFFTMF "
#define _dc_38 "DRFFTMI "
#define _dc_39 "DSINQ1B"
#define _dc_40 "DSINQ1F"
#define _dc_41 "DSINQ1I"
#define _dc_42 "DSINQMB"
#define _dc_43 "DSINQMF"
#define _dc_44 "DSINQMI"
#define _dc_45 "DSINT1B"
#define _dc_46 "DSINT1F"
#define _dc_47 "DSINT1I"
#define _dc_48 "DSINTB1"
#define _dc_49 "DSINTF1"
#define _dc_50 "DSINTMB"
#define _dc_51 "DSINTMF"
#define _dc_52 "DSINTMI"
#define _dc_53 " ** On entry to "
#define _dc_54 " parameter number "
#define _dc_55 " had an illegal value"
#define _dc_56 " parameters LOT, JUMP, N and INC are inconsistent"
#define _dc_57 " parameter L is greater than LDIM"
#define _dc_58 " parameter M is greater than MDIM"
#define _dc_59 " ** Within "
#define _dc_60 " input error returned by lower level routine"
#define _dc_61 " parameter LDIM is less than 2*(L/2+1)"
#define _dc_62 "CFFT1B "
#define _dc_63 "CFFT1F "
#define _dc_64 "CFFTMI "
#define _dc_65 "CFFT2B"
#define _dc_66 "CFFT2F"
#define _dc_67 "CFFT2I"
#define _dc_68 "CFFTMB "
#define _dc_69 "CFFTMF "
#define _dc_70 "COSQ1B"
#define _dc_71 "COSQ1F"
#define _dc_72 "COSQ1I"
#define _dc_73 "COSQB1"
#define _dc_74 "COSQF1"
#define _dc_75 "COSQMB"
#define _dc_76 "COSQMF"
#define _dc_77 "COSQMI"
#define _dc_78 "COST1B"
#define _dc_79 "COST1F"
#define _dc_80 "COST1I"
#define _dc_81 "COSTB1"
#define _dc_82 "COSTF1"
#define _dc_83 "COSTMB"
#define _dc_84 "COSTMF"
#define _dc_85 "COSTMI"
#define _dc_86 "MCSQB1"
#define _dc_87 "MCSQF1"
#define _dc_88 "MCSTB1"
#define _dc_89 "MCSTF1"
#define _dc_90 "MSNTB1"
#define _dc_91 "MSNTF1"
#define _dc_92 "RFFT1B "
#define _dc_93 "RFFT1F "
#define _dc_94 "RFFT1I "
#define _dc_95 "RFFT2F"
#define _dc_96 "RFFT2B"
#define _dc_97 "RFFT2I"
#define _dc_98 "RFFTMB "
#define _dc_99 "RFFTMF "
#define _dc_100 "RFFTMI "
#define _dc_101 "SINQ1B"
#define _dc_102 "SINQ1F"
#define _dc_103 "SINQ1I"
#define _dc_104 "SINQMB"
#define _dc_105 "SINQMF"
#define _dc_106 "SINQMI"
#define _dc_107 "SINT1B"
#define _dc_108 "SINT1F"
#define _dc_109 "SINT1I"
#define _dc_110 "SINTB1"
#define _dc_111 "SINTF1"
#define _dc_112 "SINTMB"
#define _dc_113 "SINTMF"
#define _dc_114 "SINTMI"
static FORMAT *__fmt_a = NULL;
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
#define __ncalls 221
static CALLS __calls[__ncalls] = {
  {"dc1f2kb", 0}, // subroutine
  {"dc1f2kf", 0}, // subroutine
  {"dc1f3kb", 0}, // subroutine
  {"dc1f3kf", 0}, // subroutine
  {"dc1f4kb", 0}, // subroutine
  {"dc1f4kf", 0}, // subroutine
  {"dc1f5kb", 0}, // subroutine
  {"dc1f5kf", 0}, // subroutine
  {"dc1fgkb", 0}, // subroutine
  {"dc1fgkf", 0}, // subroutine
  {"dc1fm1b", 0}, // subroutine
  {"dc1fm1f", 0}, // subroutine
  {"dcfft1b", 0}, // subroutine
  {"dcfft1f", 0}, // subroutine
  {"dcfft1i", 0}, // subroutine
  {"dcfft2b", 0}, // subroutine
  {"dcfft2f", 0}, // subroutine
  {"dcfft2i", 0}, // subroutine
  {"dcfftmb", 0}, // subroutine
  {"dcfftmf", 0}, // subroutine
  {"dcfftmi", 0}, // subroutine
  {"dcmf2kb", 0}, // subroutine
  {"dcmf2kf", 0}, // subroutine
  {"dcmf3kb", 0}, // subroutine
  {"dcmf3kf", 0}, // subroutine
  {"dcmf4kb", 0}, // subroutine
  {"dcmf4kf", 0}, // subroutine
  {"dcmf5kb", 0}, // subroutine
  {"dcmf5kf", 0}, // subroutine
  {"dcmfgkb", 0}, // subroutine
  {"dcmfgkf", 0}, // subroutine
  {"dcmfm1b", 0}, // subroutine
  {"dcmfm1f", 0}, // subroutine
  {"dcosq1b", 0}, // subroutine
  {"dcosq1f", 0}, // subroutine
  {"dcosq1i", 0}, // subroutine
  {"dcosqb1", 0}, // subroutine
  {"dcosqf1", 0}, // subroutine
  {"dcosqmb", 0}, // subroutine
  {"dcosqmf", 0}, // subroutine
  {"dcosqmi", 0}, // subroutine
  {"dcost1b", 0}, // subroutine
  {"dcost1f", 0}, // subroutine
  {"dcost1i", 0}, // subroutine
  {"dcostb1", 0}, // subroutine
  {"dcostf1", 0}, // subroutine
  {"dcostmb", 0}, // subroutine
  {"dcostmf", 0}, // subroutine
  {"dcostmi", 0}, // subroutine
  {"dfactor", 0}, // subroutine
  {"dmcfti1", 0}, // subroutine
  {"dmcsqb1", 0}, // subroutine
  {"dmcsqf1", 0}, // subroutine
  {"dmcstb1", 0}, // subroutine
  {"dmcstf1", 0}, // subroutine
  {"dmradb2", 0}, // subroutine
  {"dmradb3", 0}, // subroutine
  {"dmradb4", 0}, // subroutine
  {"dmradb5", 0}, // subroutine
  {"dmradbg", 0}, // subroutine
  {"dmradf2", 0}, // subroutine
  {"dmradf3", 0}, // subroutine
  {"dmradf4", 0}, // subroutine
  {"dmradf5", 0}, // subroutine
  {"dmradfg", 0}, // subroutine
  {"dmrftb1", 0}, // subroutine
  {"dmrftf1", 0}, // subroutine
  {"dmrfti1", 0}, // subroutine
  {"dmsntb1", 0}, // subroutine
  {"dmsntf1", 0}, // subroutine
  {"dr1f2kb", 0}, // subroutine
  {"dr1f2kf", 0}, // subroutine
  {"dr1f3kb", 0}, // subroutine
  {"dr1f3kf", 0}, // subroutine
  {"dr1f4kb", 0}, // subroutine
  {"dr1f4kf", 0}, // subroutine
  {"dr1f5kb", 0}, // subroutine
  {"dr1f5kf", 0}, // subroutine
  {"dr1fgkb", 0}, // subroutine
  {"dr1fgkf", 0}, // subroutine
  {"dr2w", 0}, // subroutine
  {"drfft1b", 0}, // subroutine
  {"drfft1f", 0}, // subroutine
  {"drfft1i", 0}, // subroutine
  {"drfft2b", 0}, // subroutine
  {"drfft2f", 0}, // subroutine
  {"drfft2i", 0}, // subroutine
  {"drfftb1", 0}, // subroutine
  {"drfftf1", 0}, // subroutine
  {"drffti1", 0}, // subroutine
  {"drfftmb", 0}, // subroutine
  {"drfftmf", 0}, // subroutine
  {"drfftmi", 0}, // subroutine
  {"dsinq1b", 0}, // subroutine
  {"dsinq1f", 0}, // subroutine
  {"dsinq1i", 0}, // subroutine
  {"dsinqmb", 0}, // subroutine
  {"dsinqmf", 0}, // subroutine
  {"dsinqmi", 0}, // subroutine
  {"dsint1b", 0}, // subroutine
  {"dsint1f", 0}, // subroutine
  {"dsint1i", 0}, // subroutine
  {"dsintb1", 0}, // subroutine
  {"dsintf1", 0}, // subroutine
  {"dsintmb", 0}, // subroutine
  {"dsintmf", 0}, // subroutine
  {"dsintmi", 0}, // subroutine
  {"dtables", 0}, // subroutine
  {"dw2r", 0}, // subroutine
  {"xercon", 0}, // logical*4 function
  {"xerfft", 0}, // subroutine
  {"c1f2kb", 0}, // subroutine
  {"c1f2kf", 0}, // subroutine
  {"c1f3kb", 0}, // subroutine
  {"c1f3kf", 0}, // subroutine
  {"c1f4kb", 0}, // subroutine
  {"c1f4kf", 0}, // subroutine
  {"c1f5kb", 0}, // subroutine
  {"c1f5kf", 0}, // subroutine
  {"c1fgkb", 0}, // subroutine
  {"c1fgkf", 0}, // subroutine
  {"c1fm1b", 0}, // subroutine
  {"c1fm1f", 0}, // subroutine
  {"cfft1b", 0}, // subroutine
  {"cfft1f", 0}, // subroutine
  {"cfft1i", 0}, // subroutine
  {"cfft2b", 0}, // subroutine
  {"cfft2f", 0}, // subroutine
  {"cfft2i", 0}, // subroutine
  {"cfftmb", 0}, // subroutine
  {"cfftmf", 0}, // subroutine
  {"cfftmi", 0}, // subroutine
  {"cmf2kb", 0}, // subroutine
  {"cmf2kf", 0}, // subroutine
  {"cmf3kb", 0}, // subroutine
  {"cmf3kf", 0}, // subroutine
  {"cmf4kb", 0}, // subroutine
  {"cmf4kf", 0}, // subroutine
  {"cmf5kb", 0}, // subroutine
  {"cmf5kf", 0}, // subroutine
  {"cmfgkb", 0}, // subroutine
  {"cmfgkf", 0}, // subroutine
  {"cmfm1b", 0}, // subroutine
  {"cmfm1f", 0}, // subroutine
  {"cosq1b", 0}, // subroutine
  {"cosq1f", 0}, // subroutine
  {"cosq1i", 0}, // subroutine
  {"cosqb1", 0}, // subroutine
  {"cosqf1", 0}, // subroutine
  {"cosqmb", 0}, // subroutine
  {"cosqmf", 0}, // subroutine
  {"cosqmi", 0}, // subroutine
  {"cost1b", 0}, // subroutine
  {"cost1f", 0}, // subroutine
  {"cost1i", 0}, // subroutine
  {"costb1", 0}, // subroutine
  {"costf1", 0}, // subroutine
  {"costmb", 0}, // subroutine
  {"costmf", 0}, // subroutine
  {"costmi", 0}, // subroutine
  {"factor", 0}, // subroutine
  {"mcfti1", 0}, // subroutine
  {"mcsqb1", 0}, // subroutine
  {"mcsqf1", 0}, // subroutine
  {"mcstb1", 0}, // subroutine
  {"mcstf1", 0}, // subroutine
  {"mradb2", 0}, // subroutine
  {"mradb3", 0}, // subroutine
  {"mradb4", 0}, // subroutine
  {"mradb5", 0}, // subroutine
  {"mradbg", 0}, // subroutine
  {"mradf2", 0}, // subroutine
  {"mradf3", 0}, // subroutine
  {"mradf4", 0}, // subroutine
  {"mradf5", 0}, // subroutine
  {"mradfg", 0}, // subroutine
  {"mrftb1", 0}, // subroutine
  {"mrftf1", 0}, // subroutine
  {"mrfti1", 0}, // subroutine
  {"msntb1", 0}, // subroutine
  {"msntf1", 0}, // subroutine
  {"r1f2kb", 0}, // subroutine
  {"r1f2kf", 0}, // subroutine
  {"r1f3kb", 0}, // subroutine
  {"r1f3kf", 0}, // subroutine
  {"r1f4kb", 0}, // subroutine
  {"r1f4kf", 0}, // subroutine
  {"r1f5kb", 0}, // subroutine
  {"r1f5kf", 0}, // subroutine
  {"r1fgkb", 0}, // subroutine
  {"r1fgkf", 0}, // subroutine
  {"r2w", 0}, // subroutine
  {"rfft1b", 0}, // subroutine
  {"rfft1f", 0}, // subroutine
  {"rfft1i", 0}, // subroutine
  {"rfft2b", 0}, // subroutine
  {"rfft2f", 0}, // subroutine
  {"rfft2i", 0}, // subroutine
  {"rfftb1", 0}, // subroutine
  {"rfftf1", 0}, // subroutine
  {"rffti1", 0}, // subroutine
  {"rfftmb", 0}, // subroutine
  {"rfftmf", 0}, // subroutine
  {"rfftmi", 0}, // subroutine
  {"sinq1b", 0}, // subroutine
  {"sinq1f", 0}, // subroutine
  {"sinq1i", 0}, // subroutine
  {"sinqmb", 0}, // subroutine
  {"sinqmf", 0}, // subroutine
  {"sinqmi", 0}, // subroutine
  {"sint1b", 0}, // subroutine
  {"sint1f", 0}, // subroutine
  {"sint1i", 0}, // subroutine
  {"sintb1", 0}, // subroutine
  {"sintf1", 0}, // subroutine
  {"sintmb", 0}, // subroutine
  {"sintmf", 0}, // subroutine
  {"sintmi", 0}, // subroutine
  {"tables", 0}, // subroutine
  {"w2r", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _dc1f2kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, 
int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1f2kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, 
int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1f3kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, 
int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1f3kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, 
int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1f4kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, 
int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1f4kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, 
int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1f5kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, 
int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1f5kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, 
int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1fgkb (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_8 _p_ cc_, 
real_8 _p_ cc1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch1_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1fgkf (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_8 _p_ cc_, 
real_8 _p_ cc1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch1_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dc1fm1b (int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, real_4 _p_ 
fnf_, real_8 _p_ fac_);
prototype int_4 _dc1fm1f (int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, real_4 _p_ 
fnf_, real_8 _p_ fac_);
prototype int_4 _dcfft1b (int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, int_4 _p_ lenc_, real_8 _p_ wsave_, int_4 
_p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcfft1f (int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, int_4 _p_ lenc_, real_8 _p_ wsave_, int_4 
_p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcfft1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dcfft2b (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, complex_16 _p_ c_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcfft2f (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, complex_16 _p_ c_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcfft2i (int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dcfftmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, int_4 _p_ 
lenc_, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcfftmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, int_4 _p_ 
lenc_, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcfftmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dcmf2kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmf2kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmf3kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmf3kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmf4kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmf4kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmf5kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmf5kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmfgkb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, 
real_8 _p_ cc_, real_8 _p_ cc1_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch1_, int_4 _p_ im2_, int_4 
_p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmfgkf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, 
real_8 _p_ cc_, real_8 _p_ cc1_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch1_, int_4 _p_ im2_, int_4 
_p_ in2_, real_8 _p_ wa_);
prototype int_4 _dcmfm1b (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, real_8 _p_ 
ch_, real_8 _p_ wa_, real_4 _p_ fnf_, real_8 _p_ fac_);
prototype int_4 _dcmfm1f (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, real_8 _p_ 
ch_, real_8 _p_ wa_, real_4 _p_ fnf_, real_8 _p_ fac_);
prototype int_4 _dcosq1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcosq1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcosq1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dcosqb1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ 
ier_);
prototype int_4 _dcosqf1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ 
ier_);
prototype int_4 _dcosqmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcosqmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcosqmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dcost1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcost1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcost1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dcostb1 (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_4 _p_ work_, int_4 _p_ 
ier_);
prototype int_4 _dcostf1 (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_4 _p_ work_, int_4 _p_ 
ier_);
prototype int_4 _dcostmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcostmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dcostmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dfactor (int_4 _p_ n_, int_4 _p_ nf_, real_8 _p_ fac_);
prototype int_4 _dmcfti1 (int_4 _p_ n_, real_8 _p_ wa_, real_4 _p_ fnf_, real_8 _p_ fac_);
prototype int_4 _dmcsqb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ 
wsave_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _dmcsqf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ 
wsave_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _dmcstb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ 
wsave_, real_8 _p_ dsum_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _dmcstf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ 
wsave_, real_8 _p_ dsum_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _dmradb2 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_);
prototype int_4 _dmradb3 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _dmradb4 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_);
prototype int_4 _dmradb5 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _dmradbg (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, 
real_8 _p_ c1_, real_8 _p_ c2_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch2_, int_4 _p_ im2_, int_4 
_p_ in2_, real_8 _p_ wa_);
prototype int_4 _dmradf2 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_);
prototype int_4 _dmradf3 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _dmradf4 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_);
prototype int_4 _dmradf5 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _dmradfg (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, 
real_8 _p_ c1_, real_8 _p_ c2_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch2_, int_4 _p_ im2_, int_4 
_p_ in2_, real_8 _p_ wa_);
prototype int_4 _dmrftb1 (int_4 _p_ m_, int_4 _p_ im_, int_4 _p_ n_, int_4 _p_ in_, real_8 _p_ c_, real_8 _p_ ch_, 
real_8 _p_ wa_, real_8 _p_ fac_);
prototype int_4 _dmrftf1 (int_4 _p_ m_, int_4 _p_ im_, int_4 _p_ n_, int_4 _p_ in_, real_8 _p_ c_, real_8 _p_ ch_, 
real_8 _p_ wa_, real_8 _p_ fac_);
prototype int_4 _dmrfti1 (int_4 _p_ n_, real_8 _p_ wa_, real_8 _p_ fac_);
prototype int_4 _dmsntb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ 
wsave_, real_8 _p_ dsum_, real_8 _p_ xh_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _dmsntf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ 
wsave_, real_8 _p_ dsum_, real_8 _p_ xh_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _dr1f2kb (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_
, real_8 _p_ wa1_);
prototype int_4 _dr1f2kf (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_
, real_8 _p_ wa1_);
prototype int_4 _dr1f3kb (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_
, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _dr1f3kf (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_
, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _dr1f4kb (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_
, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_);
prototype int_4 _dr1f4kf (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_
, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_);
prototype int_4 _dr1f5kb (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_
, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _dr1f5kf (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_
, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _dr1fgkb (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ c1_
, real_8 _p_ c2_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dr1fgkf (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ c1_
, real_8 _p_ c2_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch2_, int_4 _p_ in2_, real_8 _p_ wa_);
prototype int_4 _dr2w (int_4 _p_ ldr_, int_4 _p_ ldw_, int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ r_, real_8 _p_ w_);
prototype int_4 _drfft1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ r_, int_4 _p_ lenr_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _drfft1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ r_, int_4 _p_ lenr_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _drfft1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _drfft2b (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ r_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _drfft2f (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ r_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _drfft2i (int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _drfftb1 (int_4 _p_ n_, int_4 _p_ in_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, real_8 _p_ fac_);
prototype int_4 _drfftf1 (int_4 _p_ n_, int_4 _p_ in_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, real_8 _p_ fac_);
prototype int_4 _drffti1 (int_4 _p_ n_, real_8 _p_ wa_, real_8 _p_ fac_);
prototype int_4 _drfftmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ r_, int_4 _p_ lenr_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _drfftmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ r_, int_4 _p_ lenr_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _drfftmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dsinq1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dsinq1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dsinq1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dsinqmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dsinqmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dsinqmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dsint1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dsint1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ 
lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dsint1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dsintb1 (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_8 _p_ xh_, real_4 _p_ 
work_, int_4 _p_ ier_);
prototype int_4 _dsintf1 (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_8 _p_ xh_, real_4 _p_ 
work_, int_4 _p_ ier_);
prototype int_4 _dsintmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dsintmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_
, real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _dsintmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _dtables (int_4 _p_ ido_, int_4 _p_ ip_, real_8 _p_ wa_);
prototype int_4 _dw2r (int_4 _p_ ldr_, int_4 _p_ ldw_, int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ r_, real_8 _p_ w_);
prototype logical_4 _xercon (int_4 _p_ inc_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ lot_);
prototype int_4 _xerfft (char _p_ srname_, int_4 _p_ info_);
prototype int_4 _c1f2kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, 
int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1f2kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, 
int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1f3kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, 
int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1f3kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, 
int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1f4kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, 
int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1f4kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, 
int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1f5kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, 
int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1f5kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, 
int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1fgkb (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_4 _p_ cc_, 
real_4 _p_ cc1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch1_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1fgkf (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_4 _p_ cc_, 
real_4 _p_ cc1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch1_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _c1fm1b (int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, real_4 _p_ ch_, real_4 _p_ wa_, real_4 _p_ 
fnf_, real_4 _p_ fac_);
prototype int_4 _c1fm1f (int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, real_4 _p_ ch_, real_4 _p_ wa_, real_4 _p_ 
fnf_, real_4 _p_ fac_);
prototype int_4 _cfft1b (int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, int_4 _p_ lenc_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cfft1f (int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, int_4 _p_ lenc_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cfft1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _cfft2b (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, complex_8 _p_ c_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cfft2f (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, complex_8 _p_ c_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cfft2i (int_4 _p_ l_, int_4 _p_ m_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _cfftmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, int_4 _p_ 
lenc_, real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cfftmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, int_4 _p_ 
lenc_, real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cfftmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _cmf2kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmf2kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmf3kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmf3kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmf4kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmf4kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmf5kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmf5kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, 
int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmfgkb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, 
real_4 _p_ cc_, real_4 _p_ cc1_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch1_, int_4 _p_ im2_, int_4 
_p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmfgkf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, 
real_4 _p_ cc_, real_4 _p_ cc1_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch1_, int_4 _p_ im2_, int_4 
_p_ in2_, real_4 _p_ wa_);
prototype int_4 _cmfm1b (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, real_4 _p_ 
ch_, real_4 _p_ wa_, real_4 _p_ fnf_, real_4 _p_ fac_);
prototype int_4 _cmfm1f (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, real_4 _p_ 
ch_, real_4 _p_ wa_, real_4 _p_ fnf_, real_4 _p_ fac_);
prototype int_4 _cosq1b (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cosq1f (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cosq1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _cosqb1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ 
ier_);
prototype int_4 _cosqf1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ 
ier_);
prototype int_4 _cosqmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cosqmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cosqmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _cost1b (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cost1f (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _cost1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _costb1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ 
ier_);
prototype int_4 _costf1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ 
ier_);
prototype int_4 _costmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _costmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _costmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _factor (int_4 _p_ n_, int_4 _p_ nf_, real_4 _p_ fac_);
prototype int_4 _mcfti1 (int_4 _p_ n_, real_4 _p_ wa_, real_4 _p_ fnf_, real_4 _p_ fac_);
prototype int_4 _mcsqb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ 
wsave_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _mcsqf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ 
wsave_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _mcstb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ 
wsave_, real_8 _p_ dsum_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _mcstf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ 
wsave_, real_8 _p_ dsum_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _mradb2 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_);
prototype int_4 _mradb3 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_);
prototype int_4 _mradb4 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_);
prototype int_4 _mradb5 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, real_4 _p_ wa4_);
prototype int_4 _mradbg (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_4 _p_ cc_, 
real_4 _p_ c1_, real_4 _p_ c2_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch2_, int_4 _p_ im2_, int_4 
_p_ in2_, real_4 _p_ wa_);
prototype int_4 _mradf2 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_);
prototype int_4 _mradf3 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_);
prototype int_4 _mradf4 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_);
prototype int_4 _mradf5 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, 
real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, real_4 _p_ wa4_);
prototype int_4 _mradfg (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_4 _p_ cc_, 
real_4 _p_ c1_, real_4 _p_ c2_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch2_, int_4 _p_ im2_, int_4 
_p_ in2_, real_4 _p_ wa_);
prototype int_4 _mrftb1 (int_4 _p_ m_, int_4 _p_ im_, int_4 _p_ n_, int_4 _p_ in_, real_4 _p_ c_, real_4 _p_ ch_, 
real_4 _p_ wa_, real_4 _p_ fac_);
prototype int_4 _mrftf1 (int_4 _p_ m_, int_4 _p_ im_, int_4 _p_ n_, int_4 _p_ in_, real_4 _p_ c_, real_4 _p_ ch_, 
real_4 _p_ wa_, real_4 _p_ fac_);
prototype int_4 _mrfti1 (int_4 _p_ n_, real_4 _p_ wa_, real_4 _p_ fac_);
prototype int_4 _msntb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ 
wsave_, real_8 _p_ dsum_, real_4 _p_ xh_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _msntf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ 
wsave_, real_8 _p_ dsum_, real_4 _p_ xh_, real_4 _p_ work_, int_4 _p_ ier_);
prototype int_4 _r1f2kb (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, 
real_4 _p_ wa1_);
prototype int_4 _r1f2kf (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, 
real_4 _p_ wa1_);
prototype int_4 _r1f3kb (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, 
real_4 _p_ wa1_, real_4 _p_ wa2_);
prototype int_4 _r1f3kf (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, 
real_4 _p_ wa1_, real_4 _p_ wa2_);
prototype int_4 _r1f4kb (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, 
real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_);
prototype int_4 _r1f4kf (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, 
real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_);
prototype int_4 _r1f5kb (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, 
real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, real_4 _p_ wa4_);
prototype int_4 _r1f5kf (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, 
real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, real_4 _p_ wa4_);
prototype int_4 _r1fgkb (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_4 _p_ cc_, real_4 _p_ c1_, 
real_4 _p_ c2_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _r1fgkf (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_4 _p_ cc_, real_4 _p_ c1_, 
real_4 _p_ c2_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch2_, int_4 _p_ in2_, real_4 _p_ wa_);
prototype int_4 _r2w (int_4 _p_ ldr_, int_4 _p_ ldw_, int_4 _p_ l_, int_4 _p_ m_, real_4 _p_ r_, real_4 _p_ w_);
prototype int_4 _rfft1b (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ r_, int_4 _p_ lenr_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _rfft1f (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ r_, int_4 _p_ lenr_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _rfft1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _rfft2b (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, real_4 _p_ r_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _rfft2f (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, real_4 _p_ r_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _rfft2i (int_4 _p_ l_, int_4 _p_ m_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _rfftb1 (int_4 _p_ n_, int_4 _p_ in_, real_4 _p_ c_, real_4 _p_ ch_, real_4 _p_ wa_, real_4 _p_ fac_);
prototype int_4 _rfftf1 (int_4 _p_ n_, int_4 _p_ in_, real_4 _p_ c_, real_4 _p_ ch_, real_4 _p_ wa_, real_4 _p_ fac_);
prototype int_4 _rffti1 (int_4 _p_ n_, real_4 _p_ wa_, real_4 _p_ fac_);
prototype int_4 _rfftmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ r_, int_4 _p_ lenr_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _rfftmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ r_, int_4 _p_ lenr_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _rfftmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _sinq1b (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _sinq1f (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _sinq1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _sinqmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _sinqmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _sinqmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _sint1b (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _sint1f (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ 
lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _sint1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _sintb1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ xh_, real_4 _p_ 
work_, int_4 _p_ ier_);
prototype int_4 _sintf1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ xh_, real_4 _p_ 
work_, int_4 _p_ ier_);
prototype int_4 _sintmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _sintmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, 
real_4 _p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_);
prototype int_4 _sintmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_);
prototype int_4 _tables (int_4 _p_ ido_, int_4 _p_ ip_, real_4 _p_ wa_);
prototype int_4 _w2r (int_4 _p_ ldr_, int_4 _p_ ldw_, int_4 _p_ l_, int_4 _p_ m_, real_4 _p_ r_, real_4 _p_ w_);
int_4 _dc1f2kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ 
in2_, real_8 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 chold1_, chold2_, tr2_, ti2_;
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    chold1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
    ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold1_;
    chold2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
    ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold2_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * ti2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 1)] * tr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * tr2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 1)] * ti2_;
    }
  }
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _dc1f2kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ 
in2_, real_8 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 sn_, chold1_, chold2_, tr2_, ti2_;
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_8) (2 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    chold1_ = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold1_;
    chold2_ = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold2_;
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * ti2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 1)] * tr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * tr2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 1)] * ti2_;
    }
  }
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _dc1f3kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ 
in2_, real_8 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 taur_, taui_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_0;
#define _data_n_0 2
  static real_4 _data_l_0[_data_n_0] = {
    -.5,
    .866025403784439
  };
  if (__calls[2].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    taur_ = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    taui_ = _data_l_0[_data_k_0++];
  }
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
    ((0) + ((*ido_)) * ((0))))] + tr2_;
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
    ((0) + ((*ido_)) * ((0))))] + ti2_;
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = cr2_ - ci3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = cr2_ + ci3_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = ci2_ + cr3_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = ci2_ - cr3_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + tr2_;
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + ti2_;
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr2_ + ci3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci2_ - cr3_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + taur_ * tr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + tr2_;
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + taur_ * ti2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ 
      - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))]);
      ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ 
      - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))]);
      dr2_ = cr2_ - ci3_;
      dr3_ = cr2_ + ci3_;
      di2_ = ci2_ + cr3_;
      di3_ = ci2_ - cr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * di2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 2)] * dr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * dr2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 2)] * di2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * di3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 2)] * dr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * dr3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 2)] * di3_;
    }
  }
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _dc1f3kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ 
in2_, real_8 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 taur_, taui_, sn_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_1;
#define _data_n_1 2
  static real_4 _data_l_1[_data_n_1] = {
    -.5,
    -.866025403784439
  };
  if (__calls[3].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    taur_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    taui_ = _data_l_1[_data_k_1++];
  }
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_8) (3 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr2_);
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + ti2_);
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (cr2_ - ci3_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (cr2_ + ci3_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (ci2_ + cr3_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (ci2_ - cr3_);
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + tr2_);
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + ti2_);
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (cr2_ - ci3_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (cr2_ + ci3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (ci2_ + cr3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (ci2_ - cr3_);
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + tr2_;
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + ti2_;
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr2_ + ci3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci2_ - cr3_;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + taur_ * tr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + tr2_;
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + taur_ * ti2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ 
      - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))]);
      ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ 
      - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))]);
      dr2_ = cr2_ - ci3_;
      dr3_ = cr2_ + ci3_;
      di2_ = ci2_ + cr3_;
      di3_ = ci2_ - cr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * di2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 2)] * dr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * dr2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 2)] * di2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * di3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 2)] * dr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * dr3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 2)] * di3_;
    }
  }
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _dc1f4kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ 
in2_, real_8 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = tr2_ + tr3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = tr2_ - tr3_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = ti2_ + ti3_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = ti2_ - ti3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = tr1_ + tr4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = tr1_ - tr4_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = ti1_ + ti4_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = ti1_ - ti4_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = tr2_ - tr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ti2_ - ti3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = tr1_ + tr4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = tr1_ - tr4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ti1_ + ti4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ti1_ - ti4_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1))))] = tr2_ + tr3_;
      cr3_ = tr2_ - tr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1))))] = ti2_ + ti3_;
      ci3_ = ti2_ - ti3_;
      cr2_ = tr1_ + tr4_;
      cr4_ = tr1_ - tr4_;
      ci2_ = ti1_ + ti4_;
      ci4_ = ti1_ - ti4_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * cr2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 3)] * ci2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * ci2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 3)] * cr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * cr3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 3)] * ci3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * ci3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 3)] * cr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * cr4_ - wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 3)] * ci4_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * ci4_ + wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 3)] * cr4_;
    }
  }
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _dc1f4kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ 
in2_, real_8 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 sn_, ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_8) (4 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = sn_ * (tr2_ + tr3_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (tr2_ - tr3_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = sn_ * (ti2_ + ti3_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (ti2_ - ti3_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (tr1_ + tr4_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = sn_ * (tr1_ - tr4_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (ti1_ + ti4_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = sn_ * (ti1_ - ti4_);
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (tr2_ + tr3_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (tr2_ - tr3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (ti2_ + ti3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (ti2_ - ti3_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (tr1_ + tr4_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = sn_ * (tr1_ - tr4_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (ti1_ + ti4_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = sn_ * (ti1_ - ti4_);
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = tr2_ - tr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ti2_ - ti3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = tr1_ + tr4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = tr1_ - tr4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ti1_ + ti4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ti1_ - ti4_;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1))))] = tr2_ + tr3_;
      cr3_ = tr2_ - tr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1))))] = ti2_ + ti3_;
      ci3_ = ti2_ - ti3_;
      cr2_ = tr1_ + tr4_;
      cr4_ = tr1_ - tr4_;
      ci2_ = ti1_ + ti4_;
      ci4_ = ti1_ - ti4_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * cr2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 3)] * ci2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * ci2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 3)] * cr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * cr3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 3)] * ci3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * ci3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 3)] * cr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * cr4_ + wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 3)] * ci4_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * ci4_ - wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 3)] * cr4_;
    }
  }
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _dc1f5kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ 
in2_, real_8 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 tr11_, ti11_, tr12_, ti12_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, chold1_, chold2_, cr2_, ci2_, 
  cr3_, ci3_, cr5_, ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_2;
#define _data_n_2 4
  static real_4 _data_l_2[_data_n_2] = {
    .3090169943749474,
    .9510565162951536,
    -.8090169943749474,
    .5877852522924731
  };
  if (__calls[6].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    tr11_ = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    ti11_ = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    tr12_ = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    ti12_ = _data_l_2[_data_k_2++];
  }
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    chold1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr2_ + tr3_;
    chold2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + ti2_ + ti3_;
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold1_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold2_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = cr2_ - ci5_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4))))] = cr2_ + ci5_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = ci2_ + cr5_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = ci3_ + cr4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = cr3_ - ci4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = cr3_ + ci4_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = ci3_ - cr4_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4))))] = ci2_ - cr5_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + tr2_ + tr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + ti2_ + ti3_;
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci5_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = cr2_ + ci5_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr5_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci3_ + cr4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr3_ - ci4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = cr3_ + ci4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ci3_ - cr4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = ci2_ - cr5_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + tr2_ + tr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
      ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
      cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
      ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      dr3_ = cr3_ - ci4_;
      dr4_ = cr3_ + ci4_;
      di3_ = ci3_ + cr4_;
      di4_ = ci3_ - cr4_;
      dr5_ = cr2_ + ci5_;
      dr2_ = cr2_ - ci5_;
      di5_ = ci2_ - cr5_;
      di2_ = ci2_ + cr5_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * dr2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 4)] * di2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * di2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 4)] * dr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * dr3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 4)] * di3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * di3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 4)] * dr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * dr4_ - wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 4)] * di4_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * di4_ + wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 4)] * dr4_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((3))] * dr5_ - wa_[i_ 
      - 1 + ((*ido_)) * ((3) + 4)] * di5_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((3))] * di5_ + wa_[i_ 
      - 1 + ((*ido_)) * ((3) + 4)] * dr5_;
    }
  }
  _l0:;
  __calls[6].calls++;
  return 0;
}

int_4 _dc1f5kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ 
in2_, real_8 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 tr11_, ti11_, tr12_, ti12_, sn_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, chold1_, chold2_, cr2_, 
  ci2_, cr3_, ci3_, cr5_, ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_3;
#define _data_n_3 4
  static real_4 _data_l_3[_data_n_3] = {
    .3090169943749474,
    -.9510565162951536,
    -.8090169943749474,
    -.5877852522924731
  };
  if (__calls[7].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    tr11_ = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    ti11_ = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    tr12_ = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    ti12_ = _data_l_3[_data_k_3++];
  }
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_8) (5 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    chold1_ = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr2_ + tr3_);
    chold2_ = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + ti2_ + ti3_);
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold1_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold2_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (cr2_ - ci5_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4))))] = sn_ * (cr2_ + ci5_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (ci2_ + cr5_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (ci3_ + cr4_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (cr3_ - ci4_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = sn_ * (cr3_ + ci4_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = sn_ * (ci3_ - cr4_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4))))] = sn_ * (ci2_ - cr5_);
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + tr2_ + tr3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + ti2_ + ti3_);
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (cr2_ - ci5_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = sn_ * (cr2_ + ci5_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (ci2_ + cr5_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (ci3_ + cr4_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (cr3_ - ci4_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = sn_ * (cr3_ + ci4_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = sn_ * (ci3_ - cr4_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = sn_ * (ci2_ - cr5_);
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + tr2_ + tr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + ti2_ + ti3_;
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci5_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = cr2_ + ci5_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr5_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci3_ + cr4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr3_ - ci4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = cr3_ + ci4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ci3_ - cr4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = ci2_ - cr5_;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + tr2_ + tr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
      ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
      cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
      ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      dr3_ = cr3_ - ci4_;
      dr4_ = cr3_ + ci4_;
      di3_ = ci3_ + cr4_;
      di4_ = ci3_ - cr4_;
      dr5_ = cr2_ + ci5_;
      dr2_ = cr2_ - ci5_;
      di5_ = ci2_ - cr5_;
      di2_ = ci2_ + cr5_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * dr2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 4)] * di2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * di2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 4)] * dr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * dr3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 4)] * di3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * di3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 4)] * dr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * dr4_ + wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 4)] * di4_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * di4_ - wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 4)] * dr4_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((3))] * dr5_ + wa_[i_ 
      - 1 + ((*ido_)) * ((3) + 4)] * di5_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((3))] * di5_ - wa_[i_ 
      - 1 + ((*ido_)) * ((3) + 4)] * dr5_;
    }
  }
  _l0:;
  __calls[7].calls++;
  return 0;
}

int_4 _dc1fgkb (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_8 _p_ cc_, real_8 _p_ 
cc1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch1_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 ipp2_, ipph_, ki_, j_, jc_, l_, lc_, idlj_, i_, k_;
  static real_4 war_, wai_, chold1_, chold2_;
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + ch1_[0 
      + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + ch1_[1 
      + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
    }
  }
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + 
      wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1)))];
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * 
      ((1)))] * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + 
      wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * 
      ((1)))] * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1)))];
    }
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = _imod ((l_ - 1) * (j_ - 1), (*ip_));
      war_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((0)))];
      wai_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((1)))];
      for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
        cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] 
        + war_ * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
        cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 
        1)))] + wai_ * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
        cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] 
        + war_ * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
        cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 
        1)))] + wai_ * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      }
    }
  }
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l136;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      chold1_ = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
      ((jc_ - 1)))];
      chold2_ = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
      ((jc_ - 1)))];
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = chold1_;
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = chold2_;
    }
  }
  goto _l0;
  _l136:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1))))] = ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0))))];
      cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1))))] = ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0))))] = ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((j_ - 1))))];
      cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0))))] = ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((j_ - 1))))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (i_ = 2; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 
        1) + ((*ip_) - 1) * ((0)))] * ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1))))] - wa_[i_ 
        - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + 
        ((*ido_)) * ((j_ - 1))))];
        cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 
        1) + ((*ip_) - 1) * ((0)))] * ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1))))] + wa_[i_ 
        - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + 
        ((*ido_)) * ((j_ - 1))))];
      }
    }
  }
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _dc1fgkf (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_8 _p_ cc_, real_8 _p_ 
cc1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch1_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 ipp2_, ipph_, ki_, j_, jc_, l_, lc_, idlj_, i_, k_;
  static real_4 war_, wai_, sn_, chold1_, chold2_;
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + ch1_[0 
      + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + ch1_[1 
      + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
    }
  }
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + 
      wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1)))];
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = -wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * 
      ((1)))] * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + 
      wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = -wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * 
      ((1)))] * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1)))];
    }
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = _imod ((l_ - 1) * (j_ - 1), (*ip_));
      war_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((0)))];
      wai_ = -wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((1)))];
      for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
        cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] 
        + war_ * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
        cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 
        1)))] + wai_ * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
        cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] 
        + war_ * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
        cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 
        1)))] + wai_ * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      }
    }
  }
  if ((*ido_) > 1) {
    goto _l136;
  }
  sn_ = 1.0 / (real_8) ((*ip_) * (*l1_));
  if ((*na_) == 1) {
    goto _l146;
  }
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = sn_ * cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = sn_ * cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      chold1_ = sn_ * (cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + 
      ((*lid_)) * ((jc_ - 1)))]);
      chold2_ = sn_ * (cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + 
      ((*lid_)) * ((jc_ - 1)))]);
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = chold1_;
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = sn_ * (cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = sn_ * (cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = chold2_;
    }
  }
  goto _l0;
  _l146:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = sn_ * cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = sn_ * cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = sn_ * (cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = sn_ * (cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = sn_ * (cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = sn_ * (cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
    }
  }
  goto _l0;
  _l136:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
    }
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1))))] = ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0))))];
      cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1))))] = ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0))))] = ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((j_ - 1))))];
      cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0))))] = ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((j_ - 1))))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (i_ = 2; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 
        1) + ((*ip_) - 1) * ((0)))] * ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1))))] + wa_[i_ 
        - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + 
        ((*ido_)) * ((j_ - 1))))];
        cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 
        1) + ((*ip_) - 1) * ((0)))] * ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1))))] - wa_[i_ 
        - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + 
        ((*ido_)) * ((j_ - 1))))];
      }
    }
  }
  _l0:;
  __calls[9].calls++;
  return 0;
}

int_4 _dc1fm1b (int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, real_4 _p_ fnf_, 
real_8 _p_ fac_)
{
  static int_4 inc2_, nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, lid_, nbr_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  inc2_ = (*inc_) + (*inc_);
  nf_ = (*fnf_);
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    lid_ = l1_ * ido_;
    nbr_ = 1 + na_ + 2 * _min (ip_ - 2, 4);
    switch (nbr_) {
      default:
      case 1: goto _l52;
      case 2: goto _l62;
      case 3: goto _l53;
      case 4: goto _l63;
      case 5: goto _l54;
      case 6: goto _l64;
      case 7: goto _l55;
      case 8: goto _l65;
      case 9: goto _l56;
      case 10: goto _l66;
    }
    _l52:;
    (void) _dc1f2kb (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($0_ = 2, &$0_), &wa_[iw_ - 1]);
    goto _l120;
    _l62:;
    (void) _dc1f2kb (&ido_, &l1_, &na_, ch_, ($1_ = 2, &$1_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l53:;
    (void) _dc1f3kb (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($2_ = 2, &$2_), &wa_[iw_ - 1]);
    goto _l120;
    _l63:;
    (void) _dc1f3kb (&ido_, &l1_, &na_, ch_, ($3_ = 2, &$3_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l54:;
    (void) _dc1f4kb (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($4_ = 2, &$4_), &wa_[iw_ - 1]);
    goto _l120;
    _l64:;
    (void) _dc1f4kb (&ido_, &l1_, &na_, ch_, ($5_ = 2, &$5_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l55:;
    (void) _dc1f5kb (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($6_ = 2, &$6_), &wa_[iw_ - 1]);
    goto _l120;
    _l65:;
    (void) _dc1f5kb (&ido_, &l1_, &na_, ch_, ($7_ = 2, &$7_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l56:;
    (void) _dc1fgkb (&ido_, &ip_, &l1_, &lid_, &na_, c_, c_, &inc2_, ch_, ch_, ($8_ = 2, &$8_), &wa_[iw_ - 1]);
    goto _l120;
    _l66:;
    (void) _dc1fgkb (&ido_, &ip_, &l1_, &lid_, &na_, ch_, ch_, ($9_ = 2, &$9_), c_, c_, &inc2_, &wa_[iw_ - 1]);
    _l120:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    if (ip_ <= 5) {
      na_ = 1 - na_;
    }
  }
  __calls[10].calls++;
  return 0;
}

int_4 _dc1fm1f (int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, real_4 _p_ fnf_, 
real_8 _p_ fac_)
{
  static int_4 inc2_, nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, lid_, nbr_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  inc2_ = (*inc_) + (*inc_);
  nf_ = (*fnf_);
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    lid_ = l1_ * ido_;
    nbr_ = 1 + na_ + 2 * _min (ip_ - 2, 4);
    switch (nbr_) {
      default:
      case 1: goto _l52;
      case 2: goto _l62;
      case 3: goto _l53;
      case 4: goto _l63;
      case 5: goto _l54;
      case 6: goto _l64;
      case 7: goto _l55;
      case 8: goto _l65;
      case 9: goto _l56;
      case 10: goto _l66;
    }
    _l52:;
    (void) _dc1f2kf (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($0_ = 2, &$0_), &wa_[iw_ - 1]);
    goto _l120;
    _l62:;
    (void) _dc1f2kf (&ido_, &l1_, &na_, ch_, ($1_ = 2, &$1_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l53:;
    (void) _dc1f3kf (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($2_ = 2, &$2_), &wa_[iw_ - 1]);
    goto _l120;
    _l63:;
    (void) _dc1f3kf (&ido_, &l1_, &na_, ch_, ($3_ = 2, &$3_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l54:;
    (void) _dc1f4kf (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($4_ = 2, &$4_), &wa_[iw_ - 1]);
    goto _l120;
    _l64:;
    (void) _dc1f4kf (&ido_, &l1_, &na_, ch_, ($5_ = 2, &$5_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l55:;
    (void) _dc1f5kf (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($6_ = 2, &$6_), &wa_[iw_ - 1]);
    goto _l120;
    _l65:;
    (void) _dc1f5kf (&ido_, &l1_, &na_, ch_, ($7_ = 2, &$7_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l56:;
    (void) _dc1fgkf (&ido_, &ip_, &l1_, &lid_, &na_, c_, c_, &inc2_, ch_, ch_, ($8_ = 2, &$8_), &wa_[iw_ - 1]);
    goto _l120;
    _l66:;
    (void) _dc1fgkf (&ido_, &ip_, &l1_, &lid_, &na_, ch_, ch_, ($9_ = 2, &$9_), c_, c_, &inc2_, &wa_[iw_ - 1]);
    _l120:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    if (ip_ <= 5) {
      na_ = 1 - na_;
    }
  }
  __calls[11].calls++;
  return 0;
}

int_4 _dcfft1b (int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, int_4 _p_ lenc_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenc_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_0, ($0_ = 4, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_0, ($1_ = 6, &$1_));
  }
  else if ((*lenwrk_) < 2 * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_0, ($2_ = 8, &$2_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _dc1fm1b (n_, inc_, c_, work_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _dcfft1f (int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, int_4 _p_ lenc_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenc_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_1, ($0_ = 4, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_1, ($1_ = 6, &$1_));
  }
  else if ((*lenwrk_) < 2 * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_1, ($2_ = 8, &$2_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _dc1fm1f (n_, inc_, c_, work_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[13].calls++;
  return 0;
}

int_4 _dcfft1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_2, ($0_ = 3, &$0_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _dmcfti1 (n_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _dcfft2b (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, complex_16 _p_ c_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw_, ier1_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_;
  (*ier_) = 0;
  if ((*l_) > (*ldim_)) {
    (*ier_) = 5;
    (void) _xerfft (_dc_3, ($0_ = -2, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 2 * (*m_) + (int_4) (_aintd (log 
    ((real_8) ((*m_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 8) {
    (*ier_) = 2;
    (void) _xerfft (_dc_3, ($1_ = 6, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < 2 * (*l_) * (*m_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_3, ($2_ = 8, &$2_));
    goto _l100;
  }
  iw_ = 2 * (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 3;
  (void) _dcfftmb (l_, &_k1, m_, ldim_, c_, ($3_ = ((*l_) - 1) + (*ldim_) * ((*m_) - 1) + 1, &$3_), &wsave_[iw_ - 1], 
  ($4_ = 2 * (*m_) + (int_4) (_aintd (log ((real_8) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$4_), work_, ($5_ = 2 * (*l_) * 
  (*m_), &$5_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_3, ($6_ = -5, &$6_));
    goto _l100;
  }
  iw_ = 1;
  (void) _dcfftmb (m_, ldim_, l_, &_k1, c_, ($7_ = ((*m_) - 1) * (*ldim_) + (*l_), &$7_), &wsave_[iw_ - 1], ($8_ = 2 * 
  (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$8_), work_, ($9_ = 2 * (*m_) * 
  (*l_), &$9_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_3, ($10_ = -5, &$10_));
  }
  _l100:;
  __calls[15].calls++;
  return 0;
}

int_4 _dcfft2f (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, complex_16 _p_ c_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw_, ier1_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_;
  (*ier_) = 0;
  if ((*l_) > (*ldim_)) {
    (*ier_) = 5;
    (void) _xerfft (_dc_4, ($0_ = -2, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 2 * (*m_) + (int_4) (_aintd (log 
    ((real_8) ((*m_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 8) {
    (*ier_) = 2;
    (void) _xerfft (_dc_4, ($1_ = 6, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < 2 * (*l_) * (*m_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_4, ($2_ = 8, &$2_));
    goto _l100;
  }
  iw_ = 2 * (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 3;
  (void) _dcfftmf (l_, &_k1, m_, ldim_, c_, ($3_ = ((*l_) - 1) + (*ldim_) * ((*m_) - 1) + 1, &$3_), &wsave_[iw_ - 1], 
  ($4_ = 2 * (*m_) + (int_4) (_aintd (log ((real_8) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$4_), work_, ($5_ = 2 * (*l_) * 
  (*m_), &$5_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_4, ($6_ = -5, &$6_));
    goto _l100;
  }
  iw_ = 1;
  (void) _dcfftmf (m_, ldim_, l_, &_k1, c_, ($7_ = ((*m_) - 1) * (*ldim_) + (*l_), &$7_), &wsave_[iw_ - 1], ($8_ = 2 * 
  (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$8_), work_, ($9_ = 2 * (*m_) * 
  (*l_), &$9_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_4, ($10_ = -5, &$10_));
  }
  _l100:;
  __calls[16].calls++;
  return 0;
}

int_4 _dcfft2i (int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 2 * (*m_) + (int_4) (_aintd (log 
    ((real_8) ((*m_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 8) {
    (*ier_) = 2;
    (void) _xerfft (_dc_5, ($0_ = 4, &$0_));
    goto _l100;
  }
  (void) _dcfftmi (l_, &wsave_[0], ($1_ = 2 * (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$1_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_5, ($2_ = -5, &$2_));
    goto _l100;
  }
  (void) _dcfftmi (m_, &wsave_[2 * (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 3 - 1], ($3_ = 2 * (*m_) + (int_4) 
  (_aintd (log ((real_8) ((*m_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, 
  &$3_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_5, ($4_ = -5, &$4_));
  }
  _l100:;
  __calls[17].calls++;
  return 0;
}

int_4 _dcfftmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, int_4 _p_ lenc_, 
real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenc_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_6, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_6, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < 2 * (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_6, ($2_ = 10, &$2_));
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_6, &_km1);
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _dcmfm1b (lot_, jump_, n_, inc_, c_, work_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[18].calls++;
  return 0;
}

int_4 _dcfftmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, int_4 _p_ lenc_, 
real_8 _p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenc_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_7, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_7, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < 2 * (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_7, ($2_ = 10, &$2_));
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_7, &_km1);
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _dcmfm1f (lot_, jump_, n_, inc_, c_, work_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[19].calls++;
  return 0;
}

int_4 _dcfftmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_2, ($0_ = 3, &$0_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _dmcfti1 (n_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _dcmf2kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 chold1_, chold2_, tr2_, ti2_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      chold1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * 
      ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
      ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold1_;
      chold2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * 
      ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
      ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold2_;
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) 
        + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) 
        + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * ti2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 1)] * tr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * tr2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 1)] * ti2_;
      }
    }
  }
  _l0:;
  __calls[21].calls++;
  return 0;
}

int_4 _dcmf2kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 sn_, chold1_, chold2_, tr2_, ti2_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_8) (2 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      chold1_ = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))]);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))]);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold1_;
      chold2_ = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))]);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))]);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold2_;
    }
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((1)))))]);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((1)))))]);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((1)))))]);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((1)))))]);
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
    }
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) 
        + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) 
        + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * ti2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 1)] * tr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * tr2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 1)] * ti2_;
      }
    }
  }
  _l0:;
  __calls[22].calls++;
  return 0;
}

int_4 _dcmf3kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 taur_, taui_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_4;
#define _data_n_4 2
  static real_4 _data_l_4[_data_n_4] = {
    -.5,
    .866025403784439
  };
  if (__calls[23].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    taur_ = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    taui_ = _data_l_4[_data_k_4++];
  }
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = cc_[0 + (2) * ((m1_ - 1) + 
      ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_;
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = cc_[1 + (2) * ((m1_ - 1) + 
      ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = cr2_ - ci3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = cr2_ + ci3_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = ci2_ + cr3_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = ci2_ - cr3_;
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_;
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cr2_ - ci3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cr2_ + ci3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ci2_ + cr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ci2_ - cr3_;
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr2_;
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + ti2_;
        cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 
        + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))]);
        ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 
        + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))]);
        dr2_ = cr2_ - ci3_;
        dr3_ = cr2_ + ci3_;
        di2_ = ci2_ + cr3_;
        di3_ = ci2_ - cr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * di2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 2)] * dr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * dr2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 2)] * di2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * di3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 2)] * dr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * dr3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 2)] * di3_;
      }
    }
  }
  _l0:;
  __calls[23].calls++;
  return 0;
}

int_4 _dcmf3kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 taur_, taui_, sn_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_5;
#define _data_n_5 2
  static real_4 _data_l_5[_data_n_5] = {
    -.5,
    -.866025403784439
  };
  if (__calls[24].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    taur_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    taui_ = _data_l_5[_data_k_5++];
  }
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_8) (3 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = sn_ * (cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_);
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = sn_ * (cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_);
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (cr2_ - ci3_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (cr2_ + ci3_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (ci2_ + cr3_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (ci2_ - cr3_);
    }
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_);
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_);
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (cr2_ - ci3_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (cr2_ + ci3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (ci2_ + cr3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (ci2_ - cr3_);
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_;
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cr2_ - ci3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cr2_ + ci3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ci2_ + cr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ci2_ - cr3_;
    }
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr2_;
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + ti2_;
        cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 
        + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))]);
        ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 
        + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))]);
        dr2_ = cr2_ - ci3_;
        dr3_ = cr2_ + ci3_;
        di2_ = ci2_ + cr3_;
        di3_ = ci2_ - cr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * di2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 2)] * dr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * dr2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 2)] * di2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * di3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 2)] * dr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * dr3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 2)] * di3_;
      }
    }
  }
  _l0:;
  __calls[24].calls++;
  return 0;
}

int_4 _dcmf4kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = tr2_ + tr3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = tr2_ - tr3_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = ti2_ + ti3_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = ti2_ - ti3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = tr1_ + tr4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = tr1_ - tr4_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = ti1_ + ti4_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = ti1_ - ti4_;
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = tr2_ + tr3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = tr2_ - tr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = ti2_ + ti3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ti2_ - ti3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = tr1_ + tr4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = tr1_ - tr4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ti1_ + ti4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = ti1_ - ti4_;
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1)))))] = tr2_ + tr3_;
        cr3_ = tr2_ - tr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1)))))] = ti2_ + ti3_;
        ci3_ = ti2_ - ti3_;
        cr2_ = tr1_ + tr4_;
        cr4_ = tr1_ - tr4_;
        ci2_ = ti1_ + ti4_;
        ci4_ = ti1_ - ti4_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * cr2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 3)] * ci2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * ci2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 3)] * cr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * cr3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 3)] * ci3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * ci3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 3)] * cr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * cr4_ - wa_[i_ - 1 + ((*ido_)) * ((2) + 3)] * ci4_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * ci4_ + wa_[i_ - 1 + ((*ido_)) * ((2) + 3)] * cr4_;
      }
    }
  }
  _l0:;
  __calls[25].calls++;
  return 0;
}

int_4 _dcmf4kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 sn_, ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_8) (4 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = sn_ * (tr2_ + tr3_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (tr2_ - tr3_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = sn_ * (ti2_ + ti3_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (ti2_ - ti3_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (tr1_ + tr4_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = sn_ * (tr1_ - tr4_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (ti1_ + ti4_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = sn_ * (ti1_ - ti4_);
    }
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (tr2_ + tr3_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (tr2_ - tr3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (ti2_ + ti3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (ti2_ - ti3_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (tr1_ + tr4_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = sn_ * (tr1_ - tr4_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (ti1_ + ti4_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = sn_ * (ti1_ - ti4_);
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = tr2_ + tr3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = tr2_ - tr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = ti2_ + ti3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ti2_ - ti3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = tr1_ + tr4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = tr1_ - tr4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ti1_ + ti4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = ti1_ - ti4_;
    }
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1)))))] = tr2_ + tr3_;
        cr3_ = tr2_ - tr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1)))))] = ti2_ + ti3_;
        ci3_ = ti2_ - ti3_;
        cr2_ = tr1_ + tr4_;
        cr4_ = tr1_ - tr4_;
        ci2_ = ti1_ + ti4_;
        ci4_ = ti1_ - ti4_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * cr2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 3)] * ci2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * ci2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 3)] * cr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * cr3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 3)] * ci3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * ci3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 3)] * cr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * cr4_ + wa_[i_ - 1 + ((*ido_)) * ((2) + 3)] * ci4_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * ci4_ - wa_[i_ - 1 + ((*ido_)) * ((2) + 3)] * cr4_;
      }
    }
  }
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _dcmf5kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 tr11_, ti11_, tr12_, ti12_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, chold1_, chold2_, cr2_, ci2_, 
  cr3_, ci3_, cr5_, ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_6;
#define _data_n_6 4
  static real_4 _data_l_6[_data_n_6] = {
    .3090169943749474,
    .9510565162951536,
    -.8090169943749474,
    .5877852522924731
  };
  if (__calls[27].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    tr11_ = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ti11_ = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    tr12_ = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ti12_ = _data_l_6[_data_k_6++];
  }
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      chold1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
      chold2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold1_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold2_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = cr2_ - ci5_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))] = cr2_ + ci5_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = ci2_ + cr5_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = ci3_ + cr4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = cr3_ - ci4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = cr3_ + ci4_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = ci3_ - cr4_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))] = ci2_ - cr5_;
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cr2_ - ci5_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = cr2_ + ci5_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ci2_ + cr5_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ci3_ + cr4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cr3_ - ci4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = cr3_ + ci4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = ci3_ - cr4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = ci2_ - cr5_;
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
        cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
        tr12_ * tr3_;
        ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
        tr12_ * ti3_;
        cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
        tr11_ * tr3_;
        ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
        tr11_ * ti3_;
        cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
        ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
        cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
        ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
        dr3_ = cr3_ - ci4_;
        dr4_ = cr3_ + ci4_;
        di3_ = ci3_ + cr4_;
        di4_ = ci3_ - cr4_;
        dr5_ = cr2_ + ci5_;
        dr2_ = cr2_ - ci5_;
        di5_ = ci2_ - cr5_;
        di2_ = ci2_ + cr5_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * dr2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 4)] * di2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * di2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 4)] * dr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * dr3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 4)] * di3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * di3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 4)] * dr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * dr4_ - wa_[i_ - 1 + ((*ido_)) * ((2) + 4)] * di4_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * di4_ + wa_[i_ - 1 + ((*ido_)) * ((2) + 4)] * dr4_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((3))] * dr5_ - wa_[i_ - 1 + ((*ido_)) * ((3) + 4)] * di5_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((3))] * di5_ + wa_[i_ - 1 + ((*ido_)) * ((3) + 4)] * dr5_;
      }
    }
  }
  _l0:;
  __calls[27].calls++;
  return 0;
}

int_4 _dcmf5kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_8 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 tr11_, ti11_, tr12_, ti12_, sn_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, chold1_, chold2_, cr2_, 
  ci2_, cr3_, ci3_, cr5_, ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_7;
#define _data_n_7 4
  static real_4 _data_l_7[_data_n_7] = {
    .3090169943749474,
    -.9510565162951536,
    -.8090169943749474,
    -.5877852522924731
  };
  if (__calls[28].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    tr11_ = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    ti11_ = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    tr12_ = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    ti12_ = _data_l_7[_data_k_7++];
  }
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_8) (5 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      chold1_ = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + 
      tr3_);
      chold2_ = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + 
      ti3_);
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold1_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold2_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (cr2_ - ci5_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))] = sn_ * (cr2_ + ci5_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (ci2_ + cr5_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (ci3_ + cr4_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (cr3_ - ci4_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = sn_ * (cr3_ + ci4_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = sn_ * (ci3_ - cr4_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))] = sn_ * (ci2_ - cr5_);
    }
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + tr3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + ti3_);
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (cr2_ - ci5_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = sn_ * (cr2_ + ci5_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (ci2_ + cr5_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (ci3_ + cr4_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (cr3_ - ci4_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = sn_ * (cr3_ + ci4_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = sn_ * (ci3_ - cr4_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = sn_ * (ci2_ - cr5_);
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cr2_ - ci5_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = cr2_ + ci5_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ci2_ + cr5_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ci3_ + cr4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cr3_ - ci4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = cr3_ + ci4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = ci3_ - cr4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = ci2_ - cr5_;
    }
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
        cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
        tr12_ * tr3_;
        ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
        tr12_ * ti3_;
        cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
        tr11_ * tr3_;
        ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
        tr11_ * ti3_;
        cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
        ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
        cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
        ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
        dr3_ = cr3_ - ci4_;
        dr4_ = cr3_ + ci4_;
        di3_ = ci3_ + cr4_;
        di4_ = ci3_ - cr4_;
        dr5_ = cr2_ + ci5_;
        dr2_ = cr2_ - ci5_;
        di5_ = ci2_ - cr5_;
        di2_ = ci2_ + cr5_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * dr2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 4)] * di2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * di2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 4)] * dr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * dr3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 4)] * di3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * di3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 4)] * dr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * dr4_ + wa_[i_ - 1 + ((*ido_)) * ((2) + 4)] * di4_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * di4_ - wa_[i_ - 1 + ((*ido_)) * ((2) + 4)] * dr4_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((3))] * dr5_ + wa_[i_ - 1 + ((*ido_)) * ((3) + 4)] * di5_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((3))] * di5_ - wa_[i_ - 1 + ((*ido_)) * ((3) + 4)] * dr5_;
      }
    }
  }
  _l0:;
  __calls[28].calls++;
  return 0;
}

int_4 _dcmfgkb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_8 _p_ 
cc_, real_8 _p_ cc1_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch1_, int_4 _p_ im2_, int_4 _p_ in2_, 
real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, ipp2_, ipph_, ki_, m2_, m1_, j_, jc_, l_, lc_, idlj_, i_, k_;
  static real_4 war_, wai_, chold1_, chold2_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
        ((ki_ - 1) + ((*lid_)) * ((0))))] + ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
        ((ki_ - 1) + ((*lid_)) * ((0))))] + ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))];
      }
    }
  }
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) 
        * ((ki_ - 1) + ((*lid_)) * ((0))))] + wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[0 + (2) * ((m2_ 
        - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1))))];
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + 
        ((*ip_) - 1) * ((1)))] * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) 
        * ((ki_ - 1) + ((*lid_)) * ((0))))] + wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[1 + (2) * ((m2_ 
        - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + 
        ((*ip_) - 1) * ((1)))] * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1))))];
      }
    }
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = _imod ((l_ - 1) * (j_ - 1), (*ip_));
      war_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((0)))];
      wai_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((1)))];
      for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] + war_ * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
          - 1))))];
          cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] + wai_ * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * 
          ((jc_ - 1))))];
          cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] + war_ * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
          - 1))))];
          cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] + wai_ * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * 
          ((jc_ - 1))))];
        }
      }
    }
  }
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l136;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        chold1_ = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))];
        chold2_ = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))];
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = chold1_;
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = chold2_;
      }
    }
  }
  goto _l0;
  _l136:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
      }
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1)))))] = ch_[0 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))];
        cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1)))))] = ch_[1 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))];
      }
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0)))))] = ch_[0 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((j_ - 1)))))];
        cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0)))))] = ch_[1 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((j_ - 1)))))];
      }
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (i_ = 2; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1)))))] = wa_[i_ - 1 + 
          ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
          - 1) + ((*ido_)) * ((j_ - 1)))))] - wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[1 + (2) * 
          ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1)))))];
          cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1)))))] = wa_[i_ - 1 + 
          ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
          - 1) + ((*ido_)) * ((j_ - 1)))))] + wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[0 + (2) * 
          ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1)))))];
        }
      }
    }
  }
  _l0:;
  __calls[29].calls++;
  return 0;
}
int_4 _dcmfgkf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_8 _p_ 
cc_, real_8 _p_ cc1_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch1_, int_4 _p_ im2_, int_4 _p_ in2_, 
real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, ipp2_, ipph_, ki_, m2_, m1_, j_, jc_, l_, lc_, idlj_, i_, k_;
  static real_4 war_, wai_, sn_, chold1_, chold2_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
        ((ki_ - 1) + ((*lid_)) * ((0))))] + ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
        ((ki_ - 1) + ((*lid_)) * ((0))))] + ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))];
      }
    }
  }
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) 
        * ((ki_ - 1) + ((*lid_)) * ((0))))] + wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[0 + (2) * ((m2_ 
        - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1))))];
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = -wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + 
        ((*ip_) - 1) * ((1)))] * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) 
        * ((ki_ - 1) + ((*lid_)) * ((0))))] + wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[1 + (2) * ((m2_ 
        - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = -wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + 
        ((*ip_) - 1) * ((1)))] * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1))))];
      }
    }
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = _imod ((l_ - 1) * (j_ - 1), (*ip_));
      war_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((0)))];
      wai_ = -wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((1)))];
      for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] + war_ * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
          - 1))))];
          cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] + wai_ * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * 
          ((jc_ - 1))))];
          cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] + war_ * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
          - 1))))];
          cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] + wai_ * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * 
          ((jc_ - 1))))];
        }
      }
    }
  }
  if ((*ido_) > 1) {
    goto _l136;
  }
  sn_ = 1.0 / (real_8) ((*ip_) * (*l1_));
  if ((*na_) == 1) {
    goto _l146;
  }
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = sn_ * cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
      * ((ki_ - 1) + ((*lid_)) * ((0))))];
      cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = sn_ * cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
      * ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        chold1_ = sn_ * (cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ 
        - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))]);
        chold2_ = sn_ * (cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ 
        - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))]);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = chold1_;
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = sn_ * (cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = sn_ * (cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = chold2_;
      }
    }
  }
  goto _l0;
  _l146:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = sn_ * cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
      * ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = sn_ * cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
      * ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = sn_ * (cc1_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = sn_ * (cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = sn_ * (cc1_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = sn_ * (cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
      }
    }
  }
  goto _l0;
  _l136:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
      }
    }
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1)))))] = ch_[0 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))];
        cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1)))))] = ch_[1 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))];
      }
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0)))))] = ch_[0 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((j_ - 1)))))];
        cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0)))))] = ch_[1 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((j_ - 1)))))];
      }
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (i_ = 2; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1)))))] = wa_[i_ - 1 + 
          ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
          - 1) + ((*ido_)) * ((j_ - 1)))))] + wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[1 + (2) * 
          ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1)))))];
          cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1)))))] = wa_[i_ - 1 + 
          ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
          - 1) + ((*ido_)) * ((j_ - 1)))))] - wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[0 + (2) * 
          ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1)))))];
        }
      }
    }
  }
  _l0:;
  __calls[30].calls++;
  return 0;
}

int_4 _dcmfm1b (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, real_8 _p_ ch_, 
real_8 _p_ wa_, real_4 _p_ fnf_, real_8 _p_ fac_)
{
  static int_4 nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, lid_, nbr_;
  nf_ = (*fnf_);
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    lid_ = l1_ * ido_;
    nbr_ = 1 + na_ + 2 * _min (ip_ - 2, 4);
    switch (nbr_) {
      default:
      case 1: goto _l52;
      case 2: goto _l62;
      case 3: goto _l53;
      case 4: goto _l63;
      case 5: goto _l54;
      case 6: goto _l64;
      case 7: goto _l55;
      case 8: goto _l65;
      case 9: goto _l56;
      case 10: goto _l66;
    }
    _l52:;
    (void) _dcmf2kb (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l62:;
    (void) _dcmf2kb (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l53:;
    (void) _dcmf3kb (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l63:;
    (void) _dcmf3kb (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l54:;
    (void) _dcmf4kb (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l64:;
    (void) _dcmf4kb (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l55:;
    (void) _dcmf5kb (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l65:;
    (void) _dcmf5kb (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l56:;
    (void) _dcmfgkb (lot_, &ido_, &ip_, &l1_, &lid_, &na_, c_, c_, jump_, inc_, ch_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l66:;
    (void) _dcmfgkb (lot_, &ido_, &ip_, &l1_, &lid_, &na_, ch_, ch_, &_k1, lot_, c_, c_, jump_, inc_, &wa_[iw_ - 1]);
    _l120:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    if (ip_ <= 5) {
      na_ = 1 - na_;
    }
  }
  __calls[31].calls++;
  return 0;
}

int_4 _dcmfm1f (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_16 _p_ c_, real_8 _p_ ch_, 
real_8 _p_ wa_, real_4 _p_ fnf_, real_8 _p_ fac_)
{
  static int_4 nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, lid_, nbr_;
  nf_ = (*fnf_);
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    lid_ = l1_ * ido_;
    nbr_ = 1 + na_ + 2 * _min (ip_ - 2, 4);
    switch (nbr_) {
      default:
      case 1: goto _l52;
      case 2: goto _l62;
      case 3: goto _l53;
      case 4: goto _l63;
      case 5: goto _l54;
      case 6: goto _l64;
      case 7: goto _l55;
      case 8: goto _l65;
      case 9: goto _l56;
      case 10: goto _l66;
    }
    _l52:;
    (void) _dcmf2kf (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l62:;
    (void) _dcmf2kf (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l53:;
    (void) _dcmf3kf (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l63:;
    (void) _dcmf3kf (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l54:;
    (void) _dcmf4kf (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l64:;
    (void) _dcmf4kf (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l55:;
    (void) _dcmf5kf (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l65:;
    (void) _dcmf5kf (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l56:;
    (void) _dcmfgkf (lot_, &ido_, &ip_, &l1_, &lid_, &na_, c_, c_, jump_, inc_, ch_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l66:;
    (void) _dcmfgkf (lot_, &ido_, &ip_, &l1_, &lid_, &na_, ch_, ch_, &_k1, lot_, c_, c_, jump_, inc_, &wa_[iw_ - 1]);
    _l120:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    if (ip_ <= 5) {
      na_ = 1 - na_;
    }
  }
  __calls[32].calls++;
  return 0;
}

int_4 _dcosq1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  static real_4 ssqrt2_, x1_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_8, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_8, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_8, ($2_ = 10, &$2_));
    goto _l300;
  }
  $3_ = (*n_) - 2;
  if ($3_ < 0) {
    goto _l300;
  } else if ($3_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ssqrt2_ = 7.0710678e-1;
  x1_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = ssqrt2_ * (x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((1))]);
  x_[0 + ((*inc_)) * ((0))] = x1_;
  goto _l0;
  _l103:;
  (void) _dcosqb1 (n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_8, ($4_ = -5, &$4_));
  }
  _l300:;
  _l0:;
  __calls[33].calls++;
  return 0;
}

int_4 _dcosq1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  static real_4 ssqrt2_, tsqx_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_9, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_9, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_9, ($2_ = 10, &$2_));
    goto _l300;
  }
  $3_ = (*n_) - 2;
  if ($3_ < 0) {
    goto _l102;
  } else if ($3_ == 0) {
    goto _l101;
  } else {
    goto _l103;
  }
  _l101:;
  ssqrt2_ = 7.0710678e-1;
  tsqx_ = ssqrt2_ * x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = .5 * x_[0 + ((*inc_)) * ((0))] - tsqx_;
  x_[0 + ((*inc_)) * ((0))] = .5 * x_[0 + ((*inc_)) * ((0))] + tsqx_;
  _l102:;
  goto _l0;
  _l103:;
  (void) _dcosqf1 (n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_9, ($4_ = -5, &$4_));
  }
  _l300:;
  _l0:;
  __calls[34].calls++;
  return 0;
}

int_4 _dcosq1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 k_, lnsv_, ier1_;
  static real_4 pih_, dt_, fk_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_10, ($0_ = 3, &$0_));
    goto _l300;
  }
  pih_ = 1.5707963;
  dt_ = pih_ / (real_4) ((*n_));
  fk_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = cosf (fk_ * dt_);
  }
  lnsv_ = (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _drfft1i (n_, &wsave_[(*n_) + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_10, ($1_ = -5, &$1_));
  }
  _l300:;
  __calls[35].calls++;
  return 0;
}

int_4 _dcosqb1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 ns2_, np2_, i_, modn_, lenx_, lnsv_, lnwk_, ier1_, k_, kc_;
  static real_4 xim1_;
  int_4 $0_;
  (*ier_) = 0;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xim1_ = x_[0 + ((*inc_)) * ((i_ - 1 - 1))] + x_[0 + ((*inc_)) * ((i_ - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1))] = .5 * (x_[0 + ((*inc_)) * ((i_ - 1 - 1))] - x_[0 + ((*inc_)) * ((i_ - 1))]);
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = .5 * xim1_;
  }
  x_[0 + ((*inc_)) * ((0))] = .5 * x_[0 + ((*inc_)) * ((0))];
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    goto _l302;
  }
  x_[0 + ((*inc_)) * (((*n_) - 1))] = .5 * x_[0 + ((*inc_)) * (((*n_) - 1))];
  _l302:;
  lenx_ = (*inc_) * ((*n_) - 1) + 1;
  lnsv_ = (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*n_);
  (void) _drfft1b (n_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_11, ($0_ = -5, &$0_));
    goto _l400;
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    work_[k_ - 1] = wsave_[k_ - 1 - 1] * x_[0 + ((*inc_)) * ((kc_ - 1))] + wsave_[kc_ - 1 - 1] * x_[0 + ((*inc_)) * ((k_ - 
    1))];
    work_[kc_ - 1] = wsave_[k_ - 1 - 1] * x_[0 + ((*inc_)) * ((k_ - 1))] - wsave_[kc_ - 1 - 1] * x_[0 + ((*inc_)) * ((kc_ - 
    1))];
  }
  if (modn_ != 0) {
    goto _l305;
  }
  x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] = wsave_[ns2_ - 1] * (x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[0 + ((*inc_)) * 
  ((ns2_ + 1 - 1))]);
  _l305:;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    x_[0 + ((*inc_)) * ((k_ - 1))] = work_[k_ - 1] + work_[kc_ - 1];
    x_[0 + ((*inc_)) * ((kc_ - 1))] = work_[k_ - 1] - work_[kc_ - 1];
  }
  x_[0 + ((*inc_)) * ((0))] = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((0))];
  _l400:;
  __calls[36].calls++;
  return 0;
}

int_4 _dcosqf1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 ns2_, np2_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 xim1_;
  int_4 $0_;
  (*ier_) = 0;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    work_[k_ - 1] = x_[0 + ((*inc_)) * ((k_ - 1))] + x_[0 + ((*inc_)) * ((kc_ - 1))];
    work_[kc_ - 1] = x_[0 + ((*inc_)) * ((k_ - 1))] - x_[0 + ((*inc_)) * ((kc_ - 1))];
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    goto _l301;
  }
  work_[ns2_ + 1 - 1] = x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))];
  _l301:;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    x_[0 + ((*inc_)) * ((k_ - 1))] = wsave_[k_ - 1 - 1] * work_[kc_ - 1] + wsave_[kc_ - 1 - 1] * work_[k_ - 1];
    x_[0 + ((*inc_)) * ((kc_ - 1))] = wsave_[k_ - 1 - 1] * work_[k_ - 1] - wsave_[kc_ - 1 - 1] * work_[kc_ - 1];
  }
  if (modn_ != 0) {
    goto _l303;
  }
  x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] = wsave_[ns2_ - 1] * work_[ns2_ + 1 - 1];
  _l303:;
  lenx_ = (*inc_) * ((*n_) - 1) + 1;
  lnsv_ = (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*n_);
  (void) _drfft1f (n_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_12, ($0_ = -5, &$0_));
    goto _l400;
  }
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xim1_ = .5 * (x_[0 + ((*inc_)) * ((i_ - 1 - 1))] + x_[0 + ((*inc_)) * ((i_ - 1))]);
    x_[0 + ((*inc_)) * ((i_ - 1))] = .5 * (x_[0 + ((*inc_)) * ((i_ - 1 - 1))] - x_[0 + ((*inc_)) * ((i_ - 1))]);
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = xim1_;
  }
  _l400:;
  __calls[37].calls++;
  return 0;
}

int_4 _dcosqmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, ier1_;
  static real_4 ssqrt2_, x1_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_13, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_13, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_13, ($2_ = 10, &$2_));
    goto _l300;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_13, &_km1);
    goto _l300;
  }
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $3_ = (*n_) - 2;
  if ($3_ < 0) {
    goto _l101;
  } else if ($3_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    /* x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] */;
  }
  goto _l0;
  _l102:;
  ssqrt2_ = 7.0710678e-1;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = ssqrt2_ * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = x1_;
  }
  goto _l0;
  _l103:;
  (void) _dmcsqb1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_13, ($4_ = -5, &$4_));
  }
  _l300:;
  _l0:;
  __calls[38].calls++;
  return 0;
}

int_4 _dcosqmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, ier1_;
  static real_4 ssqrt2_, tsqx_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_14, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_14, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_14, ($2_ = 10, &$2_));
    goto _l300;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_14, &_km1);
    goto _l300;
  }
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $3_ = (*n_) - 2;
  if ($3_ < 0) {
    goto _l102;
  } else if ($3_ == 0) {
    goto _l101;
  } else {
    goto _l103;
  }
  _l101:;
  ssqrt2_ = 7.0710678e-1;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    tsqx_ = ssqrt2_ * x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = .5 * x_[m_ - 1 + ((*inc_)) * ((0))] - tsqx_;
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * x_[m_ - 1 + ((*inc_)) * ((0))] + tsqx_;
  }
  _l102:;
  goto _l0;
  _l103:;
  (void) _dmcsqf1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_14, ($4_ = -5, &$4_));
  }
  _l300:;
  _l0:;
  __calls[39].calls++;
  return 0;
}

int_4 _dcosqmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 k_, lnsv_, ier1_;
  static real_4 pih_, dt_, fk_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_15, ($0_ = 3, &$0_));
    goto _l300;
  }
  pih_ = 1.5707963;
  dt_ = pih_ / (real_4) ((*n_));
  fk_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = cosf (fk_ * dt_);
  }
  lnsv_ = (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _drfftmi (n_, &wsave_[(*n_) + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_15, ($1_ = -5, &$1_));
  }
  _l300:;
  __calls[40].calls++;
  return 0;
}

int_4 _dcost1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_16, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_16, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*n_) - 1) {
    (*ier_) = 3;
    (void) _xerfft (_dc_16, ($2_ = 10, &$2_));
    goto _l100;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _dcostb1 (n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_16, ($3_ = -5, &$3_));
  }
  _l100:;
  _l0:;
  __calls[41].calls++;
  return 0;
}

int_4 _dcost1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_17, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_17, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*n_) - 1) {
    (*ier_) = 3;
    (void) _xerfft (_dc_17, ($2_ = 10, &$2_));
    goto _l100;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _dcostf1 (n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_17, ($3_ = -5, &$3_));
  }
  _l100:;
  _l0:;
  __calls[42].calls++;
  return 0;
}

int_4 _dcost1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, lnsv_, ier1_;
  static real_4 pi_, dt_, fk_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_18, ($0_ = 3, &$0_));
    goto _l300;
  }
  if ((*n_) <= 3) {
    goto _l0;
  }
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  pi_ = 3.1415927;
  dt_ = pi_ / (real_4) (nm1_);
  fk_ = 0.0;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = 2.0 * sinf (fk_ * dt_);
    wsave_[kc_ - 1] = 2.0 * cosf (fk_ * dt_);
  }
  lnsv_ = nm1_ + (int_4) (_aintd (log ((real_8) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _drfft1i (&nm1_, &wsave_[(*n_) + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_18, ($1_ = -5, &$1_));
  }
  _l300:;
  _l0:;
  __calls[43].calls++;
  return 0;
}

int_4 _dcostb1 (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 x1h_, x1p3_, x2_, t1_, t2_, fnm1s2_, fnm1s4_, xi_;
  static real_8 dsum_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l106;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  x1h_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((0))] = x1h_;
  goto _l0;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  x1p3_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((2))];
  x2_ = x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((2))];
  x_[0 + ((*inc_)) * ((0))] = x1p3_ + x2_;
  x_[0 + ((*inc_)) * ((2))] = x1p3_ - x2_;
  goto _l0;
  _l103:;
  x_[0 + ((*inc_)) * ((0))] = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((0))];
  x_[0 + ((*inc_)) * (((*n_) - 1))] = x_[0 + ((*inc_)) * (((*n_) - 1))] + x_[0 + ((*inc_)) * (((*n_) - 1))];
  dsum_ = x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * (((*n_) - 1))];
  x_[0 + ((*inc_)) * ((0))] = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * (((*n_) - 1))];
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = x_[0 + ((*inc_)) * ((k_ - 1))] + x_[0 + ((*inc_)) * ((kc_ - 1))];
    t2_ = x_[0 + ((*inc_)) * ((k_ - 1))] - x_[0 + ((*inc_)) * ((kc_ - 1))];
    dsum_ = dsum_ + wsave_[kc_ - 1] * t2_;
    t2_ = wsave_[k_ - 1] * t2_;
    x_[0 + ((*inc_)) * ((k_ - 1))] = t1_ - t2_;
    x_[0 + ((*inc_)) * ((kc_ - 1))] = t1_ + t2_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] = x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))];
  _l124:;
  lenx_ = (*inc_) * (nm1_ - 1) + 1;
  lnsv_ = nm1_ + (int_4) (_aintd (log ((real_8) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = nm1_;
  (void) _drfft1f (&nm1_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_19, ($1_ = -5, &$1_));
    goto _l0;
  }
  fnm1s2_ = (real_4) (nm1_) / 2.0;
  dsum_ = .5 * dsum_;
  x_[0 + ((*inc_)) * ((0))] = fnm1s2_ * x_[0 + ((*inc_)) * ((0))];
  if (_imod (nm1_, 2) != 0) {
    goto _l30;
  }
  x_[0 + ((*inc_)) * ((nm1_ - 1))] = x_[0 + ((*inc_)) * ((nm1_ - 1))] + x_[0 + ((*inc_)) * ((nm1_ - 1))];
  _l30:;
  fnm1s4_ = (real_4) (nm1_) / 4.0;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xi_ = fnm1s4_ * x_[0 + ((*inc_)) * ((i_ - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1))] = fnm1s4_ * x_[0 + ((*inc_)) * ((i_ - 1 - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = dsum_;
    dsum_ = dsum_ + xi_;
  }
  if (modn_ != 0) {
    goto _l0;
  }
  x_[0 + ((*inc_)) * (((*n_) - 1))] = dsum_;
  _l106:;
  _l0:;
  __calls[44].calls++;
  return 0;
}

int_4 _dcostf1 (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 x1h_, x1p3_, tx2_, t1_, t2_, snm1_, xi_;
  static real_8 dsum_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l200;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  x1h_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = .5 * (x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((1))]);
  x_[0 + ((*inc_)) * ((0))] = .5 * x1h_;
  goto _l200;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  x1p3_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((2))];
  tx2_ = x_[0 + ((*inc_)) * ((1))] + x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = .5 * (x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((2))]);
  x_[0 + ((*inc_)) * ((0))] = .25 * (x1p3_ + tx2_);
  x_[0 + ((*inc_)) * ((2))] = .25 * (x1p3_ - tx2_);
  goto _l200;
  _l103:;
  dsum_ = x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * (((*n_) - 1))];
  x_[0 + ((*inc_)) * ((0))] = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * (((*n_) - 1))];
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = x_[0 + ((*inc_)) * ((k_ - 1))] + x_[0 + ((*inc_)) * ((kc_ - 1))];
    t2_ = x_[0 + ((*inc_)) * ((k_ - 1))] - x_[0 + ((*inc_)) * ((kc_ - 1))];
    dsum_ = dsum_ + wsave_[kc_ - 1] * t2_;
    t2_ = wsave_[k_ - 1] * t2_;
    x_[0 + ((*inc_)) * ((k_ - 1))] = t1_ - t2_;
    x_[0 + ((*inc_)) * ((kc_ - 1))] = t1_ + t2_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] = x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))];
  _l124:;
  lenx_ = (*inc_) * (nm1_ - 1) + 1;
  lnsv_ = nm1_ + (int_4) (_aintd (log ((real_8) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = nm1_;
  (void) _drfft1f (&nm1_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_20, ($1_ = -5, &$1_));
    goto _l200;
  }
  snm1_ = 1.0 / (real_4) (nm1_);
  dsum_ = snm1_ * dsum_;
  if (_imod (nm1_, 2) != 0) {
    goto _l30;
  }
  x_[0 + ((*inc_)) * ((nm1_ - 1))] = x_[0 + ((*inc_)) * ((nm1_ - 1))] + x_[0 + ((*inc_)) * ((nm1_ - 1))];
  _l30:;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xi_ = .5 * x_[0 + ((*inc_)) * ((i_ - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1))] = .5 * x_[0 + ((*inc_)) * ((i_ - 1 - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = dsum_;
    dsum_ = dsum_ + xi_;
  }
  if (modn_ != 0) {
    goto _l117;
  }
  x_[0 + ((*inc_)) * (((*n_) - 1))] = dsum_;
  _l117:;
  x_[0 + ((*inc_)) * ((0))] = .5 * x_[0 + ((*inc_)) * ((0))];
  x_[0 + ((*inc_)) * (((*n_) - 1))] = .5 * x_[0 + ((*inc_)) * (((*n_) - 1))];
  _l200:;
  __calls[45].calls++;
  return 0;
}

int_4 _dcostmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_, ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_21, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_21, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*lot_) * ((*n_) + 1)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_21, ($2_ = 10, &$2_));
    goto _l100;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_21, &_km1);
    goto _l100;
  }
  iw1_ = (*lot_) + (*lot_) + 1;
  (void) _dmcstb1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &work_[iw1_ - 1], &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_21, ($3_ = -5, &$3_));
  }
  _l100:;
  __calls[46].calls++;
  return 0;
}

int_4 _dcostmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_, ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_22, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_22, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*lot_) * ((*n_) + 1)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_22, ($2_ = 10, &$2_));
    goto _l100;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_22, &_km1);
    goto _l100;
  }
  iw1_ = (*lot_) + (*lot_) + 1;
  (void) _dmcstf1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &work_[iw1_ - 1], &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_22, ($3_ = -5, &$3_));
  }
  _l100:;
  __calls[47].calls++;
  return 0;
}

int_4 _dcostmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, lnsv_, ier1_;
  static real_4 pi_, dt_, fk_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_23, ($0_ = 3, &$0_));
    goto _l300;
  }
  if ((*n_) <= 3) {
    goto _l0;
  }
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  pi_ = 3.1415927;
  dt_ = pi_ / (real_4) (nm1_);
  fk_ = 0.0;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = 2.0 * sinf (fk_ * dt_);
    wsave_[kc_ - 1] = 2.0 * cosf (fk_ * dt_);
  }
  lnsv_ = nm1_ + (int_4) (_aintd (log ((real_8) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _drfftmi (&nm1_, &wsave_[(*n_) + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_23, ($1_ = -5, &$1_));
  }
  _l300:;
  _l0:;
  __calls[48].calls++;
  return 0;
}

int_4 _dfactor (int_4 _p_ n_, int_4 _p_ nf_, real_8 _p_ fac_)
{
  static int_4 ntryh_[4], nl_, j_, ntry_, nq_, nr_;
  int_4 _data_k_8, $0_, $1_;
#define _data_n_8 4
  static int_4 _data_l_8[_data_n_8] = {
    4,
    2,
    3,
    5
  };
  if (__calls[49].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    ntryh_[0] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    ntryh_[1] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    ntryh_[2] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    ntryh_[3] = _data_l_8[_data_k_8++];
  }
  nl_ = (*n_);
  (*nf_) = 0;
  j_ = 0;
  _l101:;
  j_ = j_ + 1;
  $0_ = j_ - 4;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ntry_ = ntryh_[j_ - 1];
  goto _l104;
  _l103:;
  ntry_ = ntry_ + 2;
  _l104:;
  nq_ = nl_ / ntry_;
  nr_ = nl_ - ntry_ * nq_;
  $1_ = nr_;
  if ($1_ < 0) {
    goto _l101;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  (*nf_) = (*nf_) + 1;
  fac_[(*nf_) - 1] = ntry_;
  nl_ = nq_;
  if (nl_ != 1) {
    goto _l104;
  }
  __calls[49].calls++;
  return 0;
}

int_4 _dmcfti1 (int_4 _p_ n_, real_8 _p_ wa_, real_4 _p_ fnf_, real_8 _p_ fac_)
{
  static int_4 nf_, iw_, l1_, k1_, ip_, l2_, ido_;
  (void) _dfactor (n_, &nf_, fac_);
  (*fnf_) = nf_;
  iw_ = 1;
  l1_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = l1_ * ip_;
    ido_ = (*n_) / l2_;
    (void) _dtables (&ido_, &ip_, &wa_[iw_ - 1]);
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    l1_ = l2_;
  }
  __calls[50].calls++;
  return 0;
}

int_4 _dmcsqb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 
_p_ work_, int_4 _p_ ier_)
{
  static int_4 lj_, ns2_, np2_, i_, m_, modn_, lenx_, lnsv_, lnwk_, ier1_, k_, kc_, m1_;
  static real_4 xim1_;
  int_4 $0_;
  (*ier_) = 0;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      xim1_ = x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] + x_[m_ - 1 + ((*inc_)) * ((i_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = .5 * (x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] - x_[m_ - 1 + ((*inc_)) * ((i_ - 
      1))]);
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = .5 * xim1_;
    }
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    goto _l302;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = .5 * x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
  }
  _l302:;
  lenx_ = ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1;
  lnsv_ = (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * (*n_);
  (void) _drfftmb (lot_, jump_, n_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_24, ($0_ = -5, &$0_));
    goto _l400;
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] = wsave_[k_ - 1 - 1] * x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] + wsave_[kc_ - 1 - 
      1] * x_[m_ - 1 + ((*inc_)) * ((k_ - 1))];
      work_[m1_ - 1 + ((*lot_)) * ((kc_ - 1))] = wsave_[k_ - 1 - 1] * x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - wsave_[kc_ - 1 - 
      1] * x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
    }
  }
  if (modn_ != 0) {
    goto _l305;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] = wsave_[ns2_ - 1] * (x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[m_ - 1 + 
    ((*inc_)) * ((ns2_ + 1 - 1))]);
  }
  _l305:;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] + work_[m1_ - 1 + ((*lot_)) * ((kc_ - 
      1))];
      x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] = work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] - work_[m1_ - 1 + ((*lot_)) * ((kc_ - 
      1))];
    }
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  _l400:;
  __calls[51].calls++;
  return 0;
}

int_4 _dmcsqf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 
_p_ work_, int_4 _p_ ier_)
{
  static int_4 lj_, ns2_, np2_, k_, kc_, m1_, m_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 xim1_;
  int_4 $0_;
  (*ier_) = 0;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      work_[m1_ - 1 + ((*lot_)) * ((kc_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    goto _l301;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    work_[m1_ - 1 + ((*lot_)) * ((ns2_ + 1 - 1))] = x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[m_ - 1 + ((*inc_)) * 
    ((ns2_ + 1 - 1))];
  }
  _l301:;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = wsave_[k_ - 1 - 1] * work_[m1_ - 1 + ((*lot_)) * ((kc_ - 1))] + wsave_[kc_ - 1 - 
      1] * work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] = wsave_[k_ - 1 - 1] * work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] - wsave_[kc_ - 1 - 
      1] * work_[m1_ - 1 + ((*lot_)) * ((kc_ - 1))];
    }
  }
  if (modn_ != 0) {
    goto _l303;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] = wsave_[ns2_ - 1] * work_[m1_ - 1 + ((*lot_)) * ((ns2_ + 1 - 1))];
  }
  _l303:;
  lenx_ = ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1;
  lnsv_ = (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * (*n_);
  (void) _drfftmf (lot_, jump_, n_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_25, ($0_ = -5, &$0_));
    goto _l400;
  }
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      xim1_ = .5 * (x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] + x_[m_ - 1 + ((*inc_)) * ((i_ - 1))]);
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = .5 * (x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] - x_[m_ - 1 + ((*inc_)) * ((i_ - 
      1))]);
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = xim1_;
    }
  }
  _l400:;
  __calls[52].calls++;
  return 0;
}

int_4 _dmcstb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_8 
_p_ dsum_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, lj_, m_, m1_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 x1h_, x1p3_, x2_, t1_, t2_, fnm1s2_, fnm1s4_, xi_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l106;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1h_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((0))] = x1h_;
  }
  goto _l0;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1p3_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((2))];
    x2_ = x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((2))];
    x_[m_ - 1 + ((*inc_)) * ((0))] = x1p3_ + x2_;
    x_[m_ - 1 + ((*inc_)) * ((2))] = x1p3_ - x2_;
  }
  goto _l0;
  _l103:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((0))];
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] + x_[m_ - 1 + ((*inc_)) * (((*n_) - 
    1))];
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    dsum_[m1_ - 1] = x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
    x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      kc_ = np1_ - k_;
      t1_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      t2_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + wsave_[kc_ - 1] * t2_;
      t2_ = wsave_[k_ - 1] * t2_;
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = t1_ - t2_;
      x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] = t1_ + t2_;
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] = x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[m_ - 1 + ((*inc_)) * ((ns2_ 
    + 1 - 1))];
  }
  _l124:;
  lenx_ = ((*lot_) - 1) * (*jump_) + (*inc_) * (nm1_ - 1) + 1;
  lnsv_ = nm1_ + (int_4) (_aintd (log ((real_8) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * nm1_;
  (void) _drfftmf (lot_, jump_, &nm1_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_26, ($1_ = -5, &$1_));
    goto _l106;
  }
  fnm1s2_ = (real_4) (nm1_) / 2.0;
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    dsum_[m1_ - 1] = .5 * dsum_[m1_ - 1];
    x_[m_ - 1 + ((*inc_)) * ((0))] = fnm1s2_ * x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  if (_imod (nm1_, 2) != 0) {
    goto _l30;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))];
  }
  _l30:;
  fnm1s4_ = (real_4) (nm1_) / 4.0;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      xi_ = fnm1s4_ * x_[m_ - 1 + ((*inc_)) * ((i_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = fnm1s4_ * x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = dsum_[m1_ - 1];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + xi_;
    }
  }
  if (modn_ != 0) {
    goto _l0;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = dsum_[m1_ - 1];
  }
  _l106:;
  _l0:;
  __calls[53].calls++;
  return 0;
}

int_4 _dmcstf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_8 
_p_ dsum_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, lj_, m_, m1_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 x1h_, x1p3_, tx2_, t1_, t2_, snm1_, xi_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l200;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1h_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = .5 * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * x1h_;
  }
  goto _l200;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1p3_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((2))];
    tx2_ = x_[m_ - 1 + ((*inc_)) * ((1))] + x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = .5 * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((2))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = .25 * (x1p3_ + tx2_);
    x_[m_ - 1 + ((*inc_)) * ((2))] = .25 * (x1p3_ - tx2_);
  }
  goto _l200;
  _l103:;
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    dsum_[m1_ - 1] = x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
    x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      kc_ = np1_ - k_;
      t1_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      t2_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + wsave_[kc_ - 1] * t2_;
      t2_ = wsave_[k_ - 1] * t2_;
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = t1_ - t2_;
      x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] = t1_ + t2_;
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] = x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[m_ - 1 + ((*inc_)) * ((ns2_ 
    + 1 - 1))];
  }
  _l124:;
  lenx_ = ((*lot_) - 1) * (*jump_) + (*inc_) * (nm1_ - 1) + 1;
  lnsv_ = nm1_ + (int_4) (_aintd (log ((real_8) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * nm1_;
  (void) _drfftmf (lot_, jump_, &nm1_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_27, ($1_ = -5, &$1_));
    goto _l200;
  }
  snm1_ = 1.0 / (real_4) (nm1_);
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    dsum_[m_ - 1] = snm1_ * dsum_[m_ - 1];
  }
  if (_imod (nm1_, 2) != 0) {
    goto _l30;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))];
  }
  _l30:;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      xi_ = .5 * x_[m_ - 1 + ((*inc_)) * ((i_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = .5 * x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = dsum_[m1_ - 1];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + xi_;
    }
  }
  if (modn_ != 0) {
    goto _l117;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = dsum_[m1_ - 1];
  }
  _l117:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * x_[m_ - 1 + ((*inc_)) * ((0))];
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = .5 * x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
  }
  _l200:;
  __calls[54].calls++;
  return 0;
}

int_4 _dmradb2 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  int_4 $0_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 
      1))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 
      1))))];
    }
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * 
        ((k_ - 1))))];
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 
        1))))];
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * (cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((1) + (2) * ((k_ - 1))))]) - wa1_[i_ - 1 - 1] * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + 
        (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((1) + (2) * ((k_ - 1))))]) + wa1_[i_ - 1 - 1] * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * 
        ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
      }
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * 
      (((*ido_) - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + 
      (2) * ((k_ - 1))))];
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = -(cc_[m1_ - 1 + ((*in1_)) * 
      ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 
      1))))]);
    }
  }
  _l107:;
  _l0:;
  __calls[55].calls++;
  return 0;
}

int_4 _dmradb3 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 arg_, taur_, taui_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  arg_ = 2.0943951;
  taur_ = cosf (arg_);
  taui_ = sinf (arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ 
      - 1))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (2.0 * taur_) * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (3) * ((k_ - 1))))] - (2.0 * taui_) * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (2.0 * taur_) * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (3) * ((k_ - 1))))] + 2.0 * taui_ * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))];
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ 
        - 1))))])) - (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) - wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + 
        (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + (taui_ * 
        (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 
        - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 
        1))))])) + (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) + wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - 
        (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ 
        - 1))))])) + (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) - wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + 
        (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - (taui_ * 
        (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 
        - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 
        1))))])) - (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) + wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + 
        (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
      }
    }
  }
  _l0:;
  __calls[56].calls++;
  return 0;
}

int_4 _dmradb4 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 sqrt2_;
  int_4 $0_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  sqrt2_ = 1.4142136;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) - (cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) 
      * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) + (cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) 
      * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
    }
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * 
        ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 
        1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
        1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - 
        cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - 
        cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 
        1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa2_[i_ - 1 - 1] * 
        ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[m1_ - 
        1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + 
        (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 
        + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa3_[i_ - 1 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - 
        cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - 
        cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa3_[i_ - 1 - 1] * ((cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
      }
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[m1_ - 1 + ((*in1_)) * 
      (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + 
      (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 
      + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sqrt2_ * ((cc_[m1_ - 1 + 
      ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + 
      ((*ido_)) * ((2) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + 
      cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]));
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[m1_ - 1 + ((*in1_)) * 
      ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 
      1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = -sqrt2_ * ((cc_[m1_ - 1 + 
      ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + 
      ((*ido_)) * ((2) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + 
      cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]));
    }
  }
  _l107:;
  _l0:;
  __calls[57].calls++;
  return 0;
}

int_4 _dmradb5 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 arg_, tr11_, ti11_, tr12_, ti12_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  arg_ = 1.2566371;
  tr11_ = cosf (arg_);
  ti11_ = sinf (arg_);
  tr12_ = cosf (2.0 * arg_);
  ti12_ = sinf (2.0 * arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
      - 1))))] + 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) 
      - (ti11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + ti12_ * 2.0 * cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) 
      - (ti12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - ti11_ * 2.0 * cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) 
      + (ti12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - ti11_ * 2.0 * cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) 
      + (ti11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + ti12_ * 2.0 * cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))]);
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * 
        ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
        - 1))))]) + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) - wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ 
        * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 
        1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
        - 1))))]) + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        - ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) - wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ 
        * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 
        1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
        - 1))))]) + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        - ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) - wa3_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ 
        * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 
        1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa3_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = wa4_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
        - 1))))]) + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) - wa4_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = wa4_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ 
        * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 
        1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa4_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])));
      }
    }
  }
  _l0:;
  __calls[58].calls++;
  return 0;
}

int_4 _dmradbg (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ 
c1_, real_8 _p_ c2_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch2_, int_4 _p_ im2_, int_4 _p_ in2_, 
real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, idp2_, nbd_, ipp2_, ipph_, k_, i_, m2_, m1_, j_, jc_, j2_, ic_, l_, lc_, ik_, is_, idij_;
  static real_4 tpi_, arg_, dcp_, dsp_, ar1_, ai1_, ar1h_, dc2_, ds2_, ar2_, ai2_, ar2h_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  tpi_ = 6.2831853;
  arg_ = tpi_ / (real_4) ((*ip_));
  dcp_ = cosf (arg_);
  dsp_ = sinf (arg_);
  idp2_ = (*ido_) + 2;
  nbd_ = ((*ido_) - 1) / 2;
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  if ((*ido_) < (*l1_)) {
    goto _l103;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))];
      }
    }
  }
  goto _l106;
  _l103:;
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))];
      }
    }
  }
  _l106:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * (((*ido_) 
        - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
        ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
        ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((j2_ - 1 - 1) + 
        ((*ip_)) * ((k_ - 1))))];
      }
    }
  }
  if ((*ido_) == 1) {
    goto _l116;
  }
  if (nbd_ < (*l1_)) {
    goto _l112;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ic_ = idp2_ - i_;
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
          ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
          ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
          - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
          ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) 
          * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        }
      }
    }
  }
  goto _l116;
  _l112:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
          ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
          ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
          - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
          ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) 
          * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        }
      }
    }
  }
  _l116:;
  ar1_ = 1.0;
  ai1_ = 0.0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    ar1h_ = dcp_ * ar1_ - dsp_ * ai1_;
    ai1_ = dcp_ * ai1_ + dsp_ * ar1_;
    ar1_ = ar1h_;
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
        ((0)))] + ar1_ * ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((1)))];
        c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ai1_ * ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + 
        ((*idl1_)) * (((*ip_) - 1)))];
      }
    }
    dc2_ = ar1_;
    ds2_ = ai1_;
    ar2_ = ar1_;
    ai2_ = ai1_;
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      ar2h_ = dc2_ * ar2_ - ds2_ * ai2_;
      ai2_ = dc2_ * ai2_ + ds2_ * ar2_;
      ar2_ = ar2h_;
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
          ((l_ - 1)))] + ar2_ * ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
          c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
          ((lc_ - 1)))] + ai2_ * ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((jc_ - 1)))];
        }
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
        ((0)))] + ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
      }
    }
  }
  if ((*ido_) == 1) {
    goto _l132;
  }
  if (nbd_ < (*l1_)) {
    goto _l128;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((i_ 
          - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
        }
      }
    }
  }
  goto _l132;
  _l128:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((i_ 
          - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
        }
      }
    }
  }
  _l132:;
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
      ((0)))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  if (nbd_ > (*l1_)) {
    goto _l139;
  }
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    idij_ = is_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * 
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * ch_[m2_ - 
          1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * ch_[m2_ - 
          1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * ch_[m2_ - 1 + ((*in2_)) 
          * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l143;
  _l139:;
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = is_;
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * 
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * ch_[m2_ - 
          1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * ch_[m2_ - 
          1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * ch_[m2_ - 1 + ((*in2_)) 
          * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  _l143:;
  _l0:;
  __calls[59].calls++;
  return 0;
}

int_4 _dmradf2 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  int_4 $0_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))];
    }
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((0))))];
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((1))))]);
      }
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = -cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * (((*ido_) 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
    }
  }
  _l107:;
  _l0:;
  __calls[60].calls++;
  return 0;
}

int_4 _dmradf3 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 arg_, taur_, taui_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  arg_ = 2.0943951;
  taur_ = cosf (arg_);
  taui_ = sinf (arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + 
      cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) + (taui_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - 
        (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) - (taui_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - 
        (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) + (taui_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
        * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - 
        (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = (taui_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]))) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - 
        wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
      }
    }
  }
  _l0:;
  __calls[61].calls++;
  return 0;
}

int_4 _dmradf4 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 hsqt2_;
  int_4 $0_;
  hsqt2_ = 7.0710678e-1;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) + 
      (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * 
      ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
    }
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))])) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((0))))] + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
        wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((2))))])) - ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + 
        wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))])) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] 
        + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))])) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] 
        + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))])) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((0))))] - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
        wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((2))))])) - ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))]) - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - 
        wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))])) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] 
        - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))])) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] 
        - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      }
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = (hsqt2_ * (cc_[m1_ - 1 + ((*in1_)) 
      * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))])) + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((0))))];
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * (((*ido_) 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (hsqt2_ * (cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((3))))]));
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = (-hsqt2_ * (cc_[m1_ - 1 + ((*in1_)) * 
      (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))])) - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (-hsqt2_ * (cc_[m1_ - 1 + ((*in1_)) * 
      (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))])) + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))];
    }
  }
  _l107:;
  _l0:;
  __calls[62].calls++;
  return 0;
}

int_4 _dmradf5 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 arg_, tr11_, ti11_, tr12_, ti12_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  arg_ = 1.2566371;
  tr11_ = cosf (arg_);
  ti11_ = sinf (arg_);
  tr12_ = cosf (2.0 * arg_);
  ti12_ = sinf (2.0 * arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + 
      cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((4))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + tr12_ * (cc_[m1_ 
      - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((4))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + tr11_ * (cc_[m1_ 
      - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) - ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] 
        + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + 
        ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] + wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))]) + tr12_ * (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
        wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) + ti11_ * (wa1_[i_ - 2 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + ti12_ * (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((2))))] - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] + wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))]) + tr12_ * (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
        wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (ti11_ * (wa1_[i_ - 2 - 1] 
        * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + ti12_ * (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((2))))] - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((3))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + tr12_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + 
        (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) + (ti11_ * ((wa4_[i_ - 2 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) + ti12_ * ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) 
        * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = (ti11_ * ((wa4_[i_ - 2 - 1] * cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) + ti12_ * ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * ((wa1_[i_ - 
        2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ 
        - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr12_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + 
        (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) + (ti12_ * ((wa1_[i_ - 2 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) - ti11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + 
        (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) - (ti12_ * ((wa1_[i_ - 2 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) - ti11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + 
        (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) + (ti12_ * ((wa4_[i_ - 2 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) - ti11_ * ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) 
        * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = (ti12_ * ((wa4_[i_ - 2 - 1] * cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) - ti11_ * ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 
        2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ 
        - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))])));
      }
    }
  }
  _l0:;
  __calls[63].calls++;
  return 0;
}

int_4 _dmradfg (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ 
c1_, real_8 _p_ c2_, int_4 _p_ im1_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch2_, int_4 _p_ im2_, int_4 _p_ in2_, 
real_8 _p_ wa_)
{
  static int_4 m1d_, m2s_, ipph_, ipp2_, idp2_, nbd_, ik_, m2_, m1_, j_, k_, is_, idij_, i_, jc_, l_, lc_, j2_, ic_;
  static real_4 tpi_, arg_, dcp_, dsp_, ar1_, ai1_, ar1h_, dc2_, ds2_, ar2_, ai2_, ar2h_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  tpi_ = 6.2831853;
  arg_ = tpi_ / (real_4) ((*ip_));
  dcp_ = cosf (arg_);
  dsp_ = sinf (arg_);
  ipph_ = ((*ip_) + 1) / 2;
  ipp2_ = (*ip_) + 2;
  idp2_ = (*ido_) + 2;
  nbd_ = ((*ido_) - 1) / 2;
  if ((*ido_) == 1) {
    goto _l119;
  }
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
      ((0)))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  if (nbd_ > (*l1_)) {
    goto _l107;
  }
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    idij_ = is_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * 
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * c1_[m1_ - 
          1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * c1_[m1_ - 
          1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * c1_[m1_ - 1 + ((*in1_)) 
          * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l111;
  _l107:;
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = is_;
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * 
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * c1_[m1_ - 
          1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * c1_[m1_ - 
          1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * c1_[m1_ - 1 + ((*in1_)) 
          * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  _l111:;
  if (nbd_ < (*l1_)) {
    goto _l115;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) 
          * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((i_ 
          - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
          ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) 
          * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l121;
  _l115:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) 
          * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((i_ 
          - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
          ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) 
          * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l121;
  _l119:;
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
      ((0)))];
    }
  }
  _l121:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1))))];
      }
    }
  }
  ar1_ = 1.0;
  ai1_ = 0.0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    ar1h_ = dcp_ * ar1_ - dsp_ * ai1_;
    ai1_ = dcp_ * ai1_ + dsp_ * ar1_;
    ar1_ = ar1h_;
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
        ((0)))] + ar1_ * c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((1)))];
        ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ai1_ * c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + 
        ((*idl1_)) * (((*ip_) - 1)))];
      }
    }
    dc2_ = ar1_;
    ds2_ = ai1_;
    ar2_ = ar1_;
    ai2_ = ai1_;
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      ar2h_ = dc2_ * ar2_ - ds2_ * ai2_;
      ai2_ = dc2_ * ai2_ + ds2_ * ar2_;
      ar2_ = ar2h_;
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) 
          * ((l_ - 1)))] + ar2_ * c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
          ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) 
          * ((lc_ - 1)))] + ai2_ * c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((jc_ - 1)))];
        }
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
        ((0)))] + c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
      }
    }
  }
  if ((*ido_) < (*l1_)) {
    goto _l132;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
      }
    }
  }
  goto _l135;
  _l132:;
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
      }
    }
  }
  _l135:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
        ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((0) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
      }
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  if (nbd_ < (*l1_)) {
    goto _l141;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ic_ = idp2_ - i_;
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
          ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) 
          + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
          ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) 
          + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) 
          * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l0;
  _l141:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
          ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) 
          + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
          ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) 
          + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) 
          * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  _l0:;
  __calls[64].calls++;
  return 0;
}

int_4 _dmrftb1 (int_4 _p_ m_, int_4 _p_ im_, int_4 _p_ n_, int_4 _p_ in_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_
, real_8 _p_ fac_)
{
  static int_4 nf_, na_, k1_, ip_, modn_, nl_, m2_, i_, j_, l1_, iw_, l2_, ido_, idl1_, ix2_, ix3_, ix4_;
  static real_4 half_, halfm_;
  nf_ = fac_[1];
  na_ = 0;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    na_ = 1 - na_;
    if (ip_ <= 5) {
      goto _l10;
    }
    if (k1_ == nf_) {
      goto _l10;
    }
    na_ = 1 - na_;
    _l10:;
  }
  half_ = .5;
  halfm_ = -.5;
  modn_ = _imod ((*n_), 2);
  nl_ = (*n_) - 2;
  if (modn_ != 0) {
    nl_ = (*n_) - 1;
  }
  if (na_ == 0) {
    goto _l120;
  }
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    ch_[i_ - 1 + ((*m_)) * ((0))] = c_[m2_ - 1 + ((*in_)) * ((0))];
    ch_[i_ - 1 + ((*m_)) * (((*n_) - 1))] = c_[m2_ - 1 + ((*in_)) * (((*n_) - 1))];
  }
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    m2_ = 1 - (*im_);
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      m2_ = m2_ + (*im_);
      ch_[i_ - 1 + ((*m_)) * ((j_ - 1))] = half_ * c_[m2_ - 1 + ((*in_)) * ((j_ - 1))];
      ch_[i_ - 1 + ((*m_)) * ((j_ + 1 - 1))] = halfm_ * c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))];
    }
  }
  goto _l124;
  _l120:;
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    m2_ = 1 - (*im_);
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      m2_ = m2_ + (*im_);
      c_[m2_ - 1 + ((*in_)) * ((j_ - 1))] = half_ * c_[m2_ - 1 + ((*in_)) * ((j_ - 1))];
      c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))] = halfm_ * c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))];
    }
  }
  _l124:;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    idl1_ = ido_ * l1_;
    if (ip_ != 4) {
      goto _l103;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _dmradb4 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l102;
    _l101:;
    (void) _dmradb4 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    _l102:;
    na_ = 1 - na_;
    goto _l115;
    _l103:;
    if (ip_ != 2) {
      goto _l106;
    }
    if (na_ != 0) {
      goto _l104;
    }
    (void) _dmradb2 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1]);
    goto _l105;
    _l104:;
    (void) _dmradb2 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1]);
    _l105:;
    na_ = 1 - na_;
    goto _l115;
    _l106:;
    if (ip_ != 3) {
      goto _l109;
    }
    ix2_ = iw_ + ido_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _dmradb3 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l108;
    _l107:;
    (void) _dmradb3 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    _l108:;
    na_ = 1 - na_;
    goto _l115;
    _l109:;
    if (ip_ != 5) {
      goto _l112;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    ix4_ = ix3_ + ido_;
    if (na_ != 0) {
      goto _l110;
    }
    (void) _dmradb5 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ 
    - 1]);
    goto _l111;
    _l110:;
    (void) _dmradb5 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ 
    - 1]);
    _l111:;
    na_ = 1 - na_;
    goto _l115;
    _l112:;
    if (na_ != 0) {
      goto _l113;
    }
    (void) _dmradbg (m_, &ido_, &ip_, &l1_, &idl1_, c_, c_, c_, im_, in_, ch_, ch_, &_k1, m_, &wa_[iw_ - 1]);
    goto _l114;
    _l113:;
    (void) _dmradbg (m_, &ido_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, &_k1, m_, c_, c_, im_, in_, &wa_[iw_ - 1]);
    _l114:;
    if (ido_ == 1) {
      na_ = 1 - na_;
    }
    _l115:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * ido_;
  }
  __calls[65].calls++;
  return 0;
}

int_4 _dmrftf1 (int_4 _p_ m_, int_4 _p_ im_, int_4 _p_ n_, int_4 _p_ in_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_
, real_8 _p_ fac_)
{
  static int_4 nf_, na_, l2_, iw_, k1_, kh_, ip_, l1_, ido_, idl1_, ix2_, ix3_, ix4_, modn_, nl_, m2_, i_, j_;
  static real_4 sn_, tsn_, tsnm_;
  nf_ = fac_[1];
  na_ = 1;
  l2_ = (*n_);
  iw_ = (*n_);
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    kh_ = nf_ - k1_;
    ip_ = fac_[kh_ + 3 - 1];
    l1_ = l2_ / ip_;
    ido_ = (*n_) / l2_;
    idl1_ = ido_ * l1_;
    iw_ = iw_ - (ip_ - 1) * ido_;
    na_ = 1 - na_;
    if (ip_ != 4) {
      goto _l102;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _dmradf4 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l110;
    _l101:;
    (void) _dmradf4 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l110;
    _l102:;
    if (ip_ != 2) {
      goto _l104;
    }
    if (na_ != 0) {
      goto _l103;
    }
    (void) _dmradf2 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1]);
    goto _l110;
    _l103:;
    (void) _dmradf2 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1]);
    goto _l110;
    _l104:;
    if (ip_ != 3) {
      goto _l106;
    }
    ix2_ = iw_ + ido_;
    if (na_ != 0) {
      goto _l105;
    }
    (void) _dmradf3 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l110;
    _l105:;
    (void) _dmradf3 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l110;
    _l106:;
    if (ip_ != 5) {
      goto _l108;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    ix4_ = ix3_ + ido_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _dmradf5 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ 
    - 1]);
    goto _l110;
    _l107:;
    (void) _dmradf5 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ 
    - 1]);
    goto _l110;
    _l108:;
    if (ido_ == 1) {
      na_ = 1 - na_;
    }
    if (na_ != 0) {
      goto _l109;
    }
    (void) _dmradfg (m_, &ido_, &ip_, &l1_, &idl1_, c_, c_, c_, im_, in_, ch_, ch_, &_k1, m_, &wa_[iw_ - 1]);
    na_ = 1;
    goto _l110;
    _l109:;
    (void) _dmradfg (m_, &ido_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, &_k1, m_, c_, c_, im_, in_, &wa_[iw_ - 1]);
    na_ = 0;
    _l110:;
    l2_ = l1_;
  }
  sn_ = 1.0 / (*n_);
  tsn_ = 2.0 / (*n_);
  tsnm_ = -tsn_;
  modn_ = _imod ((*n_), 2);
  nl_ = (*n_) - 2;
  if (modn_ != 0) {
    nl_ = (*n_) - 1;
  }
  if (na_ != 0) {
    goto _l120;
  }
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    c_[m2_ - 1 + ((*in_)) * ((0))] = sn_ * ch_[i_ - 1 + ((*m_)) * ((0))];
  }
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    m2_ = 1 - (*im_);
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      m2_ = m2_ + (*im_);
      c_[m2_ - 1 + ((*in_)) * ((j_ - 1))] = tsn_ * ch_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))] = tsnm_ * ch_[i_ - 1 + ((*m_)) * ((j_ + 1 - 1))];
    }
  }
  if (modn_ != 0) {
    goto _l0;
  }
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    c_[m2_ - 1 + ((*in_)) * (((*n_) - 1))] = sn_ * ch_[i_ - 1 + ((*m_)) * (((*n_) - 1))];
  }
  goto _l0;
  _l120:;
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    c_[m2_ - 1 + ((*in_)) * ((0))] = sn_ * c_[m2_ - 1 + ((*in_)) * ((0))];
  }
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    m2_ = 1 - (*im_);
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      m2_ = m2_ + (*im_);
      c_[m2_ - 1 + ((*in_)) * ((j_ - 1))] = tsn_ * c_[m2_ - 1 + ((*in_)) * ((j_ - 1))];
      c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))] = tsnm_ * c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))];
    }
  }
  if (modn_ != 0) {
    goto _l0;
  }
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    c_[m2_ - 1 + ((*in_)) * (((*n_) - 1))] = sn_ * c_[m2_ - 1 + ((*in_)) * (((*n_) - 1))];
  }
  _l0:;
  __calls[66].calls++;
  return 0;
}

int_4 _dmrfti1 (int_4 _p_ n_, real_8 _p_ wa_, real_8 _p_ fac_)
{
  static int_4 ntryh_[4], nl_, nf_, j_, ntry_, nq_, nr_, i_, ib_, is_, nfm1_, l1_, k1_, ip_, ld_, l2_, ido_, ipm_, ii_;
  static real_4 fi_;
  static real_8 tpi_, argh_, argld_, arg_;
  int_4 _data_k_9, $0_, $1_;
#define _data_n_9 4
  static int_4 _data_l_9[_data_n_9] = {
    4,
    2,
    3,
    5
  };
  if (__calls[67].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    ntryh_[0] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    ntryh_[1] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    ntryh_[2] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    ntryh_[3] = _data_l_9[_data_k_9++];
  }
  nl_ = (*n_);
  nf_ = 0;
  j_ = 0;
  _l101:;
  j_ = j_ + 1;
  $0_ = j_ - 4;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ntry_ = ntryh_[j_ - 1];
  goto _l104;
  _l103:;
  ntry_ = ntry_ + 2;
  _l104:;
  nq_ = nl_ / ntry_;
  nr_ = nl_ - ntry_ * nq_;
  $1_ = nr_;
  if ($1_ < 0) {
    goto _l101;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  nf_ = nf_ + 1;
  fac_[nf_ + 2 - 1] = ntry_;
  nl_ = nq_;
  if (ntry_ != 2) {
    goto _l107;
  }
  if (nf_ == 1) {
    goto _l107;
  }
  for (i_ = 2; i_ <= nf_; (i_)++) {
    ib_ = nf_ - i_ + 2;
    fac_[ib_ + 2 - 1] = fac_[ib_ + 1 - 1];
  }
  fac_[2] = 2;
  _l107:;
  if (nl_ != 1) {
    goto _l104;
  }
  fac_[0] = (*n_);
  fac_[1] = nf_;
  tpi_ = 6.2831853071795865;
  argh_ = tpi_ / (real_4) ((*n_));
  is_ = 0;
  nfm1_ = nf_ - 1;
  l1_ = 1;
  if (nfm1_ == 0) {
    goto _l0;
  }
  for (k1_ = 1; k1_ <= nfm1_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    ld_ = 0;
    l2_ = l1_ * ip_;
    ido_ = (*n_) / l2_;
    ipm_ = ip_ - 1;
    for (j_ = 1; j_ <= ipm_; (j_)++) {
      ld_ = ld_ + l1_;
      i_ = is_;
      argld_ = (real_4) (ld_) * argh_;
      fi_ = 0.0;
      for (ii_ = 3; (2 > 0 ? ii_ <= ido_ : ii_ >= ido_); ii_ += 2) {
        i_ = i_ + 2;
        fi_ = fi_ + 1.0;
        arg_ = fi_ * argld_;
        wa_[i_ - 1 - 1] = cos (arg_);
        wa_[i_ - 1] = sin (arg_);
      }
      is_ = is_ + ido_;
    }
    l1_ = l2_;
  }
  _l0:;
  __calls[67].calls++;
  return 0;
}

int_4 _dmsntb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_8 
_p_ dsum_, real_8 _p_ xh_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, np1_, ns2_, k_, kc_, m1_, modn_, lnxh_, lnsv_, lnwk_, ier1_, i_;
  static real_4 srt3s2_, xhold_, t1_, t2_, fnp1s4_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l200;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  srt3s2_ = 0.8660254;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    xhold_ = srt3s2_ * (x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((1))] = srt3s2_ * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = xhold_;
  }
  goto _l200;
  _l103:;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      t1_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      t2_ = wsave_[k_ - 1] * (x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))]);
      xh_[m1_ - 1 + ((*lot_)) * ((k_ + 1 - 1))] = t1_ + t2_;
      xh_[m1_ - 1 + ((*lot_)) * ((kc_ + 1 - 1))] = t2_ - t1_;
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    xh_[m1_ - 1 + ((*lot_)) * ((ns2_ + 2 - 1))] = 4.0 * x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))];
  }
  _l124:;
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    xh_[m_ - 1 + ((*lot_)) * ((0))] = 0.0;
  }
  lnxh_ = (*lot_) - 1 + (*lot_) * (np1_ - 1) + 1;
  lnsv_ = np1_ + (int_4) (_aintd (log ((real_8) (np1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * np1_;
  (void) _drfftmf (lot_, &_k1, &np1_, lot_, xh_, &lnxh_, &wsave_[ns2_ + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_28, ($1_ = -5, &$1_));
    goto _l200;
  }
  if (_imod (np1_, 2) != 0) {
    goto _l30;
  }
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    xh_[m_ - 1 + ((*lot_)) * ((np1_ - 1))] = xh_[m_ - 1 + ((*lot_)) * ((np1_ - 1))] + xh_[m_ - 1 + ((*lot_)) * ((np1_ - 
    1))];
  }
  _l30:;
  fnp1s4_ = (real_4) (np1_) / 4.0;
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * ((0))] = fnp1s4_ * xh_[m1_ - 1 + ((*lot_)) * ((0))];
    dsum_[m1_ - 1] = x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = fnp1s4_ * xh_[m1_ - 1 + ((*lot_)) * ((i_ - 1))];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + fnp1s4_ * xh_[m1_ - 1 + ((*lot_)) * ((i_ - 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = dsum_[m1_ - 1];
    }
  }
  if (modn_ != 0) {
    goto _l200;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = fnp1s4_ * xh_[m1_ - 1 + ((*lot_)) * (((*n_) + 1 - 1))];
  }
  _l200:;
  __calls[68].calls++;
  return 0;
}

int_4 _dmsntf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_8 
_p_ dsum_, real_8 _p_ xh_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, np1_, ns2_, k_, kc_, m1_, modn_, lnxh_, lnsv_, lnwk_, ier1_, i_;
  static real_4 ssqrt3_, xhold_, t1_, t2_, sfnp1_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ssqrt3_ = 5.7735027e-1;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    xhold_ = ssqrt3_ * (x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((1))] = ssqrt3_ * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = xhold_;
  }
  _l101:;
  goto _l200;
  _l103:;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      t1_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      t2_ = wsave_[k_ - 1] * (x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))]);
      xh_[m1_ - 1 + ((*lot_)) * ((k_ + 1 - 1))] = t1_ + t2_;
      xh_[m1_ - 1 + ((*lot_)) * ((kc_ + 1 - 1))] = t2_ - t1_;
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    xh_[m1_ - 1 + ((*lot_)) * ((ns2_ + 2 - 1))] = 4.0 * x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))];
  }
  _l124:;
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    xh_[m_ - 1 + ((*lot_)) * ((0))] = 0.0;
  }
  lnxh_ = (*lot_) - 1 + (*lot_) * (np1_ - 1) + 1;
  lnsv_ = np1_ + (int_4) (_aintd (log ((real_8) (np1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * np1_;
  (void) _drfftmf (lot_, &_k1, &np1_, lot_, xh_, &lnxh_, &wsave_[ns2_ + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_29, ($1_ = -5, &$1_));
    goto _l200;
  }
  if (_imod (np1_, 2) != 0) {
    goto _l30;
  }
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    xh_[m_ - 1 + ((*lot_)) * ((np1_ - 1))] = xh_[m_ - 1 + ((*lot_)) * ((np1_ - 1))] + xh_[m_ - 1 + ((*lot_)) * ((np1_ - 
    1))];
  }
  _l30:;
  sfnp1_ = 1.0 / (real_4) (np1_);
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * xh_[m1_ - 1 + ((*lot_)) * ((0))];
    dsum_[m1_ - 1] = x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = .5 * xh_[m1_ - 1 + ((*lot_)) * ((i_ - 1))];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + .5 * xh_[m1_ - 1 + ((*lot_)) * ((i_ - 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = dsum_[m1_ - 1];
    }
  }
  if (modn_ != 0) {
    goto _l200;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = .5 * xh_[m1_ - 1 + ((*lot_)) * (((*n_) + 1 - 1))];
  }
  _l200:;
  __calls[69].calls++;
  return 0;
}

int_4 _dr1f2kb (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_, real_8 
_p_ wa1_)
{
  static int_4 k_, idp2_, i_, ic_;
  int_4 $0_;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (2) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))];
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))];
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) 
      * ((0) + (2) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))];
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * (cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) 
      * ((k_ - 1))))]) - wa1_[i_ - 1 - 1] * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * (cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 
      1))))]) + wa1_[i_ - 1 - 1] * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
    ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = -(cc_[0 + ((*in1_)) * ((0) + 
    ((*ido_)) * ((1) + (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
  }
  _l107:;
  _l0:;
  __calls[70].calls++;
  return 0;
}

int_4 _dr1f2kf (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_, real_8 
_p_ wa1_)
{
  static int_4 k_, idp2_, i_, ic_;
  int_4 $0_;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((0))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((0))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]);
      ch_[0 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))]) - cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]);
      ch_[0 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]);
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = -cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((1))))];
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
    ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
  }
  _l107:;
  _l0:;
  __calls[71].calls++;
  return 0;
}

int_4 _dr1f3kb (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_, real_8 
_p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_4 arg_, taur_, taui_;
  arg_ = 2.0943951;
  taur_ = cosf (arg_);
  taui_ = sinf (arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (3) * ((k_ - 1))))] + 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (3) * ((k_ - 1))))] + (2.0 * taur_) * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] - 
    (2.0 * taui_) * cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (3) * ((k_ - 1))))] + (2.0 * taur_) * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] + 2.0 
    * taui_ * cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))];
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + 
      cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) 
      * ((0) + (3) * ((k_ - 1))))] + (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) 
      - (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) - wa1_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) 
      * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * 
      ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) 
      + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * 
      ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + (taui_ * (cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) 
      * ((k_ - 1))))]))) + wa1_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + 
      taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ 
      - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) 
      + (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) - wa2_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) 
      * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * 
      ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) 
      + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * 
      ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - (taui_ * (cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) 
      * ((k_ - 1))))]))) + wa2_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + 
      taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ 
      - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
    }
  }
  _l0:;
  __calls[72].calls++;
  return 0;
}

int_4 _dr1f3kf (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_, real_8 
_p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_4 arg_, taur_, taui_;
  arg_ = 2.0943951;
  taur_ = cosf (arg_);
  taui_ = sinf (arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((0))))] + (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[0 + ((*in1_)) * 
    ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = taui_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((2))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]);
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + 
    cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
      wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + 
      (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) 
      + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]))) + (taui_ * 
      ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa2_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
      ch_[0 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) 
      + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]))) - (taui_ * 
      ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa2_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 
      1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]))) + (taui_ * ((wa2_[i_ - 2 - 
      1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))])));
      ch_[0 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = (taui_ * ((wa2_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]))) - (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((2))))])));
    }
  }
  _l0:;
  __calls[73].calls++;
  return 0;
}

int_4 _dr1f4kb (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_, real_8 
_p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_4 sqrt2_;
  int_4 $0_;
  sqrt2_ = 1.4142136;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[0 + ((*in1_)) 
    * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) 
    * ((k_ - 1))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + (cc_[0 + ((*in1_)) 
    * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) 
    * ((k_ - 1))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + (cc_[0 + ((*in1_)) 
    * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[0 + ((*in1_)) 
    * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + 
      (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + 
      ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + 
      (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
      ((1) + (4) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * 
      ((3) + (4) * ((k_ - 1))))]) - (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa1_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) 
      + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + 
      (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + 
      ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) + (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa1_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + 
      (4) * ((k_ - 1))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * 
      ((3) + (4) * ((k_ - 1))))]) - (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa2_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 
      1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) 
      - (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) 
      * ((1) + (4) * ((k_ - 1))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) - (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa2_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + 
      (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) 
      * ((k_ - 1))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * 
      ((3) + (4) * ((k_ - 1))))]) + (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa3_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) 
      + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - 
      (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + 
      ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) - (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa3_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + (cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + 
      (4) * ((k_ - 1))))]));
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[0 + ((*in1_)) * (((*ido_) - 1) 
    + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))]) 
    + (cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
    ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sqrt2_ * ((cc_[0 + ((*in1_)) * 
    (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + (4) * 
    ((k_ - 1))))]) - (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((0) + 
    ((*ido_)) * ((3) + (4) * ((k_ - 1))))]));
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[0 + ((*in1_)) * ((0) + 
    ((*ido_)) * ((3) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]) + (cc_[0 + 
    ((*in1_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 
    1))))]);
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = -sqrt2_ * ((cc_[0 + ((*in1_)) * 
    (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + (4) * 
    ((k_ - 1))))]) + (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((0) + 
    ((*ido_)) * ((3) + (4) * ((k_ - 1))))]));
  }
  _l107:;
  _l0:;
  __calls[74].calls++;
  return 0;
}

int_4 _dr1f4kf (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_, real_8 
_p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_4 hsqt2_;
  int_4 $0_;
  hsqt2_ = 7.0710678e-1;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((1))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) + (cc_[0 + ((*in1_)) * 
    ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
    ((2))))]);
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((0))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (cc_[0 + 
    ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((3))))]);
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((0))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((3))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((3))))])) + (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa2_[i_ - 2 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) 
      * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))])) - ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + 
      wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) 
      * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))])) + 
      (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))])) - 
      (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((3))))])) + (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa2_[i_ - 2 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) 
      * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))])) - ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ 
      - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa3_[i_ - 2 - 1] * cc_[0 
      + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = ((wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ 
      - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) 
      + (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) 
      * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = ((wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ 
      - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) 
      - (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) 
      * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = (hsqt2_ * (cc_[0 + ((*in1_)) * (((*ido_) 
    - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((3))))])) + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
    ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (hsqt2_ * (cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((1))))] - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = (-hsqt2_ * (cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
    ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
    ((3))))])) - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (-hsqt2_ * (cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
    ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
    ((3))))])) + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))];
  }
  _l107:;
  _l0:;
  __calls[75].calls++;
  return 0;
}

int_4 _dr1f5kb (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_, real_8 
_p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_4 arg_, tr11_, ti11_, tr12_, ti12_;
  arg_ = 1.2566371;
  tr11_ = cosf (arg_);
  ti11_ = sinf (arg_);
  tr12_ = cosf (2.0 * arg_);
  ti12_ = sinf (2.0 * arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (5) * ((k_ - 1))))] + 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] + 2.0 * cc_[0 + 
    ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] + tr12_ 
    * 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) - (ti11_ * 2.0 * cc_[0 + ((*in1_)) 
    * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + ti12_ * 2.0 * cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * 
    ((k_ - 1))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] + tr11_ 
    * 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) - (ti12_ * 2.0 * cc_[0 + ((*in1_)) 
    * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - ti11_ * 2.0 * cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * 
    ((k_ - 1))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] + tr11_ 
    * 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) + (ti12_ * 2.0 * cc_[0 + ((*in1_)) 
    * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - ti11_ * 2.0 * cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * 
    ((k_ - 1))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] + tr12_ 
    * 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) + (ti11_ * 2.0 * cc_[0 + ((*in1_)) 
    * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + ti12_ * 2.0 * cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * 
    ((k_ - 1))))]);
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + 
      cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) 
      * ((0) + (5) * ((k_ - 1))))] + (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + 
      (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + 
      tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ 
      - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[0 + ((*in1_)) * ((i_ 
      - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 
      1))))]))) - wa1_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * 
      (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
      ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + 
      ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
      ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 
      1))))])) + (ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * 
      ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa1_[i_ - 
      1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * 
      ((k_ - 1))))]) + tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + 
      ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + 
      tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ 
      - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[0 + ((*in1_)) * ((i_ 
      - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 
      1))))]))) - wa2_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * 
      (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
      ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - 
      ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
      ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 
      1))))])) + (ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * 
      ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa2_[i_ - 
      1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * 
      ((k_ - 1))))]) + tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - 
      ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + 
      tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ 
      - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[0 + ((*in1_)) * ((i_ 
      - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 
      1))))]))) - wa3_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * 
      (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
      ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - 
      ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
      ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 
      1))))])) - (ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * 
      ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa3_[i_ - 
      1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * 
      ((k_ - 1))))]) + tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - 
      ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = wa4_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + 
      tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ 
      - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[0 + ((*in1_)) * ((i_ 
      - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 
      1))))]))) - wa4_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * 
      (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
      ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + 
      ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = wa4_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
      ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 
      1))))])) - (ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * 
      ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((4) + (5) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa4_[i_ - 
      1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * 
      ((k_ - 1))))]) + tr12_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + 
      ti12_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
    }
  }
  _l0:;
  __calls[76].calls++;
  return 0;
}

int_4 _dr1f5kf (int_4 _p_ ido_, int_4 _p_ l1_, real_8 _p_ cc_, int_4 _p_ in1_, real_8 _p_ ch_, int_4 _p_ in2_, real_8 
_p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_4 arg_, tr11_, ti11_, tr12_, ti12_;
  arg_ = 1.2566371;
  tr11_ = cosf (arg_);
  ti11_ = sinf (arg_);
  tr12_ = cosf (2.0 * arg_);
  ti12_ = sinf (2.0 * arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((0))))] + (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + cc_[0 + ((*in1_)) * 
    ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
    ((3))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + 
    cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + tr12_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) 
    * ((k_ - 1) + ((*l1_)) * ((3))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = ti11_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((4))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + ti12_ * 
    (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 
    1) + ((*l1_)) * ((2))))]);
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + 
    cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + tr11_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) 
    * ((k_ - 1) + ((*l1_)) * ((3))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = ti12_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((4))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - ti11_ * 
    (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 
    1) + ((*l1_)) * ((2))))]);
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + 
      wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + ((wa2_[i_ - 2 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) 
      * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) 
      + ((*l1_)) * ((3))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + 
      (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + ((wa2_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((3))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) 
      * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((1))))] + wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + 
      wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) + tr12_ * (wa2_[i_ - 2 
      - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((3))))]) + ti11_ * (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))] - (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 
      1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + ti12_ * (wa2_[i_ - 2 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((3))))]));
      ch_[0 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) 
      * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((1))))] + wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + 
      wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) + tr12_ * (wa2_[i_ - 2 
      - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((3))))]) - (ti11_ * (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))] - (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 
      1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + ti12_ * (wa2_[i_ - 2 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((3))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 
      1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr12_ * ((wa2_[i_ - 2 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((3))))]))) + (ti11_ * ((wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - 
      (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) + ti12_ * ((wa3_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))])));
      ch_[0 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = (ti11_ * ((wa4_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))])) + ti12_ * ((wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 
      2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]))) - (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 
      1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr12_ * ((wa2_[i_ - 2 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((3))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) 
      + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((4))))] + wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr11_ * 
      ((wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) + (ti12_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((1))))]) - (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((4))))] - wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) - ti11_ 
      * ((wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa3_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))])));
      ch_[0 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) 
      + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((4))))] + wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr11_ * 
      ((wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) - (ti12_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((1))))]) - (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((4))))] - wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) - ti11_ 
      * ((wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa3_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 
      1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((3))))]))) + (ti12_ * ((wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - 
      (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) - ti11_ * ((wa3_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))])));
      ch_[0 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = (ti12_ * ((wa4_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))])) - ti11_ * ((wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((3))))] + wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 
      2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]))) - (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 
      1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] 
      * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * 
      ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
      1) + ((*l1_)) * ((3))))])));
    }
  }
  _l0:;
  __calls[77].calls++;
  return 0;
}

int_4 _dr1fgkb (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ c1_, real_8 
_p_ c2_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 idp2_, nbd_, ipp2_, ipph_, k_, i_, j_, jc_, j2_, ic_, l_, lc_, ik_, is_, idij_;
  static real_4 tpi_, arg_, dcp_, dsp_, ar1_, ai1_, ar1h_, dc2_, ds2_, ar2_, ai2_, ar2h_;
  tpi_ = 6.2831853;
  arg_ = tpi_ / (real_4) ((*ip_));
  dcp_ = cosf (arg_);
  dsp_ = sinf (arg_);
  idp2_ = (*ido_) + 2;
  nbd_ = ((*ido_) - 1) / 2;
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  if ((*ido_) < (*l1_)) {
    goto _l103;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) 
      * ((0) + ((*ip_)) * ((k_ - 1))))];
    }
  }
  goto _l106;
  _l103:;
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) 
      * ((0) + ((*ip_)) * ((k_ - 1))))];
    }
  }
  _l106:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
      ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((j2_ - 2 - 1) 
      + ((*ip_)) * ((k_ - 1))))];
      ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 
      1))))];
    }
  }
  if ((*ido_) == 1) {
    goto _l116;
  }
  if (nbd_ < (*l1_)) {
    goto _l112;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ic_ = idp2_ - i_;
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((2 * 
        j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((2 * 
        j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((2 * j_ - 2 - 
        1) + ((*ip_)) * ((k_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((2 * j_ - 2 - 
        1) + ((*ip_)) * ((k_ - 1))))];
      }
    }
  }
  goto _l116;
  _l112:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((2 * 
        j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((2 * 
        j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((2 * j_ - 2 - 
        1) + ((*ip_)) * ((k_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((2 * j_ - 2 - 
        1) + ((*ip_)) * ((k_ - 1))))];
      }
    }
  }
  _l116:;
  ar1_ = 1.0;
  ai1_ = 0.0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    ar1h_ = dcp_ * ar1_ - dsp_ * ai1_;
    ai1_ = dcp_ * ai1_ + dsp_ * ar1_;
    ar1_ = ar1h_;
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] + 
      ar1_ * ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((1)))];
      c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ai1_ * ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
      (((*ip_) - 1)))];
    }
    dc2_ = ar1_;
    ds2_ = ai1_;
    ar2_ = ar1_;
    ai2_ = ai1_;
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      ar2h_ = dc2_ * ar2_ - ds2_ * ai2_;
      ai2_ = dc2_ * ai2_ + ds2_ * ar2_;
      ar2_ = ar2h_;
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] 
        + ar2_ * ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
        c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 
        1)))] + ai2_ * ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((jc_ - 1)))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] + 
      ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
      ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
    }
  }
  if ((*ido_) == 1) {
    goto _l132;
  }
  if (nbd_ < (*l1_)) {
    goto _l128;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[0 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[0 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[0 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
        * ((jc_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[0 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
        * ((jc_ - 1))))];
      }
    }
  }
  goto _l132;
  _l128:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[0 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[0 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[0 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
        * ((jc_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[0 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
        * ((jc_ - 1))))];
      }
    }
  }
  _l132:;
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))];
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      c1_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
    }
  }
  if (nbd_ > (*l1_)) {
    goto _l139;
  }
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    idij_ = is_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * ch_[0 + 
        ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * ch_[0 + ((*in2_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * ch_[0 + 
        ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * ch_[0 + ((*in2_)) * ((i_ - 
        1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  goto _l143;
  _l139:;
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = is_;
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * ch_[0 + 
        ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * ch_[0 + ((*in2_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * ch_[0 + 
        ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * ch_[0 + ((*in2_)) * ((i_ - 
        1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  _l143:;
  _l0:;
  __calls[78].calls++;
  return 0;
}

int_4 _dr1fgkf (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_8 _p_ cc_, real_8 _p_ c1_, real_8 
_p_ c2_, int_4 _p_ in1_, real_8 _p_ ch_, real_8 _p_ ch2_, int_4 _p_ in2_, real_8 _p_ wa_)
{
  static int_4 ipph_, ipp2_, idp2_, nbd_, ik_, j_, k_, is_, idij_, i_, jc_, l_, lc_, j2_, ic_;
  static real_4 tpi_, arg_, dcp_, dsp_, ar1_, ai1_, ar1h_, dc2_, ds2_, ar2_, ai2_, ar2h_;
  tpi_ = 6.2831853;
  arg_ = tpi_ / (real_4) ((*ip_));
  dcp_ = cosf (arg_);
  dsp_ = sinf (arg_);
  ipph_ = ((*ip_) + 1) / 2;
  ipp2_ = (*ip_) + 2;
  idp2_ = (*ido_) + 2;
  nbd_ = ((*ido_) - 1) / 2;
  if ((*ido_) == 1) {
    goto _l119;
  }
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))];
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
    }
  }
  if (nbd_ > (*l1_)) {
    goto _l107;
  }
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    idij_ = is_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * c1_[0 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * c1_[0 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * c1_[0 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * c1_[0 + ((*in1_)) * ((i_ - 
        1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  goto _l111;
  _l107:;
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = is_;
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * c1_[0 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * c1_[0 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * c1_[0 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * c1_[0 + ((*in1_)) * ((i_ - 
        1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  _l111:;
  if (nbd_ < (*l1_)) {
    goto _l115;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  goto _l121;
  _l115:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        c1_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        c1_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  goto _l121;
  _l119:;
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))];
  }
  _l121:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      c1_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
      c1_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
    }
  }
  ar1_ = 1.0;
  ai1_ = 0.0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    ar1h_ = dcp_ * ar1_ - dsp_ * ai1_;
    ai1_ = dcp_ * ai1_ + dsp_ * ar1_;
    ar1_ = ar1h_;
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] + 
      ar1_ * c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((1)))];
      ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ai1_ * c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
      (((*ip_) - 1)))];
    }
    dc2_ = ar1_;
    ds2_ = ai1_;
    ar2_ = ar1_;
    ai2_ = ai1_;
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      ar2h_ = dc2_ * ar2_ - ds2_ * ai2_;
      ai2_ = dc2_ * ai2_ + ds2_ * ar2_;
      ar2_ = ar2h_;
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 
        1)))] + ar2_ * c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
        ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 
        1)))] + ai2_ * c2_[0 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((jc_ - 1)))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[0 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] + c2_[0 
      + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
    }
  }
  if ((*ido_) < (*l1_)) {
    goto _l132;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) 
      * ((k_ - 1) + ((*l1_)) * ((0))))];
    }
  }
  goto _l135;
  _l132:;
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) 
      * ((k_ - 1) + ((*l1_)) * ((0))))];
    }
  }
  _l135:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((0) + ((*ido_)) 
      * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  if (nbd_ < (*l1_)) {
    goto _l141;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ic_ = idp2_ - i_;
        cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 
        1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 
        1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
        * ((j_ - 1))))];
      }
    }
  }
  goto _l0;
  _l141:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 
        1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 
        1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((jc_ - 1))))];
        cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[0 + ((*in2_)) * ((i_ - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
        * ((j_ - 1))))];
      }
    }
  }
  _l0:;
  __calls[79].calls++;
  return 0;
}

int_4 _dr2w (int_4 _p_ ldr_, int_4 _p_ ldw_, int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ r_, real_8 _p_ w_)
{
  static int_4 j_, i_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*l_); (i_)++) {
      w_[i_ - 1 + ((*ldw_)) * ((j_ - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
    }
  }
  __calls[80].calls++;
  return 0;
}

int_4 _drfft1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ r_, int_4 _p_ lenr_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenr_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_30, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_30, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_30, ($2_ = 10, &$2_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _drfftb1 (n_, inc_, r_, work_, wsave_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[81].calls++;
  return 0;
}

int_4 _drfft1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ r_, int_4 _p_ lenr_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenr_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_31, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_31, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_31, ($2_ = 10, &$2_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _drfftf1 (n_, inc_, r_, work_, wsave_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[82].calls++;
  return 0;
}

int_4 _drfft1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  int_4 $0_;
  (*ier_) = 0;
  if ((*lensav_) < (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_32, ($0_ = 3, &$0_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _drffti1 (n_, &wsave_[0], &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[83].calls++;
  return 0;
}

int_4 _drfft2b (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ r_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ldx_, lwsav_, mwsav_, mmsav_, modl_, modm_, j_, ier1_, ldh_, ldw_, i_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_;
  (*ier_) = 0;
  lwsav_ = (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  mwsav_ = 2 * (*m_) + (int_4) (_aintd (log ((real_8) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  mmsav_ = (*m_) + (int_4) (_aintd (log ((real_8) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  modl_ = _imod ((*l_), 2);
  modm_ = _imod ((*m_), 2);
  if ((*lensav_) < lwsav_ + mwsav_ + mmsav_) {
    (*ier_) = 2;
    (void) _xerfft (_dc_33, ($0_ = 6, &$0_));
    goto _l100;
  }
  if ((*lenwrk_) < ((*l_) + 1) * (*m_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_33, ($1_ = 8, &$1_));
    goto _l100;
  }
  if ((*ldim_) < (*l_)) {
    (*ier_) = 5;
    (void) _xerfft (_dc_33, ($2_ = -6, &$2_));
    goto _l100;
  }
  for (j_ = 2; j_ <= 2 * (((*m_) + 1) / 2) - 1; (j_)++) {
    r_[0 + ((*ldim_)) * ((j_ - 1))] = r_[0 + ((*ldim_)) * ((j_ - 1))] + r_[0 + ((*ldim_)) * ((j_ - 1))];
  }
  for (j_ = 3; (2 > 0 ? j_ <= (*m_) : j_ >= (*m_)); j_ += 2) {
    r_[0 + ((*ldim_)) * ((j_ - 1))] = -r_[0 + ((*ldim_)) * ((j_ - 1))];
  }
  (void) _drfftmb (&_k1, &_k1, m_, ldim_, r_, ($3_ = (*m_) * (*ldim_), &$3_), &wsave_[lwsav_ + mwsav_ + 1 - 1], &mmsav_, 
  work_, lenwrk_, &ier1_);
  ldh_ = (int_4) (_aintd (((*l_) + 1) / 2));
  if (ldh_ > 1) {
    ldw_ = ldh_ + ldh_;
    (void) _r2w (ldim_, &ldw_, l_, m_, r_, work_);
    (void) _dcfftmb (($4_ = ldh_ - 1, &$4_), &_k1, m_, &ldh_, &work_[1], ($5_ = ldh_ * (*m_), &$5_), &wsave_[lwsav_ + 1 - 
    1], &mwsav_, r_, ($6_ = (*l_) * (*m_), &$6_), &ier1_);
    if (ier1_ != 0) {
      (*ier_) = 20;
      (void) _xerfft (_dc_34, ($7_ = -5, &$7_));
      goto _l100;
    }
    (void) _w2r (ldim_, &ldw_, l_, m_, r_, work_);
  }
  if (modl_ == 0) {
    for (j_ = 2; j_ <= 2 * (((*m_) + 1) / 2) - 1; (j_)++) {
      r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 1))] = r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 1))] + r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 
      1))];
    }
    for (j_ = 3; (2 > 0 ? j_ <= (*m_) : j_ >= (*m_)); j_ += 2) {
      r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 1))] = -r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 1))];
    }
    (void) _drfftmb (&_k1, &_k1, m_, ldim_, &r_[(*l_) - 1 + ((*ldim_)) * ((0))], ($8_ = (*m_) * (*ldim_), &$8_), 
    &wsave_[lwsav_ + mwsav_ + 1 - 1], &mmsav_, work_, lenwrk_, &ier1_);
  }
  ldx_ = 2 * (int_4) (_aintd (((*l_) + 1) / 2)) - 1;
  for (i_ = 2; i_ <= ldx_; (i_)++) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))] = r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))] + r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))];
    }
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= ldx_ : i_ >= ldx_); i_ += 2) {
      r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))] = -r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))];
    }
  }
  (void) _drfftmb (m_, ldim_, l_, &_k1, r_, ($9_ = (*m_) * (*ldim_), &$9_), &wsave_[0], ($10_ = (*l_) + (int_4) (_aintd 
  (log ((real_8) ((*l_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$10_), 
  work_, lenwrk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_33, ($11_ = -5, &$11_));
    goto _l100;
  }
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_33, ($12_ = -5, &$12_));
    goto _l100;
  }
  _l100:;
  __calls[84].calls++;
  return 0;
}

int_4 _drfft2f (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ r_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 modl_, modm_, lwsav_, mwsav_, mmsav_, ier1_, ldx_, i_, j_, ldh_, ldw_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_;
  (*ier_) = 0;
  lwsav_ = (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  mwsav_ = 2 * (*m_) + (int_4) (_aintd (log ((real_8) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  mmsav_ = (*m_) + (int_4) (_aintd (log ((real_8) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  if ((*lensav_) < lwsav_ + mwsav_ + mmsav_) {
    (*ier_) = 2;
    (void) _xerfft (_dc_33, ($0_ = 6, &$0_));
    goto _l100;
  }
  if ((*lenwrk_) < ((*l_) + 1) * (*m_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_33, ($1_ = 8, &$1_));
    goto _l100;
  }
  if ((*ldim_) < (*l_)) {
    (*ier_) = 5;
    (void) _xerfft (_dc_33, ($2_ = -6, &$2_));
    goto _l100;
  }
  (void) _drfftmf (m_, ldim_, l_, &_k1, r_, ($3_ = (*m_) * (*ldim_), &$3_), &wsave_[0], ($4_ = (*l_) + (int_4) (_aintd 
  (log ((real_8) ((*l_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$4_), 
  work_, lenwrk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_33, ($5_ = -5, &$5_));
    goto _l100;
  }
  ldx_ = 2 * (int_4) (_aintd (((*l_) + 1) / 2)) - 1;
  for (i_ = 2; i_ <= ldx_; (i_)++) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))] = .5 * r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))];
    }
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= ldx_ : i_ >= ldx_); i_ += 2) {
      r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))] = -r_[i_ - 1 + ((*ldim_)) * ((j_ - 1))];
    }
  }
  modl_ = _imod ((*l_), 2);
  modm_ = _imod ((*m_), 2);
  (void) _drfftmf (&_k1, &_k1, m_, ldim_, r_, ($6_ = (*m_) * (*ldim_), &$6_), &wsave_[lwsav_ + mwsav_ + 1 - 1], &mmsav_, 
  work_, lenwrk_, &ier1_);
  for (j_ = 2; j_ <= 2 * (((*m_) + 1) / 2) - 1; (j_)++) {
    r_[0 + ((*ldim_)) * ((j_ - 1))] = .5 * r_[0 + ((*ldim_)) * ((j_ - 1))];
  }
  for (j_ = 3; (2 > 0 ? j_ <= (*m_) : j_ >= (*m_)); j_ += 2) {
    r_[0 + ((*ldim_)) * ((j_ - 1))] = -r_[0 + ((*ldim_)) * ((j_ - 1))];
  }
  ldh_ = (int_4) (_aintd (((*l_) + 1) / 2));
  if (ldh_ > 1) {
    ldw_ = ldh_ + ldh_;
    (void) _r2w (ldim_, &ldw_, l_, m_, r_, work_);
    (void) _dcfftmf (($7_ = ldh_ - 1, &$7_), &_k1, m_, &ldh_, &work_[1], ($8_ = ldh_ * (*m_), &$8_), &wsave_[lwsav_ + 1 - 
    1], &mwsav_, r_, ($9_ = (*l_) * (*m_), &$9_), &ier1_);
    if (ier1_ != 0) {
      (*ier_) = 20;
      (void) _xerfft (_dc_33, ($10_ = -5, &$10_));
      goto _l100;
    }
    (void) _w2r (ldim_, &ldw_, l_, m_, r_, work_);
  }
  if (modl_ == 0) {
    (void) _drfftmf (&_k1, &_k1, m_, ldim_, &r_[(*l_) - 1 + ((*ldim_)) * ((0))], ($11_ = (*m_) * (*ldim_), &$11_), 
    &wsave_[lwsav_ + mwsav_ + 1 - 1], &mmsav_, work_, lenwrk_, &ier1_);
    for (j_ = 2; j_ <= 2 * (((*m_) + 1) / 2) - 1; (j_)++) {
      r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 1))] = .5 * r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 1))];
    }
    for (j_ = 3; (2 > 0 ? j_ <= (*m_) : j_ >= (*m_)); j_ += 2) {
      r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 1))] = -r_[(*l_) - 1 + ((*ldim_)) * ((j_ - 1))];
    }
  }
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_33, ($12_ = -5, &$12_));
    goto _l100;
  }
  _l100:;
  __calls[85].calls++;
  return 0;
}

int_4 _drfft2i (int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 lwsav_, mwsav_, mmsav_, ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  lwsav_ = (*l_) + (int_4) (_aintd (log ((real_8) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  mwsav_ = 2 * (*m_) + (int_4) (_aintd (log ((real_8) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  mmsav_ = (*m_) + (int_4) (_aintd (log ((real_8) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  if ((*lensav_) < lwsav_ + mwsav_ + mmsav_) {
    (*ier_) = 2;
    (void) _xerfft (_dc_35, ($0_ = 4, &$0_));
    goto _l100;
  }
  (void) _drfftmi (l_, &wsave_[0], &lwsav_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_35, ($1_ = -5, &$1_));
    goto _l100;
  }
  (void) _dcfftmi (m_, &wsave_[lwsav_ + 1 - 1], &mwsav_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_35, ($2_ = -5, &$2_));
    goto _l100;
  }
  (void) _drfftmi (m_, &wsave_[lwsav_ + mwsav_ + 1 - 1], &mmsav_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_35, ($3_ = -5, &$3_));
    goto _l100;
  }
  _l100:;
  __calls[86].calls++;
  return 0;
}

int_4 _drfftb1 (int_4 _p_ n_, int_4 _p_ in_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, real_8 _p_ fac_)
{
  static int_4 nf_, na_, k1_, ip_, modn_, nl_, j_, l1_, iw_, l2_, ido_, idl1_, ix2_, ix3_, ix4_;
  static real_4 half_, halfm_;
  nf_ = fac_[1];
  na_ = 0;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    na_ = 1 - na_;
    if (ip_ <= 5) {
      goto _l10;
    }
    if (k1_ == nf_) {
      goto _l10;
    }
    na_ = 1 - na_;
    _l10:;
  }
  half_ = .5;
  halfm_ = -.5;
  modn_ = _imod ((*n_), 2);
  nl_ = (*n_) - 2;
  if (modn_ != 0) {
    nl_ = (*n_) - 1;
  }
  if (na_ == 0) {
    goto _l120;
  }
  ch_[0] = c_[0 + ((*in_)) * ((0))];
  ch_[(*n_) - 1] = c_[0 + ((*in_)) * (((*n_) - 1))];
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    ch_[j_ - 1] = half_ * c_[0 + ((*in_)) * ((j_ - 1))];
    ch_[j_ + 1 - 1] = halfm_ * c_[0 + ((*in_)) * ((j_ + 1 - 1))];
  }
  goto _l124;
  _l120:;
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    c_[0 + ((*in_)) * ((j_ - 1))] = half_ * c_[0 + ((*in_)) * ((j_ - 1))];
    c_[0 + ((*in_)) * ((j_ + 1 - 1))] = halfm_ * c_[0 + ((*in_)) * ((j_ + 1 - 1))];
  }
  _l124:;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    idl1_ = ido_ * l1_;
    if (ip_ != 4) {
      goto _l103;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _dr1f4kb (&ido_, &l1_, c_, in_, ch_, &_k1, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l102;
    _l101:;
    (void) _dr1f4kb (&ido_, &l1_, ch_, &_k1, c_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    _l102:;
    na_ = 1 - na_;
    goto _l115;
    _l103:;
    if (ip_ != 2) {
      goto _l106;
    }
    if (na_ != 0) {
      goto _l104;
    }
    (void) _dr1f2kb (&ido_, &l1_, c_, in_, ch_, &_k1, &wa_[iw_ - 1]);
    goto _l105;
    _l104:;
    (void) _dr1f2kb (&ido_, &l1_, ch_, &_k1, c_, in_, &wa_[iw_ - 1]);
    _l105:;
    na_ = 1 - na_;
    goto _l115;
    _l106:;
    if (ip_ != 3) {
      goto _l109;
    }
    ix2_ = iw_ + ido_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _dr1f3kb (&ido_, &l1_, c_, in_, ch_, &_k1, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l108;
    _l107:;
    (void) _dr1f3kb (&ido_, &l1_, ch_, &_k1, c_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    _l108:;
    na_ = 1 - na_;
    goto _l115;
    _l109:;
    if (ip_ != 5) {
      goto _l112;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    ix4_ = ix3_ + ido_;
    if (na_ != 0) {
      goto _l110;
    }
    (void) _dr1f5kb (&ido_, &l1_, c_, in_, ch_, &_k1, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    goto _l111;
    _l110:;
    (void) _dr1f5kb (&ido_, &l1_, ch_, &_k1, c_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    _l111:;
    na_ = 1 - na_;
    goto _l115;
    _l112:;
    if (na_ != 0) {
      goto _l113;
    }
    (void) _dr1fgkb (&ido_, &ip_, &l1_, &idl1_, c_, c_, c_, in_, ch_, ch_, &_k1, &wa_[iw_ - 1]);
    goto _l114;
    _l113:;
    (void) _dr1fgkb (&ido_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, &_k1, c_, c_, in_, &wa_[iw_ - 1]);
    _l114:;
    if (ido_ == 1) {
      na_ = 1 - na_;
    }
    _l115:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * ido_;
  }
  __calls[87].calls++;
  return 0;
}

int_4 _drfftf1 (int_4 _p_ n_, int_4 _p_ in_, real_8 _p_ c_, real_8 _p_ ch_, real_8 _p_ wa_, real_8 _p_ fac_)
{
  static int_4 nf_, na_, l2_, iw_, k1_, kh_, ip_, l1_, ido_, idl1_, ix2_, ix3_, ix4_, modn_, nl_, j_;
  static real_4 sn_, tsn_, tsnm_;
  nf_ = fac_[1];
  na_ = 1;
  l2_ = (*n_);
  iw_ = (*n_);
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    kh_ = nf_ - k1_;
    ip_ = fac_[kh_ + 3 - 1];
    l1_ = l2_ / ip_;
    ido_ = (*n_) / l2_;
    idl1_ = ido_ * l1_;
    iw_ = iw_ - (ip_ - 1) * ido_;
    na_ = 1 - na_;
    if (ip_ != 4) {
      goto _l102;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _dr1f4kf (&ido_, &l1_, c_, in_, ch_, &_k1, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l110;
    _l101:;
    (void) _dr1f4kf (&ido_, &l1_, ch_, &_k1, c_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l110;
    _l102:;
    if (ip_ != 2) {
      goto _l104;
    }
    if (na_ != 0) {
      goto _l103;
    }
    (void) _dr1f2kf (&ido_, &l1_, c_, in_, ch_, &_k1, &wa_[iw_ - 1]);
    goto _l110;
    _l103:;
    (void) _dr1f2kf (&ido_, &l1_, ch_, &_k1, c_, in_, &wa_[iw_ - 1]);
    goto _l110;
    _l104:;
    if (ip_ != 3) {
      goto _l106;
    }
    ix2_ = iw_ + ido_;
    if (na_ != 0) {
      goto _l105;
    }
    (void) _dr1f3kf (&ido_, &l1_, c_, in_, ch_, &_k1, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l110;
    _l105:;
    (void) _dr1f3kf (&ido_, &l1_, ch_, &_k1, c_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l110;
    _l106:;
    if (ip_ != 5) {
      goto _l108;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    ix4_ = ix3_ + ido_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _dr1f5kf (&ido_, &l1_, c_, in_, ch_, &_k1, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    goto _l110;
    _l107:;
    (void) _dr1f5kf (&ido_, &l1_, ch_, &_k1, c_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ - 1]);
    goto _l110;
    _l108:;
    if (ido_ == 1) {
      na_ = 1 - na_;
    }
    if (na_ != 0) {
      goto _l109;
    }
    (void) _dr1fgkf (&ido_, &ip_, &l1_, &idl1_, c_, c_, c_, in_, ch_, ch_, &_k1, &wa_[iw_ - 1]);
    na_ = 1;
    goto _l110;
    _l109:;
    (void) _dr1fgkf (&ido_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, &_k1, c_, c_, in_, &wa_[iw_ - 1]);
    na_ = 0;
    _l110:;
    l2_ = l1_;
  }
  sn_ = 1.0 / (*n_);
  tsn_ = 2.0 / (*n_);
  tsnm_ = -tsn_;
  modn_ = _imod ((*n_), 2);
  nl_ = (*n_) - 2;
  if (modn_ != 0) {
    nl_ = (*n_) - 1;
  }
  if (na_ != 0) {
    goto _l120;
  }
  c_[0 + ((*in_)) * ((0))] = sn_ * ch_[0];
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    c_[0 + ((*in_)) * ((j_ - 1))] = tsn_ * ch_[j_ - 1];
    c_[0 + ((*in_)) * ((j_ + 1 - 1))] = tsnm_ * ch_[j_ + 1 - 1];
  }
  if (modn_ != 0) {
    goto _l0;
  }
  c_[0 + ((*in_)) * (((*n_) - 1))] = sn_ * ch_[(*n_) - 1];
  goto _l0;
  _l120:;
  c_[0 + ((*in_)) * ((0))] = sn_ * c_[0 + ((*in_)) * ((0))];
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    c_[0 + ((*in_)) * ((j_ - 1))] = tsn_ * c_[0 + ((*in_)) * ((j_ - 1))];
    c_[0 + ((*in_)) * ((j_ + 1 - 1))] = tsnm_ * c_[0 + ((*in_)) * ((j_ + 1 - 1))];
  }
  if (modn_ != 0) {
    goto _l0;
  }
  c_[0 + ((*in_)) * (((*n_) - 1))] = sn_ * c_[0 + ((*in_)) * (((*n_) - 1))];
  _l0:;
  __calls[88].calls++;
  return 0;
}

int_4 _drffti1 (int_4 _p_ n_, real_8 _p_ wa_, real_8 _p_ fac_)
{
  static int_4 ntryh_[4], nl_, nf_, j_, ntry_, nq_, nr_, i_, ib_, is_, nfm1_, l1_, k1_, ip_, ld_, l2_, ido_, ipm_, ii_;
  static real_4 fi_;
  static real_8 tpi_, argh_, argld_, arg_;
  int_4 _data_k_10, $0_, $1_;
#define _data_n_10 4
  static int_4 _data_l_10[_data_n_10] = {
    4,
    2,
    3,
    5
  };
  if (__calls[89].calls == 0) {
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    ntryh_[0] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    ntryh_[1] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    ntryh_[2] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    ntryh_[3] = _data_l_10[_data_k_10++];
  }
  nl_ = (*n_);
  nf_ = 0;
  j_ = 0;
  _l101:;
  j_ = j_ + 1;
  $0_ = j_ - 4;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ntry_ = ntryh_[j_ - 1];
  goto _l104;
  _l103:;
  ntry_ = ntry_ + 2;
  _l104:;
  nq_ = nl_ / ntry_;
  nr_ = nl_ - ntry_ * nq_;
  $1_ = nr_;
  if ($1_ < 0) {
    goto _l101;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  nf_ = nf_ + 1;
  fac_[nf_ + 2 - 1] = ntry_;
  nl_ = nq_;
  if (ntry_ != 2) {
    goto _l107;
  }
  if (nf_ == 1) {
    goto _l107;
  }
  for (i_ = 2; i_ <= nf_; (i_)++) {
    ib_ = nf_ - i_ + 2;
    fac_[ib_ + 2 - 1] = fac_[ib_ + 1 - 1];
  }
  fac_[2] = 2;
  _l107:;
  if (nl_ != 1) {
    goto _l104;
  }
  fac_[0] = (*n_);
  fac_[1] = nf_;
  tpi_ = 6.2831853071795865;
  argh_ = tpi_ / (real_4) ((*n_));
  is_ = 0;
  nfm1_ = nf_ - 1;
  l1_ = 1;
  if (nfm1_ == 0) {
    goto _l0;
  }
  for (k1_ = 1; k1_ <= nfm1_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    ld_ = 0;
    l2_ = l1_ * ip_;
    ido_ = (*n_) / l2_;
    ipm_ = ip_ - 1;
    for (j_ = 1; j_ <= ipm_; (j_)++) {
      ld_ = ld_ + l1_;
      i_ = is_;
      argld_ = (real_4) (ld_) * argh_;
      fi_ = 0.0;
      for (ii_ = 3; (2 > 0 ? ii_ <= ido_ : ii_ >= ido_); ii_ += 2) {
        i_ = i_ + 2;
        fi_ = fi_ + 1.0;
        arg_ = fi_ * argld_;
        wa_[i_ - 1 - 1] = cos (arg_);
        wa_[i_ - 1] = sin (arg_);
      }
      is_ = is_ + ido_;
    }
    l1_ = l2_;
  }
  _l0:;
  __calls[89].calls++;
  return 0;
}

int_4 _drfftmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ r_, int_4 _p_ lenr_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenr_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_36, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_36, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_36, ($2_ = 10, &$2_));
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_36, &_km1);
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _dmrftb1 (lot_, jump_, n_, inc_, r_, work_, wsave_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[90].calls++;
  return 0;
}

int_4 _drfftmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ r_, int_4 _p_ lenr_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenr_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_37, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_37, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_37, ($2_ = 10, &$2_));
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_37, &_km1);
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _dmrftf1 (lot_, jump_, n_, inc_, r_, work_, wsave_, &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[91].calls++;
  return 0;
}

int_4 _drfftmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  int_4 $0_;
  (*ier_) = 0;
  if ((*lensav_) < (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_38, ($0_ = 3, &$0_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _dmrfti1 (n_, &wsave_[0], &wsave_[(*n_) + 1 - 1]);
  _l0:;
  __calls[92].calls++;
  return 0;
}

int_4 _dsinq1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ns2_, k_, ier1_, kc_;
  static real_4 xhold_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_39, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_39, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_39, ($2_ = 10, &$2_));
  }
  if ((*n_) > 1) {
    goto _l101;
  }
  goto _l0;
  _l101:;
  ns2_ = (*n_) / 2;
  for (k_ = 2; (2 > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += 2) {
    x_[0 + ((*inc_)) * ((k_ - 1))] = -x_[0 + ((*inc_)) * ((k_ - 1))];
  }
  (void) _dcosq1b (n_, inc_, x_, lenx_, wsave_, lensav_, work_, lenwrk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_39, ($3_ = -5, &$3_));
    goto _l300;
  }
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = (*n_) - k_;
    xhold_ = x_[0 + ((*inc_)) * ((k_ - 1))];
    x_[0 + ((*inc_)) * ((k_ - 1))] = x_[0 + ((*inc_)) * ((kc_ + 1 - 1))];
    x_[0 + ((*inc_)) * ((kc_ + 1 - 1))] = xhold_;
  }
  _l300:;
  _l0:;
  __calls[93].calls++;
  return 0;
}

int_4 _dsinq1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ns2_, k_, kc_, ier1_;
  static real_4 xhold_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_40, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_40, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_40, ($2_ = 10, &$2_));
    goto _l300;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = (*n_) - k_;
    xhold_ = x_[0 + ((*inc_)) * ((k_ - 1))];
    x_[0 + ((*inc_)) * ((k_ - 1))] = x_[0 + ((*inc_)) * ((kc_ + 1 - 1))];
    x_[0 + ((*inc_)) * ((kc_ + 1 - 1))] = xhold_;
  }
  (void) _dcosq1f (n_, inc_, x_, lenx_, wsave_, lensav_, work_, lenwrk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_40, ($3_ = -5, &$3_));
    goto _l300;
  }
  for (k_ = 2; (2 > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += 2) {
    x_[0 + ((*inc_)) * ((k_ - 1))] = -x_[0 + ((*inc_)) * ((k_ - 1))];
  }
  _l300:;
  _l0:;
  __calls[94].calls++;
  return 0;
}

int_4 _dsinq1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_41, ($0_ = 3, &$0_));
    goto _l300;
  }
  (void) _dcosq1i (n_, wsave_, lensav_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_41, ($1_ = -5, &$1_));
  }
  _l300:;
  __calls[95].calls++;
  return 0;
}

int_4 _dsinqmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, ns2_, k_, ier1_, kc_;
  static real_4 xhold_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_42, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_42, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_42, ($2_ = 10, &$2_));
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_42, &_km1);
  }
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  if ((*n_) > 1) {
    goto _l101;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = 4.0 * x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  goto _l0;
  _l101:;
  ns2_ = (*n_) / 2;
  for (k_ = 2; (2 > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += 2) {
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = -x_[m_ - 1 + ((*inc_)) * ((k_ - 1))];
    }
  }
  (void) _dcosqmb (lot_, jump_, n_, inc_, x_, lenx_, wsave_, lensav_, work_, lenwrk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_42, ($3_ = -5, &$3_));
    goto _l300;
  }
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = (*n_) - k_;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      xhold_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((kc_ + 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((kc_ + 1 - 1))] = xhold_;
    }
  }
  _l300:;
  _l0:;
  __calls[96].calls++;
  return 0;
}

int_4 _dsinqmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ns2_, lj_, k_, kc_, m_, ier1_;
  static real_4 xhold_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_43, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_43, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_43, ($2_ = 10, &$2_));
    goto _l300;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_43, &_km1);
    goto _l300;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  ns2_ = (*n_) / 2;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = (*n_) - k_;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      xhold_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((kc_ + 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((kc_ + 1 - 1))] = xhold_;
    }
  }
  (void) _dcosqmf (lot_, jump_, n_, inc_, x_, lenx_, wsave_, lensav_, work_, lenwrk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_43, ($3_ = -5, &$3_));
    goto _l300;
  }
  for (k_ = 2; (2 > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += 2) {
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = -x_[m_ - 1 + ((*inc_)) * ((k_ - 1))];
    }
  }
  _l300:;
  _l0:;
  __calls[97].calls++;
  return 0;
}

int_4 _dsinqmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_44, ($0_ = 3, &$0_));
    goto _l300;
  }
  (void) _dcosqmi (n_, wsave_, lensav_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_44, ($1_ = -5, &$1_));
  }
  _l300:;
  __calls[98].calls++;
  return 0;
}

int_4 _dsint1b (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_45, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < (*n_) / 2 + (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_45, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (2 * (*n_) + 2)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_45, ($2_ = 10, &$2_));
    goto _l100;
  }
  (void) _dsintb1 (n_, inc_, x_, wsave_, work_, &work_[(*n_) + 2 - 1], &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_45, ($3_ = -5, &$3_));
  }
  _l100:;
  __calls[99].calls++;
  return 0;
}

int_4 _dsint1f (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 _p_ wsave_, int_4 _p_ lensav_, 
real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_46, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < (*n_) / 2 + (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_46, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (2 * (*n_) + 2)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_46, ($2_ = 10, &$2_));
    goto _l100;
  }
  (void) _dsintf1 (n_, inc_, x_, wsave_, work_, &work_[(*n_) + 2 - 1], &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_46, ($3_ = -5, &$3_));
  }
  _l100:;
  __calls[100].calls++;
  return 0;
}

int_4 _dsint1i (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 ns2_, np1_, k_, lnsv_, ier1_;
  static real_4 pi_, dt_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < (*n_) / 2 + (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_47, ($0_ = 3, &$0_));
    goto _l300;
  }
  pi_ = 3.1415927;
  if ((*n_) <= 1) {
    goto _l0;
  }
  ns2_ = (*n_) / 2;
  np1_ = (*n_) + 1;
  dt_ = pi_ / (real_4) (np1_);
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    wsave_[k_ - 1] = 2.0 * sinf (k_ * dt_);
  }
  lnsv_ = np1_ + (int_4) (_aintd (log ((real_8) (np1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _drfft1i (&np1_, &wsave_[ns2_ + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_47, ($1_ = -5, &$1_));
  }
  _l300:;
  _l0:;
  __calls[101].calls++;
  return 0;
}

int_4 _dsintb1 (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_8 _p_ xh_, real_4 _p_ work_, int_4 
_p_ ier_)
{
  static int_4 np1_, ns2_, k_, kc_, modn_, lnxh_, lnsv_, lnwk_, ier1_, i_;
  static real_4 srt3s2_, xhold_, t1_, t2_, fnp1s4_;
  static real_8 dsum_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l200;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  srt3s2_ = 0.8660254;
  xhold_ = srt3s2_ * (x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((1))]);
  x_[0 + ((*inc_)) * ((1))] = srt3s2_ * (x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((1))]);
  x_[0 + ((*inc_)) * ((0))] = xhold_;
  goto _l200;
  _l103:;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = x_[0 + ((*inc_)) * ((k_ - 1))] - x_[0 + ((*inc_)) * ((kc_ - 1))];
    t2_ = wsave_[k_ - 1] * (x_[0 + ((*inc_)) * ((k_ - 1))] + x_[0 + ((*inc_)) * ((kc_ - 1))]);
    xh_[k_ + 1 - 1] = t1_ + t2_;
    xh_[kc_ + 1 - 1] = t2_ - t1_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  xh_[ns2_ + 2 - 1] = 4.0 * x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))];
  _l124:;
  xh_[0] = 0.0;
  lnxh_ = np1_;
  lnsv_ = np1_ + (int_4) (_aintd (log ((real_8) (np1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = np1_;
  (void) _drfft1f (&np1_, &_k1, xh_, &lnxh_, &wsave_[ns2_ + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_48, ($1_ = -5, &$1_));
    goto _l200;
  }
  if (_imod (np1_, 2) != 0) {
    goto _l30;
  }
  xh_[np1_ - 1] = xh_[np1_ - 1] + xh_[np1_ - 1];
  _l30:;
  fnp1s4_ = (real_4) (np1_) / 4.0;
  x_[0 + ((*inc_)) * ((0))] = fnp1s4_ * xh_[0];
  dsum_ = x_[0 + ((*inc_)) * ((0))];
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = fnp1s4_ * xh_[i_ - 1];
    dsum_ = dsum_ + fnp1s4_ * xh_[i_ - 1 - 1];
    x_[0 + ((*inc_)) * ((i_ - 1))] = dsum_;
  }
  if (modn_ != 0) {
    goto _l200;
  }
  x_[0 + ((*inc_)) * (((*n_) - 1))] = fnp1s4_ * xh_[(*n_) + 1 - 1];
  _l200:;
  __calls[102].calls++;
  return 0;
}

int_4 _dsintf1 (int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, real_8 _p_ wsave_, real_8 _p_ xh_, real_4 _p_ work_, int_4 
_p_ ier_)
{
  static int_4 np1_, ns2_, k_, kc_, modn_, lnxh_, lnsv_, lnwk_, ier1_, i_;
  static real_4 ssqrt3_, xhold_, t1_, t2_, sfnp1_;
  static real_8 dsum_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l200;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ssqrt3_ = 5.7735027e-1;
  xhold_ = ssqrt3_ * (x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((1))]);
  x_[0 + ((*inc_)) * ((1))] = ssqrt3_ * (x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((1))]);
  x_[0 + ((*inc_)) * ((0))] = xhold_;
  goto _l200;
  _l103:;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = x_[0 + ((*inc_)) * ((k_ - 1))] - x_[0 + ((*inc_)) * ((kc_ - 1))];
    t2_ = wsave_[k_ - 1] * (x_[0 + ((*inc_)) * ((k_ - 1))] + x_[0 + ((*inc_)) * ((kc_ - 1))]);
    xh_[k_ + 1 - 1] = t1_ + t2_;
    xh_[kc_ + 1 - 1] = t2_ - t1_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  xh_[ns2_ + 2 - 1] = 4.0 * x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))];
  _l124:;
  xh_[0] = 0.0;
  lnxh_ = np1_;
  lnsv_ = np1_ + (int_4) (_aintd (log ((real_8) (np1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = np1_;
  (void) _drfft1f (&np1_, &_k1, xh_, &lnxh_, &wsave_[ns2_ + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_49, ($1_ = -5, &$1_));
    goto _l200;
  }
  if (_imod (np1_, 2) != 0) {
    goto _l30;
  }
  xh_[np1_ - 1] = xh_[np1_ - 1] + xh_[np1_ - 1];
  _l30:;
  sfnp1_ = 1.0 / (real_4) (np1_);
  x_[0 + ((*inc_)) * ((0))] = .5 * xh_[0];
  dsum_ = x_[0 + ((*inc_)) * ((0))];
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = .5 * xh_[i_ - 1];
    dsum_ = dsum_ + .5 * xh_[i_ - 1 - 1];
    x_[0 + ((*inc_)) * ((i_ - 1))] = dsum_;
  }
  if (modn_ != 0) {
    goto _l200;
  }
  x_[0 + ((*inc_)) * (((*n_) - 1))] = .5 * xh_[(*n_) + 1 - 1];
  _l200:;
  __calls[103].calls++;
  return 0;
}

int_4 _dsintmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_, iw2_, ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_50, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < (*n_) / 2 + (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_50, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*lot_) * (2 * (*n_) + 4)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_50, ($2_ = 10, &$2_));
    goto _l100;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_50, &_km1);
    goto _l100;
  }
  iw1_ = (*lot_) + (*lot_) + 1;
  iw2_ = iw1_ + (*lot_) * ((*n_) + 1);
  (void) _dmsntb1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &work_[iw1_ - 1], &work_[iw2_ - 1], &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_50, ($3_ = -5, &$3_));
  }
  _l100:;
  __calls[104].calls++;
  return 0;
}

int_4 _dsintmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_8 _p_ x_, int_4 _p_ lenx_, real_8 
_p_ wsave_, int_4 _p_ lensav_, real_8 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_, iw2_, ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_51, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < (*n_) / 2 + (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_51, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*lot_) * (2 * (*n_) + 4)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_51, ($2_ = 10, &$2_));
    goto _l100;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_51, &_km1);
    goto _l100;
  }
  iw1_ = (*lot_) + (*lot_) + 1;
  iw2_ = iw1_ + (*lot_) * ((*n_) + 1);
  (void) _dmsntf1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &work_[iw1_ - 1], &work_[iw2_ - 1], &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_51, ($3_ = -5, &$3_));
  }
  _l100:;
  __calls[105].calls++;
  return 0;
}

int_4 _dsintmi (int_4 _p_ n_, real_8 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 ns2_, np1_, k_, lnsv_, ier1_;
  static real_4 pi_, dt_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < (*n_) / 2 + (*n_) + (int_4) (_aintd (log ((real_8) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_52, ($0_ = 3, &$0_));
    goto _l300;
  }
  pi_ = 3.1415927;
  if ((*n_) <= 1) {
    goto _l0;
  }
  ns2_ = (*n_) / 2;
  np1_ = (*n_) + 1;
  dt_ = pi_ / (real_4) (np1_);
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    wsave_[k_ - 1] = 2.0 * sinf (k_ * dt_);
  }
  lnsv_ = np1_ + (int_4) (_aintd (log ((real_8) (np1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _drfftmi (&np1_, &wsave_[ns2_ + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_52, ($1_ = -5, &$1_));
  }
  _l300:;
  _l0:;
  __calls[106].calls++;
  return 0;
}

int_4 _dtables (int_4 _p_ ido_, int_4 _p_ ip_, real_8 _p_ wa_)
{
  static int_4 j_, i_;
  static real_4 tpi_, argz_, arg1_, arg2_, arg3_, arg4_;
  tpi_ = 6.2831853;
  argz_ = tpi_ / (real_8) ((*ip_));
  arg1_ = tpi_ / (real_8) ((*ido_) * (*ip_));
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    arg2_ = (real_8) (j_ - 1) * arg1_;
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      arg3_ = (real_8) (i_ - 1) * arg2_;
      wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] = cosf (arg3_);
      wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] = sinf (arg3_);
    }
    if ((*ip_) <= 5) {
      goto _l110;
    }
    arg4_ = (real_8) (j_ - 1) * argz_;
    wa_[0 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] = cosf (arg4_);
    wa_[0 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] = sinf (arg4_);
    _l110:;
  }
  __calls[107].calls++;
  return 0;
}

int_4 _dw2r (int_4 _p_ ldr_, int_4 _p_ ldw_, int_4 _p_ l_, int_4 _p_ m_, real_8 _p_ r_, real_8 _p_ w_)
{
  static int_4 j_, i_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*l_); (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = w_[i_ - 1 + ((*ldw_)) * ((j_ - 1))];
    }
  }
  __calls[108].calls++;
  return 0;
}

logical_4 _xercon (int_4 _p_ inc_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ lot_)
{
  static int_4 i_, j_, jnew_, lcm_;
  logical_4 xercon_;
  i_ = (*inc_);
  j_ = (*jump_);
  _l10:;
  if (j_ != 0) {
    jnew_ = _imod (i_, j_);
    i_ = j_;
    j_ = jnew_;
    goto _l10;
  }
  lcm_ = ((*inc_) * (*jump_)) / i_;
  if (lcm_ <= ((*n_) - 1) * (*inc_) && lcm_ <= ((*lot_) - 1) * (*jump_)) {
    xercon_ = FALSE;
  }
  else {
    xercon_ = TRUE;
  }
  __calls[109].calls++;
  return xercon_;
}

int_4 _xerfft (char _p_ srname_, int_4 _p_ info_)
{
  int_4 __fcnt, __rc;
  char_15 $9_;
  char_31 $0_, $1_, $2_, $3_, $5_, $7_, $11_;
  char_63 $4_, $6_, $8_, $10_, $12_;
  static FORMAT $f_100025_[] = {
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_INT,"%3d","%3d",
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100027_[] = {
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100029_[] = {
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100031_[] = {
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100033_[] = {
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_100035_[] = {
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  if ((*info_) >= 1) {
    _fcheck ("fftpack5:xerfft:97", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
      __fcnt += 3;
    }
    bufcpy ($0_, _dc_53, 31);
    if ($f_100025_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100025_[__fcnt + 2], $0_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
    __fcnt += 3;
    while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
      if ($f_100025_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
      __fcnt += 3;
    }
    if ($f_100025_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100025_[__fcnt + 2], srname_, CHARACTER, 7);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
    __fcnt += 3;
    while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
      if ($f_100025_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
      __fcnt += 3;
    }
    bufcpy ($1_, _dc_54, 31);
    if ($f_100025_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100025_[__fcnt + 2], $1_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
    __fcnt += 3;
    while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
      if ($f_100025_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
      __fcnt += 3;
    }
    if ($f_100025_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100025_[__fcnt + 2], &(*info_), INTEGER, 4);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
    __fcnt += 3;
    while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
      if ($f_100025_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
      __fcnt += 3;
    }
    bufcpy ($2_, _dc_55, 31);
    if ($f_100025_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100025_[__fcnt + 2], $2_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
    __fcnt += 3;
    while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
      if ($f_100025_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:97", 6));
      __fcnt += 3;
    }
    _write_eol (6);
  }
  else if ((*info_) == -1) {
    _fcheck ("fftpack5:xerfft:100", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
      __fcnt += 3;
    }
    bufcpy ($3_, _dc_53, 31);
    if ($f_100027_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100027_[__fcnt + 2], $3_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
    __fcnt += 3;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      if ($f_100027_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
      __fcnt += 3;
    }
    if ($f_100027_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100027_[__fcnt + 2], srname_, CHARACTER, 7);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
    __fcnt += 3;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      if ($f_100027_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
      __fcnt += 3;
    }
    bufcpy ($4_, _dc_56, 63);
    if ($f_100027_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100027_[__fcnt + 2], $4_, CHARACTER, 63);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
    __fcnt += 3;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      if ($f_100027_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:100", 6));
      __fcnt += 3;
    }
    _write_eol (6);
  }
  else if ((*info_) == -2) {
    _fcheck ("fftpack5:xerfft:103", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
      __fcnt += 3;
    }
    bufcpy ($5_, _dc_53, 31);
    if ($f_100029_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100029_[__fcnt + 2], $5_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
    __fcnt += 3;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      if ($f_100029_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
      __fcnt += 3;
    }
    if ($f_100029_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100029_[__fcnt + 2], srname_, CHARACTER, 7);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
    __fcnt += 3;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      if ($f_100029_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
      __fcnt += 3;
    }
    bufcpy ($6_, _dc_57, 63);
    if ($f_100029_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100029_[__fcnt + 2], $6_, CHARACTER, 63);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
    __fcnt += 3;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      if ($f_100029_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:103", 6));
      __fcnt += 3;
    }
    _write_eol (6);
  }
  else if ((*info_) == -3) {
    _fcheck ("fftpack5:xerfft:106", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
      __fcnt += 3;
    }
    bufcpy ($7_, _dc_53, 31);
    if ($f_100031_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100031_[__fcnt + 2], $7_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
    __fcnt += 3;
    while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
      if ($f_100031_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
      __fcnt += 3;
    }
    if ($f_100031_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100031_[__fcnt + 2], srname_, CHARACTER, 7);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
    __fcnt += 3;
    while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
      if ($f_100031_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
      __fcnt += 3;
    }
    bufcpy ($8_, _dc_58, 63);
    if ($f_100031_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100031_[__fcnt + 2], $8_, CHARACTER, 63);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
    __fcnt += 3;
    while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
      if ($f_100031_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:106", 6));
      __fcnt += 3;
    }
    _write_eol (6);
  }
  else if ((*info_) == -5) {
    _fcheck ("fftpack5:xerfft:109", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
      __fcnt += 3;
    }
    bufcpy ($9_, _dc_59, 15);
    if ($f_100033_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100033_[__fcnt + 2], $9_, CHARACTER, 15);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
    __fcnt += 3;
    while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
      if ($f_100033_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
      __fcnt += 3;
    }
    if ($f_100033_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100033_[__fcnt + 2], srname_, CHARACTER, 7);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
    __fcnt += 3;
    while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
      if ($f_100033_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
      __fcnt += 3;
    }
    bufcpy ($10_, _dc_60, 63);
    if ($f_100033_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100033_[__fcnt + 2], $10_, CHARACTER, 63);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
    __fcnt += 3;
    while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
      if ($f_100033_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:109", 6));
      __fcnt += 3;
    }
    _write_eol (6);
  }
  else if ((*info_) == -6) {
    _fcheck ("fftpack5:xerfft:112", 6, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (6, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
      __fcnt += 3;
    }
    bufcpy ($11_, _dc_53, 31);
    if ($f_100035_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100035_[__fcnt + 2], $11_, CHARACTER, 31);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
    __fcnt += 3;
    while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
      if ($f_100035_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
      __fcnt += 3;
    }
    if ($f_100035_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100035_[__fcnt + 2], srname_, CHARACTER, 7);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
    __fcnt += 3;
    while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
      if ($f_100035_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
      __fcnt += 3;
    }
    bufcpy ($12_, _dc_61, 63);
    if ($f_100035_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[6].unit, "\n");
      while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (6, $f_100035_[__fcnt + 2], $12_, CHARACTER, 63);
    _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
    __fcnt += 3;
    while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
      if ($f_100035_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (6, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 6, _ioerr_write ("fftpack5:xerfft:112", 6));
      __fcnt += 3;
    }
    _write_eol (6);
  }
  exit (EXIT_SUCCESS);
  __calls[110].calls++;
  return 0;
}

int_4 _c1f2kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ 
in2_, real_4 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 chold1_, chold2_, tr2_, ti2_;
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    chold1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
    ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold1_;
    chold2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
    ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold2_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * ti2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 1)] * tr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * tr2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 1)] * ti2_;
    }
  }
  _l0:;
  __calls[111].calls++;
  return 0;
}

int_4 _c1f2kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ 
in2_, real_4 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 sn_, chold1_, chold2_, tr2_, ti2_;
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_4) (2 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    chold1_ = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold1_;
    chold2_ = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold2_;
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))]);
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * ti2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 1)] * tr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * tr2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 1)] * ti2_;
    }
  }
  _l0:;
  __calls[112].calls++;
  return 0;
}

int_4 _c1f3kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ 
in2_, real_4 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 taur_, taui_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_11;
#define _data_n_11 2
  static real_4 _data_l_11[_data_n_11] = {
    -.5,
    .866025403784439
  };
  if (__calls[113].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    taur_ = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    taui_ = _data_l_11[_data_k_11++];
  }
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
    ((0) + ((*ido_)) * ((0))))] + tr2_;
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
    ((0) + ((*ido_)) * ((0))))] + ti2_;
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = cr2_ - ci3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = cr2_ + ci3_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = ci2_ + cr3_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = ci2_ - cr3_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + tr2_;
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + ti2_;
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr2_ + ci3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci2_ - cr3_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + taur_ * tr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + tr2_;
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + taur_ * ti2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ 
      - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))]);
      ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ 
      - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))]);
      dr2_ = cr2_ - ci3_;
      dr3_ = cr2_ + ci3_;
      di2_ = ci2_ + cr3_;
      di3_ = ci2_ - cr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * di2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 2)] * dr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * dr2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 2)] * di2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * di3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 2)] * dr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * dr3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 2)] * di3_;
    }
  }
  _l0:;
  __calls[113].calls++;
  return 0;
}

int_4 _c1f3kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ 
in2_, real_4 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 taur_, taui_, sn_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_12;
#define _data_n_12 2
  static real_4 _data_l_12[_data_n_12] = {
    -.5,
    -.866025403784439
  };
  if (__calls[114].calls == 0) {
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    taur_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    taui_ = _data_l_12[_data_k_12++];
  }
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_4) (3 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr2_);
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + ti2_);
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (cr2_ - ci3_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (cr2_ + ci3_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (ci2_ + cr3_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (ci2_ - cr3_);
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + tr2_);
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + ti2_);
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (cr2_ - ci3_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (cr2_ + ci3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (ci2_ + cr3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (ci2_ - cr3_);
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * tr2_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + tr2_;
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + taur_ * ti2_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + ti2_;
    cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) 
    + ((*l1_)) * ((0) + ((*ido_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr2_ + ci3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci2_ - cr3_;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + taur_ * tr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + tr2_;
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + taur_ * ti2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ 
      - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))]);
      ci3_ = taui_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ 
      - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))]);
      dr2_ = cr2_ - ci3_;
      dr3_ = cr2_ + ci3_;
      di2_ = ci2_ + cr3_;
      di3_ = ci2_ - cr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * di2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 2)] * dr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * dr2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 2)] * di2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * di3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 2)] * dr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * dr3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 2)] * di3_;
    }
  }
  _l0:;
  __calls[114].calls++;
  return 0;
}

int_4 _c1f4kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ 
in2_, real_4 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = tr2_ + tr3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = tr2_ - tr3_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = ti2_ + ti3_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = ti2_ - ti3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = tr1_ + tr4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = tr1_ - tr4_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = ti1_ + ti4_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = ti1_ - ti4_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = tr2_ - tr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ti2_ - ti3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = tr1_ + tr4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = tr1_ - tr4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ti1_ + ti4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ti1_ - ti4_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1))))] = tr2_ + tr3_;
      cr3_ = tr2_ - tr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1))))] = ti2_ + ti3_;
      ci3_ = ti2_ - ti3_;
      cr2_ = tr1_ + tr4_;
      cr4_ = tr1_ - tr4_;
      ci2_ = ti1_ + ti4_;
      ci4_ = ti1_ - ti4_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * cr2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 3)] * ci2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * ci2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 3)] * cr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * cr3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 3)] * ci3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * ci3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 3)] * cr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * cr4_ - wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 3)] * ci4_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * ci4_ + wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 3)] * cr4_;
    }
  }
  _l0:;
  __calls[115].calls++;
  return 0;
}

int_4 _c1f4kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ 
in2_, real_4 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 sn_, ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_4) (4 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = sn_ * (tr2_ + tr3_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (tr2_ - tr3_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = sn_ * (ti2_ + ti3_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (ti2_ - ti3_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (tr1_ + tr4_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = sn_ * (tr1_ - tr4_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (ti1_ + ti4_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = sn_ * (ti1_ - ti4_);
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (tr2_ + tr3_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (tr2_ - tr3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (ti2_ + ti3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (ti2_ - ti3_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (tr1_ + tr4_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = sn_ * (tr1_ - tr4_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (ti1_ + ti4_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = sn_ * (ti1_ - ti4_);
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((2))))];
    ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((1))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = tr2_ + tr3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = tr2_ - tr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = ti2_ + ti3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ti2_ - ti3_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = tr1_ + tr4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = tr1_ - tr4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ti1_ + ti4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ti1_ - ti4_;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ti1_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))];
      ti4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))];
      tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1))))] = tr2_ + tr3_;
      cr3_ = tr2_ - tr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1))))] = ti2_ + ti3_;
      ci3_ = ti2_ - ti3_;
      cr2_ = tr1_ + tr4_;
      cr4_ = tr1_ - tr4_;
      ci2_ = ti1_ + ti4_;
      ci4_ = ti1_ - ti4_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * cr2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 3)] * ci2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * ci2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 3)] * cr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * cr3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 3)] * ci3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * ci3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 3)] * cr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * cr4_ + wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 3)] * ci4_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * ci4_ - wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 3)] * cr4_;
    }
  }
  _l0:;
  __calls[116].calls++;
  return 0;
}

int_4 _c1f5kb (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ 
in2_, real_4 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 tr11_, ti11_, tr12_, ti12_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, chold1_, chold2_, cr2_, ci2_, 
  cr3_, ci3_, cr5_, ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_13;
#define _data_n_13 4
  static real_4 _data_l_13[_data_n_13] = {
    .3090169943749474,
    .9510565162951536,
    -.8090169943749474,
    .5877852522924731
  };
  if (__calls[117].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    tr11_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    ti11_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    tr12_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    ti12_ = _data_l_13[_data_k_13++];
  }
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    chold1_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr2_ + tr3_;
    chold2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + ti2_ + ti3_;
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold1_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold2_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = cr2_ - ci5_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4))))] = cr2_ + ci5_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = ci2_ + cr5_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = ci3_ + cr4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = cr3_ - ci4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = cr3_ + ci4_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = ci3_ - cr4_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4))))] = ci2_ - cr5_;
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + tr2_ + tr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + ti2_ + ti3_;
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci5_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = cr2_ + ci5_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr5_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci3_ + cr4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr3_ - ci4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = cr3_ + ci4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ci3_ - cr4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = ci2_ - cr5_;
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + tr2_ + tr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
      ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
      cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
      ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      dr3_ = cr3_ - ci4_;
      dr4_ = cr3_ + ci4_;
      di3_ = ci3_ + cr4_;
      di4_ = ci3_ - cr4_;
      dr5_ = cr2_ + ci5_;
      dr2_ = cr2_ - ci5_;
      di5_ = ci2_ - cr5_;
      di2_ = ci2_ + cr5_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * dr2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 4)] * di2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * di2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 4)] * dr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * dr3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 4)] * di3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * di3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 4)] * dr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * dr4_ - wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 4)] * di4_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * di4_ + wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 4)] * dr4_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((3))] * dr5_ - wa_[i_ 
      - 1 + ((*ido_)) * ((3) + 4)] * di5_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((3))] * di5_ + wa_[i_ 
      - 1 + ((*ido_)) * ((3) + 4)] * dr5_;
    }
  }
  _l0:;
  __calls[117].calls++;
  return 0;
}

int_4 _c1f5kf (int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ 
in2_, real_4 _p_ wa_)
{
  static int_4 k_, i_;
  static real_4 tr11_, ti11_, tr12_, ti12_, sn_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, chold1_, chold2_, cr2_, 
  ci2_, cr3_, ci3_, cr5_, ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_14;
#define _data_n_14 4
  static real_4 _data_l_14[_data_n_14] = {
    .3090169943749474,
    -.9510565162951536,
    -.8090169943749474,
    -.5877852522924731
  };
  if (__calls[118].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    tr11_ = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    ti11_ = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    tr12_ = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    ti12_ = _data_l_14[_data_k_14++];
  }
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_4) (5 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    chold1_ = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr2_ + tr3_);
    chold2_ = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + ti2_ + ti3_);
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold1_;
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] = chold2_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (cr2_ - ci5_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4))))] = sn_ * (cr2_ + ci5_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] = sn_ * (ci2_ + cr5_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (ci3_ + cr4_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] = sn_ * (cr3_ - ci4_);
    cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = sn_ * (cr3_ + ci4_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3))))] = sn_ * (ci3_ - cr4_);
    cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4))))] = sn_ * (ci2_ - cr5_);
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + tr2_ + tr3_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = sn_ * (cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) 
    * ((0))))] + ti2_ + ti3_);
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (cr2_ - ci5_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = sn_ * (cr2_ + ci5_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = sn_ * (ci2_ + cr5_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (ci3_ + cr4_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = sn_ * (cr3_ - ci4_);
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = sn_ * (cr3_ + ci4_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = sn_ * (ci3_ - cr4_);
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = sn_ * (ci2_ - cr5_);
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((4))))];
    tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
    ((*l1_)) * ((0) + ((*ido_)) * ((3))))];
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + tr2_ + tr3_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0)))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * 
    ((0))))] + ti2_ + ti3_;
    cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
    ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
    cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
    ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
    cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
    ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
    cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
    ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = cr2_ - ci5_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = cr2_ + ci5_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1)))] = ci2_ + cr5_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = ci3_ + cr4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2)))] = cr3_ - ci4_;
    ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = cr3_ + ci4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3)))] = ci3_ - cr4_;
    ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4)))] = ci2_ - cr5_;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      ti5_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      ti2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      ti4_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] - cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ti3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] + cc_[1 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr5_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      tr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4))))];
      tr4_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] - cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      tr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2))))] + cc_[0 + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3))))];
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1))))] = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + tr2_ + tr3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1))))] = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
      - 1) + ((*ido_)) * ((0))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr11_ * tr2_ + tr12_ * tr3_;
      ci2_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr11_ * ti2_ + tr12_ * ti3_;
      cr3_ = cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr12_ * tr2_ + tr11_ * tr3_;
      ci3_ = cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0))))] + tr12_ * ti2_ + tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      dr3_ = cr3_ - ci4_;
      dr4_ = cr3_ + ci4_;
      di3_ = ci3_ + cr4_;
      di4_ = ci3_ - cr4_;
      dr5_ = cr2_ + ci5_;
      dr2_ = cr2_ - ci5_;
      di5_ = ci2_ - cr5_;
      di2_ = ci2_ + cr5_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * dr2_ + wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 4)] * di2_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((0))] * di2_ - wa_[i_ 
      - 1 + ((*ido_)) * ((0) + 4)] * dr2_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * dr3_ + wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 4)] * di3_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((1))] * di3_ - wa_[i_ 
      - 1 + ((*ido_)) * ((1) + 4)] * dr3_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * dr4_ + wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 4)] * di4_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((2))] * di4_ - wa_[i_ 
      - 1 + ((*ido_)) * ((2) + 4)] * dr4_;
      ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((3))] * dr5_ + wa_[i_ 
      - 1 + ((*ido_)) * ((3) + 4)] * di5_;
      ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((3))] * di5_ - wa_[i_ 
      - 1 + ((*ido_)) * ((3) + 4)] * dr5_;
    }
  }
  _l0:;
  __calls[118].calls++;
  return 0;
}

int_4 _c1fgkb (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_4 _p_ cc_, real_4 _p_ 
cc1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch1_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 ipp2_, ipph_, ki_, j_, jc_, l_, lc_, idlj_, i_, k_;
  static real_4 war_, wai_, chold1_, chold2_;
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + ch1_[0 
      + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + ch1_[1 
      + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
    }
  }
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + 
      wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1)))];
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * 
      ((1)))] * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + 
      wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * 
      ((1)))] * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1)))];
    }
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = _imod ((l_ - 1) * (j_ - 1), (*ip_));
      war_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((0)))];
      wai_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((1)))];
      for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
        cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] 
        + war_ * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
        cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 
        1)))] + wai_ * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
        cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] 
        + war_ * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
        cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 
        1)))] + wai_ * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      }
    }
  }
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l136;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      chold1_ = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
      ((jc_ - 1)))];
      chold2_ = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
      ((jc_ - 1)))];
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = chold1_;
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = chold2_;
    }
  }
  goto _l0;
  _l136:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1))))] = ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0))))];
      cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1))))] = ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0))))] = ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((j_ - 1))))];
      cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0))))] = ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((j_ - 1))))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (i_ = 2; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 
        1) + ((*ip_) - 1) * ((0)))] * ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1))))] - wa_[i_ 
        - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + 
        ((*ido_)) * ((j_ - 1))))];
        cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 
        1) + ((*ip_) - 1) * ((0)))] * ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1))))] + wa_[i_ 
        - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + 
        ((*ido_)) * ((j_ - 1))))];
      }
    }
  }
  _l0:;
  __calls[119].calls++;
  return 0;
}

int_4 _c1fgkf (int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_4 _p_ cc_, real_4 _p_ 
cc1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch1_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 ipp2_, ipph_, ki_, j_, jc_, l_, lc_, idlj_, i_, k_;
  static real_4 war_, wai_, sn_, chold1_, chold2_;
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + ch1_[0 
      + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + ch1_[1 
      + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
    }
  }
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + 
      wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1)))];
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = -wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * 
      ((1)))] * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] + 
      wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1)))];
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = -wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * 
      ((1)))] * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1)))];
    }
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = _imod ((l_ - 1) * (j_ - 1), (*ip_));
      war_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((0)))];
      wai_ = -wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((1)))];
      for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
        cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] 
        + war_ * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
        cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 
        1)))] + wai_ * ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
        cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1)))] 
        + war_ * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))];
        cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 
        1)))] + wai_ * ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      }
    }
  }
  if ((*ido_) > 1) {
    goto _l136;
  }
  sn_ = 1.0 / (real_4) ((*ip_) * (*l1_));
  if ((*na_) == 1) {
    goto _l146;
  }
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = sn_ * cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = sn_ * cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      chold1_ = sn_ * (cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + 
      ((*lid_)) * ((jc_ - 1)))]);
      chold2_ = sn_ * (cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + 
      ((*lid_)) * ((jc_ - 1)))]);
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = chold1_;
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = sn_ * (cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = sn_ * (cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = chold2_;
    }
  }
  goto _l0;
  _l146:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = sn_ * cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = sn_ * cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = sn_ * (cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = sn_ * (cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = sn_ * (cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = sn_ * (cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
      - 1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))]);
    }
  }
  goto _l0;
  _l136:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
    ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0)))];
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      - cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1)))] 
      + cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[0 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] + cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
      ch1_[1 + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))] = cc1_[1 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 
      1)))] - cc1_[0 + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1)))];
    }
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1))))] = ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0))))];
      cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1))))] = ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0))))] = ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((j_ - 1))))];
      cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0))))] = ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((j_ - 1))))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (i_ = 2; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        cc_[0 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 
        1) + ((*ip_) - 1) * ((0)))] * ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1))))] + wa_[i_ 
        - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + 
        ((*ido_)) * ((j_ - 1))))];
        cc_[1 + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1))))] = wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 
        1) + ((*ip_) - 1) * ((0)))] * ch_[1 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1))))] - wa_[i_ 
        - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[0 + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + 
        ((*ido_)) * ((j_ - 1))))];
      }
    }
  }
  _l0:;
  __calls[120].calls++;
  return 0;
}

int_4 _c1fm1b (int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, real_4 _p_ ch_, real_4 _p_ wa_, real_4 _p_ fnf_, real_4 
_p_ fac_)
{
  static int_4 inc2_, nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, lid_, nbr_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  inc2_ = (*inc_) + (*inc_);
  nf_ = (*fnf_);
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    lid_ = l1_ * ido_;
    nbr_ = 1 + na_ + 2 * _min (ip_ - 2, 4);
    switch (nbr_) {
      default:
      case 1: goto _l52;
      case 2: goto _l62;
      case 3: goto _l53;
      case 4: goto _l63;
      case 5: goto _l54;
      case 6: goto _l64;
      case 7: goto _l55;
      case 8: goto _l65;
      case 9: goto _l56;
      case 10: goto _l66;
    }
    _l52:;
    (void) _c1f2kb (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($0_ = 2, &$0_), &wa_[iw_ - 1]);
    goto _l120;
    _l62:;
    (void) _c1f2kb (&ido_, &l1_, &na_, ch_, ($1_ = 2, &$1_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l53:;
    (void) _c1f3kb (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($2_ = 2, &$2_), &wa_[iw_ - 1]);
    goto _l120;
    _l63:;
    (void) _c1f3kb (&ido_, &l1_, &na_, ch_, ($3_ = 2, &$3_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l54:;
    (void) _c1f4kb (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($4_ = 2, &$4_), &wa_[iw_ - 1]);
    goto _l120;
    _l64:;
    (void) _c1f4kb (&ido_, &l1_, &na_, ch_, ($5_ = 2, &$5_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l55:;
    (void) _c1f5kb (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($6_ = 2, &$6_), &wa_[iw_ - 1]);
    goto _l120;
    _l65:;
    (void) _c1f5kb (&ido_, &l1_, &na_, ch_, ($7_ = 2, &$7_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l56:;
    (void) _c1fgkb (&ido_, &ip_, &l1_, &lid_, &na_, c_, c_, &inc2_, ch_, ch_, ($8_ = 2, &$8_), &wa_[iw_ - 1]);
    goto _l120;
    _l66:;
    (void) _c1fgkb (&ido_, &ip_, &l1_, &lid_, &na_, ch_, ch_, ($9_ = 2, &$9_), c_, c_, &inc2_, &wa_[iw_ - 1]);
    _l120:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    if (ip_ <= 5) {
      na_ = 1 - na_;
    }
  }
  __calls[121].calls++;
  return 0;
}

int_4 _c1fm1f (int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, real_4 _p_ ch_, real_4 _p_ wa_, real_4 _p_ fnf_, real_4 
_p_ fac_)
{
  static int_4 inc2_, nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, lid_, nbr_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  inc2_ = (*inc_) + (*inc_);
  nf_ = (*fnf_);
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    lid_ = l1_ * ido_;
    nbr_ = 1 + na_ + 2 * _min (ip_ - 2, 4);
    switch (nbr_) {
      default:
      case 1: goto _l52;
      case 2: goto _l62;
      case 3: goto _l53;
      case 4: goto _l63;
      case 5: goto _l54;
      case 6: goto _l64;
      case 7: goto _l55;
      case 8: goto _l65;
      case 9: goto _l56;
      case 10: goto _l66;
    }
    _l52:;
    (void) _c1f2kf (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($0_ = 2, &$0_), &wa_[iw_ - 1]);
    goto _l120;
    _l62:;
    (void) _c1f2kf (&ido_, &l1_, &na_, ch_, ($1_ = 2, &$1_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l53:;
    (void) _c1f3kf (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($2_ = 2, &$2_), &wa_[iw_ - 1]);
    goto _l120;
    _l63:;
    (void) _c1f3kf (&ido_, &l1_, &na_, ch_, ($3_ = 2, &$3_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l54:;
    (void) _c1f4kf (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($4_ = 2, &$4_), &wa_[iw_ - 1]);
    goto _l120;
    _l64:;
    (void) _c1f4kf (&ido_, &l1_, &na_, ch_, ($5_ = 2, &$5_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l55:;
    (void) _c1f5kf (&ido_, &l1_, &na_, c_, &inc2_, ch_, ($6_ = 2, &$6_), &wa_[iw_ - 1]);
    goto _l120;
    _l65:;
    (void) _c1f5kf (&ido_, &l1_, &na_, ch_, ($7_ = 2, &$7_), c_, &inc2_, &wa_[iw_ - 1]);
    goto _l120;
    _l56:;
    (void) _c1fgkf (&ido_, &ip_, &l1_, &lid_, &na_, c_, c_, &inc2_, ch_, ch_, ($8_ = 2, &$8_), &wa_[iw_ - 1]);
    goto _l120;
    _l66:;
    (void) _c1fgkf (&ido_, &ip_, &l1_, &lid_, &na_, ch_, ch_, ($9_ = 2, &$9_), c_, c_, &inc2_, &wa_[iw_ - 1]);
    _l120:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    if (ip_ <= 5) {
      na_ = 1 - na_;
    }
  }
  __calls[122].calls++;
  return 0;
}

int_4 _cfft1b (int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, int_4 _p_ lenc_, real_4 _p_ wsave_, int_4 _p_ lensav_, 
real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenc_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_62, ($0_ = 4, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_62, ($1_ = 6, &$1_));
  }
  else if ((*lenwrk_) < 2 * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_62, ($2_ = 8, &$2_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _c1fm1b (n_, inc_, c_, work_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[123].calls++;
  return 0;
}

int_4 _cfft1f (int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, int_4 _p_ lenc_, real_4 _p_ wsave_, int_4 _p_ lensav_, 
real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenc_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_63, ($0_ = 4, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_63, ($1_ = 6, &$1_));
  }
  else if ((*lenwrk_) < 2 * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_63, ($2_ = 8, &$2_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _c1fm1f (n_, inc_, c_, work_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[124].calls++;
  return 0;
}

int_4 _cfft1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_64, ($0_ = 3, &$0_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _mcfti1 (n_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[125].calls++;
  return 0;
}

int_4 _cfft2b (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, complex_8 _p_ c_, real_4 _p_ wsave_, int_4 _p_ lensav_, 
real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw_, ier1_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_;
  (*ier_) = 0;
  if ((*l_) > (*ldim_)) {
    (*ier_) = 5;
    (void) _xerfft (_dc_65, ($0_ = -2, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 2 * (*m_) + (int_4) (_aintd (logf 
    ((real_4) ((*m_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 8) {
    (*ier_) = 2;
    (void) _xerfft (_dc_65, ($1_ = 6, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < 2 * (*l_) * (*m_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_65, ($2_ = 8, &$2_));
    goto _l100;
  }
  iw_ = 2 * (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 3;
  (void) _cfftmb (l_, &_k1, m_, ldim_, c_, ($3_ = ((*l_) - 1) + (*ldim_) * ((*m_) - 1) + 1, &$3_), &wsave_[iw_ - 1], ($4_ 
  = 2 * (*m_) + (int_4) (_aintd (logf ((real_4) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$4_), work_, ($5_ = 2 * (*l_) * 
  (*m_), &$5_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_65, ($6_ = -5, &$6_));
    goto _l100;
  }
  iw_ = 1;
  (void) _cfftmb (m_, ldim_, l_, &_k1, c_, ($7_ = ((*m_) - 1) * (*ldim_) + (*l_), &$7_), &wsave_[iw_ - 1], ($8_ = 2 * 
  (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$8_), work_, ($9_ = 2 * (*m_) * 
  (*l_), &$9_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_65, ($10_ = -5, &$10_));
  }
  _l100:;
  __calls[126].calls++;
  return 0;
}

int_4 _cfft2f (int_4 _p_ ldim_, int_4 _p_ l_, int_4 _p_ m_, complex_8 _p_ c_, real_4 _p_ wsave_, int_4 _p_ lensav_, 
real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw_, ier1_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_;
  (*ier_) = 0;
  if ((*l_) > (*ldim_)) {
    (*ier_) = 5;
    (void) _xerfft (_dc_66, ($0_ = -2, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 2 * (*m_) + (int_4) (_aintd (logf 
    ((real_4) ((*m_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 8) {
    (*ier_) = 2;
    (void) _xerfft (_dc_66, ($1_ = 6, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < 2 * (*l_) * (*m_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_66, ($2_ = 8, &$2_));
    goto _l100;
  }
  iw_ = 2 * (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 3;
  (void) _cfftmf (l_, &_k1, m_, ldim_, c_, ($3_ = ((*l_) - 1) + (*ldim_) * ((*m_) - 1) + 1, &$3_), &wsave_[iw_ - 1], ($4_ 
  = 2 * (*m_) + (int_4) (_aintd (logf ((real_4) ((*m_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$4_), work_, ($5_ = 2 * (*l_) * 
  (*m_), &$5_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_66, ($6_ = -5, &$6_));
    goto _l100;
  }
  iw_ = 1;
  (void) _cfftmf (m_, ldim_, l_, &_k1, c_, ($7_ = ((*m_) - 1) * (*ldim_) + (*l_), &$7_), &wsave_[iw_ - 1], ($8_ = 2 * 
  (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$8_), work_, ($9_ = 2 * (*m_) * 
  (*l_), &$9_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_66, ($10_ = -5, &$10_));
  }
  _l100:;
  __calls[127].calls++;
  return 0;
}

int_4 _cfft2i (int_4 _p_ l_, int_4 _p_ m_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 2 * (*m_) + (int_4) (_aintd (logf 
    ((real_4) ((*m_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 8) {
    (*ier_) = 2;
    (void) _xerfft (_dc_67, ($0_ = 4, &$0_));
    goto _l100;
  }
  (void) _cfftmi (l_, &wsave_[0], ($1_ = 2 * (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, &$1_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_67, ($2_ = -5, &$2_));
    goto _l100;
  }
  (void) _cfftmi (m_, &wsave_[2 * (*l_) + (int_4) (_aintd (logf ((real_4) ((*l_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 3 - 1], ($3_ = 2 * (*m_) + (int_4) 
  (_aintd (logf ((real_4) ((*m_))) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4, 
  &$3_), &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_67, ($4_ = -5, &$4_));
  }
  _l100:;
  __calls[128].calls++;
  return 0;
}

int_4 _cfftmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, int_4 _p_ lenc_, real_4 
_p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenc_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_68, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_68, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < 2 * (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_68, ($2_ = 10, &$2_));
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_68, &_km1);
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _cmfm1b (lot_, jump_, n_, inc_, c_, work_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[129].calls++;
  return 0;
}

int_4 _cfftmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, int_4 _p_ lenc_, real_4 
_p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_, $1_, $2_;
  (*ier_) = 0;
  if ((*lenc_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_69, ($0_ = 6, &$0_));
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_69, ($1_ = 8, &$1_));
  }
  else if ((*lenwrk_) < 2 * (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_69, ($2_ = 10, &$2_));
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_69, &_km1);
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _cmfm1f (lot_, jump_, n_, inc_, c_, work_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[130].calls++;
  return 0;
}

int_4 _cfftmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 iw1_;
  int_4 $0_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_64, ($0_ = 3, &$0_));
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  iw1_ = (*n_) + (*n_) + 1;
  (void) _mcfti1 (n_, wsave_, &wsave_[iw1_ - 1], &wsave_[iw1_ + 1 - 1]);
  _l0:;
  __calls[131].calls++;
  return 0;
}

int_4 _cmf2kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 chold1_, chold2_, tr2_, ti2_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      chold1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * 
      ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
      ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold1_;
      chold2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * 
      ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
      ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + 
      ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold2_;
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) 
        + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) 
        + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * ti2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 1)] * tr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * tr2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 1)] * ti2_;
      }
    }
  }
  _l0:;
  __calls[132].calls++;
  return 0;
}

int_4 _cmf2kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 sn_, chold1_, chold2_, tr2_, ti2_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_4) (2 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      chold1_ = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))]);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))]);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold1_;
      chold2_ = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))]);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))]);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold2_;
    }
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((1)))))]);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((1)))))]);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((1)))))]);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * 
      ((0) + ((*ido_)) * ((1)))))]);
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + 
      ((*ido_)) * ((1)))))];
    }
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) 
        + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (2) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) 
        + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * ti2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 1)] * tr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (2) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * tr2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 1)] * ti2_;
      }
    }
  }
  _l0:;
  __calls[133].calls++;
  return 0;
}

int_4 _cmf3kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 taur_, taui_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_15;
#define _data_n_15 2
  static real_4 _data_l_15[_data_n_15] = {
    -.5,
    .866025403784439
  };
  if (__calls[134].calls == 0) {
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    taur_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    taui_ = _data_l_15[_data_k_15++];
  }
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = cc_[0 + (2) * ((m1_ - 1) + 
      ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_;
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = cc_[1 + (2) * ((m1_ - 1) + 
      ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = cr2_ - ci3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = cr2_ + ci3_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = ci2_ + cr3_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = ci2_ - cr3_;
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_;
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cr2_ - ci3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cr2_ + ci3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ci2_ + cr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ci2_ - cr3_;
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr2_;
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + ti2_;
        cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 
        + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))]);
        ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 
        + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))]);
        dr2_ = cr2_ - ci3_;
        dr3_ = cr2_ + ci3_;
        di2_ = ci2_ + cr3_;
        di3_ = ci2_ - cr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * di2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 2)] * dr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * dr2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 2)] * di2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * di3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 2)] * dr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * dr3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 2)] * di3_;
      }
    }
  }
  _l0:;
  __calls[134].calls++;
  return 0;
}

int_4 _cmf3kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 taur_, taui_, sn_, tr2_, cr2_, ti2_, ci2_, cr3_, ci3_, dr2_, dr3_, di2_, di3_;
  int_4 _data_k_16;
#define _data_n_16 2
  static real_4 _data_l_16[_data_n_16] = {
    -.5,
    -.866025403784439
  };
  if (__calls[135].calls == 0) {
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    taur_ = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    taui_ = _data_l_16[_data_k_16++];
  }
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_4) (3 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = sn_ * (cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_);
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = sn_ * (cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_);
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (cr2_ - ci3_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (cr2_ + ci3_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (ci2_ + cr3_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (ci2_ - cr3_);
    }
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_);
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_);
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (cr2_ - ci3_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (cr2_ + ci3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (ci2_ + cr3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (ci2_ - cr3_);
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_;
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_;
      cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + 
      (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))]);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cr2_ - ci3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cr2_ + ci3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ci2_ + cr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ci2_ - cr3_;
    }
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + taur_ * tr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr2_;
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + taur_ * ti2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (3) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + ti2_;
        cr3_ = taui_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 
        + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))]);
        ci3_ = taui_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 
        + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))]);
        dr2_ = cr2_ - ci3_;
        dr3_ = cr2_ + ci3_;
        di2_ = ci2_ + cr3_;
        di3_ = ci2_ - cr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * di2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 2)] * dr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * dr2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 2)] * di2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * di3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 2)] * dr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (3) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * dr3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 2)] * di3_;
      }
    }
  }
  _l0:;
  __calls[135].calls++;
  return 0;
}

int_4 _cmf4kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = tr2_ + tr3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = tr2_ - tr3_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = ti2_ + ti3_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = ti2_ - ti3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = tr1_ + tr4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = tr1_ - tr4_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = ti1_ + ti4_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = ti1_ - ti4_;
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = tr2_ + tr3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = tr2_ - tr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = ti2_ + ti3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ti2_ - ti3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = tr1_ + tr4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = tr1_ - tr4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ti1_ + ti4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = ti1_ - ti4_;
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1)))))] = tr2_ + tr3_;
        cr3_ = tr2_ - tr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1)))))] = ti2_ + ti3_;
        ci3_ = ti2_ - ti3_;
        cr2_ = tr1_ + tr4_;
        cr4_ = tr1_ - tr4_;
        ci2_ = ti1_ + ti4_;
        ci4_ = ti1_ - ti4_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * cr2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 3)] * ci2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * ci2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 3)] * cr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * cr3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 3)] * ci3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * ci3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 3)] * cr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * cr4_ - wa_[i_ - 1 + ((*ido_)) * ((2) + 3)] * ci4_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * ci4_ + wa_[i_ - 1 + ((*ido_)) * ((2) + 3)] * cr4_;
      }
    }
  }
  _l0:;
  __calls[136].calls++;
  return 0;
}

int_4 _cmf4kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 sn_, ti1_, ti2_, tr4_, ti3_, tr1_, tr2_, ti4_, tr3_, cr3_, ci3_, cr2_, cr4_, ci2_, ci4_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_4) (4 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = sn_ * (tr2_ + tr3_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (tr2_ - tr3_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = sn_ * (ti2_ + ti3_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (ti2_ - ti3_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (tr1_ + tr4_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = sn_ * (tr1_ - tr4_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (ti1_ + ti4_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = sn_ * (ti1_ - ti4_);
    }
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (tr2_ + tr3_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (tr2_ - tr3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (ti2_ + ti3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (ti2_ - ti3_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (tr1_ + tr4_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = sn_ * (tr1_ - tr4_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (ti1_ + ti4_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = sn_ * (ti1_ - ti4_);
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))];
      ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = tr2_ + tr3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = tr2_ - tr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = ti2_ + ti3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ti2_ - ti3_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = tr1_ + tr4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = tr1_ - tr4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ti1_ + ti4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = ti1_ - ti4_;
    }
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ti1_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))];
        ti4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))];
        tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1)))))] = tr2_ + tr3_;
        cr3_ = tr2_ - tr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (4) * ((i_ - 1)))))] = ti2_ + ti3_;
        ci3_ = ti2_ - ti3_;
        cr2_ = tr1_ + tr4_;
        cr4_ = tr1_ - tr4_;
        ci2_ = ti1_ + ti4_;
        ci4_ = ti1_ - ti4_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * cr2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 3)] * ci2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * ci2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 3)] * cr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * cr3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 3)] * ci3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * ci3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 3)] * cr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * cr4_ + wa_[i_ - 1 + ((*ido_)) * ((2) + 3)] * ci4_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (4) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * ci4_ - wa_[i_ - 1 + ((*ido_)) * ((2) + 3)] * cr4_;
      }
    }
  }
  _l0:;
  __calls[137].calls++;
  return 0;
}

int_4 _cmf5kb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 tr11_, ti11_, tr12_, ti12_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, chold1_, chold2_, cr2_, ci2_, 
  cr3_, ci3_, cr5_, ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_17;
#define _data_n_17 4
  static real_4 _data_l_17[_data_n_17] = {
    .3090169943749474,
    .9510565162951536,
    -.8090169943749474,
    .5877852522924731
  };
  if (__calls[138].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    tr11_ = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    ti11_ = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    tr12_ = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    ti12_ = _data_l_17[_data_k_17++];
  }
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l102;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      chold1_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
      chold2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold1_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold2_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = cr2_ - ci5_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))] = cr2_ + ci5_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = ci2_ + cr5_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = ci3_ + cr4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = cr3_ - ci4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = cr3_ + ci4_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = ci3_ - cr4_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))] = ci2_ - cr5_;
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cr2_ - ci5_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = cr2_ + ci5_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ci2_ + cr5_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ci3_ + cr4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cr3_ - ci4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = cr3_ + ci4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = ci3_ - cr4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = ci2_ - cr5_;
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
        cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
        tr12_ * tr3_;
        ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
        tr12_ * ti3_;
        cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
        tr11_ * tr3_;
        ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
        tr11_ * ti3_;
        cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
        ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
        cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
        ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
        dr3_ = cr3_ - ci4_;
        dr4_ = cr3_ + ci4_;
        di3_ = ci3_ + cr4_;
        di4_ = ci3_ - cr4_;
        dr5_ = cr2_ + ci5_;
        dr2_ = cr2_ - ci5_;
        di5_ = ci2_ - cr5_;
        di2_ = ci2_ + cr5_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * dr2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 4)] * di2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * di2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 4)] * dr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * dr3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 4)] * di3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * di3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 4)] * dr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * dr4_ - wa_[i_ - 1 + ((*ido_)) * ((2) + 4)] * di4_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * di4_ + wa_[i_ - 1 + ((*ido_)) * ((2) + 4)] * dr4_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((3))] * dr5_ - wa_[i_ - 1 + ((*ido_)) * ((3) + 4)] * di5_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((3))] * di5_ + wa_[i_ - 1 + ((*ido_)) * ((3) + 4)] * dr5_;
      }
    }
  }
  _l0:;
  __calls[138].calls++;
  return 0;
}

int_4 _cmf5kf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ l1_, int_4 _p_ na_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ 
in1_, real_4 _p_ ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, k_, m1_, m2_, i_;
  static real_4 tr11_, ti11_, tr12_, ti12_, sn_, ti5_, ti2_, ti4_, ti3_, tr5_, tr2_, tr4_, tr3_, chold1_, chold2_, cr2_, 
  ci2_, cr3_, ci3_, cr5_, ci5_, cr4_, ci4_, dr3_, dr4_, di3_, di4_, dr5_, dr2_, di5_, di2_;
  int_4 _data_k_18;
#define _data_n_18 4
  static real_4 _data_l_18[_data_n_18] = {
    .3090169943749474,
    -.9510565162951536,
    -.8090169943749474,
    -.5877852522924731
  };
  if (__calls[139].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    tr11_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    ti11_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    tr12_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    ti12_ = _data_l_18[_data_k_18++];
  }
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  if ((*ido_) > 1) {
    goto _l102;
  }
  sn_ = 1.0 / (real_4) (5 * (*l1_));
  if ((*na_) == 1) {
    goto _l106;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      chold1_ = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + 
      tr3_);
      chold2_ = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + 
      ti3_);
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold1_;
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] = chold2_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (cr2_ - ci5_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))] = sn_ * (cr2_ + ci5_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] = sn_ * (ci2_ + cr5_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (ci3_ + cr4_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] = sn_ * (cr3_ - ci4_);
      cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = sn_ * (cr3_ + ci4_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))] = sn_ * (ci3_ - cr4_);
      cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))] = sn_ * (ci2_ - cr5_);
    }
  }
  goto _l0;
  _l106:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + tr3_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = sn_ * (cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + ti3_);
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (cr2_ - ci5_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = sn_ * (cr2_ + ci5_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sn_ * (ci2_ + cr5_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (ci3_ + cr4_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = sn_ * (cr3_ - ci4_);
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = sn_ * (cr3_ + ci4_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = sn_ * (ci3_ - cr4_);
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = sn_ * (ci2_ - cr5_);
    }
  }
  goto _l0;
  _l102:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((4)))))];
      tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * ((m1_ 
      - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((3)))))];
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 
      1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
      cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
      tr12_ * tr3_;
      ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
      tr12_ * ti3_;
      cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
      tr11_ * tr3_;
      ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
      tr11_ * ti3_;
      cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
      ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
      cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
      ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cr2_ - ci5_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = cr2_ + ci5_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = ci2_ + cr5_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = ci3_ + cr4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cr3_ - ci4_;
      ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = cr3_ + ci4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = ci3_ - cr4_;
      ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = ci2_ - cr5_;
    }
  }
  for (i_ = 2; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ti5_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        ti2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        ti4_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] - cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ti3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] + cc_[1 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr5_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        tr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((1)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((4)))))];
        tr4_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] - cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        tr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((2)))))] + cc_[0 + (2) * 
        ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((3)))))];
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1)))))] = cc_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr2_ + tr3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + (5) * ((i_ - 1)))))] = cc_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + ti2_ + ti3_;
        cr2_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr11_ * tr2_ + 
        tr12_ * tr3_;
        ci2_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr11_ * ti2_ + 
        tr12_ * ti3_;
        cr3_ = cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr12_ * tr2_ + 
        tr11_ * tr3_;
        ci3_ = cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))] + tr12_ * ti2_ + 
        tr11_ * ti3_;
        cr5_ = ti11_ * tr5_ + ti12_ * tr4_;
        ci5_ = ti11_ * ti5_ + ti12_ * ti4_;
        cr4_ = ti12_ * tr5_ - ti11_ * tr4_;
        ci4_ = ti12_ * ti5_ - ti11_ * ti4_;
        dr3_ = cr3_ - ci4_;
        dr4_ = cr3_ + ci4_;
        di3_ = ci3_ + cr4_;
        di4_ = ci3_ - cr4_;
        dr5_ = cr2_ + ci5_;
        dr2_ = cr2_ - ci5_;
        di5_ = ci2_ - cr5_;
        di2_ = ci2_ + cr5_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * dr2_ + wa_[i_ - 1 + ((*ido_)) * ((0) + 4)] * di2_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((1) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((0))] * di2_ - wa_[i_ - 1 + ((*ido_)) * ((0) + 4)] * dr2_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * dr3_ + wa_[i_ - 1 + ((*ido_)) * ((1) + 4)] * di3_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((2) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((1))] * di3_ - wa_[i_ - 1 + ((*ido_)) * ((1) + 4)] * dr3_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * dr4_ + wa_[i_ - 1 + ((*ido_)) * ((2) + 4)] * di4_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((3) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((2))] * di4_ - wa_[i_ - 1 + ((*ido_)) * ((2) + 4)] * dr4_;
        ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((3))] * dr5_ + wa_[i_ - 1 + ((*ido_)) * ((3) + 4)] * di5_;
        ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((4) + (5) * ((i_ - 1)))))] = wa_[i_ - 1 + ((*ido_)) * 
        ((3))] * di5_ - wa_[i_ - 1 + ((*ido_)) * ((3) + 4)] * dr5_;
      }
    }
  }
  _l0:;
  __calls[139].calls++;
  return 0;
}

int_4 _cmfgkb (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_4 _p_ 
cc_, real_4 _p_ cc1_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch1_, int_4 _p_ im2_, int_4 _p_ in2_, 
real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, ipp2_, ipph_, ki_, m2_, m1_, j_, jc_, l_, lc_, idlj_, i_, k_;
  static real_4 war_, wai_, chold1_, chold2_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
        ((ki_ - 1) + ((*lid_)) * ((0))))] + ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
        ((ki_ - 1) + ((*lid_)) * ((0))))] + ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))];
      }
    }
  }
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) 
        * ((ki_ - 1) + ((*lid_)) * ((0))))] + wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[0 + (2) * ((m2_ 
        - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1))))];
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + 
        ((*ip_) - 1) * ((1)))] * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) 
        * ((ki_ - 1) + ((*lid_)) * ((0))))] + wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[1 + (2) * ((m2_ 
        - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + 
        ((*ip_) - 1) * ((1)))] * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1))))];
      }
    }
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = _imod ((l_ - 1) * (j_ - 1), (*ip_));
      war_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((0)))];
      wai_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((1)))];
      for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] + war_ * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
          - 1))))];
          cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] + wai_ * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * 
          ((jc_ - 1))))];
          cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] + war_ * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
          - 1))))];
          cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] + wai_ * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * 
          ((jc_ - 1))))];
        }
      }
    }
  }
  if ((*ido_) > 1 || (*na_) == 1) {
    goto _l136;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        chold1_ = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))];
        chold2_ = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))];
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = chold1_;
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = chold2_;
      }
    }
  }
  goto _l0;
  _l136:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
      }
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1)))))] = ch_[0 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))];
        cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1)))))] = ch_[1 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))];
      }
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0)))))] = ch_[0 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((j_ - 1)))))];
        cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0)))))] = ch_[1 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((j_ - 1)))))];
      }
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (i_ = 2; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1)))))] = wa_[i_ - 1 + 
          ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
          - 1) + ((*ido_)) * ((j_ - 1)))))] - wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[1 + (2) * 
          ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1)))))];
          cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1)))))] = wa_[i_ - 1 + 
          ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
          - 1) + ((*ido_)) * ((j_ - 1)))))] + wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[0 + (2) * 
          ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1)))))];
        }
      }
    }
  }
  _l0:;
  __calls[140].calls++;
  return 0;
}
int_4 _cmfgkf (int_4 _p_ lot_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ lid_, int_4 _p_ na_, real_4 _p_ 
cc_, real_4 _p_ cc1_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch1_, int_4 _p_ im2_, int_4 _p_ in2_, 
real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, ipp2_, ipph_, ki_, m2_, m1_, j_, jc_, l_, lc_, idlj_, i_, k_;
  static real_4 war_, wai_, sn_, chold1_, chold2_;
  m1d_ = ((*lot_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
        ((ki_ - 1) + ((*lid_)) * ((0))))] + ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
        ((ki_ - 1) + ((*lid_)) * ((0))))] + ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))];
      }
    }
  }
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) 
        * ((ki_ - 1) + ((*lid_)) * ((0))))] + wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[0 + (2) * ((m2_ 
        - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1))))];
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = -wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + 
        ((*ip_) - 1) * ((1)))] * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) 
        * ((ki_ - 1) + ((*lid_)) * ((0))))] + wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch1_[1 + (2) * ((m2_ 
        - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((1))))];
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = -wa_[0 + ((*ido_)) * ((l_ - 1 - 1) + 
        ((*ip_) - 1) * ((1)))] * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * (((*ip_) - 1))))];
      }
    }
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      idlj_ = _imod ((l_ - 1) * (j_ - 1), (*ip_));
      war_ = wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((0)))];
      wai_ = -wa_[0 + ((*ido_)) * ((idlj_ - 1) + ((*ip_) - 1) * ((1)))];
      for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] + war_ * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
          - 1))))];
          cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] + wai_ * ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * 
          ((jc_ - 1))))];
          cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((l_ - 1))))] + war_ * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ 
          - 1))))];
          cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
          * ((ki_ - 1) + ((*lid_)) * ((lc_ - 1))))] + wai_ * ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * 
          ((jc_ - 1))))];
        }
      }
    }
  }
  if ((*ido_) > 1) {
    goto _l136;
  }
  sn_ = 1.0 / (real_4) ((*ip_) * (*l1_));
  if ((*na_) == 1) {
    goto _l146;
  }
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = sn_ * cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
      * ((ki_ - 1) + ((*lid_)) * ((0))))];
      cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = sn_ * cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
      * ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        chold1_ = sn_ * (cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ 
        - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))]);
        chold2_ = sn_ * (cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ 
        - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))]);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = chold1_;
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = sn_ * (cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = sn_ * (cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = chold2_;
      }
    }
  }
  goto _l0;
  _l146:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = sn_ * cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
      * ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = sn_ * cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
      * ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = sn_ * (cc1_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = sn_ * (cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = sn_ * (cc1_[0 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = sn_ * (cc1_[1 + (2) * ((m1_ - 1) + 
        ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * 
        ((jc_ - 1))))]);
      }
    }
  }
  goto _l0;
  _l136:;
  for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
      ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((0))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * 
      ((ki_ - 1) + ((*lid_)) * ((0))))];
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (ki_ = 1; ki_ <= (*lid_); (ki_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] + cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
        ch1_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 1))))] = cc1_[1 + (2) * ((m1_ - 1) + ((*in1_)) 
        * ((ki_ - 1) + ((*lid_)) * ((j_ - 1))))] - cc1_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((ki_ - 1) + ((*lid_)) * ((jc_ - 
        1))))];
      }
    }
  }
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1)))))] = ch_[0 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))];
        cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ip_)) * ((i_ - 1)))))] = ch_[1 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((0)))))];
      }
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0)))))] = ch_[0 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((j_ - 1)))))];
        cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((0)))))] = ch_[1 + (2) * ((m2_ - 
        1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((0) + ((*ido_)) * ((j_ - 1)))))];
      }
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (i_ = 2; i_ <= (*ido_); (i_)++) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc_[0 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1)))))] = wa_[i_ - 1 + 
          ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch_[0 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
          - 1) + ((*ido_)) * ((j_ - 1)))))] + wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[1 + (2) * 
          ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1)))))];
          cc_[1 + (2) * ((m1_ - 1) + ((*in1_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1) + ((*ip_)) * ((i_ - 1)))))] = wa_[i_ - 1 + 
          ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((0)))] * ch_[1 + (2) * ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ 
          - 1) + ((*ido_)) * ((j_ - 1)))))] - wa_[i_ - 1 + ((*ido_)) * ((j_ - 1 - 1) + ((*ip_) - 1) * ((1)))] * ch_[0 + (2) * 
          ((m2_ - 1) + ((*in2_)) * ((k_ - 1) + ((*l1_)) * ((i_ - 1) + ((*ido_)) * ((j_ - 1)))))];
        }
      }
    }
  }
  _l0:;
  __calls[141].calls++;
  return 0;
}

int_4 _cmfm1b (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, real_4 _p_ ch_, real_4 
_p_ wa_, real_4 _p_ fnf_, real_4 _p_ fac_)
{
  static int_4 nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, lid_, nbr_;
  nf_ = (*fnf_);
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    lid_ = l1_ * ido_;
    nbr_ = 1 + na_ + 2 * _min (ip_ - 2, 4);
    switch (nbr_) {
      default:
      case 1: goto _l52;
      case 2: goto _l62;
      case 3: goto _l53;
      case 4: goto _l63;
      case 5: goto _l54;
      case 6: goto _l64;
      case 7: goto _l55;
      case 8: goto _l65;
      case 9: goto _l56;
      case 10: goto _l66;
    }
    _l52:;
    (void) _cmf2kb (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l62:;
    (void) _cmf2kb (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l53:;
    (void) _cmf3kb (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l63:;
    (void) _cmf3kb (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l54:;
    (void) _cmf4kb (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l64:;
    (void) _cmf4kb (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l55:;
    (void) _cmf5kb (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l65:;
    (void) _cmf5kb (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l56:;
    (void) _cmfgkb (lot_, &ido_, &ip_, &l1_, &lid_, &na_, c_, c_, jump_, inc_, ch_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l66:;
    (void) _cmfgkb (lot_, &ido_, &ip_, &l1_, &lid_, &na_, ch_, ch_, &_k1, lot_, c_, c_, jump_, inc_, &wa_[iw_ - 1]);
    _l120:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    if (ip_ <= 5) {
      na_ = 1 - na_;
    }
  }
  __calls[142].calls++;
  return 0;
}

int_4 _cmfm1f (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, complex_8 _p_ c_, real_4 _p_ ch_, real_4 
_p_ wa_, real_4 _p_ fnf_, real_4 _p_ fac_)
{
  static int_4 nf_, na_, l1_, iw_, k1_, ip_, l2_, ido_, lid_, nbr_;
  nf_ = (*fnf_);
  na_ = 0;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    lid_ = l1_ * ido_;
    nbr_ = 1 + na_ + 2 * _min (ip_ - 2, 4);
    switch (nbr_) {
      default:
      case 1: goto _l52;
      case 2: goto _l62;
      case 3: goto _l53;
      case 4: goto _l63;
      case 5: goto _l54;
      case 6: goto _l64;
      case 7: goto _l55;
      case 8: goto _l65;
      case 9: goto _l56;
      case 10: goto _l66;
    }
    _l52:;
    (void) _cmf2kf (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l62:;
    (void) _cmf2kf (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l53:;
    (void) _cmf3kf (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l63:;
    (void) _cmf3kf (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l54:;
    (void) _cmf4kf (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l64:;
    (void) _cmf4kf (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l55:;
    (void) _cmf5kf (lot_, &ido_, &l1_, &na_, c_, jump_, inc_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l65:;
    (void) _cmf5kf (lot_, &ido_, &l1_, &na_, ch_, &_k1, lot_, c_, jump_, inc_, &wa_[iw_ - 1]);
    goto _l120;
    _l56:;
    (void) _cmfgkf (lot_, &ido_, &ip_, &l1_, &lid_, &na_, c_, c_, jump_, inc_, ch_, ch_, &_k1, lot_, &wa_[iw_ - 1]);
    goto _l120;
    _l66:;
    (void) _cmfgkf (lot_, &ido_, &ip_, &l1_, &lid_, &na_, ch_, ch_, &_k1, lot_, c_, c_, jump_, inc_, &wa_[iw_ - 1]);
    _l120:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    if (ip_ <= 5) {
      na_ = 1 - na_;
    }
  }
  __calls[143].calls++;
  return 0;
}

int_4 _cosq1b (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ lensav_, 
real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  static real_4 ssqrt2_, x1_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_70, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_70, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_70, ($2_ = 10, &$2_));
    goto _l300;
  }
  $3_ = (*n_) - 2;
  if ($3_ < 0) {
    goto _l300;
  } else if ($3_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ssqrt2_ = 7.0710678e-1;
  x1_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = ssqrt2_ * (x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((1))]);
  x_[0 + ((*inc_)) * ((0))] = x1_;
  goto _l0;
  _l103:;
  (void) _cosqb1 (n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_70, ($4_ = -5, &$4_));
  }
  _l300:;
  _l0:;
  __calls[144].calls++;
  return 0;
}

int_4 _cosq1f (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ lensav_, 
real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  static real_4 ssqrt2_, tsqx_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_71, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_71, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_71, ($2_ = 10, &$2_));
    goto _l300;
  }
  $3_ = (*n_) - 2;
  if ($3_ < 0) {
    goto _l102;
  } else if ($3_ == 0) {
    goto _l101;
  } else {
    goto _l103;
  }
  _l101:;
  ssqrt2_ = 7.0710678e-1;
  tsqx_ = ssqrt2_ * x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = .5 * x_[0 + ((*inc_)) * ((0))] - tsqx_;
  x_[0 + ((*inc_)) * ((0))] = .5 * x_[0 + ((*inc_)) * ((0))] + tsqx_;
  _l102:;
  goto _l0;
  _l103:;
  (void) _cosqf1 (n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_71, ($4_ = -5, &$4_));
  }
  _l300:;
  _l0:;
  __calls[145].calls++;
  return 0;
}

int_4 _cosq1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 k_, lnsv_, ier1_;
  static real_4 pih_, dt_, fk_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_72, ($0_ = 3, &$0_));
    goto _l300;
  }
  pih_ = 1.5707963;
  dt_ = pih_ / (real_4) ((*n_));
  fk_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = cosf (fk_ * dt_);
  }
  lnsv_ = (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _rfft1i (n_, &wsave_[(*n_) + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_72, ($1_ = -5, &$1_));
  }
  _l300:;
  __calls[146].calls++;
  return 0;
}

int_4 _cosqb1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 ns2_, np2_, i_, modn_, lenx_, lnsv_, lnwk_, ier1_, k_, kc_;
  static real_4 xim1_;
  int_4 $0_;
  (*ier_) = 0;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xim1_ = x_[0 + ((*inc_)) * ((i_ - 1 - 1))] + x_[0 + ((*inc_)) * ((i_ - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1))] = .5 * (x_[0 + ((*inc_)) * ((i_ - 1 - 1))] - x_[0 + ((*inc_)) * ((i_ - 1))]);
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = .5 * xim1_;
  }
  x_[0 + ((*inc_)) * ((0))] = .5 * x_[0 + ((*inc_)) * ((0))];
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    goto _l302;
  }
  x_[0 + ((*inc_)) * (((*n_) - 1))] = .5 * x_[0 + ((*inc_)) * (((*n_) - 1))];
  _l302:;
  lenx_ = (*inc_) * ((*n_) - 1) + 1;
  lnsv_ = (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*n_);
  (void) _rfft1b (n_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_73, ($0_ = -5, &$0_));
    goto _l400;
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    work_[k_ - 1] = wsave_[k_ - 1 - 1] * x_[0 + ((*inc_)) * ((kc_ - 1))] + wsave_[kc_ - 1 - 1] * x_[0 + ((*inc_)) * ((k_ - 
    1))];
    work_[kc_ - 1] = wsave_[k_ - 1 - 1] * x_[0 + ((*inc_)) * ((k_ - 1))] - wsave_[kc_ - 1 - 1] * x_[0 + ((*inc_)) * ((kc_ - 
    1))];
  }
  if (modn_ != 0) {
    goto _l305;
  }
  x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] = wsave_[ns2_ - 1] * (x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[0 + ((*inc_)) * 
  ((ns2_ + 1 - 1))]);
  _l305:;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    x_[0 + ((*inc_)) * ((k_ - 1))] = work_[k_ - 1] + work_[kc_ - 1];
    x_[0 + ((*inc_)) * ((kc_ - 1))] = work_[k_ - 1] - work_[kc_ - 1];
  }
  x_[0 + ((*inc_)) * ((0))] = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((0))];
  _l400:;
  __calls[147].calls++;
  return 0;
}

int_4 _cosqf1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 ns2_, np2_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 xim1_;
  int_4 $0_;
  (*ier_) = 0;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    work_[k_ - 1] = x_[0 + ((*inc_)) * ((k_ - 1))] + x_[0 + ((*inc_)) * ((kc_ - 1))];
    work_[kc_ - 1] = x_[0 + ((*inc_)) * ((k_ - 1))] - x_[0 + ((*inc_)) * ((kc_ - 1))];
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    goto _l301;
  }
  work_[ns2_ + 1 - 1] = x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))];
  _l301:;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    x_[0 + ((*inc_)) * ((k_ - 1))] = wsave_[k_ - 1 - 1] * work_[kc_ - 1] + wsave_[kc_ - 1 - 1] * work_[k_ - 1];
    x_[0 + ((*inc_)) * ((kc_ - 1))] = wsave_[k_ - 1 - 1] * work_[k_ - 1] - wsave_[kc_ - 1 - 1] * work_[kc_ - 1];
  }
  if (modn_ != 0) {
    goto _l303;
  }
  x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] = wsave_[ns2_ - 1] * work_[ns2_ + 1 - 1];
  _l303:;
  lenx_ = (*inc_) * ((*n_) - 1) + 1;
  lnsv_ = (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*n_);
  (void) _rfft1f (n_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_74, ($0_ = -5, &$0_));
    goto _l400;
  }
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xim1_ = .5 * (x_[0 + ((*inc_)) * ((i_ - 1 - 1))] + x_[0 + ((*inc_)) * ((i_ - 1))]);
    x_[0 + ((*inc_)) * ((i_ - 1))] = .5 * (x_[0 + ((*inc_)) * ((i_ - 1 - 1))] - x_[0 + ((*inc_)) * ((i_ - 1))]);
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = xim1_;
  }
  _l400:;
  __calls[148].calls++;
  return 0;
}

int_4 _cosqmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 
_p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, ier1_;
  static real_4 ssqrt2_, x1_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_75, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_75, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_75, ($2_ = 10, &$2_));
    goto _l300;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_75, &_km1);
    goto _l300;
  }
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $3_ = (*n_) - 2;
  if ($3_ < 0) {
    goto _l101;
  } else if ($3_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l101:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    /* x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] */;
  }
  goto _l0;
  _l102:;
  ssqrt2_ = 7.0710678e-1;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = ssqrt2_ * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = x1_;
  }
  goto _l0;
  _l103:;
  (void) _mcsqb1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_75, ($4_ = -5, &$4_));
  }
  _l300:;
  _l0:;
  __calls[149].calls++;
  return 0;
}

int_4 _cosqmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 
_p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, ier1_;
  static real_4 ssqrt2_, tsqx_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_76, ($0_ = 6, &$0_));
    goto _l300;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_76, ($1_ = 8, &$1_));
    goto _l300;
  }
  else if ((*lenwrk_) < (*lot_) * (*n_)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_76, ($2_ = 10, &$2_));
    goto _l300;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_76, &_km1);
    goto _l300;
  }
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $3_ = (*n_) - 2;
  if ($3_ < 0) {
    goto _l102;
  } else if ($3_ == 0) {
    goto _l101;
  } else {
    goto _l103;
  }
  _l101:;
  ssqrt2_ = 7.0710678e-1;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    tsqx_ = ssqrt2_ * x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = .5 * x_[m_ - 1 + ((*inc_)) * ((0))] - tsqx_;
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * x_[m_ - 1 + ((*inc_)) * ((0))] + tsqx_;
  }
  _l102:;
  goto _l0;
  _l103:;
  (void) _mcsqf1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_76, ($4_ = -5, &$4_));
  }
  _l300:;
  _l0:;
  __calls[150].calls++;
  return 0;
}

int_4 _cosqmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 k_, lnsv_, ier1_;
  static real_4 pih_, dt_, fk_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_77, ($0_ = 3, &$0_));
    goto _l300;
  }
  pih_ = 1.5707963;
  dt_ = pih_ / (real_4) ((*n_));
  fk_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = cosf (fk_ * dt_);
  }
  lnsv_ = (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _rfftmi (n_, &wsave_[(*n_) + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_77, ($1_ = -5, &$1_));
  }
  _l300:;
  __calls[151].calls++;
  return 0;
}

int_4 _cost1b (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ lensav_, 
real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_78, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_78, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*n_) - 1) {
    (*ier_) = 3;
    (void) _xerfft (_dc_78, ($2_ = 10, &$2_));
    goto _l100;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _costb1 (n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_78, ($3_ = -5, &$3_));
  }
  _l100:;
  _l0:;
  __calls[152].calls++;
  return 0;
}

int_4 _cost1f (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 _p_ wsave_, int_4 _p_ lensav_, 
real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_79, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_79, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*n_) - 1) {
    (*ier_) = 3;
    (void) _xerfft (_dc_79, ($2_ = 10, &$2_));
    goto _l100;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  (void) _costf1 (n_, inc_, x_, wsave_, work_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_79, ($3_ = -5, &$3_));
  }
  _l100:;
  _l0:;
  __calls[153].calls++;
  return 0;
}

int_4 _cost1i (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, lnsv_, ier1_;
  static real_4 pi_, dt_, fk_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_80, ($0_ = 3, &$0_));
    goto _l300;
  }
  if ((*n_) <= 3) {
    goto _l0;
  }
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  pi_ = 3.1415927;
  dt_ = pi_ / (real_4) (nm1_);
  fk_ = 0.0;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = 2.0 * sinf (fk_ * dt_);
    wsave_[kc_ - 1] = 2.0 * cosf (fk_ * dt_);
  }
  lnsv_ = nm1_ + (int_4) (_aintd (logf ((real_4) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _rfft1i (&nm1_, &wsave_[(*n_) + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_80, ($1_ = -5, &$1_));
  }
  _l300:;
  _l0:;
  __calls[154].calls++;
  return 0;
}

int_4 _costb1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 x1h_, x1p3_, x2_, t1_, t2_, fnm1s2_, fnm1s4_, xi_;
  static real_8 dsum_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l106;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  x1h_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((0))] = x1h_;
  goto _l0;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  x1p3_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((2))];
  x2_ = x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((2))];
  x_[0 + ((*inc_)) * ((0))] = x1p3_ + x2_;
  x_[0 + ((*inc_)) * ((2))] = x1p3_ - x2_;
  goto _l0;
  _l103:;
  x_[0 + ((*inc_)) * ((0))] = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((0))];
  x_[0 + ((*inc_)) * (((*n_) - 1))] = x_[0 + ((*inc_)) * (((*n_) - 1))] + x_[0 + ((*inc_)) * (((*n_) - 1))];
  dsum_ = x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * (((*n_) - 1))];
  x_[0 + ((*inc_)) * ((0))] = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * (((*n_) - 1))];
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = x_[0 + ((*inc_)) * ((k_ - 1))] + x_[0 + ((*inc_)) * ((kc_ - 1))];
    t2_ = x_[0 + ((*inc_)) * ((k_ - 1))] - x_[0 + ((*inc_)) * ((kc_ - 1))];
    dsum_ = dsum_ + wsave_[kc_ - 1] * t2_;
    t2_ = wsave_[k_ - 1] * t2_;
    x_[0 + ((*inc_)) * ((k_ - 1))] = t1_ - t2_;
    x_[0 + ((*inc_)) * ((kc_ - 1))] = t1_ + t2_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] = x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))];
  _l124:;
  lenx_ = (*inc_) * (nm1_ - 1) + 1;
  lnsv_ = nm1_ + (int_4) (_aintd (logf ((real_4) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = nm1_;
  (void) _rfft1f (&nm1_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_81, ($1_ = -5, &$1_));
    goto _l0;
  }
  fnm1s2_ = (real_4) (nm1_) / 2.0;
  dsum_ = .5 * dsum_;
  x_[0 + ((*inc_)) * ((0))] = fnm1s2_ * x_[0 + ((*inc_)) * ((0))];
  if (_imod (nm1_, 2) != 0) {
    goto _l30;
  }
  x_[0 + ((*inc_)) * ((nm1_ - 1))] = x_[0 + ((*inc_)) * ((nm1_ - 1))] + x_[0 + ((*inc_)) * ((nm1_ - 1))];
  _l30:;
  fnm1s4_ = (real_4) (nm1_) / 4.0;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xi_ = fnm1s4_ * x_[0 + ((*inc_)) * ((i_ - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1))] = fnm1s4_ * x_[0 + ((*inc_)) * ((i_ - 1 - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = dsum_;
    dsum_ = dsum_ + xi_;
  }
  if (modn_ != 0) {
    goto _l0;
  }
  x_[0 + ((*inc_)) * (((*n_) - 1))] = dsum_;
  _l106:;
  _l0:;
  __calls[155].calls++;
  return 0;
}

int_4 _costf1 (int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 x1h_, x1p3_, tx2_, t1_, t2_, snm1_, xi_;
  static real_8 dsum_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l200;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  x1h_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = .5 * (x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((1))]);
  x_[0 + ((*inc_)) * ((0))] = .5 * x1h_;
  goto _l200;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  x1p3_ = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * ((2))];
  tx2_ = x_[0 + ((*inc_)) * ((1))] + x_[0 + ((*inc_)) * ((1))];
  x_[0 + ((*inc_)) * ((1))] = .5 * (x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * ((2))]);
  x_[0 + ((*inc_)) * ((0))] = .25 * (x1p3_ + tx2_);
  x_[0 + ((*inc_)) * ((2))] = .25 * (x1p3_ - tx2_);
  goto _l200;
  _l103:;
  dsum_ = x_[0 + ((*inc_)) * ((0))] - x_[0 + ((*inc_)) * (((*n_) - 1))];
  x_[0 + ((*inc_)) * ((0))] = x_[0 + ((*inc_)) * ((0))] + x_[0 + ((*inc_)) * (((*n_) - 1))];
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    t1_ = x_[0 + ((*inc_)) * ((k_ - 1))] + x_[0 + ((*inc_)) * ((kc_ - 1))];
    t2_ = x_[0 + ((*inc_)) * ((k_ - 1))] - x_[0 + ((*inc_)) * ((kc_ - 1))];
    dsum_ = dsum_ + wsave_[kc_ - 1] * t2_;
    t2_ = wsave_[k_ - 1] * t2_;
    x_[0 + ((*inc_)) * ((k_ - 1))] = t1_ - t2_;
    x_[0 + ((*inc_)) * ((kc_ - 1))] = t1_ + t2_;
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] = x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[0 + ((*inc_)) * ((ns2_ + 1 - 1))];
  _l124:;
  lenx_ = (*inc_) * (nm1_ - 1) + 1;
  lnsv_ = nm1_ + (int_4) (_aintd (logf ((real_4) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = nm1_;
  (void) _rfft1f (&nm1_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_82, ($1_ = -5, &$1_));
    goto _l200;
  }
  snm1_ = 1.0 / (real_4) (nm1_);
  dsum_ = snm1_ * dsum_;
  if (_imod (nm1_, 2) != 0) {
    goto _l30;
  }
  x_[0 + ((*inc_)) * ((nm1_ - 1))] = x_[0 + ((*inc_)) * ((nm1_ - 1))] + x_[0 + ((*inc_)) * ((nm1_ - 1))];
  _l30:;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    xi_ = .5 * x_[0 + ((*inc_)) * ((i_ - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1))] = .5 * x_[0 + ((*inc_)) * ((i_ - 1 - 1))];
    x_[0 + ((*inc_)) * ((i_ - 1 - 1))] = dsum_;
    dsum_ = dsum_ + xi_;
  }
  if (modn_ != 0) {
    goto _l117;
  }
  x_[0 + ((*inc_)) * (((*n_) - 1))] = dsum_;
  _l117:;
  x_[0 + ((*inc_)) * ((0))] = .5 * x_[0 + ((*inc_)) * ((0))];
  x_[0 + ((*inc_)) * (((*n_) - 1))] = .5 * x_[0 + ((*inc_)) * (((*n_) - 1))];
  _l200:;
  __calls[156].calls++;
  return 0;
}

int_4 _costmb (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 
_p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_, ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_83, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_83, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*lot_) * ((*n_) + 1)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_83, ($2_ = 10, &$2_));
    goto _l100;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_83, &_km1);
    goto _l100;
  }
  iw1_ = (*lot_) + (*lot_) + 1;
  (void) _mcstb1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &work_[iw1_ - 1], &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_83, ($3_ = -5, &$3_));
  }
  _l100:;
  __calls[157].calls++;
  return 0;
}

int_4 _costmf (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, int_4 _p_ lenx_, real_4 
_p_ wsave_, int_4 _p_ lensav_, real_4 _p_ work_, int_4 _p_ lenwrk_, int_4 _p_ ier_)
{
  static int_4 iw1_, ier1_;
  int_4 $0_, $1_, $2_, $3_;
  (*ier_) = 0;
  if ((*lenx_) < ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1) {
    (*ier_) = 1;
    (void) _xerfft (_dc_84, ($0_ = 6, &$0_));
    goto _l100;
  }
  else if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_84, ($1_ = 8, &$1_));
    goto _l100;
  }
  else if ((*lenwrk_) < (*lot_) * ((*n_) + 1)) {
    (*ier_) = 3;
    (void) _xerfft (_dc_84, ($2_ = 10, &$2_));
    goto _l100;
  }
  else if (! (_xercon (inc_, jump_, n_, lot_))) {
    (*ier_) = 4;
    (void) _xerfft (_dc_84, &_km1);
    goto _l100;
  }
  iw1_ = (*lot_) + (*lot_) + 1;
  (void) _mcstf1 (lot_, jump_, n_, inc_, x_, wsave_, work_, &work_[iw1_ - 1], &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_84, ($3_ = -5, &$3_));
  }
  _l100:;
  __calls[158].calls++;
  return 0;
}

int_4 _costmi (int_4 _p_ n_, real_4 _p_ wsave_, int_4 _p_ lensav_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, k_, kc_, lnsv_, ier1_;
  static real_4 pi_, dt_, fk_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  if ((*lensav_) < 2 * (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
    6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4) {
    (*ier_) = 2;
    (void) _xerfft (_dc_85, ($0_ = 3, &$0_));
    goto _l300;
  }
  if ((*n_) <= 3) {
    goto _l0;
  }
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  pi_ = 3.1415927;
  dt_ = pi_ / (real_4) (nm1_);
  fk_ = 0.0;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    fk_ = fk_ + 1.0;
    wsave_[k_ - 1] = 2.0 * sinf (fk_ * dt_);
    wsave_[kc_ - 1] = 2.0 * cosf (fk_ * dt_);
  }
  lnsv_ = nm1_ + (int_4) (_aintd (logf ((real_4) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  (void) _rfftmi (&nm1_, &wsave_[(*n_) + 1 - 1], &lnsv_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_85, ($1_ = -5, &$1_));
  }
  _l300:;
  _l0:;
  __calls[159].calls++;
  return 0;
}

int_4 _factor (int_4 _p_ n_, int_4 _p_ nf_, real_4 _p_ fac_)
{
  static int_4 ntryh_[4], nl_, j_, ntry_, nq_, nr_;
  int_4 _data_k_19, $0_, $1_;
#define _data_n_19 4
  static int_4 _data_l_19[_data_n_19] = {
    4,
    2,
    3,
    5
  };
  if (__calls[160].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    ntryh_[0] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    ntryh_[1] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    ntryh_[2] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    ntryh_[3] = _data_l_19[_data_k_19++];
  }
  nl_ = (*n_);
  (*nf_) = 0;
  j_ = 0;
  _l101:;
  j_ = j_ + 1;
  $0_ = j_ - 4;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ntry_ = ntryh_[j_ - 1];
  goto _l104;
  _l103:;
  ntry_ = ntry_ + 2;
  _l104:;
  nq_ = nl_ / ntry_;
  nr_ = nl_ - ntry_ * nq_;
  $1_ = nr_;
  if ($1_ < 0) {
    goto _l101;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  (*nf_) = (*nf_) + 1;
  fac_[(*nf_) - 1] = ntry_;
  nl_ = nq_;
  if (nl_ != 1) {
    goto _l104;
  }
  __calls[160].calls++;
  return 0;
}

int_4 _mcfti1 (int_4 _p_ n_, real_4 _p_ wa_, real_4 _p_ fnf_, real_4 _p_ fac_)
{
  static int_4 nf_, iw_, l1_, k1_, ip_, l2_, ido_;
  (void) _factor (n_, &nf_, fac_);
  (*fnf_) = nf_;
  iw_ = 1;
  l1_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ - 1];
    l2_ = l1_ * ip_;
    ido_ = (*n_) / l2_;
    (void) _tables (&ido_, &ip_, &wa_[iw_ - 1]);
    iw_ = iw_ + (ip_ - 1) * (ido_ + ido_);
    l1_ = l2_;
  }
  __calls[161].calls++;
  return 0;
}

int_4 _mcsqb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 
_p_ work_, int_4 _p_ ier_)
{
  static int_4 lj_, ns2_, np2_, i_, m_, modn_, lenx_, lnsv_, lnwk_, ier1_, k_, kc_, m1_;
  static real_4 xim1_;
  int_4 $0_;
  (*ier_) = 0;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      xim1_ = x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] + x_[m_ - 1 + ((*inc_)) * ((i_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = .5 * (x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] - x_[m_ - 1 + ((*inc_)) * ((i_ - 
      1))]);
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = .5 * xim1_;
    }
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    goto _l302;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = .5 * x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
  }
  _l302:;
  lenx_ = ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1;
  lnsv_ = (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * (*n_);
  (void) _rfftmb (lot_, jump_, n_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_86, ($0_ = -5, &$0_));
    goto _l400;
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] = wsave_[k_ - 1 - 1] * x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] + wsave_[kc_ - 1 - 
      1] * x_[m_ - 1 + ((*inc_)) * ((k_ - 1))];
      work_[m1_ - 1 + ((*lot_)) * ((kc_ - 1))] = wsave_[k_ - 1 - 1] * x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - wsave_[kc_ - 1 - 
      1] * x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
    }
  }
  if (modn_ != 0) {
    goto _l305;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] = wsave_[ns2_ - 1] * (x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[m_ - 1 + 
    ((*inc_)) * ((ns2_ + 1 - 1))]);
  }
  _l305:;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] + work_[m1_ - 1 + ((*lot_)) * ((kc_ - 
      1))];
      x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] = work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] - work_[m1_ - 1 + ((*lot_)) * ((kc_ - 
      1))];
    }
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  _l400:;
  __calls[162].calls++;
  return 0;
}

int_4 _mcsqf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_4 
_p_ work_, int_4 _p_ ier_)
{
  static int_4 lj_, ns2_, np2_, k_, kc_, m1_, m_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 xim1_;
  int_4 $0_;
  (*ier_) = 0;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  ns2_ = ((*n_) + 1) / 2;
  np2_ = (*n_) + 2;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      work_[m1_ - 1 + ((*lot_)) * ((kc_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ != 0) {
    goto _l301;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    work_[m1_ - 1 + ((*lot_)) * ((ns2_ + 1 - 1))] = x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[m_ - 1 + ((*inc_)) * 
    ((ns2_ + 1 - 1))];
  }
  _l301:;
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    kc_ = np2_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = wsave_[k_ - 1 - 1] * work_[m1_ - 1 + ((*lot_)) * ((kc_ - 1))] + wsave_[kc_ - 1 - 
      1] * work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] = wsave_[k_ - 1 - 1] * work_[m1_ - 1 + ((*lot_)) * ((k_ - 1))] - wsave_[kc_ - 1 - 
      1] * work_[m1_ - 1 + ((*lot_)) * ((kc_ - 1))];
    }
  }
  if (modn_ != 0) {
    goto _l303;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] = wsave_[ns2_ - 1] * work_[m1_ - 1 + ((*lot_)) * ((ns2_ + 1 - 1))];
  }
  _l303:;
  lenx_ = ((*lot_) - 1) * (*jump_) + (*inc_) * ((*n_) - 1) + 1;
  lnsv_ = (*n_) + (int_4) (_aintd (logf ((real_4) ((*n_))) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * (*n_);
  (void) _rfftmf (lot_, jump_, n_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_87, ($0_ = -5, &$0_));
    goto _l400;
  }
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      xim1_ = .5 * (x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] + x_[m_ - 1 + ((*inc_)) * ((i_ - 1))]);
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = .5 * (x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] - x_[m_ - 1 + ((*inc_)) * ((i_ - 
      1))]);
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = xim1_;
    }
  }
  _l400:;
  __calls[163].calls++;
  return 0;
}

int_4 _mcstb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_8 
_p_ dsum_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, lj_, m_, m1_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 x1h_, x1p3_, x2_, t1_, t2_, fnm1s2_, fnm1s4_, xi_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l106;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1h_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((0))] = x1h_;
  }
  goto _l0;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1p3_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((2))];
    x2_ = x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((2))];
    x_[m_ - 1 + ((*inc_)) * ((0))] = x1p3_ + x2_;
    x_[m_ - 1 + ((*inc_)) * ((2))] = x1p3_ - x2_;
  }
  goto _l0;
  _l103:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((0))];
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] + x_[m_ - 1 + ((*inc_)) * (((*n_) - 
    1))];
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    dsum_[m1_ - 1] = x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
    x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      kc_ = np1_ - k_;
      t1_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      t2_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + wsave_[kc_ - 1] * t2_;
      t2_ = wsave_[k_ - 1] * t2_;
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = t1_ - t2_;
      x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] = t1_ + t2_;
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] = x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[m_ - 1 + ((*inc_)) * ((ns2_ 
    + 1 - 1))];
  }
  _l124:;
  lenx_ = ((*lot_) - 1) * (*jump_) + (*inc_) * (nm1_ - 1) + 1;
  lnsv_ = nm1_ + (int_4) (_aintd (logf ((real_4) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * nm1_;
  (void) _rfftmf (lot_, jump_, &nm1_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_88, ($1_ = -5, &$1_));
    goto _l106;
  }
  fnm1s2_ = (real_4) (nm1_) / 2.0;
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    dsum_[m1_ - 1] = .5 * dsum_[m1_ - 1];
    x_[m_ - 1 + ((*inc_)) * ((0))] = fnm1s2_ * x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  if (_imod (nm1_, 2) != 0) {
    goto _l30;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))];
  }
  _l30:;
  fnm1s4_ = (real_4) (nm1_) / 4.0;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      xi_ = fnm1s4_ * x_[m_ - 1 + ((*inc_)) * ((i_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = fnm1s4_ * x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = dsum_[m1_ - 1];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + xi_;
    }
  }
  if (modn_ != 0) {
    goto _l0;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = dsum_[m1_ - 1];
  }
  _l106:;
  _l0:;
  __calls[164].calls++;
  return 0;
}

int_4 _mcstf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_8 
_p_ dsum_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 nm1_, np1_, ns2_, lj_, m_, m1_, k_, kc_, modn_, lenx_, lnsv_, lnwk_, ier1_, i_;
  static real_4 x1h_, x1p3_, tx2_, t1_, t2_, snm1_, xi_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  nm1_ = (*n_) - 1;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l200;
  } else if ($0_ == 0) {
    goto _l101;
  } else {
    goto _l102;
  }
  _l101:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1h_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = .5 * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * x1h_;
  }
  goto _l200;
  _l102:;
  if ((*n_) > 3) {
    goto _l103;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x1p3_ = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((2))];
    tx2_ = x_[m_ - 1 + ((*inc_)) * ((1))] + x_[m_ - 1 + ((*inc_)) * ((1))];
    x_[m_ - 1 + ((*inc_)) * ((1))] = .5 * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((2))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = .25 * (x1p3_ + tx2_);
    x_[m_ - 1 + ((*inc_)) * ((2))] = .25 * (x1p3_ - tx2_);
  }
  goto _l200;
  _l103:;
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    dsum_[m1_ - 1] = x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
    x_[m_ - 1 + ((*inc_)) * ((0))] = x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
  }
  for (k_ = 2; k_ <= ns2_; (k_)++) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      kc_ = np1_ - k_;
      t1_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      t2_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + wsave_[kc_ - 1] * t2_;
      t2_ = wsave_[k_ - 1] * t2_;
      x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] = t1_ - t2_;
      x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))] = t1_ + t2_;
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] = x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))] + x_[m_ - 1 + ((*inc_)) * ((ns2_ 
    + 1 - 1))];
  }
  _l124:;
  lenx_ = ((*lot_) - 1) * (*jump_) + (*inc_) * (nm1_ - 1) + 1;
  lnsv_ = nm1_ + (int_4) (_aintd (logf ((real_4) (nm1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * nm1_;
  (void) _rfftmf (lot_, jump_, &nm1_, inc_, x_, &lenx_, &wsave_[(*n_) + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_89, ($1_ = -5, &$1_));
    goto _l200;
  }
  snm1_ = 1.0 / (real_4) (nm1_);
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    dsum_[m_ - 1] = snm1_ * dsum_[m_ - 1];
  }
  if (_imod (nm1_, 2) != 0) {
    goto _l30;
  }
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))] = x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((nm1_ - 1))];
  }
  _l30:;
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      xi_ = .5 * x_[m_ - 1 + ((*inc_)) * ((i_ - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = .5 * x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = dsum_[m1_ - 1];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + xi_;
    }
  }
  if (modn_ != 0) {
    goto _l117;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = dsum_[m1_ - 1];
  }
  _l117:;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * x_[m_ - 1 + ((*inc_)) * ((0))];
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = .5 * x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))];
  }
  _l200:;
  __calls[165].calls++;
  return 0;
}

int_4 _mradb2 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  int_4 $0_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 
      1))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 
      1))))];
    }
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * 
        ((k_ - 1))))];
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 
        1))))];
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * (cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((1) + (2) * ((k_ - 1))))]) - wa1_[i_ - 1 - 1] * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + 
        (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((1) + (2) * ((k_ - 1))))]) + wa1_[i_ - 1 - 1] * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * 
        ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
      }
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * 
      (((*ido_) - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + 
      (2) * ((k_ - 1))))];
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = -(cc_[m1_ - 1 + ((*in1_)) * 
      ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 
      1))))]);
    }
  }
  _l107:;
  _l0:;
  __calls[166].calls++;
  return 0;
}

int_4 _mradb3 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 arg_, taur_, taui_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  arg_ = 2.0943951;
  taur_ = cosf (arg_);
  taui_ = sinf (arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ 
      - 1))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (2.0 * taur_) * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (3) * ((k_ - 1))))] - (2.0 * taui_) * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (2.0 * taur_) * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (3) * ((k_ - 1))))] + 2.0 * taui_ * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))];
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ 
        - 1))))])) - (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) - wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + 
        (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + (taui_ * 
        (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 
        - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 
        1))))])) + (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) + wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - 
        (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ 
        - 1))))])) + (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) - wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + 
        (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - (taui_ * 
        (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 
        - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 
        1))))])) - (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) + wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + 
        (taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
      }
    }
  }
  _l0:;
  __calls[167].calls++;
  return 0;
}

int_4 _mradb4 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 sqrt2_;
  int_4 $0_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  sqrt2_ = 1.4142136;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) - (cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) 
      * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) + (cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) 
      * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
      1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
    }
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * 
        ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 
        1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 
        1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - 
        cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - 
        cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 
        1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa2_[i_ - 1 - 1] * 
        ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - cc_[m1_ - 
        1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + 
        (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 
        + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) - wa3_[i_ - 1 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - 
        cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] - 
        cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))])) + wa3_[i_ - 1 - 1] * ((cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] 
        + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))]));
      }
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = (cc_[m1_ - 1 + ((*in1_)) * 
      (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + 
      (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] + cc_[m1_ - 1 
      + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = sqrt2_ * ((cc_[m1_ - 1 + 
      ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + 
      ((*ido_)) * ((2) + (4) * ((k_ - 1))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + 
      cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]));
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[m1_ - 1 + ((*in1_)) * 
      ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 
      1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((1) + (4) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = -sqrt2_ * ((cc_[m1_ - 1 + 
      ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + 
      ((*ido_)) * ((2) + (4) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] + 
      cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))]));
    }
  }
  _l107:;
  _l0:;
  __calls[168].calls++;
  return 0;
}

int_4 _mradb5 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, real_4 _p_ wa4_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 arg_, tr11_, ti11_, tr12_, ti12_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  arg_ = 1.2566371;
  tr11_ = cosf (arg_);
  ti11_ = sinf (arg_);
  tr12_ = cosf (2.0 * arg_);
  ti12_ = sinf (2.0 * arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
      - 1))))] + 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) 
      - (ti11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + ti12_ * 2.0 * cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) 
      - (ti12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - ti11_ * 2.0 * cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) 
      + (ti12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - ti11_ * 2.0 * cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + 
      (5) * ((k_ - 1))))] + tr12_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]) 
      + (ti11_ * 2.0 * cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + ti12_ * 2.0 * cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))]);
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + (cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * 
        ((k_ - 1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
        - 1))))]) + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) - wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ 
        * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 
        1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa1_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
        - 1))))]) + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        - ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) - wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ 
        * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 
        1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa2_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
        - 1))))]) + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        - ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) - wa3_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] = wa3_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ 
        * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 
        1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa3_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr11_ * (cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) - ti11_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = wa4_[i_ - 2 - 1] * ((cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ 
        - 1))))]) + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + 
        ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) - wa4_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 
        1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] = wa4_[i_ - 2 - 1] * ((cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) 
        + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * 
        ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) - (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((2) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ 
        * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 
        1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))]))) + wa4_[i_ - 1 - 1] * ((cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((0) + (5) * ((k_ - 1))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + tr12_ * (cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
        ((*ido_)) * ((3) + (5) * ((k_ - 1))))])) + (ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * 
        ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))]) + ti12_ * (cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
        ((3) + (5) * ((k_ - 1))))])));
      }
    }
  }
  _l0:;
  __calls[169].calls++;
  return 0;
}

int_4 _mradbg (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_4 _p_ cc_, real_4 _p_ 
c1_, real_4 _p_ c2_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch2_, int_4 _p_ im2_, int_4 _p_ in2_, 
real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, idp2_, nbd_, ipp2_, ipph_, k_, i_, m2_, m1_, j_, jc_, j2_, ic_, l_, lc_, ik_, is_, idij_;
  static real_4 tpi_, arg_, dcp_, dsp_, ar1_, ai1_, ar1h_, dc2_, ds2_, ar2_, ai2_, ar2h_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  tpi_ = 6.2831853;
  arg_ = tpi_ / (real_4) ((*ip_));
  dcp_ = cosf (arg_);
  dsp_ = sinf (arg_);
  idp2_ = (*ido_) + 2;
  nbd_ = ((*ido_) - 1) / 2;
  ipp2_ = (*ip_) + 2;
  ipph_ = ((*ip_) + 1) / 2;
  if ((*ido_) < (*l1_)) {
    goto _l103;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))];
      }
    }
  }
  goto _l106;
  _l103:;
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) 
        + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))];
      }
    }
  }
  _l106:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * (((*ido_) 
        - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
        ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
        ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((j2_ - 1 - 1) + 
        ((*ip_)) * ((k_ - 1))))];
      }
    }
  }
  if ((*ido_) == 1) {
    goto _l116;
  }
  if (nbd_ < (*l1_)) {
    goto _l112;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ic_ = idp2_ - i_;
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
          ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
          ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
          - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
          ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) 
          * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        }
      }
    }
  }
  goto _l116;
  _l112:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
          ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + 
          ((*ido_)) * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ 
          - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] - cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * 
          ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1) + ((*ido_)) * ((2 * j_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] + cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) 
          * ((2 * j_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))];
        }
      }
    }
  }
  _l116:;
  ar1_ = 1.0;
  ai1_ = 0.0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    ar1h_ = dcp_ * ar1_ - dsp_ * ai1_;
    ai1_ = dcp_ * ai1_ + dsp_ * ar1_;
    ar1_ = ar1h_;
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
        ((0)))] + ar1_ * ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((1)))];
        c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ai1_ * ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + 
        ((*idl1_)) * (((*ip_) - 1)))];
      }
    }
    dc2_ = ar1_;
    ds2_ = ai1_;
    ar2_ = ar1_;
    ai2_ = ai1_;
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      ar2h_ = dc2_ * ar2_ - ds2_ * ai2_;
      ai2_ = dc2_ * ai2_ + ds2_ * ar2_;
      ar2_ = ar2h_;
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
          ((l_ - 1)))] + ar2_ * ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
          c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
          ((lc_ - 1)))] + ai2_ * ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((jc_ - 1)))];
        }
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
        ((0)))] + ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
      }
    }
  }
  if ((*ido_) == 1) {
    goto _l132;
  }
  if (nbd_ < (*l1_)) {
    goto _l128;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((i_ 
          - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
        }
      }
    }
  }
  goto _l132;
  _l128:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((i_ 
          - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
        }
      }
    }
  }
  _l132:;
  if ((*ido_) == 1) {
    goto _l0;
  }
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
      ((0)))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  if (nbd_ > (*l1_)) {
    goto _l139;
  }
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    idij_ = is_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * 
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * ch_[m2_ - 
          1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * ch_[m2_ - 
          1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * ch_[m2_ - 1 + ((*in2_)) 
          * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l143;
  _l139:;
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = is_;
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * 
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * ch_[m2_ - 
          1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * ch_[m2_ - 
          1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * ch_[m2_ - 1 + ((*in2_)) 
          * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  _l143:;
  _l0:;
  __calls[170].calls++;
  return 0;
}

int_4 _mradf2 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  int_4 $0_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))];
    }
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((0))))];
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((1))))]);
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((1))))]);
      }
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = -cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * (((*ido_) 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
    }
  }
  _l107:;
  _l0:;
  __calls[171].calls++;
  return 0;
}

int_4 _mradf3 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 arg_, taur_, taui_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  arg_ = 2.0943951;
  taur_ = cosf (arg_);
  taui_ = sinf (arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + 
      cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = taui_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) + (taui_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - 
        (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) - (taui_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - 
        (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) + (taui_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
        * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - 
        (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = (taui_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]))) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - 
        wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
      }
    }
  }
  _l0:;
  __calls[172].calls++;
  return 0;
}

int_4 _mradf4 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 hsqt2_;
  int_4 $0_;
  hsqt2_ = 7.0710678e-1;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) + 
      (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))]) - (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * 
      ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
    }
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))])) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((0))))] + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
        wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((2))))])) - ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + 
        wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))])) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] 
        + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))])) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] 
        + (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))])) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((0))))] - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
        wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((2))))])) - ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((1))))]) - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - 
        wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))])) + (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] 
        - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))])) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] 
        - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      }
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (4) * ((k_ - 1))))] = (hsqt2_ * (cc_[m1_ - 1 + ((*in1_)) 
      * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))])) + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((0))))];
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((2) + (4) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * (((*ido_) 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (hsqt2_ * (cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))] - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((3))))]));
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((1) + (4) * ((k_ - 1))))] = (-hsqt2_ * (cc_[m1_ - 1 + ((*in1_)) * 
      (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))])) - cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))];
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((3) + (4) * ((k_ - 1))))] = (-hsqt2_ * (cc_[m1_ - 1 + ((*in1_)) * 
      (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((3))))])) + cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))];
    }
  }
  _l107:;
  _l0:;
  __calls[173].calls++;
  return 0;
}

int_4 _mradf5 (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ 
ch_, int_4 _p_ im2_, int_4 _p_ in2_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, real_4 _p_ wa4_)
{
  static int_4 m1d_, m2s_, k_, m2_, m1_, idp2_, i_, ic_;
  static real_4 arg_, tr11_, ti11_, tr12_, ti12_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  arg_ = 1.2566371;
  tr11_ = cosf (arg_);
  ti11_ = sinf (arg_);
  tr12_ = cosf (2.0 * arg_);
  ti12_ = sinf (2.0 * arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + 
      cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((4))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + tr12_ * (cc_[m1_ 
      - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((4))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + tr11_ * (cc_[m1_ 
      - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((2))))]);
      ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = ti12_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) - ti11_ * (cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - cc_[m1_ - 1 + 
      ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] 
        + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + 
        ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] + wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))]) + tr12_ * (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
        wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) + ti11_ * (wa1_[i_ - 2 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + ti12_ * (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((2))))] - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((3))))]));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))] + wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))]) + tr12_ * (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
        wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (ti11_ * (wa1_[i_ - 2 - 1] 
        * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + ti12_ * (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((2))))] - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((3))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (5) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + tr12_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + 
        (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) + (ti11_ * ((wa4_[i_ - 2 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) + ti12_ * ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) 
        * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (5) * ((k_ - 1))))] = (ti11_ * ((wa4_[i_ - 2 - 1] * cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) + ti12_ * ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr11_ * ((wa1_[i_ - 
        2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ 
        - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr12_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + 
        (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) + (ti12_ * ((wa1_[i_ - 2 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) - ti11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 
        1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) 
        + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + 
        (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) - (ti12_ * ((wa1_[i_ - 2 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 
        + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) - ti11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((4) + (5) * ((k_ - 1))))] = (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + 
        (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 
        1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]))) + (ti12_ * ((wa4_[i_ - 2 
        - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * 
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) - ti11_ * ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) 
        * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))])));
        ch_[m2_ - 1 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((3) + (5) * ((k_ - 1))))] = (ti12_ * ((wa4_[i_ - 2 - 1] * cc_[m1_ - 
        1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] + wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))]) - (wa1_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * 
        ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))])) - ti11_ * ((wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((3))))] + wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ 
        - 1) + ((*l1_)) * ((3))))]) - (wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((2))))]))) - (cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + tr12_ * ((wa1_[i_ - 
        2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[m1_ 
        - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + (wa4_[i_ - 2 - 1] * cc_[m1_ - 1 + 
        ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))] - wa4_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((4))))])) + tr11_ * ((wa2_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ 
        - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) + (wa3_[i_ - 2 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
        ((k_ - 1) + ((*l1_)) * ((3))))] - wa3_[i_ - 1 - 1] * cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + 
        ((*l1_)) * ((3))))])));
      }
    }
  }
  _l0:;
  __calls[174].calls++;
  return 0;
}

int_4 _mradfg (int_4 _p_ m_, int_4 _p_ ido_, int_4 _p_ ip_, int_4 _p_ l1_, int_4 _p_ idl1_, real_4 _p_ cc_, real_4 _p_ 
c1_, real_4 _p_ c2_, int_4 _p_ im1_, int_4 _p_ in1_, real_4 _p_ ch_, real_4 _p_ ch2_, int_4 _p_ im2_, int_4 _p_ in2_, 
real_4 _p_ wa_)
{
  static int_4 m1d_, m2s_, ipph_, ipp2_, idp2_, nbd_, ik_, m2_, m1_, j_, k_, is_, idij_, i_, jc_, l_, lc_, j2_, ic_;
  static real_4 tpi_, arg_, dcp_, dsp_, ar1_, ai1_, ar1h_, dc2_, ds2_, ar2_, ai2_, ar2h_;
  m1d_ = ((*m_) - 1) * (*im1_) + 1;
  m2s_ = 1 - (*im2_);
  tpi_ = 6.2831853;
  arg_ = tpi_ / (real_4) ((*ip_));
  dcp_ = cosf (arg_);
  dsp_ = sinf (arg_);
  ipph_ = ((*ip_) + 1) / 2;
  ipp2_ = (*ip_) + 2;
  idp2_ = (*ido_) + 2;
  nbd_ = ((*ido_) - 1) / 2;
  if ((*ido_) == 1) {
    goto _l119;
  }
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
      ((0)))];
    }
  }
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = c1_[m1_ - 1 + ((*in1_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
      }
    }
  }
  if (nbd_ > (*l1_)) {
    goto _l107;
  }
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    idij_ = is_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      idij_ = idij_ + 2;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * 
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * c1_[m1_ - 
          1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * c1_[m1_ - 
          1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * c1_[m1_ - 1 + ((*in1_)) 
          * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l111;
  _l107:;
  is_ = -(*ido_);
  for (j_ = 2; j_ <= (*ip_); (j_)++) {
    is_ = is_ + (*ido_);
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      idij_ = is_;
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        idij_ = idij_ + 2;
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * 
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + wa_[idij_ - 1] * c1_[m1_ - 
          1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
          ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = wa_[idij_ - 1 - 1] * c1_[m1_ - 
          1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - wa_[idij_ - 1] * c1_[m1_ - 1 + ((*in1_)) 
          * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  _l111:;
  if (nbd_ < (*l1_)) {
    goto _l115;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) 
          * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((i_ 
          - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
          ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) 
          * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l121;
  _l115:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) 
          * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((i_ 
          - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
          ((*l1_)) * ((jc_ - 1))))];
          c1_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) 
          * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l121;
  _l119:;
  for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
    m2_ = m2s_;
    for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
      m2_ = m2_ + (*im2_);
      c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
      ((0)))];
    }
  }
  _l121:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((jc_ - 1))))];
        c1_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((0) + 
        ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
        ((j_ - 1))))];
      }
    }
  }
  ar1_ = 1.0;
  ai1_ = 0.0;
  for (l_ = 2; l_ <= ipph_; (l_)++) {
    lc_ = ipp2_ - l_;
    ar1h_ = dcp_ * ar1_ - dsp_ * ai1_;
    ai1_ = dcp_ * ai1_ + dsp_ * ar1_;
    ar1_ = ar1h_;
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * 
        ((0)))] + ar1_ * c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((1)))];
        ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ai1_ * c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + 
        ((*idl1_)) * (((*ip_) - 1)))];
      }
    }
    dc2_ = ar1_;
    ds2_ = ai1_;
    ar2_ = ar1_;
    ai2_ = ai1_;
    for (j_ = 3; j_ <= ipph_; (j_)++) {
      jc_ = ipp2_ - j_;
      ar2h_ = dc2_ * ar2_ - ds2_ * ai2_;
      ai2_ = dc2_ * ai2_ + ds2_ * ar2_;
      ar2_ = ar2h_;
      for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((l_ - 1)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) 
          * ((l_ - 1)))] + ar2_ * c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
          ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((lc_ - 1)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) 
          * ((lc_ - 1)))] + ai2_ * c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((jc_ - 1)))];
        }
      }
    }
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    for (ik_ = 1; ik_ <= (*idl1_); (ik_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * ((0)))] = ch2_[m2_ - 1 + ((*in2_)) * ((ik_ - 1) + ((*idl1_)) * 
        ((0)))] + c2_[m1_ - 1 + ((*in1_)) * ((ik_ - 1) + ((*idl1_)) * ((j_ - 1)))];
      }
    }
  }
  if ((*ido_) < (*l1_)) {
    goto _l132;
  }
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 1; i_ <= (*ido_); (i_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
      }
    }
  }
  goto _l135;
  _l132:;
  for (i_ = 1; i_ <= (*ido_); (i_)++) {
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
      }
    }
  }
  _l135:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      m2_ = m2s_;
      for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
        m2_ = m2_ + (*im2_);
        cc_[m1_ - 1 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
        ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        cc_[m1_ - 1 + ((*in1_)) * ((0) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * ((0) 
        + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
      }
    }
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  if (nbd_ < (*l1_)) {
    goto _l141;
  }
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (k_ = 1; k_ <= (*l1_); (k_)++) {
      for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
        ic_ = idp2_ - i_;
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
          ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) 
          + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
          ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) 
          + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) 
          * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  goto _l0;
  _l141:;
  for (j_ = 2; j_ <= ipph_; (j_)++) {
    jc_ = ipp2_ - j_;
    j2_ = j_ + j_;
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      for (k_ = 1; k_ <= (*l1_); (k_)++) {
        m2_ = m2s_;
        for (m1_ = 1; ((*im1_) > 0 ? m1_ <= m1d_ : m1_ >= m1d_); m1_ += (*im1_)) {
          m2_ = m2_ + (*im2_);
          cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
          ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) 
          + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + 
          ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1 - 1) 
          + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((j2_ - 1 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) * 
          ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((j_ - 1))))] + ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 
          1) + ((*l1_)) * ((jc_ - 1))))];
          cc_[m1_ - 1 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((j2_ - 2 - 1) + ((*ip_)) * ((k_ - 1))))] = ch_[m2_ - 1 + ((*in2_)) 
          * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((jc_ - 1))))] - ch_[m2_ - 1 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * 
          ((k_ - 1) + ((*l1_)) * ((j_ - 1))))];
        }
      }
    }
  }
  _l0:;
  __calls[175].calls++;
  return 0;
}

int_4 _mrftb1 (int_4 _p_ m_, int_4 _p_ im_, int_4 _p_ n_, int_4 _p_ in_, real_4 _p_ c_, real_4 _p_ ch_, real_4 _p_ wa_, 
real_4 _p_ fac_)
{
  static int_4 nf_, na_, k1_, ip_, modn_, nl_, m2_, i_, j_, l1_, iw_, l2_, ido_, idl1_, ix2_, ix3_, ix4_;
  static real_4 half_, halfm_;
  nf_ = fac_[1];
  na_ = 0;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    na_ = 1 - na_;
    if (ip_ <= 5) {
      goto _l10;
    }
    if (k1_ == nf_) {
      goto _l10;
    }
    na_ = 1 - na_;
    _l10:;
  }
  half_ = .5;
  halfm_ = -.5;
  modn_ = _imod ((*n_), 2);
  nl_ = (*n_) - 2;
  if (modn_ != 0) {
    nl_ = (*n_) - 1;
  }
  if (na_ == 0) {
    goto _l120;
  }
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    ch_[i_ - 1 + ((*m_)) * ((0))] = c_[m2_ - 1 + ((*in_)) * ((0))];
    ch_[i_ - 1 + ((*m_)) * (((*n_) - 1))] = c_[m2_ - 1 + ((*in_)) * (((*n_) - 1))];
  }
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    m2_ = 1 - (*im_);
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      m2_ = m2_ + (*im_);
      ch_[i_ - 1 + ((*m_)) * ((j_ - 1))] = half_ * c_[m2_ - 1 + ((*in_)) * ((j_ - 1))];
      ch_[i_ - 1 + ((*m_)) * ((j_ + 1 - 1))] = halfm_ * c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))];
    }
  }
  goto _l124;
  _l120:;
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    m2_ = 1 - (*im_);
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      m2_ = m2_ + (*im_);
      c_[m2_ - 1 + ((*in_)) * ((j_ - 1))] = half_ * c_[m2_ - 1 + ((*in_)) * ((j_ - 1))];
      c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))] = halfm_ * c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))];
    }
  }
  _l124:;
  l1_ = 1;
  iw_ = 1;
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    l2_ = ip_ * l1_;
    ido_ = (*n_) / l2_;
    idl1_ = ido_ * l1_;
    if (ip_ != 4) {
      goto _l103;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _mradb4 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l102;
    _l101:;
    (void) _mradb4 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    _l102:;
    na_ = 1 - na_;
    goto _l115;
    _l103:;
    if (ip_ != 2) {
      goto _l106;
    }
    if (na_ != 0) {
      goto _l104;
    }
    (void) _mradb2 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1]);
    goto _l105;
    _l104:;
    (void) _mradb2 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1]);
    _l105:;
    na_ = 1 - na_;
    goto _l115;
    _l106:;
    if (ip_ != 3) {
      goto _l109;
    }
    ix2_ = iw_ + ido_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _mradb3 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l108;
    _l107:;
    (void) _mradb3 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    _l108:;
    na_ = 1 - na_;
    goto _l115;
    _l109:;
    if (ip_ != 5) {
      goto _l112;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    ix4_ = ix3_ + ido_;
    if (na_ != 0) {
      goto _l110;
    }
    (void) _mradb5 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ 
    - 1]);
    goto _l111;
    _l110:;
    (void) _mradb5 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ 
    - 1]);
    _l111:;
    na_ = 1 - na_;
    goto _l115;
    _l112:;
    if (na_ != 0) {
      goto _l113;
    }
    (void) _mradbg (m_, &ido_, &ip_, &l1_, &idl1_, c_, c_, c_, im_, in_, ch_, ch_, &_k1, m_, &wa_[iw_ - 1]);
    goto _l114;
    _l113:;
    (void) _mradbg (m_, &ido_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, &_k1, m_, c_, c_, im_, in_, &wa_[iw_ - 1]);
    _l114:;
    if (ido_ == 1) {
      na_ = 1 - na_;
    }
    _l115:;
    l1_ = l2_;
    iw_ = iw_ + (ip_ - 1) * ido_;
  }
  __calls[176].calls++;
  return 0;
}

int_4 _mrftf1 (int_4 _p_ m_, int_4 _p_ im_, int_4 _p_ n_, int_4 _p_ in_, real_4 _p_ c_, real_4 _p_ ch_, real_4 _p_ wa_, 
real_4 _p_ fac_)
{
  static int_4 nf_, na_, l2_, iw_, k1_, kh_, ip_, l1_, ido_, idl1_, ix2_, ix3_, ix4_, modn_, nl_, m2_, i_, j_;
  static real_4 sn_, tsn_, tsnm_;
  nf_ = fac_[1];
  na_ = 1;
  l2_ = (*n_);
  iw_ = (*n_);
  for (k1_ = 1; k1_ <= nf_; (k1_)++) {
    kh_ = nf_ - k1_;
    ip_ = fac_[kh_ + 3 - 1];
    l1_ = l2_ / ip_;
    ido_ = (*n_) / l2_;
    idl1_ = ido_ * l1_;
    iw_ = iw_ - (ip_ - 1) * ido_;
    na_ = 1 - na_;
    if (ip_ != 4) {
      goto _l102;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    if (na_ != 0) {
      goto _l101;
    }
    (void) _mradf4 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l110;
    _l101:;
    (void) _mradf4 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1]);
    goto _l110;
    _l102:;
    if (ip_ != 2) {
      goto _l104;
    }
    if (na_ != 0) {
      goto _l103;
    }
    (void) _mradf2 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1]);
    goto _l110;
    _l103:;
    (void) _mradf2 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1]);
    goto _l110;
    _l104:;
    if (ip_ != 3) {
      goto _l106;
    }
    ix2_ = iw_ + ido_;
    if (na_ != 0) {
      goto _l105;
    }
    (void) _mradf3 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l110;
    _l105:;
    (void) _mradf3 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1]);
    goto _l110;
    _l106:;
    if (ip_ != 5) {
      goto _l108;
    }
    ix2_ = iw_ + ido_;
    ix3_ = ix2_ + ido_;
    ix4_ = ix3_ + ido_;
    if (na_ != 0) {
      goto _l107;
    }
    (void) _mradf5 (m_, &ido_, &l1_, c_, im_, in_, ch_, &_k1, m_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ 
    - 1]);
    goto _l110;
    _l107:;
    (void) _mradf5 (m_, &ido_, &l1_, ch_, &_k1, m_, c_, im_, in_, &wa_[iw_ - 1], &wa_[ix2_ - 1], &wa_[ix3_ - 1], &wa_[ix4_ 
    - 1]);
    goto _l110;
    _l108:;
    if (ido_ == 1) {
      na_ = 1 - na_;
    }
    if (na_ != 0) {
      goto _l109;
    }
    (void) _mradfg (m_, &ido_, &ip_, &l1_, &idl1_, c_, c_, c_, im_, in_, ch_, ch_, &_k1, m_, &wa_[iw_ - 1]);
    na_ = 1;
    goto _l110;
    _l109:;
    (void) _mradfg (m_, &ido_, &ip_, &l1_, &idl1_, ch_, ch_, ch_, &_k1, m_, c_, c_, im_, in_, &wa_[iw_ - 1]);
    na_ = 0;
    _l110:;
    l2_ = l1_;
  }
  sn_ = 1.0 / (*n_);
  tsn_ = 2.0 / (*n_);
  tsnm_ = -tsn_;
  modn_ = _imod ((*n_), 2);
  nl_ = (*n_) - 2;
  if (modn_ != 0) {
    nl_ = (*n_) - 1;
  }
  if (na_ != 0) {
    goto _l120;
  }
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    c_[m2_ - 1 + ((*in_)) * ((0))] = sn_ * ch_[i_ - 1 + ((*m_)) * ((0))];
  }
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    m2_ = 1 - (*im_);
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      m2_ = m2_ + (*im_);
      c_[m2_ - 1 + ((*in_)) * ((j_ - 1))] = tsn_ * ch_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))] = tsnm_ * ch_[i_ - 1 + ((*m_)) * ((j_ + 1 - 1))];
    }
  }
  if (modn_ != 0) {
    goto _l0;
  }
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    c_[m2_ - 1 + ((*in_)) * (((*n_) - 1))] = sn_ * ch_[i_ - 1 + ((*m_)) * (((*n_) - 1))];
  }
  goto _l0;
  _l120:;
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    c_[m2_ - 1 + ((*in_)) * ((0))] = sn_ * c_[m2_ - 1 + ((*in_)) * ((0))];
  }
  for (j_ = 2; (2 > 0 ? j_ <= nl_ : j_ >= nl_); j_ += 2) {
    m2_ = 1 - (*im_);
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      m2_ = m2_ + (*im_);
      c_[m2_ - 1 + ((*in_)) * ((j_ - 1))] = tsn_ * c_[m2_ - 1 + ((*in_)) * ((j_ - 1))];
      c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))] = tsnm_ * c_[m2_ - 1 + ((*in_)) * ((j_ + 1 - 1))];
    }
  }
  if (modn_ != 0) {
    goto _l0;
  }
  m2_ = 1 - (*im_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    m2_ = m2_ + (*im_);
    c_[m2_ - 1 + ((*in_)) * (((*n_) - 1))] = sn_ * c_[m2_ - 1 + ((*in_)) * (((*n_) - 1))];
  }
  _l0:;
  __calls[177].calls++;
  return 0;
}

int_4 _mrfti1 (int_4 _p_ n_, real_4 _p_ wa_, real_4 _p_ fac_)
{
  static int_4 ntryh_[4], nl_, nf_, j_, ntry_, nq_, nr_, i_, ib_, is_, nfm1_, l1_, k1_, ip_, ld_, l2_, ido_, ipm_, ii_;
  static real_4 fi_;
  static real_8 tpi_, argh_, argld_, arg_;
  int_4 _data_k_20, $0_, $1_;
#define _data_n_20 4
  static int_4 _data_l_20[_data_n_20] = {
    4,
    2,
    3,
    5
  };
  if (__calls[178].calls == 0) {
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ntryh_[0] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ntryh_[1] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ntryh_[2] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ntryh_[3] = _data_l_20[_data_k_20++];
  }
  nl_ = (*n_);
  nf_ = 0;
  j_ = 0;
  _l101:;
  j_ = j_ + 1;
  $0_ = j_ - 4;
  if ($0_ < 0) {
    goto _l102;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ntry_ = ntryh_[j_ - 1];
  goto _l104;
  _l103:;
  ntry_ = ntry_ + 2;
  _l104:;
  nq_ = nl_ / ntry_;
  nr_ = nl_ - ntry_ * nq_;
  $1_ = nr_;
  if ($1_ < 0) {
    goto _l101;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  nf_ = nf_ + 1;
  fac_[nf_ + 2 - 1] = ntry_;
  nl_ = nq_;
  if (ntry_ != 2) {
    goto _l107;
  }
  if (nf_ == 1) {
    goto _l107;
  }
  for (i_ = 2; i_ <= nf_; (i_)++) {
    ib_ = nf_ - i_ + 2;
    fac_[ib_ + 2 - 1] = fac_[ib_ + 1 - 1];
  }
  fac_[2] = 2;
  _l107:;
  if (nl_ != 1) {
    goto _l104;
  }
  fac_[0] = (*n_);
  fac_[1] = nf_;
  tpi_ = 6.2831853071795865;
  argh_ = tpi_ / (real_4) ((*n_));
  is_ = 0;
  nfm1_ = nf_ - 1;
  l1_ = 1;
  if (nfm1_ == 0) {
    goto _l0;
  }
  for (k1_ = 1; k1_ <= nfm1_; (k1_)++) {
    ip_ = fac_[k1_ + 2 - 1];
    ld_ = 0;
    l2_ = l1_ * ip_;
    ido_ = (*n_) / l2_;
    ipm_ = ip_ - 1;
    for (j_ = 1; j_ <= ipm_; (j_)++) {
      ld_ = ld_ + l1_;
      i_ = is_;
      argld_ = (real_4) (ld_) * argh_;
      fi_ = 0.0;
      for (ii_ = 3; (2 > 0 ? ii_ <= ido_ : ii_ >= ido_); ii_ += 2) {
        i_ = i_ + 2;
        fi_ = fi_ + 1.0;
        arg_ = fi_ * argld_;
        wa_[i_ - 1 - 1] = cos (arg_);
        wa_[i_ - 1] = sin (arg_);
      }
      is_ = is_ + ido_;
    }
    l1_ = l2_;
  }
  _l0:;
  __calls[178].calls++;
  return 0;
}

int_4 _msntb1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_8 
_p_ dsum_, real_4 _p_ xh_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, np1_, ns2_, k_, kc_, m1_, modn_, lnxh_, lnsv_, lnwk_, ier1_, i_;
  static real_4 srt3s2_, xhold_, t1_, t2_, fnp1s4_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l200;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  srt3s2_ = 0.8660254;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    xhold_ = srt3s2_ * (x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((1))] = srt3s2_ * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = xhold_;
  }
  goto _l200;
  _l103:;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      t1_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      t2_ = wsave_[k_ - 1] * (x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))]);
      xh_[m1_ - 1 + ((*lot_)) * ((k_ + 1 - 1))] = t1_ + t2_;
      xh_[m1_ - 1 + ((*lot_)) * ((kc_ + 1 - 1))] = t2_ - t1_;
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    xh_[m1_ - 1 + ((*lot_)) * ((ns2_ + 2 - 1))] = 4.0 * x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))];
  }
  _l124:;
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    xh_[m_ - 1 + ((*lot_)) * ((0))] = 0.0;
  }
  lnxh_ = (*lot_) - 1 + (*lot_) * (np1_ - 1) + 1;
  lnsv_ = np1_ + (int_4) (_aintd (logf ((real_4) (np1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * np1_;
  (void) _rfftmf (lot_, &_k1, &np1_, lot_, xh_, &lnxh_, &wsave_[ns2_ + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_90, ($1_ = -5, &$1_));
    goto _l200;
  }
  if (_imod (np1_, 2) != 0) {
    goto _l30;
  }
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    xh_[m_ - 1 + ((*lot_)) * ((np1_ - 1))] = xh_[m_ - 1 + ((*lot_)) * ((np1_ - 1))] + xh_[m_ - 1 + ((*lot_)) * ((np1_ - 
    1))];
  }
  _l30:;
  fnp1s4_ = (real_4) (np1_) / 4.0;
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * ((0))] = fnp1s4_ * xh_[m1_ - 1 + ((*lot_)) * ((0))];
    dsum_[m1_ - 1] = x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = fnp1s4_ * xh_[m1_ - 1 + ((*lot_)) * ((i_ - 1))];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + fnp1s4_ * xh_[m1_ - 1 + ((*lot_)) * ((i_ - 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = dsum_[m1_ - 1];
    }
  }
  if (modn_ != 0) {
    goto _l200;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = fnp1s4_ * xh_[m1_ - 1 + ((*lot_)) * (((*n_) + 1 - 1))];
  }
  _l200:;
  __calls[179].calls++;
  return 0;
}

int_4 _msntf1 (int_4 _p_ lot_, int_4 _p_ jump_, int_4 _p_ n_, int_4 _p_ inc_, real_4 _p_ x_, real_4 _p_ wsave_, real_8 
_p_ dsum_, real_4 _p_ xh_, real_4 _p_ work_, int_4 _p_ ier_)
{
  static int_4 lj_, m_, np1_, ns2_, k_, kc_, m1_, modn_, lnxh_, lnsv_, lnwk_, ier1_, i_;
  static real_4 ssqrt3_, xhold_, t1_, t2_, sfnp1_;
  int_4 $0_, $1_;
  (*ier_) = 0;
  lj_ = ((*lot_) - 1) * (*jump_) + 1;
  $0_ = (*n_) - 2;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l103;
  }
  _l102:;
  ssqrt3_ = 5.7735027e-1;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    xhold_ = ssqrt3_ * (x_[m_ - 1 + ((*inc_)) * ((0))] + x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((1))] = ssqrt3_ * (x_[m_ - 1 + ((*inc_)) * ((0))] - x_[m_ - 1 + ((*inc_)) * ((1))]);
    x_[m_ - 1 + ((*inc_)) * ((0))] = xhold_;
  }
  _l101:;
  goto _l200;
  _l103:;
  np1_ = (*n_) + 1;
  ns2_ = (*n_) / 2;
  for (k_ = 1; k_ <= ns2_; (k_)++) {
    kc_ = np1_ - k_;
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      t1_ = x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] - x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))];
      t2_ = wsave_[k_ - 1] * (x_[m_ - 1 + ((*inc_)) * ((k_ - 1))] + x_[m_ - 1 + ((*inc_)) * ((kc_ - 1))]);
      xh_[m1_ - 1 + ((*lot_)) * ((k_ + 1 - 1))] = t1_ + t2_;
      xh_[m1_ - 1 + ((*lot_)) * ((kc_ + 1 - 1))] = t2_ - t1_;
    }
  }
  modn_ = _imod ((*n_), 2);
  if (modn_ == 0) {
    goto _l124;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    xh_[m1_ - 1 + ((*lot_)) * ((ns2_ + 2 - 1))] = 4.0 * x_[m_ - 1 + ((*inc_)) * ((ns2_ + 1 - 1))];
  }
  _l124:;
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    xh_[m_ - 1 + ((*lot_)) * ((0))] = 0.0;
  }
  lnxh_ = (*lot_) - 1 + (*lot_) * (np1_ - 1) + 1;
  lnsv_ = np1_ + (int_4) (_aintd (logf ((real_4) (np1_)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 4;
  lnwk_ = (*lot_) * np1_;
  (void) _rfftmf (lot_, &_k1, &np1_, lot_, xh_, &lnxh_, &wsave_[ns2_ + 1 - 1], &lnsv_, work_, &lnwk_, &ier1_);
  if (ier1_ != 0) {
    (*ier_) = 20;
    (void) _xerfft (_dc_91, ($1_ = -5, &$1_));
    goto _l200;
  }
  if (_imod (np1_, 2) != 0) {
    goto _l30;
  }
  for (m_ = 1; m_ <= (*lot_); (m_)++) {
    xh_[m_ - 1 + ((*lot_)) * ((np1_ - 1))] = xh_[m_ - 1 + ((*lot_)) * ((np1_ - 1))] + xh_[m_ - 1 + ((*lot_)) * ((np1_ - 
    1))];
  }
  _l30:;
  sfnp1_ = 1.0 / (real_4) (np1_);
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * ((0))] = .5 * xh_[m1_ - 1 + ((*lot_)) * ((0))];
    dsum_[m1_ - 1] = x_[m_ - 1 + ((*inc_)) * ((0))];
  }
  for (i_ = 3; (2 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += 2) {
    m1_ = 0;
    for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
      m1_ = m1_ + 1;
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1 - 1))] = .5 * xh_[m1_ - 1 + ((*lot_)) * ((i_ - 1))];
      dsum_[m1_ - 1] = dsum_[m1_ - 1] + .5 * xh_[m1_ - 1 + ((*lot_)) * ((i_ - 1 - 1))];
      x_[m_ - 1 + ((*inc_)) * ((i_ - 1))] = dsum_[m1_ - 1];
    }
  }
  if (modn_ != 0) {
    goto _l200;
  }
  m1_ = 0;
  for (m_ = 1; ((*jump_) > 0 ? m_ <= lj_ : m_ >= lj_); m_ += (*jump_)) {
    m1_ = m1_ + 1;
    x_[m_ - 1 + ((*inc_)) * (((*n_) - 1))] = .5 * xh_[m1_ - 1 + ((*lot_)) * (((*n_) + 1 - 1))];
  }
  _l200:;
  __calls[180].calls++;
  return 0;
}

int_4 _r1f2kb (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, real_4 
_p_ wa1_)
{
  static int_4 k_, idp2_, i_, ic_;
  int_4 $0_;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (2) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))];
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))];
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) 
      * ((0) + (2) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))];
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * (cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) 
      * ((k_ - 1))))]) - wa1_[i_ - 1 - 1] * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * (cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 
      1))))]) + wa1_[i_ - 1 - 1] * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
    ((*ido_)) * ((0) + (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = -(cc_[0 + ((*in1_)) * ((0) + 
    ((*ido_)) * ((1) + (2) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))]);
  }
  _l107:;
  _l0:;
  __calls[181].calls++;
  return 0;
}

int_4 _r1f2kf (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, real_4 
_p_ wa1_)
{
  static int_4 k_, idp2_, i_, ic_;
  int_4 $0_;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((0))))] + cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((0))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))];
  }
  $0_ = (*ido_) - 2;
  if ($0_ < 0) {
    goto _l107;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]);
      ch_[0 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))]) - cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]);
      ch_[0 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]);
    }
  }
  if (_imod ((*ido_), 2) == 1) {
    goto _l0;
  }
  _l105:;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((1) + (2) * ((k_ - 1))))] = -cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((1))))];
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((0) + (2) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * (((*ido_) - 1) + 
    ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))];
  }
  _l107:;
  _l0:;
  __calls[182].calls++;
  return 0;
}

int_4 _r1f3kb (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, real_4 
_p_ wa1_, real_4 _p_ wa2_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_4 arg_, taur_, taui_;
  arg_ = 2.0943951;
  taur_ = cosf (arg_);
  taui_ = sinf (arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (3) * ((k_ - 1))))] + 2.0 * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (3) * ((k_ - 1))))] + (2.0 * taur_) * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] - 
    (2.0 * taui_) * cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))];
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((0) + 
    (3) * ((k_ - 1))))] + (2.0 * taur_) * cc_[0 + ((*in1_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] + 2.0 
    * taui_ * cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))];
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + 
      cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) 
      * ((0) + (3) * ((k_ - 1))))] + (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + 
      ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))]);
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) 
      - (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) - wa1_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) 
      * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * 
      ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) 
      + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] = wa1_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * 
      ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + (taui_ * (cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) 
      * ((k_ - 1))))]))) + wa1_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + 
      taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ 
      - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) 
      + (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + 
      ((*ido_)) * ((1) + (3) * ((k_ - 1))))]))) - wa2_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) 
      * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * 
      ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) 
      + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] = wa2_[i_ - 2 - 1] * ((cc_[0 + ((*in1_)) * 
      ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * 
      ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) - (taui_ * (cc_[0 + ((*in1_)) 
      * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] - cc_[0 + ((*in1_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) 
      * ((k_ - 1))))]))) + wa2_[i_ - 1 - 1] * ((cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] + 
      taur_ * (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1 - 
      1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])) + (taui_ * (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ 
      - 1))))] + cc_[0 + ((*in1_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))])));
    }
  }
  _l0:;
  __calls[183].calls++;
  return 0;
}

int_4 _r1f3kf (int_4 _p_ ido_, int_4 _p_ l1_, real_4 _p_ cc_, int_4 _p_ in1_, real_4 _p_ ch_, int_4 _p_ in2_, real_4 
_p_ wa1_, real_4 _p_ wa2_)
{
  static int_4 k_, idp2_, i_, ic_;
  static real_4 arg_, taur_, taui_;
  arg_ = 2.0943951;
  taur_ = cosf (arg_);
  taui_ = sinf (arg_);
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + 
    ((*l1_)) * ((0))))] + (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + cc_[0 + ((*in1_)) * 
    ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
    ch_[0 + ((*in2_)) * ((0) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = taui_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((2))))] - cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]);
    ch_[0 + ((*in2_)) * (((*ido_) - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * 
    ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * (cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + 
    cc_[0 + ((*in1_)) * ((0) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]);
  }
  if ((*ido_) == 1) {
    goto _l0;
  }
  idp2_ = (*ido_) + 2;
  for (k_ = 1; k_ <= (*l1_); (k_)++) {
    for (i_ = 3; (2 > 0 ? i_ <= (*ido_) : i_ >= (*ido_)); i_ += 2) {
      ic_ = idp2_ - i_;
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ 
      - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + 
      wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((0) + (3) * ((k_ - 1))))] = cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) 
      * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) + 
      (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]));
      ch_[0 + ((*in2_)) * ((i_ - 1 - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) 
      + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]))) + (taui_ * 
      ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa2_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
      ch_[0 + ((*in2_)) * ((ic_ - 1 - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + 
      ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) 
      + ((*l1_)) * ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]))) - (taui_ * 
      ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * 
      cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))]) - (wa2_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))])));
      ch_[0 + ((*in2_)) * ((i_ - 1) + ((*ido_)) * ((2) + (3) * ((k_ - 1))))] = (cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((0))))] + taur_ * ((wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + 
      ((*l1_)) * ((1))))] - wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * 
      ((1))))]) + (wa2_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] - wa2_[i_ - 
      1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]))) + (taui_ * ((wa2_[i_ - 2 - 
      1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 
      - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))])));
      ch_[0 + ((*in2_)) * ((ic_ - 1) + ((*ido_)) * ((1) + (3) * ((k_ - 1))))] = (taui_ * ((wa2_[i_ - 2 - 1] * cc_[0 + 
      ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))] + wa2_[i_ - 1 - 1] * cc_[0 + ((*in1_)) * ((i_ - 
      1) + ((*ido_)) * ((k_ - 1) + ((*l1_)) * ((2))))]) - (wa1_[i_ - 2 - 1] * cc_[0 + ((*in1_)) * ((i_ - 1 - 1) + ((*ido_)) * 
      ((k_ - 1) + ((*l1_)) * ((1))))] + wa1_[i