//! @file mathlib-fishpack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 19 subprograms from FISHPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// BLKTRI CMGNBN HSTCRT HSTCYL HSTSSP HWSCRT HWSCYL HWSSSP POISTG SEPX4
// CBLKTR GENBUN HSTCSP HSTPLR HW3CRT HWSCSP HWSPLR POIS3D SEPELI

// FISHPACK routines from SLATEC.
// 
// Source: netlib.org/slatec/

// The license for FISHPACK Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
static FORMAT *__fmt_a = NULL;
#define __ncalls 20
static CALLS __calls[__ncalls] = {
  {"blktri", 0}, // subroutine
  {"cblktr", 0}, // subroutine
  {"cmgnbn", 0}, // subroutine
  {"genbun", 0}, // subroutine
  {"hstcrt", 0}, // subroutine
  {"hstcsp", 0}, // subroutine
  {"hstcyl", 0}, // subroutine
  {"hstplr", 0}, // subroutine
  {"hstssp", 0}, // subroutine
  {"hw3crt", 0}, // subroutine
  {"hwscrt", 0}, // subroutine
  {"hwscsp", 0}, // subroutine
  {"hwscyl", 0}, // subroutine
  {"hwsplr", 0}, // subroutine
  {"hwsssp", 0}, // subroutine
  {"pois3d", 0}, // subroutine
  {"poistg", 0}, // subroutine
  {"sepeli", 0}, // subroutine
  {"sepx4", 0}, // subroutine
  {NULL, 0}
};

static struct {
  int_4 npp_, k_, nm_, ncmplx_, ik_;
  real_4 eps_, cnv_;
} cblkt_;
static struct {
  int_4 npp_, k_, nm_, ncmplx_, ik_;
  real_4 eps_, cnv_;
} ccblk_;
prototype int_4 _blktri (int_4 _p_ iflg_, int_4 _p_ np_, int_4 _p_ n_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, 
int_4 _p_ mp_, int_4 _p_ m_, real_4 _p_ am_, real_4 _p_ bm_, real_4 _p_ cm_, int_4 _p_ idimy_, real_4 _p_ y_, int_4 _p_ 
ierror_, real_4 _p_ w_);
prototype int_4 _cblktr (int_4 _p_ iflg_, int_4 _p_ np_, int_4 _p_ n_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, 
int_4 _p_ mp_, int_4 _p_ m_, complex_8 _p_ am_, complex_8 _p_ bm_, complex_8 _p_ cm_, int_4 _p_ idimy_, complex_8 _p_ 
y_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _cmgnbn (int_4 _p_ nperod_, int_4 _p_ n_, int_4 _p_ mperod_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 
_p_ b_, complex_8 _p_ c_, int_4 _p_ idimy_, complex_8 _p_ y_, int_4 _p_ ierror_, complex_8 _p_ w_);
prototype int_4 _genbun (int_4 _p_ nperod_, int_4 _p_ n_, int_4 _p_ mperod_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_
, real_4 _p_ c_, int_4 _p_ idimy_, real_4 _p_ y_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hstcrt (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ 
bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hstcsp (int_4 _p_ intl_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ 
bda_, real_4 _p_ bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, 
real_4 _p_ elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hstcyl (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ 
bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hstplr (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ 
bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hstssp (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ 
bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hw3crt (real_4 _p_ xs_, real_4 _p_ xf_, int_4 _p_ l_, int_4 _p_ lbdcnd_, real_4 _p_ bdxs_, real_4 _p_ 
bdxf_, real_4 _p_ ys_, real_4 _p_ yf_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bdys_, real_4 _p_ bdyf_, real_4 _p_ 
zs_, real_4 _p_ zf_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdzs_, real_4 _p_ bdzf_, real_4 _p_ elmbda_, int_4 _p_ 
ldimf_, int_4 _p_ mdimf_, real_4 _p_ f_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hwscrt (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ 
bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hwscsp (int_4 _p_ intl_, real_4 _p_ ts_, real_4 _p_ tf_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ 
bdts_, real_4 _p_ bdtf_, real_4 _p_ rs_, real_4 _p_ rf_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdrs_, real_4 _p_ 
bdrf_, real_4 _p_ elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hwscyl (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ 
bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hwsplr (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ 
bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _hwsssp (real_4 _p_ ts_, real_4 _p_ tf_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bdts_, real_4 _p_ 
bdtf_, real_4 _p_ ps_, real_4 _p_ pf_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdps_, real_4 _p_ bdpf_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _pois3d (int_4 _p_ lperod_, int_4 _p_ l_, real_4 _p_ c1_, int_4 _p_ mperod_, int_4 _p_ m_, real_4 _p_ 
c2_, int_4 _p_ nperod_, int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, int_4 _p_ ldimf_, int_4 _p_ mdimf_, 
real_4 _p_ f_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _poistg (int_4 _p_ nperod_, int_4 _p_ n_, int_4 _p_ mperod_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_
, real_4 _p_ c_, int_4 _p_ idimy_, real_4 _p_ y_, int_4 _p_ ierror_, real_4 _p_ w_);
prototype int_4 _sepeli (int_4 _p_ intl_, int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ 
mbdcnd_, real_4 _p_ bda_, real_4 _p_ alpha_, real_4 _p_ bdb_, real_4 _p_ beta_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ 
n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ gama_, real_4 _p_ bdd_, real_4 _p_ xnu_, real_4 (*_cofx)(), real_4 
(*_cofy)(), real_4 _p_ grhs_, real_4 _p_ usol_, int_4 _p_ idmn_, real_4 _p_ w_, real_4 _p_ pertrb_, int_4 _p_ ierror_);
prototype int_4 _sepx4 (int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ 
bda_, real_4 _p_ alpha_, real_4 _p_ bdb_, real_4 _p_ beta_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ 
nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 (*_cofx)(), real_4 _p_ grhs_, real_4 _p_ usol_, int_4 _p_ idmn_, 
real_4 _p_ w_, real_4 _p_ pertrb_, int_4 _p_ ierror_);
int_4 _blktri (int_4 _p_ iflg_, int_4 _p_ np_, int_4 _p_ n_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, int_4 _p_ 
mp_, int_4 _p_ m_, real_4 _p_ am_, real_4 _p_ bm_, real_4 _p_ cm_, int_4 _p_ idimy_, real_4 _p_ y_, int_4 _p_ ierror_, 
real_4 _p_ w_)
{
  static int_4 nh_, nl_, iwah_, iw1_, iwbh_, iw2_, iw3_, iwd_, iww_, iwu_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern real_4 _prod ();
  extern real_4 _prodp ();
  extern real_4 _cprod ();
  extern real_4 _cprodp ();
  cblkt_.nm_ = (*n_);
  (*ierror_) = 0;
  $0_ = (*m_) - 5;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l102;
  }
  _l101:;
  (*ierror_) = 1;
  goto _l119;
  _l102:;
  $1_ = cblkt_.nm_ - 3;
  if ($1_ < 0) {
    goto _l103;
  } else if ($1_ == 0) {
    goto _l104;
  } else {
    goto _l104;
  }
  _l103:;
  (*ierror_) = 2;
  goto _l119;
  _l104:;
  $2_ = (*idimy_) - (*m_);
  if ($2_ < 0) {
    goto _l105;
  } else if ($2_ == 0) {
    goto _l106;
  } else {
    goto _l106;
  }
  _l105:;
  (*ierror_) = 3;
  goto _l119;
  _l106:;
  nh_ = (*n_);
  cblkt_.npp_ = (*np_);
  $3_ = cblkt_.npp_;
  if ($3_ < 0) {
    goto _l107;
  } else if ($3_ == 0) {
    goto _l108;
  } else {
    goto _l107;
  }
  _l107:;
  nh_ = nh_ + 1;
  _l108:;
  cblkt_.ik_ = 2;
  cblkt_.k_ = 1;
  _l109:;
  cblkt_.ik_ = cblkt_.ik_ + cblkt_.ik_;
  cblkt_.k_ = cblkt_.k_ + 1;
  $4_ = nh_ - cblkt_.ik_;
  if ($4_ < 0) {
    goto _l110;
  } else if ($4_ == 0) {
    goto _l110;
  } else {
    goto _l109;
  }
  _l110:;
  nl_ = cblkt_.ik_;
  cblkt_.ik_ = cblkt_.ik_ + cblkt_.ik_;
  nl_ = nl_ - 1;
  iwah_ = (cblkt_.k_ - 2) * cblkt_.ik_ + cblkt_.k_ + 6;
  $5_ = cblkt_.npp_;
  if ($5_ < 0) {
    goto _l111;
  } else if ($5_ == 0) {
    goto _l112;
  } else {
    goto _l111;
  }
  _l111:;
  iw1_ = iwah_;
  iwbh_ = iw1_ + cblkt_.nm_;
  w_[0] = iw1_ - 1 + _max (2 * cblkt_.nm_, 6 * (*m_));
  goto _l113;
  _l112:;
  iwbh_ = iwah_ + cblkt_.nm_ + cblkt_.nm_;
  iw1_ = iwbh_;
  w_[0] = iw1_ - 1 + _max (2 * cblkt_.nm_, 6 * (*m_));
  cblkt_.nm_ = cblkt_.nm_ - 1;
  _l113:;
  $6_ = (*ierror_);
  if ($6_ < 0) {
    goto _l119;
  } else if ($6_ == 0) {
    goto _l114;
  } else {
    goto _l119;
  }
  _l114:;
  iw2_ = iw1_ + (*m_);
  iw3_ = iw2_ + (*m_);
  iwd_ = iw3_ + (*m_);
  iww_ = iwd_ + (*m_);
  iwu_ = iww_ + (*m_);
  $7_ = (*iflg_);
  if ($7_ < 0) {
    goto _l116;
  } else if ($7_ == 0) {
    goto _l115;
  } else {
    goto _l116;
  }
  _l115:;
  (void) _compb (&nl_, ierror_, an_, bn_, cn_, &w_[1], &w_[iwah_ - 1], &w_[iwbh_ - 1]);
  goto _l119;
  _l116:;
  $8_ = (*mp_);
  if ($8_ < 0) {
    goto _l117;
  } else if ($8_ == 0) {
    goto _l118;
  } else {
    goto _l117;
  }
  _l117:;
  (void) _blktr1 (&nl_, an_, bn_, cn_, m_, am_, bm_, cm_, idimy_, y_, &w_[1], &w_[iw1_ - 1], &w_[iw2_ - 1], &w_[iw3_ - 
  1], &w_[iwd_ - 1], &w_[iww_ - 1], &w_[iwu_ - 1], _prod, _cprod);
  goto _l119;
  _l118:;
  (void) _blktr1 (&nl_, an_, bn_, cn_, m_, am_, bm_, cm_, idimy_, y_, &w_[1], &w_[iw1_ - 1], &w_[iw2_ - 1], &w_[iw3_ - 
  1], &w_[iwd_ - 1], &w_[iww_ - 1], &w_[iwu_ - 1], _prodp, _cprodp);
  _l119:;
  __calls[0].calls++;
  return 0;
}

int_4 _cblktr (int_4 _p_ iflg_, int_4 _p_ np_, int_4 _p_ n_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, int_4 _p_ 
mp_, int_4 _p_ m_, complex_8 _p_ am_, complex_8 _p_ bm_, complex_8 _p_ cm_, int_4 _p_ idimy_, complex_8 _p_ y_, int_4 
_p_ ierror_, real_4 _p_ w_)
{
  static int_4 m2_, nh_, nl_, iwah_, iw1_, iwbh_, iw2_, iw3_, iwd_, iww_, iwu_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern real_4 _proc ();
  extern real_4 _procp ();
  extern real_4 _cproc ();
  extern real_4 _cprocp ();
  ccblk_.nm_ = (*n_);
  m2_ = (*m_) + (*m_);
  (*ierror_) = 0;
  $0_ = (*m_) - 5;
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l102;
  } else {
    goto _l102;
  }
  _l101:;
  (*ierror_) = 1;
  goto _l119;
  _l102:;
  $1_ = ccblk_.nm_ - 3;
  if ($1_ < 0) {
    goto _l103;
  } else if ($1_ == 0) {
    goto _l104;
  } else {
    goto _l104;
  }
  _l103:;
  (*ierror_) = 2;
  goto _l119;
  _l104:;
  $2_ = (*idimy_) - (*m_);
  if ($2_ < 0) {
    goto _l105;
  } else if ($2_ == 0) {
    goto _l106;
  } else {
    goto _l106;
  }
  _l105:;
  (*ierror_) = 3;
  goto _l119;
  _l106:;
  nh_ = (*n_);
  ccblk_.npp_ = (*np_);
  $3_ = ccblk_.npp_;
  if ($3_ < 0) {
    goto _l107;
  } else if ($3_ == 0) {
    goto _l108;
  } else {
    goto _l107;
  }
  _l107:;
  nh_ = nh_ + 1;
  _l108:;
  ccblk_.ik_ = 2;
  ccblk_.k_ = 1;
  _l109:;
  ccblk_.ik_ = ccblk_.ik_ + ccblk_.ik_;
  ccblk_.k_ = ccblk_.k_ + 1;
  $4_ = nh_ - ccblk_.ik_;
  if ($4_ < 0) {
    goto _l110;
  } else if ($4_ == 0) {
    goto _l110;
  } else {
    goto _l109;
  }
  _l110:;
  nl_ = ccblk_.ik_;
  ccblk_.ik_ = ccblk_.ik_ + ccblk_.ik_;
  nl_ = nl_ - 1;
  iwah_ = (ccblk_.k_ - 2) * ccblk_.ik_ + ccblk_.k_ + 6;
  $5_ = ccblk_.npp_;
  if ($5_ < 0) {
    goto _l111;
  } else if ($5_ == 0) {
    goto _l112;
  } else {
    goto _l111;
  }
  _l111:;
  iw1_ = iwah_;
  iwbh_ = iw1_ + ccblk_.nm_;
  w_[0] = iw1_ - 1 + _max (2 * ccblk_.nm_, 12 * (*m_));
  goto _l113;
  _l112:;
  iwbh_ = iwah_ + ccblk_.nm_ + ccblk_.nm_;
  iw1_ = iwbh_;
  w_[0] = iw1_ - 1 + _max (2 * ccblk_.nm_, 12 * (*m_));
  ccblk_.nm_ = ccblk_.nm_ - 1;
  _l113:;
  $6_ = (*ierror_);
  if ($6_ < 0) {
    goto _l119;
  } else if ($6_ == 0) {
    goto _l114;
  } else {
    goto _l119;
  }
  _l114:;
  iw2_ = iw1_ + m2_;
  iw3_ = iw2_ + m2_;
  iwd_ = iw3_ + m2_;
  iww_ = iwd_ + m2_;
  iwu_ = iww_ + m2_;
  $7_ = (*iflg_);
  if ($7_ < 0) {
    goto _l116;
  } else if ($7_ == 0) {
    goto _l115;
  } else {
    goto _l116;
  }
  _l115:;
  (void) _ccmpb (&nl_, ierror_, an_, bn_, cn_, &w_[1], &w_[iwah_ - 1], &w_[iwbh_ - 1]);
  goto _l119;
  _l116:;
  $8_ = (*mp_);
  if ($8_ < 0) {
    goto _l117;
  } else if ($8_ == 0) {
    goto _l118;
  } else {
    goto _l117;
  }
  _l117:;
  (void) _cblkt1 (&nl_, an_, bn_, cn_, m_, am_, bm_, cm_, idimy_, y_, &w_[1], &w_[iw1_ - 1], &w_[iw2_ - 1], &w_[iw3_ - 
  1], &w_[iwd_ - 1], &w_[iww_ - 1], &w_[iwu_ - 1], _proc, _cproc);
  goto _l119;
  _l118:;
  (void) _cblkt1 (&nl_, an_, bn_, cn_, m_, am_, bm_, cm_, idimy_, y_, &w_[1], &w_[iw1_ - 1], &w_[iw2_ - 1], &w_[iw3_ - 
  1], &w_[iwd_ - 1], &w_[iww_ - 1], &w_[iwu_ - 1], _procp, _cprocp);
  _l119:;
  __calls[1].calls++;
  return 0;
}

int_4 _cmgnbn (int_4 _p_ nperod_, int_4 _p_ n_, int_4 _p_ mperod_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, 
complex_8 _p_ c_, int_4 _p_ idimy_, complex_8 _p_ y_, int_4 _p_ ierror_, complex_8 _p_ w_)
{
  static int_4 i_, iwba_, iwbb_, iwbc_, iwb2_, iwb3_, iww1_, iww2_, iww3_, iwd_, iwtcos_, iwp_, k_, j_, mp_, np_, ipstor_
  , irev_, mh_, mhm1_, modd_, mhpi_, mhmi_, nby2_, mskip_;
  static complex_8 a1_;
  int_4 $0_;
  (*ierror_) = 0;
  if ((*m_) <= 2) {
    (*ierror_) = 1;
  }
  if ((*n_) <= 2) {
    (*ierror_) = 2;
  }
  if ((*idimy_) < (*m_)) {
    (*ierror_) = 3;
  }
  if ((*nperod_) < 0 || (*nperod_) > 4) {
    (*ierror_) = 4;
  }
  if ((*mperod_) < 0 || (*mperod_) > 1) {
    (*ierror_) = 5;
  }
  if ((*mperod_) == 1) {
    goto _l102;
  }
  for (i_ = 2; i_ <= (*m_); (i_)++) {
    if (cabsf (a_[i_ - 1] - c_[0]) != 0.0) {
      goto _l103;
    }
    if (cabsf (c_[i_ - 1] - c_[0]) != 0.0) {
      goto _l103;
    }
    if (cabsf (b_[i_ - 1] - b_[0]) != 0.0) {
      goto _l103;
    }
  }
  goto _l104;
  _l102:;
  if (cabsf (a_[0]) != 0.0 && cabsf (c_[(*m_) - 1]) != 0.0) {
    (*ierror_) = 7;
  }
  goto _l104;
  _l103:;
  (*ierror_) = 6;
  _l104:;
  if ((*ierror_) != 0) {
    goto _l0;
  }
  iwba_ = (*m_) + 1;
  iwbb_ = iwba_ + (*m_);
  iwbc_ = iwbb_ + (*m_);
  iwb2_ = iwbc_ + (*m_);
  iwb3_ = iwb2_ + (*m_);
  iww1_ = iwb3_ + (*m_);
  iww2_ = iww1_ + (*m_);
  iww3_ = iww2_ + (*m_);
  iwd_ = iww3_ + (*m_);
  iwtcos_ = iwd_ + (*m_);
  iwp_ = iwtcos_ + 4 * (*n_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    k_ = iwba_ + i_ - 1;
    w_[k_ - 1] = -a_[i_ - 1];
    k_ = iwbc_ + i_ - 1;
    w_[k_ - 1] = -c_[i_ - 1];
    k_ = iwbb_ + i_ - 1;
    w_[k_ - 1] = 2.0 - b_[i_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = -y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))];
    }
  }
  mp_ = (*mperod_) + 1;
  np_ = (*nperod_) + 1;
  switch (mp_) {
    default:
    case 1: goto _l114;
    case 2: goto _l107;
  }
  _l107:;
  switch (np_) {
    default:
    case 1: goto _l108;
    case 2: goto _l109;
    case 3: goto _l110;
    case 4: goto _l111;
    case 5: goto _l123;
  }
  _l108:;
  (void) _cmposp (m_, n_, &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], y_, idimy_, w_, &w_[iwb2_ - 1], &w_[iwb3_ - 1], 
  &w_[iww1_ - 1], &w_[iww2_ - 1], &w_[iww3_ - 1], &w_[iwd_ - 1], &w_[iwtcos_ - 1], &w_[iwp_ - 1]);
  goto _l112;
  _l109:;
  (void) _cmposd (m_, n_, &_k1, &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], y_, idimy_, w_, &w_[iww1_ - 1], &w_[iwd_ 
  - 1], &w_[iwtcos_ - 1], &w_[iwp_ - 1]);
  goto _l112;
  _l110:;
  (void) _cmposn (m_, n_, &_k1, ($0_ = 2, &$0_), &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], y_, idimy_, w_, 
  &w_[iwb2_ - 1], &w_[iwb3_ - 1], &w_[iww1_ - 1], &w_[iww2_ - 1], &w_[iww3_ - 1], &w_[iwd_ - 1], &w_[iwtcos_ - 1], 
  &w_[iwp_ - 1]);
  goto _l112;
  _l111:;
  (void) _cmposn (m_, n_, &_k1, &_k1, &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], y_, idimy_, w_, &w_[iwb2_ - 1], 
  &w_[iwb3_ - 1], &w_[iww1_ - 1], &w_[iww2_ - 1], &w_[iww3_ - 1], &w_[iwd_ - 1], &w_[iwtcos_ - 1], &w_[iwp_ - 1]);
  _l112:;
  ipstor_ = (real_4) (crealf (w_[iww1_ - 1]));
  irev_ = 2;
  if ((*nperod_) == 4) {
    goto _l124;
  }
  _l113:;
  switch (mp_) {
    default:
    case 1: goto _l127;
    case 2: goto _l133;
  }
  _l114:;
  mh_ = ((*m_) + 1) / 2;
  mhm1_ = mh_ - 1;
  modd_ = 1;
  if (mh_ * 2 == (*m_)) {
    modd_ = 2;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= mhm1_; (i_)++) {
      mhpi_ = mh_ + i_;
      mhmi_ = mh_ - i_;
      w_[i_ - 1] = y_[mhmi_ - 1 + ((*idimy_)) * ((j_ - 1))] - y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))];
      w_[mhpi_ - 1] = y_[mhmi_ - 1 + ((*idimy_)) * ((j_ - 1))] + y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))];
    }
    w_[mh_ - 1] = 2.0 * y_[mh_ - 1 + ((*idimy_)) * ((j_ - 1))];
    switch (modd_) {
      default:
      case 1: goto _l117;
      case 2: goto _l116;
    }
    _l116:;
    w_[(*m_) - 1] = 2.0 * y_[(*m_) - 1 + ((*idimy_)) * ((j_ - 1))];
    _l117:;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = w_[i_ - 1];
    }
  }
  k_ = iwbc_ + mhm1_ - 1;
  i_ = iwba_ + mhm1_;
  w_[k_ - 1] = CMPLXF (0.0, 0.0);
  w_[i_ - 1] = CMPLXF (0.0, 0.0);
  w_[k_ + 1 - 1] = 2.0 * w_[k_ + 1 - 1];
  switch (modd_) {
    default:
    case 1: goto _l120;
    case 2: goto _l121;
  }
  _l120:;
  k_ = iwbb_ + mhm1_ - 1;
  w_[k_ - 1] = w_[k_ - 1] - w_[i_ - 1 - 1];
  w_[iwbc_ - 1 - 1] = w_[iwbc_ - 1 - 1] + w_[iwbb_ - 1 - 1];
  goto _l122;
  _l121:;
  w_[iwbb_ - 1 - 1] = w_[k_ + 1 - 1];
  _l122:;
  goto _l107;
  _l123:;
  irev_ = 1;
  nby2_ = (*n_) / 2;
  _l124:;
  for (j_ = 1; j_ <= nby2_; (j_)++) {
    mskip_ = (*n_) + 1 - j_;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      a1_ = y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))];
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = y_[i_ - 1 + ((*idimy_)) * ((mskip_ - 1))];
      y_[i_ - 1 + ((*idimy_)) * ((mskip_ - 1))] = a1_;
    }
  }
  switch (irev_) {
    default:
    case 1: goto _l110;
    case 2: goto _l113;
  }
  _l127:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= mhm1_; (i_)++) {
      mhmi_ = mh_ - i_;
      mhpi_ = mh_ + i_;
      w_[mhmi_ - 1] = .5 * (y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))] + y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))]);
      w_[mhpi_ - 1] = .5 * (y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))] - y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))]);
    }
    w_[mh_ - 1] = .5 * y_[mh_ - 1 + ((*idimy_)) * ((j_ - 1))];
    switch (modd_) {
      default:
      case 1: goto _l130;
      case 2: goto _l129;
    }
    _l129:;
    w_[(*m_) - 1] = .5 * y_[(*m_) - 1 + ((*idimy_)) * ((j_ - 1))];
    _l130:;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = w_[i_ - 1];
    }
  }
  _l133:;
  w_[0] = CMPLXF ((real_4) (ipstor_ + iwp_ - 1), 0.0);
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _genbun (int_4 _p_ nperod_, int_4 _p_ n_, int_4 _p_ mperod_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 
_p_ c_, int_4 _p_ idimy_, real_4 _p_ y_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 i_, mp1_, iwba_, iwbb_, iwbc_, iwb2_, iwb3_, iww1_, iww2_, iww3_, iwd_, iwtcos_, iwp_, k_, j_, mp_, np_, 
  ipstor_, irev_, mh_, mhm1_, modd_, mhpi_, mhmi_, nby2_, mskip_;
  static real_4 a1_;
  int_4 $0_;
  (*ierror_) = 0;
  if ((*m_) <= 2) {
    (*ierror_) = 1;
  }
  if ((*n_) <= 2) {
    (*ierror_) = 2;
  }
  if ((*idimy_) < (*m_)) {
    (*ierror_) = 3;
  }
  if ((*nperod_) < 0 || (*nperod_) > 4) {
    (*ierror_) = 4;
  }
  if ((*mperod_) < 0 || (*mperod_) > 1) {
    (*ierror_) = 5;
  }
  if ((*mperod_) == 1) {
    goto _l102;
  }
  for (i_ = 2; i_ <= (*m_); (i_)++) {
    if (a_[i_ - 1] != c_[0]) {
      goto _l103;
    }
    if (c_[i_ - 1] != c_[0]) {
      goto _l103;
    }
    if (b_[i_ - 1] != b_[0]) {
      goto _l103;
    }
  }
  goto _l104;
  _l102:;
  if (a_[0] != 0.0 || c_[(*m_) - 1] != 0.0) {
    (*ierror_) = 7;
  }
  goto _l104;
  _l103:;
  (*ierror_) = 6;
  _l104:;
  if ((*ierror_) != 0) {
    goto _l0;
  }
  mp1_ = (*m_) + 1;
  iwba_ = mp1_;
  iwbb_ = iwba_ + (*m_);
  iwbc_ = iwbb_ + (*m_);
  iwb2_ = iwbc_ + (*m_);
  iwb3_ = iwb2_ + (*m_);
  iww1_ = iwb3_ + (*m_);
  iww2_ = iww1_ + (*m_);
  iww3_ = iww2_ + (*m_);
  iwd_ = iww3_ + (*m_);
  iwtcos_ = iwd_ + (*m_);
  iwp_ = iwtcos_ + 4 * (*n_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    k_ = iwba_ + i_ - 1;
    w_[k_ - 1] = -a_[i_ - 1];
    k_ = iwbc_ + i_ - 1;
    w_[k_ - 1] = -c_[i_ - 1];
    k_ = iwbb_ + i_ - 1;
    w_[k_ - 1] = 2.0 - b_[i_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = -y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))];
    }
  }
  mp_ = (*mperod_) + 1;
  np_ = (*nperod_) + 1;
  switch (mp_) {
    default:
    case 1: goto _l114;
    case 2: goto _l107;
  }
  _l107:;
  switch (np_) {
    default:
    case 1: goto _l108;
    case 2: goto _l109;
    case 3: goto _l110;
    case 4: goto _l111;
    case 5: goto _l123;
  }
  _l108:;
  (void) _poisp2 (m_, n_, &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], y_, idimy_, w_, &w_[iwb2_ - 1], &w_[iwb3_ - 1], 
  &w_[iww1_ - 1], &w_[iww2_ - 1], &w_[iww3_ - 1], &w_[iwd_ - 1], &w_[iwtcos_ - 1], &w_[iwp_ - 1]);
  goto _l112;
  _l109:;
  (void) _poisd2 (m_, n_, &_k1, &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], y_, idimy_, w_, &w_[iww1_ - 1], &w_[iwd_ 
  - 1], &w_[iwtcos_ - 1], &w_[iwp_ - 1]);
  goto _l112;
  _l110:;
  (void) _poisn2 (m_, n_, &_k1, ($0_ = 2, &$0_), &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], y_, idimy_, w_, 
  &w_[iwb2_ - 1], &w_[iwb3_ - 1], &w_[iww1_ - 1], &w_[iww2_ - 1], &w_[iww3_ - 1], &w_[iwd_ - 1], &w_[iwtcos_ - 1], 
  &w_[iwp_ - 1]);
  goto _l112;
  _l111:;
  (void) _poisn2 (m_, n_, &_k1, &_k1, &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], y_, idimy_, w_, &w_[iwb2_ - 1], 
  &w_[iwb3_ - 1], &w_[iww1_ - 1], &w_[iww2_ - 1], &w_[iww3_ - 1], &w_[iwd_ - 1], &w_[iwtcos_ - 1], &w_[iwp_ - 1]);
  _l112:;
  ipstor_ = w_[iww1_ - 1];
  irev_ = 2;
  if ((*nperod_) == 4) {
    goto _l124;
  }
  _l113:;
  switch (mp_) {
    default:
    case 1: goto _l127;
    case 2: goto _l133;
  }
  _l114:;
  mh_ = ((*m_) + 1) / 2;
  mhm1_ = mh_ - 1;
  modd_ = 1;
  if (mh_ * 2 == (*m_)) {
    modd_ = 2;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= mhm1_; (i_)++) {
      mhpi_ = mh_ + i_;
      mhmi_ = mh_ - i_;
      w_[i_ - 1] = y_[mhmi_ - 1 + ((*idimy_)) * ((j_ - 1))] - y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))];
      w_[mhpi_ - 1] = y_[mhmi_ - 1 + ((*idimy_)) * ((j_ - 1))] + y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))];
    }
    w_[mh_ - 1] = 2.0 * y_[mh_ - 1 + ((*idimy_)) * ((j_ - 1))];
    switch (modd_) {
      default:
      case 1: goto _l117;
      case 2: goto _l116;
    }
    _l116:;
    w_[(*m_) - 1] = 2.0 * y_[(*m_) - 1 + ((*idimy_)) * ((j_ - 1))];
    _l117:;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = w_[i_ - 1];
    }
  }
  k_ = iwbc_ + mhm1_ - 1;
  i_ = iwba_ + mhm1_;
  w_[k_ - 1] = 0.0;
  w_[i_ - 1] = 0.0;
  w_[k_ + 1 - 1] = 2.0 * w_[k_ + 1 - 1];
  switch (modd_) {
    default:
    case 1: goto _l120;
    case 2: goto _l121;
  }
  _l120:;
  k_ = iwbb_ + mhm1_ - 1;
  w_[k_ - 1] = w_[k_ - 1] - w_[i_ - 1 - 1];
  w_[iwbc_ - 1 - 1] = w_[iwbc_ - 1 - 1] + w_[iwbb_ - 1 - 1];
  goto _l122;
  _l121:;
  w_[iwbb_ - 1 - 1] = w_[k_ + 1 - 1];
  _l122:;
  goto _l107;
  _l123:;
  irev_ = 1;
  nby2_ = (*n_) / 2;
  _l124:;
  for (j_ = 1; j_ <= nby2_; (j_)++) {
    mskip_ = (*n_) + 1 - j_;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      a1_ = y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))];
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = y_[i_ - 1 + ((*idimy_)) * ((mskip_ - 1))];
      y_[i_ - 1 + ((*idimy_)) * ((mskip_ - 1))] = a1_;
    }
  }
  switch (irev_) {
    default:
    case 1: goto _l110;
    case 2: goto _l113;
  }
  _l127:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= mhm1_; (i_)++) {
      mhmi_ = mh_ - i_;
      mhpi_ = mh_ + i_;
      w_[mhmi_ - 1] = .5 * (y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))] + y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))]);
      w_[mhpi_ - 1] = .5 * (y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))] - y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))]);
    }
    w_[mh_ - 1] = .5 * y_[mh_ - 1 + ((*idimy_)) * ((j_ - 1))];
    switch (modd_) {
      default:
      case 1: goto _l130;
      case 2: goto _l129;
    }
    _l129:;
    w_[(*m_) - 1] = .5 * y_[(*m_) - 1 + ((*idimy_)) * ((j_ - 1))];
    _l130:;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = w_[i_ - 1];
    }
  }
  _l133:;
  w_[0] = ipstor_ + iwp_ - 1;
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _hstcrt (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ bdb_, real_4 
_p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ elmbda_, real_4 
_p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 nperod_, mperod_, np_, mp_, id2_, id3_, id4_, i_, j_, ierr1_;
  static real_4 deltax_, twdelx_, delxsq_, deltay_, twdely_, delysq_, twdysq_, s_, st2_;
  real_4 $0_, $1_;
  (*ierror_) = 0;
  if ((*a_) >= (*b_)) {
    (*ierror_) = 1;
  }
  if ((*mbdcnd_) < 0 || (*mbdcnd_) > 4) {
    (*ierror_) = 2;
  }
  if ((*c_) >= (*d_)) {
    (*ierror_) = 3;
  }
  if ((*n_) <= 2) {
    (*ierror_) = 4;
  }
  if ((*nbdcnd_) < 0 || (*nbdcnd_) > 4) {
    (*ierror_) = 5;
  }
  if ((*idimf_) < (*m_)) {
    (*ierror_) = 7;
  }
  if ((*m_) <= 2) {
    (*ierror_) = 8;
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  nperod_ = (*nbdcnd_);
  mperod_ = 0;
  if ((*mbdcnd_) > 0) {
    mperod_ = 1;
  }
  deltax_ = ((*b_) - (*a_)) / (*m_);
  twdelx_ = 1.0 / deltax_;
  delxsq_ = 2.0 / (deltax_ * deltax_);
  deltay_ = ((*d_) - (*c_)) / (*n_);
  twdely_ = 1.0 / deltay_;
  delysq_ = (deltay_ * deltay_);
  twdysq_ = 2.0 / delysq_;
  np_ = (*nbdcnd_) + 1;
  mp_ = (*mbdcnd_) + 1;
  id2_ = (*m_);
  id3_ = id2_ + (*m_);
  id4_ = id3_ + (*m_);
  s_ = ($0_ = (deltay_ / deltax_), $0_ * $0_);
  st2_ = 2.0 * s_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    w_[i_ - 1] = s_;
    j_ = id2_ + i_;
    w_[j_ - 1] = -st2_ + (*elmbda_) * delysq_;
    j_ = id3_ + i_;
    w_[j_ - 1] = s_;
  }
  switch (mp_) {
    default:
    case 1: goto _l111;
    case 2: goto _l102;
    case 3: goto _l102;
    case 4: goto _l104;
    case 5: goto _l104;
  }
  _l102:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] - bda_[j_ - 1] * delxsq_;
  }
  w_[id2_ + 1 - 1] = w_[id2_ + 1 - 1] - w_[0];
  goto _l106;
  _l104:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] + bda_[j_ - 1] * twdelx_;
  }
  w_[id2_ + 1 - 1] = w_[id2_ + 1 - 1] + w_[0];
  _l106:;
  switch (mp_) {
    default:
    case 1: goto _l111;
    case 2: goto _l107;
    case 3: goto _l109;
    case 4: goto _l109;
    case 5: goto _l107;
  }
  _l107:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - bdb_[j_ - 1] * delxsq_;
  }
  w_[id3_ - 1] = w_[id3_ - 1] - w_[0];
  goto _l111;
  _l109:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - bdb_[j_ - 1] * twdelx_;
  }
  w_[id3_ - 1] = w_[id3_ - 1] + w_[0];
  _l111:;
  switch (np_) {
    default:
    case 1: goto _l121;
    case 2: goto _l112;
    case 3: goto _l112;
    case 4: goto _l114;
    case 5: goto _l114;
  }
  _l112:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] - bdc_[i_ - 1] * twdysq_;
  }
  goto _l116;
  _l114:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] + bdc_[i_ - 1] * twdely_;
  }
  _l116:;
  switch (np_) {
    default:
    case 1: goto _l121;
    case 2: goto _l117;
    case 3: goto _l119;
    case 4: goto _l119;
    case 5: goto _l117;
  }
  _l117:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - bdd_[i_ - 1] * twdysq_;
  }
  goto _l121;
  _l119:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - bdd_[i_ - 1] * twdely_;
  }
  _l121:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] * delysq_;
    }
  }
  if (mperod_ == 0) {
    goto _l124;
  }
  w_[0] = 0.0;
  w_[id4_ - 1] = 0.0;
  _l124:;
  (*pertrb_) = 0.0;
  $1_ = (*elmbda_);
  if ($1_ < 0) {
    goto _l133;
  } else if ($1_ == 0) {
    goto _l126;
  } else {
    goto _l125;
  }
  _l125:;
  (*ierror_) = 6;
  goto _l133;
  _l126:;
  switch (mp_) {
    default:
    case 1: goto _l127;
    case 2: goto _l133;
    case 3: goto _l133;
    case 4: goto _l127;
    case 5: goto _l133;
  }
  _l127:;
  switch (np_) {
    default:
    case 1: goto _l128;
    case 2: goto _l133;
    case 3: goto _l133;
    case 4: goto _l128;
    case 5: goto _l133;
  }
  _l128:;
  s_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      s_ = s_ + f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
  }
  (*pertrb_) = s_ / ((*m_) * (*n_));
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] - (*pertrb_);
    }
  }
  (*pertrb_) = (*pertrb_) / delysq_;
  _l133:;
  if (nperod_ == 0) {
    goto _l134;
  }
  (void) _poistg (&nperod_, n_, &mperod_, m_, &w_[0], &w_[id2_ + 1 - 1], &w_[id3_ + 1 - 1], idimf_, f_, &ierr1_, &w_[id4_ 
  + 1 - 1]);
  goto _l135;
  _l134:;
  (void) _genbun (&nperod_, n_, &mperod_, m_, &w_[0], &w_[id2_ + 1 - 1], &w_[id3_ + 1 - 1], idimf_, f_, &ierr1_, &w_[id4_ 
  + 1 - 1]);
  _l135:;
  w_[0] = w_[id4_ + 1 - 1] + 3 * (*m_);
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _hstcsp (int_4 _p_ intl_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 
_p_ bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 iwbm_, iwcm_, iwan_, iwbn_, iwcn_, iwsnth_, iwrsq_, iwwrk_, ierr1_;
  static real_4 pi_, dum_;
  extern real_4 _pimach ();
  pi_ = _pimach (&dum_);
  (*ierror_) = 0;
  if ((*a_) < 0.0 || (*b_) > pi_) {
    (*ierror_) = 1;
  }
  if ((*a_) >= (*b_)) {
    (*ierror_) = 2;
  }
  if ((*mbdcnd_) < 1 || (*mbdcnd_) > 9) {
    (*ierror_) = 3;
  }
  if ((*c_) < 0.0) {
    (*ierror_) = 4;
  }
  if ((*c_) >= (*d_)) {
    (*ierror_) = 5;
  }
  if ((*nbdcnd_) < 1 || (*nbdcnd_) > 6) {
    (*ierror_) = 6;
  }
  if ((*n_) < 5) {
    (*ierror_) = 7;
  }
  if (((*nbdcnd_) == 5 || (*nbdcnd_) == 6) && ((*mbdcnd_) == 1 || (*mbdcnd_) == 2 || (*mbdcnd_) == 4 || (*mbdcnd_) == 5 
    || (*mbdcnd_) == 7)) {
    (*ierror_) = 8;
  }
  if ((*c_) > 0.0 && (*nbdcnd_) >= 5) {
    (*ierror_) = 9;
  }
  if ((*idimf_) < (*m_)) {
    (*ierror_) = 11;
  }
  if ((*m_) < 5) {
    (*ierror_) = 12;
  }
  if ((*a_) == 0.0 && (*mbdcnd_) != 5 && (*mbdcnd_) != 6 && (*mbdcnd_) != 9) {
    (*ierror_) = 13;
  }
  if ((*b_) == pi_ && (*mbdcnd_) <= 6) {
    (*ierror_) = 14;
  }
  if ((*a_) > 0.0 && ((*mbdcnd_) == 5 || (*mbdcnd_) == 6 || (*mbdcnd_) == 9)) {
    (*ierror_) = 15;
  }
  if ((*b_) < pi_ && (*mbdcnd_) >= 7) {
    (*ierror_) = 16;
  }
  if ((*elmbda_) != 0.0 && (*nbdcnd_) >= 5) {
    (*ierror_) = 17;
  }
  if ((*ierror_) != 0) {
    goto _l101;
  }
  iwbm_ = (*m_) + 1;
  iwcm_ = iwbm_ + (*m_);
  iwan_ = iwcm_ + (*m_);
  iwbn_ = iwan_ + (*n_);
  iwcn_ = iwbn_ + (*n_);
  iwsnth_ = iwcn_ + (*n_);
  iwrsq_ = iwsnth_ + (*m_);
  iwwrk_ = iwrsq_ + (*n_);
  ierr1_ = 0;
  (void) _hstcs1 (intl_, a_, b_, m_, mbdcnd_, bda_, bdb_, c_, d_, n_, nbdcnd_, bdc_, bdd_, elmbda_, f_, idimf_, pertrb_, 
  &ierr1_, w_, &w_[iwbm_ - 1], &w_[iwcm_ - 1], &w_[iwan_ - 1], &w_[iwbn_ - 1], &w_[iwcn_ - 1], &w_[iwsnth_ - 1], 
  &w_[iwrsq_ - 1], &w_[iwwrk_ - 1]);
  w_[0] = w_[iwwrk_ - 1] + iwwrk_ - 1;
  (*ierror_) = ierr1_;
  _l101:;
  __calls[5].calls++;
  return 0;
}

int_4 _hstcyl (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ bdb_, real_4 
_p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ elmbda_, real_4 
_p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 np_, iwb_, iwc_, iwr_, i_, j_, k_, lp_, ierr1_;
  static real_4 deltar_, dlrsq_, deltht_, dlthsq_, a1_;
  real_4 $0_;
  (*ierror_) = 0;
  if ((*a_) < 0.0) {
    (*ierror_) = 1;
  }
  if ((*a_) >= (*b_)) {
    (*ierror_) = 2;
  }
  if ((*mbdcnd_) <= 0 || (*mbdcnd_) >= 7) {
    (*ierror_) = 3;
  }
  if ((*c_) >= (*d_)) {
    (*ierror_) = 4;
  }
  if ((*n_) <= 2) {
    (*ierror_) = 5;
  }
  if ((*nbdcnd_) < 0 || (*nbdcnd_) >= 5) {
    (*ierror_) = 6;
  }
  if ((*a_) == 0.0 && (*mbdcnd_) != 5 && (*mbdcnd_) != 6) {
    (*ierror_) = 7;
  }
  if ((*a_) > 0.0 && (*mbdcnd_) >= 5) {
    (*ierror_) = 8;
  }
  if ((*idimf_) < (*m_)) {
    (*ierror_) = 10;
  }
  if ((*m_) <= 2) {
    (*ierror_) = 9;
  }
  if ((*a_) == 0.0 && (*mbdcnd_) >= 5 && (*elmbda_) != 0.0) {
    (*ierror_) = 12;
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  deltar_ = ((*b_) - (*a_)) / (*m_);
  dlrsq_ = (deltar_ * deltar_);
  deltht_ = ((*d_) - (*c_)) / (*n_);
  dlthsq_ = (deltht_ * deltht_);
  np_ = (*nbdcnd_) + 1;
  iwb_ = (*m_);
  iwc_ = iwb_ + (*m_);
  iwr_ = iwc_ + (*m_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    w_[j_ - 1] = (*a_) + (i_ - 0.5) * deltar_;
    w_[i_ - 1] = ((*a_) + (i_ - 1) * deltar_) / (dlrsq_ * w_[j_ - 1]);
    k_ = iwc_ + i_;
    w_[k_ - 1] = ((*a_) + i_ * deltar_) / (dlrsq_ * w_[j_ - 1]);
    k_ = iwb_ + i_;
    w_[k_ - 1] = (*elmbda_) / (w_[j_ - 1] * w_[j_ - 1]) - 2.0 / dlrsq_;
  }
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l102;
    case 2: goto _l102;
    case 3: goto _l104;
    case 4: goto _l104;
    case 5: goto _l106;
    case 6: goto _l106;
  }
  _l102:;
  a1_ = 2.0 * w_[0];
  w_[iwb_ + 1 - 1] = w_[iwb_ + 1 - 1] - w_[0];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] - a1_ * bda_[j_ - 1];
  }
  goto _l106;
  _l104:;
  a1_ = deltar_ * w_[0];
  w_[iwb_ + 1 - 1] = w_[iwb_ + 1 - 1] + w_[0];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] + a1_ * bda_[j_ - 1];
  }
  _l106:;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l107;
    case 2: goto _l109;
    case 3: goto _l109;
    case 4: goto _l107;
    case 5: goto _l107;
    case 6: goto _l109;
  }
  _l107:;
  w_[iwc_ - 1] = w_[iwc_ - 1] - w_[iwr_ - 1];
  a1_ = 2.0 * w_[iwr_ - 1];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * bdb_[j_ - 1];
  }
  goto _l111;
  _l109:;
  w_[iwc_ - 1] = w_[iwc_ - 1] + w_[iwr_ - 1];
  a1_ = deltar_ * w_[iwr_ - 1];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * bdb_[j_ - 1];
  }
  _l111:;
  a1_ = 2.0 / dlthsq_;
  switch (np_) {
    default:
    case 1: goto _l121;
    case 2: goto _l112;
    case 3: goto _l112;
    case 4: goto _l114;
    case 5: goto _l114;
  }
  _l112:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] - a1_ * bdc_[i_ - 1];
  }
  goto _l116;
  _l114:;
  a1_ = 1.0 / deltht_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] + a1_ * bdc_[i_ - 1];
  }
  _l116:;
  a1_ = 2.0 / dlthsq_;
  switch (np_) {
    default:
    case 1: goto _l121;
    case 2: goto _l117;
    case 3: goto _l119;
    case 4: goto _l119;
    case 5: goto _l117;
  }
  _l117:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - a1_ * bdd_[i_ - 1];
  }
  goto _l121;
  _l119:;
  a1_ = 1.0 / deltht_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - a1_ * bdd_[i_ - 1];
  }
  _l121:;
  (*pertrb_) = 0.0;
  $0_ = (*elmbda_);
  if ($0_ < 0) {
    goto _l130;
  } else if ($0_ == 0) {
    goto _l123;
  } else {
    goto _l122;
  }
  _l122:;
  (*ierror_) = 11;
  goto _l130;
  _l123:;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l130;
    case 2: goto _l130;
    case 3: goto _l124;
    case 4: goto _l130;
    case 5: goto _l130;
    case 6: goto _l124;
  }
  _l124:;
  switch (np_) {
    default:
    case 1: goto _l125;
    case 2: goto _l130;
    case 3: goto _l130;
    case 4: goto _l125;
    case 5: goto _l130;
  }
  _l125:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    a1_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      a1_ = a1_ + f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
    j_ = iwr_ + i_;
    (*pertrb_) = (*pertrb_) + a1_ * w_[j_ - 1];
  }
  (*pertrb_) = (*pertrb_) / ((*m_) * (*n_) * 0.5 * ((*a_) + (*b_)));
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] - (*pertrb_);
    }
  }
  _l130:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    w_[i_ - 1] = w_[i_ - 1] * dlthsq_;
    j_ = iwc_ + i_;
    w_[j_ - 1] = w_[j_ - 1] * dlthsq_;
    j_ = iwb_ + i_;
    w_[j_ - 1] = w_[j_ - 1] * dlthsq_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] * dlthsq_;
    }
  }
  lp_ = (*nbdcnd_);
  w_[0] = 0.0;
  w_[iwr_ - 1] = 0.0;
  if ((*nbdcnd_) == 0) {
    goto _l133;
  }
  (void) _poistg (&lp_, n_, &_k1, m_, w_, &w_[iwb_ + 1 - 1], &w_[iwc_ + 1 - 1], idimf_, f_, &ierr1_, &w_[iwr_ + 1 - 1]);
  goto _l134;
  _l133:;
  (void) _genbun (&lp_, n_, &_k1, m_, w_, &w_[iwb_ + 1 - 1], &w_[iwc_ + 1 - 1], idimf_, f_, &ierr1_, &w_[iwr_ + 1 - 1]);
  _l134:;
  w_[0] = w_[iwr_ + 1 - 1] + 3 * (*m_);
  _l0:;
  __calls[6].calls++;
  return 0;
}

int_4 _hstplr (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ bdb_, real_4 
_p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ elmbda_, real_4 
_p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 np_, isw_, mb_, iwb_, iwc_, iwr_, i_, j_, k_, lp_, ierr1_;
  static real_4 deltar_, dlrsq_, deltht_, dlthsq_, a1_, a2_;
  real_4 $0_;
  (*ierror_) = 0;
  if ((*a_) < 0.0) {
    (*ierror_) = 1;
  }
  if ((*a_) >= (*b_)) {
    (*ierror_) = 2;
  }
  if ((*mbdcnd_) <= 0 || (*mbdcnd_) >= 7) {
    (*ierror_) = 3;
  }
  if ((*c_) >= (*d_)) {
    (*ierror_) = 4;
  }
  if ((*n_) <= 2) {
    (*ierror_) = 5;
  }
  if ((*nbdcnd_) < 0 || (*nbdcnd_) >= 5) {
    (*ierror_) = 6;
  }
  if ((*a_) == 0.0 && ((*mbdcnd_) == 3 || (*mbdcnd_) == 4)) {
    (*ierror_) = 7;
  }
  if ((*a_) > 0.0 && (*mbdcnd_) >= 5) {
    (*ierror_) = 8;
  }
  if ((*mbdcnd_) >= 5 && (*nbdcnd_) != 0 && (*nbdcnd_) != 3) {
    (*ierror_) = 9;
  }
  if ((*idimf_) < (*m_)) {
    (*ierror_) = 10;
  }
  if ((*m_) <= 2) {
    (*ierror_) = 12;
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  deltar_ = ((*b_) - (*a_)) / (*m_);
  dlrsq_ = (deltar_ * deltar_);
  deltht_ = ((*d_) - (*c_)) / (*n_);
  dlthsq_ = (deltht_ * deltht_);
  np_ = (*nbdcnd_) + 1;
  isw_ = 1;
  mb_ = (*mbdcnd_);
  if ((*a_) == 0.0 && (*mbdcnd_) == 2) {
    mb_ = 6;
  }
  iwb_ = (*m_);
  iwc_ = iwb_ + (*m_);
  iwr_ = iwc_ + (*m_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    w_[j_ - 1] = (*a_) + (i_ - 0.5) * deltar_;
    w_[i_ - 1] = ((*a_) + (i_ - 1) * deltar_) / dlrsq_;
    k_ = iwc_ + i_;
    w_[k_ - 1] = ((*a_) + i_ * deltar_) / dlrsq_;
    k_ = iwb_ + i_;
    w_[k_ - 1] = ((*elmbda_) - 2.0 / dlrsq_) * w_[j_ - 1];
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    a1_ = w_[j_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = a1_ * f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
  }
  switch (mb_) {
    default:
    case 1: goto _l104;
    case 2: goto _l104;
    case 3: goto _l106;
    case 4: goto _l106;
    case 5: goto _l108;
    case 6: goto _l108;
  }
  _l104:;
  a1_ = 2.0 * w_[0];
  w_[iwb_ + 1 - 1] = w_[iwb_ + 1 - 1] - w_[0];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] - a1_ * bda_[j_ - 1];
  }
  goto _l108;
  _l106:;
  a1_ = deltar_ * w_[0];
  w_[iwb_ + 1 - 1] = w_[iwb_ + 1 - 1] + w_[0];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] + a1_ * bda_[j_ - 1];
  }
  _l108:;
  switch (mb_) {
    default:
    case 1: goto _l109;
    case 2: goto _l111;
    case 3: goto _l111;
    case 4: goto _l109;
    case 5: goto _l109;
    case 6: goto _l111;
  }
  _l109:;
  a1_ = 2.0 * w_[iwr_ - 1];
  w_[iwc_ - 1] = w_[iwc_ - 1] - w_[iwr_ - 1];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * bdb_[j_ - 1];
  }
  goto _l113;
  _l111:;
  a1_ = deltar_ * w_[iwr_ - 1];
  w_[iwc_ - 1] = w_[iwc_ - 1] + w_[iwr_ - 1];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * bdb_[j_ - 1];
  }
  _l113:;
  a1_ = 2.0 / dlthsq_;
  switch (np_) {
    default:
    case 1: goto _l123;
    case 2: goto _l114;
    case 3: goto _l114;
    case 4: goto _l116;
    case 5: goto _l116;
  }
  _l114:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] - a1_ * bdc_[i_ - 1] / w_[j_ - 1];
  }
  goto _l118;
  _l116:;
  a1_ = 1.0 / deltht_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] + a1_ * bdc_[i_ - 1] / w_[j_ - 1];
  }
  _l118:;
  a1_ = 2.0 / dlthsq_;
  switch (np_) {
    default:
    case 1: goto _l123;
    case 2: goto _l119;
    case 3: goto _l121;
    case 4: goto _l121;
    case 5: goto _l119;
  }
  _l119:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - a1_ * bdd_[i_ - 1] / w_[j_ - 1];
  }
  goto _l123;
  _l121:;
  a1_ = 1.0 / deltht_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - a1_ * bdd_[i_ - 1] / w_[j_ - 1];
  }
  _l123:;
  (*pertrb_) = 0.0;
  $0_ = (*elmbda_);
  if ($0_ < 0) {
    goto _l133;
  } else if ($0_ == 0) {
    goto _l125;
  } else {
    goto _l124;
  }
  _l124:;
  (*ierror_) = 11;
  goto _l133;
  _l125:;
  switch (mb_) {
    default:
    case 1: goto _l133;
    case 2: goto _l133;
    case 3: goto _l126;
    case 4: goto _l133;
    case 5: goto _l133;
    case 6: goto _l126;
  }
  _l126:;
  switch (np_) {
    default:
    case 1: goto _l127;
    case 2: goto _l133;
    case 3: goto _l133;
    case 4: goto _l127;
    case 5: goto _l133;
  }
  _l127:;
  isw_ = 2;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      (*pertrb_) = (*pertrb_) + f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
  }
  (*pertrb_) = (*pertrb_) / ((*m_) * (*n_) * 0.5 * ((*a_) + (*b_)));
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    a1_ = (*pertrb_) * w_[j_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] - a1_;
    }
  }
  a2_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    a2_ = a2_ + f_[0 + ((*idimf_)) * ((j_ - 1))];
  }
  a2_ = a2_ / w_[iwr_ + 1 - 1];
  _l133:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    a1_ = dlthsq_ * w_[j_ - 1];
    w_[i_ - 1] = a1_ * w_[i_ - 1];
    j_ = iwc_ + i_;
    w_[j_ - 1] = a1_ * w_[j_ - 1];
    j_ = iwb_ + i_;
    w_[j_ - 1] = a1_ * w_[j_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = a1_ * f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
  }
  lp_ = (*nbdcnd_);
  w_[0] = 0.0;
  w_[iwr_ - 1] = 0.0;
  if (lp_ == 0) {
    goto _l136;
  }
  (void) _poistg (&lp_, n_, &_k1, m_, w_, &w_[iwb_ + 1 - 1], &w_[iwc_ + 1 - 1], idimf_, f_, &ierr1_, &w_[iwr_ + 1 - 1]);
  goto _l137;
  _l136:;
  (void) _genbun (&lp_, n_, &_k1, m_, w_, &w_[iwb_ + 1 - 1], &w_[iwc_ + 1 - 1], idimf_, f_, &ierr1_, &w_[iwr_ + 1 - 1]);
  _l137:;
  w_[0] = w_[iwr_ + 1 - 1] + 3 * (*m_);
  if ((*a_) != 0.0 || (*mbdcnd_) != 2 || isw_ != 2) {
    goto _l141;
  }
  a1_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    a1_ = a1_ + f_[0 + ((*idimf_)) * ((j_ - 1))];
  }
  a1_ = (a1_ - dlrsq_ * a2_ / 16.0) / (*n_);
  if ((*nbdcnd_) == 3) {
    a1_ = a1_ + (bdd_[0] - bdc_[0]) / ((*d_) - (*c_));
  }
  a1_ = bda_[0] - a1_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] + a1_;
    }
  }
  _l141:;
  _l0:;
  __calls[7].calls++;
  return 0;
}

int_4 _hstssp (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ bdb_, real_4 
_p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ elmbda_, real_4 
_p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 np_, isw_, jsw_, mb_, iwb_, iwc_, iwr_, iws_, i_, j_, mm1_, k_, lp_, ierr1_;
  static real_4 pi_, dum_, deltar_, dlrsq_, deltht_, dlthsq_, a1_, a2_, a3_;
  real_4 $0_;
  extern real_4 _pimach ();
  (*ierror_) = 0;
  pi_ = _pimach (&dum_);
  if ((*a_) < 0.0 || (*b_) > pi_) {
    (*ierror_) = 1;
  }
  if ((*a_) >= (*b_)) {
    (*ierror_) = 2;
  }
  if ((*mbdcnd_) <= 0 || (*mbdcnd_) > 9) {
    (*ierror_) = 3;
  }
  if ((*c_) >= (*d_)) {
    (*ierror_) = 4;
  }
  if ((*n_) <= 2) {
    (*ierror_) = 5;
  }
  if ((*nbdcnd_) < 0 || (*nbdcnd_) >= 5) {
    (*ierror_) = 6;
  }
  if ((*a_) > 0.0 && ((*mbdcnd_) == 5 || (*mbdcnd_) == 6 || (*mbdcnd_) == 9)) {
    (*ierror_) = 7;
  }
  if ((*a_) == 0.0 && ((*mbdcnd_) == 3 || (*mbdcnd_) == 4 || (*mbdcnd_) == 8)) {
    (*ierror_) = 8;
  }
  if ((*b_) < pi_ && (*mbdcnd_) >= 7) {
    (*ierror_) = 9;
  }
  if ((*b_) == pi_ && ((*mbdcnd_) == 2 || (*mbdcnd_) == 3 || (*mbdcnd_) == 6)) {
    (*ierror_) = 10;
  }
  if ((*mbdcnd_) >= 5 && ((*nbdcnd_) == 1 || (*nbdcnd_) == 2 || (*nbdcnd_) == 4)) {
    (*ierror_) = 11;
  }
  if ((*idimf_) < (*m_)) {
    (*ierror_) = 12;
  }
  if ((*m_) <= 2) {
    (*ierror_) = 13;
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  deltar_ = ((*b_) - (*a_)) / (*m_);
  dlrsq_ = (deltar_ * deltar_);
  deltht_ = ((*d_) - (*c_)) / (*n_);
  dlthsq_ = (deltht_ * deltht_);
  np_ = (*nbdcnd_) + 1;
  isw_ = 1;
  jsw_ = 1;
  mb_ = (*mbdcnd_);
  if ((*elmbda_) != 0.0) {
    goto _l105;
  }
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l101;
    case 2: goto _l102;
    case 3: goto _l105;
    case 4: goto _l103;
    case 5: goto _l101;
    case 6: goto _l105;
    case 7: goto _l101;
    case 8: goto _l105;
    case 9: goto _l105;
  }
  _l101:;
  if ((*a_) != 0.0 || (*b_) != pi_) {
    goto _l105;
  }
  mb_ = 9;
  goto _l104;
  _l102:;
  if ((*a_) != 0.0) {
    goto _l105;
  }
  mb_ = 6;
  goto _l104;
  _l103:;
  if ((*b_) != pi_) {
    goto _l105;
  }
  mb_ = 8;
  _l104:;
  jsw_ = 2;
  _l105:;
  iwb_ = (*m_);
  iwc_ = iwb_ + (*m_);
  iwr_ = iwc_ + (*m_);
  iws_ = iwr_ + (*m_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    w_[j_ - 1] = sinf ((*a_) + (i_ - 0.5) * deltar_);
    w_[i_ - 1] = sinf (((*a_) + (i_ - 1) * deltar_)) / dlrsq_;
  }
  mm1_ = (*m_) - 1;
  for (i_ = 1; i_ <= mm1_; (i_)++) {
    k_ = iwc_ + i_;
    w_[k_ - 1] = w_[i_ + 1 - 1];
    j_ = iwr_ + i_;
    k_ = iwb_ + i_;
    w_[k_ - 1] = (*elmbda_) * w_[j_ - 1] - (w_[i_ - 1] + w_[i_ + 1 - 1]);
  }
  w_[iwr_ - 1] = sinf ((*b_)) / dlrsq_;
  w_[iwc_ - 1] = (*elmbda_) * w_[iws_ - 1] - (w_[(*m_) - 1] + w_[iwr_ - 1]);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    a1_ = w_[j_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = a1_ * f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
  }
  switch (mb_) {
    default:
    case 1: goto _l110;
    case 2: goto _l110;
    case 3: goto _l112;
    case 4: goto _l112;
    case 5: goto _l114;
    case 6: goto _l114;
    case 7: goto _l110;
    case 8: goto _l112;
    case 9: goto _l114;
  }
  _l110:;
  a1_ = 2.0 * w_[0];
  w_[iwb_ + 1 - 1] = w_[iwb_ + 1 - 1] - w_[0];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] - a1_ * bda_[j_ - 1];
  }
  goto _l114;
  _l112:;
  a1_ = deltar_ * w_[0];
  w_[iwb_ + 1 - 1] = w_[iwb_ + 1 - 1] + w_[0];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] + a1_ * bda_[j_ - 1];
  }
  _l114:;
  switch (mb_) {
    default:
    case 1: goto _l115;
    case 2: goto _l117;
    case 3: goto _l117;
    case 4: goto _l115;
    case 5: goto _l115;
    case 6: goto _l117;
    case 7: goto _l119;
    case 8: goto _l119;
    case 9: goto _l119;
  }
  _l115:;
  a1_ = 2.0 * w_[iwr_ - 1];
  w_[iwc_ - 1] = w_[iwc_ - 1] - w_[iwr_ - 1];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * bdb_[j_ - 1];
  }
  goto _l119;
  _l117:;
  a1_ = deltar_ * w_[iwr_ - 1];
  w_[iwc_ - 1] = w_[iwc_ - 1] + w_[iwr_ - 1];
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * bdb_[j_ - 1];
  }
  _l119:;
  a1_ = 2.0 / dlthsq_;
  switch (np_) {
    default:
    case 1: goto _l129;
    case 2: goto _l120;
    case 3: goto _l120;
    case 4: goto _l122;
    case 5: goto _l122;
  }
  _l120:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] - a1_ * bdc_[i_ - 1] / w_[j_ - 1];
  }
  goto _l124;
  _l122:;
  a1_ = 1.0 / deltht_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] + a1_ * bdc_[i_ - 1] / w_[j_ - 1];
  }
  _l124:;
  a1_ = 2.0 / dlthsq_;
  switch (np_) {
    default:
    case 1: goto _l129;
    case 2: goto _l125;
    case 3: goto _l127;
    case 4: goto _l127;
    case 5: goto _l125;
  }
  _l125:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - a1_ * bdd_[i_ - 1] / w_[j_ - 1];
  }
  goto _l129;
  _l127:;
  a1_ = 1.0 / deltht_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - a1_ * bdd_[i_ - 1] / w_[j_ - 1];
  }
  _l129:;
  (*pertrb_) = 0.0;
  $0_ = (*elmbda_);
  if ($0_ < 0) {
    goto _l139;
  } else if ($0_ == 0) {
    goto _l131;
  } else {
    goto _l130;
  }
  _l130:;
  (*ierror_) = 14;
  goto _l139;
  _l131:;
  switch (mb_) {
    default:
    case 1: goto _l139;
    case 2: goto _l139;
    case 3: goto _l132;
    case 4: goto _l139;
    case 5: goto _l139;
    case 6: goto _l132;
    case 7: goto _l139;
    case 8: goto _l132;
    case 9: goto _l132;
  }
  _l132:;
  switch (np_) {
    default:
    case 1: goto _l133;
    case 2: goto _l139;
    case 3: goto _l139;
    case 4: goto _l133;
    case 5: goto _l139;
  }
  _l133:;
  isw_ = 2;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      (*pertrb_) = (*pertrb_) + f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
  }
  a1_ = (*n_) * (cosf ((*a_)) - cosf ((*b_))) / (2.0 * sinf (0.5 * deltar_));
  (*pertrb_) = (*pertrb_) / a1_;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    a1_ = (*pertrb_) * w_[j_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] - a1_;
    }
  }
  a2_ = 0.0;
  a3_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    a2_ = a2_ + f_[0 + ((*idimf_)) * ((j_ - 1))];
    a3_ = a3_ + f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))];
  }
  a2_ = a2_ / w_[iwr_ + 1 - 1];
  a3_ = a3_ / w_[iws_ - 1];
  _l139:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    j_ = iwr_ + i_;
    a1_ = dlthsq_ * w_[j_ - 1];
    w_[i_ - 1] = a1_ * w_[i_ - 1];
    j_ = iwc_ + i_;
    w_[j_ - 1] = a1_ * w_[j_ - 1];
    j_ = iwb_ + i_;
    w_[j_ - 1] = a1_ * w_[j_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = a1_ * f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
  }
  lp_ = (*nbdcnd_);
  w_[0] = 0.0;
  w_[iwr_ - 1] = 0.0;
  if ((*nbdcnd_) == 0) {
    goto _l142;
  }
  (void) _poistg (&lp_, n_, &_k1, m_, w_, &w_[iwb_ + 1 - 1], &w_[iwc_ + 1 - 1], idimf_, f_, &ierr1_, &w_[iwr_ + 1 - 1]);
  goto _l143;
  _l142:;
  (void) _genbun (&lp_, n_, &_k1, m_, w_, &w_[iwb_ + 1 - 1], &w_[iwc_ + 1 - 1], idimf_, f_, &ierr1_, &w_[iwr_ + 1 - 1]);
  _l143:;
  w_[0] = w_[iwr_ + 1 - 1] + 3 * (*m_);
  if (isw_ != 2 || jsw_ != 2) {
    goto _l150;
  }
  if (mb_ != 8) {
    goto _l145;
  }
  a1_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    a1_ = a1_ + f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))];
  }
  a1_ = (a1_ - dlrsq_ * a3_ / 16.0) / (*n_);
  if ((*nbdcnd_) == 3) {
    a1_ = a1_ + (bdd_[(*m_) - 1] - bdc_[(*m_) - 1]) / ((*d_) - (*c_));
  }
  a1_ = bdb_[0] - a1_;
  goto _l147;
  _l145:;
  a1_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    a1_ = a1_ + f_[0 + ((*idimf_)) * ((j_ - 1))];
  }
  a1_ = (a1_ - dlrsq_ * a2_ / 16.0) / (*n_);
  if ((*nbdcnd_) == 3) {
    a1_ = a1_ + (bdd_[0] - bdc_[0]) / ((*d_) - (*c_));
  }
  a1_ = bda_[0] - a1_;
  _l147:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] + a1_;
    }
  }
  _l150:;
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _hw3crt (real_4 _p_ xs_, real_4 _p_ xf_, int_4 _p_ l_, int_4 _p_ lbdcnd_, real_4 _p_ bdxs_, real_4 _p_ bdxf_, 
real_4 _p_ ys_, real_4 _p_ yf_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bdys_, real_4 _p_ bdyf_, real_4 _p_ zs_, 
real_4 _p_ zf_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdzs_, real_4 _p_ bdzf_, real_4 _p_ elmbda_, int_4 _p_ 
ldimf_, int_4 _p_ mdimf_, real_4 _p_ f_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 mstart_, mstop_, mp1_, mp_, munk_, np_, np1_, nstart_, nstop_, nunk_, lp1_, lp_, lstart_, lstop_, j_, k_, 
  lunk_, i_, iwb_, iwc_, iww_, mstpm1_, lstpm1_, nstpm1_, nperod_, ir_;
  static real_4 dy_, twbydy_, c2_, dz_, twbydz_, c3_, dx_, c1_, twbydx_, xlp_, ylp_, zlp_, s1_, s2_, s_;
  real_4 $0_;
  (*ierror_) = 0;
  if ((*xf_) <= (*xs_)) {
    (*ierror_) = 1;
  }
  if ((*l_) < 5) {
    (*ierror_) = 2;
  }
  if ((*lbdcnd_) < 0 || (*lbdcnd_) > 4) {
    (*ierror_) = 3;
  }
  if ((*yf_) <= (*ys_)) {
    (*ierror_) = 4;
  }
  if ((*m_) < 5) {
    (*ierror_) = 5;
  }
  if ((*mbdcnd_) < 0 || (*mbdcnd_) > 4) {
    (*ierror_) = 6;
  }
  if ((*zf_) <= (*zs_)) {
    (*ierror_) = 7;
  }
  if ((*n_) < 5) {
    (*ierror_) = 8;
  }
  if ((*nbdcnd_) < 0 || (*nbdcnd_) > 4) {
    (*ierror_) = 9;
  }
  if ((*ldimf_) < (*l_) + 1) {
    (*ierror_) = 10;
  }
  if ((*mdimf_) < (*m_) + 1) {
    (*ierror_) = 11;
  }
  if ((*ierror_) != 0) {
    goto _l188;
  }
  dy_ = ((*yf_) - (*ys_)) / (*m_);
  twbydy_ = 2.0 / dy_;
  c2_ = 1.0 / ((dy_ * dy_));
  mstart_ = 1;
  mstop_ = (*m_);
  mp1_ = (*m_) + 1;
  mp_ = (*mbdcnd_) + 1;
  switch (mp_) {
    default:
    case 1: goto _l104;
    case 2: goto _l101;
    case 3: goto _l101;
    case 4: goto _l102;
    case 5: goto _l102;
  }
  _l101:;
  mstart_ = 2;
  _l102:;
  switch (mp_) {
    default:
    case 1: goto _l104;
    case 2: goto _l104;
    case 3: goto _l103;
    case 4: goto _l103;
    case 5: goto _l104;
  }
  _l103:;
  mstop_ = mp1_;
  _l104:;
  munk_ = mstop_ - mstart_ + 1;
  dz_ = ((*zf_) - (*zs_)) / (*n_);
  twbydz_ = 2.0 / dz_;
  np_ = (*nbdcnd_) + 1;
  c3_ = 1.0 / ((dz_ * dz_));
  np1_ = (*n_) + 1;
  nstart_ = 1;
  nstop_ = (*n_);
  switch (np_) {
    default:
    case 1: goto _l108;
    case 2: goto _l105;
    case 3: goto _l105;
    case 4: goto _l106;
    case 5: goto _l106;
  }
  _l105:;
  nstart_ = 2;
  _l106:;
  switch (np_) {
    default:
    case 1: goto _l108;
    case 2: goto _l108;
    case 3: goto _l107;
    case 4: goto _l107;
    case 5: goto _l108;
  }
  _l107:;
  nstop_ = np1_;
  _l108:;
  nunk_ = nstop_ - nstart_ + 1;
  lp1_ = (*l_) + 1;
  dx_ = ((*xf_) - (*xs_)) / (*l_);
  c1_ = 1.0 / ((dx_ * dx_));
  twbydx_ = 2.0 / dx_;
  lp_ = (*lbdcnd_) + 1;
  lstart_ = 1;
  lstop_ = (*l_);
  switch (lp_) {
    default:
    case 1: goto _l122;
    case 2: goto _l109;
    case 3: goto _l109;
    case 4: goto _l112;
    case 5: goto _l112;
  }
  _l109:;
  lstart_ = 2;
  for (j_ = mstart_; j_ <= mstop_; (j_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 
      1)))] - c1_ * f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))];
    }
  }
  goto _l115;
  _l112:;
  for (j_ = mstart_; j_ <= mstop_; (j_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 
      1)))] + twbydx_ * bdxs_[j_ - 1 + ((*mdimf_)) * ((k_ - 1))];
    }
  }
  _l115:;
  switch (lp_) {
    default:
    case 1: goto _l122;
    case 2: goto _l116;
    case 3: goto _l119;
    case 4: goto _l119;
    case 5: goto _l116;
  }
  _l116:;
  for (j_ = mstart_; j_ <= mstop_; (j_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[(*l_) - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[(*l_) - 1 + ((*ldimf_)) * ((j_ - 1) + 
      ((*mdimf_)) * ((k_ - 1)))] - c1_ * f_[lp1_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))];
    }
  }
  goto _l122;
  _l119:;
  lstop_ = lp1_;
  for (j_ = mstart_; j_ <= mstop_; (j_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[lp1_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[lp1_ - 1 + ((*ldimf_)) * ((j_ - 1) + 
      ((*mdimf_)) * ((k_ - 1)))] - twbydx_ * bdxf_[j_ - 1 + ((*mdimf_)) * ((k_ - 1))];
    }
  }
  _l122:;
  lunk_ = lstop_ - lstart_ + 1;
  switch (mp_) {
    default:
    case 1: goto _l136;
    case 2: goto _l123;
    case 3: goto _l123;
    case 4: goto _l126;
    case 5: goto _l126;
  }
  _l123:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((1) + ((*mdimf_)) * ((k_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((1) + ((*mdimf_)) * ((k_ - 
      1)))] - c2_ * f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((k_ - 1)))];
    }
  }
  goto _l129;
  _l126:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((k_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((k_ - 
      1)))] + twbydy_ * bdys_[i_ - 1 + ((*ldimf_)) * ((k_ - 1))];
    }
  }
  _l129:;
  switch (mp_) {
    default:
    case 1: goto _l136;
    case 2: goto _l130;
    case 3: goto _l133;
    case 4: goto _l133;
    case 5: goto _l130;
  }
  _l130:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[i_ - 1 + ((*ldimf_)) * (((*m_) - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * (((*m_) - 1) + 
      ((*mdimf_)) * ((k_ - 1)))] - c2_ * f_[i_ - 1 + ((*ldimf_)) * ((mp1_ - 1) + ((*mdimf_)) * ((k_ - 1)))];
    }
  }
  goto _l136;
  _l133:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((mp1_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((mp1_ - 1) + 
      ((*mdimf_)) * ((k_ - 1)))] - twbydy_ * bdyf_[i_ - 1 + ((*ldimf_)) * ((k_ - 1))];
    }
  }
  _l136:;
  switch (np_) {
    default:
    case 1: goto _l150;
    case 2: goto _l137;
    case 3: goto _l137;
    case 4: goto _l140;
    case 5: goto _l140;
  }
  _l137:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (j_ = mstart_; j_ <= mstop_; (j_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((1)))] = f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * 
      ((1)))] - c3_ * f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((0)))];
    }
  }
  goto _l143;
  _l140:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (j_ = mstart_; j_ <= mstop_; (j_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((0)))] = f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * 
      ((0)))] + twbydz_ * bdzs_[i_ - 1 + ((*ldimf_)) * ((j_ - 1))];
    }
  }
  _l143:;
  switch (np_) {
    default:
    case 1: goto _l150;
    case 2: goto _l144;
    case 3: goto _l147;
    case 4: goto _l147;
    case 5: goto _l144;
  }
  _l144:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (j_ = mstart_; j_ <= mstop_; (j_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * (((*n_) - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) 
      * (((*n_) - 1)))] - c3_ * f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((np1_ - 1)))];
    }
  }
  goto _l150;
  _l147:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (j_ = mstart_; j_ <= mstop_; (j_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((np1_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) 
      * ((np1_ - 1)))] - twbydz_ * bdzf_[i_ - 1 + ((*ldimf_)) * ((j_ - 1))];
    }
  }
  _l150:;
  iwb_ = nunk_ + 1;
  iwc_ = iwb_ + nunk_;
  iww_ = iwc_ + nunk_;
  for (k_ = 1; k_ <= nunk_; (k_)++) {
    i_ = iwc_ + k_ - 1;
    w_[k_ - 1] = c3_;
    w_[i_ - 1] = c3_;
    i_ = iwb_ + k_ - 1;
    w_[i_ - 1] = -2.0 * c3_ + (*elmbda_);
  }
  switch (np_) {
    default:
    case 1: goto _l155;
    case 2: goto _l155;
    case 3: goto _l153;
    case 4: goto _l152;
    case 5: goto _l152;
  }
  _l152:;
  w_[iwc_ - 1] = 2.0 * c3_;
  _l153:;
  switch (np_) {
    default:
    case 1: goto _l155;
    case 2: goto _l155;
    case 3: goto _l154;
    case 4: goto _l154;
    case 5: goto _l155;
  }
  _l154:;
  w_[iwb_ - 1 - 1] = 2.0 * c3_;
  _l155:;
  (*pertrb_) = 0.0;
  switch (lp_) {
    default:
    case 1: goto _l156;
    case 2: goto _l172;
    case 3: goto _l172;
    case 4: goto _l156;
    case 5: goto _l172;
  }
  _l156:;
  switch (mp_) {
    default:
    case 1: goto _l157;
    case 2: goto _l172;
    case 3: goto _l172;
    case 4: goto _l157;
    case 5: goto _l172;
  }
  _l157:;
  switch (np_) {
    default:
    case 1: goto _l158;
    case 2: goto _l172;
    case 3: goto _l172;
    case 4: goto _l158;
    case 5: goto _l172;
  }
  _l158:;
  $0_ = (*elmbda_);
  if ($0_ < 0) {
    goto _l172;
  } else if ($0_ == 0) {
    goto _l160;
  } else {
    goto _l159;
  }
  _l159:;
  (*ierror_) = 12;
  goto _l172;
  _l160:;
  mstpm1_ = mstop_ - 1;
  lstpm1_ = lstop_ - 1;
  nstpm1_ = nstop_ - 1;
  xlp_ = (2 + lp_) / 3;
  ylp_ = (2 + mp_) / 3;
  zlp_ = (2 + np_) / 3;
  s1_ = 0.0;
  for (k_ = 2; k_ <= nstpm1_; (k_)++) {
    for (j_ = 2; j_ <= mstpm1_; (j_)++) {
      for (i_ = 2; i_ <= lstpm1_; (i_)++) {
        s1_ = s1_ + f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))];
      }
      s1_ = s1_ + (f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] + f_[lstop_ - 1 + ((*ldimf_)) * ((j_ - 1) + 
      ((*mdimf_)) * ((k_ - 1)))]) / xlp_;
    }
    s2_ = 0.0;
    for (i_ = 2; i_ <= lstpm1_; (i_)++) {
      s2_ = s2_ + f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((k_ - 1)))] + f_[i_ - 1 + ((*ldimf_)) * ((mstop_ - 1) + 
      ((*mdimf_)) * ((k_ - 1)))];
    }
    s2_ = (s2_ + (f_[0 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((k_ - 1)))] + f_[0 + ((*ldimf_)) * ((mstop_ - 1) + ((*mdimf_)) 
    * ((k_ - 1)))] + f_[lstop_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((k_ - 1)))] + f_[lstop_ - 1 + ((*ldimf_)) * 
    ((mstop_ - 1) + ((*mdimf_)) * ((k_ - 1)))]) / xlp_) / ylp_;
    s1_ = s1_ + s2_;
  }
  s_ = (f_[0 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((0)))] + f_[lstop_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((0)))] + 
  f_[0 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((nstop_ - 1)))] + f_[lstop_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * 
  ((nstop_ - 1)))] + f_[0 + ((*ldimf_)) * ((mstop_ - 1) + ((*mdimf_)) * ((0)))] + f_[lstop_ - 1 + ((*ldimf_)) * ((mstop_ 
  - 1) + ((*mdimf_)) * ((0)))] + f_[0 + ((*ldimf_)) * ((mstop_ - 1) + ((*mdimf_)) * ((nstop_ - 1)))] + f_[lstop_ - 1 + 
  ((*ldimf_)) * ((mstop_ - 1) + ((*mdimf_)) * ((nstop_ - 1)))]) / (xlp_ * ylp_);
  for (j_ = 2; j_ <= mstpm1_; (j_)++) {
    for (i_ = 2; i_ <= lstpm1_; (i_)++) {
      s_ = s_ + f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((0)))] + f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + 
      ((*mdimf_)) * ((nstop_ - 1)))];
    }
  }
  s2_ = 0.0;
  for (i_ = 2; i_ <= lstpm1_; (i_)++) {
    s2_ = s2_ + f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((0)))] + f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * 
    ((nstop_ - 1)))] + f_[i_ - 1 + ((*ldimf_)) * ((mstop_ - 1) + ((*mdimf_)) * ((0)))] + f_[i_ - 1 + ((*ldimf_)) * ((mstop_ 
    - 1) + ((*mdimf_)) * ((nstop_ - 1)))];
  }
  s_ = s2_ / ylp_ + s_;
  s2_ = 0.0;
  for (j_ = 2; j_ <= mstpm1_; (j_)++) {
    s2_ = s2_ + f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((0)))] + f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * 
    ((nstop_ - 1)))] + f_[lstop_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((0)))] + f_[lstop_ - 1 + ((*ldimf_)) * ((j_ 
    - 1) + ((*mdimf_)) * ((nstop_ - 1)))];
  }
  s_ = s2_ / xlp_ + s_;
  (*pertrb_) = (s_ / zlp_ + s1_) / ((lunk_ + 1.0 - xlp_) * (munk_ + 1.0 - ylp_) * (nunk_ + 1.0 - zlp_));
  for (i_ = 1; i_ <= lunk_; (i_)++) {
    for (j_ = 1; j_ <= munk_; (j_)++) {
      for (k_ = 1; k_ <= nunk_; (k_)++) {
        f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * 
        ((k_ - 1)))] - (*pertrb_);
      }
    }
  }
  _l172:;
  nperod_ = 0;
  if ((*nbdcnd_) == 0) {
    goto _l173;
  }
  nperod_ = 1;
  w_[0] = 0.0;
  w_[iww_ - 1 - 1] = 0.0;
  _l173:;
  (void) _pois3d (lbdcnd_, &lunk_, &c1_, mbdcnd_, &munk_, &c2_, &nperod_, &nunk_, w_, &w_[iwb_ - 1], &w_[iwc_ - 1], 
  ldimf_, mdimf_, &f_[lstart_ - 1 + ((*ldimf_)) * ((mstart_ - 1) + ((*mdimf_)) * ((nstart_ - 1)))], &ir_, &w_[iww_ - 1])
  ;
  if (lp_ != 1) {
    goto _l180;
  }
  if (mp_ != 1) {
    goto _l175;
  }
  for (k_ = nstart_; k_ <= nstop_; (k_)++) {
    f_[0 + ((*ldimf_)) * ((mp1_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[0 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((k_ - 1)))]
    ;
  }
  mstop_ = mp1_;
  _l175:;
  if (np_ != 1) {
    goto _l177;
  }
  for (j_ = mstart_; j_ <= mstop_; (j_)++) {
    f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((np1_ - 1)))] = f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((0)))]
    ;
  }
  nstop_ = np1_;
  _l177:;
  for (j_ = mstart_; j_ <= mstop_; (j_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[lp1_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[0 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * 
      ((k_ - 1)))];
    }
  }
  _l180:;
  if (mp_ != 1) {
    goto _l185;
  }
  if (np_ != 1) {
    goto _l182;
  }
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((np1_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * ((0)))]
    ;
  }
  nstop_ = np1_;
  _l182:;
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (k_ = nstart_; k_ <= nstop_; (k_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((mp1_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((0) + ((*mdimf_)) * 
      ((k_ - 1)))];
    }
  }
  _l185:;
  if (np_ != 1) {
    goto _l188;
  }
  for (i_ = lstart_; i_ <= lstop_; (i_)++) {
    for (j_ = mstart_; j_ <= mstop_; (j_)++) {
      f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((np1_ - 1)))] = f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) 
      * ((0)))];
    }
  }
  _l188:;
  __calls[9].calls++;
  return 0;
}

int_4 _hwscrt (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ bdb_, real_4 
_p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ elmbda_, real_4 
_p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 nperod_, mperod_, np_, np1_, mp_, mp1_, nstart_, nstop_, nskip_, nunk_, mstart_, mstop_, mskip_, j_, munk_
  , i_, id2_, id3_, id4_, msp1_, mstm1_, nsp1_, nstm1_, ierr1_;
  static real_4 deltax_, twdelx_, delxsq_, deltay_, twdely_, delysq_, s_, st2_, a1_, a2_, s1_;
  real_4 $0_;
  (*ierror_) = 0;
  if ((*a_) >= (*b_)) {
    (*ierror_) = 1;
  }
  if ((*mbdcnd_) < 0 || (*mbdcnd_) > 4) {
    (*ierror_) = 2;
  }
  if ((*c_) >= (*d_)) {
    (*ierror_) = 3;
  }
  if ((*n_) <= 3) {
    (*ierror_) = 4;
  }
  if ((*nbdcnd_) < 0 || (*nbdcnd_) > 4) {
    (*ierror_) = 5;
  }
  if ((*idimf_) < (*m_) + 1) {
    (*ierror_) = 7;
  }
  if ((*m_) <= 3) {
    (*ierror_) = 8;
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  nperod_ = (*nbdcnd_);
  mperod_ = 0;
  if ((*mbdcnd_) > 0) {
    mperod_ = 1;
  }
  deltax_ = ((*b_) - (*a_)) / (*m_);
  twdelx_ = 2.0 / deltax_;
  delxsq_ = 1.0 / (deltax_ * deltax_);
  deltay_ = ((*d_) - (*c_)) / (*n_);
  twdely_ = 2.0 / deltay_;
  delysq_ = 1.0 / (deltay_ * deltay_);
  np_ = (*nbdcnd_) + 1;
  np1_ = (*n_) + 1;
  mp_ = (*mbdcnd_) + 1;
  mp1_ = (*m_) + 1;
  nstart_ = 1;
  nstop_ = (*n_);
  nskip_ = 1;
  switch (np_) {
    default:
    case 1: goto _l104;
    case 2: goto _l101;
    case 3: goto _l102;
    case 4: goto _l103;
    case 5: goto _l104;
  }
  _l101:;
  nstart_ = 2;
  goto _l104;
  _l102:;
  nstart_ = 2;
  _l103:;
  nstop_ = np1_;
  nskip_ = 2;
  _l104:;
  nunk_ = nstop_ - nstart_ + 1;
  mstart_ = 1;
  mstop_ = (*m_);
  mskip_ = 1;
  switch (mp_) {
    default:
    case 1: goto _l117;
    case 2: goto _l105;
    case 3: goto _l106;
    case 4: goto _l109;
    case 5: goto _l110;
  }
  _l105:;
  mstart_ = 2;
  goto _l107;
  _l106:;
  mstart_ = 2;
  mstop_ = mp1_;
  mskip_ = 2;
  _l107:;
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[1 + ((*idimf_)) * ((j_ - 1))] = f_[1 + ((*idimf_)) * ((j_ - 1))] - f_[0 + ((*idimf_)) * ((j_ - 1))] * delxsq_;
  }
  goto _l112;
  _l109:;
  mstop_ = mp1_;
  mskip_ = 2;
  _l110:;
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] + bda_[j_ - 1] * twdelx_;
  }
  _l112:;
  switch (mskip_) {
    default:
    case 1: goto _l113;
    case 2: goto _l115;
  }
  _l113:;
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - f_[mp1_ - 1 + ((*idimf_)) * ((j_ 
    - 1))] * delxsq_;
  }
  goto _l117;
  _l115:;
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[mp1_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[mp1_ - 1 + ((*idimf_)) * ((j_ - 1))] - bdb_[j_ - 1] * twdelx_;
  }
  _l117:;
  munk_ = mstop_ - mstart_ + 1;
  switch (np_) {
    default:
    case 1: goto _l127;
    case 2: goto _l118;
    case 3: goto _l118;
    case 4: goto _l120;
    case 5: goto _l120;
  }
  _l118:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((1))] = f_[i_ - 1 + ((*idimf_)) * ((1))] - f_[i_ - 1 + ((*idimf_)) * ((0))] * delysq_;
  }
  goto _l122;
  _l120:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] + bdc_[i_ - 1] * twdely_;
  }
  _l122:;
  switch (nskip_) {
    default:
    case 1: goto _l123;
    case 2: goto _l125;
  }
  _l123:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - f_[i_ - 1 + ((*idimf_)) * ((np1_ 
    - 1))] * delysq_;
  }
  goto _l127;
  _l125:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] - bdd_[i_ - 1] * twdely_;
  }
  _l127:;
  delysq_ = deltay_ * deltay_;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    for (j_ = nstart_; j_ <= nstop_; (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] * delysq_;
    }
  }
  id2_ = munk_;
  id3_ = id2_ + munk_;
  id4_ = id3_ + munk_;
  s_ = delysq_ * delxsq_;
  st2_ = 2.0 * s_;
  for (i_ = 1; i_ <= munk_; (i_)++) {
    w_[i_ - 1] = s_;
    j_ = id2_ + i_;
    w_[j_ - 1] = -st2_ + (*elmbda_) * delysq_;
    j_ = id3_ + i_;
    w_[j_ - 1] = s_;
  }
  if (mp_ == 1) {
    goto _l131;
  }
  w_[0] = 0.0;
  w_[id4_ - 1] = 0.0;
  _l131:;
  switch (mp_) {
    default:
    case 1: goto _l135;
    case 2: goto _l135;
    case 3: goto _l132;
    case 4: goto _l133;
    case 5: goto _l134;
  }
  _l132:;
  w_[id2_ - 1] = st2_;
  goto _l135;
  _l133:;
  w_[id2_ - 1] = st2_;
  _l134:;
  w_[id3_ + 1 - 1] = st2_;
  _l135:;
  (*pertrb_) = 0.0;
  $0_ = (*elmbda_);
  if ($0_ < 0) {
    goto _l144;
  } else if ($0_ == 0) {
    goto _l137;
  } else {
    goto _l136;
  }
  _l136:;
  (*ierror_) = 6;
  goto _l144;
  _l137:;
  if (((*nbdcnd_) == 0 || (*nbdcnd_) == 3) && ((*mbdcnd_) == 0 || (*mbdcnd_) == 3)) {
    goto _l138;
  }
  goto _l144;
  _l138:;
  a1_ = 1.0;
  a2_ = 1.0;
  if ((*nbdcnd_) == 3) {
    a2_ = 2.0;
  }
  if ((*mbdcnd_) == 3) {
    a1_ = 2.0;
  }
  s1_ = 0.0;
  msp1_ = mstart_ + 1;
  mstm1_ = mstop_ - 1;
  nsp1_ = nstart_ + 1;
  nstm1_ = nstop_ - 1;
  for (j_ = nsp1_; j_ <= nstm1_; (j_)++) {
    s_ = 0.0;
    for (i_ = msp1_; i_ <= mstm1_; (i_)++) {
      s_ = s_ + f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
    s1_ = s1_ + s_ * a1_ + f_[mstart_ - 1 + ((*idimf_)) * ((j_ - 1))] + f_[mstop_ - 1 + ((*idimf_)) * ((j_ - 1))];
  }
  s1_ = a2_ * s1_;
  s_ = 0.0;
  for (i_ = msp1_; i_ <= mstm1_; (i_)++) {
    s_ = s_ + f_[i_ - 1 + ((*idimf_)) * ((nstart_ - 1))] + f_[i_ - 1 + ((*idimf_)) * ((nstop_ - 1))];
  }
  s1_ = s1_ + s_ * a1_ + f_[mstart_ - 1 + ((*idimf_)) * ((nstart_ - 1))] + f_[mstart_ - 1 + ((*idimf_)) * ((nstop_ - 1))] 
  + f_[mstop_ - 1 + ((*idimf_)) * ((nstart_ - 1))] + f_[mstop_ - 1 + ((*idimf_)) * ((nstop_ - 1))];
  s_ = (2.0 + (nunk_ - 2) * a2_) * (2.0 + (munk_ - 2) * a1_);
  (*pertrb_) = s1_ / s_;
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    for (i_ = mstart_; i_ <= mstop_; (i_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] - (*pertrb_);
    }
  }
  (*pertrb_) = (*pertrb_) / delysq_;
  _l144:;
  (void) _genbun (&nperod_, &nunk_, &mperod_, &munk_, &w_[0], &w_[id2_ + 1 - 1], &w_[id3_ + 1 - 1], idimf_, &f_[mstart_ - 
  1 + ((*idimf_)) * ((nstart_ - 1))], &ierr1_, &w_[id4_ + 1 - 1]);
  w_[0] = w_[id4_ + 1 - 1] + 3 * munk_;
  if ((*nbdcnd_) != 0) {
    goto _l146;
  }
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((0))];
  }
  _l146:;
  if ((*mbdcnd_) != 0) {
    goto _l148;
  }
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[mp1_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))];
  }
  if ((*nbdcnd_) == 0) {
    f_[mp1_ - 1 + ((*idimf_)) * ((np1_ - 1))] = f_[0 + ((*idimf_)) * ((np1_ - 1))];
  }
  _l148:;
  _l0:;
  __calls[10].calls++;
  return 0;
}

int_4 _hwscsp (int_4 _p_ intl_, real_4 _p_ ts_, real_4 _p_ tf_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bdts_, 
real_4 _p_ bdtf_, real_4 _p_ rs_, real_4 _p_ rf_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdrs_, real_4 _p_ bdrf_, 
real_4 _p_ elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 nck_, l_, k_, np1_, mp1_, i1_, i2_, i3_, i4_, i5_, i6_, i7_, i8_, i9_, i10_;
  static real_4 pi_, dum_;
  int_4 $0_;
  extern real_4 _pimach ();
  pi_ = _pimach (&dum_);
  (*ierror_) = 0;
  if ((*ts_) < 0.0 || (*tf_) > pi_) {
    (*ierror_) = 1;
  }
  if ((*ts_) >= (*tf_)) {
    (*ierror_) = 2;
  }
  if ((*m_) < 5) {
    (*ierror_) = 3;
  }
  if ((*mbdcnd_) < 1 || (*mbdcnd_) > 9) {
    (*ierror_) = 4;
  }
  if ((*rs_) < 0.0) {
    (*ierror_) = 5;
  }
  if ((*rs_) >= (*rf_)) {
    (*ierror_) = 6;
  }
  if ((*n_) < 5) {
    (*ierror_) = 7;
  }
  if ((*nbdcnd_) < 1 || (*nbdcnd_) > 6) {
    (*ierror_) = 8;
  }
  if ((*elmbda_) > 0.0) {
    (*ierror_) = 9;
  }
  if ((*idimf_) < (*m_) + 1) {
    (*ierror_) = 10;
  }
  if ((*elmbda_) != 0.0 && (*mbdcnd_) >= 5) {
    (*ierror_) = 11;
  }
  if ((*elmbda_) != 0.0 && ((*nbdcnd_) == 5 || (*nbdcnd_) == 6)) {
    (*ierror_) = 12;
  }
  if (((*mbdcnd_) == 5 || (*mbdcnd_) == 6 || (*mbdcnd_) == 9) && (*ts_) != 0.0) {
    (*ierror_) = 13;
  }
  if ((*mbdcnd_) >= 7 && (*tf_) != pi_) {
    (*ierror_) = 14;
  }
  if ((*ts_) == 0.0 && ((*mbdcnd_) == 4 || (*mbdcnd_) == 8 || (*mbdcnd_) == 3)) {
    (*ierror_) = 15;
  }
  if ((*tf_) == pi_ && ((*mbdcnd_) == 2 || (*mbdcnd_) == 3 || (*mbdcnd_) == 6)) {
    (*ierror_) = 16;
  }
  if ((*nbdcnd_) >= 5 && (*rs_) != 0.0) {
    (*ierror_) = 17;
  }
  if ((*nbdcnd_) >= 5 && ((*mbdcnd_) == 1 || (*mbdcnd_) == 2 || (*mbdcnd_) == 5 || (*mbdcnd_) == 7)) {
    (*ierror_) = 18;
  }
  if ((*ierror_) != 0 && (*ierror_) != 9) {
    goto _l0;
  }
  nck_ = (*n_);
  switch ((*nbdcnd_)) {
    default:
    case 1: goto _l101;
    case 2: goto _l103;
    case 3: goto _l102;
    case 4: goto _l103;
    case 5: goto _l101;
    case 6: goto _l103;
  }
  _l101:;
  nck_ = nck_ - 1;
  goto _l103;
  _l102:;
  nck_ = nck_ + 1;
  _l103:;
  l_ = 2;
  k_ = 1;
  _l104:;
  l_ = l_ + l_;
  k_ = k_ + 1;
  $0_ = nck_ - l_;
  if ($0_ < 0) {
    goto _l105;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l104;
  }
  _l105:;
  l_ = l_ + l_;
  np1_ = (*n_) + 1;
  mp1_ = (*m_) + 1;
  i1_ = (k_ - 2) * l_ + k_ + _max (2 * (*n_), 6 * (*m_)) + 13;
  i2_ = i1_ + np1_;
  i3_ = i2_ + np1_;
  i4_ = i3_ + np1_;
  i5_ = i4_ + np1_;
  i6_ = i5_ + np1_;
  i7_ = i6_ + mp1_;
  i8_ = i7_ + mp1_;
  i9_ = i8_ + mp1_;
  i10_ = i9_ + mp1_;
  w_[0] = i10_ + (*m_);
  (void) _hwscs1 (intl_, ts_, tf_, m_, mbdcnd_, bdts_, bdtf_, rs_, rf_, n_, nbdcnd_, bdrs_, bdrf_, elmbda_, f_, idimf_, 
  pertrb_, &w_[1], &w_[i1_ - 1], &w_[i2_ - 1], &w_[i3_ - 1], &w_[i4_ - 1], &w_[i5_ - 1], &w_[i6_ - 1], &w_[i7_ - 1], 
  &w_[i8_ - 1], &w_[i9_ - 1], &w_[i10_ - 1]);
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _hwscyl (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ bdb_, real_4 
_p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ elmbda_, real_4 
_p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 mp1_, np1_, np_, mstart_, mstop_, munk_, nstart_, nstop_, nunk_, id2_, id3_, id4_, id5_, id6_, istart_, 
  ij_, i_, j_, k_, l_, nsp1_, nstm1_, ierr1_;
  static real_4 deltar_, dlrby2_, dlrsq_, deltht_, dlthsq_, a1_, r_, a2_, s_, s1_, s2_;
  real_4 $0_;
  (*ierror_) = 0;
  if ((*a_) < 0.0) {
    (*ierror_) = 1;
  }
  if ((*a_) >= (*b_)) {
    (*ierror_) = 2;
  }
  if ((*mbdcnd_) <= 0 || (*mbdcnd_) >= 7) {
    (*ierror_) = 3;
  }
  if ((*c_) >= (*d_)) {
    (*ierror_) = 4;
  }
  if ((*n_) <= 3) {
    (*ierror_) = 5;
  }
  if ((*nbdcnd_) <= -1 || (*nbdcnd_) >= 5) {
    (*ierror_) = 6;
  }
  if ((*a_) == 0.0 && ((*mbdcnd_) == 3 || (*mbdcnd_) == 4)) {
    (*ierror_) = 7;
  }
  if ((*a_) > 0.0 && (*mbdcnd_) >= 5) {
    (*ierror_) = 8;
  }
  if ((*a_) == 0.0 && (*elmbda_) != 0.0 && (*mbdcnd_) >= 5) {
    (*ierror_) = 9;
  }
  if ((*idimf_) < (*m_) + 1) {
    (*ierror_) = 10;
  }
  if ((*m_) <= 3) {
    (*ierror_) = 12;
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  mp1_ = (*m_) + 1;
  deltar_ = ((*b_) - (*a_)) / (*m_);
  dlrby2_ = deltar_ / 2.0;
  dlrsq_ = (deltar_ * deltar_);
  np1_ = (*n_) + 1;
  deltht_ = ((*d_) - (*c_)) / (*n_);
  dlthsq_ = (deltht_ * deltht_);
  np_ = (*nbdcnd_) + 1;
  mstart_ = 2;
  mstop_ = (*m_);
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l104;
    case 2: goto _l103;
    case 3: goto _l102;
    case 4: goto _l101;
    case 5: goto _l101;
    case 6: goto _l102;
  }
  _l101:;
  mstart_ = 1;
  goto _l104;
  _l102:;
  mstart_ = 1;
  _l103:;
  mstop_ = mp1_;
  _l104:;
  munk_ = mstop_ - mstart_ + 1;
  nstart_ = 1;
  nstop_ = (*n_);
  switch (np_) {
    default:
    case 1: goto _l108;
    case 2: goto _l105;
    case 3: goto _l106;
    case 4: goto _l107;
    case 5: goto _l108;
  }
  _l105:;
  nstart_ = 2;
  goto _l108;
  _l106:;
  nstart_ = 2;
  _l107:;
  nstop_ = np1_;
  _l108:;
  nunk_ = nstop_ - nstart_ + 1;
  id2_ = munk_;
  id3_ = id2_ + munk_;
  id4_ = id3_ + munk_;
  id5_ = id4_ + munk_;
  id6_ = id5_ + munk_;
  istart_ = 1;
  a1_ = 2.0 / dlrsq_;
  ij_ = 0;
  if ((*mbdcnd_) == 3 || (*mbdcnd_) == 4) {
    ij_ = 1;
  }
  if ((*mbdcnd_) <= 4) {
    goto _l109;
  }
  w_[0] = 0.0;
  w_[id2_ + 1 - 1] = -2.0 * a1_;
  w_[id3_ + 1 - 1] = 2.0 * a1_;
  istart_ = 2;
  ij_ = 1;
  _l109:;
  for (i_ = istart_; i_ <= munk_; (i_)++) {
    r_ = (*a_) + (i_ - ij_) * deltar_;
    j_ = id5_ + i_;
    w_[j_ - 1] = r_;
    j_ = id6_ + i_;
    w_[j_ - 1] = 1.0 / (r_ * r_);
    w_[i_ - 1] = (r_ - dlrby2_) / (r_ * dlrsq_);
    j_ = id3_ + i_;
    w_[j_ - 1] = (r_ + dlrby2_) / (r_ * dlrsq_);
    k_ = id6_ + i_;
    j_ = id2_ + i_;
    w_[j_ - 1] = -a1_ + (*elmbda_) * w_[k_ - 1];
  }
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l114;
    case 2: goto _l111;
    case 3: goto _l112;
    case 4: goto _l113;
    case 5: goto _l114;
    case 6: goto _l112;
  }
  _l111:;
  w_[id2_ - 1] = a1_;
  goto _l114;
  _l112:;
  w_[id2_ - 1] = a1_;
  _l113:;
  w_[id3_ + 1 - 1] = a1_ * istart_;
  _l114:;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l115;
    case 2: goto _l115;
    case 3: goto _l117;
    case 4: goto _l117;
    case 5: goto _l119;
    case 6: goto _l119;
  }
  _l115:;
  a1_ = w_[0];
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[1 + ((*idimf_)) * ((j_ - 1))] = f_[1 + ((*idimf_)) * ((j_ - 1))] - a1_ * f_[0 + ((*idimf_)) * ((j_ - 1))];
  }
  goto _l119;
  _l117:;
  a1_ = 2.0 * deltar_ * w_[0];
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] + a1_ * bda_[j_ - 1];
  }
  _l119:;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l120;
    case 2: goto _l122;
    case 3: goto _l122;
    case 4: goto _l120;
    case 5: goto _l120;
    case 6: goto _l122;
  }
  _l120:;
  a1_ = w_[id4_ - 1];
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * f_[mp1_ - 1 + ((*idimf_)) * 
    ((j_ - 1))];
  }
  goto _l124;
  _l122:;
  a1_ = 2.0 * deltar_ * w_[id4_ - 1];
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[mp1_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[mp1_ - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * bdb_[j_ - 1];
  }
  _l124:;
  a1_ = 1.0 / dlthsq_;
  l_ = id5_ - mstart_ + 1;
  switch (np_) {
    default:
    case 1: goto _l134;
    case 2: goto _l125;
    case 3: goto _l125;
    case 4: goto _l127;
    case 5: goto _l127;
  }
  _l125:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((1))] = f_[i_ - 1 + ((*idimf_)) * ((1))] - a1_ * f_[i_ - 1 + ((*idimf_)) * ((0))];
  }
  goto _l129;
  _l127:;
  a1_ = 2.0 / deltht_;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] + a1_ * bdc_[i_ - 1];
  }
  _l129:;
  a1_ = 1.0 / dlthsq_;
  switch (np_) {
    default:
    case 1: goto _l134;
    case 2: goto _l130;
    case 3: goto _l132;
    case 4: goto _l132;
    case 5: goto _l130;
  }
  _l130:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - a1_ * f_[i_ - 1 + ((*idimf_)) * 
    ((np1_ - 1))];
  }
  goto _l134;
  _l132:;
  a1_ = 2.0 / deltht_;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] - a1_ * bdd_[i_ - 1];
  }
  _l134:;
  (*pertrb_) = 0.0;
  $0_ = (*elmbda_);
  if ($0_ < 0) {
    goto _l146;
  } else if ($0_ == 0) {
    goto _l136;
  } else {
    goto _l135;
  }
  _l135:;
  (*ierror_) = 11;
  goto _l146;
  _l136:;
  w_[id5_ + 1 - 1] = .5 * (w_[id5_ + 2 - 1] - dlrby2_);
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l146;
    case 2: goto _l146;
    case 3: goto _l138;
    case 4: goto _l146;
    case 5: goto _l146;
    case 6: goto _l137;
  }
  _l137:;
  w_[id5_ + 1 - 1] = .5 * w_[id5_ + 1 - 1];
  _l138:;
  switch (np_) {
    default:
    case 1: goto _l140;
    case 2: goto _l146;
    case 3: goto _l146;
    case 4: goto _l139;
    case 5: goto _l146;
  }
  _l139:;
  a2_ = 2.0;
  goto _l141;
  _l140:;
  a2_ = 1.0;
  _l141:;
  k_ = id5_ + munk_;
  w_[k_ - 1] = .5 * (w_[k_ - 1 - 1] + dlrby2_);
  s_ = 0.0;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    s1_ = 0.0;
    nsp1_ = nstart_ + 1;
    nstm1_ = nstop_ - 1;
    for (j_ = nsp1_; j_ <= nstm1_; (j_)++) {
      s1_ = s1_ + f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
    k_ = i_ + l_;
    s_ = s_ + (a2_ * s1_ + f_[i_ - 1 + ((*idimf_)) * ((nstart_ - 1))] + f_[i_ - 1 + ((*idimf_)) * ((nstop_ - 1))]) * w_[k_ 
    - 1];
  }
  s2_ = (*m_) * (*a_) + (.75 + ((*m_) - 1) * ((*m_) + 1)) * dlrby2_;
  if ((*mbdcnd_) == 3) {
    s2_ = s2_ + .25 * dlrby2_;
  }
  s1_ = (2.0 + a2_ * (nunk_ - 2)) * s2_;
  (*pertrb_) = s_ / s1_;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    for (j_ = nstart_; j_ <= nstop_; (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] - (*pertrb_);
    }
  }
  _l146:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    k_ = i_ - mstart_ + 1;
    w_[k_ - 1] = w_[k_ - 1] * dlthsq_;
    j_ = id2_ + k_;
    w_[j_ - 1] = w_[j_ - 1] * dlthsq_;
    j_ = id3_ + k_;
    w_[j_ - 1] = w_[j_ - 1] * dlthsq_;
    for (j_ = nstart_; j_ <= nstop_; (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] * dlthsq_;
    }
  }
  w_[0] = 0.0;
  w_[id4_ - 1] = 0.0;
  (void) _genbun (nbdcnd_, &nunk_, &_k1, &munk_, &w_[0], &w_[id2_ + 1 - 1], &w_[id3_ + 1 - 1], idimf_, &f_[mstart_ - 1 + 
  ((*idimf_)) * ((nstart_ - 1))], &ierr1_, &w_[id4_ + 1 - 1]);
  w_[0] = w_[id4_ + 1 - 1] + 3 * munk_;
  if ((*nbdcnd_) != 0) {
    goto _l150;
  }
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((0))];
  }
  _l150:;
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _hwsplr (real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 _p_ bdb_, real_4 
_p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, real_4 _p_ elmbda_, real_4 
_p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 mp1_, np1_, np_, mstart_, mstop_, munk_, nstart_, nstop_, nunk_, id2_, id3_, id4_, id5_, id6_, ij_, i_, j_
  , l_, lp_, k_, ierr1_, iwstor_, ip_;
  static real_4 deltar_, dlrby2_, dlrsq_, deltht_, dlthsq_, a1_, r_, s2_, a2_, s_, s1_, ypole_;
  real_4 $0_;
  (*ierror_) = 0;
  if ((*a_) < 0.0) {
    (*ierror_) = 1;
  }
  if ((*a_) >= (*b_)) {
    (*ierror_) = 2;
  }
  if ((*mbdcnd_) <= 0 || (*mbdcnd_) >= 7) {
    (*ierror_) = 3;
  }
  if ((*c_) >= (*d_)) {
    (*ierror_) = 4;
  }
  if ((*n_) <= 3) {
    (*ierror_) = 5;
  }
  if ((*nbdcnd_) <= -1 || (*nbdcnd_) >= 5) {
    (*ierror_) = 6;
  }
  if ((*a_) == 0.0 && ((*mbdcnd_) == 3 || (*mbdcnd_) == 4)) {
    (*ierror_) = 7;
  }
  if ((*a_) > 0.0 && (*mbdcnd_) >= 5) {
    (*ierror_) = 8;
  }
  if ((*mbdcnd_) >= 5 && (*nbdcnd_) != 0 && (*nbdcnd_) != 3) {
    (*ierror_) = 9;
  }
  if ((*idimf_) < (*m_) + 1) {
    (*ierror_) = 10;
  }
  if ((*m_) <= 3) {
    (*ierror_) = 12;
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  mp1_ = (*m_) + 1;
  deltar_ = ((*b_) - (*a_)) / (*m_);
  dlrby2_ = deltar_ / 2.0;
  dlrsq_ = (deltar_ * deltar_);
  np1_ = (*n_) + 1;
  deltht_ = ((*d_) - (*c_)) / (*n_);
  dlthsq_ = (deltht_ * deltht_);
  np_ = (*nbdcnd_) + 1;
  mstart_ = 2;
  mstop_ = mp1_;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l101;
    case 2: goto _l105;
    case 3: goto _l102;
    case 4: goto _l103;
    case 5: goto _l104;
    case 6: goto _l105;
  }
  _l101:;
  mstop_ = (*m_);
  goto _l105;
  _l102:;
  mstart_ = 1;
  goto _l105;
  _l103:;
  mstart_ = 1;
  _l104:;
  mstop_ = (*m_);
  _l105:;
  munk_ = mstop_ - mstart_ + 1;
  nstart_ = 1;
  nstop_ = (*n_);
  switch (np_) {
    default:
    case 1: goto _l109;
    case 2: goto _l106;
    case 3: goto _l107;
    case 4: goto _l108;
    case 5: goto _l109;
  }
  _l106:;
  nstart_ = 2;
  goto _l109;
  _l107:;
  nstart_ = 2;
  _l108:;
  nstop_ = np1_;
  _l109:;
  nunk_ = nstop_ - nstart_ + 1;
  id2_ = munk_;
  id3_ = id2_ + munk_;
  id4_ = id3_ + munk_;
  id5_ = id4_ + munk_;
  id6_ = id5_ + munk_;
  a1_ = 2.0 / dlrsq_;
  ij_ = 0;
  if ((*mbdcnd_) == 3 || (*mbdcnd_) == 4) {
    ij_ = 1;
  }
  for (i_ = 1; i_ <= munk_; (i_)++) {
    r_ = (*a_) + (i_ - ij_) * deltar_;
    j_ = id5_ + i_;
    w_[j_ - 1] = r_;
    j_ = id6_ + i_;
    w_[j_ - 1] = 1.0 / (r_ * r_);
    w_[i_ - 1] = (r_ - dlrby2_) / (r_ * dlrsq_);
    j_ = id3_ + i_;
    w_[j_ - 1] = (r_ + dlrby2_) / (r_ * dlrsq_);
    j_ = id2_ + i_;
    w_[j_ - 1] = -a1_ + (*elmbda_);
  }
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l114;
    case 2: goto _l111;
    case 3: goto _l112;
    case 4: goto _l113;
    case 5: goto _l114;
    case 6: goto _l111;
  }
  _l111:;
  w_[id2_ - 1] = a1_;
  goto _l114;
  _l112:;
  w_[id2_ - 1] = a1_;
  _l113:;
  w_[id3_ + 1 - 1] = a1_;
  _l114:;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l115;
    case 2: goto _l115;
    case 3: goto _l117;
    case 4: goto _l117;
    case 5: goto _l119;
    case 6: goto _l119;
  }
  _l115:;
  a1_ = w_[0];
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[1 + ((*idimf_)) * ((j_ - 1))] = f_[1 + ((*idimf_)) * ((j_ - 1))] - a1_ * f_[0 + ((*idimf_)) * ((j_ - 1))];
  }
  goto _l119;
  _l117:;
  a1_ = 2.0 * deltar_ * w_[0];
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = f_[0 + ((*idimf_)) * ((j_ - 1))] + a1_ * bda_[j_ - 1];
  }
  _l119:;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l120;
    case 2: goto _l122;
    case 3: goto _l122;
    case 4: goto _l120;
    case 5: goto _l120;
    case 6: goto _l122;
  }
  _l120:;
  a1_ = w_[id4_ - 1];
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] = f_[(*m_) - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * f_[mp1_ - 1 + ((*idimf_)) * 
    ((j_ - 1))];
  }
  goto _l124;
  _l122:;
  a1_ = 2.0 * deltar_ * w_[id4_ - 1];
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    f_[mp1_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[mp1_ - 1 + ((*idimf_)) * ((j_ - 1))] - a1_ * bdb_[j_ - 1];
  }
  _l124:;
  a1_ = 1.0 / dlthsq_;
  l_ = id5_ - mstart_ + 1;
  lp_ = id6_ - mstart_ + 1;
  switch (np_) {
    default:
    case 1: goto _l134;
    case 2: goto _l125;
    case 3: goto _l125;
    case 4: goto _l127;
    case 5: goto _l127;
  }
  _l125:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    j_ = i_ + lp_;
    f_[i_ - 1 + ((*idimf_)) * ((1))] = f_[i_ - 1 + ((*idimf_)) * ((1))] - a1_ * w_[j_ - 1] * f_[i_ - 1 + ((*idimf_)) * 
    ((0))];
  }
  goto _l129;
  _l127:;
  a1_ = 2.0 / deltht_;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    j_ = i_ + lp_;
    f_[i_ - 1 + ((*idimf_)) * ((0))] = f_[i_ - 1 + ((*idimf_)) * ((0))] + a1_ * w_[j_ - 1] * bdc_[i_ - 1];
  }
  _l129:;
  a1_ = 1.0 / dlthsq_;
  switch (np_) {
    default:
    case 1: goto _l134;
    case 2: goto _l130;
    case 3: goto _l132;
    case 4: goto _l132;
    case 5: goto _l130;
  }
  _l130:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    j_ = i_ + lp_;
    f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] = f_[i_ - 1 + ((*idimf_)) * (((*n_) - 1))] - a1_ * w_[j_ - 1] * f_[i_ - 1 + 
    ((*idimf_)) * ((np1_ - 1))];
  }
  goto _l134;
  _l132:;
  a1_ = 2.0 / deltht_;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    j_ = i_ + lp_;
    f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] - a1_ * w_[j_ - 1] * bdd_[i_ - 1];
  }
  _l134:;
  if ((*mbdcnd_) >= 5 && (*nbdcnd_) == 3) {
    f_[0 + ((*idimf_)) * ((0))] = f_[0 + ((*idimf_)) * ((0))] - (bdd_[1] - bdc_[1]) * 4.0 / ((*n_) * deltht_ * dlrsq_);
  }
  (*pertrb_) = 0.0;
  $0_ = (*elmbda_);
  if ($0_ < 0) {
    goto _l144;
  } else if ($0_ == 0) {
    goto _l136;
  } else {
    goto _l135;
  }
  _l135:;
  (*ierror_) = 11;
  goto _l144;
  _l136:;
  if ((*nbdcnd_) != 0 && (*nbdcnd_) != 3) {
    goto _l144;
  }
  s2_ = 0.0;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l144;
    case 2: goto _l144;
    case 3: goto _l137;
    case 4: goto _l144;
    case 5: goto _l144;
    case 6: goto _l138;
  }
  _l137:;
  w_[id5_ + 1 - 1] = .5 * (w_[id5_ + 2 - 1] - dlrby2_);
  s2_ = .25 * deltar_;
  _l138:;
  a2_ = 2.0;
  if ((*nbdcnd_) == 0) {
    a2_ = 1.0;
  }
  j_ = id5_ + munk_;
  w_[j_ - 1] = .5 * (w_[j_ - 1 - 1] + dlrby2_);
  s_ = 0.0;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    s1_ = 0.0;
    ij_ = nstart_ + 1;
    k_ = nstop_ - 1;
    for (j_ = ij_; j_ <= k_; (j_)++) {
      s1_ = s1_ + f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
    j_ = i_ + l_;
    s_ = s_ + (a2_ * s1_ + f_[i_ - 1 + ((*idimf_)) * ((nstart_ - 1))] + f_[i_ - 1 + ((*idimf_)) * ((nstop_ - 1))]) * w_[j_ 
    - 1];
  }
  s2_ = (*m_) * (*a_) + deltar_ * (((*m_) - 1) * ((*m_) + 1) * .5 + .25) + s2_;
  s1_ = (2.0 + a2_ * (nunk_ - 2)) * s2_;
  if ((*mbdcnd_) == 3) {
    goto _l141;
  }
  s2_ = (*n_) * a2_ * deltar_ / 8.0;
  s_ = s_ + f_[0 + ((*idimf_)) * ((0))] * s2_;
  s1_ = s1_ + s2_;
  _l141:;
  (*pertrb_) = s_ / s1_;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    for (j_ = nstart_; j_ <= nstop_; (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] - (*pertrb_);
    }
  }
  _l144:;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    k_ = i_ - mstart_ + 1;
    j_ = i_ + lp_;
    a1_ = dlthsq_ / w_[j_ - 1];
    w_[k_ - 1] = a1_ * w_[k_ - 1];
    j_ = id2_ + k_;
    w_[j_ - 1] = a1_ * w_[j_ - 1];
    j_ = id3_ + k_;
    w_[j_ - 1] = a1_ * w_[j_ - 1];
    for (j_ = nstart_; j_ <= nstop_; (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = a1_ * f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))];
    }
  }
  w_[0] = 0.0;
  w_[id4_ - 1] = 0.0;
  (void) _genbun (nbdcnd_, &nunk_, &_k1, &munk_, &w_[0], &w_[id2_ + 1 - 1], &w_[id3_ + 1 - 1], idimf_, &f_[mstart_ - 1 + 
  ((*idimf_)) * ((nstart_ - 1))], &ierr1_, &w_[id4_ + 1 - 1]);
  iwstor_ = w_[id4_ + 1 - 1] + 3 * munk_;
  switch ((*mbdcnd_)) {
    default:
    case 1: goto _l157;
    case 2: goto _l157;
    case 3: goto _l157;
    case 4: goto _l157;
    case 5: goto _l148;
    case 6: goto _l147;
  }
  _l147:;
  if ((*elmbda_) != 0.0) {
    goto _l148;
  }
  ypole_ = 0.0;
  goto _l155;
  _l148:;
  j_ = id5_ + munk_;
  w_[j_ - 1] = w_[id2_ - 1] / w_[id3_ - 1];
  for (ip_ = 3; ip_ <= munk_; (ip_)++) {
    i_ = munk_ - ip_ + 2;
    j_ = id5_ + i_;
    lp_ = id2_ + i_;
    k_ = id3_ + i_;
    w_[j_ - 1] = w_[i_ - 1] / (w_[lp_ - 1] - w_[k_ - 1] * w_[j_ + 1 - 1]);
  }
  w_[id5_ + 1 - 1] = -.5 * dlthsq_ / (w_[id2_ + 1 - 1] - w_[id3_ + 1 - 1] * w_[id5_ + 2 - 1]);
  for (i_ = 2; i_ <= munk_; (i_)++) {
    j_ = id5_ + i_;
    w_[j_ - 1] = -w_[j_ - 1] * w_[j_ - 1 - 1];
  }
  s_ = 0.0;
  for (j_ = nstart_; j_ <= nstop_; (j_)++) {
    s_ = s_ + f_[1 + ((*idimf_)) * ((j_ - 1))];
  }
  a2_ = nunk_;
  if ((*nbdcnd_) == 0) {
    goto _l152;
  }
  s_ = s_ - .5 * (f_[1 + ((*idimf_)) * ((nstart_ - 1))] + f_[1 + ((*idimf_)) * ((nstop_ - 1))]);
  a2_ = a2_ - 1.0;
  _l152:;
  ypole_ = (.25 * dlrsq_ * f_[0 + ((*idimf_)) * ((0))] - s_ / a2_) / (w_[id5_ + 1 - 1] - 1.0 + (*elmbda_) * dlrsq_ * .25)
  ;
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    k_ = l_ + i_;
    for (j_ = nstart_; j_ <= nstop_; (j_)++) {
      f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((j_ - 1))] + ypole_ * w_[k_ - 1];
    }
  }
  _l155:;
  for (j_ = 1; j_ <= np1_; (j_)++) {
    f_[0 + ((*idimf_)) * ((j_ - 1))] = ypole_;
  }
  _l157:;
  if ((*nbdcnd_) != 0) {
    goto _l159;
  }
  for (i_ = mstart_; i_ <= mstop_; (i_)++) {
    f_[i_ - 1 + ((*idimf_)) * ((np1_ - 1))] = f_[i_ - 1 + ((*idimf_)) * ((0))];
  }
  _l159:;
  w_[0] = iwstor_;
  _l0:;
  __calls[13].calls++;
  return 0;
}

int_4 _hwsssp (real_4 _p_ ts_, real_4 _p_ tf_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bdts_, real_4 _p_ bdtf_, 
real_4 _p_ ps_, real_4 _p_ pf_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdps_, real_4 _p_ bdpf_, real_4 _p_ elmbda_
, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static real_4 pi_, dum_, tpi_;
  extern real_4 _pimach ();
  pi_ = _pimach (&dum_);
  tpi_ = 2.0 * pi_;
  (*ierror_) = 0;
  if ((*ts_) < 0.0 || (*tf_) > pi_) {
    (*ierror_) = 1;
  }
  if ((*ts_) >= (*tf_)) {
    (*ierror_) = 2;
  }
  if ((*mbdcnd_) < 1 || (*mbdcnd_) > 9) {
    (*ierror_) = 3;
  }
  if ((*ps_) < 0.0 || (*pf_) > tpi_) {
    (*ierror_) = 4;
  }
  if ((*ps_) >= (*pf_)) {
    (*ierror_) = 5;
  }
  if ((*n_) < 5) {
    (*ierror_) = 6;
  }
  if ((*m_) < 5) {
    (*ierror_) = 7;
  }
  if ((*nbdcnd_) < 0 || (*nbdcnd_) > 4) {
    (*ierror_) = 8;
  }
  if ((*elmbda_) > 0.0) {
    (*ierror_) = 9;
  }
  if ((*idimf_) < (*m_) + 1) {
    (*ierror_) = 10;
  }
  if (((*nbdcnd_) == 1 || (*nbdcnd_) == 2 || (*nbdcnd_) == 4) && (*mbdcnd_) >= 5) {
    (*ierror_) = 11;
  }
  if ((*ts_) == 0.0 && ((*mbdcnd_) == 3 || (*mbdcnd_) == 4 || (*mbdcnd_) == 8)) {
    (*ierror_) = 12;
  }
  if ((*tf_) == pi_ && ((*mbdcnd_) == 2 || (*mbdcnd_) == 3 || (*mbdcnd_) == 6)) {
    (*ierror_) = 13;
  }
  if (((*mbdcnd_) == 5 || (*mbdcnd_) == 6 || (*mbdcnd_) == 9) && (*ts_) != 0.0) {
    (*ierror_) = 14;
  }
  if ((*mbdcnd_) >= 7 && (*tf_) != pi_) {
    (*ierror_) = 15;
  }
  if ((*ierror_) != 0 && (*ierror_) != 9) {
    goto _l0;
  }
  (void) _hwsss1 (ts_, tf_, m_, mbdcnd_, bdts_, bdtf_, ps_, pf_, n_, nbdcnd_, bdps_, bdpf_, elmbda_, f_, idimf_, pertrb_, 
  w_, &w_[(*m_) + 2 - 1], &w_[2 * (*m_) + 3 - 1], &w_[3 * (*m_) + 4 - 1], &w_[4 * (*m_) + 5 - 1], &w_[5 * (*m_) + 6 - 1], 
  &w_[6 * (*m_) + 7 - 1]);
  w_[0] = w_[6 * (*m_) + 7 - 1] + 6 * ((*m_) + 1);
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _pois3d (int_4 _p_ lperod_, int_4 _p_ l_, real_4 _p_ c1_, int_4 _p_ mperod_, int_4 _p_ m_, real_4 _p_ c2_, int_4 
_p_ nperod_, int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, int_4 _p_ ldimf_, int_4 _p_ mdimf_, real_4 _p_ 
f_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 lp_, mp_, np_, k_, iwyrt_, iwt_, iwd_, iwbb_, iwx_, iwy_, nh_, nhm1_, nodd_, i_, j_, nhpk_, nhmk_;
  static real_4 savev_[6];
  int_4 $0_;
  lp_ = (*lperod_) + 1;
  mp_ = (*mperod_) + 1;
  np_ = (*nperod_) + 1;
  (*ierror_) = 0;
  if (lp_ < 1 || lp_ > 5) {
    (*ierror_) = 1;
  }
  if ((*l_) < 3) {
    (*ierror_) = 2;
  }
  if (mp_ < 1 || mp_ > 5) {
    (*ierror_) = 3;
  }
  if ((*m_) < 3) {
    (*ierror_) = 4;
  }
  if (np_ < 1 || np_ > 2) {
    (*ierror_) = 5;
  }
  if ((*n_) < 3) {
    (*ierror_) = 6;
  }
  if ((*ldimf_) < (*l_)) {
    (*ierror_) = 7;
  }
  if ((*mdimf_) < (*m_)) {
    (*ierror_) = 8;
  }
  if (np_ != 1) {
    goto _l103;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (a_[k_ - 1] != c_[0]) {
      goto _l102;
    }
    if (c_[k_ - 1] != c_[0]) {
      goto _l102;
    }
    if (b_[k_ - 1] != b_[0]) {
      goto _l102;
    }
  }
  goto _l104;
  _l102:;
  (*ierror_) = 9;
  _l103:;
  if ((*nperod_) == 1 && (a_[0] != 0.0 || c_[(*n_) - 1] != 0.0)) {
    (*ierror_) = 10;
  }
  _l104:;
  if ((*ierror_) != 0) {
    goto _l122;
  }
  iwyrt_ = (*l_) + 1;
  iwt_ = iwyrt_ + (*m_);
  iwd_ = iwt_ + ($0_ = _max ((*l_), (*m_)), _max ($0_, (*n_))) + 1;
  iwbb_ = iwd_ + (*n_);
  iwx_ = iwbb_ + (*n_);
  iwy_ = iwx_ + 7 * (((*l_) + 1) / 2) + 15;
  switch (np_) {
    default:
    case 1: goto _l105;
    case 2: goto _l114;
  }
  _l105:;
  nh_ = ((*n_) + 1) / 2;
  nhm1_ = nh_ - 1;
  nodd_ = 1;
  if (2 * nh_ == (*n_)) {
    nodd_ = 2;
  }
  for (i_ = 1; i_ <= (*l_); (i_)++) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (k_ = 1; k_ <= nhm1_; (k_)++) {
        nhpk_ = nh_ + k_;
        nhmk_ = nh_ - k_;
        w_[k_ - 1] = f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((nhmk_ - 1)))] - f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) 
        + ((*mdimf_)) * ((nhpk_ - 1)))];
        w_[nhpk_ - 1] = f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((nhmk_ - 1)))] + f_[i_ - 1 + ((*ldimf_)) * ((j_ - 
        1) + ((*mdimf_)) * ((nhpk_ - 1)))];
      }
      w_[nh_ - 1] = 2.0 * f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((nh_ - 1)))];
      switch (nodd_) {
        default:
        case 1: goto _l108;
        case 2: goto _l107;
      }
      _l107:;
      w_[(*n_) - 1] = 2.0 * f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * (((*n_) - 1)))];
      _l108:;
      for (k_ = 1; k_ <= (*n_); (k_)++) {
        f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = w_[k_ - 1];
      }
    }
  }
  savev_[0] = c_[nhm1_ - 1];
  savev_[1] = a_[nh_ - 1];
  savev_[2] = c_[nh_ - 1];
  savev_[3] = b_[nhm1_ - 1];
  savev_[4] = b_[(*n_) - 1];
  savev_[5] = a_[(*n_) - 1];
  c_[nhm1_ - 1] = 0.0;
  a_[nh_ - 1] = 0.0;
  c_[nh_ - 1] = 2.0 * c_[nh_ - 1];
  switch (nodd_) {
    default:
    case 1: goto _l112;
    case 2: goto _l113;
  }
  _l112:;
  b_[nhm1_ - 1] = b_[nhm1_ - 1] - a_[nh_ - 1 - 1];
  b_[(*n_) - 1] = b_[(*n_) - 1] + a_[(*n_) - 1];
  goto _l114;
  _l113:;
  a_[(*n_) - 1] = c_[nh_ - 1];
  _l114:;
  (void) _pos3d1 (&lp_, l_, &mp_, m_, n_, a_, b_, c_, ldimf_, mdimf_, f_, w_, &w_[iwyrt_ - 1], &w_[iwt_ - 1], &w_[iwd_ - 
  1], &w_[iwx_ - 1], &w_[iwy_ - 1], c1_, c2_, &w_[iwbb_ - 1]);
  switch (np_) {
    default:
    case 1: goto _l115;
    case 2: goto _l122;
  }
  _l115:;
  for (i_ = 1; i_ <= (*l_); (i_)++) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (k_ = 1; k_ <= nhm1_; (k_)++) {
        nhmk_ = nh_ - k_;
        nhpk_ = nh_ + k_;
        w_[nhmk_ - 1] = .5 * (f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((nhpk_ - 1)))] + f_[i_ - 1 + ((*ldimf_)) * 
        ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))]);
        w_[nhpk_ - 1] = .5 * (f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((nhpk_ - 1)))] - f_[i_ - 1 + ((*ldimf_)) * 
        ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))]);
      }
      w_[nh_ - 1] = .5 * f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((nh_ - 1)))];
      switch (nodd_) {
        default:
        case 1: goto _l118;
        case 2: goto _l117;
      }
      _l117:;
      w_[(*n_) - 1] = .5 * f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * (((*n_) - 1)))];
      _l118:;
      for (k_ = 1; k_ <= (*n_); (k_)++) {
        f_[i_ - 1 + ((*ldimf_)) * ((j_ - 1) + ((*mdimf_)) * ((k_ - 1)))] = w_[k_ - 1];
      }
    }
  }
  c_[nhm1_ - 1] = savev_[0];
  a_[nh_ - 1] = savev_[1];
  c_[nh_ - 1] = savev_[2];
  b_[nhm1_ - 1] = savev_[3];
  b_[(*n_) - 1] = savev_[4];
  a_[(*n_) - 1] = savev_[5];
  _l122:;
  __calls[15].calls++;
  return 0;
}

int_4 _poistg (int_4 _p_ nperod_, int_4 _p_ n_, int_4 _p_ mperod_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 
_p_ c_, int_4 _p_ idimy_, real_4 _p_ y_, int_4 _p_ ierror_, real_4 _p_ w_)
{
  static int_4 i_, iwba_, iwbb_, iwbc_, iwb2_, iwb3_, iww1_, iww2_, iww3_, iwd_, iwtcos_, iwp_, k_, j_, np_, mp_, ipstor_
  , irev_, mh_, mhm1_, modd_, mhpi_, mhmi_, nby2_, mskip_;
  static real_4 a1_;
  (*ierror_) = 0;
  if ((*m_) <= 2) {
    (*ierror_) = 1;
  }
  if ((*n_) <= 2) {
    (*ierror_) = 2;
  }
  if ((*idimy_) < (*m_)) {
    (*ierror_) = 3;
  }
  if ((*nperod_) < 1 || (*nperod_) > 4) {
    (*ierror_) = 4;
  }
  if ((*mperod_) < 0 || (*mperod_) > 1) {
    (*ierror_) = 5;
  }
  if ((*mperod_) == 1) {
    goto _l103;
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    if (a_[i_ - 1] != c_[0]) {
      goto _l102;
    }
    if (c_[i_ - 1] != c_[0]) {
      goto _l102;
    }
    if (b_[i_ - 1] != b_[0]) {
      goto _l102;
    }
  }
  goto _l104;
  _l102:;
  (*ierror_) = 6;
  goto _l0;
  _l103:;
  if (a_[0] != 0.0 || c_[(*m_) - 1] != 0.0) {
    (*ierror_) = 7;
  }
  _l104:;
  if ((*ierror_) != 0) {
    goto _l0;
  }
  iwba_ = (*m_) + 1;
  iwbb_ = iwba_ + (*m_);
  iwbc_ = iwbb_ + (*m_);
  iwb2_ = iwbc_ + (*m_);
  iwb3_ = iwb2_ + (*m_);
  iww1_ = iwb3_ + (*m_);
  iww2_ = iww1_ + (*m_);
  iww3_ = iww2_ + (*m_);
  iwd_ = iww3_ + (*m_);
  iwtcos_ = iwd_ + (*m_);
  iwp_ = iwtcos_ + 4 * (*n_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    k_ = iwba_ + i_ - 1;
    w_[k_ - 1] = -a_[i_ - 1];
    k_ = iwbc_ + i_ - 1;
    w_[k_ - 1] = -c_[i_ - 1];
    k_ = iwbb_ + i_ - 1;
    w_[k_ - 1] = 2.0 - b_[i_ - 1];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = -y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))];
    }
  }
  np_ = (*nperod_);
  mp_ = (*mperod_) + 1;
  switch (mp_) {
    default:
    case 1: goto _l110;
    case 2: goto _l107;
  }
  _l107:;
  switch ((*nperod_)) {
    default:
    case 1: goto _l108;
    case 2: goto _l108;
    case 3: goto _l108;
    case 4: goto _l119;
  }
  _l108:;
  (void) _postg2 (&np_, n_, m_, &w_[iwba_ - 1], &w_[iwbb_ - 1], &w_[iwbc_ - 1], idimy_, y_, w_, &w_[iwb2_ - 1], &w_[iwb3_ 
  - 1], &w_[iww1_ - 1], &w_[iww2_ - 1], &w_[iww3_ - 1], &w_[iwd_ - 1], &w_[iwtcos_ - 1], &w_[iwp_ - 1]);
  ipstor_ = w_[iww1_ - 1];
  irev_ = 2;
  if ((*nperod_) == 4) {
    goto _l120;
  }
  _l109:;
  switch (mp_) {
    default:
    case 1: goto _l123;
    case 2: goto _l129;
  }
  _l110:;
  mh_ = ((*m_) + 1) / 2;
  mhm1_ = mh_ - 1;
  modd_ = 1;
  if (mh_ * 2 == (*m_)) {
    modd_ = 2;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= mhm1_; (i_)++) {
      mhpi_ = mh_ + i_;
      mhmi_ = mh_ - i_;
      w_[i_ - 1] = y_[mhmi_ - 1 + ((*idimy_)) * ((j_ - 1))] - y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))];
      w_[mhpi_ - 1] = y_[mhmi_ - 1 + ((*idimy_)) * ((j_ - 1))] + y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))];
    }
    w_[mh_ - 1] = 2.0 * y_[mh_ - 1 + ((*idimy_)) * ((j_ - 1))];
    switch (modd_) {
      default:
      case 1: goto _l113;
      case 2: goto _l112;
    }
    _l112:;
    w_[(*m_) - 1] = 2.0 * y_[(*m_) - 1 + ((*idimy_)) * ((j_ - 1))];
    _l113:;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = w_[i_ - 1];
    }
  }
  k_ = iwbc_ + mhm1_ - 1;
  i_ = iwba_ + mhm1_;
  w_[k_ - 1] = 0.0;
  w_[i_ - 1] = 0.0;
  w_[k_ + 1 - 1] = 2.0 * w_[k_ + 1 - 1];
  switch (modd_) {
    default:
    case 1: goto _l116;
    case 2: goto _l117;
  }
  _l116:;
  k_ = iwbb_ + mhm1_ - 1;
  w_[k_ - 1] = w_[k_ - 1] - w_[i_ - 1 - 1];
  w_[iwbc_ - 1 - 1] = w_[iwbc_ - 1 - 1] + w_[iwbb_ - 1 - 1];
  goto _l118;
  _l117:;
  w_[iwbb_ - 1 - 1] = w_[k_ + 1 - 1];
  _l118:;
  goto _l107;
  _l119:;
  irev_ = 1;
  nby2_ = (*n_) / 2;
  np_ = 2;
  _l120:;
  for (j_ = 1; j_ <= nby2_; (j_)++) {
    mskip_ = (*n_) + 1 - j_;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      a1_ = y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))];
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = y_[i_ - 1 + ((*idimy_)) * ((mskip_ - 1))];
      y_[i_ - 1 + ((*idimy_)) * ((mskip_ - 1))] = a1_;
    }
  }
  switch (irev_) {
    default:
    case 1: goto _l108;
    case 2: goto _l109;
  }
  _l123:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = 1; i_ <= mhm1_; (i_)++) {
      mhmi_ = mh_ - i_;
      mhpi_ = mh_ + i_;
      w_[mhmi_ - 1] = .5 * (y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))] + y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))]);
      w_[mhpi_ - 1] = .5 * (y_[mhpi_ - 1 + ((*idimy_)) * ((j_ - 1))] - y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))]);
    }
    w_[mh_ - 1] = .5 * y_[mh_ - 1 + ((*idimy_)) * ((j_ - 1))];
    switch (modd_) {
      default:
      case 1: goto _l126;
      case 2: goto _l125;
    }
    _l125:;
    w_[(*m_) - 1] = .5 * y_[(*m_) - 1 + ((*idimy_)) * ((j_ - 1))];
    _l126:;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y_[i_ - 1 + ((*idimy_)) * ((j_ - 1))] = w_[i_ - 1];
    }
  }
  _l129:;
  w_[0] = ipstor_ + iwp_ - 1;
  _l0:;
  __calls[16].calls++;
  return 0;
}

int_4 _sepeli (int_4 _p_ intl_, int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, 
real_4 _p_ bda_, real_4 _p_ alpha_, real_4 _p_ bdb_, real_4 _p_ beta_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, 
int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ gama_, real_4 _p_ bdd_, real_4 _p_ xnu_, real_4 (*_cofx)(), real_4 
(*_cofy)(), real_4 _p_ grhs_, real_4 _p_ usol_, int_4 _p_ idmn_, real_4 _p_ w_, real_4 _p_ pertrb_, int_4 _p_ ierror_)
{
  static int_4 l_, logb2n_, ll_, k_, length_, linput_, loutpt_, i1_, i2_, i3_, i4_, i5_, i6_, i7_, i8_, i9_, i10_, i11_, 
  i12_, i13_;
  (void) _chkprm (intl_, iorder_, a_, b_, m_, mbdcnd_, c_, d_, n_, nbdcnd_, _cofx, _cofy, idmn_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  l_ = (*n_) + 1;
  if ((*nbdcnd_) == 0) {
    l_ = (*n_);
  }
  logb2n_ = (int_4) (_aintd (logf (l_ + 0.5) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 1;
  ll_ = _up_int_4 (2, (logb2n_ + 1));
  k_ = (*m_) + 1;
  l_ = (*n_) + 1;
  length_ = (logb2n_ - 2) * ll_ + logb2n_ + _max (2 * l_, 6 * k_) + 5;
  if ((*nbdcnd_) == 0) {
    length_ = length_ + 2 * l_;
  }
  (*ierror_) = 11;
  linput_ = (int_4) (_aintd (w_[0] + 0.5));
  loutpt_ = length_ + 6 * (k_ + l_) + 1;
  w_[0] = loutpt_;
  if (loutpt_ > linput_) {
    goto _l0;
  }
  (*ierror_) = 0;
  i1_ = length_ + 2;
  i2_ = i1_ + l_;
  i3_ = i2_ + l_;
  i4_ = i3_ + l_;
  i5_ = i4_ + l_;
  i6_ = i5_ + l_;
  i7_ = i6_ + l_;
  i8_ = i7_ + k_;
  i9_ = i8_ + k_;
  i10_ = i9_ + k_;
  i11_ = i10_ + k_;
  i12_ = i11_ + k_;
  i13_ = 2;
  (void) _spelip (intl_, iorder_, a_, b_, m_, mbdcnd_, bda_, alpha_, bdb_, beta_, c_, d_, n_, nbdcnd_, bdc_, gama_, bdd_, 
  xnu_, _cofx, _cofy, &w_[i1_ - 1], &w_[i2_ - 1], &w_[i3_ - 1], &w_[i4_ - 1], &w_[i5_ - 1], &w_[i6_ - 1], &w_[i7_ - 1], 
  &w_[i8_ - 1], &w_[i9_ - 1], &w_[i10_ - 1], &w_[i11_ - 1], &w_[i12_ - 1], grhs_, usol_, idmn_, &w_[i13_ - 1], pertrb_, 
  ierror_);
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _sepx4 (int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bda_, real_4 
_p_ alpha_, real_4 _p_ bdb_, real_4 _p_ beta_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 
_p_ bdc_, real_4 _p_ bdd_, real_4 (*_cofx)(), real_4 _p_ grhs_, real_4 _p_ usol_, int_4 _p_ idmn_, real_4 _p_ w_, 
real_4 _p_ pertrb_, int_4 _p_ ierror_)
{
  static int_4 l_, k_, log2n_, length_, linput_, loutpt_, i1_, i2_, i3_, i4_, i5_, i6_, i7_, i8_, i9_, i10_, i11_, i12_, 
  i13_;
  (void) _chkpr4 (iorder_, a_, b_, m_, mbdcnd_, c_, d_, n_, nbdcnd_, _cofx, idmn_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  l_ = (*n_) + 1;
  if ((*nbdcnd_) == 0) {
    l_ = (*n_);
  }
  k_ = (*m_) + 1;
  l_ = (*n_) + 1;
  log2n_ = (int_4) (_aintd (logf ((real_4) ((*n_) + 1)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1 + 0.5));
  length_ = 4 * ((*n_) + 1) + (10 + log2n_) * ((*m_) + 1);
  (*ierror_) = 11;
  linput_ = (int_4) (_aintd (w_[0] + 0.5));
  loutpt_ = length_ + 6 * (k_ + l_) + 1;
  w_[0] = loutpt_;
  if (loutpt_ > linput_) {
    goto _l0;
  }
  (*ierror_) = 0;
  i1_ = length_ + 2;
  i2_ = i1_ + l_;
  i3_ = i2_ + l_;
  i4_ = i3_ + l_;
  i5_ = i4_ + l_;
  i6_ = i5_ + l_;
  i7_ = i6_ + l_;
  i8_ = i7_ + k_;
  i9_ = i8_ + k_;
  i10_ = i9_ + k_;
  i11_ = i10_ + k_;
  i12_ = i11_ + k_;
  i13_ = 2;
  (void) _speli4 (iorder_, a_, b_, m_, mbdcnd_, bda_, alpha_, bdb_, beta_, c_, d_, n_, nbdcnd_, bdc_, bdd_, _cofx, 
  &w_[i1_ - 1], &w_[i2_ - 1], &w_[i3_ - 1], &w_[i4_ - 1], &w_[i5_ - 1], &w_[i6_ - 1], &w_[i7_ - 1], &w_[i8_ - 1], &w_[i9_ 
  - 1], &w_[i10_ - 1], &w_[i11_ - 1], &w_[i12_ - 1], grhs_, usol_, idmn_, &w_[i13_ - 1], pertrb_, ierror_);
  _l0:;
  __calls[18].calls++;
  return 0;
}

