//! @file mathlib-fnlib.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 254 subprograms from FNLIB

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// AI     BETA   CASINH CLNREL D9LGIT DBI    DCSEVL DPSIFN R9CHU  ZBINU
// AIE    BETAI  CATAN  CLOG10 D9LGMC DBIE   DDAWS  DSINDG R9GMIC ZBIRY
// ALBETA BFQAD  CATAN2 CMLRI  D9LN2R DBINOM DE1    DSPENC R9GMIT ZBKNU
// ALGAMS BI     CATANH COSDG  D9PAK  DBINT4 DEI    E1     R9KNUS ZBUNI
// ALI    BIE    CBESH  COT    D9UPAK DBINTK DEXINT EI     R9LGIC ZBUNK
// ALNREL BINOM  CBESI  CPSI   DAI    DBKIAS DEXPRL EXINT  R9LGIT ZDIV
// BESI   BINT4  CBESJ  CSERI  DAIE   DBKISR DFAC   EXPREL R9LGMC ZEXP
// BESI0  BINTK  CBESK  CSEVL  DASYJY DBSI0E DGAMI  FAC    R9LN2R ZKSCL
// BESI0E BKIAS  CBESY  CSINH  DAWS   DBSI1E DGAMIC FUNDOC R9PAK  ZLOG
// BESI1  BKISR  CBETA  CTAN   DBESI  DBSK0E DGAMIT GAMI   R9UPAK ZMLRI
// BESI1E BSKIN  CBINU  CTANH  DBESI0 DBSK1E DGAMLM GAMIC  RAND   ZMLT
// BESJ   BSPEV  CBIRY  CUNI1  DBESI1 DBSKES DGAMLN GAMIT  RGAUSS ZRATI
// BESJ0  BSPPP  CBKNU  CUNI2  DBESJ  DBSKIN DGAMR  GAMLIM RUNIF  ZS1S2
// BESJ1  BSPVD  CBRT   CUNK1  DBESJ0 DBSKNU DGAMRN GAMLN  SINDG  ZSERI
// BESK   BSQAD  CBUNI  CUNK2  DBESJ1 DBSPEV DHKSEQ GAMR   SPENC  ZSHCH
// BESK0  BVALU  CBUNK  CUOIK  DBESK  DBSPPP DLBETA INITDS ZABS   ZSQRT
// BESK0E C0LGMC CCBRT  CWRSK  DBESK0 DBSPVD DLGAMS INITS  ZACAI  ZUCHK
// BESK1  C9LGMC CCOSH  D9AIMP DBESK1 DBSQAD DLI    PFQAD  ZACON  ZUNHJ
// BESK1E C9LN2R CCOT   D9ATN1 DBESKS DBSYNU DLNREL POCH   ZAIRY  ZUNI1
// BESKES CACAI  CEXPRL D9B0MP DBESY  DBVALU DPFQAD POCH1  ZASYI  ZUNI2
// BESKNU CACON  CGAMMA D9B1MP DBESY0 DC_90  DPOCH  PPQAD  ZBESH  ZUNIK
// BESKS  CACOS  CGAMR  D9CHU  DBESY1 DCBRT  DPOCH1 PPVAL  ZBESI  ZUNK1
// BESY   CACOSH CHU    D9GMIC DBETA  DCHU   DPPQAD PSI    ZBESJ  ZUNK2
// BESY0  CAIRY  CKSCL  D9GMIT DBETAI DCOSDG DPPVAL R9AIMP ZBESK  ZUOIK
// BESY1  CARG   CLBETA D9KNUS DBFQAD DCOT   DPSI   R9ATN1 ZBESY  ZWRSK
// BESYNU CASIN  CLNGAM D9LGIC

// Routines from SLATEC's AMOSLIB and FNLIB.
// 
// FNLIB is W. Fullerton's special-function package.
// 
// AMOSLIB is D. E. Amos' portable package for Bessel Functions of a 
// Complex Argument and Nonnegative Order.
// 
// Functions that are already in the VIF library have been removed 
// (acos, asin, atan, lngam, erf, ...).
// 
// Source: netlib.org/slatec/

// The license for FNLIB Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "slatec"
#define _dc_1 "ai"
#define _dc_2 "x so big ai underflows"
#define _dc_3 "albeta"
#define _dc_4 "both arguments must be gt zero"
#define _dc_5 "ali"
#define _dc_6 "log integral undefined for x le 0"
#define _dc_7 "log integral undefined for x = 1"
#define _dc_8 "alnrel"
#define _dc_9 "x is le -1"
#define _dc_10 "answer lt half precision because x too near -1"
#define _dc_11 "besi0"
#define _dc_12 "abs(x) so big i0 overflows"
#define _dc_13 "besi1e"
#define _dc_14 "abs(x) so small i1 underflows"
#define _dc_15 "besi1"
#define _dc_16 "abs(x) so big i1 overflows"
#define _dc_17 "besi"
#define _dc_18 "scaling option, kode, not 1 or 2."
#define _dc_19 "order, alpha, less than zero."
#define _dc_20 "n less than one."
#define _dc_21 "x less than zero."
#define _dc_22 "overflow, x too large for kode = 1."
#define _dc_23 "besj0"
#define _dc_24 "no precision because abs(x) is too big"
#define _dc_25 "besj1"
#define _dc_26 "abs(x) so small j1 underflows"
#define _dc_27 "besj"
#define _dc_28 "besk0e"
#define _dc_29 "x is zero or negative"
#define _dc_30 "besk0"
#define _dc_31 "x so big k0 underflows"
#define _dc_32 "besk1e"
#define _dc_33 "x so small k1 overflows"
#define _dc_34 "besk1"
#define _dc_35 "x so big k1 underflows"
#define _dc_36 "beskes"
#define _dc_37 "abs(xnu) must be lt 1"
#define _dc_38 "x is le 0"
#define _dc_39 "n the number in the sequence is 0"
#define _dc_40 "x so small bessel k-sub-xnu+1 overflows"
#define _dc_41 "x so small or abs(nu) so big that bessel k-sub-nu overflows"
#define _dc_42 "besk"
#define _dc_43 "scaling option, kode, not 1 or 2"
#define _dc_44 "order, fnu, less than zero"
#define _dc_45 "x less than or equal to zero"
#define _dc_46 "n less than one"
#define _dc_47 "overflow, fnu or n too large or x too small"
#define _dc_48 "besknu"
#define _dc_49 "x not greater than zero"
#define _dc_50 "fnu not zero or positive"
#define _dc_51 "kode not 1 or 2"
#define _dc_52 "n not greater than 0"
#define _dc_53 "besks"
#define _dc_54 "x so big bessel k underflows"
#define _dc_55 "besy0"
#define _dc_56 "no precision because x is big"
#define _dc_57 "besy1"
#define _dc_58 "x so small y1 overflows"
#define _dc_59 "besy"
#define _dc_60 "besynu"
#define _dc_61 "beta"
#define _dc_62 "both arguments must be gt 0"
#define _dc_63 "a and/or b so big beta underflows"
#define _dc_64 "betai"
#define _dc_65 "x is not in the range (0,1)"
#define _dc_66 "p and/or q is le zero"
#define _dc_67 "bfqad"
#define _dc_68 "x1 or x2 or both do not satisfy t(k).le.x.le.t(n+1)"
#define _dc_69 "tol is less than the single precision tolerance or "
#define _dc_70 "greater than 0.1"
#define _dc_71 "k does not satisfy k.ge.1"
#define _dc_72 "n does not satisfy n.ge.k"
#define _dc_73 "id does not satisfy 0 .le. id .lt. k"
#define _dc_74 "bi"
#define _dc_75 "x so big that bi overflows"
#define _dc_76 "binom"
#define _dc_77 "n or m lt zero"
#define _dc_78 "n lt m"
#define _dc_79 "result overflows because n and/or m too big"
#define _dc_80 "bint4"
#define _dc_81 "the system of equations is singular"
#define _dc_82 "ndata is less than 2"
#define _dc_83 "x values are not distinct or not ordered"
#define _dc_84 "ibcl is not 1 or 2"
#define _dc_85 "ibcr is not 1 or 2"
#define _dc_86 "kntopt is not 1, 2, or 3"
#define _dc_87 "knot input through w array is not ordered properly"
#define _dc_88 "bintk"
#define _dc_89 "some abscissa was not in the support of the corresponding "
#define _dc_90 "basis function and the system is singular."
#define _dc_91 "the system of solver detects a singular system although "
#define _dc_92 "the theoretical conditions for a solution were satisfied."
#define _dc_93 "x(i) does not satisfy x(i).lt.x(i+1) for some i"
#define _dc_94 "bspev"
#define _dc_95 "x is not in t(k).le.x.le.t(n+1)"
#define _dc_96 "nderiv does not satisfy 1.le.nderiv.le.k"
#define _dc_97 "a left limiting value cannot be obtained at t(k)"
#define _dc_98 "bsppp"
#define _dc_99 "ldc does not satisfy ldc.ge.k"
#define _dc_100 "bspvd"
#define _dc_101 "ldvnik does not satisfy ldvnik.ge.k"
#define _dc_102 "bsqad"
#define _dc_103 "k does not satisfy 1.le.k.le.20"
#define _dc_104 "bvalu"
#define _dc_105 "ideriv does not satisfy 0.le.ideriv.lt.k"
#define _dc_106 "x is n0t greater than or equal to t(k)"
#define _dc_107 "x is not less than or equal to t(n+1)"
#define _dc_108 "c9lgmc"
#define _dc_109 "not valid for negative real(z) and small "
#define _dc_110 "abs(aimag(z))"
#define _dc_111 "not valid for small abs(z)"
#define _dc_112 "z so big c9lgmc underflows"
#define _dc_113 "catan2"
#define _dc_114 "called with both arguments zero"
#define _dc_115 "catan"
#define _dc_116 "z is +i or -i"
#define _dc_117 "answer lt half precision, z**2 close to -1"
#define _dc_118 "cbeta"
#define _dc_119 "real part of both arguments must be gt 0"
#define _dc_120 "ccot"
#define _dc_121 "cot is singular for input z (x is 0 or pi and y is 0)"
#define _dc_122 "answer lt half precision, abs(x) too big or x too near "
#define _dc_123 "0 or pi"
#define _dc_124 "chu"
#define _dc_125 "x is zero so chu is infinite"
#define _dc_126 "x is negative, use cchu"
#define _dc_127 "algorithm is bad when 1+a-b is near zero for small x"
#define _dc_128 "no convergence in 1000 terms of the ascending series"
#define _dc_129 "clbeta"
#define _dc_130 "clngam"
#define _dc_131 "z is a negative integer"
#define _dc_132 "answer lt half precision because z too near negative integer"
#define _dc_133 "clnrel"
#define _dc_134 "answer lt half precision because z too near -1"
#define _dc_135 "cot"
#define _dc_136 "abs(x) is zero or so small cot overflows"
#define _dc_137 "answer lt half precision, abs(x) too big or x near n*pi "
#define _dc_138 "(n.ne.0)"
#define _dc_139 "cpsi"
#define _dc_140 "cpsi called with z so near 0 that cpsi overflows"
#define _dc_141 "csevl"
#define _dc_142 "number of terms .le. 0"
#define _dc_143 "number of terms .gt. 1000"
#define _dc_144 "x outside the interval (-1,+1)"
#define _dc_145 "ctan"
#define _dc_146 "tan is singular for input z (x is pi/2 or 3*pi/2 and y is 0)"
#define _dc_147 "pi/2 or 3*pi/2"
#define _dc_148 "d9aimp"
#define _dc_149 "x must be le -1.0"
#define _dc_150 "d9atn1"
#define _dc_151 "no precision in answer because x is too big"
#define _dc_152 "answer lt half precision because x is too big"
#define _dc_153 "d9b0mp"
#define _dc_154 "x must be ge 4"
#define _dc_155 "d9b1mp"
#define _dc_156 "x must be .ge. 4"
#define _dc_157 "no precision because x is too big"
#define _dc_158 "d9chu"
#define _dc_159 "no convergence in 300 terms"
#define _dc_160 "answer lt half precision"
#define _dc_161 "d9gmic"
#define _dc_162 "a must be near a negative integer"
#define _dc_163 "x must be gt zero"
#define _dc_164 "no convergence in 200 terms of continued fraction"
#define _dc_165 "result underflows"
#define _dc_166 "d9gmit"
#define _dc_167 "x should be gt 0"
#define _dc_168 "no convergence in 200 terms of taylor-s series"
#define _dc_169 "d9knus"
#define _dc_170 "xnu must be ge 0 and lt 1"
#define _dc_171 "x must be gt 0"
#define _dc_172 "x so small bessel k-sub-xnu overflows"
#define _dc_173 "d9lgic"
#define _dc_174 "no convergence in 300 terms of continued fraction"
#define _dc_175 "d9lgit"
#define _dc_176 "x should be gt 0.0 and le a"
#define _dc_177 "result less than half precision"
#define _dc_178 "d9lgmc"
#define _dc_179 "x must be ge 10"
#define _dc_180 "x so big d9lgmc underflows"
#define _dc_181 "d9ln2r"
#define _dc_182 "answer lt half precision because x is too near -1"
#define _dc_183 "d9pak"
#define _dc_184 "packed number overflows"
#define _dc_185 "packed number underflows"
#define _dc_186 "dai"
#define _dc_187 "daws"
#define _dc_188 "abs(x) so large daws underflows"
#define _dc_189 "dbesi0"
#define _dc_190 "dbesi1"
#define _dc_191 "dbesi"
#define _dc_192 "dbesj1"
#define _dc_193 "dbesj"
#define _dc_194 "dbesk0"
#define _dc_195 "dbesk1"
#define _dc_196 "dbesk"
#define _dc_197 "dbesks"
#define _dc_198 "dbesy0"
#define _dc_199 "dbesy1"
#define _dc_200 "dbesy"
#define _dc_201 "dbeta"
#define _dc_202 "dbetai"
#define _dc_203 "dbfqad"
#define _dc_204 "tol is less dtol or greater than 0.1"
#define _dc_205 "id does not satisfy 0.le.id.lt.k"
#define _dc_206 "dbi"
#define _dc_207 "dbinom"
#define _dc_208 "dbint4"
#define _dc_209 "dbintk"
#define _dc_210 "dbsi1e"
#define _dc_211 "dbsk0e"
#define _dc_212 "dbsk1e"
#define _dc_213 "dbskes"
#define _dc_214 "x so small or abs(nu) so big that bessel k-sub-nu "
#define _dc_215 "overflows"
#define _dc_216 "dbsknu"
#define _dc_217 "dbspev"
#define _dc_218 "dbsppp"
#define _dc_219 "dbspvd"
#define _dc_220 "dbsqad"
#define _dc_221 "dbsynu"
#define _dc_222 "dbvalu"
#define _dc_223 "dchu"
#define _dc_224 "x is zero so dchu is infinite"
#define _dc_225 "algorithmis bad when 1+a-b is near zero for small x"
#define _dc_226 "dcot"
#define _dc_227 "abs(x) is zero or so small dcot overflows"
#define _dc_228 "dcsevl"
#define _dc_229 "ddaws"
#define _dc_230 "de1"
#define _dc_231 "x is 0"
#define _dc_232 "x so big e1 underflows"
#define _dc_233 "dfac"
#define _dc_234 "factorial of negative integer undefined"
#define _dc_235 "n so big factorial(n) overflows"
#define _dc_236 "dgamic"
#define _dc_237 "x is negative"
#define _dc_238 "x = 0 and a le 0 so dgamic is undefined"
#define _dc_239 "result lt half precision"
#define _dc_240 "dgami"
#define _dc_241 "a must be gt zero"
#define _dc_242 "x must be ge zero"
#define _dc_243 "dgamit"
#define _dc_244 "dgamlm"
#define _dc_245 "unable to find xmin"
#define _dc_246 "unable to find xmax"
#define _dc_247 "dlbeta"
#define _dc_248 "dli"
#define _dc_249 "log integral undefined for x = 0"
#define _dc_250 "dlnrel"
#define _dc_251 "dpfqad"
#define _dc_252 "lxi does not satisfy lxi.ge.1"
#define _dc_253 "dpoch1"
#define _dc_254 "nterms is too big, maybe d1mach(3) is bad"
#define _dc_255 "dpoch"
#define _dc_256 "a+x is non-positive integer but a is not"
#define _dc_257 "dppqad"
#define _dc_258 "dppval"
#define _dc_259 "dpsi"
#define _dc_260 "x is a negative integer"
#define _dc_261 "answer lt half precision because x too near negative integer"
#define _dc_262 "e1"
#define _dc_263 "fac"
#define _dc_264 "gamic"
#define _dc_265 "x = 0 and a le 0 so gamic is undefined"
#define _dc_266 "gami"
#define _dc_267 "gamit"
#define _dc_268 "gamlim"
#define _dc_269 "initds"
#define _dc_270 "number of coefficients is less than 1"
#define _dc_271 "chebyshev series too short for specified accuracy"
#define _dc_272 "inits"
#define _dc_273 "pfqad"
#define _dc_274 "poch1"
#define _dc_275 "nterms is too big, maybe r1mach(3) is bad"
#define _dc_276 "poch"
#define _dc_277 "ppqad"
#define _dc_278 "ppval"
#define _dc_279 "psi"
#define _dc_280 "r9aimp"
#define _dc_281 "r9atn1"
#define _dc_282 "r9chu"
#define _dc_283 "answer less than half precision"
#define _dc_284 "r9gmic"
#define _dc_285 "r9gmit"
#define _dc_286 "r9knus"
#define _dc_287 "r9lgic"
#define _dc_288 "r9lgit"
#define _dc_289 "r9lgmc"
#define _dc_290 "x so big r9lgmc underflows"
#define _dc_291 "r9ln2r"
#define _dc_292 "r9pak"
static FORMAT *__fmt_a = NULL;
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
typedef char char_127[128];
#define __ncalls 254
static CALLS __calls[__ncalls] = {
  {"aie", 0}, // function
  {"ai", 0}, // function
  {"albeta", 0}, // function
  {"algams", 0}, // subroutine
  {"ali", 0}, // function
  {"alnrel", 0}, // function
  {"besi0e", 0}, // function
  {"besi0", 0}, // function
  {"besi1e", 0}, // function
  {"besi1", 0}, // function
  {"besi", 0}, // subroutine
  {"besj0", 0}, // function
  {"besj1", 0}, // function
  {"besj", 0}, // subroutine
  {"besk0e", 0}, // function
  {"besk0", 0}, // function
  {"besk1e", 0}, // function
  {"besk1", 0}, // function
  {"beskes", 0}, // subroutine
  {"besk", 0}, // subroutine
  {"besknu", 0}, // subroutine
  {"besks", 0}, // subroutine
  {"besy0", 0}, // function
  {"besy1", 0}, // function
  {"besy", 0}, // subroutine
  {"besynu", 0}, // subroutine
  {"beta", 0}, // function
  {"betai", 0}, // real*4 function
  {"bfqad", 0}, // subroutine
  {"bie", 0}, // function
  {"bi", 0}, // function
  {"binom", 0}, // function
  {"bint4", 0}, // subroutine
  {"bintk", 0}, // subroutine
  {"bkias", 0}, // subroutine
  {"bkisr", 0}, // subroutine
  {"bskin", 0}, // subroutine
  {"bspev", 0}, // subroutine
  {"bsppp", 0}, // subroutine
  {"bspvd", 0}, // subroutine
  {"bsqad", 0}, // subroutine
  {"bvalu", 0}, // function
  {"c0lgmc", 0}, // complex*8 function
  {"c9lgmc", 0}, // complex*8 function
  {"c9ln2r", 0}, // complex*8 function
  {"cacai", 0}, // subroutine
  {"cacon", 0}, // subroutine
  {"cacos", 0}, // complex*8 function
  {"cacosh", 0}, // complex*8 function
  {"cairy", 0}, // subroutine
  {"carg", 0}, // function
  {"casin", 0}, // complex*8 function
  {"casinh", 0}, // complex*8 function
  {"catan2", 0}, // complex*8 function
  {"catan", 0}, // complex*8 function
  {"catanh", 0}, // complex*8 function
  {"cbesh", 0}, // subroutine
  {"cbesi", 0}, // subroutine
  {"cbesj", 0}, // subroutine
  {"cbesk", 0}, // subroutine
  {"cbesy", 0}, // subroutine
  {"cbeta", 0}, // complex*8 function
  {"cbinu", 0}, // subroutine
  {"cbiry", 0}, // subroutine
  {"cbknu", 0}, // subroutine
  {"cbrt", 0}, // function
  {"cbuni", 0}, // subroutine
  {"cbunk", 0}, // subroutine
  {"ccbrt", 0}, // complex*8 function
  {"ccosh", 0}, // complex*8 function
  {"ccot", 0}, // complex*8 function
  {"cexprl", 0}, // complex*8 function
  {"cgamma", 0}, // complex*8 function
  {"cgamr", 0}, // complex*8 function
  {"chu", 0}, // function
  {"ckscl", 0}, // subroutine
  {"clbeta", 0}, // complex*8 function
  {"clngam", 0}, // complex*8 function
  {"clnrel", 0}, // complex*8 function
  {"clog10", 0}, // complex*8 function
  {"cmlri", 0}, // subroutine
  {"cosdg", 0}, // function
  {"cot", 0}, // function
  {"cpsi", 0}, // complex*8 function
  {"cseri", 0}, // subroutine
  {"csevl", 0}, // function
  {"csinh", 0}, // complex*8 function
  {"ctan", 0}, // complex*8 function
  {"ctanh", 0}, // complex*8 function
  {"cuni1", 0}, // subroutine
  {"cuni2", 0}, // subroutine
  {"cunk1", 0}, // subroutine
  {"cunk2", 0}, // subroutine
  {"cuoik", 0}, // subroutine
  {"cwrsk", 0}, // subroutine
  {"d9aimp", 0}, // subroutine
  {"d9atn1", 0}, // real*8 function
  {"d9b0mp", 0}, // subroutine
  {"d9b1mp", 0}, // subroutine
  {"d9chu", 0}, // real*8 function
  {"d9gmic", 0}, // real*8 function
  {"d9gmit", 0}, // real*8 function
  {"d9knus", 0}, // subroutine
  {"d9lgic", 0}, // real*8 function
  {"d9lgit", 0}, // real*8 function
  {"d9lgmc", 0}, // real*8 function
  {"d9ln2r", 0}, // real*8 function
  {"d9pak", 0}, // real*8 function
  {"d9upak", 0}, // subroutine
  {"daie", 0}, // real*8 function
  {"dai", 0}, // real*8 function
  {"dasyjy", 0}, // subroutine
  {"daws", 0}, // function
  {"dbesi0", 0}, // real*8 function
  {"dbesi1", 0}, // real*8 function
  {"dbesi", 0}, // subroutine
  {"dbesj0", 0}, // real*8 function
  {"dbesj1", 0}, // real*8 function
  {"dbesj", 0}, // subroutine
  {"dbesk0", 0}, // real*8 function
  {"dbesk1", 0}, // real*8 function
  {"dbesk", 0}, // subroutine
  {"dbesks", 0}, // subroutine
  {"dbesy0", 0}, // real*8 function
  {"dbesy1", 0}, // real*8 function
  {"dbesy", 0}, // subroutine
  {"dbeta", 0}, // real*8 function
  {"dbetai", 0}, // real*8 function
  {"dbfqad", 0}, // subroutine
  {"dbie", 0}, // real*8 function
  {"dbi", 0}, // real*8 function
  {"dbinom", 0}, // real*8 function
  {"dbint4", 0}, // subroutine
  {"dbintk", 0}, // subroutine
  {"dbkias", 0}, // subroutine
  {"dbkisr", 0}, // subroutine
  {"dbsi0e", 0}, // real*8 function
  {"dbsi1e", 0}, // real*8 function
  {"dbsk0e", 0}, // real*8 function
  {"dbsk1e", 0}, // real*8 function
  {"dbskes", 0}, // subroutine
  {"dbskin", 0}, // subroutine
  {"dbsknu", 0}, // subroutine
  {"dbspev", 0}, // subroutine
  {"dbsppp", 0}, // subroutine
  {"dbspvd", 0}, // subroutine
  {"dbsqad", 0}, // subroutine
  {"dbsynu", 0}, // subroutine
  {"dbvalu", 0}, // real*8 function
  {"dcbrt", 0}, // real*8 function
  {"dchu", 0}, // real*8 function
  {"dcosdg", 0}, // real*8 function
  {"dcot", 0}, // real*8 function
  {"dcsevl", 0}, // real*8 function
  {"ddaws", 0}, // real*8 function
  {"de1", 0}, // real*8 function
  {"dei", 0}, // real*8 function
  {"dexint", 0}, // subroutine
  {"dexprl", 0}, // real*8 function
  {"dfac", 0}, // real*8 function
  {"dgamic", 0}, // real*8 function
  {"dgami", 0}, // real*8 function
  {"dgamit", 0}, // real*8 function
  {"dgamlm", 0}, // subroutine
  {"dgamln", 0}, // real*8 function
  {"dgamr", 0}, // real*8 function
  {"dgamrn", 0}, // real*8 function
  {"dhkseq", 0}, // subroutine
  {"dlbeta", 0}, // real*8 function
  {"dlgams", 0}, // subroutine
  {"dli", 0}, // real*8 function
  {"dlnrel", 0}, // real*8 function
  {"dpfqad", 0}, // subroutine
  {"dpoch1", 0}, // real*8 function
  {"dpoch", 0}, // real*8 function
  {"dppqad", 0}, // subroutine
  {"dppval", 0}, // real*8 function
  {"dpsi", 0}, // real*8 function
  {"dpsifn", 0}, // subroutine
  {"dsindg", 0}, // real*8 function
  {"dspenc", 0}, // real*8 function
  {"e1", 0}, // function
  {"ei", 0}, // function
  {"exint", 0}, // subroutine
  {"exprel", 0}, // function
  {"fac", 0}, // function
  {"fundoc", 0}, // subroutine
  {"gamic", 0}, // real*4 function
  {"gami", 0}, // function
  {"gamit", 0}, // real*4 function
  {"gamlim", 0}, // subroutine
  {"gamln", 0}, // real*4 function
  {"gamr", 0}, // function
  {"initds", 0}, // function
  {"inits", 0}, // function
  {"pfqad", 0}, // subroutine
  {"poch1", 0}, // function
  {"poch", 0}, // function
  {"ppqad", 0}, // subroutine
  {"ppval", 0}, // function
  {"psi", 0}, // function
  {"r9aimp", 0}, // subroutine
  {"r9atn1", 0}, // function
  {"r9chu", 0}, // function
  {"r9gmic", 0}, // function
  {"r9gmit", 0}, // function
  {"r9knus", 0}, // subroutine
  {"r9lgic", 0}, // function
  {"r9lgit", 0}, // function
  {"r9lgmc", 0}, // function
  {"r9ln2r", 0}, // function
  {"r9pak", 0}, // function
  {"r9upak", 0}, // subroutine
  {"rand", 0}, // function
  {"rgauss", 0}, // function
  {"runif", 0}, // function
  {"sindg", 0}, // function
  {"spenc", 0}, // function
  {"zabs", 0}, // real*8 function
  {"zacai", 0}, // subroutine
  {"zacon", 0}, // subroutine
  {"zairy", 0}, // subroutine
  {"zasyi", 0}, // subroutine
  {"zbesh", 0}, // subroutine
  {"zbesi", 0}, // subroutine
  {"zbesj", 0}, // subroutine
  {"zbesk", 0}, // subroutine
  {"zbesy", 0}, // subroutine
  {"zbinu", 0}, // subroutine
  {"zbiry", 0}, // subroutine
  {"zbknu", 0}, // subroutine
  {"zbuni", 0}, // subroutine
  {"zbunk", 0}, // subroutine
  {"zdiv", 0}, // subroutine
  {"zexp", 0}, // subroutine
  {"zkscl", 0}, // subroutine
  {"zlog", 0}, // subroutine
  {"zmlri", 0}, // subroutine
  {"zmlt", 0}, // subroutine
  {"zrati", 0}, // subroutine
  {"zs1s2", 0}, // subroutine
  {"zseri", 0}, // subroutine
  {"zshch", 0}, // subroutine
  {"zsqrt", 0}, // subroutine
  {"zuchk", 0}, // subroutine
  {"zunhj", 0}, // subroutine
  {"zuni1", 0}, // subroutine
  {"zuni2", 0}, // subroutine
  {"zunik", 0}, // subroutine
  {"zunk1", 0}, // subroutine
  {"zunk2", 0}, // subroutine
  {"zuoik", 0}, // subroutine
  {"zwrsk", 0}, // subroutine
  {NULL, 0}
};

prototype real_4 _aie (real_4 _p_ x_);
prototype real_4 _ai (real_4 _p_ x_);
prototype real_4 _albeta (real_4 _p_ a_, real_4 _p_ b_);
prototype int_4 _algams (real_4 _p_ x_, real_4 _p_ algam_, real_4 _p_ sgngam_);
prototype real_4 _ali (real_4 _p_ x_);
prototype real_4 _alnrel (real_4 _p_ x_);
prototype real_4 _besi0e (real_4 _p_ x_);
prototype real_4 _besi0 (real_4 _p_ x_);
prototype real_4 _besi1e (real_4 _p_ x_);
prototype real_4 _besi1 (real_4 _p_ x_);
prototype int_4 _besi (real_4 _p_ x_, real_4 _p_ alpha_, int_4 _p_ kode_, int_4 _p_ n_, real_4 _p_ y_, int_4 _p_ nz_);
prototype real_4 _besj0 (real_4 _p_ x_);
prototype real_4 _besj1 (real_4 _p_ x_);
prototype int_4 _besj (real_4 _p_ x_, real_4 _p_ alpha_, int_4 _p_ n_, real_4 _p_ y_, int_4 _p_ nz_);
prototype real_4 _besk0e (real_4 _p_ x_);
prototype real_4 _besk0 (real_4 _p_ x_);
prototype real_4 _besk1e (real_4 _p_ x_);
prototype real_4 _besk1 (real_4 _p_ x_);
prototype int_4 _beskes (real_4 _p_ xnu_, real_4 _p_ x_, int_4 _p_ nin_, real_4 _p_ bke_);
prototype int_4 _besk (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_4 _p_ y_, int_4 _p_ nz_);
prototype int_4 _besknu (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_4 _p_ y_, int_4 _p_ nz_);
prototype int_4 _besks (real_4 _p_ xnu_, real_4 _p_ x_, int_4 _p_ nin_, real_4 _p_ bk_);
prototype real_4 _besy0 (real_4 _p_ x_);
prototype real_4 _besy1 (real_4 _p_ x_);
prototype int_4 _besy (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ n_, real_4 _p_ y_);
prototype int_4 _besynu (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ n_, real_4 _p_ y_);
prototype real_4 _beta (real_4 _p_ a_, real_4 _p_ b_);
prototype real_4 _betai (real_4 _p_ x_, real_4 _p_ pin_, real_4 _p_ qin_);
prototype int_4 _bfqad (real_4 (*_f)(), real_4 _p_ t_, real_4 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ id_, 
real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ tol_, real_4 _p_ quad_, int_4 _p_ ierr_, real_4 _p_ work_);
prototype real_4 _bie (real_4 _p_ x_);
prototype real_4 _bi (real_4 _p_ x_);
prototype real_4 _binom (int_4 _p_ n_, int_4 _p_ m_);
prototype int_4 _bint4 (real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ ndata_, int_4 _p_ ibcl_, int_4 _p_ ibcr_, real_4 _p_ 
fbcl_, real_4 _p_ fbcr_, int_4 _p_ kntopt_, real_4 _p_ t_, real_4 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ w_
);
prototype int_4 _bintk (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ t_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ bcoef_, 
real_4 _p_ q_, real_4 _p_ work_);
prototype int_4 _bkias (real_4 _p_ x_, int_4 _p_ n_, int_4 _p_ ktrms_, real_4 _p_ t_, real_4 _p_ ans_, int_4 _p_ ind_, 
int_4 _p_ ms_, real_4 _p_ gmrn_, real_4 _p_ h_, int_4 _p_ ierr_);
prototype int_4 _bkisr (real_4 _p_ x_, int_4 _p_ n_, real_4 _p_ sum_, int_4 _p_ ierr_);
prototype int_4 _bskin (real_4 _p_ x_, int_4 _p_ n_, int_4 _p_ kode_, int_4 _p_ m_, real_4 _p_ y_, int_4 _p_ nz_, int_4 
_p_ ierr_);
prototype int_4 _bspev (real_4 _p_ t_, real_4 _p_ ad_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ nderiv_, real_4 _p_ x_, 
int_4 _p_ inev_, real_4 _p_ svalue_, real_4 _p_ work_);
prototype int_4 _bsppp (real_4 _p_ t_, real_4 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ ldc_, real_4 _p_ c_, real_4 
_p_ xi_, int_4 _p_ lxi_, real_4 _p_ work_);
prototype int_4 _bspvd (real_4 _p_ t_, int_4 _p_ k_, int_4 _p_ nderiv_, real_4 _p_ x_, int_4 _p_ ileft_, int_4 _p_ 
ldvnik_, real_4 _p_ vnikx_, real_4 _p_ work_);
prototype int_4 _bsqad (real_4 _p_ t_, real_4 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ x1_, real_4 _p_ x2_, 
real_4 _p_ bquad_, real_4 _p_ work_);
prototype real_4 _bvalu (real_4 _p_ t_, real_4 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ ideriv_, real_4 _p_ x_, 
int_4 _p_ inbv_, real_4 _p_ work_);
prototype complex_8 _c0lgmc (complex_8 _p_ z_);
prototype complex_8 _c9lgmc (complex_8 _p_ zin_);
prototype complex_8 _c9ln2r (complex_8 _p_ z_);
prototype int_4 _cacai (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ 
y_, int_4 _p_ nz_, real_4 _p_ rl_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cacon (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ 
y_, int_4 _p_ nz_, real_4 _p_ rl_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype complex_8 _cacos (complex_8 _p_ z_);
prototype complex_8 _cacosh (complex_8 _p_ z_);
prototype int_4 _cairy (complex_8 _p_ z_, int_4 _p_ id_, int_4 _p_ kode_, complex_8 _p_ ai_, int_4 _p_ nz_, int_4 _p_ 
ierr_);
prototype real_4 _carg (complex_8 _p_ z_);
prototype complex_8 _casin (complex_8 _p_ zinp_);
prototype complex_8 _casinh (complex_8 _p_ z_);
prototype complex_8 _catan2 (complex_8 _p_ csn_, complex_8 _p_ ccs_);
prototype complex_8 _catan (complex_8 _p_ z_);
prototype complex_8 _catanh (complex_8 _p_ z_);
prototype int_4 _cbesh (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ 
cy_, int_4 _p_ nz_, int_4 _p_ ierr_);
prototype int_4 _cbesi (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ 
nz_, int_4 _p_ ierr_);
prototype int_4 _cbesj (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ 
nz_, int_4 _p_ ierr_);
prototype int_4 _cbesk (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ 
nz_, int_4 _p_ ierr_);
prototype int_4 _cbesy (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ 
nz_, complex_8 _p_ cwrk_, int_4 _p_ ierr_);
prototype complex_8 _cbeta (complex_8 _p_ a_, complex_8 _p_ b_);
prototype int_4 _cbinu (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ 
nz_, real_4 _p_ rl_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cbiry (complex_8 _p_ z_, int_4 _p_ id_, int_4 _p_ kode_, complex_8 _p_ bi_, int_4 _p_ ierr_);
prototype int_4 _cbknu (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ 
nz_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype real_4 _cbrt (real_4 _p_ x_);
prototype int_4 _cbuni (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ 
nz_, int_4 _p_ nui_, int_4 _p_ nlast_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cbunk (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ 
y_, int_4 _p_ nz_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype complex_8 _ccbrt (complex_8 _p_ z_);
prototype complex_8 _ccosh (complex_8 _p_ z_);
prototype complex_8 _ccot (complex_8 _p_ z_);
prototype complex_8 _cexprl (complex_8 _p_ z_);
prototype complex_8 _cgamma (complex_8 _p_ z_);
prototype complex_8 _cgamr (complex_8 _p_ z_);
prototype real_4 _chu (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ x_);
prototype int_4 _ckscl (complex_8 _p_ zr_, real_4 _p_ fnu_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, complex_8 
_p_ rz_, real_4 _p_ ascle_, real_4 _p_ tol_, real_4 _p_ elim_);
prototype complex_8 _clbeta (complex_8 _p_ a_, complex_8 _p_ b_);
prototype complex_8 _clngam (complex_8 _p_ zin_);
prototype complex_8 _clnrel (complex_8 _p_ z_);
prototype complex_8 _clog10 (complex_8 _p_ z_);
prototype int_4 _cmlri (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ 
nz_, real_4 _p_ tol_);
prototype real_4 _cosdg (real_4 _p_ x_);
prototype real_4 _cot (real_4 _p_ x_);
prototype complex_8 _cpsi (complex_8 _p_ zin_);
prototype int_4 _cseri (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ 
nz_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype real_4 _csevl (real_4 _p_ x_, real_4 _p_ cs_, int_4 _p_ n_);
prototype complex_8 _csinh (complex_8 _p_ z_);
prototype complex_8 _ctan (complex_8 _p_ z_);
prototype complex_8 _ctanh (complex_8 _p_ z_);
prototype int_4 _cuni1 (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ 
nz_, int_4 _p_ nlast_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cuni2 (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ 
nz_, int_4 _p_ nlast_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cunk1 (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ 
y_, int_4 _p_ nz_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cunk2 (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ 
y_, int_4 _p_ nz_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cuoik (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ ikflg_, int_4 _p_ n_, complex_8 
_p_ y_, int_4 _p_ nuf_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cwrsk (complex_8 _p_ zr_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ 
nz_, complex_8 _p_ cw_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _d9aimp (real_8 _p_ x_, real_8 _p_ ampl_, real_8 _p_ theta_);
prototype real_8 _d9atn1 (real_8 _p_ x_);
prototype int_4 _d9b0mp (real_8 _p_ x_, real_8 _p_ ampl_, real_8 _p_ theta_);
prototype int_4 _d9b1mp (real_8 _p_ x_, real_8 _p_ ampl_, real_8 _p_ theta_);
prototype real_8 _d9chu (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ z_);
prototype real_8 _d9gmic (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ alx_);
prototype real_8 _d9gmit (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ algap1_, real_8 _p_ sgngam_, real_8 _p_ alx_);
prototype int_4 _d9knus (real_8 _p_ xnu_, real_8 _p_ x_, real_8 _p_ bknu_, real_8 _p_ bknu1_, int_4 _p_ iswtch_);
prototype real_8 _d9lgic (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ alx_);
prototype real_8 _d9lgit (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ algap1_);
prototype real_8 _d9lgmc (real_8 _p_ x_);
prototype real_8 _d9ln2r (real_8 _p_ x_);
prototype real_8 _d9pak (real_8 _p_ y_, int_4 _p_ n_);
prototype int_4 _d9upak (real_8 _p_ x_, real_8 _p_ y_, int_4 _p_ n_);
prototype real_8 _daie (real_8 _p_ x_);
prototype real_8 _dai (real_8 _p_ x_);
prototype int_4 _dasyjy (int_4 (*_funjy)(), real_8 _p_ x_, real_8 _p_ fnu_, real_8 _p_ flgjy_, int_4 _p_ in_, real_8 
_p_ y_, real_8 _p_ wk_, int_4 _p_ iflw_);
prototype real_4 _daws (real_4 _p_ x_);
prototype real_8 _dbesi0 (real_8 _p_ x_);
prototype real_8 _dbesi1 (real_8 _p_ x_);
prototype int_4 _dbesi (real_8 _p_ x_, real_8 _p_ alpha_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ y_, int_4 _p_ nz_);
prototype real_8 _dbesj0 (real_8 _p_ x_);
prototype real_8 _dbesj1 (real_8 _p_ x_);
prototype int_4 _dbesj (real_8 _p_ x_, real_8 _p_ alpha_, int_4 _p_ n_, real_8 _p_ y_, int_4 _p_ nz_);
prototype real_8 _dbesk0 (real_8 _p_ x_);
prototype real_8 _dbesk1 (real_8 _p_ x_);
prototype int_4 _dbesk (real_8 _p_ x_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ y_, int_4 _p_ nz_);
prototype int_4 _dbesks (real_8 _p_ xnu_, real_8 _p_ x_, int_4 _p_ nin_, real_8 _p_ bk_);
prototype real_8 _dbesy0 (real_8 _p_ x_);
prototype real_8 _dbesy1 (real_8 _p_ x_);
prototype int_4 _dbesy (real_8 _p_ x_, real_8 _p_ fnu_, int_4 _p_ n_, real_8 _p_ y_);
prototype real_8 _dbeta (real_8 _p_ a_, real_8 _p_ b_);
prototype real_8 _dbetai (real_8 _p_ x_, real_8 _p_ pin_, real_8 _p_ qin_);
prototype int_4 _dbfqad (real_8 (*_f)(), real_8 _p_ t_, real_8 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ id_, 
real_8 _p_ x1_, real_8 _p_ x2_, real_8 _p_ tol_, real_8 _p_ quad_, int_4 _p_ ierr_, real_8 _p_ work_);
prototype real_8 _dbie (real_8 _p_ x_);
prototype real_8 _dbi (real_8 _p_ x_);
prototype real_8 _dbinom (int_4 _p_ n_, int_4 _p_ m_);
prototype int_4 _dbint4 (real_8 _p_ x_, real_8 _p_ y_, int_4 _p_ ndata_, int_4 _p_ ibcl_, int_4 _p_ ibcr_, real_8 _p_ 
fbcl_, real_8 _p_ fbcr_, int_4 _p_ kntopt_, real_8 _p_ t_, real_8 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ w_
);
prototype int_4 _dbintk (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ t_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ bcoef_, 
real_8 _p_ q_, real_8 _p_ work_);
prototype int_4 _dbkias (real_8 _p_ x_, int_4 _p_ n_, int_4 _p_ ktrms_, real_8 _p_ t_, real_8 _p_ ans_, int_4 _p_ ind_, 
int_4 _p_ ms_, real_8 _p_ gmrn_, real_8 _p_ h_, int_4 _p_ ierr_);
prototype int_4 _dbkisr (real_8 _p_ x_, int_4 _p_ n_, real_8 _p_ sum_, int_4 _p_ ierr_);
prototype real_8 _dbsi0e (real_8 _p_ x_);
prototype real_8 _dbsi1e (real_8 _p_ x_);
prototype real_8 _dbsk0e (real_8 _p_ x_);
prototype real_8 _dbsk1e (real_8 _p_ x_);
prototype int_4 _dbskes (real_8 _p_ xnu_, real_8 _p_ x_, int_4 _p_ nin_, real_8 _p_ bke_);
prototype int_4 _dbskin (real_8 _p_ x_, int_4 _p_ n_, int_4 _p_ kode_, int_4 _p_ m_, real_8 _p_ y_, int_4 _p_ nz_, 
int_4 _p_ ierr_);
prototype int_4 _dbsknu (real_8 _p_ x_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ y_, int_4 _p_ nz_);
prototype int_4 _dbspev (real_8 _p_ t_, real_8 _p_ ad_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ nderiv_, real_8 _p_ x_, 
int_4 _p_ inev_, real_8 _p_ svalue_, real_8 _p_ work_);
prototype int_4 _dbsppp (real_8 _p_ t_, real_8 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ ldc_, real_8 _p_ c_, 
real_8 _p_ xi_, int_4 _p_ lxi_, real_8 _p_ work_);
prototype int_4 _dbspvd (real_8 _p_ t_, int_4 _p_ k_, int_4 _p_ nderiv_, real_8 _p_ x_, int_4 _p_ ileft_, int_4 _p_ 
ldvnik_, real_8 _p_ vnikx_, real_8 _p_ work_);
prototype int_4 _dbsqad (real_8 _p_ t_, real_8 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ x1_, real_8 _p_ x2_, 
real_8 _p_ bquad_, real_8 _p_ work_);
prototype int_4 _dbsynu (real_8 _p_ x_, real_8 _p_ fnu_, int_4 _p_ n_, real_8 _p_ y_);
prototype real_8 _dbvalu (real_8 _p_ t_, real_8 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ ideriv_, real_8 _p_ x_, 
int_4 _p_ inbv_, real_8 _p_ work_);
prototype real_8 _dcbrt (real_8 _p_ x_);
prototype real_8 _dchu (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ x_);
prototype real_8 _dcosdg (real_8 _p_ x_);
prototype real_8 _dcot (real_8 _p_ x_);
prototype real_8 _dcsevl (real_8 _p_ x_, real_8 _p_ cs_, int_4 _p_ n_);
prototype real_8 _ddaws (real_8 _p_ x_);
prototype real_8 _de1 (real_8 _p_ x_);
prototype real_8 _dei (real_8 _p_ x_);
prototype int_4 _dexint (real_8 _p_ x_, int_4 _p_ n_, int_4 _p_ kode_, int_4 _p_ m_, real_8 _p_ tol_, real_8 _p_ en_, 
int_4 _p_ nz_, int_4 _p_ ierr_);
prototype real_8 _dexprl (real_8 _p_ x_);
prototype real_8 _dfac (int_4 _p_ n_);
prototype real_8 _dgamic (real_8 _p_ a_, real_8 _p_ x_);
prototype real_8 _dgami (real_8 _p_ a_, real_8 _p_ x_);
prototype real_8 _dgamit (real_8 _p_ a_, real_8 _p_ x_);
prototype int_4 _dgamlm (real_8 _p_ xmin_, real_8 _p_ xmax_);
prototype real_8 _dgamln (real_8 _p_ z_, int_4 _p_ ierr_);
prototype real_8 _dgamr (real_8 _p_ x_);
prototype real_8 _dgamrn (real_8 _p_ x_);
prototype int_4 _dhkseq (real_8 _p_ x_, int_4 _p_ m_, real_8 _p_ h_, int_4 _p_ ierr_);
prototype real_8 _dlbeta (real_8 _p_ a_, real_8 _p_ b_);
prototype int_4 _dlgams (real_8 _p_ x_, real_8 _p_ dlgam_, real_8 _p_ sgngam_);
prototype real_8 _dli (real_8 _p_ x_);
prototype real_8 _dlnrel (real_8 _p_ x_);
prototype int_4 _dpfqad (real_8 (*_f)(), int_4 _p_ ldc_, real_8 _p_ c_, real_8 _p_ xi_, int_4 _p_ lxi_, int_4 _p_ k_, 
int_4 _p_ id_, real_8 _p_ x1_, real_8 _p_ x2_, real_8 _p_ tol_, real_8 _p_ quad_, int_4 _p_ ierr_);
prototype real_8 _dpoch1 (real_8 _p_ a_, real_8 _p_ x_);
prototype real_8 _dpoch (real_8 _p_ a_, real_8 _p_ x_);
prototype int_4 _dppqad (int_4 _p_ ldc_, real_8 _p_ c_, real_8 _p_ xi_, int_4 _p_ lxi_, int_4 _p_ k_, real_8 _p_ x1_, 
real_8 _p_ x2_, real_8 _p_ pquad_);
prototype real_8 _dppval (int_4 _p_ ldc_, real_8 _p_ c_, real_8 _p_ xi_, int_4 _p_ lxi_, int_4 _p_ k_, int_4 _p_ 
ideriv_, real_8 _p_ x_, int_4 _p_ inppv_);
prototype real_8 _dpsi (real_8 _p_ x_);
prototype int_4 _dpsifn (real_8 _p_ x_, int_4 _p_ n_, int_4 _p_ kode_, int_4 _p_ m_, real_8 _p_ ans_, int_4 _p_ nz_, 
int_4 _p_ ierr_);
prototype real_8 _dsindg (real_8 _p_ x_);
prototype real_8 _dspenc (real_8 _p_ x_);
prototype real_4 _e1 (real_4 _p_ x_);
prototype real_4 _ei (real_4 _p_ x_);
prototype int_4 _exint (real_4 _p_ x_, int_4 _p_ n_, int_4 _p_ kode_, int_4 _p_ m_, real_4 _p_ tol_, real_4 _p_ en_, 
int_4 _p_ nz_, int_4 _p_ ierr_);
prototype real_4 _exprel (real_4 _p_ x_);
prototype real_4 _fac (int_4 _p_ n_);
prototype int_4 _fundoc (void);
prototype real_4 _gamic (real_4 _p_ a_, real_4 _p_ x_);
prototype real_4 _gami (real_4 _p_ a_, real_4 _p_ x_);
prototype real_4 _gamit (real_4 _p_ a_, real_4 _p_ x_);
prototype int_4 _gamlim (real_4 _p_ xmin_, real_4 _p_ xmax_);
prototype real_4 _gamln (real_4 _p_ z_, int_4 _p_ ierr_);
prototype real_4 _gamr (real_4 _p_ x_);
prototype int_4 _initds (real_8 _p_ os_, int_4 _p_ nos_, real_4 _p_ eta_);
prototype int_4 _inits (real_4 _p_ os_, int_4 _p_ nos_, real_4 _p_ eta_);
prototype int_4 _pfqad (real_4 (*_f)(), int_4 _p_ ldc_, real_4 _p_ c_, real_4 _p_ xi_, int_4 _p_ lxi_, int_4 _p_ k_, 
int_4 _p_ id_, real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ tol_, real_4 _p_ quad_, int_4 _p_ ierr_);
prototype real_4 _poch1 (real_4 _p_ a_, real_4 _p_ x_);
prototype real_4 _poch (real_4 _p_ a_, real_4 _p_ x_);
prototype int_4 _ppqad (int_4 _p_ ldc_, real_4 _p_ c_, real_4 _p_ xi_, int_4 _p_ lxi_, int_4 _p_ k_, real_4 _p_ x1_, 
real_4 _p_ x2_, real_4 _p_ pquad_);
prototype real_4 _ppval (int_4 _p_ ldc_, real_4 _p_ c_, real_4 _p_ xi_, int_4 _p_ lxi_, int_4 _p_ k_, int_4 _p_ ideriv_
, real_4 _p_ x_, int_4 _p_ inppv_);
prototype real_4 _psi (real_4 _p_ x_);
prototype int_4 _r9aimp (real_4 _p_ x_, real_4 _p_ ampl_, real_4 _p_ theta_);
prototype real_4 _r9atn1 (real_4 _p_ x_);
prototype real_4 _r9chu (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ z_);
prototype real_4 _r9gmic (real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ alx_);
prototype real_4 _r9gmit (real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ algap1_, real_4 _p_ sgngam_, real_4 _p_ alx_);
prototype int_4 _r9knus (real_4 _p_ xnu_, real_4 _p_ x_, real_4 _p_ bknu_, real_4 _p_ bknu1_, int_4 _p_ iswtch_);
prototype real_4 _r9lgic (real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ alx_);
prototype real_4 _r9lgit (real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ algap1_);
prototype real_4 _r9lgmc (real_4 _p_ x_);
prototype real_4 _r9ln2r (real_4 _p_ x_);
prototype real_4 _r9pak (real_4 _p_ y_, int_4 _p_ n_);
prototype int_4 _r9upak (real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ n_);
prototype real_4 _rand (real_4 _p_ r_);
prototype real_4 _rgauss (real_4 _p_ xmean_, real_4 _p_ sd_);
prototype real_4 _runif (real_4 _p_ t_, int_4 _p_ n_);
prototype real_4 _sindg (real_4 _p_ x_);
prototype real_4 _spenc (real_4 _p_ x_);
prototype real_8 _zabs (real_8 _p_ zr_, real_8 _p_ zi_);
prototype int_4 _zacai (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, 
real_8 _p_ yr_, real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ rl_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_);
prototype int_4 _zacon (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, 
real_8 _p_ yr_, real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ rl_, real_8 _p_ fnul_, real_8 _p_ tol_, real_8 _p_ elim_, 
real_8 _p_ alim_);
prototype int_4 _zairy (real_8 _p_ zr_, real_8 _p_ zi_, int_4 _p_ id_, int_4 _p_ kode_, real_8 _p_ air_, real_8 _p_ 
aii_, int_4 _p_ nz_, int_4 _p_ ierr_);
prototype int_4 _zasyi (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ yr_, 
real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ rl_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_);
prototype int_4 _zbesh (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ m_, int_4 _p_ n_, 
real_8 _p_ cyr_, real_8 _p_ cyi_, int_4 _p_ nz_, int_4 _p_ ierr_);
prototype int_4 _zbesi (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ cyr_
, real_8 _p_ cyi_, int_4 _p_ nz_, int_4 _p_ ierr_);
prototype int_4 _zbesj (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ cyr_
, real_8 _p_ cyi_, int_4 _p_ nz_, int_4 _p_ ierr_);
prototype int_4 _zbesk (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ cyr_
, real_8 _p_ cyi_, int_4 _p_ nz_, int_4 _p_ ierr_);
prototype int_4 _zbesy (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ cyr_
, real_8 _p_ cyi_, int_4 _p_ nz_, real_8 _p_ cwrkr_, real_8 _p_ cwrki_, int_4 _p_ ierr_);
prototype int_4 _zbinu (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ cyr_
, real_8 _p_ cyi_, int_4 _p_ nz_, real_8 _p_ rl_, real_8 _p_ fnul_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_
);
prototype int_4 _zbiry (real_8 _p_ zr_, real_8 _p_ zi_, int_4 _p_ id_, int_4 _p_ kode_, real_8 _p_ bir_, real_8 _p_ 
bii_, int_4 _p_ ierr_);
prototype int_4 _zbknu (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ yr_, 
real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_);
prototype int_4 _zbuni (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ yr_, 
real_8 _p_ yi_, int_4 _p_ nz_, int_4 _p_ nui_, int_4 _p_ nlast_, real_8 _p_ fnul_, real_8 _p_ tol_, real_8 _p_ elim_, 
real_8 _p_ alim_);
prototype int_4 _zbunk (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, 
real_8 _p_ yr_, real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_);
prototype int_4 _zdiv (real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ br_, real_8 _p_ bi_, real_8 _p_ cr_, real_8 _p_ ci_);
prototype int_4 _zexp (real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ br_, real_8 _p_ bi_);
prototype int_4 _zkscl (real_8 _p_ zrr_, real_8 _p_ zri_, real_8 _p_ fnu_, int_4 _p_ n_, real_8 _p_ yr_, real_8 _p_ yi_
, int_4 _p_ nz_, real_8 _p_ rzr_, real_8 _p_ rzi_, real_8 _p_ ascle_, real_8 _p_ tol_, real_8 _p_ elim_);
prototype int_4 _zlog (real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ br_, real_8 _p_ bi_, int_4 _p_ ierr_);
prototype int_4 _zmlri (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ yr_, 
real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ tol_);
prototype int_4 _zmlt (real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ br_, real_8 _p_ bi_, real_8 _p_ cr_, real_8 _p_ ci_);
prototype int_4 _zrati (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ n_, real_8 _p_ cyr_, real_8 _p_ cyi_
, real_8 _p_ tol_);
prototype int_4 _zs1s2 (real_8 _p_ zrr_, real_8 _p_ zri_, real_8 _p_ s1r_, real_8 _p_ s1i_, real_8 _p_ s2r_, real_8 _p_ 
s2i_, int_4 _p_ nz_, real_8 _p_ ascle_, real_8 _p_ alim_, int_4 _p_ iuf_);
prototype int_4 _zseri (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ yr_, 
real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_);
prototype int_4 _zshch (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ cshr_, real_8 _p_ cshi_, real_8 _p_ cchr_, real_8 
_p_ cchi_);
prototype int_4 _zsqrt (real_8 _p_ ar_, real_8 _p_ ai_, real_8 _p_ br_, real_8 _p_ bi_);
prototype int_4 _zuchk (real_8 _p_ yr_, real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ ascle_, real_8 _p_ tol_);
prototype int_4 _zunhj (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ ipmtr_, real_8 _p_ tol_, real_8 _p_ 
phir_, real_8 _p_ phii_, real_8 _p_ argr_, real_8 _p_ argi_, real_8 _p_ zeta1r_, real_8 _p_ zeta1i_, real_8 _p_ zeta2r_
, real_8 _p_ zeta2i_, real_8 _p_ asumr_, real_8 _p_ asumi_, real_8 _p_ bsumr_, real_8 _p_ bsumi_);
prototype int_4 _zuni1 (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ yr_, 
real_8 _p_ yi_, int_4 _p_ nz_, int_4 _p_ nlast_, real_8 _p_ fnul_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_)
;
prototype int_4 _zuni2 (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ yr_, 
real_8 _p_ yi_, int_4 _p_ nz_, int_4 _p_ nlast_, real_8 _p_ fnul_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_)
;
prototype int_4 _zunik (real_8 _p_ zrr_, real_8 _p_ zri_, real_8 _p_ fnu_, int_4 _p_ ikflg_, int_4 _p_ ipmtr_, real_8 
_p_ tol_, int_4 _p_ init_, real_8 _p_ phir_, real_8 _p_ phii_, real_8 _p_ zeta1r_, real_8 _p_ zeta1i_, real_8 _p_ 
zeta2r_, real_8 _p_ zeta2i_, real_8 _p_ sumr_, real_8 _p_ sumi_, real_8 _p_ cwrkr_, real_8 _p_ cwrki_);
prototype int_4 _zunk1 (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, 
real_8 _p_ yr_, real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_);
prototype int_4 _zunk2 (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, 
real_8 _p_ yr_, real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_);
prototype int_4 _zuoik (real_8 _p_ zr_, real_8 _p_ zi_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ ikflg_, int_4 _p_ 
n_, real_8 _p_ yr_, real_8 _p_ yi_, int_4 _p_ nuf_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ alim_);
prototype int_4 _zwrsk (real_8 _p_ zrr_, real_8 _p_ zri_, real_8 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ 
yr_, real_8 _p_ yi_, int_4 _p_ nz_, real_8 _p_ cwr_, real_8 _p_ cwi_, real_8 _p_ tol_, real_8 _p_ elim_, real_8 _p_ 
alim_);
real_4 _aie (real_4 _p_ x_)
{
  static int_4 naif_, naig_, naip_;
  static logical_4 first_;
  static real_4 aie_, aifcs_[9], aigcs_[8], aipcs_[34], x3sml_, x32sml_, xbig_, eta_, xm_, theta_, z_, sqrtx_;
  int_4 _data_k_0, _data_k_1, _data_k_2, _data_k_3, _data_k_4, _data_k_5, _data_k_6, _data_k_7, _data_k_8, _data_k_9, 
  _data_k_10, _data_k_11, _data_k_12, _data_k_13, _data_k_14, _data_k_15, _data_k_16, _data_k_17, _data_k_18, _data_k_19, 
  _data_k_20, _data_k_21, _data_k_22, _data_k_23, _data_k_24, _data_k_25, _data_k_26, _data_k_27, _data_k_28, _data_k_29, 
  _data_k_30, _data_k_31, _data_k_32, _data_k_33, _data_k_34, _data_k_35, _data_k_36, _data_k_37, _data_k_38, _data_k_39, 
  _data_k_40, _data_k_41, _data_k_42, _data_k_43, _data_k_44, _data_k_45, _data_k_46, _data_k_47, _data_k_48, _data_k_49, 
  _data_k_50, _data_k_51, $0_, $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_0 1
  static real_4 _data_l_0[_data_n_0] = {
    -.0379713584966699975e0
  };
#define _data_n_1 1
  static real_4 _data_l_1[_data_n_1] = {
    .05919188853726363857e0
  };
#define _data_n_2 1
  static real_4 _data_l_2[_data_n_2] = {
    .00098629280577279975e0
  };
#define _data_n_3 1
  static real_4 _data_l_3[_data_n_3] = {
    .00000684884381907656e0
  };
#define _data_n_4 1
  static real_4 _data_l_4[_data_n_4] = {
    .00000002594202596219e0
  };
#define _data_n_5 1
  static real_4 _data_l_5[_data_n_5] = {
    .00000000006176612774e0
  };
#define _data_n_6 1
  static real_4 _data_l_6[_data_n_6] = {
    .00000000000010092454e0
  };
#define _data_n_7 1
  static real_4 _data_l_7[_data_n_7] = {
    .00000000000000012014e0
  };
#define _data_n_8 1
  static real_4 _data_l_8[_data_n_8] = {
    .0000000000000000001e0
  };
#define _data_n_9 1
  static real_4 _data_l_9[_data_n_9] = {
    .01815236558116127e0
  };
#define _data_n_10 1
  static real_4 _data_l_10[_data_n_10] = {
    .02157256316601076e0
  };
#define _data_n_11 1
  static real_4 _data_l_11[_data_n_11] = {
    .00025678356987483e0
  };
#define _data_n_12 1
  static real_4 _data_l_12[_data_n_12] = {
    .00000142652141197e0
  };
#define _data_n_13 1
  static real_4 _data_l_13[_data_n_13] = {
    .00000000457211492e0
  };
#define _data_n_14 1
  static real_4 _data_l_14[_data_n_14] = {
    .00000000000952517e0
  };
#define _data_n_15 1
  static real_4 _data_l_15[_data_n_15] = {
    .00000000000001392e0
  };
#define _data_n_16 1
  static real_4 _data_l_16[_data_n_16] = {
    .00000000000000001e0
  };
#define _data_n_17 1
  static real_4 _data_l_17[_data_n_17] = {
    -.0187519297793868e0
  };
#define _data_n_18 1
  static real_4 _data_l_18[_data_n_18] = {
    -.0091443848250055e0
  };
#define _data_n_19 1
  static real_4 _data_l_19[_data_n_19] = {
    .0009010457337825e0
  };
#define _data_n_20 1
  static real_4 _data_l_20[_data_n_20] = {
    -.0001394184127221e0
  };
#define _data_n_21 1
  static real_4 _data_l_21[_data_n_21] = {
    .0000273815815785e0
  };
#define _data_n_22 1
  static real_4 _data_l_22[_data_n_22] = {
    -.0000062750421119e0
  };
#define _data_n_23 1
  static real_4 _data_l_23[_data_n_23] = {
    .0000016064844184e0
  };
#define _data_n_24 1
  static real_4 _data_l_24[_data_n_24] = {
    -.0000004476392158e0
  };
#define _data_n_25 1
  static real_4 _data_l_25[_data_n_25] = {
    .0000001334635874e0
  };
#define _data_n_26 1
  static real_4 _data_l_26[_data_n_26] = {
    -.0000000420735334e0
  };
#define _data_n_27 1
  static real_4 _data_l_27[_data_n_27] = {
    .000000013902199e0
  };
#define _data_n_28 1
  static real_4 _data_l_28[_data_n_28] = {
    -.0000000047831848e0
  };
#define _data_n_29 1
  static real_4 _data_l_29[_data_n_29] = {
    .0000000017047897e0
  };
#define _data_n_30 1
  static real_4 _data_l_30[_data_n_30] = {
    -.0000000006268389e0
  };
#define _data_n_31 1
  static real_4 _data_l_31[_data_n_31] = {
    .0000000002369824e0
  };
#define _data_n_32 1
  static real_4 _data_l_32[_data_n_32] = {
    -.0000000000918641e0
  };
#define _data_n_33 1
  static real_4 _data_l_33[_data_n_33] = {
    .0000000000364278e0
  };
#define _data_n_34 1
  static real_4 _data_l_34[_data_n_34] = {
    -.0000000000147475e0
  };
#define _data_n_35 1
  static real_4 _data_l_35[_data_n_35] = {
    .0000000000060851e0
  };
#define _data_n_36 1
  static real_4 _data_l_36[_data_n_36] = {
    -.0000000000025552e0
  };
#define _data_n_37 1
  static real_4 _data_l_37[_data_n_37] = {
    .0000000000010906e0
  };
#define _data_n_38 1
  static real_4 _data_l_38[_data_n_38] = {
    -.0000000000004725e0
  };
#define _data_n_39 1
  static real_4 _data_l_39[_data_n_39] = {
    .0000000000002076e0
  };
#define _data_n_40 1
  static real_4 _data_l_40[_data_n_40] = {
    -.0000000000000924e0
  };
#define _data_n_41 1
  static real_4 _data_l_41[_data_n_41] = {
    .0000000000000417e0
  };
#define _data_n_42 1
  static real_4 _data_l_42[_data_n_42] = {
    -.000000000000019e0
  };
#define _data_n_43 1
  static real_4 _data_l_43[_data_n_43] = {
    .0000000000000087e0
  };
#define _data_n_44 1
  static real_4 _data_l_44[_data_n_44] = {
    -.000000000000004e0
  };
#define _data_n_45 1
  static real_4 _data_l_45[_data_n_45] = {
    .0000000000000019e0
  };
#define _data_n_46 1
  static real_4 _data_l_46[_data_n_46] = {
    -.0000000000000009e0
  };
#define _data_n_47 1
  static real_4 _data_l_47[_data_n_47] = {
    .0000000000000004e0
  };
#define _data_n_48 1
  static real_4 _data_l_48[_data_n_48] = {
    -.0000000000000002e0
  };
#define _data_n_49 1
  static real_4 _data_l_49[_data_n_49] = {
    .0000000000000001e0
  };
#define _data_n_50 1
  static real_4 _data_l_50[_data_n_50] = {
    -.0e0
  };
#define _data_n_51 1
  static logical_4 _data_l_51[_data_n_51] = {
    TRUE
  };
  if (__calls[0].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    aifcs_[0] = _data_l_0[_data_k_0++];
  }
  if (__calls[0].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    aifcs_[1] = _data_l_1[_data_k_1++];
  }
  if (__calls[0].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    aifcs_[2] = _data_l_2[_data_k_2++];
  }
  if (__calls[0].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    aifcs_[3] = _data_l_3[_data_k_3++];
  }
  if (__calls[0].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    aifcs_[4] = _data_l_4[_data_k_4++];
  }
  if (__calls[0].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    aifcs_[5] = _data_l_5[_data_k_5++];
  }
  if (__calls[0].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    aifcs_[6] = _data_l_6[_data_k_6++];
  }
  if (__calls[0].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    aifcs_[7] = _data_l_7[_data_k_7++];
  }
  if (__calls[0].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    aifcs_[8] = _data_l_8[_data_k_8++];
  }
  if (__calls[0].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    aigcs_[0] = _data_l_9[_data_k_9++];
  }
  if (__calls[0].calls == 0) {
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    aigcs_[1] = _data_l_10[_data_k_10++];
  }
  if (__calls[0].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    aigcs_[2] = _data_l_11[_data_k_11++];
  }
  if (__calls[0].calls == 0) {
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    aigcs_[3] = _data_l_12[_data_k_12++];
  }
  if (__calls[0].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    aigcs_[4] = _data_l_13[_data_k_13++];
  }
  if (__calls[0].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    aigcs_[5] = _data_l_14[_data_k_14++];
  }
  if (__calls[0].calls == 0) {
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    aigcs_[6] = _data_l_15[_data_k_15++];
  }
  if (__calls[0].calls == 0) {
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    aigcs_[7] = _data_l_16[_data_k_16++];
  }
  if (__calls[0].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    aipcs_[0] = _data_l_17[_data_k_17++];
  }
  if (__calls[0].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    aipcs_[1] = _data_l_18[_data_k_18++];
  }
  if (__calls[0].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    aipcs_[2] = _data_l_19[_data_k_19++];
  }
  if (__calls[0].calls == 0) {
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    aipcs_[3] = _data_l_20[_data_k_20++];
  }
  if (__calls[0].calls == 0) {
    _data_k_21 = 0;
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    aipcs_[4] = _data_l_21[_data_k_21++];
  }
  if (__calls[0].calls == 0) {
    _data_k_22 = 0;
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    aipcs_[5] = _data_l_22[_data_k_22++];
  }
  if (__calls[0].calls == 0) {
    _data_k_23 = 0;
    if (_data_k_23 >= _data_n_23) {
      _data_k_23 = 0;
    }
    aipcs_[6] = _data_l_23[_data_k_23++];
  }
  if (__calls[0].calls == 0) {
    _data_k_24 = 0;
    if (_data_k_24 >= _data_n_24) {
      _data_k_24 = 0;
    }
    aipcs_[7] = _data_l_24[_data_k_24++];
  }
  if (__calls[0].calls == 0) {
    _data_k_25 = 0;
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    aipcs_[8] = _data_l_25[_data_k_25++];
  }
  if (__calls[0].calls == 0) {
    _data_k_26 = 0;
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    aipcs_[9] = _data_l_26[_data_k_26++];
  }
  if (__calls[0].calls == 0) {
    _data_k_27 = 0;
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    aipcs_[10] = _data_l_27[_data_k_27++];
  }
  if (__calls[0].calls == 0) {
    _data_k_28 = 0;
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    aipcs_[11] = _data_l_28[_data_k_28++];
  }
  if (__calls[0].calls == 0) {
    _data_k_29 = 0;
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    aipcs_[12] = _data_l_29[_data_k_29++];
  }
  if (__calls[0].calls == 0) {
    _data_k_30 = 0;
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    aipcs_[13] = _data_l_30[_data_k_30++];
  }
  if (__calls[0].calls == 0) {
    _data_k_31 = 0;
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    aipcs_[14] = _data_l_31[_data_k_31++];
  }
  if (__calls[0].calls == 0) {
    _data_k_32 = 0;
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    aipcs_[15] = _data_l_32[_data_k_32++];
  }
  if (__calls[0].calls == 0) {
    _data_k_33 = 0;
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    aipcs_[16] = _data_l_33[_data_k_33++];
  }
  if (__calls[0].calls == 0) {
    _data_k_34 = 0;
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    aipcs_[17] = _data_l_34[_data_k_34++];
  }
  if (__calls[0].calls == 0) {
    _data_k_35 = 0;
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    aipcs_[18] = _data_l_35[_data_k_35++];
  }
  if (__calls[0].calls == 0) {
    _data_k_36 = 0;
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    aipcs_[19] = _data_l_36[_data_k_36++];
  }
  if (__calls[0].calls == 0) {
    _data_k_37 = 0;
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    aipcs_[20] = _data_l_37[_data_k_37++];
  }
  if (__calls[0].calls == 0) {
    _data_k_38 = 0;
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    aipcs_[21] = _data_l_38[_data_k_38++];
  }
  if (__calls[0].calls == 0) {
    _data_k_39 = 0;
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    aipcs_[22] = _data_l_39[_data_k_39++];
  }
  if (__calls[0].calls == 0) {
    _data_k_40 = 0;
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    aipcs_[23] = _data_l_40[_data_k_40++];
  }
  if (__calls[0].calls == 0) {
    _data_k_41 = 0;
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    aipcs_[24] = _data_l_41[_data_k_41++];
  }
  if (__calls[0].calls == 0) {
    _data_k_42 = 0;
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    aipcs_[25] = _data_l_42[_data_k_42++];
  }
  if (__calls[0].calls == 0) {
    _data_k_43 = 0;
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    aipcs_[26] = _data_l_43[_data_k_43++];
  }
  if (__calls[0].calls == 0) {
    _data_k_44 = 0;
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    aipcs_[27] = _data_l_44[_data_k_44++];
  }
  if (__calls[0].calls == 0) {
    _data_k_45 = 0;
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    aipcs_[28] = _data_l_45[_data_k_45++];
  }
  if (__calls[0].calls == 0) {
    _data_k_46 = 0;
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    aipcs_[29] = _data_l_46[_data_k_46++];
  }
  if (__calls[0].calls == 0) {
    _data_k_47 = 0;
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    aipcs_[30] = _data_l_47[_data_k_47++];
  }
  if (__calls[0].calls == 0) {
    _data_k_48 = 0;
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    aipcs_[31] = _data_l_48[_data_k_48++];
  }
  if (__calls[0].calls == 0) {
    _data_k_49 = 0;
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    aipcs_[32] = _data_l_49[_data_k_49++];
  }
  if (__calls[0].calls == 0) {
    _data_k_50 = 0;
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    aipcs_[33] = _data_l_50[_data_k_50++];
  }
  if (__calls[0].calls == 0) {
    _data_k_51 = 0;
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    first_ = _data_l_51[_data_k_51++];
  }
  if (first_) {
    eta_ = 0.1 * _r1mach (($0_ = 3, &$0_));
    naif_ = _inits (aifcs_, ($1_ = 9, &$1_), &eta_);
    naig_ = _inits (aigcs_, ($2_ = 8, &$2_), &eta_);
    naip_ = _inits (aipcs_, ($3_ = 34, &$3_), &eta_);
    x3sml_ = powl (eta_, 0.3333);
    x32sml_ = 1.3104 * (x3sml_ * x3sml_);
    xbig_ = powl (_r1mach (($4_ = 2, &$4_)), 0.6666);
  }
  first_ = FALSE;
  if ((*x_) >= -1.0) {
    goto _l20;
  }
  (void) _r9aimp (x_, &xm_, &theta_);
  aie_ = xm_ * cosf (theta_);
  goto _l0;
  _l20:;
  if ((*x_) > 1.0) {
    goto _l30;
  }
  z_ = 0.0;
  if (_abs ((*x_)) > x3sml_) {
    z_ = ((*x_) * (*x_) * (*x_));
  }
  aie_ = 0.375 + (_csevl (&z_, aifcs_, &naif_) - (*x_) * (0.25 + _csevl (&z_, aigcs_, &naig_)));
  if ((*x_) > x32sml_) {
    aie_ = aie_ * expf (2.0 * (*x_) * sqrtf ((*x_)) / 3.0);
  }
  goto _l0;
  _l30:;
  sqrtx_ = sqrtf ((*x_));
  z_ = -1.0;
  if ((*x_) < xbig_) {
    z_ = 2.0 / ((*x_) * sqrtx_) - 1.0;
  }
  aie_ = (.28125 + _csevl (&z_, aipcs_, &naip_)) / sqrtf (sqrtx_);
  _l0:;
  __calls[0].calls++;
  return aie_;
}

real_4 _ai (real_4 _p_ x_)
{
  static int_4 naif_, naig_;
  static logical_4 first_;
  static real_4 ai_, aifcs_[9], aigcs_[8], x3sml_, xmax_, xmaxt_, xm_, theta_, z_;
  int_4 _data_k_52, _data_k_53, _data_k_54, _data_k_55, _data_k_56, _data_k_57, _data_k_58, _data_k_59, _data_k_60, 
  _data_k_61, _data_k_62, _data_k_63, _data_k_64, _data_k_65, _data_k_66, _data_k_67, _data_k_68, _data_k_69, $0_, $1_, 
  $3_, $4_, $6_;
  real_4 $2_, $5_;
  extern real_4 _r1mach ();
#define _data_n_52 1
  static real_4 _data_l_52[_data_n_52] = {
    -.0379713584966699975e0
  };
#define _data_n_53 1
  static real_4 _data_l_53[_data_n_53] = {
    .05919188853726363857e0
  };
#define _data_n_54 1
  static real_4 _data_l_54[_data_n_54] = {
    .00098629280577279975e0
  };
#define _data_n_55 1
  static real_4 _data_l_55[_data_n_55] = {
    .00000684884381907656e0
  };
#define _data_n_56 1
  static real_4 _data_l_56[_data_n_56] = {
    .00000002594202596219e0
  };
#define _data_n_57 1
  static real_4 _data_l_57[_data_n_57] = {
    .00000000006176612774e0
  };
#define _data_n_58 1
  static real_4 _data_l_58[_data_n_58] = {
    .00000000000010092454e0
  };
#define _data_n_59 1
  static real_4 _data_l_59[_data_n_59] = {
    .00000000000000012014e0
  };
#define _data_n_60 1
  static real_4 _data_l_60[_data_n_60] = {
    .0000000000000000001e0
  };
#define _data_n_61 1
  static real_4 _data_l_61[_data_n_61] = {
    .01815236558116127e0
  };
#define _data_n_62 1
  static real_4 _data_l_62[_data_n_62] = {
    .02157256316601076e0
  };
#define _data_n_63 1
  static real_4 _data_l_63[_data_n_63] = {
    .00025678356987483e0
  };
#define _data_n_64 1
  static real_4 _data_l_64[_data_n_64] = {
    .00000142652141197e0
  };
#define _data_n_65 1
  static real_4 _data_l_65[_data_n_65] = {
    .00000000457211492e0
  };
#define _data_n_66 1
  static real_4 _data_l_66[_data_n_66] = {
    .00000000000952517e0
  };
#define _data_n_67 1
  static real_4 _data_l_67[_data_n_67] = {
    .00000000000001392e0
  };
#define _data_n_68 1
  static real_4 _data_l_68[_data_n_68] = {
    .00000000000000001e0
  };
#define _data_n_69 1
  static logical_4 _data_l_69[_data_n_69] = {
    TRUE
  };
  if (__calls[1].calls == 0) {
    _data_k_52 = 0;
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    aifcs_[0] = _data_l_52[_data_k_52++];
  }
  if (__calls[1].calls == 0) {
    _data_k_53 = 0;
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    aifcs_[1] = _data_l_53[_data_k_53++];
  }
  if (__calls[1].calls == 0) {
    _data_k_54 = 0;
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    aifcs_[2] = _data_l_54[_data_k_54++];
  }
  if (__calls[1].calls == 0) {
    _data_k_55 = 0;
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    aifcs_[3] = _data_l_55[_data_k_55++];
  }
  if (__calls[1].calls == 0) {
    _data_k_56 = 0;
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    aifcs_[4] = _data_l_56[_data_k_56++];
  }
  if (__calls[1].calls == 0) {
    _data_k_57 = 0;
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    aifcs_[5] = _data_l_57[_data_k_57++];
  }
  if (__calls[1].calls == 0) {
    _data_k_58 = 0;
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    aifcs_[6] = _data_l_58[_data_k_58++];
  }
  if (__calls[1].calls == 0) {
    _data_k_59 = 0;
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    aifcs_[7] = _data_l_59[_data_k_59++];
  }
  if (__calls[1].calls == 0) {
    _data_k_60 = 0;
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    aifcs_[8] = _data_l_60[_data_k_60++];
  }
  if (__calls[1].calls == 0) {
    _data_k_61 = 0;
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    aigcs_[0] = _data_l_61[_data_k_61++];
  }
  if (__calls[1].calls == 0) {
    _data_k_62 = 0;
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    aigcs_[1] = _data_l_62[_data_k_62++];
  }
  if (__calls[1].calls == 0) {
    _data_k_63 = 0;
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    aigcs_[2] = _data_l_63[_data_k_63++];
  }
  if (__calls[1].calls == 0) {
    _data_k_64 = 0;
    if (_data_k_64 >= _data_n_64) {
      _data_k_64 = 0;
    }
    aigcs_[3] = _data_l_64[_data_k_64++];
  }
  if (__calls[1].calls == 0) {
    _data_k_65 = 0;
    if (_data_k_65 >= _data_n_65) {
      _data_k_65 = 0;
    }
    aigcs_[4] = _data_l_65[_data_k_65++];
  }
  if (__calls[1].calls == 0) {
    _data_k_66 = 0;
    if (_data_k_66 >= _data_n_66) {
      _data_k_66 = 0;
    }
    aigcs_[5] = _data_l_66[_data_k_66++];
  }
  if (__calls[1].calls == 0) {
    _data_k_67 = 0;
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    aigcs_[6] = _data_l_67[_data_k_67++];
  }
  if (__calls[1].calls == 0) {
    _data_k_68 = 0;
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    aigcs_[7] = _data_l_68[_data_k_68++];
  }
  if (__calls[1].calls == 0) {
    _data_k_69 = 0;
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    first_ = _data_l_69[_data_k_69++];
  }
  if (first_) {
    naif_ = _inits (aifcs_, ($0_ = 9, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    naig_ = _inits (aigcs_, ($3_ = 8, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    x3sml_ = powl (_r1mach (($6_ = 3, &$6_)), 0.3334);
    xmaxt_ = powl ((-1.5 * logf (_r1mach (&_k1))), 0.6667);
    xmax_ = xmaxt_ - xmaxt_ * logf (xmaxt_) / (4.0 * sqrtf (xmaxt_) + 1.0) - 0.01;
  }
  first_ = FALSE;
  if ((*x_) >= -1.0) {
    goto _l20;
  }
  (void) _r9aimp (x_, &xm_, &theta_);
  ai_ = xm_ * cosf (theta_);
  goto _l0;
  _l20:;
  if ((*x_) > 1.0) {
    goto _l30;
  }
  z_ = 0.0;
  if (_abs ((*x_)) > x3sml_) {
    z_ = ((*x_) * (*x_) * (*x_));
  }
  ai_ = 0.375 + (_csevl (&z_, aifcs_, &naif_) - (*x_) * (0.25 + _csevl (&z_, aigcs_, &naig_)));
  goto _l0;
  _l30:;
  if ((*x_) > xmax_) {
    goto _l40;
  }
  ai_ = _aie (x_) * expf (-2.0 * (*x_) * sqrtf ((*x_)) / 3.0);
  goto _l0;
  _l40:;
  ai_ = 0.0;
  (void) _xermsg (_dc_0, _dc_1, _dc_2, &_k1, &_k1);
  _l0:;
  __calls[1].calls++;
  return ai_;
}

real_4 _albeta (real_4 _p_ a_, real_4 _p_ b_)
{
  static real_4 albeta_, sq2pil_, p_, q_, corr_;
  int_4 _data_k_70, $0_;
  real_4 $1_, $2_, $3_, $4_, $5_;
  extern real_4 _gamma ();
#define _data_n_70 1
  static real_4 _data_l_70[_data_n_70] = {
    0.91893853320467274e0
  };
  if (__calls[2].calls == 0) {
    _data_k_70 = 0;
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    sq2pil_ = _data_l_70[_data_k_70++];
  }
  p_ = _min ((*a_), (*b_));
  q_ = _max ((*a_), (*b_));
  if (p_ <= 0.0) {
    (void) _xermsg (_dc_0, _dc_3, _dc_4, &_k1, ($0_ = 2, &$0_));
  }
  if (p_ >= 10.0) {
    goto _l30;
  }
  if (q_ >= 10.0) {
    goto _l20;
  }
  albeta_ = logf (_gamma (&p_) * (_gamma (&q_) / _gamma (($1_ = p_ + q_, &$1_))));
  goto _l0;
  _l20:;
  corr_ = _r9lgmc (&q_) - _r9lgmc (($2_ = p_ + q_, &$2_));
  albeta_ = lgammaf (p_) + corr_ + p_ - p_ * logf (p_ + q_) + (q_ - 0.5) * _alnrel (($3_ = -p_ / (p_ + q_), &$3_));
  goto _l0;
  _l30:;
  corr_ = _r9lgmc (&p_) + _r9lgmc (&q_) - _r9lgmc (($4_ = p_ + q_, &$4_));
  albeta_ = -0.5 * logf (q_) + sq2pil_ + corr_ + (p_ - 0.5) * logf (p_ / (p_ + q_)) + q_ * _alnrel (($5_ = -p_ / (p_ + 
  q_), &$5_));
  _l0:;
  __calls[2].calls++;
  return albeta_;
}

int_4 _algams (real_4 _p_ x_, real_4 _p_ algam_, real_4 _p_ sgngam_)
{
  static int_4 int_;
  (*algam_) = lgammaf ((*x_));
  (*sgngam_) = 1.0;
  if ((*x_) > 0.0) {
    goto _l0;
  }
  int_ = fmod (-_aintd ((*x_)), 2.0) + 0.1;
  if (int_ == 0) {
    (*sgngam_) = -1.0;
  }
  _l0:;
  __calls[3].calls++;
  return 0;
}

real_4 _ali (real_4 _p_ x_)
{
  static real_4 ali_;
  int_4 $0_, $1_, $2_;
  real_4 $3_;
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_5, _dc_6, &_k1, ($0_ = 2, &$0_));
  }
  if ((*x_) == 1.0) {
    (void) _xermsg (_dc_0, _dc_5, _dc_7, ($1_ = 2, &$1_), ($2_ = 2, &$2_));
  }
  ali_ = _ei (($3_ = logf ((*x_)), &$3_));
  __calls[4].calls++;
  return ali_;
}

real_4 _alnrel (real_4 _p_ x_)
{
  static int_4 nlnrel_;
  static logical_4 first_;
  static real_4 alnrel_, alnrcs_[23], xmin_;
  int_4 _data_k_71, _data_k_72, _data_k_73, _data_k_74, _data_k_75, _data_k_76, _data_k_77, _data_k_78, _data_k_79, 
  _data_k_80, _data_k_81, _data_k_82, _data_k_83, _data_k_84, _data_k_85, _data_k_86, _data_k_87, _data_k_88, _data_k_89, 
  _data_k_90, _data_k_91, _data_k_92, _data_k_93, _data_k_94, $0_, $1_, $3_, $4_, $5_;
  real_4 $2_, $6_;
  extern real_4 _r1mach ();
#define _data_n_71 1
  static real_4 _data_l_71[_data_n_71] = {
    1.037869356274377e0
  };
#define _data_n_72 1
  static real_4 _data_l_72[_data_n_72] = {
    -.13364301504908918e0
  };
#define _data_n_73 1
  static real_4 _data_l_73[_data_n_73] = {
    .019408249135520563e0
  };
#define _data_n_74 1
  static real_4 _data_l_74[_data_n_74] = {
    -.003010755112753577e0
  };
#define _data_n_75 1
  static real_4 _data_l_75[_data_n_75] = {
    .000486946147971548e0
  };
#define _data_n_76 1
  static real_4 _data_l_76[_data_n_76] = {
    -.000081054881893175e0
  };
#define _data_n_77 1
  static real_4 _data_l_77[_data_n_77] = {
    .000013778847799559e0
  };
#define _data_n_78 1
  static real_4 _data_l_78[_data_n_78] = {
    -.000002380221089435e0
  };
#define _data_n_79 1
  static real_4 _data_l_79[_data_n_79] = {
    .000000416404162138e0
  };
#define _data_n_80 1
  static real_4 _data_l_80[_data_n_80] = {
    -.000000073595828378e0
  };
#define _data_n_81 1
  static real_4 _data_l_81[_data_n_81] = {
    .000000013117611876e0
  };
#define _data_n_82 1
  static real_4 _data_l_82[_data_n_82] = {
    -.000000002354670931e0
  };
#define _data_n_83 1
  static real_4 _data_l_83[_data_n_83] = {
    .000000000425227732e0
  };
#define _data_n_84 1
  static real_4 _data_l_84[_data_n_84] = {
    -.000000000077190894e0
  };
#define _data_n_85 1
  static real_4 _data_l_85[_data_n_85] = {
    .000000000014075746e0
  };
#define _data_n_86 1
  static real_4 _data_l_86[_data_n_86] = {
    -.000000000002576907e0
  };
#define _data_n_87 1
  static real_4 _data_l_87[_data_n_87] = {
    .000000000000473424e0
  };
#define _data_n_88 1
  static real_4 _data_l_88[_data_n_88] = {
    -.000000000000087249e0
  };
#define _data_n_89 1
  static real_4 _data_l_89[_data_n_89] = {
    .000000000000016124e0
  };
#define _data_n_90 1
  static real_4 _data_l_90[_data_n_90] = {
    -.000000000000002987e0
  };
#define _data_n_91 1
  static real_4 _data_l_91[_data_n_91] = {
    .000000000000000554e0
  };
#define _data_n_92 1
  static real_4 _data_l_92[_data_n_92] = {
    -.000000000000000103e0
  };
#define _data_n_93 1
  static real_4 _data_l_93[_data_n_93] = {
    .000000000000000019e0
  };
#define _data_n_94 1
  static logical_4 _data_l_94[_data_n_94] = {
    TRUE
  };
  if (__calls[5].calls == 0) {
    _data_k_71 = 0;
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    alnrcs_[0] = _data_l_71[_data_k_71++];
  }
  if (__calls[5].calls == 0) {
    _data_k_72 = 0;
    if (_data_k_72 >= _data_n_72) {
      _data_k_72 = 0;
    }
    alnrcs_[1] = _data_l_72[_data_k_72++];
  }
  if (__calls[5].calls == 0) {
    _data_k_73 = 0;
    if (_data_k_73 >= _data_n_73) {
      _data_k_73 = 0;
    }
    alnrcs_[2] = _data_l_73[_data_k_73++];
  }
  if (__calls[5].calls == 0) {
    _data_k_74 = 0;
    if (_data_k_74 >= _data_n_74) {
      _data_k_74 = 0;
    }
    alnrcs_[3] = _data_l_74[_data_k_74++];
  }
  if (__calls[5].calls == 0) {
    _data_k_75 = 0;
    if (_data_k_75 >= _data_n_75) {
      _data_k_75 = 0;
    }
    alnrcs_[4] = _data_l_75[_data_k_75++];
  }
  if (__calls[5].calls == 0) {
    _data_k_76 = 0;
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    alnrcs_[5] = _data_l_76[_data_k_76++];
  }
  if (__calls[5].calls == 0) {
    _data_k_77 = 0;
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    alnrcs_[6] = _data_l_77[_data_k_77++];
  }
  if (__calls[5].calls == 0) {
    _data_k_78 = 0;
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    alnrcs_[7] = _data_l_78[_data_k_78++];
  }
  if (__calls[5].calls == 0) {
    _data_k_79 = 0;
    if (_data_k_79 >= _data_n_79) {
      _data_k_79 = 0;
    }
    alnrcs_[8] = _data_l_79[_data_k_79++];
  }
  if (__calls[5].calls == 0) {
    _data_k_80 = 0;
    if (_data_k_80 >= _data_n_80) {
      _data_k_80 = 0;
    }
    alnrcs_[9] = _data_l_80[_data_k_80++];
  }
  if (__calls[5].calls == 0) {
    _data_k_81 = 0;
    if (_data_k_81 >= _data_n_81) {
      _data_k_81 = 0;
    }
    alnrcs_[10] = _data_l_81[_data_k_81++];
  }
  if (__calls[5].calls == 0) {
    _data_k_82 = 0;
    if (_data_k_82 >= _data_n_82) {
      _data_k_82 = 0;
    }
    alnrcs_[11] = _data_l_82[_data_k_82++];
  }
  if (__calls[5].calls == 0) {
    _data_k_83 = 0;
    if (_data_k_83 >= _data_n_83) {
      _data_k_83 = 0;
    }
    alnrcs_[12] = _data_l_83[_data_k_83++];
  }
  if (__calls[5].calls == 0) {
    _data_k_84 = 0;
    if (_data_k_84 >= _data_n_84) {
      _data_k_84 = 0;
    }
    alnrcs_[13] = _data_l_84[_data_k_84++];
  }
  if (__calls[5].calls == 0) {
    _data_k_85 = 0;
    if (_data_k_85 >= _data_n_85) {
      _data_k_85 = 0;
    }
    alnrcs_[14] = _data_l_85[_data_k_85++];
  }
  if (__calls[5].calls == 0) {
    _data_k_86 = 0;
    if (_data_k_86 >= _data_n_86) {
      _data_k_86 = 0;
    }
    alnrcs_[15] = _data_l_86[_data_k_86++];
  }
  if (__calls[5].calls == 0) {
    _data_k_87 = 0;
    if (_data_k_87 >= _data_n_87) {
      _data_k_87 = 0;
    }
    alnrcs_[16] = _data_l_87[_data_k_87++];
  }
  if (__calls[5].calls == 0) {
    _data_k_88 = 0;
    if (_data_k_88 >= _data_n_88) {
      _data_k_88 = 0;
    }
    alnrcs_[17] = _data_l_88[_data_k_88++];
  }
  if (__calls[5].calls == 0) {
    _data_k_89 = 0;
    if (_data_k_89 >= _data_n_89) {
      _data_k_89 = 0;
    }
    alnrcs_[18] = _data_l_89[_data_k_89++];
  }
  if (__calls[5].calls == 0) {
    _data_k_90 = 0;
    if (_data_k_90 >= _data_n_90) {
      _data_k_90 = 0;
    }
    alnrcs_[19] = _data_l_90[_data_k_90++];
  }
  if (__calls[5].calls == 0) {
    _data_k_91 = 0;
    if (_data_k_91 >= _data_n_91) {
      _data_k_91 = 0;
    }
    alnrcs_[20] = _data_l_91[_data_k_91++];
  }
  if (__calls[5].calls == 0) {
    _data_k_92 = 0;
    if (_data_k_92 >= _data_n_92) {
      _data_k_92 = 0;
    }
    alnrcs_[21] = _data_l_92[_data_k_92++];
  }
  if (__calls[5].calls == 0) {
    _data_k_93 = 0;
    if (_data_k_93 >= _data_n_93) {
      _data_k_93 = 0;
    }
    alnrcs_[22] = _data_l_93[_data_k_93++];
  }
  if (__calls[5].calls == 0) {
    _data_k_94 = 0;
    if (_data_k_94 >= _data_n_94) {
      _data_k_94 = 0;
    }
    first_ = _data_l_94[_data_k_94++];
  }
  if (first_) {
    nlnrel_ = _inits (alnrcs_, ($0_ = 23, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    xmin_ = -1.0 + sqrtf (_r1mach (($3_ = 4, &$3_)));
  }
  first_ = FALSE;
  if ((*x_) <= -1.0) {
    (void) _xermsg (_dc_0, _dc_8, _dc_9, ($4_ = 2, &$4_), ($5_ = 2, &$5_));
  }
  if ((*x_) < xmin_) {
    (void) _xermsg (_dc_0, _dc_8, _dc_10, &_k1, &_k1);
  }
  if (_abs ((*x_)) <= 0.375) {
    alnrel_ = (*x_) * (1.0 - (*x_) * _csevl (($6_ = (*x_) / .375, &$6_), alnrcs_, &nlnrel_));
  }
  if (_abs ((*x_)) > 0.375) {
    alnrel_ = logf (1.0 + (*x_));
  }
  __calls[5].calls++;
  return alnrel_;
}

real_4 _besi0e (real_4 _p_ x_)
{
  static int_4 nti0_, ntai0_, ntai02_;
  static logical_4 first_;
  static real_4 besi0e_, bi0cs_[12], ai0cs_[21], ai02cs_[22], xsml_, y_;
  int_4 _data_k_95, _data_k_96, _data_k_97, _data_k_98, _data_k_99, _data_k_100, _data_k_101, _data_k_102, _data_k_103, 
  _data_k_104, _data_k_105, _data_k_106, _data_k_107, _data_k_108, _data_k_109, _data_k_110, _data_k_111, _data_k_112, 
  _data_k_113, _data_k_114, _data_k_115, _data_k_116, _data_k_117, _data_k_118, _data_k_119, _data_k_120, _data_k_121, 
  _data_k_122, _data_k_123, _data_k_124, _data_k_125, _data_k_126, _data_k_127, _data_k_128, _data_k_129, _data_k_130, 
  _data_k_131, _data_k_132, _data_k_133, _data_k_134, _data_k_135, _data_k_136, _data_k_137, _data_k_138, _data_k_139, 
  _data_k_140, _data_k_141, _data_k_142, _data_k_143, _data_k_144, _data_k_145, _data_k_146, _data_k_147, _data_k_148, 
  _data_k_149, _data_k_150, $0_, $1_, $3_, $4_, $6_, $7_, $9_;
  real_4 $2_, $5_, $8_, $10_, $11_, $12_;
  extern real_4 _r1mach ();
#define _data_n_95 1
  static real_4 _data_l_95[_data_n_95] = {
    -.07660547252839144951e0
  };
#define _data_n_96 1
  static real_4 _data_l_96[_data_n_96] = {
    1.92733795399380827e0
  };
#define _data_n_97 1
  static real_4 _data_l_97[_data_n_97] = {
    .2282644586920301339e0
  };
#define _data_n_98 1
  static real_4 _data_l_98[_data_n_98] = {
    .01304891466707290428e0
  };
#define _data_n_99 1
  static real_4 _data_l_99[_data_n_99] = {
    .00043442709008164874e0
  };
#define _data_n_100 1
  static real_4 _data_l_100[_data_n_100] = {
    .00000942265768600193e0
  };
#define _data_n_101 1
  static real_4 _data_l_101[_data_n_101] = {
    .00000014340062895106e0
  };
#define _data_n_102 1
  static real_4 _data_l_102[_data_n_102] = {
    .00000000161384906966e0
  };
#define _data_n_103 1
  static real_4 _data_l_103[_data_n_103] = {
    .00000000001396650044e0
  };
#define _data_n_104 1
  static real_4 _data_l_104[_data_n_104] = {
    .00000000000009579451e0
  };
#define _data_n_105 1
  static real_4 _data_l_105[_data_n_105] = {
    .00000000000000053339e0
  };
#define _data_n_106 1
  static real_4 _data_l_106[_data_n_106] = {
    .00000000000000000245e0
  };
#define _data_n_107 1
  static real_4 _data_l_107[_data_n_107] = {
    .07575994494023796e0
  };
#define _data_n_108 1
  static real_4 _data_l_108[_data_n_108] = {
    .00759138081082334e0
  };
#define _data_n_109 1
  static real_4 _data_l_109[_data_n_109] = {
    .00041531313389237e0
  };
#define _data_n_110 1
  static real_4 _data_l_110[_data_n_110] = {
    .00001070076463439e0
  };
#define _data_n_111 1
  static real_4 _data_l_111[_data_n_111] = {
    -.00000790117997921e0
  };
#define _data_n_112 1
  static real_4 _data_l_112[_data_n_112] = {
    -.00000078261435014e0
  };
#define _data_n_113 1
  static real_4 _data_l_113[_data_n_113] = {
    .00000027838499429e0
  };
#define _data_n_114 1
  static real_4 _data_l_114[_data_n_114] = {
    .0000000082524726e0
  };
#define _data_n_115 1
  static real_4 _data_l_115[_data_n_115] = {
    -.00000001204463945e0
  };
#define _data_n_116 1
  static real_4 _data_l_116[_data_n_116] = {
    .00000000155964859e0
  };
#define _data_n_117 1
  static real_4 _data_l_117[_data_n_117] = {
    .00000000022925563e0
  };
#define _data_n_118 1
  static real_4 _data_l_118[_data_n_118] = {
    -.00000000011916228e0
  };
#define _data_n_119 1
  static real_4 _data_l_119[_data_n_119] = {
    .00000000001757854e0
  };
#define _data_n_120 1
  static real_4 _data_l_120[_data_n_120] = {
    .00000000000112822e0
  };
#define _data_n_121 1
  static real_4 _data_l_121[_data_n_121] = {
    -.00000000000114684e0
  };
#define _data_n_122 1
  static real_4 _data_l_122[_data_n_122] = {
    .00000000000027155e0
  };
#define _data_n_123 1
  static real_4 _data_l_123[_data_n_123] = {
    -.00000000000002415e0
  };
#define _data_n_124 1
  static real_4 _data_l_124[_data_n_124] = {
    -.00000000000000608e0
  };
#define _data_n_125 1
  static real_4 _data_l_125[_data_n_125] = {
    .00000000000000314e0
  };
#define _data_n_126 1
  static real_4 _data_l_126[_data_n_126] = {
    -.00000000000000071e0
  };
#define _data_n_127 1
  static real_4 _data_l_127[_data_n_127] = {
    .00000000000000007e0
  };
#define _data_n_128 1
  static real_4 _data_l_128[_data_n_128] = {
    .05449041101410882e0
  };
#define _data_n_129 1
  static real_4 _data_l_129[_data_n_129] = {
    .00336911647825569e0
  };
#define _data_n_130 1
  static real_4 _data_l_130[_data_n_130] = {
    .00006889758346918e0
  };
#define _data_n_131 1
  static real_4 _data_l_131[_data_n_131] = {
    .00000289137052082e0
  };
#define _data_n_132 1
  static real_4 _data_l_132[_data_n_132] = {
    .00000020489185893e0
  };
#define _data_n_133 1
  static real_4 _data_l_133[_data_n_133] = {
    .00000002266668991e0
  };
#define _data_n_134 1
  static real_4 _data_l_134[_data_n_134] = {
    .00000000339623203e0
  };
#define _data_n_135 1
  static real_4 _data_l_135[_data_n_135] = {
    .00000000049406022e0
  };
#define _data_n_136 1
  static real_4 _data_l_136[_data_n_136] = {
    .00000000001188914e0
  };
#define _data_n_137 1
  static real_4 _data_l_137[_data_n_137] = {
    -.00000000003149915e0
  };
#define _data_n_138 1
  static real_4 _data_l_138[_data_n_138] = {
    -.0000000000132158e0
  };
#define _data_n_139 1
  static real_4 _data_l_139[_data_n_139] = {
    -.00000000000179419e0
  };
#define _data_n_140 1
  static real_4 _data_l_140[_data_n_140] = {
    .00000000000071801e0
  };
#define _data_n_141 1
  static real_4 _data_l_141[_data_n_141] = {
    .00000000000038529e0
  };
#define _data_n_142 1
  static real_4 _data_l_142[_data_n_142] = {
    .00000000000001539e0
  };
#define _data_n_143 1
  static real_4 _data_l_143[_data_n_143] = {
    -.00000000000004151e0
  };
#define _data_n_144 1
  static real_4 _data_l_144[_data_n_144] = {
    -.00000000000000954e0
  };
#define _data_n_145 1
  static real_4 _data_l_145[_data_n_145] = {
    .00000000000000382e0
  };
#define _data_n_146 1
  static real_4 _data_l_146[_data_n_146] = {
    .00000000000000176e0
  };
#define _data_n_147 1
  static real_4 _data_l_147[_data_n_147] = {
    -.00000000000000034e0
  };
#define _data_n_148 1
  static real_4 _data_l_148[_data_n_148] = {
    -.00000000000000027e0
  };
#define _data_n_149 1
  static real_4 _data_l_149[_data_n_149] = {
    .00000000000000003e0
  };
#define _data_n_150 1
  static logical_4 _data_l_150[_data_n_150] = {
    TRUE
  };
  if (__calls[6].calls == 0) {
    _data_k_95 = 0;
    if (_data_k_95 >= _data_n_95) {
      _data_k_95 = 0;
    }
    bi0cs_[0] = _data_l_95[_data_k_95++];
  }
  if (__calls[6].calls == 0) {
    _data_k_96 = 0;
    if (_data_k_96 >= _data_n_96) {
      _data_k_96 = 0;
    }
    bi0cs_[1] = _data_l_96[_data_k_96++];
  }
  if (__calls[6].calls == 0) {
    _data_k_97 = 0;
    if (_data_k_97 >= _data_n_97) {
      _data_k_97 = 0;
    }
    bi0cs_[2] = _data_l_97[_data_k_97++];
  }
  if (__calls[6].calls == 0) {
    _data_k_98 = 0;
    if (_data_k_98 >= _data_n_98) {
      _data_k_98 = 0;
    }
    bi0cs_[3] = _data_l_98[_data_k_98++];
  }
  if (__calls[6].calls == 0) {
    _data_k_99 = 0;
    if (_data_k_99 >= _data_n_99) {
      _data_k_99 = 0;
    }
    bi0cs_[4] = _data_l_99[_data_k_99++];
  }
  if (__calls[6].calls == 0) {
    _data_k_100 = 0;
    if (_data_k_100 >= _data_n_100) {
      _data_k_100 = 0;
    }
    bi0cs_[5] = _data_l_100[_data_k_100++];
  }
  if (__calls[6].calls == 0) {
    _data_k_101 = 0;
    if (_data_k_101 >= _data_n_101) {
      _data_k_101 = 0;
    }
    bi0cs_[6] = _data_l_101[_data_k_101++];
  }
  if (__calls[6].calls == 0) {
    _data_k_102 = 0;
    if (_data_k_102 >= _data_n_102) {
      _data_k_102 = 0;
    }
    bi0cs_[7] = _data_l_102[_data_k_102++];
  }
  if (__calls[6].calls == 0) {
    _data_k_103 = 0;
    if (_data_k_103 >= _data_n_103) {
      _data_k_103 = 0;
    }
    bi0cs_[8] = _data_l_103[_data_k_103++];
  }
  if (__calls[6].calls == 0) {
    _data_k_104 = 0;
    if (_data_k_104 >= _data_n_104) {
      _data_k_104 = 0;
    }
    bi0cs_[9] = _data_l_104[_data_k_104++];
  }
  if (__calls[6].calls == 0) {
    _data_k_105 = 0;
    if (_data_k_105 >= _data_n_105) {
      _data_k_105 = 0;
    }
    bi0cs_[10] = _data_l_105[_data_k_105++];
  }
  if (__calls[6].calls == 0) {
    _data_k_106 = 0;
    if (_data_k_106 >= _data_n_106) {
      _data_k_106 = 0;
    }
    bi0cs_[11] = _data_l_106[_data_k_106++];
  }
  if (__calls[6].calls == 0) {
    _data_k_107 = 0;
    if (_data_k_107 >= _data_n_107) {
      _data_k_107 = 0;
    }
    ai0cs_[0] = _data_l_107[_data_k_107++];
  }
  if (__calls[6].calls == 0) {
    _data_k_108 = 0;
    if (_data_k_108 >= _data_n_108) {
      _data_k_108 = 0;
    }
    ai0cs_[1] = _data_l_108[_data_k_108++];
  }
  if (__calls[6].calls == 0) {
    _data_k_109 = 0;
    if (_data_k_109 >= _data_n_109) {
      _data_k_109 = 0;
    }
    ai0cs_[2] = _data_l_109[_data_k_109++];
  }
  if (__calls[6].calls == 0) {
    _data_k_110 = 0;
    if (_data_k_110 >= _data_n_110) {
      _data_k_110 = 0;
    }
    ai0cs_[3] = _data_l_110[_data_k_110++];
  }
  if (__calls[6].calls == 0) {
    _data_k_111 = 0;
    if (_data_k_111 >= _data_n_111) {
      _data_k_111 = 0;
    }
    ai0cs_[4] = _data_l_111[_data_k_111++];
  }
  if (__calls[6].calls == 0) {
    _data_k_112 = 0;
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ai0cs_[5] = _data_l_112[_data_k_112++];
  }
  if (__calls[6].calls == 0) {
    _data_k_113 = 0;
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ai0cs_[6] = _data_l_113[_data_k_113++];
  }
  if (__calls[6].calls == 0) {
    _data_k_114 = 0;
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ai0cs_[7] = _data_l_114[_data_k_114++];
  }
  if (__calls[6].calls == 0) {
    _data_k_115 = 0;
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ai0cs_[8] = _data_l_115[_data_k_115++];
  }
  if (__calls[6].calls == 0) {
    _data_k_116 = 0;
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ai0cs_[9] = _data_l_116[_data_k_116++];
  }
  if (__calls[6].calls == 0) {
    _data_k_117 = 0;
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    ai0cs_[10] = _data_l_117[_data_k_117++];
  }
  if (__calls[6].calls == 0) {
    _data_k_118 = 0;
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    ai0cs_[11] = _data_l_118[_data_k_118++];
  }
  if (__calls[6].calls == 0) {
    _data_k_119 = 0;
    if (_data_k_119 >= _data_n_119) {
      _data_k_119 = 0;
    }
    ai0cs_[12] = _data_l_119[_data_k_119++];
  }
  if (__calls[6].calls == 0) {
    _data_k_120 = 0;
    if (_data_k_120 >= _data_n_120) {
      _data_k_120 = 0;
    }
    ai0cs_[13] = _data_l_120[_data_k_120++];
  }
  if (__calls[6].calls == 0) {
    _data_k_121 = 0;
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    ai0cs_[14] = _data_l_121[_data_k_121++];
  }
  if (__calls[6].calls == 0) {
    _data_k_122 = 0;
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    ai0cs_[15] = _data_l_122[_data_k_122++];
  }
  if (__calls[6].calls == 0) {
    _data_k_123 = 0;
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    ai0cs_[16] = _data_l_123[_data_k_123++];
  }
  if (__calls[6].calls == 0) {
    _data_k_124 = 0;
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    ai0cs_[17] = _data_l_124[_data_k_124++];
  }
  if (__calls[6].calls == 0) {
    _data_k_125 = 0;
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    ai0cs_[18] = _data_l_125[_data_k_125++];
  }
  if (__calls[6].calls == 0) {
    _data_k_126 = 0;
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    ai0cs_[19] = _data_l_126[_data_k_126++];
  }
  if (__calls[6].calls == 0) {
    _data_k_127 = 0;
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    ai0cs_[20] = _data_l_127[_data_k_127++];
  }
  if (__calls[6].calls == 0) {
    _data_k_128 = 0;
    if (_data_k_128 >= _data_n_128) {
      _data_k_128 = 0;
    }
    ai02cs_[0] = _data_l_128[_data_k_128++];
  }
  if (__calls[6].calls == 0) {
    _data_k_129 = 0;
    if (_data_k_129 >= _data_n_129) {
      _data_k_129 = 0;
    }
    ai02cs_[1] = _data_l_129[_data_k_129++];
  }
  if (__calls[6].calls == 0) {
    _data_k_130 = 0;
    if (_data_k_130 >= _data_n_130) {
      _data_k_130 = 0;
    }
    ai02cs_[2] = _data_l_130[_data_k_130++];
  }
  if (__calls[6].calls == 0) {
    _data_k_131 = 0;
    if (_data_k_131 >= _data_n_131) {
      _data_k_131 = 0;
    }
    ai02cs_[3] = _data_l_131[_data_k_131++];
  }
  if (__calls[6].calls == 0) {
    _data_k_132 = 0;
    if (_data_k_132 >= _data_n_132) {
      _data_k_132 = 0;
    }
    ai02cs_[4] = _data_l_132[_data_k_132++];
  }
  if (__calls[6].calls == 0) {
    _data_k_133 = 0;
    if (_data_k_133 >= _data_n_133) {
      _data_k_133 = 0;
    }
    ai02cs_[5] = _data_l_133[_data_k_133++];
  }
  if (__calls[6].calls == 0) {
    _data_k_134 = 0;
    if (_data_k_134 >= _data_n_134) {
      _data_k_134 = 0;
    }
    ai02cs_[6] = _data_l_134[_data_k_134++];
  }
  if (__calls[6].calls == 0) {
    _data_k_135 = 0;
    if (_data_k_135 >= _data_n_135) {
      _data_k_135 = 0;
    }
    ai02cs_[7] = _data_l_135[_data_k_135++];
  }
  if (__calls[6].calls == 0) {
    _data_k_136 = 0;
    if (_data_k_136 >= _data_n_136) {
      _data_k_136 = 0;
    }
    ai02cs_[8] = _data_l_136[_data_k_136++];
  }
  if (__calls[6].calls == 0) {
    _data_k_137 = 0;
    if (_data_k_137 >= _data_n_137) {
      _data_k_137 = 0;
    }
    ai02cs_[9] = _data_l_137[_data_k_137++];
  }
  if (__calls[6].calls == 0) {
    _data_k_138 = 0;
    if (_data_k_138 >= _data_n_138) {
      _data_k_138 = 0;
    }
    ai02cs_[10] = _data_l_138[_data_k_138++];
  }
  if (__calls[6].calls == 0) {
    _data_k_139 = 0;
    if (_data_k_139 >= _data_n_139) {
      _data_k_139 = 0;
    }
    ai02cs_[11] = _data_l_139[_data_k_139++];
  }
  if (__calls[6].calls == 0) {
    _data_k_140 = 0;
    if (_data_k_140 >= _data_n_140) {
      _data_k_140 = 0;
    }
    ai02cs_[12] = _data_l_140[_data_k_140++];
  }
  if (__calls[6].calls == 0) {
    _data_k_141 = 0;
    if (_data_k_141 >= _data_n_141) {
      _data_k_141 = 0;
    }
    ai02cs_[13] = _data_l_141[_data_k_141++];
  }
  if (__calls[6].calls == 0) {
    _data_k_142 = 0;
    if (_data_k_142 >= _data_n_142) {
      _data_k_142 = 0;
    }
    ai02cs_[14] = _data_l_142[_data_k_142++];
  }
  if (__calls[6].calls == 0) {
    _data_k_143 = 0;
    if (_data_k_143 >= _data_n_143) {
      _data_k_143 = 0;
    }
    ai02cs_[15] = _data_l_143[_data_k_143++];
  }
  if (__calls[6].calls == 0) {
    _data_k_144 = 0;
    if (_data_k_144 >= _data_n_144) {
      _data_k_144 = 0;
    }
    ai02cs_[16] = _data_l_144[_data_k_144++];
  }
  if (__calls[6].calls == 0) {
    _data_k_145 = 0;
    if (_data_k_145 >= _data_n_145) {
      _data_k_145 = 0;
    }
    ai02cs_[17] = _data_l_145[_data_k_145++];
  }
  if (__calls[6].calls == 0) {
    _data_k_146 = 0;
    if (_data_k_146 >= _data_n_146) {
      _data_k_146 = 0;
    }
    ai02cs_[18] = _data_l_146[_data_k_146++];
  }
  if (__calls[6].calls == 0) {
    _data_k_147 = 0;
    if (_data_k_147 >= _data_n_147) {
      _data_k_147 = 0;
    }
    ai02cs_[19] = _data_l_147[_data_k_147++];
  }
  if (__calls[6].calls == 0) {
    _data_k_148 = 0;
    if (_data_k_148 >= _data_n_148) {
      _data_k_148 = 0;
    }
    ai02cs_[20] = _data_l_148[_data_k_148++];
  }
  if (__calls[6].calls == 0) {
    _data_k_149 = 0;
    if (_data_k_149 >= _data_n_149) {
      _data_k_149 = 0;
    }
    ai02cs_[21] = _data_l_149[_data_k_149++];
  }
  if (__calls[6].calls == 0) {
    _data_k_150 = 0;
    if (_data_k_150 >= _data_n_150) {
      _data_k_150 = 0;
    }
    first_ = _data_l_150[_data_k_150++];
  }
  if (first_) {
    nti0_ = _inits (bi0cs_, ($0_ = 12, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    ntai0_ = _inits (ai0cs_, ($3_ = 21, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    ntai02_ = _inits (ai02cs_, ($6_ = 22, &$6_), ($8_ = 0.1 * _r1mach (($7_ = 3, &$7_)), &$8_));
    xsml_ = sqrtf (4.5 * _r1mach (($9_ = 3, &$9_)));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 3.0) {
    goto _l20;
  }
  besi0e_ = 1.0 - (*x_);
  if (y_ > xsml_) {
    besi0e_ = expf (-y_) * (2.75 + _csevl (($10_ = y_ * y_ / 4.5 - 1.0, &$10_), bi0cs_, &nti0_));
  }
  goto _l0;
  _l20:;
  if (y_ <= 8.0) {
    besi0e_ = (.375 + _csevl (($11_ = (48.0 / y_ - 11.0) / 5.0, &$11_), ai0cs_, &ntai0_)) / sqrtf (y_);
  }
  if (y_ > 8.0) {
    besi0e_ = (.375 + _csevl (($12_ = 16.0 / y_ - 1.0, &$12_), ai02cs_, &ntai02_)) / sqrtf (y_);
  }
  _l0:;
  __calls[6].calls++;
  return besi0e_;
}

real_4 _besi0 (real_4 _p_ x_)
{
  static int_4 nti0_;
  static logical_4 first_;
  static real_4 besi0_, bi0cs_[12], xsml_, xmax_, y_;
  int_4 _data_k_151, _data_k_152, _data_k_153, _data_k_154, _data_k_155, _data_k_156, _data_k_157, _data_k_158, 
  _data_k_159, _data_k_160, _data_k_161, _data_k_162, _data_k_163, $0_, $1_, $3_, $4_, $6_;
  real_4 $2_, $5_;
  extern real_4 _r1mach ();
#define _data_n_151 1
  static real_4 _data_l_151[_data_n_151] = {
    -.07660547252839144951e0
  };
#define _data_n_152 1
  static real_4 _data_l_152[_data_n_152] = {
    1.92733795399380827e0
  };
#define _data_n_153 1
  static real_4 _data_l_153[_data_n_153] = {
    .2282644586920301339e0
  };
#define _data_n_154 1
  static real_4 _data_l_154[_data_n_154] = {
    .01304891466707290428e0
  };
#define _data_n_155 1
  static real_4 _data_l_155[_data_n_155] = {
    .00043442709008164874e0
  };
#define _data_n_156 1
  static real_4 _data_l_156[_data_n_156] = {
    .00000942265768600193e0
  };
#define _data_n_157 1
  static real_4 _data_l_157[_data_n_157] = {
    .00000014340062895106e0
  };
#define _data_n_158 1
  static real_4 _data_l_158[_data_n_158] = {
    .00000000161384906966e0
  };
#define _data_n_159 1
  static real_4 _data_l_159[_data_n_159] = {
    .00000000001396650044e0
  };
#define _data_n_160 1
  static real_4 _data_l_160[_data_n_160] = {
    .00000000000009579451e0
  };
#define _data_n_161 1
  static real_4 _data_l_161[_data_n_161] = {
    .00000000000000053339e0
  };
#define _data_n_162 1
  static real_4 _data_l_162[_data_n_162] = {
    .00000000000000000245e0
  };
#define _data_n_163 1
  static logical_4 _data_l_163[_data_n_163] = {
    TRUE
  };
  if (__calls[7].calls == 0) {
    _data_k_151 = 0;
    if (_data_k_151 >= _data_n_151) {
      _data_k_151 = 0;
    }
    bi0cs_[0] = _data_l_151[_data_k_151++];
  }
  if (__calls[7].calls == 0) {
    _data_k_152 = 0;
    if (_data_k_152 >= _data_n_152) {
      _data_k_152 = 0;
    }
    bi0cs_[1] = _data_l_152[_data_k_152++];
  }
  if (__calls[7].calls == 0) {
    _data_k_153 = 0;
    if (_data_k_153 >= _data_n_153) {
      _data_k_153 = 0;
    }
    bi0cs_[2] = _data_l_153[_data_k_153++];
  }
  if (__calls[7].calls == 0) {
    _data_k_154 = 0;
    if (_data_k_154 >= _data_n_154) {
      _data_k_154 = 0;
    }
    bi0cs_[3] = _data_l_154[_data_k_154++];
  }
  if (__calls[7].calls == 0) {
    _data_k_155 = 0;
    if (_data_k_155 >= _data_n_155) {
      _data_k_155 = 0;
    }
    bi0cs_[4] = _data_l_155[_data_k_155++];
  }
  if (__calls[7].calls == 0) {
    _data_k_156 = 0;
    if (_data_k_156 >= _data_n_156) {
      _data_k_156 = 0;
    }
    bi0cs_[5] = _data_l_156[_data_k_156++];
  }
  if (__calls[7].calls == 0) {
    _data_k_157 = 0;
    if (_data_k_157 >= _data_n_157) {
      _data_k_157 = 0;
    }
    bi0cs_[6] = _data_l_157[_data_k_157++];
  }
  if (__calls[7].calls == 0) {
    _data_k_158 = 0;
    if (_data_k_158 >= _data_n_158) {
      _data_k_158 = 0;
    }
    bi0cs_[7] = _data_l_158[_data_k_158++];
  }
  if (__calls[7].calls == 0) {
    _data_k_159 = 0;
    if (_data_k_159 >= _data_n_159) {
      _data_k_159 = 0;
    }
    bi0cs_[8] = _data_l_159[_data_k_159++];
  }
  if (__calls[7].calls == 0) {
    _data_k_160 = 0;
    if (_data_k_160 >= _data_n_160) {
      _data_k_160 = 0;
    }
    bi0cs_[9] = _data_l_160[_data_k_160++];
  }
  if (__calls[7].calls == 0) {
    _data_k_161 = 0;
    if (_data_k_161 >= _data_n_161) {
      _data_k_161 = 0;
    }
    bi0cs_[10] = _data_l_161[_data_k_161++];
  }
  if (__calls[7].calls == 0) {
    _data_k_162 = 0;
    if (_data_k_162 >= _data_n_162) {
      _data_k_162 = 0;
    }
    bi0cs_[11] = _data_l_162[_data_k_162++];
  }
  if (__calls[7].calls == 0) {
    _data_k_163 = 0;
    if (_data_k_163 >= _data_n_163) {
      _data_k_163 = 0;
    }
    first_ = _data_l_163[_data_k_163++];
  }
  if (first_) {
    nti0_ = _inits (bi0cs_, ($0_ = 12, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    xsml_ = sqrtf (4.5 * _r1mach (($3_ = 3, &$3_)));
    xmax_ = logf (_r1mach (($4_ = 2, &$4_)));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 3.0) {
    goto _l20;
  }
  besi0_ = 1.0;
  if (y_ > xsml_) {
    besi0_ = 2.75 + _csevl (($5_ = y_ * y_ / 4.5 - 1.0, &$5_), bi0cs_, &nti0_);
  }
  goto _l0;
  _l20:;
  if (y_ > xmax_) {
    (void) _xermsg (_dc_0, _dc_11, _dc_12, &_k1, ($6_ = 2, &$6_));
  }
  besi0_ = expf (y_) * _besi0e (x_);
  _l0:;
  __calls[7].calls++;
  return besi0_;
}

real_4 _besi1e (real_4 _p_ x_)
{
  static int_4 nti1_, ntai1_, ntai12_;
  static logical_4 first_;
  static real_4 besi1e_, bi1cs_[11], ai1cs_[21], ai12cs_[22], xmin_, xsml_, y_;
  int_4 _data_k_164, _data_k_165, _data_k_166, _data_k_167, _data_k_168, _data_k_169, _data_k_170, _data_k_171, 
  _data_k_172, _data_k_173, _data_k_174, _data_k_175, _data_k_176, _data_k_177, _data_k_178, _data_k_179, _data_k_180, 
  _data_k_181, _data_k_182, _data_k_183, _data_k_184, _data_k_185, _data_k_186, _data_k_187, _data_k_188, _data_k_189, 
  _data_k_190, _data_k_191, _data_k_192, _data_k_193, _data_k_194, _data_k_195, _data_k_196, _data_k_197, _data_k_198, 
  _data_k_199, _data_k_200, _data_k_201, _data_k_202, _data_k_203, _data_k_204, _data_k_205, _data_k_206, _data_k_207, 
  _data_k_208, _data_k_209, _data_k_210, _data_k_211, _data_k_212, _data_k_213, _data_k_214, _data_k_215, _data_k_216, 
  _data_k_217, _data_k_218, $0_, $1_, $3_, $4_, $6_, $7_, $9_;
  real_4 $2_, $5_, $8_, $10_, $11_, $12_;
  extern real_4 _r1mach ();
#define _data_n_164 1
  static real_4 _data_l_164[_data_n_164] = {
    -.001971713261099859e0
  };
#define _data_n_165 1
  static real_4 _data_l_165[_data_n_165] = {
    .40734887667546481e0
  };
#define _data_n_166 1
  static real_4 _data_l_166[_data_n_166] = {
    .034838994299959456e0
  };
#define _data_n_167 1
  static real_4 _data_l_167[_data_n_167] = {
    .001545394556300123e0
  };
#define _data_n_168 1
  static real_4 _data_l_168[_data_n_168] = {
    .000041888521098377e0
  };
#define _data_n_169 1
  static real_4 _data_l_169[_data_n_169] = {
    .000000764902676483e0
  };
#define _data_n_170 1
  static real_4 _data_l_170[_data_n_170] = {
    .000000010042493924e0
  };
#define _data_n_171 1
  static real_4 _data_l_171[_data_n_171] = {
    .000000000099322077e0
  };
#define _data_n_172 1
  static real_4 _data_l_172[_data_n_172] = {
    .00000000000076638e0
  };
#define _data_n_173 1
  static real_4 _data_l_173[_data_n_173] = {
    .000000000000004741e0
  };
#define _data_n_174 1
  static real_4 _data_l_174[_data_n_174] = {
    .000000000000000024e0
  };
#define _data_n_175 1
  static real_4 _data_l_175[_data_n_175] = {
    -.02846744181881479e0
  };
#define _data_n_176 1
  static real_4 _data_l_176[_data_n_176] = {
    -.01922953231443221e0
  };
#define _data_n_177 1
  static real_4 _data_l_177[_data_n_177] = {
    -.00061151858579437e0
  };
#define _data_n_178 1
  static real_4 _data_l_178[_data_n_178] = {
    -.0000206997125335e0
  };
#define _data_n_179 1
  static real_4 _data_l_179[_data_n_179] = {
    .00000858561914581e0
  };
#define _data_n_180 1
  static real_4 _data_l_180[_data_n_180] = {
    .00000104949824671e0
  };
#define _data_n_181 1
  static real_4 _data_l_181[_data_n_181] = {
    -.00000029183389184e0
  };
#define _data_n_182 1
  static real_4 _data_l_182[_data_n_182] = {
    -.00000001559378146e0
  };
#define _data_n_183 1
  static real_4 _data_l_183[_data_n_183] = {
    .00000001318012367e0
  };
#define _data_n_184 1
  static real_4 _data_l_184[_data_n_184] = {
    -.00000000144842341e0
  };
#define _data_n_185 1
  static real_4 _data_l_185[_data_n_185] = {
    -.00000000029085122e0
  };
#define _data_n_186 1
  static real_4 _data_l_186[_data_n_186] = {
    .00000000012663889e0
  };
#define _data_n_187 1
  static real_4 _data_l_187[_data_n_187] = {
    -.00000000001664947e0
  };
#define _data_n_188 1
  static real_4 _data_l_188[_data_n_188] = {
    -.00000000000166665e0
  };
#define _data_n_189 1
  static real_4 _data_l_189[_data_n_189] = {
    .0000000000012426e0
  };
#define _data_n_190 1
  static real_4 _data_l_190[_data_n_190] = {
    -.00000000000027315e0
  };
#define _data_n_191 1
  static real_4 _data_l_191[_data_n_191] = {
    .00000000000002023e0
  };
#define _data_n_192 1
  static real_4 _data_l_192[_data_n_192] = {
    .0000000000000073e0
  };
#define _data_n_193 1
  static real_4 _data_l_193[_data_n_193] = {
    -.00000000000000333e0
  };
#define _data_n_194 1
  static real_4 _data_l_194[_data_n_194] = {
    .00000000000000071e0
  };
#define _data_n_195 1
  static real_4 _data_l_195[_data_n_195] = {
    -.00000000000000006e0
  };
#define _data_n_196 1
  static real_4 _data_l_196[_data_n_196] = {
    .02857623501828014e0
  };
#define _data_n_197 1
  static real_4 _data_l_197[_data_n_197] = {
    -.00976109749136147e0
  };
#define _data_n_198 1
  static real_4 _data_l_198[_data_n_198] = {
    -.00011058893876263e0
  };
#define _data_n_199 1
  static real_4 _data_l_199[_data_n_199] = {
    -.00000388256480887e0
  };
#define _data_n_200 1
  static real_4 _data_l_200[_data_n_200] = {
    -.00000025122362377e0
  };
#define _data_n_201 1
  static real_4 _data_l_201[_data_n_201] = {
    -.00000002631468847e0
  };
#define _data_n_202 1
  static real_4 _data_l_202[_data_n_202] = {
    -.00000000383538039e0
  };
#define _data_n_203 1
  static real_4 _data_l_203[_data_n_203] = {
    -.00000000055897433e0
  };
#define _data_n_204 1
  static real_4 _data_l_204[_data_n_204] = {
    -.00000000001897495e0
  };
#define _data_n_205 1
  static real_4 _data_l_205[_data_n_205] = {
    .00000000003252602e0
  };
#define _data_n_206 1
  static real_4 _data_l_206[_data_n_206] = {
    .0000000000141258e0
  };
#define _data_n_207 1
  static real_4 _data_l_207[_data_n_207] = {
    .00000000000203564e0
  };
#define _data_n_208 1
  static real_4 _data_l_208[_data_n_208] = {
    -.00000000000071985e0
  };
#define _data_n_209 1
  static real_4 _data_l_209[_data_n_209] = {
    -.00000000000040836e0
  };
#define _data_n_210 1
  static real_4 _data_l_210[_data_n_210] = {
    -.00000000000002101e0
  };
#define _data_n_211 1
  static real_4 _data_l_211[_data_n_211] = {
    .00000000000004273e0
  };
#define _data_n_212 1
  static real_4 _data_l_212[_data_n_212] = {
    .00000000000001041e0
  };
#define _data_n_213 1
  static real_4 _data_l_213[_data_n_213] = {
    -.00000000000000382e0
  };
#define _data_n_214 1
  static real_4 _data_l_214[_data_n_214] = {
    -.00000000000000186e0
  };
#define _data_n_215 1
  static real_4 _data_l_215[_data_n_215] = {
    .00000000000000033e0
  };
#define _data_n_216 1
  static real_4 _data_l_216[_data_n_216] = {
    .00000000000000028e0
  };
#define _data_n_217 1
  static real_4 _data_l_217[_data_n_217] = {
    -.00000000000000003e0
  };
#define _data_n_218 1
  static logical_4 _data_l_218[_data_n_218] = {
    TRUE
  };
  if (__calls[8].calls == 0) {
    _data_k_164 = 0;
    if (_data_k_164 >= _data_n_164) {
      _data_k_164 = 0;
    }
    bi1cs_[0] = _data_l_164[_data_k_164++];
  }
  if (__calls[8].calls == 0) {
    _data_k_165 = 0;
    if (_data_k_165 >= _data_n_165) {
      _data_k_165 = 0;
    }
    bi1cs_[1] = _data_l_165[_data_k_165++];
  }
  if (__calls[8].calls == 0) {
    _data_k_166 = 0;
    if (_data_k_166 >= _data_n_166) {
      _data_k_166 = 0;
    }
    bi1cs_[2] = _data_l_166[_data_k_166++];
  }
  if (__calls[8].calls == 0) {
    _data_k_167 = 0;
    if (_data_k_167 >= _data_n_167) {
      _data_k_167 = 0;
    }
    bi1cs_[3] = _data_l_167[_data_k_167++];
  }
  if (__calls[8].calls == 0) {
    _data_k_168 = 0;
    if (_data_k_168 >= _data_n_168) {
      _data_k_168 = 0;
    }
    bi1cs_[4] = _data_l_168[_data_k_168++];
  }
  if (__calls[8].calls == 0) {
    _data_k_169 = 0;
    if (_data_k_169 >= _data_n_169) {
      _data_k_169 = 0;
    }
    bi1cs_[5] = _data_l_169[_data_k_169++];
  }
  if (__calls[8].calls == 0) {
    _data_k_170 = 0;
    if (_data_k_170 >= _data_n_170) {
      _data_k_170 = 0;
    }
    bi1cs_[6] = _data_l_170[_data_k_170++];
  }
  if (__calls[8].calls == 0) {
    _data_k_171 = 0;
    if (_data_k_171 >= _data_n_171) {
      _data_k_171 = 0;
    }
    bi1cs_[7] = _data_l_171[_data_k_171++];
  }
  if (__calls[8].calls == 0) {
    _data_k_172 = 0;
    if (_data_k_172 >= _data_n_172) {
      _data_k_172 = 0;
    }
    bi1cs_[8] = _data_l_172[_data_k_172++];
  }
  if (__calls[8].calls == 0) {
    _data_k_173 = 0;
    if (_data_k_173 >= _data_n_173) {
      _data_k_173 = 0;
    }
    bi1cs_[9] = _data_l_173[_data_k_173++];
  }
  if (__calls[8].calls == 0) {
    _data_k_174 = 0;
    if (_data_k_174 >= _data_n_174) {
      _data_k_174 = 0;
    }
    bi1cs_[10] = _data_l_174[_data_k_174++];
  }
  if (__calls[8].calls == 0) {
    _data_k_175 = 0;
    if (_data_k_175 >= _data_n_175) {
      _data_k_175 = 0;
    }
    ai1cs_[0] = _data_l_175[_data_k_175++];
  }
  if (__calls[8].calls == 0) {
    _data_k_176 = 0;
    if (_data_k_176 >= _data_n_176) {
      _data_k_176 = 0;
    }
    ai1cs_[1] = _data_l_176[_data_k_176++];
  }
  if (__calls[8].calls == 0) {
    _data_k_177 = 0;
    if (_data_k_177 >= _data_n_177) {
      _data_k_177 = 0;
    }
    ai1cs_[2] = _data_l_177[_data_k_177++];
  }
  if (__calls[8].calls == 0) {
    _data_k_178 = 0;
    if (_data_k_178 >= _data_n_178) {
      _data_k_178 = 0;
    }
    ai1cs_[3] = _data_l_178[_data_k_178++];
  }
  if (__calls[8].calls == 0) {
    _data_k_179 = 0;
    if (_data_k_179 >= _data_n_179) {
      _data_k_179 = 0;
    }
    ai1cs_[4] = _data_l_179[_data_k_179++];
  }
  if (__calls[8].calls == 0) {
    _data_k_180 = 0;
    if (_data_k_180 >= _data_n_180) {
      _data_k_180 = 0;
    }
    ai1cs_[5] = _data_l_180[_data_k_180++];
  }
  if (__calls[8].calls == 0) {
    _data_k_181 = 0;
    if (_data_k_181 >= _data_n_181) {
      _data_k_181 = 0;
    }
    ai1cs_[6] = _data_l_181[_data_k_181++];
  }
  if (__calls[8].calls == 0) {
    _data_k_182 = 0;
    if (_data_k_182 >= _data_n_182) {
      _data_k_182 = 0;
    }
    ai1cs_[7] = _data_l_182[_data_k_182++];
  }
  if (__calls[8].calls == 0) {
    _data_k_183 = 0;
    if (_data_k_183 >= _data_n_183) {
      _data_k_183 = 0;
    }
    ai1cs_[8] = _data_l_183[_data_k_183++];
  }
  if (__calls[8].calls == 0) {
    _data_k_184 = 0;
    if (_data_k_184 >= _data_n_184) {
      _data_k_184 = 0;
    }
    ai1cs_[9] = _data_l_184[_data_k_184++];
  }
  if (__calls[8].calls == 0) {
    _data_k_185 = 0;
    if (_data_k_185 >= _data_n_185) {
      _data_k_185 = 0;
    }
    ai1cs_[10] = _data_l_185[_data_k_185++];
  }
  if (__calls[8].calls == 0) {
    _data_k_186 = 0;
    if (_data_k_186 >= _data_n_186) {
      _data_k_186 = 0;
    }
    ai1cs_[11] = _data_l_186[_data_k_186++];
  }
  if (__calls[8].calls == 0) {
    _data_k_187 = 0;
    if (_data_k_187 >= _data_n_187) {
      _data_k_187 = 0;
    }
    ai1cs_[12] = _data_l_187[_data_k_187++];
  }
  if (__calls[8].calls == 0) {
    _data_k_188 = 0;
    if (_data_k_188 >= _data_n_188) {
      _data_k_188 = 0;
    }
    ai1cs_[13] = _data_l_188[_data_k_188++];
  }
  if (__calls[8].calls == 0) {
    _data_k_189 = 0;
    if (_data_k_189 >= _data_n_189) {
      _data_k_189 = 0;
    }
    ai1cs_[14] = _data_l_189[_data_k_189++];
  }
  if (__calls[8].calls == 0) {
    _data_k_190 = 0;
    if (_data_k_190 >= _data_n_190) {
      _data_k_190 = 0;
    }
    ai1cs_[15] = _data_l_190[_data_k_190++];
  }
  if (__calls[8].calls == 0) {
    _data_k_191 = 0;
    if (_data_k_191 >= _data_n_191) {
      _data_k_191 = 0;
    }
    ai1cs_[16] = _data_l_191[_data_k_191++];
  }
  if (__calls[8].calls == 0) {
    _data_k_192 = 0;
    if (_data_k_192 >= _data_n_192) {
      _data_k_192 = 0;
    }
    ai1cs_[17] = _data_l_192[_data_k_192++];
  }
  if (__calls[8].calls == 0) {
    _data_k_193 = 0;
    if (_data_k_193 >= _data_n_193) {
      _data_k_193 = 0;
    }
    ai1cs_[18] = _data_l_193[_data_k_193++];
  }
  if (__calls[8].calls == 0) {
    _data_k_194 = 0;
    if (_data_k_194 >= _data_n_194) {
      _data_k_194 = 0;
    }
    ai1cs_[19] = _data_l_194[_data_k_194++];
  }
  if (__calls[8].calls == 0) {
    _data_k_195 = 0;
    if (_data_k_195 >= _data_n_195) {
      _data_k_195 = 0;
    }
    ai1cs_[20] = _data_l_195[_data_k_195++];
  }
  if (__calls[8].calls == 0) {
    _data_k_196 = 0;
    if (_data_k_196 >= _data_n_196) {
      _data_k_196 = 0;
    }
    ai12cs_[0] = _data_l_196[_data_k_196++];
  }
  if (__calls[8].calls == 0) {
    _data_k_197 = 0;
    if (_data_k_197 >= _data_n_197) {
      _data_k_197 = 0;
    }
    ai12cs_[1] = _data_l_197[_data_k_197++];
  }
  if (__calls[8].calls == 0) {
    _data_k_198 = 0;
    if (_data_k_198 >= _data_n_198) {
      _data_k_198 = 0;
    }
    ai12cs_[2] = _data_l_198[_data_k_198++];
  }
  if (__calls[8].calls == 0) {
    _data_k_199 = 0;
    if (_data_k_199 >= _data_n_199) {
      _data_k_199 = 0;
    }
    ai12cs_[3] = _data_l_199[_data_k_199++];
  }
  if (__calls[8].calls == 0) {
    _data_k_200 = 0;
    if (_data_k_200 >= _data_n_200) {
      _data_k_200 = 0;
    }
    ai12cs_[4] = _data_l_200[_data_k_200++];
  }
  if (__calls[8].calls == 0) {
    _data_k_201 = 0;
    if (_data_k_201 >= _data_n_201) {
      _data_k_201 = 0;
    }
    ai12cs_[5] = _data_l_201[_data_k_201++];
  }
  if (__calls[8].calls == 0) {
    _data_k_202 = 0;
    if (_data_k_202 >= _data_n_202) {
      _data_k_202 = 0;
    }
    ai12cs_[6] = _data_l_202[_data_k_202++];
  }
  if (__calls[8].calls == 0) {
    _data_k_203 = 0;
    if (_data_k_203 >= _data_n_203) {
      _data_k_203 = 0;
    }
    ai12cs_[7] = _data_l_203[_data_k_203++];
  }
  if (__calls[8].calls == 0) {
    _data_k_204 = 0;
    if (_data_k_204 >= _data_n_204) {
      _data_k_204 = 0;
    }
    ai12cs_[8] = _data_l_204[_data_k_204++];
  }
  if (__calls[8].calls == 0) {
    _data_k_205 = 0;
    if (_data_k_205 >= _data_n_205) {
      _data_k_205 = 0;
    }
    ai12cs_[9] = _data_l_205[_data_k_205++];
  }
  if (__calls[8].calls == 0) {
    _data_k_206 = 0;
    if (_data_k_206 >= _data_n_206) {
      _data_k_206 = 0;
    }
    ai12cs_[10] = _data_l_206[_data_k_206++];
  }
  if (__calls[8].calls == 0) {
    _data_k_207 = 0;
    if (_data_k_207 >= _data_n_207) {
      _data_k_207 = 0;
    }
    ai12cs_[11] = _data_l_207[_data_k_207++];
  }
  if (__calls[8].calls == 0) {
    _data_k_208 = 0;
    if (_data_k_208 >= _data_n_208) {
      _data_k_208 = 0;
    }
    ai12cs_[12] = _data_l_208[_data_k_208++];
  }
  if (__calls[8].calls == 0) {
    _data_k_209 = 0;
    if (_data_k_209 >= _data_n_209) {
      _data_k_209 = 0;
    }
    ai12cs_[13] = _data_l_209[_data_k_209++];
  }
  if (__calls[8].calls == 0) {
    _data_k_210 = 0;
    if (_data_k_210 >= _data_n_210) {
      _data_k_210 = 0;
    }
    ai12cs_[14] = _data_l_210[_data_k_210++];
  }
  if (__calls[8].calls == 0) {
    _data_k_211 = 0;
    if (_data_k_211 >= _data_n_211) {
      _data_k_211 = 0;
    }
    ai12cs_[15] = _data_l_211[_data_k_211++];
  }
  if (__calls[8].calls == 0) {
    _data_k_212 = 0;
    if (_data_k_212 >= _data_n_212) {
      _data_k_212 = 0;
    }
    ai12cs_[16] = _data_l_212[_data_k_212++];
  }
  if (__calls[8].calls == 0) {
    _data_k_213 = 0;
    if (_data_k_213 >= _data_n_213) {
      _data_k_213 = 0;
    }
    ai12cs_[17] = _data_l_213[_data_k_213++];
  }
  if (__calls[8].calls == 0) {
    _data_k_214 = 0;
    if (_data_k_214 >= _data_n_214) {
      _data_k_214 = 0;
    }
    ai12cs_[18] = _data_l_214[_data_k_214++];
  }
  if (__calls[8].calls == 0) {
    _data_k_215 = 0;
    if (_data_k_215 >= _data_n_215) {
      _data_k_215 = 0;
    }
    ai12cs_[19] = _data_l_215[_data_k_215++];
  }
  if (__calls[8].calls == 0) {
    _data_k_216 = 0;
    if (_data_k_216 >= _data_n_216) {
      _data_k_216 = 0;
    }
    ai12cs_[20] = _data_l_216[_data_k_216++];
  }
  if (__calls[8].calls == 0) {
    _data_k_217 = 0;
    if (_data_k_217 >= _data_n_217) {
      _data_k_217 = 0;
    }
    ai12cs_[21] = _data_l_217[_data_k_217++];
  }
  if (__calls[8].calls == 0) {
    _data_k_218 = 0;
    if (_data_k_218 >= _data_n_218) {
      _data_k_218 = 0;
    }
    first_ = _data_l_218[_data_k_218++];
  }
  if (first_) {
    nti1_ = _inits (bi1cs_, ($0_ = 11, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    ntai1_ = _inits (ai1cs_, ($3_ = 21, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    ntai12_ = _inits (ai12cs_, ($6_ = 22, &$6_), ($8_ = 0.1 * _r1mach (($7_ = 3, &$7_)), &$8_));
    xmin_ = 2.0 * _r1mach (&_k1);
    xsml_ = sqrtf (4.5 * _r1mach (($9_ = 3, &$9_)));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 3.0) {
    goto _l20;
  }
  besi1e_ = 0.0;
  if (y_ == 0.0) {
    goto _l0;
  }
  if (y_ <= xmin_) {
    (void) _xermsg (_dc_0, _dc_13, _dc_14, &_k1, &_k1);
  }
  if (y_ > xmin_) {
    besi1e_ = 0.5 * (*x_);
  }
  if (y_ > xsml_) {
    besi1e_ = (*x_) * (.875 + _csevl (($10_ = y_ * y_ / 4.5 - 1.0, &$10_), bi1cs_, &nti1_));
  }
  besi1e_ = expf (-y_) * besi1e_;
  goto _l0;
  _l20:;
  if (y_ <= 8.0) {
    besi1e_ = (.375 + _csevl (($11_ = (48.0 / y_ - 11.0) / 5.0, &$11_), ai1cs_, &ntai1_)) / sqrtf (y_);
  }
  if (y_ > 8.0) {
    besi1e_ = (.375 + _csevl (($12_ = 16.0 / y_ - 1.0, &$12_), ai12cs_, &ntai12_)) / sqrtf (y_);
  }
  besi1e_ = _sign (besi1e_, (*x_));
  _l0:;
  __calls[8].calls++;
  return besi1e_;
}

real_4 _besi1 (real_4 _p_ x_)
{
  static int_4 nti1_;
  static logical_4 first_;
  static real_4 besi1_, bi1cs_[11], xmin_, xsml_, xmax_, y_;
  int_4 _data_k_219, _data_k_220, _data_k_221, _data_k_222, _data_k_223, _data_k_224, _data_k_225, _data_k_226, 
  _data_k_227, _data_k_228, _data_k_229, _data_k_230, $0_, $1_, $3_, $4_, $6_, $7_;
  real_4 $2_, $5_;
  extern real_4 _r1mach ();
#define _data_n_219 1
  static real_4 _data_l_219[_data_n_219] = {
    -.001971713261099859e0
  };
#define _data_n_220 1
  static real_4 _data_l_220[_data_n_220] = {
    .40734887667546481e0
  };
#define _data_n_221 1
  static real_4 _data_l_221[_data_n_221] = {
    .034838994299959456e0
  };
#define _data_n_222 1
  static real_4 _data_l_222[_data_n_222] = {
    .001545394556300123e0
  };
#define _data_n_223 1
  static real_4 _data_l_223[_data_n_223] = {
    .000041888521098377e0
  };
#define _data_n_224 1
  static real_4 _data_l_224[_data_n_224] = {
    .000000764902676483e0
  };
#define _data_n_225 1
  static real_4 _data_l_225[_data_n_225] = {
    .000000010042493924e0
  };
#define _data_n_226 1
  static real_4 _data_l_226[_data_n_226] = {
    .000000000099322077e0
  };
#define _data_n_227 1
  static real_4 _data_l_227[_data_n_227] = {
    .00000000000076638e0
  };
#define _data_n_228 1
  static real_4 _data_l_228[_data_n_228] = {
    .000000000000004741e0
  };
#define _data_n_229 1
  static real_4 _data_l_229[_data_n_229] = {
    .000000000000000024e0
  };
#define _data_n_230 1
  static logical_4 _data_l_230[_data_n_230] = {
    TRUE
  };
  if (__calls[9].calls == 0) {
    _data_k_219 = 0;
    if (_data_k_219 >= _data_n_219) {
      _data_k_219 = 0;
    }
    bi1cs_[0] = _data_l_219[_data_k_219++];
  }
  if (__calls[9].calls == 0) {
    _data_k_220 = 0;
    if (_data_k_220 >= _data_n_220) {
      _data_k_220 = 0;
    }
    bi1cs_[1] = _data_l_220[_data_k_220++];
  }
  if (__calls[9].calls == 0) {
    _data_k_221 = 0;
    if (_data_k_221 >= _data_n_221) {
      _data_k_221 = 0;
    }
    bi1cs_[2] = _data_l_221[_data_k_221++];
  }
  if (__calls[9].calls == 0) {
    _data_k_222 = 0;
    if (_data_k_222 >= _data_n_222) {
      _data_k_222 = 0;
    }
    bi1cs_[3] = _data_l_222[_data_k_222++];
  }
  if (__calls[9].calls == 0) {
    _data_k_223 = 0;
    if (_data_k_223 >= _data_n_223) {
      _data_k_223 = 0;
    }
    bi1cs_[4] = _data_l_223[_data_k_223++];
  }
  if (__calls[9].calls == 0) {
    _data_k_224 = 0;
    if (_data_k_224 >= _data_n_224) {
      _data_k_224 = 0;
    }
    bi1cs_[5] = _data_l_224[_data_k_224++];
  }
  if (__calls[9].calls == 0) {
    _data_k_225 = 0;
    if (_data_k_225 >= _data_n_225) {
      _data_k_225 = 0;
    }
    bi1cs_[6] = _data_l_225[_data_k_225++];
  }
  if (__calls[9].calls == 0) {
    _data_k_226 = 0;
    if (_data_k_226 >= _data_n_226) {
      _data_k_226 = 0;
    }
    bi1cs_[7] = _data_l_226[_data_k_226++];
  }
  if (__calls[9].calls == 0) {
    _data_k_227 = 0;
    if (_data_k_227 >= _data_n_227) {
      _data_k_227 = 0;
    }
    bi1cs_[8] = _data_l_227[_data_k_227++];
  }
  if (__calls[9].calls == 0) {
    _data_k_228 = 0;
    if (_data_k_228 >= _data_n_228) {
      _data_k_228 = 0;
    }
    bi1cs_[9] = _data_l_228[_data_k_228++];
  }
  if (__calls[9].calls == 0) {
    _data_k_229 = 0;
    if (_data_k_229 >= _data_n_229) {
      _data_k_229 = 0;
    }
    bi1cs_[10] = _data_l_229[_data_k_229++];
  }
  if (__calls[9].calls == 0) {
    _data_k_230 = 0;
    if (_data_k_230 >= _data_n_230) {
      _data_k_230 = 0;
    }
    first_ = _data_l_230[_data_k_230++];
  }
  if (first_) {
    nti1_ = _inits (bi1cs_, ($0_ = 11, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    xmin_ = 2.0 * _r1mach (&_k1);
    xsml_ = sqrtf (4.5 * _r1mach (($3_ = 3, &$3_)));
    xmax_ = logf (_r1mach (($4_ = 2, &$4_)));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 3.0) {
    goto _l20;
  }
  besi1_ = 0.0;
  if (y_ == 0.0) {
    goto _l0;
  }
  if (y_ <= xmin_) {
    (void) _xermsg (_dc_0, _dc_15, _dc_14, &_k1, &_k1);
  }
  if (y_ > xmin_) {
    besi1_ = 0.5 * (*x_);
  }
  if (y_ > xsml_) {
    besi1_ = (*x_) * (.875 + _csevl (($5_ = y_ * y_ / 4.5 - 1.0, &$5_), bi1cs_, &nti1_));
  }
  goto _l0;
  _l20:;
  if (y_ > xmax_) {
    (void) _xermsg (_dc_0, _dc_15, _dc_16, ($6_ = 2, &$6_), ($7_ = 2, &$7_));
  }
  besi1_ = expf (y_) * _besi1e (x_);
  _l0:;
  __calls[9].calls++;
  return besi1_;
}

int_4 _besi (real_4 _p_ x_, real_4 _p_ alpha_, int_4 _p_ kode_, int_4 _p_ n_, real_4 _p_ y_, int_4 _p_ nz_)
{
  static int_4 i_, ialp_, in_, inlim_, is_, i1_, k_, kk_, km_, kt_, nn_, ns_;
  static real_4 ain_, ak_, akm_, ans_, ap_, arg_, atol_, tolln_, dfn_, dtm_, dx_, earg_, elim_, etx_, flgik_, fn_, fnf_, 
  fni_, fnp1_, fnu_, gln_, ra_, rttpi_, s_, sx_, sxo2_, s1_, s2_, t_, ta_, tb_, temp_[3], tfn_, tm_, tol_, trx_, t2_, 
  xo2_, xo2l_, z_, alngam_;
  int_4 _data_k_231, _data_k_232, $0_, $1_, $2_, $3_, $4_, $7_, $8_, $9_, $10_, $11_, $12_, $13_;
  real_4 $5_, $6_;
  extern int_4 _i1mach ();
  extern real_4 _r1mach ();
#define _data_n_231 1
  static real_4 _data_l_231[_data_n_231] = {
    3.98942280401433e-1
  };
#define _data_n_232 1
  static int_4 _data_l_232[_data_n_232] = {
    80
  };
  if (__calls[10].calls == 0) {
    _data_k_231 = 0;
    if (_data_k_231 >= _data_n_231) {
      _data_k_231 = 0;
    }
    rttpi_ = _data_l_231[_data_k_231++];
  }
  if (__calls[10].calls == 0) {
    _data_k_232 = 0;
    if (_data_k_232 >= _data_n_232) {
      _data_k_232 = 0;
    }
    inlim_ = _data_l_232[_data_k_232++];
  }
  (*nz_) = 0;
  kt_ = 1;
  ra_ = _r1mach (($0_ = 3, &$0_));
  tol_ = _max (ra_, 1.0e-15);
  i1_ = -_i1mach (($1_ = 12, &$1_));
  gln_ = _r1mach (($2_ = 5, &$2_));
  elim_ = 2.303e0 * (i1_ * gln_ - 3.0e0);
  i1_ = _i1mach (($3_ = 11, &$3_)) + 1;
  tolln_ = 2.303e0 * gln_ * i1_;
  tolln_ = _min (tolln_, 34.5388);
  $4_ = (*n_) - 1;
  if ($4_ < 0) {
    goto _l590;
  } else if ($4_ == 0) {
    goto _l10;
  } else {
    goto _l20;
  }
  _l10:;
  kt_ = 2;
  _l20:;
  nn_ = (*n_);
  if ((*kode_) < 1 || (*kode_) > 2) {
    goto _l570;
  }
  $5_ = (*x_);
  if ($5_ < 0) {
    goto _l600;
  } else if ($5_ == 0) {
    goto _l30;
  } else {
    goto _l80;
  }
  _l30:;
  $6_ = (*alpha_);
  if ($6_ < 0) {
    goto _l580;
  } else if ($6_ == 0) {
    goto _l40;
  } else {
    goto _l50;
  }
  _l40:;
  y_[0] = 1.0;
  if ((*n_) == 1) {
    goto _l0;
  }
  i1_ = 2;
  goto _l60;
  _l50:;
  i1_ = 1;
  _l60:;
  for (i_ = i1_; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = 0.0;
  }
  goto _l0;
  _l80:;
  if ((*alpha_) < 0.0e0) {
    goto _l580;
  }
  ialp_ = (int_4) (_aintd ((*alpha_)));
  fni_ = ialp_ + (*n_) - 1;
  fnf_ = (*alpha_) - ialp_;
  dfn_ = fni_ + fnf_;
  fnu_ = dfn_;
  in_ = 0;
  xo2_ = (*x_) * 0.5e0;
  sxo2_ = xo2_ * xo2_;
  etx_ = (*kode_) - 1;
  sx_ = etx_ * (*x_);
  if (sxo2_ <= (fnu_ + 1.0e0)) {
    goto _l90;
  }
  if ((*x_) <= 12.0e0) {
    goto _l110;
  }
  fn_ = 0.55e0 * fnu_ * fnu_;
  fn_ = _max (17.0, fn_);
  if ((*x_) >= fn_) {
    goto _l430;
  }
  ans_ = _max (36.0e0 - fnu_, 0.0);
  ns_ = (int_4) (_aintd (ans_));
  fni_ = fni_ + ns_;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  is_ = kt_;
  km_ = (*n_) - 1 + ns_;
  if (km_ > 0) {
    is_ = 3;
  }
  goto _l120;
  _l90:;
  fn_ = fnu_;
  fnp1_ = fn_ + 1.0e0;
  xo2l_ = logf (xo2_);
  is_ = kt_;
  if ((*x_) <= 0.5e0) {
    goto _l230;
  }
  ns_ = 0;
  _l100:;
  fni_ = fni_ + ns_;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  fnp1_ = fn_ + 1.0e0;
  is_ = kt_;
  if ((*n_) - 1 + ns_ > 0) {
    is_ = 3;
  }
  goto _l230;
  _l110:;
  xo2l_ = logf (xo2_);
  ns_ = (int_4) (_aintd (sxo2_ - fnu_));
  goto _l100;
  _l120:;
  if ((*kode_) == 2) {
    goto _l130;
  }
  if ((*alpha_) < 1.0e0) {
    goto _l150;
  }
  z_ = (*x_) / (*alpha_);
  ra_ = sqrtf (1.0e0 + z_ * z_);
  gln_ = logf ((1.0e0 + ra_) / z_);
  t_ = ra_ * (1.0e0 - etx_) + etx_ / (z_ + ra_);
  arg_ = (*alpha_) * (t_ - gln_);
  if (arg_ > elim_) {
    goto _l610;
  }
  if (km_ == 0) {
    goto _l140;
  }
  _l130:;
  z_ = (*x_) / fn_;
  ra_ = sqrtf (1.0e0 + z_ * z_);
  gln_ = logf ((1.0e0 + ra_) / z_);
  t_ = ra_ * (1.0e0 - etx_) + etx_ / (z_ + ra_);
  arg_ = fn_ * (t_ - gln_);
  _l140:;
  if (arg_ < (-elim_)) {
    goto _l280;
  }
  goto _l190;
  _l150:;
  if ((*x_) > elim_) {
    goto _l610;
  }
  goto _l130;
  _l160:;
  if (km_ != 0) {
    goto _l170;
  }
  y_[0] = temp_[2];
  goto _l0;
  _l170:;
  temp_[0] = temp_[2];
  in_ = ns_;
  kt_ = 1;
  i1_ = 0;
  _l180:;
  is_ = 2;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  if (i1_ == 2) {
    goto _l350;
  }
  z_ = (*x_) / fn_;
  ra_ = sqrtf (1.0e0 + z_ * z_);
  gln_ = logf ((1.0e0 + ra_) / z_);
  t_ = ra_ * (1.0e0 - etx_) + etx_ / (z_ + ra_);
  arg_ = fn_ * (t_ - gln_);
  _l190:;
  i1_ = _abs (3 - is_);
  i1_ = _max (i1_, 1);
  flgik_ = 1.0;
  (void) _asyik (x_, &fn_, kode_, &flgik_, &ra_, &arg_, &i1_, &temp_[is_ - 1]);
  switch (is_) {
    default:
    case 1: goto _l180;
    case 2: goto _l350;
    case 3: goto _l510;
  }
  _l230:;
  gln_ = lgammaf (fnp1_);
  arg_ = fn_ * xo2l_ - gln_ - sx_;
  if (arg_ < (-elim_)) {
    goto _l300;
  }
  earg_ = expf (arg_);
  _l240:;
  s_ = 1.0;
  if ((*x_) < tol_) {
    goto _l260;
  }
  ak_ = 3.0;
  t2_ = 1.0;
  t_ = 1.0;
  s1_ = fn_;
  for (k_ = 1; k_ <= 17; (k_)++) {
    s2_ = t2_ + s1_;
    t_ = t_ * sxo2_ / s2_;
    s_ = s_ + t_;
    if (_abs (t_) < tol_) {
      goto _l260;
    }
    t2_ = t2_ + ak_;
    ak_ = ak_ + 2.0e0;
    s1_ = s1_ + fn_;
  }
  _l260:;
  temp_[is_ - 1] = s_ * earg_;
  switch (is_) {
    default:
    case 1: goto _l270;
    case 2: goto _l350;
    case 3: goto _l500;
  }
  _l270:;
  earg_ = earg_ * fn_ / xo2_;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  is_ = 2;
  goto _l240;
  _l280:;
  y_[nn_ - 1] = 0.0;
  nn_ = nn_ - 1;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  $7_ = nn_ - 1;
  if ($7_ < 0) {
    goto _l340;
  } else if ($7_ == 0) {
    goto _l290;
  } else {
    goto _l130;
  }
  _l290:;
  kt_ = 2;
  is_ = 2;
  goto _l130;
  _l300:;
  y_[nn_ - 1] = 0.0;
  nn_ = nn_ - 1;
  fnp1_ = fn_;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  $8_ = nn_ - 1;
  if ($8_ < 0) {
    goto _l340;
  } else if ($8_ == 0) {
    goto _l310;
  } else {
    goto _l320;
  }
  _l310:;
  kt_ = 2;
  is_ = 2;
  _l320:;
  if (sxo2_ <= fnp1_) {
    goto _l330;
  }
  goto _l130;
  _l330:;
  arg_ = arg_ - xo2l_ + logf (fnp1_);
  if (arg_ < (-elim_)) {
    goto _l300;
  }
  goto _l230;
  _l340:;
  (*nz_) = (*n_) - nn_;
  goto _l0;
  _l350:;
  (*nz_) = (*n_) - nn_;
  _l360:;
  if (kt_ == 2) {
    goto _l420;
  }
  s1_ = temp_[0];
  s2_ = temp_[1];
  trx_ = 2.0e0 / (*x_);
  dtm_ = fni_;
  tm_ = (dtm_ + fnf_) * trx_;
  if (in_ == 0) {
    goto _l390;
  }
  for (i_ = 1; i_ <= in_; (i_)++) {
    s_ = s2_;
    s2_ = tm_ * s2_ + s1_;
    s1_ = s_;
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
  }
  y_[nn_ - 1] = s1_;
  if (nn_ == 1) {
    goto _l0;
  }
  y_[nn_ - 1 - 1] = s2_;
  if (nn_ == 2) {
    goto _l0;
  }
  goto _l400;
  _l390:;
  y_[nn_ - 1] = s1_;
  y_[nn_ - 1 - 1] = s2_;
  if (nn_ == 2) {
    goto _l0;
  }
  _l400:;
  k_ = nn_ + 1;
  for (i_ = 3; i_ <= nn_; (i_)++) {
    k_ = k_ - 1;
    y_[k_ - 2 - 1] = tm_ * y_[k_ - 1 - 1] + y_[k_ - 1];
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
  }
  goto _l0;
  _l420:;
  y_[0] = temp_[1];
  goto _l0;
  _l430:;
  earg_ = rttpi_ / sqrtf ((*x_));
  if ((*kode_) == 2) {
    goto _l440;
  }
  if ((*x_) > elim_) {
    goto _l610;
  }
  earg_ = earg_ * expf ((*x_));
  _l440:;
  etx_ = 8.0e0 * (*x_);
  is_ = kt_;
  in_ = 0;
  fn_ = fnu_;
  _l450:;
  dx_ = fni_ + fni_;
  tm_ = 0.0;
  if (fni_ == 0.0e0 && _abs (fnf_) < tol_) {
    goto _l460;
  }
  tm_ = 4.0e0 * fnf_ * (fni_ + fni_ + fnf_);
  _l460:;
  dtm_ = dx_ * dx_;
  s1_ = etx_;
  trx_ = dtm_ - 1.0e0;
  dx_ = -(trx_ + tm_) / etx_;
  t_ = dx_;
  s_ = 1.0e0 + dx_;
  atol_ = tol_ * _abs (s_);
  s2_ = 1.0;
  ak_ = 8.0;
  for (k_ = 1; k_ <= 25; (k_)++) {
    s1_ = s1_ + etx_;
    s2_ = s2_ + ak_;
    dx_ = dtm_ - s2_;
    ap_ = dx_ + tm_;
    t_ = -t_ * ap_ / s1_;
    s_ = s_ + t_;
    if (_abs (t_) <= atol_) {
      goto _l480;
    }
    ak_ = ak_ + 8.0e0;
  }
  _l480:;
  temp_[is_ - 1] = s_ * earg_;
  if (is_ == 2) {
    goto _l360;
  }
  is_ = 2;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  goto _l450;
  _l500:;
  akm_ = _max (3.0e0 - fn_, 0.0);
  km_ = (int_4) (_aintd (akm_));
  tfn_ = fn_ + km_;
  ta_ = (gln_ + tfn_ - 0.9189385332e0 - 0.0833333333e0 / tfn_) / (tfn_ + 0.5e0);
  ta_ = xo2l_ - ta_;
  tb_ = -(1.0e0 - 1.0e0 / tfn_) / tfn_;
  ain_ = tolln_ / (-ta_ + sqrtf (ta_ * ta_ - tolln_ * tb_)) + 1.5e0;
  in_ = (int_4) (_aintd (ain_));
  in_ = in_ + km_;
  goto _l520;
  _l510:;
  t_ = 1.0e0 / (fn_ * ra_);
  ain_ = tolln_ / (gln_ + sqrtf (gln_ * gln_ + t_ * tolln_)) + 1.5e0;
  in_ = (int_4) (_aintd (ain_));
  if (in_ > inlim_) {
    goto _l160;
  }
  _l520:;
  trx_ = 2.0e0 / (*x_);
  dtm_ = fni_ + in_;
  tm_ = (dtm_ + fnf_) * trx_;
  ta_ = 0.0;
  tb_ = tol_;
  kk_ = 1;
  _l530:;
  for (i_ = 1; i_ <= in_; (i_)++) {
    s_ = tb_;
    tb_ = tm_ * tb_ + ta_;
    ta_ = s_;
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
  }
  if (kk_ != 1) {
    goto _l550;
  }
  ta_ = (ta_ / tb_) * temp_[2];
  tb_ = temp_[2];
  kk_ = 2;
  in_ = ns_;
  if (ns_ != 0) {
    goto _l530;
  }
  _l550:;
  y_[nn_ - 1] = tb_;
  (*nz_) = (*n_) - nn_;
  if (nn_ == 1) {
    goto _l0;
  }
  tb_ = tm_ * tb_ + ta_;
  k_ = nn_ - 1;
  y_[k_ - 1] = tb_;
  if (nn_ == 2) {
    goto _l0;
  }
  dtm_ = dtm_ - 1.0e0;
  tm_ = (dtm_ + fnf_) * trx_;
  km_ = k_ - 1;
  for (i_ = 1; i_ <= km_; (i_)++) {
    y_[k_ - 1 - 1] = tm_ * y_[k_ - 1] + y_[k_ + 1 - 1];
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
    k_ = k_ - 1;
  }
  goto _l0;
  _l570:;
  (void) _xermsg (_dc_0, _dc_17, _dc_18, ($9_ = 2, &$9_), &_k1);
  goto _l0;
  _l580:;
  (void) _xermsg (_dc_0, _dc_17, _dc_19, ($10_ = 2, &$10_), &_k1);
  goto _l0;
  _l590:;
  (void) _xermsg (_dc_0, _dc_17, _dc_20, ($11_ = 2, &$11_), &_k1);
  goto _l0;
  _l600:;
  (void) _xermsg (_dc_0, _dc_17, _dc_21, ($12_ = 2, &$12_), &_k1);
  goto _l0;
  _l610:;
  (void) _xermsg (_dc_0, _dc_17, _dc_22, ($13_ = 6, &$13_), &_k1);
  _l0:;
  __calls[10].calls++;
  return 0;
}

real_4 _besj0 (real_4 _p_ x_)
{
  static int_4 ntj0_, ntm0_, ntth0_;
  static logical_4 first_;
  static real_4 besj0_, bj0cs_[13], bm0cs_[21], bth0cs_[24], pi4_, xsml_, xmax_, y_, z_, ampl_, theta_;
  int_4 _data_k_233, _data_k_234, _data_k_235, _data_k_236, _data_k_237, _data_k_238, _data_k_239, _data_k_240, 
  _data_k_241, _data_k_242, _data_k_243, _data_k_244, _data_k_245, _data_k_246, _data_k_247, _data_k_248, _data_k_249, 
  _data_k_250, _data_k_251, _data_k_252, _data_k_253, _data_k_254, _data_k_255, _data_k_256, _data_k_257, _data_k_258, 
  _data_k_259, _data_k_260, _data_k_261, _data_k_262, _data_k_263, _data_k_264, _data_k_265, _data_k_266, _data_k_267, 
  _data_k_268, _data_k_269, _data_k_270, _data_k_271, _data_k_272, _data_k_273, _data_k_274, _data_k_275, _data_k_276, 
  _data_k_277, _data_k_278, _data_k_279, _data_k_280, _data_k_281, _data_k_282, _data_k_283, _data_k_284, _data_k_285, 
  _data_k_286, _data_k_287, _data_k_288, _data_k_289, _data_k_290, _data_k_291, _data_k_292, $0_, $1_, $3_, $4_, $6_, $7_
  , $9_, $10_, $12_;
  real_4 $2_, $5_, $8_, $11_;
  extern real_4 _r1mach ();
#define _data_n_233 1
  static real_4 _data_l_233[_data_n_233] = {
    .100254161968939137e0
  };
#define _data_n_234 1
  static real_4 _data_l_234[_data_n_234] = {
    -.665223007764405132e0
  };
#define _data_n_235 1
  static real_4 _data_l_235[_data_n_235] = {
    .248983703498281314e0
  };
#define _data_n_236 1
  static real_4 _data_l_236[_data_n_236] = {
    -.0332527231700357697e0
  };
#define _data_n_237 1
  static real_4 _data_l_237[_data_n_237] = {
    .0023114179304694015e0
  };
#define _data_n_238 1
  static real_4 _data_l_238[_data_n_238] = {
    -.000099112774199508e0
  };
#define _data_n_239 1
  static real_4 _data_l_239[_data_n_239] = {
    .0000028916708643998e0
  };
#define _data_n_240 1
  static real_4 _data_l_240[_data_n_240] = {
    -.000000061210858663e0
  };
#define _data_n_241 1
  static real_4 _data_l_241[_data_n_241] = {
    .0000000009838650793e0
  };
#define _data_n_242 1
  static real_4 _data_l_242[_data_n_242] = {
    -.0000000000124235515e0
  };
#define _data_n_243 1
  static real_4 _data_l_243[_data_n_243] = {
    .0000000000001265433e0
  };
#define _data_n_244 1
  static real_4 _data_l_244[_data_n_244] = {
    -.0000000000000010619e0
  };
#define _data_n_245 1
  static real_4 _data_l_245[_data_n_245] = {
    .0000000000000000074e0
  };
#define _data_n_246 1
  static real_4 _data_l_246[_data_n_246] = {
    .09284961637381644e0
  };
#define _data_n_247 1
  static real_4 _data_l_247[_data_n_247] = {
    -.00142987707403484e0
  };
#define _data_n_248 1
  static real_4 _data_l_248[_data_n_248] = {
    .00002830579271257e0
  };
#define _data_n_249 1
  static real_4 _data_l_249[_data_n_249] = {
    -.00000143300611424e0
  };
#define _data_n_250 1
  static real_4 _data_l_250[_data_n_250] = {
    .00000012028628046e0
  };
#define _data_n_251 1
  static real_4 _data_l_251[_data_n_251] = {
    -.00000001397113013e0
  };
#define _data_n_252 1
  static real_4 _data_l_252[_data_n_252] = {
    .00000000204076188e0
  };
#define _data_n_253 1
  static real_4 _data_l_253[_data_n_253] = {
    -.00000000035399669e0
  };
#define _data_n_254 1
  static real_4 _data_l_254[_data_n_254] = {
    .00000000007024759e0
  };
#define _data_n_255 1
  static real_4 _data_l_255[_data_n_255] = {
    -.00000000001554107e0
  };
#define _data_n_256 1
  static real_4 _data_l_256[_data_n_256] = {
    .00000000000376226e0
  };
#define _data_n_257 1
  static real_4 _data_l_257[_data_n_257] = {
    -.00000000000098282e0
  };
#define _data_n_258 1
  static real_4 _data_l_258[_data_n_258] = {
    .00000000000027408e0
  };
#define _data_n_259 1
  static real_4 _data_l_259[_data_n_259] = {
    -.00000000000008091e0
  };
#define _data_n_260 1
  static real_4 _data_l_260[_data_n_260] = {
    .00000000000002511e0
  };
#define _data_n_261 1
  static real_4 _data_l_261[_data_n_261] = {
    -.00000000000000814e0
  };
#define _data_n_262 1
  static real_4 _data_l_262[_data_n_262] = {
    .00000000000000275e0
  };
#define _data_n_263 1
  static real_4 _data_l_263[_data_n_263] = {
    -.00000000000000096e0
  };
#define _data_n_264 1
  static real_4 _data_l_264[_data_n_264] = {
    .00000000000000034e0
  };
#define _data_n_265 1
  static real_4 _data_l_265[_data_n_265] = {
    -.00000000000000012e0
  };
#define _data_n_266 1
  static real_4 _data_l_266[_data_n_266] = {
    .00000000000000004e0
  };
#define _data_n_267 1
  static real_4 _data_l_267[_data_n_267] = {
    -.24639163774300119e0
  };
#define _data_n_268 1
  static real_4 _data_l_268[_data_n_268] = {
    .001737098307508963e0
  };
#define _data_n_269 1
  static real_4 _data_l_269[_data_n_269] = {
    -.000062183633402968e0
  };
#define _data_n_270 1
  static real_4 _data_l_270[_data_n_270] = {
    .000004368050165742e0
  };
#define _data_n_271 1
  static real_4 _data_l_271[_data_n_271] = {
    -.000000456093019869e0
  };
#define _data_n_272 1
  static real_4 _data_l_272[_data_n_272] = {
    .000000062197400101e0
  };
#define _data_n_273 1
  static real_4 _data_l_273[_data_n_273] = {
    -.000000010300442889e0
  };
#define _data_n_274 1
  static real_4 _data_l_274[_data_n_274] = {
    .000000001979526776e0
  };
#define _data_n_275 1
  static real_4 _data_l_275[_data_n_275] = {
    -.000000000428198396e0
  };
#define _data_n_276 1
  static real_4 _data_l_276[_data_n_276] = {
    .00000000010203584e0
  };
#define _data_n_277 1
  static real_4 _data_l_277[_data_n_277] = {
    -.000000000026363898e0
  };
#define _data_n_278 1
  static real_4 _data_l_278[_data_n_278] = {
    .000000000007297935e0
  };
#define _data_n_279 1
  static real_4 _data_l_279[_data_n_279] = {
    -.000000000002144188e0
  };
#define _data_n_280 1
  static real_4 _data_l_280[_data_n_280] = {
    .000000000000663693e0
  };
#define _data_n_281 1
  static real_4 _data_l_281[_data_n_281] = {
    -.000000000000215126e0
  };
#define _data_n_282 1
  static real_4 _data_l_282[_data_n_282] = {
    .000000000000072659e0
  };
#define _data_n_283 1
  static real_4 _data_l_283[_data_n_283] = {
    -.000000000000025465e0
  };
#define _data_n_284 1
  static real_4 _data_l_284[_data_n_284] = {
    .000000000000009229e0
  };
#define _data_n_285 1
  static real_4 _data_l_285[_data_n_285] = {
    -.000000000000003448e0
  };
#define _data_n_286 1
  static real_4 _data_l_286[_data_n_286] = {
    .000000000000001325e0
  };
#define _data_n_287 1
  static real_4 _data_l_287[_data_n_287] = {
    -.000000000000000522e0
  };
#define _data_n_288 1
  static real_4 _data_l_288[_data_n_288] = {
    .00000000000000021e0
  };
#define _data_n_289 1
  static real_4 _data_l_289[_data_n_289] = {
    -.000000000000000087e0
  };
#define _data_n_290 1
  static real_4 _data_l_290[_data_n_290] = {
    .000000000000000036e0
  };
#define _data_n_291 1
  static real_4 _data_l_291[_data_n_291] = {
    0.78539816339744831e0
  };
#define _data_n_292 1
  static logical_4 _data_l_292[_data_n_292] = {
    TRUE
  };
  if (__calls[11].calls == 0) {
    _data_k_233 = 0;
    if (_data_k_233 >= _data_n_233) {
      _data_k_233 = 0;
    }
    bj0cs_[0] = _data_l_233[_data_k_233++];
  }
  if (__calls[11].calls == 0) {
    _data_k_234 = 0;
    if (_data_k_234 >= _data_n_234) {
      _data_k_234 = 0;
    }
    bj0cs_[1] = _data_l_234[_data_k_234++];
  }
  if (__calls[11].calls == 0) {
    _data_k_235 = 0;
    if (_data_k_235 >= _data_n_235) {
      _data_k_235 = 0;
    }
    bj0cs_[2] = _data_l_235[_data_k_235++];
  }
  if (__calls[11].calls == 0) {
    _data_k_236 = 0;
    if (_data_k_236 >= _data_n_236) {
      _data_k_236 = 0;
    }
    bj0cs_[3] = _data_l_236[_data_k_236++];
  }
  if (__calls[11].calls == 0) {
    _data_k_237 = 0;
    if (_data_k_237 >= _data_n_237) {
      _data_k_237 = 0;
    }
    bj0cs_[4] = _data_l_237[_data_k_237++];
  }
  if (__calls[11].calls == 0) {
    _data_k_238 = 0;
    if (_data_k_238 >= _data_n_238) {
      _data_k_238 = 0;
    }
    bj0cs_[5] = _data_l_238[_data_k_238++];
  }
  if (__calls[11].calls == 0) {
    _data_k_239 = 0;
    if (_data_k_239 >= _data_n_239) {
      _data_k_239 = 0;
    }
    bj0cs_[6] = _data_l_239[_data_k_239++];
  }
  if (__calls[11].calls == 0) {
    _data_k_240 = 0;
    if (_data_k_240 >= _data_n_240) {
      _data_k_240 = 0;
    }
    bj0cs_[7] = _data_l_240[_data_k_240++];
  }
  if (__calls[11].calls == 0) {
    _data_k_241 = 0;
    if (_data_k_241 >= _data_n_241) {
      _data_k_241 = 0;
    }
    bj0cs_[8] = _data_l_241[_data_k_241++];
  }
  if (__calls[11].calls == 0) {
    _data_k_242 = 0;
    if (_data_k_242 >= _data_n_242) {
      _data_k_242 = 0;
    }
    bj0cs_[9] = _data_l_242[_data_k_242++];
  }
  if (__calls[11].calls == 0) {
    _data_k_243 = 0;
    if (_data_k_243 >= _data_n_243) {
      _data_k_243 = 0;
    }
    bj0cs_[10] = _data_l_243[_data_k_243++];
  }
  if (__calls[11].calls == 0) {
    _data_k_244 = 0;
    if (_data_k_244 >= _data_n_244) {
      _data_k_244 = 0;
    }
    bj0cs_[11] = _data_l_244[_data_k_244++];
  }
  if (__calls[11].calls == 0) {
    _data_k_245 = 0;
    if (_data_k_245 >= _data_n_245) {
      _data_k_245 = 0;
    }
    bj0cs_[12] = _data_l_245[_data_k_245++];
  }
  if (__calls[11].calls == 0) {
    _data_k_246 = 0;
    if (_data_k_246 >= _data_n_246) {
      _data_k_246 = 0;
    }
    bm0cs_[0] = _data_l_246[_data_k_246++];
  }
  if (__calls[11].calls == 0) {
    _data_k_247 = 0;
    if (_data_k_247 >= _data_n_247) {
      _data_k_247 = 0;
    }
    bm0cs_[1] = _data_l_247[_data_k_247++];
  }
  if (__calls[11].calls == 0) {
    _data_k_248 = 0;
    if (_data_k_248 >= _data_n_248) {
      _data_k_248 = 0;
    }
    bm0cs_[2] = _data_l_248[_data_k_248++];
  }
  if (__calls[11].calls == 0) {
    _data_k_249 = 0;
    if (_data_k_249 >= _data_n_249) {
      _data_k_249 = 0;
    }
    bm0cs_[3] = _data_l_249[_data_k_249++];
  }
  if (__calls[11].calls == 0) {
    _data_k_250 = 0;
    if (_data_k_250 >= _data_n_250) {
      _data_k_250 = 0;
    }
    bm0cs_[4] = _data_l_250[_data_k_250++];
  }
  if (__calls[11].calls == 0) {
    _data_k_251 = 0;
    if (_data_k_251 >= _data_n_251) {
      _data_k_251 = 0;
    }
    bm0cs_[5] = _data_l_251[_data_k_251++];
  }
  if (__calls[11].calls == 0) {
    _data_k_252 = 0;
    if (_data_k_252 >= _data_n_252) {
      _data_k_252 = 0;
    }
    bm0cs_[6] = _data_l_252[_data_k_252++];
  }
  if (__calls[11].calls == 0) {
    _data_k_253 = 0;
    if (_data_k_253 >= _data_n_253) {
      _data_k_253 = 0;
    }
    bm0cs_[7] = _data_l_253[_data_k_253++];
  }
  if (__calls[11].calls == 0) {
    _data_k_254 = 0;
    if (_data_k_254 >= _data_n_254) {
      _data_k_254 = 0;
    }
    bm0cs_[8] = _data_l_254[_data_k_254++];
  }
  if (__calls[11].calls == 0) {
    _data_k_255 = 0;
    if (_data_k_255 >= _data_n_255) {
      _data_k_255 = 0;
    }
    bm0cs_[9] = _data_l_255[_data_k_255++];
  }
  if (__calls[11].calls == 0) {
    _data_k_256 = 0;
    if (_data_k_256 >= _data_n_256) {
      _data_k_256 = 0;
    }
    bm0cs_[10] = _data_l_256[_data_k_256++];
  }
  if (__calls[11].calls == 0) {
    _data_k_257 = 0;
    if (_data_k_257 >= _data_n_257) {
      _data_k_257 = 0;
    }
    bm0cs_[11] = _data_l_257[_data_k_257++];
  }
  if (__calls[11].calls == 0) {
    _data_k_258 = 0;
    if (_data_k_258 >= _data_n_258) {
      _data_k_258 = 0;
    }
    bm0cs_[12] = _data_l_258[_data_k_258++];
  }
  if (__calls[11].calls == 0) {
    _data_k_259 = 0;
    if (_data_k_259 >= _data_n_259) {
      _data_k_259 = 0;
    }
    bm0cs_[13] = _data_l_259[_data_k_259++];
  }
  if (__calls[11].calls == 0) {
    _data_k_260 = 0;
    if (_data_k_260 >= _data_n_260) {
      _data_k_260 = 0;
    }
    bm0cs_[14] = _data_l_260[_data_k_260++];
  }
  if (__calls[11].calls == 0) {
    _data_k_261 = 0;
    if (_data_k_261 >= _data_n_261) {
      _data_k_261 = 0;
    }
    bm0cs_[15] = _data_l_261[_data_k_261++];
  }
  if (__calls[11].calls == 0) {
    _data_k_262 = 0;
    if (_data_k_262 >= _data_n_262) {
      _data_k_262 = 0;
    }
    bm0cs_[16] = _data_l_262[_data_k_262++];
  }
  if (__calls[11].calls == 0) {
    _data_k_263 = 0;
    if (_data_k_263 >= _data_n_263) {
      _data_k_263 = 0;
    }
    bm0cs_[17] = _data_l_263[_data_k_263++];
  }
  if (__calls[11].calls == 0) {
    _data_k_264 = 0;
    if (_data_k_264 >= _data_n_264) {
      _data_k_264 = 0;
    }
    bm0cs_[18] = _data_l_264[_data_k_264++];
  }
  if (__calls[11].calls == 0) {
    _data_k_265 = 0;
    if (_data_k_265 >= _data_n_265) {
      _data_k_265 = 0;
    }
    bm0cs_[19] = _data_l_265[_data_k_265++];
  }
  if (__calls[11].calls == 0) {
    _data_k_266 = 0;
    if (_data_k_266 >= _data_n_266) {
      _data_k_266 = 0;
    }
    bm0cs_[20] = _data_l_266[_data_k_266++];
  }
  if (__calls[11].calls == 0) {
    _data_k_267 = 0;
    if (_data_k_267 >= _data_n_267) {
      _data_k_267 = 0;
    }
    bth0cs_[0] = _data_l_267[_data_k_267++];
  }
  if (__calls[11].calls == 0) {
    _data_k_268 = 0;
    if (_data_k_268 >= _data_n_268) {
      _data_k_268 = 0;
    }
    bth0cs_[1] = _data_l_268[_data_k_268++];
  }
  if (__calls[11].calls == 0) {
    _data_k_269 = 0;
    if (_data_k_269 >= _data_n_269) {
      _data_k_269 = 0;
    }
    bth0cs_[2] = _data_l_269[_data_k_269++];
  }
  if (__calls[11].calls == 0) {
    _data_k_270 = 0;
    if (_data_k_270 >= _data_n_270) {
      _data_k_270 = 0;
    }
    bth0cs_[3] = _data_l_270[_data_k_270++];
  }
  if (__calls[11].calls == 0) {
    _data_k_271 = 0;
    if (_data_k_271 >= _data_n_271) {
      _data_k_271 = 0;
    }
    bth0cs_[4] = _data_l_271[_data_k_271++];
  }
  if (__calls[11].calls == 0) {
    _data_k_272 = 0;
    if (_data_k_272 >= _data_n_272) {
      _data_k_272 = 0;
    }
    bth0cs_[5] = _data_l_272[_data_k_272++];
  }
  if (__calls[11].calls == 0) {
    _data_k_273 = 0;
    if (_data_k_273 >= _data_n_273) {
      _data_k_273 = 0;
    }
    bth0cs_[6] = _data_l_273[_data_k_273++];
  }
  if (__calls[11].calls == 0) {
    _data_k_274 = 0;
    if (_data_k_274 >= _data_n_274) {
      _data_k_274 = 0;
    }
    bth0cs_[7] = _data_l_274[_data_k_274++];
  }
  if (__calls[11].calls == 0) {
    _data_k_275 = 0;
    if (_data_k_275 >= _data_n_275) {
      _data_k_275 = 0;
    }
    bth0cs_[8] = _data_l_275[_data_k_275++];
  }
  if (__calls[11].calls == 0) {
    _data_k_276 = 0;
    if (_data_k_276 >= _data_n_276) {
      _data_k_276 = 0;
    }
    bth0cs_[9] = _data_l_276[_data_k_276++];
  }
  if (__calls[11].calls == 0) {
    _data_k_277 = 0;
    if (_data_k_277 >= _data_n_277) {
      _data_k_277 = 0;
    }
    bth0cs_[10] = _data_l_277[_data_k_277++];
  }
  if (__calls[11].calls == 0) {
    _data_k_278 = 0;
    if (_data_k_278 >= _data_n_278) {
      _data_k_278 = 0;
    }
    bth0cs_[11] = _data_l_278[_data_k_278++];
  }
  if (__calls[11].calls == 0) {
    _data_k_279 = 0;
    if (_data_k_279 >= _data_n_279) {
      _data_k_279 = 0;
    }
    bth0cs_[12] = _data_l_279[_data_k_279++];
  }
  if (__calls[11].calls == 0) {
    _data_k_280 = 0;
    if (_data_k_280 >= _data_n_280) {
      _data_k_280 = 0;
    }
    bth0cs_[13] = _data_l_280[_data_k_280++];
  }
  if (__calls[11].calls == 0) {
    _data_k_281 = 0;
    if (_data_k_281 >= _data_n_281) {
      _data_k_281 = 0;
    }
    bth0cs_[14] = _data_l_281[_data_k_281++];
  }
  if (__calls[11].calls == 0) {
    _data_k_282 = 0;
    if (_data_k_282 >= _data_n_282) {
      _data_k_282 = 0;
    }
    bth0cs_[15] = _data_l_282[_data_k_282++];
  }
  if (__calls[11].calls == 0) {
    _data_k_283 = 0;
    if (_data_k_283 >= _data_n_283) {
      _data_k_283 = 0;
    }
    bth0cs_[16] = _data_l_283[_data_k_283++];
  }
  if (__calls[11].calls == 0) {
    _data_k_284 = 0;
    if (_data_k_284 >= _data_n_284) {
      _data_k_284 = 0;
    }
    bth0cs_[17] = _data_l_284[_data_k_284++];
  }
  if (__calls[11].calls == 0) {
    _data_k_285 = 0;
    if (_data_k_285 >= _data_n_285) {
      _data_k_285 = 0;
    }
    bth0cs_[18] = _data_l_285[_data_k_285++];
  }
  if (__calls[11].calls == 0) {
    _data_k_286 = 0;
    if (_data_k_286 >= _data_n_286) {
      _data_k_286 = 0;
    }
    bth0cs_[19] = _data_l_286[_data_k_286++];
  }
  if (__calls[11].calls == 0) {
    _data_k_287 = 0;
    if (_data_k_287 >= _data_n_287) {
      _data_k_287 = 0;
    }
    bth0cs_[20] = _data_l_287[_data_k_287++];
  }
  if (__calls[11].calls == 0) {
    _data_k_288 = 0;
    if (_data_k_288 >= _data_n_288) {
      _data_k_288 = 0;
    }
    bth0cs_[21] = _data_l_288[_data_k_288++];
  }
  if (__calls[11].calls == 0) {
    _data_k_289 = 0;
    if (_data_k_289 >= _data_n_289) {
      _data_k_289 = 0;
    }
    bth0cs_[22] = _data_l_289[_data_k_289++];
  }
  if (__calls[11].calls == 0) {
    _data_k_290 = 0;
    if (_data_k_290 >= _data_n_290) {
      _data_k_290 = 0;
    }
    bth0cs_[23] = _data_l_290[_data_k_290++];
  }
  if (__calls[11].calls == 0) {
    _data_k_291 = 0;
    if (_data_k_291 >= _data_n_291) {
      _data_k_291 = 0;
    }
    pi4_ = _data_l_291[_data_k_291++];
  }
  if (__calls[11].calls == 0) {
    _data_k_292 = 0;
    if (_data_k_292 >= _data_n_292) {
      _data_k_292 = 0;
    }
    first_ = _data_l_292[_data_k_292++];
  }
  if (first_) {
    ntj0_ = _inits (bj0cs_, ($0_ = 13, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    ntm0_ = _inits (bm0cs_, ($3_ = 21, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    ntth0_ = _inits (bth0cs_, ($6_ = 24, &$6_), ($8_ = 0.1 * _r1mach (($7_ = 3, &$7_)), &$8_));
    xsml_ = sqrtf (8.0 * _r1mach (($9_ = 3, &$9_)));
    xmax_ = 1.0 / _r1mach (($10_ = 4, &$10_));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 4.0) {
    goto _l20;
  }
  besj0_ = 1.0;
  if (y_ > xsml_) {
    besj0_ = _csevl (($11_ = .125 * y_ * y_ - 1.0, &$11_), bj0cs_, &ntj0_);
  }
  goto _l0;
  _l20:;
  if (y_ > xmax_) {
    (void) _xermsg (_dc_0, _dc_23, _dc_24, &_k1, ($12_ = 2, &$12_));
  }
  z_ = 32.0 / (y_ * y_) - 1.0;
  ampl_ = (0.75 + _csevl (&z_, bm0cs_, &ntm0_)) / sqrtf (y_);
  theta_ = y_ - pi4_ + _csevl (&z_, bth0cs_, &ntth0_) / y_;
  besj0_ = ampl_ * cosf (theta_);
  _l0:;
  __calls[11].calls++;
  return besj0_;
}

real_4 _besj1 (real_4 _p_ x_)
{
  static int_4 ntj1_, ntm1_, ntth1_;
  static logical_4 first_;
  static real_4 besj1_, bj1cs_[12], bm1cs_[21], bth1cs_[24], pi4_, xsml_, xmin_, xmax_, y_, z_, ampl_, theta_;
  int_4 _data_k_293, _data_k_294, _data_k_295, _data_k_296, _data_k_297, _data_k_298, _data_k_299, _data_k_300, 
  _data_k_301, _data_k_302, _data_k_303, _data_k_304, _data_k_305, _data_k_306, _data_k_307, _data_k_308, _data_k_309, 
  _data_k_310, _data_k_311, _data_k_312, _data_k_313, _data_k_314, _data_k_315, _data_k_316, _data_k_317, _data_k_318, 
  _data_k_319, _data_k_320, _data_k_321, _data_k_322, _data_k_323, _data_k_324, _data_k_325, _data_k_326, _data_k_327, 
  _data_k_328, _data_k_329, _data_k_330, _data_k_331, _data_k_332, _data_k_333, _data_k_334, _data_k_335, _data_k_336, 
  _data_k_337, _data_k_338, _data_k_339, _data_k_340, _data_k_341, _data_k_342, _data_k_343, _data_k_344, _data_k_345, 
  _data_k_346, _data_k_347, _data_k_348, _data_k_349, _data_k_350, _data_k_351, $0_, $1_, $3_, $4_, $6_, $7_, $9_, $10_, 
  $12_, $13_;
  real_4 $2_, $5_, $8_, $11_;
  extern real_4 _r1mach ();
#define _data_n_293 1
  static real_4 _data_l_293[_data_n_293] = {
    -.11726141513332787e0
  };
#define _data_n_294 1
  static real_4 _data_l_294[_data_n_294] = {
    -.2536152183079064e0
  };
#define _data_n_295 1
  static real_4 _data_l_295[_data_n_295] = {
    .050127080984469569e0
  };
#define _data_n_296 1
  static real_4 _data_l_296[_data_n_296] = {
    -.004631514809625081e0
  };
#define _data_n_297 1
  static real_4 _data_l_297[_data_n_297] = {
    .000247996229415914e0
  };
#define _data_n_298 1
  static real_4 _data_l_298[_data_n_298] = {
    -.000008678948686278e0
  };
#define _data_n_299 1
  static real_4 _data_l_299[_data_n_299] = {
    .000000214293917143e0
  };
#define _data_n_300 1
  static real_4 _data_l_300[_data_n_300] = {
    -.000000003936093079e0
  };
#define _data_n_301 1
  static real_4 _data_l_301[_data_n_301] = {
    .000000000055911823e0
  };
#define _data_n_302 1
  static real_4 _data_l_302[_data_n_302] = {
    -.000000000000632761e0
  };
#define _data_n_303 1
  static real_4 _data_l_303[_data_n_303] = {
    .00000000000000584e0
  };
#define _data_n_304 1
  static real_4 _data_l_304[_data_n_304] = {
    -.000000000000000044e0
  };
#define _data_n_305 1
  static real_4 _data_l_305[_data_n_305] = {
    .1047362510931285e0
  };
#define _data_n_306 1
  static real_4 _data_l_306[_data_n_306] = {
    .00442443893702345e0
  };
#define _data_n_307 1
  static real_4 _data_l_307[_data_n_307] = {
    -.00005661639504035e0
  };
#define _data_n_308 1
  static real_4 _data_l_308[_data_n_308] = {
    .00000231349417339e0
  };
#define _data_n_309 1
  static real_4 _data_l_309[_data_n_309] = {
    -.00000017377182007e0
  };
#define _data_n_310 1
  static real_4 _data_l_310[_data_n_310] = {
    .0000000189320993e0
  };
#define _data_n_311 1
  static real_4 _data_l_311[_data_n_311] = {
    -.00000000265416023e0
  };
#define _data_n_312 1
  static real_4 _data_l_312[_data_n_312] = {
    .00000000044740209e0
  };
#define _data_n_313 1
  static real_4 _data_l_313[_data_n_313] = {
    -.00000000008691795e0
  };
#define _data_n_314 1
  static real_4 _data_l_314[_data_n_314] = {
    .00000000001891492e0
  };
#define _data_n_315 1
  static real_4 _data_l_315[_data_n_315] = {
    -.00000000000451884e0
  };
#define _data_n_316 1
  static real_4 _data_l_316[_data_n_316] = {
    .00000000000116765e0
  };
#define _data_n_317 1
  static real_4 _data_l_317[_data_n_317] = {
    -.00000000000032265e0
  };
#define _data_n_318 1
  static real_4 _data_l_318[_data_n_318] = {
    .0000000000000945e0
  };
#define _data_n_319 1
  static real_4 _data_l_319[_data_n_319] = {
    -.00000000000002913e0
  };
#define _data_n_320 1
  static real_4 _data_l_320[_data_n_320] = {
    .00000000000000939e0
  };
#define _data_n_321 1
  static real_4 _data_l_321[_data_n_321] = {
    -.00000000000000315e0
  };
#define _data_n_322 1
  static real_4 _data_l_322[_data_n_322] = {
    .00000000000000109e0
  };
#define _data_n_323 1
  static real_4 _data_l_323[_data_n_323] = {
    -.00000000000000039e0
  };
#define _data_n_324 1
  static real_4 _data_l_324[_data_n_324] = {
    .00000000000000014e0
  };
#define _data_n_325 1
  static real_4 _data_l_325[_data_n_325] = {
    -.00000000000000005e0
  };
#define _data_n_326 1
  static real_4 _data_l_326[_data_n_326] = {
    .7406014102631385e0
  };
#define _data_n_327 1
  static real_4 _data_l_327[_data_n_327] = {
    -.00457175565963769e0
  };
#define _data_n_328 1
  static real_4 _data_l_328[_data_n_328] = {
    .000119818510964326e0
  };
#define _data_n_329 1
  static real_4 _data_l_329[_data_n_329] = {
    -.000006964561891648e0
  };
#define _data_n_330 1
  static real_4 _data_l_330[_data_n_330] = {
    .000000655495621447e0
  };
#define _data_n_331 1
  static real_4 _data_l_331[_data_n_331] = {
    -.000000084066228945e0
  };
#define _data_n_332 1
  static real_4 _data_l_332[_data_n_332] = {
    .000000013376886564e0
  };
#define _data_n_333 1
  static real_4 _data_l_333[_data_n_333] = {
    -.000000002499565654e0
  };
#define _data_n_334 1
  static real_4 _data_l_334[_data_n_334] = {
    .0000000005294951e0
  };
#define _data_n_335 1
  static real_4 _data_l_335[_data_n_335] = {
    -.000000000124135944e0
  };
#define _data_n_336 1
  static real_4 _data_l_336[_data_n_336] = {
    .000000000031656485e0
  };
#define _data_n_337 1
  static real_4 _data_l_337[_data_n_337] = {
    -.00000000000866864e0
  };
#define _data_n_338 1
  static real_4 _data_l_338[_data_n_338] = {
    .000000000002523758e0
  };
#define _data_n_339 1
  static real_4 _data_l_339[_data_n_339] = {
    -.000000000000775085e0
  };
#define _data_n_340 1
  static real_4 _data_l_340[_data_n_340] = {
    .000000000000249527e0
  };
#define _data_n_341 1
  static real_4 _data_l_341[_data_n_341] = {
    -.000000000000083773e0
  };
#define _data_n_342 1
  static real_4 _data_l_342[_data_n_342] = {
    .000000000000029205e0
  };
#define _data_n_343 1
  static real_4 _data_l_343[_data_n_343] = {
    -.000000000000010534e0
  };
#define _data_n_344 1
  static real_4 _data_l_344[_data_n_344] = {
    .000000000000003919e0
  };
#define _data_n_345 1
  static real_4 _data_l_345[_data_n_345] = {
    -.0000000000000015e0
  };
#define _data_n_346 1
  static real_4 _data_l_346[_data_n_346] = {
    .000000000000000589e0
  };
#define _data_n_347 1
  static real_4 _data_l_347[_data_n_347] = {
    -.000000000000000237e0
  };
#define _data_n_348 1
  static real_4 _data_l_348[_data_n_348] = {
    .000000000000000097e0
  };
#define _data_n_349 1
  static real_4 _data_l_349[_data_n_349] = {
    -.00000000000000004e0
  };
#define _data_n_350 1
  static real_4 _data_l_350[_data_n_350] = {
    0.78539816339744831e0
  };
#define _data_n_351 1
  static logical_4 _data_l_351[_data_n_351] = {
    TRUE
  };
  if (__calls[12].calls == 0) {
    _data_k_293 = 0;
    if (_data_k_293 >= _data_n_293) {
      _data_k_293 = 0;
    }
    bj1cs_[0] = _data_l_293[_data_k_293++];
  }
  if (__calls[12].calls == 0) {
    _data_k_294 = 0;
    if (_data_k_294 >= _data_n_294) {
      _data_k_294 = 0;
    }
    bj1cs_[1] = _data_l_294[_data_k_294++];
  }
  if (__calls[12].calls == 0) {
    _data_k_295 = 0;
    if (_data_k_295 >= _data_n_295) {
      _data_k_295 = 0;
    }
    bj1cs_[2] = _data_l_295[_data_k_295++];
  }
  if (__calls[12].calls == 0) {
    _data_k_296 = 0;
    if (_data_k_296 >= _data_n_296) {
      _data_k_296 = 0;
    }
    bj1cs_[3] = _data_l_296[_data_k_296++];
  }
  if (__calls[12].calls == 0) {
    _data_k_297 = 0;
    if (_data_k_297 >= _data_n_297) {
      _data_k_297 = 0;
    }
    bj1cs_[4] = _data_l_297[_data_k_297++];
  }
  if (__calls[12].calls == 0) {
    _data_k_298 = 0;
    if (_data_k_298 >= _data_n_298) {
      _data_k_298 = 0;
    }
    bj1cs_[5] = _data_l_298[_data_k_298++];
  }
  if (__calls[12].calls == 0) {
    _data_k_299 = 0;
    if (_data_k_299 >= _data_n_299) {
      _data_k_299 = 0;
    }
    bj1cs_[6] = _data_l_299[_data_k_299++];
  }
  if (__calls[12].calls == 0) {
    _data_k_300 = 0;
    if (_data_k_300 >= _data_n_300) {
      _data_k_300 = 0;
    }
    bj1cs_[7] = _data_l_300[_data_k_300++];
  }
  if (__calls[12].calls == 0) {
    _data_k_301 = 0;
    if (_data_k_301 >= _data_n_301) {
      _data_k_301 = 0;
    }
    bj1cs_[8] = _data_l_301[_data_k_301++];
  }
  if (__calls[12].calls == 0) {
    _data_k_302 = 0;
    if (_data_k_302 >= _data_n_302) {
      _data_k_302 = 0;
    }
    bj1cs_[9] = _data_l_302[_data_k_302++];
  }
  if (__calls[12].calls == 0) {
    _data_k_303 = 0;
    if (_data_k_303 >= _data_n_303) {
      _data_k_303 = 0;
    }
    bj1cs_[10] = _data_l_303[_data_k_303++];
  }
  if (__calls[12].calls == 0) {
    _data_k_304 = 0;
    if (_data_k_304 >= _data_n_304) {
      _data_k_304 = 0;
    }
    bj1cs_[11] = _data_l_304[_data_k_304++];
  }
  if (__calls[12].calls == 0) {
    _data_k_305 = 0;
    if (_data_k_305 >= _data_n_305) {
      _data_k_305 = 0;
    }
    bm1cs_[0] = _data_l_305[_data_k_305++];
  }
  if (__calls[12].calls == 0) {
    _data_k_306 = 0;
    if (_data_k_306 >= _data_n_306) {
      _data_k_306 = 0;
    }
    bm1cs_[1] = _data_l_306[_data_k_306++];
  }
  if (__calls[12].calls == 0) {
    _data_k_307 = 0;
    if (_data_k_307 >= _data_n_307) {
      _data_k_307 = 0;
    }
    bm1cs_[2] = _data_l_307[_data_k_307++];
  }
  if (__calls[12].calls == 0) {
    _data_k_308 = 0;
    if (_data_k_308 >= _data_n_308) {
      _data_k_308 = 0;
    }
    bm1cs_[3] = _data_l_308[_data_k_308++];
  }
  if (__calls[12].calls == 0) {
    _data_k_309 = 0;
    if (_data_k_309 >= _data_n_309) {
      _data_k_309 = 0;
    }
    bm1cs_[4] = _data_l_309[_data_k_309++];
  }
  if (__calls[12].calls == 0) {
    _data_k_310 = 0;
    if (_data_k_310 >= _data_n_310) {
      _data_k_310 = 0;
    }
    bm1cs_[5] = _data_l_310[_data_k_310++];
  }
  if (__calls[12].calls == 0) {
    _data_k_311 = 0;
    if (_data_k_311 >= _data_n_311) {
      _data_k_311 = 0;
    }
    bm1cs_[6] = _data_l_311[_data_k_311++];
  }
  if (__calls[12].calls == 0) {
    _data_k_312 = 0;
    if (_data_k_312 >= _data_n_312) {
      _data_k_312 = 0;
    }
    bm1cs_[7] = _data_l_312[_data_k_312++];
  }
  if (__calls[12].calls == 0) {
    _data_k_313 = 0;
    if (_data_k_313 >= _data_n_313) {
      _data_k_313 = 0;
    }
    bm1cs_[8] = _data_l_313[_data_k_313++];
  }
  if (__calls[12].calls == 0) {
    _data_k_314 = 0;
    if (_data_k_314 >= _data_n_314) {
      _data_k_314 = 0;
    }
    bm1cs_[9] = _data_l_314[_data_k_314++];
  }
  if (__calls[12].calls == 0) {
    _data_k_315 = 0;
    if (_data_k_315 >= _data_n_315) {
      _data_k_315 = 0;
    }
    bm1cs_[10] = _data_l_315[_data_k_315++];
  }
  if (__calls[12].calls == 0) {
    _data_k_316 = 0;
    if (_data_k_316 >= _data_n_316) {
      _data_k_316 = 0;
    }
    bm1cs_[11] = _data_l_316[_data_k_316++];
  }
  if (__calls[12].calls == 0) {
    _data_k_317 = 0;
    if (_data_k_317 >= _data_n_317) {
      _data_k_317 = 0;
    }
    bm1cs_[12] = _data_l_317[_data_k_317++];
  }
  if (__calls[12].calls == 0) {
    _data_k_318 = 0;
    if (_data_k_318 >= _data_n_318) {
      _data_k_318 = 0;
    }
    bm1cs_[13] = _data_l_318[_data_k_318++];
  }
  if (__calls[12].calls == 0) {
    _data_k_319 = 0;
    if (_data_k_319 >= _data_n_319) {
      _data_k_319 = 0;
    }
    bm1cs_[14] = _data_l_319[_data_k_319++];
  }
  if (__calls[12].calls == 0) {
    _data_k_320 = 0;
    if (_data_k_320 >= _data_n_320) {
      _data_k_320 = 0;
    }
    bm1cs_[15] = _data_l_320[_data_k_320++];
  }
  if (__calls[12].calls == 0) {
    _data_k_321 = 0;
    if (_data_k_321 >= _data_n_321) {
      _data_k_321 = 0;
    }
    bm1cs_[16] = _data_l_321[_data_k_321++];
  }
  if (__calls[12].calls == 0) {
    _data_k_322 = 0;
    if (_data_k_322 >= _data_n_322) {
      _data_k_322 = 0;
    }
    bm1cs_[17] = _data_l_322[_data_k_322++];
  }
  if (__calls[12].calls == 0) {
    _data_k_323 = 0;
    if (_data_k_323 >= _data_n_323) {
      _data_k_323 = 0;
    }
    bm1cs_[18] = _data_l_323[_data_k_323++];
  }
  if (__calls[12].calls == 0) {
    _data_k_324 = 0;
    if (_data_k_324 >= _data_n_324) {
      _data_k_324 = 0;
    }
    bm1cs_[19] = _data_l_324[_data_k_324++];
  }
  if (__calls[12].calls == 0) {
    _data_k_325 = 0;
    if (_data_k_325 >= _data_n_325) {
      _data_k_325 = 0;
    }
    bm1cs_[20] = _data_l_325[_data_k_325++];
  }
  if (__calls[12].calls == 0) {
    _data_k_326 = 0;
    if (_data_k_326 >= _data_n_326) {
      _data_k_326 = 0;
    }
    bth1cs_[0] = _data_l_326[_data_k_326++];
  }
  if (__calls[12].calls == 0) {
    _data_k_327 = 0;
    if (_data_k_327 >= _data_n_327) {
      _data_k_327 = 0;
    }
    bth1cs_[1] = _data_l_327[_data_k_327++];
  }
  if (__calls[12].calls == 0) {
    _data_k_328 = 0;
    if (_data_k_328 >= _data_n_328) {
      _data_k_328 = 0;
    }
    bth1cs_[2] = _data_l_328[_data_k_328++];
  }
  if (__calls[12].calls == 0) {
    _data_k_329 = 0;
    if (_data_k_329 >= _data_n_329) {
      _data_k_329 = 0;
    }
    bth1cs_[3] = _data_l_329[_data_k_329++];
  }
  if (__calls[12].calls == 0) {
    _data_k_330 = 0;
    if (_data_k_330 >= _data_n_330) {
      _data_k_330 = 0;
    }
    bth1cs_[4] = _data_l_330[_data_k_330++];
  }
  if (__calls[12].calls == 0) {
    _data_k_331 = 0;
    if (_data_k_331 >= _data_n_331) {
      _data_k_331 = 0;
    }
    bth1cs_[5] = _data_l_331[_data_k_331++];
  }
  if (__calls[12].calls == 0) {
    _data_k_332 = 0;
    if (_data_k_332 >= _data_n_332) {
      _data_k_332 = 0;
    }
    bth1cs_[6] = _data_l_332[_data_k_332++];
  }
  if (__calls[12].calls == 0) {
    _data_k_333 = 0;
    if (_data_k_333 >= _data_n_333) {
      _data_k_333 = 0;
    }
    bth1cs_[7] = _data_l_333[_data_k_333++];
  }
  if (__calls[12].calls == 0) {
    _data_k_334 = 0;
    if (_data_k_334 >= _data_n_334) {
      _data_k_334 = 0;
    }
    bth1cs_[8] = _data_l_334[_data_k_334++];
  }
  if (__calls[12].calls == 0) {
    _data_k_335 = 0;
    if (_data_k_335 >= _data_n_335) {
      _data_k_335 = 0;
    }
    bth1cs_[9] = _data_l_335[_data_k_335++];
  }
  if (__calls[12].calls == 0) {
    _data_k_336 = 0;
    if (_data_k_336 >= _data_n_336) {
      _data_k_336 = 0;
    }
    bth1cs_[10] = _data_l_336[_data_k_336++];
  }
  if (__calls[12].calls == 0) {
    _data_k_337 = 0;
    if (_data_k_337 >= _data_n_337) {
      _data_k_337 = 0;
    }
    bth1cs_[11] = _data_l_337[_data_k_337++];
  }
  if (__calls[12].calls == 0) {
    _data_k_338 = 0;
    if (_data_k_338 >= _data_n_338) {
      _data_k_338 = 0;
    }
    bth1cs_[12] = _data_l_338[_data_k_338++];
  }
  if (__calls[12].calls == 0) {
    _data_k_339 = 0;
    if (_data_k_339 >= _data_n_339) {
      _data_k_339 = 0;
    }
    bth1cs_[13] = _data_l_339[_data_k_339++];
  }
  if (__calls[12].calls == 0) {
    _data_k_340 = 0;
    if (_data_k_340 >= _data_n_340) {
      _data_k_340 = 0;
    }
    bth1cs_[14] = _data_l_340[_data_k_340++];
  }
  if (__calls[12].calls == 0) {
    _data_k_341 = 0;
    if (_data_k_341 >= _data_n_341) {
      _data_k_341 = 0;
    }
    bth1cs_[15] = _data_l_341[_data_k_341++];
  }
  if (__calls[12].calls == 0) {
    _data_k_342 = 0;
    if (_data_k_342 >= _data_n_342) {
      _data_k_342 = 0;
    }
    bth1cs_[16] = _data_l_342[_data_k_342++];
  }
  if (__calls[12].calls == 0) {
    _data_k_343 = 0;
    if (_data_k_343 >= _data_n_343) {
      _data_k_343 = 0;
    }
    bth1cs_[17] = _data_l_343[_data_k_343++];
  }
  if (__calls[12].calls == 0) {
    _data_k_344 = 0;
    if (_data_k_344 >= _data_n_344) {
      _data_k_344 = 0;
    }
    bth1cs_[18] = _data_l_344[_data_k_344++];
  }
  if (__calls[12].calls == 0) {
    _data_k_345 = 0;
    if (_data_k_345 >= _data_n_345) {
      _data_k_345 = 0;
    }
    bth1cs_[19] = _data_l_345[_data_k_345++];
  }
  if (__calls[12].calls == 0) {
    _data_k_346 = 0;
    if (_data_k_346 >= _data_n_346) {
      _data_k_346 = 0;
    }
    bth1cs_[20] = _data_l_346[_data_k_346++];
  }
  if (__calls[12].calls == 0) {
    _data_k_347 = 0;
    if (_data_k_347 >= _data_n_347) {
      _data_k_347 = 0;
    }
    bth1cs_[21] = _data_l_347[_data_k_347++];
  }
  if (__calls[12].calls == 0) {
    _data_k_348 = 0;
    if (_data_k_348 >= _data_n_348) {
      _data_k_348 = 0;
    }
    bth1cs_[22] = _data_l_348[_data_k_348++];
  }
  if (__calls[12].calls == 0) {
    _data_k_349 = 0;
    if (_data_k_349 >= _data_n_349) {
      _data_k_349 = 0;
    }
    bth1cs_[23] = _data_l_349[_data_k_349++];
  }
  if (__calls[12].calls == 0) {
    _data_k_350 = 0;
    if (_data_k_350 >= _data_n_350) {
      _data_k_350 = 0;
    }
    pi4_ = _data_l_350[_data_k_350++];
  }
  if (__calls[12].calls == 0) {
    _data_k_351 = 0;
    if (_data_k_351 >= _data_n_351) {
      _data_k_351 = 0;
    }
    first_ = _data_l_351[_data_k_351++];
  }
  if (first_) {
    ntj1_ = _inits (bj1cs_, ($0_ = 12, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    ntm1_ = _inits (bm1cs_, ($3_ = 21, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    ntth1_ = _inits (bth1cs_, ($6_ = 24, &$6_), ($8_ = 0.1 * _r1mach (($7_ = 3, &$7_)), &$8_));
    xsml_ = sqrtf (8.0 * _r1mach (($9_ = 3, &$9_)));
    xmin_ = 2.0 * _r1mach (&_k1);
    xmax_ = 1.0 / _r1mach (($10_ = 4, &$10_));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 4.0) {
    goto _l20;
  }
  besj1_ = 0.0;
  if (y_ == 0.0) {
    goto _l0;
  }
  if (y_ <= xmin_) {
    (void) _xermsg (_dc_0, _dc_25, _dc_26, &_k1, &_k1);
  }
  if (y_ > xmin_) {
    besj1_ = 0.5 * (*x_);
  }
  if (y_ > xsml_) {
    besj1_ = (*x_) * (.25 + _csevl (($11_ = .125 * y_ * y_ - 1.0, &$11_), bj1cs_, &ntj1_));
  }
  goto _l0;
  _l20:;
  if (y_ > xmax_) {
    (void) _xermsg (_dc_0, _dc_25, _dc_24, ($12_ = 2, &$12_), ($13_ = 2, &$13_));
  }
  z_ = 32.0 / (y_ * y_) - 1.0;
  ampl_ = (0.75 + _csevl (&z_, bm1cs_, &ntm1_)) / sqrtf (y_);
  theta_ = y_ - 3.0 * pi4_ + _csevl (&z_, bth1cs_, &ntth1_) / y_;
  besj1_ = _sign (ampl_, (*x_)) * cosf (theta_);
  _l0:;
  __calls[12].calls++;
  return besj1_;
}

int_4 _besj (real_4 _p_ x_, real_4 _p_ alpha_, int_4 _p_ n_, real_4 _p_ y_, int_4 _p_ nz_)
{
  static int_4 i_, ialp_, idalp_, iflw_, in_, inlim_, is_, i1_, i2_, k_, kk_, km_, kt_, nn_, ns_;
  static real_4 ak_, akm_, ans_, ap_, arg_, coef_, dalpha_, dfn_, dtm_, earg_, elim1_, etx_, fidal_, flgjy_, fn_, fnf_, 
  fni_, fnp1_, fnu_, fnulim_[2], gln_, pdf_, pidt_, pp_[4], rden_, relb_, rttp_, rtwo_, rtx_, rzden_, s_, sa_, sb_, sxo2_
  , s1_, s2_, t_, ta_, tau_, tb_, temp_[3], tfn_, tm_, tol_, tolln_, trx_, tx_, t1_, t2_, wk_[7], xo2_, xo2l_, rtol_, 
  slim_, alngam_;
  int_4 _data_k_352, _data_k_353, _data_k_354, _data_k_355, $0_, $1_, $2_, $3_, $4_, $7_, $8_, $9_, $10_, $11_;
  real_4 $5_, $6_;
  extern int_4 _jairy ();
  extern int_4 _i1mach ();
  extern real_4 _r1mach ();
#define _data_n_352 4
  static real_4 _data_l_352[_data_n_352] = {
    1.34839972492648e+00,
    7.85398163397448e-1,
    7.97884560802865e-1,
    1.5707963267949e+00
  };
#define _data_n_353 4
  static real_4 _data_l_353[_data_n_353] = {
    8.72909153935547e+00,
    2.6569393226503e-1,
    1.24578576865586e-1,
    7.70133747430388e-4
  };
#define _data_n_354 1
  static int_4 _data_l_354[_data_n_354] = {
    150
  };
#define _data_n_355 2
  static real_4 _data_l_355[_data_n_355] = {
    100.0e0,
    60.0e0
  };
  if (__calls[13].calls == 0) {
    _data_k_352 = 0;
    if (_data_k_352 >= _data_n_352) {
      _data_k_352 = 0;
    }
    rtwo_ = _data_l_352[_data_k_352++];
    if (_data_k_352 >= _data_n_352) {
      _data_k_352 = 0;
    }
    pdf_ = _data_l_352[_data_k_352++];
    if (_data_k_352 >= _data_n_352) {
      _data_k_352 = 0;
    }
    rttp_ = _data_l_352[_data_k_352++];
    if (_data_k_352 >= _data_n_352) {
      _data_k_352 = 0;
    }
    pidt_ = _data_l_352[_data_k_352++];
  }
  if (__calls[13].calls == 0) {
    _data_k_353 = 0;
    if (_data_k_353 >= _data_n_353) {
      _data_k_353 = 0;
    }
    pp_[0] = _data_l_353[_data_k_353++];
    if (_data_k_353 >= _data_n_353) {
      _data_k_353 = 0;
    }
    pp_[1] = _data_l_353[_data_k_353++];
    if (_data_k_353 >= _data_n_353) {
      _data_k_353 = 0;
    }
    pp_[2] = _data_l_353[_data_k_353++];
    if (_data_k_353 >= _data_n_353) {
      _data_k_353 = 0;
    }
    pp_[3] = _data_l_353[_data_k_353++];
  }
  if (__calls[13].calls == 0) {
    _data_k_354 = 0;
    if (_data_k_354 >= _data_n_354) {
      _data_k_354 = 0;
    }
    inlim_ = _data_l_354[_data_k_354++];
  }
  if (__calls[13].calls == 0) {
    _data_k_355 = 0;
    if (_data_k_355 >= _data_n_355) {
      _data_k_355 = 0;
    }
    fnulim_[0] = _data_l_355[_data_k_355++];
    if (_data_k_355 >= _data_n_355) {
      _data_k_355 = 0;
    }
    fnulim_[1] = _data_l_355[_data_k_355++];
  }
  (*nz_) = 0;
  kt_ = 1;
  ns_ = 0;
  ta_ = _r1mach (($0_ = 3, &$0_));
  tol_ = _max (ta_, 1.0e-15);
  i1_ = _i1mach (($1_ = 11, &$1_)) + 1;
  i2_ = _i1mach (($2_ = 12, &$2_));
  tb_ = _r1mach (($3_ = 5, &$3_));
  elim1_ = -2.303e0 * (i2_ * tb_ + 3.0e0);
  rtol_ = 1.0e0 / tol_;
  slim_ = _r1mach (&_k1) * 1.0e3 * rtol_;
  tolln_ = 2.303e0 * tb_ * i1_;
  tolln_ = _min (tolln_, 34.5388);
  $4_ = (*n_) - 1;
  if ($4_ < 0) {
    goto _l720;
  } else if ($4_ == 0) {
    goto _l10;
  } else {
    goto _l20;
  }
  _l10:;
  kt_ = 2;
  _l20:;
  nn_ = (*n_);
  $5_ = (*x_);
  if ($5_ < 0) {
    goto _l730;
  } else if ($5_ == 0) {
    goto _l30;
  } else {
    goto _l80;
  }
  _l30:;
  $6_ = (*alpha_);
  if ($6_ < 0) {
    goto _l710;
  } else if ($6_ == 0) {
    goto _l40;
  } else {
    goto _l50;
  }
  _l40:;
  y_[0] = 1.0;
  if ((*n_) == 1) {
    goto _l0;
  }
  i1_ = 2;
  goto _l60;
  _l50:;
  i1_ = 1;
  _l60:;
  for (i_ = i1_; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = 0.0;
  }
  goto _l0;
  _l80:;
  if ((*alpha_) < 0.0e0) {
    goto _l710;
  }
  ialp_ = (int_4) (_aintd ((*alpha_)));
  fni_ = ialp_ + (*n_) - 1;
  fnf_ = (*alpha_) - ialp_;
  dfn_ = fni_ + fnf_;
  fnu_ = dfn_;
  xo2_ = (*x_) * 0.5e0;
  sxo2_ = xo2_ * xo2_;
  if (sxo2_ <= (fnu_ + 1.0e0)) {
    goto _l90;
  }
  ta_ = _max (20.0, fnu_);
  if ((*x_) > ta_) {
    goto _l120;
  }
  if ((*x_) > 12.0e0) {
    goto _l110;
  }
  xo2l_ = logf (xo2_);
  ns_ = (int_4) (_aintd (sxo2_ - fnu_)) + 1;
  goto _l100;
  _l90:;
  fn_ = fnu_;
  fnp1_ = fn_ + 1.0e0;
  xo2l_ = logf (xo2_);
  is_ = kt_;
  if ((*x_) <= 0.5e0) {
    goto _l330;
  }
  ns_ = 0;
  _l100:;
  fni_ = fni_ + ns_;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  fnp1_ = fn_ + 1.0e0;
  is_ = kt_;
  if ((*n_) - 1 + ns_ > 0) {
    is_ = 3;
  }
  goto _l330;
  _l110:;
  ans_ = _max (36.0e0 - fnu_, 0.0);
  ns_ = (int_4) (_aintd (ans_));
  fni_ = fni_ + ns_;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  is_ = kt_;
  if ((*n_) - 1 + ns_ > 0) {
    is_ = 3;
  }
  goto _l130;
  _l120:;
  rtx_ = sqrtf ((*x_));
  tau_ = rtwo_ * rtx_;
  ta_ = tau_ + fnulim_[kt_ - 1];
  if (fnu_ <= ta_) {
    goto _l480;
  }
  fn_ = fnu_;
  is_ = kt_;
  _l130:;
  i1_ = _abs (3 - is_);
  i1_ = _max (i1_, 1);
  flgjy_ = 1.0;
  (void) _asyjy (_jairy, x_, &fn_, &flgjy_, &i1_, &temp_[is_ - 1], wk_, &iflw_);
  if (iflw_ != 0) {
    goto _l380;
  }
  switch (is_) {
    default:
    case 1: goto _l320;
    case 2: goto _l450;
    case 3: goto _l620;
  }
  _l310:;
  temp_[0] = temp_[2];
  kt_ = 1;
  _l320:;
  is_ = 2;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  if (i1_ == 2) {
    goto _l450;
  }
  goto _l130;
  _l330:;
  gln_ = lgammaf (fnp1_);
  arg_ = fn_ * xo2l_ - gln_;
  if (arg_ < (-elim1_)) {
    goto _l400;
  }
  earg_ = expf (arg_);
  _l340:;
  s_ = 1.0;
  if ((*x_) < tol_) {
    goto _l360;
  }
  ak_ = 3.0;
  t2_ = 1.0;
  t_ = 1.0;
  s1_ = fn_;
  for (k_ = 1; k_ <= 17; (k_)++) {
    s2_ = t2_ + s1_;
    t_ = -t_ * sxo2_ / s2_;
    s_ = s_ + t_;
    if (_abs (t_) < tol_) {
      goto _l360;
    }
    t2_ = t2_ + ak_;
    ak_ = ak_ + 2.0e0;
    s1_ = s1_ + fn_;
  }
  _l360:;
  temp_[is_ - 1] = s_ * earg_;
  switch (is_) {
    default:
    case 1: goto _l370;
    case 2: goto _l450;
    case 3: goto _l610;
  }
  _l370:;
  earg_ = earg_ * fn_ / xo2_;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  is_ = 2;
  goto _l340;
  _l380:;
  y_[nn_ - 1] = 0.0;
  nn_ = nn_ - 1;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  $7_ = nn_ - 1;
  if ($7_ < 0) {
    goto _l440;
  } else if ($7_ == 0) {
    goto _l390;
  } else {
    goto _l130;
  }
  _l390:;
  kt_ = 2;
  is_ = 2;
  goto _l130;
  _l400:;
  y_[nn_ - 1] = 0.0;
  nn_ = nn_ - 1;
  fnp1_ = fn_;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  $8_ = nn_ - 1;
  if ($8_ < 0) {
    goto _l440;
  } else if ($8_ == 0) {
    goto _l410;
  } else {
    goto _l420;
  }
  _l410:;
  kt_ = 2;
  is_ = 2;
  _l420:;
  if (sxo2_ <= fnp1_) {
    goto _l430;
  }
  goto _l130;
  _l430:;
  arg_ = arg_ - xo2l_ + logf (fnp1_);
  if (arg_ < (-elim1_)) {
    goto _l400;
  }
  goto _l330;
  _l440:;
  (*nz_) = (*n_) - nn_;
  goto _l0;
  _l450:;
  if (ns_ != 0) {
    goto _l451;
  }
  (*nz_) = (*n_) - nn_;
  if (kt_ == 2) {
    goto _l470;
  }
  y_[nn_ - 1] = temp_[0];
  y_[nn_ - 1 - 1] = temp_[1];
  if (nn_ == 2) {
    goto _l0;
  }
  _l451:;
  trx_ = 2.0e0 / (*x_);
  dtm_ = fni_;
  tm_ = (dtm_ + fnf_) * trx_;
  ak_ = 1.0;
  ta_ = temp_[0];
  tb_ = temp_[1];
  if (_abs (ta_) > slim_) {
    goto _l455;
  }
  ta_ = ta_ * rtol_;
  tb_ = tb_ * rtol_;
  ak_ = tol_;
  _l455:;
  kk_ = 2;
  in_ = ns_ - 1;
  if (in_ == 0) {
    goto _l690;
  }
  if (ns_ != 0) {
    goto _l670;
  }
  k_ = nn_ - 2;
  for (i_ = 3; i_ <= nn_; (i_)++) {
    s_ = tb_;
    tb_ = tm_ * tb_ - ta_;
    ta_ = s_;
    y_[k_ - 1] = tb_ * ak_;
    k_ = k_ - 1;
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
  }
  goto _l0;
  _l470:;
  y_[0] = temp_[1];
  goto _l0;
  _l480:;
  in_ = (int_4) (_aintd ((*alpha_) - tau_ + 2.0e0));
  if (in_ <= 0) {
    goto _l490;
  }
  idalp_ = ialp_ - in_ - 1;
  kt_ = 1;
  goto _l500;
  _l490:;
  idalp_ = ialp_;
  in_ = 0;
  _l500:;
  is_ = kt_;
  fidal_ = idalp_;
  dalpha_ = fidal_ + fnf_;
  arg_ = (*x_) - pidt_ * dalpha_ - pdf_;
  sa_ = sinf (arg_);
  sb_ = cosf (arg_);
  coef_ = rttp_ / rtx_;
  etx_ = 8.0e0 * (*x_);
  _l510:;
  dtm_ = fidal_ + fidal_;
  dtm_ = dtm_ * dtm_;
  tm_ = 0.0;
  if (fidal_ == 0.0e0 && _abs (fnf_) < tol_) {
    goto _l520;
  }
  tm_ = 4.0e0 * fnf_ * (fidal_ + fidal_ + fnf_);
  _l520:;
  trx_ = dtm_ - 1.0e0;
  t2_ = (trx_ + tm_) / etx_;
  s2_ = t2_;
  relb_ = tol_ * _abs (t2_);
  t1_ = etx_;
  s1_ = 1.0;
  fn_ = 1.0;
  ak_ = 8.0;
  for (k_ = 1; k_ <= 13; (k_)++) {
    t1_ = t1_ + etx_;
    fn_ = fn_ + ak_;
    trx_ = dtm_ - fn_;
    ap_ = trx_ + tm_;
    t2_ = -t2_ * ap_ / t1_;
    s1_ = s1_ + t2_;
    t1_ = t1_ + etx_;
    ak_ = ak_ + 8.0e0;
    fn_ = fn_ + ak_;
    trx_ = dtm_ - fn_;
    ap_ = trx_ + tm_;
    t2_ = t2_ * ap_ / t1_;
    s2_ = s2_ + t2_;
    if (_abs (t2_) <= relb_) {
      goto _l540;
    }
    ak_ = ak_ + 8.0e0;
  }
  _l540:;
  temp_[is_ - 1] = coef_ * (s1_ * sb_ - s2_ * sa_);
  if (is_ == 2) {
    goto _l560;
  }
  fidal_ = fidal_ + 1.0e0;
  dalpha_ = fidal_ + fnf_;
  is_ = 2;
  tb_ = sa_;
  sa_ = -sb_;
  sb_ = tb_;
  goto _l510;
  _l560:;
  if (kt_ == 2) {
    goto _l470;
  }
  s1_ = temp_[0];
  s2_ = temp_[1];
  tx_ = 2.0e0 / (*x_);
  tm_ = dalpha_ * tx_;
  if (in_ == 0) {
    goto _l580;
  }
  for (i_ = 1; i_ <= in_; (i_)++) {
    s_ = s2_;
    s2_ = tm_ * s2_ - s1_;
    tm_ = tm_ + tx_;
    s1_ = s_;
  }
  if (nn_ == 1) {
    goto _l600;
  }
  s_ = s2_;
  s2_ = tm_ * s2_ - s1_;
  tm_ = tm_ + tx_;
  s1_ = s_;
  _l580:;
  y_[0] = s1_;
  y_[1] = s2_;
  if (nn_ == 2) {
    goto _l0;
  }
  for (i_ = 3; i_ <= nn_; (i_)++) {
    y_[i_ - 1] = tm_ * y_[i_ - 1 - 1] - y_[i_ - 2 - 1];
    tm_ = tm_ + tx_;
  }
  goto _l0;
  _l600:;
  y_[0] = s2_;
  goto _l0;
  _l610:;
  akm_ = _max (3.0e0 - fn_, 0.0);
  km_ = (int_4) (_aintd (akm_));
  tfn_ = fn_ + km_;
  ta_ = (gln_ + tfn_ - 0.9189385332e0 - 0.0833333333e0 / tfn_) / (tfn_ + 0.5e0);
  ta_ = xo2l_ - ta_;
  tb_ = -(1.0e0 - 1.5e0 / tfn_) / tfn_;
  akm_ = tolln_ / (-ta_ + sqrtf (ta_ * ta_ - tolln_ * tb_)) + 1.5e0;
  in_ = km_ + (int_4) (_aintd (akm_));
  goto _l660;
  _l620:;
  gln_ = wk_[2] + wk_[1];
  if (wk_[5] > 30.0e0) {
    goto _l640;
  }
  rden_ = (pp_[3] * wk_[5] + pp_[2]) * wk_[5] + 1.0e0;
  rzden_ = pp_[0] + pp_[1] * wk_[5];
  ta_ = rzden_ / rden_;
  if (wk_[0] < 0.1e0) {
    goto _l630;
  }
  tb_ = gln_ / wk_[4];
  goto _l650;
  _l630:;
  tb_ = (1.259921049e0 + (0.167989473e0 + 0.0887944358e0 * wk_[0]) * wk_[0]) / wk_[6];
  goto _l650;
  _l640:;
  ta_ = 0.5e0 * tolln_ / wk_[3];
  ta_ = ((0.049382716e0 * ta_ - 0.1111111111e0) * ta_ + 0.6666666667e0) * ta_ * wk_[5];
  if (wk_[0] < 0.1e0) {
    goto _l630;
  }
  tb_ = gln_ / wk_[4];
  _l650:;
  in_ = (int_4) (_aintd (ta_ / tb_ + 1.5e0));
  if (in_ > inlim_) {
    goto _l310;
  }
  _l660:;
  dtm_ = fni_ + in_;
  trx_ = 2.0e0 / (*x_);
  tm_ = (dtm_ + fnf_) * trx_;
  ta_ = 0.0;
  tb_ = tol_;
  kk_ = 1;
  ak_ = 1.0;
  _l670:;
  for (i_ = 1; i_ <= in_; (i_)++) {
    s_ = tb_;
    tb_ = tm_ * tb_ - ta_;
    ta_ = s_;
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
  }
  if (kk_ != 1) {
    goto _l690;
  }
  s_ = temp_[2];
  sa_ = ta_ / tb_;
  ta_ = s_;
  tb_ = s_;
  if (_abs (s_) > slim_) {
    goto _l685;
  }
  ta_ = ta_ * rtol_;
  tb_ = tb_ * rtol_;
  ak_ = tol_;
  _l685:;
  ta_ = ta_ * sa_;
  kk_ = 2;
  in_ = ns_;
  if (ns_ != 0) {
    goto _l670;
  }
  _l690:;
  y_[nn_ - 1] = tb_ * ak_;
  (*nz_) = (*n_) - nn_;
  if (nn_ == 1) {
    goto _l0;
  }
  k_ = nn_ - 1;
  s_ = tb_;
  tb_ = tm_ * tb_ - ta_;
  ta_ = s_;
  y_[k_ - 1] = tb_ * ak_;
  if (nn_ == 2) {
    goto _l0;
  }
  dtm_ = dtm_ - 1.0e0;
  tm_ = (dtm_ + fnf_) * trx_;
  k_ = nn_ - 2;
  for (i_ = 3; i_ <= nn_; (i_)++) {
    s_ = tb_;
    tb_ = tm_ * tb_ - ta_;
    ta_ = s_;
    y_[k_ - 1] = tb_ * ak_;
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
    k_ = k_ - 1;
  }
  goto _l0;
  _l710:;
  (void) _xermsg (_dc_0, _dc_27, _dc_19, ($9_ = 2, &$9_), &_k1);
  goto _l0;
  _l720:;
  (void) _xermsg (_dc_0, _dc_27, _dc_20, ($10_ = 2, &$10_), &_k1);
  goto _l0;
  _l730:;
  (void) _xermsg (_dc_0, _dc_27, _dc_21, ($11_ = 2, &$11_), &_k1);
  _l0:;
  __calls[13].calls++;
  return 0;
}

real_4 _besk0e (real_4 _p_ x_)
{
  static int_4 ntk0_, ntak0_, ntak02_;
  static logical_4 first_;
  static real_4 besk0e_, bk0cs_[11], ak0cs_[17], ak02cs_[14], xsml_, y_;
  int_4 _data_k_356, _data_k_357, _data_k_358, _data_k_359, _data_k_360, _data_k_361, _data_k_362, _data_k_363, 
  _data_k_364, _data_k_365, _data_k_366, _data_k_367, _data_k_368, _data_k_369, _data_k_370, _data_k_371, _data_k_372, 
  _data_k_373, _data_k_374, _data_k_375, _data_k_376, _data_k_377, _data_k_378, _data_k_379, _data_k_380, _data_k_381, 
  _data_k_382, _data_k_383, _data_k_384, _data_k_385, _data_k_386, _data_k_387, _data_k_388, _data_k_389, _data_k_390, 
  _data_k_391, _data_k_392, _data_k_393, _data_k_394, _data_k_395, _data_k_396, _data_k_397, _data_k_398, $0_, $1_, $3_, 
  $4_, $6_, $7_, $9_, $10_, $11_;
  real_4 $2_, $5_, $8_, $12_, $13_, $14_;
  extern real_4 _r1mach ();
#define _data_n_356 1
  static real_4 _data_l_356[_data_n_356] = {
    -.03532739323390276872e0
  };
#define _data_n_357 1
  static real_4 _data_l_357[_data_n_357] = {
    .3442898999246284869e0
  };
#define _data_n_358 1
  static real_4 _data_l_358[_data_n_358] = {
    .03597993651536150163e0
  };
#define _data_n_359 1
  static real_4 _data_l_359[_data_n_359] = {
    .00126461541144692592e0
  };
#define _data_n_360 1
  static real_4 _data_l_360[_data_n_360] = {
    .00002286212103119451e0
  };
#define _data_n_361 1
  static real_4 _data_l_361[_data_n_361] = {
    .00000025347910790261e0
  };
#define _data_n_362 1
  static real_4 _data_l_362[_data_n_362] = {
    .00000000190451637722e0
  };
#define _data_n_363 1
  static real_4 _data_l_363[_data_n_363] = {
    .00000000001034969525e0
  };
#define _data_n_364 1
  static real_4 _data_l_364[_data_n_364] = {
    .00000000000004259816e0
  };
#define _data_n_365 1
  static real_4 _data_l_365[_data_n_365] = {
    .00000000000000013744e0
  };
#define _data_n_366 1
  static real_4 _data_l_366[_data_n_366] = {
    .00000000000000000035e0
  };
#define _data_n_367 1
  static real_4 _data_l_367[_data_n_367] = {
    -.07643947903327941e0
  };
#define _data_n_368 1
  static real_4 _data_l_368[_data_n_368] = {
    -.02235652605699819e0
  };
#define _data_n_369 1
  static real_4 _data_l_369[_data_n_369] = {
    .00077341811546938e0
  };
#define _data_n_370 1
  static real_4 _data_l_370[_data_n_370] = {
    -.00004281006688886e0
  };
#define _data_n_371 1
  static real_4 _data_l_371[_data_n_371] = {
    .00000308170017386e0
  };
#define _data_n_372 1
  static real_4 _data_l_372[_data_n_372] = {
    -.0000002639367222e0
  };
#define _data_n_373 1
  static real_4 _data_l_373[_data_n_373] = {
    .00000002563713036e0
  };
#define _data_n_374 1
  static real_4 _data_l_374[_data_n_374] = {
    -.00000000274270554e0
  };
#define _data_n_375 1
  static real_4 _data_l_375[_data_n_375] = {
    .00000000031694296e0
  };
#define _data_n_376 1
  static real_4 _data_l_376[_data_n_376] = {
    -.00000000003902353e0
  };
#define _data_n_377 1
  static real_4 _data_l_377[_data_n_377] = {
    .00000000000506804e0
  };
#define _data_n_378 1
  static real_4 _data_l_378[_data_n_378] = {
    -.00000000000068895e0
  };
#define _data_n_379 1
  static real_4 _data_l_379[_data_n_379] = {
    .00000000000009744e0
  };
#define _data_n_380 1
  static real_4 _data_l_380[_data_n_380] = {
    -.00000000000001427e0
  };
#define _data_n_381 1
  static real_4 _data_l_381[_data_n_381] = {
    .00000000000000215e0
  };
#define _data_n_382 1
  static real_4 _data_l_382[_data_n_382] = {
    -.00000000000000033e0
  };
#define _data_n_383 1
  static real_4 _data_l_383[_data_n_383] = {
    .00000000000000005e0
  };
#define _data_n_384 1
  static real_4 _data_l_384[_data_n_384] = {
    -.01201869826307592e0
  };
#define _data_n_385 1
  static real_4 _data_l_385[_data_n_385] = {
    -.00917485269102569e0
  };
#define _data_n_386 1
  static real_4 _data_l_386[_data_n_386] = {
    .0001444550931775e0
  };
#define _data_n_387 1
  static real_4 _data_l_387[_data_n_387] = {
    -.00000401361417543e0
  };
#define _data_n_388 1
  static real_4 _data_l_388[_data_n_388] = {
    .00000015678318108e0
  };
#define _data_n_389 1
  static real_4 _data_l_389[_data_n_389] = {
    -.00000000777011043e0
  };
#define _data_n_390 1
  static real_4 _data_l_390[_data_n_390] = {
    .00000000046111825e0
  };
#define _data_n_391 1
  static real_4 _data_l_391[_data_n_391] = {
    -.00000000003158592e0
  };
#define _data_n_392 1
  static real_4 _data_l_392[_data_n_392] = {
    .00000000000243501e0
  };
#define _data_n_393 1
  static real_4 _data_l_393[_data_n_393] = {
    -.00000000000020743e0
  };
#define _data_n_394 1
  static real_4 _data_l_394[_data_n_394] = {
    .00000000000001925e0
  };
#define _data_n_395 1
  static real_4 _data_l_395[_data_n_395] = {
    -.00000000000000192e0
  };
#define _data_n_396 1
  static real_4 _data_l_396[_data_n_396] = {
    .0000000000000002e0
  };
#define _data_n_397 1
  static real_4 _data_l_397[_data_n_397] = {
    -.00000000000000002e0
  };
#define _data_n_398 1
  static logical_4 _data_l_398[_data_n_398] = {
    TRUE
  };
  if (__calls[14].calls == 0) {
    _data_k_356 = 0;
    if (_data_k_356 >= _data_n_356) {
      _data_k_356 = 0;
    }
    bk0cs_[0] = _data_l_356[_data_k_356++];
  }
  if (__calls[14].calls == 0) {
    _data_k_357 = 0;
    if (_data_k_357 >= _data_n_357) {
      _data_k_357 = 0;
    }
    bk0cs_[1] = _data_l_357[_data_k_357++];
  }
  if (__calls[14].calls == 0) {
    _data_k_358 = 0;
    if (_data_k_358 >= _data_n_358) {
      _data_k_358 = 0;
    }
    bk0cs_[2] = _data_l_358[_data_k_358++];
  }
  if (__calls[14].calls == 0) {
    _data_k_359 = 0;
    if (_data_k_359 >= _data_n_359) {
      _data_k_359 = 0;
    }
    bk0cs_[3] = _data_l_359[_data_k_359++];
  }
  if (__calls[14].calls == 0) {
    _data_k_360 = 0;
    if (_data_k_360 >= _data_n_360) {
      _data_k_360 = 0;
    }
    bk0cs_[4] = _data_l_360[_data_k_360++];
  }
  if (__calls[14].calls == 0) {
    _data_k_361 = 0;
    if (_data_k_361 >= _data_n_361) {
      _data_k_361 = 0;
    }
    bk0cs_[5] = _data_l_361[_data_k_361++];
  }
  if (__calls[14].calls == 0) {
    _data_k_362 = 0;
    if (_data_k_362 >= _data_n_362) {
      _data_k_362 = 0;
    }
    bk0cs_[6] = _data_l_362[_data_k_362++];
  }
  if (__calls[14].calls == 0) {
    _data_k_363 = 0;
    if (_data_k_363 >= _data_n_363) {
      _data_k_363 = 0;
    }
    bk0cs_[7] = _data_l_363[_data_k_363++];
  }
  if (__calls[14].calls == 0) {
    _data_k_364 = 0;
    if (_data_k_364 >= _data_n_364) {
      _data_k_364 = 0;
    }
    bk0cs_[8] = _data_l_364[_data_k_364++];
  }
  if (__calls[14].calls == 0) {
    _data_k_365 = 0;
    if (_data_k_365 >= _data_n_365) {
      _data_k_365 = 0;
    }
    bk0cs_[9] = _data_l_365[_data_k_365++];
  }
  if (__calls[14].calls == 0) {
    _data_k_366 = 0;
    if (_data_k_366 >= _data_n_366) {
      _data_k_366 = 0;
    }
    bk0cs_[10] = _data_l_366[_data_k_366++];
  }
  if (__calls[14].calls == 0) {
    _data_k_367 = 0;
    if (_data_k_367 >= _data_n_367) {
      _data_k_367 = 0;
    }
    ak0cs_[0] = _data_l_367[_data_k_367++];
  }
  if (__calls[14].calls == 0) {
    _data_k_368 = 0;
    if (_data_k_368 >= _data_n_368) {
      _data_k_368 = 0;
    }
    ak0cs_[1] = _data_l_368[_data_k_368++];
  }
  if (__calls[14].calls == 0) {
    _data_k_369 = 0;
    if (_data_k_369 >= _data_n_369) {
      _data_k_369 = 0;
    }
    ak0cs_[2] = _data_l_369[_data_k_369++];
  }
  if (__calls[14].calls == 0) {
    _data_k_370 = 0;
    if (_data_k_370 >= _data_n_370) {
      _data_k_370 = 0;
    }
    ak0cs_[3] = _data_l_370[_data_k_370++];
  }
  if (__calls[14].calls == 0) {
    _data_k_371 = 0;
    if (_data_k_371 >= _data_n_371) {
      _data_k_371 = 0;
    }
    ak0cs_[4] = _data_l_371[_data_k_371++];
  }
  if (__calls[14].calls == 0) {
    _data_k_372 = 0;
    if (_data_k_372 >= _data_n_372) {
      _data_k_372 = 0;
    }
    ak0cs_[5] = _data_l_372[_data_k_372++];
  }
  if (__calls[14].calls == 0) {
    _data_k_373 = 0;
    if (_data_k_373 >= _data_n_373) {
      _data_k_373 = 0;
    }
    ak0cs_[6] = _data_l_373[_data_k_373++];
  }
  if (__calls[14].calls == 0) {
    _data_k_374 = 0;
    if (_data_k_374 >= _data_n_374) {
      _data_k_374 = 0;
    }
    ak0cs_[7] = _data_l_374[_data_k_374++];
  }
  if (__calls[14].calls == 0) {
    _data_k_375 = 0;
    if (_data_k_375 >= _data_n_375) {
      _data_k_375 = 0;
    }
    ak0cs_[8] = _data_l_375[_data_k_375++];
  }
  if (__calls[14].calls == 0) {
    _data_k_376 = 0;
    if (_data_k_376 >= _data_n_376) {
      _data_k_376 = 0;
    }
    ak0cs_[9] = _data_l_376[_data_k_376++];
  }
  if (__calls[14].calls == 0) {
    _data_k_377 = 0;
    if (_data_k_377 >= _data_n_377) {
      _data_k_377 = 0;
    }
    ak0cs_[10] = _data_l_377[_data_k_377++];
  }
  if (__calls[14].calls == 0) {
    _data_k_378 = 0;
    if (_data_k_378 >= _data_n_378) {
      _data_k_378 = 0;
    }
    ak0cs_[11] = _data_l_378[_data_k_378++];
  }
  if (__calls[14].calls == 0) {
    _data_k_379 = 0;
    if (_data_k_379 >= _data_n_379) {
      _data_k_379 = 0;
    }
    ak0cs_[12] = _data_l_379[_data_k_379++];
  }
  if (__calls[14].calls == 0) {
    _data_k_380 = 0;
    if (_data_k_380 >= _data_n_380) {
      _data_k_380 = 0;
    }
    ak0cs_[13] = _data_l_380[_data_k_380++];
  }
  if (__calls[14].calls == 0) {
    _data_k_381 = 0;
    if (_data_k_381 >= _data_n_381) {
      _data_k_381 = 0;
    }
    ak0cs_[14] = _data_l_381[_data_k_381++];
  }
  if (__calls[14].calls == 0) {
    _data_k_382 = 0;
    if (_data_k_382 >= _data_n_382) {
      _data_k_382 = 0;
    }
    ak0cs_[15] = _data_l_382[_data_k_382++];
  }
  if (__calls[14].calls == 0) {
    _data_k_383 = 0;
    if (_data_k_383 >= _data_n_383) {
      _data_k_383 = 0;
    }
    ak0cs_[16] = _data_l_383[_data_k_383++];
  }
  if (__calls[14].calls == 0) {
    _data_k_384 = 0;
    if (_data_k_384 >= _data_n_384) {
      _data_k_384 = 0;
    }
    ak02cs_[0] = _data_l_384[_data_k_384++];
  }
  if (__calls[14].calls == 0) {
    _data_k_385 = 0;
    if (_data_k_385 >= _data_n_385) {
      _data_k_385 = 0;
    }
    ak02cs_[1] = _data_l_385[_data_k_385++];
  }
  if (__calls[14].calls == 0) {
    _data_k_386 = 0;
    if (_data_k_386 >= _data_n_386) {
      _data_k_386 = 0;
    }
    ak02cs_[2] = _data_l_386[_data_k_386++];
  }
  if (__calls[14].calls == 0) {
    _data_k_387 = 0;
    if (_data_k_387 >= _data_n_387) {
      _data_k_387 = 0;
    }
    ak02cs_[3] = _data_l_387[_data_k_387++];
  }
  if (__calls[14].calls == 0) {
    _data_k_388 = 0;
    if (_data_k_388 >= _data_n_388) {
      _data_k_388 = 0;
    }
    ak02cs_[4] = _data_l_388[_data_k_388++];
  }
  if (__calls[14].calls == 0) {
    _data_k_389 = 0;
    if (_data_k_389 >= _data_n_389) {
      _data_k_389 = 0;
    }
    ak02cs_[5] = _data_l_389[_data_k_389++];
  }
  if (__calls[14].calls == 0) {
    _data_k_390 = 0;
    if (_data_k_390 >= _data_n_390) {
      _data_k_390 = 0;
    }
    ak02cs_[6] = _data_l_390[_data_k_390++];
  }
  if (__calls[14].calls == 0) {
    _data_k_391 = 0;
    if (_data_k_391 >= _data_n_391) {
      _data_k_391 = 0;
    }
    ak02cs_[7] = _data_l_391[_data_k_391++];
  }
  if (__calls[14].calls == 0) {
    _data_k_392 = 0;
    if (_data_k_392 >= _data_n_392) {
      _data_k_392 = 0;
    }
    ak02cs_[8] = _data_l_392[_data_k_392++];
  }
  if (__calls[14].calls == 0) {
    _data_k_393 = 0;
    if (_data_k_393 >= _data_n_393) {
      _data_k_393 = 0;
    }
    ak02cs_[9] = _data_l_393[_data_k_393++];
  }
  if (__calls[14].calls == 0) {
    _data_k_394 = 0;
    if (_data_k_394 >= _data_n_394) {
      _data_k_394 = 0;
    }
    ak02cs_[10] = _data_l_394[_data_k_394++];
  }
  if (__calls[14].calls == 0) {
    _data_k_395 = 0;
    if (_data_k_395 >= _data_n_395) {
      _data_k_395 = 0;
    }
    ak02cs_[11] = _data_l_395[_data_k_395++];
  }
  if (__calls[14].calls == 0) {
    _data_k_396 = 0;
    if (_data_k_396 >= _data_n_396) {
      _data_k_396 = 0;
    }
    ak02cs_[12] = _data_l_396[_data_k_396++];
  }
  if (__calls[14].calls == 0) {
    _data_k_397 = 0;
    if (_data_k_397 >= _data_n_397) {
      _data_k_397 = 0;
    }
    ak02cs_[13] = _data_l_397[_data_k_397++];
  }
  if (__calls[14].calls == 0) {
    _data_k_398 = 0;
    if (_data_k_398 >= _data_n_398) {
      _data_k_398 = 0;
    }
    first_ = _data_l_398[_data_k_398++];
  }
  if (first_) {
    ntk0_ = _inits (bk0cs_, ($0_ = 11, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    ntak0_ = _inits (ak0cs_, ($3_ = 17, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    ntak02_ = _inits (ak02cs_, ($6_ = 14, &$6_), ($8_ = 0.1 * _r1mach (($7_ = 3, &$7_)), &$8_));
    xsml_ = sqrtf (4.0 * _r1mach (($9_ = 3, &$9_)));
  }
  first_ = FALSE;
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_28, _dc_29, ($10_ = 2, &$10_), ($11_ = 2, &$11_));
  }
  if ((*x_) > 2.0) {
    goto _l20;
  }
  y_ = 0.0;
  if ((*x_) > xsml_) {
    y_ = (*x_) * (*x_);
  }
  besk0e_ = expf ((*x_)) * (-logf (0.5 * (*x_)) * _besi0 (x_) - .25 + _csevl (($12_ = .5 * y_ - 1.0, &$12_), bk0cs_, 
  &ntk0_));
  goto _l0;
  _l20:;
  if ((*x_) <= 8.0) {
    besk0e_ = (1.25 + _csevl (($13_ = (16.0 / (*x_) - 5.0) / 3.0, &$13_), ak0cs_, &ntak0_)) / sqrtf ((*x_));
  }
  if ((*x_) > 8.0) {
    besk0e_ = (1.25 + _csevl (($14_ = 16.0 / (*x_) - 1.0, &$14_), ak02cs_, &ntak02_)) / sqrtf ((*x_));
  }
  _l0:;
  __calls[14].calls++;
  return besk0e_;
}

real_4 _besk0 (real_4 _p_ x_)
{
  static int_4 ntk0_;
  static logical_4 first_;
  static real_4 besk0_, bk0cs_[11], xsml_, xmax_, xmaxt_, y_;
  int_4 _data_k_399, _data_k_400, _data_k_401, _data_k_402, _data_k_403, _data_k_404, _data_k_405, _data_k_406, 
  _data_k_407, _data_k_408, _data_k_409, _data_k_410, $0_, $1_, $3_, $4_, $5_;
  real_4 $2_, $6_;
  extern real_4 _r1mach ();
#define _data_n_399 1
  static real_4 _data_l_399[_data_n_399] = {
    -.03532739323390276872e0
  };
#define _data_n_400 1
  static real_4 _data_l_400[_data_n_400] = {
    .3442898999246284869e0
  };
#define _data_n_401 1
  static real_4 _data_l_401[_data_n_401] = {
    .03597993651536150163e0
  };
#define _data_n_402 1
  static real_4 _data_l_402[_data_n_402] = {
    .00126461541144692592e0
  };
#define _data_n_403 1
  static real_4 _data_l_403[_data_n_403] = {
    .00002286212103119451e0
  };
#define _data_n_404 1
  static real_4 _data_l_404[_data_n_404] = {
    .00000025347910790261e0
  };
#define _data_n_405 1
  static real_4 _data_l_405[_data_n_405] = {
    .00000000190451637722e0
  };
#define _data_n_406 1
  static real_4 _data_l_406[_data_n_406] = {
    .00000000001034969525e0
  };
#define _data_n_407 1
  static real_4 _data_l_407[_data_n_407] = {
    .00000000000004259816e0
  };
#define _data_n_408 1
  static real_4 _data_l_408[_data_n_408] = {
    .00000000000000013744e0
  };
#define _data_n_409 1
  static real_4 _data_l_409[_data_n_409] = {
    .00000000000000000035e0
  };
#define _data_n_410 1
  static logical_4 _data_l_410[_data_n_410] = {
    TRUE
  };
  if (__calls[15].calls == 0) {
    _data_k_399 = 0;
    if (_data_k_399 >= _data_n_399) {
      _data_k_399 = 0;
    }
    bk0cs_[0] = _data_l_399[_data_k_399++];
  }
  if (__calls[15].calls == 0) {
    _data_k_400 = 0;
    if (_data_k_400 >= _data_n_400) {
      _data_k_400 = 0;
    }
    bk0cs_[1] = _data_l_400[_data_k_400++];
  }
  if (__calls[15].calls == 0) {
    _data_k_401 = 0;
    if (_data_k_401 >= _data_n_401) {
      _data_k_401 = 0;
    }
    bk0cs_[2] = _data_l_401[_data_k_401++];
  }
  if (__calls[15].calls == 0) {
    _data_k_402 = 0;
    if (_data_k_402 >= _data_n_402) {
      _data_k_402 = 0;
    }
    bk0cs_[3] = _data_l_402[_data_k_402++];
  }
  if (__calls[15].calls == 0) {
    _data_k_403 = 0;
    if (_data_k_403 >= _data_n_403) {
      _data_k_403 = 0;
    }
    bk0cs_[4] = _data_l_403[_data_k_403++];
  }
  if (__calls[15].calls == 0) {
    _data_k_404 = 0;
    if (_data_k_404 >= _data_n_404) {
      _data_k_404 = 0;
    }
    bk0cs_[5] = _data_l_404[_data_k_404++];
  }
  if (__calls[15].calls == 0) {
    _data_k_405 = 0;
    if (_data_k_405 >= _data_n_405) {
      _data_k_405 = 0;
    }
    bk0cs_[6] = _data_l_405[_data_k_405++];
  }
  if (__calls[15].calls == 0) {
    _data_k_406 = 0;
    if (_data_k_406 >= _data_n_406) {
      _data_k_406 = 0;
    }
    bk0cs_[7] = _data_l_406[_data_k_406++];
  }
  if (__calls[15].calls == 0) {
    _data_k_407 = 0;
    if (_data_k_407 >= _data_n_407) {
      _data_k_407 = 0;
    }
    bk0cs_[8] = _data_l_407[_data_k_407++];
  }
  if (__calls[15].calls == 0) {
    _data_k_408 = 0;
    if (_data_k_408 >= _data_n_408) {
      _data_k_408 = 0;
    }
    bk0cs_[9] = _data_l_408[_data_k_408++];
  }
  if (__calls[15].calls == 0) {
    _data_k_409 = 0;
    if (_data_k_409 >= _data_n_409) {
      _data_k_409 = 0;
    }
    bk0cs_[10] = _data_l_409[_data_k_409++];
  }
  if (__calls[15].calls == 0) {
    _data_k_410 = 0;
    if (_data_k_410 >= _data_n_410) {
      _data_k_410 = 0;
    }
    first_ = _data_l_410[_data_k_410++];
  }
  if (first_) {
    ntk0_ = _inits (bk0cs_, ($0_ = 11, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    xsml_ = sqrtf (4.0 * _r1mach (($3_ = 3, &$3_)));
    xmaxt_ = -logf (_r1mach (&_k1));
    xmax_ = xmaxt_ - 0.5 * xmaxt_ * logf (xmaxt_) / (xmaxt_ + 0.5) - 0.01;
  }
  first_ = FALSE;
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_30, _dc_29, ($4_ = 2, &$4_), ($5_ = 2, &$5_));
  }
  if ((*x_) > 2.0) {
    goto _l20;
  }
  y_ = 0.0;
  if ((*x_) > xsml_) {
    y_ = (*x_) * (*x_);
  }
  besk0_ = -logf (0.5 * (*x_)) * _besi0 (x_) - .25 + _csevl (($6_ = .5 * y_ - 1.0, &$6_), bk0cs_, &ntk0_);
  goto _l0;
  _l20:;
  besk0_ = 0.0;
  if ((*x_) > xmax_) {
    (void) _xermsg (_dc_0, _dc_30, _dc_31, &_k1, &_k1);
  }
  if ((*x_) > xmax_) {
    goto _l0;
  }
  besk0_ = expf (-(*x_)) * _besk0e (x_);
  _l0:;
  __calls[15].calls++;
  return besk0_;
}

real_4 _besk1e (real_4 _p_ x_)
{
  static int_4 ntk1_, ntak1_, ntak12_;
  static logical_4 first_;
  static real_4 besk1e_, bk1cs_[11], ak1cs_[17], ak12cs_[14], xmin_, xsml_, y_;
  int_4 _data_k_411, _data_k_412, _data_k_413, _data_k_414, _data_k_415, _data_k_416, _data_k_417, _data_k_418, 
  _data_k_419, _data_k_420, _data_k_421, _data_k_422, _data_k_423, _data_k_424, _data_k_425, _data_k_426, _data_k_427, 
  _data_k_428, _data_k_429, _data_k_430, _data_k_431, _data_k_432, _data_k_433, _data_k_434, _data_k_435, _data_k_436, 
  _data_k_437, _data_k_438, _data_k_439, _data_k_440, _data_k_441, _data_k_442, _data_k_443, _data_k_444, _data_k_445, 
  _data_k_446, _data_k_447, _data_k_448, _data_k_449, _data_k_450, _data_k_451, _data_k_452, _data_k_453, $0_, $1_, $3_, 
  $4_, $6_, $7_, $9_, $10_, $11_, $12_, $13_, $14_;
  real_4 $2_, $5_, $8_, $15_, $16_, $17_;
  extern real_4 _r1mach ();
#define _data_n_411 1
  static real_4 _data_l_411[_data_n_411] = {
    .0253002273389477705e0
  };
#define _data_n_412 1
  static real_4 _data_l_412[_data_n_412] = {
    -.353155960776544876e0
  };
#define _data_n_413 1
  static real_4 _data_l_413[_data_n_413] = {
    -.122611180822657148e0
  };
#define _data_n_414 1
  static real_4 _data_l_414[_data_n_414] = {
    -.0069757238596398643e0
  };
#define _data_n_415 1
  static real_4 _data_l_415[_data_n_415] = {
    -.0001730288957513052e0
  };
#define _data_n_416 1
  static real_4 _data_l_416[_data_n_416] = {
    -.0000024334061415659e0
  };
#define _data_n_417 1
  static real_4 _data_l_417[_data_n_417] = {
    -.0000000221338763073e0
  };
#define _data_n_418 1
  static real_4 _data_l_418[_data_n_418] = {
    -.0000000001411488392e0
  };
#define _data_n_419 1
  static real_4 _data_l_419[_data_n_419] = {
    -.0000000000006666901e0
  };
#define _data_n_420 1
  static real_4 _data_l_420[_data_n_420] = {
    -.0000000000000024274e0
  };
#define _data_n_421 1
  static real_4 _data_l_421[_data_n_421] = {
    -.000000000000000007e0
  };
#define _data_n_422 1
  static real_4 _data_l_422[_data_n_422] = {
    .2744313406973883e0
  };
#define _data_n_423 1
  static real_4 _data_l_423[_data_n_423] = {
    .07571989953199368e0
  };
#define _data_n_424 1
  static real_4 _data_l_424[_data_n_424] = {
    -.0014410515564754e0
  };
#define _data_n_425 1
  static real_4 _data_l_425[_data_n_425] = {
    .00006650116955125e0
  };
#define _data_n_426 1
  static real_4 _data_l_426[_data_n_426] = {
    -.00000436998470952e0
  };
#define _data_n_427 1
  static real_4 _data_l_427[_data_n_427] = {
    .00000035402774997e0
  };
#define _data_n_428 1
  static real_4 _data_l_428[_data_n_428] = {
    -.00000003311163779e0
  };
#define _data_n_429 1
  static real_4 _data_l_429[_data_n_429] = {
    .00000000344597758e0
  };
#define _data_n_430 1
  static real_4 _data_l_430[_data_n_430] = {
    -.00000000038989323e0
  };
#define _data_n_431 1
  static real_4 _data_l_431[_data_n_431] = {
    .00000000004720819e0
  };
#define _data_n_432 1
  static real_4 _data_l_432[_data_n_432] = {
    -.00000000000604783e0
  };
#define _data_n_433 1
  static real_4 _data_l_433[_data_n_433] = {
    .00000000000081284e0
  };
#define _data_n_434 1
  static real_4 _data_l_434[_data_n_434] = {
    -.00000000000011386e0
  };
#define _data_n_435 1
  static real_4 _data_l_435[_data_n_435] = {
    .00000000000001654e0
  };
#define _data_n_436 1
  static real_4 _data_l_436[_data_n_436] = {
    -.00000000000000248e0
  };
#define _data_n_437 1
  static real_4 _data_l_437[_data_n_437] = {
    .00000000000000038e0
  };
#define _data_n_438 1
  static real_4 _data_l_438[_data_n_438] = {
    -.00000000000000006e0
  };
#define _data_n_439 1
  static real_4 _data_l_439[_data_n_439] = {
    .06379308343739001e0
  };
#define _data_n_440 1
  static real_4 _data_l_440[_data_n_440] = {
    .02832887813049721e0
  };
#define _data_n_441 1
  static real_4 _data_l_441[_data_n_441] = {
    -.00024753706739052e0
  };
#define _data_n_442 1
  static real_4 _data_l_442[_data_n_442] = {
    .0000057719724516e0
  };
#define _data_n_443 1
  static real_4 _data_l_443[_data_n_443] = {
    -.00000020689392195e0
  };
#define _data_n_444 1
  static real_4 _data_l_444[_data_n_444] = {
    .00000000973998344e0
  };
#define _data_n_445 1
  static real_4 _data_l_445[_data_n_445] = {
    -.00000000055853361e0
  };
#define _data_n_446 1
  static real_4 _data_l_446[_data_n_446] = {
    .00000000003732996e0
  };
#define _data_n_447 1
  static real_4 _data_l_447[_data_n_447] = {
    -.00000000000282505e0
  };
#define _data_n_448 1
  static real_4 _data_l_448[_data_n_448] = {
    .0000000000002372e0
  };
#define _data_n_449 1
  static real_4 _data_l_449[_data_n_449] = {
    -.00000000000002176e0
  };
#define _data_n_450 1
  static real_4 _data_l_450[_data_n_450] = {
    .00000000000000215e0
  };
#define _data_n_451 1
  static real_4 _data_l_451[_data_n_451] = {
    -.00000000000000022e0
  };
#define _data_n_452 1
  static real_4 _data_l_452[_data_n_452] = {
    .00000000000000002e0
  };
#define _data_n_453 1
  static logical_4 _data_l_453[_data_n_453] = {
    TRUE
  };
  if (__calls[16].calls == 0) {
    _data_k_411 = 0;
    if (_data_k_411 >= _data_n_411) {
      _data_k_411 = 0;
    }
    bk1cs_[0] = _data_l_411[_data_k_411++];
  }
  if (__calls[16].calls == 0) {
    _data_k_412 = 0;
    if (_data_k_412 >= _data_n_412) {
      _data_k_412 = 0;
    }
    bk1cs_[1] = _data_l_412[_data_k_412++];
  }
  if (__calls[16].calls == 0) {
    _data_k_413 = 0;
    if (_data_k_413 >= _data_n_413) {
      _data_k_413 = 0;
    }
    bk1cs_[2] = _data_l_413[_data_k_413++];
  }
  if (__calls[16].calls == 0) {
    _data_k_414 = 0;
    if (_data_k_414 >= _data_n_414) {
      _data_k_414 = 0;
    }
    bk1cs_[3] = _data_l_414[_data_k_414++];
  }
  if (__calls[16].calls == 0) {
    _data_k_415 = 0;
    if (_data_k_415 >= _data_n_415) {
      _data_k_415 = 0;
    }
    bk1cs_[4] = _data_l_415[_data_k_415++];
  }
  if (__calls[16].calls == 0) {
    _data_k_416 = 0;
    if (_data_k_416 >= _data_n_416) {
      _data_k_416 = 0;
    }
    bk1cs_[5] = _data_l_416[_data_k_416++];
  }
  if (__calls[16].calls == 0) {
    _data_k_417 = 0;
    if (_data_k_417 >= _data_n_417) {
      _data_k_417 = 0;
    }
    bk1cs_[6] = _data_l_417[_data_k_417++];
  }
  if (__calls[16].calls == 0) {
    _data_k_418 = 0;
    if (_data_k_418 >= _data_n_418) {
      _data_k_418 = 0;
    }
    bk1cs_[7] = _data_l_418[_data_k_418++];
  }
  if (__calls[16].calls == 0) {
    _data_k_419 = 0;
    if (_data_k_419 >= _data_n_419) {
      _data_k_419 = 0;
    }
    bk1cs_[8] = _data_l_419[_data_k_419++];
  }
  if (__calls[16].calls == 0) {
    _data_k_420 = 0;
    if (_data_k_420 >= _data_n_420) {
      _data_k_420 = 0;
    }
    bk1cs_[9] = _data_l_420[_data_k_420++];
  }
  if (__calls[16].calls == 0) {
    _data_k_421 = 0;
    if (_data_k_421 >= _data_n_421) {
      _data_k_421 = 0;
    }
    bk1cs_[10] = _data_l_421[_data_k_421++];
  }
  if (__calls[16].calls == 0) {
    _data_k_422 = 0;
    if (_data_k_422 >= _data_n_422) {
      _data_k_422 = 0;
    }
    ak1cs_[0] = _data_l_422[_data_k_422++];
  }
  if (__calls[16].calls == 0) {
    _data_k_423 = 0;
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    ak1cs_[1] = _data_l_423[_data_k_423++];
  }
  if (__calls[16].calls == 0) {
    _data_k_424 = 0;
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    ak1cs_[2] = _data_l_424[_data_k_424++];
  }
  if (__calls[16].calls == 0) {
    _data_k_425 = 0;
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    ak1cs_[3] = _data_l_425[_data_k_425++];
  }
  if (__calls[16].calls == 0) {
    _data_k_426 = 0;
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    ak1cs_[4] = _data_l_426[_data_k_426++];
  }
  if (__calls[16].calls == 0) {
    _data_k_427 = 0;
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    ak1cs_[5] = _data_l_427[_data_k_427++];
  }
  if (__calls[16].calls == 0) {
    _data_k_428 = 0;
    if (_data_k_428 >= _data_n_428) {
      _data_k_428 = 0;
    }
    ak1cs_[6] = _data_l_428[_data_k_428++];
  }
  if (__calls[16].calls == 0) {
    _data_k_429 = 0;
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    ak1cs_[7] = _data_l_429[_data_k_429++];
  }
  if (__calls[16].calls == 0) {
    _data_k_430 = 0;
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    ak1cs_[8] = _data_l_430[_data_k_430++];
  }
  if (__calls[16].calls == 0) {
    _data_k_431 = 0;
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    ak1cs_[9] = _data_l_431[_data_k_431++];
  }
  if (__calls[16].calls == 0) {
    _data_k_432 = 0;
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    ak1cs_[10] = _data_l_432[_data_k_432++];
  }
  if (__calls[16].calls == 0) {
    _data_k_433 = 0;
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    ak1cs_[11] = _data_l_433[_data_k_433++];
  }
  if (__calls[16].calls == 0) {
    _data_k_434 = 0;
    if (_data_k_434 >= _data_n_434) {
      _data_k_434 = 0;
    }
    ak1cs_[12] = _data_l_434[_data_k_434++];
  }
  if (__calls[16].calls == 0) {
    _data_k_435 = 0;
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    ak1cs_[13] = _data_l_435[_data_k_435++];
  }
  if (__calls[16].calls == 0) {
    _data_k_436 = 0;
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    ak1cs_[14] = _data_l_436[_data_k_436++];
  }
  if (__calls[16].calls == 0) {
    _data_k_437 = 0;
    if (_data_k_437 >= _data_n_437) {
      _data_k_437 = 0;
    }
    ak1cs_[15] = _data_l_437[_data_k_437++];
  }
  if (__calls[16].calls == 0) {
    _data_k_438 = 0;
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    ak1cs_[16] = _data_l_438[_data_k_438++];
  }
  if (__calls[16].calls == 0) {
    _data_k_439 = 0;
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    ak12cs_[0] = _data_l_439[_data_k_439++];
  }
  if (__calls[16].calls == 0) {
    _data_k_440 = 0;
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    ak12cs_[1] = _data_l_440[_data_k_440++];
  }
  if (__calls[16].calls == 0) {
    _data_k_441 = 0;
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    ak12cs_[2] = _data_l_441[_data_k_441++];
  }
  if (__calls[16].calls == 0) {
    _data_k_442 = 0;
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    ak12cs_[3] = _data_l_442[_data_k_442++];
  }
  if (__calls[16].calls == 0) {
    _data_k_443 = 0;
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    ak12cs_[4] = _data_l_443[_data_k_443++];
  }
  if (__calls[16].calls == 0) {
    _data_k_444 = 0;
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    ak12cs_[5] = _data_l_444[_data_k_444++];
  }
  if (__calls[16].calls == 0) {
    _data_k_445 = 0;
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    ak12cs_[6] = _data_l_445[_data_k_445++];
  }
  if (__calls[16].calls == 0) {
    _data_k_446 = 0;
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    ak12cs_[7] = _data_l_446[_data_k_446++];
  }
  if (__calls[16].calls == 0) {
    _data_k_447 = 0;
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    ak12cs_[8] = _data_l_447[_data_k_447++];
  }
  if (__calls[16].calls == 0) {
    _data_k_448 = 0;
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    ak12cs_[9] = _data_l_448[_data_k_448++];
  }
  if (__calls[16].calls == 0) {
    _data_k_449 = 0;
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    ak12cs_[10] = _data_l_449[_data_k_449++];
  }
  if (__calls[16].calls == 0) {
    _data_k_450 = 0;
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    ak12cs_[11] = _data_l_450[_data_k_450++];
  }
  if (__calls[16].calls == 0) {
    _data_k_451 = 0;
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    ak12cs_[12] = _data_l_451[_data_k_451++];
  }
  if (__calls[16].calls == 0) {
    _data_k_452 = 0;
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    ak12cs_[13] = _data_l_452[_data_k_452++];
  }
  if (__calls[16].calls == 0) {
    _data_k_453 = 0;
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    first_ = _data_l_453[_data_k_453++];
  }
  if (first_) {
    ntk1_ = _inits (bk1cs_, ($0_ = 11, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    ntak1_ = _inits (ak1cs_, ($3_ = 17, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    ntak12_ = _inits (ak12cs_, ($6_ = 14, &$6_), ($8_ = 0.1 * _r1mach (($7_ = 3, &$7_)), &$8_));
    xmin_ = expf (_max (logf (_r1mach (&_k1)), -logf (_r1mach (($9_ = 2, &$9_)))) + .01);
    xsml_ = sqrtf (4.0 * _r1mach (($10_ = 3, &$10_)));
  }
  first_ = FALSE;
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_32, _dc_29, ($11_ = 2, &$11_), ($12_ = 2, &$12_));
  }
  if ((*x_) > 2.0) {
    goto _l20;
  }
  if ((*x_) < xmin_) {
    (void) _xermsg (_dc_0, _dc_32, _dc_33, ($13_ = 3, &$13_), ($14_ = 2, &$14_));
  }
  y_ = 0.0;
  if ((*x_) > xsml_) {
    y_ = (*x_) * (*x_);
  }
  besk1e_ = expf ((*x_)) * (logf (0.5 * (*x_)) * _besi1 (x_) + (0.75 + _csevl (($15_ = .5 * y_ - 1.0, &$15_), bk1cs_, 
  &ntk1_)) / (*x_));
  goto _l0;
  _l20:;
  if ((*x_) <= 8.0) {
    besk1e_ = (1.25 + _csevl (($16_ = (16.0 / (*x_) - 5.0) / 3.0, &$16_), ak1cs_, &ntak1_)) / sqrtf ((*x_));
  }
  if ((*x_) > 8.0) {
    besk1e_ = (1.25 + _csevl (($17_ = 16.0 / (*x_) - 1.0, &$17_), ak12cs_, &ntak12_)) / sqrtf ((*x_));
  }
  _l0:;
  __calls[16].calls++;
  return besk1e_;
}

real_4 _besk1 (real_4 _p_ x_)
{
  static int_4 ntk1_;
  static logical_4 first_;
  static real_4 besk1_, bk1cs_[11], xmin_, xsml_, xmax_, xmaxt_, y_;
  int_4 _data_k_454, _data_k_455, _data_k_456, _data_k_457, _data_k_458, _data_k_459, _data_k_460, _data_k_461, 
  _data_k_462, _data_k_463, _data_k_464, _data_k_465, $0_, $1_, $3_, $4_, $5_, $6_, $7_, $8_;
  real_4 $2_, $9_;
  extern real_4 _r1mach ();
#define _data_n_454 1
  static real_4 _data_l_454[_data_n_454] = {
    .0253002273389477705e0
  };
#define _data_n_455 1
  static real_4 _data_l_455[_data_n_455] = {
    -.353155960776544876e0
  };
#define _data_n_456 1
  static real_4 _data_l_456[_data_n_456] = {
    -.122611180822657148e0
  };
#define _data_n_457 1
  static real_4 _data_l_457[_data_n_457] = {
    -.0069757238596398643e0
  };
#define _data_n_458 1
  static real_4 _data_l_458[_data_n_458] = {
    -.0001730288957513052e0
  };
#define _data_n_459 1
  static real_4 _data_l_459[_data_n_459] = {
    -.0000024334061415659e0
  };
#define _data_n_460 1
  static real_4 _data_l_460[_data_n_460] = {
    -.0000000221338763073e0
  };
#define _data_n_461 1
  static real_4 _data_l_461[_data_n_461] = {
    -.0000000001411488392e0
  };
#define _data_n_462 1
  static real_4 _data_l_462[_data_n_462] = {
    -.0000000000006666901e0
  };
#define _data_n_463 1
  static real_4 _data_l_463[_data_n_463] = {
    -.0000000000000024274e0
  };
#define _data_n_464 1
  static real_4 _data_l_464[_data_n_464] = {
    -.000000000000000007e0
  };
#define _data_n_465 1
  static logical_4 _data_l_465[_data_n_465] = {
    TRUE
  };
  if (__calls[17].calls == 0) {
    _data_k_454 = 0;
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    bk1cs_[0] = _data_l_454[_data_k_454++];
  }
  if (__calls[17].calls == 0) {
    _data_k_455 = 0;
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    bk1cs_[1] = _data_l_455[_data_k_455++];
  }
  if (__calls[17].calls == 0) {
    _data_k_456 = 0;
    if (_data_k_456 >= _data_n_456) {
      _data_k_456 = 0;
    }
    bk1cs_[2] = _data_l_456[_data_k_456++];
  }
  if (__calls[17].calls == 0) {
    _data_k_457 = 0;
    if (_data_k_457 >= _data_n_457) {
      _data_k_457 = 0;
    }
    bk1cs_[3] = _data_l_457[_data_k_457++];
  }
  if (__calls[17].calls == 0) {
    _data_k_458 = 0;
    if (_data_k_458 >= _data_n_458) {
      _data_k_458 = 0;
    }
    bk1cs_[4] = _data_l_458[_data_k_458++];
  }
  if (__calls[17].calls == 0) {
    _data_k_459 = 0;
    if (_data_k_459 >= _data_n_459) {
      _data_k_459 = 0;
    }
    bk1cs_[5] = _data_l_459[_data_k_459++];
  }
  if (__calls[17].calls == 0) {
    _data_k_460 = 0;
    if (_data_k_460 >= _data_n_460) {
      _data_k_460 = 0;
    }
    bk1cs_[6] = _data_l_460[_data_k_460++];
  }
  if (__calls[17].calls == 0) {
    _data_k_461 = 0;
    if (_data_k_461 >= _data_n_461) {
      _data_k_461 = 0;
    }
    bk1cs_[7] = _data_l_461[_data_k_461++];
  }
  if (__calls[17].calls == 0) {
    _data_k_462 = 0;
    if (_data_k_462 >= _data_n_462) {
      _data_k_462 = 0;
    }
    bk1cs_[8] = _data_l_462[_data_k_462++];
  }
  if (__calls[17].calls == 0) {
    _data_k_463 = 0;
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    bk1cs_[9] = _data_l_463[_data_k_463++];
  }
  if (__calls[17].calls == 0) {
    _data_k_464 = 0;
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    bk1cs_[10] = _data_l_464[_data_k_464++];
  }
  if (__calls[17].calls == 0) {
    _data_k_465 = 0;
    if (_data_k_465 >= _data_n_465) {
      _data_k_465 = 0;
    }
    first_ = _data_l_465[_data_k_465++];
  }
  if (first_) {
    ntk1_ = _inits (bk1cs_, ($0_ = 11, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    xmin_ = expf (_max (logf (_r1mach (&_k1)), -logf (_r1mach (($3_ = 2, &$3_)))) + .01);
    xsml_ = sqrtf (4.0 * _r1mach (($4_ = 3, &$4_)));
    xmaxt_ = -logf (_r1mach (&_k1));
    xmax_ = xmaxt_ - 0.5 * xmaxt_ * logf (xmaxt_) / (xmaxt_ + 0.5);
  }
  first_ = FALSE;
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_34, _dc_29, ($5_ = 2, &$5_), ($6_ = 2, &$6_));
  }
  if ((*x_) > 2.0) {
    goto _l20;
  }
  if ((*x_) < xmin_) {
    (void) _xermsg (_dc_0, _dc_34, _dc_33, ($7_ = 3, &$7_), ($8_ = 2, &$8_));
  }
  y_ = 0.0;
  if ((*x_) > xsml_) {
    y_ = (*x_) * (*x_);
  }
  besk1_ = logf (0.5 * (*x_)) * _besi1 (x_) + (0.75 + _csevl (($9_ = .5 * y_ - 1.0, &$9_), bk1cs_, &ntk1_)) / (*x_);
  goto _l0;
  _l20:;
  besk1_ = 0.0;
  if ((*x_) > xmax_) {
    (void) _xermsg (_dc_0, _dc_34, _dc_35, &_k1, &_k1);
  }
  if ((*x_) > xmax_) {
    goto _l0;
  }
  besk1_ = expf (-(*x_)) * _besk1e (x_);
  _l0:;
  __calls[17].calls++;
  return besk1_;
}

int_4 _beskes (real_4 _p_ xnu_, real_4 _p_ x_, int_4 _p_ nin_, real_4 _p_ bke_)
{
  static int_4 n_, iswtch_, i_;
  static real_4 alnbig_, v_, bknu1_, vincr_, direct_, vend_;
  int_4 _data_k_466, $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $10_, $11_;
  real_4 $9_;
  extern real_4 _r1mach ();
#define _data_n_466 1
  static real_4 _data_l_466[_data_n_466] = {
    0.0
  };
  if (__calls[18].calls == 0) {
    _data_k_466 = 0;
    if (_data_k_466 >= _data_n_466) {
      _data_k_466 = 0;
    }
    alnbig_ = _data_l_466[_data_k_466++];
  }
  if (alnbig_ == 0.0) {
    alnbig_ = logf (_r1mach (($0_ = 2, &$0_)));
  }
  v_ = _abs ((*xnu_));
  n_ = _abs ((*nin_));
  if (v_ >= 1.0) {
    (void) _xermsg (_dc_0, _dc_36, _dc_37, ($1_ = 2, &$1_), ($2_ = 2, &$2_));
  }
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_36, _dc_38, ($3_ = 3, &$3_), ($4_ = 2, &$4_));
  }
  if (n_ == 0) {
    (void) _xermsg (_dc_0, _dc_36, _dc_39, ($5_ = 4, &$5_), ($6_ = 2, &$6_));
  }
  (void) _r9knus (&v_, x_, &bke_[0], &bknu1_, &iswtch_);
  if (n_ == 1) {
    goto _l0;
  }
  vincr_ = _sign (1.0, (real_4) ((*nin_)));
  direct_ = vincr_;
  if ((*xnu_) != 0.0) {
    direct_ = vincr_ * _sign (1.0, (*xnu_));
  }
  if (iswtch_ == 1 && direct_ > 0.0) {
    (void) _xermsg (_dc_0, _dc_36, _dc_40, ($7_ = 5, &$7_), ($8_ = 2, &$8_));
  }
  bke_[1] = bknu1_;
  if (direct_ < 0.0) {
    (void) _r9knus (($9_ = _abs ((*xnu_) + vincr_), &$9_), x_, &bke_[1], &bknu1_, &iswtch_);
  }
  if (n_ == 2) {
    goto _l0;
  }
  vend_ = _abs ((*xnu_) + (*nin_)) - 1.0;
  if ((vend_ - 0.5) * logf (vend_) + 0.27 - vend_ * (logf ((*x_)) - .694) > alnbig_) {
    (void) _xermsg (_dc_0, _dc_36, _dc_41, ($10_ = 5, &$10_), ($11_ = 2, &$11_));
  }
  v_ = (*xnu_);
  for (i_ = 3; i_ <= n_; (i_)++) {
    v_ = v_ + vincr_;
    bke_[i_ - 1] = 2.0 * v_ * bke_[i_ - 1 - 1] / (*x_) + bke_[i_ - 2 - 1];
  }
  _l0:;
  __calls[18].calls++;
  return 0;
}

int_4 _besk (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_4 _p_ y_, int_4 _p_ nz_)
{
  static int_4 i_, j_, k_, mz_, nb_, nd_, nn_, nud_, nulim_[2];
  static real_4 cn_, dnu_, elim_, etx_, flgik_, fn_, fnn_, gln_, gnu_, rtz_, s_, s1_, s2_, t_, tm_, trx_, w_[2], xlim_, 
  zn_;
  int_4 _data_k_467, $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  extern int_4 _i1mach ();
  extern real_4 _r1mach ();
#define _data_n_467 2
  static int_4 _data_l_467[_data_n_467] = {
    35,
    70
  };
  if (__calls[19].calls == 0) {
    _data_k_467 = 0;
    if (_data_k_467 >= _data_n_467) {
      _data_k_467 = 0;
    }
    nulim_[0] = _data_l_467[_data_k_467++];
    if (_data_k_467 >= _data_n_467) {
      _data_k_467 = 0;
    }
    nulim_[1] = _data_l_467[_data_k_467++];
  }
  nn_ = -_i1mach (($0_ = 12, &$0_));
  elim_ = 2.303e0 * (nn_ * _r1mach (($1_ = 5, &$1_)) - 3.0e0);
  xlim_ = _r1mach (&_k1) * 1.0e3;
  if ((*kode_) < 1 || (*kode_) > 2) {
    goto _l280;
  }
  if ((*fnu_) < 0.0e0) {
    goto _l290;
  }
  if ((*x_) <= 0.0e0) {
    goto _l300;
  }
  if ((*x_) < xlim_) {
    goto _l320;
  }
  if ((*n_) < 1) {
    goto _l310;
  }
  etx_ = (*kode_) - 1;
  nd_ = (*n_);
  (*nz_) = 0;
  nud_ = (int_4) (_aintd ((*fnu_)));
  dnu_ = (*fnu_) - nud_;
  gnu_ = (*fnu_);
  nn_ = _min (2, nd_);
  fn_ = (*fnu_) + (*n_) - 1;
  fnn_ = fn_;
  if (fn_ < 2.0e0) {
    goto _l150;
  }
  zn_ = (*x_) / fn_;
  if (zn_ == 0.0e0) {
    goto _l320;
  }
  rtz_ = sqrtf (1.0e0 + zn_ * zn_);
  gln_ = logf ((1.0e0 + rtz_) / zn_);
  t_ = rtz_ * (1.0e0 - etx_) + etx_ / (zn_ + rtz_);
  cn_ = -fn_ * (t_ - gln_);
  if (cn_ > elim_) {
    goto _l320;
  }
  if (nud_ < nulim_[nn_ - 1]) {
    goto _l30;
  }
  if (nn_ == 1) {
    goto _l20;
  }
  _l10:;
  fn_ = gnu_;
  zn_ = (*x_) / fn_;
  rtz_ = sqrtf (1.0e0 + zn_ * zn_);
  gln_ = logf ((1.0e0 + rtz_) / zn_);
  t_ = rtz_ * (1.0e0 - etx_) + etx_ / (zn_ + rtz_);
  cn_ = -fn_ * (t_ - gln_);
  _l20:;
  if (cn_ < -elim_) {
    goto _l230;
  }
  flgik_ = -1.0;
  (void) _asyik (x_, &gnu_, kode_, &flgik_, &rtz_, &cn_, &nn_, y_);
  if (nn_ == 1) {
    goto _l240;
  }
  trx_ = 2.0e0 / (*x_);
  tm_ = (gnu_ + gnu_ + 2.0e0) / (*x_);
  goto _l130;
  _l30:;
  if ((*kode_) == 2) {
    goto _l40;
  }
  if ((*x_) > elim_) {
    goto _l230;
  }
  _l40:;
  if (dnu_ != 0.0e0) {
    goto _l80;
  }
  if ((*kode_) == 2) {
    goto _l50;
  }
  s1_ = _besk0 (x_);
  goto _l60;
  _l50:;
  s1_ = _besk0e (x_);
  _l60:;
  if (nud_ == 0 && nd_ == 1) {
    goto _l120;
  }
  if ((*kode_) == 2) {
    goto _l70;
  }
  s2_ = _besk1 (x_);
  goto _l90;
  _l70:;
  s2_ = _besk1e (x_);
  goto _l90;
  _l80:;
  nb_ = 2;
  if (nud_ == 0 && nd_ == 1) {
    nb_ = 1;
  }
  (void) _besknu (x_, &dnu_, kode_, &nb_, w_, nz_);
  s1_ = w_[0];
  if (nb_ == 1) {
    goto _l120;
  }
  s2_ = w_[1];
  _l90:;
  trx_ = 2.0e0 / (*x_);
  tm_ = (dnu_ + dnu_ + 2.0e0) / (*x_);
  if (nd_ == 1) {
    nud_ = nud_ - 1;
  }
  if (nud_ > 0) {
    goto _l100;
  }
  if (nd_ > 1) {
    goto _l120;
  }
  s1_ = s2_;
  goto _l120;
  _l100:;
  for (i_ = 1; i_ <= nud_; (i_)++) {
    s_ = s2_;
    s2_ = tm_ * s2_ + s1_;
    s1_ = s_;
    tm_ = tm_ + trx_;
  }
  if (nd_ == 1) {
    s1_ = s2_;
  }
  _l120:;
  y_[0] = s1_;
  if (nd_ == 1) {
    goto _l240;
  }
  y_[1] = s2_;
  _l130:;
  if (nd_ == 2) {
    goto _l240;
  }
  for (i_ = 3; i_ <= nd_; (i_)++) {
    y_[i_ - 1] = tm_ * y_[i_ - 1 - 1] + y_[i_ - 2 - 1];
    tm_ = tm_ + trx_;
  }
  goto _l240;
  _l150:;
  if ((*kode_) == 2) {
    goto _l160;
  }
  if ((*x_) > elim_) {
    goto _l230;
  }
  _l160:;
  if (fn_ <= 1.0e0) {
    goto _l170;
  }
  if (-fn_ * (logf ((*x_)) - 0.693e0) > elim_) {
    goto _l320;
  }
  _l170:;
  if (dnu_ == 0.0e0) {
    goto _l180;
  }
  (void) _besknu (x_, fnu_, kode_, &nd_, y_, &mz_);
  goto _l240;
  _l180:;
  j_ = nud_;
  if (j_ == 1) {
    goto _l210;
  }
  j_ = j_ + 1;
  if ((*kode_) == 2) {
    goto _l190;
  }
  y_[j_ - 1] = _besk0 (x_);
  goto _l200;
  _l190:;
  y_[j_ - 1] = _besk0e (x_);
  _l200:;
  if (nd_ == 1) {
    goto _l240;
  }
  j_ = j_ + 1;
  _l210:;
  if ((*kode_) == 2) {
    goto _l220;
  }
  y_[j_ - 1] = _besk1 (x_);
  goto _l240;
  _l220:;
  y_[j_ - 1] = _besk1e (x_);
  goto _l240;
  _l230:;
  nud_ = nud_ + 1;
  nd_ = nd_ - 1;
  if (nd_ == 0) {
    goto _l240;
  }
  nn_ = _min (2, nd_);
  gnu_ = gnu_ + 1.0e0;
  if (fnn_ < 2.0e0) {
    goto _l230;
  }
  if (nud_ < nulim_[nn_ - 1]) {
    goto _l230;
  }
  goto _l10;
  _l240:;
  (*nz_) = (*n_) - nd_;
  if ((*nz_) == 0) {
    goto _l0;
  }
  if (nd_ == 0) {
    goto _l260;
  }
  for (i_ = 1; i_ <= nd_; (i_)++) {
    j_ = (*n_) - i_ + 1;
    k_ = nd_ - i_ + 1;
    y_[j_ - 1] = y_[k_ - 1];
  }
  _l260:;
  for (i_ = 1; i_ <= (*nz_); (i_)++) {
    y_[i_ - 1] = 0.0;
  }
  goto _l0;
  _l280:;
  (void) _xermsg (_dc_0, _dc_42, _dc_43, ($2_ = 2, &$2_), &_k1);
  goto _l0;
  _l290:;
  (void) _xermsg (_dc_0, _dc_42, _dc_44, ($3_ = 2, &$3_), &_k1);
  goto _l0;
  _l300:;
  (void) _xermsg (_dc_0, _dc_42, _dc_45, ($4_ = 2, &$4_), &_k1);
  goto _l0;
  _l310:;
  (void) _xermsg (_dc_0, _dc_42, _dc_46, ($5_ = 2, &$5_), &_k1);
  goto _l0;
  _l320:;
  (void) _xermsg (_dc_0, _dc_42, _dc_47, ($6_ = 6, &$6_), &_k1);
  _l0:;
  __calls[19].calls++;
  return 0;
}

int_4 _besknu (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, real_4 _p_ y_, int_4 _p_ nz_)
{
  static int_4 i_, iflag_, inu_, j_, k_, kk_, koded_, nn_;
  static real_4 a_[160], ak_, a1_, a2_, b_[160], bk_, cc_[8], ck_, coef_, cx_, dk_, dnu_, dnu2_, elim_, etest_, ex_, f_, 
  fc_, fhs_, fk_, fks_, flrx_, fmu_, g1_, g2_, p_, pi_, pt_, p1_, p2_, q_, rthpi_, rx_, s_, smu_, sqk_, st_, s1_, s2_, 
  tm_, tol_, t1_, t2_, x1_, x2_;
  int_4 _data_k_468, _data_k_469, _data_k_470, $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  extern int_4 _i1mach ();
  extern real_4 _gamma ();
  extern real_4 _r1mach ();
#define _data_n_468 2
  static real_4 _data_l_468[_data_n_468] = {
    2.0e0,
    17.0e0
  };
#define _data_n_469 2
  static real_4 _data_l_469[_data_n_469] = {
    3.14159265358979e+00,
    1.2533141373155e+00
  };
#define _data_n_470 8
  static real_4 _data_l_470[_data_n_470] = {
    5.77215664901533e-1,
    -4.20026350340952e-2,
    -4.21977345555443e-2,
    7.218943246663e-3,
    -2.152416741149e-4,
    -2.01348547807e-5,
    1.133027232e-6,
    6.116095e-9
  };
  if (__calls[20].calls == 0) {
    _data_k_468 = 0;
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    x1_ = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    x2_ = _data_l_468[_data_k_468++];
  }
  if (__calls[20].calls == 0) {
    _data_k_469 = 0;
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    pi_ = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    rthpi_ = _data_l_469[_data_k_469++];
  }
  if (__calls[20].calls == 0) {
    _data_k_470 = 0;
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    cc_[0] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    cc_[1] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    cc_[2] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    cc_[3] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    cc_[4] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    cc_[5] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    cc_[6] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    cc_[7] = _data_l_470[_data_k_470++];
  }
  kk_ = -_i1mach (($0_ = 12, &$0_));
  elim_ = 2.303e0 * (kk_ * _r1mach (($1_ = 5, &$1_)) - 3.0e0);
  ak_ = _r1mach (($2_ = 3, &$2_));
  tol_ = _max (ak_, 1.0e-15);
  if ((*x_) <= 0.0e0) {
    goto _l350;
  }
  if ((*fnu_) < 0.0e0) {
    goto _l360;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    goto _l370;
  }
  if ((*n_) < 1) {
    goto _l380;
  }
  (*nz_) = 0;
  iflag_ = 0;
  koded_ = (*kode_);
  rx_ = 2.0e0 / (*x_);
  inu_ = (int_4) (_aintd ((*fnu_) + 0.5e0));
  dnu_ = (*fnu_) - inu_;
  if (_abs (dnu_) == 0.5e0) {
    goto _l120;
  }
  dnu2_ = 0.0;
  if (_abs (dnu_) < tol_) {
    goto _l10;
  }
  dnu2_ = dnu_ * dnu_;
  _l10:;
  if ((*x_) > x1_) {
    goto _l120;
  }
  a1_ = 1.0e0 - dnu_;
  a2_ = 1.0e0 + dnu_;
  t1_ = 1.0e0 / _gamma (&a1_);
  t2_ = 1.0e0 / _gamma (&a2_);
  if (_abs (dnu_) > 0.1e0) {
    goto _l40;
  }
  s_ = cc_[0];
  ak_ = 1.0;
  for (k_ = 2; k_ <= 8; (k_)++) {
    ak_ = ak_ * dnu2_;
    tm_ = cc_[k_ - 1] * ak_;
    s_ = s_ + tm_;
    if (_abs (tm_) < tol_) {
      goto _l30;
    }
  }
  _l30:;
  g1_ = -s_;
  goto _l50;
  _l40:;
  g1_ = (t1_ - t2_) / (dnu_ + dnu_);
  _l50:;
  g2_ = (t1_ + t2_) * 0.5e0;
  smu_ = 1.0;
  fc_ = 1.0;
  flrx_ = logf (rx_);
  fmu_ = dnu_ * flrx_;
  if (dnu_ == 0.0e0) {
    goto _l60;
  }
  fc_ = dnu_ * pi_;
  fc_ = fc_ / sinf (fc_);
  if (fmu_ != 0.0e0) {
    smu_ = sinhf (fmu_) / fmu_;
  }
  _l60:;
  f_ = fc_ * (g1_ * coshf (fmu_) + g2_ * flrx_ * smu_);
  fc_ = expf (fmu_);
  p_ = 0.5e0 * fc_ / t2_;
  q_ = 0.5e0 / (fc_ * t1_);
  ak_ = 1.0;
  ck_ = 1.0;
  bk_ = 1.0;
  s1_ = f_;
  s2_ = p_;
  if (inu_ > 0 || (*n_) > 1) {
    goto _l90;
  }
  if ((*x_) < tol_) {
    goto _l80;
  }
  cx_ = (*x_) * (*x_) * 0.25e0;
  _l70:;
  f_ = (ak_ * f_ + p_ + q_) / (bk_ - dnu2_);
  p_ = p_ / (ak_ - dnu_);
  q_ = q_ / (ak_ + dnu_);
  ck_ = ck_ * cx_ / ak_;
  t1_ = ck_ * f_;
  s1_ = s1_ + t1_;
  bk_ = bk_ + ak_ + ak_ + 1.0e0;
  ak_ = ak_ + 1.0e0;
  s_ = _abs (t1_) / (1.0e0 + _abs (s1_));
  if (s_ > tol_) {
    goto _l70;
  }
  _l80:;
  y_[0] = s1_;
  if (koded_ == 1) {
    goto _l0;
  }
  y_[0] = s1_ * expf ((*x_));
  goto _l0;
  _l90:;
  if ((*x_) < tol_) {
    goto _l110;
  }
  cx_ = (*x_) * (*x_) * 0.25e0;
  _l100:;
  f_ = (ak_ * f_ + p_ + q_) / (bk_ - dnu2_);
  p_ = p_ / (ak_ - dnu_);
  q_ = q_ / (ak_ + dnu_);
  ck_ = ck_ * cx_ / ak_;
  t1_ = ck_ * f_;
  s1_ = s1_ + t1_;
  t2_ = ck_ * (p_ - ak_ * f_);
  s2_ = s2_ + t2_;
  bk_ = bk_ + ak_ + ak_ + 1.0e0;
  ak_ = ak_ + 1.0e0;
  s_ = _abs (t1_) / (1.0e0 + _abs (s1_)) + _abs (t2_) / (1.0e0 + _abs (s2_));
  if (s_ > tol_) {
    goto _l100;
  }
  _l110:;
  s2_ = s2_ * rx_;
  if (koded_ == 1) {
    goto _l170;
  }
  f_ = expf ((*x_));
  s1_ = s1_ * f_;
  s2_ = s2_ * f_;
  goto _l170;
  _l120:;
  coef_ = rthpi_ / sqrtf ((*x_));
  if (koded_ == 2) {
    goto _l130;
  }
  if ((*x_) > elim_) {
    goto _l330;
  }
  coef_ = coef_ * expf (-(*x_));
  _l130:;
  if (_abs (dnu_) == 0.5e0) {
    goto _l340;
  }
  if ((*x_) > x2_) {
    goto _l280;
  }
  etest_ = cosf (pi_ * dnu_) / (pi_ * (*x_) * tol_);
  fks_ = 1.0;
  fhs_ = 0.25;
  fk_ = 0.0;
  ck_ = (*x_) + (*x_) + 2.0e0;
  p1_ = 0.0;
  p2_ = 1.0;
  k_ = 0;
  _l140:;
  k_ = k_ + 1;
  fk_ = fk_ + 1.0e0;
  ak_ = (fhs_ - dnu2_) / (fks_ + fk_);
  bk_ = ck_ / (fk_ + 1.0e0);
  pt_ = p2_;
  p2_ = bk_ * p2_ - ak_ * p1_;
  p1_ = pt_;
  a_[k_ - 1] = ak_;
  b_[k_ - 1] = bk_;
  ck_ = ck_ + 2.0e0;
  fks_ = fks_ + fk_ + fk_ + 1.0e0;
  fhs_ = fhs_ + fk_ + fk_;
  if (etest_ > fk_ * p1_) {
    goto _l140;
  }
  kk_ = k_;
  s_ = 1.0;
  p1_ = 0.0;
  p2_ = 1.0;
  for (i_ = 1; i_ <= k_; (i_)++) {
    pt_ = p2_;
    p2_ = (b_[kk_ - 1] * p2_ - p1_) / a_[kk_ - 1];
    p1_ = pt_;
    s_ = s_ + p2_;
    kk_ = kk_ - 1;
  }
  s1_ = coef_ * (p2_ / s_);
  if (inu_ > 0 || (*n_) > 1) {
    goto _l160;
  }
  goto _l200;
  _l160:;
  s2_ = s1_ * ((*x_) + dnu_ + 0.5e0 - p1_ / p2_) / (*x_);
  _l170:;
  ck_ = (dnu_ + dnu_ + 2.0e0) / (*x_);
  if ((*n_) == 1) {
    inu_ = inu_ - 1;
  }
  if (inu_ > 0) {
    goto _l180;
  }
  if ((*n_) > 1) {
    goto _l200;
  }
  s1_ = s2_;
  goto _l200;
  _l180:;
  for (i_ = 1; i_ <= inu_; (i_)++) {
    st_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = st_;
    ck_ = ck_ + rx_;
  }
  if ((*n_) == 1) {
    s1_ = s2_;
  }
  _l200:;
  if (iflag_ == 1) {
    goto _l220;
  }
  y_[0] = s1_;
  if ((*n_) == 1) {
    goto _l0;
  }
  y_[1] = s2_;
  if ((*n_) == 2) {
    goto _l0;
  }
  for (i_ = 3; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = ck_ * y_[i_ - 1 - 1] + y_[i_ - 2 - 1];
    ck_ = ck_ + rx_;
  }
  goto _l0;
  _l220:;
  s_ = -(*x_) + logf (s1_);
  y_[0] = 0.0;
  (*nz_) = 1;
  if (s_ < -elim_) {
    goto _l230;
  }
  y_[0] = expf (s_);
  (*nz_) = 0;
  _l230:;
  if ((*n_) == 1) {
    goto _l0;
  }
  s_ = -(*x_) + logf (s2_);
  y_[1] = 0.0;
  (*nz_) = (*nz_) + 1;
  if (s_ < -elim_) {
    goto _l240;
  }
  (*nz_) = (*nz_) - 1;
  y_[1] = expf (s_);
  _l240:;
  if ((*n_) == 2) {
    goto _l0;
  }
  kk_ = 2;
  if ((*nz_) < 2) {
    goto _l260;
  }
  for (i_ = 3; i_ <= (*n_); (i_)++) {
    kk_ = i_;
    st_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = st_;
    ck_ = ck_ + rx_;
    s_ = -(*x_) + logf (s2_);
    (*nz_) = (*nz_) + 1;
    y_[i_ - 1] = 0.0;
    if (s_ < -elim_) {
      goto _l250;
    }
    y_[i_ - 1] = expf (s_);
    (*nz_) = (*nz_) - 1;
    goto _l260;
    _l250:;
  }
  goto _l0;
  _l260:;
  if (kk_ == (*n_)) {
    goto _l0;
  }
  s2_ = s2_ * ck_ + s1_;
  ck_ = ck_ + rx_;
  kk_ = kk_ + 1;
  y_[kk_ - 1] = expf (-(*x_) + logf (s2_));
  if (kk_ == (*n_)) {
    goto _l0;
  }
  kk_ = kk_ + 1;
  for (i_ = kk_; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = ck_ * y_[i_ - 1 - 1] + y_[i_ - 2 - 1];
    ck_ = ck_ + rx_;
  }
  goto _l0;
  _l280:;
  nn_ = 2;
  if (inu_ == 0 && (*n_) == 1) {
    nn_ = 1;
  }
  dnu2_ = dnu_ + dnu_;
  fmu_ = 0.0;
  if (_abs (dnu2_) < tol_) {
    goto _l290;
  }
  fmu_ = dnu2_ * dnu2_;
  _l290:;
  ex_ = (*x_) * 8.0e0;
  s2_ = 0.0;
  for (k_ = 1; k_ <= nn_; (k_)++) {
    s1_ = s2_;
    s_ = 1.0;
    ak_ = 0.0;
    ck_ = 1.0;
    sqk_ = 1.0;
    dk_ = ex_;
    for (j_ = 1; j_ <= 30; (j_)++) {
      ck_ = ck_ * (fmu_ - sqk_) / dk_;
      s_ = s_ + ck_;
      dk_ = dk_ + ex_;
      ak_ = ak_ + 8.0e0;
      sqk_ = sqk_ + ak_;
      if (_abs (ck_) < tol_) {
        goto _l310;
      }
    }
    _l310:;
    s2_ = s_ * coef_;
    fmu_ = fmu_ + 8.0e0 * dnu_ + 4.0e0;
  }
  if (nn_ > 1) {
    goto _l170;
  }
  s1_ = s2_;
  goto _l200;
  _l330:;
  koded_ = 2;
  iflag_ = 1;
  goto _l120;
  _l340:;
  s1_ = coef_;
  s2_ = coef_;
  goto _l170;
  _l350:;
  (void) _xermsg (_dc_0, _dc_48, _dc_49, ($3_ = 2, &$3_), &_k1);
  goto _l0;
  _l360:;
  (void) _xermsg (_dc_0, _dc_48, _dc_50, ($4_ = 2, &$4_), &_k1);
  goto _l0;
  _l370:;
  (void) _xermsg (_dc_0, _dc_48, _dc_51, ($5_ = 2, &$5_), &_k1);
  goto _l0;
  _l380:;
  (void) _xermsg (_dc_0, _dc_48, _dc_52, ($6_ = 2, &$6_), &_k1);
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _besks (real_4 _p_ xnu_, real_4 _p_ x_, int_4 _p_ nin_, real_4 _p_ bk_)
{
  static int_4 n_, i_;
  static real_4 xmax_, expxi_;
  int_4 _data_k_471, $0_;
  extern real_4 _r1mach ();
#define _data_n_471 1
  static real_4 _data_l_471[_data_n_471] = {
    0.0
  };
  if (__calls[21].calls == 0) {
    _data_k_471 = 0;
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    xmax_ = _data_l_471[_data_k_471++];
  }
  if (xmax_ == 0.0) {
    xmax_ = -logf (_r1mach (&_k1));
  }
  if ((*x_) > xmax_) {
    (void) _xermsg (_dc_0, _dc_53, _dc_54, &_k1, ($0_ = 2, &$0_));
  }
  (void) _beskes (xnu_, x_, nin_, bk_);
  expxi_ = expf (-(*x_));
  n_ = _abs ((*nin_));
  for (i_ = 1; i_ <= n_; (i_)++) {
    bk_[i_ - 1] = expxi_ * bk_[i_ - 1];
  }
  __calls[21].calls++;
  return 0;
}

real_4 _besy0 (real_4 _p_ x_)
{
  static int_4 nty0_, ntm0_, ntth0_;
  static logical_4 first_;
  static real_4 besy0_, by0cs_[13], bm0cs_[21], bth0cs_[24], twodpi_, pi4_, xsml_, xmax_, y_, z_, ampl_, theta_;
  int_4 _data_k_472, _data_k_473, _data_k_474, _data_k_475, _data_k_476, _data_k_477, _data_k_478, _data_k_479, 
  _data_k_480, _data_k_481, _data_k_482, _data_k_483, _data_k_484, _data_k_485, _data_k_486, _data_k_487, _data_k_488, 
  _data_k_489, _data_k_490, _data_k_491, _data_k_492, _data_k_493, _data_k_494, _data_k_495, _data_k_496, _data_k_497, 
  _data_k_498, _data_k_499, _data_k_500, _data_k_501, _data_k_502, _data_k_503, _data_k_504, _data_k_505, _data_k_506, 
  _data_k_507, _data_k_508, _data_k_509, _data_k_510, _data_k_511, _data_k_512, _data_k_513, _data_k_514, _data_k_515, 
  _data_k_516, _data_k_517, _data_k_518, _data_k_519, _data_k_520, _data_k_521, _data_k_522, _data_k_523, _data_k_524, 
  _data_k_525, _data_k_526, _data_k_527, _data_k_528, _data_k_529, _data_k_530, _data_k_531, _data_k_532, $0_, $1_, $3_, 
  $4_, $6_, $7_, $9_, $10_, $11_, $13_, $14_;
  real_4 $2_, $5_, $8_, $12_;
  extern real_4 _r1mach ();
#define _data_n_472 1
  static real_4 _data_l_472[_data_n_472] = {
    -.011277839392865573e0
  };
#define _data_n_473 1
  static real_4 _data_l_473[_data_n_473] = {
    -.12834523756042035e0
  };
#define _data_n_474 1
  static real_4 _data_l_474[_data_n_474] = {
    -.10437884799794249e0
  };
#define _data_n_475 1
  static real_4 _data_l_475[_data_n_475] = {
    .023662749183969695e0
  };
#define _data_n_476 1
  static real_4 _data_l_476[_data_n_476] = {
    -.002090391647700486e0
  };
#define _data_n_477 1
  static real_4 _data_l_477[_data_n_477] = {
    .000103975453939057e0
  };
#define _data_n_478 1
  static real_4 _data_l_478[_data_n_478] = {
    -.000003369747162423e0
  };
#define _data_n_479 1
  static real_4 _data_l_479[_data_n_479] = {
    .000000077293842676e0
  };
#define _data_n_480 1
  static real_4 _data_l_480[_data_n_480] = {
    -.000000001324976772e0
  };
#define _data_n_481 1
  static real_4 _data_l_481[_data_n_481] = {
    .000000000017648232e0
  };
#define _data_n_482 1
  static real_4 _data_l_482[_data_n_482] = {
    -.000000000000188105e0
  };
#define _data_n_483 1
  static real_4 _data_l_483[_data_n_483] = {
    .000000000000001641e0
  };
#define _data_n_484 1
  static real_4 _data_l_484[_data_n_484] = {
    -.000000000000000011e0
  };
#define _data_n_485 1
  static real_4 _data_l_485[_data_n_485] = {
    .09284961637381644e0
  };
#define _data_n_486 1
  static real_4 _data_l_486[_data_n_486] = {
    -.00142987707403484e0
  };
#define _data_n_487 1
  static real_4 _data_l_487[_data_n_487] = {
    .00002830579271257e0
  };
#define _data_n_488 1
  static real_4 _data_l_488[_data_n_488] = {
    -.00000143300611424e0
  };
#define _data_n_489 1
  static real_4 _data_l_489[_data_n_489] = {
    .00000012028628046e0
  };
#define _data_n_490 1
  static real_4 _data_l_490[_data_n_490] = {
    -.00000001397113013e0
  };
#define _data_n_491 1
  static real_4 _data_l_491[_data_n_491] = {
    .00000000204076188e0
  };
#define _data_n_492 1
  static real_4 _data_l_492[_data_n_492] = {
    -.00000000035399669e0
  };
#define _data_n_493 1
  static real_4 _data_l_493[_data_n_493] = {
    .00000000007024759e0
  };
#define _data_n_494 1
  static real_4 _data_l_494[_data_n_494] = {
    -.00000000001554107e0
  };
#define _data_n_495 1
  static real_4 _data_l_495[_data_n_495] = {
    .00000000000376226e0
  };
#define _data_n_496 1
  static real_4 _data_l_496[_data_n_496] = {
    -.00000000000098282e0
  };
#define _data_n_497 1
  static real_4 _data_l_497[_data_n_497] = {
    .00000000000027408e0
  };
#define _data_n_498 1
  static real_4 _data_l_498[_data_n_498] = {
    -.00000000000008091e0
  };
#define _data_n_499 1
  static real_4 _data_l_499[_data_n_499] = {
    .00000000000002511e0
  };
#define _data_n_500 1
  static real_4 _data_l_500[_data_n_500] = {
    -.00000000000000814e0
  };
#define _data_n_501 1
  static real_4 _data_l_501[_data_n_501] = {
    .00000000000000275e0
  };
#define _data_n_502 1
  static real_4 _data_l_502[_data_n_502] = {
    -.00000000000000096e0
  };
#define _data_n_503 1
  static real_4 _data_l_503[_data_n_503] = {
    .00000000000000034e0
  };
#define _data_n_504 1
  static real_4 _data_l_504[_data_n_504] = {
    -.00000000000000012e0
  };
#define _data_n_505 1
  static real_4 _data_l_505[_data_n_505] = {
    .00000000000000004e0
  };
#define _data_n_506 1
  static real_4 _data_l_506[_data_n_506] = {
    -.24639163774300119e0
  };
#define _data_n_507 1
  static real_4 _data_l_507[_data_n_507] = {
    .001737098307508963e0
  };
#define _data_n_508 1
  static real_4 _data_l_508[_data_n_508] = {
    -.000062183633402968e0
  };
#define _data_n_509 1
  static real_4 _data_l_509[_data_n_509] = {
    .000004368050165742e0
  };
#define _data_n_510 1
  static real_4 _data_l_510[_data_n_510] = {
    -.000000456093019869e0
  };
#define _data_n_511 1
  static real_4 _data_l_511[_data_n_511] = {
    .000000062197400101e0
  };
#define _data_n_512 1
  static real_4 _data_l_512[_data_n_512] = {
    -.000000010300442889e0
  };
#define _data_n_513 1
  static real_4 _data_l_513[_data_n_513] = {
    .000000001979526776e0
  };
#define _data_n_514 1
  static real_4 _data_l_514[_data_n_514] = {
    -.000000000428198396e0
  };
#define _data_n_515 1
  static real_4 _data_l_515[_data_n_515] = {
    .00000000010203584e0
  };
#define _data_n_516 1
  static real_4 _data_l_516[_data_n_516] = {
    -.000000000026363898e0
  };
#define _data_n_517 1
  static real_4 _data_l_517[_data_n_517] = {
    .000000000007297935e0
  };
#define _data_n_518 1
  static real_4 _data_l_518[_data_n_518] = {
    -.000000000002144188e0
  };
#define _data_n_519 1
  static real_4 _data_l_519[_data_n_519] = {
    .000000000000663693e0
  };
#define _data_n_520 1
  static real_4 _data_l_520[_data_n_520] = {
    -.000000000000215126e0
  };
#define _data_n_521 1
  static real_4 _data_l_521[_data_n_521] = {
    .000000000000072659e0
  };
#define _data_n_522 1
  static real_4 _data_l_522[_data_n_522] = {
    -.000000000000025465e0
  };
#define _data_n_523 1
  static real_4 _data_l_523[_data_n_523] = {
    .000000000000009229e0
  };
#define _data_n_524 1
  static real_4 _data_l_524[_data_n_524] = {
    -.000000000000003448e0
  };
#define _data_n_525 1
  static real_4 _data_l_525[_data_n_525] = {
    .000000000000001325e0
  };
#define _data_n_526 1
  static real_4 _data_l_526[_data_n_526] = {
    -.000000000000000522e0
  };
#define _data_n_527 1
  static real_4 _data_l_527[_data_n_527] = {
    .00000000000000021e0
  };
#define _data_n_528 1
  static real_4 _data_l_528[_data_n_528] = {
    -.000000000000000087e0
  };
#define _data_n_529 1
  static real_4 _data_l_529[_data_n_529] = {
    .000000000000000036e0
  };
#define _data_n_530 1
  static real_4 _data_l_530[_data_n_530] = {
    0.63661977236758134e0
  };
#define _data_n_531 1
  static real_4 _data_l_531[_data_n_531] = {
    0.78539816339744831e0
  };
#define _data_n_532 1
  static logical_4 _data_l_532[_data_n_532] = {
    TRUE
  };
  if (__calls[22].calls == 0) {
    _data_k_472 = 0;
    if (_data_k_472 >= _data_n_472) {
      _data_k_472 = 0;
    }
    by0cs_[0] = _data_l_472[_data_k_472++];
  }
  if (__calls[22].calls == 0) {
    _data_k_473 = 0;
    if (_data_k_473 >= _data_n_473) {
      _data_k_473 = 0;
    }
    by0cs_[1] = _data_l_473[_data_k_473++];
  }
  if (__calls[22].calls == 0) {
    _data_k_474 = 0;
    if (_data_k_474 >= _data_n_474) {
      _data_k_474 = 0;
    }
    by0cs_[2] = _data_l_474[_data_k_474++];
  }
  if (__calls[22].calls == 0) {
    _data_k_475 = 0;
    if (_data_k_475 >= _data_n_475) {
      _data_k_475 = 0;
    }
    by0cs_[3] = _data_l_475[_data_k_475++];
  }
  if (__calls[22].calls == 0) {
    _data_k_476 = 0;
    if (_data_k_476 >= _data_n_476) {
      _data_k_476 = 0;
    }
    by0cs_[4] = _data_l_476[_data_k_476++];
  }
  if (__calls[22].calls == 0) {
    _data_k_477 = 0;
    if (_data_k_477 >= _data_n_477) {
      _data_k_477 = 0;
    }
    by0cs_[5] = _data_l_477[_data_k_477++];
  }
  if (__calls[22].calls == 0) {
    _data_k_478 = 0;
    if (_data_k_478 >= _data_n_478) {
      _data_k_478 = 0;
    }
    by0cs_[6] = _data_l_478[_data_k_478++];
  }
  if (__calls[22].calls == 0) {
    _data_k_479 = 0;
    if (_data_k_479 >= _data_n_479) {
      _data_k_479 = 0;
    }
    by0cs_[7] = _data_l_479[_data_k_479++];
  }
  if (__calls[22].calls == 0) {
    _data_k_480 = 0;
    if (_data_k_480 >= _data_n_480) {
      _data_k_480 = 0;
    }
    by0cs_[8] = _data_l_480[_data_k_480++];
  }
  if (__calls[22].calls == 0) {
    _data_k_481 = 0;
    if (_data_k_481 >= _data_n_481) {
      _data_k_481 = 0;
    }
    by0cs_[9] = _data_l_481[_data_k_481++];
  }
  if (__calls[22].calls == 0) {
    _data_k_482 = 0;
    if (_data_k_482 >= _data_n_482) {
      _data_k_482 = 0;
    }
    by0cs_[10] = _data_l_482[_data_k_482++];
  }
  if (__calls[22].calls == 0) {
    _data_k_483 = 0;
    if (_data_k_483 >= _data_n_483) {
      _data_k_483 = 0;
    }
    by0cs_[11] = _data_l_483[_data_k_483++];
  }
  if (__calls[22].calls == 0) {
    _data_k_484 = 0;
    if (_data_k_484 >= _data_n_484) {
      _data_k_484 = 0;
    }
    by0cs_[12] = _data_l_484[_data_k_484++];
  }
  if (__calls[22].calls == 0) {
    _data_k_485 = 0;
    if (_data_k_485 >= _data_n_485) {
      _data_k_485 = 0;
    }
    bm0cs_[0] = _data_l_485[_data_k_485++];
  }
  if (__calls[22].calls == 0) {
    _data_k_486 = 0;
    if (_data_k_486 >= _data_n_486) {
      _data_k_486 = 0;
    }
    bm0cs_[1] = _data_l_486[_data_k_486++];
  }
  if (__calls[22].calls == 0) {
    _data_k_487 = 0;
    if (_data_k_487 >= _data_n_487) {
      _data_k_487 = 0;
    }
    bm0cs_[2] = _data_l_487[_data_k_487++];
  }
  if (__calls[22].calls == 0) {
    _data_k_488 = 0;
    if (_data_k_488 >= _data_n_488) {
      _data_k_488 = 0;
    }
    bm0cs_[3] = _data_l_488[_data_k_488++];
  }
  if (__calls[22].calls == 0) {
    _data_k_489 = 0;
    if (_data_k_489 >= _data_n_489) {
      _data_k_489 = 0;
    }
    bm0cs_[4] = _data_l_489[_data_k_489++];
  }
  if (__calls[22].calls == 0) {
    _data_k_490 = 0;
    if (_data_k_490 >= _data_n_490) {
      _data_k_490 = 0;
    }
    bm0cs_[5] = _data_l_490[_data_k_490++];
  }
  if (__calls[22].calls == 0) {
    _data_k_491 = 0;
    if (_data_k_491 >= _data_n_491) {
      _data_k_491 = 0;
    }
    bm0cs_[6] = _data_l_491[_data_k_491++];
  }
  if (__calls[22].calls == 0) {
    _data_k_492 = 0;
    if (_data_k_492 >= _data_n_492) {
      _data_k_492 = 0;
    }
    bm0cs_[7] = _data_l_492[_data_k_492++];
  }
  if (__calls[22].calls == 0) {
    _data_k_493 = 0;
    if (_data_k_493 >= _data_n_493) {
      _data_k_493 = 0;
    }
    bm0cs_[8] = _data_l_493[_data_k_493++];
  }
  if (__calls[22].calls == 0) {
    _data_k_494 = 0;
    if (_data_k_494 >= _data_n_494) {
      _data_k_494 = 0;
    }
    bm0cs_[9] = _data_l_494[_data_k_494++];
  }
  if (__calls[22].calls == 0) {
    _data_k_495 = 0;
    if (_data_k_495 >= _data_n_495) {
      _data_k_495 = 0;
    }
    bm0cs_[10] = _data_l_495[_data_k_495++];
  }
  if (__calls[22].calls == 0) {
    _data_k_496 = 0;
    if (_data_k_496 >= _data_n_496) {
      _data_k_496 = 0;
    }
    bm0cs_[11] = _data_l_496[_data_k_496++];
  }
  if (__calls[22].calls == 0) {
    _data_k_497 = 0;
    if (_data_k_497 >= _data_n_497) {
      _data_k_497 = 0;
    }
    bm0cs_[12] = _data_l_497[_data_k_497++];
  }
  if (__calls[22].calls == 0) {
    _data_k_498 = 0;
    if (_data_k_498 >= _data_n_498) {
      _data_k_498 = 0;
    }
    bm0cs_[13] = _data_l_498[_data_k_498++];
  }
  if (__calls[22].calls == 0) {
    _data_k_499 = 0;
    if (_data_k_499 >= _data_n_499) {
      _data_k_499 = 0;
    }
    bm0cs_[14] = _data_l_499[_data_k_499++];
  }
  if (__calls[22].calls == 0) {
    _data_k_500 = 0;
    if (_data_k_500 >= _data_n_500) {
      _data_k_500 = 0;
    }
    bm0cs_[15] = _data_l_500[_data_k_500++];
  }
  if (__calls[22].calls == 0) {
    _data_k_501 = 0;
    if (_data_k_501 >= _data_n_501) {
      _data_k_501 = 0;
    }
    bm0cs_[16] = _data_l_501[_data_k_501++];
  }
  if (__calls[22].calls == 0) {
    _data_k_502 = 0;
    if (_data_k_502 >= _data_n_502) {
      _data_k_502 = 0;
    }
    bm0cs_[17] = _data_l_502[_data_k_502++];
  }
  if (__calls[22].calls == 0) {
    _data_k_503 = 0;
    if (_data_k_503 >= _data_n_503) {
      _data_k_503 = 0;
    }
    bm0cs_[18] = _data_l_503[_data_k_503++];
  }
  if (__calls[22].calls == 0) {
    _data_k_504 = 0;
    if (_data_k_504 >= _data_n_504) {
      _data_k_504 = 0;
    }
    bm0cs_[19] = _data_l_504[_data_k_504++];
  }
  if (__calls[22].calls == 0) {
    _data_k_505 = 0;
    if (_data_k_505 >= _data_n_505) {
      _data_k_505 = 0;
    }
    bm0cs_[20] = _data_l_505[_data_k_505++];
  }
  if (__calls[22].calls == 0) {
    _data_k_506 = 0;
    if (_data_k_506 >= _data_n_506) {
      _data_k_506 = 0;
    }
    bth0cs_[0] = _data_l_506[_data_k_506++];
  }
  if (__calls[22].calls == 0) {
    _data_k_507 = 0;
    if (_data_k_507 >= _data_n_507) {
      _data_k_507 = 0;
    }
    bth0cs_[1] = _data_l_507[_data_k_507++];
  }
  if (__calls[22].calls == 0) {
    _data_k_508 = 0;
    if (_data_k_508 >= _data_n_508) {
      _data_k_508 = 0;
    }
    bth0cs_[2] = _data_l_508[_data_k_508++];
  }
  if (__calls[22].calls == 0) {
    _data_k_509 = 0;
    if (_data_k_509 >= _data_n_509) {
      _data_k_509 = 0;
    }
    bth0cs_[3] = _data_l_509[_data_k_509++];
  }
  if (__calls[22].calls == 0) {
    _data_k_510 = 0;
    if (_data_k_510 >= _data_n_510) {
      _data_k_510 = 0;
    }
    bth0cs_[4] = _data_l_510[_data_k_510++];
  }
  if (__calls[22].calls == 0) {
    _data_k_511 = 0;
    if (_data_k_511 >= _data_n_511) {
      _data_k_511 = 0;
    }
    bth0cs_[5] = _data_l_511[_data_k_511++];
  }
  if (__calls[22].calls == 0) {
    _data_k_512 = 0;
    if (_data_k_512 >= _data_n_512) {
      _data_k_512 = 0;
    }
    bth0cs_[6] = _data_l_512[_data_k_512++];
  }
  if (__calls[22].calls == 0) {
    _data_k_513 = 0;
    if (_data_k_513 >= _data_n_513) {
      _data_k_513 = 0;
    }
    bth0cs_[7] = _data_l_513[_data_k_513++];
  }
  if (__calls[22].calls == 0) {
    _data_k_514 = 0;
    if (_data_k_514 >= _data_n_514) {
      _data_k_514 = 0;
    }
    bth0cs_[8] = _data_l_514[_data_k_514++];
  }
  if (__calls[22].calls == 0) {
    _data_k_515 = 0;
    if (_data_k_515 >= _data_n_515) {
      _data_k_515 = 0;
    }
    bth0cs_[9] = _data_l_515[_data_k_515++];
  }
  if (__calls[22].calls == 0) {
    _data_k_516 = 0;
    if (_data_k_516 >= _data_n_516) {
      _data_k_516 = 0;
    }
    bth0cs_[10] = _data_l_516[_data_k_516++];
  }
  if (__calls[22].calls == 0) {
    _data_k_517 = 0;
    if (_data_k_517 >= _data_n_517) {
      _data_k_517 = 0;
    }
    bth0cs_[11] = _data_l_517[_data_k_517++];
  }
  if (__calls[22].calls == 0) {
    _data_k_518 = 0;
    if (_data_k_518 >= _data_n_518) {
      _data_k_518 = 0;
    }
    bth0cs_[12] = _data_l_518[_data_k_518++];
  }
  if (__calls[22].calls == 0) {
    _data_k_519 = 0;
    if (_data_k_519 >= _data_n_519) {
      _data_k_519 = 0;
    }
    bth0cs_[13] = _data_l_519[_data_k_519++];
  }
  if (__calls[22].calls == 0) {
    _data_k_520 = 0;
    if (_data_k_520 >= _data_n_520) {
      _data_k_520 = 0;
    }
    bth0cs_[14] = _data_l_520[_data_k_520++];
  }
  if (__calls[22].calls == 0) {
    _data_k_521 = 0;
    if (_data_k_521 >= _data_n_521) {
      _data_k_521 = 0;
    }
    bth0cs_[15] = _data_l_521[_data_k_521++];
  }
  if (__calls[22].calls == 0) {
    _data_k_522 = 0;
    if (_data_k_522 >= _data_n_522) {
      _data_k_522 = 0;
    }
    bth0cs_[16] = _data_l_522[_data_k_522++];
  }
  if (__calls[22].calls == 0) {
    _data_k_523 = 0;
    if (_data_k_523 >= _data_n_523) {
      _data_k_523 = 0;
    }
    bth0cs_[17] = _data_l_523[_data_k_523++];
  }
  if (__calls[22].calls == 0) {
    _data_k_524 = 0;
    if (_data_k_524 >= _data_n_524) {
      _data_k_524 = 0;
    }
    bth0cs_[18] = _data_l_524[_data_k_524++];
  }
  if (__calls[22].calls == 0) {
    _data_k_525 = 0;
    if (_data_k_525 >= _data_n_525) {
      _data_k_525 = 0;
    }
    bth0cs_[19] = _data_l_525[_data_k_525++];
  }
  if (__calls[22].calls == 0) {
    _data_k_526 = 0;
    if (_data_k_526 >= _data_n_526) {
      _data_k_526 = 0;
    }
    bth0cs_[20] = _data_l_526[_data_k_526++];
  }
  if (__calls[22].calls == 0) {
    _data_k_527 = 0;
    if (_data_k_527 >= _data_n_527) {
      _data_k_527 = 0;
    }
    bth0cs_[21] = _data_l_527[_data_k_527++];
  }
  if (__calls[22].calls == 0) {
    _data_k_528 = 0;
    if (_data_k_528 >= _data_n_528) {
      _data_k_528 = 0;
    }
    bth0cs_[22] = _data_l_528[_data_k_528++];
  }
  if (__calls[22].calls == 0) {
    _data_k_529 = 0;
    if (_data_k_529 >= _data_n_529) {
      _data_k_529 = 0;
    }
    bth0cs_[23] = _data_l_529[_data_k_529++];
  }
  if (__calls[22].calls == 0) {
    _data_k_530 = 0;
    if (_data_k_530 >= _data_n_530) {
      _data_k_530 = 0;
    }
    twodpi_ = _data_l_530[_data_k_530++];
  }
  if (__calls[22].calls == 0) {
    _data_k_531 = 0;
    if (_data_k_531 >= _data_n_531) {
      _data_k_531 = 0;
    }
    pi4_ = _data_l_531[_data_k_531++];
  }
  if (__calls[22].calls == 0) {
    _data_k_532 = 0;
    if (_data_k_532 >= _data_n_532) {
      _data_k_532 = 0;
    }
    first_ = _data_l_532[_data_k_532++];
  }
  if (first_) {
    nty0_ = _inits (by0cs_, ($0_ = 13, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    ntm0_ = _inits (bm0cs_, ($3_ = 21, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    ntth0_ = _inits (bth0cs_, ($6_ = 24, &$6_), ($8_ = 0.1 * _r1mach (($7_ = 3, &$7_)), &$8_));
    xsml_ = sqrtf (4.0 * _r1mach (($9_ = 3, &$9_)));
    xmax_ = 1.0 / _r1mach (($10_ = 4, &$10_));
  }
  first_ = FALSE;
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_55, _dc_29, &_k1, ($11_ = 2, &$11_));
  }
  if ((*x_) > 4.0) {
    goto _l20;
  }
  y_ = 0.0;
  if ((*x_) > xsml_) {
    y_ = (*x_) * (*x_);
  }
  besy0_ = twodpi_ * logf (0.5 * (*x_)) * _besj0 (x_) + .375 + _csevl (($12_ = .125 * y_ - 1.0, &$12_), by0cs_, &nty0_);
  goto _l0;
  _l20:;
  if ((*x_) > xmax_) {
    (void) _xermsg (_dc_0, _dc_55, _dc_56, ($13_ = 2, &$13_), ($14_ = 2, &$14_));
  }
  z_ = 32.0 / ((*x_) * (*x_)) - 1.0;
  ampl_ = (0.75 + _csevl (&z_, bm0cs_, &ntm0_)) / sqrtf ((*x_));
  theta_ = (*x_) - pi4_ + _csevl (&z_, bth0cs_, &ntth0_) / (*x_);
  besy0_ = ampl_ * sinf (theta_);
  _l0:;
  __calls[22].calls++;
  return besy0_;
}

real_4 _besy1 (real_4 _p_ x_)
{
  static int_4 nty1_, ntm1_, ntth1_;
  static logical_4 first_;
  static real_4 besy1_, by1cs_[14], bm1cs_[21], bth1cs_[24], twodpi_, pi4_, xmin_, xsml_, xmax_, y_, z_, ampl_, theta_;
  int_4 _data_k_533, _data_k_534, _data_k_535, _data_k_536, _data_k_537, _data_k_538, _data_k_539, _data_k_540, 
  _data_k_541, _data_k_542, _data_k_543, _data_k_544, _data_k_545, _data_k_546, _data_k_547, _data_k_548, _data_k_549, 
  _data_k_550, _data_k_551, _data_k_552, _data_k_553, _data_k_554, _data_k_555, _data_k_556, _data_k_557, _data_k_558, 
  _data_k_559, _data_k_560, _data_k_561, _data_k_562, _data_k_563, _data_k_564, _data_k_565, _data_k_566, _data_k_567, 
  _data_k_568, _data_k_569, _data_k_570, _data_k_571, _data_k_572, _data_k_573, _data_k_574, _data_k_575, _data_k_576, 
  _data_k_577, _data_k_578, _data_k_579, _data_k_580, _data_k_581, _data_k_582, _data_k_583, _data_k_584, _data_k_585, 
  _data_k_586, _data_k_587, _data_k_588, _data_k_589, _data_k_590, _data_k_591, _data_k_592, _data_k_593, _data_k_594, 
  $0_, $1_, $3_, $4_, $6_, $7_, $9_, $10_, $11_, $12_, $13_, $14_, $16_, $17_;
  real_4 $2_, $5_, $8_, $15_;
  extern real_4 _r1mach ();
#define _data_n_533 1
  static real_4 _data_l_533[_data_n_533] = {
    .03208047100611908629e0
  };
#define _data_n_534 1
  static real_4 _data_l_534[_data_n_534] = {
    1.26270789743350045e0
  };
#define _data_n_535 1
  static real_4 _data_l_535[_data_n_535] = {
    .006499961899923175e0
  };
#define _data_n_536 1
  static real_4 _data_l_536[_data_n_536] = {
    -.08936164528860504117e0
  };
#define _data_n_537 1
  static real_4 _data_l_537[_data_n_537] = {
    .01325088122175709545e0
  };
#define _data_n_538 1
  static real_4 _data_l_538[_data_n_538] = {
    -.00089790591196483523e0
  };
#define _data_n_539 1
  static real_4 _data_l_539[_data_n_539] = {
    .00003647361487958306e0
  };
#define _data_n_540 1
  static real_4 _data_l_540[_data_n_540] = {
    -.000001001374381666e0
  };
#define _data_n_541 1
  static real_4 _data_l_541[_data_n_541] = {
    .0000000199453965739e0
  };
#define _data_n_542 1
  static real_4 _data_l_542[_data_n_542] = {
    -.00000000030230656018e0
  };
#define _data_n_543 1
  static real_4 _data_l_543[_data_n_543] = {
    .00000000000360987815e0
  };
#define _data_n_544 1
  static real_4 _data_l_544[_data_n_544] = {
    -.00000000000003487488e0
  };
#define _data_n_545 1
  static real_4 _data_l_545[_data_n_545] = {
    .00000000000000027838e0
  };
#define _data_n_546 1
  static real_4 _data_l_546[_data_n_546] = {
    -.00000000000000000186e0
  };
#define _data_n_547 1
  static real_4 _data_l_547[_data_n_547] = {
    .1047362510931285e0
  };
#define _data_n_548 1
  static real_4 _data_l_548[_data_n_548] = {
    .00442443893702345e0
  };
#define _data_n_549 1
  static real_4 _data_l_549[_data_n_549] = {
    -.00005661639504035e0
  };
#define _data_n_550 1
  static real_4 _data_l_550[_data_n_550] = {
    .00000231349417339e0
  };
#define _data_n_551 1
  static real_4 _data_l_551[_data_n_551] = {
    -.00000017377182007e0
  };
#define _data_n_552 1
  static real_4 _data_l_552[_data_n_552] = {
    .0000000189320993e0
  };
#define _data_n_553 1
  static real_4 _data_l_553[_data_n_553] = {
    -.00000000265416023e0
  };
#define _data_n_554 1
  static real_4 _data_l_554[_data_n_554] = {
    .00000000044740209e0
  };
#define _data_n_555 1
  static real_4 _data_l_555[_data_n_555] = {
    -.00000000008691795e0
  };
#define _data_n_556 1
  static real_4 _data_l_556[_data_n_556] = {
    .00000000001891492e0
  };
#define _data_n_557 1
  static real_4 _data_l_557[_data_n_557] = {
    -.00000000000451884e0
  };
#define _data_n_558 1
  static real_4 _data_l_558[_data_n_558] = {
    .00000000000116765e0
  };
#define _data_n_559 1
  static real_4 _data_l_559[_data_n_559] = {
    -.00000000000032265e0
  };
#define _data_n_560 1
  static real_4 _data_l_560[_data_n_560] = {
    .0000000000000945e0
  };
#define _data_n_561 1
  static real_4 _data_l_561[_data_n_561] = {
    -.00000000000002913e0
  };
#define _data_n_562 1
  static real_4 _data_l_562[_data_n_562] = {
    .00000000000000939e0
  };
#define _data_n_563 1
  static real_4 _data_l_563[_data_n_563] = {
    -.00000000000000315e0
  };
#define _data_n_564 1
  static real_4 _data_l_564[_data_n_564] = {
    .00000000000000109e0
  };
#define _data_n_565 1
  static real_4 _data_l_565[_data_n_565] = {
    -.00000000000000039e0
  };
#define _data_n_566 1
  static real_4 _data_l_566[_data_n_566] = {
    .00000000000000014e0
  };
#define _data_n_567 1
  static real_4 _data_l_567[_data_n_567] = {
    -.00000000000000005e0
  };
#define _data_n_568 1
  static real_4 _data_l_568[_data_n_568] = {
    .7406014102631385e0
  };
#define _data_n_569 1
  static real_4 _data_l_569[_data_n_569] = {
    -.00457175565963769e0
  };
#define _data_n_570 1
  static real_4 _data_l_570[_data_n_570] = {
    .000119818510964326e0
  };
#define _data_n_571 1
  static real_4 _data_l_571[_data_n_571] = {
    -.000006964561891648e0
  };
#define _data_n_572 1
  static real_4 _data_l_572[_data_n_572] = {
    .000000655495621447e0
  };
#define _data_n_573 1
  static real_4 _data_l_573[_data_n_573] = {
    -.000000084066228945e0
  };
#define _data_n_574 1
  static real_4 _data_l_574[_data_n_574] = {
    .000000013376886564e0
  };
#define _data_n_575 1
  static real_4 _data_l_575[_data_n_575] = {
    -.000000002499565654e0
  };
#define _data_n_576 1
  static real_4 _data_l_576[_data_n_576] = {
    .0000000005294951e0
  };
#define _data_n_577 1
  static real_4 _data_l_577[_data_n_577] = {
    -.000000000124135944e0
  };
#define _data_n_578 1
  static real_4 _data_l_578[_data_n_578] = {
    .000000000031656485e0
  };
#define _data_n_579 1
  static real_4 _data_l_579[_data_n_579] = {
    -.00000000000866864e0
  };
#define _data_n_580 1
  static real_4 _data_l_580[_data_n_580] = {
    .000000000002523758e0
  };
#define _data_n_581 1
  static real_4 _data_l_581[_data_n_581] = {
    -.000000000000775085e0
  };
#define _data_n_582 1
  static real_4 _data_l_582[_data_n_582] = {
    .000000000000249527e0
  };
#define _data_n_583 1
  static real_4 _data_l_583[_data_n_583] = {
    -.000000000000083773e0
  };
#define _data_n_584 1
  static real_4 _data_l_584[_data_n_584] = {
    .000000000000029205e0
  };
#define _data_n_585 1
  static real_4 _data_l_585[_data_n_585] = {
    -.000000000000010534e0
  };
#define _data_n_586 1
  static real_4 _data_l_586[_data_n_586] = {
    .000000000000003919e0
  };
#define _data_n_587 1
  static real_4 _data_l_587[_data_n_587] = {
    -.0000000000000015e0
  };
#define _data_n_588 1
  static real_4 _data_l_588[_data_n_588] = {
    .000000000000000589e0
  };
#define _data_n_589 1
  static real_4 _data_l_589[_data_n_589] = {
    -.000000000000000237e0
  };
#define _data_n_590 1
  static real_4 _data_l_590[_data_n_590] = {
    .000000000000000097e0
  };
#define _data_n_591 1
  static real_4 _data_l_591[_data_n_591] = {
    -.00000000000000004e0
  };
#define _data_n_592 1
  static real_4 _data_l_592[_data_n_592] = {
    0.63661977236758134e0
  };
#define _data_n_593 1
  static real_4 _data_l_593[_data_n_593] = {
    0.78539816339744831e0
  };
#define _data_n_594 1
  static logical_4 _data_l_594[_data_n_594] = {
    TRUE
  };
  if (__calls[23].calls == 0) {
    _data_k_533 = 0;
    if (_data_k_533 >= _data_n_533) {
      _data_k_533 = 0;
    }
    by1cs_[0] = _data_l_533[_data_k_533++];
  }
  if (__calls[23].calls == 0) {
    _data_k_534 = 0;
    if (_data_k_534 >= _data_n_534) {
      _data_k_534 = 0;
    }
    by1cs_[1] = _data_l_534[_data_k_534++];
  }
  if (__calls[23].calls == 0) {
    _data_k_535 = 0;
    if (_data_k_535 >= _data_n_535) {
      _data_k_535 = 0;
    }
    by1cs_[2] = _data_l_535[_data_k_535++];
  }
  if (__calls[23].calls == 0) {
    _data_k_536 = 0;
    if (_data_k_536 >= _data_n_536) {
      _data_k_536 = 0;
    }
    by1cs_[3] = _data_l_536[_data_k_536++];
  }
  if (__calls[23].calls == 0) {
    _data_k_537 = 0;
    if (_data_k_537 >= _data_n_537) {
      _data_k_537 = 0;
    }
    by1cs_[4] = _data_l_537[_data_k_537++];
  }
  if (__calls[23].calls == 0) {
    _data_k_538 = 0;
    if (_data_k_538 >= _data_n_538) {
      _data_k_538 = 0;
    }
    by1cs_[5] = _data_l_538[_data_k_538++];
  }
  if (__calls[23].calls == 0) {
    _data_k_539 = 0;
    if (_data_k_539 >= _data_n_539) {
      _data_k_539 = 0;
    }
    by1cs_[6] = _data_l_539[_data_k_539++];
  }
  if (__calls[23].calls == 0) {
    _data_k_540 = 0;
    if (_data_k_540 >= _data_n_540) {
      _data_k_540 = 0;
    }
    by1cs_[7] = _data_l_540[_data_k_540++];
  }
  if (__calls[23].calls == 0) {
    _data_k_541 = 0;
    if (_data_k_541 >= _data_n_541) {
      _data_k_541 = 0;
    }
    by1cs_[8] = _data_l_541[_data_k_541++];
  }
  if (__calls[23].calls == 0) {
    _data_k_542 = 0;
    if (_data_k_542 >= _data_n_542) {
      _data_k_542 = 0;
    }
    by1cs_[9] = _data_l_542[_data_k_542++];
  }
  if (__calls[23].calls == 0) {
    _data_k_543 = 0;
    if (_data_k_543 >= _data_n_543) {
      _data_k_543 = 0;
    }
    by1cs_[10] = _data_l_543[_data_k_543++];
  }
  if (__calls[23].calls == 0) {
    _data_k_544 = 0;
    if (_data_k_544 >= _data_n_544) {
      _data_k_544 = 0;
    }
    by1cs_[11] = _data_l_544[_data_k_544++];
  }
  if (__calls[23].calls == 0) {
    _data_k_545 = 0;
    if (_data_k_545 >= _data_n_545) {
      _data_k_545 = 0;
    }
    by1cs_[12] = _data_l_545[_data_k_545++];
  }
  if (__calls[23].calls == 0) {
    _data_k_546 = 0;
    if (_data_k_546 >= _data_n_546) {
      _data_k_546 = 0;
    }
    by1cs_[13] = _data_l_546[_data_k_546++];
  }
  if (__calls[23].calls == 0) {
    _data_k_547 = 0;
    if (_data_k_547 >= _data_n_547) {
      _data_k_547 = 0;
    }
    bm1cs_[0] = _data_l_547[_data_k_547++];
  }
  if (__calls[23].calls == 0) {
    _data_k_548 = 0;
    if (_data_k_548 >= _data_n_548) {
      _data_k_548 = 0;
    }
    bm1cs_[1] = _data_l_548[_data_k_548++];
  }
  if (__calls[23].calls == 0) {
    _data_k_549 = 0;
    if (_data_k_549 >= _data_n_549) {
      _data_k_549 = 0;
    }
    bm1cs_[2] = _data_l_549[_data_k_549++];
  }
  if (__calls[23].calls == 0) {
    _data_k_550 = 0;
    if (_data_k_550 >= _data_n_550) {
      _data_k_550 = 0;
    }
    bm1cs_[3] = _data_l_550[_data_k_550++];
  }
  if (__calls[23].calls == 0) {
    _data_k_551 = 0;
    if (_data_k_551 >= _data_n_551) {
      _data_k_551 = 0;
    }
    bm1cs_[4] = _data_l_551[_data_k_551++];
  }
  if (__calls[23].calls == 0) {
    _data_k_552 = 0;
    if (_data_k_552 >= _data_n_552) {
      _data_k_552 = 0;
    }
    bm1cs_[5] = _data_l_552[_data_k_552++];
  }
  if (__calls[23].calls == 0) {
    _data_k_553 = 0;
    if (_data_k_553 >= _data_n_553) {
      _data_k_553 = 0;
    }
    bm1cs_[6] = _data_l_553[_data_k_553++];
  }
  if (__calls[23].calls == 0) {
    _data_k_554 = 0;
    if (_data_k_554 >= _data_n_554) {
      _data_k_554 = 0;
    }
    bm1cs_[7] = _data_l_554[_data_k_554++];
  }
  if (__calls[23].calls == 0) {
    _data_k_555 = 0;
    if (_data_k_555 >= _data_n_555) {
      _data_k_555 = 0;
    }
    bm1cs_[8] = _data_l_555[_data_k_555++];
  }
  if (__calls[23].calls == 0) {
    _data_k_556 = 0;
    if (_data_k_556 >= _data_n_556) {
      _data_k_556 = 0;
    }
    bm1cs_[9] = _data_l_556[_data_k_556++];
  }
  if (__calls[23].calls == 0) {
    _data_k_557 = 0;
    if (_data_k_557 >= _data_n_557) {
      _data_k_557 = 0;
    }
    bm1cs_[10] = _data_l_557[_data_k_557++];
  }
  if (__calls[23].calls == 0) {
    _data_k_558 = 0;
    if (_data_k_558 >= _data_n_558) {
      _data_k_558 = 0;
    }
    bm1cs_[11] = _data_l_558[_data_k_558++];
  }
  if (__calls[23].calls == 0) {
    _data_k_559 = 0;
    if (_data_k_559 >= _data_n_559) {
      _data_k_559 = 0;
    }
    bm1cs_[12] = _data_l_559[_data_k_559++];
  }
  if (__calls[23].calls == 0) {
    _data_k_560 = 0;
    if (_data_k_560 >= _data_n_560) {
      _data_k_560 = 0;
    }
    bm1cs_[13] = _data_l_560[_data_k_560++];
  }
  if (__calls[23].calls == 0) {
    _data_k_561 = 0;
    if (_data_k_561 >= _data_n_561) {
      _data_k_561 = 0;
    }
    bm1cs_[14] = _data_l_561[_data_k_561++];
  }
  if (__calls[23].calls == 0) {
    _data_k_562 = 0;
    if (_data_k_562 >= _data_n_562) {
      _data_k_562 = 0;
    }
    bm1cs_[15] = _data_l_562[_data_k_562++];
  }
  if (__calls[23].calls == 0) {
    _data_k_563 = 0;
    if (_data_k_563 >= _data_n_563) {
      _data_k_563 = 0;
    }
    bm1cs_[16] = _data_l_563[_data_k_563++];
  }
  if (__calls[23].calls == 0) {
    _data_k_564 = 0;
    if (_data_k_564 >= _data_n_564) {
      _data_k_564 = 0;
    }
    bm1cs_[17] = _data_l_564[_data_k_564++];
  }
  if (__calls[23].calls == 0) {
    _data_k_565 = 0;
    if (_data_k_565 >= _data_n_565) {
      _data_k_565 = 0;
    }
    bm1cs_[18] = _data_l_565[_data_k_565++];
  }
  if (__calls[23].calls == 0) {
    _data_k_566 = 0;
    if (_data_k_566 >= _data_n_566) {
      _data_k_566 = 0;
    }
    bm1cs_[19] = _data_l_566[_data_k_566++];
  }
  if (__calls[23].calls == 0) {
    _data_k_567 = 0;
    if (_data_k_567 >= _data_n_567) {
      _data_k_567 = 0;
    }
    bm1cs_[20] = _data_l_567[_data_k_567++];
  }
  if (__calls[23].calls == 0) {
    _data_k_568 = 0;
    if (_data_k_568 >= _data_n_568) {
      _data_k_568 = 0;
    }
    bth1cs_[0] = _data_l_568[_data_k_568++];
  }
  if (__calls[23].calls == 0) {
    _data_k_569 = 0;
    if (_data_k_569 >= _data_n_569) {
      _data_k_569 = 0;
    }
    bth1cs_[1] = _data_l_569[_data_k_569++];
  }
  if (__calls[23].calls == 0) {
    _data_k_570 = 0;
    if (_data_k_570 >= _data_n_570) {
      _data_k_570 = 0;
    }
    bth1cs_[2] = _data_l_570[_data_k_570++];
  }
  if (__calls[23].calls == 0) {
    _data_k_571 = 0;
    if (_data_k_571 >= _data_n_571) {
      _data_k_571 = 0;
    }
    bth1cs_[3] = _data_l_571[_data_k_571++];
  }
  if (__calls[23].calls == 0) {
    _data_k_572 = 0;
    if (_data_k_572 >= _data_n_572) {
      _data_k_572 = 0;
    }
    bth1cs_[4] = _data_l_572[_data_k_572++];
  }
  if (__calls[23].calls == 0) {
    _data_k_573 = 0;
    if (_data_k_573 >= _data_n_573) {
      _data_k_573 = 0;
    }
    bth1cs_[5] = _data_l_573[_data_k_573++];
  }
  if (__calls[23].calls == 0) {
    _data_k_574 = 0;
    if (_data_k_574 >= _data_n_574) {
      _data_k_574 = 0;
    }
    bth1cs_[6] = _data_l_574[_data_k_574++];
  }
  if (__calls[23].calls == 0) {
    _data_k_575 = 0;
    if (_data_k_575 >= _data_n_575) {
      _data_k_575 = 0;
    }
    bth1cs_[7] = _data_l_575[_data_k_575++];
  }
  if (__calls[23].calls == 0) {
    _data_k_576 = 0;
    if (_data_k_576 >= _data_n_576) {
      _data_k_576 = 0;
    }
    bth1cs_[8] = _data_l_576[_data_k_576++];
  }
  if (__calls[23].calls == 0) {
    _data_k_577 = 0;
    if (_data_k_577 >= _data_n_577) {
      _data_k_577 = 0;
    }
    bth1cs_[9] = _data_l_577[_data_k_577++];
  }
  if (__calls[23].calls == 0) {
    _data_k_578 = 0;
    if (_data_k_578 >= _data_n_578) {
      _data_k_578 = 0;
    }
    bth1cs_[10] = _data_l_578[_data_k_578++];
  }
  if (__calls[23].calls == 0) {
    _data_k_579 = 0;
    if (_data_k_579 >= _data_n_579) {
      _data_k_579 = 0;
    }
    bth1cs_[11] = _data_l_579[_data_k_579++];
  }
  if (__calls[23].calls == 0) {
    _data_k_580 = 0;
    if (_data_k_580 >= _data_n_580) {
      _data_k_580 = 0;
    }
    bth1cs_[12] = _data_l_580[_data_k_580++];
  }
  if (__calls[23].calls == 0) {
    _data_k_581 = 0;
    if (_data_k_581 >= _data_n_581) {
      _data_k_581 = 0;
    }
    bth1cs_[13] = _data_l_581[_data_k_581++];
  }
  if (__calls[23].calls == 0) {
    _data_k_582 = 0;
    if (_data_k_582 >= _data_n_582) {
      _data_k_582 = 0;
    }
    bth1cs_[14] = _data_l_582[_data_k_582++];
  }
  if (__calls[23].calls == 0) {
    _data_k_583 = 0;
    if (_data_k_583 >= _data_n_583) {
      _data_k_583 = 0;
    }
    bth1cs_[15] = _data_l_583[_data_k_583++];
  }
  if (__calls[23].calls == 0) {
    _data_k_584 = 0;
    if (_data_k_584 >= _data_n_584) {
      _data_k_584 = 0;
    }
    bth1cs_[16] = _data_l_584[_data_k_584++];
  }
  if (__calls[23].calls == 0) {
    _data_k_585 = 0;
    if (_data_k_585 >= _data_n_585) {
      _data_k_585 = 0;
    }
    bth1cs_[17] = _data_l_585[_data_k_585++];
  }
  if (__calls[23].calls == 0) {
    _data_k_586 = 0;
    if (_data_k_586 >= _data_n_586) {
      _data_k_586 = 0;
    }
    bth1cs_[18] = _data_l_586[_data_k_586++];
  }
  if (__calls[23].calls == 0) {
    _data_k_587 = 0;
    if (_data_k_587 >= _data_n_587) {
      _data_k_587 = 0;
    }
    bth1cs_[19] = _data_l_587[_data_k_587++];
  }
  if (__calls[23].calls == 0) {
    _data_k_588 = 0;
    if (_data_k_588 >= _data_n_588) {
      _data_k_588 = 0;
    }
    bth1cs_[20] = _data_l_588[_data_k_588++];
  }
  if (__calls[23].calls == 0) {
    _data_k_589 = 0;
    if (_data_k_589 >= _data_n_589) {
      _data_k_589 = 0;
    }
    bth1cs_[21] = _data_l_589[_data_k_589++];
  }
  if (__calls[23].calls == 0) {
    _data_k_590 = 0;
    if (_data_k_590 >= _data_n_590) {
      _data_k_590 = 0;
    }
    bth1cs_[22] = _data_l_590[_data_k_590++];
  }
  if (__calls[23].calls == 0) {
    _data_k_591 = 0;
    if (_data_k_591 >= _data_n_591) {
      _data_k_591 = 0;
    }
    bth1cs_[23] = _data_l_591[_data_k_591++];
  }
  if (__calls[23].calls == 0) {
    _data_k_592 = 0;
    if (_data_k_592 >= _data_n_592) {
      _data_k_592 = 0;
    }
    twodpi_ = _data_l_592[_data_k_592++];
  }
  if (__calls[23].calls == 0) {
    _data_k_593 = 0;
    if (_data_k_593 >= _data_n_593) {
      _data_k_593 = 0;
    }
    pi4_ = _data_l_593[_data_k_593++];
  }
  if (__calls[23].calls == 0) {
    _data_k_594 = 0;
    if (_data_k_594 >= _data_n_594) {
      _data_k_594 = 0;
    }
    first_ = _data_l_594[_data_k_594++];
  }
  if (first_) {
    nty1_ = _inits (by1cs_, ($0_ = 14, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    ntm1_ = _inits (bm1cs_, ($3_ = 21, &$3_), ($5_ = 0.1 * _r1mach (($4_ = 3, &$4_)), &$5_));
    ntth1_ = _inits (bth1cs_, ($6_ = 24, &$6_), ($8_ = 0.1 * _r1mach (($7_ = 3, &$7_)), &$8_));
    xmin_ = 1.571 * expf (_max (logf (_r1mach (&_k1)), -logf (_r1mach (($9_ = 2, &$9_)))) + .01);
    xsml_ = sqrtf (4.0 * _r1mach (($10_ = 3, &$10_)));
    xmax_ = 1.0 / _r1mach (($11_ = 4, &$11_));
  }
  first_ = FALSE;
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_57, _dc_29, &_k1, ($12_ = 2, &$12_));
  }
  if ((*x_) > 4.0) {
    goto _l20;
  }
  if ((*x_) < xmin_) {
    (void) _xermsg (_dc_0, _dc_57, _dc_58, ($13_ = 3, &$13_), ($14_ = 2, &$14_));
  }
  y_ = 0.0;
  if ((*x_) > xsml_) {
    y_ = (*x_) * (*x_);
  }
  besy1_ = twodpi_ * logf (0.5 * (*x_)) * _besj1 (x_) + (0.5 + _csevl (($15_ = .125 * y_ - 1.0, &$15_), by1cs_, &nty1_)) 
  / (*x_);
  goto _l0;
  _l20:;
  if ((*x_) > xmax_) {
    (void) _xermsg (_dc_0, _dc_57, _dc_56, ($16_ = 2, &$16_), ($17_ = 2, &$17_));
  }
  z_ = 32.0 / ((*x_) * (*x_)) - 1.0;
  ampl_ = (0.75 + _csevl (&z_, bm1cs_, &ntm1_)) / sqrtf ((*x_));
  theta_ = (*x_) - 3.0 * pi4_ + _csevl (&z_, bth1cs_, &ntth1_) / (*x_);
  besy1_ = ampl_ * sinf (theta_);
  _l0:;
  __calls[23].calls++;
  return besy1_;
}

int_4 _besy (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ n_, real_4 _p_ y_)
{
  static int_4 i_, iflw_, j_, nb_, nd_, nn_, nud_, nulim_[2];
  static real_4 azn_, cn_, dnu_, elim_, flgjy_, fn_, ran_, s_, s1_, s2_, tm_, trx_, w_[2], wk_[7], w2n_, xlim_, xxn_;
  int_4 _data_k_595, $0_, $1_, $2_, $3_, $4_, $5_;
  extern real_4 _yairy ();
  extern int_4 _i1mach ();
  extern real_4 _r1mach ();
#define _data_n_595 2
  static int_4 _data_l_595[_data_n_595] = {
    70,
    100
  };
  if (__calls[24].calls == 0) {
    _data_k_595 = 0;
    if (_data_k_595 >= _data_n_595) {
      _data_k_595 = 0;
    }
    nulim_[0] = _data_l_595[_data_k_595++];
    if (_data_k_595 >= _data_n_595) {
      _data_k_595 = 0;
    }
    nulim_[1] = _data_l_595[_data_k_595++];
  }
  nn_ = -_i1mach (($0_ = 12, &$0_));
  elim_ = 2.303e0 * (nn_ * _r1mach (($1_ = 5, &$1_)) - 3.0e0);
  xlim_ = _r1mach (&_k1) * 1.0e3;
  if ((*fnu_) < 0.0e0) {
    goto _l140;
  }
  if ((*x_) <= 0.0e0) {
    goto _l150;
  }
  if ((*x_) < xlim_) {
    goto _l170;
  }
  if ((*n_) < 1) {
    goto _l160;
  }
  nd_ = (*n_);
  nud_ = (int_4) (_aintd ((*fnu_)));
  dnu_ = (*fnu_) - nud_;
  nn_ = _min (2, nd_);
  fn_ = (*fnu_) + (*n_) - 1;
  if (fn_ < 2.0e0) {
    goto _l100;
  }
  xxn_ = (*x_) / fn_;
  w2n_ = 1.0e0 - xxn_ * xxn_;
  if (w2n_ <= 0.0e0) {
    goto _l10;
  }
  ran_ = sqrtf (w2n_);
  azn_ = logf ((1.0e0 + ran_) / xxn_) - ran_;
  cn_ = fn_ * azn_;
  if (cn_ > elim_) {
    goto _l170;
  }
  _l10:;
  if (nud_ < nulim_[nn_ - 1]) {
    goto _l20;
  }
  flgjy_ = -1.0;
  (void) _asyjy (_yairy, x_, fnu_, &flgjy_, &nn_, y_, wk_, &iflw_);
  if (iflw_ != 0) {
    goto _l170;
  }
  if (nn_ == 1) {
    goto _l0;
  }
  trx_ = 2.0e0 / (*x_);
  tm_ = ((*fnu_) + (*fnu_) + 2.0e0) / (*x_);
  goto _l80;
  _l20:;
  if (dnu_ != 0.0e0) {
    goto _l30;
  }
  s1_ = _besy0 (x_);
  if (nud_ == 0 && nd_ == 1) {
    goto _l70;
  }
  s2_ = _besy1 (x_);
  goto _l40;
  _l30:;
  nb_ = 2;
  if (nud_ == 0 && nd_ == 1) {
    nb_ = 1;
  }
  (void) _besynu (x_, &dnu_, &nb_, w_);
  s1_ = w_[0];
  if (nb_ == 1) {
    goto _l70;
  }
  s2_ = w_[1];
  _l40:;
  trx_ = 2.0e0 / (*x_);
  tm_ = (dnu_ + dnu_ + 2.0e0) / (*x_);
  if (nd_ == 1) {
    nud_ = nud_ - 1;
  }
  if (nud_ > 0) {
    goto _l50;
  }
  if (nd_ > 1) {
    goto _l70;
  }
  s1_ = s2_;
  goto _l70;
  _l50:;
  for (i_ = 1; i_ <= nud_; (i_)++) {
    s_ = s2_;
    s2_ = tm_ * s2_ - s1_;
    s1_ = s_;
    tm_ = tm_ + trx_;
  }
  if (nd_ == 1) {
    s1_ = s2_;
  }
  _l70:;
  y_[0] = s1_;
  if (nd_ == 1) {
    goto _l0;
  }
  y_[1] = s2_;
  _l80:;
  if (nd_ == 2) {
    goto _l0;
  }
  for (i_ = 3; i_ <= nd_; (i_)++) {
    y_[i_ - 1] = tm_ * y_[i_ - 1 - 1] - y_[i_ - 2 - 1];
    tm_ = tm_ + trx_;
  }
  goto _l0;
  _l100:;
  if (fn_ <= 1.0e0) {
    goto _l110;
  }
  if (-fn_ * (logf ((*x_)) - 0.693e0) > elim_) {
    goto _l170;
  }
  _l110:;
  if (dnu_ == 0.0e0) {
    goto _l120;
  }
  (void) _besynu (x_, fnu_, &nd_, y_);
  goto _l0;
  _l120:;
  j_ = nud_;
  if (j_ == 1) {
    goto _l130;
  }
  j_ = j_ + 1;
  y_[j_ - 1] = _besy0 (x_);
  if (nd_ == 1) {
    goto _l0;
  }
  j_ = j_ + 1;
  _l130:;
  y_[j_ - 1] = _besy1 (x_);
  if (nd_ == 1) {
    goto _l0;
  }
  trx_ = 2.0e0 / (*x_);
  tm_ = trx_;
  goto _l80;
  _l140:;
  (void) _xermsg (_dc_0, _dc_59, _dc_44, ($2_ = 2, &$2_), &_k1);
  goto _l0;
  _l150:;
  (void) _xermsg (_dc_0, _dc_59, _dc_45, ($3_ = 2, &$3_), &_k1);
  goto _l0;
  _l160:;
  (void) _xermsg (_dc_0, _dc_59, _dc_46, ($4_ = 2, &$4_), &_k1);
  goto _l0;
  _l170:;
  (void) _xermsg (_dc_0, _dc_59, _dc_47, ($5_ = 6, &$5_), &_k1);
  _l0:;
  __calls[24].calls++;
  return 0;
}

int_4 _besynu (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ n_, real_4 _p_ y_)
{
  static int_4 i_, inu_, j_, k_, kk_, nn_;
  static real_4 a_[120], ak_, arg_, a1_, a2_, bk_, cb_[120], cbk_, cc_[8], cck_, ck_, coef_, cpt_, cp1_, cp2_, cs_, cs1_, 
  cs2_, cx_, dnu_, dnu2_, etest_, etx_, f_, fc_, fhs_, fk_, fks_, flrx_, fmu_, fn_, fx_, g_, g1_, g2_, hpi_, p_, pi_, pt_
  , q_, rb_[120], rbk_, rck_, relb_, rpt_, rp1_, rp2_, rs_, rs1_, rs2_, rthpi_, rx_, s_, sa_, sb_, smu_, ss_, st_, s1_, 
  s2_, tb_, tm_, tol_, t1_, t2_, x1_, x2_;
  int_4 _data_k_596, _data_k_597, _data_k_598, _data_k_599, $0_, $7_, $8_, $9_;
  real_4 $1_, $2_, $3_, $4_, $5_, $6_;
  extern real_4 _gamma ();
  extern real_4 _r1mach ();
#define _data_n_596 2
  static real_4 _data_l_596[_data_n_596] = {
    3.0e0,
    20.0e0
  };
#define _data_n_597 2
  static real_4 _data_l_597[_data_n_597] = {
    3.14159265358979e+00,
    7.97884560802865e-1
  };
#define _data_n_598 1
  static real_4 _data_l_598[_data_n_598] = {
    1.5707963267949e+00
  };
#define _data_n_599 8
  static real_4 _data_l_599[_data_n_599] = {
    5.77215664901533e-1,
    -4.20026350340952e-2,
    -4.21977345555443e-2,
    7.218943246663e-3,
    -2.152416741149e-4,
    -2.01348547807e-5,
    1.133027232e-6,
    6.116095e-9
  };
  if (__calls[25].calls == 0) {
    _data_k_596 = 0;
    if (_data_k_596 >= _data_n_596) {
      _data_k_596 = 0;
    }
    x1_ = _data_l_596[_data_k_596++];
    if (_data_k_596 >= _data_n_596) {
      _data_k_596 = 0;
    }
    x2_ = _data_l_596[_data_k_596++];
  }
  if (__calls[25].calls == 0) {
    _data_k_597 = 0;
    if (_data_k_597 >= _data_n_597) {
      _data_k_597 = 0;
    }
    pi_ = _data_l_597[_data_k_597++];
    if (_data_k_597 >= _data_n_597) {
      _data_k_597 = 0;
    }
    rthpi_ = _data_l_597[_data_k_597++];
  }
  if (__calls[25].calls == 0) {
    _data_k_598 = 0;
    if (_data_k_598 >= _data_n_598) {
      _data_k_598 = 0;
    }
    hpi_ = _data_l_598[_data_k_598++];
  }
  if (__calls[25].calls == 0) {
    _data_k_599 = 0;
    if (_data_k_599 >= _data_n_599) {
      _data_k_599 = 0;
    }
    cc_[0] = _data_l_599[_data_k_599++];
    if (_data_k_599 >= _data_n_599) {
      _data_k_599 = 0;
    }
    cc_[1] = _data_l_599[_data_k_599++];
    if (_data_k_599 >= _data_n_599) {
      _data_k_599 = 0;
    }
    cc_[2] = _data_l_599[_data_k_599++];
    if (_data_k_599 >= _data_n_599) {
      _data_k_599 = 0;
    }
    cc_[3] = _data_l_599[_data_k_599++];
    if (_data_k_599 >= _data_n_599) {
      _data_k_599 = 0;
    }
    cc_[4] = _data_l_599[_data_k_599++];
    if (_data_k_599 >= _data_n_599) {
      _data_k_599 = 0;
    }
    cc_[5] = _data_l_599[_data_k_599++];
    if (_data_k_599 >= _data_n_599) {
      _data_k_599 = 0;
    }
    cc_[6] = _data_l_599[_data_k_599++];
    if (_data_k_599 >= _data_n_599) {
      _data_k_599 = 0;
    }
    cc_[7] = _data_l_599[_data_k_599++];
  }
  ak_ = _r1mach (($0_ = 3, &$0_));
  tol_ = _max (ak_, 1.0e-15);
  if ((*x_) <= 0.0e0) {
    goto _l270;
  }
  if ((*fnu_) < 0.0e0) {
    goto _l280;
  }
  if ((*n_) < 1) {
    goto _l290;
  }
  rx_ = 2.0e0 / (*x_);
  inu_ = (int_4) (_aintd ((*fnu_) + 0.5e0));
  dnu_ = (*fnu_) - inu_;
  if (_abs (dnu_) == 0.5e0) {
    goto _l260;
  }
  dnu2_ = 0.0;
  if (_abs (dnu_) < tol_) {
    goto _l10;
  }
  dnu2_ = dnu_ * dnu_;
  _l10:;
  if ((*x_) > x1_) {
    goto _l120;
  }
  a1_ = 1.0e0 - dnu_;
  a2_ = 1.0e0 + dnu_;
  t1_ = 1.0e0 / _gamma (&a1_);
  t2_ = 1.0e0 / _gamma (&a2_);
  if (_abs (dnu_) > 0.1e0) {
    goto _l40;
  }
  s_ = cc_[0];
  ak_ = 1.0;
  for (k_ = 2; k_ <= 8; (k_)++) {
    ak_ = ak_ * dnu2_;
    tm_ = cc_[k_ - 1] * ak_;
    s_ = s_ + tm_;
    if (_abs (tm_) < tol_) {
      goto _l30;
    }
  }
  _l30:;
  g1_ = -(s_ + s_);
  goto _l50;
  _l40:;
  g1_ = (t1_ - t2_) / dnu_;
  _l50:;
  g2_ = t1_ + t2_;
  smu_ = 1.0;
  fc_ = 1.0e0 / pi_;
  flrx_ = logf (rx_);
  fmu_ = dnu_ * flrx_;
  tm_ = 0.0;
  if (dnu_ == 0.0e0) {
    goto _l60;
  }
  tm_ = sinf (dnu_ * hpi_) / dnu_;
  tm_ = (dnu_ + dnu_) * tm_ * tm_;
  fc_ = dnu_ / sinf (dnu_ * pi_);
  if (fmu_ != 0.0e0) {
    smu_ = sinhf (fmu_) / fmu_;
  }
  _l60:;
  f_ = fc_ * (g1_ * coshf (fmu_) + g2_ * flrx_ * smu_);
  fx_ = expf (fmu_);
  p_ = fc_ * t1_ * fx_;
  q_ = fc_ * t2_ / fx_;
  g_ = f_ + tm_ * q_;
  ak_ = 1.0;
  ck_ = 1.0;
  bk_ = 1.0;
  s1_ = g_;
  s2_ = p_;
  if (inu_ > 0 || (*n_) > 1) {
    goto _l90;
  }
  if ((*x_) < tol_) {
    goto _l80;
  }
  cx_ = (*x_) * (*x_) * 0.25e0;
  _l70:;
  f_ = (ak_ * f_ + p_ + q_) / (bk_ - dnu2_);
  p_ = p_ / (ak_ - dnu_);
  q_ = q_ / (ak_ + dnu_);
  g_ = f_ + tm_ * q_;
  ck_ = -ck_ * cx_ / ak_;
  t1_ = ck_ * g_;
  s1_ = s1_ + t1_;
  bk_ = bk_ + ak_ + ak_ + 1.0e0;
  ak_ = ak_ + 1.0e0;
  s_ = _abs (t1_) / (1.0e0 + _abs (s1_));
  if (s_ > tol_) {
    goto _l70;
  }
  _l80:;
  y_[0] = -s1_;
  goto _l0;
  _l90:;
  if ((*x_) < tol_) {
    goto _l110;
  }
  cx_ = (*x_) * (*x_) * 0.25e0;
  _l100:;
  f_ = (ak_ * f_ + p_ + q_) / (bk_ - dnu2_);
  p_ = p_ / (ak_ - dnu_);
  q_ = q_ / (ak_ + dnu_);
  g_ = f_ + tm_ * q_;
  ck_ = -ck_ * cx_ / ak_;
  t1_ = ck_ * g_;
  s1_ = s1_ + t1_;
  t2_ = ck_ * (p_ - ak_ * g_);
  s2_ = s2_ + t2_;
  bk_ = bk_ + ak_ + ak_ + 1.0e0;
  ak_ = ak_ + 1.0e0;
  s_ = _abs (t1_) / (1.0e0 + _abs (s1_)) + _abs (t2_) / (1.0e0 + _abs (s2_));
  if (s_ > tol_) {
    goto _l100;
  }
  _l110:;
  s2_ = -s2_ * rx_;
  s1_ = -s1_;
  goto _l160;
  _l120:;
  coef_ = rthpi_ / sqrtf ((*x_));
  if ((*x_) > x2_) {
    goto _l210;
  }
  etest_ = cosf (pi_ * dnu_) / (pi_ * (*x_) * tol_);
  fks_ = 1.0;
  fhs_ = 0.25;
  fk_ = 0.0;
  rck_ = 2.0;
  cck_ = (*x_) + (*x_);
  rp1_ = 0.0;
  cp1_ = 0.0;
  rp2_ = 1.0;
  cp2_ = 0.0;
  k_ = 0;
  _l130:;
  k_ = k_ + 1;
  fk_ = fk_ + 1.0e0;
  ak_ = (fhs_ - dnu2_) / (fks_ + fk_);
  pt_ = fk_ + 1.0e0;
  rbk_ = rck_ / pt_;
  cbk_ = cck_ / pt_;
  rpt_ = rp2_;
  cpt_ = cp2_;
  rp2_ = rbk_ * rpt_ - cbk_ * cpt_ - ak_ * rp1_;
  cp2_ = cbk_ * rpt_ + rbk_ * cpt_ - ak_ * cp1_;
  rp1_ = rpt_;
  cp1_ = cpt_;
  rb_[k_ - 1] = rbk_;
  cb_[k_ - 1] = cbk_;
  a_[k_ - 1] = ak_;
  rck_ = rck_ + 2.0e0;
  fks_ = fks_ + fk_ + fk_ + 1.0e0;
  fhs_ = fhs_ + fk_ + fk_;
  pt_ = _max (_abs (rp1_), _abs (cp1_));
  fc_ = ($1_ = (rp1_ / pt_), $1_ * $1_) + ($2_ = (cp1_ / pt_), $2_ * $2_);
  pt_ = pt_ * sqrtf (fc_) * fk_;
  if (etest_ > pt_) {
    goto _l130;
  }
  kk_ = k_;
  rs_ = 1.0;
  cs_ = 0.0;
  rp1_ = 0.0;
  cp1_ = 0.0;
  rp2_ = 1.0;
  cp2_ = 0.0;
  for (i_ = 1; i_ <= k_; (i_)++) {
    rpt_ = rp2_;
    cpt_ = cp2_;
    rp2_ = (rb_[kk_ - 1] * rpt_ - cb_[kk_ - 1] * cpt_ - rp1_) / a_[kk_ - 1];
    cp2_ = (cb_[kk_ - 1] * rpt_ + rb_[kk_ - 1] * cpt_ - cp1_) / a_[kk_ - 1];
    rp1_ = rpt_;
    cp1_ = cpt_;
    rs_ = rs_ + rp2_;
    cs_ = cs_ + cp2_;
    kk_ = kk_ - 1;
  }
  pt_ = _max (_abs (rs_), _abs (cs_));
  fc_ = ($3_ = (rs_ / pt_), $3_ * $3_) + ($4_ = (cs_ / pt_), $4_ * $4_);
  pt_ = pt_ * sqrtf (fc_);
  rs1_ = (rp2_ * (rs_ / pt_) + cp2_ * (cs_ / pt_)) / pt_;
  cs1_ = (cp2_ * (rs_ / pt_) - rp2_ * (cs_ / pt_)) / pt_;
  fc_ = hpi_ * (dnu_ - 0.5e0) - (*x_);
  p_ = cosf (fc_);
  q_ = sinf (fc_);
  s1_ = (cs1_ * q_ - rs1_ * p_) * coef_;
  if (inu_ > 0 || (*n_) > 1) {
    goto _l150;
  }
  y_[0] = s1_;
  goto _l0;
  _l150:;
  pt_ = _max (_abs (rp2_), _abs (cp2_));
  fc_ = ($5_ = (rp2_ / pt_), $5_ * $5_) + ($6_ = (cp2_ / pt_), $6_ * $6_);
  pt_ = pt_ * sqrtf (fc_);
  rpt_ = dnu_ + 0.5e0 - (rp1_ * (rp2_ / pt_) + cp1_ * (cp2_ / pt_)) / pt_;
  cpt_ = (*x_) - (cp1_ * (rp2_ / pt_) - rp1_ * (cp2_ / pt_)) / pt_;
  cs2_ = cs1_ * cpt_ - rs1_ * rpt_;
  rs2_ = rpt_ * cs1_ + rs1_ * cpt_;
  s2_ = (rs2_ * q_ + cs2_ * p_) * coef_ / (*x_);
  _l160:;
  ck_ = (dnu_ + dnu_ + 2.0e0) / (*x_);
  if ((*n_) == 1) {
    inu_ = inu_ - 1;
  }
  if (inu_ > 0) {
    goto _l170;
  }
  if ((*n_) > 1) {
    goto _l190;
  }
  s1_ = s2_;
  goto _l190;
  _l170:;
  for (i_ = 1; i_ <= inu_; (i_)++) {
    st_ = s2_;
    s2_ = ck_ * s2_ - s1_;
    s1_ = st_;
    ck_ = ck_ + rx_;
  }
  if ((*n_) == 1) {
    s1_ = s2_;
  }
  _l190:;
  y_[0] = s1_;
  if ((*n_) == 1) {
    goto _l0;
  }
  y_[1] = s2_;
  if ((*n_) == 2) {
    goto _l0;
  }
  for (i_ = 3; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = ck_ * y_[i_ - 1 - 1] - y_[i_ - 2 - 1];
    ck_ = ck_ + rx_;
  }
  goto _l0;
  _l210:;
  nn_ = 2;
  if (inu_ == 0 && (*n_) == 1) {
    nn_ = 1;
  }
  dnu2_ = dnu_ + dnu_;
  fmu_ = 0.0;
  if (_abs (dnu2_) < tol_) {
    goto _l220;
  }
  fmu_ = dnu2_ * dnu2_;
  _l220:;
  arg_ = (*x_) - hpi_ * (dnu_ + 0.5e0);
  sa_ = sinf (arg_);
  sb_ = cosf (arg_);
  etx_ = 8.0e0 * (*x_);
  for (k_ = 1; k_ <= nn_; (k_)++) {
    s1_ = s2_;
    t2_ = (fmu_ - 1.0e0) / etx_;
    ss_ = t2_;
    relb_ = tol_ * _abs (t2_);
    t1_ = etx_;
    s_ = 1.0;
    fn_ = 1.0;
    ak_ = 0.0;
    for (j_ = 1; j_ <= 13; (j_)++) {
      t1_ = t1_ + etx_;
      ak_ = ak_ + 8.0e0;
      fn_ = fn_ + ak_;
      t2_ = -t2_ * (fmu_ - fn_) / t1_;
      s_ = s_ + t2_;
      t1_ = t1_ + etx_;
      ak_ = ak_ + 8.0e0;
      fn_ = fn_ + ak_;
      t2_ = t2_ * (fmu_ - fn_) / t1_;
      ss_ = ss_ + t2_;
      if (_abs (t2_) <= relb_) {
        goto _l240;
      }
    }
    _l240:;
    s2_ = coef_ * (s_ * sa_ + ss_ * sb_);
    fmu_ = fmu_ + 8.0e0 * dnu_ + 4.0e0;
    tb_ = sa_;
    sa_ = -sb_;
    sb_ = tb_;
  }
  if (nn_ > 1) {
    goto _l160;
  }
  s1_ = s2_;
  goto _l190;
  _l260:;
  coef_ = rthpi_ / sqrtf ((*x_));
  s1_ = coef_ * sinf ((*x_));
  s2_ = -coef_ * cosf ((*x_));
  goto _l160;
  _l270:;
  (void) _xermsg (_dc_0, _dc_60, _dc_49, ($7_ = 2, &$7_), &_k1);
  goto _l0;
  _l280:;
  (void) _xermsg (_dc_0, _dc_60, _dc_50, ($8_ = 2, &$8_), &_k1);
  goto _l0;
  _l290:;
  (void) _xermsg (_dc_0, _dc_60, _dc_52, ($9_ = 2, &$9_), &_k1);
  _l0:;
  __calls[25].calls++;
  return 0;
}

real_4 _beta (real_4 _p_ a_, real_4 _p_ b_)
{
  static real_4 beta_, xmax_, alnsml_, xmin_;
  int_4 _data_k_600, $0_, $1_, $3_;
  real_4 $2_;
  extern real_4 _gamma ();
  extern real_4 _r1mach ();
#define _data_n_600 2
  static real_4 _data_l_600[_data_n_600] = {
    0.0,
    0.0
  };
  if (__calls[26].calls == 0) {
    _data_k_600 = 0;
    if (_data_k_600 >= _data_n_600) {
      _data_k_600 = 0;
    }
    xmax_ = _data_l_600[_data_k_600++];
    if (_data_k_600 >= _data_n_600) {
      _data_k_600 = 0;
    }
    alnsml_ = _data_l_600[_data_k_600++];
  }
  if (alnsml_ != 0.0) {
    goto _l10;
  }
  (void) _gamlim (&xmin_, &xmax_);
  alnsml_ = logf (_r1mach (&_k1));
  _l10:;
  if ((*a_) <= 0.0 || (*b_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_61, _dc_62, ($0_ = 2, &$0_), ($1_ = 2, &$1_));
  }
  if ((*a_) + (*b_) < xmax_) {
    beta_ = _gamma (a_) * _gamma (b_) / _gamma (($2_ = (*a_) + (*b_), &$2_));
  }
  if ((*a_) + (*b_) < xmax_) {
    goto _l0;
  }
  beta_ = _albeta (a_, b_);
  if (beta_ < alnsml_) {
    (void) _xermsg (_dc_0, _dc_61, _dc_63, &_k1, ($3_ = 2, &$3_));
  }
  beta_ = expf (beta_);
  _l0:;
  __calls[26].calls++;
  return beta_;
}

real_4 _betai (real_4 _p_ x_, real_4 _p_ pin_, real_4 _p_ qin_)
{
  static int_4 n_, i_, ib_;
  static logical_4 first_;
  static real_4 eps_, alneps_, sml_, alnsml_, y_, p_, q_, ps_, xb_, term_, c_, p1_, finsum_;
  int_4 _data_k_601, $0_, $1_, $2_, $3_;
  real_4 betai_;
  extern real_4 _r1mach ();
#define _data_n_601 1
  static logical_4 _data_l_601[_data_n_601] = {
    TRUE
  };
  if (__calls[27].calls == 0) {
    _data_k_601 = 0;
    if (_data_k_601 >= _data_n_601) {
      _data_k_601 = 0;
    }
    first_ = _data_l_601[_data_k_601++];
  }
  if (first_) {
    eps_ = _r1mach (($0_ = 3, &$0_));
    alneps_ = logf (eps_);
    sml_ = _r1mach (&_k1);
    alnsml_ = logf (sml_);
  }
  first_ = FALSE;
  if ((*x_) < 0.0 || (*x_) > 1.0) {
    (void) _xermsg (_dc_0, _dc_64, _dc_65, &_k1, ($1_ = 2, &$1_));
  }
  if ((*pin_) <= 0.0 || (*qin_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_64, _dc_66, ($2_ = 2, &$2_), ($3_ = 2, &$3_));
  }
  y_ = (*x_);
  p_ = (*pin_);
  q_ = (*qin_);
  if (q_ <= p_ && (*x_) < 0.8) {
    goto _l20;
  }
  if ((*x_) < 0.2) {
    goto _l20;
  }
  y_ = 1.0 - y_;
  p_ = (*qin_);
  q_ = (*pin_);
  _l20:;
  if ((p_ + q_) * y_ / (p_ + 1.0) < eps_) {
    goto _l80;
  }
  ps_ = q_ - _aintd (q_);
  if (ps_ == 0.0) {
    ps_ = 1.0;
  }
  xb_ = p_ * logf (y_) - _albeta (&ps_, &p_) - logf (p_);
  betai_ = 0.0;
  if (xb_ < alnsml_) {
    goto _l40;
  }
  betai_ = expf (xb_);
  term_ = betai_ * p_;
  if (ps_ == 1.0) {
    goto _l40;
  }
  n_ = _max (alneps_ / logf (y_), 4.0);
  for (i_ = 1; i_ <= n_; (i_)++) {
    term_ = term_ * (i_ - ps_) * y_ / i_;
    betai_ = betai_ + term_ / (p_ + i_);
  }
  _l40:;
  if (q_ <= 1.0) {
    goto _l70;
  }
  xb_ = p_ * logf (y_) + q_ * logf (1.0 - y_) - _albeta (&p_, &q_) - logf (q_);
  ib_ = _max (xb_ / alnsml_, 0.0);
  term_ = expf (xb_ - ib_ * alnsml_);
  c_ = 1.0 / (1.0 - y_);
  p1_ = q_ * c_ / (p_ + q_ - 1.0);
  finsum_ = 0.0;
  n_ = q_;
  if (q_ == (real_4) (n_)) {
    n_ = n_ - 1;
  }
  for (i_ = 1; i_ <= n_; (i_)++) {
    if (p1_ <= 1.0 && term_ / eps_ <= finsum_) {
      goto _l60;
    }
    term_ = (q_ - i_ + 1) * c_ * term_ / (p_ + q_ - i_);
    if (term_ > 1.0) {
      ib_ = ib_ - 1;
    }
    if (term_ > 1.0) {
      term_ = term_ * sml_;
    }
    if (ib_ == 0) {
      finsum_ = finsum_ + term_;
    }
  }
  _l60:;
  betai_ = betai_ + finsum_;
  _l70:;
  if (y_ != (*x_) || p_ != (*pin_)) {
    betai_ = 1.0 - betai_;
  }
  betai_ = _max (_min (betai_, 1.0), 0.0);
  goto _l0;
  _l80:;
  betai_ = 0.0;
  xb_ = p_ * logf (_max (y_, sml_)) - logf (p_) - _albeta (&p_, &q_);
  if (xb_ > alnsml_ && y_ != 0.0) {
    betai_ = expf (xb_);
  }
  if (y_ != (*x_) || p_ != (*pin_)) {
    betai_ = 1.0 - betai_;
  }
  _l0:;
  __calls[27].calls++;
  return betai_;
}

int_4 _bfqad (real_4 (*_f)(), real_4 _p_ t_, real_4 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ id_, real_4 _p_ 
x1_, real_4 _p_ x2_, real_4 _p_ tol_, real_4 _p_ quad_, int_4 _p_ ierr_, real_4 _p_ work_)
{
  static int_4 iflg_, ilo_, il1_, il2_, left_, mflag_, npk_, np1_, inbv_;
  static real_4 a_, aa_, ans_, b_, bb_, q_, ta_, tb_, wtol_;
  int_4 $0_, $1_, $3_, $4_, $5_, $6_;
  char_127 $2_;
  extern real_4 _r1mach ();
  (*ierr_) = 1;
  (*quad_) = 0.0;
  if ((*k_) < 1) {
    goto _l100;
  }
  if ((*n_) < (*k_)) {
    goto _l105;
  }
  if ((*id_) < 0 || (*id_) >= (*k_)) {
    goto _l110;
  }
  wtol_ = _r1mach (($0_ = 4, &$0_));
  if ((*tol_) < wtol_ || (*tol_) > 0.1e0) {
    goto _l30;
  }
  aa_ = _min ((*x1_), (*x2_));
  bb_ = _max ((*x1_), (*x2_));
  if (aa_ < t_[(*k_) - 1]) {
    goto _l20;
  }
  np1_ = (*n_) + 1;
  if (bb_ > t_[np1_ - 1]) {
    goto _l20;
  }
  if (aa_ == bb_) {
    goto _l0;
  }
  npk_ = (*n_) + (*k_);
  ilo_ = 1;
  (void) _intrv (t_, &npk_, &aa_, &ilo_, &il1_, &mflag_);
  (void) _intrv (t_, &npk_, &bb_, &ilo_, &il2_, &mflag_);
  if (il2_ >= np1_) {
    il2_ = (*n_);
  }
  inbv_ = 1;
  q_ = 0.0;
  for (left_ = il1_; left_ <= il2_; (left_)++) {
    ta_ = t_[left_ - 1];
    tb_ = t_[left_ + 1 - 1];
    if (ta_ == tb_) {
      goto _l10;
    }
    a_ = _max (aa_, ta_);
    b_ = _min (bb_, tb_);
    (void) _bsgq8 (_f, t_, bcoef_, n_, k_, id_, &a_, &b_, &inbv_, tol_, &ans_, &iflg_, work_);
    if (iflg_ > 1) {
      (*ierr_) = 2;
    }
    q_ = q_ + ans_;
    _l10:;
  }
  if ((*x1_) > (*x2_)) {
    q_ = -q_;
  }
  (*quad_) = q_;
  goto _l0;
  _l20:;
  (void) _xermsg (_dc_0, _dc_67, _dc_68, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l30:;
  (void) _xermsg (_dc_0, _dc_67, concat ($2_, _dc_69, _dc_70), ($3_ = 2, &$3_), &_k1);
  goto _l0;
  _l100:;
  (void) _xermsg (_dc_0, _dc_67, _dc_71, ($4_ = 2, &$4_), &_k1);
  goto _l0;
  _l105:;
  (void) _xermsg (_dc_0, _dc_67, _dc_72, ($5_ = 2, &$5_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_67, _dc_73, ($6_ = 2, &$6_), &_k1);
  _l0:;
  __calls[28].calls++;
  return 0;
}

real_4 _bie (real_4 _p_ x_)
{
  static int_4 nbif_, nbig_, nbif2_, nbig2_, nbip_, nbip2_;
  static logical_4 first_;
  static real_4 bie_, bifcs_[9], bigcs_[8], bif2cs_[10], big2cs_[10], bipcs_[24], bip2cs_[29], atr_, btr_, x3sml_, 
  x32sml_, xbig_, eta_, xm_, theta_, z_, sqrtx_;
  int_4 _data_k_602, _data_k_603, _data_k_604, _data_k_605, _data_k_606, _data_k_607, _data_k_608, _data_k_609, 
  _data_k_610, _data_k_611, _data_k_612, _data_k_613, _data_k_614, _data_k_615, _data_k_616, _data_k_617, _data_k_618, 
  _data_k_619, _data_k_620, _data_k_621, _data_k_622, _data_k_623, _data_k_624, _data_k_625, _data_k_626, _data_k_627, 
  _data_k_628, _data_k_629, _data_k_630, _data_k_631, _data_k_632, _data_k_633, _data_k_634, _data_k_635, _data_k_636, 
  _data_k_637, _data_k_638, _data_k_639, _data_k_640, _data_k_641, _data_k_642, _data_k_643, _data_k_644, _data_k_645, 
  _data_k_646, _data_k_647, _data_k_648, _data_k_649, _data_k_650, _data_k_651, _data_k_652, _data_k_653, _data_k_654, 
  _data_k_655, _data_k_656, _data_k_657, _data_k_658, _data_k_659, _data_k_660, _data_k_661, _data_k_662, _data_k_663, 
  _data_k_664, _data_k_665, _data_k_666, _data_k_667, _data_k_668, _data_k_669, _data_k_670, _data_k_671, _data_k_672, 
  _data_k_673, _data_k_674, _data_k_675, _data_k_676, _data_k_677, _data_k_678, _data_k_679, _data_k_680, _data_k_681, 
  _data_k_682, _data_k_683, _data_k_684, _data_k_685, _data_k_686, _data_k_687, _data_k_688, _data_k_689, _data_k_690, 
  _data_k_691, _data_k_692, _data_k_693, _data_k_694, $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern real_4 _r1mach ();
#define _data_n_602 1
  static real_4 _data_l_602[_data_n_602] = {
    -.01673021647198664948e0
  };
#define _data_n_603 1
  static real_4 _data_l_603[_data_n_603] = {
    .1025233583424944561e0
  };
#define _data_n_604 1
  static real_4 _data_l_604[_data_n_604] = {
    .00170830925073815165e0
  };
#define _data_n_605 1
  static real_4 _data_l_605[_data_n_605] = {
    .00001186254546774468e0
  };
#define _data_n_606 1
  static real_4 _data_l_606[_data_n_606] = {
    .00000004493290701779e0
  };
#define _data_n_607 1
  static real_4 _data_l_607[_data_n_607] = {
    .00000000010698207143e0
  };
#define _data_n_608 1
  static real_4 _data_l_608[_data_n_608] = {
    .00000000000017480643e0
  };
#define _data_n_609 1
  static real_4 _data_l_609[_data_n_609] = {
    .0000000000000002081e0
  };
#define _data_n_610 1
  static real_4 _data_l_610[_data_n_610] = {
    .00000000000000000018e0
  };
#define _data_n_611 1
  static real_4 _data_l_611[_data_n_611] = {
    .02246622324857452e0
  };
#define _data_n_612 1
  static real_4 _data_l_612[_data_n_612] = {
    .03736477545301955e0
  };
#define _data_n_613 1
  static real_4 _data_l_613[_data_n_613] = {
    .00044476218957212e0
  };
#define _data_n_614 1
  static real_4 _data_l_614[_data_n_614] = {
    .00000247080756363e0
  };
#define _data_n_615 1
  static real_4 _data_l_615[_data_n_615] = {
    .00000000791913533e0
  };
#define _data_n_616 1
  static real_4 _data_l_616[_data_n_616] = {
    .00000000001649807e0
  };
#define _data_n_617 1
  static real_4 _data_l_617[_data_n_617] = {
    .00000000000002411e0
  };
#define _data_n_618 1
  static real_4 _data_l_618[_data_n_618] = {
    .00000000000000002e0
  };
#define _data_n_619 1
  static real_4 _data_l_619[_data_n_619] = {
    0.09984572693816041e0
  };
#define _data_n_620 1
  static real_4 _data_l_620[_data_n_620] = {
    .478624977863005538e0
  };
#define _data_n_621 1
  static real_4 _data_l_621[_data_n_621] = {
    .0251552119604330118e0
  };
#define _data_n_622 1
  static real_4 _data_l_622[_data_n_622] = {
    .0005820693885232645e0
  };
#define _data_n_623 1
  static real_4 _data_l_623[_data_n_623] = {
    .0000074997659644377e0
  };
#define _data_n_624 1
  static real_4 _data_l_624[_data_n_624] = {
    .0000000613460287034e0
  };
#define _data_n_625 1
  static real_4 _data_l_625[_data_n_625] = {
    .0000000003462753885e0
  };
#define _data_n_626 1
  static real_4 _data_l_626[_data_n_626] = {
    .000000000001428891e0
  };
#define _data_n_627 1
  static real_4 _data_l_627[_data_n_627] = {
    .0000000000000044962e0
  };
#define _data_n_628 1
  static real_4 _data_l_628[_data_n_628] = {
    .0000000000000000111e0
  };
#define _data_n_629 1
  static real_4 _data_l_629[_data_n_629] = {
    .03330566214551434e0
  };
#define _data_n_630 1
  static real_4 _data_l_630[_data_n_630] = {
    .161309215123197068e0
  };
#define _data_n_631 1
  static real_4 _data_l_631[_data_n_631] = {
    .0063190073096134286e0
  };
#define _data_n_632 1
  static real_4 _data_l_632[_data_n_632] = {
    .0001187904568162517e0
  };
#define _data_n_633 1
  static real_4 _data_l_633[_data_n_633] = {
    .00000130453458862e0
  };
#define _data_n_634 1
  static real_4 _data_l_634[_data_n_634] = {
    .0000000093741259955e0
  };
#define _data_n_635 1
  static real_4 _data_l_635[_data_n_635] = {
    .0000000000474580188e0
  };
#define _data_n_636 1
  static real_4 _data_l_636[_data_n_636] = {
    .0000000000001783107e0
  };
#define _data_n_637 1
  static real_4 _data_l_637[_data_n_637] = {
    .0000000000000005167e0
  };
#define _data_n_638 1
  static real_4 _data_l_638[_data_n_638] = {
    .0000000000000000011e0
  };
#define _data_n_639 1
  static real_4 _data_l_639[_data_n_639] = {
    -.08322047477943447e0
  };
#define _data_n_640 1
  static real_4 _data_l_640[_data_n_640] = {
    .01146118927371174e0
  };
#define _data_n_641 1
  static real_4 _data_l_641[_data_n_641] = {
    .00042896440718911e0
  };
#define _data_n_642 1
  static real_4 _data_l_642[_data_n_642] = {
    -.0001490663937995e0
  };
#define _data_n_643 1
  static real_4 _data_l_643[_data_n_643] = {
    -.00001307659726787e0
  };
#define _data_n_644 1
  static real_4 _data_l_644[_data_n_644] = {
    .0000063275983961e0
  };
#define _data_n_645 1
  static real_4 _data_l_645[_data_n_645] = {
    -.00000042226696982e0
  };
#define _data_n_646 1
  static real_4 _data_l_646[_data_n_646] = {
    -.00000019147186298e0
  };
#define _data_n_647 1
  static real_4 _data_l_647[_data_n_647] = {
    .00000006453106284e0
  };
#define _data_n_648 1
  static real_4 _data_l_648[_data_n_648] = {
    -.00000000784485467e0
  };
#define _data_n_649 1
  static real_4 _data_l_649[_data_n_649] = {
    -.00000000096077216e0
  };
#define _data_n_650 1
  static real_4 _data_l_650[_data_n_650] = {
    .00000000070004713e0
  };
#define _data_n_651 1
  static real_4 _data_l_651[_data_n_651] = {
    -.00000000017731789e0
  };
#define _data_n_652 1
  static real_4 _data_l_652[_data_n_652] = {
    .00000000002272089e0
  };
#define _data_n_653 1
  static real_4 _data_l_653[_data_n_653] = {
    .00000000000165404e0
  };
#define _data_n_654 1
  static real_4 _data_l_654[_data_n_654] = {
    -.00000000000185171e0
  };
#define _data_n_655 1
  static real_4 _data_l_655[_data_n_655] = {
    .00000000000059576e0
  };
#define _data_n_656 1
  static real_4 _data_l_656[_data_n_656] = {
    -.00000000000012194e0
  };
#define _data_n_657 1
  static real_4 _data_l_657[_data_n_657] = {
    .00000000000001334e0
  };
#define _data_n_658 1
  static real_4 _data_l_658[_data_n_658] = {
    .00000000000000172e0
  };
#define _data_n_659 1
  static real_4 _data_l_659[_data_n_659] = {
    -.00000000000000145e0
  };
#define _data_n_660 1
  static real_4 _data_l_660[_data_n_660] = {
    .00000000000000049e0
  };
#define _data_n_661 1
  static real_4 _data_l_661[_data_n_661] = {
    -.00000000000000011e0
  };
#define _data_n_662 1
  static real_4 _data_l_662[_data_n_662] = {
    .00000000000000001e0
  };
#define _data_n_663 1
  static real_4 _data_l_663[_data_n_663] = {
    -.113596737585988679e0
  };
#define _data_n_664 1
  static real_4 _data_l_664[_data_n_664] = {
    .0041381473947881595e0
  };
#define _data_n_665 1
  static real_4 _data_l_665[_data_n_665] = {
    .0001353470622119332e0
  };
#define _data_n_666 1
  static real_4 _data_l_666[_data_n_666] = {
    .0000104273166530153e0
  };
#define _data_n_667 1
  static real_4 _data_l_667[_data_n_667] = {
    .0000013474954767849e0
  };
#define _data_n_668 1
  static real_4 _data_l_668[_data_n_668] = {
    .0000001696537405438e0
  };
#define _data_n_669 1
  static real_4 _data_l_669[_data_n_669] = {
    -.0000000100965008656e0
  };
#define _data_n_670 1
  static real_4 _data_l_670[_data_n_670] = {
    -.0000000167291194937e0
  };
#define _data_n_671 1
  static real_4 _data_l_671[_data_n_671] = {
    -.0000000045815364485e0
  };
#define _data_n_672 1
  static real_4 _data_l_672[_data_n_672] = {
    .0000000003736681366e0
  };
#define _data_n_673 1
  static real_4 _data_l_673[_data_n_673] = {
    .000000000576693032e0
  };
#define _data_n_674 1
  static real_4 _data_l_674[_data_n_674] = {
    .000000000062181265e0
  };
#define _data_n_675 1
  static real_4 _data_l_675[_data_n_675] = {
    -.0000000000632941202e0
  };
#define _data_n_676 1
  static real_4 _data_l_676[_data_n_676] = {
    -.0000000000149150479e0
  };
#define _data_n_677 1
  static real_4 _data_l_677[_data_n_677] = {
    .0000000000078896213e0
  };
#define _data_n_678 1
  static real_4 _data_l_678[_data_n_678] = {
    .0000000000024960513e0
  };
#define _data_n_679 1
  static real_4 _data_l_679[_data_n_679] = {
    -.0000000000012130075e0
  };
#define _data_n_680 1
  static real_4 _data_l_680[_data_n_680] = {
    -.0000000000003740493e0
  };
#define _data_n_681 1
  static real_4 _data_l_681[_data_n_681] = {
    .0000000000002237727e0
  };
#define _data_n_682 1
  static real_4 _data_l_682[_data_n_682] = {
    .0000000000000474902e0
  };
#define _data_n_683 1
  static real_4 _data_l_683[_data_n_683] = {
    -.0000000000000452616e0
  };
#define _data_n_684 1
  static real_4 _data_l_684[_data_n_684] = {
    -.0000000000000030172e0
  };
#define _data_n_685 1
  static real_4 _data_l_685[_data_n_685] = {
    .0000000000000091058e0
  };
#define _data_n_686 1
  static real_4 _data_l_686[_data_n_686] = {
    -.0000000000000009814e0
  };
#define _data_n_687 1
  static real_4 _data_l_687[_data_n_687] = {
    -.0000000000000016429e0
  };
#define _data_n_688 1
  static real_4 _data_l_688[_data_n_688] = {
    .0000000000000005533e0
  };
#define _data_n_689 1
  static real_4 _data_l_689[_data_n_689] = {
    .0000000000000002175e0
  };
#define _data_n_690 1
  static real_4 _data_l_690[_data_n_690] = {
    -.0000000000000001737e0
  };
#define _data_n_691 1
  static real_4 _data_l_691[_data_n_691] = {
    -.000000000000000001e0
  };
#define _data_n_692 1
  static real_4 _data_l_692[_data_n_692] = {
    8.7506905708484345e0
  };
#define _data_n_693 1
  static real_4 _data_l_693[_data_n_693] = {
    -2.093836321356054e0
  };
#define _data_n_694 1
  static logical_4 _data_l_694[_data_n_694] = {
    TRUE
  };
  if (__calls[29].calls == 0) {
    _data_k_602 = 0;
    if (_data_k_602 >= _data_n_602) {
      _data_k_602 = 0;
    }
    bifcs_[0] = _data_l_602[_data_k_602++];
  }
  if (__calls[29].calls == 0) {
    _data_k_603 = 0;
    if (_data_k_603 >= _data_n_603) {
      _data_k_603 = 0;
    }
    bifcs_[1] = _data_l_603[_data_k_603++];
  }
  if (__calls[29].calls == 0) {
    _data_k_604 = 0;
    if (_data_k_604 >= _data_n_604) {
      _data_k_604 = 0;
    }
    bifcs_[2] = _data_l_604[_data_k_604++];
  }
  if (__calls[29].calls == 0) {
    _data_k_605 = 0;
    if (_data_k_605 >= _data_n_605) {
      _data_k_605 = 0;
    }
    bifcs_[3] = _data_l_605[_data_k_605++];
  }
  if (__calls[29].calls == 0) {
    _data_k_606 = 0;
    if (_data_k_606 >= _data_n_606) {
      _data_k_606 = 0;
    }
    bifcs_[4] = _data_l_606[_data_k_606++];
  }
  if (__calls[29].calls == 0) {
    _data_k_607 = 0;
    if (_data_k_607 >= _data_n_607) {
      _data_k_607 = 0;
    }
    bifcs_[5] = _data_l_607[_data_k_607++];
  }
  if (__calls[29].calls == 0) {
    _data_k_608 = 0;
    if (_data_k_608 >= _data_n_608) {
      _data_k_608 = 0;
    }
    bifcs_[6] = _data_l_608[_data_k_608++];
  }
  if (__calls[29].calls == 0) {
    _data_k_609 = 0;
    if (_data_k_609 >= _data_n_609) {
      _data_k_609 = 0;
    }
    bifcs_[7] = _data_l_609[_data_k_609++];
  }
  if (__calls[29].calls == 0) {
    _data_k_610 = 0;
    if (_data_k_610 >= _data_n_610) {
      _data_k_610 = 0;
    }
    bifcs_[8] = _data_l_610[_data_k_610++];
  }
  if (__calls[29].calls == 0) {
    _data_k_611 = 0;
    if (_data_k_611 >= _data_n_611) {
      _data_k_611 = 0;
    }
    bigcs_[0] = _data_l_611[_data_k_611++];
  }
  if (__calls[29].calls == 0) {
    _data_k_612 = 0;
    if (_data_k_612 >= _data_n_612) {
      _data_k_612 = 0;
    }
    bigcs_[1] = _data_l_612[_data_k_612++];
  }
  if (__calls[29].calls == 0) {
    _data_k_613 = 0;
    if (_data_k_613 >= _data_n_613) {
      _data_k_613 = 0;
    }
    bigcs_[2] = _data_l_613[_data_k_613++];
  }
  if (__calls[29].calls == 0) {
    _data_k_614 = 0;
    if (_data_k_614 >= _data_n_614) {
      _data_k_614 = 0;
    }
    bigcs_[3] = _data_l_614[_data_k_614++];
  }
  if (__calls[29].calls == 0) {
    _data_k_615 = 0;
    if (_data_k_615 >= _data_n_615) {
      _data_k_615 = 0;
    }
    bigcs_[4] = _data_l_615[_data_k_615++];
  }
  if (__calls[29].calls == 0) {
    _data_k_616 = 0;
    if (_data_k_616 >= _data_n_616) {
      _data_k_616 = 0;
    }
    bigcs_[5] = _data_l_616[_data_k_616++];
  }
  if (__calls[29].calls == 0) {
    _data_k_617 = 0;
    if (_data_k_617 >= _data_n_617) {
      _data_k_617 = 0;
    }
    bigcs_[6] = _data_l_617[_data_k_617++];
  }
  if (__calls[29].calls == 0) {
    _data_k_618 = 0;
    if (_data_k_618 >= _data_n_618) {
      _data_k_618 = 0;
    }
    bigcs_[7] = _data_l_618[_data_k_618++];
  }
  if (__calls[29].calls == 0) {
    _data_k_619 = 0;
    if (_data_k_619 >= _data_n_619) {
      _data_k_619 = 0;
    }
    bif2cs_[0] = _data_l_619[_data_k_619++];
  }
  if (__calls[29].calls == 0) {
    _data_k_620 = 0;
    if (_data_k_620 >= _data_n_620) {
      _data_k_620 = 0;
    }
    bif2cs_[1] = _data_l_620[_data_k_620++];
  }
  if (__calls[29].calls == 0) {
    _data_k_621 = 0;
    if (_data_k_621 >= _data_n_621) {
      _data_k_621 = 0;
    }
    bif2cs_[2] = _data_l_621[_data_k_621++];
  }
  if (__calls[29].calls == 0) {
    _data_k_622 = 0;
    if (_data_k_622 >= _data_n_622) {
      _data_k_622 = 0;
    }
    bif2cs_[3] = _data_l_622[_data_k_622++];
  }
  if (__calls[29].calls == 0) {
    _data_k_623 = 0;
    if (_data_k_623 >= _data_n_623) {
      _data_k_623 = 0;
    }
    bif2cs_[4] = _data_l_623[_data_k_623++];
  }
  if (__calls[29].calls == 0) {
    _data_k_624 = 0;
    if (_data_k_624 >= _data_n_624) {
      _data_k_624 = 0;
    }
    bif2cs_[5] = _data_l_624[_data_k_624++];
  }
  if (__calls[29].calls == 0) {
    _data_k_625 = 0;
    if (_data_k_625 >= _data_n_625) {
      _data_k_625 = 0;
    }
    bif2cs_[6] = _data_l_625[_data_k_625++];
  }
  if (__calls[29].calls == 0) {
    _data_k_626 = 0;
    if (_data_k_626 >= _data_n_626) {
      _data_k_626 = 0;
    }
    bif2cs_[7] = _data_l_626[_data_k_626++];
  }
  if (__calls[29].calls == 0) {
    _data_k_627 = 0;
    if (_data_k_627 >= _data_n_627) {
      _data_k_627 = 0;
    }
    bif2cs_[8] = _data_l_627[_data_k_627++];
  }
  if (__calls[29].calls == 0) {
    _data_k_628 = 0;
    if (_data_k_628 >= _data_n_628) {
      _data_k_628 = 0;
    }
    bif2cs_[9] = _data_l_628[_data_k_628++];
  }
  if (__calls[29].calls == 0) {
    _data_k_629 = 0;
    if (_data_k_629 >= _data_n_629) {
      _data_k_629 = 0;
    }
    big2cs_[0] = _data_l_629[_data_k_629++];
  }
  if (__calls[29].calls == 0) {
    _data_k_630 = 0;
    if (_data_k_630 >= _data_n_630) {
      _data_k_630 = 0;
    }
    big2cs_[1] = _data_l_630[_data_k_630++];
  }
  if (__calls[29].calls == 0) {
    _data_k_631 = 0;
    if (_data_k_631 >= _data_n_631) {
      _data_k_631 = 0;
    }
    big2cs_[2] = _data_l_631[_data_k_631++];
  }
  if (__calls[29].calls == 0) {
    _data_k_632 = 0;
    if (_data_k_632 >= _data_n_632) {
      _data_k_632 = 0;
    }
    big2cs_[3] = _data_l_632[_data_k_632++];
  }
  if (__calls[29].calls == 0) {
    _data_k_633 = 0;
    if (_data_k_633 >= _data_n_633) {
      _data_k_633 = 0;
    }
    big2cs_[4] = _data_l_633[_data_k_633++];
  }
  if (__calls[29].calls == 0) {
    _data_k_634 = 0;
    if (_data_k_634 >= _data_n_634) {
      _data_k_634 = 0;
    }
    big2cs_[5] = _data_l_634[_data_k_634++];
  }
  if (__calls[29].calls == 0) {
    _data_k_635 = 0;
    if (_data_k_635 >= _data_n_635) {
      _data_k_635 = 0;
    }
    big2cs_[6] = _data_l_635[_data_k_635++];
  }
  if (__calls[29].calls == 0) {
    _data_k_636 = 0;
    if (_data_k_636 >= _data_n_636) {
      _data_k_636 = 0;
    }
    big2cs_[7] = _data_l_636[_data_k_636++];
  }
  if (__calls[29].calls == 0) {
    _data_k_637 = 0;
    if (_data_k_637 >= _data_n_637) {
      _data_k_637 = 0;
    }
    big2cs_[8] = _data_l_637[_data_k_637++];
  }
  if (__calls[29].calls == 0) {
    _data_k_638 = 0;
    if (_data_k_638 >= _data_n_638) {
      _data_k_638 = 0;
    }
    big2cs_[9] = _data_l_638[_data_k_638++];
  }
  if (__calls[29].calls == 0) {
    _data_k_639 = 0;
    if (_data_k_639 >= _data_n_639) {
      _data_k_639 = 0;
    }
    bipcs_[0] = _data_l_639[_data_k_639++];
  }
  if (__calls[29].calls == 0) {
    _data_k_640 = 0;
    if (_data_k_640 >= _data_n_640) {
      _data_k_640 = 0;
    }
    bipcs_[1] = _data_l_640[_data_k_640++];
  }
  if (__calls[29].calls == 0) {
    _data_k_641 = 0;
    if (_data_k_641 >= _data_n_641) {
      _data_k_641 = 0;
    }
    bipcs_[2] = _data_l_641[_data_k_641++];
  }
  if (__calls[29].calls == 0) {
    _data_k_642 = 0;
    if (_data_k_642 >= _data_n_642) {
      _data_k_642 = 0;
    }
    bipcs_[3] = _data_l_642[_data_k_642++];
  }
  if (__calls[29].calls == 0) {
    _data_k_643 = 0;
    if (_data_k_643 >= _data_n_643) {
      _data_k_643 = 0;
    }
    bipcs_[4] = _data_l_643[_data_k_643++];
  }
  if (__calls[29].calls == 0) {
    _data_k_644 = 0;
    if (_data_k_644 >= _data_n_644) {
      _data_k_644 = 0;
    }
    bipcs_[5] = _data_l_644[_data_k_644++];
  }
  if (__calls[29].calls == 0) {
    _data_k_645 = 0;
    if (_data_k_645 >= _data_n_645) {
      _data_k_645 = 0;
    }
    bipcs_[6] = _data_l_645[_data_k_645++];
  }
  if (__calls[29].calls == 0) {
    _data_k_646 = 0;
    if (_data_k_646 >= _data_n_646) {
      _data_k_646 = 0;
    }
    bipcs_[7] = _data_l_646[_data_k_646++];
  }
  if (__calls[29].calls == 0) {
    _data_k_647 = 0;
    if (_data_k_647 >= _data_n_647) {
      _data_k_647 = 0;
    }
    bipcs_[8] = _data_l_647[_data_k_647++];
  }
  if (__calls[29].calls == 0) {
    _data_k_648 = 0;
    if (_data_k_648 >= _data_n_648) {
      _data_k_648 = 0;
    }
    bipcs_[9] = _data_l_648[_data_k_648++];
  }
  if (__calls[29].calls == 0) {
    _data_k_649 = 0;
    if (_data_k_649 >= _data_n_649) {
      _data_k_649 = 0;
    }
    bipcs_[10] = _data_l_649[_data_k_649++];
  }
  if (__calls[29].calls == 0) {
    _data_k_650 = 0;
    if (_data_k_650 >= _data_n_650) {
      _data_k_650 = 0;
    }
    bipcs_[11] = _data_l_650[_data_k_650++];
  }
  if (__calls[29].calls == 0) {
    _data_k_651 = 0;
    if (_data_k_651 >= _data_n_651) {
      _data_k_651 = 0;
    }
    bipcs_[12] = _data_l_651[_data_k_651++];
  }
  if (__calls[29].calls == 0) {
    _data_k_652 = 0;
    if (_data_k_652 >= _data_n_652) {
      _data_k_652 = 0;
    }
    bipcs_[13] = _data_l_652[_data_k_652++];
  }
  if (__calls[29].calls == 0) {
    _data_k_653 = 0;
    if (_data_k_653 >= _data_n_653) {
      _data_k_653 = 0;
    }
    bipcs_[14] = _data_l_653[_data_k_653++];
  }
  if (__calls[29].calls == 0) {
    _data_k_654 = 0;
    if (_data_k_654 >= _data_n_654) {
      _data_k_654 = 0;
    }
    bipcs_[15] = _data_l_654[_data_k_654++];
  }
  if (__calls[29].calls == 0) {
    _data_k_655 = 0;
    if (_data_k_655 >= _data_n_655) {
      _data_k_655 = 0;
    }
    bipcs_[16] = _data_l_655[_data_k_655++];
  }
  if (__calls[29].calls == 0) {
    _data_k_656 = 0;
    if (_data_k_656 >= _data_n_656) {
      _data_k_656 = 0;
    }
    bipcs_[17] = _data_l_656[_data_k_656++];
  }
  if (__calls[29].calls == 0) {
    _data_k_657 = 0;
    if (_data_k_657 >= _data_n_657) {
      _data_k_657 = 0;
    }
    bipcs_[18] = _data_l_657[_data_k_657++];
  }
  if (__calls[29].calls == 0) {
    _data_k_658 = 0;
    if (_data_k_658 >= _data_n_658) {
      _data_k_658 = 0;
    }
    bipcs_[19] = _data_l_658[_data_k_658++];
  }
  if (__calls[29].calls == 0) {
    _data_k_659 = 0;
    if (_data_k_659 >= _data_n_659) {
      _data_k_659 = 0;
    }
    bipcs_[20] = _data_l_659[_data_k_659++];
  }
  if (__calls[29].calls == 0) {
    _data_k_660 = 0;
    if (_data_k_660 >= _data_n_660) {
      _data_k_660 = 0;
    }
    bipcs_[21] = _data_l_660[_data_k_660++];
  }
  if (__calls[29].calls == 0) {
    _data_k_661 = 0;
    if (_data_k_661 >= _data_n_661) {
      _data_k_661 = 0;
    }
    bipcs_[22] = _data_l_661[_data_k_661++];
  }
  if (__calls[29].calls == 0) {
    _data_k_662 = 0;
    if (_data_k_662 >= _data_n_662) {
      _data_k_662 = 0;
    }
    bipcs_[23] = _data_l_662[_data_k_662++];
  }
  if (__calls[29].calls == 0) {
    _data_k_663 = 0;
    if (_data_k_663 >= _data_n_663) {
      _data_k_663 = 0;
    }
    bip2cs_[0] = _data_l_663[_data_k_663++];
  }
  if (__calls[29].calls == 0) {
    _data_k_664 = 0;
    if (_data_k_664 >= _data_n_664) {
      _data_k_664 = 0;
    }
    bip2cs_[1] = _data_l_664[_data_k_664++];
  }
  if (__calls[29].calls == 0) {
    _data_k_665 = 0;
    if (_data_k_665 >= _data_n_665) {
      _data_k_665 = 0;
    }
    bip2cs_[2] = _data_l_665[_data_k_665++];
  }
  if (__calls[29].calls == 0) {
    _data_k_666 = 0;
    if (_data_k_666 >= _data_n_666) {
      _data_k_666 = 0;
    }
    bip2cs_[3] = _data_l_666[_data_k_666++];
  }
  if (__calls[29].calls == 0) {
    _data_k_667 = 0;
    if (_data_k_667 >= _data_n_667) {
      _data_k_667 = 0;
    }
    bip2cs_[4] = _data_l_667[_data_k_667++];
  }
  if (__calls[29].calls == 0) {
    _data_k_668 = 0;
    if (_data_k_668 >= _data_n_668) {
      _data_k_668 = 0;
    }
    bip2cs_[5] = _data_l_668[_data_k_668++];
  }
  if (__calls[29].calls == 0) {
    _data_k_669 = 0;
    if (_data_k_669 >= _data_n_669) {
      _data_k_669 = 0;
    }
    bip2cs_[6] = _data_l_669[_data_k_669++];
  }
  if (__calls[29].calls == 0) {
    _data_k_670 = 0;
    if (_data_k_670 >= _data_n_670) {
      _data_k_670 = 0;
    }
    bip2cs_[7] = _data_l_670[_data_k_670++];
  }
  if (__calls[29].calls == 0) {
    _data_k_671 = 0;
    if (_data_k_671 >= _data_n_671) {
      _data_k_671 = 0;
    }
    bip2cs_[8] = _data_l_671[_data_k_671++];
  }
  if (__calls[29].calls == 0) {
    _data_k_672 = 0;
    if (_data_k_672 >= _data_n_672) {
      _data_k_672 = 0;
    }
    bip2cs_[9] = _data_l_672[_data_k_672++];
  }
  if (__calls[29].calls == 0) {
    _data_k_673 = 0;
    if (_data_k_673 >= _data_n_673) {
      _data_k_673 = 0;
    }
    bip2cs_[10] = _data_l_673[_data_k_673++];
  }
  if (__calls[29].calls == 0) {
    _data_k_674 = 0;
    if (_data_k_674 >= _data_n_674) {
      _data_k_674 = 0;
    }
    bip2cs_[11] = _data_l_674[_data_k_674++];
  }
  if (__calls[29].calls == 0) {
    _data_k_675 = 0;
    if (_data_k_675 >= _data_n_675) {
      _data_k_675 = 0;
    }
    bip2cs_[12] = _data_l_675[_data_k_675++];
  }
  if (__calls[29].calls == 0) {
    _data_k_676 = 0;
    if (_data_k_676 >= _data_n_676) {
      _data_k_676 = 0;
    }
    bip2cs_[13] = _data_l_676[_data_k_676++];
  }
  if (__calls[29].calls == 0) {
    _data_k_677 = 0;
    if (_data_k_677 >= _data_n_677) {
      _data_k_677 = 0;
    }
    bip2cs_[14] = _data_l_677[_data_k_677++];
  }
  if (__calls[29].calls == 0) {
    _data_k_678 = 0;
    if (_data_k_678 >= _data_n_678) {
      _data_k_678 = 0;
    }
    bip2cs_[15] = _data_l_678[_data_k_678++];
  }
  if (__calls[29].calls == 0) {
    _data_k_679 = 0;
    if (_data_k_679 >= _data_n_679) {
      _data_k_679 = 0;
    }
    bip2cs_[16] = _data_l_679[_data_k_679++];
  }
  if (__calls[29].calls == 0) {
    _data_k_680 = 0;
    if (_data_k_680 >= _data_n_680) {
      _data_k_680 = 0;
    }
    bip2cs_[17] = _data_l_680[_data_k_680++];
  }
  if (__calls[29].calls == 0) {
    _data_k_681 = 0;
    if (_data_k_681 >= _data_n_681) {
      _data_k_681 = 0;
    }
    bip2cs_[18] = _data_l_681[_data_k_681++];
  }
  if (__calls[29].calls == 0) {
    _data_k_682 = 0;
    if (_data_k_682 >= _data_n_682) {
      _data_k_682 = 0;
    }
    bip2cs_[19] = _data_l_682[_data_k_682++];
  }
  if (__calls[29].calls == 0) {
    _data_k_683 = 0;
    if (_data_k_683 >= _data_n_683) {
      _data_k_683 = 0;
    }
    bip2cs_[20] = _data_l_683[_data_k_683++];
  }
  if (__calls[29].calls == 0) {
    _data_k_684 = 0;
    if (_data_k_684 >= _data_n_684) {
      _data_k_684 = 0;
    }
    bip2cs_[21] = _data_l_684[_data_k_684++];
  }
  if (__calls[29].calls == 0) {
    _data_k_685 = 0;
    if (_data_k_685 >= _data_n_685) {
      _data_k_685 = 0;
    }
    bip2cs_[22] = _data_l_685[_data_k_685++];
  }
  if (__calls[29].calls == 0) {
    _data_k_686 = 0;
    if (_data_k_686 >= _data_n_686) {
      _data_k_686 = 0;
    }
    bip2cs_[23] = _data_l_686[_data_k_686++];
  }
  if (__calls[29].calls == 0) {
    _data_k_687 = 0;
    if (_data_k_687 >= _data_n_687) {
      _data_k_687 = 0;
    }
    bip2cs_[24] = _data_l_687[_data_k_687++];
  }
  if (__calls[29].calls == 0) {
    _data_k_688 = 0;
    if (_data_k_688 >= _data_n_688) {
      _data_k_688 = 0;
    }
    bip2cs_[25] = _data_l_688[_data_k_688++];
  }
  if (__calls[29].calls == 0) {
    _data_k_689 = 0;
    if (_data_k_689 >= _data_n_689) {
      _data_k_689 = 0;
    }
    bip2cs_[26] = _data_l_689[_data_k_689++];
  }
  if (__calls[29].calls == 0) {
    _data_k_690 = 0;
    if (_data_k_690 >= _data_n_690) {
      _data_k_690 = 0;
    }
    bip2cs_[27] = _data_l_690[_data_k_690++];
  }
  if (__calls[29].calls == 0) {
    _data_k_691 = 0;
    if (_data_k_691 >= _data_n_691) {
      _data_k_691 = 0;
    }
    bip2cs_[28] = _data_l_691[_data_k_691++];
  }
  if (__calls[29].calls == 0) {
    _data_k_692 = 0;
    if (_data_k_692 >= _data_n_692) {
      _data_k_692 = 0;
    }
    atr_ = _data_l_692[_data_k_692++];
  }
  if (__calls[29].calls == 0) {
    _data_k_693 = 0;
    if (_data_k_693 >= _data_n_693) {
      _data_k_693 = 0;
    }
    btr_ = _data_l_693[_data_k_693++];
  }
  if (__calls[29].calls == 0) {
    _data_k_694 = 0;
    if (_data_k_694 >= _data_n_694) {
      _data_k_694 = 0;
    }
    first_ = _data_l_694[_data_k_694++];
  }
  if (first_) {
    eta_ = 0.1 * _r1mach (($0_ = 3, &$0_));
    nbif_ = _inits (bifcs_, ($1_ = 9, &$1_), &eta_);
    nbig_ = _inits (bigcs_, ($2_ = 8, &$2_), &eta_);
    nbif2_ = _inits (bif2cs_, ($3_ = 10, &$3_), &eta_);
    nbig2_ = _inits (big2cs_, ($4_ = 10, &$4_), &eta_);
    nbip_ = _inits (bipcs_, ($5_ = 24, &$5_), &eta_);
    nbip2_ = _inits (bip2cs_, ($6_ = 29, &$6_), &eta_);
    x3sml_ = powl (eta_, 0.3333);
    x32sml_ = 1.3104 * (x3sml_ * x3sml_);
    xbig_ = powl (_r1mach (($7_ = 2, &$7_)), 0.6666);
  }
  first_ = FALSE;
  if ((*x_) >= -1.0) {
    goto _l20;
  }
  (void) _r9aimp (x_, &xm_, &theta_);
  bie_ = xm_ * sinf (theta_);
  goto _l0;
  _l20:;
  if ((*x_) > 1.0) {
    goto _l30;
  }
  z_ = 0.0;
  if (_abs ((*x_)) > x3sml_) {
    z_ = ((*x_) * (*x_) * (*x_));
  }
  bie_ = 0.625 + _csevl (&z_, bifcs_, &nbif_) + (*x_) * (0.4375 + _csevl (&z_, bigcs_, &nbig_));
  if ((*x_) > x32sml_) {
    bie_ = bie_ * expf (-2.0 * (*x_) * sqrtf ((*x_)) / 3.0);
  }
  goto _l0;
  _l30:;
  if ((*x_) > 2.0) {
    goto _l40;
  }
  z_ = (2.0 * ((*x_) * (*x_) * (*x_)) - 9.0) / 7.0;
  bie_ = expf (-2.0 * (*x_) * sqrtf ((*x_)) / 3.0) * (1.125 + _csevl (&z_, bif2cs_, &nbif2_) + (*x_) * (0.625 + _csevl 
  (&z_, big2cs_, &nbig2_)));
  goto _l0;
  _l40:;
  if ((*x_) > 4.0) {
    goto _l50;
  }
  sqrtx_ = sqrtf ((*x_));
  z_ = atr_ / ((*x_) * sqrtx_) + btr_;
  bie_ = (0.625 + _csevl (&z_, bipcs_, &nbip_)) / sqrtf (sqrtx_);
  goto _l0;
  _l50:;
  sqrtx_ = sqrtf ((*x_));
  z_ = -1.0;
  if ((*x_) < xbig_) {
    z_ = 16.0 / ((*x_) * sqrtx_) - 1.0;
  }
  bie_ = (0.625 + _csevl (&z_, bip2cs_, &nbip2_)) / sqrtf (sqrtx_);
  _l0:;
  __calls[29].calls++;
  return bie_;
}

real_4 _bi (real_4 _p_ x_)
{
  static int_4 nbif_, nbig_, nbif2_, nbig2_;
  static logical_4 first_;
  static real_4 bi_, bifcs_[9], bigcs_[8], bif2cs_[10], big2cs_[10], x3sml_, xmax_, eta_, xm_, theta_, z_;
  int_4 _data_k_695, _data_k_696, _data_k_697, _data_k_698, _data_k_699, _data_k_700, _data_k_701, _data_k_702, 
  _data_k_703, _data_k_704, _data_k_705, _data_k_706, _data_k_707, _data_k_708, _data_k_709, _data_k_710, _data_k_711, 
  _data_k_712, _data_k_713, _data_k_714, _data_k_715, _data_k_716, _data_k_717, _data_k_718, _data_k_719, _data_k_720, 
  _data_k_721, _data_k_722, _data_k_723, _data_k_724, _data_k_725, _data_k_726, _data_k_727, _data_k_728, _data_k_729, 
  _data_k_730, _data_k_731, _data_k_732, $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  extern real_4 _r1mach ();
#define _data_n_695 1
  static real_4 _data_l_695[_data_n_695] = {
    -.01673021647198664948e0
  };
#define _data_n_696 1
  static real_4 _data_l_696[_data_n_696] = {
    .1025233583424944561e0
  };
#define _data_n_697 1
  static real_4 _data_l_697[_data_n_697] = {
    .00170830925073815165e0
  };
#define _data_n_698 1
  static real_4 _data_l_698[_data_n_698] = {
    .00001186254546774468e0
  };
#define _data_n_699 1
  static real_4 _data_l_699[_data_n_699] = {
    .00000004493290701779e0
  };
#define _data_n_700 1
  static real_4 _data_l_700[_data_n_700] = {
    .00000000010698207143e0
  };
#define _data_n_701 1
  static real_4 _data_l_701[_data_n_701] = {
    .00000000000017480643e0
  };
#define _data_n_702 1
  static real_4 _data_l_702[_data_n_702] = {
    .0000000000000002081e0
  };
#define _data_n_703 1
  static real_4 _data_l_703[_data_n_703] = {
    .00000000000000000018e0
  };
#define _data_n_704 1
  static real_4 _data_l_704[_data_n_704] = {
    .02246622324857452e0
  };
#define _data_n_705 1
  static real_4 _data_l_705[_data_n_705] = {
    .03736477545301955e0
  };
#define _data_n_706 1
  static real_4 _data_l_706[_data_n_706] = {
    .00044476218957212e0
  };
#define _data_n_707 1
  static real_4 _data_l_707[_data_n_707] = {
    .00000247080756363e0
  };
#define _data_n_708 1
  static real_4 _data_l_708[_data_n_708] = {
    .00000000791913533e0
  };
#define _data_n_709 1
  static real_4 _data_l_709[_data_n_709] = {
    .00000000001649807e0
  };
#define _data_n_710 1
  static real_4 _data_l_710[_data_n_710] = {
    .00000000000002411e0
  };
#define _data_n_711 1
  static real_4 _data_l_711[_data_n_711] = {
    .00000000000000002e0
  };
#define _data_n_712 1
  static real_4 _data_l_712[_data_n_712] = {
    0.09984572693816041e0
  };
#define _data_n_713 1
  static real_4 _data_l_713[_data_n_713] = {
    .478624977863005538e0
  };
#define _data_n_714 1
  static real_4 _data_l_714[_data_n_714] = {
    .0251552119604330118e0
  };
#define _data_n_715 1
  static real_4 _data_l_715[_data_n_715] = {
    .0005820693885232645e0
  };
#define _data_n_716 1
  static real_4 _data_l_716[_data_n_716] = {
    .0000074997659644377e0
  };
#define _data_n_717 1
  static real_4 _data_l_717[_data_n_717] = {
    .0000000613460287034e0
  };
#define _data_n_718 1
  static real_4 _data_l_718[_data_n_718] = {
    .0000000003462753885e0
  };
#define _data_n_719 1
  static real_4 _data_l_719[_data_n_719] = {
    .000000000001428891e0
  };
#define _data_n_720 1
  static real_4 _data_l_720[_data_n_720] = {
    .0000000000000044962e0
  };
#define _data_n_721 1
  static real_4 _data_l_721[_data_n_721] = {
    .0000000000000000111e0
  };
#define _data_n_722 1
  static real_4 _data_l_722[_data_n_722] = {
    .03330566214551434e0
  };
#define _data_n_723 1
  static real_4 _data_l_723[_data_n_723] = {
    .161309215123197068e0
  };
#define _data_n_724 1
  static real_4 _data_l_724[_data_n_724] = {
    .0063190073096134286e0
  };
#define _data_n_725 1
  static real_4 _data_l_725[_data_n_725] = {
    .0001187904568162517e0
  };
#define _data_n_726 1
  static real_4 _data_l_726[_data_n_726] = {
    .00000130453458862e0
  };
#define _data_n_727 1
  static real_4 _data_l_727[_data_n_727] = {
    .0000000093741259955e0
  };
#define _data_n_728 1
  static real_4 _data_l_728[_data_n_728] = {
    .0000000000474580188e0
  };
#define _data_n_729 1
  static real_4 _data_l_729[_data_n_729] = {
    .0000000000001783107e0
  };
#define _data_n_730 1
  static real_4 _data_l_730[_data_n_730] = {
    .0000000000000005167e0
  };
#define _data_n_731 1
  static real_4 _data_l_731[_data_n_731] = {
    .0000000000000000011e0
  };
#define _data_n_732 1
  static logical_4 _data_l_732[_data_n_732] = {
    TRUE
  };
  if (__calls[30].calls == 0) {
    _data_k_695 = 0;
    if (_data_k_695 >= _data_n_695) {
      _data_k_695 = 0;
    }
    bifcs_[0] = _data_l_695[_data_k_695++];
  }
  if (__calls[30].calls == 0) {
    _data_k_696 = 0;
    if (_data_k_696 >= _data_n_696) {
      _data_k_696 = 0;
    }
    bifcs_[1] = _data_l_696[_data_k_696++];
  }
  if (__calls[30].calls == 0) {
    _data_k_697 = 0;
    if (_data_k_697 >= _data_n_697) {
      _data_k_697 = 0;
    }
    bifcs_[2] = _data_l_697[_data_k_697++];
  }
  if (__calls[30].calls == 0) {
    _data_k_698 = 0;
    if (_data_k_698 >= _data_n_698) {
      _data_k_698 = 0;
    }
    bifcs_[3] = _data_l_698[_data_k_698++];
  }
  if (__calls[30].calls == 0) {
    _data_k_699 = 0;
    if (_data_k_699 >= _data_n_699) {
      _data_k_699 = 0;
    }
    bifcs_[4] = _data_l_699[_data_k_699++];
  }
  if (__calls[30].calls == 0) {
    _data_k_700 = 0;
    if (_data_k_700 >= _data_n_700) {
      _data_k_700 = 0;
    }
    bifcs_[5] = _data_l_700[_data_k_700++];
  }
  if (__calls[30].calls == 0) {
    _data_k_701 = 0;
    if (_data_k_701 >= _data_n_701) {
      _data_k_701 = 0;
    }
    bifcs_[6] = _data_l_701[_data_k_701++];
  }
  if (__calls[30].calls == 0) {
    _data_k_702 = 0;
    if (_data_k_702 >= _data_n_702) {
      _data_k_702 = 0;
    }
    bifcs_[7] = _data_l_702[_data_k_702++];
  }
  if (__calls[30].calls == 0) {
    _data_k_703 = 0;
    if (_data_k_703 >= _data_n_703) {
      _data_k_703 = 0;
    }
    bifcs_[8] = _data_l_703[_data_k_703++];
  }
  if (__calls[30].calls == 0) {
    _data_k_704 = 0;
    if (_data_k_704 >= _data_n_704) {
      _data_k_704 = 0;
    }
    bigcs_[0] = _data_l_704[_data_k_704++];
  }
  if (__calls[30].calls == 0) {
    _data_k_705 = 0;
    if (_data_k_705 >= _data_n_705) {
      _data_k_705 = 0;
    }
    bigcs_[1] = _data_l_705[_data_k_705++];
  }
  if (__calls[30].calls == 0) {
    _data_k_706 = 0;
    if (_data_k_706 >= _data_n_706) {
      _data_k_706 = 0;
    }
    bigcs_[2] = _data_l_706[_data_k_706++];
  }
  if (__calls[30].calls == 0) {
    _data_k_707 = 0;
    if (_data_k_707 >= _data_n_707) {
      _data_k_707 = 0;
    }
    bigcs_[3] = _data_l_707[_data_k_707++];
  }
  if (__calls[30].calls == 0) {
    _data_k_708 = 0;
    if (_data_k_708 >= _data_n_708) {
      _data_k_708 = 0;
    }
    bigcs_[4] = _data_l_708[_data_k_708++];
  }
  if (__calls[30].calls == 0) {
    _data_k_709 = 0;
    if (_data_k_709 >= _data_n_709) {
      _data_k_709 = 0;
    }
    bigcs_[5] = _data_l_709[_data_k_709++];
  }
  if (__calls[30].calls == 0) {
    _data_k_710 = 0;
    if (_data_k_710 >= _data_n_710) {
      _data_k_710 = 0;
    }
    bigcs_[6] = _data_l_710[_data_k_710++];
  }
  if (__calls[30].calls == 0) {
    _data_k_711 = 0;
    if (_data_k_711 >= _data_n_711) {
      _data_k_711 = 0;
    }
    bigcs_[7] = _data_l_711[_data_k_711++];
  }
  if (__calls[30].calls == 0) {
    _data_k_712 = 0;
    if (_data_k_712 >= _data_n_712) {
      _data_k_712 = 0;
    }
    bif2cs_[0] = _data_l_712[_data_k_712++];
  }
  if (__calls[30].calls == 0) {
    _data_k_713 = 0;
    if (_data_k_713 >= _data_n_713) {
      _data_k_713 = 0;
    }
    bif2cs_[1] = _data_l_713[_data_k_713++];
  }
  if (__calls[30].calls == 0) {
    _data_k_714 = 0;
    if (_data_k_714 >= _data_n_714) {
      _data_k_714 = 0;
    }
    bif2cs_[2] = _data_l_714[_data_k_714++];
  }
  if (__calls[30].calls == 0) {
    _data_k_715 = 0;
    if (_data_k_715 >= _data_n_715) {
      _data_k_715 = 0;
    }
    bif2cs_[3] = _data_l_715[_data_k_715++];
  }
  if (__calls[30].calls == 0) {
    _data_k_716 = 0;
    if (_data_k_716 >= _data_n_716) {
      _data_k_716 = 0;
    }
    bif2cs_[4] = _data_l_716[_data_k_716++];
  }
  if (__calls[30].calls == 0) {
    _data_k_717 = 0;
    if (_data_k_717 >= _data_n_717) {
      _data_k_717 = 0;
    }
    bif2cs_[5] = _data_l_717[_data_k_717++];
  }
  if (__calls[30].calls == 0) {
    _data_k_718 = 0;
    if (_data_k_718 >= _data_n_718) {
      _data_k_718 = 0;
    }
    bif2cs_[6] = _data_l_718[_data_k_718++];
  }
  if (__calls[30].calls == 0) {
    _data_k_719 = 0;
    if (_data_k_719 >= _data_n_719) {
      _data_k_719 = 0;
    }
    bif2cs_[7] = _data_l_719[_data_k_719++];
  }
  if (__calls[30].calls == 0) {
    _data_k_720 = 0;
    if (_data_k_720 >= _data_n_720) {
      _data_k_720 = 0;
    }
    bif2cs_[8] = _data_l_720[_data_k_720++];
  }
  if (__calls[30].calls == 0) {
    _data_k_721 = 0;
    if (_data_k_721 >= _data_n_721) {
      _data_k_721 = 0;
    }
    bif2cs_[9] = _data_l_721[_data_k_721++];
  }
  if (__calls[30].calls == 0) {
    _data_k_722 = 0;
    if (_data_k_722 >= _data_n_722) {
      _data_k_722 = 0;
    }
    big2cs_[0] = _data_l_722[_data_k_722++];
  }
  if (__calls[30].calls == 0) {
    _data_k_723 = 0;
    if (_data_k_723 >= _data_n_723) {
      _data_k_723 = 0;
    }
    big2cs_[1] = _data_l_723[_data_k_723++];
  }
  if (__calls[30].calls == 0) {
    _data_k_724 = 0;
    if (_data_k_724 >= _data_n_724) {
      _data_k_724 = 0;
    }
    big2cs_[2] = _data_l_724[_data_k_724++];
  }
  if (__calls[30].calls == 0) {
    _data_k_725 = 0;
    if (_data_k_725 >= _data_n_725) {
      _data_k_725 = 0;
    }
    big2cs_[3] = _data_l_725[_data_k_725++];
  }
  if (__calls[30].calls == 0) {
    _data_k_726 = 0;
    if (_data_k_726 >= _data_n_726) {
      _data_k_726 = 0;
    }
    big2cs_[4] = _data_l_726[_data_k_726++];
  }
  if (__calls[30].calls == 0) {
    _data_k_727 = 0;
    if (_data_k_727 >= _data_n_727) {
      _data_k_727 = 0;
    }
    big2cs_[5] = _data_l_727[_data_k_727++];
  }
  if (__calls[30].calls == 0) {
    _data_k_728 = 0;
    if (_data_k_728 >= _data_n_728) {
      _data_k_728 = 0;
    }
    big2cs_[6] = _data_l_728[_data_k_728++];
  }
  if (__calls[30].calls == 0) {
    _data_k_729 = 0;
    if (_data_k_729 >= _data_n_729) {
      _data_k_729 = 0;
    }
    big2cs_[7] = _data_l_729[_data_k_729++];
  }
  if (__calls[30].calls == 0) {
    _data_k_730 = 0;
    if (_data_k_730 >= _data_n_730) {
      _data_k_730 = 0;
    }
    big2cs_[8] = _data_l_730[_data_k_730++];
  }
  if (__calls[30].calls == 0) {
    _data_k_731 = 0;
    if (_data_k_731 >= _data_n_731) {
      _data_k_731 = 0;
    }
    big2cs_[9] = _data_l_731[_data_k_731++];
  }
  if (__calls[30].calls == 0) {
    _data_k_732 = 0;
    if (_data_k_732 >= _data_n_732) {
      _data_k_732 = 0;
    }
    first_ = _data_l_732[_data_k_732++];
  }
  if (first_) {
    eta_ = 0.1 * _r1mach (($0_ = 3, &$0_));
    nbif_ = _inits (bifcs_, ($1_ = 9, &$1_), &eta_);
    nbig_ = _inits (bigcs_, ($2_ = 8, &$2_), &eta_);
    nbif2_ = _inits (bif2cs_, ($3_ = 10, &$3_), &eta_);
    nbig2_ = _inits (big2cs_, ($4_ = 10, &$4_), &eta_);
    x3sml_ = powl (eta_, 0.3333);
    xmax_ = powl ((1.5 * logf (_r1mach (($5_ = 2, &$5_)))), 0.6666);
  }
  first_ = FALSE;
  if ((*x_) >= -1.0) {
    goto _l20;
  }
  (void) _r9aimp (x_, &xm_, &theta_);
  bi_ = xm_ * sinf (theta_);
  goto _l0;
  _l20:;
  if ((*x_) > 1.0) {
    goto _l30;
  }
  z_ = 0.0;
  if (_abs ((*x_)) > x3sml_) {
    z_ = ((*x_) * (*x_) * (*x_));
  }
  bi_ = 0.625 + _csevl (&z_, bifcs_, &nbif_) + (*x_) * (0.4375 + _csevl (&z_, bigcs_, &nbig_));
  goto _l0;
  _l30:;
  if ((*x_) > 2.0) {
    goto _l40;
  }
  z_ = (2.0 * ((*x_) * (*x_) * (*x_)) - 9.0) / 7.0;
  bi_ = 1.125 + _csevl (&z_, bif2cs_, &nbif2_) + (*x_) * (0.625 + _csevl (&z_, big2cs_, &nbig2_));
  goto _l0;
  _l40:;
  if ((*x_) > xmax_) {
    (void) _xermsg (_dc_0, _dc_74, _dc_75, &_k1, ($6_ = 2, &$6_));
  }
  bi_ = _bie (x_) * expf (2.0 * (*x_) * sqrtf ((*x_)) / 3.0);
  _l0:;
  __calls[30].calls++;
  return bi_;
}

real_4 _binom (int_4 _p_ n_, int_4 _p_ m_)
{
  static int_4 k_, i_;
  static logical_4 first_;
  static real_4 binom_, sq2pil_, bilnmx_, fintmx_, xn_, xk_, xnk_, corr_;
  int_4 _data_k_733, _data_k_734, $0_, $1_, $2_, $3_, $4_, $5_, $6_, $8_, $9_;
  real_4 $7_;
  extern real_4 _r1mach ();
#define _data_n_733 1
  static real_4 _data_l_733[_data_n_733] = {
    0.91893853320467274e0
  };
#define _data_n_734 1
  static logical_4 _data_l_734[_data_n_734] = {
    TRUE
  };
  if (__calls[31].calls == 0) {
    _data_k_733 = 0;
    if (_data_k_733 >= _data_n_733) {
      _data_k_733 = 0;
    }
    sq2pil_ = _data_l_733[_data_k_733++];
  }
  if (__calls[31].calls == 0) {
    _data_k_734 = 0;
    if (_data_k_734 >= _data_n_734) {
      _data_k_734 = 0;
    }
    first_ = _data_l_734[_data_k_734++];
  }
  if (first_) {
    bilnmx_ = logf (_r1mach (($0_ = 2, &$0_)));
    fintmx_ = 0.9 / _r1mach (($1_ = 3, &$1_));
  }
  first_ = FALSE;
  if ((*n_) < 0 || (*m_) < 0) {
    (void) _xermsg (_dc_0, _dc_76, _dc_77, &_k1, ($2_ = 2, &$2_));
  }
  if ((*n_) < (*m_)) {
    (void) _xermsg (_dc_0, _dc_76, _dc_78, ($3_ = 2, &$3_), ($4_ = 2, &$4_));
  }
  k_ = _min ((*m_), (*n_) - (*m_));
  if (k_ > 20) {
    goto _l30;
  }
  if (k_ * logf ((real_4) (_max ((*n_), 1))) > bilnmx_) {
    goto _l30;
  }
  binom_ = 1.0;
  if (k_ == 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= k_; (i_)++) {
    binom_ = binom_ * (real_4) ((*n_) - i_ + 1) / i_;
  }
  if (binom_ < fintmx_) {
    binom_ = _aintd (binom_ + 0.5);
  }
  goto _l0;
  _l30:;
  if (k_ < 9) {
    (void) _xermsg (_dc_0, _dc_76, _dc_79, ($5_ = 3, &$5_), ($6_ = 2, &$6_));
  }
  xn_ = (*n_) + 1;
  xk_ = k_ + 1;
  xnk_ = (*n_) - k_ + 1;
  corr_ = _r9lgmc (&xn_) - _r9lgmc (&xk_) - _r9lgmc (&xnk_);
  binom_ = xk_ * logf (xnk_ / xk_) - xn_ * _alnrel (($7_ = -(xk_ - 1.0) / xn_, &$7_)) - 0.5 * logf (xn_ * xnk_ / xk_) + 
  1.0 - sq2pil_ + corr_;
  if (binom_ > bilnmx_) {
    (void) _xermsg (_dc_0, _dc_76, _dc_79, ($8_ = 3, &$8_), ($9_ = 2, &$9_));
  }
  binom_ = expf (binom_);
  if (binom_ < fintmx_) {
    binom_ = _aintd (binom_ + 0.5);
  }
  _l0:;
  __calls[31].calls++;
  return binom_;
}

int_4 _bint4 (real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ ndata_, int_4 _p_ ibcl_, int_4 _p_ ibcr_, real_4 _p_ fbcl_, 
real_4 _p_ fbcr_, int_4 _p_ kntopt_, real_4 _p_ t_, real_4 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ w_)
{
  static int_4 i_, iflag_, ilb_, ileft_, it_, iub_, iw_, iwp_, j_, jw_, ndm_, np_, nwrow_;
  static real_4 tol_, txn_, tx1_, vnikx_[16], wdtol_, work_[15], xl_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_;
  extern real_4 _r1mach ();
  wdtol_ = _r1mach (($0_ = 4, &$0_));
  tol_ = sqrtf (wdtol_);
  if ((*ndata_) < 2) {
    goto _l200;
  }
  ndm_ = (*ndata_) - 1;
  for (i_ = 1; i_ <= ndm_; (i_)++) {
    if (x_[i_ - 1] >= x_[i_ + 1 - 1]) {
      goto _l210;
    }
  }
  if ((*ibcl_) < 1 || (*ibcl_) > 2) {
    goto _l220;
  }
  if ((*ibcr_) < 1 || (*ibcr_) > 2) {
    goto _l230;
  }
  if ((*kntopt_) < 1 || (*kntopt_) > 3) {
    goto _l240;
  }
  (*k_) = 4;
  (*n_) = (*ndata_) + 2;
  np_ = (*n_) + 1;
  for (i_ = 1; i_ <= (*ndata_); (i_)++) {
    t_[i_ + 3 - 1] = x_[i_ - 1];
  }
  switch ((*kntopt_)) {
    default:
    case 1: goto _l30;
    case 2: goto _l50;
    case 3: goto _l90;
  }
  _l30:;
  for (i_ = 1; i_ <= 3; (i_)++) {
    t_[4 - i_ - 1] = x_[0];
    t_[np_ + i_ - 1] = x_[(*ndata_) - 1];
  }
  goto _l110;
  _l50:;
  if ((*ndata_) > 3) {
    goto _l70;
  }
  xl_ = (x_[(*ndata_) - 1] - x_[0]) / 3.0e0;
  for (i_ = 1; i_ <= 3; (i_)++) {
    t_[4 - i_ - 1] = t_[5 - i_ - 1] - xl_;
    t_[np_ + i_ - 1] = t_[np_ + i_ - 1 - 1] + xl_;
  }
  goto _l110;
  _l70:;
  tx1_ = x_[0] + x_[0];
  txn_ = x_[(*ndata_) - 1] + x_[(*ndata_) - 1];
  for (i_ = 1; i_ <= 3; (i_)++) {
    t_[4 - i_ - 1] = tx1_ - x_[i_ + 1 - 1];
    t_[np_ + i_ - 1] = txn_ - x_[(*ndata_) - i_ - 1];
  }
  goto _l110;
  _l90:;
  for (i_ = 1; i_ <= 3; (i_)++) {
    t_[4 - i_ - 1] = w_[4 - i_ - 1];
    jw_ = _max (1, i_ - 1);
    iw_ = _imod (i_ + 2, 5) + 1;
    t_[np_ + i_ - 1] = w_[iw_ - 1 + (5) * ((jw_ - 1))];
    if (t_[4 - i_ - 1] > t_[5 - i_ - 1]) {
      goto _l250;
    }
    if (t_[np_ + i_ - 1] < t_[np_ + i_ - 1 - 1]) {
      goto _l250;
    }
  }
  _l110:;
  for (i_ = 1; i_ <= 5; (i_)++) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      w_[i_ - 1 + (5) * ((j_ - 1))] = 0.0;
    }
  }
  it_ = (*ibcl_) + 1;
  (void) _bspvd (t_, k_, &it_, &x_[0], k_, ($1_ = 4, &$1_), vnikx_, work_);
  iw_ = 0;
  if (_abs (vnikx_[2]) < tol_) {
    iw_ = 1;
  }
  for (j_ = 1; j_ <= 3; (j_)++) {
    w_[j_ + 1 - 1 + (5) * ((4 - j_ - 1))] = vnikx_[4 - j_ - 1 + (4) * ((it_ - 1))];
    w_[j_ - 1 + (5) * ((4 - j_ - 1))] = vnikx_[4 - j_ - 1];
  }
  bcoef_[0] = y_[0];
  bcoef_[1] = (*fbcl_);
  ileft_ = 4;
  if (ndm_ < 2) {
    goto _l170;
  }
  for (i_ = 2; i_ <= ndm_; (i_)++) {
    ileft_ = ileft_ + 1;
    (void) _bspvd (t_, k_, &_k1, &x_[i_ - 1], &ileft_, ($2_ = 4, &$2_), vnikx_, work_);
    for (j_ = 1; j_ <= 3; (j_)++) {
      w_[j_ + 1 - 1 + (5) * ((3 + i_ - j_ - 1))] = vnikx_[4 - j_ - 1];
    }
    bcoef_[i_ + 1 - 1] = y_[i_ - 1];
  }
  _l170:;
  it_ = (*ibcr_) + 1;
  (void) _bspvd (t_, k_, &it_, &x_[(*ndata_) - 1], &ileft_, ($3_ = 4, &$3_), vnikx_, work_);
  jw_ = 0;
  if (_abs (vnikx_[1]) < tol_) {
    jw_ = 1;
  }
  for (j_ = 1; j_ <= 3; (j_)++) {
    w_[j_ + 1 - 1 + (5) * ((3 + (*ndata_) - j_ - 1))] = vnikx_[5 - j_ - 1 + (4) * ((it_ - 1))];
    w_[j_ + 2 - 1 + (5) * ((3 + (*ndata_) - j_ - 1))] = vnikx_[5 - j_ - 1];
  }
  bcoef_[(*n_) - 1 - 1] = (*fbcr_);
  bcoef_[(*n_) - 1] = y_[(*ndata_) - 1];
  ilb_ = 2 - jw_;
  iub_ = 2 - iw_;
  nwrow_ = 5;
  iwp_ = iw_ + 1;
  (void) _bnfac (&w_[iwp_ - 1], &nwrow_, n_, &ilb_, &iub_, &iflag_);
  if (iflag_ == 2) {
    goto _l190;
  }
  (void) _bnslv (&w_[iwp_ - 1], &nwrow_, n_, &ilb_, &iub_, bcoef_);
  goto _l0;
  _l190:;
  (void) _xermsg (_dc_0, _dc_80, _dc_81, ($4_ = 2, &$4_), &_k1);
  goto _l0;
  _l200:;
  (void) _xermsg (_dc_0, _dc_80, _dc_82, ($5_ = 2, &$5_), &_k1);
  goto _l0;
  _l210:;
  (void) _xermsg (_dc_0, _dc_80, _dc_83, ($6_ = 2, &$6_), &_k1);
  goto _l0;
  _l220:;
  (void) _xermsg (_dc_0, _dc_80, _dc_84, ($7_ = 2, &$7_), &_k1);
  goto _l0;
  _l230:;
  (void) _xermsg (_dc_0, _dc_80, _dc_85, ($8_ = 2, &$8_), &_k1);
  goto _l0;
  _l240:;
  (void) _xermsg (_dc_0, _dc_80, _dc_86, ($9_ = 2, &$9_), &_k1);
  goto _l0;
  _l250:;
  (void) _xermsg (_dc_0, _dc_80, _dc_87, ($10_ = 2, &$10_), &_k1);
  _l0:;
  __calls[32].calls++;
  return 0;
}

int_4 _bintk (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ t_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ bcoef_, real_4 _p_ q_
, real_4 _p_ work_)
{
  static int_4 iflag_, iwork_, i_, ilp1mx_, j_, jj_, km1_, kpkm2_, left_, lenq_, np1_;
  static real_4 xi_;
  int_4 $0_, $1_, $3_, $5_, $6_, $7_, $8_;
  char_127 $2_, $4_;
  if ((*k_) < 1) {
    goto _l100;
  }
  if ((*n_) < (*k_)) {
    goto _l105;
  }
  jj_ = (*n_) - 1;
  if (jj_ == 0) {
    goto _l6;
  }
  for (i_ = 1; i_ <= jj_; (i_)++) {
    if (x_[i_ - 1] >= x_[i_ + 1 - 1]) {
      goto _l110;
    }
  }
  _l6:;
  np1_ = (*n_) + 1;
  km1_ = (*k_) - 1;
  kpkm2_ = 2 * km1_;
  left_ = (*k_);
  lenq_ = (*n_) * ((*k_) + km1_);
  for (i_ = 1; i_ <= lenq_; (i_)++) {
    q_[i_ - 1] = 0.0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    xi_ = x_[i_ - 1];
    ilp1mx_ = _min (i_ + (*k_), np1_);
    left_ = _max (left_, i_);
    if (xi_ < t_[left_ - 1]) {
      goto _l80;
    }
    _l20:;
    if (xi_ < t_[left_ + 1 - 1]) {
      goto _l30;
    }
    left_ = left_ + 1;
    if (left_ < ilp1mx_) {
      goto _l20;
    }
    left_ = left_ - 1;
    if (xi_ > t_[left_ + 1 - 1]) {
      goto _l80;
    }
    _l30:;
    (void) _bspvn (t_, k_, k_, &_k1, &xi_, &left_, bcoef_, work_, &iwork_);
    jj_ = i_ - left_ + 1 + (left_ - (*k_)) * ((*k_) + km1_);
    for (j_ = 1; j_ <= (*k_); (j_)++) {
      jj_ = jj_ + kpkm2_;
      q_[jj_ - 1] = bcoef_[j_ - 1];
    }
  }
  (void) _bnfac (q_, ($0_ = (*k_) + km1_, &$0_), n_, &km1_, &km1_, &iflag_);
  switch (iflag_) {
    default:
    case 1: goto _l60;
    case 2: goto _l90;
  }
  _l60:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    bcoef_[i_ - 1] = y_[i_ - 1];
  }
  (void) _bnslv (q_, ($1_ = (*k_) + km1_, &$1_), n_, &km1_, &km1_, bcoef_);
  goto _l0;
  _l80:;
  (void) _xermsg (_dc_0, _dc_88, concat ($2_, _dc_89, _dc_90), ($3_ = 2, &$3_), &_k1);
  goto _l0;
  _l90:;
  (void) _xermsg (_dc_0, _dc_88, concat ($4_, _dc_91, _dc_92), ($5_ = 8, &$5_), &_k1);
  goto _l0;
  _l100:;
  (void) _xermsg (_dc_0, _dc_88, _dc_71, ($6_ = 2, &$6_), &_k1);
  goto _l0;
  _l105:;
  (void) _xermsg (_dc_0, _dc_88, _dc_72, ($7_ = 2, &$7_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_88, _dc_93, ($8_ = 2, &$8_), &_k1);
  _l0:;
  __calls[33].calls++;
  return 0;
}

int_4 _bkias (real_4 _p_ x_, int_4 _p_ n_, int_4 _p_ ktrms_, real_4 _p_ t_, real_4 _p_ ans_, int_4 _p_ ind_, int_4 _p_ 
ms_, real_4 _p_ gmrn_, real_4 _p_ h_, int_4 _p_ ierr_)
{
  static int_4 i_, ii_, j_, jmi_, jn_, k_, kk_, km_, mm_, mp_;
  static real_4 b_[120], bnd_[15], den1_, den2_, den3_, er_, err_, fj_, fk_, fln_, fm1_, g1_, gs_, hn_, hrtpi_, rat_, 
  rg1_, rxp_, rz_, rzx_, s_[31], ss_, sumi_, sumj_, tol_, v_[52], w_[52], xp_[16], z_;
  int_4 _data_k_735, _data_k_736, _data_k_737, _data_k_738, _data_k_739, _data_k_740, _data_k_741, _data_k_742, $0_;
  extern real_4 _gamrn ();
  extern real_4 _r1mach ();
#define _data_n_735 24
  static real_4 _data_l_735[_data_n_735] = {
    1.0e+00,
    1.0e+00,
    -2.0e+00,
    1.0e+00,
    -8.0e+00,
    6.0e+00,
    1.0e+00,
    -2.2e1,
    5.8e1,
    -2.4e1,
    1.0e+00,
    -5.2e1,
    3.28e2,
    -4.44e2,
    1.2e2,
    1.0e+00,
    -1.14e2,
    1.452e3,
    -4.4e3,
    3.708e3,
    -7.2e2,
    1.0e+00,
    -2.4e2,
    5.61e3
  };
#define _data_n_736 24
  static real_4 _data_l_736[_data_n_736] = {
    -3.212e4,
    5.814e4,
    -3.3984e4,
    5.04e3,
    1.0e+00,
    -4.94e2,
    1.995e4,
    -1.958e5,
    6.4402e5,
    -7.85304e5,
    3.41136e5,
    -4.032e4,
    1.0e+00,
    -1.004e3,
    6.726e4,
    -1.0625e6,
    5.7655e6,
    -1.2440064e7,
    1.1026296e7,
    -3.73392e6,
    3.6288e5,
    1.0e+00,
    -2.026e3,
    2.18848e5
  };
#define _data_n_737 24
  static real_4 _data_l_737[_data_n_737] = {
    -5.32616e6,
    4.4765e7,
    -1.55357384e8,
    2.38904904e8,
    -1.62186912e8,
    4.433904e7,
    -3.6288e6,
    1.0e+00,
    -4.072e3,
    6.95038e5,
    -2.5243904e7,
    3.1436972e8,
    -1.648384304e9,
    4.002695088e9,
    -4.642163952e9,
    2.507481216e9,
    -5.6835648e8,
    3.99168e7,
    1.0e+00,
    -8.166e3,
    2.170626e6,
    -1.14876376e8,
    2.051482776e9,
    -1.5548960784e10
  };
#define _data_n_738 24
  static real_4 _data_l_738[_data_n_738] = {
    5.6041398784e10,
    -1.01180433024e11,
    9.2199790224e10,
    -4.0788301824e10,
    7.82771904e9,
    -4.790016e8,
    1.0e+00,
    -1.6356e4,
    6.699696e6,
    -5.07259276e8,
    1.2669817776e10,
    -1.34323420224e11,
    6.87720046384e11,
    -1.818188642304e12,
    2.549865473424e12,
    -1.883079661824e12,
    6.979294368e11,
    -1.1533608576e11,
    6.2270208e9,
    1.0e+00,
    -3.2738e4,
    2.0507988e7,
    -2.189829808e9,
    7.5016052228e10
  };
#define _data_n_739 22
  static real_4 _data_l_739[_data_n_739] = {
    -1.084676512416e12,
    7.634832149392e12,
    -2.8299910066112e13,
    5.7494373464592e13,
    -6.4728375139872e13,
    3.9689578055808e13,
    -1.255090401792e13,
    1.8109925568e12,
    -8.71782912e10,
    1.0e+00,
    -6.5504e4,
    6.240789e7,
    -9.29252692e9,
    4.2982600634e11,
    -8.308444327968e12,
    7.8391384831312e13,
    -3.9436558781552e14,
    1.11174747256968e15,
    -1.79717122069056e15,
    1.666424486271456e15,
    -8.65023253219584e14,
    2.3690827154304e14
  };
#define _data_n_740 2
  static real_4 _data_l_740[_data_n_740] = {
    -3.01963769856e13,
    1.307674368e12
  };
#define _data_n_741 15
  static real_4 _data_l_741[_data_n_741] = {
    1.0e0,
    1.0e0,
    1.0e0,
    1.0e0,
    3.1e0,
    5.18e0,
    11.7e0,
    29.8e0,
    90.4e0,
    297.0e0,
    1070.0e0,
    4290.0e0,
    18100.0e0,
    84700.0e0,
    408000.0e0
  };
#define _data_n_742 1
  static real_4 _data_l_742[_data_n_742] = {
    8.86226925452758014e-1
  };
  if (__calls[34].calls == 0) {
    _data_k_735 = 0;
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[0] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[1] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[2] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[3] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[4] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[5] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[6] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[7] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[8] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[9] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[10] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[11] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[12] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[13] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[14] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[15] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[16] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[17] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[18] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[19] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[20] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[21] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[22] = _data_l_735[_data_k_735++];
    if (_data_k_735 >= _data_n_735) {
      _data_k_735 = 0;
    }
    b_[23] = _data_l_735[_data_k_735++];
  }
  if (__calls[34].calls == 0) {
    _data_k_736 = 0;
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[24] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[25] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[26] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[27] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[28] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[29] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[30] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[31] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[32] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[33] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[34] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[35] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[36] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[37] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[38] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[39] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[40] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[41] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[42] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[43] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[44] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[45] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[46] = _data_l_736[_data_k_736++];
    if (_data_k_736 >= _data_n_736) {
      _data_k_736 = 0;
    }
    b_[47] = _data_l_736[_data_k_736++];
  }
  if (__calls[34].calls == 0) {
    _data_k_737 = 0;
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[48] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[49] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[50] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[51] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[52] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[53] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[54] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[55] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[56] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[57] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[58] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[59] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[60] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[61] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[62] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[63] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[64] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[65] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[66] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[67] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[68] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[69] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[70] = _data_l_737[_data_k_737++];
    if (_data_k_737 >= _data_n_737) {
      _data_k_737 = 0;
    }
    b_[71] = _data_l_737[_data_k_737++];
  }
  if (__calls[34].calls == 0) {
    _data_k_738 = 0;
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[72] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[73] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[74] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[75] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[76] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[77] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[78] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[79] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[80] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[81] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[82] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[83] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[84] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[85] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[86] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[87] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[88] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[89] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[90] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[91] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[92] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[93] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[94] = _data_l_738[_data_k_738++];
    if (_data_k_738 >= _data_n_738) {
      _data_k_738 = 0;
    }
    b_[95] = _data_l_738[_data_k_738++];
  }
  if (__calls[34].calls == 0) {
    _data_k_739 = 0;
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[96] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[97] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[98] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[99] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[100] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[101] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[102] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[103] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[104] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[105] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[106] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[107] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[108] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[109] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[110] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[111] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[112] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[113] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[114] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[115] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[116] = _data_l_739[_data_k_739++];
    if (_data_k_739 >= _data_n_739) {
      _data_k_739 = 0;
    }
    b_[117] = _data_l_739[_data_k_739++];
  }
  if (__calls[34].calls == 0) {
    _data_k_740 = 0;
    if (_data_k_740 >= _data_n_740) {
      _data_k_740 = 0;
    }
    b_[118] = _data_l_740[_data_k_740++];
    if (_data_k_740 >= _data_n_740) {
      _data_k_740 = 0;
    }
    b_[119] = _data_l_740[_data_k_740++];
  }
  if (__calls[34].calls == 0) {
    _data_k_741 = 0;
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[0] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[1] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[2] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[3] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[4] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[5] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[6] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[7] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[8] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[9] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[10] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[11] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[12] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[13] = _data_l_741[_data_k_741++];
    if (_data_k_741 >= _data_n_741) {
      _data_k_741 = 0;
    }
    bnd_[14] = _data_l_741[_data_k_741++];
  }
  if (__calls[34].calls == 0) {
    _data_k_742 = 0;
    if (_data_k_742 >= _data_n_742) {
      _data_k_742 = 0;
    }
    hrtpi_ = _data_l_742[_data_k_742++];
  }
  (*ierr_) = 0;
  tol_ = _max (_r1mach (($0_ = 4, &$0_)), 1.0e-18);
  fln_ = (*n_);
  rz_ = 1.0e0 / ((*x_) + fln_);
  rzx_ = (*x_) * rz_;
  z_ = 0.5e0 * ((*x_) + fln_);
  if ((*ind_) > 1) {
    goto _l10;
  }
  (*gmrn_) = _gamrn (&z_);
  _l10:;
  gs_ = hrtpi_ * (*gmrn_);
  g1_ = gs_ + gs_;
  rg1_ = 1.0e0 / g1_;
  (*gmrn_) = (rz_ + rz_) / (*gmrn_);
  if ((*ind_) > 1) {
    goto _l70;
  }
  hn_ = 0.5e0 * fln_;
  den2_ = (*ktrms_) + (*ktrms_) + (*n_);
  den3_ = den2_ - 2.0e0;
  den1_ = (*x_) + den2_;
  err_ = rg1_ * ((*x_) + (*x_)) / (den1_ - 1.0e0);
  if ((*n_) == 0) {
    goto _l20;
  }
  rat_ = 1.0e0 / (fln_ * fln_);
  _l20:;
  if ((*ktrms_) == 0) {
    goto _l30;
  }
  fj_ = (*ktrms_);
  rat_ = 0.25e0 / (hrtpi_ * den3_ * sqrtf (fj_));
  _l30:;
  err_ = err_ * rat_;
  fj_ = -3.0;
  for (j_ = 1; j_ <= 15; (j_)++) {
    if (j_ <= 5) {
      err_ = err_ / den1_;
    }
    fm1_ = _max (1.0, fj_);
    fj_ = fj_ + 1.0e0;
    er_ = bnd_[j_ - 1] * err_;
    if ((*ktrms_) == 0) {
      goto _l40;
    }
    er_ = er_ / fm1_;
    if (er_ < tol_) {
      goto _l60;
    }
    if (j_ >= 5) {
      err_ = err_ / den3_;
    }
    goto _l50;
    _l40:;
    er_ = er_ * (1.0e0 + hn_ / fm1_);
    if (er_ < tol_) {
      goto _l60;
    }
    if (j_ >= 5) {
      err_ = err_ / fln_;
    }
    _l50:;
  }
  goto _l200;
  _l60:;
  (*ms_) = j_;
  _l70:;
  mm_ = (*ms_) + (*ms_);
  mp_ = mm_ + 1;
  if ((*ind_) > 1) {
    goto _l80;
  }
  (void) _hkseq (&z_, &mm_, h_, ierr_);
  goto _l100;
  _l80:;
  rat_ = z_ / (z_ - 0.5e0);
  rxp_ = rat_;
  for (i_ = 1; i_ <= mm_; (i_)++) {
    h_[i_ - 1] = rxp_ * (1.0e0 - h_[i_ - 1]);
    rxp_ = rxp_ * rat_;
  }
  _l100:;
  s_[0] = 1.0;
  fk_ = 1.0;
  for (k_ = 2; k_ <= mp_; (k_)++) {
    ss_ = 0.0;
    km_ = k_ - 1;
    i_ = km_;
    for (j_ = 1; j_ <= km_; (j_)++) {
      ss_ = ss_ + s_[j_ - 1] * h_[i_ - 1];
      i_ = i_ - 1;
    }
    s_[k_ - 1] = ss_ / fk_;
    fk_ = fk_ + 1.0e0;
  }
  if ((*ktrms_) == 0) {
    goto _l160;
  }
  fk_ = 0.0;
  ss_ = 0.0;
  rg1_ = rg1_ / z_;
  for (k_ = 1; k_ <= (*ktrms_); (k_)++) {
    v_[k_ - 1] = z_ / (z_ + fk_);
    w_[k_ - 1] = t_[k_ - 1] * v_[k_ - 1];
    ss_ = ss_ + w_[k_ - 1];
    fk_ = fk_ + 1.0e0;
  }
  s_[0] = s_[0] - ss_ * rg1_;
  for (i_ = 2; i_ <= mp_; (i_)++) {
    ss_ = 0.0;
    for (k_ = 1; k_ <= (*ktrms_); (k_)++) {
      w_[k_ - 1] = w_[k_ - 1] * v_[k_ - 1];
      ss_ = ss_ + w_[k_ - 1];
    }
    s_[i_ - 1] = s_[i_ - 1] - ss_ * rg1_;
  }
  _l160:;
  sumj_ = 0.0;
  jn_ = 1;
  rxp_ = 1.0;
  xp_[0] = 1.0;
  for (j_ = 1; j_ <= (*ms_); (j_)++) {
    jn_ = jn_ + j_ - 1;
    xp_[j_ + 1 - 1] = xp_[j_ - 1] * rzx_;
    rxp_ = rxp_ * rz_;
    sumi_ = 0.0;
    ii_ = jn_;
    for (i_ = 1; i_ <= j_; (i_)++) {
      jmi_ = j_ - i_ + 1;
      kk_ = j_ + i_ + 1;
      for (k_ = 1; k_ <= jmi_; (k_)++) {
        v_[k_ - 1] = s_[kk_ - 1] * xp_[k_ - 1];
        kk_ = kk_ + 1;
      }
      (void) _bdiff (&jmi_, v_);
      sumi_ = sumi_ + b_[ii_ - 1] * v_[jmi_ - 1] * xp_[i_ + 1 - 1];
      ii_ = ii_ + 1;
    }
    sumj_ = sumj_ + sumi_ * rxp_;
  }
  (*ans_) = gs_ * (s_[0] - sumj_);
  goto _l0;
  _l200:;
  (*ierr_) = 2;
  _l0:;
  __calls[34].calls++;
  return 0;
}

int_4 _bkisr (real_4 _p_ x_, int_4 _p_ n_, real_4 _p_ sum_, int_4 _p_ ierr_)
{
  static int_4 i_, k_, kk_, kkn_, k1_, np_;
  static real_4 ak_, atol_, bk_, c_[2], fk_, fn_, hx_, hxs_, pol_, pr_, tkp_, tol_, trm_, xln_;
  int_4 _data_k_743, $0_, $1_, $2_, $3_;
  extern real_4 _psixn ();
  extern real_4 _r1mach ();
#define _data_n_743 2
  static real_4 _data_l_743[_data_n_743] = {
    1.57079632679489662e+00,
    1.0e0
  };
  if (__calls[35].calls == 0) {
    _data_k_743 = 0;
    if (_data_k_743 >= _data_n_743) {
      _data_k_743 = 0;
    }
    c_[0] = _data_l_743[_data_k_743++];
    if (_data_k_743 >= _data_n_743) {
      _data_k_743 = 0;
    }
    c_[1] = _data_l_743[_data_k_743++];
  }
  (*ierr_) = 0;
  tol_ = _max (_r1mach (($0_ = 4, &$0_)), 1.0e-18);
  if ((*x_) < tol_) {
    goto _l50;
  }
  pr_ = 1.0;
  pol_ = 0.0;
  if ((*n_) == 0) {
    goto _l20;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    pol_ = -pol_ * (*x_) + c_[i_ - 1];
    pr_ = pr_ * (*x_) / i_;
  }
  _l20:;
  hx_ = (*x_) * 0.5e0;
  hxs_ = hx_ * hx_;
  xln_ = logf (hx_);
  np_ = (*n_) + 1;
  tkp_ = 3.0;
  fk_ = 2.0;
  fn_ = (*n_);
  bk_ = 4.0;
  ak_ = 2.0e0 / ((fn_ + 1.0e0) * (fn_ + 2.0e0));
  (*sum_) = ak_ * (_psixn (($1_ = (*n_) + 3, &$1_)) - _psixn (($2_ = 3, &$2_)) + _psixn (($3_ = 2, &$3_)) - xln_);
  atol_ = (*sum_) * tol_ * 0.75e0;
  for (k_ = 2; k_ <= 20; (k_)++) {
    ak_ = ak_ * (hxs_ / bk_) * ((tkp_ + 1.0e0) / (tkp_ + fn_ + 1.0e0)) * (tkp_ / (tkp_ + fn_));
    k1_ = k_ + 1;
    kk_ = k1_ + k_;
    kkn_ = kk_ + (*n_);
    trm_ = (_psixn (&k1_) + _psixn (&kkn_) - _psixn (&kk_) - xln_) * ak_;
    (*sum_) = (*sum_) + trm_;
    if (_abs (trm_) <= atol_) {
      goto _l40;
    }
    tkp_ = tkp_ + 2.0e0;
    bk_ = bk_ + tkp_;
    fk_ = fk_ + 1.0e0;
  }
  goto _l80;
  _l40:;
  (*sum_) = ((*sum_) * hxs_ + _psixn (&np_) - xln_) * pr_;
  if ((*n_) == 1) {
    (*sum_) = -(*sum_);
  }
  (*sum_) = pol_ + (*sum_);
  goto _l0;
  _l50:;
  if ((*n_) > 0) {
    goto _l60;
  }
  hx_ = (*x_) * 0.5e0;
  (*sum_) = _psixn (&_k1) - logf (hx_);
  goto _l0;
  _l60:;
  (*sum_) = c_[(*n_) - 1];
  goto _l0;
  _l80:;
  (*ierr_) = 2;
  _l0:;
  __calls[35].calls++;
  return 0;
}

int_4 _bskin (real_4 _p_ x_, int_4 _p_ n_, int_4 _p_ kode_, int_4 _p_ m_, real_4 _p_ y_, int_4 _p_ nz_, int_4 _p_ ierr_
)
{
  static int_4 i_, icase_, il_, i1m_, k_, kk_, ktrms_, m3_, ne_, nflg_, nl_, nlim_, nn_, np_, ns_, nt_;
  static real_4 a_[50], enlim_, exi_[102], fn_, gr_, h_[31], hn_, hrtpi_, ss_, tol_, t1_, t2_, w_, xlim_, xnlim_, xp_, 
  ys_[3], yss_[3];
  int_4 _data_k_744, _data_k_745, _data_k_746, _data_k_747, $0_, $1_, $2_, $3_, $4_, $5_;
  extern int_4 _i1mach ();
  extern real_4 _gamrn ();
  extern real_4 _r1mach ();
#define _data_n_744 24
  static real_4 _data_l_744[_data_n_744] = {
    1.0e+00,
    5.0e-1,
    3.75e-1,
    3.125e-1,
    2.734375e-1,
    2.4609375e-1,
    2.255859375e-1,
    2.0947265625e-1,
    1.96380615234375e-1,
    1.854705810546875e-1,
    1.76197052001953125e-1,
    1.68188095092773438e-1,
    1.61180257797241211e-1,
    1.54981017112731934e-1,
    1.49445980787277222e-1,
    1.44464448094367981e-1,
    1.39949934091418982e-1,
    1.35833759559318423e-1,
    1.32060599571559578e-1,
    1.28585320635465905e-1,
    1.25370687619579257e-1,
    1.22385671247684513e-1,
    1.19604178719328047e-1,
    1.17004087877603524e-1
  };
#define _data_n_745 24
  static real_4 _data_l_745[_data_n_745] = {
    1.14566502713486784e-1,
    1.12275172659217048e-1,
    1.10116034723462874e-1,
    1.08076848895250599e-1,
    1.06146905164978267e-1,
    1.04316786110409676e-1,
    1.02578173008569515e-1,
    1.00923686347140974e-1,
    9.93467537479668965e-2,
    9.78414999033007314e-2,
    9.64026543164874854e-2,
    9.50254735405376642e-2,
    9.37056752969190855e-2,
    9.243938238750126e-2,
    9.12230747245078224e-2,
    9.00535481254756708e-2,
    8.89278787739072249e-2,
    8.78433924473961612e-2,
    8.67976377754033498e-2,
    8.57883629175498224e-2,
    8.48134951571231199e-2,
    8.38711229887106408e-2,
    8.29594803475290034e-2,
    8.20769326842574183e-2
  };
#define _data_n_746 2
  static real_4 _data_l_746[_data_n_746] = {
    8.12219646354630702e-2,
    8.03931690779583449e-2
  };
#define _data_n_747 1
  static real_4 _data_l_747[_data_n_747] = {
    8.86226925452758014e-1
  };
  if (__calls[36].calls == 0) {
    _data_k_744 = 0;
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[0] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[1] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[2] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[3] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[4] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[5] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[6] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[7] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[8] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[9] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[10] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[11] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[12] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[13] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[14] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[15] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[16] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[17] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[18] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[19] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[20] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[21] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[22] = _data_l_744[_data_k_744++];
    if (_data_k_744 >= _data_n_744) {
      _data_k_744 = 0;
    }
    a_[23] = _data_l_744[_data_k_744++];
  }
  if (__calls[36].calls == 0) {
    _data_k_745 = 0;
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[24] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[25] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[26] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[27] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[28] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[29] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[30] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[31] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[32] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[33] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[34] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[35] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[36] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[37] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[38] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[39] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[40] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[41] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[42] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[43] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[44] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[45] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[46] = _data_l_745[_data_k_745++];
    if (_data_k_745 >= _data_n_745) {
      _data_k_745 = 0;
    }
    a_[47] = _data_l_745[_data_k_745++];
  }
  if (__calls[36].calls == 0) {
    _data_k_746 = 0;
    if (_data_k_746 >= _data_n_746) {
      _data_k_746 = 0;
    }
    a_[48] = _data_l_746[_data_k_746++];
    if (_data_k_746 >= _data_n_746) {
      _data_k_746 = 0;
    }
    a_[49] = _data_l_746[_data_k_746++];
  }
  if (__calls[36].calls == 0) {
    _data_k_747 = 0;
    if (_data_k_747 >= _data_n_747) {
      _data_k_747 = 0;
    }
    hrtpi_ = _data_l_747[_data_k_747++];
  }
  (*ierr_) = 0;
  (*nz_) = 0;
  if ((*x_) < 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*n_) < 0) {
    (*ierr_) = 1;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    (*ierr_) = 1;
  }
  if ((*m_) < 1) {
    (*ierr_) = 1;
  }
  if ((*x_) == 0.0e0 && (*n_) == 0) {
    (*ierr_) = 1;
  }
  if ((*ierr_) != 0) {
    goto _l0;
  }
  if ((*x_) == 0.0e0) {
    goto _l300;
  }
  i1m_ = -_i1mach (($0_ = 12, &$0_));
  t1_ = 2.3026e0 * _r1mach (($1_ = 5, &$1_)) * i1m_;
  xlim_ = t1_ - 3.228086e0;
  t2_ = t1_ + (*n_) + (*m_) - 1;
  if (t2_ > 1000.0e0) {
    xlim_ = t1_ - 0.5e0 * (logf (t2_) - 0.451583e0);
  }
  if ((*x_) > xlim_ && (*kode_) == 1) {
    goto _l320;
  }
  tol_ = _max (_r1mach (($2_ = 4, &$2_)), 1.0e-18);
  i1m_ = _i1mach (($3_ = 11, &$3_));
  xnlim_ = 0.287823e0 * (i1m_ - 1) * _r1mach (($4_ = 5, &$4_));
  enlim_ = expf (xnlim_);
  nlim_ = (int_4) (_aintd (enlim_)) + 2;
  nlim_ = _min (100, nlim_);
  nlim_ = _max (20, nlim_);
  m3_ = _min ((*m_), 3);
  nl_ = (*n_) + (*m_) - 1;
  if ((*x_) > 2.0e0) {
    goto _l130;
  }
  if ((*n_) > nlim_) {
    goto _l280;
  }
  nflg_ = 0;
  nn_ = (*n_);
  if (nl_ <= 2) {
    goto _l60;
  }
  m3_ = 3;
  nn_ = 0;
  nflg_ = 1;
  _l60:;
  xp_ = 1.0;
  if ((*kode_) == 2) {
    xp_ = expf ((*x_));
  }
  for (i_ = 1; i_ <= m3_; (i_)++) {
    (void) _bkisr (x_, &nn_, &w_, ierr_);
    if ((*ierr_) != 0) {
      goto _l0;
    }
    w_ = w_ * xp_;
    if (nn_ < (*n_)) {
      goto _l70;
    }
    kk_ = nn_ - (*n_) + 1;
    y_[kk_ - 1] = w_;
    _l70:;
    ys_[i_ - 1] = w_;
    nn_ = nn_ + 1;
  }
  if (nflg_ == 0) {
    goto _l0;
  }
  ns_ = nn_;
  xp_ = 1.0;
  _l90:;
  fn_ = ns_ - 1;
  il_ = nl_ - ns_ + 1;
  if (il_ <= 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= il_; (i_)++) {
    t1_ = ys_[1];
    t2_ = ys_[2];
    ys_[2] = ((*x_) * (ys_[0] - ys_[2]) + (fn_ - 1.0e0) * ys_[1]) / fn_;
    ys_[1] = t2_;
    ys_[0] = t1_;
    fn_ = fn_ + 1.0e0;
    if (ns_ < (*n_)) {
      goto _l100;
    }
    kk_ = ns_ - (*n_) + 1;
    y_[kk_ - 1] = ys_[2] * xp_;
    _l100:;
    ns_ = ns_ + 1;
  }
  goto _l0;
  _l130:;
  w_ = (*x_) + 0.5e0;
  nt_ = (int_4) (_aintd (w_));
  if (nl_ > nt_) {
    goto _l270;
  }
  icase_ = 0;
  nn_ = nl_;
  nflg_ = _min ((*m_) - m3_, 1);
  _l140:;
  kk_ = (nlim_ - nn_) / 2;
  ktrms_ = _max (0, kk_);
  ns_ = nn_ + 1;
  np_ = nn_ - m3_ + 1;
  xp_ = 1.0;
  if ((*kode_) == 1) {
    xp_ = expf (-(*x_));
  }
  for (i_ = 1; i_ <= m3_; (i_)++) {
    kk_ = i_;
    (void) _bkias (x_, &np_, &ktrms_, a_, &w_, &kk_, &ne_, &gr_, h_, ierr_);
    if ((*ierr_) != 0) {
      goto _l0;
    }
    ys_[i_ - 1] = w_;
    np_ = np_ + 1;
  }
  if (ktrms_ == 0) {
    goto _l160;
  }
  ne_ = ktrms_ + ktrms_ + 1;
  np_ = nn_ - m3_ + 2;
  (void) _exint (x_, &np_, ($5_ = 2, &$5_), &ne_, &tol_, exi_, nz_, ierr_);
  if ((*nz_) != 0) {
    goto _l320;
  }
  if ((*ierr_) == 2) {
    goto _l0;
  }
  _l160:;
  for (i_ = 1; i_ <= m3_; (i_)++) {
    ss_ = 0.0;
    if (ktrms_ == 0) {
      goto _l180;
    }
    kk_ = i_ + ktrms_ + ktrms_ - 2;
    il_ = ktrms_;
    for (k_ = 1; k_ <= ktrms_; (k_)++) {
      ss_ = ss_ + a_[il_ - 1] * exi_[kk_ - 1];
      kk_ = kk_ - 2;
      il_ = il_ - 1;
    }
    _l180:;
    ys_[i_ - 1] = ys_[i_ - 1] + ss_;
  }
  if (icase_ == 1) {
    goto _l200;
  }
  if (nflg_ != 0) {
    goto _l220;
  }
  _l200:;
  for (i_ = 1; i_ <= m3_; (i_)++) {
    y_[i_ - 1] = ys_[i_ - 1] * xp_;
  }
  if (icase_ == 1 && nflg_ == 1) {
    goto _l90;
  }
  goto _l0;
  _l220:;
  kk_ = nn_ - (*n_) + 1;
  k_ = m3_;
  for (i_ = 1; i_ <= m3_; (i_)++) {
    y_[kk_ - 1] = ys_[k_ - 1] * xp_;
    yss_[i_ - 1] = ys_[i_ - 1];
    kk_ = kk_ - 1;
    k_ = k_ - 1;
  }
  il_ = kk_;
  if (il_ <= 0) {
    goto _l250;
  }
  fn_ = nn_ - 3;
  for (i_ = 1; i_ <= il_; (i_)++) {
    t1_ = ys_[1];
    t2_ = ys_[0];
    ys_[0] = ys_[1] + ((fn_ + 2.0e0) * ys_[2] - (fn_ + 1.0e0) * ys_[0]) / (*x_);
    ys_[1] = t2_;
    ys_[2] = t1_;
    y_[kk_ - 1] = ys_[0] * xp_;
    kk_ = kk_ - 1;
    fn_ = fn_ - 1.0e0;
  }
  _l250:;
  if (icase_ != 2) {
    goto _l0;
  }
  for (i_ = 1; i_ <= m3_; (i_)++) {
    ys_[i_ - 1] = yss_[i_ - 1];
  }
  goto _l90;
  _l270:;
  if ((*n_) < nt_) {
    goto _l290;
  }
  _l280:;
  nn_ = (*n_) + m3_ - 1;
  nflg_ = _min ((*m_) - m3_, 1);
  icase_ = 1;
  goto _l140;
  _l290:;
  nn_ = nt_ + 1;
  nflg_ = _min ((*m_) - m3_, 1);
  icase_ = 2;
  goto _l140;
  _l300:;
  fn_ = (*n_);
  hn_ = 0.5e0 * fn_;
  gr_ = _gamrn (&hn_);
  y_[0] = hrtpi_ * gr_;
  if ((*m_) == 1) {
    goto _l0;
  }
  y_[1] = hrtpi_ / (hn_ * gr_);
  if ((*m_) == 2) {
    goto _l0;
  }
  for (k_ = 3; k_ <= (*m_); (k_)++) {
    y_[k_ - 1] = fn_ * y_[k_ - 2 - 1] / (fn_ + 1.0e0);
    fn_ = fn_ + 1.0e0;
  }
  goto _l0;
  _l320:;
  (*nz_) = (*m_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    y_[i_ - 1] = 0.0;
  }
  _l0:;
  __calls[36].calls++;
  return 0;
}

int_4 _bspev (real_4 _p_ t_, real_4 _p_ ad_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ nderiv_, real_4 _p_ x_, int_4 _p_ 
inev_, real_4 _p_ svalue_, real_4 _p_ work_)
{
  static int_4 i_, id_, iwork_, jj_, kp1_, kp1mn_, l_, left_, ll_, mflag_;
  static real_4 sum_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  if ((*k_) < 1) {
    goto _l100;
  }
  if ((*n_) < (*k_)) {
    goto _l105;
  }
  if ((*nderiv_) < 1 || (*nderiv_) > (*k_)) {
    goto _l115;
  }
  id_ = (*nderiv_);
  (void) _intrv (t_, ($0_ = (*n_) + 1, &$0_), x_, inev_, &i_, &mflag_);
  if ((*x_) < t_[(*k_) - 1]) {
    goto _l110;
  }
  if (mflag_ == 0) {
    goto _l30;
  }
  if ((*x_) > t_[i_ - 1]) {
    goto _l110;
  }
  _l20:;
  if (i_ == (*k_)) {
    goto _l120;
  }
  i_ = i_ - 1;
  if ((*x_) == t_[i_ - 1]) {
    goto _l20;
  }
  _l30:;
  kp1mn_ = (*k_) + 1 - id_;
  kp1_ = (*k_) + 1;
  (void) _bspvn (t_, &kp1mn_, k_, &_k1, x_, &i_, &work_[0], &work_[kp1_ - 1], &iwork_);
  jj_ = ((*n_) + (*n_) - id_ + 2) * (id_ - 1) / 2;
  _l40:;
  left_ = i_ - kp1mn_;
  sum_ = 0.0;
  ll_ = left_ + jj_ + 2 - id_;
  for (l_ = 1; l_ <= kp1mn_; (l_)++) {
    sum_ = sum_ + work_[l_ - 1] * ad_[ll_ - 1];
    ll_ = ll_ + 1;
  }
  svalue_[id_ - 1] = sum_;
  id_ = id_ - 1;
  if (id_ == 0) {
    goto _l60;
  }
  jj_ = jj_ - ((*n_) - id_ + 1);
  kp1mn_ = kp1mn_ + 1;
  (void) _bspvn (t_, &kp1mn_, k_, ($1_ = 2, &$1_), x_, &i_, &work_[0], &work_[kp1_ - 1], &iwork_);
  goto _l40;
  _l60:;
  goto _l0;
  _l100:;
  (void) _xermsg (_dc_0, _dc_94, _dc_71, ($2_ = 2, &$2_), &_k1);
  goto _l0;
  _l105:;
  (void) _xermsg (_dc_0, _dc_94, _dc_72, ($3_ = 2, &$3_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_94, _dc_95, ($4_ = 2, &$4_), &_k1);
  goto _l0;
  _l115:;
  (void) _xermsg (_dc_0, _dc_94, _dc_96, ($5_ = 2, &$5_), &_k1);
  goto _l0;
  _l120:;
  (void) _xermsg (_dc_0, _dc_94, _dc_97, ($6_ = 2, &$6_), &_k1);
  _l0:;
  __calls[37].calls++;
  return 0;
}

int_4 _bsppp (real_4 _p_ t_, real_4 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ ldc_, real_4 _p_ c_, real_4 _p_ xi_, 
int_4 _p_ lxi_, real_4 _p_ work_)
{
  static int_4 ileft_, inev_, nk_;
  int_4 $0_, $1_, $2_;
  if ((*k_) < 1) {
    goto _l100;
  }
  if ((*n_) < (*k_)) {
    goto _l105;
  }
  if ((*ldc_) < (*k_)) {
    goto _l110;
  }
  (void) _bspdr (t_, a_, n_, k_, k_, work_);
  (*lxi_) = 0;
  xi_[0] = t_[(*k_) - 1];
  inev_ = 1;
  nk_ = (*n_) * (*k_) + 1;
  for (ileft_ = (*k_); ileft_ <= (*n_); (ileft_)++) {
    if (t_[ileft_ + 1 - 1] == t_[ileft_ - 1]) {
      goto _l10;
    }
    (*lxi_) = (*lxi_) + 1;
    xi_[(*lxi_) + 1 - 1] = t_[ileft_ + 1 - 1];
    (void) _bspev (t_, &work_[0], n_, k_, k_, &xi_[(*lxi_) - 1], &inev_, &c_[0 + ((*ldc_)) * (((*lxi_) - 1))], &work_[nk_ - 
    1]);
    _l10:;
  }
  goto _l0;
  _l100:;
  (void) _xermsg (_dc_0, _dc_98, _dc_71, ($0_ = 2, &$0_), &_k1);
  goto _l0;
  _l105:;
  (void) _xermsg (_dc_0, _dc_98, _dc_72, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_98, _dc_99, ($2_ = 2, &$2_), &_k1);
  _l0:;
  __calls[38].calls++;
  return 0;
}

int_4 _bspvd (real_4 _p_ t_, int_4 _p_ k_, int_4 _p_ nderiv_, real_4 _p_ x_, int_4 _p_ ileft_, int_4 _p_ ldvnik_, 
real_4 _p_ vnikx_, real_4 _p_ work_)
{
  static int_4 i_, ideriv_, ipkmd_, j_, jj_, jlow_, jm_, jp1mid_, kmd_, kp1_, l_, ldummy_, m_, mhigh_, iwork_;
  static real_4 factor_, fkmd_, v_;
  int_4 $0_, $1_, $2_, $3_;
  if ((*k_) < 1) {
    goto _l200;
  }
  if ((*nderiv_) < 1 || (*nderiv_) > (*k_)) {
    goto _l205;
  }
  if ((*ldvnik_) < (*k_)) {
    goto _l210;
  }
  ideriv_ = (*nderiv_);
  kp1_ = (*k_) + 1;
  jj_ = kp1_ - ideriv_;
  (void) _bspvn (t_, &jj_, k_, &_k1, x_, ileft_, vnikx_, work_, &iwork_);
  if (ideriv_ == 1) {
    goto _l100;
  }
  mhigh_ = ideriv_;
  for (m_ = 2; m_ <= mhigh_; (m_)++) {
    jp1mid_ = 1;
    for (j_ = ideriv_; j_ <= (*k_); (j_)++) {
      vnikx_[j_ - 1 + ((*ldvnik_)) * ((ideriv_ - 1))] = vnikx_[jp1mid_ - 1 + ((*ldvnik_)) * ((0))];
      jp1mid_ = jp1mid_ + 1;
    }
    ideriv_ = ideriv_ - 1;
    jj_ = kp1_ - ideriv_;
    (void) _bspvn (t_, &jj_, k_, ($0_ = 2, &$0_), x_, ileft_, vnikx_, work_, &iwork_);
  }
  jm_ = kp1_ * (kp1_ + 1) / 2;
  for (l_ = 1; l_ <= jm_; (l_)++) {
    work_[l_ - 1] = 0.0;
  }
  l_ = 2;
  j_ = 0;
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    j_ = j_ + l_;
    work_[j_ - 1] = 1.0;
    l_ = l_ + 1;
  }
  kmd_ = (*k_);
  for (m_ = 2; m_ <= mhigh_; (m_)++) {
    kmd_ = kmd_ - 1;
    fkmd_ = kmd_;
    i_ = (*ileft_);
    j_ = (*k_);
    jj_ = j_ * (j_ + 1) / 2;
    jm_ = jj_ - j_;
    for (ldummy_ = 1; ldummy_ <= kmd_; (ldummy_)++) {
      ipkmd_ = i_ + kmd_;
      factor_ = fkmd_ / (t_[ipkmd_ - 1] - t_[i_ - 1]);
      for (l_ = 1; l_ <= j_; (l_)++) {
        work_[l_ + jj_ - 1] = (work_[l_ + jj_ - 1] - work_[l_ + jm_ - 1]) * factor_;
      }
      i_ = i_ - 1;
      j_ = j_ - 1;
      jj_ = jm_;
      jm_ = jm_ - j_;
    }
    for (i_ = 1; i_ <= (*k_); (i_)++) {
      v_ = 0.0;
      jlow_ = _max (i_, m_);
      jj_ = jlow_ * (jlow_ + 1) / 2;
      for (j_ = jlow_; j_ <= (*k_); (j_)++) {
        v_ = work_[i_ + jj_ - 1] * vnikx_[j_ - 1 + ((*ldvnik_)) * ((m_ - 1))] + v_;
        jj_ = jj_ + j_ + 1;
      }
      vnikx_[i_ - 1 + ((*ldvnik_)) * ((m_ - 1))] = v_;
    }
  }
  _l100:;
  goto _l0;
  _l200:;
  (void) _xermsg (_dc_0, _dc_100, _dc_71, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l205:;
  (void) _xermsg (_dc_0, _dc_100, _dc_96, ($2_ = 2, &$2_), &_k1);
  goto _l0;
  _l210:;
  (void) _xermsg (_dc_0, _dc_100, _dc_101, ($3_ = 2, &$3_), &_k1);
  _l0:;
  __calls[39].calls++;
  return 0;
}

int_4 _bsqad (real_4 _p_ t_, real_4 _p_ bcoef_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ 
bquad_, real_4 _p_ work_)
{
  static int_4 i_, il1_, il2_, ilo_, inbv_, jf_, left_, m_, mf_, mflag_, npk_, np1_;
  static real_4 a_, aa_, b_, bb_, bma_, bpa_, c1_, gpts_[9], gwts_[9], gx_, q_, sum_[5], ta_, tb_, y1_, y2_;
  int_4 _data_k_748, _data_k_749, $0_, $1_, $2_;
#define _data_n_748 9
  static real_4 _data_l_748[_data_n_748] = {
    5.77350269189625764e-1,
    2.38619186083196909e-1,
    6.61209386466264514e-1,
    9.32469514203152028e-1,
    1.48874338981631211e-1,
    4.33395394129247191e-1,
    6.79409568299024406e-1,
    8.65063366688984511e-1,
    9.7390652851717172e-1
  };
#define _data_n_749 9
  static real_4 _data_l_749[_data_n_749] = {
    1.0e+00,
    4.67913934572691047e-1,
    3.60761573048138608e-1,
    1.71324492379170345e-1,
    2.9552422471475287e-1,
    2.69266719309996355e-1,
    2.19086362515982044e-1,
    1.49451349150580593e-1,
    6.66713443086881376e-2
  };
  if (__calls[40].calls == 0) {
    _data_k_748 = 0;
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[0] = _data_l_748[_data_k_748++];
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[1] = _data_l_748[_data_k_748++];
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[2] = _data_l_748[_data_k_748++];
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[3] = _data_l_748[_data_k_748++];
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[4] = _data_l_748[_data_k_748++];
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[5] = _data_l_748[_data_k_748++];
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[6] = _data_l_748[_data_k_748++];
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[7] = _data_l_748[_data_k_748++];
    if (_data_k_748 >= _data_n_748) {
      _data_k_748 = 0;
    }
    gpts_[8] = _data_l_748[_data_k_748++];
  }
  if (__calls[40].calls == 0) {
    _data_k_749 = 0;
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[0] = _data_l_749[_data_k_749++];
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[1] = _data_l_749[_data_k_749++];
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[2] = _data_l_749[_data_k_749++];
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[3] = _data_l_749[_data_k_749++];
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[4] = _data_l_749[_data_k_749++];
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[5] = _data_l_749[_data_k_749++];
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[6] = _data_l_749[_data_k_749++];
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[7] = _data_l_749[_data_k_749++];
    if (_data_k_749 >= _data_n_749) {
      _data_k_749 = 0;
    }
    gwts_[8] = _data_l_749[_data_k_749++];
  }
  (*bquad_) = 0.0;
  if ((*k_) < 1 || (*k_) > 20) {
    goto _l65;
  }
  if ((*n_) < (*k_)) {
    goto _l70;
  }
  aa_ = _min ((*x1_), (*x2_));
  bb_ = _max ((*x1_), (*x2_));
  if (aa_ < t_[(*k_) - 1]) {
    goto _l60;
  }
  np1_ = (*n_) + 1;
  if (bb_ > t_[np1_ - 1]) {
    goto _l60;
  }
  if (aa_ == bb_) {
    goto _l0;
  }
  npk_ = (*n_) + (*k_);
  jf_ = 0;
  mf_ = 1;
  if ((*k_) <= 4) {
    goto _l10;
  }
  jf_ = 1;
  mf_ = 3;
  if ((*k_) <= 12) {
    goto _l10;
  }
  jf_ = 4;
  mf_ = 5;
  _l10:;
  for (i_ = 1; i_ <= mf_; (i_)++) {
    sum_[i_ - 1] = 0.0;
  }
  ilo_ = 1;
  inbv_ = 1;
  (void) _intrv (t_, &npk_, &aa_, &ilo_, &il1_, &mflag_);
  (void) _intrv (t_, &npk_, &bb_, &ilo_, &il2_, &mflag_);
  if (il2_ >= np1_) {
    il2_ = (*n_);
  }
  for (left_ = il1_; left_ <= il2_; (left_)++) {
    ta_ = t_[left_ - 1];
    tb_ = t_[left_ + 1 - 1];
    if (ta_ == tb_) {
      goto _l40;
    }
    a_ = _max (aa_, ta_);
    b_ = _min (bb_, tb_);
    bma_ = 0.5e0 * (b_ - a_);
    bpa_ = 0.5e0 * (b_ + a_);
    for (m_ = 1; m_ <= mf_; (m_)++) {
      c1_ = bma_ * gpts_[jf_ + m_ - 1];
      gx_ = -c1_ + bpa_;
      y2_ = _bvalu (t_, bcoef_, n_, k_, &_k0, &gx_, &inbv_, work_);
      gx_ = c1_ + bpa_;
      y1_ = _bvalu (t_, bcoef_, n_, k_, &_k0, &gx_, &inbv_, work_);
      sum_[m_ - 1] = sum_[m_ - 1] + (y1_ + y2_) * bma_;
    }
    _l40:;
  }
  q_ = 0.0;
  for (m_ = 1; m_ <= mf_; (m_)++) {
    q_ = q_ + gwts_[jf_ + m_ - 1] * sum_[m_ - 1];
  }
  if ((*x1_) > (*x2_)) {
    q_ = -q_;
  }
  (*bquad_) = q_;
  goto _l0;
  _l60:;
  (void) _xermsg (_dc_0, _dc_102, _dc_68, ($0_ = 2, &$0_), &_k1);
  goto _l0;
  _l65:;
  (void) _xermsg (_dc_0, _dc_102, _dc_103, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l70:;
  (void) _xermsg (_dc_0, _dc_102, _dc_72, ($2_ = 2, &$2_), &_k1);
  _l0:;
  __calls[40].calls++;
  return 0;
}

real_4 _bvalu (real_4 _p_ t_, real_4 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ ideriv_, real_4 _p_ x_, int_4 _p_ 
inbv_, real_4 _p_ work_)
{
  static int_4 i_, iderp1_, ihi_, ihmkmj_, ilo_, imk_, imkpj_, ipj_, ip1_, ip1mj_, j_, jj_, j1_, j2_, kmider_, kmj_, km1_
  , kpk_, mflag_;
  static real_4 bvalu_, fkmj_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  bvalu_ = 0.0;
  if ((*k_) < 1) {
    goto _l102;
  }
  if ((*n_) < (*k_)) {
    goto _l101;
  }
  if ((*ideriv_) < 0 || (*ideriv_) >= (*k_)) {
    goto _l110;
  }
  kmider_ = (*k_) - (*ideriv_);
  km1_ = (*k_) - 1;
  (void) _intrv (t_, ($0_ = (*n_) + 1, &$0_), x_, inbv_, &i_, &mflag_);
  if ((*x_) < t_[(*k_) - 1]) {
    goto _l120;
  }
  if (mflag_ == 0) {
    goto _l20;
  }
  if ((*x_) > t_[i_ - 1]) {
    goto _l130;
  }
  _l10:;
  if (i_ == (*k_)) {
    goto _l140;
  }
  i_ = i_ - 1;
  if ((*x_) == t_[i_ - 1]) {
    goto _l10;
  }
  _l20:;
  imk_ = i_ - (*k_);
  for (j_ = 1; j_ <= (*k_); (j_)++) {
    imkpj_ = imk_ + j_;
    work_[j_ - 1] = a_[imkpj_ - 1];
  }
  if ((*ideriv_) == 0) {
    goto _l60;
  }
  for (j_ = 1; j_ <= (*ideriv_); (j_)++) {
    kmj_ = (*k_) - j_;
    fkmj_ = kmj_;
    for (jj_ = 1; jj_ <= kmj_; (jj_)++) {
      ihi_ = i_ + jj_;
      ihmkmj_ = ihi_ - kmj_;
      work_[jj_ - 1] = (work_[jj_ + 1 - 1] - work_[jj_ - 1]) / (t_[ihi_ - 1] - t_[ihmkmj_ - 1]) * fkmj_;
    }
  }
  _l60:;
  if ((*ideriv_) == km1_) {
    goto _l100;
  }
  ip1_ = i_ + 1;
  kpk_ = (*k_) + (*k_);
  j1_ = (*k_) + 1;
  j2_ = kpk_ + 1;
  for (j_ = 1; j_ <= kmider_; (j_)++) {
    ipj_ = i_ + j_;
    work_[j1_ - 1] = t_[ipj_ - 1] - (*x_);
    ip1mj_ = ip1_ - j_;
    work_[j2_ - 1] = (*x_) - t_[ip1mj_ - 1];
    j1_ = j1_ + 1;
    j2_ = j2_ + 1;
  }
  iderp1_ = (*ideriv_) + 1;
  for (j_ = iderp1_; j_ <= km1_; (j_)++) {
    kmj_ = (*k_) - j_;
    ilo_ = kmj_;
    for (jj_ = 1; jj_ <= kmj_; (jj_)++) {
      work_[jj_ - 1] = (work_[jj_ + 1 - 1] * work_[kpk_ + ilo_ - 1] + work_[jj_ - 1] * work_[(*k_) + jj_ - 1]) / (work_[kpk_ 
      + ilo_ - 1] + work_[(*k_) + jj_ - 1]);
      ilo_ = ilo_ - 1;
    }
  }
  _l100:;
  bvalu_ = work_[0];
  goto _l0;
  _l101:;
  (void) _xermsg (_dc_0, _dc_104, _dc_72, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l102:;
  (void) _xermsg (_dc_0, _dc_104, _dc_71, ($2_ = 2, &$2_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_104, _dc_105, ($3_ = 2, &$3_), &_k1);
  goto _l0;
  _l120:;
  (void) _xermsg (_dc_0, _dc_104, _dc_106, ($4_ = 2, &$4_), &_k1);
  goto _l0;
  _l130:;
  (void) _xermsg (_dc_0, _dc_104, _dc_107, ($5_ = 2, &$5_), &_k1);
  goto _l0;
  _l140:;
  (void) _xermsg (_dc_0, _dc_104, _dc_97, ($6_ = 2, &$6_), &_k1);
  _l0:;
  __calls[41].calls++;
  return bvalu_;
}

complex_8 _c0lgmc (complex_8 _p_ z_)
{
  static real_4 rbig_, cabsz_;
  static complex_8 q_;
  int_4 _data_k_750, $0_;
  complex_8 c0lgmc_;
  extern real_4 _r1mach ();
#define _data_n_750 1
  static real_4 _data_l_750[_data_n_750] = {
    0.0
  };
  if (__calls[42].calls == 0) {
    _data_k_750 = 0;
    if (_data_k_750 >= _data_n_750) {
      _data_k_750 = 0;
    }
    rbig_ = _data_l_750[_data_k_750++];
  }
  if (rbig_ == 0.0) {
    rbig_ = 1.0 / _r1mach (($0_ = 3, &$0_));
  }
  cabsz_ = cabsf ((*z_));
  if (cabsz_ > rbig_) {
    c0lgmc_ = -((*z_) + 0.5) * clogf ((*z_)) - (*z_);
  }
  if (cabsz_ > rbig_) {
    goto _l0;
  }
  q_ = 1.0 / (*z_);
  if (cabsz_ <= 1.23) {
    c0lgmc_ = ((*z_) + 0.5) * clogf (1.0 + q_) - 1.0;
  }
  if (cabsz_ > 1.23) {
    c0lgmc_ = ((1.0 + .5 * q_) * _c9ln2r (&q_) - .25) * (q_ * q_);
  }
  _l0:;
  __calls[42].calls++;
  return c0lgmc_;
}

complex_8 _c9lgmc (complex_8 _p_ zin_)
{
  static int_4 nterm_, i_, ndx_;
  static logical_4 first_;
  static real_4 bern_[11], bound_, xbig_, xmax_, x_, y_, cabsz_;
  static complex_8 z_, z2inv_;
  int_4 _data_k_751, _data_k_752, _data_k_753, _data_k_754, _data_k_755, _data_k_756, _data_k_757, _data_k_758, 
  _data_k_759, _data_k_760, _data_k_761, _data_k_762, $0_, $1_, $2_, $3_, $5_, $6_, $7_, $8_;
  char_127 $4_;
  complex_8 c9lgmc_;
  extern real_4 _r1mach ();
#define _data_n_751 1
  static real_4 _data_l_751[_data_n_751] = {
    .083333333333333333e0
  };
#define _data_n_752 1
  static real_4 _data_l_752[_data_n_752] = {
    -.0027777777777777778e0
  };
#define _data_n_753 1
  static real_4 _data_l_753[_data_n_753] = {
    .00079365079365079365e0
  };
#define _data_n_754 1
  static real_4 _data_l_754[_data_n_754] = {
    -.00059523809523809524e0
  };
#define _data_n_755 1
  static real_4 _data_l_755[_data_n_755] = {
    .00084175084175084175e0
  };
#define _data_n_756 1
  static real_4 _data_l_756[_data_n_756] = {
    -.0019175269175269175e0
  };
#define _data_n_757 1
  static real_4 _data_l_757[_data_n_757] = {
    .0064102564102564103e0
  };
#define _data_n_758 1
  static real_4 _data_l_758[_data_n_758] = {
    -.029550653594771242e0
  };
#define _data_n_759 1
  static real_4 _data_l_759[_data_n_759] = {
    .17964437236883057e0
  };
#define _data_n_760 1
  static real_4 _data_l_760[_data_n_760] = {
    -1.3924322169059011e0
  };
#define _data_n_761 1
  static real_4 _data_l_761[_data_n_761] = {
    13.402864044168392e0
  };
#define _data_n_762 1
  static logical_4 _data_l_762[_data_n_762] = {
    TRUE
  };
  if (__calls[43].calls == 0) {
    _data_k_751 = 0;
    if (_data_k_751 >= _data_n_751) {
      _data_k_751 = 0;
    }
    bern_[0] = _data_l_751[_data_k_751++];
  }
  if (__calls[43].calls == 0) {
    _data_k_752 = 0;
    if (_data_k_752 >= _data_n_752) {
      _data_k_752 = 0;
    }
    bern_[1] = _data_l_752[_data_k_752++];
  }
  if (__calls[43].calls == 0) {
    _data_k_753 = 0;
    if (_data_k_753 >= _data_n_753) {
      _data_k_753 = 0;
    }
    bern_[2] = _data_l_753[_data_k_753++];
  }
  if (__calls[43].calls == 0) {
    _data_k_754 = 0;
    if (_data_k_754 >= _data_n_754) {
      _data_k_754 = 0;
    }
    bern_[3] = _data_l_754[_data_k_754++];
  }
  if (__calls[43].calls == 0) {
    _data_k_755 = 0;
    if (_data_k_755 >= _data_n_755) {
      _data_k_755 = 0;
    }
    bern_[4] = _data_l_755[_data_k_755++];
  }
  if (__calls[43].calls == 0) {
    _data_k_756 = 0;
    if (_data_k_756 >= _data_n_756) {
      _data_k_756 = 0;
    }
    bern_[5] = _data_l_756[_data_k_756++];
  }
  if (__calls[43].calls == 0) {
    _data_k_757 = 0;
    if (_data_k_757 >= _data_n_757) {
      _data_k_757 = 0;
    }
    bern_[6] = _data_l_757[_data_k_757++];
  }
  if (__calls[43].calls == 0) {
    _data_k_758 = 0;
    if (_data_k_758 >= _data_n_758) {
      _data_k_758 = 0;
    }
    bern_[7] = _data_l_758[_data_k_758++];
  }
  if (__calls[43].calls == 0) {
    _data_k_759 = 0;
    if (_data_k_759 >= _data_n_759) {
      _data_k_759 = 0;
    }
    bern_[8] = _data_l_759[_data_k_759++];
  }
  if (__calls[43].calls == 0) {
    _data_k_760 = 0;
    if (_data_k_760 >= _data_n_760) {
      _data_k_760 = 0;
    }
    bern_[9] = _data_l_760[_data_k_760++];
  }
  if (__calls[43].calls == 0) {
    _data_k_761 = 0;
    if (_data_k_761 >= _data_n_761) {
      _data_k_761 = 0;
    }
    bern_[10] = _data_l_761[_data_k_761++];
  }
  if (__calls[43].calls == 0) {
    _data_k_762 = 0;
    if (_data_k_762 >= _data_n_762) {
      _data_k_762 = 0;
    }
    first_ = _data_l_762[_data_k_762++];
  }
  if (first_) {
    nterm_ = -0.3 * logf (_r1mach (($0_ = 3, &$0_)));
    bound_ = 0.117 * nterm_ * powl ((0.1 * _r1mach (($1_ = 3, &$1_))), (-1.0 / (2 * nterm_ - 1)));
    xbig_ = 1.0 / sqrtf (_r1mach (($2_ = 3, &$2_)));
    xmax_ = expf (_min (logf (_r1mach (($3_ = 2, &$3_)) / 12.0), -logf (12.0 * _r1mach (&_k1))));
  }
  first_ = FALSE;
  z_ = (*zin_);
  x_ = (real_4) (crealf (z_));
  y_ = cimagf (z_);
  cabsz_ = cabsf (z_);
  if (x_ < 0.0 && _abs (y_) < bound_) {
    (void) _xermsg (_dc_0, _dc_108, concat ($4_, _dc_109, _dc_110), ($5_ = 2, &$5_), ($6_ = 2, &$6_));
  }
  if (cabsz_ < bound_) {
    (void) _xermsg (_dc_0, _dc_108, _dc_111, ($7_ = 3, &$7_), ($8_ = 2, &$8_));
  }
  if (cabsz_ >= xmax_) {
    goto _l50;
  }
  if (cabsz_ >= xbig_) {
    c9lgmc_ = 1.0 / (12.0 * z_);
  }
  if (cabsz_ >= xbig_) {
    goto _l0;
  }
  z2inv_ = 1.0 / (z_ * z_);
  c9lgmc_ = CMPLXF (0.0, 0.0);
  for (i_ = 1; i_ <= nterm_; (i_)++) {
    ndx_ = nterm_ + 1 - i_;
    c9lgmc_ = bern_[ndx_ - 1] + c9lgmc_ * z2inv_;
  }
  c9lgmc_ = c9lgmc_ / z_;
  goto _l0;
  _l50:;
  c9lgmc_ = CMPLXF (0.0, 0.0);
  (void) _xermsg (_dc_0, _dc_108, _dc_112, &_k1, &_k1);
  _l0:;
  __calls[43].calls++;
  return c9lgmc_;
}

complex_8 _c9ln2r (complex_8 _p_ z_)
{
  static real_4 x_, y_, cabsz_, xz_, yz_, arg_, rpart_, y1x_, aipart_;
  real_4 $0_, $1_;
  complex_8 c9ln2r_;
  x_ = (real_4) (crealf ((*z_)));
  y_ = cimagf ((*z_));
  cabsz_ = cabsf ((*z_));
  if (cabsz_ > 0.8125) {
    goto _l20;
  }
  c9ln2r_ = CMPLXF (3.3333333e-1, 0.0);
  if (cabsz_ == 0.0) {
    goto _l0;
  }
  xz_ = x_ / cabsz_;
  yz_ = y_ / cabsz_;
  arg_ = 2.0 * xz_ + cabsz_;
  rpart_ = 0.5 * (arg_ * arg_ * arg_) * _r9ln2r (($0_ = cabsz_ * arg_, &$0_)) - xz_ - 0.25 * cabsz_;
  y1x_ = yz_ / (1.0 + x_);
  aipart_ = y1x_ * ((xz_ * xz_) + (y1x_ * y1x_) * _r9atn1 (($1_ = cabsz_ * y1x_, &$1_)));
  c9ln2r_ = _up_complex_8 (CMPLXF (xz_, -yz_), 3) * CMPLXF (rpart_, aipart_);
  goto _l0;
  _l20:;
  c9ln2r_ = (clogf (1.0 + (*z_)) - (*z_) * (1.0 - 0.5 * (*z_))) / ((*z_) * (*z_) * (*z_));
  _l0:;
  __calls[44].calls++;
  return c9ln2r_;
}

int_4 _cacai (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ y_, int_4 
_p_ nz_, real_4 _p_ rl_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 inu_, iuf_, nn_, nw_;
  static real_4 arg_, ascle_, az_, cpn_, dfnu_, fmr_, pi_, sgn_, spn_, yy_;
  static complex_8 csgn_, cspn_, c1_, c2_, zn_, cy_[2];
  int_4 _data_k_763;
  extern real_4 _r1mach ();
#define _data_n_763 1
  static real_4 _data_l_763[_data_n_763] = {
    3.14159265358979324e0
  };
  if (__calls[45].calls == 0) {
    _data_k_763 = 0;
    if (_data_k_763 >= _data_n_763) {
      _data_k_763 = 0;
    }
    pi_ = _data_l_763[_data_k_763++];
  }
  (*nz_) = 0;
  zn_ = -(*z_);
  az_ = cabsf ((*z_));
  nn_ = (*n_);
  dfnu_ = (*fnu_) + ((*n_) - 1);
  if (az_ <= 2.0e0) {
    goto _l10;
  }
  if (az_ * az_ * 0.25e0 > dfnu_ + 1.0e0) {
    goto _l20;
  }
  _l10:;
  (void) _cseri (&zn_, fnu_, kode_, &nn_, y_, &nw_, tol_, elim_, alim_);
  goto _l40;
  _l20:;
  if (az_ < (*rl_)) {
    goto _l30;
  }
  (void) _casyi (&zn_, fnu_, kode_, &nn_, y_, &nw_, rl_, tol_, elim_, alim_);
  if (nw_ < 0) {
    goto _l70;
  }
  goto _l40;
  _l30:;
  (void) _cmlri (&zn_, fnu_, kode_, &nn_, y_, &nw_, tol_);
  if (nw_ < 0) {
    goto _l70;
  }
  _l40:;
  (void) _cbknu (&zn_, fnu_, kode_, &_k1, cy_, &nw_, tol_, elim_, alim_);
  if (nw_ != 0) {
    goto _l70;
  }
  fmr_ = (*mr_);
  sgn_ = -_sign (pi_, fmr_);
  csgn_ = CMPLXF (0.0, sgn_);
  if ((*kode_) == 1) {
    goto _l50;
  }
  yy_ = -cimagf (zn_);
  cpn_ = cosf (yy_);
  spn_ = sinf (yy_);
  csgn_ = csgn_ * CMPLXF (cpn_, spn_);
  _l50:;
  inu_ = (*fnu_);
  arg_ = ((*fnu_) - inu_) * sgn_;
  cpn_ = cosf (arg_);
  spn_ = sinf (arg_);
  cspn_ = CMPLXF (cpn_, spn_);
  if (_imod (inu_, 2) == 1) {
    cspn_ = -cspn_;
  }
  c1_ = cy_[0];
  c2_ = y_[0];
  if ((*kode_) == 1) {
    goto _l60;
  }
  iuf_ = 0;
  ascle_ = 1.0e3 * _r1mach (&_k1) / (*tol_);
  (void) _cs1s2 (&zn_, &c1_, &c2_, &nw_, &ascle_, alim_, &iuf_);
  (*nz_) = (*nz_) + nw_;
  _l60:;
  y_[0] = cspn_ * c1_ + csgn_ * c2_;
  goto _l0;
  _l70:;
  (*nz_) = -1;
  if (nw_ == -2) {
    (*nz_) = -2;
  }
  _l0:;
  __calls[45].calls++;
  return 0;
}

int_4 _cacon (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ y_, int_4 
_p_ nz_, real_4 _p_ rl_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, inu_, iuf_, kflag_, nn_, nw_;
  static real_4 arg_, ascle_, as2_, bscle_, bry_[3], cpn_, c1i_, c1m_, c1r_, fmr_, pi_, sgn_, spn_, yy_;
  static complex_8 ck_, cone_, cs_, cscl_, cscr_, csgn_, cspn_, css_[3], csr_[3], c1_, c2_, rz_, sc1_, sc2_, st_, s1_, 
  s2_, zn_, cy_[2];
  int_4 _data_k_764, _data_k_765, $0_;
  extern real_4 _r1mach ();
#define _data_n_764 1
  static real_4 _data_l_764[_data_n_764] = {
    3.14159265358979324e0
  };
#define _data_n_765 1
  static complex_8 _data_l_765[_data_n_765] = {
    CMPLXF (1.0, 0.0)
  };
  if (__calls[46].calls == 0) {
    _data_k_764 = 0;
    if (_data_k_764 >= _data_n_764) {
      _data_k_764 = 0;
    }
    pi_ = _data_l_764[_data_k_764++];
  }
  if (__calls[46].calls == 0) {
    _data_k_765 = 0;
    if (_data_k_765 >= _data_n_765) {
      _data_k_765 = 0;
    }
    cone_ = _data_l_765[_data_k_765++];
  }
  (*nz_) = 0;
  zn_ = -(*z_);
  nn_ = (*n_);
  (void) _cbinu (&zn_, fnu_, kode_, &nn_, y_, &nw_, rl_, fnul_, tol_, elim_, alim_);
  if (nw_ < 0) {
    goto _l80;
  }
  nn_ = _min (2, (*n_));
  (void) _cbknu (&zn_, fnu_, kode_, &nn_, cy_, &nw_, tol_, elim_, alim_);
  if (nw_ != 0) {
    goto _l80;
  }
  s1_ = cy_[0];
  fmr_ = (*mr_);
  sgn_ = -_sign (pi_, fmr_);
  csgn_ = CMPLXF (0.0, sgn_);
  if ((*kode_) == 1) {
    goto _l10;
  }
  yy_ = -cimagf (zn_);
  cpn_ = cosf (yy_);
  spn_ = sinf (yy_);
  csgn_ = csgn_ * CMPLXF (cpn_, spn_);
  _l10:;
  inu_ = (*fnu_);
  arg_ = ((*fnu_) - inu_) * sgn_;
  cpn_ = cosf (arg_);
  spn_ = sinf (arg_);
  cspn_ = CMPLXF (cpn_, spn_);
  if (_imod (inu_, 2) == 1) {
    cspn_ = -cspn_;
  }
  iuf_ = 0;
  c1_ = s1_;
  c2_ = y_[0];
  ascle_ = 1.0e3 * _r1mach (&_k1) / (*tol_);
  if ((*kode_) == 1) {
    goto _l20;
  }
  (void) _cs1s2 (&zn_, &c1_, &c2_, &nw_, &ascle_, alim_, &iuf_);
  (*nz_) = (*nz_) + nw_;
  sc1_ = c1_;
  _l20:;
  y_[0] = cspn_ * c1_ + csgn_ * c2_;
  if ((*n_) == 1) {
    goto _l0;
  }
  cspn_ = -cspn_;
  s2_ = cy_[1];
  c1_ = s2_;
  c2_ = y_[1];
  if ((*kode_) == 1) {
    goto _l30;
  }
  (void) _cs1s2 (&zn_, &c1_, &c2_, &nw_, &ascle_, alim_, &iuf_);
  (*nz_) = (*nz_) + nw_;
  sc2_ = c1_;
  _l30:;
  y_[1] = cspn_ * c1_ + csgn_ * c2_;
  if ((*n_) == 2) {
    goto _l0;
  }
  cspn_ = -cspn_;
  rz_ = CMPLXF (2.0, 0.0) / zn_;
  ck_ = CMPLXF ((*fnu_) + 1.0e0, 0.0) * rz_;
  cscl_ = CMPLXF (1.0e0 / (*tol_), 0.0);
  cscr_ = CMPLXF ((*tol_), 0.0);
  css_[0] = cscl_;
  css_[1] = cone_;
  css_[2] = cscr_;
  csr_[0] = cscr_;
  csr_[1] = cone_;
  csr_[2] = cscl_;
  bry_[0] = ascle_;
  bry_[1] = 1.0e0 / ascle_;
  bry_[2] = _r1mach (($0_ = 2, &$0_));
  as2_ = cabsf (s2_);
  kflag_ = 2;
  if (as2_ > bry_[0]) {
    goto _l40;
  }
  kflag_ = 1;
  goto _l50;
  _l40:;
  if (as2_ < bry_[1]) {
    goto _l50;
  }
  kflag_ = 3;
  _l50:;
  bscle_ = bry_[kflag_ - 1];
  s1_ = s1_ * css_[kflag_ - 1];
  s2_ = s2_ * css_[kflag_ - 1];
  cs_ = csr_[kflag_ - 1];
  for (i_ = 3; i_ <= (*n_); (i_)++) {
    st_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = st_;
    c1_ = s2_ * cs_;
    st_ = c1_;
    c2_ = y_[i_ - 1];
    if ((*kode_) == 1) {
      goto _l60;
    }
    if (iuf_ < 0) {
      goto _l60;
    }
    (void) _cs1s2 (&zn_, &c1_, &c2_, &nw_, &ascle_, alim_, &iuf_);
    (*nz_) = (*nz_) + nw_;
    sc1_ = sc2_;
    sc2_ = c1_;
    if (iuf_ != 3) {
      goto _l60;
    }
    iuf_ = -4;
    s1_ = sc1_ * css_[kflag_ - 1];
    s2_ = sc2_ * css_[kflag_ - 1];
    st_ = sc2_;
    _l60:;
    y_[i_ - 1] = cspn_ * c1_ + csgn_ * c2_;
    ck_ = ck_ + rz_;
    cspn_ = -cspn_;
    if (kflag_ >= 3) {
      goto _l70;
    }
    c1r_ = (real_4) (crealf (c1_));
    c1i_ = cimagf (c1_);
    c1r_ = _abs (c1r_);
    c1i_ = _abs (c1i_);
    c1m_ = _max (c1r_, c1i_);
    if (c1m_ <= bscle_) {
      goto _l70;
    }
    kflag_ = kflag_ + 1;
    bscle_ = bry_[kflag_ - 1];
    s1_ = s1_ * cs_;
    s2_ = st_;
    s1_ = s1_ * css_[kflag_ - 1];
    s2_ = s2_ * css_[kflag_ - 1];
    cs_ = csr_[kflag_ - 1];
    _l70:;
  }
  goto _l0;
  _l80:;
  (*nz_) = -1;
  if (nw_ == -2) {
    (*nz_) = -2;
  }
  _l0:;
  __calls[46].calls++;
  return 0;
}

complex_8 _cacos (complex_8 _p_ z_)
{
  static real_4 pi2_;
  int_4 _data_k_766;
  complex_8 cacos_;
#define _data_n_766 1
  static real_4 _data_l_766[_data_n_766] = {
    1.57079632679489661923e0
  };
  if (__calls[47].calls == 0) {
    _data_k_766 = 0;
    if (_data_k_766 >= _data_n_766) {
      _data_k_766 = 0;
    }
    pi2_ = _data_l_766[_data_k_766++];
  }
  cacos_ = pi2_ - _casin (z_);
  __calls[47].calls++;
  return cacos_;
}

complex_8 _cacosh (complex_8 _p_ z_)
{
  static complex_8 ci_;
  int_4 _data_k_767;
  complex_8 cacosh_;
#define _data_n_767 1
  static complex_8 _data_l_767[_data_n_767] = {
    CMPLXF (0.0, 1.0)
  };
  if (__calls[48].calls == 0) {
    _data_k_767 = 0;
    if (_data_k_767 >= _data_n_767) {
      _data_k_767 = 0;
    }
    ci_ = _data_l_767[_data_k_767++];
  }
  cacosh_ = ci_ * _cacos (z_);
  __calls[48].calls++;
  return cacosh_;
}

int_4 _cairy (complex_8 _p_ z_, int_4 _p_ id_, int_4 _p_ kode_, complex_8 _p_ ai_, int_4 _p_ nz_, int_4 _p_ ierr_)
{
  static int_4 iflag_, k_, k1_, k2_, mr_, nn_;
  static real_4 aa_, ad_, ak_, alim_, atrm_, az_, az3_, bk_, ck_, coef_, c1_, c2_, dig_, dk_, d1_, d2_, elim_, fid_, fnu_
  , rl_, r1m5_, sfac_, tol_, tth_, zi_, zr_, z3i_, z3r_, bb_, alaz_;
  static complex_8 cone_, csq_, cy_[1], s1_, s2_, trm1_, trm2_, zta_, z3_;
  int_4 _data_k_768, _data_k_769, $0_, $1_, $2_, $3_, $4_, $5_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
#define _data_n_768 4
  static real_4 _data_l_768[_data_n_768] = {
    6.66666666666666667e-1,
    3.5502805388781724e-1,
    2.58819403792806799e-1,
    1.83776298473930683e-1
  };
#define _data_n_769 1
  static complex_8 _data_l_769[_data_n_769] = {
    CMPLXF (1.0, 0.0)
  };
  if (__calls[49].calls == 0) {
    _data_k_768 = 0;
    if (_data_k_768 >= _data_n_768) {
      _data_k_768 = 0;
    }
    tth_ = _data_l_768[_data_k_768++];
    if (_data_k_768 >= _data_n_768) {
      _data_k_768 = 0;
    }
    c1_ = _data_l_768[_data_k_768++];
    if (_data_k_768 >= _data_n_768) {
      _data_k_768 = 0;
    }
    c2_ = _data_l_768[_data_k_768++];
    if (_data_k_768 >= _data_n_768) {
      _data_k_768 = 0;
    }
    coef_ = _data_l_768[_data_k_768++];
  }
  if (__calls[49].calls == 0) {
    _data_k_769 = 0;
    if (_data_k_769 >= _data_n_769) {
      _data_k_769 = 0;
    }
    cone_ = _data_l_769[_data_k_769++];
  }
  (*ierr_) = 0;
  (*nz_) = 0;
  if ((*id_) < 0 || (*id_) > 1) {
    (*ierr_) = 1;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    (*ierr_) = 1;
  }
  if ((*ierr_) != 0) {
    goto _l0;
  }
  az_ = cabsf ((*z_));
  tol_ = _max (_r1mach (($0_ = 4, &$0_)), 1.0e-18);
  fid_ = (*id_);
  if (az_ > 1.0e0) {
    goto _l60;
  }
  s1_ = cone_;
  s2_ = cone_;
  if (az_ < tol_) {
    goto _l160;
  }
  aa_ = az_ * az_;
  if (aa_ < tol_ / az_) {
    goto _l40;
  }
  trm1_ = cone_;
  trm2_ = cone_;
  atrm_ = 1.0;
  z3_ = (*z_) * (*z_) * (*z_);
  az3_ = az_ * aa_;
  ak_ = 2.0e0 + fid_;
  bk_ = 3.0e0 - fid_ - fid_;
  ck_ = 4.0e0 - fid_;
  dk_ = 3.0e0 + fid_ + fid_;
  d1_ = ak_ * dk_;
  d2_ = bk_ * ck_;
  ad_ = _min (d1_, d2_);
  ak_ = 24.0e0 + 9.0e0 * fid_;
  bk_ = 30.0e0 - 9.0e0 * fid_;
  z3r_ = (real_4) (crealf (z3_));
  z3i_ = cimagf (z3_);
  for (k_ = 1; k_ <= 25; (k_)++) {
    trm1_ = trm1_ * CMPLXF (z3r_ / d1_, z3i_ / d1_);
    s1_ = s1_ + trm1_;
    trm2_ = trm2_ * CMPLXF (z3r_ / d2_, z3i_ / d2_);
    s2_ = s2_ + trm2_;
    atrm_ = atrm_ * az3_ / ad_;
    d1_ = d1_ + ak_;
    d2_ = d2_ + bk_;
    ad_ = _min (d1_, d2_);
    if (atrm_ < tol_ * ad_) {
      goto _l40;
    }
    ak_ = ak_ + 18.0e0;
    bk_ = bk_ + 18.0e0;
  }
  _l40:;
  if ((*id_) == 1) {
    goto _l50;
  }
  (*ai_) = s1_ * CMPLXF (c1_, 0.0) - (*z_) * s2_ * CMPLXF (c2_, 0.0);
  if ((*kode_) == 1) {
    goto _l0;
  }
  zta_ = (*z_) * csqrtf ((*z_)) * CMPLXF (tth_, 0.0);
  (*ai_) = (*ai_) * cexpf (zta_);
  goto _l0;
  _l50:;
  (*ai_) = -s2_ * CMPLXF (c2_, 0.0);
  if (az_ > tol_) {
    (*ai_) = (*ai_) + (*z_) * (*z_) * s1_ * CMPLXF (c1_ / (1.0e0 + fid_), 0.0);
  }
  if ((*kode_) == 1) {
    goto _l0;
  }
  zta_ = (*z_) * csqrtf ((*z_)) * CMPLXF (tth_, 0.0);
  (*ai_) = (*ai_) * cexpf (zta_);
  goto _l0;
  _l60:;
  fnu_ = (1.0e0 + fid_) / 3.0e0;
  k1_ = _i1mach (($1_ = 12, &$1_));
  k2_ = _i1mach (($2_ = 13, &$2_));
  r1m5_ = _r1mach (($3_ = 5, &$3_));
  k_ = _min (_abs (k1_), _abs (k2_));
  elim_ = 2.303e0 * (k_ * r1m5_ - 3.0e0);
  k1_ = _i1mach (($4_ = 11, &$4_)) - 1;
  aa_ = r1m5_ * k1_;
  dig_ = _min (aa_, 18.0);
  aa_ = aa_ * 2.303e0;
  alim_ = elim_ + _max (-aa_, -41.45);
  rl_ = 1.2e0 * dig_ + 3.0e0;
  alaz_ = logf (az_);
  aa_ = 0.5e0 / tol_;
  bb_ = _i1mach (($5_ = 9, &$5_)) * 0.5e0;
  aa_ = _min (aa_, bb_);
  aa_ = powl (aa_, tth_);
  if (az_ > aa_) {
    goto _l260;
  }
  aa_ = sqrtf (aa_);
  if (az_ > aa_) {
    (*ierr_) = 3;
  }
  csq_ = csqrtf ((*z_));
  zta_ = (*z_) * csq_ * CMPLXF (tth_, 0.0);
  iflag_ = 0;
  sfac_ = 1.0;
  zi_ = cimagf ((*z_));
  zr_ = (real_4) (crealf ((*z_)));
  ak_ = cimagf (zta_);
  if (zr_ >= 0.0e0) {
    goto _l70;
  }
  bk_ = (real_4) (crealf (zta_));
  ck_ = -_abs (bk_);
  zta_ = CMPLXF (ck_, ak_);
  _l70:;
  if (zi_ != 0.0e0) {
    goto _l80;
  }
  if (zr_ > 0.0e0) {
    goto _l80;
  }
  zta_ = CMPLXF (0.0, ak_);
  _l80:;
  aa_ = (real_4) (crealf (zta_));
  if (aa_ >= 0.0e0 && zr_ > 0.0e0) {
    goto _l100;
  }
  if ((*kode_) == 2) {
    goto _l90;
  }
  if (aa_ > (-alim_)) {
    goto _l90;
  }
  aa_ = -aa_ + 0.25e0 * alaz_;
  iflag_ = 1;
  sfac_ = tol_;
  if (aa_ > elim_) {
    goto _l240;
  }
  _l90:;
  mr_ = 1;
  if (zi_ < 0.0e0) {
    mr_ = -1;
  }
  (void) _cacai (&zta_, &fnu_, kode_, &mr_, &_k1, cy_, &nn_, &rl_, &tol_, &elim_, &alim_);
  if (nn_ < 0) {
    goto _l250;
  }
  (*nz_) = (*nz_) + nn_;
  goto _l120;
  _l100:;
  if ((*kode_) == 2) {
    goto _l110;
  }
  if (aa_ < alim_) {
    goto _l110;
  }
  aa_ = -aa_ - 0.25e0 * alaz_;
  iflag_ = 2;
  sfac_ = 1.0e0 / tol_;
  if (aa_ < (-elim_)) {
    goto _l180;
  }
  _l110:;
  (void) _cbknu (&zta_, &fnu_, kode_, &_k1, cy_, nz_, &tol_, &elim_, &alim_);
  _l120:;
  s1_ = cy_[0] * CMPLXF (coef_, 0.0);
  if (iflag_ != 0) {
    goto _l140;
  }
  if ((*id_) == 1) {
    goto _l130;
  }
  (*ai_) = csq_ * s1_;
  goto _l0;
  _l130:;
  (*ai_) = -(*z_) * s1_;
  goto _l0;
  _l140:;
  s1_ = s1_ * CMPLXF (sfac_, 0.0);
  if ((*id_) == 1) {
    goto _l150;
  }
  s1_ = s1_ * csq_;
  (*ai_) = s1_ * CMPLXF (1.0e0 / sfac_, 0.0);
  goto _l0;
  _l150:;
  s1_ = -s1_ * (*z_);
  (*ai_) = s1_ * CMPLXF (1.0e0 / sfac_, 0.0);
  goto _l0;
  _l160:;
  aa_ = 1.0e3 * _r1mach (&_k1);
  s1_ = CMPLXF (0.0, 0.0);
  if ((*id_) == 1) {
    goto _l170;
  }
  if (az_ > aa_) {
    s1_ = CMPLXF (c2_, 0.0) * (*z_);
  }
  (*ai_) = CMPLXF (c1_, 0.0) - s1_;
  goto _l0;
  _l170:;
  (*ai_) = -CMPLXF (c2_, 0.0);
  aa_ = sqrtf (aa_);
  if (az_ > aa_) {
    s1_ = (*z_) * (*z_) * CMPLXF (0.5, 0.0);
  }
  (*ai_) = (*ai_) + s1_ * CMPLXF (c1_, 0.0);
  goto _l0;
  _l180:;
  (*nz_) = 1;
  (*ai_) = CMPLXF (0.0, 0.0);
  goto _l0;
  _l240:;
  (*nz_) = 0;
  (*ierr_) = 2;
  goto _l0;
  _l250:;
  if (nn_ == -1) {
    goto _l240;
  }
  (*nz_) = 0;
  (*ierr_) = 5;
  goto _l0;
  _l260:;
  (*ierr_) = 4;
  (*nz_) = 0;
  _l0:;
  __calls[49].calls++;
  return 0;
}

real_4 _carg (complex_8 _p_ z_)
{
  static real_4 carg_;
  carg_ = 0.0;
  if ((real_4) (crealf ((*z_))) != 0.0 || cimagf ((*z_)) != 0.0) {
    carg_ = atan2f (cimagf ((*z_)), (real_4) (crealf ((*z_))));
  }
  __calls[50].calls++;
  return carg_;
}

complex_8 _casin (complex_8 _p_ zinp_)
{
  static int_4 nterms_, i_;
  static logical_4 first_;
  static real_4 pi2_, pi_, rmin_, r_, twoi_;
  static complex_8 z_, z2_, sqzp1_, ci_;
  int_4 _data_k_770, _data_k_771, _data_k_772, _data_k_773, $0_, $1_;
  complex_8 casin_;
  extern real_4 _r1mach ();
#define _data_n_770 1
  static real_4 _data_l_770[_data_n_770] = {
    1.57079632679489661923e0
  };
#define _data_n_771 1
  static real_4 _data_l_771[_data_n_771] = {
    3.14159265358979324e0
  };
#define _data_n_772 1
  static complex_8 _data_l_772[_data_n_772] = {
    CMPLXF (0.0, 1.0)
  };
#define _data_n_773 1
  static logical_4 _data_l_773[_data_n_773] = {
    TRUE
  };
  if (__calls[51].calls == 0) {
    _data_k_770 = 0;
    if (_data_k_770 >= _data_n_770) {
      _data_k_770 = 0;
    }
    pi2_ = _data_l_770[_data_k_770++];
  }
  if (__calls[51].calls == 0) {
    _data_k_771 = 0;
    if (_data_k_771 >= _data_n_771) {
      _data_k_771 = 0;
    }
    pi_ = _data_l_771[_data_k_771++];
  }
  if (__calls[51].calls == 0) {
    _data_k_772 = 0;
    if (_data_k_772 >= _data_n_772) {
      _data_k_772 = 0;
    }
    ci_ = _data_l_772[_data_k_772++];
  }
  if (__calls[51].calls == 0) {
    _data_k_773 = 0;
    if (_data_k_773 >= _data_n_773) {
      _data_k_773 = 0;
    }
    first_ = _data_l_773[_data_k_773++];
  }
  if (first_) {
    nterms_ = -0.4343 * logf (_r1mach (($0_ = 3, &$0_)));
    rmin_ = sqrtf (6.0 * _r1mach (($1_ = 3, &$1_)));
  }
  first_ = FALSE;
  z_ = (*zinp_);
  r_ = cabsf (z_);
  if (r_ > 0.1) {
    goto _l30;
  }
  casin_ = z_;
  if (r_ < rmin_) {
    goto _l0;
  }
  casin_ = CMPLXF (0.0, 0.0);
  z2_ = z_ * z_;
  for (i_ = 1; i_ <= nterms_; (i_)++) {
    twoi_ = 2 * (nterms_ - i_) + 1;
    casin_ = 1.0 / twoi_ + twoi_ * casin_ * z2_ / (twoi_ + 1.0);
  }
  casin_ = z_ * casin_;
  goto _l0;
  _l30:;
  if ((real_4) (crealf ((*zinp_))) < 0.0) {
    z_ = -(*zinp_);
  }
  sqzp1_ = csqrtf (z_ + 1.0);
  if (cimagf (sqzp1_) < 0.0) {
    sqzp1_ = -sqzp1_;
  }
  casin_ = pi2_ - ci_ * clogf (z_ + sqzp1_ * csqrtf (z_ - 1.0));
  if ((real_4) (crealf (casin_)) > pi2_) {
    casin_ = pi_ - casin_;
  }
  if ((real_4) (crealf (casin_)) <= (-pi2_)) {
    casin_ = -pi_ - casin_;
  }
  if ((real_4) (crealf ((*zinp_))) < 0.0) {
    casin_ = -casin_;
  }
  _l0:;
  __calls[51].calls++;
  return casin_;
}

complex_8 _casinh (complex_8 _p_ z_)
{
  static complex_8 ci_;
  int_4 _data_k_774;
  complex_8 $0_;
  complex_8 casinh_;
#define _data_n_774 1
  static complex_8 _data_l_774[_data_n_774] = {
    CMPLXF (0.0, 1.0)
  };
  if (__calls[52].calls == 0) {
    _data_k_774 = 0;
    if (_data_k_774 >= _data_n_774) {
      _data_k_774 = 0;
    }
    ci_ = _data_l_774[_data_k_774++];
  }
  casinh_ = -ci_ * _casin (($0_ = ci_ * (*z_), &$0_));
  __calls[52].calls++;
  return casinh_;
}

complex_8 _catan2 (complex_8 _p_ csn_, complex_8 _p_ ccs_)
{
  static real_4 pi_;
  int_4 _data_k_775, $1_;
  complex_8 $0_;
  complex_8 catan2_;
#define _data_n_775 1
  static real_4 _data_l_775[_data_n_775] = {
    3.14159265358979323846e0
  };
  if (__calls[53].calls == 0) {
    _data_k_775 = 0;
    if (_data_k_775 >= _data_n_775) {
      _data_k_775 = 0;
    }
    pi_ = _data_l_775[_data_k_775++];
  }
  if (cabsf ((*ccs_)) == 0.0) {
    goto _l10;
  }
  catan2_ = _catan (($0_ = (*csn_) / (*ccs_), &$0_));
  if ((real_4) (crealf ((*ccs_))) < 0.0) {
    catan2_ = catan2_ + pi_;
  }
  if ((real_4) (crealf (catan2_)) > pi_) {
    catan2_ = catan2_ - 2.0 * pi_;
  }
  goto _l0;
  _l10:;
  if (cabsf ((*csn_)) == 0.0) {
    (void) _xermsg (_dc_0, _dc_113, _dc_114, &_k1, ($1_ = 2, &$1_));
  }
  catan2_ = CMPLXF (_sign (0.5 * pi_, (real_4) (crealf ((*csn_)))), 0.0);
  _l0:;
  __calls[53].calls++;
  return catan2_;
}

complex_8 _catan (complex_8 _p_ z_)
{
  static int_4 nterms_, i_;
  static logical_4 first_;
  static real_4 pi2_, sqeps_, rmin_, rmax_, r_, twoi_, x_, y_, r2_, xans_, yans_;
  static complex_8 z2_;
  int_4 _data_k_776, _data_k_777, $0_, $1_, $2_, $3_, $4_, $5_;
  complex_8 catan_;
  extern real_4 _r1mach ();
#define _data_n_776 1
  static real_4 _data_l_776[_data_n_776] = {
    1.57079632679489661923e0
  };
#define _data_n_777 1
  static logical_4 _data_l_777[_data_n_777] = {
    TRUE
  };
  if (__calls[54].calls == 0) {
    _data_k_776 = 0;
    if (_data_k_776 >= _data_n_776) {
      _data_k_776 = 0;
    }
    pi2_ = _data_l_776[_data_k_776++];
  }
  if (__calls[54].calls == 0) {
    _data_k_777 = 0;
    if (_data_k_777 >= _data_n_777) {
      _data_k_777 = 0;
    }
    first_ = _data_l_777[_data_k_777++];
  }
  if (first_) {
    nterms_ = -0.4343 * logf (_r1mach (($0_ = 3, &$0_))) + 1.0;
    sqeps_ = sqrtf (_r1mach (($1_ = 4, &$1_)));
    rmin_ = sqrtf (3.0 * _r1mach (($2_ = 3, &$2_)));
    rmax_ = 1.0 / _r1mach (($3_ = 3, &$3_));
  }
  first_ = FALSE;
  r_ = cabsf ((*z_));
  if (r_ > 0.1) {
    goto _l30;
  }
  catan_ = (*z_);
  if (r_ < rmin_) {
    goto _l0;
  }
  catan_ = CMPLXF (0.0, 0.0);
  z2_ = (*z_) * (*z_);
  for (i_ = 1; i_ <= nterms_; (i_)++) {
    twoi_ = 2 * (nterms_ - i_) + 1;
    catan_ = 1.0 / twoi_ - z2_ * catan_;
  }
  catan_ = (*z_) * catan_;
  goto _l0;
  _l30:;
  if (r_ > rmax_) {
    goto _l50;
  }
  x_ = (real_4) (crealf ((*z_)));
  y_ = cimagf ((*z_));
  r2_ = r_ * r_;
  if (r2_ == 1.0 && x_ == 0.0) {
    (void) _xermsg (_dc_0, _dc_115, _dc_116, ($4_ = 2, &$4_), ($5_ = 2, &$5_));
  }
  if (_abs (r2_ - 1.0) > sqeps_) {
    goto _l40;
  }
  if (cabsf (CMPLXF (1.0, 0.0) + (*z_) * (*z_)) < sqeps_) {
    (void) _xermsg (_dc_0, _dc_115, _dc_117, &_k1, &_k1);
  }
  _l40:;
  xans_ = 0.5 * atan2f (2.0 * x_, 1.0 - r2_);
  yans_ = 0.25 * logf ((r2_ + 2.0 * y_ + 1.0) / (r2_ - 2.0 * y_ + 1.0));
  catan_ = CMPLXF (xans_, yans_);
  goto _l0;
  _l50:;
  catan_ = CMPLXF (pi2_, 0.0);
  if ((real_4) (crealf ((*z_))) < 0.0) {
    catan_ = CMPLXF (-pi2_, 0.0);
  }
  _l0:;
  __calls[54].calls++;
  return catan_;
}

complex_8 _catanh (complex_8 _p_ z_)
{
  static complex_8 ci_;
  int_4 _data_k_778;
  complex_8 $0_;
  complex_8 catanh_;
#define _data_n_778 1
  static complex_8 _data_l_778[_data_n_778] = {
    CMPLXF (0.0, 1.0)
  };
  if (__calls[55].calls == 0) {
    _data_k_778 = 0;
    if (_data_k_778 >= _data_n_778) {
      _data_k_778 = 0;
    }
    ci_ = _data_l_778[_data_k_778++];
  }
  catanh_ = -ci_ * _catan (($0_ = ci_ * (*z_), &$0_));
  __calls[55].calls++;
  return catanh_;
}

int_4 _cbesh (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 
_p_ nz_, int_4 _p_ ierr_)
{
  static int_4 i_, inu_, inuh_, ir_, k_, k1_, k2_, mm_, mr_, nn_, nuf_, nw_;
  static real_4 aa_, alim_, aln_, arg_, az_, cpn_, dig_, elim_, fmm_, fn_, fnul_, hpi_, rhpi_, rl_, r1m5_, sgn_, spn_, 
  tol_, ufl_, xn_, xx_, yn_, yy_, bb_, ascle_, rtol_, atol_;
  static complex_8 zn_, zt_, csgn_;
  int_4 _data_k_779, $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
#define _data_n_779 1
  static real_4 _data_l_779[_data_n_779] = {
    1.57079632679489662e0
  };
  if (__calls[56].calls == 0) {
    _data_k_779 = 0;
    if (_data_k_779 >= _data_n_779) {
      _data_k_779 = 0;
    }
    hpi_ = _data_l_779[_data_k_779++];
  }
  (*nz_) = 0;
  xx_ = (real_4) (crealf ((*z_)));
  yy_ = cimagf ((*z_));
  (*ierr_) = 0;
  if (xx_ == 0.0e0 && yy_ == 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*fnu_) < 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*m_) < 1 || (*m_) > 2) {
    (*ierr_) = 1;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    (*ierr_) = 1;
  }
  if ((*n_) < 1) {
    (*ierr_) = 1;
  }
  if ((*ierr_) != 0) {
    goto _l0;
  }
  nn_ = (*n_);
  tol_ = _max (_r1mach (($0_ = 4, &$0_)), 1.0e-18);
  k1_ = _i1mach (($1_ = 12, &$1_));
  k2_ = _i1mach (($2_ = 13, &$2_));
  r1m5_ = _r1mach (($3_ = 5, &$3_));
  k_ = _min (_abs (k1_), _abs (k2_));
  elim_ = 2.303e0 * (k_ * r1m5_ - 3.0e0);
  k1_ = _i1mach (($4_ = 11, &$4_)) - 1;
  aa_ = r1m5_ * k1_;
  dig_ = _min (aa_, 18.0);
  aa_ = aa_ * 2.303e0;
  alim_ = elim_ + _max (-aa_, -41.45);
  fnul_ = 10.0e0 + 6.0e0 * (dig_ - 3.0e0);
  rl_ = 1.2e0 * dig_ + 3.0e0;
  fn_ = (*fnu_) + (nn_ - 1);
  mm_ = 3 - (*m_) - (*m_);
  fmm_ = mm_;
  zn_ = (*z_) * CMPLXF (0.0, -fmm_);
  xn_ = (real_4) (crealf (zn_));
  yn_ = cimagf (zn_);
  az_ = cabsf ((*z_));
  aa_ = 0.5e0 / tol_;
  bb_ = _i1mach (($5_ = 9, &$5_)) * 0.5e0;
  aa_ = _min (aa_, bb_);
  if (az_ > aa_) {
    goto _l240;
  }
  if (fn_ > aa_) {
    goto _l240;
  }
  aa_ = sqrtf (aa_);
  if (az_ > aa_) {
    (*ierr_) = 3;
  }
  if (fn_ > aa_) {
    (*ierr_) = 3;
  }
  ufl_ = _r1mach (&_k1) * 1.0e3;
  if (az_ < ufl_) {
    goto _l220;
  }
  if ((*fnu_) > fnul_) {
    goto _l90;
  }
  if (fn_ <= 1.0e0) {
    goto _l70;
  }
  if (fn_ > 2.0e0) {
    goto _l60;
  }
  if (az_ > tol_) {
    goto _l70;
  }
  arg_ = 0.5e0 * az_;
  aln_ = -fn_ * logf (arg_);
  if (aln_ > elim_) {
    goto _l220;
  }
  goto _l70;
  _l60:;
  (void) _cuoik (&zn_, fnu_, kode_, ($6_ = 2, &$6_), &nn_, cy_, &nuf_, &tol_, &elim_, &alim_);
  if (nuf_ < 0) {
    goto _l220;
  }
  (*nz_) = (*nz_) + nuf_;
  nn_ = nn_ - nuf_;
  if (nn_ == 0) {
    goto _l130;
  }
  _l70:;
  if ((xn_ < 0.0e0) || (xn_ == 0.0e0 && yn_ < 0.0e0 && (*m_) == 2)) {
    goto _l80;
  }
  (void) _cbknu (&zn_, fnu_, kode_, &nn_, cy_, nz_, &tol_, &elim_, &alim_);
  goto _l110;
  _l80:;
  mr_ = -mm_;
  (void) _cacon (&zn_, fnu_, kode_, &mr_, &nn_, cy_, &nw_, &rl_, &fnul_, &tol_, &elim_, &alim_);
  if (nw_ < 0) {
    goto _l230;
  }
  (*nz_) = nw_;
  goto _l110;
  _l90:;
  mr_ = 0;
  if ((xn_ >= 0.0e0) && (xn_ != 0.0e0 || yn_ >= 0.0e0 || (*m_) != 2)) {
    goto _l100;
  }
  mr_ = -mm_;
  if (xn_ == 0.0e0 && yn_ < 0.0e0) {
    zn_ = -zn_;
  }
  _l100:;
  (void) _cbunk (&zn_, fnu_, kode_, &mr_, &nn_, cy_, &nw_, &tol_, &elim_, &alim_);
  if (nw_ < 0) {
    goto _l230;
  }
  (*nz_) = (*nz_) + nw_;
  _l110:;
  sgn_ = _sign (hpi_, -fmm_);
  inu_ = (*fnu_);
  inuh_ = inu_ / 2;
  ir_ = inu_ - 2 * inuh_;
  arg_ = ((*fnu_) - (inu_ - ir_)) * sgn_;
  rhpi_ = 1.0e0 / sgn_;
  cpn_ = rhpi_ * cosf (arg_);
  spn_ = rhpi_ * sinf (arg_);
  csgn_ = CMPLXF (-spn_, cpn_);
  if (_imod (inuh_, 2) == 1) {
    csgn_ = -csgn_;
  }
  zt_ = CMPLXF (0.0, -fmm_);
  rtol_ = 1.0e0 / tol_;
  ascle_ = ufl_ * rtol_;
  for (i_ = 1; i_ <= nn_; (i_)++) {
    zn_ = cy_[i_ - 1];
    aa_ = (real_4) (crealf (zn_));
    bb_ = cimagf (zn_);
    atol_ = 1.0;
    if (_max (_abs (aa_), _abs (bb_)) > ascle_) {
      goto _l125;
    }
    zn_ = zn_ * CMPLXF (rtol_, 0.0);
    atol_ = tol_;
    _l125:;
    zn_ = zn_ * csgn_;
    cy_[i_ - 1] = zn_ * CMPLXF (atol_, 0.0);
    csgn_ = csgn_ * zt_;
  }
  goto _l0;
  _l130:;
  if (xn_ < 0.0e0) {
    goto _l220;
  }
  goto _l0;
  _l220:;
  (*ierr_) = 2;
  (*nz_) = 0;
  goto _l0;
  _l230:;
  if (nw_ == -1) {
    goto _l220;
  }
  (*nz_) = 0;
  (*ierr_) = 5;
  goto _l0;
  _l240:;
  (*nz_) = 0;
  (*ierr_) = 4;
  _l0:;
  __calls[56].calls++;
  return 0;
}

int_4 _cbesi (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ nz_, int_4 
_p_ ierr_)
{
  static int_4 i_, inu_, k_, k1_, k2_, nn_;
  static real_4 aa_, alim_, arg_, dig_, elim_, fnul_, pi_, rl_, r1m5_, s1_, s2_, tol_, xx_, yy_, az_, fn_, bb_, ascle_, 
  rtol_, atol_;
  static complex_8 cone_, csgn_, zn_;
  int_4 _data_k_780, _data_k_781, $0_, $1_, $2_, $3_, $4_, $5_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
#define _data_n_780 1
  static real_4 _data_l_780[_data_n_780] = {
    3.14159265358979324e0
  };
#define _data_n_781 1
  static complex_8 _data_l_781[_data_n_781] = {
    CMPLXF (1.0, 0.0)
  };
  if (__calls[57].calls == 0) {
    _data_k_780 = 0;
    if (_data_k_780 >= _data_n_780) {
      _data_k_780 = 0;
    }
    pi_ = _data_l_780[_data_k_780++];
  }
  if (__calls[57].calls == 0) {
    _data_k_781 = 0;
    if (_data_k_781 >= _data_n_781) {
      _data_k_781 = 0;
    }
    cone_ = _data_l_781[_data_k_781++];
  }
  (*ierr_) = 0;
  (*nz_) = 0;
  if ((*fnu_) < 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    (*ierr_) = 1;
  }
  if ((*n_) < 1) {
    (*ierr_) = 1;
  }
  if ((*ierr_) != 0) {
    goto _l0;
  }
  xx_ = (real_4) (crealf ((*z_)));
  yy_ = cimagf ((*z_));
  tol_ = _max (_r1mach (($0_ = 4, &$0_)), 1.0e-18);
  k1_ = _i1mach (($1_ = 12, &$1_));
  k2_ = _i1mach (($2_ = 13, &$2_));
  r1m5_ = _r1mach (($3_ = 5, &$3_));
  k_ = _min (_abs (k1_), _abs (k2_));
  elim_ = 2.303e0 * (k_ * r1m5_ - 3.0e0);
  k1_ = _i1mach (($4_ = 11, &$4_)) - 1;
  aa_ = r1m5_ * k1_;
  dig_ = _min (aa_, 18.0);
  aa_ = aa_ * 2.303e0;
  alim_ = elim_ + _max (-aa_, -41.45);
  rl_ = 1.2e0 * dig_ + 3.0e0;
  fnul_ = 10.0e0 + 6.0e0 * (dig_ - 3.0e0);
  az_ = cabsf ((*z_));
  aa_ = 0.5e0 / tol_;
  bb_ = _i1mach (($5_ = 9, &$5_)) * 0.5e0;
  aa_ = _min (aa_, bb_);
  if (az_ > aa_) {
    goto _l140;
  }
  fn_ = (*fnu_) + ((*n_) - 1);
  if (fn_ > aa_) {
    goto _l140;
  }
  aa_ = sqrtf (aa_);
  if (az_ > aa_) {
    (*ierr_) = 3;
  }
  if (fn_ > aa_) {
    (*ierr_) = 3;
  }
  zn_ = (*z_);
  csgn_ = cone_;
  if (xx_ >= 0.0e0) {
    goto _l40;
  }
  zn_ = -(*z_);
  inu_ = (*fnu_);
  arg_ = ((*fnu_) - inu_) * pi_;
  if (yy_ < 0.0e0) {
    arg_ = -arg_;
  }
  s1_ = cosf (arg_);
  s2_ = sinf (arg_);
  csgn_ = CMPLXF (s1_, s2_);
  if (_imod (inu_, 2) == 1) {
    csgn_ = -csgn_;
  }
  _l40:;
  (void) _cbinu (&zn_, fnu_, kode_, n_, cy_, nz_, &rl_, &fnul_, &tol_, &elim_, &alim_);
  if ((*nz_) < 0) {
    goto _l120;
  }
  if (xx_ >= 0.0e0) {
    goto _l0;
  }
  nn_ = (*n_) - (*nz_);
  if (nn_ == 0) {
    goto _l0;
  }
  rtol_ = 1.0e0 / tol_;
  ascle_ = _r1mach (&_k1) * rtol_ * 1.0e3;
  for (i_ = 1; i_ <= nn_; (i_)++) {
    zn_ = cy_[i_ - 1];
    aa_ = (real_4) (crealf (zn_));
    bb_ = cimagf (zn_);
    atol_ = 1.0;
    if (_max (_abs (aa_), _abs (bb_)) > ascle_) {
      goto _l55;
    }
    zn_ = zn_ * CMPLXF (rtol_, 0.0);
    atol_ = tol_;
    _l55:;
    zn_ = zn_ * csgn_;
    cy_[i_ - 1] = zn_ * CMPLXF (atol_, 0.0);
    csgn_ = -csgn_;
  }
  goto _l0;
  _l120:;
  if ((*nz_) == -2) {
    goto _l130;
  }
  (*nz_) = 0;
  (*ierr_) = 2;
  goto _l0;
  _l130:;
  (*nz_) = 0;
  (*ierr_) = 5;
  goto _l0;
  _l140:;
  (*nz_) = 0;
  (*ierr_) = 4;
  _l0:;
  __calls[57].calls++;
  return 0;
}

int_4 _cbesj (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ nz_, int_4 
_p_ ierr_)
{
  static int_4 i_, inu_, inuh_, ir_, k1_, k2_, nl_, k_;
  static real_4 aa_, alim_, arg_, dig_, elim_, fnul_, hpi_, rl_, r1_, r1m5_, r2_, tol_, yy_, az_, fn_, bb_, ascle_, rtol_
  , atol_;
  static complex_8 ci_, csgn_, zn_;
  int_4 _data_k_782, $0_, $1_, $2_, $3_, $4_, $5_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
#define _data_n_782 1
  static real_4 _data_l_782[_data_n_782] = {
    1.57079632679489662e0
  };
  if (__calls[58].calls == 0) {
    _data_k_782 = 0;
    if (_data_k_782 >= _data_n_782) {
      _data_k_782 = 0;
    }
    hpi_ = _data_l_782[_data_k_782++];
  }
  (*ierr_) = 0;
  (*nz_) = 0;
  if ((*fnu_) < 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    (*ierr_) = 1;
  }
  if ((*n_) < 1) {
    (*ierr_) = 1;
  }
  if ((*ierr_) != 0) {
    goto _l0;
  }
  tol_ = _max (_r1mach (($0_ = 4, &$0_)), 1.0e-18);
  k1_ = _i1mach (($1_ = 12, &$1_));
  k2_ = _i1mach (($2_ = 13, &$2_));
  r1m5_ = _r1mach (($3_ = 5, &$3_));
  k_ = _min (_abs (k1_), _abs (k2_));
  elim_ = 2.303e0 * (k_ * r1m5_ - 3.0e0);
  k1_ = _i1mach (($4_ = 11, &$4_)) - 1;
  aa_ = r1m5_ * k1_;
  dig_ = _min (aa_, 18.0);
  aa_ = aa_ * 2.303e0;
  alim_ = elim_ + _max (-aa_, -41.45);
  rl_ = 1.2e0 * dig_ + 3.0e0;
  fnul_ = 10.0e0 + 6.0e0 * (dig_ - 3.0e0);
  ci_ = CMPLXF (0.0, 1.0);
  yy_ = cimagf ((*z_));
  az_ = cabsf ((*z_));
  aa_ = 0.5e0 / tol_;
  bb_ = _i1mach (($5_ = 9, &$5_)) * 0.5e0;
  aa_ = _min (aa_, bb_);
  fn_ = (*fnu_) + ((*n_) - 1);
  if (az_ > aa_) {
    goto _l140;
  }
  if (fn_ > aa_) {
    goto _l140;
  }
  aa_ = sqrtf (aa_);
  if (az_ > aa_) {
    (*ierr_) = 3;
  }
  if (fn_ > aa_) {
    (*ierr_) = 3;
  }
  inu_ = (*fnu_);
  inuh_ = inu_ / 2;
  ir_ = inu_ - 2 * inuh_;
  arg_ = ((*fnu_) - (inu_ - ir_)) * hpi_;
  r1_ = cosf (arg_);
  r2_ = sinf (arg_);
  csgn_ = CMPLXF (r1_, r2_);
  if (_imod (inuh_, 2) == 1) {
    csgn_ = -csgn_;
  }
  zn_ = -(*z_) * ci_;
  if (yy_ >= 0.0e0) {
    goto _l40;
  }
  zn_ = -zn_;
  csgn_ = conjf (csgn_);
  ci_ = conjf (ci_);
  _l40:;
  (void) _cbinu (&zn_, fnu_, kode_, n_, cy_, nz_, &rl_, &fnul_, &tol_, &elim_, &alim_);
  if ((*nz_) < 0) {
    goto _l120;
  }
  nl_ = (*n_) - (*nz_);
  if (nl_ == 0) {
    goto _l0;
  }
  rtol_ = 1.0e0 / tol_;
  ascle_ = _r1mach (&_k1) * rtol_ * 1.0e3;
  for (i_ = 1; i_ <= nl_; (i_)++) {
    zn_ = cy_[i_ - 1];
    aa_ = (real_4) (crealf (zn_));
    bb_ = cimagf (zn_);
    atol_ = 1.0;
    if (_max (_abs (aa_), _abs (bb_)) > ascle_) {
      goto _l55;
    }
    zn_ = zn_ * CMPLXF (rtol_, 0.0);
    atol_ = tol_;
    _l55:;
    zn_ = zn_ * csgn_;
    cy_[i_ - 1] = zn_ * CMPLXF (atol_, 0.0);
    csgn_ = csgn_ * ci_;
  }
  goto _l0;
  _l120:;
  if ((*nz_) == -2) {
    goto _l130;
  }
  (*nz_) = 0;
  (*ierr_) = 2;
  goto _l0;
  _l130:;
  (*nz_) = 0;
  (*ierr_) = 5;
  goto _l0;
  _l140:;
  (*nz_) = 0;
  (*ierr_) = 4;
  _l0:;
  __calls[58].calls++;
  return 0;
}

int_4 _cbesk (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ nz_, int_4 
_p_ ierr_)
{
  static int_4 k_, k1_, k2_, mr_, nn_, nuf_, nw_;
  static real_4 aa_, alim_, aln_, arg_, az_, dig_, elim_, fn_, fnul_, rl_, r1m5_, tol_, ufl_, xx_, yy_, bb_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
  (*ierr_) = 0;
  (*nz_) = 0;
  xx_ = (real_4) (crealf ((*z_)));
  yy_ = cimagf ((*z_));
  if (yy_ == 0.0e0 && xx_ == 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*fnu_) < 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    (*ierr_) = 1;
  }
  if ((*n_) < 1) {
    (*ierr_) = 1;
  }
  if ((*ierr_) != 0) {
    goto _l0;
  }
  nn_ = (*n_);
  tol_ = _max (_r1mach (($0_ = 4, &$0_)), 1.0e-18);
  k1_ = _i1mach (($1_ = 12, &$1_));
  k2_ = _i1mach (($2_ = 13, &$2_));
  r1m5_ = _r1mach (($3_ = 5, &$3_));
  k_ = _min (_abs (k1_), _abs (k2_));
  elim_ = 2.303e0 * (k_ * r1m5_ - 3.0e0);
  k1_ = _i1mach (($4_ = 11, &$4_)) - 1;
  aa_ = r1m5_ * k1_;
  dig_ = _min (aa_, 18.0);
  aa_ = aa_ * 2.303e0;
  alim_ = elim_ + _max (-aa_, -41.45);
  fnul_ = 10.0e0 + 6.0e0 * (dig_ - 3.0e0);
  rl_ = 1.2e0 * dig_ + 3.0e0;
  az_ = cabsf ((*z_));
  fn_ = (*fnu_) + (nn_ - 1);
  aa_ = 0.5e0 / tol_;
  bb_ = _i1mach (($5_ = 9, &$5_)) * 0.5e0;
  aa_ = _min (aa_, bb_);
  if (az_ > aa_) {
    goto _l210;
  }
  if (fn_ > aa_) {
    goto _l210;
  }
  aa_ = sqrtf (aa_);
  if (az_ > aa_) {
    (*ierr_) = 3;
  }
  if (fn_ > aa_) {
    (*ierr_) = 3;
  }
  ufl_ = _r1mach (&_k1) * 1.0e3;
  if (az_ < ufl_) {
    goto _l180;
  }
  if ((*fnu_) > fnul_) {
    goto _l80;
  }
  if (fn_ <= 1.0e0) {
    goto _l60;
  }
  if (fn_ > 2.0e0) {
    goto _l50;
  }
  if (az_ > tol_) {
    goto _l60;
  }
  arg_ = 0.5e0 * az_;
  aln_ = -fn_ * logf (arg_);
  if (aln_ > elim_) {
    goto _l180;
  }
  goto _l60;
  _l50:;
  (void) _cuoik (z_, fnu_, kode_, ($6_ = 2, &$6_), &nn_, cy_, &nuf_, &tol_, &elim_, &alim_);
  if (nuf_ < 0) {
    goto _l180;
  }
  (*nz_) = (*nz_) + nuf_;
  nn_ = nn_ - nuf_;
  if (nn_ == 0) {
    goto _l100;
  }
  _l60:;
  if (xx_ < 0.0e0) {
    goto _l70;
  }
  (void) _cbknu (z_, fnu_, kode_, &nn_, cy_, &nw_, &tol_, &elim_, &alim_);
  if (nw_ < 0) {
    goto _l200;
  }
  (*nz_) = nw_;
  goto _l0;
  _l70:;
  if ((*nz_) != 0) {
    goto _l180;
  }
  mr_ = 1;
  if (yy_ < 0.0e0) {
    mr_ = -1;
  }
  (void) _cacon (z_, fnu_, kode_, &mr_, &nn_, cy_, &nw_, &rl_, &fnul_, &tol_, &elim_, &alim_);
  if (nw_ < 0) {
    goto _l200;
  }
  (*nz_) = nw_;
  goto _l0;
  _l80:;
  mr_ = 0;
  if (xx_ >= 0.0e0) {
    goto _l90;
  }
  mr_ = 1;
  if (yy_ < 0.0e0) {
    mr_ = -1;
  }
  _l90:;
  (void) _cbunk (z_, fnu_, kode_, &mr_, &nn_, cy_, &nw_, &tol_, &elim_, &alim_);
  if (nw_ < 0) {
    goto _l200;
  }
  (*nz_) = (*nz_) + nw_;
  goto _l0;
  _l100:;
  if (xx_ < 0.0e0) {
    goto _l180;
  }
  goto _l0;
  _l180:;
  (*nz_) = 0;
  (*ierr_) = 2;
  goto _l0;
  _l200:;
  if (nw_ == -1) {
    goto _l180;
  }
  (*nz_) = 0;
  (*ierr_) = 5;
  goto _l0;
  _l210:;
  (*nz_) = 0;
  (*ierr_) = 4;
  _l0:;
  __calls[59].calls++;
  return 0;
}

int_4 _cbesy (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ nz_, 
complex_8 _p_ cwrk_, int_4 _p_ ierr_)
{
  static int_4 i_, k_, k1_, k2_, nz1_, nz2_;
  static real_4 elim_, ey_, r1_, r2_, tay_, xx_, yy_, r1m5_, ascle_, rtol_, atol_, tol_, aa_, bb_;
  static complex_8 c1_, c2_, ex_, hci_, zu_, zv_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
  xx_ = (real_4) (crealf ((*z_)));
  yy_ = cimagf ((*z_));
  (*ierr_) = 0;
  (*nz_) = 0;
  if (xx_ == 0.0e0 && yy_ == 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*fnu_) < 0.0e0) {
    (*ierr_) = 1;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    (*ierr_) = 1;
  }
  if ((*n_) < 1) {
    (*ierr_) = 1;
  }
  if ((*ierr_) != 0) {
    goto _l0;
  }
  hci_ = CMPLXF (0.0, 0.5);
  (void) _cbesh (z_, fnu_, kode_, &_k1, n_, cy_, &nz1_, ierr_);
  if ((*ierr_) != 0 && (*ierr_) != 3) {
    goto _l170;
  }
  (void) _cbesh (z_, fnu_, kode_, ($0_ = 2, &$0_), n_, cwrk_, &nz2_, ierr_);
  if ((*ierr_) != 0 && (*ierr_) != 3) {
    goto _l170;
  }
  (*nz_) = _min (nz1_, nz2_);
  if ((*kode_) == 2) {
    goto _l60;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    cy_[i_ - 1] = hci_ * (cwrk_[i_ - 1] - cy_[i_ - 1]);
  }
  goto _l0;
  _l60:;
  tol_ = _max (_r1mach (($1_ = 4, &$1_)), 1.0e-18);
  k1_ = _i1mach (($2_ = 12, &$2_));
  k2_ = _i1mach (($3_ = 13, &$3_));
  k_ = _min (_abs (k1_), _abs (k2_));
  r1m5_ = _r1mach (($4_ = 5, &$4_));
  elim_ = 2.303e0 * (k_ * r1m5_ - 3.0e0);
  r1_ = cosf (xx_);
  r2_ = sinf (xx_);
  ex_ = CMPLXF (r1_, r2_);
  ey_ = 0.0;
  tay_ = _abs (yy_ + yy_);
  if (tay_ < elim_) {
    ey_ = expf (-tay_);
  }
  if (yy_ < 0.0e0) {
    goto _l90;
  }
  c1_ = ex_ * CMPLXF (ey_, 0.0);
  c2_ = conjf (ex_);
  _l70:;
  (*nz_) = 0;
  rtol_ = 1.0e0 / tol_;
  ascle_ = _r1mach (&_k1) * rtol_ * 1.0e3;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    zv_ = cwrk_[i_ - 1];
    aa_ = (real_4) (crealf (zv_));
    bb_ = cimagf (zv_);
    atol_ = 1.0;
    if (_max (_abs (aa_), _abs (bb_)) > ascle_) {
      goto _l75;
    }
    zv_ = zv_ * CMPLXF (rtol_, 0.0);
    atol_ = tol_;
    _l75:;
    zv_ = zv_ * c2_ * hci_;
    zv_ = zv_ * CMPLXF (atol_, 0.0);
    zu_ = cy_[i_ - 1];
    aa_ = (real_4) (crealf (zu_));
    bb_ = cimagf (zu_);
    atol_ = 1.0;
    if (_max (_abs (aa_), _abs (bb_)) > ascle_) {
      goto _l85;
    }
    zu_ = zu_ * CMPLXF (rtol_, 0.0);
    atol_ = tol_;
    _l85:;
    zu_ = zu_ * c1_ * hci_;
    zu_ = zu_ * CMPLXF (atol_, 0.0);
    cy_[i_ - 1] = zv_ - zu_;
    if (cy_[i_ - 1] == CMPLXF (0.0, 0.0) && ey_ == 0.0e0) {
      (*nz_) = (*nz_) + 1;
    }
  }
  goto _l0;
  _l90:;
  c1_ = ex_;
  c2_ = conjf (ex_) * CMPLXF (ey_, 0.0);
  goto _l70;
  _l170:;
  (*nz_) = 0;
  _l0:;
  __calls[60].calls++;
  return 0;
}

complex_8 _cbeta (complex_8 _p_ a_, complex_8 _p_ b_)
{
  static real_4 xmax_, xmin_, xmaxt_;
  int_4 _data_k_783, $0_;
  complex_8 $1_;
  complex_8 cbeta_;
#define _data_n_783 1
  static real_4 _data_l_783[_data_n_783] = {
    0.0
  };
  if (__calls[61].calls == 0) {
    _data_k_783 = 0;
    if (_data_k_783 >= _data_n_783) {
      _data_k_783 = 0;
    }
    xmax_ = _data_l_783[_data_k_783++];
  }
  if (xmax_ == 0.0) {
    (void) _gamlim (&xmin_, &xmaxt_);
    xmax_ = xmaxt_;
  }
  if ((real_4) (crealf ((*a_))) <= 0.0 || (real_4) (crealf ((*b_))) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_118, _dc_119, &_k1, ($0_ = 2, &$0_));
  }
  if ((real_4) (crealf ((*a_))) + (real_4) (crealf ((*b_))) < xmax_) {
    cbeta_ = _cgamma (a_) * (_cgamma (b_) / _cgamma (($1_ = (*a_) + (*b_), &$1_)));
  }
  if ((real_4) (crealf ((*a_))) + (real_4) (crealf ((*b_))) < xmax_) {
    goto _l0;
  }
  cbeta_ = cexpf (_clbeta (a_, b_));
  _l0:;
  __calls[61].calls++;
  return cbeta_;
}

int_4 _cbinu (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ cy_, int_4 _p_ nz_, 
real_4 _p_ rl_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, inw_, nlast_, nn_, nui_, nw_;
  static real_4 az_, dfnu_;
  static complex_8 cw_[2], czero_;
  int_4 _data_k_784, $0_, $1_;
#define _data_n_784 1
  static complex_8 _data_l_784[_data_n_784] = {
    CMPLXF (0.0, 0.0)
  };
  if (__calls[62].calls == 0) {
    _data_k_784 = 0;
    if (_data_k_784 >= _data_n_784) {
      _data_k_784 = 0;
    }
    czero_ = _data_l_784[_data_k_784++];
  }
  (*nz_) = 0;
  az_ = cabsf ((*z_));
  nn_ = (*n_);
  dfnu_ = (*fnu_) + ((*n_) - 1);
  if (az_ <= 2.0e0) {
    goto _l10;
  }
  if (az_ * az_ * 0.25e0 > dfnu_ + 1.0e0) {
    goto _l20;
  }
  _l10:;
  (void) _cseri (z_, fnu_, kode_, &nn_, cy_, &nw_, tol_, elim_, alim_);
  inw_ = _abs (nw_);
  (*nz_) = (*nz_) + inw_;
  nn_ = nn_ - inw_;
  if (nn_ == 0) {
    goto _l0;
  }
  if (nw_ >= 0) {
    goto _l120;
  }
  dfnu_ = (*fnu_) + (nn_ - 1);
  _l20:;
  if (az_ < (*rl_)) {
    goto _l40;
  }
  if (dfnu_ <= 1.0e0) {
    goto _l30;
  }
  if (az_ + az_ < dfnu_ * dfnu_) {
    goto _l50;
  }
  _l30:;
  (void) _casyi (z_, fnu_, kode_, &nn_, cy_, &nw_, rl_, tol_, elim_, alim_);
  if (nw_ < 0) {
    goto _l130;
  }
  goto _l120;
  _l40:;
  if (dfnu_ <= 1.0e0) {
    goto _l70;
  }
  _l50:;
  (void) _cuoik (z_, fnu_, kode_, &_k1, &nn_, cy_, &nw_, tol_, elim_, alim_);
  if (nw_ < 0) {
    goto _l130;
  }
  (*nz_) = (*nz_) + nw_;
  nn_ = nn_ - nw_;
  if (nn_ == 0) {
    goto _l0;
  }
  dfnu_ = (*fnu_) + (nn_ - 1);
  if (dfnu_ > (*fnul_)) {
    goto _l110;
  }
  if (az_ > (*fnul_)) {
    goto _l110;
  }
  _l60:;
  if (az_ > (*rl_)) {
    goto _l80;
  }
  _l70:;
  (void) _cmlri (z_, fnu_, kode_, &nn_, cy_, &nw_, tol_);
  if (nw_ < 0) {
    goto _l130;
  }
  goto _l120;
  _l80:;
  (void) _cuoik (z_, fnu_, kode_, ($0_ = 2, &$0_), ($1_ = 2, &$1_), cw_, &nw_, tol_, elim_, alim_);
  if (nw_ >= 0) {
    goto _l100;
  }
  (*nz_) = nn_;
  for (i_ = 1; i_ <= nn_; (i_)++) {
    cy_[i_ - 1] = czero_;
  }
  goto _l0;
  _l100:;
  if (nw_ > 0) {
    goto _l130;
  }
  (void) _cwrsk (z_, fnu_, kode_, &nn_, cy_, &nw_, cw_, tol_, elim_, alim_);
  if (nw_ < 0) {
    goto _l130;
  }
  goto _l120;
  _l110:;
  nui_ = (*fnul_) - dfnu_ + 1;
  nui_ = _max (nui_, 0);
  (void) _cbuni (z_, fnu_, kode_, &nn_, cy_, &nw_, &nui_, &nlast_, fnul_, tol_, elim_, alim_);
  if (nw_ < 0) {
    goto _l130;
  }
  (*nz_) = (*nz_) + nw_;
  if (nlast_ == 0) {
    goto _l120;
  }
  nn_ = nlast_;
  goto _l60;
  _l120:;
  goto _l0;
  _l130:;
  (*nz_) = -1;
  if (nw_ == -2) {
    (*nz_) = -2;
  }
  _l0:;
  __calls[62].calls++;
  return 0;
}

int_4 _cbiry (complex_8 _p_ z_, int_4 _p_ id_, int_4 _p_ kode_, complex_8 _p_ bi_, int_4 _p_ ierr_)
{
  static int_4 k_, k1_, k2_, nz_;
  static real_4 aa_, ad_, ak_, alim_, atrm_, az_, az3_, bb_, bk_, ck_, coef_, c1_, c2_, dig_, dk_, d1_, d2_, elim_, fid_, 
  fmr_, fnu_, fnul_, pi_, rl_, r1m5_, sfac_, tol_, tth_, zi_, zr_, z3i_, z3r_;
  static complex_8 cone_, csq_, cy_[2], s1_, s2_, trm1_, trm2_, zta_, z3_;
  int_4 _data_k_785, _data_k_786, $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
#define _data_n_785 5
  static real_4 _data_l_785[_data_n_785] = {
    6.66666666666666667e-1,
    6.14926627446000736e-1,
    4.48288357353826359e-1,
    5.77350269189625765e-1,
    3.14159265358979324e+00
  };
#define _data_n_786 1
  static complex_8 _data_l_786[_data_n_786] = {
    CMPLXF (1.0, 0.0)
  };
  if (__calls[63].calls == 0) {
    _data_k_785 = 0;
    if (_data_k_785 >= _data_n_785) {
      _data_k_785 = 0;
    }
    tth_ = _data_l_785[_data_k_785++];
    if (_data_k_785 >= _data_n_785) {
      _data_k_785 = 0;
    }
    c1_ = _data_l_785[_data_k_785++];
    if (_data_k_785 >= _data_n_785) {
      _data_k_785 = 0;
    }
    c2_ = _data_l_785[_data_k_785++];
    if (_data_k_785 >= _data_n_785) {
      _data_k_785 = 0;
    }
    coef_ = _data_l_785[_data_k_785++];
    if (_data_k_785 >= _data_n_785) {
      _data_k_785 = 0;
    }
    pi_ = _data_l_785[_data_k_785++];
  }
  if (__calls[63].calls == 0) {
    _data_k_786 = 0;
    if (_data_k_786 >= _data_n_786) {
      _data_k_786 = 0;
    }
    cone_ = _data_l_786[_data_k_786++];
  }
  (*ierr_) = 0;
  nz_ = 0;
  if ((*id_) < 0 || (*id_) > 1) {
    (*ierr_) = 1;
  }
  if ((*kode_) < 1 || (*kode_) > 2) {
    (*ierr_) = 1;
  }
  if ((*ierr_) != 0) {
    goto _l0;
  }
  az_ = cabsf ((*z_));
  tol_ = _max (_r1mach (($0_ = 4, &$0_)), 1.0e-18);
  fid_ = (*id_);
  if (az_ > 1.0e0) {
    goto _l60;
  }
  s1_ = cone_;
  s2_ = cone_;
  if (az_ < tol_) {
    goto _l110;
  }
  aa_ = az_ * az_;
  if (aa_ < tol_ / az_) {
    goto _l40;
  }
  trm1_ = cone_;
  trm2_ = cone_;
  atrm_ = 1.0;
  z3_ = (*z_) * (*z_) * (*z_);
  az3_ = az_ * aa_;
  ak_ = 2.0e0 + fid_;
  bk_ = 3.0e0 - fid_ - fid_;
  ck_ = 4.0e0 - fid_;
  dk_ = 3.0e0 + fid_ + fid_;
  d1_ = ak_ * dk_;
  d2_ = bk_ * ck_;
  ad_ = _min (d1_, d2_);
  ak_ = 24.0e0 + 9.0e0 * fid_;
  bk_ = 30.0e0 - 9.0e0 * fid_;
  z3r_ = (real_4) (crealf (z3_));
  z3i_ = cimagf (z3_);
  for (k_ = 1; k_ <= 25; (k_)++) {
    trm1_ = trm1_ * CMPLXF (z3r_ / d1_, z3i_ / d1_);
    s1_ = s1_ + trm1_;
    trm2_ = trm2_ * CMPLXF (z3r_ / d2_, z3i_ / d2_);
    s2_ = s2_ + trm2_;
    atrm_ = atrm_ * az3_ / ad_;
    d1_ = d1_ + ak_;
    d2_ = d2_ + bk_;
    ad_ = _min (d1_, d2_);
    if (atrm_ < tol_ * ad_) {
      goto _l40;
    }
    ak_ = ak_ + 18.0e0;
    bk_ = bk_ + 18.0e0;
  }
  _l40:;
  if ((*id_) == 1) {
    goto _l50;
  }
  (*bi_) = s1_ * CMPLXF (c1_, 0.0) + (*z_) * s2_ * CMPLXF (c2_, 0.0);
  if ((*kode_) == 1) {
    goto _l0;
  }
  zta_ = (*z_) * csqrtf ((*z_)) * CMPLXF (tth_, 0.0);
  aa_ = (real_4) (crealf (zta_));
  aa_ = -_abs (aa_);
  (*bi_) = (*bi_) * CMPLXF (expf (aa_), 0.0);
  goto _l0;
  _l50:;
  (*bi_) = s2_ * CMPLXF (c2_, 0.0);
  if (az_ > tol_) {
    (*bi_) = (*bi_) + (*z_) * (*z_) * s1_ * CMPLXF (c1_ / (1.0e0 + fid_), 0.0);
  }
  if ((*kode_) == 1) {
    goto _l0;
  }
  zta_ = (*z_) * csqrtf ((*z_)) * CMPLXF (tth_, 0.0);
  aa_ = (real_4) (crealf (zta_));
  aa_ = -_abs (aa_);
  (*bi_) = (*bi_) * CMPLXF (expf (aa_), 0.0);
  goto _l0;
  _l60:;
  fnu_ = (1.0e0 + fid_) / 3.0e0;
  k1_ = _i1mach (($1_ = 12, &$1_));
  k2_ = _i1mach (($2_ = 13, &$2_));
  r1m5_ = _r1mach (($3_ = 5, &$3_));
  k_ = _min (_abs (k1_), _abs (k2_));
  elim_ = 2.303e0 * (k_ * r1m5_ - 3.0e0);
  k1_ = _i1mach (($4_ = 11, &$4_)) - 1;
  aa_ = r1m5_ * k1_;
  dig_ = _min (aa_, 18.0);
  aa_ = aa_ * 2.303e0;
  alim_ = elim_ + _max (-aa_, -41.45);
  rl_ = 1.2e0 * dig_ + 3.0e0;
  fnul_ = 10.0e0 + 6.0e0 * (dig_ - 3.0e0);
  aa_ = 0.5e0 / tol_;
  bb_ = _i1mach (($5_ = 9, &$5_)) * 0.5e0;
  aa_ = _min (aa_, bb_);
  aa_ = powl (aa_, tth_);
  if (az_ > aa_) {
    goto _l190;
  }
  aa_ = sqrtf (aa_);
  if (az_ > aa_) {
    (*ierr_) = 3;
  }
  csq_ = csqrtf ((*z_));
  zta_ = (*z_) * csq_ * CMPLXF (tth_, 0.0);
  sfac_ = 1.0;
  zi_ = cimagf ((*z_));
  zr_ = (real_4) (crealf ((*z_)));
  ak_ = cimagf (zta_);
  if (zr_ >= 0.0e0) {
    goto _l70;
  }
  bk_ = (real_4) (crealf (zta_));
  ck_ = -_abs (bk_);
  zta_ = CMPLXF (ck_, ak_);
  _l70:;
  if (zi_ == 0.0e0 && zr_ <= 0.0e0) {
    zta_ = CMPLXF (0.0, ak_);
  }
  aa_ = (real_4) (crealf (zta_));
  if ((*kode_) == 2) {
    goto _l80;
  }
  bb_ = _abs (aa_);
  if (bb_ < alim_) {
    goto _l80;
  }
  bb_ = bb_ + 0.25e0 * logf (az_);
  sfac_ = tol_;
  if (bb_ > elim_) {
    goto _l170;
  }
  _l80:;
  fmr_ = 0.0;
  if (aa_ >= 0.0e0 && zr_ > 0.0e0) {
    goto _l90;
  }
  fmr_ = pi_;
  if (zi_ < 0.0e0) {
    fmr_ = -pi_;
  }
  zta_ = -zta_;
  _l90:;
  (void) _cbinu (&zta_, &fnu_, kode_, &_k1, cy_, &nz_, &rl_, &fnul_, &tol_, &elim_, &alim_);
  if (nz_ < 0) {
    goto _l180;
  }
  aa_ = fmr_ * fnu_;
  z3_ = CMPLXF (sfac_, 0.0);
  s1_ = cy_[0] * CMPLXF (cosf (aa_), sinf (aa_)) * z3_;
  fnu_ = (2.0e0 - fid_) / 3.0e0;
  (void) _cbinu (&zta_, &fnu_, kode_, ($6_ = 2, &$6_), cy_, &nz_, &rl_, &fnul_, &tol_, &elim_, &alim_);
  cy_[0] = cy_[0] * z3_;
  cy_[1] = cy_[1] * z3_;
  s2_ = cy_[0] * CMPLXF (fnu_ + fnu_, 0.0) / zta_ + cy_[1];
  aa_ = fmr_ * (fnu_ - 1.0e0);
  s1_ = (s1_ + s2_ * CMPLXF (cosf (aa_), sinf (aa_))) * CMPLXF (coef_, 0.0);
  if ((*id_) == 1) {
    goto _l100;
  }
  s1_ = csq_ * s1_;
  (*bi_) = s1_ * CMPLXF (1.0e0 / sfac_, 0.0);
  goto _l0;
  _l100:;
  s1_ = (*z_) * s1_;
  (*bi_) = s1_ * CMPLXF (1.0e0 / sfac_, 0.0);
  goto _l0;
  _l110:;
  aa_ = c1_ * (1.0e0 - fid_) + fid_ * c2_;
  (*bi_) = CMPLXF (aa_, 0.0);
  goto _l0;
  _l170:;
  nz_ = 0;
  (*ierr_) = 2;
  goto _l0;
  _l180:;
  if (nz_ == -1) {
    goto _l170;
  }
  nz_ = 0;
  (*ierr_) = 5;
  goto _l0;
  _l190:;
  (*ierr_) = 4;
  nz_ = 0;
  _l0:;
  __calls[63].calls++;
  return 0;
}

int_4 _cbknu (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, real_4 
_p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, idum_, iflag_, inu_, k_, kflag_, kk_, kmax_, koded_, nw_, j_, ic_, inub_;
  static real_4 aa_, ak_, ascle_, a1_, a2_, bb_, bk_, bry_[3], caz_, cc_[8], dnu_, dnu2_, etest_, fc_, fhs_, fk_, fks_, 
  fpi_, g1_, g2_, hpi_, pi_, p2i_, p2m_, p2r_, rk_, rthpi_, r1_, s_, spi_, tm_, tth_, t1_, t2_, xx_, yy_, helim_, elm_, 
  xd_, yd_, alas_, as_;
  static complex_8 cch_, ck_, coef_, cone_, crsc_, cs_, cscl_, csh_, csr_[3], css_[3], ctwo_, cz_, czero_, f_, fmu_, p_, 
  pt_, p1_, p2_, q_, rz_, smu_, st_, s1_, s2_, zd_, celm_, cy_[2];
  int_4 _data_k_787, _data_k_788, _data_k_789, _data_k_790, _data_k_791, $0_, $1_, $2_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
#define _data_n_787 1
  static int_4 _data_l_787[_data_n_787] = {
    30
  };
#define _data_n_788 1
  static real_4 _data_l_788[_data_n_788] = {
    2.0e0
  };
#define _data_n_789 3
  static complex_8 _data_l_789[_data_n_789] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0),
    CMPLXF (2.0, 0.0)
  };
#define _data_n_790 6
  static real_4 _data_l_790[_data_n_790] = {
    3.14159265358979324e0,
    1.25331413731550025e0,
    1.90985931710274403e0,
    1.57079632679489662e0,
    1.89769999331517738e0,
    6.66666666666666666e-1
  };
#define _data_n_791 8
  static real_4 _data_l_791[_data_n_791] = {
    5.77215664901532861e-1,
    -4.20026350340952355e-2,
    -4.21977345555443367e-2,
    7.21894324666309954e-3,
    -2.15241674114950973e-4,
    -2.01348547807882387e-5,
    1.13302723198169588e-6,
    6.11609510448141582e-9
  };
  if (__calls[64].calls == 0) {
    _data_k_787 = 0;
    if (_data_k_787 >= _data_n_787) {
      _data_k_787 = 0;
    }
    kmax_ = _data_l_787[_data_k_787++];
  }
  if (__calls[64].calls == 0) {
    _data_k_788 = 0;
    if (_data_k_788 >= _data_n_788) {
      _data_k_788 = 0;
    }
    r1_ = _data_l_788[_data_k_788++];
  }
  if (__calls[64].calls == 0) {
    _data_k_789 = 0;
    if (_data_k_789 >= _data_n_789) {
      _data_k_789 = 0;
    }
    czero_ = _data_l_789[_data_k_789++];
    if (_data_k_789 >= _data_n_789) {
      _data_k_789 = 0;
    }
    cone_ = _data_l_789[_data_k_789++];
    if (_data_k_789 >= _data_n_789) {
      _data_k_789 = 0;
    }
    ctwo_ = _data_l_789[_data_k_789++];
  }
  if (__calls[64].calls == 0) {
    _data_k_790 = 0;
    if (_data_k_790 >= _data_n_790) {
      _data_k_790 = 0;
    }
    pi_ = _data_l_790[_data_k_790++];
    if (_data_k_790 >= _data_n_790) {
      _data_k_790 = 0;
    }
    rthpi_ = _data_l_790[_data_k_790++];
    if (_data_k_790 >= _data_n_790) {
      _data_k_790 = 0;
    }
    spi_ = _data_l_790[_data_k_790++];
    if (_data_k_790 >= _data_n_790) {
      _data_k_790 = 0;
    }
    hpi_ = _data_l_790[_data_k_790++];
    if (_data_k_790 >= _data_n_790) {
      _data_k_790 = 0;
    }
    fpi_ = _data_l_790[_data_k_790++];
    if (_data_k_790 >= _data_n_790) {
      _data_k_790 = 0;
    }
    tth_ = _data_l_790[_data_k_790++];
  }
  if (__calls[64].calls == 0) {
    _data_k_791 = 0;
    if (_data_k_791 >= _data_n_791) {
      _data_k_791 = 0;
    }
    cc_[0] = _data_l_791[_data_k_791++];
    if (_data_k_791 >= _data_n_791) {
      _data_k_791 = 0;
    }
    cc_[1] = _data_l_791[_data_k_791++];
    if (_data_k_791 >= _data_n_791) {
      _data_k_791 = 0;
    }
    cc_[2] = _data_l_791[_data_k_791++];
    if (_data_k_791 >= _data_n_791) {
      _data_k_791 = 0;
    }
    cc_[3] = _data_l_791[_data_k_791++];
    if (_data_k_791 >= _data_n_791) {
      _data_k_791 = 0;
    }
    cc_[4] = _data_l_791[_data_k_791++];
    if (_data_k_791 >= _data_n_791) {
      _data_k_791 = 0;
    }
    cc_[5] = _data_l_791[_data_k_791++];
    if (_data_k_791 >= _data_n_791) {
      _data_k_791 = 0;
    }
    cc_[6] = _data_l_791[_data_k_791++];
    if (_data_k_791 >= _data_n_791) {
      _data_k_791 = 0;
    }
    cc_[7] = _data_l_791[_data_k_791++];
  }
  xx_ = (real_4) (crealf ((*z_)));
  yy_ = cimagf ((*z_));
  caz_ = cabsf ((*z_));
  cscl_ = CMPLXF (1.0e0 / (*tol_), 0.0);
  crsc_ = CMPLXF ((*tol_), 0.0);
  css_[0] = cscl_;
  css_[1] = cone_;
  css_[2] = crsc_;
  csr_[0] = crsc_;
  csr_[1] = cone_;
  csr_[2] = cscl_;
  bry_[0] = 1.0e3 * _r1mach (&_k1) / (*tol_);
  bry_[1] = 1.0e0 / bry_[0];
  bry_[2] = _r1mach (($0_ = 2, &$0_));
  (*nz_) = 0;
  iflag_ = 0;
  koded_ = (*kode_);
  rz_ = ctwo_ / (*z_);
  inu_ = (*fnu_) + 0.5e0;
  dnu_ = (*fnu_) - inu_;
  if (_abs (dnu_) == 0.5e0) {
    goto _l110;
  }
  dnu2_ = 0.0;
  if (_abs (dnu_) > (*tol_)) {
    dnu2_ = dnu_ * dnu_;
  }
  if (caz_ > r1_) {
    goto _l110;
  }
  fc_ = 1.0;
  smu_ = clogf (rz_);
  fmu_ = smu_ * CMPLXF (dnu_, 0.0);
  (void) _cshch (&fmu_, &csh_, &cch_);
  if (dnu_ == 0.0e0) {
    goto _l10;
  }
  fc_ = dnu_ * pi_;
  fc_ = fc_ / sinf (fc_);
  smu_ = csh_ * CMPLXF (1.0e0 / dnu_, 0.0);
  _l10:;
  a2_ = 1.0e0 + dnu_;
  t2_ = expf (-_gamln (&a2_, &idum_));
  t1_ = 1.0e0 / (t2_ * fc_);
  if (_abs (dnu_) > 0.1e0) {
    goto _l40;
  }
  ak_ = 1.0;
  s_ = cc_[0];
  for (k_ = 2; k_ <= 8; (k_)++) {
    ak_ = ak_ * dnu2_;
    tm_ = cc_[k_ - 1] * ak_;
    s_ = s_ + tm_;
    if (_abs (tm_) < (*tol_)) {
      goto _l30;
    }
  }
  _l30:;
  g1_ = -s_;
  goto _l50;
  _l40:;
  g1_ = (t1_ - t2_) / (dnu_ + dnu_);
  _l50:;
  g2_ = 0.5e0 * (t1_ + t2_) * fc_;
  g1_ = g1_ * fc_;
  f_ = CMPLXF (g1_, 0.0) * cch_ + smu_ * CMPLXF (g2_, 0.0);
  pt_ = cexpf (fmu_);
  p_ = CMPLXF (0.5e0 / t2_, 0.0) * pt_;
  q_ = CMPLXF (0.5e0 / t1_, 0.0) / pt_;
  s1_ = f_;
  s2_ = p_;
  ak_ = 1.0;
  a1_ = 1.0;
  ck_ = cone_;
  bk_ = 1.0e0 - dnu2_;
  if (inu_ > 0 || (*n_) > 1) {
    goto _l80;
  }
  if (caz_ < (*tol_)) {
    goto _l70;
  }
  cz_ = (*z_) * (*z_) * CMPLXF (0.25, 0.0);
  t1_ = 0.25e0 * caz_ * caz_;
  _l60:;
  f_ = (f_ * CMPLXF (ak_, 0.0) + p_ + q_) * CMPLXF (1.0e0 / bk_, 0.0);
  p_ = p_ * CMPLXF (1.0e0 / (ak_ - dnu_), 0.0);
  q_ = q_ * CMPLXF (1.0e0 / (ak_ + dnu_), 0.0);
  rk_ = 1.0e0 / ak_;
  ck_ = ck_ * cz_ * CMPLXF (rk_, 0.0);
  s1_ = s1_ + ck_ * f_;
  a1_ = a1_ * t1_ * rk_;
  bk_ = bk_ + ak_ + ak_ + 1.0e0;
  ak_ = ak_ + 1.0e0;
  if (a1_ > (*tol_)) {
    goto _l60;
  }
  _l70:;
  y_[0] = s1_;
  if (koded_ == 1) {
    goto _l0;
  }
  y_[0] = s1_ * cexpf ((*z_));
  goto _l0;
  _l80:;
  if (caz_ < (*tol_)) {
    goto _l100;
  }
  cz_ = (*z_) * (*z_) * CMPLXF (0.25, 0.0);
  t1_ = 0.25e0 * caz_ * caz_;
  _l90:;
  f_ = (f_ * CMPLXF (ak_, 0.0) + p_ + q_) * CMPLXF (1.0e0 / bk_, 0.0);
  p_ = p_ * CMPLXF (1.0e0 / (ak_ - dnu_), 0.0);
  q_ = q_ * CMPLXF (1.0e0 / (ak_ + dnu_), 0.0);
  rk_ = 1.0e0 / ak_;
  ck_ = ck_ * cz_ * CMPLXF (rk_, 0.0);
  s1_ = s1_ + ck_ * f_;
  s2_ = s2_ + ck_ * (p_ - f_ * CMPLXF (ak_, 0.0));
  a1_ = a1_ * t1_ * rk_;
  bk_ = bk_ + ak_ + ak_ + 1.0e0;
  ak_ = ak_ + 1.0e0;
  if (a1_ > (*tol_)) {
    goto _l90;
  }
  _l100:;
  kflag_ = 2;
  bk_ = (real_4) (crealf (smu_));
  a1_ = (*fnu_) + 1.0e0;
  ak_ = a1_ * _abs (bk_);
  if (ak_ > (*alim_)) {
    kflag_ = 3;
  }
  p2_ = s2_ * css_[kflag_ - 1];
  s2_ = p2_ * rz_;
  s1_ = s1_ * css_[kflag_ - 1];
  if (koded_ == 1) {
    goto _l210;
  }
  f_ = cexpf ((*z_));
  s1_ = s1_ * f_;
  s2_ = s2_ * f_;
  goto _l210;
  _l110:;
  coef_ = CMPLXF (rthpi_, 0.0) / csqrtf ((*z_));
  kflag_ = 2;
  if (koded_ == 2) {
    goto _l120;
  }
  if (xx_ > (*alim_)) {
    goto _l290;
  }
  a1_ = expf (-xx_) * (real_4) (crealf (css_[kflag_ - 1]));
  pt_ = CMPLXF (a1_, 0.0) * CMPLXF (cosf (yy_), -sinf (yy_));
  coef_ = coef_ * pt_;
  _l120:;
  if (_abs (dnu_) == 0.5e0) {
    goto _l300;
  }
  ak_ = cosf (pi_ * dnu_);
  ak_ = _abs (ak_);
  if (ak_ == 0.0e0) {
    goto _l300;
  }
  fhs_ = _abs (0.25e0 - dnu2_);
  if (fhs_ == 0.0e0) {
    goto _l300;
  }
  t1_ = (_i1mach (($1_ = 11, &$1_)) - 1) * _r1mach (($2_ = 5, &$2_)) * 3.321928094e0;
  t1_ = _max (t1_, 12.0);
  t1_ = _min (t1_, 60.0);
  t2_ = tth_ * t1_ - 6.0e0;
  if (xx_ != 0.0e0) {
    goto _l130;
  }
  t1_ = hpi_;
  goto _l140;
  _l130:;
  t1_ = atanf (yy_ / xx_);
  t1_ = _abs (t1_);
  _l140:;
  if (t2_ > caz_) {
    goto _l170;
  }
  etest_ = ak_ / (pi_ * caz_ * (*tol_));
  fk_ = 1.0;
  if (etest_ < 1.0e0) {
    goto _l180;
  }
  fks_ = 2.0;
  rk_ = caz_ + caz_ + 2.0e0;
  a1_ = 0.0;
  a2_ = 1.0;
  for (i_ = 1; i_ <= kmax_; (i_)++) {
    ak_ = fhs_ / fks_;
    bk_ = rk_ / (fk_ + 1.0e0);
    tm_ = a2_;
    a2_ = bk_ * a2_ - ak_ * a1_;
    a1_ = tm_;
    rk_ = rk_ + 2.0e0;
    fks_ = fks_ + fk_ + fk_ + 2.0e0;
    fhs_ = fhs_ + fk_ + fk_;
    fk_ = fk_ + 1.0e0;
    tm_ = _abs (a2_) * fk_;
    if (etest_ < tm_) {
      goto _l160;
    }
  }
  goto _l310;
  _l160:;
  fk_ = fk_ + spi_ * t1_ * sqrtf (t2_ / caz_);
  fhs_ = _abs (0.25e0 - dnu2_);
  goto _l180;
  _l170:;
  a2_ = sqrtf (caz_);
  ak_ = fpi_ * ak_ / ((*tol_) * sqrtf (a2_));
  aa_ = 3.0e0 * t1_ / (1.0e0 + caz_);
  bb_ = 14.7e0 * t1_ / (28.0e0 + caz_);
  ak_ = (logf (ak_) + caz_ * cosf (aa_) / (1.0e0 + 0.008e0 * caz_)) / cosf (bb_);
  fk_ = 0.12125e0 * ak_ * ak_ / caz_ + 1.5e0;
  _l180:;
  k_ = fk_;
  fk_ = k_;
  fks_ = fk_ * fk_;
  p1_ = czero_;
  p2_ = CMPLXF ((*tol_), 0.0);
  cs_ = p2_;
  for (i_ = 1; i_ <= k_; (i_)++) {
    a1_ = fks_ - fk_;
    a2_ = (fks_ + fk_) / (a1_ + fhs_);
    rk_ = 2.0e0 / (fk_ + 1.0e0);
    t1_ = (fk_ + xx_) * rk_;
    t2_ = yy_ * rk_;
    pt_ = p2_;
    p2_ = (p2_ * CMPLXF (t1_, t2_) - p1_) * CMPLXF (a2_, 0.0);
    p1_ = pt_;
    cs_ = cs_ + p2_;
    fks_ = a1_ - fk_ + 1.0e0;
    fk_ = fk_ - 1.0e0;
  }
  tm_ = cabsf (cs_);
  pt_ = CMPLXF (1.0e0 / tm_, 0.0);
  s1_ = pt_ * p2_;
  cs_ = conjf (cs_) * pt_;
  s1_ = coef_ * s1_ * cs_;
  if (inu_ > 0 || (*n_) > 1) {
    goto _l200;
  }
  zd_ = (*z_);
  if (iflag_ == 1) {
    goto _l270;
  }
  goto _l240;
  _l200:;
  tm_ = cabsf (p2_);
  pt_ = CMPLXF (1.0e0 / tm_, 0.0);
  p1_ = pt_ * p1_;
  p2_ = conjf (p2_) * pt_;
  pt_ = p1_ * p2_;
  s2_ = s1_ * (cone_ + (CMPLXF (dnu_ + 0.5e0, 0.0) - pt_) / (*z_));
  _l210:;
  ck_ = CMPLXF (dnu_ + 1.0e0, 0.0) * rz_;
  if ((*n_) == 1) {
    inu_ = inu_ - 1;
  }
  if (inu_ > 0) {
    goto _l220;
  }
  if ((*n_) == 1) {
    s1_ = s2_;
  }
  zd_ = (*z_);
  if (iflag_ == 1) {
    goto _l270;
  }
  goto _l240;
  _l220:;
  inub_ = 1;
  if (iflag_ == 1) {
    goto _l261;
  }
  _l225:;
  p1_ = csr_[kflag_ - 1];
  ascle_ = bry_[kflag_ - 1];
  for (i_ = inub_; i_ <= inu_; (i_)++) {
    st_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = st_;
    ck_ = ck_ + rz_;
    if (kflag_ >= 3) {
      goto _l230;
    }
    p2_ = s2_ * p1_;
    p2r_ = (real_4) (crealf (p2_));
    p2i_ = cimagf (p2_);
    p2r_ = _abs (p2r_);
    p2i_ = _abs (p2i_);
    p2m_ = _max (p2r_, p2i_);
    if (p2m_ <= ascle_) {
      goto _l230;
    }
    kflag_ = kflag_ + 1;
    ascle_ = bry_[kflag_ - 1];
    s1_ = s1_ * p1_;
    s2_ = p2_;
    s1_ = s1_ * css_[kflag_ - 1];
    s2_ = s2_ * css_[kflag_ - 1];
    p1_ = csr_[kflag_ - 1];
    _l230:;
  }
  if ((*n_) == 1) {
    s1_ = s2_;
  }
  _l240:;
  y_[0] = s1_ * csr_[kflag_ - 1];
  if ((*n_) == 1) {
    goto _l0;
  }
  y_[1] = s2_ * csr_[kflag_ - 1];
  if ((*n_) == 2) {
    goto _l0;
  }
  kk_ = 2;
  _l250:;
  kk_ = kk_ + 1;
  if (kk_ > (*n_)) {
    goto _l0;
  }
  p1_ = csr_[kflag_ - 1];
  ascle_ = bry_[kflag_ - 1];
  for (i_ = kk_; i_ <= (*n_); (i_)++) {
    p2_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = p2_;
    ck_ = ck_ + rz_;
    p2_ = s2_ * p1_;
    y_[i_ - 1] = p2_;
    if (kflag_ >= 3) {
      goto _l260;
    }
    p2r_ = (real_4) (crealf (p2_));
    p2i_ = cimagf (p2_);
    p2r_ = _abs (p2r_);
    p2i_ = _abs (p2i_);
    p2m_ = _max (p2r_, p2i_);
    if (p2m_ <= ascle_) {
      goto _l260;
    }
    kflag_ = kflag_ + 1;
    ascle_ = bry_[kflag_ - 1];
    s1_ = s1_ * p1_;
    s2_ = p2_;
    s1_ = s1_ * css_[kflag_ - 1];
    s2_ = s2_ * css_[kflag_ - 1];
    p1_ = csr_[kflag_ - 1];
    _l260:;
  }
  goto _l0;
  _l261:;
  helim_ = 0.5e0 * (*elim_);
  elm_ = expf (-(*elim_));
  celm_ = CMPLXF (elm_, 0.0);
  ascle_ = bry_[0];
  zd_ = (*z_);
  xd_ = xx_;
  yd_ = yy_;
  ic_ = -1;
  j_ = 2;
  for (i_ = 1; i_ <= inu_; (i_)++) {
    st_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = st_;
    ck_ = ck_ + rz_;
    as_ = cabsf (s2_);
    alas_ = logf (as_);
    p2r_ = -xd_ + alas_;
    if (p2r_ < (-(*elim_))) {
      goto _l263;
    }
    p2_ = -zd_ + clogf (s2_);
    p2r_ = (real_4) (crealf (p2_));
    p2i_ = cimagf (p2_);
    p2m_ = expf (p2r_) / (*tol_);
    p1_ = CMPLXF (p2m_, 0.0) * CMPLXF (cosf (p2i_), sinf (p2i_));
    (void) _cuchk (&p1_, &nw_, &ascle_, tol_);
    if (nw_ != 0) {
      goto _l263;
    }
    j_ = 3 - j_;
    cy_[j_ - 1] = p1_;
    if (ic_ == (i_ - 1)) {
      goto _l264;
    }
    ic_ = i_;
    goto _l262;
    _l263:;
    if (alas_ < helim_) {
      goto _l262;
    }
    xd_ = xd_ - (*elim_);
    s1_ = s1_ * celm_;
    s2_ = s2_ * celm_;
    zd_ = CMPLXF (xd_, yd_);
    _l262:;
  }
  if ((*n_) == 1) {
    s1_ = s2_;
  }
  goto _l270;
  _l264:;
  kflag_ = 1;
  inub_ = i_ + 1;
  s2_ = cy_[j_ - 1];
  j_ = 3 - j_;
  s1_ = cy_[j_ - 1];
  if (inub_ <= inu_) {
    goto _l225;
  }
  if ((*n_) == 1) {
    s1_ = s2_;
  }
  goto _l240;
  _l270:;
  y_[0] = s1_;
  if ((*n_) == 1) {
    goto _l280;
  }
  y_[1] = s2_;
  _l280:;
  ascle_ = bry_[0];
  (void) _ckscl (&zd_, fnu_, n_, y_, nz_, &rz_, &ascle_, tol_, elim_);
  inu_ = (*n_) - (*nz_);
  if (inu_ <= 0) {
    goto _l0;
  }
  kk_ = (*nz_) + 1;
  s1_ = y_[kk_ - 1];
  y_[kk_ - 1] = s1_ * csr_[0];
  if (inu_ == 1) {
    goto _l0;
  }
  kk_ = (*nz_) + 2;
  s2_ = y_[kk_ - 1];
  y_[kk_ - 1] = s2_ * csr_[0];
  if (inu_ == 2) {
    goto _l0;
  }
  t2_ = (*fnu_) + (kk_ - 1);
  ck_ = CMPLXF (t2_, 0.0) * rz_;
  kflag_ = 1;
  goto _l250;
  _l290:;
  koded_ = 2;
  iflag_ = 1;
  kflag_ = 2;
  goto _l120;
  _l300:;
  s1_ = coef_;
  s2_ = coef_;
  goto _l210;
  _l310:;
  (*nz_) = -2;
  _l0:;
  __calls[64].calls++;
  return 0;
}

real_4 _cbrt (real_4 _p_ x_)
{
  static int_4 niter_, n_, ixpnt_, irem_, iter_;
  static real_4 cbrt_, cbrt2_[5], y_, cbrtsq_;
  int_4 _data_k_792, _data_k_793, _data_k_794, _data_k_795, _data_k_796, _data_k_797, $0_;
  real_4 $1_, $2_;
  extern real_4 _r1mach ();
#define _data_n_792 1
  static real_4 _data_l_792[_data_n_792] = {
    0.62996052494743658e0
  };
#define _data_n_793 1
  static real_4 _data_l_793[_data_n_793] = {
    0.79370052598409974e0
  };
#define _data_n_794 1
  static real_4 _data_l_794[_data_n_794] = {
    1.0e0
  };
#define _data_n_795 1
  static real_4 _data_l_795[_data_n_795] = {
    1.25992104989487316e0
  };
#define _data_n_796 1
  static real_4 _data_l_796[_data_n_796] = {
    1.58740105196819947e0
  };
#define _data_n_797 1
  static int_4 _data_l_797[_data_n_797] = {
    0
  };
  if (__calls[65].calls == 0) {
    _data_k_792 = 0;
    if (_data_k_792 >= _data_n_792) {
      _data_k_792 = 0;
    }
    cbrt2_[0] = _data_l_792[_data_k_792++];
  }
  if (__calls[65].calls == 0) {
    _data_k_793 = 0;
    if (_data_k_793 >= _data_n_793) {
      _data_k_793 = 0;
    }
    cbrt2_[1] = _data_l_793[_data_k_793++];
  }
  if (__calls[65].calls == 0) {
    _data_k_794 = 0;
    if (_data_k_794 >= _data_n_794) {
      _data_k_794 = 0;
    }
    cbrt2_[2] = _data_l_794[_data_k_794++];
  }
  if (__calls[65].calls == 0) {
    _data_k_795 = 0;
    if (_data_k_795 >= _data_n_795) {
      _data_k_795 = 0;
    }
    cbrt2_[3] = _data_l_795[_data_k_795++];
  }
  if (__calls[65].calls == 0) {
    _data_k_796 = 0;
    if (_data_k_796 >= _data_n_796) {
      _data_k_796 = 0;
    }
    cbrt2_[4] = _data_l_796[_data_k_796++];
  }
  if (__calls[65].calls == 0) {
    _data_k_797 = 0;
    if (_data_k_797 >= _data_n_797) {
      _data_k_797 = 0;
    }
    niter_ = _data_l_797[_data_k_797++];
  }
  if (niter_ == 0) {
    niter_ = 1.443 * logf (-.106 * logf (0.1 * _r1mach (($0_ = 3, &$0_)))) + 1.0;
  }
  cbrt_ = 0.0;
  if ((*x_) == 0.0) {
    goto _l0;
  }
  (void) _r9upak (($1_ = _abs ((*x_)), &$1_), &y_, &n_);
  ixpnt_ = n_ / 3;
  irem_ = n_ - 3 * ixpnt_ + 3;
  cbrt_ = .439581e0 + y_ * (.928549e0 + y_ * (-.512653e0 + y_ * .144586e0));
  for (iter_ = 1; iter_ <= niter_; (iter_)++) {
    cbrtsq_ = cbrt_ * cbrt_;
    cbrt_ = cbrt_ + (y_ - cbrt_ * cbrtsq_) / (3.0 * cbrtsq_);
  }
  cbrt_ = _r9pak (($2_ = cbrt2_[irem_ - 1] * _sign (cbrt_, (*x_)), &$2_), &ixpnt_);
  _l0:;
  __calls[65].calls++;
  return cbrt_;
}

int_4 _cbuni (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, int_4 
_p_ nui_, int_4 _p_ nlast_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, iflag_, iform_, k_, nl_, nw_;
  static real_4 ax_, ay_, dfnu_, fnui_, gnu_, xx_, yy_, ascle_, bry_[3], str_, sti_, stm_;
  static complex_8 cscl_, cscr_, cy_[2], rz_, st_, s1_, s2_;
  int_4 $0_, $1_;
  extern real_4 _r1mach ();
  (*nz_) = 0;
  xx_ = (real_4) (crealf ((*z_)));
  yy_ = cimagf ((*z_));
  ax_ = _abs (xx_) * 1.7321e0;
  ay_ = _abs (yy_);
  iform_ = 1;
  if (ay_ > ax_) {
    iform_ = 2;
  }
  if ((*nui_) == 0) {
    goto _l60;
  }
  fnui_ = (*nui_);
  dfnu_ = (*fnu_) + ((*n_) - 1);
  gnu_ = dfnu_ + fnui_;
  if (iform_ == 2) {
    goto _l10;
  }
  (void) _cuni1 (z_, &gnu_, kode_, ($0_ = 2, &$0_), cy_, &nw_, nlast_, fnul_, tol_, elim_, alim_);
  goto _l20;
  _l10:;
  (void) _cuni2 (z_, &gnu_, kode_, ($1_ = 2, &$1_), cy_, &nw_, nlast_, fnul_, tol_, elim_, alim_);
  _l20:;
  if (nw_ < 0) {
    goto _l50;
  }
  if (nw_ != 0) {
    goto _l90;
  }
  ay_ = cabsf (cy_[0]);
  bry_[0] = 1.0e3 * _r1mach (&_k1) / (*tol_);
  bry_[1] = 1.0e0 / bry_[0];
  bry_[2] = bry_[1];
  iflag_ = 2;
  ascle_ = bry_[1];
  ax_ = 1.0;
  cscl_ = CMPLXF (ax_, 0.0);
  if (ay_ > bry_[0]) {
    goto _l21;
  }
  iflag_ = 1;
  ascle_ = bry_[0];
  ax_ = 1.0e0 / (*tol_);
  cscl_ = CMPLXF (ax_, 0.0);
  goto _l25;
  _l21:;
  if (ay_ < bry_[1]) {
    goto _l25;
  }
  iflag_ = 3;
  ascle_ = bry_[2];
  ax_ = (*tol_);
  cscl_ = CMPLXF (ax_, 0.0);
  _l25:;
  ay_ = 1.0e0 / ax_;
  cscr_ = CMPLXF (ay_, 0.0);
  s1_ = cy_[1] * cscl_;
  s2_ = cy_[0] * cscl_;
  rz_ = CMPLXF (2.0, 0.0) / (*z_);
  for (i_ = 1; i_ <= (*nui_); (i_)++) {
    st_ = s2_;
    s2_ = CMPLXF (dfnu_ + fnui_, 0.0) * rz_ * s2_ + s1_;
    s1_ = st_;
    fnui_ = fnui_ - 1.0e0;
    if (iflag_ >= 3) {
      goto _l30;
    }
    st_ = s2_ * cscr_;
    str_ = (real_4) (crealf (st_));
    sti_ = cimagf (st_);
    str_ = _abs (str_);
    sti_ = _abs (sti_);
    stm_ = _max (str_, sti_);
    if (stm_ <= ascle_) {
      goto _l30;
    }
    iflag_ = iflag_ + 1;
    ascle_ = bry_[iflag_ - 1];
    s1_ = s1_ * cscr_;
    s2_ = st_;
    ax_ = ax_ * (*tol_);
    ay_ = 1.0e0 / ax_;
    cscl_ = CMPLXF (ax_, 0.0);
    cscr_ = CMPLXF (ay_, 0.0);
    s1_ = s1_ * cscl_;
    s2_ = s2_ * cscl_;
    _l30:;
  }
  y_[(*n_) - 1] = s2_ * cscr_;
  if ((*n_) == 1) {
    goto _l0;
  }
  nl_ = (*n_) - 1;
  fnui_ = nl_;
  k_ = nl_;
  for (i_ = 1; i_ <= nl_; (i_)++) {
    st_ = s2_;
    s2_ = CMPLXF ((*fnu_) + fnui_, 0.0) * rz_ * s2_ + s1_;
    s1_ = st_;
    st_ = s2_ * cscr_;
    y_[k_ - 1] = st_;
    fnui_ = fnui_ - 1.0e0;
    k_ = k_ - 1;
    if (iflag_ >= 3) {
      goto _l40;
    }
    str_ = (real_4) (crealf (st_));
    sti_ = cimagf (st_);
    str_ = _abs (str_);
    sti_ = _abs (sti_);
    stm_ = _max (str_, sti_);
    if (stm_ <= ascle_) {
      goto _l40;
    }
    iflag_ = iflag_ + 1;
    ascle_ = bry_[iflag_ - 1];
    s1_ = s1_ * cscr_;
    s2_ = st_;
    ax_ = ax_ * (*tol_);
    ay_ = 1.0e0 / ax_;
    cscl_ = CMPLXF (ax_, 0.0);
    cscr_ = CMPLXF (ay_, 0.0);
    s1_ = s1_ * cscl_;
    s2_ = s2_ * cscl_;
    _l40:;
  }
  goto _l0;
  _l50:;
  (*nz_) = -1;
  if (nw_ == -2) {
    (*nz_) = -2;
  }
  goto _l0;
  _l60:;
  if (iform_ == 2) {
    goto _l70;
  }
  (void) _cuni1 (z_, fnu_, kode_, n_, y_, &nw_, nlast_, fnul_, tol_, elim_, alim_);
  goto _l80;
  _l70:;
  (void) _cuni2 (z_, fnu_, kode_, n_, y_, &nw_, nlast_, fnul_, tol_, elim_, alim_);
  _l80:;
  if (nw_ < 0) {
    goto _l50;
  }
  (*nz_) = nw_;
  goto _l0;
  _l90:;
  (*nlast_) = (*n_);
  _l0:;
  __calls[66].calls++;
  return 0;
}

int_4 _cbunk (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ y_, int_4 
_p_ nz_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static real_4 ax_, ay_, xx_, yy_;
  (*nz_) = 0;
  xx_ = (real_4) (crealf ((*z_)));
  yy_ = cimagf ((*z_));
  ax_ = _abs (xx_) * 1.7321e0;
  ay_ = _abs (yy_);
  if (ay_ > ax_) {
    goto _l10;
  }
  (void) _cunk1 (z_, fnu_, kode_, mr_, n_, y_, nz_, tol_, elim_, alim_);
  goto _l20;
  _l10:;
  (void) _cunk2 (z_, fnu_, kode_, mr_, n_, y_, nz_, tol_, elim_, alim_);
  _l20:;
  __calls[67].calls++;
  return 0;
}

complex_8 _ccbrt (complex_8 _p_ z_)
{
  static real_4 theta_, r_;
  real_4 $0_;
  complex_8 ccbrt_;
  theta_ = _carg (z_) / 3.0;
  r_ = _cbrt (($0_ = cabsf ((*z_)), &$0_));
  ccbrt_ = CMPLXF (r_ * cosf (theta_), r_ * sinf (theta_));
  __calls[68].calls++;
  return ccbrt_;
}

complex_8 _ccosh (complex_8 _p_ z_)
{
  static complex_8 ci_;
  int_4 _data_k_798;
  complex_8 ccosh_;
#define _data_n_798 1
  static complex_8 _data_l_798[_data_n_798] = {
    CMPLXF (0.0, 1.0)
  };
  if (__calls[69].calls == 0) {
    _data_k_798 = 0;
    if (_data_k_798 >= _data_n_798) {
      _data_k_798 = 0;
    }
    ci_ = _data_l_798[_data_k_798++];
  }
  ccosh_ = ccosf (ci_ * (*z_));
  __calls[69].calls++;
  return ccosh_;
}

complex_8 _ccot (complex_8 _p_ z_)
{
  static real_4 sqeps_, x2_, y2_, sn2x_, den_;
  int_4 _data_k_799, $0_, $1_, $2_;
  char_127 $3_;
  complex_8 ccot_;
  extern real_4 _r1mach ();
#define _data_n_799 1
  static real_4 _data_l_799[_data_n_799] = {
    0.0
  };
  if (__calls[70].calls == 0) {
    _data_k_799 = 0;
    if (_data_k_799 >= _data_n_799) {
      _data_k_799 = 0;
    }
    sqeps_ = _data_l_799[_data_k_799++];
  }
  if (sqeps_ == 0.0) {
    sqeps_ = sqrtf (_r1mach (($0_ = 4, &$0_)));
  }
  x2_ = 2.0 * (real_4) (crealf ((*z_)));
  y2_ = 2.0 * cimagf ((*z_));
  sn2x_ = sinf (x2_);
  (void) _xerclr ();
  den_ = coshf (y2_) - cosf (x2_);
  if (den_ == 0.0) {
    (void) _xermsg (_dc_0, _dc_120, _dc_121, ($1_ = 2, &$1_), ($2_ = 2, &$2_));
  }
  if (_abs (den_) > _max (_abs (x2_), 1.0) * sqeps_) {
    goto _l10;
  }
  (void) _xerclr ();
  (void) _xermsg (_dc_0, _dc_120, concat ($3_, _dc_122, _dc_123), &_k1, &_k1);
  _l10:;
  ccot_ = CMPLXF (sn2x_ / den_, -sinhf (y2_) / den_);
  __calls[70].calls++;
  return ccot_;
}

complex_8 _cexprl (complex_8 _p_ z_)
{
  static int_4 nterms_, i_;
  static logical_4 first_;
  static real_4 rbnd_, alneps_, xn_, xln_, r_;
  int_4 _data_k_800, $0_, $1_;
  complex_8 cexprl_;
  extern real_4 _r1mach ();
#define _data_n_800 1
  static logical_4 _data_l_800[_data_n_800] = {
    TRUE
  };
  if (__calls[71].calls == 0) {
    _data_k_800 = 0;
    if (_data_k_800 >= _data_n_800) {
      _data_k_800 = 0;
    }
    first_ = _data_l_800[_data_k_800++];
  }
  if (first_) {
    alneps_ = logf (_r1mach (($0_ = 3, &$0_)));
    xn_ = 3.72 - 0.3 * alneps_;
    xln_ = logf ((xn_ + 1.0) / 1.36);
    nterms_ = xn_ - (xn_ * xln_ + alneps_) / (xln_ + 1.36) + 1.5;
    rbnd_ = _r1mach (($1_ = 3, &$1_));
  }
  first_ = FALSE;
  r_ = cabsf ((*z_));
  if (r_ > 0.5) {
    cexprl_ = (cexpf ((*z_)) - 1.0) / (*z_);
  }
  if (r_ > 0.5) {
    goto _l0;
  }
  cexprl_ = CMPLXF (1.0, 0.0);
  if (r_ < rbnd_) {
    goto _l0;
  }
  cexprl_ = CMPLXF (0.0, 0.0);
  for (i_ = 1; i_ <= nterms_; (i_)++) {
    cexprl_ = 1.0 + cexprl_ * (*z_) / (nterms_ + 2 - i_);
  }
  _l0:;
  __calls[71].calls++;
  return cexprl_;
}

complex_8 _cgamma (complex_8 _p_ z_)
{
  complex_8 cgamma_;
  cgamma_ = cexpf (_clngam (z_));
  __calls[72].calls++;
  return cgamma_;
}

complex_8 _cgamr (complex_8 _p_ z_)
{
  static int_4 irold_;
  static real_4 x_;
  complex_8 cgamr_;
  cgamr_ = CMPLXF (0.0, 0.0);
  x_ = (real_4) (crealf ((*z_)));
  if (x_ <= 0.0 && _aintd (x_) == x_ && cimagf ((*z_)) == 0.0) {
    goto _l0;
  }
  (void) _xgetf (&irold_);
  (void) _xsetf (&_k1);
  cgamr_ = _clngam (z_);
  (void) _xerclr ();
  (void) _xsetf (&irold_);
  cgamr_ = cexpf (-cgamr_);
  _l0:;
  __calls[73].calls++;
  return cgamr_;
}

real_4 _chu (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ x_)
{
  static int_4 n_, m_, i_, istrt_;
  static real_4 chu_, pi_, eps_, aintb_, beps_, alnx_, xtoeps_, sum_, t_, xi1_, xi_, factor_, pochai_, gamri1_, gamrni_, 
  b0_, pch1ai_, pch1i_, c0_, xeps1_, xn_, a0_;
  int_4 _data_k_801, _data_k_802, $0_, $1_, $2_, $3_, $4_, $5_, $20_, $21_, $23_, $24_;
  real_4 $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, $22_;
  extern real_4 _gamma ();
  extern real_4 _r1mach ();
#define _data_n_801 1
  static real_4 _data_l_801[_data_n_801] = {
    3.14159265358979324e0
  };
#define _data_n_802 1
  static real_4 _data_l_802[_data_n_802] = {
    0.0
  };
  if (__calls[74].calls == 0) {
    _data_k_801 = 0;
    if (_data_k_801 >= _data_n_801) {
      _data_k_801 = 0;
    }
    pi_ = _data_l_801[_data_k_801++];
  }
  if (__calls[74].calls == 0) {
    _data_k_802 = 0;
    if (_data_k_802 >= _data_n_802) {
      _data_k_802 = 0;
    }
    eps_ = _data_l_802[_data_k_802++];
  }
  if (eps_ == 0.0) {
    eps_ = _r1mach (($0_ = 3, &$0_));
  }
  if ((*x_) == 0.0) {
    (void) _xermsg (_dc_0, _dc_124, _dc_125, &_k1, ($1_ = 2, &$1_));
  }
  if ((*x_) < 0.0) {
    (void) _xermsg (_dc_0, _dc_124, _dc_126, ($2_ = 2, &$2_), ($3_ = 2, &$3_));
  }
  if (_max (_abs ((*a_)), 1.0) * _max (_abs (1.0 + (*a_) - (*b_)), 1.0) < 0.99 * _abs ((*x_))) {
    goto _l120;
  }
  if (_abs (1.0 + (*a_) - (*b_)) < sqrtf (eps_)) {
    (void) _xermsg (_dc_0, _dc_124, _dc_127, ($4_ = 10, &$4_), ($5_ = 2, &$5_));
  }
  aintb_ = _aintd ((*b_) + 0.5);
  if ((*b_) < 0.0) {
    aintb_ = _aintd ((*b_) - 0.5);
  }
  beps_ = (*b_) - aintb_;
  n_ = aintb_;
  alnx_ = logf ((*x_));
  xtoeps_ = expf (-beps_ * alnx_);
  if (n_ >= 1) {
    goto _l40;
  }
  sum_ = 1.0;
  if (n_ == 0) {
    goto _l30;
  }
  t_ = 1.0;
  m_ = -n_;
  for (i_ = 1; i_ <= m_; (i_)++) {
    xi1_ = i_ - 1;
    t_ = t_ * ((*a_) + xi1_) * (*x_) / (((*b_) + xi1_) * (xi1_ + 1.0));
    sum_ = sum_ + t_;
  }
  _l30:;
  sum_ = _poch (($6_ = 1.0 + (*a_) - (*b_), &$6_), ($7_ = -(*a_), &$7_)) * sum_;
  goto _l70;
  _l40:;
  sum_ = 0.0;
  m_ = n_ - 2;
  if (m_ < 0) {
    goto _l70;
  }
  t_ = 1.0;
  sum_ = 1.0;
  if (m_ == 0) {
    goto _l60;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    xi_ = i_;
    t_ = t_ * ((*a_) - (*b_) + xi_) * (*x_) / ((1.0 - (*b_) + xi_) * xi_);
    sum_ = sum_ + t_;
  }
  _l60:;
  sum_ = _gamma (($8_ = (*b_) - 1.0, &$8_)) * _gamr (a_) * _up_real_4 ((*x_), (1 - n_)) * xtoeps_ * sum_;
  _l70:;
  istrt_ = 0;
  if (n_ < 1) {
    istrt_ = 1 - n_;
  }
  xi_ = istrt_;
  factor_ = _up_real_4 (-1.0, n_) * _gamr (($9_ = 1.0 + (*a_) - (*b_), &$9_)) * _up_real_4 ((*x_), istrt_);
  if (beps_ != 0.0) {
    factor_ = factor_ * beps_ * pi_ / sinf (beps_ * pi_);
  }
  pochai_ = _poch (a_, &xi_);
  gamri1_ = _gamr (($10_ = xi_ + 1.0, &$10_));
  gamrni_ = _gamr (($11_ = aintb_ + xi_, &$11_));
  b0_ = factor_ * _poch (a_, ($12_ = xi_ - beps_, &$12_)) * gamrni_ * _gamr (($13_ = xi_ + 1.0 - beps_, &$13_));
  if (_abs (xtoeps_ - 1.0) > 0.5) {
    goto _l90;
  }
  pch1ai_ = _poch1 (($14_ = (*a_) + xi_, &$14_), ($15_ = -beps_, &$15_));
  pch1i_ = _poch1 (($16_ = xi_ + 1.0 - beps_, &$16_), &beps_);
  c0_ = factor_ * pochai_ * gamrni_ * gamri1_ * (-_poch1 (($17_ = (*b_) + xi_, &$17_), ($18_ = -beps_, &$18_)) + pch1ai_ 
  - pch1i_ + beps_ * pch1ai_ * pch1i_);
  xeps1_ = alnx_ * _exprel (($19_ = -beps_ * alnx_, &$19_));
  chu_ = sum_ + c0_ + xeps1_ * b0_;
  xn_ = n_;
  for (i_ = 1; i_ <= 1000; (i_)++) {
    xi_ = istrt_ + i_;
    xi1_ = istrt_ + i_ - 1;
    b0_ = ((*a_) + xi1_ - beps_) * b0_ * (*x_) / ((xn_ + xi1_) * (xi_ - beps_));
    c0_ = ((*a_) + xi1_) * c0_ * (*x_) / (((*b_) + xi1_) * xi_) - (((*a_) - 1.0) * (xn_ + 2.0 * xi_ - 1.0) + xi_ * (xi_ - 
    beps_)) * b0_ / (xi_ * ((*b_) + xi1_) * ((*a_) + xi1_ - beps_));
    t_ = c0_ + xeps1_ * b0_;
    chu_ = chu_ + t_;
    if (_abs (t_) < eps_ * _abs (chu_)) {
      goto _l130;
    }
  }
  (void) _xermsg (_dc_0, _dc_124, _dc_128, ($20_ = 3, &$20_), ($21_ = 2, &$21_));
  _l90:;
  a0_ = factor_ * pochai_ * _gamr (($22_ = (*b_) + xi_, &$22_)) * gamri1_ / beps_;
  b0_ = xtoeps_ * b0_ / beps_;
  chu_ = sum_ + a0_ - b0_;
  for (i_ = 1; i_ <= 1000; (i_)++) {
    xi_ = istrt_ + i_;
    xi1_ = istrt_ + i_ - 1;
    a0_ = ((*a_) + xi1_) * a0_ * (*x_) / (((*b_) + xi1_) * xi_);
    b0_ = ((*a_) + xi1_ - beps_) * b0_ * (*x_) / ((aintb_ + xi1_) * (xi_ - beps_));
    t_ = a0_ - b0_;
    chu_ = chu_ + t_;
    if (_abs (t_) < eps_ * _abs (chu_)) {
      goto _l130;
    }
  }
  (void) _xermsg (_dc_0, _dc_124, _dc_128, ($23_ = 3, &$23_), ($24_ = 2, &$24_));
  _l120:;
  chu_ = powl ((*x_), (-(*a_))) * _r9chu (a_, b_, x_);
  _l130:;
  __calls[74].calls++;
  return chu_;
}
int_4 _ckscl (complex_8 _p_ zr_, real_4 _p_ fnu_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, complex_8 _p_ rz_, 
real_4 _p_ ascle_, real_4 _p_ tol_, real_4 _p_ elim_)
{
  static int_4 i_, ic_, k_, kk_, nn_, nw_;
  static real_4 aa_, acs_, as_, csi_, csr_, fn_, xx_, zri_, elm_, alas_, helim_;
  static complex_8 ck_, cs_, cy_[2], czero_, s1_, s2_, zd_, celm_;
  int_4 _data_k_803;
#define _data_n_803 1
  static complex_8 _data_l_803[_data_n_803] = {
    CMPLXF (0.0, 0.0)
  };
  if (__calls[75].calls == 0) {
    _data_k_803 = 0;
    if (_data_k_803 >= _data_n_803) {
      _data_k_803 = 0;
    }
    czero_ = _data_l_803[_data_k_803++];
  }
  (*nz_) = 0;
  ic_ = 0;
  xx_ = (real_4) (crealf ((*zr_)));
  nn_ = _min (2, (*n_));
  for (i_ = 1; i_ <= nn_; (i_)++) {
    s1_ = y_[i_ - 1];
    cy_[i_ - 1] = s1_;
    as_ = cabsf (s1_);
    acs_ = -xx_ + logf (as_);
    (*nz_) = (*nz_) + 1;
    y_[i_ - 1] = czero_;
    if (acs_ < (-(*elim_))) {
      goto _l10;
    }
    cs_ = -(*zr_) + clogf (s1_);
    csr_ = (real_4) (crealf (cs_));
    csi_ = cimagf (cs_);
    aa_ = expf (csr_) / (*tol_);
    cs_ = CMPLXF (aa_, 0.0) * CMPLXF (cosf (csi_), sinf (csi_));
    (void) _cuchk (&cs_, &nw_, ascle_, tol_);
    if (nw_ != 0) {
      goto _l10;
    }
    y_[i_ - 1] = cs_;
    (*nz_) = (*nz_) - 1;
    ic_ = i_;
    _l10:;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  if (ic_ > 1) {
    goto _l20;
  }
  y_[0] = czero_;
  (*nz_) = 2;
  _l20:;
  if ((*n_) == 2) {
    goto _l0;
  }
  if ((*nz_) == 0) {
    goto _l0;
  }
  fn_ = (*fnu_) + 1.0e0;
  ck_ = CMPLXF (fn_, 0.0) * (*rz_);
  s1_ = cy_[0];
  s2_ = cy_[1];
  helim_ = 0.5e0 * (*elim_);
  elm_ = expf (-(*elim_));
  celm_ = CMPLXF (elm_, 0.0);
  zri_ = cimagf ((*zr_));
  zd_ = (*zr_);
  for (i_ = 3; i_ <= (*n_); (i_)++) {
    kk_ = i_;
    cs_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = cs_;
    ck_ = ck_ + (*rz_);
    as_ = cabsf (s2_);
    alas_ = logf (as_);
    acs_ = -xx_ + alas_;
    (*nz_) = (*nz_) + 1;
    y_[i_ - 1] = czero_;
    if (acs_ < (-(*elim_))) {
      goto _l25;
    }
    cs_ = -zd_ + clogf (s2_);
    csr_ = (real_4) (crealf (cs_));
    csi_ = cimagf (cs_);
    aa_ = expf (csr_) / (*tol_);
    cs_ = CMPLXF (aa_, 0.0) * CMPLXF (cosf (csi_), sinf (csi_));
    (void) _cuchk (&cs_, &nw_, ascle_, tol_);
    if (nw_ != 0) {
      goto _l25;
    }
    y_[i_ - 1] = cs_;
    (*nz_) = (*nz_) - 1;
    if (ic_ == (kk_ - 1)) {
      goto _l40;
    }
    ic_ = kk_;
    goto _l30;
    _l25:;
    if (alas_ < helim_) {
      goto _l30;
    }
    xx_ = xx_ - (*elim_);
    s1_ = s1_ * celm_;
    s2_ = s2_ * celm_;
    zd_ = CMPLXF (xx_, zri_);
    _l30:;
  }
  (*nz_) = (*n_);
  if (ic_ == (*n_)) {
    (*nz_) = (*n_) - 1;
  }
  goto _l45;
  _l40:;
  (*nz_) = kk_ - 2;
  _l45:;
  for (k_ = 1; k_ <= (*nz_); (k_)++) {
    y_[k_ - 1] = czero_;
  }
  _l0:;
  __calls[75].calls++;
  return 0;
}

complex_8 _clbeta (complex_8 _p_ a_, complex_8 _p_ b_)
{
  int_4 $0_;
  complex_8 $1_;
  complex_8 clbeta_;
  if ((real_4) (crealf ((*a_))) <= 0.0 || (real_4) (crealf ((*b_))) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_129, _dc_119, &_k1, ($0_ = 2, &$0_));
  }
  clbeta_ = _clngam (a_) + _clngam (b_) - _clngam (($1_ = (*a_) + (*b_), &$1_));
  __calls[76].calls++;
  return clbeta_;
}

complex_8 _clngam (complex_8 _p_ zin_)
{
  static int_4 n_, i_;
  static logical_4 first_;
  static real_4 pi_, sq2pil_, bound_, dxrel_, x_, y_, cabsz_, argsum_;
  static complex_8 z_, corr_;
  int_4 _data_k_804, _data_k_805, _data_k_806, $0_, $1_, $2_, $3_, $4_, $7_, $8_;
  complex_8 $5_, $6_;
  complex_8 clngam_;
  extern real_4 _r1mach ();
#define _data_n_804 1
  static real_4 _data_l_804[_data_n_804] = {
    3.14159265358979324e0
  };
#define _data_n_805 1
  static real_4 _data_l_805[_data_n_805] = {
    0.91893853320467274e0
  };
#define _data_n_806 1
  static logical_4 _data_l_806[_data_n_806] = {
    TRUE
  };
  if (__calls[77].calls == 0) {
    _data_k_804 = 0;
    if (_data_k_804 >= _data_n_804) {
      _data_k_804 = 0;
    }
    pi_ = _data_l_804[_data_k_804++];
  }
  if (__calls[77].calls == 0) {
    _data_k_805 = 0;
    if (_data_k_805 >= _data_n_805) {
      _data_k_805 = 0;
    }
    sq2pil_ = _data_l_805[_data_k_805++];
  }
  if (__calls[77].calls == 0) {
    _data_k_806 = 0;
    if (_data_k_806 >= _data_n_806) {
      _data_k_806 = 0;
    }
    first_ = _data_l_806[_data_k_806++];
  }
  if (first_) {
    n_ = -0.3 * logf (_r1mach (($0_ = 3, &$0_)));
    bound_ = 0.1171 * n_ * powl ((0.1 * _r1mach (($1_ = 3, &$1_))), (-1.0 / (2 * n_ - 1)));
    dxrel_ = sqrtf (_r1mach (($2_ = 4, &$2_)));
  }
  first_ = FALSE;
  z_ = (*zin_);
  x_ = (real_4) (crealf ((*zin_)));
  y_ = cimagf ((*zin_));
  corr_ = CMPLXF (0.0, 0.0);
  cabsz_ = cabsf (z_);
  if (x_ >= 0.0 && cabsz_ > bound_) {
    goto _l50;
  }
  if (x_ < 0.0 && _abs (y_) > bound_) {
    goto _l50;
  }
  if (cabsz_ < bound_) {
    goto _l20;
  }
  if (y_ > 0.0) {
    z_ = conjf (z_);
  }
  corr_ = cexpf (-CMPLXF (0.0, 2.0 * pi_) * z_);
  if ((real_4) (crealf (corr_)) == 1.0 && cimagf (corr_) == 0.0) {
    (void) _xermsg (_dc_0, _dc_130, _dc_131, ($3_ = 3, &$3_), ($4_ = 2, &$4_));
  }
  clngam_ = sq2pil_ + 1.0 - CMPLXF (0.0, pi_) * (z_ - 0.5) - _clnrel (($5_ = -corr_, &$5_)) + (z_ - 0.5) * clogf (1.0 - 
  z_) - z_ - _c9lgmc (($6_ = 1.0 - z_, &$6_));
  if (y_ > 0.0) {
    clngam_ = conjf (clngam_);
  }
  goto _l0;
  _l20:;
  if (x_ >= -0.5 || _abs (y_) > dxrel_) {
    goto _l30;
  }
  if (cabsf ((z_ - _aintd (x_ - 0.5)) / x_) < dxrel_) {
    (void) _xermsg (_dc_0, _dc_130, _dc_132, &_k1, &_k1);
  }
  _l30:;
  n_ = sqrtf ((bound_ * bound_) - (y_ * y_)) - x_ + 1.0;
  argsum_ = 0.0;
  corr_ = CMPLXF (1.0, 0.0);
  for (i_ = 1; i_ <= n_; (i_)++) {
    argsum_ = argsum_ + _carg (&z_);
    corr_ = z_ * corr_;
    z_ = 1.0 + z_;
  }
  if ((real_4) (crealf (corr_)) == 0.0 && cimagf (corr_) == 0.0) {
    (void) _xermsg (_dc_0, _dc_130, _dc_131, ($7_ = 3, &$7_), ($8_ = 2, &$8_));
  }
  corr_ = -CMPLXF (logf (cabsf (corr_)), argsum_);
  _l50:;
  clngam_ = sq2pil_ + (z_ - 0.5) * clogf (z_) - z_ + corr_ + _c9lgmc (&z_);
  _l0:;
  __calls[77].calls++;
  return clngam_;
}

complex_8 _clnrel (complex_8 _p_ z_)
{
  static real_4 sqeps_, rho_, x_;
  int_4 _data_k_807, $0_;
  real_4 $1_;
  complex_8 $2_;
  complex_8 clnrel_;
  extern real_4 _r1mach ();
#define _data_n_807 1
  static real_4 _data_l_807[_data_n_807] = {
    0.0
  };
  if (__calls[78].calls == 0) {
    _data_k_807 = 0;
    if (_data_k_807 >= _data_n_807) {
      _data_k_807 = 0;
    }
    sqeps_ = _data_l_807[_data_k_807++];
  }
  if (sqeps_ == 0.0) {
    sqeps_ = sqrtf (_r1mach (($0_ = 4, &$0_)));
  }
  if (cabsf (1.0 + (*z_)) < sqeps_) {
    (void) _xermsg (_dc_0, _dc_133, _dc_134, &_k1, &_k1);
  }
  rho_ = cabsf ((*z_));
  if (rho_ > 0.375) {
    clnrel_ = clogf (1.0 + (*z_));
  }
  if (rho_ > 0.375) {
    goto _l0;
  }
  x_ = (real_4) (crealf ((*z_)));
  clnrel_ = CMPLXF (0.5 * _alnrel (($1_ = 2.0 * x_ + (rho_ * rho_), &$1_)), _carg (($2_ = 1.0 + (*z_), &$2_)));
  _l0:;
  __calls[78].calls++;
  return clnrel_;
}

complex_8 _clog10 (complex_8 _p_ z_)
{
  static real_4 aloge_;
  int_4 _data_k_808;
  complex_8 clog10_;
#define _data_n_808 1
  static real_4 _data_l_808[_data_n_808] = {
    0.43429448190325182765e0
  };
  if (__calls[79].calls == 0) {
    _data_k_808 = 0;
    if (_data_k_808 >= _data_n_808) {
      _data_k_808 = 0;
    }
    aloge_ = _data_l_808[_data_k_808++];
  }
  clog10_ = aloge_ * clogf ((*z_));
  __calls[79].calls++;
  return clog10_;
}

int_4 _cmlri (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, real_4 
_p_ tol_)
{
  static int_4 i_, iaz_, idum_, ifnu_, inu_, itime_, k_, kk_, km_, m_;
  static real_4 ack_, ak_, ap_, at_, az_, bk_, fkap_, fkk_, flam_, fnf_, rho_, rho2_, scle_, tfnf_, tst_, x_;
  static complex_8 ck_, cnorm_, cone_, ctwo_, czero_, pt_, p1_, p2_, rz_, sum_;
  int_4 _data_k_809;
  real_4 $0_, $1_, $2_, $3_;
  extern real_4 _r1mach ();
#define _data_n_809 3
  static complex_8 _data_l_809[_data_n_809] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0),
    CMPLXF (2.0, 0.0)
  };
  if (__calls[80].calls == 0) {
    _data_k_809 = 0;
    if (_data_k_809 >= _data_n_809) {
      _data_k_809 = 0;
    }
    czero_ = _data_l_809[_data_k_809++];
    if (_data_k_809 >= _data_n_809) {
      _data_k_809 = 0;
    }
    cone_ = _data_l_809[_data_k_809++];
    if (_data_k_809 >= _data_n_809) {
      _data_k_809 = 0;
    }
    ctwo_ = _data_l_809[_data_k_809++];
  }
  scle_ = 1.0e3 * _r1mach (&_k1) / (*tol_);
  (*nz_) = 0;
  az_ = cabsf ((*z_));
  x_ = (real_4) (crealf ((*z_)));
  iaz_ = az_;
  ifnu_ = (*fnu_);
  inu_ = ifnu_ + (*n_) - 1;
  at_ = iaz_ + 1.0e0;
  ck_ = CMPLXF (at_, 0.0) / (*z_);
  rz_ = ctwo_ / (*z_);
  p1_ = czero_;
  p2_ = cone_;
  ack_ = (at_ + 1.0e0) / az_;
  rho_ = ack_ + sqrtf (ack_ * ack_ - 1.0e0);
  rho2_ = rho_ * rho_;
  tst_ = (rho2_ + rho2_) / ((rho2_ - 1.0e0) * (rho_ - 1.0e0));
  tst_ = tst_ / (*tol_);
  ak_ = at_;
  for (i_ = 1; i_ <= 80; (i_)++) {
    pt_ = p2_;
    p2_ = p1_ - ck_ * p2_;
    p1_ = pt_;
    ck_ = ck_ + rz_;
    ap_ = cabsf (p2_);
    if (ap_ > tst_ * ak_ * ak_) {
      goto _l20;
    }
    ak_ = ak_ + 1.0e0;
  }
  goto _l110;
  _l20:;
  i_ = i_ + 1;
  k_ = 0;
  if (inu_ < iaz_) {
    goto _l40;
  }
  p1_ = czero_;
  p2_ = cone_;
  at_ = inu_ + 1.0e0;
  ck_ = CMPLXF (at_, 0.0) / (*z_);
  ack_ = at_ / az_;
  tst_ = sqrtf (ack_ / (*tol_));
  itime_ = 1;
  for (k_ = 1; k_ <= 80; (k_)++) {
    pt_ = p2_;
    p2_ = p1_ - ck_ * p2_;
    p1_ = pt_;
    ck_ = ck_ + rz_;
    ap_ = cabsf (p2_);
    if (ap_ < tst_) {
      goto _l30;
    }
    if (itime_ == 2) {
      goto _l40;
    }
    ack_ = cabsf (ck_);
    flam_ = ack_ + sqrtf (ack_ * ack_ - 1.0e0);
    fkap_ = ap_ / cabsf (p1_);
    rho_ = _min (flam_, fkap_);
    tst_ = tst_ * sqrtf (rho_ / (rho_ * rho_ - 1.0e0));
    itime_ = 2;
    _l30:;
  }
  goto _l110;
  _l40:;
  k_ = k_ + 1;
  kk_ = _max (i_ + iaz_, k_ + inu_);
  fkk_ = kk_;
  p1_ = czero_;
  p2_ = CMPLXF (scle_, 0.0);
  fnf_ = (*fnu_) - ifnu_;
  tfnf_ = fnf_ + fnf_;
  bk_ = _gamln (($0_ = fkk_ + tfnf_ + 1.0e0, &$0_), &idum_) - _gamln (($1_ = fkk_ + 1.0e0, &$1_), &idum_) - _gamln (($2_ 
  = tfnf_ + 1.0e0, &$2_), &idum_);
  bk_ = expf (bk_);
  sum_ = czero_;
  km_ = kk_ - inu_;
  for (i_ = 1; i_ <= km_; (i_)++) {
    pt_ = p2_;
    p2_ = p1_ + CMPLXF (fkk_ + fnf_, 0.0) * rz_ * p2_;
    p1_ = pt_;
    ak_ = 1.0e0 - tfnf_ / (fkk_ + tfnf_);
    ack_ = bk_ * ak_;
    sum_ = sum_ + CMPLXF (ack_ + bk_, 0.0) * p1_;
    bk_ = ack_;
    fkk_ = fkk_ - 1.0e0;
  }
  y_[(*n_) - 1] = p2_;
  if ((*n_) == 1) {
    goto _l70;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    pt_ = p2_;
    p2_ = p1_ + CMPLXF (fkk_ + fnf_, 0.0) * rz_ * p2_;
    p1_ = pt_;
    ak_ = 1.0e0 - tfnf_ / (fkk_ + tfnf_);
    ack_ = bk_ * ak_;
    sum_ = sum_ + CMPLXF (ack_ + bk_, 0.0) * p1_;
    bk_ = ack_;
    fkk_ = fkk_ - 1.0e0;
    m_ = (*n_) - i_ + 1;
    y_[m_ - 1] = p2_;
  }
  _l70:;
  if (ifnu_ <= 0) {
    goto _l90;
  }
  for (i_ = 1; i_ <= ifnu_; (i_)++) {
    pt_ = p2_;
    p2_ = p1_ + CMPLXF (fkk_ + fnf_, 0.0) * rz_ * p2_;
    p1_ = pt_;
    ak_ = 1.0e0 - tfnf_ / (fkk_ + tfnf_);
    ack_ = bk_ * ak_;
    sum_ = sum_ + CMPLXF (ack_ + bk_, 0.0) * p1_;
    bk_ = ack_;
    fkk_ = fkk_ - 1.0e0;
  }
  _l90:;
  pt_ = (*z_);
  if ((*kode_) == 2) {
    pt_ = pt_ - CMPLXF (x_, 0.0);
  }
  p1_ = -CMPLXF (fnf_, 0.0) * clogf (rz_) + pt_;
  ap_ = _gamln (($3_ = 1.0e0 + fnf_, &$3_), &idum_);
  pt_ = p1_ - CMPLXF (ap_, 0.0);
  p2_ = p2_ + sum_;
  ap_ = cabsf (p2_);
  p1_ = CMPLXF (1.0e0 / ap_, 0.0);
  ck_ = cexpf (pt_) * p1_;
  pt_ = conjf (p2_) * p1_;
  cnorm_ = ck_ * pt_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] * cnorm_;
  }
  goto _l0;
  _l110:;
  (*nz_) = -2;
  _l0:;
  __calls[80].calls++;
  return 0;
}

real_4 _cosdg (real_4 _p_ x_)
{
  static int_4 n_;
  static real_4 cosdg_, raddeg_;
  int_4 _data_k_810;
#define _data_n_810 1
  static real_4 _data_l_810[_data_n_810] = {
    .017453292519943296e0
  };
  if (__calls[81].calls == 0) {
    _data_k_810 = 0;
    if (_data_k_810 >= _data_n_810) {
      _data_k_810 = 0;
    }
    raddeg_ = _data_l_810[_data_k_810++];
  }
  cosdg_ = cosf (raddeg_ * (*x_));
  if (fmodf ((*x_), 90.0) != 0.0) {
    goto _l0;
  }
  n_ = _abs ((*x_)) / 90.0 + 0.5;
  n_ = _imod (n_, 2);
  if (n_ == 0) {
    cosdg_ = _sign (1.0, cosdg_);
  }
  if (n_ == 1) {
    cosdg_ = 0.0;
  }
  _l0:;
  __calls[81].calls++;
  return cosdg_;
}

real_4 _cot (real_4 _p_ x_)
{
  static int_4 nterms_, ifn_;
  static logical_4 first_;
  static real_4 cot_, cotcs_[8], pi2rec_, xmax_, xsml_, xmin_, sqeps_, y_, ainty_, yrem_, prodbg_, ainty2_;
  int_4 _data_k_811, _data_k_812, _data_k_813, _data_k_814, _data_k_815, _data_k_816, _data_k_817, _data_k_818, 
  _data_k_819, _data_k_820, $0_, $1_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_;
  real_4 $2_, $12_, $13_, $14_;
  char_127 $11_;
  extern real_4 _r1mach ();
#define _data_n_811 1
  static real_4 _data_l_811[_data_n_811] = {
    .2402591609829563e0
  };
#define _data_n_812 1
  static real_4 _data_l_812[_data_n_812] = {
    -.016533031601500228e0
  };
#define _data_n_813 1
  static real_4 _data_l_813[_data_n_813] = {
    -.000042998391931724e0
  };
#define _data_n_814 1
  static real_4 _data_l_814[_data_n_814] = {
    -.000000159283223327e0
  };
#define _data_n_815 1
  static real_4 _data_l_815[_data_n_815] = {
    -.000000000619109313e0
  };
#define _data_n_816 1
  static real_4 _data_l_816[_data_n_816] = {
    -.000000000002430197e0
  };
#define _data_n_817 1
  static real_4 _data_l_817[_data_n_817] = {
    -.00000000000000956e0
  };
#define _data_n_818 1
  static real_4 _data_l_818[_data_n_818] = {
    -.000000000000000037e0
  };
#define _data_n_819 1
  static real_4 _data_l_819[_data_n_819] = {
    .011619772367581343e0
  };
#define _data_n_820 1
  static logical_4 _data_l_820[_data_n_820] = {
    TRUE
  };
  if (__calls[82].calls == 0) {
    _data_k_811 = 0;
    if (_data_k_811 >= _data_n_811) {
      _data_k_811 = 0;
    }
    cotcs_[0] = _data_l_811[_data_k_811++];
  }
  if (__calls[82].calls == 0) {
    _data_k_812 = 0;
    if (_data_k_812 >= _data_n_812) {
      _data_k_812 = 0;
    }
    cotcs_[1] = _data_l_812[_data_k_812++];
  }
  if (__calls[82].calls == 0) {
    _data_k_813 = 0;
    if (_data_k_813 >= _data_n_813) {
      _data_k_813 = 0;
    }
    cotcs_[2] = _data_l_813[_data_k_813++];
  }
  if (__calls[82].calls == 0) {
    _data_k_814 = 0;
    if (_data_k_814 >= _data_n_814) {
      _data_k_814 = 0;
    }
    cotcs_[3] = _data_l_814[_data_k_814++];
  }
  if (__calls[82].calls == 0) {
    _data_k_815 = 0;
    if (_data_k_815 >= _data_n_815) {
      _data_k_815 = 0;
    }
    cotcs_[4] = _data_l_815[_data_k_815++];
  }
  if (__calls[82].calls == 0) {
    _data_k_816 = 0;
    if (_data_k_816 >= _data_n_816) {
      _data_k_816 = 0;
    }
    cotcs_[5] = _data_l_816[_data_k_816++];
  }
  if (__calls[82].calls == 0) {
    _data_k_817 = 0;
    if (_data_k_817 >= _data_n_817) {
      _data_k_817 = 0;
    }
    cotcs_[6] = _data_l_817[_data_k_817++];
  }
  if (__calls[82].calls == 0) {
    _data_k_818 = 0;
    if (_data_k_818 >= _data_n_818) {
      _data_k_818 = 0;
    }
    cotcs_[7] = _data_l_818[_data_k_818++];
  }
  if (__calls[82].calls == 0) {
    _data_k_819 = 0;
    if (_data_k_819 >= _data_n_819) {
      _data_k_819 = 0;
    }
    pi2rec_ = _data_l_819[_data_k_819++];
  }
  if (__calls[82].calls == 0) {
    _data_k_820 = 0;
    if (_data_k_820 >= _data_n_820) {
      _data_k_820 = 0;
    }
    first_ = _data_l_820[_data_k_820++];
  }
  if (first_) {
    nterms_ = _inits (cotcs_, ($0_ = 8, &$0_), ($2_ = 0.1 * _r1mach (($1_ = 3, &$1_)), &$2_));
    xmax_ = 1.0 / _r1mach (($3_ = 4, &$3_));
    xsml_ = sqrtf (3.0 * _r1mach (($4_ = 3, &$4_)));
    xmin_ = expf (_max (logf (_r1mach (&_k1)), -logf (_r1mach (($5_ = 2, &$5_)))) + 0.01);
    sqeps_ = sqrtf (_r1mach (($6_ = 4, &$6_)));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (_abs ((*x_)) < xmin_) {
    (void) _xermsg (_dc_0, _dc_135, _dc_136, ($7_ = 2, &$7_), ($8_ = 2, &$8_));
  }
  if (y_ > xmax_) {
    (void) _xermsg (_dc_0, _dc_135, _dc_24, ($9_ = 3, &$9_), ($10_ = 2, &$10_));
  }
  ainty_ = _aintd (y_);
  yrem_ = y_ - ainty_;
  prodbg_ = 0.625 * ainty_;
  ainty_ = _aintd (prodbg_);
  y_ = (prodbg_ - ainty_) + 0.625 * yrem_ + y_ * pi2rec_;
  ainty2_ = _aintd (y_);
  ainty_ = ainty_ + ainty2_;
  y_ = y_ - ainty2_;
  ifn_ = fmodf (ainty_, 2.0);
  if (ifn_ == 1) {
    y_ = 1.0 - y_;
  }
  if (_abs ((*x_)) > 0.5 && y_ < _abs ((*x_)) * sqeps_) {
    (void) _xermsg (_dc_0, _dc_135, concat ($11_, _dc_137, _dc_138), &_k1, &_k1);
  }
  if (y_ > 0.25) {
    goto _l20;
  }
  cot_ = 1.0 / (*x_);
  if (y_ > xsml_) {
    cot_ = (0.5 + _csevl (($12_ = 32.0 * y_ * y_ - 1.0, &$12_), cotcs_, &nterms_)) / y_;
  }
  goto _l40;
  _l20:;
  if (y_ > 0.5) {
    goto _l30;
  }
  cot_ = (0.5 + _csevl (($13_ = 8.0 * y_ * y_ - 1.0, &$13_), cotcs_, &nterms_)) / (0.5 * y_);
  cot_ = ((cot_ * cot_) - 1.0) * 0.5 / cot_;
  goto _l40;
  _l30:;
  cot_ = (0.5 + _csevl (($14_ = 2.0 * y_ * y_ - 1.0, &$14_), cotcs_, &nterms_)) / (0.25 * y_);
  cot_ = ((cot_ * cot_) - 1.0) * 0.5 / cot_;
  cot_ = ((cot_ * cot_) - 1.0) * 0.5 / cot_;
  _l40:;
  if ((*x_) != 0.0) {
    cot_ = _sign (cot_, (*x_));
  }
  if (ifn_ == 1) {
    cot_ = -cot_;
  }
  __calls[82].calls++;
  return cot_;
}

complex_8 _cpsi (complex_8 _p_ zin_)
{
  static int_4 nterm_, n_, i_, ndx_;
  static logical_4 first_;
  static real_4 bern_[13], pi_, bound_, dxrel_, rmin_, rbig_, x_, y_, cabsz_;
  static complex_8 z_, z2inv_, corr_;
  int_4 _data_k_821, _data_k_822, _data_k_823, _data_k_824, _data_k_825, _data_k_826, _data_k_827, _data_k_828, 
  _data_k_829, _data_k_830, _data_k_831, _data_k_832, _data_k_833, _data_k_834, _data_k_835, $0_, $1_, $2_, $3_, $4_, $6_
  , $7_, $8_, $9_;
  complex_8 $5_;
  complex_8 cpsi_;
  extern real_4 _r1mach ();
#define _data_n_821 1
  static real_4 _data_l_821[_data_n_821] = {
    .83333333333333333e-1
  };
#define _data_n_822 1
  static real_4 _data_l_822[_data_n_822] = {
    -.83333333333333333e-2
  };
#define _data_n_823 1
  static real_4 _data_l_823[_data_n_823] = {
    .39682539682539683e-2
  };
#define _data_n_824 1
  static real_4 _data_l_824[_data_n_824] = {
    -.41666666666666667e-2
  };
#define _data_n_825 1
  static real_4 _data_l_825[_data_n_825] = {
    .75757575757575758e-2
  };
#define _data_n_826 1
  static real_4 _data_l_826[_data_n_826] = {
    -.21092796092796093e-1
  };
#define _data_n_827 1
  static real_4 _data_l_827[_data_n_827] = {
    .83333333333333333e-1
  };
#define _data_n_828 1
  static real_4 _data_l_828[_data_n_828] = {
    -.44325980392156863e0
  };
#define _data_n_829 1
  static real_4 _data_l_829[_data_n_829] = {
    .30539543302701197e1
  };
#define _data_n_830 1
  static real_4 _data_l_830[_data_n_830] = {
    -.26456212121212121e2
  };
#define _data_n_831 1
  static real_4 _data_l_831[_data_n_831] = {
    .28146014492753623e3
  };
#define _data_n_832 1
  static real_4 _data_l_832[_data_n_832] = {
    -.34548853937728938e4
  };
#define _data_n_833 1
  static real_4 _data_l_833[_data_n_833] = {
    .54827583333333333e5
  };
#define _data_n_834 1
  static real_4 _data_l_834[_data_n_834] = {
    3.141592653589793e0
  };
#define _data_n_835 1
  static logical_4 _data_l_835[_data_n_835] = {
    TRUE
  };
  if (__calls[83].calls == 0) {
    _data_k_821 = 0;
    if (_data_k_821 >= _data_n_821) {
      _data_k_821 = 0;
    }
    bern_[0] = _data_l_821[_data_k_821++];
  }
  if (__calls[83].calls == 0) {
    _data_k_822 = 0;
    if (_data_k_822 >= _data_n_822) {
      _data_k_822 = 0;
    }
    bern_[1] = _data_l_822[_data_k_822++];
  }
  if (__calls[83].calls == 0) {
    _data_k_823 = 0;
    if (_data_k_823 >= _data_n_823) {
      _data_k_823 = 0;
    }
    bern_[2] = _data_l_823[_data_k_823++];
  }
  if (__calls[83].calls == 0) {
    _data_k_824 = 0;
    if (_data_k_824 >= _data_n_824) {
      _data_k_824 = 0;
    }
    bern_[3] = _data_l_824[_data_k_824++];
  }
  if (__calls[83].calls == 0) {
    _data_k_825 = 0;
    if (_data_k_825 >= _data_n_825) {
      _data_k_825 = 0;
    }
    bern_[4] = _data_l_825[_data_k_825++];
  }
  if (__calls[83].calls == 0) {
    _data_k_826 = 0;
    if (_data_k_826 >= _data_n_826) {
      _data_k_826 = 0;
    }
    bern_[5] = _data_l_826[_data_k_826++];
  }
  if (__calls[83].calls == 0) {
    _data_k_827 = 0;
    if (_data_k_827 >= _data_n_827) {
      _data_k_827 = 0;
    }
    bern_[6] = _data_l_827[_data_k_827++];
  }
  if (__calls[83].calls == 0) {
    _data_k_828 = 0;
    if (_data_k_828 >= _data_n_828) {
      _data_k_828 = 0;
    }
    bern_[7] = _data_l_828[_data_k_828++];
  }
  if (__calls[83].calls == 0) {
    _data_k_829 = 0;
    if (_data_k_829 >= _data_n_829) {
      _data_k_829 = 0;
    }
    bern_[8] = _data_l_829[_data_k_829++];
  }
  if (__calls[83].calls == 0) {
    _data_k_830 = 0;
    if (_data_k_830 >= _data_n_830) {
      _data_k_830 = 0;
    }
    bern_[9] = _data_l_830[_data_k_830++];
  }
  if (__calls[83].calls == 0) {
    _data_k_831 = 0;
    if (_data_k_831 >= _data_n_831) {
      _data_k_831 = 0;
    }
    bern_[10] = _data_l_831[_data_k_831++];
  }
  if (__calls[83].calls == 0) {
    _data_k_832 = 0;
    if (_data_k_832 >= _data_n_832) {
      _data_k_832 = 0;
    }
    bern_[11] = _data_l_832[_data_k_832++];
  }
  if (__calls[83].calls == 0) {
    _data_k_833 = 0;
    if (_data_k_833 >= _data_n_833) {
      _data_k_833 = 0;
    }
    bern_[12] = _data_l_833[_data_k_833++];
  }
  if (__calls[83].calls == 0) {
    _data_k_834 = 0;
    if (_data_k_834 >= _data_n_834) {
      _data_k_834 = 0;
    }
    pi_ = _data_l_834[_data_k_834++];
  }
  if (__calls[83].calls == 0) {
    _data_k_835 = 0;
    if (_data_k_835 >= _data_n_835) {
      _data_k_835 = 0;
    }
    first_ = _data_l_835[_data_k_835++];
  }
  if (first_) {
    nterm_ = -0.3 * logf (_r1mach (($0_ = 3, &$0_)));
    bound_ = 0.1171 * nterm_ * powl ((0.1 * _r1mach (($1_ = 3, &$1_))), (-1.0 / (2 * nterm_ - 1)));
    dxrel_ = sqrtf (_r1mach (($2_ = 4, &$2_)));
    rmin_ = expf (_max (logf (_r1mach (&_k1)), -logf (_r1mach (($3_ = 2, &$3_)))) + 0.011);
    rbig_ = 1.0 / _r1mach (($4_ = 3, &$4_));
  }
  first_ = FALSE;
  z_ = (*zin_);
  x_ = (real_4) (crealf (z_));
  y_ = cimagf (z_);
  if (y_ < 0.0) {
    z_ = conjf (z_);
  }
  corr_ = CMPLXF (0.0, 0.0);
  cabsz_ = cabsf (z_);
  if (x_ >= 0.0 && cabsz_ > bound_) {
    goto _l50;
  }
  if (x_ < 0.0 && _abs (y_) > bound_) {
    goto _l50;
  }
  if (cabsz_ < bound_) {
    goto _l20;
  }
  corr_ = -pi_ * _ccot (($5_ = pi_ * z_, &$5_));
  z_ = 1.0 - z_;
  goto _l50;
  _l20:;
  if (cabsz_ < rmin_) {
    (void) _xermsg (_dc_0, _dc_139, _dc_140, ($6_ = 2, &$6_), ($7_ = 2, &$7_));
  }
  if (x_ >= -0.5 || _abs (y_) > dxrel_) {
    goto _l30;
  }
  if (cabsf ((z_ - _aintd (x_ - 0.5)) / x_) < dxrel_) {
    (void) _xermsg (_dc_0, _dc_139, _dc_132, &_k1, &_k1);
  }
  if (y_ == 0.0 && x_ == _aintd (x_)) {
    (void) _xermsg (_dc_0, _dc_139, _dc_131, ($8_ = 3, &$8_), ($9_ = 2, &$9_));
  }
  _l30:;
  n_ = sqrtf ((bound_ * bound_) - (y_ * y_)) - x_ + 1.0;
  for (i_ = 1; i_ <= n_; (i_)++) {
    corr_ = corr_ - 1.0 / z_;
    z_ = z_ + 1.0;
  }
  _l50:;
  if (cabsz_ > rbig_) {
    cpsi_ = clogf (z_) + corr_;
  }
  if (cabsz_ > rbig_) {
    goto _l70;
  }
  cpsi_ = CMPLXF (0.0, 0.0);
  z2inv_ = 1.0 / (z_ * z_);
  for (i_ = 1; i_ <= nterm_; (i_)++) {
    ndx_ = nterm_ + 1 - i_;
    cpsi_ = bern_[ndx_ - 1] + z2inv_ * cpsi_;
  }
  cpsi_ = clogf (z_) - 0.5 / z_ - cpsi_ * z2inv_ + corr_;
  _l70:;
  if (y_ < 0.0) {
    cpsi_ = conjf (cpsi_);
  }
  __calls[83].calls++;
  return cpsi_;
}

int_4 _cseri (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, real_4 
_p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, ib_, idum_, iflag_, il_, k_, l_, m_, nn_, nw_;
  static real_4 aa_, acz_, ak_, arm_, ascle_, atol_, az_, dfnu_, fnup_, rak1_, rs_, rtr1_, s_, ss_, x_;
  static complex_8 ak1_, ck_, coef_, cone_, crsc_, cz_, czero_, hz_, rz_, s1_, s2_, w_[2];
  int_4 _data_k_836;
  extern real_4 _r1mach ();
#define _data_n_836 2
  static complex_8 _data_l_836[_data_n_836] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0)
  };
  if (__calls[84].calls == 0) {
    _data_k_836 = 0;
    if (_data_k_836 >= _data_n_836) {
      _data_k_836 = 0;
    }
    czero_ = _data_l_836[_data_k_836++];
    if (_data_k_836 >= _data_n_836) {
      _data_k_836 = 0;
    }
    cone_ = _data_l_836[_data_k_836++];
  }
  (*nz_) = 0;
  az_ = cabsf ((*z_));
  if (az_ == 0.0e0) {
    goto _l150;
  }
  x_ = (real_4) (crealf ((*z_)));
  arm_ = 1.0e3 * _r1mach (&_k1);
  rtr1_ = sqrtf (arm_);
  crsc_ = CMPLXF (1.0, 0.0);
  iflag_ = 0;
  if (az_ < arm_) {
    goto _l140;
  }
  hz_ = (*z_) * CMPLXF (0.5, 0.0);
  cz_ = czero_;
  if (az_ > rtr1_) {
    cz_ = hz_ * hz_;
  }
  acz_ = cabsf (cz_);
  nn_ = (*n_);
  ck_ = clogf (hz_);
  _l10:;
  dfnu_ = (*fnu_) + (nn_ - 1);
  fnup_ = dfnu_ + 1.0e0;
  ak1_ = ck_ * CMPLXF (dfnu_, 0.0);
  ak_ = _gamln (&fnup_, &idum_);
  ak1_ = ak1_ - CMPLXF (ak_, 0.0);
  if ((*kode_) == 2) {
    ak1_ = ak1_ - CMPLXF (x_, 0.0);
  }
  rak1_ = (real_4) (crealf (ak1_));
  if (rak1_ > (-(*elim_))) {
    goto _l30;
  }
  _l20:;
  (*nz_) = (*nz_) + 1;
  y_[nn_ - 1] = czero_;
  if (acz_ > dfnu_) {
    goto _l170;
  }
  nn_ = nn_ - 1;
  if (nn_ == 0) {
    goto _l0;
  }
  goto _l10;
  _l30:;
  if (rak1_ > (-(*alim_))) {
    goto _l40;
  }
  iflag_ = 1;
  ss_ = 1.0e0 / (*tol_);
  crsc_ = CMPLXF ((*tol_), 0.0);
  ascle_ = arm_ * ss_;
  _l40:;
  ak_ = cimagf (ak1_);
  aa_ = expf (rak1_);
  if (iflag_ == 1) {
    aa_ = aa_ * ss_;
  }
  coef_ = CMPLXF (aa_, 0.0) * CMPLXF (cosf (ak_), sinf (ak_));
  atol_ = (*tol_) * acz_ / fnup_;
  il_ = _min (2, nn_);
  for (i_ = 1; i_ <= il_; (i_)++) {
    dfnu_ = (*fnu_) + (nn_ - i_);
    fnup_ = dfnu_ + 1.0e0;
    s1_ = cone_;
    if (acz_ < (*tol_) * fnup_) {
      goto _l60;
    }
    ak1_ = cone_;
    ak_ = fnup_ + 2.0e0;
    s_ = fnup_;
    aa_ = 2.0;
    _l50:;
    rs_ = 1.0e0 / s_;
    ak1_ = ak1_ * cz_ * CMPLXF (rs_, 0.0);
    s1_ = s1_ + ak1_;
    s_ = s_ + ak_;
    ak_ = ak_ + 2.0e0;
    aa_ = aa_ * acz_ * rs_;
    if (aa_ > atol_) {
      goto _l50;
    }
    _l60:;
    m_ = nn_ - i_ + 1;
    s2_ = s1_ * coef_;
    w_[i_ - 1] = s2_;
    if (iflag_ == 0) {
      goto _l70;
    }
    (void) _cuchk (&s2_, &nw_, &ascle_, tol_);
    if (nw_ != 0) {
      goto _l20;
    }
    _l70:;
    y_[m_ - 1] = s2_ * crsc_;
    if (i_ != il_) {
      coef_ = coef_ * CMPLXF (dfnu_, 0.0) / hz_;
    }
  }
  if (nn_ <= 2) {
    goto _l0;
  }
  k_ = nn_ - 2;
  ak_ = k_;
  rz_ = (cone_ + cone_) / (*z_);
  if (iflag_ == 1) {
    goto _l110;
  }
  ib_ = 3;
  _l90:;
  for (i_ = ib_; i_ <= nn_; (i_)++) {
    y_[k_ - 1] = CMPLXF (ak_ + (*fnu_), 0.0) * rz_ * y_[k_ + 1 - 1] + y_[k_ + 2 - 1];
    ak_ = ak_ - 1.0e0;
    k_ = k_ - 1;
  }
  goto _l0;
  _l110:;
  s1_ = w_[0];
  s2_ = w_[1];
  for (l_ = 3; l_ <= nn_; (l_)++) {
    ck_ = s2_;
    s2_ = s1_ + CMPLXF (ak_ + (*fnu_), 0.0) * rz_ * s2_;
    s1_ = ck_;
    ck_ = s2_ * crsc_;
    y_[k_ - 1] = ck_;
    ak_ = ak_ - 1.0e0;
    k_ = k_ - 1;
    if (cabsf (ck_) > ascle_) {
      goto _l130;
    }
  }
  goto _l0;
  _l130:;
  ib_ = l_ + 1;
  if (ib_ > nn_) {
    goto _l0;
  }
  goto _l90;
  _l140:;
  (*nz_) = (*n_);
  if ((*fnu_) == 0.0e0) {
    (*nz_) = (*nz_) - 1;
  }
  _l150:;
  y_[0] = czero_;
  if ((*fnu_) == 0.0e0) {
    y_[0] = cone_;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = czero_;
  }
  goto _l0;
  _l170:;
  (*nz_) = -(*nz_);
  _l0:;
  __calls[84].calls++;
  return 0;
}

real_4 _csevl (real_4 _p_ x_, real_4 _p_ cs_, int_4 _p_ n_)
{
  static int_4 i_, ni_;
  static logical_4 first_;
  static real_4 csevl_, b0_, b1_, b2_, onepl_, twox_;
  int_4 _data_k_837, $0_, $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_837 1
  static logical_4 _data_l_837[_data_n_837] = {
    TRUE
  };
  if (__calls[85].calls == 0) {
    _data_k_837 = 0;
    if (_data_k_837 >= _data_n_837) {
      _data_k_837 = 0;
    }
    first_ = _data_l_837[_data_k_837++];
  }
  if (first_) {
    onepl_ = 1.0e0 + _r1mach (($0_ = 4, &$0_));
  }
  first_ = FALSE;
  if ((*n_) < 1) {
    (void) _xermsg (_dc_0, _dc_141, _dc_142, ($1_ = 2, &$1_), ($2_ = 2, &$2_));
  }
  if ((*n_) > 1000) {
    (void) _xermsg (_dc_0, _dc_141, _dc_143, ($3_ = 3, &$3_), ($4_ = 2, &$4_));
  }
  if (_abs ((*x_)) > onepl_) {
    (void) _xermsg (_dc_0, _dc_141, _dc_144, &_k1, &_k1);
  }
  b1_ = 0.0;
  b0_ = 0.0;
  twox_ = 2.0 * (*x_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    b2_ = b1_;
    b1_ = b0_;
    ni_ = (*n_) + 1 - i_;
    b0_ = twox_ * b1_ - b2_ + cs_[ni_ - 1];
  }
  csevl_ = 0.5e0 * (b0_ - b2_);
  __calls[85].calls++;
  return csevl_;
}

complex_8 _csinh (complex_8 _p_ z_)
{
  static complex_8 ci_;
  int_4 _data_k_838;
  complex_8 csinh_;
#define _data_n_838 1
  static complex_8 _data_l_838[_data_n_838] = {
    CMPLXF (0.0, 1.0)
  };
  if (__calls[86].calls == 0) {
    _data_k_838 = 0;
    if (_data_k_838 >= _data_n_838) {
      _data_k_838 = 0;
    }
    ci_ = _data_l_838[_data_k_838++];
  }
  csinh_ = -ci_ * csinf (ci_ * (*z_));
  __calls[86].calls++;
  return csinh_;
}

complex_8 _ctan (complex_8 _p_ z_)
{
  static real_4 sqeps_, x2_, y2_, sn2x_, den_;
  int_4 _data_k_839, $0_, $1_, $2_;
  char_127 $3_;
  complex_8 ctan_;
  extern real_4 _r1mach ();
#define _data_n_839 1
  static real_4 _data_l_839[_data_n_839] = {
    0.0
  };
  if (__calls[87].calls == 0) {
    _data_k_839 = 0;
    if (_data_k_839 >= _data_n_839) {
      _data_k_839 = 0;
    }
    sqeps_ = _data_l_839[_data_k_839++];
  }
  if (sqeps_ == 0.0) {
    sqeps_ = sqrtf (_r1mach (($0_ = 4, &$0_)));
  }
  x2_ = 2.0 * (real_4) (crealf ((*z_)));
  y2_ = 2.0 * cimagf ((*z_));
  sn2x_ = sinf (x2_);
  (void) _xerclr ();
  den_ = cosf (x2_) + coshf (y2_);
  if (den_ == 0.0) {
    (void) _xermsg (_dc_0, _dc_145, _dc_146, ($1_ = 2, &$1_), ($2_ = 2, &$2_));
  }
  if (_abs (den_) > _max (_abs (x2_), 1.0) * sqeps_) {
    goto _l10;
  }
  (void) _xerclr ();
  (void) _xermsg (_dc_0, _dc_145, concat ($3_, _dc_122, _dc_147), &_k1, &_k1);
  _l10:;
  ctan_ = CMPLXF (sn2x_ / den_, sinhf (y2_) / den_);
  __calls[87].calls++;
  return ctan_;
}

complex_8 _ctanh (complex_8 _p_ z_)
{
  static complex_8 ci_, ctan_;
  int_4 _data_k_840;
  complex_8 ctanh_;
#define _data_n_840 1
  static complex_8 _data_l_840[_data_n_840] = {
    CMPLXF (0.0, 1.0)
  };
  if (__calls[88].calls == 0) {
    _data_k_840 = 0;
    if (_data_k_840 >= _data_n_840) {
      _data_k_840 = 0;
    }
    ci_ = _data_l_840[_data_k_840++];
  }
  ctanh_ = -ci_ * ctanf (ci_ * (*z_));
  __calls[88].calls++;
  return ctanh_;
}

int_4 _cuni1 (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, int_4 
_p_ nlast_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, iflag_, init_, k_, m_, nd_, nn_, nuf_, nw_;
  static real_4 aphi_, ascle_, bry_[3], c2i_, c2m_, c2r_, fn_, rs1_, yy_;
  static complex_8 cfn_, cone_, crsc_, cscl_, csr_[3], css_[3], cwrk_[16], czero_, c1_, c2_, phi_, rz_, sum_, s1_, s2_, 
  zeta1_, zeta2_, cy_[2];
  int_4 _data_k_841, $0_;
  extern real_4 _r1mach ();
#define _data_n_841 2
  static complex_8 _data_l_841[_data_n_841] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0)
  };
  if (__calls[89].calls == 0) {
    _data_k_841 = 0;
    if (_data_k_841 >= _data_n_841) {
      _data_k_841 = 0;
    }
    czero_ = _data_l_841[_data_k_841++];
    if (_data_k_841 >= _data_n_841) {
      _data_k_841 = 0;
    }
    cone_ = _data_l_841[_data_k_841++];
  }
  (*nz_) = 0;
  nd_ = (*n_);
  (*nlast_) = 0;
  cscl_ = CMPLXF (1.0e0 / (*tol_), 0.0);
  crsc_ = CMPLXF ((*tol_), 0.0);
  css_[0] = cscl_;
  css_[1] = cone_;
  css_[2] = crsc_;
  csr_[0] = crsc_;
  csr_[1] = cone_;
  csr_[2] = cscl_;
  bry_[0] = 1.0e3 * _r1mach (&_k1) / (*tol_);
  fn_ = _max ((*fnu_), 1.0);
  init_ = 0;
  (void) _cunik (z_, &fn_, &_k1, &_k1, tol_, &init_, &phi_, &zeta1_, &zeta2_, &sum_, cwrk_);
  if ((*kode_) == 1) {
    goto _l10;
  }
  cfn_ = CMPLXF (fn_, 0.0);
  s1_ = -zeta1_ + cfn_ * (cfn_ / ((*z_) + zeta2_));
  goto _l20;
  _l10:;
  s1_ = -zeta1_ + zeta2_;
  _l20:;
  rs1_ = (real_4) (crealf (s1_));
  if (_abs (rs1_) > (*elim_)) {
    goto _l130;
  }
  _l30:;
  nn_ = _min (2, nd_);
  for (i_ = 1; i_ <= nn_; (i_)++) {
    fn_ = (*fnu_) + (nd_ - i_);
    init_ = 0;
    (void) _cunik (z_, &fn_, &_k1, &_k0, tol_, &init_, &phi_, &zeta1_, &zeta2_, &sum_, cwrk_);
    if ((*kode_) == 1) {
      goto _l40;
    }
    cfn_ = CMPLXF (fn_, 0.0);
    yy_ = cimagf ((*z_));
    s1_ = -zeta1_ + cfn_ * (cfn_ / ((*z_) + zeta2_)) + CMPLXF (0.0, yy_);
    goto _l50;
    _l40:;
    s1_ = -zeta1_ + zeta2_;
    _l50:;
    rs1_ = (real_4) (crealf (s1_));
    if (_abs (rs1_) > (*elim_)) {
      goto _l110;
    }
    if (i_ == 1) {
      iflag_ = 2;
    }
    if (_abs (rs1_) < (*alim_)) {
      goto _l60;
    }
    aphi_ = cabsf (phi_);
    rs1_ = rs1_ + logf (aphi_);
    if (_abs (rs1_) > (*elim_)) {
      goto _l110;
    }
    if (i_ == 1) {
      iflag_ = 1;
    }
    if (rs1_ < 0.0e0) {
      goto _l60;
    }
    if (i_ == 1) {
      iflag_ = 3;
    }
    _l60:;
    s2_ = phi_ * sum_;
    c2r_ = (real_4) (crealf (s1_));
    c2i_ = cimagf (s1_);
    c2m_ = expf (c2r_) * (real_4) (crealf (css_[iflag_ - 1]));
    s1_ = CMPLXF (c2m_, 0.0) * CMPLXF (cosf (c2i_), sinf (c2i_));
    s2_ = s2_ * s1_;
    if (iflag_ != 1) {
      goto _l70;
    }
    (void) _cuchk (&s2_, &nw_, &bry_[0], tol_);
    if (nw_ != 0) {
      goto _l110;
    }
    _l70:;
    m_ = nd_ - i_ + 1;
    cy_[i_ - 1] = s2_;
    y_[m_ - 1] = s2_ * csr_[iflag_ - 1];
  }
  if (nd_ <= 2) {
    goto _l100;
  }
  rz_ = CMPLXF (2.0, 0.0) / (*z_);
  bry_[1] = 1.0e0 / bry_[0];
  bry_[2] = _r1mach (($0_ = 2, &$0_));
  s1_ = cy_[0];
  s2_ = cy_[1];
  c1_ = csr_[iflag_ - 1];
  ascle_ = bry_[iflag_ - 1];
  k_ = nd_ - 2;
  fn_ = k_;
  for (i_ = 3; i_ <= nd_; (i_)++) {
    c2_ = s2_;
    s2_ = s1_ + CMPLXF ((*fnu_) + fn_, 0.0) * rz_ * s2_;
    s1_ = c2_;
    c2_ = s2_ * c1_;
    y_[k_ - 1] = c2_;
    k_ = k_ - 1;
    fn_ = fn_ - 1.0e0;
    if (iflag_ >= 3) {
      goto _l90;
    }
    c2r_ = (real_4) (crealf (c2_));
    c2i_ = cimagf (c2_);
    c2r_ = _abs (c2r_);
    c2i_ = _abs (c2i_);
    c2m_ = _max (c2r_, c2i_);
    if (c2m_ <= ascle_) {
      goto _l90;
    }
    iflag_ = iflag_ + 1;
    ascle_ = bry_[iflag_ - 1];
    s1_ = s1_ * c1_;
    s2_ = c2_;
    s1_ = s1_ * css_[iflag_ - 1];
    s2_ = s2_ * css_[iflag_ - 1];
    c1_ = csr_[iflag_ - 1];
    _l90:;
  }
  _l100:;
  goto _l0;
  _l110:;
  if (rs1_ > 0.0e0) {
    goto _l120;
  }
  y_[nd_ - 1] = czero_;
  (*nz_) = (*nz_) + 1;
  nd_ = nd_ - 1;
  if (nd_ == 0) {
    goto _l100;
  }
  (void) _cuoik (z_, fnu_, kode_, &_k1, &nd_, y_, &nuf_, tol_, elim_, alim_);
  if (nuf_ < 0) {
    goto _l120;
  }
  nd_ = nd_ - nuf_;
  (*nz_) = (*nz_) + nuf_;
  if (nd_ == 0) {
    goto _l100;
  }
  fn_ = (*fnu_) + (nd_ - 1);
  if (fn_ >= (*fnul_)) {
    goto _l30;
  }
  (*nlast_) = nd_;
  goto _l0;
  _l120:;
  (*nz_) = -1;
  goto _l0;
  _l130:;
  if (rs1_ > 0.0e0) {
    goto _l120;
  }
  (*nz_) = (*n_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = czero_;
  }
  _l0:;
  __calls[89].calls++;
  return 0;
}

int_4 _cuni2 (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, int_4 
_p_ nlast_, real_4 _p_ fnul_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, iflag_, in_, inu_, j_, k_, nai_, nd_, ndai_, nn_, nuf_, nw_, idum_;
  static real_4 aarg_, aic_, ang_, aphi_, ascle_, ay_, bry_[3], car_, c2i_, c2m_, c2r_, fn_, hpi_, rs1_, sar_, yy_;
  static complex_8 ai_, arg_, asum_, bsum_, cfn_, ci_, cid_, cip_[4], cone_, crsc_, cscl_, csr_[3], css_[3], cy_[2], 
  czero_, c1_, c2_, dai_, phi_, rz_, s1_, s2_, zb_, zeta1_, zeta2_, zn_, zar_;
  int_4 _data_k_842, _data_k_843, _data_k_844, $0_, $1_, $2_;
  extern real_4 _r1mach ();
#define _data_n_842 3
  static complex_8 _data_l_842[_data_n_842] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0),
    CMPLXF (0.0, 1.0)
  };
#define _data_n_843 4
  static complex_8 _data_l_843[_data_n_843] = {
    CMPLXF (1.0, 0.0),
    CMPLXF (0.0, 1.0),
    CMPLXF (-1.0, 0.0),
    CMPLXF (0.0, -1.0)
  };
#define _data_n_844 2
  static real_4 _data_l_844[_data_n_844] = {
    1.57079632679489662e+00,
    1.265512123484645396e+00
  };
  if (__calls[90].calls == 0) {
    _data_k_842 = 0;
    if (_data_k_842 >= _data_n_842) {
      _data_k_842 = 0;
    }
    czero_ = _data_l_842[_data_k_842++];
    if (_data_k_842 >= _data_n_842) {
      _data_k_842 = 0;
    }
    cone_ = _data_l_842[_data_k_842++];
    if (_data_k_842 >= _data_n_842) {
      _data_k_842 = 0;
    }
    ci_ = _data_l_842[_data_k_842++];
  }
  if (__calls[90].calls == 0) {
    _data_k_843 = 0;
    if (_data_k_843 >= _data_n_843) {
      _data_k_843 = 0;
    }
    cip_[0] = _data_l_843[_data_k_843++];
    if (_data_k_843 >= _data_n_843) {
      _data_k_843 = 0;
    }
    cip_[1] = _data_l_843[_data_k_843++];
    if (_data_k_843 >= _data_n_843) {
      _data_k_843 = 0;
    }
    cip_[2] = _data_l_843[_data_k_843++];
    if (_data_k_843 >= _data_n_843) {
      _data_k_843 = 0;
    }
    cip_[3] = _data_l_843[_data_k_843++];
  }
  if (__calls[90].calls == 0) {
    _data_k_844 = 0;
    if (_data_k_844 >= _data_n_844) {
      _data_k_844 = 0;
    }
    hpi_ = _data_l_844[_data_k_844++];
    if (_data_k_844 >= _data_n_844) {
      _data_k_844 = 0;
    }
    aic_ = _data_l_844[_data_k_844++];
  }
  (*nz_) = 0;
  nd_ = (*n_);
  (*nlast_) = 0;
  cscl_ = CMPLXF (1.0e0 / (*tol_), 0.0);
  crsc_ = CMPLXF ((*tol_), 0.0);
  css_[0] = cscl_;
  css_[1] = cone_;
  css_[2] = crsc_;
  csr_[0] = crsc_;
  csr_[1] = cone_;
  csr_[2] = cscl_;
  bry_[0] = 1.0e3 * _r1mach (&_k1) / (*tol_);
  yy_ = cimagf ((*z_));
  zn_ = -(*z_) * ci_;
  zb_ = (*z_);
  cid_ = -ci_;
  inu_ = (*fnu_);
  ang_ = hpi_ * ((*fnu_) - inu_);
  car_ = cosf (ang_);
  sar_ = sinf (ang_);
  c2_ = CMPLXF (car_, sar_);
  zar_ = c2_;
  in_ = inu_ + (*n_) - 1;
  in_ = _imod (in_, 4);
  c2_ = c2_ * cip_[in_ + 1 - 1];
  if (yy_ > 0.0e0) {
    goto _l10;
  }
  zn_ = conjf (-zn_);
  zb_ = conjf (zb_);
  cid_ = -cid_;
  c2_ = conjf (c2_);
  _l10:;
  fn_ = _max ((*fnu_), 1.0);
  (void) _cunhj (&zn_, &fn_, &_k1, tol_, &phi_, &arg_, &zeta1_, &zeta2_, &asum_, &bsum_);
  if ((*kode_) == 1) {
    goto _l20;
  }
  cfn_ = CMPLXF ((*fnu_), 0.0);
  s1_ = -zeta1_ + cfn_ * (cfn_ / (zb_ + zeta2_));
  goto _l30;
  _l20:;
  s1_ = -zeta1_ + zeta2_;
  _l30:;
  rs1_ = (real_4) (crealf (s1_));
  if (_abs (rs1_) > (*elim_)) {
    goto _l150;
  }
  _l40:;
  nn_ = _min (2, nd_);
  for (i_ = 1; i_ <= nn_; (i_)++) {
    fn_ = (*fnu_) + (nd_ - i_);
    (void) _cunhj (&zn_, &fn_, &_k0, tol_, &phi_, &arg_, &zeta1_, &zeta2_, &asum_, &bsum_);
    if ((*kode_) == 1) {
      goto _l50;
    }
    cfn_ = CMPLXF (fn_, 0.0);
    ay_ = _abs (yy_);
    s1_ = -zeta1_ + cfn_ * (cfn_ / (zb_ + zeta2_)) + CMPLXF (0.0, ay_);
    goto _l60;
    _l50:;
    s1_ = -zeta1_ + zeta2_;
    _l60:;
    rs1_ = (real_4) (crealf (s1_));
    if (_abs (rs1_) > (*elim_)) {
      goto _l120;
    }
    if (i_ == 1) {
      iflag_ = 2;
    }
    if (_abs (rs1_) < (*alim_)) {
      goto _l70;
    }
    aphi_ = cabsf (phi_);
    aarg_ = cabsf (arg_);
    rs1_ = rs1_ + logf (aphi_) - 0.25e0 * logf (aarg_) - aic_;
    if (_abs (rs1_) > (*elim_)) {
      goto _l120;
    }
    if (i_ == 1) {
      iflag_ = 1;
    }
    if (rs1_ < 0.0e0) {
      goto _l70;
    }
    if (i_ == 1) {
      iflag_ = 3;
    }
    _l70:;
    (void) _cairy (&arg_, &_k0, ($0_ = 2, &$0_), &ai_, &nai_, &idum_);
    (void) _cairy (&arg_, &_k1, ($1_ = 2, &$1_), &dai_, &ndai_, &idum_);
    s2_ = phi_ * (ai_ * asum_ + dai_ * bsum_);
    c2r_ = (real_4) (crealf (s1_));
    c2i_ = cimagf (s1_);
    c2m_ = expf (c2r_) * (real_4) (crealf (css_[iflag_ - 1]));
    s1_ = CMPLXF (c2m_, 0.0) * CMPLXF (cosf (c2i_), sinf (c2i_));
    s2_ = s2_ * s1_;
    if (iflag_ != 1) {
      goto _l80;
    }
    (void) _cuchk (&s2_, &nw_, &bry_[0], tol_);
    if (nw_ != 0) {
      goto _l120;
    }
    _l80:;
    if (yy_ <= 0.0e0) {
      s2_ = conjf (s2_);
    }
    j_ = nd_ - i_ + 1;
    s2_ = s2_ * c2_;
    cy_[i_ - 1] = s2_;
    y_[j_ - 1] = s2_ * csr_[iflag_ - 1];
    c2_ = c2_ * cid_;
  }
  if (nd_ <= 2) {
    goto _l110;
  }
  rz_ = CMPLXF (2.0, 0.0) / (*z_);
  bry_[1] = 1.0e0 / bry_[0];
  bry_[2] = _r1mach (($2_ = 2, &$2_));
  s1_ = cy_[0];
  s2_ = cy_[1];
  c1_ = csr_[iflag_ - 1];
  ascle_ = bry_[iflag_ - 1];
  k_ = nd_ - 2;
  fn_ = k_;
  for (i_ = 3; i_ <= nd_; (i_)++) {
    c2_ = s2_;
    s2_ = s1_ + CMPLXF ((*fnu_) + fn_, 0.0) * rz_ * s2_;
    s1_ = c2_;
    c2_ = s2_ * c1_;
    y_[k_ - 1] = c2_;
    k_ = k_ - 1;
    fn_ = fn_ - 1.0e0;
    if (iflag_ >= 3) {
      goto _l100;
    }
    c2r_ = (real_4) (crealf (c2_));
    c2i_ = cimagf (c2_);
    c2r_ = _abs (c2r_);
    c2i_ = _abs (c2i_);
    c2m_ = _max (c2r_, c2i_);
    if (c2m_ <= ascle_) {
      goto _l100;
    }
    iflag_ = iflag_ + 1;
    ascle_ = bry_[iflag_ - 1];
    s1_ = s1_ * c1_;
    s2_ = c2_;
    s1_ = s1_ * css_[iflag_ - 1];
    s2_ = s2_ * css_[iflag_ - 1];
    c1_ = csr_[iflag_ - 1];
    _l100:;
  }
  _l110:;
  goto _l0;
  _l120:;
  if (rs1_ > 0.0e0) {
    goto _l140;
  }
  y_[nd_ - 1] = czero_;
  (*nz_) = (*nz_) + 1;
  nd_ = nd_ - 1;
  if (nd_ == 0) {
    goto _l110;
  }
  (void) _cuoik (z_, fnu_, kode_, &_k1, &nd_, y_, &nuf_, tol_, elim_, alim_);
  if (nuf_ < 0) {
    goto _l140;
  }
  nd_ = nd_ - nuf_;
  (*nz_) = (*nz_) + nuf_;
  if (nd_ == 0) {
    goto _l110;
  }
  fn_ = (*fnu_) + (nd_ - 1);
  if (fn_ < (*fnul_)) {
    goto _l130;
  }
  in_ = inu_ + nd_ - 1;
  in_ = _imod (in_, 4) + 1;
  c2_ = zar_ * cip_[in_ - 1];
  if (yy_ <= 0.0e0) {
    c2_ = conjf (c2_);
  }
  goto _l40;
  _l130:;
  (*nlast_) = nd_;
  goto _l0;
  _l140:;
  (*nz_) = -1;
  goto _l0;
  _l150:;
  if (rs1_ > 0.0e0) {
    goto _l140;
  }
  (*nz_) = (*n_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = czero_;
  }
  _l0:;
  __calls[90].calls++;
  return 0;
}

int_4 _cunk1 (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ y_, int_4 
_p_ nz_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, ib_, iflag_, ifn_, il_, init_[2], inu_, iuf_, k_, kdflg_, kflag_, kk_, nw_, j_, ipard_, initd_, ic_, 
  m_;
  static real_4 ang_, aphi_, asc_, ascle_, bry_[3], cpn_, c2i_, c2m_, c2r_, fmr_, fn_, fnf_, pi_, rs1_, sgn_, spn_, x_;
  static complex_8 cfn_, ck_, cone_, crsc_, cs_, cscl_, csgn_, cspn_, csr_[3], css_[3], cwrk_[48], cy_[2], czero_, c1_, 
  c2_, phi_[2], rz_, sum_[2], s1_, s2_, zeta1_[2], zeta2_[2], zr_, phid_, zeta1d_, zeta2d_, sumd_;
  int_4 _data_k_845, _data_k_846, $0_, $1_, $2_;
  extern real_4 _r1mach ();
#define _data_n_845 2
  static complex_8 _data_l_845[_data_n_845] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0)
  };
#define _data_n_846 1
  static real_4 _data_l_846[_data_n_846] = {
    3.14159265358979324e0
  };
  if (__calls[91].calls == 0) {
    _data_k_845 = 0;
    if (_data_k_845 >= _data_n_845) {
      _data_k_845 = 0;
    }
    czero_ = _data_l_845[_data_k_845++];
    if (_data_k_845 >= _data_n_845) {
      _data_k_845 = 0;
    }
    cone_ = _data_l_845[_data_k_845++];
  }
  if (__calls[91].calls == 0) {
    _data_k_846 = 0;
    if (_data_k_846 >= _data_n_846) {
      _data_k_846 = 0;
    }
    pi_ = _data_l_846[_data_k_846++];
  }
  kdflg_ = 1;
  (*nz_) = 0;
  cscl_ = CMPLXF (1.0e0 / (*tol_), 0.0);
  crsc_ = CMPLXF ((*tol_), 0.0);
  css_[0] = cscl_;
  css_[1] = cone_;
  css_[2] = crsc_;
  csr_[0] = crsc_;
  csr_[1] = cone_;
  csr_[2] = cscl_;
  bry_[0] = 1.0e3 * _r1mach (&_k1) / (*tol_);
  bry_[1] = 1.0e0 / bry_[0];
  bry_[2] = _r1mach (($0_ = 2, &$0_));
  x_ = (real_4) (crealf ((*z_)));
  zr_ = (*z_);
  if (x_ < 0.0e0) {
    zr_ = -(*z_);
  }
  j_ = 2;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    j_ = 3 - j_;
    fn_ = (*fnu_) + (i_ - 1);
    init_[j_ - 1] = 0;
    (void) _cunik (&zr_, &fn_, ($1_ = 2, &$1_), &_k0, tol_, &init_[j_ - 1], &phi_[j_ - 1], &zeta1_[j_ - 1], &zeta2_[j_ - 
    1], &sum_[j_ - 1], &cwrk_[0 + (16) * ((j_ - 1))]);
    if ((*kode_) == 1) {
      goto _l20;
    }
    cfn_ = CMPLXF (fn_, 0.0);
    s1_ = zeta1_[j_ - 1] - cfn_ * (cfn_ / (zr_ + zeta2_[j_ - 1]));
    goto _l30;
    _l20:;
    s1_ = zeta1_[j_ - 1] - zeta2_[j_ - 1];
    _l30:;
    rs1_ = (real_4) (crealf (s1_));
    if (_abs (rs1_) > (*elim_)) {
      goto _l60;
    }
    if (kdflg_ == 1) {
      kflag_ = 2;
    }
    if (_abs (rs1_) < (*alim_)) {
      goto _l40;
    }
    aphi_ = cabsf (phi_[j_ - 1]);
    rs1_ = rs1_ + logf (aphi_);
    if (_abs (rs1_) > (*elim_)) {
      goto _l60;
    }
    if (kdflg_ == 1) {
      kflag_ = 1;
    }
    if (rs1_ < 0.0e0) {
      goto _l40;
    }
    if (kdflg_ == 1) {
      kflag_ = 3;
    }
    _l40:;
    s2_ = phi_[j_ - 1] * sum_[j_ - 1];
    c2r_ = (real_4) (crealf (s1_));
    c2i_ = cimagf (s1_);
    c2m_ = expf (c2r_) * (real_4) (crealf (css_[kflag_ - 1]));
    s1_ = CMPLXF (c2m_, 0.0) * CMPLXF (cosf (c2i_), sinf (c2i_));
    s2_ = s2_ * s1_;
    if (kflag_ != 1) {
      goto _l50;
    }
    (void) _cuchk (&s2_, &nw_, &bry_[0], tol_);
    if (nw_ != 0) {
      goto _l60;
    }
    _l50:;
    cy_[kdflg_ - 1] = s2_;
    y_[i_ - 1] = s2_ * csr_[kflag_ - 1];
    if (kdflg_ == 2) {
      goto _l75;
    }
    kdflg_ = 2;
    goto _l70;
    _l60:;
    if (rs1_ > 0.0e0) {
      goto _l290;
    }
    if (x_ < 0.0e0) {
      goto _l290;
    }
    kdflg_ = 1;
    y_[i_ - 1] = czero_;
    (*nz_) = (*nz_) + 1;
    if (i_ == 1) {
      goto _l70;
    }
    if (y_[i_ - 1 - 1] == czero_) {
      goto _l70;
    }
    y_[i_ - 1 - 1] = czero_;
    (*nz_) = (*nz_) + 1;
    _l70:;
  }
  i_ = (*n_);
  _l75:;
  rz_ = CMPLXF (2.0, 0.0) / zr_;
  ck_ = CMPLXF (fn_, 0.0) * rz_;
  ib_ = i_ + 1;
  if ((*n_) < ib_) {
    goto _l160;
  }
  fn_ = (*fnu_) + ((*n_) - 1);
  ipard_ = 1;
  if ((*mr_) != 0) {
    ipard_ = 0;
  }
  initd_ = 0;
  (void) _cunik (&zr_, &fn_, ($2_ = 2, &$2_), &ipard_, tol_, &initd_, &phid_, &zeta1d_, &zeta2d_, &sumd_, &cwrk_[32]);
  if ((*kode_) == 1) {
    goto _l80;
  }
  cfn_ = CMPLXF (fn_, 0.0);
  s1_ = zeta1d_ - cfn_ * (cfn_ / (zr_ + zeta2d_));
  goto _l90;
  _l80:;
  s1_ = zeta1d_ - zeta2d_;
  _l90:;
  rs1_ = (real_4) (crealf (s1_));
  if (_abs (rs1_) > (*elim_)) {
    goto _l95;
  }
  if (_abs (rs1_) < (*alim_)) {
    goto _l100;
  }
  aphi_ = cabsf (phid_);
  rs1_ = rs1_ + logf (aphi_);
  if (_abs (rs1_) < (*elim_)) {
    goto _l100;
  }
  _l95:;
  if (rs1_ > 0.0e0) {
    goto _l290;
  }
  if (x_ < 0.0e0) {
    goto _l290;
  }
  (*nz_) = (*n_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = czero_;
  }
  goto _l0;
  _l100:;
  s1_ = cy_[0];
  s2_ = cy_[1];
  c1_ = csr_[kflag_ - 1];
  ascle_ = bry_[kflag_ - 1];
  for (i_ = ib_; i_ <= (*n_); (i_)++) {
    c2_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = c2_;
    ck_ = ck_ + rz_;
    c2_ = s2_ * c1_;
    y_[i_ - 1] = c2_;
    if (kflag_ >= 3) {
      goto _l120;
    }
    c2r_ = (real_4) (crealf (c2_));
    c2i_ = cimagf (c2_);
    c2r_ = _abs (c2r_);
    c2i_ = _abs (c2i_);
    c2m_ = _max (c2r_, c2i_);
    if (c2m_ <= ascle_) {
      goto _l120;
    }
    kflag_ = kflag_ + 1;
    ascle_ = bry_[kflag_ - 1];
    s1_ = s1_ * c1_;
    s2_ = c2_;
    s1_ = s1_ * css_[kflag_ - 1];
    s2_ = s2_ * css_[kflag_ - 1];
    c1_ = csr_[kflag_ - 1];
    _l120:;
  }
  _l160:;
  if ((*mr_) == 0) {
    goto _l0;
  }
  (*nz_) = 0;
  fmr_ = (*mr_);
  sgn_ = -_sign (pi_, fmr_);
  csgn_ = CMPLXF (0.0, sgn_);
  inu_ = (*fnu_);
  fnf_ = (*fnu_) - inu_;
  ifn_ = inu_ + (*n_) - 1;
  ang_ = fnf_ * sgn_;
  cpn_ = cosf (ang_);
  spn_ = sinf (ang_);
  cspn_ = CMPLXF (cpn_, spn_);
  if (_imod (ifn_, 2) == 1) {
    cspn_ = -cspn_;
  }
  asc_ = bry_[0];
  kk_ = (*n_);
  iuf_ = 0;
  kdflg_ = 1;
  ib_ = ib_ - 1;
  ic_ = ib_ - 1;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    fn_ = (*fnu_) + (kk_ - 1);
    m_ = 3;
    if ((*n_) > 2) {
      goto _l175;
    }
    _l170:;
    initd_ = init_[j_ - 1];
    phid_ = phi_[j_ - 1];
    zeta1d_ = zeta1_[j_ - 1];
    zeta2d_ = zeta2_[j_ - 1];
    sumd_ = sum_[j_ - 1];
    m_ = j_;
    j_ = 3 - j_;
    goto _l180;
    _l175:;
    if ((kk_ == (*n_)) && (ib_ < (*n_))) {
      goto _l180;
    }
    if ((kk_ == ib_) || (kk_ == ic_)) {
      goto _l170;
    }
    initd_ = 0;
    _l180:;
    (void) _cunik (&zr_, &fn_, &_k1, &_k0, tol_, &initd_, &phid_, &zeta1d_, &zeta2d_, &sumd_, &cwrk_[0 + (16) * ((m_ - 
    1))]);
    if ((*kode_) == 1) {
      goto _l190;
    }
    cfn_ = CMPLXF (fn_, 0.0);
    s1_ = -zeta1d_ + cfn_ * (cfn_ / (zr_ + zeta2d_));
    goto _l200;
    _l190:;
    s1_ = -zeta1d_ + zeta2d_;
    _l200:;
    rs1_ = (real_4) (crealf (s1_));
    if (_abs (rs1_) > (*elim_)) {
      goto _l250;
    }
    if (kdflg_ == 1) {
      iflag_ = 2;
    }
    if (_abs (rs1_) < (*alim_)) {
      goto _l210;
    }
    aphi_ = cabsf (phid_);
    rs1_ = rs1_ + logf (aphi_);
    if (_abs (rs1_) > (*elim_)) {
      goto _l250;
    }
    if (kdflg_ == 1) {
      iflag_ = 1;
    }
    if (rs1_ < 0.0e0) {
      goto _l210;
    }
    if (kdflg_ == 1) {
      iflag_ = 3;
    }
    _l210:;
    s2_ = csgn_ * phid_ * sumd_;
    c2r_ = (real_4) (crealf (s1_));
    c2i_ = cimagf (s1_);
    c2m_ = expf (c2r_) * (real_4) (crealf (css_[iflag_ - 1]));
    s1_ = CMPLXF (c2m_, 0.0) * CMPLXF (cosf (c2i_), sinf (c2i_));
    s2_ = s2_ * s1_;
    if (iflag_ != 1) {
      goto _l220;
    }
    (void) _cuchk (&s2_, &nw_, &bry_[0], tol_);
    if (nw_ != 0) {
      s2_ = CMPLXF (0.0, 0.0);
    }
    _l220:;
    cy_[kdflg_ - 1] = s2_;
    c2_ = s2_;
    s2_ = s2_ * csr_[iflag_ - 1];
    s1_ = y_[kk_ - 1];
    if ((*kode_) == 1) {
      goto _l240;
    }
    (void) _cs1s2 (&zr_, &s1_, &s2_, &nw_, &asc_, alim_, &iuf_);
    (*nz_) = (*nz_) + nw_;
    _l240:;
    y_[kk_ - 1] = s1_ * cspn_ + s2_;
    kk_ = kk_ - 1;
    cspn_ = -cspn_;
    if (c2_ != czero_) {
      goto _l245;
    }
    kdflg_ = 1;
    goto _l260;
    _l245:;
    if (kdflg_ == 2) {
      goto _l265;
    }
    kdflg_ = 2;
    goto _l260;
    _l250:;
    if (rs1_ > 0.0e0) {
      goto _l290;
    }
    s2_ = czero_;
    goto _l220;
    _l260:;
  }
  k_ = (*n_);
  _l265:;
  il_ = (*n_) - k_;
  if (il_ == 0) {
    goto _l0;
  }
  s1_ = cy_[0];
  s2_ = cy_[1];
  cs_ = csr_[iflag_ - 1];
  ascle_ = bry_[iflag_ - 1];
  fn_ = (inu_ + il_);
  for (i_ = 1; i_ <= il_; (i_)++) {
    c2_ = s2_;
    s2_ = s1_ + CMPLXF (fn_ + fnf_, 0.0) * rz_ * s2_;
    s1_ = c2_;
    fn_ = fn_ - 1.0e0;
    c2_ = s2_ * cs_;
    ck_ = c2_;
    c1_ = y_[kk_ - 1];
    if ((*kode_) == 1) {
      goto _l270;
    }
    (void) _cs1s2 (&zr_, &c1_, &c2_, &nw_, &asc_, alim_, &iuf_);
    (*nz_) = (*nz_) + nw_;
    _l270:;
    y_[kk_ - 1] = c1_ * cspn_ + c2_;
    kk_ = kk_ - 1;
    cspn_ = -cspn_;
    if (iflag_ >= 3) {
      goto _l280;
    }
    c2r_ = (real_4) (crealf (ck_));
    c2i_ = cimagf (ck_);
    c2r_ = _abs (c2r_);
    c2i_ = _abs (c2i_);
    c2m_ = _max (c2r_, c2i_);
    if (c2m_ <= ascle_) {
      goto _l280;
    }
    iflag_ = iflag_ + 1;
    ascle_ = bry_[iflag_ - 1];
    s1_ = s1_ * cs_;
    s2_ = ck_;
    s1_ = s1_ * css_[iflag_ - 1];
    s2_ = s2_ * css_[iflag_ - 1];
    cs_ = csr_[iflag_ - 1];
    _l280:;
  }
  goto _l0;
  _l290:;
  (*nz_) = -1;
  _l0:;
  __calls[91].calls++;
  return 0;
}

int_4 _cunk2 (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ mr_, int_4 _p_ n_, complex_8 _p_ y_, int_4 
_p_ nz_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, ib_, iflag_, ifn_, il_, in_, inu_, iuf_, k_, kdflg_, kflag_, kk_, nai_, ndai_, nw_, idum_, j_, ipard_, 
  ic_;
  static real_4 aarg_, aic_, ang_, aphi_, asc_, ascle_, bry_[3], car_, cpn_, c2i_, c2m_, c2r_, fmr_, fn_, fnf_, hpi_, pi_
  , rs1_, sar_, sgn_, spn_, x_, yy_;
  static complex_8 ai_, arg_[2], asum_[2], bsum_[2], cfn_, ci_, cip_[4], ck_, cone_, crsc_, cr1_, cr2_, cs_, cscl_, csgn_
  , cspn_, csr_[3], css_[3], cy_[2], czero_, c1_, c2_, dai_, phi_[2], rz_, s1_, s2_, zb_, zeta1_[2], zeta2_[2], zn_, zr_, 
  phid_, argd_, zeta1d_, zeta2d_, asumd_, bsumd_;
  int_4 _data_k_847, _data_k_848, _data_k_849, $0_, $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_847 5
  static complex_8 _data_l_847[_data_n_847] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0),
    CMPLXF (0.0, 1.0),
    CMPLXF (1.0, 1.7320508),
    CMPLXF (-0.5, -0.8660254)
  };
#define _data_n_848 3
  static real_4 _data_l_848[_data_n_848] = {
    1.57079632679489662e+00,
    3.14159265358979324e+00,
    1.26551212348464539e+00
  };
#define _data_n_849 4
  static complex_8 _data_l_849[_data_n_849] = {
    CMPLXF (1.0, 0.0),
    CMPLXF (0.0, -1.0),
    CMPLXF (-1.0, 0.0),
    CMPLXF (0.0, 1.0)
  };
  if (__calls[92].calls == 0) {
    _data_k_847 = 0;
    if (_data_k_847 >= _data_n_847) {
      _data_k_847 = 0;
    }
    czero_ = _data_l_847[_data_k_847++];
    if (_data_k_847 >= _data_n_847) {
      _data_k_847 = 0;
    }
    cone_ = _data_l_847[_data_k_847++];
    if (_data_k_847 >= _data_n_847) {
      _data_k_847 = 0;
    }
    ci_ = _data_l_847[_data_k_847++];
    if (_data_k_847 >= _data_n_847) {
      _data_k_847 = 0;
    }
    cr1_ = _data_l_847[_data_k_847++];
    if (_data_k_847 >= _data_n_847) {
      _data_k_847 = 0;
    }
    cr2_ = _data_l_847[_data_k_847++];
  }
  if (__calls[92].calls == 0) {
    _data_k_848 = 0;
    if (_data_k_848 >= _data_n_848) {
      _data_k_848 = 0;
    }
    hpi_ = _data_l_848[_data_k_848++];
    if (_data_k_848 >= _data_n_848) {
      _data_k_848 = 0;
    }
    pi_ = _data_l_848[_data_k_848++];
    if (_data_k_848 >= _data_n_848) {
      _data_k_848 = 0;
    }
    aic_ = _data_l_848[_data_k_848++];
  }
  if (__calls[92].calls == 0) {
    _data_k_849 = 0;
    if (_data_k_849 >= _data_n_849) {
      _data_k_849 = 0;
    }
    cip_[0] = _data_l_849[_data_k_849++];
    if (_data_k_849 >= _data_n_849) {
      _data_k_849 = 0;
    }
    cip_[1] = _data_l_849[_data_k_849++];
    if (_data_k_849 >= _data_n_849) {
      _data_k_849 = 0;
    }
    cip_[2] = _data_l_849[_data_k_849++];
    if (_data_k_849 >= _data_n_849) {
      _data_k_849 = 0;
    }
    cip_[3] = _data_l_849[_data_k_849++];
  }
  kdflg_ = 1;
  (*nz_) = 0;
  cscl_ = CMPLXF (1.0e0 / (*tol_), 0.0);
  crsc_ = CMPLXF ((*tol_), 0.0);
  css_[0] = cscl_;
  css_[1] = cone_;
  css_[2] = crsc_;
  csr_[0] = crsc_;
  csr_[1] = cone_;
  csr_[2] = cscl_;
  bry_[0] = 1.0e3 * _r1mach (&_k1) / (*tol_);
  bry_[1] = 1.0e0 / bry_[0];
  bry_[2] = _r1mach (($0_ = 2, &$0_));
  x_ = (real_4) (crealf ((*z_)));
  zr_ = (*z_);
  if (x_ < 0.0e0) {
    zr_ = -(*z_);
  }
  yy_ = cimagf (zr_);
  zn_ = -zr_ * ci_;
  zb_ = zr_;
  inu_ = (*fnu_);
  fnf_ = (*fnu_) - inu_;
  ang_ = -hpi_ * fnf_;
  car_ = cosf (ang_);
  sar_ = sinf (ang_);
  cpn_ = -hpi_ * car_;
  spn_ = -hpi_ * sar_;
  c2_ = CMPLXF (-spn_, cpn_);
  kk_ = _imod (inu_, 4) + 1;
  cs_ = cr1_ * c2_ * cip_[kk_ - 1];
  if (yy_ > 0.0e0) {
    goto _l10;
  }
  zn_ = conjf (-zn_);
  zb_ = conjf (zb_);
  _l10:;
  j_ = 2;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    j_ = 3 - j_;
    fn_ = (*fnu_) + (i_ - 1);
    (void) _cunhj (&zn_, &fn_, &_k0, tol_, &phi_[j_ - 1], &arg_[j_ - 1], &zeta1_[j_ - 1], &zeta2_[j_ - 1], &asum_[j_ - 1], 
    &bsum_[j_ - 1]);
    if ((*kode_) == 1) {
      goto _l20;
    }
    cfn_ = CMPLXF (fn_, 0.0);
    s1_ = zeta1_[j_ - 1] - cfn_ * (cfn_ / (zb_ + zeta2_[j_ - 1]));
    goto _l30;
    _l20:;
    s1_ = zeta1_[j_ - 1] - zeta2_[j_ - 1];
    _l30:;
    rs1_ = (real_4) (crealf (s1_));
    if (_abs (rs1_) > (*elim_)) {
      goto _l60;
    }
    if (kdflg_ == 1) {
      kflag_ = 2;
    }
    if (_abs (rs1_) < (*alim_)) {
      goto _l40;
    }
    aphi_ = cabsf (phi_[j_ - 1]);
    aarg_ = cabsf (arg_[j_ - 1]);
    rs1_ = rs1_ + logf (aphi_) - 0.25e0 * logf (aarg_) - aic_;
    if (_abs (rs1_) > (*elim_)) {
      goto _l60;
    }
    if (kdflg_ == 1) {
      kflag_ = 1;
    }
    if (rs1_ < 0.0e0) {
      goto _l40;
    }
    if (kdflg_ == 1) {
      kflag_ = 3;
    }
    _l40:;
    c2_ = arg_[j_ - 1] * cr2_;
    (void) _cairy (&c2_, &_k0, ($1_ = 2, &$1_), &ai_, &nai_, &idum_);
    (void) _cairy (&c2_, &_k1, ($2_ = 2, &$2_), &dai_, &ndai_, &idum_);
    s2_ = cs_ * phi_[j_ - 1] * (ai_ * asum_[j_ - 1] + cr2_ * dai_ * bsum_[j_ - 1]);
    c2r_ = (real_4) (crealf (s1_));
    c2i_ = cimagf (s1_);
    c2m_ = expf (c2r_) * (real_4) (crealf (css_[kflag_ - 1]));
    s1_ = CMPLXF (c2m_, 0.0) * CMPLXF (cosf (c2i_), sinf (c2i_));
    s2_ = s2_ * s1_;
    if (kflag_ != 1) {
      goto _l50;
    }
    (void) _cuchk (&s2_, &nw_, &bry_[0], tol_);
    if (nw_ != 0) {
      goto _l60;
    }
    _l50:;
    if (yy_ <= 0.0e0) {
      s2_ = conjf (s2_);
    }
    cy_[kdflg_ - 1] = s2_;
    y_[i_ - 1] = s2_ * csr_[kflag_ - 1];
    cs_ = -ci_ * cs_;
    if (kdflg_ == 2) {
      goto _l75;
    }
    kdflg_ = 2;
    goto _l70;
    _l60:;
    if (rs1_ > 0.0e0) {
      goto _l300;
    }
    if (x_ < 0.0e0) {
      goto _l300;
    }
    kdflg_ = 1;
    y_[i_ - 1] = czero_;
    cs_ = -ci_ * cs_;
    (*nz_) = (*nz_) + 1;
    if (i_ == 1) {
      goto _l70;
    }
    if (y_[i_ - 1 - 1] == czero_) {
      goto _l70;
    }
    y_[i_ - 1 - 1] = czero_;
    (*nz_) = (*nz_) + 1;
    _l70:;
  }
  i_ = (*n_);
  _l75:;
  rz_ = CMPLXF (2.0, 0.0) / zr_;
  ck_ = CMPLXF (fn_, 0.0) * rz_;
  ib_ = i_ + 1;
  if ((*n_) < ib_) {
    goto _l170;
  }
  fn_ = (*fnu_) + ((*n_) - 1);
  ipard_ = 1;
  if ((*mr_) != 0) {
    ipard_ = 0;
  }
  (void) _cunhj (&zn_, &fn_, &ipard_, tol_, &phid_, &argd_, &zeta1d_, &zeta2d_, &asumd_, &bsumd_);
  if ((*kode_) == 1) {
    goto _l80;
  }
  cfn_ = CMPLXF (fn_, 0.0);
  s1_ = zeta1d_ - cfn_ * (cfn_ / (zb_ + zeta2d_));
  goto _l90;
  _l80:;
  s1_ = zeta1d_ - zeta2d_;
  _l90:;
  rs1_ = (real_4) (crealf (s1_));
  if (_abs (rs1_) > (*elim_)) {
    goto _l95;
  }
  if (_abs (rs1_) < (*alim_)) {
    goto _l100;
  }
  aphi_ = cabsf (phid_);
  aarg_ = cabsf (argd_);
  rs1_ = rs1_ + logf (aphi_) - 0.25e0 * logf (aarg_) - aic_;
  if (_abs (rs1_) < (*elim_)) {
    goto _l100;
  }
  _l95:;
  if (rs1_ > 0.0e0) {
    goto _l300;
  }
  if (x_ < 0.0e0) {
    goto _l300;
  }
  (*nz_) = (*n_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = czero_;
  }
  goto _l0;
  _l100:;
  s1_ = cy_[0];
  s2_ = cy_[1];
  c1_ = csr_[kflag_ - 1];
  ascle_ = bry_[kflag_ - 1];
  for (i_ = ib_; i_ <= (*n_); (i_)++) {
    c2_ = s2_;
    s2_ = ck_ * s2_ + s1_;
    s1_ = c2_;
    ck_ = ck_ + rz_;
    c2_ = s2_ * c1_;
    y_[i_ - 1] = c2_;
    if (kflag_ >= 3) {
      goto _l120;
    }
    c2r_ = (real_4) (crealf (c2_));
    c2i_ = cimagf (c2_);
    c2r_ = _abs (c2r_);
    c2i_ = _abs (c2i_);
    c2m_ = _max (c2r_, c2i_);
    if (c2m_ <= ascle_) {
      goto _l120;
    }
    kflag_ = kflag_ + 1;
    ascle_ = bry_[kflag_ - 1];
    s1_ = s1_ * c1_;
    s2_ = c2_;
    s1_ = s1_ * css_[kflag_ - 1];
    s2_ = s2_ * css_[kflag_ - 1];
    c1_ = csr_[kflag_ - 1];
    _l120:;
  }
  _l170:;
  if ((*mr_) == 0) {
    goto _l0;
  }
  (*nz_) = 0;
  fmr_ = (*mr_);
  sgn_ = -_sign (pi_, fmr_);
  csgn_ = CMPLXF (0.0, sgn_);
  if (yy_ <= 0.0e0) {
    csgn_ = conjf (csgn_);
  }
  ifn_ = inu_ + (*n_) - 1;
  ang_ = fnf_ * sgn_;
  cpn_ = cosf (ang_);
  spn_ = sinf (ang_);
  cspn_ = CMPLXF (cpn_, spn_);
  if (_imod (ifn_, 2) == 1) {
    cspn_ = -cspn_;
  }
  cs_ = CMPLXF (car_, -sar_) * csgn_;
  in_ = _imod (ifn_, 4) + 1;
  c2_ = cip_[in_ - 1];
  cs_ = cs_ * conjf (c2_);
  asc_ = bry_[0];
  kk_ = (*n_);
  kdflg_ = 1;
  ib_ = ib_ - 1;
  ic_ = ib_ - 1;
  iuf_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    fn_ = (*fnu_) + (kk_ - 1);
    if ((*n_) > 2) {
      goto _l180;
    }
    _l175:;
    phid_ = phi_[j_ - 1];
    argd_ = arg_[j_ - 1];
    zeta1d_ = zeta1_[j_ - 1];
    zeta2d_ = zeta2_[j_ - 1];
    asumd_ = asum_[j_ - 1];
    bsumd_ = bsum_[j_ - 1];
    j_ = 3 - j_;
    goto _l190;
    _l180:;
    if ((kk_ == (*n_)) && (ib_ < (*n_))) {
      goto _l190;
    }
    if ((kk_ == ib_) || (kk_ == ic_)) {
      goto _l175;
    }
    (void) _cunhj (&zn_, &fn_, &_k0, tol_, &phid_, &argd_, &zeta1d_, &zeta2d_, &asumd_, &bsumd_);
    _l190:;
    if ((*kode_) == 1) {
      goto _l200;
    }
    cfn_ = CMPLXF (fn_, 0.0);
    s1_ = -zeta1d_ + cfn_ * (cfn_ / (zb_ + zeta2d_));
    goto _l210;
    _l200:;
    s1_ = -zeta1d_ + zeta2d_;
    _l210:;
    rs1_ = (real_4) (crealf (s1_));
    if (_abs (rs1_) > (*elim_)) {
      goto _l260;
    }
    if (kdflg_ == 1) {
      iflag_ = 2;
    }
    if (_abs (rs1_) < (*alim_)) {
      goto _l220;
    }
    aphi_ = cabsf (phid_);
    aarg_ = cabsf (argd_);
    rs1_ = rs1_ + logf (aphi_) - 0.25e0 * logf (aarg_) - aic_;
    if (_abs (rs1_) > (*elim_)) {
      goto _l260;
    }
    if (kdflg_ == 1) {
      iflag_ = 1;
    }
    if (rs1_ < 0.0e0) {
      goto _l220;
    }
    if (kdflg_ == 1) {
      iflag_ = 3;
    }
    _l220:;
    (void) _cairy (&argd_, &_k0, ($3_ = 2, &$3_), &ai_, &nai_, &idum_);
    (void) _cairy (&argd_, &_k1, ($4_ = 2, &$4_), &dai_, &ndai_, &idum_);
    s2_ = cs_ * phid_ * (ai_ * asumd_ + dai_ * bsumd_);
    c2r_ = (real_4) (crealf (s1_));
    c2i_ = cimagf (s1_);
    c2m_ = expf (c2r_) * (real_4) (crealf (css_[iflag_ - 1]));
    s1_ = CMPLXF (c2m_, 0.0) * CMPLXF (cosf (c2i_), sinf (c2i_));
    s2_ = s2_ * s1_;
    if (iflag_ != 1) {
      goto _l230;
    }
    (void) _cuchk (&s2_, &nw_, &bry_[0], tol_);
    if (nw_ != 0) {
      s2_ = CMPLXF (0.0, 0.0);
    }
    _l230:;
    if (yy_ <= 0.0e0) {
      s2_ = conjf (s2_);
    }
    cy_[kdflg_ - 1] = s2_;
    c2_ = s2_;
    s2_ = s2_ * csr_[iflag_ - 1];
    s1_ = y_[kk_ - 1];
    if ((*kode_) == 1) {
      goto _l250;
    }
    (void) _cs1s2 (&zr_, &s1_, &s2_, &nw_, &asc_, alim_, &iuf_);
    (*nz_) = (*nz_) + nw_;
    _l250:;
    y_[kk_ - 1] = s1_ * cspn_ + s2_;
    kk_ = kk_ - 1;
    cspn_ = -cspn_;
    cs_ = -cs_ * ci_;
    if (c2_ != czero_) {
      goto _l255;
    }
    kdflg_ = 1;
    goto _l270;
    _l255:;
    if (kdflg_ == 2) {
      goto _l275;
    }
    kdflg_ = 2;
    goto _l270;
    _l260:;
    if (rs1_ > 0.0e0) {
      goto _l300;
    }
    s2_ = czero_;
    goto _l230;
    _l270:;
  }
  k_ = (*n_);
  _l275:;
  il_ = (*n_) - k_;
  if (il_ == 0) {
    goto _l0;
  }
  s1_ = cy_[0];
  s2_ = cy_[1];
  cs_ = csr_[iflag_ - 1];
  ascle_ = bry_[iflag_ - 1];
  fn_ = inu_ + il_;
  for (i_ = 1; i_ <= il_; (i_)++) {
    c2_ = s2_;
    s2_ = s1_ + CMPLXF (fn_ + fnf_, 0.0) * rz_ * s2_;
    s1_ = c2_;
    fn_ = fn_ - 1.0e0;
    c2_ = s2_ * cs_;
    ck_ = c2_;
    c1_ = y_[kk_ - 1];
    if ((*kode_) == 1) {
      goto _l280;
    }
    (void) _cs1s2 (&zr_, &c1_, &c2_, &nw_, &asc_, alim_, &iuf_);
    (*nz_) = (*nz_) + nw_;
    _l280:;
    y_[kk_ - 1] = c1_ * cspn_ + c2_;
    kk_ = kk_ - 1;
    cspn_ = -cspn_;
    if (iflag_ >= 3) {
      goto _l290;
    }
    c2r_ = (real_4) (crealf (ck_));
    c2i_ = cimagf (ck_);
    c2r_ = _abs (c2r_);
    c2i_ = _abs (c2i_);
    c2m_ = _max (c2r_, c2i_);
    if (c2m_ <= ascle_) {
      goto _l290;
    }
    iflag_ = iflag_ + 1;
    ascle_ = bry_[iflag_ - 1];
    s1_ = s1_ * cs_;
    s2_ = ck_;
    s1_ = s1_ * css_[iflag_ - 1];
    s2_ = s2_ * css_[iflag_ - 1];
    cs_ = csr_[iflag_ - 1];
    _l290:;
  }
  goto _l0;
  _l300:;
  (*nz_) = -1;
  _l0:;
  __calls[92].calls++;
  return 0;
}

int_4 _cuoik (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ ikflg_, int_4 _p_ n_, complex_8 _p_ y_, 
int_4 _p_ nuf_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, iform_, init_, nn_, nw_;
  static real_4 aarg_, aic_, aphi_, ascle_, ax_, ay_, fnn_, gnn_, gnu_, rcz_, x_, yy_;
  static complex_8 arg_, asum_, bsum_, cwrk_[16], cz_, czero_, phi_, sum_, zb_, zeta1_, zeta2_, zn_, zr_;
  int_4 _data_k_850, _data_k_851;
  extern real_4 _r1mach ();
#define _data_n_850 1
  static complex_8 _data_l_850[_data_n_850] = {
    CMPLXF (0.0, 0.0)
  };
#define _data_n_851 1
  static real_4 _data_l_851[_data_n_851] = {
    1.265512123484645396e+00
  };
  if (__calls[93].calls == 0) {
    _data_k_850 = 0;
    if (_data_k_850 >= _data_n_850) {
      _data_k_850 = 0;
    }
    czero_ = _data_l_850[_data_k_850++];
  }
  if (__calls[93].calls == 0) {
    _data_k_851 = 0;
    if (_data_k_851 >= _data_n_851) {
      _data_k_851 = 0;
    }
    aic_ = _data_l_851[_data_k_851++];
  }
  (*nuf_) = 0;
  nn_ = (*n_);
  x_ = (real_4) (crealf ((*z_)));
  zr_ = (*z_);
  if (x_ < 0.0e0) {
    zr_ = -(*z_);
  }
  zb_ = zr_;
  yy_ = cimagf (zr_);
  ax_ = _abs (x_) * 1.7321e0;
  ay_ = _abs (yy_);
  iform_ = 1;
  if (ay_ > ax_) {
    iform_ = 2;
  }
  gnu_ = _max ((*fnu_), 1.0);
  if ((*ikflg_) == 1) {
    goto _l10;
  }
  fnn_ = nn_;
  gnn_ = (*fnu_) + fnn_ - 1.0e0;
  gnu_ = _max (gnn_, fnn_);
  _l10:;
  if (iform_ == 2) {
    goto _l20;
  }
  init_ = 0;
  (void) _cunik (&zr_, &gnu_, ikflg_, &_k1, tol_, &init_, &phi_, &zeta1_, &zeta2_, &sum_, cwrk_);
  cz_ = -zeta1_ + zeta2_;
  goto _l40;
  _l20:;
  zn_ = -zr_ * CMPLXF (0.0, 1.0);
  if (yy_ > 0.0e0) {
    goto _l30;
  }
  zn_ = conjf (-zn_);
  _l30:;
  (void) _cunhj (&zn_, &gnu_, &_k1, tol_, &phi_, &arg_, &zeta1_, &zeta2_, &asum_, &bsum_);
  cz_ = -zeta1_ + zeta2_;
  aarg_ = cabsf (arg_);
  _l40:;
  if ((*kode_) == 2) {
    cz_ = cz_ - zb_;
  }
  if ((*ikflg_) == 2) {
    cz_ = -cz_;
  }
  aphi_ = cabsf (phi_);
  rcz_ = (real_4) (crealf (cz_));
  if (rcz_ > (*elim_)) {
    goto _l170;
  }
  if (rcz_ < (*alim_)) {
    goto _l50;
  }
  rcz_ = rcz_ + logf (aphi_);
  if (iform_ == 2) {
    rcz_ = rcz_ - 0.25e0 * logf (aarg_) - aic_;
  }
  if (rcz_ > (*elim_)) {
    goto _l170;
  }
  goto _l100;
  _l50:;
  if (rcz_ < (-(*elim_))) {
    goto _l60;
  }
  if (rcz_ > (-(*alim_))) {
    goto _l100;
  }
  rcz_ = rcz_ + logf (aphi_);
  if (iform_ == 2) {
    rcz_ = rcz_ - 0.25e0 * logf (aarg_) - aic_;
  }
  if (rcz_ > (-(*elim_))) {
    goto _l80;
  }
  _l60:;
  for (i_ = 1; i_ <= nn_; (i_)++) {
    y_[i_ - 1] = czero_;
  }
  (*nuf_) = nn_;
  goto _l0;
  _l80:;
  ascle_ = 1.0e3 * _r1mach (&_k1) / (*tol_);
  cz_ = cz_ + clogf (phi_);
  if (iform_ == 1) {
    goto _l90;
  }
  cz_ = cz_ - CMPLXF (0.25, 0.0) * clogf (arg_) - CMPLXF (aic_, 0.0);
  _l90:;
  ax_ = expf (rcz_) / (*tol_);
  ay_ = cimagf (cz_);
  cz_ = CMPLXF (ax_, 0.0) * CMPLXF (cosf (ay_), sinf (ay_));
  (void) _cuchk (&cz_, &nw_, &ascle_, tol_);
  if (nw_ == 1) {
    goto _l60;
  }
  _l100:;
  if ((*ikflg_) == 2) {
    goto _l0;
  }
  if ((*n_) == 1) {
    goto _l0;
  }
  _l110:;
  gnu_ = (*fnu_) + (nn_ - 1);
  if (iform_ == 2) {
    goto _l120;
  }
  init_ = 0;
  (void) _cunik (&zr_, &gnu_, ikflg_, &_k1, tol_, &init_, &phi_, &zeta1_, &zeta2_, &sum_, cwrk_);
  cz_ = -zeta1_ + zeta2_;
  goto _l130;
  _l120:;
  (void) _cunhj (&zn_, &gnu_, &_k1, tol_, &phi_, &arg_, &zeta1_, &zeta2_, &asum_, &bsum_);
  cz_ = -zeta1_ + zeta2_;
  aarg_ = cabsf (arg_);
  _l130:;
  if ((*kode_) == 2) {
    cz_ = cz_ - zb_;
  }
  aphi_ = cabsf (phi_);
  rcz_ = (real_4) (crealf (cz_));
  if (rcz_ < (-(*elim_))) {
    goto _l140;
  }
  if (rcz_ > (-(*alim_))) {
    goto _l0;
  }
  rcz_ = rcz_ + logf (aphi_);
  if (iform_ == 2) {
    rcz_ = rcz_ - 0.25e0 * logf (aarg_) - aic_;
  }
  if (rcz_ > (-(*elim_))) {
    goto _l150;
  }
  _l140:;
  y_[nn_ - 1] = czero_;
  nn_ = nn_ - 1;
  (*nuf_) = (*nuf_) + 1;
  if (nn_ == 0) {
    goto _l0;
  }
  goto _l110;
  _l150:;
  ascle_ = 1.0e3 * _r1mach (&_k1) / (*tol_);
  cz_ = cz_ + clogf (phi_);
  if (iform_ == 1) {
    goto _l160;
  }
  cz_ = cz_ - CMPLXF (0.25, 0.0) * clogf (arg_) - CMPLXF (aic_, 0.0);
  _l160:;
  ax_ = expf (rcz_) / (*tol_);
  ay_ = cimagf (cz_);
  cz_ = CMPLXF (ax_, 0.0) * CMPLXF (cosf (ay_), sinf (ay_));
  (void) _cuchk (&cz_, &nw_, &ascle_, tol_);
  if (nw_ == 1) {
    goto _l140;
  }
  goto _l0;
  _l170:;
  (*nuf_) = -1;
  _l0:;
  __calls[93].calls++;
  return 0;
}

int_4 _cwrsk (complex_8 _p_ zr_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, 
complex_8 _p_ cw_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, nw_;
  static real_4 act_, acw_, ascle_, s1_, s2_, yy_;
  static complex_8 cinu_, cscl_, ct_, c1_, c2_, rct_, st_;
  int_4 $0_;
  extern real_4 _r1mach ();
  (*nz_) = 0;
  (void) _cbknu (zr_, fnu_, kode_, ($0_ = 2, &$0_), cw_, &nw_, tol_, elim_, alim_);
  if (nw_ != 0) {
    goto _l50;
  }
  (void) _crati (zr_, fnu_, n_, y_, tol_);
  cinu_ = CMPLXF (1.0, 0.0);
  if ((*kode_) == 1) {
    goto _l10;
  }
  yy_ = cimagf ((*zr_));
  s1_ = cosf (yy_);
  s2_ = sinf (yy_);
  cinu_ = CMPLXF (s1_, s2_);
  _l10:;
  acw_ = cabsf (cw_[1]);
  ascle_ = 1.0e3 * _r1mach (&_k1) / (*tol_);
  cscl_ = CMPLXF (1.0, 0.0);
  if (acw_ > ascle_) {
    goto _l20;
  }
  cscl_ = CMPLXF (1.0e0 / (*tol_), 0.0);
  goto _l30;
  _l20:;
  ascle_ = 1.0e0 / ascle_;
  if (acw_ < ascle_) {
    goto _l30;
  }
  cscl_ = CMPLXF ((*tol_), 0.0);
  _l30:;
  c1_ = cw_[0] * cscl_;
  c2_ = cw_[1] * cscl_;
  st_ = y_[0];
  ct_ = (*zr_) * (c2_ + st_ * c1_);
  act_ = cabsf (ct_);
  rct_ = CMPLXF (1.0e0 / act_, 0.0);
  ct_ = conjf (ct_) * rct_;
  cinu_ = cinu_ * rct_ * ct_;
  y_[0] = cinu_ * cscl_;
  if ((*n_) == 1) {
    goto _l0;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    cinu_ = st_ * cinu_;
    st_ = y_[i_ - 1];
    y_[i_ - 1] = cinu_ * cscl_;
  }
  goto _l0;
  _l50:;
  (*nz_) = -1;
  if (nw_ == -2) {
    (*nz_) = -2;
  }
  _l0:;
  __calls[94].calls++;
  return 0;
}

int_4 _d9aimp (real_8 _p_ x_, real_8 _p_ ampl_, real_8 _p_ theta_)
{
  static int_4 nam20_, nath0_, nam21_, nath1_, nam22_, nath2_;
  static logical_4 first_;
  static real_4 eta_;
  static real_8 am20cs_[57], ath0cs_[53], am21cs_[60], ath1cs_[58], am22cs_[74], ath2cs_[72], pi4_, sqrtx_, xsml_, z_;
  int_4 _data_k_852, _data_k_853, _data_k_854, _data_k_855, _data_k_856, _data_k_857, _data_k_858, _data_k_859, 
  _data_k_860, _data_k_861, _data_k_862, _data_k_863, _data_k_864, _data_k_865, _data_k_866, _data_k_867, _data_k_868, 
  _data_k_869, _data_k_870, _data_k_871, _data_k_872, _data_k_873, _data_k_874, _data_k_875, _data_k_876, _data_k_877, 
  _data_k_878, _data_k_879, _data_k_880, _data_k_881, _data_k_882, _data_k_883, _data_k_884, _data_k_885, _data_k_886, 
  _data_k_887, _data_k_888, _data_k_889, _data_k_890, _data_k_891, _data_k_892, _data_k_893, _data_k_894, _data_k_895, 
  _data_k_896, _data_k_897, _data_k_898, _data_k_899, _data_k_900, _data_k_901, _data_k_902, _data_k_903, _data_k_904, 
  _data_k_905, _data_k_906, _data_k_907, _data_k_908, _data_k_909, _data_k_910, _data_k_911, _data_k_912, _data_k_913, 
  _data_k_914, _data_k_915, _data_k_916, _data_k_917, _data_k_918, _data_k_919, _data_k_920, _data_k_921, _data_k_922, 
  _data_k_923, _data_k_924, _data_k_925, _data_k_926, _data_k_927, _data_k_928, _data_k_929, _data_k_930, _data_k_931, 
  _data_k_932, _data_k_933, _data_k_934, _data_k_935, _data_k_936, _data_k_937, _data_k_938, _data_k_939, _data_k_940, 
  _data_k_941, _data_k_942, _data_k_943, _data_k_944, _data_k_945, _data_k_946, _data_k_947, _data_k_948, _data_k_949, 
  _data_k_950, _data_k_951, _data_k_952, _data_k_953, _data_k_954, _data_k_955, _data_k_956, _data_k_957, _data_k_958, 
  _data_k_959, _data_k_960, _data_k_961, _data_k_962, _data_k_963, _data_k_964, _data_k_965, _data_k_966, _data_k_967, 
  _data_k_968, _data_k_969, _data_k_970, _data_k_971, _data_k_972, _data_k_973, _data_k_974, _data_k_975, _data_k_976, 
  _data_k_977, _data_k_978, _data_k_979, _data_k_980, _data_k_981, _data_k_982, _data_k_983, _data_k_984, _data_k_985, 
  _data_k_986, _data_k_987, _data_k_988, _data_k_989, _data_k_990, _data_k_991, _data_k_992, _data_k_993, _data_k_994, 
  _data_k_995, _data_k_996, _data_k_997, _data_k_998, _data_k_999, _data_k_1000, _data_k_1001, _data_k_1002, _data_k_1003
  , _data_k_1004, _data_k_1005, _data_k_1006, _data_k_1007, _data_k_1008, _data_k_1009, _data_k_1010, _data_k_1011, 
  _data_k_1012, _data_k_1013, _data_k_1014, _data_k_1015, _data_k_1016, _data_k_1017, _data_k_1018, _data_k_1019, 
  _data_k_1020, _data_k_1021, _data_k_1022, _data_k_1023, _data_k_1024, _data_k_1025, _data_k_1026, _data_k_1027, 
  _data_k_1028, _data_k_1029, _data_k_1030, _data_k_1031, _data_k_1032, _data_k_1033, _data_k_1034, _data_k_1035, 
  _data_k_1036, _data_k_1037, _data_k_1038, _data_k_1039, _data_k_1040, _data_k_1041, _data_k_1042, _data_k_1043, 
  _data_k_1044, _data_k_1045, _data_k_1046, _data_k_1047, _data_k_1048, _data_k_1049, _data_k_1050, _data_k_1051, 
  _data_k_1052, _data_k_1053, _data_k_1054, _data_k_1055, _data_k_1056, _data_k_1057, _data_k_1058, _data_k_1059, 
  _data_k_1060, _data_k_1061, _data_k_1062, _data_k_1063, _data_k_1064, _data_k_1065, _data_k_1066, _data_k_1067, 
  _data_k_1068, _data_k_1069, _data_k_1070, _data_k_1071, _data_k_1072, _data_k_1073, _data_k_1074, _data_k_1075, 
  _data_k_1076, _data_k_1077, _data_k_1078, _data_k_1079, _data_k_1080, _data_k_1081, _data_k_1082, _data_k_1083, 
  _data_k_1084, _data_k_1085, _data_k_1086, _data_k_1087, _data_k_1088, _data_k_1089, _data_k_1090, _data_k_1091, 
  _data_k_1092, _data_k_1093, _data_k_1094, _data_k_1095, _data_k_1096, _data_k_1097, _data_k_1098, _data_k_1099, 
  _data_k_1100, _data_k_1101, _data_k_1102, _data_k_1103, _data_k_1104, _data_k_1105, _data_k_1106, _data_k_1107, 
  _data_k_1108, _data_k_1109, _data_k_1110, _data_k_1111, _data_k_1112, _data_k_1113, _data_k_1114, _data_k_1115, 
  _data_k_1116, _data_k_1117, _data_k_1118, _data_k_1119, _data_k_1120, _data_k_1121, _data_k_1122, _data_k_1123, 
  _data_k_1124, _data_k_1125, _data_k_1126, _data_k_1127, _data_k_1128, _data_k_1129, _data_k_1130, _data_k_1131, 
  _data_k_1132, _data_k_1133, _data_k_1134, _data_k_1135, _data_k_1136, _data_k_1137, _data_k_1138, _data_k_1139, 
  _data_k_1140, _data_k_1141, _data_k_1142, _data_k_1143, _data_k_1144, _data_k_1145, _data_k_1146, _data_k_1147, 
  _data_k_1148, _data_k_1149, _data_k_1150, _data_k_1151, _data_k_1152, _data_k_1153, _data_k_1154, _data_k_1155, 
  _data_k_1156, _data_k_1157, _data_k_1158, _data_k_1159, _data_k_1160, _data_k_1161, _data_k_1162, _data_k_1163, 
  _data_k_1164, _data_k_1165, _data_k_1166, _data_k_1167, _data_k_1168, _data_k_1169, _data_k_1170, _data_k_1171, 
  _data_k_1172, _data_k_1173, _data_k_1174, _data_k_1175, _data_k_1176, _data_k_1177, _data_k_1178, _data_k_1179, 
  _data_k_1180, _data_k_1181, _data_k_1182, _data_k_1183, _data_k_1184, _data_k_1185, _data_k_1186, _data_k_1187, 
  _data_k_1188, _data_k_1189, _data_k_1190, _data_k_1191, _data_k_1192, _data_k_1193, _data_k_1194, _data_k_1195, 
  _data_k_1196, _data_k_1197, _data_k_1198, _data_k_1199, _data_k_1200, _data_k_1201, _data_k_1202, _data_k_1203, 
  _data_k_1204, _data_k_1205, _data_k_1206, _data_k_1207, _data_k_1208, _data_k_1209, _data_k_1210, _data_k_1211, 
  _data_k_1212, _data_k_1213, _data_k_1214, _data_k_1215, _data_k_1216, _data_k_1217, _data_k_1218, _data_k_1219, 
  _data_k_1220, _data_k_1221, _data_k_1222, _data_k_1223, _data_k_1224, _data_k_1225, _data_k_1226, _data_k_1227, $0_, 
  $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern real_8 _d1mach ();
#define _data_n_852 1
  static real_8 _data_l_852[_data_n_852] = {
    .108716749086561856615730588125e-1
  };
#define _data_n_853 1
  static real_8 _data_l_853[_data_n_853] = {
    .369489228982663555091728665146e-3
  };
#define _data_n_854 1
  static real_8 _data_l_854[_data_n_854] = {
    .440680100484689563667507001327e-5
  };
#define _data_n_855 1
  static real_8 _data_l_855[_data_n_855] = {
    .143686762361911153929183952833e-6
  };
#define _data_n_856 1
  static real_8 _data_l_856[_data_n_856] = {
    .824275552390078308670628855353e-8
  };
#define _data_n_857 1
  static real_8 _data_l_857[_data_n_857] = {
    .68442675889366160617392727818e-9
  };
#define _data_n_858 1
  static real_8 _data_l_858[_data_n_858] = {
    .739566697282739287731004740213e-10
  };
#define _data_n_859 1
  static real_8 _data_l_859[_data_n_859] = {
    .974595633696825017638702600847e-11
  };
#define _data_n_860 1
  static real_8 _data_l_860[_data_n_860] = {
    .150076885829405775650973119497e-11
  };
#define _data_n_861 1
  static real_8 _data_l_861[_data_n_861] = {
    .262147910221527634206252854802e-12
  };
#define _data_n_862 1
  static real_8 _data_l_862[_data_n_862] = {
    .508354111376487180357278966914e-13
  };
#define _data_n_863 1
  static real_8 _data_l_863[_data_n_863] = {
    .10768475335881144049298599707e-13
  };
#define _data_n_864 1
  static real_8 _data_l_864[_data_n_864] = {
    .246091286618433429335914062617e-14
  };
#define _data_n_865 1
  static real_8 _data_l_865[_data_n_865] = {
    .60078638035865641843611037355e-15
  };
#define _data_n_866 1
  static real_8 _data_l_866[_data_n_866] = {
    .155449156102388071150651388384e-15
  };
#define _data_n_867 1
  static real_8 _data_l_867[_data_n_867] = {
    .423535125035576604426382780182e-16
  };
#define _data_n_868 1
  static real_8 _data_l_868[_data_n_868] = {
    .120862166289299840154401109189e-16
  };
#define _data_n_869 1
  static real_8 _data_l_869[_data_n_869] = {
    .359609651214658240861499706423e-17
  };
#define _data_n_870 1
  static real_8 _data_l_870[_data_n_870] = {
    .111134218386395638261774604677e-17
  };
#define _data_n_871 1
  static real_8 _data_l_871[_data_n_871] = {
    .355559532432366609893680289225e-18
  };
#define _data_n_872 1
  static real_8 _data_l_872[_data_n_872] = {
    .117433021600139309998766947387e-18
  };
#define _data_n_873 1
  static real_8 _data_l_873[_data_n_873] = {
    .399397454661077561389162200966e-19
  };
#define _data_n_874 1
  static real_8 _data_l_874[_data_n_874] = {
    .13957667152891631042560632564e-19
  };
#define _data_n_875 1
  static real_8 _data_l_875[_data_n_875] = {
    .500240055309236041393459280716e-20
  };
#define _data_n_876 1
  static real_8 _data_l_876[_data_n_876] = {
    .183552760958132679184834866457e-20
  };
#define _data_n_877 1
  static real_8 _data_l_877[_data_n_877] = {
    .688490998179202743197790112404e-21
  };
#define _data_n_878 1
  static real_8 _data_l_878[_data_n_878] = {
    .263631035611417012359996885105e-21
  };
#define _data_n_879 1
  static real_8 _data_l_879[_data_n_879] = {
    .102924890237338360287153563785e-21
  };
#define _data_n_880 1
  static real_8 _data_l_880[_data_n_880] = {
    .409246966671594885489762960571e-22
  };
#define _data_n_881 1
  static real_8 _data_l_881[_data_n_881] = {
    .165558573406734651039727903828e-22
  };
#define _data_n_882 1
  static real_8 _data_l_882[_data_n_882] = {
    .680797467063033356116599685727e-23
  };
#define _data_n_883 1
  static real_8 _data_l_883[_data_n_883] = {
    .284326559934079832419751134476e-23
  };
#define _data_n_884 1
  static real_8 _data_l_884[_data_n_884] = {
    .120507398348965255097287818819e-23
  };
#define _data_n_885 1
  static real_8 _data_l_885[_data_n_885] = {
    .517961243287505217976613610424e-24
  };
#define _data_n_886 1
  static real_8 _data_l_886[_data_n_886] = {
    .225622613427562816303268640887e-24
  };
#define _data_n_887 1
  static real_8 _data_l_887[_data_n_887] = {
    .995418801147745168832117078246e-25
  };
#define _data_n_888 1
  static real_8 _data_l_888[_data_n_888] = {
    .444551696397342424308280582053e-25
  };
#define _data_n_889 1
  static real_8 _data_l_889[_data_n_889] = {
    .200865195461501101425916097338e-25
  };
#define _data_n_890 1
  static real_8 _data_l_890[_data_n_890] = {
    .917786344151775165973885645402e-26
  };
#define _data_n_891 1
  static real_8 _data_l_891[_data_n_891] = {
    .423872958105589240661672197948e-26
  };
#define _data_n_892 1
  static real_8 _data_l_892[_data_n_892] = {
    .19778927200784609237084625149e-26
  };
#define _data_n_893 1
  static real_8 _data_l_893[_data_n_893] = {
    .932116351284620665680435253373e-27
  };
#define _data_n_894 1
  static real_8 _data_l_894[_data_n_894] = {
    .443482133249918099955611379722e-27
  };
#define _data_n_895 1
  static real_8 _data_l_895[_data_n_895] = {
    .212945672365573895594589552837e-27
  };
#define _data_n_896 1
  static real_8 _data_l_896[_data_n_896] = {
    .103158569651075977552209344907e-27
  };
#define _data_n_897 1
  static real_8 _data_l_897[_data_n_897] = {
    .504023773022591199157904590029e-28
  };
#define _data_n_898 1
  static real_8 _data_l_898[_data_n_898] = {
    .248301304570155945304046541005e-28
  };
#define _data_n_899 1
  static real_8 _data_l_899[_data_n_899] = {
    .12330178312856219605419823856e-28
  };
#define _data_n_900 1
  static real_8 _data_l_900[_data_n_900] = {
    .617033449920521746121976730507e-29
  };
#define _data_n_901 1
  static real_8 _data_l_901[_data_n_901] = {
    .311092617415918897233869792213e-29
  };
#define _data_n_902 1
  static real_8 _data_l_902[_data_n_902] = {
    .157983085201706173015269071503e-29
  };
#define _data_n_903 1
  static real_8 _data_l_903[_data_n_903] = {
    .807931987538283607678121339092e-30
  };
#define _data_n_904 1
  static real_8 _data_l_904[_data_n_904] = {
    .415997394138667562722951360052e-30
  };
#define _data_n_905 1
  static real_8 _data_l_905[_data_n_905] = {
    .215610934097716900471935862504e-30
  };
#define _data_n_906 1
  static real_8 _data_l_906[_data_n_906] = {
    .112468857265869178296752823613e-30
  };
#define _data_n_907 1
  static real_8 _data_l_907[_data_n_907] = {
    .590331560632838091123040811797e-31
  };
#define _data_n_908 1
  static real_8 _data_l_908[_data_n_908] = {
    .311735667692928562046280505333e-31
  };
#define _data_n_909 1
  static real_8 _data_l_909[_data_n_909] = {
    -.8172601764161634499840208700543e-1
  };
#define _data_n_910 1
  static real_8 _data_l_910[_data_n_910] = {
    -.8004012824788273287596481113068e-3
  };
#define _data_n_911 1
  static real_8 _data_l_911[_data_n_911] = {
    -.3186525268782113203795553628242e-5
  };
#define _data_n_912 1
  static real_8 _data_l_912[_data_n_912] = {
    -.6688388266477509330741698865033e-7
  };
#define _data_n_913 1
  static real_8 _data_l_913[_data_n_913] = {
    -.2931759284994564516506822463184e-8
  };
#define _data_n_914 1
  static real_8 _data_l_914[_data_n_914] = {
    -.2011263760883621669049030307186e-9
  };
#define _data_n_915 1
  static real_8 _data_l_915[_data_n_915] = {
    -.1877522678055973426074008166652e-10
  };
#define _data_n_916 1
  static real_8 _data_l_916[_data_n_916] = {
    -.2199637137704601251899002199848e-11
  };
#define _data_n_917 1
  static real_8 _data_l_917[_data_n_917] = {
    -.3071616682592272449025746605586e-12
  };
#define _data_n_918 1
  static real_8 _data_l_918[_data_n_918] = {
    -.4936140553673418361025600985389e-13
  };
#define _data_n_919 1
  static real_8 _data_l_919[_data_n_919] = {
    -.8902833722583660416935236969866e-14
  };
#define _data_n_920 1
  static real_8 _data_l_920[_data_n_920] = {
    -.1768987764615272613656814199467e-14
  };
#define _data_n_921 1
  static real_8 _data_l_921[_data_n_921] = {
    -.38178686890322770146781996096e-15
  };
#define _data_n_922 1
  static real_8 _data_l_922[_data_n_922] = {
    -.8851159014819947594156286509984e-16
  };
#define _data_n_923 1
  static real_8 _data_l_923[_data_n_923] = {
    -.2184818181414365953149677679568e-16
  };
#define _data_n_924 1
  static real_8 _data_l_924[_data_n_924] = {
    -.5700849046986452380599442295119e-17
  };
#define _data_n_925 1
  static real_8 _data_l_925[_data_n_925] = {
    -.1563121122177875392516031795495e-17
  };
#define _data_n_926 1
  static real_8 _data_l_926[_data_n_926] = {
    -.4481437996768995067906688776353e-18
  };
#define _data_n_927 1
  static real_8 _data_l_927[_data_n_927] = {
    -.1337794883736188022044566044098e-18
  };
#define _data_n_928 1
  static real_8 _data_l_928[_data_n_928] = {
    -.4143340036874114453776852445442e-19
  };
#define _data_n_929 1
  static real_8 _data_l_929[_data_n_929] = {
    -.1327263385718805025080481164652e-19
  };
#define _data_n_930 1
  static real_8 _data_l_930[_data_n_930] = {
    -.4385728589128440522215756835955e-20
  };
#define _data_n_931 1
  static real_8 _data_l_931[_data_n_931] = {
    -.1491360695952818067686201743956e-20
  };
#define _data_n_932 1
  static real_8 _data_l_932[_data_n_932] = {
    -.5208104738630711377154238188773e-21
  };
#define _data_n_933 1
  static real_8 _data_l_933[_data_n_933] = {
    -.1864382222390498923872526604979e-21
  };
#define _data_n_934 1
  static real_8 _data_l_934[_data_n_934] = {
    -.6830263751167969012975435381881e-22
  };
#define _data_n_935 1
  static real_8 _data_l_935[_data_n_935] = {
    -.2557117058029329629296207591347e-22
  };
#define _data_n_936 1
  static real_8 _data_l_936[_data_n_936] = {
    -.9770158640254300218246907254046e-23
  };
#define _data_n_937 1
  static real_8 _data_l_937[_data_n_937] = {
    -.3805161433416679084068428254886e-23
  };
#define _data_n_938 1
  static real_8 _data_l_938[_data_n_938] = {
    -.1509022750737054063493926482995e-23
  };
#define _data_n_939 1
  static real_8 _data_l_939[_data_n_939] = {
    -.6087551341242424929005568014525e-24
  };
#define _data_n_940 1
  static real_8 _data_l_940[_data_n_940] = {
    -.2495879513809711495425982124058e-24
  };
#define _data_n_941 1
  static real_8 _data_l_941[_data_n_941] = {
    -.1039157654581920948909588084274e-24
  };
#define _data_n_942 1
  static real_8 _data_l_942[_data_n_942] = {
    -.4390235913976846536974594969051e-25
  };
#define _data_n_943 1
  static real_8 _data_l_943[_data_n_943] = {
    -.1880790678447990211675826820582e-25
  };
#define _data_n_944 1
  static real_8 _data_l_944[_data_n_944] = {
    -.8165070764199462948863022205753e-26
  };
#define _data_n_945 1
  static real_8 _data_l_945[_data_n_945] = {
    -.3589944503749750514266435585041e-26
  };
#define _data_n_946 1
  static real_8 _data_l_946[_data_n_946] = {
    -.1597658126632132872981291608708e-26
  };
#define _data_n_947 1
  static real_8 _data_l_947[_data_n_947] = {
    -.7193250175703823969113802835305e-27
  };
#define _data_n_948 1
  static real_8 _data_l_948[_data_n_948] = {
    -.3274943012727856506209351132721e-27
  };
#define _data_n_949 1
  static real_8 _data_l_949[_data_n_949] = {
    -.1507042445783690665816975047272e-27
  };
#define _data_n_950 1
  static real_8 _data_l_950[_data_n_950] = {
    -.700662419831990471784396794914e-28
  };
#define _data_n_951 1
  static real_8 _data_l_951[_data_n_951] = {
    -.3289907402983718226528815678356e-28
  };
#define _data_n_952 1
  static real_8 _data_l_952[_data_n_952] = {
    -.1559518084365146526445322711496e-28
  };
#define _data_n_953 1
  static real_8 _data_l_953[_data_n_953] = {
    -.7460690508208254582833851119721e-29
  };
#define _data_n_954 1
  static real_8 _data_l_954[_data_n_954] = {
    -.3600877034824662020563277249431e-29
  };
#define _data_n_955 1
  static real_8 _data_l_955[_data_n_955] = {
    -.1752851437473772257350402219197e-29
  };
#define _data_n_956 1
  static real_8 _data_l_956[_data_n_956] = {
    -.8603275775188512909623778628724e-30
  };
#define _data_n_957 1
  static real_8 _data_l_957[_data_n_957] = {
    -.4256432603226946534668039480105e-30
  };
#define _data_n_958 1
  static real_8 _data_l_958[_data_n_958] = {
    -.2122161865044262927723650698206e-30
  };
#define _data_n_959 1
  static real_8 _data_l_959[_data_n_959] = {
    -.1065996156704879052472060798561e-30
  };
#define _data_n_960 1
  static real_8 _data_l_960[_data_n_960] = {
    -.5393568608816949116410688086892e-31
  };
#define _data_n_961 1
  static real_8 _data_l_961[_data_n_961] = {
    -.274817485104395482227849651787e-31
  };
#define _data_n_962 1
  static real_8 _data_l_962[_data_n_962] = {
    .592790266721309588375717482814e-2
  };
#define _data_n_963 1
  static real_8 _data_l_963[_data_n_963] = {
    .20056940539316518642869521769e-2
  };
#define _data_n_964 1
  static real_8 _data_l_964[_data_n_964] = {
    .911081850262275893553072526291e-4
  };
#define _data_n_965 1
  static real_8 _data_l_965[_data_n_965] = {
    .849894306372047155633172107475e-5
  };
#define _data_n_966 1
  static real_8 _data_l_966[_data_n_966] = {
    .113297908976913076637929215494e-5
  };
#define _data_n_967 1
  static real_8 _data_l_967[_data_n_967] = {
    .187517946100666496180950627804e-6
  };
#define _data_n_968 1
  static real_8 _data_l_968[_data_n_968] = {
    .359306519018245832699035211192e-7
  };
#define _data_n_969 1
  static real_8 _data_l_969[_data_n_969] = {
    .76575771407168386403909351747e-8
  };
#define _data_n_970 1
  static real_8 _data_l_970[_data_n_970] = {
    .176999967168039173925953460744e-8
  };
#define _data_n_971 1
  static real_8 _data_l_971[_data_n_971] = {
    .436259555654598932720546585535e-9
  };
#define _data_n_972 1
  static real_8 _data_l_972[_data_n_972] = {
    .113291641337853230035520085219e-9
  };
#define _data_n_973 1
  static real_8 _data_l_973[_data_n_973] = {
    .307257690982419244137868398126e-10
  };
#define _data_n_974 1
  static real_8 _data_l_974[_data_n_974] = {
    .864482416482201075541200465766e-11
  };
#define _data_n_975 1
  static real_8 _data_l_975[_data_n_975] = {
    .251015250060924402115104562212e-11
  };
#define _data_n_976 1
  static real_8 _data_l_976[_data_n_976] = {
    .749102496764440371601802227751e-12
  };
#define _data_n_977 1
  static real_8 _data_l_977[_data_n_977] = {
    .228996928487994073089565214432e-12
  };
#define _data_n_978 1
  static real_8 _data_l_978[_data_n_978] = {
    .715113658927987694949327491175e-13
  };
#define _data_n_979 1
  static real_8 _data_l_979[_data_n_979] = {
    .227607924959566841946395165061e-13
  };
#define _data_n_980 1
  static real_8 _data_l_980[_data_n_980] = {
    .736942142760886513969953227782e-14
  };
#define _data_n_981 1
  static real_8 _data_l_981[_data_n_981] = {
    .242328675267827490463991742006e-14
  };
#define _data_n_982 1
  static real_8 _data_l_982[_data_n_982] = {
    .808153774548239869283406558403e-15
  };
#define _data_n_983 1
  static real_8 _data_l_983[_data_n_983] = {
    .273008079804356086659174563386e-15
  };
#define _data_n_984 1
  static real_8 _data_l_984[_data_n_984] = {
    .933236070891385318473519474326e-16
  };
#define _data_n_985 1
  static real_8 _data_l_985[_data_n_985] = {
    .322508099681084622213867546973e-16
  };
#define _data_n_986 1
  static real_8 _data_l_986[_data_n_986] = {
    .112581932346444541217757573416e-16
  };
#define _data_n_987 1
  static real_8 _data_l_987[_data_n_987] = {
    .39669946398693882166025945953e-17
  };
#define _data_n_988 1
  static real_8 _data_l_988[_data_n_988] = {
    .141006567944319504660865034527e-17
  };
#define _data_n_989 1
  static real_8 _data_l_989[_data_n_989] = {
    .505302086537851213375537393032e-18
  };
#define _data_n_990 1
  static real_8 _data_l_990[_data_n_990] = {
    .182461523215945141197999102789e-18
  };
#define _data_n_991 1
  static real_8 _data_l_991[_data_n_991] = {
    .663584568262130466928029121642e-19
  };
#define _data_n_992 1
  static real_8 _data_l_992[_data_n_992] = {
    .242963731631276179741747455826e-19
  };
#define _data_n_993 1
  static real_8 _data_l_993[_data_n_993] = {
    .895238915123687802013669922963e-20
  };
#define _data_n_994 1
  static real_8 _data_l_994[_data_n_994] = {
    .331845289350050791260229250755e-20
  };
#define _data_n_995 1
  static real_8 _data_l_995[_data_n_995] = {
    .123706196188658315384437905922e-20
  };
#define _data_n_996 1
  static real_8 _data_l_996[_data_n_996] = {
    .463636677012390840306767734243e-21
  };
#define _data_n_997 1
  static real_8 _data_l_997[_data_n_997] = {
    .174653135947764475469758765989e-21
  };
#define _data_n_998 1
  static real_8 _data_l_998[_data_n_998] = {
    .661116810234991176307910643111e-22
  };
#define _data_n_999 1
  static real_8 _data_l_999[_data_n_999] = {
    .251409918994072486176125666459e-22
  };
#define _data_n_1000 1
  static real_8 _data_l_1000[_data_n_1000] = {
    .960274995571732568694034386998e-23
  };
#define _data_n_1001 1
  static real_8 _data_l_1001[_data_n_1001] = {
    .368324952289296395686436898078e-23
  };
#define _data_n_1002 1
  static real_8 _data_l_1002[_data_n_1002] = {
    .141843138269159136145535939553e-23
  };
#define _data_n_1003 1
  static real_8 _data_l_1003[_data_n_1003] = {
    .54834267427693583010634580099e-24
  };
#define _data_n_1004 1
  static real_8 _data_l_1004[_data_n_1004] = {
    .212761054623118806650372562616e-24
  };
#define _data_n_1005 1
  static real_8 _data_l_1005[_data_n_1005] = {
    .828443700849418591487734760953e-25
  };
#define _data_n_1006 1
  static real_8 _data_l_1006[_data_n_1006] = {
    .323670563926127001421028600927e-25
  };
#define _data_n_1007 1
  static real_8 _data_l_1007[_data_n_1007] = {
    .126868882963286057355055062493e-25
  };
#define _data_n_1008 1
  static real_8 _data_l_1008[_data_n_1008] = {
    .498843818992121626935068934362e-26
  };
#define _data_n_1009 1
  static real_8 _data_l_1009[_data_n_1009] = {
    .19673458446764939096711938179e-26
  };
#define _data_n_1010 1
  static real_8 _data_l_1010[_data_n_1010] = {
    .778135971020326957713212064836e-27
  };
#define _data_n_1011 1
  static real_8 _data_l_1011[_data_n_1011] = {
    .308633941498911152919192968451e-27
  };
#define _data_n_1012 1
  static real_8 _data_l_1012[_data_n_1012] = {
    .122744647045453119789338037234e-27
  };
#define _data_n_1013 1
  static real_8 _data_l_1013[_data_n_1013] = {
    .489431279134292205885241216204e-28
  };
#define _data_n_1014 1
  static real_8 _data_l_1014[_data_n_1014] = {
    .195646879802909821175925099724e-28
  };
#define _data_n_1015 1
  static real_8 _data_l_1015[_data_n_1015] = {
    .783988952922426171166311492266e-29
  };
#define _data_n_1016 1
  static real_8 _data_l_1016[_data_n_1016] = {
    .314896914002484223748298978099e-29
  };
#define _data_n_1017 1
  static real_8 _data_l_1017[_data_n_1017] = {
    .126769763137250681307067842559e-29
  };
#define _data_n_1018 1
  static real_8 _data_l_1018[_data_n_1018] = {
    .511470691906900141641632107724e-30
  };
#define _data_n_1019 1
  static real_8 _data_l_1019[_data_n_1019] = {
    .206801709795538770250900316706e-30
  };
#define _data_n_1020 1
  static real_8 _data_l_1020[_data_n_1020] = {
    .837891344768519001325996867583e-31
  };
#define _data_n_1021 1
  static real_8 _data_l_1021[_data_n_1021] = {
    .340168991971489802052339079577e-31
  };
#define _data_n_1022 1
  static real_8 _data_l_1022[_data_n_1022] = {
    -.6972849916208883845888148415037e-1
  };
#define _data_n_1023 1
  static real_8 _data_l_1023[_data_n_1023] = {
    -.5108722790650044987073448077961e-2
  };
#define _data_n_1024 1
  static real_8 _data_l_1024[_data_n_1024] = {
    -.8644335996989755094525334749512e-4
  };
#define _data_n_1025 1
  static real_8 _data_l_1025[_data_n_1025] = {
    -.5604720044235263542188698916125e-5
  };
#define _data_n_1026 1
  static real_8 _data_l_1026[_data_n_1026] = {
    -.6045735125623897409156376640077e-6
  };
#define _data_n_1027 1
  static real_8 _data_l_1027[_data_n_1027] = {
    -.8639802632488334393219721138499e-7
  };
#define _data_n_1028 1
  static real_8 _data_l_1028[_data_n_1028] = {
    -.148080948430992715714778248078e-7
  };
#define _data_n_1029 1
  static real_8 _data_l_1029[_data_n_1029] = {
    -.2885809334577236039999449908712e-8
  };
#define _data_n_1030 1
  static real_8 _data_l_1030[_data_n_1030] = {
    -.61916319756656996093091912318e-9
  };
#define _data_n_1031 1
  static real_8 _data_l_1031[_data_n_1031] = {
    -.1431992808860957830931365259879e-9
  };
#define _data_n_1032 1
  static real_8 _data_l_1032[_data_n_1032] = {
    -.3518141102137214721504616874321e-10
  };
#define _data_n_1033 1
  static real_8 _data_l_1033[_data_n_1033] = {
    -.9084761919955078290070339808051e-11
  };
#define _data_n_1034 1
  static real_8 _data_l_1034[_data_n_1034] = {
    -.2446171672688598449343283664767e-11
  };
#define _data_n_1035 1
  static real_8 _data_l_1035[_data_n_1035] = {
    -.6826083203213446240828996710264e-12
  };
#define _data_n_1036 1
  static real_8 _data_l_1036[_data_n_1036] = {
    -.1964579931194940171278546257802e-12
  };
#define _data_n_1037 1
  static real_8 _data_l_1037[_data_n_1037] = {
    -.5808933227139693164009191265856e-13
  };
#define _data_n_1038 1
  static real_8 _data_l_1038[_data_n_1038] = {
    -.1759042249527441992795400959024e-13
  };
#define _data_n_1039 1
  static real_8 _data_l_1039[_data_n_1039] = {
    -.5440902932714896613632538945319e-14
  };
#define _data_n_1040 1
  static real_8 _data_l_1040[_data_n_1040] = {
    -.1715247407486806802622358519451e-14
  };
#define _data_n_1041 1
  static real_8 _data_l_1041[_data_n_1041] = {
    -.5500929233576991546871101847161e-15
  };
#define _data_n_1042 1
  static real_8 _data_l_1042[_data_n_1042] = {
    -.1791878287739317259495152638754e-15
  };
#define _data_n_1043 1
  static real_8 _data_l_1043[_data_n_1043] = {
    -.5920372520086694197778411062231e-16
  };
#define _data_n_1044 1
  static real_8 _data_l_1044[_data_n_1044] = {
    -.198171302787648396247097220659e-16
  };
#define _data_n_1045 1
  static real_8 _data_l_1045[_data_n_1045] = {
    -.671323234701635226204998434379e-17
  };
#define _data_n_1046 1
  static real_8 _data_l_1046[_data_n_1046] = {
    -.2299450243658281116122358619832e-17
  };
#define _data_n_1047 1
  static real_8 _data_l_1047[_data_n_1047] = {
    -.7957300928236376595304637145634e-18
  };
#define _data_n_1048 1
  static real_8 _data_l_1048[_data_n_1048] = {
    -.2779994027291784157172290233739e-18
  };
#define _data_n_1049 1
  static real_8 _data_l_1049[_data_n_1049] = {
    -.9798924361326985224406795480814e-19
  };
#define _data_n_1050 1
  static real_8 _data_l_1050[_data_n_1050] = {
    -.3482717006061574386702645565849e-19
  };
#define _data_n_1051 1
  static real_8 _data_l_1051[_data_n_1051] = {
    -.1247489122558599057173300058084e-19
  };
#define _data_n_1052 1
  static real_8 _data_l_1052[_data_n_1052] = {
    -.4501210041478228113487751824452e-20
  };
#define _data_n_1053 1
  static real_8 _data_l_1053[_data_n_1053] = {
    -.1635346244013352135596114164667e-20
  };
#define _data_n_1054 1
  static real_8 _data_l_1054[_data_n_1054] = {
    -.5980102897780336268098762265941e-21
  };
#define _data_n_1055 1
  static real_8 _data_l_1055[_data_n_1055] = {
    -.2200246286286123454028196295475e-21
  };
#define _data_n_1056 1
  static real_8 _data_l_1056[_data_n_1056] = {
    -.8142463073515085897408205291519e-22
  };
#define _data_n_1057 1
  static real_8 _data_l_1057[_data_n_1057] = {
    -.3029924773660042537432330709674e-22
  };
#define _data_n_1058 1
  static real_8 _data_l_1058[_data_n_1058] = {
    -.1133390098574623537722943969689e-22
  };
#define _data_n_1059 1
  static real_8 _data_l_1059[_data_n_1059] = {
    -.4260766024749295719283049889791e-23
  };
#define _data_n_1060 1
  static real_8 _data_l_1060[_data_n_1060] = {
    -.1609363396278189718797500634453e-23
  };
#define _data_n_1061 1
  static real_8 _data_l_1061[_data_n_1061] = {
    -.6106377190825026293045330444287e-24
  };
#define _data_n_1062 1
  static real_8 _data_l_1062[_data_n_1062] = {
    -.2326954318021694061836577887573e-24
  };
#define _data_n_1063 1
  static real_8 _data_l_1063[_data_n_1063] = {
    -.8903987877472252604474129558186e-25
  };
#define _data_n_1064 1
  static real_8 _data_l_1064[_data_n_1064] = {
    -.3420558530005675024117914752341e-25
  };
#define _data_n_1065 1
  static real_8 _data_l_1065[_data_n_1065] = {
    -.1319026715257272659017212100607e-25
  };
#define _data_n_1066 1
  static real_8 _data_l_1066[_data_n_1066] = {
    -.5104899493612043091316191177386e-26
  };
#define _data_n_1067 1
  static real_8 _data_l_1067[_data_n_1067] = {
    -.1982599478474547451242444663466e-26
  };
#define _data_n_1068 1
  static real_8 _data_l_1068[_data_n_1068] = {
    -.7725702356880830535636111851519e-27
  };
#define _data_n_1069 1
  static real_8 _data_l_1069[_data_n_1069] = {
    -.3020234733664680100815776863573e-27
  };
#define _data_n_1070 1
  static real_8 _data_l_1070[_data_n_1070] = {
    -.11843797390741699937129463808e-27
  };
#define _data_n_1071 1
  static real_8 _data_l_1071[_data_n_1071] = {
    -.4658430227922308520573252840106e-28
  };
#define _data_n_1072 1
  static real_8 _data_l_1072[_data_n_1072] = {
    -.1837554188100384647157502006613e-28
  };
#define _data_n_1073 1
  static real_8 _data_l_1073[_data_n_1073] = {
    -.72685668944279909533218766848e-29
  };
#define _data_n_1074 1
  static real_8 _data_l_1074[_data_n_1074] = {
    -.2882863120391468135527089875626e-29
  };
#define _data_n_1075 1
  static real_8 _data_l_1075[_data_n_1075] = {
    -.1146374629459906350417591664639e-29
  };
#define _data_n_1076 1
  static real_8 _data_l_1076[_data_n_1076] = {
    -.4570031437748533058179991688533e-30
  };
#define _data_n_1077 1
  static real_8 _data_l_1077[_data_n_1077] = {
    -.1826276602045346104809934028799e-30
  };
#define _data_n_1078 1
  static real_8 _data_l_1078[_data_n_1078] = {
    -.7315349993385250469111066350933e-31
  };
#define _data_n_1079 1
  static real_8 _data_l_1079[_data_n_1079] = {
    -.2936925599971429781637815773866e-31
  };
#define _data_n_1080 1
  static real_8 _data_l_1080[_data_n_1080] = {
    -.156284448062534112753545828583e-1
  };
#define _data_n_1081 1
  static real_8 _data_l_1081[_data_n_1081] = {
    .778336445239681307018943100334e-2
  };
#define _data_n_1082 1
  static real_8 _data_l_1082[_data_n_1082] = {
    .86705777047718952840607281211e-3
  };
#define _data_n_1083 1
  static real_8 _data_l_1083[_data_n_1083] = {
    .156966273156113719469953482266e-3
  };
#define _data_n_1084 1
  static real_8 _data_l_1084[_data_n_1084] = {
    .356396257143286511324100666302e-4
  };
#define _data_n_1085 1
  static real_8 _data_l_1085[_data_n_1085] = {
    .924598335425043154495080090994e-5
  };
#define _data_n_1086 1
  static real_8 _data_l_1086[_data_n_1086] = {
    .262110161850422389523194982066e-5
  };
#define _data_n_1087 1
  static real_8 _data_l_1087[_data_n_1087] = {
    .791882216516012561489469982263e-6
  };
#define _data_n_1088 1
  static real_8 _data_l_1088[_data_n_1088] = {
    .251041527921011847803162690862e-6
  };
#define _data_n_1089 1
  static real_8 _data_l_1089[_data_n_1089] = {
    .82652232066540773447299771294e-7
  };
#define _data_n_1090 1
  static real_8 _data_l_1090[_data_n_1090] = {
    .280571166281305264396384290014e-7
  };
#define _data_n_1091 1
  static real_8 _data_l_1091[_data_n_1091] = {
    .97682109048468078667463127389e-8
  };
#define _data_n_1092 1
  static real_8 _data_l_1092[_data_n_1092] = {
    .347407923227710343287279035573e-8
  };
#define _data_n_1093 1
  static real_8 _data_l_1093[_data_n_1093] = {
    .125828132169836914219092738164e-8
  };
#define _data_n_1094 1
  static real_8 _data_l_1094[_data_n_1094] = {
    .462988260641895264497330784625e-9
  };
#define _data_n_1095 1
  static real_8 _data_l_1095[_data_n_1095] = {
    .172728258813604072468143128696e-9
  };
#define _data_n_1096 1
  static real_8 _data_l_1096[_data_n_1096] = {
    .65231920013115413514857412497e-10
  };
#define _data_n_1097 1
  static real_8 _data_l_1097[_data_n_1097] = {
    .249047168520982056019881087112e-10
  };
#define _data_n_1098 1
  static real_8 _data_l_1098[_data_n_1098] = {
    .960156820553765948078189890126e-11
  };
#define _data_n_1099 1
  static real_8 _data_l_1099[_data_n_1099] = {
    .373448002067726856974776596757e-11
  };
#define _data_n_1100 1
  static real_8 _data_l_1100[_data_n_1100] = {
    .146417565032053391722216189678e-11
  };
#define _data_n_1101 1
  static real_8 _data_l_1101[_data_n_1101] = {
    .578265471168512825475827881553e-12
  };
#define _data_n_1102 1
  static real_8 _data_l_1102[_data_n_1102] = {
    .229915407244706118560254184494e-12
  };
#define _data_n_1103 1
  static real_8 _data_l_1103[_data_n_1103] = {
    .919780711231997257150883662365e-13
  };
#define _data_n_1104 1
  static real_8 _data_l_1104[_data_n_1104] = {
    .370060068813090065807504045556e-13
  };
#define _data_n_1105 1
  static real_8 _data_l_1105[_data_n_1105] = {
    .149675761698672987823326345205e-13
  };
#define _data_n_1106 1
  static real_8 _data_l_1106[_data_n_1106] = {
    .608361194938461148720451399443e-14
  };
#define _data_n_1107 1
  static real_8 _data_l_1107[_data_n_1107] = {
    .248404087115121397635425326873e-14
  };
#define _data_n_1108 1
  static real_8 _data_l_1108[_data_n_1108] = {
    .101862476526769080727914465339e-14
  };
#define _data_n_1109 1
  static real_8 _data_l_1109[_data_n_1109] = {
    .419383856352753989429640310957e-15
  };
#define _data_n_1110 1
  static real_8 _data_l_1110[_data_n_1110] = {
    .173318901762930756149702493501e-15
  };
#define _data_n_1111 1
  static real_8 _data_l_1111[_data_n_1111] = {
    .718821902388508517820445406811e-16
  };
#define _data_n_1112 1
  static real_8 _data_l_1112[_data_n_1112] = {
    .299123633598403607712470896113e-16
  };
#define _data_n_1113 1
  static real_8 _data_l_1113[_data_n_1113] = {
    .12486899043323862785571311088e-16
  };
#define _data_n_1114 1
  static real_8 _data_l_1114[_data_n_1114] = {
    .522829344609483661928651193632e-17
  };
#define _data_n_1115 1
  static real_8 _data_l_1115[_data_n_1115] = {
    .219532961724713396595998454359e-17
  };
#define _data_n_1116 1
  static real_8 _data_l_1116[_data_n_1116] = {
    .924298325229777281154410024332e-18
  };
#define _data_n_1117 1
  static real_8 _data_l_1117[_data_n_1117] = {
    .390157708236091407825543197309e-18
  };
#define _data_n_1118 1
  static real_8 _data_l_1118[_data_n_1118] = {
    .165093892693863707213759030367e-18
  };
#define _data_n_1119 1
  static real_8 _data_l_1119[_data_n_1119] = {
    .700221815715994367565716554487e-19
  };
#define _data_n_1120 1
  static real_8 _data_l_1120[_data_n_1120] = {
    .297651833616786915573214963506e-19
  };
#define _data_n_1121 1
  static real_8 _data_l_1121[_data_n_1121] = {
    .126796539086902072571134261229e-19
  };
#define _data_n_1122 1
  static real_8 _data_l_1122[_data_n_1122] = {
    .541243400697077628687581725061e-20
  };
#define _data_n_1123 1
  static real_8 _data_l_1123[_data_n_1123] = {
    .231487350218155252296382133283e-20
  };
#define _data_n_1124 1
  static real_8 _data_l_1124[_data_n_1124] = {
    .991920288386566563462623851167e-21
  };
#define _data_n_1125 1
  static real_8 _data_l_1125[_data_n_1125] = {
    .425803015323732357158897608174e-21
  };
#define _data_n_1126 1
  static real_8 _data_l_1126[_data_n_1126] = {
    .183101842973024501678402003088e-21
  };
#define _data_n_1127 1
  static real_8 _data_l_1127[_data_n_1127] = {
    .788678712311075375564526811022e-22
  };
#define _data_n_1128 1
  static real_8 _data_l_1128[_data_n_1128] = {
    .340254607386229874956582997235e-22
  };
#define _data_n_1129 1
  static real_8 _data_l_1129[_data_n_1129] = {
    .147020881405712530791860892535e-22
  };
#define _data_n_1130 1
  static real_8 _data_l_1130[_data_n_1130] = {
    .636211018324916957733348071767e-23
  };
#define _data_n_1131 1
  static real_8 _data_l_1131[_data_n_1131] = {
    .275707050680980721919395987768e-23
  };
#define _data_n_1132 1
  static real_8 _data_l_1132[_data_n_1132] = {
    .119645858090104071356261780457e-23
  };
#define _data_n_1133 1
  static real_8 _data_l_1133[_data_n_1133] = {
    .519912545729242147981768210567e-24
  };
#define _data_n_1134 1
  static real_8 _data_l_1134[_data_n_1134] = {
    .22621767484710447526057528685e-24
  };
#define _data_n_1135 1
  static real_8 _data_l_1135[_data_n_1135] = {
    .985526113754431819448565068283e-25
  };
#define _data_n_1136 1
  static real_8 _data_l_1136[_data_n_1136] = {
    .429870630332508717223681286187e-25
  };
#define _data_n_1137 1
  static real_8 _data_l_1137[_data_n_1137] = {
    .187723641661580639829657670189e-25
  };
#define _data_n_1138 1
  static real_8 _data_l_1138[_data_n_1138] = {
    .820721941772842137268801052115e-26
  };
#define _data_n_1139 1
  static real_8 _data_l_1139[_data_n_1139] = {
    .359214665604615507812767944463e-26
  };
#define _data_n_1140 1
  static real_8 _data_l_1140[_data_n_1140] = {
    .157390594612773315611458940587e-26
  };
#define _data_n_1141 1
  static real_8 _data_l_1141[_data_n_1141] = {
    .690329781039333834965319153586e-27
  };
#define _data_n_1142 1
  static real_8 _data_l_1142[_data_n_1142] = {
    .303092079078968534607859331415e-27
  };
#define _data_n_1143 1
  static real_8 _data_l_1143[_data_n_1143] = {
    .133204934160481219185689121944e-27
  };
#define _data_n_1144 1
  static real_8 _data_l_1144[_data_n_1144] = {
    .585978836851523490117937981442e-28
  };
#define _data_n_1145 1
  static real_8 _data_l_1145[_data_n_1145] = {
    .258016868489487806338425080457e-28
  };
#define _data_n_1146 1
  static real_8 _data_l_1146[_data_n_1146] = {
    .113712433637283667223632182863e-28
  };
#define _data_n_1147 1
  static real_8 _data_l_1147[_data_n_1147] = {
    .501592557226068509236430548549e-29
  };
#define _data_n_1148 1
  static real_8 _data_l_1148[_data_n_1148] = {
    .221445829395509373322569708484e-29
  };
#define _data_n_1149 1
  static real_8 _data_l_1149[_data_n_1149] = {
    .978470283886507289984691416411e-30
  };
#define _data_n_1150 1
  static real_8 _data_l_1150[_data_n_1150] = {
    .432695414934180170112000952983e-30
  };
#define _data_n_1151 1
  static real_8 _data_l_1151[_data_n_1151] = {
    .19149728819399457061292986044e-30
  };
#define _data_n_1152 1
  static real_8 _data_l_1152[_data_n_1152] = {
    .848164622402392354171298331562e-31
  };
#define _data_n_1153 1
  static real_8 _data_l_1153[_data_n_1153] = {
    .375947065173955919947455052934e-31
  };
#define _data_n_1154 1
  static real_8 _data_l_1154[_data_n_1154] = {
    .4405273458718778997061127057775e-2
  };
#define _data_n_1155 1
  static real_8 _data_l_1155[_data_n_1155] = {
    -.3042919452318454608483844239873e-1
  };
#define _data_n_1156 1
  static real_8 _data_l_1156[_data_n_1156] = {
    -.1385653283771793791602692842653e-2
  };
#define _data_n_1157 1
  static real_8 _data_l_1157[_data_n_1157] = {
    -.1804443908954952302670486910952e-3
  };
#define _data_n_1158 1
  static real_8 _data_l_1158[_data_n_1158] = {
    -.3380847108327308671057465323618e-4
  };
#define _data_n_1159 1
  static real_8 _data_l_1159[_data_n_1159] = {
    -.7678183535229023055257676817765e-5
  };
#define _data_n_1160 1
  static real_8 _data_l_1160[_data_n_1160] = {
    -.1967839443716035324690935417077e-5
  };
#define _data_n_1161 1
  static real_8 _data_l_1161[_data_n_1161] = {
    -.5483727115877700361586143659281e-6
  };
#define _data_n_1162 1
  static real_8 _data_l_1162[_data_n_1162] = {
    -.1625461550532612452712696212258e-6
  };
#define _data_n_1163 1
  static real_8 _data_l_1163[_data_n_1163] = {
    -.5053049981268895015277637842078e-7
  };
#define _data_n_1164 1
  static real_8 _data_l_1164[_data_n_1164] = {
    -.1631580701124066881183851715617e-7
  };
#define _data_n_1165 1
  static real_8 _data_l_1165[_data_n_1165] = {
    -.5434204112348517507963436694817e-8
  };
#define _data_n_1166 1
  static real_8 _data_l_1166[_data_n_1166] = {
    -.185739855640990032576385010963e-8
  };
#define _data_n_1167 1
  static real_8 _data_l_1167[_data_n_1167] = {
    -.6489512033326108816213513640676e-9
  };
#define _data_n_1168 1
  static real_8 _data_l_1168[_data_n_1168] = {
    -.2310594885800944720482995987079e-9
  };
#define _data_n_1169 1
  static real_8 _data_l_1169[_data_n_1169] = {
    -.8363282183204411682819329546745e-10
  };
#define _data_n_1170 1
  static real_8 _data_l_1170[_data_n_1170] = {
    -.3071196844890191462660661303891e-10
  };
#define _data_n_1171 1
  static real_8 _data_l_1171[_data_n_1171] = {
    -.1142367142432716819409514579892e-10
  };
#define _data_n_1172 1
  static real_8 _data_l_1172[_data_n_1172] = {
    -.4298116066345803065822470108971e-11
  };
#define _data_n_1173 1
  static real_8 _data_l_1173[_data_n_1173] = {
    -.1633898699596715440601646086632e-11
  };
#define _data_n_1174 1
  static real_8 _data_l_1174[_data_n_1174] = {
    -.6269328620016619432123443754076e-12
  };
#define _data_n_1175 1
  static real_8 _data_l_1175[_data_n_1175] = {
    -.2426052694816257357356159203991e-12
  };
#define _data_n_1176 1
  static real_8 _data_l_1176[_data_n_1176] = {
    -.9461198321624039090742527765052e-13
  };
#define _data_n_1177 1
  static real_8 _data_l_1177[_data_n_1177] = {
    -.3716060313411504806847798281269e-13
  };
#define _data_n_1178 1
  static real_8 _data_l_1178[_data_n_1178] = {
    -.1469155684097526763170138810309e-13
  };
#define _data_n_1179 1
  static real_8 _data_l_1179[_data_n_1179] = {
    -.5843694726140911944556401363094e-14
  };
#define _data_n_1180 1
  static real_8 _data_l_1180[_data_n_1180] = {
    -.2337502595591951298832675034934e-14
  };
#define _data_n_1181 1
  static real_8 _data_l_1181[_data_n_1181] = {
    -.9399231371171435401160167358411e-15
  };
#define _data_n_1182 1
  static real_8 _data_l_1182[_data_n_1182] = {
    -.3798014669372894500076335263715e-15
  };
#define _data_n_1183 1
  static real_8 _data_l_1183[_data_n_1183] = {
    -.1541731043984972524883443681775e-15
  };
#define _data_n_1184 1
  static real_8 _data_l_1184[_data_n_1184] = {
    -.6285287079535307162925662365202e-16
  };
#define _data_n_1185 1
  static real_8 _data_l_1185[_data_n_1185] = {
    -.2572731812811455424755383992774e-16
  };
#define _data_n_1186 1
  static real_8 _data_l_1186[_data_n_1186] = {
    -.1057098119354017809340974866555e-16
  };
#define _data_n_1187 1
  static real_8 _data_l_1187[_data_n_1187] = {
    -.4359080267402696966695992699964e-17
  };
#define _data_n_1188 1
  static real_8 _data_l_1188[_data_n_1188] = {
    -.180363431595997801395317694554e-17
  };
#define _data_n_1189 1
  static real_8 _data_l_1189[_data_n_1189] = {
    -.7486838064380536821719431676914e-18
  };
#define _data_n_1190 1
  static real_8 _data_l_1190[_data_n_1190] = {
    -.3117261367347604656799597209985e-18
  };
#define _data_n_1191 1
  static real_8 _data_l_1191[_data_n_1191] = {
    -.1301687980927700734792871620696e-18
  };
#define _data_n_1192 1
  static real_8 _data_l_1192[_data_n_1192] = {
    -.5450527587519522468973883909909e-19
  };
#define _data_n_1193 1
  static real_8 _data_l_1193[_data_n_1193] = {
    -.2288293490114231872268635931903e-19
  };
#define _data_n_1194 1
  static real_8 _data_l_1194[_data_n_1194] = {
    -.9631059503829538655655060440088e-20
  };
#define _data_n_1195 1
  static real_8 _data_l_1195[_data_n_1195] = {
    -.4063281001524614089092195416434e-20
  };
#define _data_n_1196 1
  static real_8 _data_l_1196[_data_n_1196] = {
    -.171820398090802676390041385851e-20
  };
#define _data_n_1197 1
  static real_8 _data_l_1197[_data_n_1197] = {
    -.7281574619892536367415322473328e-21
  };
#define _data_n_1198 1
  static real_8 _data_l_1198[_data_n_1198] = {
    -.309235265268064312796068034579e-21
  };
#define _data_n_1199 1
  static real_8 _data_l_1199[_data_n_1199] = {
    -.1315917855965440490383417023254e-21
  };
#define _data_n_1200 1
  static real_8 _data_l_1200[_data_n_1200] = {
    -.5610606786087055512664907412668e-22
  };
#define _data_n_1201 1
  static real_8 _data_l_1201[_data_n_1201] = {
    -.2396621894086355206020304337895e-22
  };
#define _data_n_1202 1
  static real_8 _data_l_1202[_data_n_1202] = {
    -.1025574332390581200832954423924e-22
  };
#define _data_n_1203 1
  static real_8 _data_l_1203[_data_n_1203] = {
    -.4396264138143656476403607323663e-23
  };
#define _data_n_1204 1
  static real_8 _data_l_1204[_data_n_1204] = {
    -.188765299837257737334250871945e-23
  };
#define _data_n_1205 1
  static real_8 _data_l_1205[_data_n_1205] = {
    -.8118140359576807603579433230445e-24
  };
#define _data_n_1206 1
  static real_8 _data_l_1206[_data_n_1206] = {
    -.3496734274366286856375952089214e-24
  };
#define _data_n_1207 1
  static real_8 _data_l_1207[_data_n_1207] = {
    -.1508402925156873215171751475867e-24
  };
#define _data_n_1208 1
  static real_8 _data_l_1208[_data_n_1208] = {
    -.6516268284778671059787773834341e-25
  };
#define _data_n_1209 1
  static real_8 _data_l_1209[_data_n_1209] = {
    -.2818945797529207424505942114583e-25
  };
#define _data_n_1210 1
  static real_8 _data_l_1210[_data_n_1210] = {
    -.1221127596512262744598094464505e-25
  };
#define _data_n_1211 1
  static real_8 _data_l_1211[_data_n_1211] = {
    -.5296674341169867168620011705073e-26
  };
#define _data_n_1212 1
  static real_8 _data_l_1212[_data_n_1212] = {
    -.2300359270773673431358870971744e-26
  };
#define _data_n_1213 1
  static real_8 _data_l_1213[_data_n_1213] = {
    -.100027948235536749478122034893e-26
  };
#define _data_n_1214 1
  static real_8 _data_l_1214[_data_n_1214] = {
    -.4354760404180879394806893162179e-27
  };
#define _data_n_1215 1
  static real_8 _data_l_1215[_data_n_1215] = {
    -.189805613474147752251548282703e-27
  };
#define _data_n_1216 1
  static real_8 _data_l_1216[_data_n_1216] = {
    -.8282111868712974697554009309315e-28
  };
#define _data_n_1217 1
  static real_8 _data_l_1217[_data_n_1217] = {
    -.3617815493066569006586213484374e-28
  };
#define _data_n_1218 1
  static real_8 _data_l_1218[_data_n_1218] = {
    -.1582018896178003654858941843636e-28
  };
#define _data_n_1219 1
  static real_8 _data_l_1219[_data_n_1219] = {
    -.6925068597802270011772820383247e-29
  };
#define _data_n_1220 1
  static real_8 _data_l_1220[_data_n_1220] = {
    -.3034390239778629128908629727335e-29
  };
#define _data_n_1221 1
  static real_8 _data_l_1221[_data_n_1221] = {
    -.1330889568166725224761977446509e-29
  };
#define _data_n_1222 1
  static real_8 _data_l_1222[_data_n_1222] = {
    -.5842848522173090120487606971706e-30
  };
#define _data_n_1223 1
  static real_8 _data_l_1223[_data_n_1223] = {
    -.2567488423238302631121274357678e-30
  };
#define _data_n_1224 1
  static real_8 _data_l_1224[_data_n_1224] = {
    -.1129232322268882185791505819151e-30
  };
#define _data_n_1225 1
  static real_8 _data_l_1225[_data_n_1225] = {
    -.4970947029753336916550570105023e-31
  };
#define _data_n_1226 1
  static real_8 _data_l_1226[_data_n_1226] = {
    0.78539816339744830961566084581988e0
  };
#define _data_n_1227 1
  static logical_4 _data_l_1227[_data_n_1227] = {
    TRUE
  };
  if (__calls[95].calls == 0) {
    _data_k_852 = 0;
    if (_data_k_852 >= _data_n_852) {
      _data_k_852 = 0;
    }
    am20cs_[0] = _data_l_852[_data_k_852++];
  }
  if (__calls[95].calls == 0) {
    _data_k_853 = 0;
    if (_data_k_853 >= _data_n_853) {
      _data_k_853 = 0;
    }
    am20cs_[1] = _data_l_853[_data_k_853++];
  }
  if (__calls[95].calls == 0) {
    _data_k_854 = 0;
    if (_data_k_854 >= _data_n_854) {
      _data_k_854 = 0;
    }
    am20cs_[2] = _data_l_854[_data_k_854++];
  }
  if (__calls[95].calls == 0) {
    _data_k_855 = 0;
    if (_data_k_855 >= _data_n_855) {
      _data_k_855 = 0;
    }
    am20cs_[3] = _data_l_855[_data_k_855++];
  }
  if (__calls[95].calls == 0) {
    _data_k_856 = 0;
    if (_data_k_856 >= _data_n_856) {
      _data_k_856 = 0;
    }
    am20cs_[4] = _data_l_856[_data_k_856++];
  }
  if (__calls[95].calls == 0) {
    _data_k_857 = 0;
    if (_data_k_857 >= _data_n_857) {
      _data_k_857 = 0;
    }
    am20cs_[5] = _data_l_857[_data_k_857++];
  }
  if (__calls[95].calls == 0) {
    _data_k_858 = 0;
    if (_data_k_858 >= _data_n_858) {
      _data_k_858 = 0;
    }
    am20cs_[6] = _data_l_858[_data_k_858++];
  }
  if (__calls[95].calls == 0) {
    _data_k_859 = 0;
    if (_data_k_859 >= _data_n_859) {
      _data_k_859 = 0;
    }
    am20cs_[7] = _data_l_859[_data_k_859++];
  }
  if (__calls[95].calls == 0) {
    _data_k_860 = 0;
    if (_data_k_860 >= _data_n_860) {
      _data_k_860 = 0;
    }
    am20cs_[8] = _data_l_860[_data_k_860++];
  }
  if (__calls[95].calls == 0) {
    _data_k_861 = 0;
    if (_data_k_861 >= _data_n_861) {
      _data_k_861 = 0;
    }
    am20cs_[9] = _data_l_861[_data_k_861++];
  }
  if (__calls[95].calls == 0) {
    _data_k_862 = 0;
    if (_data_k_862 >= _data_n_862) {
      _data_k_862 = 0;
    }
    am20cs_[10] = _data_l_862[_data_k_862++];
  }
  if (__calls[95].calls == 0) {
    _data_k_863 = 0;
    if (_data_k_863 >= _data_n_863) {
      _data_k_863 = 0;
    }
    am20cs_[11] = _data_l_863[_data_k_863++];
  }
  if (__calls[95].calls == 0) {
    _data_k_864 = 0;
    if (_data_k_864 >= _data_n_864) {
      _data_k_864 = 0;
    }
    am20cs_[12] = _data_l_864[_data_k_864++];
  }
  if (__calls[95].calls == 0) {
    _data_k_865 = 0;
    if (_data_k_865 >= _data_n_865) {
      _data_k_865 = 0;
    }
    am20cs_[13] = _data_l_865[_data_k_865++];
  }
  if (__calls[95].calls == 0) {
    _data_k_866 = 0;
    if (_data_k_866 >= _data_n_866) {
      _data_k_866 = 0;
    }
    am20cs_[14] = _data_l_866[_data_k_866++];
  }
  if (__calls[95].calls == 0) {
    _data_k_867 = 0;
    if (_data_k_867 >= _data_n_867) {
      _data_k_867 = 0;
    }
    am20cs_[15] = _data_l_867[_data_k_867++];
  }
  if (__calls[95].calls == 0) {
    _data_k_868 = 0;
    if (_data_k_868 >= _data_n_868) {
      _data_k_868 = 0;
    }
    am20cs_[16] = _data_l_868[_data_k_868++];
  }
  if (__calls[95].calls == 0) {
    _data_k_869 = 0;
    if (_data_k_869 >= _data_n_869) {
      _data_k_869 = 0;
    }
    am20cs_[17] = _data_l_869[_data_k_869++];
  }
  if (__calls[95].calls == 0) {
    _data_k_870 = 0;
    if (_data_k_870 >= _data_n_870) {
      _data_k_870 = 0;
    }
    am20cs_[18] = _data_l_870[_data_k_870++];
  }
  if (__calls[95].calls == 0) {
    _data_k_871 = 0;
    if (_data_k_871 >= _data_n_871) {
      _data_k_871 = 0;
    }
    am20cs_[19] = _data_l_871[_data_k_871++];
  }
  if (__calls[95].calls == 0) {
    _data_k_872 = 0;
    if (_data_k_872 >= _data_n_872) {
      _data_k_872 = 0;
    }
    am20cs_[20] = _data_l_872[_data_k_872++];
  }
  if (__calls[95].calls == 0) {
    _data_k_873 = 0;
    if (_data_k_873 >= _data_n_873) {
      _data_k_873 = 0;
    }
    am20cs_[21] = _data_l_873[_data_k_873++];
  }
  if (__calls[95].calls == 0) {
    _data_k_874 = 0;
    if (_data_k_874 >= _data_n_874) {
      _data_k_874 = 0;
    }
    am20cs_[22] = _data_l_874[_data_k_874++];
  }
  if (__calls[95].calls == 0) {
    _data_k_875 = 0;
    if (_data_k_875 >= _data_n_875) {
      _data_k_875 = 0;
    }
    am20cs_[23] = _data_l_875[_data_k_875++];
  }
  if (__calls[95].calls == 0) {
    _data_k_876 = 0;
    if (_data_k_876 >= _data_n_876) {
      _data_k_876 = 0;
    }
    am20cs_[24] = _data_l_876[_data_k_876++];
  }
  if (__calls[95].calls == 0) {
    _data_k_877 = 0;
    if (_data_k_877 >= _data_n_877) {
      _data_k_877 = 0;
    }
    am20cs_[25] = _data_l_877[_data_k_877++];
  }
  if (__calls[95].calls == 0) {
    _data_k_878 = 0;
    if (_data_k_878 >= _data_n_878) {
      _data_k_878 = 0;
    }
    am20cs_[26] = _data_l_878[_data_k_878++];
  }
  if (__calls[95].calls == 0) {
    _data_k_879 = 0;
    if (_data_k_879 >= _data_n_879) {
      _data_k_879 = 0;
    }
    am20cs_[27] = _data_l_879[_data_k_879++];
  }
  if (__calls[95].calls == 0) {
    _data_k_880 = 0;
    if (_data_k_880 >= _data_n_880) {
      _data_k_880 = 0;
    }
    am20cs_[28] = _data_l_880[_data_k_880++];
  }
  if (__calls[95].calls == 0) {
    _data_k_881 = 0;
    if (_data_k_881 >= _data_n_881) {
      _data_k_881 = 0;
    }
    am20cs_[29] = _data_l_881[_data_k_881++];
  }
  if (__calls[95].calls == 0) {
    _data_k_882 = 0;
    if (_data_k_882 >= _data_n_882) {
      _data_k_882 = 0;
    }
    am20cs_[30] = _data_l_882[_data_k_882++];
  }
  if (__calls[95].calls == 0) {
    _data_k_883 = 0;
    if (_data_k_883 >= _data_n_883) {
      _data_k_883 = 0;
    }
    am20cs_[31] = _data_l_883[_data_k_883++];
  }
  if (__calls[95].calls == 0) {
    _data_k_884 = 0;
    if (_data_k_884 >= _data_n_884) {
      _data_k_884 = 0;
    }
    am20cs_[32] = _data_l_884[_data_k_884++];
  }
  if (__calls[95].calls == 0) {
    _data_k_885 = 0;
    if (_data_k_885 >= _data_n_885) {
      _data_k_885 = 0;
    }
    am20cs_[33] = _data_l_885[_data_k_885++];
  }
  if (__calls[95].calls == 0) {
    _data_k_886 = 0;
    if (_data_k_886 >= _data_n_886) {
      _data_k_886 = 0;
    }
    am20cs_[34] = _data_l_886[_data_k_886++];
  }
  if (__calls[95].calls == 0) {
    _data_k_887 = 0;
    if (_data_k_887 >= _data_n_887) {
      _data_k_887 = 0;
    }
    am20cs_[35] = _data_l_887[_data_k_887++];
  }
  if (__calls[95].calls == 0) {
    _data_k_888 = 0;
    if (_data_k_888 >= _data_n_888) {
      _data_k_888 = 0;
    }
    am20cs_[36] = _data_l_888[_data_k_888++];
  }
  if (__calls[95].calls == 0) {
    _data_k_889 = 0;
    if (_data_k_889 >= _data_n_889) {
      _data_k_889 = 0;
    }
    am20cs_[37] = _data_l_889[_data_k_889++];
  }
  if (__calls[95].calls == 0) {
    _data_k_890 = 0;
    if (_data_k_890 >= _data_n_890) {
      _data_k_890 = 0;
    }
    am20cs_[38] = _data_l_890[_data_k_890++];
  }
  if (__calls[95].calls == 0) {
    _data_k_891 = 0;
    if (_data_k_891 >= _data_n_891) {
      _data_k_891 = 0;
    }
    am20cs_[39] = _data_l_891[_data_k_891++];
  }
  if (__calls[95].calls == 0) {
    _data_k_892 = 0;
    if (_data_k_892 >= _data_n_892) {
      _data_k_892 = 0;
    }
    am20cs_[40] = _data_l_892[_data_k_892++];
  }
  if (__calls[95].calls == 0) {
    _data_k_893 = 0;
    if (_data_k_893 >= _data_n_893) {
      _data_k_893 = 0;
    }
    am20cs_[41] = _data_l_893[_data_k_893++];
  }
  if (__calls[95].calls == 0) {
    _data_k_894 = 0;
    if (_data_k_894 >= _data_n_894) {
      _data_k_894 = 0;
    }
    am20cs_[42] = _data_l_894[_data_k_894++];
  }
  if (__calls[95].calls == 0) {
    _data_k_895 = 0;
    if (_data_k_895 >= _data_n_895) {
      _data_k_895 = 0;
    }
    am20cs_[43] = _data_l_895[_data_k_895++];
  }
  if (__calls[95].calls == 0) {
    _data_k_896 = 0;
    if (_data_k_896 >= _data_n_896) {
      _data_k_896 = 0;
    }
    am20cs_[44] = _data_l_896[_data_k_896++];
  }
  if (__calls[95].calls == 0) {
    _data_k_897 = 0;
    if (_data_k_897 >= _data_n_897) {
      _data_k_897 = 0;
    }
    am20cs_[45] = _data_l_897[_data_k_897++];
  }
  if (__calls[95].calls == 0) {
    _data_k_898 = 0;
    if (_data_k_898 >= _data_n_898) {
      _data_k_898 = 0;
    }
    am20cs_[46] = _data_l_898[_data_k_898++];
  }
  if (__calls[95].calls == 0) {
    _data_k_899 = 0;
    if (_data_k_899 >= _data_n_899) {
      _data_k_899 = 0;
    }
    am20cs_[47] = _data_l_899[_data_k_899++];
  }
  if (__calls[95].calls == 0) {
    _data_k_900 = 0;
    if (_data_k_900 >= _data_n_900) {
      _data_k_900 = 0;
    }
    am20cs_[48] = _data_l_900[_data_k_900++];
  }
  if (__calls[95].calls == 0) {
    _data_k_901 = 0;
    if (_data_k_901 >= _data_n_901) {
      _data_k_901 = 0;
    }
    am20cs_[49] = _data_l_901[_data_k_901++];
  }
  if (__calls[95].calls == 0) {
    _data_k_902 = 0;
    if (_data_k_902 >= _data_n_902) {
      _data_k_902 = 0;
    }
    am20cs_[50] = _data_l_902[_data_k_902++];
  }
  if (__calls[95].calls == 0) {
    _data_k_903 = 0;
    if (_data_k_903 >= _data_n_903) {
      _data_k_903 = 0;
    }
    am20cs_[51] = _data_l_903[_data_k_903++];
  }
  if (__calls[95].calls == 0) {
    _data_k_904 = 0;
    if (_data_k_904 >= _data_n_904) {
      _data_k_904 = 0;
    }
    am20cs_[52] = _data_l_904[_data_k_904++];
  }
  if (__calls[95].calls == 0) {
    _data_k_905 = 0;
    if (_data_k_905 >= _data_n_905) {
      _data_k_905 = 0;
    }
    am20cs_[53] = _data_l_905[_data_k_905++];
  }
  if (__calls[95].calls == 0) {
    _data_k_906 = 0;
    if (_data_k_906 >= _data_n_906) {
      _data_k_906 = 0;
    }
    am20cs_[54] = _data_l_906[_data_k_906++];
  }
  if (__calls[95].calls == 0) {
    _data_k_907 = 0;
    if (_data_k_907 >= _data_n_907) {
      _data_k_907 = 0;
    }
    am20cs_[55] = _data_l_907[_data_k_907++];
  }
  if (__calls[95].calls == 0) {
    _data_k_908 = 0;
    if (_data_k_908 >= _data_n_908) {
      _data_k_908 = 0;
    }
    am20cs_[56] = _data_l_908[_data_k_908++];
  }
  if (__calls[95].calls == 0) {
    _data_k_909 = 0;
    if (_data_k_909 >= _data_n_909) {
      _data_k_909 = 0;
    }
    ath0cs_[0] = _data_l_909[_data_k_909++];
  }
  if (__calls[95].calls == 0) {
    _data_k_910 = 0;
    if (_data_k_910 >= _data_n_910) {
      _data_k_910 = 0;
    }
    ath0cs_[1] = _data_l_910[_data_k_910++];
  }
  if (__calls[95].calls == 0) {
    _data_k_911 = 0;
    if (_data_k_911 >= _data_n_911) {
      _data_k_911 = 0;
    }
    ath0cs_[2] = _data_l_911[_data_k_911++];
  }
  if (__calls[95].calls == 0) {
    _data_k_912 = 0;
    if (_data_k_912 >= _data_n_912) {
      _data_k_912 = 0;
    }
    ath0cs_[3] = _data_l_912[_data_k_912++];
  }
  if (__calls[95].calls == 0) {
    _data_k_913 = 0;
    if (_data_k_913 >= _data_n_913) {
      _data_k_913 = 0;
    }
    ath0cs_[4] = _data_l_913[_data_k_913++];
  }
  if (__calls[95].calls == 0) {
    _data_k_914 = 0;
    if (_data_k_914 >= _data_n_914) {
      _data_k_914 = 0;
    }
    ath0cs_[5] = _data_l_914[_data_k_914++];
  }
  if (__calls[95].calls == 0) {
    _data_k_915 = 0;
    if (_data_k_915 >= _data_n_915) {
      _data_k_915 = 0;
    }
    ath0cs_[6] = _data_l_915[_data_k_915++];
  }
  if (__calls[95].calls == 0) {
    _data_k_916 = 0;
    if (_data_k_916 >= _data_n_916) {
      _data_k_916 = 0;
    }
    ath0cs_[7] = _data_l_916[_data_k_916++];
  }
  if (__calls[95].calls == 0) {
    _data_k_917 = 0;
    if (_data_k_917 >= _data_n_917) {
      _data_k_917 = 0;
    }
    ath0cs_[8] = _data_l_917[_data_k_917++];
  }
  if (__calls[95].calls == 0) {
    _data_k_918 = 0;
    if (_data_k_918 >= _data_n_918) {
      _data_k_918 = 0;
    }
    ath0cs_[9] = _data_l_918[_data_k_918++];
  }
  if (__calls[95].calls == 0) {
    _data_k_919 = 0;
    if (_data_k_919 >= _data_n_919) {
      _data_k_919 = 0;
    }
    ath0cs_[10] = _data_l_919[_data_k_919++];
  }
  if (__calls[95].calls == 0) {
    _data_k_920 = 0;
    if (_data_k_920 >= _data_n_920) {
      _data_k_920 = 0;
    }
    ath0cs_[11] = _data_l_920[_data_k_920++];
  }
  if (__calls[95].calls == 0) {
    _data_k_921 = 0;
    if (_data_k_921 >= _data_n_921) {
      _data_k_921 = 0;
    }
    ath0cs_[12] = _data_l_921[_data_k_921++];
  }
  if (__calls[95].calls == 0) {
    _data_k_922 = 0;
    if (_data_k_922 >= _data_n_922) {
      _data_k_922 = 0;
    }
    ath0cs_[13] = _data_l_922[_data_k_922++];
  }
  if (__calls[95].calls == 0) {
    _data_k_923 = 0;
    if (_data_k_923 >= _data_n_923) {
      _data_k_923 = 0;
    }
    ath0cs_[14] = _data_l_923[_data_k_923++];
  }
  if (__calls[95].calls == 0) {
    _data_k_924 = 0;
    if (_data_k_924 >= _data_n_924) {
      _data_k_924 = 0;
    }
    ath0cs_[15] = _data_l_924[_data_k_924++];
  }
  if (__calls[95].calls == 0) {
    _data_k_925 = 0;
    if (_data_k_925 >= _data_n_925) {
      _data_k_925 = 0;
    }
    ath0cs_[16] = _data_l_925[_data_k_925++];
  }
  if (__calls[95].calls == 0) {
    _data_k_926 = 0;
    if (_data_k_926 >= _data_n_926) {
      _data_k_926 = 0;
    }
    ath0cs_[17] = _data_l_926[_data_k_926++];
  }
  if (__calls[95].calls == 0) {
    _data_k_927 = 0;
    if (_data_k_927 >= _data_n_927) {
      _data_k_927 = 0;
    }
    ath0cs_[18] = _data_l_927[_data_k_927++];
  }
  if (__calls[95].calls == 0) {
    _data_k_928 = 0;
    if (_data_k_928 >= _data_n_928) {
      _data_k_928 = 0;
    }
    ath0cs_[19] = _data_l_928[_data_k_928++];
  }
  if (__calls[95].calls == 0) {
    _data_k_929 = 0;
    if (_data_k_929 >= _data_n_929) {
      _data_k_929 = 0;
    }
    ath0cs_[20] = _data_l_929[_data_k_929++];
  }
  if (__calls[95].calls == 0) {
    _data_k_930 = 0;
    if (_data_k_930 >= _data_n_930) {
      _data_k_930 = 0;
    }
    ath0cs_[21] = _data_l_930[_data_k_930++];
  }
  if (__calls[95].calls == 0) {
    _data_k_931 = 0;
    if (_data_k_931 >= _data_n_931) {
      _data_k_931 = 0;
    }
    ath0cs_[22] = _data_l_931[_data_k_931++];
  }
  if (__calls[95].calls == 0) {
    _data_k_932 = 0;
    if (_data_k_932 >= _data_n_932) {
      _data_k_932 = 0;
    }
    ath0cs_[23] = _data_l_932[_data_k_932++];
  }
  if (__calls[95].calls == 0) {
    _data_k_933 = 0;
    if (_data_k_933 >= _data_n_933) {
      _data_k_933 = 0;
    }
    ath0cs_[24] = _data_l_933[_data_k_933++];
  }
  if (__calls[95].calls == 0) {
    _data_k_934 = 0;
    if (_data_k_934 >= _data_n_934) {
      _data_k_934 = 0;
    }
    ath0cs_[25] = _data_l_934[_data_k_934++];
  }
  if (__calls[95].calls == 0) {
    _data_k_935 = 0;
    if (_data_k_935 >= _data_n_935) {
      _data_k_935 = 0;
    }
    ath0cs_[26] = _data_l_935[_data_k_935++];
  }
  if (__calls[95].calls == 0) {
    _data_k_936 = 0;
    if (_data_k_936 >= _data_n_936) {
      _data_k_936 = 0;
    }
    ath0cs_[27] = _data_l_936[_data_k_936++];
  }
  if (__calls[95].calls == 0) {
    _data_k_937 = 0;
    if (_data_k_937 >= _data_n_937) {
      _data_k_937 = 0;
    }
    ath0cs_[28] = _data_l_937[_data_k_937++];
  }
  if (__calls[95].calls == 0) {
    _data_k_938 = 0;
    if (_data_k_938 >= _data_n_938) {
      _data_k_938 = 0;
    }
    ath0cs_[29] = _data_l_938[_data_k_938++];
  }
  if (__calls[95].calls == 0) {
    _data_k_939 = 0;
    if (_data_k_939 >= _data_n_939) {
      _data_k_939 = 0;
    }
    ath0cs_[30] = _data_l_939[_data_k_939++];
  }
  if (__calls[95].calls == 0) {
    _data_k_940 = 0;
    if (_data_k_940 >= _data_n_940) {
      _data_k_940 = 0;
    }
    ath0cs_[31] = _data_l_940[_data_k_940++];
  }
  if (__calls[95].calls == 0) {
    _data_k_941 = 0;
    if (_data_k_941 >= _data_n_941) {
      _data_k_941 = 0;
    }
    ath0cs_[32] = _data_l_941[_data_k_941++];
  }
  if (__calls[95].calls == 0) {
    _data_k_942 = 0;
    if (_data_k_942 >= _data_n_942) {
      _data_k_942 = 0;
    }
    ath0cs_[33] = _data_l_942[_data_k_942++];
  }
  if (__calls[95].calls == 0) {
    _data_k_943 = 0;
    if (_data_k_943 >= _data_n_943) {
      _data_k_943 = 0;
    }
    ath0cs_[34] = _data_l_943[_data_k_943++];
  }
  if (__calls[95].calls == 0) {
    _data_k_944 = 0;
    if (_data_k_944 >= _data_n_944) {
      _data_k_944 = 0;
    }
    ath0cs_[35] = _data_l_944[_data_k_944++];
  }
  if (__calls[95].calls == 0) {
    _data_k_945 = 0;
    if (_data_k_945 >= _data_n_945) {
      _data_k_945 = 0;
    }
    ath0cs_[36] = _data_l_945[_data_k_945++];
  }
  if (__calls[95].calls == 0) {
    _data_k_946 = 0;
    if (_data_k_946 >= _data_n_946) {
      _data_k_946 = 0;
    }
    ath0cs_[37] = _data_l_946[_data_k_946++];
  }
  if (__calls[95].calls == 0) {
    _data_k_947 = 0;
    if (_data_k_947 >= _data_n_947) {
      _data_k_947 = 0;
    }
    ath0cs_[38] = _data_l_947[_data_k_947++];
  }
  if (__calls[95].calls == 0) {
    _data_k_948 = 0;
    if (_data_k_948 >= _data_n_948) {
      _data_k_948 = 0;
    }
    ath0cs_[39] = _data_l_948[_data_k_948++];
  }
  if (__calls[95].calls == 0) {
    _data_k_949 = 0;
    if (_data_k_949 >= _data_n_949) {
      _data_k_949 = 0;
    }
    ath0cs_[40] = _data_l_949[_data_k_949++];
  }
  if (__calls[95].calls == 0) {
    _data_k_950 = 0;
    if (_data_k_950 >= _data_n_950) {
      _data_k_950 = 0;
    }
    ath0cs_[41] = _data_l_950[_data_k_950++];
  }
  if (__calls[95].calls == 0) {
    _data_k_951 = 0;
    if (_data_k_951 >= _data_n_951) {
      _data_k_951 = 0;
    }
    ath0cs_[42] = _data_l_951[_data_k_951++];
  }
  if (__calls[95].calls == 0) {
    _data_k_952 = 0;
    if (_data_k_952 >= _data_n_952) {
      _data_k_952 = 0;
    }
    ath0cs_[43] = _data_l_952[_data_k_952++];
  }
  if (__calls[95].calls == 0) {
    _data_k_953 = 0;
    if (_data_k_953 >= _data_n_953) {
      _data_k_953 = 0;
    }
    ath0cs_[44] = _data_l_953[_data_k_953++];
  }
  if (__calls[95].calls == 0) {
    _data_k_954 = 0;
    if (_data_k_954 >= _data_n_954) {
      _data_k_954 = 0;
    }
    ath0cs_[45] = _data_l_954[_data_k_954++];
  }
  if (__calls[95].calls == 0) {
    _data_k_955 = 0;
    if (_data_k_955 >= _data_n_955) {
      _data_k_955 = 0;
    }
    ath0cs_[46] = _data_l_955[_data_k_955++];
  }
  if (__calls[95].calls == 0) {
    _data_k_956 = 0;
    if (_data_k_956 >= _data_n_956) {
      _data_k_956 = 0;
    }
    ath0cs_[47] = _data_l_956[_data_k_956++];
  }
  if (__calls[95].calls == 0) {
    _data_k_957 = 0;
    if (_data_k_957 >= _data_n_957) {
      _data_k_957 = 0;
    }
    ath0cs_[48] = _data_l_957[_data_k_957++];
  }
  if (__calls[95].calls == 0) {
    _data_k_958 = 0;
    if (_data_k_958 >= _data_n_958) {
      _data_k_958 = 0;
    }
    ath0cs_[49] = _data_l_958[_data_k_958++];
  }
  if (__calls[95].calls == 0) {
    _data_k_959 = 0;
    if (_data_k_959 >= _data_n_959) {
      _data_k_959 = 0;
    }
    ath0cs_[50] = _data_l_959[_data_k_959++];
  }
  if (__calls[95].calls == 0) {
    _data_k_960 = 0;
    if (_data_k_960 >= _data_n_960) {
      _data_k_960 = 0;
    }
    ath0cs_[51] = _data_l_960[_data_k_960++];
  }
  if (__calls[95].calls == 0) {
    _data_k_961 = 0;
    if (_data_k_961 >= _data_n_961) {
      _data_k_961 = 0;
    }
    ath0cs_[52] = _data_l_961[_data_k_961++];
  }
  if (__calls[95].calls == 0) {
    _data_k_962 = 0;
    if (_data_k_962 >= _data_n_962) {
      _data_k_962 = 0;
    }
    am21cs_[0] = _data_l_962[_data_k_962++];
  }
  if (__calls[95].calls == 0) {
    _data_k_963 = 0;
    if (_data_k_963 >= _data_n_963) {
      _data_k_963 = 0;
    }
    am21cs_[1] = _data_l_963[_data_k_963++];
  }
  if (__calls[95].calls == 0) {
    _data_k_964 = 0;
    if (_data_k_964 >= _data_n_964) {
      _data_k_964 = 0;
    }
    am21cs_[2] = _data_l_964[_data_k_964++];
  }
  if (__calls[95].calls == 0) {
    _data_k_965 = 0;
    if (_data_k_965 >= _data_n_965) {
      _data_k_965 = 0;
    }
    am21cs_[3] = _data_l_965[_data_k_965++];
  }
  if (__calls[95].calls == 0) {
    _data_k_966 = 0;
    if (_data_k_966 >= _data_n_966) {
      _data_k_966 = 0;
    }
    am21cs_[4] = _data_l_966[_data_k_966++];
  }
  if (__calls[95].calls == 0) {
    _data_k_967 = 0;
    if (_data_k_967 >= _data_n_967) {
      _data_k_967 = 0;
    }
    am21cs_[5] = _data_l_967[_data_k_967++];
  }
  if (__calls[95].calls == 0) {
    _data_k_968 = 0;
    if (_data_k_968 >= _data_n_968) {
      _data_k_968 = 0;
    }
    am21cs_[6] = _data_l_968[_data_k_968++];
  }
  if (__calls[95].calls == 0) {
    _data_k_969 = 0;
    if (_data_k_969 >= _data_n_969) {
      _data_k_969 = 0;
    }
    am21cs_[7] = _data_l_969[_data_k_969++];
  }
  if (__calls[95].calls == 0) {
    _data_k_970 = 0;
    if (_data_k_970 >= _data_n_970) {
      _data_k_970 = 0;
    }
    am21cs_[8] = _data_l_970[_data_k_970++];
  }
  if (__calls[95].calls == 0) {
    _data_k_971 = 0;
    if (_data_k_971 >= _data_n_971) {
      _data_k_971 = 0;
    }
    am21cs_[9] = _data_l_971[_data_k_971++];
  }
  if (__calls[95].calls == 0) {
    _data_k_972 = 0;
    if (_data_k_972 >= _data_n_972) {
      _data_k_972 = 0;
    }
    am21cs_[10] = _data_l_972[_data_k_972++];
  }
  if (__calls[95].calls == 0) {
    _data_k_973 = 0;
    if (_data_k_973 >= _data_n_973) {
      _data_k_973 = 0;
    }
    am21cs_[11] = _data_l_973[_data_k_973++];
  }
  if (__calls[95].calls == 0) {
    _data_k_974 = 0;
    if (_data_k_974 >= _data_n_974) {
      _data_k_974 = 0;
    }
    am21cs_[12] = _data_l_974[_data_k_974++];
  }
  if (__calls[95].calls == 0) {
    _data_k_975 = 0;
    if (_data_k_975 >= _data_n_975) {
      _data_k_975 = 0;
    }
    am21cs_[13] = _data_l_975[_data_k_975++];
  }
  if (__calls[95].calls == 0) {
    _data_k_976 = 0;
    if (_data_k_976 >= _data_n_976) {
      _data_k_976 = 0;
    }
    am21cs_[14] = _data_l_976[_data_k_976++];
  }
  if (__calls[95].calls == 0) {
    _data_k_977 = 0;
    if (_data_k_977 >= _data_n_977) {
      _data_k_977 = 0;
    }
    am21cs_[15] = _data_l_977[_data_k_977++];
  }
  if (__calls[95].calls == 0) {
    _data_k_978 = 0;
    if (_data_k_978 >= _data_n_978) {
      _data_k_978 = 0;
    }
    am21cs_[16] = _data_l_978[_data_k_978++];
  }
  if (__calls[95].calls == 0) {
    _data_k_979 = 0;
    if (_data_k_979 >= _data_n_979) {
      _data_k_979 = 0;
    }
    am21cs_[17] = _data_l_979[_data_k_979++];
  }
  if (__calls[95].calls == 0) {
    _data_k_980 = 0;
    if (_data_k_980 >= _data_n_980) {
      _data_k_980 = 0;
    }
    am21cs_[18] = _data_l_980[_data_k_980++];
  }
  if (__calls[95].calls == 0) {
    _data_k_981 = 0;
    if (_data_k_981 >= _data_n_981) {
      _data_k_981 = 0;
    }
    am21cs_[19] = _data_l_981[_data_k_981++];
  }
  if (__calls[95].calls == 0) {
    _data_k_982 = 0;
    if (_data_k_982 >= _data_n_982) {
      _data_k_982 = 0;
    }
    am21cs_[20] = _data_l_982[_data_k_982++];
  }
  if (__calls[95].calls == 0) {
    _data_k_983 = 0;
    if (_data_k_983 >= _data_n_983) {
      _data_k_983 = 0;
    }
    am21cs_[21] = _data_l_983[_data_k_983++];
  }
  if (__calls[95].calls == 0) {
    _data_k_984 = 0;
    if (_data_k_984 >= _data_n_984) {
      _data_k_984 = 0;
    }
    am21cs_[22] = _data_l_984[_data_k_984++];
  }
  if (__calls[95].calls == 0) {
    _data_k_985 = 0;
    if (_data_k_985 >= _data_n_985) {
      _data_k_985 = 0;
    }
    am21cs_[23] = _data_l_985[_data_k_985++];
  }
  if (__calls[95].calls == 0) {
    _data_k_986 = 0;
    if (_data_k_986 >= _data_n_986) {
      _data_k_986 = 0;
    }
    am21cs_[24] = _data_l_986[_data_k_986++];
  }
  if (__calls[95].calls == 0) {
    _data_k_987 = 0;
    if (_data_k_987 >= _data_n_987) {
      _data_k_987 = 0;
    }
    am21cs_[25] = _data_l_987[_data_k_987++];
  }
  if (__calls[95].calls == 0) {
    _data_k_988 = 0;
    if (_data_k_988 >= _data_n_988) {
      _data_k_988 = 0;
    }
    am21cs_[26] = _data_l_988[_data_k_988++];
  }
  if (__calls[95].calls == 0) {
    _data_k_989 = 0;
    if (_data_k_989 >= _data_n_989) {
      _data_k_989 = 0;
    }
    am21cs_[27] = _data_l_989[_data_k_989++];
  }
  if (__calls[95].calls == 0) {
    _data_k_990 = 0;
    if (_data_k_990 >= _data_n_990) {
      _data_k_990 = 0;
    }
    am21cs_[28] = _data_l_990[_data_k_990++];
  }
  if (__calls[95].calls == 0) {
    _data_k_991 = 0;
    if (_data_k_991 >= _data_n_991) {
      _data_k_991 = 0;
    }
    am21cs_[29] = _data_l_991[_data_k_991++];
  }
  if (__calls[95].calls == 0) {
    _data_k_992 = 0;
    if (_data_k_992 >= _data_n_992) {
      _data_k_992 = 0;
    }
    am21cs_[30] = _data_l_992[_data_k_992++];
  }
  if (__calls[95].calls == 0) {
    _data_k_993 = 0;
    if (_data_k_993 >= _data_n_993) {
      _data_k_993 = 0;
    }
    am21cs_[31] = _data_l_993[_data_k_993++];
  }
  if (__calls[95].calls == 0) {
    _data_k_994 = 0;
    if (_data_k_994 >= _data_n_994) {
      _data_k_994 = 0;
    }
    am21cs_[32] = _data_l_994[_data_k_994++];
  }
  if (__calls[95].calls == 0) {
    _data_k_995 = 0;
    if (_data_k_995 >= _data_n_995) {
      _data_k_995 = 0;
    }
    am21cs_[33] = _data_l_995[_data_k_995++];
  }
  if (__calls[95].calls == 0) {
    _data_k_996 = 0;
    if (_data_k_996 >= _data_n_996) {
      _data_k_996 = 0;
    }
    am21cs_[34] = _data_l_996[_data_k_996++];
  }
  if (__calls[95].calls == 0) {
    _data_k_997 = 0;
    if (_data_k_997 >= _data_n_997) {
      _data_k_997 = 0;
    }
    am21cs_[35] = _data_l_997[_data_k_997++];
  }
  if (__calls[95].calls == 0) {
    _data_k_998 = 0;
    if (_data_k_998 >= _data_n_998) {
      _data_k_998 = 0;
    }
    am21cs_[36] = _data_l_998[_data_k_998++];
  }
  if (__calls[95].calls == 0) {
    _data_k_999 = 0;
    if (_data_k_999 >= _data_n_999) {
      _data_k_999 = 0;
    }
    am21cs_[37] = _data_l_999[_data_k_999++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1000 = 0;
    if (_data_k_1000 >= _data_n_1000) {
      _data_k_1000 = 0;
    }
    am21cs_[38] = _data_l_1000[_data_k_1000++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1001 = 0;
    if (_data_k_1001 >= _data_n_1001) {
      _data_k_1001 = 0;
    }
    am21cs_[39] = _data_l_1001[_data_k_1001++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1002 = 0;
    if (_data_k_1002 >= _data_n_1002) {
      _data_k_1002 = 0;
    }
    am21cs_[40] = _data_l_1002[_data_k_1002++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1003 = 0;
    if (_data_k_1003 >= _data_n_1003) {
      _data_k_1003 = 0;
    }
    am21cs_[41] = _data_l_1003[_data_k_1003++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1004 = 0;
    if (_data_k_1004 >= _data_n_1004) {
      _data_k_1004 = 0;
    }
    am21cs_[42] = _data_l_1004[_data_k_1004++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1005 = 0;
    if (_data_k_1005 >= _data_n_1005) {
      _data_k_1005 = 0;
    }
    am21cs_[43] = _data_l_1005[_data_k_1005++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1006 = 0;
    if (_data_k_1006 >= _data_n_1006) {
      _data_k_1006 = 0;
    }
    am21cs_[44] = _data_l_1006[_data_k_1006++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1007 = 0;
    if (_data_k_1007 >= _data_n_1007) {
      _data_k_1007 = 0;
    }
    am21cs_[45] = _data_l_1007[_data_k_1007++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1008 = 0;
    if (_data_k_1008 >= _data_n_1008) {
      _data_k_1008 = 0;
    }
    am21cs_[46] = _data_l_1008[_data_k_1008++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1009 = 0;
    if (_data_k_1009 >= _data_n_1009) {
      _data_k_1009 = 0;
    }
    am21cs_[47] = _data_l_1009[_data_k_1009++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1010 = 0;
    if (_data_k_1010 >= _data_n_1010) {
      _data_k_1010 = 0;
    }
    am21cs_[48] = _data_l_1010[_data_k_1010++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1011 = 0;
    if (_data_k_1011 >= _data_n_1011) {
      _data_k_1011 = 0;
    }
    am21cs_[49] = _data_l_1011[_data_k_1011++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1012 = 0;
    if (_data_k_1012 >= _data_n_1012) {
      _data_k_1012 = 0;
    }
    am21cs_[50] = _data_l_1012[_data_k_1012++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1013 = 0;
    if (_data_k_1013 >= _data_n_1013) {
      _data_k_1013 = 0;
    }
    am21cs_[51] = _data_l_1013[_data_k_1013++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1014 = 0;
    if (_data_k_1014 >= _data_n_1014) {
      _data_k_1014 = 0;
    }
    am21cs_[52] = _data_l_1014[_data_k_1014++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1015 = 0;
    if (_data_k_1015 >= _data_n_1015) {
      _data_k_1015 = 0;
    }
    am21cs_[53] = _data_l_1015[_data_k_1015++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1016 = 0;
    if (_data_k_1016 >= _data_n_1016) {
      _data_k_1016 = 0;
    }
    am21cs_[54] = _data_l_1016[_data_k_1016++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1017 = 0;
    if (_data_k_1017 >= _data_n_1017) {
      _data_k_1017 = 0;
    }
    am21cs_[55] = _data_l_1017[_data_k_1017++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1018 = 0;
    if (_data_k_1018 >= _data_n_1018) {
      _data_k_1018 = 0;
    }
    am21cs_[56] = _data_l_1018[_data_k_1018++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1019 = 0;
    if (_data_k_1019 >= _data_n_1019) {
      _data_k_1019 = 0;
    }
    am21cs_[57] = _data_l_1019[_data_k_1019++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1020 = 0;
    if (_data_k_1020 >= _data_n_1020) {
      _data_k_1020 = 0;
    }
    am21cs_[58] = _data_l_1020[_data_k_1020++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1021 = 0;
    if (_data_k_1021 >= _data_n_1021) {
      _data_k_1021 = 0;
    }
    am21cs_[59] = _data_l_1021[_data_k_1021++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1022 = 0;
    if (_data_k_1022 >= _data_n_1022) {
      _data_k_1022 = 0;
    }
    ath1cs_[0] = _data_l_1022[_data_k_1022++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1023 = 0;
    if (_data_k_1023 >= _data_n_1023) {
      _data_k_1023 = 0;
    }
    ath1cs_[1] = _data_l_1023[_data_k_1023++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1024 = 0;
    if (_data_k_1024 >= _data_n_1024) {
      _data_k_1024 = 0;
    }
    ath1cs_[2] = _data_l_1024[_data_k_1024++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1025 = 0;
    if (_data_k_1025 >= _data_n_1025) {
      _data_k_1025 = 0;
    }
    ath1cs_[3] = _data_l_1025[_data_k_1025++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1026 = 0;
    if (_data_k_1026 >= _data_n_1026) {
      _data_k_1026 = 0;
    }
    ath1cs_[4] = _data_l_1026[_data_k_1026++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1027 = 0;
    if (_data_k_1027 >= _data_n_1027) {
      _data_k_1027 = 0;
    }
    ath1cs_[5] = _data_l_1027[_data_k_1027++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1028 = 0;
    if (_data_k_1028 >= _data_n_1028) {
      _data_k_1028 = 0;
    }
    ath1cs_[6] = _data_l_1028[_data_k_1028++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1029 = 0;
    if (_data_k_1029 >= _data_n_1029) {
      _data_k_1029 = 0;
    }
    ath1cs_[7] = _data_l_1029[_data_k_1029++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1030 = 0;
    if (_data_k_1030 >= _data_n_1030) {
      _data_k_1030 = 0;
    }
    ath1cs_[8] = _data_l_1030[_data_k_1030++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1031 = 0;
    if (_data_k_1031 >= _data_n_1031) {
      _data_k_1031 = 0;
    }
    ath1cs_[9] = _data_l_1031[_data_k_1031++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1032 = 0;
    if (_data_k_1032 >= _data_n_1032) {
      _data_k_1032 = 0;
    }
    ath1cs_[10] = _data_l_1032[_data_k_1032++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1033 = 0;
    if (_data_k_1033 >= _data_n_1033) {
      _data_k_1033 = 0;
    }
    ath1cs_[11] = _data_l_1033[_data_k_1033++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1034 = 0;
    if (_data_k_1034 >= _data_n_1034) {
      _data_k_1034 = 0;
    }
    ath1cs_[12] = _data_l_1034[_data_k_1034++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1035 = 0;
    if (_data_k_1035 >= _data_n_1035) {
      _data_k_1035 = 0;
    }
    ath1cs_[13] = _data_l_1035[_data_k_1035++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1036 = 0;
    if (_data_k_1036 >= _data_n_1036) {
      _data_k_1036 = 0;
    }
    ath1cs_[14] = _data_l_1036[_data_k_1036++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1037 = 0;
    if (_data_k_1037 >= _data_n_1037) {
      _data_k_1037 = 0;
    }
    ath1cs_[15] = _data_l_1037[_data_k_1037++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1038 = 0;
    if (_data_k_1038 >= _data_n_1038) {
      _data_k_1038 = 0;
    }
    ath1cs_[16] = _data_l_1038[_data_k_1038++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1039 = 0;
    if (_data_k_1039 >= _data_n_1039) {
      _data_k_1039 = 0;
    }
    ath1cs_[17] = _data_l_1039[_data_k_1039++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1040 = 0;
    if (_data_k_1040 >= _data_n_1040) {
      _data_k_1040 = 0;
    }
    ath1cs_[18] = _data_l_1040[_data_k_1040++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1041 = 0;
    if (_data_k_1041 >= _data_n_1041) {
      _data_k_1041 = 0;
    }
    ath1cs_[19] = _data_l_1041[_data_k_1041++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1042 = 0;
    if (_data_k_1042 >= _data_n_1042) {
      _data_k_1042 = 0;
    }
    ath1cs_[20] = _data_l_1042[_data_k_1042++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1043 = 0;
    if (_data_k_1043 >= _data_n_1043) {
      _data_k_1043 = 0;
    }
    ath1cs_[21] = _data_l_1043[_data_k_1043++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1044 = 0;
    if (_data_k_1044 >= _data_n_1044) {
      _data_k_1044 = 0;
    }
    ath1cs_[22] = _data_l_1044[_data_k_1044++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1045 = 0;
    if (_data_k_1045 >= _data_n_1045) {
      _data_k_1045 = 0;
    }
    ath1cs_[23] = _data_l_1045[_data_k_1045++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1046 = 0;
    if (_data_k_1046 >= _data_n_1046) {
      _data_k_1046 = 0;
    }
    ath1cs_[24] = _data_l_1046[_data_k_1046++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1047 = 0;
    if (_data_k_1047 >= _data_n_1047) {
      _data_k_1047 = 0;
    }
    ath1cs_[25] = _data_l_1047[_data_k_1047++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1048 = 0;
    if (_data_k_1048 >= _data_n_1048) {
      _data_k_1048 = 0;
    }
    ath1cs_[26] = _data_l_1048[_data_k_1048++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1049 = 0;
    if (_data_k_1049 >= _data_n_1049) {
      _data_k_1049 = 0;
    }
    ath1cs_[27] = _data_l_1049[_data_k_1049++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1050 = 0;
    if (_data_k_1050 >= _data_n_1050) {
      _data_k_1050 = 0;
    }
    ath1cs_[28] = _data_l_1050[_data_k_1050++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1051 = 0;
    if (_data_k_1051 >= _data_n_1051) {
      _data_k_1051 = 0;
    }
    ath1cs_[29] = _data_l_1051[_data_k_1051++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1052 = 0;
    if (_data_k_1052 >= _data_n_1052) {
      _data_k_1052 = 0;
    }
    ath1cs_[30] = _data_l_1052[_data_k_1052++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1053 = 0;
    if (_data_k_1053 >= _data_n_1053) {
      _data_k_1053 = 0;
    }
    ath1cs_[31] = _data_l_1053[_data_k_1053++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1054 = 0;
    if (_data_k_1054 >= _data_n_1054) {
      _data_k_1054 = 0;
    }
    ath1cs_[32] = _data_l_1054[_data_k_1054++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1055 = 0;
    if (_data_k_1055 >= _data_n_1055) {
      _data_k_1055 = 0;
    }
    ath1cs_[33] = _data_l_1055[_data_k_1055++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1056 = 0;
    if (_data_k_1056 >= _data_n_1056) {
      _data_k_1056 = 0;
    }
    ath1cs_[34] = _data_l_1056[_data_k_1056++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1057 = 0;
    if (_data_k_1057 >= _data_n_1057) {
      _data_k_1057 = 0;
    }
    ath1cs_[35] = _data_l_1057[_data_k_1057++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1058 = 0;
    if (_data_k_1058 >= _data_n_1058) {
      _data_k_1058 = 0;
    }
    ath1cs_[36] = _data_l_1058[_data_k_1058++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1059 = 0;
    if (_data_k_1059 >= _data_n_1059) {
      _data_k_1059 = 0;
    }
    ath1cs_[37] = _data_l_1059[_data_k_1059++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1060 = 0;
    if (_data_k_1060 >= _data_n_1060) {
      _data_k_1060 = 0;
    }
    ath1cs_[38] = _data_l_1060[_data_k_1060++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1061 = 0;
    if (_data_k_1061 >= _data_n_1061) {
      _data_k_1061 = 0;
    }
    ath1cs_[39] = _data_l_1061[_data_k_1061++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1062 = 0;
    if (_data_k_1062 >= _data_n_1062) {
      _data_k_1062 = 0;
    }
    ath1cs_[40] = _data_l_1062[_data_k_1062++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1063 = 0;
    if (_data_k_1063 >= _data_n_1063) {
      _data_k_1063 = 0;
    }
    ath1cs_[41] = _data_l_1063[_data_k_1063++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1064 = 0;
    if (_data_k_1064 >= _data_n_1064) {
      _data_k_1064 = 0;
    }
    ath1cs_[42] = _data_l_1064[_data_k_1064++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1065 = 0;
    if (_data_k_1065 >= _data_n_1065) {
      _data_k_1065 = 0;
    }
    ath1cs_[43] = _data_l_1065[_data_k_1065++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1066 = 0;
    if (_data_k_1066 >= _data_n_1066) {
      _data_k_1066 = 0;
    }
    ath1cs_[44] = _data_l_1066[_data_k_1066++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1067 = 0;
    if (_data_k_1067 >= _data_n_1067) {
      _data_k_1067 = 0;
    }
    ath1cs_[45] = _data_l_1067[_data_k_1067++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1068 = 0;
    if (_data_k_1068 >= _data_n_1068) {
      _data_k_1068 = 0;
    }
    ath1cs_[46] = _data_l_1068[_data_k_1068++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1069 = 0;
    if (_data_k_1069 >= _data_n_1069) {
      _data_k_1069 = 0;
    }
    ath1cs_[47] = _data_l_1069[_data_k_1069++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1070 = 0;
    if (_data_k_1070 >= _data_n_1070) {
      _data_k_1070 = 0;
    }
    ath1cs_[48] = _data_l_1070[_data_k_1070++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1071 = 0;
    if (_data_k_1071 >= _data_n_1071) {
      _data_k_1071 = 0;
    }
    ath1cs_[49] = _data_l_1071[_data_k_1071++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1072 = 0;
    if (_data_k_1072 >= _data_n_1072) {
      _data_k_1072 = 0;
    }
    ath1cs_[50] = _data_l_1072[_data_k_1072++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1073 = 0;
    if (_data_k_1073 >= _data_n_1073) {
      _data_k_1073 = 0;
    }
    ath1cs_[51] = _data_l_1073[_data_k_1073++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1074 = 0;
    if (_data_k_1074 >= _data_n_1074) {
      _data_k_1074 = 0;
    }
    ath1cs_[52] = _data_l_1074[_data_k_1074++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1075 = 0;
    if (_data_k_1075 >= _data_n_1075) {
      _data_k_1075 = 0;
    }
    ath1cs_[53] = _data_l_1075[_data_k_1075++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1076 = 0;
    if (_data_k_1076 >= _data_n_1076) {
      _data_k_1076 = 0;
    }
    ath1cs_[54] = _data_l_1076[_data_k_1076++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1077 = 0;
    if (_data_k_1077 >= _data_n_1077) {
      _data_k_1077 = 0;
    }
    ath1cs_[55] = _data_l_1077[_data_k_1077++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1078 = 0;
    if (_data_k_1078 >= _data_n_1078) {
      _data_k_1078 = 0;
    }
    ath1cs_[56] = _data_l_1078[_data_k_1078++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1079 = 0;
    if (_data_k_1079 >= _data_n_1079) {
      _data_k_1079 = 0;
    }
    ath1cs_[57] = _data_l_1079[_data_k_1079++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1080 = 0;
    if (_data_k_1080 >= _data_n_1080) {
      _data_k_1080 = 0;
    }
    am22cs_[0] = _data_l_1080[_data_k_1080++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1081 = 0;
    if (_data_k_1081 >= _data_n_1081) {
      _data_k_1081 = 0;
    }
    am22cs_[1] = _data_l_1081[_data_k_1081++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1082 = 0;
    if (_data_k_1082 >= _data_n_1082) {
      _data_k_1082 = 0;
    }
    am22cs_[2] = _data_l_1082[_data_k_1082++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1083 = 0;
    if (_data_k_1083 >= _data_n_1083) {
      _data_k_1083 = 0;
    }
    am22cs_[3] = _data_l_1083[_data_k_1083++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1084 = 0;
    if (_data_k_1084 >= _data_n_1084) {
      _data_k_1084 = 0;
    }
    am22cs_[4] = _data_l_1084[_data_k_1084++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1085 = 0;
    if (_data_k_1085 >= _data_n_1085) {
      _data_k_1085 = 0;
    }
    am22cs_[5] = _data_l_1085[_data_k_1085++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1086 = 0;
    if (_data_k_1086 >= _data_n_1086) {
      _data_k_1086 = 0;
    }
    am22cs_[6] = _data_l_1086[_data_k_1086++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1087 = 0;
    if (_data_k_1087 >= _data_n_1087) {
      _data_k_1087 = 0;
    }
    am22cs_[7] = _data_l_1087[_data_k_1087++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1088 = 0;
    if (_data_k_1088 >= _data_n_1088) {
      _data_k_1088 = 0;
    }
    am22cs_[8] = _data_l_1088[_data_k_1088++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1089 = 0;
    if (_data_k_1089 >= _data_n_1089) {
      _data_k_1089 = 0;
    }
    am22cs_[9] = _data_l_1089[_data_k_1089++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1090 = 0;
    if (_data_k_1090 >= _data_n_1090) {
      _data_k_1090 = 0;
    }
    am22cs_[10] = _data_l_1090[_data_k_1090++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1091 = 0;
    if (_data_k_1091 >= _data_n_1091) {
      _data_k_1091 = 0;
    }
    am22cs_[11] = _data_l_1091[_data_k_1091++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1092 = 0;
    if (_data_k_1092 >= _data_n_1092) {
      _data_k_1092 = 0;
    }
    am22cs_[12] = _data_l_1092[_data_k_1092++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1093 = 0;
    if (_data_k_1093 >= _data_n_1093) {
      _data_k_1093 = 0;
    }
    am22cs_[13] = _data_l_1093[_data_k_1093++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1094 = 0;
    if (_data_k_1094 >= _data_n_1094) {
      _data_k_1094 = 0;
    }
    am22cs_[14] = _data_l_1094[_data_k_1094++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1095 = 0;
    if (_data_k_1095 >= _data_n_1095) {
      _data_k_1095 = 0;
    }
    am22cs_[15] = _data_l_1095[_data_k_1095++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1096 = 0;
    if (_data_k_1096 >= _data_n_1096) {
      _data_k_1096 = 0;
    }
    am22cs_[16] = _data_l_1096[_data_k_1096++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1097 = 0;
    if (_data_k_1097 >= _data_n_1097) {
      _data_k_1097 = 0;
    }
    am22cs_[17] = _data_l_1097[_data_k_1097++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1098 = 0;
    if (_data_k_1098 >= _data_n_1098) {
      _data_k_1098 = 0;
    }
    am22cs_[18] = _data_l_1098[_data_k_1098++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1099 = 0;
    if (_data_k_1099 >= _data_n_1099) {
      _data_k_1099 = 0;
    }
    am22cs_[19] = _data_l_1099[_data_k_1099++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1100 = 0;
    if (_data_k_1100 >= _data_n_1100) {
      _data_k_1100 = 0;
    }
    am22cs_[20] = _data_l_1100[_data_k_1100++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1101 = 0;
    if (_data_k_1101 >= _data_n_1101) {
      _data_k_1101 = 0;
    }
    am22cs_[21] = _data_l_1101[_data_k_1101++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1102 = 0;
    if (_data_k_1102 >= _data_n_1102) {
      _data_k_1102 = 0;
    }
    am22cs_[22] = _data_l_1102[_data_k_1102++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1103 = 0;
    if (_data_k_1103 >= _data_n_1103) {
      _data_k_1103 = 0;
    }
    am22cs_[23] = _data_l_1103[_data_k_1103++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1104 = 0;
    if (_data_k_1104 >= _data_n_1104) {
      _data_k_1104 = 0;
    }
    am22cs_[24] = _data_l_1104[_data_k_1104++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1105 = 0;
    if (_data_k_1105 >= _data_n_1105) {
      _data_k_1105 = 0;
    }
    am22cs_[25] = _data_l_1105[_data_k_1105++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1106 = 0;
    if (_data_k_1106 >= _data_n_1106) {
      _data_k_1106 = 0;
    }
    am22cs_[26] = _data_l_1106[_data_k_1106++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1107 = 0;
    if (_data_k_1107 >= _data_n_1107) {
      _data_k_1107 = 0;
    }
    am22cs_[27] = _data_l_1107[_data_k_1107++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1108 = 0;
    if (_data_k_1108 >= _data_n_1108) {
      _data_k_1108 = 0;
    }
    am22cs_[28] = _data_l_1108[_data_k_1108++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1109 = 0;
    if (_data_k_1109 >= _data_n_1109) {
      _data_k_1109 = 0;
    }
    am22cs_[29] = _data_l_1109[_data_k_1109++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1110 = 0;
    if (_data_k_1110 >= _data_n_1110) {
      _data_k_1110 = 0;
    }
    am22cs_[30] = _data_l_1110[_data_k_1110++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1111 = 0;
    if (_data_k_1111 >= _data_n_1111) {
      _data_k_1111 = 0;
    }
    am22cs_[31] = _data_l_1111[_data_k_1111++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1112 = 0;
    if (_data_k_1112 >= _data_n_1112) {
      _data_k_1112 = 0;
    }
    am22cs_[32] = _data_l_1112[_data_k_1112++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1113 = 0;
    if (_data_k_1113 >= _data_n_1113) {
      _data_k_1113 = 0;
    }
    am22cs_[33] = _data_l_1113[_data_k_1113++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1114 = 0;
    if (_data_k_1114 >= _data_n_1114) {
      _data_k_1114 = 0;
    }
    am22cs_[34] = _data_l_1114[_data_k_1114++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1115 = 0;
    if (_data_k_1115 >= _data_n_1115) {
      _data_k_1115 = 0;
    }
    am22cs_[35] = _data_l_1115[_data_k_1115++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1116 = 0;
    if (_data_k_1116 >= _data_n_1116) {
      _data_k_1116 = 0;
    }
    am22cs_[36] = _data_l_1116[_data_k_1116++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1117 = 0;
    if (_data_k_1117 >= _data_n_1117) {
      _data_k_1117 = 0;
    }
    am22cs_[37] = _data_l_1117[_data_k_1117++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1118 = 0;
    if (_data_k_1118 >= _data_n_1118) {
      _data_k_1118 = 0;
    }
    am22cs_[38] = _data_l_1118[_data_k_1118++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1119 = 0;
    if (_data_k_1119 >= _data_n_1119) {
      _data_k_1119 = 0;
    }
    am22cs_[39] = _data_l_1119[_data_k_1119++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1120 = 0;
    if (_data_k_1120 >= _data_n_1120) {
      _data_k_1120 = 0;
    }
    am22cs_[40] = _data_l_1120[_data_k_1120++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1121 = 0;
    if (_data_k_1121 >= _data_n_1121) {
      _data_k_1121 = 0;
    }
    am22cs_[41] = _data_l_1121[_data_k_1121++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1122 = 0;
    if (_data_k_1122 >= _data_n_1122) {
      _data_k_1122 = 0;
    }
    am22cs_[42] = _data_l_1122[_data_k_1122++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1123 = 0;
    if (_data_k_1123 >= _data_n_1123) {
      _data_k_1123 = 0;
    }
    am22cs_[43] = _data_l_1123[_data_k_1123++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1124 = 0;
    if (_data_k_1124 >= _data_n_1124) {
      _data_k_1124 = 0;
    }
    am22cs_[44] = _data_l_1124[_data_k_1124++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1125 = 0;
    if (_data_k_1125 >= _data_n_1125) {
      _data_k_1125 = 0;
    }
    am22cs_[45] = _data_l_1125[_data_k_1125++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1126 = 0;
    if (_data_k_1126 >= _data_n_1126) {
      _data_k_1126 = 0;
    }
    am22cs_[46] = _data_l_1126[_data_k_1126++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1127 = 0;
    if (_data_k_1127 >= _data_n_1127) {
      _data_k_1127 = 0;
    }
    am22cs_[47] = _data_l_1127[_data_k_1127++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1128 = 0;
    if (_data_k_1128 >= _data_n_1128) {
      _data_k_1128 = 0;
    }
    am22cs_[48] = _data_l_1128[_data_k_1128++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1129 = 0;
    if (_data_k_1129 >= _data_n_1129) {
      _data_k_1129 = 0;
    }
    am22cs_[49] = _data_l_1129[_data_k_1129++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1130 = 0;
    if (_data_k_1130 >= _data_n_1130) {
      _data_k_1130 = 0;
    }
    am22cs_[50] = _data_l_1130[_data_k_1130++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1131 = 0;
    if (_data_k_1131 >= _data_n_1131) {
      _data_k_1131 = 0;
    }
    am22cs_[51] = _data_l_1131[_data_k_1131++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1132 = 0;
    if (_data_k_1132 >= _data_n_1132) {
      _data_k_1132 = 0;
    }
    am22cs_[52] = _data_l_1132[_data_k_1132++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1133 = 0;
    if (_data_k_1133 >= _data_n_1133) {
      _data_k_1133 = 0;
    }
    am22cs_[53] = _data_l_1133[_data_k_1133++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1134 = 0;
    if (_data_k_1134 >= _data_n_1134) {
      _data_k_1134 = 0;
    }
    am22cs_[54] = _data_l_1134[_data_k_1134++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1135 = 0;
    if (_data_k_1135 >= _data_n_1135) {
      _data_k_1135 = 0;
    }
    am22cs_[55] = _data_l_1135[_data_k_1135++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1136 = 0;
    if (_data_k_1136 >= _data_n_1136) {
      _data_k_1136 = 0;
    }
    am22cs_[56] = _data_l_1136[_data_k_1136++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1137 = 0;
    if (_data_k_1137 >= _data_n_1137) {
      _data_k_1137 = 0;
    }
    am22cs_[57] = _data_l_1137[_data_k_1137++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1138 = 0;
    if (_data_k_1138 >= _data_n_1138) {
      _data_k_1138 = 0;
    }
    am22cs_[58] = _data_l_1138[_data_k_1138++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1139 = 0;
    if (_data_k_1139 >= _data_n_1139) {
      _data_k_1139 = 0;
    }
    am22cs_[59] = _data_l_1139[_data_k_1139++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1140 = 0;
    if (_data_k_1140 >= _data_n_1140) {
      _data_k_1140 = 0;
    }
    am22cs_[60] = _data_l_1140[_data_k_1140++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1141 = 0;
    if (_data_k_1141 >= _data_n_1141) {
      _data_k_1141 = 0;
    }
    am22cs_[61] = _data_l_1141[_data_k_1141++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1142 = 0;
    if (_data_k_1142 >= _data_n_1142) {
      _data_k_1142 = 0;
    }
    am22cs_[62] = _data_l_1142[_data_k_1142++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1143 = 0;
    if (_data_k_1143 >= _data_n_1143) {
      _data_k_1143 = 0;
    }
    am22cs_[63] = _data_l_1143[_data_k_1143++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1144 = 0;
    if (_data_k_1144 >= _data_n_1144) {
      _data_k_1144 = 0;
    }
    am22cs_[64] = _data_l_1144[_data_k_1144++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1145 = 0;
    if (_data_k_1145 >= _data_n_1145) {
      _data_k_1145 = 0;
    }
    am22cs_[65] = _data_l_1145[_data_k_1145++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1146 = 0;
    if (_data_k_1146 >= _data_n_1146) {
      _data_k_1146 = 0;
    }
    am22cs_[66] = _data_l_1146[_data_k_1146++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1147 = 0;
    if (_data_k_1147 >= _data_n_1147) {
      _data_k_1147 = 0;
    }
    am22cs_[67] = _data_l_1147[_data_k_1147++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1148 = 0;
    if (_data_k_1148 >= _data_n_1148) {
      _data_k_1148 = 0;
    }
    am22cs_[68] = _data_l_1148[_data_k_1148++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1149 = 0;
    if (_data_k_1149 >= _data_n_1149) {
      _data_k_1149 = 0;
    }
    am22cs_[69] = _data_l_1149[_data_k_1149++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1150 = 0;
    if (_data_k_1150 >= _data_n_1150) {
      _data_k_1150 = 0;
    }
    am22cs_[70] = _data_l_1150[_data_k_1150++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1151 = 0;
    if (_data_k_1151 >= _data_n_1151) {
      _data_k_1151 = 0;
    }
    am22cs_[71] = _data_l_1151[_data_k_1151++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1152 = 0;
    if (_data_k_1152 >= _data_n_1152) {
      _data_k_1152 = 0;
    }
    am22cs_[72] = _data_l_1152[_data_k_1152++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1153 = 0;
    if (_data_k_1153 >= _data_n_1153) {
      _data_k_1153 = 0;
    }
    am22cs_[73] = _data_l_1153[_data_k_1153++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1154 = 0;
    if (_data_k_1154 >= _data_n_1154) {
      _data_k_1154 = 0;
    }
    ath2cs_[0] = _data_l_1154[_data_k_1154++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1155 = 0;
    if (_data_k_1155 >= _data_n_1155) {
      _data_k_1155 = 0;
    }
    ath2cs_[1] = _data_l_1155[_data_k_1155++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1156 = 0;
    if (_data_k_1156 >= _data_n_1156) {
      _data_k_1156 = 0;
    }
    ath2cs_[2] = _data_l_1156[_data_k_1156++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1157 = 0;
    if (_data_k_1157 >= _data_n_1157) {
      _data_k_1157 = 0;
    }
    ath2cs_[3] = _data_l_1157[_data_k_1157++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1158 = 0;
    if (_data_k_1158 >= _data_n_1158) {
      _data_k_1158 = 0;
    }
    ath2cs_[4] = _data_l_1158[_data_k_1158++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1159 = 0;
    if (_data_k_1159 >= _data_n_1159) {
      _data_k_1159 = 0;
    }
    ath2cs_[5] = _data_l_1159[_data_k_1159++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1160 = 0;
    if (_data_k_1160 >= _data_n_1160) {
      _data_k_1160 = 0;
    }
    ath2cs_[6] = _data_l_1160[_data_k_1160++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1161 = 0;
    if (_data_k_1161 >= _data_n_1161) {
      _data_k_1161 = 0;
    }
    ath2cs_[7] = _data_l_1161[_data_k_1161++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1162 = 0;
    if (_data_k_1162 >= _data_n_1162) {
      _data_k_1162 = 0;
    }
    ath2cs_[8] = _data_l_1162[_data_k_1162++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1163 = 0;
    if (_data_k_1163 >= _data_n_1163) {
      _data_k_1163 = 0;
    }
    ath2cs_[9] = _data_l_1163[_data_k_1163++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1164 = 0;
    if (_data_k_1164 >= _data_n_1164) {
      _data_k_1164 = 0;
    }
    ath2cs_[10] = _data_l_1164[_data_k_1164++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1165 = 0;
    if (_data_k_1165 >= _data_n_1165) {
      _data_k_1165 = 0;
    }
    ath2cs_[11] = _data_l_1165[_data_k_1165++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1166 = 0;
    if (_data_k_1166 >= _data_n_1166) {
      _data_k_1166 = 0;
    }
    ath2cs_[12] = _data_l_1166[_data_k_1166++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1167 = 0;
    if (_data_k_1167 >= _data_n_1167) {
      _data_k_1167 = 0;
    }
    ath2cs_[13] = _data_l_1167[_data_k_1167++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1168 = 0;
    if (_data_k_1168 >= _data_n_1168) {
      _data_k_1168 = 0;
    }
    ath2cs_[14] = _data_l_1168[_data_k_1168++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1169 = 0;
    if (_data_k_1169 >= _data_n_1169) {
      _data_k_1169 = 0;
    }
    ath2cs_[15] = _data_l_1169[_data_k_1169++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1170 = 0;
    if (_data_k_1170 >= _data_n_1170) {
      _data_k_1170 = 0;
    }
    ath2cs_[16] = _data_l_1170[_data_k_1170++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1171 = 0;
    if (_data_k_1171 >= _data_n_1171) {
      _data_k_1171 = 0;
    }
    ath2cs_[17] = _data_l_1171[_data_k_1171++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1172 = 0;
    if (_data_k_1172 >= _data_n_1172) {
      _data_k_1172 = 0;
    }
    ath2cs_[18] = _data_l_1172[_data_k_1172++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1173 = 0;
    if (_data_k_1173 >= _data_n_1173) {
      _data_k_1173 = 0;
    }
    ath2cs_[19] = _data_l_1173[_data_k_1173++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1174 = 0;
    if (_data_k_1174 >= _data_n_1174) {
      _data_k_1174 = 0;
    }
    ath2cs_[20] = _data_l_1174[_data_k_1174++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1175 = 0;
    if (_data_k_1175 >= _data_n_1175) {
      _data_k_1175 = 0;
    }
    ath2cs_[21] = _data_l_1175[_data_k_1175++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1176 = 0;
    if (_data_k_1176 >= _data_n_1176) {
      _data_k_1176 = 0;
    }
    ath2cs_[22] = _data_l_1176[_data_k_1176++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1177 = 0;
    if (_data_k_1177 >= _data_n_1177) {
      _data_k_1177 = 0;
    }
    ath2cs_[23] = _data_l_1177[_data_k_1177++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1178 = 0;
    if (_data_k_1178 >= _data_n_1178) {
      _data_k_1178 = 0;
    }
    ath2cs_[24] = _data_l_1178[_data_k_1178++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1179 = 0;
    if (_data_k_1179 >= _data_n_1179) {
      _data_k_1179 = 0;
    }
    ath2cs_[25] = _data_l_1179[_data_k_1179++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1180 = 0;
    if (_data_k_1180 >= _data_n_1180) {
      _data_k_1180 = 0;
    }
    ath2cs_[26] = _data_l_1180[_data_k_1180++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1181 = 0;
    if (_data_k_1181 >= _data_n_1181) {
      _data_k_1181 = 0;
    }
    ath2cs_[27] = _data_l_1181[_data_k_1181++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1182 = 0;
    if (_data_k_1182 >= _data_n_1182) {
      _data_k_1182 = 0;
    }
    ath2cs_[28] = _data_l_1182[_data_k_1182++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1183 = 0;
    if (_data_k_1183 >= _data_n_1183) {
      _data_k_1183 = 0;
    }
    ath2cs_[29] = _data_l_1183[_data_k_1183++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1184 = 0;
    if (_data_k_1184 >= _data_n_1184) {
      _data_k_1184 = 0;
    }
    ath2cs_[30] = _data_l_1184[_data_k_1184++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1185 = 0;
    if (_data_k_1185 >= _data_n_1185) {
      _data_k_1185 = 0;
    }
    ath2cs_[31] = _data_l_1185[_data_k_1185++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1186 = 0;
    if (_data_k_1186 >= _data_n_1186) {
      _data_k_1186 = 0;
    }
    ath2cs_[32] = _data_l_1186[_data_k_1186++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1187 = 0;
    if (_data_k_1187 >= _data_n_1187) {
      _data_k_1187 = 0;
    }
    ath2cs_[33] = _data_l_1187[_data_k_1187++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1188 = 0;
    if (_data_k_1188 >= _data_n_1188) {
      _data_k_1188 = 0;
    }
    ath2cs_[34] = _data_l_1188[_data_k_1188++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1189 = 0;
    if (_data_k_1189 >= _data_n_1189) {
      _data_k_1189 = 0;
    }
    ath2cs_[35] = _data_l_1189[_data_k_1189++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1190 = 0;
    if (_data_k_1190 >= _data_n_1190) {
      _data_k_1190 = 0;
    }
    ath2cs_[36] = _data_l_1190[_data_k_1190++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1191 = 0;
    if (_data_k_1191 >= _data_n_1191) {
      _data_k_1191 = 0;
    }
    ath2cs_[37] = _data_l_1191[_data_k_1191++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1192 = 0;
    if (_data_k_1192 >= _data_n_1192) {
      _data_k_1192 = 0;
    }
    ath2cs_[38] = _data_l_1192[_data_k_1192++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1193 = 0;
    if (_data_k_1193 >= _data_n_1193) {
      _data_k_1193 = 0;
    }
    ath2cs_[39] = _data_l_1193[_data_k_1193++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1194 = 0;
    if (_data_k_1194 >= _data_n_1194) {
      _data_k_1194 = 0;
    }
    ath2cs_[40] = _data_l_1194[_data_k_1194++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1195 = 0;
    if (_data_k_1195 >= _data_n_1195) {
      _data_k_1195 = 0;
    }
    ath2cs_[41] = _data_l_1195[_data_k_1195++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1196 = 0;
    if (_data_k_1196 >= _data_n_1196) {
      _data_k_1196 = 0;
    }
    ath2cs_[42] = _data_l_1196[_data_k_1196++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1197 = 0;
    if (_data_k_1197 >= _data_n_1197) {
      _data_k_1197 = 0;
    }
    ath2cs_[43] = _data_l_1197[_data_k_1197++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1198 = 0;
    if (_data_k_1198 >= _data_n_1198) {
      _data_k_1198 = 0;
    }
    ath2cs_[44] = _data_l_1198[_data_k_1198++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1199 = 0;
    if (_data_k_1199 >= _data_n_1199) {
      _data_k_1199 = 0;
    }
    ath2cs_[45] = _data_l_1199[_data_k_1199++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1200 = 0;
    if (_data_k_1200 >= _data_n_1200) {
      _data_k_1200 = 0;
    }
    ath2cs_[46] = _data_l_1200[_data_k_1200++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1201 = 0;
    if (_data_k_1201 >= _data_n_1201) {
      _data_k_1201 = 0;
    }
    ath2cs_[47] = _data_l_1201[_data_k_1201++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1202 = 0;
    if (_data_k_1202 >= _data_n_1202) {
      _data_k_1202 = 0;
    }
    ath2cs_[48] = _data_l_1202[_data_k_1202++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1203 = 0;
    if (_data_k_1203 >= _data_n_1203) {
      _data_k_1203 = 0;
    }
    ath2cs_[49] = _data_l_1203[_data_k_1203++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1204 = 0;
    if (_data_k_1204 >= _data_n_1204) {
      _data_k_1204 = 0;
    }
    ath2cs_[50] = _data_l_1204[_data_k_1204++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1205 = 0;
    if (_data_k_1205 >= _data_n_1205) {
      _data_k_1205 = 0;
    }
    ath2cs_[51] = _data_l_1205[_data_k_1205++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1206 = 0;
    if (_data_k_1206 >= _data_n_1206) {
      _data_k_1206 = 0;
    }
    ath2cs_[52] = _data_l_1206[_data_k_1206++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1207 = 0;
    if (_data_k_1207 >= _data_n_1207) {
      _data_k_1207 = 0;
    }
    ath2cs_[53] = _data_l_1207[_data_k_1207++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1208 = 0;
    if (_data_k_1208 >= _data_n_1208) {
      _data_k_1208 = 0;
    }
    ath2cs_[54] = _data_l_1208[_data_k_1208++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1209 = 0;
    if (_data_k_1209 >= _data_n_1209) {
      _data_k_1209 = 0;
    }
    ath2cs_[55] = _data_l_1209[_data_k_1209++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1210 = 0;
    if (_data_k_1210 >= _data_n_1210) {
      _data_k_1210 = 0;
    }
    ath2cs_[56] = _data_l_1210[_data_k_1210++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1211 = 0;
    if (_data_k_1211 >= _data_n_1211) {
      _data_k_1211 = 0;
    }
    ath2cs_[57] = _data_l_1211[_data_k_1211++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1212 = 0;
    if (_data_k_1212 >= _data_n_1212) {
      _data_k_1212 = 0;
    }
    ath2cs_[58] = _data_l_1212[_data_k_1212++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1213 = 0;
    if (_data_k_1213 >= _data_n_1213) {
      _data_k_1213 = 0;
    }
    ath2cs_[59] = _data_l_1213[_data_k_1213++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1214 = 0;
    if (_data_k_1214 >= _data_n_1214) {
      _data_k_1214 = 0;
    }
    ath2cs_[60] = _data_l_1214[_data_k_1214++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1215 = 0;
    if (_data_k_1215 >= _data_n_1215) {
      _data_k_1215 = 0;
    }
    ath2cs_[61] = _data_l_1215[_data_k_1215++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1216 = 0;
    if (_data_k_1216 >= _data_n_1216) {
      _data_k_1216 = 0;
    }
    ath2cs_[62] = _data_l_1216[_data_k_1216++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1217 = 0;
    if (_data_k_1217 >= _data_n_1217) {
      _data_k_1217 = 0;
    }
    ath2cs_[63] = _data_l_1217[_data_k_1217++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1218 = 0;
    if (_data_k_1218 >= _data_n_1218) {
      _data_k_1218 = 0;
    }
    ath2cs_[64] = _data_l_1218[_data_k_1218++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1219 = 0;
    if (_data_k_1219 >= _data_n_1219) {
      _data_k_1219 = 0;
    }
    ath2cs_[65] = _data_l_1219[_data_k_1219++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1220 = 0;
    if (_data_k_1220 >= _data_n_1220) {
      _data_k_1220 = 0;
    }
    ath2cs_[66] = _data_l_1220[_data_k_1220++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1221 = 0;
    if (_data_k_1221 >= _data_n_1221) {
      _data_k_1221 = 0;
    }
    ath2cs_[67] = _data_l_1221[_data_k_1221++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1222 = 0;
    if (_data_k_1222 >= _data_n_1222) {
      _data_k_1222 = 0;
    }
    ath2cs_[68] = _data_l_1222[_data_k_1222++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1223 = 0;
    if (_data_k_1223 >= _data_n_1223) {
      _data_k_1223 = 0;
    }
    ath2cs_[69] = _data_l_1223[_data_k_1223++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1224 = 0;
    if (_data_k_1224 >= _data_n_1224) {
      _data_k_1224 = 0;
    }
    ath2cs_[70] = _data_l_1224[_data_k_1224++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1225 = 0;
    if (_data_k_1225 >= _data_n_1225) {
      _data_k_1225 = 0;
    }
    ath2cs_[71] = _data_l_1225[_data_k_1225++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1226 = 0;
    if (_data_k_1226 >= _data_n_1226) {
      _data_k_1226 = 0;
    }
    pi4_ = _data_l_1226[_data_k_1226++];
  }
  if (__calls[95].calls == 0) {
    _data_k_1227 = 0;
    if (_data_k_1227 >= _data_n_1227) {
      _data_k_1227 = 0;
    }
    first_ = _data_l_1227[_data_k_1227++];
  }
  if (first_) {
    eta_ = 0.1 * (real_4) (_d1mach (($0_ = 3, &$0_)));
    nam20_ = _initds (am20cs_, ($1_ = 57, &$1_), &eta_);
    nath0_ = _initds (ath0cs_, ($2_ = 53, &$2_), &eta_);
    nam21_ = _initds (am21cs_, ($3_ = 60, &$3_), &eta_);
    nath1_ = _initds (ath1cs_, ($4_ = 58, &$4_), &eta_);
    nam22_ = _initds (am22cs_, ($5_ = 74, &$5_), &eta_);
    nath2_ = _initds (ath2cs_, ($6_ = 72, &$6_), &eta_);
    xsml_ = -1.0e0 / pow (_d1mach (($7_ = 3, &$7_)), 0.3333e0);
  }
  first_ = FALSE;
  if ((*x_) >= -4.0) {
    goto _l20;
  }
  z_ = 1.0;
  if ((*x_) > xsml_) {
    z_ = 128.0e0 / ((*x_) * (*x_) * (*x_)) + 1.0e0;
  }
  (*ampl_) = 0.3125e0 + _dcsevl (&z_, am20cs_, &nam20_);
  (*theta_) = -0.625e0 + _dcsevl (&z_, ath0cs_, &nath0_);
  goto _l40;
  _l20:;
  if ((*x_) >= -2.0) {
    goto _l30;
  }
  z_ = (128.0e0 / ((*x_) * (*x_) * (*x_)) + 9.0e0) / 7.0e0;
  (*ampl_) = 0.3125e0 + _dcsevl (&z_, am21cs_, &nam21_);
  (*theta_) = -0.625e0 + _dcsevl (&z_, ath1cs_, &nath1_);
  goto _l40;
  _l30:;
  if ((*x_) >= -1.0) {
    (void) _xermsg (_dc_0, _dc_148, _dc_149, &_k1, ($8_ = 2, &$8_));
  }
  z_ = (16.0e0 / ((*x_) * (*x_) * (*x_)) + 9.0e0) / 7.0e0;
  (*ampl_) = 0.3125e0 + _dcsevl (&z_, am22cs_, &nam22_);
  (*theta_) = -0.625e0 + _dcsevl (&z_, ath2cs_, &nath2_);
  _l40:;
  sqrtx_ = sqrt (-(*x_));
  (*ampl_) = sqrt ((*ampl_) / sqrtx_);
  (*theta_) = pi4_ - (*x_) * sqrtx_ * (*theta_);
  __calls[95].calls++;
  return 0;
}

real_8 _d9atn1 (real_8 _p_ x_)
{
  static int_4 ntatn1_;
  static logical_4 first_;
  static real_8 xbig_, xmax_, xsml_, y_, atn1cs_[40], eps_;
  int_4 _data_k_1228, _data_k_1229, _data_k_1230, _data_k_1231, _data_k_1232, _data_k_1233, _data_k_1234, _data_k_1235, 
  _data_k_1236, _data_k_1237, _data_k_1238, _data_k_1239, _data_k_1240, _data_k_1241, _data_k_1242, _data_k_1243, 
  _data_k_1244, _data_k_1245, _data_k_1246, _data_k_1247, _data_k_1248, _data_k_1249, _data_k_1250, _data_k_1251, 
  _data_k_1252, _data_k_1253, _data_k_1254, _data_k_1255, _data_k_1256, _data_k_1257, _data_k_1258, _data_k_1259, 
  _data_k_1260, _data_k_1261, _data_k_1262, _data_k_1263, _data_k_1264, _data_k_1265, _data_k_1266, _data_k_1267, 
  _data_k_1268, $0_, $1_, $4_, $5_;
  real_4 $2_;
  real_8 $3_;
  real_8 d9atn1_;
  extern real_8 _d1mach ();
#define _data_n_1228 1
  static real_8 _data_l_1228[_data_n_1228] = {
    -.328399753535520235690793992299e-1
  };
#define _data_n_1229 1
  static real_8 _data_l_1229[_data_n_1229] = {
    .5833432343172412449951669914907e-1
  };
#define _data_n_1230 1
  static real_8 _data_l_1230[_data_n_1230] = {
    -.7400369696719646463809011551413e-2
  };
#define _data_n_1231 1
  static real_8 _data_l_1231[_data_n_1231] = {
    .1009784199337288083590357511639e-2
  };
#define _data_n_1232 1
  static real_8 _data_l_1232[_data_n_1232] = {
    -.14397871635652056214713036977e-3
  };
#define _data_n_1233 1
  static real_8 _data_l_1233[_data_n_1233] = {
    .2114512648992107572072112243439e-4
  };
#define _data_n_1234 1
  static real_8 _data_l_1234[_data_n_1234] = {
    -.3172321074254667167402564996757e-5
  };
#define _data_n_1235 1
  static real_8 _data_l_1235[_data_n_1235] = {
    .48366203654607108253778593848e-6
  };
#define _data_n_1236 1
  static real_8 _data_l_1236[_data_n_1236] = {
    -.7467746546814112670437614322776e-7
  };
#define _data_n_1237 1
  static real_8 _data_l_1237[_data_n_1237] = {
    .1164800896824429830620998641342e-7
  };
#define _data_n_1238 1
  static real_8 _data_l_1238[_data_n_1238] = {
    -.1832088370847201392699956242452e-8
  };
#define _data_n_1239 1
  static real_8 _data_l_1239[_data_n_1239] = {
    .2901908277966063313175351230455e-9
  };
#define _data_n_1240 1
  static real_8 _data_l_1240[_data_n_1240] = {
    -.4623885312106326738351805721512e-10
  };
#define _data_n_1241 1
  static real_8 _data_l_1241[_data_n_1241] = {
    .7405528668775736917992197048286e-11
  };
#define _data_n_1242 1
  static real_8 _data_l_1242[_data_n_1242] = {
    -.1191354457845136682370820373417e-11
  };
#define _data_n_1243 1
  static real_8 _data_l_1243[_data_n_1243] = {
    .1924090144391772599867855692518e-12
  };
#define _data_n_1244 1
  static real_8 _data_l_1244[_data_n_1244] = {
    -.3118271051076194272254476155327e-13
  };
#define _data_n_1245 1
  static real_8 _data_l_1245[_data_n_1245] = {
    .5069240036567731789694520593032e-14
  };
#define _data_n_1246 1
  static real_8 _data_l_1246[_data_n_1246] = {
    -.8263694719802866053818284405964e-15
  };
#define _data_n_1247 1
  static real_8 _data_l_1247[_data_n_1247] = {
    .1350486709817079420526506123029e-15
  };
#define _data_n_1248 1
  static real_8 _data_l_1248[_data_n_1248] = {
    -.2212023650481746045840137823191e-16
  };
#define _data_n_1249 1
  static real_8 _data_l_1249[_data_n_1249] = {
    .3630654747381356783829047647709e-17
  };
#define _data_n_1250 1
  static real_8 _data_l_1250[_data_n_1250] = {
    -.5970345328847154052451215859165e-18
  };
#define _data_n_1251 1
  static real_8 _data_l_1251[_data_n_1251] = {
    .9834816050077133119448329005738e-19
  };
#define _data_n_1252 1
  static real_8 _data_l_1252[_data_n_1252] = {
    -.162265507585506233614438760448e-19
  };
#define _data_n_1253 1
  static real_8 _data_l_1253[_data_n_1253] = {
    .2681186176945436796301320301226e-20
  };
#define _data_n_1254 1
  static real_8 _data_l_1254[_data_n_1254] = {
    -.4436309706785255479636243688106e-21
  };
#define _data_n_1255 1
  static real_8 _data_l_1255[_data_n_1255] = {
    .73496918976524969450724655104e-22
  };
#define _data_n_1256 1
  static real_8 _data_l_1256[_data_n_1256] = {
    -.1219077508350052588289401378133e-22
  };
#define _data_n_1257 1
  static real_8 _data_l_1257[_data_n_1257] = {
    .2024298836805215403184540876799e-23
  };
#define _data_n_1258 1
  static real_8 _data_l_1258[_data_n_1258] = {
    -.3364871555797354579925576362666e-24
  };
#define _data_n_1259 1
  static real_8 _data_l_1259[_data_n_1259] = {
    .5598673968346988749492933973333e-25
  };
#define _data_n_1260 1
  static real_8 _data_l_1260[_data_n_1260] = {
    -.9323939267272320229628532053333e-26
  };
#define _data_n_1261 1
  static real_8 _data_l_1261[_data_n_1261] = {
    .1554133116995970222934807893333e-26
  };
#define _data_n_1262 1
  static real_8 _data_l_1262[_data_n_1262] = {
    -.2592569534179745922757427199999e-27
  };
#define _data_n_1263 1
  static real_8 _data_l_1263[_data_n_1263] = {
    .4328193466245734685037909333333e-28
  };
#define _data_n_1264 1
  static real_8 _data_l_1264[_data_n_1264] = {
    -.7231013125595437471192405333333e-29
  };
#define _data_n_1265 1
  static real_8 _data_l_1265[_data_n_1265] = {
    .1208902859830494772942165333333e-29
  };
#define _data_n_1266 1
  static real_8 _data_l_1266[_data_n_1266] = {
    -.2022404543449897579315199999999e-30
  };
#define _data_n_1267 1
  static real_8 _data_l_1267[_data_n_1267] = {
    .3385428713046493843073706666666e-31
  };
#define _data_n_1268 1
  static logical_4 _data_l_1268[_data_n_1268] = {
    TRUE
  };
  if (__calls[96].calls == 0) {
    _data_k_1228 = 0;
    if (_data_k_1228 >= _data_n_1228) {
      _data_k_1228 = 0;
    }
    atn1cs_[0] = _data_l_1228[_data_k_1228++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1229 = 0;
    if (_data_k_1229 >= _data_n_1229) {
      _data_k_1229 = 0;
    }
    atn1cs_[1] = _data_l_1229[_data_k_1229++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1230 = 0;
    if (_data_k_1230 >= _data_n_1230) {
      _data_k_1230 = 0;
    }
    atn1cs_[2] = _data_l_1230[_data_k_1230++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1231 = 0;
    if (_data_k_1231 >= _data_n_1231) {
      _data_k_1231 = 0;
    }
    atn1cs_[3] = _data_l_1231[_data_k_1231++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1232 = 0;
    if (_data_k_1232 >= _data_n_1232) {
      _data_k_1232 = 0;
    }
    atn1cs_[4] = _data_l_1232[_data_k_1232++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1233 = 0;
    if (_data_k_1233 >= _data_n_1233) {
      _data_k_1233 = 0;
    }
    atn1cs_[5] = _data_l_1233[_data_k_1233++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1234 = 0;
    if (_data_k_1234 >= _data_n_1234) {
      _data_k_1234 = 0;
    }
    atn1cs_[6] = _data_l_1234[_data_k_1234++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1235 = 0;
    if (_data_k_1235 >= _data_n_1235) {
      _data_k_1235 = 0;
    }
    atn1cs_[7] = _data_l_1235[_data_k_1235++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1236 = 0;
    if (_data_k_1236 >= _data_n_1236) {
      _data_k_1236 = 0;
    }
    atn1cs_[8] = _data_l_1236[_data_k_1236++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1237 = 0;
    if (_data_k_1237 >= _data_n_1237) {
      _data_k_1237 = 0;
    }
    atn1cs_[9] = _data_l_1237[_data_k_1237++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1238 = 0;
    if (_data_k_1238 >= _data_n_1238) {
      _data_k_1238 = 0;
    }
    atn1cs_[10] = _data_l_1238[_data_k_1238++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1239 = 0;
    if (_data_k_1239 >= _data_n_1239) {
      _data_k_1239 = 0;
    }
    atn1cs_[11] = _data_l_1239[_data_k_1239++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1240 = 0;
    if (_data_k_1240 >= _data_n_1240) {
      _data_k_1240 = 0;
    }
    atn1cs_[12] = _data_l_1240[_data_k_1240++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1241 = 0;
    if (_data_k_1241 >= _data_n_1241) {
      _data_k_1241 = 0;
    }
    atn1cs_[13] = _data_l_1241[_data_k_1241++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1242 = 0;
    if (_data_k_1242 >= _data_n_1242) {
      _data_k_1242 = 0;
    }
    atn1cs_[14] = _data_l_1242[_data_k_1242++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1243 = 0;
    if (_data_k_1243 >= _data_n_1243) {
      _data_k_1243 = 0;
    }
    atn1cs_[15] = _data_l_1243[_data_k_1243++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1244 = 0;
    if (_data_k_1244 >= _data_n_1244) {
      _data_k_1244 = 0;
    }
    atn1cs_[16] = _data_l_1244[_data_k_1244++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1245 = 0;
    if (_data_k_1245 >= _data_n_1245) {
      _data_k_1245 = 0;
    }
    atn1cs_[17] = _data_l_1245[_data_k_1245++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1246 = 0;
    if (_data_k_1246 >= _data_n_1246) {
      _data_k_1246 = 0;
    }
    atn1cs_[18] = _data_l_1246[_data_k_1246++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1247 = 0;
    if (_data_k_1247 >= _data_n_1247) {
      _data_k_1247 = 0;
    }
    atn1cs_[19] = _data_l_1247[_data_k_1247++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1248 = 0;
    if (_data_k_1248 >= _data_n_1248) {
      _data_k_1248 = 0;
    }
    atn1cs_[20] = _data_l_1248[_data_k_1248++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1249 = 0;
    if (_data_k_1249 >= _data_n_1249) {
      _data_k_1249 = 0;
    }
    atn1cs_[21] = _data_l_1249[_data_k_1249++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1250 = 0;
    if (_data_k_1250 >= _data_n_1250) {
      _data_k_1250 = 0;
    }
    atn1cs_[22] = _data_l_1250[_data_k_1250++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1251 = 0;
    if (_data_k_1251 >= _data_n_1251) {
      _data_k_1251 = 0;
    }
    atn1cs_[23] = _data_l_1251[_data_k_1251++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1252 = 0;
    if (_data_k_1252 >= _data_n_1252) {
      _data_k_1252 = 0;
    }
    atn1cs_[24] = _data_l_1252[_data_k_1252++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1253 = 0;
    if (_data_k_1253 >= _data_n_1253) {
      _data_k_1253 = 0;
    }
    atn1cs_[25] = _data_l_1253[_data_k_1253++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1254 = 0;
    if (_data_k_1254 >= _data_n_1254) {
      _data_k_1254 = 0;
    }
    atn1cs_[26] = _data_l_1254[_data_k_1254++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1255 = 0;
    if (_data_k_1255 >= _data_n_1255) {
      _data_k_1255 = 0;
    }
    atn1cs_[27] = _data_l_1255[_data_k_1255++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1256 = 0;
    if (_data_k_1256 >= _data_n_1256) {
      _data_k_1256 = 0;
    }
    atn1cs_[28] = _data_l_1256[_data_k_1256++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1257 = 0;
    if (_data_k_1257 >= _data_n_1257) {
      _data_k_1257 = 0;
    }
    atn1cs_[29] = _data_l_1257[_data_k_1257++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1258 = 0;
    if (_data_k_1258 >= _data_n_1258) {
      _data_k_1258 = 0;
    }
    atn1cs_[30] = _data_l_1258[_data_k_1258++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1259 = 0;
    if (_data_k_1259 >= _data_n_1259) {
      _data_k_1259 = 0;
    }
    atn1cs_[31] = _data_l_1259[_data_k_1259++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1260 = 0;
    if (_data_k_1260 >= _data_n_1260) {
      _data_k_1260 = 0;
    }
    atn1cs_[32] = _data_l_1260[_data_k_1260++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1261 = 0;
    if (_data_k_1261 >= _data_n_1261) {
      _data_k_1261 = 0;
    }
    atn1cs_[33] = _data_l_1261[_data_k_1261++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1262 = 0;
    if (_data_k_1262 >= _data_n_1262) {
      _data_k_1262 = 0;
    }
    atn1cs_[34] = _data_l_1262[_data_k_1262++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1263 = 0;
    if (_data_k_1263 >= _data_n_1263) {
      _data_k_1263 = 0;
    }
    atn1cs_[35] = _data_l_1263[_data_k_1263++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1264 = 0;
    if (_data_k_1264 >= _data_n_1264) {
      _data_k_1264 = 0;
    }
    atn1cs_[36] = _data_l_1264[_data_k_1264++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1265 = 0;
    if (_data_k_1265 >= _data_n_1265) {
      _data_k_1265 = 0;
    }
    atn1cs_[37] = _data_l_1265[_data_k_1265++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1266 = 0;
    if (_data_k_1266 >= _data_n_1266) {
      _data_k_1266 = 0;
    }
    atn1cs_[38] = _data_l_1266[_data_k_1266++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1267 = 0;
    if (_data_k_1267 >= _data_n_1267) {
      _data_k_1267 = 0;
    }
    atn1cs_[39] = _data_l_1267[_data_k_1267++];
  }
  if (__calls[96].calls == 0) {
    _data_k_1268 = 0;
    if (_data_k_1268 >= _data_n_1268) {
      _data_k_1268 = 0;
    }
    first_ = _data_l_1268[_data_k_1268++];
  }
  if (first_) {
    eps_ = _d1mach (($0_ = 3, &$0_));
    ntatn1_ = _initds (atn1cs_, ($1_ = 40, &$1_), ($2_ = 0.1 * (real_4) (eps_), &$2_));
    xsml_ = sqrt (0.1e0 * eps_);
    xbig_ = 1.571e0 / sqrt (eps_);
    xmax_ = 1.571e0 / eps_;
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 1.0e0) {
    goto _l20;
  }
  if (y_ <= xsml_) {
    d9atn1_ = -3.3333333333333333e-1;
  }
  if (y_ <= xsml_) {
    goto _l0;
  }
  d9atn1_ = -0.25e0 + _dcsevl (($3_ = 2.0e0 * y_ * y_ - 1.0e0, &$3_), atn1cs_, &ntatn1_);
  goto _l0;
  _l20:;
  if (y_ > xmax_) {
    (void) _xermsg (_dc_0, _dc_150, _dc_151, ($4_ = 2, &$4_), ($5_ = 2, &$5_));
  }
  if (y_ > xbig_) {
    (void) _xermsg (_dc_0, _dc_150, _dc_152, &_k1, &_k1);
  }
  d9atn1_ = (atan ((*x_)) - (*x_)) / ((*x_) * (*x_) * (*x_));
  _l0:;
  __calls[96].calls++;
  return d9atn1_;
}

int_4 _d9b0mp (real_8 _p_ x_, real_8 _p_ ampl_, real_8 _p_ theta_)
{
  static int_4 nbm0_, nbt02_, nbm02_, nbth0_;
  static logical_4 first_;
  static real_4 eta_;
  static real_8 bm0cs_[37], bt02cs_[39], bm02cs_[40], bth0cs_[44], xmax_, pi4_, z_;
  int_4 _data_k_1269, _data_k_1270, _data_k_1271, _data_k_1272, _data_k_1273, _data_k_1274, _data_k_1275, _data_k_1276, 
  _data_k_1277, _data_k_1278, _data_k_1279, _data_k_1280, _data_k_1281, _data_k_1282, _data_k_1283, _data_k_1284, 
  _data_k_1285, _data_k_1286, _data_k_1287, _data_k_1288, _data_k_1289, _data_k_1290, _data_k_1291, _data_k_1292, 
  _data_k_1293, _data_k_1294, _data_k_1295, _data_k_1296, _data_k_1297, _data_k_1298, _data_k_1299, _data_k_1300, 
  _data_k_1301, _data_k_1302, _data_k_1303, _data_k_1304, _data_k_1305, _data_k_1306, _data_k_1307, _data_k_1308, 
  _data_k_1309, _data_k_1310, _data_k_1311, _data_k_1312, _data_k_1313, _data_k_1314, _data_k_1315, _data_k_1316, 
  _data_k_1317, _data_k_1318, _data_k_1319, _data_k_1320, _data_k_1321, _data_k_1322, _data_k_1323, _data_k_1324, 
  _data_k_1325, _data_k_1326, _data_k_1327, _data_k_1328, _data_k_1329, _data_k_1330, _data_k_1331, _data_k_1332, 
  _data_k_1333, _data_k_1334, _data_k_1335, _data_k_1336, _data_k_1337, _data_k_1338, _data_k_1339, _data_k_1340, 
  _data_k_1341, _data_k_1342, _data_k_1343, _data_k_1344, _data_k_1345, _data_k_1346, _data_k_1347, _data_k_1348, 
  _data_k_1349, _data_k_1350, _data_k_1351, _data_k_1352, _data_k_1353, _data_k_1354, _data_k_1355, _data_k_1356, 
  _data_k_1357, _data_k_1358, _data_k_1359, _data_k_1360, _data_k_1361, _data_k_1362, _data_k_1363, _data_k_1364, 
  _data_k_1365, _data_k_1366, _data_k_1367, _data_k_1368, _data_k_1369, _data_k_1370, _data_k_1371, _data_k_1372, 
  _data_k_1373, _data_k_1374, _data_k_1375, _data_k_1376, _data_k_1377, _data_k_1378, _data_k_1379, _data_k_1380, 
  _data_k_1381, _data_k_1382, _data_k_1383, _data_k_1384, _data_k_1385, _data_k_1386, _data_k_1387, _data_k_1388, 
  _data_k_1389, _data_k_1390, _data_k_1391, _data_k_1392, _data_k_1393, _data_k_1394, _data_k_1395, _data_k_1396, 
  _data_k_1397, _data_k_1398, _data_k_1399, _data_k_1400, _data_k_1401, _data_k_1402, _data_k_1403, _data_k_1404, 
  _data_k_1405, _data_k_1406, _data_k_1407, _data_k_1408, _data_k_1409, _data_k_1410, _data_k_1411, _data_k_1412, 
  _data_k_1413, _data_k_1414, _data_k_1415, _data_k_1416, _data_k_1417, _data_k_1418, _data_k_1419, _data_k_1420, 
  _data_k_1421, _data_k_1422, _data_k_1423, _data_k_1424, _data_k_1425, _data_k_1426, _data_k_1427, _data_k_1428, 
  _data_k_1429, _data_k_1430, $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern real_8 _d1mach ();
#define _data_n_1269 1
  static real_8 _data_l_1269[_data_n_1269] = {
    .9211656246827742712573767730182e-1
  };
#define _data_n_1270 1
  static real_8 _data_l_1270[_data_n_1270] = {
    -.1050590997271905102480716371755e-2
  };
#define _data_n_1271 1
  static real_8 _data_l_1271[_data_n_1271] = {
    .1470159840768759754056392850952e-4
  };
#define _data_n_1272 1
  static real_8 _data_l_1272[_data_n_1272] = {
    -.5058557606038554223347929327702e-6
  };
#define _data_n_1273 1
  static real_8 _data_l_1273[_data_n_1273] = {
    .2787254538632444176630356137881e-7
  };
#define _data_n_1274 1
  static real_8 _data_l_1274[_data_n_1274] = {
    -.2062363611780914802618841018973e-8
  };
#define _data_n_1275 1
  static real_8 _data_l_1275[_data_n_1275] = {
    .1870214313138879675138172596261e-9
  };
#define _data_n_1276 1
  static real_8 _data_l_1276[_data_n_1276] = {
    -.1969330971135636200241730777825e-10
  };
#define _data_n_1277 1
  static real_8 _data_l_1277[_data_n_1277] = {
    .2325973793999275444012508818052e-11
  };
#define _data_n_1278 1
  static real_8 _data_l_1278[_data_n_1278] = {
    -.3009520344938250272851224734482e-12
  };
#define _data_n_1279 1
  static real_8 _data_l_1279[_data_n_1279] = {
    .4194521333850669181471206768646e-13
  };
#define _data_n_1280 1
  static real_8 _data_l_1280[_data_n_1280] = {
    -.6219449312188445825973267429564e-14
  };
#define _data_n_1281 1
  static real_8 _data_l_1281[_data_n_1281] = {
    .9718260411336068469601765885269e-15
  };
#define _data_n_1282 1
  static real_8 _data_l_1282[_data_n_1282] = {
    -.1588478585701075207366635966937e-15
  };
#define _data_n_1283 1
  static real_8 _data_l_1283[_data_n_1283] = {
    .2700072193671308890086217324458e-16
  };
#define _data_n_1284 1
  static real_8 _data_l_1284[_data_n_1284] = {
    -.4750092365234008992477504786773e-17
  };
#define _data_n_1285 1
  static real_8 _data_l_1285[_data_n_1285] = {
    .861512816260437087319170374656e-18
  };
#define _data_n_1286 1
  static real_8 _data_l_1286[_data_n_1286] = {
    -.1605608686956144815745602703359e-18
  };
#define _data_n_1287 1
  static real_8 _data_l_1287[_data_n_1287] = {
    .3066513987314482975188539801599e-19
  };
#define _data_n_1288 1
  static real_8 _data_l_1288[_data_n_1288] = {
    -.5987764223193956430696505617066e-20
  };
#define _data_n_1289 1
  static real_8 _data_l_1289[_data_n_1289] = {
    .1192971253748248306489069841066e-20
  };
#define _data_n_1290 1
  static real_8 _data_l_1290[_data_n_1290] = {
    -.2420969142044805489484682581333e-21
  };
#define _data_n_1291 1
  static real_8 _data_l_1291[_data_n_1291] = {
    .4996751760510616453371002879999e-22
  };
#define _data_n_1292 1
  static real_8 _data_l_1292[_data_n_1292] = {
    -.1047493639351158510095040511999e-22
  };
#define _data_n_1293 1
  static real_8 _data_l_1293[_data_n_1293] = {
    .2227786843797468101048183466666e-23
  };
#define _data_n_1294 1
  static real_8 _data_l_1294[_data_n_1294] = {
    -.4801813239398162862370542933333e-24
  };
#define _data_n_1295 1
  static real_8 _data_l_1295[_data_n_1295] = {
    .1047962723470959956476996266666e-24
  };
#define _data_n_1296 1
  static real_8 _data_l_1296[_data_n_1296] = {
    -.23138581656786153251012608e-25
  };
#define _data_n_1297 1
  static real_8 _data_l_1297[_data_n_1297] = {
    .5164823088462674211635199999999e-26
  };
#define _data_n_1298 1
  static real_8 _data_l_1298[_data_n_1298] = {
    -.1164691191850065389525401599999e-26
  };
#define _data_n_1299 1
  static real_8 _data_l_1299[_data_n_1299] = {
    .2651788486043319282958336e-27
  };
#define _data_n_1300 1
  static real_8 _data_l_1300[_data_n_1300] = {
    -.6092559503825728497691306666666e-28
  };
#define _data_n_1301 1
  static real_8 _data_l_1301[_data_n_1301] = {
    .1411804686144259308038826666666e-28
  };
#define _data_n_1302 1
  static real_8 _data_l_1302[_data_n_1302] = {
    -.3298094961231737245750613333333e-29
  };
#define _data_n_1303 1
  static real_8 _data_l_1303[_data_n_1303] = {
    .7763931143074065031714133333333e-30
  };
#define _data_n_1304 1
  static real_8 _data_l_1304[_data_n_1304] = {
    -.1841031343661458478421333333333e-30
  };
#define _data_n_1305 1
  static real_8 _data_l_1305[_data_n_1305] = {
    .4395880138594310737100799999999e-31
  };
#define _data_n_1306 1
  static real_8 _data_l_1306[_data_n_1306] = {
    -.24901780862128936717709793789967e+0
  };
#define _data_n_1307 1
  static real_8 _data_l_1307[_data_n_1307] = {
    .48550299609623749241048615535485e-3
  };
#define _data_n_1308 1
  static real_8 _data_l_1308[_data_n_1308] = {
    -.54511837345017204950656273563505e-5
  };
#define _data_n_1309 1
  static real_8 _data_l_1309[_data_n_1309] = {
    .13558673059405964054377445929903e-6
  };
#define _data_n_1310 1
  static real_8 _data_l_1310[_data_n_1310] = {
    -.5569139890222762622758321841492e-8
  };
#define _data_n_1311 1
  static real_8 _data_l_1311[_data_n_1311] = {
    .32609031824994335304004205719468e-9
  };
#define _data_n_1312 1
  static real_8 _data_l_1312[_data_n_1312] = {
    -.24918807862461341125237903877993e-10
  };
#define _data_n_1313 1
  static real_8 _data_l_1313[_data_n_1313] = {
    .23449377420882520554352413564891e-11
  };
#define _data_n_1314 1
  static real_8 _data_l_1314[_data_n_1314] = {
    -.26096534444310387762177574766136e-12
  };
#define _data_n_1315 1
  static real_8 _data_l_1315[_data_n_1315] = {
    .33353140420097395105869955014923e-13
  };
#define _data_n_1316 1
  static real_8 _data_l_1316[_data_n_1316] = {
    -.47890000440572684646750770557409e-14
  };
#define _data_n_1317 1
  static real_8 _data_l_1317[_data_n_1317] = {
    .75956178436192215972642568545248e-15
  };
#define _data_n_1318 1
  static real_8 _data_l_1318[_data_n_1318] = {
    -.13131556016891440382773397487633e-15
  };
#define _data_n_1319 1
  static real_8 _data_l_1319[_data_n_1319] = {
    .24483618345240857495426820738355e-16
  };
#define _data_n_1320 1
  static real_8 _data_l_1320[_data_n_1320] = {
    -.48805729810618777683256761918331e-17
  };
#define _data_n_1321 1
  static real_8 _data_l_1321[_data_n_1321] = {
    .10327285029786316149223756361204e-17
  };
#define _data_n_1322 1
  static real_8 _data_l_1322[_data_n_1322] = {
    -.23057633815057217157004744527025e-18
  };
#define _data_n_1323 1
  static real_8 _data_l_1323[_data_n_1323] = {
    .54044443001892693993017108483765e-19
  };
#define _data_n_1324 1
  static real_8 _data_l_1324[_data_n_1324] = {
    -.13240695194366572724155032882385e-19
  };
#define _data_n_1325 1
  static real_8 _data_l_1325[_data_n_1325] = {
    .33780795621371970203424792124722e-20
  };
#define _data_n_1326 1
  static real_8 _data_l_1326[_data_n_1326] = {
    -.89457629157111779003026926292299e-21
  };
#define _data_n_1327 1
  static real_8 _data_l_1327[_data_n_1327] = {
    .24519906889219317090899908651405e-21
  };
#define _data_n_1328 1
  static real_8 _data_l_1328[_data_n_1328] = {
    -.69388422876866318680139933157657e-22
  };
#define _data_n_1329 1
  static real_8 _data_l_1329[_data_n_1329] = {
    .20228278714890138392946303337791e-22
  };
#define _data_n_1330 1
  static real_8 _data_l_1330[_data_n_1330] = {
    -.60628500002335483105794195371764e-23
  };
#define _data_n_1331 1
  static real_8 _data_l_1331[_data_n_1331] = {
    .1864974896403763538182378839627e-23
  };
#define _data_n_1332 1
  static real_8 _data_l_1332[_data_n_1332] = {
    -.58783732384849894560245036530867e-24
  };
#define _data_n_1333 1
  static real_8 _data_l_1333[_data_n_1333] = {
    .18958591447999563485531179503513e-24
  };
#define _data_n_1334 1
  static real_8 _data_l_1334[_data_n_1334] = {
    -.62481979372258858959291620728565e-25
  };
#define _data_n_1335 1
  static real_8 _data_l_1335[_data_n_1335] = {
    .21017901684551024686638633529074e-25
  };
#define _data_n_1336 1
  static real_8 _data_l_1336[_data_n_1336] = {
    -.72084300935209253690813933992446e-26
  };
#define _data_n_1337 1
  static real_8 _data_l_1337[_data_n_1337] = {
    .25181363892474240867156405976746e-26
  };
#define _data_n_1338 1
  static real_8 _data_l_1338[_data_n_1338] = {
    -.89518042258785778806143945953643e-27
  };
#define _data_n_1339 1
  static real_8 _data_l_1339[_data_n_1339] = {
    .32357237479762298533256235868587e-27
  };
#define _data_n_1340 1
  static real_8 _data_l_1340[_data_n_1340] = {
    -.11883010519855353657047144113796e-27
  };
#define _data_n_1341 1
  static real_8 _data_l_1341[_data_n_1341] = {
    .44306286907358104820579231941731e-28
  };
#define _data_n_1342 1
  static real_8 _data_l_1342[_data_n_1342] = {
    -.16761009648834829495792010135681e-28
  };
#define _data_n_1343 1
  static real_8 _data_l_1343[_data_n_1343] = {
    .64292946921207466972532393966088e-29
  };
#define _data_n_1344 1
  static real_8 _data_l_1344[_data_n_1344] = {
    -.24992261166978652421207213682763e-29
  };
#define _data_n_1345 1
  static real_8 _data_l_1345[_data_n_1345] = {
    .98399794299521955672828260355318e-30
  };
#define _data_n_1346 1
  static real_8 _data_l_1346[_data_n_1346] = {
    -.39220375242408016397989131626158e-30
  };
#define _data_n_1347 1
  static real_8 _data_l_1347[_data_n_1347] = {
    .15818107030056522138590618845692e-30
  };
#define _data_n_1348 1
  static real_8 _data_l_1348[_data_n_1348] = {
    -.64525506144890715944344098365426e-31
  };
#define _data_n_1349 1
  static real_8 _data_l_1349[_data_n_1349] = {
    .26611111369199356137177018346367e-31
  };
#define _data_n_1350 1
  static real_8 _data_l_1350[_data_n_1350] = {
    .950041514522838136933086133556e-1
  };
#define _data_n_1351 1
  static real_8 _data_l_1351[_data_n_1351] = {
    -.3801864682365670991748081566851e-3
  };
#define _data_n_1352 1
  static real_8 _data_l_1352[_data_n_1352] = {
    .2258339301031481192951829927224e-5
  };
#define _data_n_1353 1
  static real_8 _data_l_1353[_data_n_1353] = {
    -.3895725802372228764730621412605e-7
  };
#define _data_n_1354 1
  static real_8 _data_l_1354[_data_n_1354] = {
    .1246886416512081697930990529725e-8
  };
#define _data_n_1355 1
  static real_8 _data_l_1355[_data_n_1355] = {
    -.6065949022102503779803835058387e-10
  };
#define _data_n_1356 1
  static real_8 _data_l_1356[_data_n_1356] = {
    .4008461651421746991015275971045e-11
  };
#define _data_n_1357 1
  static real_8 _data_l_1357[_data_n_1357] = {
    -.3350998183398094218467298794574e-12
  };
#define _data_n_1358 1
  static real_8 _data_l_1358[_data_n_1358] = {
    .3377119716517417367063264341996e-13
  };
#define _data_n_1359 1
  static real_8 _data_l_1359[_data_n_1359] = {
    -.3964585901635012700569356295823e-14
  };
#define _data_n_1360 1
  static real_8 _data_l_1360[_data_n_1360] = {
    .5286111503883857217387939744735e-15
  };
#define _data_n_1361 1
  static real_8 _data_l_1361[_data_n_1361] = {
    -.7852519083450852313654640243493e-16
  };
#define _data_n_1362 1
  static real_8 _data_l_1362[_data_n_1362] = {
    .1280300573386682201011634073449e-16
  };
#define _data_n_1363 1
  static real_8 _data_l_1363[_data_n_1363] = {
    -.2263996296391429776287099244884e-17
  };
#define _data_n_1364 1
  static real_8 _data_l_1364[_data_n_1364] = {
    .4300496929656790388646410290477e-18
  };
#define _data_n_1365 1
  static real_8 _data_l_1365[_data_n_1365] = {
    -.8705749805132587079747535451455e-19
  };
#define _data_n_1366 1
  static real_8 _data_l_1366[_data_n_1366] = {
    .186586271396209514118144277205e-19
  };
#define _data_n_1367 1
  static real_8 _data_l_1367[_data_n_1367] = {
    -.4210482486093065457345086972301e-20
  };
#define _data_n_1368 1
  static real_8 _data_l_1368[_data_n_1368] = {
    .9956676964228400991581627417842e-21
  };
#define _data_n_1369 1
  static real_8 _data_l_1369[_data_n_1369] = {
    -.2457357442805313359605921478547e-21
  };
#define _data_n_1370 1
  static real_8 _data_l_1370[_data_n_1370] = {
    .6307692160762031568087353707059e-22
  };
#define _data_n_1371 1
  static real_8 _data_l_1371[_data_n_1371] = {
    -.1678773691440740142693331172388e-22
  };
#define _data_n_1372 1
  static real_8 _data_l_1372[_data_n_1372] = {
    .4620259064673904433770878136087e-23
  };
#define _data_n_1373 1
  static real_8 _data_l_1373[_data_n_1373] = {
    -.1311782266860308732237693402496e-23
  };
#define _data_n_1374 1
  static real_8 _data_l_1374[_data_n_1374] = {
    .3834087564116302827747922440276e-24
  };
#define _data_n_1375 1
  static real_8 _data_l_1375[_data_n_1375] = {
    -.1151459324077741271072613293576e-24
  };
#define _data_n_1376 1
  static real_8 _data_l_1376[_data_n_1376] = {
    .3547210007523338523076971345213e-25
  };
#define _data_n_1377 1
  static real_8 _data_l_1377[_data_n_1377] = {
    -.1119218385815004646264355942176e-25
  };
#define _data_n_1378 1
  static real_8 _data_l_1378[_data_n_1378] = {
    .3611879427629837831698404994257e-26
  };
#define _data_n_1379 1
  static real_8 _data_l_1379[_data_n_1379] = {
    -.1190687765913333150092641762463e-26
  };
#define _data_n_1380 1
  static real_8 _data_l_1380[_data_n_1380] = {
    .4005094059403968131802476449536e-27
  };
#define _data_n_1381 1
  static real_8 _data_l_1381[_data_n_1381] = {
    -.1373169422452212390595193916017e-27
  };
#define _data_n_1382 1
  static real_8 _data_l_1382[_data_n_1382] = {
    .4794199088742531585996491526437e-28
  };
#define _data_n_1383 1
  static real_8 _data_l_1383[_data_n_1383] = {
    -.1702965627624109584006994476452e-28
  };
#define _data_n_1384 1
  static real_8 _data_l_1384[_data_n_1384] = {
    .6149512428936330071503575161324e-29
  };
#define _data_n_1385 1
  static real_8 _data_l_1385[_data_n_1385] = {
    -.2255766896581828349944300237242e-29
  };
#define _data_n_1386 1
  static real_8 _data_l_1386[_data_n_1386] = {
    .83997075092942994860616583532e-30
  };
#define _data_n_1387 1
  static real_8 _data_l_1387[_data_n_1387] = {
    -.3172997595562602355567423936152e-30
  };
#define _data_n_1388 1
  static real_8 _data_l_1388[_data_n_1388] = {
    .1215205298881298554583333026514e-30
  };
#define _data_n_1389 1
  static real_8 _data_l_1389[_data_n_1389] = {
    -.4715852749754438693013210568045e-31
  };
#define _data_n_1390 1
  static real_8 _data_l_1390[_data_n_1390] = {
    -.24548295213424597462050467249324e+0
  };
#define _data_n_1391 1
  static real_8 _data_l_1391[_data_n_1391] = {
    .12544121039084615780785331778299e-2
  };
#define _data_n_1392 1
  static real_8 _data_l_1392[_data_n_1392] = {
    -.31253950414871522854973446709571e-4
  };
#define _data_n_1393 1
  static real_8 _data_l_1393[_data_n_1393] = {
    .14709778249940831164453426969314e-5
  };
#define _data_n_1394 1
  static real_8 _data_l_1394[_data_n_1394] = {
    -.99543488937950033643468850351158e-7
  };
#define _data_n_1395 1
  static real_8 _data_l_1395[_data_n_1395] = {
    .85493166733203041247578711397751e-8
  };
#define _data_n_1396 1
  static real_8 _data_l_1396[_data_n_1396] = {
    -.86989759526554334557985512179192e-9
  };
#define _data_n_1397 1
  static real_8 _data_l_1397[_data_n_1397] = {
    .10052099533559791084540101082153e-9
  };
#define _data_n_1398 1
  static real_8 _data_l_1398[_data_n_1398] = {
    -.12828230601708892903483623685544e-10
  };
#define _data_n_1399 1
  static real_8 _data_l_1399[_data_n_1399] = {
    .17731700781805131705655750451023e-11
  };
#define _data_n_1400 1
  static real_8 _data_l_1400[_data_n_1400] = {
    -.26174574569485577488636284180925e-12
  };
#define _data_n_1401 1
  static real_8 _data_l_1401[_data_n_1401] = {
    .40828351389972059621966481221103e-13
  };
#define _data_n_1402 1
  static real_8 _data_l_1402[_data_n_1402] = {
    -.66751668239742720054606749554261e-14
  };
#define _data_n_1403 1
  static real_8 _data_l_1403[_data_n_1403] = {
    .11365761393071629448392469549951e-14
  };
#define _data_n_1404 1
  static real_8 _data_l_1404[_data_n_1404] = {
    -.20051189620647160250559266412117e-15
  };
#define _data_n_1405 1
  static real_8 _data_l_1405[_data_n_1405] = {
    .36497978794766269635720591464106e-16
  };
#define _data_n_1406 1
  static real_8 _data_l_1406[_data_n_1406] = {
    -.683096375645823031693558437888e-17
  };
#define _data_n_1407 1
  static real_8 _data_l_1407[_data_n_1407] = {
    .13107583145670756620057104267946e-17
  };
#define _data_n_1408 1
  static real_8 _data_l_1408[_data_n_1408] = {
    -.25723363101850607778757130649599e-18
  };
#define _data_n_1409 1
  static real_8 _data_l_1409[_data_n_1409] = {
    .51521657441863959925267780949333e-19
  };
#define _data_n_1410 1
  static real_8 _data_l_1410[_data_n_1410] = {
    -.10513017563758802637940741461333e-19
  };
#define _data_n_1411 1
  static real_8 _data_l_1411[_data_n_1411] = {
    .21820381991194813847301084501333e-20
  };
#define _data_n_1412 1
  static real_8 _data_l_1412[_data_n_1412] = {
    -.46004701210362160577225905493333e-21
  };
#define _data_n_1413 1
  static real_8 _data_l_1413[_data_n_1413] = {
    .98407006925466818520953651199999e-22
  };
#define _data_n_1414 1
  static real_8 _data_l_1414[_data_n_1414] = {
    -.21334038035728375844735986346666e-22
  };
#define _data_n_1415 1
  static real_8 _data_l_1415[_data_n_1415] = {
    .46831036423973365296066286933333e-23
  };
#define _data_n_1416 1
  static real_8 _data_l_1416[_data_n_1416] = {
    -.10400213691985747236513382399999e-23
  };
#define _data_n_1417 1
  static real_8 _data_l_1417[_data_n_1417] = {
    .233491056773015100517777408e-24
  };
#define _data_n_1418 1
  static real_8 _data_l_1418[_data_n_1418] = {
    -.52956825323318615788049749333333e-25
  };
#define _data_n_1419 1
  static real_8 _data_l_1419[_data_n_1419] = {
    .12126341952959756829196287999999e-25
  };
#define _data_n_1420 1
  static real_8 _data_l_1420[_data_n_1420] = {
    -.28018897082289428760275626666666e-26
  };
#define _data_n_1421 1
  static real_8 _data_l_1421[_data_n_1421] = {
    .65292678987012873342593706666666e-27
  };
#define _data_n_1422 1
  static real_8 _data_l_1422[_data_n_1422] = {
    -.15337980061873346427835733333333e-27
  };
#define _data_n_1423 1
  static real_8 _data_l_1423[_data_n_1423] = {
    .36305884306364536682359466666666e-28
  };
#define _data_n_1424 1
  static real_8 _data_l_1424[_data_n_1424] = {
    -.86560755713629122479172266666666e-29
  };
#define _data_n_1425 1
  static real_8 _data_l_1425[_data_n_1425] = {
    .20779909972536284571238399999999e-29
  };
#define _data_n_1426 1
  static real_8 _data_l_1426[_data_n_1426] = {
    -.50211170221417221674325333333333e-30
  };
#define _data_n_1427 1
  static real_8 _data_l_1427[_data_n_1427] = {
    .12208360279441714184191999999999e-30
  };
#define _data_n_1428 1
  static real_8 _data_l_1428[_data_n_1428] = {
    -.29860056267039913454250666666666e-31
  };
#define _data_n_1429 1
  static real_8 _data_l_1429[_data_n_1429] = {
    0.785398163397448309615660845819876e0
  };
#define _data_n_1430 1
  static logical_4 _data_l_1430[_data_n_1430] = {
    TRUE
  };
  if (__calls[97].calls == 0) {
    _data_k_1269 = 0;
    if (_data_k_1269 >= _data_n_1269) {
      _data_k_1269 = 0;
    }
    bm0cs_[0] = _data_l_1269[_data_k_1269++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1270 = 0;
    if (_data_k_1270 >= _data_n_1270) {
      _data_k_1270 = 0;
    }
    bm0cs_[1] = _data_l_1270[_data_k_1270++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1271 = 0;
    if (_data_k_1271 >= _data_n_1271) {
      _data_k_1271 = 0;
    }
    bm0cs_[2] = _data_l_1271[_data_k_1271++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1272 = 0;
    if (_data_k_1272 >= _data_n_1272) {
      _data_k_1272 = 0;
    }
    bm0cs_[3] = _data_l_1272[_data_k_1272++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1273 = 0;
    if (_data_k_1273 >= _data_n_1273) {
      _data_k_1273 = 0;
    }
    bm0cs_[4] = _data_l_1273[_data_k_1273++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1274 = 0;
    if (_data_k_1274 >= _data_n_1274) {
      _data_k_1274 = 0;
    }
    bm0cs_[5] = _data_l_1274[_data_k_1274++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1275 = 0;
    if (_data_k_1275 >= _data_n_1275) {
      _data_k_1275 = 0;
    }
    bm0cs_[6] = _data_l_1275[_data_k_1275++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1276 = 0;
    if (_data_k_1276 >= _data_n_1276) {
      _data_k_1276 = 0;
    }
    bm0cs_[7] = _data_l_1276[_data_k_1276++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1277 = 0;
    if (_data_k_1277 >= _data_n_1277) {
      _data_k_1277 = 0;
    }
    bm0cs_[8] = _data_l_1277[_data_k_1277++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1278 = 0;
    if (_data_k_1278 >= _data_n_1278) {
      _data_k_1278 = 0;
    }
    bm0cs_[9] = _data_l_1278[_data_k_1278++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1279 = 0;
    if (_data_k_1279 >= _data_n_1279) {
      _data_k_1279 = 0;
    }
    bm0cs_[10] = _data_l_1279[_data_k_1279++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1280 = 0;
    if (_data_k_1280 >= _data_n_1280) {
      _data_k_1280 = 0;
    }
    bm0cs_[11] = _data_l_1280[_data_k_1280++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1281 = 0;
    if (_data_k_1281 >= _data_n_1281) {
      _data_k_1281 = 0;
    }
    bm0cs_[12] = _data_l_1281[_data_k_1281++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1282 = 0;
    if (_data_k_1282 >= _data_n_1282) {
      _data_k_1282 = 0;
    }
    bm0cs_[13] = _data_l_1282[_data_k_1282++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1283 = 0;
    if (_data_k_1283 >= _data_n_1283) {
      _data_k_1283 = 0;
    }
    bm0cs_[14] = _data_l_1283[_data_k_1283++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1284 = 0;
    if (_data_k_1284 >= _data_n_1284) {
      _data_k_1284 = 0;
    }
    bm0cs_[15] = _data_l_1284[_data_k_1284++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1285 = 0;
    if (_data_k_1285 >= _data_n_1285) {
      _data_k_1285 = 0;
    }
    bm0cs_[16] = _data_l_1285[_data_k_1285++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1286 = 0;
    if (_data_k_1286 >= _data_n_1286) {
      _data_k_1286 = 0;
    }
    bm0cs_[17] = _data_l_1286[_data_k_1286++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1287 = 0;
    if (_data_k_1287 >= _data_n_1287) {
      _data_k_1287 = 0;
    }
    bm0cs_[18] = _data_l_1287[_data_k_1287++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1288 = 0;
    if (_data_k_1288 >= _data_n_1288) {
      _data_k_1288 = 0;
    }
    bm0cs_[19] = _data_l_1288[_data_k_1288++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1289 = 0;
    if (_data_k_1289 >= _data_n_1289) {
      _data_k_1289 = 0;
    }
    bm0cs_[20] = _data_l_1289[_data_k_1289++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1290 = 0;
    if (_data_k_1290 >= _data_n_1290) {
      _data_k_1290 = 0;
    }
    bm0cs_[21] = _data_l_1290[_data_k_1290++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1291 = 0;
    if (_data_k_1291 >= _data_n_1291) {
      _data_k_1291 = 0;
    }
    bm0cs_[22] = _data_l_1291[_data_k_1291++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1292 = 0;
    if (_data_k_1292 >= _data_n_1292) {
      _data_k_1292 = 0;
    }
    bm0cs_[23] = _data_l_1292[_data_k_1292++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1293 = 0;
    if (_data_k_1293 >= _data_n_1293) {
      _data_k_1293 = 0;
    }
    bm0cs_[24] = _data_l_1293[_data_k_1293++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1294 = 0;
    if (_data_k_1294 >= _data_n_1294) {
      _data_k_1294 = 0;
    }
    bm0cs_[25] = _data_l_1294[_data_k_1294++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1295 = 0;
    if (_data_k_1295 >= _data_n_1295) {
      _data_k_1295 = 0;
    }
    bm0cs_[26] = _data_l_1295[_data_k_1295++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1296 = 0;
    if (_data_k_1296 >= _data_n_1296) {
      _data_k_1296 = 0;
    }
    bm0cs_[27] = _data_l_1296[_data_k_1296++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1297 = 0;
    if (_data_k_1297 >= _data_n_1297) {
      _data_k_1297 = 0;
    }
    bm0cs_[28] = _data_l_1297[_data_k_1297++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1298 = 0;
    if (_data_k_1298 >= _data_n_1298) {
      _data_k_1298 = 0;
    }
    bm0cs_[29] = _data_l_1298[_data_k_1298++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1299 = 0;
    if (_data_k_1299 >= _data_n_1299) {
      _data_k_1299 = 0;
    }
    bm0cs_[30] = _data_l_1299[_data_k_1299++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1300 = 0;
    if (_data_k_1300 >= _data_n_1300) {
      _data_k_1300 = 0;
    }
    bm0cs_[31] = _data_l_1300[_data_k_1300++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1301 = 0;
    if (_data_k_1301 >= _data_n_1301) {
      _data_k_1301 = 0;
    }
    bm0cs_[32] = _data_l_1301[_data_k_1301++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1302 = 0;
    if (_data_k_1302 >= _data_n_1302) {
      _data_k_1302 = 0;
    }
    bm0cs_[33] = _data_l_1302[_data_k_1302++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1303 = 0;
    if (_data_k_1303 >= _data_n_1303) {
      _data_k_1303 = 0;
    }
    bm0cs_[34] = _data_l_1303[_data_k_1303++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1304 = 0;
    if (_data_k_1304 >= _data_n_1304) {
      _data_k_1304 = 0;
    }
    bm0cs_[35] = _data_l_1304[_data_k_1304++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1305 = 0;
    if (_data_k_1305 >= _data_n_1305) {
      _data_k_1305 = 0;
    }
    bm0cs_[36] = _data_l_1305[_data_k_1305++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1306 = 0;
    if (_data_k_1306 >= _data_n_1306) {
      _data_k_1306 = 0;
    }
    bth0cs_[0] = _data_l_1306[_data_k_1306++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1307 = 0;
    if (_data_k_1307 >= _data_n_1307) {
      _data_k_1307 = 0;
    }
    bth0cs_[1] = _data_l_1307[_data_k_1307++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1308 = 0;
    if (_data_k_1308 >= _data_n_1308) {
      _data_k_1308 = 0;
    }
    bth0cs_[2] = _data_l_1308[_data_k_1308++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1309 = 0;
    if (_data_k_1309 >= _data_n_1309) {
      _data_k_1309 = 0;
    }
    bth0cs_[3] = _data_l_1309[_data_k_1309++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1310 = 0;
    if (_data_k_1310 >= _data_n_1310) {
      _data_k_1310 = 0;
    }
    bth0cs_[4] = _data_l_1310[_data_k_1310++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1311 = 0;
    if (_data_k_1311 >= _data_n_1311) {
      _data_k_1311 = 0;
    }
    bth0cs_[5] = _data_l_1311[_data_k_1311++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1312 = 0;
    if (_data_k_1312 >= _data_n_1312) {
      _data_k_1312 = 0;
    }
    bth0cs_[6] = _data_l_1312[_data_k_1312++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1313 = 0;
    if (_data_k_1313 >= _data_n_1313) {
      _data_k_1313 = 0;
    }
    bth0cs_[7] = _data_l_1313[_data_k_1313++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1314 = 0;
    if (_data_k_1314 >= _data_n_1314) {
      _data_k_1314 = 0;
    }
    bth0cs_[8] = _data_l_1314[_data_k_1314++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1315 = 0;
    if (_data_k_1315 >= _data_n_1315) {
      _data_k_1315 = 0;
    }
    bth0cs_[9] = _data_l_1315[_data_k_1315++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1316 = 0;
    if (_data_k_1316 >= _data_n_1316) {
      _data_k_1316 = 0;
    }
    bth0cs_[10] = _data_l_1316[_data_k_1316++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1317 = 0;
    if (_data_k_1317 >= _data_n_1317) {
      _data_k_1317 = 0;
    }
    bth0cs_[11] = _data_l_1317[_data_k_1317++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1318 = 0;
    if (_data_k_1318 >= _data_n_1318) {
      _data_k_1318 = 0;
    }
    bth0cs_[12] = _data_l_1318[_data_k_1318++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1319 = 0;
    if (_data_k_1319 >= _data_n_1319) {
      _data_k_1319 = 0;
    }
    bth0cs_[13] = _data_l_1319[_data_k_1319++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1320 = 0;
    if (_data_k_1320 >= _data_n_1320) {
      _data_k_1320 = 0;
    }
    bth0cs_[14] = _data_l_1320[_data_k_1320++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1321 = 0;
    if (_data_k_1321 >= _data_n_1321) {
      _data_k_1321 = 0;
    }
    bth0cs_[15] = _data_l_1321[_data_k_1321++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1322 = 0;
    if (_data_k_1322 >= _data_n_1322) {
      _data_k_1322 = 0;
    }
    bth0cs_[16] = _data_l_1322[_data_k_1322++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1323 = 0;
    if (_data_k_1323 >= _data_n_1323) {
      _data_k_1323 = 0;
    }
    bth0cs_[17] = _data_l_1323[_data_k_1323++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1324 = 0;
    if (_data_k_1324 >= _data_n_1324) {
      _data_k_1324 = 0;
    }
    bth0cs_[18] = _data_l_1324[_data_k_1324++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1325 = 0;
    if (_data_k_1325 >= _data_n_1325) {
      _data_k_1325 = 0;
    }
    bth0cs_[19] = _data_l_1325[_data_k_1325++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1326 = 0;
    if (_data_k_1326 >= _data_n_1326) {
      _data_k_1326 = 0;
    }
    bth0cs_[20] = _data_l_1326[_data_k_1326++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1327 = 0;
    if (_data_k_1327 >= _data_n_1327) {
      _data_k_1327 = 0;
    }
    bth0cs_[21] = _data_l_1327[_data_k_1327++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1328 = 0;
    if (_data_k_1328 >= _data_n_1328) {
      _data_k_1328 = 0;
    }
    bth0cs_[22] = _data_l_1328[_data_k_1328++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1329 = 0;
    if (_data_k_1329 >= _data_n_1329) {
      _data_k_1329 = 0;
    }
    bth0cs_[23] = _data_l_1329[_data_k_1329++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1330 = 0;
    if (_data_k_1330 >= _data_n_1330) {
      _data_k_1330 = 0;
    }
    bth0cs_[24] = _data_l_1330[_data_k_1330++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1331 = 0;
    if (_data_k_1331 >= _data_n_1331) {
      _data_k_1331 = 0;
    }
    bth0cs_[25] = _data_l_1331[_data_k_1331++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1332 = 0;
    if (_data_k_1332 >= _data_n_1332) {
      _data_k_1332 = 0;
    }
    bth0cs_[26] = _data_l_1332[_data_k_1332++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1333 = 0;
    if (_data_k_1333 >= _data_n_1333) {
      _data_k_1333 = 0;
    }
    bth0cs_[27] = _data_l_1333[_data_k_1333++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1334 = 0;
    if (_data_k_1334 >= _data_n_1334) {
      _data_k_1334 = 0;
    }
    bth0cs_[28] = _data_l_1334[_data_k_1334++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1335 = 0;
    if (_data_k_1335 >= _data_n_1335) {
      _data_k_1335 = 0;
    }
    bth0cs_[29] = _data_l_1335[_data_k_1335++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1336 = 0;
    if (_data_k_1336 >= _data_n_1336) {
      _data_k_1336 = 0;
    }
    bth0cs_[30] = _data_l_1336[_data_k_1336++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1337 = 0;
    if (_data_k_1337 >= _data_n_1337) {
      _data_k_1337 = 0;
    }
    bth0cs_[31] = _data_l_1337[_data_k_1337++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1338 = 0;
    if (_data_k_1338 >= _data_n_1338) {
      _data_k_1338 = 0;
    }
    bth0cs_[32] = _data_l_1338[_data_k_1338++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1339 = 0;
    if (_data_k_1339 >= _data_n_1339) {
      _data_k_1339 = 0;
    }
    bth0cs_[33] = _data_l_1339[_data_k_1339++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1340 = 0;
    if (_data_k_1340 >= _data_n_1340) {
      _data_k_1340 = 0;
    }
    bth0cs_[34] = _data_l_1340[_data_k_1340++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1341 = 0;
    if (_data_k_1341 >= _data_n_1341) {
      _data_k_1341 = 0;
    }
    bth0cs_[35] = _data_l_1341[_data_k_1341++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1342 = 0;
    if (_data_k_1342 >= _data_n_1342) {
      _data_k_1342 = 0;
    }
    bth0cs_[36] = _data_l_1342[_data_k_1342++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1343 = 0;
    if (_data_k_1343 >= _data_n_1343) {
      _data_k_1343 = 0;
    }
    bth0cs_[37] = _data_l_1343[_data_k_1343++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1344 = 0;
    if (_data_k_1344 >= _data_n_1344) {
      _data_k_1344 = 0;
    }
    bth0cs_[38] = _data_l_1344[_data_k_1344++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1345 = 0;
    if (_data_k_1345 >= _data_n_1345) {
      _data_k_1345 = 0;
    }
    bth0cs_[39] = _data_l_1345[_data_k_1345++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1346 = 0;
    if (_data_k_1346 >= _data_n_1346) {
      _data_k_1346 = 0;
    }
    bth0cs_[40] = _data_l_1346[_data_k_1346++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1347 = 0;
    if (_data_k_1347 >= _data_n_1347) {
      _data_k_1347 = 0;
    }
    bth0cs_[41] = _data_l_1347[_data_k_1347++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1348 = 0;
    if (_data_k_1348 >= _data_n_1348) {
      _data_k_1348 = 0;
    }
    bth0cs_[42] = _data_l_1348[_data_k_1348++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1349 = 0;
    if (_data_k_1349 >= _data_n_1349) {
      _data_k_1349 = 0;
    }
    bth0cs_[43] = _data_l_1349[_data_k_1349++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1350 = 0;
    if (_data_k_1350 >= _data_n_1350) {
      _data_k_1350 = 0;
    }
    bm02cs_[0] = _data_l_1350[_data_k_1350++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1351 = 0;
    if (_data_k_1351 >= _data_n_1351) {
      _data_k_1351 = 0;
    }
    bm02cs_[1] = _data_l_1351[_data_k_1351++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1352 = 0;
    if (_data_k_1352 >= _data_n_1352) {
      _data_k_1352 = 0;
    }
    bm02cs_[2] = _data_l_1352[_data_k_1352++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1353 = 0;
    if (_data_k_1353 >= _data_n_1353) {
      _data_k_1353 = 0;
    }
    bm02cs_[3] = _data_l_1353[_data_k_1353++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1354 = 0;
    if (_data_k_1354 >= _data_n_1354) {
      _data_k_1354 = 0;
    }
    bm02cs_[4] = _data_l_1354[_data_k_1354++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1355 = 0;
    if (_data_k_1355 >= _data_n_1355) {
      _data_k_1355 = 0;
    }
    bm02cs_[5] = _data_l_1355[_data_k_1355++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1356 = 0;
    if (_data_k_1356 >= _data_n_1356) {
      _data_k_1356 = 0;
    }
    bm02cs_[6] = _data_l_1356[_data_k_1356++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1357 = 0;
    if (_data_k_1357 >= _data_n_1357) {
      _data_k_1357 = 0;
    }
    bm02cs_[7] = _data_l_1357[_data_k_1357++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1358 = 0;
    if (_data_k_1358 >= _data_n_1358) {
      _data_k_1358 = 0;
    }
    bm02cs_[8] = _data_l_1358[_data_k_1358++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1359 = 0;
    if (_data_k_1359 >= _data_n_1359) {
      _data_k_1359 = 0;
    }
    bm02cs_[9] = _data_l_1359[_data_k_1359++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1360 = 0;
    if (_data_k_1360 >= _data_n_1360) {
      _data_k_1360 = 0;
    }
    bm02cs_[10] = _data_l_1360[_data_k_1360++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1361 = 0;
    if (_data_k_1361 >= _data_n_1361) {
      _data_k_1361 = 0;
    }
    bm02cs_[11] = _data_l_1361[_data_k_1361++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1362 = 0;
    if (_data_k_1362 >= _data_n_1362) {
      _data_k_1362 = 0;
    }
    bm02cs_[12] = _data_l_1362[_data_k_1362++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1363 = 0;
    if (_data_k_1363 >= _data_n_1363) {
      _data_k_1363 = 0;
    }
    bm02cs_[13] = _data_l_1363[_data_k_1363++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1364 = 0;
    if (_data_k_1364 >= _data_n_1364) {
      _data_k_1364 = 0;
    }
    bm02cs_[14] = _data_l_1364[_data_k_1364++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1365 = 0;
    if (_data_k_1365 >= _data_n_1365) {
      _data_k_1365 = 0;
    }
    bm02cs_[15] = _data_l_1365[_data_k_1365++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1366 = 0;
    if (_data_k_1366 >= _data_n_1366) {
      _data_k_1366 = 0;
    }
    bm02cs_[16] = _data_l_1366[_data_k_1366++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1367 = 0;
    if (_data_k_1367 >= _data_n_1367) {
      _data_k_1367 = 0;
    }
    bm02cs_[17] = _data_l_1367[_data_k_1367++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1368 = 0;
    if (_data_k_1368 >= _data_n_1368) {
      _data_k_1368 = 0;
    }
    bm02cs_[18] = _data_l_1368[_data_k_1368++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1369 = 0;
    if (_data_k_1369 >= _data_n_1369) {
      _data_k_1369 = 0;
    }
    bm02cs_[19] = _data_l_1369[_data_k_1369++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1370 = 0;
    if (_data_k_1370 >= _data_n_1370) {
      _data_k_1370 = 0;
    }
    bm02cs_[20] = _data_l_1370[_data_k_1370++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1371 = 0;
    if (_data_k_1371 >= _data_n_1371) {
      _data_k_1371 = 0;
    }
    bm02cs_[21] = _data_l_1371[_data_k_1371++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1372 = 0;
    if (_data_k_1372 >= _data_n_1372) {
      _data_k_1372 = 0;
    }
    bm02cs_[22] = _data_l_1372[_data_k_1372++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1373 = 0;
    if (_data_k_1373 >= _data_n_1373) {
      _data_k_1373 = 0;
    }
    bm02cs_[23] = _data_l_1373[_data_k_1373++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1374 = 0;
    if (_data_k_1374 >= _data_n_1374) {
      _data_k_1374 = 0;
    }
    bm02cs_[24] = _data_l_1374[_data_k_1374++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1375 = 0;
    if (_data_k_1375 >= _data_n_1375) {
      _data_k_1375 = 0;
    }
    bm02cs_[25] = _data_l_1375[_data_k_1375++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1376 = 0;
    if (_data_k_1376 >= _data_n_1376) {
      _data_k_1376 = 0;
    }
    bm02cs_[26] = _data_l_1376[_data_k_1376++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1377 = 0;
    if (_data_k_1377 >= _data_n_1377) {
      _data_k_1377 = 0;
    }
    bm02cs_[27] = _data_l_1377[_data_k_1377++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1378 = 0;
    if (_data_k_1378 >= _data_n_1378) {
      _data_k_1378 = 0;
    }
    bm02cs_[28] = _data_l_1378[_data_k_1378++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1379 = 0;
    if (_data_k_1379 >= _data_n_1379) {
      _data_k_1379 = 0;
    }
    bm02cs_[29] = _data_l_1379[_data_k_1379++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1380 = 0;
    if (_data_k_1380 >= _data_n_1380) {
      _data_k_1380 = 0;
    }
    bm02cs_[30] = _data_l_1380[_data_k_1380++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1381 = 0;
    if (_data_k_1381 >= _data_n_1381) {
      _data_k_1381 = 0;
    }
    bm02cs_[31] = _data_l_1381[_data_k_1381++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1382 = 0;
    if (_data_k_1382 >= _data_n_1382) {
      _data_k_1382 = 0;
    }
    bm02cs_[32] = _data_l_1382[_data_k_1382++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1383 = 0;
    if (_data_k_1383 >= _data_n_1383) {
      _data_k_1383 = 0;
    }
    bm02cs_[33] = _data_l_1383[_data_k_1383++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1384 = 0;
    if (_data_k_1384 >= _data_n_1384) {
      _data_k_1384 = 0;
    }
    bm02cs_[34] = _data_l_1384[_data_k_1384++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1385 = 0;
    if (_data_k_1385 >= _data_n_1385) {
      _data_k_1385 = 0;
    }
    bm02cs_[35] = _data_l_1385[_data_k_1385++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1386 = 0;
    if (_data_k_1386 >= _data_n_1386) {
      _data_k_1386 = 0;
    }
    bm02cs_[36] = _data_l_1386[_data_k_1386++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1387 = 0;
    if (_data_k_1387 >= _data_n_1387) {
      _data_k_1387 = 0;
    }
    bm02cs_[37] = _data_l_1387[_data_k_1387++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1388 = 0;
    if (_data_k_1388 >= _data_n_1388) {
      _data_k_1388 = 0;
    }
    bm02cs_[38] = _data_l_1388[_data_k_1388++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1389 = 0;
    if (_data_k_1389 >= _data_n_1389) {
      _data_k_1389 = 0;
    }
    bm02cs_[39] = _data_l_1389[_data_k_1389++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1390 = 0;
    if (_data_k_1390 >= _data_n_1390) {
      _data_k_1390 = 0;
    }
    bt02cs_[0] = _data_l_1390[_data_k_1390++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1391 = 0;
    if (_data_k_1391 >= _data_n_1391) {
      _data_k_1391 = 0;
    }
    bt02cs_[1] = _data_l_1391[_data_k_1391++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1392 = 0;
    if (_data_k_1392 >= _data_n_1392) {
      _data_k_1392 = 0;
    }
    bt02cs_[2] = _data_l_1392[_data_k_1392++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1393 = 0;
    if (_data_k_1393 >= _data_n_1393) {
      _data_k_1393 = 0;
    }
    bt02cs_[3] = _data_l_1393[_data_k_1393++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1394 = 0;
    if (_data_k_1394 >= _data_n_1394) {
      _data_k_1394 = 0;
    }
    bt02cs_[4] = _data_l_1394[_data_k_1394++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1395 = 0;
    if (_data_k_1395 >= _data_n_1395) {
      _data_k_1395 = 0;
    }
    bt02cs_[5] = _data_l_1395[_data_k_1395++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1396 = 0;
    if (_data_k_1396 >= _data_n_1396) {
      _data_k_1396 = 0;
    }
    bt02cs_[6] = _data_l_1396[_data_k_1396++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1397 = 0;
    if (_data_k_1397 >= _data_n_1397) {
      _data_k_1397 = 0;
    }
    bt02cs_[7] = _data_l_1397[_data_k_1397++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1398 = 0;
    if (_data_k_1398 >= _data_n_1398) {
      _data_k_1398 = 0;
    }
    bt02cs_[8] = _data_l_1398[_data_k_1398++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1399 = 0;
    if (_data_k_1399 >= _data_n_1399) {
      _data_k_1399 = 0;
    }
    bt02cs_[9] = _data_l_1399[_data_k_1399++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1400 = 0;
    if (_data_k_1400 >= _data_n_1400) {
      _data_k_1400 = 0;
    }
    bt02cs_[10] = _data_l_1400[_data_k_1400++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1401 = 0;
    if (_data_k_1401 >= _data_n_1401) {
      _data_k_1401 = 0;
    }
    bt02cs_[11] = _data_l_1401[_data_k_1401++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1402 = 0;
    if (_data_k_1402 >= _data_n_1402) {
      _data_k_1402 = 0;
    }
    bt02cs_[12] = _data_l_1402[_data_k_1402++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1403 = 0;
    if (_data_k_1403 >= _data_n_1403) {
      _data_k_1403 = 0;
    }
    bt02cs_[13] = _data_l_1403[_data_k_1403++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1404 = 0;
    if (_data_k_1404 >= _data_n_1404) {
      _data_k_1404 = 0;
    }
    bt02cs_[14] = _data_l_1404[_data_k_1404++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1405 = 0;
    if (_data_k_1405 >= _data_n_1405) {
      _data_k_1405 = 0;
    }
    bt02cs_[15] = _data_l_1405[_data_k_1405++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1406 = 0;
    if (_data_k_1406 >= _data_n_1406) {
      _data_k_1406 = 0;
    }
    bt02cs_[16] = _data_l_1406[_data_k_1406++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1407 = 0;
    if (_data_k_1407 >= _data_n_1407) {
      _data_k_1407 = 0;
    }
    bt02cs_[17] = _data_l_1407[_data_k_1407++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1408 = 0;
    if (_data_k_1408 >= _data_n_1408) {
      _data_k_1408 = 0;
    }
    bt02cs_[18] = _data_l_1408[_data_k_1408++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1409 = 0;
    if (_data_k_1409 >= _data_n_1409) {
      _data_k_1409 = 0;
    }
    bt02cs_[19] = _data_l_1409[_data_k_1409++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1410 = 0;
    if (_data_k_1410 >= _data_n_1410) {
      _data_k_1410 = 0;
    }
    bt02cs_[20] = _data_l_1410[_data_k_1410++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1411 = 0;
    if (_data_k_1411 >= _data_n_1411) {
      _data_k_1411 = 0;
    }
    bt02cs_[21] = _data_l_1411[_data_k_1411++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1412 = 0;
    if (_data_k_1412 >= _data_n_1412) {
      _data_k_1412 = 0;
    }
    bt02cs_[22] = _data_l_1412[_data_k_1412++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1413 = 0;
    if (_data_k_1413 >= _data_n_1413) {
      _data_k_1413 = 0;
    }
    bt02cs_[23] = _data_l_1413[_data_k_1413++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1414 = 0;
    if (_data_k_1414 >= _data_n_1414) {
      _data_k_1414 = 0;
    }
    bt02cs_[24] = _data_l_1414[_data_k_1414++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1415 = 0;
    if (_data_k_1415 >= _data_n_1415) {
      _data_k_1415 = 0;
    }
    bt02cs_[25] = _data_l_1415[_data_k_1415++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1416 = 0;
    if (_data_k_1416 >= _data_n_1416) {
      _data_k_1416 = 0;
    }
    bt02cs_[26] = _data_l_1416[_data_k_1416++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1417 = 0;
    if (_data_k_1417 >= _data_n_1417) {
      _data_k_1417 = 0;
    }
    bt02cs_[27] = _data_l_1417[_data_k_1417++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1418 = 0;
    if (_data_k_1418 >= _data_n_1418) {
      _data_k_1418 = 0;
    }
    bt02cs_[28] = _data_l_1418[_data_k_1418++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1419 = 0;
    if (_data_k_1419 >= _data_n_1419) {
      _data_k_1419 = 0;
    }
    bt02cs_[29] = _data_l_1419[_data_k_1419++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1420 = 0;
    if (_data_k_1420 >= _data_n_1420) {
      _data_k_1420 = 0;
    }
    bt02cs_[30] = _data_l_1420[_data_k_1420++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1421 = 0;
    if (_data_k_1421 >= _data_n_1421) {
      _data_k_1421 = 0;
    }
    bt02cs_[31] = _data_l_1421[_data_k_1421++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1422 = 0;
    if (_data_k_1422 >= _data_n_1422) {
      _data_k_1422 = 0;
    }
    bt02cs_[32] = _data_l_1422[_data_k_1422++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1423 = 0;
    if (_data_k_1423 >= _data_n_1423) {
      _data_k_1423 = 0;
    }
    bt02cs_[33] = _data_l_1423[_data_k_1423++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1424 = 0;
    if (_data_k_1424 >= _data_n_1424) {
      _data_k_1424 = 0;
    }
    bt02cs_[34] = _data_l_1424[_data_k_1424++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1425 = 0;
    if (_data_k_1425 >= _data_n_1425) {
      _data_k_1425 = 0;
    }
    bt02cs_[35] = _data_l_1425[_data_k_1425++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1426 = 0;
    if (_data_k_1426 >= _data_n_1426) {
      _data_k_1426 = 0;
    }
    bt02cs_[36] = _data_l_1426[_data_k_1426++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1427 = 0;
    if (_data_k_1427 >= _data_n_1427) {
      _data_k_1427 = 0;
    }
    bt02cs_[37] = _data_l_1427[_data_k_1427++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1428 = 0;
    if (_data_k_1428 >= _data_n_1428) {
      _data_k_1428 = 0;
    }
    bt02cs_[38] = _data_l_1428[_data_k_1428++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1429 = 0;
    if (_data_k_1429 >= _data_n_1429) {
      _data_k_1429 = 0;
    }
    pi4_ = _data_l_1429[_data_k_1429++];
  }
  if (__calls[97].calls == 0) {
    _data_k_1430 = 0;
    if (_data_k_1430 >= _data_n_1430) {
      _data_k_1430 = 0;
    }
    first_ = _data_l_1430[_data_k_1430++];
  }
  if (first_) {
    eta_ = 0.1 * (real_4) (_d1mach (($0_ = 3, &$0_)));
    nbm0_ = _initds (bm0cs_, ($1_ = 37, &$1_), &eta_);
    nbt02_ = _initds (bt02cs_, ($2_ = 39, &$2_), &eta_);
    nbm02_ = _initds (bm02cs_, ($3_ = 40, &$3_), &eta_);
    nbth0_ = _initds (bth0cs_, ($4_ = 44, &$4_), &eta_);
    xmax_ = 1.0e0 / _d1mach (($5_ = 4, &$5_));
  }
  first_ = FALSE;
  if ((*x_) < 4.0e0) {
    (void) _xermsg (_dc_0, _dc_153, _dc_154, &_k1, ($6_ = 2, &$6_));
  }
  if ((*x_) > 8.0e0) {
    goto _l20;
  }
  z_ = (128.0e0 / ((*x_) * (*x_)) - 5.0e0) / 3.0e0;
  (*ampl_) = (.75e0 + _dcsevl (&z_, bm0cs_, &nbm0_)) / sqrt ((*x_));
  (*theta_) = (*x_) - pi4_ + _dcsevl (&z_, bt02cs_, &nbt02_) / (*x_);
  goto _l0;
  _l20:;
  if ((*x_) > xmax_) {
    (void) _xermsg (_dc_0, _dc_153, _dc_56, ($7_ = 2, &$7_), ($8_ = 2, &$8_));
  }
  z_ = 128.0e0 / ((*x_) * (*x_)) - 1.0e0;
  (*ampl_) = (.75e0 + _dcsevl (&z_, bm02cs_, &nbm02_)) / sqrt ((*x_));
  (*theta_) = (*x_) - pi4_ + _dcsevl (&z_, bth0cs_, &nbth0_) / (*x_);
  _l0:;
  __calls[97].calls++;
  return 0;
}

int_4 _d9b1mp (real_8 _p_ x_, real_8 _p_ ampl_, real_8 _p_ theta_)
{
  static int_4 nbm1_, nbt12_, nbm12_, nbth1_;
  static logical_4 first_;
  static real_4 eta_;
  static real_8 bm1cs_[37], bt12cs_[39], bm12cs_[40], bth1cs_[44], xmax_, pi4_, z_;
  int_4 _data_k_1431, _data_k_1432, _data_k_1433, _data_k_1434, _data_k_1435, _data_k_1436, _data_k_1437, _data_k_1438, 
  _data_k_1439, _data_k_1440, _data_k_1441, _data_k_1442, _data_k_1443, _data_k_1444, _data_k_1445, _data_k_1446, 
  _data_k_1447, _data_k_1448, _data_k_1449, _data_k_1450, _data_k_1451, _data_k_1452, _data_k_1453, _data_k_1454, 
  _data_k_1455, _data_k_1456, _data_k_1457, _data_k_1458, _data_k_1459, _data_k_1460, _data_k_1461, _data_k_1462, 
  _data_k_1463, _data_k_1464, _data_k_1465, _data_k_1466, _data_k_1467, _data_k_1468, _data_k_1469, _data_k_1470, 
  _data_k_1471, _data_k_1472, _data_k_1473, _data_k_1474, _data_k_1475, _data_k_1476, _data_k_1477, _data_k_1478, 
  _data_k_1479, _data_k_1480, _data_k_1481, _data_k_1482, _data_k_1483, _data_k_1484, _data_k_1485, _data_k_1486, 
  _data_k_1487, _data_k_1488, _data_k_1489, _data_k_1490, _data_k_1491, _data_k_1492, _data_k_1493, _data_k_1494, 
  _data_k_1495, _data_k_1496, _data_k_1497, _data_k_1498, _data_k_1499, _data_k_1500, _data_k_1501, _data_k_1502, 
  _data_k_1503, _data_k_1504, _data_k_1505, _data_k_1506, _data_k_1507, _data_k_1508, _data_k_1509, _data_k_1510, 
  _data_k_1511, _data_k_1512, _data_k_1513, _data_k_1514, _data_k_1515, _data_k_1516, _data_k_1517, _data_k_1518, 
  _data_k_1519, _data_k_1520, _data_k_1521, _data_k_1522, _data_k_1523, _data_k_1524, _data_k_1525, _data_k_1526, 
  _data_k_1527, _data_k_1528, _data_k_1529, _data_k_1530, _data_k_1531, _data_k_1532, _data_k_1533, _data_k_1534, 
  _data_k_1535, _data_k_1536, _data_k_1537, _data_k_1538, _data_k_1539, _data_k_1540, _data_k_1541, _data_k_1542, 
  _data_k_1543, _data_k_1544, _data_k_1545, _data_k_1546, _data_k_1547, _data_k_1548, _data_k_1549, _data_k_1550, 
  _data_k_1551, _data_k_1552, _data_k_1553, _data_k_1554, _data_k_1555, _data_k_1556, _data_k_1557, _data_k_1558, 
  _data_k_1559, _data_k_1560, _data_k_1561, _data_k_1562, _data_k_1563, _data_k_1564, _data_k_1565, _data_k_1566, 
  _data_k_1567, _data_k_1568, _data_k_1569, _data_k_1570, _data_k_1571, _data_k_1572, _data_k_1573, _data_k_1574, 
  _data_k_1575, _data_k_1576, _data_k_1577, _data_k_1578, _data_k_1579, _data_k_1580, _data_k_1581, _data_k_1582, 
  _data_k_1583, _data_k_1584, _data_k_1585, _data_k_1586, _data_k_1587, _data_k_1588, _data_k_1589, _data_k_1590, 
  _data_k_1591, _data_k_1592, $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern real_8 _d1mach ();
#define _data_n_1431 1
  static real_8 _data_l_1431[_data_n_1431] = {
    .1069845452618063014969985308538e+0
  };
#define _data_n_1432 1
  static real_8 _data_l_1432[_data_n_1432] = {
    .3274915039715964900729055143445e-2
  };
#define _data_n_1433 1
  static real_8 _data_l_1433[_data_n_1433] = {
    -.2987783266831698592030445777938e-4
  };
#define _data_n_1434 1
  static real_8 _data_l_1434[_data_n_1434] = {
    .8331237177991974531393222669023e-6
  };
#define _data_n_1435 1
  static real_8 _data_l_1435[_data_n_1435] = {
    -.4112665690302007304896381725498e-7
  };
#define _data_n_1436 1
  static real_8 _data_l_1436[_data_n_1436] = {
    .2855344228789215220719757663161e-8
  };
#define _data_n_1437 1
  static real_8 _data_l_1437[_data_n_1437] = {
    -.2485408305415623878060026596055e-9
  };
#define _data_n_1438 1
  static real_8 _data_l_1438[_data_n_1438] = {
    .2543393338072582442742484397174e-10
  };
#define _data_n_1439 1
  static real_8 _data_l_1439[_data_n_1439] = {
    -.2941045772822967523489750827909e-11
  };
#define _data_n_1440 1
  static real_8 _data_l_1440[_data_n_1440] = {
    .3743392025493903309265056153626e-12
  };
#define _data_n_1441 1
  static real_8 _data_l_1441[_data_n_1441] = {
    -.5149118293821167218720548243527e-13
  };
#define _data_n_1442 1
  static real_8 _data_l_1442[_data_n_1442] = {
    .7552535949865143908034040764199e-14
  };
#define _data_n_1443 1
  static real_8 _data_l_1443[_data_n_1443] = {
    -.1169409706828846444166290622464e-14
  };
#define _data_n_1444 1
  static real_8 _data_l_1444[_data_n_1444] = {
    .189656244943479157172182460506e-15
  };
#define _data_n_1445 1
  static real_8 _data_l_1445[_data_n_1445] = {
    -.3201955368693286420664775316394e-16
  };
#define _data_n_1446 1
  static real_8 _data_l_1446[_data_n_1446] = {
    .5599548399316204114484169905493e-17
  };
#define _data_n_1447 1
  static real_8 _data_l_1447[_data_n_1447] = {
    -.1010215894730432443119390444544e-17
  };
#define _data_n_1448 1
  static real_8 _data_l_1448[_data_n_1448] = {
    .1873844985727562983302042719573e-18
  };
#define _data_n_1449 1
  static real_8 _data_l_1449[_data_n_1449] = {
    -.3563537470328580219274301439999e-19
  };
#define _data_n_1450 1
  static real_8 _data_l_1450[_data_n_1450] = {
    .6931283819971238330422763519999e-20
  };
#define _data_n_1451 1
  static real_8 _data_l_1451[_data_n_1451] = {
    -.1376059453406500152251408930133e-20
  };
#define _data_n_1452 1
  static real_8 _data_l_1452[_data_n_1452] = {
    .2783430784107080220599779327999e-21
  };
#define _data_n_1453 1
  static real_8 _data_l_1453[_data_n_1453] = {
    -.5727595364320561689348669439999e-22
  };
#define _data_n_1454 1
  static real_8 _data_l_1454[_data_n_1454] = {
    .1197361445918892672535756799999e-22
  };
#define _data_n_1455 1
  static real_8 _data_l_1455[_data_n_1455] = {
    -.2539928509891871976641440426666e-23
  };
#define _data_n_1456 1
  static real_8 _data_l_1456[_data_n_1456] = {
    .5461378289657295973069619199999e-24
  };
#define _data_n_1457 1
  static real_8 _data_l_1457[_data_n_1457] = {
    -.1189211341773320288986289493333e-24
  };
#define _data_n_1458 1
  static real_8 _data_l_1458[_data_n_1458] = {
    .2620150977340081594957824e-25
  };
#define _data_n_1459 1
  static real_8 _data_l_1459[_data_n_1459] = {
    -.5836810774255685901920938666666e-26
  };
#define _data_n_1460 1
  static real_8 _data_l_1460[_data_n_1460] = {
    .1313743500080595773423615999999e-26
  };
#define _data_n_1461 1
  static real_8 _data_l_1461[_data_n_1461] = {
    -.2985814622510380355332778666666e-27
  };
#define _data_n_1462 1
  static real_8 _data_l_1462[_data_n_1462] = {
    .6848390471334604937625599999999e-28
  };
#define _data_n_1463 1
  static real_8 _data_l_1463[_data_n_1463] = {
    -.158440156822247672119296e-28
  };
#define _data_n_1464 1
  static real_8 _data_l_1464[_data_n_1464] = {
    .3695641006570938054301013333333e-29
  };
#define _data_n_1465 1
  static real_8 _data_l_1465[_data_n_1465] = {
    -.8687115921144668243012266666666e-30
  };
#define _data_n_1466 1
  static real_8 _data_l_1466[_data_n_1466] = {
    .2057080846158763462929066666666e-30
  };
#define _data_n_1467 1
  static real_8 _data_l_1467[_data_n_1467] = {
    -.4905225761116225518523733333333e-31
  };
#define _data_n_1468 1
  static real_8 _data_l_1468[_data_n_1468] = {
    .73823860128742974662620839792764e+0
  };
#define _data_n_1469 1
  static real_8 _data_l_1469[_data_n_1469] = {
    -.33361113174483906384470147681189e-2
  };
#define _data_n_1470 1
  static real_8 _data_l_1470[_data_n_1470] = {
    .61463454888046964698514899420186e-4
  };
#define _data_n_1471 1
  static real_8 _data_l_1471[_data_n_1471] = {
    -.24024585161602374264977635469568e-5
  };
#define _data_n_1472 1
  static real_8 _data_l_1472[_data_n_1472] = {
    .14663555577509746153210591997204e-6
  };
#define _data_n_1473 1
  static real_8 _data_l_1473[_data_n_1473] = {
    -.11841917305589180567005147504983e-7
  };
#define _data_n_1474 1
  static real_8 _data_l_1474[_data_n_1474] = {
    .11574198963919197052125466303055e-8
  };
#define _data_n_1475 1
  static real_8 _data_l_1475[_data_n_1475] = {
    -.13001161129439187449366007794571e-9
  };
#define _data_n_1476 1
  static real_8 _data_l_1476[_data_n_1476] = {
    .16245391141361731937742166273667e-10
  };
#define _data_n_1477 1
  static real_8 _data_l_1477[_data_n_1477] = {
    -.22089636821403188752155441770128e-11
  };
#define _data_n_1478 1
  static real_8 _data_l_1478[_data_n_1478] = {
    .32180304258553177090474358653778e-12
  };
#define _data_n_1479 1
  static real_8 _data_l_1479[_data_n_1479] = {
    -.49653147932768480785552021135381e-13
  };
#define _data_n_1480 1
  static real_8 _data_l_1480[_data_n_1480] = {
    .80438900432847825985558882639317e-14
  };
#define _data_n_1481 1
  static real_8 _data_l_1481[_data_n_1481] = {
    -.13589121310161291384694712682282e-14
  };
#define _data_n_1482 1
  static real_8 _data_l_1482[_data_n_1482] = {
    .23810504397147214869676529605973e-15
  };
#define _data_n_1483 1
  static real_8 _data_l_1483[_data_n_1483] = {
    -.43081466363849106724471241420799e-16
  };
#define _data_n_1484 1
  static real_8 _data_l_1484[_data_n_1484] = {
    .802025440327710024349935125504e-17
  };
#define _data_n_1485 1
  static real_8 _data_l_1485[_data_n_1485] = {
    -.15316310642462311864230027468799e-17
  };
#define _data_n_1486 1
  static real_8 _data_l_1486[_data_n_1486] = {
    .29928606352715568924073040554666e-18
  };
#define _data_n_1487 1
  static real_8 _data_l_1487[_data_n_1487] = {
    -.59709964658085443393815636650666e-19
  };
#define _data_n_1488 1
  static real_8 _data_l_1488[_data_n_1488] = {
    .12140289669415185024160852650666e-19
  };
#define _data_n_1489 1
  static real_8 _data_l_1489[_data_n_1489] = {
    -.25115114696612948901006977706666e-20
  };
#define _data_n_1490 1
  static real_8 _data_l_1490[_data_n_1490] = {
    .52790567170328744850738380799999e-21
  };
#define _data_n_1491 1
  static real_8 _data_l_1491[_data_n_1491] = {
    -.11260509227550498324361161386666e-21
  };
#define _data_n_1492 1
  static real_8 _data_l_1492[_data_n_1492] = {
    .243482773595763266596634624e-22
  };
#define _data_n_1493 1
  static real_8 _data_l_1493[_data_n_1493] = {
    -.53317261236931800130038442666666e-23
  };
#define _data_n_1494 1
  static real_8 _data_l_1494[_data_n_1494] = {
    .11813615059707121039205990399999e-23
  };
#define _data_n_1495 1
  static real_8 _data_l_1495[_data_n_1495] = {
    -.26465368283353523514856789333333e-24
  };
#define _data_n_1496 1
  static real_8 _data_l_1496[_data_n_1496] = {
    .59903394041361503945577813333333e-25
  };
#define _data_n_1497 1
  static real_8 _data_l_1497[_data_n_1497] = {
    -.13690854630829503109136383999999e-25
  };
#define _data_n_1498 1
  static real_8 _data_l_1498[_data_n_1498] = {
    .31576790154380228326413653333333e-26
  };
#define _data_n_1499 1
  static real_8 _data_l_1499[_data_n_1499] = {
    -.73457915082084356491400533333333e-27
  };
#define _data_n_1500 1
  static real_8 _data_l_1500[_data_n_1500] = {
    .1722808148072274793070592e-27
  };
#define _data_n_1501 1
  static real_8 _data_l_1501[_data_n_1501] = {
    -.407169079612865079410688e-28
  };
#define _data_n_1502 1
  static real_8 _data_l_1502[_data_n_1502] = {
    .96934745136779622700373333333333e-29
  };
#define _data_n_1503 1
  static real_8 _data_l_1503[_data_n_1503] = {
    -.23237636337765716765354666666666e-29
  };
#define _data_n_1504 1
  static real_8 _data_l_1504[_data_n_1504] = {
    .56074510673522029406890666666666e-30
  };
#define _data_n_1505 1
  static real_8 _data_l_1505[_data_n_1505] = {
    -.13616465391539005860522666666666e-30
  };
#define _data_n_1506 1
  static real_8 _data_l_1506[_data_n_1506] = {
    .33263109233894654388906666666666e-31
  };
#define _data_n_1507 1
  static real_8 _data_l_1507[_data_n_1507] = {
    .9807979156233050027272093546937e-1
  };
#define _data_n_1508 1
  static real_8 _data_l_1508[_data_n_1508] = {
    .1150961189504685306175483484602e-2
  };
#define _data_n_1509 1
  static real_8 _data_l_1509[_data_n_1509] = {
    -.4312482164338205409889358097732e-5
  };
#define _data_n_1510 1
  static real_8 _data_l_1510[_data_n_1510] = {
    .5951839610088816307813029801832e-7
  };
#define _data_n_1511 1
  static real_8 _data_l_1511[_data_n_1511] = {
    -.1704844019826909857400701586478e-8
  };
#define _data_n_1512 1
  static real_8 _data_l_1512[_data_n_1512] = {
    .7798265413611109508658173827401e-10
  };
#define _data_n_1513 1
  static real_8 _data_l_1513[_data_n_1513] = {
    -.4958986126766415809491754951865e-11
  };
#define _data_n_1514 1
  static real_8 _data_l_1514[_data_n_1514] = {
    .4038432416421141516838202265144e-12
  };
#define _data_n_1515 1
  static real_8 _data_l_1515[_data_n_1515] = {
    -.3993046163725175445765483846645e-13
  };
#define _data_n_1516 1
  static real_8 _data_l_1516[_data_n_1516] = {
    .4619886183118966494313342432775e-14
  };
#define _data_n_1517 1
  static real_8 _data_l_1517[_data_n_1517] = {
    -.6089208019095383301345472619333e-15
  };
#define _data_n_1518 1
  static real_8 _data_l_1518[_data_n_1518] = {
    .8960930916433876482157048041249e-16
  };
#define _data_n_1519 1
  static real_8 _data_l_1519[_data_n_1519] = {
    -.1449629423942023122916518918925e-16
  };
#define _data_n_1520 1
  static real_8 _data_l_1520[_data_n_1520] = {
    .2546463158537776056165149648068e-17
  };
#define _data_n_1521 1
  static real_8 _data_l_1521[_data_n_1521] = {
    -.480947287464783644425926371862e-18
  };
#define _data_n_1522 1
  static real_8 _data_l_1522[_data_n_1522] = {
    .9687684668292599049087275839124e-19
  };
#define _data_n_1523 1
  static real_8 _data_l_1523[_data_n_1523] = {
    -.2067213372277966023245038117551e-19
  };
#define _data_n_1524 1
  static real_8 _data_l_1524[_data_n_1524] = {
    .464665155915038473180276780959e-20
  };
#define _data_n_1525 1
  static real_8 _data_l_1525[_data_n_1525] = {
    -.1094966128848334138241351328339e-20
  };
#define _data_n_1526 1
  static real_8 _data_l_1526[_data_n_1526] = {
    .2693892797288682860905707612785e-21
  };
#define _data_n_1527 1
  static real_8 _data_l_1527[_data_n_1527] = {
    -.6894992910930374477818970026857e-22
  };
#define _data_n_1528 1
  static real_8 _data_l_1528[_data_n_1528] = {
    .183026826275206290989066855474e-22
  };
#define _data_n_1529 1
  static real_8 _data_l_1529[_data_n_1529] = {
    -.5025064246351916428156113553224e-23
  };
#define _data_n_1530 1
  static real_8 _data_l_1530[_data_n_1530] = {
    .1423545194454806039631693634194e-23
  };
#define _data_n_1531 1
  static real_8 _data_l_1531[_data_n_1531] = {
    -.4152191203616450388068886769801e-24
  };
#define _data_n_1532 1
  static real_8 _data_l_1532[_data_n_1532] = {
    .1244609201503979325882330076547e-24
  };
#define _data_n_1533 1
  static real_8 _data_l_1533[_data_n_1533] = {
    -.3827336370569304299431918661286e-25
  };
#define _data_n_1534 1
  static real_8 _data_l_1534[_data_n_1534] = {
    .1205591357815617535374723981835e-25
  };
#define _data_n_1535 1
  static real_8 _data_l_1535[_data_n_1535] = {
    -.3884536246376488076431859361124e-26
  };
#define _data_n_1536 1
  static real_8 _data_l_1536[_data_n_1536] = {
    .1278689528720409721904895283461e-26
  };
#define _data_n_1537 1
  static real_8 _data_l_1537[_data_n_1537] = {
    -.4295146689447946272061936915912e-27
  };
#define _data_n_1538 1
  static real_8 _data_l_1538[_data_n_1538] = {
    .1470689117829070886456802707983e-27
  };
#define _data_n_1539 1
  static real_8 _data_l_1539[_data_n_1539] = {
    -.5128315665106073128180374017796e-28
  };
#define _data_n_1540 1
  static real_8 _data_l_1540[_data_n_1540] = {
    .1819509585471169385481437373286e-28
  };
#define _data_n_1541 1
  static real_8 _data_l_1541[_data_n_1541] = {
    -.6563031314841980867618635050373e-29
  };
#define _data_n_1542 1
  static real_8 _data_l_1542[_data_n_1542] = {
    .2404898976919960653198914875834e-29
  };
#define _data_n_1543 1
  static real_8 _data_l_1543[_data_n_1543] = {
    -.8945966744690612473234958242979e-30
  };
#define _data_n_1544 1
  static real_8 _data_l_1544[_data_n_1544] = {
    .337608516065723102663714897824e-30
  };
#define _data_n_1545 1
  static real_8 _data_l_1545[_data_n_1545] = {
    -.1291791454620656360913099916966e-30
  };
#define _data_n_1546 1
  static real_8 _data_l_1546[_data_n_1546] = {
    .5008634462958810520684951501254e-31
  };
#define _data_n_1547 1
  static real_8 _data_l_1547[_data_n_1547] = {
    .74749957203587276055443483969695e+0
  };
#define _data_n_1548 1
  static real_8 _data_l_1548[_data_n_1548] = {
    -.12400777144651711252545777541384e-2
  };
#define _data_n_1549 1
  static real_8 _data_l_1549[_data_n_1549] = {
    .99252442404424527376641497689592e-5
  };
#define _data_n_1550 1
  static real_8 _data_l_1550[_data_n_1550] = {
    -.20303690737159711052419375375608e-6
  };
#define _data_n_1551 1
  static real_8 _data_l_1551[_data_n_1551] = {
    .75359617705690885712184017583629e-8
  };
#define _data_n_1552 1
  static real_8 _data_l_1552[_data_n_1552] = {
    -.41661612715343550107630023856228e-9
  };
#define _data_n_1553 1
  static real_8 _data_l_1553[_data_n_1553] = {
    .30701618070834890481245102091216e-10
  };
#define _data_n_1554 1
  static real_8 _data_l_1554[_data_n_1554] = {
    -.28178499637605213992324008883924e-11
  };
#define _data_n_1555 1
  static real_8 _data_l_1555[_data_n_1555] = {
    .30790696739040295476028146821647e-12
  };
#define _data_n_1556 1
  static real_8 _data_l_1556[_data_n_1556] = {
    -.38803300262803434112787347554781e-13
  };
#define _data_n_1557 1
  static real_8 _data_l_1557[_data_n_1557] = {
    .55096039608630904934561726208562e-14
  };
#define _data_n_1558 1
  static real_8 _data_l_1558[_data_n_1558] = {
    -.86590060768383779940103398953994e-15
  };
#define _data_n_1559 1
  static real_8 _data_l_1559[_data_n_1559] = {
    .14856049141536749003423689060683e-15
  };
#define _data_n_1560 1
  static real_8 _data_l_1560[_data_n_1560] = {
    -.27519529815904085805371212125009e-16
  };
#define _data_n_1561 1
  static real_8 _data_l_1561[_data_n_1561] = {
    .54550796090481089625036223640923e-17
  };
#define _data_n_1562 1
  static real_8 _data_l_1562[_data_n_1562] = {
    -.11486534501983642749543631027177e-17
  };
#define _data_n_1563 1
  static real_8 _data_l_1563[_data_n_1563] = {
    .25535213377973900223199052533522e-18
  };
#define _data_n_1564 1
  static real_8 _data_l_1564[_data_n_1564] = {
    -.59621490197413450395768287907849e-19
  };
#define _data_n_1565 1
  static real_8 _data_l_1565[_data_n_1565] = {
    .14556622902372718620288302005833e-19
  };
#define _data_n_1566 1
  static real_8 _data_l_1566[_data_n_1566] = {
    -.37022185422450538201579776019593e-20
  };
#define _data_n_1567 1
  static real_8 _data_l_1567[_data_n_1567] = {
    .97763074125345357664168434517924e-21
  };
#define _data_n_1568 1
  static real_8 _data_l_1568[_data_n_1568] = {
    -.26726821639668488468723775393052e-21
  };
#define _data_n_1569 1
  static real_8 _data_l_1569[_data_n_1569] = {
    .75453300384983271794038190655764e-22
  };
#define _data_n_1570 1
  static real_8 _data_l_1570[_data_n_1570] = {
    -.21947899919802744897892383371647e-22
  };
#define _data_n_1571 1
  static real_8 _data_l_1571[_data_n_1571] = {
    .65648394623955262178906999817493e-23
  };
#define _data_n_1572 1
  static real_8 _data_l_1572[_data_n_1572] = {
    -.20155604298370207570784076869519e-23
  };
#define _data_n_1573 1
  static real_8 _data_l_1573[_data_n_1573] = {
    .6341776855677614349214466718567e-24
  };
#define _data_n_1574 1
  static real_8 _data_l_1574[_data_n_1574] = {
    -.20419277885337895634813769955591e-24
  };
#define _data_n_1575 1
  static real_8 _data_l_1575[_data_n_1575] = {
    .67191464220720567486658980018551e-25
  };
#define _data_n_1576 1
  static real_8 _data_l_1576[_data_n_1576] = {
    -.22569079110207573595709003687336e-25
  };
#define _data_n_1577 1
  static real_8 _data_l_1577[_data_n_1577] = {
    .77297719892989706370926959871929e-26
  };
#define _data_n_1578 1
  static real_8 _data_l_1578[_data_n_1578] = {
    -.2696744451229464091321142408092e-26
  };
#define _data_n_1579 1
  static real_8 _data_l_1579[_data_n_1579] = {
    .95749344518502698072295521933627e-27
  };
#define _data_n_1580 1
  static real_8 _data_l_1580[_data_n_1580] = {
    -.34569168448890113000175680827627e-27
  };
#define _data_n_1581 1
  static real_8 _data_l_1581[_data_n_1581] = {
    .12681234817398436504211986238374e-27
  };
#define _data_n_1582 1
  static real_8 _data_l_1582[_data_n_1582] = {
    -.47232536630722639860464993713445e-28
  };
#define _data_n_1583 1
  static real_8 _data_l_1583[_data_n_1583] = {
    .17850008478186376177858619796417e-28
  };
#define _data_n_1584 1
  static real_8 _data_l_1584[_data_n_1584] = {
    -.68404361004510395406215223566746e-29
  };
#define _data_n_1585 1
  static real_8 _data_l_1585[_data_n_1585] = {
    .26566028671720419358293422672212e-29
  };
#define _data_n_1586 1
  static real_8 _data_l_1586[_data_n_1586] = {
    -.1045040252791445291771416148467e-29
  };
#define _data_n_1587 1
  static real_8 _data_l_1587[_data_n_1587] = {
    .41618290825377144306861917197064e-30
  };
#define _data_n_1588 1
  static real_8 _data_l_1588[_data_n_1588] = {
    -.16771639203643714856501347882887e-30
  };
#define _data_n_1589 1
  static real_8 _data_l_1589[_data_n_1589] = {
    .68361997776664389173535928028528e-31
  };
#define _data_n_1590 1
  static real_8 _data_l_1590[_data_n_1590] = {
    -.2817224786123364116673957462281e-31
  };
#define _data_n_1591 1
  static real_8 _data_l_1591[_data_n_1591] = {
    0.785398163397448309615660845819876e0
  };
#define _data_n_1592 1
  static logical_4 _data_l_1592[_data_n_1592] = {
    TRUE
  };
  if (__calls[98].calls == 0) {
    _data_k_1431 = 0;
    if (_data_k_1431 >= _data_n_1431) {
      _data_k_1431 = 0;
    }
    bm1cs_[0] = _data_l_1431[_data_k_1431++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1432 = 0;
    if (_data_k_1432 >= _data_n_1432) {
      _data_k_1432 = 0;
    }
    bm1cs_[1] = _data_l_1432[_data_k_1432++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1433 = 0;
    if (_data_k_1433 >= _data_n_1433) {
      _data_k_1433 = 0;
    }
    bm1cs_[2] = _data_l_1433[_data_k_1433++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1434 = 0;
    if (_data_k_1434 >= _data_n_1434) {
      _data_k_1434 = 0;
    }
    bm1cs_[3] = _data_l_1434[_data_k_1434++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1435 = 0;
    if (_data_k_1435 >= _data_n_1435) {
      _data_k_1435 = 0;
    }
    bm1cs_[4] = _data_l_1435[_data_k_1435++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1436 = 0;
    if (_data_k_1436 >= _data_n_1436) {
      _data_k_1436 = 0;
    }
    bm1cs_[5] = _data_l_1436[_data_k_1436++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1437 = 0;
    if (_data_k_1437 >= _data_n_1437) {
      _data_k_1437 = 0;
    }
    bm1cs_[6] = _data_l_1437[_data_k_1437++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1438 = 0;
    if (_data_k_1438 >= _data_n_1438) {
      _data_k_1438 = 0;
    }
    bm1cs_[7] = _data_l_1438[_data_k_1438++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1439 = 0;
    if (_data_k_1439 >= _data_n_1439) {
      _data_k_1439 = 0;
    }
    bm1cs_[8] = _data_l_1439[_data_k_1439++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1440 = 0;
    if (_data_k_1440 >= _data_n_1440) {
      _data_k_1440 = 0;
    }
    bm1cs_[9] = _data_l_1440[_data_k_1440++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1441 = 0;
    if (_data_k_1441 >= _data_n_1441) {
      _data_k_1441 = 0;
    }
    bm1cs_[10] = _data_l_1441[_data_k_1441++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1442 = 0;
    if (_data_k_1442 >= _data_n_1442) {
      _data_k_1442 = 0;
    }
    bm1cs_[11] = _data_l_1442[_data_k_1442++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1443 = 0;
    if (_data_k_1443 >= _data_n_1443) {
      _data_k_1443 = 0;
    }
    bm1cs_[12] = _data_l_1443[_data_k_1443++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1444 = 0;
    if (_data_k_1444 >= _data_n_1444) {
      _data_k_1444 = 0;
    }
    bm1cs_[13] = _data_l_1444[_data_k_1444++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1445 = 0;
    if (_data_k_1445 >= _data_n_1445) {
      _data_k_1445 = 0;
    }
    bm1cs_[14] = _data_l_1445[_data_k_1445++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1446 = 0;
    if (_data_k_1446 >= _data_n_1446) {
      _data_k_1446 = 0;
    }
    bm1cs_[15] = _data_l_1446[_data_k_1446++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1447 = 0;
    if (_data_k_1447 >= _data_n_1447) {
      _data_k_1447 = 0;
    }
    bm1cs_[16] = _data_l_1447[_data_k_1447++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1448 = 0;
    if (_data_k_1448 >= _data_n_1448) {
      _data_k_1448 = 0;
    }
    bm1cs_[17] = _data_l_1448[_data_k_1448++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1449 = 0;
    if (_data_k_1449 >= _data_n_1449) {
      _data_k_1449 = 0;
    }
    bm1cs_[18] = _data_l_1449[_data_k_1449++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1450 = 0;
    if (_data_k_1450 >= _data_n_1450) {
      _data_k_1450 = 0;
    }
    bm1cs_[19] = _data_l_1450[_data_k_1450++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1451 = 0;
    if (_data_k_1451 >= _data_n_1451) {
      _data_k_1451 = 0;
    }
    bm1cs_[20] = _data_l_1451[_data_k_1451++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1452 = 0;
    if (_data_k_1452 >= _data_n_1452) {
      _data_k_1452 = 0;
    }
    bm1cs_[21] = _data_l_1452[_data_k_1452++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1453 = 0;
    if (_data_k_1453 >= _data_n_1453) {
      _data_k_1453 = 0;
    }
    bm1cs_[22] = _data_l_1453[_data_k_1453++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1454 = 0;
    if (_data_k_1454 >= _data_n_1454) {
      _data_k_1454 = 0;
    }
    bm1cs_[23] = _data_l_1454[_data_k_1454++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1455 = 0;
    if (_data_k_1455 >= _data_n_1455) {
      _data_k_1455 = 0;
    }
    bm1cs_[24] = _data_l_1455[_data_k_1455++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1456 = 0;
    if (_data_k_1456 >= _data_n_1456) {
      _data_k_1456 = 0;
    }
    bm1cs_[25] = _data_l_1456[_data_k_1456++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1457 = 0;
    if (_data_k_1457 >= _data_n_1457) {
      _data_k_1457 = 0;
    }
    bm1cs_[26] = _data_l_1457[_data_k_1457++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1458 = 0;
    if (_data_k_1458 >= _data_n_1458) {
      _data_k_1458 = 0;
    }
    bm1cs_[27] = _data_l_1458[_data_k_1458++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1459 = 0;
    if (_data_k_1459 >= _data_n_1459) {
      _data_k_1459 = 0;
    }
    bm1cs_[28] = _data_l_1459[_data_k_1459++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1460 = 0;
    if (_data_k_1460 >= _data_n_1460) {
      _data_k_1460 = 0;
    }
    bm1cs_[29] = _data_l_1460[_data_k_1460++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1461 = 0;
    if (_data_k_1461 >= _data_n_1461) {
      _data_k_1461 = 0;
    }
    bm1cs_[30] = _data_l_1461[_data_k_1461++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1462 = 0;
    if (_data_k_1462 >= _data_n_1462) {
      _data_k_1462 = 0;
    }
    bm1cs_[31] = _data_l_1462[_data_k_1462++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1463 = 0;
    if (_data_k_1463 >= _data_n_1463) {
      _data_k_1463 = 0;
    }
    bm1cs_[32] = _data_l_1463[_data_k_1463++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1464 = 0;
    if (_data_k_1464 >= _data_n_1464) {
      _data_k_1464 = 0;
    }
    bm1cs_[33] = _data_l_1464[_data_k_1464++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1465 = 0;
    if (_data_k_1465 >= _data_n_1465) {
      _data_k_1465 = 0;
    }
    bm1cs_[34] = _data_l_1465[_data_k_1465++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1466 = 0;
    if (_data_k_1466 >= _data_n_1466) {
      _data_k_1466 = 0;
    }
    bm1cs_[35] = _data_l_1466[_data_k_1466++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1467 = 0;
    if (_data_k_1467 >= _data_n_1467) {
      _data_k_1467 = 0;
    }
    bm1cs_[36] = _data_l_1467[_data_k_1467++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1468 = 0;
    if (_data_k_1468 >= _data_n_1468) {
      _data_k_1468 = 0;
    }
    bt12cs_[0] = _data_l_1468[_data_k_1468++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1469 = 0;
    if (_data_k_1469 >= _data_n_1469) {
      _data_k_1469 = 0;
    }
    bt12cs_[1] = _data_l_1469[_data_k_1469++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1470 = 0;
    if (_data_k_1470 >= _data_n_1470) {
      _data_k_1470 = 0;
    }
    bt12cs_[2] = _data_l_1470[_data_k_1470++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1471 = 0;
    if (_data_k_1471 >= _data_n_1471) {
      _data_k_1471 = 0;
    }
    bt12cs_[3] = _data_l_1471[_data_k_1471++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1472 = 0;
    if (_data_k_1472 >= _data_n_1472) {
      _data_k_1472 = 0;
    }
    bt12cs_[4] = _data_l_1472[_data_k_1472++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1473 = 0;
    if (_data_k_1473 >= _data_n_1473) {
      _data_k_1473 = 0;
    }
    bt12cs_[5] = _data_l_1473[_data_k_1473++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1474 = 0;
    if (_data_k_1474 >= _data_n_1474) {
      _data_k_1474 = 0;
    }
    bt12cs_[6] = _data_l_1474[_data_k_1474++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1475 = 0;
    if (_data_k_1475 >= _data_n_1475) {
      _data_k_1475 = 0;
    }
    bt12cs_[7] = _data_l_1475[_data_k_1475++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1476 = 0;
    if (_data_k_1476 >= _data_n_1476) {
      _data_k_1476 = 0;
    }
    bt12cs_[8] = _data_l_1476[_data_k_1476++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1477 = 0;
    if (_data_k_1477 >= _data_n_1477) {
      _data_k_1477 = 0;
    }
    bt12cs_[9] = _data_l_1477[_data_k_1477++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1478 = 0;
    if (_data_k_1478 >= _data_n_1478) {
      _data_k_1478 = 0;
    }
    bt12cs_[10] = _data_l_1478[_data_k_1478++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1479 = 0;
    if (_data_k_1479 >= _data_n_1479) {
      _data_k_1479 = 0;
    }
    bt12cs_[11] = _data_l_1479[_data_k_1479++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1480 = 0;
    if (_data_k_1480 >= _data_n_1480) {
      _data_k_1480 = 0;
    }
    bt12cs_[12] = _data_l_1480[_data_k_1480++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1481 = 0;
    if (_data_k_1481 >= _data_n_1481) {
      _data_k_1481 = 0;
    }
    bt12cs_[13] = _data_l_1481[_data_k_1481++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1482 = 0;
    if (_data_k_1482 >= _data_n_1482) {
      _data_k_1482 = 0;
    }
    bt12cs_[14] = _data_l_1482[_data_k_1482++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1483 = 0;
    if (_data_k_1483 >= _data_n_1483) {
      _data_k_1483 = 0;
    }
    bt12cs_[15] = _data_l_1483[_data_k_1483++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1484 = 0;
    if (_data_k_1484 >= _data_n_1484) {
      _data_k_1484 = 0;
    }
    bt12cs_[16] = _data_l_1484[_data_k_1484++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1485 = 0;
    if (_data_k_1485 >= _data_n_1485) {
      _data_k_1485 = 0;
    }
    bt12cs_[17] = _data_l_1485[_data_k_1485++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1486 = 0;
    if (_data_k_1486 >= _data_n_1486) {
      _data_k_1486 = 0;
    }
    bt12cs_[18] = _data_l_1486[_data_k_1486++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1487 = 0;
    if (_data_k_1487 >= _data_n_1487) {
      _data_k_1487 = 0;
    }
    bt12cs_[19] = _data_l_1487[_data_k_1487++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1488 = 0;
    if (_data_k_1488 >= _data_n_1488) {
      _data_k_1488 = 0;
    }
    bt12cs_[20] = _data_l_1488[_data_k_1488++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1489 = 0;
    if (_data_k_1489 >= _data_n_1489) {
      _data_k_1489 = 0;
    }
    bt12cs_[21] = _data_l_1489[_data_k_1489++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1490 = 0;
    if (_data_k_1490 >= _data_n_1490) {
      _data_k_1490 = 0;
    }
    bt12cs_[22] = _data_l_1490[_data_k_1490++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1491 = 0;
    if (_data_k_1491 >= _data_n_1491) {
      _data_k_1491 = 0;
    }
    bt12cs_[23] = _data_l_1491[_data_k_1491++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1492 = 0;
    if (_data_k_1492 >= _data_n_1492) {
      _data_k_1492 = 0;
    }
    bt12cs_[24] = _data_l_1492[_data_k_1492++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1493 = 0;
    if (_data_k_1493 >= _data_n_1493) {
      _data_k_1493 = 0;
    }
    bt12cs_[25] = _data_l_1493[_data_k_1493++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1494 = 0;
    if (_data_k_1494 >= _data_n_1494) {
      _data_k_1494 = 0;
    }
    bt12cs_[26] = _data_l_1494[_data_k_1494++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1495 = 0;
    if (_data_k_1495 >= _data_n_1495) {
      _data_k_1495 = 0;
    }
    bt12cs_[27] = _data_l_1495[_data_k_1495++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1496 = 0;
    if (_data_k_1496 >= _data_n_1496) {
      _data_k_1496 = 0;
    }
    bt12cs_[28] = _data_l_1496[_data_k_1496++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1497 = 0;
    if (_data_k_1497 >= _data_n_1497) {
      _data_k_1497 = 0;
    }
    bt12cs_[29] = _data_l_1497[_data_k_1497++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1498 = 0;
    if (_data_k_1498 >= _data_n_1498) {
      _data_k_1498 = 0;
    }
    bt12cs_[30] = _data_l_1498[_data_k_1498++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1499 = 0;
    if (_data_k_1499 >= _data_n_1499) {
      _data_k_1499 = 0;
    }
    bt12cs_[31] = _data_l_1499[_data_k_1499++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1500 = 0;
    if (_data_k_1500 >= _data_n_1500) {
      _data_k_1500 = 0;
    }
    bt12cs_[32] = _data_l_1500[_data_k_1500++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1501 = 0;
    if (_data_k_1501 >= _data_n_1501) {
      _data_k_1501 = 0;
    }
    bt12cs_[33] = _data_l_1501[_data_k_1501++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1502 = 0;
    if (_data_k_1502 >= _data_n_1502) {
      _data_k_1502 = 0;
    }
    bt12cs_[34] = _data_l_1502[_data_k_1502++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1503 = 0;
    if (_data_k_1503 >= _data_n_1503) {
      _data_k_1503 = 0;
    }
    bt12cs_[35] = _data_l_1503[_data_k_1503++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1504 = 0;
    if (_data_k_1504 >= _data_n_1504) {
      _data_k_1504 = 0;
    }
    bt12cs_[36] = _data_l_1504[_data_k_1504++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1505 = 0;
    if (_data_k_1505 >= _data_n_1505) {
      _data_k_1505 = 0;
    }
    bt12cs_[37] = _data_l_1505[_data_k_1505++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1506 = 0;
    if (_data_k_1506 >= _data_n_1506) {
      _data_k_1506 = 0;
    }
    bt12cs_[38] = _data_l_1506[_data_k_1506++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1507 = 0;
    if (_data_k_1507 >= _data_n_1507) {
      _data_k_1507 = 0;
    }
    bm12cs_[0] = _data_l_1507[_data_k_1507++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1508 = 0;
    if (_data_k_1508 >= _data_n_1508) {
      _data_k_1508 = 0;
    }
    bm12cs_[1] = _data_l_1508[_data_k_1508++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1509 = 0;
    if (_data_k_1509 >= _data_n_1509) {
      _data_k_1509 = 0;
    }
    bm12cs_[2] = _data_l_1509[_data_k_1509++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1510 = 0;
    if (_data_k_1510 >= _data_n_1510) {
      _data_k_1510 = 0;
    }
    bm12cs_[3] = _data_l_1510[_data_k_1510++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1511 = 0;
    if (_data_k_1511 >= _data_n_1511) {
      _data_k_1511 = 0;
    }
    bm12cs_[4] = _data_l_1511[_data_k_1511++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1512 = 0;
    if (_data_k_1512 >= _data_n_1512) {
      _data_k_1512 = 0;
    }
    bm12cs_[5] = _data_l_1512[_data_k_1512++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1513 = 0;
    if (_data_k_1513 >= _data_n_1513) {
      _data_k_1513 = 0;
    }
    bm12cs_[6] = _data_l_1513[_data_k_1513++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1514 = 0;
    if (_data_k_1514 >= _data_n_1514) {
      _data_k_1514 = 0;
    }
    bm12cs_[7] = _data_l_1514[_data_k_1514++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1515 = 0;
    if (_data_k_1515 >= _data_n_1515) {
      _data_k_1515 = 0;
    }
    bm12cs_[8] = _data_l_1515[_data_k_1515++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1516 = 0;
    if (_data_k_1516 >= _data_n_1516) {
      _data_k_1516 = 0;
    }
    bm12cs_[9] = _data_l_1516[_data_k_1516++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1517 = 0;
    if (_data_k_1517 >= _data_n_1517) {
      _data_k_1517 = 0;
    }
    bm12cs_[10] = _data_l_1517[_data_k_1517++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1518 = 0;
    if (_data_k_1518 >= _data_n_1518) {
      _data_k_1518 = 0;
    }
    bm12cs_[11] = _data_l_1518[_data_k_1518++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1519 = 0;
    if (_data_k_1519 >= _data_n_1519) {
      _data_k_1519 = 0;
    }
    bm12cs_[12] = _data_l_1519[_data_k_1519++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1520 = 0;
    if (_data_k_1520 >= _data_n_1520) {
      _data_k_1520 = 0;
    }
    bm12cs_[13] = _data_l_1520[_data_k_1520++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1521 = 0;
    if (_data_k_1521 >= _data_n_1521) {
      _data_k_1521 = 0;
    }
    bm12cs_[14] = _data_l_1521[_data_k_1521++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1522 = 0;
    if (_data_k_1522 >= _data_n_1522) {
      _data_k_1522 = 0;
    }
    bm12cs_[15] = _data_l_1522[_data_k_1522++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1523 = 0;
    if (_data_k_1523 >= _data_n_1523) {
      _data_k_1523 = 0;
    }
    bm12cs_[16] = _data_l_1523[_data_k_1523++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1524 = 0;
    if (_data_k_1524 >= _data_n_1524) {
      _data_k_1524 = 0;
    }
    bm12cs_[17] = _data_l_1524[_data_k_1524++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1525 = 0;
    if (_data_k_1525 >= _data_n_1525) {
      _data_k_1525 = 0;
    }
    bm12cs_[18] = _data_l_1525[_data_k_1525++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1526 = 0;
    if (_data_k_1526 >= _data_n_1526) {
      _data_k_1526 = 0;
    }
    bm12cs_[19] = _data_l_1526[_data_k_1526++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1527 = 0;
    if (_data_k_1527 >= _data_n_1527) {
      _data_k_1527 = 0;
    }
    bm12cs_[20] = _data_l_1527[_data_k_1527++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1528 = 0;
    if (_data_k_1528 >= _data_n_1528) {
      _data_k_1528 = 0;
    }
    bm12cs_[21] = _data_l_1528[_data_k_1528++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1529 = 0;
    if (_data_k_1529 >= _data_n_1529) {
      _data_k_1529 = 0;
    }
    bm12cs_[22] = _data_l_1529[_data_k_1529++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1530 = 0;
    if (_data_k_1530 >= _data_n_1530) {
      _data_k_1530 = 0;
    }
    bm12cs_[23] = _data_l_1530[_data_k_1530++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1531 = 0;
    if (_data_k_1531 >= _data_n_1531) {
      _data_k_1531 = 0;
    }
    bm12cs_[24] = _data_l_1531[_data_k_1531++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1532 = 0;
    if (_data_k_1532 >= _data_n_1532) {
      _data_k_1532 = 0;
    }
    bm12cs_[25] = _data_l_1532[_data_k_1532++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1533 = 0;
    if (_data_k_1533 >= _data_n_1533) {
      _data_k_1533 = 0;
    }
    bm12cs_[26] = _data_l_1533[_data_k_1533++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1534 = 0;
    if (_data_k_1534 >= _data_n_1534) {
      _data_k_1534 = 0;
    }
    bm12cs_[27] = _data_l_1534[_data_k_1534++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1535 = 0;
    if (_data_k_1535 >= _data_n_1535) {
      _data_k_1535 = 0;
    }
    bm12cs_[28] = _data_l_1535[_data_k_1535++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1536 = 0;
    if (_data_k_1536 >= _data_n_1536) {
      _data_k_1536 = 0;
    }
    bm12cs_[29] = _data_l_1536[_data_k_1536++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1537 = 0;
    if (_data_k_1537 >= _data_n_1537) {
      _data_k_1537 = 0;
    }
    bm12cs_[30] = _data_l_1537[_data_k_1537++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1538 = 0;
    if (_data_k_1538 >= _data_n_1538) {
      _data_k_1538 = 0;
    }
    bm12cs_[31] = _data_l_1538[_data_k_1538++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1539 = 0;
    if (_data_k_1539 >= _data_n_1539) {
      _data_k_1539 = 0;
    }
    bm12cs_[32] = _data_l_1539[_data_k_1539++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1540 = 0;
    if (_data_k_1540 >= _data_n_1540) {
      _data_k_1540 = 0;
    }
    bm12cs_[33] = _data_l_1540[_data_k_1540++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1541 = 0;
    if (_data_k_1541 >= _data_n_1541) {
      _data_k_1541 = 0;
    }
    bm12cs_[34] = _data_l_1541[_data_k_1541++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1542 = 0;
    if (_data_k_1542 >= _data_n_1542) {
      _data_k_1542 = 0;
    }
    bm12cs_[35] = _data_l_1542[_data_k_1542++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1543 = 0;
    if (_data_k_1543 >= _data_n_1543) {
      _data_k_1543 = 0;
    }
    bm12cs_[36] = _data_l_1543[_data_k_1543++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1544 = 0;
    if (_data_k_1544 >= _data_n_1544) {
      _data_k_1544 = 0;
    }
    bm12cs_[37] = _data_l_1544[_data_k_1544++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1545 = 0;
    if (_data_k_1545 >= _data_n_1545) {
      _data_k_1545 = 0;
    }
    bm12cs_[38] = _data_l_1545[_data_k_1545++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1546 = 0;
    if (_data_k_1546 >= _data_n_1546) {
      _data_k_1546 = 0;
    }
    bm12cs_[39] = _data_l_1546[_data_k_1546++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1547 = 0;
    if (_data_k_1547 >= _data_n_1547) {
      _data_k_1547 = 0;
    }
    bth1cs_[0] = _data_l_1547[_data_k_1547++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1548 = 0;
    if (_data_k_1548 >= _data_n_1548) {
      _data_k_1548 = 0;
    }
    bth1cs_[1] = _data_l_1548[_data_k_1548++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1549 = 0;
    if (_data_k_1549 >= _data_n_1549) {
      _data_k_1549 = 0;
    }
    bth1cs_[2] = _data_l_1549[_data_k_1549++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1550 = 0;
    if (_data_k_1550 >= _data_n_1550) {
      _data_k_1550 = 0;
    }
    bth1cs_[3] = _data_l_1550[_data_k_1550++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1551 = 0;
    if (_data_k_1551 >= _data_n_1551) {
      _data_k_1551 = 0;
    }
    bth1cs_[4] = _data_l_1551[_data_k_1551++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1552 = 0;
    if (_data_k_1552 >= _data_n_1552) {
      _data_k_1552 = 0;
    }
    bth1cs_[5] = _data_l_1552[_data_k_1552++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1553 = 0;
    if (_data_k_1553 >= _data_n_1553) {
      _data_k_1553 = 0;
    }
    bth1cs_[6] = _data_l_1553[_data_k_1553++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1554 = 0;
    if (_data_k_1554 >= _data_n_1554) {
      _data_k_1554 = 0;
    }
    bth1cs_[7] = _data_l_1554[_data_k_1554++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1555 = 0;
    if (_data_k_1555 >= _data_n_1555) {
      _data_k_1555 = 0;
    }
    bth1cs_[8] = _data_l_1555[_data_k_1555++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1556 = 0;
    if (_data_k_1556 >= _data_n_1556) {
      _data_k_1556 = 0;
    }
    bth1cs_[9] = _data_l_1556[_data_k_1556++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1557 = 0;
    if (_data_k_1557 >= _data_n_1557) {
      _data_k_1557 = 0;
    }
    bth1cs_[10] = _data_l_1557[_data_k_1557++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1558 = 0;
    if (_data_k_1558 >= _data_n_1558) {
      _data_k_1558 = 0;
    }
    bth1cs_[11] = _data_l_1558[_data_k_1558++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1559 = 0;
    if (_data_k_1559 >= _data_n_1559) {
      _data_k_1559 = 0;
    }
    bth1cs_[12] = _data_l_1559[_data_k_1559++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1560 = 0;
    if (_data_k_1560 >= _data_n_1560) {
      _data_k_1560 = 0;
    }
    bth1cs_[13] = _data_l_1560[_data_k_1560++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1561 = 0;
    if (_data_k_1561 >= _data_n_1561) {
      _data_k_1561 = 0;
    }
    bth1cs_[14] = _data_l_1561[_data_k_1561++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1562 = 0;
    if (_data_k_1562 >= _data_n_1562) {
      _data_k_1562 = 0;
    }
    bth1cs_[15] = _data_l_1562[_data_k_1562++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1563 = 0;
    if (_data_k_1563 >= _data_n_1563) {
      _data_k_1563 = 0;
    }
    bth1cs_[16] = _data_l_1563[_data_k_1563++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1564 = 0;
    if (_data_k_1564 >= _data_n_1564) {
      _data_k_1564 = 0;
    }
    bth1cs_[17] = _data_l_1564[_data_k_1564++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1565 = 0;
    if (_data_k_1565 >= _data_n_1565) {
      _data_k_1565 = 0;
    }
    bth1cs_[18] = _data_l_1565[_data_k_1565++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1566 = 0;
    if (_data_k_1566 >= _data_n_1566) {
      _data_k_1566 = 0;
    }
    bth1cs_[19] = _data_l_1566[_data_k_1566++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1567 = 0;
    if (_data_k_1567 >= _data_n_1567) {
      _data_k_1567 = 0;
    }
    bth1cs_[20] = _data_l_1567[_data_k_1567++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1568 = 0;
    if (_data_k_1568 >= _data_n_1568) {
      _data_k_1568 = 0;
    }
    bth1cs_[21] = _data_l_1568[_data_k_1568++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1569 = 0;
    if (_data_k_1569 >= _data_n_1569) {
      _data_k_1569 = 0;
    }
    bth1cs_[22] = _data_l_1569[_data_k_1569++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1570 = 0;
    if (_data_k_1570 >= _data_n_1570) {
      _data_k_1570 = 0;
    }
    bth1cs_[23] = _data_l_1570[_data_k_1570++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1571 = 0;
    if (_data_k_1571 >= _data_n_1571) {
      _data_k_1571 = 0;
    }
    bth1cs_[24] = _data_l_1571[_data_k_1571++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1572 = 0;
    if (_data_k_1572 >= _data_n_1572) {
      _data_k_1572 = 0;
    }
    bth1cs_[25] = _data_l_1572[_data_k_1572++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1573 = 0;
    if (_data_k_1573 >= _data_n_1573) {
      _data_k_1573 = 0;
    }
    bth1cs_[26] = _data_l_1573[_data_k_1573++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1574 = 0;
    if (_data_k_1574 >= _data_n_1574) {
      _data_k_1574 = 0;
    }
    bth1cs_[27] = _data_l_1574[_data_k_1574++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1575 = 0;
    if (_data_k_1575 >= _data_n_1575) {
      _data_k_1575 = 0;
    }
    bth1cs_[28] = _data_l_1575[_data_k_1575++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1576 = 0;
    if (_data_k_1576 >= _data_n_1576) {
      _data_k_1576 = 0;
    }
    bth1cs_[29] = _data_l_1576[_data_k_1576++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1577 = 0;
    if (_data_k_1577 >= _data_n_1577) {
      _data_k_1577 = 0;
    }
    bth1cs_[30] = _data_l_1577[_data_k_1577++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1578 = 0;
    if (_data_k_1578 >= _data_n_1578) {
      _data_k_1578 = 0;
    }
    bth1cs_[31] = _data_l_1578[_data_k_1578++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1579 = 0;
    if (_data_k_1579 >= _data_n_1579) {
      _data_k_1579 = 0;
    }
    bth1cs_[32] = _data_l_1579[_data_k_1579++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1580 = 0;
    if (_data_k_1580 >= _data_n_1580) {
      _data_k_1580 = 0;
    }
    bth1cs_[33] = _data_l_1580[_data_k_1580++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1581 = 0;
    if (_data_k_1581 >= _data_n_1581) {
      _data_k_1581 = 0;
    }
    bth1cs_[34] = _data_l_1581[_data_k_1581++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1582 = 0;
    if (_data_k_1582 >= _data_n_1582) {
      _data_k_1582 = 0;
    }
    bth1cs_[35] = _data_l_1582[_data_k_1582++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1583 = 0;
    if (_data_k_1583 >= _data_n_1583) {
      _data_k_1583 = 0;
    }
    bth1cs_[36] = _data_l_1583[_data_k_1583++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1584 = 0;
    if (_data_k_1584 >= _data_n_1584) {
      _data_k_1584 = 0;
    }
    bth1cs_[37] = _data_l_1584[_data_k_1584++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1585 = 0;
    if (_data_k_1585 >= _data_n_1585) {
      _data_k_1585 = 0;
    }
    bth1cs_[38] = _data_l_1585[_data_k_1585++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1586 = 0;
    if (_data_k_1586 >= _data_n_1586) {
      _data_k_1586 = 0;
    }
    bth1cs_[39] = _data_l_1586[_data_k_1586++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1587 = 0;
    if (_data_k_1587 >= _data_n_1587) {
      _data_k_1587 = 0;
    }
    bth1cs_[40] = _data_l_1587[_data_k_1587++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1588 = 0;
    if (_data_k_1588 >= _data_n_1588) {
      _data_k_1588 = 0;
    }
    bth1cs_[41] = _data_l_1588[_data_k_1588++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1589 = 0;
    if (_data_k_1589 >= _data_n_1589) {
      _data_k_1589 = 0;
    }
    bth1cs_[42] = _data_l_1589[_data_k_1589++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1590 = 0;
    if (_data_k_1590 >= _data_n_1590) {
      _data_k_1590 = 0;
    }
    bth1cs_[43] = _data_l_1590[_data_k_1590++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1591 = 0;
    if (_data_k_1591 >= _data_n_1591) {
      _data_k_1591 = 0;
    }
    pi4_ = _data_l_1591[_data_k_1591++];
  }
  if (__calls[98].calls == 0) {
    _data_k_1592 = 0;
    if (_data_k_1592 >= _data_n_1592) {
      _data_k_1592 = 0;
    }
    first_ = _data_l_1592[_data_k_1592++];
  }
  if (first_) {
    eta_ = 0.1 * (real_4) (_d1mach (($0_ = 3, &$0_)));
    nbm1_ = _initds (bm1cs_, ($1_ = 37, &$1_), &eta_);
    nbt12_ = _initds (bt12cs_, ($2_ = 39, &$2_), &eta_);
    nbm12_ = _initds (bm12cs_, ($3_ = 40, &$3_), &eta_);
    nbth1_ = _initds (bth1cs_, ($4_ = 44, &$4_), &eta_);
    xmax_ = 1.0e0 / _d1mach (($5_ = 4, &$5_));
  }
  first_ = FALSE;
  if ((*x_) < 4.0e0) {
    (void) _xermsg (_dc_0, _dc_155, _dc_156, &_k1, ($6_ = 2, &$6_));
    (*ampl_) = 0.0;
    (*theta_) = 0.0;
  }
  else if ((*x_) <= 8.0e0) {
    z_ = (128.0e0 / ((*x_) * (*x_)) - 5.0e0) / 3.0e0;
    (*ampl_) = (0.75e0 + _dcsevl (&z_, bm1cs_, &nbm1_)) / sqrt ((*x_));
    (*theta_) = (*x_) - 3.0e0 * pi4_ + _dcsevl (&z_, bt12cs_, &nbt12_) / (*x_);
  }
  else {
    if ((*x_) > xmax_) {
      (void) _xermsg (_dc_0, _dc_155, _dc_157, ($7_ = 2, &$7_), ($8_ = 2, &$8_));
    }
    z_ = 128.0e0 / ((*x_) * (*x_)) - 1.0e0;
    (*ampl_) = (0.75e0 + _dcsevl (&z_, bm12cs_, &nbm12_)) / sqrt ((*x_));
    (*theta_) = (*x_) - 3.0e0 * pi4_ + _dcsevl (&z_, bth1cs_, &nbth1_) / (*x_);
  }
  __calls[98].calls++;
  return 0;
}

real_8 _d9chu (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ z_)
{
  static int_4 i_, j_;
  static logical_4 first_;
  static real_8 aa_[4], bb_[4], ab_, anbn_, bp_, ct1_, ct2_, ct3_, c2_, d1z_, eps_, g1_, g2_, g3_, sab_, sqeps_, x2i1_;
  int_4 _data_k_1593, $0_, $1_, $2_, $3_, $4_;
  real_8 d9chu_;
  extern real_8 _d1mach ();
#define _data_n_1593 1
  static logical_4 _data_l_1593[_data_n_1593] = {
    TRUE
  };
  if (__calls[99].calls == 0) {
    _data_k_1593 = 0;
    if (_data_k_1593 >= _data_n_1593) {
      _data_k_1593 = 0;
    }
    first_ = _data_l_1593[_data_k_1593++];
  }
  if (first_) {
    eps_ = 4.0e0 * _d1mach (($0_ = 4, &$0_));
    sqeps_ = sqrt (_d1mach (($1_ = 4, &$1_)));
  }
  first_ = FALSE;
  bp_ = 1.0e0 + (*a_) - (*b_);
  ab_ = (*a_) * bp_;
  ct2_ = 2.0e0 * ((*z_) - ab_);
  sab_ = (*a_) + bp_;
  bb_[0] = 1.0;
  aa_[0] = 1.0;
  ct3_ = sab_ + 1.0e0 + ab_;
  bb_[1] = 1.0e0 + 2.0e0 * (*z_) / ct3_;
  aa_[1] = 1.0e0 + ct2_ / ct3_;
  anbn_ = ct3_ + sab_ + 3.0e0;
  ct1_ = 1.0e0 + 2.0e0 * (*z_) / anbn_;
  bb_[2] = 1.0e0 + 6.0e0 * ct1_ * (*z_) / ct3_;
  aa_[2] = 1.0e0 + 6.0e0 * ab_ / anbn_ + 3.0e0 * ct1_ * ct2_ / ct3_;
  for (i_ = 4; i_ <= 300; (i_)++) {
    x2i1_ = 2 * i_ - 3;
    ct1_ = x2i1_ / (x2i1_ - 2.0e0);
    anbn_ = anbn_ + x2i1_ + sab_;
    ct2_ = (x2i1_ - 1.0e0) / anbn_;
    c2_ = x2i1_ * ct2_ - 1.0e0;
    d1z_ = x2i1_ * 2.0e0 * (*z_) / anbn_;
    ct3_ = sab_ * ct2_;
    g1_ = d1z_ + ct1_ * (c2_ + ct3_);
    g2_ = d1z_ - c2_;
    g3_ = ct1_ * (1.0e0 - ct3_ - 2.0e0 * ct2_);
    bb_[3] = g1_ * bb_[2] + g2_ * bb_[1] + g3_ * bb_[0];
    aa_[3] = g1_ * aa_[2] + g2_ * aa_[1] + g3_ * aa_[0];
    if (_abs (aa_[3] * bb_[0] - aa_[0] * bb_[3]) < eps_ * _abs (bb_[3] * bb_[0])) {
      goto _l40;
    }
    for (j_ = 1; j_ <= 3; (j_)++) {
      aa_[j_ - 1] = aa_[j_ + 1 - 1];
      bb_[j_ - 1] = bb_[j_ + 1 - 1];
    }
  }
  (void) _xermsg (_dc_0, _dc_158, _dc_159, ($2_ = 2, &$2_), ($3_ = 2, &$3_));
  _l40:;
  d9chu_ = aa_[3] / bb_[3];
  if (d9chu_ < sqeps_ || d9chu_ > 1.0e0 / sqeps_) {
    (void) _xermsg (_dc_0, _dc_158, _dc_160, ($4_ = 2, &$4_), &_k1);
  }
  __calls[99].calls++;
  return d9chu_;
}

real_8 _d9gmic (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ alx_)
{
  static int_4 m_, k_, mm1_;
  static logical_4 first_;
  static real_8 alng_, bot_, eps_, euler_, fk_, fkp1_, fm_, s_, sgng_, t_, te_, dlngam_;
  int_4 _data_k_1594, _data_k_1595, $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  real_8 d9gmic_;
  extern real_8 _d1mach ();
#define _data_n_1594 1
  static real_8 _data_l_1594[_data_n_1594] = {
    0.5772156649015328606065120900824e0
  };
#define _data_n_1595 1
  static logical_4 _data_l_1595[_data_n_1595] = {
    TRUE
  };
  if (__calls[100].calls == 0) {
    _data_k_1594 = 0;
    if (_data_k_1594 >= _data_n_1594) {
      _data_k_1594 = 0;
    }
    euler_ = _data_l_1594[_data_k_1594++];
  }
  if (__calls[100].calls == 0) {
    _data_k_1595 = 0;
    if (_data_k_1595 >= _data_n_1595) {
      _data_k_1595 = 0;
    }
    first_ = _data_l_1595[_data_k_1595++];
  }
  if (first_) {
    eps_ = 0.5e0 * _d1mach (($0_ = 3, &$0_));
    bot_ = log (_d1mach (&_k1));
  }
  first_ = FALSE;
  if ((*a_) > 0.0e0) {
    (void) _xermsg (_dc_0, _dc_161, _dc_162, ($1_ = 2, &$1_), ($2_ = 2, &$2_));
  }
  if ((*x_) <= 0.0e0) {
    (void) _xermsg (_dc_0, _dc_161, _dc_163, ($3_ = 3, &$3_), ($4_ = 2, &$4_));
  }
  m_ = -((*a_) - 0.5e0);
  fm_ = m_;
  te_ = 1.0;
  t_ = 1.0;
  s_ = t_;
  for (k_ = 1; k_ <= 200; (k_)++) {
    fkp1_ = k_ + 1;
    te_ = -(*x_) * te_ / (fm_ + fkp1_);
    t_ = te_ / fkp1_;
    s_ = s_ + t_;
    if (_abs (t_) < eps_ * s_) {
      goto _l30;
    }
  }
  (void) _xermsg (_dc_0, _dc_161, _dc_164, ($5_ = 4, &$5_), ($6_ = 2, &$6_));
  _l30:;
  d9gmic_ = -(*alx_) - euler_ + (*x_) * s_ / (fm_ + 1.0e0);
  if (m_ == 0) {
    goto _l0;
  }
  if (m_ == 1) {
    d9gmic_ = -d9gmic_ - 1.0e0 + 1.0e0 / (*x_);
  }
  if (m_ == 1) {
    goto _l0;
  }
  te_ = fm_;
  t_ = 1.0;
  s_ = t_;
  mm1_ = m_ - 1;
  for (k_ = 1; k_ <= mm1_; (k_)++) {
    fk_ = k_;
    te_ = -(*x_) * te_ / fk_;
    t_ = te_ / (fm_ - fk_);
    s_ = s_ + t_;
    if (_abs (t_) < eps_ * _abs (s_)) {
      goto _l50;
    }
  }
  _l50:;
  for (k_ = 1; k_ <= m_; (k_)++) {
    d9gmic_ = d9gmic_ + 1.0e0 / k_;
  }
  sgng_ = 1.0;
  if (_imod (m_, 2) == 1) {
    sgng_ = -1.0;
  }
  alng_ = log (d9gmic_) - lgamma (fm_ + 1.0e0);
  d9gmic_ = 0.0;
  if (alng_ > bot_) {
    d9gmic_ = sgng_ * exp (alng_);
  }
  if (s_ != 0.0e0) {
    d9gmic_ = d9gmic_ + _sign (exp (-fm_ * (*alx_) + log (_abs (s_) / fm_)), s_);
  }
  if (d9gmic_ == 0.0e0 && s_ == 0.0e0) {
    (void) _xermsg (_dc_0, _dc_161, _dc_165, &_k1, &_k1);
  }
  _l0:;
  __calls[100].calls++;
  return d9gmic_;
}

real_8 _d9gmit (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ algap1_, real_8 _p_ sgngam_, real_8 _p_ alx_)
{
  static int_4 ma_, k_, m_;
  static logical_4 first_;
  static real_8 ae_, aeps_, algs_, alg2_, bot_, eps_, fk_, s_, sgng2_, t_, te_, dlngam_;
  int_4 _data_k_1596, $0_, $1_, $2_, $3_;
  real_8 d9gmit_;
  extern real_8 _d1mach ();
#define _data_n_1596 1
  static logical_4 _data_l_1596[_data_n_1596] = {
    TRUE
  };
  if (__calls[101].calls == 0) {
    _data_k_1596 = 0;
    if (_data_k_1596 >= _data_n_1596) {
      _data_k_1596 = 0;
    }
    first_ = _data_l_1596[_data_k_1596++];
  }
  if (first_) {
    eps_ = 0.5e0 * _d1mach (($0_ = 3, &$0_));
    bot_ = log (_d1mach (&_k1));
  }
  first_ = FALSE;
  if ((*x_) <= 0.0e0) {
    (void) _xermsg (_dc_0, _dc_166, _dc_167, &_k1, ($1_ = 2, &$1_));
  }
  ma_ = (*a_) + 0.5e0;
  if ((*a_) < 0.0e0) {
    ma_ = (*a_) - 0.5e0;
  }
  aeps_ = (*a_) - ma_;
  ae_ = (*a_);
  if ((*a_) < -0.5) {
    ae_ = aeps_;
  }
  t_ = 1.0;
  te_ = ae_;
  s_ = t_;
  for (k_ = 1; k_ <= 200; (k_)++) {
    fk_ = k_;
    te_ = -(*x_) * te_ / fk_;
    t_ = te_ / (ae_ + fk_);
    s_ = s_ + t_;
    if (_abs (t_) < eps_ * _abs (s_)) {
      goto _l30;
    }
  }
  (void) _xermsg (_dc_0, _dc_166, _dc_168, ($2_ = 2, &$2_), ($3_ = 2, &$3_));
  _l30:;
  if ((*a_) >= -0.5) {
    algs_ = -(*algap1_) + log (s_);
  }
  if ((*a_) >= -0.5) {
    goto _l60;
  }
  algs_ = -lgamma (1.0e0 + aeps_) + log (s_);
  s_ = 1.0;
  m_ = -ma_ - 1;
  if (m_ == 0) {
    goto _l50;
  }
  t_ = 1.0;
  for (k_ = 1; k_ <= m_; (k_)++) {
    t_ = (*x_) * t_ / (aeps_ - (m_ + 1 - k_));
    s_ = s_ + t_;
    if (_abs (t_) < eps_ * _abs (s_)) {
      goto _l50;
    }
  }
  _l50:;
  d9gmit_ = 0.0;
  algs_ = -ma_ * log ((*x_)) + algs_;
  if (s_ == 0.0e0 || aeps_ == 0.0e0) {
    goto _l60;
  }
  sgng2_ = (*sgngam_) * _sign (1.0, s_);
  alg2_ = -(*x_) - (*algap1_) + log (_abs (s_));
  if (alg2_ > bot_) {
    d9gmit_ = sgng2_ * exp (alg2_);
  }
  if (algs_ > bot_) {
    d9gmit_ = d9gmit_ + exp (algs_);
  }
  goto _l0;
  _l60:;
  d9gmit_ = exp (algs_);
  _l0:;
  __calls[101].calls++;
  return d9gmit_;
}

int_4 _d9knus (real_8 _p_ xnu_, real_8 _p_ x_, real_8 _p_ bknu_, real_8 _p_ bknu1_, int_4 _p_ iswtch_)
{
  static int_4 ntc0k_, ntznu1_, nterms_, i_, ii_, inu_, n_;
  static logical_4 first_;
  static real_4 alneps_, eta_, an_, bn_;
  static real_8 alpha_[32], beta_[32], a_[32], c0kcs_[29], znu1cs_[20], alnz_, aln2_, a0_, bknud_, bknu0_, b0_, c0_, 
  euler_, expx_, p1_, p2_, p3_, qq_, result_, sqpi2_, sqrtx_, v_, vlnz_, xi_, xmu_, xnusml_, xsml_, x2n_, x2tov_, z_, 
  ztov_, alnsml_, alnbig_;
  int_4 _data_k_1597, _data_k_1598, _data_k_1599, _data_k_1600, _data_k_1601, _data_k_1602, _data_k_1603, _data_k_1604, 
  _data_k_1605, _data_k_1606, _data_k_1607, _data_k_1608, _data_k_1609, _data_k_1610, _data_k_1611, _data_k_1612, 
  _data_k_1613, _data_k_1614, _data_k_1615, _data_k_1616, _data_k_1617, _data_k_1618, _data_k_1619, _data_k_1620, 
  _data_k_1621, _data_k_1622, _data_k_1623, _data_k_1624, _data_k_1625, _data_k_1626, _data_k_1627, _data_k_1628, 
  _data_k_1629, _data_k_1630, _data_k_1631, _data_k_1632, _data_k_1633, _data_k_1634, _data_k_1635, _data_k_1636, 
  _data_k_1637, _data_k_1638, _data_k_1639, _data_k_1640, _data_k_1641, _data_k_1642, _data_k_1643, _data_k_1644, 
  _data_k_1645, _data_k_1646, _data_k_1647, _data_k_1648, _data_k_1649, $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, 
  $10_, $11_;
  real_8 $12_, $13_, $14_, $15_, $16_, $17_;
  extern real_8 _d1mach ();
  extern real_8 _dgamma ();
#define _data_n_1597 1
  static real_8 _data_l_1597[_data_n_1597] = {
    .60183057242626108387577445180329e-1
  };
#define _data_n_1598 1
  static real_8 _data_l_1598[_data_n_1598] = {
    -.15364871433017286092959755943124e+0
  };
#define _data_n_1599 1
  static real_8 _data_l_1599[_data_n_1599] = {
    -.11751176008210492040068229226213e-1
  };
#define _data_n_1600 1
  static real_8 _data_l_1600[_data_n_1600] = {
    -.85248788891979509827048401550987e-3
  };
#define _data_n_1601 1
  static real_8 _data_l_1601[_data_n_1601] = {
    -.61329838767496791874098176922111e-4
  };
#define _data_n_1602 1
  static real_8 _data_l_1602[_data_n_1602] = {
    -.44052281245510444562679889548505e-5
  };
#define _data_n_1603 1
  static real_8 _data_l_1603[_data_n_1603] = {
    -.31631246728384488192915445892199e-6
  };
#define _data_n_1604 1
  static real_8 _data_l_1604[_data_n_1604] = {
    -.22710719382899588330673771793396e-7
  };
#define _data_n_1605 1
  static real_8 _data_l_1605[_data_n_1605] = {
    -.1630564460807760955227462051536e-8
  };
#define _data_n_1606 1
  static real_8 _data_l_1606[_data_n_1606] = {
    -.1170693929941477656875604404313e-9
  };
#define _data_n_1607 1
  static real_8 _data_l_1607[_data_n_1607] = {
    -.84052063786464437174546593413792e-11
  };
#define _data_n_1608 1
  static real_8 _data_l_1608[_data_n_1608] = {
    -.60346670118979991487096050737198e-12
  };
#define _data_n_1609 1
  static real_8 _data_l_1609[_data_n_1609] = {
    -.43326960335681371952045997366903e-13
  };
#define _data_n_1610 1
  static real_8 _data_l_1610[_data_n_1610] = {
    -.31107358030203546214634697772237e-14
  };
#define _data_n_1611 1
  static real_8 _data_l_1611[_data_n_1611] = {
    -.2233407822673698225448613340984e-15
  };
#define _data_n_1612 1
  static real_8 _data_l_1612[_data_n_1612] = {
    -.1603514671686422630063579152861e-16
  };
#define _data_n_1613 1
  static real_8 _data_l_1613[_data_n_1613] = {
    -.11512717363666556196035697705305e-17
  };
#define _data_n_1614 1
  static real_8 _data_l_1614[_data_n_1614] = {
    -.82657591746836959105169479089258e-19
  };
#define _data_n_1615 1
  static real_8 _data_l_1615[_data_n_1615] = {
    -.59345480806383948172333436695984e-20
  };
#define _data_n_1616 1
  static real_8 _data_l_1616[_data_n_1616] = {
    -.42608138196467143926499613023976e-21
  };
#define _data_n_1617 1
  static real_8 _data_l_1617[_data_n_1617] = {
    -.30591266864812876299263698370542e-22
  };
#define _data_n_1618 1
  static real_8 _data_l_1618[_data_n_1618] = {
    -.21963541426734575224975501815516e-23
  };
#define _data_n_1619 1
  static real_8 _data_l_1619[_data_n_1619] = {
    -.1576911326149583607110575068476e-24
  };
#define _data_n_1620 1
  static real_8 _data_l_1620[_data_n_1620] = {
    -.11321713935950320948757731048056e-25
  };
#define _data_n_1621 1
  static real_8 _data_l_1621[_data_n_1621] = {
    -.81286248834598404082792349714433e-27
  };
#define _data_n_1622 1
  static real_8 _data_l_1622[_data_n_1622] = {
    -.58360900893453226552829349315949e-28
  };
#define _data_n_1623 1
  static real_8 _data_l_1623[_data_n_1623] = {
    -.41901241623610922519452337780905e-29
  };
#define _data_n_1624 1
  static real_8 _data_l_1624[_data_n_1624] = {
    -.30083737960206435069530504212862e-30
  };
#define _data_n_1625 1
  static real_8 _data_l_1625[_data_n_1625] = {
    -.21599152067808647728342168089832e-31
  };
#define _data_n_1626 1
  static real_8 _data_l_1626[_data_n_1626] = {
    .203306756994191729674444001216911e+0
  };
#define _data_n_1627 1
  static real_8 _data_l_1627[_data_n_1627] = {
    .140077933413219771062943670790563e+0
  };
#define _data_n_1628 1
  static real_8 _data_l_1628[_data_n_1628] = {
    .79167969610016135284097224197232e-2
  };
#define _data_n_1629 1
  static real_8 _data_l_1629[_data_n_1629] = {
    .33980118253210404535293009220575e-3
  };
#define _data_n_1630 1
  static real_8 _data_l_1630[_data_n_1630] = {
    .11741975688989336666450722835269e-4
  };
#define _data_n_1631 1
  static real_8 _data_l_1631[_data_n_1631] = {
    .339357570612261680333825865475121e-6
  };
#define _data_n_1632 1
  static real_8 _data_l_1632[_data_n_1632] = {
    .842594176976219910194629891264803e-8
  };
#define _data_n_1633 1
  static real_8 _data_l_1633[_data_n_1633] = {
    .18333667702485008918474815090009e-9
  };
#define _data_n_1634 1
  static real_8 _data_l_1634[_data_n_1634] = {
    .354969844704416310863007064469557e-11
  };
#define _data_n_1635 1
  static real_8 _data_l_1635[_data_n_1635] = {
    .619032496469887332205244342078407e-13
  };
#define _data_n_1636 1
  static real_8 _data_l_1636[_data_n_1636] = {
    .981964535680439424960346115456527e-15
  };
#define _data_n_1637 1
  static real_8 _data_l_1637[_data_n_1637] = {
    .142851314396490474211473563005985e-16
  };
#define _data_n_1638 1
  static real_8 _data_l_1638[_data_n_1638] = {
    .191894921887825298966162467488436e-18
  };
#define _data_n_1639 1
  static real_8 _data_l_1639[_data_n_1639] = {
    .239430979739498914162313140597128e-20
  };
#define _data_n_1640 1
  static real_8 _data_l_1640[_data_n_1640] = {
    .278890246815347354835870465474995e-22
  };
#define _data_n_1641 1
  static real_8 _data_l_1641[_data_n_1641] = {
    .304606650633033442582845214092865e-24
  };
#define _data_n_1642 1
  static real_8 _data_l_1642[_data_n_1642] = {
    .313173237042191815771564260932089e-26
  };
#define _data_n_1643 1
  static real_8 _data_l_1643[_data_n_1643] = {
    .304133098987854951645174908005034e-28
  };
#define _data_n_1644 1
  static real_8 _data_l_1644[_data_n_1644] = {
    .279840384636833084343185097659733e-30
  };
#define _data_n_1645 1
  static real_8 _data_l_1645[_data_n_1645] = {
    .244637186274497596485238794922666e-32
  };
#define _data_n_1646 1
  static real_8 _data_l_1646[_data_n_1646] = {
    0.5772156649015328606065120900824e0
  };
#define _data_n_1647 1
  static real_8 _data_l_1647[_data_n_1647] = {
    1.2533141373155002512078826424055e0
  };
#define _data_n_1648 1
  static real_8 _data_l_1648[_data_n_1648] = {
    0.69314718055994530941723212145818e0
  };
#define _data_n_1649 1
  static logical_4 _data_l_1649[_data_n_1649] = {
    TRUE
  };
  if (__calls[102].calls == 0) {
    _data_k_1597 = 0;
    if (_data_k_1597 >= _data_n_1597) {
      _data_k_1597 = 0;
    }
    c0kcs_[0] = _data_l_1597[_data_k_1597++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1598 = 0;
    if (_data_k_1598 >= _data_n_1598) {
      _data_k_1598 = 0;
    }
    c0kcs_[1] = _data_l_1598[_data_k_1598++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1599 = 0;
    if (_data_k_1599 >= _data_n_1599) {
      _data_k_1599 = 0;
    }
    c0kcs_[2] = _data_l_1599[_data_k_1599++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1600 = 0;
    if (_data_k_1600 >= _data_n_1600) {
      _data_k_1600 = 0;
    }
    c0kcs_[3] = _data_l_1600[_data_k_1600++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1601 = 0;
    if (_data_k_1601 >= _data_n_1601) {
      _data_k_1601 = 0;
    }
    c0kcs_[4] = _data_l_1601[_data_k_1601++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1602 = 0;
    if (_data_k_1602 >= _data_n_1602) {
      _data_k_1602 = 0;
    }
    c0kcs_[5] = _data_l_1602[_data_k_1602++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1603 = 0;
    if (_data_k_1603 >= _data_n_1603) {
      _data_k_1603 = 0;
    }
    c0kcs_[6] = _data_l_1603[_data_k_1603++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1604 = 0;
    if (_data_k_1604 >= _data_n_1604) {
      _data_k_1604 = 0;
    }
    c0kcs_[7] = _data_l_1604[_data_k_1604++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1605 = 0;
    if (_data_k_1605 >= _data_n_1605) {
      _data_k_1605 = 0;
    }
    c0kcs_[8] = _data_l_1605[_data_k_1605++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1606 = 0;
    if (_data_k_1606 >= _data_n_1606) {
      _data_k_1606 = 0;
    }
    c0kcs_[9] = _data_l_1606[_data_k_1606++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1607 = 0;
    if (_data_k_1607 >= _data_n_1607) {
      _data_k_1607 = 0;
    }
    c0kcs_[10] = _data_l_1607[_data_k_1607++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1608 = 0;
    if (_data_k_1608 >= _data_n_1608) {
      _data_k_1608 = 0;
    }
    c0kcs_[11] = _data_l_1608[_data_k_1608++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1609 = 0;
    if (_data_k_1609 >= _data_n_1609) {
      _data_k_1609 = 0;
    }
    c0kcs_[12] = _data_l_1609[_data_k_1609++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1610 = 0;
    if (_data_k_1610 >= _data_n_1610) {
      _data_k_1610 = 0;
    }
    c0kcs_[13] = _data_l_1610[_data_k_1610++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1611 = 0;
    if (_data_k_1611 >= _data_n_1611) {
      _data_k_1611 = 0;
    }
    c0kcs_[14] = _data_l_1611[_data_k_1611++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1612 = 0;
    if (_data_k_1612 >= _data_n_1612) {
      _data_k_1612 = 0;
    }
    c0kcs_[15] = _data_l_1612[_data_k_1612++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1613 = 0;
    if (_data_k_1613 >= _data_n_1613) {
      _data_k_1613 = 0;
    }
    c0kcs_[16] = _data_l_1613[_data_k_1613++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1614 = 0;
    if (_data_k_1614 >= _data_n_1614) {
      _data_k_1614 = 0;
    }
    c0kcs_[17] = _data_l_1614[_data_k_1614++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1615 = 0;
    if (_data_k_1615 >= _data_n_1615) {
      _data_k_1615 = 0;
    }
    c0kcs_[18] = _data_l_1615[_data_k_1615++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1616 = 0;
    if (_data_k_1616 >= _data_n_1616) {
      _data_k_1616 = 0;
    }
    c0kcs_[19] = _data_l_1616[_data_k_1616++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1617 = 0;
    if (_data_k_1617 >= _data_n_1617) {
      _data_k_1617 = 0;
    }
    c0kcs_[20] = _data_l_1617[_data_k_1617++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1618 = 0;
    if (_data_k_1618 >= _data_n_1618) {
      _data_k_1618 = 0;
    }
    c0kcs_[21] = _data_l_1618[_data_k_1618++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1619 = 0;
    if (_data_k_1619 >= _data_n_1619) {
      _data_k_1619 = 0;
    }
    c0kcs_[22] = _data_l_1619[_data_k_1619++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1620 = 0;
    if (_data_k_1620 >= _data_n_1620) {
      _data_k_1620 = 0;
    }
    c0kcs_[23] = _data_l_1620[_data_k_1620++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1621 = 0;
    if (_data_k_1621 >= _data_n_1621) {
      _data_k_1621 = 0;
    }
    c0kcs_[24] = _data_l_1621[_data_k_1621++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1622 = 0;
    if (_data_k_1622 >= _data_n_1622) {
      _data_k_1622 = 0;
    }
    c0kcs_[25] = _data_l_1622[_data_k_1622++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1623 = 0;
    if (_data_k_1623 >= _data_n_1623) {
      _data_k_1623 = 0;
    }
    c0kcs_[26] = _data_l_1623[_data_k_1623++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1624 = 0;
    if (_data_k_1624 >= _data_n_1624) {
      _data_k_1624 = 0;
    }
    c0kcs_[27] = _data_l_1624[_data_k_1624++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1625 = 0;
    if (_data_k_1625 >= _data_n_1625) {
      _data_k_1625 = 0;
    }
    c0kcs_[28] = _data_l_1625[_data_k_1625++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1626 = 0;
    if (_data_k_1626 >= _data_n_1626) {
      _data_k_1626 = 0;
    }
    znu1cs_[0] = _data_l_1626[_data_k_1626++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1627 = 0;
    if (_data_k_1627 >= _data_n_1627) {
      _data_k_1627 = 0;
    }
    znu1cs_[1] = _data_l_1627[_data_k_1627++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1628 = 0;
    if (_data_k_1628 >= _data_n_1628) {
      _data_k_1628 = 0;
    }
    znu1cs_[2] = _data_l_1628[_data_k_1628++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1629 = 0;
    if (_data_k_1629 >= _data_n_1629) {
      _data_k_1629 = 0;
    }
    znu1cs_[3] = _data_l_1629[_data_k_1629++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1630 = 0;
    if (_data_k_1630 >= _data_n_1630) {
      _data_k_1630 = 0;
    }
    znu1cs_[4] = _data_l_1630[_data_k_1630++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1631 = 0;
    if (_data_k_1631 >= _data_n_1631) {
      _data_k_1631 = 0;
    }
    znu1cs_[5] = _data_l_1631[_data_k_1631++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1632 = 0;
    if (_data_k_1632 >= _data_n_1632) {
      _data_k_1632 = 0;
    }
    znu1cs_[6] = _data_l_1632[_data_k_1632++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1633 = 0;
    if (_data_k_1633 >= _data_n_1633) {
      _data_k_1633 = 0;
    }
    znu1cs_[7] = _data_l_1633[_data_k_1633++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1634 = 0;
    if (_data_k_1634 >= _data_n_1634) {
      _data_k_1634 = 0;
    }
    znu1cs_[8] = _data_l_1634[_data_k_1634++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1635 = 0;
    if (_data_k_1635 >= _data_n_1635) {
      _data_k_1635 = 0;
    }
    znu1cs_[9] = _data_l_1635[_data_k_1635++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1636 = 0;
    if (_data_k_1636 >= _data_n_1636) {
      _data_k_1636 = 0;
    }
    znu1cs_[10] = _data_l_1636[_data_k_1636++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1637 = 0;
    if (_data_k_1637 >= _data_n_1637) {
      _data_k_1637 = 0;
    }
    znu1cs_[11] = _data_l_1637[_data_k_1637++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1638 = 0;
    if (_data_k_1638 >= _data_n_1638) {
      _data_k_1638 = 0;
    }
    znu1cs_[12] = _data_l_1638[_data_k_1638++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1639 = 0;
    if (_data_k_1639 >= _data_n_1639) {
      _data_k_1639 = 0;
    }
    znu1cs_[13] = _data_l_1639[_data_k_1639++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1640 = 0;
    if (_data_k_1640 >= _data_n_1640) {
      _data_k_1640 = 0;
    }
    znu1cs_[14] = _data_l_1640[_data_k_1640++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1641 = 0;
    if (_data_k_1641 >= _data_n_1641) {
      _data_k_1641 = 0;
    }
    znu1cs_[15] = _data_l_1641[_data_k_1641++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1642 = 0;
    if (_data_k_1642 >= _data_n_1642) {
      _data_k_1642 = 0;
    }
    znu1cs_[16] = _data_l_1642[_data_k_1642++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1643 = 0;
    if (_data_k_1643 >= _data_n_1643) {
      _data_k_1643 = 0;
    }
    znu1cs_[17] = _data_l_1643[_data_k_1643++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1644 = 0;
    if (_data_k_1644 >= _data_n_1644) {
      _data_k_1644 = 0;
    }
    znu1cs_[18] = _data_l_1644[_data_k_1644++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1645 = 0;
    if (_data_k_1645 >= _data_n_1645) {
      _data_k_1645 = 0;
    }
    znu1cs_[19] = _data_l_1645[_data_k_1645++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1646 = 0;
    if (_data_k_1646 >= _data_n_1646) {
      _data_k_1646 = 0;
    }
    euler_ = _data_l_1646[_data_k_1646++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1647 = 0;
    if (_data_k_1647 >= _data_n_1647) {
      _data_k_1647 = 0;
    }
    sqpi2_ = _data_l_1647[_data_k_1647++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1648 = 0;
    if (_data_k_1648 >= _data_n_1648) {
      _data_k_1648 = 0;
    }
    aln2_ = _data_l_1648[_data_k_1648++];
  }
  if (__calls[102].calls == 0) {
    _data_k_1649 = 0;
    if (_data_k_1649 >= _data_n_1649) {
      _data_k_1649 = 0;
    }
    first_ = _data_l_1649[_data_k_1649++];
  }
  if (first_) {
    eta_ = 0.1e0 * _d1mach (($0_ = 3, &$0_));
    ntc0k_ = _initds (c0kcs_, ($1_ = 29, &$1_), &eta_);
    ntznu1_ = _initds (znu1cs_, ($2_ = 20, &$2_), &eta_);
    xnusml_ = sqrt (_d1mach (($3_ = 3, &$3_)) / 8.0e0);
    xsml_ = 0.1e0 * _d1mach (($4_ = 3, &$4_));
    alnsml_ = log (_d1mach (&_k1));
    alnbig_ = log (_d1mach (($5_ = 2, &$5_)));
    alneps_ = log (0.1e0 * _d1mach (($6_ = 3, &$6_)));
  }
  first_ = FALSE;
  if ((*xnu_) < 0.0e0 || (*xnu_) >= 1.0e0) {
    (void) _xermsg (_dc_0, _dc_169, _dc_170, &_k1, ($7_ = 2, &$7_));
  }
  if ((*x_) <= 0.0) {
    (void) _xermsg (_dc_0, _dc_169, _dc_171, ($8_ = 2, &$8_), ($9_ = 2, &$9_));
  }
  (*iswtch_) = 0;
  if ((*x_) > 2.0e0) {
    goto _l50;
  }
  v_ = (*xnu_);
  if ((*xnu_) > 0.5e0) {
    v_ = 1.0e0 - (*xnu_);
  }
  alnz_ = 2.0e0 * (log ((*x_)) - aln2_);
  if ((*x_) > (*xnu_)) {
    goto _l20;
  }
  if (-0.5e0 * (*xnu_) * alnz_ - aln2_ - log ((*xnu_)) > alnbig_) {
    (void) _xermsg (_dc_0, _dc_169, _dc_172, ($10_ = 3, &$10_), ($11_ = 2, &$11_));
  }
  _l20:;
  vlnz_ = v_ * alnz_;
  x2tov_ = exp (0.5e0 * vlnz_);
  ztov_ = 0.0;
  if (vlnz_ > alnsml_) {
    ztov_ = (x2tov_ * x2tov_);
  }
  a0_ = 0.5e0 * _dgamma (($12_ = 1.0e0 + v_, &$12_));
  b0_ = 0.5e0 * _dgamma (($13_ = 1.0e0 - v_, &$13_));
  c0_ = -euler_;
  if (ztov_ > 0.5e0 && v_ > xnusml_) {
    c0_ = -0.75e0 + _dcsevl (($14_ = (8.0e0 * v_) * v_ - 1.0e0, &$14_), c0kcs_, &ntc0k_);
  }
  if (ztov_ <= 0.5e0) {
    alpha_[0] = (a0_ - ztov_ * b0_) / v_;
  }
  if (ztov_ > 0.5e0) {
    alpha_[0] = c0_ - alnz_ * (0.75e0 + _dcsevl (($15_ = vlnz_ / 0.35e0 + 1.0e0, &$15_), znu1cs_, &ntznu1_)) * b0_;
  }
  beta_[0] = -0.5e0 * (a0_ + ztov_ * b0_);
  z_ = 0.0;
  if ((*x_) > xsml_) {
    z_ = 0.25e0 * (*x_) * (*x_);
  }
  nterms_ = _max (2.0, 11.0 + (8.0 * (real_4) (alnz_) - 25.19 - alneps_) / (4.28 - (real_4) (alnz_)));
  for (i_ = 2; i_ <= nterms_; (i_)++) {
    xi_ = i_ - 1;
    a0_ = a0_ / (xi_ * (xi_ - v_));
    b0_ = b0_ / (xi_ * (xi_ + v_));
    alpha_[i_ - 1] = (alpha_[i_ - 1 - 1] + 2.0e0 * xi_ * a0_) / (xi_ * (xi_ + v_));
    beta_[i_ - 1] = (xi_ - 0.5e0 * v_) * alpha_[i_ - 1] - ztov_ * b0_;
  }
  (*bknu_) = alpha_[nterms_ - 1];
  bknud_ = beta_[nterms_ - 1];
  for (ii_ = 2; ii_ <= nterms_; (ii_)++) {
    i_ = nterms_ + 1 - ii_;
    (*bknu_) = alpha_[i_ - 1] + (*bknu_) * z_;
    bknud_ = beta_[i_ - 1] + bknud_ * z_;
  }
  expx_ = exp ((*x_));
  (*bknu_) = expx_ * (*bknu_) / x2tov_;
  if (-0.5e0 * ((*xnu_) + 1.0e0) * alnz_ - 2.0e0 * aln2_ > alnbig_) {
    (*iswtch_) = 1;
  }
  if ((*iswtch_) == 1) {
    goto _l0;
  }
  bknud_ = expx_ * bknud_ * 2.0e0 / (x2tov_ * (*x_));
  if ((*xnu_) <= 0.5e0) {
    (*bknu1_) = v_ * (*bknu_) / (*x_) - bknud_;
  }
  if ((*xnu_) <= 0.5e0) {
    goto _l0;
  }
  bknu0_ = (*bknu_);
  (*bknu_) = -v_ * (*bknu_) / (*x_) - bknud_;
  (*bknu1_) = 2.0e0 * (*xnu_) * (*bknu_) / (*x_) + bknu0_;
  goto _l0;
  _l50:;
  sqrtx_ = sqrt ((*x_));
  if ((*x_) > 1.0e0 / xsml_) {
    goto _l90;
  }
  an_ = -0.6 - 1.02 / (real_4) ((*x_));
  bn_ = -0.27 - 0.53 / (real_4) ((*x_));
  nterms_ = _min (32, (int_4) (_max (3.0, an_ + bn_ * alneps_)));
  for (inu_ = 1; inu_ <= 2; (inu_)++) {
    xmu_ = 0.0;
    if (inu_ == 1 && (*xnu_) > xnusml_) {
      xmu_ = (4.0e0 * (*xnu_)) * (*xnu_);
    }
    if (inu_ == 2) {
      xmu_ = 4.0e0 * ($16_ = (_abs ((*xnu_)) + 1.0e0), $16_ * $16_);
    }
    a_[0] = 1.0e0 - xmu_;
    a_[1] = 9.0e0 - xmu_;
    a_[2] = 25.0e0 - xmu_;
    if (a_[1] == 0.0e0) {
      result_ = sqpi2_ * (16.0e0 * (*x_) + xmu_ + 7.0e0) / (16.0e0 * (*x_) * sqrtx_);
    }
    if (a_[1] == 0.0e0) {
      goto _l70;
    }
    alpha_[0] = 1.0;
    alpha_[1] = (16.0e0 * (*x_) + a_[1]) / a_[1];
    alpha_[2] = ((768.0e0 * (*x_) + 48.0e0 * a_[2]) * (*x_) + a_[1] * a_[2]) / (a_[1] * a_[2]);
    beta_[0] = 1.0;
    beta_[1] = (16.0e0 * (*x_) + (xmu_ + 7.0e0)) / a_[1];
    beta_[2] = ((768.0e0 * (*x_) + 48.0e0 * (xmu_ + 23.0e0)) * (*x_) + ((xmu_ + 62.0e0) * xmu_ + 129.0e0)) / (a_[1] * 
    a_[2]);
    if (nterms_ < 4) {
      goto _l65;
    }
    for (i_ = 4; i_ <= nterms_; (i_)++) {
      n_ = i_ - 1;
      x2n_ = 2 * n_ - 1;
      a_[i_ - 1] = ($17_ = (x2n_ + 2.0e0), $17_ * $17_) - xmu_;
      qq_ = 16.0e0 * x2n_ / a_[i_ - 1];
      p1_ = -x2n_ * ((12 * n_ * n_ - 20 * n_) - a_[0]) / ((x2n_ - 2.0e0) * a_[i_ - 1]) - qq_ * (*x_);
      p2_ = ((12 * n_ * n_ - 28 * n_ + 8) - a_[0]) / a_[i_ - 1] - qq_ * (*x_);
      p3_ = -x2n_ * a_[i_ - 3 - 1] / ((x2n_ - 2.0e0) * a_[i_ - 1]);
      alpha_[i_ - 1] = -p1_ * alpha_[i_ - 1 - 1] - p2_ * alpha_[i_ - 2 - 1] - p3_ * alpha_[i_ - 3 - 1];
      beta_[i_ - 1] = -p1_ * beta_[i_ - 1 - 1] - p2_ * beta_[i_ - 2 - 1] - p3_ * beta_[i_ - 3 - 1];
    }
    _l65:;
    result_ = sqpi2_ * beta_[nterms_ - 1] / (sqrtx_ * alpha_[nterms_ - 1]);
    _l70:;
    if (inu_ == 1) {
      (*bknu_) = result_;
    }
    if (inu_ == 2) {
      (*bknu1_) = result_;
    }
  }
  goto _l0;
  _l90:;
  (*bknu_) = sqpi2_ / sqrtx_;
  (*bknu1_) = (*bknu_);
  _l0:;
  __calls[102].calls++;
  return 0;
}

real_8 _d9lgic (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ alx_)
{
  static int_4 k_;
  static real_8 eps_, fk_, p_, r_, s_, t_, xma_, xpa_;
  int_4 _data_k_1650, $0_, $1_;
  real_8 d9lgic_;
  extern real_8 _d1mach ();
#define _data_n_1650 1
  static real_8 _data_l_1650[_data_n_1650] = {
    0.0e0
  };
  if (__calls[103].calls == 0) {
    _data_k_1650 = 0;
    if (_data_k_1650 >= _data_n_1650) {
      _data_k_1650 = 0;
    }
    eps_ = _data_l_1650[_data_k_1650++];
  }
  if (eps_ == 0.0e0) {
    eps_ = 0.5e0 * _d1mach (($0_ = 3, &$0_));
  }
  xpa_ = (*x_) + 1.0e0 - (*a_);
  xma_ = (*x_) - 1.0e0 - (*a_);
  r_ = 0.0;
  p_ = 1.0;
  s_ = p_;
  for (k_ = 1; k_ <= 300; (k_)++) {
    fk_ = k_;
    t_ = fk_ * ((*a_) - fk_) * (1.0e0 + r_);
    r_ = -t_ / ((xma_ + 2.0e0 * fk_) * (xpa_ + 2.0e0 * fk_) + t_);
    p_ = r_ * p_;
    s_ = s_ + p_;
    if (_abs (p_) < eps_ * s_) {
      goto _l20;
    }
  }
  (void) _xermsg (_dc_0, _dc_173, _dc_174, &_k1, ($1_ = 2, &$1_));
  _l20:;
  d9lgic_ = (*a_) * (*alx_) - (*x_) + log (s_ / xpa_);
  __calls[103].calls++;
  return d9lgic_;
}

real_8 _d9lgit (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ algap1_)
{
  static int_4 k_;
  static logical_4 first_;
  static real_8 ax_, a1x_, eps_, fk_, hstar_, p_, r_, s_, sqeps_, t_;
  int_4 _data_k_1651, $0_, $1_, $2_, $3_, $4_, $5_;
  real_8 d9lgit_;
  extern real_8 _d1mach ();
#define _data_n_1651 1
  static logical_4 _data_l_1651[_data_n_1651] = {
    TRUE
  };
  if (__calls[104].calls == 0) {
    _data_k_1651 = 0;
    if (_data_k_1651 >= _data_n_1651) {
      _data_k_1651 = 0;
    }
    first_ = _data_l_1651[_data_k_1651++];
  }
  if (first_) {
    eps_ = 0.5e0 * _d1mach (($0_ = 3, &$0_));
    sqeps_ = sqrt (_d1mach (($1_ = 4, &$1_)));
  }
  first_ = FALSE;
  if ((*x_) <= 0.0e0 || (*a_) < (*x_)) {
    (void) _xermsg (_dc_0, _dc_175, _dc_176, ($2_ = 2, &$2_), ($3_ = 2, &$3_));
  }
  ax_ = (*a_) + (*x_);
  a1x_ = ax_ + 1.0e0;
  r_ = 0.0;
  p_ = 1.0;
  s_ = p_;
  for (k_ = 1; k_ <= 200; (k_)++) {
    fk_ = k_;
    t_ = ((*a_) + fk_) * (*x_) * (1.0e0 + r_);
    r_ = t_ / ((ax_ + fk_) * (a1x_ + fk_) - t_);
    p_ = r_ * p_;
    s_ = s_ + p_;
    if (_abs (p_) < eps_ * s_) {
      goto _l30;
    }
  }
  (void) _xermsg (_dc_0, _dc_175, _dc_164, ($4_ = 3, &$4_), ($5_ = 2, &$5_));
  _l30:;
  hstar_ = 1.0e0 - (*x_) * s_ / a1x_;
  if (hstar_ < sqeps_) {
    (void) _xermsg (_dc_0, _dc_175, _dc_177, &_k1, &_k1);
  }
  d9lgit_ = -(*x_) - (*algap1_) - log (hstar_);
  __calls[104].calls++;
  return d9lgit_;
}

real_8 _d9lgmc (real_8 _p_ x_)
{
  static int_4 nalgm_;
  static logical_4 first_;
  static real_8 algmcs_[15], xbig_, xmax_;
  int_4 _data_k_1652, _data_k_1653, _data_k_1654, _data_k_1655, _data_k_1656, _data_k_1657, _data_k_1658, _data_k_1659, 
  _data_k_1660, _data_k_1661, _data_k_1662, _data_k_1663, _data_k_1664, _data_k_1665, _data_k_1666, _data_k_1667, $0_, 
  $1_, $3_, $4_, $5_, $8_;
  real_4 $2_;
  real_8 $6_, $7_;
  real_8 d9lgmc_;
  extern real_8 _d1mach ();
#define _data_n_1652 1
  static real_8 _data_l_1652[_data_n_1652] = {
    .1666389480451863247205729650822e+0
  };
#define _data_n_1653 1
  static real_8 _data_l_1653[_data_n_1653] = {
    -.1384948176067563840732986059135e-4
  };
#define _data_n_1654 1
  static real_8 _data_l_1654[_data_n_1654] = {
    .9810825646924729426157171547487e-8
  };
#define _data_n_1655 1
  static real_8 _data_l_1655[_data_n_1655] = {
    -.1809129475572494194263306266719e-10
  };
#define _data_n_1656 1
  static real_8 _data_l_1656[_data_n_1656] = {
    .6221098041892605227126015543416e-13
  };
#define _data_n_1657 1
  static real_8 _data_l_1657[_data_n_1657] = {
    -.3399615005417721944303330599666e-15
  };
#define _data_n_1658 1
  static real_8 _data_l_1658[_data_n_1658] = {
    .2683181998482698748957538846666e-17
  };
#define _data_n_1659 1
  static real_8 _data_l_1659[_data_n_1659] = {
    -.2868042435334643284144622399999e-19
  };
#define _data_n_1660 1
  static real_8 _data_l_1660[_data_n_1660] = {
    .3962837061046434803679306666666e-21
  };
#define _data_n_1661 1
  static real_8 _data_l_1661[_data_n_1661] = {
    -.6831888753985766870111999999999e-23
  };
#define _data_n_1662 1
  static real_8 _data_l_1662[_data_n_1662] = {
    .1429227355942498147573333333333e-24
  };
#define _data_n_1663 1
  static real_8 _data_l_1663[_data_n_1663] = {
    -.3547598158101070547199999999999e-26
  };
#define _data_n_1664 1
  static real_8 _data_l_1664[_data_n_1664] = {
    .1025680058010470912e-27
  };
#define _data_n_1665 1
  static real_8 _data_l_1665[_data_n_1665] = {
    -.3401102254316748799999999999999e-29
  };
#define _data_n_1666 1
  static real_8 _data_l_1666[_data_n_1666] = {
    .1276642195630062933333333333333e-30
  };
#define _data_n_1667 1
  static logical_4 _data_l_1667[_data_n_1667] = {
    TRUE
  };
  if (__calls[105].calls == 0) {
    _data_k_1652 = 0;
    if (_data_k_1652 >= _data_n_1652) {
      _data_k_1652 = 0;
    }
    algmcs_[0] = _data_l_1652[_data_k_1652++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1653 = 0;
    if (_data_k_1653 >= _data_n_1653) {
      _data_k_1653 = 0;
    }
    algmcs_[1] = _data_l_1653[_data_k_1653++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1654 = 0;
    if (_data_k_1654 >= _data_n_1654) {
      _data_k_1654 = 0;
    }
    algmcs_[2] = _data_l_1654[_data_k_1654++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1655 = 0;
    if (_data_k_1655 >= _data_n_1655) {
      _data_k_1655 = 0;
    }
    algmcs_[3] = _data_l_1655[_data_k_1655++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1656 = 0;
    if (_data_k_1656 >= _data_n_1656) {
      _data_k_1656 = 0;
    }
    algmcs_[4] = _data_l_1656[_data_k_1656++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1657 = 0;
    if (_data_k_1657 >= _data_n_1657) {
      _data_k_1657 = 0;
    }
    algmcs_[5] = _data_l_1657[_data_k_1657++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1658 = 0;
    if (_data_k_1658 >= _data_n_1658) {
      _data_k_1658 = 0;
    }
    algmcs_[6] = _data_l_1658[_data_k_1658++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1659 = 0;
    if (_data_k_1659 >= _data_n_1659) {
      _data_k_1659 = 0;
    }
    algmcs_[7] = _data_l_1659[_data_k_1659++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1660 = 0;
    if (_data_k_1660 >= _data_n_1660) {
      _data_k_1660 = 0;
    }
    algmcs_[8] = _data_l_1660[_data_k_1660++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1661 = 0;
    if (_data_k_1661 >= _data_n_1661) {
      _data_k_1661 = 0;
    }
    algmcs_[9] = _data_l_1661[_data_k_1661++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1662 = 0;
    if (_data_k_1662 >= _data_n_1662) {
      _data_k_1662 = 0;
    }
    algmcs_[10] = _data_l_1662[_data_k_1662++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1663 = 0;
    if (_data_k_1663 >= _data_n_1663) {
      _data_k_1663 = 0;
    }
    algmcs_[11] = _data_l_1663[_data_k_1663++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1664 = 0;
    if (_data_k_1664 >= _data_n_1664) {
      _data_k_1664 = 0;
    }
    algmcs_[12] = _data_l_1664[_data_k_1664++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1665 = 0;
    if (_data_k_1665 >= _data_n_1665) {
      _data_k_1665 = 0;
    }
    algmcs_[13] = _data_l_1665[_data_k_1665++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1666 = 0;
    if (_data_k_1666 >= _data_n_1666) {
      _data_k_1666 = 0;
    }
    algmcs_[14] = _data_l_1666[_data_k_1666++];
  }
  if (__calls[105].calls == 0) {
    _data_k_1667 = 0;
    if (_data_k_1667 >= _data_n_1667) {
      _data_k_1667 = 0;
    }
    first_ = _data_l_1667[_data_k_1667++];
  }
  if (first_) {
    nalgm_ = _initds (algmcs_, ($0_ = 15, &$0_), ($2_ = (real_4) (_d1mach (($1_ = 3, &$1_))), &$2_));
    xbig_ = 1.0e0 / sqrt (_d1mach (($3_ = 3, &$3_)));
    xmax_ = exp (_min (log (_d1mach (($4_ = 2, &$4_)) / 12.0e0), -log (12.0e0 * _d1mach (&_k1))));
  }
  first_ = FALSE;
  if ((*x_) < 10.0e0) {
    (void) _xermsg (_dc_0, _dc_178, _dc_179, &_k1, ($5_ = 2, &$5_));
  }
  if ((*x_) >= xmax_) {
    goto _l20;
  }
  d9lgmc_ = 1.0e0 / (12.0e0 * (*x_));
  if ((*x_) < xbig_) {
    d9lgmc_ = _dcsevl (($7_ = 2.0e0 * ($6_ = (10.0e0 / (*x_)), $6_ * $6_) - 1.0e0, &$7_), algmcs_, &nalgm_) / (*x_);
  }
  goto _l0;
  _l20:;
  d9lgmc_ = 0.0;
  (void) _xermsg (_dc_0, _dc_178, _dc_180, ($8_ = 2, &$8_), &_k1);
  _l0:;
  __calls[105].calls++;
  return d9lgmc_;
}

real_8 _d9ln2r (real_8 _p_ x_)
{
  static int_4 ntln21_, ntln22_;
  static logical_4 first_;
  static real_4 eps_, sqeps_;
  static real_8 xbig_, txbig_, xmax_, txmax_, xmin_, ln21cs_[50], ln22cs_[37];
  int_4 _data_k_1668, _data_k_1669, _data_k_1670, _data_k_1671, _data_k_1672, _data_k_1673, _data_k_1674, _data_k_1675, 
  _data_k_1676, _data_k_1677, _data_k_1678, _data_k_1679, _data_k_1680, _data_k_1681, _data_k_1682, _data_k_1683, 
  _data_k_1684, _data_k_1685, _data_k_1686, _data_k_1687, _data_k_1688, _data_k_1689, _data_k_1690, _data_k_1691, 
  _data_k_1692, _data_k_1693, _data_k_1694, _data_k_1695, _data_k_1696, _data_k_1697, _data_k_1698, _data_k_1699, 
  _data_k_1700, _data_k_1701, _data_k_1702, _data_k_1703, _data_k_1704, _data_k_1705, _data_k_1706, _data_k_1707, 
  _data_k_1708, _data_k_1709, _data_k_1710, _data_k_1711, _data_k_1712, _data_k_1713, _data_k_1714, _data_k_1715, 
  _data_k_1716, _data_k_1717, _data_k_1718, _data_k_1719, _data_k_1720, _data_k_1721, _data_k_1722, _data_k_1723, 
  _data_k_1724, _data_k_1725, _data_k_1726, _data_k_1727, _data_k_1728, _data_k_1729, _data_k_1730, _data_k_1731, 
  _data_k_1732, _data_k_1733, _data_k_1734, _data_k_1735, _data_k_1736, _data_k_1737, _data_k_1738, _data_k_1739, 
  _data_k_1740, _data_k_1741, _data_k_1742, _data_k_1743, _data_k_1744, _data_k_1745, _data_k_1746, _data_k_1747, 
  _data_k_1748, _data_k_1749, _data_k_1750, _data_k_1751, _data_k_1752, _data_k_1753, _data_k_1754, _data_k_1755, $0_, 
  $1_, $3_, $5_, $8_, $9_, $10_;
  real_4 $2_, $4_;
  real_8 $6_, $7_;
  real_8 d9ln2r_;
  extern real_8 _d1mach ();
#define _data_n_1668 1
  static real_8 _data_l_1668[_data_n_1668] = {
    .18111962513478809875894953043071e+0
  };
#define _data_n_1669 1
  static real_8 _data_l_1669[_data_n_1669] = {
    -.15627123192872462669625155541078e+0
  };
#define _data_n_1670 1
  static real_8 _data_l_1670[_data_n_1670] = {
    .28676305361557275209540627102051e-1
  };
#define _data_n_1671 1
  static real_8 _data_l_1671[_data_n_1671] = {
    -.55586996559481398781157725126781e-2
  };
#define _data_n_1672 1
  static real_8 _data_l_1672[_data_n_1672] = {
    .11178976652299837657335666279727e-2
  };
#define _data_n_1673 1
  static real_8 _data_l_1673[_data_n_1673] = {
    -.23080508982327947182299279585705e-3
  };
#define _data_n_1674 1
  static real_8 _data_l_1674[_data_n_1674] = {
    .4859885334110017587468155806875e-4
  };
#define _data_n_1675 1
  static real_8 _data_l_1675[_data_n_1675] = {
    -.10390127388903210765514242633338e-4
  };
#define _data_n_1676 1
  static real_8 _data_l_1676[_data_n_1676] = {
    .22484563707390128494621804946408e-5
  };
#define _data_n_1677 1
  static real_8 _data_l_1677[_data_n_1677] = {
    -.49140592739266484875327802597091e-6
  };
#define _data_n_1678 1
  static real_8 _data_l_1678[_data_n_1678] = {
    .10828256507077483336620152971597e-6
  };
#define _data_n_1679 1
  static real_8 _data_l_1679[_data_n_1679] = {
    -.24025872763420701435976675416719e-7
  };
#define _data_n_1680 1
  static real_8 _data_l_1680[_data_n_1680] = {
    .53624600472708133762984443250163e-8
  };
#define _data_n_1681 1
  static real_8 _data_l_1681[_data_n_1681] = {
    -.12029951362138772264671646424377e-8
  };
#define _data_n_1682 1
  static real_8 _data_l_1682[_data_n_1682] = {
    .27107889277591860785622551632266e-9
  };
#define _data_n_1683 1
  static real_8 _data_l_1683[_data_n_1683] = {
    -.6132356261831901006879672843069e-10
  };
#define _data_n_1684 1
  static real_8 _data_l_1684[_data_n_1684] = {
    .13920858369159469857436908543978e-10
  };
#define _data_n_1685 1
  static real_8 _data_l_1685[_data_n_1685] = {
    -.31699300330223494015283057260883e-11
  };
#define _data_n_1686 1
  static real_8 _data_l_1686[_data_n_1686] = {
    .72383754044307505335214326197011e-12
  };
#define _data_n_1687 1
  static real_8 _data_l_1687[_data_n_1687] = {
    -.16570017184764411391498805506268e-12
  };
#define _data_n_1688 1
  static real_8 _data_l_1688[_data_n_1688] = {
    .38018428663117424257364422631876e-13
  };
#define _data_n_1689 1
  static real_8 _data_l_1689[_data_n_1689] = {
    -.87411189296972700259724429899137e-14
  };
#define _data_n_1690 1
  static real_8 _data_l_1690[_data_n_1690] = {
    .20135619845055748302118751028154e-14
  };
#define _data_n_1691 1
  static real_8 _data_l_1691[_data_n_1691] = {
    -.46464456409033907031102008154477e-15
  };
#define _data_n_1692 1
  static real_8 _data_l_1692[_data_n_1692] = {
    .10739282147018339453453338554925e-15
  };
#define _data_n_1693 1
  static real_8 _data_l_1693[_data_n_1693] = {
    -.2485853461993779475553402183396e-16
  };
#define _data_n_1694 1
  static real_8 _data_l_1694[_data_n_1694] = {
    .57620197950800189813888142628181e-17
  };
#define _data_n_1695 1
  static real_8 _data_l_1695[_data_n_1695] = {
    -.1337306376980439470140219995805e-17
  };
#define _data_n_1696 1
  static real_8 _data_l_1696[_data_n_1696] = {
    .31074653227331824966533807166805e-18
  };
#define _data_n_1697 1
  static real_8 _data_l_1697[_data_n_1697] = {
    -.72288104083040539906901957917627e-19
  };
#define _data_n_1698 1
  static real_8 _data_l_1698[_data_n_1698] = {
    .16833783788037385103313258186888e-19
  };
#define _data_n_1699 1
  static real_8 _data_l_1699[_data_n_1699] = {
    -.39239463312069958052519372739925e-20
  };
#define _data_n_1700 1
  static real_8 _data_l_1700[_data_n_1700] = {
    .91551468387536789746385528640853e-21
  };
#define _data_n_1701 1
  static real_8 _data_l_1701[_data_n_1701] = {
    -.21378895321320159520982095801002e-21
  };
#define _data_n_1702 1
  static real_8 _data_l_1702[_data_n_1702] = {
    .49964507479047864699828564568746e-22
  };
#define _data_n_1703 1
  static real_8 _data_l_1703[_data_n_1703] = {
    -.11686240636080170135360806147413e-22
  };
#define _data_n_1704 1
  static real_8 _data_l_1704[_data_n_1704] = {
    .27353123470391863775628686786559e-23
  };
#define _data_n_1705 1
  static real_8 _data_l_1705[_data_n_1705] = {
    -.64068025084792111965050345881599e-24
  };
#define _data_n_1706 1
  static real_8 _data_l_1706[_data_n_1706] = {
    .15016293204334124162949071940266e-24
  };
#define _data_n_1707 1
  static real_8 _data_l_1707[_data_n_1707] = {
    -.35217372410398479759497145002666e-25
  };
#define _data_n_1708 1
  static real_8 _data_l_1708[_data_n_1708] = {
    .82643901014814767012482733397333e-26
  };
#define _data_n_1709 1
  static real_8 _data_l_1709[_data_n_1709] = {
    -.19404930275943401918036617898666e-26
  };
#define _data_n_1710 1
  static real_8 _data_l_1710[_data_n_1710] = {
    .45587880018841283562451588437333e-27
  };
#define _data_n_1711 1
  static real_8 _data_l_1711[_data_n_1711] = {
    -.10715492087545202154378625023999e-27
  };
#define _data_n_1712 1
  static real_8 _data_l_1712[_data_n_1712] = {
    .25199408007927592978096674133333e-28
  };
#define _data_n_1713 1
  static real_8 _data_l_1713[_data_n_1713] = {
    -.592890884001209693417504768e-29
  };
#define _data_n_1714 1
  static real_8 _data_l_1714[_data_n_1714] = {
    .13955864061057513058237153279999e-29
  };
#define _data_n_1715 1
  static real_8 _data_l_1715[_data_n_1715] = {
    -.32864578813478583431436697599999e-30
  };
#define _data_n_1716 1
  static real_8 _data_l_1716[_data_n_1716] = {
    .77424967950478166247254698666666e-31
  };
#define _data_n_1717 1
  static real_8 _data_l_1717[_data_n_1717] = {
    -.18247735667260887638125226666666e-31
  };
#define _data_n_1718 1
  static real_8 _data_l_1718[_data_n_1718] = {
    -.2224253253502046082986015223552e+0
  };
#define _data_n_1719 1
  static real_8 _data_l_1719[_data_n_1719] = {
    -.6104710010807862398680104755764e-1
  };
#define _data_n_1720 1
  static real_8 _data_l_1720[_data_n_1720] = {
    .7427235009750394590519629755729e-2
  };
#define _data_n_1721 1
  static real_8 _data_l_1721[_data_n_1721] = {
    -.9335018261636970565612779606397e-3
  };
#define _data_n_1722 1
  static real_8 _data_l_1722[_data_n_1722] = {
    .1200499076872601283350731287359e-3
  };
#define _data_n_1723 1
  static real_8 _data_l_1723[_data_n_1723] = {
    -.1570472295282004112823352608243e-4
  };
#define _data_n_1724 1
  static real_8 _data_l_1724[_data_n_1724] = {
    .2081874781051271096050783592759e-5
  };
#define _data_n_1725 1
  static real_8 _data_l_1725[_data_n_1725] = {
    -.2789195577646713654057213051375e-6
  };
#define _data_n_1726 1
  static real_8 _data_l_1726[_data_n_1726] = {
    .3769355823760132058422895135447e-7
  };
#define _data_n_1727 1
  static real_8 _data_l_1727[_data_n_1727] = {
    -.5130902896527711258240589938003e-8
  };
#define _data_n_1728 1
  static real_8 _data_l_1728[_data_n_1728] = {
    .7027141178150694738206218215392e-9
  };
#define _data_n_1729 1
  static real_8 _data_l_1729[_data_n_1729] = {
    -.9674859550134342389243972005137e-10
  };
#define _data_n_1730 1
  static real_8 _data_l_1730[_data_n_1730] = {
    .1338104645924887306588496449748e-10
  };
#define _data_n_1731 1
  static real_8 _data_l_1731[_data_n_1731] = {
    -.1858102603534063981628453846591e-11
  };
#define _data_n_1732 1
  static real_8 _data_l_1732[_data_n_1732] = {
    .258929442252791974930860012307e-12
  };
#define _data_n_1733 1
  static real_8 _data_l_1733[_data_n_1733] = {
    -.3619568316141588674466025382172e-13
  };
#define _data_n_1734 1
  static real_8 _data_l_1734[_data_n_1734] = {
    .5074037398016623088006858917396e-14
  };
#define _data_n_1735 1
  static real_8 _data_l_1735[_data_n_1735] = {
    -.7131012977031127302700938748927e-15
  };
#define _data_n_1736 1
  static real_8 _data_l_1736[_data_n_1736] = {
    .1004490328554567481853386784126e-15
  };
#define _data_n_1737 1
  static real_8 _data_l_1737[_data_n_1737] = {
    -.1417906532184025791904405075285e-16
  };
#define _data_n_1738 1
  static real_8 _data_l_1738[_data_n_1738] = {
    .2005297034743326117891086396074e-17
  };
#define _data_n_1739 1
  static real_8 _data_l_1739[_data_n_1739] = {
    -.2840996662339803305365396717567e-18
  };
#define _data_n_1740 1
  static real_8 _data_l_1740[_data_n_1740] = {
    .4031469883969079899599878662826e-19
  };
#define _data_n_1741 1
  static real_8 _data_l_1741[_data_n_1741] = {
    -.5729325241832207320455498956799e-20
  };
#define _data_n_1742 1
  static real_8 _data_l_1742[_data_n_1742] = {
    .8153488253890010675848928733866e-21
  };
#define _data_n_1743 1
  static real_8 _data_l_1743[_data_n_1743] = {
    -.1161825588549721787606027468799e-21
  };
#define _data_n_1744 1
  static real_8 _data_l_1744[_data_n_1744] = {
    .1657516611662538343659339775999e-22
  };
#define _data_n_1745 1
  static real_8 _data_l_1745[_data_n_1745] = {
    -.236733670471080519011401728e-23
  };
#define _data_n_1746 1
  static real_8 _data_l_1746[_data_n_1746] = {
    .3384670367975521386076569599999e-24
  };
#define _data_n_1747 1
  static real_8 _data_l_1747[_data_n_1747] = {
    -.4843940829215718204296396799999e-25
  };
#define _data_n_1748 1
  static real_8 _data_l_1748[_data_n_1748] = {
    .6938759162514273718676138666666e-26
  };
#define _data_n_1749 1
  static real_8 _data_l_1749[_data_n_1749] = {
    -.9948142607031436571923797333333e-27
  };
#define _data_n_1750 1
  static real_8 _data_l_1750[_data_n_1750] = {
    .1427440611211698610634752e-27
  };
#define _data_n_1751 1
  static real_8 _data_l_1751[_data_n_1751] = {
    -.2049794721898234911566506666666e-28
  };
#define _data_n_1752 1
  static real_8 _data_l_1752[_data_n_1752] = {
    .2945648756401362222885546666666e-29
  };
#define _data_n_1753 1
  static real_8 _data_l_1753[_data_n_1753] = {
    -.4235973185184957027669333333333e-30
  };
#define _data_n_1754 1
  static real_8 _data_l_1754[_data_n_1754] = {
    .6095532614003832040106666666666e-31
  };
#define _data_n_1755 1
  static logical_4 _data_l_1755[_data_n_1755] = {
    TRUE
  };
  if (__calls[106].calls == 0) {
    _data_k_1668 = 0;
    if (_data_k_1668 >= _data_n_1668) {
      _data_k_1668 = 0;
    }
    ln21cs_[0] = _data_l_1668[_data_k_1668++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1669 = 0;
    if (_data_k_1669 >= _data_n_1669) {
      _data_k_1669 = 0;
    }
    ln21cs_[1] = _data_l_1669[_data_k_1669++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1670 = 0;
    if (_data_k_1670 >= _data_n_1670) {
      _data_k_1670 = 0;
    }
    ln21cs_[2] = _data_l_1670[_data_k_1670++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1671 = 0;
    if (_data_k_1671 >= _data_n_1671) {
      _data_k_1671 = 0;
    }
    ln21cs_[3] = _data_l_1671[_data_k_1671++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1672 = 0;
    if (_data_k_1672 >= _data_n_1672) {
      _data_k_1672 = 0;
    }
    ln21cs_[4] = _data_l_1672[_data_k_1672++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1673 = 0;
    if (_data_k_1673 >= _data_n_1673) {
      _data_k_1673 = 0;
    }
    ln21cs_[5] = _data_l_1673[_data_k_1673++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1674 = 0;
    if (_data_k_1674 >= _data_n_1674) {
      _data_k_1674 = 0;
    }
    ln21cs_[6] = _data_l_1674[_data_k_1674++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1675 = 0;
    if (_data_k_1675 >= _data_n_1675) {
      _data_k_1675 = 0;
    }
    ln21cs_[7] = _data_l_1675[_data_k_1675++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1676 = 0;
    if (_data_k_1676 >= _data_n_1676) {
      _data_k_1676 = 0;
    }
    ln21cs_[8] = _data_l_1676[_data_k_1676++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1677 = 0;
    if (_data_k_1677 >= _data_n_1677) {
      _data_k_1677 = 0;
    }
    ln21cs_[9] = _data_l_1677[_data_k_1677++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1678 = 0;
    if (_data_k_1678 >= _data_n_1678) {
      _data_k_1678 = 0;
    }
    ln21cs_[10] = _data_l_1678[_data_k_1678++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1679 = 0;
    if (_data_k_1679 >= _data_n_1679) {
      _data_k_1679 = 0;
    }
    ln21cs_[11] = _data_l_1679[_data_k_1679++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1680 = 0;
    if (_data_k_1680 >= _data_n_1680) {
      _data_k_1680 = 0;
    }
    ln21cs_[12] = _data_l_1680[_data_k_1680++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1681 = 0;
    if (_data_k_1681 >= _data_n_1681) {
      _data_k_1681 = 0;
    }
    ln21cs_[13] = _data_l_1681[_data_k_1681++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1682 = 0;
    if (_data_k_1682 >= _data_n_1682) {
      _data_k_1682 = 0;
    }
    ln21cs_[14] = _data_l_1682[_data_k_1682++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1683 = 0;
    if (_data_k_1683 >= _data_n_1683) {
      _data_k_1683 = 0;
    }
    ln21cs_[15] = _data_l_1683[_data_k_1683++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1684 = 0;
    if (_data_k_1684 >= _data_n_1684) {
      _data_k_1684 = 0;
    }
    ln21cs_[16] = _data_l_1684[_data_k_1684++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1685 = 0;
    if (_data_k_1685 >= _data_n_1685) {
      _data_k_1685 = 0;
    }
    ln21cs_[17] = _data_l_1685[_data_k_1685++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1686 = 0;
    if (_data_k_1686 >= _data_n_1686) {
      _data_k_1686 = 0;
    }
    ln21cs_[18] = _data_l_1686[_data_k_1686++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1687 = 0;
    if (_data_k_1687 >= _data_n_1687) {
      _data_k_1687 = 0;
    }
    ln21cs_[19] = _data_l_1687[_data_k_1687++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1688 = 0;
    if (_data_k_1688 >= _data_n_1688) {
      _data_k_1688 = 0;
    }
    ln21cs_[20] = _data_l_1688[_data_k_1688++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1689 = 0;
    if (_data_k_1689 >= _data_n_1689) {
      _data_k_1689 = 0;
    }
    ln21cs_[21] = _data_l_1689[_data_k_1689++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1690 = 0;
    if (_data_k_1690 >= _data_n_1690) {
      _data_k_1690 = 0;
    }
    ln21cs_[22] = _data_l_1690[_data_k_1690++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1691 = 0;
    if (_data_k_1691 >= _data_n_1691) {
      _data_k_1691 = 0;
    }
    ln21cs_[23] = _data_l_1691[_data_k_1691++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1692 = 0;
    if (_data_k_1692 >= _data_n_1692) {
      _data_k_1692 = 0;
    }
    ln21cs_[24] = _data_l_1692[_data_k_1692++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1693 = 0;
    if (_data_k_1693 >= _data_n_1693) {
      _data_k_1693 = 0;
    }
    ln21cs_[25] = _data_l_1693[_data_k_1693++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1694 = 0;
    if (_data_k_1694 >= _data_n_1694) {
      _data_k_1694 = 0;
    }
    ln21cs_[26] = _data_l_1694[_data_k_1694++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1695 = 0;
    if (_data_k_1695 >= _data_n_1695) {
      _data_k_1695 = 0;
    }
    ln21cs_[27] = _data_l_1695[_data_k_1695++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1696 = 0;
    if (_data_k_1696 >= _data_n_1696) {
      _data_k_1696 = 0;
    }
    ln21cs_[28] = _data_l_1696[_data_k_1696++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1697 = 0;
    if (_data_k_1697 >= _data_n_1697) {
      _data_k_1697 = 0;
    }
    ln21cs_[29] = _data_l_1697[_data_k_1697++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1698 = 0;
    if (_data_k_1698 >= _data_n_1698) {
      _data_k_1698 = 0;
    }
    ln21cs_[30] = _data_l_1698[_data_k_1698++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1699 = 0;
    if (_data_k_1699 >= _data_n_1699) {
      _data_k_1699 = 0;
    }
    ln21cs_[31] = _data_l_1699[_data_k_1699++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1700 = 0;
    if (_data_k_1700 >= _data_n_1700) {
      _data_k_1700 = 0;
    }
    ln21cs_[32] = _data_l_1700[_data_k_1700++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1701 = 0;
    if (_data_k_1701 >= _data_n_1701) {
      _data_k_1701 = 0;
    }
    ln21cs_[33] = _data_l_1701[_data_k_1701++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1702 = 0;
    if (_data_k_1702 >= _data_n_1702) {
      _data_k_1702 = 0;
    }
    ln21cs_[34] = _data_l_1702[_data_k_1702++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1703 = 0;
    if (_data_k_1703 >= _data_n_1703) {
      _data_k_1703 = 0;
    }
    ln21cs_[35] = _data_l_1703[_data_k_1703++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1704 = 0;
    if (_data_k_1704 >= _data_n_1704) {
      _data_k_1704 = 0;
    }
    ln21cs_[36] = _data_l_1704[_data_k_1704++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1705 = 0;
    if (_data_k_1705 >= _data_n_1705) {
      _data_k_1705 = 0;
    }
    ln21cs_[37] = _data_l_1705[_data_k_1705++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1706 = 0;
    if (_data_k_1706 >= _data_n_1706) {
      _data_k_1706 = 0;
    }
    ln21cs_[38] = _data_l_1706[_data_k_1706++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1707 = 0;
    if (_data_k_1707 >= _data_n_1707) {
      _data_k_1707 = 0;
    }
    ln21cs_[39] = _data_l_1707[_data_k_1707++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1708 = 0;
    if (_data_k_1708 >= _data_n_1708) {
      _data_k_1708 = 0;
    }
    ln21cs_[40] = _data_l_1708[_data_k_1708++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1709 = 0;
    if (_data_k_1709 >= _data_n_1709) {
      _data_k_1709 = 0;
    }
    ln21cs_[41] = _data_l_1709[_data_k_1709++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1710 = 0;
    if (_data_k_1710 >= _data_n_1710) {
      _data_k_1710 = 0;
    }
    ln21cs_[42] = _data_l_1710[_data_k_1710++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1711 = 0;
    if (_data_k_1711 >= _data_n_1711) {
      _data_k_1711 = 0;
    }
    ln21cs_[43] = _data_l_1711[_data_k_1711++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1712 = 0;
    if (_data_k_1712 >= _data_n_1712) {
      _data_k_1712 = 0;
    }
    ln21cs_[44] = _data_l_1712[_data_k_1712++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1713 = 0;
    if (_data_k_1713 >= _data_n_1713) {
      _data_k_1713 = 0;
    }
    ln21cs_[45] = _data_l_1713[_data_k_1713++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1714 = 0;
    if (_data_k_1714 >= _data_n_1714) {
      _data_k_1714 = 0;
    }
    ln21cs_[46] = _data_l_1714[_data_k_1714++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1715 = 0;
    if (_data_k_1715 >= _data_n_1715) {
      _data_k_1715 = 0;
    }
    ln21cs_[47] = _data_l_1715[_data_k_1715++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1716 = 0;
    if (_data_k_1716 >= _data_n_1716) {
      _data_k_1716 = 0;
    }
    ln21cs_[48] = _data_l_1716[_data_k_1716++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1717 = 0;
    if (_data_k_1717 >= _data_n_1717) {
      _data_k_1717 = 0;
    }
    ln21cs_[49] = _data_l_1717[_data_k_1717++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1718 = 0;
    if (_data_k_1718 >= _data_n_1718) {
      _data_k_1718 = 0;
    }
    ln22cs_[0] = _data_l_1718[_data_k_1718++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1719 = 0;
    if (_data_k_1719 >= _data_n_1719) {
      _data_k_1719 = 0;
    }
    ln22cs_[1] = _data_l_1719[_data_k_1719++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1720 = 0;
    if (_data_k_1720 >= _data_n_1720) {
      _data_k_1720 = 0;
    }
    ln22cs_[2] = _data_l_1720[_data_k_1720++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1721 = 0;
    if (_data_k_1721 >= _data_n_1721) {
      _data_k_1721 = 0;
    }
    ln22cs_[3] = _data_l_1721[_data_k_1721++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1722 = 0;
    if (_data_k_1722 >= _data_n_1722) {
      _data_k_1722 = 0;
    }
    ln22cs_[4] = _data_l_1722[_data_k_1722++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1723 = 0;
    if (_data_k_1723 >= _data_n_1723) {
      _data_k_1723 = 0;
    }
    ln22cs_[5] = _data_l_1723[_data_k_1723++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1724 = 0;
    if (_data_k_1724 >= _data_n_1724) {
      _data_k_1724 = 0;
    }
    ln22cs_[6] = _data_l_1724[_data_k_1724++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1725 = 0;
    if (_data_k_1725 >= _data_n_1725) {
      _data_k_1725 = 0;
    }
    ln22cs_[7] = _data_l_1725[_data_k_1725++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1726 = 0;
    if (_data_k_1726 >= _data_n_1726) {
      _data_k_1726 = 0;
    }
    ln22cs_[8] = _data_l_1726[_data_k_1726++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1727 = 0;
    if (_data_k_1727 >= _data_n_1727) {
      _data_k_1727 = 0;
    }
    ln22cs_[9] = _data_l_1727[_data_k_1727++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1728 = 0;
    if (_data_k_1728 >= _data_n_1728) {
      _data_k_1728 = 0;
    }
    ln22cs_[10] = _data_l_1728[_data_k_1728++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1729 = 0;
    if (_data_k_1729 >= _data_n_1729) {
      _data_k_1729 = 0;
    }
    ln22cs_[11] = _data_l_1729[_data_k_1729++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1730 = 0;
    if (_data_k_1730 >= _data_n_1730) {
      _data_k_1730 = 0;
    }
    ln22cs_[12] = _data_l_1730[_data_k_1730++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1731 = 0;
    if (_data_k_1731 >= _data_n_1731) {
      _data_k_1731 = 0;
    }
    ln22cs_[13] = _data_l_1731[_data_k_1731++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1732 = 0;
    if (_data_k_1732 >= _data_n_1732) {
      _data_k_1732 = 0;
    }
    ln22cs_[14] = _data_l_1732[_data_k_1732++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1733 = 0;
    if (_data_k_1733 >= _data_n_1733) {
      _data_k_1733 = 0;
    }
    ln22cs_[15] = _data_l_1733[_data_k_1733++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1734 = 0;
    if (_data_k_1734 >= _data_n_1734) {
      _data_k_1734 = 0;
    }
    ln22cs_[16] = _data_l_1734[_data_k_1734++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1735 = 0;
    if (_data_k_1735 >= _data_n_1735) {
      _data_k_1735 = 0;
    }
    ln22cs_[17] = _data_l_1735[_data_k_1735++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1736 = 0;
    if (_data_k_1736 >= _data_n_1736) {
      _data_k_1736 = 0;
    }
    ln22cs_[18] = _data_l_1736[_data_k_1736++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1737 = 0;
    if (_data_k_1737 >= _data_n_1737) {
      _data_k_1737 = 0;
    }
    ln22cs_[19] = _data_l_1737[_data_k_1737++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1738 = 0;
    if (_data_k_1738 >= _data_n_1738) {
      _data_k_1738 = 0;
    }
    ln22cs_[20] = _data_l_1738[_data_k_1738++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1739 = 0;
    if (_data_k_1739 >= _data_n_1739) {
      _data_k_1739 = 0;
    }
    ln22cs_[21] = _data_l_1739[_data_k_1739++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1740 = 0;
    if (_data_k_1740 >= _data_n_1740) {
      _data_k_1740 = 0;
    }
    ln22cs_[22] = _data_l_1740[_data_k_1740++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1741 = 0;
    if (_data_k_1741 >= _data_n_1741) {
      _data_k_1741 = 0;
    }
    ln22cs_[23] = _data_l_1741[_data_k_1741++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1742 = 0;
    if (_data_k_1742 >= _data_n_1742) {
      _data_k_1742 = 0;
    }
    ln22cs_[24] = _data_l_1742[_data_k_1742++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1743 = 0;
    if (_data_k_1743 >= _data_n_1743) {
      _data_k_1743 = 0;
    }
    ln22cs_[25] = _data_l_1743[_data_k_1743++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1744 = 0;
    if (_data_k_1744 >= _data_n_1744) {
      _data_k_1744 = 0;
    }
    ln22cs_[26] = _data_l_1744[_data_k_1744++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1745 = 0;
    if (_data_k_1745 >= _data_n_1745) {
      _data_k_1745 = 0;
    }
    ln22cs_[27] = _data_l_1745[_data_k_1745++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1746 = 0;
    if (_data_k_1746 >= _data_n_1746) {
      _data_k_1746 = 0;
    }
    ln22cs_[28] = _data_l_1746[_data_k_1746++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1747 = 0;
    if (_data_k_1747 >= _data_n_1747) {
      _data_k_1747 = 0;
    }
    ln22cs_[29] = _data_l_1747[_data_k_1747++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1748 = 0;
    if (_data_k_1748 >= _data_n_1748) {
      _data_k_1748 = 0;
    }
    ln22cs_[30] = _data_l_1748[_data_k_1748++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1749 = 0;
    if (_data_k_1749 >= _data_n_1749) {
      _data_k_1749 = 0;
    }
    ln22cs_[31] = _data_l_1749[_data_k_1749++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1750 = 0;
    if (_data_k_1750 >= _data_n_1750) {
      _data_k_1750 = 0;
    }
    ln22cs_[32] = _data_l_1750[_data_k_1750++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1751 = 0;
    if (_data_k_1751 >= _data_n_1751) {
      _data_k_1751 = 0;
    }
    ln22cs_[33] = _data_l_1751[_data_k_1751++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1752 = 0;
    if (_data_k_1752 >= _data_n_1752) {
      _data_k_1752 = 0;
    }
    ln22cs_[34] = _data_l_1752[_data_k_1752++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1753 = 0;
    if (_data_k_1753 >= _data_n_1753) {
      _data_k_1753 = 0;
    }
    ln22cs_[35] = _data_l_1753[_data_k_1753++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1754 = 0;
    if (_data_k_1754 >= _data_n_1754) {
      _data_k_1754 = 0;
    }
    ln22cs_[36] = _data_l_1754[_data_k_1754++];
  }
  if (__calls[106].calls == 0) {
    _data_k_1755 = 0;
    if (_data_k_1755 >= _data_n_1755) {
      _data_k_1755 = 0;
    }
    first_ = _data_l_1755[_data_k_1755++];
  }
  if (first_) {
    eps_ = _d1mach (($0_ = 3, &$0_));
    ntln21_ = _initds (ln21cs_, ($1_ = 50, &$1_), ($2_ = 0.1 * eps_, &$2_));
    ntln22_ = _initds (ln22cs_, ($3_ = 37, &$3_), ($4_ = 0.1 * eps_, &$4_));
    xmin_ = -1.0e0 + sqrt (_d1mach (($5_ = 4, &$5_)));
    sqeps_ = sqrtf (eps_);
    txmax_ = 8.0 / sqeps_;
    xmax_ = txmax_ - (eps_ * (txmax_ * txmax_) - 2.0e0 * log (txmax_)) / (2.0e0 * eps_ * txmax_);
    txbig_ = 6.0 / sqrtf (sqeps_);
    xbig_ = txbig_ - (sqeps_ * (txbig_ * txbig_) - 2.0e0 * log (txbig_)) / (2.0e0 * sqeps_ * txbig_);
  }
  first_ = FALSE;
  if ((*x_) < -.625e0 || (*x_) > 0.8125e0) {
    goto _l20;
  }
  if ((*x_) < 0.0e0) {
    d9ln2r_ = 0.375e0 + _dcsevl (($6_ = 16.0e0 * (*x_) / 5.0e0 + 1.0e0, &$6_), ln21cs_, &ntln21_);
  }
  if ((*x_) >= 0.0e0) {
    d9ln2r_ = 0.375e0 + _dcsevl (($7_ = 32.0e0 * (*x_) / 13.0e0 - 1.0e0, &$7_), ln22cs_, &ntln22_);
  }
  goto _l0;
  _l20:;
  if ((*x_) < xmin_) {
    (void) _xermsg (_dc_0, _dc_181, _dc_182, &_k1, &_k1);
  }
  if ((*x_) > xmax_) {
    (void) _xermsg (_dc_0, _dc_181, _dc_151, ($8_ = 3, &$8_), ($9_ = 2, &$9_));
  }
  if ((*x_) > xbig_) {
    (void) _xermsg (_dc_0, _dc_181, _dc_152, ($10_ = 2, &$10_), &_k1);
  }
  d9ln2r_ = (log (1.0e0 + (*x_)) - (*x_) * (1.0e0 - 0.5e0 * (*x_))) / ((*x_) * (*x_) * (*x_));
  _l0:;
  __calls[106].calls++;
  return d9ln2r_;
}

real_8 _d9pak (real_8 _p_ y_, int_4 _p_ n_)
{
  static int_4 nmin_, nmax_, ny_, nsum_;
  static logical_4 first_;
  static real_8 a1n2b_, a1n210_;
  int_4 _data_k_1756, _data_k_1757, $0_, $1_, $2_, $3_, $4_;
  real_8 d9pak_;
  extern real_8 _d1mach ();
  extern int_4 _i1mach ();
#define _data_n_1756 1
  static real_8 _data_l_1756[_data_n_1756] = {
    3.321928094887362347870319429489e0
  };
#define _data_n_1757 1
  static logical_4 _data_l_1757[_data_n_1757] = {
    TRUE
  };
  if (__calls[107].calls == 0) {
    _data_k_1756 = 0;
    if (_data_k_1756 >= _data_n_1756) {
      _data_k_1756 = 0;
    }
    a1n210_ = _data_l_1756[_data_k_1756++];
  }
  if (__calls[107].calls == 0) {
    _data_k_1757 = 0;
    if (_data_k_1757 >= _data_n_1757) {
      _data_k_1757 = 0;
    }
    first_ = _data_l_1757[_data_k_1757++];
  }
  if (first_) {
    a1n2b_ = 1.0;
    if (_i1mach (($0_ = 10, &$0_)) != 2) {
      a1n2b_ = _d1mach (($1_ = 5, &$1_)) * a1n210_;
    }
    nmin_ = a1n2b_ * _i1mach (($2_ = 15, &$2_));
    nmax_ = a1n2b_ * _i1mach (($3_ = 16, &$3_));
  }
  first_ = FALSE;
  (void) _d9upak (y_, &d9pak_, &ny_);
  nsum_ = (*n_) + ny_;
  if (nsum_ < nmin_) {
    goto _l40;
  }
  if (nsum_ > nmax_) {
    (void) _xermsg (_dc_0, _dc_183, _dc_184, &_k1, ($4_ = 2, &$4_));
  }
  if (nsum_ == 0) {
    goto _l0;
  }
  if (nsum_ > 0) {
    goto _l30;
  }
  _l20:;
  d9pak_ = 0.5e0 * d9pak_;
  nsum_ = nsum_ + 1;
  if (nsum_ != 0) {
    goto _l20;
  }
  goto _l0;
  _l30:;
  d9pak_ = 2.0e0 * d9pak_;
  nsum_ = nsum_ - 1;
  if (nsum_ != 0) {
    goto _l30;
  }
  goto _l0;
  _l40:;
  (void) _xermsg (_dc_0, _dc_183, _dc_185, &_k1, &_k1);
  d9pak_ = 0.0;
  _l0:;
  __calls[107].calls++;
  return d9pak_;
}

int_4 _d9upak (real_8 _p_ x_, real_8 _p_ y_, int_4 _p_ n_)
{
  static real_8 absx_;
  absx_ = _abs ((*x_));
  (*n_) = 0;
  if ((*x_) == 0.0e0) {
    goto _l30;
  }
  _l10:;
  if (absx_ >= 0.5e0) {
    goto _l20;
  }
  (*n_) = (*n_) - 1;
  absx_ = absx_ * 2.0e0;
  goto _l10;
  _l20:;
  if (absx_ < 1.0e0) {
    goto _l30;
  }
  (*n_) = (*n_) + 1;
  absx_ = absx_ * 0.5e0;
  goto _l20;
  _l30:;
  (*y_) = _sign (absx_, (*x_));
  __calls[108].calls++;
  return 0;
}

real_8 _daie (real_8 _p_ x_)
{
  static int_4 naif_, naig_, naip1_, naip2_;
  static logical_4 first_;
  static real_4 eta_;
  static real_8 aifcs_[13], aigcs_[13], aip1cs_[57], aip2cs_[37], sqrtx_, theta_, xbig_, xm_, x3sml_, x32sml_, z_;
  int_4 _data_k_1758, _data_k_1759, _data_k_1760, _data_k_1761, _data_k_1762, _data_k_1763, _data_k_1764, _data_k_1765, 
  _data_k_1766, _data_k_1767, _data_k_1768, _data_k_1769, _data_k_1770, _data_k_1771, _data_k_1772, _data_k_1773, 
  _data_k_1774, _data_k_1775, _data_k_1776, _data_k_1777, _data_k_1778, _data_k_1779, _data_k_1780, _data_k_1781, 
  _data_k_1782, _data_k_1783, _data_k_1784, _data_k_1785, _data_k_1786, _data_k_1787, _data_k_1788, _data_k_1789, 
  _data_k_1790, _data_k_1791, _data_k_1792, _data_k_1793, _data_k_1794, _data_k_1795, _data_k_1796, _data_k_1797, 
  _data_k_1798, _data_k_1799, _data_k_1800, _data_k_1801, _data_k_1802, _data_k_1803, _data_k_1804, _data_k_1805, 
  _data_k_1806, _data_k_1807, _data_k_1808, _data_k_1809, _data_k_1810, _data_k_1811, _data_k_1812, _data_k_1813, 
  _data_k_1814, _data_k_1815, _data_k_1816, _data_k_1817, _data_k_1818, _data_k_1819, _data_k_1820, _data_k_1821, 
  _data_k_1822, _data_k_1823, _data_k_1824, _data_k_1825, _data_k_1826, _data_k_1827, _data_k_1828, _data_k_1829, 
  _data_k_1830, _data_k_1831, _data_k_1832, _data_k_1833, _data_k_1834, _data_k_1835, _data_k_1836, _data_k_1837, 
  _data_k_1838, _data_k_1839, _data_k_1840, _data_k_1841, _data_k_1842, _data_k_1843, _data_k_1844, _data_k_1845, 
  _data_k_1846, _data_k_1847, _data_k_1848, _data_k_1849, _data_k_1850, _data_k_1851, _data_k_1852, _data_k_1853, 
  _data_k_1854, _data_k_1855, _data_k_1856, _data_k_1857, _data_k_1858, _data_k_1859, _data_k_1860, _data_k_1861, 
  _data_k_1862, _data_k_1863, _data_k_1864, _data_k_1865, _data_k_1866, _data_k_1867, _data_k_1868, _data_k_1869, 
  _data_k_1870, _data_k_1871, _data_k_1872, _data_k_1873, _data_k_1874, _data_k_1875, _data_k_1876, _data_k_1877, 
  _data_k_1878, $0_, $1_, $2_, $3_, $4_, $5_;
  real_8 daie_;
  extern real_8 _d1mach ();
#define _data_n_1758 1
  static real_8 _data_l_1758[_data_n_1758] = {
    -.37971358496669997496197089469414e-1
  };
#define _data_n_1759 1
  static real_8 _data_l_1759[_data_n_1759] = {
    .59191888537263638574319728013777e-1
  };
#define _data_n_1760 1
  static real_8 _data_l_1760[_data_n_1760] = {
    .9862928057727997536560389104406e-3
  };
#define _data_n_1761 1
  static real_8 _data_l_1761[_data_n_1761] = {
    .68488438190765667554854830182412e-5
  };
#define _data_n_1762 1
  static real_8 _data_l_1762[_data_n_1762] = {
    .25942025962194713019489279081403e-7
  };
#define _data_n_1763 1
  static real_8 _data_l_1763[_data_n_1763] = {
    .61766127740813750329445749697236e-10
  };
#define _data_n_1764 1
  static real_8 _data_l_1764[_data_n_1764] = {
    .10092454172466117901429556224601e-12
  };
#define _data_n_1765 1
  static real_8 _data_l_1765[_data_n_1765] = {
    .12014792511179938141288033225333e-15
  };
#define _data_n_1766 1
  static real_8 _data_l_1766[_data_n_1766] = {
    .10882945588716991878525295466666e-18
  };
#define _data_n_1767 1
  static real_8 _data_l_1767[_data_n_1767] = {
    .775137721966848870392384e-22
  };
#define _data_n_1768 1
  static real_8 _data_l_1768[_data_n_1768] = {
    .44548112037175638391466666666666e-25
  };
#define _data_n_1769 1
  static real_8 _data_l_1769[_data_n_1769] = {
    .21092845231692343466666666666666e-28
  };
#define _data_n_1770 1
  static real_8 _data_l_1770[_data_n_1770] = {
    .83701735910741333333333333333333e-32
  };
#define _data_n_1771 1
  static real_8 _data_l_1771[_data_n_1771] = {
    .18152365581161273011556209957864e-1
  };
#define _data_n_1772 1
  static real_8 _data_l_1772[_data_n_1772] = {
    .21572563166010755534030638819968e-1
  };
#define _data_n_1773 1
  static real_8 _data_l_1773[_data_n_1773] = {
    .25678356987483249659052428090133e-3
  };
#define _data_n_1774 1
  static real_8 _data_l_1774[_data_n_1774] = {
    .14265214119792403898829496921721e-5
  };
#define _data_n_1775 1
  static real_8 _data_l_1775[_data_n_1775] = {
    .45721149200180426070434097558191e-8
  };
#define _data_n_1776 1
  static real_8 _data_l_1776[_data_n_1776] = {
    .95251708435647098607392278840592e-11
  };
#define _data_n_1777 1
  static real_8 _data_l_1777[_data_n_1777] = {
    .1392563460577139905115042068619e-13
  };
#define _data_n_1778 1
  static real_8 _data_l_1778[_data_n_1778] = {
    .15070999142762379592306991138666e-16
  };
#define _data_n_1779 1
  static real_8 _data_l_1779[_data_n_1779] = {
    .12559148312567778822703205333333e-19
  };
#define _data_n_1780 1
  static real_8 _data_l_1780[_data_n_1780] = {
    .83063073770821340343829333333333e-23
  };
#define _data_n_1781 1
  static real_8 _data_l_1781[_data_n_1781] = {
    .44657538493718567445333333333333e-26
  };
#define _data_n_1782 1
  static real_8 _data_l_1782[_data_n_1782] = {
    .19900855034518869333333333333333e-29
  };
#define _data_n_1783 1
  static real_8 _data_l_1783[_data_n_1783] = {
    .74702885256533333333333333333333e-33
  };
#define _data_n_1784 1
  static real_8 _data_l_1784[_data_n_1784] = {
    -.2146951858910538455460863467778e-1
  };
#define _data_n_1785 1
  static real_8 _data_l_1785[_data_n_1785] = {
    -.7535382535043301166219720865565e-2
  };
#define _data_n_1786 1
  static real_8 _data_l_1786[_data_n_1786] = {
    .5971527949026380852035388881994e-3
  };
#define _data_n_1787 1
  static real_8 _data_l_1787[_data_n_1787] = {
    -.7283251254207610648502368291548e-4
  };
#define _data_n_1788 1
  static real_8 _data_l_1788[_data_n_1788] = {
    .111029713073929966651738182114e-4
  };
#define _data_n_1789 1
  static real_8 _data_l_1789[_data_n_1789] = {
    -.1950386152284405710346930314033e-5
  };
#define _data_n_1790 1
  static real_8 _data_l_1790[_data_n_1790] = {
    .3786973885159515193885319670057e-6
  };
#define _data_n_1791 1
  static real_8 _data_l_1791[_data_n_1791] = {
    -.7929675297350978279039072879154e-7
  };
#define _data_n_1792 1
  static real_8 _data_l_1792[_data_n_1792] = {
    .1762247638674256075568420122202e-7
  };
#define _data_n_1793 1
  static real_8 _data_l_1793[_data_n_1793] = {
    -.4110767539667195045029896593893e-8
  };
#define _data_n_1794 1
  static real_8 _data_l_1794[_data_n_1794] = {
    .9984770057857892247183414107544e-9
  };
#define _data_n_1795 1
  static real_8 _data_l_1795[_data_n_1795] = {
    -.2510093251387122211349867730034e-9
  };
#define _data_n_1796 1
  static real_8 _data_l_1796[_data_n_1796] = {
    .6500501929860695409272038601725e-10
  };
#define _data_n_1797 1
  static real_8 _data_l_1797[_data_n_1797] = {
    -.1727818405393616515478877107366e-10
  };
#define _data_n_1798 1
  static real_8 _data_l_1798[_data_n_1798] = {
    .4699378842824512578362292872307e-11
  };
#define _data_n_1799 1
  static real_8 _data_l_1799[_data_n_1799] = {
    -.1304675656297743914491241246272e-11
  };
#define _data_n_1800 1
  static real_8 _data_l_1800[_data_n_1800] = {
    .3689698478462678810473948382282e-12
  };
#define _data_n_1801 1
  static real_8 _data_l_1801[_data_n_1801] = {
    -.1061087206646806173650359679035e-12
  };
#define _data_n_1802 1
  static real_8 _data_l_1802[_data_n_1802] = {
    .309841438487818743866021007011e-13
  };
#define _data_n_1803 1
  static real_8 _data_l_1803[_data_n_1803] = {
    -.9174908079824139307833423547851e-14
  };
#define _data_n_1804 1
  static real_8 _data_l_1804[_data_n_1804] = {
    .2752049140347210895693579062271e-14
  };
#define _data_n_1805 1
  static real_8 _data_l_1805[_data_n_1805] = {
    -.835375011592204655809139330188e-15
  };
#define _data_n_1806 1
  static real_8 _data_l_1806[_data_n_1806] = {
    .2563931129357934947568636168612e-15
  };
#define _data_n_1807 1
  static real_8 _data_l_1807[_data_n_1807] = {
    -.7950633762598854983273747289822e-16
  };
#define _data_n_1808 1
  static real_8 _data_l_1808[_data_n_1808] = {
    .2489283634603069977437281175644e-16
  };
#define _data_n_1809 1
  static real_8 _data_l_1809[_data_n_1809] = {
    -.7864326933928735569664626221296e-17
  };
#define _data_n_1810 1
  static real_8 _data_l_1810[_data_n_1810] = {
    .2505687311439975672324470645019e-17
  };
#define _data_n_1811 1
  static real_8 _data_l_1811[_data_n_1811] = {
    -.8047420364163909524537958682241e-18
  };
#define _data_n_1812 1
  static real_8 _data_l_1812[_data_n_1812] = {
    .2604097118952053964443401104392e-18
  };
#define _data_n_1813 1
  static real_8 _data_l_1813[_data_n_1813] = {
    -.8486954164056412259482488834184e-19
  };
#define _data_n_1814 1
  static real_8 _data_l_1814[_data_n_1814] = {
    .2784706882142337843359429186027e-19
  };
#define _data_n_1815 1
  static real_8 _data_l_1815[_data_n_1815] = {
    -.9195858953498612913687224151354e-20
  };
#define _data_n_1816 1
  static real_8 _data_l_1816[_data_n_1816] = {
    .3055304318374238742247668225583e-20
  };
#define _data_n_1817 1
  static real_8 _data_l_1817[_data_n_1817] = {
    -.1021035455479477875902177048439e-20
  };
#define _data_n_1818 1
  static real_8 _data_l_1818[_data_n_1818] = {
    .3431118190743757844000555680836e-21
  };
#define _data_n_1819 1
  static real_8 _data_l_1819[_data_n_1819] = {
    -.1159129341797749513376922463109e-21
  };
#define _data_n_1820 1
  static real_8 _data_l_1820[_data_n_1820] = {
    .3935772844200255610836268229154e-22
  };
#define _data_n_1821 1
  static real_8 _data_l_1821[_data_n_1821] = {
    -.1342880980296717611956718989038e-22
  };
#define _data_n_1822 1
  static real_8 _data_l_1822[_data_n_1822] = {
    .4603287883520002741659190305314e-23
  };
#define _data_n_1823 1
  static real_8 _data_l_1823[_data_n_1823] = {
    -.1585043927004064227810772499387e-23
  };
#define _data_n_1824 1
  static real_8 _data_l_1824[_data_n_1824] = {
    .5481275667729675908925523755008e-24
  };
#define _data_n_1825 1
  static real_8 _data_l_1825[_data_n_1825] = {
    -.1903349371855047259064017948945e-24
  };
#define _data_n_1826 1
  static real_8 _data_l_1826[_data_n_1826] = {
    .6635682302374008716777612115968e-25
  };
#define _data_n_1827 1
  static real_8 _data_l_1827[_data_n_1827] = {
    -.2322311650026314307975200986453e-25
  };
#define _data_n_1828 1
  static real_8 _data_l_1828[_data_n_1828] = {
    .8157640113429179313142743695359e-26
  };
#define _data_n_1829 1
  static real_8 _data_l_1829[_data_n_1829] = {
    -.2875824240632900490057489929557e-26
  };
#define _data_n_1830 1
  static real_8 _data_l_1830[_data_n_1830] = {
    .1017329450942901435079714319018e-26
  };
#define _data_n_1831 1
  static real_8 _data_l_1831[_data_n_1831] = {
    -.3610879108742216446575703490559e-27
  };
#define _data_n_1832 1
  static real_8 _data_l_1832[_data_n_1832] = {
    .1285788540363993421256640342698e-27
  };
#define _data_n_1833 1
  static real_8 _data_l_1833[_data_n_1833] = {
    -.4592901037378547425160693022719e-28
  };
#define _data_n_1834 1
  static real_8 _data_l_1834[_data_n_1834] = {
    .1645597033820713725812102485333e-28
  };
#define _data_n_1835 1
  static real_8 _data_l_1835[_data_n_1835] = {
    -.591342129984350184208792027136e-29
  };
#define _data_n_1836 1
  static real_8 _data_l_1836[_data_n_1836] = {
    .2131057006604993303479369509546e-29
  };
#define _data_n_1837 1
  static real_8 _data_l_1837[_data_n_1837] = {
    -.7701158157787598216982761745066e-30
  };
#define _data_n_1838 1
  static real_8 _data_l_1838[_data_n_1838] = {
    .279053330796893041758178377728e-30
  };
#define _data_n_1839 1
  static real_8 _data_l_1839[_data_n_1839] = {
    -.1013807715111284006452241367039e-30
  };
#define _data_n_1840 1
  static real_8 _data_l_1840[_data_n_1840] = {
    .3692580158719624093658286216533e-31
  };
#define _data_n_1841 1
  static real_8 _data_l_1841[_data_n_1841] = {
    -.174314496929375513390355844011e-2
  };
#define _data_n_1842 1
  static real_8 _data_l_1842[_data_n_1842] = {
    -.16789385432554167163219061348e-2
  };
#define _data_n_1843 1
  static real_8 _data_l_1843[_data_n_1843] = {
    .359653403352166035885983858114e-4
  };
#define _data_n_1844 1
  static real_8 _data_l_1844[_data_n_1844] = {
    -.1380818602739228354573993831e-5
  };
#define _data_n_1845 1
  static real_8 _data_l_1845[_data_n_1845] = {
    .741122807731505298848699095233e-7
  };
#define _data_n_1846 1
  static real_8 _data_l_1846[_data_n_1846] = {
    -.500238203900133013130422866325e-8
  };
#define _data_n_1847 1
  static real_8 _data_l_1847[_data_n_1847] = {
    .400693917417184240675446866355e-9
  };
#define _data_n_1848 1
  static real_8 _data_l_1848[_data_n_1848] = {
    -.367331242795905044199318496207e-10
  };
#define _data_n_1849 1
  static real_8 _data_l_1849[_data_n_1849] = {
    .376034439592373852439592002918e-11
  };
#define _data_n_1850 1
  static real_8 _data_l_1850[_data_n_1850] = {
    -.422321332718747538026564938968e-12
  };
#define _data_n_1851 1
  static real_8 _data_l_1851[_data_n_1851] = {
    .51350945403365707091961875412e-13
  };
#define _data_n_1852 1
  static real_8 _data_l_1852[_data_n_1852] = {
    -.669095850390477595651681356676e-14
  };
#define _data_n_1853 1
  static real_8 _data_l_1853[_data_n_1853] = {
    .926667545641290648239550724382e-15
  };
#define _data_n_1854 1
  static real_8 _data_l_1854[_data_n_1854] = {
    -.135514382416070576333397356591e-15
  };
#define _data_n_1855 1
  static real_8 _data_l_1855[_data_n_1855] = {
    .208115496312830995299006549335e-16
  };
#define _data_n_1856 1
  static real_8 _data_l_1856[_data_n_1856] = {
    -.334116499159176856871277570256e-17
  };
#define _data_n_1857 1
  static real_8 _data_l_1857[_data_n_1857] = {
    .558578584585924316868032946585e-18
  };
#define _data_n_1858 1
  static real_8 _data_l_1858[_data_n_1858] = {
    -.969219040152365247518658209109e-19
  };
#define _data_n_1859 1
  static real_8 _data_l_1859[_data_n_1859] = {
    .174045700128893206465696557738e-19
  };
#define _data_n_1860 1
  static real_8 _data_l_1860[_data_n_1860] = {
    -.322640979731130400247846333098e-20
  };
#define _data_n_1861 1
  static real_8 _data_l_1861[_data_n_1861] = {
    .616074471106625258533259618986e-21
  };
#define _data_n_1862 1
  static real_8 _data_l_1862[_data_n_1862] = {
    -.120936347982490059076420676266e-21
  };
#define _data_n_1863 1
  static real_8 _data_l_1863[_data_n_1863] = {
    .243632763310138108261570095786e-22
  };
#define _data_n_1864 1
  static real_8 _data_l_1864[_data_n_1864] = {
    -.502914221497457468943403144533e-23
  };
#define _data_n_1865 1
  static real_8 _data_l_1865[_data_n_1865] = {
    .106224175543635689495470626133e-23
  };
#define _data_n_1866 1
  static real_8 _data_l_1866[_data_n_1866] = {
    -.229284284895989241509856324266e-24
  };
#define _data_n_1867 1
  static real_8 _data_l_1867[_data_n_1867] = {
    .505181733929503744986884778666e-25
  };
#define _data_n_1868 1
  static real_8 _data_l_1868[_data_n_1868] = {
    -.11349812371441240497979392e-25
  };
#define _data_n_1869 1
  static real_8 _data_l_1869[_data_n_1869] = {
    .259765565985606980698374144e-26
  };
#define _data_n_1870 1
  static real_8 _data_l_1870[_data_n_1870] = {
    -.605124621542939506172231679999e-27
  };
#define _data_n_1871 1
  static real_8 _data_l_1871[_data_n_1871] = {
    .143359777966772800720295253333e-27
  };
#define _data_n_1872 1
  static real_8 _data_l_1872[_data_n_1872] = {
    -.345147757060899986280721066666e-28
  };
#define _data_n_1873 1
  static real_8 _data_l_1873[_data_n_1873] = {
    .843875190213646740427025066666e-29
  };
#define _data_n_1874 1
  static real_8 _data_l_1874[_data_n_1874] = {
    -.209396142298188169434453333333e-29
  };
#define _data_n_1875 1
  static real_8 _data_l_1875[_data_n_1875] = {
    .527008873478945503182848e-30
  };
#define _data_n_1876 1
  static real_8 _data_l_1876[_data_n_1876] = {
    -.134457433014553385789030399999e-30
  };
#define _data_n_1877 1
  static real_8 _data_l_1877[_data_n_1877] = {
    .347570964526601147340117333333e-31
  };
#define _data_n_1878 1
  static logical_4 _data_l_1878[_data_n_1878] = {
    TRUE
  };
  if (__calls[109].calls == 0) {
    _data_k_1758 = 0;
    if (_data_k_1758 >= _data_n_1758) {
      _data_k_1758 = 0;
    }
    aifcs_[0] = _data_l_1758[_data_k_1758++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1759 = 0;
    if (_data_k_1759 >= _data_n_1759) {
      _data_k_1759 = 0;
    }
    aifcs_[1] = _data_l_1759[_data_k_1759++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1760 = 0;
    if (_data_k_1760 >= _data_n_1760) {
      _data_k_1760 = 0;
    }
    aifcs_[2] = _data_l_1760[_data_k_1760++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1761 = 0;
    if (_data_k_1761 >= _data_n_1761) {
      _data_k_1761 = 0;
    }
    aifcs_[3] = _data_l_1761[_data_k_1761++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1762 = 0;
    if (_data_k_1762 >= _data_n_1762) {
      _data_k_1762 = 0;
    }
    aifcs_[4] = _data_l_1762[_data_k_1762++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1763 = 0;
    if (_data_k_1763 >= _data_n_1763) {
      _data_k_1763 = 0;
    }
    aifcs_[5] = _data_l_1763[_data_k_1763++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1764 = 0;
    if (_data_k_1764 >= _data_n_1764) {
      _data_k_1764 = 0;
    }
    aifcs_[6] = _data_l_1764[_data_k_1764++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1765 = 0;
    if (_data_k_1765 >= _data_n_1765) {
      _data_k_1765 = 0;
    }
    aifcs_[7] = _data_l_1765[_data_k_1765++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1766 = 0;
    if (_data_k_1766 >= _data_n_1766) {
      _data_k_1766 = 0;
    }
    aifcs_[8] = _data_l_1766[_data_k_1766++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1767 = 0;
    if (_data_k_1767 >= _data_n_1767) {
      _data_k_1767 = 0;
    }
    aifcs_[9] = _data_l_1767[_data_k_1767++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1768 = 0;
    if (_data_k_1768 >= _data_n_1768) {
      _data_k_1768 = 0;
    }
    aifcs_[10] = _data_l_1768[_data_k_1768++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1769 = 0;
    if (_data_k_1769 >= _data_n_1769) {
      _data_k_1769 = 0;
    }
    aifcs_[11] = _data_l_1769[_data_k_1769++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1770 = 0;
    if (_data_k_1770 >= _data_n_1770) {
      _data_k_1770 = 0;
    }
    aifcs_[12] = _data_l_1770[_data_k_1770++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1771 = 0;
    if (_data_k_1771 >= _data_n_1771) {
      _data_k_1771 = 0;
    }
    aigcs_[0] = _data_l_1771[_data_k_1771++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1772 = 0;
    if (_data_k_1772 >= _data_n_1772) {
      _data_k_1772 = 0;
    }
    aigcs_[1] = _data_l_1772[_data_k_1772++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1773 = 0;
    if (_data_k_1773 >= _data_n_1773) {
      _data_k_1773 = 0;
    }
    aigcs_[2] = _data_l_1773[_data_k_1773++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1774 = 0;
    if (_data_k_1774 >= _data_n_1774) {
      _data_k_1774 = 0;
    }
    aigcs_[3] = _data_l_1774[_data_k_1774++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1775 = 0;
    if (_data_k_1775 >= _data_n_1775) {
      _data_k_1775 = 0;
    }
    aigcs_[4] = _data_l_1775[_data_k_1775++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1776 = 0;
    if (_data_k_1776 >= _data_n_1776) {
      _data_k_1776 = 0;
    }
    aigcs_[5] = _data_l_1776[_data_k_1776++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1777 = 0;
    if (_data_k_1777 >= _data_n_1777) {
      _data_k_1777 = 0;
    }
    aigcs_[6] = _data_l_1777[_data_k_1777++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1778 = 0;
    if (_data_k_1778 >= _data_n_1778) {
      _data_k_1778 = 0;
    }
    aigcs_[7] = _data_l_1778[_data_k_1778++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1779 = 0;
    if (_data_k_1779 >= _data_n_1779) {
      _data_k_1779 = 0;
    }
    aigcs_[8] = _data_l_1779[_data_k_1779++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1780 = 0;
    if (_data_k_1780 >= _data_n_1780) {
      _data_k_1780 = 0;
    }
    aigcs_[9] = _data_l_1780[_data_k_1780++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1781 = 0;
    if (_data_k_1781 >= _data_n_1781) {
      _data_k_1781 = 0;
    }
    aigcs_[10] = _data_l_1781[_data_k_1781++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1782 = 0;
    if (_data_k_1782 >= _data_n_1782) {
      _data_k_1782 = 0;
    }
    aigcs_[11] = _data_l_1782[_data_k_1782++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1783 = 0;
    if (_data_k_1783 >= _data_n_1783) {
      _data_k_1783 = 0;
    }
    aigcs_[12] = _data_l_1783[_data_k_1783++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1784 = 0;
    if (_data_k_1784 >= _data_n_1784) {
      _data_k_1784 = 0;
    }
    aip1cs_[0] = _data_l_1784[_data_k_1784++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1785 = 0;
    if (_data_k_1785 >= _data_n_1785) {
      _data_k_1785 = 0;
    }
    aip1cs_[1] = _data_l_1785[_data_k_1785++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1786 = 0;
    if (_data_k_1786 >= _data_n_1786) {
      _data_k_1786 = 0;
    }
    aip1cs_[2] = _data_l_1786[_data_k_1786++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1787 = 0;
    if (_data_k_1787 >= _data_n_1787) {
      _data_k_1787 = 0;
    }
    aip1cs_[3] = _data_l_1787[_data_k_1787++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1788 = 0;
    if (_data_k_1788 >= _data_n_1788) {
      _data_k_1788 = 0;
    }
    aip1cs_[4] = _data_l_1788[_data_k_1788++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1789 = 0;
    if (_data_k_1789 >= _data_n_1789) {
      _data_k_1789 = 0;
    }
    aip1cs_[5] = _data_l_1789[_data_k_1789++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1790 = 0;
    if (_data_k_1790 >= _data_n_1790) {
      _data_k_1790 = 0;
    }
    aip1cs_[6] = _data_l_1790[_data_k_1790++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1791 = 0;
    if (_data_k_1791 >= _data_n_1791) {
      _data_k_1791 = 0;
    }
    aip1cs_[7] = _data_l_1791[_data_k_1791++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1792 = 0;
    if (_data_k_1792 >= _data_n_1792) {
      _data_k_1792 = 0;
    }
    aip1cs_[8] = _data_l_1792[_data_k_1792++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1793 = 0;
    if (_data_k_1793 >= _data_n_1793) {
      _data_k_1793 = 0;
    }
    aip1cs_[9] = _data_l_1793[_data_k_1793++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1794 = 0;
    if (_data_k_1794 >= _data_n_1794) {
      _data_k_1794 = 0;
    }
    aip1cs_[10] = _data_l_1794[_data_k_1794++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1795 = 0;
    if (_data_k_1795 >= _data_n_1795) {
      _data_k_1795 = 0;
    }
    aip1cs_[11] = _data_l_1795[_data_k_1795++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1796 = 0;
    if (_data_k_1796 >= _data_n_1796) {
      _data_k_1796 = 0;
    }
    aip1cs_[12] = _data_l_1796[_data_k_1796++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1797 = 0;
    if (_data_k_1797 >= _data_n_1797) {
      _data_k_1797 = 0;
    }
    aip1cs_[13] = _data_l_1797[_data_k_1797++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1798 = 0;
    if (_data_k_1798 >= _data_n_1798) {
      _data_k_1798 = 0;
    }
    aip1cs_[14] = _data_l_1798[_data_k_1798++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1799 = 0;
    if (_data_k_1799 >= _data_n_1799) {
      _data_k_1799 = 0;
    }
    aip1cs_[15] = _data_l_1799[_data_k_1799++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1800 = 0;
    if (_data_k_1800 >= _data_n_1800) {
      _data_k_1800 = 0;
    }
    aip1cs_[16] = _data_l_1800[_data_k_1800++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1801 = 0;
    if (_data_k_1801 >= _data_n_1801) {
      _data_k_1801 = 0;
    }
    aip1cs_[17] = _data_l_1801[_data_k_1801++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1802 = 0;
    if (_data_k_1802 >= _data_n_1802) {
      _data_k_1802 = 0;
    }
    aip1cs_[18] = _data_l_1802[_data_k_1802++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1803 = 0;
    if (_data_k_1803 >= _data_n_1803) {
      _data_k_1803 = 0;
    }
    aip1cs_[19] = _data_l_1803[_data_k_1803++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1804 = 0;
    if (_data_k_1804 >= _data_n_1804) {
      _data_k_1804 = 0;
    }
    aip1cs_[20] = _data_l_1804[_data_k_1804++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1805 = 0;
    if (_data_k_1805 >= _data_n_1805) {
      _data_k_1805 = 0;
    }
    aip1cs_[21] = _data_l_1805[_data_k_1805++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1806 = 0;
    if (_data_k_1806 >= _data_n_1806) {
      _data_k_1806 = 0;
    }
    aip1cs_[22] = _data_l_1806[_data_k_1806++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1807 = 0;
    if (_data_k_1807 >= _data_n_1807) {
      _data_k_1807 = 0;
    }
    aip1cs_[23] = _data_l_1807[_data_k_1807++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1808 = 0;
    if (_data_k_1808 >= _data_n_1808) {
      _data_k_1808 = 0;
    }
    aip1cs_[24] = _data_l_1808[_data_k_1808++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1809 = 0;
    if (_data_k_1809 >= _data_n_1809) {
      _data_k_1809 = 0;
    }
    aip1cs_[25] = _data_l_1809[_data_k_1809++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1810 = 0;
    if (_data_k_1810 >= _data_n_1810) {
      _data_k_1810 = 0;
    }
    aip1cs_[26] = _data_l_1810[_data_k_1810++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1811 = 0;
    if (_data_k_1811 >= _data_n_1811) {
      _data_k_1811 = 0;
    }
    aip1cs_[27] = _data_l_1811[_data_k_1811++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1812 = 0;
    if (_data_k_1812 >= _data_n_1812) {
      _data_k_1812 = 0;
    }
    aip1cs_[28] = _data_l_1812[_data_k_1812++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1813 = 0;
    if (_data_k_1813 >= _data_n_1813) {
      _data_k_1813 = 0;
    }
    aip1cs_[29] = _data_l_1813[_data_k_1813++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1814 = 0;
    if (_data_k_1814 >= _data_n_1814) {
      _data_k_1814 = 0;
    }
    aip1cs_[30] = _data_l_1814[_data_k_1814++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1815 = 0;
    if (_data_k_1815 >= _data_n_1815) {
      _data_k_1815 = 0;
    }
    aip1cs_[31] = _data_l_1815[_data_k_1815++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1816 = 0;
    if (_data_k_1816 >= _data_n_1816) {
      _data_k_1816 = 0;
    }
    aip1cs_[32] = _data_l_1816[_data_k_1816++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1817 = 0;
    if (_data_k_1817 >= _data_n_1817) {
      _data_k_1817 = 0;
    }
    aip1cs_[33] = _data_l_1817[_data_k_1817++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1818 = 0;
    if (_data_k_1818 >= _data_n_1818) {
      _data_k_1818 = 0;
    }
    aip1cs_[34] = _data_l_1818[_data_k_1818++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1819 = 0;
    if (_data_k_1819 >= _data_n_1819) {
      _data_k_1819 = 0;
    }
    aip1cs_[35] = _data_l_1819[_data_k_1819++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1820 = 0;
    if (_data_k_1820 >= _data_n_1820) {
      _data_k_1820 = 0;
    }
    aip1cs_[36] = _data_l_1820[_data_k_1820++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1821 = 0;
    if (_data_k_1821 >= _data_n_1821) {
      _data_k_1821 = 0;
    }
    aip1cs_[37] = _data_l_1821[_data_k_1821++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1822 = 0;
    if (_data_k_1822 >= _data_n_1822) {
      _data_k_1822 = 0;
    }
    aip1cs_[38] = _data_l_1822[_data_k_1822++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1823 = 0;
    if (_data_k_1823 >= _data_n_1823) {
      _data_k_1823 = 0;
    }
    aip1cs_[39] = _data_l_1823[_data_k_1823++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1824 = 0;
    if (_data_k_1824 >= _data_n_1824) {
      _data_k_1824 = 0;
    }
    aip1cs_[40] = _data_l_1824[_data_k_1824++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1825 = 0;
    if (_data_k_1825 >= _data_n_1825) {
      _data_k_1825 = 0;
    }
    aip1cs_[41] = _data_l_1825[_data_k_1825++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1826 = 0;
    if (_data_k_1826 >= _data_n_1826) {
      _data_k_1826 = 0;
    }
    aip1cs_[42] = _data_l_1826[_data_k_1826++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1827 = 0;
    if (_data_k_1827 >= _data_n_1827) {
      _data_k_1827 = 0;
    }
    aip1cs_[43] = _data_l_1827[_data_k_1827++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1828 = 0;
    if (_data_k_1828 >= _data_n_1828) {
      _data_k_1828 = 0;
    }
    aip1cs_[44] = _data_l_1828[_data_k_1828++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1829 = 0;
    if (_data_k_1829 >= _data_n_1829) {
      _data_k_1829 = 0;
    }
    aip1cs_[45] = _data_l_1829[_data_k_1829++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1830 = 0;
    if (_data_k_1830 >= _data_n_1830) {
      _data_k_1830 = 0;
    }
    aip1cs_[46] = _data_l_1830[_data_k_1830++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1831 = 0;
    if (_data_k_1831 >= _data_n_1831) {
      _data_k_1831 = 0;
    }
    aip1cs_[47] = _data_l_1831[_data_k_1831++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1832 = 0;
    if (_data_k_1832 >= _data_n_1832) {
      _data_k_1832 = 0;
    }
    aip1cs_[48] = _data_l_1832[_data_k_1832++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1833 = 0;
    if (_data_k_1833 >= _data_n_1833) {
      _data_k_1833 = 0;
    }
    aip1cs_[49] = _data_l_1833[_data_k_1833++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1834 = 0;
    if (_data_k_1834 >= _data_n_1834) {
      _data_k_1834 = 0;
    }
    aip1cs_[50] = _data_l_1834[_data_k_1834++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1835 = 0;
    if (_data_k_1835 >= _data_n_1835) {
      _data_k_1835 = 0;
    }
    aip1cs_[51] = _data_l_1835[_data_k_1835++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1836 = 0;
    if (_data_k_1836 >= _data_n_1836) {
      _data_k_1836 = 0;
    }
    aip1cs_[52] = _data_l_1836[_data_k_1836++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1837 = 0;
    if (_data_k_1837 >= _data_n_1837) {
      _data_k_1837 = 0;
    }
    aip1cs_[53] = _data_l_1837[_data_k_1837++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1838 = 0;
    if (_data_k_1838 >= _data_n_1838) {
      _data_k_1838 = 0;
    }
    aip1cs_[54] = _data_l_1838[_data_k_1838++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1839 = 0;
    if (_data_k_1839 >= _data_n_1839) {
      _data_k_1839 = 0;
    }
    aip1cs_[55] = _data_l_1839[_data_k_1839++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1840 = 0;
    if (_data_k_1840 >= _data_n_1840) {
      _data_k_1840 = 0;
    }
    aip1cs_[56] = _data_l_1840[_data_k_1840++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1841 = 0;
    if (_data_k_1841 >= _data_n_1841) {
      _data_k_1841 = 0;
    }
    aip2cs_[0] = _data_l_1841[_data_k_1841++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1842 = 0;
    if (_data_k_1842 >= _data_n_1842) {
      _data_k_1842 = 0;
    }
    aip2cs_[1] = _data_l_1842[_data_k_1842++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1843 = 0;
    if (_data_k_1843 >= _data_n_1843) {
      _data_k_1843 = 0;
    }
    aip2cs_[2] = _data_l_1843[_data_k_1843++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1844 = 0;
    if (_data_k_1844 >= _data_n_1844) {
      _data_k_1844 = 0;
    }
    aip2cs_[3] = _data_l_1844[_data_k_1844++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1845 = 0;
    if (_data_k_1845 >= _data_n_1845) {
      _data_k_1845 = 0;
    }
    aip2cs_[4] = _data_l_1845[_data_k_1845++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1846 = 0;
    if (_data_k_1846 >= _data_n_1846) {
      _data_k_1846 = 0;
    }
    aip2cs_[5] = _data_l_1846[_data_k_1846++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1847 = 0;
    if (_data_k_1847 >= _data_n_1847) {
      _data_k_1847 = 0;
    }
    aip2cs_[6] = _data_l_1847[_data_k_1847++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1848 = 0;
    if (_data_k_1848 >= _data_n_1848) {
      _data_k_1848 = 0;
    }
    aip2cs_[7] = _data_l_1848[_data_k_1848++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1849 = 0;
    if (_data_k_1849 >= _data_n_1849) {
      _data_k_1849 = 0;
    }
    aip2cs_[8] = _data_l_1849[_data_k_1849++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1850 = 0;
    if (_data_k_1850 >= _data_n_1850) {
      _data_k_1850 = 0;
    }
    aip2cs_[9] = _data_l_1850[_data_k_1850++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1851 = 0;
    if (_data_k_1851 >= _data_n_1851) {
      _data_k_1851 = 0;
    }
    aip2cs_[10] = _data_l_1851[_data_k_1851++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1852 = 0;
    if (_data_k_1852 >= _data_n_1852) {
      _data_k_1852 = 0;
    }
    aip2cs_[11] = _data_l_1852[_data_k_1852++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1853 = 0;
    if (_data_k_1853 >= _data_n_1853) {
      _data_k_1853 = 0;
    }
    aip2cs_[12] = _data_l_1853[_data_k_1853++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1854 = 0;
    if (_data_k_1854 >= _data_n_1854) {
      _data_k_1854 = 0;
    }
    aip2cs_[13] = _data_l_1854[_data_k_1854++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1855 = 0;
    if (_data_k_1855 >= _data_n_1855) {
      _data_k_1855 = 0;
    }
    aip2cs_[14] = _data_l_1855[_data_k_1855++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1856 = 0;
    if (_data_k_1856 >= _data_n_1856) {
      _data_k_1856 = 0;
    }
    aip2cs_[15] = _data_l_1856[_data_k_1856++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1857 = 0;
    if (_data_k_1857 >= _data_n_1857) {
      _data_k_1857 = 0;
    }
    aip2cs_[16] = _data_l_1857[_data_k_1857++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1858 = 0;
    if (_data_k_1858 >= _data_n_1858) {
      _data_k_1858 = 0;
    }
    aip2cs_[17] = _data_l_1858[_data_k_1858++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1859 = 0;
    if (_data_k_1859 >= _data_n_1859) {
      _data_k_1859 = 0;
    }
    aip2cs_[18] = _data_l_1859[_data_k_1859++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1860 = 0;
    if (_data_k_1860 >= _data_n_1860) {
      _data_k_1860 = 0;
    }
    aip2cs_[19] = _data_l_1860[_data_k_1860++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1861 = 0;
    if (_data_k_1861 >= _data_n_1861) {
      _data_k_1861 = 0;
    }
    aip2cs_[20] = _data_l_1861[_data_k_1861++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1862 = 0;
    if (_data_k_1862 >= _data_n_1862) {
      _data_k_1862 = 0;
    }
    aip2cs_[21] = _data_l_1862[_data_k_1862++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1863 = 0;
    if (_data_k_1863 >= _data_n_1863) {
      _data_k_1863 = 0;
    }
    aip2cs_[22] = _data_l_1863[_data_k_1863++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1864 = 0;
    if (_data_k_1864 >= _data_n_1864) {
      _data_k_1864 = 0;
    }
    aip2cs_[23] = _data_l_1864[_data_k_1864++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1865 = 0;
    if (_data_k_1865 >= _data_n_1865) {
      _data_k_1865 = 0;
    }
    aip2cs_[24] = _data_l_1865[_data_k_1865++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1866 = 0;
    if (_data_k_1866 >= _data_n_1866) {
      _data_k_1866 = 0;
    }
    aip2cs_[25] = _data_l_1866[_data_k_1866++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1867 = 0;
    if (_data_k_1867 >= _data_n_1867) {
      _data_k_1867 = 0;
    }
    aip2cs_[26] = _data_l_1867[_data_k_1867++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1868 = 0;
    if (_data_k_1868 >= _data_n_1868) {
      _data_k_1868 = 0;
    }
    aip2cs_[27] = _data_l_1868[_data_k_1868++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1869 = 0;
    if (_data_k_1869 >= _data_n_1869) {
      _data_k_1869 = 0;
    }
    aip2cs_[28] = _data_l_1869[_data_k_1869++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1870 = 0;
    if (_data_k_1870 >= _data_n_1870) {
      _data_k_1870 = 0;
    }
    aip2cs_[29] = _data_l_1870[_data_k_1870++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1871 = 0;
    if (_data_k_1871 >= _data_n_1871) {
      _data_k_1871 = 0;
    }
    aip2cs_[30] = _data_l_1871[_data_k_1871++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1872 = 0;
    if (_data_k_1872 >= _data_n_1872) {
      _data_k_1872 = 0;
    }
    aip2cs_[31] = _data_l_1872[_data_k_1872++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1873 = 0;
    if (_data_k_1873 >= _data_n_1873) {
      _data_k_1873 = 0;
    }
    aip2cs_[32] = _data_l_1873[_data_k_1873++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1874 = 0;
    if (_data_k_1874 >= _data_n_1874) {
      _data_k_1874 = 0;
    }
    aip2cs_[33] = _data_l_1874[_data_k_1874++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1875 = 0;
    if (_data_k_1875 >= _data_n_1875) {
      _data_k_1875 = 0;
    }
    aip2cs_[34] = _data_l_1875[_data_k_1875++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1876 = 0;
    if (_data_k_1876 >= _data_n_1876) {
      _data_k_1876 = 0;
    }
    aip2cs_[35] = _data_l_1876[_data_k_1876++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1877 = 0;
    if (_data_k_1877 >= _data_n_1877) {
      _data_k_1877 = 0;
    }
    aip2cs_[36] = _data_l_1877[_data_k_1877++];
  }
  if (__calls[109].calls == 0) {
    _data_k_1878 = 0;
    if (_data_k_1878 >= _data_n_1878) {
      _data_k_1878 = 0;
    }
    first_ = _data_l_1878[_data_k_1878++];
  }
  if (first_) {
    eta_ = 0.1 * (real_4) (_d1mach (($0_ = 3, &$0_)));
    naif_ = _initds (aifcs_, ($1_ = 13, &$1_), &eta_);
    naig_ = _initds (aigcs_, ($2_ = 13, &$2_), &eta_);
    naip1_ = _initds (aip1cs_, ($3_ = 57, &$3_), &eta_);
    naip2_ = _initds (aip2cs_, ($4_ = 37, &$4_), &eta_);
    x3sml_ = powl (eta_, 0.3333e0);
    x32sml_ = 1.3104e0 * (x3sml_ * x3sml_);
    xbig_ = pow (_d1mach (($5_ = 2, &$5_)), 0.6666e0);
  }
  first_ = FALSE;
  if ((*x_) >= -1.0) {
    goto _l20;
  }
  (void) _d9aimp (x_, &xm_, &theta_);
  daie_ = xm_ * cos (theta_);
  goto _l0;
  _l20:;
  if ((*x_) > 1.0e0) {
    goto _l30;
  }
  z_ = 0.0;
  if (_abs ((*x_)) > x3sml_) {
    z_ = ((*x_) * (*x_) * (*x_));
  }
  daie_ = 0.375e0 + (_dcsevl (&z_, aifcs_, &naif_) - (*x_) * (0.25e0 + _dcsevl (&z_, aigcs_, &naig_)));
  if ((*x_) > x32sml_) {
    daie_ = daie_ * exp (2.0e0 * (*x_) * sqrt ((*x_)) / 3.0e0);
  }
  goto _l0;
  _l30:;
  if ((*x_) > 4.0e0) {
    goto _l40;
  }
  sqrtx_ = sqrt ((*x_));
  z_ = (16.0e0 / ((*x_) * sqrtx_) - 9.0e0) / 7.0e0;
  daie_ = (0.28125e0 + _dcsevl (&z_, aip1cs_, &naip1_)) / sqrt (sqrtx_);
  goto _l0;
  _l40:;
  sqrtx_ = sqrt ((*x_));
  z_ = -1.0;
  if ((*x_) < xbig_) {
    z_ = 16.0e0 / ((*x_) * sqrtx_) - 1.0e0;
  }
  daie_ = (0.28125e0 + _dcsevl (&z_, aip2cs_, &naip2_)) / sqrt (sqrtx_);
  _l0:;
  __calls[109].calls++;
  return daie_;
}

real_8 _dai (real_8 _p_ x_)
{
  static int_4 naif_, naig_;
  static logical_4 first_;
  static real_8 aifcs_[13], aigcs_[13], theta_, xm_, xmax_, x3sml_, z_, xmaxt_;
  int_4 _data_k_1879, _data_k_1880, _data_k_1881, _data_k_1882, _data_k_1883, _data_k_1884, _data_k_1885, _data_k_1886, 
  _data_k_1887, _data_k_1888, _data_k_1889, _data_k_1890, _data_k_1891, _data_k_1892, _data_k_1893, _data_k_1894, 
  _data_k_1895, _data_k_1896, _data_k_1897, _data_k_1898, _data_k_1899, _data_k_1900, _data_k_1901, _data_k_1902, 
  _data_k_1903, _data_k_1904, _data_k_1905, $0_, $1_, $3_, $4_, $6_;
  real_4 $2_, $5_;
  real_8 dai_;
  extern real_8 _d1mach ();
#define _data_n_1879 1
  static real_8 _data_l_1879[_data_n_1879] = {
    -.37971358496669997496197089469414e-1
  };
#define _data_n_1880 1
  static real_8 _data_l_1880[_data_n_1880] = {
    .59191888537263638574319728013777e-1
  };
#define _data_n_1881 1
  static real_8 _data_l_1881[_data_n_1881] = {
    .9862928057727997536560389104406e-3
  };
#define _data_n_1882 1
  static real_8 _data_l_1882[_data_n_1882] = {
    .68488438190765667554854830182412e-5
  };
#define _data_n_1883 1
  static real_8 _data_l_1883[_data_n_1883] = {
    .25942025962194713019489279081403e-7
  };
#define _data_n_1884 1
  static real_8 _data_l_1884[_data_n_1884] = {
    .61766127740813750329445749697236e-10
  };
#define _data_n_1885 1
  static real_8 _data_l_1885[_data_n_1885] = {
    .10092454172466117901429556224601e-12
  };
#define _data_n_1886 1
  static real_8 _data_l_1886[_data_n_1886] = {
    .12014792511179938141288033225333e-15
  };
#define _data_n_1887 1
  static real_8 _data_l_1887[_data_n_1887] = {
    .10882945588716991878525295466666e-18
  };
#define _data_n_1888 1
  static real_8 _data_l_1888[_data_n_1888] = {
    .775137721966848870392384e-22
  };
#define _data_n_1889 1
  static real_8 _data_l_1889[_data_n_1889] = {
    .44548112037175638391466666666666e-25
  };
#define _data_n_1890 1
  static real_8 _data_l_1890[_data_n_1890] = {
    .21092845231692343466666666666666e-28
  };
#define _data_n_1891 1
  static real_8 _data_l_1891[_data_n_1891] = {
    .83701735910741333333333333333333e-32
  };
#define _data_n_1892 1
  static real_8 _data_l_1892[_data_n_1892] = {
    .18152365581161273011556209957864e-1
  };
#define _data_n_1893 1
  static real_8 _data_l_1893[_data_n_1893] = {
    .21572563166010755534030638819968e-1
  };
#define _data_n_1894 1
  static real_8 _data_l_1894[_data_n_1894] = {
    .25678356987483249659052428090133e-3
  };
#define _data_n_1895 1
  static real_8 _data_l_1895[_data_n_1895] = {
    .14265214119792403898829496921721e-5
  };
#define _data_n_1896 1
  static real_8 _data_l_1896[_data_n_1896] = {
    .45721149200180426070434097558191e-8
  };
#define _data_n_1897 1
  static real_8 _data_l_1897[_data_n_1897] = {
    .95251708435647098607392278840592e-11
  };
#define _data_n_1898 1
  static real_8 _data_l_1898[_data_n_1898] = {
    .1392563460577139905115042068619e-13
  };
#define _data_n_1899 1
  static real_8 _data_l_1899[_data_n_1899] = {
    .15070999142762379592306991138666e-16
  };
#define _data_n_1900 1
  static real_8 _data_l_1900[_data_n_1900] = {
    .12559148312567778822703205333333e-19
  };
#define _data_n_1901 1
  static real_8 _data_l_1901[_data_n_1901] = {
    .83063073770821340343829333333333e-23
  };
#define _data_n_1902 1
  static real_8 _data_l_1902[_data_n_1902] = {
    .44657538493718567445333333333333e-26
  };
#define _data_n_1903 1
  static real_8 _data_l_1903[_data_n_1903] = {
    .19900855034518869333333333333333e-29
  };
#define _data_n_1904 1
  static real_8 _data_l_1904[_data_n_1904] = {
    .74702885256533333333333333333333e-33
  };
#define _data_n_1905 1
  static logical_4 _data_l_1905[_data_n_1905] = {
    TRUE
  };
  if (__calls[110].calls == 0) {
    _data_k_1879 = 0;
    if (_data_k_1879 >= _data_n_1879) {
      _data_k_1879 = 0;
    }
    aifcs_[0] = _data_l_1879[_data_k_1879++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1880 = 0;
    if (_data_k_1880 >= _data_n_1880) {
      _data_k_1880 = 0;
    }
    aifcs_[1] = _data_l_1880[_data_k_1880++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1881 = 0;
    if (_data_k_1881 >= _data_n_1881) {
      _data_k_1881 = 0;
    }
    aifcs_[2] = _data_l_1881[_data_k_1881++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1882 = 0;
    if (_data_k_1882 >= _data_n_1882) {
      _data_k_1882 = 0;
    }
    aifcs_[3] = _data_l_1882[_data_k_1882++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1883 = 0;
    if (_data_k_1883 >= _data_n_1883) {
      _data_k_1883 = 0;
    }
    aifcs_[4] = _data_l_1883[_data_k_1883++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1884 = 0;
    if (_data_k_1884 >= _data_n_1884) {
      _data_k_1884 = 0;
    }
    aifcs_[5] = _data_l_1884[_data_k_1884++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1885 = 0;
    if (_data_k_1885 >= _data_n_1885) {
      _data_k_1885 = 0;
    }
    aifcs_[6] = _data_l_1885[_data_k_1885++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1886 = 0;
    if (_data_k_1886 >= _data_n_1886) {
      _data_k_1886 = 0;
    }
    aifcs_[7] = _data_l_1886[_data_k_1886++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1887 = 0;
    if (_data_k_1887 >= _data_n_1887) {
      _data_k_1887 = 0;
    }
    aifcs_[8] = _data_l_1887[_data_k_1887++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1888 = 0;
    if (_data_k_1888 >= _data_n_1888) {
      _data_k_1888 = 0;
    }
    aifcs_[9] = _data_l_1888[_data_k_1888++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1889 = 0;
    if (_data_k_1889 >= _data_n_1889) {
      _data_k_1889 = 0;
    }
    aifcs_[10] = _data_l_1889[_data_k_1889++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1890 = 0;
    if (_data_k_1890 >= _data_n_1890) {
      _data_k_1890 = 0;
    }
    aifcs_[11] = _data_l_1890[_data_k_1890++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1891 = 0;
    if (_data_k_1891 >= _data_n_1891) {
      _data_k_1891 = 0;
    }
    aifcs_[12] = _data_l_1891[_data_k_1891++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1892 = 0;
    if (_data_k_1892 >= _data_n_1892) {
      _data_k_1892 = 0;
    }
    aigcs_[0] = _data_l_1892[_data_k_1892++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1893 = 0;
    if (_data_k_1893 >= _data_n_1893) {
      _data_k_1893 = 0;
    }
    aigcs_[1] = _data_l_1893[_data_k_1893++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1894 = 0;
    if (_data_k_1894 >= _data_n_1894) {
      _data_k_1894 = 0;
    }
    aigcs_[2] = _data_l_1894[_data_k_1894++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1895 = 0;
    if (_data_k_1895 >= _data_n_1895) {
      _data_k_1895 = 0;
    }
    aigcs_[3] = _data_l_1895[_data_k_1895++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1896 = 0;
    if (_data_k_1896 >= _data_n_1896) {
      _data_k_1896 = 0;
    }
    aigcs_[4] = _data_l_1896[_data_k_1896++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1897 = 0;
    if (_data_k_1897 >= _data_n_1897) {
      _data_k_1897 = 0;
    }
    aigcs_[5] = _data_l_1897[_data_k_1897++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1898 = 0;
    if (_data_k_1898 >= _data_n_1898) {
      _data_k_1898 = 0;
    }
    aigcs_[6] = _data_l_1898[_data_k_1898++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1899 = 0;
    if (_data_k_1899 >= _data_n_1899) {
      _data_k_1899 = 0;
    }
    aigcs_[7] = _data_l_1899[_data_k_1899++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1900 = 0;
    if (_data_k_1900 >= _data_n_1900) {
      _data_k_1900 = 0;
    }
    aigcs_[8] = _data_l_1900[_data_k_1900++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1901 = 0;
    if (_data_k_1901 >= _data_n_1901) {
      _data_k_1901 = 0;
    }
    aigcs_[9] = _data_l_1901[_data_k_1901++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1902 = 0;
    if (_data_k_1902 >= _data_n_1902) {
      _data_k_1902 = 0;
    }
    aigcs_[10] = _data_l_1902[_data_k_1902++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1903 = 0;
    if (_data_k_1903 >= _data_n_1903) {
      _data_k_1903 = 0;
    }
    aigcs_[11] = _data_l_1903[_data_k_1903++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1904 = 0;
    if (_data_k_1904 >= _data_n_1904) {
      _data_k_1904 = 0;
    }
    aigcs_[12] = _data_l_1904[_data_k_1904++];
  }
  if (__calls[110].calls == 0) {
    _data_k_1905 = 0;
    if (_data_k_1905 >= _data_n_1905) {
      _data_k_1905 = 0;
    }
    first_ = _data_l_1905[_data_k_1905++];
  }
  if (first_) {
    naif_ = _initds (aifcs_, ($0_ = 13, &$0_), ($2_ = 0.1 * (real_4) (_d1mach (($1_ = 3, &$1_))), &$2_));
    naig_ = _initds (aigcs_, ($3_ = 13, &$3_), ($5_ = 0.1 * (real_4) (_d1mach (($4_ = 3, &$4_))), &$5_));
    x3sml_ = pow (_d1mach (($6_ = 3, &$6_)), 0.3334e0);
    xmaxt_ = pow ((-1.5e0 * log (_d1mach (&_k1))), 0.6667e0);
    xmax_ = xmaxt_ - xmaxt_ * log (xmaxt_) / (4.0e0 * sqrt (xmaxt_) + 1.0e0) - 0.01e0;
  }
  first_ = FALSE;
  if ((*x_) >= -1.0) {
    goto _l20;
  }
  (void) _d9aimp (x_, &xm_, &theta_);
  dai_ = xm_ * cos (theta_);
  goto _l0;
  _l20:;
  if ((*x_) > 1.0e0) {
    goto _l30;
  }
  z_ = 0.0;
  if (_abs ((*x_)) > x3sml_) {
    z_ = ((*x_) * (*x_) * (*x_));
  }
  dai_ = 0.375e0 + (_dcsevl (&z_, aifcs_, &naif_) - (*x_) * (0.25e0 + _dcsevl (&z_, aigcs_, &naig_)));
  goto _l0;
  _l30:;
  if ((*x_) > xmax_) {
    goto _l40;
  }
  dai_ = _daie (x_) * exp (-2.0e0 * (*x_) * sqrt ((*x_)) / 3.0e0);
  goto _l0;
  _l40:;
  dai_ = 0.0;
  (void) _xermsg (_dc_0, _dc_186, _dc_2, &_k1, &_k1);
  _l0:;
  __calls[110].calls++;
  return dai_;
}

int_4 _dasyjy (int_4 (*_funjy)(), real_8 _p_ x_, real_8 _p_ fnu_, real_8 _p_ flgjy_, int_4 _p_ in_, real_8 _p_ y_, 
real_8 _p_ wk_, int_4 _p_ iflw_)
{
  static int_4 i_, j_, jn_, jr_, ju_, k_, kb_, klast_, kmax_[5], kp1_, ks_, ksp1_, kstemp_, l_, lr_, lrp1_, iseta_, 
  isetb_;
  static real_8 abw2_, akm_, alfa_[104], (_p_ alfa1_), (_p_ alfa2_), ap_, ar_[8], asum_, az_, beta_[130], (_p_ beta1_), 
  (_p_ beta2_), (_p_ beta3_), br_[10], bsum_, c_[65], con1_, con2_, con548_, cr_[10], crz32_, dfi_, elim_, dr_[10], fi_, 
  fn_, fn2_, gama_[26], phi_, rcz_, rden_, relb_, rfn2_, rtz_, rzden_, sa_, sb_, suma_, sumb_, s1_, ta_, tau_, tb_, tfn_, 
  tol_, tols_, t2_, upol_[10], xx_, z_, z32_;
  int_4 _data_k_1906, _data_k_1907, _data_k_1908, _data_k_1909, _data_k_1910, _data_k_1911, _data_k_1912, _data_k_1913, 
  _data_k_1914, _data_k_1915, _data_k_1916, _data_k_1917, _data_k_1918, _data_k_1919, _data_k_1920, _data_k_1921, 
  _data_k_1922, $0_, $1_, $2_, $3_;
  extern int_4 _i1mach ();
  extern real_8 _d1mach ();
  alfa1_ = (real_8 (_p_)) alfa_;
  alfa2_ = (real_8 (_p_)) &(alfa_[52]);
  beta1_ = (real_8 (_p_)) beta_;
  beta2_ = (real_8 (_p_)) &(beta_[52]);
  beta3_ = (real_8 (_p_)) &(beta_[104]);
#define _data_n_1906 1
  static real_8 _data_l_1906[_data_n_1906] = {
    -6.90775527898214e+00
  };
#define _data_n_1907 3
  static real_8 _data_l_1907[_data_n_1907] = {
    6.66666666666667e-1,
    3.33333333333333e-1,
    1.04166666666667e-1
  };
#define _data_n_1908 8
  static real_8 _data_l_1908[_data_n_1908] = {
    8.35503472222222e-2,
    1.28226574556327e-1,
    2.9184902646414e-1,
    8.81627267443758e-1,
    3.32140828186277e+00,
    1.49957629868626e1,
    7.89230130115865e1,
    4.74451538868264e2
  };
#define _data_n_1909 10
  static real_8 _data_l_1909[_data_n_1909] = {
    -1.45833333333333e-1,
    -9.87413194444444e-2,
    -1.43312053915895e-1,
    -3.17227202678414e-1,
    -9.4242914795712e-1,
    -3.51120304082635e+00,
    -1.5727263620368e1,
    -8.22814390971859e1,
    -4.92355370523671e2,
    -3.31621856854797e3
  };
#define _data_n_1910 24
  static real_8 _data_l_1910[_data_n_1910] = {
    -2.08333333333333e-1,
    1.25e-1,
    3.34201388888889e-1,
    -4.01041666666667e-1,
    7.03125e-2,
    -1.02581259645062e+00,
    1.84646267361111e+00,
    -8.912109375e-1,
    7.32421875e-2,
    4.66958442342625e+00,
    -1.1207002616223e1,
    8.78912353515625e+00,
    -2.3640869140625e+00,
    1.12152099609375e-1,
    -2.82120725582002e1,
    8.46362176746007e1,
    -9.181824154324e1,
    4.25349987453885e1,
    -7.36879435947963e+00,
    2.27108001708984e-1,
    2.12570130039217e2,
    -7.65252468141182e2,
    1.059990452528e3,
    -6.99579627376133e2
  };
#define _data_n_1911 24
  static real_8 _data_l_1911[_data_n_1911] = {
    2.18190511744212e2,
    -2.64914304869516e1,
    5.72501420974731e-1,
    -1.91945766231841e3,
    8.06172218173731e3,
    -1.35865500064341e4,
    1.16553933368645e4,
    -5.3056469786134e3,
    1.20090291321635e3,
    -1.08090919788395e2,
    1.72772750258446e+00,
    2.02042913309661e4,
    -9.69805983886375e4,
    1.92547001232532e5,
    -2.03400177280416e5,
    1.22200464983017e5,
    -4.11926549688976e4,
    7.10951430248936e3,
    -4.93915304773088e2,
    6.07404200127348e+00,
    -2.42919187900551e5,
    1.31176361466298e6,
    -2.99801591853811e6,
    3.7632712976564e6
  };
#define _data_n_1912 17
  static real_8 _data_l_1912[_data_n_1912] = {
    -2.81356322658653e6,
    1.26836527332162e6,
    -3.31645172484564e5,
    4.52187689813627e4,
    -2.49983048181121e3,
    2.43805296995561e1,
    3.28446985307204e6,
    -1.97068191184322e7,
    5.09526024926646e7,
    -7.41051482115327e7,
    6.6344512274729e7,
    -3.75671766607634e7,
    1.32887671664218e7,
    -2.78561812808645e6,
    3.08186404612662e5,
    -1.3886089753717e4,
    1.10017140269247e2
  };
#define _data_n_1913 26
  static real_8 _data_l_1913[_data_n_1913] = {
    -4.44444444444444e-3,
    -9.22077922077922e-4,
    -8.84892884892885e-5,
    1.6592768783245e-4,
    2.46691372741793e-4,
    2.65995589346255e-4,
    2.61824297061501e-4,
    2.48730437344656e-4,
    2.32721040083232e-4,
    2.16362485712365e-4,
    2.00738858762752e-4,
    1.86267636637545e-4,
    1.73060775917876e-4,
    1.61091705929016e-4,
    1.50274774160908e-4,
    1.4050349739127e-4,
    1.31668816545923e-4,
    1.23667445598253e-4,
    1.16405271474738e-4,
    1.09798298372713e-4,
    1.03772410422993e-4,
    9.82626078369363e-5,
    9.32120517249503e-5,
    8.85710852478712e-5,
    8.429631057157e-5,
    8.03497548407791e-5
  };
#define _data_n_1914 26
  static real_8 _data_l_1914[_data_n_1914] = {
    6.93735541354589e-4,
    2.32241745182922e-4,
    -1.41986273556691e-5,
    -1.16444931672049e-4,
    -1.50803558053049e-4,
    -1.55121924918096e-4,
    -1.46809756646466e-4,
    -1.33815503867491e-4,
    -1.19744975684254e-4,
    -1.06184319207974e-4,
    -9.37699549891194e-5,
    -8.26923045588193e-5,
    -7.29374348155221e-5,
    -6.44042357721016e-5,
    -5.69611566009369e-5,
    -5.04731044303562e-5,
    -4.48134868008883e-5,
    -3.98688727717599e-5,
    -3.55400532972042e-5,
    -3.17414256609022e-5,
    -2.83996793904175e-5,
    -2.54522720634871e-5,
    -2.28459297164725e-5,
    -2.05352753106481e-5,
    -1.84816217627666e-5,
    -1.66519330021394e-5
  };
#define _data_n_1915 26
  static real_8 _data_l_1915[_data_n_1915] = {
    -3.54211971457744e-4,
    -1.56161263945159e-4,
    3.04465503594936e-5,
    1.30198655773243e-4,
    1.67471106699712e-4,
    1.70222587683593e-4,
    1.56501427608595e-4,
    1.36339170977445e-4,
    1.14886692029825e-4,
    9.45869093034688e-5,
    7.64498419250898e-5,
    6.07570334965197e-5,
    4.74394299290509e-5,
    3.62757512005344e-5,
    2.69939714979225e-5,
    1.93210938247939e-5,
    1.30056674793963e-5,
    7.82620866744497e-6,
    3.59257485819352e-6,
    1.44040049814252e-7,
    -2.65396769697939e-6,
    -4.91346867098486e-6,
    -6.72739296091248e-6,
    -8.17269379678658e-6,
    -9.31304715093561e-6,
    -1.02011418798016e-5
  };
#define _data_n_1916 26
  static real_8 _data_l_1916[_data_n_1916] = {
    3.78194199201773e-4,
    2.02471952761816e-4,
    -6.37938506318862e-5,
    -2.38598230603006e-4,
    -3.10916256027362e-4,
    -3.13680115247576e-4,
    -2.78950273791323e-4,
    -2.28564082619141e-4,
    -1.75245280340847e-4,
    -1.2554406306069e-4,
    -8.22982872820208e-5,
    -4.62860730588116e-5,
    -1.72334302366962e-5,
    5.60690482304602e-6,
    2.31395443148287e-5,
    3.62642745856794e-5,
    4.58006124490189e-5,
    5.24595294959114e-5,
    5.68396208545815e-5,
    5.94349820393104e-5,
    6.06478527578422e-5,
    6.08023907788436e-5,
    6.0157789453946e-5,
    5.89199657344698e-5,
    5.72515823777593e-5,
    5.52804375585853e-5
  };
#define _data_n_1917 26
  static real_8 _data_l_1917[_data_n_1917] = {
    1.79988721413553e-2,
    5.59964911064388e-3,
    2.88501402231133e-3,
    1.80096606761054e-3,
    1.24753110589199e-3,
    9.22878876572938e-4,
    7.14430421727287e-4,
    5.71787281789705e-4,
    4.69431007606482e-4,
    3.93232835462917e-4,
    3.34818889318298e-4,
    2.88952148495752e-4,
    2.52211615549573e-4,
    2.22280580798883e-4,
    1.97541838033063e-4,
    1.76836855019718e-4,
    1.59316899661821e-4,
    1.44347930197334e-4,
    1.31448068119965e-4,
    1.20245444949303e-4,
    1.10449144504599e-4,
    1.01828770740567e-4,
    9.41998224204238e-5,
    8.74130545753834e-5,
    8.13466262162801e-5,
    7.59002269646219e-5
  };
#define _data_n_1918 26
  static real_8 _data_l_1918[_data_n_1918] = {
    -1.49282953213429e-3,
    -8.78204709546389e-4,
    -5.02916549572035e-4,
    -2.94822138512746e-4,
    -1.75463996970783e-4,
    -1.04008550460816e-4,
    -5.96141953046458e-5,
    -3.12038929076098e-5,
    -1.2608973598023e-5,
    -2.4289260857573e-7,
    8.05996165414274e-6,
    1.36507009262147e-5,
    1.73964125472926e-5,
    1.98672978842134e-5,
    2.14463263790823e-5,
    2.23954659232457e-5,
    2.28967783814713e-5,
    2.30785389811178e-5,
    2.30321976080909e-5,
    2.28236073720349e-5,
    2.25005881105292e-5,
    2.20981015361991e-5,
    2.16418427448104e-5,
    2.11507649256221e-5,
    2.06388749782171e-5,
    2.01165241997082e-5
  };
#define _data_n_1919 26
  static real_8 _data_l_1919[_data_n_1919] = {
    5.52213076721293e-4,
    4.47932581552385e-4,
    2.79520653992021e-4,
    1.52468156198447e-4,
    6.93271105657044e-5,
    1.76258683069991e-5,
    -1.35744996343269e-5,
    -3.17972413350427e-5,
    -4.18861861696693e-5,
    -4.69004889379141e-5,
    -4.87665447413787e-5,
    -4.87010031186735e-5,
    -4.74755620890087e-5,
    -4.55813058138628e-5,
    -4.33309644511266e-5,
    -4.0923019315775e-5,
    -3.84822638603221e-5,
    -3.60857167535411e-5,
    -3.37793306123367e-5,
    -3.1588856077211e-5,
    -2.95269561750807e-5,
    -2.75978914828336e-5,
    -2.58006174666884e-5,
    -2.4130835676128e-5,
    -2.25823509518346e-5,
    -2.11479656768913e-5
  };
#define _data_n_1920 26
  static real_8 _data_l_1920[_data_n_1920] = {
    -4.7461779655996e-4,
    -4.77864567147321e-4,
    -3.20390228067038e-4,
    -1.61105016119962e-4,
    -4.25778101285435e-5,
    3.44571294294968e-5,
    7.97092684075675e-5,
    1.03138236708272e-4,
    1.12466775262204e-4,
    1.13103642108481e-4,
    1.08651634848774e-4,
    1.01437951597662e-4,
    9.29298396593364e-5,
    8.4029313301609e-5,
    7.52727991349134e-5,
    6.69632521975731e-5,
    5.92564547323195e-5,
    5.22169308826976e-5,
    4.58539485165361e-5,
    4.01445513891487e-5,
    3.50481730031328e-5,
    3.05157995034347e-5,
    2.64956119950516e-5,
    2.29363633690998e-5,
    1.97893056664022e-5,
    1.70091984636413e-5
  };
#define _data_n_1921 26
  static real_8 _data_l_1921[_data_n_1921] = {
    7.36465810572578e-4,
    8.72790805146194e-4,
    6.22614862573135e-4,
    2.85998154194304e-4,
    3.84737672879366e-6,
    -1.87906003636972e-4,
    -2.97603646594555e-4,
    -3.45998126832656e-4,
    -3.53382470916038e-4,
    -3.35715635775049e-4,
    -3.0432112478904e-4,
    -2.66722723047613e-4,
    -2.2765421412282e-4,
    -1.89922611854562e-4,
    -1.55058918599094e-4,
    -1.23778240761874e-4,
    -9.62926147717644e-5,
    -7.25178327714425e-5,
    -5.22070028895634e-5,
    -3.50347750511901e-5,
    -2.06489761035552e-5,
    -8.70106096849767e-6,
    1.136986866751e-6,
    9.16426474122779e-6,
    1.56477785428873e-5,
    2.08223629482467e-5
  };
#define _data_n_1922 26
  static real_8 _data_l_1922[_data_n_1922] = {
    6.29960524947437e-1,
    2.51984209978975e-1,
    1.54790300415656e-1,
    1.10713062416159e-1,
    8.57309395527395e-2,
    6.97161316958684e-2,
    5.86085671893714e-2,
    5.04698873536311e-2,
    4.42600580689155e-2,
    3.9372066154351e-2,
    3.54283195924455e-2,
    3.21818857502098e-2,
    2.94646240791158e-2,
    2.71581677112934e-2,
    2.51768272973862e-2,
    2.34570755306079e-2,
    2.19508390134907e-2,
    2.06210828235646e-2,
    1.94388240897881e-2,
    1.83810633800683e-2,
    1.74293213231963e-2,
    1.65685837786612e-2,
    1.57865285987918e-2,
    1.50729501494096e-2,
    1.44193250839955e-2,
    1.38184805735342e-2
  };
  if (__calls[111].calls == 0) {
    _data_k_1906 = 0;
    if (_data_k_1906 >= _data_n_1906) {
      _data_k_1906 = 0;
    }
    tols_ = _data_l_1906[_data_k_1906++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1907 = 0;
    if (_data_k_1907 >= _data_n_1907) {
      _data_k_1907 = 0;
    }
    con1_ = _data_l_1907[_data_k_1907++];
    if (_data_k_1907 >= _data_n_1907) {
      _data_k_1907 = 0;
    }
    con2_ = _data_l_1907[_data_k_1907++];
    if (_data_k_1907 >= _data_n_1907) {
      _data_k_1907 = 0;
    }
    con548_ = _data_l_1907[_data_k_1907++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1908 = 0;
    if (_data_k_1908 >= _data_n_1908) {
      _data_k_1908 = 0;
    }
    ar_[0] = _data_l_1908[_data_k_1908++];
    if (_data_k_1908 >= _data_n_1908) {
      _data_k_1908 = 0;
    }
    ar_[1] = _data_l_1908[_data_k_1908++];
    if (_data_k_1908 >= _data_n_1908) {
      _data_k_1908 = 0;
    }
    ar_[2] = _data_l_1908[_data_k_1908++];
    if (_data_k_1908 >= _data_n_1908) {
      _data_k_1908 = 0;
    }
    ar_[3] = _data_l_1908[_data_k_1908++];
    if (_data_k_1908 >= _data_n_1908) {
      _data_k_1908 = 0;
    }
    ar_[4] = _data_l_1908[_data_k_1908++];
    if (_data_k_1908 >= _data_n_1908) {
      _data_k_1908 = 0;
    }
    ar_[5] = _data_l_1908[_data_k_1908++];
    if (_data_k_1908 >= _data_n_1908) {
      _data_k_1908 = 0;
    }
    ar_[6] = _data_l_1908[_data_k_1908++];
    if (_data_k_1908 >= _data_n_1908) {
      _data_k_1908 = 0;
    }
    ar_[7] = _data_l_1908[_data_k_1908++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1909 = 0;
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[0] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[1] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[2] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[3] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[4] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[5] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[6] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[7] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[8] = _data_l_1909[_data_k_1909++];
    if (_data_k_1909 >= _data_n_1909) {
      _data_k_1909 = 0;
    }
    br_[9] = _data_l_1909[_data_k_1909++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1910 = 0;
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[0] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[1] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[2] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[3] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[4] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[5] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[6] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[7] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[8] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[9] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[10] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[11] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[12] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[13] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[14] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[15] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[16] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[17] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[18] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[19] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[20] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[21] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[22] = _data_l_1910[_data_k_1910++];
    if (_data_k_1910 >= _data_n_1910) {
      _data_k_1910 = 0;
    }
    c_[23] = _data_l_1910[_data_k_1910++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1911 = 0;
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[24] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[25] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[26] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[27] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[28] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[29] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[30] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[31] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[32] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[33] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[34] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[35] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[36] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[37] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[38] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[39] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[40] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[41] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[42] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[43] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[44] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[45] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[46] = _data_l_1911[_data_k_1911++];
    if (_data_k_1911 >= _data_n_1911) {
      _data_k_1911 = 0;
    }
    c_[47] = _data_l_1911[_data_k_1911++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1912 = 0;
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[48] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[49] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[50] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[51] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[52] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[53] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[54] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[55] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[56] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[57] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[58] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[59] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[60] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[61] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[62] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[63] = _data_l_1912[_data_k_1912++];
    if (_data_k_1912 >= _data_n_1912) {
      _data_k_1912 = 0;
    }
    c_[64] = _data_l_1912[_data_k_1912++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1913 = 0;
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[0] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[1] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[2] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[3] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[4] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[5] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[6] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[7] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[8] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[9] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[10] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[11] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[12] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[13] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[14] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[15] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[16] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[17] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[18] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[19] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[20] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[21] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[22] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[23] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[24] = _data_l_1913[_data_k_1913++];
    if (_data_k_1913 >= _data_n_1913) {
      _data_k_1913 = 0;
    }
    alfa1_[25] = _data_l_1913[_data_k_1913++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1914 = 0;
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[26] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[27] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[28] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[29] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[30] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[31] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[32] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[33] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[34] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[35] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[36] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[37] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[38] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[39] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[40] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[41] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[42] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[43] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[44] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[45] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[46] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[47] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[48] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[49] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[50] = _data_l_1914[_data_k_1914++];
    if (_data_k_1914 >= _data_n_1914) {
      _data_k_1914 = 0;
    }
    alfa1_[51] = _data_l_1914[_data_k_1914++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1915 = 0;
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[0] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[1] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[2] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[3] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[4] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[5] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[6] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[7] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[8] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[9] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[10] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[11] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[12] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[13] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[14] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[15] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[16] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[17] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[18] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[19] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[20] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[21] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[22] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[23] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[24] = _data_l_1915[_data_k_1915++];
    if (_data_k_1915 >= _data_n_1915) {
      _data_k_1915 = 0;
    }
    alfa2_[25] = _data_l_1915[_data_k_1915++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1916 = 0;
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[26] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[27] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[28] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[29] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[30] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[31] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[32] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[33] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[34] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[35] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[36] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[37] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[38] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[39] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[40] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[41] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[42] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[43] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[44] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[45] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[46] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[47] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[48] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[49] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[50] = _data_l_1916[_data_k_1916++];
    if (_data_k_1916 >= _data_n_1916) {
      _data_k_1916 = 0;
    }
    alfa2_[51] = _data_l_1916[_data_k_1916++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1917 = 0;
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[0] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[1] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[2] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[3] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[4] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[5] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[6] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[7] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[8] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[9] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[10] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[11] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[12] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[13] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[14] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[15] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[16] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[17] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[18] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[19] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[20] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[21] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[22] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[23] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[24] = _data_l_1917[_data_k_1917++];
    if (_data_k_1917 >= _data_n_1917) {
      _data_k_1917 = 0;
    }
    beta1_[25] = _data_l_1917[_data_k_1917++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1918 = 0;
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[26] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[27] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[28] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[29] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[30] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[31] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[32] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[33] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[34] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[35] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[36] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[37] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[38] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[39] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[40] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[41] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[42] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[43] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[44] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[45] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[46] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[47] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[48] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[49] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[50] = _data_l_1918[_data_k_1918++];
    if (_data_k_1918 >= _data_n_1918) {
      _data_k_1918 = 0;
    }
    beta1_[51] = _data_l_1918[_data_k_1918++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1919 = 0;
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[0] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[1] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[2] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[3] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[4] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[5] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[6] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[7] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[8] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[9] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[10] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[11] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[12] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[13] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[14] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[15] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[16] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[17] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[18] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[19] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[20] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[21] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[22] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[23] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[24] = _data_l_1919[_data_k_1919++];
    if (_data_k_1919 >= _data_n_1919) {
      _data_k_1919 = 0;
    }
    beta2_[25] = _data_l_1919[_data_k_1919++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1920 = 0;
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[26] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[27] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[28] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[29] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[30] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[31] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[32] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[33] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[34] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[35] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[36] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[37] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[38] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[39] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[40] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[41] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[42] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[43] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[44] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[45] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[46] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[47] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[48] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[49] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[50] = _data_l_1920[_data_k_1920++];
    if (_data_k_1920 >= _data_n_1920) {
      _data_k_1920 = 0;
    }
    beta2_[51] = _data_l_1920[_data_k_1920++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1921 = 0;
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[0] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[1] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[2] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[3] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[4] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[5] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[6] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[7] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[8] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[9] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[10] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[11] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[12] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[13] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[14] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[15] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[16] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[17] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[18] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[19] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[20] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[21] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[22] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[23] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[24] = _data_l_1921[_data_k_1921++];
    if (_data_k_1921 >= _data_n_1921) {
      _data_k_1921 = 0;
    }
    beta3_[25] = _data_l_1921[_data_k_1921++];
  }
  if (__calls[111].calls == 0) {
    _data_k_1922 = 0;
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[0] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[1] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[2] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[3] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[4] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[5] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[6] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[7] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[8] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[9] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[10] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[11] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[12] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[13] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[14] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[15] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[16] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[17] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[18] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[19] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[20] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[21] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[22] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[23] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[24] = _data_l_1922[_data_k_1922++];
    if (_data_k_1922 >= _data_n_1922) {
      _data_k_1922 = 0;
    }
    gama_[25] = _data_l_1922[_data_k_1922++];
  }
  ta_ = _d1mach (($0_ = 3, &$0_));
  tol_ = _max (ta_, 1.0e-15);
  tb_ = _d1mach (($1_ = 5, &$1_));
  ju_ = _i1mach (($2_ = 15, &$2_));
  if ((*flgjy_) == 1.0e0) {
    goto _l6;
  }
  jr_ = _i1mach (($3_ = 14, &$3_));
  elim_ = -2.303e0 * tb_ * (ju_ + jr_);
  goto _l7;
  _l6:;
  elim_ = -2.303e0 * (tb_ * ju_ + 3.0e0);
  _l7:;
  fn_ = (*fnu_);
  (*iflw_) = 0;
  for (jn_ = 1; jn_ <= (*in_); (jn_)++) {
    xx_ = (*x_) / fn_;
    wk_[0] = 1.0e0 - xx_ * xx_;
    abw2_ = _abs (wk_[0]);
    wk_[1] = sqrt (abw2_);
    wk_[6] = pow (fn_, con2_);
    if (abw2_ > 0.2775e0) {
      goto _l80;
    }
    sa_ = 0.0;
    if (abw2_ == 0.0e0) {
      goto _l10;
    }
    sa_ = tols_ / log (abw2_);
    _l10:;
    sb_ = sa_;
    for (i_ = 1; i_ <= 5; (i_)++) {
      akm_ = _max (sa_, 2.0);
      kmax_[i_ - 1] = (int_4) (_aintd (akm_));
      sa_ = sa_ + sb_;
    }
    kb_ = kmax_[4];
    klast_ = kb_ - 1;
    sa_ = gama_[kb_ - 1];
    for (k_ = 1; k_ <= klast_; (k_)++) {
      kb_ = kb_ - 1;
      sa_ = sa_ * wk_[0] + gama_[kb_ - 1];
    }
    z_ = wk_[0] * sa_;
    az_ = _abs (z_);
    rtz_ = sqrt (az_);
    wk_[2] = con1_ * az_ * rtz_;
    wk_[3] = wk_[2] * fn_;
    wk_[4] = rtz_ * wk_[6];
    wk_[5] = -wk_[4] * wk_[4];
    if (z_ <= 0.0e0) {
      goto _l35;
    }
    if (wk_[3] > elim_) {
      goto _l75;
    }
    wk_[5] = -wk_[5];
    _l35:;
    phi_ = sqrt (sqrt (sa_ + sa_ + sa_ + sa_));
    kb_ = kmax_[4];
    klast_ = kb_ - 1;
    sb_ = beta_[kb_ - 1];
    for (k_ = 1; k_ <= klast_; (k_)++) {
      kb_ = kb_ - 1;
      sb_ = sb_ * wk_[0] + beta_[kb_ - 1];
    }
    ksp1_ = 1;
    fn2_ = fn_ * fn_;
    rfn2_ = 1.0e0 / fn2_;
    rden_ = 1.0;
    asum_ = 1.0;
    relb_ = tol_ * _abs (sb_);
    bsum_ = sb_;
    for (ks_ = 1; ks_ <= 4; (ks_)++) {
      ksp1_ = ksp1_ + 1;
      rden_ = rden_ * rfn2_;
      kstemp_ = 5 - ks_;
      kb_ = kmax_[kstemp_ - 1];
      klast_ = kb_ - 1;
      sa_ = alfa_[kb_ - 1 + (26) * ((ks_ - 1))];
      sb_ = beta_[kb_ - 1 + (26) * ((ksp1_ - 1))];
      for (k_ = 1; k_ <= klast_; (k_)++) {
        kb_ = kb_ - 1;
        sa_ = sa_ * wk_[0] + alfa_[kb_ - 1 + (26) * ((ks_ - 1))];
        sb_ = sb_ * wk_[0] + beta_[kb_ - 1 + (26) * ((ksp1_ - 1))];
      }
      ta_ = sa_ * rden_;
      tb_ = sb_ * rden_;
      asum_ = asum_ + ta_;
      bsum_ = bsum_ + tb_;
      if (_abs (ta_) <= tol_ && _abs (tb_) <= relb_) {
        goto _l70;
      }
    }
    _l70:;
    bsum_ = bsum_ / (fn_ * wk_[6]);
    goto _l160;
    _l75:;
    (*iflw_) = 1;
    goto _l0;
    _l80:;
    upol_[0] = 1.0;
    tau_ = 1.0e0 / wk_[1];
    t2_ = 1.0e0 / wk_[0];
    if (wk_[0] >= 0.0e0) {
      goto _l90;
    }
    wk_[2] = _abs (wk_[1] - atan (wk_[1]));
    wk_[3] = wk_[2] * fn_;
    rcz_ = -con1_ / wk_[3];
    z32_ = 1.5e0 * wk_[2];
    rtz_ = pow (z32_, con2_);
    wk_[4] = rtz_ * wk_[6];
    wk_[5] = -wk_[4] * wk_[4];
    goto _l100;
    _l90:;
    wk_[2] = _abs (log ((1.0e0 + wk_[1]) / xx_) - wk_[1]);
    wk_[3] = wk_[2] * fn_;
    rcz_ = con1_ / wk_[3];
    if (wk_[3] > elim_) {
      goto _l75;
    }
    z32_ = 1.5e0 * wk_[2];
    rtz_ = pow (z32_, con2_);
    wk_[6] = pow (fn_, con2_);
    wk_[4] = rtz_ * wk_[6];
    wk_[5] = wk_[4] * wk_[4];
    _l100:;
    phi_ = sqrt ((rtz_ + rtz_) * tau_);
    tb_ = 1.0;
    asum_ = 1.0;
    tfn_ = tau_ / fn_;
    rden_ = 1.0e0 / fn_;
    rfn2_ = rden_ * rden_;
    rden_ = 1.0;
    upol_[1] = (c_[0] * t2_ + c_[1]) * tfn_;
    crz32_ = con548_ * rcz_;
    bsum_ = upol_[1] + crz32_;
    relb_ = tol_ * _abs (bsum_);
    ap_ = tfn_;
    ks_ = 0;
    kp1_ = 2;
    rzden_ = rcz_;
    l_ = 2;
    iseta_ = 0;
    isetb_ = 0;
    for (lr_ = 2; (2 > 0 ? lr_ <= 8 : lr_ >= 8); lr_ += 2) {
      lrp1_ = lr_ + 1;
      for (k_ = lr_; k_ <= lrp1_; (k_)++) {
        ks_ = ks_ + 1;
        kp1_ = kp1_ + 1;
        l_ = l_ + 1;
        s1_ = c_[l_ - 1];
        for (j_ = 2; j_ <= kp1_; (j_)++) {
          l_ = l_ + 1;
          s1_ = s1_ * t2_ + c_[l_ - 1];
        }
        ap_ = ap_ * tfn_;
        upol_[kp1_ - 1] = ap_ * s1_;
        cr_[ks_ - 1] = br_[ks_ - 1] * rzden_;
        rzden_ = rzden_ * rcz_;
        dr_[ks_ - 1] = ar_[ks_ - 1] * rzden_;
      }
      suma_ = upol_[lrp1_ - 1];
      sumb_ = upol_[lr_ + 2 - 1] + upol_[lrp1_ - 1] * crz32_;
      ju_ = lrp1_;
      for (jr_ = 1; jr_ <= lr_; (jr_)++) {
        ju_ = ju_ - 1;
        suma_ = suma_ + cr_[jr_ - 1] * upol_[ju_ - 1];
        sumb_ = sumb_ + dr_[jr_ - 1] * upol_[ju_ - 1];
      }
      rden_ = rden_ * rfn2_;
      tb_ = -tb_;
      if (wk_[0] > 0.0e0) {
        tb_ = _abs (tb_);
      }
      if (rden_ < tol_) {
        goto _l131;
      }
      asum_ = asum_ + suma_ * tb_;
      bsum_ = bsum_ + sumb_ * tb_;
      goto _l140;
      _l131:;
      if (iseta_ == 1) {
        goto _l132;
      }
      if (_abs (suma_) < tol_) {
        iseta_ = 1;
      }
      asum_ = asum_ + suma_ * tb_;
      _l132:;
      if (isetb_ == 1) {
        goto _l133;
      }
      if (_abs (sumb_) < relb_) {
        isetb_ = 1;
      }
      bsum_ = bsum_ + sumb_ * tb_;
      _l133:;
      if (iseta_ == 1 && isetb_ == 1) {
        goto _l150;
      }
      _l140:;
    }
    _l150:;
    tb_ = wk_[4];
    if (wk_[0] > 0.0e0) {
      tb_ = -tb_;
    }
    bsum_ = bsum_ / tb_;
    _l160:;
    (void) _funjy (&wk_[5], &wk_[4], &wk_[3], &fi_, &dfi_);
    ta_ = 1.0e0 / tol_;
    tb_ = _d1mach (&_k1) * ta_ * 1.0e3;
    if (_abs (fi_) > tb_) {
      goto _l165;
    }
    fi_ = fi_ * ta_;
    dfi_ = dfi_ * ta_;
    phi_ = phi_ * tol_;
    _l165:;
    y_[jn_ - 1] = (*flgjy_) * phi_ * (fi_ * asum_ + dfi_ * bsum_) / wk_[6];
    fn_ = fn_ - (*flgjy_);
  }
  _l0:;
  __calls[111].calls++;
  return 0;
}

real_4 _daws (real_4 _p_ x_)
{
  static int_4 ntdaw_, ntdaw2_, ntdawa_;
  static logical_4 first_;
  static real_4 daws_, dawcs_[13], daw2cs_[29], dawacs_[26], xsml_, xbig_, xmax_, eps_, y_;
  int_4 _data_k_1923, _data_k_1924, _data_k_1925, _data_k_1926, _data_k_1927, _data_k_1928, _data_k_1929, _data_k_1930, 
  _data_k_1931, _data_k_1932, _data_k_1933, _data_k_1934, _data_k_1935, _data_k_1936, _data_k_1937, _data_k_1938, 
  _data_k_1939, _data_k_1940, _data_k_1941, _data_k_1942, _data_k_1943, _data_k_1944, _data_k_1945, _data_k_1946, 
  _data_k_1947, _data_k_1948, _data_k_1949, _data_k_1950, _data_k_1951, _data_k_1952, _data_k_1953, _data_k_1954, 
  _data_k_1955, _data_k_1956, _data_k_1957, _data_k_1958, _data_k_1959, _data_k_1960, _data_k_1961, _data_k_1962, 
  _data_k_1963, _data_k_1964, _data_k_1965, _data_k_1966, _data_k_1967, _data_k_1968, _data_k_1969, _data_k_1970, 
  _data_k_1971, _data_k_1972, _data_k_1973, _data_k_1974, _data_k_1975, _data_k_1976, _data_k_1977, _data_k_1978, 
  _data_k_1979, _data_k_1980, _data_k_1981, _data_k_1982, _data_k_1983, _data_k_1984, _data_k_1985, _data_k_1986, 
  _data_k_1987, _data_k_1988, _data_k_1989, _data_k_1990, _data_k_1991, $0_, $1_, $3_, $5_, $7_;
  real_4 $2_, $4_, $6_, $8_, $9_, $10_;
  extern real_4 _r1mach ();
#define _data_n_1923 1
  static real_4 _data_l_1923[_data_n_1923] = {
    -.006351734375145949e0
  };
#define _data_n_1924 1
  static real_4 _data_l_1924[_data_n_1924] = {
    -.22940714796773869e0
  };
#define _data_n_1925 1
  static real_4 _data_l_1925[_data_n_1925] = {
    .022130500939084764e0
  };
#define _data_n_1926 1
  static real_4 _data_l_1926[_data_n_1926] = {
    -.001549265453892985e0
  };
#define _data_n_1927 1
  static real_4 _data_l_1927[_data_n_1927] = {
    .000084973277156849e0
  };
#define _data_n_1928 1
  static real_4 _data_l_1928[_data_n_1928] = {
    -.000003828266270972e0
  };
#define _data_n_1929 1
  static real_4 _data_l_1929[_data_n_1929] = {
    .000000146285480625e0
  };
#define _data_n_1930 1
  static real_4 _data_l_1930[_data_n_1930] = {
    -.000000004851982381e0
  };
#define _data_n_1931 1
  static real_4 _data_l_1931[_data_n_1931] = {
    .000000000142146357e0
  };
#define _data_n_1932 1
  static real_4 _data_l_1932[_data_n_1932] = {
    -.000000000003728836e0
  };
#define _data_n_1933 1
  static real_4 _data_l_1933[_data_n_1933] = {
    .000000000000088549e0
  };
#define _data_n_1934 1
  static real_4 _data_l_1934[_data_n_1934] = {
    -.00000000000000192e0
  };
#define _data_n_1935 1
  static real_4 _data_l_1935[_data_n_1935] = {
    .000000000000000038e0
  };
#define _data_n_1936 1
  static real_4 _data_l_1936[_data_n_1936] = {
    -.056886544105215527e0
  };
#define _data_n_1937 1
  static real_4 _data_l_1937[_data_n_1937] = {
    -.31811346996168131e0
  };
#define _data_n_1938 1
  static real_4 _data_l_1938[_data_n_1938] = {
    .20873845413642237e0
  };
#define _data_n_1939 1
  static real_4 _data_l_1939[_data_n_1939] = {
    -.12475409913779131e0
  };
#define _data_n_1940 1
  static real_4 _data_l_1940[_data_n_1940] = {
    .067869305186676777e0
  };
#define _data_n_1941 1
  static real_4 _data_l_1941[_data_n_1941] = {
    -.03365914489527094e0
  };
#define _data_n_1942 1
  static real_4 _data_l_1942[_data_n_1942] = {
    .015260781271987972e0
  };
#define _data_n_1943 1
  static real_4 _data_l_1943[_data_n_1943] = {
    -.006348370962596214e0
  };
#define _data_n_1944 1
  static real_4 _data_l_1944[_data_n_1944] = {
    .002432674092074852e0
  };
#define _data_n_1945 1
  static real_4 _data_l_1945[_data_n_1945] = {
    -.00086219541491065e0
  };
#define _data_n_1946 1
  static real_4 _data_l_1946[_data_n_1946] = {
    .000283765733363216e0
  };
#define _data_n_1947 1
  static real_4 _data_l_1947[_data_n_1947] = {
    -.00008705754987417e0
  };
#define _data_n_1948 1
  static real_4 _data_l_1948[_data_n_1948] = {
    .000024986849985481e0
  };
#define _data_n_1949 1
  static real_4 _data_l_1949[_data_n_1949] = {
    -.000006731928676416e0
  };
#define _data_n_1950 1
  static real_4 _data_l_1950[_data_n_1950] = {
    .000001707857878557e0
  };
#define _data_n_1951 1
  static real_4 _data_l_1951[_data_n_1951] = {
    -.000000409175512264e0
  };
#define _data_n_1952 1
  static real_4 _data_l_1952[_data_n_1952] = {
    .000000092828292216e0
  };
#define _data_n_1953 1
  static real_4 _data_l_1953[_data_n_1953] = {
    -.00000001999140361e0
  };
#define _data_n_1954 1
  static real_4 _data_l_1954[_data_n_1954] = {
    .000000004096349064e0
  };
#define _data_n_1955 1
  static real_4 _data_l_1955[_data_n_1955] = {
    -.000000000800324095e0
  };
#define _data_n_1956 1
  static real_4 _data_l_1956[_data_n_1956] = {
    .000000000149385031e0
  };
#define _data_n_1957 1
  static real_4 _data_l_1957[_data_n_1957] = {
    -.000000000026687999e0
  };
#define _data_n_1958 1
  static real_4 _data_l_1958[_data_n_1958] = {
    .000000000004571221e0
  };
#define _data_n_1959 1
  static real_4 _data_l_1959[_data_n_1959] = {
    -.000000000000751873e0
  };
#define _data_n_1960 1
  static real_4 _data_l_1960[_data_n_1960] = {
    .000000000000118931e0
  };
#define _data_n_1961 1
  static real_4 _data_l_1961[_data_n_1961] = {
    -.000000000000018116e0
  };
#define _data_n_1962 1
  static real_4 _data_l_1962[_data_n_1962] = {
    .000000000000002661e0
  };
#define _data_n_1963 1
  static real_4 _data_l_1963[_data_n_1963] = {
    -.000000000000000377e0
  };
#define _data_n_1964 1
  static real_4 _data_l_1964[_data_n_1964] = {
    .000000000000000051e0
  };
#define _data_n_1965 1
  static real_4 _data_l_1965[_data_n_1965] = {
    .01690485637765704e0
  };
#define _data_n_1966 1
  static real_4 _data_l_1966[_data_n_1966] = {
    .00868325227840695e0
  };
#define _data_n_1967 1
  static real_4 _data_l_1967[_data_n_1967] = {
    .00024248640424177e0
  };
#define _data_n_1968 1
  static real_4 _data_l_1968[_data_n_1968] = {
    .00001261182399572e0
  };
#define _data_n_1969 1
  static real_4 _data_l_1969[_data_n_1969] = {
    .00000106645331463e0
  };
#define _data_n_1970 1
  static real_4 _data_l_1970[_data_n_1970] = {
    .00000013581597947e0
  };
#define _data_n_1971 1
  static real_4 _data_l_1971[_data_n_1971] = {
    .00000002171042356e0
  };
#define _data_n_1972 1
  static real_4 _data_l_1972[_data_n_1972] = {
    .0000000028670105e0
  };
#define _data_n_1973 1
  static real_4 _data_l_1973[_data_n_1973] = {
    -.00000000019013363e0
  };
#define _data_n_1974 1
  static real_4 _data_l_1974[_data_n_1974] = {
    -.00000000030977804e0
  };
#define _data_n_1975 1
  static real_4 _data_l_1975[_data_n_1975] = {
    -.00000000010294148e0
  };
#define _data_n_1976 1
  static real_4 _data_l_1976[_data_n_1976] = {
    -.00000000000626035e0
  };
#define _data_n_1977 1
  static real_4 _data_l_1977[_data_n_1977] = {
    .00000000000856313e0
  };
#define _data_n_1978 1
  static real_4 _data_l_1978[_data_n_1978] = {
    .00000000000303304e0
  };
#define _data_n_1979 1
  static real_4 _data_l_1979[_data_n_1979] = {
    -.00000000000025236e0
  };
#define _data_n_1980 1
  static real_4 _data_l_1980[_data_n_1980] = {
    -.00000000000042106e0
  };
#define _data_n_1981 1
  static real_4 _data_l_1981[_data_n_1981] = {
    -.00000000000004431e0
  };
#define _data_n_1982 1
  static real_4 _data_l_1982[_data_n_1982] = {
    .00000000000004911e0
  };
#define _data_n_1983 1
  static real_4 _data_l_1983[_data_n_1983] = {
    .00000000000001235e0
  };
#define _data_n_1984 1
  static real_4 _data_l_1984[_data_n_1984] = {
    -.00000000000000578e0
  };
#define _data_n_1985 1
  static real_4 _data_l_1985[_data_n_1985] = {
    -.00000000000000228e0
  };
#define _data_n_1986 1
  static real_4 _data_l_1986[_data_n_1986] = {
    .00000000000000076e0
  };
#define _data_n_1987 1
  static real_4 _data_l_1987[_data_n_1987] = {
    .00000000000000038e0
  };
#define _data_n_1988 1
  static real_4 _data_l_1988[_data_n_1988] = {
    -.00000000000000011e0
  };
#define _data_n_1989 1
  static real_4 _data_l_1989[_data_n_1989] = {
    -.00000000000000006e0
  };
#define _data_n_1990 1
  static real_4 _data_l_1990[_data_n_1990] = {
    .00000000000000002e0
  };
#define _data_n_1991 1
  static logical_4 _data_l_1991[_data_n_1991] = {
    TRUE
  };
  if (__calls[112].calls == 0) {
    _data_k_1923 = 0;
    if (_data_k_1923 >= _data_n_1923) {
      _data_k_1923 = 0;
    }
    dawcs_[0] = _data_l_1923[_data_k_1923++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1924 = 0;
    if (_data_k_1924 >= _data_n_1924) {
      _data_k_1924 = 0;
    }
    dawcs_[1] = _data_l_1924[_data_k_1924++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1925 = 0;
    if (_data_k_1925 >= _data_n_1925) {
      _data_k_1925 = 0;
    }
    dawcs_[2] = _data_l_1925[_data_k_1925++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1926 = 0;
    if (_data_k_1926 >= _data_n_1926) {
      _data_k_1926 = 0;
    }
    dawcs_[3] = _data_l_1926[_data_k_1926++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1927 = 0;
    if (_data_k_1927 >= _data_n_1927) {
      _data_k_1927 = 0;
    }
    dawcs_[4] = _data_l_1927[_data_k_1927++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1928 = 0;
    if (_data_k_1928 >= _data_n_1928) {
      _data_k_1928 = 0;
    }
    dawcs_[5] = _data_l_1928[_data_k_1928++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1929 = 0;
    if (_data_k_1929 >= _data_n_1929) {
      _data_k_1929 = 0;
    }
    dawcs_[6] = _data_l_1929[_data_k_1929++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1930 = 0;
    if (_data_k_1930 >= _data_n_1930) {
      _data_k_1930 = 0;
    }
    dawcs_[7] = _data_l_1930[_data_k_1930++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1931 = 0;
    if (_data_k_1931 >= _data_n_1931) {
      _data_k_1931 = 0;
    }
    dawcs_[8] = _data_l_1931[_data_k_1931++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1932 = 0;
    if (_data_k_1932 >= _data_n_1932) {
      _data_k_1932 = 0;
    }
    dawcs_[9] = _data_l_1932[_data_k_1932++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1933 = 0;
    if (_data_k_1933 >= _data_n_1933) {
      _data_k_1933 = 0;
    }
    dawcs_[10] = _data_l_1933[_data_k_1933++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1934 = 0;
    if (_data_k_1934 >= _data_n_1934) {
      _data_k_1934 = 0;
    }
    dawcs_[11] = _data_l_1934[_data_k_1934++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1935 = 0;
    if (_data_k_1935 >= _data_n_1935) {
      _data_k_1935 = 0;
    }
    dawcs_[12] = _data_l_1935[_data_k_1935++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1936 = 0;
    if (_data_k_1936 >= _data_n_1936) {
      _data_k_1936 = 0;
    }
    daw2cs_[0] = _data_l_1936[_data_k_1936++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1937 = 0;
    if (_data_k_1937 >= _data_n_1937) {
      _data_k_1937 = 0;
    }
    daw2cs_[1] = _data_l_1937[_data_k_1937++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1938 = 0;
    if (_data_k_1938 >= _data_n_1938) {
      _data_k_1938 = 0;
    }
    daw2cs_[2] = _data_l_1938[_data_k_1938++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1939 = 0;
    if (_data_k_1939 >= _data_n_1939) {
      _data_k_1939 = 0;
    }
    daw2cs_[3] = _data_l_1939[_data_k_1939++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1940 = 0;
    if (_data_k_1940 >= _data_n_1940) {
      _data_k_1940 = 0;
    }
    daw2cs_[4] = _data_l_1940[_data_k_1940++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1941 = 0;
    if (_data_k_1941 >= _data_n_1941) {
      _data_k_1941 = 0;
    }
    daw2cs_[5] = _data_l_1941[_data_k_1941++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1942 = 0;
    if (_data_k_1942 >= _data_n_1942) {
      _data_k_1942 = 0;
    }
    daw2cs_[6] = _data_l_1942[_data_k_1942++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1943 = 0;
    if (_data_k_1943 >= _data_n_1943) {
      _data_k_1943 = 0;
    }
    daw2cs_[7] = _data_l_1943[_data_k_1943++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1944 = 0;
    if (_data_k_1944 >= _data_n_1944) {
      _data_k_1944 = 0;
    }
    daw2cs_[8] = _data_l_1944[_data_k_1944++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1945 = 0;
    if (_data_k_1945 >= _data_n_1945) {
      _data_k_1945 = 0;
    }
    daw2cs_[9] = _data_l_1945[_data_k_1945++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1946 = 0;
    if (_data_k_1946 >= _data_n_1946) {
      _data_k_1946 = 0;
    }
    daw2cs_[10] = _data_l_1946[_data_k_1946++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1947 = 0;
    if (_data_k_1947 >= _data_n_1947) {
      _data_k_1947 = 0;
    }
    daw2cs_[11] = _data_l_1947[_data_k_1947++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1948 = 0;
    if (_data_k_1948 >= _data_n_1948) {
      _data_k_1948 = 0;
    }
    daw2cs_[12] = _data_l_1948[_data_k_1948++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1949 = 0;
    if (_data_k_1949 >= _data_n_1949) {
      _data_k_1949 = 0;
    }
    daw2cs_[13] = _data_l_1949[_data_k_1949++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1950 = 0;
    if (_data_k_1950 >= _data_n_1950) {
      _data_k_1950 = 0;
    }
    daw2cs_[14] = _data_l_1950[_data_k_1950++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1951 = 0;
    if (_data_k_1951 >= _data_n_1951) {
      _data_k_1951 = 0;
    }
    daw2cs_[15] = _data_l_1951[_data_k_1951++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1952 = 0;
    if (_data_k_1952 >= _data_n_1952) {
      _data_k_1952 = 0;
    }
    daw2cs_[16] = _data_l_1952[_data_k_1952++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1953 = 0;
    if (_data_k_1953 >= _data_n_1953) {
      _data_k_1953 = 0;
    }
    daw2cs_[17] = _data_l_1953[_data_k_1953++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1954 = 0;
    if (_data_k_1954 >= _data_n_1954) {
      _data_k_1954 = 0;
    }
    daw2cs_[18] = _data_l_1954[_data_k_1954++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1955 = 0;
    if (_data_k_1955 >= _data_n_1955) {
      _data_k_1955 = 0;
    }
    daw2cs_[19] = _data_l_1955[_data_k_1955++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1956 = 0;
    if (_data_k_1956 >= _data_n_1956) {
      _data_k_1956 = 0;
    }
    daw2cs_[20] = _data_l_1956[_data_k_1956++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1957 = 0;
    if (_data_k_1957 >= _data_n_1957) {
      _data_k_1957 = 0;
    }
    daw2cs_[21] = _data_l_1957[_data_k_1957++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1958 = 0;
    if (_data_k_1958 >= _data_n_1958) {
      _data_k_1958 = 0;
    }
    daw2cs_[22] = _data_l_1958[_data_k_1958++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1959 = 0;
    if (_data_k_1959 >= _data_n_1959) {
      _data_k_1959 = 0;
    }
    daw2cs_[23] = _data_l_1959[_data_k_1959++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1960 = 0;
    if (_data_k_1960 >= _data_n_1960) {
      _data_k_1960 = 0;
    }
    daw2cs_[24] = _data_l_1960[_data_k_1960++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1961 = 0;
    if (_data_k_1961 >= _data_n_1961) {
      _data_k_1961 = 0;
    }
    daw2cs_[25] = _data_l_1961[_data_k_1961++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1962 = 0;
    if (_data_k_1962 >= _data_n_1962) {
      _data_k_1962 = 0;
    }
    daw2cs_[26] = _data_l_1962[_data_k_1962++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1963 = 0;
    if (_data_k_1963 >= _data_n_1963) {
      _data_k_1963 = 0;
    }
    daw2cs_[27] = _data_l_1963[_data_k_1963++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1964 = 0;
    if (_data_k_1964 >= _data_n_1964) {
      _data_k_1964 = 0;
    }
    daw2cs_[28] = _data_l_1964[_data_k_1964++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1965 = 0;
    if (_data_k_1965 >= _data_n_1965) {
      _data_k_1965 = 0;
    }
    dawacs_[0] = _data_l_1965[_data_k_1965++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1966 = 0;
    if (_data_k_1966 >= _data_n_1966) {
      _data_k_1966 = 0;
    }
    dawacs_[1] = _data_l_1966[_data_k_1966++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1967 = 0;
    if (_data_k_1967 >= _data_n_1967) {
      _data_k_1967 = 0;
    }
    dawacs_[2] = _data_l_1967[_data_k_1967++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1968 = 0;
    if (_data_k_1968 >= _data_n_1968) {
      _data_k_1968 = 0;
    }
    dawacs_[3] = _data_l_1968[_data_k_1968++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1969 = 0;
    if (_data_k_1969 >= _data_n_1969) {
      _data_k_1969 = 0;
    }
    dawacs_[4] = _data_l_1969[_data_k_1969++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1970 = 0;
    if (_data_k_1970 >= _data_n_1970) {
      _data_k_1970 = 0;
    }
    dawacs_[5] = _data_l_1970[_data_k_1970++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1971 = 0;
    if (_data_k_1971 >= _data_n_1971) {
      _data_k_1971 = 0;
    }
    dawacs_[6] = _data_l_1971[_data_k_1971++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1972 = 0;
    if (_data_k_1972 >= _data_n_1972) {
      _data_k_1972 = 0;
    }
    dawacs_[7] = _data_l_1972[_data_k_1972++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1973 = 0;
    if (_data_k_1973 >= _data_n_1973) {
      _data_k_1973 = 0;
    }
    dawacs_[8] = _data_l_1973[_data_k_1973++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1974 = 0;
    if (_data_k_1974 >= _data_n_1974) {
      _data_k_1974 = 0;
    }
    dawacs_[9] = _data_l_1974[_data_k_1974++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1975 = 0;
    if (_data_k_1975 >= _data_n_1975) {
      _data_k_1975 = 0;
    }
    dawacs_[10] = _data_l_1975[_data_k_1975++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1976 = 0;
    if (_data_k_1976 >= _data_n_1976) {
      _data_k_1976 = 0;
    }
    dawacs_[11] = _data_l_1976[_data_k_1976++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1977 = 0;
    if (_data_k_1977 >= _data_n_1977) {
      _data_k_1977 = 0;
    }
    dawacs_[12] = _data_l_1977[_data_k_1977++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1978 = 0;
    if (_data_k_1978 >= _data_n_1978) {
      _data_k_1978 = 0;
    }
    dawacs_[13] = _data_l_1978[_data_k_1978++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1979 = 0;
    if (_data_k_1979 >= _data_n_1979) {
      _data_k_1979 = 0;
    }
    dawacs_[14] = _data_l_1979[_data_k_1979++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1980 = 0;
    if (_data_k_1980 >= _data_n_1980) {
      _data_k_1980 = 0;
    }
    dawacs_[15] = _data_l_1980[_data_k_1980++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1981 = 0;
    if (_data_k_1981 >= _data_n_1981) {
      _data_k_1981 = 0;
    }
    dawacs_[16] = _data_l_1981[_data_k_1981++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1982 = 0;
    if (_data_k_1982 >= _data_n_1982) {
      _data_k_1982 = 0;
    }
    dawacs_[17] = _data_l_1982[_data_k_1982++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1983 = 0;
    if (_data_k_1983 >= _data_n_1983) {
      _data_k_1983 = 0;
    }
    dawacs_[18] = _data_l_1983[_data_k_1983++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1984 = 0;
    if (_data_k_1984 >= _data_n_1984) {
      _data_k_1984 = 0;
    }
    dawacs_[19] = _data_l_1984[_data_k_1984++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1985 = 0;
    if (_data_k_1985 >= _data_n_1985) {
      _data_k_1985 = 0;
    }
    dawacs_[20] = _data_l_1985[_data_k_1985++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1986 = 0;
    if (_data_k_1986 >= _data_n_1986) {
      _data_k_1986 = 0;
    }
    dawacs_[21] = _data_l_1986[_data_k_1986++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1987 = 0;
    if (_data_k_1987 >= _data_n_1987) {
      _data_k_1987 = 0;
    }
    dawacs_[22] = _data_l_1987[_data_k_1987++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1988 = 0;
    if (_data_k_1988 >= _data_n_1988) {
      _data_k_1988 = 0;
    }
    dawacs_[23] = _data_l_1988[_data_k_1988++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1989 = 0;
    if (_data_k_1989 >= _data_n_1989) {
      _data_k_1989 = 0;
    }
    dawacs_[24] = _data_l_1989[_data_k_1989++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1990 = 0;
    if (_data_k_1990 >= _data_n_1990) {
      _data_k_1990 = 0;
    }
    dawacs_[25] = _data_l_1990[_data_k_1990++];
  }
  if (__calls[112].calls == 0) {
    _data_k_1991 = 0;
    if (_data_k_1991 >= _data_n_1991) {
      _data_k_1991 = 0;
    }
    first_ = _data_l_1991[_data_k_1991++];
  }
  if (first_) {
    eps_ = _r1mach (($0_ = 3, &$0_));
    ntdaw_ = _inits (dawcs_, ($1_ = 13, &$1_), ($2_ = 0.1 * eps_, &$2_));
    ntdaw2_ = _inits (daw2cs_, ($3_ = 29, &$3_), ($4_ = 0.1 * eps_, &$4_));
    ntdawa_ = _inits (dawacs_, ($5_ = 26, &$5_), ($6_ = 0.1 * eps_, &$6_));
    xsml_ = sqrtf (1.5 * eps_);
    xbig_ = sqrtf (0.5 / eps_);
    xmax_ = expf (_min (-logf (2.0 * _r1mach (&_k1)), logf (_r1mach (($7_ = 2, &$7_)))) - 1.0);
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 1.0) {
    goto _l20;
  }
  daws_ = (*x_);
  if (y_ <= xsml_) {
    goto _l0;
  }
  daws_ = (*x_) * (0.75 + _csevl (($8_ = 2.0 * y_ * y_ - 1.0, &$8_), dawcs_, &ntdaw_));
  goto _l0;
  _l20:;
  if (y_ > 4.0) {
    goto _l30;
  }
  daws_ = (*x_) * (0.25 + _csevl (($9_ = 0.125 * y_ * y_ - 1.0, &$9_), daw2cs_, &ntdaw2_));
  goto _l0;
  _l30:;
  if (y_ > xmax_) {
    goto _l40;
  }
  daws_ = 0.5 / (*x_);
  if (y_ > xbig_) {
    goto _l0;
  }
  daws_ = (0.5 + _csevl (($10_ = 32.0 / (y_ * y_) - 1.0, &$10_), dawacs_, &ntdawa_)) / (*x_);
  goto _l0;
  _l40:;
  (void) _xermsg (_dc_0, _dc_187, _dc_188, &_k1, &_k1);
  daws_ = 0.0;
  _l0:;
  __calls[112].calls++;
  return daws_;
}

real_8 _dbesi0 (real_8 _p_ x_)
{
  static int_4 nti0_;
  static logical_4 first_;
  static real_8 bi0cs_[18], xmax_, xsml_, y_;
  int_4 _data_k_1992, _data_k_1993, _data_k_1994, _data_k_1995, _data_k_1996, _data_k_1997, _data_k_1998, _data_k_1999, 
  _data_k_2000, _data_k_2001, _data_k_2002, _data_k_2003, _data_k_2004, _data_k_2005, _data_k_2006, _data_k_2007, 
  _data_k_2008, _data_k_2009, _data_k_2010, $0_, $1_, $3_, $4_, $6_, $7_;
  real_4 $2_;
  real_8 $5_;
  real_8 dbesi0_;
  extern real_8 _d1mach ();
#define _data_n_1992 1
  static real_8 _data_l_1992[_data_n_1992] = {
    -.7660547252839144951081894976243285e-1
  };
#define _data_n_1993 1
  static real_8 _data_l_1993[_data_n_1993] = {
    .1927337953993808269952408750881196e1
  };
#define _data_n_1994 1
  static real_8 _data_l_1994[_data_n_1994] = {
    .2282644586920301338937029292330415e+0
  };
#define _data_n_1995 1
  static real_8 _data_l_1995[_data_n_1995] = {
    .1304891466707290428079334210691888e-1
  };
#define _data_n_1996 1
  static real_8 _data_l_1996[_data_n_1996] = {
    .4344270900816487451378682681026107e-3
  };
#define _data_n_1997 1
  static real_8 _data_l_1997[_data_n_1997] = {
    .9422657686001934663923171744118766e-5
  };
#define _data_n_1998 1
  static real_8 _data_l_1998[_data_n_1998] = {
    .1434006289510691079962091878179957e-6
  };
#define _data_n_1999 1
  static real_8 _data_l_1999[_data_n_1999] = {
    .1613849069661749069915419719994611e-8
  };
#define _data_n_2000 1
  static real_8 _data_l_2000[_data_n_2000] = {
    .1396650044535669699495092708142522e-10
  };
#define _data_n_2001 1
  static real_8 _data_l_2001[_data_n_2001] = {
    .9579451725505445344627523171893333e-13
  };
#define _data_n_2002 1
  static real_8 _data_l_2002[_data_n_2002] = {
    .5333981859862502131015107744e-15
  };
#define _data_n_2003 1
  static real_8 _data_l_2003[_data_n_2003] = {
    .2458716088437470774696785919999999e-17
  };
#define _data_n_2004 1
  static real_8 _data_l_2004[_data_n_2004] = {
    .9535680890248770026944341333333333e-20
  };
#define _data_n_2005 1
  static real_8 _data_l_2005[_data_n_2005] = {
    .3154382039721427336789333333333333e-22
  };
#define _data_n_2006 1
  static real_8 _data_l_2006[_data_n_2006] = {
    .9004564101094637431466666666666666e-25
  };
#define _data_n_2007 1
  static real_8 _data_l_2007[_data_n_2007] = {
    .2240647369123670016e-27
  };
#define _data_n_2008 1
  static real_8 _data_l_2008[_data_n_2008] = {
    .4903034603242837333333333333333333e-30
  };
#define _data_n_2009 1
  static real_8 _data_l_2009[_data_n_2009] = {
    .9508172606122666666666666666666666e-33
  };
#define _data_n_2010 1
  static logical_4 _data_l_2010[_data_n_2010] = {
    TRUE
  };
  if (__calls[113].calls == 0) {
    _data_k_1992 = 0;
    if (_data_k_1992 >= _data_n_1992) {
      _data_k_1992 = 0;
    }
    bi0cs_[0] = _data_l_1992[_data_k_1992++];
  }
  if (__calls[113].calls == 0) {
    _data_k_1993 = 0;
    if (_data_k_1993 >= _data_n_1993) {
      _data_k_1993 = 0;
    }
    bi0cs_[1] = _data_l_1993[_data_k_1993++];
  }
  if (__calls[113].calls == 0) {
    _data_k_1994 = 0;
    if (_data_k_1994 >= _data_n_1994) {
      _data_k_1994 = 0;
    }
    bi0cs_[2] = _data_l_1994[_data_k_1994++];
  }
  if (__calls[113].calls == 0) {
    _data_k_1995 = 0;
    if (_data_k_1995 >= _data_n_1995) {
      _data_k_1995 = 0;
    }
    bi0cs_[3] = _data_l_1995[_data_k_1995++];
  }
  if (__calls[113].calls == 0) {
    _data_k_1996 = 0;
    if (_data_k_1996 >= _data_n_1996) {
      _data_k_1996 = 0;
    }
    bi0cs_[4] = _data_l_1996[_data_k_1996++];
  }
  if (__calls[113].calls == 0) {
    _data_k_1997 = 0;
    if (_data_k_1997 >= _data_n_1997) {
      _data_k_1997 = 0;
    }
    bi0cs_[5] = _data_l_1997[_data_k_1997++];
  }
  if (__calls[113].calls == 0) {
    _data_k_1998 = 0;
    if (_data_k_1998 >= _data_n_1998) {
      _data_k_1998 = 0;
    }
    bi0cs_[6] = _data_l_1998[_data_k_1998++];
  }
  if (__calls[113].calls == 0) {
    _data_k_1999 = 0;
    if (_data_k_1999 >= _data_n_1999) {
      _data_k_1999 = 0;
    }
    bi0cs_[7] = _data_l_1999[_data_k_1999++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2000 = 0;
    if (_data_k_2000 >= _data_n_2000) {
      _data_k_2000 = 0;
    }
    bi0cs_[8] = _data_l_2000[_data_k_2000++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2001 = 0;
    if (_data_k_2001 >= _data_n_2001) {
      _data_k_2001 = 0;
    }
    bi0cs_[9] = _data_l_2001[_data_k_2001++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2002 = 0;
    if (_data_k_2002 >= _data_n_2002) {
      _data_k_2002 = 0;
    }
    bi0cs_[10] = _data_l_2002[_data_k_2002++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2003 = 0;
    if (_data_k_2003 >= _data_n_2003) {
      _data_k_2003 = 0;
    }
    bi0cs_[11] = _data_l_2003[_data_k_2003++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2004 = 0;
    if (_data_k_2004 >= _data_n_2004) {
      _data_k_2004 = 0;
    }
    bi0cs_[12] = _data_l_2004[_data_k_2004++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2005 = 0;
    if (_data_k_2005 >= _data_n_2005) {
      _data_k_2005 = 0;
    }
    bi0cs_[13] = _data_l_2005[_data_k_2005++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2006 = 0;
    if (_data_k_2006 >= _data_n_2006) {
      _data_k_2006 = 0;
    }
    bi0cs_[14] = _data_l_2006[_data_k_2006++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2007 = 0;
    if (_data_k_2007 >= _data_n_2007) {
      _data_k_2007 = 0;
    }
    bi0cs_[15] = _data_l_2007[_data_k_2007++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2008 = 0;
    if (_data_k_2008 >= _data_n_2008) {
      _data_k_2008 = 0;
    }
    bi0cs_[16] = _data_l_2008[_data_k_2008++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2009 = 0;
    if (_data_k_2009 >= _data_n_2009) {
      _data_k_2009 = 0;
    }
    bi0cs_[17] = _data_l_2009[_data_k_2009++];
  }
  if (__calls[113].calls == 0) {
    _data_k_2010 = 0;
    if (_data_k_2010 >= _data_n_2010) {
      _data_k_2010 = 0;
    }
    first_ = _data_l_2010[_data_k_2010++];
  }
  if (first_) {
    nti0_ = _initds (bi0cs_, ($0_ = 18, &$0_), ($2_ = 0.1 * (real_4) (_d1mach (($1_ = 3, &$1_))), &$2_));
    xsml_ = sqrt (4.5e0 * _d1mach (($3_ = 3, &$3_)));
    xmax_ = log (_d1mach (($4_ = 2, &$4_)));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 3.0e0) {
    goto _l20;
  }
  dbesi0_ = 1.0;
  if (y_ > xsml_) {
    dbesi0_ = 2.75e0 + _dcsevl (($5_ = y_ * y_ / 4.5e0 - 1.0e0, &$5_), bi0cs_, &nti0_);
  }
  goto _l0;
  _l20:;
  if (y_ > xmax_) {
    (void) _xermsg (_dc_0, _dc_189, _dc_12, ($6_ = 2, &$6_), ($7_ = 2, &$7_));
  }
  dbesi0_ = exp (y_) * _dbsi0e (x_);
  _l0:;
  __calls[113].calls++;
  return dbesi0_;
}

real_8 _dbesi1 (real_8 _p_ x_)
{
  static int_4 nti1_;
  static logical_4 first_;
  static real_8 bi1cs_[17], xmax_, xmin_, xsml_, y_;
  int_4 _data_k_2011, _data_k_2012, _data_k_2013, _data_k_2014, _data_k_2015, _data_k_2016, _data_k_2017, _data_k_2018, 
  _data_k_2019, _data_k_2020, _data_k_2021, _data_k_2022, _data_k_2023, _data_k_2024, _data_k_2025, _data_k_2026, 
  _data_k_2027, _data_k_2028, $0_, $1_, $3_, $4_, $6_, $7_;
  real_4 $2_;
  real_8 $5_;
  real_8 dbesi1_;
  extern real_8 _d1mach ();
#define _data_n_2011 1
  static real_8 _data_l_2011[_data_n_2011] = {
    -.19717132610998597316138503218149e-2
  };
#define _data_n_2012 1
  static real_8 _data_l_2012[_data_n_2012] = {
    .40734887667546480608155393652014e+0
  };
#define _data_n_2013 1
  static real_8 _data_l_2013[_data_n_2013] = {
    .34838994299959455866245037783787e-1
  };
#define _data_n_2014 1
  static real_8 _data_l_2014[_data_n_2014] = {
    .15453945563001236038598401058489e-2
  };
#define _data_n_2015 1
  static real_8 _data_l_2015[_data_n_2015] = {
    .4188852109837778412945883200412e-4
  };
#define _data_n_2016 1
  static real_8 _data_l_2016[_data_n_2016] = {
    .76490267648362114741959703966069e-6
  };
#define _data_n_2017 1
  static real_8 _data_l_2017[_data_n_2017] = {
    .10042493924741178689179808037238e-7
  };
#define _data_n_2018 1
  static real_8 _data_l_2018[_data_n_2018] = {
    .99322077919238106481371298054863e-10
  };
#define _data_n_2019 1
  static real_8 _data_l_2019[_data_n_2019] = {
    .76638017918447637275200171681349e-12
  };
#define _data_n_2020 1
  static real_8 _data_l_2020[_data_n_2020] = {
    .4741418923816739498038809194816e-14
  };
#define _data_n_2021 1
  static real_8 _data_l_2021[_data_n_2021] = {
    .24041144040745181799863172032e-16
  };
#define _data_n_2022 1
  static real_8 _data_l_2022[_data_n_2022] = {
    .10171505007093713649121100799999e-18
  };
#define _data_n_2023 1
  static real_8 _data_l_2023[_data_n_2023] = {
    .36450935657866949458491733333333e-21
  };
#define _data_n_2024 1
  static real_8 _data_l_2024[_data_n_2024] = {
    .11205749502562039344810666666666e-23
  };
#define _data_n_2025 1
  static real_8 _data_l_2025[_data_n_2025] = {
    .29875441934468088832e-26
  };
#define _data_n_2026 1
  static real_8 _data_l_2026[_data_n_2026] = {
    .69732310939194709333333333333333e-29
  };
#define _data_n_2027 1
  static real_8 _data_l_2027[_data_n_2027] = {
    .143679482206208e-31
  };
#define _data_n_2028 1
  static logical_4 _data_l_2028[_data_n_2028] = {
    TRUE
  };
  if (__calls[114].calls == 0) {
    _data_k_2011 = 0;
    if (_data_k_2011 >= _data_n_2011) {
      _data_k_2011 = 0;
    }
    bi1cs_[0] = _data_l_2011[_data_k_2011++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2012 = 0;
    if (_data_k_2012 >= _data_n_2012) {
      _data_k_2012 = 0;
    }
    bi1cs_[1] = _data_l_2012[_data_k_2012++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2013 = 0;
    if (_data_k_2013 >= _data_n_2013) {
      _data_k_2013 = 0;
    }
    bi1cs_[2] = _data_l_2013[_data_k_2013++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2014 = 0;
    if (_data_k_2014 >= _data_n_2014) {
      _data_k_2014 = 0;
    }
    bi1cs_[3] = _data_l_2014[_data_k_2014++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2015 = 0;
    if (_data_k_2015 >= _data_n_2015) {
      _data_k_2015 = 0;
    }
    bi1cs_[4] = _data_l_2015[_data_k_2015++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2016 = 0;
    if (_data_k_2016 >= _data_n_2016) {
      _data_k_2016 = 0;
    }
    bi1cs_[5] = _data_l_2016[_data_k_2016++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2017 = 0;
    if (_data_k_2017 >= _data_n_2017) {
      _data_k_2017 = 0;
    }
    bi1cs_[6] = _data_l_2017[_data_k_2017++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2018 = 0;
    if (_data_k_2018 >= _data_n_2018) {
      _data_k_2018 = 0;
    }
    bi1cs_[7] = _data_l_2018[_data_k_2018++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2019 = 0;
    if (_data_k_2019 >= _data_n_2019) {
      _data_k_2019 = 0;
    }
    bi1cs_[8] = _data_l_2019[_data_k_2019++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2020 = 0;
    if (_data_k_2020 >= _data_n_2020) {
      _data_k_2020 = 0;
    }
    bi1cs_[9] = _data_l_2020[_data_k_2020++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2021 = 0;
    if (_data_k_2021 >= _data_n_2021) {
      _data_k_2021 = 0;
    }
    bi1cs_[10] = _data_l_2021[_data_k_2021++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2022 = 0;
    if (_data_k_2022 >= _data_n_2022) {
      _data_k_2022 = 0;
    }
    bi1cs_[11] = _data_l_2022[_data_k_2022++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2023 = 0;
    if (_data_k_2023 >= _data_n_2023) {
      _data_k_2023 = 0;
    }
    bi1cs_[12] = _data_l_2023[_data_k_2023++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2024 = 0;
    if (_data_k_2024 >= _data_n_2024) {
      _data_k_2024 = 0;
    }
    bi1cs_[13] = _data_l_2024[_data_k_2024++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2025 = 0;
    if (_data_k_2025 >= _data_n_2025) {
      _data_k_2025 = 0;
    }
    bi1cs_[14] = _data_l_2025[_data_k_2025++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2026 = 0;
    if (_data_k_2026 >= _data_n_2026) {
      _data_k_2026 = 0;
    }
    bi1cs_[15] = _data_l_2026[_data_k_2026++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2027 = 0;
    if (_data_k_2027 >= _data_n_2027) {
      _data_k_2027 = 0;
    }
    bi1cs_[16] = _data_l_2027[_data_k_2027++];
  }
  if (__calls[114].calls == 0) {
    _data_k_2028 = 0;
    if (_data_k_2028 >= _data_n_2028) {
      _data_k_2028 = 0;
    }
    first_ = _data_l_2028[_data_k_2028++];
  }
  if (first_) {
    nti1_ = _initds (bi1cs_, ($0_ = 17, &$0_), ($2_ = 0.1 * (real_4) (_d1mach (($1_ = 3, &$1_))), &$2_));
    xmin_ = 2.0e0 * _d1mach (&_k1);
    xsml_ = sqrt (4.5e0 * _d1mach (($3_ = 3, &$3_)));
    xmax_ = log (_d1mach (($4_ = 2, &$4_)));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 3.0e0) {
    goto _l20;
  }
  dbesi1_ = 0.0;
  if (y_ == 0.0e0) {
    goto _l0;
  }
  if (y_ <= xmin_) {
    (void) _xermsg (_dc_0, _dc_190, _dc_14, &_k1, &_k1);
  }
  if (y_ > xmin_) {
    dbesi1_ = 0.5e0 * (*x_);
  }
  if (y_ > xsml_) {
    dbesi1_ = (*x_) * (0.875e0 + _dcsevl (($5_ = y_ * y_ / 4.5e0 - 1.0e0, &$5_), bi1cs_, &nti1_));
  }
  goto _l0;
  _l20:;
  if (y_ > xmax_) {
    (void) _xermsg (_dc_0, _dc_190, _dc_16, ($6_ = 2, &$6_), ($7_ = 2, &$7_));
  }
  dbesi1_ = exp (y_) * _dbsi1e (x_);
  _l0:;
  __calls[114].calls++;
  return dbesi1_;
}

int_4 _dbesi (real_8 _p_ x_, real_8 _p_ alpha_, int_4 _p_ kode_, int_4 _p_ n_, real_8 _p_ y_, int_4 _p_ nz_)
{
  static int_4 i_, ialp_, in_, inlim_, is_, i1_, k_, kk_, km_, kt_, nn_, ns_;
  static real_8 ain_, ak_, akm_, ans_, ap_, arg_, atol_, tolln_, dfn_, dtm_, dx_, earg_, elim_, etx_, flgik_, fn_, fnf_, 
  fni_, fnp1_, fnu_, gln_, ra_, rttpi_, s_, sx_, sxo2_, s1_, s2_, t_, ta_, tb_, temp_[3], tfn_, tm_, tol_, trx_, t2_, 
  xo2_, xo2l_, z_, dlngam_;
  int_4 _data_k_2029, _data_k_2030, $0_, $1_, $2_, $3_, $4_, $7_, $8_, $9_, $10_, $11_, $12_, $13_;
  real_8 $5_, $6_;
  extern int_4 _i1mach ();
  extern real_8 _d1mach ();
#define _data_n_2029 1
  static real_8 _data_l_2029[_data_n_2029] = {
    3.98942280401433e-1
  };
#define _data_n_2030 1
  static int_4 _data_l_2030[_data_n_2030] = {
    80
  };
  if (__calls[115].calls == 0) {
    _data_k_2029 = 0;
    if (_data_k_2029 >= _data_n_2029) {
      _data_k_2029 = 0;
    }
    rttpi_ = _data_l_2029[_data_k_2029++];
  }
  if (__calls[115].calls == 0) {
    _data_k_2030 = 0;
    if (_data_k_2030 >= _data_n_2030) {
      _data_k_2030 = 0;
    }
    inlim_ = _data_l_2030[_data_k_2030++];
  }
  (*nz_) = 0;
  kt_ = 1;
  ra_ = _d1mach (($0_ = 3, &$0_));
  tol_ = _max (ra_, 1.0e-15);
  i1_ = -_i1mach (($1_ = 15, &$1_));
  gln_ = _d1mach (($2_ = 5, &$2_));
  elim_ = 2.303e0 * (i1_ * gln_ - 3.0e0);
  i1_ = _i1mach (($3_ = 14, &$3_)) + 1;
  tolln_ = 2.303e0 * gln_ * i1_;
  tolln_ = _min (tolln_, 34.5388);
  $4_ = (*n_) - 1;
  if ($4_ < 0) {
    goto _l590;
  } else if ($4_ == 0) {
    goto _l10;
  } else {
    goto _l20;
  }
  _l10:;
  kt_ = 2;
  _l20:;
  nn_ = (*n_);
  if ((*kode_) < 1 || (*kode_) > 2) {
    goto _l570;
  }
  $5_ = (*x_);
  if ($5_ < 0) {
    goto _l600;
  } else if ($5_ == 0) {
    goto _l30;
  } else {
    goto _l80;
  }
  _l30:;
  $6_ = (*alpha_);
  if ($6_ < 0) {
    goto _l580;
  } else if ($6_ == 0) {
    goto _l40;
  } else {
    goto _l50;
  }
  _l40:;
  y_[0] = 1.0;
  if ((*n_) == 1) {
    goto _l0;
  }
  i1_ = 2;
  goto _l60;
  _l50:;
  i1_ = 1;
  _l60:;
  for (i_ = i1_; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = 0.0;
  }
  goto _l0;
  _l80:;
  if ((*alpha_) < 0.0e0) {
    goto _l580;
  }
  ialp_ = (int_4) (_aintd ((*alpha_)));
  fni_ = ialp_ + (*n_) - 1;
  fnf_ = (*alpha_) - ialp_;
  dfn_ = fni_ + fnf_;
  fnu_ = dfn_;
  in_ = 0;
  xo2_ = (*x_) * 0.5e0;
  sxo2_ = xo2_ * xo2_;
  etx_ = (*kode_) - 1;
  sx_ = etx_ * (*x_);
  if (sxo2_ <= (fnu_ + 1.0e0)) {
    goto _l90;
  }
  if ((*x_) <= 12.0e0) {
    goto _l110;
  }
  fn_ = 0.55e0 * fnu_ * fnu_;
  fn_ = _max (17.0, fn_);
  if ((*x_) >= fn_) {
    goto _l430;
  }
  ans_ = _max (36.0e0 - fnu_, 0.0);
  ns_ = (int_4) (_aintd (ans_));
  fni_ = fni_ + ns_;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  is_ = kt_;
  km_ = (*n_) - 1 + ns_;
  if (km_ > 0) {
    is_ = 3;
  }
  goto _l120;
  _l90:;
  fn_ = fnu_;
  fnp1_ = fn_ + 1.0e0;
  xo2l_ = log (xo2_);
  is_ = kt_;
  if ((*x_) <= 0.5e0) {
    goto _l230;
  }
  ns_ = 0;
  _l100:;
  fni_ = fni_ + ns_;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  fnp1_ = fn_ + 1.0e0;
  is_ = kt_;
  if ((*n_) - 1 + ns_ > 0) {
    is_ = 3;
  }
  goto _l230;
  _l110:;
  xo2l_ = log (xo2_);
  ns_ = (int_4) (_aintd (sxo2_ - fnu_));
  goto _l100;
  _l120:;
  if ((*kode_) == 2) {
    goto _l130;
  }
  if ((*alpha_) < 1.0e0) {
    goto _l150;
  }
  z_ = (*x_) / (*alpha_);
  ra_ = sqrt (1.0e0 + z_ * z_);
  gln_ = log ((1.0e0 + ra_) / z_);
  t_ = ra_ * (1.0e0 - etx_) + etx_ / (z_ + ra_);
  arg_ = (*alpha_) * (t_ - gln_);
  if (arg_ > elim_) {
    goto _l610;
  }
  if (km_ == 0) {
    goto _l140;
  }
  _l130:;
  z_ = (*x_) / fn_;
  ra_ = sqrt (1.0e0 + z_ * z_);
  gln_ = log ((1.0e0 + ra_) / z_);
  t_ = ra_ * (1.0e0 - etx_) + etx_ / (z_ + ra_);
  arg_ = fn_ * (t_ - gln_);
  _l140:;
  if (arg_ < (-elim_)) {
    goto _l280;
  }
  goto _l190;
  _l150:;
  if ((*x_) > elim_) {
    goto _l610;
  }
  goto _l130;
  _l160:;
  if (km_ != 0) {
    goto _l170;
  }
  y_[0] = temp_[2];
  goto _l0;
  _l170:;
  temp_[0] = temp_[2];
  in_ = ns_;
  kt_ = 1;
  i1_ = 0;
  _l180:;
  is_ = 2;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  if (i1_ == 2) {
    goto _l350;
  }
  z_ = (*x_) / fn_;
  ra_ = sqrt (1.0e0 + z_ * z_);
  gln_ = log ((1.0e0 + ra_) / z_);
  t_ = ra_ * (1.0e0 - etx_) + etx_ / (z_ + ra_);
  arg_ = fn_ * (t_ - gln_);
  _l190:;
  i1_ = _abs (3 - is_);
  i1_ = _max (i1_, 1);
  flgik_ = 1.0;
  (void) _dasyik (x_, &fn_, kode_, &flgik_, &ra_, &arg_, &i1_, &temp_[is_ - 1]);
  switch (is_) {
    default:
    case 1: goto _l180;
    case 2: goto _l350;
    case 3: goto _l510;
  }
  _l230:;
  gln_ = lgamma (fnp1_);
  arg_ = fn_ * xo2l_ - gln_ - sx_;
  if (arg_ < (-elim_)) {
    goto _l300;
  }
  earg_ = exp (arg_);
  _l240:;
  s_ = 1.0;
  if ((*x_) < tol_) {
    goto _l260;
  }
  ak_ = 3.0;
  t2_ = 1.0;
  t_ = 1.0;
  s1_ = fn_;
  for (k_ = 1; k_ <= 17; (k_)++) {
    s2_ = t2_ + s1_;
    t_ = t_ * sxo2_ / s2_;
    s_ = s_ + t_;
    if (_abs (t_) < tol_) {
      goto _l260;
    }
    t2_ = t2_ + ak_;
    ak_ = ak_ + 2.0e0;
    s1_ = s1_ + fn_;
  }
  _l260:;
  temp_[is_ - 1] = s_ * earg_;
  switch (is_) {
    default:
    case 1: goto _l270;
    case 2: goto _l350;
    case 3: goto _l500;
  }
  _l270:;
  earg_ = earg_ * fn_ / xo2_;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  is_ = 2;
  goto _l240;
  _l280:;
  y_[nn_ - 1] = 0.0;
  nn_ = nn_ - 1;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  $7_ = nn_ - 1;
  if ($7_ < 0) {
    goto _l340;
  } else if ($7_ == 0) {
    goto _l290;
  } else {
    goto _l130;
  }
  _l290:;
  kt_ = 2;
  is_ = 2;
  goto _l130;
  _l300:;
  y_[nn_ - 1] = 0.0;
  nn_ = nn_ - 1;
  fnp1_ = fn_;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  $8_ = nn_ - 1;
  if ($8_ < 0) {
    goto _l340;
  } else if ($8_ == 0) {
    goto _l310;
  } else {
    goto _l320;
  }
  _l310:;
  kt_ = 2;
  is_ = 2;
  _l320:;
  if (sxo2_ <= fnp1_) {
    goto _l330;
  }
  goto _l130;
  _l330:;
  arg_ = arg_ - xo2l_ + log (fnp1_);
  if (arg_ < (-elim_)) {
    goto _l300;
  }
  goto _l230;
  _l340:;
  (*nz_) = (*n_) - nn_;
  goto _l0;
  _l350:;
  (*nz_) = (*n_) - nn_;
  _l360:;
  if (kt_ == 2) {
    goto _l420;
  }
  s1_ = temp_[0];
  s2_ = temp_[1];
  trx_ = 2.0e0 / (*x_);
  dtm_ = fni_;
  tm_ = (dtm_ + fnf_) * trx_;
  if (in_ == 0) {
    goto _l390;
  }
  for (i_ = 1; i_ <= in_; (i_)++) {
    s_ = s2_;
    s2_ = tm_ * s2_ + s1_;
    s1_ = s_;
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
  }
  y_[nn_ - 1] = s1_;
  if (nn_ == 1) {
    goto _l0;
  }
  y_[nn_ - 1 - 1] = s2_;
  if (nn_ == 2) {
    goto _l0;
  }
  goto _l400;
  _l390:;
  y_[nn_ - 1] = s1_;
  y_[nn_ - 1 - 1] = s2_;
  if (nn_ == 2) {
    goto _l0;
  }
  _l400:;
  k_ = nn_ + 1;
  for (i_ = 3; i_ <= nn_; (i_)++) {
    k_ = k_ - 1;
    y_[k_ - 2 - 1] = tm_ * y_[k_ - 1 - 1] + y_[k_ - 1];
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
  }
  goto _l0;
  _l420:;
  y_[0] = temp_[1];
  goto _l0;
  _l430:;
  earg_ = rttpi_ / sqrt ((*x_));
  if ((*kode_) == 2) {
    goto _l440;
  }
  if ((*x_) > elim_) {
    goto _l610;
  }
  earg_ = earg_ * exp ((*x_));
  _l440:;
  etx_ = 8.0e0 * (*x_);
  is_ = kt_;
  in_ = 0;
  fn_ = fnu_;
  _l450:;
  dx_ = fni_ + fni_;
  tm_ = 0.0;
  if (fni_ == 0.0e0 && _abs (fnf_) < tol_) {
    goto _l460;
  }
  tm_ = 4.0e0 * fnf_ * (fni_ + fni_ + fnf_);
  _l460:;
  dtm_ = dx_ * dx_;
  s1_ = etx_;
  trx_ = dtm_ - 1.0e0;
  dx_ = -(trx_ + tm_) / etx_;
  t_ = dx_;
  s_ = 1.0e0 + dx_;
  atol_ = tol_ * _abs (s_);
  s2_ = 1.0;
  ak_ = 8.0;
  for (k_ = 1; k_ <= 25; (k_)++) {
    s1_ = s1_ + etx_;
    s2_ = s2_ + ak_;
    dx_ = dtm_ - s2_;
    ap_ = dx_ + tm_;
    t_ = -t_ * ap_ / s1_;
    s_ = s_ + t_;
    if (_abs (t_) <= atol_) {
      goto _l480;
    }
    ak_ = ak_ + 8.0e0;
  }
  _l480:;
  temp_[is_ - 1] = s_ * earg_;
  if (is_ == 2) {
    goto _l360;
  }
  is_ = 2;
  fni_ = fni_ - 1.0e0;
  dfn_ = fni_ + fnf_;
  fn_ = dfn_;
  goto _l450;
  _l500:;
  akm_ = _max (3.0e0 - fn_, 0.0);
  km_ = (int_4) (_aintd (akm_));
  tfn_ = fn_ + km_;
  ta_ = (gln_ + tfn_ - 0.9189385332e0 - 0.0833333333e0 / tfn_) / (tfn_ + 0.5e0);
  ta_ = xo2l_ - ta_;
  tb_ = -(1.0e0 - 1.0e0 / tfn_) / tfn_;
  ain_ = tolln_ / (-ta_ + sqrt (ta_ * ta_ - tolln_ * tb_)) + 1.5e0;
  in_ = (int_4) (_aintd (ain_));
  in_ = in_ + km_;
  goto _l520;
  _l510:;
  t_ = 1.0e0 / (fn_ * ra_);
  ain_ = tolln_ / (gln_ + sqrt (gln_ * gln_ + t_ * tolln_)) + 1.5e0;
  in_ = (int_4) (_aintd (ain_));
  if (in_ > inlim_) {
    goto _l160;
  }
  _l520:;
  trx_ = 2.0e0 / (*x_);
  dtm_ = fni_ + in_;
  tm_ = (dtm_ + fnf_) * trx_;
  ta_ = 0.0;
  tb_ = tol_;
  kk_ = 1;
  _l530:;
  for (i_ = 1; i_ <= in_; (i_)++) {
    s_ = tb_;
    tb_ = tm_ * tb_ + ta_;
    ta_ = s_;
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
  }
  if (kk_ != 1) {
    goto _l550;
  }
  ta_ = (ta_ / tb_) * temp_[2];
  tb_ = temp_[2];
  kk_ = 2;
  in_ = ns_;
  if (ns_ != 0) {
    goto _l530;
  }
  _l550:;
  y_[nn_ - 1] = tb_;
  (*nz_) = (*n_) - nn_;
  if (nn_ == 1) {
    goto _l0;
  }
  tb_ = tm_ * tb_ + ta_;
  k_ = nn_ - 1;
  y_[k_ - 1] = tb_;
  if (nn_ == 2) {
    goto _l0;
  }
  dtm_ = dtm_ - 1.0e0;
  tm_ = (dtm_ + fnf_) * trx_;
  km_ = k_ - 1;
  for (i_ = 1; i_ <= km_; (i_)++) {
    y_[k_ - 1 - 1] = tm_ * y_[k_ - 1] + y_[k_ + 1 - 1];
    dtm_ = dtm_ - 1.0e0;
    tm_ = (dtm_ + fnf_) * trx_;
    k_ = k_ - 1;
  }
  goto _l0;
  _l570:;
  (void) _xermsg (_dc_0, _dc_191, _dc_18, ($9_ = 2, &$9_), &_k1);
  goto _l0;
  _l580:;
  (void) _xermsg (_dc_0, _dc_191, _dc_19, ($10_ = 2, &$10_), &_k1);
  goto _l0;
  _l590:;
  (void) _xermsg (_dc_0, _dc_191, _dc_20, ($11_ = 2, &$11_), &_k1);
  goto _l0;
  _l600:;
  (void) _xermsg (_dc_0, _dc_191, _dc_21, ($12_ = 2, &$12_), &_k1);
  goto _l0;
  _l610:;
  (void) _xermsg (_dc_0, _dc_191, _dc_22, ($13_ = 6, &$13_), &_k1);
  _l0:;
  __calls[115].calls++;
  return 0;
}

real_8 _dbesj0 (real_8 _p_ x_)
{
  static int_4 ntj0_;
  static logical_4 first_;
  static real_8 bj0cs_[19], ampl_, theta_, xsml_, y_;
  int_4 _data_k_2031, _data_k_2032, _data_k_2033, _data_k_2034, _data_k_2035, _data_k_2036, _data_k_2037, _data_k_2038, 
  _data_k_2039, _data_k_2040, _data_k_2041, _data_k_2042, _data_k_2043, _data_k_2044, _data_k_2045, _data_k_2046, 
  _data_k_2047, _data_k_2048, _data_k_2049, _data_k_2050, $0_, $1_, $3_;
  real_4 $2_;
  real_8 $4_;
  real_8 dbesj0_;
  extern real_8 _d1mach ();
#define _data_n_2031 1
  static real_8 _data_l_2031[_data_n_2031] = {
    .10025416196893913701073127264074e+0
  };
#define _data_n_2032 1
  static real_8 _data_l_2032[_data_n_2032] = {
    -.66522300776440513177678757831124e+0
  };
#define _data_n_2033 1
  static real_8 _data_l_2033[_data_n_2033] = {
    .2489837034982813137046046872668e+0
  };
#define _data_n_2034 1
  static real_8 _data_l_2034[_data_n_2034] = {
    -.33252723170035769653884341503854e-1
  };
#define _data_n_2035 1
  static real_8 _data_l_2035[_data_n_2035] = {
    .23114179304694015462904924117729e-2
  };
#define _data_n_2036 1
  static real_8 _data_l_2036[_data_n_2036] = {
    -.99112774199508092339048519336549e-4
  };
#define _data_n_2037 1
  static real_8 _data_l_2037[_data_n_2037] = {
    .28916708643998808884733903747078e-5
  };
#define _data_n_2038 1
  static real_8 _data_l_2038[_data_n_2038] = {
    -.61210858663032635057818407481516e-7
  };
#define _data_n_2039 1
  static real_8 _data_l_2039[_data_n_2039] = {
    .98386507938567841324768748636415e-9
  };
#define _data_n_2040 1
  static real_8 _data_l_2040[_data_n_2040] = {
    -.12423551597301765145515897006836e-10
  };
#define _data_n_2041 1
  static real_8 _data_l_2041[_data_n_2041] = {
    .12654336302559045797915827210363e-12
  };
#define _data_n_2042 1
  static real_8 _data_l_2042[_data_n_2042] = {
    -.10619456495287244546914817512959e-14
  };
#define _data_n_2043 1
  static real_8 _data_l_2043[_data_n_2043] = {
    .74706210758024567437098915584e-17
  };
#define _data_n_2044 1
  static real_8 _data_l_2044[_data_n_2044] = {
    -.44697032274412780547627007999999e-19
  };
#define _data_n_2045 1
  static real_8 _data_l_2045[_data_n_2045] = {
    .23024281584337436200523093333333e-21
  };
#define _data_n_2046 1
  static real_8 _data_l_2046[_data_n_2046] = {
    -.10319144794166698148522666666666e-23
  };
#define _data_n_2047 1
  static real_8 _data_l_2047[_data_n_2047] = {
    .406081782748733227008e-26
  };
#define _data_n_2048 1
  static real_8 _data_l_2048[_data_n_2048] = {
    -.14143836005240913919999999999999e-28
  };
#define _data_n_2049 1
  static real_8 _data_l_2049[_data_n_2049] = {
    .4391090549669888e-31
  };
#define _data_n_2050 1
  static logical_4 _data_l_2050[_data_n_2050] = {
    TRUE
  };
  if (__calls[116].calls == 0) {
    _data_k_2031 = 0;
    if (_data_k_2031 >= _data_n_2031) {
      _data_k_2031 = 0;
    }
    bj0cs_[0] = _data_l_2031[_data_k_2031++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2032 = 0;
    if (_data_k_2032 >= _data_n_2032) {
      _data_k_2032 = 0;
    }
    bj0cs_[1] = _data_l_2032[_data_k_2032++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2033 = 0;
    if (_data_k_2033 >= _data_n_2033) {
      _data_k_2033 = 0;
    }
    bj0cs_[2] = _data_l_2033[_data_k_2033++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2034 = 0;
    if (_data_k_2034 >= _data_n_2034) {
      _data_k_2034 = 0;
    }
    bj0cs_[3] = _data_l_2034[_data_k_2034++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2035 = 0;
    if (_data_k_2035 >= _data_n_2035) {
      _data_k_2035 = 0;
    }
    bj0cs_[4] = _data_l_2035[_data_k_2035++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2036 = 0;
    if (_data_k_2036 >= _data_n_2036) {
      _data_k_2036 = 0;
    }
    bj0cs_[5] = _data_l_2036[_data_k_2036++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2037 = 0;
    if (_data_k_2037 >= _data_n_2037) {
      _data_k_2037 = 0;
    }
    bj0cs_[6] = _data_l_2037[_data_k_2037++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2038 = 0;
    if (_data_k_2038 >= _data_n_2038) {
      _data_k_2038 = 0;
    }
    bj0cs_[7] = _data_l_2038[_data_k_2038++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2039 = 0;
    if (_data_k_2039 >= _data_n_2039) {
      _data_k_2039 = 0;
    }
    bj0cs_[8] = _data_l_2039[_data_k_2039++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2040 = 0;
    if (_data_k_2040 >= _data_n_2040) {
      _data_k_2040 = 0;
    }
    bj0cs_[9] = _data_l_2040[_data_k_2040++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2041 = 0;
    if (_data_k_2041 >= _data_n_2041) {
      _data_k_2041 = 0;
    }
    bj0cs_[10] = _data_l_2041[_data_k_2041++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2042 = 0;
    if (_data_k_2042 >= _data_n_2042) {
      _data_k_2042 = 0;
    }
    bj0cs_[11] = _data_l_2042[_data_k_2042++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2043 = 0;
    if (_data_k_2043 >= _data_n_2043) {
      _data_k_2043 = 0;
    }
    bj0cs_[12] = _data_l_2043[_data_k_2043++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2044 = 0;
    if (_data_k_2044 >= _data_n_2044) {
      _data_k_2044 = 0;
    }
    bj0cs_[13] = _data_l_2044[_data_k_2044++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2045 = 0;
    if (_data_k_2045 >= _data_n_2045) {
      _data_k_2045 = 0;
    }
    bj0cs_[14] = _data_l_2045[_data_k_2045++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2046 = 0;
    if (_data_k_2046 >= _data_n_2046) {
      _data_k_2046 = 0;
    }
    bj0cs_[15] = _data_l_2046[_data_k_2046++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2047 = 0;
    if (_data_k_2047 >= _data_n_2047) {
      _data_k_2047 = 0;
    }
    bj0cs_[16] = _data_l_2047[_data_k_2047++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2048 = 0;
    if (_data_k_2048 >= _data_n_2048) {
      _data_k_2048 = 0;
    }
    bj0cs_[17] = _data_l_2048[_data_k_2048++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2049 = 0;
    if (_data_k_2049 >= _data_n_2049) {
      _data_k_2049 = 0;
    }
    bj0cs_[18] = _data_l_2049[_data_k_2049++];
  }
  if (__calls[116].calls == 0) {
    _data_k_2050 = 0;
    if (_data_k_2050 >= _data_n_2050) {
      _data_k_2050 = 0;
    }
    first_ = _data_l_2050[_data_k_2050++];
  }
  if (first_) {
    ntj0_ = _initds (bj0cs_, ($0_ = 19, &$0_), ($2_ = 0.1 * (real_4) (_d1mach (($1_ = 3, &$1_))), &$2_));
    xsml_ = sqrt (8.0e0 * _d1mach (($3_ = 3, &$3_)));
  }
  first_ = FALSE;
  y_ = _abs ((*x_));
  if (y_ > 4.0e0) {
    goto _l20;
  }
  dbesj0_ = 1.0;
  if (y_ > xsml_) {
    dbesj0_ = _dcsevl (($4_ = .125e0 * y_ * y_ - 1.0e0, &$4_), bj0cs_, &ntj0_);
  }
  goto _l0;
  _l20:;
  (void) _d9b0mp (&y_, &ampl_, &theta_);
  dbesj0_ = ampl_ * cos (theta_);
  _l0:;
  __calls[116].calls++;
  return dbesj0_;
}

real_8 _dbesj1 (real_8 _p_ x_)
{
  static int_4 ntj1_;
  static logical_4 first_;
  static real_8 bj1cs_[19], ampl_, theta_, xsml_, xmin_, y_;
  int_4 _data_k_2051, _data_k_2052, _data_k_2053, _data_k_2054, _data_k_2055, _data_k_2056, _data_k_2057, _data_k_2058, 
  _data_k_2059, _data_k_2060, _data_k_2061, _data_k_2062, _data_k_2063, _data_k_2064, _data_k_2065, _data_k_2066, 
  _data_k_2067, _data_k_2068, _data_k_2069, _data_k_2070, $0_, $1_, $3_;
  real_4 $2_;
  real_8 $4_;
  real_8 dbesj1_;
  extern real_8 _d1mach ();
#define _data_n_2051 1
  static real_8 _data_l_2051[_data_n_2051] = {
    -.117261415133327865606240574524003e+0
  };
#define _data_n_2052 1
  static real_8 _data_l_2052[_data_n_2052] = {
    -.253615218307906395623030884554698e+0
  };
#define _data_n_2053 1
  static real_8 _data_l_2053[_data_n_2053] = {
    .501270809844695685053656363203743e-1
  };
#define _data_n_2054 1
  static real_8 _data_l_2054[_data_n_2054] = {
    -.463151480962508191842619728789772e-2
  };
#define _data_n_2055 1
  static real_8 _data_l_2055[_data_n_2055] = {
    .247996229415914024539124064592364e-3
  };
#define _data_n_2056 1
  static real_8 _data_l_2056[_data_n_2056] = {
    -.867894868627882584521246435176416e-5
  };
#define _data_n_2057 1
  static real_8 _data_l_2057[_data_n_2057] = {
    .214293917143793691502766250991292e-6
  };
#define _data_n_2058 1
  static real_8 _data_l_2058[_data_n_2058] = {
    -.393609307918317979229322764073061e-8
  };
#define _data_n_2059 1
  static real_8 _data_l_2059[_data_n_2059] = {
    .559118231794688004018248059864032e-10
  };
#define _data_n_2060 1
  static real_8 _data_l_2060[_data_n_2060] = {
    -.63276164046613930247769527401488e-12
  };
#define _data_n_2061 1
  static real_8 _data_l_2061[_data_n_2061] = {
    .584099161085724700326945563268266e-14
  };
#define _data_n_2062 1
  static real_8 _data_l_