//! @file mathlib-lapack-arpack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 144 subprograms from LAPACK-ARPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CGBTF2 CLARNV DGBTRF DLAPY3 ICMAX1 SLAEV2 SLANV2 SLASR  ZGBTF2 ZLARFG
// CGBTRF CLARTG DGBTRS DLARAN IZMAX1 SLAEXC SLAPTM SLASRT ZGBTRF ZLARNV
// CGBTRS CLASCL DGTTRF DLARFX SCSUM1 SLAGTM SLAPY2 SLASSQ ZGBTRS ZLARTG
// CGEQR2 CLASET DGTTRS DLARND SGBTF2 SLAHQR SLAPY3 SLASWP ZGEQR2 ZLASCL
// CGTTRF CLASSQ DLACON DLARNV SGBTRF SLALN2 SLARAN SLASY2 ZGTTRF ZLASET
// CGTTRS CLASWP DLADIV DLARUV SGBTRS SLAMC1 SLARF  SORM2R ZGTTRS ZLASSQ
// CLACGV CLATRS DLAE2  DLASY2 SGEQR2 SLAMC2 SLARFG SPTTRF ZLACGV ZLASWP
// CLACON CMACH  DLAEV2 DPTTRF SGTTRF SLAMC3 SLARFX SPTTRS ZLACON ZLATRS
// CLACPY CROT   DLAEXC DPTTRS SGTTRS SLAMC4 SLARND SSTEQR ZLACPY ZROT
// CLADIV CTREVC DLAGTM DSTEQR SLABAD SLAMC5 SLARNV STREVC ZLADIV ZTREVC
// CLAHQR CTREXC DLAHQR DTREVC SLACON SLAMCH SLARTG STREXC ZLAHQR ZTREXC
// CLANGE CTRSEN DLALN2 DTREXC SLACPY SLANGE SLARUV STRSEN ZLANGE ZTRSEN
// CLANHS CTRSYL DLANHS DTRSEN SLADIV SLANHS SLASCL STRSYL ZLANHS ZTRSYL
// CLARF  CUNM2R DLANV2 DTRSYL SLAE2  SLANST SLASET XLAENV ZLARF  ZUNM2R
// CLARFG DGBTF2 DLAPTM DZSUM1

// LAPACK routines to support ARPACK.
// These LAPACK routines MUST be from the public release.

// The license for LAPACK Fortran source code is:
//
// BSD Software License
// 
// Pertains to ARPACK and P_ARPACK
// 
// Copyright (c) 1996-2008 Rice University.  
// Developed by D.C. Sorensen, R.B. Lehoucq, C. Yang, and K. Maschhoff.
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
// 
// - Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer. 
//   
// - Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer listed
//   in this license in the documentation and/or other materials
//   provided with the distribution.
//   
// - Neither the name of the copyright holders nor the names of its
//   contributors may be used to endorse or promote products derived from
//   this software without specific prior written permission.
//   
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT  
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT  
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "cgbtf2"
#define _dc_1 "cgbtrf"
#define _dc_2 " "
#define _dc_3 "left"
#define _dc_4 "lower"
#define _dc_5 "no transpose"
#define _dc_6 "unit"
#define _dc_7 "n"
#define _dc_8 "t"
#define _dc_9 "c"
#define _dc_10 "cgbtrs"
#define _dc_11 "upper"
#define _dc_12 "non-unit"
#define _dc_13 "transpose"
#define _dc_14 "conjugate transpose"
#define _dc_15 "cgeqr2"
#define _dc_16 "cgttrf"
#define _dc_17 "cgttrs"
#define _dc_18 "safe minimum"
#define _dc_19 "u"
#define _dc_20 "l"
#define _dc_21 "precision"
#define _dc_22 "1"
#define _dc_23 "m"
#define _dc_24 "o"
#define _dc_25 "i"
#define _dc_26 "f"
#define _dc_27 "e"
#define _dc_28 "s"
#define _dc_29 "g"
#define _dc_30 "h"
#define _dc_31 "b"
#define _dc_32 "q"
#define _dc_33 "z"
#define _dc_34 "clascl"
#define _dc_35 "y"
#define _dc_36 "clatrs"
#define _dc_37 "r"
#define _dc_38 "a"
#define _dc_39 "ctrevc"
#define _dc_40 "v"
#define _dc_41 "ctrexc"
#define _dc_42 "ctrsen"
#define _dc_43 "ctrsyl"
#define _dc_44 "p"
#define _dc_45 "cunm2r"
#define _dc_46 "dgbtf2"
#define _dc_47 "dgbtrf"
#define _dc_48 "dgbtrs"
#define _dc_49 "dgttrf"
#define _dc_50 "dgttrs"
#define _dc_51 "full"
#define _dc_52 "max"
#define _dc_53 "dpttrf"
#define _dc_54 "dpttrs"
#define _dc_55 "dsteqr"
#define _dc_56 "dtrevc"
#define _dc_57 "dtrexc"
#define _dc_58 "dtrsen"
#define _dc_59 "dtrsyl"
#define _dc_60 "sgbtf2"
#define _dc_61 "sgbtrf"
#define _dc_62 "sgbtrs"
#define _dc_63 "sgeqr2"
#define _dc_64 "sgttrf"
#define _dc_65 "sgttrs"
#define _dc_66 " warning. the value emin may be incorrect:-"
#define _dc_67 "  emin = "
#define _dc_68 " if, after inspection, the value emin looks"
#define _dc_69 " acceptable please comment out "
#define _dc_70 " the if block as marked within the code of routine"
#define _dc_71 " slamc2,"
#define _dc_72 " otherwise supply emin explicitly."
#define _dc_73 "slascl"
#define _dc_74 "slasr "
#define _dc_75 "d"
#define _dc_76 "slasrt"
#define _dc_77 "sorm2r"
#define _dc_78 "spttrf"
#define _dc_79 "spttrs"
#define _dc_80 "ssteqr"
#define _dc_81 "strevc"
#define _dc_82 "strexc"
#define _dc_83 "strsen"
#define _dc_84 "strsyl"
#define _dc_85 "zgbtf2"
#define _dc_86 "zgbtrf"
#define _dc_87 "zgbtrs"
#define _dc_88 "zgeqr2"
#define _dc_89 "zgttrf"
#define _dc_90 "zgttrs"
#define _dc_91 "zlascl"
#define _dc_92 "zlatrs"
#define _dc_93 "ztrevc"
#define _dc_94 "ztrexc"
#define _dc_95 "ztrsen"
#define _dc_96 "ztrsyl"
#define _dc_97 "zunm2r"
static FORMAT *__fmt_a = NULL;
typedef char char_1[2];
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
#define __ncalls 145
static CALLS __calls[__ncalls] = {
  {"cgbtf2", 0}, // subroutine
  {"cgbtrf", 0}, // subroutine
  {"cgbtrs", 0}, // subroutine
  {"cgeqr2", 0}, // subroutine
  {"cgttrf", 0}, // subroutine
  {"cgttrs", 0}, // subroutine
  {"clacgv", 0}, // subroutine
  {"clacon", 0}, // subroutine
  {"clacpy", 0}, // subroutine
  {"cladiv", 0}, // complex*8 function
  {"clahqr", 0}, // subroutine
  {"clange", 0}, // real*4 function
  {"clanhs", 0}, // real*4 function
  {"clarf", 0}, // subroutine
  {"clarfg", 0}, // subroutine
  {"clarnv", 0}, // subroutine
  {"clartg", 0}, // subroutine
  {"clascl", 0}, // subroutine
  {"claset", 0}, // subroutine
  {"classq", 0}, // subroutine
  {"claswp", 0}, // subroutine
  {"clatrs", 0}, // subroutine
  {"cmach", 0}, // real*4 function
  {"crot", 0}, // subroutine
  {"ctrevc", 0}, // subroutine
  {"ctrexc", 0}, // subroutine
  {"ctrsen", 0}, // subroutine
  {"ctrsyl", 0}, // subroutine
  {"cunm2r", 0}, // subroutine
  {"dgbtf2", 0}, // subroutine
  {"dgbtrf", 0}, // subroutine
  {"dgbtrs", 0}, // subroutine
  {"dgttrf", 0}, // subroutine
  {"dgttrs", 0}, // subroutine
  {"dlacon", 0}, // subroutine
  {"dladiv", 0}, // subroutine
  {"dlae2", 0}, // subroutine
  {"dlaev2", 0}, // subroutine
  {"dlaexc", 0}, // subroutine
  {"dlagtm", 0}, // subroutine
  {"dlahqr", 0}, // subroutine
  {"dlaln2", 0}, // subroutine
  {"dlanhs", 0}, // real*8 function
  {"dlanv2", 0}, // subroutine
  {"dlaptm", 0}, // subroutine
  {"dlapy3", 0}, // real*8 function
  {"dlaran", 0}, // real*8 function
  {"dlarfx", 0}, // subroutine
  {"dlarnd", 0}, // real*8 function
  {"dlarnv", 0}, // subroutine
  {"dlaruv", 0}, // subroutine
  {"dlasy2", 0}, // subroutine
  {"dpttrf", 0}, // subroutine
  {"dpttrs", 0}, // subroutine
  {"dsteqr", 0}, // subroutine
  {"dtrevc", 0}, // subroutine
  {"dtrexc", 0}, // subroutine
  {"dtrsen", 0}, // subroutine
  {"dtrsyl", 0}, // subroutine
  {"dzsum1", 0}, // real*8 function
  {"icmax1", 0}, // integer*4 function
  {"izmax1", 0}, // integer*4 function
  {"scsum1", 0}, // real*4 function
  {"sgbtf2", 0}, // subroutine
  {"sgbtrf", 0}, // subroutine
  {"sgbtrs", 0}, // subroutine
  {"sgeqr2", 0}, // subroutine
  {"sgttrf", 0}, // subroutine
  {"sgttrs", 0}, // subroutine
  {"slabad", 0}, // subroutine
  {"slacon", 0}, // subroutine
  {"slacpy", 0}, // subroutine
  {"sladiv", 0}, // subroutine
  {"slae2", 0}, // subroutine
  {"slaev2", 0}, // subroutine
  {"slaexc", 0}, // subroutine
  {"slagtm", 0}, // subroutine
  {"slahqr", 0}, // subroutine
  {"slaln2", 0}, // subroutine
  {"slamch", 0}, // real*4 function
  {"slamc1", 0}, // subroutine
  {"slamc2", 0}, // subroutine
  {"slamc3", 0}, // real*4 function
  {"slamc4", 0}, // subroutine
  {"slamc5", 0}, // subroutine
  {"slange", 0}, // real*4 function
  {"slanhs", 0}, // real*4 function
  {"slanst", 0}, // real*4 function
  {"slanv2", 0}, // subroutine
  {"slaptm", 0}, // subroutine
  {"slapy2", 0}, // real*4 function
  {"slapy3", 0}, // real*4 function
  {"slaran", 0}, // real*4 function
  {"slarf", 0}, // subroutine
  {"slarfg", 0}, // subroutine
  {"slarfx", 0}, // subroutine
  {"slarnd", 0}, // real*4 function
  {"slarnv", 0}, // subroutine
  {"slartg", 0}, // subroutine
  {"slaruv", 0}, // subroutine
  {"slascl", 0}, // subroutine
  {"slaset", 0}, // subroutine
  {"slasr", 0}, // subroutine
  {"slasrt", 0}, // subroutine
  {"slassq", 0}, // subroutine
  {"slaswp", 0}, // subroutine
  {"slasy2", 0}, // subroutine
  {"sorm2r", 0}, // subroutine
  {"spttrf", 0}, // subroutine
  {"spttrs", 0}, // subroutine
  {"ssteqr", 0}, // subroutine
  {"strevc", 0}, // subroutine
  {"strexc", 0}, // subroutine
  {"strsen", 0}, // subroutine
  {"strsyl", 0}, // subroutine
  {"xlaenv", 0}, // subroutine
  {"zgbtf2", 0}, // subroutine
  {"zgbtrf", 0}, // subroutine
  {"zgbtrs", 0}, // subroutine
  {"zgeqr2", 0}, // subroutine
  {"zgttrf", 0}, // subroutine
  {"zgttrs", 0}, // subroutine
  {"zlacgv", 0}, // subroutine
  {"zlacon", 0}, // subroutine
  {"zlacpy", 0}, // subroutine
  {"zladiv", 0}, // complex*16 function
  {"zlahqr", 0}, // subroutine
  {"zlange", 0}, // real*8 function
  {"zlanhs", 0}, // real*8 function
  {"zlarf", 0}, // subroutine
  {"zlarfg", 0}, // subroutine
  {"zlarnv", 0}, // subroutine
  {"zlartg", 0}, // subroutine
  {"zlascl", 0}, // subroutine
  {"zlaset", 0}, // subroutine
  {"zlassq", 0}, // subroutine
  {"zlaswp", 0}, // subroutine
  {"zlatrs", 0}, // subroutine
  {"zrot", 0}, // subroutine
  {"ztrevc", 0}, // subroutine
  {"ztrexc", 0}, // subroutine
  {"ztrsen", 0}, // subroutine
  {"ztrsyl", 0}, // subroutine
  {"zunm2r", 0}, // subroutine
  {NULL, 0}
};

static struct {
  int_4 iparms_[100];
} claenv_;
prototype int_4 _cgbtf2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_8 _p_ ab_, int_4 _p_ ldab_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _cgbtrf (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_8 _p_ ab_, int_4 _p_ ldab_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _cgbtrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, int_4 _p_ nrhs_, complex_8 _p_ 
ab_, int_4 _p_ ldab_, int_4 _p_ ipiv_, complex_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_);
prototype int_4 _cgeqr2 (int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ tau_, complex_8 
_p_ work_, int_4 _p_ info_);
prototype int_4 _cgttrf (int_4 _p_ n_, complex_8 _p_ dl_, complex_8 _p_ d_, complex_8 _p_ du_, complex_8 _p_ du2_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _cgttrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, complex_8 _p_ dl_, complex_8 _p_ d_, complex_8 
_p_ du_, complex_8 _p_ du2_, int_4 _p_ ipiv_, complex_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_);
prototype int_4 _clacgv (int_4 _p_ n_, complex_8 _p_ x_, int_4 _p_ incx_);
prototype int_4 _clacon (int_4 _p_ n_, complex_8 _p_ v_, complex_8 _p_ x_, real_4 _p_ est_, int_4 _p_ kase_);
prototype int_4 _clacpy (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ b_
, int_4 _p_ ldb_);
prototype complex_8 _cladiv (complex_8 _p_ x_, complex_8 _p_ y_);
prototype int_4 _clahqr (logical_4 _p_ wantt_, logical_4 _p_ wantz_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, 
complex_8 _p_ h_, int_4 _p_ ldh_, complex_8 _p_ w_, int_4 _p_ iloz_, int_4 _p_ ihiz_, complex_8 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ info_);
prototype real_4 _clange (char _p_ norm_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, real_4 _p_ 
work_);
prototype real_4 _clanhs (char _p_ norm_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, real_4 _p_ work_);
prototype int_4 _clarf (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ incv_, complex_8 _p_ 
tau_, complex_8 _p_ c_, int_4 _p_ ldc_, complex_8 _p_ work_);
prototype int_4 _clarfg (int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ tau_);
prototype int_4 _clarnv (int_4 _p_ idist_, int_4 _p_ iseed_, int_4 _p_ n_, complex_8 _p_ x_);
prototype int_4 _clartg (complex_8 _p_ f_, complex_8 _p_ g_, real_4 _p_ cs_, complex_8 _p_ sn_, complex_8 _p_ r_);
prototype int_4 _clascl (char _p_ type_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ cfrom_, real_4 _p_ cto_, int_4 _p_ m_
, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ info_);
prototype int_4 _claset (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ beta_, 
complex_8 _p_ a_, int_4 _p_ lda_);
prototype int_4 _classq (int_4 _p_ n_, complex_8 _p_ x_, int_4 _p_ incx_, real_4 _p_ scale_, real_4 _p_ sumsq_);
prototype int_4 _claswp (int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ k1_, int_4 _p_ k2_, int_4 _p_ ipiv_, 
int_4 _p_ incx_);
prototype int_4 _clatrs (char _p_ uplo_, char _p_ trans_, char _p_ diag_, char _p_ normin_, int_4 _p_ n_, complex_8 _p_ 
a_, int_4 _p_ lda_, complex_8 _p_ x_, real_4 _p_ scale_, real_4 _p_ cnorm_, int_4 _p_ info_);
prototype real_4 _cmach (int_4 _p_ job_);
prototype int_4 _crot (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_, real_4 _p_ 
c_, complex_8 _p_ s_);
prototype int_4 _ctrevc (char _p_ side_, char _p_ howmny_, logical_4 _p_ select_, int_4 _p_ n_, complex_8 _p_ t_, int_4 
_p_ ldt_, complex_8 _p_ vl_, int_4 _p_ ldvl_, complex_8 _p_ vr_, int_4 _p_ ldvr_, int_4 _p_ mm_, int_4 _p_ m_, 
complex_8 _p_ work_, real_4 _p_ rwork_, int_4 _p_ info_);
prototype int_4 _ctrexc (char _p_ compq_, int_4 _p_ n_, complex_8 _p_ t_, int_4 _p_ ldt_, complex_8 _p_ q_, int_4 _p_ 
ldq_, int_4 _p_ ifst_, int_4 _p_ ilst_, int_4 _p_ info_);
prototype int_4 _ctrsen (char _p_ job_, char _p_ compq_, logical_4 _p_ select_, int_4 _p_ n_, complex_8 _p_ t_, int_4 
_p_ ldt_, complex_8 _p_ q_, int_4 _p_ ldq_, complex_8 _p_ w_, int_4 _p_ m_, real_4 _p_ s_, real_4 _p_ sep_, complex_8 
_p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _ctrsyl (char _p_ trana_, char _p_ tranb_, int_4 _p_ isgn_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ 
a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ c_, int_4 _p_ ldc_, real_4 _p_ scale_, int_4 _p_ 
info_);
prototype int_4 _cunm2r (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ a_, 
int_4 _p_ lda_, complex_8 _p_ tau_, complex_8 _p_ c_, int_4 _p_ ldc_, complex_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dgbtf2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ ab_, int_4 _p_ ldab_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _dgbtrf (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ ab_, int_4 _p_ ldab_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _dgbtrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, int_4 _p_ nrhs_, real_8 _p_ ab_, 
int_4 _p_ ldab_, int_4 _p_ ipiv_, real_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_);
prototype int_4 _dgttrf (int_4 _p_ n_, real_8 _p_ dl_, real_8 _p_ d_, real_8 _p_ du_, real_8 _p_ du2_, int_4 _p_ ipiv_, 
int_4 _p_ info_);
prototype int_4 _dgttrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ dl_, real_8 _p_ d_, real_8 _p_ du_, 
real_8 _p_ du2_, int_4 _p_ ipiv_, real_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_);
prototype int_4 _dlacon (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ x_, int_4 _p_ isgn_, real_8 _p_ est_, int_4 _p_ kase_)
;
prototype int_4 _dladiv (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ d_, real_8 _p_ p_, real_8 _p_ q_);
prototype int_4 _dlae2 (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ rt1_, real_8 _p_ rt2_);
prototype int_4 _dlaev2 (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ rt1_, real_8 _p_ rt2_, real_8 _p_ cs1_
, real_8 _p_ sn1_);
prototype int_4 _dlaexc (logical_4 _p_ wantq_, int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ q_, int_4 _p_ 
ldq_, int_4 _p_ j1_, int_4 _p_ n1_, int_4 _p_ n2_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dlagtm (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ alpha_, real_8 _p_ dl_, real_8 _p_ 
d_, real_8 _p_ du_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ beta_, real_8 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _dlahqr (logical_4 _p_ wantt_, logical_4 _p_ wantz_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, 
real_8 _p_ h_, int_4 _p_ ldh_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ iloz_, int_4 _p_ ihiz_, real_8 _p_ z_, int_4 
_p_ ldz_, int_4 _p_ info_);
prototype int_4 _dlaln2 (logical_4 _p_ ltrans_, int_4 _p_ na_, int_4 _p_ nw_, real_8 _p_ smin_, real_8 _p_ ca_, real_8 
_p_ a_, int_4 _p_ lda_, real_8 _p_ d1_, real_8 _p_ d2_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ wr_, real_8 _p_ wi_, 
real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ scale_, real_8 _p_ xnorm_, int_4 _p_ info_);
prototype real_8 _dlanhs (char _p_ norm_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ work_);
prototype int_4 _dlanv2 (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ d_, real_8 _p_ rt1r_, real_8 _p_ rt1i_
, real_8 _p_ rt2r_, real_8 _p_ rt2i_, real_8 _p_ cs_, real_8 _p_ sn_);
prototype int_4 _dlaptm (int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ alpha_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ x_, 
int_4 _p_ ldx_, real_8 _p_ beta_, real_8 _p_ b_, int_4 _p_ ldb_);
prototype real_8 _dlapy3 (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ z_);
prototype real_8 _dlaran (int_4 _p_ iseed_);
prototype int_4 _dlarfx (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ tau_, real_8 _p_ c_, 
int_4 _p_ ldc_, real_8 _p_ work_);
prototype real_8 _dlarnd (int_4 _p_ idist_, int_4 _p_ iseed_);
prototype int_4 _dlarnv (int_4 _p_ idist_, int_4 _p_ iseed_, int_4 _p_ n_, real_8 _p_ x_);
prototype int_4 _dlaruv (int_4 _p_ iseed_, int_4 _p_ n_, real_8 _p_ x_);
prototype int_4 _dlasy2 (logical_4 _p_ ltranl_, logical_4 _p_ ltranr_, int_4 _p_ isgn_, int_4 _p_ n1_, int_4 _p_ n2_, 
real_8 _p_ tl_, int_4 _p_ ldtl_, real_8 _p_ tr_, int_4 _p_ ldtr_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ scale_, 
real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ xnorm_, int_4 _p_ info_);
prototype int_4 _dpttrf (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, int_4 _p_ info_);
prototype int_4 _dpttrs (int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ b_, int_4 _p_ ldb_, 
int_4 _p_ info_);
prototype int_4 _dsteqr (char _p_ compz_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, int_4 _p_ ldz_, 
real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dtrevc (char _p_ side_, char _p_ howmny_, logical_4 _p_ select_, int_4 _p_ n_, real_8 _p_ t_, int_4 
_p_ ldt_, real_8 _p_ vl_, int_4 _p_ ldvl_, real_8 _p_ vr_, int_4 _p_ ldvr_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ 
work_, int_4 _p_ info_);
prototype int_4 _dtrexc (char _p_ compq_, int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ q_, int_4 _p_ ldq_, 
int_4 _p_ ifst_, int_4 _p_ ilst_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dtrsen (char _p_ job_, char _p_ compq_, logical_4 _p_ select_, int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ 
ldt_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ m_, real_8 _p_ s_, real_8 _p_ sep_, 
real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ info_);
prototype int_4 _dtrsyl (char _p_ trana_, char _p_ tranb_, int_4 _p_ isgn_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ scale_, int_4 _p_ info_);
prototype real_8 _dzsum1 (int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ incx_);
prototype int_4 _icmax1 (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_);
prototype int_4 _izmax1 (int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ incx_);
prototype real_4 _scsum1 (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_);
prototype int_4 _sgbtf2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ ab_, int_4 _p_ ldab_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _sgbtrf (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ ab_, int_4 _p_ ldab_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _sgbtrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, int_4 _p_ nrhs_, real_4 _p_ ab_, 
int_4 _p_ ldab_, int_4 _p_ ipiv_, real_4 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_);
prototype int_4 _sgeqr2 (int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ tau_, real_4 _p_ work_, 
int_4 _p_ info_);
prototype int_4 _sgttrf (int_4 _p_ n_, real_4 _p_ dl_, real_4 _p_ d_, real_4 _p_ du_, real_4 _p_ du2_, int_4 _p_ ipiv_, 
int_4 _p_ info_);
prototype int_4 _sgttrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, real_4 _p_ dl_, real_4 _p_ d_, real_4 _p_ du_, 
real_4 _p_ du2_, int_4 _p_ ipiv_, real_4 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_);
prototype int_4 _slabad (real_4 _p_ small_, real_4 _p_ large_);
prototype int_4 _slacon (int_4 _p_ n_, real_4 _p_ v_, real_4 _p_ x_, int_4 _p_ isgn_, real_4 _p_ est_, int_4 _p_ kase_)
;
prototype int_4 _slacpy (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ b_, 
int_4 _p_ ldb_);
prototype int_4 _sladiv (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ p_, real_4 _p_ q_);
prototype int_4 _slae2 (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ rt1_, real_4 _p_ rt2_);
prototype int_4 _slaev2 (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ rt1_, real_4 _p_ rt2_, real_4 _p_ cs1_
, real_4 _p_ sn1_);
prototype int_4 _slaexc (logical_4 _p_ wantq_, int_4 _p_ n_, real_4 _p_ t_, int_4 _p_ ldt_, real_4 _p_ q_, int_4 _p_ 
ldq_, int_4 _p_ j1_, int_4 _p_ n1_, int_4 _p_ n2_, real_4 _p_ work_, int_4 _p_ info_);
prototype int_4 _slagtm (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, real_4 _p_ alpha_, real_4 _p_ dl_, real_4 _p_ 
d_, real_4 _p_ du_, real_4 _p_ x_, int_4 _p_ ldx_, real_4 _p_ beta_, real_4 _p_ b_, int_4 _p_ ldb_);
prototype int_4 _slahqr (logical_4 _p_ wantt_, logical_4 _p_ wantz_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, 
real_4 _p_ h_, int_4 _p_ ldh_, real_4 _p_ wr_, real_4 _p_ wi_, int_4 _p_ iloz_, int_4 _p_ ihiz_, real_4 _p_ z_, int_4 
_p_ ldz_, int_4 _p_ info_);
prototype int_4 _slaln2 (logical_4 _p_ ltrans_, int_4 _p_ na_, int_4 _p_ nw_, real_4 _p_ smin_, real_4 _p_ ca_, real_4 
_p_ a_, int_4 _p_ lda_, real_4 _p_ d1_, real_4 _p_ d2_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ wr_, real_4 _p_ wi_, 
real_4 _p_ x_, int_4 _p_ ldx_, real_4 _p_ scale_, real_4 _p_ xnorm_, int_4 _p_ info_);
prototype real_4 _slamch (char _p_ cmach_);
prototype int_4 _slamc1 (int_4 _p_ beta_, int_4 _p_ t_, logical_4 _p_ rnd_, logical_4 _p_ ieee1_);
prototype int_4 _slamc2 (int_4 _p_ beta_, int_4 _p_ t_, logical_4 _p_ rnd_, real_4 _p_ eps_, int_4 _p_ emin_, real_4 
_p_ rmin_, int_4 _p_ emax_, real_4 _p_ rmax_);
prototype real_4 _slamc3 (real_4 _p_ a_, real_4 _p_ b_);
prototype int_4 _slamc4 (int_4 _p_ emin_, real_4 _p_ start_, int_4 _p_ base_);
prototype int_4 _slamc5 (int_4 _p_ beta_, int_4 _p_ p_, int_4 _p_ emin_, logical_4 _p_ ieee_, int_4 _p_ emax_, real_4 
_p_ rmax_);
prototype real_4 _slange (char _p_ norm_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ work_);
prototype real_4 _slanhs (char _p_ norm_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ work_);
prototype real_4 _slanst (char _p_ norm_, int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_);
prototype int_4 _slanv2 (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ rt1r_, real_4 _p_ rt1i_
, real_4 _p_ rt2r_, real_4 _p_ rt2i_, real_4 _p_ cs_, real_4 _p_ sn_);
prototype int_4 _slaptm (int_4 _p_ n_, int_4 _p_ nrhs_, real_4 _p_ alpha_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ x_, 
int_4 _p_ ldx_, real_4 _p_ beta_, real_4 _p_ b_, int_4 _p_ ldb_);
prototype real_4 _slapy2 (real_4 _p_ x_, real_4 _p_ y_);
prototype real_4 _slapy3 (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ z_);
prototype real_4 _slaran (int_4 _p_ iseed_);
prototype int_4 _slarf (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ v_, int_4 _p_ incv_, real_4 _p_ tau_, 
real_4 _p_ c_, int_4 _p_ ldc_, real_4 _p_ work_);
prototype int_4 _slarfg (int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ tau_);
prototype int_4 _slarfx (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ v_, real_4 _p_ tau_, real_4 _p_ c_, 
int_4 _p_ ldc_, real_4 _p_ work_);
prototype real_4 _slarnd (int_4 _p_ idist_, int_4 _p_ iseed_);
prototype int_4 _slarnv (int_4 _p_ idist_, int_4 _p_ iseed_, int_4 _p_ n_, real_4 _p_ x_);
prototype int_4 _slartg (real_4 _p_ f_, real_4 _p_ g_, real_4 _p_ cs_, real_4 _p_ sn_, real_4 _p_ r_);
prototype int_4 _slaruv (int_4 _p_ iseed_, int_4 _p_ n_, real_4 _p_ x_);
prototype int_4 _slascl (char _p_ type_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ cfrom_, real_4 _p_ cto_, int_4 _p_ m_
, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ info_);
prototype int_4 _slaset (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ a_
, int_4 _p_ lda_);
prototype int_4 _slasr (char _p_ side_, char _p_ pivot_, char _p_ direct_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ c_, 
real_4 _p_ s_, real_4 _p_ a_, int_4 _p_ lda_);
prototype int_4 _slasrt (char _p_ id_, int_4 _p_ n_, real_4 _p_ d_, int_4 _p_ info_);
prototype int_4 _slassq (int_4 _p_ n_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ scale_, real_4 _p_ sumsq_);
prototype int_4 _slaswp (int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ k1_, int_4 _p_ k2_, int_4 _p_ ipiv_, 
int_4 _p_ incx_);
prototype int_4 _slasy2 (logical_4 _p_ ltranl_, logical_4 _p_ ltranr_, int_4 _p_ isgn_, int_4 _p_ n1_, int_4 _p_ n2_, 
real_4 _p_ tl_, int_4 _p_ ldtl_, real_4 _p_ tr_, int_4 _p_ ldtr_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ scale_, 
real_4 _p_ x_, int_4 _p_ ldx_, real_4 _p_ xnorm_, int_4 _p_ info_);
prototype int_4 _sorm2r (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ a_, 
int_4 _p_ lda_, real_4 _p_ tau_, real_4 _p_ c_, int_4 _p_ ldc_, real_4 _p_ work_, int_4 _p_ info_);
prototype int_4 _spttrf (int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_, int_4 _p_ info_);
prototype int_4 _spttrs (int_4 _p_ n_, int_4 _p_ nrhs_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ b_, int_4 _p_ ldb_, 
int_4 _p_ info_);
prototype int_4 _ssteqr (char _p_ compz_, int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ z_, int_4 _p_ ldz_, 
real_4 _p_ work_, int_4 _p_ info_);
prototype int_4 _strevc (char _p_ side_, char _p_ howmny_, logical_4 _p_ select_, int_4 _p_ n_, real_4 _p_ t_, int_4 
_p_ ldt_, real_4 _p_ vl_, int_4 _p_ ldvl_, real_4 _p_ vr_, int_4 _p_ ldvr_, int_4 _p_ mm_, int_4 _p_ m_, real_4 _p_ 
work_, int_4 _p_ info_);
prototype int_4 _strexc (char _p_ compq_, int_4 _p_ n_, real_4 _p_ t_, int_4 _p_ ldt_, real_4 _p_ q_, int_4 _p_ ldq_, 
int_4 _p_ ifst_, int_4 _p_ ilst_, real_4 _p_ work_, int_4 _p_ info_);
prototype int_4 _strsen (char _p_ job_, char _p_ compq_, logical_4 _p_ select_, int_4 _p_ n_, real_4 _p_ t_, int_4 _p_ 
ldt_, real_4 _p_ q_, int_4 _p_ ldq_, real_4 _p_ wr_, real_4 _p_ wi_, int_4 _p_ m_, real_4 _p_ s_, real_4 _p_ sep_, 
real_4 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ info_);
prototype int_4 _strsyl (char _p_ trana_, char _p_ tranb_, int_4 _p_ isgn_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, 
int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ c_, int_4 _p_ ldc_, real_4 _p_ scale_, int_4 _p_ info_);
prototype int_4 _xlaenv (int_4 _p_ ispec_, int_4 _p_ nvalue_);
prototype int_4 _zgbtf2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_16 _p_ ab_, int_4 _p_ ldab_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _zgbtrf (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_16 _p_ ab_, int_4 _p_ ldab_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _zgbtrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, int_4 _p_ nrhs_, complex_16 _p_ 
ab_, int_4 _p_ ldab_, int_4 _p_ ipiv_, complex_16 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_);
prototype int_4 _zgeqr2 (int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ tau_, complex_16 
_p_ work_, int_4 _p_ info_);
prototype int_4 _zgttrf (int_4 _p_ n_, complex_16 _p_ dl_, complex_16 _p_ d_, complex_16 _p_ du_, complex_16 _p_ du2_, 
int_4 _p_ ipiv_, int_4 _p_ info_);
prototype int_4 _zgttrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, complex_16 _p_ dl_, complex_16 _p_ d_, 
complex_16 _p_ du_, complex_16 _p_ du2_, int_4 _p_ ipiv_, complex_16 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_);
prototype int_4 _zlacgv (int_4 _p_ n_, complex_16 _p_ x_, int_4 _p_ incx_);
prototype int_4 _zlacon (int_4 _p_ n_, complex_16 _p_ v_, complex_16 _p_ x_, real_8 _p_ est_, int_4 _p_ kase_);
prototype int_4 _zlacpy (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ 
b_, int_4 _p_ ldb_);
prototype complex_16 _zladiv (complex_16 _p_ x_, complex_16 _p_ y_);
prototype int_4 _zlahqr (logical_4 _p_ wantt_, logical_4 _p_ wantz_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, 
complex_16 _p_ h_, int_4 _p_ ldh_, complex_16 _p_ w_, int_4 _p_ iloz_, int_4 _p_ ihiz_, complex_16 _p_ z_, int_4 _p_ 
ldz_, int_4 _p_ info_);
prototype real_8 _zlange (char _p_ norm_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, real_8 _p_ 
work_);
prototype real_8 _zlanhs (char _p_ norm_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, real_8 _p_ work_);
prototype int_4 _zlarf (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ v_, int_4 _p_ incv_, complex_16 _p_ 
tau_, complex_16 _p_ c_, int_4 _p_ ldc_, complex_16 _p_ work_);
prototype int_4 _zlarfg (int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ tau_);
prototype int_4 _zlarnv (int_4 _p_ idist_, int_4 _p_ iseed_, int_4 _p_ n_, complex_16 _p_ x_);
prototype int_4 _zlartg (complex_16 _p_ f_, complex_16 _p_ g_, real_8 _p_ cs_, complex_16 _p_ sn_, complex_16 _p_ r_);
prototype int_4 _zlascl (char _p_ type_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ cfrom_, real_8 _p_ cto_, int_4 _p_ m_
, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ info_);
prototype int_4 _zlaset (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ beta_, 
complex_16 _p_ a_, int_4 _p_ lda_);
prototype int_4 _zlassq (int_4 _p_ n_, complex_16 _p_ x_, int_4 _p_ incx_, real_8 _p_ scale_, real_8 _p_ sumsq_);
prototype int_4 _zlaswp (int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ k1_, int_4 _p_ k2_, int_4 _p_ ipiv_
, int_4 _p_ incx_);
prototype int_4 _zlatrs (char _p_ uplo_, char _p_ trans_, char _p_ diag_, char _p_ normin_, int_4 _p_ n_, complex_16 
_p_ a_, int_4 _p_ lda_, complex_16 _p_ x_, real_8 _p_ scale_, real_8 _p_ cnorm_, int_4 _p_ info_);
prototype int_4 _zrot (int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ incx_, complex_16 _p_ cy_, int_4 _p_ incy_, real_8 
_p_ c_, complex_16 _p_ s_);
prototype int_4 _ztrevc (char _p_ side_, char _p_ howmny_, logical_4 _p_ select_, int_4 _p_ n_, complex_16 _p_ t_, 
int_4 _p_ ldt_, complex_16 _p_ vl_, int_4 _p_ ldvl_, complex_16 _p_ vr_, int_4 _p_ ldvr_, int_4 _p_ mm_, int_4 _p_ m_, 
complex_16 _p_ work_, real_8 _p_ rwork_, int_4 _p_ info_);
prototype int_4 _ztrexc (char _p_ compq_, int_4 _p_ n_, complex_16 _p_ t_, int_4 _p_ ldt_, complex_16 _p_ q_, int_4 _p_ 
ldq_, int_4 _p_ ifst_, int_4 _p_ ilst_, int_4 _p_ info_);
prototype int_4 _ztrsen (char _p_ job_, char _p_ compq_, logical_4 _p_ select_, int_4 _p_ n_, complex_16 _p_ t_, int_4 
_p_ ldt_, complex_16 _p_ q_, int_4 _p_ ldq_, complex_16 _p_ w_, int_4 _p_ m_, real_8 _p_ s_, real_8 _p_ sep_, 
complex_16 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _ztrsyl (char _p_ trana_, char _p_ tranb_, int_4 _p_ isgn_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ 
a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ c_, int_4 _p_ ldc_, real_8 _p_ scale_, int_4 _p_ 
info_);
prototype int_4 _zunm2r (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ tau_, complex_16 _p_ c_, int_4 _p_ ldc_, complex_16 _p_ work_, int_4 _p_ info_);
int_4 _cgbtf2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_8 _p_ ab_, int_4 _p_ ldab_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_, j_, jp_, ju_, km_, kv_;
  int_4 $0_, $1_, $2_, $3_, $4_, $6_, $8_, $9_;
  complex_8 $5_, $7_;
  extern int_4 _icamax ();
  extern int_4 _cgeru ();
  extern int_4 _cscal ();
  extern int_4 _cswap ();
  extern int_4 _xerbla ();
  kv_ = (*ku_) + (*kl_);
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldab_) < (*kl_) + kv_ + 1) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_0, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  for (j_ = (*ku_) + 2; j_ <= _min (kv_, (*n_)); (j_)++) {
    for (i_ = kv_ - j_ + 2; i_ <= (*kl_); (i_)++) {
      ab_[i_ - 1 + ((*ldab_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
    }
  }
  ju_ = 1;
  for (j_ = 1; j_ <= _min ((*m_), (*n_)); (j_)++) {
    if (j_ + kv_ <= (*n_)) {
      for (i_ = 1; i_ <= (*kl_); (i_)++) {
        ab_[i_ - 1 + ((*ldab_)) * ((j_ + kv_ - 1))] = CMPLXF (0.0, 0.0);
      }
    }
    km_ = _min ((*kl_), (*m_) - j_);
    jp_ = _icamax (($1_ = km_ + 1, &$1_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1);
    ipiv_[j_ - 1] = jp_ + j_ - 1;
    if (ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((j_ - 1))] != CMPLXF (0.0, 0.0)) {
      ju_ = _max (ju_, _min (j_ + (*ku_) + jp_ - 1, (*n_)));
      if (jp_ != 1) {
        (void) _cswap (($2_ = ju_ - j_ + 1, &$2_), &ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((j_ - 1))], ($3_ = (*ldab_) - 1, &$3_), 
        &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], ($4_ = (*ldab_) - 1, &$4_));
      }
      if (km_ > 0) {
        (void) _cscal (&km_, ($5_ = CMPLXF (1.0, 0.0) / ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &$5_), &ab_[kv_ + 2 - 1 + 
        ((*ldab_)) * ((j_ - 1))], &_k1);
        if (ju_ > j_) {
          (void) _cgeru (&km_, ($6_ = ju_ - j_, &$6_), ($7_ = CMPLXF (-1.0, 0.0), &$7_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * ((j_ - 
          1))], &_k1, &ab_[kv_ - 1 + ((*ldab_)) * ((j_ + 1 - 1))], ($8_ = (*ldab_) - 1, &$8_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * 
          ((j_ + 1 - 1))], ($9_ = (*ldab_) - 1, &$9_));
        }
      }
    }
    else {
      if ((*info_) == 0) {
        (*info_) = j_;
      }
    }
  }
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _cgbtrf (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_8 _p_ ab_, int_4 _p_ ldab_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_, i2_, i3_, ii_, ip_, j_, j2_, j3_, jb_, jj_, jm_, jp_, ju_, k2_, km_, kv_, nb_, nw_;
  static complex_8 temp_, work13_[4160], work31_[4160];
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $11_, $13_, $14_, $15_, $17_, $18_, $20_, $21_, $23_, $25_, 
  $26_, $28_, $30_, $31_, $33_, $34_, $36_, $38_, $39_, $41_, $42_, $43_, $44_, $45_, $46_, $47_;
  complex_8 $10_, $12_, $16_, $19_, $22_, $24_, $27_, $29_, $32_, $35_, $37_, $40_;
  extern int_4 _icamax ();
  extern int_4 _ilaenv ();
  extern int_4 _ccopy ();
  extern int_4 _cgemm ();
  extern int_4 _cgeru ();
  extern int_4 _cscal ();
  extern int_4 _cswap ();
  extern int_4 _ctrsm ();
  extern int_4 _xerbla ();
  kv_ = (*ku_) + (*kl_);
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldab_) < (*kl_) + kv_ + 1) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_1, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  nb_ = _ilaenv (&_k1, _dc_1, _dc_2, m_, n_, kl_, ku_);
  nb_ = _min (nb_, 64);
  if (nb_ <= 1 || nb_ > (*kl_)) {
    (void) _cgbtf2 (m_, n_, kl_, ku_, ab_, ldab_, ipiv_, info_);
  }
  else {
    for (j_ = 1; j_ <= nb_; (j_)++) {
      for (i_ = 1; i_ <= j_ - 1; (i_)++) {
        work13_[i_ - 1 + (65) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
      }
    }
    for (j_ = 1; j_ <= nb_; (j_)++) {
      for (i_ = j_ + 1; i_ <= nb_; (i_)++) {
        work31_[i_ - 1 + (65) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
      }
    }
    for (j_ = (*ku_) + 2; j_ <= _min (kv_, (*n_)); (j_)++) {
      for (i_ = kv_ - j_ + 2; i_ <= (*kl_); (i_)++) {
        ab_[i_ - 1 + ((*ldab_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
      }
    }
    ju_ = 1;
    for (j_ = 1; (nb_ > 0 ? j_ <= _min ((*m_), (*n_)) : j_ >= _min ((*m_), (*n_))); j_ += nb_) {
      jb_ = _min (nb_, _min ((*m_), (*n_)) - j_ + 1);
      i2_ = _min ((*kl_) - jb_, (*m_) - j_ - jb_ + 1);
      i3_ = _min (jb_, (*m_) - j_ - (*kl_) + 1);
      for (jj_ = j_; jj_ <= j_ + jb_ - 1; (jj_)++) {
        if (jj_ + kv_ <= (*n_)) {
          for (i_ = 1; i_ <= (*kl_); (i_)++) {
            ab_[i_ - 1 + ((*ldab_)) * ((jj_ + kv_ - 1))] = CMPLXF (0.0, 0.0);
          }
        }
        km_ = _min ((*kl_), (*m_) - jj_);
        jp_ = _icamax (($1_ = km_ + 1, &$1_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], &_k1);
        ipiv_[jj_ - 1] = jp_ + jj_ - j_;
        if (ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((jj_ - 1))] != CMPLXF (0.0, 0.0)) {
          ju_ = _max (ju_, _min (jj_ + (*ku_) + jp_ - 1, (*n_)));
          if (jp_ != 1) {
            if (jp_ + jj_ - 1 < j_ + (*kl_)) {
              (void) _cswap (&jb_, &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($2_ = (*ldab_) - 1, &$2_), &ab_[kv_ + jp_ 
              + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($3_ = (*ldab_) - 1, &$3_));
            }
            else {
              (void) _cswap (($4_ = jj_ - j_, &$4_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($5_ = (*ldab_) - 1, 
              &$5_), &work31_[jp_ + jj_ - j_ - (*kl_) - 1], ($6_ = 65, &$6_));
              (void) _cswap (($7_ = j_ + jb_ - jj_, &$7_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], ($8_ = (*ldab_) - 1, &$8_), 
              &ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((jj_ - 1))], ($9_ = (*ldab_) - 1, &$9_));
            }
          }
          (void) _cscal (&km_, ($10_ = CMPLXF (1.0, 0.0) / ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], &$10_), &ab_[kv_ + 2 - 1 
          + ((*ldab_)) * ((jj_ - 1))], &_k1);
          jm_ = _min (ju_, j_ + jb_ - 1);
          if (jm_ > jj_) {
            (void) _cgeru (&km_, ($11_ = jm_ - jj_, &$11_), ($12_ = CMPLXF (-1.0, 0.0), &$12_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * 
            ((jj_ - 1))], &_k1, &ab_[kv_ - 1 + ((*ldab_)) * ((jj_ + 1 - 1))], ($13_ = (*ldab_) - 1, &$13_), &ab_[kv_ + 1 - 1 + 
            ((*ldab_)) * ((jj_ + 1 - 1))], ($14_ = (*ldab_) - 1, &$14_));
          }
        }
        else {
          if ((*info_) == 0) {
            (*info_) = jj_;
          }
        }
        nw_ = _min (jj_ - j_ + 1, i3_);
        if (nw_ > 0) {
          (void) _ccopy (&nw_, &ab_[kv_ + (*kl_) + 1 - jj_ + j_ - 1 + ((*ldab_)) * ((jj_ - 1))], &_k1, &work31_[0 + (65) * ((jj_ 
          - j_ + 1 - 1))], &_k1);
        }
      }
      if (j_ + jb_ <= (*n_)) {
        j2_ = _min (ju_ - j_ + 1, kv_) - jb_;
        j3_ = _max (0, ju_ - j_ - kv_ + 1);
        (void) _claswp (&j2_, &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($15_ = (*ldab_) - 1, &$15_), &_k1, 
        &jb_, &ipiv_[j_ - 1], &_k1);
        for (i_ = j_; i_ <= j_ + jb_ - 1; (i_)++) {
          ipiv_[i_ - 1] = ipiv_[i_ - 1] + j_ - 1;
        }
        k2_ = j_ - 1 + jb_ + j2_;
        for (i_ = 1; i_ <= j3_; (i_)++) {
          jj_ = k2_ + i_;
          for (ii_ = j_ + i_ - 1; ii_ <= j_ + jb_ - 1; (ii_)++) {
            ip_ = ipiv_[ii_ - 1];
            if (ip_ != ii_) {
              temp_ = ab_[kv_ + 1 + ii_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))];
              ab_[kv_ + 1 + ii_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))] = ab_[kv_ + 1 + ip_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))];
              ab_[kv_ + 1 + ip_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))] = temp_;
            }
          }
        }
        if (j2_ > 0) {
          (void) _ctrsm (_dc_3, _dc_4, _dc_5, _dc_6, &jb_, &j2_, ($16_ = CMPLXF (1.0, 0.0), &$16_), &ab_[kv_ + 1 - 1 + ((*ldab_)) 
          * ((j_ - 1))], ($17_ = (*ldab_) - 1, &$17_), &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($18_ = (*ldab_) 
          - 1, &$18_));
          if (i2_ > 0) {
            (void) _cgemm (_dc_5, _dc_5, &i2_, &j2_, &jb_, ($19_ = CMPLXF (-1.0, 0.0), &$19_), &ab_[kv_ + 1 + jb_ - 1 + ((*ldab_)) 
            * ((j_ - 1))], ($20_ = (*ldab_) - 1, &$20_), &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($21_ = (*ldab_) 
            - 1, &$21_), ($22_ = CMPLXF (1.0, 0.0), &$22_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($23_ = (*ldab_) - 
            1, &$23_));
          }
          if (i3_ > 0) {
            (void) _cgemm (_dc_5, _dc_5, &i3_, &j2_, &jb_, ($24_ = CMPLXF (-1.0, 0.0), &$24_), work31_, ($25_ = 65, &$25_), 
            &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($26_ = (*ldab_) - 1, &$26_), ($27_ = CMPLXF (1.0, 0.0), 
            &$27_), &ab_[kv_ + (*kl_) + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($28_ = (*ldab_) - 1, &$28_));
          }
        }
        if (j3_ > 0) {
          for (jj_ = 1; jj_ <= j3_; (jj_)++) {
            for (ii_ = jj_; ii_ <= jb_; (ii_)++) {
              work13_[ii_ - 1 + (65) * ((jj_ - 1))] = ab_[ii_ - jj_ + 1 - 1 + ((*ldab_)) * ((jj_ + j_ + kv_ - 1 - 1))];
            }
          }
          (void) _ctrsm (_dc_3, _dc_4, _dc_5, _dc_6, &jb_, &j3_, ($29_ = CMPLXF (1.0, 0.0), &$29_), &ab_[kv_ + 1 - 1 + ((*ldab_)) 
          * ((j_ - 1))], ($30_ = (*ldab_) - 1, &$30_), work13_, ($31_ = 65, &$31_));
          if (i2_ > 0) {
            (void) _cgemm (_dc_5, _dc_5, &i2_, &j3_, &jb_, ($32_ = CMPLXF (-1.0, 0.0), &$32_), &ab_[kv_ + 1 + jb_ - 1 + ((*ldab_)) 
            * ((j_ - 1))], ($33_ = (*ldab_) - 1, &$33_), work13_, ($34_ = 65, &$34_), ($35_ = CMPLXF (1.0, 0.0), &$35_), &ab_[1 + 
            jb_ - 1 + ((*ldab_)) * ((j_ + kv_ - 1))], ($36_ = (*ldab_) - 1, &$36_));
          }
          if (i3_ > 0) {
            (void) _cgemm (_dc_5, _dc_5, &i3_, &j3_, &jb_, ($37_ = CMPLXF (-1.0, 0.0), &$37_), work31_, ($38_ = 65, &$38_), 
            work13_, ($39_ = 65, &$39_), ($40_ = CMPLXF (1.0, 0.0), &$40_), &ab_[1 + (*kl_) - 1 + ((*ldab_)) * ((j_ + kv_ - 1))], 
            ($41_ = (*ldab_) - 1, &$41_));
          }
          for (jj_ = 1; jj_ <= j3_; (jj_)++) {
            for (ii_ = jj_; ii_ <= jb_; (ii_)++) {
              ab_[ii_ - jj_ + 1 - 1 + ((*ldab_)) * ((jj_ + j_ + kv_ - 1 - 1))] = work13_[ii_ - 1 + (65) * ((jj_ - 1))];
            }
          }
        }
      }
      else {
        for (i_ = j_; i_ <= j_ + jb_ - 1; (i_)++) {
          ipiv_[i_ - 1] = ipiv_[i_ - 1] + j_ - 1;
        }
      }
      for (jj_ = j_ + jb_ - 1; jj_ >= j_; (jj_)--) {
        jp_ = ipiv_[jj_ - 1] - jj_ + 1;
        if (jp_ != 1) {
          if (jp_ + jj_ - 1 < j_ + (*kl_)) {
            (void) _cswap (($42_ = jj_ - j_, &$42_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($43_ = (*ldab_) - 1, 
            &$43_), &ab_[kv_ + jp_ + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($44_ = (*ldab_) - 1, &$44_));
          }
          else {
            (void) _cswap (($45_ = jj_ - j_, &$45_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($46_ = (*ldab_) - 1, 
            &$46_), &work31_[jp_ + jj_ - j_ - (*kl_) - 1], ($47_ = 65, &$47_));
          }
        }
        nw_ = _min (i3_, jj_ - j_ + 1);
        if (nw_ > 0) {
          (void) _ccopy (&nw_, &work31_[0 + (65) * ((jj_ - j_ + 1 - 1))], &_k1, &ab_[kv_ + (*kl_) + 1 - jj_ + j_ - 1 + ((*ldab_)) 
          * ((jj_ - 1))], &_k1);
        }
      }
    }
  }
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _cgbtrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, int_4 _p_ nrhs_, complex_8 _p_ ab_, int_4 
_p_ ldab_, int_4 _p_ ipiv_, complex_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_)
{
  static int_4 i_, j_, kd_, l_, lm_;
  static logical_4 lnoti_, notran_;
  int_4 $0_, $2_, $3_, $6_;
  complex_8 $1_, $4_, $5_, $7_, $8_;
  extern logical_4 _lsame ();
  extern int_4 _cgemv ();
  extern int_4 _cgeru ();
  extern int_4 _cswap ();
  extern int_4 _ctbsv ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  notran_ = _lsame (trans_, _dc_7);
  if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -5;
  }
  else if ((*ldab_) < (2 * (*kl_) + (*ku_) + 1)) {
    (*info_) = -7;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_10, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*nrhs_) == 0) {
    goto _l0;
  }
  kd_ = (*ku_) + (*kl_) + 1;
  lnoti_ = (*kl_) > 0;
  if (notran_) {
    if (lnoti_) {
      for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
        lm_ = _min ((*kl_), (*n_) - j_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _cswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
        (void) _cgeru (&lm_, nrhs_, ($1_ = CMPLXF (-1.0, 0.0), &$1_), &ab_[kd_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, &b_[j_ 
        - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_);
      }
    }
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _ctbsv (_dc_11, _dc_5, _dc_12, n_, ($2_ = (*kl_) + (*ku_), &$2_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
  }
  else if (_lsame (trans_, _dc_8)) {
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _ctbsv (_dc_11, _dc_13, _dc_12, n_, ($3_ = (*kl_) + (*ku_), &$3_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
    if (lnoti_) {
      for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
        lm_ = _min ((*kl_), (*n_) - j_);
        (void) _cgemv (_dc_13, &lm_, nrhs_, ($4_ = CMPLXF (-1.0, 0.0), &$4_), &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_, 
        &ab_[kd_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, ($5_ = CMPLXF (1.0, 0.0), &$5_), &b_[j_ - 1 + ((*ldb_)) * ((0))], 
        ldb_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _cswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
      }
    }
  }
  else {
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _ctbsv (_dc_11, _dc_14, _dc_12, n_, ($6_ = (*kl_) + (*ku_), &$6_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
    if (lnoti_) {
      for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
        lm_ = _min ((*kl_), (*n_) - j_);
        (void) _clacgv (nrhs_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        (void) _cgemv (_dc_14, &lm_, nrhs_, ($7_ = CMPLXF (-1.0, 0.0), &$7_), &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_, 
        &ab_[kd_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, ($8_ = CMPLXF (1.0, 0.0), &$8_), &b_[j_ - 1 + ((*ldb_)) * ((0))], 
        ldb_);
        (void) _clacgv (nrhs_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _cswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
      }
    }
  }
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _cgeqr2 (int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ tau_, complex_8 _p_ work_, 
int_4 _p_ info_)
{
  static int_4 i_, k_;
  static complex_8 alpha_;
  int_4 $0_, $1_, $2_, $3_;
  complex_8 $4_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_15, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  k_ = _min ((*m_), (*n_));
  for (i_ = 1; i_ <= k_; (i_)++) {
    (void) _clarfg (($1_ = (*m_) - i_ + 1, &$1_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[_min (i_ + 1, (*m_)) - 1 + 
    ((*lda_)) * ((i_ - 1))], &_k1, &tau_[i_ - 1]);
    if (i_ < (*n_)) {
      alpha_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = CMPLXF (1.0, 0.0);
      (void) _clarf (_dc_3, ($2_ = (*m_) - i_ + 1, &$2_), ($3_ = (*n_) - i_, &$3_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
      &_k1, ($4_ = conjf (tau_[i_ - 1]), &$4_), &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, work_);
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = alpha_;
    }
  }
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _cgttrf (int_4 _p_ n_, complex_8 _p_ dl_, complex_8 _p_ d_, complex_8 _p_ du_, complex_8 _p_ du2_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_;
  static complex_8 fact_, temp_, zdum_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
    (void) _xerbla (_dc_16, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ipiv_[i_ - 1] = i_;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (dl_[i_ - 1] == CMPLXF (0.0, 0.0)) {
      if (d_[i_ - 1] == CMPLXF (0.0, 0.0) && (*info_) == 0) {
        (*info_) = i_;
      }
      if (i_ < (*n_) - 1) {
        du2_[i_ - 1] = CMPLXF (0.0, 0.0);
      }
    }
    else if (({complex_8 zdum__1_ = d_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) >= 
    ({complex_8 zdum__1_ = dl_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
    fact_ = dl_[i_ - 1] / d_[i_ - 1];
    dl_[i_ - 1] = fact_;
    d_[i_ + 1 - 1] = d_[i_ + 1 - 1] - fact_ * du_[i_ - 1];
    if (i_ < (*n_) - 1) {
      du2_[i_ - 1] = CMPLXF (0.0, 0.0);
    }
  }
  else {
    fact_ = d_[i_ - 1] / dl_[i_ - 1];
    d_[i_ - 1] = dl_[i_ - 1];
    dl_[i_ - 1] = fact_;
    temp_ = du_[i_ - 1];
    du_[i_ - 1] = d_[i_ + 1 - 1];
    d_[i_ + 1 - 1] = temp_ - fact_ * d_[i_ + 1 - 1];
    if (i_ < (*n_) - 1) {
      du2_[i_ - 1] = du_[i_ + 1 - 1];
      du_[i_ + 1 - 1] = -fact_ * du_[i_ + 1 - 1];
    }
    ipiv_[i_ - 1] = ipiv_[i_ - 1] + 1;
  }
}

if (d_[(*n_) - 1] == CMPLXF (0.0, 0.0) && (*info_) == 0) {
  (*info_) = (*n_);
  goto _l0;
}

_l0:;
__calls[4].calls++;
return 0;
}

int_4 _cgttrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, complex_8 _p_ dl_, complex_8 _p_ d_, complex_8 _p_ du_, 
complex_8 _p_ du2_, int_4 _p_ ipiv_, complex_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_)
{
  static int_4 i_, j_;
  static logical_4 notran_;
  static complex_8 temp_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  notran_ = _lsame (trans_, _dc_7);
  if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -3;
  }
  else if ((*ldb_) < _max ((*n_), 1)) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_17, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*nrhs_) == 0) {
    goto _l0;
  }
  if (notran_) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * b_[i_ - 1 + ((*ldb_)) 
          * ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ - dl_[i_ - 1] * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] / d_[(*n_) - 1];
      if ((*n_) > 1) {
        b_[(*n_) - 1 - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[(*n_) - 1 - 1 + ((*ldb_)) * ((j_ - 1))] - du_[(*n_) - 1 - 1] * 
        b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[(*n_) - 1 - 1];
      }
      for (i_ = (*n_) - 2; i_ >= 1; (i_)--) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1] * b_[i_ + 1 - 1 + ((*ldb_)) * 
        ((j_ - 1))] - du2_[i_ - 1] * b_[i_ + 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[i_ - 1];
      }
    }
  }
  else if (_lsame (trans_, _dc_8)) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / d_[0];
      if ((*n_) > 1) {
        b_[1 + ((*ldb_)) * ((j_ - 1))] = (b_[1 + ((*ldb_)) * ((j_ - 1))] - du_[0] * b_[0 + ((*ldb_)) * ((j_ - 1))]) / d_[1];
      }
      for (i_ = 3; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1 - 1] * b_[i_ - 1 - 1 + 
        ((*ldb_)) * ((j_ - 1))] - du2_[i_ - 2 - 1] * b_[i_ - 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[i_ - 1];
      }
      for (i_ = (*n_) - 1; i_ >= 1; (i_)--) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * b_[i_ + 1 - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * temp_;
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / conjf (d_[0]);
      if ((*n_) > 1) {
        b_[1 + ((*ldb_)) * ((j_ - 1))] = (b_[1 + ((*ldb_)) * ((j_ - 1))] - conjf (du_[0]) * b_[0 + ((*ldb_)) * ((j_ - 1))]) / 
        conjf (d_[1]);
      }
      for (i_ = 3; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - conjf (du_[i_ - 1 - 1]) * b_[i_ - 1 - 1 + 
        ((*ldb_)) * ((j_ - 1))] - conjf (du2_[i_ - 2 - 1]) * b_[i_ - 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / conjf (d_[i_ - 1]);
      }
      for (i_ = (*n_) - 1; i_ >= 1; (i_)--) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - conjf (dl_[i_ - 1]) * b_[i_ + 1 - 1 + 
          ((*ldb_)) * ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - conjf (dl_[i_ - 1]) * temp_;
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
        }
      }
    }
  }
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _clacgv (int_4 _p_ n_, complex_8 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, ioff_;
  if ((*incx_) == 1) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[i_ - 1] = conjf (x_[i_ - 1]);
    }
  }
  else {
    ioff_ = 1;
    if ((*incx_) < 0) {
      ioff_ = 1 - ((*n_) - 1) * (*incx_);
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[ioff_ - 1] = conjf (x_[ioff_ - 1]);
      ioff_ = ioff_ + (*incx_);
    }
  }
  __calls[6].calls++;
  return 0;
}

int_4 _clacon (int_4 _p_ n_, complex_8 _p_ v_, complex_8 _p_ x_, real_4 _p_ est_, int_4 _p_ kase_)
{
  static int_4 i_, iter_, j_, jlast_, jump_;
  static real_4 altsgn_, estold_, safmin_, temp_;
  extern int_4 _ccopy ();
  safmin_ = _slamch (_dc_18);
  if ((*kase_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[i_ - 1] = (complex_8) (1.0 / (real_4) ((*n_)));
    }
    (*kase_) = 1;
    jump_ = 1;
    goto _l0;
  }
  switch (jump_) {
    default:
    case 1: goto _l20;
    case 2: goto _l40;
    case 3: goto _l70;
    case 4: goto _l90;
    case 5: goto _l120;
  }
  _l20:;
  if ((*n_) == 1) {
    v_[0] = x_[0];
    (*est_) = cabsf (v_[0]);
    goto _l130;
  }
  (*est_) = _scsum1 (n_, x_, &_k1);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (cabsf (x_[i_ - 1]) > safmin_) {
      x_[i_ - 1] = x_[i_ - 1] / (complex_8) (cabsf (x_[i_ - 1]));
    }
    else {
      x_[i_ - 1] = CMPLXF (1.0, 0.0);
    }
  }
  (*kase_) = 2;
  jump_ = 2;
  goto _l0;
  _l40:;
  j_ = _icmax1 (n_, x_, &_k1);
  iter_ = 2;
  _l50:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = CMPLXF (0.0, 0.0);
  }
  x_[j_ - 1] = CMPLXF (1.0, 0.0);
  (*kase_) = 1;
  jump_ = 3;
  goto _l0;
  _l70:;
  (void) _ccopy (n_, x_, &_k1, v_, &_k1);
  estold_ = (*est_);
  (*est_) = _scsum1 (n_, v_, &_k1);
  if ((*est_) <= estold_) {
    goto _l100;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (cabsf (x_[i_ - 1]) > safmin_) {
      x_[i_ - 1] = x_[i_ - 1] / (complex_8) (cabsf (x_[i_ - 1]));
    }
    else {
      x_[i_ - 1] = CMPLXF (1.0, 0.0);
    }
  }
  (*kase_) = 2;
  jump_ = 4;
  goto _l0;
  _l90:;
  jlast_ = j_;
  j_ = _icmax1 (n_, x_, &_k1);
  if (((real_4) (crealf (x_[jlast_ - 1])) != _abs ((real_4) (crealf (x_[j_ - 1])))) && (iter_ < 5)) {
    iter_ = iter_ + 1;
    goto _l50;
  }
  _l100:;
  altsgn_ = 1.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = (complex_8) (altsgn_ * (1.0 + (real_4) (i_ - 1) / (real_4) ((*n_) - 1)));
    altsgn_ = -altsgn_;
  }
  (*kase_) = 1;
  jump_ = 5;
  goto _l0;
  _l120:;
  temp_ = 2.0 * (_scsum1 (n_, x_, &_k1) / (real_4) (3 * (*n_)));
  if (temp_ > (*est_)) {
    (void) _ccopy (n_, x_, &_k1, v_, &_k1);
    (*est_) = temp_;
  }
  _l130:;
  (*kase_) = 0;
  _l0:;
  __calls[7].calls++;
  return 0;
}
int_4 _clacpy (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, complex_8 _p_ b_, int_4 
_p_ ldb_)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if (_lsame (uplo_, _dc_19)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_, (*m_)); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  else if (_lsame (uplo_, _dc_20)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  __calls[8].calls++;
  return 0;
}

complex_8 _cladiv (complex_8 _p_ x_, complex_8 _p_ y_)
{
  static real_4 zi_, zr_;
  real_4 $0_, $1_, $2_, $3_;
  complex_8 cladiv_;
  (void) _sladiv (($0_ = (real_4) (crealf ((*x_))), &$0_), ($1_ = cimagf ((*x_)), &$1_), ($2_ = (real_4) (crealf 
  ((*y_))), &$2_), ($3_ = cimagf ((*y_)), &$3_), &zr_, &zi_);
  cladiv_ = CMPLXF (zr_, zi_);
  __calls[9].calls++;
  return cladiv_;
}

int_4 _clahqr (logical_4 _p_ wantt_, logical_4 _p_ wantz_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, complex_8 _p_ 
h_, int_4 _p_ ldh_, complex_8 _p_ w_, int_4 _p_ iloz_, int_4 _p_ ihiz_, complex_8 _p_ z_, int_4 _p_ ldz_, int_4 _p_ 
info_)
{
  static int_4 i_, i1_, i2_, itn_, its_, j_, k_, l_, m_, nh_, nz_;
  static real_4 h10_, h21_, rtemp_, s_, smlnum_, t2_, tst1_, ulp_, rwork_[1];
  static complex_8 cdum_, h11_, h11s_, h22_, sum_, t_, t1_, temp_, u_, v2_, x_, y_, v_[2];
  int_4 $0_, $2_, $3_, $4_, $5_, $8_, $10_;
  complex_8 $1_, $6_, $7_, $9_;
  extern int_4 _ccopy ();
  extern int_4 _cscal ();
  (*info_) = 0;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*ilo_) == (*ihi_)) {
    w_[(*ilo_) - 1] = h_[(*ilo_) - 1 + ((*ldh_)) * (((*ilo_) - 1))];
    goto _l0;
  }
  nh_ = (*ihi_) - (*ilo_) + 1;
  nz_ = (*ihiz_) - (*iloz_) + 1;
  ulp_ = _slamch (_dc_21);
  smlnum_ = _slamch (_dc_18) / ulp_;
  if ((*wantt_)) {
    i1_ = 1;
    i2_ = (*n_);
  }
  itn_ = 30 * nh_;
  i_ = (*ihi_);
  _l10:;
  if (i_ < (*ilo_)) {
    goto _l130;
  }
  l_ = (*ilo_);
  for (its_ = 0; its_ <= itn_; (its_)++) {
    for (k_ = i_; k_ >= l_ + 1; (k_)--) {
      tst1_ = ({complex_8 cdum__1_ = h_[k_ - 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))]; _abs ((real_4) (crealf (cdum__1_))) + _abs 
      (cimagf (cdum__1_));}) + ({complex_8 cdum__1_ = h_[k_ - 1 + ((*ldh_)) * ((k_ - 1))]; _abs ((real_4) (crealf 
      (cdum__1_))) + _abs (cimagf (cdum__1_));});
      if (tst1_ == 0.0) {
        tst1_ = _clanhs (_dc_22, ($0_ = i_ - l_ + 1, &$0_), &h_[l_ - 1 + ((*ldh_)) * ((l_ - 1))], ldh_, rwork_);
      }
      if (_abs ((real_4) (crealf (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))]))) <= _max (ulp_ * tst1_, smlnum_)) {
        goto _l30;
      }
    }
    _l30:;
    l_ = k_;
    if (l_ > (*ilo_)) {
      h_[l_ - 1 + ((*ldh_)) * ((l_ - 1 - 1))] = CMPLXF (0.0, 0.0);
    }
    if (l_ >= i_) {
      goto _l120;
    }
    if (! ((*wantt_))) {
      i1_ = l_;
      i2_ = i_;
    }
    if (its_ == 10 || its_ == 20) {
      t_ = _abs ((real_4) (crealf (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))]))) + _abs ((real_4) (crealf (h_[i_ - 1 - 1 + 
      ((*ldh_)) * ((i_ - 2 - 1))])));
    }
    else {
      t_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
      u_ = h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))] * (real_4) (crealf (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))]));
      if (u_ != CMPLXF (0.0, 0.0)) {
        x_ = 0.5 * (h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] - t_);
        y_ = csqrtf (x_ * x_ + u_);
        if ((real_4) (crealf (x_)) * (real_4) (crealf (y_)) + cimagf (x_) * cimagf (y_) < 0.0) {
          y_ = -y_;
        }
        t_ = t_ - _cladiv (&u_, ($1_ = (x_ + y_), &$1_));
      }
    }
    for (m_ = i_ - 1; m_ >= l_ + 1; (m_)--) {
      h11_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1))];
      h22_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h11s_ = h11_ - t_;
      h21_ = (real_4) (crealf (h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))]));
      s_ = ({complex_8 cdum__1_ = h11s_; _abs ((real_4) (crealf (cdum__1_))) + _abs (cimagf (cdum__1_));}) + _abs (h21_);
      h11s_ = h11s_ / s_;
      h21_ = h21_ / s_;
      v_[0] = h11s_;
      v_[1] = h21_;
      h10_ = (real_4) (crealf (h_[m_ - 1 + ((*ldh_)) * ((m_ - 1 - 1))]));
      tst1_ = ({complex_8 cdum__1_ = h11s_; _abs ((real_4) (crealf (cdum__1_))) + _abs (cimagf (cdum__1_));}) * (({complex_8 
      cdum__1_ = h11_; _abs ((real_4) (crealf (cdum__1_))) + _abs (cimagf (cdum__1_));}) + ({complex_8 cdum__1_ = h22_; _abs 
      ((real_4) (crealf (cdum__1_))) + _abs (cimagf (cdum__1_));}));
      if (_abs (h10_ * h21_) <= ulp_ * tst1_) {
        goto _l50;
      }
    }
    h11_ = h_[l_ - 1 + ((*ldh_)) * ((l_ - 1))];
    h22_ = h_[l_ + 1 - 1 + ((*ldh_)) * ((l_ + 1 - 1))];
    h11s_ = h11_ - t_;
    h21_ = (real_4) (crealf (h_[l_ + 1 - 1 + ((*ldh_)) * ((l_ - 1))]));
    s_ = ({complex_8 cdum__1_ = h11s_; _abs ((real_4) (crealf (cdum__1_))) + _abs (cimagf (cdum__1_));}) + _abs (h21_);
    h11s_ = h11s_ / s_;
    h21_ = h21_ / s_;
    v_[0] = h11s_;
    v_[1] = h21_;
    _l50:;
    for (k_ = m_; k_ <= i_ - 1; (k_)++) {
      if (k_ > m_) {
        (void) _ccopy (($2_ = 2, &$2_), &h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))], &_k1, v_, &_k1);
      }
      (void) _clarfg (($3_ = 2, &$3_), &v_[0], &v_[1], &_k1, &t1_);
      if (k_ > m_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = v_[0];
        h_[k_ + 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = CMPLXF (0.0, 0.0);
      }
      v2_ = v_[1];
      t2_ = (real_4) (crealf (t1_ * v2_));
      for (j_ = k_; j_ <= i2_; (j_)++) {
        sum_ = conjf (t1_) * h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + t2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
        h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_;
        h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * v2_;
      }
      for (j_ = i1_; j_ <= _min (k_ + 2, i_); (j_)++) {
        sum_ = t1_ * h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + t2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))];
        h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_;
        h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * conjf (v2_);
      }
      if ((*wantz_)) {
        for (j_ = (*iloz_); j_ <= (*ihiz_); (j_)++) {
          sum_ = t1_ * z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] + t2_ * z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))];
          z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] - sum_;
          z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] - sum_ * conjf (v2_);
        }
      }
      if (k_ == m_ && m_ > l_) {
        temp_ = CMPLXF (1.0, 0.0) - t1_;
        temp_ = temp_ / cabsf (temp_);
        h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))] = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))] * conjf (temp_);
        if (m_ + 2 <= i_) {
          h_[m_ + 2 - 1 + ((*ldh_)) * ((m_ + 1 - 1))] = h_[m_ + 2 - 1 + ((*ldh_)) * ((m_ + 1 - 1))] * temp_;
        }
        for (j_ = m_; j_ <= i_; (j_)++) {
          if (j_ != m_ + 1) {
            if (i2_ > j_) {
              (void) _cscal (($4_ = i2_ - j_, &$4_), &temp_, &h_[j_ - 1 + ((*ldh_)) * ((j_ + 1 - 1))], ldh_);
            }
            (void) _cscal (($5_ = j_ - i1_, &$5_), ($6_ = conjf (temp_), &$6_), &h_[i1_ - 1 + ((*ldh_)) * ((j_ - 1))], &_k1);
            if ((*wantz_)) {
              (void) _cscal (&nz_, ($7_ = conjf (temp_), &$7_), &z_[(*iloz_) - 1 + ((*ldz_)) * ((j_ - 1))], &_k1);
            }
          }
        }
      }
    }
    temp_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))];
    if (cimagf (temp_) != 0.0) {
      rtemp_ = cabsf (temp_);
      h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = rtemp_;
      temp_ = temp_ / rtemp_;
      if (i2_ > i_) {
        (void) _cscal (($8_ = i2_ - i_, &$8_), ($9_ = conjf (temp_), &$9_), &h_[i_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))], ldh_);
      }
      (void) _cscal (($10_ = i_ - i1_, &$10_), &temp_, &h_[i1_ - 1 + ((*ldh_)) * ((i_ - 1))], &_k1);
      if ((*wantz_)) {
        (void) _cscal (&nz_, &temp_, &z_[(*iloz_) - 1 + ((*ldz_)) * ((i_ - 1))], &_k1);
      }
    }
  }
  (*info_) = i_;
  goto _l0;
  _l120:;
  w_[i_ - 1] = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
  itn_ = itn_ - its_;
  i_ = l_ - 1;
  goto _l10;
  _l130:;
  _l0:;
  __calls[10].calls++;
  return 0;
}

real_4 _clange (char _p_ norm_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, real_4 _p_ work_)
{
  static int_4 i_, j_;
  static real_4 scale_, sum_, value_;
  real_4 clange_;
  extern logical_4 _lsame ();
  if (_min ((*m_), (*n_)) == 0) {
    value_ = 0.0;
  }
  else if (_lsame (norm_, _dc_23)) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        value_ = _max (value_, cabsf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]));
      }
    }
  }
  else if ((_lsame (norm_, _dc_24)) || ((strcmp (norm_, _dc_22) == 0))) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = 0.0;
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        sum_ = sum_ + cabsf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
      value_ = _max (value_, sum_);
    }
  }
  else if (_lsame (norm_, _dc_25)) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        work_[i_ - 1] = work_[i_ - 1] + cabsf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
    }
    value_ = 0.0;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      value_ = _max (value_, work_[i_ - 1]);
    }
  }
  else if ((_lsame (norm_, _dc_26)) || (_lsame (norm_, _dc_27))) {
    scale_ = 0.0;
    sum_ = 1.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _classq (m_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &scale_, &sum_);
    }
    value_ = scale_ * sqrtf (sum_);
  }
  clange_ = value_;
  __calls[11].calls++;
  return clange_;
}

real_4 _clanhs (char _p_ norm_, int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, real_4 _p_ work_)
{
  static int_4 i_, j_;
  static real_4 scale_, sum_, value_;
  int_4 $0_;
  real_4 clanhs_;
  extern logical_4 _lsame ();
  if ((*n_) == 0) {
    value_ = 0.0;
  }
  else if (_lsame (norm_, _dc_23)) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        value_ = _max (value_, cabsf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]));
      }
    }
  }
  else if ((_lsame (norm_, _dc_24)) || ((strcmp (norm_, _dc_22) == 0))) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = 0.0;
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        sum_ = sum_ + cabsf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
      value_ = _max (value_, sum_);
    }
  }
  else if (_lsame (norm_, _dc_25)) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        work_[i_ - 1] = work_[i_ - 1] + cabsf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
    }
    value_ = 0.0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      value_ = _max (value_, work_[i_ - 1]);
    }
  }
  else if ((_lsame (norm_, _dc_26)) || (_lsame (norm_, _dc_27))) {
    scale_ = 0.0;
    sum_ = 1.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _classq (($0_ = _min ((*n_), j_ + 1), &$0_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &scale_, &sum_);
    }
    value_ = scale_ * sqrtf (sum_);
  }
  clanhs_ = value_;
  __calls[12].calls++;
  return clanhs_;
}

int_4 _clarf (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ incv_, complex_8 _p_ tau_, 
complex_8 _p_ c_, int_4 _p_ ldc_, complex_8 _p_ work_)
{
  complex_8 $0_, $1_, $2_, $3_, $4_, $5_;
  extern int_4 _cgemv ();
  extern int_4 _cgerc ();
  extern logical_4 _lsame ();
  if (_lsame (side_, _dc_20)) {
    if ((*tau_) != CMPLXF (0.0, 0.0)) {
      (void) _cgemv (_dc_14, m_, n_, ($0_ = CMPLXF (1.0, 0.0), &$0_), c_, ldc_, v_, incv_, ($1_ = CMPLXF (0.0, 0.0), &$1_), 
      work_, &_k1);
      (void) _cgerc (m_, n_, ($2_ = -(*tau_), &$2_), v_, incv_, work_, &_k1, c_, ldc_);
    }
  }
  else {
    if ((*tau_) != CMPLXF (0.0, 0.0)) {
      (void) _cgemv (_dc_5, m_, n_, ($3_ = CMPLXF (1.0, 0.0), &$3_), c_, ldc_, v_, incv_, ($4_ = CMPLXF (0.0, 0.0), &$4_), 
      work_, &_k1);
      (void) _cgerc (m_, n_, ($5_ = -(*tau_), &$5_), work_, &_k1, v_, incv_, c_, ldc_);
    }
  }
  __calls[13].calls++;
  return 0;
}

int_4 _clarfg (int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ x_, int_4 _p_ incx_, complex_8 _p_ tau_)
{
  static int_4 j_, knt_;
  static real_4 alphi_, alphr_, beta_, rsafmn_, safmin_, xnorm_;
  int_4 $0_, $1_, $2_, $5_, $8_;
  complex_8 $3_, $4_, $6_, $7_;
  extern real_4 _scnrm2 ();
  extern int_4 _cscal ();
  extern int_4 _csscal ();
  if ((*n_) <= 0) {
    (*tau_) = 0.0;
    goto _l0;
  }
  xnorm_ = _scnrm2 (($0_ = (*n_) - 1, &$0_), x_, incx_);
  alphr_ = (real_4) (crealf ((*alpha_)));
  alphi_ = cimagf ((*alpha_));
  if (xnorm_ == 0.0 && alphi_ == 0.0) {
    (*tau_) = 0.0;
  }
  else {
    beta_ = -_sign (_slapy3 (&alphr_, &alphi_, &xnorm_), alphr_);
    safmin_ = _slamch (_dc_28) / _slamch (_dc_27);
    rsafmn_ = 1.0 / safmin_;
    if (_abs (beta_) < safmin_) {
      knt_ = 0;
      _l10:;
      knt_ = knt_ + 1;
      (void) _csscal (($1_ = (*n_) - 1, &$1_), &rsafmn_, x_, incx_);
      beta_ = beta_ * rsafmn_;
      alphi_ = alphi_ * rsafmn_;
      alphr_ = alphr_ * rsafmn_;
      if (_abs (beta_) < safmin_) {
        goto _l10;
      }
      xnorm_ = _scnrm2 (($2_ = (*n_) - 1, &$2_), x_, incx_);
      (*alpha_) = CMPLXF (alphr_, alphi_);
      beta_ = -_sign (_slapy3 (&alphr_, &alphi_, &xnorm_), alphr_);
      (*tau_) = CMPLXF ((beta_ - alphr_) / beta_, -alphi_ / beta_);
      (*alpha_) = _cladiv (($3_ = (complex_8) (1.0), &$3_), ($4_ = (*alpha_) - beta_, &$4_));
      (void) _cscal (($5_ = (*n_) - 1, &$5_), alpha_, x_, incx_);
      (*alpha_) = beta_;
      for (j_ = 1; j_ <= knt_; (j_)++) {
        (*alpha_) = (*alpha_) * safmin_;
      }
    }
    else {
      (*tau_) = CMPLXF ((beta_ - alphr_) / beta_, -alphi_ / beta_);
      (*alpha_) = _cladiv (($6_ = (complex_8) (1.0), &$6_), ($7_ = (*alpha_) - beta_, &$7_));
      (void) _cscal (($8_ = (*n_) - 1, &$8_), alpha_, x_, incx_);
      (*alpha_) = beta_;
    }
  }
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _clarnv (int_4 _p_ idist_, int_4 _p_ iseed_, int_4 _p_ n_, complex_8 _p_ x_)
{
  static int_4 i_, il_, iv_;
  static real_4 u_[128];
  int_4 $0_;
  for (iv_ = 1; (64 > 0 ? iv_ <= (*n_) : iv_ >= (*n_)); iv_ += 64) {
    il_ = _min (64, (*n_) - iv_ + 1);
    (void) _slaruv (iseed_, ($0_ = 2 * il_, &$0_), u_);
    if ((*idist_) == 1) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = CMPLXF (u_[2 * i_ - 1 - 1], u_[2 * i_ - 1]);
      }
    }
    else if ((*idist_) == 2) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = CMPLXF (2.0 * u_[2 * i_ - 1 - 1] - 1.0, 2.0 * u_[2 * i_ - 1] - 1.0);
      }
    }
    else if ((*idist_) == 3) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = sqrtf (-2.0 * logf (u_[2 * i_ - 1 - 1])) * cexpf (CMPLXF (0.0, 6.2831853 * u_[2 * i_ - 1]));
      }
    }
    else if ((*idist_) == 4) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = sqrtf (u_[2 * i_ - 1 - 1]) * cexpf (CMPLXF (0.0, 6.2831853 * u_[2 * i_ - 1]));
      }
    }
    else if ((*idist_) == 5) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = cexpf (CMPLXF (0.0, 6.2831853 * u_[2 * i_ - 1]));
      }
    }
  }
  __calls[15].calls++;
  return 0;
}

int_4 _clartg (complex_8 _p_ f_, complex_8 _p_ g_, real_4 _p_ cs_, complex_8 _p_ sn_, complex_8 _p_ r_)
{
  static real_4 d_, di_, f1_, f2_, fa_, g1_, g2_, ga_;
  static complex_8 fs_, gs_, ss_, t_;
  real_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  if ((*g_) == CMPLXF (0.0, 0.0)) {
    (*cs_) = 1.0;
    (*sn_) = 0.0;
    (*r_) = (*f_);
  }
  else if ((*f_) == CMPLXF (0.0, 0.0)) {
    (*cs_) = 0.0;
    (*sn_) = conjf ((*g_)) / cabsf ((*g_));
    (*r_) = cabsf ((*g_));
  }
  else {
    f1_ = ({complex_8 t__1_ = (*f_); _abs ((real_4) (crealf (t__1_))) + _abs (cimagf (t__1_));});
    g1_ = ({complex_8 t__1_ = (*g_); _abs ((real_4) (crealf (t__1_))) + _abs (cimagf (t__1_));});
    if (f1_ >= g1_) {
      gs_ = (*g_) / f1_;
      g2_ = ({complex_8 t__1_ = gs_; ($0_ = (real_4) (crealf (t__1_)), $0_ * $0_) + ($1_ = cimagf (t__1_), $1_ * $1_);});
      fs_ = (*f_) / f1_;
      f2_ = ({complex_8 t__1_ = fs_; ($2_ = (real_4) (crealf (t__1_)), $2_ * $2_) + ($3_ = cimagf (t__1_), $3_ * $3_);});
      d_ = sqrtf (1.0 + g2_ / f2_);
      (*cs_) = 1.0 / d_;
      (*sn_) = conjf (gs_) * fs_ * ((*cs_) / f2_);
      (*r_) = (*f_) * d_;
    }
    else {
      fs_ = (*f_) / g1_;
      f2_ = ({complex_8 t__1_ = fs_; ($4_ = (real_4) (crealf (t__1_)), $4_ * $4_) + ($5_ = cimagf (t__1_), $5_ * $5_);});
      fa_ = sqrtf (f2_);
      gs_ = (*g_) / g1_;
      g2_ = ({complex_8 t__1_ = gs_; ($6_ = (real_4) (crealf (t__1_)), $6_ * $6_) + ($7_ = cimagf (t__1_), $7_ * $7_);});
      ga_ = sqrtf (g2_);
      d_ = sqrtf (1.0 + f2_ / g2_);
      di_ = 1.0 / d_;
      (*cs_) = (fa_ / ga_) * di_;
      ss_ = (conjf (gs_) * fs_) / (fa_ * ga_);
      (*sn_) = ss_ * di_;
      (*r_) = (*g_) * ss_ * d_;
    }
  }
  __calls[16].calls++;
  return 0;
}

int_4 _clascl (char _p_ type_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ cfrom_, real_4 _p_ cto_, int_4 _p_ m_, int_4 
_p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ info_)
{
  static int_4 i_, itype_, j_, k1_, k2_, k3_, k4_;
  static logical_4 done_;
  static real_4 bignum_, cfrom1_, cfromc_, cto1_, ctoc_, mul_, smlnum_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if (_lsame (type_, _dc_29)) {
    itype_ = 0;
  }
  else if (_lsame (type_, _dc_20)) {
    itype_ = 1;
  }
  else if (_lsame (type_, _dc_19)) {
    itype_ = 2;
  }
  else if (_lsame (type_, _dc_30)) {
    itype_ = 3;
  }
  else if (_lsame (type_, _dc_31)) {
    itype_ = 4;
  }
  else if (_lsame (type_, _dc_32)) {
    itype_ = 5;
  }
  else if (_lsame (type_, _dc_33)) {
    itype_ = 6;
  }
  else {
    itype_ = -1;
  }
  if (itype_ == -1) {
    (*info_) = -1;
  }
  else if ((*cfrom_) == 0.0) {
    (*info_) = -4;
  }
  else if ((*m_) < 0) {
    (*info_) = -6;
  }
  else if ((*n_) < 0 || (itype_ == 4 && (*n_) != (*m_)) || (itype_ == 5 && (*n_) != (*m_))) {
    (*info_) = -7;
  }
  else if (itype_ <= 3 && (*lda_) < _max (1, (*m_))) {
    (*info_) = -9;
  }
  else if (itype_ >= 4) {
    if ((*kl_) < 0 || (*kl_) > _max ((*m_) - 1, 0)) {
      (*info_) = -2;
    }
    else if ((*ku_) < 0 || (*ku_) > _max ((*n_) - 1, 0) || ((itype_ == 4 || itype_ == 5) && (*kl_) != (*ku_))) {
      (*info_) = -3;
    }
    else if ((itype_ == 4 && (*lda_) < (*kl_) + 1) || (itype_ == 5 && (*lda_) < (*ku_) + 1) || (itype_ == 6 && (*lda_) < 2 
      * (*kl_) + (*ku_) + 1)) {
      (*info_) = -9;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_34, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  smlnum_ = _slamch (_dc_28);
  bignum_ = 1.0 / smlnum_;
  cfromc_ = (*cfrom_);
  ctoc_ = (*cto_);
  _l10:;
  cfrom1_ = cfromc_ * smlnum_;
  cto1_ = ctoc_ / bignum_;
  if (_abs (cfrom1_) > _abs (ctoc_) && ctoc_ != 0.0) {
    mul_ = smlnum_;
    done_ = FALSE;
    cfromc_ = cfrom1_;
  }
  else if (_abs (cto1_) > _abs (cfromc_)) {
    mul_ = bignum_;
    done_ = FALSE;
    ctoc_ = cto1_;
  }
  else {
    mul_ = ctoc_ / cfromc_;
    done_ = TRUE;
  }
  if (itype_ == 0) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 2) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 3) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_ + 1, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 4) {
    k3_ = (*kl_) + 1;
    k4_ = (*n_) + 1;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (k3_, k4_ - j_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 5) {
    k1_ = (*ku_) + 2;
    k3_ = (*ku_) + 1;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = _max (k1_ - j_, 1); i_ <= k3_; (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 6) {
    k1_ = (*kl_) + (*ku_) + 2;
    k2_ = (*kl_) + 1;
    k3_ = 2 * (*kl_) + (*ku_) + 1;
    k4_ = (*kl_) + (*ku_) + 1 + (*m_);
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = _max (k1_ - j_, k2_); i_ <= _min (k3_, k4_ - j_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  if (! (done_)) {
    goto _l10;
  }
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _claset (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ alpha_, complex_8 _p_ beta_, complex_8 _p_ a_, 
int_4 _p_ lda_)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if (_lsame (uplo_, _dc_19)) {
    for (j_ = 2; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_ - 1, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
    for (i_ = 1; i_ <= _min ((*n_), (*m_)); (i_)++) {
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = (*beta_);
    }
  }
  else if (_lsame (uplo_, _dc_20)) {
    for (j_ = 1; j_ <= _min ((*m_), (*n_)); (j_)++) {
      for (i_ = j_ + 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
    for (i_ = 1; i_ <= _min ((*n_), (*m_)); (i_)++) {
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = (*beta_);
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
    for (i_ = 1; i_ <= _min ((*m_), (*n_)); (i_)++) {
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = (*beta_);
    }
  }
  __calls[18].calls++;
  return 0;
}

int_4 _classq (int_4 _p_ n_, complex_8 _p_ x_, int_4 _p_ incx_, real_4 _p_ scale_, real_4 _p_ sumsq_)
{
  static int_4 ix_;
  static real_4 temp1_;
  real_4 $0_, $1_, $2_, $3_;
  if ((*n_) > 0) {
    for (ix_ = 1; ((*incx_) > 0 ? ix_ <= 1 + ((*n_) - 1) * (*incx_) : ix_ >= 1 + ((*n_) - 1) * (*incx_)); ix_ += (*incx_)) 
      {
      if ((real_4) (crealf (x_[ix_ - 1])) != 0.0) {
        temp1_ = _abs ((real_4) (crealf (x_[ix_ - 1])));
        if ((*scale_) < temp1_) {
          (*sumsq_) = 1 + (*sumsq_) * ($0_ = ((*scale_) / temp1_), $0_ * $0_);
          (*scale_) = temp1_;
        }
        else {
          (*sumsq_) = (*sumsq_) + ($1_ = (temp1_ / (*scale_)), $1_ * $1_);
        }
      }
      if (cimagf (x_[ix_ - 1]) != 0.0) {
        temp1_ = _abs (cimagf (x_[ix_ - 1]));
        if ((*scale_) < temp1_) {
          (*sumsq_) = 1 + (*sumsq_) * ($2_ = ((*scale_) / temp1_), $2_ * $2_);
          (*scale_) = temp1_;
        }
        else {
          (*sumsq_) = (*sumsq_) + ($3_ = (temp1_ / (*scale_)), $3_ * $3_);
        }
      }
    }
  }
  __calls[19].calls++;
  return 0;
}

int_4 _claswp (int_4 _p_ n_, complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ k1_, int_4 _p_ k2_, int_4 _p_ ipiv_, int_4 _p_ 
incx_)
{
  static int_4 i_, ip_, ix_;
  extern int_4 _cswap ();
  if ((*incx_) == 0) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    ix_ = (*k1_);
  }
  else {
    ix_ = 1 + (1 - (*k2_)) * (*incx_);
  }
  if ((*incx_) == 1) {
    for (i_ = (*k1_); i_ <= (*k2_); (i_)++) {
      ip_ = ipiv_[i_ - 1];
      if (ip_ != i_) {
        (void) _cswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
    }
  }
  else if ((*incx_) > 1) {
    for (i_ = (*k1_); i_ <= (*k2_); (i_)++) {
      ip_ = ipiv_[ix_ - 1];
      if (ip_ != i_) {
        (void) _cswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
      ix_ = ix_ + (*incx_);
    }
  }
  else if ((*incx_) < 0) {
    for (i_ = (*k2_); i_ >= (*k1_); (i_)--) {
      ip_ = ipiv_[ix_ - 1];
      if (ip_ != i_) {
        (void) _cswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
      ix_ = ix_ + (*incx_);
    }
  }
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _clatrs (char _p_ uplo_, char _p_ trans_, char _p_ diag_, char _p_ normin_, int_4 _p_ n_, complex_8 _p_ a_, int_4 
_p_ lda_, complex_8 _p_ x_, real_4 _p_ scale_, real_4 _p_ cnorm_, int_4 _p_ info_)
{
  static int_4 i_, imax_, j_, jfirst_, jinc_, jlast_;
  static logical_4 notran_, nounit_, upper_;
  static real_4 bignum_, grow_, rec_, smlnum_, tjj_, tmax_, tscal_, xbnd_, xj_, xmax_;
  static complex_8 csumj_, tjjs_, uscal_, zdum_;
  int_4 $0_, $1_, $2_, $4_, $6_, $7_, $9_, $10_, $11_, $12_, $13_;
  real_4 $3_, $14_;
  complex_8 $5_, $8_;
  extern logical_4 _lsame ();
  extern int_4 _icamax ();
  extern int_4 _isamax ();
  extern real_4 _scasum ();
  extern complex_8 _cdotc ();
  extern complex_8 _cdotu ();
  extern int_4 _caxpy ();
  extern int_4 _csscal ();
  extern int_4 _ctrsv ();
  extern int_4 _sscal ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  upper_ = _lsame (uplo_, _dc_19);
  notran_ = _lsame (trans_, _dc_7);
  nounit_ = _lsame (diag_, _dc_7);
  if (! (upper_) && ! (_lsame (uplo_, _dc_20))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -2;
  }
  else if (! (nounit_) && ! (_lsame (diag_, _dc_19))) {
    (*info_) = -3;
  }
  else if (! (_lsame (normin_, _dc_35)) && ! (_lsame (normin_, _dc_7))) {
    (*info_) = -4;
  }
  else if ((*n_) < 0) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    (*info_) = -7;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_36, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  smlnum_ = _slamch (_dc_18);
  bignum_ = 1.0 / smlnum_;
  (void) _slabad (&smlnum_, &bignum_);
  smlnum_ = smlnum_ / _slamch (_dc_21);
  bignum_ = 1.0 / smlnum_;
  (*scale_) = 1.0;
  if (_lsame (normin_, _dc_7)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        cnorm_[j_ - 1] = _scasum (($1_ = j_ - 1, &$1_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
        cnorm_[j_ - 1] = _scasum (($2_ = (*n_) - j_, &$2_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
      }
      cnorm_[(*n_) - 1] = 0.0;
    }
  }
  imax_ = _isamax (n_, cnorm_, &_k1);
  tmax_ = cnorm_[imax_ - 1];
  if (tmax_ <= bignum_ * 0.5) {
    tscal_ = 1.0;
  }
  else {
    tscal_ = 0.5 / (smlnum_ * tmax_);
    (void) _sscal (n_, &tscal_, cnorm_, &_k1);
  }
  xmax_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    xmax_ = _max (xmax_, ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_)) / 2.0) + _abs (cimagf 
    (zdum__1_) / 2.0);}));
  }
  xbnd_ = xmax_;
  if (notran_) {
    if (upper_) {
      jfirst_ = (*n_);
      jlast_ = 1;
      jinc_ = -1;
    }
    else {
      jfirst_ = 1;
      jlast_ = (*n_);
      jinc_ = 1;
    }
    if (tscal_ != 1.0) {
      grow_ = 0.0;
      goto _l60;
    }
    if (nounit_) {
      grow_ = 0.5 / _max (xbnd_, smlnum_);
      xbnd_ = grow_;
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l60;
        }
        tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
        tjj_ = ({complex_8 zdum__1_ = tjjs_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
        if (tjj_ >= smlnum_) {
          xbnd_ = _min (xbnd_, _min (1.0, tjj_) * grow_);
        }
        else {
          xbnd_ = 0.0;
        }
        if (tjj_ + cnorm_[j_ - 1] >= smlnum_) {
          grow_ = grow_ * (tjj_ / (tjj_ + cnorm_[j_ - 1]));
        }
        else {
          grow_ = 0.0;
        }
      }
      grow_ = xbnd_;
    }
    else {
      grow_ = _min (1.0, 0.5 / _max (xbnd_, smlnum_));
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l60;
        }
        grow_ = grow_ * (1.0 / (1.0 + cnorm_[j_ - 1]));
      }
    }
    _l60:;
  }
  else {
    if (upper_) {
      jfirst_ = 1;
      jlast_ = (*n_);
      jinc_ = 1;
    }
    else {
      jfirst_ = (*n_);
      jlast_ = 1;
      jinc_ = -1;
    }
    if (tscal_ != 1.0) {
      grow_ = 0.0;
      goto _l90;
    }
    if (nounit_) {
      grow_ = 0.5 / _max (xbnd_, smlnum_);
      xbnd_ = grow_;
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l90;
        }
        xj_ = 1.0 + cnorm_[j_ - 1];
        grow_ = _min (grow_, xbnd_ / xj_);
        tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
        tjj_ = ({complex_8 zdum__1_ = tjjs_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
        if (tjj_ >= smlnum_) {
          if (xj_ > tjj_) {
            xbnd_ = xbnd_ * (tjj_ / xj_);
          }
        }
        else {
          xbnd_ = 0.0;
        }
      }
      grow_ = _min (grow_, xbnd_);
    }
    else {
      grow_ = _min (1.0, 0.5 / _max (xbnd_, smlnum_));
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l90;
        }
        xj_ = 1.0 + cnorm_[j_ - 1];
        grow_ = grow_ / xj_;
      }
    }
    _l90:;
  }
  if ((grow_ * tscal_) > smlnum_) {
    (void) _ctrsv (uplo_, trans_, diag_, n_, a_, lda_, x_, &_k1);
  }
  else {
    if (xmax_ > bignum_ * 0.5) {
      (*scale_) = (bignum_ * 0.5) / xmax_;
      (void) _csscal (n_, scale_, x_, &_k1);
      xmax_ = bignum_;
    }
    else {
      xmax_ = xmax_ * 2.0;
    }
    if (notran_) {
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        xj_ = ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
        if (nounit_) {
          tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
        }
        else {
          tjjs_ = tscal_;
          if (tscal_ == 1.0) {
            goto _l105;
          }
        }
        tjj_ = ({complex_8 zdum__1_ = tjjs_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
        if (tjj_ > smlnum_) {
          if (tjj_ < 1.0) {
            if (xj_ > tjj_ * bignum_) {
              rec_ = 1.0 / xj_;
              (void) _csscal (n_, &rec_, x_, &_k1);
              (*scale_) = (*scale_) * rec_;
              xmax_ = xmax_ * rec_;
            }
          }
          x_[j_ - 1] = _cladiv (&x_[j_ - 1], &tjjs_);
          xj_ = ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
        }
        else if (tjj_ > 0.0) {
          if (xj_ > tjj_ * bignum_) {
            rec_ = (tjj_ * bignum_) / xj_;
            if (cnorm_[j_ - 1] > 1.0) {
              rec_ = rec_ / cnorm_[j_ - 1];
            }
            (void) _csscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
            xmax_ = xmax_ * rec_;
          }
          x_[j_ - 1] = _cladiv (&x_[j_ - 1], &tjjs_);
          xj_ = ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
        }
        else {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            x_[i_ - 1] = 0.0;
          }
          x_[j_ - 1] = 1.0;
          xj_ = 1.0;
          (*scale_) = 0.0;
          xmax_ = 0.0;
        }
        _l105:;
        if (xj_ > 1.0) {
          rec_ = 1.0 / xj_;
          if (cnorm_[j_ - 1] > (bignum_ - xmax_) * rec_) {
            rec_ = rec_ * 0.5;
            (void) _csscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
          }
        }
        else if (xj_ * cnorm_[j_ - 1] > (bignum_ - xmax_)) {
          (void) _csscal (n_, ($3_ = 0.5, &$3_), x_, &_k1);
          (*scale_) = (*scale_) * 0.5;
        }
        if (upper_) {
          if (j_ > 1) {
            (void) _caxpy (($4_ = j_ - 1, &$4_), ($5_ = -x_[j_ - 1] * tscal_, &$5_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, x_, 
            &_k1);
            i_ = _icamax (($6_ = j_ - 1, &$6_), x_, &_k1);
            xmax_ = ({complex_8 zdum__1_ = x_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
          }
        }
        else {
          if (j_ < (*n_)) {
            (void) _caxpy (($7_ = (*n_) - j_, &$7_), ($8_ = -x_[j_ - 1] * tscal_, &$8_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], 
            &_k1, &x_[j_ + 1 - 1], &_k1);
            i_ = j_ + _icamax (($9_ = (*n_) - j_, &$9_), &x_[j_ + 1 - 1], &_k1);
            xmax_ = ({complex_8 zdum__1_ = x_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
          }
        }
      }
    }
    else if (_lsame (trans_, _dc_8)) {
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        xj_ = ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
        uscal_ = tscal_;
        rec_ = 1.0 / _max (xmax_, 1.0);
        if (cnorm_[j_ - 1] > (bignum_ - xj_) * rec_) {
          rec_ = rec_ * 0.5;
          if (nounit_) {
            tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
          }
          else {
            tjjs_ = tscal_;
          }
          tjj_ = ({complex_8 zdum__1_ = tjjs_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
          if (tjj_ > 1.0) {
            rec_ = _min (1.0, rec_ * tjj_);
            uscal_ = _cladiv (&uscal_, &tjjs_);
          }
          if (rec_ < 1.0) {
            (void) _csscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
            xmax_ = xmax_ * rec_;
          }
        }
        csumj_ = 0.0;
        if (uscal_ == (complex_8) (1.0)) {
          if (upper_) {
            csumj_ = _cdotu (($10_ = j_ - 1, &$10_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, x_, &_k1);
          }
          else if (j_ < (*n_)) {
            csumj_ = _cdotu (($11_ = (*n_) - j_, &$11_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1, &x_[j_ + 1 - 1], &_k1);
          }
        }
        else {
          if (upper_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              csumj_ = csumj_ + (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * uscal_) * x_[i_ - 1];
            }
          }
          else if (j_ < (*n_)) {
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              csumj_ = csumj_ + (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * uscal_) * x_[i_ - 1];
            }
          }
        }
        if (uscal_ == (complex_8) (tscal_)) {
          x_[j_ - 1] = x_[j_ - 1] - csumj_;
          xj_ = ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
          if (nounit_) {
            tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
          }
          else {
            tjjs_ = tscal_;
            if (tscal_ == 1.0) {
              goto _l145;
            }
          }
          tjj_ = ({complex_8 zdum__1_ = tjjs_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
          if (tjj_ > smlnum_) {
            if (tjj_ < 1.0) {
              if (xj_ > tjj_ * bignum_) {
                rec_ = 1.0 / xj_;
                (void) _csscal (n_, &rec_, x_, &_k1);
                (*scale_) = (*scale_) * rec_;
                xmax_ = xmax_ * rec_;
              }
            }
            x_[j_ - 1] = _cladiv (&x_[j_ - 1], &tjjs_);
          }
          else if (tjj_ > 0.0) {
            if (xj_ > tjj_ * bignum_) {
              rec_ = (tjj_ * bignum_) / xj_;
              (void) _csscal (n_, &rec_, x_, &_k1);
              (*scale_) = (*scale_) * rec_;
              xmax_ = xmax_ * rec_;
            }
            x_[j_ - 1] = _cladiv (&x_[j_ - 1], &tjjs_);
          }
          else {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = 0.0;
            }
            x_[j_ - 1] = 1.0;
            (*scale_) = 0.0;
            xmax_ = 0.0;
          }
          _l145:;
        }
        else {
          x_[j_ - 1] = _cladiv (&x_[j_ - 1], &tjjs_) - csumj_;
        }
        xmax_ = _max (xmax_, ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
        (zdum__1_));}));
      }
    }
    else {
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        xj_ = ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
        uscal_ = tscal_;
        rec_ = 1.0 / _max (xmax_, 1.0);
        if (cnorm_[j_ - 1] > (bignum_ - xj_) * rec_) {
          rec_ = rec_ * 0.5;
          if (nounit_) {
            tjjs_ = conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]) * tscal_;
          }
          else {
            tjjs_ = tscal_;
          }
          tjj_ = ({complex_8 zdum__1_ = tjjs_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
          if (tjj_ > 1.0) {
            rec_ = _min (1.0, rec_ * tjj_);
            uscal_ = _cladiv (&uscal_, &tjjs_);
          }
          if (rec_ < 1.0) {
            (void) _csscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
            xmax_ = xmax_ * rec_;
          }
        }
        csumj_ = 0.0;
        if (uscal_ == (complex_8) (1.0)) {
          if (upper_) {
            csumj_ = _cdotc (($12_ = j_ - 1, &$12_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, x_, &_k1);
          }
          else if (j_ < (*n_)) {
            csumj_ = _cdotc (($13_ = (*n_) - j_, &$13_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1, &x_[j_ + 1 - 1], &_k1);
          }
        }
        else {
          if (upper_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              csumj_ = csumj_ + (conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * uscal_) * x_[i_ - 1];
            }
          }
          else if (j_ < (*n_)) {
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              csumj_ = csumj_ + (conjf (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * uscal_) * x_[i_ - 1];
            }
          }
        }
        if (uscal_ == (complex_8) (tscal_)) {
          x_[j_ - 1] = x_[j_ - 1] - csumj_;
          xj_ = ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
          if (nounit_) {
            tjjs_ = conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]) * tscal_;
          }
          else {
            tjjs_ = tscal_;
            if (tscal_ == 1.0) {
              goto _l185;
            }
          }
          tjj_ = ({complex_8 zdum__1_ = tjjs_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
          if (tjj_ > smlnum_) {
            if (tjj_ < 1.0) {
              if (xj_ > tjj_ * bignum_) {
                rec_ = 1.0 / xj_;
                (void) _csscal (n_, &rec_, x_, &_k1);
                (*scale_) = (*scale_) * rec_;
                xmax_ = xmax_ * rec_;
              }
            }
            x_[j_ - 1] = _cladiv (&x_[j_ - 1], &tjjs_);
          }
          else if (tjj_ > 0.0) {
            if (xj_ > tjj_ * bignum_) {
              rec_ = (tjj_ * bignum_) / xj_;
              (void) _csscal (n_, &rec_, x_, &_k1);
              (*scale_) = (*scale_) * rec_;
              xmax_ = xmax_ * rec_;
            }
            x_[j_ - 1] = _cladiv (&x_[j_ - 1], &tjjs_);
          }
          else {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = 0.0;
            }
            x_[j_ - 1] = 1.0;
            (*scale_) = 0.0;
            xmax_ = 0.0;
          }
          _l185:;
        }
        else {
          x_[j_ - 1] = _cladiv (&x_[j_ - 1], &tjjs_) - csumj_;
        }
        xmax_ = _max (xmax_, ({complex_8 zdum__1_ = x_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
        (zdum__1_));}));
      }
    }
    (*scale_) = (*scale_) / tscal_;
  }
  if (tscal_ != 1.0) {
    (void) _sscal (n_, ($14_ = 1.0 / tscal_, &$14_), cnorm_, &_k1);
  }
  _l0:;
  __calls[21].calls++;
  return 0;
}

real_4 _cmach (int_4 _p_ job_)
{
  static real_4 eps_, tiny_, huge_, s_;
  real_4 cmach_;
  eps_ = 1.0;
  _l10:;
  eps_ = eps_ / 2.0;
  s_ = 1.0 + eps_;
  if (s_ > 1.0) {
    goto _l10;
  }
  eps_ = 2.0 * eps_;
  cmach_ = eps_;
  if ((*job_) == 1) {
    goto _l0;
  }
  s_ = 1.0;
  _l20:;
  tiny_ = s_;
  s_ = s_ / 16.0;
  if (s_ * 1.0 != 0.0) {
    goto _l20;
  }
  tiny_ = (tiny_ / eps_) * 100.0;
  s_ = (real_4) (crealf (CMPLXF (1.0, 0.0) / CMPLXF (tiny_, 0.0)));
  if (s_ != 1.0 / tiny_) {
    tiny_ = sqrtf (tiny_);
  }
  huge_ = 1.0 / tiny_;
  if ((*job_) == 1) {
    cmach_ = eps_;
  }
  if ((*job_) == 2) {
    cmach_ = tiny_;
  }
  if ((*job_) == 3) {
    cmach_ = huge_;
  }
  _l0:;
  __calls[22].calls++;
  return cmach_;
}

int_4 _crot (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_, complex_8 _p_ cy_, int_4 _p_ incy_, real_4 _p_ c_, 
complex_8 _p_ s_)
{
  static int_4 i_, ix_, iy_;
  static complex_8 stemp_;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = (*c_) * cx_[ix_ - 1] + (*s_) * cy_[iy_ - 1];
    cy_[iy_ - 1] = (*c_) * cy_[iy_ - 1] - conjf ((*s_)) * cx_[ix_ - 1];
    cx_[ix_ - 1] = stemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = (*c_) * cx_[i_ - 1] + (*s_) * cy_[i_ - 1];
    cy_[i_ - 1] = (*c_) * cy_[i_ - 1] - conjf ((*s_)) * cx_[i_ - 1];
    cx_[i_ - 1] = stemp_;
  }
  _l0:;
  __calls[23].calls++;
  return 0;
}

int_4 _ctrevc (char _p_ side_, char _p_ howmny_, logical_4 _p_ select_, int_4 _p_ n_, complex_8 _p_ t_, int_4 _p_ ldt_, 
complex_8 _p_ vl_, int_4 _p_ ldvl_, complex_8 _p_ vr_, int_4 _p_ ldvr_, int_4 _p_ mm_, int_4 _p_ m_, complex_8 _p_ 
work_, real_4 _p_ rwork_, int_4 _p_ info_)
{
  static int_4 i_, ii_, is_, j_, k_, ki_;
  static logical_4 allv_, bothv_, leftv_, over_, rightv_, somev_;
  static real_4 ovfl_, remax_, scale_, smin_, smlnum_, ulp_, unfl_;
  static complex_8 cdum_;
  int_4 $0_, $1_, $2_, $3_, $6_, $7_, $8_, $9_, $10_;
  complex_8 $4_, $5_, $11_, $12_;
  extern logical_4 _lsame ();
  extern int_4 _icamax ();
  extern real_4 _scasum ();
  extern int_4 _ccopy ();
  extern int_4 _cgemv ();
  extern int_4 _csscal ();
  extern int_4 _xerbla ();
  bothv_ = _lsame (side_, _dc_31);
  rightv_ = _lsame (side_, _dc_37) || bothv_;
  leftv_ = _lsame (side_, _dc_20) || bothv_;
  allv_ = _lsame (howmny_, _dc_38);
  over_ = _lsame (howmny_, _dc_31) || _lsame (howmny_, _dc_24);
  somev_ = _lsame (howmny_, _dc_28);
  if (somev_) {
    (*m_) = 0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (select_[j_ - 1]) {
        (*m_) = (*m_) + 1;
      }
    }
  }
  else {
    (*m_) = (*n_);
  }
  (*info_) = 0;
  if (! (rightv_) && ! (leftv_)) {
    (*info_) = -1;
  }
  else if (! (allv_) && ! (over_) && ! (somev_)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  else if ((*ldvl_) < 1 || (leftv_ && (*ldvl_) < (*n_))) {
    (*info_) = -8;
  }
  else if ((*ldvr_) < 1 || (rightv_ && (*ldvr_) < (*n_))) {
    (*info_) = -10;
  }
  else if ((*mm_) < (*m_)) {
    (*info_) = -11;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_39, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  unfl_ = _slamch (_dc_18);
  ovfl_ = 1.0 / unfl_;
  (void) _slabad (&unfl_, &ovfl_);
  ulp_ = _slamch (_dc_21);
  smlnum_ = unfl_ * ((*n_) / ulp_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    work_[i_ + (*n_) - 1] = t_[i_ - 1 + ((*ldt_)) * ((i_ - 1))];
  }
  rwork_[0] = 0.0;
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    rwork_[j_ - 1] = _scasum (($1_ = j_ - 1, &$1_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1);
  }
  if (rightv_) {
    is_ = (*m_);
    for (ki_ = (*n_); ki_ >= 1; (ki_)--) {
      if (somev_) {
        if (! (select_[ki_ - 1])) {
          goto _l80;
        }
      }
      smin_ = _max (ulp_ * (({complex_8 cdum__1_ = t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) 
      + _abs (cimagf (cdum__1_));})), smlnum_);
      work_[0] = CMPLXF (1.0, 0.0);
      for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
        work_[k_ - 1] = -t_[k_ - 1 + ((*ldt_)) * ((ki_ - 1))];
      }
      for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
        t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] - t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))];
        if (({complex_8 cdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) + _abs (cimagf 
        (cdum__1_));}) < smin_) {
        t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = smin_;
      }
    }
    if (ki_ > 1) {
      (void) _clatrs (_dc_11, _dc_5, _dc_12, _dc_35, ($2_ = ki_ - 1, &$2_), t_, ldt_, &work_[0], &scale_, rwork_, info_);
      work_[ki_ - 1] = scale_;
    }
    if (! (over_)) {
      (void) _ccopy (&ki_, &work_[0], &_k1, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
      ii_ = _icamax (&ki_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
      remax_ = 1.0 / ({complex_8 cdum__1_ = vr_[ii_ - 1 + ((*ldvr_)) * ((is_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) + 
      _abs (cimagf (cdum__1_));});
      (void) _csscal (&ki_, &remax_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
      for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
        vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1))] = CMPLXF (0.0, 0.0);
      }
    }
    else {
      if (ki_ > 1) {
        (void) _cgemv (_dc_7, n_, ($3_ = ki_ - 1, &$3_), ($4_ = CMPLXF (1.0, 0.0), &$4_), vr_, ldvr_, &work_[0], &_k1, ($5_ = 
        (complex_8) (scale_), &$5_), &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
      }
      ii_ = _icamax (n_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
      remax_ = 1.0 / ({complex_8 cdum__1_ = vr_[ii_ - 1 + ((*ldvr_)) * ((ki_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) + 
      _abs (cimagf (cdum__1_));});
      (void) _csscal (n_, &remax_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
    }
    for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
      t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = work_[k_ + (*n_) - 1];
    }
    is_ = is_ - 1;
    _l80:;
  }
}

if (leftv_) {
  is_ = 1;
  for (ki_ = 1; ki_ <= (*n_); (ki_)++) {
    if (somev_) {
      if (! (select_[ki_ - 1])) {
        goto _l130;
      }
    }
    smin_ = _max (ulp_ * (({complex_8 cdum__1_ = t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) 
    + _abs (cimagf (cdum__1_));})), smlnum_);
    work_[(*n_) - 1] = CMPLXF (1.0, 0.0);
    for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
      work_[k_ - 1] = -conjf (t_[ki_ - 1 + ((*ldt_)) * ((k_ - 1))]);
    }
    for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
      t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] - t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))];
      if (({complex_8 cdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) + _abs (cimagf 
      (cdum__1_));}) < smin_) {
      t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = smin_;
    }
  }
  if (ki_ < (*n_)) {
    (void) _clatrs (_dc_11, _dc_14, _dc_12, _dc_35, ($6_ = (*n_) - ki_, &$6_), &t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ + 1 - 
    1))], ldt_, &work_[ki_ + 1 - 1], &scale_, rwork_, info_);
    work_[ki_ - 1] = scale_;
  }
  if (! (over_)) {
    (void) _ccopy (($7_ = (*n_) - ki_ + 1, &$7_), &work_[ki_ - 1], &_k1, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1);
    ii_ = _icamax (($8_ = (*n_) - ki_ + 1, &$8_), &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1) + ki_ - 1;
    remax_ = 1.0 / ({complex_8 cdum__1_ = vl_[ii_ - 1 + ((*ldvl_)) * ((is_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) + 
    _abs (cimagf (cdum__1_));});
    (void) _csscal (($9_ = (*n_) - ki_ + 1, &$9_), &remax_, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1);
    for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
      vl_[k_ - 1 + ((*ldvl_)) * ((is_ - 1))] = CMPLXF (0.0, 0.0);
    }
  }
  else {
    if (ki_ < (*n_)) {
      (void) _cgemv (_dc_7, n_, ($10_ = (*n_) - ki_, &$10_), ($11_ = CMPLXF (1.0, 0.0), &$11_), &vl_[0 + ((*ldvl_)) * ((ki_ + 
      1 - 1))], ldvl_, &work_[ki_ + 1 - 1], &_k1, ($12_ = (complex_8) (scale_), &$12_), &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], 
      &_k1);
    }
    ii_ = _icamax (n_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
    remax_ = 1.0 / ({complex_8 cdum__1_ = vl_[ii_ - 1 + ((*ldvl_)) * ((ki_ - 1))]; _abs ((real_4) (crealf (cdum__1_))) + 
    _abs (cimagf (cdum__1_));});
    (void) _csscal (n_, &remax_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
  }
  for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
    t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = work_[k_ + (*n_) - 1];
  }
  is_ = is_ + 1;
  _l130:;
}

}

_l0:;
__calls[24].calls++;
return 0;
}

int_4 _ctrexc (char _p_ compq_, int_4 _p_ n_, complex_8 _p_ t_, int_4 _p_ ldt_, complex_8 _p_ q_, int_4 _p_ ldq_, int_4 
_p_ ifst_, int_4 _p_ ilst_, int_4 _p_ info_)
{
  static int_4 k_, m1_, m2_, m3_;
  static logical_4 wantq_;
  static real_4 cs_;
  static complex_8 sn_, t11_, t22_, temp_;
  int_4 $0_, $2_, $3_;
  complex_8 $1_, $4_, $5_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  wantq_ = _lsame (compq_, _dc_40);
  if (! (_lsame (compq_, _dc_7)) && ! (wantq_)) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -4;
  }
  else if ((*ldq_) < 1 || (wantq_ && (*ldq_) < _max (1, (*n_)))) {
    (*info_) = -6;
  }
  else if ((*ifst_) < 1 || (*ifst_) > (*n_)) {
    (*info_) = -7;
  }
  else if ((*ilst_) < 1 || (*ilst_) > (*n_)) {
    (*info_) = -8;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_41, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 1 || (*ifst_) == (*ilst_)) {
    goto _l0;
  }
  if ((*ifst_) < (*ilst_)) {
    m1_ = 0;
    m2_ = -1;
    m3_ = 1;
  }
  else {
    m1_ = -1;
    m2_ = 0;
    m3_ = -1;
  }
  for (k_ = (*ifst_) + m1_; (m3_ > 0 ? k_ <= (*ilst_) + m2_ : k_ >= (*ilst_) + m2_); k_ += m3_) {
    t11_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    t22_ = t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ + 1 - 1))];
    (void) _clartg (&t_[k_ - 1 + ((*ldt_)) * ((k_ + 1 - 1))], ($1_ = t22_ - t11_, &$1_), &cs_, &sn_, &temp_);
    if (k_ + 2 <= (*n_)) {
      (void) _crot (($2_ = (*n_) - k_ - 1, &$2_), &t_[k_ - 1 + ((*ldt_)) * ((k_ + 2 - 1))], ldt_, &t_[k_ + 1 - 1 + ((*ldt_)) 
      * ((k_ + 2 - 1))], ldt_, &cs_, &sn_);
    }
    (void) _crot (($3_ = k_ - 1, &$3_), &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[0 + ((*ldt_)) * ((k_ + 1 - 1))], &_k1, 
    &cs_, ($4_ = conjf (sn_), &$4_));
    t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = t22_;
    t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ + 1 - 1))] = t11_;
    if (wantq_) {
      (void) _crot (n_, &q_[0 + ((*ldq_)) * ((k_ - 1))], &_k1, &q_[0 + ((*ldq_)) * ((k_ + 1 - 1))], &_k1, &cs_, ($5_ = conjf 
      (sn_), &$5_));
    }
  }
  _l0:;
  __calls[25].calls++;
  return 0;
}

int_4 _ctrsen (char _p_ job_, char _p_ compq_, logical_4 _p_ select_, int_4 _p_ n_, complex_8 _p_ t_, int_4 _p_ ldt_, 
complex_8 _p_ q_, int_4 _p_ ldq_, complex_8 _p_ w_, int_4 _p_ m_, real_4 _p_ s_, real_4 _p_ sep_, complex_8 _p_ work_, 
int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 ierr_, k_, kase_, ks_, n1_, n2_, nn_;
  static logical_4 wantbh_, wantq_, wants_, wantsp_;
  static real_4 est_, rnorm_, scale_, rwork_[1];
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  wantbh_ = _lsame (job_, _dc_31);
  wants_ = _lsame (job_, _dc_27) || wantbh_;
  wantsp_ = _lsame (job_, _dc_40) || wantbh_;
  wantq_ = _lsame (compq_, _dc_40);
  (*m_) = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (select_[k_ - 1]) {
      (*m_) = (*m_) + 1;
    }
  }
  n1_ = (*m_);
  n2_ = (*n_) - (*m_);
  nn_ = n1_ * n2_;
  (*info_) = 0;
  if (! (_lsame (job_, _dc_7)) && ! (wants_) && ! (wantsp_)) {
    (*info_) = -1;
  }
  else if (! (_lsame (compq_, _dc_7)) && ! (wantq_)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  else if ((*ldq_) < 1 || (wantq_ && (*ldq_) < (*n_))) {
    (*info_) = -8;
  }
  else if ((*lwork_) < 1 || ((wants_ && ! (wantsp_)) && (*lwork_) < nn_) || (wantsp_ && (*lwork_) < 2 * nn_)) {
    (*info_) = -14;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_42, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == (*n_) || (*m_) == 0) {
    if (wants_) {
      (*s_) = 1.0;
    }
    if (wantsp_) {
      (*sep_) = _clange (_dc_22, n_, n_, t_, ldt_, rwork_);
    }
    goto _l40;
  }
  ks_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (select_[k_ - 1]) {
      ks_ = ks_ + 1;
      if (k_ != ks_) {
        (void) _ctrexc (compq_, n_, t_, ldt_, q_, ldq_, &k_, &ks_, &ierr_);
      }
    }
  }
  if (wants_) {
    (void) _clacpy (_dc_26, &n1_, &n2_, &t_[0 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, &n1_);
    (void) _ctrsyl (_dc_7, _dc_7, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
    &n1_, &scale_, &ierr_);
    rnorm_ = _clange (_dc_26, &n1_, &n2_, work_, &n1_, rwork_);
    if (rnorm_ == 0.0) {
      (*s_) = 1.0;
    }
    else {
      (*s_) = scale_ / (sqrtf (scale_ * scale_ / rnorm_ + rnorm_) * sqrtf (rnorm_));
    }
  }
  if (wantsp_) {
    est_ = 0.0;
    kase_ = 0;
    _l30:;
    (void) _clacon (&nn_, &work_[nn_ + 1 - 1], work_, &est_, &kase_);
    if (kase_ != 0) {
      if (kase_ == 1) {
        (void) _ctrsyl (_dc_7, _dc_7, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
        &n1_, &scale_, &ierr_);
      }
      else {
        (void) _ctrsyl (_dc_9, _dc_9, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
        &n1_, &scale_, &ierr_);
      }
      goto _l30;
    }
    (*sep_) = scale_ / est_;
  }
  _l40:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    w_[k_ - 1] = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
  }
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _ctrsyl (char _p_ trana_, char _p_ tranb_, int_4 _p_ isgn_, int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, int_4 
_p_ lda_, complex_8 _p_ b_, int_4 _p_ ldb_, complex_8 _p_ c_, int_4 _p_ ldc_, real_4 _p_ scale_, int_4 _p_ info_)
{
  static int_4 j_, k_, l_;
  static logical_4 notrna_, notrnb_;
  static real_4 bignum_, da11_, db_, eps_, scaloc_, sgn_, smin_, smlnum_, dum_[1];
  static complex_8 a11_, suml_, sumr_, vec_, x11_;
  int_4 $0_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  real_4 $1_;
  extern logical_4 _lsame ();
  extern complex_8 _cdotc ();
  extern complex_8 _cdotu ();
  extern int_4 _csscal ();
  extern int_4 _xerbla ();
  notrna_ = _lsame (trana_, _dc_7);
  notrnb_ = _lsame (tranb_, _dc_7);
  (*info_) = 0;
  if (! (notrna_) && ! (_lsame (trana_, _dc_8)) && ! (_lsame (trana_, _dc_9))) {
    (*info_) = -1;
  }
  else if (! (notrnb_) && ! (_lsame (tranb_, _dc_8)) && ! (_lsame (tranb_, _dc_9))) {
    (*info_) = -2;
  }
  else if ((*isgn_) != 1 && (*isgn_) != -1) {
    (*info_) = -3;
  }
  else if ((*m_) < 0) {
    (*info_) = -4;
  }
  else if ((*n_) < 0) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -7;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -11;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_43, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  eps_ = _slamch (_dc_44);
  smlnum_ = _slamch (_dc_28);
  bignum_ = 1.0 / smlnum_;
  (void) _slabad (&smlnum_, &bignum_);
  smlnum_ = smlnum_ * (real_4) ((*m_) * (*n_)) / eps_;
  bignum_ = 1.0 / smlnum_;
  smin_ = ($1_ = _max (smlnum_, eps_ * _clange (_dc_23, m_, m_, a_, lda_, dum_)), _max ($1_, eps_ * _clange (_dc_23, n_, 
  n_, b_, ldb_, dum_)));
  (*scale_) = 1.0;
  sgn_ = (*isgn_);
  if (notrna_ && notrnb_) {
    for (l_ = 1; l_ <= (*n_); (l_)++) {
      for (k_ = (*m_); k_ >= 1; (k_)--) {
        suml_ = _cdotu (($2_ = (*m_) - k_, &$2_), &a_[k_ - 1 + ((*lda_)) * ((_min (k_ + 1, (*m_)) - 1))], lda_, &c_[_min (k_ + 
        1, (*m_)) - 1 + ((*ldc_)) * ((l_ - 1))], &_k1);
        sumr_ = _cdotu (($3_ = l_ - 1, &$3_), &c_[k_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l_ - 1))], &_k1);
        vec_ = c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] - (suml_ + sgn_ * sumr_);
        scaloc_ = 1.0;
        a11_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + sgn_ * b_[l_ - 1 + ((*ldb_)) * ((l_ - 1))];
        da11_ = _abs ((real_4) (crealf (a11_))) + _abs (cimagf (a11_));
        if (da11_ <= smin_) {
          a11_ = smin_;
          da11_ = smin_;
          (*info_) = 1;
        }
        db_ = _abs ((real_4) (crealf (vec_))) + _abs (cimagf (vec_));
        if (da11_ < 1.0 && db_ > 1.0) {
          if (db_ > bignum_ * da11_) {
            scaloc_ = 1.0 / db_;
          }
        }
        x11_ = (vec_ * (complex_8) (scaloc_)) / a11_;
        if (scaloc_ != 1.0) {
          for (j_ = 1; j_ <= (*n_); (j_)++) {
            (void) _csscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
          }
          (*scale_) = (*scale_) * scaloc_;
        }
        c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] = x11_;
      }
    }
  }
  else if (! (notrna_) && notrnb_) {
    for (l_ = 1; l_ <= (*n_); (l_)++) {
      for (k_ = 1; k_ <= (*m_); (k_)++) {
        suml_ = _cdotc (($4_ = k_ - 1, &$4_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l_ - 1))], &_k1);
        sumr_ = _cdotu (($5_ = l_ - 1, &$5_), &c_[k_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l_ - 1))], &_k1);
        vec_ = c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] - (suml_ + sgn_ * sumr_);
        scaloc_ = 1.0;
        a11_ = conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) + sgn_ * b_[l_ - 1 + ((*ldb_)) * ((l_ - 1))];
        da11_ = _abs ((real_4) (crealf (a11_))) + _abs (cimagf (a11_));
        if (da11_ <= smin_) {
          a11_ = smin_;
          da11_ = smin_;
          (*info_) = 1;
        }
        db_ = _abs ((real_4) (crealf (vec_))) + _abs (cimagf (vec_));
        if (da11_ < 1.0 && db_ > 1.0) {
          if (db_ > bignum_ * da11_) {
            scaloc_ = 1.0 / db_;
          }
        }
        x11_ = (vec_ * (complex_8) (scaloc_)) / a11_;
        if (scaloc_ != 1.0) {
          for (j_ = 1; j_ <= (*n_); (j_)++) {
            (void) _csscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
          }
          (*scale_) = (*scale_) * scaloc_;
        }
        c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] = x11_;
      }
    }
  }
  else if (! (notrna_) && ! (notrnb_)) {
    for (l_ = (*n_); l_ >= 1; (l_)--) {
      for (k_ = 1; k_ <= (*m_); (k_)++) {
        suml_ = _cdotc (($6_ = k_ - 1, &$6_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l_ - 1))], &_k1);
        sumr_ = _cdotc (($7_ = (*n_) - l_, &$7_), &c_[k_ - 1 + ((*ldc_)) * ((_min (l_ + 1, (*n_)) - 1))], ldc_, &b_[l_ - 1 + 
        ((*ldb_)) * ((_min (l_ + 1, (*n_)) - 1))], ldb_);
        vec_ = c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] - (suml_ + sgn_ * conjf (sumr_));
        scaloc_ = 1.0;
        a11_ = conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + sgn_ * b_[l_ - 1 + ((*ldb_)) * ((l_ - 1))]);
        da11_ = _abs ((real_4) (crealf (a11_))) + _abs (cimagf (a11_));
        if (da11_ <= smin_) {
          a11_ = smin_;
          da11_ = smin_;
          (*info_) = 1;
        }
        db_ = _abs ((real_4) (crealf (vec_))) + _abs (cimagf (vec_));
        if (da11_ < 1.0 && db_ > 1.0) {
          if (db_ > bignum_ * da11_) {
            scaloc_ = 1.0 / db_;
          }
        }
        x11_ = (vec_ * (complex_8) (scaloc_)) / a11_;
        if (scaloc_ != 1.0) {
          for (j_ = 1; j_ <= (*n_); (j_)++) {
            (void) _csscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
          }
          (*scale_) = (*scale_) * scaloc_;
        }
        c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] = x11_;
      }
    }
  }
  else if (notrna_ && ! (notrnb_)) {
    for (l_ = (*n_); l_ >= 1; (l_)--) {
      for (k_ = (*m_); k_ >= 1; (k_)--) {
        suml_ = _cdotu (($8_ = (*m_) - k_, &$8_), &a_[k_ - 1 + ((*lda_)) * ((_min (k_ + 1, (*m_)) - 1))], lda_, &c_[_min (k_ + 
        1, (*m_)) - 1 + ((*ldc_)) * ((l_ - 1))], &_k1);
        sumr_ = _cdotc (($9_ = (*n_) - l_, &$9_), &c_[k_ - 1 + ((*ldc_)) * ((_min (l_ + 1, (*n_)) - 1))], ldc_, &b_[l_ - 1 + 
        ((*ldb_)) * ((_min (l_ + 1, (*n_)) - 1))], ldb_);
        vec_ = c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] - (suml_ + sgn_ * conjf (sumr_));
        scaloc_ = 1.0;
        a11_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + sgn_ * conjf (b_[l_ - 1 + ((*ldb_)) * ((l_ - 1))]);
        da11_ = _abs ((real_4) (crealf (a11_))) + _abs (cimagf (a11_));
        if (da11_ <= smin_) {
          a11_ = smin_;
          da11_ = smin_;
          (*info_) = 1;
        }
        db_ = _abs ((real_4) (crealf (vec_))) + _abs (cimagf (vec_));
        if (da11_ < 1.0 && db_ > 1.0) {
          if (db_ > bignum_ * da11_) {
            scaloc_ = 1.0 / db_;
          }
        }
        x11_ = (vec_ * (complex_8) (scaloc_)) / a11_;
        if (scaloc_ != 1.0) {
          for (j_ = 1; j_ <= (*n_); (j_)++) {
            (void) _csscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
          }
          (*scale_) = (*scale_) * scaloc_;
        }
        c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] = x11_;
      }
    }
  }
  _l0:;
  __calls[27].calls++;
  return 0;
}

int_4 _cunm2r (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ a_, int_4 _p_ 
lda_, complex_8 _p_ tau_, complex_8 _p_ c_, int_4 _p_ ldc_, complex_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, i3_, ic_, jc_, mi_, ni_, nq_;
  static logical_4 left_, notran_;
  static complex_8 aii_, taui_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  left_ = _lsame (side_, _dc_20);
  notran_ = _lsame (trans_, _dc_7);
  if (left_) {
    nq_ = (*m_);
  }
  else {
    nq_ = (*n_);
  }
  if (! (left_) && ! (_lsame (side_, _dc_37))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -2;
  }
  else if ((*m_) < 0) {
    (*info_) = -3;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*k_) < 0 || (*k_) > nq_) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, nq_)) {
    (*info_) = -7;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_45, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0 || (*k_) == 0) {
    goto _l0;
  }
  if ((left_ && ! (notran_) || ! (left_) && notran_)) {
    i1_ = 1;
    i2_ = (*k_);
    i3_ = 1;
  }
  else {
    i1_ = (*k_);
    i2_ = 1;
    i3_ = -1;
  }
  if (left_) {
    ni_ = (*n_);
    jc_ = 1;
  }
  else {
    mi_ = (*m_);
    ic_ = 1;
  }
  for (i_ = i1_; (i3_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += i3_) {
    if (left_) {
      mi_ = (*m_) - i_ + 1;
      ic_ = i_;
    }
    else {
      ni_ = (*n_) - i_ + 1;
      jc_ = i_;
    }
    if (notran_) {
      taui_ = tau_[i_ - 1];
    }
    else {
      taui_ = conjf (tau_[i_ - 1]);
    }
    aii_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = CMPLXF (1.0, 0.0);
    (void) _clarf (side_, &mi_, &ni_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1, &taui_, &c_[ic_ - 1 + ((*ldc_)) * ((jc_ - 
    1))], ldc_, work_);
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
  }
  _l0:;
  __calls[28].calls++;
  return 0;
}

int_4 _dgbtf2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ ab_, int_4 _p_ ldab_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_, j_, jp_, ju_, km_, kv_;
  int_4 $0_, $1_, $2_, $3_, $4_, $6_, $8_, $9_;
  real_8 $5_, $7_;
  extern int_4 _idamax ();
  extern int_4 _dger ();
  extern int_4 _dscal ();
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  kv_ = (*ku_) + (*kl_);
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldab_) < (*kl_) + kv_ + 1) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_46, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  for (j_ = (*ku_) + 2; j_ <= _min (kv_, (*n_)); (j_)++) {
    for (i_ = kv_ - j_ + 2; i_ <= (*kl_); (i_)++) {
      ab_[i_ - 1 + ((*ldab_)) * ((j_ - 1))] = 0.0;
    }
  }
  ju_ = 1;
  for (j_ = 1; j_ <= _min ((*m_), (*n_)); (j_)++) {
    if (j_ + kv_ <= (*n_)) {
      for (i_ = 1; i_ <= (*kl_); (i_)++) {
        ab_[i_ - 1 + ((*ldab_)) * ((j_ + kv_ - 1))] = 0.0;
      }
    }
    km_ = _min ((*kl_), (*m_) - j_);
    jp_ = _idamax (($1_ = km_ + 1, &$1_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1);
    ipiv_[j_ - 1] = jp_ + j_ - 1;
    if (ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((j_ - 1))] != 0.0) {
      ju_ = _max (ju_, _min (j_ + (*ku_) + jp_ - 1, (*n_)));
      if (jp_ != 1) {
        (void) _dswap (($2_ = ju_ - j_ + 1, &$2_), &ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((j_ - 1))], ($3_ = (*ldab_) - 1, &$3_), 
        &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], ($4_ = (*ldab_) - 1, &$4_));
      }
      if (km_ > 0) {
        (void) _dscal (&km_, ($5_ = 1.0 / ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &$5_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * 
        ((j_ - 1))], &_k1);
        if (ju_ > j_) {
          (void) _dger (&km_, ($6_ = ju_ - j_, &$6_), ($7_ = -1.0, &$7_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, 
          &ab_[kv_ - 1 + ((*ldab_)) * ((j_ + 1 - 1))], ($8_ = (*ldab_) - 1, &$8_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ + 1 - 
          1))], ($9_ = (*ldab_) - 1, &$9_));
        }
      }
    }
    else {
      if ((*info_) == 0) {
        (*info_) = j_;
      }
    }
  }
  _l0:;
  __calls[29].calls++;
  return 0;
}

int_4 _dgbtrf (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ ab_, int_4 _p_ ldab_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_, i2_, i3_, ii_, ip_, j_, j2_, j3_, jb_, jj_, jm_, jp_, ju_, k2_, km_, kv_, nb_, nw_;
  static real_8 temp_, work13_[4160], work31_[4160];
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $11_, $13_, $14_, $15_, $17_, $18_, $20_, $21_, $23_, $25_, 
  $26_, $28_, $30_, $31_, $33_, $34_, $36_, $38_, $39_, $41_, $42_, $43_, $44_, $45_, $46_, $47_;
  real_8 $10_, $12_, $16_, $19_, $22_, $24_, $27_, $29_, $32_, $35_, $37_, $40_;
  extern int_4 _idamax ();
  extern int_4 _ilaenv ();
  extern int_4 _dcopy ();
  extern int_4 _dgemm ();
  extern int_4 _dger ();
  extern int_4 _dlaswp ();
  extern int_4 _dscal ();
  extern int_4 _dswap ();
  extern int_4 _dtrsm ();
  extern int_4 _xerbla ();
  kv_ = (*ku_) + (*kl_);
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldab_) < (*kl_) + kv_ + 1) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_47, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  nb_ = _ilaenv (&_k1, _dc_47, _dc_2, m_, n_, kl_, ku_);
  nb_ = _min (nb_, 64);
  if (nb_ <= 1 || nb_ > (*kl_)) {
    (void) _dgbtf2 (m_, n_, kl_, ku_, ab_, ldab_, ipiv_, info_);
  }
  else {
    for (j_ = 1; j_ <= nb_; (j_)++) {
      for (i_ = 1; i_ <= j_ - 1; (i_)++) {
        work13_[i_ - 1 + (65) * ((j_ - 1))] = 0.0;
      }
    }
    for (j_ = 1; j_ <= nb_; (j_)++) {
      for (i_ = j_ + 1; i_ <= nb_; (i_)++) {
        work31_[i_ - 1 + (65) * ((j_ - 1))] = 0.0;
      }
    }
    for (j_ = (*ku_) + 2; j_ <= _min (kv_, (*n_)); (j_)++) {
      for (i_ = kv_ - j_ + 2; i_ <= (*kl_); (i_)++) {
        ab_[i_ - 1 + ((*ldab_)) * ((j_ - 1))] = 0.0;
      }
    }
    ju_ = 1;
    for (j_ = 1; (nb_ > 0 ? j_ <= _min ((*m_), (*n_)) : j_ >= _min ((*m_), (*n_))); j_ += nb_) {
      jb_ = _min (nb_, _min ((*m_), (*n_)) - j_ + 1);
      i2_ = _min ((*kl_) - jb_, (*m_) - j_ - jb_ + 1);
      i3_ = _min (jb_, (*m_) - j_ - (*kl_) + 1);
      for (jj_ = j_; jj_ <= j_ + jb_ - 1; (jj_)++) {
        if (jj_ + kv_ <= (*n_)) {
          for (i_ = 1; i_ <= (*kl_); (i_)++) {
            ab_[i_ - 1 + ((*ldab_)) * ((jj_ + kv_ - 1))] = 0.0;
          }
        }
        km_ = _min ((*kl_), (*m_) - jj_);
        jp_ = _idamax (($1_ = km_ + 1, &$1_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], &_k1);
        ipiv_[jj_ - 1] = jp_ + jj_ - j_;
        if (ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((jj_ - 1))] != 0.0) {
          ju_ = _max (ju_, _min (jj_ + (*ku_) + jp_ - 1, (*n_)));
          if (jp_ != 1) {
            if (jp_ + jj_ - 1 < j_ + (*kl_)) {
              (void) _dswap (&jb_, &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($2_ = (*ldab_) - 1, &$2_), &ab_[kv_ + jp_ 
              + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($3_ = (*ldab_) - 1, &$3_));
            }
            else {
              (void) _dswap (($4_ = jj_ - j_, &$4_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($5_ = (*ldab_) - 1, 
              &$5_), &work31_[jp_ + jj_ - j_ - (*kl_) - 1], ($6_ = 65, &$6_));
              (void) _dswap (($7_ = j_ + jb_ - jj_, &$7_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], ($8_ = (*ldab_) - 1, &$8_), 
              &ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((jj_ - 1))], ($9_ = (*ldab_) - 1, &$9_));
            }
          }
          (void) _dscal (&km_, ($10_ = 1.0 / ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], &$10_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * 
          ((jj_ - 1))], &_k1);
          jm_ = _min (ju_, j_ + jb_ - 1);
          if (jm_ > jj_) {
            (void) _dger (&km_, ($11_ = jm_ - jj_, &$11_), ($12_ = -1.0, &$12_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * ((jj_ - 1))], 
            &_k1, &ab_[kv_ - 1 + ((*ldab_)) * ((jj_ + 1 - 1))], ($13_ = (*ldab_) - 1, &$13_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ 
            + 1 - 1))], ($14_ = (*ldab_) - 1, &$14_));
          }
        }
        else {
          if ((*info_) == 0) {
            (*info_) = jj_;
          }
        }
        nw_ = _min (jj_ - j_ + 1, i3_);
        if (nw_ > 0) {
          (void) _dcopy (&nw_, &ab_[kv_ + (*kl_) + 1 - jj_ + j_ - 1 + ((*ldab_)) * ((jj_ - 1))], &_k1, &work31_[0 + (65) * ((jj_ 
          - j_ + 1 - 1))], &_k1);
        }
      }
      if (j_ + jb_ <= (*n_)) {
        j2_ = _min (ju_ - j_ + 1, kv_) - jb_;
        j3_ = _max (0, ju_ - j_ - kv_ + 1);
        (void) _dlaswp (&j2_, &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($15_ = (*ldab_) - 1, &$15_), &_k1, 
        &jb_, &ipiv_[j_ - 1], &_k1);
        for (i_ = j_; i_ <= j_ + jb_ - 1; (i_)++) {
          ipiv_[i_ - 1] = ipiv_[i_ - 1] + j_ - 1;
        }
        k2_ = j_ - 1 + jb_ + j2_;
        for (i_ = 1; i_ <= j3_; (i_)++) {
          jj_ = k2_ + i_;
          for (ii_ = j_ + i_ - 1; ii_ <= j_ + jb_ - 1; (ii_)++) {
            ip_ = ipiv_[ii_ - 1];
            if (ip_ != ii_) {
              temp_ = ab_[kv_ + 1 + ii_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))];
              ab_[kv_ + 1 + ii_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))] = ab_[kv_ + 1 + ip_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))];
              ab_[kv_ + 1 + ip_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))] = temp_;
            }
          }
        }
        if (j2_ > 0) {
          (void) _dtrsm (_dc_3, _dc_4, _dc_5, _dc_6, &jb_, &j2_, ($16_ = 1.0, &$16_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 
          1))], ($17_ = (*ldab_) - 1, &$17_), &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($18_ = (*ldab_) - 1, 
          &$18_));
          if (i2_ > 0) {
            (void) _dgemm (_dc_5, _dc_5, &i2_, &j2_, &jb_, ($19_ = -1.0, &$19_), &ab_[kv_ + 1 + jb_ - 1 + ((*ldab_)) * ((j_ - 1))], 
            ($20_ = (*ldab_) - 1, &$20_), &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($21_ = (*ldab_) - 1, &$21_), 
            ($22_ = 1.0, &$22_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($23_ = (*ldab_) - 1, &$23_));
          }
          if (i3_ > 0) {
            (void) _dgemm (_dc_5, _dc_5, &i3_, &j2_, &jb_, ($24_ = -1.0, &$24_), work31_, ($25_ = 65, &$25_), &ab_[kv_ + 1 - jb_ - 
            1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($26_ = (*ldab_) - 1, &$26_), ($27_ = 1.0, &$27_), &ab_[kv_ + (*kl_) + 1 - jb_ - 1 
            + ((*ldab_)) * ((j_ + jb_ - 1))], ($28_ = (*ldab_) - 1, &$28_));
          }
        }
        if (j3_ > 0) {
          for (jj_ = 1; jj_ <= j3_; (jj_)++) {
            for (ii_ = jj_; ii_ <= jb_; (ii_)++) {
              work13_[ii_ - 1 + (65) * ((jj_ - 1))] = ab_[ii_ - jj_ + 1 - 1 + ((*ldab_)) * ((jj_ + j_ + kv_ - 1 - 1))];
            }
          }
          (void) _dtrsm (_dc_3, _dc_4, _dc_5, _dc_6, &jb_, &j3_, ($29_ = 1.0, &$29_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 
          1))], ($30_ = (*ldab_) - 1, &$30_), work13_, ($31_ = 65, &$31_));
          if (i2_ > 0) {
            (void) _dgemm (_dc_5, _dc_5, &i2_, &j3_, &jb_, ($32_ = -1.0, &$32_), &ab_[kv_ + 1 + jb_ - 1 + ((*ldab_)) * ((j_ - 1))], 
            ($33_ = (*ldab_) - 1, &$33_), work13_, ($34_ = 65, &$34_), ($35_ = 1.0, &$35_), &ab_[1 + jb_ - 1 + ((*ldab_)) * ((j_ + 
            kv_ - 1))], ($36_ = (*ldab_) - 1, &$36_));
          }
          if (i3_ > 0) {
            (void) _dgemm (_dc_5, _dc_5, &i3_, &j3_, &jb_, ($37_ = -1.0, &$37_), work31_, ($38_ = 65, &$38_), work13_, ($39_ = 65, 
            &$39_), ($40_ = 1.0, &$40_), &ab_[1 + (*kl_) - 1 + ((*ldab_)) * ((j_ + kv_ - 1))], ($41_ = (*ldab_) - 1, &$41_));
          }
          for (jj_ = 1; jj_ <= j3_; (jj_)++) {
            for (ii_ = jj_; ii_ <= jb_; (ii_)++) {
              ab_[ii_ - jj_ + 1 - 1 + ((*ldab_)) * ((jj_ + j_ + kv_ - 1 - 1))] = work13_[ii_ - 1 + (65) * ((jj_ - 1))];
            }
          }
        }
      }
      else {
        for (i_ = j_; i_ <= j_ + jb_ - 1; (i_)++) {
          ipiv_[i_ - 1] = ipiv_[i_ - 1] + j_ - 1;
        }
      }
      for (jj_ = j_ + jb_ - 1; jj_ >= j_; (jj_)--) {
        jp_ = ipiv_[jj_ - 1] - jj_ + 1;
        if (jp_ != 1) {
          if (jp_ + jj_ - 1 < j_ + (*kl_)) {
            (void) _dswap (($42_ = jj_ - j_, &$42_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($43_ = (*ldab_) - 1, 
            &$43_), &ab_[kv_ + jp_ + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($44_ = (*ldab_) - 1, &$44_));
          }
          else {
            (void) _dswap (($45_ = jj_ - j_, &$45_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($46_ = (*ldab_) - 1, 
            &$46_), &work31_[jp_ + jj_ - j_ - (*kl_) - 1], ($47_ = 65, &$47_));
          }
        }
        nw_ = _min (i3_, jj_ - j_ + 1);
        if (nw_ > 0) {
          (void) _dcopy (&nw_, &work31_[0 + (65) * ((jj_ - j_ + 1 - 1))], &_k1, &ab_[kv_ + (*kl_) + 1 - jj_ + j_ - 1 + ((*ldab_)) 
          * ((jj_ - 1))], &_k1);
        }
      }
    }
  }
  _l0:;
  __calls[30].calls++;
  return 0;
}

int_4 _dgbtrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, int_4 _p_ nrhs_, real_8 _p_ ab_, int_4 _p_ 
ldab_, int_4 _p_ ipiv_, real_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_)
{
  static int_4 i_, j_, kd_, l_, lm_;
  static logical_4 lnoti_, notran_;
  int_4 $0_, $2_, $3_;
  real_8 $1_, $4_, $5_;
  extern logical_4 _lsame ();
  extern int_4 _dgemv ();
  extern int_4 _dger ();
  extern int_4 _dswap ();
  extern int_4 _dtbsv ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  notran_ = _lsame (trans_, _dc_7);
  if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -5;
  }
  else if ((*ldab_) < (2 * (*kl_) + (*ku_) + 1)) {
    (*info_) = -7;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_48, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*nrhs_) == 0) {
    goto _l0;
  }
  kd_ = (*ku_) + (*kl_) + 1;
  lnoti_ = (*kl_) > 0;
  if (notran_) {
    if (lnoti_) {
      for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
        lm_ = _min ((*kl_), (*n_) - j_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _dswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
        (void) _dger (&lm_, nrhs_, ($1_ = -1.0, &$1_), &ab_[kd_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, &b_[j_ - 1 + 
        ((*ldb_)) * ((0))], ldb_, &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_);
      }
    }
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _dtbsv (_dc_11, _dc_5, _dc_12, n_, ($2_ = (*kl_) + (*ku_), &$2_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
  }
  else {
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _dtbsv (_dc_11, _dc_13, _dc_12, n_, ($3_ = (*kl_) + (*ku_), &$3_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
    if (lnoti_) {
      for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
        lm_ = _min ((*kl_), (*n_) - j_);
        (void) _dgemv (_dc_13, &lm_, nrhs_, ($4_ = -1.0, &$4_), &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_, &ab_[kd_ + 1 - 1 + 
        ((*ldab_)) * ((j_ - 1))], &_k1, ($5_ = 1.0, &$5_), &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _dswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
      }
    }
  }
  _l0:;
  __calls[31].calls++;
  return 0;
}

int_4 _dgttrf (int_4 _p_ n_, real_8 _p_ dl_, real_8 _p_ d_, real_8 _p_ du_, real_8 _p_ du2_, int_4 _p_ ipiv_, int_4 _p_ 
info_)
{
  static int_4 i_;
  static real_8 fact_, temp_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
    (void) _xerbla (_dc_49, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ipiv_[i_ - 1] = i_;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (dl_[i_ - 1] == 0.0) {
      if (d_[i_ - 1] == 0.0 && (*info_) == 0) {
        (*info_) = i_;
      }
      if (i_ < (*n_) - 1) {
        du2_[i_ - 1] = 0.0;
      }
    }
    else if (_abs (d_[i_ - 1]) >= _abs (dl_[i_ - 1])) {
      fact_ = dl_[i_ - 1] / d_[i_ - 1];
      dl_[i_ - 1] = fact_;
      d_[i_ + 1 - 1] = d_[i_ + 1 - 1] - fact_ * du_[i_ - 1];
      if (i_ < (*n_) - 1) {
        du2_[i_ - 1] = 0.0;
      }
    }
    else {
      fact_ = d_[i_ - 1] / dl_[i_ - 1];
      d_[i_ - 1] = dl_[i_ - 1];
      dl_[i_ - 1] = fact_;
      temp_ = du_[i_ - 1];
      du_[i_ - 1] = d_[i_ + 1 - 1];
      d_[i_ + 1 - 1] = temp_ - fact_ * d_[i_ + 1 - 1];
      if (i_ < (*n_) - 1) {
        du2_[i_ - 1] = du_[i_ + 1 - 1];
        du_[i_ + 1 - 1] = -fact_ * du_[i_ + 1 - 1];
      }
      ipiv_[i_ - 1] = ipiv_[i_ - 1] + 1;
    }
  }
  if (d_[(*n_) - 1] == 0.0 && (*info_) == 0) {
    (*info_) = (*n_);
    goto _l0;
  }
  _l0:;
  __calls[32].calls++;
  return 0;
}

int_4 _dgttrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ dl_, real_8 _p_ d_, real_8 _p_ du_, real_8 
_p_ du2_, int_4 _p_ ipiv_, real_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_)
{
  static int_4 i_, j_;
  static logical_4 notran_;
  static real_8 temp_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  notran_ = _lsame (trans_, _dc_7);
  if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -3;
  }
  else if ((*ldb_) < _max ((*n_), 1)) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_50, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*nrhs_) == 0) {
    goto _l0;
  }
  if (notran_) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * b_[i_ - 1 + ((*ldb_)) 
          * ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ - dl_[i_ - 1] * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] / d_[(*n_) - 1];
      if ((*n_) > 1) {
        b_[(*n_) - 1 - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[(*n_) - 1 - 1 + ((*ldb_)) * ((j_ - 1))] - du_[(*n_) - 1 - 1] * 
        b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[(*n_) - 1 - 1];
      }
      for (i_ = (*n_) - 2; i_ >= 1; (i_)--) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1] * b_[i_ + 1 - 1 + ((*ldb_)) * 
        ((j_ - 1))] - du2_[i_ - 1] * b_[i_ + 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[i_ - 1];
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / d_[0];
      if ((*n_) > 1) {
        b_[1 + ((*ldb_)) * ((j_ - 1))] = (b_[1 + ((*ldb_)) * ((j_ - 1))] - du_[0] * b_[0 + ((*ldb_)) * ((j_ - 1))]) / d_[1];
      }
      for (i_ = 3; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1 - 1] * b_[i_ - 1 - 1 + 
        ((*ldb_)) * ((j_ - 1))] - du2_[i_ - 2 - 1] * b_[i_ - 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[i_ - 1];
      }
      for (i_ = (*n_) - 1; i_ >= 1; (i_)--) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * b_[i_ + 1 - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * temp_;
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
        }
      }
    }
  }
  _l0:;
  __calls[33].calls++;
  return 0;
}

int_4 _dlacon (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ x_, int_4 _p_ isgn_, real_8 _p_ est_, int_4 _p_ kase_)
{
  static int_4 i_, iter_, j_, jlast_, jump_;
  static real_8 altsgn_, estold_, temp_;
  extern int_4 _idamax ();
  extern real_8 _dasum ();
  extern int_4 _dcopy ();
  if ((*kase_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[i_ - 1] = 1.0 / (real_8) ((*n_));
    }
    (*kase_) = 1;
    jump_ = 1;
    goto _l0;
  }
  switch (jump_) {
    default:
    case 1: goto _l20;
    case 2: goto _l40;
    case 3: goto _l70;
    case 4: goto _l110;
    case 5: goto _l140;
  }
  _l20:;
  if ((*n_) == 1) {
    v_[0] = x_[0];
    (*est_) = _abs (v_[0]);
    goto _l150;
  }
  (*est_) = _dasum (n_, x_, &_k1);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = _sign (1.0, x_[i_ - 1]);
    isgn_[i_ - 1] = _nintd (x_[i_ - 1]);
  }
  (*kase_) = 2;
  jump_ = 2;
  goto _l0;
  _l40:;
  j_ = _idamax (n_, x_, &_k1);
  iter_ = 2;
  _l50:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = 0.0;
  }
  x_[j_ - 1] = 1.0;
  (*kase_) = 1;
  jump_ = 3;
  goto _l0;
  _l70:;
  (void) _dcopy (n_, x_, &_k1, v_, &_k1);
  estold_ = (*est_);
  (*est_) = _dasum (n_, v_, &_k1);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_nintd (_sign (1.0, x_[i_ - 1])) != isgn_[i_ - 1]) {
      goto _l90;
    }
  }
  goto _l120;
  _l90:;
  if ((*est_) <= estold_) {
    goto _l120;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = _sign (1.0, x_[i_ - 1]);
    isgn_[i_ - 1] = _nintd (x_[i_ - 1]);
  }
  (*kase_) = 2;
  jump_ = 4;
  goto _l0;
  _l110:;
  jlast_ = j_;
  j_ = _idamax (n_, x_, &_k1);
  if ((x_[jlast_ - 1] != _abs (x_[j_ - 1])) && (iter_ < 5)) {
    iter_ = iter_ + 1;
    goto _l50;
  }
  _l120:;
  altsgn_ = 1.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = altsgn_ * (1.0 + (real_8) (i_ - 1) / (real_8) ((*n_) - 1));
    altsgn_ = -altsgn_;
  }
  (*kase_) = 1;
  jump_ = 5;
  goto _l0;
  _l140:;
  temp_ = 2.0 * (_dasum (n_, x_, &_k1) / (real_8) (3 * (*n_)));
  if (temp_ > (*est_)) {
    (void) _dcopy (n_, x_, &_k1, v_, &_k1);
    (*est_) = temp_;
  }
  _l150:;
  (*kase_) = 0;
  _l0:;
  __calls[34].calls++;
  return 0;
}

int_4 _dladiv (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ d_, real_8 _p_ p_, real_8 _p_ q_)
{
  static real_8 e_, f_;
  if (_abs ((*d_)) < _abs ((*c_))) {
    e_ = (*d_) / (*c_);
    f_ = (*c_) + (*d_) * e_;
    (*p_) = ((*a_) + (*b_) * e_) / f_;
    (*q_) = ((*b_) - (*a_) * e_) / f_;
  }
  else {
    e_ = (*c_) / (*d_);
    f_ = (*d_) + (*c_) * e_;
    (*p_) = ((*b_) + (*a_) * e_) / f_;
    (*q_) = (-(*a_) + (*b_) * e_) / f_;
  }
  __calls[35].calls++;
  return 0;
}

int_4 _dlae2 (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ rt1_, real_8 _p_ rt2_)
{
  static real_8 ab_, acmn_, acmx_, adf_, df_, rt_, sm_, tb_;
  real_8 $0_, $1_;
  sm_ = (*a_) + (*c_);
  df_ = (*a_) - (*c_);
  adf_ = _abs (df_);
  tb_ = (*b_) + (*b_);
  ab_ = _abs (tb_);
  if (_abs ((*a_)) > _abs ((*c_))) {
    acmx_ = (*a_);
    acmn_ = (*c_);
  }
  else {
    acmx_ = (*c_);
    acmn_ = (*a_);
  }
  if (adf_ > ab_) {
    rt_ = adf_ * sqrt (1.0 + ($0_ = (ab_ / adf_), $0_ * $0_));
  }
  else if (adf_ < ab_) {
    rt_ = ab_ * sqrt (1.0 + ($1_ = (adf_ / ab_), $1_ * $1_));
  }
  else {
    rt_ = ab_ * 1.4142135623730950488016887242096980785696718753769480731766797379907325;
  }
  if (sm_ < 0.0) {
    (*rt1_) = 0.5 * (sm_ - rt_);
    (*rt2_) = (acmx_ / (*rt1_)) * acmn_ - ((*b_) / (*rt1_)) * (*b_);
  }
  else if (sm_ > 0.0) {
    (*rt1_) = 0.5 * (sm_ + rt_);
    (*rt2_) = (acmx_ / (*rt1_)) * acmn_ - ((*b_) / (*rt1_)) * (*b_);
  }
  else {
    (*rt1_) = 0.5 * rt_;
    (*rt2_) = -0.5 * rt_;
  }
  __calls[36].calls++;
  return 0;
}

int_4 _dlaev2 (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ rt1_, real_8 _p_ rt2_, real_8 _p_ cs1_, real_8 
_p_ sn1_)
{
  static int_4 sgn1_, sgn2_;
  static real_8 ab_, acmn_, acmx_, acs_, adf_, cs_, ct_, df_, rt_, sm_, tb_, tn_;
  real_8 $0_, $1_;
  sm_ = (*a_) + (*c_);
  df_ = (*a_) - (*c_);
  adf_ = _abs (df_);
  tb_ = (*b_) + (*b_);
  ab_ = _abs (tb_);
  if (_abs ((*a_)) > _abs ((*c_))) {
    acmx_ = (*a_);
    acmn_ = (*c_);
  }
  else {
    acmx_ = (*c_);
    acmn_ = (*a_);
  }
  if (adf_ > ab_) {
    rt_ = adf_ * sqrt (1.0 + ($0_ = (ab_ / adf_), $0_ * $0_));
  }
  else if (adf_ < ab_) {
    rt_ = ab_ * sqrt (1.0 + ($1_ = (adf_ / ab_), $1_ * $1_));
  }
  else {
    rt_ = ab_ * 1.4142135623730950488016887242096980785696718753769480731766797379907325;
  }
  if (sm_ < 0.0) {
    (*rt1_) = 0.5 * (sm_ - rt_);
    sgn1_ = -1;
    (*rt2_) = (acmx_ / (*rt1_)) * acmn_ - ((*b_) / (*rt1_)) * (*b_);
  }
  else if (sm_ > 0.0) {
    (*rt1_) = 0.5 * (sm_ + rt_);
    sgn1_ = 1;
    (*rt2_) = (acmx_ / (*rt1_)) * acmn_ - ((*b_) / (*rt1_)) * (*b_);
  }
  else {
    (*rt1_) = 0.5 * rt_;
    (*rt2_) = -0.5 * rt_;
    sgn1_ = 1;
  }
  if (df_ >= 0.0) {
    cs_ = df_ + rt_;
    sgn2_ = 1;
  }
  else {
    cs_ = df_ - rt_;
    sgn2_ = -1;
  }
  acs_ = _abs (cs_);
  if (acs_ > ab_) {
    ct_ = -tb_ / cs_;
    (*sn1_) = 1.0 / sqrt (1.0 + ct_ * ct_);
    (*cs1_) = ct_ * (*sn1_);
  }
  else {
    if (ab_ == 0.0) {
      (*cs1_) = 1.0;
      (*sn1_) = 0.0;
    }
    else {
      tn_ = -cs_ / tb_;
      (*cs1_) = 1.0 / sqrt (1.0 + tn_ * tn_);
      (*sn1_) = tn_ * (*cs1_);
    }
  }
  if (sgn1_ == sgn2_) {
    tn_ = (*cs1_);
    (*cs1_) = -(*sn1_);
    (*sn1_) = tn_;
  }
  __calls[37].calls++;
  return 0;
}

int_4 _dlaexc (logical_4 _p_ wantq_, int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ q_, int_4 _p_ ldq_, int_4 
_p_ j1_, int_4 _p_ n1_, int_4 _p_ n2_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 ierr_, j2_, j3_, j4_, k_, nd_;
  static real_8 cs_, dnorm_, eps_, scale_, smlnum_, sn_, t11_, t22_, t33_, tau_, tau1_, tau2_, temp_, thresh_, wi1_, wi2_
  , wr1_, wr2_, xnorm_, d_[16], u_[3], u1_[3], u2_[3], x_[4];
  int_4 $1_, $2_, $3_, $4_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $19_, $20_, $21_, $22_, $23_, 
  $24_, $25_, $26_, $27_, $28_, $29_, $31_, $32_, $33_, $34_, $35_, $36_, $37_, $38_, $39_, $40_, $41_, $42_, $43_, $44_, 
  $45_, $46_, $47_, $48_, $50_, $51_, $52_, $53_, $54_, $55_, $56_, $57_, $58_, $59_, $60_, $61_;
  logical_4 $5_, $6_;
  real_8 $0_, $18_, $30_, $49_;
  extern real_8 _dlamch ();
  extern real_8 _dlange ();
  extern int_4 _dlacpy ();
  extern int_4 _dlarfg ();
  extern int_4 _dlartg ();
  extern int_4 _drot ();
  (*info_) = 0;
  if ((*n_) == 0 || (*n1_) == 0 || (*n2_) == 0) {
    goto _l0;
  }
  if ((*j1_) + (*n1_) > (*n_)) {
    goto _l0;
  }
  j2_ = (*j1_) + 1;
  j3_ = (*j1_) + 2;
  j4_ = (*j1_) + 3;
  if ((*n1_) == 1 && (*n2_) == 1) {
    t11_ = t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))];
    t22_ = t_[j2_ - 1 + ((*ldt_)) * ((j2_ - 1))];
    (void) _dlartg (&t_[(*j1_) - 1 + ((*ldt_)) * ((j2_ - 1))], ($0_ = t22_ - t11_, &$0_), &cs_, &sn_, &temp_);
    if (j3_ <= (*n_)) {
      (void) _drot (($1_ = (*n_) - (*j1_) - 1, &$1_), &t_[(*j1_) - 1 + ((*ldt_)) * ((j3_ - 1))], ldt_, &t_[j2_ - 1 + 
      ((*ldt_)) * ((j3_ - 1))], ldt_, &cs_, &sn_);
    }
    (void) _drot (($2_ = (*j1_) - 1, &$2_), &t_[0 + ((*ldt_)) * (((*j1_) - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j2_ - 1))], 
    &_k1, &cs_, &sn_);
    t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))] = t22_;
    t_[j2_ - 1 + ((*ldt_)) * ((j2_ - 1))] = t11_;
    if ((*wantq_)) {
      (void) _drot (n_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], &_k1, &q_[0 + ((*ldq_)) * ((j2_ - 1))], &_k1, &cs_, &sn_);
    }
  }
  else {
    nd_ = (*n1_) + (*n2_);
    (void) _dlacpy (_dc_51, &nd_, &nd_, &t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))], ldt_, d_, ($3_ = 4, &$3_));
    dnorm_ = _dlange (_dc_52, &nd_, &nd_, d_, ($4_ = 4, &$4_), work_);
    eps_ = _dlamch (_dc_44);
    smlnum_ = _dlamch (_dc_28) / eps_;
    thresh_ = _max (10.0 * eps_ * dnorm_, smlnum_);
    (void) _dlasy2 (($5_ = FALSE, &$5_), ($6_ = FALSE, &$6_), &_km1, n1_, n2_, d_, ($7_ = 4, &$7_), &d_[(*n1_) + 1 - 1 + 
    (4) * (((*n1_) + 1 - 1))], ($8_ = 4, &$8_), &d_[0 + (4) * (((*n1_) + 1 - 1))], ($9_ = 4, &$9_), &scale_, x_, ($10_ = 2, 
    &$10_), &xnorm_, &ierr_);
    k_ = (*n1_) + (*n1_) + (*n2_) - 3;
    switch (k_) {
      default:
      case 1: goto _l10;
      case 2: goto _l20;
      case 3: goto _l30;
    }
    _l10:;
    u_[0] = scale_;
    u_[1] = x_[0];
    u_[2] = x_[2];
    (void) _dlarfg (($11_ = 3, &$11_), &u_[2], u_, &_k1, &tau_);
    u_[2] = 1.0;
    t11_ = t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))];
    (void) _dlarfx (_dc_20, ($12_ = 3, &$12_), ($13_ = 3, &$13_), u_, &tau_, d_, ($14_ = 4, &$14_), work_);
    (void) _dlarfx (_dc_37, ($15_ = 3, &$15_), ($16_ = 3, &$16_), u_, &tau_, d_, ($17_ = 4, &$17_), work_);
    if (($18_ = _max (_abs (d_[2]), _abs (d_[6])), _max ($18_, _abs (d_[10] - t11_))) > thresh_) {
      goto _l50;
    }
    (void) _dlarfx (_dc_20, ($19_ = 3, &$19_), ($20_ = (*n_) - (*j1_) + 1, &$20_), u_, &tau_, &t_[(*j1_) - 1 + ((*ldt_)) * 
    (((*j1_) - 1))], ldt_, work_);
    (void) _dlarfx (_dc_37, &j2_, ($21_ = 3, &$21_), u_, &tau_, &t_[0 + ((*ldt_)) * (((*j1_) - 1))], ldt_, work_);
    t_[j3_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    t_[j3_ - 1 + ((*ldt_)) * ((j2_ - 1))] = 0.0;
    t_[j3_ - 1 + ((*ldt_)) * ((j3_ - 1))] = t11_;
    if ((*wantq_)) {
      (void) _dlarfx (_dc_37, n_, ($22_ = 3, &$22_), u_, &tau_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], ldq_, work_);
    }
    goto _l40;
    _l20:;
    u_[0] = -x_[0];
    u_[1] = -x_[1];
    u_[2] = scale_;
    (void) _dlarfg (($23_ = 3, &$23_), &u_[0], &u_[1], &_k1, &tau_);
    u_[0] = 1.0;
    t33_ = t_[j3_ - 1 + ((*ldt_)) * ((j3_ - 1))];
    (void) _dlarfx (_dc_20, ($24_ = 3, &$24_), ($25_ = 3, &$25_), u_, &tau_, d_, ($26_ = 4, &$26_), work_);
    (void) _dlarfx (_dc_37, ($27_ = 3, &$27_), ($28_ = 3, &$28_), u_, &tau_, d_, ($29_ = 4, &$29_), work_);
    if (($30_ = _max (_abs (d_[1]), _abs (d_[2])), _max ($30_, _abs (d_[0] - t33_))) > thresh_) {
      goto _l50;
    }
    (void) _dlarfx (_dc_37, &j3_, ($31_ = 3, &$31_), u_, &tau_, &t_[0 + ((*ldt_)) * (((*j1_) - 1))], ldt_, work_);
    (void) _dlarfx (_dc_20, ($32_ = 3, &$32_), ($33_ = (*n_) - (*j1_), &$33_), u_, &tau_, &t_[(*j1_) - 1 + ((*ldt_)) * 
    ((j2_ - 1))], ldt_, work_);
    t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))] = t33_;
    t_[j2_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    t_[j3_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    if ((*wantq_)) {
      (void) _dlarfx (_dc_37, n_, ($34_ = 3, &$34_), u_, &tau_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], ldq_, work_);
    }
    goto _l40;
    _l30:;
    u1_[0] = -x_[0];
    u1_[1] = -x_[1];
    u1_[2] = scale_;
    (void) _dlarfg (($35_ = 3, &$35_), &u1_[0], &u1_[1], &_k1, &tau1_);
    u1_[0] = 1.0;
    temp_ = -tau1_ * (x_[2] + u1_[1] * x_[3]);
    u2_[0] = -temp_ * u1_[1] - x_[3];
    u2_[1] = -temp_ * u1_[2];
    u2_[2] = scale_;
    (void) _dlarfg (($36_ = 3, &$36_), &u2_[0], &u2_[1], &_k1, &tau2_);
    u2_[0] = 1.0;
    (void) _dlarfx (_dc_20, ($37_ = 3, &$37_), ($38_ = 4, &$38_), u1_, &tau1_, d_, ($39_ = 4, &$39_), work_);
    (void) _dlarfx (_dc_37, ($40_ = 4, &$40_), ($41_ = 3, &$41_), u1_, &tau1_, d_, ($42_ = 4, &$42_), work_);
    (void) _dlarfx (_dc_20, ($43_ = 3, &$43_), ($44_ = 4, &$44_), u2_, &tau2_, &d_[1], ($45_ = 4, &$45_), work_);
    (void) _dlarfx (_dc_37, ($46_ = 4, &$46_), ($47_ = 3, &$47_), u2_, &tau2_, &d_[4], ($48_ = 4, &$48_), work_);
    if (($49_ = _max (_abs (d_[2]), _abs (d_[6])), $49_ = _max ($49_, _abs (d_[3])), _max ($49_, _abs (d_[7]))) > thresh_) 
      {
      goto _l50;
    }
    (void) _dlarfx (_dc_20, ($50_ = 3, &$50_), ($51_ = (*n_) - (*j1_) + 1, &$51_), u1_, &tau1_, &t_[(*j1_) - 1 + ((*ldt_)) 
    * (((*j1_) - 1))], ldt_, work_);
    (void) _dlarfx (_dc_37, &j4_, ($52_ = 3, &$52_), u1_, &tau1_, &t_[0 + ((*ldt_)) * (((*j1_) - 1))], ldt_, work_);
    (void) _dlarfx (_dc_20, ($53_ = 3, &$53_), ($54_ = (*n_) - (*j1_) + 1, &$54_), u2_, &tau2_, &t_[j2_ - 1 + ((*ldt_)) * 
    (((*j1_) - 1))], ldt_, work_);
    (void) _dlarfx (_dc_37, &j4_, ($55_ = 3, &$55_), u2_, &tau2_, &t_[0 + ((*ldt_)) * ((j2_ - 1))], ldt_, work_);
    t_[j3_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    t_[j3_ - 1 + ((*ldt_)) * ((j2_ - 1))] = 0.0;
    t_[j4_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    t_[j4_ - 1 + ((*ldt_)) * ((j2_ - 1))] = 0.0;
    if ((*wantq_)) {
      (void) _dlarfx (_dc_37, n_, ($56_ = 3, &$56_), u1_, &tau1_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], ldq_, work_);
      (void) _dlarfx (_dc_37, n_, ($57_ = 3, &$57_), u2_, &tau2_, &q_[0 + ((*ldq_)) * ((j2_ - 1))], ldq_, work_);
    }
    _l40:;
    if ((*n2_) == 2) {
      (void) _dlanv2 (&t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))], &t_[(*j1_) - 1 + ((*ldt_)) * ((j2_ - 1))], &t_[j2_ - 1 + 
      ((*ldt_)) * (((*j1_) - 1))], &t_[j2_ - 1 + ((*ldt_)) * ((j2_ - 1))], &wr1_, &wi1_, &wr2_, &wi2_, &cs_, &sn_);
      (void) _drot (($58_ = (*n_) - (*j1_) - 1, &$58_), &t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) + 2 - 1))], ldt_, &t_[j2_ - 1 + 
      ((*ldt_)) * (((*j1_) + 2 - 1))], ldt_, &cs_, &sn_);
      (void) _drot (($59_ = (*j1_) - 1, &$59_), &t_[0 + ((*ldt_)) * (((*j1_) - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j2_ - 1))], 
      &_k1, &cs_, &sn_);
      if ((*wantq_)) {
        (void) _drot (n_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], &_k1, &q_[0 + ((*ldq_)) * ((j2_ - 1))], &_k1, &cs_, &sn_);
      }
    }
    if ((*n1_) == 2) {
      j3_ = (*j1_) + (*n2_);
      j4_ = j3_ + 1;
      (void) _dlanv2 (&t_[j3_ - 1 + ((*ldt_)) * ((j3_ - 1))], &t_[j3_ - 1 + ((*ldt_)) * ((j4_ - 1))], &t_[j4_ - 1 + ((*ldt_)) 
      * ((j3_ - 1))], &t_[j4_ - 1 + ((*ldt_)) * ((j4_ - 1))], &wr1_, &wi1_, &wr2_, &wi2_, &cs_, &sn_);
      if (j3_ + 2 <= (*n_)) {
        (void) _drot (($60_ = (*n_) - j3_ - 1, &$60_), &t_[j3_ - 1 + ((*ldt_)) * ((j3_ + 2 - 1))], ldt_, &t_[j4_ - 1 + 
        ((*ldt_)) * ((j3_ + 2 - 1))], ldt_, &cs_, &sn_);
      }
      (void) _drot (($61_ = j3_ - 1, &$61_), &t_[0 + ((*ldt_)) * ((j3_ - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j4_ - 1))], &_k1, 
      &cs_, &sn_);
      if ((*wantq_)) {
        (void) _drot (n_, &q_[0 + ((*ldq_)) * ((j3_ - 1))], &_k1, &q_[0 + ((*ldq_)) * ((j4_ - 1))], &_k1, &cs_, &sn_);
      }
    }
  }
  goto _l0;
  _l50:;
  (*info_) = 1;
  _l0:;
  __calls[38].calls++;
  return 0;
}

int_4 _dlagtm (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ alpha_, real_8 _p_ dl_, real_8 _p_ d_, real_8 
_p_ du_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ beta_, real_8 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*beta_) == 0.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = 0.0;
      }
    }
  }
  else if ((*beta_) == -1.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = -b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
      }
    }
  }
  if ((*alpha_) == 1.0) {
    if (_lsame (trans_, _dc_7)) {
      for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
        if ((*n_) == 1) {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
        }
        else {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] + du_[0] * 
          x_[1 + ((*ldx_)) * ((j_ - 1))];
          b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] + dl_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
          + ((*ldx_)) * ((j_ - 1))] + d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
          for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + dl_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
            * ((j_ - 1))] + d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + du_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 
            1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
        if ((*n_) == 1) {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
        }
        else {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] + dl_[0] * 
          x_[1 + ((*ldx_)) * ((j_ - 1))];
          b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] + du_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
          + ((*ldx_)) * ((j_ - 1))] + d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
          for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + du_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
            * ((j_ - 1))] + d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + dl_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 
            1))];
          }
        }
      }
    }
  }
  else if ((*alpha_) == -1.0) {
    if (_lsame (trans_, _dc_7)) {
      for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
        if ((*n_) == 1) {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
        }
        else {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] - du_[0] * 
          x_[1 + ((*ldx_)) * ((j_ - 1))];
          b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
          + ((*ldx_)) * ((j_ - 1))] - d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
          for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
            * ((j_ - 1))] - d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] - du_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 
            1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
        if ((*n_) == 1) {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
        }
        else {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] - dl_[0] * 
          x_[1 + ((*ldx_)) * ((j_ - 1))];
          b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] - du_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
          + ((*ldx_)) * ((j_ - 1))] - d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
          for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
            * ((j_ - 1))] - d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] - dl_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 
            1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[39].calls++;
  return 0;
}

int_4 _dlahqr (logical_4 _p_ wantt_, logical_4 _p_ wantz_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, real_8 _p_ h_, 
int_4 _p_ ldh_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ iloz_, int_4 _p_ ihiz_, real_8 _p_ z_, int_4 _p_ ldz_, int_4 
_p_ info_)
{
  static int_4 i_, i1_, i2_, itn_, its_, j_, k_, l_, m_, nh_, nr_, nz_;
  static real_8 cs_, h00_, h10_, h11_, h12_, h21_, h22_, h33_, h33s_, h43h34_, h44_, h44s_, ovfl_, s_, smlnum_, sn_, sum_
  , t1_, t2_, t3_, tst1_, ulp_, unfl_, v1_, v2_, v3_, v_[3], work_[1];
  int_4 $0_, $1_, $2_;
  extern real_8 _dlamch ();
  extern int_4 _dcopy ();
  extern int_4 _dlabad ();
  extern int_4 _dlarfg ();
  extern int_4 _drot ();
  (*info_) = 0;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*ilo_) == (*ihi_)) {
    wr_[(*ilo_) - 1] = h_[(*ilo_) - 1 + ((*ldh_)) * (((*ilo_) - 1))];
    wi_[(*ilo_) - 1] = 0.0;
    goto _l0;
  }
  nh_ = (*ihi_) - (*ilo_) + 1;
  nz_ = (*ihiz_) - (*iloz_) + 1;
  unfl_ = _dlamch (_dc_18);
  ovfl_ = 1.0 / unfl_;
  (void) _dlabad (&unfl_, &ovfl_);
  ulp_ = _dlamch (_dc_21);
  smlnum_ = unfl_ * (nh_ / ulp_);
  if ((*wantt_)) {
    i1_ = 1;
    i2_ = (*n_);
  }
  itn_ = 30 * nh_;
  i_ = (*ihi_);
  _l10:;
  l_ = (*ilo_);
  if (i_ < (*ilo_)) {
    goto _l150;
  }
  for (its_ = 0; its_ <= itn_; (its_)++) {
    for (k_ = i_; k_ >= l_ + 1; (k_)--) {
      tst1_ = _abs (h_[k_ - 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))]) + _abs (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1))]);
      if (tst1_ == 0.0) {
        tst1_ = _dlanhs (_dc_22, ($0_ = i_ - l_ + 1, &$0_), &h_[l_ - 1 + ((*ldh_)) * ((l_ - 1))], ldh_, work_);
      }
      if (_abs (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))]) <= _max (ulp_ * tst1_, smlnum_)) {
        goto _l30;
      }
    }
    _l30:;
    l_ = k_;
    if (l_ > (*ilo_)) {
      h_[l_ - 1 + ((*ldh_)) * ((l_ - 1 - 1))] = 0.0;
    }
    if (l_ >= i_ - 1) {
      goto _l140;
    }
    if (! ((*wantt_))) {
      i1_ = l_;
      i2_ = i_;
    }
    if (its_ == 10 || its_ == 20) {
      s_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))]) + _abs (h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 2 - 1))]);
      h44_ = 0.75 * s_;
      h33_ = h44_;
      h43h34_ = -0.4375 * s_ * s_;
    }
    else {
      h44_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
      h33_ = h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))];
      h43h34_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] * h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))];
    }
    for (m_ = i_ - 2; m_ >= l_; (m_)--) {
      h11_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1))];
      h22_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h21_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))];
      h12_ = h_[m_ - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h44s_ = h44_ - h11_;
      h33s_ = h33_ - h11_;
      v1_ = (h33s_ * h44s_ - h43h34_) / h21_ + h12_;
      v2_ = h22_ - h11_ - h33s_ - h44s_;
      v3_ = h_[m_ + 2 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      s_ = _abs (v1_) + _abs (v2_) + _abs (v3_);
      v1_ = v1_ / s_;
      v2_ = v2_ / s_;
      v3_ = v3_ / s_;
      v_[0] = v1_;
      v_[1] = v2_;
      v_[2] = v3_;
      if (m_ == l_) {
        goto _l50;
      }
      h00_ = h_[m_ - 1 - 1 + ((*ldh_)) * ((m_ - 1 - 1))];
      h10_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1 - 1))];
      tst1_ = _abs (v1_) * (_abs (h00_) + _abs (h11_) + _abs (h22_));
      if (_abs (h10_) * (_abs (v2_) + _abs (v3_)) <= ulp_ * tst1_) {
        goto _l50;
      }
    }
    _l50:;
    for (k_ = m_; k_ <= i_ - 1; (k_)++) {
      nr_ = _min (3, i_ - k_ + 1);
      if (k_ > m_) {
        (void) _dcopy (&nr_, &h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))], &_k1, v_, &_k1);
      }
      (void) _dlarfg (&nr_, &v_[0], &v_[1], &_k1, &t1_);
      if (k_ > m_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = v_[0];
        h_[k_ + 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = 0.0;
        if (k_ < i_ - 1) {
          h_[k_ + 2 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = 0.0;
        }
      }
      else if (m_ > l_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = -h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))];
      }
      v2_ = v_[1];
      t2_ = t1_ * v2_;
      if (nr_ == 3) {
        v3_ = v_[2];
        t3_ = t1_ * v3_;
        for (j_ = k_; j_ <= i2_; (j_)++) {
          sum_ = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + v2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] + v3_ * h_[k_ + 2 - 1 + 
          ((*ldh_)) * ((j_ - 1))];
          h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t1_;
          h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t2_;
          h_[k_ + 2 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 2 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t3_;
        }
        for (j_ = i1_; j_ <= _min (k_ + 3, i_); (j_)++) {
          sum_ = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + v2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] + v3_ * h_[j_ - 1 + 
          ((*ldh_)) * ((k_ + 2 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_ * t1_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * t2_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 2 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 2 - 1))] - sum_ * t3_;
        }
        if ((*wantz_)) {
          for (j_ = (*iloz_); j_ <= (*ihiz_); (j_)++) {
            sum_ = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] + v2_ * z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] + v3_ * z_[j_ - 1 + 
            ((*ldz_)) * ((k_ + 2 - 1))];
            z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] - sum_ * t1_;
            z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] - sum_ * t2_;
            z_[j_ - 1 + ((*ldz_)) * ((k_ + 2 - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ + 2 - 1))] - sum_ * t3_;
          }
        }
      }
      else if (nr_ == 2) {
        for (j_ = k_; j_ <= i2_; (j_)++) {
          sum_ = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + v2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
          h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t1_;
          h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t2_;
        }
        for (j_ = i1_; j_ <= i_; (j_)++) {
          sum_ = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + v2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_ * t1_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * t2_;
        }
        if ((*wantz_)) {
          for (j_ = (*iloz_); j_ <= (*ihiz_); (j_)++) {
            sum_ = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] + v2_ * z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))];
            z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] - sum_ * t1_;
            z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] - sum_ * t2_;
          }
        }
      }
    }
  }
  (*info_) = i_;
  goto _l0;
  _l140:;
  if (l_ == i_) {
    wr_[i_ - 1] = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
    wi_[i_ - 1] = 0.0;
  }
  else if (l_ == i_ - 1) {
    (void) _dlanv2 (&h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))], &h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))], &h_[i_ - 1 + 
    ((*ldh_)) * ((i_ - 1 - 1))], &h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))], &wr_[i_ - 1 - 1], &wi_[i_ - 1 - 1], &wr_[i_ - 1], 
    &wi_[i_ - 1], &cs_, &sn_);
    if ((*wantt_)) {
      if (i2_ > i_) {
        (void) _drot (($1_ = i2_ - i_, &$1_), &h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))], ldh_, &h_[i_ - 1 + ((*ldh_)) * ((i_ 
        + 1 - 1))], ldh_, &cs_, &sn_);
      }
      (void) _drot (($2_ = i_ - i1_ - 1, &$2_), &h_[i1_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))], &_k1, &h_[i1_ - 1 + ((*ldh_)) * 
      ((i_ - 1))], &_k1, &cs_, &sn_);
    }
    if ((*wantz_)) {
      (void) _drot (&nz_, &z_[(*iloz_) - 1 + ((*ldz_)) * ((i_ - 1 - 1))], &_k1, &z_[(*iloz_) - 1 + ((*ldz_)) * ((i_ - 1))], 
      &_k1, &cs_, &sn_);
    }
  }
  itn_ = itn_ - its_;
  i_ = l_ - 1;
  goto _l10;
  _l150:;
  _l0:;
  __calls[40].calls++;
  return 0;
}

int_4 _dlaln2 (logical_4 _p_ ltrans_, int_4 _p_ na_, int_4 _p_ nw_, real_8 _p_ smin_, real_8 _p_ ca_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ d1_, real_8 _p_ d2_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ wr_, real_8 _p_ wi_, real_8 
_p_ x_, int_4 _p_ ldx_, real_8 _p_ scale_, real_8 _p_ xnorm_, int_4 _p_ info_)
{
  static int_4 icmax_, j_, ipivot_[16];
  static logical_4 rswap_[4], zswap_[4];
  static real_8 bbnd_, bi1_, bi2_, bignum_, bnorm_, br1_, br2_, ci21_, ci22_, cmax_, cnorm_, cr21_, cr22_, csi_, csr_, 
  li21_, lr21_, smini_, smlnum_, temp_, u22abs_, ui11_, ui11r_, ui12_, ui12s_, ui22_, ur11_, ur11r_, ur12_, ur12s_, ur22_
  , xi1_, xi2_, xr1_, xr2_, (_p_ ci_), civ_[4], (_p_ cr_), crv_[4];
  int_4 _data_k_0, _k_1, _data_k_1, _k_3, _data_k_2, _p_ _arr_4, _k_5;
  logical_4 _p_ _arr_0, _p_ _arr_2;
  real_8 $6_, $7_;
  extern real_8 _dlamch ();
  ci_ = (real_8 (_p_)) civ_;
  cr_ = (real_8 (_p_)) crv_;
#define _data_n_0 4
  static logical_4 _data_l_0[_data_n_0] = {
    FALSE,
    FALSE,
    TRUE,
    TRUE
  };
#define _data_n_1 4
  static logical_4 _data_l_1[_data_n_1] = {
    FALSE,
    TRUE,
    FALSE,
    TRUE
  };
#define _data_n_2 16
  static int_4 _data_l_2[_data_n_2] = {
    1,
    2,
    3,
    4,
    2,
    1,
    4,
    3,
    3,
    4,
    1,
    2,
    4,
    3,
    2,
    1
  };
  if (__calls[41].calls == 0) {
    _data_k_0 = 0;
    for (_arr_0 = (logical_4 *) zswap_, _k_1 = 0; _k_1 < 4; _arr_0++, _k_1++) {
      if (_data_k_0 >= _data_n_0) {
        _data_k_0 = 0;
      }
      zswap_[_k_1] = _data_l_0[_data_k_0++];
    }
  }
  if (__calls[41].calls == 0) {
    _data_k_1 = 0;
    for (_arr_2 = (logical_4 *) rswap_, _k_3 = 0; _k_3 < 4; _arr_2++, _k_3++) {
      if (_data_k_1 >= _data_n_1) {
        _data_k_1 = 0;
      }
      rswap_[_k_3] = _data_l_1[_data_k_1++];
    }
  }
  if (__calls[41].calls == 0) {
    _data_k_2 = 0;
    for (_arr_4 = (int_4 *) ipivot_, _k_5 = 0; _k_5 < 16; _arr_4++, _k_5++) {
      if (_data_k_2 >= _data_n_2) {
        _data_k_2 = 0;
      }
      ipivot_[_k_5] = _data_l_2[_data_k_2++];
    }
  }
  smlnum_ = 2.0 * _dlamch (_dc_18);
  bignum_ = 1.0 / smlnum_;
  smini_ = _max ((*smin_), smlnum_);
  (*info_) = 0;
  (*scale_) = 1.0;
  if ((*na_) == 1) {
    if ((*nw_) == 1) {
      csr_ = (*ca_) * a_[0 + ((*lda_)) * ((0))] - (*wr_) * (*d1_);
      cnorm_ = _abs (csr_);
      if (cnorm_ < smini_) {
        csr_ = smini_;
        cnorm_ = smini_;
        (*info_) = 1;
      }
      bnorm_ = _abs (b_[0 + ((*ldb_)) * ((0))]);
      if (cnorm_ < 1.0 && bnorm_ > 1.0) {
        if (bnorm_ > bignum_ * cnorm_) {
          (*scale_) = 1.0 / bnorm_;
        }
      }
      x_[0 + ((*ldx_)) * ((0))] = (b_[0 + ((*ldb_)) * ((0))] * (*scale_)) / csr_;
      (*xnorm_) = _abs (x_[0 + ((*ldx_)) * ((0))]);
    }
    else {
      csr_ = (*ca_) * a_[0 + ((*lda_)) * ((0))] - (*wr_) * (*d1_);
      csi_ = -(*wi_) * (*d1_);
      cnorm_ = _abs (csr_) + _abs (csi_);
      if (cnorm_ < smini_) {
        csr_ = smini_;
        csi_ = 0.0;
        cnorm_ = smini_;
        (*info_) = 1;
      }
      bnorm_ = _abs (b_[0 + ((*ldb_)) * ((0))]) + _abs (b_[0 + ((*ldb_)) * ((1))]);
      if (cnorm_ < 1.0 && bnorm_ > 1.0) {
        if (bnorm_ > bignum_ * cnorm_) {
          (*scale_) = 1.0 / bnorm_;
        }
      }
      (void) _dladiv (($6_ = (*scale_) * b_[0 + ((*ldb_)) * ((0))], &$6_), ($7_ = (*scale_) * b_[0 + ((*ldb_)) * ((1))], 
      &$7_), &csr_, &csi_, &x_[0 + ((*ldx_)) * ((0))], &x_[0 + ((*ldx_)) * ((1))]);
      (*xnorm_) = _abs (x_[0 + ((*ldx_)) * ((0))]) + _abs (x_[0 + ((*ldx_)) * ((1))]);
    }
  }
  else {
    cr_[0] = (*ca_) * a_[0 + ((*lda_)) * ((0))] - (*wr_) * (*d1_);
    cr_[3] = (*ca_) * a_[1 + ((*lda_)) * ((1))] - (*wr_) * (*d2_);
    if ((*ltrans_)) {
      cr_[2] = (*ca_) * a_[1 + ((*lda_)) * ((0))];
      cr_[1] = (*ca_) * a_[0 + ((*lda_)) * ((1))];
    }
    else {
      cr_[1] = (*ca_) * a_[1 + ((*lda_)) * ((0))];
      cr_[2] = (*ca_) * a_[0 + ((*lda_)) * ((1))];
    }
    if ((*nw_) == 1) {
      cmax_ = 0.0;
      icmax_ = 0;
      for (j_ = 1; j_ <= 4; (j_)++) {
        if (_abs (crv_[j_ - 1]) > cmax_) {
          cmax_ = _abs (crv_[j_ - 1]);
          icmax_ = j_;
        }
      }
      if (cmax_ < smini_) {
        bnorm_ = _max (_abs (b_[0 + ((*ldb_)) * ((0))]), _abs (b_[1 + ((*ldb_)) * ((0))]));
        if (smini_ < 1.0 && bnorm_ > 1.0) {
          if (bnorm_ > bignum_ * smini_) {
            (*scale_) = 1.0 / bnorm_;
          }
        }
        temp_ = (*scale_) / smini_;
        x_[0 + ((*ldx_)) * ((0))] = temp_ * b_[0 + ((*ldb_)) * ((0))];
        x_[1 + ((*ldx_)) * ((0))] = temp_ * b_[1 + ((*ldb_)) * ((0))];
        (*xnorm_) = temp_ * bnorm_;
        (*info_) = 1;
        goto _l0;
      }
      ur11_ = crv_[icmax_ - 1];
      cr21_ = crv_[ipivot_[1 + (4) * ((icmax_ - 1))] - 1];
      ur12_ = crv_[ipivot_[2 + (4) * ((icmax_ - 1))] - 1];
      cr22_ = crv_[ipivot_[3 + (4) * ((icmax_ - 1))] - 1];
      ur11r_ = 1.0 / ur11_;
      lr21_ = ur11r_ * cr21_;
      ur22_ = cr22_ - ur12_ * lr21_;
      if (_abs (ur22_) < smini_) {
        ur22_ = smini_;
        (*info_) = 1;
      }
      if (rswap_[icmax_ - 1]) {
        br1_ = b_[1 + ((*ldb_)) * ((0))];
        br2_ = b_[0 + ((*ldb_)) * ((0))];
      }
      else {
        br1_ = b_[0 + ((*ldb_)) * ((0))];
        br2_ = b_[1 + ((*ldb_)) * ((0))];
      }
      br2_ = br2_ - lr21_ * br1_;
      bbnd_ = _max (_abs (br1_ * (ur22_ * ur11r_)), _abs (br2_));
      if (bbnd_ > 1.0 && _abs (ur22_) < 1.0) {
        if (bbnd_ >= bignum_ * _abs (ur22_)) {
          (*scale_) = 1.0 / bbnd_;
        }
      }
      xr2_ = (br2_ * (*scale_)) / ur22_;
      xr1_ = ((*scale_) * br1_) * ur11r_ - xr2_ * (ur11r_ * ur12_);
      if (zswap_[icmax_ - 1]) {
        x_[0 + ((*ldx_)) * ((0))] = xr2_;
        x_[1 + ((*ldx_)) * ((0))] = xr1_;
      }
      else {
        x_[0 + ((*ldx_)) * ((0))] = xr1_;
        x_[1 + ((*ldx_)) * ((0))] = xr2_;
      }
      (*xnorm_) = _max (_abs (xr1_), _abs (xr2_));
      if ((*xnorm_) > 1.0 && cmax_ > 1.0) {
        if ((*xnorm_) > bignum_ / cmax_) {
          temp_ = cmax_ / bignum_;
          x_[0 + ((*ldx_)) * ((0))] = temp_ * x_[0 + ((*ldx_)) * ((0))];
          x_[1 + ((*ldx_)) * ((0))] = temp_ * x_[1 + ((*ldx_)) * ((0))];
          (*xnorm_) = temp_ * (*xnorm_);
          (*scale_) = temp_ * (*scale_);
        }
      }
    }
    else {
      ci_[0] = -(*wi_) * (*d1_);
      ci_[1] = 0.0;
      ci_[2] = 0.0;
      ci_[3] = -(*wi_) * (*d2_);
      cmax_ = 0.0;
      icmax_ = 0;
      for (j_ = 1; j_ <= 4; (j_)++) {
        if (_abs (crv_[j_ - 1]) + _abs (civ_[j_ - 1]) > cmax_) {
          cmax_ = _abs (crv_[j_ - 1]) + _abs (civ_[j_ - 1]);
          icmax_ = j_;
        }
      }
      if (cmax_ < smini_) {
        bnorm_ = _max (_abs (b_[0 + ((*ldb_)) * ((0))]) + _abs (b_[0 + ((*ldb_)) * ((1))]), _abs (b_[1 + ((*ldb_)) * ((0))]) + 
        _abs (b_[1 + ((*ldb_)) * ((1))]));
        if (smini_ < 1.0 && bnorm_ > 1.0) {
          if (bnorm_ > bignum_ * smini_) {
            (*scale_) = 1.0 / bnorm_;
          }
        }
        temp_ = (*scale_) / smini_;
        x_[0 + ((*ldx_)) * ((0))] = temp_ * b_[0 + ((*ldb_)) * ((0))];
        x_[1 + ((*ldx_)) * ((0))] = temp_ * b_[1 + ((*ldb_)) * ((0))];
        x_[0 + ((*ldx_)) * ((1))] = temp_ * b_[0 + ((*ldb_)) * ((1))];
        x_[1 + ((*ldx_)) * ((1))] = temp_ * b_[1 + ((*ldb_)) * ((1))];
        (*xnorm_) = temp_ * bnorm_;
        (*info_) = 1;
        goto _l0;
      }
      ur11_ = crv_[icmax_ - 1];
      ui11_ = civ_[icmax_ - 1];
      cr21_ = crv_[ipivot_[1 + (4) * ((icmax_ - 1))] - 1];
      ci21_ = civ_[ipivot_[1 + (4) * ((icmax_ - 1))] - 1];
      ur12_ = crv_[ipivot_[2 + (4) * ((icmax_ - 1))] - 1];
      ui12_ = civ_[ipivot_[2 + (4) * ((icmax_ - 1))] - 1];
      cr22_ = crv_[ipivot_[3 + (4) * ((icmax_ - 1))] - 1];
      ci22_ = civ_[ipivot_[3 + (4) * ((icmax_ - 1))] - 1];
      if (icmax_ == 1 || icmax_ == 4) {
        if (_abs (ur11_) > _abs (ui11_)) {
          temp_ = ui11_ / ur11_;
          ur11r_ = 1.0 / (ur11_ * (1.0 + (temp_ * temp_)));
          ui11r_ = -temp_ * ur11r_;
        }
        else {
          temp_ = ur11_ / ui11_;
          ui11r_ = -1.0 / (ui11_ * (1.0 + (temp_ * temp_)));
          ur11r_ = -temp_ * ui11r_;
        }
        lr21_ = cr21_ * ur11r_;
        li21_ = cr21_ * ui11r_;
        ur12s_ = ur12_ * ur11r_;
        ui12s_ = ur12_ * ui11r_;
        ur22_ = cr22_ - ur12_ * lr21_;
        ui22_ = ci22_ - ur12_ * li21_;
      }
      else {
        ur11r_ = 1.0 / ur11_;
        ui11r_ = 0.0;
        lr21_ = cr21_ * ur11r_;
        li21_ = ci21_ * ur11r_;
        ur12s_ = ur12_ * ur11r_;
        ui12s_ = ui12_ * ur11r_;
        ur22_ = cr22_ - ur12_ * lr21_ + ui12_ * li21_;
        ui22_ = -ur12_ * li21_ - ui12_ * lr21_;
      }
      u22abs_ = _abs (ur22_) + _abs (ui22_);
      if (u22abs_ < smini_) {
        ur22_ = smini_;
        ui22_ = 0.0;
        (*info_) = 1;
      }
      if (rswap_[icmax_ - 1]) {
        br2_ = b_[0 + ((*ldb_)) * ((0))];
        br1_ = b_[1 + ((*ldb_)) * ((0))];
        bi2_ = b_[0 + ((*ldb_)) * ((1))];
        bi1_ = b_[1 + ((*ldb_)) * ((1))];
      }
      else {
        br1_ = b_[0 + ((*ldb_)) * ((0))];
        br2_ = b_[1 + ((*ldb_)) * ((0))];
        bi1_ = b_[0 + ((*ldb_)) * ((1))];
        bi2_ = b_[1 + ((*ldb_)) * ((1))];
      }
      br2_ = br2_ - lr21_ * br1_ + li21_ * bi1_;
      bi2_ = bi2_ - li21_ * br1_ - lr21_ * bi1_;
      bbnd_ = _max ((_abs (br1_) + _abs (bi1_)) * (u22abs_ * (_abs (ur11r_) + _abs (ui11r_))), _abs (br2_) + _abs (bi2_));
      if (bbnd_ > 1.0 && u22abs_ < 1.0) {
        if (bbnd_ >= bignum_ * u22abs_) {
          (*scale_) = 1.0 / bbnd_;
          br1_ = (*scale_) * br1_;
          bi1_ = (*scale_) * bi1_;
          br2_ = (*scale_) * br2_;
          bi2_ = (*scale_) * bi2_;
        }
      }
      (void) _dladiv (&br2_, &bi2_, &ur22_, &ui22_, &xr2_, &xi2_);
      xr1_ = ur11r_ * br1_ - ui11r_ * bi1_ - ur12s_ * xr2_ + ui12s_ * xi2_;
      xi1_ = ui11r_ * br1_ + ur11r_ * bi1_ - ui12s_ * xr2_ - ur12s_ * xi2_;
      if (zswap_[icmax_ - 1]) {
        x_[0 + ((*ldx_)) * ((0))] = xr2_;
        x_[1 + ((*ldx_)) * ((0))] = xr1_;
        x_[0 + ((*ldx_)) * ((1))] = xi2_;
        x_[1 + ((*ldx_)) * ((1))] = xi1_;
      }
      else {
        x_[0 + ((*ldx_)) * ((0))] = xr1_;
        x_[1 + ((*ldx_)) * ((0))] = xr2_;
        x_[0 + ((*ldx_)) * ((1))] = xi1_;
        x_[1 + ((*ldx_)) * ((1))] = xi2_;
      }
      (*xnorm_) = _max (_abs (xr1_) + _abs (xi1_), _abs (xr2_) + _abs (xi2_));
      if ((*xnorm_) > 1.0 && cmax_ > 1.0) {
        if ((*xnorm_) > bignum_ / cmax_) {
          temp_ = cmax_ / bignum_;
          x_[0 + ((*ldx_)) * ((0))] = temp_ * x_[0 + ((*ldx_)) * ((0))];
          x_[1 + ((*ldx_)) * ((0))] = temp_ * x_[1 + ((*ldx_)) * ((0))];
          x_[0 + ((*ldx_)) * ((1))] = temp_ * x_[0 + ((*ldx_)) * ((1))];
          x_[1 + ((*ldx_)) * ((1))] = temp_ * x_[1 + ((*ldx_)) * ((1))];
          (*xnorm_) = temp_ * (*xnorm_);
          (*scale_) = temp_ * (*scale_);
        }
      }
    }
  }
  _l0:;
  __calls[41].calls++;
  return 0;
}

real_8 _dlanhs (char _p_ norm_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ work_)
{
  static int_4 i_, j_;
  static real_8 scale_, sum_, value_;
  int_4 $0_;
  real_8 dlanhs_;
  extern int_4 _dlassq ();
  extern logical_4 _lsame ();
  if ((*n_) == 0) {
    value_ = 0.0;
  }
  else if (_lsame (norm_, _dc_23)) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        value_ = _max (value_, _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]));
      }
    }
  }
  else if ((_lsame (norm_, _dc_24)) || ((strcmp (norm_, _dc_22) == 0))) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = 0.0;
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        sum_ = sum_ + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
      value_ = _max (value_, sum_);
    }
  }
  else if (_lsame (norm_, _dc_25)) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        work_[i_ - 1] = work_[i_ - 1] + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
    }
    value_ = 0.0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      value_ = _max (value_, work_[i_ - 1]);
    }
  }
  else if ((_lsame (norm_, _dc_26)) || (_lsame (norm_, _dc_27))) {
    scale_ = 0.0;
    sum_ = 1.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _dlassq (($0_ = _min ((*n_), j_ + 1), &$0_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &scale_, &sum_);
    }
    value_ = scale_ * sqrt (sum_);
  }
  dlanhs_ = value_;
  __calls[42].calls++;
  return dlanhs_;
}

int_4 _dlanv2 (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ d_, real_8 _p_ rt1r_, real_8 _p_ rt1i_, real_8 
_p_ rt2r_, real_8 _p_ rt2i_, real_8 _p_ cs_, real_8 _p_ sn_)
{
  static real_8 aa_, bb_, cc_, cs1_, dd_, p_, sab_, sac_, sigma_, sn1_, tau_, temp_;
  extern real_8 _dlapy2 ();
  (*cs_) = 1.0;
  (*sn_) = 0.0;
  if ((*c_) == 0.0) {
    goto _l10;
  }
  else if ((*b_) == 0.0) {
    (*cs_) = 0.0;
    (*sn_) = 1.0;
    temp_ = (*d_);
    (*d_) = (*a_);
    (*a_) = temp_;
    (*b_) = -(*c_);
    (*c_) = 0.0;
    goto _l10;
  }
  else if (((*a_) - (*d_)) == 0.0 && _sign (1.0, (*b_)) != _sign (1.0, (*c_))) {
    goto _l10;
  }
  else {
    temp_ = (*a_) - (*d_);
    p_ = 0.5 * temp_;
    sigma_ = (*b_) + (*c_);
    tau_ = _dlapy2 (&sigma_, &temp_);
    cs1_ = sqrt (0.5 * (1.0 + _abs (sigma_) / tau_));
    sn1_ = -(p_ / (tau_ * cs1_)) * _sign (1.0, sigma_);
    aa_ = (*a_) * cs1_ + (*b_) * sn1_;
    bb_ = -(*a_) * sn1_ + (*b_) * cs1_;
    cc_ = (*c_) * cs1_ + (*d_) * sn1_;
    dd_ = -(*c_) * sn1_ + (*d_) * cs1_;
    (*a_) = aa_ * cs1_ + cc_ * sn1_;
    (*b_) = bb_ * cs1_ + dd_ * sn1_;
    (*c_) = -aa_ * sn1_ + cc_ * cs1_;
    (*d_) = -bb_ * sn1_ + dd_ * cs1_;
    temp_ = (*cs_) * cs1_ - (*sn_) * sn1_;
    (*sn_) = (*cs_) * sn1_ + (*sn_) * cs1_;
    (*cs_) = temp_;
    temp_ = 0.5 * ((*a_) + (*d_));
    (*a_) = temp_;
    (*d_) = temp_;
    if ((*c_) != 0.0) {
      if ((*b_) != 0.0) {
        if (_sign (1.0, (*b_)) == _sign (1.0, (*c_))) {
          sab_ = sqrt (_abs ((*b_)));
          sac_ = sqrt (_abs ((*c_)));
          p_ = _sign (sab_ * sac_, (*c_));
          tau_ = 1.0 / sqrt (_abs ((*b_) + (*c_)));
          (*a_) = temp_ + p_;
          (*d_) = temp_ - p_;
          (*b_) = (*b_) - (*c_);
          (*c_) = 0.0;
          cs1_ = sab_ * tau_;
          sn1_ = sac_ * tau_;
          temp_ = (*cs_) * cs1_ - (*sn_) * sn1_;
          (*sn_) = (*cs_) * sn1_ + (*sn_) * cs1_;
          (*cs_) = temp_;
        }
      }
      else {
        (*b_) = -(*c_);
        (*c_) = 0.0;
        temp_ = (*cs_);
        (*cs_) = -(*sn_);
        (*sn_) = temp_;
      }
    }
  }
  _l10:;
  (*rt1r_) = (*a_);
  (*rt2r_) = (*d_);
  if ((*c_) == 0.0) {
    (*rt1i_) = 0.0;
    (*rt2i_) = 0.0;
  }
  else {
    (*rt1i_) = sqrt (_abs ((*b_))) * sqrt (_abs ((*c_)));
    (*rt2i_) = -(*rt1i_);
  }
  __calls[43].calls++;
  return 0;
}

int_4 _dlaptm (int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ alpha_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ x_, int_4 _p_ 
ldx_, real_8 _p_ beta_, real_8 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, j_;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*beta_) == 0.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = 0.0;
      }
    }
  }
  else if ((*beta_) == -1.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = -b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
      }
    }
  }
  if ((*alpha_) == 1.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      if ((*n_) == 1) {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
      }
      else {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] + e_[0] * x_[1 
        + ((*ldx_)) * ((j_ - 1))];
        b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] + e_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
        + ((*ldx_)) * ((j_ - 1))] + d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
        for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + e_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
          * ((j_ - 1))] + d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + e_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 1))]
          ;
        }
      }
    }
  }
  else if ((*alpha_) == -1.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      if ((*n_) == 1) {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
      }
      else {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] - e_[0] * x_[1 
        + ((*ldx_)) * ((j_ - 1))];
        b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] - e_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
        + ((*ldx_)) * ((j_ - 1))] - d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
        for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - e_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
          * ((j_ - 1))] - d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] - e_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 1))]
          ;
        }
      }
    }
  }
  _l0:;
  __calls[44].calls++;
  return 0;
}

real_8 _dlapy3 (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ z_)
{
  static real_8 w_, xabs_, yabs_, zabs_;
  real_8 $0_, $1_, $2_, $3_;
  real_8 dlapy3_;
  xabs_ = _abs ((*x_));
  yabs_ = _abs ((*y_));
  zabs_ = _abs ((*z_));
  w_ = ($0_ = _max (xabs_, yabs_), _max ($0_, zabs_));
  if (w_ == 0.0) {
    dlapy3_ = 0.0;
  }
  else {
    dlapy3_ = w_ * sqrt (($1_ = (xabs_ / w_), $1_ * $1_) + ($2_ = (yabs_ / w_), $2_ * $2_) + ($3_ = (zabs_ / w_), $3_ * 
    $3_));
  }
  __calls[45].calls++;
  return dlapy3_;
}

real_8 _dlaran (int_4 _p_ iseed_)
{
  static int_4 it1_, it2_, it3_, it4_;
  real_8 dlaran_;
  it4_ = iseed_[3] * 2549;
  it3_ = it4_ / 4096;
  it4_ = it4_ - 4096 * it3_;
  it3_ = it3_ + iseed_[2] * 2549 + iseed_[3] * 2508;
  it2_ = it3_ / 4096;
  it3_ = it3_ - 4096 * it2_;
  it2_ = it2_ + iseed_[1] * 2549 + iseed_[2] * 2508 + iseed_[3] * 322;
  it1_ = it2_ / 4096;
  it2_ = it2_ - 4096 * it1_;
  it1_ = it1_ + iseed_[0] * 2549 + iseed_[1] * 2508 + iseed_[2] * 322 + iseed_[3] * 494;
  it1_ = _imod (it1_, 4096);
  iseed_[0] = it1_;
  iseed_[1] = it2_;
  iseed_[2] = it3_;
  iseed_[3] = it4_;
  dlaran_ = 2.44140625e-4 * ((real_8) (it1_) + 2.44140625e-4 * ((real_8) (it2_) + 2.44140625e-4 * ((real_8) (it3_) + 
  2.44140625e-4 * ((real_8) (it4_)))));
  __calls[46].calls++;
  return dlaran_;
}

int_4 _dlarfx (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ 
ldc_, real_8 _p_ work_)
{
  static int_4 j_;
  static real_8 sum_, t1_, t10_, t2_, t3_, t4_, t5_, t6_, t7_, t8_, t9_, v1_, v10_, v2_, v3_, v4_, v5_, v6_, v7_, v8_, 
  v9_;
  real_8 $0_, $1_, $2_, $3_, $4_, $5_;
  extern logical_4 _lsame ();
  extern int_4 _dgemv ();
  extern int_4 _dger ();
  if ((*tau_) == 0.0) {
    goto _l0;
  }
  if (_lsame (side_, _dc_20)) {
    switch ((*m_)) {
      default:
      case 1: goto _l10;
      case 2: goto _l30;
      case 3: goto _l50;
      case 4: goto _l70;
      case 5: goto _l90;
      case 6: goto _l110;
      case 7: goto _l130;
      case 8: goto _l150;
      case 9: goto _l170;
      case 10: goto _l190;
    }
    (void) _dgemv (_dc_13, m_, n_, ($0_ = 1.0, &$0_), c_, ldc_, v_, &_k1, ($1_ = 0.0, &$1_), work_, &_k1);
    (void) _dger (m_, n_, ($2_ = -(*tau_), &$2_), v_, &_k1, work_, &_k1, c_, ldc_);
    goto _l410;
    _l10:;
    t1_ = 1.0 - (*tau_) * v_[0] * v_[0];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      c_[0 + ((*ldc_)) * ((j_ - 1))] = t1_ * c_[0 + ((*ldc_)) * ((j_ - 1))];
    }
    goto _l410;
    _l30:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
    }
    goto _l410;
    _l50:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
    }
    goto _l410;
    _l70:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
    }
    goto _l410;
    _l90:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
    }
    goto _l410;
    _l110:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
    }
    goto _l410;
    _l130:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))] + v7_ * c_[6 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
      c_[6 + ((*ldc_)) * ((j_ - 1))] = c_[6 + ((*ldc_)) * ((j_ - 1))] - sum_ * t7_;
    }
    goto _l410;
    _l150:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))] + v7_ * c_[6 + ((*ldc_)) * ((j_ - 1))] + v8_ * c_[7 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
      c_[6 + ((*ldc_)) * ((j_ - 1))] = c_[6 + ((*ldc_)) * ((j_ - 1))] - sum_ * t7_;
      c_[7 + ((*ldc_)) * ((j_ - 1))] = c_[7 + ((*ldc_)) * ((j_ - 1))] - sum_ * t8_;
    }
    goto _l410;
    _l170:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    v9_ = v_[8];
    t9_ = (*tau_) * v9_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))] + v7_ * c_[6 + ((*ldc_)) * ((j_ - 1))] + v8_ * c_[7 + ((*ldc_)) * ((j_ - 1))] + v9_ * c_[8 + ((*ldc_)) * ((j_ - 
      1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
      c_[6 + ((*ldc_)) * ((j_ - 1))] = c_[6 + ((*ldc_)) * ((j_ - 1))] - sum_ * t7_;
      c_[7 + ((*ldc_)) * ((j_ - 1))] = c_[7 + ((*ldc_)) * ((j_ - 1))] - sum_ * t8_;
      c_[8 + ((*ldc_)) * ((j_ - 1))] = c_[8 + ((*ldc_)) * ((j_ - 1))] - sum_ * t9_;
    }
    goto _l410;
    _l190:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    v9_ = v_[8];
    t9_ = (*tau_) * v9_;
    v10_ = v_[9];
    t10_ = (*tau_) * v10_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))] + v7_ * c_[6 + ((*ldc_)) * ((j_ - 1))] + v8_ * c_[7 + ((*ldc_)) * ((j_ - 1))] + v9_ * c_[8 + ((*ldc_)) * ((j_ - 
      1))] + v10_ * c_[9 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
      c_[6 + ((*ldc_)) * ((j_ - 1))] = c_[6 + ((*ldc_)) * ((j_ - 1))] - sum_ * t7_;
      c_[7 + ((*ldc_)) * ((j_ - 1))] = c_[7 + ((*ldc_)) * ((j_ - 1))] - sum_ * t8_;
      c_[8 + ((*ldc_)) * ((j_ - 1))] = c_[8 + ((*ldc_)) * ((j_ - 1))] - sum_ * t9_;
      c_[9 + ((*ldc_)) * ((j_ - 1))] = c_[9 + ((*ldc_)) * ((j_ - 1))] - sum_ * t10_;
    }
    goto _l410;
  }
  else {
    switch ((*n_)) {
      default:
      case 1: goto _l210;
      case 2: goto _l230;
      case 3: goto _l250;
      case 4: goto _l270;
      case 5: goto _l290;
      case 6: goto _l310;
      case 7: goto _l330;
      case 8: goto _l350;
      case 9: goto _l370;
      case 10: goto _l390;
    }
    (void) _dgemv (_dc_5, m_, n_, ($3_ = 1.0, &$3_), c_, ldc_, v_, &_k1, ($4_ = 0.0, &$4_), work_, &_k1);
    (void) _dger (m_, n_, ($5_ = -(*tau_), &$5_), work_, &_k1, v_, &_k1, c_, ldc_);
    goto _l410;
    _l210:;
    t1_ = 1.0 - (*tau_) * v_[0] * v_[0];
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      c_[j_ - 1 + ((*ldc_)) * ((0))] = t1_ * c_[j_ - 1 + ((*ldc_)) * ((0))];
    }
    goto _l410;
    _l230:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
    }
    goto _l410;
    _l250:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
    }
    goto _l410;
    _l270:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
    }
    goto _l410;
    _l290:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
    }
    goto _l410;
    _l310:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
    }
    goto _l410;
    _l330:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))] + v7_ * c_[j_ - 1 + ((*ldc_)) * ((6))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
      c_[j_ - 1 + ((*ldc_)) * ((6))] = c_[j_ - 1 + ((*ldc_)) * ((6))] - sum_ * t7_;
    }
    goto _l410;
    _l350:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))] + v7_ * c_[j_ - 1 + ((*ldc_)) * ((6))] + v8_ * c_[j_ - 1 + ((*ldc_)) * ((7))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
      c_[j_ - 1 + ((*ldc_)) * ((6))] = c_[j_ - 1 + ((*ldc_)) * ((6))] - sum_ * t7_;
      c_[j_ - 1 + ((*ldc_)) * ((7))] = c_[j_ - 1 + ((*ldc_)) * ((7))] - sum_ * t8_;
    }
    goto _l410;
    _l370:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    v9_ = v_[8];
    t9_ = (*tau_) * v9_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))] + v7_ * c_[j_ - 1 + ((*ldc_)) * ((6))] + v8_ * c_[j_ - 1 + ((*ldc_)) * ((7))] + v9_ * c_[j_ - 1 + ((*ldc_)) * 
      ((8))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
      c_[j_ - 1 + ((*ldc_)) * ((6))] = c_[j_ - 1 + ((*ldc_)) * ((6))] - sum_ * t7_;
      c_[j_ - 1 + ((*ldc_)) * ((7))] = c_[j_ - 1 + ((*ldc_)) * ((7))] - sum_ * t8_;
      c_[j_ - 1 + ((*ldc_)) * ((8))] = c_[j_ - 1 + ((*ldc_)) * ((8))] - sum_ * t9_;
    }
    goto _l410;
    _l390:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    v9_ = v_[8];
    t9_ = (*tau_) * v9_;
    v10_ = v_[9];
    t10_ = (*tau_) * v10_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))] + v7_ * c_[j_ - 1 + ((*ldc_)) * ((6))] + v8_ * c_[j_ - 1 + ((*ldc_)) * ((7))] + v9_ * c_[j_ - 1 + ((*ldc_)) * 
      ((8))] + v10_ * c_[j_ - 1 + ((*ldc_)) * ((9))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
      c_[j_ - 1 + ((*ldc_)) * ((6))] = c_[j_ - 1 + ((*ldc_)) * ((6))] - sum_ * t7_;
      c_[j_ - 1 + ((*ldc_)) * ((7))] = c_[j_ - 1 + ((*ldc_)) * ((7))] - sum_ * t8_;
      c_[j_ - 1 + ((*ldc_)) * ((8))] = c_[j_ - 1 + ((*ldc_)) * ((8))] - sum_ * t9_;
      c_[j_ - 1 + ((*ldc_)) * ((9))] = c_[j_ - 1 + ((*ldc_)) * ((9))] - sum_ * t10_;
    }
    goto _l410;
  }
  _l410:;
  _l0:;
  __calls[47].calls++;
  return 0;
}

real_8 _dlarnd (int_4 _p_ idist_, int_4 _p_ iseed_)
{
  static real_8 t1_, t2_;
  real_8 dlarnd_;
  t1_ = _dlaran (iseed_);
  if ((*idist_) == 1) {
    dlarnd_ = t1_;
  }
  else if ((*idist_) == 2) {
    dlarnd_ = 2.0 * t1_ - 1.0;
  }
  else if ((*idist_) == 3) {
    t2_ = _dlaran (iseed_);
    dlarnd_ = sqrt (-2.0 * log (t1_)) * cos (6.2831853071795865 * t2_);
  }
  __calls[48].calls++;
  return dlarnd_;
}

int_4 _dlarnv (int_4 _p_ idist_, int_4 _p_ iseed_, int_4 _p_ n_, real_8 _p_ x_)
{
  static int_4 i_, il_, il2_, iv_;
  static real_8 u_[128];
  for (iv_ = 1; (64 > 0 ? iv_ <= (*n_) : iv_ >= (*n_)); iv_ += 64) {
    il_ = _min (64, (*n_) - iv_ + 1);
    if ((*idist_) == 3) {
      il2_ = 2 * il_;
    }
    else {
      il2_ = il_;
    }
    (void) _dlaruv (iseed_, &il2_, u_);
    if ((*idist_) == 1) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = u_[i_ - 1];
      }
    }
    else if ((*idist_) == 2) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = 2.0 * u_[i_ - 1] - 1.0;
      }
    }
    else if ((*idist_) == 3) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = sqrt (-2.0 * log (u_[2 * i_ - 1 - 1])) * cos (6.2831853071795865 * u_[2 * i_ - 1]);
      }
    }
  }
  __calls[49].calls++;
  return 0;
}

int_4 _dlaruv (int_4 _p_ iseed_, int_4 _p_ n_, real_8 _p_ x_)
{
  static int_4 i_, i1_, i2_, i3_, i4_, it1_, it2_, it3_, it4_, j_, mm_[512];
  int_4 _data_k_3, _data_k_4, _data_k_5, _data_k_6, _data_k_7, _data_k_8, _data_k_9, _data_k_10, _data_k_11, _data_k_12, 
  _data_k_13, _data_k_14, _data_k_15, _data_k_16, _data_k_17, _data_k_18, _data_k_19, _data_k_20, _data_k_21, _data_k_22, 
  _data_k_23, _data_k_24, _data_k_25, _data_k_26, _data_k_27, _data_k_28, _data_k_29, _data_k_30, _data_k_31, _data_k_32, 
  _data_k_33, _data_k_34, _data_k_35, _data_k_36, _data_k_37, _data_k_38, _data_k_39, _data_k_40, _data_k_41, _data_k_42, 
  _data_k_43, _data_k_44, _data_k_45, _data_k_46, _data_k_47, _data_k_48, _data_k_49, _data_k_50, _data_k_51, _data_k_52, 
  _data_k_53, _data_k_54, _data_k_55, _data_k_56, _data_k_57, _data_k_58, _data_k_59, _data_k_60, _data_k_61, _data_k_62, 
  _data_k_63, _data_k_64, _data_k_65, _data_k_66, _data_k_67, _data_k_68, _data_k_69, _data_k_70, _data_k_71, _data_k_72, 
  _data_k_73, _data_k_74, _data_k_75, _data_k_76, _data_k_77, _data_k_78, _data_k_79, _data_k_80, _data_k_81, _data_k_82, 
  _data_k_83, _data_k_84, _data_k_85, _data_k_86, _data_k_87, _data_k_88, _data_k_89, _data_k_90, _data_k_91, _data_k_92, 
  _data_k_93, _data_k_94, _data_k_95, _data_k_96, _data_k_97, _data_k_98, _data_k_99, _data_k_100, _data_k_101, 
  _data_k_102, _data_k_103, _data_k_104, _data_k_105, _data_k_106, _data_k_107, _data_k_108, _data_k_109, _data_k_110, 
  _data_k_111, _data_k_112, _data_k_113, _data_k_114, _data_k_115, _data_k_116, _data_k_117, _data_k_118, _data_k_119, 
  _data_k_120, _data_k_121, _data_k_122, _data_k_123, _data_k_124, _data_k_125, _data_k_126, _data_k_127, _data_k_128, 
  _data_k_129, _data_k_130;
#define _data_n_3 4
  static int_4 _data_l_3[_data_n_3] = {
    494,
    322,
    2508,
    2549
  };
#define _data_n_4 4
  static int_4 _data_l_4[_data_n_4] = {
    2637,
    789,
    3754,
    1145
  };
#define _data_n_5 4
  static int_4 _data_l_5[_data_n_5] = {
    255,
    1440,
    1766,
    2253
  };
#define _data_n_6 4
  static int_4 _data_l_6[_data_n_6] = {
    2008,
    752,
    3572,
    305
  };
#define _data_n_7 4
  static int_4 _data_l_7[_data_n_7] = {
    1253,
    2859,
    2893,
    3301
  };
#define _data_n_8 4
  static int_4 _data_l_8[_data_n_8] = {
    3344,
    123,
    307,
    1065
  };
#define _data_n_9 4
  static int_4 _data_l_9[_data_n_9] = {
    4084,
    1848,
    1297,
    3133
  };
#define _data_n_10 4
  static int_4 _data_l_10[_data_n_10] = {
    1739,
    643,
    3966,
    2913
  };
#define _data_n_11 4
  static int_4 _data_l_11[_data_n_11] = {
    3143,
    2405,
    758,
    3285
  };
#define _data_n_12 4
  static int_4 _data_l_12[_data_n_12] = {
    3468,
    2638,
    2598,
    1241
  };
#define _data_n_13 4
  static int_4 _data_l_13[_data_n_13] = {
    688,
    2344,
    3406,
    1197
  };
#define _data_n_14 4
  static int_4 _data_l_14[_data_n_14] = {
    1657,
    46,
    2922,
    3729
  };
#define _data_n_15 4
  static int_4 _data_l_15[_data_n_15] = {
    1238,
    3814,
    1038,
    2501
  };
#define _data_n_16 4
  static int_4 _data_l_16[_data_n_16] = {
    3166,
    913,
    2934,
    1673
  };
#define _data_n_17 4
  static int_4 _data_l_17[_data_n_17] = {
    1292,
    3649,
    2091,
    541
  };
#define _data_n_18 4
  static int_4 _data_l_18[_data_n_18] = {
    3422,
    339,
    2451,
    2753
  };
#define _data_n_19 4
  static int_4 _data_l_19[_data_n_19] = {
    1270,
    3808,
    1580,
    949
  };
#define _data_n_20 4
  static int_4 _data_l_20[_data_n_20] = {
    2016,
    822,
    1958,
    2361
  };
#define _data_n_21 4
  static int_4 _data_l_21[_data_n_21] = {
    154,
    2832,
    2055,
    1165
  };
#define _data_n_22 4
  static int_4 _data_l_22[_data_n_22] = {
    2862,
    3078,
    1507,
    4081
  };
#define _data_n_23 4
  static int_4 _data_l_23[_data_n_23] = {
    697,
    3633,
    1078,
    2725
  };
#define _data_n_24 4
  static int_4 _data_l_24[_data_n_24] = {
    1706,
    2970,
    3273,
    3305
  };
#define _data_n_25 4
  static int_4 _data_l_25[_data_n_25] = {
    491,
    637,
    17,
    3069
  };
#define _data_n_26 4
  static int_4 _data_l_26[_data_n_26] = {
    931,
    2249,
    854,
    3617
  };
#define _data_n_27 4
  static int_4 _data_l_27[_data_n_27] = {
    1444,
    2081,
    2916,
    3733
  };
#define _data_n_28 4
  static int_4 _data_l_28[_data_n_28] = {
    444,
    4019,
    3971,
    409
  };
#define _data_n_29 4
  static int_4 _data_l_29[_data_n_29] = {
    3577,
    1478,
    2889,
    2157
  };
#define _data_n_30 4
  static int_4 _data_l_30[_data_n_30] = {
    3944,
    242,
    3831,
    1361
  };
#define _data_n_31 4
  static int_4 _data_l_31[_data_n_31] = {
    2184,
    481,
    2621,
    3973
  };
#define _data_n_32 4
  static int_4 _data_l_32[_data_n_32] = {
    1661,
    2075,
    1541,
    1865
  };
#define _data_n_33 4
  static int_4 _data_l_33[_data_n_33] = {
    3482,
    4058,
    893,
    2525
  };
#define _data_n_34 4
  static int_4 _data_l_34[_data_n_34] = {
    657,
    622,
    736,
    1409
  };
#define _data_n_35 4
  static int_4 _data_l_35[_data_n_35] = {
    3023,
    3376,
    3992,
    3445
  };
#define _data_n_36 4
  static int_4 _data_l_36[_data_n_36] = {
    3618,
    812,
    787,
    3577
  };
#define _data_n_37 4
  static int_4 _data_l_37[_data_n_37] = {
    1267,
    234,
    2125,
    77
  };
#define _data_n_38 4
  static int_4 _data_l_38[_data_n_38] = {
    1828,
    641,
    2364,
    3761
  };
#define _data_n_39 4
  static int_4 _data_l_39[_data_n_39] = {
    164,
    4005,
    2460,
    2149
  };
#define _data_n_40 4
  static int_4 _data_l_40[_data_n_40] = {
    3798,
    1122,
    257,
    1449
  };
#define _data_n_41 4
  static int_4 _data_l_41[_data_n_41] = {
    3087,
    3135,
    1574,
    3005
  };
#define _data_n_42 4
  static int_4 _data_l_42[_data_n_42] = {
    2400,
    2640,
    3912,
    225
  };
#define _data_n_43 4
  static int_4 _data_l_43[_data_n_43] = {
    2870,
    2302,
    1216,
    85
  };
#define _data_n_44 4
  static int_4 _data_l_44[_data_n_44] = {
    3876,
    40,
    3248,
    3673
  };
#define _data_n_45 4
  static int_4 _data_l_45[_data_n_45] = {
    1905,
    1832,
    3401,
    3117
  };
#define _data_n_46 4
  static int_4 _data_l_46[_data_n_46] = {
    1593,
    2247,
    2124,
    3089
  };
#define _data_n_47 4
  static int_4 _data_l_47[_data_n_47] = {
    1797,
    2034,
    2762,
    1349
  };
#define _data_n_48 4
  static int_4 _data_l_48[_data_n_48] = {
    1234,
    2637,
    149,
    2057
  };
#define _data_n_49 4
  static int_4 _data_l_49[_data_n_49] = {
    3460,
    1287,
    2245,
    413
  };
#define _data_n_50 4
  static int_4 _data_l_50[_data_n_50] = {
    328,
    1691,
    166,
    65
  };
#define _data_n_51 4
  static int_4 _data_l_51[_data_n_51] = {
    2861,
    496,
    466,
    1845
  };
#define _data_n_52 4
  static int_4 _data_l_52[_data_n_52] = {
    1950,
    1597,
    4018,
    697
  };
#define _data_n_53 4
  static int_4 _data_l_53[_data_n_53] = {
    617,
    2394,
    1399,
    3085
  };
#define _data_n_54 4
  static int_4 _data_l_54[_data_n_54] = {
    2070,
    2584,
    190,
    3441
  };
#define _data_n_55 4
  static int_4 _data_l_55[_data_n_55] = {
    3331,
    1843,
    2879,
    1573
  };
#define _data_n_56 4
  static int_4 _data_l_56[_data_n_56] = {
    769,
    336,
    153,
    3689
  };
#define _data_n_57 4
  static int_4 _data_l_57[_data_n_57] = {
    1558,
    1472,
    2320,
    2941
  };
#define _data_n_58 4
  static int_4 _data_l_58[_data_n_58] = {
    2412,
    2407,
    18,
    929
  };
#define _data_n_59 4
  static int_4 _data_l_59[_data_n_59] = {
    2800,
    433,
    712,
    533
  };
#define _data_n_60 4
  static int_4 _data_l_60[_data_n_60] = {
    189,
    2096,
    2159,
    2841
  };
#define _data_n_61 4
  static int_4 _data_l_61[_data_n_61] = {
    287,
    1761,
    2318,
    4077
  };
#define _data_n_62 4
  static int_4 _data_l_62[_data_n_62] = {
    2045,
    2810,
    2091,
    721
  };
#define _data_n_63 4
  static int_4 _data_l_63[_data_n_63] = {
    1227,
    566,
    3443,
    2821
  };
#define _data_n_64 4
  static int_4 _data_l_64[_data_n_64] = {
    2838,
    442,
    1510,
    2249
  };
#define _data_n_65 4
  static int_4 _data_l_65[_data_n_65] = {
    209,
    41,
    449,
    2397
  };
#define _data_n_66 4
  static int_4 _data_l_66[_data_n_66] = {
    2770,
    1238,
    1956,
    2817
  };
#define _data_n_67 4
  static int_4 _data_l_67[_data_n_67] = {
    3654,
    1086,
    2201,
    245
  };
#define _data_n_68 4
  static int_4 _data_l_68[_data_n_68] = {
    3993,
    603,
    3137,
    1913
  };
#define _data_n_69 4
  static int_4 _data_l_69[_data_n_69] = {
    192,
    840,
    3399,
    1997
  };
#define _data_n_70 4
  static int_4 _data_l_70[_data_n_70] = {
    2253,
    3168,
    1321,
    3121
  };
#define _data_n_71 4
  static int_4 _data_l_71[_data_n_71] = {
    3491,
    1499,
    2271,
    997
  };
#define _data_n_72 4
  static int_4 _data_l_72[_data_n_72] = {
    2889,
    1084,
    3667,
    1833
  };
#define _data_n_73 4
  static int_4 _data_l_73[_data_n_73] = {
    2857,
    3438,
    2703,
    2877
  };
#define _data_n_74 4
  static int_4 _data_l_74[_data_n_74] = {
    2094,
    2408,
    629,
    1633
  };
#define _data_n_75 4
  static int_4 _data_l_75[_data_n_75] = {
    1818,
    1589,
    2365,
    981
  };
#define _data_n_76 4
  static int_4 _data_l_76[_data_n_76] = {
    688,
    2391,
    2431,
    2009
  };
#define _data_n_77 4
  static int_4 _data_l_77[_data_n_77] = {
    1407,
    288,
    1113,
    941
  };
#define _data_n_78 4
  static int_4 _data_l_78[_data_n_78] = {
    634,
    26,
    3922,
    2449
  };
#define _data_n_79 4
  static int_4 _data_l_79[_data_n_79] = {
    3231,
    512,
    2554,
    197
  };
#define _data_n_80 4
  static int_4 _data_l_80[_data_n_80] = {
    815,
    1456,
    184,
    2441
  };
#define _data_n_81 4
  static int_4 _data_l_81[_data_n_81] = {
    3524,
    171,
    2099,
    285
  };
#define _data_n_82 4
  static int_4 _data_l_82[_data_n_82] = {
    1914,
    1677,
    3228,
    1473
  };
#define _data_n_83 4
  static int_4 _data_l_83[_data_n_83] = {
    516,
    2657,
    4012,
    2741
  };
#define _data_n_84 4
  static int_4 _data_l_84[_data_n_84] = {
    164,
    2270,
    1921,
    3129
  };
#define _data_n_85 4
  static int_4 _data_l_85[_data_n_85] = {
    303,
    2587,
    3452,
    909
  };
#define _data_n_86 4
  static int_4 _data_l_86[_data_n_86] = {
    2144,
    2961,
    3901,
    2801
  };
#define _data_n_87 4
  static int_4 _data_l_87[_data_n_87] = {
    3480,
    1970,
    572,
    421
  };
#define _data_n_88 4
  static int_4 _data_l_88[_data_n_88] = {
    119,
    1817,
    3309,
    4073
  };
#define _data_n_89 4
  static int_4 _data_l_89[_data_n_89] = {
    3357,
    676,
    3171,
    2813
  };
#define _data_n_90 4
  static int_4 _data_l_90[_data_n_90] = {
    837,
    1410,
    817,
    2337
  };
#define _data_n_91 4
  static int_4 _data_l_91[_data_n_91] = {
    2826,
    3723,
    3039,
    1429
  };
#define _data_n_92 4
  static int_4 _data_l_92[_data_n_92] = {
    2332,
    2803,
    1696,
    1177
  };
#define _data_n_93 4
  static int_4 _data_l_93[_data_n_93] = {
    2089,
    3185,
    1256,
    1901
  };
#define _data_n_94 4
  static int_4 _data_l_94[_data_n_94] = {
    3780,
    184,
    3715,
    81
  };
#define _data_n_95 4
  static int_4 _data_l_95[_data_n_95] = {
    1700,
    663,
    2077,
    1669
  };
#define _data_n_96 4
  static int_4 _data_l_96[_data_n_96] = {
    3712,
    499,
    3019,
    2633
  };
#define _data_n_97 4
  static int_4 _data_l_97[_data_n_97] = {
    150,
    3784,
    1497,
    2269
  };
#define _data_n_98 4
  static int_4 _data_l_98[_data_n_98] = {
    2000,
    1631,
    1101,
    129
  };
#define _data_n_99 4
  static int_4 _data_l_99[_data_n_99] = {
    3375,
    1925,
    717,
    1141
  };
#define _data_n_100 4
  static int_4 _data_l_100[_data_n_100] = {
    1621,
    3912,
    51,
    249
  };
#define _data_n_101 4
  static int_4 _data_l_101[_data_n_101] = {
    3090,
    1398,
    981,
    3917
  };
#define _data_n_102 4
  static int_4 _data_l_102[_data_n_102] = {
    3765,
    1349,
    1978,
    2481
  };
#define _data_n_103 4
  static int_4 _data_l_103[_data_n_103] = {
    1149,
    1441,
    1813,
    3941
  };
#define _data_n_104 4
  static int_4 _data_l_104[_data_n_104] = {
    3146,
    2224,
    3881,
    2217
  };
#define _data_n_105 4
  static int_4 _data_l_105[_data_n_105] = {
    33,
    2411,
    76,
    2749
  };
#define _data_n_106 4
  static int_4 _data_l_106[_data_n_106] = {
    3082,
    1907,
    3846,
    3041
  };
#define _data_n_107 4
  static int_4 _data_l_107[_data_n_107] = {
    2741,
    3192,
    3694,
    1877
  };
#define _data_n_108 4
  static int_4 _data_l_108[_data_n_108] = {
    359,
    2786,
    1682,
    345
  };
#define _data_n_109 4
  static int_4 _data_l_109[_data_n_109] = {
    3316,
    382,
    124,
    2861
  };
#define _data_n_110 4
  static int_4 _data_l_110[_data_n_110] = {
    1749,
    37,
    1660,
    1809
  };
#define _data_n_111 4
  static int_4 _data_l_111[_data_n_111] = {
    185,
    759,
    3997,
    3141
  };
#define _data_n_112 4
  static int_4 _data_l_112[_data_n_112] = {
    2784,
    2948,
    479,
    2825
  };
#define _data_n_113 4
  static int_4 _data_l_113[_data_n_113] = {
    2202,
    1862,
    1141,
    157
  };
#define _data_n_114 4
  static int_4 _data_l_114[_data_n_114] = {
    2199,
    3802,
    886,
    2881
  };
#define _data_n_115 4
  static int_4 _data_l_115[_data_n_115] = {
    1364,
    2423,
    3514,
    3637
  };
#define _data_n_116 4
  static int_4 _data_l_116[_data_n_116] = {
    1244,
    2051,
    1301,
    1465
  };
#define _data_n_117 4
  static int_4 _data_l_117[_data_n_117] = {
    2020,
    2295,
    3604,
    2829
  };
#define _data_n_118 4
  static int_4 _data_l_118[_data_n_118] = {
    3160,
    1332,
    1888,
    2161
  };
#define _data_n_119 4
  static int_4 _data_l_119[_data_n_119] = {
    2785,
    1832,
    1836,
    3365
  };
#define _data_n_120 4
  static int_4 _data_l_120[_data_n_120] = {
    2772,
    2405,
    1990,
    361
  };
#define _data_n_121 4
  static int_4 _data_l_121[_data_n_121] = {
    1217,
    3638,
    2058,
    2685
  };
#define _data_n_122 4
  static int_4 _data_l_122[_data_n_122] = {
    1822,
    3661,
    692,
    3745
  };
#define _data_n_123 4
  static int_4 _data_l_123[_data_n_123] = {
    1245,
    327,
    1194,
    2325
  };
#define _data_n_124 4
  static int_4 _data_l_124[_data_n_124] = {
    2252,
    3660,
    20,
    3609
  };
#define _data_n_125 4
  static int_4 _data_l_125[_data_n_125] = {
    3904,
    716,
    3285,
    3821
  };
#define _data_n_126 4
  static int_4 _data_l_126[_data_n_126] = {
    2774,
    1842,
    2046,
    3537
  };
#define _data_n_127 4
  static int_4 _data_l_127[_data_n_127] = {
    997,
    3987,
    2107,
    517
  };
#define _data_n_128 4
  static int_4 _data_l_128[_data_n_128] = {
    2573,
    1368,
    3508,
    3017
  };
#define _data_n_129 4
  static int_4 _data_l_129[_data_n_129] = {
    1148,
    1848,
    3525,
    2141
  };
#define _data_n_130 4
  static int_4 _data_l_130[_data_n_130] = {
    545,
    2366,
    3801,
    1537
  };
  if (__calls[50].calls == 0) {
    _data_k_3 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_3 >= _data_n_3) {
        _data_k_3 = 0;
      }
      mm_[0 + (128) * ((j_ - 1))] = _data_l_3[_data_k_3++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_4 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_4 >= _data_n_4) {
        _data_k_4 = 0;
      }
      mm_[1 + (128) * ((j_ - 1))] = _data_l_4[_data_k_4++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_5 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_5 >= _data_n_5) {
        _data_k_5 = 0;
      }
      mm_[2 + (128) * ((j_ - 1))] = _data_l_5[_data_k_5++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_6 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_6 >= _data_n_6) {
        _data_k_6 = 0;
      }
      mm_[3 + (128) * ((j_ - 1))] = _data_l_6[_data_k_6++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_7 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_7 >= _data_n_7) {
        _data_k_7 = 0;
      }
      mm_[4 + (128) * ((j_ - 1))] = _data_l_7[_data_k_7++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_8 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_8 >= _data_n_8) {
        _data_k_8 = 0;
      }
      mm_[5 + (128) * ((j_ - 1))] = _data_l_8[_data_k_8++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_9 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_9 >= _data_n_9) {
        _data_k_9 = 0;
      }
      mm_[6 + (128) * ((j_ - 1))] = _data_l_9[_data_k_9++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_10 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_10 >= _data_n_10) {
        _data_k_10 = 0;
      }
      mm_[7 + (128) * ((j_ - 1))] = _data_l_10[_data_k_10++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_11 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_11 >= _data_n_11) {
        _data_k_11 = 0;
      }
      mm_[8 + (128) * ((j_ - 1))] = _data_l_11[_data_k_11++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_12 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_12 >= _data_n_12) {
        _data_k_12 = 0;
      }
      mm_[9 + (128) * ((j_ - 1))] = _data_l_12[_data_k_12++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_13 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_13 >= _data_n_13) {
        _data_k_13 = 0;
      }
      mm_[10 + (128) * ((j_ - 1))] = _data_l_13[_data_k_13++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_14 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_14 >= _data_n_14) {
        _data_k_14 = 0;
      }
      mm_[11 + (128) * ((j_ - 1))] = _data_l_14[_data_k_14++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_15 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_15 >= _data_n_15) {
        _data_k_15 = 0;
      }
      mm_[12 + (128) * ((j_ - 1))] = _data_l_15[_data_k_15++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_16 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_16 >= _data_n_16) {
        _data_k_16 = 0;
      }
      mm_[13 + (128) * ((j_ - 1))] = _data_l_16[_data_k_16++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_17 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_17 >= _data_n_17) {
        _data_k_17 = 0;
      }
      mm_[14 + (128) * ((j_ - 1))] = _data_l_17[_data_k_17++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_18 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_18 >= _data_n_18) {
        _data_k_18 = 0;
      }
      mm_[15 + (128) * ((j_ - 1))] = _data_l_18[_data_k_18++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_19 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_19 >= _data_n_19) {
        _data_k_19 = 0;
      }
      mm_[16 + (128) * ((j_ - 1))] = _data_l_19[_data_k_19++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_20 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_20 >= _data_n_20) {
        _data_k_20 = 0;
      }
      mm_[17 + (128) * ((j_ - 1))] = _data_l_20[_data_k_20++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_21 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_21 >= _data_n_21) {
        _data_k_21 = 0;
      }
      mm_[18 + (128) * ((j_ - 1))] = _data_l_21[_data_k_21++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_22 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_22 >= _data_n_22) {
        _data_k_22 = 0;
      }
      mm_[19 + (128) * ((j_ - 1))] = _data_l_22[_data_k_22++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_23 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_23 >= _data_n_23) {
        _data_k_23 = 0;
      }
      mm_[20 + (128) * ((j_ - 1))] = _data_l_23[_data_k_23++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_24 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_24 >= _data_n_24) {
        _data_k_24 = 0;
      }
      mm_[21 + (128) * ((j_ - 1))] = _data_l_24[_data_k_24++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_25 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_25 >= _data_n_25) {
        _data_k_25 = 0;
      }
      mm_[22 + (128) * ((j_ - 1))] = _data_l_25[_data_k_25++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_26 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_26 >= _data_n_26) {
        _data_k_26 = 0;
      }
      mm_[23 + (128) * ((j_ - 1))] = _data_l_26[_data_k_26++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_27 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_27 >= _data_n_27) {
        _data_k_27 = 0;
      }
      mm_[24 + (128) * ((j_ - 1))] = _data_l_27[_data_k_27++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_28 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_28 >= _data_n_28) {
        _data_k_28 = 0;
      }
      mm_[25 + (128) * ((j_ - 1))] = _data_l_28[_data_k_28++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_29 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_29 >= _data_n_29) {
        _data_k_29 = 0;
      }
      mm_[26 + (128) * ((j_ - 1))] = _data_l_29[_data_k_29++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_30 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_30 >= _data_n_30) {
        _data_k_30 = 0;
      }
      mm_[27 + (128) * ((j_ - 1))] = _data_l_30[_data_k_30++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_31 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_31 >= _data_n_31) {
        _data_k_31 = 0;
      }
      mm_[28 + (128) * ((j_ - 1))] = _data_l_31[_data_k_31++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_32 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_32 >= _data_n_32) {
        _data_k_32 = 0;
      }
      mm_[29 + (128) * ((j_ - 1))] = _data_l_32[_data_k_32++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_33 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_33 >= _data_n_33) {
        _data_k_33 = 0;
      }
      mm_[30 + (128) * ((j_ - 1))] = _data_l_33[_data_k_33++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_34 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_34 >= _data_n_34) {
        _data_k_34 = 0;
      }
      mm_[31 + (128) * ((j_ - 1))] = _data_l_34[_data_k_34++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_35 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_35 >= _data_n_35) {
        _data_k_35 = 0;
      }
      mm_[32 + (128) * ((j_ - 1))] = _data_l_35[_data_k_35++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_36 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_36 >= _data_n_36) {
        _data_k_36 = 0;
      }
      mm_[33 + (128) * ((j_ - 1))] = _data_l_36[_data_k_36++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_37 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_37 >= _data_n_37) {
        _data_k_37 = 0;
      }
      mm_[34 + (128) * ((j_ - 1))] = _data_l_37[_data_k_37++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_38 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_38 >= _data_n_38) {
        _data_k_38 = 0;
      }
      mm_[35 + (128) * ((j_ - 1))] = _data_l_38[_data_k_38++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_39 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_39 >= _data_n_39) {
        _data_k_39 = 0;
      }
      mm_[36 + (128) * ((j_ - 1))] = _data_l_39[_data_k_39++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_40 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_40 >= _data_n_40) {
        _data_k_40 = 0;
      }
      mm_[37 + (128) * ((j_ - 1))] = _data_l_40[_data_k_40++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_41 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_41 >= _data_n_41) {
        _data_k_41 = 0;
      }
      mm_[38 + (128) * ((j_ - 1))] = _data_l_41[_data_k_41++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_42 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_42 >= _data_n_42) {
        _data_k_42 = 0;
      }
      mm_[39 + (128) * ((j_ - 1))] = _data_l_42[_data_k_42++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_43 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_43 >= _data_n_43) {
        _data_k_43 = 0;
      }
      mm_[40 + (128) * ((j_ - 1))] = _data_l_43[_data_k_43++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_44 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_44 >= _data_n_44) {
        _data_k_44 = 0;
      }
      mm_[41 + (128) * ((j_ - 1))] = _data_l_44[_data_k_44++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_45 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_45 >= _data_n_45) {
        _data_k_45 = 0;
      }
      mm_[42 + (128) * ((j_ - 1))] = _data_l_45[_data_k_45++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_46 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_46 >= _data_n_46) {
        _data_k_46 = 0;
      }
      mm_[43 + (128) * ((j_ - 1))] = _data_l_46[_data_k_46++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_47 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_47 >= _data_n_47) {
        _data_k_47 = 0;
      }
      mm_[44 + (128) * ((j_ - 1))] = _data_l_47[_data_k_47++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_48 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_48 >= _data_n_48) {
        _data_k_48 = 0;
      }
      mm_[45 + (128) * ((j_ - 1))] = _data_l_48[_data_k_48++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_49 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_49 >= _data_n_49) {
        _data_k_49 = 0;
      }
      mm_[46 + (128) * ((j_ - 1))] = _data_l_49[_data_k_49++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_50 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_50 >= _data_n_50) {
        _data_k_50 = 0;
      }
      mm_[47 + (128) * ((j_ - 1))] = _data_l_50[_data_k_50++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_51 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_51 >= _data_n_51) {
        _data_k_51 = 0;
      }
      mm_[48 + (128) * ((j_ - 1))] = _data_l_51[_data_k_51++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_52 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_52 >= _data_n_52) {
        _data_k_52 = 0;
      }
      mm_[49 + (128) * ((j_ - 1))] = _data_l_52[_data_k_52++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_53 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_53 >= _data_n_53) {
        _data_k_53 = 0;
      }
      mm_[50 + (128) * ((j_ - 1))] = _data_l_53[_data_k_53++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_54 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_54 >= _data_n_54) {
        _data_k_54 = 0;
      }
      mm_[51 + (128) * ((j_ - 1))] = _data_l_54[_data_k_54++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_55 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_55 >= _data_n_55) {
        _data_k_55 = 0;
      }
      mm_[52 + (128) * ((j_ - 1))] = _data_l_55[_data_k_55++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_56 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_56 >= _data_n_56) {
        _data_k_56 = 0;
      }
      mm_[53 + (128) * ((j_ - 1))] = _data_l_56[_data_k_56++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_57 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_57 >= _data_n_57) {
        _data_k_57 = 0;
      }
      mm_[54 + (128) * ((j_ - 1))] = _data_l_57[_data_k_57++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_58 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_58 >= _data_n_58) {
        _data_k_58 = 0;
      }
      mm_[55 + (128) * ((j_ - 1))] = _data_l_58[_data_k_58++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_59 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_59 >= _data_n_59) {
        _data_k_59 = 0;
      }
      mm_[56 + (128) * ((j_ - 1))] = _data_l_59[_data_k_59++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_60 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_60 >= _data_n_60) {
        _data_k_60 = 0;
      }
      mm_[57 + (128) * ((j_ - 1))] = _data_l_60[_data_k_60++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_61 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_61 >= _data_n_61) {
        _data_k_61 = 0;
      }
      mm_[58 + (128) * ((j_ - 1))] = _data_l_61[_data_k_61++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_62 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_62 >= _data_n_62) {
        _data_k_62 = 0;
      }
      mm_[59 + (128) * ((j_ - 1))] = _data_l_62[_data_k_62++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_63 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_63 >= _data_n_63) {
        _data_k_63 = 0;
      }
      mm_[60 + (128) * ((j_ - 1))] = _data_l_63[_data_k_63++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_64 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_64 >= _data_n_64) {
        _data_k_64 = 0;
      }
      mm_[61 + (128) * ((j_ - 1))] = _data_l_64[_data_k_64++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_65 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_65 >= _data_n_65) {
        _data_k_65 = 0;
      }
      mm_[62 + (128) * ((j_ - 1))] = _data_l_65[_data_k_65++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_66 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_66 >= _data_n_66) {
        _data_k_66 = 0;
      }
      mm_[63 + (128) * ((j_ - 1))] = _data_l_66[_data_k_66++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_67 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_67 >= _data_n_67) {
        _data_k_67 = 0;
      }
      mm_[64 + (128) * ((j_ - 1))] = _data_l_67[_data_k_67++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_68 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_68 >= _data_n_68) {
        _data_k_68 = 0;
      }
      mm_[65 + (128) * ((j_ - 1))] = _data_l_68[_data_k_68++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_69 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_69 >= _data_n_69) {
        _data_k_69 = 0;
      }
      mm_[66 + (128) * ((j_ - 1))] = _data_l_69[_data_k_69++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_70 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_70 >= _data_n_70) {
        _data_k_70 = 0;
      }
      mm_[67 + (128) * ((j_ - 1))] = _data_l_70[_data_k_70++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_71 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_71 >= _data_n_71) {
        _data_k_71 = 0;
      }
      mm_[68 + (128) * ((j_ - 1))] = _data_l_71[_data_k_71++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_72 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_72 >= _data_n_72) {
        _data_k_72 = 0;
      }
      mm_[69 + (128) * ((j_ - 1))] = _data_l_72[_data_k_72++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_73 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_73 >= _data_n_73) {
        _data_k_73 = 0;
      }
      mm_[70 + (128) * ((j_ - 1))] = _data_l_73[_data_k_73++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_74 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_74 >= _data_n_74) {
        _data_k_74 = 0;
      }
      mm_[71 + (128) * ((j_ - 1))] = _data_l_74[_data_k_74++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_75 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_75 >= _data_n_75) {
        _data_k_75 = 0;
      }
      mm_[72 + (128) * ((j_ - 1))] = _data_l_75[_data_k_75++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_76 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_76 >= _data_n_76) {
        _data_k_76 = 0;
      }
      mm_[73 + (128) * ((j_ - 1))] = _data_l_76[_data_k_76++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_77 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_77 >= _data_n_77) {
        _data_k_77 = 0;
      }
      mm_[74 + (128) * ((j_ - 1))] = _data_l_77[_data_k_77++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_78 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_78 >= _data_n_78) {
        _data_k_78 = 0;
      }
      mm_[75 + (128) * ((j_ - 1))] = _data_l_78[_data_k_78++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_79 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_79 >= _data_n_79) {
        _data_k_79 = 0;
      }
      mm_[76 + (128) * ((j_ - 1))] = _data_l_79[_data_k_79++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_80 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_80 >= _data_n_80) {
        _data_k_80 = 0;
      }
      mm_[77 + (128) * ((j_ - 1))] = _data_l_80[_data_k_80++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_81 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_81 >= _data_n_81) {
        _data_k_81 = 0;
      }
      mm_[78 + (128) * ((j_ - 1))] = _data_l_81[_data_k_81++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_82 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_82 >= _data_n_82) {
        _data_k_82 = 0;
      }
      mm_[79 + (128) * ((j_ - 1))] = _data_l_82[_data_k_82++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_83 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_83 >= _data_n_83) {
        _data_k_83 = 0;
      }
      mm_[80 + (128) * ((j_ - 1))] = _data_l_83[_data_k_83++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_84 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_84 >= _data_n_84) {
        _data_k_84 = 0;
      }
      mm_[81 + (128) * ((j_ - 1))] = _data_l_84[_data_k_84++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_85 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_85 >= _data_n_85) {
        _data_k_85 = 0;
      }
      mm_[82 + (128) * ((j_ - 1))] = _data_l_85[_data_k_85++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_86 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_86 >= _data_n_86) {
        _data_k_86 = 0;
      }
      mm_[83 + (128) * ((j_ - 1))] = _data_l_86[_data_k_86++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_87 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_87 >= _data_n_87) {
        _data_k_87 = 0;
      }
      mm_[84 + (128) * ((j_ - 1))] = _data_l_87[_data_k_87++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_88 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_88 >= _data_n_88) {
        _data_k_88 = 0;
      }
      mm_[85 + (128) * ((j_ - 1))] = _data_l_88[_data_k_88++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_89 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_89 >= _data_n_89) {
        _data_k_89 = 0;
      }
      mm_[86 + (128) * ((j_ - 1))] = _data_l_89[_data_k_89++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_90 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_90 >= _data_n_90) {
        _data_k_90 = 0;
      }
      mm_[87 + (128) * ((j_ - 1))] = _data_l_90[_data_k_90++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_91 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_91 >= _data_n_91) {
        _data_k_91 = 0;
      }
      mm_[88 + (128) * ((j_ - 1))] = _data_l_91[_data_k_91++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_92 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_92 >= _data_n_92) {
        _data_k_92 = 0;
      }
      mm_[89 + (128) * ((j_ - 1))] = _data_l_92[_data_k_92++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_93 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_93 >= _data_n_93) {
        _data_k_93 = 0;
      }
      mm_[90 + (128) * ((j_ - 1))] = _data_l_93[_data_k_93++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_94 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_94 >= _data_n_94) {
        _data_k_94 = 0;
      }
      mm_[91 + (128) * ((j_ - 1))] = _data_l_94[_data_k_94++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_95 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_95 >= _data_n_95) {
        _data_k_95 = 0;
      }
      mm_[92 + (128) * ((j_ - 1))] = _data_l_95[_data_k_95++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_96 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_96 >= _data_n_96) {
        _data_k_96 = 0;
      }
      mm_[93 + (128) * ((j_ - 1))] = _data_l_96[_data_k_96++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_97 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_97 >= _data_n_97) {
        _data_k_97 = 0;
      }
      mm_[94 + (128) * ((j_ - 1))] = _data_l_97[_data_k_97++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_98 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_98 >= _data_n_98) {
        _data_k_98 = 0;
      }
      mm_[95 + (128) * ((j_ - 1))] = _data_l_98[_data_k_98++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_99 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_99 >= _data_n_99) {
        _data_k_99 = 0;
      }
      mm_[96 + (128) * ((j_ - 1))] = _data_l_99[_data_k_99++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_100 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_100 >= _data_n_100) {
        _data_k_100 = 0;
      }
      mm_[97 + (128) * ((j_ - 1))] = _data_l_100[_data_k_100++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_101 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_101 >= _data_n_101) {
        _data_k_101 = 0;
      }
      mm_[98 + (128) * ((j_ - 1))] = _data_l_101[_data_k_101++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_102 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_102 >= _data_n_102) {
        _data_k_102 = 0;
      }
      mm_[99 + (128) * ((j_ - 1))] = _data_l_102[_data_k_102++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_103 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_103 >= _data_n_103) {
        _data_k_103 = 0;
      }
      mm_[100 + (128) * ((j_ - 1))] = _data_l_103[_data_k_103++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_104 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_104 >= _data_n_104) {
        _data_k_104 = 0;
      }
      mm_[101 + (128) * ((j_ - 1))] = _data_l_104[_data_k_104++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_105 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_105 >= _data_n_105) {
        _data_k_105 = 0;
      }
      mm_[102 + (128) * ((j_ - 1))] = _data_l_105[_data_k_105++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_106 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_106 >= _data_n_106) {
        _data_k_106 = 0;
      }
      mm_[103 + (128) * ((j_ - 1))] = _data_l_106[_data_k_106++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_107 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_107 >= _data_n_107) {
        _data_k_107 = 0;
      }
      mm_[104 + (128) * ((j_ - 1))] = _data_l_107[_data_k_107++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_108 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_108 >= _data_n_108) {
        _data_k_108 = 0;
      }
      mm_[105 + (128) * ((j_ - 1))] = _data_l_108[_data_k_108++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_109 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_109 >= _data_n_109) {
        _data_k_109 = 0;
      }
      mm_[106 + (128) * ((j_ - 1))] = _data_l_109[_data_k_109++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_110 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_110 >= _data_n_110) {
        _data_k_110 = 0;
      }
      mm_[107 + (128) * ((j_ - 1))] = _data_l_110[_data_k_110++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_111 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_111 >= _data_n_111) {
        _data_k_111 = 0;
      }
      mm_[108 + (128) * ((j_ - 1))] = _data_l_111[_data_k_111++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_112 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_112 >= _data_n_112) {
        _data_k_112 = 0;
      }
      mm_[109 + (128) * ((j_ - 1))] = _data_l_112[_data_k_112++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_113 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_113 >= _data_n_113) {
        _data_k_113 = 0;
      }
      mm_[110 + (128) * ((j_ - 1))] = _data_l_113[_data_k_113++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_114 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_114 >= _data_n_114) {
        _data_k_114 = 0;
      }
      mm_[111 + (128) * ((j_ - 1))] = _data_l_114[_data_k_114++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_115 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_115 >= _data_n_115) {
        _data_k_115 = 0;
      }
      mm_[112 + (128) * ((j_ - 1))] = _data_l_115[_data_k_115++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_116 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_116 >= _data_n_116) {
        _data_k_116 = 0;
      }
      mm_[113 + (128) * ((j_ - 1))] = _data_l_116[_data_k_116++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_117 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_117 >= _data_n_117) {
        _data_k_117 = 0;
      }
      mm_[114 + (128) * ((j_ - 1))] = _data_l_117[_data_k_117++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_118 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_118 >= _data_n_118) {
        _data_k_118 = 0;
      }
      mm_[115 + (128) * ((j_ - 1))] = _data_l_118[_data_k_118++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_119 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_119 >= _data_n_119) {
        _data_k_119 = 0;
      }
      mm_[116 + (128) * ((j_ - 1))] = _data_l_119[_data_k_119++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_120 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_120 >= _data_n_120) {
        _data_k_120 = 0;
      }
      mm_[117 + (128) * ((j_ - 1))] = _data_l_120[_data_k_120++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_121 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_121 >= _data_n_121) {
        _data_k_121 = 0;
      }
      mm_[118 + (128) * ((j_ - 1))] = _data_l_121[_data_k_121++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_122 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_122 >= _data_n_122) {
        _data_k_122 = 0;
      }
      mm_[119 + (128) * ((j_ - 1))] = _data_l_122[_data_k_122++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_123 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_123 >= _data_n_123) {
        _data_k_123 = 0;
      }
      mm_[120 + (128) * ((j_ - 1))] = _data_l_123[_data_k_123++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_124 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_124 >= _data_n_124) {
        _data_k_124 = 0;
      }
      mm_[121 + (128) * ((j_ - 1))] = _data_l_124[_data_k_124++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_125 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_125 >= _data_n_125) {
        _data_k_125 = 0;
      }
      mm_[122 + (128) * ((j_ - 1))] = _data_l_125[_data_k_125++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_126 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_126 >= _data_n_126) {
        _data_k_126 = 0;
      }
      mm_[123 + (128) * ((j_ - 1))] = _data_l_126[_data_k_126++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_127 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_127 >= _data_n_127) {
        _data_k_127 = 0;
      }
      mm_[124 + (128) * ((j_ - 1))] = _data_l_127[_data_k_127++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_128 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_128 >= _data_n_128) {
        _data_k_128 = 0;
      }
      mm_[125 + (128) * ((j_ - 1))] = _data_l_128[_data_k_128++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_129 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_129 >= _data_n_129) {
        _data_k_129 = 0;
      }
      mm_[126 + (128) * ((j_ - 1))] = _data_l_129[_data_k_129++];
    }; // implied DO 
  }
  if (__calls[50].calls == 0) {
    _data_k_130 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_130 >= _data_n_130) {
        _data_k_130 = 0;
      }
      mm_[127 + (128) * ((j_ - 1))] = _data_l_130[_data_k_130++];
    }; // implied DO 
  }
  i1_ = iseed_[0];
  i2_ = iseed_[1];
  i3_ = iseed_[2];
  i4_ = iseed_[3];
  for (i_ = 1; i_ <= _min ((*n_), 128); (i_)++) {
    it4_ = i4_ * mm_[i_ - 1 + 384];
    it3_ = it4_ / 4096;
    it4_ = it4_ - 4096 * it3_;
    it3_ = it3_ + i3_ * mm_[i_ - 1 + 384] + i4_ * mm_[i_ - 1 + 256];
    it2_ = it3_ / 4096;
    it3_ = it3_ - 4096 * it2_;
    it2_ = it2_ + i2_ * mm_[i_ - 1 + 384] + i3_ * mm_[i_ - 1 + 256] + i4_ * mm_[i_ - 1 + 128];
    it1_ = it2_ / 4096;
    it2_ = it2_ - 4096 * it1_;
    it1_ = it1_ + i1_ * mm_[i_ - 1 + 384] + i2_ * mm_[i_ - 1 + 256] + i3_ * mm_[i_ - 1 + 128] + i4_ * mm_[i_ - 1];
    it1_ = _imod (it1_, 4096);
    x_[i_ - 1] = 2.44140625e-4 * ((real_8) (it1_) + 2.44140625e-4 * ((real_8) (it2_) + 2.44140625e-4 * ((real_8) (it3_) + 
    2.44140625e-4 * (real_8) (it4_))));
  }
  iseed_[0] = it1_;
  iseed_[1] = it2_;
  iseed_[2] = it3_;
  iseed_[3] = it4_;
  __calls[50].calls++;
  return 0;
}

int_4 _dlasy2 (logical_4 _p_ ltranl_, logical_4 _p_ ltranr_, int_4 _p_ isgn_, int_4 _p_ n1_, int_4 _p_ n2_, real_8 _p_ 
tl_, int_4 _p_ ldtl_, real_8 _p_ tr_, int_4 _p_ ldtr_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ scale_, real_8 _p_ x_, 
int_4 _p_ ldx_, real_8 _p_ xnorm_, int_4 _p_ info_)
{
  static int_4 i_, ip_, ipiv_, ipsv_, j_, jp_, jpsv_, k_, jpiv_[4], locl21_[4], locu12_[4], locu22_[4];
  static logical_4 bswap_, xswap_, bswpiv_[4], xswpiv_[4];
  static real_8 bet_, eps_, gam_, l21_, sgn_, smin_, smlnum_, tau1_, temp_, u11_, u12_, u22_, xmax_, btmp_[4], t16_[16], 
  tmp_[4], x2_[2];
  int_4 _data_k_131, _p_ _arr_0, _k_1, _data_k_132, _p_ _arr_2, _k_3, _data_k_133, _p_ _arr_4, _k_5, _data_k_134, _k_7, 
  _data_k_135, _k_9, $12_, $15_, $16_, $17_, $18_, $19_;
  logical_4 _p_ _arr_6, _p_ _arr_8;
  real_8 $10_, $11_, $13_, $14_, $20_;
  extern int_4 _idamax ();
  extern real_8 _dlamch ();
  extern int_4 _dcopy ();
  extern int_4 _dswap ();
#define _data_n_131 4
  static int_4 _data_l_131[_data_n_131] = {
    3,
    4,
    1,
    2
  };
#define _data_n_132 4
  static int_4 _data_l_132[_data_n_132] = {
    2,
    1,
    4,
    3
  };
#define _data_n_133 4
  static int_4 _data_l_133[_data_n_133] = {
    4,
    3,
    2,
    1
  };
#define _data_n_134 4
  static logical_4 _data_l_134[_data_n_134] = {
    FALSE,
    FALSE,
    TRUE,
    TRUE
  };
#define _data_n_135 4
  static logical_4 _data_l_135[_data_n_135] = {
    FALSE,
    TRUE,
    FALSE,
    TRUE
  };
  if (__calls[51].calls == 0) {
    _data_k_131 = 0;
    for (_arr_0 = (int_4 *) locu12_, _k_1 = 0; _k_1 < 4; _arr_0++, _k_1++) {
      if (_data_k_131 >= _data_n_131) {
        _data_k_131 = 0;
      }
      locu12_[_k_1] = _data_l_131[_data_k_131++];
    }
    _data_k_132 = 0;
    for (_arr_2 = (int_4 *) locl21_, _k_3 = 0; _k_3 < 4; _arr_2++, _k_3++) {
      if (_data_k_132 >= _data_n_132) {
        _data_k_132 = 0;
      }
      locl21_[_k_3] = _data_l_132[_data_k_132++];
    }
    _data_k_133 = 0;
    for (_arr_4 = (int_4 *) locu22_, _k_5 = 0; _k_5 < 4; _arr_4++, _k_5++) {
      if (_data_k_133 >= _data_n_133) {
        _data_k_133 = 0;
      }
      locu22_[_k_5] = _data_l_133[_data_k_133++];
    }
  }
  if (__calls[51].calls == 0) {
    _data_k_134 = 0;
    for (_arr_6 = (logical_4 *) xswpiv_, _k_7 = 0; _k_7 < 4; _arr_6++, _k_7++) {
      if (_data_k_134 >= _data_n_134) {
        _data_k_134 = 0;
      }
      xswpiv_[_k_7] = _data_l_134[_data_k_134++];
    }
  }
  if (__calls[51].calls == 0) {
    _data_k_135 = 0;
    for (_arr_8 = (logical_4 *) bswpiv_, _k_9 = 0; _k_9 < 4; _arr_8++, _k_9++) {
      if (_data_k_135 >= _data_n_135) {
        _data_k_135 = 0;
      }
      bswpiv_[_k_9] = _data_l_135[_data_k_135++];
    }
  }
  (*info_) = 0;
  if ((*n1_) == 0 || (*n2_) == 0) {
    goto _l0;
  }
  eps_ = _dlamch (_dc_44);
  smlnum_ = _dlamch (_dc_28) / eps_;
  sgn_ = (*isgn_);
  k_ = (*n1_) + (*n1_) + (*n2_) - 2;
  switch (k_) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
    case 3: goto _l30;
    case 4: goto _l50;
  }
  _l10:;
  tau1_ = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  bet_ = _abs (tau1_);
  if (bet_ <= smlnum_) {
    tau1_ = smlnum_;
    bet_ = smlnum_;
    (*info_) = 1;
  }
  (*scale_) = 1.0;
  gam_ = _abs (b_[0 + ((*ldb_)) * ((0))]);
  if (smlnum_ * gam_ > bet_) {
    (*scale_) = 1.0 / gam_;
  }
  x_[0 + ((*ldx_)) * ((0))] = (b_[0 + ((*ldb_)) * ((0))] * (*scale_)) / tau1_;
  (*xnorm_) = _abs (x_[0 + ((*ldx_)) * ((0))]);
  goto _l0;
  _l20:;
  smin_ = _max (eps_ * ($10_ = _max (_abs (tl_[0 + ((*ldtl_)) * ((0))]), _abs (tr_[0 + ((*ldtr_)) * ((0))])), $10_ = _max 
  ($10_, _abs (tr_[0 + ((*ldtr_)) * ((1))])), $10_ = _max ($10_, _abs (tr_[1 + ((*ldtr_)) * ((0))])), _max ($10_, _abs 
  (tr_[1 + ((*ldtr_)) * ((1))]))), smlnum_);
  tmp_[0] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  tmp_[3] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[1 + ((*ldtr_)) * ((1))];
  if ((*ltranr_)) {
    tmp_[1] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
    tmp_[2] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
  }
  else {
    tmp_[1] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
    tmp_[2] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
  }
  btmp_[0] = b_[0 + ((*ldb_)) * ((0))];
  btmp_[1] = b_[0 + ((*ldb_)) * ((1))];
  goto _l40;
  _l30:;
  smin_ = _max (eps_ * ($11_ = _max (_abs (tr_[0 + ((*ldtr_)) * ((0))]), _abs (tl_[0 + ((*ldtl_)) * ((0))])), $11_ = _max 
  ($11_, _abs (tl_[0 + ((*ldtl_)) * ((1))])), $11_ = _max ($11_, _abs (tl_[1 + ((*ldtl_)) * ((0))])), _max ($11_, _abs 
  (tl_[1 + ((*ldtl_)) * ((1))]))), smlnum_);
  tmp_[0] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  tmp_[3] = tl_[1 + ((*ldtl_)) * ((1))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  if ((*ltranl_)) {
    tmp_[1] = tl_[0 + ((*ldtl_)) * ((1))];
    tmp_[2] = tl_[1 + ((*ldtl_)) * ((0))];
  }
  else {
    tmp_[1] = tl_[1 + ((*ldtl_)) * ((0))];
    tmp_[2] = tl_[0 + ((*ldtl_)) * ((1))];
  }
  btmp_[0] = b_[0 + ((*ldb_)) * ((0))];
  btmp_[1] = b_[1 + ((*ldb_)) * ((0))];
  _l40:;
  ipiv_ = _idamax (($12_ = 4, &$12_), tmp_, &_k1);
  u11_ = tmp_[ipiv_ - 1];
  if (_abs (u11_) <= smin_) {
    (*info_) = 1;
    u11_ = smin_;
  }
  u12_ = tmp_[locu12_[ipiv_ - 1] - 1];
  l21_ = tmp_[locl21_[ipiv_ - 1] - 1] / u11_;
  u22_ = tmp_[locu22_[ipiv_ - 1] - 1] - u12_ * l21_;
  xswap_ = xswpiv_[ipiv_ - 1];
  bswap_ = bswpiv_[ipiv_ - 1];
  if (_abs (u22_) <= smin_) {
    (*info_) = 1;
    u22_ = smin_;
  }
  if (bswap_) {
    temp_ = btmp_[1];
    btmp_[1] = btmp_[0] - l21_ * temp_;
    btmp_[0] = temp_;
  }
  else {
    btmp_[1] = btmp_[1] - l21_ * btmp_[0];
  }
  (*scale_) = 1.0;
  if ((2.0 * smlnum_) * _abs (btmp_[1]) > _abs (u22_) || (2.0 * smlnum_) * _abs (btmp_[0]) > _abs (u11_)) {
    (*scale_) = 0.5 / _max (_abs (btmp_[0]), _abs (btmp_[1]));
    btmp_[0] = btmp_[0] * (*scale_);
    btmp_[1] = btmp_[1] * (*scale_);
  }
  x2_[1] = btmp_[1] / u22_;
  x2_[0] = btmp_[0] / u11_ - (u12_ / u11_) * x2_[1];
  if (xswap_) {
    temp_ = x2_[1];
    x2_[1] = x2_[0];
    x2_[0] = temp_;
  }
  x_[0 + ((*ldx_)) * ((0))] = x2_[0];
  if ((*n1_) == 1) {
    x_[0 + ((*ldx_)) * ((1))] = x2_[1];
    (*xnorm_) = _abs (x_[0 + ((*ldx_)) * ((0))]) + _abs (x_[0 + ((*ldx_)) * ((1))]);
  }
  else {
    x_[1 + ((*ldx_)) * ((0))] = x2_[1];
    (*xnorm_) = _max (_abs (x_[0 + ((*ldx_)) * ((0))]), _abs (x_[1 + ((*ldx_)) * ((0))]));
  }
  goto _l0;
  _l50:;
  smin_ = ($13_ = _max (_abs (tr_[0 + ((*ldtr_)) * ((0))]), _abs (tr_[0 + ((*ldtr_)) * ((1))])), $13_ = _max ($13_, _abs 
  (tr_[1 + ((*ldtr_)) * ((0))])), _max ($13_, _abs (tr_[1 + ((*ldtr_)) * ((1))])));
  smin_ = ($14_ = _max (smin_, _abs (tl_[0 + ((*ldtl_)) * ((0))])), $14_ = _max ($14_, _abs (tl_[0 + ((*ldtl_)) * 
  ((1))])), $14_ = _max ($14_, _abs (tl_[1 + ((*ldtl_)) * ((0))])), _max ($14_, _abs (tl_[1 + ((*ldtl_)) * ((1))])));
  smin_ = _max (eps_ * smin_, smlnum_);
  btmp_[0] = 0.0;
  (void) _dcopy (($15_ = 16, &$15_), btmp_, &_k0, t16_, &_k1);
  t16_[0] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  t16_[5] = tl_[1 + ((*ldtl_)) * ((1))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  t16_[10] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[1 + ((*ldtr_)) * ((1))];
  t16_[15] = tl_[1 + ((*ldtl_)) * ((1))] + sgn_ * tr_[1 + ((*ldtr_)) * ((1))];
  if ((*ltranl_)) {
    t16_[4] = tl_[1 + ((*ldtl_)) * ((0))];
    t16_[1] = tl_[0 + ((*ldtl_)) * ((1))];
    t16_[14] = tl_[1 + ((*ldtl_)) * ((0))];
    t16_[11] = tl_[0 + ((*ldtl_)) * ((1))];
  }
  else {
    t16_[4] = tl_[0 + ((*ldtl_)) * ((1))];
    t16_[1] = tl_[1 + ((*ldtl_)) * ((0))];
    t16_[14] = tl_[0 + ((*ldtl_)) * ((1))];
    t16_[11] = tl_[1 + ((*ldtl_)) * ((0))];
  }
  if ((*ltranr_)) {
    t16_[8] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
    t16_[13] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
    t16_[2] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
    t16_[7] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
  }
  else {
    t16_[8] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
    t16_[13] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
    t16_[2] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
    t16_[7] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
  }
  btmp_[0] = b_[0 + ((*ldb_)) * ((0))];
  btmp_[1] = b_[1 + ((*ldb_)) * ((0))];
  btmp_[2] = b_[0 + ((*ldb_)) * ((1))];
  btmp_[3] = b_[1 + ((*ldb_)) * ((1))];
  for (i_ = 1; i_ <= 3; (i_)++) {
    xmax_ = 0.0;
    for (ip_ = i_; ip_ <= 4; (ip_)++) {
      for (jp_ = i_; jp_ <= 4; (jp_)++) {
        if (_abs (t16_[ip_ - 1 + (4) * ((jp_ - 1))]) >= xmax_) {
          xmax_ = _abs (t16_[ip_ - 1 + (4) * ((jp_ - 1))]);
          ipsv_ = ip_;
          jpsv_ = jp_;
        }
      }
    }
    if (ipsv_ != i_) {
      (void) _dswap (($16_ = 4, &$16_), &t16_[ipsv_ - 1], ($17_ = 4, &$17_), &t16_[i_ - 1], ($18_ = 4, &$18_));
      temp_ = btmp_[i_ - 1];
      btmp_[i_ - 1] = btmp_[ipsv_ - 1];
      btmp_[ipsv_ - 1] = temp_;
    }
    if (jpsv_ != i_) {
      (void) _dswap (($19_ = 4, &$19_), &t16_[0 + (4) * ((jpsv_ - 1))], &_k1, &t16_[0 + (4) * ((i_ - 1))], &_k1);
    }
    jpiv_[i_ - 1] = jpsv_;
    if (_abs (t16_[i_ - 1 + (4) * ((i_ - 1))]) < smin_) {
      (*info_) = 1;
      t16_[i_ - 1 + (4) * ((i_ - 1))] = smin_;
    }
    for (j_ = i_ + 1; j_ <= 4; (j_)++) {
      t16_[j_ - 1 + (4) * ((i_ - 1))] = t16_[j_ - 1 + (4) * ((i_ - 1))] / t16_[i_ - 1 + (4) * ((i_ - 1))];
      btmp_[j_ - 1] = btmp_[j_ - 1] - t16_[j_ - 1 + (4) * ((i_ - 1))] * btmp_[i_ - 1];
      for (k_ = i_ + 1; k_ <= 4; (k_)++) {
        t16_[j_ - 1 + (4) * ((k_ - 1))] = t16_[j_ - 1 + (4) * ((k_ - 1))] - t16_[j_ - 1 + (4) * ((i_ - 1))] * t16_[i_ - 1 + (4) 
        * ((k_ - 1))];
      }
    }
  }
  if (_abs (t16_[15]) < smin_) {
    t16_[15] = smin_;
  }
  (*scale_) = 1.0;
  if ((8.0 * smlnum_) * _abs (btmp_[0]) > _abs (t16_[0]) || (8.0 * smlnum_) * _abs (btmp_[1]) > _abs (t16_[5]) || (8.0 * 
    smlnum_) * _abs (btmp_[2]) > _abs (t16_[10]) || (8.0 * smlnum_) * _abs (btmp_[3]) > _abs (t16_[15])) {
    (*scale_) = 0.125 / ($20_ = _max (_abs (btmp_[0]), _abs (btmp_[1])), $20_ = _max ($20_, _abs (btmp_[2])), _max ($20_, 
    _abs (btmp_[3])));
    btmp_[0] = btmp_[0] * (*scale_);
    btmp_[1] = btmp_[1] * (*scale_);
    btmp_[2] = btmp_[2] * (*scale_);
    btmp_[3] = btmp_[3] * (*scale_);
  }
  for (i_ = 1; i_ <= 4; (i_)++) {
    k_ = 5 - i_;
    temp_ = 1.0 / t16_[k_ - 1 + (4) * ((k_ - 1))];
    tmp_[k_ - 1] = btmp_[k_ - 1] * temp_;
    for (j_ = k_ + 1; j_ <= 4; (j_)++) {
      tmp_[k_ - 1] = tmp_[k_ - 1] - (temp_ * t16_[k_ - 1 + (4) * ((j_ - 1))]) * tmp_[j_ - 1];
    }
  }
  for (i_ = 1; i_ <= 3; (i_)++) {
    if (jpiv_[4 - i_ - 1] != 4 - i_) {
      temp_ = tmp_[4 - i_ - 1];
      tmp_[4 - i_ - 1] = tmp_[jpiv_[4 - i_ - 1] - 1];
      tmp_[jpiv_[4 - i_ - 1] - 1] = temp_;
    }
  }
  x_[0 + ((*ldx_)) * ((0))] = tmp_[0];
  x_[1 + ((*ldx_)) * ((0))] = tmp_[1];
  x_[0 + ((*ldx_)) * ((1))] = tmp_[2];
  x_[1 + ((*ldx_)) * ((1))] = tmp_[3];
  (*xnorm_) = _max (_abs (tmp_[0]) + _abs (tmp_[2]), _abs (tmp_[1]) + _abs (tmp_[3]));
  _l0:;
  __calls[51].calls++;
  return 0;
}

int_4 _dpttrf (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, int_4 _p_ info_)
{
  static int_4 i_;
  static real_8 di_, ei_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
    (void) _xerbla (_dc_53, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    di_ = d_[i_ - 1];
    if (di_ <= 0.0) {
      goto _l20;
    }
    ei_ = e_[i_ - 1];
    e_[i_ - 1] = ei_ / di_;
    d_[i_ + 1 - 1] = d_[i_ + 1 - 1] - e_[i_ - 1] * ei_;
  }
  i_ = (*n_);
  if (d_[i_ - 1] > 0.0) {
    goto _l30;
  }
  _l20:;
  (*info_) = i_;
  _l30:;
  _l0:;
  __calls[52].calls++;
  return 0;
}

int_4 _dpttrs (int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ 
info_)
{
  static int_4 i_, j_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -2;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_54, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
    for (i_ = 2; i_ <= (*n_); (i_)++) {
      b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[i_ - 1 - 1 + ((*ldb_)) * ((j_ - 1))] * 
      e_[i_ - 1 - 1];
    }
    b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] / d_[(*n_) - 1];
    for (i_ = (*n_) - 1; i_ >= 1; (i_)--) {
      b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] / d_[i_ - 1] - b_[i_ + 1 - 1 + ((*ldb_)) * 
      ((j_ - 1))] * e_[i_ - 1];
    }
  }
  _l0:;
  __calls[53].calls++;
  return 0;
}

int_4 _dsteqr (char _p_ compz_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ z_, int_4 _p_ ldz_, real_8 _p_ 
work_, int_4 _p_ info_)
{
  static int_4 i_, icompz_, ii_, iscale_, j_, jtot_, k_, l_, l1_, lend_, lendm1_, lendp1_, lendsv_, lm1_, lsv_, m_, mm_, 
  mm1_, nm1_, nmaxit_;
  static real_8 anorm_, b_, c_, eps_, eps2_, f_, g_, p_, r_, rt1_, rt2_, s_, safmax_, safmin_, ssfmax_, ssfmin_, tst_;
  int_4 $0_, $3_, $4_, $5_, $6_, $7_, $9_, $12_, $14_, $15_, $16_, $17_;
  real_8 $1_, $2_, $8_, $10_, $11_, $13_;
  extern logical_4 _lsame ();
  extern real_8 _dlamch ();
  extern real_8 _dlanst ();
  extern real_8 _dlapy2 ();
  extern int_4 _dlartg ();
  extern int_4 _dlascl ();
  extern int_4 _dlaset ();
  extern int_4 _dlasr ();
  extern int_4 _dlasrt ();
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if (_lsame (compz_, _dc_7)) {
    icompz_ = 0;
  }
  else if (_lsame (compz_, _dc_40)) {
    icompz_ = 1;
  }
  else if (_lsame (compz_, _dc_25)) {
    icompz_ = 2;
  }
  else {
    icompz_ = -1;
  }
  if (icompz_ < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if (((*ldz_) < 1) || (icompz_ > 0 && (*ldz_) < _max (1, (*n_)))) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_55, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*n_) == 1) {
    if (icompz_ == 2) {
      z_[0 + ((*ldz_)) * ((0))] = 1.0;
    }
    goto _l0;
  }
  eps_ = _dlamch (_dc_27);
  eps2_ = (eps_ * eps_);
  safmin_ = _dlamch (_dc_28);
  safmax_ = 1.0 / safmin_;
  ssfmax_ = sqrt (safmax_) / 3.0;
  ssfmin_ = sqrt (safmin_) / eps2_;
  if (icompz_ == 2) {
    (void) _dlaset (_dc_51, n_, n_, ($1_ = 0.0, &$1_), ($2_ = 1.0, &$2_), z_, ldz_);
  }
  nmaxit_ = (*n_) * 30;
  jtot_ = 0;
  l1_ = 1;
  nm1_ = (*n_) - 1;
  _l10:;
  if (l1_ > (*n_)) {
    goto _l160;
  }
  if (l1_ > 1) {
    e_[l1_ - 1 - 1] = 0.0;
  }
  if (l1_ <= nm1_) {
    for (m_ = l1_; m_ <= nm1_; (m_)++) {
      tst_ = _abs (e_[m_ - 1]);
      if (tst_ == 0.0) {
        goto _l30;
      }
      if (tst_ <= (sqrt (_abs (d_[m_ - 1])) * sqrt (_abs (d_[m_ + 1 - 1]))) * eps_) {
        e_[m_ - 1] = 0.0;
        goto _l30;
      }
    }
  }
  m_ = (*n_);
  _l30:;
  l_ = l1_;
  lsv_ = l_;
  lend_ = m_;
  lendsv_ = lend_;
  l1_ = m_ + 1;
  if (lend_ == l_) {
    goto _l10;
  }
  anorm_ = _dlanst (_dc_25, ($3_ = lend_ - l_ + 1, &$3_), &d_[l_ - 1], &e_[l_ - 1]);
  iscale_ = 0;
  if (anorm_ == 0.0) {
    goto _l10;
  }
  if (anorm_ > ssfmax_) {
    iscale_ = 1;
    (void) _dlascl (_dc_29, &_k0, &_k0, &anorm_, &ssfmax_, ($4_ = lend_ - l_ + 1, &$4_), &_k1, &d_[l_ - 1], n_, info_);
    (void) _dlascl (_dc_29, &_k0, &_k0, &anorm_, &ssfmax_, ($5_ = lend_ - l_, &$5_), &_k1, &e_[l_ - 1], n_, info_);
  }
  else if (anorm_ < ssfmin_) {
    iscale_ = 2;
    (void) _dlascl (_dc_29, &_k0, &_k0, &anorm_, &ssfmin_, ($6_ = lend_ - l_ + 1, &$6_), &_k1, &d_[l_ - 1], n_, info_);
    (void) _dlascl (_dc_29, &_k0, &_k0, &anorm_, &ssfmin_, ($7_ = lend_ - l_, &$7_), &_k1, &e_[l_ - 1], n_, info_);
  }
  if (_abs (d_[lend_ - 1]) < _abs (d_[l_ - 1])) {
    lend_ = lsv_;
    l_ = lendsv_;
  }
  if (lend_ > l_) {
    _l40:;
    if (l_ != lend_) {
      lendm1_ = lend_ - 1;
      for (m_ = l_; m_ <= lendm1_; (m_)++) {
        tst_ = ($8_ = _abs (e_[m_ - 1]), $8_ * $8_);
        if (tst_ <= (eps2_ * _abs (d_[m_ - 1])) * _abs (d_[m_ + 1 - 1]) + safmin_) {
          goto _l60;
        }
      }
    }
    m_ = lend_;
    _l60:;
    if (m_ < lend_) {
      e_[m_ - 1] = 0.0;
    }
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l80;
    }
    if (m_ == l_ + 1) {
      if (icompz_ > 0) {
        (void) _dlaev2 (&d_[l_ - 1], &e_[l_ - 1], &d_[l_ + 1 - 1], &rt1_, &rt2_, &c_, &s_);
        work_[l_ - 1] = c_;
        work_[(*n_) - 1 + l_ - 1] = s_;
        (void) _dlasr (_dc_37, _dc_40, _dc_31, n_, ($9_ = 2, &$9_), &work_[l_ - 1], &work_[(*n_) - 1 + l_ - 1], &z_[0 + 
        ((*ldz_)) * ((l_ - 1))], ldz_);
      }
      else {
        (void) _dlae2 (&d_[l_ - 1], &e_[l_ - 1], &d_[l_ + 1 - 1], &rt1_, &rt2_);
      }
      d_[l_ - 1] = rt1_;
      d_[l_ + 1 - 1] = rt2_;
      e_[l_ - 1] = 0.0;
      l_ = l_ + 2;
      if (l_ <= lend_) {
        goto _l40;
      }
      goto _l140;
    }
    if (jtot_ == nmaxit_) {
      goto _l140;
    }
    jtot_ = jtot_ + 1;
    g_ = (d_[l_ + 1 - 1] - p_) / (2.0 * e_[l_ - 1]);
    r_ = _dlapy2 (&g_, ($10_ = 1.0, &$10_));
    g_ = d_[m_ - 1] - p_ + (e_[l_ - 1] / (g_ + _sign (r_, g_)));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    mm1_ = m_ - 1;
    for (i_ = mm1_; i_ >= l_; (i_)--) {
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      (void) _dlartg (&g_, &f_, &c_, &s_, &r_);
      if (i_ != m_ - 1) {
        e_[i_ + 1 - 1] = r_;
      }
      g_ = d_[i_ + 1 - 1] - p_;
      r_ = (d_[i_ - 1] - g_) * s_ + 2.0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ + 1 - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      if (icompz_ > 0) {
        work_[i_ - 1] = c_;
        work_[(*n_) - 1 + i_ - 1] = -s_;
      }
    }
    if (icompz_ > 0) {
      mm_ = m_ - l_ + 1;
      (void) _dlasr (_dc_37, _dc_40, _dc_31, n_, &mm_, &work_[l_ - 1], &work_[(*n_) - 1 + l_ - 1], &z_[0 + ((*ldz_)) * ((l_ - 
      1))], ldz_);
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[l_ - 1] = g_;
    goto _l40;
    _l80:;
    d_[l_ - 1] = p_;
    l_ = l_ + 1;
    if (l_ <= lend_) {
      goto _l40;
    }
    goto _l140;
  }
  else {
    _l90:;
    if (l_ != lend_) {
      lendp1_ = lend_ + 1;
      for (m_ = l_; m_ >= lendp1_; (m_)--) {
        tst_ = ($11_ = _abs (e_[m_ - 1 - 1]), $11_ * $11_);
        if (tst_ <= (eps2_ * _abs (d_[m_ - 1])) * _abs (d_[m_ - 1 - 1]) + safmin_) {
          goto _l110;
        }
      }
    }
    m_ = lend_;
    _l110:;
    if (m_ > lend_) {
      e_[m_ - 1 - 1] = 0.0;
    }
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l130;
    }
    if (m_ == l_ - 1) {
      if (icompz_ > 0) {
        (void) _dlaev2 (&d_[l_ - 1 - 1], &e_[l_ - 1 - 1], &d_[l_ - 1], &rt1_, &rt2_, &c_, &s_);
        work_[m_ - 1] = c_;
        work_[(*n_) - 1 + m_ - 1] = s_;
        (void) _dlasr (_dc_37, _dc_40, _dc_26, n_, ($12_ = 2, &$12_), &work_[m_ - 1], &work_[(*n_) - 1 + m_ - 1], &z_[0 + 
        ((*ldz_)) * ((l_ - 1 - 1))], ldz_);
      }
      else {
        (void) _dlae2 (&d_[l_ - 1 - 1], &e_[l_ - 1 - 1], &d_[l_ - 1], &rt1_, &rt2_);
      }
      d_[l_ - 1 - 1] = rt1_;
      d_[l_ - 1] = rt2_;
      e_[l_ - 1 - 1] = 0.0;
      l_ = l_ - 2;
      if (l_ >= lend_) {
        goto _l90;
      }
      goto _l140;
    }
    if (jtot_ == nmaxit_) {
      goto _l140;
    }
    jtot_ = jtot_ + 1;
    g_ = (d_[l_ - 1 - 1] - p_) / (2.0 * e_[l_ - 1 - 1]);
    r_ = _dlapy2 (&g_, ($13_ = 1.0, &$13_));
    g_ = d_[m_ - 1] - p_ + (e_[l_ - 1 - 1] / (g_ + _sign (r_, g_)));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    lm1_ = l_ - 1;
    for (i_ = m_; i_ <= lm1_; (i_)++) {
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      (void) _dlartg (&g_, &f_, &c_, &s_, &r_);
      if (i_ != m_) {
        e_[i_ - 1 - 1] = r_;
      }
      g_ = d_[i_ - 1] - p_;
      r_ = (d_[i_ + 1 - 1] - g_) * s_ + 2.0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      if (icompz_ > 0) {
        work_[i_ - 1] = c_;
        work_[(*n_) - 1 + i_ - 1] = s_;
      }
    }
    if (icompz_ > 0) {
      mm_ = l_ - m_ + 1;
      (void) _dlasr (_dc_37, _dc_40, _dc_26, n_, &mm_, &work_[m_ - 1], &work_[(*n_) - 1 + m_ - 1], &z_[0 + ((*ldz_)) * ((m_ - 
      1))], ldz_);
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[lm1_ - 1] = g_;
    goto _l90;
    _l130:;
    d_[l_ - 1] = p_;
    l_ = l_ - 1;
    if (l_ >= lend_) {
      goto _l90;
    }
    goto _l140;
  }
  _l140:;
  if (iscale_ == 1) {
    (void) _dlascl (_dc_29, &_k0, &_k0, &ssfmax_, &anorm_, ($14_ = lendsv_ - lsv_ + 1, &$14_), &_k1, &d_[lsv_ - 1], n_, 
    info_);
    (void) _dlascl (_dc_29, &_k0, &_k0, &ssfmax_, &anorm_, ($15_ = lendsv_ - lsv_, &$15_), &_k1, &e_[lsv_ - 1], n_, info_)
    ;
  }
  else if (iscale_ == 2) {
    (void) _dlascl (_dc_29, &_k0, &_k0, &ssfmin_, &anorm_, ($16_ = lendsv_ - lsv_ + 1, &$16_), &_k1, &d_[lsv_ - 1], n_, 
    info_);
    (void) _dlascl (_dc_29, &_k0, &_k0, &ssfmin_, &anorm_, ($17_ = lendsv_ - lsv_, &$17_), &_k1, &e_[lsv_ - 1], n_, info_)
    ;
  }
  if (jtot_ < nmaxit_) {
    goto _l10;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (e_[i_ - 1] != 0.0) {
      (*info_) = (*info_) + 1;
    }
  }
  goto _l190;
  _l160:;
  if (icompz_ == 0) {
    (void) _dlasrt (_dc_25, n_, d_, info_);
  }
  else {
    for (ii_ = 2; ii_ <= (*n_); (ii_)++) {
      i_ = ii_ - 1;
      k_ = i_;
      p_ = d_[i_ - 1];
      for (j_ = ii_; j_ <= (*n_); (j_)++) {
        if (d_[j_ - 1] < p_) {
          k_ = j_;
          p_ = d_[j_ - 1];
        }
      }
      if (k_ != i_) {
        d_[k_ - 1] = d_[i_ - 1];
        d_[i_ - 1] = p_;
        (void) _dswap (n_, &z_[0 + ((*ldz_)) * ((i_ - 1))], &_k1, &z_[0 + ((*ldz_)) * ((k_ - 1))], &_k1);
      }
    }
  }
  _l190:;
  _l0:;
  __calls[54].calls++;
  return 0;
}

int_4 _dtrevc (char _p_ side_, char _p_ howmny_, logical_4 _p_ select_, int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ ldt_, 
real_8 _p_ vl_, int_4 _p_ ldvl_, real_8 _p_ vr_, int_4 _p_ ldvr_, int_4 _p_ mm_, int_4 _p_ m_, real_8 _p_ work_, int_4 
_p_ info_)
{
  static int_4 i_, ierr_, ii_, ip_, is_, j_, j1_, j2_, jnxt_, k_, ki_, n2_;
  static logical_4 allv_, bothv_, leftv_, over_, pair_, rightv_, somev_;
  static real_8 beta_, bignum_, emax_, ovfl_, rec_, remax_, scale_, smin_, smlnum_, ulp_, unfl_, vcrit_, vmax_, wi_, wr_, 
  xnorm_, x_[4];
  int_4 $0_, $6_, $7_, $10_, $15_, $16_, $18_, $20_, $23_, $27_, $28_, $30_, $33_, $34_, $38_, $39_, $41_, $43_, $45_, 
  $47_, $49_, $51_, $52_, $58_, $59_, $60_, $61_, $62_, $64_, $69_, $70_, $72_, $73_, $74_, $75_, $77_, $78_, $79_, $80_, 
  $82_, $87_, $88_, $89_, $91_, $92_, $93_, $94_, $95_, $96_, $98_, $99_, $104_, $105_, $106_, $108_, $109_, $110_, $111_
  , $112_, $114_;
  logical_4 $1_, $9_, $22_, $32_, $53_, $63_, $81_, $97_;
  real_8 $2_, $3_, $4_, $5_, $8_, $11_, $12_, $13_, $14_, $17_, $19_, $21_, $24_, $25_, $26_, $29_, $31_, $35_, $36_, 
  $37_, $40_, $42_, $44_, $46_, $48_, $50_, $54_, $55_, $56_, $57_, $65_, $66_, $67_, $68_, $71_, $76_, $83_, $84_, $85_, 
  $86_, $90_, $100_, $101_, $102_, $103_, $107_, $113_, $115_;
  extern logical_4 _lsame ();
  extern int_4 _idamax ();
  extern real_8 _ddot ();
  extern real_8 _dlamch ();
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern int_4 _dgemv ();
  extern int_4 _dlabad ();
  extern int_4 _dscal ();
  extern int_4 _xerbla ();
  bothv_ = _lsame (side_, _dc_31);
  rightv_ = _lsame (side_, _dc_37) || bothv_;
  leftv_ = _lsame (side_, _dc_20) || bothv_;
  allv_ = _lsame (howmny_, _dc_38);
  over_ = _lsame (howmny_, _dc_31) || _lsame (howmny_, _dc_24);
  somev_ = _lsame (howmny_, _dc_28);
  (*info_) = 0;
  if (! (rightv_) && ! (leftv_)) {
    (*info_) = -1;
  }
  else if (! (allv_) && ! (over_) && ! (somev_)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  else if ((*ldvl_) < 1 || (leftv_ && (*ldvl_) < (*n_))) {
    (*info_) = -8;
  }
  else if ((*ldvr_) < 1 || (rightv_ && (*ldvr_) < (*n_))) {
    (*info_) = -10;
  }
  else {
    if (somev_) {
      (*m_) = 0;
      pair_ = FALSE;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (pair_) {
          pair_ = FALSE;
          select_[j_ - 1] = FALSE;
        }
        else {
          if (j_ < (*n_)) {
            if (t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))] == 0.0) {
              if (select_[j_ - 1]) {
                (*m_) = (*m_) + 1;
              }
            }
            else {
              pair_ = TRUE;
              if (select_[j_ - 1] || select_[j_ + 1 - 1]) {
                select_[j_ - 1] = TRUE;
                (*m_) = (*m_) + 2;
              }
            }
          }
          else {
            if (select_[(*n_) - 1]) {
              (*m_) = (*m_) + 1;
            }
          }
        }
      }
    }
    else {
      (*m_) = (*n_);
    }
    if ((*mm_) < (*m_)) {
      (*info_) = -11;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_56, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  unfl_ = _dlamch (_dc_18);
  ovfl_ = 1.0 / unfl_;
  (void) _dlabad (&unfl_, &ovfl_);
  ulp_ = _dlamch (_dc_21);
  smlnum_ = unfl_ * ((*n_) / ulp_);
  bignum_ = (1.0 - ulp_) / smlnum_;
  work_[0] = 0.0;
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    work_[j_ - 1] = 0.0;
    for (i_ = 1; i_ <= j_ - 1; (i_)++) {
      work_[j_ - 1] = work_[j_ - 1] + _abs (t_[i_ - 1 + ((*ldt_)) * ((j_ - 1))]);
    }
  }
  n2_ = 2 * (*n_);
  if (rightv_) {
    ip_ = 0;
    is_ = (*m_);
    for (ki_ = (*n_); ki_ >= 1; (ki_)--) {
      if (ip_ == 1) {
        goto _l130;
      }
      if (ki_ == 1) {
        goto _l40;
      }
      if (t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))] == 0.0) {
        goto _l40;
      }
      ip_ = -1;
      _l40:;
      if (somev_) {
        if (ip_ == 0) {
          if (! (select_[ki_ - 1])) {
            goto _l130;
          }
        }
        else {
          if (! (select_[ki_ - 1 - 1])) {
            goto _l130;
          }
        }
      }
      wr_ = t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))];
      wi_ = 0.0;
      if (ip_ != 0) {
        wi_ = sqrt (_abs (t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))])) * sqrt (_abs (t_[ki_ - 1 - 1 + ((*ldt_)) * ((ki_ - 1))]))
        ;
      }
      smin_ = _max (ulp_ * (_abs (wr_) + _abs (wi_)), smlnum_);
      if (ip_ == 0) {
        work_[ki_ + (*n_) - 1] = 1.0;
        for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
          work_[k_ + (*n_) - 1] = -t_[k_ - 1 + ((*ldt_)) * ((ki_ - 1))];
        }
        jnxt_ = ki_ - 1;
        for (j_ = ki_ - 1; j_ >= 1; (j_)--) {
          if (j_ > jnxt_) {
            goto _l60;
          }
          j1_ = j_;
          j2_ = j_;
          jnxt_ = j_ - 1;
          if (j_ > 1) {
            if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))] != 0.0) {
              j1_ = j_ - 1;
              jnxt_ = j_ - 2;
            }
          }
          if (j1_ == j2_) {
            (void) _dlaln2 (($1_ = FALSE, &$1_), &_k1, &_k1, &smin_, ($2_ = 1.0, &$2_), &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))], ldt_, 
            ($3_ = 1.0, &$3_), ($4_ = 1.0, &$4_), &work_[j_ + (*n_) - 1], n_, &wr_, ($5_ = 0.0, &$5_), x_, ($6_ = 2, &$6_), 
            &scale_, &xnorm_, &ierr_);
            if (xnorm_ > 1.0) {
              if (work_[j_ - 1] > bignum_ / xnorm_) {
                x_[0] = x_[0] / xnorm_;
                scale_ = scale_ / xnorm_;
              }
            }
            if (scale_ != 1.0) {
              (void) _dscal (&ki_, &scale_, &work_[1 + (*n_) - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            (void) _daxpy (($7_ = j_ - 1, &$7_), ($8_ = -x_[0], &$8_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + (*n_) - 
            1], &_k1);
          }
          else {
            (void) _dlaln2 (($9_ = FALSE, &$9_), ($10_ = 2, &$10_), &_k1, &smin_, ($11_ = 1.0, &$11_), &t_[j_ - 1 - 1 + ((*ldt_)) * 
            ((j_ - 1 - 1))], ldt_, ($12_ = 1.0, &$12_), ($13_ = 1.0, &$13_), &work_[j_ - 1 + (*n_) - 1], n_, &wr_, ($14_ = 0.0, 
            &$14_), x_, ($15_ = 2, &$15_), &scale_, &xnorm_, &ierr_);
            if (xnorm_ > 1.0) {
              beta_ = _max (work_[j_ - 1 - 1], work_[j_ - 1]);
              if (beta_ > bignum_ / xnorm_) {
                x_[0] = x_[0] / xnorm_;
                x_[1] = x_[1] / xnorm_;
                scale_ = scale_ / xnorm_;
              }
            }
            if (scale_ != 1.0) {
              (void) _dscal (&ki_, &scale_, &work_[1 + (*n_) - 1], &_k1);
            }
            work_[j_ - 1 + (*n_) - 1] = x_[0];
            work_[j_ + (*n_) - 1] = x_[1];
            (void) _daxpy (($16_ = j_ - 2, &$16_), ($17_ = -x_[0], &$17_), &t_[0 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &work_[1 + 
            (*n_) - 1], &_k1);
            (void) _daxpy (($18_ = j_ - 2, &$18_), ($19_ = -x_[1], &$19_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + (*n_) 
            - 1], &_k1);
          }
          _l60:;
        }
        if (! (over_)) {
          (void) _dcopy (&ki_, &work_[1 + (*n_) - 1], &_k1, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          ii_ = _idamax (&ki_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          remax_ = 1.0 / _abs (vr_[ii_ - 1 + ((*ldvr_)) * ((is_ - 1))]);
          (void) _dscal (&ki_, &remax_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
            vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1))] = 0.0;
          }
        }
        else {
          if (ki_ > 1) {
            (void) _dgemv (_dc_7, n_, ($20_ = ki_ - 1, &$20_), ($21_ = 1.0, &$21_), vr_, ldvr_, &work_[1 + (*n_) - 1], &_k1, 
            &work_[ki_ + (*n_) - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
          }
          ii_ = _idamax (n_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
          remax_ = 1.0 / _abs (vr_[ii_ - 1 + ((*ldvr_)) * ((ki_ - 1))]);
          (void) _dscal (n_, &remax_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
        }
      }
      else {
        if (_abs (t_[ki_ - 1 - 1 + ((*ldt_)) * ((ki_ - 1))]) >= _abs (t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))])) {
          work_[ki_ - 1 + (*n_) - 1] = 1.0;
          work_[ki_ + n2_ - 1] = wi_ / t_[ki_ - 1 - 1 + ((*ldt_)) * ((ki_ - 1))];
        }
        else {
          work_[ki_ - 1 + (*n_) - 1] = -wi_ / t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))];
          work_[ki_ + n2_ - 1] = 1.0;
        }
        work_[ki_ + (*n_) - 1] = 0.0;
        work_[ki_ - 1 + n2_ - 1] = 0.0;
        for (k_ = 1; k_ <= ki_ - 2; (k_)++) {
          work_[k_ + (*n_) - 1] = -work_[ki_ - 1 + (*n_) - 1] * t_[k_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))];
          work_[k_ + n2_ - 1] = -work_[ki_ + n2_ - 1] * t_[k_ - 1 + ((*ldt_)) * ((ki_ - 1))];
        }
        jnxt_ = ki_ - 2;
        for (j_ = ki_ - 2; j_ >= 1; (j_)--) {
          if (j_ > jnxt_) {
            goto _l90;
          }
          j1_ = j_;
          j2_ = j_;
          jnxt_ = j_ - 1;
          if (j_ > 1) {
            if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))] != 0.0) {
              j1_ = j_ - 1;
              jnxt_ = j_ - 2;
            }
          }
          if (j1_ == j2_) {
            (void) _dlaln2 (($22_ = FALSE, &$22_), &_k1, ($23_ = 2, &$23_), &smin_, ($24_ = 1.0, &$24_), &t_[j_ - 1 + ((*ldt_)) * 
            ((j_ - 1))], ldt_, ($25_ = 1.0, &$25_), ($26_ = 1.0, &$26_), &work_[j_ + (*n_) - 1], n_, &wr_, &wi_, x_, ($27_ = 2, 
            &$27_), &scale_, &xnorm_, &ierr_);
            if (xnorm_ > 1.0) {
              if (work_[j_ - 1] > bignum_ / xnorm_) {
                x_[0] = x_[0] / xnorm_;
                x_[2] = x_[2] / xnorm_;
                scale_ = scale_ / xnorm_;
              }
            }
            if (scale_ != 1.0) {
              (void) _dscal (&ki_, &scale_, &work_[1 + (*n_) - 1], &_k1);
              (void) _dscal (&ki_, &scale_, &work_[1 + n2_ - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            work_[j_ + n2_ - 1] = x_[2];
            (void) _daxpy (($28_ = j_ - 1, &$28_), ($29_ = -x_[0], &$29_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + (*n_) 
            - 1], &_k1);
            (void) _daxpy (($30_ = j_ - 1, &$30_), ($31_ = -x_[2], &$31_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + n2_ - 
            1], &_k1);
          }
          else {
            (void) _dlaln2 (($32_ = FALSE, &$32_), ($33_ = 2, &$33_), ($34_ = 2, &$34_), &smin_, ($35_ = 1.0, &$35_), &t_[j_ - 1 - 
            1 + ((*ldt_)) * ((j_ - 1 - 1))], ldt_, ($36_ = 1.0, &$36_), ($37_ = 1.0, &$37_), &work_[j_ - 1 + (*n_) - 1], n_, &wr_, 
            &wi_, x_, ($38_ = 2, &$38_), &scale_, &xnorm_, &ierr_);
            if (xnorm_ > 1.0) {
              beta_ = _max (work_[j_ - 1 - 1], work_[j_ - 1]);
              if (beta_ > bignum_ / xnorm_) {
                rec_ = 1.0 / xnorm_;
                x_[0] = x_[0] * rec_;
                x_[2] = x_[2] * rec_;
                x_[1] = x_[1] * rec_;
                x_[3] = x_[3] * rec_;
                scale_ = scale_ * rec_;
              }
            }
            if (scale_ != 1.0) {
              (void) _dscal (&ki_, &scale_, &work_[1 + (*n_) - 1], &_k1);
              (void) _dscal (&ki_, &scale_, &work_[1 + n2_ - 1], &_k1);
            }
            work_[j_ - 1 + (*n_) - 1] = x_[0];
            work_[j_ + (*n_) - 1] = x_[1];
            work_[j_ - 1 + n2_ - 1] = x_[2];
            work_[j_ + n2_ - 1] = x_[3];
            (void) _daxpy (($39_ = j_ - 2, &$39_), ($40_ = -x_[0], &$40_), &t_[0 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &work_[1 + 
            (*n_) - 1], &_k1);
            (void) _daxpy (($41_ = j_ - 2, &$41_), ($42_ = -x_[1], &$42_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + (*n_) 
            - 1], &_k1);
            (void) _daxpy (($43_ = j_ - 2, &$43_), ($44_ = -x_[2], &$44_), &t_[0 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &work_[1 + 
            n2_ - 1], &_k1);
            (void) _daxpy (($45_ = j_ - 2, &$45_), ($46_ = -x_[3], &$46_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + n2_ - 
            1], &_k1);
          }
          _l90:;
        }
        if (! (over_)) {
          (void) _dcopy (&ki_, &work_[1 + (*n_) - 1], &_k1, &vr_[0 + ((*ldvr_)) * ((is_ - 1 - 1))], &_k1);
          (void) _dcopy (&ki_, &work_[1 + n2_ - 1], &_k1, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          emax_ = 0.0;
          for (k_ = 1; k_ <= ki_; (k_)++) {
            emax_ = _max (emax_, _abs (vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1 - 1))]) + _abs (vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1))]))
            ;
          }
          remax_ = 1.0 / emax_;
          (void) _dscal (&ki_, &remax_, &vr_[0 + ((*ldvr_)) * ((is_ - 1 - 1))], &_k1);
          (void) _dscal (&ki_, &remax_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
            vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1 - 1))] = 0.0;
            vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1))] = 0.0;
          }
        }
        else {
          if (ki_ > 2) {
            (void) _dgemv (_dc_7, n_, ($47_ = ki_ - 2, &$47_), ($48_ = 1.0, &$48_), vr_, ldvr_, &work_[1 + (*n_) - 1], &_k1, 
            &work_[ki_ - 1 + (*n_) - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1 - 1))], &_k1);
            (void) _dgemv (_dc_7, n_, ($49_ = ki_ - 2, &$49_), ($50_ = 1.0, &$50_), vr_, ldvr_, &work_[1 + n2_ - 1], &_k1, 
            &work_[ki_ + n2_ - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
          }
          else {
            (void) _dscal (n_, &work_[ki_ - 1 + (*n_) - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1 - 1))], &_k1);
            (void) _dscal (n_, &work_[ki_ + n2_ - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
          }
          emax_ = 0.0;
          for (k_ = 1; k_ <= (*n_); (k_)++) {
            emax_ = _max (emax_, _abs (vr_[k_ - 1 + ((*ldvr_)) * ((ki_ - 1 - 1))]) + _abs (vr_[k_ - 1 + ((*ldvr_)) * ((ki_ - 1))]))
            ;
          }
          remax_ = 1.0 / emax_;
          (void) _dscal (n_, &remax_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1 - 1))], &_k1);
          (void) _dscal (n_, &remax_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
        }
      }
      is_ = is_ - 1;
      if (ip_ != 0) {
        is_ = is_ - 1;
      }
      _l130:;
      if (ip_ == 1) {
        ip_ = 0;
      }
      if (ip_ == -1) {
        ip_ = 1;
      }
    }
  }
  if (leftv_) {
    ip_ = 0;
    is_ = 1;
    for (ki_ = 1; ki_ <= (*n_); (ki_)++) {
      if (ip_ == -1) {
        goto _l250;
      }
      if (ki_ == (*n_)) {
        goto _l150;
      }
      if (t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ - 1))] == 0.0) {
        goto _l150;
      }
      ip_ = 1;
      _l150:;
      if (somev_) {
        if (! (select_[ki_ - 1])) {
          goto _l250;
        }
      }
      wr_ = t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))];
      wi_ = 0.0;
      if (ip_ != 0) {
        wi_ = sqrt (_abs (t_[ki_ - 1 + ((*ldt_)) * ((ki_ + 1 - 1))])) * sqrt (_abs (t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ - 1))]))
        ;
      }
      smin_ = _max (ulp_ * (_abs (wr_) + _abs (wi_)), smlnum_);
      if (ip_ == 0) {
        work_[ki_ + (*n_) - 1] = 1.0;
        for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
          work_[k_ + (*n_) - 1] = -t_[ki_ - 1 + ((*ldt_)) * ((k_ - 1))];
        }
        vmax_ = 1.0;
        vcrit_ = bignum_;
        jnxt_ = ki_ + 1;
        for (j_ = ki_ + 1; j_ <= (*n_); (j_)++) {
          if (j_ < jnxt_) {
            goto _l170;
          }
          j1_ = j_;
          j2_ = j_;
          jnxt_ = j_ + 1;
          if (j_ < (*n_)) {
            if (t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))] != 0.0) {
              j2_ = j_ + 1;
              jnxt_ = j_ + 2;
            }
          }
          if (j1_ == j2_) {
            if (work_[j_ - 1] > vcrit_) {
              rec_ = 1.0 / vmax_;
              (void) _dscal (($51_ = (*n_) - ki_ + 1, &$51_), &rec_, &work_[ki_ + (*n_) - 1], &_k1);
              vmax_ = 1.0;
              vcrit_ = bignum_;
            }
            work_[j_ + (*n_) - 1] = work_[j_ + (*n_) - 1] - _ddot (($52_ = j_ - ki_ - 1, &$52_), &t_[ki_ + 1 - 1 + ((*ldt_)) * ((j_ 
            - 1))], &_k1, &work_[ki_ + 1 + (*n_) - 1], &_k1);
            (void) _dlaln2 (($53_ = FALSE, &$53_), &_k1, &_k1, &smin_, ($54_ = 1.0, &$54_), &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))], 
            ldt_, ($55_ = 1.0, &$55_), ($56_ = 1.0, &$56_), &work_[j_ + (*n_) - 1], n_, &wr_, ($57_ = 0.0, &$57_), x_, ($58_ = 2, 
            &$58_), &scale_, &xnorm_, &ierr_);
            if (scale_ != 1.0) {
              (void) _dscal (($59_ = (*n_) - ki_ + 1, &$59_), &scale_, &work_[ki_ + (*n_) - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            vmax_ = _max (_abs (work_[j_ + (*n_) - 1]), vmax_);
            vcrit_ = bignum_ / vmax_;
          }
          else {
            beta_ = _max (work_[j_ - 1], work_[j_ + 1 - 1]);
            if (beta_ > vcrit_) {
              rec_ = 1.0 / vmax_;
              (void) _dscal (($60_ = (*n_) - ki_ + 1, &$60_), &rec_, &work_[ki_ + (*n_) - 1], &_k1);
              vmax_ = 1.0;
              vcrit_ = bignum_;
            }
            work_[j_ + (*n_) - 1] = work_[j_ + (*n_) - 1] - _ddot (($61_ = j_ - ki_ - 1, &$61_), &t_[ki_ + 1 - 1 + ((*ldt_)) * ((j_ 
            - 1))], &_k1, &work_[ki_ + 1 + (*n_) - 1], &_k1);
            work_[j_ + 1 + (*n_) - 1] = work_[j_ + 1 + (*n_) - 1] - _ddot (($62_ = j_ - ki_ - 1, &$62_), &t_[ki_ + 1 - 1 + 
            ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &work_[ki_ + 1 + (*n_) - 1], &_k1);
            (void) _dlaln2 (($63_ = TRUE, &$63_), ($64_ = 2, &$64_), &_k1, &smin_, ($65_ = 1.0, &$65_), &t_[j_ - 1 + ((*ldt_)) * 
            ((j_ - 1))], ldt_, ($66_ = 1.0, &$66_), ($67_ = 1.0, &$67_), &work_[j_ + (*n_) - 1], n_, &wr_, ($68_ = 0.0, &$68_), x_, 
            ($69_ = 2, &$69_), &scale_, &xnorm_, &ierr_);
            if (scale_ != 1.0) {
              (void) _dscal (($70_ = (*n_) - ki_ + 1, &$70_), &scale_, &work_[ki_ + (*n_) - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            work_[j_ + 1 + (*n_) - 1] = x_[1];
            vmax_ = ($71_ = _max (_abs (work_[j_ + (*n_) - 1]), _abs (work_[j_ + 1 + (*n_) - 1])), _max ($71_, vmax_));
            vcrit_ = bignum_ / vmax_;
          }
          _l170:;
        }
        if (! (over_)) {
          (void) _dcopy (($72_ = (*n_) - ki_ + 1, &$72_), &work_[ki_ + (*n_) - 1], &_k1, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 
          1))], &_k1);
          ii_ = _idamax (($73_ = (*n_) - ki_ + 1, &$73_), &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1) + ki_ - 1;
          remax_ = 1.0 / _abs (vl_[ii_ - 1 + ((*ldvl_)) * ((is_ - 1))]);
          (void) _dscal (($74_ = (*n_) - ki_ + 1, &$74_), &remax_, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1);
          for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
            vl_[k_ - 1 + ((*ldvl_)) * ((is_ - 1))] = 0.0;
          }
        }
        else {
          if (ki_ < (*n_)) {
            (void) _dgemv (_dc_7, n_, ($75_ = (*n_) - ki_, &$75_), ($76_ = 1.0, &$76_), &vl_[0 + ((*ldvl_)) * ((ki_ + 1 - 1))], 
            ldvl_, &work_[ki_ + 1 + (*n_) - 1], &_k1, &work_[ki_ + (*n_) - 1], &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
          }
          ii_ = _idamax (n_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
          remax_ = 1.0 / _abs (vl_[ii_ - 1 + ((*ldvl_)) * ((ki_ - 1))]);
          (void) _dscal (n_, &remax_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
        }
      }
      else {
        if (_abs (t_[ki_ - 1 + ((*ldt_)) * ((ki_ + 1 - 1))]) >= _abs (t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ - 1))])) {
          work_[ki_ + (*n_) - 1] = wi_ / t_[ki_ - 1 + ((*ldt_)) * ((ki_ + 1 - 1))];
          work_[ki_ + 1 + n2_ - 1] = 1.0;
        }
        else {
          work_[ki_ + (*n_) - 1] = 1.0;
          work_[ki_ + 1 + n2_ - 1] = -wi_ / t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ - 1))];
        }
        work_[ki_ + 1 + (*n_) - 1] = 0.0;
        work_[ki_ + n2_ - 1] = 0.0;
        for (k_ = ki_ + 2; k_ <= (*n_); (k_)++) {
          work_[k_ + (*n_) - 1] = -work_[ki_ + (*n_) - 1] * t_[ki_ - 1 + ((*ldt_)) * ((k_ - 1))];
          work_[k_ + n2_ - 1] = -work_[ki_ + 1 + n2_ - 1] * t_[ki_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))];
        }
        vmax_ = 1.0;
        vcrit_ = bignum_;
        jnxt_ = ki_ + 2;
        for (j_ = ki_ + 2; j_ <= (*n_); (j_)++) {
          if (j_ < jnxt_) {
            goto _l200;
          }
          j1_ = j_;
          j2_ = j_;
          jnxt_ = j_ + 1;
          if (j_ < (*n_)) {
            if (t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))] != 0.0) {
              j2_ = j_ + 1;
              jnxt_ = j_ + 2;
            }
          }
          if (j1_ == j2_) {
            if (work_[j_ - 1] > vcrit_) {
              rec_ = 1.0 / vmax_;
              (void) _dscal (($77_ = (*n_) - ki_ + 1, &$77_), &rec_, &work_[ki_ + (*n_) - 1], &_k1);
              (void) _dscal (($78_ = (*n_) - ki_ + 1, &$78_), &rec_, &work_[ki_ + n2_ - 1], &_k1);
              vmax_ = 1.0;
              vcrit_ = bignum_;
            }
            work_[j_ + (*n_) - 1] = work_[j_ + (*n_) - 1] - _ddot (($79_ = j_ - ki_ - 2, &$79_), &t_[ki_ + 2 - 1 + ((*ldt_)) * ((j_ 
            - 1))], &_k1, &work_[ki_ + 2 + (*n_) - 1], &_k1);
            work_[j_ + n2_ - 1] = work_[j_ + n2_ - 1] - _ddot (($80_ = j_ - ki_ - 2, &$80_), &t_[ki_ + 2 - 1 + ((*ldt_)) * ((j_ - 
            1))], &_k1, &work_[ki_ + 2 + n2_ - 1], &_k1);
            (void) _dlaln2 (($81_ = FALSE, &$81_), &_k1, ($82_ = 2, &$82_), &smin_, ($83_ = 1.0, &$83_), &t_[j_ - 1 + ((*ldt_)) * 
            ((j_ - 1))], ldt_, ($84_ = 1.0, &$84_), ($85_ = 1.0, &$85_), &work_[j_ + (*n_) - 1], n_, &wr_, ($86_ = -wi_, &$86_), 
            x_, ($87_ = 2, &$87_), &scale_, &xnorm_, &ierr_);
            if (scale_ != 1.0) {
              (void) _dscal (($88_ = (*n_) - ki_ + 1, &$88_), &scale_, &work_[ki_ + (*n_) - 1], &_k1);
              (void) _dscal (($89_ = (*n_) - ki_ + 1, &$89_), &scale_, &work_[ki_ + n2_ - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            work_[j_ + n2_ - 1] = x_[2];
            vmax_ = ($90_ = _max (_abs (work_[j_ + (*n_) - 1]), _abs (work_[j_ + n2_ - 1])), _max ($90_, vmax_));
            vcrit_ = bignum_ / vmax_;
          }
          else {
            beta_ = _max (work_[j_ - 1], work_[j_ + 1 - 1]);
            if (beta_ > vcrit_) {
              rec_ = 1.0 / vmax_;
              (void) _dscal (($91_ = (*n_) - ki_ + 1, &$91_), &rec_, &work_[ki_ + (*n_) - 1], &_k1);
              (void) _dscal (($92_ = (*n_) - ki_ + 1, &$92_), &rec_, &work_[ki_ + n2_ - 1], &_k1);
              vmax_ = 1.0;
              vcrit_ = bignum_;
            }
            work_[j_ + (*n_) - 1] = work_[j_ + (*n_) - 1] - _ddot (($93_ = j_ - ki_ - 2, &$93_), &t_[ki_ + 2 - 1 + ((*ldt_)) * ((j_ 
            - 1))], &_k1, &work_[ki_ + 2 + (*n_) - 1], &_k1);
            work_[j_ + n2_ - 1] = work_[j_ + n2_ - 1] - _ddot (($94_ = j_ - ki_ - 2, &$94_), &t_[ki_ + 2 - 1 + ((*ldt_)) * ((j_ - 
            1))], &_k1, &work_[ki_ + 2 + n2_ - 1], &_k1);
            work_[j_ + 1 + (*n_) - 1] = work_[j_ + 1 + (*n_) - 1] - _ddot (($95_ = j_ - ki_ - 2, &$95_), &t_[ki_ + 2 - 1 + 
            ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &work_[ki_ + 2 + (*n_) - 1], &_k1);
            work_[j_ + 1 + n2_ - 1] = work_[j_ + 1 + n2_ - 1] - _ddot (($96_ = j_ - ki_ - 2, &$96_), &t_[ki_ + 2 - 1 + ((*ldt_)) * 
            ((j_ + 1 - 1))], &_k1, &work_[ki_ + 2 + n2_ - 1], &_k1);
            (void) _dlaln2 (($97_ = TRUE, &$97_), ($98_ = 2, &$98_), ($99_ = 2, &$99_), &smin_, ($100_ = 1.0, &$100_), &t_[j_ - 1 + 
            ((*ldt_)) * ((j_ - 1))], ldt_, ($101_ = 1.0, &$101_), ($102_ = 1.0, &$102_), &work_[j_ + (*n_) - 1], n_, &wr_, ($103_ = 
            -wi_, &$103_), x_, ($104_ = 2, &$104_), &scale_, &xnorm_, &ierr_);
            if (scale_ != 1.0) {
              (void) _dscal (($105_ = (*n_) - ki_ + 1, &$105_), &scale_, &work_[ki_ + (*n_) - 1], &_k1);
              (void) _dscal (($106_ = (*n_) - ki_ + 1, &$106_), &scale_, &work_[ki_ + n2_ - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            work_[j_ + n2_ - 1] = x_[2];
            work_[j_ + 1 + (*n_) - 1] = x_[1];
            work_[j_ + 1 + n2_ - 1] = x_[3];
            vmax_ = ($107_ = _max (_abs (x_[0]), _abs (x_[2])), $107_ = _max ($107_, _abs (x_[1])), $107_ = _max ($107_, _abs 
            (x_[3])), _max ($107_, vmax_));
            vcrit_ = bignum_ / vmax_;
          }
          _l200:;
        }
        if (! (over_)) {
          (void) _dcopy (($108_ = (*n_) - ki_ + 1, &$108_), &work_[ki_ + (*n_) - 1], &_k1, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 
          1))], &_k1);
          (void) _dcopy (($109_ = (*n_) - ki_ + 1, &$109_), &work_[ki_ + n2_ - 1], &_k1, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ + 1 - 
          1))], &_k1);
          emax_ = 0.0;
          for (k_ = ki_; k_ <= (*n_); (k_)++) {
            emax_ = _max (emax_, _abs (vl_[k_ - 1 + ((*ldvl_)) * ((is_ - 1))]) + _abs (vl_[k_ - 1 + ((*ldvl_)) * ((is_ + 1 - 1))]))
            ;
          }
          remax_ = 1.0 / emax_;
          (void) _dscal (($110_ = (*n_) - ki_ + 1, &$110_), &remax_, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1);
          (void) _dscal (($111_ = (*n_) - ki_ + 1, &$111_), &remax_, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ + 1 - 1))], &_k1);
          for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
            vl_[k_ - 1 + ((*ldvl_)) * ((is_ - 1))] = 0.0;
            vl_[k_ - 1 + ((*ldvl_)) * ((is_ + 1 - 1))] = 0.0;
          }
        }
        else {
          if (ki_ < (*n_) - 1) {
            (void) _dgemv (_dc_7, n_, ($112_ = (*n_) - ki_ - 1, &$112_), ($113_ = 1.0, &$113_), &vl_[0 + ((*ldvl_)) * ((ki_ + 2 - 
            1))], ldvl_, &work_[ki_ + 2 + (*n_) - 1], &_k1, &work_[ki_ + (*n_) - 1], &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
            (void) _dgemv (_dc_7, n_, ($114_ = (*n_) - ki_ - 1, &$114_), ($115_ = 1.0, &$115_), &vl_[0 + ((*ldvl_)) * ((ki_ + 2 - 
            1))], ldvl_, &work_[ki_ + 2 + n2_ - 1], &_k1, &work_[ki_ + 1 + n2_ - 1], &vl_[0 + ((*ldvl_)) * ((ki_ + 1 - 1))], &_k1)
            ;
          }
          else {
            (void) _dscal (n_, &work_[ki_ + (*n_) - 1], &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
            (void) _dscal (n_, &work_[ki_ + 1 + n2_ - 1], &vl_[0 + ((*ldvl_)) * ((ki_ + 1 - 1))], &_k1);
          }
          emax_ = 0.0;
          for (k_ = 1; k_ <= (*n_); (k_)++) {
            emax_ = _max (emax_, _abs (vl_[k_ - 1 + ((*ldvl_)) * ((ki_ - 1))]) + _abs (vl_[k_ - 1 + ((*ldvl_)) * ((ki_ + 1 - 1))]))
            ;
          }
          remax_ = 1.0 / emax_;
          (void) _dscal (n_, &remax_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
          (void) _dscal (n_, &remax_, &vl_[0 + ((*ldvl_)) * ((ki_ + 1 - 1))], &_k1);
        }
      }
      is_ = is_ + 1;
      if (ip_ != 0) {
        is_ = is_ + 1;
      }
      _l250:;
      if (ip_ == -1) {
        ip_ = 0;
      }
      if (ip_ == 1) {
        ip_ = -1;
      }
    }
  }
  _l0:;
  __calls[55].calls++;
  return 0;
}

int_4 _dtrexc (char _p_ compq_, int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ q_, int_4 _p_ ldq_, int_4 _p_ 
ifst_, int_4 _p_ ilst_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 here_, nbf_, nbl_, nbnext_;
  static logical_4 wantq_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  wantq_ = _lsame (compq_, _dc_40);
  if (! (wantq_) && ! (_lsame (compq_, _dc_7))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -4;
  }
  else if ((*ldq_) < 1 || (wantq_ && (*ldq_) < _max (1, (*n_)))) {
    (*info_) = -6;
  }
  else if ((*ifst_) < 1 || (*ifst_) > (*n_)) {
    (*info_) = -7;
  }
  else if ((*ilst_) < 1 || (*ilst_) > (*n_)) {
    (*info_) = -8;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_57, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) <= 1) {
    goto _l0;
  }
  if ((*ifst_) > 1) {
    if (t_[(*ifst_) - 1 + ((*ldt_)) * (((*ifst_) - 1 - 1))] != 0.0) {
      (*ifst_) = (*ifst_) - 1;
    }
  }
  nbf_ = 1;
  if ((*ifst_) < (*n_)) {
    if (t_[(*ifst_) + 1 - 1 + ((*ldt_)) * (((*ifst_) - 1))] != 0.0) {
      nbf_ = 2;
    }
  }
  if ((*ilst_) > 1) {
    if (t_[(*ilst_) - 1 + ((*ldt_)) * (((*ilst_) - 1 - 1))] != 0.0) {
      (*ilst_) = (*ilst_) - 1;
    }
  }
  nbl_ = 1;
  if ((*ilst_) < (*n_)) {
    if (t_[(*ilst_) + 1 - 1 + ((*ldt_)) * (((*ilst_) - 1))] != 0.0) {
      nbl_ = 2;
    }
  }
  if ((*ifst_) == (*ilst_)) {
    goto _l0;
  }
  if ((*ifst_) < (*ilst_)) {
    if (nbf_ == 2 && nbl_ == 1) {
      (*ilst_) = (*ilst_) - 1;
    }
    if (nbf_ == 1 && nbl_ == 2) {
      (*ilst_) = (*ilst_) + 1;
    }
    here_ = (*ifst_);
    _l10:;
    if (nbf_ == 1 || nbf_ == 2) {
      nbnext_ = 1;
      if (here_ + nbf_ + 1 <= (*n_)) {
        if (t_[here_ + nbf_ + 1 - 1 + ((*ldt_)) * ((here_ + nbf_ - 1))] != 0.0) {
          nbnext_ = 2;
        }
      }
      (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &nbf_, &nbnext_, work_, info_);
      if ((*info_) != 0) {
        (*ilst_) = here_;
        goto _l0;
      }
      here_ = here_ + nbnext_;
      if (nbf_ == 2) {
        if (t_[here_ + 1 - 1 + ((*ldt_)) * ((here_ - 1))] == 0.0) {
          nbf_ = 3;
        }
      }
    }
    else {
      nbnext_ = 1;
      if (here_ + 3 <= (*n_)) {
        if (t_[here_ + 3 - 1 + ((*ldt_)) * ((here_ + 2 - 1))] != 0.0) {
          nbnext_ = 2;
        }
      }
      (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($1_ = here_ + 1, &$1_), &_k1, &nbnext_, work_, info_);
      if ((*info_) != 0) {
        (*ilst_) = here_;
        goto _l0;
      }
      if (nbnext_ == 1) {
        (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &_k1, &nbnext_, work_, info_);
        here_ = here_ + 1;
      }
      else {
        if (t_[here_ + 2 - 1 + ((*ldt_)) * ((here_ + 1 - 1))] == 0.0) {
          nbnext_ = 1;
        }
        if (nbnext_ == 2) {
          (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &_k1, &nbnext_, work_, info_);
          if ((*info_) != 0) {
            (*ilst_) = here_;
            goto _l0;
          }
          here_ = here_ + 2;
        }
        else {
          (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &_k1, &_k1, work_, info_);
          (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($2_ = here_ + 1, &$2_), &_k1, &_k1, work_, info_);
          here_ = here_ + 2;
        }
      }
    }
    if (here_ < (*ilst_)) {
      goto _l10;
    }
  }
  else {
    here_ = (*ifst_);
    _l20:;
    if (nbf_ == 1 || nbf_ == 2) {
      nbnext_ = 1;
      if (here_ >= 3) {
        if (t_[here_ - 1 - 1 + ((*ldt_)) * ((here_ - 2 - 1))] != 0.0) {
          nbnext_ = 2;
        }
      }
      (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($3_ = here_ - nbnext_, &$3_), &nbnext_, &nbf_, work_, info_);
      if ((*info_) != 0) {
        (*ilst_) = here_;
        goto _l0;
      }
      here_ = here_ - nbnext_;
      if (nbf_ == 2) {
        if (t_[here_ + 1 - 1 + ((*ldt_)) * ((here_ - 1))] == 0.0) {
          nbf_ = 3;
        }
      }
    }
    else {
      nbnext_ = 1;
      if (here_ >= 3) {
        if (t_[here_ - 1 - 1 + ((*ldt_)) * ((here_ - 2 - 1))] != 0.0) {
          nbnext_ = 2;
        }
      }
      (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($4_ = here_ - nbnext_, &$4_), &nbnext_, &_k1, work_, info_);
      if ((*info_) != 0) {
        (*ilst_) = here_;
        goto _l0;
      }
      if (nbnext_ == 1) {
        (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &nbnext_, &_k1, work_, info_);
        here_ = here_ - 1;
      }
      else {
        if (t_[here_ - 1 + ((*ldt_)) * ((here_ - 1 - 1))] == 0.0) {
          nbnext_ = 1;
        }
        if (nbnext_ == 2) {
          (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($5_ = here_ - 1, &$5_), ($6_ = 2, &$6_), &_k1, work_, info_);
          if ((*info_) != 0) {
            (*ilst_) = here_;
            goto _l0;
          }
          here_ = here_ - 2;
        }
        else {
          (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &_k1, &_k1, work_, info_);
          (void) _dlaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($7_ = here_ - 1, &$7_), &_k1, &_k1, work_, info_);
          here_ = here_ - 2;
        }
      }
    }
    if (here_ > (*ilst_)) {
      goto _l20;
    }
  }
  (*ilst_) = here_;
  _l0:;
  __calls[56].calls++;
  return 0;
}

int_4 _dtrsen (char _p_ job_, char _p_ compq_, logical_4 _p_ select_, int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ ldt_, 
real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ wr_, real_8 _p_ wi_, int_4 _p_ m_, real_8 _p_ s_, real_8 _p_ sep_, real_8 _p_ 
work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ info_)
{
  static int_4 ierr_, k_, kase_, kk_, ks_, n1_, n2_, nn_;
  static logical_4 pair_, swap_, wantbh_, wantq_, wants_, wantsp_;
  static real_8 est_, rnorm_, scale_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern real_8 _dlange ();
  extern int_4 _dlacpy ();
  extern int_4 _xerbla ();
  wantbh_ = _lsame (job_, _dc_31);
  wants_ = _lsame (job_, _dc_27) || wantbh_;
  wantsp_ = _lsame (job_, _dc_40) || wantbh_;
  wantq_ = _lsame (compq_, _dc_40);
  (*info_) = 0;
  if (! (_lsame (job_, _dc_7)) && ! (wants_) && ! (wantsp_)) {
    (*info_) = -1;
  }
  else if (! (_lsame (compq_, _dc_7)) && ! (wantq_)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  else if ((*ldq_) < 1 || (wantq_ && (*ldq_) < (*n_))) {
    (*info_) = -8;
  }
  else {
    (*m_) = 0;
    pair_ = FALSE;
    for (k_ = 1; k_ <= (*n_); (k_)++) {
      if (pair_) {
        pair_ = FALSE;
      }
      else {
        if (k_ < (*n_)) {
          if (t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0) {
            if (select_[k_ - 1]) {
              (*m_) = (*m_) + 1;
            }
          }
          else {
            pair_ = TRUE;
            if (select_[k_ - 1] || select_[k_ + 1 - 1]) {
              (*m_) = (*m_) + 2;
            }
          }
        }
        else {
          if (select_[(*n_) - 1]) {
            (*m_) = (*m_) + 1;
          }
        }
      }
    }
    n1_ = (*m_);
    n2_ = (*n_) - (*m_);
    nn_ = n1_ * n2_;
    if ((*lwork_) < 1 || ((wants_ && ! (wantsp_)) && (*lwork_) < nn_) || (wantsp_ && (*lwork_) < 2 * nn_)) {
      (*info_) = -15;
    }
    else if ((*liwork_) < 1 || (wantsp_ && (*liwork_) < nn_)) {
      (*info_) = -17;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_58, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == (*n_) || (*m_) == 0) {
    if (wants_) {
      (*s_) = 1.0;
    }
    if (wantsp_) {
      (*sep_) = _dlange (_dc_22, n_, n_, t_, ldt_, work_);
    }
    goto _l40;
  }
  ks_ = 0;
  pair_ = FALSE;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (pair_) {
      pair_ = FALSE;
    }
    else {
      swap_ = select_[k_ - 1];
      if (k_ < (*n_)) {
        if (t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))] != 0.0) {
          pair_ = TRUE;
          swap_ = swap_ || select_[k_ + 1 - 1];
        }
      }
      if (swap_) {
        ks_ = ks_ + 1;
        ierr_ = 0;
        kk_ = k_;
        if (k_ != ks_) {
          (void) _dtrexc (compq_, n_, t_, ldt_, q_, ldq_, &kk_, &ks_, work_, &ierr_);
        }
        if (ierr_ == 1 || ierr_ == 2) {
          (*info_) = 1;
          if (wants_) {
            (*s_) = 0.0;
          }
          if (wantsp_) {
            (*sep_) = 0.0;
          }
          goto _l40;
        }
        if (pair_) {
          ks_ = ks_ + 1;
        }
      }
    }
  }
  if (wants_) {
    (void) _dlacpy (_dc_26, &n1_, &n2_, &t_[0 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, &n1_);
    (void) _dtrsyl (_dc_7, _dc_7, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
    &n1_, &scale_, &ierr_);
    rnorm_ = _dlange (_dc_26, &n1_, &n2_, work_, &n1_, work_);
    if (rnorm_ == 0.0) {
      (*s_) = 1.0;
    }
    else {
      (*s_) = scale_ / (sqrt (scale_ * scale_ / rnorm_ + rnorm_) * sqrt (rnorm_));
    }
  }
  if (wantsp_) {
    est_ = 0.0;
    kase_ = 0;
    _l30:;
    (void) _dlacon (&nn_, &work_[nn_ + 1 - 1], work_, iwork_, &est_, &kase_);
    if (kase_ != 0) {
      if (kase_ == 1) {
        (void) _dtrsyl (_dc_7, _dc_7, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
        &n1_, &scale_, &ierr_);
      }
      else {
        (void) _dtrsyl (_dc_8, _dc_8, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
        &n1_, &scale_, &ierr_);
      }
      goto _l30;
    }
    (*sep_) = scale_ / est_;
  }
  _l40:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    wr_[k_ - 1] = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    wi_[k_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*n_) - 1; (k_)++) {
    if (t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))] != 0.0) {
      wi_[k_ - 1] = sqrt (_abs (t_[k_ - 1 + ((*ldt_)) * ((k_ + 1 - 1))])) * sqrt (_abs (t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 
      1))]));
      wi_[k_ + 1 - 1] = -wi_[k_ - 1];
    }
  }
  _l0:;
  __calls[57].calls++;
  return 0;
}

int_4 _dtrsyl (char _p_ trana_, char _p_ tranb_, int_4 _p_ isgn_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ 
lda_, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ scale_, int_4 _p_ info_)
{
  static int_4 ierr_, j_, k_, k1_, k2_, knext_, l_, l1_, l2_, lnext_;
  static logical_4 notrna_, notrnb_;
  static real_8 a11_, bignum_, da11_, db_, eps_, scaloc_, sgn_, smin_, smlnum_, suml_, sumr_, xnorm_, dum_[1], vec_[4], 
  x_[4];
  int_4 $0_, $2_, $3_, $4_, $5_, $6_, $7_, $9_, $13_, $16_, $17_, $18_, $19_, $20_, $22_, $26_, $29_, $30_, $31_, $32_, 
  $33_, $34_, $35_, $36_, $37_, $40_, $41_, $42_, $43_, $44_, $45_, $46_, $47_, $48_, $49_, $51_, $55_, $58_, $59_, $60_, 
  $61_, $62_, $64_, $68_, $71_, $72_, $73_, $74_, $75_, $76_, $77_, $78_, $79_, $82_, $83_, $84_, $85_, $86_, $87_, $88_, 
  $89_, $90_, $91_, $93_, $97_, $100_, $101_, $102_, $103_, $104_, $106_, $110_, $113_, $114_, $115_, $116_, $117_, $118_
  , $119_, $120_, $121_, $124_, $125_, $126_, $127_, $128_, $129_, $130_, $131_, $132_, $133_, $135_, $139_, $142_, $143_
  , $144_, $145_, $146_, $148_, $152_, $155_, $156_, $157_, $158_, $159_, $160_, $161_, $162_, $163_, $166_, $167_, $168_
  , $169_;
  logical_4 $8_, $21_, $38_, $39_, $50_, $63_, $80_, $81_, $92_, $105_, $122_, $123_, $134_, $147_, $164_, $165_;
  real_8 $1_, $10_, $11_, $12_, $14_, $15_, $23_, $24_, $25_, $27_, $28_, $52_, $53_, $54_, $56_, $57_, $65_, $66_, $67_, 
  $69_, $70_, $94_, $95_, $96_, $98_, $99_, $107_, $108_, $109_, $111_, $112_, $136_, $137_, $138_, $140_, $141_, $149_, 
  $150_, $151_, $153_, $154_;
  extern logical_4 _lsame ();
  extern real_8 _ddot ();
  extern real_8 _dlamch ();
  extern real_8 _dlange ();
  extern int_4 _dlabad ();
  extern int_4 _dscal ();
  extern int_4 _xerbla ();
  notrna_ = _lsame (trana_, _dc_7);
  notrnb_ = _lsame (tranb_, _dc_7);
  (*info_) = 0;
  if (! (notrna_) && ! (_lsame (trana_, _dc_8)) && ! (_lsame (trana_, _dc_9))) {
    (*info_) = -1;
  }
  else if (! (notrnb_) && ! (_lsame (tranb_, _dc_8)) && ! (_lsame (tranb_, _dc_9))) {
    (*info_) = -2;
  }
  else if ((*isgn_) != 1 && (*isgn_) != -1) {
    (*info_) = -3;
  }
  else if ((*m_) < 0) {
    (*info_) = -4;
  }
  else if ((*n_) < 0) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -7;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -11;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_59, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  eps_ = _dlamch (_dc_44);
  smlnum_ = _dlamch (_dc_28);
  bignum_ = 1.0 / smlnum_;
  (void) _dlabad (&smlnum_, &bignum_);
  smlnum_ = smlnum_ * (real_8) ((*m_) * (*n_)) / eps_;
  bignum_ = 1.0 / smlnum_;
  smin_ = ($1_ = _max (smlnum_, eps_ * _dlange (_dc_23, m_, m_, a_, lda_, dum_)), _max ($1_, eps_ * _dlange (_dc_23, n_, 
  n_, b_, ldb_, dum_)));
  (*scale_) = 1.0;
  sgn_ = (*isgn_);
  if (notrna_ && notrnb_) {
    lnext_ = 1;
    for (l_ = 1; l_ <= (*n_); (l_)++) {
      if (l_ < lnext_) {
        goto _l60;
      }
      if (l_ == (*n_)) {
        l1_ = l_;
        l2_ = l_;
      }
      else {
        if (b_[l_ + 1 - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0) {
          l1_ = l_;
          l2_ = l_ + 1;
          lnext_ = l_ + 2;
        }
        else {
          l1_ = l_;
          l2_ = l_;
          lnext_ = l_ + 1;
        }
      }
      knext_ = (*m_);
      for (k_ = (*m_); k_ >= 1; (k_)--) {
        if (k_ > knext_) {
          goto _l50;
        }
        if (k_ == 1) {
          k1_ = k_;
          k2_ = k_;
        }
        else {
          if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] != 0.0) {
            k1_ = k_ - 1;
            k2_ = k_;
            knext_ = k_ - 2;
          }
          else {
            k1_ = k_;
            k2_ = k_;
            knext_ = k_ - 1;
          }
        }
        if (l1_ == l2_ && k1_ == k2_) {
          suml_ = _ddot (($2_ = (*m_) - k1_, &$2_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min (k1_ 
          + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($3_ = l1_ - 1, &$3_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          scaloc_ = 1.0;
          a11_ = a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))] + sgn_ * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))];
          da11_ = _abs (a11_);
          if (da11_ <= smin_) {
            a11_ = smin_;
            da11_ = smin_;
            (*info_) = 1;
          }
          db_ = _abs (vec_[0]);
          if (da11_ < 1.0 && db_ > 1.0) {
            if (db_ > bignum_ * da11_) {
              scaloc_ = 1.0 / db_;
            }
          }
          x_[0] = (vec_[0] * scaloc_) / a11_;
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
        }
        else if (l1_ == l2_ && k1_ != k2_) {
          suml_ = _ddot (($4_ = (*m_) - k2_, &$4_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min (k2_ 
          + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($5_ = l1_ - 1, &$5_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($6_ = (*m_) - k2_, &$6_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min (k2_ 
          + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($7_ = l1_ - 1, &$7_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _dlaln2 (($8_ = FALSE, &$8_), ($9_ = 2, &$9_), &_k1, &smin_, ($10_ = 1.0, &$10_), &a_[k1_ - 1 + ((*lda_)) * 
          ((k1_ - 1))], lda_, ($11_ = 1.0, &$11_), ($12_ = 1.0, &$12_), vec_, ($13_ = 2, &$13_), ($14_ = -sgn_ * b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], &$14_), ($15_ = 0.0, &$15_), x_, ($16_ = 2, &$16_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ == k2_) {
          suml_ = _ddot (($17_ = (*m_) - k1_, &$17_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($18_ = l1_ - 1, &$18_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_));
          suml_ = _ddot (($19_ = (*m_) - k1_, &$19_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _ddot (($20_ = l1_ - 1, &$20_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[1] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_));
          (void) _dlaln2 (($21_ = TRUE, &$21_), ($22_ = 2, &$22_), &_k1, &smin_, ($23_ = 1.0, &$23_), &b_[l1_ - 1 + ((*ldb_)) * 
          ((l1_ - 1))], ldb_, ($24_ = 1.0, &$24_), ($25_ = 1.0, &$25_), vec_, ($26_ = 2, &$26_), ($27_ = -sgn_ * a_[k1_ - 1 + 
          ((*lda_)) * ((k1_ - 1))], &$27_), ($28_ = 0.0, &$28_), x_, ($29_ = 2, &$29_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ != k2_) {
          suml_ = _ddot (($30_ = (*m_) - k2_, &$30_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($31_ = l1_ - 1, &$31_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($32_ = (*m_) - k2_, &$32_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _ddot (($33_ = l1_ - 1, &$33_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[2] = c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($34_ = (*m_) - k2_, &$34_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($35_ = l1_ - 1, &$35_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($36_ = (*m_) - k2_, &$36_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _ddot (($37_ = l1_ - 1, &$37_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[3] = c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _dlasy2 (($38_ = FALSE, &$38_), ($39_ = FALSE, &$39_), isgn_, ($40_ = 2, &$40_), ($41_ = 2, &$41_), &a_[k1_ - 1 
          + ((*lda_)) * ((k1_ - 1))], lda_, &b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], ldb_, vec_, ($42_ = 2, &$42_), &scaloc_, x_, 
          ($43_ = 2, &$43_), &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[2];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
          c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[3];
        }
        _l50:;
      }
      _l60:;
    }
  }
  else if (! (notrna_) && notrnb_) {
    lnext_ = 1;
    for (l_ = 1; l_ <= (*n_); (l_)++) {
      if (l_ < lnext_) {
        goto _l120;
      }
      if (l_ == (*n_)) {
        l1_ = l_;
        l2_ = l_;
      }
      else {
        if (b_[l_ + 1 - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0) {
          l1_ = l_;
          l2_ = l_ + 1;
          lnext_ = l_ + 2;
        }
        else {
          l1_ = l_;
          l2_ = l_;
          lnext_ = l_ + 1;
        }
      }
      knext_ = 1;
      for (k_ = 1; k_ <= (*m_); (k_)++) {
        if (k_ < knext_) {
          goto _l110;
        }
        if (k_ == (*m_)) {
          k1_ = k_;
          k2_ = k_;
        }
        else {
          if (a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
            k1_ = k_;
            k2_ = k_ + 1;
            knext_ = k_ + 2;
          }
          else {
            k1_ = k_;
            k2_ = k_;
            knext_ = k_ + 1;
          }
        }
        if (l1_ == l2_ && k1_ == k2_) {
          suml_ = _ddot (($44_ = k1_ - 1, &$44_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($45_ = l1_ - 1, &$45_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          scaloc_ = 1.0;
          a11_ = a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))] + sgn_ * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))];
          da11_ = _abs (a11_);
          if (da11_ <= smin_) {
            a11_ = smin_;
            da11_ = smin_;
            (*info_) = 1;
          }
          db_ = _abs (vec_[0]);
          if (da11_ < 1.0 && db_ > 1.0) {
            if (db_ > bignum_ * da11_) {
              scaloc_ = 1.0 / db_;
            }
          }
          x_[0] = (vec_[0] * scaloc_) / a11_;
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
        }
        else if (l1_ == l2_ && k1_ != k2_) {
          suml_ = _ddot (($46_ = k1_ - 1, &$46_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($47_ = l1_ - 1, &$47_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($48_ = k1_ - 1, &$48_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($49_ = l1_ - 1, &$49_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _dlaln2 (($50_ = TRUE, &$50_), ($51_ = 2, &$51_), &_k1, &smin_, ($52_ = 1.0, &$52_), &a_[k1_ - 1 + ((*lda_)) * 
          ((k1_ - 1))], lda_, ($53_ = 1.0, &$53_), ($54_ = 1.0, &$54_), vec_, ($55_ = 2, &$55_), ($56_ = -sgn_ * b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], &$56_), ($57_ = 0.0, &$57_), x_, ($58_ = 2, &$58_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ == k2_) {
          suml_ = _ddot (($59_ = k1_ - 1, &$59_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($60_ = l1_ - 1, &$60_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_));
          suml_ = _ddot (($61_ = k1_ - 1, &$61_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($62_ = l1_ - 1, &$62_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[1] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_));
          (void) _dlaln2 (($63_ = TRUE, &$63_), ($64_ = 2, &$64_), &_k1, &smin_, ($65_ = 1.0, &$65_), &b_[l1_ - 1 + ((*ldb_)) * 
          ((l1_ - 1))], ldb_, ($66_ = 1.0, &$66_), ($67_ = 1.0, &$67_), vec_, ($68_ = 2, &$68_), ($69_ = -sgn_ * a_[k1_ - 1 + 
          ((*lda_)) * ((k1_ - 1))], &$69_), ($70_ = 0.0, &$70_), x_, ($71_ = 2, &$71_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ != k2_) {
          suml_ = _ddot (($72_ = k1_ - 1, &$72_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($73_ = l1_ - 1, &$73_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($74_ = k1_ - 1, &$74_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($75_ = l1_ - 1, &$75_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[2] = c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($76_ = k1_ - 1, &$76_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($77_ = l1_ - 1, &$77_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($78_ = k1_ - 1, &$78_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($79_ = l1_ - 1, &$79_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[3] = c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _dlasy2 (($80_ = TRUE, &$80_), ($81_ = FALSE, &$81_), isgn_, ($82_ = 2, &$82_), ($83_ = 2, &$83_), &a_[k1_ - 1 + 
          ((*lda_)) * ((k1_ - 1))], lda_, &b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], ldb_, vec_, ($84_ = 2, &$84_), &scaloc_, x_, 
          ($85_ = 2, &$85_), &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[2];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
          c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[3];
        }
        _l110:;
      }
      _l120:;
    }
  }
  else if (! (notrna_) && ! (notrnb_)) {
    lnext_ = (*n_);
    for (l_ = (*n_); l_ >= 1; (l_)--) {
      if (l_ > lnext_) {
        goto _l180;
      }
      if (l_ == 1) {
        l1_ = l_;
        l2_ = l_;
      }
      else {
        if (b_[l_ - 1 + ((*ldb_)) * ((l_ - 1 - 1))] != 0.0) {
          l1_ = l_ - 1;
          l2_ = l_;
          lnext_ = l_ - 2;
        }
        else {
          l1_ = l_;
          l2_ = l_;
          lnext_ = l_ - 1;
        }
      }
      knext_ = 1;
      for (k_ = 1; k_ <= (*m_); (k_)++) {
        if (k_ < knext_) {
          goto _l170;
        }
        if (k_ == (*m_)) {
          k1_ = k_;
          k2_ = k_;
        }
        else {
          if (a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
            k1_ = k_;
            k2_ = k_ + 1;
            knext_ = k_ + 2;
          }
          else {
            k1_ = k_;
            k2_ = k_;
            knext_ = k_ + 1;
          }
        }
        if (l1_ == l2_ && k1_ == k2_) {
          suml_ = _ddot (($86_ = k1_ - 1, &$86_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($87_ = (*n_) - l1_, &$87_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l1_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 1 
          + ((*ldb_)) * ((_min (l1_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          scaloc_ = 1.0;
          a11_ = a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))] + sgn_ * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))];
          da11_ = _abs (a11_);
          if (da11_ <= smin_) {
            a11_ = smin_;
            da11_ = smin_;
            (*info_) = 1;
          }
          db_ = _abs (vec_[0]);
          if (da11_ < 1.0 && db_ > 1.0) {
            if (db_ > bignum_ * da11_) {
              scaloc_ = 1.0 / db_;
            }
          }
          x_[0] = (vec_[0] * scaloc_) / a11_;
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
        }
        else if (l1_ == l2_ && k1_ != k2_) {
          suml_ = _ddot (($88_ = k1_ - 1, &$88_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($89_ = (*n_) - l2_, &$89_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 1 
          + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($90_ = k1_ - 1, &$90_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _ddot (($91_ = (*n_) - l2_, &$91_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 1 
          + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _dlaln2 (($92_ = TRUE, &$92_), ($93_ = 2, &$93_), &_k1, &smin_, ($94_ = 1.0, &$94_), &a_[k1_ - 1 + ((*lda_)) * 
          ((k1_ - 1))], lda_, ($95_ = 1.0, &$95_), ($96_ = 1.0, &$96_), vec_, ($97_ = 2, &$97_), ($98_ = -sgn_ * b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], &$98_), ($99_ = 0.0, &$99_), x_, ($100_ = 2, &$100_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ == k2_) {
          suml_ = _ddot (($101_ = k1_ - 1, &$101_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], 
          &_k1);
          sumr_ = _ddot (($102_ = (*n_) - l2_, &$102_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_));
          suml_ = _ddot (($103_ = k1_ - 1, &$103_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], 
          &_k1);
          sumr_ = _ddot (($104_ = (*n_) - l2_, &$104_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_));
          (void) _dlaln2 (($105_ = FALSE, &$105_), ($106_ = 2, &$106_), &_k1, &smin_, ($107_ = 1.0, &$107_), &b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], ldb_, ($108_ = 1.0, &$108_), ($109_ = 1.0, &$109_), vec_, ($110_ = 2, &$110_), ($111_ = -sgn_ 
          * a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))], &$111_), ($112_ = 0.0, &$112_), x_, ($113_ = 2, &$113_), &scaloc_, &xnorm_, 
          &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ != k2_) {
          suml_ = _ddot (($114_ = k1_ - 1, &$114_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], 
          &_k1);
          sumr_ = _ddot (($115_ = (*n_) - l2_, &$115_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($116_ = k1_ - 1, &$116_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], 
          &_k1);
          sumr_ = _ddot (($117_ = (*n_) - l2_, &$117_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[2] = c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($118_ = k1_ - 1, &$118_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], 
          &_k1);
          sumr_ = _ddot (($119_ = (*n_) - l2_, &$119_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($120_ = k1_ - 1, &$120_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], 
          &_k1);
          sumr_ = _ddot (($121_ = (*n_) - l2_, &$121_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[3] = c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _dlasy2 (($122_ = TRUE, &$122_), ($123_ = TRUE, &$123_), isgn_, ($124_ = 2, &$124_), ($125_ = 2, &$125_), 
          &a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))], lda_, &b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], ldb_, vec_, ($126_ = 2, &$126_), 
          &scaloc_, x_, ($127_ = 2, &$127_), &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[2];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
          c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[3];
        }
        _l170:;
      }
      _l180:;
    }
  }
  else if (notrna_ && ! (notrnb_)) {
    lnext_ = (*n_);
    for (l_ = (*n_); l_ >= 1; (l_)--) {
      if (l_ > lnext_) {
        goto _l240;
      }
      if (l_ == 1) {
        l1_ = l_;
        l2_ = l_;
      }
      else {
        if (b_[l_ - 1 + ((*ldb_)) * ((l_ - 1 - 1))] != 0.0) {
          l1_ = l_ - 1;
          l2_ = l_;
          lnext_ = l_ - 2;
        }
        else {
          l1_ = l_;
          l2_ = l_;
          lnext_ = l_ - 1;
        }
      }
      knext_ = (*m_);
      for (k_ = (*m_); k_ >= 1; (k_)--) {
        if (k_ > knext_) {
          goto _l230;
        }
        if (k_ == 1) {
          k1_ = k_;
          k2_ = k_;
        }
        else {
          if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] != 0.0) {
            k1_ = k_ - 1;
            k2_ = k_;
            knext_ = k_ - 2;
          }
          else {
            k1_ = k_;
            k2_ = k_;
            knext_ = k_ - 1;
          }
        }
        if (l1_ == l2_ && k1_ == k2_) {
          suml_ = _ddot (($128_ = (*m_) - k1_, &$128_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($129_ = (*n_) - l1_, &$129_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l1_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l1_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          scaloc_ = 1.0;
          a11_ = a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))] + sgn_ * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))];
          da11_ = _abs (a11_);
          if (da11_ <= smin_) {
            a11_ = smin_;
            da11_ = smin_;
            (*info_) = 1;
          }
          db_ = _abs (vec_[0]);
          if (da11_ < 1.0 && db_ > 1.0) {
            if (db_ > bignum_ * da11_) {
              scaloc_ = 1.0 / db_;
            }
          }
          x_[0] = (vec_[0] * scaloc_) / a11_;
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
        }
        else if (l1_ == l2_ && k1_ != k2_) {
          suml_ = _ddot (($130_ = (*m_) - k2_, &$130_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($131_ = (*n_) - l2_, &$131_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($132_ = (*m_) - k2_, &$132_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($133_ = (*n_) - l2_, &$133_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _dlaln2 (($134_ = FALSE, &$134_), ($135_ = 2, &$135_), &_k1, &smin_, ($136_ = 1.0, &$136_), &a_[k1_ - 1 + 
          ((*lda_)) * ((k1_ - 1))], lda_, ($137_ = 1.0, &$137_), ($138_ = 1.0, &$138_), vec_, ($139_ = 2, &$139_), ($140_ = -sgn_ 
          * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], &$140_), ($141_ = 0.0, &$141_), x_, ($142_ = 2, &$142_), &scaloc_, &xnorm_, 
          &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ == k2_) {
          suml_ = _ddot (($143_ = (*m_) - k1_, &$143_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($144_ = (*n_) - l2_, &$144_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_));
          suml_ = _ddot (($145_ = (*m_) - k1_, &$145_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _ddot (($146_ = (*n_) - l2_, &$146_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_));
          (void) _dlaln2 (($147_ = FALSE, &$147_), ($148_ = 2, &$148_), &_k1, &smin_, ($149_ = 1.0, &$149_), &b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], ldb_, ($150_ = 1.0, &$150_), ($151_ = 1.0, &$151_), vec_, ($152_ = 2, &$152_), ($153_ = -sgn_ 
          * a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))], &$153_), ($154_ = 0.0, &$154_), x_, ($155_ = 2, &$155_), &scaloc_, &xnorm_, 
          &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ != k2_) {
          suml_ = _ddot (($156_ = (*m_) - k2_, &$156_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($157_ = (*n_) - l2_, &$157_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($158_ = (*m_) - k2_, &$158_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _ddot (($159_ = (*n_) - l2_, &$159_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[2] = c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($160_ = (*m_) - k2_, &$160_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _ddot (($161_ = (*n_) - l2_, &$161_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _ddot (($162_ = (*m_) - k2_, &$162_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _ddot (($163_ = (*n_) - l2_, &$163_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[3] = c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _dlasy2 (($164_ = FALSE, &$164_), ($165_ = TRUE, &$165_), isgn_, ($166_ = 2, &$166_), ($167_ = 2, &$167_), 
          &a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))], lda_, &b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], ldb_, vec_, ($168_ = 2, &$168_), 
          &scaloc_, x_, ($169_ = 2, &$169_), &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _dscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[2];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
          c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[3];
        }
        _l230:;
      }
      _l240:;
    }
  }
  _l0:;
  __calls[58].calls++;
  return 0;
}

real_8 _dzsum1 (int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ incx_)
{
  static int_4 i_, nincx_;
  static real_8 stemp_;
  real_8 dzsum1_;
  dzsum1_ = 0.0;
  stemp_ = 0.0;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    stemp_ = stemp_ + cabs (cx_[i_ - 1]);
  }
  dzsum1_ = stemp_;
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = stemp_ + cabs (cx_[i_ - 1]);
  }
  dzsum1_ = stemp_;
  _l0:;
  __calls[59].calls++;
  return dzsum1_;
}

int_4 _icmax1 (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  static real_4 smax_;
  static complex_8 zdum_;
  int_4 icmax1_;
  icmax1_ = 0;
  if ((*n_) < 1) {
    goto _l0;
  }
  icmax1_ = 1;
  if ((*n_) == 1) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l30;
  }
  ix_ = 1;
  smax_ = ({complex_8 zdum__1_ = cx_[0]; _abs ((real_4) (crealf (zdum__1_)));});
  ix_ = ix_ + (*incx_);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (({complex_8 zdum__1_ = cx_[ix_ - 1]; _abs ((real_4) (crealf (zdum__1_)));}) <= smax_) {
    goto _l10;
  }
  icmax1_ = i_;
  smax_ = ({complex_8 zdum__1_ = cx_[ix_ - 1]; _abs ((real_4) (crealf (zdum__1_)));});
  _l10:;
  ix_ = ix_ + (*incx_);
}

goto _l0;
_l30:;
smax_ = ({complex_8 zdum__1_ = cx_[0]; _abs ((real_4) (crealf (zdum__1_)));});
for (i_ = 2; i_ <= (*n_); (i_)++) {
  if (({complex_8 zdum__1_ = cx_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_)));}) <= smax_) {
  goto _l40;
}

icmax1_ = i_;
smax_ = ({complex_8 zdum__1_ = cx_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_)));});
_l40:;
}

_l0:;
__calls[60].calls++;
return icmax1_;
}

int_4 _izmax1 (int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ incx_)
{
  static int_4 i_, ix_;
  static real_8 smax_;
  static complex_16 zdum_;
  int_4 izmax1_;
  izmax1_ = 0;
  if ((*n_) < 1) {
    goto _l0;
  }
  izmax1_ = 1;
  if ((*n_) == 1) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l30;
  }
  ix_ = 1;
  smax_ = ({complex_16 zdum__1_ = cx_[0]; _abs ((real_8) (creal (zdum__1_)));});
  ix_ = ix_ + (*incx_);
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (({complex_16 zdum__1_ = cx_[ix_ - 1]; _abs ((real_8) (creal (zdum__1_)));}) <= smax_) {
    goto _l10;
  }
  izmax1_ = i_;
  smax_ = ({complex_16 zdum__1_ = cx_[ix_ - 1]; _abs ((real_8) (creal (zdum__1_)));});
  _l10:;
  ix_ = ix_ + (*incx_);
}

goto _l0;
_l30:;
smax_ = ({complex_16 zdum__1_ = cx_[0]; _abs ((real_8) (creal (zdum__1_)));});
for (i_ = 2; i_ <= (*n_); (i_)++) {
  if (({complex_16 zdum__1_ = cx_[i_ - 1]; _abs ((real_8) (creal (zdum__1_)));}) <= smax_) {
  goto _l40;
}

izmax1_ = i_;
smax_ = ({complex_16 zdum__1_ = cx_[i_ - 1]; _abs ((real_8) (creal (zdum__1_)));});
_l40:;
}

_l0:;
__calls[61].calls++;
return izmax1_;
}

real_4 _scsum1 (int_4 _p_ n_, complex_8 _p_ cx_, int_4 _p_ incx_)
{
  static int_4 i_, nincx_;
  static real_4 stemp_;
  real_4 scsum1_;
  scsum1_ = 0.0;
  stemp_ = 0.0;
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1) {
    goto _l20;
  }
  nincx_ = (*n_) * (*incx_);
  for (i_ = 1; ((*incx_) > 0 ? i_ <= nincx_ : i_ >= nincx_); i_ += (*incx_)) {
    stemp_ = stemp_ + cabsf (cx_[i_ - 1]);
  }
  scsum1_ = stemp_;
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = stemp_ + cabsf (cx_[i_ - 1]);
  }
  scsum1_ = stemp_;
  _l0:;
  __calls[62].calls++;
  return scsum1_;
}

int_4 _sgbtf2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ ab_, int_4 _p_ ldab_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_, j_, jp_, ju_, km_, kv_;
  int_4 $0_, $1_, $2_, $3_, $4_, $6_, $8_, $9_;
  real_4 $5_, $7_;
  extern int_4 _isamax ();
  extern int_4 _sger ();
  extern int_4 _sscal ();
  extern int_4 _sswap ();
  extern int_4 _xerbla ();
  kv_ = (*ku_) + (*kl_);
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldab_) < (*kl_) + kv_ + 1) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_60, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  for (j_ = (*ku_) + 2; j_ <= _min (kv_, (*n_)); (j_)++) {
    for (i_ = kv_ - j_ + 2; i_ <= (*kl_); (i_)++) {
      ab_[i_ - 1 + ((*ldab_)) * ((j_ - 1))] = 0.0;
    }
  }
  ju_ = 1;
  for (j_ = 1; j_ <= _min ((*m_), (*n_)); (j_)++) {
    if (j_ + kv_ <= (*n_)) {
      for (i_ = 1; i_ <= (*kl_); (i_)++) {
        ab_[i_ - 1 + ((*ldab_)) * ((j_ + kv_ - 1))] = 0.0;
      }
    }
    km_ = _min ((*kl_), (*m_) - j_);
    jp_ = _isamax (($1_ = km_ + 1, &$1_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1);
    ipiv_[j_ - 1] = jp_ + j_ - 1;
    if (ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((j_ - 1))] != 0.0) {
      ju_ = _max (ju_, _min (j_ + (*ku_) + jp_ - 1, (*n_)));
      if (jp_ != 1) {
        (void) _sswap (($2_ = ju_ - j_ + 1, &$2_), &ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((j_ - 1))], ($3_ = (*ldab_) - 1, &$3_), 
        &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], ($4_ = (*ldab_) - 1, &$4_));
      }
      if (km_ > 0) {
        (void) _sscal (&km_, ($5_ = 1.0 / ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &$5_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * 
        ((j_ - 1))], &_k1);
        if (ju_ > j_) {
          (void) _sger (&km_, ($6_ = ju_ - j_, &$6_), ($7_ = -1.0, &$7_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, 
          &ab_[kv_ - 1 + ((*ldab_)) * ((j_ + 1 - 1))], ($8_ = (*ldab_) - 1, &$8_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ + 1 - 
          1))], ($9_ = (*ldab_) - 1, &$9_));
        }
      }
    }
    else {
      if ((*info_) == 0) {
        (*info_) = j_;
      }
    }
  }
  _l0:;
  __calls[63].calls++;
  return 0;
}

int_4 _sgbtrf (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ ab_, int_4 _p_ ldab_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_, i2_, i3_, ii_, ip_, j_, j2_, j3_, jb_, jj_, jm_, jp_, ju_, k2_, km_, kv_, nb_, nw_;
  static real_4 temp_, work13_[4160], work31_[4160];
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $11_, $13_, $14_, $15_, $17_, $18_, $20_, $21_, $23_, $25_, 
  $26_, $28_, $30_, $31_, $33_, $34_, $36_, $38_, $39_, $41_, $42_, $43_, $44_, $45_, $46_, $47_;
  real_4 $10_, $12_, $16_, $19_, $22_, $24_, $27_, $29_, $32_, $35_, $37_, $40_;
  extern int_4 _ilaenv ();
  extern int_4 _isamax ();
  extern int_4 _scopy ();
  extern int_4 _sgemm ();
  extern int_4 _sger ();
  extern int_4 _sscal ();
  extern int_4 _sswap ();
  extern int_4 _strsm ();
  extern int_4 _xerbla ();
  kv_ = (*ku_) + (*kl_);
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldab_) < (*kl_) + kv_ + 1) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_61, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  nb_ = _ilaenv (&_k1, _dc_61, _dc_2, m_, n_, kl_, ku_);
  nb_ = _min (nb_, 64);
  if (nb_ <= 1 || nb_ > (*kl_)) {
    (void) _sgbtf2 (m_, n_, kl_, ku_, ab_, ldab_, ipiv_, info_);
  }
  else {
    for (j_ = 1; j_ <= nb_; (j_)++) {
      for (i_ = 1; i_ <= j_ - 1; (i_)++) {
        work13_[i_ - 1 + (65) * ((j_ - 1))] = 0.0;
      }
    }
    for (j_ = 1; j_ <= nb_; (j_)++) {
      for (i_ = j_ + 1; i_ <= nb_; (i_)++) {
        work31_[i_ - 1 + (65) * ((j_ - 1))] = 0.0;
      }
    }
    for (j_ = (*ku_) + 2; j_ <= _min (kv_, (*n_)); (j_)++) {
      for (i_ = kv_ - j_ + 2; i_ <= (*kl_); (i_)++) {
        ab_[i_ - 1 + ((*ldab_)) * ((j_ - 1))] = 0.0;
      }
    }
    ju_ = 1;
    for (j_ = 1; (nb_ > 0 ? j_ <= _min ((*m_), (*n_)) : j_ >= _min ((*m_), (*n_))); j_ += nb_) {
      jb_ = _min (nb_, _min ((*m_), (*n_)) - j_ + 1);
      i2_ = _min ((*kl_) - jb_, (*m_) - j_ - jb_ + 1);
      i3_ = _min (jb_, (*m_) - j_ - (*kl_) + 1);
      for (jj_ = j_; jj_ <= j_ + jb_ - 1; (jj_)++) {
        if (jj_ + kv_ <= (*n_)) {
          for (i_ = 1; i_ <= (*kl_); (i_)++) {
            ab_[i_ - 1 + ((*ldab_)) * ((jj_ + kv_ - 1))] = 0.0;
          }
        }
        km_ = _min ((*kl_), (*m_) - jj_);
        jp_ = _isamax (($1_ = km_ + 1, &$1_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], &_k1);
        ipiv_[jj_ - 1] = jp_ + jj_ - j_;
        if (ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((jj_ - 1))] != 0.0) {
          ju_ = _max (ju_, _min (jj_ + (*ku_) + jp_ - 1, (*n_)));
          if (jp_ != 1) {
            if (jp_ + jj_ - 1 < j_ + (*kl_)) {
              (void) _sswap (&jb_, &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($2_ = (*ldab_) - 1, &$2_), &ab_[kv_ + jp_ 
              + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($3_ = (*ldab_) - 1, &$3_));
            }
            else {
              (void) _sswap (($4_ = jj_ - j_, &$4_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($5_ = (*ldab_) - 1, 
              &$5_), &work31_[jp_ + jj_ - j_ - (*kl_) - 1], ($6_ = 65, &$6_));
              (void) _sswap (($7_ = j_ + jb_ - jj_, &$7_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], ($8_ = (*ldab_) - 1, &$8_), 
              &ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((jj_ - 1))], ($9_ = (*ldab_) - 1, &$9_));
            }
          }
          (void) _sscal (&km_, ($10_ = 1.0 / ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], &$10_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * 
          ((jj_ - 1))], &_k1);
          jm_ = _min (ju_, j_ + jb_ - 1);
          if (jm_ > jj_) {
            (void) _sger (&km_, ($11_ = jm_ - jj_, &$11_), ($12_ = -1.0, &$12_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * ((jj_ - 1))], 
            &_k1, &ab_[kv_ - 1 + ((*ldab_)) * ((jj_ + 1 - 1))], ($13_ = (*ldab_) - 1, &$13_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ 
            + 1 - 1))], ($14_ = (*ldab_) - 1, &$14_));
          }
        }
        else {
          if ((*info_) == 0) {
            (*info_) = jj_;
          }
        }
        nw_ = _min (jj_ - j_ + 1, i3_);
        if (nw_ > 0) {
          (void) _scopy (&nw_, &ab_[kv_ + (*kl_) + 1 - jj_ + j_ - 1 + ((*ldab_)) * ((jj_ - 1))], &_k1, &work31_[0 + (65) * ((jj_ 
          - j_ + 1 - 1))], &_k1);
        }
      }
      if (j_ + jb_ <= (*n_)) {
        j2_ = _min (ju_ - j_ + 1, kv_) - jb_;
        j3_ = _max (0, ju_ - j_ - kv_ + 1);
        (void) _slaswp (&j2_, &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($15_ = (*ldab_) - 1, &$15_), &_k1, 
        &jb_, &ipiv_[j_ - 1], &_k1);
        for (i_ = j_; i_ <= j_ + jb_ - 1; (i_)++) {
          ipiv_[i_ - 1] = ipiv_[i_ - 1] + j_ - 1;
        }
        k2_ = j_ - 1 + jb_ + j2_;
        for (i_ = 1; i_ <= j3_; (i_)++) {
          jj_ = k2_ + i_;
          for (ii_ = j_ + i_ - 1; ii_ <= j_ + jb_ - 1; (ii_)++) {
            ip_ = ipiv_[ii_ - 1];
            if (ip_ != ii_) {
              temp_ = ab_[kv_ + 1 + ii_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))];
              ab_[kv_ + 1 + ii_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))] = ab_[kv_ + 1 + ip_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))];
              ab_[kv_ + 1 + ip_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))] = temp_;
            }
          }
        }
        if (j2_ > 0) {
          (void) _strsm (_dc_3, _dc_4, _dc_5, _dc_6, &jb_, &j2_, ($16_ = 1.0, &$16_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 
          1))], ($17_ = (*ldab_) - 1, &$17_), &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($18_ = (*ldab_) - 1, 
          &$18_));
          if (i2_ > 0) {
            (void) _sgemm (_dc_5, _dc_5, &i2_, &j2_, &jb_, ($19_ = -1.0, &$19_), &ab_[kv_ + 1 + jb_ - 1 + ((*ldab_)) * ((j_ - 1))], 
            ($20_ = (*ldab_) - 1, &$20_), &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($21_ = (*ldab_) - 1, &$21_), 
            ($22_ = 1.0, &$22_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($23_ = (*ldab_) - 1, &$23_));
          }
          if (i3_ > 0) {
            (void) _sgemm (_dc_5, _dc_5, &i3_, &j2_, &jb_, ($24_ = -1.0, &$24_), work31_, ($25_ = 65, &$25_), &ab_[kv_ + 1 - jb_ - 
            1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($26_ = (*ldab_) - 1, &$26_), ($27_ = 1.0, &$27_), &ab_[kv_ + (*kl_) + 1 - jb_ - 1 
            + ((*ldab_)) * ((j_ + jb_ - 1))], ($28_ = (*ldab_) - 1, &$28_));
          }
        }
        if (j3_ > 0) {
          for (jj_ = 1; jj_ <= j3_; (jj_)++) {
            for (ii_ = jj_; ii_ <= jb_; (ii_)++) {
              work13_[ii_ - 1 + (65) * ((jj_ - 1))] = ab_[ii_ - jj_ + 1 - 1 + ((*ldab_)) * ((jj_ + j_ + kv_ - 1 - 1))];
            }
          }
          (void) _strsm (_dc_3, _dc_4, _dc_5, _dc_6, &jb_, &j3_, ($29_ = 1.0, &$29_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 
          1))], ($30_ = (*ldab_) - 1, &$30_), work13_, ($31_ = 65, &$31_));
          if (i2_ > 0) {
            (void) _sgemm (_dc_5, _dc_5, &i2_, &j3_, &jb_, ($32_ = -1.0, &$32_), &ab_[kv_ + 1 + jb_ - 1 + ((*ldab_)) * ((j_ - 1))], 
            ($33_ = (*ldab_) - 1, &$33_), work13_, ($34_ = 65, &$34_), ($35_ = 1.0, &$35_), &ab_[1 + jb_ - 1 + ((*ldab_)) * ((j_ + 
            kv_ - 1))], ($36_ = (*ldab_) - 1, &$36_));
          }
          if (i3_ > 0) {
            (void) _sgemm (_dc_5, _dc_5, &i3_, &j3_, &jb_, ($37_ = -1.0, &$37_), work31_, ($38_ = 65, &$38_), work13_, ($39_ = 65, 
            &$39_), ($40_ = 1.0, &$40_), &ab_[1 + (*kl_) - 1 + ((*ldab_)) * ((j_ + kv_ - 1))], ($41_ = (*ldab_) - 1, &$41_));
          }
          for (jj_ = 1; jj_ <= j3_; (jj_)++) {
            for (ii_ = jj_; ii_ <= jb_; (ii_)++) {
              ab_[ii_ - jj_ + 1 - 1 + ((*ldab_)) * ((jj_ + j_ + kv_ - 1 - 1))] = work13_[ii_ - 1 + (65) * ((jj_ - 1))];
            }
          }
        }
      }
      else {
        for (i_ = j_; i_ <= j_ + jb_ - 1; (i_)++) {
          ipiv_[i_ - 1] = ipiv_[i_ - 1] + j_ - 1;
        }
      }
      for (jj_ = j_ + jb_ - 1; jj_ >= j_; (jj_)--) {
        jp_ = ipiv_[jj_ - 1] - jj_ + 1;
        if (jp_ != 1) {
          if (jp_ + jj_ - 1 < j_ + (*kl_)) {
            (void) _sswap (($42_ = jj_ - j_, &$42_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($43_ = (*ldab_) - 1, 
            &$43_), &ab_[kv_ + jp_ + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($44_ = (*ldab_) - 1, &$44_));
          }
          else {
            (void) _sswap (($45_ = jj_ - j_, &$45_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($46_ = (*ldab_) - 1, 
            &$46_), &work31_[jp_ + jj_ - j_ - (*kl_) - 1], ($47_ = 65, &$47_));
          }
        }
        nw_ = _min (i3_, jj_ - j_ + 1);
        if (nw_ > 0) {
          (void) _scopy (&nw_, &work31_[0 + (65) * ((jj_ - j_ + 1 - 1))], &_k1, &ab_[kv_ + (*kl_) + 1 - jj_ + j_ - 1 + ((*ldab_)) 
          * ((jj_ - 1))], &_k1);
        }
      }
    }
  }
  _l0:;
  __calls[64].calls++;
  return 0;
}
int_4 _sgbtrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, int_4 _p_ nrhs_, real_4 _p_ ab_, int_4 _p_ 
ldab_, int_4 _p_ ipiv_, real_4 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_)
{
  static int_4 i_, j_, kd_, l_, lm_;
  static logical_4 lnoti_, notran_;
  int_4 $0_, $2_, $3_;
  real_4 $1_, $4_, $5_;
  extern logical_4 _lsame ();
  extern int_4 _sgemv ();
  extern int_4 _sger ();
  extern int_4 _sswap ();
  extern int_4 _stbsv ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  notran_ = _lsame (trans_, _dc_7);
  if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -5;
  }
  else if ((*ldab_) < (2 * (*kl_) + (*ku_) + 1)) {
    (*info_) = -7;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_62, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*nrhs_) == 0) {
    goto _l0;
  }
  kd_ = (*ku_) + (*kl_) + 1;
  lnoti_ = (*kl_) > 0;
  if (notran_) {
    if (lnoti_) {
      for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
        lm_ = _min ((*kl_), (*n_) - j_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _sswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
        (void) _sger (&lm_, nrhs_, ($1_ = -1.0, &$1_), &ab_[kd_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, &b_[j_ - 1 + 
        ((*ldb_)) * ((0))], ldb_, &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_);
      }
    }
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _stbsv (_dc_11, _dc_5, _dc_12, n_, ($2_ = (*kl_) + (*ku_), &$2_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
  }
  else {
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _stbsv (_dc_11, _dc_13, _dc_12, n_, ($3_ = (*kl_) + (*ku_), &$3_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
    if (lnoti_) {
      for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
        lm_ = _min ((*kl_), (*n_) - j_);
        (void) _sgemv (_dc_13, &lm_, nrhs_, ($4_ = -1.0, &$4_), &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_, &ab_[kd_ + 1 - 1 + 
        ((*ldab_)) * ((j_ - 1))], &_k1, ($5_ = 1.0, &$5_), &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _sswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
      }
    }
  }
  _l0:;
  __calls[65].calls++;
  return 0;
}

int_4 _sgeqr2 (int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ tau_, real_4 _p_ work_, int_4 _p_ 
info_)
{
  static int_4 i_, k_;
  static real_4 aii_;
  int_4 $0_, $1_, $2_, $3_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_63, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  k_ = _min ((*m_), (*n_));
  for (i_ = 1; i_ <= k_; (i_)++) {
    (void) _slarfg (($1_ = (*m_) - i_ + 1, &$1_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[_min (i_ + 1, (*m_)) - 1 + 
    ((*lda_)) * ((i_ - 1))], &_k1, &tau_[i_ - 1]);
    if (i_ < (*n_)) {
      aii_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
      (void) _slarf (_dc_3, ($2_ = (*m_) - i_ + 1, &$2_), ($3_ = (*n_) - i_, &$3_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
      &_k1, &tau_[i_ - 1], &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, work_);
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
    }
  }
  _l0:;
  __calls[66].calls++;
  return 0;
}

int_4 _sgttrf (int_4 _p_ n_, real_4 _p_ dl_, real_4 _p_ d_, real_4 _p_ du_, real_4 _p_ du2_, int_4 _p_ ipiv_, int_4 _p_ 
info_)
{
  static int_4 i_;
  static real_4 fact_, temp_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
    (void) _xerbla (_dc_64, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ipiv_[i_ - 1] = i_;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (dl_[i_ - 1] == 0.0) {
      if (d_[i_ - 1] == 0.0 && (*info_) == 0) {
        (*info_) = i_;
      }
      if (i_ < (*n_) - 1) {
        du2_[i_ - 1] = 0.0;
      }
    }
    else if (_abs (d_[i_ - 1]) >= _abs (dl_[i_ - 1])) {
      fact_ = dl_[i_ - 1] / d_[i_ - 1];
      dl_[i_ - 1] = fact_;
      d_[i_ + 1 - 1] = d_[i_ + 1 - 1] - fact_ * du_[i_ - 1];
      if (i_ < (*n_) - 1) {
        du2_[i_ - 1] = 0.0;
      }
    }
    else {
      fact_ = d_[i_ - 1] / dl_[i_ - 1];
      d_[i_ - 1] = dl_[i_ - 1];
      dl_[i_ - 1] = fact_;
      temp_ = du_[i_ - 1];
      du_[i_ - 1] = d_[i_ + 1 - 1];
      d_[i_ + 1 - 1] = temp_ - fact_ * d_[i_ + 1 - 1];
      if (i_ < (*n_) - 1) {
        du2_[i_ - 1] = du_[i_ + 1 - 1];
        du_[i_ + 1 - 1] = -fact_ * du_[i_ + 1 - 1];
      }
      ipiv_[i_ - 1] = ipiv_[i_ - 1] + 1;
    }
  }
  if (d_[(*n_) - 1] == 0.0 && (*info_) == 0) {
    (*info_) = (*n_);
    goto _l0;
  }
  _l0:;
  __calls[67].calls++;
  return 0;
}

int_4 _sgttrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, real_4 _p_ dl_, real_4 _p_ d_, real_4 _p_ du_, real_4 
_p_ du2_, int_4 _p_ ipiv_, real_4 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_)
{
  static int_4 i_, j_;
  static logical_4 notran_;
  static real_4 temp_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  notran_ = _lsame (trans_, _dc_7);
  if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -3;
  }
  else if ((*ldb_) < _max ((*n_), 1)) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_65, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*nrhs_) == 0) {
    goto _l0;
  }
  if (notran_) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * b_[i_ - 1 + ((*ldb_)) 
          * ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ - dl_[i_ - 1] * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] / d_[(*n_) - 1];
      if ((*n_) > 1) {
        b_[(*n_) - 1 - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[(*n_) - 1 - 1 + ((*ldb_)) * ((j_ - 1))] - du_[(*n_) - 1 - 1] * 
        b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[(*n_) - 1 - 1];
      }
      for (i_ = (*n_) - 2; i_ >= 1; (i_)--) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1] * b_[i_ + 1 - 1 + ((*ldb_)) * 
        ((j_ - 1))] - du2_[i_ - 1] * b_[i_ + 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[i_ - 1];
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / d_[0];
      if ((*n_) > 1) {
        b_[1 + ((*ldb_)) * ((j_ - 1))] = (b_[1 + ((*ldb_)) * ((j_ - 1))] - du_[0] * b_[0 + ((*ldb_)) * ((j_ - 1))]) / d_[1];
      }
      for (i_ = 3; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1 - 1] * b_[i_ - 1 - 1 + 
        ((*ldb_)) * ((j_ - 1))] - du2_[i_ - 2 - 1] * b_[i_ - 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[i_ - 1];
      }
      for (i_ = (*n_) - 1; i_ >= 1; (i_)--) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * b_[i_ + 1 - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * temp_;
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
        }
      }
    }
  }
  _l0:;
  __calls[68].calls++;
  return 0;
}

int_4 _slabad (real_4 _p_ small_, real_4 _p_ large_)
{
  if (log10f ((*large_)) > 2000.0) {
    (*small_) = sqrtf ((*small_));
    (*large_) = sqrtf ((*large_));
  }
  __calls[69].calls++;
  return 0;
}

int_4 _slacon (int_4 _p_ n_, real_4 _p_ v_, real_4 _p_ x_, int_4 _p_ isgn_, real_4 _p_ est_, int_4 _p_ kase_)
{
  static int_4 i_, iter_, j_, jlast_, jump_;
  static real_4 altsgn_, estold_, temp_;
  extern int_4 _isamax ();
  extern real_4 _sasum ();
  extern int_4 _scopy ();
  if ((*kase_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[i_ - 1] = 1.0 / (real_4) ((*n_));
    }
    (*kase_) = 1;
    jump_ = 1;
    goto _l0;
  }
  switch (jump_) {
    default:
    case 1: goto _l20;
    case 2: goto _l40;
    case 3: goto _l70;
    case 4: goto _l110;
    case 5: goto _l140;
  }
  _l20:;
  if ((*n_) == 1) {
    v_[0] = x_[0];
    (*est_) = _abs (v_[0]);
    goto _l150;
  }
  (*est_) = _sasum (n_, x_, &_k1);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = _sign (1.0, x_[i_ - 1]);
    isgn_[i_ - 1] = _nintf (x_[i_ - 1]);
  }
  (*kase_) = 2;
  jump_ = 2;
  goto _l0;
  _l40:;
  j_ = _isamax (n_, x_, &_k1);
  iter_ = 2;
  _l50:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = 0.0;
  }
  x_[j_ - 1] = 1.0;
  (*kase_) = 1;
  jump_ = 3;
  goto _l0;
  _l70:;
  (void) _scopy (n_, x_, &_k1, v_, &_k1);
  estold_ = (*est_);
  (*est_) = _sasum (n_, v_, &_k1);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_nintf (_sign (1.0, x_[i_ - 1])) != isgn_[i_ - 1]) {
      goto _l90;
    }
  }
  goto _l120;
  _l90:;
  if ((*est_) <= estold_) {
    goto _l120;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = _sign (1.0, x_[i_ - 1]);
    isgn_[i_ - 1] = _nintf (x_[i_ - 1]);
  }
  (*kase_) = 2;
  jump_ = 4;
  goto _l0;
  _l110:;
  jlast_ = j_;
  j_ = _isamax (n_, x_, &_k1);
  if ((x_[jlast_ - 1] != _abs (x_[j_ - 1])) && (iter_ < 5)) {
    iter_ = iter_ + 1;
    goto _l50;
  }
  _l120:;
  altsgn_ = 1.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = altsgn_ * (1.0 + (real_4) (i_ - 1) / (real_4) ((*n_) - 1));
    altsgn_ = -altsgn_;
  }
  (*kase_) = 1;
  jump_ = 5;
  goto _l0;
  _l140:;
  temp_ = 2.0 * (_sasum (n_, x_, &_k1) / (real_4) (3 * (*n_)));
  if (temp_ > (*est_)) {
    (void) _scopy (n_, x_, &_k1, v_, &_k1);
    (*est_) = temp_;
  }
  _l150:;
  (*kase_) = 0;
  _l0:;
  __calls[70].calls++;
  return 0;
}

int_4 _slacpy (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ b_, int_4 _p_ ldb_
)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if (_lsame (uplo_, _dc_19)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_, (*m_)); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  else if (_lsame (uplo_, _dc_20)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  __calls[71].calls++;
  return 0;
}

int_4 _sladiv (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ p_, real_4 _p_ q_)
{
  static real_4 e_, f_;
  if (_abs ((*d_)) < _abs ((*c_))) {
    e_ = (*d_) / (*c_);
    f_ = (*c_) + (*d_) * e_;
    (*p_) = ((*a_) + (*b_) * e_) / f_;
    (*q_) = ((*b_) - (*a_) * e_) / f_;
  }
  else {
    e_ = (*c_) / (*d_);
    f_ = (*d_) + (*c_) * e_;
    (*p_) = ((*b_) + (*a_) * e_) / f_;
    (*q_) = (-(*a_) + (*b_) * e_) / f_;
  }
  __calls[72].calls++;
  return 0;
}

int_4 _slae2 (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ rt1_, real_4 _p_ rt2_)
{
  static real_4 ab_, acmn_, acmx_, adf_, df_, rt_, sm_, tb_;
  real_4 $0_, $1_;
  sm_ = (*a_) + (*c_);
  df_ = (*a_) - (*c_);
  adf_ = _abs (df_);
  tb_ = (*b_) + (*b_);
  ab_ = _abs (tb_);
  if (_abs ((*a_)) > _abs ((*c_))) {
    acmx_ = (*a_);
    acmn_ = (*c_);
  }
  else {
    acmx_ = (*c_);
    acmn_ = (*a_);
  }
  if (adf_ > ab_) {
    rt_ = adf_ * sqrtf (1.0 + ($0_ = (ab_ / adf_), $0_ * $0_));
  }
  else if (adf_ < ab_) {
    rt_ = ab_ * sqrtf (1.0 + ($1_ = (adf_ / ab_), $1_ * $1_));
  }
  else {
    rt_ = ab_ * 1.4142135623730950488016887242096980785696718753769480731766797379907325;
  }
  if (sm_ < 0.0) {
    (*rt1_) = 0.5 * (sm_ - rt_);
    (*rt2_) = (acmx_ / (*rt1_)) * acmn_ - ((*b_) / (*rt1_)) * (*b_);
  }
  else if (sm_ > 0.0) {
    (*rt1_) = 0.5 * (sm_ + rt_);
    (*rt2_) = (acmx_ / (*rt1_)) * acmn_ - ((*b_) / (*rt1_)) * (*b_);
  }
  else {
    (*rt1_) = 0.5 * rt_;
    (*rt2_) = -0.5 * rt_;
  }
  __calls[73].calls++;
  return 0;
}

int_4 _slaev2 (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ rt1_, real_4 _p_ rt2_, real_4 _p_ cs1_, real_4 
_p_ sn1_)
{
  static int_4 sgn1_, sgn2_;
  static real_4 ab_, acmn_, acmx_, acs_, adf_, cs_, ct_, df_, rt_, sm_, tb_, tn_;
  real_4 $0_, $1_;
  sm_ = (*a_) + (*c_);
  df_ = (*a_) - (*c_);
  adf_ = _abs (df_);
  tb_ = (*b_) + (*b_);
  ab_ = _abs (tb_);
  if (_abs ((*a_)) > _abs ((*c_))) {
    acmx_ = (*a_);
    acmn_ = (*c_);
  }
  else {
    acmx_ = (*c_);
    acmn_ = (*a_);
  }
  if (adf_ > ab_) {
    rt_ = adf_ * sqrtf (1.0 + ($0_ = (ab_ / adf_), $0_ * $0_));
  }
  else if (adf_ < ab_) {
    rt_ = ab_ * sqrtf (1.0 + ($1_ = (adf_ / ab_), $1_ * $1_));
  }
  else {
    rt_ = ab_ * 1.4142135623730950488016887242096980785696718753769480731766797379907325;
  }
  if (sm_ < 0.0) {
    (*rt1_) = 0.5 * (sm_ - rt_);
    sgn1_ = -1;
    (*rt2_) = (acmx_ / (*rt1_)) * acmn_ - ((*b_) / (*rt1_)) * (*b_);
  }
  else if (sm_ > 0.0) {
    (*rt1_) = 0.5 * (sm_ + rt_);
    sgn1_ = 1;
    (*rt2_) = (acmx_ / (*rt1_)) * acmn_ - ((*b_) / (*rt1_)) * (*b_);
  }
  else {
    (*rt1_) = 0.5 * rt_;
    (*rt2_) = -0.5 * rt_;
    sgn1_ = 1;
  }
  if (df_ >= 0.0) {
    cs_ = df_ + rt_;
    sgn2_ = 1;
  }
  else {
    cs_ = df_ - rt_;
    sgn2_ = -1;
  }
  acs_ = _abs (cs_);
  if (acs_ > ab_) {
    ct_ = -tb_ / cs_;
    (*sn1_) = 1.0 / sqrtf (1.0 + ct_ * ct_);
    (*cs1_) = ct_ * (*sn1_);
  }
  else {
    if (ab_ == 0.0) {
      (*cs1_) = 1.0;
      (*sn1_) = 0.0;
    }
    else {
      tn_ = -cs_ / tb_;
      (*cs1_) = 1.0 / sqrtf (1.0 + tn_ * tn_);
      (*sn1_) = tn_ * (*cs1_);
    }
  }
  if (sgn1_ == sgn2_) {
    tn_ = (*cs1_);
    (*cs1_) = -(*sn1_);
    (*sn1_) = tn_;
  }
  __calls[74].calls++;
  return 0;
}

int_4 _slaexc (logical_4 _p_ wantq_, int_4 _p_ n_, real_4 _p_ t_, int_4 _p_ ldt_, real_4 _p_ q_, int_4 _p_ ldq_, int_4 
_p_ j1_, int_4 _p_ n1_, int_4 _p_ n2_, real_4 _p_ work_, int_4 _p_ info_)
{
  static int_4 ierr_, j2_, j3_, j4_, k_, nd_;
  static real_4 cs_, dnorm_, eps_, scale_, smlnum_, sn_, t11_, t22_, t33_, tau_, tau1_, tau2_, temp_, thresh_, wi1_, wi2_
  , wr1_, wr2_, xnorm_, d_[16], u_[3], u1_[3], u2_[3], x_[4];
  int_4 $1_, $2_, $3_, $4_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $19_, $20_, $21_, $22_, $23_, 
  $24_, $25_, $26_, $27_, $28_, $29_, $31_, $32_, $33_, $34_, $35_, $36_, $37_, $38_, $39_, $40_, $41_, $42_, $43_, $44_, 
  $45_, $46_, $47_, $48_, $50_, $51_, $52_, $53_, $54_, $55_, $56_, $57_, $58_, $59_, $60_, $61_;
  logical_4 $5_, $6_;
  real_4 $0_, $18_, $30_, $49_;
  extern int_4 _srot ();
  (*info_) = 0;
  if ((*n_) == 0 || (*n1_) == 0 || (*n2_) == 0) {
    goto _l0;
  }
  if ((*j1_) + (*n1_) > (*n_)) {
    goto _l0;
  }
  j2_ = (*j1_) + 1;
  j3_ = (*j1_) + 2;
  j4_ = (*j1_) + 3;
  if ((*n1_) == 1 && (*n2_) == 1) {
    t11_ = t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))];
    t22_ = t_[j2_ - 1 + ((*ldt_)) * ((j2_ - 1))];
    (void) _slartg (&t_[(*j1_) - 1 + ((*ldt_)) * ((j2_ - 1))], ($0_ = t22_ - t11_, &$0_), &cs_, &sn_, &temp_);
    if (j3_ <= (*n_)) {
      (void) _srot (($1_ = (*n_) - (*j1_) - 1, &$1_), &t_[(*j1_) - 1 + ((*ldt_)) * ((j3_ - 1))], ldt_, &t_[j2_ - 1 + 
      ((*ldt_)) * ((j3_ - 1))], ldt_, &cs_, &sn_);
    }
    (void) _srot (($2_ = (*j1_) - 1, &$2_), &t_[0 + ((*ldt_)) * (((*j1_) - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j2_ - 1))], 
    &_k1, &cs_, &sn_);
    t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))] = t22_;
    t_[j2_ - 1 + ((*ldt_)) * ((j2_ - 1))] = t11_;
    if ((*wantq_)) {
      (void) _srot (n_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], &_k1, &q_[0 + ((*ldq_)) * ((j2_ - 1))], &_k1, &cs_, &sn_);
    }
  }
  else {
    nd_ = (*n1_) + (*n2_);
    (void) _slacpy (_dc_51, &nd_, &nd_, &t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))], ldt_, d_, ($3_ = 4, &$3_));
    dnorm_ = _slange (_dc_52, &nd_, &nd_, d_, ($4_ = 4, &$4_), work_);
    eps_ = _slamch (_dc_44);
    smlnum_ = _slamch (_dc_28) / eps_;
    thresh_ = _max (10.0 * eps_ * dnorm_, smlnum_);
    (void) _slasy2 (($5_ = FALSE, &$5_), ($6_ = FALSE, &$6_), &_km1, n1_, n2_, d_, ($7_ = 4, &$7_), &d_[(*n1_) + 1 - 1 + 
    (4) * (((*n1_) + 1 - 1))], ($8_ = 4, &$8_), &d_[0 + (4) * (((*n1_) + 1 - 1))], ($9_ = 4, &$9_), &scale_, x_, ($10_ = 2, 
    &$10_), &xnorm_, &ierr_);
    k_ = (*n1_) + (*n1_) + (*n2_) - 3;
    switch (k_) {
      default:
      case 1: goto _l10;
      case 2: goto _l20;
      case 3: goto _l30;
    }
    _l10:;
    u_[0] = scale_;
    u_[1] = x_[0];
    u_[2] = x_[2];
    (void) _slarfg (($11_ = 3, &$11_), &u_[2], u_, &_k1, &tau_);
    u_[2] = 1.0;
    t11_ = t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))];
    (void) _slarfx (_dc_20, ($12_ = 3, &$12_), ($13_ = 3, &$13_), u_, &tau_, d_, ($14_ = 4, &$14_), work_);
    (void) _slarfx (_dc_37, ($15_ = 3, &$15_), ($16_ = 3, &$16_), u_, &tau_, d_, ($17_ = 4, &$17_), work_);
    if (($18_ = _max (_abs (d_[2]), _abs (d_[6])), _max ($18_, _abs (d_[10] - t11_))) > thresh_) {
      goto _l50;
    }
    (void) _slarfx (_dc_20, ($19_ = 3, &$19_), ($20_ = (*n_) - (*j1_) + 1, &$20_), u_, &tau_, &t_[(*j1_) - 1 + ((*ldt_)) * 
    (((*j1_) - 1))], ldt_, work_);
    (void) _slarfx (_dc_37, &j2_, ($21_ = 3, &$21_), u_, &tau_, &t_[0 + ((*ldt_)) * (((*j1_) - 1))], ldt_, work_);
    t_[j3_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    t_[j3_ - 1 + ((*ldt_)) * ((j2_ - 1))] = 0.0;
    t_[j3_ - 1 + ((*ldt_)) * ((j3_ - 1))] = t11_;
    if ((*wantq_)) {
      (void) _slarfx (_dc_37, n_, ($22_ = 3, &$22_), u_, &tau_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], ldq_, work_);
    }
    goto _l40;
    _l20:;
    u_[0] = -x_[0];
    u_[1] = -x_[1];
    u_[2] = scale_;
    (void) _slarfg (($23_ = 3, &$23_), &u_[0], &u_[1], &_k1, &tau_);
    u_[0] = 1.0;
    t33_ = t_[j3_ - 1 + ((*ldt_)) * ((j3_ - 1))];
    (void) _slarfx (_dc_20, ($24_ = 3, &$24_), ($25_ = 3, &$25_), u_, &tau_, d_, ($26_ = 4, &$26_), work_);
    (void) _slarfx (_dc_37, ($27_ = 3, &$27_), ($28_ = 3, &$28_), u_, &tau_, d_, ($29_ = 4, &$29_), work_);
    if (($30_ = _max (_abs (d_[1]), _abs (d_[2])), _max ($30_, _abs (d_[0] - t33_))) > thresh_) {
      goto _l50;
    }
    (void) _slarfx (_dc_37, &j3_, ($31_ = 3, &$31_), u_, &tau_, &t_[0 + ((*ldt_)) * (((*j1_) - 1))], ldt_, work_);
    (void) _slarfx (_dc_20, ($32_ = 3, &$32_), ($33_ = (*n_) - (*j1_), &$33_), u_, &tau_, &t_[(*j1_) - 1 + ((*ldt_)) * 
    ((j2_ - 1))], ldt_, work_);
    t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))] = t33_;
    t_[j2_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    t_[j3_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    if ((*wantq_)) {
      (void) _slarfx (_dc_37, n_, ($34_ = 3, &$34_), u_, &tau_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], ldq_, work_);
    }
    goto _l40;
    _l30:;
    u1_[0] = -x_[0];
    u1_[1] = -x_[1];
    u1_[2] = scale_;
    (void) _slarfg (($35_ = 3, &$35_), &u1_[0], &u1_[1], &_k1, &tau1_);
    u1_[0] = 1.0;
    temp_ = -tau1_ * (x_[2] + u1_[1] * x_[3]);
    u2_[0] = -temp_ * u1_[1] - x_[3];
    u2_[1] = -temp_ * u1_[2];
    u2_[2] = scale_;
    (void) _slarfg (($36_ = 3, &$36_), &u2_[0], &u2_[1], &_k1, &tau2_);
    u2_[0] = 1.0;
    (void) _slarfx (_dc_20, ($37_ = 3, &$37_), ($38_ = 4, &$38_), u1_, &tau1_, d_, ($39_ = 4, &$39_), work_);
    (void) _slarfx (_dc_37, ($40_ = 4, &$40_), ($41_ = 3, &$41_), u1_, &tau1_, d_, ($42_ = 4, &$42_), work_);
    (void) _slarfx (_dc_20, ($43_ = 3, &$43_), ($44_ = 4, &$44_), u2_, &tau2_, &d_[1], ($45_ = 4, &$45_), work_);
    (void) _slarfx (_dc_37, ($46_ = 4, &$46_), ($47_ = 3, &$47_), u2_, &tau2_, &d_[4], ($48_ = 4, &$48_), work_);
    if (($49_ = _max (_abs (d_[2]), _abs (d_[6])), $49_ = _max ($49_, _abs (d_[3])), _max ($49_, _abs (d_[7]))) > thresh_) 
      {
      goto _l50;
    }
    (void) _slarfx (_dc_20, ($50_ = 3, &$50_), ($51_ = (*n_) - (*j1_) + 1, &$51_), u1_, &tau1_, &t_[(*j1_) - 1 + ((*ldt_)) 
    * (((*j1_) - 1))], ldt_, work_);
    (void) _slarfx (_dc_37, &j4_, ($52_ = 3, &$52_), u1_, &tau1_, &t_[0 + ((*ldt_)) * (((*j1_) - 1))], ldt_, work_);
    (void) _slarfx (_dc_20, ($53_ = 3, &$53_), ($54_ = (*n_) - (*j1_) + 1, &$54_), u2_, &tau2_, &t_[j2_ - 1 + ((*ldt_)) * 
    (((*j1_) - 1))], ldt_, work_);
    (void) _slarfx (_dc_37, &j4_, ($55_ = 3, &$55_), u2_, &tau2_, &t_[0 + ((*ldt_)) * ((j2_ - 1))], ldt_, work_);
    t_[j3_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    t_[j3_ - 1 + ((*ldt_)) * ((j2_ - 1))] = 0.0;
    t_[j4_ - 1 + ((*ldt_)) * (((*j1_) - 1))] = 0.0;
    t_[j4_ - 1 + ((*ldt_)) * ((j2_ - 1))] = 0.0;
    if ((*wantq_)) {
      (void) _slarfx (_dc_37, n_, ($56_ = 3, &$56_), u1_, &tau1_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], ldq_, work_);
      (void) _slarfx (_dc_37, n_, ($57_ = 3, &$57_), u2_, &tau2_, &q_[0 + ((*ldq_)) * ((j2_ - 1))], ldq_, work_);
    }
    _l40:;
    if ((*n2_) == 2) {
      (void) _slanv2 (&t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) - 1))], &t_[(*j1_) - 1 + ((*ldt_)) * ((j2_ - 1))], &t_[j2_ - 1 + 
      ((*ldt_)) * (((*j1_) - 1))], &t_[j2_ - 1 + ((*ldt_)) * ((j2_ - 1))], &wr1_, &wi1_, &wr2_, &wi2_, &cs_, &sn_);
      (void) _srot (($58_ = (*n_) - (*j1_) - 1, &$58_), &t_[(*j1_) - 1 + ((*ldt_)) * (((*j1_) + 2 - 1))], ldt_, &t_[j2_ - 1 + 
      ((*ldt_)) * (((*j1_) + 2 - 1))], ldt_, &cs_, &sn_);
      (void) _srot (($59_ = (*j1_) - 1, &$59_), &t_[0 + ((*ldt_)) * (((*j1_) - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j2_ - 1))], 
      &_k1, &cs_, &sn_);
      if ((*wantq_)) {
        (void) _srot (n_, &q_[0 + ((*ldq_)) * (((*j1_) - 1))], &_k1, &q_[0 + ((*ldq_)) * ((j2_ - 1))], &_k1, &cs_, &sn_);
      }
    }
    if ((*n1_) == 2) {
      j3_ = (*j1_) + (*n2_);
      j4_ = j3_ + 1;
      (void) _slanv2 (&t_[j3_ - 1 + ((*ldt_)) * ((j3_ - 1))], &t_[j3_ - 1 + ((*ldt_)) * ((j4_ - 1))], &t_[j4_ - 1 + ((*ldt_)) 
      * ((j3_ - 1))], &t_[j4_ - 1 + ((*ldt_)) * ((j4_ - 1))], &wr1_, &wi1_, &wr2_, &wi2_, &cs_, &sn_);
      if (j3_ + 2 <= (*n_)) {
        (void) _srot (($60_ = (*n_) - j3_ - 1, &$60_), &t_[j3_ - 1 + ((*ldt_)) * ((j3_ + 2 - 1))], ldt_, &t_[j4_ - 1 + 
        ((*ldt_)) * ((j3_ + 2 - 1))], ldt_, &cs_, &sn_);
      }
      (void) _srot (($61_ = j3_ - 1, &$61_), &t_[0 + ((*ldt_)) * ((j3_ - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j4_ - 1))], &_k1, 
      &cs_, &sn_);
      if ((*wantq_)) {
        (void) _srot (n_, &q_[0 + ((*ldq_)) * ((j3_ - 1))], &_k1, &q_[0 + ((*ldq_)) * ((j4_ - 1))], &_k1, &cs_, &sn_);
      }
    }
  }
  goto _l0;
  _l50:;
  (*info_) = 1;
  _l0:;
  __calls[75].calls++;
  return 0;
}

int_4 _slagtm (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, real_4 _p_ alpha_, real_4 _p_ dl_, real_4 _p_ d_, real_4 
_p_ du_, real_4 _p_ x_, int_4 _p_ ldx_, real_4 _p_ beta_, real_4 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*beta_) == 0.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = 0.0;
      }
    }
  }
  else if ((*beta_) == -1.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = -b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
      }
    }
  }
  if ((*alpha_) == 1.0) {
    if (_lsame (trans_, _dc_7)) {
      for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
        if ((*n_) == 1) {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
        }
        else {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] + du_[0] * 
          x_[1 + ((*ldx_)) * ((j_ - 1))];
          b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] + dl_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
          + ((*ldx_)) * ((j_ - 1))] + d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
          for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + dl_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
            * ((j_ - 1))] + d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + du_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 
            1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
        if ((*n_) == 1) {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
        }
        else {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] + dl_[0] * 
          x_[1 + ((*ldx_)) * ((j_ - 1))];
          b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] + du_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
          + ((*ldx_)) * ((j_ - 1))] + d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
          for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + du_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
            * ((j_ - 1))] + d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + dl_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 
            1))];
          }
        }
      }
    }
  }
  else if ((*alpha_) == -1.0) {
    if (_lsame (trans_, _dc_7)) {
      for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
        if ((*n_) == 1) {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
        }
        else {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] - du_[0] * 
          x_[1 + ((*ldx_)) * ((j_ - 1))];
          b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
          + ((*ldx_)) * ((j_ - 1))] - d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
          for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
            * ((j_ - 1))] - d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] - du_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 
            1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
        if ((*n_) == 1) {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
        }
        else {
          b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] - dl_[0] * 
          x_[1 + ((*ldx_)) * ((j_ - 1))];
          b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] - du_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
          + ((*ldx_)) * ((j_ - 1))] - d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
          for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
            b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
            * ((j_ - 1))] - d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] - dl_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 
            1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[76].calls++;
  return 0;
}

int_4 _slahqr (logical_4 _p_ wantt_, logical_4 _p_ wantz_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, real_4 _p_ h_, 
int_4 _p_ ldh_, real_4 _p_ wr_, real_4 _p_ wi_, int_4 _p_ iloz_, int_4 _p_ ihiz_, real_4 _p_ z_, int_4 _p_ ldz_, int_4 
_p_ info_)
{
  static int_4 i_, i1_, i2_, itn_, its_, j_, k_, l_, m_, nh_, nr_, nz_;
  static real_4 cs_, h00_, h10_, h11_, h12_, h21_, h22_, h33_, h33s_, h43h34_, h44_, h44s_, ovfl_, s_, smlnum_, sn_, sum_
  , t1_, t2_, t3_, tst1_, ulp_, unfl_, v1_, v2_, v3_, v_[3], work_[1];
  int_4 $0_, $1_, $2_;
  extern int_4 _scopy ();
  extern int_4 _srot ();
  (*info_) = 0;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*ilo_) == (*ihi_)) {
    wr_[(*ilo_) - 1] = h_[(*ilo_) - 1 + ((*ldh_)) * (((*ilo_) - 1))];
    wi_[(*ilo_) - 1] = 0.0;
    goto _l0;
  }
  nh_ = (*ihi_) - (*ilo_) + 1;
  nz_ = (*ihiz_) - (*iloz_) + 1;
  unfl_ = _slamch (_dc_18);
  ovfl_ = 1.0 / unfl_;
  (void) _slabad (&unfl_, &ovfl_);
  ulp_ = _slamch (_dc_21);
  smlnum_ = unfl_ * (nh_ / ulp_);
  if ((*wantt_)) {
    i1_ = 1;
    i2_ = (*n_);
  }
  itn_ = 30 * nh_;
  i_ = (*ihi_);
  _l10:;
  l_ = (*ilo_);
  if (i_ < (*ilo_)) {
    goto _l150;
  }
  for (its_ = 0; its_ <= itn_; (its_)++) {
    for (k_ = i_; k_ >= l_ + 1; (k_)--) {
      tst1_ = _abs (h_[k_ - 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))]) + _abs (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1))]);
      if (tst1_ == 0.0) {
        tst1_ = _slanhs (_dc_22, ($0_ = i_ - l_ + 1, &$0_), &h_[l_ - 1 + ((*ldh_)) * ((l_ - 1))], ldh_, work_);
      }
      if (_abs (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))]) <= _max (ulp_ * tst1_, smlnum_)) {
        goto _l30;
      }
    }
    _l30:;
    l_ = k_;
    if (l_ > (*ilo_)) {
      h_[l_ - 1 + ((*ldh_)) * ((l_ - 1 - 1))] = 0.0;
    }
    if (l_ >= i_ - 1) {
      goto _l140;
    }
    if (! ((*wantt_))) {
      i1_ = l_;
      i2_ = i_;
    }
    if (its_ == 10 || its_ == 20) {
      s_ = _abs (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))]) + _abs (h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 2 - 1))]);
      h44_ = 0.75 * s_;
      h33_ = h44_;
      h43h34_ = -0.4375 * s_ * s_;
    }
    else {
      h44_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
      h33_ = h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))];
      h43h34_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] * h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))];
    }
    for (m_ = i_ - 2; m_ >= l_; (m_)--) {
      h11_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1))];
      h22_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h21_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))];
      h12_ = h_[m_ - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h44s_ = h44_ - h11_;
      h33s_ = h33_ - h11_;
      v1_ = (h33s_ * h44s_ - h43h34_) / h21_ + h12_;
      v2_ = h22_ - h11_ - h33s_ - h44s_;
      v3_ = h_[m_ + 2 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      s_ = _abs (v1_) + _abs (v2_) + _abs (v3_);
      v1_ = v1_ / s_;
      v2_ = v2_ / s_;
      v3_ = v3_ / s_;
      v_[0] = v1_;
      v_[1] = v2_;
      v_[2] = v3_;
      if (m_ == l_) {
        goto _l50;
      }
      h00_ = h_[m_ - 1 - 1 + ((*ldh_)) * ((m_ - 1 - 1))];
      h10_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1 - 1))];
      tst1_ = _abs (v1_) * (_abs (h00_) + _abs (h11_) + _abs (h22_));
      if (_abs (h10_) * (_abs (v2_) + _abs (v3_)) <= ulp_ * tst1_) {
        goto _l50;
      }
    }
    _l50:;
    for (k_ = m_; k_ <= i_ - 1; (k_)++) {
      nr_ = _min (3, i_ - k_ + 1);
      if (k_ > m_) {
        (void) _scopy (&nr_, &h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))], &_k1, v_, &_k1);
      }
      (void) _slarfg (&nr_, &v_[0], &v_[1], &_k1, &t1_);
      if (k_ > m_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = v_[0];
        h_[k_ + 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = 0.0;
        if (k_ < i_ - 1) {
          h_[k_ + 2 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = 0.0;
        }
      }
      else if (m_ > l_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = -h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))];
      }
      v2_ = v_[1];
      t2_ = t1_ * v2_;
      if (nr_ == 3) {
        v3_ = v_[2];
        t3_ = t1_ * v3_;
        for (j_ = k_; j_ <= i2_; (j_)++) {
          sum_ = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + v2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] + v3_ * h_[k_ + 2 - 1 + 
          ((*ldh_)) * ((j_ - 1))];
          h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t1_;
          h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t2_;
          h_[k_ + 2 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 2 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t3_;
        }
        for (j_ = i1_; j_ <= _min (k_ + 3, i_); (j_)++) {
          sum_ = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + v2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] + v3_ * h_[j_ - 1 + 
          ((*ldh_)) * ((k_ + 2 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_ * t1_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * t2_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 2 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 2 - 1))] - sum_ * t3_;
        }
        if ((*wantz_)) {
          for (j_ = (*iloz_); j_ <= (*ihiz_); (j_)++) {
            sum_ = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] + v2_ * z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] + v3_ * z_[j_ - 1 + 
            ((*ldz_)) * ((k_ + 2 - 1))];
            z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] - sum_ * t1_;
            z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] - sum_ * t2_;
            z_[j_ - 1 + ((*ldz_)) * ((k_ + 2 - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ + 2 - 1))] - sum_ * t3_;
          }
        }
      }
      else if (nr_ == 2) {
        for (j_ = k_; j_ <= i2_; (j_)++) {
          sum_ = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + v2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
          h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t1_;
          h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * t2_;
        }
        for (j_ = i1_; j_ <= i_; (j_)++) {
          sum_ = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + v2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))];
          h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_ * t1_;
          h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * t2_;
        }
        if ((*wantz_)) {
          for (j_ = (*iloz_); j_ <= (*ihiz_); (j_)++) {
            sum_ = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] + v2_ * z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))];
            z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] - sum_ * t1_;
            z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] - sum_ * t2_;
          }
        }
      }
    }
  }
  (*info_) = i_;
  goto _l0;
  _l140:;
  if (l_ == i_) {
    wr_[i_ - 1] = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
    wi_[i_ - 1] = 0.0;
  }
  else if (l_ == i_ - 1) {
    (void) _slanv2 (&h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))], &h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))], &h_[i_ - 1 + 
    ((*ldh_)) * ((i_ - 1 - 1))], &h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))], &wr_[i_ - 1 - 1], &wi_[i_ - 1 - 1], &wr_[i_ - 1], 
    &wi_[i_ - 1], &cs_, &sn_);
    if ((*wantt_)) {
      if (i2_ > i_) {
        (void) _srot (($1_ = i2_ - i_, &$1_), &h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ + 1 - 1))], ldh_, &h_[i_ - 1 + ((*ldh_)) * ((i_ 
        + 1 - 1))], ldh_, &cs_, &sn_);
      }
      (void) _srot (($2_ = i_ - i1_ - 1, &$2_), &h_[i1_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))], &_k1, &h_[i1_ - 1 + ((*ldh_)) * 
      ((i_ - 1))], &_k1, &cs_, &sn_);
    }
    if ((*wantz_)) {
      (void) _srot (&nz_, &z_[(*iloz_) - 1 + ((*ldz_)) * ((i_ - 1 - 1))], &_k1, &z_[(*iloz_) - 1 + ((*ldz_)) * ((i_ - 1))], 
      &_k1, &cs_, &sn_);
    }
  }
  itn_ = itn_ - its_;
  i_ = l_ - 1;
  goto _l10;
  _l150:;
  _l0:;
  __calls[77].calls++;
  return 0;
}

int_4 _slaln2 (logical_4 _p_ ltrans_, int_4 _p_ na_, int_4 _p_ nw_, real_4 _p_ smin_, real_4 _p_ ca_, real_4 _p_ a_, 
int_4 _p_ lda_, real_4 _p_ d1_, real_4 _p_ d2_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ wr_, real_4 _p_ wi_, real_4 
_p_ x_, int_4 _p_ ldx_, real_4 _p_ scale_, real_4 _p_ xnorm_, int_4 _p_ info_)
{
  static int_4 icmax_, j_, ipivot_[16];
  static logical_4 cswap_[4], rswap_[4];
  static real_4 bbnd_, bi1_, bi2_, bignum_, bnorm_, br1_, br2_, ci21_, ci22_, cmax_, cnorm_, cr21_, cr22_, csi_, csr_, 
  li21_, lr21_, smini_, smlnum_, temp_, u22abs_, ui11_, ui11r_, ui12_, ui12s_, ui22_, ur11_, ur11r_, ur12_, ur12s_, ur22_
  , xi1_, xi2_, xr1_, xr2_, (_p_ ci_), civ_[4], (_p_ cr_), crv_[4];
  int_4 _data_k_136, _k_1, _data_k_137, _k_3, _data_k_138, _p_ _arr_4, _k_5;
  logical_4 _p_ _arr_0, _p_ _arr_2;
  real_4 $6_, $7_;
  ci_ = (real_4 (_p_)) civ_;
  cr_ = (real_4 (_p_)) crv_;
#define _data_n_136 4
  static logical_4 _data_l_136[_data_n_136] = {
    FALSE,
    FALSE,
    TRUE,
    TRUE
  };
#define _data_n_137 4
  static logical_4 _data_l_137[_data_n_137] = {
    FALSE,
    TRUE,
    FALSE,
    TRUE
  };
#define _data_n_138 16
  static int_4 _data_l_138[_data_n_138] = {
    1,
    2,
    3,
    4,
    2,
    1,
    4,
    3,
    3,
    4,
    1,
    2,
    4,
    3,
    2,
    1
  };
  if (__calls[78].calls == 0) {
    _data_k_136 = 0;
    for (_arr_0 = (logical_4 *) cswap_, _k_1 = 0; _k_1 < 4; _arr_0++, _k_1++) {
      if (_data_k_136 >= _data_n_136) {
        _data_k_136 = 0;
      }
      cswap_[_k_1] = _data_l_136[_data_k_136++];
    }
  }
  if (__calls[78].calls == 0) {
    _data_k_137 = 0;
    for (_arr_2 = (logical_4 *) rswap_, _k_3 = 0; _k_3 < 4; _arr_2++, _k_3++) {
      if (_data_k_137 >= _data_n_137) {
        _data_k_137 = 0;
      }
      rswap_[_k_3] = _data_l_137[_data_k_137++];
    }
  }
  if (__calls[78].calls == 0) {
    _data_k_138 = 0;
    for (_arr_4 = (int_4 *) ipivot_, _k_5 = 0; _k_5 < 16; _arr_4++, _k_5++) {
      if (_data_k_138 >= _data_n_138) {
        _data_k_138 = 0;
      }
      ipivot_[_k_5] = _data_l_138[_data_k_138++];
    }
  }
  smlnum_ = 2.0 * _slamch (_dc_18);
  bignum_ = 1.0 / smlnum_;
  smini_ = _max ((*smin_), smlnum_);
  (*info_) = 0;
  (*scale_) = 1.0;
  if ((*na_) == 1) {
    if ((*nw_) == 1) {
      csr_ = (*ca_) * a_[0 + ((*lda_)) * ((0))] - (*wr_) * (*d1_);
      cnorm_ = _abs (csr_);
      if (cnorm_ < smini_) {
        csr_ = smini_;
        cnorm_ = smini_;
        (*info_) = 1;
      }
      bnorm_ = _abs (b_[0 + ((*ldb_)) * ((0))]);
      if (cnorm_ < 1.0 && bnorm_ > 1.0) {
        if (bnorm_ > bignum_ * cnorm_) {
          (*scale_) = 1.0 / bnorm_;
        }
      }
      x_[0 + ((*ldx_)) * ((0))] = (b_[0 + ((*ldb_)) * ((0))] * (*scale_)) / csr_;
      (*xnorm_) = _abs (x_[0 + ((*ldx_)) * ((0))]);
    }
    else {
      csr_ = (*ca_) * a_[0 + ((*lda_)) * ((0))] - (*wr_) * (*d1_);
      csi_ = -(*wi_) * (*d1_);
      cnorm_ = _abs (csr_) + _abs (csi_);
      if (cnorm_ < smini_) {
        csr_ = smini_;
        csi_ = 0.0;
        cnorm_ = smini_;
        (*info_) = 1;
      }
      bnorm_ = _abs (b_[0 + ((*ldb_)) * ((0))]) + _abs (b_[0 + ((*ldb_)) * ((1))]);
      if (cnorm_ < 1.0 && bnorm_ > 1.0) {
        if (bnorm_ > bignum_ * cnorm_) {
          (*scale_) = 1.0 / bnorm_;
        }
      }
      (void) _sladiv (($6_ = (*scale_) * b_[0 + ((*ldb_)) * ((0))], &$6_), ($7_ = (*scale_) * b_[0 + ((*ldb_)) * ((1))], 
      &$7_), &csr_, &csi_, &x_[0 + ((*ldx_)) * ((0))], &x_[0 + ((*ldx_)) * ((1))]);
      (*xnorm_) = _abs (x_[0 + ((*ldx_)) * ((0))]) + _abs (x_[0 + ((*ldx_)) * ((1))]);
    }
  }
  else {
    cr_[0] = (*ca_) * a_[0 + ((*lda_)) * ((0))] - (*wr_) * (*d1_);
    cr_[3] = (*ca_) * a_[1 + ((*lda_)) * ((1))] - (*wr_) * (*d2_);
    if ((*ltrans_)) {
      cr_[2] = (*ca_) * a_[1 + ((*lda_)) * ((0))];
      cr_[1] = (*ca_) * a_[0 + ((*lda_)) * ((1))];
    }
    else {
      cr_[1] = (*ca_) * a_[1 + ((*lda_)) * ((0))];
      cr_[2] = (*ca_) * a_[0 + ((*lda_)) * ((1))];
    }
    if ((*nw_) == 1) {
      cmax_ = 0.0;
      icmax_ = 0;
      for (j_ = 1; j_ <= 4; (j_)++) {
        if (_abs (crv_[j_ - 1]) > cmax_) {
          cmax_ = _abs (crv_[j_ - 1]);
          icmax_ = j_;
        }
      }
      if (cmax_ < smini_) {
        bnorm_ = _max (_abs (b_[0 + ((*ldb_)) * ((0))]), _abs (b_[1 + ((*ldb_)) * ((0))]));
        if (smini_ < 1.0 && bnorm_ > 1.0) {
          if (bnorm_ > bignum_ * smini_) {
            (*scale_) = 1.0 / bnorm_;
          }
        }
        temp_ = (*scale_) / smini_;
        x_[0 + ((*ldx_)) * ((0))] = temp_ * b_[0 + ((*ldb_)) * ((0))];
        x_[1 + ((*ldx_)) * ((0))] = temp_ * b_[1 + ((*ldb_)) * ((0))];
        (*xnorm_) = temp_ * bnorm_;
        (*info_) = 1;
        goto _l0;
      }
      ur11_ = crv_[icmax_ - 1];
      cr21_ = crv_[ipivot_[1 + (4) * ((icmax_ - 1))] - 1];
      ur12_ = crv_[ipivot_[2 + (4) * ((icmax_ - 1))] - 1];
      cr22_ = crv_[ipivot_[3 + (4) * ((icmax_ - 1))] - 1];
      ur11r_ = 1.0 / ur11_;
      lr21_ = ur11r_ * cr21_;
      ur22_ = cr22_ - ur12_ * lr21_;
      if (_abs (ur22_) < smini_) {
        ur22_ = smini_;
        (*info_) = 1;
      }
      if (rswap_[icmax_ - 1]) {
        br1_ = b_[1 + ((*ldb_)) * ((0))];
        br2_ = b_[0 + ((*ldb_)) * ((0))];
      }
      else {
        br1_ = b_[0 + ((*ldb_)) * ((0))];
        br2_ = b_[1 + ((*ldb_)) * ((0))];
      }
      br2_ = br2_ - lr21_ * br1_;
      bbnd_ = _max (_abs (br1_ * (ur22_ * ur11r_)), _abs (br2_));
      if (bbnd_ > 1.0 && _abs (ur22_) < 1.0) {
        if (bbnd_ >= bignum_ * _abs (ur22_)) {
          (*scale_) = 1.0 / bbnd_;
        }
      }
      xr2_ = (br2_ * (*scale_)) / ur22_;
      xr1_ = ((*scale_) * br1_) * ur11r_ - xr2_ * (ur11r_ * ur12_);
      if (cswap_[icmax_ - 1]) {
        x_[0 + ((*ldx_)) * ((0))] = xr2_;
        x_[1 + ((*ldx_)) * ((0))] = xr1_;
      }
      else {
        x_[0 + ((*ldx_)) * ((0))] = xr1_;
        x_[1 + ((*ldx_)) * ((0))] = xr2_;
      }
      (*xnorm_) = _max (_abs (xr1_), _abs (xr2_));
      if ((*xnorm_) > 1.0 && cmax_ > 1.0) {
        if ((*xnorm_) > bignum_ / cmax_) {
          temp_ = cmax_ / bignum_;
          x_[0 + ((*ldx_)) * ((0))] = temp_ * x_[0 + ((*ldx_)) * ((0))];
          x_[1 + ((*ldx_)) * ((0))] = temp_ * x_[1 + ((*ldx_)) * ((0))];
          (*xnorm_) = temp_ * (*xnorm_);
          (*scale_) = temp_ * (*scale_);
        }
      }
    }
    else {
      ci_[0] = -(*wi_) * (*d1_);
      ci_[1] = 0.0;
      ci_[2] = 0.0;
      ci_[3] = -(*wi_) * (*d2_);
      cmax_ = 0.0;
      icmax_ = 0;
      for (j_ = 1; j_ <= 4; (j_)++) {
        if (_abs (crv_[j_ - 1]) + _abs (civ_[j_ - 1]) > cmax_) {
          cmax_ = _abs (crv_[j_ - 1]) + _abs (civ_[j_ - 1]);
          icmax_ = j_;
        }
      }
      if (cmax_ < smini_) {
        bnorm_ = _max (_abs (b_[0 + ((*ldb_)) * ((0))]) + _abs (b_[0 + ((*ldb_)) * ((1))]), _abs (b_[1 + ((*ldb_)) * ((0))]) + 
        _abs (b_[1 + ((*ldb_)) * ((1))]));
        if (smini_ < 1.0 && bnorm_ > 1.0) {
          if (bnorm_ > bignum_ * smini_) {
            (*scale_) = 1.0 / bnorm_;
          }
        }
        temp_ = (*scale_) / smini_;
        x_[0 + ((*ldx_)) * ((0))] = temp_ * b_[0 + ((*ldb_)) * ((0))];
        x_[1 + ((*ldx_)) * ((0))] = temp_ * b_[1 + ((*ldb_)) * ((0))];
        x_[0 + ((*ldx_)) * ((1))] = temp_ * b_[0 + ((*ldb_)) * ((1))];
        x_[1 + ((*ldx_)) * ((1))] = temp_ * b_[1 + ((*ldb_)) * ((1))];
        (*xnorm_) = temp_ * bnorm_;
        (*info_) = 1;
        goto _l0;
      }
      ur11_ = crv_[icmax_ - 1];
      ui11_ = civ_[icmax_ - 1];
      cr21_ = crv_[ipivot_[1 + (4) * ((icmax_ - 1))] - 1];
      ci21_ = civ_[ipivot_[1 + (4) * ((icmax_ - 1))] - 1];
      ur12_ = crv_[ipivot_[2 + (4) * ((icmax_ - 1))] - 1];
      ui12_ = civ_[ipivot_[2 + (4) * ((icmax_ - 1))] - 1];
      cr22_ = crv_[ipivot_[3 + (4) * ((icmax_ - 1))] - 1];
      ci22_ = civ_[ipivot_[3 + (4) * ((icmax_ - 1))] - 1];
      if (icmax_ == 1 || icmax_ == 4) {
        if (_abs (ur11_) > _abs (ui11_)) {
          temp_ = ui11_ / ur11_;
          ur11r_ = 1.0 / (ur11_ * (1.0 + (temp_ * temp_)));
          ui11r_ = -temp_ * ur11r_;
        }
        else {
          temp_ = ur11_ / ui11_;
          ui11r_ = -1.0 / (ui11_ * (1.0 + (temp_ * temp_)));
          ur11r_ = -temp_ * ui11r_;
        }
        lr21_ = cr21_ * ur11r_;
        li21_ = cr21_ * ui11r_;
        ur12s_ = ur12_ * ur11r_;
        ui12s_ = ur12_ * ui11r_;
        ur22_ = cr22_ - ur12_ * lr21_;
        ui22_ = ci22_ - ur12_ * li21_;
      }
      else {
        ur11r_ = 1.0 / ur11_;
        ui11r_ = 0.0;
        lr21_ = cr21_ * ur11r_;
        li21_ = ci21_ * ur11r_;
        ur12s_ = ur12_ * ur11r_;
        ui12s_ = ui12_ * ur11r_;
        ur22_ = cr22_ - ur12_ * lr21_ + ui12_ * li21_;
        ui22_ = -ur12_ * li21_ - ui12_ * lr21_;
      }
      u22abs_ = _abs (ur22_) + _abs (ui22_);
      if (u22abs_ < smini_) {
        ur22_ = smini_;
        ui22_ = 0.0;
        (*info_) = 1;
      }
      if (rswap_[icmax_ - 1]) {
        br2_ = b_[0 + ((*ldb_)) * ((0))];
        br1_ = b_[1 + ((*ldb_)) * ((0))];
        bi2_ = b_[0 + ((*ldb_)) * ((1))];
        bi1_ = b_[1 + ((*ldb_)) * ((1))];
      }
      else {
        br1_ = b_[0 + ((*ldb_)) * ((0))];
        br2_ = b_[1 + ((*ldb_)) * ((0))];
        bi1_ = b_[0 + ((*ldb_)) * ((1))];
        bi2_ = b_[1 + ((*ldb_)) * ((1))];
      }
      br2_ = br2_ - lr21_ * br1_ + li21_ * bi1_;
      bi2_ = bi2_ - li21_ * br1_ - lr21_ * bi1_;
      bbnd_ = _max ((_abs (br1_) + _abs (bi1_)) * (u22abs_ * (_abs (ur11r_) + _abs (ui11r_))), _abs (br2_) + _abs (bi2_));
      if (bbnd_ > 1.0 && u22abs_ < 1.0) {
        if (bbnd_ >= bignum_ * u22abs_) {
          (*scale_) = 1.0 / bbnd_;
          br1_ = (*scale_) * br1_;
          bi1_ = (*scale_) * bi1_;
          br2_ = (*scale_) * br2_;
          bi2_ = (*scale_) * bi2_;
        }
      }
      (void) _sladiv (&br2_, &bi2_, &ur22_, &ui22_, &xr2_, &xi2_);
      xr1_ = ur11r_ * br1_ - ui11r_ * bi1_ - ur12s_ * xr2_ + ui12s_ * xi2_;
      xi1_ = ui11r_ * br1_ + ur11r_ * bi1_ - ui12s_ * xr2_ - ur12s_ * xi2_;
      if (cswap_[icmax_ - 1]) {
        x_[0 + ((*ldx_)) * ((0))] = xr2_;
        x_[1 + ((*ldx_)) * ((0))] = xr1_;
        x_[0 + ((*ldx_)) * ((1))] = xi2_;
        x_[1 + ((*ldx_)) * ((1))] = xi1_;
      }
      else {
        x_[0 + ((*ldx_)) * ((0))] = xr1_;
        x_[1 + ((*ldx_)) * ((0))] = xr2_;
        x_[0 + ((*ldx_)) * ((1))] = xi1_;
        x_[1 + ((*ldx_)) * ((1))] = xi2_;
      }
      (*xnorm_) = _max (_abs (xr1_) + _abs (xi1_), _abs (xr2_) + _abs (xi2_));
      if ((*xnorm_) > 1.0 && cmax_ > 1.0) {
        if ((*xnorm_) > bignum_ / cmax_) {
          temp_ = cmax_ / bignum_;
          x_[0 + ((*ldx_)) * ((0))] = temp_ * x_[0 + ((*ldx_)) * ((0))];
          x_[1 + ((*ldx_)) * ((0))] = temp_ * x_[1 + ((*ldx_)) * ((0))];
          x_[0 + ((*ldx_)) * ((1))] = temp_ * x_[0 + ((*ldx_)) * ((1))];
          x_[1 + ((*ldx_)) * ((1))] = temp_ * x_[1 + ((*ldx_)) * ((1))];
          (*xnorm_) = temp_ * (*xnorm_);
          (*scale_) = temp_ * (*scale_);
        }
      }
    }
  }
  _l0:;
  __calls[78].calls++;
  return 0;
}

real_4 _slamch (char _p_ cmach_)
{
  static int_4 beta_, imax_, imin_, it_;
  static logical_4 first_, lrnd_;
  static real_4 base_, emax_, emin_, eps_, prec_, rmach_, rmax_, rmin_, rnd_, sfmin_, small_, t_;
  int_4 _data_k_139;
  real_4 slamch_;
  extern logical_4 _lsame ();
#define _data_n_139 1
  static logical_4 _data_l_139[_data_n_139] = {
    TRUE
  };
  if (__calls[79].calls == 0) {
    _data_k_139 = 0;
    if (_data_k_139 >= _data_n_139) {
      _data_k_139 = 0;
    }
    first_ = _data_l_139[_data_k_139++];
  }
  if (first_) {
    first_ = FALSE;
    (void) _slamc2 (&beta_, &it_, &lrnd_, &eps_, &imin_, &rmin_, &imax_, &rmax_);
    base_ = beta_;
    t_ = it_;
    if (lrnd_) {
      rnd_ = 1.0;
      eps_ = (_up_real_4 (base_, (1 - it_))) / 2;
    }
    else {
      rnd_ = 0.0;
      eps_ = _up_real_4 (base_, (1 - it_));
    }
    prec_ = eps_ * base_;
    emin_ = imin_;
    emax_ = imax_;
    sfmin_ = rmin_;
    small_ = 1.0 / rmax_;
    if (small_ >= sfmin_) {
      sfmin_ = small_ * (1.0 + eps_);
    }
  }
  if (_lsame (cmach_, _dc_27)) {
    rmach_ = eps_;
  }
  else if (_lsame (cmach_, _dc_28)) {
    rmach_ = sfmin_;
  }
  else if (_lsame (cmach_, _dc_31)) {
    rmach_ = base_;
  }
  else if (_lsame (cmach_, _dc_44)) {
    rmach_ = prec_;
  }
  else if (_lsame (cmach_, _dc_7)) {
    rmach_ = t_;
  }
  else if (_lsame (cmach_, _dc_37)) {
    rmach_ = rnd_;
  }
  else if (_lsame (cmach_, _dc_23)) {
    rmach_ = emin_;
  }
  else if (_lsame (cmach_, _dc_19)) {
    rmach_ = rmin_;
  }
  else if (_lsame (cmach_, _dc_20)) {
    rmach_ = emax_;
  }
  else if (_lsame (cmach_, _dc_24)) {
    rmach_ = rmax_;
  }
  slamch_ = rmach_;
  __calls[79].calls++;
  return slamch_;
}

int_4 _slamc1 (int_4 _p_ beta_, int_4 _p_ t_, logical_4 _p_ rnd_, logical_4 _p_ ieee1_)
{
  static int_4 lbeta_, lt_;
  static logical_4 first_, lieee1_, lrnd_;
  static real_4 a_, b_, c_, f_, one_, qtr_, savec_, t1_, t2_;
  int_4 _data_k_140;
  real_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
#define _data_n_140 1
  static logical_4 _data_l_140[_data_n_140] = {
    TRUE
  };
  if (__calls[80].calls == 0) {
    _data_k_140 = 0;
    if (_data_k_140 >= _data_n_140) {
      _data_k_140 = 0;
    }
    first_ = _data_l_140[_data_k_140++];
  }
  if (first_) {
    first_ = FALSE;
    one_ = 1;
    a_ = 1;
    c_ = 1;
    _l10:;
    if (c_ == one_) {
      a_ = 2 * a_;
      c_ = _slamc3 (&a_, &one_);
      c_ = _slamc3 (&c_, ($0_ = -a_, &$0_));
      goto _l10;
    }
    b_ = 1;
    c_ = _slamc3 (&a_, &b_);
    _l20:;
    if (c_ == a_) {
      b_ = 2 * b_;
      c_ = _slamc3 (&a_, &b_);
      goto _l20;
    }
    qtr_ = one_ / 4;
    savec_ = c_;
    c_ = _slamc3 (&c_, ($1_ = -a_, &$1_));
    lbeta_ = c_ + qtr_;
    b_ = lbeta_;
    f_ = _slamc3 (($2_ = b_ / 2, &$2_), ($3_ = -b_ / 100, &$3_));
    c_ = _slamc3 (&f_, &a_);
    if (c_ == a_) {
      lrnd_ = TRUE;
    }
    else {
      lrnd_ = FALSE;
    }
    f_ = _slamc3 (($4_ = b_ / 2, &$4_), ($5_ = b_ / 100, &$5_));
    c_ = _slamc3 (&f_, &a_);
    if ((lrnd_) && (c_ == a_)) {
      lrnd_ = FALSE;
    }
    t1_ = _slamc3 (($6_ = b_ / 2, &$6_), &a_);
    t2_ = _slamc3 (($7_ = b_ / 2, &$7_), &savec_);
    lieee1_ = (t1_ == a_) && (t2_ > savec_) && lrnd_;
    lt_ = 0;
    a_ = 1;
    c_ = 1;
    _l30:;
    if (c_ == one_) {
      lt_ = lt_ + 1;
      a_ = a_ * lbeta_;
      c_ = _slamc3 (&a_, &one_);
      c_ = _slamc3 (&c_, ($8_ = -a_, &$8_));
      goto _l30;
    }
  }
  (*beta_) = lbeta_;
  (*t_) = lt_;
  (*rnd_) = lrnd_;
  (*ieee1_) = lieee1_;
  __calls[80].calls++;
  return 0;
}

int_4 _slamc2 (int_4 _p_ beta_, int_4 _p_ t_, logical_4 _p_ rnd_, real_4 _p_ eps_, int_4 _p_ emin_, real_4 _p_ rmin_, 
int_4 _p_ emax_, real_4 _p_ rmax_)
{
  static int_4 gnmin_, gpmin_, i_, lbeta_, lemax_, lemin_, lt_, ngnmin_, ngpmin_;
  static logical_4 first_, ieee_, iwarn_, lieee1_, lrnd_;
  static real_4 a_, b_, c_, half_, leps_, lrmax_, lrmin_, one_, rbase_, sixth_, small_, third_, two_, zero_;
  int_4 _data_k_141, _data_k_142, $10_, __fcnt, __rc;
  real_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $11_;
  static FORMAT $f_9999_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_66, _dc_66,
    FMT_TEXT, _dc_67, _dc_67,
    FMT_INT,"%8d","%8d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_68, _dc_68,
    FMT_TEXT, _dc_69, _dc_69,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_70, _dc_70,
    FMT_TEXT, _dc_71, _dc_71,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_72, _dc_72,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
#define _data_n_141 1
  static logical_4 _data_l_141[_data_n_141] = {
    TRUE
  };
#define _data_n_142 1
  static logical_4 _data_l_142[_data_n_142] = {
    FALSE
  };
  if (__calls[81].calls == 0) {
    _data_k_141 = 0;
    if (_data_k_141 >= _data_n_141) {
      _data_k_141 = 0;
    }
    first_ = _data_l_141[_data_k_141++];
    _data_k_142 = 0;
    if (_data_k_142 >= _data_n_142) {
      _data_k_142 = 0;
    }
    iwarn_ = _data_l_142[_data_k_142++];
  }
  if (first_) {
    first_ = FALSE;
    zero_ = 0;
    one_ = 1;
    two_ = 2;
    (void) _slamc1 (&lbeta_, &lt_, &lrnd_, &lieee1_);
    b_ = lbeta_;
    a_ = _up_real_4 (b_, (-lt_));
    leps_ = a_;
    b_ = two_ / 3;
    half_ = one_ / 2;
    sixth_ = _slamc3 (&b_, ($0_ = -half_, &$0_));
    third_ = _slamc3 (&sixth_, &sixth_);
    b_ = _slamc3 (&third_, ($1_ = -half_, &$1_));
    b_ = _slamc3 (&b_, &sixth_);
    b_ = _abs (b_);
    if (b_ < leps_) {
      b_ = leps_;
    }
    leps_ = 1;
    _l10:;
    if ((leps_ > b_) && (b_ > zero_)) {
      leps_ = b_;
      c_ = _slamc3 (($2_ = half_ * leps_, &$2_), ($4_ = (($3_ = two_ * two_, two_ * $3_ * $3_)) * ((leps_ * leps_)), &$4_));
      c_ = _slamc3 (&half_, ($5_ = -c_, &$5_));
      b_ = _slamc3 (&half_, &c_);
      c_ = _slamc3 (&half_, ($6_ = -b_, &$6_));
      b_ = _slamc3 (&half_, &c_);
      goto _l10;
    }
    if (a_ < leps_) {
      leps_ = a_;
    }
    rbase_ = one_ / lbeta_;
    small_ = one_;
    for (i_ = 1; i_ <= 3; (i_)++) {
      small_ = _slamc3 (($7_ = small_ * rbase_, &$7_), &zero_);
    }
    a_ = _slamc3 (&one_, &small_);
    (void) _slamc4 (&ngpmin_, &one_, &lbeta_);
    (void) _slamc4 (&ngnmin_, ($8_ = -one_, &$8_), &lbeta_);
    (void) _slamc4 (&gpmin_, &a_, &lbeta_);
    (void) _slamc4 (&gnmin_, ($9_ = -a_, &$9_), &lbeta_);
    ieee_ = FALSE;
    if ((ngpmin_ == ngnmin_) && (gpmin_ == gnmin_)) {
      if (ngpmin_ == gpmin_) {
        lemin_ = ngpmin_;
      }
      else if ((gpmin_ - ngpmin_) == 3) {
        lemin_ = ngpmin_ - 1 + lt_;
        ieee_ = TRUE;
      }
      else {
        lemin_ = _min (ngpmin_, gpmin_);
        iwarn_ = TRUE;
      }
    }
    else if ((ngpmin_ == gpmin_) && (ngnmin_ == gnmin_)) {
      if (_abs (ngpmin_ - ngnmin_) == 1) {
        lemin_ = _max (ngpmin_, ngnmin_);
      }
      else {
        lemin_ = _min (ngpmin_, ngnmin_);
        iwarn_ = TRUE;
      }
    }
    else if ((_abs (ngpmin_ - ngnmin_) == 1) && (gpmin_ == gnmin_)) {
      if ((gpmin_ - _min (ngpmin_, ngnmin_)) == 3) {
        lemin_ = _max (ngpmin_, ngnmin_) - 1 + lt_;
      }
      else {
        lemin_ = _min (ngpmin_, ngnmin_);
        iwarn_ = TRUE;
      }
    }
    else {
      lemin_ = ($10_ = _min (ngpmin_, ngnmin_), $10_ = _min ($10_, gpmin_), _min ($10_, gnmin_));
      iwarn_ = TRUE;
    }
    if (iwarn_) {
      first_ = TRUE;
      _fcheck ("lapack-arpack:slamc2:528", 6, action_write, form_formatted);
      __fcnt = 0;
      while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (6, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("lapack-arpack:slamc2:528", 6));
        __fcnt += 3;
      }
      if ($f_9999_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[6].unit, "\n");
        while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (6, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 6, _ioerr_write ("lapack-arpack:slamc2:528", 6));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (6, $f_9999_[__fcnt + 2], &lemin_, INTEGER, 4);
      _write_err (__rc, 6, _ioerr_write ("lapack-arpack:slamc2:528", 6));
      __fcnt += 3;
      while ($f_9999_[__fcnt] != NULL && $f_9999_[__fcnt] == FMT_TEXT) {
        if ($f_9999_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (6, $f_9999_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 6, _ioerr_write ("lapack-arpack:slamc2:528", 6));
        __fcnt += 3;
      }
      _write_eol (6);
    }
    ieee_ = ieee_ || lieee1_;
    lrmin_ = 1;
    for (i_ = 1; i_ <= 1 - lemin_; (i_)++) {
      lrmin_ = _slamc3 (($11_ = lrmin_ * rbase_, &$11_), &zero_);
    }
    (void) _slamc5 (&lbeta_, &lt_, &lemin_, &ieee_, &lemax_, &lrmax_);
  }
  (*beta_) = lbeta_;
  (*t_) = lt_;
  (*rnd_) = lrnd_;
  (*eps_) = leps_;
  (*emin_) = lemin_;
  (*rmin_) = lrmin_;
  (*emax_) = lemax_;
  (*rmax_) = lrmax_;
  goto _l0;
  _l9999:;
  _l0:;
  __calls[81].calls++;
  return 0;
}

real_4 _slamc3 (real_4 _p_ a_, real_4 _p_ b_)
{
  real_4 slamc3_;
  slamc3_ = (*a_) + (*b_);
  __calls[82].calls++;
  return slamc3_;
}

int_4 _slamc4 (int_4 _p_ emin_, real_4 _p_ start_, int_4 _p_ base_)
{
  static int_4 i_;
  static real_4 a_, b1_, b2_, c1_, c2_, d1_, d2_, one_, rbase_, zero_;
  real_4 $0_, $1_, $2_, $3_, $4_;
  a_ = (*start_);
  one_ = 1;
  rbase_ = one_ / (*base_);
  zero_ = 0;
  (*emin_) = 1;
  b1_ = _slamc3 (($0_ = a_ * rbase_, &$0_), &zero_);
  c1_ = a_;
  c2_ = a_;
  d1_ = a_;
  d2_ = a_;
  _l10:;
  if ((c1_ == a_) && (c2_ == a_) && (d1_ == a_) && (d2_ == a_)) {
    (*emin_) = (*emin_) - 1;
    a_ = b1_;
    b1_ = _slamc3 (($1_ = a_ / (*base_), &$1_), &zero_);
    c1_ = _slamc3 (($2_ = b1_ * (*base_), &$2_), &zero_);
    d1_ = zero_;
    for (i_ = 1; i_ <= (*base_); (i_)++) {
      d1_ = d1_ + b1_;
    }
    b2_ = _slamc3 (($3_ = a_ * rbase_, &$3_), &zero_);
    c2_ = _slamc3 (($4_ = b2_ / rbase_, &$4_), &zero_);
    d2_ = zero_;
    for (i_ = 1; i_ <= (*base_); (i_)++) {
      d2_ = d2_ + b2_;
    }
    goto _l10;
  }
  __calls[83].calls++;
  return 0;
}

int_4 _slamc5 (int_4 _p_ beta_, int_4 _p_ p_, int_4 _p_ emin_, logical_4 _p_ ieee_, int_4 _p_ emax_, real_4 _p_ rmax_)
{
  static int_4 exbits_, expsum_, i_, lexp_, nbits_, try_, uexp_;
  static real_4 oldy_, recbas_, y_, z_;
  real_4 $0_, $1_;
  lexp_ = 1;
  exbits_ = 1;
  _l10:;
  try_ = lexp_ * 2;
  if (try_ <= (-(*emin_))) {
    lexp_ = try_;
    exbits_ = exbits_ + 1;
    goto _l10;
  }
  if (lexp_ == -(*emin_)) {
    uexp_ = lexp_;
  }
  else {
    uexp_ = try_;
    exbits_ = exbits_ + 1;
  }
  if ((uexp_ + (*emin_)) > (-lexp_ - (*emin_))) {
    expsum_ = 2 * lexp_;
  }
  else {
    expsum_ = 2 * uexp_;
  }
  (*emax_) = expsum_ + (*emin_) - 1;
  nbits_ = 1 + exbits_ + (*p_);
  if ((_imod (nbits_, 2) == 1) && ((*beta_) == 2)) {
    (*emax_) = (*emax_) - 1;
  }
  if ((*ieee_)) {
    (*emax_) = (*emax_) - 1;
  }
  recbas_ = 1.0 / (*beta_);
  z_ = (*beta_) - 1.0;
  y_ = 0.0;
  for (i_ = 1; i_ <= (*p_); (i_)++) {
    z_ = z_ * recbas_;
    if (y_ < 1.0) {
      oldy_ = y_;
    }
    y_ = _slamc3 (&y_, &z_);
  }
  if (y_ >= 1.0) {
    y_ = oldy_;
  }
  for (i_ = 1; i_ <= (*emax_); (i_)++) {
    y_ = _slamc3 (($0_ = y_ * (*beta_), &$0_), ($1_ = 0.0, &$1_));
  }
  (*rmax_) = y_;
  __calls[84].calls++;
  return 0;
}

real_4 _slange (char _p_ norm_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ work_)
{
  static int_4 i_, j_;
  static real_4 scale_, sum_, value_;
  real_4 slange_;
  extern logical_4 _lsame ();
  if (_min ((*m_), (*n_)) == 0) {
    value_ = 0.0;
  }
  else if (_lsame (norm_, _dc_23)) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        value_ = _max (value_, _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]));
      }
    }
  }
  else if ((_lsame (norm_, _dc_24)) || ((strcmp (norm_, _dc_22) == 0))) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = 0.0;
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        sum_ = sum_ + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
      value_ = _max (value_, sum_);
    }
  }
  else if (_lsame (norm_, _dc_25)) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        work_[i_ - 1] = work_[i_ - 1] + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
    }
    value_ = 0.0;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      value_ = _max (value_, work_[i_ - 1]);
    }
  }
  else if ((_lsame (norm_, _dc_26)) || (_lsame (norm_, _dc_27))) {
    scale_ = 0.0;
    sum_ = 1.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _slassq (m_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &scale_, &sum_);
    }
    value_ = scale_ * sqrtf (sum_);
  }
  slange_ = value_;
  __calls[85].calls++;
  return slange_;
}

real_4 _slanhs (char _p_ norm_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, real_4 _p_ work_)
{
  static int_4 i_, j_;
  static real_4 scale_, sum_, value_;
  int_4 $0_;
  real_4 slanhs_;
  extern logical_4 _lsame ();
  if ((*n_) == 0) {
    value_ = 0.0;
  }
  else if (_lsame (norm_, _dc_23)) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        value_ = _max (value_, _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]));
      }
    }
  }
  else if ((_lsame (norm_, _dc_24)) || ((strcmp (norm_, _dc_22) == 0))) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = 0.0;
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        sum_ = sum_ + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
      value_ = _max (value_, sum_);
    }
  }
  else if (_lsame (norm_, _dc_25)) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        work_[i_ - 1] = work_[i_ - 1] + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
    }
    value_ = 0.0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      value_ = _max (value_, work_[i_ - 1]);
    }
  }
  else if ((_lsame (norm_, _dc_26)) || (_lsame (norm_, _dc_27))) {
    scale_ = 0.0;
    sum_ = 1.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _slassq (($0_ = _min ((*n_), j_ + 1), &$0_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &scale_, &sum_);
    }
    value_ = scale_ * sqrtf (sum_);
  }
  slanhs_ = value_;
  __calls[86].calls++;
  return slanhs_;
}

real_4 _slanst (char _p_ norm_, int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_)
{
  static int_4 i_;
  static real_4 anorm_, scale_, sum_;
  int_4 $0_;
  real_4 slanst_;
  extern logical_4 _lsame ();
  if ((*n_) <= 0) {
    anorm_ = 0.0;
  }
  else if (_lsame (norm_, _dc_23)) {
    anorm_ = _abs (d_[(*n_) - 1]);
    for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
      anorm_ = _max (anorm_, _abs (d_[i_ - 1]));
      anorm_ = _max (anorm_, _abs (e_[i_ - 1]));
    }
  }
  else if (_lsame (norm_, _dc_24) || (strcmp (norm_, _dc_22) == 0) || _lsame (norm_, _dc_25)) {
    if ((*n_) == 1) {
      anorm_ = _abs (d_[0]);
    }
    else {
      anorm_ = _max (_abs (d_[0]) + _abs (e_[0]), _abs (e_[(*n_) - 1 - 1]) + _abs (d_[(*n_) - 1]));
      for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
        anorm_ = _max (anorm_, _abs (d_[i_ - 1]) + _abs (e_[i_ - 1]) + _abs (e_[i_ - 1 - 1]));
      }
    }
  }
  else if ((_lsame (norm_, _dc_26)) || (_lsame (norm_, _dc_27))) {
    scale_ = 0.0;
    sum_ = 1.0;
    if ((*n_) > 1) {
      (void) _slassq (($0_ = (*n_) - 1, &$0_), e_, &_k1, &scale_, &sum_);
      sum_ = 2 * sum_;
    }
    (void) _slassq (n_, d_, &_k1, &scale_, &sum_);
    anorm_ = scale_ * sqrtf (sum_);
  }
  slanst_ = anorm_;
  __calls[87].calls++;
  return slanst_;
}

int_4 _slanv2 (real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ rt1r_, real_4 _p_ rt1i_, real_4 
_p_ rt2r_, real_4 _p_ rt2i_, real_4 _p_ cs_, real_4 _p_ sn_)
{
  static real_4 aa_, bb_, cc_, cs1_, dd_, p_, sab_, sac_, sigma_, sn1_, tau_, temp_;
  (*cs_) = 1.0;
  (*sn_) = 0.0;
  if ((*c_) == 0.0) {
    goto _l10;
  }
  else if ((*b_) == 0.0) {
    (*cs_) = 0.0;
    (*sn_) = 1.0;
    temp_ = (*d_);
    (*d_) = (*a_);
    (*a_) = temp_;
    (*b_) = -(*c_);
    (*c_) = 0.0;
    goto _l10;
  }
  else if (((*a_) - (*d_)) == 0.0 && _sign (1.0, (*b_)) != _sign (1.0, (*c_))) {
    goto _l10;
  }
  else {
    temp_ = (*a_) - (*d_);
    p_ = 0.5 * temp_;
    sigma_ = (*b_) + (*c_);
    tau_ = _slapy2 (&sigma_, &temp_);
    cs1_ = sqrtf (0.5 * (1.0 + _abs (sigma_) / tau_));
    sn1_ = -(p_ / (tau_ * cs1_)) * _sign (1.0, sigma_);
    aa_ = (*a_) * cs1_ + (*b_) * sn1_;
    bb_ = -(*a_) * sn1_ + (*b_) * cs1_;
    cc_ = (*c_) * cs1_ + (*d_) * sn1_;
    dd_ = -(*c_) * sn1_ + (*d_) * cs1_;
    (*a_) = aa_ * cs1_ + cc_ * sn1_;
    (*b_) = bb_ * cs1_ + dd_ * sn1_;
    (*c_) = -aa_ * sn1_ + cc_ * cs1_;
    (*d_) = -bb_ * sn1_ + dd_ * cs1_;
    temp_ = (*cs_) * cs1_ - (*sn_) * sn1_;
    (*sn_) = (*cs_) * sn1_ + (*sn_) * cs1_;
    (*cs_) = temp_;
    temp_ = 0.5 * ((*a_) + (*d_));
    (*a_) = temp_;
    (*d_) = temp_;
    if ((*c_) != 0.0) {
      if ((*b_) != 0.0) {
        if (_sign (1.0, (*b_)) == _sign (1.0, (*c_))) {
          sab_ = sqrtf (_abs ((*b_)));
          sac_ = sqrtf (_abs ((*c_)));
          p_ = _sign (sab_ * sac_, (*c_));
          tau_ = 1.0 / sqrtf (_abs ((*b_) + (*c_)));
          (*a_) = temp_ + p_;
          (*d_) = temp_ - p_;
          (*b_) = (*b_) - (*c_);
          (*c_) = 0.0;
          cs1_ = sab_ * tau_;
          sn1_ = sac_ * tau_;
          temp_ = (*cs_) * cs1_ - (*sn_) * sn1_;
          (*sn_) = (*cs_) * sn1_ + (*sn_) * cs1_;
          (*cs_) = temp_;
        }
      }
      else {
        (*b_) = -(*c_);
        (*c_) = 0.0;
        temp_ = (*cs_);
        (*cs_) = -(*sn_);
        (*sn_) = temp_;
      }
    }
  }
  _l10:;
  (*rt1r_) = (*a_);
  (*rt2r_) = (*d_);
  if ((*c_) == 0.0) {
    (*rt1i_) = 0.0;
    (*rt2i_) = 0.0;
  }
  else {
    (*rt1i_) = sqrtf (_abs ((*b_))) * sqrtf (_abs ((*c_)));
    (*rt2i_) = -(*rt1i_);
  }
  __calls[88].calls++;
  return 0;
}

int_4 _slaptm (int_4 _p_ n_, int_4 _p_ nrhs_, real_4 _p_ alpha_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ x_, int_4 _p_ 
ldx_, real_4 _p_ beta_, real_4 _p_ b_, int_4 _p_ ldb_)
{
  static int_4 i_, j_;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*beta_) == 0.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = 0.0;
      }
    }
  }
  else if ((*beta_) == -1.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = -b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
      }
    }
  }
  if ((*alpha_) == 1.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      if ((*n_) == 1) {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
      }
      else {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] + d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] + e_[0] * x_[1 
        + ((*ldx_)) * ((j_ - 1))];
        b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] + e_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
        + ((*ldx_)) * ((j_ - 1))] + d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
        for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] + e_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
          * ((j_ - 1))] + d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + e_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 1))]
          ;
        }
      }
    }
  }
  else if ((*alpha_) == -1.0) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      if ((*n_) == 1) {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))];
      }
      else {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - d_[0] * x_[0 + ((*ldx_)) * ((j_ - 1))] - e_[0] * x_[1 
        + ((*ldx_)) * ((j_ - 1))];
        b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] - e_[(*n_) - 1 - 1] * x_[(*n_) - 1 - 1 
        + ((*ldx_)) * ((j_ - 1))] - d_[(*n_) - 1] * x_[(*n_) - 1 + ((*ldx_)) * ((j_ - 1))];
        for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - e_[i_ - 1 - 1] * x_[i_ - 1 - 1 + ((*ldx_)) 
          * ((j_ - 1))] - d_[i_ - 1] * x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] - e_[i_ - 1] * x_[i_ + 1 - 1 + ((*ldx_)) * ((j_ - 1))]
          ;
        }
      }
    }
  }
  _l0:;
  __calls[89].calls++;
  return 0;
}

real_4 _slapy2 (real_4 _p_ x_, real_4 _p_ y_)
{
  static real_4 w_, xabs_, yabs_, z_;
  real_4 $0_;
  real_4 slapy2_;
  xabs_ = _abs ((*x_));
  yabs_ = _abs ((*y_));
  w_ = _max (xabs_, yabs_);
  z_ = _min (xabs_, yabs_);
  if (z_ == 0.0) {
    slapy2_ = w_;
  }
  else {
    slapy2_ = w_ * sqrtf (1.0 + ($0_ = (z_ / w_), $0_ * $0_));
  }
  __calls[90].calls++;
  return slapy2_;
}

real_4 _slapy3 (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ z_)
{
  static real_4 w_, xabs_, yabs_, zabs_;
  real_4 $0_, $1_, $2_, $3_;
  real_4 slapy3_;
  xabs_ = _abs ((*x_));
  yabs_ = _abs ((*y_));
  zabs_ = _abs ((*z_));
  w_ = ($0_ = _max (xabs_, yabs_), _max ($0_, zabs_));
  if (w_ == 0.0) {
    slapy3_ = 0.0;
  }
  else {
    slapy3_ = w_ * sqrtf (($1_ = (xabs_ / w_), $1_ * $1_) + ($2_ = (yabs_ / w_), $2_ * $2_) + ($3_ = (zabs_ / w_), $3_ * 
    $3_));
  }
  __calls[91].calls++;
  return slapy3_;
}

real_4 _slaran (int_4 _p_ iseed_)
{
  static int_4 it1_, it2_, it3_, it4_;
  real_4 slaran_;
  it4_ = iseed_[3] * 2549;
  it3_ = it4_ / 4096;
  it4_ = it4_ - 4096 * it3_;
  it3_ = it3_ + iseed_[2] * 2549 + iseed_[3] * 2508;
  it2_ = it3_ / 4096;
  it3_ = it3_ - 4096 * it2_;
  it2_ = it2_ + iseed_[1] * 2549 + iseed_[2] * 2508 + iseed_[3] * 322;
  it1_ = it2_ / 4096;
  it2_ = it2_ - 4096 * it1_;
  it1_ = it1_ + iseed_[0] * 2549 + iseed_[1] * 2508 + iseed_[2] * 322 + iseed_[3] * 494;
  it1_ = _imod (it1_, 4096);
  iseed_[0] = it1_;
  iseed_[1] = it2_;
  iseed_[2] = it3_;
  iseed_[3] = it4_;
  slaran_ = 2.4414063e-4 * ((real_4) (it1_) + 2.4414063e-4 * ((real_4) (it2_) + 2.4414063e-4 * ((real_4) (it3_) + 
  2.4414063e-4 * ((real_4) (it4_)))));
  __calls[92].calls++;
  return slaran_;
}

int_4 _slarf (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ v_, int_4 _p_ incv_, real_4 _p_ tau_, real_4 _p_ 
c_, int_4 _p_ ldc_, real_4 _p_ work_)
{
  real_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern int_4 _sgemv ();
  extern int_4 _sger ();
  extern logical_4 _lsame ();
  if (_lsame (side_, _dc_20)) {
    if ((*tau_) != 0.0) {
      (void) _sgemv (_dc_13, m_, n_, ($0_ = 1.0, &$0_), c_, ldc_, v_, incv_, ($1_ = 0.0, &$1_), work_, &_k1);
      (void) _sger (m_, n_, ($2_ = -(*tau_), &$2_), v_, incv_, work_, &_k1, c_, ldc_);
    }
  }
  else {
    if ((*tau_) != 0.0) {
      (void) _sgemv (_dc_5, m_, n_, ($3_ = 1.0, &$3_), c_, ldc_, v_, incv_, ($4_ = 0.0, &$4_), work_, &_k1);
      (void) _sger (m_, n_, ($5_ = -(*tau_), &$5_), work_, &_k1, v_, incv_, c_, ldc_);
    }
  }
  __calls[93].calls++;
  return 0;
}

int_4 _slarfg (int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ tau_)
{
  static int_4 j_, knt_;
  static real_4 beta_, rsafmn_, safmin_, xnorm_;
  int_4 $0_, $1_, $2_, $3_, $5_;
  real_4 $4_, $6_;
  extern real_4 _snrm2 ();
  extern int_4 _sscal ();
  if ((*n_) <= 1) {
    (*tau_) = 0.0;
    goto _l0;
  }
  xnorm_ = _snrm2 (($0_ = (*n_) - 1, &$0_), x_, incx_);
  if (xnorm_ == 0.0) {
    (*tau_) = 0.0;
  }
  else {
    beta_ = -_sign (_slapy2 (alpha_, &xnorm_), (*alpha_));
    safmin_ = _slamch (_dc_28) / _slamch (_dc_27);
    if (_abs (beta_) < safmin_) {
      rsafmn_ = 1.0 / safmin_;
      knt_ = 0;
      _l10:;
      knt_ = knt_ + 1;
      (void) _sscal (($1_ = (*n_) - 1, &$1_), &rsafmn_, x_, incx_);
      beta_ = beta_ * rsafmn_;
      (*alpha_) = (*alpha_) * rsafmn_;
      if (_abs (beta_) < safmin_) {
        goto _l10;
      }
      xnorm_ = _snrm2 (($2_ = (*n_) - 1, &$2_), x_, incx_);
      beta_ = -_sign (_slapy2 (alpha_, &xnorm_), (*alpha_));
      (*tau_) = (beta_ - (*alpha_)) / beta_;
      (void) _sscal (($3_ = (*n_) - 1, &$3_), ($4_ = 1.0 / ((*alpha_) - beta_), &$4_), x_, incx_);
      (*alpha_) = beta_;
      for (j_ = 1; j_ <= knt_; (j_)++) {
        (*alpha_) = (*alpha_) * safmin_;
      }
    }
    else {
      (*tau_) = (beta_ - (*alpha_)) / beta_;
      (void) _sscal (($5_ = (*n_) - 1, &$5_), ($6_ = 1.0 / ((*alpha_) - beta_), &$6_), x_, incx_);
      (*alpha_) = beta_;
    }
  }
  _l0:;
  __calls[94].calls++;
  return 0;
}

int_4 _slarfx (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ v_, real_4 _p_ tau_, real_4 _p_ c_, int_4 _p_ 
ldc_, real_4 _p_ work_)
{
  static int_4 j_;
  static real_4 sum_, t1_, t10_, t2_, t3_, t4_, t5_, t6_, t7_, t8_, t9_, v1_, v10_, v2_, v3_, v4_, v5_, v6_, v7_, v8_, 
  v9_;
  real_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern logical_4 _lsame ();
  extern int_4 _sgemv ();
  extern int_4 _sger ();
  if ((*tau_) == 0.0) {
    goto _l0;
  }
  if (_lsame (side_, _dc_20)) {
    switch ((*m_)) {
      default:
      case 1: goto _l10;
      case 2: goto _l30;
      case 3: goto _l50;
      case 4: goto _l70;
      case 5: goto _l90;
      case 6: goto _l110;
      case 7: goto _l130;
      case 8: goto _l150;
      case 9: goto _l170;
      case 10: goto _l190;
    }
    (void) _sgemv (_dc_13, m_, n_, ($0_ = 1.0, &$0_), c_, ldc_, v_, &_k1, ($1_ = 0.0, &$1_), work_, &_k1);
    (void) _sger (m_, n_, ($2_ = -(*tau_), &$2_), v_, &_k1, work_, &_k1, c_, ldc_);
    goto _l410;
    _l10:;
    t1_ = 1.0 - (*tau_) * v_[0] * v_[0];
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      c_[0 + ((*ldc_)) * ((j_ - 1))] = t1_ * c_[0 + ((*ldc_)) * ((j_ - 1))];
    }
    goto _l410;
    _l30:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
    }
    goto _l410;
    _l50:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
    }
    goto _l410;
    _l70:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
    }
    goto _l410;
    _l90:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
    }
    goto _l410;
    _l110:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
    }
    goto _l410;
    _l130:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))] + v7_ * c_[6 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
      c_[6 + ((*ldc_)) * ((j_ - 1))] = c_[6 + ((*ldc_)) * ((j_ - 1))] - sum_ * t7_;
    }
    goto _l410;
    _l150:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))] + v7_ * c_[6 + ((*ldc_)) * ((j_ - 1))] + v8_ * c_[7 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
      c_[6 + ((*ldc_)) * ((j_ - 1))] = c_[6 + ((*ldc_)) * ((j_ - 1))] - sum_ * t7_;
      c_[7 + ((*ldc_)) * ((j_ - 1))] = c_[7 + ((*ldc_)) * ((j_ - 1))] - sum_ * t8_;
    }
    goto _l410;
    _l170:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    v9_ = v_[8];
    t9_ = (*tau_) * v9_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))] + v7_ * c_[6 + ((*ldc_)) * ((j_ - 1))] + v8_ * c_[7 + ((*ldc_)) * ((j_ - 1))] + v9_ * c_[8 + ((*ldc_)) * ((j_ - 
      1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
      c_[6 + ((*ldc_)) * ((j_ - 1))] = c_[6 + ((*ldc_)) * ((j_ - 1))] - sum_ * t7_;
      c_[7 + ((*ldc_)) * ((j_ - 1))] = c_[7 + ((*ldc_)) * ((j_ - 1))] - sum_ * t8_;
      c_[8 + ((*ldc_)) * ((j_ - 1))] = c_[8 + ((*ldc_)) * ((j_ - 1))] - sum_ * t9_;
    }
    goto _l410;
    _l190:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    v9_ = v_[8];
    t9_ = (*tau_) * v9_;
    v10_ = v_[9];
    t10_ = (*tau_) * v10_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = v1_ * c_[0 + ((*ldc_)) * ((j_ - 1))] + v2_ * c_[1 + ((*ldc_)) * ((j_ - 1))] + v3_ * c_[2 + ((*ldc_)) * ((j_ - 
      1))] + v4_ * c_[3 + ((*ldc_)) * ((j_ - 1))] + v5_ * c_[4 + ((*ldc_)) * ((j_ - 1))] + v6_ * c_[5 + ((*ldc_)) * ((j_ - 
      1))] + v7_ * c_[6 + ((*ldc_)) * ((j_ - 1))] + v8_ * c_[7 + ((*ldc_)) * ((j_ - 1))] + v9_ * c_[8 + ((*ldc_)) * ((j_ - 
      1))] + v10_ * c_[9 + ((*ldc_)) * ((j_ - 1))];
      c_[0 + ((*ldc_)) * ((j_ - 1))] = c_[0 + ((*ldc_)) * ((j_ - 1))] - sum_ * t1_;
      c_[1 + ((*ldc_)) * ((j_ - 1))] = c_[1 + ((*ldc_)) * ((j_ - 1))] - sum_ * t2_;
      c_[2 + ((*ldc_)) * ((j_ - 1))] = c_[2 + ((*ldc_)) * ((j_ - 1))] - sum_ * t3_;
      c_[3 + ((*ldc_)) * ((j_ - 1))] = c_[3 + ((*ldc_)) * ((j_ - 1))] - sum_ * t4_;
      c_[4 + ((*ldc_)) * ((j_ - 1))] = c_[4 + ((*ldc_)) * ((j_ - 1))] - sum_ * t5_;
      c_[5 + ((*ldc_)) * ((j_ - 1))] = c_[5 + ((*ldc_)) * ((j_ - 1))] - sum_ * t6_;
      c_[6 + ((*ldc_)) * ((j_ - 1))] = c_[6 + ((*ldc_)) * ((j_ - 1))] - sum_ * t7_;
      c_[7 + ((*ldc_)) * ((j_ - 1))] = c_[7 + ((*ldc_)) * ((j_ - 1))] - sum_ * t8_;
      c_[8 + ((*ldc_)) * ((j_ - 1))] = c_[8 + ((*ldc_)) * ((j_ - 1))] - sum_ * t9_;
      c_[9 + ((*ldc_)) * ((j_ - 1))] = c_[9 + ((*ldc_)) * ((j_ - 1))] - sum_ * t10_;
    }
    goto _l410;
  }
  else {
    switch ((*n_)) {
      default:
      case 1: goto _l210;
      case 2: goto _l230;
      case 3: goto _l250;
      case 4: goto _l270;
      case 5: goto _l290;
      case 6: goto _l310;
      case 7: goto _l330;
      case 8: goto _l350;
      case 9: goto _l370;
      case 10: goto _l390;
    }
    (void) _sgemv (_dc_5, m_, n_, ($3_ = 1.0, &$3_), c_, ldc_, v_, &_k1, ($4_ = 0.0, &$4_), work_, &_k1);
    (void) _sger (m_, n_, ($5_ = -(*tau_), &$5_), work_, &_k1, v_, &_k1, c_, ldc_);
    goto _l410;
    _l210:;
    t1_ = 1.0 - (*tau_) * v_[0] * v_[0];
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      c_[j_ - 1 + ((*ldc_)) * ((0))] = t1_ * c_[j_ - 1 + ((*ldc_)) * ((0))];
    }
    goto _l410;
    _l230:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
    }
    goto _l410;
    _l250:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
    }
    goto _l410;
    _l270:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
    }
    goto _l410;
    _l290:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
    }
    goto _l410;
    _l310:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
    }
    goto _l410;
    _l330:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))] + v7_ * c_[j_ - 1 + ((*ldc_)) * ((6))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
      c_[j_ - 1 + ((*ldc_)) * ((6))] = c_[j_ - 1 + ((*ldc_)) * ((6))] - sum_ * t7_;
    }
    goto _l410;
    _l350:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))] + v7_ * c_[j_ - 1 + ((*ldc_)) * ((6))] + v8_ * c_[j_ - 1 + ((*ldc_)) * ((7))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
      c_[j_ - 1 + ((*ldc_)) * ((6))] = c_[j_ - 1 + ((*ldc_)) * ((6))] - sum_ * t7_;
      c_[j_ - 1 + ((*ldc_)) * ((7))] = c_[j_ - 1 + ((*ldc_)) * ((7))] - sum_ * t8_;
    }
    goto _l410;
    _l370:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    v9_ = v_[8];
    t9_ = (*tau_) * v9_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))] + v7_ * c_[j_ - 1 + ((*ldc_)) * ((6))] + v8_ * c_[j_ - 1 + ((*ldc_)) * ((7))] + v9_ * c_[j_ - 1 + ((*ldc_)) * 
      ((8))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
      c_[j_ - 1 + ((*ldc_)) * ((6))] = c_[j_ - 1 + ((*ldc_)) * ((6))] - sum_ * t7_;
      c_[j_ - 1 + ((*ldc_)) * ((7))] = c_[j_ - 1 + ((*ldc_)) * ((7))] - sum_ * t8_;
      c_[j_ - 1 + ((*ldc_)) * ((8))] = c_[j_ - 1 + ((*ldc_)) * ((8))] - sum_ * t9_;
    }
    goto _l410;
    _l390:;
    v1_ = v_[0];
    t1_ = (*tau_) * v1_;
    v2_ = v_[1];
    t2_ = (*tau_) * v2_;
    v3_ = v_[2];
    t3_ = (*tau_) * v3_;
    v4_ = v_[3];
    t4_ = (*tau_) * v4_;
    v5_ = v_[4];
    t5_ = (*tau_) * v5_;
    v6_ = v_[5];
    t6_ = (*tau_) * v6_;
    v7_ = v_[6];
    t7_ = (*tau_) * v7_;
    v8_ = v_[7];
    t8_ = (*tau_) * v8_;
    v9_ = v_[8];
    t9_ = (*tau_) * v9_;
    v10_ = v_[9];
    t10_ = (*tau_) * v10_;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      sum_ = v1_ * c_[j_ - 1 + ((*ldc_)) * ((0))] + v2_ * c_[j_ - 1 + ((*ldc_)) * ((1))] + v3_ * c_[j_ - 1 + ((*ldc_)) * 
      ((2))] + v4_ * c_[j_ - 1 + ((*ldc_)) * ((3))] + v5_ * c_[j_ - 1 + ((*ldc_)) * ((4))] + v6_ * c_[j_ - 1 + ((*ldc_)) * 
      ((5))] + v7_ * c_[j_ - 1 + ((*ldc_)) * ((6))] + v8_ * c_[j_ - 1 + ((*ldc_)) * ((7))] + v9_ * c_[j_ - 1 + ((*ldc_)) * 
      ((8))] + v10_ * c_[j_ - 1 + ((*ldc_)) * ((9))];
      c_[j_ - 1 + ((*ldc_)) * ((0))] = c_[j_ - 1 + ((*ldc_)) * ((0))] - sum_ * t1_;
      c_[j_ - 1 + ((*ldc_)) * ((1))] = c_[j_ - 1 + ((*ldc_)) * ((1))] - sum_ * t2_;
      c_[j_ - 1 + ((*ldc_)) * ((2))] = c_[j_ - 1 + ((*ldc_)) * ((2))] - sum_ * t3_;
      c_[j_ - 1 + ((*ldc_)) * ((3))] = c_[j_ - 1 + ((*ldc_)) * ((3))] - sum_ * t4_;
      c_[j_ - 1 + ((*ldc_)) * ((4))] = c_[j_ - 1 + ((*ldc_)) * ((4))] - sum_ * t5_;
      c_[j_ - 1 + ((*ldc_)) * ((5))] = c_[j_ - 1 + ((*ldc_)) * ((5))] - sum_ * t6_;
      c_[j_ - 1 + ((*ldc_)) * ((6))] = c_[j_ - 1 + ((*ldc_)) * ((6))] - sum_ * t7_;
      c_[j_ - 1 + ((*ldc_)) * ((7))] = c_[j_ - 1 + ((*ldc_)) * ((7))] - sum_ * t8_;
      c_[j_ - 1 + ((*ldc_)) * ((8))] = c_[j_ - 1 + ((*ldc_)) * ((8))] - sum_ * t9_;
      c_[j_ - 1 + ((*ldc_)) * ((9))] = c_[j_ - 1 + ((*ldc_)) * ((9))] - sum_ * t10_;
    }
    goto _l410;
  }
  _l410:;
  _l0:;
  __calls[95].calls++;
  return 0;
}

real_4 _slarnd (int_4 _p_ idist_, int_4 _p_ iseed_)
{
  static real_4 t1_, t2_;
  real_4 slarnd_;
  t1_ = _slaran (iseed_);
  if ((*idist_) == 1) {
    slarnd_ = t1_;
  }
  else if ((*idist_) == 2) {
    slarnd_ = 2.0 * t1_ - 1.0;
  }
  else if ((*idist_) == 3) {
    t2_ = _slaran (iseed_);
    slarnd_ = sqrtf (-2.0 * logf (t1_)) * cosf (6.2831853 * t2_);
  }
  __calls[96].calls++;
  return slarnd_;
}

int_4 _slarnv (int_4 _p_ idist_, int_4 _p_ iseed_, int_4 _p_ n_, real_4 _p_ x_)
{
  static int_4 i_, il_, il2_, iv_;
  static real_4 u_[128];
  for (iv_ = 1; (64 > 0 ? iv_ <= (*n_) : iv_ >= (*n_)); iv_ += 64) {
    il_ = _min (64, (*n_) - iv_ + 1);
    if ((*idist_) == 3) {
      il2_ = 2 * il_;
    }
    else {
      il2_ = il_;
    }
    (void) _slaruv (iseed_, &il2_, u_);
    if ((*idist_) == 1) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = u_[i_ - 1];
      }
    }
    else if ((*idist_) == 2) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = 2.0 * u_[i_ - 1] - 1.0;
      }
    }
    else if ((*idist_) == 3) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = sqrtf (-2.0 * logf (u_[2 * i_ - 1 - 1])) * cosf (6.2831853 * u_[2 * i_ - 1]);
      }
    }
  }
  __calls[97].calls++;
  return 0;
}

int_4 _slartg (real_4 _p_ f_, real_4 _p_ g_, real_4 _p_ cs_, real_4 _p_ sn_, real_4 _p_ r_)
{
  static int_4 count_, i_;
  static logical_4 first_;
  static real_4 eps_, f1_, g1_, safmin_, safmn2_, safmx2_, scale_;
  int_4 _data_k_143;
#define _data_n_143 1
  static logical_4 _data_l_143[_data_n_143] = {
    TRUE
  };
  if (__calls[98].calls == 0) {
    _data_k_143 = 0;
    if (_data_k_143 >= _data_n_143) {
      _data_k_143 = 0;
    }
    first_ = _data_l_143[_data_k_143++];
  }
  if (first_) {
    first_ = FALSE;
    safmin_ = _slamch (_dc_28);
    eps_ = _slamch (_dc_27);
    safmn2_ = _up_real_4 (_slamch (_dc_31), (int_4) (_aintd (logf (safmin_ / eps_) / logf (_slamch (_dc_31)) / 2.0)));
    safmx2_ = 1.0 / safmn2_;
  }
  if ((*g_) == 0.0) {
    (*cs_) = 1.0;
    (*sn_) = 0.0;
    (*r_) = (*f_);
  }
  else if ((*f_) == 0.0) {
    (*cs_) = 0.0;
    (*sn_) = 1.0;
    (*r_) = (*g_);
  }
  else {
    f1_ = (*f_);
    g1_ = (*g_);
    scale_ = _max (_abs (f1_), _abs (g1_));
    if (scale_ >= safmx2_) {
      count_ = 0;
      _l10:;
      count_ = count_ + 1;
      f1_ = f1_ * safmn2_;
      g1_ = g1_ * safmn2_;
      scale_ = _max (_abs (f1_), _abs (g1_));
      if (scale_ >= safmx2_) {
        goto _l10;
      }
      (*r_) = sqrtf ((f1_ * f1_) + (g1_ * g1_));
      (*cs_) = f1_ / (*r_);
      (*sn_) = g1_ / (*r_);
      for (i_ = 1; i_ <= count_; (i_)++) {
        (*r_) = (*r_) * safmx2_;
      }
    }
    else if (scale_ <= safmn2_) {
      count_ = 0;
      _l30:;
      count_ = count_ + 1;
      f1_ = f1_ * safmx2_;
      g1_ = g1_ * safmx2_;
      scale_ = _max (_abs (f1_), _abs (g1_));
      if (scale_ <= safmn2_) {
        goto _l30;
      }
      (*r_) = sqrtf ((f1_ * f1_) + (g1_ * g1_));
      (*cs_) = f1_ / (*r_);
      (*sn_) = g1_ / (*r_);
      for (i_ = 1; i_ <= count_; (i_)++) {
        (*r_) = (*r_) * safmn2_;
      }
    }
    else {
      (*r_) = sqrtf ((f1_ * f1_) + (g1_ * g1_));
      (*cs_) = f1_ / (*r_);
      (*sn_) = g1_ / (*r_);
    }
    if (_abs ((*f_)) > _abs ((*g_)) && (*cs_) < 0.0) {
      (*cs_) = -(*cs_);
      (*sn_) = -(*sn_);
      (*r_) = -(*r_);
    }
  }
  __calls[98].calls++;
  return 0;
}

int_4 _slaruv (int_4 _p_ iseed_, int_4 _p_ n_, real_4 _p_ x_)
{
  static int_4 i_, i1_, i2_, i3_, i4_, it1_, it2_, it3_, it4_, j_, mm_[512];
  int_4 _data_k_144, _data_k_145, _data_k_146, _data_k_147, _data_k_148, _data_k_149, _data_k_150, _data_k_151, 
  _data_k_152, _data_k_153, _data_k_154, _data_k_155, _data_k_156, _data_k_157, _data_k_158, _data_k_159, _data_k_160, 
  _data_k_161, _data_k_162, _data_k_163, _data_k_164, _data_k_165, _data_k_166, _data_k_167, _data_k_168, _data_k_169, 
  _data_k_170, _data_k_171, _data_k_172, _data_k_173, _data_k_174, _data_k_175, _data_k_176, _data_k_177, _data_k_178, 
  _data_k_179, _data_k_180, _data_k_181, _data_k_182, _data_k_183, _data_k_184, _data_k_185, _data_k_186, _data_k_187, 
  _data_k_188, _data_k_189, _data_k_190, _data_k_191, _data_k_192, _data_k_193, _data_k_194, _data_k_195, _data_k_196, 
  _data_k_197, _data_k_198, _data_k_199, _data_k_200, _data_k_201, _data_k_202, _data_k_203, _data_k_204, _data_k_205, 
  _data_k_206, _data_k_207, _data_k_208, _data_k_209, _data_k_210, _data_k_211, _data_k_212, _data_k_213, _data_k_214, 
  _data_k_215, _data_k_216, _data_k_217, _data_k_218, _data_k_219, _data_k_220, _data_k_221, _data_k_222, _data_k_223, 
  _data_k_224, _data_k_225, _data_k_226, _data_k_227, _data_k_228, _data_k_229, _data_k_230, _data_k_231, _data_k_232, 
  _data_k_233, _data_k_234, _data_k_235, _data_k_236, _data_k_237, _data_k_238, _data_k_239, _data_k_240, _data_k_241, 
  _data_k_242, _data_k_243, _data_k_244, _data_k_245, _data_k_246, _data_k_247, _data_k_248, _data_k_249, _data_k_250, 
  _data_k_251, _data_k_252, _data_k_253, _data_k_254, _data_k_255, _data_k_256, _data_k_257, _data_k_258, _data_k_259, 
  _data_k_260, _data_k_261, _data_k_262, _data_k_263, _data_k_264, _data_k_265, _data_k_266, _data_k_267, _data_k_268, 
  _data_k_269, _data_k_270, _data_k_271;
#define _data_n_144 4
  static int_4 _data_l_144[_data_n_144] = {
    494,
    322,
    2508,
    2549
  };
#define _data_n_145 4
  static int_4 _data_l_145[_data_n_145] = {
    2637,
    789,
    3754,
    1145
  };
#define _data_n_146 4
  static int_4 _data_l_146[_data_n_146] = {
    255,
    1440,
    1766,
    2253
  };
#define _data_n_147 4
  static int_4 _data_l_147[_data_n_147] = {
    2008,
    752,
    3572,
    305
  };
#define _data_n_148 4
  static int_4 _data_l_148[_data_n_148] = {
    1253,
    2859,
    2893,
    3301
  };
#define _data_n_149 4
  static int_4 _data_l_149[_data_n_149] = {
    3344,
    123,
    307,
    1065
  };
#define _data_n_150 4
  static int_4 _data_l_150[_data_n_150] = {
    4084,
    1848,
    1297,
    3133
  };
#define _data_n_151 4
  static int_4 _data_l_151[_data_n_151] = {
    1739,
    643,
    3966,
    2913
  };
#define _data_n_152 4
  static int_4 _data_l_152[_data_n_152] = {
    3143,
    2405,
    758,
    3285
  };
#define _data_n_153 4
  static int_4 _data_l_153[_data_n_153] = {
    3468,
    2638,
    2598,
    1241
  };
#define _data_n_154 4
  static int_4 _data_l_154[_data_n_154] = {
    688,
    2344,
    3406,
    1197
  };
#define _data_n_155 4
  static int_4 _data_l_155[_data_n_155] = {
    1657,
    46,
    2922,
    3729
  };
#define _data_n_156 4
  static int_4 _data_l_156[_data_n_156] = {
    1238,
    3814,
    1038,
    2501
  };
#define _data_n_157 4
  static int_4 _data_l_157[_data_n_157] = {
    3166,
    913,
    2934,
    1673
  };
#define _data_n_158 4
  static int_4 _data_l_158[_data_n_158] = {
    1292,
    3649,
    2091,
    541
  };
#define _data_n_159 4
  static int_4 _data_l_159[_data_n_159] = {
    3422,
    339,
    2451,
    2753
  };
#define _data_n_160 4
  static int_4 _data_l_160[_data_n_160] = {
    1270,
    3808,
    1580,
    949
  };
#define _data_n_161 4
  static int_4 _data_l_161[_data_n_161] = {
    2016,
    822,
    1958,
    2361
  };
#define _data_n_162 4
  static int_4 _data_l_162[_data_n_162] = {
    154,
    2832,
    2055,
    1165
  };
#define _data_n_163 4
  static int_4 _data_l_163[_data_n_163] = {
    2862,
    3078,
    1507,
    4081
  };
#define _data_n_164 4
  static int_4 _data_l_164[_data_n_164] = {
    697,
    3633,
    1078,
    2725
  };
#define _data_n_165 4
  static int_4 _data_l_165[_data_n_165] = {
    1706,
    2970,
    3273,
    3305
  };
#define _data_n_166 4
  static int_4 _data_l_166[_data_n_166] = {
    491,
    637,
    17,
    3069
  };
#define _data_n_167 4
  static int_4 _data_l_167[_data_n_167] = {
    931,
    2249,
    854,
    3617
  };
#define _data_n_168 4
  static int_4 _data_l_168[_data_n_168] = {
    1444,
    2081,
    2916,
    3733
  };
#define _data_n_169 4
  static int_4 _data_l_169[_data_n_169] = {
    444,
    4019,
    3971,
    409
  };
#define _data_n_170 4
  static int_4 _data_l_170[_data_n_170] = {
    3577,
    1478,
    2889,
    2157
  };
#define _data_n_171 4
  static int_4 _data_l_171[_data_n_171] = {
    3944,
    242,
    3831,
    1361
  };
#define _data_n_172 4
  static int_4 _data_l_172[_data_n_172] = {
    2184,
    481,
    2621,
    3973
  };
#define _data_n_173 4
  static int_4 _data_l_173[_data_n_173] = {
    1661,
    2075,
    1541,
    1865
  };
#define _data_n_174 4
  static int_4 _data_l_174[_data_n_174] = {
    3482,
    4058,
    893,
    2525
  };
#define _data_n_175 4
  static int_4 _data_l_175[_data_n_175] = {
    657,
    622,
    736,
    1409
  };
#define _data_n_176 4
  static int_4 _data_l_176[_data_n_176] = {
    3023,
    3376,
    3992,
    3445
  };
#define _data_n_177 4
  static int_4 _data_l_177[_data_n_177] = {
    3618,
    812,
    787,
    3577
  };
#define _data_n_178 4
  static int_4 _data_l_178[_data_n_178] = {
    1267,
    234,
    2125,
    77
  };
#define _data_n_179 4
  static int_4 _data_l_179[_data_n_179] = {
    1828,
    641,
    2364,
    3761
  };
#define _data_n_180 4
  static int_4 _data_l_180[_data_n_180] = {
    164,
    4005,
    2460,
    2149
  };
#define _data_n_181 4
  static int_4 _data_l_181[_data_n_181] = {
    3798,
    1122,
    257,
    1449
  };
#define _data_n_182 4
  static int_4 _data_l_182[_data_n_182] = {
    3087,
    3135,
    1574,
    3005
  };
#define _data_n_183 4
  static int_4 _data_l_183[_data_n_183] = {
    2400,
    2640,
    3912,
    225
  };
#define _data_n_184 4
  static int_4 _data_l_184[_data_n_184] = {
    2870,
    2302,
    1216,
    85
  };
#define _data_n_185 4
  static int_4 _data_l_185[_data_n_185] = {
    3876,
    40,
    3248,
    3673
  };
#define _data_n_186 4
  static int_4 _data_l_186[_data_n_186] = {
    1905,
    1832,
    3401,
    3117
  };
#define _data_n_187 4
  static int_4 _data_l_187[_data_n_187] = {
    1593,
    2247,
    2124,
    3089
  };
#define _data_n_188 4
  static int_4 _data_l_188[_data_n_188] = {
    1797,
    2034,
    2762,
    1349
  };
#define _data_n_189 4
  static int_4 _data_l_189[_data_n_189] = {
    1234,
    2637,
    149,
    2057
  };
#define _data_n_190 4
  static int_4 _data_l_190[_data_n_190] = {
    3460,
    1287,
    2245,
    413
  };
#define _data_n_191 4
  static int_4 _data_l_191[_data_n_191] = {
    328,
    1691,
    166,
    65
  };
#define _data_n_192 4
  static int_4 _data_l_192[_data_n_192] = {
    2861,
    496,
    466,
    1845
  };
#define _data_n_193 4
  static int_4 _data_l_193[_data_n_193] = {
    1950,
    1597,
    4018,
    697
  };
#define _data_n_194 4
  static int_4 _data_l_194[_data_n_194] = {
    617,
    2394,
    1399,
    3085
  };
#define _data_n_195 4
  static int_4 _data_l_195[_data_n_195] = {
    2070,
    2584,
    190,
    3441
  };
#define _data_n_196 4
  static int_4 _data_l_196[_data_n_196] = {
    3331,
    1843,
    2879,
    1573
  };
#define _data_n_197 4
  static int_4 _data_l_197[_data_n_197] = {
    769,
    336,
    153,
    3689
  };
#define _data_n_198 4
  static int_4 _data_l_198[_data_n_198] = {
    1558,
    1472,
    2320,
    2941
  };
#define _data_n_199 4
  static int_4 _data_l_199[_data_n_199] = {
    2412,
    2407,
    18,
    929
  };
#define _data_n_200 4
  static int_4 _data_l_200[_data_n_200] = {
    2800,
    433,
    712,
    533
  };
#define _data_n_201 4
  static int_4 _data_l_201[_data_n_201] = {
    189,
    2096,
    2159,
    2841
  };
#define _data_n_202 4
  static int_4 _data_l_202[_data_n_202] = {
    287,
    1761,
    2318,
    4077
  };
#define _data_n_203 4
  static int_4 _data_l_203[_data_n_203] = {
    2045,
    2810,
    2091,
    721
  };
#define _data_n_204 4
  static int_4 _data_l_204[_data_n_204] = {
    1227,
    566,
    3443,
    2821
  };
#define _data_n_205 4
  static int_4 _data_l_205[_data_n_205] = {
    2838,
    442,
    1510,
    2249
  };
#define _data_n_206 4
  static int_4 _data_l_206[_data_n_206] = {
    209,
    41,
    449,
    2397
  };
#define _data_n_207 4
  static int_4 _data_l_207[_data_n_207] = {
    2770,
    1238,
    1956,
    2817
  };
#define _data_n_208 4
  static int_4 _data_l_208[_data_n_208] = {
    3654,
    1086,
    2201,
    245
  };
#define _data_n_209 4
  static int_4 _data_l_209[_data_n_209] = {
    3993,
    603,
    3137,
    1913
  };
#define _data_n_210 4
  static int_4 _data_l_210[_data_n_210] = {
    192,
    840,
    3399,
    1997
  };
#define _data_n_211 4
  static int_4 _data_l_211[_data_n_211] = {
    2253,
    3168,
    1321,
    3121
  };
#define _data_n_212 4
  static int_4 _data_l_212[_data_n_212] = {
    3491,
    1499,
    2271,
    997
  };
#define _data_n_213 4
  static int_4 _data_l_213[_data_n_213] = {
    2889,
    1084,
    3667,
    1833
  };
#define _data_n_214 4
  static int_4 _data_l_214[_data_n_214] = {
    2857,
    3438,
    2703,
    2877
  };
#define _data_n_215 4
  static int_4 _data_l_215[_data_n_215] = {
    2094,
    2408,
    629,
    1633
  };
#define _data_n_216 4
  static int_4 _data_l_216[_data_n_216] = {
    1818,
    1589,
    2365,
    981
  };
#define _data_n_217 4
  static int_4 _data_l_217[_data_n_217] = {
    688,
    2391,
    2431,
    2009
  };
#define _data_n_218 4
  static int_4 _data_l_218[_data_n_218] = {
    1407,
    288,
    1113,
    941
  };
#define _data_n_219 4
  static int_4 _data_l_219[_data_n_219] = {
    634,
    26,
    3922,
    2449
  };
#define _data_n_220 4
  static int_4 _data_l_220[_data_n_220] = {
    3231,
    512,
    2554,
    197
  };
#define _data_n_221 4
  static int_4 _data_l_221[_data_n_221] = {
    815,
    1456,
    184,
    2441
  };
#define _data_n_222 4
  static int_4 _data_l_222[_data_n_222] = {
    3524,
    171,
    2099,
    285
  };
#define _data_n_223 4
  static int_4 _data_l_223[_data_n_223] = {
    1914,
    1677,
    3228,
    1473
  };
#define _data_n_224 4
  static int_4 _data_l_224[_data_n_224] = {
    516,
    2657,
    4012,
    2741
  };
#define _data_n_225 4
  static int_4 _data_l_225[_data_n_225] = {
    164,
    2270,
    1921,
    3129
  };
#define _data_n_226 4
  static int_4 _data_l_226[_data_n_226] = {
    303,
    2587,
    3452,
    909
  };
#define _data_n_227 4
  static int_4 _data_l_227[_data_n_227] = {
    2144,
    2961,
    3901,
    2801
  };
#define _data_n_228 4
  static int_4 _data_l_228[_data_n_228] = {
    3480,
    1970,
    572,
    421
  };
#define _data_n_229 4
  static int_4 _data_l_229[_data_n_229] = {
    119,
    1817,
    3309,
    4073
  };
#define _data_n_230 4
  static int_4 _data_l_230[_data_n_230] = {
    3357,
    676,
    3171,
    2813
  };
#define _data_n_231 4
  static int_4 _data_l_231[_data_n_231] = {
    837,
    1410,
    817,
    2337
  };
#define _data_n_232 4
  static int_4 _data_l_232[_data_n_232] = {
    2826,
    3723,
    3039,
    1429
  };
#define _data_n_233 4
  static int_4 _data_l_233[_data_n_233] = {
    2332,
    2803,
    1696,
    1177
  };
#define _data_n_234 4
  static int_4 _data_l_234[_data_n_234] = {
    2089,
    3185,
    1256,
    1901
  };
#define _data_n_235 4
  static int_4 _data_l_235[_data_n_235] = {
    3780,
    184,
    3715,
    81
  };
#define _data_n_236 4
  static int_4 _data_l_236[_data_n_236] = {
    1700,
    663,
    2077,
    1669
  };
#define _data_n_237 4
  static int_4 _data_l_237[_data_n_237] = {
    3712,
    499,
    3019,
    2633
  };
#define _data_n_238 4
  static int_4 _data_l_238[_data_n_238] = {
    150,
    3784,
    1497,
    2269
  };
#define _data_n_239 4
  static int_4 _data_l_239[_data_n_239] = {
    2000,
    1631,
    1101,
    129
  };
#define _data_n_240 4
  static int_4 _data_l_240[_data_n_240] = {
    3375,
    1925,
    717,
    1141
  };
#define _data_n_241 4
  static int_4 _data_l_241[_data_n_241] = {
    1621,
    3912,
    51,
    249
  };
#define _data_n_242 4
  static int_4 _data_l_242[_data_n_242] = {
    3090,
    1398,
    981,
    3917
  };
#define _data_n_243 4
  static int_4 _data_l_243[_data_n_243] = {
    3765,
    1349,
    1978,
    2481
  };
#define _data_n_244 4
  static int_4 _data_l_244[_data_n_244] = {
    1149,
    1441,
    1813,
    3941
  };
#define _data_n_245 4
  static int_4 _data_l_245[_data_n_245] = {
    3146,
    2224,
    3881,
    2217
  };
#define _data_n_246 4
  static int_4 _data_l_246[_data_n_246] = {
    33,
    2411,
    76,
    2749
  };
#define _data_n_247 4
  static int_4 _data_l_247[_data_n_247] = {
    3082,
    1907,
    3846,
    3041
  };
#define _data_n_248 4
  static int_4 _data_l_248[_data_n_248] = {
    2741,
    3192,
    3694,
    1877
  };
#define _data_n_249 4
  static int_4 _data_l_249[_data_n_249] = {
    359,
    2786,
    1682,
    345
  };
#define _data_n_250 4
  static int_4 _data_l_250[_data_n_250] = {
    3316,
    382,
    124,
    2861
  };
#define _data_n_251 4
  static int_4 _data_l_251[_data_n_251] = {
    1749,
    37,
    1660,
    1809
  };
#define _data_n_252 4
  static int_4 _data_l_252[_data_n_252] = {
    185,
    759,
    3997,
    3141
  };
#define _data_n_253 4
  static int_4 _data_l_253[_data_n_253] = {
    2784,
    2948,
    479,
    2825
  };
#define _data_n_254 4
  static int_4 _data_l_254[_data_n_254] = {
    2202,
    1862,
    1141,
    157
  };
#define _data_n_255 4
  static int_4 _data_l_255[_data_n_255] = {
    2199,
    3802,
    886,
    2881
  };
#define _data_n_256 4
  static int_4 _data_l_256[_data_n_256] = {
    1364,
    2423,
    3514,
    3637
  };
#define _data_n_257 4
  static int_4 _data_l_257[_data_n_257] = {
    1244,
    2051,
    1301,
    1465
  };
#define _data_n_258 4
  static int_4 _data_l_258[_data_n_258] = {
    2020,
    2295,
    3604,
    2829
  };
#define _data_n_259 4
  static int_4 _data_l_259[_data_n_259] = {
    3160,
    1332,
    1888,
    2161
  };
#define _data_n_260 4
  static int_4 _data_l_260[_data_n_260] = {
    2785,
    1832,
    1836,
    3365
  };
#define _data_n_261 4
  static int_4 _data_l_261[_data_n_261] = {
    2772,
    2405,
    1990,
    361
  };
#define _data_n_262 4
  static int_4 _data_l_262[_data_n_262] = {
    1217,
    3638,
    2058,
    2685
  };
#define _data_n_263 4
  static int_4 _data_l_263[_data_n_263] = {
    1822,
    3661,
    692,
    3745
  };
#define _data_n_264 4
  static int_4 _data_l_264[_data_n_264] = {
    1245,
    327,
    1194,
    2325
  };
#define _data_n_265 4
  static int_4 _data_l_265[_data_n_265] = {
    2252,
    3660,
    20,
    3609
  };
#define _data_n_266 4
  static int_4 _data_l_266[_data_n_266] = {
    3904,
    716,
    3285,
    3821
  };
#define _data_n_267 4
  static int_4 _data_l_267[_data_n_267] = {
    2774,
    1842,
    2046,
    3537
  };
#define _data_n_268 4
  static int_4 _data_l_268[_data_n_268] = {
    997,
    3987,
    2107,
    517
  };
#define _data_n_269 4
  static int_4 _data_l_269[_data_n_269] = {
    2573,
    1368,
    3508,
    3017
  };
#define _data_n_270 4
  static int_4 _data_l_270[_data_n_270] = {
    1148,
    1848,
    3525,
    2141
  };
#define _data_n_271 4
  static int_4 _data_l_271[_data_n_271] = {
    545,
    2366,
    3801,
    1537
  };
  if (__calls[99].calls == 0) {
    _data_k_144 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_144 >= _data_n_144) {
        _data_k_144 = 0;
      }
      mm_[0 + (128) * ((j_ - 1))] = _data_l_144[_data_k_144++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_145 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_145 >= _data_n_145) {
        _data_k_145 = 0;
      }
      mm_[1 + (128) * ((j_ - 1))] = _data_l_145[_data_k_145++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_146 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_146 >= _data_n_146) {
        _data_k_146 = 0;
      }
      mm_[2 + (128) * ((j_ - 1))] = _data_l_146[_data_k_146++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_147 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_147 >= _data_n_147) {
        _data_k_147 = 0;
      }
      mm_[3 + (128) * ((j_ - 1))] = _data_l_147[_data_k_147++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_148 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_148 >= _data_n_148) {
        _data_k_148 = 0;
      }
      mm_[4 + (128) * ((j_ - 1))] = _data_l_148[_data_k_148++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_149 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_149 >= _data_n_149) {
        _data_k_149 = 0;
      }
      mm_[5 + (128) * ((j_ - 1))] = _data_l_149[_data_k_149++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_150 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_150 >= _data_n_150) {
        _data_k_150 = 0;
      }
      mm_[6 + (128) * ((j_ - 1))] = _data_l_150[_data_k_150++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_151 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_151 >= _data_n_151) {
        _data_k_151 = 0;
      }
      mm_[7 + (128) * ((j_ - 1))] = _data_l_151[_data_k_151++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_152 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_152 >= _data_n_152) {
        _data_k_152 = 0;
      }
      mm_[8 + (128) * ((j_ - 1))] = _data_l_152[_data_k_152++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_153 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_153 >= _data_n_153) {
        _data_k_153 = 0;
      }
      mm_[9 + (128) * ((j_ - 1))] = _data_l_153[_data_k_153++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_154 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_154 >= _data_n_154) {
        _data_k_154 = 0;
      }
      mm_[10 + (128) * ((j_ - 1))] = _data_l_154[_data_k_154++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_155 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_155 >= _data_n_155) {
        _data_k_155 = 0;
      }
      mm_[11 + (128) * ((j_ - 1))] = _data_l_155[_data_k_155++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_156 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_156 >= _data_n_156) {
        _data_k_156 = 0;
      }
      mm_[12 + (128) * ((j_ - 1))] = _data_l_156[_data_k_156++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_157 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_157 >= _data_n_157) {
        _data_k_157 = 0;
      }
      mm_[13 + (128) * ((j_ - 1))] = _data_l_157[_data_k_157++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_158 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_158 >= _data_n_158) {
        _data_k_158 = 0;
      }
      mm_[14 + (128) * ((j_ - 1))] = _data_l_158[_data_k_158++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_159 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_159 >= _data_n_159) {
        _data_k_159 = 0;
      }
      mm_[15 + (128) * ((j_ - 1))] = _data_l_159[_data_k_159++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_160 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_160 >= _data_n_160) {
        _data_k_160 = 0;
      }
      mm_[16 + (128) * ((j_ - 1))] = _data_l_160[_data_k_160++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_161 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_161 >= _data_n_161) {
        _data_k_161 = 0;
      }
      mm_[17 + (128) * ((j_ - 1))] = _data_l_161[_data_k_161++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_162 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_162 >= _data_n_162) {
        _data_k_162 = 0;
      }
      mm_[18 + (128) * ((j_ - 1))] = _data_l_162[_data_k_162++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_163 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_163 >= _data_n_163) {
        _data_k_163 = 0;
      }
      mm_[19 + (128) * ((j_ - 1))] = _data_l_163[_data_k_163++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_164 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_164 >= _data_n_164) {
        _data_k_164 = 0;
      }
      mm_[20 + (128) * ((j_ - 1))] = _data_l_164[_data_k_164++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_165 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_165 >= _data_n_165) {
        _data_k_165 = 0;
      }
      mm_[21 + (128) * ((j_ - 1))] = _data_l_165[_data_k_165++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_166 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_166 >= _data_n_166) {
        _data_k_166 = 0;
      }
      mm_[22 + (128) * ((j_ - 1))] = _data_l_166[_data_k_166++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_167 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_167 >= _data_n_167) {
        _data_k_167 = 0;
      }
      mm_[23 + (128) * ((j_ - 1))] = _data_l_167[_data_k_167++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_168 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_168 >= _data_n_168) {
        _data_k_168 = 0;
      }
      mm_[24 + (128) * ((j_ - 1))] = _data_l_168[_data_k_168++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_169 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_169 >= _data_n_169) {
        _data_k_169 = 0;
      }
      mm_[25 + (128) * ((j_ - 1))] = _data_l_169[_data_k_169++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_170 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_170 >= _data_n_170) {
        _data_k_170 = 0;
      }
      mm_[26 + (128) * ((j_ - 1))] = _data_l_170[_data_k_170++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_171 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_171 >= _data_n_171) {
        _data_k_171 = 0;
      }
      mm_[27 + (128) * ((j_ - 1))] = _data_l_171[_data_k_171++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_172 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_172 >= _data_n_172) {
        _data_k_172 = 0;
      }
      mm_[28 + (128) * ((j_ - 1))] = _data_l_172[_data_k_172++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_173 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_173 >= _data_n_173) {
        _data_k_173 = 0;
      }
      mm_[29 + (128) * ((j_ - 1))] = _data_l_173[_data_k_173++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_174 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_174 >= _data_n_174) {
        _data_k_174 = 0;
      }
      mm_[30 + (128) * ((j_ - 1))] = _data_l_174[_data_k_174++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_175 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_175 >= _data_n_175) {
        _data_k_175 = 0;
      }
      mm_[31 + (128) * ((j_ - 1))] = _data_l_175[_data_k_175++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_176 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_176 >= _data_n_176) {
        _data_k_176 = 0;
      }
      mm_[32 + (128) * ((j_ - 1))] = _data_l_176[_data_k_176++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_177 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_177 >= _data_n_177) {
        _data_k_177 = 0;
      }
      mm_[33 + (128) * ((j_ - 1))] = _data_l_177[_data_k_177++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_178 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_178 >= _data_n_178) {
        _data_k_178 = 0;
      }
      mm_[34 + (128) * ((j_ - 1))] = _data_l_178[_data_k_178++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_179 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_179 >= _data_n_179) {
        _data_k_179 = 0;
      }
      mm_[35 + (128) * ((j_ - 1))] = _data_l_179[_data_k_179++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_180 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_180 >= _data_n_180) {
        _data_k_180 = 0;
      }
      mm_[36 + (128) * ((j_ - 1))] = _data_l_180[_data_k_180++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_181 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_181 >= _data_n_181) {
        _data_k_181 = 0;
      }
      mm_[37 + (128) * ((j_ - 1))] = _data_l_181[_data_k_181++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_182 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_182 >= _data_n_182) {
        _data_k_182 = 0;
      }
      mm_[38 + (128) * ((j_ - 1))] = _data_l_182[_data_k_182++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_183 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_183 >= _data_n_183) {
        _data_k_183 = 0;
      }
      mm_[39 + (128) * ((j_ - 1))] = _data_l_183[_data_k_183++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_184 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_184 >= _data_n_184) {
        _data_k_184 = 0;
      }
      mm_[40 + (128) * ((j_ - 1))] = _data_l_184[_data_k_184++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_185 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_185 >= _data_n_185) {
        _data_k_185 = 0;
      }
      mm_[41 + (128) * ((j_ - 1))] = _data_l_185[_data_k_185++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_186 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_186 >= _data_n_186) {
        _data_k_186 = 0;
      }
      mm_[42 + (128) * ((j_ - 1))] = _data_l_186[_data_k_186++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_187 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_187 >= _data_n_187) {
        _data_k_187 = 0;
      }
      mm_[43 + (128) * ((j_ - 1))] = _data_l_187[_data_k_187++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_188 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_188 >= _data_n_188) {
        _data_k_188 = 0;
      }
      mm_[44 + (128) * ((j_ - 1))] = _data_l_188[_data_k_188++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_189 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_189 >= _data_n_189) {
        _data_k_189 = 0;
      }
      mm_[45 + (128) * ((j_ - 1))] = _data_l_189[_data_k_189++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_190 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_190 >= _data_n_190) {
        _data_k_190 = 0;
      }
      mm_[46 + (128) * ((j_ - 1))] = _data_l_190[_data_k_190++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_191 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_191 >= _data_n_191) {
        _data_k_191 = 0;
      }
      mm_[47 + (128) * ((j_ - 1))] = _data_l_191[_data_k_191++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_192 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_192 >= _data_n_192) {
        _data_k_192 = 0;
      }
      mm_[48 + (128) * ((j_ - 1))] = _data_l_192[_data_k_192++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_193 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_193 >= _data_n_193) {
        _data_k_193 = 0;
      }
      mm_[49 + (128) * ((j_ - 1))] = _data_l_193[_data_k_193++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_194 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_194 >= _data_n_194) {
        _data_k_194 = 0;
      }
      mm_[50 + (128) * ((j_ - 1))] = _data_l_194[_data_k_194++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_195 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_195 >= _data_n_195) {
        _data_k_195 = 0;
      }
      mm_[51 + (128) * ((j_ - 1))] = _data_l_195[_data_k_195++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_196 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_196 >= _data_n_196) {
        _data_k_196 = 0;
      }
      mm_[52 + (128) * ((j_ - 1))] = _data_l_196[_data_k_196++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_197 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_197 >= _data_n_197) {
        _data_k_197 = 0;
      }
      mm_[53 + (128) * ((j_ - 1))] = _data_l_197[_data_k_197++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_198 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_198 >= _data_n_198) {
        _data_k_198 = 0;
      }
      mm_[54 + (128) * ((j_ - 1))] = _data_l_198[_data_k_198++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_199 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_199 >= _data_n_199) {
        _data_k_199 = 0;
      }
      mm_[55 + (128) * ((j_ - 1))] = _data_l_199[_data_k_199++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_200 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_200 >= _data_n_200) {
        _data_k_200 = 0;
      }
      mm_[56 + (128) * ((j_ - 1))] = _data_l_200[_data_k_200++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_201 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_201 >= _data_n_201) {
        _data_k_201 = 0;
      }
      mm_[57 + (128) * ((j_ - 1))] = _data_l_201[_data_k_201++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_202 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_202 >= _data_n_202) {
        _data_k_202 = 0;
      }
      mm_[58 + (128) * ((j_ - 1))] = _data_l_202[_data_k_202++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_203 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_203 >= _data_n_203) {
        _data_k_203 = 0;
      }
      mm_[59 + (128) * ((j_ - 1))] = _data_l_203[_data_k_203++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_204 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_204 >= _data_n_204) {
        _data_k_204 = 0;
      }
      mm_[60 + (128) * ((j_ - 1))] = _data_l_204[_data_k_204++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_205 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_205 >= _data_n_205) {
        _data_k_205 = 0;
      }
      mm_[61 + (128) * ((j_ - 1))] = _data_l_205[_data_k_205++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_206 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_206 >= _data_n_206) {
        _data_k_206 = 0;
      }
      mm_[62 + (128) * ((j_ - 1))] = _data_l_206[_data_k_206++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_207 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_207 >= _data_n_207) {
        _data_k_207 = 0;
      }
      mm_[63 + (128) * ((j_ - 1))] = _data_l_207[_data_k_207++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_208 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_208 >= _data_n_208) {
        _data_k_208 = 0;
      }
      mm_[64 + (128) * ((j_ - 1))] = _data_l_208[_data_k_208++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_209 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_209 >= _data_n_209) {
        _data_k_209 = 0;
      }
      mm_[65 + (128) * ((j_ - 1))] = _data_l_209[_data_k_209++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_210 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_210 >= _data_n_210) {
        _data_k_210 = 0;
      }
      mm_[66 + (128) * ((j_ - 1))] = _data_l_210[_data_k_210++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_211 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_211 >= _data_n_211) {
        _data_k_211 = 0;
      }
      mm_[67 + (128) * ((j_ - 1))] = _data_l_211[_data_k_211++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_212 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_212 >= _data_n_212) {
        _data_k_212 = 0;
      }
      mm_[68 + (128) * ((j_ - 1))] = _data_l_212[_data_k_212++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_213 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_213 >= _data_n_213) {
        _data_k_213 = 0;
      }
      mm_[69 + (128) * ((j_ - 1))] = _data_l_213[_data_k_213++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_214 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_214 >= _data_n_214) {
        _data_k_214 = 0;
      }
      mm_[70 + (128) * ((j_ - 1))] = _data_l_214[_data_k_214++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_215 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_215 >= _data_n_215) {
        _data_k_215 = 0;
      }
      mm_[71 + (128) * ((j_ - 1))] = _data_l_215[_data_k_215++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_216 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_216 >= _data_n_216) {
        _data_k_216 = 0;
      }
      mm_[72 + (128) * ((j_ - 1))] = _data_l_216[_data_k_216++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_217 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_217 >= _data_n_217) {
        _data_k_217 = 0;
      }
      mm_[73 + (128) * ((j_ - 1))] = _data_l_217[_data_k_217++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_218 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_218 >= _data_n_218) {
        _data_k_218 = 0;
      }
      mm_[74 + (128) * ((j_ - 1))] = _data_l_218[_data_k_218++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_219 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_219 >= _data_n_219) {
        _data_k_219 = 0;
      }
      mm_[75 + (128) * ((j_ - 1))] = _data_l_219[_data_k_219++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_220 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_220 >= _data_n_220) {
        _data_k_220 = 0;
      }
      mm_[76 + (128) * ((j_ - 1))] = _data_l_220[_data_k_220++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_221 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_221 >= _data_n_221) {
        _data_k_221 = 0;
      }
      mm_[77 + (128) * ((j_ - 1))] = _data_l_221[_data_k_221++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_222 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_222 >= _data_n_222) {
        _data_k_222 = 0;
      }
      mm_[78 + (128) * ((j_ - 1))] = _data_l_222[_data_k_222++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_223 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_223 >= _data_n_223) {
        _data_k_223 = 0;
      }
      mm_[79 + (128) * ((j_ - 1))] = _data_l_223[_data_k_223++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_224 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_224 >= _data_n_224) {
        _data_k_224 = 0;
      }
      mm_[80 + (128) * ((j_ - 1))] = _data_l_224[_data_k_224++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_225 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_225 >= _data_n_225) {
        _data_k_225 = 0;
      }
      mm_[81 + (128) * ((j_ - 1))] = _data_l_225[_data_k_225++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_226 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_226 >= _data_n_226) {
        _data_k_226 = 0;
      }
      mm_[82 + (128) * ((j_ - 1))] = _data_l_226[_data_k_226++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_227 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_227 >= _data_n_227) {
        _data_k_227 = 0;
      }
      mm_[83 + (128) * ((j_ - 1))] = _data_l_227[_data_k_227++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_228 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_228 >= _data_n_228) {
        _data_k_228 = 0;
      }
      mm_[84 + (128) * ((j_ - 1))] = _data_l_228[_data_k_228++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_229 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_229 >= _data_n_229) {
        _data_k_229 = 0;
      }
      mm_[85 + (128) * ((j_ - 1))] = _data_l_229[_data_k_229++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_230 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_230 >= _data_n_230) {
        _data_k_230 = 0;
      }
      mm_[86 + (128) * ((j_ - 1))] = _data_l_230[_data_k_230++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_231 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_231 >= _data_n_231) {
        _data_k_231 = 0;
      }
      mm_[87 + (128) * ((j_ - 1))] = _data_l_231[_data_k_231++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_232 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_232 >= _data_n_232) {
        _data_k_232 = 0;
      }
      mm_[88 + (128) * ((j_ - 1))] = _data_l_232[_data_k_232++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_233 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_233 >= _data_n_233) {
        _data_k_233 = 0;
      }
      mm_[89 + (128) * ((j_ - 1))] = _data_l_233[_data_k_233++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_234 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_234 >= _data_n_234) {
        _data_k_234 = 0;
      }
      mm_[90 + (128) * ((j_ - 1))] = _data_l_234[_data_k_234++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_235 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_235 >= _data_n_235) {
        _data_k_235 = 0;
      }
      mm_[91 + (128) * ((j_ - 1))] = _data_l_235[_data_k_235++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_236 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_236 >= _data_n_236) {
        _data_k_236 = 0;
      }
      mm_[92 + (128) * ((j_ - 1))] = _data_l_236[_data_k_236++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_237 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_237 >= _data_n_237) {
        _data_k_237 = 0;
      }
      mm_[93 + (128) * ((j_ - 1))] = _data_l_237[_data_k_237++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_238 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_238 >= _data_n_238) {
        _data_k_238 = 0;
      }
      mm_[94 + (128) * ((j_ - 1))] = _data_l_238[_data_k_238++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_239 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_239 >= _data_n_239) {
        _data_k_239 = 0;
      }
      mm_[95 + (128) * ((j_ - 1))] = _data_l_239[_data_k_239++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_240 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_240 >= _data_n_240) {
        _data_k_240 = 0;
      }
      mm_[96 + (128) * ((j_ - 1))] = _data_l_240[_data_k_240++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_241 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_241 >= _data_n_241) {
        _data_k_241 = 0;
      }
      mm_[97 + (128) * ((j_ - 1))] = _data_l_241[_data_k_241++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_242 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_242 >= _data_n_242) {
        _data_k_242 = 0;
      }
      mm_[98 + (128) * ((j_ - 1))] = _data_l_242[_data_k_242++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_243 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_243 >= _data_n_243) {
        _data_k_243 = 0;
      }
      mm_[99 + (128) * ((j_ - 1))] = _data_l_243[_data_k_243++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_244 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_244 >= _data_n_244) {
        _data_k_244 = 0;
      }
      mm_[100 + (128) * ((j_ - 1))] = _data_l_244[_data_k_244++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_245 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_245 >= _data_n_245) {
        _data_k_245 = 0;
      }
      mm_[101 + (128) * ((j_ - 1))] = _data_l_245[_data_k_245++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_246 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_246 >= _data_n_246) {
        _data_k_246 = 0;
      }
      mm_[102 + (128) * ((j_ - 1))] = _data_l_246[_data_k_246++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_247 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_247 >= _data_n_247) {
        _data_k_247 = 0;
      }
      mm_[103 + (128) * ((j_ - 1))] = _data_l_247[_data_k_247++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_248 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_248 >= _data_n_248) {
        _data_k_248 = 0;
      }
      mm_[104 + (128) * ((j_ - 1))] = _data_l_248[_data_k_248++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_249 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_249 >= _data_n_249) {
        _data_k_249 = 0;
      }
      mm_[105 + (128) * ((j_ - 1))] = _data_l_249[_data_k_249++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_250 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_250 >= _data_n_250) {
        _data_k_250 = 0;
      }
      mm_[106 + (128) * ((j_ - 1))] = _data_l_250[_data_k_250++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_251 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_251 >= _data_n_251) {
        _data_k_251 = 0;
      }
      mm_[107 + (128) * ((j_ - 1))] = _data_l_251[_data_k_251++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_252 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_252 >= _data_n_252) {
        _data_k_252 = 0;
      }
      mm_[108 + (128) * ((j_ - 1))] = _data_l_252[_data_k_252++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_253 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_253 >= _data_n_253) {
        _data_k_253 = 0;
      }
      mm_[109 + (128) * ((j_ - 1))] = _data_l_253[_data_k_253++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_254 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_254 >= _data_n_254) {
        _data_k_254 = 0;
      }
      mm_[110 + (128) * ((j_ - 1))] = _data_l_254[_data_k_254++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_255 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_255 >= _data_n_255) {
        _data_k_255 = 0;
      }
      mm_[111 + (128) * ((j_ - 1))] = _data_l_255[_data_k_255++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_256 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_256 >= _data_n_256) {
        _data_k_256 = 0;
      }
      mm_[112 + (128) * ((j_ - 1))] = _data_l_256[_data_k_256++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_257 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_257 >= _data_n_257) {
        _data_k_257 = 0;
      }
      mm_[113 + (128) * ((j_ - 1))] = _data_l_257[_data_k_257++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_258 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_258 >= _data_n_258) {
        _data_k_258 = 0;
      }
      mm_[114 + (128) * ((j_ - 1))] = _data_l_258[_data_k_258++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_259 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_259 >= _data_n_259) {
        _data_k_259 = 0;
      }
      mm_[115 + (128) * ((j_ - 1))] = _data_l_259[_data_k_259++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_260 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_260 >= _data_n_260) {
        _data_k_260 = 0;
      }
      mm_[116 + (128) * ((j_ - 1))] = _data_l_260[_data_k_260++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_261 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_261 >= _data_n_261) {
        _data_k_261 = 0;
      }
      mm_[117 + (128) * ((j_ - 1))] = _data_l_261[_data_k_261++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_262 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_262 >= _data_n_262) {
        _data_k_262 = 0;
      }
      mm_[118 + (128) * ((j_ - 1))] = _data_l_262[_data_k_262++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_263 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_263 >= _data_n_263) {
        _data_k_263 = 0;
      }
      mm_[119 + (128) * ((j_ - 1))] = _data_l_263[_data_k_263++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_264 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_264 >= _data_n_264) {
        _data_k_264 = 0;
      }
      mm_[120 + (128) * ((j_ - 1))] = _data_l_264[_data_k_264++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_265 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_265 >= _data_n_265) {
        _data_k_265 = 0;
      }
      mm_[121 + (128) * ((j_ - 1))] = _data_l_265[_data_k_265++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_266 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_266 >= _data_n_266) {
        _data_k_266 = 0;
      }
      mm_[122 + (128) * ((j_ - 1))] = _data_l_266[_data_k_266++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_267 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_267 >= _data_n_267) {
        _data_k_267 = 0;
      }
      mm_[123 + (128) * ((j_ - 1))] = _data_l_267[_data_k_267++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_268 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_268 >= _data_n_268) {
        _data_k_268 = 0;
      }
      mm_[124 + (128) * ((j_ - 1))] = _data_l_268[_data_k_268++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_269 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_269 >= _data_n_269) {
        _data_k_269 = 0;
      }
      mm_[125 + (128) * ((j_ - 1))] = _data_l_269[_data_k_269++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_270 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_270 >= _data_n_270) {
        _data_k_270 = 0;
      }
      mm_[126 + (128) * ((j_ - 1))] = _data_l_270[_data_k_270++];
    }; // implied DO 
  }
  if (__calls[99].calls == 0) {
    _data_k_271 = 0;
    for (j_ = 1; j_ <= 4; j_++) {
      if (_data_k_271 >= _data_n_271) {
        _data_k_271 = 0;
      }
      mm_[127 + (128) * ((j_ - 1))] = _data_l_271[_data_k_271++];
    }; // implied DO 
  }
  i1_ = iseed_[0];
  i2_ = iseed_[1];
  i3_ = iseed_[2];
  i4_ = iseed_[3];
  for (i_ = 1; i_ <= _min ((*n_), 128); (i_)++) {
    it4_ = i4_ * mm_[i_ - 1 + 384];
    it3_ = it4_ / 4096;
    it4_ = it4_ - 4096 * it3_;
    it3_ = it3_ + i3_ * mm_[i_ - 1 + 384] + i4_ * mm_[i_ - 1 + 256];
    it2_ = it3_ / 4096;
    it3_ = it3_ - 4096 * it2_;
    it2_ = it2_ + i2_ * mm_[i_ - 1 + 384] + i3_ * mm_[i_ - 1 + 256] + i4_ * mm_[i_ - 1 + 128];
    it1_ = it2_ / 4096;
    it2_ = it2_ - 4096 * it1_;
    it1_ = it1_ + i1_ * mm_[i_ - 1 + 384] + i2_ * mm_[i_ - 1 + 256] + i3_ * mm_[i_ - 1 + 128] + i4_ * mm_[i_ - 1];
    it1_ = _imod (it1_, 4096);
    x_[i_ - 1] = 2.4414063e-4 * ((real_4) (it1_) + 2.4414063e-4 * ((real_4) (it2_) + 2.4414063e-4 * ((real_4) (it3_) + 
    2.4414063e-4 * (real_4) (it4_))));
  }
  iseed_[0] = it1_;
  iseed_[1] = it2_;
  iseed_[2] = it3_;
  iseed_[3] = it4_;
  __calls[99].calls++;
  return 0;
}

int_4 _slascl (char _p_ type_, int_4 _p_ kl_, int_4 _p_ ku_, real_4 _p_ cfrom_, real_4 _p_ cto_, int_4 _p_ m_, int_4 
_p_ n_, real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ info_)
{
  static int_4 i_, itype_, j_, k1_, k2_, k3_, k4_;
  static logical_4 done_;
  static real_4 bignum_, cfrom1_, cfromc_, cto1_, ctoc_, mul_, smlnum_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if (_lsame (type_, _dc_29)) {
    itype_ = 0;
  }
  else if (_lsame (type_, _dc_20)) {
    itype_ = 1;
  }
  else if (_lsame (type_, _dc_19)) {
    itype_ = 2;
  }
  else if (_lsame (type_, _dc_30)) {
    itype_ = 3;
  }
  else if (_lsame (type_, _dc_31)) {
    itype_ = 4;
  }
  else if (_lsame (type_, _dc_32)) {
    itype_ = 5;
  }
  else if (_lsame (type_, _dc_33)) {
    itype_ = 6;
  }
  else {
    itype_ = -1;
  }
  if (itype_ == -1) {
    (*info_) = -1;
  }
  else if ((*cfrom_) == 0.0) {
    (*info_) = -4;
  }
  else if ((*m_) < 0) {
    (*info_) = -6;
  }
  else if ((*n_) < 0 || (itype_ == 4 && (*n_) != (*m_)) || (itype_ == 5 && (*n_) != (*m_))) {
    (*info_) = -7;
  }
  else if (itype_ <= 3 && (*lda_) < _max (1, (*m_))) {
    (*info_) = -9;
  }
  else if (itype_ >= 4) {
    if ((*kl_) < 0 || (*kl_) > _max ((*m_) - 1, 0)) {
      (*info_) = -2;
    }
    else if ((*ku_) < 0 || (*ku_) > _max ((*n_) - 1, 0) || ((itype_ == 4 || itype_ == 5) && (*kl_) != (*ku_))) {
      (*info_) = -3;
    }
    else if ((itype_ == 4 && (*lda_) < (*kl_) + 1) || (itype_ == 5 && (*lda_) < (*ku_) + 1) || (itype_ == 6 && (*lda_) < 2 
      * (*kl_) + (*ku_) + 1)) {
      (*info_) = -9;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_73, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  smlnum_ = _slamch (_dc_28);
  bignum_ = 1.0 / smlnum_;
  cfromc_ = (*cfrom_);
  ctoc_ = (*cto_);
  _l10:;
  cfrom1_ = cfromc_ * smlnum_;
  cto1_ = ctoc_ / bignum_;
  if (_abs (cfrom1_) > _abs (ctoc_) && ctoc_ != 0.0) {
    mul_ = smlnum_;
    done_ = FALSE;
    cfromc_ = cfrom1_;
  }
  else if (_abs (cto1_) > _abs (cfromc_)) {
    mul_ = bignum_;
    done_ = FALSE;
    ctoc_ = cto1_;
  }
  else {
    mul_ = ctoc_ / cfromc_;
    done_ = TRUE;
  }
  if (itype_ == 0) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 2) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 3) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_ + 1, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 4) {
    k3_ = (*kl_) + 1;
    k4_ = (*n_) + 1;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (k3_, k4_ - j_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 5) {
    k1_ = (*ku_) + 2;
    k3_ = (*ku_) + 1;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = _max (k1_ - j_, 1); i_ <= k3_; (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 6) {
    k1_ = (*kl_) + (*ku_) + 2;
    k2_ = (*kl_) + 1;
    k3_ = 2 * (*kl_) + (*ku_) + 1;
    k4_ = (*kl_) + (*ku_) + 1 + (*m_);
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = _max (k1_ - j_, k2_); i_ <= _min (k3_, k4_ - j_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  if (! (done_)) {
    goto _l10;
  }
  _l0:;
  __calls[100].calls++;
  return 0;
}

int_4 _slaset (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ a_, int_4 
_p_ lda_)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if (_lsame (uplo_, _dc_19)) {
    for (j_ = 2; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_ - 1, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
  }
  else if (_lsame (uplo_, _dc_20)) {
    for (j_ = 1; j_ <= _min ((*m_), (*n_)); (j_)++) {
      for (i_ = j_ + 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
  }
  for (i_ = 1; i_ <= _min ((*m_), (*n_)); (i_)++) {
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = (*beta_);
  }
  __calls[101].calls++;
  return 0;
}

int_4 _slasr (char _p_ side_, char _p_ pivot_, char _p_ direct_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ c_, real_4 _p_ 
s_, real_4 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, j_;
  static real_4 ctemp_, stemp_, temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! ((_lsame (side_, _dc_20) || _lsame (side_, _dc_37)))) {
    info_ = 1;
  }
  else if (! ((_lsame (pivot_, _dc_40) || _lsame (pivot_, _dc_8) || _lsame (pivot_, _dc_31)))) {
    info_ = 2;
  }
  else if (! ((_lsame (direct_, _dc_26) || _lsame (direct_, _dc_31)))) {
    info_ = 3;
  }
  else if ((*m_) < 0) {
    info_ = 4;
  }
  else if ((*n_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_74, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0)) {
    goto _l0;
  }
  if (_lsame (side_, _dc_20)) {
    if (_lsame (pivot_, _dc_40)) {
      if (_lsame (direct_, _dc_26)) {
        for (j_ = 1; j_ <= (*m_) - 1; (j_)++) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ + 1 - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ + 1 - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * temp_ - stemp_ * a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = stemp_ * temp_ + ctemp_ * a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_31)) {
        for (j_ = (*m_) - 1; j_ >= 1; (j_)--) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ + 1 - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ + 1 - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * temp_ - stemp_ * a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = stemp_ * temp_ + ctemp_ * a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
          }
        }
      }
    }
    else if (_lsame (pivot_, _dc_8)) {
      if (_lsame (direct_, _dc_26)) {
        for (j_ = 2; j_ <= (*m_); (j_)++) {
          ctemp_ = c_[j_ - 1 - 1];
          stemp_ = s_[j_ - 1 - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * temp_ - stemp_ * a_[0 + ((*lda_)) * ((i_ - 1))];
              a_[0 + ((*lda_)) * ((i_ - 1))] = stemp_ * temp_ + ctemp_ * a_[0 + ((*lda_)) * ((i_ - 1))];
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_31)) {
        for (j_ = (*m_); j_ >= 2; (j_)--) {
          ctemp_ = c_[j_ - 1 - 1];
          stemp_ = s_[j_ - 1 - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * temp_ - stemp_ * a_[0 + ((*lda_)) * ((i_ - 1))];
              a_[0 + ((*lda_)) * ((i_ - 1))] = stemp_ * temp_ + ctemp_ * a_[0 + ((*lda_)) * ((i_ - 1))];
            }
          }
        }
      }
    }
    else if (_lsame (pivot_, _dc_31)) {
      if (_lsame (direct_, _dc_26)) {
        for (j_ = 1; j_ <= (*m_) - 1; (j_)++) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = stemp_ * a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] + ctemp_ * temp_;
              a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] - stemp_ * temp_;
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_31)) {
        for (j_ = (*m_) - 1; j_ >= 1; (j_)--) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = stemp_ * a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] + ctemp_ * temp_;
              a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] - stemp_ * temp_;
            }
          }
        }
      }
    }
  }
  else if (_lsame (side_, _dc_37)) {
    if (_lsame (pivot_, _dc_40)) {
      if (_lsame (direct_, _dc_26)) {
        for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ + 1 - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ + 1 - 1))] = ctemp_ * temp_ - stemp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = stemp_ * temp_ + ctemp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_31)) {
        for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ + 1 - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ + 1 - 1))] = ctemp_ * temp_ - stemp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = stemp_ * temp_ + ctemp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
    }
    else if (_lsame (pivot_, _dc_8)) {
      if (_lsame (direct_, _dc_26)) {
        for (j_ = 2; j_ <= (*n_); (j_)++) {
          ctemp_ = c_[j_ - 1 - 1];
          stemp_ = s_[j_ - 1 - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = ctemp_ * temp_ - stemp_ * a_[i_ - 1 + ((*lda_)) * ((0))];
              a_[i_ - 1 + ((*lda_)) * ((0))] = stemp_ * temp_ + ctemp_ * a_[i_ - 1 + ((*lda_)) * ((0))];
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_31)) {
        for (j_ = (*n_); j_ >= 2; (j_)--) {
          ctemp_ = c_[j_ - 1 - 1];
          stemp_ = s_[j_ - 1 - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = ctemp_ * temp_ - stemp_ * a_[i_ - 1 + ((*lda_)) * ((0))];
              a_[i_ - 1 + ((*lda_)) * ((0))] = stemp_ * temp_ + ctemp_ * a_[i_ - 1 + ((*lda_)) * ((0))];
            }
          }
        }
      }
    }
    else if (_lsame (pivot_, _dc_31)) {
      if (_lsame (direct_, _dc_26)) {
        for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = stemp_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] + ctemp_ * temp_;
              a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] = ctemp_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] - stemp_ * temp_;
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_31)) {
        for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = stemp_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] + ctemp_ * temp_;
              a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] = ctemp_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] - stemp_ * temp_;
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[102].calls++;
  return 0;
}

int_4 _slasrt (char _p_ id_, int_4 _p_ n_, real_4 _p_ d_, int_4 _p_ info_)
{
  static int_4 dir_, endd_, i_, j_, start_, stkpnt_, stack_[64];
  static real_4 d1_, d2_, d3_, dmnmx_, tmp_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  dir_ = -1;
  if (_lsame (id_, _dc_75)) {
    dir_ = 0;
  }
  else if (_lsame (id_, _dc_25)) {
    dir_ = 1;
  }
  if (dir_ == -1) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_76, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) <= 1) {
    goto _l0;
  }
  stkpnt_ = 1;
  stack_[0] = 1;
  stack_[1] = (*n_);
  _l10:;
  start_ = stack_[0 + (2) * ((stkpnt_ - 1))];
  endd_ = stack_[1 + (2) * ((stkpnt_ - 1))];
  stkpnt_ = stkpnt_ - 1;
  if (endd_ - start_ <= 20 && endd_ - start_ > 0) {
    if (dir_ == 0) {
      for (i_ = start_ + 1; i_ <= endd_; (i_)++) {
        for (j_ = i_; j_ >= start_ + 1; (j_)--) {
          if (d_[j_ - 1] > d_[j_ - 1 - 1]) {
            dmnmx_ = d_[j_ - 1];
            d_[j_ - 1] = d_[j_ - 1 - 1];
            d_[j_ - 1 - 1] = dmnmx_;
          }
          else {
            goto _l30;
          }
        }
        _l30:;
      }
    }
    else {
      for (i_ = start_ + 1; i_ <= endd_; (i_)++) {
        for (j_ = i_; j_ >= start_ + 1; (j_)--) {
          if (d_[j_ - 1] < d_[j_ - 1 - 1]) {
            dmnmx_ = d_[j_ - 1];
            d_[j_ - 1] = d_[j_ - 1 - 1];
            d_[j_ - 1 - 1] = dmnmx_;
          }
          else {
            goto _l50;
          }
        }
        _l50:;
      }
    }
  }
  else if (endd_ - start_ > 20) {
    d1_ = d_[start_ - 1];
    d2_ = d_[endd_ - 1];
    i_ = (start_ + endd_) / 2;
    d3_ = d_[i_ - 1];
    if (d1_ < d2_) {
      if (d3_ < d1_) {
        dmnmx_ = d1_;
      }
      else if (d3_ < d2_) {
        dmnmx_ = d3_;
      }
      else {
        dmnmx_ = d2_;
      }
    }
    else {
      if (d3_ < d2_) {
        dmnmx_ = d2_;
      }
      else if (d3_ < d1_) {
        dmnmx_ = d3_;
      }
      else {
        dmnmx_ = d1_;
      }
    }
    if (dir_ == 0) {
      i_ = start_ - 1;
      j_ = endd_ + 1;
      _l60:;
      _l70:;
      j_ = j_ - 1;
      if (d_[j_ - 1] < dmnmx_) {
        goto _l70;
      }
      _l80:;
      i_ = i_ + 1;
      if (d_[i_ - 1] > dmnmx_) {
        goto _l80;
      }
      if (i_ < j_) {
        tmp_ = d_[i_ - 1];
        d_[i_ - 1] = d_[j_ - 1];
        d_[j_ - 1] = tmp_;
        goto _l60;
      }
      if (j_ - start_ > endd_ - j_ - 1) {
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = start_;
        stack_[1 + (2) * ((stkpnt_ - 1))] = j_;
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = j_ + 1;
        stack_[1 + (2) * ((stkpnt_ - 1))] = endd_;
      }
      else {
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = j_ + 1;
        stack_[1 + (2) * ((stkpnt_ - 1))] = endd_;
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = start_;
        stack_[1 + (2) * ((stkpnt_ - 1))] = j_;
      }
    }
    else {
      i_ = start_ - 1;
      j_ = endd_ + 1;
      _l90:;
      _l100:;
      j_ = j_ - 1;
      if (d_[j_ - 1] > dmnmx_) {
        goto _l100;
      }
      _l110:;
      i_ = i_ + 1;
      if (d_[i_ - 1] < dmnmx_) {
        goto _l110;
      }
      if (i_ < j_) {
        tmp_ = d_[i_ - 1];
        d_[i_ - 1] = d_[j_ - 1];
        d_[j_ - 1] = tmp_;
        goto _l90;
      }
      if (j_ - start_ > endd_ - j_ - 1) {
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = start_;
        stack_[1 + (2) * ((stkpnt_ - 1))] = j_;
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = j_ + 1;
        stack_[1 + (2) * ((stkpnt_ - 1))] = endd_;
      }
      else {
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = j_ + 1;
        stack_[1 + (2) * ((stkpnt_ - 1))] = endd_;
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = start_;
        stack_[1 + (2) * ((stkpnt_ - 1))] = j_;
      }
    }
  }
  if (stkpnt_ > 0) {
    goto _l10;
  }
  _l0:;
  __calls[103].calls++;
  return 0;
}

int_4 _slassq (int_4 _p_ n_, real_4 _p_ x_, int_4 _p_ incx_, real_4 _p_ scale_, real_4 _p_ sumsq_)
{
  static int_4 ix_;
  static real_4 absxi_;
  real_4 $0_, $1_;
  if ((*n_) > 0) {
    for (ix_ = 1; ((*incx_) > 0 ? ix_ <= 1 + ((*n_) - 1) * (*incx_) : ix_ >= 1 + ((*n_) - 1) * (*incx_)); ix_ += (*incx_)) 
      {
      if (x_[ix_ - 1] != 0.0) {
        absxi_ = _abs (x_[ix_ - 1]);
        if ((*scale_) < absxi_) {
          (*sumsq_) = 1 + (*sumsq_) * ($0_ = ((*scale_) / absxi_), $0_ * $0_);
          (*scale_) = absxi_;
        }
        else {
          (*sumsq_) = (*sumsq_) + ($1_ = (absxi_ / (*scale_)), $1_ * $1_);
        }
      }
    }
  }
  __calls[104].calls++;
  return 0;
}

int_4 _slaswp (int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ k1_, int_4 _p_ k2_, int_4 _p_ ipiv_, int_4 _p_ 
incx_)
{
  static int_4 i_, ip_, ix_;
  extern int_4 _sswap ();
  if ((*incx_) == 0) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    ix_ = (*k1_);
  }
  else {
    ix_ = 1 + (1 - (*k2_)) * (*incx_);
  }
  if ((*incx_) == 1) {
    for (i_ = (*k1_); i_ <= (*k2_); (i_)++) {
      ip_ = ipiv_[i_ - 1];
      if (ip_ != i_) {
        (void) _sswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
    }
  }
  else if ((*incx_) > 1) {
    for (i_ = (*k1_); i_ <= (*k2_); (i_)++) {
      ip_ = ipiv_[ix_ - 1];
      if (ip_ != i_) {
        (void) _sswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
      ix_ = ix_ + (*incx_);
    }
  }
  else if ((*incx_) < 0) {
    for (i_ = (*k2_); i_ >= (*k1_); (i_)--) {
      ip_ = ipiv_[ix_ - 1];
      if (ip_ != i_) {
        (void) _sswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
      ix_ = ix_ + (*incx_);
    }
  }
  _l0:;
  __calls[105].calls++;
  return 0;
}

int_4 _slasy2 (logical_4 _p_ ltranl_, logical_4 _p_ ltranr_, int_4 _p_ isgn_, int_4 _p_ n1_, int_4 _p_ n2_, real_4 _p_ 
tl_, int_4 _p_ ldtl_, real_4 _p_ tr_, int_4 _p_ ldtr_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ scale_, real_4 _p_ x_, 
int_4 _p_ ldx_, real_4 _p_ xnorm_, int_4 _p_ info_)
{
  static int_4 i_, ip_, ipiv_, ipsv_, j_, jp_, jpsv_, k_, jpiv_[4], locl21_[4], locu12_[4], locu22_[4];
  static logical_4 bswap_, xswap_, bswpiv_[4], xswpiv_[4];
  static real_4 bet_, eps_, gam_, l21_, sgn_, smin_, smlnum_, tau1_, temp_, u11_, u12_, u22_, xmax_, btmp_[4], t16_[16], 
  tmp_[4], x2_[2];
  int_4 _data_k_272, _p_ _arr_0, _k_1, _data_k_273, _p_ _arr_2, _k_3, _data_k_274, _p_ _arr_4, _k_5, _data_k_275, _k_7, 
  _data_k_276, _k_9, $12_, $15_, $16_, $17_, $18_, $19_;
  logical_4 _p_ _arr_6, _p_ _arr_8;
  real_4 $10_, $11_, $13_, $14_, $20_;
  extern int_4 _isamax ();
  extern int_4 _scopy ();
  extern int_4 _sswap ();
#define _data_n_272 4
  static int_4 _data_l_272[_data_n_272] = {
    3,
    4,
    1,
    2
  };
#define _data_n_273 4
  static int_4 _data_l_273[_data_n_273] = {
    2,
    1,
    4,
    3
  };
#define _data_n_274 4
  static int_4 _data_l_274[_data_n_274] = {
    4,
    3,
    2,
    1
  };
#define _data_n_275 4
  static logical_4 _data_l_275[_data_n_275] = {
    FALSE,
    FALSE,
    TRUE,
    TRUE
  };
#define _data_n_276 4
  static logical_4 _data_l_276[_data_n_276] = {
    FALSE,
    TRUE,
    FALSE,
    TRUE
  };
  if (__calls[106].calls == 0) {
    _data_k_272 = 0;
    for (_arr_0 = (int_4 *) locu12_, _k_1 = 0; _k_1 < 4; _arr_0++, _k_1++) {
      if (_data_k_272 >= _data_n_272) {
        _data_k_272 = 0;
      }
      locu12_[_k_1] = _data_l_272[_data_k_272++];
    }
    _data_k_273 = 0;
    for (_arr_2 = (int_4 *) locl21_, _k_3 = 0; _k_3 < 4; _arr_2++, _k_3++) {
      if (_data_k_273 >= _data_n_273) {
        _data_k_273 = 0;
      }
      locl21_[_k_3] = _data_l_273[_data_k_273++];
    }
    _data_k_274 = 0;
    for (_arr_4 = (int_4 *) locu22_, _k_5 = 0; _k_5 < 4; _arr_4++, _k_5++) {
      if (_data_k_274 >= _data_n_274) {
        _data_k_274 = 0;
      }
      locu22_[_k_5] = _data_l_274[_data_k_274++];
    }
  }
  if (__calls[106].calls == 0) {
    _data_k_275 = 0;
    for (_arr_6 = (logical_4 *) xswpiv_, _k_7 = 0; _k_7 < 4; _arr_6++, _k_7++) {
      if (_data_k_275 >= _data_n_275) {
        _data_k_275 = 0;
      }
      xswpiv_[_k_7] = _data_l_275[_data_k_275++];
    }
  }
  if (__calls[106].calls == 0) {
    _data_k_276 = 0;
    for (_arr_8 = (logical_4 *) bswpiv_, _k_9 = 0; _k_9 < 4; _arr_8++, _k_9++) {
      if (_data_k_276 >= _data_n_276) {
        _data_k_276 = 0;
      }
      bswpiv_[_k_9] = _data_l_276[_data_k_276++];
    }
  }
  (*info_) = 0;
  if ((*n1_) == 0 || (*n2_) == 0) {
    goto _l0;
  }
  eps_ = _slamch (_dc_44);
  smlnum_ = _slamch (_dc_28) / eps_;
  sgn_ = (*isgn_);
  k_ = (*n1_) + (*n1_) + (*n2_) - 2;
  switch (k_) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
    case 3: goto _l30;
    case 4: goto _l50;
  }
  _l10:;
  tau1_ = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  bet_ = _abs (tau1_);
  if (bet_ <= smlnum_) {
    tau1_ = smlnum_;
    bet_ = smlnum_;
    (*info_) = 1;
  }
  (*scale_) = 1.0;
  gam_ = _abs (b_[0 + ((*ldb_)) * ((0))]);
  if (smlnum_ * gam_ > bet_) {
    (*scale_) = 1.0 / gam_;
  }
  x_[0 + ((*ldx_)) * ((0))] = (b_[0 + ((*ldb_)) * ((0))] * (*scale_)) / tau1_;
  (*xnorm_) = _abs (x_[0 + ((*ldx_)) * ((0))]);
  goto _l0;
  _l20:;
  smin_ = _max (eps_ * ($10_ = _max (_abs (tl_[0 + ((*ldtl_)) * ((0))]), _abs (tr_[0 + ((*ldtr_)) * ((0))])), $10_ = _max 
  ($10_, _abs (tr_[0 + ((*ldtr_)) * ((1))])), $10_ = _max ($10_, _abs (tr_[1 + ((*ldtr_)) * ((0))])), _max ($10_, _abs 
  (tr_[1 + ((*ldtr_)) * ((1))]))), smlnum_);
  tmp_[0] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  tmp_[3] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[1 + ((*ldtr_)) * ((1))];
  if ((*ltranr_)) {
    tmp_[1] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
    tmp_[2] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
  }
  else {
    tmp_[1] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
    tmp_[2] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
  }
  btmp_[0] = b_[0 + ((*ldb_)) * ((0))];
  btmp_[1] = b_[0 + ((*ldb_)) * ((1))];
  goto _l40;
  _l30:;
  smin_ = _max (eps_ * ($11_ = _max (_abs (tr_[0 + ((*ldtr_)) * ((0))]), _abs (tl_[0 + ((*ldtl_)) * ((0))])), $11_ = _max 
  ($11_, _abs (tl_[0 + ((*ldtl_)) * ((1))])), $11_ = _max ($11_, _abs (tl_[1 + ((*ldtl_)) * ((0))])), _max ($11_, _abs 
  (tl_[1 + ((*ldtl_)) * ((1))]))), smlnum_);
  tmp_[0] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  tmp_[3] = tl_[1 + ((*ldtl_)) * ((1))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  if ((*ltranl_)) {
    tmp_[1] = tl_[0 + ((*ldtl_)) * ((1))];
    tmp_[2] = tl_[1 + ((*ldtl_)) * ((0))];
  }
  else {
    tmp_[1] = tl_[1 + ((*ldtl_)) * ((0))];
    tmp_[2] = tl_[0 + ((*ldtl_)) * ((1))];
  }
  btmp_[0] = b_[0 + ((*ldb_)) * ((0))];
  btmp_[1] = b_[1 + ((*ldb_)) * ((0))];
  _l40:;
  ipiv_ = _isamax (($12_ = 4, &$12_), tmp_, &_k1);
  u11_ = tmp_[ipiv_ - 1];
  if (_abs (u11_) <= smin_) {
    (*info_) = 1;
    u11_ = smin_;
  }
  u12_ = tmp_[locu12_[ipiv_ - 1] - 1];
  l21_ = tmp_[locl21_[ipiv_ - 1] - 1] / u11_;
  u22_ = tmp_[locu22_[ipiv_ - 1] - 1] - u12_ * l21_;
  xswap_ = xswpiv_[ipiv_ - 1];
  bswap_ = bswpiv_[ipiv_ - 1];
  if (_abs (u22_) <= smin_) {
    (*info_) = 1;
    u22_ = smin_;
  }
  if (bswap_) {
    temp_ = btmp_[1];
    btmp_[1] = btmp_[0] - l21_ * temp_;
    btmp_[0] = temp_;
  }
  else {
    btmp_[1] = btmp_[1] - l21_ * btmp_[0];
  }
  (*scale_) = 1.0;
  if ((2.0 * smlnum_) * _abs (btmp_[1]) > _abs (u22_) || (2.0 * smlnum_) * _abs (btmp_[0]) > _abs (u11_)) {
    (*scale_) = 0.5 / _max (_abs (btmp_[0]), _abs (btmp_[1]));
    btmp_[0] = btmp_[0] * (*scale_);
    btmp_[1] = btmp_[1] * (*scale_);
  }
  x2_[1] = btmp_[1] / u22_;
  x2_[0] = btmp_[0] / u11_ - (u12_ / u11_) * x2_[1];
  if (xswap_) {
    temp_ = x2_[1];
    x2_[1] = x2_[0];
    x2_[0] = temp_;
  }
  x_[0 + ((*ldx_)) * ((0))] = x2_[0];
  if ((*n1_) == 1) {
    x_[0 + ((*ldx_)) * ((1))] = x2_[1];
    (*xnorm_) = _abs (x_[0 + ((*ldx_)) * ((0))]) + _abs (x_[0 + ((*ldx_)) * ((1))]);
  }
  else {
    x_[1 + ((*ldx_)) * ((0))] = x2_[1];
    (*xnorm_) = _max (_abs (x_[0 + ((*ldx_)) * ((0))]), _abs (x_[1 + ((*ldx_)) * ((0))]));
  }
  goto _l0;
  _l50:;
  smin_ = ($13_ = _max (_abs (tr_[0 + ((*ldtr_)) * ((0))]), _abs (tr_[0 + ((*ldtr_)) * ((1))])), $13_ = _max ($13_, _abs 
  (tr_[1 + ((*ldtr_)) * ((0))])), _max ($13_, _abs (tr_[1 + ((*ldtr_)) * ((1))])));
  smin_ = ($14_ = _max (smin_, _abs (tl_[0 + ((*ldtl_)) * ((0))])), $14_ = _max ($14_, _abs (tl_[0 + ((*ldtl_)) * 
  ((1))])), $14_ = _max ($14_, _abs (tl_[1 + ((*ldtl_)) * ((0))])), _max ($14_, _abs (tl_[1 + ((*ldtl_)) * ((1))])));
  smin_ = _max (eps_ * smin_, smlnum_);
  btmp_[0] = 0.0;
  (void) _scopy (($15_ = 16, &$15_), btmp_, &_k0, t16_, &_k1);
  t16_[0] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  t16_[5] = tl_[1 + ((*ldtl_)) * ((1))] + sgn_ * tr_[0 + ((*ldtr_)) * ((0))];
  t16_[10] = tl_[0 + ((*ldtl_)) * ((0))] + sgn_ * tr_[1 + ((*ldtr_)) * ((1))];
  t16_[15] = tl_[1 + ((*ldtl_)) * ((1))] + sgn_ * tr_[1 + ((*ldtr_)) * ((1))];
  if ((*ltranl_)) {
    t16_[4] = tl_[1 + ((*ldtl_)) * ((0))];
    t16_[1] = tl_[0 + ((*ldtl_)) * ((1))];
    t16_[14] = tl_[1 + ((*ldtl_)) * ((0))];
    t16_[11] = tl_[0 + ((*ldtl_)) * ((1))];
  }
  else {
    t16_[4] = tl_[0 + ((*ldtl_)) * ((1))];
    t16_[1] = tl_[1 + ((*ldtl_)) * ((0))];
    t16_[14] = tl_[0 + ((*ldtl_)) * ((1))];
    t16_[11] = tl_[1 + ((*ldtl_)) * ((0))];
  }
  if ((*ltranr_)) {
    t16_[8] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
    t16_[13] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
    t16_[2] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
    t16_[7] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
  }
  else {
    t16_[8] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
    t16_[13] = sgn_ * tr_[1 + ((*ldtr_)) * ((0))];
    t16_[2] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
    t16_[7] = sgn_ * tr_[0 + ((*ldtr_)) * ((1))];
  }
  btmp_[0] = b_[0 + ((*ldb_)) * ((0))];
  btmp_[1] = b_[1 + ((*ldb_)) * ((0))];
  btmp_[2] = b_[0 + ((*ldb_)) * ((1))];
  btmp_[3] = b_[1 + ((*ldb_)) * ((1))];
  for (i_ = 1; i_ <= 3; (i_)++) {
    xmax_ = 0.0;
    for (ip_ = i_; ip_ <= 4; (ip_)++) {
      for (jp_ = i_; jp_ <= 4; (jp_)++) {
        if (_abs (t16_[ip_ - 1 + (4) * ((jp_ - 1))]) >= xmax_) {
          xmax_ = _abs (t16_[ip_ - 1 + (4) * ((jp_ - 1))]);
          ipsv_ = ip_;
          jpsv_ = jp_;
        }
      }
    }
    if (ipsv_ != i_) {
      (void) _sswap (($16_ = 4, &$16_), &t16_[ipsv_ - 1], ($17_ = 4, &$17_), &t16_[i_ - 1], ($18_ = 4, &$18_));
      temp_ = btmp_[i_ - 1];
      btmp_[i_ - 1] = btmp_[ipsv_ - 1];
      btmp_[ipsv_ - 1] = temp_;
    }
    if (jpsv_ != i_) {
      (void) _sswap (($19_ = 4, &$19_), &t16_[0 + (4) * ((jpsv_ - 1))], &_k1, &t16_[0 + (4) * ((i_ - 1))], &_k1);
    }
    jpiv_[i_ - 1] = jpsv_;
    if (_abs (t16_[i_ - 1 + (4) * ((i_ - 1))]) < smin_) {
      (*info_) = 1;
      t16_[i_ - 1 + (4) * ((i_ - 1))] = smin_;
    }
    for (j_ = i_ + 1; j_ <= 4; (j_)++) {
      t16_[j_ - 1 + (4) * ((i_ - 1))] = t16_[j_ - 1 + (4) * ((i_ - 1))] / t16_[i_ - 1 + (4) * ((i_ - 1))];
      btmp_[j_ - 1] = btmp_[j_ - 1] - t16_[j_ - 1 + (4) * ((i_ - 1))] * btmp_[i_ - 1];
      for (k_ = i_ + 1; k_ <= 4; (k_)++) {
        t16_[j_ - 1 + (4) * ((k_ - 1))] = t16_[j_ - 1 + (4) * ((k_ - 1))] - t16_[j_ - 1 + (4) * ((i_ - 1))] * t16_[i_ - 1 + (4) 
        * ((k_ - 1))];
      }
    }
  }
  if (_abs (t16_[15]) < smin_) {
    t16_[15] = smin_;
  }
  (*scale_) = 1.0;
  if ((8.0 * smlnum_) * _abs (btmp_[0]) > _abs (t16_[0]) || (8.0 * smlnum_) * _abs (btmp_[1]) > _abs (t16_[5]) || (8.0 * 
    smlnum_) * _abs (btmp_[2]) > _abs (t16_[10]) || (8.0 * smlnum_) * _abs (btmp_[3]) > _abs (t16_[15])) {
    (*scale_) = 0.125 / ($20_ = _max (_abs (btmp_[0]), _abs (btmp_[1])), $20_ = _max ($20_, _abs (btmp_[2])), _max ($20_, 
    _abs (btmp_[3])));
    btmp_[0] = btmp_[0] * (*scale_);
    btmp_[1] = btmp_[1] * (*scale_);
    btmp_[2] = btmp_[2] * (*scale_);
    btmp_[3] = btmp_[3] * (*scale_);
  }
  for (i_ = 1; i_ <= 4; (i_)++) {
    k_ = 5 - i_;
    temp_ = 1.0 / t16_[k_ - 1 + (4) * ((k_ - 1))];
    tmp_[k_ - 1] = btmp_[k_ - 1] * temp_;
    for (j_ = k_ + 1; j_ <= 4; (j_)++) {
      tmp_[k_ - 1] = tmp_[k_ - 1] - (temp_ * t16_[k_ - 1 + (4) * ((j_ - 1))]) * tmp_[j_ - 1];
    }
  }
  for (i_ = 1; i_ <= 3; (i_)++) {
    if (jpiv_[4 - i_ - 1] != 4 - i_) {
      temp_ = tmp_[4 - i_ - 1];
      tmp_[4 - i_ - 1] = tmp_[jpiv_[4 - i_ - 1] - 1];
      tmp_[jpiv_[4 - i_ - 1] - 1] = temp_;
    }
  }
  x_[0 + ((*ldx_)) * ((0))] = tmp_[0];
  x_[1 + ((*ldx_)) * ((0))] = tmp_[1];
  x_[0 + ((*ldx_)) * ((1))] = tmp_[2];
  x_[1 + ((*ldx_)) * ((1))] = tmp_[3];
  (*xnorm_) = _max (_abs (tmp_[0]) + _abs (tmp_[2]), _abs (tmp_[1]) + _abs (tmp_[3]));
  _l0:;
  __calls[106].calls++;
  return 0;
}

int_4 _sorm2r (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ a_, int_4 _p_ lda_
, real_4 _p_ tau_, real_4 _p_ c_, int_4 _p_ ldc_, real_4 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, i3_, ic_, jc_, mi_, ni_, nq_;
  static logical_4 left_, notran_;
  static real_4 aii_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  left_ = _lsame (side_, _dc_20);
  notran_ = _lsame (trans_, _dc_7);
  if (left_) {
    nq_ = (*m_);
  }
  else {
    nq_ = (*n_);
  }
  if (! (left_) && ! (_lsame (side_, _dc_37))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_8))) {
    (*info_) = -2;
  }
  else if ((*m_) < 0) {
    (*info_) = -3;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*k_) < 0 || (*k_) > nq_) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, nq_)) {
    (*info_) = -7;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_77, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0 || (*k_) == 0) {
    goto _l0;
  }
  if ((left_ && ! (notran_)) || (! (left_) && notran_)) {
    i1_ = 1;
    i2_ = (*k_);
    i3_ = 1;
  }
  else {
    i1_ = (*k_);
    i2_ = 1;
    i3_ = -1;
  }
  if (left_) {
    ni_ = (*n_);
    jc_ = 1;
  }
  else {
    mi_ = (*m_);
    ic_ = 1;
  }
  for (i_ = i1_; (i3_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += i3_) {
    if (left_) {
      mi_ = (*m_) - i_ + 1;
      ic_ = i_;
    }
    else {
      ni_ = (*n_) - i_ + 1;
      jc_ = i_;
    }
    aii_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
    (void) _slarf (side_, &mi_, &ni_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1, &tau_[i_ - 1], &c_[ic_ - 1 + ((*ldc_)) * 
    ((jc_ - 1))], ldc_, work_);
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
  }
  _l0:;
  __calls[107].calls++;
  return 0;
}

int_4 _spttrf (int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_, int_4 _p_ info_)
{
  static int_4 i_;
  static real_4 di_, ei_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
    (void) _xerbla (_dc_78, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    di_ = d_[i_ - 1];
    if (di_ <= 0.0) {
      goto _l20;
    }
    ei_ = e_[i_ - 1];
    e_[i_ - 1] = ei_ / di_;
    d_[i_ + 1 - 1] = d_[i_ + 1 - 1] - e_[i_ - 1] * ei_;
  }
  i_ = (*n_);
  if (d_[i_ - 1] > 0.0) {
    goto _l30;
  }
  _l20:;
  (*info_) = i_;
  _l30:;
  _l0:;
  __calls[108].calls++;
  return 0;
}

int_4 _spttrs (int_4 _p_ n_, int_4 _p_ nrhs_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ b_, int_4 _p_ ldb_, int_4 _p_ 
info_)
{
  static int_4 i_, j_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -2;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_79, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
    for (i_ = 2; i_ <= (*n_); (i_)++) {
      b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - b_[i_ - 1 - 1 + ((*ldb_)) * ((j_ - 1))] * 
      e_[i_ - 1 - 1];
    }
    b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] / d_[(*n_) - 1];
    for (i_ = (*n_) - 1; i_ >= 1; (i_)--) {
      b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] / d_[i_ - 1] - b_[i_ + 1 - 1 + ((*ldb_)) * 
      ((j_ - 1))] * e_[i_ - 1];
    }
  }
  _l0:;
  __calls[109].calls++;
  return 0;
}

int_4 _ssteqr (char _p_ compz_, int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ z_, int_4 _p_ ldz_, real_4 _p_ 
work_, int_4 _p_ info_)
{
  static int_4 i_, icompz_, ii_, iscale_, j_, jtot_, k_, l_, l1_, lend_, lendm1_, lendp1_, lendsv_, lm1_, lsv_, m_, mm_, 
  mm1_, nm1_, nmaxit_;
  static real_4 anorm_, b_, c_, eps_, eps2_, f_, g_, p_, r_, rt1_, rt2_, s_, safmax_, safmin_, ssfmax_, ssfmin_, tst_;
  int_4 $0_, $3_, $4_, $5_, $6_, $7_, $9_, $12_, $14_, $15_, $16_, $17_;
  real_4 $1_, $2_, $8_, $10_, $11_, $13_;
  extern logical_4 _lsame ();
  extern int_4 _sswap ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if (_lsame (compz_, _dc_7)) {
    icompz_ = 0;
  }
  else if (_lsame (compz_, _dc_40)) {
    icompz_ = 1;
  }
  else if (_lsame (compz_, _dc_25)) {
    icompz_ = 2;
  }
  else {
    icompz_ = -1;
  }
  if (icompz_ < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if (((*ldz_) < 1) || (icompz_ > 0 && (*ldz_) < _max (1, (*n_)))) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_80, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*n_) == 1) {
    if (icompz_ == 2) {
      z_[0 + ((*ldz_)) * ((0))] = 1.0;
    }
    goto _l0;
  }
  eps_ = _slamch (_dc_27);
  eps2_ = (eps_ * eps_);
  safmin_ = _slamch (_dc_28);
  safmax_ = 1.0 / safmin_;
  ssfmax_ = sqrtf (safmax_) / 3.0;
  ssfmin_ = sqrtf (safmin_) / eps2_;
  if (icompz_ == 2) {
    (void) _slaset (_dc_51, n_, n_, ($1_ = 0.0, &$1_), ($2_ = 1.0, &$2_), z_, ldz_);
  }
  nmaxit_ = (*n_) * 30;
  jtot_ = 0;
  l1_ = 1;
  nm1_ = (*n_) - 1;
  _l10:;
  if (l1_ > (*n_)) {
    goto _l160;
  }
  if (l1_ > 1) {
    e_[l1_ - 1 - 1] = 0.0;
  }
  if (l1_ <= nm1_) {
    for (m_ = l1_; m_ <= nm1_; (m_)++) {
      tst_ = _abs (e_[m_ - 1]);
      if (tst_ == 0.0) {
        goto _l30;
      }
      if (tst_ <= (sqrtf (_abs (d_[m_ - 1])) * sqrtf (_abs (d_[m_ + 1 - 1]))) * eps_) {
        e_[m_ - 1] = 0.0;
        goto _l30;
      }
    }
  }
  m_ = (*n_);
  _l30:;
  l_ = l1_;
  lsv_ = l_;
  lend_ = m_;
  lendsv_ = lend_;
  l1_ = m_ + 1;
  if (lend_ == l_) {
    goto _l10;
  }
  anorm_ = _slanst (_dc_25, ($3_ = lend_ - l_ + 1, &$3_), &d_[l_ - 1], &e_[l_ - 1]);
  iscale_ = 0;
  if (anorm_ == 0.0) {
    goto _l10;
  }
  if (anorm_ > ssfmax_) {
    iscale_ = 1;
    (void) _slascl (_dc_29, &_k0, &_k0, &anorm_, &ssfmax_, ($4_ = lend_ - l_ + 1, &$4_), &_k1, &d_[l_ - 1], n_, info_);
    (void) _slascl (_dc_29, &_k0, &_k0, &anorm_, &ssfmax_, ($5_ = lend_ - l_, &$5_), &_k1, &e_[l_ - 1], n_, info_);
  }
  else if (anorm_ < ssfmin_) {
    iscale_ = 2;
    (void) _slascl (_dc_29, &_k0, &_k0, &anorm_, &ssfmin_, ($6_ = lend_ - l_ + 1, &$6_), &_k1, &d_[l_ - 1], n_, info_);
    (void) _slascl (_dc_29, &_k0, &_k0, &anorm_, &ssfmin_, ($7_ = lend_ - l_, &$7_), &_k1, &e_[l_ - 1], n_, info_);
  }
  if (_abs (d_[lend_ - 1]) < _abs (d_[l_ - 1])) {
    lend_ = lsv_;
    l_ = lendsv_;
  }
  if (lend_ > l_) {
    _l40:;
    if (l_ != lend_) {
      lendm1_ = lend_ - 1;
      for (m_ = l_; m_ <= lendm1_; (m_)++) {
        tst_ = ($8_ = _abs (e_[m_ - 1]), $8_ * $8_);
        if (tst_ <= (eps2_ * _abs (d_[m_ - 1])) * _abs (d_[m_ + 1 - 1]) + safmin_) {
          goto _l60;
        }
      }
    }
    m_ = lend_;
    _l60:;
    if (m_ < lend_) {
      e_[m_ - 1] = 0.0;
    }
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l80;
    }
    if (m_ == l_ + 1) {
      if (icompz_ > 0) {
        (void) _slaev2 (&d_[l_ - 1], &e_[l_ - 1], &d_[l_ + 1 - 1], &rt1_, &rt2_, &c_, &s_);
        work_[l_ - 1] = c_;
        work_[(*n_) - 1 + l_ - 1] = s_;
        (void) _slasr (_dc_37, _dc_40, _dc_31, n_, ($9_ = 2, &$9_), &work_[l_ - 1], &work_[(*n_) - 1 + l_ - 1], &z_[0 + 
        ((*ldz_)) * ((l_ - 1))], ldz_);
      }
      else {
        (void) _slae2 (&d_[l_ - 1], &e_[l_ - 1], &d_[l_ + 1 - 1], &rt1_, &rt2_);
      }
      d_[l_ - 1] = rt1_;
      d_[l_ + 1 - 1] = rt2_;
      e_[l_ - 1] = 0.0;
      l_ = l_ + 2;
      if (l_ <= lend_) {
        goto _l40;
      }
      goto _l140;
    }
    if (jtot_ == nmaxit_) {
      goto _l140;
    }
    jtot_ = jtot_ + 1;
    g_ = (d_[l_ + 1 - 1] - p_) / (2.0 * e_[l_ - 1]);
    r_ = _slapy2 (&g_, ($10_ = 1.0, &$10_));
    g_ = d_[m_ - 1] - p_ + (e_[l_ - 1] / (g_ + _sign (r_, g_)));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    mm1_ = m_ - 1;
    for (i_ = mm1_; i_ >= l_; (i_)--) {
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      (void) _slartg (&g_, &f_, &c_, &s_, &r_);
      if (i_ != m_ - 1) {
        e_[i_ + 1 - 1] = r_;
      }
      g_ = d_[i_ + 1 - 1] - p_;
      r_ = (d_[i_ - 1] - g_) * s_ + 2.0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ + 1 - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      if (icompz_ > 0) {
        work_[i_ - 1] = c_;
        work_[(*n_) - 1 + i_ - 1] = -s_;
      }
    }
    if (icompz_ > 0) {
      mm_ = m_ - l_ + 1;
      (void) _slasr (_dc_37, _dc_40, _dc_31, n_, &mm_, &work_[l_ - 1], &work_[(*n_) - 1 + l_ - 1], &z_[0 + ((*ldz_)) * ((l_ - 
      1))], ldz_);
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[l_ - 1] = g_;
    goto _l40;
    _l80:;
    d_[l_ - 1] = p_;
    l_ = l_ + 1;
    if (l_ <= lend_) {
      goto _l40;
    }
    goto _l140;
  }
  else {
    _l90:;
    if (l_ != lend_) {
      lendp1_ = lend_ + 1;
      for (m_ = l_; m_ >= lendp1_; (m_)--) {
        tst_ = ($11_ = _abs (e_[m_ - 1 - 1]), $11_ * $11_);
        if (tst_ <= (eps2_ * _abs (d_[m_ - 1])) * _abs (d_[m_ - 1 - 1]) + safmin_) {
          goto _l110;
        }
      }
    }
    m_ = lend_;
    _l110:;
    if (m_ > lend_) {
      e_[m_ - 1 - 1] = 0.0;
    }
    p_ = d_[l_ - 1];
    if (m_ == l_) {
      goto _l130;
    }
    if (m_ == l_ - 1) {
      if (icompz_ > 0) {
        (void) _slaev2 (&d_[l_ - 1 - 1], &e_[l_ - 1 - 1], &d_[l_ - 1], &rt1_, &rt2_, &c_, &s_);
        work_[m_ - 1] = c_;
        work_[(*n_) - 1 + m_ - 1] = s_;
        (void) _slasr (_dc_37, _dc_40, _dc_26, n_, ($12_ = 2, &$12_), &work_[m_ - 1], &work_[(*n_) - 1 + m_ - 1], &z_[0 + 
        ((*ldz_)) * ((l_ - 1 - 1))], ldz_);
      }
      else {
        (void) _slae2 (&d_[l_ - 1 - 1], &e_[l_ - 1 - 1], &d_[l_ - 1], &rt1_, &rt2_);
      }
      d_[l_ - 1 - 1] = rt1_;
      d_[l_ - 1] = rt2_;
      e_[l_ - 1 - 1] = 0.0;
      l_ = l_ - 2;
      if (l_ >= lend_) {
        goto _l90;
      }
      goto _l140;
    }
    if (jtot_ == nmaxit_) {
      goto _l140;
    }
    jtot_ = jtot_ + 1;
    g_ = (d_[l_ - 1 - 1] - p_) / (2.0 * e_[l_ - 1 - 1]);
    r_ = _slapy2 (&g_, ($13_ = 1.0, &$13_));
    g_ = d_[m_ - 1] - p_ + (e_[l_ - 1 - 1] / (g_ + _sign (r_, g_)));
    s_ = 1.0;
    c_ = 1.0;
    p_ = 0.0;
    lm1_ = l_ - 1;
    for (i_ = m_; i_ <= lm1_; (i_)++) {
      f_ = s_ * e_[i_ - 1];
      b_ = c_ * e_[i_ - 1];
      (void) _slartg (&g_, &f_, &c_, &s_, &r_);
      if (i_ != m_) {
        e_[i_ - 1 - 1] = r_;
      }
      g_ = d_[i_ - 1] - p_;
      r_ = (d_[i_ + 1 - 1] - g_) * s_ + 2.0 * c_ * b_;
      p_ = s_ * r_;
      d_[i_ - 1] = g_ + p_;
      g_ = c_ * r_ - b_;
      if (icompz_ > 0) {
        work_[i_ - 1] = c_;
        work_[(*n_) - 1 + i_ - 1] = s_;
      }
    }
    if (icompz_ > 0) {
      mm_ = l_ - m_ + 1;
      (void) _slasr (_dc_37, _dc_40, _dc_26, n_, &mm_, &work_[m_ - 1], &work_[(*n_) - 1 + m_ - 1], &z_[0 + ((*ldz_)) * ((m_ - 
      1))], ldz_);
    }
    d_[l_ - 1] = d_[l_ - 1] - p_;
    e_[lm1_ - 1] = g_;
    goto _l90;
    _l130:;
    d_[l_ - 1] = p_;
    l_ = l_ - 1;
    if (l_ >= lend_) {
      goto _l90;
    }
    goto _l140;
  }
  _l140:;
  if (iscale_ == 1) {
    (void) _slascl (_dc_29, &_k0, &_k0, &ssfmax_, &anorm_, ($14_ = lendsv_ - lsv_ + 1, &$14_), &_k1, &d_[lsv_ - 1], n_, 
    info_);
    (void) _slascl (_dc_29, &_k0, &_k0, &ssfmax_, &anorm_, ($15_ = lendsv_ - lsv_, &$15_), &_k1, &e_[lsv_ - 1], n_, info_)
    ;
  }
  else if (iscale_ == 2) {
    (void) _slascl (_dc_29, &_k0, &_k0, &ssfmin_, &anorm_, ($16_ = lendsv_ - lsv_ + 1, &$16_), &_k1, &d_[lsv_ - 1], n_, 
    info_);
    (void) _slascl (_dc_29, &_k0, &_k0, &ssfmin_, &anorm_, ($17_ = lendsv_ - lsv_, &$17_), &_k1, &e_[lsv_ - 1], n_, info_)
    ;
  }
  if (jtot_ < nmaxit_) {
    goto _l10;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (e_[i_ - 1] != 0.0) {
      (*info_) = (*info_) + 1;
    }
  }
  goto _l190;
  _l160:;
  if (icompz_ == 0) {
    (void) _slasrt (_dc_25, n_, d_, info_);
  }
  else {
    for (ii_ = 2; ii_ <= (*n_); (ii_)++) {
      i_ = ii_ - 1;
      k_ = i_;
      p_ = d_[i_ - 1];
      for (j_ = ii_; j_ <= (*n_); (j_)++) {
        if (d_[j_ - 1] < p_) {
          k_ = j_;
          p_ = d_[j_ - 1];
        }
      }
      if (k_ != i_) {
        d_[k_ - 1] = d_[i_ - 1];
        d_[i_ - 1] = p_;
        (void) _sswap (n_, &z_[0 + ((*ldz_)) * ((i_ - 1))], &_k1, &z_[0 + ((*ldz_)) * ((k_ - 1))], &_k1);
      }
    }
  }
  _l190:;
  _l0:;
  __calls[110].calls++;
  return 0;
}

int_4 _strevc (char _p_ side_, char _p_ howmny_, logical_4 _p_ select_, int_4 _p_ n_, real_4 _p_ t_, int_4 _p_ ldt_, 
real_4 _p_ vl_, int_4 _p_ ldvl_, real_4 _p_ vr_, int_4 _p_ ldvr_, int_4 _p_ mm_, int_4 _p_ m_, real_4 _p_ work_, int_4 
_p_ info_)
{
  static int_4 i_, ierr_, ii_, ip_, is_, j_, j1_, j2_, jnxt_, k_, ki_, n2_;
  static logical_4 allv_, bothv_, leftv_, over_, pair_, rightv_, somev_;
  static real_4 beta_, bignum_, emax_, ovfl_, rec_, remax_, scale_, smin_, smlnum_, ulp_, unfl_, vcrit_, vmax_, wi_, wr_, 
  xnorm_, x_[4];
  int_4 $0_, $6_, $7_, $10_, $15_, $16_, $18_, $20_, $23_, $27_, $28_, $30_, $33_, $34_, $38_, $39_, $41_, $43_, $45_, 
  $47_, $49_, $51_, $52_, $58_, $59_, $60_, $61_, $62_, $64_, $69_, $70_, $72_, $73_, $74_, $75_, $77_, $78_, $79_, $80_, 
  $82_, $87_, $88_, $89_, $91_, $92_, $93_, $94_, $95_, $96_, $98_, $99_, $104_, $105_, $106_, $108_, $109_, $110_, $111_
  , $112_, $114_;
  logical_4 $1_, $9_, $22_, $32_, $53_, $63_, $81_, $97_;
  real_4 $2_, $3_, $4_, $5_, $8_, $11_, $12_, $13_, $14_, $17_, $19_, $21_, $24_, $25_, $26_, $29_, $31_, $35_, $36_, 
  $37_, $40_, $42_, $44_, $46_, $48_, $50_, $54_, $55_, $56_, $57_, $65_, $66_, $67_, $68_, $71_, $76_, $83_, $84_, $85_, 
  $86_, $90_, $100_, $101_, $102_, $103_, $107_, $113_, $115_;
  extern logical_4 _lsame ();
  extern int_4 _isamax ();
  extern real_4 _sdot ();
  extern int_4 _saxpy ();
  extern int_4 _scopy ();
  extern int_4 _sgemv ();
  extern int_4 _sscal ();
  extern int_4 _xerbla ();
  bothv_ = _lsame (side_, _dc_31);
  rightv_ = _lsame (side_, _dc_37) || bothv_;
  leftv_ = _lsame (side_, _dc_20) || bothv_;
  allv_ = _lsame (howmny_, _dc_38);
  over_ = _lsame (howmny_, _dc_31) || _lsame (howmny_, _dc_24);
  somev_ = _lsame (howmny_, _dc_28);
  (*info_) = 0;
  if (! (rightv_) && ! (leftv_)) {
    (*info_) = -1;
  }
  else if (! (allv_) && ! (over_) && ! (somev_)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  else if ((*ldvl_) < 1 || (leftv_ && (*ldvl_) < (*n_))) {
    (*info_) = -8;
  }
  else if ((*ldvr_) < 1 || (rightv_ && (*ldvr_) < (*n_))) {
    (*info_) = -10;
  }
  else {
    if (somev_) {
      (*m_) = 0;
      pair_ = FALSE;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (pair_) {
          pair_ = FALSE;
          select_[j_ - 1] = FALSE;
        }
        else {
          if (j_ < (*n_)) {
            if (t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))] == 0.0) {
              if (select_[j_ - 1]) {
                (*m_) = (*m_) + 1;
              }
            }
            else {
              pair_ = TRUE;
              if (select_[j_ - 1] || select_[j_ + 1 - 1]) {
                select_[j_ - 1] = TRUE;
                (*m_) = (*m_) + 2;
              }
            }
          }
          else {
            if (select_[(*n_) - 1]) {
              (*m_) = (*m_) + 1;
            }
          }
        }
      }
    }
    else {
      (*m_) = (*n_);
    }
    if ((*mm_) < (*m_)) {
      (*info_) = -11;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_81, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  unfl_ = _slamch (_dc_18);
  ovfl_ = 1.0 / unfl_;
  (void) _slabad (&unfl_, &ovfl_);
  ulp_ = _slamch (_dc_21);
  smlnum_ = unfl_ * ((*n_) / ulp_);
  bignum_ = (1.0 - ulp_) / smlnum_;
  work_[0] = 0.0;
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    work_[j_ - 1] = 0.0;
    for (i_ = 1; i_ <= j_ - 1; (i_)++) {
      work_[j_ - 1] = work_[j_ - 1] + _abs (t_[i_ - 1 + ((*ldt_)) * ((j_ - 1))]);
    }
  }
  n2_ = 2 * (*n_);
  if (rightv_) {
    ip_ = 0;
    is_ = (*m_);
    for (ki_ = (*n_); ki_ >= 1; (ki_)--) {
      if (ip_ == 1) {
        goto _l130;
      }
      if (ki_ == 1) {
        goto _l40;
      }
      if (t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))] == 0.0) {
        goto _l40;
      }
      ip_ = -1;
      _l40:;
      if (somev_) {
        if (ip_ == 0) {
          if (! (select_[ki_ - 1])) {
            goto _l130;
          }
        }
        else {
          if (! (select_[ki_ - 1 - 1])) {
            goto _l130;
          }
        }
      }
      wr_ = t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))];
      wi_ = 0.0;
      if (ip_ != 0) {
        wi_ = sqrtf (_abs (t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))])) * sqrtf (_abs (t_[ki_ - 1 - 1 + ((*ldt_)) * ((ki_ - 
        1))]));
      }
      smin_ = _max (ulp_ * (_abs (wr_) + _abs (wi_)), smlnum_);
      if (ip_ == 0) {
        work_[ki_ + (*n_) - 1] = 1.0;
        for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
          work_[k_ + (*n_) - 1] = -t_[k_ - 1 + ((*ldt_)) * ((ki_ - 1))];
        }
        jnxt_ = ki_ - 1;
        for (j_ = ki_ - 1; j_ >= 1; (j_)--) {
          if (j_ > jnxt_) {
            goto _l60;
          }
          j1_ = j_;
          j2_ = j_;
          jnxt_ = j_ - 1;
          if (j_ > 1) {
            if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))] != 0.0) {
              j1_ = j_ - 1;
              jnxt_ = j_ - 2;
            }
          }
          if (j1_ == j2_) {
            (void) _slaln2 (($1_ = FALSE, &$1_), &_k1, &_k1, &smin_, ($2_ = 1.0, &$2_), &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))], ldt_, 
            ($3_ = 1.0, &$3_), ($4_ = 1.0, &$4_), &work_[j_ + (*n_) - 1], n_, &wr_, ($5_ = 0.0, &$5_), x_, ($6_ = 2, &$6_), 
            &scale_, &xnorm_, &ierr_);
            if (xnorm_ > 1.0) {
              if (work_[j_ - 1] > bignum_ / xnorm_) {
                x_[0] = x_[0] / xnorm_;
                scale_ = scale_ / xnorm_;
              }
            }
            if (scale_ != 1.0) {
              (void) _sscal (&ki_, &scale_, &work_[1 + (*n_) - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            (void) _saxpy (($7_ = j_ - 1, &$7_), ($8_ = -x_[0], &$8_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + (*n_) - 
            1], &_k1);
          }
          else {
            (void) _slaln2 (($9_ = FALSE, &$9_), ($10_ = 2, &$10_), &_k1, &smin_, ($11_ = 1.0, &$11_), &t_[j_ - 1 - 1 + ((*ldt_)) * 
            ((j_ - 1 - 1))], ldt_, ($12_ = 1.0, &$12_), ($13_ = 1.0, &$13_), &work_[j_ - 1 + (*n_) - 1], n_, &wr_, ($14_ = 0.0, 
            &$14_), x_, ($15_ = 2, &$15_), &scale_, &xnorm_, &ierr_);
            if (xnorm_ > 1.0) {
              beta_ = _max (work_[j_ - 1 - 1], work_[j_ - 1]);
              if (beta_ > bignum_ / xnorm_) {
                x_[0] = x_[0] / xnorm_;
                x_[1] = x_[1] / xnorm_;
                scale_ = scale_ / xnorm_;
              }
            }
            if (scale_ != 1.0) {
              (void) _sscal (&ki_, &scale_, &work_[1 + (*n_) - 1], &_k1);
            }
            work_[j_ - 1 + (*n_) - 1] = x_[0];
            work_[j_ + (*n_) - 1] = x_[1];
            (void) _saxpy (($16_ = j_ - 2, &$16_), ($17_ = -x_[0], &$17_), &t_[0 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &work_[1 + 
            (*n_) - 1], &_k1);
            (void) _saxpy (($18_ = j_ - 2, &$18_), ($19_ = -x_[1], &$19_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + (*n_) 
            - 1], &_k1);
          }
          _l60:;
        }
        if (! (over_)) {
          (void) _scopy (&ki_, &work_[1 + (*n_) - 1], &_k1, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          ii_ = _isamax (&ki_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          remax_ = 1.0 / _abs (vr_[ii_ - 1 + ((*ldvr_)) * ((is_ - 1))]);
          (void) _sscal (&ki_, &remax_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
            vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1))] = 0.0;
          }
        }
        else {
          if (ki_ > 1) {
            (void) _sgemv (_dc_7, n_, ($20_ = ki_ - 1, &$20_), ($21_ = 1.0, &$21_), vr_, ldvr_, &work_[1 + (*n_) - 1], &_k1, 
            &work_[ki_ + (*n_) - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
          }
          ii_ = _isamax (n_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
          remax_ = 1.0 / _abs (vr_[ii_ - 1 + ((*ldvr_)) * ((ki_ - 1))]);
          (void) _sscal (n_, &remax_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
        }
      }
      else {
        if (_abs (t_[ki_ - 1 - 1 + ((*ldt_)) * ((ki_ - 1))]) >= _abs (t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))])) {
          work_[ki_ - 1 + (*n_) - 1] = 1.0;
          work_[ki_ + n2_ - 1] = wi_ / t_[ki_ - 1 - 1 + ((*ldt_)) * ((ki_ - 1))];
        }
        else {
          work_[ki_ - 1 + (*n_) - 1] = -wi_ / t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))];
          work_[ki_ + n2_ - 1] = 1.0;
        }
        work_[ki_ + (*n_) - 1] = 0.0;
        work_[ki_ - 1 + n2_ - 1] = 0.0;
        for (k_ = 1; k_ <= ki_ - 2; (k_)++) {
          work_[k_ + (*n_) - 1] = -work_[ki_ - 1 + (*n_) - 1] * t_[k_ - 1 + ((*ldt_)) * ((ki_ - 1 - 1))];
          work_[k_ + n2_ - 1] = -work_[ki_ + n2_ - 1] * t_[k_ - 1 + ((*ldt_)) * ((ki_ - 1))];
        }
        jnxt_ = ki_ - 2;
        for (j_ = ki_ - 2; j_ >= 1; (j_)--) {
          if (j_ > jnxt_) {
            goto _l90;
          }
          j1_ = j_;
          j2_ = j_;
          jnxt_ = j_ - 1;
          if (j_ > 1) {
            if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))] != 0.0) {
              j1_ = j_ - 1;
              jnxt_ = j_ - 2;
            }
          }
          if (j1_ == j2_) {
            (void) _slaln2 (($22_ = FALSE, &$22_), &_k1, ($23_ = 2, &$23_), &smin_, ($24_ = 1.0, &$24_), &t_[j_ - 1 + ((*ldt_)) * 
            ((j_ - 1))], ldt_, ($25_ = 1.0, &$25_), ($26_ = 1.0, &$26_), &work_[j_ + (*n_) - 1], n_, &wr_, &wi_, x_, ($27_ = 2, 
            &$27_), &scale_, &xnorm_, &ierr_);
            if (xnorm_ > 1.0) {
              if (work_[j_ - 1] > bignum_ / xnorm_) {
                x_[0] = x_[0] / xnorm_;
                x_[2] = x_[2] / xnorm_;
                scale_ = scale_ / xnorm_;
              }
            }
            if (scale_ != 1.0) {
              (void) _sscal (&ki_, &scale_, &work_[1 + (*n_) - 1], &_k1);
              (void) _sscal (&ki_, &scale_, &work_[1 + n2_ - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            work_[j_ + n2_ - 1] = x_[2];
            (void) _saxpy (($28_ = j_ - 1, &$28_), ($29_ = -x_[0], &$29_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + (*n_) 
            - 1], &_k1);
            (void) _saxpy (($30_ = j_ - 1, &$30_), ($31_ = -x_[2], &$31_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + n2_ - 
            1], &_k1);
          }
          else {
            (void) _slaln2 (($32_ = FALSE, &$32_), ($33_ = 2, &$33_), ($34_ = 2, &$34_), &smin_, ($35_ = 1.0, &$35_), &t_[j_ - 1 - 
            1 + ((*ldt_)) * ((j_ - 1 - 1))], ldt_, ($36_ = 1.0, &$36_), ($37_ = 1.0, &$37_), &work_[j_ - 1 + (*n_) - 1], n_, &wr_, 
            &wi_, x_, ($38_ = 2, &$38_), &scale_, &xnorm_, &ierr_);
            if (xnorm_ > 1.0) {
              beta_ = _max (work_[j_ - 1 - 1], work_[j_ - 1]);
              if (beta_ > bignum_ / xnorm_) {
                rec_ = 1.0 / xnorm_;
                x_[0] = x_[0] * rec_;
                x_[2] = x_[2] * rec_;
                x_[1] = x_[1] * rec_;
                x_[3] = x_[3] * rec_;
                scale_ = scale_ * rec_;
              }
            }
            if (scale_ != 1.0) {
              (void) _sscal (&ki_, &scale_, &work_[1 + (*n_) - 1], &_k1);
              (void) _sscal (&ki_, &scale_, &work_[1 + n2_ - 1], &_k1);
            }
            work_[j_ - 1 + (*n_) - 1] = x_[0];
            work_[j_ + (*n_) - 1] = x_[1];
            work_[j_ - 1 + n2_ - 1] = x_[2];
            work_[j_ + n2_ - 1] = x_[3];
            (void) _saxpy (($39_ = j_ - 2, &$39_), ($40_ = -x_[0], &$40_), &t_[0 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &work_[1 + 
            (*n_) - 1], &_k1);
            (void) _saxpy (($41_ = j_ - 2, &$41_), ($42_ = -x_[1], &$42_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + (*n_) 
            - 1], &_k1);
            (void) _saxpy (($43_ = j_ - 2, &$43_), ($44_ = -x_[2], &$44_), &t_[0 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &work_[1 + 
            n2_ - 1], &_k1);
            (void) _saxpy (($45_ = j_ - 2, &$45_), ($46_ = -x_[3], &$46_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &work_[1 + n2_ - 
            1], &_k1);
          }
          _l90:;
        }
        if (! (over_)) {
          (void) _scopy (&ki_, &work_[1 + (*n_) - 1], &_k1, &vr_[0 + ((*ldvr_)) * ((is_ - 1 - 1))], &_k1);
          (void) _scopy (&ki_, &work_[1 + n2_ - 1], &_k1, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          emax_ = 0.0;
          for (k_ = 1; k_ <= ki_; (k_)++) {
            emax_ = _max (emax_, _abs (vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1 - 1))]) + _abs (vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1))]))
            ;
          }
          remax_ = 1.0 / emax_;
          (void) _sscal (&ki_, &remax_, &vr_[0 + ((*ldvr_)) * ((is_ - 1 - 1))], &_k1);
          (void) _sscal (&ki_, &remax_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
          for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
            vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1 - 1))] = 0.0;
            vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1))] = 0.0;
          }
        }
        else {
          if (ki_ > 2) {
            (void) _sgemv (_dc_7, n_, ($47_ = ki_ - 2, &$47_), ($48_ = 1.0, &$48_), vr_, ldvr_, &work_[1 + (*n_) - 1], &_k1, 
            &work_[ki_ - 1 + (*n_) - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1 - 1))], &_k1);
            (void) _sgemv (_dc_7, n_, ($49_ = ki_ - 2, &$49_), ($50_ = 1.0, &$50_), vr_, ldvr_, &work_[1 + n2_ - 1], &_k1, 
            &work_[ki_ + n2_ - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
          }
          else {
            (void) _sscal (n_, &work_[ki_ - 1 + (*n_) - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1 - 1))], &_k1);
            (void) _sscal (n_, &work_[ki_ + n2_ - 1], &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
          }
          emax_ = 0.0;
          for (k_ = 1; k_ <= (*n_); (k_)++) {
            emax_ = _max (emax_, _abs (vr_[k_ - 1 + ((*ldvr_)) * ((ki_ - 1 - 1))]) + _abs (vr_[k_ - 1 + ((*ldvr_)) * ((ki_ - 1))]))
            ;
          }
          remax_ = 1.0 / emax_;
          (void) _sscal (n_, &remax_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1 - 1))], &_k1);
          (void) _sscal (n_, &remax_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
        }
      }
      is_ = is_ - 1;
      if (ip_ != 0) {
        is_ = is_ - 1;
      }
      _l130:;
      if (ip_ == 1) {
        ip_ = 0;
      }
      if (ip_ == -1) {
        ip_ = 1;
      }
    }
  }
  if (leftv_) {
    ip_ = 0;
    is_ = 1;
    for (ki_ = 1; ki_ <= (*n_); (ki_)++) {
      if (ip_ == -1) {
        goto _l250;
      }
      if (ki_ == (*n_)) {
        goto _l150;
      }
      if (t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ - 1))] == 0.0) {
        goto _l150;
      }
      ip_ = 1;
      _l150:;
      if (somev_) {
        if (! (select_[ki_ - 1])) {
          goto _l250;
        }
      }
      wr_ = t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))];
      wi_ = 0.0;
      if (ip_ != 0) {
        wi_ = sqrtf (_abs (t_[ki_ - 1 + ((*ldt_)) * ((ki_ + 1 - 1))])) * sqrtf (_abs (t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ - 
        1))]));
      }
      smin_ = _max (ulp_ * (_abs (wr_) + _abs (wi_)), smlnum_);
      if (ip_ == 0) {
        work_[ki_ + (*n_) - 1] = 1.0;
        for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
          work_[k_ + (*n_) - 1] = -t_[ki_ - 1 + ((*ldt_)) * ((k_ - 1))];
        }
        vmax_ = 1.0;
        vcrit_ = bignum_;
        jnxt_ = ki_ + 1;
        for (j_ = ki_ + 1; j_ <= (*n_); (j_)++) {
          if (j_ < jnxt_) {
            goto _l170;
          }
          j1_ = j_;
          j2_ = j_;
          jnxt_ = j_ + 1;
          if (j_ < (*n_)) {
            if (t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))] != 0.0) {
              j2_ = j_ + 1;
              jnxt_ = j_ + 2;
            }
          }
          if (j1_ == j2_) {
            if (work_[j_ - 1] > vcrit_) {
              rec_ = 1.0 / vmax_;
              (void) _sscal (($51_ = (*n_) - ki_ + 1, &$51_), &rec_, &work_[ki_ + (*n_) - 1], &_k1);
              vmax_ = 1.0;
              vcrit_ = bignum_;
            }
            work_[j_ + (*n_) - 1] = work_[j_ + (*n_) - 1] - _sdot (($52_ = j_ - ki_ - 1, &$52_), &t_[ki_ + 1 - 1 + ((*ldt_)) * ((j_ 
            - 1))], &_k1, &work_[ki_ + 1 + (*n_) - 1], &_k1);
            (void) _slaln2 (($53_ = FALSE, &$53_), &_k1, &_k1, &smin_, ($54_ = 1.0, &$54_), &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))], 
            ldt_, ($55_ = 1.0, &$55_), ($56_ = 1.0, &$56_), &work_[j_ + (*n_) - 1], n_, &wr_, ($57_ = 0.0, &$57_), x_, ($58_ = 2, 
            &$58_), &scale_, &xnorm_, &ierr_);
            if (scale_ != 1.0) {
              (void) _sscal (($59_ = (*n_) - ki_ + 1, &$59_), &scale_, &work_[ki_ + (*n_) - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            vmax_ = _max (_abs (work_[j_ + (*n_) - 1]), vmax_);
            vcrit_ = bignum_ / vmax_;
          }
          else {
            beta_ = _max (work_[j_ - 1], work_[j_ + 1 - 1]);
            if (beta_ > vcrit_) {
              rec_ = 1.0 / vmax_;
              (void) _sscal (($60_ = (*n_) - ki_ + 1, &$60_), &rec_, &work_[ki_ + (*n_) - 1], &_k1);
              vmax_ = 1.0;
              vcrit_ = bignum_;
            }
            work_[j_ + (*n_) - 1] = work_[j_ + (*n_) - 1] - _sdot (($61_ = j_ - ki_ - 1, &$61_), &t_[ki_ + 1 - 1 + ((*ldt_)) * ((j_ 
            - 1))], &_k1, &work_[ki_ + 1 + (*n_) - 1], &_k1);
            work_[j_ + 1 + (*n_) - 1] = work_[j_ + 1 + (*n_) - 1] - _sdot (($62_ = j_ - ki_ - 1, &$62_), &t_[ki_ + 1 - 1 + 
            ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &work_[ki_ + 1 + (*n_) - 1], &_k1);
            (void) _slaln2 (($63_ = TRUE, &$63_), ($64_ = 2, &$64_), &_k1, &smin_, ($65_ = 1.0, &$65_), &t_[j_ - 1 + ((*ldt_)) * 
            ((j_ - 1))], ldt_, ($66_ = 1.0, &$66_), ($67_ = 1.0, &$67_), &work_[j_ + (*n_) - 1], n_, &wr_, ($68_ = 0.0, &$68_), x_, 
            ($69_ = 2, &$69_), &scale_, &xnorm_, &ierr_);
            if (scale_ != 1.0) {
              (void) _sscal (($70_ = (*n_) - ki_ + 1, &$70_), &scale_, &work_[ki_ + (*n_) - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            work_[j_ + 1 + (*n_) - 1] = x_[1];
            vmax_ = ($71_ = _max (_abs (work_[j_ + (*n_) - 1]), _abs (work_[j_ + 1 + (*n_) - 1])), _max ($71_, vmax_));
            vcrit_ = bignum_ / vmax_;
          }
          _l170:;
        }
        if (! (over_)) {
          (void) _scopy (($72_ = (*n_) - ki_ + 1, &$72_), &work_[ki_ + (*n_) - 1], &_k1, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 
          1))], &_k1);
          ii_ = _isamax (($73_ = (*n_) - ki_ + 1, &$73_), &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1) + ki_ - 1;
          remax_ = 1.0 / _abs (vl_[ii_ - 1 + ((*ldvl_)) * ((is_ - 1))]);
          (void) _sscal (($74_ = (*n_) - ki_ + 1, &$74_), &remax_, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1);
          for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
            vl_[k_ - 1 + ((*ldvl_)) * ((is_ - 1))] = 0.0;
          }
        }
        else {
          if (ki_ < (*n_)) {
            (void) _sgemv (_dc_7, n_, ($75_ = (*n_) - ki_, &$75_), ($76_ = 1.0, &$76_), &vl_[0 + ((*ldvl_)) * ((ki_ + 1 - 1))], 
            ldvl_, &work_[ki_ + 1 + (*n_) - 1], &_k1, &work_[ki_ + (*n_) - 1], &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
          }
          ii_ = _isamax (n_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
          remax_ = 1.0 / _abs (vl_[ii_ - 1 + ((*ldvl_)) * ((ki_ - 1))]);
          (void) _sscal (n_, &remax_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
        }
      }
      else {
        if (_abs (t_[ki_ - 1 + ((*ldt_)) * ((ki_ + 1 - 1))]) >= _abs (t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ - 1))])) {
          work_[ki_ + (*n_) - 1] = wi_ / t_[ki_ - 1 + ((*ldt_)) * ((ki_ + 1 - 1))];
          work_[ki_ + 1 + n2_ - 1] = 1.0;
        }
        else {
          work_[ki_ + (*n_) - 1] = 1.0;
          work_[ki_ + 1 + n2_ - 1] = -wi_ / t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ - 1))];
        }
        work_[ki_ + 1 + (*n_) - 1] = 0.0;
        work_[ki_ + n2_ - 1] = 0.0;
        for (k_ = ki_ + 2; k_ <= (*n_); (k_)++) {
          work_[k_ + (*n_) - 1] = -work_[ki_ + (*n_) - 1] * t_[ki_ - 1 + ((*ldt_)) * ((k_ - 1))];
          work_[k_ + n2_ - 1] = -work_[ki_ + 1 + n2_ - 1] * t_[ki_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))];
        }
        vmax_ = 1.0;
        vcrit_ = bignum_;
        jnxt_ = ki_ + 2;
        for (j_ = ki_ + 2; j_ <= (*n_); (j_)++) {
          if (j_ < jnxt_) {
            goto _l200;
          }
          j1_ = j_;
          j2_ = j_;
          jnxt_ = j_ + 1;
          if (j_ < (*n_)) {
            if (t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))] != 0.0) {
              j2_ = j_ + 1;
              jnxt_ = j_ + 2;
            }
          }
          if (j1_ == j2_) {
            if (work_[j_ - 1] > vcrit_) {
              rec_ = 1.0 / vmax_;
              (void) _sscal (($77_ = (*n_) - ki_ + 1, &$77_), &rec_, &work_[ki_ + (*n_) - 1], &_k1);
              (void) _sscal (($78_ = (*n_) - ki_ + 1, &$78_), &rec_, &work_[ki_ + n2_ - 1], &_k1);
              vmax_ = 1.0;
              vcrit_ = bignum_;
            }
            work_[j_ + (*n_) - 1] = work_[j_ + (*n_) - 1] - _sdot (($79_ = j_ - ki_ - 2, &$79_), &t_[ki_ + 2 - 1 + ((*ldt_)) * ((j_ 
            - 1))], &_k1, &work_[ki_ + 2 + (*n_) - 1], &_k1);
            work_[j_ + n2_ - 1] = work_[j_ + n2_ - 1] - _sdot (($80_ = j_ - ki_ - 2, &$80_), &t_[ki_ + 2 - 1 + ((*ldt_)) * ((j_ - 
            1))], &_k1, &work_[ki_ + 2 + n2_ - 1], &_k1);
            (void) _slaln2 (($81_ = FALSE, &$81_), &_k1, ($82_ = 2, &$82_), &smin_, ($83_ = 1.0, &$83_), &t_[j_ - 1 + ((*ldt_)) * 
            ((j_ - 1))], ldt_, ($84_ = 1.0, &$84_), ($85_ = 1.0, &$85_), &work_[j_ + (*n_) - 1], n_, &wr_, ($86_ = -wi_, &$86_), 
            x_, ($87_ = 2, &$87_), &scale_, &xnorm_, &ierr_);
            if (scale_ != 1.0) {
              (void) _sscal (($88_ = (*n_) - ki_ + 1, &$88_), &scale_, &work_[ki_ + (*n_) - 1], &_k1);
              (void) _sscal (($89_ = (*n_) - ki_ + 1, &$89_), &scale_, &work_[ki_ + n2_ - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            work_[j_ + n2_ - 1] = x_[2];
            vmax_ = ($90_ = _max (_abs (work_[j_ + (*n_) - 1]), _abs (work_[j_ + n2_ - 1])), _max ($90_, vmax_));
            vcrit_ = bignum_ / vmax_;
          }
          else {
            beta_ = _max (work_[j_ - 1], work_[j_ + 1 - 1]);
            if (beta_ > vcrit_) {
              rec_ = 1.0 / vmax_;
              (void) _sscal (($91_ = (*n_) - ki_ + 1, &$91_), &rec_, &work_[ki_ + (*n_) - 1], &_k1);
              (void) _sscal (($92_ = (*n_) - ki_ + 1, &$92_), &rec_, &work_[ki_ + n2_ - 1], &_k1);
              vmax_ = 1.0;
              vcrit_ = bignum_;
            }
            work_[j_ + (*n_) - 1] = work_[j_ + (*n_) - 1] - _sdot (($93_ = j_ - ki_ - 2, &$93_), &t_[ki_ + 2 - 1 + ((*ldt_)) * ((j_ 
            - 1))], &_k1, &work_[ki_ + 2 + (*n_) - 1], &_k1);
            work_[j_ + n2_ - 1] = work_[j_ + n2_ - 1] - _sdot (($94_ = j_ - ki_ - 2, &$94_), &t_[ki_ + 2 - 1 + ((*ldt_)) * ((j_ - 
            1))], &_k1, &work_[ki_ + 2 + n2_ - 1], &_k1);
            work_[j_ + 1 + (*n_) - 1] = work_[j_ + 1 + (*n_) - 1] - _sdot (($95_ = j_ - ki_ - 2, &$95_), &t_[ki_ + 2 - 1 + 
            ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &work_[ki_ + 2 + (*n_) - 1], &_k1);
            work_[j_ + 1 + n2_ - 1] = work_[j_ + 1 + n2_ - 1] - _sdot (($96_ = j_ - ki_ - 2, &$96_), &t_[ki_ + 2 - 1 + ((*ldt_)) * 
            ((j_ + 1 - 1))], &_k1, &work_[ki_ + 2 + n2_ - 1], &_k1);
            (void) _slaln2 (($97_ = TRUE, &$97_), ($98_ = 2, &$98_), ($99_ = 2, &$99_), &smin_, ($100_ = 1.0, &$100_), &t_[j_ - 1 + 
            ((*ldt_)) * ((j_ - 1))], ldt_, ($101_ = 1.0, &$101_), ($102_ = 1.0, &$102_), &work_[j_ + (*n_) - 1], n_, &wr_, ($103_ = 
            -wi_, &$103_), x_, ($104_ = 2, &$104_), &scale_, &xnorm_, &ierr_);
            if (scale_ != 1.0) {
              (void) _sscal (($105_ = (*n_) - ki_ + 1, &$105_), &scale_, &work_[ki_ + (*n_) - 1], &_k1);
              (void) _sscal (($106_ = (*n_) - ki_ + 1, &$106_), &scale_, &work_[ki_ + n2_ - 1], &_k1);
            }
            work_[j_ + (*n_) - 1] = x_[0];
            work_[j_ + n2_ - 1] = x_[2];
            work_[j_ + 1 + (*n_) - 1] = x_[1];
            work_[j_ + 1 + n2_ - 1] = x_[3];
            vmax_ = ($107_ = _max (_abs (x_[0]), _abs (x_[2])), $107_ = _max ($107_, _abs (x_[1])), $107_ = _max ($107_, _abs 
            (x_[3])), _max ($107_, vmax_));
            vcrit_ = bignum_ / vmax_;
          }
          _l200:;
        }
        if (! (over_)) {
          (void) _scopy (($108_ = (*n_) - ki_ + 1, &$108_), &work_[ki_ + (*n_) - 1], &_k1, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 
          1))], &_k1);
          (void) _scopy (($109_ = (*n_) - ki_ + 1, &$109_), &work_[ki_ + n2_ - 1], &_k1, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ + 1 - 
          1))], &_k1);
          emax_ = 0.0;
          for (k_ = ki_; k_ <= (*n_); (k_)++) {
            emax_ = _max (emax_, _abs (vl_[k_ - 1 + ((*ldvl_)) * ((is_ - 1))]) + _abs (vl_[k_ - 1 + ((*ldvl_)) * ((is_ + 1 - 1))]))
            ;
          }
          remax_ = 1.0 / emax_;
          (void) _sscal (($110_ = (*n_) - ki_ + 1, &$110_), &remax_, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1);
          (void) _sscal (($111_ = (*n_) - ki_ + 1, &$111_), &remax_, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ + 1 - 1))], &_k1);
          for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
            vl_[k_ - 1 + ((*ldvl_)) * ((is_ - 1))] = 0.0;
            vl_[k_ - 1 + ((*ldvl_)) * ((is_ + 1 - 1))] = 0.0;
          }
        }
        else {
          if (ki_ < (*n_) - 1) {
            (void) _sgemv (_dc_7, n_, ($112_ = (*n_) - ki_ - 1, &$112_), ($113_ = 1.0, &$113_), &vl_[0 + ((*ldvl_)) * ((ki_ + 2 - 
            1))], ldvl_, &work_[ki_ + 2 + (*n_) - 1], &_k1, &work_[ki_ + (*n_) - 1], &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
            (void) _sgemv (_dc_7, n_, ($114_ = (*n_) - ki_ - 1, &$114_), ($115_ = 1.0, &$115_), &vl_[0 + ((*ldvl_)) * ((ki_ + 2 - 
            1))], ldvl_, &work_[ki_ + 2 + n2_ - 1], &_k1, &work_[ki_ + 1 + n2_ - 1], &vl_[0 + ((*ldvl_)) * ((ki_ + 1 - 1))], &_k1)
            ;
          }
          else {
            (void) _sscal (n_, &work_[ki_ + (*n_) - 1], &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
            (void) _sscal (n_, &work_[ki_ + 1 + n2_ - 1], &vl_[0 + ((*ldvl_)) * ((ki_ + 1 - 1))], &_k1);
          }
          emax_ = 0.0;
          for (k_ = 1; k_ <= (*n_); (k_)++) {
            emax_ = _max (emax_, _abs (vl_[k_ - 1 + ((*ldvl_)) * ((ki_ - 1))]) + _abs (vl_[k_ - 1 + ((*ldvl_)) * ((ki_ + 1 - 1))]))
            ;
          }
          remax_ = 1.0 / emax_;
          (void) _sscal (n_, &remax_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
          (void) _sscal (n_, &remax_, &vl_[0 + ((*ldvl_)) * ((ki_ + 1 - 1))], &_k1);
        }
      }
      is_ = is_ + 1;
      if (ip_ != 0) {
        is_ = is_ + 1;
      }
      _l250:;
      if (ip_ == -1) {
        ip_ = 0;
      }
      if (ip_ == 1) {
        ip_ = -1;
      }
    }
  }
  _l0:;
  __calls[111].calls++;
  return 0;
}

int_4 _strexc (char _p_ compq_, int_4 _p_ n_, real_4 _p_ t_, int_4 _p_ ldt_, real_4 _p_ q_, int_4 _p_ ldq_, int_4 _p_ 
ifst_, int_4 _p_ ilst_, real_4 _p_ work_, int_4 _p_ info_)
{
  static int_4 here_, nbf_, nbl_, nbnext_;
  static logical_4 wantq_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  wantq_ = _lsame (compq_, _dc_40);
  if (! (wantq_) && ! (_lsame (compq_, _dc_7))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -4;
  }
  else if ((*ldq_) < 1 || (wantq_ && (*ldq_) < _max (1, (*n_)))) {
    (*info_) = -6;
  }
  else if ((*ifst_) < 1 || (*ifst_) > (*n_)) {
    (*info_) = -7;
  }
  else if ((*ilst_) < 1 || (*ilst_) > (*n_)) {
    (*info_) = -8;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_82, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) <= 1) {
    goto _l0;
  }
  if ((*ifst_) > 1) {
    if (t_[(*ifst_) - 1 + ((*ldt_)) * (((*ifst_) - 1 - 1))] != 0.0) {
      (*ifst_) = (*ifst_) - 1;
    }
  }
  nbf_ = 1;
  if ((*ifst_) < (*n_)) {
    if (t_[(*ifst_) + 1 - 1 + ((*ldt_)) * (((*ifst_) - 1))] != 0.0) {
      nbf_ = 2;
    }
  }
  if ((*ilst_) > 1) {
    if (t_[(*ilst_) - 1 + ((*ldt_)) * (((*ilst_) - 1 - 1))] != 0.0) {
      (*ilst_) = (*ilst_) - 1;
    }
  }
  nbl_ = 1;
  if ((*ilst_) < (*n_)) {
    if (t_[(*ilst_) + 1 - 1 + ((*ldt_)) * (((*ilst_) - 1))] != 0.0) {
      nbl_ = 2;
    }
  }
  if ((*ifst_) == (*ilst_)) {
    goto _l0;
  }
  if ((*ifst_) < (*ilst_)) {
    if (nbf_ == 2 && nbl_ == 1) {
      (*ilst_) = (*ilst_) - 1;
    }
    if (nbf_ == 1 && nbl_ == 2) {
      (*ilst_) = (*ilst_) + 1;
    }
    here_ = (*ifst_);
    _l10:;
    if (nbf_ == 1 || nbf_ == 2) {
      nbnext_ = 1;
      if (here_ + nbf_ + 1 <= (*n_)) {
        if (t_[here_ + nbf_ + 1 - 1 + ((*ldt_)) * ((here_ + nbf_ - 1))] != 0.0) {
          nbnext_ = 2;
        }
      }
      (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &nbf_, &nbnext_, work_, info_);
      if ((*info_) != 0) {
        (*ilst_) = here_;
        goto _l0;
      }
      here_ = here_ + nbnext_;
      if (nbf_ == 2) {
        if (t_[here_ + 1 - 1 + ((*ldt_)) * ((here_ - 1))] == 0.0) {
          nbf_ = 3;
        }
      }
    }
    else {
      nbnext_ = 1;
      if (here_ + 3 <= (*n_)) {
        if (t_[here_ + 3 - 1 + ((*ldt_)) * ((here_ + 2 - 1))] != 0.0) {
          nbnext_ = 2;
        }
      }
      (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($1_ = here_ + 1, &$1_), &_k1, &nbnext_, work_, info_);
      if ((*info_) != 0) {
        (*ilst_) = here_;
        goto _l0;
      }
      if (nbnext_ == 1) {
        (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &_k1, &nbnext_, work_, info_);
        here_ = here_ + 1;
      }
      else {
        if (t_[here_ + 2 - 1 + ((*ldt_)) * ((here_ + 1 - 1))] == 0.0) {
          nbnext_ = 1;
        }
        if (nbnext_ == 2) {
          (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &_k1, &nbnext_, work_, info_);
          if ((*info_) != 0) {
            (*ilst_) = here_;
            goto _l0;
          }
          here_ = here_ + 2;
        }
        else {
          (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &_k1, &_k1, work_, info_);
          (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($2_ = here_ + 1, &$2_), &_k1, &_k1, work_, info_);
          here_ = here_ + 2;
        }
      }
    }
    if (here_ < (*ilst_)) {
      goto _l10;
    }
  }
  else {
    here_ = (*ifst_);
    _l20:;
    if (nbf_ == 1 || nbf_ == 2) {
      nbnext_ = 1;
      if (here_ >= 3) {
        if (t_[here_ - 1 - 1 + ((*ldt_)) * ((here_ - 2 - 1))] != 0.0) {
          nbnext_ = 2;
        }
      }
      (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($3_ = here_ - nbnext_, &$3_), &nbnext_, &nbf_, work_, info_);
      if ((*info_) != 0) {
        (*ilst_) = here_;
        goto _l0;
      }
      here_ = here_ - nbnext_;
      if (nbf_ == 2) {
        if (t_[here_ + 1 - 1 + ((*ldt_)) * ((here_ - 1))] == 0.0) {
          nbf_ = 3;
        }
      }
    }
    else {
      nbnext_ = 1;
      if (here_ >= 3) {
        if (t_[here_ - 1 - 1 + ((*ldt_)) * ((here_ - 2 - 1))] != 0.0) {
          nbnext_ = 2;
        }
      }
      (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($4_ = here_ - nbnext_, &$4_), &nbnext_, &_k1, work_, info_);
      if ((*info_) != 0) {
        (*ilst_) = here_;
        goto _l0;
      }
      if (nbnext_ == 1) {
        (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &nbnext_, &_k1, work_, info_);
        here_ = here_ - 1;
      }
      else {
        if (t_[here_ - 1 + ((*ldt_)) * ((here_ - 1 - 1))] == 0.0) {
          nbnext_ = 1;
        }
        if (nbnext_ == 2) {
          (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($5_ = here_ - 1, &$5_), ($6_ = 2, &$6_), &_k1, work_, info_);
          if ((*info_) != 0) {
            (*ilst_) = here_;
            goto _l0;
          }
          here_ = here_ - 2;
        }
        else {
          (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, &here_, &_k1, &_k1, work_, info_);
          (void) _slaexc (&wantq_, n_, t_, ldt_, q_, ldq_, ($7_ = here_ - 1, &$7_), &_k1, &_k1, work_, info_);
          here_ = here_ - 2;
        }
      }
    }
    if (here_ > (*ilst_)) {
      goto _l20;
    }
  }
  (*ilst_) = here_;
  _l0:;
  __calls[112].calls++;
  return 0;
}

int_4 _strsen (char _p_ job_, char _p_ compq_, logical_4 _p_ select_, int_4 _p_ n_, real_4 _p_ t_, int_4 _p_ ldt_, 
real_4 _p_ q_, int_4 _p_ ldq_, real_4 _p_ wr_, real_4 _p_ wi_, int_4 _p_ m_, real_4 _p_ s_, real_4 _p_ sep_, real_4 _p_ 
work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ info_)
{
  static int_4 ierr_, k_, kase_, kk_, ks_, n1_, n2_, nn_;
  static logical_4 pair_, swap_, wantbh_, wantq_, wants_, wantsp_;
  static real_4 est_, rnorm_, scale_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  wantbh_ = _lsame (job_, _dc_31);
  wants_ = _lsame (job_, _dc_27) || wantbh_;
  wantsp_ = _lsame (job_, _dc_40) || wantbh_;
  wantq_ = _lsame (compq_, _dc_40);
  (*info_) = 0;
  if (! (_lsame (job_, _dc_7)) && ! (wants_) && ! (wantsp_)) {
    (*info_) = -1;
  }
  else if (! (_lsame (compq_, _dc_7)) && ! (wantq_)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  else if ((*ldq_) < 1 || (wantq_ && (*ldq_) < (*n_))) {
    (*info_) = -8;
  }
  else {
    (*m_) = 0;
    pair_ = FALSE;
    for (k_ = 1; k_ <= (*n_); (k_)++) {
      if (pair_) {
        pair_ = FALSE;
      }
      else {
        if (k_ < (*n_)) {
          if (t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0) {
            if (select_[k_ - 1]) {
              (*m_) = (*m_) + 1;
            }
          }
          else {
            pair_ = TRUE;
            if (select_[k_ - 1] || select_[k_ + 1 - 1]) {
              (*m_) = (*m_) + 2;
            }
          }
        }
        else {
          if (select_[(*n_) - 1]) {
            (*m_) = (*m_) + 1;
          }
        }
      }
    }
    n1_ = (*m_);
    n2_ = (*n_) - (*m_);
    nn_ = n1_ * n2_;
    if ((*lwork_) < 1 || ((wants_ && ! (wantsp_)) && (*lwork_) < nn_) || (wantsp_ && (*lwork_) < 2 * nn_)) {
      (*info_) = -15;
    }
    else if ((*liwork_) < 1 || (wantsp_ && (*liwork_) < nn_)) {
      (*info_) = -17;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_83, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == (*n_) || (*m_) == 0) {
    if (wants_) {
      (*s_) = 1.0;
    }
    if (wantsp_) {
      (*sep_) = _slange (_dc_22, n_, n_, t_, ldt_, work_);
    }
    goto _l40;
  }
  ks_ = 0;
  pair_ = FALSE;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (pair_) {
      pair_ = FALSE;
    }
    else {
      swap_ = select_[k_ - 1];
      if (k_ < (*n_)) {
        if (t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))] != 0.0) {
          pair_ = TRUE;
          swap_ = swap_ || select_[k_ + 1 - 1];
        }
      }
      if (swap_) {
        ks_ = ks_ + 1;
        ierr_ = 0;
        kk_ = k_;
        if (k_ != ks_) {
          (void) _strexc (compq_, n_, t_, ldt_, q_, ldq_, &kk_, &ks_, work_, &ierr_);
        }
        if (ierr_ == 1 || ierr_ == 2) {
          (*info_) = 1;
          if (wants_) {
            (*s_) = 0.0;
          }
          if (wantsp_) {
            (*sep_) = 0.0;
          }
          goto _l40;
        }
        if (pair_) {
          ks_ = ks_ + 1;
        }
      }
    }
  }
  if (wants_) {
    (void) _slacpy (_dc_26, &n1_, &n2_, &t_[0 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, &n1_);
    (void) _strsyl (_dc_7, _dc_7, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
    &n1_, &scale_, &ierr_);
    rnorm_ = _slange (_dc_26, &n1_, &n2_, work_, &n1_, work_);
    if (rnorm_ == 0.0) {
      (*s_) = 1.0;
    }
    else {
      (*s_) = scale_ / (sqrtf (scale_ * scale_ / rnorm_ + rnorm_) * sqrtf (rnorm_));
    }
  }
  if (wantsp_) {
    est_ = 0.0;
    kase_ = 0;
    _l30:;
    (void) _slacon (&nn_, &work_[nn_ + 1 - 1], work_, iwork_, &est_, &kase_);
    if (kase_ != 0) {
      if (kase_ == 1) {
        (void) _strsyl (_dc_7, _dc_7, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
        &n1_, &scale_, &ierr_);
      }
      else {
        (void) _strsyl (_dc_8, _dc_8, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
        &n1_, &scale_, &ierr_);
      }
      goto _l30;
    }
    (*sep_) = scale_ / est_;
  }
  _l40:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    wr_[k_ - 1] = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    wi_[k_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*n_) - 1; (k_)++) {
    if (t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))] != 0.0) {
      wi_[k_ - 1] = sqrtf (_abs (t_[k_ - 1 + ((*ldt_)) * ((k_ + 1 - 1))])) * sqrtf (_abs (t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 
      1))]));
      wi_[k_ + 1 - 1] = -wi_[k_ - 1];
    }
  }
  _l0:;
  __calls[113].calls++;
  return 0;
}

int_4 _strsyl (char _p_ trana_, char _p_ tranb_, int_4 _p_ isgn_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ 
lda_, real_4 _p_ b_, int_4 _p_ ldb_, real_4 _p_ c_, int_4 _p_ ldc_, real_4 _p_ scale_, int_4 _p_ info_)
{
  static int_4 ierr_, j_, k_, k1_, k2_, knext_, l_, l1_, l2_, lnext_;
  static logical_4 notrna_, notrnb_;
  static real_4 a11_, bignum_, da11_, db_, eps_, scaloc_, sgn_, smin_, smlnum_, suml_, sumr_, xnorm_, dum_[1], vec_[4], 
  x_[4];
  int_4 $0_, $2_, $3_, $4_, $5_, $6_, $7_, $9_, $13_, $16_, $17_, $18_, $19_, $20_, $22_, $26_, $29_, $30_, $31_, $32_, 
  $33_, $34_, $35_, $36_, $37_, $40_, $41_, $42_, $43_, $44_, $45_, $46_, $47_, $48_, $49_, $51_, $55_, $58_, $59_, $60_, 
  $61_, $62_, $64_, $68_, $71_, $72_, $73_, $74_, $75_, $76_, $77_, $78_, $79_, $82_, $83_, $84_, $85_, $86_, $87_, $88_, 
  $89_, $90_, $91_, $93_, $97_, $100_, $101_, $102_, $103_, $104_, $106_, $110_, $113_, $114_, $115_, $116_, $117_, $118_
  , $119_, $120_, $121_, $124_, $125_, $126_, $127_, $128_, $129_, $130_, $131_, $132_, $133_, $135_, $139_, $142_, $143_
  , $144_, $145_, $146_, $148_, $152_, $155_, $156_, $157_, $158_, $159_, $160_, $161_, $162_, $163_, $166_, $167_, $168_
  , $169_;
  logical_4 $8_, $21_, $38_, $39_, $50_, $63_, $80_, $81_, $92_, $105_, $122_, $123_, $134_, $147_, $164_, $165_;
  real_4 $1_, $10_, $11_, $12_, $14_, $15_, $23_, $24_, $25_, $27_, $28_, $52_, $53_, $54_, $56_, $57_, $65_, $66_, $67_, 
  $69_, $70_, $94_, $95_, $96_, $98_, $99_, $107_, $108_, $109_, $111_, $112_, $136_, $137_, $138_, $140_, $141_, $149_, 
  $150_, $151_, $153_, $154_;
  extern logical_4 _lsame ();
  extern real_4 _sdot ();
  extern int_4 _sscal ();
  extern int_4 _xerbla ();
  notrna_ = _lsame (trana_, _dc_7);
  notrnb_ = _lsame (tranb_, _dc_7);
  (*info_) = 0;
  if (! (notrna_) && ! (_lsame (trana_, _dc_8)) && ! (_lsame (trana_, _dc_9))) {
    (*info_) = -1;
  }
  else if (! (notrnb_) && ! (_lsame (tranb_, _dc_8)) && ! (_lsame (tranb_, _dc_9))) {
    (*info_) = -2;
  }
  else if ((*isgn_) != 1 && (*isgn_) != -1) {
    (*info_) = -3;
  }
  else if ((*m_) < 0) {
    (*info_) = -4;
  }
  else if ((*n_) < 0) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -7;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -11;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_84, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  eps_ = _slamch (_dc_44);
  smlnum_ = _slamch (_dc_28);
  bignum_ = 1.0 / smlnum_;
  (void) _slabad (&smlnum_, &bignum_);
  smlnum_ = smlnum_ * (real_4) ((*m_) * (*n_)) / eps_;
  bignum_ = 1.0 / smlnum_;
  smin_ = ($1_ = _max (smlnum_, eps_ * _slange (_dc_23, m_, m_, a_, lda_, dum_)), _max ($1_, eps_ * _slange (_dc_23, n_, 
  n_, b_, ldb_, dum_)));
  (*scale_) = 1.0;
  sgn_ = (*isgn_);
  if (notrna_ && notrnb_) {
    lnext_ = 1;
    for (l_ = 1; l_ <= (*n_); (l_)++) {
      if (l_ < lnext_) {
        goto _l70;
      }
      if (l_ == (*n_)) {
        l1_ = l_;
        l2_ = l_;
      }
      else {
        if (b_[l_ + 1 - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0) {
          l1_ = l_;
          l2_ = l_ + 1;
          lnext_ = l_ + 2;
        }
        else {
          l1_ = l_;
          l2_ = l_;
          lnext_ = l_ + 1;
        }
      }
      knext_ = (*m_);
      for (k_ = (*m_); k_ >= 1; (k_)--) {
        if (k_ > knext_) {
          goto _l60;
        }
        if (k_ == 1) {
          k1_ = k_;
          k2_ = k_;
        }
        else {
          if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] != 0.0) {
            k1_ = k_ - 1;
            k2_ = k_;
            knext_ = k_ - 2;
          }
          else {
            k1_ = k_;
            k2_ = k_;
            knext_ = k_ - 1;
          }
        }
        if (l1_ == l2_ && k1_ == k2_) {
          suml_ = _sdot (($2_ = (*m_) - k1_, &$2_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min (k1_ 
          + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($3_ = l1_ - 1, &$3_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          scaloc_ = 1.0;
          a11_ = a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))] + sgn_ * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))];
          da11_ = _abs (a11_);
          if (da11_ <= smin_) {
            a11_ = smin_;
            da11_ = smin_;
            (*info_) = 1;
          }
          db_ = _abs (vec_[0]);
          if (da11_ < 1.0 && db_ > 1.0) {
            if (db_ > bignum_ * da11_) {
              scaloc_ = 1.0 / db_;
            }
          }
          x_[0] = (vec_[0] * scaloc_) / a11_;
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
        }
        else if (l1_ == l2_ && k1_ != k2_) {
          suml_ = _sdot (($4_ = (*m_) - k2_, &$4_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min (k2_ 
          + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($5_ = l1_ - 1, &$5_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($6_ = (*m_) - k2_, &$6_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min (k2_ 
          + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($7_ = l1_ - 1, &$7_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _slaln2 (($8_ = FALSE, &$8_), ($9_ = 2, &$9_), &_k1, &smin_, ($10_ = 1.0, &$10_), &a_[k1_ - 1 + ((*lda_)) * 
          ((k1_ - 1))], lda_, ($11_ = 1.0, &$11_), ($12_ = 1.0, &$12_), vec_, ($13_ = 2, &$13_), ($14_ = -sgn_ * b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], &$14_), ($15_ = 0.0, &$15_), x_, ($16_ = 2, &$16_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ == k2_) {
          suml_ = _sdot (($17_ = (*m_) - k1_, &$17_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($18_ = l1_ - 1, &$18_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_));
          suml_ = _sdot (($19_ = (*m_) - k1_, &$19_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _sdot (($20_ = l1_ - 1, &$20_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[1] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_));
          (void) _slaln2 (($21_ = TRUE, &$21_), ($22_ = 2, &$22_), &_k1, &smin_, ($23_ = 1.0, &$23_), &b_[l1_ - 1 + ((*ldb_)) * 
          ((l1_ - 1))], ldb_, ($24_ = 1.0, &$24_), ($25_ = 1.0, &$25_), vec_, ($26_ = 2, &$26_), ($27_ = -sgn_ * a_[k1_ - 1 + 
          ((*lda_)) * ((k1_ - 1))], &$27_), ($28_ = 0.0, &$28_), x_, ($29_ = 2, &$29_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ != k2_) {
          suml_ = _sdot (($30_ = (*m_) - k2_, &$30_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($31_ = l1_ - 1, &$31_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($32_ = (*m_) - k2_, &$32_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _sdot (($33_ = l1_ - 1, &$33_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[2] = c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($34_ = (*m_) - k2_, &$34_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($35_ = l1_ - 1, &$35_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($36_ = (*m_) - k2_, &$36_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _sdot (($37_ = l1_ - 1, &$37_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[3] = c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _slasy2 (($38_ = FALSE, &$38_), ($39_ = FALSE, &$39_), isgn_, ($40_ = 2, &$40_), ($41_ = 2, &$41_), &a_[k1_ - 1 
          + ((*lda_)) * ((k1_ - 1))], lda_, &b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], ldb_, vec_, ($42_ = 2, &$42_), &scaloc_, x_, 
          ($43_ = 2, &$43_), &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[2];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
          c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[3];
        }
        _l60:;
      }
      _l70:;
    }
  }
  else if (! (notrna_) && notrnb_) {
    lnext_ = 1;
    for (l_ = 1; l_ <= (*n_); (l_)++) {
      if (l_ < lnext_) {
        goto _l130;
      }
      if (l_ == (*n_)) {
        l1_ = l_;
        l2_ = l_;
      }
      else {
        if (b_[l_ + 1 - 1 + ((*ldb_)) * ((l_ - 1))] != 0.0) {
          l1_ = l_;
          l2_ = l_ + 1;
          lnext_ = l_ + 2;
        }
        else {
          l1_ = l_;
          l2_ = l_;
          lnext_ = l_ + 1;
        }
      }
      knext_ = 1;
      for (k_ = 1; k_ <= (*m_); (k_)++) {
        if (k_ < knext_) {
          goto _l120;
        }
        if (k_ == (*m_)) {
          k1_ = k_;
          k2_ = k_;
        }
        else {
          if (a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
            k1_ = k_;
            k2_ = k_ + 1;
            knext_ = k_ + 2;
          }
          else {
            k1_ = k_;
            k2_ = k_;
            knext_ = k_ + 1;
          }
        }
        if (l1_ == l2_ && k1_ == k2_) {
          suml_ = _sdot (($44_ = k1_ - 1, &$44_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($45_ = l1_ - 1, &$45_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          scaloc_ = 1.0;
          a11_ = a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))] + sgn_ * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))];
          da11_ = _abs (a11_);
          if (da11_ <= smin_) {
            a11_ = smin_;
            da11_ = smin_;
            (*info_) = 1;
          }
          db_ = _abs (vec_[0]);
          if (da11_ < 1.0 && db_ > 1.0) {
            if (db_ > bignum_ * da11_) {
              scaloc_ = 1.0 / db_;
            }
          }
          x_[0] = (vec_[0] * scaloc_) / a11_;
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
        }
        else if (l1_ == l2_ && k1_ != k2_) {
          suml_ = _sdot (($46_ = k1_ - 1, &$46_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($47_ = l1_ - 1, &$47_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($48_ = k1_ - 1, &$48_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($49_ = l1_ - 1, &$49_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _slaln2 (($50_ = TRUE, &$50_), ($51_ = 2, &$51_), &_k1, &smin_, ($52_ = 1.0, &$52_), &a_[k1_ - 1 + ((*lda_)) * 
          ((k1_ - 1))], lda_, ($53_ = 1.0, &$53_), ($54_ = 1.0, &$54_), vec_, ($55_ = 2, &$55_), ($56_ = -sgn_ * b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], &$56_), ($57_ = 0.0, &$57_), x_, ($58_ = 2, &$58_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ == k2_) {
          suml_ = _sdot (($59_ = k1_ - 1, &$59_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($60_ = l1_ - 1, &$60_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_));
          suml_ = _sdot (($61_ = k1_ - 1, &$61_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($62_ = l1_ - 1, &$62_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[1] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_));
          (void) _slaln2 (($63_ = TRUE, &$63_), ($64_ = 2, &$64_), &_k1, &smin_, ($65_ = 1.0, &$65_), &b_[l1_ - 1 + ((*ldb_)) * 
          ((l1_ - 1))], ldb_, ($66_ = 1.0, &$66_), ($67_ = 1.0, &$67_), vec_, ($68_ = 2, &$68_), ($69_ = -sgn_ * a_[k1_ - 1 + 
          ((*lda_)) * ((k1_ - 1))], &$69_), ($70_ = 0.0, &$70_), x_, ($71_ = 2, &$71_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ != k2_) {
          suml_ = _sdot (($72_ = k1_ - 1, &$72_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($73_ = l1_ - 1, &$73_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($74_ = k1_ - 1, &$74_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($75_ = l1_ - 1, &$75_), &c_[k1_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[2] = c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($76_ = k1_ - 1, &$76_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($77_ = l1_ - 1, &$77_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l1_ - 1))], &_k1)
          ;
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($78_ = k1_ - 1, &$78_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($79_ = l1_ - 1, &$79_), &c_[k2_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l2_ - 1))], &_k1)
          ;
          vec_[3] = c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _slasy2 (($80_ = TRUE, &$80_), ($81_ = FALSE, &$81_), isgn_, ($82_ = 2, &$82_), ($83_ = 2, &$83_), &a_[k1_ - 1 + 
          ((*lda_)) * ((k1_ - 1))], lda_, &b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], ldb_, vec_, ($84_ = 2, &$84_), &scaloc_, x_, 
          ($85_ = 2, &$85_), &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[2];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
          c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[3];
        }
        _l120:;
      }
      _l130:;
    }
  }
  else if (! (notrna_) && ! (notrnb_)) {
    lnext_ = (*n_);
    for (l_ = (*n_); l_ >= 1; (l_)--) {
      if (l_ > lnext_) {
        goto _l190;
      }
      if (l_ == 1) {
        l1_ = l_;
        l2_ = l_;
      }
      else {
        if (b_[l_ - 1 + ((*ldb_)) * ((l_ - 1 - 1))] != 0.0) {
          l1_ = l_ - 1;
          l2_ = l_;
          lnext_ = l_ - 2;
        }
        else {
          l1_ = l_;
          l2_ = l_;
          lnext_ = l_ - 1;
        }
      }
      knext_ = 1;
      for (k_ = 1; k_ <= (*m_); (k_)++) {
        if (k_ < knext_) {
          goto _l180;
        }
        if (k_ == (*m_)) {
          k1_ = k_;
          k2_ = k_;
        }
        else {
          if (a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))] != 0.0) {
            k1_ = k_;
            k2_ = k_ + 1;
            knext_ = k_ + 2;
          }
          else {
            k1_ = k_;
            k2_ = k_;
            knext_ = k_ + 1;
          }
        }
        if (l1_ == l2_ && k1_ == k2_) {
          suml_ = _sdot (($86_ = k1_ - 1, &$86_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($87_ = (*n_) - l1_, &$87_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l1_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 1 
          + ((*ldb_)) * ((_min (l1_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          scaloc_ = 1.0;
          a11_ = a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))] + sgn_ * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))];
          da11_ = _abs (a11_);
          if (da11_ <= smin_) {
            a11_ = smin_;
            da11_ = smin_;
            (*info_) = 1;
          }
          db_ = _abs (vec_[0]);
          if (da11_ < 1.0 && db_ > 1.0) {
            if (db_ > bignum_ * da11_) {
              scaloc_ = 1.0 / db_;
            }
          }
          x_[0] = (vec_[0] * scaloc_) / a11_;
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
        }
        else if (l1_ == l2_ && k1_ != k2_) {
          suml_ = _sdot (($88_ = k1_ - 1, &$88_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($89_ = (*n_) - l2_, &$89_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 1 
          + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($90_ = k1_ - 1, &$90_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], &_k1)
          ;
          sumr_ = _sdot (($91_ = (*n_) - l2_, &$91_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 1 
          + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _slaln2 (($92_ = TRUE, &$92_), ($93_ = 2, &$93_), &_k1, &smin_, ($94_ = 1.0, &$94_), &a_[k1_ - 1 + ((*lda_)) * 
          ((k1_ - 1))], lda_, ($95_ = 1.0, &$95_), ($96_ = 1.0, &$96_), vec_, ($97_ = 2, &$97_), ($98_ = -sgn_ * b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], &$98_), ($99_ = 0.0, &$99_), x_, ($100_ = 2, &$100_), &scaloc_, &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ == k2_) {
          suml_ = _sdot (($101_ = k1_ - 1, &$101_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], 
          &_k1);
          sumr_ = _sdot (($102_ = (*n_) - l2_, &$102_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_));
          suml_ = _sdot (($103_ = k1_ - 1, &$103_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], 
          &_k1);
          sumr_ = _sdot (($104_ = (*n_) - l2_, &$104_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_));
          (void) _slaln2 (($105_ = FALSE, &$105_), ($106_ = 2, &$106_), &_k1, &smin_, ($107_ = 1.0, &$107_), &b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], ldb_, ($108_ = 1.0, &$108_), ($109_ = 1.0, &$109_), vec_, ($110_ = 2, &$110_), ($111_ = -sgn_ 
          * a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))], &$111_), ($112_ = 0.0, &$112_), x_, ($113_ = 2, &$113_), &scaloc_, &xnorm_, 
          &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ != k2_) {
          suml_ = _sdot (($114_ = k1_ - 1, &$114_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], 
          &_k1);
          sumr_ = _sdot (($115_ = (*n_) - l2_, &$115_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($116_ = k1_ - 1, &$116_), &a_[0 + ((*lda_)) * ((k1_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], 
          &_k1);
          sumr_ = _sdot (($117_ = (*n_) - l2_, &$117_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[2] = c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($118_ = k1_ - 1, &$118_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l1_ - 1))], 
          &_k1);
          sumr_ = _sdot (($119_ = (*n_) - l2_, &$119_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($120_ = k1_ - 1, &$120_), &a_[0 + ((*lda_)) * ((k2_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l2_ - 1))], 
          &_k1);
          sumr_ = _sdot (($121_ = (*n_) - l2_, &$121_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[3] = c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _slasy2 (($122_ = TRUE, &$122_), ($123_ = TRUE, &$123_), isgn_, ($124_ = 2, &$124_), ($125_ = 2, &$125_), 
          &a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))], lda_, &b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], ldb_, vec_, ($126_ = 2, &$126_), 
          &scaloc_, x_, ($127_ = 2, &$127_), &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[2];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
          c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[3];
        }
        _l180:;
      }
      _l190:;
    }
  }
  else if (notrna_ && ! (notrnb_)) {
    lnext_ = (*n_);
    for (l_ = (*n_); l_ >= 1; (l_)--) {
      if (l_ > lnext_) {
        goto _l250;
      }
      if (l_ == 1) {
        l1_ = l_;
        l2_ = l_;
      }
      else {
        if (b_[l_ - 1 + ((*ldb_)) * ((l_ - 1 - 1))] != 0.0) {
          l1_ = l_ - 1;
          l2_ = l_;
          lnext_ = l_ - 2;
        }
        else {
          l1_ = l_;
          l2_ = l_;
          lnext_ = l_ - 1;
        }
      }
      knext_ = (*m_);
      for (k_ = (*m_); k_ >= 1; (k_)--) {
        if (k_ > knext_) {
          goto _l240;
        }
        if (k_ == 1) {
          k1_ = k_;
          k2_ = k_;
        }
        else {
          if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] != 0.0) {
            k1_ = k_ - 1;
            k2_ = k_;
            knext_ = k_ - 2;
          }
          else {
            k1_ = k_;
            k2_ = k_;
            knext_ = k_ - 1;
          }
        }
        if (l1_ == l2_ && k1_ == k2_) {
          suml_ = _sdot (($128_ = (*m_) - k1_, &$128_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($129_ = (*n_) - l1_, &$129_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l1_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l1_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          scaloc_ = 1.0;
          a11_ = a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))] + sgn_ * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))];
          da11_ = _abs (a11_);
          if (da11_ <= smin_) {
            a11_ = smin_;
            da11_ = smin_;
            (*info_) = 1;
          }
          db_ = _abs (vec_[0]);
          if (da11_ < 1.0 && db_ > 1.0) {
            if (db_ > bignum_ * da11_) {
              scaloc_ = 1.0 / db_;
            }
          }
          x_[0] = (vec_[0] * scaloc_) / a11_;
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
        }
        else if (l1_ == l2_ && k1_ != k2_) {
          suml_ = _sdot (($130_ = (*m_) - k2_, &$130_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($131_ = (*n_) - l2_, &$131_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($132_ = (*m_) - k2_, &$132_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($133_ = (*n_) - l2_, &$133_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _slaln2 (($134_ = FALSE, &$134_), ($135_ = 2, &$135_), &_k1, &smin_, ($136_ = 1.0, &$136_), &a_[k1_ - 1 + 
          ((*lda_)) * ((k1_ - 1))], lda_, ($137_ = 1.0, &$137_), ($138_ = 1.0, &$138_), vec_, ($139_ = 2, &$139_), ($140_ = -sgn_ 
          * b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], &$140_), ($141_ = 0.0, &$141_), x_, ($142_ = 2, &$142_), &scaloc_, &xnorm_, 
          &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ == k2_) {
          suml_ = _sdot (($143_ = (*m_) - k1_, &$143_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($144_ = (*n_) - l2_, &$144_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_));
          suml_ = _sdot (($145_ = (*m_) - k1_, &$145_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k1_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k1_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _sdot (($146_ = (*n_) - l2_, &$146_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = sgn_ * (c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_));
          (void) _slaln2 (($147_ = FALSE, &$147_), ($148_ = 2, &$148_), &_k1, &smin_, ($149_ = 1.0, &$149_), &b_[l1_ - 1 + 
          ((*ldb_)) * ((l1_ - 1))], ldb_, ($150_ = 1.0, &$150_), ($151_ = 1.0, &$151_), vec_, ($152_ = 2, &$152_), ($153_ = -sgn_ 
          * a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))], &$153_), ($154_ = 0.0, &$154_), x_, ($155_ = 2, &$155_), &scaloc_, &xnorm_, 
          &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[1];
        }
        else if (l1_ != l2_ && k1_ != k2_) {
          suml_ = _sdot (($156_ = (*m_) - k2_, &$156_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($157_ = (*n_) - l2_, &$157_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[0] = c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($158_ = (*m_) - k2_, &$158_), &a_[k1_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _sdot (($159_ = (*n_) - l2_, &$159_), &c_[k1_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[2] = c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($160_ = (*m_) - k2_, &$160_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l1_ - 1))], &_k1);
          sumr_ = _sdot (($161_ = (*n_) - l2_, &$161_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l1_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[1] = c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] - (suml_ + sgn_ * sumr_);
          suml_ = _sdot (($162_ = (*m_) - k2_, &$162_), &a_[k2_ - 1 + ((*lda_)) * ((_min (k2_ + 1, (*m_)) - 1))], lda_, &c_[_min 
          (k2_ + 1, (*m_)) - 1 + ((*ldc_)) * ((l2_ - 1))], &_k1);
          sumr_ = _sdot (($163_ = (*n_) - l2_, &$163_), &c_[k2_ - 1 + ((*ldc_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldc_, &b_[l2_ - 
          1 + ((*ldb_)) * ((_min (l2_ + 1, (*n_)) - 1))], ldb_);
          vec_[3] = c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] - (suml_ + sgn_ * sumr_);
          (void) _slasy2 (($164_ = FALSE, &$164_), ($165_ = TRUE, &$165_), isgn_, ($166_ = 2, &$166_), ($167_ = 2, &$167_), 
          &a_[k1_ - 1 + ((*lda_)) * ((k1_ - 1))], lda_, &b_[l1_ - 1 + ((*ldb_)) * ((l1_ - 1))], ldb_, vec_, ($168_ = 2, &$168_), 
          &scaloc_, x_, ($169_ = 2, &$169_), &xnorm_, &ierr_);
          if (ierr_ != 0) {
            (*info_) = 1;
          }
          if (scaloc_ != 1.0) {
            for (j_ = 1; j_ <= (*n_); (j_)++) {
              (void) _sscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
            }
            (*scale_) = (*scale_) * scaloc_;
          }
          c_[k1_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[0];
          c_[k1_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[2];
          c_[k2_ - 1 + ((*ldc_)) * ((l1_ - 1))] = x_[1];
          c_[k2_ - 1 + ((*ldc_)) * ((l2_ - 1))] = x_[3];
        }
        _l240:;
      }
      _l250:;
    }
  }
  _l0:;
  __calls[114].calls++;
  return 0;
}

int_4 _xlaenv (int_4 _p_ ispec_, int_4 _p_ nvalue_)
{
  if ((*ispec_) >= 1 && (*ispec_) <= 8) {
    claenv_.iparms_[(*ispec_) - 1] = (*nvalue_);
  }
  __calls[115].calls++;
  return 0;
}

int_4 _zgbtf2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_16 _p_ ab_, int_4 _p_ ldab_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_, j_, jp_, ju_, km_, kv_;
  int_4 $0_, $1_, $2_, $3_, $4_, $6_, $8_, $9_;
  complex_16 $5_, $7_;
  extern int_4 _izamax ();
  extern int_4 _xerbla ();
  extern int_4 _zgeru ();
  extern int_4 _zscal ();
  extern int_4 _zswap ();
  kv_ = (*ku_) + (*kl_);
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldab_) < (*kl_) + kv_ + 1) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_85, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  for (j_ = (*ku_) + 2; j_ <= _min (kv_, (*n_)); (j_)++) {
    for (i_ = kv_ - j_ + 2; i_ <= (*kl_); (i_)++) {
      ab_[i_ - 1 + ((*ldab_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
    }
  }
  ju_ = 1;
  for (j_ = 1; j_ <= _min ((*m_), (*n_)); (j_)++) {
    if (j_ + kv_ <= (*n_)) {
      for (i_ = 1; i_ <= (*kl_); (i_)++) {
        ab_[i_ - 1 + ((*ldab_)) * ((j_ + kv_ - 1))] = CMPLX (0.0, 0.0);
      }
    }
    km_ = _min ((*kl_), (*m_) - j_);
    jp_ = _izamax (($1_ = km_ + 1, &$1_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1);
    ipiv_[j_ - 1] = jp_ + j_ - 1;
    if (ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((j_ - 1))] != CMPLX (0.0, 0.0)) {
      ju_ = _max (ju_, _min (j_ + (*ku_) + jp_ - 1, (*n_)));
      if (jp_ != 1) {
        (void) _zswap (($2_ = ju_ - j_ + 1, &$2_), &ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((j_ - 1))], ($3_ = (*ldab_) - 1, &$3_), 
        &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], ($4_ = (*ldab_) - 1, &$4_));
      }
      if (km_ > 0) {
        (void) _zscal (&km_, ($5_ = CMPLX (1.0, 0.0) / ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &$5_), &ab_[kv_ + 2 - 1 + 
        ((*ldab_)) * ((j_ - 1))], &_k1);
        if (ju_ > j_) {
          (void) _zgeru (&km_, ($6_ = ju_ - j_, &$6_), ($7_ = CMPLX (-1.0, 0.0), &$7_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * ((j_ - 
          1))], &_k1, &ab_[kv_ - 1 + ((*ldab_)) * ((j_ + 1 - 1))], ($8_ = (*ldab_) - 1, &$8_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * 
          ((j_ + 1 - 1))], ($9_ = (*ldab_) - 1, &$9_));
        }
      }
    }
    else {
      if ((*info_) == 0) {
        (*info_) = j_;
      }
    }
  }
  _l0:;
  __calls[116].calls++;
  return 0;
}

int_4 _zgbtrf (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, complex_16 _p_ ab_, int_4 _p_ ldab_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_, i2_, i3_, ii_, ip_, j_, j2_, j3_, jb_, jj_, jm_, jp_, ju_, k2_, km_, kv_, nb_, nw_;
  static complex_16 temp_, work13_[4160], work31_[4160];
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $11_, $13_, $14_, $15_, $17_, $18_, $20_, $21_, $23_, $25_, 
  $26_, $28_, $30_, $31_, $33_, $34_, $36_, $38_, $39_, $41_, $42_, $43_, $44_, $45_, $46_, $47_;
  complex_16 $10_, $12_, $16_, $19_, $22_, $24_, $27_, $29_, $32_, $35_, $37_, $40_;
  extern int_4 _ilaenv ();
  extern int_4 _izamax ();
  extern int_4 _xerbla ();
  extern int_4 _zcopy ();
  extern int_4 _zgemm ();
  extern int_4 _zgeru ();
  extern int_4 _zscal ();
  extern int_4 _zswap ();
  extern int_4 _ztrsm ();
  kv_ = (*ku_) + (*kl_);
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldab_) < (*kl_) + kv_ + 1) {
    (*info_) = -6;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_86, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  nb_ = _ilaenv (&_k1, _dc_86, _dc_2, m_, n_, kl_, ku_);
  nb_ = _min (nb_, 64);
  if (nb_ <= 1 || nb_ > (*kl_)) {
    (void) _zgbtf2 (m_, n_, kl_, ku_, ab_, ldab_, ipiv_, info_);
  }
  else {
    for (j_ = 1; j_ <= nb_; (j_)++) {
      for (i_ = 1; i_ <= j_ - 1; (i_)++) {
        work13_[i_ - 1 + (65) * ((j_ - 1))] = CMPLX (0.0, 0.0);
      }
    }
    for (j_ = 1; j_ <= nb_; (j_)++) {
      for (i_ = j_ + 1; i_ <= nb_; (i_)++) {
        work31_[i_ - 1 + (65) * ((j_ - 1))] = CMPLX (0.0, 0.0);
      }
    }
    for (j_ = (*ku_) + 2; j_ <= _min (kv_, (*n_)); (j_)++) {
      for (i_ = kv_ - j_ + 2; i_ <= (*kl_); (i_)++) {
        ab_[i_ - 1 + ((*ldab_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
      }
    }
    ju_ = 1;
    for (j_ = 1; (nb_ > 0 ? j_ <= _min ((*m_), (*n_)) : j_ >= _min ((*m_), (*n_))); j_ += nb_) {
      jb_ = _min (nb_, _min ((*m_), (*n_)) - j_ + 1);
      i2_ = _min ((*kl_) - jb_, (*m_) - j_ - jb_ + 1);
      i3_ = _min (jb_, (*m_) - j_ - (*kl_) + 1);
      for (jj_ = j_; jj_ <= j_ + jb_ - 1; (jj_)++) {
        if (jj_ + kv_ <= (*n_)) {
          for (i_ = 1; i_ <= (*kl_); (i_)++) {
            ab_[i_ - 1 + ((*ldab_)) * ((jj_ + kv_ - 1))] = CMPLX (0.0, 0.0);
          }
        }
        km_ = _min ((*kl_), (*m_) - jj_);
        jp_ = _izamax (($1_ = km_ + 1, &$1_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], &_k1);
        ipiv_[jj_ - 1] = jp_ + jj_ - j_;
        if (ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((jj_ - 1))] != CMPLX (0.0, 0.0)) {
          ju_ = _max (ju_, _min (jj_ + (*ku_) + jp_ - 1, (*n_)));
          if (jp_ != 1) {
            if (jp_ + jj_ - 1 < j_ + (*kl_)) {
              (void) _zswap (&jb_, &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($2_ = (*ldab_) - 1, &$2_), &ab_[kv_ + jp_ 
              + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($3_ = (*ldab_) - 1, &$3_));
            }
            else {
              (void) _zswap (($4_ = jj_ - j_, &$4_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($5_ = (*ldab_) - 1, 
              &$5_), &work31_[jp_ + jj_ - j_ - (*kl_) - 1], ($6_ = 65, &$6_));
              (void) _zswap (($7_ = j_ + jb_ - jj_, &$7_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], ($8_ = (*ldab_) - 1, &$8_), 
              &ab_[kv_ + jp_ - 1 + ((*ldab_)) * ((jj_ - 1))], ($9_ = (*ldab_) - 1, &$9_));
            }
          }
          (void) _zscal (&km_, ($10_ = CMPLX (1.0, 0.0) / ab_[kv_ + 1 - 1 + ((*ldab_)) * ((jj_ - 1))], &$10_), &ab_[kv_ + 2 - 1 + 
          ((*ldab_)) * ((jj_ - 1))], &_k1);
          jm_ = _min (ju_, j_ + jb_ - 1);
          if (jm_ > jj_) {
            (void) _zgeru (&km_, ($11_ = jm_ - jj_, &$11_), ($12_ = CMPLX (-1.0, 0.0), &$12_), &ab_[kv_ + 2 - 1 + ((*ldab_)) * 
            ((jj_ - 1))], &_k1, &ab_[kv_ - 1 + ((*ldab_)) * ((jj_ + 1 - 1))], ($13_ = (*ldab_) - 1, &$13_), &ab_[kv_ + 1 - 1 + 
            ((*ldab_)) * ((jj_ + 1 - 1))], ($14_ = (*ldab_) - 1, &$14_));
          }
        }
        else {
          if ((*info_) == 0) {
            (*info_) = jj_;
          }
        }
        nw_ = _min (jj_ - j_ + 1, i3_);
        if (nw_ > 0) {
          (void) _zcopy (&nw_, &ab_[kv_ + (*kl_) + 1 - jj_ + j_ - 1 + ((*ldab_)) * ((jj_ - 1))], &_k1, &work31_[0 + (65) * ((jj_ 
          - j_ + 1 - 1))], &_k1);
        }
      }
      if (j_ + jb_ <= (*n_)) {
        j2_ = _min (ju_ - j_ + 1, kv_) - jb_;
        j3_ = _max (0, ju_ - j_ - kv_ + 1);
        (void) _zlaswp (&j2_, &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($15_ = (*ldab_) - 1, &$15_), &_k1, 
        &jb_, &ipiv_[j_ - 1], &_k1);
        for (i_ = j_; i_ <= j_ + jb_ - 1; (i_)++) {
          ipiv_[i_ - 1] = ipiv_[i_ - 1] + j_ - 1;
        }
        k2_ = j_ - 1 + jb_ + j2_;
        for (i_ = 1; i_ <= j3_; (i_)++) {
          jj_ = k2_ + i_;
          for (ii_ = j_ + i_ - 1; ii_ <= j_ + jb_ - 1; (ii_)++) {
            ip_ = ipiv_[ii_ - 1];
            if (ip_ != ii_) {
              temp_ = ab_[kv_ + 1 + ii_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))];
              ab_[kv_ + 1 + ii_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))] = ab_[kv_ + 1 + ip_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))];
              ab_[kv_ + 1 + ip_ - jj_ - 1 + ((*ldab_)) * ((jj_ - 1))] = temp_;
            }
          }
        }
        if (j2_ > 0) {
          (void) _ztrsm (_dc_3, _dc_4, _dc_5, _dc_6, &jb_, &j2_, ($16_ = CMPLX (1.0, 0.0), &$16_), &ab_[kv_ + 1 - 1 + ((*ldab_)) 
          * ((j_ - 1))], ($17_ = (*ldab_) - 1, &$17_), &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($18_ = (*ldab_) 
          - 1, &$18_));
          if (i2_ > 0) {
            (void) _zgemm (_dc_5, _dc_5, &i2_, &j2_, &jb_, ($19_ = CMPLX (-1.0, 0.0), &$19_), &ab_[kv_ + 1 + jb_ - 1 + ((*ldab_)) * 
            ((j_ - 1))], ($20_ = (*ldab_) - 1, &$20_), &ab_[kv_ + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($21_ = (*ldab_) - 
            1, &$21_), ($22_ = CMPLX (1.0, 0.0), &$22_), &ab_[kv_ + 1 - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($23_ = (*ldab_) - 1, 
            &$23_));
          }
          if (i3_ > 0) {
            (void) _zgemm (_dc_5, _dc_5, &i3_, &j2_, &jb_, ($24_ = CMPLX (-1.0, 0.0), &$24_), work31_, ($25_ = 65, &$25_), &ab_[kv_ 
            + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($26_ = (*ldab_) - 1, &$26_), ($27_ = CMPLX (1.0, 0.0), &$27_), 
            &ab_[kv_ + (*kl_) + 1 - jb_ - 1 + ((*ldab_)) * ((j_ + jb_ - 1))], ($28_ = (*ldab_) - 1, &$28_));
          }
        }
        if (j3_ > 0) {
          for (jj_ = 1; jj_ <= j3_; (jj_)++) {
            for (ii_ = jj_; ii_ <= jb_; (ii_)++) {
              work13_[ii_ - 1 + (65) * ((jj_ - 1))] = ab_[ii_ - jj_ + 1 - 1 + ((*ldab_)) * ((jj_ + j_ + kv_ - 1 - 1))];
            }
          }
          (void) _ztrsm (_dc_3, _dc_4, _dc_5, _dc_6, &jb_, &j3_, ($29_ = CMPLX (1.0, 0.0), &$29_), &ab_[kv_ + 1 - 1 + ((*ldab_)) 
          * ((j_ - 1))], ($30_ = (*ldab_) - 1, &$30_), work13_, ($31_ = 65, &$31_));
          if (i2_ > 0) {
            (void) _zgemm (_dc_5, _dc_5, &i2_, &j3_, &jb_, ($32_ = CMPLX (-1.0, 0.0), &$32_), &ab_[kv_ + 1 + jb_ - 1 + ((*ldab_)) * 
            ((j_ - 1))], ($33_ = (*ldab_) - 1, &$33_), work13_, ($34_ = 65, &$34_), ($35_ = CMPLX (1.0, 0.0), &$35_), &ab_[1 + jb_ 
            - 1 + ((*ldab_)) * ((j_ + kv_ - 1))], ($36_ = (*ldab_) - 1, &$36_));
          }
          if (i3_ > 0) {
            (void) _zgemm (_dc_5, _dc_5, &i3_, &j3_, &jb_, ($37_ = CMPLX (-1.0, 0.0), &$37_), work31_, ($38_ = 65, &$38_), work13_, 
            ($39_ = 65, &$39_), ($40_ = CMPLX (1.0, 0.0), &$40_), &ab_[1 + (*kl_) - 1 + ((*ldab_)) * ((j_ + kv_ - 1))], ($41_ = 
            (*ldab_) - 1, &$41_));
          }
          for (jj_ = 1; jj_ <= j3_; (jj_)++) {
            for (ii_ = jj_; ii_ <= jb_; (ii_)++) {
              ab_[ii_ - jj_ + 1 - 1 + ((*ldab_)) * ((jj_ + j_ + kv_ - 1 - 1))] = work13_[ii_ - 1 + (65) * ((jj_ - 1))];
            }
          }
        }
      }
      else {
        for (i_ = j_; i_ <= j_ + jb_ - 1; (i_)++) {
          ipiv_[i_ - 1] = ipiv_[i_ - 1] + j_ - 1;
        }
      }
      for (jj_ = j_ + jb_ - 1; jj_ >= j_; (jj_)--) {
        jp_ = ipiv_[jj_ - 1] - jj_ + 1;
        if (jp_ != 1) {
          if (jp_ + jj_ - 1 < j_ + (*kl_)) {
            (void) _zswap (($42_ = jj_ - j_, &$42_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($43_ = (*ldab_) - 1, 
            &$43_), &ab_[kv_ + jp_ + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($44_ = (*ldab_) - 1, &$44_));
          }
          else {
            (void) _zswap (($45_ = jj_ - j_, &$45_), &ab_[kv_ + 1 + jj_ - j_ - 1 + ((*ldab_)) * ((j_ - 1))], ($46_ = (*ldab_) - 1, 
            &$46_), &work31_[jp_ + jj_ - j_ - (*kl_) - 1], ($47_ = 65, &$47_));
          }
        }
        nw_ = _min (i3_, jj_ - j_ + 1);
        if (nw_ > 0) {
          (void) _zcopy (&nw_, &work31_[0 + (65) * ((jj_ - j_ + 1 - 1))], &_k1, &ab_[kv_ + (*kl_) + 1 - jj_ + j_ - 1 + ((*ldab_)) 
          * ((jj_ - 1))], &_k1);
        }
      }
    }
  }
  _l0:;
  __calls[117].calls++;
  return 0;
}

int_4 _zgbtrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ kl_, int_4 _p_ ku_, int_4 _p_ nrhs_, complex_16 _p_ ab_, int_4 
_p_ ldab_, int_4 _p_ ipiv_, complex_16 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_)
{
  static int_4 i_, j_, kd_, l_, lm_;
  static logical_4 lnoti_, notran_;
  int_4 $0_, $2_, $3_, $6_;
  complex_16 $1_, $4_, $5_, $7_, $8_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern int_4 _zgemv ();
  extern int_4 _zgeru ();
  extern int_4 _zswap ();
  extern int_4 _ztbsv ();
  (*info_) = 0;
  notran_ = _lsame (trans_, _dc_7);
  if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*kl_) < 0) {
    (*info_) = -3;
  }
  else if ((*ku_) < 0) {
    (*info_) = -4;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -5;
  }
  else if ((*ldab_) < (2 * (*kl_) + (*ku_) + 1)) {
    (*info_) = -7;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_87, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*nrhs_) == 0) {
    goto _l0;
  }
  kd_ = (*ku_) + (*kl_) + 1;
  lnoti_ = (*kl_) > 0;
  if (notran_) {
    if (lnoti_) {
      for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
        lm_ = _min ((*kl_), (*n_) - j_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _zswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
        (void) _zgeru (&lm_, nrhs_, ($1_ = CMPLX (-1.0, 0.0), &$1_), &ab_[kd_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, &b_[j_ 
        - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_);
      }
    }
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _ztbsv (_dc_11, _dc_5, _dc_12, n_, ($2_ = (*kl_) + (*ku_), &$2_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
  }
  else if (_lsame (trans_, _dc_8)) {
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _ztbsv (_dc_11, _dc_13, _dc_12, n_, ($3_ = (*kl_) + (*ku_), &$3_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
    if (lnoti_) {
      for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
        lm_ = _min ((*kl_), (*n_) - j_);
        (void) _zgemv (_dc_13, &lm_, nrhs_, ($4_ = CMPLX (-1.0, 0.0), &$4_), &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_, 
        &ab_[kd_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, ($5_ = CMPLX (1.0, 0.0), &$5_), &b_[j_ - 1 + ((*ldb_)) * ((0))], 
        ldb_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _zswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
      }
    }
  }
  else {
    for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
      (void) _ztbsv (_dc_11, _dc_14, _dc_12, n_, ($6_ = (*kl_) + (*ku_), &$6_), ab_, ldab_, &b_[0 + ((*ldb_)) * ((i_ - 1))], 
      &_k1);
    }
    if (lnoti_) {
      for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
        lm_ = _min ((*kl_), (*n_) - j_);
        (void) _zlacgv (nrhs_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        (void) _zgemv (_dc_14, &lm_, nrhs_, ($7_ = CMPLX (-1.0, 0.0), &$7_), &b_[j_ + 1 - 1 + ((*ldb_)) * ((0))], ldb_, 
        &ab_[kd_ + 1 - 1 + ((*ldab_)) * ((j_ - 1))], &_k1, ($8_ = CMPLX (1.0, 0.0), &$8_), &b_[j_ - 1 + ((*ldb_)) * ((0))], 
        ldb_);
        (void) _zlacgv (nrhs_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        l_ = ipiv_[j_ - 1];
        if (l_ != j_) {
          (void) _zswap (nrhs_, &b_[l_ - 1 + ((*ldb_)) * ((0))], ldb_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_);
        }
      }
    }
  }
  _l0:;
  __calls[118].calls++;
  return 0;
}

int_4 _zgeqr2 (int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ tau_, complex_16 _p_ work_
, int_4 _p_ info_)
{
  static int_4 i_, k_;
  static complex_16 alpha_;
  int_4 $0_, $1_, $2_, $3_;
  complex_16 $4_;
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_88, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  k_ = _min ((*m_), (*n_));
  for (i_ = 1; i_ <= k_; (i_)++) {
    (void) _zlarfg (($1_ = (*m_) - i_ + 1, &$1_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[_min (i_ + 1, (*m_)) - 1 + 
    ((*lda_)) * ((i_ - 1))], &_k1, &tau_[i_ - 1]);
    if (i_ < (*n_)) {
      alpha_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = CMPLX (1.0, 0.0);
      (void) _zlarf (_dc_3, ($2_ = (*m_) - i_ + 1, &$2_), ($3_ = (*n_) - i_, &$3_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
      &_k1, ($4_ = __dconjg (&tau_[i_ - 1]), &$4_), &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, work_);
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = alpha_;
    }
  }
  _l0:;
  __calls[119].calls++;
  return 0;
}

int_4 _zgttrf (int_4 _p_ n_, complex_16 _p_ dl_, complex_16 _p_ d_, complex_16 _p_ du_, complex_16 _p_ du2_, int_4 _p_ 
ipiv_, int_4 _p_ info_)
{
  static int_4 i_;
  static complex_16 fact_, temp_, zdum_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
    (void) _xerbla (_dc_89, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ipiv_[i_ - 1] = i_;
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (dl_[i_ - 1] == CMPLX (0.0, 0.0)) {
      if (d_[i_ - 1] == CMPLX (0.0, 0.0) && (*info_) == 0) {
        (*info_) = i_;
      }
      if (i_ < (*n_) - 1) {
        du2_[i_ - 1] = CMPLX (0.0, 0.0);
      }
    }
    else if (({complex_16 zdum__1_ = d_[i_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));}) >= 
    ({complex_16 zdum__1_ = dl_[i_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));})) {
    fact_ = dl_[i_ - 1] / d_[i_ - 1];
    dl_[i_ - 1] = fact_;
    d_[i_ + 1 - 1] = d_[i_ + 1 - 1] - fact_ * du_[i_ - 1];
    if (i_ < (*n_) - 1) {
      du2_[i_ - 1] = CMPLX (0.0, 0.0);
    }
  }
  else {
    fact_ = d_[i_ - 1] / dl_[i_ - 1];
    d_[i_ - 1] = dl_[i_ - 1];
    dl_[i_ - 1] = fact_;
    temp_ = du_[i_ - 1];
    du_[i_ - 1] = d_[i_ + 1 - 1];
    d_[i_ + 1 - 1] = temp_ - fact_ * d_[i_ + 1 - 1];
    if (i_ < (*n_) - 1) {
      du2_[i_ - 1] = du_[i_ + 1 - 1];
      du_[i_ + 1 - 1] = -fact_ * du_[i_ + 1 - 1];
    }
    ipiv_[i_ - 1] = ipiv_[i_ - 1] + 1;
  }
}

if (d_[(*n_) - 1] == CMPLX (0.0, 0.0) && (*info_) == 0) {
  (*info_) = (*n_);
  goto _l0;
}

_l0:;
__calls[120].calls++;
return 0;
}

int_4 _zgttrs (char _p_ trans_, int_4 _p_ n_, int_4 _p_ nrhs_, complex_16 _p_ dl_, complex_16 _p_ d_, complex_16 _p_ 
du_, complex_16 _p_ du2_, int_4 _p_ ipiv_, complex_16 _p_ b_, int_4 _p_ ldb_, int_4 _p_ info_)
{
  static int_4 i_, j_;
  static logical_4 notran_;
  static complex_16 temp_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  (*info_) = 0;
  notran_ = _lsame (trans_, _dc_7);
  if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -3;
  }
  else if ((*ldb_) < _max ((*n_), 1)) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_90, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*nrhs_) == 0) {
    goto _l0;
  }
  if (notran_) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * b_[i_ - 1 + ((*ldb_)) 
          * ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = temp_ - dl_[i_ - 1] * b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))];
        }
      }
      b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] = b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))] / d_[(*n_) - 1];
      if ((*n_) > 1) {
        b_[(*n_) - 1 - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[(*n_) - 1 - 1 + ((*ldb_)) * ((j_ - 1))] - du_[(*n_) - 1 - 1] * 
        b_[(*n_) - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[(*n_) - 1 - 1];
      }
      for (i_ = (*n_) - 2; i_ >= 1; (i_)--) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1] * b_[i_ + 1 - 1 + ((*ldb_)) * 
        ((j_ - 1))] - du2_[i_ - 1] * b_[i_ + 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[i_ - 1];
      }
    }
  }
  else if (_lsame (trans_, _dc_8)) {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / d_[0];
      if ((*n_) > 1) {
        b_[1 + ((*ldb_)) * ((j_ - 1))] = (b_[1 + ((*ldb_)) * ((j_ - 1))] - du_[0] * b_[0 + ((*ldb_)) * ((j_ - 1))]) / d_[1];
      }
      for (i_ = 3; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - du_[i_ - 1 - 1] * b_[i_ - 1 - 1 + 
        ((*ldb_)) * ((j_ - 1))] - du2_[i_ - 2 - 1] * b_[i_ - 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / d_[i_ - 1];
      }
      for (i_ = (*n_) - 1; i_ >= 1; (i_)--) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * b_[i_ + 1 - 1 + ((*ldb_)) * 
          ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - dl_[i_ - 1] * temp_;
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*nrhs_); (j_)++) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / __dconjg (&d_[0]);
      if ((*n_) > 1) {
        b_[1 + ((*ldb_)) * ((j_ - 1))] = (b_[1 + ((*ldb_)) * ((j_ - 1))] - __dconjg (&du_[0]) * b_[0 + ((*ldb_)) * ((j_ - 1))]) 
        / __dconjg (&d_[1]);
      }
      for (i_ = 3; i_ <= (*n_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = (b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - __dconjg (&du_[i_ - 1 - 1]) * b_[i_ - 1 - 
        1 + ((*ldb_)) * ((j_ - 1))] - __dconjg (&du2_[i_ - 2 - 1]) * b_[i_ - 2 - 1 + ((*ldb_)) * ((j_ - 1))]) / __dconjg 
        (&d_[i_ - 1]);
      }
      for (i_ = (*n_) - 1; i_ >= 1; (i_)--) {
        if (ipiv_[i_ - 1] == i_) {
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - __dconjg (&dl_[i_ - 1]) * b_[i_ + 1 - 1 + 
          ((*ldb_)) * ((j_ - 1))];
        }
        else {
          temp_ = b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))];
          b_[i_ + 1 - 1 + ((*ldb_)) * ((j_ - 1))] = b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] - __dconjg (&dl_[i_ - 1]) * temp_;
          b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = temp_;
        }
      }
    }
  }
  _l0:;
  __calls[121].calls++;
  return 0;
}

int_4 _zlacgv (int_4 _p_ n_, complex_16 _p_ x_, int_4 _p_ incx_)
{
  static int_4 i_, ioff_;
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  if ((*incx_) == 1) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[i_ - 1] = __dconjg (&x_[i_ - 1]);
    }
  }
  else {
    ioff_ = 1;
    if ((*incx_) < 0) {
      ioff_ = 1 - ((*n_) - 1) * (*incx_);
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[ioff_ - 1] = __dconjg (&x_[ioff_ - 1]);
      ioff_ = ioff_ + (*incx_);
    }
  }
  __calls[122].calls++;
  return 0;
}

int_4 _zlacon (int_4 _p_ n_, complex_16 _p_ v_, complex_16 _p_ x_, real_8 _p_ est_, int_4 _p_ kase_)
{
  static int_4 i_, iter_, j_, jlast_, jump_;
  static real_8 altsgn_, estold_, safmin_, temp_;
  extern real_8 _dlamch ();
  extern int_4 _zcopy ();
  safmin_ = _dlamch (_dc_18);
  if ((*kase_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[i_ - 1] = (complex_16) (1.0 / (real_8) ((*n_)));
    }
    (*kase_) = 1;
    jump_ = 1;
    goto _l0;
  }
  switch (jump_) {
    default:
    case 1: goto _l20;
    case 2: goto _l40;
    case 3: goto _l70;
    case 4: goto _l90;
    case 5: goto _l120;
  }
  _l20:;
  if ((*n_) == 1) {
    v_[0] = x_[0];
    (*est_) = cabs (v_[0]);
    goto _l130;
  }
  (*est_) = _dzsum1 (n_, x_, &_k1);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (cabs (x_[i_ - 1]) > safmin_) {
      x_[i_ - 1] = x_[i_ - 1] / (complex_16) (cabs (x_[i_ - 1]));
    }
    else {
      x_[i_ - 1] = CMPLX (1.0, 0.0);
    }
  }
  (*kase_) = 2;
  jump_ = 2;
  goto _l0;
  _l40:;
  j_ = _izmax1 (n_, x_, &_k1);
  iter_ = 2;
  _l50:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = CMPLX (0.0, 0.0);
  }
  x_[j_ - 1] = CMPLX (1.0, 0.0);
  (*kase_) = 1;
  jump_ = 3;
  goto _l0;
  _l70:;
  (void) _zcopy (n_, x_, &_k1, v_, &_k1);
  estold_ = (*est_);
  (*est_) = _dzsum1 (n_, v_, &_k1);
  if ((*est_) <= estold_) {
    goto _l100;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (cabs (x_[i_ - 1]) > safmin_) {
      x_[i_ - 1] = x_[i_ - 1] / (complex_16) (cabs (x_[i_ - 1]));
    }
    else {
      x_[i_ - 1] = CMPLX (1.0, 0.0);
    }
  }
  (*kase_) = 2;
  jump_ = 4;
  goto _l0;
  _l90:;
  jlast_ = j_;
  j_ = _izmax1 (n_, x_, &_k1);
  if (((real_8) (creal (x_[jlast_ - 1])) != _abs ((real_8) (creal (x_[j_ - 1])))) && (iter_ < 5)) {
    iter_ = iter_ + 1;
    goto _l50;
  }
  _l100:;
  altsgn_ = 1.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = (complex_16) (altsgn_ * (1.0 + (real_8) (i_ - 1) / (real_8) ((*n_) - 1)));
    altsgn_ = -altsgn_;
  }
  (*kase_) = 1;
  jump_ = 5;
  goto _l0;
  _l120:;
  temp_ = 2.0 * (_dzsum1 (n_, x_, &_k1) / (real_8) (3 * (*n_)));
  if (temp_ > (*est_)) {
    (void) _zcopy (n_, x_, &_k1, v_, &_k1);
    (*est_) = temp_;
  }
  _l130:;
  (*kase_) = 0;
  _l0:;
  __calls[123].calls++;
  return 0;
}

int_4 _zlacpy (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, complex_16 _p_ b_, int_4 
_p_ ldb_)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if (_lsame (uplo_, _dc_19)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_, (*m_)); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  else if (_lsame (uplo_, _dc_20)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  __calls[124].calls++;
  return 0;
}

complex_16 _zladiv (complex_16 _p_ x_, complex_16 _p_ y_)
{
  static real_8 zi_, zr_;
  real_8 $0_, $1_, $2_, $3_;
  complex_16 zladiv_;
  (void) _dladiv (($0_ = (real_8) (creal ((*x_))), &$0_), ($1_ = cimag ((*x_)), &$1_), ($2_ = (real_8) (creal ((*y_))), 
  &$2_), ($3_ = cimag ((*y_)), &$3_), &zr_, &zi_);
  zladiv_ = CMPLX (zr_, zi_);
  __calls[125].calls++;
  return zladiv_;
}

int_4 _zlahqr (logical_4 _p_ wantt_, logical_4 _p_ wantz_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, complex_16 _p_ 
h_, int_4 _p_ ldh_, complex_16 _p_ w_, int_4 _p_ iloz_, int_4 _p_ ihiz_, complex_16 _p_ z_, int_4 _p_ ldz_, int_4 _p_ 
info_)
{
  static int_4 i_, i1_, i2_, itn_, its_, j_, k_, l_, m_, nh_, nz_;
  static real_8 h10_, h21_, rtemp_, s_, smlnum_, t2_, tst1_, ulp_, rwork_[1];
  static complex_16 cdum_, h11_, h11s_, h22_, sum_, t_, t1_, temp_, u_, v2_, x_, y_, v_[2];
  int_4 $0_, $2_, $3_, $4_, $5_, $8_, $10_;
  complex_16 $1_, $6_, $7_, $9_;
  extern real_8 _dlamch ();
  extern int_4 _zcopy ();
  extern int_4 _zscal ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  (*info_) = 0;
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*ilo_) == (*ihi_)) {
    w_[(*ilo_) - 1] = h_[(*ilo_) - 1 + ((*ldh_)) * (((*ilo_) - 1))];
    goto _l0;
  }
  nh_ = (*ihi_) - (*ilo_) + 1;
  nz_ = (*ihiz_) - (*iloz_) + 1;
  ulp_ = _dlamch (_dc_21);
  smlnum_ = _dlamch (_dc_18) / ulp_;
  if ((*wantt_)) {
    i1_ = 1;
    i2_ = (*n_);
  }
  itn_ = 30 * nh_;
  i_ = (*ihi_);
  _l10:;
  if (i_ < (*ilo_)) {
    goto _l130;
  }
  l_ = (*ilo_);
  for (its_ = 0; its_ <= itn_; (its_)++) {
    for (k_ = i_; k_ >= l_ + 1; (k_)--) {
      tst1_ = ({complex_16 cdum__1_ = h_[k_ - 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))]; _abs ((real_8) (creal (cdum__1_))) + _abs 
      (cimag (cdum__1_));}) + ({complex_16 cdum__1_ = h_[k_ - 1 + ((*ldh_)) * ((k_ - 1))]; _abs ((real_8) (creal (cdum__1_))) 
      + _abs (cimag (cdum__1_));});
      if (tst1_ == 0.0) {
        tst1_ = _zlanhs (_dc_22, ($0_ = i_ - l_ + 1, &$0_), &h_[l_ - 1 + ((*ldh_)) * ((l_ - 1))], ldh_, rwork_);
      }
      if (_abs ((real_8) (creal (h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))]))) <= _max (ulp_ * tst1_, smlnum_)) {
        goto _l30;
      }
    }
    _l30:;
    l_ = k_;
    if (l_ > (*ilo_)) {
      h_[l_ - 1 + ((*ldh_)) * ((l_ - 1 - 1))] = CMPLX (0.0, 0.0);
    }
    if (l_ >= i_) {
      goto _l120;
    }
    if (! ((*wantt_))) {
      i1_ = l_;
      i2_ = i_;
    }
    if (its_ == 10 || its_ == 20) {
      t_ = _abs ((real_8) (creal (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))]))) + _abs ((real_8) (creal (h_[i_ - 1 - 1 + 
      ((*ldh_)) * ((i_ - 2 - 1))])));
    }
    else {
      t_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
      u_ = h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1))] * (real_8) (creal (h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))]));
      if (u_ != CMPLX (0.0, 0.0)) {
        x_ = 0.5 * (h_[i_ - 1 - 1 + ((*ldh_)) * ((i_ - 1 - 1))] - t_);
        y_ = csqrt (x_ * x_ + u_);
        if ((real_8) (creal (x_)) * (real_8) (creal (y_)) + cimag (x_) * cimag (y_) < 0.0) {
          y_ = -y_;
        }
        t_ = t_ - _zladiv (&u_, ($1_ = (x_ + y_), &$1_));
      }
    }
    for (m_ = i_ - 1; m_ >= l_ + 1; (m_)--) {
      h11_ = h_[m_ - 1 + ((*ldh_)) * ((m_ - 1))];
      h22_ = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ + 1 - 1))];
      h11s_ = h11_ - t_;
      h21_ = (real_8) (creal (h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))]));
      s_ = ({complex_16 cdum__1_ = h11s_; _abs ((real_8) (creal (cdum__1_))) + _abs (cimag (cdum__1_));}) + _abs (h21_);
      h11s_ = h11s_ / s_;
      h21_ = h21_ / s_;
      v_[0] = h11s_;
      v_[1] = h21_;
      h10_ = (real_8) (creal (h_[m_ - 1 + ((*ldh_)) * ((m_ - 1 - 1))]));
      tst1_ = ({complex_16 cdum__1_ = h11s_; _abs ((real_8) (creal (cdum__1_))) + _abs (cimag (cdum__1_));}) * (({complex_16 
      cdum__1_ = h11_; _abs ((real_8) (creal (cdum__1_))) + _abs (cimag (cdum__1_));}) + ({complex_16 cdum__1_ = h22_; _abs 
      ((real_8) (creal (cdum__1_))) + _abs (cimag (cdum__1_));}));
      if (_abs (h10_ * h21_) <= ulp_ * tst1_) {
        goto _l50;
      }
    }
    h11_ = h_[l_ - 1 + ((*ldh_)) * ((l_ - 1))];
    h22_ = h_[l_ + 1 - 1 + ((*ldh_)) * ((l_ + 1 - 1))];
    h11s_ = h11_ - t_;
    h21_ = (real_8) (creal (h_[l_ + 1 - 1 + ((*ldh_)) * ((l_ - 1))]));
    s_ = ({complex_16 cdum__1_ = h11s_; _abs ((real_8) (creal (cdum__1_))) + _abs (cimag (cdum__1_));}) + _abs (h21_);
    h11s_ = h11s_ / s_;
    h21_ = h21_ / s_;
    v_[0] = h11s_;
    v_[1] = h21_;
    _l50:;
    for (k_ = m_; k_ <= i_ - 1; (k_)++) {
      if (k_ > m_) {
        (void) _zcopy (($2_ = 2, &$2_), &h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))], &_k1, v_, &_k1);
      }
      (void) _zlarfg (($3_ = 2, &$3_), &v_[0], &v_[1], &_k1, &t1_);
      if (k_ > m_) {
        h_[k_ - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = v_[0];
        h_[k_ + 1 - 1 + ((*ldh_)) * ((k_ - 1 - 1))] = CMPLX (0.0, 0.0);
      }
      v2_ = v_[1];
      t2_ = (real_8) (creal (t1_ * v2_));
      for (j_ = k_; j_ <= i2_; (j_)++) {
        sum_ = __dconjg (&t1_) * h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] + t2_ * h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))];
        h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ - 1 + ((*ldh_)) * ((j_ - 1))] - sum_;
        h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] = h_[k_ + 1 - 1 + ((*ldh_)) * ((j_ - 1))] - sum_ * v2_;
      }
      for (j_ = i1_; j_ <= _min (k_ + 2, i_); (j_)++) {
        sum_ = t1_ * h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] + t2_ * h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))];
        h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ - 1))] - sum_;
        h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] = h_[j_ - 1 + ((*ldh_)) * ((k_ + 1 - 1))] - sum_ * __dconjg (&v2_);
      }
      if ((*wantz_)) {
        for (j_ = (*iloz_); j_ <= (*ihiz_); (j_)++) {
          sum_ = t1_ * z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] + t2_ * z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))];
          z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ - 1))] - sum_;
          z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] = z_[j_ - 1 + ((*ldz_)) * ((k_ + 1 - 1))] - sum_ * __dconjg (&v2_);
        }
      }
      if (k_ == m_ && m_ > l_) {
        temp_ = CMPLX (1.0, 0.0) - t1_;
        temp_ = temp_ / cabs (temp_);
        h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))] = h_[m_ + 1 - 1 + ((*ldh_)) * ((m_ - 1))] * __dconjg (&temp_);
        if (m_ + 2 <= i_) {
          h_[m_ + 2 - 1 + ((*ldh_)) * ((m_ + 1 - 1))] = h_[m_ + 2 - 1 + ((*ldh_)) * ((m_ + 1 - 1))] * temp_;
        }
        for (j_ = m_; j_ <= i_; (j_)++) {
          if (j_ != m_ + 1) {
            if (i2_ > j_) {
              (void) _zscal (($4_ = i2_ - j_, &$4_), &temp_, &h_[j_ - 1 + ((*ldh_)) * ((j_ + 1 - 1))], ldh_);
            }
            (void) _zscal (($5_ = j_ - i1_, &$5_), ($6_ = __dconjg (&temp_), &$6_), &h_[i1_ - 1 + ((*ldh_)) * ((j_ - 1))], &_k1);
            if ((*wantz_)) {
              (void) _zscal (&nz_, ($7_ = __dconjg (&temp_), &$7_), &z_[(*iloz_) - 1 + ((*ldz_)) * ((j_ - 1))], &_k1);
            }
          }
        }
      }
    }
    temp_ = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))];
    if (cimag (temp_) != 0.0) {
      rtemp_ = cabs (temp_);
      h_[i_ - 1 + ((*ldh_)) * ((i_ - 1 - 1))] = rtemp_;
      temp_ = temp_ / rtemp_;
      if (i2_ > i_) {
        (void) _zscal (($8_ = i2_ - i_, &$8_), ($9_ = __dconjg (&temp_), &$9_), &h_[i_ - 1 + ((*ldh_)) * ((i_ + 1 - 1))], ldh_)
        ;
      }
      (void) _zscal (($10_ = i_ - i1_, &$10_), &temp_, &h_[i1_ - 1 + ((*ldh_)) * ((i_ - 1))], &_k1);
      if ((*wantz_)) {
        (void) _zscal (&nz_, &temp_, &z_[(*iloz_) - 1 + ((*ldz_)) * ((i_ - 1))], &_k1);
      }
    }
  }
  (*info_) = i_;
  goto _l0;
  _l120:;
  w_[i_ - 1] = h_[i_ - 1 + ((*ldh_)) * ((i_ - 1))];
  itn_ = itn_ - its_;
  i_ = l_ - 1;
  goto _l10;
  _l130:;
  _l0:;
  __calls[126].calls++;
  return 0;
}

real_8 _zlange (char _p_ norm_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, real_8 _p_ work_)
{
  static int_4 i_, j_;
  static real_8 scale_, sum_, value_;
  real_8 zlange_;
  extern logical_4 _lsame ();
  if (_min ((*m_), (*n_)) == 0) {
    value_ = 0.0;
  }
  else if (_lsame (norm_, _dc_23)) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        value_ = _max (value_, cabs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]));
      }
    }
  }
  else if ((_lsame (norm_, _dc_24)) || ((strcmp (norm_, _dc_22) == 0))) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = 0.0;
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        sum_ = sum_ + cabs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
      value_ = _max (value_, sum_);
    }
  }
  else if (_lsame (norm_, _dc_25)) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        work_[i_ - 1] = work_[i_ - 1] + cabs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
    }
    value_ = 0.0;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      value_ = _max (value_, work_[i_ - 1]);
    }
  }
  else if ((_lsame (norm_, _dc_26)) || (_lsame (norm_, _dc_27))) {
    scale_ = 0.0;
    sum_ = 1.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _zlassq (m_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &scale_, &sum_);
    }
    value_ = scale_ * sqrt (sum_);
  }
  zlange_ = value_;
  __calls[127].calls++;
  return zlange_;
}

real_8 _zlanhs (char _p_ norm_, int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, real_8 _p_ work_)
{
  static int_4 i_, j_;
  static real_8 scale_, sum_, value_;
  int_4 $0_;
  real_8 zlanhs_;
  extern logical_4 _lsame ();
  if ((*n_) == 0) {
    value_ = 0.0;
  }
  else if (_lsame (norm_, _dc_23)) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        value_ = _max (value_, cabs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]));
      }
    }
  }
  else if ((_lsame (norm_, _dc_24)) || ((strcmp (norm_, _dc_22) == 0))) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = 0.0;
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        sum_ = sum_ + cabs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
      value_ = _max (value_, sum_);
    }
  }
  else if (_lsame (norm_, _dc_25)) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min ((*n_), j_ + 1); (i_)++) {
        work_[i_ - 1] = work_[i_ - 1] + cabs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
    }
    value_ = 0.0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      value_ = _max (value_, work_[i_ - 1]);
    }
  }
  else if ((_lsame (norm_, _dc_26)) || (_lsame (norm_, _dc_27))) {
    scale_ = 0.0;
    sum_ = 1.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _zlassq (($0_ = _min ((*n_), j_ + 1), &$0_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &scale_, &sum_);
    }
    value_ = scale_ * sqrt (sum_);
  }
  zlanhs_ = value_;
  __calls[128].calls++;
  return zlanhs_;
}

int_4 _zlarf (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ v_, int_4 _p_ incv_, complex_16 _p_ tau_, 
complex_16 _p_ c_, int_4 _p_ ldc_, complex_16 _p_ work_)
{
  complex_16 $0_, $1_, $2_, $3_, $4_, $5_;
  extern int_4 _zgemv ();
  extern int_4 _zgerc ();
  extern logical_4 _lsame ();
  if (_lsame (side_, _dc_20)) {
    if ((*tau_) != CMPLX (0.0, 0.0)) {
      (void) _zgemv (_dc_14, m_, n_, ($0_ = CMPLX (1.0, 0.0), &$0_), c_, ldc_, v_, incv_, ($1_ = CMPLX (0.0, 0.0), &$1_), 
      work_, &_k1);
      (void) _zgerc (m_, n_, ($2_ = -(*tau_), &$2_), v_, incv_, work_, &_k1, c_, ldc_);
    }
  }
  else {
    if ((*tau_) != CMPLX (0.0, 0.0)) {
      (void) _zgemv (_dc_5, m_, n_, ($3_ = CMPLX (1.0, 0.0), &$3_), c_, ldc_, v_, incv_, ($4_ = CMPLX (0.0, 0.0), &$4_), 
      work_, &_k1);
      (void) _zgerc (m_, n_, ($5_ = -(*tau_), &$5_), work_, &_k1, v_, incv_, c_, ldc_);
    }
  }
  __calls[129].calls++;
  return 0;
}

int_4 _zlarfg (int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ x_, int_4 _p_ incx_, complex_16 _p_ tau_)
{
  static int_4 j_, knt_;
  static real_8 alphi_, alphr_, beta_, rsafmn_, safmin_, xnorm_;
  int_4 $0_, $1_, $2_, $5_, $8_;
  complex_16 $3_, $4_, $6_, $7_;
  extern real_8 _dlamch ();
  extern real_8 _dznrm2 ();
  extern int_4 _zdscal ();
  extern int_4 _zscal ();
  if ((*n_) <= 0) {
    (*tau_) = 0.0;
    goto _l0;
  }
  xnorm_ = _dznrm2 (($0_ = (*n_) - 1, &$0_), x_, incx_);
  alphr_ = (real_8) (creal ((*alpha_)));
  alphi_ = cimag ((*alpha_));
  if (xnorm_ == 0.0 && alphi_ == 0.0) {
    (*tau_) = 0.0;
  }
  else {
    beta_ = -_sign (_dlapy3 (&alphr_, &alphi_, &xnorm_), alphr_);
    safmin_ = _dlamch (_dc_28) / _dlamch (_dc_27);
    rsafmn_ = 1.0 / safmin_;
    if (_abs (beta_) < safmin_) {
      knt_ = 0;
      _l10:;
      knt_ = knt_ + 1;
      (void) _zdscal (($1_ = (*n_) - 1, &$1_), &rsafmn_, x_, incx_);
      beta_ = beta_ * rsafmn_;
      alphi_ = alphi_ * rsafmn_;
      alphr_ = alphr_ * rsafmn_;
      if (_abs (beta_) < safmin_) {
        goto _l10;
      }
      xnorm_ = _dznrm2 (($2_ = (*n_) - 1, &$2_), x_, incx_);
      (*alpha_) = CMPLX (alphr_, alphi_);
      beta_ = -_sign (_dlapy3 (&alphr_, &alphi_, &xnorm_), alphr_);
      (*tau_) = CMPLX ((beta_ - alphr_) / beta_, -alphi_ / beta_);
      (*alpha_) = _zladiv (($3_ = (complex_16) (1.0), &$3_), ($4_ = (*alpha_) - beta_, &$4_));
      (void) _zscal (($5_ = (*n_) - 1, &$5_), alpha_, x_, incx_);
      (*alpha_) = beta_;
      for (j_ = 1; j_ <= knt_; (j_)++) {
        (*alpha_) = (*alpha_) * safmin_;
      }
    }
    else {
      (*tau_) = CMPLX ((beta_ - alphr_) / beta_, -alphi_ / beta_);
      (*alpha_) = _zladiv (($6_ = (complex_16) (1.0), &$6_), ($7_ = (*alpha_) - beta_, &$7_));
      (void) _zscal (($8_ = (*n_) - 1, &$8_), alpha_, x_, incx_);
      (*alpha_) = beta_;
    }
  }
  _l0:;
  __calls[130].calls++;
  return 0;
}

int_4 _zlarnv (int_4 _p_ idist_, int_4 _p_ iseed_, int_4 _p_ n_, complex_16 _p_ x_)
{
  static int_4 i_, il_, iv_;
  static real_8 u_[128];
  int_4 $0_;
  for (iv_ = 1; (64 > 0 ? iv_ <= (*n_) : iv_ >= (*n_)); iv_ += 64) {
    il_ = _min (64, (*n_) - iv_ + 1);
    (void) _dlaruv (iseed_, ($0_ = 2 * il_, &$0_), u_);
    if ((*idist_) == 1) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = CMPLX (u_[2 * i_ - 1 - 1], u_[2 * i_ - 1]);
      }
    }
    else if ((*idist_) == 2) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = CMPLX (2.0 * u_[2 * i_ - 1 - 1] - 1.0, 2.0 * u_[2 * i_ - 1] - 1.0);
      }
    }
    else if ((*idist_) == 3) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = sqrt (-2.0 * log (u_[2 * i_ - 1 - 1])) * cexp (CMPLX (0.0, 6.2831853071795865 * u_[2 * i_ - 1]))
        ;
      }
    }
    else if ((*idist_) == 4) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = sqrt (u_[2 * i_ - 1 - 1]) * cexp (CMPLX (0.0, 6.2831853071795865 * u_[2 * i_ - 1]));
      }
    }
    else if ((*idist_) == 5) {
      for (i_ = 1; i_ <= il_; (i_)++) {
        x_[iv_ + i_ - 1 - 1] = cexp (CMPLX (0.0, 6.2831853071795865 * u_[2 * i_ - 1]));
      }
    }
  }
  __calls[131].calls++;
  return 0;
}

int_4 _zlartg (complex_16 _p_ f_, complex_16 _p_ g_, real_8 _p_ cs_, complex_16 _p_ sn_, complex_16 _p_ r_)
{
  static real_8 d_, di_, f1_, f2_, fa_, g1_, g2_, ga_;
  static complex_16 fs_, gs_, ss_, t_;
  real_8 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  if ((*g_) == CMPLX (0.0, 0.0)) {
    (*cs_) = 1.0;
    (*sn_) = 0.0;
    (*r_) = (*f_);
  }
  else if ((*f_) == CMPLX (0.0, 0.0)) {
    (*cs_) = 0.0;
    (*sn_) = __dconjg (g_) / cabs ((*g_));
    (*r_) = cabs ((*g_));
  }
  else {
    f1_ = ({complex_16 t__1_ = (*f_); _abs ((real_8) (creal (t__1_))) + _abs (cimag (t__1_));});
    g1_ = ({complex_16 t__1_ = (*g_); _abs ((real_8) (creal (t__1_))) + _abs (cimag (t__1_));});
    if (f1_ >= g1_) {
      gs_ = (*g_) / f1_;
      g2_ = ({complex_16 t__1_ = gs_; ($0_ = (real_8) (creal (t__1_)), $0_ * $0_) + ($1_ = cimag (t__1_), $1_ * $1_);});
      fs_ = (*f_) / f1_;
      f2_ = ({complex_16 t__1_ = fs_; ($2_ = (real_8) (creal (t__1_)), $2_ * $2_) + ($3_ = cimag (t__1_), $3_ * $3_);});
      d_ = sqrt (1.0 + g2_ / f2_);
      (*cs_) = 1.0 / d_;
      (*sn_) = __dconjg (&gs_) * fs_ * ((*cs_) / f2_);
      (*r_) = (*f_) * d_;
    }
    else {
      fs_ = (*f_) / g1_;
      f2_ = ({complex_16 t__1_ = fs_; ($4_ = (real_8) (creal (t__1_)), $4_ * $4_) + ($5_ = cimag (t__1_), $5_ * $5_);});
      fa_ = sqrt (f2_);
      gs_ = (*g_) / g1_;
      g2_ = ({complex_16 t__1_ = gs_; ($6_ = (real_8) (creal (t__1_)), $6_ * $6_) + ($7_ = cimag (t__1_), $7_ * $7_);});
      ga_ = sqrt (g2_);
      d_ = sqrt (1.0 + f2_ / g2_);
      di_ = 1.0 / d_;
      (*cs_) = (fa_ / ga_) * di_;
      ss_ = (__dconjg (&gs_) * fs_) / (fa_ * ga_);
      (*sn_) = ss_ * di_;
      (*r_) = (*g_) * ss_ * d_;
    }
  }
  __calls[132].calls++;
  return 0;
}

int_4 _zlascl (char _p_ type_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ cfrom_, real_8 _p_ cto_, int_4 _p_ m_, int_4 
_p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ info_)
{
  static int_4 i_, itype_, j_, k1_, k2_, k3_, k4_;
  static logical_4 done_;
  static real_8 bignum_, cfrom1_, cfromc_, cto1_, ctoc_, mul_, smlnum_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern real_8 _dlamch ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if (_lsame (type_, _dc_29)) {
    itype_ = 0;
  }
  else if (_lsame (type_, _dc_20)) {
    itype_ = 1;
  }
  else if (_lsame (type_, _dc_19)) {
    itype_ = 2;
  }
  else if (_lsame (type_, _dc_30)) {
    itype_ = 3;
  }
  else if (_lsame (type_, _dc_31)) {
    itype_ = 4;
  }
  else if (_lsame (type_, _dc_32)) {
    itype_ = 5;
  }
  else if (_lsame (type_, _dc_33)) {
    itype_ = 6;
  }
  else {
    itype_ = -1;
  }
  if (itype_ == -1) {
    (*info_) = -1;
  }
  else if ((*cfrom_) == 0.0) {
    (*info_) = -4;
  }
  else if ((*m_) < 0) {
    (*info_) = -6;
  }
  else if ((*n_) < 0 || (itype_ == 4 && (*n_) != (*m_)) || (itype_ == 5 && (*n_) != (*m_))) {
    (*info_) = -7;
  }
  else if (itype_ <= 3 && (*lda_) < _max (1, (*m_))) {
    (*info_) = -9;
  }
  else if (itype_ >= 4) {
    if ((*kl_) < 0 || (*kl_) > _max ((*m_) - 1, 0)) {
      (*info_) = -2;
    }
    else if ((*ku_) < 0 || (*ku_) > _max ((*n_) - 1, 0) || ((itype_ == 4 || itype_ == 5) && (*kl_) != (*ku_))) {
      (*info_) = -3;
    }
    else if ((itype_ == 4 && (*lda_) < (*kl_) + 1) || (itype_ == 5 && (*lda_) < (*ku_) + 1) || (itype_ == 6 && (*lda_) < 2 
      * (*kl_) + (*ku_) + 1)) {
      (*info_) = -9;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_91, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  smlnum_ = _dlamch (_dc_28);
  bignum_ = 1.0 / smlnum_;
  cfromc_ = (*cfrom_);
  ctoc_ = (*cto_);
  _l10:;
  cfrom1_ = cfromc_ * smlnum_;
  cto1_ = ctoc_ / bignum_;
  if (_abs (cfrom1_) > _abs (ctoc_) && ctoc_ != 0.0) {
    mul_ = smlnum_;
    done_ = FALSE;
    cfromc_ = cfrom1_;
  }
  else if (_abs (cto1_) > _abs (cfromc_)) {
    mul_ = bignum_;
    done_ = FALSE;
    ctoc_ = cto1_;
  }
  else {
    mul_ = ctoc_ / cfromc_;
    done_ = TRUE;
  }
  if (itype_ == 0) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 2) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 3) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_ + 1, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 4) {
    k3_ = (*kl_) + 1;
    k4_ = (*n_) + 1;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (k3_, k4_ - j_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 5) {
    k1_ = (*ku_) + 2;
    k3_ = (*ku_) + 1;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = _max (k1_ - j_, 1); i_ <= k3_; (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 6) {
    k1_ = (*kl_) + (*ku_) + 2;
    k2_ = (*kl_) + 1;
    k3_ = 2 * (*kl_) + (*ku_) + 1;
    k4_ = (*kl_) + (*ku_) + 1 + (*m_);
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = _max (k1_ - j_, k2_); i_ <= _min (k3_, k4_ - j_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  if (! (done_)) {
    goto _l10;
  }
  _l0:;
  __calls[133].calls++;
  return 0;
}

int_4 _zlaset (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ alpha_, complex_16 _p_ beta_, complex_16 _p_ 
a_, int_4 _p_ lda_)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if (_lsame (uplo_, _dc_19)) {
    for (j_ = 2; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_ - 1, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
    for (i_ = 1; i_ <= _min ((*n_), (*m_)); (i_)++) {
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = (*beta_);
    }
  }
  else if (_lsame (uplo_, _dc_20)) {
    for (j_ = 1; j_ <= _min ((*m_), (*n_)); (j_)++) {
      for (i_ = j_ + 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
    for (i_ = 1; i_ <= _min ((*n_), (*m_)); (i_)++) {
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = (*beta_);
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
    for (i_ = 1; i_ <= _min ((*m_), (*n_)); (i_)++) {
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = (*beta_);
    }
  }
  __calls[134].calls++;
  return 0;
}

int_4 _zlassq (int_4 _p_ n_, complex_16 _p_ x_, int_4 _p_ incx_, real_8 _p_ scale_, real_8 _p_ sumsq_)
{
  static int_4 ix_;
  static real_8 temp1_;
  real_8 $0_, $1_, $2_, $3_;
  if ((*n_) > 0) {
    for (ix_ = 1; ((*incx_) > 0 ? ix_ <= 1 + ((*n_) - 1) * (*incx_) : ix_ >= 1 + ((*n_) - 1) * (*incx_)); ix_ += (*incx_)) 
      {
      if ((real_8) (creal (x_[ix_ - 1])) != 0.0) {
        temp1_ = _abs ((real_8) (creal (x_[ix_ - 1])));
        if ((*scale_) < temp1_) {
          (*sumsq_) = 1 + (*sumsq_) * ($0_ = ((*scale_) / temp1_), $0_ * $0_);
          (*scale_) = temp1_;
        }
        else {
          (*sumsq_) = (*sumsq_) + ($1_ = (temp1_ / (*scale_)), $1_ * $1_);
        }
      }
      if (cimag (x_[ix_ - 1]) != 0.0) {
        temp1_ = _abs (cimag (x_[ix_ - 1]));
        if ((*scale_) < temp1_) {
          (*sumsq_) = 1 + (*sumsq_) * ($2_ = ((*scale_) / temp1_), $2_ * $2_);
          (*scale_) = temp1_;
        }
        else {
          (*sumsq_) = (*sumsq_) + ($3_ = (temp1_ / (*scale_)), $3_ * $3_);
        }
      }
    }
  }
  __calls[135].calls++;
  return 0;
}

int_4 _zlaswp (int_4 _p_ n_, complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ k1_, int_4 _p_ k2_, int_4 _p_ ipiv_, int_4 
_p_ incx_)
{
  static int_4 i_, ip_, ix_;
  extern int_4 _zswap ();
  if ((*incx_) == 0) {
    goto _l0;
  }
  if ((*incx_) > 0) {
    ix_ = (*k1_);
  }
  else {
    ix_ = 1 + (1 - (*k2_)) * (*incx_);
  }
  if ((*incx_) == 1) {
    for (i_ = (*k1_); i_ <= (*k2_); (i_)++) {
      ip_ = ipiv_[i_ - 1];
      if (ip_ != i_) {
        (void) _zswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
    }
  }
  else if ((*incx_) > 1) {
    for (i_ = (*k1_); i_ <= (*k2_); (i_)++) {
      ip_ = ipiv_[ix_ - 1];
      if (ip_ != i_) {
        (void) _zswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
      ix_ = ix_ + (*incx_);
    }
  }
  else if ((*incx_) < 0) {
    for (i_ = (*k2_); i_ >= (*k1_); (i_)--) {
      ip_ = ipiv_[ix_ - 1];
      if (ip_ != i_) {
        (void) _zswap (n_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &a_[ip_ - 1 + ((*lda_)) * ((0))], lda_);
      }
      ix_ = ix_ + (*incx_);
    }
  }
  _l0:;
  __calls[136].calls++;
  return 0;
}

int_4 _zlatrs (char _p_ uplo_, char _p_ trans_, char _p_ diag_, char _p_ normin_, int_4 _p_ n_, complex_16 _p_ a_, 
int_4 _p_ lda_, complex_16 _p_ x_, real_8 _p_ scale_, real_8 _p_ cnorm_, int_4 _p_ info_)
{
  static int_4 i_, imax_, j_, jfirst_, jinc_, jlast_;
  static logical_4 notran_, nounit_, upper_;
  static real_8 bignum_, grow_, rec_, smlnum_, tjj_, tmax_, tscal_, xbnd_, xj_, xmax_;
  static complex_16 csumj_, tjjs_, uscal_, zdum_;
  int_4 $0_, $1_, $2_, $4_, $6_, $7_, $9_, $10_, $11_, $12_, $13_;
  real_8 $3_, $14_;
  complex_16 $5_, $8_;
  extern logical_4 _lsame ();
  extern int_4 _idamax ();
  extern int_4 _izamax ();
  extern real_8 _dlamch ();
  extern real_8 _dzasum ();
  extern complex_16 _zdotc ();
  extern complex_16 _zdotu ();
  extern int_4 _dlabad ();
  extern int_4 _dscal ();
  extern int_4 _xerbla ();
  extern int_4 _zaxpy ();
  extern int_4 _zdscal ();
  extern int_4 _ztrsv ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  (*info_) = 0;
  upper_ = _lsame (uplo_, _dc_19);
  notran_ = _lsame (trans_, _dc_7);
  nounit_ = _lsame (diag_, _dc_7);
  if (! (upper_) && ! (_lsame (uplo_, _dc_20))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_8)) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -2;
  }
  else if (! (nounit_) && ! (_lsame (diag_, _dc_19))) {
    (*info_) = -3;
  }
  else if (! (_lsame (normin_, _dc_35)) && ! (_lsame (normin_, _dc_7))) {
    (*info_) = -4;
  }
  else if ((*n_) < 0) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    (*info_) = -7;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_92, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  smlnum_ = _dlamch (_dc_18);
  bignum_ = 1.0 / smlnum_;
  (void) _dlabad (&smlnum_, &bignum_);
  smlnum_ = smlnum_ / _dlamch (_dc_21);
  bignum_ = 1.0 / smlnum_;
  (*scale_) = 1.0;
  if (_lsame (normin_, _dc_7)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        cnorm_[j_ - 1] = _dzasum (($1_ = j_ - 1, &$1_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
        cnorm_[j_ - 1] = _dzasum (($2_ = (*n_) - j_, &$2_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
      }
      cnorm_[(*n_) - 1] = 0.0;
    }
  }
  imax_ = _idamax (n_, cnorm_, &_k1);
  tmax_ = cnorm_[imax_ - 1];
  if (tmax_ <= bignum_ * 0.5) {
    tscal_ = 1.0;
  }
  else {
    tscal_ = 0.5 / (smlnum_ * tmax_);
    (void) _dscal (n_, &tscal_, cnorm_, &_k1);
  }
  xmax_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    xmax_ = _max (xmax_, ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_)) / 2.0e0) + _abs (cimag 
    (zdum__1_) / 2.0e0);}));
  }
  xbnd_ = xmax_;
  if (notran_) {
    if (upper_) {
      jfirst_ = (*n_);
      jlast_ = 1;
      jinc_ = -1;
    }
    else {
      jfirst_ = 1;
      jlast_ = (*n_);
      jinc_ = 1;
    }
    if (tscal_ != 1.0) {
      grow_ = 0.0;
      goto _l60;
    }
    if (nounit_) {
      grow_ = 0.5 / _max (xbnd_, smlnum_);
      xbnd_ = grow_;
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l60;
        }
        tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
        tjj_ = ({complex_16 zdum__1_ = tjjs_; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
        if (tjj_ >= smlnum_) {
          xbnd_ = _min (xbnd_, _min (1.0, tjj_) * grow_);
        }
        else {
          xbnd_ = 0.0;
        }
        if (tjj_ + cnorm_[j_ - 1] >= smlnum_) {
          grow_ = grow_ * (tjj_ / (tjj_ + cnorm_[j_ - 1]));
        }
        else {
          grow_ = 0.0;
        }
      }
      grow_ = xbnd_;
    }
    else {
      grow_ = _min (1.0, 0.5 / _max (xbnd_, smlnum_));
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l60;
        }
        grow_ = grow_ * (1.0 / (1.0 + cnorm_[j_ - 1]));
      }
    }
    _l60:;
  }
  else {
    if (upper_) {
      jfirst_ = 1;
      jlast_ = (*n_);
      jinc_ = 1;
    }
    else {
      jfirst_ = (*n_);
      jlast_ = 1;
      jinc_ = -1;
    }
    if (tscal_ != 1.0) {
      grow_ = 0.0;
      goto _l90;
    }
    if (nounit_) {
      grow_ = 0.5 / _max (xbnd_, smlnum_);
      xbnd_ = grow_;
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l90;
        }
        xj_ = 1.0 + cnorm_[j_ - 1];
        grow_ = _min (grow_, xbnd_ / xj_);
        tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
        tjj_ = ({complex_16 zdum__1_ = tjjs_; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
        if (tjj_ >= smlnum_) {
          if (xj_ > tjj_) {
            xbnd_ = xbnd_ * (tjj_ / xj_);
          }
        }
        else {
          xbnd_ = 0.0;
        }
      }
      grow_ = _min (grow_, xbnd_);
    }
    else {
      grow_ = _min (1.0, 0.5 / _max (xbnd_, smlnum_));
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l90;
        }
        xj_ = 1.0 + cnorm_[j_ - 1];
        grow_ = grow_ / xj_;
      }
    }
    _l90:;
  }
  if ((grow_ * tscal_) > smlnum_) {
    (void) _ztrsv (uplo_, trans_, diag_, n_, a_, lda_, x_, &_k1);
  }
  else {
    if (xmax_ > bignum_ * 0.5) {
      (*scale_) = (bignum_ * 0.5) / xmax_;
      (void) _zdscal (n_, scale_, x_, &_k1);
      xmax_ = bignum_;
    }
    else {
      xmax_ = xmax_ * 2.0;
    }
    if (notran_) {
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        xj_ = ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
        if (nounit_) {
          tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
        }
        else {
          tjjs_ = tscal_;
          if (tscal_ == 1.0) {
            goto _l110;
          }
        }
        tjj_ = ({complex_16 zdum__1_ = tjjs_; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
        if (tjj_ > smlnum_) {
          if (tjj_ < 1.0) {
            if (xj_ > tjj_ * bignum_) {
              rec_ = 1.0 / xj_;
              (void) _zdscal (n_, &rec_, x_, &_k1);
              (*scale_) = (*scale_) * rec_;
              xmax_ = xmax_ * rec_;
            }
          }
          x_[j_ - 1] = _zladiv (&x_[j_ - 1], &tjjs_);
          xj_ = ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
        }
        else if (tjj_ > 0.0) {
          if (xj_ > tjj_ * bignum_) {
            rec_ = (tjj_ * bignum_) / xj_;
            if (cnorm_[j_ - 1] > 1.0) {
              rec_ = rec_ / cnorm_[j_ - 1];
            }
            (void) _zdscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
            xmax_ = xmax_ * rec_;
          }
          x_[j_ - 1] = _zladiv (&x_[j_ - 1], &tjjs_);
          xj_ = ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
        }
        else {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            x_[i_ - 1] = 0.0;
          }
          x_[j_ - 1] = 1.0;
          xj_ = 1.0;
          (*scale_) = 0.0;
          xmax_ = 0.0;
        }
        _l110:;
        if (xj_ > 1.0) {
          rec_ = 1.0 / xj_;
          if (cnorm_[j_ - 1] > (bignum_ - xmax_) * rec_) {
            rec_ = rec_ * 0.5;
            (void) _zdscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
          }
        }
        else if (xj_ * cnorm_[j_ - 1] > (bignum_ - xmax_)) {
          (void) _zdscal (n_, ($3_ = 0.5, &$3_), x_, &_k1);
          (*scale_) = (*scale_) * 0.5;
        }
        if (upper_) {
          if (j_ > 1) {
            (void) _zaxpy (($4_ = j_ - 1, &$4_), ($5_ = -x_[j_ - 1] * tscal_, &$5_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, x_, 
            &_k1);
            i_ = _izamax (($6_ = j_ - 1, &$6_), x_, &_k1);
            xmax_ = ({complex_16 zdum__1_ = x_[i_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
          }
        }
        else {
          if (j_ < (*n_)) {
            (void) _zaxpy (($7_ = (*n_) - j_, &$7_), ($8_ = -x_[j_ - 1] * tscal_, &$8_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], 
            &_k1, &x_[j_ + 1 - 1], &_k1);
            i_ = j_ + _izamax (($9_ = (*n_) - j_, &$9_), &x_[j_ + 1 - 1], &_k1);
            xmax_ = ({complex_16 zdum__1_ = x_[i_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
          }
        }
      }
    }
    else if (_lsame (trans_, _dc_8)) {
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        xj_ = ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
        uscal_ = tscal_;
        rec_ = 1.0 / _max (xmax_, 1.0);
        if (cnorm_[j_ - 1] > (bignum_ - xj_) * rec_) {
          rec_ = rec_ * 0.5;
          if (nounit_) {
            tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
          }
          else {
            tjjs_ = tscal_;
          }
          tjj_ = ({complex_16 zdum__1_ = tjjs_; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
          if (tjj_ > 1.0) {
            rec_ = _min (1.0, rec_ * tjj_);
            uscal_ = _zladiv (&uscal_, &tjjs_);
          }
          if (rec_ < 1.0) {
            (void) _zdscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
            xmax_ = xmax_ * rec_;
          }
        }
        csumj_ = 0.0;
        if (uscal_ == (complex_16) (1.0)) {
          if (upper_) {
            csumj_ = _zdotu (($10_ = j_ - 1, &$10_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, x_, &_k1);
          }
          else if (j_ < (*n_)) {
            csumj_ = _zdotu (($11_ = (*n_) - j_, &$11_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1, &x_[j_ + 1 - 1], &_k1);
          }
        }
        else {
          if (upper_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              csumj_ = csumj_ + (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * uscal_) * x_[i_ - 1];
            }
          }
          else if (j_ < (*n_)) {
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              csumj_ = csumj_ + (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * uscal_) * x_[i_ - 1];
            }
          }
        }
        if (uscal_ == (complex_16) (tscal_)) {
          x_[j_ - 1] = x_[j_ - 1] - csumj_;
          xj_ = ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
          if (nounit_) {
            tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
          }
          else {
            tjjs_ = tscal_;
            if (tscal_ == 1.0) {
              goto _l160;
            }
          }
          tjj_ = ({complex_16 zdum__1_ = tjjs_; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
          if (tjj_ > smlnum_) {
            if (tjj_ < 1.0) {
              if (xj_ > tjj_ * bignum_) {
                rec_ = 1.0 / xj_;
                (void) _zdscal (n_, &rec_, x_, &_k1);
                (*scale_) = (*scale_) * rec_;
                xmax_ = xmax_ * rec_;
              }
            }
            x_[j_ - 1] = _zladiv (&x_[j_ - 1], &tjjs_);
          }
          else if (tjj_ > 0.0) {
            if (xj_ > tjj_ * bignum_) {
              rec_ = (tjj_ * bignum_) / xj_;
              (void) _zdscal (n_, &rec_, x_, &_k1);
              (*scale_) = (*scale_) * rec_;
              xmax_ = xmax_ * rec_;
            }
            x_[j_ - 1] = _zladiv (&x_[j_ - 1], &tjjs_);
          }
          else {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = 0.0;
            }
            x_[j_ - 1] = 1.0;
            (*scale_) = 0.0;
            xmax_ = 0.0;
          }
          _l160:;
        }
        else {
          x_[j_ - 1] = _zladiv (&x_[j_ - 1], &tjjs_) - csumj_;
        }
        xmax_ = _max (xmax_, ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag 
        (zdum__1_));}));
      }
    }
    else {
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        xj_ = ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
        uscal_ = tscal_;
        rec_ = 1.0 / _max (xmax_, 1.0);
        if (cnorm_[j_ - 1] > (bignum_ - xj_) * rec_) {
          rec_ = rec_ * 0.5;
          if (nounit_) {
            tjjs_ = __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]) * tscal_;
          }
          else {
            tjjs_ = tscal_;
          }
          tjj_ = ({complex_16 zdum__1_ = tjjs_; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
          if (tjj_ > 1.0) {
            rec_ = _min (1.0, rec_ * tjj_);
            uscal_ = _zladiv (&uscal_, &tjjs_);
          }
          if (rec_ < 1.0) {
            (void) _zdscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
            xmax_ = xmax_ * rec_;
          }
        }
        csumj_ = 0.0;
        if (uscal_ == (complex_16) (1.0)) {
          if (upper_) {
            csumj_ = _zdotc (($12_ = j_ - 1, &$12_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, x_, &_k1);
          }
          else if (j_ < (*n_)) {
            csumj_ = _zdotc (($13_ = (*n_) - j_, &$13_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1, &x_[j_ + 1 - 1], &_k1);
          }
        }
        else {
          if (upper_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              csumj_ = csumj_ + (__dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * uscal_) * x_[i_ - 1];
            }
          }
          else if (j_ < (*n_)) {
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              csumj_ = csumj_ + (__dconjg (&a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]) * uscal_) * x_[i_ - 1];
            }
          }
        }
        if (uscal_ == (complex_16) (tscal_)) {
          x_[j_ - 1] = x_[j_ - 1] - csumj_;
          xj_ = ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
          if (nounit_) {
            tjjs_ = __dconjg (&a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]) * tscal_;
          }
          else {
            tjjs_ = tscal_;
            if (tscal_ == 1.0) {
              goto _l210;
            }
          }
          tjj_ = ({complex_16 zdum__1_ = tjjs_; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag (zdum__1_));});
          if (tjj_ > smlnum_) {
            if (tjj_ < 1.0) {
              if (xj_ > tjj_ * bignum_) {
                rec_ = 1.0 / xj_;
                (void) _zdscal (n_, &rec_, x_, &_k1);
                (*scale_) = (*scale_) * rec_;
                xmax_ = xmax_ * rec_;
              }
            }
            x_[j_ - 1] = _zladiv (&x_[j_ - 1], &tjjs_);
          }
          else if (tjj_ > 0.0) {
            if (xj_ > tjj_ * bignum_) {
              rec_ = (tjj_ * bignum_) / xj_;
              (void) _zdscal (n_, &rec_, x_, &_k1);
              (*scale_) = (*scale_) * rec_;
              xmax_ = xmax_ * rec_;
            }
            x_[j_ - 1] = _zladiv (&x_[j_ - 1], &tjjs_);
          }
          else {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = 0.0;
            }
            x_[j_ - 1] = 1.0;
            (*scale_) = 0.0;
            xmax_ = 0.0;
          }
          _l210:;
        }
        else {
          x_[j_ - 1] = _zladiv (&x_[j_ - 1], &tjjs_) - csumj_;
        }
        xmax_ = _max (xmax_, ({complex_16 zdum__1_ = x_[j_ - 1]; _abs ((real_8) (creal (zdum__1_))) + _abs (cimag 
        (zdum__1_));}));
      }
    }
    (*scale_) = (*scale_) / tscal_;
  }
  if (tscal_ != 1.0) {
    (void) _dscal (n_, ($14_ = 1.0 / tscal_, &$14_), cnorm_, &_k1);
  }
  _l0:;
  __calls[137].calls++;
  return 0;
}

int_4 _zrot (int_4 _p_ n_, complex_16 _p_ cx_, int_4 _p_ incx_, complex_16 _p_ cy_, int_4 _p_ incy_, real_8 _p_ c_, 
complex_16 _p_ s_)
{
  static int_4 i_, ix_, iy_;
  static complex_16 stemp_;
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  if ((*n_) <= 0) {
    goto _l0;
  }
  if ((*incx_) == 1 && (*incy_) == 1) {
    goto _l20;
  }
  ix_ = 1;
  iy_ = 1;
  if ((*incx_) < 0) {
    ix_ = (-(*n_) + 1) * (*incx_) + 1;
  }
  if ((*incy_) < 0) {
    iy_ = (-(*n_) + 1) * (*incy_) + 1;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = (*c_) * cx_[ix_ - 1] + (*s_) * cy_[iy_ - 1];
    cy_[iy_ - 1] = (*c_) * cy_[iy_ - 1] - __dconjg (s_) * cx_[ix_ - 1];
    cx_[ix_ - 1] = stemp_;
    ix_ = ix_ + (*incx_);
    iy_ = iy_ + (*incy_);
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    stemp_ = (*c_) * cx_[i_ - 1] + (*s_) * cy_[i_ - 1];
    cy_[i_ - 1] = (*c_) * cy_[i_ - 1] - __dconjg (s_) * cx_[i_ - 1];
    cx_[i_ - 1] = stemp_;
  }
  _l0:;
  __calls[138].calls++;
  return 0;
}

int_4 _ztrevc (char _p_ side_, char _p_ howmny_, logical_4 _p_ select_, int_4 _p_ n_, complex_16 _p_ t_, int_4 _p_ ldt_
, complex_16 _p_ vl_, int_4 _p_ ldvl_, complex_16 _p_ vr_, int_4 _p_ ldvr_, int_4 _p_ mm_, int_4 _p_ m_, complex_16 _p_ 
work_, real_8 _p_ rwork_, int_4 _p_ info_)
{
  static int_4 i_, ii_, is_, j_, k_, ki_;
  static logical_4 allv_, bothv_, leftv_, over_, rightv_, somev_;
  static real_8 ovfl_, remax_, scale_, smin_, smlnum_, ulp_, unfl_;
  static complex_16 cdum_;
  int_4 $0_, $1_, $2_, $3_, $6_, $7_, $8_, $9_, $10_;
  complex_16 $4_, $5_, $11_, $12_;
  extern logical_4 _lsame ();
  extern int_4 _izamax ();
  extern real_8 _dlamch ();
  extern real_8 _dzasum ();
  extern int_4 _dlabad ();
  extern int_4 _xerbla ();
  extern int_4 _zcopy ();
  extern int_4 _zdscal ();
  extern int_4 _zgemv ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  bothv_ = _lsame (side_, _dc_31);
  rightv_ = _lsame (side_, _dc_37) || bothv_;
  leftv_ = _lsame (side_, _dc_20) || bothv_;
  allv_ = _lsame (howmny_, _dc_38);
  over_ = _lsame (howmny_, _dc_31) || _lsame (howmny_, _dc_24);
  somev_ = _lsame (howmny_, _dc_28);
  if (somev_) {
    (*m_) = 0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (select_[j_ - 1]) {
        (*m_) = (*m_) + 1;
      }
    }
  }
  else {
    (*m_) = (*n_);
  }
  (*info_) = 0;
  if (! (rightv_) && ! (leftv_)) {
    (*info_) = -1;
  }
  else if (! (allv_) && ! (over_) && ! (somev_)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  else if ((*ldvl_) < 1 || (leftv_ && (*ldvl_) < (*n_))) {
    (*info_) = -8;
  }
  else if ((*ldvr_) < 1 || (rightv_ && (*ldvr_) < (*n_))) {
    (*info_) = -10;
  }
  else if ((*mm_) < (*m_)) {
    (*info_) = -11;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_93, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  unfl_ = _dlamch (_dc_18);
  ovfl_ = 1.0 / unfl_;
  (void) _dlabad (&unfl_, &ovfl_);
  ulp_ = _dlamch (_dc_21);
  smlnum_ = unfl_ * ((*n_) / ulp_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    work_[i_ + (*n_) - 1] = t_[i_ - 1 + ((*ldt_)) * ((i_ - 1))];
  }
  rwork_[0] = 0.0;
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    rwork_[j_ - 1] = _dzasum (($1_ = j_ - 1, &$1_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1);
  }
  if (rightv_) {
    is_ = (*m_);
    for (ki_ = (*n_); ki_ >= 1; (ki_)--) {
      if (somev_) {
        if (! (select_[ki_ - 1])) {
          goto _l80;
        }
      }
      smin_ = _max (ulp_ * (({complex_16 cdum__1_ = t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))]; _abs ((real_8) (creal (cdum__1_))) 
      + _abs (cimag (cdum__1_));})), smlnum_);
      work_[0] = CMPLX (1.0, 0.0);
      for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
        work_[k_ - 1] = -t_[k_ - 1 + ((*ldt_)) * ((ki_ - 1))];
      }
      for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
        t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] - t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))];
        if (({complex_16 cdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_8) (creal (cdum__1_))) + _abs (cimag 
        (cdum__1_));}) < smin_) {
        t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = smin_;
      }
    }
    if (ki_ > 1) {
      (void) _zlatrs (_dc_11, _dc_5, _dc_12, _dc_35, ($2_ = ki_ - 1, &$2_), t_, ldt_, &work_[0], &scale_, rwork_, info_);
      work_[ki_ - 1] = scale_;
    }
    if (! (over_)) {
      (void) _zcopy (&ki_, &work_[0], &_k1, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
      ii_ = _izamax (&ki_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
      remax_ = 1.0 / ({complex_16 cdum__1_ = vr_[ii_ - 1 + ((*ldvr_)) * ((is_ - 1))]; _abs ((real_8) (creal (cdum__1_))) + 
      _abs (cimag (cdum__1_));});
      (void) _zdscal (&ki_, &remax_, &vr_[0 + ((*ldvr_)) * ((is_ - 1))], &_k1);
      for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
        vr_[k_ - 1 + ((*ldvr_)) * ((is_ - 1))] = CMPLX (0.0, 0.0);
      }
    }
    else {
      if (ki_ > 1) {
        (void) _zgemv (_dc_7, n_, ($3_ = ki_ - 1, &$3_), ($4_ = CMPLX (1.0, 0.0), &$4_), vr_, ldvr_, &work_[0], &_k1, ($5_ = 
        (complex_16) (scale_), &$5_), &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
      }
      ii_ = _izamax (n_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
      remax_ = 1.0 / ({complex_16 cdum__1_ = vr_[ii_ - 1 + ((*ldvr_)) * ((ki_ - 1))]; _abs ((real_8) (creal (cdum__1_))) + 
      _abs (cimag (cdum__1_));});
      (void) _zdscal (n_, &remax_, &vr_[0 + ((*ldvr_)) * ((ki_ - 1))], &_k1);
    }
    for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
      t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = work_[k_ + (*n_) - 1];
    }
    is_ = is_ - 1;
    _l80:;
  }
}

if (leftv_) {
  is_ = 1;
  for (ki_ = 1; ki_ <= (*n_); (ki_)++) {
    if (somev_) {
      if (! (select_[ki_ - 1])) {
        goto _l130;
      }
    }
    smin_ = _max (ulp_ * (({complex_16 cdum__1_ = t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))]; _abs ((real_8) (creal (cdum__1_))) 
    + _abs (cimag (cdum__1_));})), smlnum_);
    work_[(*n_) - 1] = CMPLX (1.0, 0.0);
    for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
      work_[k_ - 1] = -__dconjg (&t_[ki_ - 1 + ((*ldt_)) * ((k_ - 1))]);
    }
    for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
      t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] - t_[ki_ - 1 + ((*ldt_)) * ((ki_ - 1))];
      if (({complex_16 cdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_8) (creal (cdum__1_))) + _abs (cimag 
      (cdum__1_));}) < smin_) {
      t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = smin_;
    }
  }
  if (ki_ < (*n_)) {
    (void) _zlatrs (_dc_11, _dc_14, _dc_12, _dc_35, ($6_ = (*n_) - ki_, &$6_), &t_[ki_ + 1 - 1 + ((*ldt_)) * ((ki_ + 1 - 
    1))], ldt_, &work_[ki_ + 1 - 1], &scale_, rwork_, info_);
    work_[ki_ - 1] = scale_;
  }
  if (! (over_)) {
    (void) _zcopy (($7_ = (*n_) - ki_ + 1, &$7_), &work_[ki_ - 1], &_k1, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1);
    ii_ = _izamax (($8_ = (*n_) - ki_ + 1, &$8_), &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1) + ki_ - 1;
    remax_ = 1.0 / ({complex_16 cdum__1_ = vl_[ii_ - 1 + ((*ldvl_)) * ((is_ - 1))]; _abs ((real_8) (creal (cdum__1_))) + 
    _abs (cimag (cdum__1_));});
    (void) _zdscal (($9_ = (*n_) - ki_ + 1, &$9_), &remax_, &vl_[ki_ - 1 + ((*ldvl_)) * ((is_ - 1))], &_k1);
    for (k_ = 1; k_ <= ki_ - 1; (k_)++) {
      vl_[k_ - 1 + ((*ldvl_)) * ((is_ - 1))] = CMPLX (0.0, 0.0);
    }
  }
  else {
    if (ki_ < (*n_)) {
      (void) _zgemv (_dc_7, n_, ($10_ = (*n_) - ki_, &$10_), ($11_ = CMPLX (1.0, 0.0), &$11_), &vl_[0 + ((*ldvl_)) * ((ki_ + 
      1 - 1))], ldvl_, &work_[ki_ + 1 - 1], &_k1, ($12_ = (complex_16) (scale_), &$12_), &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], 
      &_k1);
    }
    ii_ = _izamax (n_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
    remax_ = 1.0 / ({complex_16 cdum__1_ = vl_[ii_ - 1 + ((*ldvl_)) * ((ki_ - 1))]; _abs ((real_8) (creal (cdum__1_))) + 
    _abs (cimag (cdum__1_));});
    (void) _zdscal (n_, &remax_, &vl_[0 + ((*ldvl_)) * ((ki_ - 1))], &_k1);
  }
  for (k_ = ki_ + 1; k_ <= (*n_); (k_)++) {
    t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = work_[k_ + (*n_) - 1];
  }
  is_ = is_ + 1;
  _l130:;
}

}

_l0:;
__calls[139].calls++;
return 0;
}

int_4 _ztrexc (char _p_ compq_, int_4 _p_ n_, complex_16 _p_ t_, int_4 _p_ ldt_, complex_16 _p_ q_, int_4 _p_ ldq_, 
int_4 _p_ ifst_, int_4 _p_ ilst_, int_4 _p_ info_)
{
  static int_4 k_, m1_, m2_, m3_;
  static logical_4 wantq_;
  static real_8 cs_;
  static complex_16 sn_, t11_, t22_, temp_;
  int_4 $0_, $2_, $3_;
  complex_16 $1_, $4_, $5_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  (*info_) = 0;
  wantq_ = _lsame (compq_, _dc_40);
  if (! (_lsame (compq_, _dc_7)) && ! (wantq_)) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -4;
  }
  else if ((*ldq_) < 1 || (wantq_ && (*ldq_) < _max (1, (*n_)))) {
    (*info_) = -6;
  }
  else if ((*ifst_) < 1 || (*ifst_) > (*n_)) {
    (*info_) = -7;
  }
  else if ((*ilst_) < 1 || (*ilst_) > (*n_)) {
    (*info_) = -8;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_94, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 1 || (*ifst_) == (*ilst_)) {
    goto _l0;
  }
  if ((*ifst_) < (*ilst_)) {
    m1_ = 0;
    m2_ = -1;
    m3_ = 1;
  }
  else {
    m1_ = -1;
    m2_ = 0;
    m3_ = -1;
  }
  for (k_ = (*ifst_) + m1_; (m3_ > 0 ? k_ <= (*ilst_) + m2_ : k_ >= (*ilst_) + m2_); k_ += m3_) {
    t11_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    t22_ = t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ + 1 - 1))];
    (void) _zlartg (&t_[k_ - 1 + ((*ldt_)) * ((k_ + 1 - 1))], ($1_ = t22_ - t11_, &$1_), &cs_, &sn_, &temp_);
    if (k_ + 2 <= (*n_)) {
      (void) _zrot (($2_ = (*n_) - k_ - 1, &$2_), &t_[k_ - 1 + ((*ldt_)) * ((k_ + 2 - 1))], ldt_, &t_[k_ + 1 - 1 + ((*ldt_)) 
      * ((k_ + 2 - 1))], ldt_, &cs_, &sn_);
    }
    (void) _zrot (($3_ = k_ - 1, &$3_), &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[0 + ((*ldt_)) * ((k_ + 1 - 1))], &_k1, 
    &cs_, ($4_ = __dconjg (&sn_), &$4_));
    t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = t22_;
    t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ + 1 - 1))] = t11_;
    if (wantq_) {
      (void) _zrot (n_, &q_[0 + ((*ldq_)) * ((k_ - 1))], &_k1, &q_[0 + ((*ldq_)) * ((k_ + 1 - 1))], &_k1, &cs_, ($5_ = 
      __dconjg (&sn_), &$5_));
    }
  }
  _l0:;
  __calls[140].calls++;
  return 0;
}

int_4 _ztrsen (char _p_ job_, char _p_ compq_, logical_4 _p_ select_, int_4 _p_ n_, complex_16 _p_ t_, int_4 _p_ ldt_, 
complex_16 _p_ q_, int_4 _p_ ldq_, complex_16 _p_ w_, int_4 _p_ m_, real_8 _p_ s_, real_8 _p_ sep_, complex_16 _p_ 
work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 ierr_, k_, kase_, ks_, n1_, n2_, nn_;
  static logical_4 wantbh_, wantq_, wants_, wantsp_;
  static real_8 est_, rnorm_, scale_, rwork_[1];
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  wantbh_ = _lsame (job_, _dc_31);
  wants_ = _lsame (job_, _dc_27) || wantbh_;
  wantsp_ = _lsame (job_, _dc_40) || wantbh_;
  wantq_ = _lsame (compq_, _dc_40);
  (*m_) = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (select_[k_ - 1]) {
      (*m_) = (*m_) + 1;
    }
  }
  n1_ = (*m_);
  n2_ = (*n_) - (*m_);
  nn_ = n1_ * n2_;
  (*info_) = 0;
  if (! (_lsame (job_, _dc_7)) && ! (wants_) && ! (wantsp_)) {
    (*info_) = -1;
  }
  else if (! (_lsame (compq_, _dc_7)) && ! (wantq_)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*ldt_) < _max (1, (*n_))) {
    (*info_) = -6;
  }
  else if ((*ldq_) < 1 || (wantq_ && (*ldq_) < (*n_))) {
    (*info_) = -8;
  }
  else if ((*lwork_) < 1 || ((wants_ && ! (wantsp_)) && (*lwork_) < nn_) || (wantsp_ && (*lwork_) < 2 * nn_)) {
    (*info_) = -14;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_95, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == (*n_) || (*m_) == 0) {
    if (wants_) {
      (*s_) = 1.0;
    }
    if (wantsp_) {
      (*sep_) = _zlange (_dc_22, n_, n_, t_, ldt_, rwork_);
    }
    goto _l40;
  }
  ks_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (select_[k_ - 1]) {
      ks_ = ks_ + 1;
      if (k_ != ks_) {
        (void) _ztrexc (compq_, n_, t_, ldt_, q_, ldq_, &k_, &ks_, &ierr_);
      }
    }
  }
  if (wants_) {
    (void) _zlacpy (_dc_26, &n1_, &n2_, &t_[0 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, &n1_);
    (void) _ztrsyl (_dc_7, _dc_7, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
    &n1_, &scale_, &ierr_);
    rnorm_ = _zlange (_dc_26, &n1_, &n2_, work_, &n1_, rwork_);
    if (rnorm_ == 0.0) {
      (*s_) = 1.0;
    }
    else {
      (*s_) = scale_ / (sqrt (scale_ * scale_ / rnorm_ + rnorm_) * sqrt (rnorm_));
    }
  }
  if (wantsp_) {
    est_ = 0.0;
    kase_ = 0;
    _l30:;
    (void) _zlacon (&nn_, &work_[nn_ + 1 - 1], work_, &est_, &kase_);
    if (kase_ != 0) {
      if (kase_ == 1) {
        (void) _ztrsyl (_dc_7, _dc_7, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
        &n1_, &scale_, &ierr_);
      }
      else {
        (void) _ztrsyl (_dc_9, _dc_9, &_km1, &n1_, &n2_, t_, ldt_, &t_[n1_ + 1 - 1 + ((*ldt_)) * ((n1_ + 1 - 1))], ldt_, work_, 
        &n1_, &scale_, &ierr_);
      }
      goto _l30;
    }
    (*sep_) = scale_ / est_;
  }
  _l40:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    w_[k_ - 1] = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
  }
  _l0:;
  __calls[141].calls++;
  return 0;
}

int_4 _ztrsyl (char _p_ trana_, char _p_ tranb_, int_4 _p_ isgn_, int_4 _p_ m_, int_4 _p_ n_, complex_16 _p_ a_, int_4 
_p_ lda_, complex_16 _p_ b_, int_4 _p_ ldb_, complex_16 _p_ c_, int_4 _p_ ldc_, real_8 _p_ scale_, int_4 _p_ info_)
{
  static int_4 j_, k_, l_;
  static logical_4 notrna_, notrnb_;
  static real_8 bignum_, da11_, db_, eps_, scaloc_, sgn_, smin_, smlnum_, dum_[1];
  static complex_16 a11_, suml_, sumr_, vec_, x11_;
  int_4 $0_, $2_, $3_, $4_, $5_, $6_, $7_, $9_, $10_;
  real_8 $1_;
  complex_16 $8_;
  extern logical_4 _lsame ();
  extern real_8 _dlamch ();
  extern complex_16 _zdotc ();
  extern complex_16 _zdotu ();
  extern int_4 _dlabad ();
  extern int_4 _xerbla ();
  extern int_4 _zdscal ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  notrna_ = _lsame (trana_, _dc_7);
  notrnb_ = _lsame (tranb_, _dc_7);
  (*info_) = 0;
  if (! (notrna_) && ! (_lsame (trana_, _dc_8)) && ! (_lsame (trana_, _dc_9))) {
    (*info_) = -1;
  }
  else if (! (notrnb_) && ! (_lsame (tranb_, _dc_8)) && ! (_lsame (tranb_, _dc_9))) {
    (*info_) = -2;
  }
  else if ((*isgn_) != 1 && (*isgn_) != -1) {
    (*info_) = -3;
  }
  else if ((*m_) < 0) {
    (*info_) = -4;
  }
  else if ((*n_) < 0) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -7;
  }
  else if ((*ldb_) < _max (1, (*n_))) {
    (*info_) = -9;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -11;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_96, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  eps_ = _dlamch (_dc_44);
  smlnum_ = _dlamch (_dc_28);
  bignum_ = 1.0 / smlnum_;
  (void) _dlabad (&smlnum_, &bignum_);
  smlnum_ = smlnum_ * (real_8) ((*m_) * (*n_)) / eps_;
  bignum_ = 1.0 / smlnum_;
  smin_ = ($1_ = _max (smlnum_, eps_ * _zlange (_dc_23, m_, m_, a_, lda_, dum_)), _max ($1_, eps_ * _zlange (_dc_23, n_, 
  n_, b_, ldb_, dum_)));
  (*scale_) = 1.0;
  sgn_ = (*isgn_);
  if (notrna_ && notrnb_) {
    for (l_ = 1; l_ <= (*n_); (l_)++) {
      for (k_ = (*m_); k_ >= 1; (k_)--) {
        suml_ = _zdotu (($2_ = (*m_) - k_, &$2_), &a_[k_ - 1 + ((*lda_)) * ((_min (k_ + 1, (*m_)) - 1))], lda_, &c_[_min (k_ + 
        1, (*m_)) - 1 + ((*ldc_)) * ((l_ - 1))], &_k1);
        sumr_ = _zdotu (($3_ = l_ - 1, &$3_), &c_[k_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l_ - 1))], &_k1);
        vec_ = c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] - (suml_ + sgn_ * sumr_);
        scaloc_ = 1.0;
        a11_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + sgn_ * b_[l_ - 1 + ((*ldb_)) * ((l_ - 1))];
        da11_ = _abs ((real_8) (creal (a11_))) + _abs (cimag (a11_));
        if (da11_ <= smin_) {
          a11_ = smin_;
          da11_ = smin_;
          (*info_) = 1;
        }
        db_ = _abs ((real_8) (creal (vec_))) + _abs (cimag (vec_));
        if (da11_ < 1.0 && db_ > 1.0) {
          if (db_ > bignum_ * da11_) {
            scaloc_ = 1.0 / db_;
          }
        }
        x11_ = (vec_ * (complex_16) (scaloc_)) / a11_;
        if (scaloc_ != 1.0) {
          for (j_ = 1; j_ <= (*n_); (j_)++) {
            (void) _zdscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
          }
          (*scale_) = (*scale_) * scaloc_;
        }
        c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] = x11_;
      }
    }
  }
  else if (! (notrna_) && notrnb_) {
    for (l_ = 1; l_ <= (*n_); (l_)++) {
      for (k_ = 1; k_ <= (*m_); (k_)++) {
        suml_ = _zdotc (($4_ = k_ - 1, &$4_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l_ - 1))], &_k1);
        sumr_ = _zdotu (($5_ = l_ - 1, &$5_), &c_[k_ - 1 + ((*ldc_)) * ((0))], ldc_, &b_[0 + ((*ldb_)) * ((l_ - 1))], &_k1);
        vec_ = c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] - (suml_ + sgn_ * sumr_);
        scaloc_ = 1.0;
        a11_ = __dconjg (&a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) + sgn_ * b_[l_ - 1 + ((*ldb_)) * ((l_ - 1))];
        da11_ = _abs ((real_8) (creal (a11_))) + _abs (cimag (a11_));
        if (da11_ <= smin_) {
          a11_ = smin_;
          da11_ = smin_;
          (*info_) = 1;
        }
        db_ = _abs ((real_8) (creal (vec_))) + _abs (cimag (vec_));
        if (da11_ < 1.0 && db_ > 1.0) {
          if (db_ > bignum_ * da11_) {
            scaloc_ = 1.0 / db_;
          }
        }
        x11_ = (vec_ * (complex_16) (scaloc_)) / a11_;
        if (scaloc_ != 1.0) {
          for (j_ = 1; j_ <= (*n_); (j_)++) {
            (void) _zdscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
          }
          (*scale_) = (*scale_) * scaloc_;
        }
        c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] = x11_;
      }
    }
  }
  else if (! (notrna_) && ! (notrnb_)) {
    for (l_ = (*n_); l_ >= 1; (l_)--) {
      for (k_ = 1; k_ <= (*m_); (k_)++) {
        suml_ = _zdotc (($6_ = k_ - 1, &$6_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &c_[0 + ((*ldc_)) * ((l_ - 1))], &_k1);
        sumr_ = _zdotc (($7_ = (*n_) - l_, &$7_), &c_[k_ - 1 + ((*ldc_)) * ((_min (l_ + 1, (*n_)) - 1))], ldc_, &b_[l_ - 1 + 
        ((*ldb_)) * ((_min (l_ + 1, (*n_)) - 1))], ldb_);
        vec_ = c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] - (suml_ + sgn_ * __dconjg (&sumr_));
        scaloc_ = 1.0;
        a11_ = __dconjg (($8_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + sgn_ * b_[l_ - 1 + ((*ldb_)) * ((l_ - 1))], &$8_));
        da11_ = _abs ((real_8) (creal (a11_))) + _abs (cimag (a11_));
        if (da11_ <= smin_) {
          a11_ = smin_;
          da11_ = smin_;
          (*info_) = 1;
        }
        db_ = _abs ((real_8) (creal (vec_))) + _abs (cimag (vec_));
        if (da11_ < 1.0 && db_ > 1.0) {
          if (db_ > bignum_ * da11_) {
            scaloc_ = 1.0 / db_;
          }
        }
        x11_ = (vec_ * (complex_16) (scaloc_)) / a11_;
        if (scaloc_ != 1.0) {
          for (j_ = 1; j_ <= (*n_); (j_)++) {
            (void) _zdscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
          }
          (*scale_) = (*scale_) * scaloc_;
        }
        c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] = x11_;
      }
    }
  }
  else if (notrna_ && ! (notrnb_)) {
    for (l_ = (*n_); l_ >= 1; (l_)--) {
      for (k_ = (*m_); k_ >= 1; (k_)--) {
        suml_ = _zdotu (($9_ = (*m_) - k_, &$9_), &a_[k_ - 1 + ((*lda_)) * ((_min (k_ + 1, (*m_)) - 1))], lda_, &c_[_min (k_ + 
        1, (*m_)) - 1 + ((*ldc_)) * ((l_ - 1))], &_k1);
        sumr_ = _zdotc (($10_ = (*n_) - l_, &$10_), &c_[k_ - 1 + ((*ldc_)) * ((_min (l_ + 1, (*n_)) - 1))], ldc_, &b_[l_ - 1 + 
        ((*ldb_)) * ((_min (l_ + 1, (*n_)) - 1))], ldb_);
        vec_ = c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] - (suml_ + sgn_ * __dconjg (&sumr_));
        scaloc_ = 1.0;
        a11_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + sgn_ * __dconjg (&b_[l_ - 1 + ((*ldb_)) * ((l_ - 1))]);
        da11_ = _abs ((real_8) (creal (a11_))) + _abs (cimag (a11_));
        if (da11_ <= smin_) {
          a11_ = smin_;
          da11_ = smin_;
          (*info_) = 1;
        }
        db_ = _abs ((real_8) (creal (vec_))) + _abs (cimag (vec_));
        if (da11_ < 1.0 && db_ > 1.0) {
          if (db_ > bignum_ * da11_) {
            scaloc_ = 1.0 / db_;
          }
        }
        x11_ = (vec_ * (complex_16) (scaloc_)) / a11_;
        if (scaloc_ != 1.0) {
          for (j_ = 1; j_ <= (*n_); (j_)++) {
            (void) _zdscal (m_, &scaloc_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1);
          }
          (*scale_) = (*scale_) * scaloc_;
        }
        c_[k_ - 1 + ((*ldc_)) * ((l_ - 1))] = x11_;
      }
    }
  }
  _l0:;
  __calls[142].calls++;
  return 0;
}

int_4 _zunm2r (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ a_, int_4 _p_ 
lda_, complex_16 _p_ tau_, complex_16 _p_ c_, int_4 _p_ ldc_, complex_16 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, i3_, ic_, jc_, mi_, ni_, nq_;
  static logical_4 left_, notran_;
  static complex_16 aii_, taui_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  extern complex_16 _dconjg ();
  complex_16 __dconjg (complex_16 _p_ __x__) {return conj (*__x__);}
  (*info_) = 0;
  left_ = _lsame (side_, _dc_20);
  notran_ = _lsame (trans_, _dc_7);
  if (left_) {
    nq_ = (*m_);
  }
  else {
    nq_ = (*n_);
  }
  if (! (left_) && ! (_lsame (side_, _dc_37))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_9))) {
    (*info_) = -2;
  }
  else if ((*m_) < 0) {
    (*info_) = -3;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*k_) < 0 || (*k_) > nq_) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, nq_)) {
    (*info_) = -7;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_97, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0 || (*k_) == 0) {
    goto _l0;
  }
  if ((left_ && ! (notran_) || ! (left_) && notran_)) {
    i1_ = 1;
    i2_ = (*k_);
    i3_ = 1;
  }
  else {
    i1_ = (*k_);
    i2_ = 1;
    i3_ = -1;
  }
  if (left_) {
    ni_ = (*n_);
    jc_ = 1;
  }
  else {
    mi_ = (*m_);
    ic_ = 1;
  }
  for (i_ = i1_; (i3_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += i3_) {
    if (left_) {
      mi_ = (*m_) - i_ + 1;
      ic_ = i_;
    }
    else {
      ni_ = (*n_) - i_ + 1;
      jc_ = i_;
    }
    if (notran_) {
      taui_ = tau_[i_ - 1];
    }
    else {
      taui_ = __dconjg (&tau_[i_ - 1]);
    }
    aii_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = CMPLX (1.0, 0.0);
    (void) _zlarf (side_, &mi_, &ni_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1, &taui_, &c_[ic_ - 1 + ((*ldc_)) * ((jc_ - 
    1))], ldc_, work_);
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
  }
  _l0:;
  __calls[143].calls++;
  return 0;
}

