//! @file mathlib-lapack-svd.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 85 subprograms from LAPACK-SVD

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// DBDSDC DGELSS DGSVJ1 DLALSA DLARF  DLASD2 DLASDQ DLASQ6 DORGBR DORMQR
// DBDSQR DGEQP3 DISNAN DLALSD DLARFB DLASD3 DLASDT DLASR  DORGL2 DPOCON
// DCOMBS DGEQR2 DLABAD DLAMRG DLARFG DLASD4 DLASET DLASRT DORGLQ DRSCL
// DGEBD2 DGEQRF DLABRD DLANGE DLARFT DLASD5 DLASQ1 DLASSQ DORGQR IEEECK
// DGEBRD DGESDD DLACN2 DLANST DLARTG DLASD6 DLASQ2 DLASV2 DORM2R ILADLC
// DGEJSV DGESVD DLACPY DLAPMT DLAS2  DLASD7 DLASQ3 DLASWP DORMBR ILADLR
// DGELQ2 DGESVD DLAED6 DLAPY2 DLASCL DLASD8 DLASQ4 DLATRS DORML2 ILAENV
// DGELQF DGESVJ DLAISN DLAQP2 DLASD0 DLASDA DLASQ5 DORG2R DORMLQ IPARMQ
// DGELSD DGSVJ0 DLALS0 DLAQPS DLASD1

// Selected SVD functionality from LAPACK. 
// 
// The original code is F90 from 2023, but could be made to compile 
// with VIF trivially.
// 
// Included LAPACK routines of interest to VIF are:
// 
//   DGEJSV
//   DGELSD 
//   DGELSS 
//   DGESDD
//   DGESVD
//   DGESVDQ
//   DGESVJ
// 
// Source: netlib.org/lapack
// LAPACK 3.12.0

// The license for LAPACK Fortran source code is:
//
// Copyright (c) 1992-2013 The University of Tennessee and The University
//                         of Tennessee Research Foundation.  All rights
//                         reserved.
// Copyright (c) 2000-2013 The University of California Berkeley. All
//                         rights reserved.
// Copyright (c) 2006-2013 The University of Colorado Denver.  All rights
//                         reserved.
// 
// $COPYRIGHT$
// 
// Additional copyrights may follow
// 
// $HEADER$
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
// 
// - Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer.
// 
// - Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer listed
//   in this license in the documentation and/or other materials
//   provided with the distribution.
// 
// - Neither the name of the copyright holders nor the names of its
//   contributors may be used to endorse or promote products derived from
//   this software without specific prior written permission.
// 
// The copyright holders provide no reassurances that the source code
// provided does not infringe any patent, copyright, or any other
// intellectual property rights of third parties.  The copyright holders
// disclaim any liability to any recipient for claims brought against
// recipient by any third party for infringement of that parties
// intellectual property rights.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// `

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "u"
#define _dc_1 "l"
#define _dc_2 "n"
#define _dc_3 "p"
#define _dc_4 "i"
#define _dc_5 "dbdsdc"
#define _dc_6 " "
#define _dc_7 "a"
#define _dc_8 "m"
#define _dc_9 "g"
#define _dc_10 "epsilon"
#define _dc_11 "v"
#define _dc_12 "b"
#define _dc_13 "dbdsqr"
#define _dc_14 "safe minimum"
#define _dc_15 "r"
#define _dc_16 "f"
#define _dc_17 "dgebd2"
#define _dc_18 "left"
#define _dc_19 "right"
#define _dc_20 "dgebrd"
#define _dc_21 "no transpose"
#define _dc_22 "transpose"
#define _dc_23 "j"
#define _dc_24 "e"
#define _dc_25 "t"
#define _dc_26 "c"
#define _dc_27 "w"
#define _dc_28 "dgejsv"
#define _dc_29 "safeminimum"
#define _dc_30 "o"
#define _dc_31 "nou"
#define _dc_32 "nov"
#define _dc_33 "upper"
#define _dc_34 "lower"
#define _dc_35 "all"
#define _dc_36 "no tr"
#define _dc_37 "no_tr"
#define _dc_38 "notrans"
#define _dc_39 "no ud"
#define _dc_40 "dgelq2"
#define _dc_41 "dgelqf"
#define _dc_42 "forward"
#define _dc_43 "rowwise"
#define _dc_44 "dgelsd"
#define _dc_45 "dgeqrf"
#define _dc_46 "dormqr"
#define _dc_47 "lt"
#define _dc_48 "dormbr"
#define _dc_49 "qlt"
#define _dc_50 "pln"
#define _dc_51 "dormlq"
#define _dc_52 "s"
#define _dc_53 "q"
#define _dc_54 "dgelss"
#define _dc_55 "dgeqp3"
#define _dc_56 "dgeqr2"
#define _dc_57 "columnwise"
#define _dc_58 "dgesdd"
#define _dc_59 "dgesvd"
#define _dc_60 "h"
#define _dc_61 "dgesvdq"
#define _dc_62 "dgesvj"
#define _dc_63 "overflow"
#define _dc_64 "dgsvj0"
#define _dc_65 "dgsvj1"
#define _dc_66 "base"
#define _dc_67 "safmin"
#define _dc_68 "dlals0"
#define _dc_69 "dlalsa"
#define _dc_70 "dlalsd"
#define _dc_71 "d"
#define _dc_72 "1"
#define _dc_73 "unit"
#define _dc_74 "non-unit"
#define _dc_75 "z"
#define _dc_76 "dlascl"
#define _dc_77 "dlasd0"
#define _dc_78 "dlasd1"
#define _dc_79 "dlasd2"
#define _dc_80 "dlasd3"
#define _dc_81 "dlasd6"
#define _dc_82 "dlasd7"
#define _dc_83 "dlasd8"
#define _dc_84 "dlasda"
#define _dc_85 "dlasdq"
#define _dc_86 "dlasq1"
#define _dc_87 "precision"
#define _dc_88 "dlasq2"
#define _dc_89 "dlasr "
#define _dc_90 "dlasrt"
#define _dc_91 "eps"
#define _dc_92 "y"
#define _dc_93 "dlatrs"
#define _dc_94 "dorg2r"
#define _dc_95 "dorgbr"
#define _dc_96 "dorgl2"
#define _dc_97 "dorglq"
#define _dc_98 "dorgqr"
#define _dc_99 "dorm2r"
#define _dc_100 "dorml2"
#define _dc_101 "dpocon"
#define _dc_102 "2"
#define _dc_103 "laorh"
#define _dc_104 "ge"
#define _dc_105 "trf"
#define _dc_106 "qrf"
#define _dc_107 "rqf"
#define _dc_108 "lqf"
#define _dc_109 "qlf"
#define _dc_110 "qr "
#define _dc_111 "lq "
#define _dc_112 "hrd"
#define _dc_113 "brd"
#define _dc_114 "tri"
#define _dc_115 "po"
#define _dc_116 "sy"
#define _dc_117 "trd"
#define _dc_118 "gst"
#define _dc_119 "he"
#define _dc_120 "or"
#define _dc_121 "qr"
#define _dc_122 "rq"
#define _dc_123 "lq"
#define _dc_124 "ql"
#define _dc_125 "hr"
#define _dc_126 "tr"
#define _dc_127 "br"
#define _dc_128 "un"
#define _dc_129 "gb"
#define _dc_130 "pb"
#define _dc_131 "evc"
#define _dc_132 "la"
#define _dc_133 "uum"
#define _dc_134 "st"
#define _dc_135 "ebz"
#define _dc_136 "gg"
#define _dc_137 "hd3"
#define _dc_138 "gghrd"
#define _dc_139 "gghd3"
#define _dc_140 "exc"
#define _dc_141 "hseqr"
#define _dc_142 "laqr"
static FORMAT *__fmt_a = NULL;
typedef char char_1[2];
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
#define __ncalls 86
static CALLS __calls[__ncalls] = {
  {"dbdsdc", 0}, // subroutine
  {"dbdsqr", 0}, // subroutine
  {"dcombssq", 0}, // subroutine
  {"dgebd2", 0}, // subroutine
  {"dgebrd", 0}, // subroutine
  {"dgejsv", 0}, // subroutine
  {"dgelq2", 0}, // subroutine
  {"dgelqf", 0}, // subroutine
  {"dgelsd", 0}, // subroutine
  {"dgelss", 0}, // subroutine
  {"dgeqp3", 0}, // subroutine
  {"dgeqr2", 0}, // subroutine
  {"dgeqrf", 0}, // subroutine
  {"dgesdd", 0}, // subroutine
  {"dgesvd", 0}, // subroutine
  {"dgesvdq", 0}, // subroutine
  {"dgesvj", 0}, // subroutine
  {"dgsvj0", 0}, // subroutine
  {"dgsvj1", 0}, // subroutine
  {"disnan", 0}, // logical*4 function
  {"dlabad", 0}, // subroutine
  {"dlabrd", 0}, // subroutine
  {"dlacn2", 0}, // subroutine
  {"dlacpy", 0}, // subroutine
  {"dlaed6", 0}, // subroutine
  {"dlaisnan", 0}, // logical*4 function
  {"dlals0", 0}, // subroutine
  {"dlalsa", 0}, // subroutine
  {"dlalsd", 0}, // subroutine
  {"dlamrg", 0}, // subroutine
  {"dlange", 0}, // real*8 function
  {"dlanst", 0}, // real*8 function
  {"dlapmt", 0}, // subroutine
  {"dlapy2", 0}, // real*8 function
  {"dlaqp2", 0}, // subroutine
  {"dlaqps", 0}, // subroutine
  {"dlarfb", 0}, // subroutine
  {"dlarf", 0}, // subroutine
  {"dlarfg", 0}, // subroutine
  {"dlarft", 0}, // subroutine
  {"dlartg", 0}, // subroutine
  {"dlas2", 0}, // subroutine
  {"dlascl", 0}, // subroutine
  {"dlasd0", 0}, // subroutine
  {"dlasd1", 0}, // subroutine
  {"dlasd2", 0}, // subroutine
  {"dlasd3", 0}, // subroutine
  {"dlasd4", 0}, // subroutine
  {"dlasd5", 0}, // subroutine
  {"dlasd6", 0}, // subroutine
  {"dlasd7", 0}, // subroutine
  {"dlasd8", 0}, // subroutine
  {"dlasda", 0}, // subroutine
  {"dlasdq", 0}, // subroutine
  {"dlasdt", 0}, // subroutine
  {"dlaset", 0}, // subroutine
  {"dlasq1", 0}, // subroutine
  {"dlasq2", 0}, // subroutine
  {"dlasq3", 0}, // subroutine
  {"dlasq4", 0}, // subroutine
  {"dlasq5", 0}, // subroutine
  {"dlasq6", 0}, // subroutine
  {"dlasr", 0}, // subroutine
  {"dlasrt", 0}, // subroutine
  {"dlassq", 0}, // subroutine
  {"dlasv2", 0}, // subroutine
  {"dlaswp", 0}, // subroutine
  {"dlatrs", 0}, // subroutine
  {"dorg2r", 0}, // subroutine
  {"dorgbr", 0}, // subroutine
  {"dorgl2", 0}, // subroutine
  {"dorglq", 0}, // subroutine
  {"dorgqr", 0}, // subroutine
  {"dorm2r", 0}, // subroutine
  {"dormbr", 0}, // subroutine
  {"dorml2", 0}, // subroutine
  {"dormlq", 0}, // subroutine
  {"dormqr", 0}, // subroutine
  {"dpocon", 0}, // subroutine
  {"drscl", 0}, // subroutine
  {"ieeeck", 0}, // integer*4 function
  {"iladlc", 0}, // integer*4 function
  {"iladlr", 0}, // integer*4 function
  {"ilaenv", 0}, // integer*4 function
  {"iparmq", 0}, // integer*4 function
  {NULL, 0}
};

prototype int_4 _dbdsdc (char _p_ uplo_, char _p_ compq_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ u_, 
int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ q_, int_4 _p_ iq_, real_8 _p_ work_, int_4 _p_ iwork_, 
int_4 _p_ info_);
prototype int_4 _dbdsqr (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ ncvt_, int_4 _p_ nru_, int_4 _p_ ncc_, real_8 _p_ d_, 
real_8 _p_ e_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 
_p_ work_, int_4 _p_ info_);
prototype int_4 _dcombssq (real_8 _p_ v1_, real_8 _p_ v2_);
prototype int_4 _dgebd2 (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, real_8 _p_ e_, 
real_8 _p_ tauq_, real_8 _p_ taup_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dgebrd (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, real_8 _p_ e_, 
real_8 _p_ tauq_, real_8 _p_ taup_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dgejsv (char _p_ joba_, char _p_ jobu_, char _p_ jobv_, char _p_ jobr_, char _p_ jobt_, char _p_ jobp_
, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ sva_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ 
v_, int_4 _p_ ldv_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ info_);
prototype int_4 _dgelq2 (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ work_, 
int_4 _p_ info_);
prototype int_4 _dgelqf (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ work_, 
int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dgelsd (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, 
int_4 _p_ ldb_, real_8 _p_ s_, real_8 _p_ rcond_, int_4 _p_ rank_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_
, int_4 _p_ info_);
prototype int_4 _dgelss (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, 
int_4 _p_ ldb_, real_8 _p_ s_, real_8 _p_ rcond_, int_4 _p_ rank_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
;
prototype int_4 _dgeqp3 (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ jpvt_, real_8 _p_ tau_, 
real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dgeqr2 (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ work_, 
int_4 _p_ info_);
prototype int_4 _dgeqrf (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ work_, 
int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dgesdd (char _p_ jobz_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ s_, 
real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, 
int_4 _p_ info_);
prototype int_4 _dgesvd (char _p_ jobu_, char _p_ jobvt_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, 
real_8 _p_ s_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ work_, int_4 _p_ lwork_, 
int_4 _p_ info_);
prototype int_4 _dgesvdq (char _p_ joba_, char _p_ jobp_, char _p_ jobr_, char _p_ jobu_, char _p_ jobv_, int_4 _p_ m_, 
int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ s_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ v_, int_4 _p_ 
ldv_, int_4 _p_ numrank_, int_4 _p_ iwork_, int_4 _p_ liwork_, real_8 _p_ work_, int_4 _p_ lwork_, real_8 _p_ rwork_, 
int_4 _p_ lrwork_, int_4 _p_ info_);
prototype int_4 _dgesvj (char _p_ joba_, char _p_ jobu_, char _p_ jobv_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ sva_, int_4 _p_ mv_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ work_, int_4 _p_ lwork_, 
int_4 _p_ info_);
prototype int_4 _dgsvj0 (char _p_ jobv_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, 
real_8 _p_ sva_, int_4 _p_ mv_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ eps_, real_8 _p_ sfmin_, real_8 _p_ tol_, 
int_4 _p_ nsweep_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dgsvj1 (char _p_ jobv_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ n1_, real_8 _p_ a_, int_4 _p_ lda_, 
real_8 _p_ d_, real_8 _p_ sva_, int_4 _p_ mv_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ eps_, real_8 _p_ sfmin_, 
real_8 _p_ tol_, int_4 _p_ nsweep_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype logical_4 _disnan (real_8 _p_ din_);
prototype int_4 _dlabad (real_8 _p_ small_, real_8 _p_ large_);
prototype int_4 _dlabrd (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ nb_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, 
real_8 _p_ e_, real_8 _p_ tauq_, real_8 _p_ taup_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ y_, int_4 _p_ ldy_);
prototype int_4 _dlacn2 (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ x_, int_4 _p_ isgn_, real_8 _p_ est_, int_4 _p_ kase_, 
int_4 _p_ isave_);
prototype int_4 _dlacpy (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, 
int_4 _p_ ldb_);
prototype int_4 _dlaed6 (int_4 _p_ kniter_, logical_4 _p_ orgati_, real_8 _p_ rho_, real_8 _p_ d_, real_8 _p_ z_, 
real_8 _p_ finit_, real_8 _p_ tau_, int_4 _p_ info_);
prototype logical_4 _dlaisnan (real_8 _p_ din1_, real_8 _p_ din2_);
prototype int_4 _dlals0 (int_4 _p_ icompq_, int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, int_4 _p_ nrhs_, real_8 _p_ 
b_, int_4 _p_ ldb_, real_8 _p_ bx_, int_4 _p_ ldbx_, int_4 _p_ perm_, int_4 _p_ givptr_, int_4 _p_ givcol_, int_4 _p_ 
ldgcol_, real_8 _p_ givnum_, int_4 _p_ ldgnum_, real_8 _p_ poles_, real_8 _p_ difl_, real_8 _p_ difr_, real_8 _p_ z_, 
int_4 _p_ k_, real_8 _p_ c_, real_8 _p_ s_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dlalsa (int_4 _p_ icompq_, int_4 _p_ smlsiz_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ b_, int_4 _p_ 
ldb_, real_8 _p_ bx_, int_4 _p_ ldbx_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ k_, real_8 _p_ difl_, 
real_8 _p_ difr_, real_8 _p_ z_, real_8 _p_ poles_, int_4 _p_ givptr_, int_4 _p_ givcol_, int_4 _p_ ldgcol_, int_4 _p_ 
perm_, real_8 _p_ givnum_, real_8 _p_ c_, real_8 _p_ s_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_);
prototype int_4 _dlalsd (char _p_ uplo_, int_4 _p_ smlsiz_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ d_, real_8 _p_ e_
, real_8 _p_ b_, int_4 _p_ ldb_, real_8 _p_ rcond_, int_4 _p_ rank_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ 
info_);
prototype int_4 _dlamrg (int_4 _p_ n1_, int_4 _p_ n2_, real_8 _p_ a_, int_4 _p_ dtrd1_, int_4 _p_ dtrd2_, int_4 _p_ 
index_);
prototype real_8 _dlange (char _p_ norm_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ work_);
prototype real_8 _dlanst (char _p_ norm_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_);
prototype int_4 _dlapmt (logical_4 _p_ forwrd_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ k_
);
prototype real_8 _dlapy2 (real_8 _p_ x_, real_8 _p_ y_);
prototype int_4 _dlaqp2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ offset_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ jpvt_, 
real_8 _p_ tau_, real_8 _p_ vn1_, real_8 _p_ vn2_, real_8 _p_ work_);
prototype int_4 _dlaqps (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ offset_, int_4 _p_ nb_, int_4 _p_ kb_, real_8 _p_ a_, 
int_4 _p_ lda_, int_4 _p_ jpvt_, real_8 _p_ tau_, real_8 _p_ vn1_, real_8 _p_ vn2_, real_8 _p_ auxv_, real_8 _p_ f_, 
int_4 _p_ ldf_);
prototype int_4 _dlarfb (char _p_ side_, char _p_ trans_, char _p_ direct_, char _p_ storev_, int_4 _p_ m_, int_4 _p_ 
n_, int_4 _p_ k_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 
_p_ work_, int_4 _p_ ldwork_);
prototype int_4 _dlarf (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ v_, int_4 _p_ incv_, real_8 _p_ tau_, 
real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_);
prototype int_4 _dlarfg (int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ tau_);
prototype int_4 _dlarft (char _p_ direct_, char _p_ storev_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ v_, int_4 _p_ ldv_, 
real_8 _p_ tau_, real_8 _p_ t_, int_4 _p_ ldt_);
prototype int_4 _dlartg (real_8 _p_ f_, real_8 _p_ g_, real_8 _p_ cs_, real_8 _p_ sn_, real_8 _p_ r_);
prototype int_4 _dlas2 (real_8 _p_ f_, real_8 _p_ g_, real_8 _p_ h_, real_8 _p_ ssmin_, real_8 _p_ ssmax_);
prototype int_4 _dlascl (char _p_ type_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ cfrom_, real_8 _p_ cto_, int_4 _p_ m_
, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ info_);
prototype int_4 _dlasd0 (int_4 _p_ n_, int_4 _p_ sqre_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ u_, int_4 _p_ ldu_, 
real_8 _p_ vt_, int_4 _p_ ldvt_, int_4 _p_ smlsiz_, int_4 _p_ iwork_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dlasd1 (int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, real_8 _p_ d_, real_8 _p_ alpha_, real_8 _p_ 
beta_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, int_4 _p_ idxq_, int_4 _p_ iwork_, real_8 _p_ 
work_, int_4 _p_ info_);
prototype int_4 _dlasd2 (int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, int_4 _p_ k_, real_8 _p_ d_, real_8 _p_ z_, 
real_8 _p_ alpha_, real_8 _p_ beta_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ dsigma_
, real_8 _p_ u2_, int_4 _p_ ldu2_, real_8 _p_ vt2_, int_4 _p_ ldvt2_, int_4 _p_ idxp_, int_4 _p_ idx_, int_4 _p_ idxc_, 
int_4 _p_ idxq_, int_4 _p_ coltyp_, int_4 _p_ info_);
prototype int_4 _dlasd3 (int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, int_4 _p_ k_, real_8 _p_ d_, real_8 _p_ q_, 
int_4 _p_ ldq_, real_8 _p_ dsigma_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ u2_, int_4 _p_ ldu2_, real_8 _p_ vt_, 
int_4 _p_ ldvt_, real_8 _p_ vt2_, int_4 _p_ ldvt2_, int_4 _p_ idxc_, int_4 _p_ ctot_, real_8 _p_ z_, int_4 _p_ info_);
prototype int_4 _dlasd4 (int_4 _p_ n_, int_4 _p_ i_, real_8 _p_ d_, real_8 _p_ z_, real_8 _p_ delta_, real_8 _p_ rho_, 
real_8 _p_ sigma_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dlasd5 (int_4 _p_ i_, real_8 _p_ d_, real_8 _p_ z_, real_8 _p_ delta_, real_8 _p_ rho_, real_8 _p_ 
dsigma_, real_8 _p_ work_);
prototype int_4 _dlasd6 (int_4 _p_ icompq_, int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, real_8 _p_ d_, real_8 _p_ 
vf_, real_8 _p_ vl_, real_8 _p_ alpha_, real_8 _p_ beta_, int_4 _p_ idxq_, int_4 _p_ perm_, int_4 _p_ givptr_, int_4 
_p_ givcol_, int_4 _p_ ldgcol_, real_8 _p_ givnum_, int_4 _p_ ldgnum_, real_8 _p_ poles_, real_8 _p_ difl_, real_8 _p_ 
difr_, real_8 _p_ z_, int_4 _p_ k_, real_8 _p_ c_, real_8 _p_ s_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_);
prototype int_4 _dlasd7 (int_4 _p_ icompq_, int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, int_4 _p_ k_, real_8 _p_ d_, 
real_8 _p_ z_, real_8 _p_ zw_, real_8 _p_ vf_, real_8 _p_ vfw_, real_8 _p_ vl_, real_8 _p_ vlw_, real_8 _p_ alpha_, 
real_8 _p_ beta_, real_8 _p_ dsigma_, int_4 _p_ idx_, int_4 _p_ idxp_, int_4 _p_ idxq_, int_4 _p_ perm_, int_4 _p_ 
givptr_, int_4 _p_ givcol_, int_4 _p_ ldgcol_, real_8 _p_ givnum_, int_4 _p_ ldgnum_, real_8 _p_ c_, real_8 _p_ s_, 
int_4 _p_ info_);
prototype int_4 _dlasd8 (int_4 _p_ icompq_, int_4 _p_ k_, real_8 _p_ d_, real_8 _p_ z_, real_8 _p_ vf_, real_8 _p_ vl_, 
real_8 _p_ difl_, real_8 _p_ difr_, int_4 _p_ lddifr_, real_8 _p_ dsigma_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dlasda (int_4 _p_ icompq_, int_4 _p_ smlsiz_, int_4 _p_ n_, int_4 _p_ sqre_, real_8 _p_ d_, real_8 _p_ 
e_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ k_, real_8 _p_ difl_, real_8 _p_ difr_, real_8 _p_ z_, 
real_8 _p_ poles_, int_4 _p_ givptr_, int_4 _p_ givcol_, int_4 _p_ ldgcol_, int_4 _p_ perm_, real_8 _p_ givnum_, real_8 
_p_ c_, real_8 _p_ s_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_);
prototype int_4 _dlasdq (char _p_ uplo_, int_4 _p_ sqre_, int_4 _p_ n_, int_4 _p_ ncvt_, int_4 _p_ nru_, int_4 _p_ ncc_
, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ c_, int_4 
_p_ ldc_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dlasdt (int_4 _p_ n_, int_4 _p_ lvl_, int_4 _p_ nd_, int_4 _p_ inode_, int_4 _p_ ndiml_, int_4 _p_ 
ndimr_, int_4 _p_ msub_);
prototype int_4 _dlaset (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ beta_, real_8 _p_ a_
, int_4 _p_ lda_);
prototype int_4 _dlasq1 (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dlasq2 (int_4 _p_ n_, real_8 _p_ z_, int_4 _p_ info_);
prototype int_4 _dlasq3 (int_4 _p_ i0_, int_4 _p_ n0_, real_8 _p_ z_, int_4 _p_ pp_, real_8 _p_ dmin_, real_8 _p_ 
sigma_, real_8 _p_ desig_, real_8 _p_ qmax_, int_4 _p_ nfail_, int_4 _p_ iter_, int_4 _p_ ndiv_, logical_4 _p_ ieee_, 
int_4 _p_ ttype_, real_8 _p_ dmin1_, real_8 _p_ dmin2_, real_8 _p_ dn_, real_8 _p_ dn1_, real_8 _p_ dn2_, real_8 _p_ g_
, real_8 _p_ tau_);
prototype int_4 _dlasq4 (int_4 _p_ i0_, int_4 _p_ n0_, real_8 _p_ z_, int_4 _p_ pp_, int_4 _p_ n0in_, real_8 _p_ dmin_, 
real_8 _p_ dmin1_, real_8 _p_ dmin2_, real_8 _p_ dn_, real_8 _p_ dn1_, real_8 _p_ dn2_, real_8 _p_ tau_, int_4 _p_ 
ttype_, real_8 _p_ g_);
prototype int_4 _dlasq5 (int_4 _p_ i0_, int_4 _p_ n0_, real_8 _p_ z_, int_4 _p_ pp_, real_8 _p_ tau_, real_8 _p_ sigma_
, real_8 _p_ dmin_, real_8 _p_ dmin1_, real_8 _p_ dmin2_, real_8 _p_ dn_, real_8 _p_ dnm1_, real_8 _p_ dnm2_, logical_4 
_p_ ieee_, real_8 _p_ eps_);
prototype int_4 _dlasq6 (int_4 _p_ i0_, int_4 _p_ n0_, real_8 _p_ z_, int_4 _p_ pp_, real_8 _p_ dmin_, real_8 _p_ 
dmin1_, real_8 _p_ dmin2_, real_8 _p_ dn_, real_8 _p_ dnm1_, real_8 _p_ dnm2_);
prototype int_4 _dlasr (char _p_ side_, char _p_ pivot_, char _p_ direct_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ c_, 
real_8 _p_ s_, real_8 _p_ a_, int_4 _p_ lda_);
prototype int_4 _dlasrt (char _p_ id_, int_4 _p_ n_, real_8 _p_ d_, int_4 _p_ info_);
prototype int_4 _dlassq (int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ scale_, real_8 _p_ sumsq_);
prototype int_4 _dlasv2 (real_8 _p_ f_, real_8 _p_ g_, real_8 _p_ h_, real_8 _p_ ssmin_, real_8 _p_ ssmax_, real_8 _p_ 
snr_, real_8 _p_ csr_, real_8 _p_ snl_, real_8 _p_ csl_);
prototype int_4 _dlaswp (int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ k1_, int_4 _p_ k2_, int_4 _p_ ipiv_, 
int_4 _p_ incx_);
prototype int_4 _dlatrs (char _p_ uplo_, char _p_ trans_, char _p_ diag_, char _p_ normin_, int_4 _p_ n_, real_8 _p_ a_
, int_4 _p_ lda_, real_8 _p_ x_, real_8 _p_ scale_, real_8 _p_ cnorm_, int_4 _p_ info_);
prototype int_4 _dorg2r (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, 
real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dorgbr (char _p_ vect_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, 
real_8 _p_ tau_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dorgl2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, 
real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dorglq (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, 
real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dorgqr (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, 
real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dorm2r (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dormbr (char _p_ vect_, char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, 
real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ lwork_, 
int_4 _p_ info_);
prototype int_4 _dorml2 (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ info_);
prototype int_4 _dormlq (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dormqr (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, 
int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_);
prototype int_4 _dpocon (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ anorm_, real_8 _p_ 
rcond_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_);
prototype int_4 _drscl (int_4 _p_ n_, real_8 _p_ sa_, real_8 _p_ sx_, int_4 _p_ incx_);
prototype int_4 _ieeeck (int_4 _p_ ispec_, real_4 _p_ zero_, real_4 _p_ one_);
prototype int_4 _iladlc (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_);
prototype int_4 _iladlr (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_);
prototype int_4 _ilaenv (int_4 _p_ ispec_, char _p_ name_, char _p_ opts_, int_4 _p_ n1_, int_4 _p_ n2_, int_4 _p_ n3_, 
int_4 _p_ n4_);
prototype int_4 _iparmq (int_4 _p_ ispec_, char _p_ name_, char _p_ opts_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_
, int_4 _p_ lwork_);
int_4 _dbdsdc (char _p_ uplo_, char _p_ compq_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ u_, int_4 _p_ 
ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ q_, int_4 _p_ iq_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ 
info_)
{
  static int_4 difl_, difr_, givcol_, givnum_, givptr_, i_, ic_, icompq_, ierr_, ii_, is_, iu_, iuplo_, ivt_, j_, k_, kk_
  , mlvl_, nm1_, nsize_, perm_, poles_, qstart_, smlsiz_, smlszp_, sqre_, start_, wstart_, z_;
  static real_8 cs_, eps_, orgnrm_, p_, r_, sn_;
  int_4 $0_, $1_, $2_;
  real_8 $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_;
  extern logical_4 _lsame ();
  extern real_8 _dlamch ();
  extern int_4 _dcopy ();
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  iuplo_ = 0;
  if (_lsame (uplo_, _dc_0)) {
    iuplo_ = 1;
  }
  if (_lsame (uplo_, _dc_1)) {
    iuplo_ = 2;
  }
  if (_lsame (compq_, _dc_2)) {
    icompq_ = 0;
  }
  else if (_lsame (compq_, _dc_3)) {
    icompq_ = 1;
  }
  else if (_lsame (compq_, _dc_4)) {
    icompq_ = 2;
  }
  else {
    icompq_ = -1;
  }
  if (iuplo_ == 0) {
    (*info_) = -1;
  }
  else if (icompq_ < 0) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -3;
  }
  else if (((*ldu_) < 1) || ((icompq_ == 2) && ((*ldu_) < (*n_)))) {
    (*info_) = -7;
  }
  else if (((*ldvt_) < 1) || ((icompq_ == 2) && ((*ldvt_) < (*n_)))) {
    (*info_) = -9;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_5, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  smlsiz_ = _ilaenv (($1_ = 9, &$1_), _dc_5, _dc_6, &_k0, &_k0, &_k0, &_k0);
  if ((*n_) == 1) {
    if (icompq_ == 1) {
      q_[0] = _sign (1.0, d_[0]);
      q_[1 + smlsiz_ * (*n_) - 1] = 1.0;
    }
    else if (icompq_ == 2) {
      u_[0 + ((*ldu_)) * ((0))] = _sign (1.0, d_[0]);
      vt_[0 + ((*ldvt_)) * ((0))] = 1.0;
    }
    d_[0] = _abs (d_[0]);
    goto _l0;
  }
  nm1_ = (*n_) - 1;
  wstart_ = 1;
  qstart_ = 3;
  if (icompq_ == 1) {
    (void) _dcopy (n_, d_, &_k1, &q_[0], &_k1);
    (void) _dcopy (($2_ = (*n_) - 1, &$2_), e_, &_k1, &q_[(*n_) + 1 - 1], &_k1);
  }
  if (iuplo_ == 2) {
    qstart_ = 5;
    if (icompq_ == 2) {
      wstart_ = 2 * (*n_) - 1;
    }
    for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
      (void) _dlartg (&d_[i_ - 1], &e_[i_ - 1], &cs_, &sn_, &r_);
      d_[i_ - 1] = r_;
      e_[i_ - 1] = sn_ * d_[i_ + 1 - 1];
      d_[i_ + 1 - 1] = cs_ * d_[i_ + 1 - 1];
      if (icompq_ == 1) {
        q_[i_ + 2 * (*n_) - 1] = cs_;
        q_[i_ + 3 * (*n_) - 1] = sn_;
      }
      else if (icompq_ == 2) {
        work_[i_ - 1] = cs_;
        work_[nm1_ + i_ - 1] = -sn_;
      }
    }
  }
  if (icompq_ == 0) {
    (void) _dlasdq (_dc_0, &_k0, n_, &_k0, &_k0, &_k0, d_, e_, vt_, ldvt_, u_, ldu_, u_, ldu_, &work_[0], info_);
    goto _l40;
  }
  if ((*n_) <= smlsiz_) {
    if (icompq_ == 2) {
      (void) _dlaset (_dc_7, n_, n_, ($3_ = 0.0, &$3_), ($4_ = 1.0, &$4_), u_, ldu_);
      (void) _dlaset (_dc_7, n_, n_, ($5_ = 0.0, &$5_), ($6_ = 1.0, &$6_), vt_, ldvt_);
      (void) _dlasdq (_dc_0, &_k0, n_, n_, n_, &_k0, d_, e_, vt_, ldvt_, u_, ldu_, u_, ldu_, &work_[wstart_ - 1], info_);
    }
    else if (icompq_ == 1) {
      iu_ = 1;
      ivt_ = iu_ + (*n_);
      (void) _dlaset (_dc_7, n_, n_, ($7_ = 0.0, &$7_), ($8_ = 1.0, &$8_), &q_[iu_ + (qstart_ - 1) * (*n_) - 1], n_);
      (void) _dlaset (_dc_7, n_, n_, ($9_ = 0.0, &$9_), ($10_ = 1.0, &$10_), &q_[ivt_ + (qstart_ - 1) * (*n_) - 1], n_);
      (void) _dlasdq (_dc_0, &_k0, n_, n_, n_, &_k0, d_, e_, &q_[ivt_ + (qstart_ - 1) * (*n_) - 1], n_, &q_[iu_ + (qstart_ - 
      1) * (*n_) - 1], n_, &q_[iu_ + (qstart_ - 1) * (*n_) - 1], n_, &work_[wstart_ - 1], info_);
    }
    goto _l40;
  }
  if (icompq_ == 2) {
    (void) _dlaset (_dc_7, n_, n_, ($11_ = 0.0, &$11_), ($12_ = 1.0, &$12_), u_, ldu_);
    (void) _dlaset (_dc_7, n_, n_, ($13_ = 0.0, &$13_), ($14_ = 1.0, &$14_), vt_, ldvt_);
  }
  orgnrm_ = _dlanst (_dc_8, n_, d_, e_);
  if (orgnrm_ == 0.0) {
    goto _l0;
  }
  (void) _dlascl (_dc_9, &_k0, &_k0, &orgnrm_, ($15_ = 1.0, &$15_), n_, &_k1, d_, n_, &ierr_);
  (void) _dlascl (_dc_9, &_k0, &_k0, &orgnrm_, ($16_ = 1.0, &$16_), &nm1_, &_k1, e_, &nm1_, &ierr_);
  eps_ = 0.9 * _dlamch (_dc_10);
  mlvl_ = (int_4) (_aintd (log ((real_8) ((*n_)) / (real_8) (smlsiz_ + 1)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 1;
  smlszp_ = smlsiz_ + 1;
  if (icompq_ == 1) {
    iu_ = 1;
    ivt_ = 1 + smlsiz_;
    difl_ = ivt_ + smlszp_;
    difr_ = difl_ + mlvl_;
    z_ = difr_ + mlvl_ * 2;
    ic_ = z_ + mlvl_;
    is_ = ic_ + 1;
    poles_ = is_ + 1;
    givnum_ = poles_ + 2 * mlvl_;
    k_ = 1;
    givptr_ = 2;
    perm_ = 3;
    givcol_ = perm_ + mlvl_;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_abs (d_[i_ - 1]) < eps_) {
      d_[i_ - 1] = _sign (eps_, d_[i_ - 1]);
    }
  }
  start_ = 1;
  sqre_ = 0;
  for (i_ = 1; i_ <= nm1_; (i_)++) {
    if ((_abs (e_[i_ - 1]) < eps_) || (i_ == nm1_)) {
      if (i_ < nm1_) {
        nsize_ = i_ - start_ + 1;
      }
      else if (_abs (e_[i_ - 1]) >= eps_) {
        nsize_ = (*n_) - start_ + 1;
      }
      else {
        nsize_ = i_ - start_ + 1;
        if (icompq_ == 2) {
          u_[(*n_) - 1 + ((*ldu_)) * (((*n_) - 1))] = _sign (1.0, d_[(*n_) - 1]);
          vt_[(*n_) - 1 + ((*ldvt_)) * (((*n_) - 1))] = 1.0;
        }
        else if (icompq_ == 1) {
          q_[(*n_) + (qstart_ - 1) * (*n_) - 1] = _sign (1.0, d_[(*n_) - 1]);
          q_[(*n_) + (smlsiz_ + qstart_ - 1) * (*n_) - 1] = 1.0;
        }
        d_[(*n_) - 1] = _abs (d_[(*n_) - 1]);
      }
      if (icompq_ == 2) {
        (void) _dlasd0 (&nsize_, &sqre_, &d_[start_ - 1], &e_[start_ - 1], &u_[start_ - 1 + ((*ldu_)) * ((start_ - 1))], ldu_, 
        &vt_[start_ - 1 + ((*ldvt_)) * ((start_ - 1))], ldvt_, &smlsiz_, iwork_, &work_[wstart_ - 1], info_);
      }
      else {
        (void) _dlasda (&icompq_, &smlsiz_, &nsize_, &sqre_, &d_[start_ - 1], &e_[start_ - 1], &q_[start_ + (iu_ + qstart_ - 2) 
        * (*n_) - 1], n_, &q_[start_ + (ivt_ + qstart_ - 2) * (*n_) - 1], &iq_[start_ + k_ * (*n_) - 1], &q_[start_ + (difl_ + 
        qstart_ - 2) * (*n_) - 1], &q_[start_ + (difr_ + qstart_ - 2) * (*n_) - 1], &q_[start_ + (z_ + qstart_ - 2) * (*n_) - 
        1], &q_[start_ + (poles_ + qstart_ - 2) * (*n_) - 1], &iq_[start_ + givptr_ * (*n_) - 1], &iq_[start_ + givcol_ * (*n_) 
        - 1], n_, &iq_[start_ + perm_ * (*n_) - 1], &q_[start_ + (givnum_ + qstart_ - 2) * (*n_) - 1], &q_[start_ + (ic_ + 
        qstart_ - 2) * (*n_) - 1], &q_[start_ + (is_ + qstart_ - 2) * (*n_) - 1], &work_[wstart_ - 1], iwork_, info_);
      }
      if ((*info_) != 0) {
        goto _l0;
      }
      start_ = i_ + 1;
    }
  }
  (void) _dlascl (_dc_9, &_k0, &_k0, ($17_ = 1.0, &$17_), &orgnrm_, n_, &_k1, d_, n_, &ierr_);
  _l40:;
  for (ii_ = 2; ii_ <= (*n_); (ii_)++) {
    i_ = ii_ - 1;
    kk_ = i_;
    p_ = d_[i_ - 1];
    for (j_ = ii_; j_ <= (*n_); (j_)++) {
      if (d_[j_ - 1] > p_) {
        kk_ = j_;
        p_ = d_[j_ - 1];
      }
    }
    if (kk_ != i_) {
      d_[kk_ - 1] = d_[i_ - 1];
      d_[i_ - 1] = p_;
      if (icompq_ == 1) {
        iq_[i_ - 1] = kk_;
      }
      else if (icompq_ == 2) {
        (void) _dswap (n_, &u_[0 + ((*ldu_)) * ((i_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((kk_ - 1))], &_k1);
        (void) _dswap (n_, &vt_[i_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &vt_[kk_ - 1 + ((*ldvt_)) * ((0))], ldvt_);
      }
    }
    else if (icompq_ == 1) {
      iq_[i_ - 1] = i_;
    }
  }
  if (icompq_ == 1) {
    if (iuplo_ == 1) {
      iq_[(*n_) - 1] = 1;
    }
    else {
      iq_[(*n_) - 1] = 0;
    }
  }
  if ((iuplo_ == 2) && (icompq_ == 2)) {
    (void) _dlasr (_dc_1, _dc_11, _dc_12, n_, n_, &work_[0], &work_[(*n_) - 1], u_, ldu_);
  }
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _dbdsqr (char _p_ uplo_, int_4 _p_ n_, int_4 _p_ ncvt_, int_4 _p_ nru_, int_4 _p_ ncc_, real_8 _p_ d_, real_8 _p_ 
e_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, 
int_4 _p_ info_)
{
  static int_4 i_, idir_, isub_, iter_, iterdivn_, j_, ll_, lll_, m_, maxitdivn_, nm1_, nm12_, nm13_, oldll_, oldm_;
  static logical_4 lower_, rotate_;
  static real_8 abse_, abss_, cosl_, cosr_, cs_, eps_, f_, g_, h_, mu_, oldcs_, oldsn_, r_, shift_, sigmn_, sigmx_, sinl_
  , sinr_, sll_, smax_, smin_, sminl_, sminoa_, sn_, thresh_, tol_, tolmul_, unfl_;
  int_4 $0_, $6_, $7_, $8_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, $20_;
  real_8 $1_, $2_, $3_, $4_, $5_, $9_, $10_, $11_, $21_;
  extern logical_4 _lsame ();
  extern real_8 _dlamch ();
  extern int_4 _drot ();
  extern int_4 _dscal ();
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  lower_ = _lsame (uplo_, _dc_1);
  if (! (_lsame (uplo_, _dc_0)) && ! (lower_)) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*ncvt_) < 0) {
    (*info_) = -3;
  }
  else if ((*nru_) < 0) {
    (*info_) = -4;
  }
  else if ((*ncc_) < 0) {
    (*info_) = -5;
  }
  else if (((*ncvt_) == 0 && (*ldvt_) < 1) || ((*ncvt_) > 0 && (*ldvt_) < _max (1, (*n_)))) {
    (*info_) = -9;
  }
  else if ((*ldu_) < _max (1, (*nru_))) {
    (*info_) = -11;
  }
  else if (((*ncc_) == 0 && (*ldc_) < 1) || ((*ncc_) > 0 && (*ldc_) < _max (1, (*n_)))) {
    (*info_) = -13;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_13, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*n_) == 1) {
    goto _l160;
  }
  rotate_ = ((*ncvt_) > 0) || ((*nru_) > 0) || ((*ncc_) > 0);
  if (! (rotate_)) {
    (void) _dlasq1 (n_, d_, e_, work_, info_);
    if ((*info_) != 2) {
      goto _l0;
    }
    (*info_) = 0;
  }
  nm1_ = (*n_) - 1;
  nm12_ = nm1_ + nm1_;
  nm13_ = nm12_ + nm1_;
  idir_ = 0;
  eps_ = _dlamch (_dc_10);
  unfl_ = _dlamch (_dc_14);
  if (lower_) {
    for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
      (void) _dlartg (&d_[i_ - 1], &e_[i_ - 1], &cs_, &sn_, &r_);
      d_[i_ - 1] = r_;
      e_[i_ - 1] = sn_ * d_[i_ + 1 - 1];
      d_[i_ + 1 - 1] = cs_ * d_[i_ + 1 - 1];
      work_[i_ - 1] = cs_;
      work_[nm1_ + i_ - 1] = sn_;
    }
    if ((*nru_) > 0) {
      (void) _dlasr (_dc_15, _dc_11, _dc_16, nru_, n_, &work_[0], &work_[(*n_) - 1], u_, ldu_);
    }
    if ((*ncc_) > 0) {
      (void) _dlasr (_dc_1, _dc_11, _dc_16, n_, ncc_, &work_[0], &work_[(*n_) - 1], c_, ldc_);
    }
  }
  tolmul_ = _max (10.0, _min (100.0, pow (eps_, -0.125)));
  tol_ = tolmul_ * eps_;
  smax_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    smax_ = _max (smax_, _abs (d_[i_ - 1]));
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    smax_ = _max (smax_, _abs (e_[i_ - 1]));
  }
  sminl_ = 0.0;
  if (tol_ >= 0.0) {
    sminoa_ = _abs (d_[0]);
    if (sminoa_ == 0.0) {
      goto _l50;
    }
    mu_ = sminoa_;
    for (i_ = 2; i_ <= (*n_); (i_)++) {
      mu_ = _abs (d_[i_ - 1]) * (mu_ / (mu_ + _abs (e_[i_ - 1 - 1])));
      sminoa_ = _min (sminoa_, mu_);
      if (sminoa_ == 0.0) {
        goto _l50;
      }
    }
    _l50:;
    sminoa_ = sminoa_ / sqrt ((real_8) ((*n_)));
    thresh_ = _max (tol_ * sminoa_, 6 * ((*n_) * ((*n_) * unfl_)));
  }
  else {
    thresh_ = _max (_abs (tol_) * smax_, 6 * ((*n_) * ((*n_) * unfl_)));
  }
  maxitdivn_ = 6 * (*n_);
  iterdivn_ = 0;
  iter_ = -1;
  oldll_ = -1;
  oldm_ = -1;
  m_ = (*n_);
  _l60:;
  if (m_ <= 1) {
    goto _l160;
  }
  if (iter_ >= (*n_)) {
    iter_ = iter_ - (*n_);
    iterdivn_ = iterdivn_ + 1;
    if (iterdivn_ >= maxitdivn_) {
      goto _l200;
    }
  }
  if (tol_ < 0.0 && _abs (d_[m_ - 1]) <= thresh_) {
    d_[m_ - 1] = 0.0;
  }
  smax_ = _abs (d_[m_ - 1]);
  smin_ = smax_;
  for (lll_ = 1; lll_ <= m_ - 1; (lll_)++) {
    ll_ = m_ - lll_;
    abss_ = _abs (d_[ll_ - 1]);
    abse_ = _abs (e_[ll_ - 1]);
    if (tol_ < 0.0 && abss_ <= thresh_) {
      d_[ll_ - 1] = 0.0;
    }
    if (abse_ <= thresh_) {
      goto _l80;
    }
    smin_ = _min (smin_, abss_);
    smax_ = ($1_ = _max (smax_, abss_), _max ($1_, abse_));
  }
  ll_ = 0;
  goto _l90;
  _l80:;
  e_[ll_ - 1] = 0.0;
  if (ll_ == m_ - 1) {
    m_ = m_ - 1;
    goto _l60;
  }
  _l90:;
  ll_ = ll_ + 1;
  if (ll_ == m_ - 1) {
    (void) _dlasv2 (&d_[m_ - 1 - 1], &e_[m_ - 1 - 1], &d_[m_ - 1], &sigmn_, &sigmx_, &sinr_, &cosr_, &sinl_, &cosl_);
    d_[m_ - 1 - 1] = sigmx_;
    e_[m_ - 1 - 1] = 0.0;
    d_[m_ - 1] = sigmn_;
    if ((*ncvt_) > 0) {
      (void) _drot (ncvt_, &vt_[m_ - 1 - 1 + ((*ldvt_)) * ((0))], ldvt_, &vt_[m_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &cosr_, 
      &sinr_);
    }
    if ((*nru_) > 0) {
      (void) _drot (nru_, &u_[0 + ((*ldu_)) * ((m_ - 1 - 1))], &_k1, &u_[0 + ((*ldu_)) * ((m_ - 1))], &_k1, &cosl_, &sinl_);
    }
    if ((*ncc_) > 0) {
      (void) _drot (ncc_, &c_[m_ - 1 - 1 + ((*ldc_)) * ((0))], ldc_, &c_[m_ - 1 + ((*ldc_)) * ((0))], ldc_, &cosl_, &sinl_);
    }
    m_ = m_ - 2;
    goto _l60;
  }
  if (ll_ > oldm_ || m_ < oldll_) {
    if (_abs (d_[ll_ - 1]) >= _abs (d_[m_ - 1])) {
      idir_ = 1;
    }
    else {
      idir_ = 2;
    }
  }
  if (idir_ == 1) {
    if (_abs (e_[m_ - 1 - 1]) <= _abs (tol_) * _abs (d_[m_ - 1]) || (tol_ < 0.0 && _abs (e_[m_ - 1 - 1]) <= thresh_)) {
      e_[m_ - 1 - 1] = 0.0;
      goto _l60;
    }
    if (tol_ >= 0.0) {
      mu_ = _abs (d_[ll_ - 1]);
      sminl_ = mu_;
      for (lll_ = ll_; lll_ <= m_ - 1; (lll_)++) {
        if (_abs (e_[lll_ - 1]) <= tol_ * mu_) {
          e_[lll_ - 1] = 0.0;
          goto _l60;
        }
        mu_ = _abs (d_[lll_ + 1 - 1]) * (mu_ / (mu_ + _abs (e_[lll_ - 1])));
        sminl_ = _min (sminl_, mu_);
      }
    }
  }
  else {
    if (_abs (e_[ll_ - 1]) <= _abs (tol_) * _abs (d_[ll_ - 1]) || (tol_ < 0.0 && _abs (e_[ll_ - 1]) <= thresh_)) {
      e_[ll_ - 1] = 0.0;
      goto _l60;
    }
    if (tol_ >= 0.0) {
      mu_ = _abs (d_[m_ - 1]);
      sminl_ = mu_;
      for (lll_ = m_ - 1; lll_ >= ll_; (lll_)--) {
        if (_abs (e_[lll_ - 1]) <= tol_ * mu_) {
          e_[lll_ - 1] = 0.0;
          goto _l60;
        }
        mu_ = _abs (d_[lll_ - 1]) * (mu_ / (mu_ + _abs (e_[lll_ - 1])));
        sminl_ = _min (sminl_, mu_);
      }
    }
  }
  oldll_ = ll_;
  oldm_ = m_;
  if (tol_ >= 0.0 && (*n_) * tol_ * (sminl_ / smax_) <= _max (eps_, 1.0e-2 * tol_)) {
    shift_ = 0.0;
  }
  else {
    if (idir_ == 1) {
      sll_ = _abs (d_[ll_ - 1]);
      (void) _dlas2 (&d_[m_ - 1 - 1], &e_[m_ - 1 - 1], &d_[m_ - 1], &shift_, &r_);
    }
    else {
      sll_ = _abs (d_[m_ - 1]);
      (void) _dlas2 (&d_[ll_ - 1], &e_[ll_ - 1], &d_[ll_ + 1 - 1], &shift_, &r_);
    }
    if (sll_ > 0.0) {
      if (($2_ = (shift_ / sll_), $2_ * $2_) < eps_) {
        shift_ = 0.0;
      }
    }
  }
  iter_ = iter_ + m_ - ll_;
  if (shift_ == 0.0) {
    if (idir_ == 1) {
      cs_ = 1.0;
      oldcs_ = 1.0;
      for (i_ = ll_; i_ <= m_ - 1; (i_)++) {
        (void) _dlartg (($3_ = d_[i_ - 1] * cs_, &$3_), &e_[i_ - 1], &cs_, &sn_, &r_);
        if (i_ > ll_) {
          e_[i_ - 1 - 1] = oldsn_ * r_;
        }
        (void) _dlartg (($4_ = oldcs_ * r_, &$4_), ($5_ = d_[i_ + 1 - 1] * sn_, &$5_), &oldcs_, &oldsn_, &d_[i_ - 1]);
        work_[i_ - ll_ + 1 - 1] = cs_;
        work_[i_ - ll_ + 1 + nm1_ - 1] = sn_;
        work_[i_ - ll_ + 1 + nm12_ - 1] = oldcs_;
        work_[i_ - ll_ + 1 + nm13_ - 1] = oldsn_;
      }
      h_ = d_[m_ - 1] * cs_;
      d_[m_ - 1] = h_ * oldcs_;
      e_[m_ - 1 - 1] = h_ * oldsn_;
      if ((*ncvt_) > 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_16, ($6_ = m_ - ll_ + 1, &$6_), ncvt_, &work_[0], &work_[(*n_) - 1], &vt_[ll_ - 1 + 
        ((*ldvt_)) * ((0))], ldvt_);
      }
      if ((*nru_) > 0) {
        (void) _dlasr (_dc_15, _dc_11, _dc_16, nru_, ($7_ = m_ - ll_ + 1, &$7_), &work_[nm12_ + 1 - 1], &work_[nm13_ + 1 - 1], 
        &u_[0 + ((*ldu_)) * ((ll_ - 1))], ldu_);
      }
      if ((*ncc_) > 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_16, ($8_ = m_ - ll_ + 1, &$8_), ncc_, &work_[nm12_ + 1 - 1], &work_[nm13_ + 1 - 1], 
        &c_[ll_ - 1 + ((*ldc_)) * ((0))], ldc_);
      }
      if (_abs (e_[m_ - 1 - 1]) <= thresh_) {
        e_[m_ - 1 - 1] = 0.0;
      }
    }
    else {
      cs_ = 1.0;
      oldcs_ = 1.0;
      for (i_ = m_; i_ >= ll_ + 1; (i_)--) {
        (void) _dlartg (($9_ = d_[i_ - 1] * cs_, &$9_), &e_[i_ - 1 - 1], &cs_, &sn_, &r_);
        if (i_ < m_) {
          e_[i_ - 1] = oldsn_ * r_;
        }
        (void) _dlartg (($10_ = oldcs_ * r_, &$10_), ($11_ = d_[i_ - 1 - 1] * sn_, &$11_), &oldcs_, &oldsn_, &d_[i_ - 1]);
        work_[i_ - ll_ - 1] = cs_;
        work_[i_ - ll_ + nm1_ - 1] = -sn_;
        work_[i_ - ll_ + nm12_ - 1] = oldcs_;
        work_[i_ - ll_ + nm13_ - 1] = -oldsn_;
      }
      h_ = d_[ll_ - 1] * cs_;
      d_[ll_ - 1] = h_ * oldcs_;
      e_[ll_ - 1] = h_ * oldsn_;
      if ((*ncvt_) > 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_12, ($12_ = m_ - ll_ + 1, &$12_), ncvt_, &work_[nm12_ + 1 - 1], &work_[nm13_ + 1 - 
        1], &vt_[ll_ - 1 + ((*ldvt_)) * ((0))], ldvt_);
      }
      if ((*nru_) > 0) {
        (void) _dlasr (_dc_15, _dc_11, _dc_12, nru_, ($13_ = m_ - ll_ + 1, &$13_), &work_[0], &work_[(*n_) - 1], &u_[0 + 
        ((*ldu_)) * ((ll_ - 1))], ldu_);
      }
      if ((*ncc_) > 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_12, ($14_ = m_ - ll_ + 1, &$14_), ncc_, &work_[0], &work_[(*n_) - 1], &c_[ll_ - 1 + 
        ((*ldc_)) * ((0))], ldc_);
      }
      if (_abs (e_[ll_ - 1]) <= thresh_) {
        e_[ll_ - 1] = 0.0;
      }
    }
  }
  else {
    if (idir_ == 1) {
      f_ = (_abs (d_[ll_ - 1]) - shift_) * (_sign (1.0, d_[ll_ - 1]) + shift_ / d_[ll_ - 1]);
      g_ = e_[ll_ - 1];
      for (i_ = ll_; i_ <= m_ - 1; (i_)++) {
        (void) _dlartg (&f_, &g_, &cosr_, &sinr_, &r_);
        if (i_ > ll_) {
          e_[i_ - 1 - 1] = r_;
        }
        f_ = cosr_ * d_[i_ - 1] + sinr_ * e_[i_ - 1];
        e_[i_ - 1] = cosr_ * e_[i_ - 1] - sinr_ * d_[i_ - 1];
        g_ = sinr_ * d_[i_ + 1 - 1];
        d_[i_ + 1 - 1] = cosr_ * d_[i_ + 1 - 1];
        (void) _dlartg (&f_, &g_, &cosl_, &sinl_, &r_);
        d_[i_ - 1] = r_;
        f_ = cosl_ * e_[i_ - 1] + sinl_ * d_[i_ + 1 - 1];
        d_[i_ + 1 - 1] = cosl_ * d_[i_ + 1 - 1] - sinl_ * e_[i_ - 1];
        if (i_ < m_ - 1) {
          g_ = sinl_ * e_[i_ + 1 - 1];
          e_[i_ + 1 - 1] = cosl_ * e_[i_ + 1 - 1];
        }
        work_[i_ - ll_ + 1 - 1] = cosr_;
        work_[i_ - ll_ + 1 + nm1_ - 1] = sinr_;
        work_[i_ - ll_ + 1 + nm12_ - 1] = cosl_;
        work_[i_ - ll_ + 1 + nm13_ - 1] = sinl_;
      }
      e_[m_ - 1 - 1] = f_;
      if ((*ncvt_) > 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_16, ($15_ = m_ - ll_ + 1, &$15_), ncvt_, &work_[0], &work_[(*n_) - 1], &vt_[ll_ - 1 + 
        ((*ldvt_)) * ((0))], ldvt_);
      }
      if ((*nru_) > 0) {
        (void) _dlasr (_dc_15, _dc_11, _dc_16, nru_, ($16_ = m_ - ll_ + 1, &$16_), &work_[nm12_ + 1 - 1], &work_[nm13_ + 1 - 
        1], &u_[0 + ((*ldu_)) * ((ll_ - 1))], ldu_);
      }
      if ((*ncc_) > 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_16, ($17_ = m_ - ll_ + 1, &$17_), ncc_, &work_[nm12_ + 1 - 1], &work_[nm13_ + 1 - 1], 
        &c_[ll_ - 1 + ((*ldc_)) * ((0))], ldc_);
      }
      if (_abs (e_[m_ - 1 - 1]) <= thresh_) {
        e_[m_ - 1 - 1] = 0.0;
      }
    }
    else {
      f_ = (_abs (d_[m_ - 1]) - shift_) * (_sign (1.0, d_[m_ - 1]) + shift_ / d_[m_ - 1]);
      g_ = e_[m_ - 1 - 1];
      for (i_ = m_; i_ >= ll_ + 1; (i_)--) {
        (void) _dlartg (&f_, &g_, &cosr_, &sinr_, &r_);
        if (i_ < m_) {
          e_[i_ - 1] = r_;
        }
        f_ = cosr_ * d_[i_ - 1] + sinr_ * e_[i_ - 1 - 1];
        e_[i_ - 1 - 1] = cosr_ * e_[i_ - 1 - 1] - sinr_ * d_[i_ - 1];
        g_ = sinr_ * d_[i_ - 1 - 1];
        d_[i_ - 1 - 1] = cosr_ * d_[i_ - 1 - 1];
        (void) _dlartg (&f_, &g_, &cosl_, &sinl_, &r_);
        d_[i_ - 1] = r_;
        f_ = cosl_ * e_[i_ - 1 - 1] + sinl_ * d_[i_ - 1 - 1];
        d_[i_ - 1 - 1] = cosl_ * d_[i_ - 1 - 1] - sinl_ * e_[i_ - 1 - 1];
        if (i_ > ll_ + 1) {
          g_ = sinl_ * e_[i_ - 2 - 1];
          e_[i_ - 2 - 1] = cosl_ * e_[i_ - 2 - 1];
        }
        work_[i_ - ll_ - 1] = cosr_;
        work_[i_ - ll_ + nm1_ - 1] = -sinr_;
        work_[i_ - ll_ + nm12_ - 1] = cosl_;
        work_[i_ - ll_ + nm13_ - 1] = -sinl_;
      }
      e_[ll_ - 1] = f_;
      if (_abs (e_[ll_ - 1]) <= thresh_) {
        e_[ll_ - 1] = 0.0;
      }
      if ((*ncvt_) > 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_12, ($18_ = m_ - ll_ + 1, &$18_), ncvt_, &work_[nm12_ + 1 - 1], &work_[nm13_ + 1 - 
        1], &vt_[ll_ - 1 + ((*ldvt_)) * ((0))], ldvt_);
      }
      if ((*nru_) > 0) {
        (void) _dlasr (_dc_15, _dc_11, _dc_12, nru_, ($19_ = m_ - ll_ + 1, &$19_), &work_[0], &work_[(*n_) - 1], &u_[0 + 
        ((*ldu_)) * ((ll_ - 1))], ldu_);
      }
      if ((*ncc_) > 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_12, ($20_ = m_ - ll_ + 1, &$20_), ncc_, &work_[0], &work_[(*n_) - 1], &c_[ll_ - 1 + 
        ((*ldc_)) * ((0))], ldc_);
      }
    }
  }
  goto _l60;
  _l160:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (d_[i_ - 1] < 0.0) {
      d_[i_ - 1] = -d_[i_ - 1];
      if ((*ncvt_) > 0) {
        (void) _dscal (ncvt_, ($21_ = -1.0, &$21_), &vt_[i_ - 1 + ((*ldvt_)) * ((0))], ldvt_);
      }
    }
  }
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    isub_ = 1;
    smin_ = d_[0];
    for (j_ = 2; j_ <= (*n_) + 1 - i_; (j_)++) {
      if (d_[j_ - 1] <= smin_) {
        isub_ = j_;
        smin_ = d_[j_ - 1];
      }
    }
    if (isub_ != (*n_) + 1 - i_) {
      d_[isub_ - 1] = d_[(*n_) + 1 - i_ - 1];
      d_[(*n_) + 1 - i_ - 1] = smin_;
      if ((*ncvt_) > 0) {
        (void) _dswap (ncvt_, &vt_[isub_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &vt_[(*n_) + 1 - i_ - 1 + ((*ldvt_)) * ((0))], 
        ldvt_);
      }
      if ((*nru_) > 0) {
        (void) _dswap (nru_, &u_[0 + ((*ldu_)) * ((isub_ - 1))], &_k1, &u_[0 + ((*ldu_)) * (((*n_) + 1 - i_ - 1))], &_k1);
      }
      if ((*ncc_) > 0) {
        (void) _dswap (ncc_, &c_[isub_ - 1 + ((*ldc_)) * ((0))], ldc_, &c_[(*n_) + 1 - i_ - 1 + ((*ldc_)) * ((0))], ldc_);
      }
    }
  }
  goto _l220;
  _l200:;
  (*info_) = 0;
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    if (e_[i_ - 1] != 0.0) {
      (*info_) = (*info_) + 1;
    }
  }
  _l220:;
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _dcombssq (real_8 _p_ v1_, real_8 _p_ v2_)
{
  real_8 $0_, $1_;
  if (v1_[0] >= v2_[0]) {
    if (v1_[0] != 0.0) {
      v1_[1] = v1_[1] + ($0_ = (v2_[0] / v1_[0]), $0_ * $0_) * v2_[1];
    }
    else {
      v1_[1] = v1_[1] + v2_[1];
    }
  }
  else {
    v1_[1] = v2_[1] + ($1_ = (v1_[0] / v2_[0]), $1_ * $1_) * v1_[1];
    v1_[0] = v2_[0];
  }
  __calls[2].calls++;
  return 0;
}

int_4 _dgebd2 (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ 
tauq_, real_8 _p_ taup_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  if ((*info_) < 0) {
    (void) _xerbla (_dc_17, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) >= (*n_)) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      (void) _dlarfg (($1_ = (*m_) - i_ + 1, &$1_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[_min (i_ + 1, (*m_)) - 1 + 
      ((*lda_)) * ((i_ - 1))], &_k1, &tauq_[i_ - 1]);
      d_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
      if (i_ < (*n_)) {
        (void) _dlarf (_dc_18, ($2_ = (*m_) - i_ + 1, &$2_), ($3_ = (*n_) - i_, &$3_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
        &_k1, &tauq_[i_ - 1], &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, work_);
      }
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = d_[i_ - 1];
      if (i_ < (*n_)) {
        (void) _dlarfg (($4_ = (*n_) - i_, &$4_), &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], &a_[i_ - 1 + ((*lda_)) * ((_min (i_ 
        + 2, (*n_)) - 1))], lda_, &taup_[i_ - 1]);
        e_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))];
        a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))] = 1.0;
        (void) _dlarf (_dc_19, ($5_ = (*m_) - i_, &$5_), ($6_ = (*n_) - i_, &$6_), &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], 
        lda_, &taup_[i_ - 1], &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, work_);
        a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))] = e_[i_ - 1];
      }
      else {
        taup_[i_ - 1] = 0.0;
      }
    }
  }
  else {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      (void) _dlarfg (($7_ = (*n_) - i_ + 1, &$7_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[i_ - 1 + ((*lda_)) * ((_min (i_ 
      + 1, (*n_)) - 1))], lda_, &taup_[i_ - 1]);
      d_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
      if (i_ < (*m_)) {
        (void) _dlarf (_dc_19, ($8_ = (*m_) - i_, &$8_), ($9_ = (*n_) - i_ + 1, &$9_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
        lda_, &taup_[i_ - 1], &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], lda_, work_);
      }
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = d_[i_ - 1];
      if (i_ < (*m_)) {
        (void) _dlarfg (($10_ = (*m_) - i_, &$10_), &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], &a_[_min (i_ + 2, (*m_)) - 1 + 
        ((*lda_)) * ((i_ - 1))], &_k1, &tauq_[i_ - 1]);
        e_[i_ - 1] = a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))];
        a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
        (void) _dlarf (_dc_18, ($11_ = (*m_) - i_, &$11_), ($12_ = (*n_) - i_, &$12_), &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 
        1))], &_k1, &tauq_[i_ - 1], &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, work_);
        a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))] = e_[i_ - 1];
      }
      else {
        tauq_[i_ - 1] = 0.0;
      }
    }
  }
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _dgebrd (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ 
tauq_, real_8 _p_ taup_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 i_, iinfo_, j_, ldwrkx_, ldwrky_, lwkopt_, minmn_, nb_, nbmin_, nx_, ws_;
  static logical_4 lquery_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $10_, $11_, $14_, $15_;
  real_8 $8_, $9_, $12_, $13_;
  extern int_4 _dgemm ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  nb_ = _max (1, _ilaenv (&_k1, _dc_20, _dc_6, m_, n_, &_km1, &_km1));
  lwkopt_ = ((*m_) + (*n_)) * nb_;
  work_[0] = (real_8) (lwkopt_);
  lquery_ = ((*lwork_) == -1);
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  else if ((*lwork_) < ($0_ = _max (1, (*m_)), _max ($0_, (*n_))) && ! (lquery_)) {
    (*info_) = -10;
  }
  if ((*info_) < 0) {
    (void) _xerbla (_dc_20, ($1_ = -(*info_), &$1_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  minmn_ = _min ((*m_), (*n_));
  if (minmn_ == 0) {
    work_[0] = 1;
    goto _l0;
  }
  ws_ = _max ((*m_), (*n_));
  ldwrkx_ = (*m_);
  ldwrky_ = (*n_);
  if (nb_ > 1 && nb_ < minmn_) {
    nx_ = _max (nb_, _ilaenv (($2_ = 3, &$2_), _dc_20, _dc_6, m_, n_, &_km1, &_km1));
    if (nx_ < minmn_) {
      ws_ = ((*m_) + (*n_)) * nb_;
      if ((*lwork_) < ws_) {
        nbmin_ = _ilaenv (($3_ = 2, &$3_), _dc_20, _dc_6, m_, n_, &_km1, &_km1);
        if ((*lwork_) >= ((*m_) + (*n_)) * nbmin_) {
          nb_ = (*lwork_) / ((*m_) + (*n_));
        }
        else {
          nb_ = 1;
          nx_ = minmn_;
        }
      }
    }
  }
  else {
    nx_ = minmn_;
  }
  for (i_ = 1; (nb_ > 0 ? i_ <= minmn_ - nx_ : i_ >= minmn_ - nx_); i_ += nb_) {
    (void) _dlabrd (($4_ = (*m_) - i_ + 1, &$4_), ($5_ = (*n_) - i_ + 1, &$5_), &nb_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
    lda_, &d_[i_ - 1], &e_[i_ - 1], &tauq_[i_ - 1], &taup_[i_ - 1], work_, &ldwrkx_, &work_[ldwrkx_ * nb_ + 1 - 1], 
    &ldwrky_);
    (void) _dgemm (_dc_21, _dc_22, ($6_ = (*m_) - i_ - nb_ + 1, &$6_), ($7_ = (*n_) - i_ - nb_ + 1, &$7_), &nb_, ($8_ = 
    -1.0, &$8_), &a_[i_ + nb_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, &work_[ldwrkx_ * nb_ + nb_ + 1 - 1], &ldwrky_, ($9_ = 
    1.0, &$9_), &a_[i_ + nb_ - 1 + ((*lda_)) * ((i_ + nb_ - 1))], lda_);
    (void) _dgemm (_dc_21, _dc_21, ($10_ = (*m_) - i_ - nb_ + 1, &$10_), ($11_ = (*n_) - i_ - nb_ + 1, &$11_), &nb_, ($12_ 
    = -1.0, &$12_), &work_[nb_ + 1 - 1], &ldwrkx_, &a_[i_ - 1 + ((*lda_)) * ((i_ + nb_ - 1))], lda_, ($13_ = 1.0, &$13_), 
    &a_[i_ + nb_ - 1 + ((*lda_)) * ((i_ + nb_ - 1))], lda_);
    if ((*m_) >= (*n_)) {
      for (j_ = i_; j_ <= i_ + nb_ - 1; (j_)++) {
        a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = d_[j_ - 1];
        a_[j_ - 1 + ((*lda_)) * ((j_ + 1 - 1))] = e_[j_ - 1];
      }
    }
    else {
      for (j_ = i_; j_ <= i_ + nb_ - 1; (j_)++) {
        a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = d_[j_ - 1];
        a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))] = e_[j_ - 1];
      }
    }
  }
  (void) _dgebd2 (($14_ = (*m_) - i_ + 1, &$14_), ($15_ = (*n_) - i_ + 1, &$15_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
  lda_, &d_[i_ - 1], &e_[i_ - 1], &tauq_[i_ - 1], &taup_[i_ - 1], work_, &iinfo_);
  work_[0] = ws_;
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _dgejsv (char _p_ joba_, char _p_ jobu_, char _p_ jobv_, char _p_ jobr_, char _p_ jobt_, char _p_ jobp_, int_4 
_p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ sva_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ v_, 
int_4 _p_ ldv_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ info_)
{
  static int_4 ierr_, n1_, nr_, numrank_, p_, q_, warning_;
  static logical_4 almort_, defr_, errest_, goscal_, jracc_, kill_, lsvec_, l2aber_, l2kill_, l2pert_, l2rank_, l2tran_, 
  noscal_, rowpiv_, rsvec_, transp_;
  static real_8 aapp_, aaqq_, aatmax_, aatmin_, big_, big1_, cond_ok_, condr1_, condr2_, entra_, entrat_, epsln_, maxprj_
  , scalem_, sconda_, sfmin_, small_, temp1_, uscal1_, uscal2_, xsc_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $12_, $13_, $18_, $19_, $20_, $27_, $28_, $29_, $32_, $33_, $34_, $35_, 
  $38_, $39_, $40_, $43_, $44_, $47_, $48_, $49_, $52_, $53_, $54_, $55_, $58_, $61_, $64_, $65_, $68_, $69_, $70_, $71_, 
  $74_, $75_, $76_, $77_, $80_, $81_, $84_, $87_, $88_, $91_, $92_, $93_, $94_, $95_, $98_, $99_, $102_, $103_, $104_, 
  $105_, $106_, $109_, $112_, $113_, $116_, $119_, $122_, $125_, $126_, $129_, $130_, $132_, $135_, $138_, $139_, $142_, 
  $143_, $144_, $147_, $150_, $151_, $154_, $155_, $156_, $159_, $162_, $163_, $166_, $167_, $168_, $169_, $172_, $174_, 
  $177_, $180_, $181_, $184_, $185_, $186_, $187_, $188_, $191_, $192_, $193_, $194_, $197_, $198_, $201_, $204_, $205_, 
  $208_, $209_, $212_, $215_, $216_, $219_, $220_;
  real_8 $8_, $9_, $10_, $11_, $14_, $15_, $16_, $17_, $21_, $22_, $23_, $24_, $25_, $26_, $30_, $31_, $36_, $37_, $41_, 
  $42_, $45_, $46_, $50_, $51_, $56_, $57_, $59_, $60_, $62_, $63_, $66_, $67_, $72_, $73_, $78_, $79_, $82_, $83_, $85_, 
  $86_, $89_, $90_, $96_, $97_, $100_, $101_, $107_, $108_, $110_, $111_, $114_, $115_, $117_, $118_, $120_, $121_, $123_
  , $124_, $127_, $128_, $131_, $133_, $134_, $136_, $137_, $140_, $141_, $145_, $146_, $148_, $149_, $152_, $153_, $157_
  , $158_, $160_, $161_, $164_, $165_, $170_, $171_, $173_, $175_, $176_, $178_, $179_, $182_, $183_, $189_, $190_, $195_
  , $196_, $199_, $200_, $202_, $203_, $206_, $207_, $210_, $211_, $213_, $214_, $217_, $218_;
  extern real_8 _dlamch ();
  extern real_8 _dnrm2 ();
  extern int_4 _idamax ();
  extern logical_4 _lsame ();
  extern int_4 _dcopy ();
  extern int_4 _dscal ();
  extern int_4 _dswap ();
  extern int_4 _dtrsm ();
  extern int_4 _xerbla ();
  lsvec_ = _lsame (jobu_, _dc_0) || _lsame (jobu_, _dc_16);
  jracc_ = _lsame (jobv_, _dc_23);
  rsvec_ = _lsame (jobv_, _dc_11) || jracc_;
  rowpiv_ = _lsame (joba_, _dc_16) || _lsame (joba_, _dc_9);
  l2rank_ = _lsame (joba_, _dc_15);
  l2aber_ = _lsame (joba_, _dc_7);
  errest_ = _lsame (joba_, _dc_24) || _lsame (joba_, _dc_9);
  l2tran_ = _lsame (jobt_, _dc_25);
  l2kill_ = _lsame (jobr_, _dc_15);
  defr_ = _lsame (jobr_, _dc_2);
  l2pert_ = _lsame (jobp_, _dc_3);
  if (! ((rowpiv_ || l2rank_ || l2aber_ || errest_ || _lsame (joba_, _dc_26)))) {
    (*info_) = -1;
  }
  else if (! ((lsvec_ || _lsame (jobu_, _dc_2) || _lsame (jobu_, _dc_27)))) {
    (*info_) = -2;
  }
  else if (! ((rsvec_ || _lsame (jobv_, _dc_2) || _lsame (jobv_, _dc_27))) || (jracc_ && (! (lsvec_)))) {
    (*info_) = -3;
  }
  else if (! ((l2kill_ || defr_))) {
    (*info_) = -4;
  }
  else if (! ((l2tran_ || _lsame (jobt_, _dc_2)))) {
    (*info_) = -5;
  }
  else if (! ((l2pert_ || _lsame (jobp_, _dc_2)))) {
    (*info_) = -6;
  }
  else if ((*m_) < 0) {
    (*info_) = -7;
  }
  else if (((*n_) < 0) || ((*n_) > (*m_))) {
    (*info_) = -8;
  }
  else if ((*lda_) < (*m_)) {
    (*info_) = -10;
  }
  else if (lsvec_ && ((*ldu_) < (*m_))) {
    (*info_) = -13;
  }
  else if (rsvec_ && ((*ldv_) < (*n_))) {
    (*info_) = -15;
  }
  else if ((! ((lsvec_ || rsvec_ || errest_)) && ((*lwork_) < ($0_ = _max (7, 4 * (*n_) + 1), _max ($0_, 2 * (*m_) + 
    (*n_))))) || (! ((lsvec_ || rsvec_)) && errest_ && ((*lwork_) < ($1_ = _max (7, 4 * (*n_) + (*n_) * (*n_)), _max ($1_, 
    2 * (*m_) + (*n_))))) || (lsvec_ && (! (rsvec_)) && ((*lwork_) < ($2_ = _max (7, 2 * (*m_) + (*n_)), _max ($2_, 4 * 
    (*n_) + 1)))) || (rsvec_ && (! (lsvec_)) && ((*lwork_) < ($3_ = _max (7, 2 * (*m_) + (*n_)), _max ($3_, 4 * (*n_) + 
    1)))) || (lsvec_ && rsvec_ && (! (jracc_)) && ((*lwork_) < _max (2 * (*m_) + (*n_), 6 * (*n_) + 2 * (*n_) * (*n_)))) || 
    (lsvec_ && rsvec_ && jracc_ && (*lwork_) < ($4_ = _max (2 * (*m_) + (*n_), 4 * (*n_) + (*n_) * (*n_)), _max ($4_, 2 * 
    (*n_) + (*n_) * (*n_) + 6)))) {
    (*info_) = -17;
  }
  else {
    (*info_) = 0;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_28, ($5_ = -(*info_), &$5_));
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0)) {
    for (p_ = 1; p_ <= 3; (p_)++) {
      iwork_[p_ - 1] = 0;
    }
    for (p_ = 1; p_ <= 7; (p_)++) {
      work_[p_ - 1] = 0;
    }
    goto _l0;
  }
  if (lsvec_) {
    n1_ = (*n_);
    if (_lsame (jobu_, _dc_16)) {
      n1_ = (*m_);
    }
  }
  epsln_ = _dlamch (_dc_10);
  sfmin_ = _dlamch (_dc_29);
  small_ = sfmin_ / epsln_;
  big_ = _dlamch (_dc_30);
  scalem_ = 1.0 / sqrt ((real_8) ((*m_)) * (real_8) ((*n_)));
  noscal_ = TRUE;
  goscal_ = TRUE;
  for (p_ = 1; p_ <= (*n_); (p_)++) {
    aapp_ = 0.0;
    aaqq_ = 1.0;
    (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &aapp_, &aaqq_);
    if (aapp_ > big_) {
      (*info_) = -9;
      (void) _xerbla (_dc_28, ($6_ = -(*info_), &$6_));
      goto _l0;
    }
    aaqq_ = sqrt (aaqq_);
    if ((aapp_ < (big_ / aaqq_)) && noscal_) {
      sva_[p_ - 1] = aapp_ * aaqq_;
    }
    else {
      noscal_ = FALSE;
      sva_[p_ - 1] = aapp_ * (aaqq_ * scalem_);
      if (goscal_) {
        goscal_ = FALSE;
        (void) _dscal (($7_ = p_ - 1, &$7_), &scalem_, sva_, &_k1);
      }
    }
  }
  if (noscal_) {
    scalem_ = 1.0;
  }
  aapp_ = 0.0;
  aaqq_ = big_;
  for (p_ = 1; p_ <= (*n_); (p_)++) {
    aapp_ = _max (aapp_, sva_[p_ - 1]);
    if (sva_[p_ - 1] != 0.0) {
      aaqq_ = _min (aaqq_, sva_[p_ - 1]);
    }
  }
  if (aapp_ == 0.0) {
    if (lsvec_) {
      (void) _dlaset (_dc_9, m_, &n1_, ($8_ = 0.0, &$8_), ($9_ = 1.0, &$9_), u_, ldu_);
    }
    if (rsvec_) {
      (void) _dlaset (_dc_9, n_, n_, ($10_ = 0.0, &$10_), ($11_ = 1.0, &$11_), v_, ldv_);
    }
    work_[0] = 1.0;
    work_[1] = 1.0;
    if (errest_) {
      work_[2] = 1.0;
    }
    if (lsvec_ && rsvec_) {
      work_[3] = 1.0;
      work_[4] = 1.0;
    }
    if (l2tran_) {
      work_[5] = 0.0;
      work_[6] = 0.0;
    }
    iwork_[0] = 0;
    iwork_[1] = 0;
    iwork_[2] = 0;
    goto _l0;
  }
  warning_ = 0;
  if (aaqq_ <= sfmin_) {
    l2rank_ = TRUE;
    l2kill_ = TRUE;
    warning_ = 1;
  }
  if ((*n_) == 1) {
    if (lsvec_) {
      (void) _dlascl (_dc_9, &_k0, &_k0, &sva_[0], &scalem_, m_, &_k1, &a_[0 + ((*lda_)) * ((0))], lda_, &ierr_);
      (void) _dlacpy (_dc_7, m_, &_k1, a_, lda_, u_, ldu_);
      if (n1_ != (*n_)) {
        (void) _dgeqrf (m_, n_, u_, ldu_, work_, &work_[(*n_) + 1 - 1], ($12_ = (*lwork_) - (*n_), &$12_), &ierr_);
        (void) _dorgqr (m_, &n1_, &_k1, u_, ldu_, work_, &work_[(*n_) + 1 - 1], ($13_ = (*lwork_) - (*n_), &$13_), &ierr_);
        (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((0))], &_k1, &u_[0 + ((*ldu_)) * ((0))], &_k1);
      }
    }
    if (rsvec_) {
      v_[0 + ((*ldv_)) * ((0))] = 1.0;
    }
    if (sva_[0] < (big_ * scalem_)) {
      sva_[0] = sva_[0] / scalem_;
      scalem_ = 1.0;
    }
    work_[0] = 1.0 / scalem_;
    work_[1] = 1.0;
    if (sva_[0] != 0.0) {
      iwork_[0] = 1;
      if ((sva_[0] / scalem_) >= sfmin_) {
        iwork_[1] = 1;
      }
      else {
        iwork_[1] = 0;
      }
    }
    else {
      iwork_[0] = 0;
      iwork_[1] = 0;
    }
    iwork_[2] = 0;
    if (errest_) {
      work_[2] = 1.0;
    }
    if (lsvec_ && rsvec_) {
      work_[3] = 1.0;
      work_[4] = 1.0;
    }
    if (l2tran_) {
      work_[5] = 0.0;
      work_[6] = 0.0;
    }
    goto _l0;
  }
  transp_ = FALSE;
  l2tran_ = l2tran_ && ((*m_) == (*n_));
  aatmax_ = -1.0;
  aatmin_ = big_;
  if (rowpiv_ || l2tran_) {
    if (l2tran_) {
      for (p_ = 1; p_ <= (*m_); (p_)++) {
        xsc_ = 0.0;
        temp1_ = 1.0;
        (void) _dlassq (n_, &a_[p_ - 1 + ((*lda_)) * ((0))], lda_, &xsc_, &temp1_);
        work_[(*m_) + (*n_) + p_ - 1] = xsc_ * scalem_;
        work_[(*n_) + p_ - 1] = xsc_ * (scalem_ * sqrt (temp1_));
        aatmax_ = _max (aatmax_, work_[(*n_) + p_ - 1]);
        if (work_[(*n_) + p_ - 1] != 0.0) {
          aatmin_ = _min (aatmin_, work_[(*n_) + p_ - 1]);
        }
      }
    }
    else {
      for (p_ = 1; p_ <= (*m_); (p_)++) {
        work_[(*m_) + (*n_) + p_ - 1] = scalem_ * _abs (a_[p_ - 1 + ((*lda_)) * ((_idamax (n_, &a_[p_ - 1 + ((*lda_)) * ((0))], 
        lda_) - 1))]);
        aatmax_ = _max (aatmax_, work_[(*m_) + (*n_) + p_ - 1]);
        aatmin_ = _min (aatmin_, work_[(*m_) + (*n_) + p_ - 1]);
      }
    }
  }
  entra_ = 0.0;
  entrat_ = 0.0;
  if (l2tran_) {
    xsc_ = 0.0;
    temp1_ = 1.0;
    (void) _dlassq (n_, sva_, &_k1, &xsc_, &temp1_);
    temp1_ = 1.0 / temp1_;
    entra_ = 0.0;
    for (p_ = 1; p_ <= (*n_); (p_)++) {
      big1_ = (($14_ = (sva_[p_ - 1] / xsc_), $14_ * $14_)) * temp1_;
      if (big1_ != 0.0) {
        entra_ = entra_ + big1_ * log (big1_);
      }
    }
    entra_ = -entra_ / log ((real_8) ((*n_)));
    entrat_ = 0.0;
    for (p_ = (*n_) + 1; p_ <= (*n_) + (*m_); (p_)++) {
      big1_ = (($15_ = (work_[p_ - 1] / xsc_), $15_ * $15_)) * temp1_;
      if (big1_ != 0.0) {
        entrat_ = entrat_ + big1_ * log (big1_);
      }
    }
    entrat_ = -entrat_ / log ((real_8) ((*m_)));
    transp_ = (entrat_ < entra_);
    if (transp_) {
      for (p_ = 1; p_ <= (*n_) - 1; (p_)++) {
        for (q_ = p_ + 1; q_ <= (*n_); (q_)++) {
          temp1_ = a_[q_ - 1 + ((*lda_)) * ((p_ - 1))];
          a_[q_ - 1 + ((*lda_)) * ((p_ - 1))] = a_[p_ - 1 + ((*lda_)) * ((q_ - 1))];
          a_[p_ - 1 + ((*lda_)) * ((q_ - 1))] = temp1_;
        }
      }
      for (p_ = 1; p_ <= (*n_); (p_)++) {
        work_[(*m_) + (*n_) + p_ - 1] = sva_[p_ - 1];
        sva_[p_ - 1] = work_[(*n_) + p_ - 1];
      }
      temp1_ = aapp_;
      aapp_ = aatmax_;
      aatmax_ = temp1_;
      temp1_ = aaqq_;
      aaqq_ = aatmin_;
      aatmin_ = temp1_;
      kill_ = lsvec_;
      lsvec_ = rsvec_;
      rsvec_ = kill_;
      if (lsvec_) {
        n1_ = (*n_);
      }
      rowpiv_ = TRUE;
    }
  }
  big1_ = sqrt (big_);
  temp1_ = sqrt (big_ / (real_8) ((*n_)));
  (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, &temp1_, n_, &_k1, sva_, n_, &ierr_);
  if (aaqq_ > (aapp_ * sfmin_)) {
    aaqq_ = (aaqq_ / aapp_) * temp1_;
  }
  else {
    aaqq_ = (aaqq_ * temp1_) / aapp_;
  }
  temp1_ = temp1_ * scalem_;
  (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, &temp1_, m_, n_, a_, lda_, &ierr_);
  uscal1_ = temp1_;
  uscal2_ = aapp_;
  if (l2kill_) {
    xsc_ = sqrt (sfmin_);
  }
  else {
    xsc_ = small_;
    if ((aaqq_ < sqrt (sfmin_)) && lsvec_ && rsvec_) {
      jracc_ = TRUE;
    }
  }
  if (aaqq_ < xsc_) {
    for (p_ = 1; p_ <= (*n_); (p_)++) {
      if (sva_[p_ - 1] < xsc_) {
        (void) _dlaset (_dc_7, m_, &_k1, ($16_ = 0.0, &$16_), ($17_ = 0.0, &$17_), &a_[0 + ((*lda_)) * ((p_ - 1))], lda_);
        sva_[p_ - 1] = 0.0;
      }
    }
  }
  if (rowpiv_) {
    for (p_ = 1; p_ <= (*m_) - 1; (p_)++) {
      q_ = _idamax (($18_ = (*m_) - p_ + 1, &$18_), &work_[(*m_) + (*n_) + p_ - 1], &_k1) + p_ - 1;
      iwork_[2 * (*n_) + p_ - 1] = q_;
      if (p_ != q_) {
        temp1_ = work_[(*m_) + (*n_) + p_ - 1];
        work_[(*m_) + (*n_) + p_ - 1] = work_[(*m_) + (*n_) + q_ - 1];
        work_[(*m_) + (*n_) + q_ - 1] = temp1_;
      }
    }
    (void) _dlaswp (n_, a_, lda_, &_k1, ($19_ = (*m_) - 1, &$19_), &iwork_[2 * (*n_) + 1 - 1], &_k1);
  }
  for (p_ = 1; p_ <= (*n_); (p_)++) {
    iwork_[p_ - 1] = 0;
  }
  (void) _dgeqp3 (m_, n_, a_, lda_, iwork_, work_, &work_[(*n_) + 1 - 1], ($20_ = (*lwork_) - (*n_), &$20_), &ierr_);
  nr_ = 1;
  if (l2aber_) {
    temp1_ = sqrt ((real_8) ((*n_))) * epsln_;
    for (p_ = 2; p_ <= (*n_); (p_)++) {
      if (_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) >= (temp1_ * _abs (a_[0 + ((*lda_)) * ((0))]))) {
        nr_ = nr_ + 1;
      }
      else {
        goto _l3002;
      }
    }
    _l3002:;
  }
  else if (l2rank_) {
    temp1_ = sqrt (sfmin_);
    for (p_ = 2; p_ <= (*n_); (p_)++) {
      if ((_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) < (epsln_ * _abs (a_[p_ - 1 - 1 + ((*lda_)) * ((p_ - 1 - 1))]))) || 
        (_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) < small_) || (l2kill_ && (_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) < 
        temp1_))) {
        goto _l3402;
      }
      nr_ = nr_ + 1;
    }
    _l3402:;
  }
  else {
    temp1_ = sqrt (sfmin_);
    for (p_ = 2; p_ <= (*n_); (p_)++) {
      if ((_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) < small_) || (l2kill_ && (_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) < 
        temp1_))) {
        goto _l3302;
      }
      nr_ = nr_ + 1;
    }
    _l3302:;
  }
  almort_ = FALSE;
  if (nr_ == (*n_)) {
    maxprj_ = 1.0;
    for (p_ = 2; p_ <= (*n_); (p_)++) {
      temp1_ = _abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) / sva_[iwork_[p_ - 1] - 1];
      maxprj_ = _min (maxprj_, temp1_);
    }
    if ((maxprj_ * maxprj_) >= 1.0 - (real_8) ((*n_)) * epsln_) {
      almort_ = TRUE;
    }
  }
  sconda_ = -1.0;
  condr1_ = -1.0;
  condr2_ = -1.0;
  if (errest_) {
    if ((*n_) == nr_) {
      if (rsvec_) {
        (void) _dlacpy (_dc_0, n_, n_, a_, lda_, v_, ldv_);
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          temp1_ = sva_[iwork_[p_ - 1] - 1];
          (void) _dscal (&p_, ($21_ = 1.0 / temp1_, &$21_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
        }
        (void) _dpocon (_dc_0, n_, v_, ldv_, ($22_ = 1.0, &$22_), &temp1_, &work_[(*n_) + 1 - 1], &iwork_[2 * (*n_) + (*m_) + 1 
        - 1], &ierr_);
      }
      else if (lsvec_) {
        (void) _dlacpy (_dc_0, n_, n_, a_, lda_, u_, ldu_);
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          temp1_ = sva_[iwork_[p_ - 1] - 1];
          (void) _dscal (&p_, ($23_ = 1.0 / temp1_, &$23_), &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
        }
        (void) _dpocon (_dc_0, n_, u_, ldu_, ($24_ = 1.0, &$24_), &temp1_, &work_[(*n_) + 1 - 1], &iwork_[2 * (*n_) + (*m_) + 1 
        - 1], &ierr_);
      }
      else {
        (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[(*n_) + 1 - 1], n_);
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          temp1_ = sva_[iwork_[p_ - 1] - 1];
          (void) _dscal (&p_, ($25_ = 1.0 / temp1_, &$25_), &work_[(*n_) + (p_ - 1) * (*n_) + 1 - 1], &_k1);
        }
        (void) _dpocon (_dc_0, n_, &work_[(*n_) + 1 - 1], n_, ($26_ = 1.0, &$26_), &temp1_, &work_[(*n_) + (*n_) * (*n_) + 1 - 
        1], &iwork_[2 * (*n_) + (*m_) + 1 - 1], &ierr_);
      }
      sconda_ = 1.0 / sqrt (temp1_);
    }
    else {
      sconda_ = -1.0;
    }
  }
  l2pert_ = l2pert_ && (_abs (a_[0 + ((*lda_)) * ((0))] / a_[nr_ - 1 + ((*lda_)) * ((nr_ - 1))]) > sqrt (big1_));
  if (! ((rsvec_ || lsvec_))) {
    for (p_ = 1; p_ <= _min ((*n_) - 1, nr_); (p_)++) {
      (void) _dcopy (($27_ = (*n_) - p_, &$27_), &a_[p_ - 1 + ((*lda_)) * ((p_ + 1 - 1))], lda_, &a_[p_ + 1 - 1 + ((*lda_)) * 
      ((p_ - 1))], &_k1);
    }
    if (! (almort_)) {
      if (l2pert_) {
        xsc_ = epsln_ / (real_8) ((*n_));
        for (q_ = 1; q_ <= nr_; (q_)++) {
          temp1_ = xsc_ * _abs (a_[q_ - 1 + ((*lda_)) * ((q_ - 1))]);
          for (p_ = 1; p_ <= (*n_); (p_)++) {
            if (((p_ > q_) && (_abs (a_[p_ - 1 + ((*lda_)) * ((q_ - 1))]) <= temp1_)) || (p_ < q_)) {
              a_[p_ - 1 + ((*lda_)) * ((q_ - 1))] = _sign (temp1_, a_[p_ - 1 + ((*lda_)) * ((q_ - 1))]);
            }
          }
        }
      }
      else {
        (void) _dlaset (_dc_0, ($28_ = nr_ - 1, &$28_), ($29_ = nr_ - 1, &$29_), ($30_ = 0.0, &$30_), ($31_ = 0.0, &$31_), 
        &a_[0 + ((*lda_)) * ((1))], lda_);
      }
      (void) _dgeqrf (n_, &nr_, a_, lda_, work_, &work_[(*n_) + 1 - 1], ($32_ = (*lwork_) - (*n_), &$32_), &ierr_);
      for (p_ = 1; p_ <= nr_ - 1; (p_)++) {
        (void) _dcopy (($33_ = nr_ - p_, &$33_), &a_[p_ - 1 + ((*lda_)) * ((p_ + 1 - 1))], lda_, &a_[p_ + 1 - 1 + ((*lda_)) * 
        ((p_ - 1))], &_k1);
      }
    }
    if (l2pert_) {
      xsc_ = epsln_ / (real_8) ((*n_));
      for (q_ = 1; q_ <= nr_; (q_)++) {
        temp1_ = xsc_ * _abs (a_[q_ - 1 + ((*lda_)) * ((q_ - 1))]);
        for (p_ = 1; p_ <= nr_; (p_)++) {
          if (((p_ > q_) && (_abs (a_[p_ - 1 + ((*lda_)) * ((q_ - 1))]) <= temp1_)) || (p_ < q_)) {
            a_[p_ - 1 + ((*lda_)) * ((q_ - 1))] = _sign (temp1_, a_[p_ - 1 + ((*lda_)) * ((q_ - 1))]);
          }
        }
      }
    }
    else {
      (void) _dlaset (_dc_0, ($34_ = nr_ - 1, &$34_), ($35_ = nr_ - 1, &$35_), ($36_ = 0.0, &$36_), ($37_ = 0.0, &$37_), 
      &a_[0 + ((*lda_)) * ((1))], lda_);
    }
    (void) _dgesvj (_dc_1, _dc_31, _dc_32, &nr_, &nr_, a_, lda_, sva_, n_, v_, ldv_, work_, lwork_, info_);
    scalem_ = work_[0];
    numrank_ = _nintd (work_[1]);
  }
  else if (rsvec_ && (! (lsvec_))) {
    if (almort_) {
      for (p_ = 1; p_ <= nr_; (p_)++) {
        (void) _dcopy (($38_ = (*n_) - p_ + 1, &$38_), &a_[p_ - 1 + ((*lda_)) * ((p_ - 1))], lda_, &v_[p_ - 1 + ((*ldv_)) * 
        ((p_ - 1))], &_k1);
      }
      (void) _dlaset (_dc_33, ($39_ = nr_ - 1, &$39_), ($40_ = nr_ - 1, &$40_), ($41_ = 0.0, &$41_), ($42_ = 0.0, &$42_), 
      &v_[0 + ((*ldv_)) * ((1))], ldv_);
      (void) _dgesvj (_dc_1, _dc_0, _dc_2, n_, &nr_, v_, ldv_, sva_, &nr_, a_, lda_, work_, lwork_, info_);
      scalem_ = work_[0];
      numrank_ = _nintd (work_[1]);
    }
    else {
      (void) _dlaset (_dc_34, ($43_ = nr_ - 1, &$43_), ($44_ = nr_ - 1, &$44_), ($45_ = 0.0, &$45_), ($46_ = 0.0, &$46_), 
      &a_[1 + ((*lda_)) * ((0))], lda_);
      (void) _dgelqf (&nr_, n_, a_, lda_, work_, &work_[(*n_) + 1 - 1], ($47_ = (*lwork_) - (*n_), &$47_), &ierr_);
      (void) _dlacpy (_dc_34, &nr_, &nr_, a_, lda_, v_, ldv_);
      (void) _dlaset (_dc_33, ($48_ = nr_ - 1, &$48_), ($49_ = nr_ - 1, &$49_), ($50_ = 0.0, &$50_), ($51_ = 0.0, &$51_), 
      &v_[0 + ((*ldv_)) * ((1))], ldv_);
      (void) _dgeqrf (&nr_, &nr_, v_, ldv_, &work_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 1], ($52_ = (*lwork_) - 2 * (*n_), 
      &$52_), &ierr_);
      for (p_ = 1; p_ <= nr_; (p_)++) {
        (void) _dcopy (($53_ = nr_ - p_ + 1, &$53_), &v_[p_ - 1 + ((*ldv_)) * ((p_ - 1))], ldv_, &v_[p_ - 1 + ((*ldv_)) * ((p_ 
        - 1))], &_k1);
      }
      (void) _dlaset (_dc_33, ($54_ = nr_ - 1, &$54_), ($55_ = nr_ - 1, &$55_), ($56_ = 0.0, &$56_), ($57_ = 0.0, &$57_), 
      &v_[0 + ((*ldv_)) * ((1))], ldv_);
      (void) _dgesvj (_dc_34, _dc_0, _dc_2, &nr_, &nr_, v_, ldv_, sva_, &nr_, u_, ldu_, &work_[(*n_) + 1 - 1], lwork_, info_)
      ;
      scalem_ = work_[(*n_) + 1 - 1];
      numrank_ = _nintd (work_[(*n_) + 2 - 1]);
      if (nr_ < (*n_)) {
        (void) _dlaset (_dc_7, ($58_ = (*n_) - nr_, &$58_), &nr_, ($59_ = 0.0, &$59_), ($60_ = 0.0, &$60_), &v_[nr_ + 1 - 1 + 
        ((*ldv_)) * ((0))], ldv_);
        (void) _dlaset (_dc_7, &nr_, ($61_ = (*n_) - nr_, &$61_), ($62_ = 0.0, &$62_), ($63_ = 0.0, &$63_), &v_[0 + ((*ldv_)) * 
        ((nr_ + 1 - 1))], ldv_);
        (void) _dlaset (_dc_7, ($64_ = (*n_) - nr_, &$64_), ($65_ = (*n_) - nr_, &$65_), ($66_ = 0.0, &$66_), ($67_ = 1.0, 
        &$67_), &v_[nr_ + 1 - 1 + ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
      }
      (void) _dormlq (_dc_18, _dc_22, n_, n_, &nr_, a_, lda_, work_, v_, ldv_, &work_[(*n_) + 1 - 1], ($68_ = (*lwork_) - 
      (*n_), &$68_), &ierr_);
    }
    for (p_ = 1; p_ <= (*n_); (p_)++) {
      (void) _dcopy (n_, &v_[p_ - 1 + ((*ldv_)) * ((0))], ldv_, &a_[iwork_[p_ - 1] - 1 + ((*lda_)) * ((0))], lda_);
    }
    (void) _dlacpy (_dc_35, n_, n_, a_, lda_, v_, ldv_);
    if (transp_) {
      (void) _dlacpy (_dc_35, n_, n_, v_, ldv_, u_, ldu_);
    }
  }
  else if (lsvec_ && (! (rsvec_))) {
    for (p_ = 1; p_ <= nr_; (p_)++) {
      (void) _dcopy (($69_ = (*n_) - p_ + 1, &$69_), &a_[p_ - 1 + ((*lda_)) * ((p_ - 1))], lda_, &u_[p_ - 1 + ((*ldu_)) * 
      ((p_ - 1))], &_k1);
    }
    (void) _dlaset (_dc_33, ($70_ = nr_ - 1, &$70_), ($71_ = nr_ - 1, &$71_), ($72_ = 0.0, &$72_), ($73_ = 0.0, &$73_), 
    &u_[0 + ((*ldu_)) * ((1))], ldu_);
    (void) _dgeqrf (n_, &nr_, u_, ldu_, &work_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 1], ($74_ = (*lwork_) - 2 * (*n_), 
    &$74_), &ierr_);
    for (p_ = 1; p_ <= nr_ - 1; (p_)++) {
      (void) _dcopy (($75_ = nr_ - p_, &$75_), &u_[p_ - 1 + ((*ldu_)) * ((p_ + 1 - 1))], ldu_, &u_[p_ + 1 - 1 + ((*ldu_)) * 
      ((p_ - 1))], &_k1);
    }
    (void) _dlaset (_dc_33, ($76_ = nr_ - 1, &$76_), ($77_ = nr_ - 1, &$77_), ($78_ = 0.0, &$78_), ($79_ = 0.0, &$79_), 
    &u_[0 + ((*ldu_)) * ((1))], ldu_);
    (void) _dgesvj (_dc_34, _dc_0, _dc_2, &nr_, &nr_, u_, ldu_, sva_, &nr_, a_, lda_, &work_[(*n_) + 1 - 1], ($80_ = 
    (*lwork_) - (*n_), &$80_), info_);
    scalem_ = work_[(*n_) + 1 - 1];
    numrank_ = _nintd (work_[(*n_) + 2 - 1]);
    if (nr_ < (*m_)) {
      (void) _dlaset (_dc_7, ($81_ = (*m_) - nr_, &$81_), &nr_, ($82_ = 0.0, &$82_), ($83_ = 0.0, &$83_), &u_[nr_ + 1 - 1 + 
      ((*ldu_)) * ((0))], ldu_);
      if (nr_ < n1_) {
        (void) _dlaset (_dc_7, &nr_, ($84_ = n1_ - nr_, &$84_), ($85_ = 0.0, &$85_), ($86_ = 0.0, &$86_), &u_[0 + ((*ldu_)) * 
        ((nr_ + 1 - 1))], ldu_);
        (void) _dlaset (_dc_7, ($87_ = (*m_) - nr_, &$87_), ($88_ = n1_ - nr_, &$88_), ($89_ = 0.0, &$89_), ($90_ = 1.0, 
        &$90_), &u_[nr_ + 1 - 1 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
      }
    }
    (void) _dormqr (_dc_18, _dc_36, m_, &n1_, n_, a_, lda_, work_, u_, ldu_, &work_[(*n_) + 1 - 1], ($91_ = (*lwork_) - 
    (*n_), &$91_), &ierr_);
    if (rowpiv_) {
      (void) _dlaswp (&n1_, u_, ldu_, &_k1, ($92_ = (*m_) - 1, &$92_), &iwork_[2 * (*n_) + 1 - 1], &_km1);
    }
    for (p_ = 1; p_ <= n1_; (p_)++) {
      xsc_ = 1.0 / _dnrm2 (m_, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
      (void) _dscal (m_, &xsc_, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
    }
    if (transp_) {
      (void) _dlacpy (_dc_35, n_, n_, u_, ldu_, v_, ldv_);
    }
  }
  else {
    if (! (jracc_)) {
      if (! (almort_)) {
        for (p_ = 1; p_ <= nr_; (p_)++) {
          (void) _dcopy (($93_ = (*n_) - p_ + 1, &$93_), &a_[p_ - 1 + ((*lda_)) * ((p_ - 1))], lda_, &v_[p_ - 1 + ((*ldv_)) * 
          ((p_ - 1))], &_k1);
        }
        if (l2pert_) {
          xsc_ = sqrt (small_);
          for (q_ = 1; q_ <= nr_; (q_)++) {
            temp1_ = xsc_ * _abs (v_[q_ - 1 + ((*ldv_)) * ((q_ - 1))]);
            for (p_ = 1; p_ <= (*n_); (p_)++) {
              if ((p_ > q_) && (_abs (v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))]) <= temp1_) || (p_ < q_)) {
                v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = _sign (temp1_, v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))]);
              }
              if (p_ < q_) {
                v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = -v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))];
              }
            }
          }
        }
        else {
          (void) _dlaset (_dc_0, ($94_ = nr_ - 1, &$94_), ($95_ = nr_ - 1, &$95_), ($96_ = 0.0, &$96_), ($97_ = 0.0, &$97_), 
          &v_[0 + ((*ldv_)) * ((1))], ldv_);
        }
        (void) _dlacpy (_dc_1, &nr_, &nr_, v_, ldv_, &work_[2 * (*n_) + 1 - 1], &nr_);
        for (p_ = 1; p_ <= nr_; (p_)++) {
          temp1_ = _dnrm2 (($98_ = nr_ - p_ + 1, &$98_), &work_[2 * (*n_) + (p_ - 1) * nr_ + p_ - 1], &_k1);
          (void) _dscal (($99_ = nr_ - p_ + 1, &$99_), ($100_ = 1.0 / temp1_, &$100_), &work_[2 * (*n_) + (p_ - 1) * nr_ + p_ - 
          1], &_k1);
        }
        (void) _dpocon (_dc_34, &nr_, &work_[2 * (*n_) + 1 - 1], &nr_, ($101_ = 1.0, &$101_), &temp1_, &work_[2 * (*n_) + nr_ * 
        nr_ + 1 - 1], &iwork_[(*m_) + 2 * (*n_) + 1 - 1], &ierr_);
        condr1_ = 1.0 / sqrt (temp1_);
        cond_ok_ = sqrt ((real_8) (nr_));
        if (condr1_ < cond_ok_) {
          (void) _dgeqrf (n_, &nr_, v_, ldv_, &work_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 1], ($102_ = (*lwork_) - 2 * (*n_), 
          &$102_), &ierr_);
          if (l2pert_) {
            xsc_ = sqrt (small_) / epsln_;
            for (p_ = 2; p_ <= nr_; (p_)++) {
              for (q_ = 1; q_ <= p_ - 1; (q_)++) {
                temp1_ = xsc_ * _min (_abs (v_[p_ - 1 + ((*ldv_)) * ((p_ - 1))]), _abs (v_[q_ - 1 + ((*ldv_)) * ((q_ - 1))]));
                if (_abs (v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))]) <= temp1_) {
                  v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = _sign (temp1_, v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))]);
                }
              }
            }
          }
          if (nr_ != (*n_)) {
            (void) _dlacpy (_dc_7, n_, &nr_, v_, ldv_, &work_[2 * (*n_) + 1 - 1], n_);
          }
          for (p_ = 1; p_ <= nr_ - 1; (p_)++) {
            (void) _dcopy (($103_ = nr_ - p_, &$103_), &v_[p_ - 1 + ((*ldv_)) * ((p_ + 1 - 1))], ldv_, &v_[p_ + 1 - 1 + ((*ldv_)) * 
            ((p_ - 1))], &_k1);
          }
          condr2_ = condr1_;
        }
        else {
          for (p_ = 1; p_ <= nr_; (p_)++) {
            iwork_[(*n_) + p_ - 1] = 0;
          }
          (void) _dgeqp3 (n_, &nr_, v_, ldv_, &iwork_[(*n_) + 1 - 1], &work_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 1], ($104_ = 
          (*lwork_) - 2 * (*n_), &$104_), &ierr_);
          if (l2pert_) {
            xsc_ = sqrt (small_);
            for (p_ = 2; p_ <= nr_; (p_)++) {
              for (q_ = 1; q_ <= p_ - 1; (q_)++) {
                temp1_ = xsc_ * _min (_abs (v_[p_ - 1 + ((*ldv_)) * ((p_ - 1))]), _abs (v_[q_ - 1 + ((*ldv_)) * ((q_ - 1))]));
                if (_abs (v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))]) <= temp1_) {
                  v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = _sign (temp1_, v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))]);
                }
              }
            }
          }
          (void) _dlacpy (_dc_7, n_, &nr_, v_, ldv_, &work_[2 * (*n_) + 1 - 1], n_);
          if (l2pert_) {
            xsc_ = sqrt (small_);
            for (p_ = 2; p_ <= nr_; (p_)++) {
              for (q_ = 1; q_ <= p_ - 1; (q_)++) {
                temp1_ = xsc_ * _min (_abs (v_[p_ - 1 + ((*ldv_)) * ((p_ - 1))]), _abs (v_[q_ - 1 + ((*ldv_)) * ((q_ - 1))]));
                v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = -_sign (temp1_, v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))]);
              }
            }
          }
          else {
            (void) _dlaset (_dc_1, ($105_ = nr_ - 1, &$105_), ($106_ = nr_ - 1, &$106_), ($107_ = 0.0, &$107_), ($108_ = 0.0, 
            &$108_), &v_[1 + ((*ldv_)) * ((0))], ldv_);
          }
          (void) _dgelqf (&nr_, &nr_, v_, ldv_, &work_[2 * (*n_) + (*n_) * nr_ + 1 - 1], &work_[2 * (*n_) + (*n_) * nr_ + nr_ + 1 
          - 1], ($109_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, &$109_), &ierr_);
          (void) _dlacpy (_dc_1, &nr_, &nr_, v_, ldv_, &work_[2 * (*n_) + (*n_) * nr_ + nr_ + 1 - 1], &nr_);
          for (p_ = 1; p_ <= nr_; (p_)++) {
            temp1_ = _dnrm2 (&p_, &work_[2 * (*n_) + (*n_) * nr_ + nr_ + p_ - 1], &nr_);
            (void) _dscal (&p_, ($110_ = 1.0 / temp1_, &$110_), &work_[2 * (*n_) + (*n_) * nr_ + nr_ + p_ - 1], &nr_);
          }
          (void) _dpocon (_dc_1, &nr_, &work_[2 * (*n_) + (*n_) * nr_ + nr_ + 1 - 1], &nr_, ($111_ = 1.0, &$111_), &temp1_, 
          &work_[2 * (*n_) + (*n_) * nr_ + nr_ + nr_ * nr_ + 1 - 1], &iwork_[(*m_) + 2 * (*n_) + 1 - 1], &ierr_);
          condr2_ = 1.0 / sqrt (temp1_);
          if (condr2_ >= cond_ok_) {
            (void) _dlacpy (_dc_0, &nr_, &nr_, v_, ldv_, &work_[2 * (*n_) + 1 - 1], n_);
          }
        }
        if (l2pert_) {
          xsc_ = sqrt (small_);
          for (q_ = 2; q_ <= nr_; (q_)++) {
            temp1_ = xsc_ * v_[q_ - 1 + ((*ldv_)) * ((q_ - 1))];
            for (p_ = 1; p_ <= q_ - 1; (p_)++) {
              v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = -_sign (temp1_, v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))]);
            }
          }
        }
        else {
          (void) _dlaset (_dc_0, ($112_ = nr_ - 1, &$112_), ($113_ = nr_ - 1, &$113_), ($114_ = 0.0, &$114_), ($115_ = 0.0, 
          &$115_), &v_[0 + ((*ldv_)) * ((1))], ldv_);
        }
        if (condr1_ < cond_ok_) {
          (void) _dgesvj (_dc_1, _dc_0, _dc_2, &nr_, &nr_, v_, ldv_, sva_, &nr_, u_, ldu_, &work_[2 * (*n_) + (*n_) * nr_ + nr_ + 
          1 - 1], ($116_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, &$116_), info_);
          scalem_ = work_[2 * (*n_) + (*n_) * nr_ + nr_ + 1 - 1];
          numrank_ = _nintd (work_[2 * (*n_) + (*n_) * nr_ + nr_ + 2 - 1]);
          for (p_ = 1; p_ <= nr_; (p_)++) {
            (void) _dcopy (&nr_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
            (void) _dscal (&nr_, &sva_[p_ - 1], &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
          }
          if (nr_ == (*n_)) {
            (void) _dtrsm (_dc_1, _dc_0, _dc_2, _dc_2, &nr_, &nr_, ($117_ = 1.0, &$117_), a_, lda_, v_, ldv_);
          }
          else {
            (void) _dtrsm (_dc_1, _dc_0, _dc_25, _dc_2, &nr_, &nr_, ($118_ = 1.0, &$118_), &work_[2 * (*n_) + 1 - 1], n_, v_, ldv_)
            ;
            if (nr_ < (*n_)) {
              (void) _dlaset (_dc_7, ($119_ = (*n_) - nr_, &$119_), &nr_, ($120_ = 0.0, &$120_), ($121_ = 0.0, &$121_), &v_[nr_ + 1 - 
              1 + ((*ldv_)) * ((0))], ldv_);
              (void) _dlaset (_dc_7, &nr_, ($122_ = (*n_) - nr_, &$122_), ($123_ = 0.0, &$123_), ($124_ = 0.0, &$124_), &v_[0 + 
              ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
              (void) _dlaset (_dc_7, ($125_ = (*n_) - nr_, &$125_), ($126_ = (*n_) - nr_, &$126_), ($127_ = 0.0, &$127_), ($128_ = 
              1.0, &$128_), &v_[nr_ + 1 - 1 + ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
            }
            (void) _dormqr (_dc_1, _dc_2, n_, n_, &nr_, &work_[2 * (*n_) + 1 - 1], n_, &work_[(*n_) + 1 - 1], v_, ldv_, &work_[2 * 
            (*n_) + (*n_) * nr_ + nr_ + 1 - 1], ($129_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, &$129_), &ierr_);
          }
        }
        else if (condr2_ < cond_ok_) {
          (void) _dgesvj (_dc_1, _dc_0, _dc_2, &nr_, &nr_, v_, ldv_, sva_, &nr_, u_, ldu_, &work_[2 * (*n_) + (*n_) * nr_ + nr_ + 
          1 - 1], ($130_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, &$130_), info_);
          scalem_ = work_[2 * (*n_) + (*n_) * nr_ + nr_ + 1 - 1];
          numrank_ = _nintd (work_[2 * (*n_) + (*n_) * nr_ + nr_ + 2 - 1]);
          for (p_ = 1; p_ <= nr_; (p_)++) {
            (void) _dcopy (&nr_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
            (void) _dscal (&nr_, &sva_[p_ - 1], &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
          }
          (void) _dtrsm (_dc_1, _dc_0, _dc_2, _dc_2, &nr_, &nr_, ($131_ = 1.0, &$131_), &work_[2 * (*n_) + 1 - 1], n_, u_, ldu_)
          ;
          for (q_ = 1; q_ <= nr_; (q_)++) {
            for (p_ = 1; p_ <= nr_; (p_)++) {
              work_[2 * (*n_) + (*n_) * nr_ + nr_ + iwork_[(*n_) + p_ - 1] - 1] = u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))];
            }
            for (p_ = 1; p_ <= nr_; (p_)++) {
              u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))] = work_[2 * (*n_) + (*n_) * nr_ + nr_ + p_ - 1];
            }
          }
          if (nr_ < (*n_)) {
            (void) _dlaset (_dc_7, ($132_ = (*n_) - nr_, &$132_), &nr_, ($133_ = 0.0, &$133_), ($134_ = 0.0, &$134_), &v_[nr_ + 1 - 
            1 + ((*ldv_)) * ((0))], ldv_);
            (void) _dlaset (_dc_7, &nr_, ($135_ = (*n_) - nr_, &$135_), ($136_ = 0.0, &$136_), ($137_ = 0.0, &$137_), &v_[0 + 
            ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
            (void) _dlaset (_dc_7, ($138_ = (*n_) - nr_, &$138_), ($139_ = (*n_) - nr_, &$139_), ($140_ = 0.0, &$140_), ($141_ = 
            1.0, &$141_), &v_[nr_ + 1 - 1 + ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
          }
          (void) _dormqr (_dc_1, _dc_2, n_, n_, &nr_, &work_[2 * (*n_) + 1 - 1], n_, &work_[(*n_) + 1 - 1], v_, ldv_, &work_[2 * 
          (*n_) + (*n_) * nr_ + nr_ + 1 - 1], ($142_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, &$142_), &ierr_);
        }
        else {
          (void) _dgesvj (_dc_1, _dc_0, _dc_11, &nr_, &nr_, v_, ldv_, sva_, &nr_, u_, ldu_, &work_[2 * (*n_) + (*n_) * nr_ + nr_ 
          + 1 - 1], ($143_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, &$143_), info_);
          scalem_ = work_[2 * (*n_) + (*n_) * nr_ + nr_ + 1 - 1];
          numrank_ = _nintd (work_[2 * (*n_) + (*n_) * nr_ + nr_ + 2 - 1]);
          if (nr_ < (*n_)) {
            (void) _dlaset (_dc_7, ($144_ = (*n_) - nr_, &$144_), &nr_, ($145_ = 0.0, &$145_), ($146_ = 0.0, &$146_), &v_[nr_ + 1 - 
            1 + ((*ldv_)) * ((0))], ldv_);
            (void) _dlaset (_dc_7, &nr_, ($147_ = (*n_) - nr_, &$147_), ($148_ = 0.0, &$148_), ($149_ = 0.0, &$149_), &v_[0 + 
            ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
            (void) _dlaset (_dc_7, ($150_ = (*n_) - nr_, &$150_), ($151_ = (*n_) - nr_, &$151_), ($152_ = 0.0, &$152_), ($153_ = 
            1.0, &$153_), &v_[nr_ + 1 - 1 + ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
          }
          (void) _dormqr (_dc_1, _dc_2, n_, n_, &nr_, &work_[2 * (*n_) + 1 - 1], n_, &work_[(*n_) + 1 - 1], v_, ldv_, &work_[2 * 
          (*n_) + (*n_) * nr_ + nr_ + 1 - 1], ($154_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, &$154_), &ierr_);
          (void) _dormlq (_dc_1, _dc_25, &nr_, &nr_, &nr_, &work_[2 * (*n_) + 1 - 1], n_, &work_[2 * (*n_) + (*n_) * nr_ + 1 - 
          1], u_, ldu_, &work_[2 * (*n_) + (*n_) * nr_ + nr_ + 1 - 1], ($155_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, 
          &$155_), &ierr_);
          for (q_ = 1; q_ <= nr_; (q_)++) {
            for (p_ = 1; p_ <= nr_; (p_)++) {
              work_[2 * (*n_) + (*n_) * nr_ + nr_ + iwork_[(*n_) + p_ - 1] - 1] = u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))];
            }
            for (p_ = 1; p_ <= nr_; (p_)++) {
              u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))] = work_[2 * (*n_) + (*n_) * nr_ + nr_ + p_ - 1];
            }
          }
        }
        temp1_ = sqrt ((real_8) ((*n_))) * epsln_;
        for (q_ = 1; q_ <= (*n_); (q_)++) {
          for (p_ = 1; p_ <= (*n_); (p_)++) {
            work_[2 * (*n_) + (*n_) * nr_ + nr_ + iwork_[p_ - 1] - 1] = v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))];
          }
          for (p_ = 1; p_ <= (*n_); (p_)++) {
            v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = work_[2 * (*n_) + (*n_) * nr_ + nr_ + p_ - 1];
          }
          xsc_ = 1.0 / _dnrm2 (n_, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
          if ((xsc_ < (1.0 - temp1_)) || (xsc_ > (1.0 + temp1_))) {
            (void) _dscal (n_, &xsc_, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
          }
        }
        if (nr_ < (*m_)) {
          (void) _dlaset (_dc_7, ($156_ = (*m_) - nr_, &$156_), &nr_, ($157_ = 0.0, &$157_), ($158_ = 0.0, &$158_), &u_[nr_ + 1 - 
          1 + ((*ldu_)) * ((0))], ldu_);
          if (nr_ < n1_) {
            (void) _dlaset (_dc_7, &nr_, ($159_ = n1_ - nr_, &$159_), ($160_ = 0.0, &$160_), ($161_ = 0.0, &$161_), &u_[0 + 
            ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
            (void) _dlaset (_dc_7, ($162_ = (*m_) - nr_, &$162_), ($163_ = n1_ - nr_, &$163_), ($164_ = 0.0, &$164_), ($165_ = 1.0, 
            &$165_), &u_[nr_ + 1 - 1 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
          }
        }
        (void) _dormqr (_dc_18, _dc_37, m_, &n1_, n_, a_, lda_, work_, u_, ldu_, &work_[(*n_) + 1 - 1], ($166_ = (*lwork_) - 
        (*n_), &$166_), &ierr_);
        temp1_ = sqrt ((real_8) ((*m_))) * epsln_;
        for (p_ = 1; p_ <= nr_; (p_)++) {
          xsc_ = 1.0 / _dnrm2 (m_, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
          if ((xsc_ < (1.0 - temp1_)) || (xsc_ > (1.0 + temp1_))) {
            (void) _dscal (m_, &xsc_, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
          }
        }
        if (rowpiv_) {
          (void) _dlaswp (&n1_, u_, ldu_, &_k1, ($167_ = (*m_) - 1, &$167_), &iwork_[2 * (*n_) + 1 - 1], &_km1);
        }
      }
      else {
        (void) _dlacpy (_dc_33, n_, n_, a_, lda_, &work_[(*n_) + 1 - 1], n_);
        if (l2pert_) {
          xsc_ = sqrt (small_);
          for (p_ = 2; p_ <= (*n_); (p_)++) {
            temp1_ = xsc_ * work_[(*n_) + (p_ - 1) * (*n_) + p_ - 1];
            for (q_ = 1; q_ <= p_ - 1; (q_)++) {
              work_[(*n_) + (q_ - 1) * (*n_) + p_ - 1] = -_sign (temp1_, work_[(*n_) + (p_ - 1) * (*n_) + q_ - 1]);
            }
          }
        }
        else {
          (void) _dlaset (_dc_34, ($168_ = (*n_) - 1, &$168_), ($169_ = (*n_) - 1, &$169_), ($170_ = 0.0, &$170_), ($171_ = 0.0, 
          &$171_), &work_[(*n_) + 2 - 1], n_);
        }
        (void) _dgesvj (_dc_33, _dc_0, _dc_2, n_, n_, &work_[(*n_) + 1 - 1], n_, sva_, n_, u_, ldu_, &work_[(*n_) + (*n_) * 
        (*n_) + 1 - 1], ($172_ = (*lwork_) - (*n_) - (*n_) * (*n_), &$172_), info_);
        scalem_ = work_[(*n_) + (*n_) * (*n_) + 1 - 1];
        numrank_ = _nintd (work_[(*n_) + (*n_) * (*n_) + 2 - 1]);
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          (void) _dcopy (n_, &work_[(*n_) + (p_ - 1) * (*n_) + 1 - 1], &_k1, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
          (void) _dscal (n_, &sva_[p_ - 1], &work_[(*n_) + (p_ - 1) * (*n_) + 1 - 1], &_k1);
        }
        (void) _dtrsm (_dc_18, _dc_33, _dc_38, _dc_39, n_, n_, ($173_ = 1.0, &$173_), a_, lda_, &work_[(*n_) + 1 - 1], n_);
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          (void) _dcopy (n_, &work_[(*n_) + p_ - 1], n_, &v_[iwork_[p_ - 1] - 1 + ((*ldv_)) * ((0))], ldv_);
        }
        temp1_ = sqrt ((real_8) ((*n_))) * epsln_;
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          xsc_ = 1.0 / _dnrm2 (n_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
          if ((xsc_ < (1.0 - temp1_)) || (xsc_ > (1.0 + temp1_))) {
            (void) _dscal (n_, &xsc_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
          }
        }
        if ((*n_) < (*m_)) {
          (void) _dlaset (_dc_7, ($174_ = (*m_) - (*n_), &$174_), n_, ($175_ = 0.0, &$175_), ($176_ = 0.0, &$176_), &u_[(*n_) + 1 
          - 1 + ((*ldu_)) * ((0))], ldu_);
          if ((*n_) < n1_) {
            (void) _dlaset (_dc_7, n_, ($177_ = n1_ - (*n_), &$177_), ($178_ = 0.0, &$178_), ($179_ = 0.0, &$179_), &u_[0 + 
            ((*ldu_)) * (((*n_) + 1 - 1))], ldu_);
            (void) _dlaset (_dc_7, ($180_ = (*m_) - (*n_), &$180_), ($181_ = n1_ - (*n_), &$181_), ($182_ = 0.0, &$182_), ($183_ = 
            1.0, &$183_), &u_[(*n_) + 1 - 1 + ((*ldu_)) * (((*n_) + 1 - 1))], ldu_);
          }
        }
        (void) _dormqr (_dc_18, _dc_36, m_, &n1_, n_, a_, lda_, work_, u_, ldu_, &work_[(*n_) + 1 - 1], ($184_ = (*lwork_) - 
        (*n_), &$184_), &ierr_);
        temp1_ = sqrt ((real_8) ((*m_))) * epsln_;
        for (p_ = 1; p_ <= n1_; (p_)++) {
          xsc_ = 1.0 / _dnrm2 (m_, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
          if ((xsc_ < (1.0 - temp1_)) || (xsc_ > (1.0 + temp1_))) {
            (void) _dscal (m_, &xsc_, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1);
          }
        }
        if (rowpiv_) {
          (void) _dlaswp (&n1_, u_, ldu_, &_k1, ($185_ = (*m_) - 1, &$185_), &iwork_[2 * (*n_) + 1 - 1], &_km1);
        }
      }
    }
    else {
      for (p_ = 1; p_ <= nr_; (p_)++) {
        (void) _dcopy (($186_ = (*n_) - p_ + 1, &$186_), &a_[p_ - 1 + ((*lda_)) * ((p_ - 1))], lda_, &v_[p_ - 1 + ((*ldv_)) * 
        ((p_ - 1))], &_k1);
      }
      if (l2pert_) {
        xsc_ = sqrt (small_ / epsln_);
        for (q_ = 1; q_ <= nr_; (q_)++) {
          temp1_ = xsc_ * _abs (v_[q_ - 1 + ((*ldv_)) * ((q_ - 1))]);
          for (p_ = 1; p_ <= (*n_); (p_)++) {
            if ((p_ > q_) && (_abs (v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))]) <= temp1_) || (p_ < q_)) {
              v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = _sign (temp1_, v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))]);
            }
            if (p_ < q_) {
              v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = -v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))];
            }
          }
        }
      }
      else {
        (void) _dlaset (_dc_0, ($187_ = nr_ - 1, &$187_), ($188_ = nr_ - 1, &$188_), ($189_ = 0.0, &$189_), ($190_ = 0.0, 
        &$190_), &v_[0 + ((*ldv_)) * ((1))], ldv_);
      }
      (void) _dgeqrf (n_, &nr_, v_, ldv_, &work_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 1], ($191_ = (*lwork_) - 2 * (*n_), 
      &$191_), &ierr_);
      (void) _dlacpy (_dc_1, n_, &nr_, v_, ldv_, &work_[2 * (*n_) + 1 - 1], n_);
      for (p_ = 1; p_ <= nr_; (p_)++) {
        (void) _dcopy (($192_ = nr_ - p_ + 1, &$192_), &v_[p_ - 1 + ((*ldv_)) * ((p_ - 1))], ldv_, &u_[p_ - 1 + ((*ldu_)) * 
        ((p_ - 1))], &_k1);
      }
      if (l2pert_) {
        xsc_ = sqrt (small_ / epsln_);
        for (q_ = 2; q_ <= nr_; (q_)++) {
          for (p_ = 1; p_ <= q_ - 1; (p_)++) {
            temp1_ = xsc_ * _min (_abs (u_[p_ - 1 + ((*ldu_)) * ((p_ - 1))]), _abs (u_[q_ - 1 + ((*ldu_)) * ((q_ - 1))]));
            u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))] = -_sign (temp1_, u_[q_ - 1 + ((*ldu_)) * ((p_ - 1))]);
          }
        }
      }
      else {
        (void) _dlaset (_dc_0, ($193_ = nr_ - 1, &$193_), ($194_ = nr_ - 1, &$194_), ($195_ = 0.0, &$195_), ($196_ = 0.0, 
        &$196_), &u_[0 + ((*ldu_)) * ((1))], ldu_);
      }
      (void) _dgesvj (_dc_9, _dc_0, _dc_11, &nr_, &nr_, u_, ldu_, sva_, n_, v_, ldv_, &work_[2 * (*n_) + (*n_) * nr_ + 1 - 
      1], ($197_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_, &$197_), info_);
      scalem_ = work_[2 * (*n_) + (*n_) * nr_ + 1 - 1];
      numrank_ = _nintd (work_[2 * (*n_) + (*n_) * nr_ + 2 - 1]);
      if (nr_ < (*n_)) {
        (void) _dlaset (_dc_7, ($198_ = (*n_) - nr_, &$198_), &nr_, ($199_ = 0.0, &$199_), ($200_ = 0.0, &$200_), &v_[nr_ + 1 - 
        1 + ((*ldv_)) * ((0))], ldv_);
        (void) _dlaset (_dc_7, &nr_, ($201_ = (*n_) - nr_, &$201_), ($202_ = 0.0, &$202_), ($203_ = 0.0, &$203_), &v_[0 + 
        ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
        (void) _dlaset (_dc_7, ($204_ = (*n_) - nr_, &$204_), ($205_ = (*n_) - nr_, &$205_), ($206_ = 0.0, &$206_), ($207_ = 
        1.0, &$207_), &v_[nr_ + 1 - 1 + ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
      }
      (void) _dormqr (_dc_1, _dc_2, n_, n_, &nr_, &work_[2 * (*n_) + 1 - 1], n_, &work_[(*n_) + 1 - 1], v_, ldv_, &work_[2 * 
      (*n_) + (*n_) * nr_ + nr_ + 1 - 1], ($208_ = (*lwork_) - 2 * (*n_) - (*n_) * nr_ - nr_, &$208_), &ierr_);
      temp1_ = sqrt ((real_8) ((*n_))) * epsln_;
      for (q_ = 1; q_ <= (*n_); (q_)++) {
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          work_[2 * (*n_) + (*n_) * nr_ + nr_ + iwork_[p_ - 1] - 1] = v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))];
        }
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = work_[2 * (*n_) + (*n_) * nr_ + nr_ + p_ - 1];
        }
        xsc_ = 1.0 / _dnrm2 (n_, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
        if ((xsc_ < (1.0 - temp1_)) || (xsc_ > (1.0 + temp1_))) {
          (void) _dscal (n_, &xsc_, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
        }
      }
      if (nr_ < (*m_)) {
        (void) _dlaset (_dc_7, ($209_ = (*m_) - nr_, &$209_), &nr_, ($210_ = 0.0, &$210_), ($211_ = 0.0, &$211_), &u_[nr_ + 1 - 
        1 + ((*ldu_)) * ((0))], ldu_);
        if (nr_ < n1_) {
          (void) _dlaset (_dc_7, &nr_, ($212_ = n1_ - nr_, &$212_), ($213_ = 0.0, &$213_), ($214_ = 0.0, &$214_), &u_[0 + 
          ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
          (void) _dlaset (_dc_7, ($215_ = (*m_) - nr_, &$215_), ($216_ = n1_ - nr_, &$216_), ($217_ = 0.0, &$217_), ($218_ = 1.0, 
          &$218_), &u_[nr_ + 1 - 1 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
        }
      }
      (void) _dormqr (_dc_18, _dc_36, m_, &n1_, n_, a_, lda_, work_, u_, ldu_, &work_[(*n_) + 1 - 1], ($219_ = (*lwork_) - 
      (*n_), &$219_), &ierr_);
      if (rowpiv_) {
        (void) _dlaswp (&n1_, u_, ldu_, &_k1, ($220_ = (*m_) - 1, &$220_), &iwork_[2 * (*n_) + 1 - 1], &_km1);
      }
    }
    if (transp_) {
      for (p_ = 1; p_ <= (*n_); (p_)++) {
        (void) _dswap (n_, &u_[0 + ((*ldu_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
      }
    }
  }
  if (uscal2_ <= (big_ / sva_[0]) * uscal1_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &uscal1_, &uscal2_, &nr_, &_k1, sva_, n_, &ierr_);
    uscal1_ = 1.0;
    uscal2_ = 1.0;
  }
  if (nr_ < (*n_)) {
    for (p_ = nr_ + 1; p_ <= (*n_); (p_)++) {
      sva_[p_ - 1] = 0.0;
    }
  }
  work_[0] = uscal2_ * scalem_;
  work_[1] = uscal1_;
  if (errest_) {
    work_[2] = sconda_;
  }
  if (lsvec_ && rsvec_) {
    work_[3] = condr1_;
    work_[4] = condr2_;
  }
  if (l2tran_) {
    work_[5] = entra_;
    work_[6] = entrat_;
  }
  iwork_[0] = nr_;
  iwork_[1] = numrank_;
  iwork_[2] = warning_;
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _dgelq2 (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ work_, int_4 _p_ 
info_)
{
  static int_4 i_, k_;
  static real_8 aii_;
  int_4 $0_, $1_, $2_, $3_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_40, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  k_ = _min ((*m_), (*n_));
  for (i_ = 1; i_ <= k_; (i_)++) {
    (void) _dlarfg (($1_ = (*n_) - i_ + 1, &$1_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[i_ - 1 + ((*lda_)) * ((_min (i_ 
    + 1, (*n_)) - 1))], lda_, &tau_[i_ - 1]);
    if (i_ < (*m_)) {
      aii_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
      (void) _dlarf (_dc_19, ($2_ = (*m_) - i_, &$2_), ($3_ = (*n_) - i_ + 1, &$3_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
      lda_, &tau_[i_ - 1], &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], lda_, work_);
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
    }
  }
  _l0:;
  __calls[6].calls++;
  return 0;
}

int_4 _dgelqf (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ work_, int_4 _p_ 
lwork_, int_4 _p_ info_)
{
  static int_4 i_, ib_, iinfo_, iws_, k_, ldwork_, lwkopt_, nb_, nbmin_, nx_;
  static logical_4 lquery_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  nb_ = _ilaenv (&_k1, _dc_41, _dc_6, m_, n_, &_km1, &_km1);
  lwkopt_ = (*m_) * nb_;
  work_[0] = lwkopt_;
  lquery_ = ((*lwork_) == -1);
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  else if ((*lwork_) < _max (1, (*m_)) && ! (lquery_)) {
    (*info_) = -7;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_41, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  k_ = _min ((*m_), (*n_));
  if (k_ == 0) {
    work_[0] = 1;
    goto _l0;
  }
  nbmin_ = 2;
  nx_ = 0;
  iws_ = (*m_);
  if (nb_ > 1 && nb_ < k_) {
    nx_ = _max (0, _ilaenv (($1_ = 3, &$1_), _dc_41, _dc_6, m_, n_, &_km1, &_km1));
    if (nx_ < k_) {
      ldwork_ = (*m_);
      iws_ = ldwork_ * nb_;
      if ((*lwork_) < iws_) {
        nb_ = (*lwork_) / ldwork_;
        nbmin_ = _max (2, _ilaenv (($2_ = 2, &$2_), _dc_41, _dc_6, m_, n_, &_km1, &_km1));
      }
    }
  }
  if (nb_ >= nbmin_ && nb_ < k_ && nx_ < k_) {
    for (i_ = 1; (nb_ > 0 ? i_ <= k_ - nx_ : i_ >= k_ - nx_); i_ += nb_) {
      ib_ = _min (k_ - i_ + 1, nb_);
      (void) _dgelq2 (&ib_, ($3_ = (*n_) - i_ + 1, &$3_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, &tau_[i_ - 1], work_, 
      &iinfo_);
      if (i_ + ib_ <= (*m_)) {
        (void) _dlarft (_dc_42, _dc_43, ($4_ = (*n_) - i_ + 1, &$4_), &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
        &tau_[i_ - 1], work_, &ldwork_);
        (void) _dlarfb (_dc_19, _dc_21, _dc_42, _dc_43, ($5_ = (*m_) - i_ - ib_ + 1, &$5_), ($6_ = (*n_) - i_ + 1, &$6_), &ib_, 
        &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, work_, &ldwork_, &a_[i_ + ib_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
        &work_[ib_ + 1 - 1], &ldwork_);
      }
    }
  }
  else {
    i_ = 1;
  }
  if (i_ <= k_) {
    (void) _dgelq2 (($7_ = (*m_) - i_ + 1, &$7_), ($8_ = (*n_) - i_ + 1, &$8_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
    &tau_[i_ - 1], work_, &iinfo_);
  }
  work_[0] = iws_;
  _l0:;
  __calls[7].calls++;
  return 0;
}

int_4 _dgelsd (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ 
ldb_, real_8 _p_ s_, real_8 _p_ rcond_, int_4 _p_ rank_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 
_p_ info_)
{
  static int_4 iascl_, ibscl_, ie_, il_, itau_, itaup_, itauq_, ldwork_, liwork_, maxmn_, maxwrk_, minmn_, minwrk_, mm_, 
  mnthr_, nlvl_, nwork_, smlsiz_, wlalsd_;
  static logical_4 lquery_;
  static real_8 anrm_, bignum_, bnrm_, eps_, sfmin_, smlnum_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $13_, $16_, $17_, $18_, $19_, $22_, $23_, $24_, $25_, $26_, $27_, 
  $28_, $29_, $30_, $33_, $34_, $35_, $36_, $39_, $40_, $41_, $42_;
  real_8 $9_, $10_, $11_, $12_, $14_, $15_, $20_, $21_, $31_, $32_, $37_, $38_;
  extern int_4 _xerbla ();
  extern real_8 _dlamch ();
  (*info_) = 0;
  minmn_ = _min ((*m_), (*n_));
  maxmn_ = _max ((*m_), (*n_));
  mnthr_ = _ilaenv (($0_ = 6, &$0_), _dc_44, _dc_6, m_, n_, nrhs_, &_km1);
  lquery_ = ((*lwork_) == -1);
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -5;
  }
  else if ((*ldb_) < _max (1, maxmn_)) {
    (*info_) = -7;
  }
  smlsiz_ = _ilaenv (($1_ = 9, &$1_), _dc_44, _dc_6, &_k0, &_k0, &_k0, &_k0);
  minwrk_ = 1;
  liwork_ = 1;
  minmn_ = _max (1, minmn_);
  nlvl_ = _max ((int_4) (_aintd (log ((real_8) (minmn_) / (real_8) (smlsiz_ + 1)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 1, 0);
  if ((*info_) == 0) {
    maxwrk_ = 0;
    liwork_ = 3 * minmn_ * nlvl_ + 11 * minmn_;
    mm_ = (*m_);
    if ((*m_) >= (*n_) && (*m_) >= mnthr_) {
      mm_ = (*n_);
      maxwrk_ = _max (maxwrk_, (*n_) + (*n_) * _ilaenv (&_k1, _dc_45, _dc_6, m_, n_, &_km1, &_km1));
      maxwrk_ = _max (maxwrk_, (*n_) + (*nrhs_) * _ilaenv (&_k1, _dc_46, _dc_47, m_, nrhs_, n_, &_km1));
    }
    if ((*m_) >= (*n_)) {
      maxwrk_ = _max (maxwrk_, 3 * (*n_) + (mm_ + (*n_)) * _ilaenv (&_k1, _dc_20, _dc_6, &mm_, n_, &_km1, &_km1));
      maxwrk_ = _max (maxwrk_, 3 * (*n_) + (*nrhs_) * _ilaenv (&_k1, _dc_48, _dc_49, &mm_, nrhs_, n_, &_km1));
      maxwrk_ = _max (maxwrk_, 3 * (*n_) + ((*n_) - 1) * _ilaenv (&_k1, _dc_48, _dc_50, n_, nrhs_, n_, &_km1));
      wlalsd_ = 9 * (*n_) + 2 * (*n_) * smlsiz_ + 8 * (*n_) * nlvl_ + (*n_) * (*nrhs_) + ($2_ = (smlsiz_ + 1), $2_ * $2_);
      maxwrk_ = _max (maxwrk_, 3 * (*n_) + wlalsd_);
      minwrk_ = ($3_ = _max (3 * (*n_) + mm_, 3 * (*n_) + (*nrhs_)), _max ($3_, 3 * (*n_) + wlalsd_));
    }
    if ((*n_) > (*m_)) {
      wlalsd_ = 9 * (*m_) + 2 * (*m_) * smlsiz_ + 8 * (*m_) * nlvl_ + (*m_) * (*nrhs_) + ($4_ = (smlsiz_ + 1), $4_ * $4_);
      if ((*n_) >= mnthr_) {
        maxwrk_ = (*m_) + (*m_) * _ilaenv (&_k1, _dc_41, _dc_6, m_, n_, &_km1, &_km1);
        maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 4 * (*m_) + 2 * (*m_) * _ilaenv (&_k1, _dc_20, _dc_6, m_, m_, &_km1, &_km1));
        maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 4 * (*m_) + (*nrhs_) * _ilaenv (&_k1, _dc_48, _dc_49, m_, nrhs_, m_, &_km1));
        maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 4 * (*m_) + ((*m_) - 1) * _ilaenv (&_k1, _dc_48, _dc_50, m_, nrhs_, m_, 
        &_km1));
        if ((*nrhs_) > 1) {
          maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + (*m_) + (*m_) * (*nrhs_));
        }
        else {
          maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 2 * (*m_));
        }
        maxwrk_ = _max (maxwrk_, (*m_) + (*nrhs_) * _ilaenv (&_k1, _dc_51, _dc_47, n_, nrhs_, m_, &_km1));
        maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 4 * (*m_) + wlalsd_);
        maxwrk_ = _max (maxwrk_, 4 * (*m_) + (*m_) * (*m_) + ($5_ = _max ((*m_), 2 * (*m_) - 4), $5_ = _max ($5_, (*nrhs_)), 
        _max ($5_, (*n_) - 3 * (*m_))));
      }
      else {
        maxwrk_ = 3 * (*m_) + ((*n_) + (*m_)) * _ilaenv (&_k1, _dc_20, _dc_6, m_, n_, &_km1, &_km1);
        maxwrk_ = _max (maxwrk_, 3 * (*m_) + (*nrhs_) * _ilaenv (&_k1, _dc_48, _dc_49, m_, nrhs_, n_, &_km1));
        maxwrk_ = _max (maxwrk_, 3 * (*m_) + (*m_) * _ilaenv (&_k1, _dc_48, _dc_50, n_, nrhs_, m_, &_km1));
        maxwrk_ = _max (maxwrk_, 3 * (*m_) + wlalsd_);
      }
      minwrk_ = ($6_ = _max (3 * (*m_) + (*nrhs_), 3 * (*m_) + (*m_)), _max ($6_, 3 * (*m_) + wlalsd_));
    }
    minwrk_ = _min (minwrk_, maxwrk_);
    work_[0] = maxwrk_;
    iwork_[0] = liwork_;
    if ((*lwork_) < minwrk_ && ! (lquery_)) {
      (*info_) = -12;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_44, ($7_ = -(*info_), &$7_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l10;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    (*rank_) = 0;
    goto _l0;
  }
  eps_ = _dlamch (_dc_3);
  sfmin_ = _dlamch (_dc_52);
  smlnum_ = sfmin_ / eps_;
  bignum_ = 1.0 / smlnum_;
  (void) _dlabad (&smlnum_, &bignum_);
  anrm_ = _dlange (_dc_8, m_, n_, a_, lda_, work_);
  iascl_ = 0;
  if (anrm_ > 0.0 && anrm_ < smlnum_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &smlnum_, m_, n_, a_, lda_, info_);
    iascl_ = 1;
  }
  else if (anrm_ > bignum_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &bignum_, m_, n_, a_, lda_, info_);
    iascl_ = 2;
  }
  else if (anrm_ == 0.0) {
    (void) _dlaset (_dc_16, ($8_ = _max ((*m_), (*n_)), &$8_), nrhs_, ($9_ = 0.0, &$9_), ($10_ = 0.0, &$10_), b_, ldb_);
    (void) _dlaset (_dc_16, &minmn_, &_k1, ($11_ = 0.0, &$11_), ($12_ = 0.0, &$12_), s_, &_k1);
    (*rank_) = 0;
    goto _l10;
  }
  bnrm_ = _dlange (_dc_8, m_, nrhs_, b_, ldb_, work_);
  ibscl_ = 0;
  if (bnrm_ > 0.0 && bnrm_ < smlnum_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &bnrm_, &smlnum_, m_, nrhs_, b_, ldb_, info_);
    ibscl_ = 1;
  }
  else if (bnrm_ > bignum_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &bnrm_, &bignum_, m_, nrhs_, b_, ldb_, info_);
    ibscl_ = 2;
  }
  if ((*m_) < (*n_)) {
    (void) _dlaset (_dc_16, ($13_ = (*n_) - (*m_), &$13_), nrhs_, ($14_ = 0.0, &$14_), ($15_ = 0.0, &$15_), &b_[(*m_) + 1 - 
    1 + ((*ldb_)) * ((0))], ldb_);
  }
  if ((*m_) >= (*n_)) {
    mm_ = (*m_);
    if ((*m_) >= mnthr_) {
      mm_ = (*n_);
      itau_ = 1;
      nwork_ = itau_ + (*n_);
      (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($16_ = (*lwork_) - nwork_ + 1, &$16_), info_)
      ;
      (void) _dormqr (_dc_1, _dc_25, m_, nrhs_, n_, a_, lda_, &work_[itau_ - 1], b_, ldb_, &work_[nwork_ - 1], ($17_ = 
      (*lwork_) - nwork_ + 1, &$17_), info_);
      if ((*n_) > 1) {
        (void) _dlaset (_dc_1, ($18_ = (*n_) - 1, &$18_), ($19_ = (*n_) - 1, &$19_), ($20_ = 0.0, &$20_), ($21_ = 0.0, &$21_), 
        &a_[1 + ((*lda_)) * ((0))], lda_);
      }
    }
    ie_ = 1;
    itauq_ = ie_ + (*n_);
    itaup_ = itauq_ + (*n_);
    nwork_ = itaup_ + (*n_);
    (void) _dgebrd (&mm_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[nwork_ - 1], 
    ($22_ = (*lwork_) - nwork_ + 1, &$22_), info_);
    (void) _dormbr (_dc_53, _dc_1, _dc_25, &mm_, nrhs_, n_, a_, lda_, &work_[itauq_ - 1], b_, ldb_, &work_[nwork_ - 1], 
    ($23_ = (*lwork_) - nwork_ + 1, &$23_), info_);
    (void) _dlalsd (_dc_0, &smlsiz_, n_, nrhs_, s_, &work_[ie_ - 1], b_, ldb_, rcond_, rank_, &work_[nwork_ - 1], iwork_, 
    info_);
    if ((*info_) != 0) {
      goto _l10;
    }
    (void) _dormbr (_dc_3, _dc_1, _dc_2, n_, nrhs_, n_, a_, lda_, &work_[itaup_ - 1], b_, ldb_, &work_[nwork_ - 1], ($24_ = 
    (*lwork_) - nwork_ + 1, &$24_), info_);
  }
  else if ((*n_) >= mnthr_ && (*lwork_) >= 4 * (*m_) + (*m_) * (*m_) + ($25_ = _max ((*m_), 2 * (*m_) - 4), $25_ = _max 
    ($25_, (*nrhs_)), $25_ = _max ($25_, (*n_) - 3 * (*m_)), _max ($25_, wlalsd_))) {
    ldwork_ = (*m_);
    if ((*lwork_) >= ($27_ = _max (4 * (*m_) + (*m_) * (*lda_) + ($26_ = _max ((*m_), 2 * (*m_) - 4), $26_ = _max ($26_, 
      (*nrhs_)), _max ($26_, (*n_) - 3 * (*m_))), (*m_) * (*lda_) + (*m_) + (*m_) * (*nrhs_)), _max ($27_, 4 * (*m_) + (*m_) 
      * (*lda_) + wlalsd_))) {
      ldwork_ = (*lda_);
    }
    itau_ = 1;
    nwork_ = (*m_) + 1;
    (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($28_ = (*lwork_) - nwork_ + 1, &$28_), info_)
    ;
    il_ = nwork_;
    (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[il_ - 1], &ldwork_);
    (void) _dlaset (_dc_0, ($29_ = (*m_) - 1, &$29_), ($30_ = (*m_) - 1, &$30_), ($31_ = 0.0, &$31_), ($32_ = 0.0, &$32_), 
    &work_[il_ + ldwork_ - 1], &ldwork_);
    ie_ = il_ + ldwork_ * (*m_);
    itauq_ = ie_ + (*m_);
    itaup_ = itauq_ + (*m_);
    nwork_ = itaup_ + (*m_);
    (void) _dgebrd (m_, m_, &work_[il_ - 1], &ldwork_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
    &work_[nwork_ - 1], ($33_ = (*lwork_) - nwork_ + 1, &$33_), info_);
    (void) _dormbr (_dc_53, _dc_1, _dc_25, m_, nrhs_, m_, &work_[il_ - 1], &ldwork_, &work_[itauq_ - 1], b_, ldb_, 
    &work_[nwork_ - 1], ($34_ = (*lwork_) - nwork_ + 1, &$34_), info_);
    (void) _dlalsd (_dc_0, &smlsiz_, m_, nrhs_, s_, &work_[ie_ - 1], b_, ldb_, rcond_, rank_, &work_[nwork_ - 1], iwork_, 
    info_);
    if ((*info_) != 0) {
      goto _l10;
    }
    (void) _dormbr (_dc_3, _dc_1, _dc_2, m_, nrhs_, m_, &work_[il_ - 1], &ldwork_, &work_[itaup_ - 1], b_, ldb_, 
    &work_[nwork_ - 1], ($35_ = (*lwork_) - nwork_ + 1, &$35_), info_);
    (void) _dlaset (_dc_16, ($36_ = (*n_) - (*m_), &$36_), nrhs_, ($37_ = 0.0, &$37_), ($38_ = 0.0, &$38_), &b_[(*m_) + 1 - 
    1 + ((*ldb_)) * ((0))], ldb_);
    nwork_ = itau_ + (*m_);
    (void) _dormlq (_dc_1, _dc_25, n_, nrhs_, m_, a_, lda_, &work_[itau_ - 1], b_, ldb_, &work_[nwork_ - 1], ($39_ = 
    (*lwork_) - nwork_ + 1, &$39_), info_);
  }
  else {
    ie_ = 1;
    itauq_ = ie_ + (*m_);
    itaup_ = itauq_ + (*m_);
    nwork_ = itaup_ + (*m_);
    (void) _dgebrd (m_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[nwork_ - 1], 
    ($40_ = (*lwork_) - nwork_ + 1, &$40_), info_);
    (void) _dormbr (_dc_53, _dc_1, _dc_25, m_, nrhs_, n_, a_, lda_, &work_[itauq_ - 1], b_, ldb_, &work_[nwork_ - 1], ($41_ 
    = (*lwork_) - nwork_ + 1, &$41_), info_);
    (void) _dlalsd (_dc_1, &smlsiz_, m_, nrhs_, s_, &work_[ie_ - 1], b_, ldb_, rcond_, rank_, &work_[nwork_ - 1], iwork_, 
    info_);
    if ((*info_) != 0) {
      goto _l10;
    }
    (void) _dormbr (_dc_3, _dc_1, _dc_2, n_, nrhs_, m_, a_, lda_, &work_[itaup_ - 1], b_, ldb_, &work_[nwork_ - 1], ($42_ = 
    (*lwork_) - nwork_ + 1, &$42_), info_);
  }
  if (iascl_ == 1) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &smlnum_, n_, nrhs_, b_, ldb_, info_);
    (void) _dlascl (_dc_9, &_k0, &_k0, &smlnum_, &anrm_, &minmn_, &_k1, s_, &minmn_, info_);
  }
  else if (iascl_ == 2) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &bignum_, n_, nrhs_, b_, ldb_, info_);
    (void) _dlascl (_dc_9, &_k0, &_k0, &bignum_, &anrm_, &minmn_, &_k1, s_, &minmn_, info_);
  }
  if (ibscl_ == 1) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &smlnum_, &bnrm_, n_, nrhs_, b_, ldb_, info_);
  }
  else if (ibscl_ == 2) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &bignum_, &bnrm_, n_, nrhs_, b_, ldb_, info_);
  }
  _l10:;
  work_[0] = maxwrk_;
  iwork_[0] = liwork_;
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _dgelss (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ 
ldb_, real_8 _p_ s_, real_8 _p_ rcond_, int_4 _p_ rank_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 bdspac_, bl_, chunk_, i_, iascl_, ibscl_, ie_, il_, itau_, itaup_, itauq_, iwork_, ldwork_, maxmn_, 
  maxwrk_, minmn_, minwrk_, mm_, mnthr_, lwork_dgeqrf_, lwork_dormqr_, lwork_dgebrd_, lwork_dormbr_, lwork_dorgbr_, 
  lwork_dormlq_, lwork_dgelqf_;
  static logical_4 lquery_;
  static real_8 anrm_, bignum_, bnrm_, eps_, sfmin_, smlnum_, thr_, dum_[1];
  int_4 $0_, $1_, $2_, $3_, $4_, $9_, $10_, $11_, $12_, $15_, $16_, $17_, $26_, $27_, $28_, $29_, $30_, $33_, $34_, $35_, 
  $44_, $47_, $48_, $49_, $50_;
  real_8 $5_, $6_, $7_, $8_, $13_, $14_, $18_, $19_, $20_, $21_, $22_, $23_, $24_, $25_, $31_, $32_, $36_, $37_, $38_, 
  $39_, $40_, $41_, $42_, $43_, $45_, $46_, $51_, $52_, $53_, $54_, $55_, $56_, $57_, $58_;
  extern int_4 _dcopy ();
  extern int_4 _dgemm ();
  extern int_4 _dgemv ();
  extern int_4 _xerbla ();
  extern real_8 _dlamch ();
  (*info_) = 0;
  minmn_ = _min ((*m_), (*n_));
  maxmn_ = _max ((*m_), (*n_));
  lquery_ = ((*lwork_) == -1);
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*nrhs_) < 0) {
    (*info_) = -3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -5;
  }
  else if ((*ldb_) < _max (1, maxmn_)) {
    (*info_) = -7;
  }
  if ((*info_) == 0) {
    minwrk_ = 1;
    maxwrk_ = 1;
    if (minmn_ > 0) {
      mm_ = (*m_);
      mnthr_ = _ilaenv (($0_ = 6, &$0_), _dc_54, _dc_6, m_, n_, nrhs_, &_km1);
      if ((*m_) >= (*n_) && (*m_) >= mnthr_) {
        (void) _dgeqrf (m_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, info_);
        lwork_dgeqrf_ = dum_[0];
        (void) _dormqr (_dc_1, _dc_25, m_, nrhs_, n_, a_, lda_, &dum_[0], b_, ldb_, &dum_[0], &_km1, info_);
        lwork_dormqr_ = dum_[0];
        mm_ = (*n_);
        maxwrk_ = _max (maxwrk_, (*n_) + lwork_dgeqrf_);
        maxwrk_ = _max (maxwrk_, (*n_) + lwork_dormqr_);
      }
      if ((*m_) >= (*n_)) {
        bdspac_ = _max (1, 5 * (*n_));
        (void) _dgebrd (&mm_, n_, a_, lda_, s_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, info_);
        lwork_dgebrd_ = dum_[0];
        (void) _dormbr (_dc_53, _dc_1, _dc_25, &mm_, nrhs_, n_, a_, lda_, &dum_[0], b_, ldb_, &dum_[0], &_km1, info_);
        lwork_dormbr_ = dum_[0];
        (void) _dorgbr (_dc_3, n_, n_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, info_);
        lwork_dorgbr_ = dum_[0];
        maxwrk_ = _max (maxwrk_, 3 * (*n_) + lwork_dgebrd_);
        maxwrk_ = _max (maxwrk_, 3 * (*n_) + lwork_dormbr_);
        maxwrk_ = _max (maxwrk_, 3 * (*n_) + lwork_dorgbr_);
        maxwrk_ = _max (maxwrk_, bdspac_);
        maxwrk_ = _max (maxwrk_, (*n_) * (*nrhs_));
        minwrk_ = ($1_ = _max (3 * (*n_) + mm_, 3 * (*n_) + (*nrhs_)), _max ($1_, bdspac_));
        maxwrk_ = _max (minwrk_, maxwrk_);
      }
      if ((*n_) > (*m_)) {
        bdspac_ = _max (1, 5 * (*m_));
        minwrk_ = ($2_ = _max (3 * (*m_) + (*nrhs_), 3 * (*m_) + (*n_)), _max ($2_, bdspac_));
        if ((*n_) >= mnthr_) {
          (void) _dgelqf (m_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, info_);
          lwork_dgelqf_ = dum_[0];
          (void) _dgebrd (m_, m_, a_, lda_, s_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, info_);
          lwork_dgebrd_ = dum_[0];
          (void) _dormbr (_dc_53, _dc_1, _dc_25, m_, nrhs_, n_, a_, lda_, &dum_[0], b_, ldb_, &dum_[0], &_km1, info_);
          lwork_dormbr_ = dum_[0];
          (void) _dorgbr (_dc_3, m_, m_, m_, a_, lda_, &dum_[0], &dum_[0], &_km1, info_);
          lwork_dorgbr_ = dum_[0];
          (void) _dormlq (_dc_1, _dc_25, n_, nrhs_, m_, a_, lda_, &dum_[0], b_, ldb_, &dum_[0], &_km1, info_);
          lwork_dormlq_ = dum_[0];
          maxwrk_ = (*m_) + lwork_dgelqf_;
          maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 4 * (*m_) + lwork_dgebrd_);
          maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 4 * (*m_) + lwork_dormbr_);
          maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 4 * (*m_) + lwork_dorgbr_);
          maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + (*m_) + bdspac_);
          if ((*nrhs_) > 1) {
            maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + (*m_) + (*m_) * (*nrhs_));
          }
          else {
            maxwrk_ = _max (maxwrk_, (*m_) * (*m_) + 2 * (*m_));
          }
          maxwrk_ = _max (maxwrk_, (*m_) + lwork_dormlq_);
        }
        else {
          (void) _dgebrd (m_, n_, a_, lda_, s_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, info_);
          lwork_dgebrd_ = dum_[0];
          (void) _dormbr (_dc_53, _dc_1, _dc_25, m_, nrhs_, m_, a_, lda_, &dum_[0], b_, ldb_, &dum_[0], &_km1, info_);
          lwork_dormbr_ = dum_[0];
          (void) _dorgbr (_dc_3, m_, n_, m_, a_, lda_, &dum_[0], &dum_[0], &_km1, info_);
          lwork_dorgbr_ = dum_[0];
          maxwrk_ = 3 * (*m_) + lwork_dgebrd_;
          maxwrk_ = _max (maxwrk_, 3 * (*m_) + lwork_dormbr_);
          maxwrk_ = _max (maxwrk_, 3 * (*m_) + lwork_dorgbr_);
          maxwrk_ = _max (maxwrk_, bdspac_);
          maxwrk_ = _max (maxwrk_, (*n_) * (*nrhs_));
        }
      }
      maxwrk_ = _max (minwrk_, maxwrk_);
    }
    work_[0] = maxwrk_;
    if ((*lwork_) < minwrk_ && ! (lquery_)) {
      (*info_) = -12;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_54, ($3_ = -(*info_), &$3_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    (*rank_) = 0;
    goto _l0;
  }
  eps_ = _dlamch (_dc_3);
  sfmin_ = _dlamch (_dc_52);
  smlnum_ = sfmin_ / eps_;
  bignum_ = 1.0 / smlnum_;
  (void) _dlabad (&smlnum_, &bignum_);
  anrm_ = _dlange (_dc_8, m_, n_, a_, lda_, work_);
  iascl_ = 0;
  if (anrm_ > 0.0 && anrm_ < smlnum_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &smlnum_, m_, n_, a_, lda_, info_);
    iascl_ = 1;
  }
  else if (anrm_ > bignum_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &bignum_, m_, n_, a_, lda_, info_);
    iascl_ = 2;
  }
  else if (anrm_ == 0.0) {
    (void) _dlaset (_dc_16, ($4_ = _max ((*m_), (*n_)), &$4_), nrhs_, ($5_ = 0.0, &$5_), ($6_ = 0.0, &$6_), b_, ldb_);
    (void) _dlaset (_dc_16, &minmn_, &_k1, ($7_ = 0.0, &$7_), ($8_ = 0.0, &$8_), s_, &minmn_);
    (*rank_) = 0;
    goto _l70;
  }
  bnrm_ = _dlange (_dc_8, m_, nrhs_, b_, ldb_, work_);
  ibscl_ = 0;
  if (bnrm_ > 0.0 && bnrm_ < smlnum_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &bnrm_, &smlnum_, m_, nrhs_, b_, ldb_, info_);
    ibscl_ = 1;
  }
  else if (bnrm_ > bignum_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &bnrm_, &bignum_, m_, nrhs_, b_, ldb_, info_);
    ibscl_ = 2;
  }
  if ((*m_) >= (*n_)) {
    mm_ = (*m_);
    if ((*m_) >= mnthr_) {
      mm_ = (*n_);
      itau_ = 1;
      iwork_ = itau_ + (*n_);
      (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($9_ = (*lwork_) - iwork_ + 1, &$9_), info_);
      (void) _dormqr (_dc_1, _dc_25, m_, nrhs_, n_, a_, lda_, &work_[itau_ - 1], b_, ldb_, &work_[iwork_ - 1], ($10_ = 
      (*lwork_) - iwork_ + 1, &$10_), info_);
      if ((*n_) > 1) {
        (void) _dlaset (_dc_1, ($11_ = (*n_) - 1, &$11_), ($12_ = (*n_) - 1, &$12_), ($13_ = 0.0, &$13_), ($14_ = 0.0, &$14_), 
        &a_[1 + ((*lda_)) * ((0))], lda_);
      }
    }
    ie_ = 1;
    itauq_ = ie_ + (*n_);
    itaup_ = itauq_ + (*n_);
    iwork_ = itaup_ + (*n_);
    (void) _dgebrd (&mm_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
    ($15_ = (*lwork_) - iwork_ + 1, &$15_), info_);
    (void) _dormbr (_dc_53, _dc_1, _dc_25, &mm_, nrhs_, n_, a_, lda_, &work_[itauq_ - 1], b_, ldb_, &work_[iwork_ - 1], 
    ($16_ = (*lwork_) - iwork_ + 1, &$16_), info_);
    (void) _dorgbr (_dc_3, n_, n_, n_, a_, lda_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($17_ = (*lwork_) - iwork_ + 1, 
    &$17_), info_);
    iwork_ = ie_ + (*n_);
    (void) _dbdsqr (_dc_0, n_, n_, &_k0, nrhs_, s_, &work_[ie_ - 1], a_, lda_, dum_, &_k1, b_, ldb_, &work_[iwork_ - 1], 
    info_);
    if ((*info_) != 0) {
      goto _l70;
    }
    thr_ = _max ((*rcond_) * s_[0], sfmin_);
    if ((*rcond_) < 0.0) {
      thr_ = _max (eps_ * s_[0], sfmin_);
    }
    (*rank_) = 0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      if (s_[i_ - 1] > thr_) {
        (void) _drscl (nrhs_, &s_[i_ - 1], &b_[i_ - 1 + ((*ldb_)) * ((0))], ldb_);
        (*rank_) = (*rank_) + 1;
      }
      else {
        (void) _dlaset (_dc_16, &_k1, nrhs_, ($18_ = 0.0, &$18_), ($19_ = 0.0, &$19_), &b_[i_ - 1 + ((*ldb_)) * ((0))], ldb_);
      }
    }
    if ((*lwork_) >= (*ldb_) * (*nrhs_) && (*nrhs_) > 1) {
      (void) _dgemm (_dc_25, _dc_2, n_, nrhs_, n_, ($20_ = 1.0, &$20_), a_, lda_, b_, ldb_, ($21_ = 0.0, &$21_), work_, ldb_)
      ;
      (void) _dlacpy (_dc_9, n_, nrhs_, work_, ldb_, b_, ldb_);
    }
    else if ((*nrhs_) > 1) {
      chunk_ = (*lwork_) / (*n_);
      for (i_ = 1; (chunk_ > 0 ? i_ <= (*nrhs_) : i_ >= (*nrhs_)); i_ += chunk_) {
        bl_ = _min ((*nrhs_) - i_ + 1, chunk_);
        (void) _dgemm (_dc_25, _dc_2, n_, &bl_, n_, ($22_ = 1.0, &$22_), a_, lda_, &b_[0 + ((*ldb_)) * ((i_ - 1))], ldb_, ($23_ 
        = 0.0, &$23_), work_, n_);
        (void) _dlacpy (_dc_9, n_, &bl_, work_, n_, &b_[0 + ((*ldb_)) * ((i_ - 1))], ldb_);
      }
    }
    else {
      (void) _dgemv (_dc_25, n_, n_, ($24_ = 1.0, &$24_), a_, lda_, b_, &_k1, ($25_ = 0.0, &$25_), work_, &_k1);
      (void) _dcopy (n_, work_, &_k1, b_, &_k1);
    }
  }
  else if ((*n_) >= mnthr_ && (*lwork_) >= 4 * (*m_) + (*m_) * (*m_) + ($26_ = _max ((*m_), 2 * (*m_) - 4), $26_ = _max 
    ($26_, (*nrhs_)), _max ($26_, (*n_) - 3 * (*m_)))) {
    ldwork_ = (*m_);
    if ((*lwork_) >= _max (4 * (*m_) + (*m_) * (*lda_) + ($27_ = _max ((*m_), 2 * (*m_) - 4), $27_ = _max ($27_, (*nrhs_)), 
      _max ($27_, (*n_) - 3 * (*m_))), (*m_) * (*lda_) + (*m_) + (*m_) * (*nrhs_))) {
      ldwork_ = (*lda_);
    }
    itau_ = 1;
    iwork_ = (*m_) + 1;
    (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($28_ = (*lwork_) - iwork_ + 1, &$28_), info_)
    ;
    il_ = iwork_;
    (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[il_ - 1], &ldwork_);
    (void) _dlaset (_dc_0, ($29_ = (*m_) - 1, &$29_), ($30_ = (*m_) - 1, &$30_), ($31_ = 0.0, &$31_), ($32_ = 0.0, &$32_), 
    &work_[il_ + ldwork_ - 1], &ldwork_);
    ie_ = il_ + ldwork_ * (*m_);
    itauq_ = ie_ + (*m_);
    itaup_ = itauq_ + (*m_);
    iwork_ = itaup_ + (*m_);
    (void) _dgebrd (m_, m_, &work_[il_ - 1], &ldwork_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
    &work_[iwork_ - 1], ($33_ = (*lwork_) - iwork_ + 1, &$33_), info_);
    (void) _dormbr (_dc_53, _dc_1, _dc_25, m_, nrhs_, m_, &work_[il_ - 1], &ldwork_, &work_[itauq_ - 1], b_, ldb_, 
    &work_[iwork_ - 1], ($34_ = (*lwork_) - iwork_ + 1, &$34_), info_);
    (void) _dorgbr (_dc_3, m_, m_, m_, &work_[il_ - 1], &ldwork_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($35_ = (*lwork_) 
    - iwork_ + 1, &$35_), info_);
    iwork_ = ie_ + (*m_);
    (void) _dbdsqr (_dc_0, m_, m_, &_k0, nrhs_, s_, &work_[ie_ - 1], &work_[il_ - 1], &ldwork_, a_, lda_, b_, ldb_, 
    &work_[iwork_ - 1], info_);
    if ((*info_) != 0) {
      goto _l70;
    }
    thr_ = _max ((*rcond_) * s_[0], sfmin_);
    if ((*rcond_) < 0.0) {
      thr_ = _max (eps_ * s_[0], sfmin_);
    }
    (*rank_) = 0;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      if (s_[i_ - 1] > thr_) {
        (void) _drscl (nrhs_, &s_[i_ - 1], &b_[i_ - 1 + ((*ldb_)) * ((0))], ldb_);
        (*rank_) = (*rank_) + 1;
      }
      else {
        (void) _dlaset (_dc_16, &_k1, nrhs_, ($36_ = 0.0, &$36_), ($37_ = 0.0, &$37_), &b_[i_ - 1 + ((*ldb_)) * ((0))], ldb_);
      }
    }
    iwork_ = ie_;
    if ((*lwork_) >= (*ldb_) * (*nrhs_) + iwork_ - 1 && (*nrhs_) > 1) {
      (void) _dgemm (_dc_25, _dc_2, m_, nrhs_, m_, ($38_ = 1.0, &$38_), &work_[il_ - 1], &ldwork_, b_, ldb_, ($39_ = 0.0, 
      &$39_), &work_[iwork_ - 1], ldb_);
      (void) _dlacpy (_dc_9, m_, nrhs_, &work_[iwork_ - 1], ldb_, b_, ldb_);
    }
    else if ((*nrhs_) > 1) {
      chunk_ = ((*lwork_) - iwork_ + 1) / (*m_);
      for (i_ = 1; (chunk_ > 0 ? i_ <= (*nrhs_) : i_ >= (*nrhs_)); i_ += chunk_) {
        bl_ = _min ((*nrhs_) - i_ + 1, chunk_);
        (void) _dgemm (_dc_25, _dc_2, m_, &bl_, m_, ($40_ = 1.0, &$40_), &work_[il_ - 1], &ldwork_, &b_[0 + ((*ldb_)) * ((i_ - 
        1))], ldb_, ($41_ = 0.0, &$41_), &work_[iwork_ - 1], m_);
        (void) _dlacpy (_dc_9, m_, &bl_, &work_[iwork_ - 1], m_, &b_[0 + ((*ldb_)) * ((i_ - 1))], ldb_);
      }
    }
    else {
      (void) _dgemv (_dc_25, m_, m_, ($42_ = 1.0, &$42_), &work_[il_ - 1], &ldwork_, &b_[0 + ((*ldb_)) * ((0))], &_k1, ($43_ 
      = 0.0, &$43_), &work_[iwork_ - 1], &_k1);
      (void) _dcopy (m_, &work_[iwork_ - 1], &_k1, &b_[0 + ((*ldb_)) * ((0))], &_k1);
    }
    (void) _dlaset (_dc_16, ($44_ = (*n_) - (*m_), &$44_), nrhs_, ($45_ = 0.0, &$45_), ($46_ = 0.0, &$46_), &b_[(*m_) + 1 - 
    1 + ((*ldb_)) * ((0))], ldb_);
    iwork_ = itau_ + (*m_);
    (void) _dormlq (_dc_1, _dc_25, n_, nrhs_, m_, a_, lda_, &work_[itau_ - 1], b_, ldb_, &work_[iwork_ - 1], ($47_ = 
    (*lwork_) - iwork_ + 1, &$47_), info_);
  }
  else {
    ie_ = 1;
    itauq_ = ie_ + (*m_);
    itaup_ = itauq_ + (*m_);
    iwork_ = itaup_ + (*m_);
    (void) _dgebrd (m_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
    ($48_ = (*lwork_) - iwork_ + 1, &$48_), info_);
    (void) _dormbr (_dc_53, _dc_1, _dc_25, m_, nrhs_, n_, a_, lda_, &work_[itauq_ - 1], b_, ldb_, &work_[iwork_ - 1], ($49_ 
    = (*lwork_) - iwork_ + 1, &$49_), info_);
    (void) _dorgbr (_dc_3, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($50_ = (*lwork_) - iwork_ + 1, 
    &$50_), info_);
    iwork_ = ie_ + (*m_);
    (void) _dbdsqr (_dc_1, m_, n_, &_k0, nrhs_, s_, &work_[ie_ - 1], a_, lda_, dum_, &_k1, b_, ldb_, &work_[iwork_ - 1], 
    info_);
    if ((*info_) != 0) {
      goto _l70;
    }
    thr_ = _max ((*rcond_) * s_[0], sfmin_);
    if ((*rcond_) < 0.0) {
      thr_ = _max (eps_ * s_[0], sfmin_);
    }
    (*rank_) = 0;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      if (s_[i_ - 1] > thr_) {
        (void) _drscl (nrhs_, &s_[i_ - 1], &b_[i_ - 1 + ((*ldb_)) * ((0))], ldb_);
        (*rank_) = (*rank_) + 1;
      }
      else {
        (void) _dlaset (_dc_16, &_k1, nrhs_, ($51_ = 0.0, &$51_), ($52_ = 0.0, &$52_), &b_[i_ - 1 + ((*ldb_)) * ((0))], ldb_);
      }
    }
    if ((*lwork_) >= (*ldb_) * (*nrhs_) && (*nrhs_) > 1) {
      (void) _dgemm (_dc_25, _dc_2, n_, nrhs_, m_, ($53_ = 1.0, &$53_), a_, lda_, b_, ldb_, ($54_ = 0.0, &$54_), work_, ldb_)
      ;
      (void) _dlacpy (_dc_16, n_, nrhs_, work_, ldb_, b_, ldb_);
    }
    else if ((*nrhs_) > 1) {
      chunk_ = (*lwork_) / (*n_);
      for (i_ = 1; (chunk_ > 0 ? i_ <= (*nrhs_) : i_ >= (*nrhs_)); i_ += chunk_) {
        bl_ = _min ((*nrhs_) - i_ + 1, chunk_);
        (void) _dgemm (_dc_25, _dc_2, n_, &bl_, m_, ($55_ = 1.0, &$55_), a_, lda_, &b_[0 + ((*ldb_)) * ((i_ - 1))], ldb_, ($56_ 
        = 0.0, &$56_), work_, n_);
        (void) _dlacpy (_dc_16, n_, &bl_, work_, n_, &b_[0 + ((*ldb_)) * ((i_ - 1))], ldb_);
      }
    }
    else {
      (void) _dgemv (_dc_25, m_, n_, ($57_ = 1.0, &$57_), a_, lda_, b_, &_k1, ($58_ = 0.0, &$58_), work_, &_k1);
      (void) _dcopy (n_, work_, &_k1, b_, &_k1);
    }
  }
  if (iascl_ == 1) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &smlnum_, n_, nrhs_, b_, ldb_, info_);
    (void) _dlascl (_dc_9, &_k0, &_k0, &smlnum_, &anrm_, &minmn_, &_k1, s_, &minmn_, info_);
  }
  else if (iascl_ == 2) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &bignum_, n_, nrhs_, b_, ldb_, info_);
    (void) _dlascl (_dc_9, &_k0, &_k0, &bignum_, &anrm_, &minmn_, &_k1, s_, &minmn_, info_);
  }
  if (ibscl_ == 1) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &smlnum_, &bnrm_, n_, nrhs_, b_, ldb_, info_);
  }
  else if (ibscl_ == 2) {
    (void) _dlascl (_dc_9, &_k0, &_k0, &bignum_, &bnrm_, n_, nrhs_, b_, ldb_, info_);
  }
  _l70:;
  work_[0] = maxwrk_;
  _l0:;
  __calls[9].calls++;
  return 0;
}

int_4 _dgeqp3 (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ jpvt_, real_8 _p_ tau_, real_8 _p_ 
work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 fjb_, iws_, j_, jb_, lwkopt_, minmn_, minws_, na_, nb_, nbmin_, nfxd_, nx_, sm_, sminmn_, sn_, topbmn_;
  static logical_4 lquery_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  extern real_8 _dnrm2 ();
  (*info_) = 0;
  lquery_ = ((*lwork_) == -1);
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  if ((*info_) == 0) {
    minmn_ = _min ((*m_), (*n_));
    if (minmn_ == 0) {
      iws_ = 1;
      lwkopt_ = 1;
    }
    else {
      iws_ = 3 * (*n_) + 1;
      nb_ = _ilaenv (&_k1, _dc_45, _dc_6, m_, n_, &_km1, &_km1);
      lwkopt_ = 2 * (*n_) + ((*n_) + 1) * nb_;
    }
    work_[0] = lwkopt_;
    if (((*lwork_) < iws_) && ! (lquery_)) {
      (*info_) = -8;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_55, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  nfxd_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (jpvt_[j_ - 1] != 0) {
      if (j_ != nfxd_) {
        (void) _dswap (m_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((nfxd_ - 1))], &_k1);
        jpvt_[j_ - 1] = jpvt_[nfxd_ - 1];
        jpvt_[nfxd_ - 1] = j_;
      }
      else {
        jpvt_[j_ - 1] = j_;
      }
      nfxd_ = nfxd_ + 1;
    }
    else {
      jpvt_[j_ - 1] = j_;
    }
  }
  nfxd_ = nfxd_ - 1;
  if (nfxd_ > 0) {
    na_ = _min ((*m_), nfxd_);
    (void) _dgeqrf (m_, &na_, a_, lda_, tau_, work_, lwork_, info_);
    iws_ = _max (iws_, (int_4) (_aintd (work_[0])));
    if (na_ < (*n_)) {
      (void) _dormqr (_dc_18, _dc_22, m_, ($1_ = (*n_) - na_, &$1_), &na_, a_, lda_, tau_, &a_[0 + ((*lda_)) * ((na_ + 1 - 
      1))], lda_, work_, lwork_, info_);
      iws_ = _max (iws_, (int_4) (_aintd (work_[0])));
    }
  }
  if (nfxd_ < minmn_) {
    sm_ = (*m_) - nfxd_;
    sn_ = (*n_) - nfxd_;
    sminmn_ = minmn_ - nfxd_;
    nb_ = _ilaenv (&_k1, _dc_45, _dc_6, &sm_, &sn_, &_km1, &_km1);
    nbmin_ = 2;
    nx_ = 0;
    if ((nb_ > 1) && (nb_ < sminmn_)) {
      nx_ = _max (0, _ilaenv (($2_ = 3, &$2_), _dc_45, _dc_6, &sm_, &sn_, &_km1, &_km1));
      if (nx_ < sminmn_) {
        minws_ = 2 * sn_ + (sn_ + 1) * nb_;
        iws_ = _max (iws_, minws_);
        if ((*lwork_) < minws_) {
          nb_ = ((*lwork_) - 2 * sn_) / (sn_ + 1);
          nbmin_ = _max (2, _ilaenv (($3_ = 2, &$3_), _dc_45, _dc_6, &sm_, &sn_, &_km1, &_km1));
        }
      }
    }
    for (j_ = nfxd_ + 1; j_ <= (*n_); (j_)++) {
      work_[j_ - 1] = _dnrm2 (&sm_, &a_[nfxd_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
      work_[(*n_) + j_ - 1] = work_[j_ - 1];
    }
    if ((nb_ >= nbmin_) && (nb_ < sminmn_) && (nx_ < sminmn_)) {
      j_ = nfxd_ + 1;
      topbmn_ = minmn_ - nx_;
      _l30:;
      if (j_ <= topbmn_) {
        jb_ = _min (nb_, topbmn_ - j_ + 1);
        (void) _dlaqps (m_, ($4_ = (*n_) - j_ + 1, &$4_), ($5_ = j_ - 1, &$5_), &jb_, &fjb_, &a_[0 + ((*lda_)) * ((j_ - 1))], 
        lda_, &jpvt_[j_ - 1], &tau_[j_ - 1], &work_[j_ - 1], &work_[(*n_) + j_ - 1], &work_[2 * (*n_) + 1 - 1], &work_[2 * 
        (*n_) + jb_ + 1 - 1], ($6_ = (*n_) - j_ + 1, &$6_));
        j_ = j_ + fjb_;
        goto _l30;
      }
    }
    else {
      j_ = nfxd_ + 1;
    }
    if (j_ <= minmn_) {
      (void) _dlaqp2 (m_, ($7_ = (*n_) - j_ + 1, &$7_), ($8_ = j_ - 1, &$8_), &a_[0 + ((*lda_)) * ((j_ - 1))], lda_, 
      &jpvt_[j_ - 1], &tau_[j_ - 1], &work_[j_ - 1], &work_[(*n_) + j_ - 1], &work_[2 * (*n_) + 1 - 1]);
    }
  }
  work_[0] = iws_;
  _l0:;
  __calls[10].calls++;
  return 0;
}

int_4 _dgeqr2 (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ work_, int_4 _p_ 
info_)
{
  static int_4 i_, k_;
  static real_8 aii_;
  int_4 $0_, $1_, $2_, $3_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_56, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  k_ = _min ((*m_), (*n_));
  for (i_ = 1; i_ <= k_; (i_)++) {
    (void) _dlarfg (($1_ = (*m_) - i_ + 1, &$1_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[_min (i_ + 1, (*m_)) - 1 + 
    ((*lda_)) * ((i_ - 1))], &_k1, &tau_[i_ - 1]);
    if (i_ < (*n_)) {
      aii_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
      (void) _dlarf (_dc_18, ($2_ = (*m_) - i_ + 1, &$2_), ($3_ = (*n_) - i_, &$3_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
      &_k1, &tau_[i_ - 1], &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, work_);
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
    }
  }
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _dgeqrf (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ work_, int_4 _p_ 
lwork_, int_4 _p_ info_)
{
  static int_4 i_, ib_, iinfo_, iws_, k_, ldwork_, lwkopt_, nb_, nbmin_, nx_;
  static logical_4 lquery_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  nb_ = _ilaenv (&_k1, _dc_45, _dc_6, m_, n_, &_km1, &_km1);
  lwkopt_ = (*n_) * nb_;
  work_[0] = lwkopt_;
  lquery_ = ((*lwork_) == -1);
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -4;
  }
  else if ((*lwork_) < _max (1, (*n_)) && ! (lquery_)) {
    (*info_) = -7;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_45, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  k_ = _min ((*m_), (*n_));
  if (k_ == 0) {
    work_[0] = 1;
    goto _l0;
  }
  nbmin_ = 2;
  nx_ = 0;
  iws_ = (*n_);
  if (nb_ > 1 && nb_ < k_) {
    nx_ = _max (0, _ilaenv (($1_ = 3, &$1_), _dc_45, _dc_6, m_, n_, &_km1, &_km1));
    if (nx_ < k_) {
      ldwork_ = (*n_);
      iws_ = ldwork_ * nb_;
      if ((*lwork_) < iws_) {
        nb_ = (*lwork_) / ldwork_;
        nbmin_ = _max (2, _ilaenv (($2_ = 2, &$2_), _dc_45, _dc_6, m_, n_, &_km1, &_km1));
      }
    }
  }
  if (nb_ >= nbmin_ && nb_ < k_ && nx_ < k_) {
    for (i_ = 1; (nb_ > 0 ? i_ <= k_ - nx_ : i_ >= k_ - nx_); i_ += nb_) {
      ib_ = _min (k_ - i_ + 1, nb_);
      (void) _dgeqr2 (($3_ = (*m_) - i_ + 1, &$3_), &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, &tau_[i_ - 1], work_, 
      &iinfo_);
      if (i_ + ib_ <= (*n_)) {
        (void) _dlarft (_dc_42, _dc_57, ($4_ = (*m_) - i_ + 1, &$4_), &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
        &tau_[i_ - 1], work_, &ldwork_);
        (void) _dlarfb (_dc_18, _dc_22, _dc_42, _dc_57, ($5_ = (*m_) - i_ + 1, &$5_), ($6_ = (*n_) - i_ - ib_ + 1, &$6_), &ib_, 
        &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, work_, &ldwork_, &a_[i_ - 1 + ((*lda_)) * ((i_ + ib_ - 1))], lda_, 
        &work_[ib_ + 1 - 1], &ldwork_);
      }
    }
  }
  else {
    i_ = 1;
  }
  if (i_ <= k_) {
    (void) _dgeqr2 (($7_ = (*m_) - i_ + 1, &$7_), ($8_ = (*n_) - i_ + 1, &$8_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
    &tau_[i_ - 1], work_, &iinfo_);
  }
  work_[0] = iws_;
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _dgesdd (char _p_ jobz_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ s_, real_8 _p_ u_, 
int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ info_)
{
  static int_4 bdspac_, blk_, chunk_, i_, ie_, ierr_, il_, ir_, iscl_, itau_, itaup_, itauq_, iu_, ivt_, ldwkvt_, ldwrkl_
  , ldwrkr_, ldwrku_, maxwrk_, minmn_, minwrk_, mnthr_, nwork_, wrkbl_, lwork_dgebrd_mn_, lwork_dgebrd_mm_, 
  lwork_dgebrd_nn_, lwork_dgelqf_mn_, lwork_dgeqrf_mn_, lwork_dorgbr_p_mm_, lwork_dorgbr_q_nn_, lwork_dorglq_mn_, 
  lwork_dorglq_nn_, lwork_dorgqr_mm_, lwork_dorgqr_mn_, lwork_dormbr_prt_mm_, lwork_dormbr_qln_mm_, lwork_dormbr_prt_mn_, 
  lwork_dormbr_qln_mn_, lwork_dormbr_prt_nn_, lwork_dormbr_qln_nn_, idum_[1];
  static logical_4 lquery_, wntqa_, wntqas_, wntqn_, wntqo_, wntqs_;
  static real_8 anrm_, bignum_, eps_, smlnum_, dum_[1];
  int_4 $0_, $1_, $2_, $3_, $6_, $7_, $8_, $9_, $12_, $13_, $14_, $15_, $18_, $19_, $20_, $23_, $24_, $25_, $26_, $29_, 
  $30_, $31_, $32_, $35_, $36_, $37_, $40_, $43_, $44_, $45_, $50_, $51_, $54_, $55_, $58_, $59_, $60_, $61_, $62_, $65_, 
  $66_, $67_, $68_, $71_, $72_, $73_, $74_, $77_, $78_, $79_, $82_, $83_, $84_, $85_, $88_, $89_, $90_, $91_, $94_, $95_, 
  $96_, $99_, $102_, $103_, $104_, $109_, $110_, $113_, $114_, $117_, $118_;
  real_8 $4_, $5_, $10_, $11_, $16_, $17_, $21_, $22_, $27_, $28_, $33_, $34_, $38_, $39_, $41_, $42_, $46_, $47_, $48_, 
  $49_, $52_, $53_, $56_, $57_, $63_, $64_, $69_, $70_, $75_, $76_, $80_, $81_, $86_, $87_, $92_, $93_, $97_, $98_, $100_
  , $101_, $105_, $106_, $107_, $108_, $111_, $112_, $115_, $116_;
  extern int_4 _dgemm ();
  extern int_4 _xerbla ();
  extern logical_4 _lsame ();
  extern real_8 _dlamch ();
  (*info_) = 0;
  minmn_ = _min ((*m_), (*n_));
  wntqa_ = _lsame (jobz_, _dc_7);
  wntqs_ = _lsame (jobz_, _dc_52);
  wntqas_ = wntqa_ || wntqs_;
  wntqo_ = _lsame (jobz_, _dc_30);
  wntqn_ = _lsame (jobz_, _dc_2);
  lquery_ = ((*lwork_) == -1);
  if (! ((wntqa_ || wntqs_ || wntqo_ || wntqn_))) {
    (*info_) = -1;
  }
  else if ((*m_) < 0) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -5;
  }
  else if ((*ldu_) < 1 || (wntqas_ && (*ldu_) < (*m_)) || (wntqo_ && (*m_) < (*n_) && (*ldu_) < (*m_))) {
    (*info_) = -8;
  }
  else if ((*ldvt_) < 1 || (wntqa_ && (*ldvt_) < (*n_)) || (wntqs_ && (*ldvt_) < minmn_) || (wntqo_ && (*m_) >= (*n_) && 
    (*ldvt_) < (*n_))) {
    (*info_) = -10;
  }
  if ((*info_) == 0) {
    minwrk_ = 1;
    maxwrk_ = 1;
    bdspac_ = 0;
    mnthr_ = (int_4) (_aintd (minmn_ * 11.0e0 / 6.0e0));
    if ((*m_) >= (*n_) && minmn_ > 0) {
      if (wntqn_) {
        bdspac_ = 7 * (*n_);
      }
      else {
        bdspac_ = 3 * (*n_) * (*n_) + 4 * (*n_);
      }
      (void) _dgebrd (m_, n_, &dum_[0], m_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgebrd_mn_ = (int_4) (_aintd (dum_[0]));
      (void) _dgebrd (n_, n_, &dum_[0], n_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgebrd_nn_ = (int_4) (_aintd (dum_[0]));
      (void) _dgeqrf (m_, n_, &dum_[0], m_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgeqrf_mn_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgbr (_dc_53, n_, n_, n_, &dum_[0], n_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgbr_q_nn_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgqr (m_, m_, n_, &dum_[0], m_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgqr_mm_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgqr (m_, n_, n_, &dum_[0], m_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgqr_mn_ = (int_4) (_aintd (dum_[0]));
      (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, n_, &dum_[0], n_, &dum_[0], &dum_[0], n_, &dum_[0], &_km1, &ierr_);
      lwork_dormbr_prt_nn_ = (int_4) (_aintd (dum_[0]));
      (void) _dormbr (_dc_53, _dc_1, _dc_2, n_, n_, n_, &dum_[0], n_, &dum_[0], &dum_[0], n_, &dum_[0], &_km1, &ierr_);
      lwork_dormbr_qln_nn_ = (int_4) (_aintd (dum_[0]));
      (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, n_, n_, &dum_[0], m_, &dum_[0], &dum_[0], m_, &dum_[0], &_km1, &ierr_);
      lwork_dormbr_qln_mn_ = (int_4) (_aintd (dum_[0]));
      (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, n_, &dum_[0], m_, &dum_[0], &dum_[0], m_, &dum_[0], &_km1, &ierr_);
      lwork_dormbr_qln_mm_ = (int_4) (_aintd (dum_[0]));
      if ((*m_) >= mnthr_) {
        if (wntqn_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_mn_;
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_nn_);
          maxwrk_ = _max (wrkbl_, bdspac_ + (*n_));
          minwrk_ = bdspac_ + (*n_);
        }
        else if (wntqo_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_mn_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_mn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_qln_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_prt_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + bdspac_);
          maxwrk_ = wrkbl_ + 2 * (*n_) * (*n_);
          minwrk_ = bdspac_ + 2 * (*n_) * (*n_) + 3 * (*n_);
        }
        else if (wntqs_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_mn_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_mn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_qln_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_prt_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + bdspac_);
          maxwrk_ = wrkbl_ + (*n_) * (*n_);
          minwrk_ = bdspac_ + (*n_) * (*n_) + 3 * (*n_);
        }
        else if (wntqa_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_mn_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_qln_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_prt_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + bdspac_);
          maxwrk_ = wrkbl_ + (*n_) * (*n_);
          minwrk_ = (*n_) * (*n_) + _max (3 * (*n_) + bdspac_, (*n_) + (*m_));
        }
      }
      else {
        wrkbl_ = 3 * (*n_) + lwork_dgebrd_mn_;
        if (wntqn_) {
          maxwrk_ = _max (wrkbl_, 3 * (*n_) + bdspac_);
          minwrk_ = 3 * (*n_) + _max ((*m_), bdspac_);
        }
        else if (wntqo_) {
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_prt_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_qln_mn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + bdspac_);
          maxwrk_ = wrkbl_ + (*m_) * (*n_);
          minwrk_ = 3 * (*n_) + _max ((*m_), (*n_) * (*n_) + bdspac_);
        }
        else if (wntqs_) {
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_qln_mn_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_prt_nn_);
          maxwrk_ = _max (wrkbl_, 3 * (*n_) + bdspac_);
          minwrk_ = 3 * (*n_) + _max ((*m_), bdspac_);
        }
        else if (wntqa_) {
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_qln_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dormbr_prt_nn_);
          maxwrk_ = _max (wrkbl_, 3 * (*n_) + bdspac_);
          minwrk_ = 3 * (*n_) + _max ((*m_), bdspac_);
        }
      }
    }
    else if (minmn_ > 0) {
      if (wntqn_) {
        bdspac_ = 7 * (*m_);
      }
      else {
        bdspac_ = 3 * (*m_) * (*m_) + 4 * (*m_);
      }
      (void) _dgebrd (m_, n_, &dum_[0], m_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgebrd_mn_ = (int_4) (_aintd (dum_[0]));
      (void) _dgebrd (m_, m_, a_, m_, s_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgebrd_mm_ = (int_4) (_aintd (dum_[0]));
      (void) _dgelqf (m_, n_, a_, m_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgelqf_mn_ = (int_4) (_aintd (dum_[0]));
      (void) _dorglq (n_, n_, m_, &dum_[0], n_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorglq_nn_ = (int_4) (_aintd (dum_[0]));
      (void) _dorglq (m_, n_, m_, a_, m_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorglq_mn_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgbr (_dc_3, m_, m_, m_, a_, n_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgbr_p_mm_ = (int_4) (_aintd (dum_[0]));
      (void) _dormbr (_dc_3, _dc_15, _dc_25, m_, m_, m_, &dum_[0], m_, &dum_[0], &dum_[0], m_, &dum_[0], &_km1, &ierr_);
      lwork_dormbr_prt_mm_ = (int_4) (_aintd (dum_[0]));
      (void) _dormbr (_dc_3, _dc_15, _dc_25, m_, n_, m_, &dum_[0], m_, &dum_[0], &dum_[0], m_, &dum_[0], &_km1, &ierr_);
      lwork_dormbr_prt_mn_ = (int_4) (_aintd (dum_[0]));
      (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, m_, &dum_[0], n_, &dum_[0], &dum_[0], n_, &dum_[0], &_km1, &ierr_);
      lwork_dormbr_prt_nn_ = (int_4) (_aintd (dum_[0]));
      (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, m_, &dum_[0], m_, &dum_[0], &dum_[0], m_, &dum_[0], &_km1, &ierr_);
      lwork_dormbr_qln_mm_ = (int_4) (_aintd (dum_[0]));
      if ((*n_) >= mnthr_) {
        if (wntqn_) {
          wrkbl_ = (*m_) + lwork_dgelqf_mn_;
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_mm_);
          maxwrk_ = _max (wrkbl_, bdspac_ + (*m_));
          minwrk_ = bdspac_ + (*m_);
        }
        else if (wntqo_) {
          wrkbl_ = (*m_) + lwork_dgelqf_mn_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_mn_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_qln_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_prt_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + bdspac_);
          maxwrk_ = wrkbl_ + 2 * (*m_) * (*m_);
          minwrk_ = bdspac_ + 2 * (*m_) * (*m_) + 3 * (*m_);
        }
        else if (wntqs_) {
          wrkbl_ = (*m_) + lwork_dgelqf_mn_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_mn_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_qln_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_prt_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + bdspac_);
          maxwrk_ = wrkbl_ + (*m_) * (*m_);
          minwrk_ = bdspac_ + (*m_) * (*m_) + 3 * (*m_);
        }
        else if (wntqa_) {
          wrkbl_ = (*m_) + lwork_dgelqf_mn_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_nn_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_qln_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_prt_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + bdspac_);
          maxwrk_ = wrkbl_ + (*m_) * (*m_);
          minwrk_ = (*m_) * (*m_) + _max (3 * (*m_) + bdspac_, (*m_) + (*n_));
        }
      }
      else {
        wrkbl_ = 3 * (*m_) + lwork_dgebrd_mn_;
        if (wntqn_) {
          maxwrk_ = _max (wrkbl_, 3 * (*m_) + bdspac_);
          minwrk_ = 3 * (*m_) + _max ((*n_), bdspac_);
        }
        else if (wntqo_) {
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_qln_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_prt_mn_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + bdspac_);
          maxwrk_ = wrkbl_ + (*m_) * (*n_);
          minwrk_ = 3 * (*m_) + _max ((*n_), (*m_) * (*m_) + bdspac_);
        }
        else if (wntqs_) {
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_qln_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_prt_mn_);
          maxwrk_ = _max (wrkbl_, 3 * (*m_) + bdspac_);
          minwrk_ = 3 * (*m_) + _max ((*n_), bdspac_);
        }
        else if (wntqa_) {
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_qln_mm_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dormbr_prt_nn_);
          maxwrk_ = _max (wrkbl_, 3 * (*m_) + bdspac_);
          minwrk_ = 3 * (*m_) + _max ((*n_), bdspac_);
        }
      }
    }
    maxwrk_ = _max (maxwrk_, minwrk_);
    work_[0] = maxwrk_;
    if ((*lwork_) < minwrk_ && ! (lquery_)) {
      (*info_) = -12;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_58, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  eps_ = _dlamch (_dc_3);
  smlnum_ = sqrt (_dlamch (_dc_52)) / eps_;
  bignum_ = 1.0 / smlnum_;
  anrm_ = _dlange (_dc_8, m_, n_, a_, lda_, dum_);
  iscl_ = 0;
  if (anrm_ > 0.0 && anrm_ < smlnum_) {
    iscl_ = 1;
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &smlnum_, m_, n_, a_, lda_, &ierr_);
  }
  else if (anrm_ > bignum_) {
    iscl_ = 1;
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &bignum_, m_, n_, a_, lda_, &ierr_);
  }
  if ((*m_) >= (*n_)) {
    if ((*m_) >= mnthr_) {
      if (wntqn_) {
        itau_ = 1;
        nwork_ = itau_ + (*n_);
        (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($1_ = (*lwork_) - nwork_ + 1, &$1_), &ierr_)
        ;
        (void) _dlaset (_dc_1, ($2_ = (*n_) - 1, &$2_), ($3_ = (*n_) - 1, &$3_), ($4_ = 0.0, &$4_), ($5_ = 0.0, &$5_), &a_[1 + 
        ((*lda_)) * ((0))], lda_);
        ie_ = 1;
        itauq_ = ie_ + (*n_);
        itaup_ = itauq_ + (*n_);
        nwork_ = itaup_ + (*n_);
        (void) _dgebrd (n_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[nwork_ - 1], ($6_ 
        = (*lwork_) - nwork_ + 1, &$6_), &ierr_);
        nwork_ = ie_ + (*n_);
        (void) _dbdsdc (_dc_0, _dc_2, n_, s_, &work_[ie_ - 1], dum_, &_k1, dum_, &_k1, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
      }
      else if (wntqo_) {
        ir_ = 1;
        if ((*lwork_) >= (*lda_) * (*n_) + (*n_) * (*n_) + 3 * (*n_) + bdspac_) {
          ldwrkr_ = (*lda_);
        }
        else {
          ldwrkr_ = ((*lwork_) - (*n_) * (*n_) - 3 * (*n_) - bdspac_) / (*n_);
        }
        itau_ = ir_ + ldwrkr_ * (*n_);
        nwork_ = itau_ + (*n_);
        (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($7_ = (*lwork_) - nwork_ + 1, &$7_), &ierr_)
        ;
        (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[ir_ - 1], &ldwrkr_);
        (void) _dlaset (_dc_1, ($8_ = (*n_) - 1, &$8_), ($9_ = (*n_) - 1, &$9_), ($10_ = 0.0, &$10_), ($11_ = 0.0, &$11_), 
        &work_[ir_ + 1 - 1], &ldwrkr_);
        (void) _dorgqr (m_, n_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($12_ = (*lwork_) - nwork_ + 1, &$12_), 
        &ierr_);
        ie_ = itau_;
        itauq_ = ie_ + (*n_);
        itaup_ = itauq_ + (*n_);
        nwork_ = itaup_ + (*n_);
        (void) _dgebrd (n_, n_, &work_[ir_ - 1], &ldwrkr_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
        &work_[nwork_ - 1], ($13_ = (*lwork_) - nwork_ + 1, &$13_), &ierr_);
        iu_ = nwork_;
        nwork_ = iu_ + (*n_) * (*n_);
        (void) _dbdsdc (_dc_0, _dc_4, n_, s_, &work_[ie_ - 1], &work_[iu_ - 1], n_, vt_, ldvt_, dum_, idum_, &work_[nwork_ - 
        1], iwork_, info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itauq_ - 1], &work_[iu_ - 1], n_, 
        &work_[nwork_ - 1], ($14_ = (*lwork_) - nwork_ + 1, &$14_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itaup_ - 1], vt_, ldvt_, 
        &work_[nwork_ - 1], ($15_ = (*lwork_) - nwork_ + 1, &$15_), &ierr_);
        for (i_ = 1; (ldwrkr_ > 0 ? i_ <= (*m_) : i_ >= (*m_)); i_ += ldwrkr_) {
          chunk_ = _min ((*m_) - i_ + 1, ldwrkr_);
          (void) _dgemm (_dc_2, _dc_2, &chunk_, n_, n_, ($16_ = 1.0, &$16_), &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &work_[iu_ - 
          1], n_, ($17_ = 0.0, &$17_), &work_[ir_ - 1], &ldwrkr_);
          (void) _dlacpy (_dc_16, &chunk_, n_, &work_[ir_ - 1], &ldwrkr_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_);
        }
      }
      else if (wntqs_) {
        ir_ = 1;
        ldwrkr_ = (*n_);
        itau_ = ir_ + ldwrkr_ * (*n_);
        nwork_ = itau_ + (*n_);
        (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($18_ = (*lwork_) - nwork_ + 1, &$18_), 
        &ierr_);
        (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[ir_ - 1], &ldwrkr_);
        (void) _dlaset (_dc_1, ($19_ = (*n_) - 1, &$19_), ($20_ = (*n_) - 1, &$20_), ($21_ = 0.0, &$21_), ($22_ = 0.0, &$22_), 
        &work_[ir_ + 1 - 1], &ldwrkr_);
        (void) _dorgqr (m_, n_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($23_ = (*lwork_) - nwork_ + 1, &$23_), 
        &ierr_);
        ie_ = itau_;
        itauq_ = ie_ + (*n_);
        itaup_ = itauq_ + (*n_);
        nwork_ = itaup_ + (*n_);
        (void) _dgebrd (n_, n_, &work_[ir_ - 1], &ldwrkr_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
        &work_[nwork_ - 1], ($24_ = (*lwork_) - nwork_ + 1, &$24_), &ierr_);
        (void) _dbdsdc (_dc_0, _dc_4, n_, s_, &work_[ie_ - 1], u_, ldu_, vt_, ldvt_, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itauq_ - 1], u_, ldu_, 
        &work_[nwork_ - 1], ($25_ = (*lwork_) - nwork_ + 1, &$25_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itaup_ - 1], vt_, ldvt_, 
        &work_[nwork_ - 1], ($26_ = (*lwork_) - nwork_ + 1, &$26_), &ierr_);
        (void) _dlacpy (_dc_16, n_, n_, u_, ldu_, &work_[ir_ - 1], &ldwrkr_);
        (void) _dgemm (_dc_2, _dc_2, m_, n_, n_, ($27_ = 1.0, &$27_), a_, lda_, &work_[ir_ - 1], &ldwrkr_, ($28_ = 0.0, &$28_), 
        u_, ldu_);
      }
      else if (wntqa_) {
        iu_ = 1;
        ldwrku_ = (*n_);
        itau_ = iu_ + ldwrku_ * (*n_);
        nwork_ = itau_ + (*n_);
        (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($29_ = (*lwork_) - nwork_ + 1, &$29_), 
        &ierr_);
        (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
        (void) _dorgqr (m_, m_, n_, u_, ldu_, &work_[itau_ - 1], &work_[nwork_ - 1], ($30_ = (*lwork_) - nwork_ + 1, &$30_), 
        &ierr_);
        (void) _dlaset (_dc_1, ($31_ = (*n_) - 1, &$31_), ($32_ = (*n_) - 1, &$32_), ($33_ = 0.0, &$33_), ($34_ = 0.0, &$34_), 
        &a_[1 + ((*lda_)) * ((0))], lda_);
        ie_ = itau_;
        itauq_ = ie_ + (*n_);
        itaup_ = itauq_ + (*n_);
        nwork_ = itaup_ + (*n_);
        (void) _dgebrd (n_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[nwork_ - 1], 
        ($35_ = (*lwork_) - nwork_ + 1, &$35_), &ierr_);
        (void) _dbdsdc (_dc_0, _dc_4, n_, s_, &work_[ie_ - 1], &work_[iu_ - 1], n_, vt_, ldvt_, dum_, idum_, &work_[nwork_ - 
        1], iwork_, info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, n_, n_, n_, a_, lda_, &work_[itauq_ - 1], &work_[iu_ - 1], &ldwrku_, 
        &work_[nwork_ - 1], ($36_ = (*lwork_) - nwork_ + 1, &$36_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, n_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[nwork_ - 1], ($37_ 
        = (*lwork_) - nwork_ + 1, &$37_), &ierr_);
        (void) _dgemm (_dc_2, _dc_2, m_, n_, n_, ($38_ = 1.0, &$38_), u_, ldu_, &work_[iu_ - 1], &ldwrku_, ($39_ = 0.0, &$39_), 
        a_, lda_);
        (void) _dlacpy (_dc_16, m_, n_, a_, lda_, u_, ldu_);
      }
    }
    else {
      ie_ = 1;
      itauq_ = ie_ + (*n_);
      itaup_ = itauq_ + (*n_);
      nwork_ = itaup_ + (*n_);
      (void) _dgebrd (m_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[nwork_ - 1], 
      ($40_ = (*lwork_) - nwork_ + 1, &$40_), &ierr_);
      if (wntqn_) {
        (void) _dbdsdc (_dc_0, _dc_2, n_, s_, &work_[ie_ - 1], dum_, &_k1, dum_, &_k1, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
      }
      else if (wntqo_) {
        iu_ = nwork_;
        if ((*lwork_) >= (*m_) * (*n_) + 3 * (*n_) + bdspac_) {
          ldwrku_ = (*m_);
          nwork_ = iu_ + ldwrku_ * (*n_);
          (void) _dlaset (_dc_16, m_, n_, ($41_ = 0.0, &$41_), ($42_ = 0.0, &$42_), &work_[iu_ - 1], &ldwrku_);
          ir_ = -1;
        }
        else {
          ldwrku_ = (*n_);
          nwork_ = iu_ + ldwrku_ * (*n_);
          ir_ = nwork_;
          ldwrkr_ = ((*lwork_) - (*n_) * (*n_) - 3 * (*n_)) / (*n_);
        }
        nwork_ = iu_ + ldwrku_ * (*n_);
        (void) _dbdsdc (_dc_0, _dc_4, n_, s_, &work_[ie_ - 1], &work_[iu_ - 1], &ldwrku_, vt_, ldvt_, dum_, idum_, 
        &work_[nwork_ - 1], iwork_, info_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, n_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[nwork_ - 1], ($43_ 
        = (*lwork_) - nwork_ + 1, &$43_), &ierr_);
        if ((*lwork_) >= (*m_) * (*n_) + 3 * (*n_) + bdspac_) {
          (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], &work_[iu_ - 1], &ldwrku_, 
          &work_[nwork_ - 1], ($44_ = (*lwork_) - nwork_ + 1, &$44_), &ierr_);
          (void) _dlacpy (_dc_16, m_, n_, &work_[iu_ - 1], &ldwrku_, a_, lda_);
        }
        else {
          (void) _dorgbr (_dc_53, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], &work_[nwork_ - 1], ($45_ = (*lwork_) - nwork_ + 1, 
          &$45_), &ierr_);
          for (i_ = 1; (ldwrkr_ > 0 ? i_ <= (*m_) : i_ >= (*m_)); i_ += ldwrkr_) {
            chunk_ = _min ((*m_) - i_ + 1, ldwrkr_);
            (void) _dgemm (_dc_2, _dc_2, &chunk_, n_, n_, ($46_ = 1.0, &$46_), &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &work_[iu_ - 
            1], &ldwrku_, ($47_ = 0.0, &$47_), &work_[ir_ - 1], &ldwrkr_);
            (void) _dlacpy (_dc_16, &chunk_, n_, &work_[ir_ - 1], &ldwrkr_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_);
          }
        }
      }
      else if (wntqs_) {
        (void) _dlaset (_dc_16, m_, n_, ($48_ = 0.0, &$48_), ($49_ = 0.0, &$49_), u_, ldu_);
        (void) _dbdsdc (_dc_0, _dc_4, n_, s_, &work_[ie_ - 1], u_, ldu_, vt_, ldvt_, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[nwork_ - 1], ($50_ = 
        (*lwork_) - nwork_ + 1, &$50_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, n_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[nwork_ - 1], ($51_ 
        = (*lwork_) - nwork_ + 1, &$51_), &ierr_);
      }
      else if (wntqa_) {
        (void) _dlaset (_dc_16, m_, m_, ($52_ = 0.0, &$52_), ($53_ = 0.0, &$53_), u_, ldu_);
        (void) _dbdsdc (_dc_0, _dc_4, n_, s_, &work_[ie_ - 1], u_, ldu_, vt_, ldvt_, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
        if ((*m_) > (*n_)) {
          (void) _dlaset (_dc_16, ($54_ = (*m_) - (*n_), &$54_), ($55_ = (*m_) - (*n_), &$55_), ($56_ = 0.0, &$56_), ($57_ = 1.0, 
          &$57_), &u_[(*n_) + 1 - 1 + ((*ldu_)) * (((*n_) + 1 - 1))], ldu_);
        }
        (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[nwork_ - 1], ($58_ = 
        (*lwork_) - nwork_ + 1, &$58_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, m_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[nwork_ - 1], ($59_ 
        = (*lwork_) - nwork_ + 1, &$59_), &ierr_);
      }
    }
  }
  else {
    if ((*n_) >= mnthr_) {
      if (wntqn_) {
        itau_ = 1;
        nwork_ = itau_ + (*m_);
        (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($60_ = (*lwork_) - nwork_ + 1, &$60_), 
        &ierr_);
        (void) _dlaset (_dc_0, ($61_ = (*m_) - 1, &$61_), ($62_ = (*m_) - 1, &$62_), ($63_ = 0.0, &$63_), ($64_ = 0.0, &$64_), 
        &a_[0 + ((*lda_)) * ((1))], lda_);
        ie_ = 1;
        itauq_ = ie_ + (*m_);
        itaup_ = itauq_ + (*m_);
        nwork_ = itaup_ + (*m_);
        (void) _dgebrd (m_, m_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[nwork_ - 1], 
        ($65_ = (*lwork_) - nwork_ + 1, &$65_), &ierr_);
        nwork_ = ie_ + (*m_);
        (void) _dbdsdc (_dc_0, _dc_2, m_, s_, &work_[ie_ - 1], dum_, &_k1, dum_, &_k1, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
      }
      else if (wntqo_) {
        ivt_ = 1;
        il_ = ivt_ + (*m_) * (*m_);
        if ((*lwork_) >= (*m_) * (*n_) + (*m_) * (*m_) + 3 * (*m_) + bdspac_) {
          ldwrkl_ = (*m_);
          chunk_ = (*n_);
        }
        else {
          ldwrkl_ = (*m_);
          chunk_ = ((*lwork_) - (*m_) * (*m_)) / (*m_);
        }
        itau_ = il_ + ldwrkl_ * (*m_);
        nwork_ = itau_ + (*m_);
        (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($66_ = (*lwork_) - nwork_ + 1, &$66_), 
        &ierr_);
        (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[il_ - 1], &ldwrkl_);
        (void) _dlaset (_dc_0, ($67_ = (*m_) - 1, &$67_), ($68_ = (*m_) - 1, &$68_), ($69_ = 0.0, &$69_), ($70_ = 0.0, &$70_), 
        &work_[il_ + ldwrkl_ - 1], &ldwrkl_);
        (void) _dorglq (m_, n_, m_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($71_ = (*lwork_) - nwork_ + 1, &$71_), 
        &ierr_);
        ie_ = itau_;
        itauq_ = ie_ + (*m_);
        itaup_ = itauq_ + (*m_);
        nwork_ = itaup_ + (*m_);
        (void) _dgebrd (m_, m_, &work_[il_ - 1], &ldwrkl_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
        &work_[nwork_ - 1], ($72_ = (*lwork_) - nwork_ + 1, &$72_), &ierr_);
        (void) _dbdsdc (_dc_0, _dc_4, m_, s_, &work_[ie_ - 1], u_, ldu_, &work_[ivt_ - 1], m_, dum_, idum_, &work_[nwork_ - 1], 
        iwork_, info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, m_, &work_[il_ - 1], &ldwrkl_, &work_[itauq_ - 1], u_, ldu_, 
        &work_[nwork_ - 1], ($73_ = (*lwork_) - nwork_ + 1, &$73_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, m_, m_, m_, &work_[il_ - 1], &ldwrkl_, &work_[itaup_ - 1], &work_[ivt_ - 1], m_, 
        &work_[nwork_ - 1], ($74_ = (*lwork_) - nwork_ + 1, &$74_), &ierr_);
        for (i_ = 1; (chunk_ > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += chunk_) {
          blk_ = _min ((*n_) - i_ + 1, chunk_);
          (void) _dgemm (_dc_2, _dc_2, m_, &blk_, m_, ($75_ = 1.0, &$75_), &work_[ivt_ - 1], m_, &a_[0 + ((*lda_)) * ((i_ - 1))], 
          lda_, ($76_ = 0.0, &$76_), &work_[il_ - 1], &ldwrkl_);
          (void) _dlacpy (_dc_16, m_, &blk_, &work_[il_ - 1], &ldwrkl_, &a_[0 + ((*lda_)) * ((i_ - 1))], lda_);
        }
      }
      else if (wntqs_) {
        il_ = 1;
        ldwrkl_ = (*m_);
        itau_ = il_ + ldwrkl_ * (*m_);
        nwork_ = itau_ + (*m_);
        (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($77_ = (*lwork_) - nwork_ + 1, &$77_), 
        &ierr_);
        (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[il_ - 1], &ldwrkl_);
        (void) _dlaset (_dc_0, ($78_ = (*m_) - 1, &$78_), ($79_ = (*m_) - 1, &$79_), ($80_ = 0.0, &$80_), ($81_ = 0.0, &$81_), 
        &work_[il_ + ldwrkl_ - 1], &ldwrkl_);
        (void) _dorglq (m_, n_, m_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($82_ = (*lwork_) - nwork_ + 1, &$82_), 
        &ierr_);
        ie_ = itau_;
        itauq_ = ie_ + (*m_);
        itaup_ = itauq_ + (*m_);
        nwork_ = itaup_ + (*m_);
        (void) _dgebrd (m_, m_, &work_[il_ - 1], &ldwrkl_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
        &work_[nwork_ - 1], ($83_ = (*lwork_) - nwork_ + 1, &$83_), &ierr_);
        (void) _dbdsdc (_dc_0, _dc_4, m_, s_, &work_[ie_ - 1], u_, ldu_, vt_, ldvt_, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, m_, &work_[il_ - 1], &ldwrkl_, &work_[itauq_ - 1], u_, ldu_, 
        &work_[nwork_ - 1], ($84_ = (*lwork_) - nwork_ + 1, &$84_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, m_, m_, m_, &work_[il_ - 1], &ldwrkl_, &work_[itaup_ - 1], vt_, ldvt_, 
        &work_[nwork_ - 1], ($85_ = (*lwork_) - nwork_ + 1, &$85_), &ierr_);
        (void) _dlacpy (_dc_16, m_, m_, vt_, ldvt_, &work_[il_ - 1], &ldwrkl_);
        (void) _dgemm (_dc_2, _dc_2, m_, n_, m_, ($86_ = 1.0, &$86_), &work_[il_ - 1], &ldwrkl_, a_, lda_, ($87_ = 0.0, &$87_), 
        vt_, ldvt_);
      }
      else if (wntqa_) {
        ivt_ = 1;
        ldwkvt_ = (*m_);
        itau_ = ivt_ + ldwkvt_ * (*m_);
        nwork_ = itau_ + (*m_);
        (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[nwork_ - 1], ($88_ = (*lwork_) - nwork_ + 1, &$88_), 
        &ierr_);
        (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
        (void) _dorglq (n_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[nwork_ - 1], ($89_ = (*lwork_) - nwork_ + 1, &$89_), 
        &ierr_);
        (void) _dlaset (_dc_0, ($90_ = (*m_) - 1, &$90_), ($91_ = (*m_) - 1, &$91_), ($92_ = 0.0, &$92_), ($93_ = 0.0, &$93_), 
        &a_[0 + ((*lda_)) * ((1))], lda_);
        ie_ = itau_;
        itauq_ = ie_ + (*m_);
        itaup_ = itauq_ + (*m_);
        nwork_ = itaup_ + (*m_);
        (void) _dgebrd (m_, m_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[nwork_ - 1], 
        ($94_ = (*lwork_) - nwork_ + 1, &$94_), &ierr_);
        (void) _dbdsdc (_dc_0, _dc_4, m_, s_, &work_[ie_ - 1], u_, ldu_, &work_[ivt_ - 1], &ldwkvt_, dum_, idum_, &work_[nwork_ 
        - 1], iwork_, info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, m_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[nwork_ - 1], ($95_ = 
        (*lwork_) - nwork_ + 1, &$95_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, m_, m_, m_, a_, lda_, &work_[itaup_ - 1], &work_[ivt_ - 1], &ldwkvt_, 
        &work_[nwork_ - 1], ($96_ = (*lwork_) - nwork_ + 1, &$96_), &ierr_);
        (void) _dgemm (_dc_2, _dc_2, m_, n_, m_, ($97_ = 1.0, &$97_), &work_[ivt_ - 1], &ldwkvt_, vt_, ldvt_, ($98_ = 0.0, 
        &$98_), a_, lda_);
        (void) _dlacpy (_dc_16, m_, n_, a_, lda_, vt_, ldvt_);
      }
    }
    else {
      ie_ = 1;
      itauq_ = ie_ + (*m_);
      itaup_ = itauq_ + (*m_);
      nwork_ = itaup_ + (*m_);
      (void) _dgebrd (m_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[nwork_ - 1], 
      ($99_ = (*lwork_) - nwork_ + 1, &$99_), &ierr_);
      if (wntqn_) {
        (void) _dbdsdc (_dc_1, _dc_2, m_, s_, &work_[ie_ - 1], dum_, &_k1, dum_, &_k1, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
      }
      else if (wntqo_) {
        ldwkvt_ = (*m_);
        ivt_ = nwork_;
        if ((*lwork_) >= (*m_) * (*n_) + 3 * (*m_) + bdspac_) {
          (void) _dlaset (_dc_16, m_, n_, ($100_ = 0.0, &$100_), ($101_ = 0.0, &$101_), &work_[ivt_ - 1], &ldwkvt_);
          nwork_ = ivt_ + ldwkvt_ * (*n_);
          il_ = -1;
        }
        else {
          nwork_ = ivt_ + ldwkvt_ * (*m_);
          il_ = nwork_;
          chunk_ = ((*lwork_) - (*m_) * (*m_) - 3 * (*m_)) / (*m_);
        }
        (void) _dbdsdc (_dc_1, _dc_4, m_, s_, &work_[ie_ - 1], u_, ldu_, &work_[ivt_ - 1], &ldwkvt_, dum_, idum_, &work_[nwork_ 
        - 1], iwork_, info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[nwork_ - 1], ($102_ = 
        (*lwork_) - nwork_ + 1, &$102_), &ierr_);
        if ((*lwork_) >= (*m_) * (*n_) + 3 * (*m_) + bdspac_) {
          (void) _dormbr (_dc_3, _dc_15, _dc_25, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], &work_[ivt_ - 1], &ldwkvt_, 
          &work_[nwork_ - 1], ($103_ = (*lwork_) - nwork_ + 1, &$103_), &ierr_);
          (void) _dlacpy (_dc_16, m_, n_, &work_[ivt_ - 1], &ldwkvt_, a_, lda_);
        }
        else {
          (void) _dorgbr (_dc_3, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], &work_[nwork_ - 1], ($104_ = (*lwork_) - nwork_ + 1, 
          &$104_), &ierr_);
          for (i_ = 1; (chunk_ > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += chunk_) {
            blk_ = _min ((*n_) - i_ + 1, chunk_);
            (void) _dgemm (_dc_2, _dc_2, m_, &blk_, m_, ($105_ = 1.0, &$105_), &work_[ivt_ - 1], &ldwkvt_, &a_[0 + ((*lda_)) * ((i_ 
            - 1))], lda_, ($106_ = 0.0, &$106_), &work_[il_ - 1], m_);
            (void) _dlacpy (_dc_16, m_, &blk_, &work_[il_ - 1], m_, &a_[0 + ((*lda_)) * ((i_ - 1))], lda_);
          }
        }
      }
      else if (wntqs_) {
        (void) _dlaset (_dc_16, m_, n_, ($107_ = 0.0, &$107_), ($108_ = 0.0, &$108_), vt_, ldvt_);
        (void) _dbdsdc (_dc_1, _dc_4, m_, s_, &work_[ie_ - 1], u_, ldu_, vt_, ldvt_, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
        (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[nwork_ - 1], ($109_ = 
        (*lwork_) - nwork_ + 1, &$109_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[nwork_ - 1], ($110_ 
        = (*lwork_) - nwork_ + 1, &$110_), &ierr_);
      }
      else if (wntqa_) {
        (void) _dlaset (_dc_16, n_, n_, ($111_ = 0.0, &$111_), ($112_ = 0.0, &$112_), vt_, ldvt_);
        (void) _dbdsdc (_dc_1, _dc_4, m_, s_, &work_[ie_ - 1], u_, ldu_, vt_, ldvt_, dum_, idum_, &work_[nwork_ - 1], iwork_, 
        info_);
        if ((*n_) > (*m_)) {
          (void) _dlaset (_dc_16, ($113_ = (*n_) - (*m_), &$113_), ($114_ = (*n_) - (*m_), &$114_), ($115_ = 0.0, &$115_), ($116_ 
          = 1.0, &$116_), &vt_[(*m_) + 1 - 1 + ((*ldvt_)) * (((*m_) + 1 - 1))], ldvt_);
        }
        (void) _dormbr (_dc_53, _dc_1, _dc_2, m_, m_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[nwork_ - 1], ($117_ = 
        (*lwork_) - nwork_ + 1, &$117_), &ierr_);
        (void) _dormbr (_dc_3, _dc_15, _dc_25, n_, n_, m_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[nwork_ - 1], ($118_ 
        = (*lwork_) - nwork_ + 1, &$118_), &ierr_);
      }
    }
  }
  if (iscl_ == 1) {
    if (anrm_ > bignum_) {
      (void) _dlascl (_dc_9, &_k0, &_k0, &bignum_, &anrm_, &minmn_, &_k1, s_, &minmn_, &ierr_);
    }
    if (anrm_ < smlnum_) {
      (void) _dlascl (_dc_9, &_k0, &_k0, &smlnum_, &anrm_, &minmn_, &_k1, s_, &minmn_, &ierr_);
    }
  }
  work_[0] = maxwrk_;
  _l0:;
  __calls[13].calls++;
  return 0;
}
int_4 _dgesvd (char _p_ jobu_, char _p_ jobvt_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ 
s_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_
)
{
  static int_4 bdspac_, blk_, chunk_, i_, ie_, ierr_, ir_, iscl_, itau_, itaup_, itauq_, iu_, iwork_, ldwrkr_, ldwrku_, 
  maxwrk_, minmn_, minwrk_, mnthr_, ncu_, ncvt_, nru_, nrvt_, wrkbl_, lwork_dgeqrf_, lwork_dorgqr_n_, lwork_dorgqr_m_, 
  lwork_dgebrd_, lwork_dorgbr_p_, lwork_dorgbr_q_, lwork_dgelqf_, lwork_dorglq_n_, lwork_dorglq_m_;
  static logical_4 lquery_, wntua_, wntuas_, wntun_, wntuo_, wntus_, wntva_, wntvas_, wntvn_, wntvo_, wntvs_;
  static real_8 anrm_, bignum_, eps_, smlnum_, dum_[1];
  int_4 $0_, $3_, $6_, $7_, $8_, $9_, $12_, $13_, $14_, $15_, $16_, $19_, $20_, $21_, $24_, $25_, $26_, $27_, $28_, $31_, 
  $32_, $33_, $34_, $37_, $38_, $39_, $42_, $43_, $44_, $45_, $46_, $47_, $48_, $51_, $52_, $53_, $56_, $57_, $58_, $59_, 
  $62_, $63_, $64_, $65_, $66_, $69_, $70_, $71_, $72_, $75_, $76_, $77_, $78_, $81_, $82_, $83_, $84_, $85_, $86_, $89_, 
  $90_, $91_, $92_, $95_, $96_, $97_, $98_, $101_, $102_, $103_, $104_, $105_, $106_, $107_, $110_, $111_, $112_, $115_, 
  $116_, $117_, $118_, $121_, $122_, $123_, $124_, $125_, $126_, $127_, $130_, $131_, $132_, $135_, $136_, $137_, $138_, 
  $141_, $142_, $143_, $144_, $145_, $146_, $147_, $148_, $151_, $152_, $153_, $156_, $157_, $158_, $159_, $162_, $163_, 
  $164_, $165_, $166_, $167_, $168_, $169_, $170_, $171_, $172_, $175_, $176_, $177_, $178_, $179_, $182_, $183_, $184_, 
  $187_, $188_, $189_, $190_, $191_, $194_, $195_, $196_, $197_, $200_, $201_, $202_, $205_, $206_, $207_, $208_, $209_, 
  $210_, $211_, $214_, $215_, $216_, $219_, $220_, $221_, $222_, $225_, $226_, $227_, $228_, $229_, $232_, $233_, $234_, 
  $235_, $238_, $239_, $240_, $241_, $244_, $245_, $246_, $247_, $248_, $249_, $252_, $253_, $254_, $255_, $258_, $259_, 
  $260_, $261_, $264_, $265_, $266_, $267_, $268_, $269_, $270_, $273_, $274_, $275_, $278_, $279_, $280_, $281_, $284_, 
  $285_, $286_, $287_, $288_, $289_, $290_, $293_, $294_, $295_, $298_, $299_, $300_, $301_, $304_, $305_, $306_, $307_, 
  $308_, $309_, $310_, $311_, $314_, $315_, $316_, $319_, $320_, $321_, $322_, $325_, $326_, $327_, $328_, $329_, $330_, 
  $331_, $332_, $333_, $334_;
  real_8 $10_, $11_, $17_, $18_, $22_, $23_, $29_, $30_, $35_, $36_, $40_, $41_, $49_, $50_, $54_, $55_, $60_, $61_, $67_
  , $68_, $73_, $74_, $79_, $80_, $87_, $88_, $93_, $94_, $99_, $100_, $108_, $109_, $113_, $114_, $119_, $120_, $128_, 
  $129_, $133_, $134_, $139_, $140_, $149_, $150_, $154_, $155_, $160_, $161_, $173_, $174_, $180_, $181_, $185_, $186_, 
  $192_, $193_, $198_, $199_, $203_, $204_, $212_, $213_, $217_, $218_, $223_, $224_, $230_, $231_, $236_, $237_, $242_, 
  $243_, $250_, $251_, $256_, $257_, $262_, $263_, $271_, $272_, $276_, $277_, $282_, $283_, $291_, $292_, $296_, $297_, 
  $302_, $303_, $312_, $313_, $317_, $318_, $323_, $324_;
  char_3 $1_, $2_, $4_, $5_;
  extern int_4 _dgemm ();
  extern int_4 _xerbla ();
  extern logical_4 _lsame ();
  extern real_8 _dlamch ();
  (*info_) = 0;
  minmn_ = _min ((*m_), (*n_));
  wntua_ = _lsame (jobu_, _dc_7);
  wntus_ = _lsame (jobu_, _dc_52);
  wntuas_ = wntua_ || wntus_;
  wntuo_ = _lsame (jobu_, _dc_30);
  wntun_ = _lsame (jobu_, _dc_2);
  wntva_ = _lsame (jobvt_, _dc_7);
  wntvs_ = _lsame (jobvt_, _dc_52);
  wntvas_ = wntva_ || wntvs_;
  wntvo_ = _lsame (jobvt_, _dc_30);
  wntvn_ = _lsame (jobvt_, _dc_2);
  lquery_ = ((*lwork_) == -1);
  if (! ((wntua_ || wntus_ || wntuo_ || wntun_))) {
    (*info_) = -1;
  }
  else if (! ((wntva_ || wntvs_ || wntvo_ || wntvn_)) || (wntvo_ && wntuo_)) {
    (*info_) = -2;
  }
  else if ((*m_) < 0) {
    (*info_) = -3;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -6;
  }
  else if ((*ldu_) < 1 || (wntuas_ && (*ldu_) < (*m_))) {
    (*info_) = -9;
  }
  else if ((*ldvt_) < 1 || (wntva_ && (*ldvt_) < (*n_)) || (wntvs_ && (*ldvt_) < minmn_)) {
    (*info_) = -11;
  }
  if ((*info_) == 0) {
    minwrk_ = 1;
    maxwrk_ = 1;
    if ((*m_) >= (*n_) && minmn_ > 0) {
      mnthr_ = _ilaenv (($0_ = 6, &$0_), _dc_59, (bufcpy ($2_, concat ($1_, jobu_, jobvt_), 3), $2_), m_, n_, &_k0, &_k0);
      bdspac_ = 5 * (*n_);
      (void) _dgeqrf (m_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgeqrf_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgqr (m_, n_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgqr_n_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgqr (m_, m_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgqr_m_ = (int_4) (_aintd (dum_[0]));
      (void) _dgebrd (n_, n_, a_, lda_, s_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgebrd_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgbr (_dc_3, n_, n_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgbr_p_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgbr (_dc_53, n_, n_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgbr_q_ = (int_4) (_aintd (dum_[0]));
      if ((*m_) >= mnthr_) {
        if (wntun_) {
          maxwrk_ = (*n_) + lwork_dgeqrf_;
          maxwrk_ = _max (maxwrk_, 3 * (*n_) + lwork_dgebrd_);
          if (wntvo_ || wntvas_) {
            maxwrk_ = _max (maxwrk_, 3 * (*n_) + lwork_dorgbr_p_);
          }
          maxwrk_ = _max (maxwrk_, bdspac_);
          minwrk_ = _max (4 * (*n_), bdspac_);
        }
        else if (wntuo_ && wntvn_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_n_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = _max ((*n_) * (*n_) + wrkbl_, (*n_) * (*n_) + (*m_) * (*n_) + (*n_));
          minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
        }
        else if (wntuo_ && wntvas_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_n_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = _max ((*n_) * (*n_) + wrkbl_, (*n_) * (*n_) + (*m_) * (*n_) + (*n_));
          minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
        }
        else if (wntus_ && wntvn_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_n_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = (*n_) * (*n_) + wrkbl_;
          minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
        }
        else if (wntus_ && wntvo_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_n_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = 2 * (*n_) * (*n_) + wrkbl_;
          minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
        }
        else if (wntus_ && wntvas_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_n_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = (*n_) * (*n_) + wrkbl_;
          minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
        }
        else if (wntua_ && wntvn_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_m_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = (*n_) * (*n_) + wrkbl_;
          minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
        }
        else if (wntua_ && wntvo_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_m_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = 2 * (*n_) * (*n_) + wrkbl_;
          minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
        }
        else if (wntua_ && wntvas_) {
          wrkbl_ = (*n_) + lwork_dgeqrf_;
          wrkbl_ = _max (wrkbl_, (*n_) + lwork_dorgqr_m_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, 3 * (*n_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = (*n_) * (*n_) + wrkbl_;
          minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
        }
      }
      else {
        (void) _dgebrd (m_, n_, a_, lda_, s_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, &ierr_);
        lwork_dgebrd_ = (int_4) (_aintd (dum_[0]));
        maxwrk_ = 3 * (*n_) + lwork_dgebrd_;
        if (wntus_ || wntuo_) {
          (void) _dorgbr (_dc_53, m_, n_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
          lwork_dorgbr_q_ = (int_4) (_aintd (dum_[0]));
          maxwrk_ = _max (maxwrk_, 3 * (*n_) + lwork_dorgbr_q_);
        }
        if (wntua_) {
          (void) _dorgbr (_dc_53, m_, m_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
          lwork_dorgbr_q_ = (int_4) (_aintd (dum_[0]));
          maxwrk_ = _max (maxwrk_, 3 * (*n_) + lwork_dorgbr_q_);
        }
        if (! (wntvn_)) {
          maxwrk_ = _max (maxwrk_, 3 * (*n_) + lwork_dorgbr_p_);
        }
        maxwrk_ = _max (maxwrk_, bdspac_);
        minwrk_ = _max (3 * (*n_) + (*m_), bdspac_);
      }
    }
    else if (minmn_ > 0) {
      mnthr_ = _ilaenv (($3_ = 6, &$3_), _dc_59, (bufcpy ($5_, concat ($4_, jobu_, jobvt_), 3), $5_), m_, n_, &_k0, &_k0);
      bdspac_ = 5 * (*m_);
      (void) _dgelqf (m_, n_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgelqf_ = (int_4) (_aintd (dum_[0]));
      (void) _dorglq (n_, n_, m_, &dum_[0], n_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorglq_n_ = (int_4) (_aintd (dum_[0]));
      (void) _dorglq (m_, n_, m_, a_, lda_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorglq_m_ = (int_4) (_aintd (dum_[0]));
      (void) _dgebrd (m_, m_, a_, lda_, s_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dgebrd_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgbr (_dc_3, m_, m_, m_, a_, n_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgbr_p_ = (int_4) (_aintd (dum_[0]));
      (void) _dorgbr (_dc_53, m_, m_, m_, a_, n_, &dum_[0], &dum_[0], &_km1, &ierr_);
      lwork_dorgbr_q_ = (int_4) (_aintd (dum_[0]));
      if ((*n_) >= mnthr_) {
        if (wntvn_) {
          maxwrk_ = (*m_) + lwork_dgelqf_;
          maxwrk_ = _max (maxwrk_, 3 * (*m_) + lwork_dgebrd_);
          if (wntuo_ || wntuas_) {
            maxwrk_ = _max (maxwrk_, 3 * (*m_) + lwork_dorgbr_q_);
          }
          maxwrk_ = _max (maxwrk_, bdspac_);
          minwrk_ = _max (4 * (*m_), bdspac_);
        }
        else if (wntvo_ && wntun_) {
          wrkbl_ = (*m_) + lwork_dgelqf_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_m_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = _max ((*m_) * (*m_) + wrkbl_, (*m_) * (*m_) + (*m_) * (*n_) + (*m_));
          minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
        }
        else if (wntvo_ && wntuas_) {
          wrkbl_ = (*m_) + lwork_dgelqf_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_m_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = _max ((*m_) * (*m_) + wrkbl_, (*m_) * (*m_) + (*m_) * (*n_) + (*m_));
          minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
        }
        else if (wntvs_ && wntun_) {
          wrkbl_ = (*m_) + lwork_dgelqf_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_m_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = (*m_) * (*m_) + wrkbl_;
          minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
        }
        else if (wntvs_ && wntuo_) {
          wrkbl_ = (*m_) + lwork_dgelqf_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_m_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = 2 * (*m_) * (*m_) + wrkbl_;
          minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
        }
        else if (wntvs_ && wntuas_) {
          wrkbl_ = (*m_) + lwork_dgelqf_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_m_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = (*m_) * (*m_) + wrkbl_;
          minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
        }
        else if (wntva_ && wntun_) {
          wrkbl_ = (*m_) + lwork_dgelqf_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_n_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = (*m_) * (*m_) + wrkbl_;
          minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
        }
        else if (wntva_ && wntuo_) {
          wrkbl_ = (*m_) + lwork_dgelqf_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_n_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = 2 * (*m_) * (*m_) + wrkbl_;
          minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
        }
        else if (wntva_ && wntuas_) {
          wrkbl_ = (*m_) + lwork_dgelqf_;
          wrkbl_ = _max (wrkbl_, (*m_) + lwork_dorglq_n_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dgebrd_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_p_);
          wrkbl_ = _max (wrkbl_, 3 * (*m_) + lwork_dorgbr_q_);
          wrkbl_ = _max (wrkbl_, bdspac_);
          maxwrk_ = (*m_) * (*m_) + wrkbl_;
          minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
        }
      }
      else {
        (void) _dgebrd (m_, n_, a_, lda_, s_, &dum_[0], &dum_[0], &dum_[0], &dum_[0], &_km1, &ierr_);
        lwork_dgebrd_ = (int_4) (_aintd (dum_[0]));
        maxwrk_ = 3 * (*m_) + lwork_dgebrd_;
        if (wntvs_ || wntvo_) {
          (void) _dorgbr (_dc_3, m_, n_, m_, a_, n_, &dum_[0], &dum_[0], &_km1, &ierr_);
          lwork_dorgbr_p_ = (int_4) (_aintd (dum_[0]));
          maxwrk_ = _max (maxwrk_, 3 * (*m_) + lwork_dorgbr_p_);
        }
        if (wntva_) {
          (void) _dorgbr (_dc_3, n_, n_, m_, a_, n_, &dum_[0], &dum_[0], &_km1, &ierr_);
          lwork_dorgbr_p_ = (int_4) (_aintd (dum_[0]));
          maxwrk_ = _max (maxwrk_, 3 * (*m_) + lwork_dorgbr_p_);
        }
        if (! (wntun_)) {
          maxwrk_ = _max (maxwrk_, 3 * (*m_) + lwork_dorgbr_q_);
        }
        maxwrk_ = _max (maxwrk_, bdspac_);
        minwrk_ = _max (3 * (*m_) + (*n_), bdspac_);
      }
    }
    maxwrk_ = _max (maxwrk_, minwrk_);
    work_[0] = maxwrk_;
    if ((*lwork_) < minwrk_ && ! (lquery_)) {
      (*info_) = -13;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_59, ($6_ = -(*info_), &$6_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  eps_ = _dlamch (_dc_3);
  smlnum_ = sqrt (_dlamch (_dc_52)) / eps_;
  bignum_ = 1.0 / smlnum_;
  anrm_ = _dlange (_dc_8, m_, n_, a_, lda_, dum_);
  iscl_ = 0;
  if (anrm_ > 0.0 && anrm_ < smlnum_) {
    iscl_ = 1;
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &smlnum_, m_, n_, a_, lda_, &ierr_);
  }
  else if (anrm_ > bignum_) {
    iscl_ = 1;
    (void) _dlascl (_dc_9, &_k0, &_k0, &anrm_, &bignum_, m_, n_, a_, lda_, &ierr_);
  }
  if ((*m_) >= (*n_)) {
    if ((*m_) >= mnthr_) {
      if (wntun_) {
        itau_ = 1;
        iwork_ = itau_ + (*n_);
        (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($7_ = (*lwork_) - iwork_ + 1, &$7_), &ierr_)
        ;
        if ((*n_) > 1) {
          (void) _dlaset (_dc_1, ($8_ = (*n_) - 1, &$8_), ($9_ = (*n_) - 1, &$9_), ($10_ = 0.0, &$10_), ($11_ = 0.0, &$11_), 
          &a_[1 + ((*lda_)) * ((0))], lda_);
        }
        ie_ = 1;
        itauq_ = ie_ + (*n_);
        itaup_ = itauq_ + (*n_);
        iwork_ = itaup_ + (*n_);
        (void) _dgebrd (n_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
        ($12_ = (*lwork_) - iwork_ + 1, &$12_), &ierr_);
        ncvt_ = 0;
        if (wntvo_ || wntvas_) {
          (void) _dorgbr (_dc_3, n_, n_, n_, a_, lda_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($13_ = (*lwork_) - iwork_ + 1, 
          &$13_), &ierr_);
          ncvt_ = (*n_);
        }
        iwork_ = ie_ + (*n_);
        (void) _dbdsqr (_dc_0, n_, &ncvt_, &_k0, &_k0, s_, &work_[ie_ - 1], a_, lda_, dum_, &_k1, dum_, &_k1, &work_[iwork_ - 
        1], info_);
        if (wntvas_) {
          (void) _dlacpy (_dc_16, n_, n_, a_, lda_, vt_, ldvt_);
        }
      }
      else if (wntuo_ && wntvn_) {
        if ((*lwork_) >= (*n_) * (*n_) + _max (4 * (*n_), bdspac_)) {
          ir_ = 1;
          if ((*lwork_) >= _max (wrkbl_, (*lda_) * (*n_) + (*n_)) + (*lda_) * (*n_)) {
            ldwrku_ = (*lda_);
            ldwrkr_ = (*lda_);
          }
          else if ((*lwork_) >= _max (wrkbl_, (*lda_) * (*n_) + (*n_)) + (*n_) * (*n_)) {
            ldwrku_ = (*lda_);
            ldwrkr_ = (*n_);
          }
          else {
            ldwrku_ = ((*lwork_) - (*n_) * (*n_) - (*n_)) / (*n_);
            ldwrkr_ = (*n_);
          }
          itau_ = ir_ + ldwrkr_ * (*n_);
          iwork_ = itau_ + (*n_);
          (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($14_ = (*lwork_) - iwork_ + 1, &$14_), 
          &ierr_);
          (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[ir_ - 1], &ldwrkr_);
          (void) _dlaset (_dc_1, ($15_ = (*n_) - 1, &$15_), ($16_ = (*n_) - 1, &$16_), ($17_ = 0.0, &$17_), ($18_ = 0.0, &$18_), 
          &work_[ir_ + 1 - 1], &ldwrkr_);
          (void) _dorgqr (m_, n_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($19_ = (*lwork_) - iwork_ + 1, &$19_), 
          &ierr_);
          ie_ = itau_;
          itauq_ = ie_ + (*n_);
          itaup_ = itauq_ + (*n_);
          iwork_ = itaup_ + (*n_);
          (void) _dgebrd (n_, n_, &work_[ir_ - 1], &ldwrkr_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
          &work_[iwork_ - 1], ($20_ = (*lwork_) - iwork_ + 1, &$20_), &ierr_);
          (void) _dorgbr (_dc_53, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($21_ = 
          (*lwork_) - iwork_ + 1, &$21_), &ierr_);
          iwork_ = ie_ + (*n_);
          (void) _dbdsqr (_dc_0, n_, &_k0, n_, &_k0, s_, &work_[ie_ - 1], dum_, &_k1, &work_[ir_ - 1], &ldwrkr_, dum_, &_k1, 
          &work_[iwork_ - 1], info_);
          iu_ = ie_ + (*n_);
          for (i_ = 1; (ldwrku_ > 0 ? i_ <= (*m_) : i_ >= (*m_)); i_ += ldwrku_) {
            chunk_ = _min ((*m_) - i_ + 1, ldwrku_);
            (void) _dgemm (_dc_2, _dc_2, &chunk_, n_, n_, ($22_ = 1.0, &$22_), &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &work_[ir_ - 
            1], &ldwrkr_, ($23_ = 0.0, &$23_), &work_[iu_ - 1], &ldwrku_);
            (void) _dlacpy (_dc_16, &chunk_, n_, &work_[iu_ - 1], &ldwrku_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_);
          }
        }
        else {
          ie_ = 1;
          itauq_ = ie_ + (*n_);
          itaup_ = itauq_ + (*n_);
          iwork_ = itaup_ + (*n_);
          (void) _dgebrd (m_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
          ($24_ = (*lwork_) - iwork_ + 1, &$24_), &ierr_);
          (void) _dorgbr (_dc_53, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($25_ = (*lwork_) - iwork_ + 1, 
          &$25_), &ierr_);
          iwork_ = ie_ + (*n_);
          (void) _dbdsqr (_dc_0, n_, &_k0, m_, &_k0, s_, &work_[ie_ - 1], dum_, &_k1, a_, lda_, dum_, &_k1, &work_[iwork_ - 1], 
          info_);
        }
      }
      else if (wntuo_ && wntvas_) {
        if ((*lwork_) >= (*n_) * (*n_) + _max (4 * (*n_), bdspac_)) {
          ir_ = 1;
          if ((*lwork_) >= _max (wrkbl_, (*lda_) * (*n_) + (*n_)) + (*lda_) * (*n_)) {
            ldwrku_ = (*lda_);
            ldwrkr_ = (*lda_);
          }
          else if ((*lwork_) >= _max (wrkbl_, (*lda_) * (*n_) + (*n_)) + (*n_) * (*n_)) {
            ldwrku_ = (*lda_);
            ldwrkr_ = (*n_);
          }
          else {
            ldwrku_ = ((*lwork_) - (*n_) * (*n_) - (*n_)) / (*n_);
            ldwrkr_ = (*n_);
          }
          itau_ = ir_ + ldwrkr_ * (*n_);
          iwork_ = itau_ + (*n_);
          (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($26_ = (*lwork_) - iwork_ + 1, &$26_), 
          &ierr_);
          (void) _dlacpy (_dc_0, n_, n_, a_, lda_, vt_, ldvt_);
          if ((*n_) > 1) {
            (void) _dlaset (_dc_1, ($27_ = (*n_) - 1, &$27_), ($28_ = (*n_) - 1, &$28_), ($29_ = 0.0, &$29_), ($30_ = 0.0, &$30_), 
            &vt_[1 + ((*ldvt_)) * ((0))], ldvt_);
          }
          (void) _dorgqr (m_, n_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($31_ = (*lwork_) - iwork_ + 1, &$31_), 
          &ierr_);
          ie_ = itau_;
          itauq_ = ie_ + (*n_);
          itaup_ = itauq_ + (*n_);
          iwork_ = itaup_ + (*n_);
          (void) _dgebrd (n_, n_, vt_, ldvt_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
          ($32_ = (*lwork_) - iwork_ + 1, &$32_), &ierr_);
          (void) _dlacpy (_dc_1, n_, n_, vt_, ldvt_, &work_[ir_ - 1], &ldwrkr_);
          (void) _dorgbr (_dc_53, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($33_ = 
          (*lwork_) - iwork_ + 1, &$33_), &ierr_);
          (void) _dorgbr (_dc_3, n_, n_, n_, vt_, ldvt_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($34_ = (*lwork_) - iwork_ + 1, 
          &$34_), &ierr_);
          iwork_ = ie_ + (*n_);
          (void) _dbdsqr (_dc_0, n_, n_, n_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, &work_[ir_ - 1], &ldwrkr_, dum_, &_k1, 
          &work_[iwork_ - 1], info_);
          iu_ = ie_ + (*n_);
          for (i_ = 1; (ldwrku_ > 0 ? i_ <= (*m_) : i_ >= (*m_)); i_ += ldwrku_) {
            chunk_ = _min ((*m_) - i_ + 1, ldwrku_);
            (void) _dgemm (_dc_2, _dc_2, &chunk_, n_, n_, ($35_ = 1.0, &$35_), &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, &work_[ir_ - 
            1], &ldwrkr_, ($36_ = 0.0, &$36_), &work_[iu_ - 1], &ldwrku_);
            (void) _dlacpy (_dc_16, &chunk_, n_, &work_[iu_ - 1], &ldwrku_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_);
          }
        }
        else {
          itau_ = 1;
          iwork_ = itau_ + (*n_);
          (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($37_ = (*lwork_) - iwork_ + 1, &$37_), 
          &ierr_);
          (void) _dlacpy (_dc_0, n_, n_, a_, lda_, vt_, ldvt_);
          if ((*n_) > 1) {
            (void) _dlaset (_dc_1, ($38_ = (*n_) - 1, &$38_), ($39_ = (*n_) - 1, &$39_), ($40_ = 0.0, &$40_), ($41_ = 0.0, &$41_), 
            &vt_[1 + ((*ldvt_)) * ((0))], ldvt_);
          }
          (void) _dorgqr (m_, n_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($42_ = (*lwork_) - iwork_ + 1, &$42_), 
          &ierr_);
          ie_ = itau_;
          itauq_ = ie_ + (*n_);
          itaup_ = itauq_ + (*n_);
          iwork_ = itaup_ + (*n_);
          (void) _dgebrd (n_, n_, vt_, ldvt_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
          ($43_ = (*lwork_) - iwork_ + 1, &$43_), &ierr_);
          (void) _dormbr (_dc_53, _dc_15, _dc_2, m_, n_, n_, vt_, ldvt_, &work_[itauq_ - 1], a_, lda_, &work_[iwork_ - 1], ($44_ 
          = (*lwork_) - iwork_ + 1, &$44_), &ierr_);
          (void) _dorgbr (_dc_3, n_, n_, n_, vt_, ldvt_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($45_ = (*lwork_) - iwork_ + 1, 
          &$45_), &ierr_);
          iwork_ = ie_ + (*n_);
          (void) _dbdsqr (_dc_0, n_, n_, m_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, a_, lda_, dum_, &_k1, &work_[iwork_ - 1], 
          info_);
        }
      }
      else if (wntus_) {
        if (wntvn_) {
          if ((*lwork_) >= (*n_) * (*n_) + _max (4 * (*n_), bdspac_)) {
            ir_ = 1;
            if ((*lwork_) >= wrkbl_ + (*lda_) * (*n_)) {
              ldwrkr_ = (*lda_);
            }
            else {
              ldwrkr_ = (*n_);
            }
            itau_ = ir_ + ldwrkr_ * (*n_);
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($46_ = (*lwork_) - iwork_ + 1, &$46_), 
            &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[ir_ - 1], &ldwrkr_);
            (void) _dlaset (_dc_1, ($47_ = (*n_) - 1, &$47_), ($48_ = (*n_) - 1, &$48_), ($49_ = 0.0, &$49_), ($50_ = 0.0, &$50_), 
            &work_[ir_ + 1 - 1], &ldwrkr_);
            (void) _dorgqr (m_, n_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($51_ = (*lwork_) - iwork_ + 1, &$51_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            (void) _dgebrd (n_, n_, &work_[ir_ - 1], &ldwrkr_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($52_ = (*lwork_) - iwork_ + 1, &$52_), &ierr_);
            (void) _dorgbr (_dc_53, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($53_ = 
            (*lwork_) - iwork_ + 1, &$53_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, &_k0, n_, &_k0, s_, &work_[ie_ - 1], dum_, &_k1, &work_[ir_ - 1], &ldwrkr_, dum_, &_k1, 
            &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, n_, ($54_ = 1.0, &$54_), a_, lda_, &work_[ir_ - 1], &ldwrkr_, ($55_ = 0.0, &$55_), 
            u_, ldu_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($56_ = (*lwork_) - iwork_ + 1, &$56_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dorgqr (m_, n_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($57_ = (*lwork_) - iwork_ + 1, &$57_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            if ((*n_) > 1) {
              (void) _dlaset (_dc_1, ($58_ = (*n_) - 1, &$58_), ($59_ = (*n_) - 1, &$59_), ($60_ = 0.0, &$60_), ($61_ = 0.0, &$61_), 
              &a_[1 + ((*lda_)) * ((0))], lda_);
            }
            (void) _dgebrd (n_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($62_ = (*lwork_) - iwork_ + 1, &$62_), &ierr_);
            (void) _dormbr (_dc_53, _dc_15, _dc_2, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[iwork_ - 1], ($63_ = 
            (*lwork_) - iwork_ + 1, &$63_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, &_k0, m_, &_k0, s_, &work_[ie_ - 1], dum_, &_k1, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
        else if (wntvo_) {
          if ((*lwork_) >= 2 * (*n_) * (*n_) + _max (4 * (*n_), bdspac_)) {
            iu_ = 1;
            if ((*lwork_) >= wrkbl_ + 2 * (*lda_) * (*n_)) {
              ldwrku_ = (*lda_);
              ir_ = iu_ + ldwrku_ * (*n_);
              ldwrkr_ = (*lda_);
            }
            else if ((*lwork_) >= wrkbl_ + ((*lda_) + (*n_)) * (*n_)) {
              ldwrku_ = (*lda_);
              ir_ = iu_ + ldwrku_ * (*n_);
              ldwrkr_ = (*n_);
            }
            else {
              ldwrku_ = (*n_);
              ir_ = iu_ + ldwrku_ * (*n_);
              ldwrkr_ = (*n_);
            }
            itau_ = ir_ + ldwrkr_ * (*n_);
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($64_ = (*lwork_) - iwork_ + 1, &$64_), 
            &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[iu_ - 1], &ldwrku_);
            (void) _dlaset (_dc_1, ($65_ = (*n_) - 1, &$65_), ($66_ = (*n_) - 1, &$66_), ($67_ = 0.0, &$67_), ($68_ = 0.0, &$68_), 
            &work_[iu_ + 1 - 1], &ldwrku_);
            (void) _dorgqr (m_, n_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($69_ = (*lwork_) - iwork_ + 1, &$69_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            (void) _dgebrd (n_, n_, &work_[iu_ - 1], &ldwrku_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($70_ = (*lwork_) - iwork_ + 1, &$70_), &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, &work_[iu_ - 1], &ldwrku_, &work_[ir_ - 1], &ldwrkr_);
            (void) _dorgbr (_dc_53, n_, n_, n_, &work_[iu_ - 1], &ldwrku_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($71_ = 
            (*lwork_) - iwork_ + 1, &$71_), &ierr_);
            (void) _dorgbr (_dc_3, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($72_ = (*lwork_) 
            - iwork_ + 1, &$72_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, n_, n_, &_k0, s_, &work_[ie_ - 1], &work_[ir_ - 1], &ldwrkr_, &work_[iu_ - 1], &ldwrku_, 
            dum_, &_k1, &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, n_, ($73_ = 1.0, &$73_), a_, lda_, &work_[iu_ - 1], &ldwrku_, ($74_ = 0.0, &$74_), 
            u_, ldu_);
            (void) _dlacpy (_dc_16, n_, n_, &work_[ir_ - 1], &ldwrkr_, a_, lda_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($75_ = (*lwork_) - iwork_ + 1, &$75_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dorgqr (m_, n_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($76_ = (*lwork_) - iwork_ + 1, &$76_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            if ((*n_) > 1) {
              (void) _dlaset (_dc_1, ($77_ = (*n_) - 1, &$77_), ($78_ = (*n_) - 1, &$78_), ($79_ = 0.0, &$79_), ($80_ = 0.0, &$80_), 
              &a_[1 + ((*lda_)) * ((0))], lda_);
            }
            (void) _dgebrd (n_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($81_ = (*lwork_) - iwork_ + 1, &$81_), &ierr_);
            (void) _dormbr (_dc_53, _dc_15, _dc_2, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[iwork_ - 1], ($82_ = 
            (*lwork_) - iwork_ + 1, &$82_), &ierr_);
            (void) _dorgbr (_dc_3, n_, n_, n_, a_, lda_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($83_ = (*lwork_) - iwork_ + 1, 
            &$83_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, n_, m_, &_k0, s_, &work_[ie_ - 1], a_, lda_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
        else if (wntvas_) {
          if ((*lwork_) >= (*n_) * (*n_) + _max (4 * (*n_), bdspac_)) {
            iu_ = 1;
            if ((*lwork_) >= wrkbl_ + (*lda_) * (*n_)) {
              ldwrku_ = (*lda_);
            }
            else {
              ldwrku_ = (*n_);
            }
            itau_ = iu_ + ldwrku_ * (*n_);
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($84_ = (*lwork_) - iwork_ + 1, &$84_), 
            &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[iu_ - 1], &ldwrku_);
            (void) _dlaset (_dc_1, ($85_ = (*n_) - 1, &$85_), ($86_ = (*n_) - 1, &$86_), ($87_ = 0.0, &$87_), ($88_ = 0.0, &$88_), 
            &work_[iu_ + 1 - 1], &ldwrku_);
            (void) _dorgqr (m_, n_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($89_ = (*lwork_) - iwork_ + 1, &$89_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            (void) _dgebrd (n_, n_, &work_[iu_ - 1], &ldwrku_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($90_ = (*lwork_) - iwork_ + 1, &$90_), &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, &work_[iu_ - 1], &ldwrku_, vt_, ldvt_);
            (void) _dorgbr (_dc_53, n_, n_, n_, &work_[iu_ - 1], &ldwrku_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($91_ = 
            (*lwork_) - iwork_ + 1, &$91_), &ierr_);
            (void) _dorgbr (_dc_3, n_, n_, n_, vt_, ldvt_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($92_ = (*lwork_) - iwork_ + 1, 
            &$92_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, n_, n_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, &work_[iu_ - 1], &ldwrku_, dum_, &_k1, 
            &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, n_, ($93_ = 1.0, &$93_), a_, lda_, &work_[iu_ - 1], &ldwrku_, ($94_ = 0.0, &$94_), 
            u_, ldu_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($95_ = (*lwork_) - iwork_ + 1, &$95_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dorgqr (m_, n_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($96_ = (*lwork_) - iwork_ + 1, &$96_), 
            &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, a_, lda_, vt_, ldvt_);
            if ((*n_) > 1) {
              (void) _dlaset (_dc_1, ($97_ = (*n_) - 1, &$97_), ($98_ = (*n_) - 1, &$98_), ($99_ = 0.0, &$99_), ($100_ = 0.0, 
              &$100_), &vt_[1 + ((*ldvt_)) * ((0))], ldvt_);
            }
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            (void) _dgebrd (n_, n_, vt_, ldvt_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($101_ = (*lwork_) - iwork_ + 1, &$101_), &ierr_);
            (void) _dormbr (_dc_53, _dc_15, _dc_2, m_, n_, n_, vt_, ldvt_, &work_[itauq_ - 1], u_, ldu_, &work_[iwork_ - 1], ($102_ 
            = (*lwork_) - iwork_ + 1, &$102_), &ierr_);
            (void) _dorgbr (_dc_3, n_, n_, n_, vt_, ldvt_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($103_ = (*lwork_) - iwork_ + 1, 
            &$103_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, n_, m_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
      }
      else if (wntua_) {
        if (wntvn_) {
          if ((*lwork_) >= (*n_) * (*n_) + ($104_ = _max ((*n_) + (*m_), 4 * (*n_)), _max ($104_, bdspac_))) {
            ir_ = 1;
            if ((*lwork_) >= wrkbl_ + (*lda_) * (*n_)) {
              ldwrkr_ = (*lda_);
            }
            else {
              ldwrkr_ = (*n_);
            }
            itau_ = ir_ + ldwrkr_ * (*n_);
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($105_ = (*lwork_) - iwork_ + 1, &$105_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[ir_ - 1], &ldwrkr_);
            (void) _dlaset (_dc_1, ($106_ = (*n_) - 1, &$106_), ($107_ = (*n_) - 1, &$107_), ($108_ = 0.0, &$108_), ($109_ = 0.0, 
            &$109_), &work_[ir_ + 1 - 1], &ldwrkr_);
            (void) _dorgqr (m_, m_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($110_ = (*lwork_) - iwork_ + 1, &$110_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            (void) _dgebrd (n_, n_, &work_[ir_ - 1], &ldwrkr_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($111_ = (*lwork_) - iwork_ + 1, &$111_), &ierr_);
            (void) _dorgbr (_dc_53, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($112_ = 
            (*lwork_) - iwork_ + 1, &$112_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, &_k0, n_, &_k0, s_, &work_[ie_ - 1], dum_, &_k1, &work_[ir_ - 1], &ldwrkr_, dum_, &_k1, 
            &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, n_, ($113_ = 1.0, &$113_), u_, ldu_, &work_[ir_ - 1], &ldwrkr_, ($114_ = 0.0, 
            &$114_), a_, lda_);
            (void) _dlacpy (_dc_16, m_, n_, a_, lda_, u_, ldu_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($115_ = (*lwork_) - iwork_ + 1, &$115_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dorgqr (m_, m_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($116_ = (*lwork_) - iwork_ + 1, &$116_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            if ((*n_) > 1) {
              (void) _dlaset (_dc_1, ($117_ = (*n_) - 1, &$117_), ($118_ = (*n_) - 1, &$118_), ($119_ = 0.0, &$119_), ($120_ = 0.0, 
              &$120_), &a_[1 + ((*lda_)) * ((0))], lda_);
            }
            (void) _dgebrd (n_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($121_ = (*lwork_) - iwork_ + 1, &$121_), &ierr_);
            (void) _dormbr (_dc_53, _dc_15, _dc_2, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[iwork_ - 1], ($122_ = 
            (*lwork_) - iwork_ + 1, &$122_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, &_k0, m_, &_k0, s_, &work_[ie_ - 1], dum_, &_k1, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
        else if (wntvo_) {
          if ((*lwork_) >= 2 * (*n_) * (*n_) + ($123_ = _max ((*n_) + (*m_), 4 * (*n_)), _max ($123_, bdspac_))) {
            iu_ = 1;
            if ((*lwork_) >= wrkbl_ + 2 * (*lda_) * (*n_)) {
              ldwrku_ = (*lda_);
              ir_ = iu_ + ldwrku_ * (*n_);
              ldwrkr_ = (*lda_);
            }
            else if ((*lwork_) >= wrkbl_ + ((*lda_) + (*n_)) * (*n_)) {
              ldwrku_ = (*lda_);
              ir_ = iu_ + ldwrku_ * (*n_);
              ldwrkr_ = (*n_);
            }
            else {
              ldwrku_ = (*n_);
              ir_ = iu_ + ldwrku_ * (*n_);
              ldwrkr_ = (*n_);
            }
            itau_ = ir_ + ldwrkr_ * (*n_);
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($124_ = (*lwork_) - iwork_ + 1, &$124_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dorgqr (m_, m_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($125_ = (*lwork_) - iwork_ + 1, &$125_), 
            &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[iu_ - 1], &ldwrku_);
            (void) _dlaset (_dc_1, ($126_ = (*n_) - 1, &$126_), ($127_ = (*n_) - 1, &$127_), ($128_ = 0.0, &$128_), ($129_ = 0.0, 
            &$129_), &work_[iu_ + 1 - 1], &ldwrku_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            (void) _dgebrd (n_, n_, &work_[iu_ - 1], &ldwrku_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($130_ = (*lwork_) - iwork_ + 1, &$130_), &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, &work_[iu_ - 1], &ldwrku_, &work_[ir_ - 1], &ldwrkr_);
            (void) _dorgbr (_dc_53, n_, n_, n_, &work_[iu_ - 1], &ldwrku_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($131_ = 
            (*lwork_) - iwork_ + 1, &$131_), &ierr_);
            (void) _dorgbr (_dc_3, n_, n_, n_, &work_[ir_ - 1], &ldwrkr_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($132_ = 
            (*lwork_) - iwork_ + 1, &$132_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, n_, n_, &_k0, s_, &work_[ie_ - 1], &work_[ir_ - 1], &ldwrkr_, &work_[iu_ - 1], &ldwrku_, 
            dum_, &_k1, &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, n_, ($133_ = 1.0, &$133_), u_, ldu_, &work_[iu_ - 1], &ldwrku_, ($134_ = 0.0, 
            &$134_), a_, lda_);
            (void) _dlacpy (_dc_16, m_, n_, a_, lda_, u_, ldu_);
            (void) _dlacpy (_dc_16, n_, n_, &work_[ir_ - 1], &ldwrkr_, a_, lda_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($135_ = (*lwork_) - iwork_ + 1, &$135_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dorgqr (m_, m_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($136_ = (*lwork_) - iwork_ + 1, &$136_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            if ((*n_) > 1) {
              (void) _dlaset (_dc_1, ($137_ = (*n_) - 1, &$137_), ($138_ = (*n_) - 1, &$138_), ($139_ = 0.0, &$139_), ($140_ = 0.0, 
              &$140_), &a_[1 + ((*lda_)) * ((0))], lda_);
            }
            (void) _dgebrd (n_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($141_ = (*lwork_) - iwork_ + 1, &$141_), &ierr_);
            (void) _dormbr (_dc_53, _dc_15, _dc_2, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], u_, ldu_, &work_[iwork_ - 1], ($142_ = 
            (*lwork_) - iwork_ + 1, &$142_), &ierr_);
            (void) _dorgbr (_dc_3, n_, n_, n_, a_, lda_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($143_ = (*lwork_) - iwork_ + 1, 
            &$143_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, n_, m_, &_k0, s_, &work_[ie_ - 1], a_, lda_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
        else if (wntvas_) {
          if ((*lwork_) >= (*n_) * (*n_) + ($144_ = _max ((*n_) + (*m_), 4 * (*n_)), _max ($144_, bdspac_))) {
            iu_ = 1;
            if ((*lwork_) >= wrkbl_ + (*lda_) * (*n_)) {
              ldwrku_ = (*lda_);
            }
            else {
              ldwrku_ = (*n_);
            }
            itau_ = iu_ + ldwrku_ * (*n_);
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($145_ = (*lwork_) - iwork_ + 1, &$145_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dorgqr (m_, m_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($146_ = (*lwork_) - iwork_ + 1, &$146_), 
            &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, a_, lda_, &work_[iu_ - 1], &ldwrku_);
            (void) _dlaset (_dc_1, ($147_ = (*n_) - 1, &$147_), ($148_ = (*n_) - 1, &$148_), ($149_ = 0.0, &$149_), ($150_ = 0.0, 
            &$150_), &work_[iu_ + 1 - 1], &ldwrku_);
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            (void) _dgebrd (n_, n_, &work_[iu_ - 1], &ldwrku_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($151_ = (*lwork_) - iwork_ + 1, &$151_), &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, &work_[iu_ - 1], &ldwrku_, vt_, ldvt_);
            (void) _dorgbr (_dc_53, n_, n_, n_, &work_[iu_ - 1], &ldwrku_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($152_ = 
            (*lwork_) - iwork_ + 1, &$152_), &ierr_);
            (void) _dorgbr (_dc_3, n_, n_, n_, vt_, ldvt_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($153_ = (*lwork_) - iwork_ + 1, 
            &$153_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, n_, n_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, &work_[iu_ - 1], &ldwrku_, dum_, &_k1, 
            &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, n_, ($154_ = 1.0, &$154_), u_, ldu_, &work_[iu_ - 1], &ldwrku_, ($155_ = 0.0, 
            &$155_), a_, lda_);
            (void) _dlacpy (_dc_16, m_, n_, a_, lda_, u_, ldu_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*n_);
            (void) _dgeqrf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($156_ = (*lwork_) - iwork_ + 1, &$156_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
            (void) _dorgqr (m_, m_, n_, u_, ldu_, &work_[itau_ - 1], &work_[iwork_ - 1], ($157_ = (*lwork_) - iwork_ + 1, &$157_), 
            &ierr_);
            (void) _dlacpy (_dc_0, n_, n_, a_, lda_, vt_, ldvt_);
            if ((*n_) > 1) {
              (void) _dlaset (_dc_1, ($158_ = (*n_) - 1, &$158_), ($159_ = (*n_) - 1, &$159_), ($160_ = 0.0, &$160_), ($161_ = 0.0, 
              &$161_), &vt_[1 + ((*ldvt_)) * ((0))], ldvt_);
            }
            ie_ = itau_;
            itauq_ = ie_ + (*n_);
            itaup_ = itauq_ + (*n_);
            iwork_ = itaup_ + (*n_);
            (void) _dgebrd (n_, n_, vt_, ldvt_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($162_ = (*lwork_) - iwork_ + 1, &$162_), &ierr_);
            (void) _dormbr (_dc_53, _dc_15, _dc_2, m_, n_, n_, vt_, ldvt_, &work_[itauq_ - 1], u_, ldu_, &work_[iwork_ - 1], ($163_ 
            = (*lwork_) - iwork_ + 1, &$163_), &ierr_);
            (void) _dorgbr (_dc_3, n_, n_, n_, vt_, ldvt_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($164_ = (*lwork_) - iwork_ + 1, 
            &$164_), &ierr_);
            iwork_ = ie_ + (*n_);
            (void) _dbdsqr (_dc_0, n_, n_, m_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
      }
    }
    else {
      ie_ = 1;
      itauq_ = ie_ + (*n_);
      itaup_ = itauq_ + (*n_);
      iwork_ = itaup_ + (*n_);
      (void) _dgebrd (m_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
      ($165_ = (*lwork_) - iwork_ + 1, &$165_), &ierr_);
      if (wntuas_) {
        (void) _dlacpy (_dc_1, m_, n_, a_, lda_, u_, ldu_);
        if (wntus_) {
          ncu_ = (*n_);
        }
        if (wntua_) {
          ncu_ = (*m_);
        }
        (void) _dorgbr (_dc_53, m_, &ncu_, n_, u_, ldu_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($166_ = (*lwork_) - iwork_ + 
        1, &$166_), &ierr_);
      }
      if (wntvas_) {
        (void) _dlacpy (_dc_0, n_, n_, a_, lda_, vt_, ldvt_);
        (void) _dorgbr (_dc_3, n_, n_, n_, vt_, ldvt_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($167_ = (*lwork_) - iwork_ + 1, 
        &$167_), &ierr_);
      }
      if (wntuo_) {
        (void) _dorgbr (_dc_53, m_, n_, n_, a_, lda_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($168_ = (*lwork_) - iwork_ + 1, 
        &$168_), &ierr_);
      }
      if (wntvo_) {
        (void) _dorgbr (_dc_3, n_, n_, n_, a_, lda_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($169_ = (*lwork_) - iwork_ + 1, 
        &$169_), &ierr_);
      }
      iwork_ = ie_ + (*n_);
      if (wntuas_ || wntuo_) {
        nru_ = (*m_);
      }
      if (wntun_) {
        nru_ = 0;
      }
      if (wntvas_ || wntvo_) {
        ncvt_ = (*n_);
      }
      if (wntvn_) {
        ncvt_ = 0;
      }
      if ((! (wntuo_)) && (! (wntvo_))) {
        (void) _dbdsqr (_dc_0, n_, &ncvt_, &nru_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 
        1], info_);
      }
      else if ((! (wntuo_)) && wntvo_) {
        (void) _dbdsqr (_dc_0, n_, &ncvt_, &nru_, &_k0, s_, &work_[ie_ - 1], a_, lda_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 
        1], info_);
      }
      else {
        (void) _dbdsqr (_dc_0, n_, &ncvt_, &nru_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, a_, lda_, dum_, &_k1, &work_[iwork_ - 
        1], info_);
      }
    }
  }
  else {
    if ((*n_) >= mnthr_) {
      if (wntvn_) {
        itau_ = 1;
        iwork_ = itau_ + (*m_);
        (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($170_ = (*lwork_) - iwork_ + 1, &$170_), 
        &ierr_);
        (void) _dlaset (_dc_0, ($171_ = (*m_) - 1, &$171_), ($172_ = (*m_) - 1, &$172_), ($173_ = 0.0, &$173_), ($174_ = 0.0, 
        &$174_), &a_[0 + ((*lda_)) * ((1))], lda_);
        ie_ = 1;
        itauq_ = ie_ + (*m_);
        itaup_ = itauq_ + (*m_);
        iwork_ = itaup_ + (*m_);
        (void) _dgebrd (m_, m_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
        ($175_ = (*lwork_) - iwork_ + 1, &$175_), &ierr_);
        if (wntuo_ || wntuas_) {
          (void) _dorgbr (_dc_53, m_, m_, m_, a_, lda_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($176_ = (*lwork_) - iwork_ + 1, 
          &$176_), &ierr_);
        }
        iwork_ = ie_ + (*m_);
        nru_ = 0;
        if (wntuo_ || wntuas_) {
          nru_ = (*m_);
        }
        (void) _dbdsqr (_dc_0, m_, &_k0, &nru_, &_k0, s_, &work_[ie_ - 1], dum_, &_k1, a_, lda_, dum_, &_k1, &work_[iwork_ - 
        1], info_);
        if (wntuas_) {
          (void) _dlacpy (_dc_16, m_, m_, a_, lda_, u_, ldu_);
        }
      }
      else if (wntvo_ && wntun_) {
        if ((*lwork_) >= (*m_) * (*m_) + _max (4 * (*m_), bdspac_)) {
          ir_ = 1;
          if ((*lwork_) >= _max (wrkbl_, (*lda_) * (*n_) + (*m_)) + (*lda_) * (*m_)) {
            ldwrku_ = (*lda_);
            chunk_ = (*n_);
            ldwrkr_ = (*lda_);
          }
          else if ((*lwork_) >= _max (wrkbl_, (*lda_) * (*n_) + (*m_)) + (*m_) * (*m_)) {
            ldwrku_ = (*lda_);
            chunk_ = (*n_);
            ldwrkr_ = (*m_);
          }
          else {
            ldwrku_ = (*m_);
            chunk_ = ((*lwork_) - (*m_) * (*m_) - (*m_)) / (*m_);
            ldwrkr_ = (*m_);
          }
          itau_ = ir_ + ldwrkr_ * (*m_);
          iwork_ = itau_ + (*m_);
          (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($177_ = (*lwork_) - iwork_ + 1, &$177_), 
          &ierr_);
          (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[ir_ - 1], &ldwrkr_);
          (void) _dlaset (_dc_0, ($178_ = (*m_) - 1, &$178_), ($179_ = (*m_) - 1, &$179_), ($180_ = 0.0, &$180_), ($181_ = 0.0, 
          &$181_), &work_[ir_ + ldwrkr_ - 1], &ldwrkr_);
          (void) _dorglq (m_, n_, m_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($182_ = (*lwork_) - iwork_ + 1, &$182_), 
          &ierr_);
          ie_ = itau_;
          itauq_ = ie_ + (*m_);
          itaup_ = itauq_ + (*m_);
          iwork_ = itaup_ + (*m_);
          (void) _dgebrd (m_, m_, &work_[ir_ - 1], &ldwrkr_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
          &work_[iwork_ - 1], ($183_ = (*lwork_) - iwork_ + 1, &$183_), &ierr_);
          (void) _dorgbr (_dc_3, m_, m_, m_, &work_[ir_ - 1], &ldwrkr_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($184_ = 
          (*lwork_) - iwork_ + 1, &$184_), &ierr_);
          iwork_ = ie_ + (*m_);
          (void) _dbdsqr (_dc_0, m_, m_, &_k0, &_k0, s_, &work_[ie_ - 1], &work_[ir_ - 1], &ldwrkr_, dum_, &_k1, dum_, &_k1, 
          &work_[iwork_ - 1], info_);
          iu_ = ie_ + (*m_);
          for (i_ = 1; (chunk_ > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += chunk_) {
            blk_ = _min ((*n_) - i_ + 1, chunk_);
            (void) _dgemm (_dc_2, _dc_2, m_, &blk_, m_, ($185_ = 1.0, &$185_), &work_[ir_ - 1], &ldwrkr_, &a_[0 + ((*lda_)) * ((i_ 
            - 1))], lda_, ($186_ = 0.0, &$186_), &work_[iu_ - 1], &ldwrku_);
            (void) _dlacpy (_dc_16, m_, &blk_, &work_[iu_ - 1], &ldwrku_, &a_[0 + ((*lda_)) * ((i_ - 1))], lda_);
          }
        }
        else {
          ie_ = 1;
          itauq_ = ie_ + (*m_);
          itaup_ = itauq_ + (*m_);
          iwork_ = itaup_ + (*m_);
          (void) _dgebrd (m_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
          ($187_ = (*lwork_) - iwork_ + 1, &$187_), &ierr_);
          (void) _dorgbr (_dc_3, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($188_ = (*lwork_) - iwork_ + 1, 
          &$188_), &ierr_);
          iwork_ = ie_ + (*m_);
          (void) _dbdsqr (_dc_1, m_, n_, &_k0, &_k0, s_, &work_[ie_ - 1], a_, lda_, dum_, &_k1, dum_, &_k1, &work_[iwork_ - 1], 
          info_);
        }
      }
      else if (wntvo_ && wntuas_) {
        if ((*lwork_) >= (*m_) * (*m_) + _max (4 * (*m_), bdspac_)) {
          ir_ = 1;
          if ((*lwork_) >= _max (wrkbl_, (*lda_) * (*n_) + (*m_)) + (*lda_) * (*m_)) {
            ldwrku_ = (*lda_);
            chunk_ = (*n_);
            ldwrkr_ = (*lda_);
          }
          else if ((*lwork_) >= _max (wrkbl_, (*lda_) * (*n_) + (*m_)) + (*m_) * (*m_)) {
            ldwrku_ = (*lda_);
            chunk_ = (*n_);
            ldwrkr_ = (*m_);
          }
          else {
            ldwrku_ = (*m_);
            chunk_ = ((*lwork_) - (*m_) * (*m_) - (*m_)) / (*m_);
            ldwrkr_ = (*m_);
          }
          itau_ = ir_ + ldwrkr_ * (*m_);
          iwork_ = itau_ + (*m_);
          (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($189_ = (*lwork_) - iwork_ + 1, &$189_), 
          &ierr_);
          (void) _dlacpy (_dc_1, m_, m_, a_, lda_, u_, ldu_);
          (void) _dlaset (_dc_0, ($190_ = (*m_) - 1, &$190_), ($191_ = (*m_) - 1, &$191_), ($192_ = 0.0, &$192_), ($193_ = 0.0, 
          &$193_), &u_[0 + ((*ldu_)) * ((1))], ldu_);
          (void) _dorglq (m_, n_, m_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($194_ = (*lwork_) - iwork_ + 1, &$194_), 
          &ierr_);
          ie_ = itau_;
          itauq_ = ie_ + (*m_);
          itaup_ = itauq_ + (*m_);
          iwork_ = itaup_ + (*m_);
          (void) _dgebrd (m_, m_, u_, ldu_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
          ($195_ = (*lwork_) - iwork_ + 1, &$195_), &ierr_);
          (void) _dlacpy (_dc_0, m_, m_, u_, ldu_, &work_[ir_ - 1], &ldwrkr_);
          (void) _dorgbr (_dc_3, m_, m_, m_, &work_[ir_ - 1], &ldwrkr_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($196_ = 
          (*lwork_) - iwork_ + 1, &$196_), &ierr_);
          (void) _dorgbr (_dc_53, m_, m_, m_, u_, ldu_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($197_ = (*lwork_) - iwork_ + 1, 
          &$197_), &ierr_);
          iwork_ = ie_ + (*m_);
          (void) _dbdsqr (_dc_0, m_, m_, m_, &_k0, s_, &work_[ie_ - 1], &work_[ir_ - 1], &ldwrkr_, u_, ldu_, dum_, &_k1, 
          &work_[iwork_ - 1], info_);
          iu_ = ie_ + (*m_);
          for (i_ = 1; (chunk_ > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += chunk_) {
            blk_ = _min ((*n_) - i_ + 1, chunk_);
            (void) _dgemm (_dc_2, _dc_2, m_, &blk_, m_, ($198_ = 1.0, &$198_), &work_[ir_ - 1], &ldwrkr_, &a_[0 + ((*lda_)) * ((i_ 
            - 1))], lda_, ($199_ = 0.0, &$199_), &work_[iu_ - 1], &ldwrku_);
            (void) _dlacpy (_dc_16, m_, &blk_, &work_[iu_ - 1], &ldwrku_, &a_[0 + ((*lda_)) * ((i_ - 1))], lda_);
          }
        }
        else {
          itau_ = 1;
          iwork_ = itau_ + (*m_);
          (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($200_ = (*lwork_) - iwork_ + 1, &$200_), 
          &ierr_);
          (void) _dlacpy (_dc_1, m_, m_, a_, lda_, u_, ldu_);
          (void) _dlaset (_dc_0, ($201_ = (*m_) - 1, &$201_), ($202_ = (*m_) - 1, &$202_), ($203_ = 0.0, &$203_), ($204_ = 0.0, 
          &$204_), &u_[0 + ((*ldu_)) * ((1))], ldu_);
          (void) _dorglq (m_, n_, m_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($205_ = (*lwork_) - iwork_ + 1, &$205_), 
          &ierr_);
          ie_ = itau_;
          itauq_ = ie_ + (*m_);
          itaup_ = itauq_ + (*m_);
          iwork_ = itaup_ + (*m_);
          (void) _dgebrd (m_, m_, u_, ldu_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
          ($206_ = (*lwork_) - iwork_ + 1, &$206_), &ierr_);
          (void) _dormbr (_dc_3, _dc_1, _dc_25, m_, n_, m_, u_, ldu_, &work_[itaup_ - 1], a_, lda_, &work_[iwork_ - 1], ($207_ = 
          (*lwork_) - iwork_ + 1, &$207_), &ierr_);
          (void) _dorgbr (_dc_53, m_, m_, m_, u_, ldu_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($208_ = (*lwork_) - iwork_ + 1, 
          &$208_), &ierr_);
          iwork_ = ie_ + (*m_);
          (void) _dbdsqr (_dc_0, m_, n_, m_, &_k0, s_, &work_[ie_ - 1], a_, lda_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
          info_);
        }
      }
      else if (wntvs_) {
        if (wntun_) {
          if ((*lwork_) >= (*m_) * (*m_) + _max (4 * (*m_), bdspac_)) {
            ir_ = 1;
            if ((*lwork_) >= wrkbl_ + (*lda_) * (*m_)) {
              ldwrkr_ = (*lda_);
            }
            else {
              ldwrkr_ = (*m_);
            }
            itau_ = ir_ + ldwrkr_ * (*m_);
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($209_ = (*lwork_) - iwork_ + 1, &$209_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[ir_ - 1], &ldwrkr_);
            (void) _dlaset (_dc_0, ($210_ = (*m_) - 1, &$210_), ($211_ = (*m_) - 1, &$211_), ($212_ = 0.0, &$212_), ($213_ = 0.0, 
            &$213_), &work_[ir_ + ldwrkr_ - 1], &ldwrkr_);
            (void) _dorglq (m_, n_, m_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($214_ = (*lwork_) - iwork_ + 1, &$214_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dgebrd (m_, m_, &work_[ir_ - 1], &ldwrkr_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($215_ = (*lwork_) - iwork_ + 1, &$215_), &ierr_);
            (void) _dorgbr (_dc_3, m_, m_, m_, &work_[ir_ - 1], &ldwrkr_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($216_ = 
            (*lwork_) - iwork_ + 1, &$216_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, m_, &_k0, &_k0, s_, &work_[ie_ - 1], &work_[ir_ - 1], &ldwrkr_, dum_, &_k1, dum_, &_k1, 
            &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, m_, ($217_ = 1.0, &$217_), &work_[ir_ - 1], &ldwrkr_, a_, lda_, ($218_ = 0.0, 
            &$218_), vt_, ldvt_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($219_ = (*lwork_) - iwork_ + 1, &$219_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dorglq (m_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($220_ = (*lwork_) - iwork_ + 1, 
            &$220_), &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dlaset (_dc_0, ($221_ = (*m_) - 1, &$221_), ($222_ = (*m_) - 1, &$222_), ($223_ = 0.0, &$223_), ($224_ = 0.0, 
            &$224_), &a_[0 + ((*lda_)) * ((1))], lda_);
            (void) _dgebrd (m_, m_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($225_ = (*lwork_) - iwork_ + 1, &$225_), &ierr_);
            (void) _dormbr (_dc_3, _dc_1, _dc_25, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[iwork_ - 1], ($226_ 
            = (*lwork_) - iwork_ + 1, &$226_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, n_, &_k0, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, dum_, &_k1, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
        else if (wntuo_) {
          if ((*lwork_) >= 2 * (*m_) * (*m_) + _max (4 * (*m_), bdspac_)) {
            iu_ = 1;
            if ((*lwork_) >= wrkbl_ + 2 * (*lda_) * (*m_)) {
              ldwrku_ = (*lda_);
              ir_ = iu_ + ldwrku_ * (*m_);
              ldwrkr_ = (*lda_);
            }
            else if ((*lwork_) >= wrkbl_ + ((*lda_) + (*m_)) * (*m_)) {
              ldwrku_ = (*lda_);
              ir_ = iu_ + ldwrku_ * (*m_);
              ldwrkr_ = (*m_);
            }
            else {
              ldwrku_ = (*m_);
              ir_ = iu_ + ldwrku_ * (*m_);
              ldwrkr_ = (*m_);
            }
            itau_ = ir_ + ldwrkr_ * (*m_);
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($227_ = (*lwork_) - iwork_ + 1, &$227_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[iu_ - 1], &ldwrku_);
            (void) _dlaset (_dc_0, ($228_ = (*m_) - 1, &$228_), ($229_ = (*m_) - 1, &$229_), ($230_ = 0.0, &$230_), ($231_ = 0.0, 
            &$231_), &work_[iu_ + ldwrku_ - 1], &ldwrku_);
            (void) _dorglq (m_, n_, m_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($232_ = (*lwork_) - iwork_ + 1, &$232_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dgebrd (m_, m_, &work_[iu_ - 1], &ldwrku_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($233_ = (*lwork_) - iwork_ + 1, &$233_), &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, &work_[iu_ - 1], &ldwrku_, &work_[ir_ - 1], &ldwrkr_);
            (void) _dorgbr (_dc_3, m_, m_, m_, &work_[iu_ - 1], &ldwrku_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($234_ = 
            (*lwork_) - iwork_ + 1, &$234_), &ierr_);
            (void) _dorgbr (_dc_53, m_, m_, m_, &work_[ir_ - 1], &ldwrkr_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($235_ = 
            (*lwork_) - iwork_ + 1, &$235_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, m_, m_, &_k0, s_, &work_[ie_ - 1], &work_[iu_ - 1], &ldwrku_, &work_[ir_ - 1], &ldwrkr_, 
            dum_, &_k1, &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, m_, ($236_ = 1.0, &$236_), &work_[iu_ - 1], &ldwrku_, a_, lda_, ($237_ = 0.0, 
            &$237_), vt_, ldvt_);
            (void) _dlacpy (_dc_16, m_, m_, &work_[ir_ - 1], &ldwrkr_, a_, lda_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($238_ = (*lwork_) - iwork_ + 1, &$238_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dorglq (m_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($239_ = (*lwork_) - iwork_ + 1, 
            &$239_), &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dlaset (_dc_0, ($240_ = (*m_) - 1, &$240_), ($241_ = (*m_) - 1, &$241_), ($242_ = 0.0, &$242_), ($243_ = 0.0, 
            &$243_), &a_[0 + ((*lda_)) * ((1))], lda_);
            (void) _dgebrd (m_, m_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($244_ = (*lwork_) - iwork_ + 1, &$244_), &ierr_);
            (void) _dormbr (_dc_3, _dc_1, _dc_25, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[iwork_ - 1], ($245_ 
            = (*lwork_) - iwork_ + 1, &$245_), &ierr_);
            (void) _dorgbr (_dc_53, m_, m_, m_, a_, lda_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($246_ = (*lwork_) - iwork_ + 1, 
            &$246_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, n_, m_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, a_, lda_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
        else if (wntuas_) {
          if ((*lwork_) >= (*m_) * (*m_) + _max (4 * (*m_), bdspac_)) {
            iu_ = 1;
            if ((*lwork_) >= wrkbl_ + (*lda_) * (*m_)) {
              ldwrku_ = (*lda_);
            }
            else {
              ldwrku_ = (*m_);
            }
            itau_ = iu_ + ldwrku_ * (*m_);
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($247_ = (*lwork_) - iwork_ + 1, &$247_), 
            &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[iu_ - 1], &ldwrku_);
            (void) _dlaset (_dc_0, ($248_ = (*m_) - 1, &$248_), ($249_ = (*m_) - 1, &$249_), ($250_ = 0.0, &$250_), ($251_ = 0.0, 
            &$251_), &work_[iu_ + ldwrku_ - 1], &ldwrku_);
            (void) _dorglq (m_, n_, m_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($252_ = (*lwork_) - iwork_ + 1, &$252_), 
            &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dgebrd (m_, m_, &work_[iu_ - 1], &ldwrku_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($253_ = (*lwork_) - iwork_ + 1, &$253_), &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, &work_[iu_ - 1], &ldwrku_, u_, ldu_);
            (void) _dorgbr (_dc_3, m_, m_, m_, &work_[iu_ - 1], &ldwrku_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($254_ = 
            (*lwork_) - iwork_ + 1, &$254_), &ierr_);
            (void) _dorgbr (_dc_53, m_, m_, m_, u_, ldu_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($255_ = (*lwork_) - iwork_ + 1, 
            &$255_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, m_, m_, &_k0, s_, &work_[ie_ - 1], &work_[iu_ - 1], &ldwrku_, u_, ldu_, dum_, &_k1, 
            &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, m_, ($256_ = 1.0, &$256_), &work_[iu_ - 1], &ldwrku_, a_, lda_, ($257_ = 0.0, 
            &$257_), vt_, ldvt_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($258_ = (*lwork_) - iwork_ + 1, &$258_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dorglq (m_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($259_ = (*lwork_) - iwork_ + 1, 
            &$259_), &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, a_, lda_, u_, ldu_);
            (void) _dlaset (_dc_0, ($260_ = (*m_) - 1, &$260_), ($261_ = (*m_) - 1, &$261_), ($262_ = 0.0, &$262_), ($263_ = 0.0, 
            &$263_), &u_[0 + ((*ldu_)) * ((1))], ldu_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dgebrd (m_, m_, u_, ldu_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($264_ = (*lwork_) - iwork_ + 1, &$264_), &ierr_);
            (void) _dormbr (_dc_3, _dc_1, _dc_25, m_, n_, m_, u_, ldu_, &work_[itaup_ - 1], vt_, ldvt_, &work_[iwork_ - 1], ($265_ 
            = (*lwork_) - iwork_ + 1, &$265_), &ierr_);
            (void) _dorgbr (_dc_53, m_, m_, m_, u_, ldu_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($266_ = (*lwork_) - iwork_ + 1, 
            &$266_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, n_, m_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
      }
      else if (wntva_) {
        if (wntun_) {
          if ((*lwork_) >= (*m_) * (*m_) + ($267_ = _max ((*n_) + (*m_), 4 * (*m_)), _max ($267_, bdspac_))) {
            ir_ = 1;
            if ((*lwork_) >= wrkbl_ + (*lda_) * (*m_)) {
              ldwrkr_ = (*lda_);
            }
            else {
              ldwrkr_ = (*m_);
            }
            itau_ = ir_ + ldwrkr_ * (*m_);
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($268_ = (*lwork_) - iwork_ + 1, &$268_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[ir_ - 1], &ldwrkr_);
            (void) _dlaset (_dc_0, ($269_ = (*m_) - 1, &$269_), ($270_ = (*m_) - 1, &$270_), ($271_ = 0.0, &$271_), ($272_ = 0.0, 
            &$272_), &work_[ir_ + ldwrkr_ - 1], &ldwrkr_);
            (void) _dorglq (n_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($273_ = (*lwork_) - iwork_ + 1, 
            &$273_), &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dgebrd (m_, m_, &work_[ir_ - 1], &ldwrkr_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($274_ = (*lwork_) - iwork_ + 1, &$274_), &ierr_);
            (void) _dorgbr (_dc_3, m_, m_, m_, &work_[ir_ - 1], &ldwrkr_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($275_ = 
            (*lwork_) - iwork_ + 1, &$275_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, m_, &_k0, &_k0, s_, &work_[ie_ - 1], &work_[ir_ - 1], &ldwrkr_, dum_, &_k1, dum_, &_k1, 
            &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, m_, ($276_ = 1.0, &$276_), &work_[ir_ - 1], &ldwrkr_, vt_, ldvt_, ($277_ = 0.0, 
            &$277_), a_, lda_);
            (void) _dlacpy (_dc_16, m_, n_, a_, lda_, vt_, ldvt_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($278_ = (*lwork_) - iwork_ + 1, &$278_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dorglq (n_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($279_ = (*lwork_) - iwork_ + 1, 
            &$279_), &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dlaset (_dc_0, ($280_ = (*m_) - 1, &$280_), ($281_ = (*m_) - 1, &$281_), ($282_ = 0.0, &$282_), ($283_ = 0.0, 
            &$283_), &a_[0 + ((*lda_)) * ((1))], lda_);
            (void) _dgebrd (m_, m_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($284_ = (*lwork_) - iwork_ + 1, &$284_), &ierr_);
            (void) _dormbr (_dc_3, _dc_1, _dc_25, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[iwork_ - 1], ($285_ 
            = (*lwork_) - iwork_ + 1, &$285_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, n_, &_k0, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, dum_, &_k1, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
        else if (wntuo_) {
          if ((*lwork_) >= 2 * (*m_) * (*m_) + ($286_ = _max ((*n_) + (*m_), 4 * (*m_)), _max ($286_, bdspac_))) {
            iu_ = 1;
            if ((*lwork_) >= wrkbl_ + 2 * (*lda_) * (*m_)) {
              ldwrku_ = (*lda_);
              ir_ = iu_ + ldwrku_ * (*m_);
              ldwrkr_ = (*lda_);
            }
            else if ((*lwork_) >= wrkbl_ + ((*lda_) + (*m_)) * (*m_)) {
              ldwrku_ = (*lda_);
              ir_ = iu_ + ldwrku_ * (*m_);
              ldwrkr_ = (*m_);
            }
            else {
              ldwrku_ = (*m_);
              ir_ = iu_ + ldwrku_ * (*m_);
              ldwrkr_ = (*m_);
            }
            itau_ = ir_ + ldwrkr_ * (*m_);
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($287_ = (*lwork_) - iwork_ + 1, &$287_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dorglq (n_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($288_ = (*lwork_) - iwork_ + 1, 
            &$288_), &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[iu_ - 1], &ldwrku_);
            (void) _dlaset (_dc_0, ($289_ = (*m_) - 1, &$289_), ($290_ = (*m_) - 1, &$290_), ($291_ = 0.0, &$291_), ($292_ = 0.0, 
            &$292_), &work_[iu_ + ldwrku_ - 1], &ldwrku_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dgebrd (m_, m_, &work_[iu_ - 1], &ldwrku_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($293_ = (*lwork_) - iwork_ + 1, &$293_), &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, &work_[iu_ - 1], &ldwrku_, &work_[ir_ - 1], &ldwrkr_);
            (void) _dorgbr (_dc_3, m_, m_, m_, &work_[iu_ - 1], &ldwrku_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($294_ = 
            (*lwork_) - iwork_ + 1, &$294_), &ierr_);
            (void) _dorgbr (_dc_53, m_, m_, m_, &work_[ir_ - 1], &ldwrkr_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($295_ = 
            (*lwork_) - iwork_ + 1, &$295_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, m_, m_, &_k0, s_, &work_[ie_ - 1], &work_[iu_ - 1], &ldwrku_, &work_[ir_ - 1], &ldwrkr_, 
            dum_, &_k1, &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, m_, ($296_ = 1.0, &$296_), &work_[iu_ - 1], &ldwrku_, vt_, ldvt_, ($297_ = 0.0, 
            &$297_), a_, lda_);
            (void) _dlacpy (_dc_16, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dlacpy (_dc_16, m_, m_, &work_[ir_ - 1], &ldwrkr_, a_, lda_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($298_ = (*lwork_) - iwork_ + 1, &$298_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dorglq (n_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($299_ = (*lwork_) - iwork_ + 1, 
            &$299_), &ierr_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dlaset (_dc_0, ($300_ = (*m_) - 1, &$300_), ($301_ = (*m_) - 1, &$301_), ($302_ = 0.0, &$302_), ($303_ = 0.0, 
            &$303_), &a_[0 + ((*lda_)) * ((1))], lda_);
            (void) _dgebrd (m_, m_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($304_ = (*lwork_) - iwork_ + 1, &$304_), &ierr_);
            (void) _dormbr (_dc_3, _dc_1, _dc_25, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], vt_, ldvt_, &work_[iwork_ - 1], ($305_ 
            = (*lwork_) - iwork_ + 1, &$305_), &ierr_);
            (void) _dorgbr (_dc_53, m_, m_, m_, a_, lda_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($306_ = (*lwork_) - iwork_ + 1, 
            &$306_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, n_, m_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, a_, lda_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
        else if (wntuas_) {
          if ((*lwork_) >= (*m_) * (*m_) + ($307_ = _max ((*n_) + (*m_), 4 * (*m_)), _max ($307_, bdspac_))) {
            iu_ = 1;
            if ((*lwork_) >= wrkbl_ + (*lda_) * (*m_)) {
              ldwrku_ = (*lda_);
            }
            else {
              ldwrku_ = (*m_);
            }
            itau_ = iu_ + ldwrku_ * (*m_);
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($308_ = (*lwork_) - iwork_ + 1, &$308_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dorglq (n_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($309_ = (*lwork_) - iwork_ + 1, 
            &$309_), &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, a_, lda_, &work_[iu_ - 1], &ldwrku_);
            (void) _dlaset (_dc_0, ($310_ = (*m_) - 1, &$310_), ($311_ = (*m_) - 1, &$311_), ($312_ = 0.0, &$312_), ($313_ = 0.0, 
            &$313_), &work_[iu_ + ldwrku_ - 1], &ldwrku_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dgebrd (m_, m_, &work_[iu_ - 1], &ldwrku_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], 
            &work_[iwork_ - 1], ($314_ = (*lwork_) - iwork_ + 1, &$314_), &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, &work_[iu_ - 1], &ldwrku_, u_, ldu_);
            (void) _dorgbr (_dc_3, m_, m_, m_, &work_[iu_ - 1], &ldwrku_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($315_ = 
            (*lwork_) - iwork_ + 1, &$315_), &ierr_);
            (void) _dorgbr (_dc_53, m_, m_, m_, u_, ldu_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($316_ = (*lwork_) - iwork_ + 1, 
            &$316_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, m_, m_, &_k0, s_, &work_[ie_ - 1], &work_[iu_ - 1], &ldwrku_, u_, ldu_, dum_, &_k1, 
            &work_[iwork_ - 1], info_);
            (void) _dgemm (_dc_2, _dc_2, m_, n_, m_, ($317_ = 1.0, &$317_), &work_[iu_ - 1], &ldwrku_, vt_, ldvt_, ($318_ = 0.0, 
            &$318_), a_, lda_);
            (void) _dlacpy (_dc_16, m_, n_, a_, lda_, vt_, ldvt_);
          }
          else {
            itau_ = 1;
            iwork_ = itau_ + (*m_);
            (void) _dgelqf (m_, n_, a_, lda_, &work_[itau_ - 1], &work_[iwork_ - 1], ($319_ = (*lwork_) - iwork_ + 1, &$319_), 
            &ierr_);
            (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
            (void) _dorglq (n_, n_, m_, vt_, ldvt_, &work_[itau_ - 1], &work_[iwork_ - 1], ($320_ = (*lwork_) - iwork_ + 1, 
            &$320_), &ierr_);
            (void) _dlacpy (_dc_1, m_, m_, a_, lda_, u_, ldu_);
            (void) _dlaset (_dc_0, ($321_ = (*m_) - 1, &$321_), ($322_ = (*m_) - 1, &$322_), ($323_ = 0.0, &$323_), ($324_ = 0.0, 
            &$324_), &u_[0 + ((*ldu_)) * ((1))], ldu_);
            ie_ = itau_;
            itauq_ = ie_ + (*m_);
            itaup_ = itauq_ + (*m_);
            iwork_ = itaup_ + (*m_);
            (void) _dgebrd (m_, m_, u_, ldu_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
            ($325_ = (*lwork_) - iwork_ + 1, &$325_), &ierr_);
            (void) _dormbr (_dc_3, _dc_1, _dc_25, m_, n_, m_, u_, ldu_, &work_[itaup_ - 1], vt_, ldvt_, &work_[iwork_ - 1], ($326_ 
            = (*lwork_) - iwork_ + 1, &$326_), &ierr_);
            (void) _dorgbr (_dc_53, m_, m_, m_, u_, ldu_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($327_ = (*lwork_) - iwork_ + 1, 
            &$327_), &ierr_);
            iwork_ = ie_ + (*m_);
            (void) _dbdsqr (_dc_0, m_, n_, m_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 1], 
            info_);
          }
        }
      }
    }
    else {
      ie_ = 1;
      itauq_ = ie_ + (*m_);
      itaup_ = itauq_ + (*m_);
      iwork_ = itaup_ + (*m_);
      (void) _dgebrd (m_, n_, a_, lda_, s_, &work_[ie_ - 1], &work_[itauq_ - 1], &work_[itaup_ - 1], &work_[iwork_ - 1], 
      ($328_ = (*lwork_) - iwork_ + 1, &$328_), &ierr_);
      if (wntuas_) {
        (void) _dlacpy (_dc_1, m_, m_, a_, lda_, u_, ldu_);
        (void) _dorgbr (_dc_53, m_, m_, n_, u_, ldu_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($329_ = (*lwork_) - iwork_ + 1, 
        &$329_), &ierr_);
      }
      if (wntvas_) {
        (void) _dlacpy (_dc_0, m_, n_, a_, lda_, vt_, ldvt_);
        if (wntva_) {
          nrvt_ = (*n_);
        }
        if (wntvs_) {
          nrvt_ = (*m_);
        }
        (void) _dorgbr (_dc_3, &nrvt_, n_, m_, vt_, ldvt_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($330_ = (*lwork_) - iwork_ 
        + 1, &$330_), &ierr_);
      }
      if (wntuo_) {
        (void) _dorgbr (_dc_53, m_, m_, n_, a_, lda_, &work_[itauq_ - 1], &work_[iwork_ - 1], ($331_ = (*lwork_) - iwork_ + 1, 
        &$331_), &ierr_);
      }
      if (wntvo_) {
        (void) _dorgbr (_dc_3, m_, n_, m_, a_, lda_, &work_[itaup_ - 1], &work_[iwork_ - 1], ($332_ = (*lwork_) - iwork_ + 1, 
        &$332_), &ierr_);
      }
      iwork_ = ie_ + (*m_);
      if (wntuas_ || wntuo_) {
        nru_ = (*m_);
      }
      if (wntun_) {
        nru_ = 0;
      }
      if (wntvas_ || wntvo_) {
        ncvt_ = (*n_);
      }
      if (wntvn_) {
        ncvt_ = 0;
      }
      if ((! (wntuo_)) && (! (wntvo_))) {
        (void) _dbdsqr (_dc_1, m_, &ncvt_, &nru_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 
        1], info_);
      }
      else if ((! (wntuo_)) && wntvo_) {
        (void) _dbdsqr (_dc_1, m_, &ncvt_, &nru_, &_k0, s_, &work_[ie_ - 1], a_, lda_, u_, ldu_, dum_, &_k1, &work_[iwork_ - 
        1], info_);
      }
      else {
        (void) _dbdsqr (_dc_1, m_, &ncvt_, &nru_, &_k0, s_, &work_[ie_ - 1], vt_, ldvt_, a_, lda_, dum_, &_k1, &work_[iwork_ - 
        1], info_);
      }
    }
  }
  if ((*info_) != 0) {
    if (ie_ > 2) {
      for (i_ = 1; i_ <= minmn_ - 1; (i_)++) {
        work_[i_ + 1 - 1] = work_[i_ + ie_ - 1 - 1];
      }
    }
    if (ie_ < 2) {
      for (i_ = minmn_ - 1; i_ >= 1; (i_)--) {
        work_[i_ + 1 - 1] = work_[i_ + ie_ - 1 - 1];
      }
    }
  }
  if (iscl_ == 1) {
    if (anrm_ > bignum_) {
      (void) _dlascl (_dc_9, &_k0, &_k0, &bignum_, &anrm_, &minmn_, &_k1, s_, &minmn_, &ierr_);
    }
    if ((*info_) != 0 && anrm_ > bignum_) {
      (void) _dlascl (_dc_9, &_k0, &_k0, &bignum_, &anrm_, ($333_ = minmn_ - 1, &$333_), &_k1, &work_[1], &minmn_, &ierr_);
    }
    if (anrm_ < smlnum_) {
      (void) _dlascl (_dc_9, &_k0, &_k0, &smlnum_, &anrm_, &minmn_, &_k1, s_, &minmn_, &ierr_);
    }
    if ((*info_) != 0 && anrm_ < smlnum_) {
      (void) _dlascl (_dc_9, &_k0, &_k0, &smlnum_, &anrm_, ($334_ = minmn_ - 1, &$334_), &_k1, &work_[1], &minmn_, &ierr_);
    }
  }
  work_[0] = maxwrk_;
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _dgesvdq (char _p_ joba_, char _p_ jobp_, char _p_ jobr_, char _p_ jobu_, char _p_ jobv_, int_4 _p_ m_, int_4 _p_ 
n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ s_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 
_p_ numrank_, int_4 _p_ iwork_, int_4 _p_ liwork_, real_8 _p_ work_, int_4 _p_ lwork_, real_8 _p_ rwork_, int_4 _p_ 
lrwork_, int_4 _p_ info_)
{
  static int_4 ierr_, iwoff_, nr_, n1_, optratio_, p_, q_, lwcon_, lwqp3_, lwrk_dgelqf_, lwrk_dgesvd_, lwrk_dgesvd2_, 
  lwrk_dgeqp3_, lwrk_dgeqrf_, lwrk_dormlq_, lwrk_dormqr_, lwrk_dormqr2_, lwlqf_, lwqrf_, lwsvd_, lwsvd2_, lworq_, lworq2_
  , lworlq_, minwrk_, minwrk2_, optwrk_, optwrk2_, iminwrk_, rminwrk_;
  static logical_4 accla_, acclm_, acclh_, ascaled_, conda_, dntwu_, dntwv_, lquery_, lsvc0_, lsvec_, rowprm_, rsvec_, 
  rtrans_, wntua_, wntuf_, wntur_, wntus_, wntva_, wntvr_;
  static real_8 big_, epsln_, rtmp_, sconda_, sfmin_, rdummy_[1];
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, 
  $20_, $21_, $22_, $23_, $24_, $25_, $26_, $41_, $42_, $45_, $49_, $50_, $53_, $54_, $57_, $58_, $59_, $62_, $63_, $66_, 
  $69_, $70_, $73_, $74_, $75_, $76_, $79_, $81_, $84_, $86_, $87_, $90_, $92_, $95_, $97_, $98_, $101_, $103_, $106_, 
  $109_, $110_, $113_, $114_, $117_, $120_, $122_, $125_, $128_, $129_, $132_, $133_, $136_, $137_, $138_, $141_, $142_, 
  $145_, $148_, $149_, $152_, $154_, $157_, $160_, $161_, $164_, $165_, $168_, $170_, $173_, $176_, $177_, $180_, $181_, 
  $184_, $187_, $189_, $192_, $195_, $196_, $199_, $200_, $203_, $204_, $205_, $208_, $209_, $212_, $215_, $216_, $219_, 
  $221_, $224_, $227_, $228_, $231_, $232_, $233_;
  logical_4 $80_, $85_, $91_, $96_, $102_, $121_, $153_, $169_, $188_, $220_;
  real_8 $27_, $28_, $29_, $30_, $31_, $32_, $33_, $34_, $35_, $36_, $37_, $38_, $39_, $40_, $43_, $44_, $46_, $47_, $48_
  , $51_, $52_, $55_, $56_, $60_, $61_, $64_, $65_, $67_, $68_, $71_, $72_, $77_, $78_, $82_, $83_, $88_, $89_, $93_, 
  $94_, $99_, $100_, $104_, $105_, $107_, $108_, $111_, $112_, $115_, $116_, $118_, $119_, $123_, $124_, $126_, $127_, 
  $130_, $131_, $134_, $135_, $139_, $140_, $143_, $144_, $146_, $147_, $150_, $151_, $155_, $156_, $158_, $159_, $162_, 
  $163_, $166_, $167_, $171_, $172_, $174_, $175_, $178_, $179_, $182_, $183_, $185_, $186_, $190_, $191_, $193_, $194_, 
  $197_, $198_, $201_, $202_, $206_, $207_, $210_, $211_, $213_, $214_, $217_, $218_, $222_, $223_, $225_, $226_, $229_, 
  $230_, $234_, $235_, $236_, $237_;
  extern int_4 _dscal ();
  extern int_4 _xerbla ();
  extern logical_4 _lsame ();
  extern int_4 _idamax ();
  extern real_8 _dnrm2 ();
  extern real_8 _dlamch ();
  wntus_ = _lsame (jobu_, _dc_52) || _lsame (jobu_, _dc_0);
  wntur_ = _lsame (jobu_, _dc_15);
  wntua_ = _lsame (jobu_, _dc_7);
  wntuf_ = _lsame (jobu_, _dc_16);
  lsvc0_ = wntus_ || wntur_ || wntua_;
  lsvec_ = lsvc0_ || wntuf_;
  dntwu_ = _lsame (jobu_, _dc_2);
  wntvr_ = _lsame (jobv_, _dc_15);
  wntva_ = _lsame (jobv_, _dc_7) || _lsame (jobv_, _dc_11);
  rsvec_ = wntvr_ || wntva_;
  dntwv_ = _lsame (jobv_, _dc_2);
  accla_ = _lsame (joba_, _dc_7);
  acclm_ = _lsame (joba_, _dc_8);
  conda_ = _lsame (joba_, _dc_24);
  acclh_ = _lsame (joba_, _dc_60) || conda_;
  rowprm_ = _lsame (jobp_, _dc_3);
  rtrans_ = _lsame (jobr_, _dc_25);
  if (rowprm_) {
    if (conda_) {
      iminwrk_ = _max (1, (*n_) + (*m_) - 1 + (*n_));
    }
    else {
      iminwrk_ = _max (1, (*n_) + (*m_) - 1);
    }
    rminwrk_ = _max (2, (*m_));
  }
  else {
    if (conda_) {
      iminwrk_ = _max (1, (*n_) + (*n_));
    }
    else {
      iminwrk_ = _max (1, (*n_));
    }
    rminwrk_ = 2;
  }
  lquery_ = ((*liwork_) == -1 || (*lwork_) == -1 || (*lrwork_) == -1);
  (*info_) = 0;
  if (! ((accla_ || acclm_ || acclh_))) {
    (*info_) = -1;
  }
  else if (! ((rowprm_ || _lsame (jobp_, _dc_2)))) {
    (*info_) = -2;
  }
  else if (! ((rtrans_ || _lsame (jobr_, _dc_2)))) {
    (*info_) = -3;
  }
  else if (! ((lsvec_ || dntwu_))) {
    (*info_) = -4;
  }
  else if (wntur_ && wntva_) {
    (*info_) = -5;
  }
  else if (! ((rsvec_ || dntwv_))) {
    (*info_) = -5;
  }
  else if ((*m_) < 0) {
    (*info_) = -6;
  }
  else if (((*n_) < 0) || ((*n_) > (*m_))) {
    (*info_) = -7;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -9;
  }
  else if ((*ldu_) < 1 || (lsvc0_ && (*ldu_) < (*m_)) || (wntuf_ && (*ldu_) < (*n_))) {
    (*info_) = -12;
  }
  else if ((*ldv_) < 1 || (rsvec_ && (*ldv_) < (*n_)) || (conda_ && (*ldv_) < (*n_))) {
    (*info_) = -14;
  }
  else if ((*liwork_) < iminwrk_ && ! (lquery_)) {
    (*info_) = -17;
  }
  if ((*info_) == 0) {
    lwqp3_ = 3 * (*n_) + 1;
    if (wntus_ || wntur_) {
      lworq_ = _max ((*n_), 1);
    }
    else if (wntua_) {
      lworq_ = _max ((*m_), 1);
    }
    lwcon_ = 3 * (*n_);
    lwsvd_ = _max (5 * (*n_), 1);
    if (lquery_) {
      (void) _dgeqp3 (m_, n_, a_, lda_, iwork_, rdummy_, rdummy_, &_km1, &ierr_);
      lwrk_dgeqp3_ = (int_4) (_aintd (rdummy_[0]));
      if (wntus_ || wntur_) {
        (void) _dormqr (_dc_1, _dc_2, m_, n_, n_, a_, lda_, rdummy_, u_, ldu_, rdummy_, &_km1, &ierr_);
        lwrk_dormqr_ = (int_4) (_aintd (rdummy_[0]));
      }
      else if (wntua_) {
        (void) _dormqr (_dc_1, _dc_2, m_, m_, n_, a_, lda_, rdummy_, u_, ldu_, rdummy_, &_km1, &ierr_);
        lwrk_dormqr_ = (int_4) (_aintd (rdummy_[0]));
      }
      else {
        lwrk_dormqr_ = 0;
      }
    }
    minwrk_ = 2;
    optwrk_ = 2;
    if (! ((lsvec_ || rsvec_))) {
      if (conda_) {
        minwrk_ = ($0_ = _max ((*n_) + lwqp3_, lwcon_), _max ($0_, lwsvd_));
      }
      else {
        minwrk_ = _max ((*n_) + lwqp3_, lwsvd_);
      }
      if (lquery_) {
        (void) _dgesvd (_dc_2, _dc_2, n_, n_, a_, lda_, s_, u_, ldu_, v_, ldv_, rdummy_, &_km1, &ierr_);
        lwrk_dgesvd_ = (int_4) (_aintd (rdummy_[0]));
        if (conda_) {
          optwrk_ = ($1_ = _max ((*n_) + lwrk_dgeqp3_, (*n_) + lwcon_), _max ($1_, lwrk_dgesvd_));
        }
        else {
          optwrk_ = _max ((*n_) + lwrk_dgeqp3_, lwrk_dgesvd_);
        }
      }
    }
    else if (lsvec_ && (! (rsvec_))) {
      if (conda_) {
        minwrk_ = (*n_) + ($2_ = _max (lwqp3_, lwcon_), $2_ = _max ($2_, lwsvd_), _max ($2_, lworq_));
      }
      else {
        minwrk_ = (*n_) + ($3_ = _max (lwqp3_, lwsvd_), _max ($3_, lworq_));
      }
      if (lquery_) {
        if (rtrans_) {
          (void) _dgesvd (_dc_2, _dc_30, n_, n_, a_, lda_, s_, u_, ldu_, v_, ldv_, rdummy_, &_km1, &ierr_);
        }
        else {
          (void) _dgesvd (_dc_30, _dc_2, n_, n_, a_, lda_, s_, u_, ldu_, v_, ldv_, rdummy_, &_km1, &ierr_);
        }
        lwrk_dgesvd_ = (int_4) (_aintd (rdummy_[0]));
        if (conda_) {
          optwrk_ = (*n_) + ($4_ = _max (lwrk_dgeqp3_, lwcon_), $4_ = _max ($4_, lwrk_dgesvd_), _max ($4_, lwrk_dormqr_));
        }
        else {
          optwrk_ = (*n_) + ($5_ = _max (lwrk_dgeqp3_, lwrk_dgesvd_), _max ($5_, lwrk_dormqr_));
        }
      }
    }
    else if (rsvec_ && (! (lsvec_))) {
      if (conda_) {
        minwrk_ = (*n_) + ($6_ = _max (lwqp3_, lwcon_), _max ($6_, lwsvd_));
      }
      else {
        minwrk_ = (*n_) + _max (lwqp3_, lwsvd_);
      }
      if (lquery_) {
        if (rtrans_) {
          (void) _dgesvd (_dc_30, _dc_2, n_, n_, a_, lda_, s_, u_, ldu_, v_, ldv_, rdummy_, &_km1, &ierr_);
        }
        else {
          (void) _dgesvd (_dc_2, _dc_30, n_, n_, a_, lda_, s_, u_, ldu_, v_, ldv_, rdummy_, &_km1, &ierr_);
        }
        lwrk_dgesvd_ = (int_4) (_aintd (rdummy_[0]));
        if (conda_) {
          optwrk_ = (*n_) + ($7_ = _max (lwrk_dgeqp3_, lwcon_), _max ($7_, lwrk_dgesvd_));
        }
        else {
          optwrk_ = (*n_) + _max (lwrk_dgeqp3_, lwrk_dgesvd_);
        }
      }
    }
    else {
      if (rtrans_) {
        minwrk_ = ($8_ = _max (lwqp3_, lwsvd_), _max ($8_, lworq_));
        if (conda_) {
          minwrk_ = _max (minwrk_, lwcon_);
        }
        minwrk_ = minwrk_ + (*n_);
        if (wntva_) {
          lwqrf_ = _max ((*n_) / 2, 1);
          lwsvd2_ = _max (5 * ((*n_) / 2), 1);
          lworq2_ = _max ((*n_), 1);
          minwrk2_ = ($9_ = _max (lwqp3_, (*n_) / 2 + lwqrf_), $9_ = _max ($9_, (*n_) / 2 + lwsvd2_), $9_ = _max ($9_, (*n_) / 2 
          + lworq2_), _max ($9_, lworq_));
          if (conda_) {
            minwrk2_ = _max (minwrk2_, lwcon_);
          }
          minwrk2_ = (*n_) + minwrk2_;
          minwrk_ = _max (minwrk_, minwrk2_);
        }
      }
      else {
        minwrk_ = ($10_ = _max (lwqp3_, lwsvd_), _max ($10_, lworq_));
        if (conda_) {
          minwrk_ = _max (minwrk_, lwcon_);
        }
        minwrk_ = minwrk_ + (*n_);
        if (wntva_) {
          lwlqf_ = _max ((*n_) / 2, 1);
          lwsvd2_ = _max (5 * ((*n_) / 2), 1);
          lworlq_ = _max ((*n_), 1);
          minwrk2_ = ($11_ = _max (lwqp3_, (*n_) / 2 + lwlqf_), $11_ = _max ($11_, (*n_) / 2 + lwsvd2_), $11_ = _max ($11_, (*n_) 
          / 2 + lworlq_), _max ($11_, lworq_));
          if (conda_) {
            minwrk2_ = _max (minwrk2_, lwcon_);
          }
          minwrk2_ = (*n_) + minwrk2_;
          minwrk_ = _max (minwrk_, minwrk2_);
        }
      }
      if (lquery_) {
        if (rtrans_) {
          (void) _dgesvd (_dc_30, _dc_7, n_, n_, a_, lda_, s_, u_, ldu_, v_, ldv_, rdummy_, &_km1, &ierr_);
          lwrk_dgesvd_ = (int_4) (_aintd (rdummy_[0]));
          optwrk_ = ($12_ = _max (lwrk_dgeqp3_, lwrk_dgesvd_), _max ($12_, lwrk_dormqr_));
          if (conda_) {
            optwrk_ = _max (optwrk_, lwcon_);
          }
          optwrk_ = (*n_) + optwrk_;
          if (wntva_) {
            (void) _dgeqrf (n_, ($13_ = (*n_) / 2, &$13_), u_, ldu_, rdummy_, rdummy_, &_km1, &ierr_);
            lwrk_dgeqrf_ = (int_4) (_aintd (rdummy_[0]));
            (void) _dgesvd (_dc_52, _dc_30, ($14_ = (*n_) / 2, &$14_), ($15_ = (*n_) / 2, &$15_), v_, ldv_, s_, u_, ldu_, v_, ldv_, 
            rdummy_, &_km1, &ierr_);
            lwrk_dgesvd2_ = (int_4) (_aintd (rdummy_[0]));
            (void) _dormqr (_dc_15, _dc_26, n_, n_, ($16_ = (*n_) / 2, &$16_), u_, ldu_, rdummy_, v_, ldv_, rdummy_, &_km1, &ierr_)
            ;
            lwrk_dormqr2_ = (int_4) (_aintd (rdummy_[0]));
            optwrk2_ = ($17_ = _max (lwrk_dgeqp3_, (*n_) / 2 + lwrk_dgeqrf_), $17_ = _max ($17_, (*n_) / 2 + lwrk_dgesvd2_), _max 
            ($17_, (*n_) / 2 + lwrk_dormqr2_));
            if (conda_) {
              optwrk2_ = _max (optwrk2_, lwcon_);
            }
            optwrk2_ = (*n_) + optwrk2_;
            optwrk_ = _max (optwrk_, optwrk2_);
          }
        }
        else {
          (void) _dgesvd (_dc_52, _dc_30, n_, n_, a_, lda_, s_, u_, ldu_, v_, ldv_, rdummy_, &_km1, &ierr_);
          lwrk_dgesvd_ = (int_4) (_aintd (rdummy_[0]));
          optwrk_ = ($18_ = _max (lwrk_dgeqp3_, lwrk_dgesvd_), _max ($18_, lwrk_dormqr_));
          if (conda_) {
            optwrk_ = _max (optwrk_, lwcon_);
          }
          optwrk_ = (*n_) + optwrk_;
          if (wntva_) {
            (void) _dgelqf (($19_ = (*n_) / 2, &$19_), n_, u_, ldu_, rdummy_, rdummy_, &_km1, &ierr_);
            lwrk_dgelqf_ = (int_4) (_aintd (rdummy_[0]));
            (void) _dgesvd (_dc_52, _dc_30, ($20_ = (*n_) / 2, &$20_), ($21_ = (*n_) / 2, &$21_), v_, ldv_, s_, u_, ldu_, v_, ldv_, 
            rdummy_, &_km1, &ierr_);
            lwrk_dgesvd2_ = (int_4) (_aintd (rdummy_[0]));
            (void) _dormlq (_dc_15, _dc_2, n_, n_, ($22_ = (*n_) / 2, &$22_), u_, ldu_, rdummy_, v_, ldv_, rdummy_, &_km1, &ierr_)
            ;
            lwrk_dormlq_ = (int_4) (_aintd (rdummy_[0]));
            optwrk2_ = ($23_ = _max (lwrk_dgeqp3_, (*n_) / 2 + lwrk_dgelqf_), $23_ = _max ($23_, (*n_) / 2 + lwrk_dgesvd2_), _max 
            ($23_, (*n_) / 2 + lwrk_dormlq_));
            if (conda_) {
              optwrk2_ = _max (optwrk2_, lwcon_);
            }
            optwrk2_ = (*n_) + optwrk2_;
            optwrk_ = _max (optwrk_, optwrk2_);
          }
        }
      }
    }
    minwrk_ = _max (2, minwrk_);
    optwrk_ = _max (2, optwrk_);
    if ((*lwork_) < minwrk_ && (! (lquery_))) {
      (*info_) = -19;
    }
  }
  if ((*info_) == 0 && (*lrwork_) < rminwrk_ && ! (lquery_)) {
    (*info_) = -21;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_61, ($24_ = -(*info_), &$24_));
    goto _l0;
  }
  else if (lquery_) {
    iwork_[0] = iminwrk_;
    work_[0] = optwrk_;
    work_[1] = minwrk_;
    rwork_[0] = rminwrk_;
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0)) {
    goto _l0;
  }
  big_ = _dlamch (_dc_30);
  ascaled_ = FALSE;
  iwoff_ = 1;
  if (rowprm_) {
    iwoff_ = (*m_);
    for (p_ = 1; p_ <= (*m_); (p_)++) {
      rwork_[p_ - 1] = _dlange (_dc_8, &_k1, n_, &a_[p_ - 1 + ((*lda_)) * ((0))], lda_, rdummy_);
      if ((rwork_[p_ - 1] != rwork_[p_ - 1]) || ((rwork_[p_ - 1] * 0.0) != 0.0)) {
        (*info_) = -8;
        (void) _xerbla (_dc_61, ($25_ = -(*info_), &$25_));
        goto _l0;
      }
    }
    for (p_ = 1; p_ <= (*m_) - 1; (p_)++) {
      q_ = _idamax (($26_ = (*m_) - p_ + 1, &$26_), &rwork_[p_ - 1], &_k1) + p_ - 1;
      iwork_[(*n_) + p_ - 1] = q_;
      if (p_ != q_) {
        rtmp_ = rwork_[p_ - 1];
        rwork_[p_ - 1] = rwork_[q_ - 1];
        rwork_[q_ - 1] = rtmp_;
      }
    }
    if (rwork_[0] == 0.0) {
      (*numrank_) = 0;
      (void) _dlaset (_dc_9, n_, &_k1, ($27_ = 0.0, &$27_), ($28_ = 0.0, &$28_), s_, n_);
      if (wntus_) {
        (void) _dlaset (_dc_9, m_, n_, ($29_ = 0.0, &$29_), ($30_ = 1.0, &$30_), u_, ldu_);
      }
      if (wntua_) {
        (void) _dlaset (_dc_9, m_, m_, ($31_ = 0.0, &$31_), ($32_ = 1.0, &$32_), u_, ldu_);
      }
      if (wntva_) {
        (void) _dlaset (_dc_9, n_, n_, ($33_ = 0.0, &$33_), ($34_ = 1.0, &$34_), v_, ldv_);
      }
      if (wntuf_) {
        (void) _dlaset (_dc_9, n_, &_k1, ($35_ = 0.0, &$35_), ($36_ = 0.0, &$36_), work_, n_);
        (void) _dlaset (_dc_9, m_, n_, ($37_ = 0.0, &$37_), ($38_ = 1.0, &$38_), u_, ldu_);
      }
      for (p_ = 1; p_ <= (*n_); (p_)++) {
        iwork_[p_ - 1] = p_;
      }
      if (rowprm_) {
        for (p_ = (*n_) + 1; p_ <= (*n_) + (*m_) - 1; (p_)++) {
          iwork_[p_ - 1] = p_ - (*n_);
        }
      }
      if (conda_) {
        rwork_[0] = -1;
      }
      rwork_[1] = -1;
      goto _l0;
    }
    if (rwork_[0] > big_ / sqrt ((real_8) ((*m_)))) {
      (void) _dlascl (_dc_9, &_k0, &_k0, ($39_ = sqrt ((real_8) ((*m_))), &$39_), ($40_ = 1.0, &$40_), m_, n_, a_, lda_, 
      &ierr_);
      ascaled_ = TRUE;
    }
    (void) _dlaswp (n_, a_, lda_, &_k1, ($41_ = (*m_) - 1, &$41_), &iwork_[(*n_) + 1 - 1], &_k1);
  }
  if (! (rowprm_)) {
    rtmp_ = _dlange (_dc_8, m_, n_, a_, lda_, rdummy_);
    if ((rtmp_ != rtmp_) || ((rtmp_ * 0.0) != 0.0)) {
      (*info_) = -8;
      (void) _xerbla (_dc_61, ($42_ = -(*info_), &$42_));
      goto _l0;
    }
    if (rtmp_ > big_ / sqrt ((real_8) ((*m_)))) {
      (void) _dlascl (_dc_9, &_k0, &_k0, ($43_ = sqrt ((real_8) ((*m_))), &$43_), ($44_ = 1.0, &$44_), m_, n_, a_, lda_, 
      &ierr_);
      ascaled_ = TRUE;
    }
  }
  for (p_ = 1; p_ <= (*n_); (p_)++) {
    iwork_[p_ - 1] = 0;
  }
  (void) _dgeqp3 (m_, n_, a_, lda_, iwork_, work_, &work_[(*n_) + 1 - 1], ($45_ = (*lwork_) - (*n_), &$45_), &ierr_);
  epsln_ = _dlamch (_dc_24);
  sfmin_ = _dlamch (_dc_52);
  nr_ = (*n_);
  if (accla_) {
    nr_ = 1;
    rtmp_ = sqrt ((real_8) ((*n_))) * epsln_;
    for (p_ = 2; p_ <= (*n_); (p_)++) {
      if (_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) < (rtmp_ * _abs (a_[0 + ((*lda_)) * ((0))]))) {
        goto _l3002;
      }
      nr_ = nr_ + 1;
    }
    _l3002:;
  }
  else if (acclm_) {
    nr_ = 1;
    for (p_ = 2; p_ <= (*n_); (p_)++) {
      if ((_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) < (epsln_ * _abs (a_[p_ - 1 - 1 + ((*lda_)) * ((p_ - 1 - 1))]))) || 
        (_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) < sfmin_)) {
        goto _l3402;
      }
      nr_ = nr_ + 1;
    }
    _l3402:;
  }
  else {
    nr_ = 1;
    for (p_ = 2; p_ <= (*n_); (p_)++) {
      if (_abs (a_[p_ - 1 + ((*lda_)) * ((p_ - 1))]) == 0.0) {
        goto _l3502;
      }
      nr_ = nr_ + 1;
    }
    _l3502:;
    if (conda_) {
      (void) _dlacpy (_dc_0, n_, n_, a_, lda_, v_, ldv_);
      for (p_ = 1; p_ <= nr_; (p_)++) {
        rtmp_ = _dnrm2 (&p_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
        (void) _dscal (&p_, ($46_ = 1.0 / rtmp_, &$46_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
      }
      if (! ((lsvec_ || rsvec_))) {
        (void) _dpocon (_dc_0, &nr_, v_, ldv_, ($47_ = 1.0, &$47_), &rtmp_, work_, &iwork_[(*n_) + iwoff_ - 1], &ierr_);
      }
      else {
        (void) _dpocon (_dc_0, &nr_, v_, ldv_, ($48_ = 1.0, &$48_), &rtmp_, &work_[(*n_) + 1 - 1], &iwork_[(*n_) + iwoff_ - 1], 
        &ierr_);
      }
      sconda_ = 1.0 / sqrt (rtmp_);
    }
  }
  if (wntur_) {
    n1_ = nr_;
  }
  else if (wntus_ || wntuf_) {
    n1_ = (*n_);
  }
  else if (wntua_) {
    n1_ = (*m_);
  }
  if (! ((rsvec_ || lsvec_))) {
    if (rtrans_) {
      for (p_ = 1; p_ <= _min ((*n_), nr_); (p_)++) {
        for (q_ = p_ + 1; q_ <= (*n_); (q_)++) {
          a_[q_ - 1 + ((*lda_)) * ((p_ - 1))] = a_[p_ - 1 + ((*lda_)) * ((q_ - 1))];
          if (q_ <= nr_) {
            a_[p_ - 1 + ((*lda_)) * ((q_ - 1))] = 0.0;
          }
        }
      }
      (void) _dgesvd (_dc_2, _dc_2, n_, &nr_, a_, lda_, s_, u_, ldu_, v_, ldv_, work_, lwork_, info_);
    }
    else {
      if (nr_ > 1) {
        (void) _dlaset (_dc_1, ($49_ = nr_ - 1, &$49_), ($50_ = nr_ - 1, &$50_), ($51_ = 0.0, &$51_), ($52_ = 0.0, &$52_), 
        &a_[1 + ((*lda_)) * ((0))], lda_);
      }
      (void) _dgesvd (_dc_2, _dc_2, &nr_, n_, a_, lda_, s_, u_, ldu_, v_, ldv_, work_, lwork_, info_);
    }
  }
  else if (lsvec_ && (! (rsvec_))) {
    if (rtrans_) {
      for (p_ = 1; p_ <= nr_; (p_)++) {
        for (q_ = p_; q_ <= (*n_); (q_)++) {
          u_[q_ - 1 + ((*ldu_)) * ((p_ - 1))] = a_[p_ - 1 + ((*lda_)) * ((q_ - 1))];
        }
      }
      if (nr_ > 1) {
        (void) _dlaset (_dc_0, ($53_ = nr_ - 1, &$53_), ($54_ = nr_ - 1, &$54_), ($55_ = 0.0, &$55_), ($56_ = 0.0, &$56_), 
        &u_[0 + ((*ldu_)) * ((1))], ldu_);
      }
      (void) _dgesvd (_dc_2, _dc_30, n_, &nr_, u_, ldu_, s_, u_, ldu_, u_, ldu_, &work_[(*n_) + 1 - 1], ($57_ = (*lwork_) - 
      (*n_), &$57_), info_);
      for (p_ = 1; p_ <= nr_; (p_)++) {
        for (q_ = p_ + 1; q_ <= nr_; (q_)++) {
          rtmp_ = u_[q_ - 1 + ((*ldu_)) * ((p_ - 1))];
          u_[q_ - 1 + ((*ldu_)) * ((p_ - 1))] = u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))];
          u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))] = rtmp_;
        }
      }
    }
    else {
      (void) _dlacpy (_dc_0, &nr_, n_, a_, lda_, u_, ldu_);
      if (nr_ > 1) {
        (void) _dlaset (_dc_1, ($58_ = nr_ - 1, &$58_), ($59_ = nr_ - 1, &$59_), ($60_ = 0.0, &$60_), ($61_ = 0.0, &$61_), 
        &u_[1 + ((*ldu_)) * ((0))], ldu_);
      }
      (void) _dgesvd (_dc_30, _dc_2, &nr_, n_, u_, ldu_, s_, u_, ldu_, v_, ldv_, &work_[(*n_) + 1 - 1], ($62_ = (*lwork_) - 
      (*n_), &$62_), info_);
    }
    if ((nr_ < (*m_)) && (! (wntuf_))) {
      (void) _dlaset (_dc_7, ($63_ = (*m_) - nr_, &$63_), &nr_, ($64_ = 0.0, &$64_), ($65_ = 0.0, &$65_), &u_[nr_ + 1 - 1 + 
      ((*ldu_)) * ((0))], ldu_);
      if (nr_ < n1_) {
        (void) _dlaset (_dc_7, &nr_, ($66_ = n1_ - nr_, &$66_), ($67_ = 0.0, &$67_), ($68_ = 0.0, &$68_), &u_[0 + ((*ldu_)) * 
        ((nr_ + 1 - 1))], ldu_);
        (void) _dlaset (_dc_7, ($69_ = (*m_) - nr_, &$69_), ($70_ = n1_ - nr_, &$70_), ($71_ = 0.0, &$71_), ($72_ = 1.0, 
        &$72_), &u_[nr_ + 1 - 1 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
      }
    }
    if (! (wntuf_)) {
      (void) _dormqr (_dc_1, _dc_2, m_, &n1_, n_, a_, lda_, work_, u_, ldu_, &work_[(*n_) + 1 - 1], ($73_ = (*lwork_) - 
      (*n_), &$73_), &ierr_);
    }
    if (rowprm_ && ! (wntuf_)) {
      (void) _dlaswp (&n1_, u_, ldu_, &_k1, ($74_ = (*m_) - 1, &$74_), &iwork_[(*n_) + 1 - 1], &_km1);
    }
  }
  else if (rsvec_ && (! (lsvec_))) {
    if (rtrans_) {
      for (p_ = 1; p_ <= nr_; (p_)++) {
        for (q_ = p_; q_ <= (*n_); (q_)++) {
          v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = (a_[p_ - 1 + ((*lda_)) * ((q_ - 1))]);
        }
      }
      if (nr_ > 1) {
        (void) _dlaset (_dc_0, ($75_ = nr_ - 1, &$75_), ($76_ = nr_ - 1, &$76_), ($77_ = 0.0, &$77_), ($78_ = 0.0, &$78_), 
        &v_[0 + ((*ldv_)) * ((1))], ldv_);
      }
      if (wntvr_ || (nr_ == (*n_))) {
        (void) _dgesvd (_dc_30, _dc_2, n_, &nr_, v_, ldv_, s_, u_, ldu_, u_, ldu_, &work_[(*n_) + 1 - 1], ($79_ = (*lwork_) - 
        (*n_), &$79_), info_);
        for (p_ = 1; p_ <= nr_; (p_)++) {
          for (q_ = p_ + 1; q_ <= nr_; (q_)++) {
            rtmp_ = v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))];
            v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))];
            v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = rtmp_;
          }
        }
        if (nr_ < (*n_)) {
          for (p_ = 1; p_ <= nr_; (p_)++) {
            for (q_ = nr_ + 1; q_ <= (*n_); (q_)++) {
              v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))];
            }
          }
        }
        (void) _dlapmt (($80_ = FALSE, &$80_), &nr_, n_, v_, ldv_, iwork_);
      }
      else {
        (void) _dlaset (_dc_9, n_, ($81_ = (*n_) - nr_, &$81_), ($82_ = 0.0, &$82_), ($83_ = 0.0, &$83_), &v_[0 + ((*ldv_)) * 
        ((nr_ + 1 - 1))], ldv_);
        (void) _dgesvd (_dc_30, _dc_2, n_, n_, v_, ldv_, s_, u_, ldu_, u_, ldu_, &work_[(*n_) + 1 - 1], ($84_ = (*lwork_) - 
        (*n_), &$84_), info_);
        for (p_ = 1; p_ <= (*n_); (p_)++) {
          for (q_ = p_ + 1; q_ <= (*n_); (q_)++) {
            rtmp_ = v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))];
            v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))];
            v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = rtmp_;
          }
        }
        (void) _dlapmt (($85_ = FALSE, &$85_), n_, n_, v_, ldv_, iwork_);
      }
    }
    else {
      (void) _dlacpy (_dc_0, &nr_, n_, a_, lda_, v_, ldv_);
      if (nr_ > 1) {
        (void) _dlaset (_dc_1, ($86_ = nr_ - 1, &$86_), ($87_ = nr_ - 1, &$87_), ($88_ = 0.0, &$88_), ($89_ = 0.0, &$89_), 
        &v_[1 + ((*ldv_)) * ((0))], ldv_);
      }
      if (wntvr_ || (nr_ == (*n_))) {
        (void) _dgesvd (_dc_2, _dc_30, &nr_, n_, v_, ldv_, s_, u_, ldu_, v_, ldv_, &work_[(*n_) + 1 - 1], ($90_ = (*lwork_) - 
        (*n_), &$90_), info_);
        (void) _dlapmt (($91_ = FALSE, &$91_), &nr_, n_, v_, ldv_, iwork_);
      }
      else {
        (void) _dlaset (_dc_9, ($92_ = (*n_) - nr_, &$92_), n_, ($93_ = 0.0, &$93_), ($94_ = 0.0, &$94_), &v_[nr_ + 1 - 1 + 
        ((*ldv_)) * ((0))], ldv_);
        (void) _dgesvd (_dc_2, _dc_30, n_, n_, v_, ldv_, s_, u_, ldu_, v_, ldv_, &work_[(*n_) + 1 - 1], ($95_ = (*lwork_) - 
        (*n_), &$95_), info_);
        (void) _dlapmt (($96_ = FALSE, &$96_), n_, n_, v_, ldv_, iwork_);
      }
    }
  }
  else {
    if (rtrans_) {
      if (wntvr_ || (nr_ == (*n_))) {
        for (p_ = 1; p_ <= nr_; (p_)++) {
          for (q_ = p_; q_ <= (*n_); (q_)++) {
            v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = a_[p_ - 1 + ((*lda_)) * ((q_ - 1))];
          }
        }
        if (nr_ > 1) {
          (void) _dlaset (_dc_0, ($97_ = nr_ - 1, &$97_), ($98_ = nr_ - 1, &$98_), ($99_ = 0.0, &$99_), ($100_ = 0.0, &$100_), 
          &v_[0 + ((*ldv_)) * ((1))], ldv_);
        }
        (void) _dgesvd (_dc_30, _dc_7, n_, &nr_, v_, ldv_, s_, v_, ldv_, u_, ldu_, &work_[(*n_) + 1 - 1], ($101_ = (*lwork_) - 
        (*n_), &$101_), info_);
        for (p_ = 1; p_ <= nr_; (p_)++) {
          for (q_ = p_ + 1; q_ <= nr_; (q_)++) {
            rtmp_ = v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))];
            v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))];
            v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = rtmp_;
          }
        }
        if (nr_ < (*n_)) {
          for (p_ = 1; p_ <= nr_; (p_)++) {
            for (q_ = nr_ + 1; q_ <= (*n_); (q_)++) {
              v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))];
            }
          }
        }
        (void) _dlapmt (($102_ = FALSE, &$102_), &nr_, n_, v_, ldv_, iwork_);
        for (p_ = 1; p_ <= nr_; (p_)++) {
          for (q_ = p_ + 1; q_ <= nr_; (q_)++) {
            rtmp_ = u_[q_ - 1 + ((*ldu_)) * ((p_ - 1))];
            u_[q_ - 1 + ((*ldu_)) * ((p_ - 1))] = u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))];
            u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))] = rtmp_;
          }
        }
        if ((nr_ < (*m_)) && ! ((wntuf_))) {
          (void) _dlaset (_dc_7, ($103_ = (*m_) - nr_, &$103_), &nr_, ($104_ = 0.0, &$104_), ($105_ = 0.0, &$105_), &u_[nr_ + 1 - 
          1 + ((*ldu_)) * ((0))], ldu_);
          if (nr_ < n1_) {
            (void) _dlaset (_dc_7, &nr_, ($106_ = n1_ - nr_, &$106_), ($107_ = 0.0, &$107_), ($108_ = 0.0, &$108_), &u_[0 + 
            ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
            (void) _dlaset (_dc_7, ($109_ = (*m_) - nr_, &$109_), ($110_ = n1_ - nr_, &$110_), ($111_ = 0.0, &$111_), ($112_ = 1.0, 
            &$112_), &u_[nr_ + 1 - 1 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
          }
        }
      }
      else {
        optratio_ = 2;
        if (optratio_ * nr_ > (*n_)) {
          for (p_ = 1; p_ <= nr_; (p_)++) {
            for (q_ = p_; q_ <= (*n_); (q_)++) {
              v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = a_[p_ - 1 + ((*lda_)) * ((q_ - 1))];
            }
          }
          if (nr_ > 1) {
            (void) _dlaset (_dc_0, ($113_ = nr_ - 1, &$113_), ($114_ = nr_ - 1, &$114_), ($115_ = 0.0, &$115_), ($116_ = 0.0, 
            &$116_), &v_[0 + ((*ldv_)) * ((1))], ldv_);
          }
          (void) _dlaset (_dc_7, n_, ($117_ = (*n_) - nr_, &$117_), ($118_ = 0.0, &$118_), ($119_ = 0.0, &$119_), &v_[0 + 
          ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
          (void) _dgesvd (_dc_30, _dc_7, n_, n_, v_, ldv_, s_, v_, ldv_, u_, ldu_, &work_[(*n_) + 1 - 1], ($120_ = (*lwork_) - 
          (*n_), &$120_), info_);
          for (p_ = 1; p_ <= (*n_); (p_)++) {
            for (q_ = p_ + 1; q_ <= (*n_); (q_)++) {
              rtmp_ = v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))];
              v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))];
              v_[p_ - 1 + ((*ldv_)) * ((q_ - 1))] = rtmp_;
            }
          }
          (void) _dlapmt (($121_ = FALSE, &$121_), n_, n_, v_, ldv_, iwork_);
          for (p_ = 1; p_ <= (*n_); (p_)++) {
            for (q_ = p_ + 1; q_ <= (*n_); (q_)++) {
              rtmp_ = u_[q_ - 1 + ((*ldu_)) * ((p_ - 1))];
              u_[q_ - 1 + ((*ldu_)) * ((p_ - 1))] = u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))];
              u_[p_ - 1 + ((*ldu_)) * ((q_ - 1))] = rtmp_;
            }
          }
          if (((*n_) < (*m_)) && ! ((wntuf_))) {
            (void) _dlaset (_dc_7, ($122_ = (*m_) - (*n_), &$122_), n_, ($123_ = 0.0, &$123_), ($124_ = 0.0, &$124_), &u_[(*n_) + 1 
            - 1 + ((*ldu_)) * ((0))], ldu_);
            if ((*n_) < n1_) {
              (void) _dlaset (_dc_7, n_, ($125_ = n1_ - (*n_), &$125_), ($126_ = 0.0, &$126_), ($127_ = 0.0, &$127_), &u_[0 + 
              ((*ldu_)) * (((*n_) + 1 - 1))], ldu_);
              (void) _dlaset (_dc_7, ($128_ = (*m_) - (*n_), &$128_), ($129_ = n1_ - (*n_), &$129_), ($130_ = 0.0, &$130_), ($131_ = 
              1.0, &$131_), &u_[(*n_) + 1 - 1 + ((*ldu_)) * (((*n_) + 1 - 1))], ldu_);
            }
          }
        }
        else {
          for (p_ = 1; p_ <= nr_; (p_)++) {
            for (q_ = p_; q_ <= (*n_); (q_)++) {
              u_[q_ - 1 + ((*ldu_)) * ((nr_ + p_ - 1))] = a_[p_ - 1 + ((*lda_)) * ((q_ - 1))];
            }
          }
          if (nr_ > 1) {
            (void) _dlaset (_dc_0, ($132_ = nr_ - 1, &$132_), ($133_ = nr_ - 1, &$133_), ($134_ = 0.0, &$134_), ($135_ = 0.0, 
            &$135_), &u_[0 + ((*ldu_)) * ((nr_ + 2 - 1))], ldu_);
          }
          (void) _dgeqrf (n_, &nr_, &u_[0 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_, &work_[(*n_) + 1 - 1], &work_[(*n_) + nr_ + 1 - 
          1], ($136_ = (*lwork_) - (*n_) - nr_, &$136_), &ierr_);
          for (p_ = 1; p_ <= nr_; (p_)++) {
            for (q_ = 1; q_ <= (*n_); (q_)++) {
              v_[q_ - 1 + ((*ldv_)) * ((p_ - 1))] = u_[p_ - 1 + ((*ldu_)) * ((nr_ + q_ - 1))];
            }
          }
          (void) _dlaset (_dc_0, ($137_ = nr_ - 1, &$137_), ($138_ = nr_ - 1, &$138_), ($139_ = 0.0, &$139_), ($140_ = 0.0, 
          &$140_), &v_[0 + ((*ldv_)) * ((1))], ldv_);
          (void) _dgesvd (_dc_52, _dc_30, &nr_, &nr_, v_, ldv_, s_, u_, ldu_, v_, ldv_, &work_[(*n_) + nr_ + 1 - 1], ($141_ = 
          (*lwork_) - (*n_) - nr_, &$141_), info_);
          (void) _dlaset (_dc_7, ($142_ = (*n_) - nr_, &$142_), &nr_, ($143_ = 0.0, &$143_), ($144_ = 0.0, &$144_), &v_[nr_ + 1 - 
          1 + ((*ldv_)) * ((0))], ldv_);
          (void) _dlaset (_dc_7, &nr_, ($145_ = (*n_) - nr_, &$145_), ($146_ = 0.0, &$146_), ($147_ = 0.0, &$147_), &v_[0 + 
          ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
          (void) _dlaset (_dc_7, ($148_ = (*n_) - nr_, &$148_), ($149_ = (*n_) - nr_, &$149_), ($150_ = 0.0, &$150_), ($151_ = 
          1.0, &$151_), &v_[nr_ + 1 - 1 + ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
          (void) _dormqr (_dc_15, _dc_26, n_, n_, &nr_, &u_[0 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_, &work_[(*n_) + 1 - 1], v_, 
          ldv_, &work_[(*n_) + nr_ + 1 - 1], ($152_ = (*lwork_) - (*n_) - nr_, &$152_), &ierr_);
          (void) _dlapmt (($153_ = FALSE, &$153_), n_, n_, v_, ldv_, iwork_);
          if ((nr_ < (*m_)) && ! ((wntuf_))) {
            (void) _dlaset (_dc_7, ($154_ = (*m_) - nr_, &$154_), &nr_, ($155_ = 0.0, &$155_), ($156_ = 0.0, &$156_), &u_[nr_ + 1 - 
            1 + ((*ldu_)) * ((0))], ldu_);
            if (nr_ < n1_) {
              (void) _dlaset (_dc_7, &nr_, ($157_ = n1_ - nr_, &$157_), ($158_ = 0.0, &$158_), ($159_ = 0.0, &$159_), &u_[0 + 
              ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
              (void) _dlaset (_dc_7, ($160_ = (*m_) - nr_, &$160_), ($161_ = n1_ - nr_, &$161_), ($162_ = 0.0, &$162_), ($163_ = 1.0, 
              &$163_), &u_[nr_ + 1 - 1 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
            }
          }
        }
      }
    }
    else {
      if (wntvr_ || (nr_ == (*n_))) {
        (void) _dlacpy (_dc_0, &nr_, n_, a_, lda_, v_, ldv_);
        if (nr_ > 1) {
          (void) _dlaset (_dc_1, ($164_ = nr_ - 1, &$164_), ($165_ = nr_ - 1, &$165_), ($166_ = 0.0, &$166_), ($167_ = 0.0, 
          &$167_), &v_[1 + ((*ldv_)) * ((0))], ldv_);
        }
        (void) _dgesvd (_dc_52, _dc_30, &nr_, n_, v_, ldv_, s_, u_, ldu_, v_, ldv_, &work_[(*n_) + 1 - 1], ($168_ = (*lwork_) - 
        (*n_), &$168_), info_);
        (void) _dlapmt (($169_ = FALSE, &$169_), &nr_, n_, v_, ldv_, iwork_);
        if ((nr_ < (*m_)) && ! ((wntuf_))) {
          (void) _dlaset (_dc_7, ($170_ = (*m_) - nr_, &$170_), &nr_, ($171_ = 0.0, &$171_), ($172_ = 0.0, &$172_), &u_[nr_ + 1 - 
          1 + ((*ldu_)) * ((0))], ldu_);
          if (nr_ < n1_) {
            (void) _dlaset (_dc_7, &nr_, ($173_ = n1_ - nr_, &$173_), ($174_ = 0.0, &$174_), ($175_ = 0.0, &$175_), &u_[0 + 
            ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
            (void) _dlaset (_dc_7, ($176_ = (*m_) - nr_, &$176_), ($177_ = n1_ - nr_, &$177_), ($178_ = 0.0, &$178_), ($179_ = 1.0, 
            &$179_), &u_[nr_ + 1 - 1 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
          }
        }
      }
      else {
        optratio_ = 2;
        if (optratio_ * nr_ > (*n_)) {
          (void) _dlacpy (_dc_0, &nr_, n_, a_, lda_, v_, ldv_);
          if (nr_ > 1) {
            (void) _dlaset (_dc_1, ($180_ = nr_ - 1, &$180_), ($181_ = nr_ - 1, &$181_), ($182_ = 0.0, &$182_), ($183_ = 0.0, 
            &$183_), &v_[1 + ((*ldv_)) * ((0))], ldv_);
          }
          (void) _dlaset (_dc_7, ($184_ = (*n_) - nr_, &$184_), n_, ($185_ = 0.0, &$185_), ($186_ = 0.0, &$186_), &v_[nr_ + 1 - 1 
          + ((*ldv_)) * ((0))], ldv_);
          (void) _dgesvd (_dc_52, _dc_30, n_, n_, v_, ldv_, s_, u_, ldu_, v_, ldv_, &work_[(*n_) + 1 - 1], ($187_ = (*lwork_) - 
          (*n_), &$187_), info_);
          (void) _dlapmt (($188_ = FALSE, &$188_), n_, n_, v_, ldv_, iwork_);
          if (((*n_) < (*m_)) && ! ((wntuf_))) {
            (void) _dlaset (_dc_7, ($189_ = (*m_) - (*n_), &$189_), n_, ($190_ = 0.0, &$190_), ($191_ = 0.0, &$191_), &u_[(*n_) + 1 
            - 1 + ((*ldu_)) * ((0))], ldu_);
            if ((*n_) < n1_) {
              (void) _dlaset (_dc_7, n_, ($192_ = n1_ - (*n_), &$192_), ($193_ = 0.0, &$193_), ($194_ = 0.0, &$194_), &u_[0 + 
              ((*ldu_)) * (((*n_) + 1 - 1))], ldu_);
              (void) _dlaset (_dc_7, ($195_ = (*m_) - (*n_), &$195_), ($196_ = n1_ - (*n_), &$196_), ($197_ = 0.0, &$197_), ($198_ = 
              1.0, &$198_), &u_[(*n_) + 1 - 1 + ((*ldu_)) * (((*n_) + 1 - 1))], ldu_);
            }
          }
        }
        else {
          (void) _dlacpy (_dc_0, &nr_, n_, a_, lda_, &u_[nr_ + 1 - 1 + ((*ldu_)) * ((0))], ldu_);
          if (nr_ > 1) {
            (void) _dlaset (_dc_1, ($199_ = nr_ - 1, &$199_), ($200_ = nr_ - 1, &$200_), ($201_ = 0.0, &$201_), ($202_ = 0.0, 
            &$202_), &u_[nr_ + 2 - 1 + ((*ldu_)) * ((0))], ldu_);
          }
          (void) _dgelqf (&nr_, n_, &u_[nr_ + 1 - 1 + ((*ldu_)) * ((0))], ldu_, &work_[(*n_) + 1 - 1], &work_[(*n_) + nr_ + 1 - 
          1], ($203_ = (*lwork_) - (*n_) - nr_, &$203_), &ierr_);
          (void) _dlacpy (_dc_1, &nr_, &nr_, &u_[nr_ + 1 - 1 + ((*ldu_)) * ((0))], ldu_, v_, ldv_);
          if (nr_ > 1) {
            (void) _dlaset (_dc_0, ($204_ = nr_ - 1, &$204_), ($205_ = nr_ - 1, &$205_), ($206_ = 0.0, &$206_), ($207_ = 0.0, 
            &$207_), &v_[0 + ((*ldv_)) * ((1))], ldv_);
          }
          (void) _dgesvd (_dc_52, _dc_30, &nr_, &nr_, v_, ldv_, s_, u_, ldu_, v_, ldv_, &work_[(*n_) + nr_ + 1 - 1], ($208_ = 
          (*lwork_) - (*n_) - nr_, &$208_), info_);
          (void) _dlaset (_dc_7, ($209_ = (*n_) - nr_, &$209_), &nr_, ($210_ = 0.0, &$210_), ($211_ = 0.0, &$211_), &v_[nr_ + 1 - 
          1 + ((*ldv_)) * ((0))], ldv_);
          (void) _dlaset (_dc_7, &nr_, ($212_ = (*n_) - nr_, &$212_), ($213_ = 0.0, &$213_), ($214_ = 0.0, &$214_), &v_[0 + 
          ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
          (void) _dlaset (_dc_7, ($215_ = (*n_) - nr_, &$215_), ($216_ = (*n_) - nr_, &$216_), ($217_ = 0.0, &$217_), ($218_ = 
          1.0, &$218_), &v_[nr_ + 1 - 1 + ((*ldv_)) * ((nr_ + 1 - 1))], ldv_);
          (void) _dormlq (_dc_15, _dc_2, n_, n_, &nr_, &u_[nr_ + 1 - 1 + ((*ldu_)) * ((0))], ldu_, &work_[(*n_) + 1 - 1], v_, 
          ldv_, &work_[(*n_) + nr_ + 1 - 1], ($219_ = (*lwork_) - (*n_) - nr_, &$219_), &ierr_);
          (void) _dlapmt (($220_ = FALSE, &$220_), n_, n_, v_, ldv_, iwork_);
          if ((nr_ < (*m_)) && ! ((wntuf_))) {
            (void) _dlaset (_dc_7, ($221_ = (*m_) - nr_, &$221_), &nr_, ($222_ = 0.0, &$222_), ($223_ = 0.0, &$223_), &u_[nr_ + 1 - 
            1 + ((*ldu_)) * ((0))], ldu_);
            if (nr_ < n1_) {
              (void) _dlaset (_dc_7, &nr_, ($224_ = n1_ - nr_, &$224_), ($225_ = 0.0, &$225_), ($226_ = 0.0, &$226_), &u_[0 + 
              ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
              (void) _dlaset (_dc_7, ($227_ = (*m_) - nr_, &$227_), ($228_ = n1_ - nr_, &$228_), ($229_ = 0.0, &$229_), ($230_ = 1.0, 
              &$230_), &u_[nr_ + 1 - 1 + ((*ldu_)) * ((nr_ + 1 - 1))], ldu_);
            }
          }
        }
      }
    }
    if (! (wntuf_)) {
      (void) _dormqr (_dc_1, _dc_2, m_, &n1_, n_, a_, lda_, work_, u_, ldu_, &work_[(*n_) + 1 - 1], ($231_ = (*lwork_) - 
      (*n_), &$231_), &ierr_);
    }
    if (rowprm_ && ! (wntuf_)) {
      (void) _dlaswp (&n1_, u_, ldu_, &_k1, ($232_ = (*m_) - 1, &$232_), &iwork_[(*n_) + 1 - 1], &_km1);
    }
  }
  p_ = nr_;
  for (q_ = p_; q_ >= 1; (q_)--) {
    if (s_[q_ - 1] > 0.0) {
      goto _l4002;
    }
    nr_ = nr_ - 1;
  }
  _l4002:;
  if (nr_ < (*n_)) {
    (void) _dlaset (_dc_9, ($233_ = (*n_) - nr_, &$233_), &_k1, ($234_ = 0.0, &$234_), ($235_ = 0.0, &$235_), &s_[nr_ + 1 - 
    1], n_);
  }
  if (ascaled_) {
    (void) _dlascl (_dc_9, &_k0, &_k0, ($236_ = 1.0, &$236_), ($237_ = sqrt ((real_8) ((*m_))), &$237_), &nr_, &_k1, s_, 
    n_, &ierr_);
  }
  if (conda_) {
    rwork_[0] = sconda_;
  }
  rwork_[1] = p_ - nr_;
  (*numrank_) = nr_;
  _l0:;
  __calls[15].calls++;
  return 0;
}

int_4 _dgesvj (char _p_ joba_, char _p_ jobu_, char _p_ jobv_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ 
lda_, real_8 _p_ sva_, int_4 _p_ mv_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ 
info_)
{
  static int_4 blskip_, emptsw_, i_, ibr_, ierr_, igl_, ijblsk_, ir1_, iswrot_, jbc_, jgl_, kbl_, lkahead_, mvl_, n2_, 
  n34_, n4_, nbl_, notrot_, p_, pskipped_, q_, rowskip_, swband_;
  static logical_4 applv_, goscale_, lower_, lsvec_, noscale_, rotok_, rsvec_, uctol_, upper_;
  static real_8 aapp_, aapp0_, aapq_, aaqq_, apoaq_, aqoap_, big_, bigtheta_, cs_, ctol_, epsln_, large_, mxaapq_, 
  mxsinj_, rootbig_, rooteps_, rootsfmin_, roottol_, skl_, sfmin_, small_, sn_, t_, temp1_, theta_, thsign_, tol_, 
  fastr_[5];
  int_4 $0_, $3_, $7_, $8_, $9_, $10_, $19_, $20_, $21_, $22_, $23_, $24_, $25_, $26_, $27_, $28_, $29_, $30_, $31_, $32_
  , $33_, $34_, $35_, $36_, $37_, $38_, $39_, $40_, $41_, $106_;
  real_8 $1_, $2_, $4_, $5_, $6_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $42_, $43_, $44_, $45_, $46_, $47_, 
  $48_, $49_, $50_, $51_, $52_, $53_, $54_, $55_, $56_, $57_, $58_, $59_, $60_, $61_, $62_, $63_, $64_, $65_, $66_, $67_, 
  $68_, $69_, $70_, $71_, $72_, $73_, $74_, $75_, $76_, $77_, $78_, $79_, $80_, $81_, $82_, $83_, $84_, $85_, $86_, $87_, 
  $88_, $89_, $90_, $91_, $92_, $93_, $94_, $95_, $96_, $97_, $98_, $99_, $100_, $101_, $102_, $103_, $104_, $105_, $107_
  ;
  extern real_8 _dabs ();
  extern real_8 _dsign ();
  extern real_8 _dsqrt ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern int_4 _idamax ();
  extern real_8 _dlamch ();
  extern logical_4 _lsame ();
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern int_4 _drotm ();
  extern int_4 _dscal ();
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  real_8 __dabs (real_8 _p_ __x__) {return _abs (*__x__);}
  real_8 __dsign (real_8 _p_ __x__, real_8 _p_ __y__) {return _sign (*__x__, *__y__);}
  real_8 __dsqrt (real_8 _p_ __x__) {return sqrt (*__x__);}
  lsvec_ = _lsame (jobu_, _dc_0);
  uctol_ = _lsame (jobu_, _dc_26);
  rsvec_ = _lsame (jobv_, _dc_11);
  applv_ = _lsame (jobv_, _dc_7);
  upper_ = _lsame (joba_, _dc_0);
  lower_ = _lsame (joba_, _dc_1);
  if (! ((upper_ || lower_ || _lsame (joba_, _dc_9)))) {
    (*info_) = -1;
  }
  else if (! ((lsvec_ || uctol_ || _lsame (jobu_, _dc_2)))) {
    (*info_) = -2;
  }
  else if (! ((rsvec_ || applv_ || _lsame (jobv_, _dc_2)))) {
    (*info_) = -3;
  }
  else if ((*m_) < 0) {
    (*info_) = -4;
  }
  else if (((*n_) < 0) || ((*n_) > (*m_))) {
    (*info_) = -5;
  }
  else if ((*lda_) < (*m_)) {
    (*info_) = -7;
  }
  else if ((*mv_) < 0) {
    (*info_) = -9;
  }
  else if ((rsvec_ && ((*ldv_) < (*n_))) || (applv_ && ((*ldv_) < (*mv_)))) {
    (*info_) = -11;
  }
  else if (uctol_ && (work_[0] <= 1.0)) {
    (*info_) = -12;
  }
  else if ((*lwork_) < _max ((*m_) + (*n_), 6)) {
    (*info_) = -13;
  }
  else {
    (*info_) = 0;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_62, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0)) {
    goto _l0;
  }
  if (uctol_) {
    ctol_ = work_[0];
  }
  else {
    if (lsvec_ || rsvec_ || applv_) {
      ctol_ = __dsqrt (($1_ = (real_8) ((*m_)), &$1_));
    }
    else {
      ctol_ = (real_8) ((*m_));
    }
  }
  epsln_ = _dlamch (_dc_10);
  rooteps_ = __dsqrt (&epsln_);
  sfmin_ = _dlamch (_dc_29);
  rootsfmin_ = __dsqrt (&sfmin_);
  small_ = sfmin_ / epsln_;
  big_ = _dlamch (_dc_63);
  rootbig_ = 1.0 / rootsfmin_;
  large_ = big_ / __dsqrt (($2_ = (real_8) ((*m_) * (*n_)), &$2_));
  bigtheta_ = 1.0 / rooteps_;
  tol_ = ctol_ * epsln_;
  roottol_ = __dsqrt (&tol_);
  if ((real_8) ((*m_)) * epsln_ >= 1.0) {
    (*info_) = -4;
    (void) _xerbla (_dc_62, ($3_ = -(*info_), &$3_));
    goto _l0;
  }
  if (rsvec_) {
    mvl_ = (*n_);
    (void) _dlaset (_dc_7, &mvl_, n_, ($4_ = 0.0, &$4_), ($5_ = 1.0, &$5_), v_, ldv_);
  }
  else if (applv_) {
    mvl_ = (*mv_);
  }
  rsvec_ = rsvec_ || applv_;
  skl_ = 1.0 / __dsqrt (($6_ = (real_8) ((*m_)) * (real_8) ((*n_)), &$6_));
  noscale_ = TRUE;
  goscale_ = TRUE;
  if (lower_) {
    for (p_ = 1; p_ <= (*n_); (p_)++) {
      aapp_ = 0.0;
      aaqq_ = 1.0;
      (void) _dlassq (($7_ = (*m_) - p_ + 1, &$7_), &a_[p_ - 1 + ((*lda_)) * ((p_ - 1))], &_k1, &aapp_, &aaqq_);
      if (aapp_ > big_) {
        (*info_) = -6;
        (void) _xerbla (_dc_62, ($8_ = -(*info_), &$8_));
        goto _l0;
      }
      aaqq_ = __dsqrt (&aaqq_);
      if ((aapp_ < (big_ / aaqq_)) && noscale_) {
        sva_[p_ - 1] = aapp_ * aaqq_;
      }
      else {
        noscale_ = FALSE;
        sva_[p_ - 1] = aapp_ * (aaqq_ * skl_);
        if (goscale_) {
          goscale_ = FALSE;
          for (q_ = 1; q_ <= p_ - 1; (q_)++) {
            sva_[q_ - 1] = sva_[q_ - 1] * skl_;
          }
        }
      }
    }
  }
  else if (upper_) {
    for (p_ = 1; p_ <= (*n_); (p_)++) {
      aapp_ = 0.0;
      aaqq_ = 1.0;
      (void) _dlassq (&p_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &aapp_, &aaqq_);
      if (aapp_ > big_) {
        (*info_) = -6;
        (void) _xerbla (_dc_62, ($9_ = -(*info_), &$9_));
        goto _l0;
      }
      aaqq_ = __dsqrt (&aaqq_);
      if ((aapp_ < (big_ / aaqq_)) && noscale_) {
        sva_[p_ - 1] = aapp_ * aaqq_;
      }
      else {
        noscale_ = FALSE;
        sva_[p_ - 1] = aapp_ * (aaqq_ * skl_);
        if (goscale_) {
          goscale_ = FALSE;
          for (q_ = 1; q_ <= p_ - 1; (q_)++) {
            sva_[q_ - 1] = sva_[q_ - 1] * skl_;
          }
        }
      }
    }
  }
  else {
    for (p_ = 1; p_ <= (*n_); (p_)++) {
      aapp_ = 0.0;
      aaqq_ = 1.0;
      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &aapp_, &aaqq_);
      if (aapp_ > big_) {
        (*info_) = -6;
        (void) _xerbla (_dc_62, ($10_ = -(*info_), &$10_));
        goto _l0;
      }
      aaqq_ = __dsqrt (&aaqq_);
      if ((aapp_ < (big_ / aaqq_)) && noscale_) {
        sva_[p_ - 1] = aapp_ * aaqq_;
      }
      else {
        noscale_ = FALSE;
        sva_[p_ - 1] = aapp_ * (aaqq_ * skl_);
        if (goscale_) {
          goscale_ = FALSE;
          for (q_ = 1; q_ <= p_ - 1; (q_)++) {
            sva_[q_ - 1] = sva_[q_ - 1] * skl_;
          }
        }
      }
    }
  }
  if (noscale_) {
    skl_ = 1.0;
  }
  aapp_ = 0.0;
  aaqq_ = big_;
  for (p_ = 1; p_ <= (*n_); (p_)++) {
    if (sva_[p_ - 1] != 0.0) {
      aaqq_ = _min (aaqq_, sva_[p_ - 1]);
    }
    aapp_ = _max (aapp_, sva_[p_ - 1]);
  }
  if (aapp_ == 0.0) {
    if (lsvec_) {
      (void) _dlaset (_dc_9, m_, n_, ($11_ = 0.0, &$11_), ($12_ = 1.0, &$12_), a_, lda_);
    }
    work_[0] = 1.0;
    work_[1] = 0.0;
    work_[2] = 0.0;
    work_[3] = 0.0;
    work_[4] = 0.0;
    work_[5] = 0.0;
    goto _l0;
  }
  if ((*n_) == 1) {
    if (lsvec_) {
      (void) _dlascl (_dc_9, &_k0, &_k0, &sva_[0], &skl_, m_, &_k1, &a_[0 + ((*lda_)) * ((0))], lda_, &ierr_);
    }
    work_[0] = 1.0 / skl_;
    if (sva_[0] >= sfmin_) {
      work_[1] = 1.0;
    }
    else {
      work_[1] = 0.0;
    }
    work_[2] = 0.0;
    work_[3] = 0.0;
    work_[4] = 0.0;
    work_[5] = 0.0;
    goto _l0;
  }
  sn_ = __dsqrt (($13_ = sfmin_ / epsln_, &$13_));
  temp1_ = __dsqrt (($14_ = big_ / (real_8) ((*n_)), &$14_));
  if ((aapp_ <= sn_) || (aaqq_ >= temp1_) || ((sn_ <= aaqq_) && (aapp_ <= temp1_))) {
    temp1_ = _min (big_, temp1_ / aapp_);
  }
  else if ((aaqq_ <= sn_) && (aapp_ <= temp1_)) {
    temp1_ = _min (sn_ / aaqq_, big_ / (aapp_ * __dsqrt (($15_ = (real_8) ((*n_)), &$15_))));
  }
  else if ((aaqq_ >= sn_) && (aapp_ >= temp1_)) {
    temp1_ = _max (sn_ / aaqq_, temp1_ / aapp_);
  }
  else if ((aaqq_ <= sn_) && (aapp_ >= temp1_)) {
    temp1_ = _min (sn_ / aaqq_, big_ / (__dsqrt (($16_ = (real_8) ((*n_)), &$16_)) * aapp_));
  }
  else {
    temp1_ = 1.0;
  }
  if (temp1_ != 1.0) {
    (void) _dlascl (_dc_9, &_k0, &_k0, ($17_ = 1.0, &$17_), &temp1_, n_, &_k1, sva_, n_, &ierr_);
  }
  skl_ = temp1_ * skl_;
  if (skl_ != 1.0) {
    (void) _dlascl (joba_, &_k0, &_k0, ($18_ = 1.0, &$18_), &skl_, m_, n_, a_, lda_, &ierr_);
    skl_ = 1.0 / skl_;
  }
  emptsw_ = ((*n_) * ((*n_) - 1)) / 2;
  notrot_ = 0;
  fastr_[0] = 0.0;
  for (q_ = 1; q_ <= (*n_); (q_)++) {
    work_[q_ - 1] = 1.0;
  }
  swband_ = 3;
  kbl_ = _min (8, (*n_));
  nbl_ = (*n_) / kbl_;
  if ((nbl_ * kbl_) != (*n_)) {
    nbl_ = nbl_ + 1;
  }
  blskip_ = (kbl_ * kbl_);
  rowskip_ = _min (5, kbl_);
  lkahead_ = 1;
  if ((lower_ || upper_) && ((*n_) > _max (64, 4 * kbl_))) {
    n4_ = (*n_) / 4;
    n2_ = (*n_) / 2;
    n34_ = 3 * n4_;
    if (applv_) {
      q_ = 0;
    }
    else {
      q_ = 1;
    }
    if (lower_) {
      (void) _dgsvj0 (jobv_, ($19_ = (*m_) - n34_, &$19_), ($20_ = (*n_) - n34_, &$20_), &a_[n34_ + 1 - 1 + ((*lda_)) * 
      ((n34_ + 1 - 1))], lda_, &work_[n34_ + 1 - 1], &sva_[n34_ + 1 - 1], &mvl_, &v_[n34_ * q_ + 1 - 1 + ((*ldv_)) * ((n34_ + 
      1 - 1))], ldv_, &epsln_, &sfmin_, &tol_, ($21_ = 2, &$21_), &work_[(*n_) + 1 - 1], ($22_ = (*lwork_) - (*n_), &$22_), 
      &ierr_);
      (void) _dgsvj0 (jobv_, ($23_ = (*m_) - n2_, &$23_), ($24_ = n34_ - n2_, &$24_), &a_[n2_ + 1 - 1 + ((*lda_)) * ((n2_ + 1 
      - 1))], lda_, &work_[n2_ + 1 - 1], &sva_[n2_ + 1 - 1], &mvl_, &v_[n2_ * q_ + 1 - 1 + ((*ldv_)) * ((n2_ + 1 - 1))], 
      ldv_, &epsln_, &sfmin_, &tol_, ($25_ = 2, &$25_), &work_[(*n_) + 1 - 1], ($26_ = (*lwork_) - (*n_), &$26_), &ierr_);
      (void) _dgsvj1 (jobv_, ($27_ = (*m_) - n2_, &$27_), ($28_ = (*n_) - n2_, &$28_), &n4_, &a_[n2_ + 1 - 1 + ((*lda_)) * 
      ((n2_ + 1 - 1))], lda_, &work_[n2_ + 1 - 1], &sva_[n2_ + 1 - 1], &mvl_, &v_[n2_ * q_ + 1 - 1 + ((*ldv_)) * ((n2_ + 1 - 
      1))], ldv_, &epsln_, &sfmin_, &tol_, &_k1, &work_[(*n_) + 1 - 1], ($29_ = (*lwork_) - (*n_), &$29_), &ierr_);
      (void) _dgsvj0 (jobv_, ($30_ = (*m_) - n4_, &$30_), ($31_ = n2_ - n4_, &$31_), &a_[n4_ + 1 - 1 + ((*lda_)) * ((n4_ + 1 
      - 1))], lda_, &work_[n4_ + 1 - 1], &sva_[n4_ + 1 - 1], &mvl_, &v_[n4_ * q_ + 1 - 1 + ((*ldv_)) * ((n4_ + 1 - 1))], 
      ldv_, &epsln_, &sfmin_, &tol_, &_k1, &work_[(*n_) + 1 - 1], ($32_ = (*lwork_) - (*n_), &$32_), &ierr_);
      (void) _dgsvj0 (jobv_, m_, &n4_, a_, lda_, work_, sva_, &mvl_, v_, ldv_, &epsln_, &sfmin_, &tol_, &_k1, &work_[(*n_) + 
      1 - 1], ($33_ = (*lwork_) - (*n_), &$33_), &ierr_);
      (void) _dgsvj1 (jobv_, m_, &n2_, &n4_, a_, lda_, work_, sva_, &mvl_, v_, ldv_, &epsln_, &sfmin_, &tol_, &_k1, 
      &work_[(*n_) + 1 - 1], ($34_ = (*lwork_) - (*n_), &$34_), &ierr_);
    }
    else if (upper_) {
      (void) _dgsvj0 (jobv_, &n4_, &n4_, a_, lda_, work_, sva_, &mvl_, v_, ldv_, &epsln_, &sfmin_, &tol_, ($35_ = 2, &$35_), 
      &work_[(*n_) + 1 - 1], ($36_ = (*lwork_) - (*n_), &$36_), &ierr_);
      (void) _dgsvj0 (jobv_, &n2_, &n4_, &a_[0 + ((*lda_)) * ((n4_ + 1 - 1))], lda_, &work_[n4_ + 1 - 1], &sva_[n4_ + 1 - 1], 
      &mvl_, &v_[n4_ * q_ + 1 - 1 + ((*ldv_)) * ((n4_ + 1 - 1))], ldv_, &epsln_, &sfmin_, &tol_, &_k1, &work_[(*n_) + 1 - 1], 
      ($37_ = (*lwork_) - (*n_), &$37_), &ierr_);
      (void) _dgsvj1 (jobv_, &n2_, &n2_, &n4_, a_, lda_, work_, sva_, &mvl_, v_, ldv_, &epsln_, &sfmin_, &tol_, &_k1, 
      &work_[(*n_) + 1 - 1], ($38_ = (*lwork_) - (*n_), &$38_), &ierr_);
      (void) _dgsvj0 (jobv_, ($39_ = n2_ + n4_, &$39_), &n4_, &a_[0 + ((*lda_)) * ((n2_ + 1 - 1))], lda_, &work_[n2_ + 1 - 
      1], &sva_[n2_ + 1 - 1], &mvl_, &v_[n2_ * q_ + 1 - 1 + ((*ldv_)) * ((n2_ + 1 - 1))], ldv_, &epsln_, &sfmin_, &tol_, 
      &_k1, &work_[(*n_) + 1 - 1], ($40_ = (*lwork_) - (*n_), &$40_), &ierr_);
    }
  }
  for (i_ = 1; i_ <= 30; (i_)++) {
    mxaapq_ = 0.0;
    mxsinj_ = 0.0;
    iswrot_ = 0;
    notrot_ = 0;
    pskipped_ = 0;
    for (ibr_ = 1; ibr_ <= nbl_; (ibr_)++) {
      igl_ = (ibr_ - 1) * kbl_ + 1;
      for (ir1_ = 0; ir1_ <= _min (lkahead_, nbl_ - ibr_); (ir1_)++) {
        igl_ = igl_ + ir1_ * kbl_;
        for (p_ = igl_; p_ <= _min (igl_ + kbl_ - 1, (*n_) - 1); (p_)++) {
          q_ = _idamax (($41_ = (*n_) - p_ + 1, &$41_), &sva_[p_ - 1], &_k1) + p_ - 1;
          if (p_ != q_) {
            (void) _dswap (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
            if (rsvec_) {
              (void) _dswap (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
            }
            temp1_ = sva_[p_ - 1];
            sva_[p_ - 1] = sva_[q_ - 1];
            sva_[q_ - 1] = temp1_;
            temp1_ = work_[p_ - 1];
            work_[p_ - 1] = work_[q_ - 1];
            work_[q_ - 1] = temp1_;
          }
          if (ir1_ == 0) {
            if ((sva_[p_ - 1] < rootbig_) && (sva_[p_ - 1] > rootsfmin_)) {
              sva_[p_ - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * work_[p_ - 1];
            }
            else {
              temp1_ = 0.0;
              aapp_ = 1.0;
              (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &temp1_, &aapp_);
              sva_[p_ - 1] = temp1_ * __dsqrt (&aapp_) * work_[p_ - 1];
            }
            aapp_ = sva_[p_ - 1];
          }
          else {
            aapp_ = sva_[p_ - 1];
          }
          if (aapp_ > 0.0) {
            pskipped_ = 0;
            for (q_ = p_ + 1; q_ <= _min (igl_ + kbl_ - 1, (*n_)); (q_)++) {
              aaqq_ = sva_[q_ - 1];
              if (aaqq_ > 0.0) {
                aapp0_ = aapp_;
                if (aaqq_ >= 1.0) {
                  rotok_ = (small_ * aapp_) <= aaqq_;
                  if (aapp_ < (big_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * work_[p_ - 1] * 
                    work_[q_ - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &work_[(*n_) + 1 - 1], &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, &work_[p_ - 1], m_, &_k1, &work_[(*n_) + 1 - 1], lda_, &ierr_);
                    aapq_ = _ddot (m_, &work_[(*n_) + 1 - 1], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * work_[q_ - 1] / aaqq_;
                  }
                }
                else {
                  rotok_ = aapp_ <= (aaqq_ / small_);
                  if (aapp_ > (small_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * work_[p_ - 1] * 
                    work_[q_ - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &work_[(*n_) + 1 - 1], &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, &work_[q_ - 1], m_, &_k1, &work_[(*n_) + 1 - 1], lda_, &ierr_);
                    aapq_ = _ddot (m_, &work_[(*n_) + 1 - 1], &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * work_[p_ - 1] / aapp_;
                  }
                }
                mxaapq_ = _max (mxaapq_, __dabs (&aapq_));
                if (__dabs (&aapq_) > tol_) {
                  if (ir1_ == 0) {
                    notrot_ = 0;
                    pskipped_ = 0;
                    iswrot_ = iswrot_ + 1;
                  }
                  if (rotok_) {
                    aqoap_ = aaqq_ / aapp_;
                    apoaq_ = aapp_ / aaqq_;
                    theta_ = -0.5 * __dabs (($42_ = aqoap_ - apoaq_, &$42_)) / aapq_;
                    if (__dabs (&theta_) > bigtheta_) {
                      t_ = 0.5 / theta_;
                      fastr_[2] = t_ * work_[p_ - 1] / work_[q_ - 1];
                      fastr_[3] = -t_ * work_[q_ - 1] / work_[p_ - 1];
                      (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                      if (rsvec_) {
                        (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                      }
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($43_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$43_));
                      aapp_ = aapp_ * __dsqrt (($44_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$44_));
                      mxsinj_ = _max (mxsinj_, __dabs (&t_));
                    }
                    else {
                      thsign_ = -__dsign (($45_ = 1.0, &$45_), &aapq_);
                      t_ = 1.0 / (theta_ + thsign_ * __dsqrt (($46_ = 1.0 + theta_ * theta_, &$46_)));
                      cs_ = __dsqrt (($47_ = 1.0 / (1.0 + t_ * t_), &$47_));
                      sn_ = t_ * cs_;
                      mxsinj_ = _max (mxsinj_, __dabs (&sn_));
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($48_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$48_));
                      aapp_ = aapp_ * __dsqrt (($49_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$49_));
                      apoaq_ = work_[p_ - 1] / work_[q_ - 1];
                      aqoap_ = work_[q_ - 1] / work_[p_ - 1];
                      if (work_[p_ - 1] >= 1.0) {
                        if (work_[q_ - 1] >= 1.0) {
                          fastr_[2] = t_ * apoaq_;
                          fastr_[3] = -t_ * aqoap_;
                          work_[p_ - 1] = work_[p_ - 1] * cs_;
                          work_[q_ - 1] = work_[q_ - 1] * cs_;
                          (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                          if (rsvec_) {
                            (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                          }
                        }
                        else {
                          (void) _daxpy (m_, ($50_ = -t_ * aqoap_, &$50_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                          1))], &_k1);
                          (void) _daxpy (m_, ($51_ = cs_ * sn_ * apoaq_, &$51_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                          - 1))], &_k1);
                          work_[p_ - 1] = work_[p_ - 1] * cs_;
                          work_[q_ - 1] = work_[q_ - 1] / cs_;
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($52_ = -t_ * aqoap_, &$52_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($53_ = cs_ * sn_ * apoaq_, &$53_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((q_ - 1))], &_k1);
                          }
                        }
                      }
                      else {
                        if (work_[q_ - 1] >= 1.0) {
                          (void) _daxpy (m_, ($54_ = t_ * apoaq_, &$54_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                          &_k1);
                          (void) _daxpy (m_, ($55_ = -cs_ * sn_ * aqoap_, &$55_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                          - 1))], &_k1);
                          work_[p_ - 1] = work_[p_ - 1] / cs_;
                          work_[q_ - 1] = work_[q_ - 1] * cs_;
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($56_ = t_ * apoaq_, &$56_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($57_ = -cs_ * sn_ * aqoap_, &$57_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((p_ - 1))], &_k1);
                          }
                        }
                        else {
                          if (work_[p_ - 1] >= work_[q_ - 1]) {
                            (void) _daxpy (m_, ($58_ = -t_ * aqoap_, &$58_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (m_, ($59_ = cs_ * sn_ * apoaq_, &$59_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                            - 1))], &_k1);
                            work_[p_ - 1] = work_[p_ - 1] * cs_;
                            work_[q_ - 1] = work_[q_ - 1] / cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($60_ = -t_ * aqoap_, &$60_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($61_ = cs_ * sn_ * apoaq_, &$61_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((q_ - 1))], &_k1);
                            }
                          }
                          else {
                            (void) _daxpy (m_, ($62_ = t_ * apoaq_, &$62_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                            &_k1);
                            (void) _daxpy (m_, ($63_ = -cs_ * sn_ * aqoap_, &$63_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                            - 1))], &_k1);
                            work_[p_ - 1] = work_[p_ - 1] / cs_;
                            work_[q_ - 1] = work_[q_ - 1] * cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($64_ = t_ * apoaq_, &$64_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($65_ = -cs_ * sn_ * aqoap_, &$65_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((p_ - 1))], &_k1);
                            }
                          }
                        }
                      }
                    }
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &work_[(*n_) + 1 - 1], &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, ($66_ = 1.0, &$66_), m_, &_k1, &work_[(*n_) + 1 - 1], lda_, &ierr_);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, ($67_ = 1.0, &$67_), m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                    &ierr_);
                    temp1_ = -aapq_ * work_[p_ - 1] / work_[q_ - 1];
                    (void) _daxpy (m_, &temp1_, &work_[(*n_) + 1 - 1], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, ($68_ = 1.0, &$68_), &aaqq_, m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                    &ierr_);
                    sva_[q_ - 1] = aaqq_ * __dsqrt (($69_ = _max (0.0, 1.0 - aapq_ * aapq_), &$69_));
                    mxsinj_ = _max (mxsinj_, sfmin_);
                  }
                  if (($70_ = (sva_[q_ - 1] / aaqq_), $70_ * $70_) <= rooteps_) {
                    if ((aaqq_ < rootbig_) && (aaqq_ > rootsfmin_)) {
                      sva_[q_ - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * work_[q_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aaqq_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &t_, &aaqq_);
                      sva_[q_ - 1] = t_ * __dsqrt (&aaqq_) * work_[q_ - 1];
                    }
                  }
                  if ((aapp_ / aapp0_) <= rooteps_) {
                    if ((aapp_ < rootbig_) && (aapp_ > rootsfmin_)) {
                      aapp_ = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * work_[p_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aapp_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &t_, &aapp_);
                      aapp_ = t_ * __dsqrt (&aapp_) * work_[p_ - 1];
                    }
                    sva_[p_ - 1] = aapp_;
                  }
                }
                else {
                  if (ir1_ == 0) {
                    notrot_ = notrot_ + 1;
                  }
                  pskipped_ = pskipped_ + 1;
                }
              }
              else {
                if (ir1_ == 0) {
                  notrot_ = notrot_ + 1;
                }
                pskipped_ = pskipped_ + 1;
              }
              if ((i_ <= swband_) && (pskipped_ > rowskip_)) {
                if (ir1_ == 0) {
                  aapp_ = -aapp_;
                }
                notrot_ = 0;
                goto _l2103;
              }
            }
            _l2103:;
            sva_[p_ - 1] = aapp_;
          }
          else {
            sva_[p_ - 1] = aapp_;
            if ((ir1_ == 0) && (aapp_ == 0.0)) {
              notrot_ = notrot_ + _min (igl_ + kbl_ - 1, (*n_)) - p_;
            }
          }
        }
      }
      igl_ = (ibr_ - 1) * kbl_ + 1;
      for (jbc_ = ibr_ + 1; jbc_ <= nbl_; (jbc_)++) {
        jgl_ = (jbc_ - 1) * kbl_ + 1;
        ijblsk_ = 0;
        for (p_ = igl_; p_ <= _min (igl_ + kbl_ - 1, (*n_)); (p_)++) {
          aapp_ = sva_[p_ - 1];
          if (aapp_ > 0.0) {
            pskipped_ = 0;
            for (q_ = jgl_; q_ <= _min (jgl_ + kbl_ - 1, (*n_)); (q_)++) {
              aaqq_ = sva_[q_ - 1];
              if (aaqq_ > 0.0) {
                aapp0_ = aapp_;
                if (aaqq_ >= 1.0) {
                  if (aapp_ >= aaqq_) {
                    rotok_ = (small_ * aapp_) <= aaqq_;
                  }
                  else {
                    rotok_ = (small_ * aaqq_) <= aapp_;
                  }
                  if (aapp_ < (big_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * work_[p_ - 1] * 
                    work_[q_ - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &work_[(*n_) + 1 - 1], &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, &work_[p_ - 1], m_, &_k1, &work_[(*n_) + 1 - 1], lda_, &ierr_);
                    aapq_ = _ddot (m_, &work_[(*n_) + 1 - 1], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * work_[q_ - 1] / aaqq_;
                  }
                }
                else {
                  if (aapp_ >= aaqq_) {
                    rotok_ = aapp_ <= (aaqq_ / small_);
                  }
                  else {
                    rotok_ = aaqq_ <= (aapp_ / small_);
                  }
                  if (aapp_ > (small_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * work_[p_ - 1] * 
                    work_[q_ - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &work_[(*n_) + 1 - 1], &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, &work_[q_ - 1], m_, &_k1, &work_[(*n_) + 1 - 1], lda_, &ierr_);
                    aapq_ = _ddot (m_, &work_[(*n_) + 1 - 1], &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * work_[p_ - 1] / aapp_;
                  }
                }
                mxaapq_ = _max (mxaapq_, __dabs (&aapq_));
                if (__dabs (&aapq_) > tol_) {
                  notrot_ = 0;
                  pskipped_ = 0;
                  iswrot_ = iswrot_ + 1;
                  if (rotok_) {
                    aqoap_ = aaqq_ / aapp_;
                    apoaq_ = aapp_ / aaqq_;
                    theta_ = -0.5 * __dabs (($71_ = aqoap_ - apoaq_, &$71_)) / aapq_;
                    if (aaqq_ > aapp0_) {
                      theta_ = -theta_;
                    }
                    if (__dabs (&theta_) > bigtheta_) {
                      t_ = 0.5 / theta_;
                      fastr_[2] = t_ * work_[p_ - 1] / work_[q_ - 1];
                      fastr_[3] = -t_ * work_[q_ - 1] / work_[p_ - 1];
                      (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                      if (rsvec_) {
                        (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                      }
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($72_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$72_));
                      aapp_ = aapp_ * __dsqrt (($73_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$73_));
                      mxsinj_ = _max (mxsinj_, __dabs (&t_));
                    }
                    else {
                      thsign_ = -__dsign (($74_ = 1.0, &$74_), &aapq_);
                      if (aaqq_ > aapp0_) {
                        thsign_ = -thsign_;
                      }
                      t_ = 1.0 / (theta_ + thsign_ * __dsqrt (($75_ = 1.0 + theta_ * theta_, &$75_)));
                      cs_ = __dsqrt (($76_ = 1.0 / (1.0 + t_ * t_), &$76_));
                      sn_ = t_ * cs_;
                      mxsinj_ = _max (mxsinj_, __dabs (&sn_));
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($77_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$77_));
                      aapp_ = aapp_ * __dsqrt (($78_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$78_));
                      apoaq_ = work_[p_ - 1] / work_[q_ - 1];
                      aqoap_ = work_[q_ - 1] / work_[p_ - 1];
                      if (work_[p_ - 1] >= 1.0) {
                        if (work_[q_ - 1] >= 1.0) {
                          fastr_[2] = t_ * apoaq_;
                          fastr_[3] = -t_ * aqoap_;
                          work_[p_ - 1] = work_[p_ - 1] * cs_;
                          work_[q_ - 1] = work_[q_ - 1] * cs_;
                          (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                          if (rsvec_) {
                            (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                          }
                        }
                        else {
                          (void) _daxpy (m_, ($79_ = -t_ * aqoap_, &$79_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                          1))], &_k1);
                          (void) _daxpy (m_, ($80_ = cs_ * sn_ * apoaq_, &$80_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                          - 1))], &_k1);
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($81_ = -t_ * aqoap_, &$81_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($82_ = cs_ * sn_ * apoaq_, &$82_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((q_ - 1))], &_k1);
                          }
                          work_[p_ - 1] = work_[p_ - 1] * cs_;
                          work_[q_ - 1] = work_[q_ - 1] / cs_;
                        }
                      }
                      else {
                        if (work_[q_ - 1] >= 1.0) {
                          (void) _daxpy (m_, ($83_ = t_ * apoaq_, &$83_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                          &_k1);
                          (void) _daxpy (m_, ($84_ = -cs_ * sn_ * aqoap_, &$84_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                          - 1))], &_k1);
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($85_ = t_ * apoaq_, &$85_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($86_ = -cs_ * sn_ * aqoap_, &$86_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((p_ - 1))], &_k1);
                          }
                          work_[p_ - 1] = work_[p_ - 1] / cs_;
                          work_[q_ - 1] = work_[q_ - 1] * cs_;
                        }
                        else {
                          if (work_[p_ - 1] >= work_[q_ - 1]) {
                            (void) _daxpy (m_, ($87_ = -t_ * aqoap_, &$87_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (m_, ($88_ = cs_ * sn_ * apoaq_, &$88_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                            - 1))], &_k1);
                            work_[p_ - 1] = work_[p_ - 1] * cs_;
                            work_[q_ - 1] = work_[q_ - 1] / cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($89_ = -t_ * aqoap_, &$89_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($90_ = cs_ * sn_ * apoaq_, &$90_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((q_ - 1))], &_k1);
                            }
                          }
                          else {
                            (void) _daxpy (m_, ($91_ = t_ * apoaq_, &$91_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                            &_k1);
                            (void) _daxpy (m_, ($92_ = -cs_ * sn_ * aqoap_, &$92_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                            - 1))], &_k1);
                            work_[p_ - 1] = work_[p_ - 1] / cs_;
                            work_[q_ - 1] = work_[q_ - 1] * cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($93_ = t_ * apoaq_, &$93_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($94_ = -cs_ * sn_ * aqoap_, &$94_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((p_ - 1))], &_k1);
                            }
                          }
                        }
                      }
                    }
                  }
                  else {
                    if (aapp_ > aaqq_) {
                      (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &work_[(*n_) + 1 - 1], &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, ($95_ = 1.0, &$95_), m_, &_k1, &work_[(*n_) + 1 - 1], lda_, &ierr_);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, ($96_ = 1.0, &$96_), m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                      &ierr_);
                      temp1_ = -aapq_ * work_[p_ - 1] / work_[q_ - 1];
                      (void) _daxpy (m_, &temp1_, &work_[(*n_) + 1 - 1], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, ($97_ = 1.0, &$97_), &aaqq_, m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                      &ierr_);
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($98_ = _max (0.0, 1.0 - aapq_ * aapq_), &$98_));
                      mxsinj_ = _max (mxsinj_, sfmin_);
                    }
                    else {
                      (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &work_[(*n_) + 1 - 1], &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, ($99_ = 1.0, &$99_), m_, &_k1, &work_[(*n_) + 1 - 1], lda_, &ierr_);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, ($100_ = 1.0, &$100_), m_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], lda_, 
                      &ierr_);
                      temp1_ = -aapq_ * work_[q_ - 1] / work_[p_ - 1];
                      (void) _daxpy (m_, &temp1_, &work_[(*n_) + 1 - 1], &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, ($101_ = 1.0, &$101_), &aapp_, m_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], lda_, 
                      &ierr_);
                      sva_[p_ - 1] = aapp_ * __dsqrt (($102_ = _max (0.0, 1.0 - aapq_ * aapq_), &$102_));
                      mxsinj_ = _max (mxsinj_, sfmin_);
                    }
                  }
                  if (($103_ = (sva_[q_ - 1] / aaqq_), $103_ * $103_) <= rooteps_) {
                    if ((aaqq_ < rootbig_) && (aaqq_ > rootsfmin_)) {
                      sva_[q_ - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * work_[q_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aaqq_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &t_, &aaqq_);
                      sva_[q_ - 1] = t_ * __dsqrt (&aaqq_) * work_[q_ - 1];
                    }
                  }
                  if (($104_ = (aapp_ / aapp0_), $104_ * $104_) <= rooteps_) {
                    if ((aapp_ < rootbig_) && (aapp_ > rootsfmin_)) {
                      aapp_ = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * work_[p_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aapp_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &t_, &aapp_);
                      aapp_ = t_ * __dsqrt (&aapp_) * work_[p_ - 1];
                    }
                    sva_[p_ - 1] = aapp_;
                  }
                }
                else {
                  notrot_ = notrot_ + 1;
                  pskipped_ = pskipped_ + 1;
                  ijblsk_ = ijblsk_ + 1;
                }
              }
              else {
                notrot_ = notrot_ + 1;
                pskipped_ = pskipped_ + 1;
                ijblsk_ = ijblsk_ + 1;
              }
              if ((i_ <= swband_) && (ijblsk_ >= blskip_)) {
                sva_[p_ - 1] = aapp_;
                notrot_ = 0;
                goto _l2011;
              }
              if ((i_ <= swband_) && (pskipped_ > rowskip_)) {
                aapp_ = -aapp_;
                notrot_ = 0;
                goto _l2203;
              }
            }
            _l2203:;
            sva_[p_ - 1] = aapp_;
          }
          else {
            if (aapp_ == 0.0) {
              notrot_ = notrot_ + _min (jgl_ + kbl_ - 1, (*n_)) - jgl_ + 1;
            }
            if (aapp_ < 0.0) {
              notrot_ = 0;
            }
          }
        }
      }
      _l2011:;
      for (p_ = igl_; p_ <= _min (igl_ + kbl_ - 1, (*n_)); (p_)++) {
        sva_[p_ - 1] = __dabs (&sva_[p_ - 1]);
      }
    }
    if ((sva_[(*n_) - 1] < rootbig_) && (sva_[(*n_) - 1] > rootsfmin_)) {
      sva_[(*n_) - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * (((*n_) - 1))], &_k1) * work_[(*n_) - 1];
    }
    else {
      t_ = 0.0;
      aapp_ = 1.0;
      (void) _dlassq (m_, &a_[0 + ((*lda_)) * (((*n_) - 1))], &_k1, &t_, &aapp_);
      sva_[(*n_) - 1] = t_ * __dsqrt (&aapp_) * work_[(*n_) - 1];
    }
    if ((i_ < swband_) && ((mxaapq_ <= roottol_) || (iswrot_ <= (*n_)))) {
      swband_ = i_;
    }
    if ((i_ > swband_ + 1) && (mxaapq_ < __dsqrt (($105_ = (real_8) ((*n_)), &$105_)) * tol_) && ((real_8) ((*n_)) * 
      mxaapq_ * mxsinj_ < tol_)) {
      goto _l1994;
    }
    if (notrot_ >= emptsw_) {
      goto _l1994;
    }
  }
  (*info_) = 29;
  goto _l1995;
  _l1994:;
  (*info_) = 0;
  _l1995:;
  n2_ = 0;
  n4_ = 0;
  for (p_ = 1; p_ <= (*n_) - 1; (p_)++) {
    q_ = _idamax (($106_ = (*n_) - p_ + 1, &$106_), &sva_[p_ - 1], &_k1) + p_ - 1;
    if (p_ != q_) {
      temp1_ = sva_[p_ - 1];
      sva_[p_ - 1] = sva_[q_ - 1];
      sva_[q_ - 1] = temp1_;
      temp1_ = work_[p_ - 1];
      work_[p_ - 1] = work_[q_ - 1];
      work_[q_ - 1] = temp1_;
      (void) _dswap (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
      if (rsvec_) {
        (void) _dswap (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
      }
    }
    if (sva_[p_ - 1] != 0.0) {
      n4_ = n4_ + 1;
      if (sva_[p_ - 1] * skl_ > sfmin_) {
        n2_ = n2_ + 1;
      }
    }
  }
  if (sva_[(*n_) - 1] != 0.0) {
    n4_ = n4_ + 1;
    if (sva_[(*n_) - 1] * skl_ > sfmin_) {
      n2_ = n2_ + 1;
    }
  }
  if (lsvec_ || uctol_) {
    for (p_ = 1; p_ <= n2_; (p_)++) {
      (void) _dscal (m_, ($107_ = work_[p_ - 1] / sva_[p_ - 1], &$107_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1);
    }
  }
  if (rsvec_) {
    if (applv_) {
      for (p_ = 1; p_ <= (*n_); (p_)++) {
        (void) _dscal (&mvl_, &work_[p_ - 1], &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
      }
    }
    else {
      for (p_ = 1; p_ <= (*n_); (p_)++) {
        temp1_ = 1.0 / _dnrm2 (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
        (void) _dscal (&mvl_, &temp1_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1);
      }
    }
  }
  if (((skl_ > 1.0) && (sva_[0] < (big_ / skl_))) || ((skl_ < 1.0) && (sva_[_max (n2_, 1) - 1] > (sfmin_ / skl_)))) {
    for (p_ = 1; p_ <= (*n_); (p_)++) {
      sva_[p_ - 1] = skl_ * sva_[p_ - 1];
    }
    skl_ = 1.0;
  }
  work_[0] = skl_;
  work_[1] = (real_8) (n4_);
  work_[2] = (real_8) (n2_);
  work_[3] = (real_8) (i_);
  work_[4] = mxaapq_;
  work_[5] = mxsinj_;
  _l0:;
  __calls[16].calls++;
  return 0;
}
int_4 _dgsvj0 (char _p_ jobv_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, real_8 _p_ 
sva_, int_4 _p_ mv_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ eps_, real_8 _p_ sfmin_, real_8 _p_ tol_, int_4 _p_ 
nsweep_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 blskip_, emptsw_, i_, ibr_, ierr_, igl_, ijblsk_, ir1_, iswrot_, jbc_, jgl_, kbl_, lkahead_, mvl_, nbl_, 
  notrot_, p_, pskipped_, q_, rowskip_, swband_;
  static logical_4 applv_, rotok_, rsvec_;
  static real_8 aapp_, aapp0_, aapq_, aaqq_, apoaq_, aqoap_, big_, bigtheta_, cs_, mxaapq_, mxsinj_, rootbig_, rooteps_, 
  rootsfmin_, roottol_, small_, sn_, t_, temp1_, theta_, thsign_, fastr_[5];
  int_4 $0_, $1_, $65_;
  real_8 $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, $20_, $21_, 
  $22_, $23_, $24_, $25_, $26_, $27_, $28_, $29_, $30_, $31_, $32_, $33_, $34_, $35_, $36_, $37_, $38_, $39_, $40_, $41_, 
  $42_, $43_, $44_, $45_, $46_, $47_, $48_, $49_, $50_, $51_, $52_, $53_, $54_, $55_, $56_, $57_, $58_, $59_, $60_, $61_, 
  $62_, $63_, $64_;
  extern real_8 _dabs ();
  extern real_8 _dsign ();
  extern real_8 _dsqrt ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern int_4 _idamax ();
  extern logical_4 _lsame ();
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern int_4 _drotm ();
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  real_8 __dabs (real_8 _p_ __x__) {return _abs (*__x__);}
  real_8 __dsign (real_8 _p_ __x__, real_8 _p_ __y__) {return _sign (*__x__, *__y__);}
  real_8 __dsqrt (real_8 _p_ __x__) {return sqrt (*__x__);}
  applv_ = _lsame (jobv_, _dc_7);
  rsvec_ = _lsame (jobv_, _dc_11);
  if (! ((rsvec_ || applv_ || _lsame (jobv_, _dc_2)))) {
    (*info_) = -1;
  }
  else if ((*m_) < 0) {
    (*info_) = -2;
  }
  else if (((*n_) < 0) || ((*n_) > (*m_))) {
    (*info_) = -3;
  }
  else if ((*lda_) < (*m_)) {
    (*info_) = -5;
  }
  else if ((rsvec_ || applv_) && ((*mv_) < 0)) {
    (*info_) = -8;
  }
  else if ((rsvec_ && ((*ldv_) < (*n_))) || (applv_ && ((*ldv_) < (*mv_)))) {
    (*info_) = -10;
  }
  else if ((*tol_) <= (*eps_)) {
    (*info_) = -13;
  }
  else if ((*nsweep_) < 0) {
    (*info_) = -14;
  }
  else if ((*lwork_) < (*m_)) {
    (*info_) = -16;
  }
  else {
    (*info_) = 0;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_64, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if (rsvec_) {
    mvl_ = (*n_);
  }
  else if (applv_) {
    mvl_ = (*mv_);
  }
  rsvec_ = rsvec_ || applv_;
  rooteps_ = __dsqrt (eps_);
  rootsfmin_ = __dsqrt (sfmin_);
  small_ = (*sfmin_) / (*eps_);
  big_ = 1.0 / (*sfmin_);
  rootbig_ = 1.0 / rootsfmin_;
  bigtheta_ = 1.0 / rooteps_;
  roottol_ = __dsqrt (tol_);
  emptsw_ = ((*n_) * ((*n_) - 1)) / 2;
  notrot_ = 0;
  fastr_[0] = 0.0;
  swband_ = 0;
  kbl_ = _min (8, (*n_));
  nbl_ = (*n_) / kbl_;
  if ((nbl_ * kbl_) != (*n_)) {
    nbl_ = nbl_ + 1;
  }
  blskip_ = ((kbl_ * kbl_)) + 1;
  rowskip_ = _min (5, kbl_);
  lkahead_ = 1;
  swband_ = 0;
  pskipped_ = 0;
  for (i_ = 1; i_ <= (*nsweep_); (i_)++) {
    mxaapq_ = 0.0;
    mxsinj_ = 0.0;
    iswrot_ = 0;
    notrot_ = 0;
    pskipped_ = 0;
    for (ibr_ = 1; ibr_ <= nbl_; (ibr_)++) {
      igl_ = (ibr_ - 1) * kbl_ + 1;
      for (ir1_ = 0; ir1_ <= _min (lkahead_, nbl_ - ibr_); (ir1_)++) {
        igl_ = igl_ + ir1_ * kbl_;
        for (p_ = igl_; p_ <= _min (igl_ + kbl_ - 1, (*n_) - 1); (p_)++) {
          q_ = _idamax (($1_ = (*n_) - p_ + 1, &$1_), &sva_[p_ - 1], &_k1) + p_ - 1;
          if (p_ != q_) {
            (void) _dswap (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
            if (rsvec_) {
              (void) _dswap (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
            }
            temp1_ = sva_[p_ - 1];
            sva_[p_ - 1] = sva_[q_ - 1];
            sva_[q_ - 1] = temp1_;
            temp1_ = d_[p_ - 1];
            d_[p_ - 1] = d_[q_ - 1];
            d_[q_ - 1] = temp1_;
          }
          if (ir1_ == 0) {
            if ((sva_[p_ - 1] < rootbig_) && (sva_[p_ - 1] > rootsfmin_)) {
              sva_[p_ - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * d_[p_ - 1];
            }
            else {
              temp1_ = 0.0;
              aapp_ = 1.0;
              (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &temp1_, &aapp_);
              sva_[p_ - 1] = temp1_ * __dsqrt (&aapp_) * d_[p_ - 1];
            }
            aapp_ = sva_[p_ - 1];
          }
          else {
            aapp_ = sva_[p_ - 1];
          }
          if (aapp_ > 0.0) {
            pskipped_ = 0;
            for (q_ = p_ + 1; q_ <= _min (igl_ + kbl_ - 1, (*n_)); (q_)++) {
              aaqq_ = sva_[q_ - 1];
              if (aaqq_ > 0.0) {
                aapp0_ = aapp_;
                if (aaqq_ >= 1.0) {
                  rotok_ = (small_ * aapp_) <= aaqq_;
                  if (aapp_ < (big_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[p_ - 1] * d_[q_ 
                    - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, work_, &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, &d_[p_ - 1], m_, &_k1, work_, lda_, &ierr_);
                    aapq_ = _ddot (m_, work_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[q_ - 1] / aaqq_;
                  }
                }
                else {
                  rotok_ = aapp_ <= (aaqq_ / small_);
                  if (aapp_ > (small_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[p_ - 1] * d_[q_ 
                    - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, work_, &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, &d_[q_ - 1], m_, &_k1, work_, lda_, &ierr_);
                    aapq_ = _ddot (m_, work_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * d_[p_ - 1] / aapp_;
                  }
                }
                mxaapq_ = _max (mxaapq_, __dabs (&aapq_));
                if (__dabs (&aapq_) > (*tol_)) {
                  if (ir1_ == 0) {
                    notrot_ = 0;
                    pskipped_ = 0;
                    iswrot_ = iswrot_ + 1;
                  }
                  if (rotok_) {
                    aqoap_ = aaqq_ / aapp_;
                    apoaq_ = aapp_ / aaqq_;
                    theta_ = -0.5 * __dabs (($2_ = aqoap_ - apoaq_, &$2_)) / aapq_;
                    if (__dabs (&theta_) > bigtheta_) {
                      t_ = 0.5 / theta_;
                      fastr_[2] = t_ * d_[p_ - 1] / d_[q_ - 1];
                      fastr_[3] = -t_ * d_[q_ - 1] / d_[p_ - 1];
                      (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                      if (rsvec_) {
                        (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                      }
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($3_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$3_));
                      aapp_ = aapp_ * __dsqrt (($4_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$4_));
                      mxsinj_ = _max (mxsinj_, __dabs (&t_));
                    }
                    else {
                      thsign_ = -__dsign (($5_ = 1.0, &$5_), &aapq_);
                      t_ = 1.0 / (theta_ + thsign_ * __dsqrt (($6_ = 1.0 + theta_ * theta_, &$6_)));
                      cs_ = __dsqrt (($7_ = 1.0 / (1.0 + t_ * t_), &$7_));
                      sn_ = t_ * cs_;
                      mxsinj_ = _max (mxsinj_, __dabs (&sn_));
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($8_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$8_));
                      aapp_ = aapp_ * __dsqrt (($9_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$9_));
                      apoaq_ = d_[p_ - 1] / d_[q_ - 1];
                      aqoap_ = d_[q_ - 1] / d_[p_ - 1];
                      if (d_[p_ - 1] >= 1.0) {
                        if (d_[q_ - 1] >= 1.0) {
                          fastr_[2] = t_ * apoaq_;
                          fastr_[3] = -t_ * aqoap_;
                          d_[p_ - 1] = d_[p_ - 1] * cs_;
                          d_[q_ - 1] = d_[q_ - 1] * cs_;
                          (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                          if (rsvec_) {
                            (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                          }
                        }
                        else {
                          (void) _daxpy (m_, ($10_ = -t_ * aqoap_, &$10_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                          1))], &_k1);
                          (void) _daxpy (m_, ($11_ = cs_ * sn_ * apoaq_, &$11_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                          - 1))], &_k1);
                          d_[p_ - 1] = d_[p_ - 1] * cs_;
                          d_[q_ - 1] = d_[q_ - 1] / cs_;
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($12_ = -t_ * aqoap_, &$12_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($13_ = cs_ * sn_ * apoaq_, &$13_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((q_ - 1))], &_k1);
                          }
                        }
                      }
                      else {
                        if (d_[q_ - 1] >= 1.0) {
                          (void) _daxpy (m_, ($14_ = t_ * apoaq_, &$14_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                          &_k1);
                          (void) _daxpy (m_, ($15_ = -cs_ * sn_ * aqoap_, &$15_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                          - 1))], &_k1);
                          d_[p_ - 1] = d_[p_ - 1] / cs_;
                          d_[q_ - 1] = d_[q_ - 1] * cs_;
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($16_ = t_ * apoaq_, &$16_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($17_ = -cs_ * sn_ * aqoap_, &$17_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((p_ - 1))], &_k1);
                          }
                        }
                        else {
                          if (d_[p_ - 1] >= d_[q_ - 1]) {
                            (void) _daxpy (m_, ($18_ = -t_ * aqoap_, &$18_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (m_, ($19_ = cs_ * sn_ * apoaq_, &$19_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                            - 1))], &_k1);
                            d_[p_ - 1] = d_[p_ - 1] * cs_;
                            d_[q_ - 1] = d_[q_ - 1] / cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($20_ = -t_ * aqoap_, &$20_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($21_ = cs_ * sn_ * apoaq_, &$21_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((q_ - 1))], &_k1);
                            }
                          }
                          else {
                            (void) _daxpy (m_, ($22_ = t_ * apoaq_, &$22_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                            &_k1);
                            (void) _daxpy (m_, ($23_ = -cs_ * sn_ * aqoap_, &$23_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                            - 1))], &_k1);
                            d_[p_ - 1] = d_[p_ - 1] / cs_;
                            d_[q_ - 1] = d_[q_ - 1] * cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($24_ = t_ * apoaq_, &$24_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($25_ = -cs_ * sn_ * aqoap_, &$25_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((p_ - 1))], &_k1);
                            }
                          }
                        }
                      }
                    }
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, work_, &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, ($26_ = 1.0, &$26_), m_, &_k1, work_, lda_, &ierr_);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, ($27_ = 1.0, &$27_), m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                    &ierr_);
                    temp1_ = -aapq_ * d_[p_ - 1] / d_[q_ - 1];
                    (void) _daxpy (m_, &temp1_, work_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, ($28_ = 1.0, &$28_), &aaqq_, m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                    &ierr_);
                    sva_[q_ - 1] = aaqq_ * __dsqrt (($29_ = _max (0.0, 1.0 - aapq_ * aapq_), &$29_));
                    mxsinj_ = _max (mxsinj_, (*sfmin_));
                  }
                  if (($30_ = (sva_[q_ - 1] / aaqq_), $30_ * $30_) <= rooteps_) {
                    if ((aaqq_ < rootbig_) && (aaqq_ > rootsfmin_)) {
                      sva_[q_ - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[q_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aaqq_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &t_, &aaqq_);
                      sva_[q_ - 1] = t_ * __dsqrt (&aaqq_) * d_[q_ - 1];
                    }
                  }
                  if ((aapp_ / aapp0_) <= rooteps_) {
                    if ((aapp_ < rootbig_) && (aapp_ > rootsfmin_)) {
                      aapp_ = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * d_[p_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aapp_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &t_, &aapp_);
                      aapp_ = t_ * __dsqrt (&aapp_) * d_[p_ - 1];
                    }
                    sva_[p_ - 1] = aapp_;
                  }
                }
                else {
                  if (ir1_ == 0) {
                    notrot_ = notrot_ + 1;
                  }
                  pskipped_ = pskipped_ + 1;
                }
              }
              else {
                if (ir1_ == 0) {
                  notrot_ = notrot_ + 1;
                }
                pskipped_ = pskipped_ + 1;
              }
              if ((i_ <= swband_) && (pskipped_ > rowskip_)) {
                if (ir1_ == 0) {
                  aapp_ = -aapp_;
                }
                notrot_ = 0;
                goto _l2103;
              }
            }
            _l2103:;
            sva_[p_ - 1] = aapp_;
          }
          else {
            sva_[p_ - 1] = aapp_;
            if ((ir1_ == 0) && (aapp_ == 0.0)) {
              notrot_ = notrot_ + _min (igl_ + kbl_ - 1, (*n_)) - p_;
            }
          }
        }
      }
      igl_ = (ibr_ - 1) * kbl_ + 1;
      for (jbc_ = ibr_ + 1; jbc_ <= nbl_; (jbc_)++) {
        jgl_ = (jbc_ - 1) * kbl_ + 1;
        ijblsk_ = 0;
        for (p_ = igl_; p_ <= _min (igl_ + kbl_ - 1, (*n_)); (p_)++) {
          aapp_ = sva_[p_ - 1];
          if (aapp_ > 0.0) {
            pskipped_ = 0;
            for (q_ = jgl_; q_ <= _min (jgl_ + kbl_ - 1, (*n_)); (q_)++) {
              aaqq_ = sva_[q_ - 1];
              if (aaqq_ > 0.0) {
                aapp0_ = aapp_;
                if (aaqq_ >= 1.0) {
                  if (aapp_ >= aaqq_) {
                    rotok_ = (small_ * aapp_) <= aaqq_;
                  }
                  else {
                    rotok_ = (small_ * aaqq_) <= aapp_;
                  }
                  if (aapp_ < (big_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[p_ - 1] * d_[q_ 
                    - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, work_, &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, &d_[p_ - 1], m_, &_k1, work_, lda_, &ierr_);
                    aapq_ = _ddot (m_, work_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[q_ - 1] / aaqq_;
                  }
                }
                else {
                  if (aapp_ >= aaqq_) {
                    rotok_ = aapp_ <= (aaqq_ / small_);
                  }
                  else {
                    rotok_ = aaqq_ <= (aapp_ / small_);
                  }
                  if (aapp_ > (small_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[p_ - 1] * d_[q_ 
                    - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, work_, &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, &d_[q_ - 1], m_, &_k1, work_, lda_, &ierr_);
                    aapq_ = _ddot (m_, work_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * d_[p_ - 1] / aapp_;
                  }
                }
                mxaapq_ = _max (mxaapq_, __dabs (&aapq_));
                if (__dabs (&aapq_) > (*tol_)) {
                  notrot_ = 0;
                  pskipped_ = 0;
                  iswrot_ = iswrot_ + 1;
                  if (rotok_) {
                    aqoap_ = aaqq_ / aapp_;
                    apoaq_ = aapp_ / aaqq_;
                    theta_ = -0.5 * __dabs (($31_ = aqoap_ - apoaq_, &$31_)) / aapq_;
                    if (aaqq_ > aapp0_) {
                      theta_ = -theta_;
                    }
                    if (__dabs (&theta_) > bigtheta_) {
                      t_ = 0.5 / theta_;
                      fastr_[2] = t_ * d_[p_ - 1] / d_[q_ - 1];
                      fastr_[3] = -t_ * d_[q_ - 1] / d_[p_ - 1];
                      (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                      if (rsvec_) {
                        (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                      }
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($32_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$32_));
                      aapp_ = aapp_ * __dsqrt (($33_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$33_));
                      mxsinj_ = _max (mxsinj_, __dabs (&t_));
                    }
                    else {
                      thsign_ = -__dsign (($34_ = 1.0, &$34_), &aapq_);
                      if (aaqq_ > aapp0_) {
                        thsign_ = -thsign_;
                      }
                      t_ = 1.0 / (theta_ + thsign_ * __dsqrt (($35_ = 1.0 + theta_ * theta_, &$35_)));
                      cs_ = __dsqrt (($36_ = 1.0 / (1.0 + t_ * t_), &$36_));
                      sn_ = t_ * cs_;
                      mxsinj_ = _max (mxsinj_, __dabs (&sn_));
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($37_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$37_));
                      aapp_ = aapp_ * __dsqrt (($38_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$38_));
                      apoaq_ = d_[p_ - 1] / d_[q_ - 1];
                      aqoap_ = d_[q_ - 1] / d_[p_ - 1];
                      if (d_[p_ - 1] >= 1.0) {
                        if (d_[q_ - 1] >= 1.0) {
                          fastr_[2] = t_ * apoaq_;
                          fastr_[3] = -t_ * aqoap_;
                          d_[p_ - 1] = d_[p_ - 1] * cs_;
                          d_[q_ - 1] = d_[q_ - 1] * cs_;
                          (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                          if (rsvec_) {
                            (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                          }
                        }
                        else {
                          (void) _daxpy (m_, ($39_ = -t_ * aqoap_, &$39_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                          1))], &_k1);
                          (void) _daxpy (m_, ($40_ = cs_ * sn_ * apoaq_, &$40_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                          - 1))], &_k1);
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($41_ = -t_ * aqoap_, &$41_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($42_ = cs_ * sn_ * apoaq_, &$42_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((q_ - 1))], &_k1);
                          }
                          d_[p_ - 1] = d_[p_ - 1] * cs_;
                          d_[q_ - 1] = d_[q_ - 1] / cs_;
                        }
                      }
                      else {
                        if (d_[q_ - 1] >= 1.0) {
                          (void) _daxpy (m_, ($43_ = t_ * apoaq_, &$43_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                          &_k1);
                          (void) _daxpy (m_, ($44_ = -cs_ * sn_ * aqoap_, &$44_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                          - 1))], &_k1);
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($45_ = t_ * apoaq_, &$45_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($46_ = -cs_ * sn_ * aqoap_, &$46_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((p_ - 1))], &_k1);
                          }
                          d_[p_ - 1] = d_[p_ - 1] / cs_;
                          d_[q_ - 1] = d_[q_ - 1] * cs_;
                        }
                        else {
                          if (d_[p_ - 1] >= d_[q_ - 1]) {
                            (void) _daxpy (m_, ($47_ = -t_ * aqoap_, &$47_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (m_, ($48_ = cs_ * sn_ * apoaq_, &$48_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                            - 1))], &_k1);
                            d_[p_ - 1] = d_[p_ - 1] * cs_;
                            d_[q_ - 1] = d_[q_ - 1] / cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($49_ = -t_ * aqoap_, &$49_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($50_ = cs_ * sn_ * apoaq_, &$50_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((q_ - 1))], &_k1);
                            }
                          }
                          else {
                            (void) _daxpy (m_, ($51_ = t_ * apoaq_, &$51_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                            &_k1);
                            (void) _daxpy (m_, ($52_ = -cs_ * sn_ * aqoap_, &$52_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                            - 1))], &_k1);
                            d_[p_ - 1] = d_[p_ - 1] / cs_;
                            d_[q_ - 1] = d_[q_ - 1] * cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($53_ = t_ * apoaq_, &$53_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($54_ = -cs_ * sn_ * aqoap_, &$54_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((p_ - 1))], &_k1);
                            }
                          }
                        }
                      }
                    }
                  }
                  else {
                    if (aapp_ > aaqq_) {
                      (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, work_, &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, ($55_ = 1.0, &$55_), m_, &_k1, work_, lda_, &ierr_);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, ($56_ = 1.0, &$56_), m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                      &ierr_);
                      temp1_ = -aapq_ * d_[p_ - 1] / d_[q_ - 1];
                      (void) _daxpy (m_, &temp1_, work_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, ($57_ = 1.0, &$57_), &aaqq_, m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                      &ierr_);
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($58_ = _max (0.0, 1.0 - aapq_ * aapq_), &$58_));
                      mxsinj_ = _max (mxsinj_, (*sfmin_));
                    }
                    else {
                      (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, work_, &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, ($59_ = 1.0, &$59_), m_, &_k1, work_, lda_, &ierr_);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, ($60_ = 1.0, &$60_), m_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], lda_, 
                      &ierr_);
                      temp1_ = -aapq_ * d_[q_ - 1] / d_[p_ - 1];
                      (void) _daxpy (m_, &temp1_, work_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, ($61_ = 1.0, &$61_), &aapp_, m_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], lda_, 
                      &ierr_);
                      sva_[p_ - 1] = aapp_ * __dsqrt (($62_ = _max (0.0, 1.0 - aapq_ * aapq_), &$62_));
                      mxsinj_ = _max (mxsinj_, (*sfmin_));
                    }
                  }
                  if (($63_ = (sva_[q_ - 1] / aaqq_), $63_ * $63_) <= rooteps_) {
                    if ((aaqq_ < rootbig_) && (aaqq_ > rootsfmin_)) {
                      sva_[q_ - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[q_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aaqq_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &t_, &aaqq_);
                      sva_[q_ - 1] = t_ * __dsqrt (&aaqq_) * d_[q_ - 1];
                    }
                  }
                  if (($64_ = (aapp_ / aapp0_), $64_ * $64_) <= rooteps_) {
                    if ((aapp_ < rootbig_) && (aapp_ > rootsfmin_)) {
                      aapp_ = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * d_[p_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aapp_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &t_, &aapp_);
                      aapp_ = t_ * __dsqrt (&aapp_) * d_[p_ - 1];
                    }
                    sva_[p_ - 1] = aapp_;
                  }
                }
                else {
                  notrot_ = notrot_ + 1;
                  pskipped_ = pskipped_ + 1;
                  ijblsk_ = ijblsk_ + 1;
                }
              }
              else {
                notrot_ = notrot_ + 1;
                pskipped_ = pskipped_ + 1;
                ijblsk_ = ijblsk_ + 1;
              }
              if ((i_ <= swband_) && (ijblsk_ >= blskip_)) {
                sva_[p_ - 1] = aapp_;
                notrot_ = 0;
                goto _l2011;
              }
              if ((i_ <= swband_) && (pskipped_ > rowskip_)) {
                aapp_ = -aapp_;
                notrot_ = 0;
                goto _l2203;
              }
            }
            _l2203:;
            sva_[p_ - 1] = aapp_;
          }
          else {
            if (aapp_ == 0.0) {
              notrot_ = notrot_ + _min (jgl_ + kbl_ - 1, (*n_)) - jgl_ + 1;
            }
            if (aapp_ < 0.0) {
              notrot_ = 0;
            }
          }
        }
      }
      _l2011:;
      for (p_ = igl_; p_ <= _min (igl_ + kbl_ - 1, (*n_)); (p_)++) {
        sva_[p_ - 1] = __dabs (&sva_[p_ - 1]);
      }
    }
    if ((sva_[(*n_) - 1] < rootbig_) && (sva_[(*n_) - 1] > rootsfmin_)) {
      sva_[(*n_) - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * (((*n_) - 1))], &_k1) * d_[(*n_) - 1];
    }
    else {
      t_ = 0.0;
      aapp_ = 1.0;
      (void) _dlassq (m_, &a_[0 + ((*lda_)) * (((*n_) - 1))], &_k1, &t_, &aapp_);
      sva_[(*n_) - 1] = t_ * __dsqrt (&aapp_) * d_[(*n_) - 1];
    }
    if ((i_ < swband_) && ((mxaapq_ <= roottol_) || (iswrot_ <= (*n_)))) {
      swband_ = i_;
    }
    if ((i_ > swband_ + 1) && (mxaapq_ < (real_8) ((*n_)) * (*tol_)) && ((real_8) ((*n_)) * mxaapq_ * mxsinj_ < (*tol_))) 
      {
      goto _l1994;
    }
    if (notrot_ >= emptsw_) {
      goto _l1994;
    }
  }
  (*info_) = (*nsweep_) - 1;
  goto _l1995;
  _l1994:;
  (*info_) = 0;
  _l1995:;
  for (p_ = 1; p_ <= (*n_) - 1; (p_)++) {
    q_ = _idamax (($65_ = (*n_) - p_ + 1, &$65_), &sva_[p_ - 1], &_k1) + p_ - 1;
    if (p_ != q_) {
      temp1_ = sva_[p_ - 1];
      sva_[p_ - 1] = sva_[q_ - 1];
      sva_[q_ - 1] = temp1_;
      temp1_ = d_[p_ - 1];
      d_[p_ - 1] = d_[q_ - 1];
      d_[q_ - 1] = temp1_;
      (void) _dswap (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
      if (rsvec_) {
        (void) _dswap (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
      }
    }
  }
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _dgsvj1 (char _p_ jobv_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ n1_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, 
real_8 _p_ sva_, int_4 _p_ mv_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ eps_, real_8 _p_ sfmin_, real_8 _p_ tol_, 
int_4 _p_ nsweep_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 blskip_, emptsw_, i_, ibr_, igl_, ierr_, ijblsk_, iswrot_, jbc_, jgl_, kbl_, mvl_, notrot_, nblc_, nblr_, 
  p_, pskipped_, q_, rowskip_, swband_;
  static logical_4 applv_, rotok_, rsvec_;
  static real_8 aapp_, aapp0_, aapq_, aaqq_, apoaq_, aqoap_, big_, bigtheta_, cs_, large_, mxaapq_, mxsinj_, rootbig_, 
  rooteps_, rootsfmin_, roottol_, small_, sn_, t_, temp1_, theta_, thsign_, fastr_[5];
  int_4 $0_, $36_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, $20_, 
  $21_, $22_, $23_, $24_, $25_, $26_, $27_, $28_, $29_, $30_, $31_, $32_, $33_, $34_, $35_;
  extern real_8 _dabs ();
  extern real_8 _dsign ();
  extern real_8 _dsqrt ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern int_4 _idamax ();
  extern logical_4 _lsame ();
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern int_4 _drotm ();
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  real_8 __dabs (real_8 _p_ __x__) {return _abs (*__x__);}
  real_8 __dsign (real_8 _p_ __x__, real_8 _p_ __y__) {return _sign (*__x__, *__y__);}
  real_8 __dsqrt (real_8 _p_ __x__) {return sqrt (*__x__);}
  applv_ = _lsame (jobv_, _dc_7);
  rsvec_ = _lsame (jobv_, _dc_11);
  if (! ((rsvec_ || applv_ || _lsame (jobv_, _dc_2)))) {
    (*info_) = -1;
  }
  else if ((*m_) < 0) {
    (*info_) = -2;
  }
  else if (((*n_) < 0) || ((*n_) > (*m_))) {
    (*info_) = -3;
  }
  else if ((*n1_) < 0) {
    (*info_) = -4;
  }
  else if ((*lda_) < (*m_)) {
    (*info_) = -6;
  }
  else if ((rsvec_ || applv_) && ((*mv_) < 0)) {
    (*info_) = -9;
  }
  else if ((rsvec_ && ((*ldv_) < (*n_))) || (applv_ && ((*ldv_) < (*mv_)))) {
    (*info_) = -11;
  }
  else if ((*tol_) <= (*eps_)) {
    (*info_) = -14;
  }
  else if ((*nsweep_) < 0) {
    (*info_) = -15;
  }
  else if ((*lwork_) < (*m_)) {
    (*info_) = -17;
  }
  else {
    (*info_) = 0;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_65, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if (rsvec_) {
    mvl_ = (*n_);
  }
  else if (applv_) {
    mvl_ = (*mv_);
  }
  rsvec_ = rsvec_ || applv_;
  rooteps_ = __dsqrt (eps_);
  rootsfmin_ = __dsqrt (sfmin_);
  small_ = (*sfmin_) / (*eps_);
  big_ = 1.0 / (*sfmin_);
  rootbig_ = 1.0 / rootsfmin_;
  large_ = big_ / __dsqrt (($1_ = (real_8) ((*m_) * (*n_)), &$1_));
  bigtheta_ = 1.0 / rooteps_;
  roottol_ = __dsqrt (tol_);
  emptsw_ = (*n1_) * ((*n_) - (*n1_));
  notrot_ = 0;
  fastr_[0] = 0.0;
  kbl_ = _min (8, (*n_));
  nblr_ = (*n1_) / kbl_;
  if ((nblr_ * kbl_) != (*n1_)) {
    nblr_ = nblr_ + 1;
  }
  nblc_ = ((*n_) - (*n1_)) / kbl_;
  if ((nblc_ * kbl_) != ((*n_) - (*n1_))) {
    nblc_ = nblc_ + 1;
  }
  blskip_ = ((kbl_ * kbl_)) + 1;
  rowskip_ = _min (5, kbl_);
  swband_ = 0;
  for (i_ = 1; i_ <= (*nsweep_); (i_)++) {
    mxaapq_ = 0.0;
    mxsinj_ = 0.0;
    iswrot_ = 0;
    notrot_ = 0;
    pskipped_ = 0;
    for (ibr_ = 1; ibr_ <= nblr_; (ibr_)++) {
      igl_ = (ibr_ - 1) * kbl_ + 1;
      igl_ = (ibr_ - 1) * kbl_ + 1;
      for (jbc_ = 1; jbc_ <= nblc_; (jbc_)++) {
        jgl_ = (*n1_) + (jbc_ - 1) * kbl_ + 1;
        ijblsk_ = 0;
        for (p_ = igl_; p_ <= _min (igl_ + kbl_ - 1, (*n1_)); (p_)++) {
          aapp_ = sva_[p_ - 1];
          if (aapp_ > 0.0) {
            pskipped_ = 0;
            for (q_ = jgl_; q_ <= _min (jgl_ + kbl_ - 1, (*n_)); (q_)++) {
              aaqq_ = sva_[q_ - 1];
              if (aaqq_ > 0.0) {
                aapp0_ = aapp_;
                if (aaqq_ >= 1.0) {
                  if (aapp_ >= aaqq_) {
                    rotok_ = (small_ * aapp_) <= aaqq_;
                  }
                  else {
                    rotok_ = (small_ * aaqq_) <= aapp_;
                  }
                  if (aapp_ < (big_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[p_ - 1] * d_[q_ 
                    - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, work_, &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, &d_[p_ - 1], m_, &_k1, work_, lda_, &ierr_);
                    aapq_ = _ddot (m_, work_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[q_ - 1] / aaqq_;
                  }
                }
                else {
                  if (aapp_ >= aaqq_) {
                    rotok_ = aapp_ <= (aaqq_ / small_);
                  }
                  else {
                    rotok_ = aaqq_ <= (aapp_ / small_);
                  }
                  if (aapp_ > (small_ / aaqq_)) {
                    aapq_ = (_ddot (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[p_ - 1] * d_[q_ 
                    - 1] / aaqq_) / aapp_;
                  }
                  else {
                    (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, work_, &_k1);
                    (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, &d_[q_ - 1], m_, &_k1, work_, lda_, &ierr_);
                    aapq_ = _ddot (m_, work_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * d_[p_ - 1] / aapp_;
                  }
                }
                mxaapq_ = _max (mxaapq_, __dabs (&aapq_));
                if (__dabs (&aapq_) > (*tol_)) {
                  notrot_ = 0;
                  pskipped_ = 0;
                  iswrot_ = iswrot_ + 1;
                  if (rotok_) {
                    aqoap_ = aaqq_ / aapp_;
                    apoaq_ = aapp_ / aaqq_;
                    theta_ = -0.5 * __dabs (($2_ = aqoap_ - apoaq_, &$2_)) / aapq_;
                    if (aaqq_ > aapp0_) {
                      theta_ = -theta_;
                    }
                    if (__dabs (&theta_) > bigtheta_) {
                      t_ = 0.5 / theta_;
                      fastr_[2] = t_ * d_[p_ - 1] / d_[q_ - 1];
                      fastr_[3] = -t_ * d_[q_ - 1] / d_[p_ - 1];
                      (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                      if (rsvec_) {
                        (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                      }
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($3_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$3_));
                      aapp_ = aapp_ * __dsqrt (($4_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$4_));
                      mxsinj_ = _max (mxsinj_, __dabs (&t_));
                    }
                    else {
                      thsign_ = -__dsign (($5_ = 1.0, &$5_), &aapq_);
                      if (aaqq_ > aapp0_) {
                        thsign_ = -thsign_;
                      }
                      t_ = 1.0 / (theta_ + thsign_ * __dsqrt (($6_ = 1.0 + theta_ * theta_, &$6_)));
                      cs_ = __dsqrt (($7_ = 1.0 / (1.0 + t_ * t_), &$7_));
                      sn_ = t_ * cs_;
                      mxsinj_ = _max (mxsinj_, __dabs (&sn_));
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($8_ = _max (0.0, 1.0 + t_ * apoaq_ * aapq_), &$8_));
                      aapp_ = aapp_ * __dsqrt (($9_ = _max (0.0, 1.0 - t_ * aqoap_ * aapq_), &$9_));
                      apoaq_ = d_[p_ - 1] / d_[q_ - 1];
                      aqoap_ = d_[q_ - 1] / d_[p_ - 1];
                      if (d_[p_ - 1] >= 1.0) {
                        if (d_[q_ - 1] >= 1.0) {
                          fastr_[2] = t_ * apoaq_;
                          fastr_[3] = -t_ * aqoap_;
                          d_[p_ - 1] = d_[p_ - 1] * cs_;
                          d_[q_ - 1] = d_[q_ - 1] * cs_;
                          (void) _drotm (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, fastr_);
                          if (rsvec_) {
                            (void) _drotm (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, fastr_);
                          }
                        }
                        else {
                          (void) _daxpy (m_, ($10_ = -t_ * aqoap_, &$10_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                          1))], &_k1);
                          (void) _daxpy (m_, ($11_ = cs_ * sn_ * apoaq_, &$11_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                          - 1))], &_k1);
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($12_ = -t_ * aqoap_, &$12_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($13_ = cs_ * sn_ * apoaq_, &$13_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((q_ - 1))], &_k1);
                          }
                          d_[p_ - 1] = d_[p_ - 1] * cs_;
                          d_[q_ - 1] = d_[q_ - 1] / cs_;
                        }
                      }
                      else {
                        if (d_[q_ - 1] >= 1.0) {
                          (void) _daxpy (m_, ($14_ = t_ * apoaq_, &$14_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                          &_k1);
                          (void) _daxpy (m_, ($15_ = -cs_ * sn_ * aqoap_, &$15_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                          - 1))], &_k1);
                          if (rsvec_) {
                            (void) _daxpy (&mvl_, ($16_ = t_ * apoaq_, &$16_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                            1))], &_k1);
                            (void) _daxpy (&mvl_, ($17_ = -cs_ * sn_ * aqoap_, &$17_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                            ((p_ - 1))], &_k1);
                          }
                          d_[p_ - 1] = d_[p_ - 1] / cs_;
                          d_[q_ - 1] = d_[q_ - 1] * cs_;
                        }
                        else {
                          if (d_[p_ - 1] >= d_[q_ - 1]) {
                            (void) _daxpy (m_, ($18_ = -t_ * aqoap_, &$18_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ - 
                            1))], &_k1);
                            (void) _daxpy (m_, ($19_ = cs_ * sn_ * apoaq_, &$19_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ 
                            - 1))], &_k1);
                            d_[p_ - 1] = d_[p_ - 1] * cs_;
                            d_[q_ - 1] = d_[q_ - 1] / cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($20_ = -t_ * aqoap_, &$20_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((p_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($21_ = cs_ * sn_ * apoaq_, &$21_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((q_ - 1))], &_k1);
                            }
                          }
                          else {
                            (void) _daxpy (m_, ($22_ = t_ * apoaq_, &$22_), &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], 
                            &_k1);
                            (void) _daxpy (m_, ($23_ = -cs_ * sn_ * aqoap_, &$23_), &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((p_ 
                            - 1))], &_k1);
                            d_[p_ - 1] = d_[p_ - 1] / cs_;
                            d_[q_ - 1] = d_[q_ - 1] * cs_;
                            if (rsvec_) {
                              (void) _daxpy (&mvl_, ($24_ = t_ * apoaq_, &$24_), &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 
                              1))], &_k1);
                              (void) _daxpy (&mvl_, ($25_ = -cs_ * sn_ * aqoap_, &$25_), &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1, &v_[0 + ((*ldv_)) * 
                              ((p_ - 1))], &_k1);
                            }
                          }
                        }
                      }
                    }
                  }
                  else {
                    if (aapp_ > aaqq_) {
                      (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, work_, &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, ($26_ = 1.0, &$26_), m_, &_k1, work_, lda_, &ierr_);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, ($27_ = 1.0, &$27_), m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                      &ierr_);
                      temp1_ = -aapq_ * d_[p_ - 1] / d_[q_ - 1];
                      (void) _daxpy (m_, &temp1_, work_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, ($28_ = 1.0, &$28_), &aaqq_, m_, &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], lda_, 
                      &ierr_);
                      sva_[q_ - 1] = aaqq_ * __dsqrt (($29_ = _max (0.0, 1.0 - aapq_ * aapq_), &$29_));
                      mxsinj_ = _max (mxsinj_, (*sfmin_));
                    }
                    else {
                      (void) _dcopy (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, work_, &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aaqq_, ($30_ = 1.0, &$30_), m_, &_k1, work_, lda_, &ierr_);
                      (void) _dlascl (_dc_9, &_k0, &_k0, &aapp_, ($31_ = 1.0, &$31_), m_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], lda_, 
                      &ierr_);
                      temp1_ = -aapq_ * d_[q_ - 1] / d_[p_ - 1];
                      (void) _daxpy (m_, &temp1_, work_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1);
                      (void) _dlascl (_dc_9, &_k0, &_k0, ($32_ = 1.0, &$32_), &aapp_, m_, &_k1, &a_[0 + ((*lda_)) * ((p_ - 1))], lda_, 
                      &ierr_);
                      sva_[p_ - 1] = aapp_ * __dsqrt (($33_ = _max (0.0, 1.0 - aapq_ * aapq_), &$33_));
                      mxsinj_ = _max (mxsinj_, (*sfmin_));
                    }
                  }
                  if (($34_ = (sva_[q_ - 1] / aaqq_), $34_ * $34_) <= rooteps_) {
                    if ((aaqq_ < rootbig_) && (aaqq_ > rootsfmin_)) {
                      sva_[q_ - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1) * d_[q_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aaqq_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1, &t_, &aaqq_);
                      sva_[q_ - 1] = t_ * __dsqrt (&aaqq_) * d_[q_ - 1];
                    }
                  }
                  if (($35_ = (aapp_ / aapp0_), $35_ * $35_) <= rooteps_) {
                    if ((aapp_ < rootbig_) && (aapp_ > rootsfmin_)) {
                      aapp_ = _dnrm2 (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1) * d_[p_ - 1];
                    }
                    else {
                      t_ = 0.0;
                      aapp_ = 1.0;
                      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &t_, &aapp_);
                      aapp_ = t_ * __dsqrt (&aapp_) * d_[p_ - 1];
                    }
                    sva_[p_ - 1] = aapp_;
                  }
                }
                else {
                  notrot_ = notrot_ + 1;
                  pskipped_ = pskipped_ + 1;
                  ijblsk_ = ijblsk_ + 1;
                }
              }
              else {
                notrot_ = notrot_ + 1;
                pskipped_ = pskipped_ + 1;
                ijblsk_ = ijblsk_ + 1;
              }
              if ((i_ <= swband_) && (ijblsk_ >= blskip_)) {
                sva_[p_ - 1] = aapp_;
                notrot_ = 0;
                goto _l2011;
              }
              if ((i_ <= swband_) && (pskipped_ > rowskip_)) {
                aapp_ = -aapp_;
                notrot_ = 0;
                goto _l2203;
              }
            }
            _l2203:;
            sva_[p_ - 1] = aapp_;
          }
          else {
            if (aapp_ == 0.0) {
              notrot_ = notrot_ + _min (jgl_ + kbl_ - 1, (*n_)) - jgl_ + 1;
            }
            if (aapp_ < 0.0) {
              notrot_ = 0;
            }
          }
        }
      }
      _l2011:;
      for (p_ = igl_; p_ <= _min (igl_ + kbl_ - 1, (*n_)); (p_)++) {
        sva_[p_ - 1] = __dabs (&sva_[p_ - 1]);
      }
    }
    if ((sva_[(*n_) - 1] < rootbig_) && (sva_[(*n_) - 1] > rootsfmin_)) {
      sva_[(*n_) - 1] = _dnrm2 (m_, &a_[0 + ((*lda_)) * (((*n_) - 1))], &_k1) * d_[(*n_) - 1];
    }
    else {
      t_ = 0.0;
      aapp_ = 1.0;
      (void) _dlassq (m_, &a_[0 + ((*lda_)) * (((*n_) - 1))], &_k1, &t_, &aapp_);
      sva_[(*n_) - 1] = t_ * __dsqrt (&aapp_) * d_[(*n_) - 1];
    }
    if ((i_ < swband_) && ((mxaapq_ <= roottol_) || (iswrot_ <= (*n_)))) {
      swband_ = i_;
    }
    if ((i_ > swband_ + 1) && (mxaapq_ < (real_8) ((*n_)) * (*tol_)) && ((real_8) ((*n_)) * mxaapq_ * mxsinj_ < (*tol_))) 
      {
      goto _l1994;
    }
    if (notrot_ >= emptsw_) {
      goto _l1994;
    }
  }
  (*info_) = (*nsweep_) - 1;
  goto _l1995;
  _l1994:;
  (*info_) = 0;
  _l1995:;
  for (p_ = 1; p_ <= (*n_) - 1; (p_)++) {
    q_ = _idamax (($36_ = (*n_) - p_ + 1, &$36_), &sva_[p_ - 1], &_k1) + p_ - 1;
    if (p_ != q_) {
      temp1_ = sva_[p_ - 1];
      sva_[p_ - 1] = sva_[q_ - 1];
      sva_[q_ - 1] = temp1_;
      temp1_ = d_[p_ - 1];
      d_[p_ - 1] = d_[q_ - 1];
      d_[q_ - 1] = temp1_;
      (void) _dswap (m_, &a_[0 + ((*lda_)) * ((p_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((q_ - 1))], &_k1);
      if (rsvec_) {
        (void) _dswap (&mvl_, &v_[0 + ((*ldv_)) * ((p_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((q_ - 1))], &_k1);
      }
    }
  }
  _l0:;
  __calls[18].calls++;
  return 0;
}

logical_4 _disnan (real_8 _p_ din_)
{
  logical_4 disnan_;
  disnan_ = _dlaisnan (din_, din_);
  __calls[19].calls++;
  return disnan_;
}

int_4 _dlabad (real_8 _p_ small_, real_8 _p_ large_)
{
  if (log10 ((*large_)) > 2000.0e0) {
    (*small_) = sqrt ((*small_));
    (*large_) = sqrt ((*large_));
  }
  __calls[20].calls++;
  return 0;
}

int_4 _dlabrd (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ nb_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ d_, real_8 _p_ e_, 
real_8 _p_ tauq_, real_8 _p_ taup_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ y_, int_4 _p_ ldy_)
{
  static int_4 i_;
  int_4 $0_, $1_, $4_, $5_, $8_, $9_, $10_, $13_, $14_, $17_, $18_, $21_, $22_, $25_, $26_, $29_, $30_, $33_, $34_, $37_, 
  $38_, $39_, $42_, $45_, $48_, $49_, $52_, $53_, $56_, $57_, $58_, $61_, $62_, $65_, $66_, $67_, $70_, $71_, $74_, $75_, 
  $78_, $79_, $82_, $83_, $86_, $87_, $88_, $91_, $94_, $95_, $96_, $99_, $100_, $103_, $104_, $107_, $110_, $113_;
  real_8 $2_, $3_, $6_, $7_, $11_, $12_, $15_, $16_, $19_, $20_, $23_, $24_, $27_, $28_, $31_, $32_, $35_, $36_, $40_, 
  $41_, $43_, $44_, $46_, $47_, $50_, $51_, $54_, $55_, $59_, $60_, $63_, $64_, $68_, $69_, $72_, $73_, $76_, $77_, $80_, 
  $81_, $84_, $85_, $89_, $90_, $92_, $93_, $97_, $98_, $101_, $102_, $105_, $106_, $108_, $109_, $111_, $112_;
  extern int_4 _dgemv ();
  extern int_4 _dscal ();
  if ((*m_) <= 0 || (*n_) <= 0) {
    goto _l0;
  }
  if ((*m_) >= (*n_)) {
    for (i_ = 1; i_ <= (*nb_); (i_)++) {
      (void) _dgemv (_dc_21, ($0_ = (*m_) - i_ + 1, &$0_), ($1_ = i_ - 1, &$1_), ($2_ = -1.0, &$2_), &a_[i_ - 1 + ((*lda_)) * 
      ((0))], lda_, &y_[i_ - 1 + ((*ldy_)) * ((0))], ldy_, ($3_ = 1.0, &$3_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1);
      (void) _dgemv (_dc_21, ($4_ = (*m_) - i_ + 1, &$4_), ($5_ = i_ - 1, &$5_), ($6_ = -1.0, &$6_), &x_[i_ - 1 + ((*ldx_)) * 
      ((0))], ldx_, &a_[0 + ((*lda_)) * ((i_ - 1))], &_k1, ($7_ = 1.0, &$7_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1);
      (void) _dlarfg (($8_ = (*m_) - i_ + 1, &$8_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[_min (i_ + 1, (*m_)) - 1 + 
      ((*lda_)) * ((i_ - 1))], &_k1, &tauq_[i_ - 1]);
      d_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      if (i_ < (*n_)) {
        a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
        (void) _dgemv (_dc_22, ($9_ = (*m_) - i_ + 1, &$9_), ($10_ = (*n_) - i_, &$10_), ($11_ = 1.0, &$11_), &a_[i_ - 1 + 
        ((*lda_)) * ((i_ + 1 - 1))], lda_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1, ($12_ = 0.0, &$12_), &y_[i_ + 1 - 1 + 
        ((*ldy_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_22, ($13_ = (*m_) - i_ + 1, &$13_), ($14_ = i_ - 1, &$14_), ($15_ = 1.0, &$15_), &a_[i_ - 1 + 
        ((*lda_)) * ((0))], lda_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1, ($16_ = 0.0, &$16_), &y_[0 + ((*ldy_)) * ((i_ - 
        1))], &_k1);
        (void) _dgemv (_dc_21, ($17_ = (*n_) - i_, &$17_), ($18_ = i_ - 1, &$18_), ($19_ = -1.0, &$19_), &y_[i_ + 1 - 1 + 
        ((*ldy_)) * ((0))], ldy_, &y_[0 + ((*ldy_)) * ((i_ - 1))], &_k1, ($20_ = 1.0, &$20_), &y_[i_ + 1 - 1 + ((*ldy_)) * ((i_ 
        - 1))], &_k1);
        (void) _dgemv (_dc_22, ($21_ = (*m_) - i_ + 1, &$21_), ($22_ = i_ - 1, &$22_), ($23_ = 1.0, &$23_), &x_[i_ - 1 + 
        ((*ldx_)) * ((0))], ldx_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1, ($24_ = 0.0, &$24_), &y_[0 + ((*ldy_)) * ((i_ - 
        1))], &_k1);
        (void) _dgemv (_dc_22, ($25_ = i_ - 1, &$25_), ($26_ = (*n_) - i_, &$26_), ($27_ = -1.0, &$27_), &a_[0 + ((*lda_)) * 
        ((i_ + 1 - 1))], lda_, &y_[0 + ((*ldy_)) * ((i_ - 1))], &_k1, ($28_ = 1.0, &$28_), &y_[i_ + 1 - 1 + ((*ldy_)) * ((i_ - 
        1))], &_k1);
        (void) _dscal (($29_ = (*n_) - i_, &$29_), &tauq_[i_ - 1], &y_[i_ + 1 - 1 + ((*ldy_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_21, ($30_ = (*n_) - i_, &$30_), &i_, ($31_ = -1.0, &$31_), &y_[i_ + 1 - 1 + ((*ldy_)) * ((0))], 
        ldy_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, ($32_ = 1.0, &$32_), &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_);
        (void) _dgemv (_dc_22, ($33_ = i_ - 1, &$33_), ($34_ = (*n_) - i_, &$34_), ($35_ = -1.0, &$35_), &a_[0 + ((*lda_)) * 
        ((i_ + 1 - 1))], lda_, &x_[i_ - 1 + ((*ldx_)) * ((0))], ldx_, ($36_ = 1.0, &$36_), &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 
        1))], lda_);
        (void) _dlarfg (($37_ = (*n_) - i_, &$37_), &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], &a_[i_ - 1 + ((*lda_)) * ((_min 
        (i_ + 2, (*n_)) - 1))], lda_, &taup_[i_ - 1]);
        e_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))];
        a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))] = 1.0;
        (void) _dgemv (_dc_21, ($38_ = (*m_) - i_, &$38_), ($39_ = (*n_) - i_, &$39_), ($40_ = 1.0, &$40_), &a_[i_ + 1 - 1 + 
        ((*lda_)) * ((i_ + 1 - 1))], lda_, &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, ($41_ = 0.0, &$41_), &x_[i_ + 1 - 1 
        + ((*ldx_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_22, ($42_ = (*n_) - i_, &$42_), &i_, ($43_ = 1.0, &$43_), &y_[i_ + 1 - 1 + ((*ldy_)) * ((0))], ldy_, 
        &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, ($44_ = 0.0, &$44_), &x_[0 + ((*ldx_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_21, ($45_ = (*m_) - i_, &$45_), &i_, ($46_ = -1.0, &$46_), &a_[i_ + 1 - 1 + ((*lda_)) * ((0))], 
        lda_, &x_[0 + ((*ldx_)) * ((i_ - 1))], &_k1, ($47_ = 1.0, &$47_), &x_[i_ + 1 - 1 + ((*ldx_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_21, ($48_ = i_ - 1, &$48_), ($49_ = (*n_) - i_, &$49_), ($50_ = 1.0, &$50_), &a_[0 + ((*lda_)) * 
        ((i_ + 1 - 1))], lda_, &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, ($51_ = 0.0, &$51_), &x_[0 + ((*ldx_)) * ((i_ - 
        1))], &_k1);
        (void) _dgemv (_dc_21, ($52_ = (*m_) - i_, &$52_), ($53_ = i_ - 1, &$53_), ($54_ = -1.0, &$54_), &x_[i_ + 1 - 1 + 
        ((*ldx_)) * ((0))], ldx_, &x_[0 + ((*ldx_)) * ((i_ - 1))], &_k1, ($55_ = 1.0, &$55_), &x_[i_ + 1 - 1 + ((*ldx_)) * ((i_ 
        - 1))], &_k1);
        (void) _dscal (($56_ = (*m_) - i_, &$56_), &taup_[i_ - 1], &x_[i_ + 1 - 1 + ((*ldx_)) * ((i_ - 1))], &_k1);
      }
    }
  }
  else {
    for (i_ = 1; i_ <= (*nb_); (i_)++) {
      (void) _dgemv (_dc_21, ($57_ = (*n_) - i_ + 1, &$57_), ($58_ = i_ - 1, &$58_), ($59_ = -1.0, &$59_), &y_[i_ - 1 + 
      ((*ldy_)) * ((0))], ldy_, &a_[i_ - 1 + ((*lda_)) * ((0))], lda_, ($60_ = 1.0, &$60_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 
      1))], lda_);
      (void) _dgemv (_dc_22, ($61_ = i_ - 1, &$61_), ($62_ = (*n_) - i_ + 1, &$62_), ($63_ = -1.0, &$63_), &a_[0 + ((*lda_)) 
      * ((i_ - 1))], lda_, &x_[i_ - 1 + ((*ldx_)) * ((0))], ldx_, ($64_ = 1.0, &$64_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
      lda_);
      (void) _dlarfg (($65_ = (*n_) - i_ + 1, &$65_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[i_ - 1 + ((*lda_)) * ((_min 
      (i_ + 1, (*n_)) - 1))], lda_, &taup_[i_ - 1]);
      d_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
      if (i_ < (*m_)) {
        a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
        (void) _dgemv (_dc_21, ($66_ = (*m_) - i_, &$66_), ($67_ = (*n_) - i_ + 1, &$67_), ($68_ = 1.0, &$68_), &a_[i_ + 1 - 1 
        + ((*lda_)) * ((i_ - 1))], lda_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, ($69_ = 0.0, &$69_), &x_[i_ + 1 - 1 + 
        ((*ldx_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_22, ($70_ = (*n_) - i_ + 1, &$70_), ($71_ = i_ - 1, &$71_), ($72_ = 1.0, &$72_), &y_[i_ - 1 + 
        ((*ldy_)) * ((0))], ldy_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, ($73_ = 0.0, &$73_), &x_[0 + ((*ldx_)) * ((i_ - 
        1))], &_k1);
        (void) _dgemv (_dc_21, ($74_ = (*m_) - i_, &$74_), ($75_ = i_ - 1, &$75_), ($76_ = -1.0, &$76_), &a_[i_ + 1 - 1 + 
        ((*lda_)) * ((0))], lda_, &x_[0 + ((*ldx_)) * ((i_ - 1))], &_k1, ($77_ = 1.0, &$77_), &x_[i_ + 1 - 1 + ((*ldx_)) * ((i_ 
        - 1))], &_k1);
        (void) _dgemv (_dc_21, ($78_ = i_ - 1, &$78_), ($79_ = (*n_) - i_ + 1, &$79_), ($80_ = 1.0, &$80_), &a_[0 + ((*lda_)) * 
        ((i_ - 1))], lda_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, ($81_ = 0.0, &$81_), &x_[0 + ((*ldx_)) * ((i_ - 1))], 
        &_k1);
        (void) _dgemv (_dc_21, ($82_ = (*m_) - i_, &$82_), ($83_ = i_ - 1, &$83_), ($84_ = -1.0, &$84_), &x_[i_ + 1 - 1 + 
        ((*ldx_)) * ((0))], ldx_, &x_[0 + ((*ldx_)) * ((i_ - 1))], &_k1, ($85_ = 1.0, &$85_), &x_[i_ + 1 - 1 + ((*ldx_)) * ((i_ 
        - 1))], &_k1);
        (void) _dscal (($86_ = (*m_) - i_, &$86_), &taup_[i_ - 1], &x_[i_ + 1 - 1 + ((*ldx_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_21, ($87_ = (*m_) - i_, &$87_), ($88_ = i_ - 1, &$88_), ($89_ = -1.0, &$89_), &a_[i_ + 1 - 1 + 
        ((*lda_)) * ((0))], lda_, &y_[i_ - 1 + ((*ldy_)) * ((0))], ldy_, ($90_ = 1.0, &$90_), &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ 
        - 1))], &_k1);
        (void) _dgemv (_dc_21, ($91_ = (*m_) - i_, &$91_), &i_, ($92_ = -1.0, &$92_), &x_[i_ + 1 - 1 + ((*ldx_)) * ((0))], 
        ldx_, &a_[0 + ((*lda_)) * ((i_ - 1))], &_k1, ($93_ = 1.0, &$93_), &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], &_k1);
        (void) _dlarfg (($94_ = (*m_) - i_, &$94_), &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], &a_[_min (i_ + 2, (*m_)) - 1 + 
        ((*lda_)) * ((i_ - 1))], &_k1, &tauq_[i_ - 1]);
        e_[i_ - 1] = a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))];
        a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
        (void) _dgemv (_dc_22, ($95_ = (*m_) - i_, &$95_), ($96_ = (*n_) - i_, &$96_), ($97_ = 1.0, &$97_), &a_[i_ + 1 - 1 + 
        ((*lda_)) * ((i_ + 1 - 1))], lda_, &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], &_k1, ($98_ = 0.0, &$98_), &y_[i_ + 1 - 1 
        + ((*ldy_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_22, ($99_ = (*m_) - i_, &$99_), ($100_ = i_ - 1, &$100_), ($101_ = 1.0, &$101_), &a_[i_ + 1 - 1 + 
        ((*lda_)) * ((0))], lda_, &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], &_k1, ($102_ = 0.0, &$102_), &y_[0 + ((*ldy_)) * 
        ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_21, ($103_ = (*n_) - i_, &$103_), ($104_ = i_ - 1, &$104_), ($105_ = -1.0, &$105_), &y_[i_ + 1 - 1 + 
        ((*ldy_)) * ((0))], ldy_, &y_[0 + ((*ldy_)) * ((i_ - 1))], &_k1, ($106_ = 1.0, &$106_), &y_[i_ + 1 - 1 + ((*ldy_)) * 
        ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_22, ($107_ = (*m_) - i_, &$107_), &i_, ($108_ = 1.0, &$108_), &x_[i_ + 1 - 1 + ((*ldx_)) * ((0))], 
        ldx_, &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], &_k1, ($109_ = 0.0, &$109_), &y_[0 + ((*ldy_)) * ((i_ - 1))], &_k1);
        (void) _dgemv (_dc_22, &i_, ($110_ = (*n_) - i_, &$110_), ($111_ = -1.0, &$111_), &a_[0 + ((*lda_)) * ((i_ + 1 - 1))], 
        lda_, &y_[0 + ((*ldy_)) * ((i_ - 1))], &_k1, ($112_ = 1.0, &$112_), &y_[i_ + 1 - 1 + ((*ldy_)) * ((i_ - 1))], &_k1);
        (void) _dscal (($113_ = (*n_) - i_, &$113_), &tauq_[i_ - 1], &y_[i_ + 1 - 1 + ((*ldy_)) * ((i_ - 1))], &_k1);
      }
    }
  }
  _l0:;
  __calls[21].calls++;
  return 0;
}

int_4 _dlacn2 (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ x_, int_4 _p_ isgn_, real_8 _p_ est_, int_4 _p_ kase_, int_4 _p_ 
isave_)
{
  static int_4 i_, jlast_;
  static real_8 altsgn_, estold_, temp_, xs_;
  extern int_4 _idamax ();
  extern real_8 _dasum ();
  extern int_4 _dcopy ();
  if ((*kase_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      x_[i_ - 1] = 1.0 / (real_8) ((*n_));
    }
    (*kase_) = 1;
    isave_[0] = 1;
    goto _l0;
  }
  switch (isave_[0]) {
    default:
    case 1: goto _l20;
    case 2: goto _l40;
    case 3: goto _l70;
    case 4: goto _l110;
    case 5: goto _l140;
  }
  _l20:;
  if ((*n_) == 1) {
    v_[0] = x_[0];
    (*est_) = _abs (v_[0]);
    goto _l150;
  }
  (*est_) = _dasum (n_, x_, &_k1);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] >= 0.0) {
      x_[i_ - 1] = 1.0;
    }
    else {
      x_[i_ - 1] = -1.0;
    }
    isgn_[i_ - 1] = _nintd (x_[i_ - 1]);
  }
  (*kase_) = 2;
  isave_[0] = 2;
  goto _l0;
  _l40:;
  isave_[1] = _idamax (n_, x_, &_k1);
  isave_[2] = 2;
  _l50:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = 0.0;
  }
  x_[isave_[1] - 1] = 1.0;
  (*kase_) = 1;
  isave_[0] = 3;
  goto _l0;
  _l70:;
  (void) _dcopy (n_, x_, &_k1, v_, &_k1);
  estold_ = (*est_);
  (*est_) = _dasum (n_, v_, &_k1);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] >= 0.0) {
      xs_ = 1.0;
    }
    else {
      xs_ = -1.0;
    }
    if (_nintd (xs_) != isgn_[i_ - 1]) {
      goto _l90;
    }
  }
  goto _l120;
  _l90:;
  if ((*est_) <= estold_) {
    goto _l120;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] >= 0.0) {
      x_[i_ - 1] = 1.0;
    }
    else {
      x_[i_ - 1] = -1.0;
    }
    isgn_[i_ - 1] = _nintd (x_[i_ - 1]);
  }
  (*kase_) = 2;
  isave_[0] = 4;
  goto _l0;
  _l110:;
  jlast_ = isave_[1];
  isave_[1] = _idamax (n_, x_, &_k1);
  if ((x_[jlast_ - 1] != _abs (x_[isave_[1] - 1])) && (isave_[2] < 5)) {
    isave_[2] = isave_[2] + 1;
    goto _l50;
  }
  _l120:;
  altsgn_ = 1.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = altsgn_ * (1.0 + (real_8) (i_ - 1) / (real_8) ((*n_) - 1));
    altsgn_ = -altsgn_;
  }
  (*kase_) = 1;
  isave_[0] = 5;
  goto _l0;
  _l140:;
  temp_ = 2.0 * (_dasum (n_, x_, &_k1) / (real_8) (3 * (*n_)));
  if (temp_ > (*est_)) {
    (void) _dcopy (n_, x_, &_k1, v_, &_k1);
    (*est_) = temp_;
  }
  _l150:;
  (*kase_) = 0;
  _l0:;
  __calls[22].calls++;
  return 0;
}

int_4 _dlacpy (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ b_, int_4 _p_ ldb_
)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if (_lsame (uplo_, _dc_0)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_, (*m_)); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  else if (_lsame (uplo_, _dc_1)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        b_[i_ - 1 + ((*ldb_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      }
    }
  }
  __calls[23].calls++;
  return 0;
}

int_4 _dlaed6 (int_4 _p_ kniter_, logical_4 _p_ orgati_, real_8 _p_ rho_, real_8 _p_ d_, real_8 _p_ z_, real_8 _p_ 
finit_, real_8 _p_ tau_, int_4 _p_ info_)
{
  static int_4 i_, iter_, niter_;
  static logical_4 scale_;
  static real_8 dscale_[3], zscale_[3], a_, b_, base_, c_, ddf_, df_, eps_, erretm_, eta_, f_, fc_, sclfac_, sclinv_, 
  small1_, small2_, sminv1_, sminv2_, temp_, temp1_, temp2_, temp3_, temp4_, lbd_, ubd_;
  real_8 $0_, $1_;
  extern real_8 _dlamch ();
  (*info_) = 0;
  if ((*orgati_)) {
    lbd_ = d_[1];
    ubd_ = d_[2];
  }
  else {
    lbd_ = d_[0];
    ubd_ = d_[1];
  }
  if ((*finit_) < 0.0) {
    lbd_ = 0.0;
  }
  else {
    ubd_ = 0.0;
  }
  niter_ = 1;
  (*tau_) = 0.0;
  if ((*kniter_) == 2) {
    if ((*orgati_)) {
      temp_ = (d_[2] - d_[1]) / 2.0;
      c_ = (*rho_) + z_[0] / ((d_[0] - d_[1]) - temp_);
      a_ = c_ * (d_[1] + d_[2]) + z_[1] + z_[2];
      b_ = c_ * d_[1] * d_[2] + z_[1] * d_[2] + z_[2] * d_[1];
    }
    else {
      temp_ = (d_[0] - d_[1]) / 2.0;
      c_ = (*rho_) + z_[2] / ((d_[2] - d_[1]) - temp_);
      a_ = c_ * (d_[0] + d_[1]) + z_[0] + z_[1];
      b_ = c_ * d_[0] * d_[1] + z_[0] * d_[1] + z_[1] * d_[0];
    }
    temp_ = ($0_ = _max (_abs (a_), _abs (b_)), _max ($0_, _abs (c_)));
    a_ = a_ / temp_;
    b_ = b_ / temp_;
    c_ = c_ / temp_;
    if (c_ == 0.0) {
      (*tau_) = b_ / a_;
    }
    else if (a_ <= 0.0) {
      (*tau_) = (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
    }
    else {
      (*tau_) = 2.0 * b_ / (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
    }
    if ((*tau_) < lbd_ || (*tau_) > ubd_) {
      (*tau_) = (lbd_ + ubd_) / 2.0;
    }
    if (d_[0] == (*tau_) || d_[1] == (*tau_) || d_[2] == (*tau_)) {
      (*tau_) = 0.0;
    }
    else {
      temp_ = (*finit_) + (*tau_) * z_[0] / (d_[0] * (d_[0] - (*tau_))) + (*tau_) * z_[1] / (d_[1] * (d_[1] - (*tau_))) + 
      (*tau_) * z_[2] / (d_[2] * (d_[2] - (*tau_)));
      if (temp_ <= 0.0) {
        lbd_ = (*tau_);
      }
      else {
        ubd_ = (*tau_);
      }
      if (_abs ((*finit_)) <= _abs (temp_)) {
        (*tau_) = 0.0;
      }
    }
  }
  eps_ = _dlamch (_dc_10);
  base_ = _dlamch (_dc_66);
  small1_ = _up_real_8 (base_, ((int_4) (_aintd (log (_dlamch (_dc_67)) / log (base_) / 3.0))));
  sminv1_ = 1.0 / small1_;
  small2_ = small1_ * small1_;
  sminv2_ = sminv1_ * sminv1_;
  if ((*orgati_)) {
    temp_ = _min (_abs (d_[1] - (*tau_)), _abs (d_[2] - (*tau_)));
  }
  else {
    temp_ = _min (_abs (d_[0] - (*tau_)), _abs (d_[1] - (*tau_)));
  }
  scale_ = FALSE;
  if (temp_ <= small1_) {
    scale_ = TRUE;
    if (temp_ <= small2_) {
      sclfac_ = sminv2_;
      sclinv_ = small2_;
    }
    else {
      sclfac_ = sminv1_;
      sclinv_ = small1_;
    }
    for (i_ = 1; i_ <= 3; (i_)++) {
      dscale_[i_ - 1] = d_[i_ - 1] * sclfac_;
      zscale_[i_ - 1] = z_[i_ - 1] * sclfac_;
    }
    (*tau_) = (*tau_) * sclfac_;
    lbd_ = lbd_ * sclfac_;
    ubd_ = ubd_ * sclfac_;
  }
  else {
    for (i_ = 1; i_ <= 3; (i_)++) {
      dscale_[i_ - 1] = d_[i_ - 1];
      zscale_[i_ - 1] = z_[i_ - 1];
    }
  }
  fc_ = 0.0;
  df_ = 0.0;
  ddf_ = 0.0;
  for (i_ = 1; i_ <= 3; (i_)++) {
    temp_ = 1.0 / (dscale_[i_ - 1] - (*tau_));
    temp1_ = zscale_[i_ - 1] * temp_;
    temp2_ = temp1_ * temp_;
    temp3_ = temp2_ * temp_;
    fc_ = fc_ + temp1_ / dscale_[i_ - 1];
    df_ = df_ + temp2_;
    ddf_ = ddf_ + temp3_;
  }
  f_ = (*finit_) + (*tau_) * fc_;
  if (_abs (f_) <= 0.0) {
    goto _l60;
  }
  if (f_ <= 0.0) {
    lbd_ = (*tau_);
  }
  else {
    ubd_ = (*tau_);
  }
  iter_ = niter_ + 1;
  for (niter_ = iter_; niter_ <= 40; (niter_)++) {
    if ((*orgati_)) {
      temp1_ = dscale_[1] - (*tau_);
      temp2_ = dscale_[2] - (*tau_);
    }
    else {
      temp1_ = dscale_[0] - (*tau_);
      temp2_ = dscale_[1] - (*tau_);
    }
    a_ = (temp1_ + temp2_) * f_ - temp1_ * temp2_ * df_;
    b_ = temp1_ * temp2_ * f_;
    c_ = f_ - (temp1_ + temp2_) * df_ + temp1_ * temp2_ * ddf_;
    temp_ = ($1_ = _max (_abs (a_), _abs (b_)), _max ($1_, _abs (c_)));
    a_ = a_ / temp_;
    b_ = b_ / temp_;
    c_ = c_ / temp_;
    if (c_ == 0.0) {
      eta_ = b_ / a_;
    }
    else if (a_ <= 0.0) {
      eta_ = (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
    }
    else {
      eta_ = 2.0 * b_ / (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
    }
    if (f_ * eta_ >= 0.0) {
      eta_ = -f_ / df_;
    }
    (*tau_) = (*tau_) + eta_;
    if ((*tau_) < lbd_ || (*tau_) > ubd_) {
      (*tau_) = (lbd_ + ubd_) / 2.0;
    }
    fc_ = 0.0;
    erretm_ = 0.0;
    df_ = 0.0;
    ddf_ = 0.0;
    for (i_ = 1; i_ <= 3; (i_)++) {
      if ((dscale_[i_ - 1] - (*tau_)) != 0.0) {
        temp_ = 1.0 / (dscale_[i_ - 1] - (*tau_));
        temp1_ = zscale_[i_ - 1] * temp_;
        temp2_ = temp1_ * temp_;
        temp3_ = temp2_ * temp_;
        temp4_ = temp1_ / dscale_[i_ - 1];
        fc_ = fc_ + temp4_;
        erretm_ = erretm_ + _abs (temp4_);
        df_ = df_ + temp2_;
        ddf_ = ddf_ + temp3_;
      }
      else {
        goto _l60;
      }
    }
    f_ = (*finit_) + (*tau_) * fc_;
    erretm_ = 8.0 * (_abs ((*finit_)) + _abs ((*tau_)) * erretm_) + _abs ((*tau_)) * df_;
    if ((_abs (f_) <= 4.0 * eps_ * erretm_) || ((ubd_ - lbd_) <= 4.0 * eps_ * _abs ((*tau_)))) {
      goto _l60;
    }
    if (f_ <= 0.0) {
      lbd_ = (*tau_);
    }
    else {
      ubd_ = (*tau_);
    }
  }
  (*info_) = 1;
  _l60:;
  if (scale_) {
    (*tau_) = (*tau_) * sclinv_;
  }
  __calls[24].calls++;
  return 0;
}

logical_4 _dlaisnan (real_8 _p_ din1_, real_8 _p_ din2_)
{
  logical_4 dlaisnan_;
  dlaisnan_ = ((*din1_) != (*din2_));
  __calls[25].calls++;
  return dlaisnan_;
}

int_4 _dlals0 (int_4 _p_ icompq_, int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, int_4 _p_ nrhs_, real_8 _p_ b_, int_4 
_p_ ldb_, real_8 _p_ bx_, int_4 _p_ ldbx_, int_4 _p_ perm_, int_4 _p_ givptr_, int_4 _p_ givcol_, int_4 _p_ ldgcol_, 
real_8 _p_ givnum_, int_4 _p_ ldgnum_, real_8 _p_ poles_, real_8 _p_ difl_, real_8 _p_ difr_, real_8 _p_ z_, int_4 _p_ 
k_, real_8 _p_ c_, real_8 _p_ s_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, j_, m_, n_, nlp1_;
  static real_8 diflj_, difrj_, dj_, dsigj_, dsigjp_, temp_;
  int_4 $0_, $5_, $10_;
  real_8 $1_, $2_, $3_, $4_, $6_, $7_, $8_, $9_, $11_;
  extern int_4 _dcopy ();
  extern int_4 _dgemv ();
  extern int_4 _drot ();
  extern int_4 _dscal ();
  extern int_4 _xerbla ();
  extern real_8 _dlamc3 ();
  extern real_8 _dnrm2 ();
  (*info_) = 0;
  n_ = (*nl_) + (*nr_) + 1;
  if (((*icompq_) < 0) || ((*icompq_) > 1)) {
    (*info_) = -1;
  }
  else if ((*nl_) < 1) {
    (*info_) = -2;
  }
  else if ((*nr_) < 1) {
    (*info_) = -3;
  }
  else if (((*sqre_) < 0) || ((*sqre_) > 1)) {
    (*info_) = -4;
  }
  else if ((*nrhs_) < 1) {
    (*info_) = -5;
  }
  else if ((*ldb_) < n_) {
    (*info_) = -7;
  }
  else if ((*ldbx_) < n_) {
    (*info_) = -9;
  }
  else if ((*givptr_) < 0) {
    (*info_) = -11;
  }
  else if ((*ldgcol_) < n_) {
    (*info_) = -13;
  }
  else if ((*ldgnum_) < n_) {
    (*info_) = -15;
  }
  else if ((*k_) < 1) {
    (*info_) = -20;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_68, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  m_ = n_ + (*sqre_);
  nlp1_ = (*nl_) + 1;
  if ((*icompq_) == 0) {
    for (i_ = 1; i_ <= (*givptr_); (i_)++) {
      (void) _drot (nrhs_, &b_[givcol_[i_ - 1 + ((*ldgcol_)) * ((1))] - 1 + ((*ldb_)) * ((0))], ldb_, &b_[givcol_[i_ - 1 + 
      ((*ldgcol_)) * ((0))] - 1 + ((*ldb_)) * ((0))], ldb_, &givnum_[i_ - 1 + ((*ldgnum_)) * ((1))], &givnum_[i_ - 1 + 
      ((*ldgnum_)) * ((0))]);
    }
    (void) _dcopy (nrhs_, &b_[nlp1_ - 1 + ((*ldb_)) * ((0))], ldb_, &bx_[0 + ((*ldbx_)) * ((0))], ldbx_);
    for (i_ = 2; i_ <= n_; (i_)++) {
      (void) _dcopy (nrhs_, &b_[perm_[i_ - 1] - 1 + ((*ldb_)) * ((0))], ldb_, &bx_[i_ - 1 + ((*ldbx_)) * ((0))], ldbx_);
    }
    if ((*k_) == 1) {
      (void) _dcopy (nrhs_, bx_, ldbx_, b_, ldb_);
      if (z_[0] < 0.0) {
        (void) _dscal (nrhs_, ($1_ = -1.0, &$1_), b_, ldb_);
      }
    }
    else {
      for (j_ = 1; j_ <= (*k_); (j_)++) {
        diflj_ = difl_[j_ - 1];
        dj_ = poles_[j_ - 1 + ((*ldgnum_)) * ((0))];
        dsigj_ = -poles_[j_ - 1 + ((*ldgnum_)) * ((1))];
        if (j_ < (*k_)) {
          difrj_ = -difr_[j_ - 1 + ((*ldgnum_)) * ((0))];
          dsigjp_ = -poles_[j_ + 1 - 1 + ((*ldgnum_)) * ((1))];
        }
        if ((z_[j_ - 1] == 0.0) || (poles_[j_ - 1 + ((*ldgnum_)) * ((1))] == 0.0)) {
          work_[j_ - 1] = 0.0;
        }
        else {
          work_[j_ - 1] = -poles_[j_ - 1 + ((*ldgnum_)) * ((1))] * z_[j_ - 1] / diflj_ / (poles_[j_ - 1 + ((*ldgnum_)) * ((1))] + 
          dj_);
        }
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          if ((z_[i_ - 1] == 0.0) || (poles_[i_ - 1 + ((*ldgnum_)) * ((1))] == 0.0)) {
            work_[i_ - 1] = 0.0;
          }
          else {
            work_[i_ - 1] = poles_[i_ - 1 + ((*ldgnum_)) * ((1))] * z_[i_ - 1] / (_dlamc3 (&poles_[i_ - 1 + ((*ldgnum_)) * ((1))], 
            &dsigj_) - diflj_) / (poles_[i_ - 1 + ((*ldgnum_)) * ((1))] + dj_);
          }
        }
        for (i_ = j_ + 1; i_ <= (*k_); (i_)++) {
          if ((z_[i_ - 1] == 0.0) || (poles_[i_ - 1 + ((*ldgnum_)) * ((1))] == 0.0)) {
            work_[i_ - 1] = 0.0;
          }
          else {
            work_[i_ - 1] = poles_[i_ - 1 + ((*ldgnum_)) * ((1))] * z_[i_ - 1] / (_dlamc3 (&poles_[i_ - 1 + ((*ldgnum_)) * ((1))], 
            &dsigjp_) + difrj_) / (poles_[i_ - 1 + ((*ldgnum_)) * ((1))] + dj_);
          }
        }
        work_[0] = -1.0;
        temp_ = _dnrm2 (k_, work_, &_k1);
        (void) _dgemv (_dc_25, k_, nrhs_, ($2_ = 1.0, &$2_), bx_, ldbx_, work_, &_k1, ($3_ = 0.0, &$3_), &b_[j_ - 1 + ((*ldb_)) 
        * ((0))], ldb_);
        (void) _dlascl (_dc_9, &_k0, &_k0, &temp_, ($4_ = 1.0, &$4_), &_k1, nrhs_, &b_[j_ - 1 + ((*ldb_)) * ((0))], ldb_, 
        info_);
      }
    }
    if ((*k_) < _max (m_, n_)) {
      (void) _dlacpy (_dc_7, ($5_ = n_ - (*k_), &$5_), nrhs_, &bx_[(*k_) + 1 - 1 + ((*ldbx_)) * ((0))], ldbx_, &b_[(*k_) + 1 
      - 1 + ((*ldb_)) * ((0))], ldb_);
    }
  }
  else {
    if ((*k_) == 1) {
      (void) _dcopy (nrhs_, b_, ldb_, bx_, ldbx_);
    }
    else {
      for (j_ = 1; j_ <= (*k_); (j_)++) {
        dsigj_ = poles_[j_ - 1 + ((*ldgnum_)) * ((1))];
        if (z_[j_ - 1] == 0.0) {
          work_[j_ - 1] = 0.0;
        }
        else {
          work_[j_ - 1] = -z_[j_ - 1] / difl_[j_ - 1] / (dsigj_ + poles_[j_ - 1 + ((*ldgnum_)) * ((0))]) / difr_[j_ - 1 + 
          ((*ldgnum_)) * ((1))];
        }
        for (i_ = 1; i_ <= j_ - 1; (i_)++) {
          if (z_[j_ - 1] == 0.0) {
            work_[i_ - 1] = 0.0;
          }
          else {
            work_[i_ - 1] = z_[j_ - 1] / (_dlamc3 (&dsigj_, ($6_ = -poles_[i_ + 1 - 1 + ((*ldgnum_)) * ((1))], &$6_)) - difr_[i_ - 
            1 + ((*ldgnum_)) * ((0))]) / (dsigj_ + poles_[i_ - 1 + ((*ldgnum_)) * ((0))]) / difr_[i_ - 1 + ((*ldgnum_)) * ((1))];
          }
        }
        for (i_ = j_ + 1; i_ <= (*k_); (i_)++) {
          if (z_[j_ - 1] == 0.0) {
            work_[i_ - 1] = 0.0;
          }
          else {
            work_[i_ - 1] = z_[j_ - 1] / (_dlamc3 (&dsigj_, ($7_ = -poles_[i_ - 1 + ((*ldgnum_)) * ((1))], &$7_)) - difl_[i_ - 1]) 
            / (dsigj_ + poles_[i_ - 1 + ((*ldgnum_)) * ((0))]) / difr_[i_ - 1 + ((*ldgnum_)) * ((1))];
          }
        }
        (void) _dgemv (_dc_25, k_, nrhs_, ($8_ = 1.0, &$8_), b_, ldb_, work_, &_k1, ($9_ = 0.0, &$9_), &bx_[j_ - 1 + ((*ldbx_)) 
        * ((0))], ldbx_);
      }
    }
    if ((*sqre_) == 1) {
      (void) _dcopy (nrhs_, &b_[m_ - 1 + ((*ldb_)) * ((0))], ldb_, &bx_[m_ - 1 + ((*ldbx_)) * ((0))], ldbx_);
      (void) _drot (nrhs_, &bx_[0 + ((*ldbx_)) * ((0))], ldbx_, &bx_[m_ - 1 + ((*ldbx_)) * ((0))], ldbx_, c_, s_);
    }
    if ((*k_) < _max (m_, n_)) {
      (void) _dlacpy (_dc_7, ($10_ = n_ - (*k_), &$10_), nrhs_, &b_[(*k_) + 1 - 1 + ((*ldb_)) * ((0))], ldb_, &bx_[(*k_) + 1 
      - 1 + ((*ldbx_)) * ((0))], ldbx_);
    }
    (void) _dcopy (nrhs_, &bx_[0 + ((*ldbx_)) * ((0))], ldbx_, &b_[nlp1_ - 1 + ((*ldb_)) * ((0))], ldb_);
    if ((*sqre_) == 1) {
      (void) _dcopy (nrhs_, &bx_[m_ - 1 + ((*ldbx_)) * ((0))], ldbx_, &b_[m_ - 1 + ((*ldb_)) * ((0))], ldb_);
    }
    for (i_ = 2; i_ <= n_; (i_)++) {
      (void) _dcopy (nrhs_, &bx_[i_ - 1 + ((*ldbx_)) * ((0))], ldbx_, &b_[perm_[i_ - 1] - 1 + ((*ldb_)) * ((0))], ldb_);
    }
    for (i_ = (*givptr_); i_ >= 1; (i_)--) {
      (void) _drot (nrhs_, &b_[givcol_[i_ - 1 + ((*ldgcol_)) * ((1))] - 1 + ((*ldb_)) * ((0))], ldb_, &b_[givcol_[i_ - 1 + 
      ((*ldgcol_)) * ((0))] - 1 + ((*ldb_)) * ((0))], ldb_, &givnum_[i_ - 1 + ((*ldgnum_)) * ((1))], ($11_ = -givnum_[i_ - 1 
      + ((*ldgnum_)) * ((0))], &$11_));
    }
  }
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _dlalsa (int_4 _p_ icompq_, int_4 _p_ smlsiz_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ b_, int_4 _p_ ldb_, 
real_8 _p_ bx_, int_4 _p_ ldbx_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ k_, real_8 _p_ difl_, real_8 
_p_ difr_, real_8 _p_ z_, real_8 _p_ poles_, int_4 _p_ givptr_, int_4 _p_ givcol_, int_4 _p_ ldgcol_, int_4 _p_ perm_, 
real_8 _p_ givnum_, real_8 _p_ c_, real_8 _p_ s_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_)
{
  static int_4 i_, i1_, ic_, im1_, inode_, j_, lf_, ll_, lvl_, lvl2_, nd_, ndb1_, ndiml_, ndimr_, nl_, nlf_, nlp1_, nlvl_
  , nr_, nrf_, nrp1_, sqre_;
  int_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern int_4 _dcopy ();
  extern int_4 _dgemm ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if (((*icompq_) < 0) || ((*icompq_) > 1)) {
    (*info_) = -1;
  }
  else if ((*smlsiz_) < 3) {
    (*info_) = -2;
  }
  else if ((*n_) < (*smlsiz_)) {
    (*info_) = -3;
  }
  else if ((*nrhs_) < 1) {
    (*info_) = -4;
  }
  else if ((*ldb_) < (*n_)) {
    (*info_) = -6;
  }
  else if ((*ldbx_) < (*n_)) {
    (*info_) = -8;
  }
  else if ((*ldu_) < (*n_)) {
    (*info_) = -10;
  }
  else if ((*ldgcol_) < (*n_)) {
    (*info_) = -19;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_69, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  inode_ = 1;
  ndiml_ = inode_ + (*n_);
  ndimr_ = ndiml_ + (*n_);
  (void) _dlasdt (n_, &nlvl_, &nd_, &iwork_[inode_ - 1], &iwork_[ndiml_ - 1], &iwork_[ndimr_ - 1], smlsiz_);
  if ((*icompq_) == 1) {
    goto _l50;
  }
  ndb1_ = (nd_ + 1) / 2;
  for (i_ = ndb1_; i_ <= nd_; (i_)++) {
    i1_ = i_ - 1;
    ic_ = iwork_[inode_ + i1_ - 1];
    nl_ = iwork_[ndiml_ + i1_ - 1];
    nr_ = iwork_[ndimr_ + i1_ - 1];
    nlf_ = ic_ - nl_;
    nrf_ = ic_ + 1;
    (void) _dgemm (_dc_25, _dc_2, &nl_, nrhs_, &nl_, ($1_ = 1.0, &$1_), &u_[nlf_ - 1 + ((*ldu_)) * ((0))], ldu_, &b_[nlf_ - 
    1 + ((*ldb_)) * ((0))], ldb_, ($2_ = 0.0, &$2_), &bx_[nlf_ - 1 + ((*ldbx_)) * ((0))], ldbx_);
    (void) _dgemm (_dc_25, _dc_2, &nr_, nrhs_, &nr_, ($3_ = 1.0, &$3_), &u_[nrf_ - 1 + ((*ldu_)) * ((0))], ldu_, &b_[nrf_ - 
    1 + ((*ldb_)) * ((0))], ldb_, ($4_ = 0.0, &$4_), &bx_[nrf_ - 1 + ((*ldbx_)) * ((0))], ldbx_);
  }
  for (i_ = 1; i_ <= nd_; (i_)++) {
    ic_ = iwork_[inode_ + i_ - 1 - 1];
    (void) _dcopy (nrhs_, &b_[ic_ - 1 + ((*ldb_)) * ((0))], ldb_, &bx_[ic_ - 1 + ((*ldbx_)) * ((0))], ldbx_);
  }
  j_ = _up_int_4 (2, nlvl_);
  sqre_ = 0;
  for (lvl_ = nlvl_; lvl_ >= 1; (lvl_)--) {
    lvl2_ = 2 * lvl_ - 1;
    if (lvl_ == 1) {
      lf_ = 1;
      ll_ = 1;
    }
    else {
      lf_ = _up_int_4 (2, (lvl_ - 1));
      ll_ = 2 * lf_ - 1;
    }
    for (i_ = lf_; i_ <= ll_; (i_)++) {
      im1_ = i_ - 1;
      ic_ = iwork_[inode_ + im1_ - 1];
      nl_ = iwork_[ndiml_ + im1_ - 1];
      nr_ = iwork_[ndimr_ + im1_ - 1];
      nlf_ = ic_ - nl_;
      nrf_ = ic_ + 1;
      j_ = j_ - 1;
      (void) _dlals0 (icompq_, &nl_, &nr_, &sqre_, nrhs_, &bx_[nlf_ - 1 + ((*ldbx_)) * ((0))], ldbx_, &b_[nlf_ - 1 + 
      ((*ldb_)) * ((0))], ldb_, &perm_[nlf_ - 1 + ((*ldgcol_)) * ((lvl_ - 1))], &givptr_[j_ - 1], &givcol_[nlf_ - 1 + 
      ((*ldgcol_)) * ((lvl2_ - 1))], ldgcol_, &givnum_[nlf_ - 1 + ((*ldu_)) * ((lvl2_ - 1))], ldu_, &poles_[nlf_ - 1 + 
      ((*ldu_)) * ((lvl2_ - 1))], &difl_[nlf_ - 1 + ((*ldu_)) * ((lvl_ - 1))], &difr_[nlf_ - 1 + ((*ldu_)) * ((lvl2_ - 1))], 
      &z_[nlf_ - 1 + ((*ldu_)) * ((lvl_ - 1))], &k_[j_ - 1], &c_[j_ - 1], &s_[j_ - 1], work_, info_);
    }
  }
  goto _l90;
  _l50:;
  j_ = 0;
  for (lvl_ = 1; lvl_ <= nlvl_; (lvl_)++) {
    lvl2_ = 2 * lvl_ - 1;
    if (lvl_ == 1) {
      lf_ = 1;
      ll_ = 1;
    }
    else {
      lf_ = _up_int_4 (2, (lvl_ - 1));
      ll_ = 2 * lf_ - 1;
    }
    for (i_ = ll_; i_ >= lf_; (i_)--) {
      im1_ = i_ - 1;
      ic_ = iwork_[inode_ + im1_ - 1];
      nl_ = iwork_[ndiml_ + im1_ - 1];
      nr_ = iwork_[ndimr_ + im1_ - 1];
      nlf_ = ic_ - nl_;
      nrf_ = ic_ + 1;
      if (i_ == ll_) {
        sqre_ = 0;
      }
      else {
        sqre_ = 1;
      }
      j_ = j_ + 1;
      (void) _dlals0 (icompq_, &nl_, &nr_, &sqre_, nrhs_, &b_[nlf_ - 1 + ((*ldb_)) * ((0))], ldb_, &bx_[nlf_ - 1 + ((*ldbx_)) 
      * ((0))], ldbx_, &perm_[nlf_ - 1 + ((*ldgcol_)) * ((lvl_ - 1))], &givptr_[j_ - 1], &givcol_[nlf_ - 1 + ((*ldgcol_)) * 
      ((lvl2_ - 1))], ldgcol_, &givnum_[nlf_ - 1 + ((*ldu_)) * ((lvl2_ - 1))], ldu_, &poles_[nlf_ - 1 + ((*ldu_)) * ((lvl2_ - 
      1))], &difl_[nlf_ - 1 + ((*ldu_)) * ((lvl_ - 1))], &difr_[nlf_ - 1 + ((*ldu_)) * ((lvl2_ - 1))], &z_[nlf_ - 1 + 
      ((*ldu_)) * ((lvl_ - 1))], &k_[j_ - 1], &c_[j_ - 1], &s_[j_ - 1], work_, info_);
    }
  }
  ndb1_ = (nd_ + 1) / 2;
  for (i_ = ndb1_; i_ <= nd_; (i_)++) {
    i1_ = i_ - 1;
    ic_ = iwork_[inode_ + i1_ - 1];
    nl_ = iwork_[ndiml_ + i1_ - 1];
    nr_ = iwork_[ndimr_ + i1_ - 1];
    nlp1_ = nl_ + 1;
    if (i_ == nd_) {
      nrp1_ = nr_;
    }
    else {
      nrp1_ = nr_ + 1;
    }
    nlf_ = ic_ - nl_;
    nrf_ = ic_ + 1;
    (void) _dgemm (_dc_25, _dc_2, &nlp1_, nrhs_, &nlp1_, ($5_ = 1.0, &$5_), &vt_[nlf_ - 1 + ((*ldu_)) * ((0))], ldu_, 
    &b_[nlf_ - 1 + ((*ldb_)) * ((0))], ldb_, ($6_ = 0.0, &$6_), &bx_[nlf_ - 1 + ((*ldbx_)) * ((0))], ldbx_);
    (void) _dgemm (_dc_25, _dc_2, &nrp1_, nrhs_, &nrp1_, ($7_ = 1.0, &$7_), &vt_[nrf_ - 1 + ((*ldu_)) * ((0))], ldu_, 
    &b_[nrf_ - 1 + ((*ldb_)) * ((0))], ldb_, ($8_ = 0.0, &$8_), &bx_[nrf_ - 1 + ((*ldbx_)) * ((0))], ldbx_);
  }
  _l90:;
  _l0:;
  __calls[27].calls++;
  return 0;
}

int_4 _dlalsd (char _p_ uplo_, int_4 _p_ smlsiz_, int_4 _p_ n_, int_4 _p_ nrhs_, real_8 _p_ d_, real_8 _p_ e_, real_8 
_p_ b_, int_4 _p_ ldb_, real_8 _p_ rcond_, int_4 _p_ rank_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_)
{
  static int_4 bx_, bxst_, c_, difl_, difr_, givcol_, givnum_, givptr_, i_, icmpq1_, icmpq2_, iwk_, j_, k_, nlvl_, nm1_, 
  nsize_, nsub_, nwork_, perm_, poles_, s_, sizei_, smlszp_, sqre_, st_, st1_, u_, vt_, z_;
  static real_8 cs_, eps_, orgnrm_, r_, rcnd_, sn_, tol_;
  int_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, $20_, 
  $21_, $22_, $23_, $24_, $25_;
  extern int_4 _idamax ();
  extern real_8 _dlamch ();
  extern int_4 _dcopy ();
  extern int_4 _dgemm ();
  extern int_4 _drot ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -3;
  }
  else if ((*nrhs_) < 1) {
    (*info_) = -4;
  }
  else if (((*ldb_) < 1) || ((*ldb_) < (*n_))) {
    (*info_) = -8;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_70, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  eps_ = _dlamch (_dc_10);
  if (((*rcond_) <= 0.0) || ((*rcond_) >= 1.0)) {
    rcnd_ = eps_;
  }
  else {
    rcnd_ = (*rcond_);
  }
  (*rank_) = 0;
  if ((*n_) == 0) {
    goto _l0;
  }
  else if ((*n_) == 1) {
    if (d_[0] == 0.0) {
      (void) _dlaset (_dc_7, &_k1, nrhs_, ($1_ = 0.0, &$1_), ($2_ = 0.0, &$2_), b_, ldb_);
    }
    else {
      (*rank_) = 1;
      (void) _dlascl (_dc_9, &_k0, &_k0, &d_[0], ($3_ = 1.0, &$3_), &_k1, nrhs_, b_, ldb_, info_);
      d_[0] = _abs (d_[0]);
    }
    goto _l0;
  }
  if ((strcmp (uplo_, _dc_1) == 0)) {
    for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
      (void) _dlartg (&d_[i_ - 1], &e_[i_ - 1], &cs_, &sn_, &r_);
      d_[i_ - 1] = r_;
      e_[i_ - 1] = sn_ * d_[i_ + 1 - 1];
      d_[i_ + 1 - 1] = cs_ * d_[i_ + 1 - 1];
      if ((*nrhs_) == 1) {
        (void) _drot (&_k1, &b_[i_ - 1 + ((*ldb_)) * ((0))], &_k1, &b_[i_ + 1 - 1 + ((*ldb_)) * ((0))], &_k1, &cs_, &sn_);
      }
      else {
        work_[i_ * 2 - 1 - 1] = cs_;
        work_[i_ * 2 - 1] = sn_;
      }
    }
    if ((*nrhs_) > 1) {
      for (i_ = 1; i_ <= (*nrhs_); (i_)++) {
        for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
          cs_ = work_[j_ * 2 - 1 - 1];
          sn_ = work_[j_ * 2 - 1];
          (void) _drot (&_k1, &b_[j_ - 1 + ((*ldb_)) * ((i_ - 1))], &_k1, &b_[j_ + 1 - 1 + ((*ldb_)) * ((i_ - 1))], &_k1, &cs_, 
          &sn_);
        }
      }
    }
  }
  nm1_ = (*n_) - 1;
  orgnrm_ = _dlanst (_dc_8, n_, d_, e_);
  if (orgnrm_ == 0.0) {
    (void) _dlaset (_dc_7, n_, nrhs_, ($4_ = 0.0, &$4_), ($5_ = 0.0, &$5_), b_, ldb_);
    goto _l0;
  }
  (void) _dlascl (_dc_9, &_k0, &_k0, &orgnrm_, ($6_ = 1.0, &$6_), n_, &_k1, d_, n_, info_);
  (void) _dlascl (_dc_9, &_k0, &_k0, &orgnrm_, ($7_ = 1.0, &$7_), &nm1_, &_k1, e_, &nm1_, info_);
  if ((*n_) <= (*smlsiz_)) {
    nwork_ = 1 + (*n_) * (*n_);
    (void) _dlaset (_dc_7, n_, n_, ($8_ = 0.0, &$8_), ($9_ = 1.0, &$9_), work_, n_);
    (void) _dlasdq (_dc_0, &_k0, n_, n_, &_k0, nrhs_, d_, e_, work_, n_, work_, n_, b_, ldb_, &work_[nwork_ - 1], info_);
    if ((*info_) != 0) {
      goto _l0;
    }
    tol_ = rcnd_ * _abs (d_[_idamax (n_, d_, &_k1) - 1]);
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      if (d_[i_ - 1] <= tol_) {
        (void) _dlaset (_dc_7, &_k1, nrhs_, ($10_ = 0.0, &$10_), ($11_ = 0.0, &$11_), &b_[i_ - 1 + ((*ldb_)) * ((0))], ldb_);
      }
      else {
        (void) _dlascl (_dc_9, &_k0, &_k0, &d_[i_ - 1], ($12_ = 1.0, &$12_), &_k1, nrhs_, &b_[i_ - 1 + ((*ldb_)) * ((0))], 
        ldb_, info_);
        (*rank_) = (*rank_) + 1;
      }
    }
    (void) _dgemm (_dc_25, _dc_2, n_, nrhs_, n_, ($13_ = 1.0, &$13_), work_, n_, b_, ldb_, ($14_ = 0.0, &$14_), 
    &work_[nwork_ - 1], n_);
    (void) _dlacpy (_dc_7, n_, nrhs_, &work_[nwork_ - 1], n_, b_, ldb_);
    (void) _dlascl (_dc_9, &_k0, &_k0, ($15_ = 1.0, &$15_), &orgnrm_, n_, &_k1, d_, n_, info_);
    (void) _dlasrt (_dc_71, n_, d_, info_);
    (void) _dlascl (_dc_9, &_k0, &_k0, &orgnrm_, ($16_ = 1.0, &$16_), n_, nrhs_, b_, ldb_, info_);
    goto _l0;
  }
  nlvl_ = (int_4) (_aintd (log ((real_8) ((*n_)) / (real_8) ((*smlsiz_) + 1)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1)) + 1;
  smlszp_ = (*smlsiz_) + 1;
  u_ = 1;
  vt_ = 1 + (*smlsiz_) * (*n_);
  difl_ = vt_ + smlszp_ * (*n_);
  difr_ = difl_ + nlvl_ * (*n_);
  z_ = difr_ + nlvl_ * (*n_) * 2;
  c_ = z_ + nlvl_ * (*n_);
  s_ = c_ + (*n_);
  poles_ = s_ + (*n_);
  givnum_ = poles_ + 2 * nlvl_ * (*n_);
  bx_ = givnum_ + 2 * nlvl_ * (*n_);
  nwork_ = bx_ + (*n_) * (*nrhs_);
  sizei_ = 1 + (*n_);
  k_ = sizei_ + (*n_);
  givptr_ = k_ + (*n_);
  perm_ = givptr_ + (*n_);
  givcol_ = perm_ + nlvl_ * (*n_);
  iwk_ = givcol_ + nlvl_ * (*n_) * 2;
  st_ = 1;
  sqre_ = 0;
  icmpq1_ = 1;
  icmpq2_ = 0;
  nsub_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_abs (d_[i_ - 1]) < eps_) {
      d_[i_ - 1] = _sign (eps_, d_[i_ - 1]);
    }
  }
  for (i_ = 1; i_ <= nm1_; (i_)++) {
    if ((_abs (e_[i_ - 1]) < eps_) || (i_ == nm1_)) {
      nsub_ = nsub_ + 1;
      iwork_[nsub_ - 1] = st_;
      if (i_ < nm1_) {
        nsize_ = i_ - st_ + 1;
        iwork_[sizei_ + nsub_ - 1 - 1] = nsize_;
      }
      else if (_abs (e_[i_ - 1]) >= eps_) {
        nsize_ = (*n_) - st_ + 1;
        iwork_[sizei_ + nsub_ - 1 - 1] = nsize_;
      }
      else {
        nsize_ = i_ - st_ + 1;
        iwork_[sizei_ + nsub_ - 1 - 1] = nsize_;
        nsub_ = nsub_ + 1;
        iwork_[nsub_ - 1] = (*n_);
        iwork_[sizei_ + nsub_ - 1 - 1] = 1;
        (void) _dcopy (nrhs_, &b_[(*n_) - 1 + ((*ldb_)) * ((0))], ldb_, &work_[bx_ + nm1_ - 1], n_);
      }
      st1_ = st_ - 1;
      if (nsize_ == 1) {
        (void) _dcopy (nrhs_, &b_[st_ - 1 + ((*ldb_)) * ((0))], ldb_, &work_[bx_ + st1_ - 1], n_);
      }
      else if (nsize_ <= (*smlsiz_)) {
        (void) _dlaset (_dc_7, &nsize_, &nsize_, ($17_ = 0.0, &$17_), ($18_ = 1.0, &$18_), &work_[vt_ + st1_ - 1], n_);
        (void) _dlasdq (_dc_0, &_k0, &nsize_, &nsize_, &_k0, nrhs_, &d_[st_ - 1], &e_[st_ - 1], &work_[vt_ + st1_ - 1], n_, 
        &work_[nwork_ - 1], n_, &b_[st_ - 1 + ((*ldb_)) * ((0))], ldb_, &work_[nwork_ - 1], info_);
        if ((*info_) != 0) {
          goto _l0;
        }
        (void) _dlacpy (_dc_7, &nsize_, nrhs_, &b_[st_ - 1 + ((*ldb_)) * ((0))], ldb_, &work_[bx_ + st1_ - 1], n_);
      }
      else {
        (void) _dlasda (&icmpq1_, smlsiz_, &nsize_, &sqre_, &d_[st_ - 1], &e_[st_ - 1], &work_[u_ + st1_ - 1], n_, &work_[vt_ + 
        st1_ - 1], &iwork_[k_ + st1_ - 1], &work_[difl_ + st1_ - 1], &work_[difr_ + st1_ - 1], &work_[z_ + st1_ - 1], 
        &work_[poles_ + st1_ - 1], &iwork_[givptr_ + st1_ - 1], &iwork_[givcol_ + st1_ - 1], n_, &iwork_[perm_ + st1_ - 1], 
        &work_[givnum_ + st1_ - 1], &work_[c_ + st1_ - 1], &work_[s_ + st1_ - 1], &work_[nwork_ - 1], &iwork_[iwk_ - 1], info_)
        ;
        if ((*info_) != 0) {
          goto _l0;
        }
        bxst_ = bx_ + st1_;
        (void) _dlalsa (&icmpq2_, smlsiz_, &nsize_, nrhs_, &b_[st_ - 1 + ((*ldb_)) * ((0))], ldb_, &work_[bxst_ - 1], n_, 
        &work_[u_ + st1_ - 1], n_, &work_[vt_ + st1_ - 1], &iwork_[k_ + st1_ - 1], &work_[difl_ + st1_ - 1], &work_[difr_ + 
        st1_ - 1], &work_[z_ + st1_ - 1], &work_[poles_ + st1_ - 1], &iwork_[givptr_ + st1_ - 1], &iwork_[givcol_ + st1_ - 1], 
        n_, &iwork_[perm_ + st1_ - 1], &work_[givnum_ + st1_ - 1], &work_[c_ + st1_ - 1], &work_[s_ + st1_ - 1], &work_[nwork_ 
        - 1], &iwork_[iwk_ - 1], info_);
        if ((*info_) != 0) {
          goto _l0;
        }
      }
      st_ = i_ + 1;
    }
  }
  tol_ = rcnd_ * _abs (d_[_idamax (n_, d_, &_k1) - 1]);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (_abs (d_[i_ - 1]) <= tol_) {
      (void) _dlaset (_dc_7, &_k1, nrhs_, ($19_ = 0.0, &$19_), ($20_ = 0.0, &$20_), &work_[bx_ + i_ - 1 - 1], n_);
    }
    else {
      (*rank_) = (*rank_) + 1;
      (void) _dlascl (_dc_9, &_k0, &_k0, &d_[i_ - 1], ($21_ = 1.0, &$21_), &_k1, nrhs_, &work_[bx_ + i_ - 1 - 1], n_, info_)
      ;
    }
    d_[i_ - 1] = _abs (d_[i_ - 1]);
  }
  icmpq2_ = 1;
  for (i_ = 1; i_ <= nsub_; (i_)++) {
    st_ = iwork_[i_ - 1];
    st1_ = st_ - 1;
    nsize_ = iwork_[sizei_ + i_ - 1 - 1];
    bxst_ = bx_ + st1_;
    if (nsize_ == 1) {
      (void) _dcopy (nrhs_, &work_[bxst_ - 1], n_, &b_[st_ - 1 + ((*ldb_)) * ((0))], ldb_);
    }
    else if (nsize_ <= (*smlsiz_)) {
      (void) _dgemm (_dc_25, _dc_2, &nsize_, nrhs_, &nsize_, ($22_ = 1.0, &$22_), &work_[vt_ + st1_ - 1], n_, &work_[bxst_ - 
      1], n_, ($23_ = 0.0, &$23_), &b_[st_ - 1 + ((*ldb_)) * ((0))], ldb_);
    }
    else {
      (void) _dlalsa (&icmpq2_, smlsiz_, &nsize_, nrhs_, &work_[bxst_ - 1], n_, &b_[st_ - 1 + ((*ldb_)) * ((0))], ldb_, 
      &work_[u_ + st1_ - 1], n_, &work_[vt_ + st1_ - 1], &iwork_[k_ + st1_ - 1], &work_[difl_ + st1_ - 1], &work_[difr_ + 
      st1_ - 1], &work_[z_ + st1_ - 1], &work_[poles_ + st1_ - 1], &iwork_[givptr_ + st1_ - 1], &iwork_[givcol_ + st1_ - 1], 
      n_, &iwork_[perm_ + st1_ - 1], &work_[givnum_ + st1_ - 1], &work_[c_ + st1_ - 1], &work_[s_ + st1_ - 1], &work_[nwork_ 
      - 1], &iwork_[iwk_ - 1], info_);
      if ((*info_) != 0) {
        goto _l0;
      }
    }
  }
  (void) _dlascl (_dc_9, &_k0, &_k0, ($24_ = 1.0, &$24_), &orgnrm_, n_, &_k1, d_, n_, info_);
  (void) _dlasrt (_dc_71, n_, d_, info_);
  (void) _dlascl (_dc_9, &_k0, &_k0, &orgnrm_, ($25_ = 1.0, &$25_), n_, nrhs_, b_, ldb_, info_);
  _l0:;
  __calls[28].calls++;
  return 0;
}

int_4 _dlamrg (int_4 _p_ n1_, int_4 _p_ n2_, real_8 _p_ a_, int_4 _p_ dtrd1_, int_4 _p_ dtrd2_, int_4 _p_ index_)
{
  static int_4 i_, ind1_, ind2_, n1sv_, n2sv_;
  n1sv_ = (*n1_);
  n2sv_ = (*n2_);
  if ((*dtrd1_) > 0) {
    ind1_ = 1;
  }
  else {
    ind1_ = (*n1_);
  }
  if ((*dtrd2_) > 0) {
    ind2_ = 1 + (*n1_);
  }
  else {
    ind2_ = (*n1_) + (*n2_);
  }
  i_ = 1;
  _l10:;
  if (n1sv_ > 0 && n2sv_ > 0) {
    if (a_[ind1_ - 1] <= a_[ind2_ - 1]) {
      index_[i_ - 1] = ind1_;
      i_ = i_ + 1;
      ind1_ = ind1_ + (*dtrd1_);
      n1sv_ = n1sv_ - 1;
    }
    else {
      index_[i_ - 1] = ind2_;
      i_ = i_ + 1;
      ind2_ = ind2_ + (*dtrd2_);
      n2sv_ = n2sv_ - 1;
    }
    goto _l10;
  }
  if (n1sv_ == 0) {
    for (n1sv_ = 1; n1sv_ <= n2sv_; (n1sv_)++) {
      index_[i_ - 1] = ind2_;
      i_ = i_ + 1;
      ind2_ = ind2_ + (*dtrd2_);
    }
  }
  else {
    for (n2sv_ = 1; n2sv_ <= n1sv_; (n2sv_)++) {
      index_[i_ - 1] = ind1_;
      i_ = i_ + 1;
      ind1_ = ind1_ + (*dtrd1_);
    }
  }
  __calls[29].calls++;
  return 0;
}

real_8 _dlange (char _p_ norm_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ work_)
{
  static int_4 i_, j_;
  static real_8 sum_, value_, temp_, ssq_[2], colssq_[2];
  real_8 dlange_;
  extern logical_4 _lsame ();
  if (_min ((*m_), (*n_)) == 0) {
    value_ = 0.0;
  }
  else if (_lsame (norm_, _dc_8)) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        temp_ = _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
        if (value_ < temp_ || _disnan (&temp_)) {
          value_ = temp_;
        }
      }
    }
  }
  else if ((_lsame (norm_, _dc_30)) || ((strcmp (norm_, _dc_72) == 0))) {
    value_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = 0.0;
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        sum_ = sum_ + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
      if (value_ < sum_ || _disnan (&sum_)) {
        value_ = sum_;
      }
    }
  }
  else if (_lsame (norm_, _dc_4)) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        work_[i_ - 1] = work_[i_ - 1] + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      }
    }
    value_ = 0.0;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      temp_ = work_[i_ - 1];
      if (value_ < temp_ || _disnan (&temp_)) {
        value_ = temp_;
      }
    }
  }
  else if ((_lsame (norm_, _dc_16)) || (_lsame (norm_, _dc_24))) {
    ssq_[0] = 0.0;
    ssq_[1] = 1.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      colssq_[0] = 0.0;
      colssq_[1] = 1.0;
      (void) _dlassq (m_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &colssq_[0], &colssq_[1]);
      (void) _dcombssq (ssq_, colssq_);
    }
    value_ = ssq_[0] * sqrt (ssq_[1]);
  }
  dlange_ = value_;
  __calls[30].calls++;
  return dlange_;
}

real_8 _dlanst (char _p_ norm_, int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_)
{
  static int_4 i_;
  static real_8 anorm_, scale_, sum_;
  int_4 $0_;
  real_8 dlanst_;
  extern logical_4 _lsame ();
  if ((*n_) <= 0) {
    anorm_ = 0.0;
  }
  else if (_lsame (norm_, _dc_8)) {
    anorm_ = _abs (d_[(*n_) - 1]);
    for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
      sum_ = _abs (d_[i_ - 1]);
      if (anorm_ < sum_ || _disnan (&sum_)) {
        anorm_ = sum_;
      }
      sum_ = _abs (e_[i_ - 1]);
      if (anorm_ < sum_ || _disnan (&sum_)) {
        anorm_ = sum_;
      }
    }
  }
  else if (_lsame (norm_, _dc_30) || (strcmp (norm_, _dc_72) == 0) || _lsame (norm_, _dc_4)) {
    if ((*n_) == 1) {
      anorm_ = _abs (d_[0]);
    }
    else {
      anorm_ = _abs (d_[0]) + _abs (e_[0]);
      sum_ = _abs (e_[(*n_) - 1 - 1]) + _abs (d_[(*n_) - 1]);
      if (anorm_ < sum_ || _disnan (&sum_)) {
        anorm_ = sum_;
      }
      for (i_ = 2; i_ <= (*n_) - 1; (i_)++) {
        sum_ = _abs (d_[i_ - 1]) + _abs (e_[i_ - 1]) + _abs (e_[i_ - 1 - 1]);
        if (anorm_ < sum_ || _disnan (&sum_)) {
          anorm_ = sum_;
        }
      }
    }
  }
  else if ((_lsame (norm_, _dc_16)) || (_lsame (norm_, _dc_24))) {
    scale_ = 0.0;
    sum_ = 1.0;
    if ((*n_) > 1) {
      (void) _dlassq (($0_ = (*n_) - 1, &$0_), e_, &_k1, &scale_, &sum_);
      sum_ = 2 * sum_;
    }
    (void) _dlassq (n_, d_, &_k1, &scale_, &sum_);
    anorm_ = scale_ * sqrt (sum_);
  }
  dlanst_ = anorm_;
  __calls[31].calls++;
  return dlanst_;
}

int_4 _dlapmt (logical_4 _p_ forwrd_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ k_)
{
  static int_4 i_, ii_, in_, j_;
  static real_8 temp_;
  if ((*n_) <= 1) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    k_[i_ - 1] = -k_[i_ - 1];
  }
  if ((*forwrd_)) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      if (k_[i_ - 1] > 0) {
        goto _l40;
      }
      j_ = i_;
      k_[j_ - 1] = -k_[j_ - 1];
      in_ = k_[j_ - 1];
      _l20:;
      if (k_[in_ - 1] > 0) {
        goto _l40;
      }
      for (ii_ = 1; ii_ <= (*m_); (ii_)++) {
        temp_ = x_[ii_ - 1 + ((*ldx_)) * ((j_ - 1))];
        x_[ii_ - 1 + ((*ldx_)) * ((j_ - 1))] = x_[ii_ - 1 + ((*ldx_)) * ((in_ - 1))];
        x_[ii_ - 1 + ((*ldx_)) * ((in_ - 1))] = temp_;
      }
      k_[in_ - 1] = -k_[in_ - 1];
      j_ = in_;
      in_ = k_[in_ - 1];
      goto _l20;
      _l40:;
    }
  }
  else {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      if (k_[i_ - 1] > 0) {
        goto _l80;
      }
      k_[i_ - 1] = -k_[i_ - 1];
      j_ = k_[i_ - 1];
      _l60:;
      if (j_ == i_) {
        goto _l80;
      }
      for (ii_ = 1; ii_ <= (*m_); (ii_)++) {
        temp_ = x_[ii_ - 1 + ((*ldx_)) * ((i_ - 1))];
        x_[ii_ - 1 + ((*ldx_)) * ((i_ - 1))] = x_[ii_ - 1 + ((*ldx_)) * ((j_ - 1))];
        x_[ii_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
      }
      k_[j_ - 1] = -k_[j_ - 1];
      j_ = k_[j_ - 1];
      goto _l60;
      _l80:;
    }
  }
  _l0:;
  __calls[32].calls++;
  return 0;
}

real_8 _dlapy2 (real_8 _p_ x_, real_8 _p_ y_)
{
  static logical_4 x_is_nan_, y_is_nan_;
  static real_8 w_, xabs_, yabs_, z_;
  real_8 $0_;
  real_8 dlapy2_;
  x_is_nan_ = _disnan (x_);
  y_is_nan_ = _disnan (y_);
  if (x_is_nan_) {
    dlapy2_ = (*x_);
  }
  if (y_is_nan_) {
    dlapy2_ = (*y_);
  }
  if (! ((x_is_nan_ || y_is_nan_))) {
    xabs_ = _abs ((*x_));
    yabs_ = _abs ((*y_));
    w_ = _max (xabs_, yabs_);
    z_ = _min (xabs_, yabs_);
    if (z_ == 0.0) {
      dlapy2_ = w_;
    }
    else {
      dlapy2_ = w_ * sqrt (1.0 + ($0_ = (z_ / w_), $0_ * $0_));
    }
  }
  __calls[33].calls++;
  return dlapy2_;
}

int_4 _dlaqp2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ offset_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ jpvt_, real_8 
_p_ tau_, real_8 _p_ vn1_, real_8 _p_ vn2_, real_8 _p_ work_)
{
  static int_4 i_, itemp_, j_, mn_, offpi_, pvt_;
  static real_8 aii_, temp_, temp2_, tol3z_;
  int_4 $0_, $1_, $2_, $3_, $6_;
  real_8 $4_, $5_;
  extern int_4 _dswap ();
  extern int_4 _idamax ();
  extern real_8 _dlamch ();
  extern real_8 _dnrm2 ();
  mn_ = _min ((*m_) - (*offset_), (*n_));
  tol3z_ = sqrt (_dlamch (_dc_10));
  for (i_ = 1; i_ <= mn_; (i_)++) {
    offpi_ = (*offset_) + i_;
    pvt_ = (i_ - 1) + _idamax (($0_ = (*n_) - i_ + 1, &$0_), &vn1_[i_ - 1], &_k1);
    if (pvt_ != i_) {
      (void) _dswap (m_, &a_[0 + ((*lda_)) * ((pvt_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((i_ - 1))], &_k1);
      itemp_ = jpvt_[pvt_ - 1];
      jpvt_[pvt_ - 1] = jpvt_[i_ - 1];
      jpvt_[i_ - 1] = itemp_;
      vn1_[pvt_ - 1] = vn1_[i_ - 1];
      vn2_[pvt_ - 1] = vn2_[i_ - 1];
    }
    if (offpi_ < (*m_)) {
      (void) _dlarfg (($1_ = (*m_) - offpi_ + 1, &$1_), &a_[offpi_ - 1 + ((*lda_)) * ((i_ - 1))], &a_[offpi_ + 1 - 1 + 
      ((*lda_)) * ((i_ - 1))], &_k1, &tau_[i_ - 1]);
    }
    else {
      (void) _dlarfg (&_k1, &a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))], &a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))], &_k1, &tau_[i_ 
      - 1]);
    }
    if (i_ < (*n_)) {
      aii_ = a_[offpi_ - 1 + ((*lda_)) * ((i_ - 1))];
      a_[offpi_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
      (void) _dlarf (_dc_18, ($2_ = (*m_) - offpi_ + 1, &$2_), ($3_ = (*n_) - i_, &$3_), &a_[offpi_ - 1 + ((*lda_)) * ((i_ - 
      1))], &_k1, &tau_[i_ - 1], &a_[offpi_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, &work_[0]);
      a_[offpi_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
    }
    for (j_ = i_ + 1; j_ <= (*n_); (j_)++) {
      if (vn1_[j_ - 1] != 0.0) {
        temp_ = 1.0 - ($4_ = (_abs (a_[offpi_ - 1 + ((*lda_)) * ((j_ - 1))]) / vn1_[j_ - 1]), $4_ * $4_);
        temp_ = _max (temp_, 0.0);
        temp2_ = temp_ * ($5_ = (vn1_[j_ - 1] / vn2_[j_ - 1]), $5_ * $5_);
        if (temp2_ <= tol3z_) {
          if (offpi_ < (*m_)) {
            vn1_[j_ - 1] = _dnrm2 (($6_ = (*m_) - offpi_, &$6_), &a_[offpi_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
            vn2_[j_ - 1] = vn1_[j_ - 1];
          }
          else {
            vn1_[j_ - 1] = 0.0;
            vn2_[j_ - 1] = 0.0;
          }
        }
        else {
          vn1_[j_ - 1] = vn1_[j_ - 1] * sqrt (temp_);
        }
      }
    }
  }
  __calls[34].calls++;
  return 0;
}

int_4 _dlaqps (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ offset_, int_4 _p_ nb_, int_4 _p_ kb_, real_8 _p_ a_, int_4 _p_ 
lda_, int_4 _p_ jpvt_, real_8 _p_ tau_, real_8 _p_ vn1_, real_8 _p_ vn2_, real_8 _p_ auxv_, real_8 _p_ f_, int_4 _p_ 
ldf_)
{
  static int_4 itemp_, j_, k_, lastrk_, lsticc_, pvt_, rk_;
  static real_8 akk_, temp_, temp2_, tol3z_;
  int_4 $0_, $1_, $2_, $3_, $6_, $7_, $8_, $10_, $11_, $14_, $17_, $21_, $22_, $25_;
  real_8 $4_, $5_, $9_, $12_, $13_, $15_, $16_, $18_, $19_, $20_, $23_, $24_;
  extern int_4 _dgemm ();
  extern int_4 _dgemv ();
  extern int_4 _dswap ();
  extern int_4 _idamax ();
  extern real_8 _dlamch ();
  extern real_8 _dnrm2 ();
  lastrk_ = _min ((*m_), (*n_) + (*offset_));
  lsticc_ = 0;
  k_ = 0;
  tol3z_ = sqrt (_dlamch (_dc_10));
  _l10:;
  if ((k_ < (*nb_)) && (lsticc_ == 0)) {
    k_ = k_ + 1;
    rk_ = (*offset_) + k_;
    pvt_ = (k_ - 1) + _idamax (($0_ = (*n_) - k_ + 1, &$0_), &vn1_[k_ - 1], &_k1);
    if (pvt_ != k_) {
      (void) _dswap (m_, &a_[0 + ((*lda_)) * ((pvt_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
      (void) _dswap (($1_ = k_ - 1, &$1_), &f_[pvt_ - 1 + ((*ldf_)) * ((0))], ldf_, &f_[k_ - 1 + ((*ldf_)) * ((0))], ldf_);
      itemp_ = jpvt_[pvt_ - 1];
      jpvt_[pvt_ - 1] = jpvt_[k_ - 1];
      jpvt_[k_ - 1] = itemp_;
      vn1_[pvt_ - 1] = vn1_[k_ - 1];
      vn2_[pvt_ - 1] = vn2_[k_ - 1];
    }
    if (k_ > 1) {
      (void) _dgemv (_dc_21, ($2_ = (*m_) - rk_ + 1, &$2_), ($3_ = k_ - 1, &$3_), ($4_ = -1.0, &$4_), &a_[rk_ - 1 + ((*lda_)) 
      * ((0))], lda_, &f_[k_ - 1 + ((*ldf_)) * ((0))], ldf_, ($5_ = 1.0, &$5_), &a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1)
      ;
    }
    if (rk_ < (*m_)) {
      (void) _dlarfg (($6_ = (*m_) - rk_ + 1, &$6_), &a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))], &a_[rk_ + 1 - 1 + ((*lda_)) * 
      ((k_ - 1))], &_k1, &tau_[k_ - 1]);
    }
    else {
      (void) _dlarfg (&_k1, &a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))], &a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &tau_[k_ - 
      1]);
    }
    akk_ = a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))] = 1.0;
    if (k_ < (*n_)) {
      (void) _dgemv (_dc_22, ($7_ = (*m_) - rk_ + 1, &$7_), ($8_ = (*n_) - k_, &$8_), &tau_[k_ - 1], &a_[rk_ - 1 + ((*lda_)) 
      * ((k_ + 1 - 1))], lda_, &a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, ($9_ = 0.0, &$9_), &f_[k_ + 1 - 1 + ((*ldf_)) * 
      ((k_ - 1))], &_k1);
    }
    for (j_ = 1; j_ <= k_; (j_)++) {
      f_[j_ - 1 + ((*ldf_)) * ((k_ - 1))] = 0.0;
    }
    if (k_ > 1) {
      (void) _dgemv (_dc_22, ($10_ = (*m_) - rk_ + 1, &$10_), ($11_ = k_ - 1, &$11_), ($12_ = -tau_[k_ - 1], &$12_), &a_[rk_ 
      - 1 + ((*lda_)) * ((0))], lda_, &a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, ($13_ = 0.0, &$13_), &auxv_[0], &_k1);
      (void) _dgemv (_dc_21, n_, ($14_ = k_ - 1, &$14_), ($15_ = 1.0, &$15_), &f_[0 + ((*ldf_)) * ((0))], ldf_, &auxv_[0], 
      &_k1, ($16_ = 1.0, &$16_), &f_[0 + ((*ldf_)) * ((k_ - 1))], &_k1);
    }
    if (k_ < (*n_)) {
      (void) _dgemv (_dc_21, ($17_ = (*n_) - k_, &$17_), &k_, ($18_ = -1.0, &$18_), &f_[k_ + 1 - 1 + ((*ldf_)) * ((0))], 
      ldf_, &a_[rk_ - 1 + ((*lda_)) * ((0))], lda_, ($19_ = 1.0, &$19_), &a_[rk_ - 1 + ((*lda_)) * ((k_ + 1 - 1))], lda_);
    }
    if (rk_ < lastrk_) {
      for (j_ = k_ + 1; j_ <= (*n_); (j_)++) {
        if (vn1_[j_ - 1] != 0.0) {
          temp_ = _abs (a_[rk_ - 1 + ((*lda_)) * ((j_ - 1))]) / vn1_[j_ - 1];
          temp_ = _max (0.0, (1.0 + temp_) * (1.0 - temp_));
          temp2_ = temp_ * ($20_ = (vn1_[j_ - 1] / vn2_[j_ - 1]), $20_ * $20_);
          if (temp2_ <= tol3z_) {
            vn2_[j_ - 1] = (real_8) (lsticc_);
            lsticc_ = j_;
          }
          else {
            vn1_[j_ - 1] = vn1_[j_ - 1] * sqrt (temp_);
          }
        }
      }
    }
    a_[rk_ - 1 + ((*lda_)) * ((k_ - 1))] = akk_;
    goto _l10;
  }
  (*kb_) = k_;
  rk_ = (*offset_) + (*kb_);
  if ((*kb_) < _min ((*n_), (*m_) - (*offset_))) {
    (void) _dgemm (_dc_21, _dc_22, ($21_ = (*m_) - rk_, &$21_), ($22_ = (*n_) - (*kb_), &$22_), kb_, ($23_ = -1.0, &$23_), 
    &a_[rk_ + 1 - 1 + ((*lda_)) * ((0))], lda_, &f_[(*kb_) + 1 - 1 + ((*ldf_)) * ((0))], ldf_, ($24_ = 1.0, &$24_), &a_[rk_ 
    + 1 - 1 + ((*lda_)) * (((*kb_) + 1 - 1))], lda_);
  }
  _l40:;
  if (lsticc_ > 0) {
    itemp_ = _nintd (vn2_[lsticc_ - 1]);
    vn1_[lsticc_ - 1] = _dnrm2 (($25_ = (*m_) - rk_, &$25_), &a_[rk_ + 1 - 1 + ((*lda_)) * ((lsticc_ - 1))], &_k1);
    vn2_[lsticc_ - 1] = vn1_[lsticc_ - 1];
    lsticc_ = itemp_;
    goto _l40;
  }
  __calls[35].calls++;
  return 0;
}

int_4 _dlarfb (char _p_ side_, char _p_ trans_, char _p_ direct_, char _p_ storev_, int_4 _p_ m_, int_4 _p_ n_, int_4 
_p_ k_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, 
int_4 _p_ ldwork_)
{
  static int_4 i_, j_;
  static char_1 transt_;
  int_4 $1_, $5_, $10_, $14_, $19_, $23_, $28_, $32_, $37_, $41_, $46_, $50_, $55_, $59_, $64_, $68_;
  real_8 $0_, $2_, $3_, $4_, $6_, $7_, $8_, $9_, $11_, $12_, $13_, $15_, $16_, $17_, $18_, $20_, $21_, $22_, $24_, $25_, 
  $26_, $27_, $29_, $30_, $31_, $33_, $34_, $35_, $36_, $38_, $39_, $40_, $42_, $43_, $44_, $45_, $47_, $48_, $49_, $51_, 
  $52_, $53_, $54_, $56_, $57_, $58_, $60_, $61_, $62_, $63_, $65_, $66_, $67_, $69_, $70_, $71_;
  extern logical_4 _lsame ();
  extern int_4 _dcopy ();
  extern int_4 _dgemm ();
  extern int_4 _dtrmm ();
  if ((*m_) <= 0 || (*n_) <= 0) {
    goto _l0;
  }
  if (_lsame (trans_, _dc_2)) {
    bufcpy (transt_, _dc_25, 1);
  }
  else {
    bufcpy (transt_, _dc_2, 1);
  }
  if (_lsame (storev_, _dc_26)) {
    if (_lsame (direct_, _dc_16)) {
      if (_lsame (side_, _dc_1)) {
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          (void) _dcopy (n_, &c_[j_ - 1 + ((*ldc_)) * ((0))], ldc_, &work_[0 + ((*ldwork_)) * ((j_ - 1))], &_k1);
        }
        (void) _dtrmm (_dc_19, _dc_34, _dc_21, _dc_73, n_, k_, ($0_ = 1.0, &$0_), v_, ldv_, work_, ldwork_);
        if ((*m_) > (*k_)) {
          (void) _dgemm (_dc_22, _dc_21, n_, k_, ($1_ = (*m_) - (*k_), &$1_), ($2_ = 1.0, &$2_), &c_[(*k_) + 1 - 1 + ((*ldc_)) * 
          ((0))], ldc_, &v_[(*k_) + 1 - 1 + ((*ldv_)) * ((0))], ldv_, ($3_ = 1.0, &$3_), work_, ldwork_);
        }
        (void) _dtrmm (_dc_19, _dc_33, transt_, _dc_74, n_, k_, ($4_ = 1.0, &$4_), t_, ldt_, work_, ldwork_);
        if ((*m_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_22, ($5_ = (*m_) - (*k_), &$5_), n_, k_, ($6_ = -1.0, &$6_), &v_[(*k_) + 1 - 1 + ((*ldv_)) * 
          ((0))], ldv_, work_, ldwork_, ($7_ = 1.0, &$7_), &c_[(*k_) + 1 - 1 + ((*ldc_)) * ((0))], ldc_);
        }
        (void) _dtrmm (_dc_19, _dc_34, _dc_22, _dc_73, n_, k_, ($8_ = 1.0, &$8_), v_, ldv_, work_, ldwork_);
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            c_[j_ - 1 + ((*ldc_)) * ((i_ - 1))] = c_[j_ - 1 + ((*ldc_)) * ((i_ - 1))] - work_[i_ - 1 + ((*ldwork_)) * ((j_ - 1))];
          }
        }
      }
      else if (_lsame (side_, _dc_15)) {
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          (void) _dcopy (m_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1, &work_[0 + ((*ldwork_)) * ((j_ - 1))], &_k1);
        }
        (void) _dtrmm (_dc_19, _dc_34, _dc_21, _dc_73, m_, k_, ($9_ = 1.0, &$9_), v_, ldv_, work_, ldwork_);
        if ((*n_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_21, m_, k_, ($10_ = (*n_) - (*k_), &$10_), ($11_ = 1.0, &$11_), &c_[0 + ((*ldc_)) * (((*k_) 
          + 1 - 1))], ldc_, &v_[(*k_) + 1 - 1 + ((*ldv_)) * ((0))], ldv_, ($12_ = 1.0, &$12_), work_, ldwork_);
        }
        (void) _dtrmm (_dc_19, _dc_33, trans_, _dc_74, m_, k_, ($13_ = 1.0, &$13_), t_, ldt_, work_, ldwork_);
        if ((*n_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_22, m_, ($14_ = (*n_) - (*k_), &$14_), k_, ($15_ = -1.0, &$15_), work_, ldwork_, &v_[(*k_) + 
          1 - 1 + ((*ldv_)) * ((0))], ldv_, ($16_ = 1.0, &$16_), &c_[0 + ((*ldc_)) * (((*k_) + 1 - 1))], ldc_);
        }
        (void) _dtrmm (_dc_19, _dc_34, _dc_22, _dc_73, m_, k_, ($17_ = 1.0, &$17_), v_, ldv_, work_, ldwork_);
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] - work_[i_ - 1 + ((*ldwork_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if (_lsame (side_, _dc_1)) {
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          (void) _dcopy (n_, &c_[(*m_) - (*k_) + j_ - 1 + ((*ldc_)) * ((0))], ldc_, &work_[0 + ((*ldwork_)) * ((j_ - 1))], &_k1)
          ;
        }
        (void) _dtrmm (_dc_19, _dc_33, _dc_21, _dc_73, n_, k_, ($18_ = 1.0, &$18_), &v_[(*m_) - (*k_) + 1 - 1 + ((*ldv_)) * 
        ((0))], ldv_, work_, ldwork_);
        if ((*m_) > (*k_)) {
          (void) _dgemm (_dc_22, _dc_21, n_, k_, ($19_ = (*m_) - (*k_), &$19_), ($20_ = 1.0, &$20_), c_, ldc_, v_, ldv_, ($21_ = 
          1.0, &$21_), work_, ldwork_);
        }
        (void) _dtrmm (_dc_19, _dc_34, transt_, _dc_74, n_, k_, ($22_ = 1.0, &$22_), t_, ldt_, work_, ldwork_);
        if ((*m_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_22, ($23_ = (*m_) - (*k_), &$23_), n_, k_, ($24_ = -1.0, &$24_), v_, ldv_, work_, ldwork_, 
          ($25_ = 1.0, &$25_), c_, ldc_);
        }
        (void) _dtrmm (_dc_19, _dc_33, _dc_22, _dc_73, n_, k_, ($26_ = 1.0, &$26_), &v_[(*m_) - (*k_) + 1 - 1 + ((*ldv_)) * 
        ((0))], ldv_, work_, ldwork_);
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            c_[(*m_) - (*k_) + j_ - 1 + ((*ldc_)) * ((i_ - 1))] = c_[(*m_) - (*k_) + j_ - 1 + ((*ldc_)) * ((i_ - 1))] - work_[i_ - 
            1 + ((*ldwork_)) * ((j_ - 1))];
          }
        }
      }
      else if (_lsame (side_, _dc_15)) {
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          (void) _dcopy (m_, &c_[0 + ((*ldc_)) * (((*n_) - (*k_) + j_ - 1))], &_k1, &work_[0 + ((*ldwork_)) * ((j_ - 1))], &_k1)
          ;
        }
        (void) _dtrmm (_dc_19, _dc_33, _dc_21, _dc_73, m_, k_, ($27_ = 1.0, &$27_), &v_[(*n_) - (*k_) + 1 - 1 + ((*ldv_)) * 
        ((0))], ldv_, work_, ldwork_);
        if ((*n_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_21, m_, k_, ($28_ = (*n_) - (*k_), &$28_), ($29_ = 1.0, &$29_), c_, ldc_, v_, ldv_, ($30_ = 
          1.0, &$30_), work_, ldwork_);
        }
        (void) _dtrmm (_dc_19, _dc_34, trans_, _dc_74, m_, k_, ($31_ = 1.0, &$31_), t_, ldt_, work_, ldwork_);
        if ((*n_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_22, m_, ($32_ = (*n_) - (*k_), &$32_), k_, ($33_ = -1.0, &$33_), work_, ldwork_, v_, ldv_, 
          ($34_ = 1.0, &$34_), c_, ldc_);
        }
        (void) _dtrmm (_dc_19, _dc_33, _dc_22, _dc_73, m_, k_, ($35_ = 1.0, &$35_), &v_[(*n_) - (*k_) + 1 - 1 + ((*ldv_)) * 
        ((0))], ldv_, work_, ldwork_);
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * (((*n_) - (*k_) + j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * (((*n_) - (*k_) + j_ - 1))] - work_[i_ - 
            1 + ((*ldwork_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  else if (_lsame (storev_, _dc_15)) {
    if (_lsame (direct_, _dc_16)) {
      if (_lsame (side_, _dc_1)) {
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          (void) _dcopy (n_, &c_[j_ - 1 + ((*ldc_)) * ((0))], ldc_, &work_[0 + ((*ldwork_)) * ((j_ - 1))], &_k1);
        }
        (void) _dtrmm (_dc_19, _dc_33, _dc_22, _dc_73, n_, k_, ($36_ = 1.0, &$36_), v_, ldv_, work_, ldwork_);
        if ((*m_) > (*k_)) {
          (void) _dgemm (_dc_22, _dc_22, n_, k_, ($37_ = (*m_) - (*k_), &$37_), ($38_ = 1.0, &$38_), &c_[(*k_) + 1 - 1 + 
          ((*ldc_)) * ((0))], ldc_, &v_[0 + ((*ldv_)) * (((*k_) + 1 - 1))], ldv_, ($39_ = 1.0, &$39_), work_, ldwork_);
        }
        (void) _dtrmm (_dc_19, _dc_33, transt_, _dc_74, n_, k_, ($40_ = 1.0, &$40_), t_, ldt_, work_, ldwork_);
        if ((*m_) > (*k_)) {
          (void) _dgemm (_dc_22, _dc_22, ($41_ = (*m_) - (*k_), &$41_), n_, k_, ($42_ = -1.0, &$42_), &v_[0 + ((*ldv_)) * (((*k_) 
          + 1 - 1))], ldv_, work_, ldwork_, ($43_ = 1.0, &$43_), &c_[(*k_) + 1 - 1 + ((*ldc_)) * ((0))], ldc_);
        }
        (void) _dtrmm (_dc_19, _dc_33, _dc_21, _dc_73, n_, k_, ($44_ = 1.0, &$44_), v_, ldv_, work_, ldwork_);
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            c_[j_ - 1 + ((*ldc_)) * ((i_ - 1))] = c_[j_ - 1 + ((*ldc_)) * ((i_ - 1))] - work_[i_ - 1 + ((*ldwork_)) * ((j_ - 1))];
          }
        }
      }
      else if (_lsame (side_, _dc_15)) {
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          (void) _dcopy (m_, &c_[0 + ((*ldc_)) * ((j_ - 1))], &_k1, &work_[0 + ((*ldwork_)) * ((j_ - 1))], &_k1);
        }
        (void) _dtrmm (_dc_19, _dc_33, _dc_22, _dc_73, m_, k_, ($45_ = 1.0, &$45_), v_, ldv_, work_, ldwork_);
        if ((*n_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_22, m_, k_, ($46_ = (*n_) - (*k_), &$46_), ($47_ = 1.0, &$47_), &c_[0 + ((*ldc_)) * (((*k_) 
          + 1 - 1))], ldc_, &v_[0 + ((*ldv_)) * (((*k_) + 1 - 1))], ldv_, ($48_ = 1.0, &$48_), work_, ldwork_);
        }
        (void) _dtrmm (_dc_19, _dc_33, trans_, _dc_74, m_, k_, ($49_ = 1.0, &$49_), t_, ldt_, work_, ldwork_);
        if ((*n_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_21, m_, ($50_ = (*n_) - (*k_), &$50_), k_, ($51_ = -1.0, &$51_), work_, ldwork_, &v_[0 + 
          ((*ldv_)) * (((*k_) + 1 - 1))], ldv_, ($52_ = 1.0, &$52_), &c_[0 + ((*ldc_)) * (((*k_) + 1 - 1))], ldc_);
        }
        (void) _dtrmm (_dc_19, _dc_33, _dc_21, _dc_73, m_, k_, ($53_ = 1.0, &$53_), v_, ldv_, work_, ldwork_);
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * ((j_ - 1))] - work_[i_ - 1 + ((*ldwork_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if (_lsame (side_, _dc_1)) {
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          (void) _dcopy (n_, &c_[(*m_) - (*k_) + j_ - 1 + ((*ldc_)) * ((0))], ldc_, &work_[0 + ((*ldwork_)) * ((j_ - 1))], &_k1)
          ;
        }
        (void) _dtrmm (_dc_19, _dc_34, _dc_22, _dc_73, n_, k_, ($54_ = 1.0, &$54_), &v_[0 + ((*ldv_)) * (((*m_) - (*k_) + 1 - 
        1))], ldv_, work_, ldwork_);
        if ((*m_) > (*k_)) {
          (void) _dgemm (_dc_22, _dc_22, n_, k_, ($55_ = (*m_) - (*k_), &$55_), ($56_ = 1.0, &$56_), c_, ldc_, v_, ldv_, ($57_ = 
          1.0, &$57_), work_, ldwork_);
        }
        (void) _dtrmm (_dc_19, _dc_34, transt_, _dc_74, n_, k_, ($58_ = 1.0, &$58_), t_, ldt_, work_, ldwork_);
        if ((*m_) > (*k_)) {
          (void) _dgemm (_dc_22, _dc_22, ($59_ = (*m_) - (*k_), &$59_), n_, k_, ($60_ = -1.0, &$60_), v_, ldv_, work_, ldwork_, 
          ($61_ = 1.0, &$61_), c_, ldc_);
        }
        (void) _dtrmm (_dc_19, _dc_34, _dc_21, _dc_73, n_, k_, ($62_ = 1.0, &$62_), &v_[0 + ((*ldv_)) * (((*m_) - (*k_) + 1 - 
        1))], ldv_, work_, ldwork_);
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            c_[(*m_) - (*k_) + j_ - 1 + ((*ldc_)) * ((i_ - 1))] = c_[(*m_) - (*k_) + j_ - 1 + ((*ldc_)) * ((i_ - 1))] - work_[i_ - 
            1 + ((*ldwork_)) * ((j_ - 1))];
          }
        }
      }
      else if (_lsame (side_, _dc_15)) {
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          (void) _dcopy (m_, &c_[0 + ((*ldc_)) * (((*n_) - (*k_) + j_ - 1))], &_k1, &work_[0 + ((*ldwork_)) * ((j_ - 1))], &_k1)
          ;
        }
        (void) _dtrmm (_dc_19, _dc_34, _dc_22, _dc_73, m_, k_, ($63_ = 1.0, &$63_), &v_[0 + ((*ldv_)) * (((*n_) - (*k_) + 1 - 
        1))], ldv_, work_, ldwork_);
        if ((*n_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_22, m_, k_, ($64_ = (*n_) - (*k_), &$64_), ($65_ = 1.0, &$65_), c_, ldc_, v_, ldv_, ($66_ = 
          1.0, &$66_), work_, ldwork_);
        }
        (void) _dtrmm (_dc_19, _dc_34, trans_, _dc_74, m_, k_, ($67_ = 1.0, &$67_), t_, ldt_, work_, ldwork_);
        if ((*n_) > (*k_)) {
          (void) _dgemm (_dc_21, _dc_21, m_, ($68_ = (*n_) - (*k_), &$68_), k_, ($69_ = -1.0, &$69_), work_, ldwork_, v_, ldv_, 
          ($70_ = 1.0, &$70_), c_, ldc_);
        }
        (void) _dtrmm (_dc_19, _dc_34, _dc_21, _dc_73, m_, k_, ($71_ = 1.0, &$71_), &v_[0 + ((*ldv_)) * (((*n_) - (*k_) + 1 - 
        1))], ldv_, work_, ldwork_);
        for (j_ = 1; j_ <= (*k_); (j_)++) {
          for (i_ = 1; i_ <= (*m_); (i_)++) {
            c_[i_ - 1 + ((*ldc_)) * (((*n_) - (*k_) + j_ - 1))] = c_[i_ - 1 + ((*ldc_)) * (((*n_) - (*k_) + j_ - 1))] - work_[i_ - 
            1 + ((*ldwork_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[36].calls++;
  return 0;
}

int_4 _dlarf (char _p_ side_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ v_, int_4 _p_ incv_, real_8 _p_ tau_, real_8 _p_ 
c_, int_4 _p_ ldc_, real_8 _p_ work_)
{
  static int_4 i_, lastv_, lastc_;
  static logical_4 applyleft_;
  real_8 $0_, $1_, $2_, $3_, $4_, $5_;
  extern int_4 _dgemv ();
  extern int_4 _dger ();
  extern logical_4 _lsame ();
  applyleft_ = _lsame (side_, _dc_1);
  lastv_ = 0;
  lastc_ = 0;
  if ((*tau_) != 0.0) {
    if (applyleft_) {
      lastv_ = (*m_);
    }
    else {
      lastv_ = (*n_);
    }
    if ((*incv_) > 0) {
      i_ = 1 + (lastv_ - 1) * (*incv_);
    }
    else {
      i_ = 1;
    }
    while (lastv_ > 0 && v_[i_ - 1] == 0.0) {
      lastv_ = lastv_ - 1;
      i_ = i_ - (*incv_);
    }
    if (applyleft_) {
      lastc_ = _iladlc (&lastv_, n_, c_, ldc_);
    }
    else {
      lastc_ = _iladlr (m_, &lastv_, c_, ldc_);
    }
  }
  if (applyleft_) {
    if (lastv_ > 0) {
      (void) _dgemv (_dc_22, &lastv_, &lastc_, ($0_ = 1.0, &$0_), c_, ldc_, v_, incv_, ($1_ = 0.0, &$1_), work_, &_k1);
      (void) _dger (&lastv_, &lastc_, ($2_ = -(*tau_), &$2_), v_, incv_, work_, &_k1, c_, ldc_);
    }
  }
  else {
    if (lastv_ > 0) {
      (void) _dgemv (_dc_21, &lastc_, &lastv_, ($3_ = 1.0, &$3_), c_, ldc_, v_, incv_, ($4_ = 0.0, &$4_), work_, &_k1);
      (void) _dger (&lastc_, &lastv_, ($5_ = -(*tau_), &$5_), work_, &_k1, v_, incv_, c_, ldc_);
    }
  }
  __calls[37].calls++;
  return 0;
}

int_4 _dlarfg (int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ tau_)
{
  static int_4 j_, knt_;
  static real_8 beta_, rsafmn_, safmin_, xnorm_;
  int_4 $0_, $1_, $2_, $3_;
  real_8 $4_;
  extern real_8 _dlamch ();
  extern real_8 _dnrm2 ();
  extern int_4 _dscal ();
  if ((*n_) <= 1) {
    (*tau_) = 0.0;
    goto _l0;
  }
  xnorm_ = _dnrm2 (($0_ = (*n_) - 1, &$0_), x_, incx_);
  if (xnorm_ == 0.0) {
    (*tau_) = 0.0;
  }
  else {
    beta_ = -_sign (_dlapy2 (alpha_, &xnorm_), (*alpha_));
    safmin_ = _dlamch (_dc_52) / _dlamch (_dc_24);
    knt_ = 0;
    if (_abs (beta_) < safmin_) {
      rsafmn_ = 1.0 / safmin_;
      _l10:;
      knt_ = knt_ + 1;
      (void) _dscal (($1_ = (*n_) - 1, &$1_), &rsafmn_, x_, incx_);
      beta_ = beta_ * rsafmn_;
      (*alpha_) = (*alpha_) * rsafmn_;
      if ((_abs (beta_) < safmin_) && (knt_ < 20)) {
        goto _l10;
      }
      xnorm_ = _dnrm2 (($2_ = (*n_) - 1, &$2_), x_, incx_);
      beta_ = -_sign (_dlapy2 (alpha_, &xnorm_), (*alpha_));
    }
    (*tau_) = (beta_ - (*alpha_)) / beta_;
    (void) _dscal (($3_ = (*n_) - 1, &$3_), ($4_ = 1.0 / ((*alpha_) - beta_), &$4_), x_, incx_);
    for (j_ = 1; j_ <= knt_; (j_)++) {
      beta_ = beta_ * safmin_;
    }
    (*alpha_) = beta_;
  }
  _l0:;
  __calls[38].calls++;
  return 0;
}

int_4 _dlarft (char _p_ direct_, char _p_ storev_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 
_p_ tau_, real_8 _p_ t_, int_4 _p_ ldt_)
{
  static int_4 i_, j_, prevlastv_, lastv_;
  int_4 $0_, $1_, $4_, $5_, $8_, $9_, $10_, $13_, $14_, $17_;
  real_8 $2_, $3_, $6_, $7_, $11_, $12_, $15_, $16_;
  extern int_4 _dgemv ();
  extern int_4 _dtrmv ();
  extern logical_4 _lsame ();
  if ((*n_) == 0) {
    goto _l0;
  }
  if (_lsame (direct_, _dc_16)) {
    prevlastv_ = (*n_);
    for (i_ = 1; i_ <= (*k_); (i_)++) {
      prevlastv_ = _max (i_, prevlastv_);
      if (tau_[i_ - 1] == 0.0) {
        for (j_ = 1; j_ <= i_; (j_)++) {
          t_[j_ - 1 + ((*ldt_)) * ((i_ - 1))] = 0.0;
        }
      }
      else {
        if (_lsame (storev_, _dc_26)) {
          for (lastv_ = (*n_); lastv_ >= i_ + 1; (lastv_)--) {
            if (v_[lastv_ - 1 + ((*ldv_)) * ((i_ - 1))] != 0.0) {
              break;
            }
          }
          for (j_ = 1; j_ <= i_ - 1; (j_)++) {
            t_[j_ - 1 + ((*ldt_)) * ((i_ - 1))] = -tau_[i_ - 1] * v_[i_ - 1 + ((*ldv_)) * ((j_ - 1))];
          }
          j_ = _min (lastv_, prevlastv_);
          (void) _dgemv (_dc_22, ($0_ = j_ - i_, &$0_), ($1_ = i_ - 1, &$1_), ($2_ = -tau_[i_ - 1], &$2_), &v_[i_ + 1 - 1 + 
          ((*ldv_)) * ((0))], ldv_, &v_[i_ + 1 - 1 + ((*ldv_)) * ((i_ - 1))], &_k1, ($3_ = 1.0, &$3_), &t_[0 + ((*ldt_)) * ((i_ - 
          1))], &_k1);
        }
        else {
          for (lastv_ = (*n_); lastv_ >= i_ + 1; (lastv_)--) {
            if (v_[i_ - 1 + ((*ldv_)) * ((lastv_ - 1))] != 0.0) {
              break;
            }
          }
          for (j_ = 1; j_ <= i_ - 1; (j_)++) {
            t_[j_ - 1 + ((*ldt_)) * ((i_ - 1))] = -tau_[i_ - 1] * v_[j_ - 1 + ((*ldv_)) * ((i_ - 1))];
          }
          j_ = _min (lastv_, prevlastv_);
          (void) _dgemv (_dc_21, ($4_ = i_ - 1, &$4_), ($5_ = j_ - i_, &$5_), ($6_ = -tau_[i_ - 1], &$6_), &v_[0 + ((*ldv_)) * 
          ((i_ + 1 - 1))], ldv_, &v_[i_ - 1 + ((*ldv_)) * ((i_ + 1 - 1))], ldv_, ($7_ = 1.0, &$7_), &t_[0 + ((*ldt_)) * ((i_ - 
          1))], &_k1);
        }
        (void) _dtrmv (_dc_33, _dc_21, _dc_74, ($8_ = i_ - 1, &$8_), t_, ldt_, &t_[0 + ((*ldt_)) * ((i_ - 1))], &_k1);
        t_[i_ - 1 + ((*ldt_)) * ((i_ - 1))] = tau_[i_ - 1];
        if (i_ > 1) {
          prevlastv_ = _max (prevlastv_, lastv_);
        }
        else {
          prevlastv_ = lastv_;
        }
      }
    }
  }
  else {
    prevlastv_ = 1;
    for (i_ = (*k_); i_ >= 1; (i_)--) {
      if (tau_[i_ - 1] == 0.0) {
        for (j_ = i_; j_ <= (*k_); (j_)++) {
          t_[j_ - 1 + ((*ldt_)) * ((i_ - 1))] = 0.0;
        }
      }
      else {
        if (i_ < (*k_)) {
          if (_lsame (storev_, _dc_26)) {
            for (lastv_ = 1; lastv_ <= i_ - 1; (lastv_)++) {
              if (v_[lastv_ - 1 + ((*ldv_)) * ((i_ - 1))] != 0.0) {
                break;
              }
            }
            for (j_ = i_ + 1; j_ <= (*k_); (j_)++) {
              t_[j_ - 1 + ((*ldt_)) * ((i_ - 1))] = -tau_[i_ - 1] * v_[(*n_) - (*k_) + i_ - 1 + ((*ldv_)) * ((j_ - 1))];
            }
            j_ = _max (lastv_, prevlastv_);
            (void) _dgemv (_dc_22, ($9_ = (*n_) - (*k_) + i_ - j_, &$9_), ($10_ = (*k_) - i_, &$10_), ($11_ = -tau_[i_ - 1], 
            &$11_), &v_[j_ - 1 + ((*ldv_)) * ((i_ + 1 - 1))], ldv_, &v_[j_ - 1 + ((*ldv_)) * ((i_ - 1))], &_k1, ($12_ = 1.0, 
            &$12_), &t_[i_ + 1 - 1 + ((*ldt_)) * ((i_ - 1))], &_k1);
          }
          else {
            for (lastv_ = 1; lastv_ <= i_ - 1; (lastv_)++) {
              if (v_[i_ - 1 + ((*ldv_)) * ((lastv_ - 1))] != 0.0) {
                break;
              }
            }
            for (j_ = i_ + 1; j_ <= (*k_); (j_)++) {
              t_[j_ - 1 + ((*ldt_)) * ((i_ - 1))] = -tau_[i_ - 1] * v_[j_ - 1 + ((*ldv_)) * (((*n_) - (*k_) + i_ - 1))];
            }
            j_ = _max (lastv_, prevlastv_);
            (void) _dgemv (_dc_21, ($13_ = (*k_) - i_, &$13_), ($14_ = (*n_) - (*k_) + i_ - j_, &$14_), ($15_ = -tau_[i_ - 1], 
            &$15_), &v_[i_ + 1 - 1 + ((*ldv_)) * ((j_ - 1))], ldv_, &v_[i_ - 1 + ((*ldv_)) * ((j_ - 1))], ldv_, ($16_ = 1.0, 
            &$16_), &t_[i_ + 1 - 1 + ((*ldt_)) * ((i_ - 1))], &_k1);
          }
          (void) _dtrmv (_dc_34, _dc_21, _dc_74, ($17_ = (*k_) - i_, &$17_), &t_[i_ + 1 - 1 + ((*ldt_)) * ((i_ + 1 - 1))], ldt_, 
          &t_[i_ + 1 - 1 + ((*ldt_)) * ((i_ - 1))], &_k1);
          if (i_ > 1) {
            prevlastv_ = _min (prevlastv_, lastv_);
          }
          else {
            prevlastv_ = lastv_;
          }
        }
        t_[i_ - 1 + ((*ldt_)) * ((i_ - 1))] = tau_[i_ - 1];
      }
    }
  }
  _l0:;
  __calls[39].calls++;
  return 0;
}

int_4 _dlartg (real_8 _p_ f_, real_8 _p_ g_, real_8 _p_ cs_, real_8 _p_ sn_, real_8 _p_ r_)
{
  static int_4 count_, i_;
  static real_8 eps_, f1_, g1_, safmin_, safmn2_, safmx2_, scale_;
  extern real_8 _dlamch ();
  safmin_ = _dlamch (_dc_52);
  eps_ = _dlamch (_dc_24);
  safmn2_ = _up_real_8 (_dlamch (_dc_12), (int_4) (_aintd (log (safmin_ / eps_) / log (_dlamch (_dc_12)) / 2.0)));
  safmx2_ = 1.0 / safmn2_;
  if ((*g_) == 0.0) {
    (*cs_) = 1.0;
    (*sn_) = 0.0;
    (*r_) = (*f_);
  }
  else if ((*f_) == 0.0) {
    (*cs_) = 0.0;
    (*sn_) = 1.0;
    (*r_) = (*g_);
  }
  else {
    f1_ = (*f_);
    g1_ = (*g_);
    scale_ = _max (_abs (f1_), _abs (g1_));
    if (scale_ >= safmx2_) {
      count_ = 0;
      _l10:;
      count_ = count_ + 1;
      f1_ = f1_ * safmn2_;
      g1_ = g1_ * safmn2_;
      scale_ = _max (_abs (f1_), _abs (g1_));
      if (scale_ >= safmx2_) {
        goto _l10;
      }
      (*r_) = sqrt ((f1_ * f1_) + (g1_ * g1_));
      (*cs_) = f1_ / (*r_);
      (*sn_) = g1_ / (*r_);
      for (i_ = 1; i_ <= count_; (i_)++) {
        (*r_) = (*r_) * safmx2_;
      }
    }
    else if (scale_ <= safmn2_) {
      count_ = 0;
      _l30:;
      count_ = count_ + 1;
      f1_ = f1_ * safmx2_;
      g1_ = g1_ * safmx2_;
      scale_ = _max (_abs (f1_), _abs (g1_));
      if (scale_ <= safmn2_) {
        goto _l30;
      }
      (*r_) = sqrt ((f1_ * f1_) + (g1_ * g1_));
      (*cs_) = f1_ / (*r_);
      (*sn_) = g1_ / (*r_);
      for (i_ = 1; i_ <= count_; (i_)++) {
        (*r_) = (*r_) * safmn2_;
      }
    }
    else {
      (*r_) = sqrt ((f1_ * f1_) + (g1_ * g1_));
      (*cs_) = f1_ / (*r_);
      (*sn_) = g1_ / (*r_);
    }
    if (_abs ((*f_)) > _abs ((*g_)) && (*cs_) < 0.0) {
      (*cs_) = -(*cs_);
      (*sn_) = -(*sn_);
      (*r_) = -(*r_);
    }
  }
  __calls[40].calls++;
  return 0;
}

int_4 _dlas2 (real_8 _p_ f_, real_8 _p_ g_, real_8 _p_ h_, real_8 _p_ ssmin_, real_8 _p_ ssmax_)
{
  static real_8 as_, at_, au_, c_, fa_, fhmn_, fhmx_, ga_, ha_;
  real_8 $0_, $1_, $2_, $3_;
  fa_ = _abs ((*f_));
  ga_ = _abs ((*g_));
  ha_ = _abs ((*h_));
  fhmn_ = _min (fa_, ha_);
  fhmx_ = _max (fa_, ha_);
  if (fhmn_ == 0.0) {
    (*ssmin_) = 0.0;
    if (fhmx_ == 0.0) {
      (*ssmax_) = ga_;
    }
    else {
      (*ssmax_) = _max (fhmx_, ga_) * sqrt (1.0 + ($0_ = (_min (fhmx_, ga_) / _max (fhmx_, ga_)), $0_ * $0_));
    }
  }
  else {
    if (ga_ < fhmx_) {
      as_ = 1.0 + fhmn_ / fhmx_;
      at_ = (fhmx_ - fhmn_) / fhmx_;
      au_ = ($1_ = (ga_ / fhmx_), $1_ * $1_);
      c_ = 2.0 / (sqrt (as_ * as_ + au_) + sqrt (at_ * at_ + au_));
      (*ssmin_) = fhmn_ * c_;
      (*ssmax_) = fhmx_ / c_;
    }
    else {
      au_ = fhmx_ / ga_;
      if (au_ == 0.0) {
        (*ssmin_) = (fhmn_ * fhmx_) / ga_;
        (*ssmax_) = ga_;
      }
      else {
        as_ = 1.0 + fhmn_ / fhmx_;
        at_ = (fhmx_ - fhmn_) / fhmx_;
        c_ = 1.0 / (sqrt (1.0 + ($2_ = (as_ * au_), $2_ * $2_)) + sqrt (1.0 + ($3_ = (at_ * au_), $3_ * $3_)));
        (*ssmin_) = (fhmn_ * c_) * au_;
        (*ssmin_) = (*ssmin_) + (*ssmin_);
        (*ssmax_) = ga_ / (c_ + c_);
      }
    }
  }
  __calls[41].calls++;
  return 0;
}
int_4 _dlascl (char _p_ type_, int_4 _p_ kl_, int_4 _p_ ku_, real_8 _p_ cfrom_, real_8 _p_ cto_, int_4 _p_ m_, int_4 
_p_ n_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ info_)
{
  static int_4 i_, itype_, j_, k1_, k2_, k3_, k4_;
  static logical_4 done_;
  static real_8 bignum_, cfrom1_, cfromc_, cto1_, ctoc_, mul_, smlnum_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern real_8 _dlamch ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if (_lsame (type_, _dc_9)) {
    itype_ = 0;
  }
  else if (_lsame (type_, _dc_1)) {
    itype_ = 1;
  }
  else if (_lsame (type_, _dc_0)) {
    itype_ = 2;
  }
  else if (_lsame (type_, _dc_60)) {
    itype_ = 3;
  }
  else if (_lsame (type_, _dc_12)) {
    itype_ = 4;
  }
  else if (_lsame (type_, _dc_53)) {
    itype_ = 5;
  }
  else if (_lsame (type_, _dc_75)) {
    itype_ = 6;
  }
  else {
    itype_ = -1;
  }
  if (itype_ == -1) {
    (*info_) = -1;
  }
  else if ((*cfrom_) == 0.0 || _disnan (cfrom_)) {
    (*info_) = -4;
  }
  else if (_disnan (cto_)) {
    (*info_) = -5;
  }
  else if ((*m_) < 0) {
    (*info_) = -6;
  }
  else if ((*n_) < 0 || (itype_ == 4 && (*n_) != (*m_)) || (itype_ == 5 && (*n_) != (*m_))) {
    (*info_) = -7;
  }
  else if (itype_ <= 3 && (*lda_) < _max (1, (*m_))) {
    (*info_) = -9;
  }
  else if (itype_ >= 4) {
    if ((*kl_) < 0 || (*kl_) > _max ((*m_) - 1, 0)) {
      (*info_) = -2;
    }
    else if ((*ku_) < 0 || (*ku_) > _max ((*n_) - 1, 0) || ((itype_ == 4 || itype_ == 5) && (*kl_) != (*ku_))) {
      (*info_) = -3;
    }
    else if ((itype_ == 4 && (*lda_) < (*kl_) + 1) || (itype_ == 5 && (*lda_) < (*ku_) + 1) || (itype_ == 6 && (*lda_) < 2 
      * (*kl_) + (*ku_) + 1)) {
      (*info_) = -9;
    }
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_76, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  smlnum_ = _dlamch (_dc_52);
  bignum_ = 1.0 / smlnum_;
  cfromc_ = (*cfrom_);
  ctoc_ = (*cto_);
  _l10:;
  cfrom1_ = cfromc_ * smlnum_;
  if (cfrom1_ == cfromc_) {
    mul_ = ctoc_ / cfromc_;
    done_ = TRUE;
    cto1_ = ctoc_;
  }
  else {
    cto1_ = ctoc_ / bignum_;
    if (cto1_ == ctoc_) {
      mul_ = ctoc_;
      done_ = TRUE;
      cfromc_ = 1.0;
    }
    else if (_abs (cfrom1_) > _abs (ctoc_) && ctoc_ != 0.0) {
      mul_ = smlnum_;
      done_ = FALSE;
      cfromc_ = cfrom1_;
    }
    else if (_abs (cto1_) > _abs (cfromc_)) {
      mul_ = bignum_;
      done_ = FALSE;
      ctoc_ = cto1_;
    }
    else {
      mul_ = ctoc_ / cfromc_;
      done_ = TRUE;
    }
  }
  if (itype_ == 0) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 2) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 3) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_ + 1, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 4) {
    k3_ = (*kl_) + 1;
    k4_ = (*n_) + 1;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (k3_, k4_ - j_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 5) {
    k1_ = (*ku_) + 2;
    k3_ = (*ku_) + 1;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = _max (k1_ - j_, 1); i_ <= k3_; (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  else if (itype_ == 6) {
    k1_ = (*kl_) + (*ku_) + 2;
    k2_ = (*kl_) + 1;
    k3_ = 2 * (*kl_) + (*ku_) + 1;
    k4_ = (*kl_) + (*ku_) + 1 + (*m_);
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = _max (k1_ - j_, k2_); i_ <= _min (k3_, k4_ - j_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * mul_;
      }
    }
  }
  if (! (done_)) {
    goto _l10;
  }
  _l0:;
  __calls[42].calls++;
  return 0;
}

int_4 _dlasd0 (int_4 _p_ n_, int_4 _p_ sqre_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ 
vt_, int_4 _p_ ldvt_, int_4 _p_ smlsiz_, int_4 _p_ iwork_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, i1_, ic_, idxq_, idxqc_, im1_, inode_, itemp_, iwk_, j_, lf_, ll_, lvl_, m_, ncc_, nd_, ndb1_, ndiml_, 
  ndimr_, nl_, nlf_, nlp1_, nlvl_, nr_, nrf_, nrp1_, sqrei_;
  static real_8 alpha_, beta_;
  int_4 $0_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
  }
  else if (((*sqre_) < 0) || ((*sqre_) > 1)) {
    (*info_) = -2;
  }
  m_ = (*n_) + (*sqre_);
  if ((*ldu_) < (*n_)) {
    (*info_) = -6;
  }
  else if ((*ldvt_) < m_) {
    (*info_) = -8;
  }
  else if ((*smlsiz_) < 3) {
    (*info_) = -9;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_77, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) <= (*smlsiz_)) {
    (void) _dlasdq (_dc_0, sqre_, n_, &m_, n_, &_k0, d_, e_, vt_, ldvt_, u_, ldu_, u_, ldu_, work_, info_);
    goto _l0;
  }
  inode_ = 1;
  ndiml_ = inode_ + (*n_);
  ndimr_ = ndiml_ + (*n_);
  idxq_ = ndimr_ + (*n_);
  iwk_ = idxq_ + (*n_);
  (void) _dlasdt (n_, &nlvl_, &nd_, &iwork_[inode_ - 1], &iwork_[ndiml_ - 1], &iwork_[ndimr_ - 1], smlsiz_);
  ndb1_ = (nd_ + 1) / 2;
  ncc_ = 0;
  for (i_ = ndb1_; i_ <= nd_; (i_)++) {
    i1_ = i_ - 1;
    ic_ = iwork_[inode_ + i1_ - 1];
    nl_ = iwork_[ndiml_ + i1_ - 1];
    nlp1_ = nl_ + 1;
    nr_ = iwork_[ndimr_ + i1_ - 1];
    nrp1_ = nr_ + 1;
    nlf_ = ic_ - nl_;
    nrf_ = ic_ + 1;
    sqrei_ = 1;
    (void) _dlasdq (_dc_0, &sqrei_, &nl_, &nlp1_, &nl_, &ncc_, &d_[nlf_ - 1], &e_[nlf_ - 1], &vt_[nlf_ - 1 + ((*ldvt_)) * 
    ((nlf_ - 1))], ldvt_, &u_[nlf_ - 1 + ((*ldu_)) * ((nlf_ - 1))], ldu_, &u_[nlf_ - 1 + ((*ldu_)) * ((nlf_ - 1))], ldu_, 
    work_, info_);
    if ((*info_) != 0) {
      goto _l0;
    }
    itemp_ = idxq_ + nlf_ - 2;
    for (j_ = 1; j_ <= nl_; (j_)++) {
      iwork_[itemp_ + j_ - 1] = j_;
    }
    if (i_ == nd_) {
      sqrei_ = (*sqre_);
    }
    else {
      sqrei_ = 1;
    }
    nrp1_ = nr_ + sqrei_;
    (void) _dlasdq (_dc_0, &sqrei_, &nr_, &nrp1_, &nr_, &ncc_, &d_[nrf_ - 1], &e_[nrf_ - 1], &vt_[nrf_ - 1 + ((*ldvt_)) * 
    ((nrf_ - 1))], ldvt_, &u_[nrf_ - 1 + ((*ldu_)) * ((nrf_ - 1))], ldu_, &u_[nrf_ - 1 + ((*ldu_)) * ((nrf_ - 1))], ldu_, 
    work_, info_);
    if ((*info_) != 0) {
      goto _l0;
    }
    itemp_ = idxq_ + ic_;
    for (j_ = 1; j_ <= nr_; (j_)++) {
      iwork_[itemp_ + j_ - 1 - 1] = j_;
    }
  }
  for (lvl_ = nlvl_; lvl_ >= 1; (lvl_)--) {
    if (lvl_ == 1) {
      lf_ = 1;
      ll_ = 1;
    }
    else {
      lf_ = _up_int_4 (2, (lvl_ - 1));
      ll_ = 2 * lf_ - 1;
    }
    for (i_ = lf_; i_ <= ll_; (i_)++) {
      im1_ = i_ - 1;
      ic_ = iwork_[inode_ + im1_ - 1];
      nl_ = iwork_[ndiml_ + im1_ - 1];
      nr_ = iwork_[ndimr_ + im1_ - 1];
      nlf_ = ic_ - nl_;
      if (((*sqre_) == 0) && (i_ == ll_)) {
        sqrei_ = (*sqre_);
      }
      else {
        sqrei_ = 1;
      }
      idxqc_ = idxq_ + nlf_ - 1;
      alpha_ = d_[ic_ - 1];
      beta_ = e_[ic_ - 1];
      (void) _dlasd1 (&nl_, &nr_, &sqrei_, &d_[nlf_ - 1], &alpha_, &beta_, &u_[nlf_ - 1 + ((*ldu_)) * ((nlf_ - 1))], ldu_, 
      &vt_[nlf_ - 1 + ((*ldvt_)) * ((nlf_ - 1))], ldvt_, &iwork_[idxqc_ - 1], &iwork_[iwk_ - 1], work_, info_);
      if ((*info_) != 0) {
        goto _l0;
      }
    }
  }
  _l0:;
  __calls[43].calls++;
  return 0;
}

int_4 _dlasd1 (int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, real_8 _p_ d_, real_8 _p_ alpha_, real_8 _p_ beta_, 
real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, int_4 _p_ idxq_, int_4 _p_ iwork_, real_8 _p_ work_, 
int_4 _p_ info_)
{
  static int_4 coltyp_, i_, idx_, idxc_, idxp_, iq_, isigma_, iu2_, ivt2_, iz_, k_, ldq_, ldu2_, ldvt2_, m_, n_, n1_, n2_
  ;
  static real_8 orgnrm_;
  int_4 $0_;
  real_8 $1_, $2_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*nl_) < 1) {
    (*info_) = -1;
  }
  else if ((*nr_) < 1) {
    (*info_) = -2;
  }
  else if (((*sqre_) < 0) || ((*sqre_) > 1)) {
    (*info_) = -3;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_78, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  n_ = (*nl_) + (*nr_) + 1;
  m_ = n_ + (*sqre_);
  ldu2_ = n_;
  ldvt2_ = m_;
  iz_ = 1;
  isigma_ = iz_ + m_;
  iu2_ = isigma_ + n_;
  ivt2_ = iu2_ + ldu2_ * n_;
  iq_ = ivt2_ + ldvt2_ * m_;
  idx_ = 1;
  idxc_ = idx_ + n_;
  coltyp_ = idxc_ + n_;
  idxp_ = coltyp_ + n_;
  orgnrm_ = _max (_abs ((*alpha_)), _abs ((*beta_)));
  d_[(*nl_) + 1 - 1] = 0.0;
  for (i_ = 1; i_ <= n_; (i_)++) {
    if (_abs (d_[i_ - 1]) > orgnrm_) {
      orgnrm_ = _abs (d_[i_ - 1]);
    }
  }
  (void) _dlascl (_dc_9, &_k0, &_k0, &orgnrm_, ($1_ = 1.0, &$1_), &n_, &_k1, d_, &n_, info_);
  (*alpha_) = (*alpha_) / orgnrm_;
  (*beta_) = (*beta_) / orgnrm_;
  (void) _dlasd2 (nl_, nr_, sqre_, &k_, d_, &work_[iz_ - 1], alpha_, beta_, u_, ldu_, vt_, ldvt_, &work_[isigma_ - 1], 
  &work_[iu2_ - 1], &ldu2_, &work_[ivt2_ - 1], &ldvt2_, &iwork_[idxp_ - 1], &iwork_[idx_ - 1], &iwork_[idxc_ - 1], idxq_, 
  &iwork_[coltyp_ - 1], info_);
  ldq_ = k_;
  (void) _dlasd3 (nl_, nr_, sqre_, &k_, d_, &work_[iq_ - 1], &ldq_, &work_[isigma_ - 1], u_, ldu_, &work_[iu2_ - 1], 
  &ldu2_, vt_, ldvt_, &work_[ivt2_ - 1], &ldvt2_, &iwork_[idxc_ - 1], &iwork_[coltyp_ - 1], &work_[iz_ - 1], info_);
  if ((*info_) != 0) {
    goto _l0;
  }
  (void) _dlascl (_dc_9, &_k0, &_k0, ($2_ = 1.0, &$2_), &orgnrm_, &n_, &_k1, d_, &n_, info_);
  n1_ = k_;
  n2_ = n_ - k_;
  (void) _dlamrg (&n1_, &n2_, d_, &_k1, &_km1, idxq_);
  _l0:;
  __calls[44].calls++;
  return 0;
}

int_4 _dlasd2 (int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, int_4 _p_ k_, real_8 _p_ d_, real_8 _p_ z_, real_8 _p_ 
alpha_, real_8 _p_ beta_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ dsigma_, real_8 
_p_ u2_, int_4 _p_ ldu2_, real_8 _p_ vt2_, int_4 _p_ ldvt2_, int_4 _p_ idxp_, int_4 _p_ idx_, int_4 _p_ idxc_, int_4 
_p_ idxq_, int_4 _p_ coltyp_, int_4 _p_ info_)
{
  static int_4 ctot_[4], psm_[4], ct_, i_, idxi_, idxj_, idxjp_, j_, jp_, jprev_, k2_, m_, n_, nlp1_, nlp2_;
  static real_8 c_, eps_, hlftol_, s_, tau_, tol_, z1_;
  int_4 $0_, $1_, $4_, $5_, $6_;
  real_8 $2_, $3_;
  extern real_8 _dlamch ();
  extern int_4 _dcopy ();
  extern int_4 _drot ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*nl_) < 1) {
    (*info_) = -1;
  }
  else if ((*nr_) < 1) {
    (*info_) = -2;
  }
  else if (((*sqre_) != 1) && ((*sqre_) != 0)) {
    (*info_) = -3;
  }
  n_ = (*nl_) + (*nr_) + 1;
  m_ = n_ + (*sqre_);
  if ((*ldu_) < n_) {
    (*info_) = -10;
  }
  else if ((*ldvt_) < m_) {
    (*info_) = -12;
  }
  else if ((*ldu2_) < n_) {
    (*info_) = -15;
  }
  else if ((*ldvt2_) < m_) {
    (*info_) = -17;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_79, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  nlp1_ = (*nl_) + 1;
  nlp2_ = (*nl_) + 2;
  z1_ = (*alpha_) * vt_[nlp1_ - 1 + ((*ldvt_)) * ((nlp1_ - 1))];
  z_[0] = z1_;
  for (i_ = (*nl_); i_ >= 1; (i_)--) {
    z_[i_ + 1 - 1] = (*alpha_) * vt_[i_ - 1 + ((*ldvt_)) * ((nlp1_ - 1))];
    d_[i_ + 1 - 1] = d_[i_ - 1];
    idxq_[i_ + 1 - 1] = idxq_[i_ - 1] + 1;
  }
  for (i_ = nlp2_; i_ <= m_; (i_)++) {
    z_[i_ - 1] = (*beta_) * vt_[i_ - 1 + ((*ldvt_)) * ((nlp2_ - 1))];
  }
  for (i_ = 2; i_ <= nlp1_; (i_)++) {
    coltyp_[i_ - 1] = 1;
  }
  for (i_ = nlp2_; i_ <= n_; (i_)++) {
    coltyp_[i_ - 1] = 2;
  }
  for (i_ = nlp2_; i_ <= n_; (i_)++) {
    idxq_[i_ - 1] = idxq_[i_ - 1] + nlp1_;
  }
  for (i_ = 2; i_ <= n_; (i_)++) {
    dsigma_[i_ - 1] = d_[idxq_[i_ - 1] - 1];
    u2_[i_ - 1 + ((*ldu2_)) * ((0))] = z_[idxq_[i_ - 1] - 1];
    idxc_[i_ - 1] = coltyp_[idxq_[i_ - 1] - 1];
  }
  (void) _dlamrg (nl_, nr_, &dsigma_[1], &_k1, &_k1, &idx_[1]);
  for (i_ = 2; i_ <= n_; (i_)++) {
    idxi_ = 1 + idx_[i_ - 1];
    d_[i_ - 1] = dsigma_[idxi_ - 1];
    z_[i_ - 1] = u2_[idxi_ - 1 + ((*ldu2_)) * ((0))];
    coltyp_[i_ - 1] = idxc_[idxi_ - 1];
  }
  eps_ = _dlamch (_dc_10);
  tol_ = _max (_abs ((*alpha_)), _abs ((*beta_)));
  tol_ = 8.0 * eps_ * _max (_abs (d_[n_ - 1]), tol_);
  (*k_) = 1;
  k2_ = n_ + 1;
  for (j_ = 2; j_ <= n_; (j_)++) {
    if (_abs (z_[j_ - 1]) <= tol_) {
      k2_ = k2_ - 1;
      idxp_[k2_ - 1] = j_;
      coltyp_[j_ - 1] = 4;
      if (j_ == n_) {
        goto _l120;
      }
    }
    else {
      jprev_ = j_;
      goto _l90;
    }
  }
  _l90:;
  j_ = jprev_;
  _l100:;
  j_ = j_ + 1;
  if (j_ > n_) {
    goto _l110;
  }
  if (_abs (z_[j_ - 1]) <= tol_) {
    k2_ = k2_ - 1;
    idxp_[k2_ - 1] = j_;
    coltyp_[j_ - 1] = 4;
  }
  else {
    if (_abs (d_[j_ - 1] - d_[jprev_ - 1]) <= tol_) {
      s_ = z_[jprev_ - 1];
      c_ = z_[j_ - 1];
      tau_ = _dlapy2 (&c_, &s_);
      c_ = c_ / tau_;
      s_ = -s_ / tau_;
      z_[j_ - 1] = tau_;
      z_[jprev_ - 1] = 0.0;
      idxjp_ = idxq_[idx_[jprev_ - 1] + 1 - 1];
      idxj_ = idxq_[idx_[j_ - 1] + 1 - 1];
      if (idxjp_ <= nlp1_) {
        idxjp_ = idxjp_ - 1;
      }
      if (idxj_ <= nlp1_) {
        idxj_ = idxj_ - 1;
      }
      (void) _drot (&n_, &u_[0 + ((*ldu_)) * ((idxjp_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((idxj_ - 1))], &_k1, &c_, &s_);
      (void) _drot (&m_, &vt_[idxjp_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &vt_[idxj_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &c_, &s_)
      ;
      if (coltyp_[j_ - 1] != coltyp_[jprev_ - 1]) {
        coltyp_[j_ - 1] = 3;
      }
      coltyp_[jprev_ - 1] = 4;
      k2_ = k2_ - 1;
      idxp_[k2_ - 1] = jprev_;
      jprev_ = j_;
    }
    else {
      (*k_) = (*k_) + 1;
      u2_[(*k_) - 1 + ((*ldu2_)) * ((0))] = z_[jprev_ - 1];
      dsigma_[(*k_) - 1] = d_[jprev_ - 1];
      idxp_[(*k_) - 1] = jprev_;
      jprev_ = j_;
    }
  }
  goto _l100;
  _l110:;
  (*k_) = (*k_) + 1;
  u2_[(*k_) - 1 + ((*ldu2_)) * ((0))] = z_[jprev_ - 1];
  dsigma_[(*k_) - 1] = d_[jprev_ - 1];
  idxp_[(*k_) - 1] = jprev_;
  _l120:;
  for (j_ = 1; j_ <= 4; (j_)++) {
    ctot_[j_ - 1] = 0;
  }
  for (j_ = 2; j_ <= n_; (j_)++) {
    ct_ = coltyp_[j_ - 1];
    ctot_[ct_ - 1] = ctot_[ct_ - 1] + 1;
  }
  psm_[0] = 2;
  psm_[1] = 2 + ctot_[0];
  psm_[2] = psm_[1] + ctot_[1];
  psm_[3] = psm_[2] + ctot_[2];
  for (j_ = 2; j_ <= n_; (j_)++) {
    jp_ = idxp_[j_ - 1];
    ct_ = coltyp_[jp_ - 1];
    idxc_[psm_[ct_ - 1] - 1] = j_;
    psm_[ct_ - 1] = psm_[ct_ - 1] + 1;
  }
  for (j_ = 2; j_ <= n_; (j_)++) {
    jp_ = idxp_[j_ - 1];
    dsigma_[j_ - 1] = d_[jp_ - 1];
    idxj_ = idxq_[idx_[idxp_[idxc_[j_ - 1] - 1] - 1] + 1 - 1];
    if (idxj_ <= nlp1_) {
      idxj_ = idxj_ - 1;
    }
    (void) _dcopy (&n_, &u_[0 + ((*ldu_)) * ((idxj_ - 1))], &_k1, &u2_[0 + ((*ldu2_)) * ((j_ - 1))], &_k1);
    (void) _dcopy (&m_, &vt_[idxj_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &vt2_[j_ - 1 + ((*ldvt2_)) * ((0))], ldvt2_);
  }
  dsigma_[0] = 0.0;
  hlftol_ = tol_ / 2.0;
  if (_abs (dsigma_[1]) <= hlftol_) {
    dsigma_[1] = hlftol_;
  }
  if (m_ > n_) {
    z_[0] = _dlapy2 (&z1_, &z_[m_ - 1]);
    if (z_[0] <= tol_) {
      c_ = 1.0;
      s_ = 0.0;
      z_[0] = tol_;
    }
    else {
      c_ = z1_ / z_[0];
      s_ = z_[m_ - 1] / z_[0];
    }
  }
  else {
    if (_abs (z1_) <= tol_) {
      z_[0] = tol_;
    }
    else {
      z_[0] = z1_;
    }
  }
  (void) _dcopy (($1_ = (*k_) - 1, &$1_), &u2_[1 + ((*ldu2_)) * ((0))], &_k1, &z_[1], &_k1);
  (void) _dlaset (_dc_7, &n_, &_k1, ($2_ = 0.0, &$2_), ($3_ = 0.0, &$3_), u2_, ldu2_);
  u2_[nlp1_ - 1 + ((*ldu2_)) * ((0))] = 1.0;
  if (m_ > n_) {
    for (i_ = 1; i_ <= nlp1_; (i_)++) {
      vt_[m_ - 1 + ((*ldvt_)) * ((i_ - 1))] = -s_ * vt_[nlp1_ - 1 + ((*ldvt_)) * ((i_ - 1))];
      vt2_[0 + ((*ldvt2_)) * ((i_ - 1))] = c_ * vt_[nlp1_ - 1 + ((*ldvt_)) * ((i_ - 1))];
    }
    for (i_ = nlp2_; i_ <= m_; (i_)++) {
      vt2_[0 + ((*ldvt2_)) * ((i_ - 1))] = s_ * vt_[m_ - 1 + ((*ldvt_)) * ((i_ - 1))];
      vt_[m_ - 1 + ((*ldvt_)) * ((i_ - 1))] = c_ * vt_[m_ - 1 + ((*ldvt_)) * ((i_ - 1))];
    }
  }
  else {
    (void) _dcopy (&m_, &vt_[nlp1_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &vt2_[0 + ((*ldvt2_)) * ((0))], ldvt2_);
  }
  if (m_ > n_) {
    (void) _dcopy (&m_, &vt_[m_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &vt2_[m_ - 1 + ((*ldvt2_)) * ((0))], ldvt2_);
  }
  if (n_ > (*k_)) {
    (void) _dcopy (($4_ = n_ - (*k_), &$4_), &dsigma_[(*k_) + 1 - 1], &_k1, &d_[(*k_) + 1 - 1], &_k1);
    (void) _dlacpy (_dc_7, &n_, ($5_ = n_ - (*k_), &$5_), &u2_[0 + ((*ldu2_)) * (((*k_) + 1 - 1))], ldu2_, &u_[0 + 
    ((*ldu_)) * (((*k_) + 1 - 1))], ldu_);
    (void) _dlacpy (_dc_7, ($6_ = n_ - (*k_), &$6_), &m_, &vt2_[(*k_) + 1 - 1 + ((*ldvt2_)) * ((0))], ldvt2_, &vt_[(*k_) + 
    1 - 1 + ((*ldvt_)) * ((0))], ldvt_);
  }
  for (j_ = 1; j_ <= 4; (j_)++) {
    coltyp_[j_ - 1] = ctot_[j_ - 1];
  }
  _l0:;
  __calls[45].calls++;
  return 0;
}

int_4 _dlasd3 (int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, int_4 _p_ k_, real_8 _p_ d_, real_8 _p_ q_, int_4 _p_ 
ldq_, real_8 _p_ dsigma_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ u2_, int_4 _p_ ldu2_, real_8 _p_ vt_, int_4 _p_ 
ldvt_, real_8 _p_ vt2_, int_4 _p_ ldvt2_, int_4 _p_ idxc_, int_4 _p_ ctot_, real_8 _p_ z_, int_4 _p_ info_)
{
  static int_4 ctemp_, i_, j_, jc_, ktemp_, m_, n_, nlp1_, nlp2_, nrp1_;
  static real_8 rho_, temp_;
  int_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_;
  extern real_8 _dlamc3 ();
  extern real_8 _dnrm2 ();
  extern int_4 _dcopy ();
  extern int_4 _dgemm ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*nl_) < 1) {
    (*info_) = -1;
  }
  else if ((*nr_) < 1) {
    (*info_) = -2;
  }
  else if (((*sqre_) != 1) && ((*sqre_) != 0)) {
    (*info_) = -3;
  }
  n_ = (*nl_) + (*nr_) + 1;
  m_ = n_ + (*sqre_);
  nlp1_ = (*nl_) + 1;
  nlp2_ = (*nl_) + 2;
  if (((*k_) < 1) || ((*k_) > n_)) {
    (*info_) = -4;
  }
  else if ((*ldq_) < (*k_)) {
    (*info_) = -7;
  }
  else if ((*ldu_) < n_) {
    (*info_) = -10;
  }
  else if ((*ldu2_) < n_) {
    (*info_) = -12;
  }
  else if ((*ldvt_) < m_) {
    (*info_) = -14;
  }
  else if ((*ldvt2_) < m_) {
    (*info_) = -16;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_80, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*k_) == 1) {
    d_[0] = _abs (z_[0]);
    (void) _dcopy (&m_, &vt2_[0 + ((*ldvt2_)) * ((0))], ldvt2_, &vt_[0 + ((*ldvt_)) * ((0))], ldvt_);
    if (z_[0] > 0.0) {
      (void) _dcopy (&n_, &u2_[0 + ((*ldu2_)) * ((0))], &_k1, &u_[0 + ((*ldu_)) * ((0))], &_k1);
    }
    else {
      for (i_ = 1; i_ <= n_; (i_)++) {
        u_[i_ - 1 + ((*ldu_)) * ((0))] = -u2_[i_ - 1 + ((*ldu2_)) * ((0))];
      }
    }
    goto _l0;
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    dsigma_[i_ - 1] = _dlamc3 (&dsigma_[i_ - 1], &dsigma_[i_ - 1]) - dsigma_[i_ - 1];
  }
  (void) _dcopy (k_, z_, &_k1, q_, &_k1);
  rho_ = _dnrm2 (k_, z_, &_k1);
  (void) _dlascl (_dc_9, &_k0, &_k0, &rho_, ($1_ = 1.0, &$1_), k_, &_k1, z_, k_, info_);
  rho_ = rho_ * rho_;
  for (j_ = 1; j_ <= (*k_); (j_)++) {
    (void) _dlasd4 (k_, &j_, dsigma_, z_, &u_[0 + ((*ldu_)) * ((j_ - 1))], &rho_, &d_[j_ - 1], &vt_[0 + ((*ldvt_)) * ((j_ - 
    1))], info_);
    if ((*info_) != 0) {
      goto _l0;
    }
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    z_[i_ - 1] = u_[i_ - 1 + ((*ldu_)) * (((*k_) - 1))] * vt_[i_ - 1 + ((*ldvt_)) * (((*k_) - 1))];
    for (j_ = 1; j_ <= i_ - 1; (j_)++) {
      z_[i_ - 1] = z_[i_ - 1] * (u_[i_ - 1 + ((*ldu_)) * ((j_ - 1))] * vt_[i_ - 1 + ((*ldvt_)) * ((j_ - 1))] / (dsigma_[i_ - 
      1] - dsigma_[j_ - 1]) / (dsigma_[i_ - 1] + dsigma_[j_ - 1]));
    }
    for (j_ = i_; j_ <= (*k_) - 1; (j_)++) {
      z_[i_ - 1] = z_[i_ - 1] * (u_[i_ - 1 + ((*ldu_)) * ((j_ - 1))] * vt_[i_ - 1 + ((*ldvt_)) * ((j_ - 1))] / (dsigma_[i_ - 
      1] - dsigma_[j_ + 1 - 1]) / (dsigma_[i_ - 1] + dsigma_[j_ + 1 - 1]));
    }
    z_[i_ - 1] = _sign (sqrt (_abs (z_[i_ - 1])), q_[i_ - 1 + ((*ldq_)) * ((0))]);
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    vt_[0 + ((*ldvt_)) * ((i_ - 1))] = z_[0] / u_[0 + ((*ldu_)) * ((i_ - 1))] / vt_[0 + ((*ldvt_)) * ((i_ - 1))];
    u_[0 + ((*ldu_)) * ((i_ - 1))] = -1.0;
    for (j_ = 2; j_ <= (*k_); (j_)++) {
      vt_[j_ - 1 + ((*ldvt_)) * ((i_ - 1))] = z_[j_ - 1] / u_[j_ - 1 + ((*ldu_)) * ((i_ - 1))] / vt_[j_ - 1 + ((*ldvt_)) * 
      ((i_ - 1))];
      u_[j_ - 1 + ((*ldu_)) * ((i_ - 1))] = dsigma_[j_ - 1] * vt_[j_ - 1 + ((*ldvt_)) * ((i_ - 1))];
    }
    temp_ = _dnrm2 (k_, &u_[0 + ((*ldu_)) * ((i_ - 1))], &_k1);
    q_[0 + ((*ldq_)) * ((i_ - 1))] = u_[0 + ((*ldu_)) * ((i_ - 1))] / temp_;
    for (j_ = 2; j_ <= (*k_); (j_)++) {
      jc_ = idxc_[j_ - 1];
      q_[j_ - 1 + ((*ldq_)) * ((i_ - 1))] = u_[jc_ - 1 + ((*ldu_)) * ((i_ - 1))] / temp_;
    }
  }
  if ((*k_) == 2) {
    (void) _dgemm (_dc_2, _dc_2, &n_, k_, k_, ($2_ = 1.0, &$2_), u2_, ldu2_, q_, ldq_, ($3_ = 0.0, &$3_), u_, ldu_);
    goto _l100;
  }
  if (ctot_[0] > 0) {
    (void) _dgemm (_dc_2, _dc_2, nl_, k_, &ctot_[0], ($4_ = 1.0, &$4_), &u2_[0 + ((*ldu2_)) * ((1))], ldu2_, &q_[1 + 
    ((*ldq_)) * ((0))], ldq_, ($5_ = 0.0, &$5_), &u_[0 + ((*ldu_)) * ((0))], ldu_);
    if (ctot_[2] > 0) {
      ktemp_ = 2 + ctot_[0] + ctot_[1];
      (void) _dgemm (_dc_2, _dc_2, nl_, k_, &ctot_[2], ($6_ = 1.0, &$6_), &u2_[0 + ((*ldu2_)) * ((ktemp_ - 1))], ldu2_, 
      &q_[ktemp_ - 1 + ((*ldq_)) * ((0))], ldq_, ($7_ = 1.0, &$7_), &u_[0 + ((*ldu_)) * ((0))], ldu_);
    }
  }
  else if (ctot_[2] > 0) {
    ktemp_ = 2 + ctot_[0] + ctot_[1];
    (void) _dgemm (_dc_2, _dc_2, nl_, k_, &ctot_[2], ($8_ = 1.0, &$8_), &u2_[0 + ((*ldu2_)) * ((ktemp_ - 1))], ldu2_, 
    &q_[ktemp_ - 1 + ((*ldq_)) * ((0))], ldq_, ($9_ = 0.0, &$9_), &u_[0 + ((*ldu_)) * ((0))], ldu_);
  }
  else {
    (void) _dlacpy (_dc_16, nl_, k_, u2_, ldu2_, u_, ldu_);
  }
  (void) _dcopy (k_, &q_[0 + ((*ldq_)) * ((0))], ldq_, &u_[nlp1_ - 1 + ((*ldu_)) * ((0))], ldu_);
  ktemp_ = 2 + ctot_[0];
  ctemp_ = ctot_[1] + ctot_[2];
  (void) _dgemm (_dc_2, _dc_2, nr_, k_, &ctemp_, ($10_ = 1.0, &$10_), &u2_[nlp2_ - 1 + ((*ldu2_)) * ((ktemp_ - 1))], 
  ldu2_, &q_[ktemp_ - 1 + ((*ldq_)) * ((0))], ldq_, ($11_ = 0.0, &$11_), &u_[nlp2_ - 1 + ((*ldu_)) * ((0))], ldu_);
  _l100:;
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    temp_ = _dnrm2 (k_, &vt_[0 + ((*ldvt_)) * ((i_ - 1))], &_k1);
    q_[i_ - 1 + ((*ldq_)) * ((0))] = vt_[0 + ((*ldvt_)) * ((i_ - 1))] / temp_;
    for (j_ = 2; j_ <= (*k_); (j_)++) {
      jc_ = idxc_[j_ - 1];
      q_[i_ - 1 + ((*ldq_)) * ((j_ - 1))] = vt_[jc_ - 1 + ((*ldvt_)) * ((i_ - 1))] / temp_;
    }
  }
  if ((*k_) == 2) {
    (void) _dgemm (_dc_2, _dc_2, k_, &m_, k_, ($12_ = 1.0, &$12_), q_, ldq_, vt2_, ldvt2_, ($13_ = 0.0, &$13_), vt_, ldvt_)
    ;
    goto _l0;
  }
  ktemp_ = 1 + ctot_[0];
  (void) _dgemm (_dc_2, _dc_2, k_, &nlp1_, &ktemp_, ($14_ = 1.0, &$14_), &q_[0 + ((*ldq_)) * ((0))], ldq_, &vt2_[0 + 
  ((*ldvt2_)) * ((0))], ldvt2_, ($15_ = 0.0, &$15_), &vt_[0 + ((*ldvt_)) * ((0))], ldvt_);
  ktemp_ = 2 + ctot_[0] + ctot_[1];
  if (ktemp_ <= (*ldvt2_)) {
    (void) _dgemm (_dc_2, _dc_2, k_, &nlp1_, &ctot_[2], ($16_ = 1.0, &$16_), &q_[0 + ((*ldq_)) * ((ktemp_ - 1))], ldq_, 
    &vt2_[ktemp_ - 1 + ((*ldvt2_)) * ((0))], ldvt2_, ($17_ = 1.0, &$17_), &vt_[0 + ((*ldvt_)) * ((0))], ldvt_);
  }
  ktemp_ = ctot_[0] + 1;
  nrp1_ = (*nr_) + (*sqre_);
  if (ktemp_ > 1) {
    for (i_ = 1; i_ <= (*k_); (i_)++) {
      q_[i_ - 1 + ((*ldq_)) * ((ktemp_ - 1))] = q_[i_ - 1 + ((*ldq_)) * ((0))];
    }
    for (i_ = nlp2_; i_ <= m_; (i_)++) {
      vt2_[ktemp_ - 1 + ((*ldvt2_)) * ((i_ - 1))] = vt2_[0 + ((*ldvt2_)) * ((i_ - 1))];
    }
  }
  ctemp_ = 1 + ctot_[1] + ctot_[2];
  (void) _dgemm (_dc_2, _dc_2, k_, &nrp1_, &ctemp_, ($18_ = 1.0, &$18_), &q_[0 + ((*ldq_)) * ((ktemp_ - 1))], ldq_, 
  &vt2_[ktemp_ - 1 + ((*ldvt2_)) * ((nlp2_ - 1))], ldvt2_, ($19_ = 0.0, &$19_), &vt_[0 + ((*ldvt_)) * ((nlp2_ - 1))], 
  ldvt_);
  _l0:;
  __calls[46].calls++;
  return 0;
}

int_4 _dlasd4 (int_4 _p_ n_, int_4 _p_ i_, real_8 _p_ d_, real_8 _p_ z_, real_8 _p_ delta_, real_8 _p_ rho_, real_8 _p_ 
sigma_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 ii_, iim1_, iip1_, ip1_, iter_, j_, niter_;
  static logical_4 orgati_, swtch_, swtch3_, geomavg_;
  static real_8 a_, b_, c_, delsq_, delsq2_, sq2_, dphi_, dpsi_, dtiim_, dtiip_, dtipsq_, dtisq_, dtnsq_, dtnsq1_, dw_, 
  eps_, erretm_, eta_, phi_, prew_, psi_, rhoinv_, sglb_, sgub_, tau_, tau2_, temp_, temp1_, temp2_, w_, dd_[3], zz_[3];
  real_8 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern real_8 _dlamch ();
  (*info_) = 0;
  if ((*n_) == 1) {
    (*sigma_) = sqrt (d_[0] * d_[0] + (*rho_) * z_[0] * z_[0]);
    delta_[0] = 1.0;
    work_[0] = 1.0;
    goto _l0;
  }
  if ((*n_) == 2) {
    (void) _dlasd5 (i_, d_, z_, delta_, rho_, sigma_, work_);
    goto _l0;
  }
  eps_ = _dlamch (_dc_10);
  rhoinv_ = 1.0 / (*rho_);
  tau2_ = 0.0;
  if ((*i_) == (*n_)) {
    ii_ = (*n_) - 1;
    niter_ = 1;
    temp_ = (*rho_) / 2.0;
    temp1_ = temp_ / (d_[(*n_) - 1] + sqrt (d_[(*n_) - 1] * d_[(*n_) - 1] + temp_));
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      work_[j_ - 1] = d_[j_ - 1] + d_[(*n_) - 1] + temp1_;
      delta_[j_ - 1] = (d_[j_ - 1] - d_[(*n_) - 1]) - temp1_;
    }
    psi_ = 0.0;
    for (j_ = 1; j_ <= (*n_) - 2; (j_)++) {
      psi_ = psi_ + z_[j_ - 1] * z_[j_ - 1] / (delta_[j_ - 1] * work_[j_ - 1]);
    }
    c_ = rhoinv_ + psi_;
    w_ = c_ + z_[ii_ - 1] * z_[ii_ - 1] / (delta_[ii_ - 1] * work_[ii_ - 1]) + z_[(*n_) - 1] * z_[(*n_) - 1] / 
    (delta_[(*n_) - 1] * work_[(*n_) - 1]);
    if (w_ <= 0.0) {
      temp1_ = sqrt (d_[(*n_) - 1] * d_[(*n_) - 1] + (*rho_));
      temp_ = z_[(*n_) - 1 - 1] * z_[(*n_) - 1 - 1] / ((d_[(*n_) - 1 - 1] + temp1_) * (d_[(*n_) - 1] - d_[(*n_) - 1 - 1] + 
      (*rho_) / (d_[(*n_) - 1] + temp1_))) + z_[(*n_) - 1] * z_[(*n_) - 1] / (*rho_);
      if (c_ <= temp_) {
        tau_ = (*rho_);
      }
      else {
        delsq_ = (d_[(*n_) - 1] - d_[(*n_) - 1 - 1]) * (d_[(*n_) - 1] + d_[(*n_) - 1 - 1]);
        a_ = -c_ * delsq_ + z_[(*n_) - 1 - 1] * z_[(*n_) - 1 - 1] + z_[(*n_) - 1] * z_[(*n_) - 1];
        b_ = z_[(*n_) - 1] * z_[(*n_) - 1] * delsq_;
        if (a_ < 0.0) {
          tau2_ = 2.0 * b_ / (sqrt (a_ * a_ + 4.0 * b_ * c_) - a_);
        }
        else {
          tau2_ = (a_ + sqrt (a_ * a_ + 4.0 * b_ * c_)) / (2.0 * c_);
        }
        tau_ = tau2_ / (d_[(*n_) - 1] + sqrt (d_[(*n_) - 1] * d_[(*n_) - 1] + tau2_));
      }
    }
    else {
      delsq_ = (d_[(*n_) - 1] - d_[(*n_) - 1 - 1]) * (d_[(*n_) - 1] + d_[(*n_) - 1 - 1]);
      a_ = -c_ * delsq_ + z_[(*n_) - 1 - 1] * z_[(*n_) - 1 - 1] + z_[(*n_) - 1] * z_[(*n_) - 1];
      b_ = z_[(*n_) - 1] * z_[(*n_) - 1] * delsq_;
      if (a_ < 0.0) {
        tau2_ = 2.0 * b_ / (sqrt (a_ * a_ + 4.0 * b_ * c_) - a_);
      }
      else {
        tau2_ = (a_ + sqrt (a_ * a_ + 4.0 * b_ * c_)) / (2.0 * c_);
      }
      tau_ = tau2_ / (d_[(*n_) - 1] + sqrt (d_[(*n_) - 1] * d_[(*n_) - 1] + tau2_));
    }
    (*sigma_) = d_[(*n_) - 1] + tau_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      delta_[j_ - 1] = (d_[j_ - 1] - d_[(*n_) - 1]) - tau_;
      work_[j_ - 1] = d_[j_ - 1] + d_[(*n_) - 1] + tau_;
    }
    dpsi_ = 0.0;
    psi_ = 0.0;
    erretm_ = 0.0;
    for (j_ = 1; j_ <= ii_; (j_)++) {
      temp_ = z_[j_ - 1] / (delta_[j_ - 1] * work_[j_ - 1]);
      psi_ = psi_ + z_[j_ - 1] * temp_;
      dpsi_ = dpsi_ + temp_ * temp_;
      erretm_ = erretm_ + psi_;
    }
    erretm_ = _abs (erretm_);
    temp_ = z_[(*n_) - 1] / (delta_[(*n_) - 1] * work_[(*n_) - 1]);
    phi_ = z_[(*n_) - 1] * temp_;
    dphi_ = temp_ * temp_;
    erretm_ = 8.0 * (-phi_ - psi_) + erretm_ - phi_ + rhoinv_;
    w_ = rhoinv_ + phi_ + psi_;
    if (_abs (w_) <= eps_ * erretm_) {
      goto _l240;
    }
    niter_ = niter_ + 1;
    dtnsq1_ = work_[(*n_) - 1 - 1] * delta_[(*n_) - 1 - 1];
    dtnsq_ = work_[(*n_) - 1] * delta_[(*n_) - 1];
    c_ = w_ - dtnsq1_ * dpsi_ - dtnsq_ * dphi_;
    a_ = (dtnsq_ + dtnsq1_) * w_ - dtnsq_ * dtnsq1_ * (dpsi_ + dphi_);
    b_ = dtnsq_ * dtnsq1_ * w_;
    if (c_ < 0.0) {
      c_ = _abs (c_);
    }
    if (c_ == 0.0) {
      eta_ = (*rho_) - (*sigma_) * (*sigma_);
    }
    else if (a_ >= 0.0) {
      eta_ = (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
    }
    else {
      eta_ = 2.0 * b_ / (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
    }
    if (w_ * eta_ > 0.0) {
      eta_ = -w_ / (dpsi_ + dphi_);
    }
    temp_ = eta_ - dtnsq_;
    if (temp_ > (*rho_)) {
      eta_ = (*rho_) + dtnsq_;
    }
    eta_ = eta_ / ((*sigma_) + sqrt (eta_ + (*sigma_) * (*sigma_)));
    tau_ = tau_ + eta_;
    (*sigma_) = (*sigma_) + eta_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      delta_[j_ - 1] = delta_[j_ - 1] - eta_;
      work_[j_ - 1] = work_[j_ - 1] + eta_;
    }
    dpsi_ = 0.0;
    psi_ = 0.0;
    erretm_ = 0.0;
    for (j_ = 1; j_ <= ii_; (j_)++) {
      temp_ = z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
      psi_ = psi_ + z_[j_ - 1] * temp_;
      dpsi_ = dpsi_ + temp_ * temp_;
      erretm_ = erretm_ + psi_;
    }
    erretm_ = _abs (erretm_);
    tau2_ = work_[(*n_) - 1] * delta_[(*n_) - 1];
    temp_ = z_[(*n_) - 1] / tau2_;
    phi_ = z_[(*n_) - 1] * temp_;
    dphi_ = temp_ * temp_;
    erretm_ = 8.0 * (-phi_ - psi_) + erretm_ - phi_ + rhoinv_;
    w_ = rhoinv_ + phi_ + psi_;
    iter_ = niter_ + 1;
    for (niter_ = iter_; niter_ <= 400; (niter_)++) {
      if (_abs (w_) <= eps_ * erretm_) {
        goto _l240;
      }
      dtnsq1_ = work_[(*n_) - 1 - 1] * delta_[(*n_) - 1 - 1];
      dtnsq_ = work_[(*n_) - 1] * delta_[(*n_) - 1];
      c_ = w_ - dtnsq1_ * dpsi_ - dtnsq_ * dphi_;
      a_ = (dtnsq_ + dtnsq1_) * w_ - dtnsq1_ * dtnsq_ * (dpsi_ + dphi_);
      b_ = dtnsq1_ * dtnsq_ * w_;
      if (a_ >= 0.0) {
        eta_ = (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
      }
      else {
        eta_ = 2.0 * b_ / (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
      }
      if (w_ * eta_ > 0.0) {
        eta_ = -w_ / (dpsi_ + dphi_);
      }
      temp_ = eta_ - dtnsq_;
      if (temp_ <= 0.0) {
        eta_ = eta_ / 2.0;
      }
      eta_ = eta_ / ((*sigma_) + sqrt (eta_ + (*sigma_) * (*sigma_)));
      tau_ = tau_ + eta_;
      (*sigma_) = (*sigma_) + eta_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        delta_[j_ - 1] = delta_[j_ - 1] - eta_;
        work_[j_ - 1] = work_[j_ - 1] + eta_;
      }
      dpsi_ = 0.0;
      psi_ = 0.0;
      erretm_ = 0.0;
      for (j_ = 1; j_ <= ii_; (j_)++) {
        temp_ = z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
        psi_ = psi_ + z_[j_ - 1] * temp_;
        dpsi_ = dpsi_ + temp_ * temp_;
        erretm_ = erretm_ + psi_;
      }
      erretm_ = _abs (erretm_);
      tau2_ = work_[(*n_) - 1] * delta_[(*n_) - 1];
      temp_ = z_[(*n_) - 1] / tau2_;
      phi_ = z_[(*n_) - 1] * temp_;
      dphi_ = temp_ * temp_;
      erretm_ = 8.0 * (-phi_ - psi_) + erretm_ - phi_ + rhoinv_;
      w_ = rhoinv_ + phi_ + psi_;
    }
    (*info_) = 1;
    goto _l240;
  }
  else {
    niter_ = 1;
    ip1_ = (*i_) + 1;
    delsq_ = (d_[ip1_ - 1] - d_[(*i_) - 1]) * (d_[ip1_ - 1] + d_[(*i_) - 1]);
    delsq2_ = delsq_ / 2.0;
    sq2_ = sqrt ((d_[(*i_) - 1] * d_[(*i_) - 1] + d_[ip1_ - 1] * d_[ip1_ - 1]) / 2.0);
    temp_ = delsq2_ / (d_[(*i_) - 1] + sq2_);
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      work_[j_ - 1] = d_[j_ - 1] + d_[(*i_) - 1] + temp_;
      delta_[j_ - 1] = (d_[j_ - 1] - d_[(*i_) - 1]) - temp_;
    }
    psi_ = 0.0;
    for (j_ = 1; j_ <= (*i_) - 1; (j_)++) {
      psi_ = psi_ + z_[j_ - 1] * z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
    }
    phi_ = 0.0;
    for (j_ = (*n_); j_ >= (*i_) + 2; (j_)--) {
      phi_ = phi_ + z_[j_ - 1] * z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
    }
    c_ = rhoinv_ + psi_ + phi_;
    w_ = c_ + z_[(*i_) - 1] * z_[(*i_) - 1] / (work_[(*i_) - 1] * delta_[(*i_) - 1]) + z_[ip1_ - 1] * z_[ip1_ - 1] / 
    (work_[ip1_ - 1] * delta_[ip1_ - 1]);
    geomavg_ = FALSE;
    if (w_ > 0.0) {
      orgati_ = TRUE;
      ii_ = (*i_);
      sglb_ = 0.0;
      sgub_ = delsq2_ / (d_[(*i_) - 1] + sq2_);
      a_ = c_ * delsq_ + z_[(*i_) - 1] * z_[(*i_) - 1] + z_[ip1_ - 1] * z_[ip1_ - 1];
      b_ = z_[(*i_) - 1] * z_[(*i_) - 1] * delsq_;
      if (a_ > 0.0) {
        tau2_ = 2.0 * b_ / (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
      }
      else {
        tau2_ = (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
      }
      tau_ = tau2_ / (d_[(*i_) - 1] + sqrt (d_[(*i_) - 1] * d_[(*i_) - 1] + tau2_));
      temp_ = sqrt (eps_);
      if ((d_[(*i_) - 1] <= temp_ * d_[ip1_ - 1]) && (_abs (z_[(*i_) - 1]) <= temp_) && (d_[(*i_) - 1] > 0.0)) {
        tau_ = _min (10.0 * d_[(*i_) - 1], sgub_);
        geomavg_ = TRUE;
      }
    }
    else {
      orgati_ = FALSE;
      ii_ = ip1_;
      sglb_ = -delsq2_ / (d_[ii_ - 1] + sq2_);
      sgub_ = 0.0;
      a_ = c_ * delsq_ - z_[(*i_) - 1] * z_[(*i_) - 1] - z_[ip1_ - 1] * z_[ip1_ - 1];
      b_ = z_[ip1_ - 1] * z_[ip1_ - 1] * delsq_;
      if (a_ < 0.0) {
        tau2_ = 2.0 * b_ / (a_ - sqrt (_abs (a_ * a_ + 4.0 * b_ * c_)));
      }
      else {
        tau2_ = -(a_ + sqrt (_abs (a_ * a_ + 4.0 * b_ * c_))) / (2.0 * c_);
      }
      tau_ = tau2_ / (d_[ip1_ - 1] + sqrt (_abs (d_[ip1_ - 1] * d_[ip1_ - 1] + tau2_)));
    }
    (*sigma_) = d_[ii_ - 1] + tau_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      work_[j_ - 1] = d_[j_ - 1] + d_[ii_ - 1] + tau_;
      delta_[j_ - 1] = (d_[j_ - 1] - d_[ii_ - 1]) - tau_;
    }
    iim1_ = ii_ - 1;
    iip1_ = ii_ + 1;
    dpsi_ = 0.0;
    psi_ = 0.0;
    erretm_ = 0.0;
    for (j_ = 1; j_ <= iim1_; (j_)++) {
      temp_ = z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
      psi_ = psi_ + z_[j_ - 1] * temp_;
      dpsi_ = dpsi_ + temp_ * temp_;
      erretm_ = erretm_ + psi_;
    }
    erretm_ = _abs (erretm_);
    dphi_ = 0.0;
    phi_ = 0.0;
    for (j_ = (*n_); j_ >= iip1_; (j_)--) {
      temp_ = z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
      phi_ = phi_ + z_[j_ - 1] * temp_;
      dphi_ = dphi_ + temp_ * temp_;
      erretm_ = erretm_ + phi_;
    }
    w_ = rhoinv_ + phi_ + psi_;
    swtch3_ = FALSE;
    if (orgati_) {
      if (w_ < 0.0) {
        swtch3_ = TRUE;
      }
    }
    else {
      if (w_ > 0.0) {
        swtch3_ = TRUE;
      }
    }
    if (ii_ == 1 || ii_ == (*n_)) {
      swtch3_ = FALSE;
    }
    temp_ = z_[ii_ - 1] / (work_[ii_ - 1] * delta_[ii_ - 1]);
    dw_ = dpsi_ + dphi_ + temp_ * temp_;
    temp_ = z_[ii_ - 1] * temp_;
    w_ = w_ + temp_;
    erretm_ = 8.0 * (phi_ - psi_) + erretm_ + 2.0 * rhoinv_ + 3.0 * _abs (temp_);
    if (_abs (w_) <= eps_ * erretm_) {
      goto _l240;
    }
    if (w_ <= 0.0) {
      sglb_ = _max (sglb_, tau_);
    }
    else {
      sgub_ = _min (sgub_, tau_);
    }
    niter_ = niter_ + 1;
    if (! (swtch3_)) {
      dtipsq_ = work_[ip1_ - 1] * delta_[ip1_ - 1];
      dtisq_ = work_[(*i_) - 1] * delta_[(*i_) - 1];
      if (orgati_) {
        c_ = w_ - dtipsq_ * dw_ + delsq_ * ($0_ = (z_[(*i_) - 1] / dtisq_), $0_ * $0_);
      }
      else {
        c_ = w_ - dtisq_ * dw_ - delsq_ * ($1_ = (z_[ip1_ - 1] / dtipsq_), $1_ * $1_);
      }
      a_ = (dtipsq_ + dtisq_) * w_ - dtipsq_ * dtisq_ * dw_;
      b_ = dtipsq_ * dtisq_ * w_;
      if (c_ == 0.0) {
        if (a_ == 0.0) {
          if (orgati_) {
            a_ = z_[(*i_) - 1] * z_[(*i_) - 1] + dtipsq_ * dtipsq_ * (dpsi_ + dphi_);
          }
          else {
            a_ = z_[ip1_ - 1] * z_[ip1_ - 1] + dtisq_ * dtisq_ * (dpsi_ + dphi_);
          }
        }
        eta_ = b_ / a_;
      }
      else if (a_ <= 0.0) {
        eta_ = (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
      }
      else {
        eta_ = 2.0 * b_ / (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
      }
    }
    else {
      dtiim_ = work_[iim1_ - 1] * delta_[iim1_ - 1];
      dtiip_ = work_[iip1_ - 1] * delta_[iip1_ - 1];
      temp_ = rhoinv_ + psi_ + phi_;
      if (orgati_) {
        temp1_ = z_[iim1_ - 1] / dtiim_;
        temp1_ = temp1_ * temp1_;
        c_ = (temp_ - dtiip_ * (dpsi_ + dphi_)) - (d_[iim1_ - 1] - d_[iip1_ - 1]) * (d_[iim1_ - 1] + d_[iip1_ - 1]) * temp1_;
        zz_[0] = z_[iim1_ - 1] * z_[iim1_ - 1];
        if (dpsi_ < temp1_) {
          zz_[2] = dtiip_ * dtiip_ * dphi_;
        }
        else {
          zz_[2] = dtiip_ * dtiip_ * ((dpsi_ - temp1_) + dphi_);
        }
      }
      else {
        temp1_ = z_[iip1_ - 1] / dtiip_;
        temp1_ = temp1_ * temp1_;
        c_ = (temp_ - dtiim_ * (dpsi_ + dphi_)) - (d_[iip1_ - 1] - d_[iim1_ - 1]) * (d_[iim1_ - 1] + d_[iip1_ - 1]) * temp1_;
        if (dphi_ < temp1_) {
          zz_[0] = dtiim_ * dtiim_ * dpsi_;
        }
        else {
          zz_[0] = dtiim_ * dtiim_ * (dpsi_ + (dphi_ - temp1_));
        }
        zz_[2] = z_[iip1_ - 1] * z_[iip1_ - 1];
      }
      zz_[1] = z_[ii_ - 1] * z_[ii_ - 1];
      dd_[0] = dtiim_;
      dd_[1] = delta_[ii_ - 1] * work_[ii_ - 1];
      dd_[2] = dtiip_;
      (void) _dlaed6 (&niter_, &orgati_, &c_, dd_, zz_, &w_, &eta_, info_);
      if ((*info_) != 0) {
        swtch3_ = FALSE;
        (*info_) = 0;
        dtipsq_ = work_[ip1_ - 1] * delta_[ip1_ - 1];
        dtisq_ = work_[(*i_) - 1] * delta_[(*i_) - 1];
        if (orgati_) {
          c_ = w_ - dtipsq_ * dw_ + delsq_ * ($2_ = (z_[(*i_) - 1] / dtisq_), $2_ * $2_);
        }
        else {
          c_ = w_ - dtisq_ * dw_ - delsq_ * ($3_ = (z_[ip1_ - 1] / dtipsq_), $3_ * $3_);
        }
        a_ = (dtipsq_ + dtisq_) * w_ - dtipsq_ * dtisq_ * dw_;
        b_ = dtipsq_ * dtisq_ * w_;
        if (c_ == 0.0) {
          if (a_ == 0.0) {
            if (orgati_) {
              a_ = z_[(*i_) - 1] * z_[(*i_) - 1] + dtipsq_ * dtipsq_ * (dpsi_ + dphi_);
            }
            else {
              a_ = z_[ip1_ - 1] * z_[ip1_ - 1] + dtisq_ * dtisq_ * (dpsi_ + dphi_);
            }
          }
          eta_ = b_ / a_;
        }
        else if (a_ <= 0.0) {
          eta_ = (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
        }
        else {
          eta_ = 2.0 * b_ / (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
        }
      }
    }
    if (w_ * eta_ >= 0.0) {
      eta_ = -w_ / dw_;
    }
    eta_ = eta_ / ((*sigma_) + sqrt ((*sigma_) * (*sigma_) + eta_));
    temp_ = tau_ + eta_;
    if (temp_ > sgub_ || temp_ < sglb_) {
      if (w_ < 0.0) {
        eta_ = (sgub_ - tau_) / 2.0;
      }
      else {
        eta_ = (sglb_ - tau_) / 2.0;
      }
      if (geomavg_) {
        if (w_ < 0.0) {
          if (tau_ > 0.0) {
            eta_ = sqrt (sgub_ * tau_) - tau_;
          }
        }
        else {
          if (sglb_ > 0.0) {
            eta_ = sqrt (sglb_ * tau_) - tau_;
          }
        }
      }
    }
    prew_ = w_;
    tau_ = tau_ + eta_;
    (*sigma_) = (*sigma_) + eta_;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      work_[j_ - 1] = work_[j_ - 1] + eta_;
      delta_[j_ - 1] = delta_[j_ - 1] - eta_;
    }
    dpsi_ = 0.0;
    psi_ = 0.0;
    erretm_ = 0.0;
    for (j_ = 1; j_ <= iim1_; (j_)++) {
      temp_ = z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
      psi_ = psi_ + z_[j_ - 1] * temp_;
      dpsi_ = dpsi_ + temp_ * temp_;
      erretm_ = erretm_ + psi_;
    }
    erretm_ = _abs (erretm_);
    dphi_ = 0.0;
    phi_ = 0.0;
    for (j_ = (*n_); j_ >= iip1_; (j_)--) {
      temp_ = z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
      phi_ = phi_ + z_[j_ - 1] * temp_;
      dphi_ = dphi_ + temp_ * temp_;
      erretm_ = erretm_ + phi_;
    }
    tau2_ = work_[ii_ - 1] * delta_[ii_ - 1];
    temp_ = z_[ii_ - 1] / tau2_;
    dw_ = dpsi_ + dphi_ + temp_ * temp_;
    temp_ = z_[ii_ - 1] * temp_;
    w_ = rhoinv_ + phi_ + psi_ + temp_;
    erretm_ = 8.0 * (phi_ - psi_) + erretm_ + 2.0 * rhoinv_ + 3.0 * _abs (temp_);
    swtch_ = FALSE;
    if (orgati_) {
      if (-w_ > _abs (prew_) / 10.0) {
        swtch_ = TRUE;
      }
    }
    else {
      if (w_ > _abs (prew_) / 10.0) {
        swtch_ = TRUE;
      }
    }
    iter_ = niter_ + 1;
    for (niter_ = iter_; niter_ <= 400; (niter_)++) {
      if (_abs (w_) <= eps_ * erretm_) {
        goto _l240;
      }
      if (w_ <= 0.0) {
        sglb_ = _max (sglb_, tau_);
      }
      else {
        sgub_ = _min (sgub_, tau_);
      }
      if (! (swtch3_)) {
        dtipsq_ = work_[ip1_ - 1] * delta_[ip1_ - 1];
        dtisq_ = work_[(*i_) - 1] * delta_[(*i_) - 1];
        if (! (swtch_)) {
          if (orgati_) {
            c_ = w_ - dtipsq_ * dw_ + delsq_ * ($4_ = (z_[(*i_) - 1] / dtisq_), $4_ * $4_);
          }
          else {
            c_ = w_ - dtisq_ * dw_ - delsq_ * ($5_ = (z_[ip1_ - 1] / dtipsq_), $5_ * $5_);
          }
        }
        else {
          temp_ = z_[ii_ - 1] / (work_[ii_ - 1] * delta_[ii_ - 1]);
          if (orgati_) {
            dpsi_ = dpsi_ + temp_ * temp_;
          }
          else {
            dphi_ = dphi_ + temp_ * temp_;
          }
          c_ = w_ - dtisq_ * dpsi_ - dtipsq_ * dphi_;
        }
        a_ = (dtipsq_ + dtisq_) * w_ - dtipsq_ * dtisq_ * dw_;
        b_ = dtipsq_ * dtisq_ * w_;
        if (c_ == 0.0) {
          if (a_ == 0.0) {
            if (! (swtch_)) {
              if (orgati_) {
                a_ = z_[(*i_) - 1] * z_[(*i_) - 1] + dtipsq_ * dtipsq_ * (dpsi_ + dphi_);
              }
              else {
                a_ = z_[ip1_ - 1] * z_[ip1_ - 1] + dtisq_ * dtisq_ * (dpsi_ + dphi_);
              }
            }
            else {
              a_ = dtisq_ * dtisq_ * dpsi_ + dtipsq_ * dtipsq_ * dphi_;
            }
          }
          eta_ = b_ / a_;
        }
        else if (a_ <= 0.0) {
          eta_ = (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
        }
        else {
          eta_ = 2.0 * b_ / (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
        }
      }
      else {
        dtiim_ = work_[iim1_ - 1] * delta_[iim1_ - 1];
        dtiip_ = work_[iip1_ - 1] * delta_[iip1_ - 1];
        temp_ = rhoinv_ + psi_ + phi_;
        if (swtch_) {
          c_ = temp_ - dtiim_ * dpsi_ - dtiip_ * dphi_;
          zz_[0] = dtiim_ * dtiim_ * dpsi_;
          zz_[2] = dtiip_ * dtiip_ * dphi_;
        }
        else {
          if (orgati_) {
            temp1_ = z_[iim1_ - 1] / dtiim_;
            temp1_ = temp1_ * temp1_;
            temp2_ = (d_[iim1_ - 1] - d_[iip1_ - 1]) * (d_[iim1_ - 1] + d_[iip1_ - 1]) * temp1_;
            c_ = temp_ - dtiip_ * (dpsi_ + dphi_) - temp2_;
            zz_[0] = z_[iim1_ - 1] * z_[iim1_ - 1];
            if (dpsi_ < temp1_) {
              zz_[2] = dtiip_ * dtiip_ * dphi_;
            }
            else {
              zz_[2] = dtiip_ * dtiip_ * ((dpsi_ - temp1_) + dphi_);
            }
          }
          else {
            temp1_ = z_[iip1_ - 1] / dtiip_;
            temp1_ = temp1_ * temp1_;
            temp2_ = (d_[iip1_ - 1] - d_[iim1_ - 1]) * (d_[iim1_ - 1] + d_[iip1_ - 1]) * temp1_;
            c_ = temp_ - dtiim_ * (dpsi_ + dphi_) - temp2_;
            if (dphi_ < temp1_) {
              zz_[0] = dtiim_ * dtiim_ * dpsi_;
            }
            else {
              zz_[0] = dtiim_ * dtiim_ * (dpsi_ + (dphi_ - temp1_));
            }
            zz_[2] = z_[iip1_ - 1] * z_[iip1_ - 1];
          }
        }
        dd_[0] = dtiim_;
        dd_[1] = delta_[ii_ - 1] * work_[ii_ - 1];
        dd_[2] = dtiip_;
        (void) _dlaed6 (&niter_, &orgati_, &c_, dd_, zz_, &w_, &eta_, info_);
        if ((*info_) != 0) {
          swtch3_ = FALSE;
          (*info_) = 0;
          dtipsq_ = work_[ip1_ - 1] * delta_[ip1_ - 1];
          dtisq_ = work_[(*i_) - 1] * delta_[(*i_) - 1];
          if (! (swtch_)) {
            if (orgati_) {
              c_ = w_ - dtipsq_ * dw_ + delsq_ * ($6_ = (z_[(*i_) - 1] / dtisq_), $6_ * $6_);
            }
            else {
              c_ = w_ - dtisq_ * dw_ - delsq_ * ($7_ = (z_[ip1_ - 1] / dtipsq_), $7_ * $7_);
            }
          }
          else {
            temp_ = z_[ii_ - 1] / (work_[ii_ - 1] * delta_[ii_ - 1]);
            if (orgati_) {
              dpsi_ = dpsi_ + temp_ * temp_;
            }
            else {
              dphi_ = dphi_ + temp_ * temp_;
            }
            c_ = w_ - dtisq_ * dpsi_ - dtipsq_ * dphi_;
          }
          a_ = (dtipsq_ + dtisq_) * w_ - dtipsq_ * dtisq_ * dw_;
          b_ = dtipsq_ * dtisq_ * w_;
          if (c_ == 0.0) {
            if (a_ == 0.0) {
              if (! (swtch_)) {
                if (orgati_) {
                  a_ = z_[(*i_) - 1] * z_[(*i_) - 1] + dtipsq_ * dtipsq_ * (dpsi_ + dphi_);
                }
                else {
                  a_ = z_[ip1_ - 1] * z_[ip1_ - 1] + dtisq_ * dtisq_ * (dpsi_ + dphi_);
                }
              }
              else {
                a_ = dtisq_ * dtisq_ * dpsi_ + dtipsq_ * dtipsq_ * dphi_;
              }
            }
            eta_ = b_ / a_;
          }
          else if (a_ <= 0.0) {
            eta_ = (a_ - sqrt (_abs (a_ * a_ - 4.0 * b_ * c_))) / (2.0 * c_);
          }
          else {
            eta_ = 2.0 * b_ / (a_ + sqrt (_abs (a_ * a_ - 4.0 * b_ * c_)));
          }
        }
      }
      if (w_ * eta_ >= 0.0) {
        eta_ = -w_ / dw_;
      }
      eta_ = eta_ / ((*sigma_) + sqrt ((*sigma_) * (*sigma_) + eta_));
      temp_ = tau_ + eta_;
      if (temp_ > sgub_ || temp_ < sglb_) {
        if (w_ < 0.0) {
          eta_ = (sgub_ - tau_) / 2.0;
        }
        else {
          eta_ = (sglb_ - tau_) / 2.0;
        }
        if (geomavg_) {
          if (w_ < 0.0) {
            if (tau_ > 0.0) {
              eta_ = sqrt (sgub_ * tau_) - tau_;
            }
          }
          else {
            if (sglb_ > 0.0) {
              eta_ = sqrt (sglb_ * tau_) - tau_;
            }
          }
        }
      }
      prew_ = w_;
      tau_ = tau_ + eta_;
      (*sigma_) = (*sigma_) + eta_;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        work_[j_ - 1] = work_[j_ - 1] + eta_;
        delta_[j_ - 1] = delta_[j_ - 1] - eta_;
      }
      dpsi_ = 0.0;
      psi_ = 0.0;
      erretm_ = 0.0;
      for (j_ = 1; j_ <= iim1_; (j_)++) {
        temp_ = z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
        psi_ = psi_ + z_[j_ - 1] * temp_;
        dpsi_ = dpsi_ + temp_ * temp_;
        erretm_ = erretm_ + psi_;
      }
      erretm_ = _abs (erretm_);
      dphi_ = 0.0;
      phi_ = 0.0;
      for (j_ = (*n_); j_ >= iip1_; (j_)--) {
        temp_ = z_[j_ - 1] / (work_[j_ - 1] * delta_[j_ - 1]);
        phi_ = phi_ + z_[j_ - 1] * temp_;
        dphi_ = dphi_ + temp_ * temp_;
        erretm_ = erretm_ + phi_;
      }
      tau2_ = work_[ii_ - 1] * delta_[ii_ - 1];
      temp_ = z_[ii_ - 1] / tau2_;
      dw_ = dpsi_ + dphi_ + temp_ * temp_;
      temp_ = z_[ii_ - 1] * temp_;
      w_ = rhoinv_ + phi_ + psi_ + temp_;
      erretm_ = 8.0 * (phi_ - psi_) + erretm_ + 2.0 * rhoinv_ + 3.0 * _abs (temp_);
      if (w_ * prew_ > 0.0 && _abs (w_) > _abs (prew_) / 10.0) {
        swtch_ = ! (swtch_);
      }
    }
    (*info_) = 1;
  }
  _l240:;
  _l0:;
  __calls[47].calls++;
  return 0;
}

int_4 _dlasd5 (int_4 _p_ i_, real_8 _p_ d_, real_8 _p_ z_, real_8 _p_ delta_, real_8 _p_ rho_, real_8 _p_ dsigma_, 
real_8 _p_ work_)
{
  static real_8 b_, c_, del_, delsq_, tau_, w_;
  del_ = d_[1] - d_[0];
  delsq_ = del_ * (d_[1] + d_[0]);
  if ((*i_) == 1) {
    w_ = 1.0 + 4.0 * (*rho_) * (z_[1] * z_[1] / (d_[0] + 3.0 * d_[1]) - z_[0] * z_[0] / (3.0 * d_[0] + d_[1])) / del_;
    if (w_ > 0.0) {
      b_ = delsq_ + (*rho_) * (z_[0] * z_[0] + z_[1] * z_[1]);
      c_ = (*rho_) * z_[0] * z_[0] * delsq_;
      tau_ = 2.0 * c_ / (b_ + sqrt (_abs (b_ * b_ - 4.0 * c_)));
      tau_ = tau_ / (d_[0] + sqrt (d_[0] * d_[0] + tau_));
      (*dsigma_) = d_[0] + tau_;
      delta_[0] = -tau_;
      delta_[1] = del_ - tau_;
      work_[0] = 2.0 * d_[0] + tau_;
      work_[1] = (d_[0] + tau_) + d_[1];
    }
    else {
      b_ = -delsq_ + (*rho_) * (z_[0] * z_[0] + z_[1] * z_[1]);
      c_ = (*rho_) * z_[1] * z_[1] * delsq_;
      if (b_ > 0.0) {
        tau_ = -2.0 * c_ / (b_ + sqrt (b_ * b_ + 4.0 * c_));
      }
      else {
        tau_ = (b_ - sqrt (b_ * b_ + 4.0 * c_)) / 2.0;
      }
      tau_ = tau_ / (d_[1] + sqrt (_abs (d_[1] * d_[1] + tau_)));
      (*dsigma_) = d_[1] + tau_;
      delta_[0] = -(del_ + tau_);
      delta_[1] = -tau_;
      work_[0] = d_[0] + tau_ + d_[1];
      work_[1] = 2.0 * d_[1] + tau_;
    }
  }
  else {
    b_ = -delsq_ + (*rho_) * (z_[0] * z_[0] + z_[1] * z_[1]);
    c_ = (*rho_) * z_[1] * z_[1] * delsq_;
    if (b_ > 0.0) {
      tau_ = (b_ + sqrt (b_ * b_ + 4.0 * c_)) / 2.0;
    }
    else {
      tau_ = 2.0 * c_ / (-b_ + sqrt (b_ * b_ + 4.0 * c_));
    }
    tau_ = tau_ / (d_[1] + sqrt (d_[1] * d_[1] + tau_));
    (*dsigma_) = d_[1] + tau_;
    delta_[0] = -(del_ + tau_);
    delta_[1] = -tau_;
    work_[0] = d_[0] + tau_ + d_[1];
    work_[1] = 2.0 * d_[1] + tau_;
  }
  __calls[48].calls++;
  return 0;
}

int_4 _dlasd6 (int_4 _p_ icompq_, int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, real_8 _p_ d_, real_8 _p_ vf_, real_8 
_p_ vl_, real_8 _p_ alpha_, real_8 _p_ beta_, int_4 _p_ idxq_, int_4 _p_ perm_, int_4 _p_ givptr_, int_4 _p_ givcol_, 
int_4 _p_ ldgcol_, real_8 _p_ givnum_, int_4 _p_ ldgnum_, real_8 _p_ poles_, real_8 _p_ difl_, real_8 _p_ difr_, real_8 
_p_ z_, int_4 _p_ k_, real_8 _p_ c_, real_8 _p_ s_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_)
{
  static int_4 i_, idx_, idxc_, idxp_, isigma_, ivfw_, ivlw_, iw_, m_, n_, n1_, n2_;
  static real_8 orgnrm_;
  int_4 $0_;
  real_8 $1_, $2_;
  extern int_4 _dcopy ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  n_ = (*nl_) + (*nr_) + 1;
  m_ = n_ + (*sqre_);
  if (((*icompq_) < 0) || ((*icompq_) > 1)) {
    (*info_) = -1;
  }
  else if ((*nl_) < 1) {
    (*info_) = -2;
  }
  else if ((*nr_) < 1) {
    (*info_) = -3;
  }
  else if (((*sqre_) < 0) || ((*sqre_) > 1)) {
    (*info_) = -4;
  }
  else if ((*ldgcol_) < n_) {
    (*info_) = -14;
  }
  else if ((*ldgnum_) < n_) {
    (*info_) = -16;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_81, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  isigma_ = 1;
  iw_ = isigma_ + n_;
  ivfw_ = iw_ + m_;
  ivlw_ = ivfw_ + m_;
  idx_ = 1;
  idxc_ = idx_ + n_;
  idxp_ = idxc_ + n_;
  orgnrm_ = _max (_abs ((*alpha_)), _abs ((*beta_)));
  d_[(*nl_) + 1 - 1] = 0.0;
  for (i_ = 1; i_ <= n_; (i_)++) {
    if (_abs (d_[i_ - 1]) > orgnrm_) {
      orgnrm_ = _abs (d_[i_ - 1]);
    }
  }
  (void) _dlascl (_dc_9, &_k0, &_k0, &orgnrm_, ($1_ = 1.0, &$1_), &n_, &_k1, d_, &n_, info_);
  (*alpha_) = (*alpha_) / orgnrm_;
  (*beta_) = (*beta_) / orgnrm_;
  (void) _dlasd7 (icompq_, nl_, nr_, sqre_, k_, d_, z_, &work_[iw_ - 1], vf_, &work_[ivfw_ - 1], vl_, &work_[ivlw_ - 1], 
  alpha_, beta_, &work_[isigma_ - 1], &iwork_[idx_ - 1], &iwork_[idxp_ - 1], idxq_, perm_, givptr_, givcol_, ldgcol_, 
  givnum_, ldgnum_, c_, s_, info_);
  (void) _dlasd8 (icompq_, k_, d_, z_, vf_, vl_, difl_, difr_, ldgnum_, &work_[isigma_ - 1], &work_[iw_ - 1], info_);
  if ((*info_) != 0) {
    goto _l0;
  }
  if ((*icompq_) == 1) {
    (void) _dcopy (k_, d_, &_k1, &poles_[0 + ((*ldgnum_)) * ((0))], &_k1);
    (void) _dcopy (k_, &work_[isigma_ - 1], &_k1, &poles_[0 + ((*ldgnum_)) * ((1))], &_k1);
  }
  (void) _dlascl (_dc_9, &_k0, &_k0, ($2_ = 1.0, &$2_), &orgnrm_, &n_, &_k1, d_, &n_, info_);
  n1_ = (*k_);
  n2_ = n_ - (*k_);
  (void) _dlamrg (&n1_, &n2_, d_, &_k1, &_km1, idxq_);
  _l0:;
  __calls[49].calls++;
  return 0;
}

int_4 _dlasd7 (int_4 _p_ icompq_, int_4 _p_ nl_, int_4 _p_ nr_, int_4 _p_ sqre_, int_4 _p_ k_, real_8 _p_ d_, real_8 
_p_ z_, real_8 _p_ zw_, real_8 _p_ vf_, real_8 _p_ vfw_, real_8 _p_ vl_, real_8 _p_ vlw_, real_8 _p_ alpha_, real_8 _p_ 
beta_, real_8 _p_ dsigma_, int_4 _p_ idx_, int_4 _p_ idxp_, int_4 _p_ idxq_, int_4 _p_ perm_, int_4 _p_ givptr_, int_4 
_p_ givcol_, int_4 _p_ ldgcol_, real_8 _p_ givnum_, int_4 _p_ ldgnum_, real_8 _p_ c_, real_8 _p_ s_, int_4 _p_ info_)
{
  static int_4 i_, idxi_, idxj_, idxjp_, j_, jp_, jprev_, k2_, m_, n_, nlp1_, nlp2_;
  static real_8 eps_, hlftol_, tau_, tol_, z1_;
  int_4 $0_, $1_, $2_, $3_, $4_;
  extern int_4 _dcopy ();
  extern int_4 _drot ();
  extern int_4 _xerbla ();
  extern real_8 _dlamch ();
  (*info_) = 0;
  n_ = (*nl_) + (*nr_) + 1;
  m_ = n_ + (*sqre_);
  if (((*icompq_) < 0) || ((*icompq_) > 1)) {
    (*info_) = -1;
  }
  else if ((*nl_) < 1) {
    (*info_) = -2;
  }
  else if ((*nr_) < 1) {
    (*info_) = -3;
  }
  else if (((*sqre_) < 0) || ((*sqre_) > 1)) {
    (*info_) = -4;
  }
  else if ((*ldgcol_) < n_) {
    (*info_) = -22;
  }
  else if ((*ldgnum_) < n_) {
    (*info_) = -24;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_82, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  nlp1_ = (*nl_) + 1;
  nlp2_ = (*nl_) + 2;
  if ((*icompq_) == 1) {
    (*givptr_) = 0;
  }
  z1_ = (*alpha_) * vl_[nlp1_ - 1];
  vl_[nlp1_ - 1] = 0.0;
  tau_ = vf_[nlp1_ - 1];
  for (i_ = (*nl_); i_ >= 1; (i_)--) {
    z_[i_ + 1 - 1] = (*alpha_) * vl_[i_ - 1];
    vl_[i_ - 1] = 0.0;
    vf_[i_ + 1 - 1] = vf_[i_ - 1];
    d_[i_ + 1 - 1] = d_[i_ - 1];
    idxq_[i_ + 1 - 1] = idxq_[i_ - 1] + 1;
  }
  vf_[0] = tau_;
  for (i_ = nlp2_; i_ <= m_; (i_)++) {
    z_[i_ - 1] = (*beta_) * vf_[i_ - 1];
    vf_[i_ - 1] = 0.0;
  }
  for (i_ = nlp2_; i_ <= n_; (i_)++) {
    idxq_[i_ - 1] = idxq_[i_ - 1] + nlp1_;
  }
  for (i_ = 2; i_ <= n_; (i_)++) {
    dsigma_[i_ - 1] = d_[idxq_[i_ - 1] - 1];
    zw_[i_ - 1] = z_[idxq_[i_ - 1] - 1];
    vfw_[i_ - 1] = vf_[idxq_[i_ - 1] - 1];
    vlw_[i_ - 1] = vl_[idxq_[i_ - 1] - 1];
  }
  (void) _dlamrg (nl_, nr_, &dsigma_[1], &_k1, &_k1, &idx_[1]);
  for (i_ = 2; i_ <= n_; (i_)++) {
    idxi_ = 1 + idx_[i_ - 1];
    d_[i_ - 1] = dsigma_[idxi_ - 1];
    z_[i_ - 1] = zw_[idxi_ - 1];
    vf_[i_ - 1] = vfw_[idxi_ - 1];
    vl_[i_ - 1] = vlw_[idxi_ - 1];
  }
  eps_ = _dlamch (_dc_10);
  tol_ = _max (_abs ((*alpha_)), _abs ((*beta_)));
  tol_ = 8.0 * 8.0 * eps_ * _max (_abs (d_[n_ - 1]), tol_);
  (*k_) = 1;
  k2_ = n_ + 1;
  for (j_ = 2; j_ <= n_; (j_)++) {
    if (_abs (z_[j_ - 1]) <= tol_) {
      k2_ = k2_ - 1;
      idxp_[k2_ - 1] = j_;
      if (j_ == n_) {
        goto _l100;
      }
    }
    else {
      jprev_ = j_;
      goto _l70;
    }
  }
  _l70:;
  j_ = jprev_;
  _l80:;
  j_ = j_ + 1;
  if (j_ > n_) {
    goto _l90;
  }
  if (_abs (z_[j_ - 1]) <= tol_) {
    k2_ = k2_ - 1;
    idxp_[k2_ - 1] = j_;
  }
  else {
    if (_abs (d_[j_ - 1] - d_[jprev_ - 1]) <= tol_) {
      (*s_) = z_[jprev_ - 1];
      (*c_) = z_[j_ - 1];
      tau_ = _dlapy2 (c_, s_);
      z_[j_ - 1] = tau_;
      z_[jprev_ - 1] = 0.0;
      (*c_) = (*c_) / tau_;
      (*s_) = -(*s_) / tau_;
      if ((*icompq_) == 1) {
        (*givptr_) = (*givptr_) + 1;
        idxjp_ = idxq_[idx_[jprev_ - 1] + 1 - 1];
        idxj_ = idxq_[idx_[j_ - 1] + 1 - 1];
        if (idxjp_ <= nlp1_) {
          idxjp_ = idxjp_ - 1;
        }
        if (idxj_ <= nlp1_) {
          idxj_ = idxj_ - 1;
        }
        givcol_[(*givptr_) - 1 + ((*ldgcol_)) * ((1))] = idxjp_;
        givcol_[(*givptr_) - 1 + ((*ldgcol_)) * ((0))] = idxj_;
        givnum_[(*givptr_) - 1 + ((*ldgnum_)) * ((1))] = (*c_);
        givnum_[(*givptr_) - 1 + ((*ldgnum_)) * ((0))] = (*s_);
      }
      (void) _drot (&_k1, &vf_[jprev_ - 1], &_k1, &vf_[j_ - 1], &_k1, c_, s_);
      (void) _drot (&_k1, &vl_[jprev_ - 1], &_k1, &vl_[j_ - 1], &_k1, c_, s_);
      k2_ = k2_ - 1;
      idxp_[k2_ - 1] = jprev_;
      jprev_ = j_;
    }
    else {
      (*k_) = (*k_) + 1;
      zw_[(*k_) - 1] = z_[jprev_ - 1];
      dsigma_[(*k_) - 1] = d_[jprev_ - 1];
      idxp_[(*k_) - 1] = jprev_;
      jprev_ = j_;
    }
  }
  goto _l80;
  _l90:;
  (*k_) = (*k_) + 1;
  zw_[(*k_) - 1] = z_[jprev_ - 1];
  dsigma_[(*k_) - 1] = d_[jprev_ - 1];
  idxp_[(*k_) - 1] = jprev_;
  _l100:;
  for (j_ = 2; j_ <= n_; (j_)++) {
    jp_ = idxp_[j_ - 1];
    dsigma_[j_ - 1] = d_[jp_ - 1];
    vfw_[j_ - 1] = vf_[jp_ - 1];
    vlw_[j_ - 1] = vl_[jp_ - 1];
  }
  if ((*icompq_) == 1) {
    for (j_ = 2; j_ <= n_; (j_)++) {
      jp_ = idxp_[j_ - 1];
      perm_[j_ - 1] = idxq_[idx_[jp_ - 1] + 1 - 1];
      if (perm_[j_ - 1] <= nlp1_) {
        perm_[j_ - 1] = perm_[j_ - 1] - 1;
      }
    }
  }
  (void) _dcopy (($1_ = n_ - (*k_), &$1_), &dsigma_[(*k_) + 1 - 1], &_k1, &d_[(*k_) + 1 - 1], &_k1);
  dsigma_[0] = 0.0;
  hlftol_ = tol_ / 2.0;
  if (_abs (dsigma_[1]) <= hlftol_) {
    dsigma_[1] = hlftol_;
  }
  if (m_ > n_) {
    z_[0] = _dlapy2 (&z1_, &z_[m_ - 1]);
    if (z_[0] <= tol_) {
      (*c_) = 1.0;
      (*s_) = 0.0;
      z_[0] = tol_;
    }
    else {
      (*c_) = z1_ / z_[0];
      (*s_) = -z_[m_ - 1] / z_[0];
    }
    (void) _drot (&_k1, &vf_[m_ - 1], &_k1, &vf_[0], &_k1, c_, s_);
    (void) _drot (&_k1, &vl_[m_ - 1], &_k1, &vl_[0], &_k1, c_, s_);
  }
  else {
    if (_abs (z1_) <= tol_) {
      z_[0] = tol_;
    }
    else {
      z_[0] = z1_;
    }
  }
  (void) _dcopy (($2_ = (*k_) - 1, &$2_), &zw_[1], &_k1, &z_[1], &_k1);
  (void) _dcopy (($3_ = n_ - 1, &$3_), &vfw_[1], &_k1, &vf_[1], &_k1);
  (void) _dcopy (($4_ = n_ - 1, &$4_), &vlw_[1], &_k1, &vl_[1], &_k1);
  _l0:;
  __calls[50].calls++;
  return 0;
}
int_4 _dlasd8 (int_4 _p_ icompq_, int_4 _p_ k_, real_8 _p_ d_, real_8 _p_ z_, real_8 _p_ vf_, real_8 _p_ vl_, real_8 
_p_ difl_, real_8 _p_ difr_, int_4 _p_ lddifr_, real_8 _p_ dsigma_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, iwk1_, iwk2_, iwk2i_, iwk3_, iwk3i_, j_;
  static real_8 diflj_, difrj_, dj_, dsigj_, dsigjp_, rho_, temp_;
  int_4 $0_;
  real_8 $1_, $2_, $3_;
  extern int_4 _dcopy ();
  extern int_4 _xerbla ();
  extern real_8 _ddot ();
  extern real_8 _dlamc3 ();
  extern real_8 _dnrm2 ();
  (*info_) = 0;
  if (((*icompq_) < 0) || ((*icompq_) > 1)) {
    (*info_) = -1;
  }
  else if ((*k_) < 1) {
    (*info_) = -2;
  }
  else if ((*lddifr_) < (*k_)) {
    (*info_) = -9;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_83, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*k_) == 1) {
    d_[0] = _abs (z_[0]);
    difl_[0] = d_[0];
    if ((*icompq_) == 1) {
      difl_[1] = 1.0;
      difr_[0 + ((*lddifr_)) * ((1))] = 1.0;
    }
    goto _l0;
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    dsigma_[i_ - 1] = _dlamc3 (&dsigma_[i_ - 1], &dsigma_[i_ - 1]) - dsigma_[i_ - 1];
  }
  iwk1_ = 1;
  iwk2_ = iwk1_ + (*k_);
  iwk3_ = iwk2_ + (*k_);
  iwk2i_ = iwk2_ - 1;
  iwk3i_ = iwk3_ - 1;
  rho_ = _dnrm2 (k_, z_, &_k1);
  (void) _dlascl (_dc_9, &_k0, &_k0, &rho_, ($1_ = 1.0, &$1_), k_, &_k1, z_, k_, info_);
  rho_ = rho_ * rho_;
  (void) _dlaset (_dc_7, k_, &_k1, ($2_ = 1.0, &$2_), ($3_ = 1.0, &$3_), &work_[iwk3_ - 1], k_);
  for (j_ = 1; j_ <= (*k_); (j_)++) {
    (void) _dlasd4 (k_, &j_, dsigma_, z_, &work_[iwk1_ - 1], &rho_, &d_[j_ - 1], &work_[iwk2_ - 1], info_);
    if ((*info_) != 0) {
      goto _l0;
    }
    work_[iwk3i_ + j_ - 1] = work_[iwk3i_ + j_ - 1] * work_[j_ - 1] * work_[iwk2i_ + j_ - 1];
    difl_[j_ - 1] = -work_[j_ - 1];
    difr_[j_ - 1 + ((*lddifr_)) * ((0))] = -work_[j_ + 1 - 1];
    for (i_ = 1; i_ <= j_ - 1; (i_)++) {
      work_[iwk3i_ + i_ - 1] = work_[iwk3i_ + i_ - 1] * work_[i_ - 1] * work_[iwk2i_ + i_ - 1] / (dsigma_[i_ - 1] - 
      dsigma_[j_ - 1]) / (dsigma_[i_ - 1] + dsigma_[j_ - 1]);
    }
    for (i_ = j_ + 1; i_ <= (*k_); (i_)++) {
      work_[iwk3i_ + i_ - 1] = work_[iwk3i_ + i_ - 1] * work_[i_ - 1] * work_[iwk2i_ + i_ - 1] / (dsigma_[i_ - 1] - 
      dsigma_[j_ - 1]) / (dsigma_[i_ - 1] + dsigma_[j_ - 1]);
    }
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    z_[i_ - 1] = _sign (sqrt (_abs (work_[iwk3i_ + i_ - 1])), z_[i_ - 1]);
  }
  for (j_ = 1; j_ <= (*k_); (j_)++) {
    diflj_ = difl_[j_ - 1];
    dj_ = d_[j_ - 1];
    dsigj_ = -dsigma_[j_ - 1];
    if (j_ < (*k_)) {
      difrj_ = -difr_[j_ - 1 + ((*lddifr_)) * ((0))];
      dsigjp_ = -dsigma_[j_ + 1 - 1];
    }
    work_[j_ - 1] = -z_[j_ - 1] / diflj_ / (dsigma_[j_ - 1] + dj_);
    for (i_ = 1; i_ <= j_ - 1; (i_)++) {
      work_[i_ - 1] = z_[i_ - 1] / (_dlamc3 (&dsigma_[i_ - 1], &dsigj_) - diflj_) / (dsigma_[i_ - 1] + dj_);
    }
    for (i_ = j_ + 1; i_ <= (*k_); (i_)++) {
      work_[i_ - 1] = z_[i_ - 1] / (_dlamc3 (&dsigma_[i_ - 1], &dsigjp_) + difrj_) / (dsigma_[i_ - 1] + dj_);
    }
    temp_ = _dnrm2 (k_, work_, &_k1);
    work_[iwk2i_ + j_ - 1] = _ddot (k_, work_, &_k1, vf_, &_k1) / temp_;
    work_[iwk3i_ + j_ - 1] = _ddot (k_, work_, &_k1, vl_, &_k1) / temp_;
    if ((*icompq_) == 1) {
      difr_[j_ - 1 + ((*lddifr_)) * ((1))] = temp_;
    }
  }
  (void) _dcopy (k_, &work_[iwk2_ - 1], &_k1, vf_, &_k1);
  (void) _dcopy (k_, &work_[iwk3_ - 1], &_k1, vl_, &_k1);
  _l0:;
  __calls[51].calls++;
  return 0;
}

int_4 _dlasda (int_4 _p_ icompq_, int_4 _p_ smlsiz_, int_4 _p_ n_, int_4 _p_ sqre_, real_8 _p_ d_, real_8 _p_ e_, 
real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ vt_, int_4 _p_ k_, real_8 _p_ difl_, real_8 _p_ difr_, real_8 _p_ z_, real_8 
_p_ poles_, int_4 _p_ givptr_, int_4 _p_ givcol_, int_4 _p_ ldgcol_, int_4 _p_ perm_, real_8 _p_ givnum_, real_8 _p_ c_
, real_8 _p_ s_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_)
{
  static int_4 i_, i1_, ic_, idxq_, idxqi_, im1_, inode_, itemp_, iwk_, j_, lf_, ll_, lvl_, lvl2_, m_, ncc_, nd_, ndb1_, 
  ndiml_, ndimr_, nl_, nlf_, nlp1_, nlvl_, nr_, nrf_, nrp1_, nru_, nwork1_, nwork2_, smlszp_, sqrei_, vf_, vfi_, vl_, 
  vli_;
  static real_8 alpha_, beta_;
  int_4 $0_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_;
  extern int_4 _dcopy ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if (((*icompq_) < 0) || ((*icompq_) > 1)) {
    (*info_) = -1;
  }
  else if ((*smlsiz_) < 3) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -3;
  }
  else if (((*sqre_) < 0) || ((*sqre_) > 1)) {
    (*info_) = -4;
  }
  else if ((*ldu_) < ((*n_) + (*sqre_))) {
    (*info_) = -8;
  }
  else if ((*ldgcol_) < (*n_)) {
    (*info_) = -17;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_84, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  m_ = (*n_) + (*sqre_);
  if ((*n_) <= (*smlsiz_)) {
    if ((*icompq_) == 0) {
      (void) _dlasdq (_dc_0, sqre_, n_, &_k0, &_k0, &_k0, d_, e_, vt_, ldu_, u_, ldu_, u_, ldu_, work_, info_);
    }
    else {
      (void) _dlasdq (_dc_0, sqre_, n_, &m_, n_, &_k0, d_, e_, vt_, ldu_, u_, ldu_, u_, ldu_, work_, info_);
    }
    goto _l0;
  }
  inode_ = 1;
  ndiml_ = inode_ + (*n_);
  ndimr_ = ndiml_ + (*n_);
  idxq_ = ndimr_ + (*n_);
  iwk_ = idxq_ + (*n_);
  ncc_ = 0;
  nru_ = 0;
  smlszp_ = (*smlsiz_) + 1;
  vf_ = 1;
  vl_ = vf_ + m_;
  nwork1_ = vl_ + m_;
  nwork2_ = nwork1_ + smlszp_ * smlszp_;
  (void) _dlasdt (n_, &nlvl_, &nd_, &iwork_[inode_ - 1], &iwork_[ndiml_ - 1], &iwork_[ndimr_ - 1], smlsiz_);
  ndb1_ = (nd_ + 1) / 2;
  for (i_ = ndb1_; i_ <= nd_; (i_)++) {
    i1_ = i_ - 1;
    ic_ = iwork_[inode_ + i1_ - 1];
    nl_ = iwork_[ndiml_ + i1_ - 1];
    nlp1_ = nl_ + 1;
    nr_ = iwork_[ndimr_ + i1_ - 1];
    nlf_ = ic_ - nl_;
    nrf_ = ic_ + 1;
    idxqi_ = idxq_ + nlf_ - 2;
    vfi_ = vf_ + nlf_ - 1;
    vli_ = vl_ + nlf_ - 1;
    sqrei_ = 1;
    if ((*icompq_) == 0) {
      (void) _dlaset (_dc_7, &nlp1_, &nlp1_, ($1_ = 0.0, &$1_), ($2_ = 1.0, &$2_), &work_[nwork1_ - 1], &smlszp_);
      (void) _dlasdq (_dc_0, &sqrei_, &nl_, &nlp1_, &nru_, &ncc_, &d_[nlf_ - 1], &e_[nlf_ - 1], &work_[nwork1_ - 1], 
      &smlszp_, &work_[nwork2_ - 1], &nl_, &work_[nwork2_ - 1], &nl_, &work_[nwork2_ - 1], info_);
      itemp_ = nwork1_ + nl_ * smlszp_;
      (void) _dcopy (&nlp1_, &work_[nwork1_ - 1], &_k1, &work_[vfi_ - 1], &_k1);
      (void) _dcopy (&nlp1_, &work_[itemp_ - 1], &_k1, &work_[vli_ - 1], &_k1);
    }
    else {
      (void) _dlaset (_dc_7, &nl_, &nl_, ($3_ = 0.0, &$3_), ($4_ = 1.0, &$4_), &u_[nlf_ - 1 + ((*ldu_)) * ((0))], ldu_);
      (void) _dlaset (_dc_7, &nlp1_, &nlp1_, ($5_ = 0.0, &$5_), ($6_ = 1.0, &$6_), &vt_[nlf_ - 1 + ((*ldu_)) * ((0))], ldu_)
      ;
      (void) _dlasdq (_dc_0, &sqrei_, &nl_, &nlp1_, &nl_, &ncc_, &d_[nlf_ - 1], &e_[nlf_ - 1], &vt_[nlf_ - 1 + ((*ldu_)) * 
      ((0))], ldu_, &u_[nlf_ - 1 + ((*ldu_)) * ((0))], ldu_, &u_[nlf_ - 1 + ((*ldu_)) * ((0))], ldu_, &work_[nwork1_ - 1], 
      info_);
      (void) _dcopy (&nlp1_, &vt_[nlf_ - 1 + ((*ldu_)) * ((0))], &_k1, &work_[vfi_ - 1], &_k1);
      (void) _dcopy (&nlp1_, &vt_[nlf_ - 1 + ((*ldu_)) * ((nlp1_ - 1))], &_k1, &work_[vli_ - 1], &_k1);
    }
    if ((*info_) != 0) {
      goto _l0;
    }
    for (j_ = 1; j_ <= nl_; (j_)++) {
      iwork_[idxqi_ + j_ - 1] = j_;
    }
    if ((i_ == nd_) && ((*sqre_) == 0)) {
      sqrei_ = 0;
    }
    else {
      sqrei_ = 1;
    }
    idxqi_ = idxqi_ + nlp1_;
    vfi_ = vfi_ + nlp1_;
    vli_ = vli_ + nlp1_;
    nrp1_ = nr_ + sqrei_;
    if ((*icompq_) == 0) {
      (void) _dlaset (_dc_7, &nrp1_, &nrp1_, ($7_ = 0.0, &$7_), ($8_ = 1.0, &$8_), &work_[nwork1_ - 1], &smlszp_);
      (void) _dlasdq (_dc_0, &sqrei_, &nr_, &nrp1_, &nru_, &ncc_, &d_[nrf_ - 1], &e_[nrf_ - 1], &work_[nwork1_ - 1], 
      &smlszp_, &work_[nwork2_ - 1], &nr_, &work_[nwork2_ - 1], &nr_, &work_[nwork2_ - 1], info_);
      itemp_ = nwork1_ + (nrp1_ - 1) * smlszp_;
      (void) _dcopy (&nrp1_, &work_[nwork1_ - 1], &_k1, &work_[vfi_ - 1], &_k1);
      (void) _dcopy (&nrp1_, &work_[itemp_ - 1], &_k1, &work_[vli_ - 1], &_k1);
    }
    else {
      (void) _dlaset (_dc_7, &nr_, &nr_, ($9_ = 0.0, &$9_), ($10_ = 1.0, &$10_), &u_[nrf_ - 1 + ((*ldu_)) * ((0))], ldu_);
      (void) _dlaset (_dc_7, &nrp1_, &nrp1_, ($11_ = 0.0, &$11_), ($12_ = 1.0, &$12_), &vt_[nrf_ - 1 + ((*ldu_)) * ((0))], 
      ldu_);
      (void) _dlasdq (_dc_0, &sqrei_, &nr_, &nrp1_, &nr_, &ncc_, &d_[nrf_ - 1], &e_[nrf_ - 1], &vt_[nrf_ - 1 + ((*ldu_)) * 
      ((0))], ldu_, &u_[nrf_ - 1 + ((*ldu_)) * ((0))], ldu_, &u_[nrf_ - 1 + ((*ldu_)) * ((0))], ldu_, &work_[nwork1_ - 1], 
      info_);
      (void) _dcopy (&nrp1_, &vt_[nrf_ - 1 + ((*ldu_)) * ((0))], &_k1, &work_[vfi_ - 1], &_k1);
      (void) _dcopy (&nrp1_, &vt_[nrf_ - 1 + ((*ldu_)) * ((nrp1_ - 1))], &_k1, &work_[vli_ - 1], &_k1);
    }
    if ((*info_) != 0) {
      goto _l0;
    }
    for (j_ = 1; j_ <= nr_; (j_)++) {
      iwork_[idxqi_ + j_ - 1] = j_;
    }
  }
  j_ = _up_int_4 (2, nlvl_);
  for (lvl_ = nlvl_; lvl_ >= 1; (lvl_)--) {
    lvl2_ = lvl_ * 2 - 1;
    if (lvl_ == 1) {
      lf_ = 1;
      ll_ = 1;
    }
    else {
      lf_ = _up_int_4 (2, (lvl_ - 1));
      ll_ = 2 * lf_ - 1;
    }
    for (i_ = lf_; i_ <= ll_; (i_)++) {
      im1_ = i_ - 1;
      ic_ = iwork_[inode_ + im1_ - 1];
      nl_ = iwork_[ndiml_ + im1_ - 1];
      nr_ = iwork_[ndimr_ + im1_ - 1];
      nlf_ = ic_ - nl_;
      nrf_ = ic_ + 1;
      if (i_ == ll_) {
        sqrei_ = (*sqre_);
      }
      else {
        sqrei_ = 1;
      }
      vfi_ = vf_ + nlf_ - 1;
      vli_ = vl_ + nlf_ - 1;
      idxqi_ = idxq_ + nlf_ - 1;
      alpha_ = d_[ic_ - 1];
      beta_ = e_[ic_ - 1];
      if ((*icompq_) == 0) {
        (void) _dlasd6 (icompq_, &nl_, &nr_, &sqrei_, &d_[nlf_ - 1], &work_[vfi_ - 1], &work_[vli_ - 1], &alpha_, &beta_, 
        &iwork_[idxqi_ - 1], perm_, &givptr_[0], givcol_, ldgcol_, givnum_, ldu_, poles_, difl_, difr_, z_, &k_[0], &c_[0], 
        &s_[0], &work_[nwork1_ - 1], &iwork_[iwk_ - 1], info_);
      }
      else {
        j_ = j_ - 1;
        (void) _dlasd6 (icompq_, &nl_, &nr_, &sqrei_, &d_[nlf_ - 1], &work_[vfi_ - 1], &work_[vli_ - 1], &alpha_, &beta_, 
        &iwork_[idxqi_ - 1], &perm_[nlf_ - 1 + ((*ldgcol_)) * ((lvl_ - 1))], &givptr_[j_ - 1], &givcol_[nlf_ - 1 + ((*ldgcol_)) 
        * ((lvl2_ - 1))], ldgcol_, &givnum_[nlf_ - 1 + ((*ldu_)) * ((lvl2_ - 1))], ldu_, &poles_[nlf_ - 1 + ((*ldu_)) * ((lvl2_ 
        - 1))], &difl_[nlf_ - 1 + ((*ldu_)) * ((lvl_ - 1))], &difr_[nlf_ - 1 + ((*ldu_)) * ((lvl2_ - 1))], &z_[nlf_ - 1 + 
        ((*ldu_)) * ((lvl_ - 1))], &k_[j_ - 1], &c_[j_ - 1], &s_[j_ - 1], &work_[nwork1_ - 1], &iwork_[iwk_ - 1], info_);
      }
      if ((*info_) != 0) {
        goto _l0;
      }
    }
  }
  _l0:;
  __calls[52].calls++;
  return 0;
}

int_4 _dlasdq (char _p_ uplo_, int_4 _p_ sqre_, int_4 _p_ n_, int_4 _p_ ncvt_, int_4 _p_ nru_, int_4 _p_ ncc_, real_8 
_p_ d_, real_8 _p_ e_, real_8 _p_ vt_, int_4 _p_ ldvt_, real_8 _p_ u_, int_4 _p_ ldu_, real_8 _p_ c_, int_4 _p_ ldc_, 
real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, isub_, iuplo_, j_, np1_, sqre1_;
  static logical_4 rotate_;
  static real_8 cs_, r_, smin_, sn_;
  int_4 $0_;
  extern int_4 _dswap ();
  extern int_4 _xerbla ();
  extern logical_4 _lsame ();
  (*info_) = 0;
  iuplo_ = 0;
  if (_lsame (uplo_, _dc_0)) {
    iuplo_ = 1;
  }
  if (_lsame (uplo_, _dc_1)) {
    iuplo_ = 2;
  }
  if (iuplo_ == 0) {
    (*info_) = -1;
  }
  else if (((*sqre_) < 0) || ((*sqre_) > 1)) {
    (*info_) = -2;
  }
  else if ((*n_) < 0) {
    (*info_) = -3;
  }
  else if ((*ncvt_) < 0) {
    (*info_) = -4;
  }
  else if ((*nru_) < 0) {
    (*info_) = -5;
  }
  else if ((*ncc_) < 0) {
    (*info_) = -6;
  }
  else if (((*ncvt_) == 0 && (*ldvt_) < 1) || ((*ncvt_) > 0 && (*ldvt_) < _max (1, (*n_)))) {
    (*info_) = -10;
  }
  else if ((*ldu_) < _max (1, (*nru_))) {
    (*info_) = -12;
  }
  else if (((*ncc_) == 0 && (*ldc_) < 1) || ((*ncc_) > 0 && (*ldc_) < _max (1, (*n_)))) {
    (*info_) = -14;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_85, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  rotate_ = ((*ncvt_) > 0) || ((*nru_) > 0) || ((*ncc_) > 0);
  np1_ = (*n_) + 1;
  sqre1_ = (*sqre_);
  if ((iuplo_ == 1) && (sqre1_ == 1)) {
    for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
      (void) _dlartg (&d_[i_ - 1], &e_[i_ - 1], &cs_, &sn_, &r_);
      d_[i_ - 1] = r_;
      e_[i_ - 1] = sn_ * d_[i_ + 1 - 1];
      d_[i_ + 1 - 1] = cs_ * d_[i_ + 1 - 1];
      if (rotate_) {
        work_[i_ - 1] = cs_;
        work_[(*n_) + i_ - 1] = sn_;
      }
    }
    (void) _dlartg (&d_[(*n_) - 1], &e_[(*n_) - 1], &cs_, &sn_, &r_);
    d_[(*n_) - 1] = r_;
    e_[(*n_) - 1] = 0.0;
    if (rotate_) {
      work_[(*n_) - 1] = cs_;
      work_[(*n_) + (*n_) - 1] = sn_;
    }
    iuplo_ = 2;
    sqre1_ = 0;
    if ((*ncvt_) > 0) {
      (void) _dlasr (_dc_1, _dc_11, _dc_16, &np1_, ncvt_, &work_[0], &work_[np1_ - 1], vt_, ldvt_);
    }
  }
  if (iuplo_ == 2) {
    for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
      (void) _dlartg (&d_[i_ - 1], &e_[i_ - 1], &cs_, &sn_, &r_);
      d_[i_ - 1] = r_;
      e_[i_ - 1] = sn_ * d_[i_ + 1 - 1];
      d_[i_ + 1 - 1] = cs_ * d_[i_ + 1 - 1];
      if (rotate_) {
        work_[i_ - 1] = cs_;
        work_[(*n_) + i_ - 1] = sn_;
      }
    }
    if (sqre1_ == 1) {
      (void) _dlartg (&d_[(*n_) - 1], &e_[(*n_) - 1], &cs_, &sn_, &r_);
      d_[(*n_) - 1] = r_;
      if (rotate_) {
        work_[(*n_) - 1] = cs_;
        work_[(*n_) + (*n_) - 1] = sn_;
      }
    }
    if ((*nru_) > 0) {
      if (sqre1_ == 0) {
        (void) _dlasr (_dc_15, _dc_11, _dc_16, nru_, n_, &work_[0], &work_[np1_ - 1], u_, ldu_);
      }
      else {
        (void) _dlasr (_dc_15, _dc_11, _dc_16, nru_, &np1_, &work_[0], &work_[np1_ - 1], u_, ldu_);
      }
    }
    if ((*ncc_) > 0) {
      if (sqre1_ == 0) {
        (void) _dlasr (_dc_1, _dc_11, _dc_16, n_, ncc_, &work_[0], &work_[np1_ - 1], c_, ldc_);
      }
      else {
        (void) _dlasr (_dc_1, _dc_11, _dc_16, &np1_, ncc_, &work_[0], &work_[np1_ - 1], c_, ldc_);
      }
    }
  }
  (void) _dbdsqr (_dc_0, n_, ncvt_, nru_, ncc_, d_, e_, vt_, ldvt_, u_, ldu_, c_, ldc_, work_, info_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    isub_ = i_;
    smin_ = d_[i_ - 1];
    for (j_ = i_ + 1; j_ <= (*n_); (j_)++) {
      if (d_[j_ - 1] < smin_) {
        isub_ = j_;
        smin_ = d_[j_ - 1];
      }
    }
    if (isub_ != i_) {
      d_[isub_ - 1] = d_[i_ - 1];
      d_[i_ - 1] = smin_;
      if ((*ncvt_) > 0) {
        (void) _dswap (ncvt_, &vt_[isub_ - 1 + ((*ldvt_)) * ((0))], ldvt_, &vt_[i_ - 1 + ((*ldvt_)) * ((0))], ldvt_);
      }
      if ((*nru_) > 0) {
        (void) _dswap (nru_, &u_[0 + ((*ldu_)) * ((isub_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((i_ - 1))], &_k1);
      }
      if ((*ncc_) > 0) {
        (void) _dswap (ncc_, &c_[isub_ - 1 + ((*ldc_)) * ((0))], ldc_, &c_[i_ - 1 + ((*ldc_)) * ((0))], ldc_);
      }
    }
  }
  _l0:;
  __calls[53].calls++;
  return 0;
}

int_4 _dlasdt (int_4 _p_ n_, int_4 _p_ lvl_, int_4 _p_ nd_, int_4 _p_ inode_, int_4 _p_ ndiml_, int_4 _p_ ndimr_, int_4 
_p_ msub_)
{
  static int_4 i_, il_, ir_, llst_, maxn_, ncrnt_, nlvl_;
  static real_8 temp_;
  maxn_ = _max (1, (*n_));
  temp_ = log ((real_8) (maxn_) / (real_8) ((*msub_) + 1)) / 
  6.9314718055994530941723212145817656807550013436025525412068000949339362e-1;
  (*lvl_) = (int_4) (_aintd (temp_)) + 1;
  i_ = (*n_) / 2;
  inode_[0] = i_ + 1;
  ndiml_[0] = i_;
  ndimr_[0] = (*n_) - i_ - 1;
  il_ = 0;
  ir_ = 1;
  llst_ = 1;
  for (nlvl_ = 1; nlvl_ <= (*lvl_) - 1; (nlvl_)++) {
    for (i_ = 0; i_ <= llst_ - 1; (i_)++) {
      il_ = il_ + 2;
      ir_ = ir_ + 2;
      ncrnt_ = llst_ + i_;
      ndiml_[il_ - 1] = ndiml_[ncrnt_ - 1] / 2;
      ndimr_[il_ - 1] = ndiml_[ncrnt_ - 1] - ndiml_[il_ - 1] - 1;
      inode_[il_ - 1] = inode_[ncrnt_ - 1] - ndimr_[il_ - 1] - 1;
      ndiml_[ir_ - 1] = ndimr_[ncrnt_ - 1] / 2;
      ndimr_[ir_ - 1] = ndimr_[ncrnt_ - 1] - ndiml_[ir_ - 1] - 1;
      inode_[ir_ - 1] = inode_[ncrnt_ - 1] + ndiml_[ir_ - 1] + 1;
    }
    llst_ = llst_ * 2;
  }
  (*nd_) = llst_ * 2 - 1;
  __calls[54].calls++;
  return 0;
}

int_4 _dlaset (char _p_ uplo_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ alpha_, real_8 _p_ beta_, real_8 _p_ a_, int_4 
_p_ lda_)
{
  static int_4 i_, j_;
  extern logical_4 _lsame ();
  if (_lsame (uplo_, _dc_0)) {
    for (j_ = 2; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= _min (j_ - 1, (*m_)); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
  }
  else if (_lsame (uplo_, _dc_1)) {
    for (j_ = 1; j_ <= _min ((*m_), (*n_)); (j_)++) {
      for (i_ = j_ + 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = (*alpha_);
      }
    }
  }
  for (i_ = 1; i_ <= _min ((*m_), (*n_)); (i_)++) {
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = (*beta_);
  }
  __calls[55].calls++;
  return 0;
}

int_4 _dlasq1 (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, iinfo_;
  static real_8 eps_, scale_, safmin_, sigmn_, sigmx_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern int_4 _dcopy ();
  extern int_4 _xerbla ();
  extern real_8 _dlamch ();
  (*info_) = 0;
  if ((*n_) < 0) {
    (*info_) = -1;
    (void) _xerbla (_dc_86, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  else if ((*n_) == 0) {
    goto _l0;
  }
  else if ((*n_) == 1) {
    d_[0] = _abs (d_[0]);
    goto _l0;
  }
  else if ((*n_) == 2) {
    (void) _dlas2 (&d_[0], &e_[0], &d_[1], &sigmn_, &sigmx_);
    d_[0] = sigmx_;
    d_[1] = sigmn_;
    goto _l0;
  }
  sigmx_ = 0.0;
  for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
    d_[i_ - 1] = _abs (d_[i_ - 1]);
    sigmx_ = _max (sigmx_, _abs (e_[i_ - 1]));
  }
  d_[(*n_) - 1] = _abs (d_[(*n_) - 1]);
  if (sigmx_ == 0.0) {
    (void) _dlasrt (_dc_71, n_, d_, &iinfo_);
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sigmx_ = _max (sigmx_, d_[i_ - 1]);
  }
  eps_ = _dlamch (_dc_87);
  safmin_ = _dlamch (_dc_14);
  scale_ = sqrt (eps_ / safmin_);
  (void) _dcopy (n_, d_, &_k1, &work_[0], ($1_ = 2, &$1_));
  (void) _dcopy (($2_ = (*n_) - 1, &$2_), e_, &_k1, &work_[1], ($3_ = 2, &$3_));
  (void) _dlascl (_dc_9, &_k0, &_k0, &sigmx_, &scale_, ($4_ = 2 * (*n_) - 1, &$4_), &_k1, work_, ($5_ = 2 * (*n_) - 1, 
  &$5_), &iinfo_);
  for (i_ = 1; i_ <= 2 * (*n_) - 1; (i_)++) {
    work_[i_ - 1] = (work_[i_ - 1] * work_[i_ - 1]);
  }
  work_[2 * (*n_) - 1] = 0.0;
  (void) _dlasq2 (n_, work_, info_);
  if ((*info_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      d_[i_ - 1] = sqrt (work_[i_ - 1]);
    }
    (void) _dlascl (_dc_9, &_k0, &_k0, &scale_, &sigmx_, n_, &_k1, d_, n_, &iinfo_);
  }
  else if ((*info_) == 2) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      d_[i_ - 1] = sqrt (work_[2 * i_ - 1 - 1]);
      e_[i_ - 1] = sqrt (work_[2 * i_ - 1]);
    }
    (void) _dlascl (_dc_9, &_k0, &_k0, &scale_, &sigmx_, n_, &_k1, d_, n_, &iinfo_);
    (void) _dlascl (_dc_9, &_k0, &_k0, &scale_, &sigmx_, n_, &_k1, e_, n_, &iinfo_);
  }
  _l0:;
  __calls[56].calls++;
  return 0;
}

int_4 _dlasq2 (int_4 _p_ n_, real_8 _p_ z_, int_4 _p_ info_)
{
  static int_4 i0_, i1_, i4_, iinfo_, ipn4_, iter_, iwhila_, iwhilb_, k_, kmin_, n0_, n1_, nbig_, ndiv_, nfail_, pp_, 
  splt_, ttype_;
  static logical_4 ieee_;
  static real_8 d_, dee_, deemin_, desig_, dmin_, dmin1_, dmin2_, dn_, dn1_, dn2_, e_, emax_, emin_, eps_, g_, oldemn_, 
  qmax_, qmin_, s_, safmin_, sigma_, t_, tau_, temp_, tol_, tol2_, trace_, zmax_, tempe_, tempq_;
  int_4 $0_, $1_, $2_, $3_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_;
  real_8 $4_;
  extern int_4 _xerbla ();
  extern real_8 _dlamch ();
  (*info_) = 0;
  eps_ = _dlamch (_dc_87);
  safmin_ = _dlamch (_dc_14);
  tol_ = eps_ * 100.0;
  tol2_ = (tol_ * tol_);
  if ((*n_) < 0) {
    (*info_) = -1;
    (void) _xerbla (_dc_88, &_k1);
    goto _l0;
  }
  else if ((*n_) == 0) {
    goto _l0;
  }
  else if ((*n_) == 1) {
    if (z_[0] < 0.0) {
      (*info_) = -201;
      (void) _xerbla (_dc_88, ($0_ = 2, &$0_));
    }
    goto _l0;
  }
  else if ((*n_) == 2) {
    if (z_[1] < 0.0 || z_[2] < 0.0) {
      (*info_) = -2;
      (void) _xerbla (_dc_88, ($1_ = 2, &$1_));
      goto _l0;
    }
    else if (z_[2] > z_[0]) {
      d_ = z_[2];
      z_[2] = z_[0];
      z_[0] = d_;
    }
    z_[4] = z_[0] + z_[1] + z_[2];
    if (z_[1] > z_[2] * tol2_) {
      t_ = 0.5 * ((z_[0] - z_[2]) + z_[1]);
      s_ = z_[2] * (z_[1] / t_);
      if (s_ <= t_) {
        s_ = z_[2] * (z_[1] / (t_ * (1.0 + sqrt (1.0 + s_ / t_))));
      }
      else {
        s_ = z_[2] * (z_[1] / (t_ + sqrt (t_) * sqrt (t_ + s_)));
      }
      t_ = z_[0] + (s_ + z_[1]);
      z_[2] = z_[2] * (z_[0] / t_);
      z_[0] = t_;
    }
    z_[1] = z_[2];
    z_[5] = z_[1] + z_[0];
    goto _l0;
  }
  z_[2 * (*n_) - 1] = 0.0;
  emin_ = z_[1];
  qmax_ = 0.0;
  zmax_ = 0.0;
  d_ = 0.0;
  e_ = 0.0;
  for (k_ = 1; (2 > 0 ? k_ <= 2 * ((*n_) - 1) : k_ >= 2 * ((*n_) - 1)); k_ += 2) {
    if (z_[k_ - 1] < 0.0) {
      (*info_) = -(200 + k_);
      (void) _xerbla (_dc_88, ($2_ = 2, &$2_));
      goto _l0;
    }
    else if (z_[k_ + 1 - 1] < 0.0) {
      (*info_) = -(200 + k_ + 1);
      (void) _xerbla (_dc_88, ($3_ = 2, &$3_));
      goto _l0;
    }
    d_ = d_ + z_[k_ - 1];
    e_ = e_ + z_[k_ + 1 - 1];
    qmax_ = _max (qmax_, z_[k_ - 1]);
    emin_ = _min (emin_, z_[k_ + 1 - 1]);
    zmax_ = ($4_ = _max (qmax_, zmax_), _max ($4_, z_[k_ + 1 - 1]));
  }
  if (z_[2 * (*n_) - 1 - 1] < 0.0) {
    (*info_) = -(200 + 2 * (*n_) - 1);
    (void) _xerbla (_dc_88, ($5_ = 2, &$5_));
    goto _l0;
  }
  d_ = d_ + z_[2 * (*n_) - 1 - 1];
  qmax_ = _max (qmax_, z_[2 * (*n_) - 1 - 1]);
  zmax_ = _max (qmax_, zmax_);
  if (e_ == 0.0) {
    for (k_ = 2; k_ <= (*n_); (k_)++) {
      z_[k_ - 1] = z_[2 * k_ - 1 - 1];
    }
    (void) _dlasrt (_dc_71, n_, z_, &iinfo_);
    z_[2 * (*n_) - 1 - 1] = d_;
    goto _l0;
  }
  trace_ = d_ + e_;
  if (trace_ == 0.0) {
    z_[2 * (*n_) - 1 - 1] = 0.0;
    goto _l0;
  }
  ieee_ = _ilaenv (($6_ = 10, &$6_), _dc_88, _dc_2, &_k1, ($7_ = 2, &$7_), ($8_ = 3, &$8_), ($9_ = 4, &$9_)) == 1 && 
  _ilaenv (($10_ = 11, &$10_), _dc_88, _dc_2, &_k1, ($11_ = 2, &$11_), ($12_ = 3, &$12_), ($13_ = 4, &$13_)) == 1;
  for (k_ = 2 * (*n_); (-2 > 0 ? k_ <= 2 : k_ >= 2); k_ += -2) {
    z_[2 * k_ - 1] = 0.0;
    z_[2 * k_ - 1 - 1] = z_[k_ - 1];
    z_[2 * k_ - 2 - 1] = 0.0;
    z_[2 * k_ - 3 - 1] = z_[k_ - 1 - 1];
  }
  i0_ = 1;
  n0_ = (*n_);
  if (1.5 * z_[4 * i0_ - 3 - 1] < z_[4 * n0_ - 3 - 1]) {
    ipn4_ = 4 * (i0_ + n0_);
    for (i4_ = 4 * i0_; (4 > 0 ? i4_ <= 2 * (i0_ + n0_ - 1) : i4_ >= 2 * (i0_ + n0_ - 1)); i4_ += 4) {
      temp_ = z_[i4_ - 3 - 1];
      z_[i4_ - 3 - 1] = z_[ipn4_ - i4_ - 3 - 1];
      z_[ipn4_ - i4_ - 3 - 1] = temp_;
      temp_ = z_[i4_ - 1 - 1];
      z_[i4_ - 1 - 1] = z_[ipn4_ - i4_ - 5 - 1];
      z_[ipn4_ - i4_ - 5 - 1] = temp_;
    }
  }
  pp_ = 0;
  for (k_ = 1; k_ <= 2; (k_)++) {
    d_ = z_[4 * n0_ + pp_ - 3 - 1];
    for (i4_ = 4 * (n0_ - 1) + pp_; (-4 > 0 ? i4_ <= 4 * i0_ + pp_ : i4_ >= 4 * i0_ + pp_); i4_ += -4) {
      if (z_[i4_ - 1 - 1] <= tol2_ * d_) {
        z_[i4_ - 1 - 1] = 0.0;
        d_ = z_[i4_ - 3 - 1];
      }
      else {
        d_ = z_[i4_ - 3 - 1] * (d_ / (d_ + z_[i4_ - 1 - 1]));
      }
    }
    emin_ = z_[4 * i0_ + pp_ + 1 - 1];
    d_ = z_[4 * i0_ + pp_ - 3 - 1];
    for (i4_ = 4 * i0_ + pp_; (4 > 0 ? i4_ <= 4 * (n0_ - 1) + pp_ : i4_ >= 4 * (n0_ - 1) + pp_); i4_ += 4) {
      z_[i4_ - 2 * pp_ - 2 - 1] = d_ + z_[i4_ - 1 - 1];
      if (z_[i4_ - 1 - 1] <= tol2_ * d_) {
        z_[i4_ - 1 - 1] = 0.0;
        z_[i4_ - 2 * pp_ - 2 - 1] = d_;
        z_[i4_ - 2 * pp_ - 1] = 0.0;
        d_ = z_[i4_ + 1 - 1];
      }
      else if (safmin_ * z_[i4_ + 1 - 1] < z_[i4_ - 2 * pp_ - 2 - 1] && safmin_ * z_[i4_ - 2 * pp_ - 2 - 1] < z_[i4_ + 1 - 
        1]) {
        temp_ = z_[i4_ + 1 - 1] / z_[i4_ - 2 * pp_ - 2 - 1];
        z_[i4_ - 2 * pp_ - 1] = z_[i4_ - 1 - 1] * temp_;
        d_ = d_ * temp_;
      }
      else {
        z_[i4_ - 2 * pp_ - 1] = z_[i4_ + 1 - 1] * (z_[i4_ - 1 - 1] / z_[i4_ - 2 * pp_ - 2 - 1]);
        d_ = z_[i4_ + 1 - 1] * (d_ / z_[i4_ - 2 * pp_ - 2 - 1]);
      }
      emin_ = _min (emin_, z_[i4_ - 2 * pp_ - 1]);
    }
    z_[4 * n0_ - pp_ - 2 - 1] = d_;
    qmax_ = z_[4 * i0_ - pp_ - 2 - 1];
    for (i4_ = 4 * i0_ - pp_ + 2; (4 > 0 ? i4_ <= 4 * n0_ - pp_ - 2 : i4_ >= 4 * n0_ - pp_ - 2); i4_ += 4) {
      qmax_ = _max (qmax_, z_[i4_ - 1]);
    }
    pp_ = 1 - pp_;
  }
  ttype_ = 0;
  dmin1_ = 0.0;
  dmin2_ = 0.0;
  dn_ = 0.0;
  dn1_ = 0.0;
  dn2_ = 0.0;
  g_ = 0.0;
  tau_ = 0.0;
  iter_ = 2;
  nfail_ = 0;
  ndiv_ = 2 * (n0_ - i0_);
  for (iwhila_ = 1; iwhila_ <= (*n_) + 1; (iwhila_)++) {
    if (n0_ < 1) {
      goto _l170;
    }
    desig_ = 0.0;
    if (n0_ == (*n_)) {
      sigma_ = 0.0;
    }
    else {
      sigma_ = -z_[4 * n0_ - 1 - 1];
    }
    if (sigma_ < 0.0) {
      (*info_) = 1;
      goto _l0;
    }
    emax_ = 0.0;
    if (n0_ > i0_) {
      emin_ = _abs (z_[4 * n0_ - 5 - 1]);
    }
    else {
      emin_ = 0.0;
    }
    qmin_ = z_[4 * n0_ - 3 - 1];
    qmax_ = qmin_;
    for (i4_ = 4 * n0_; (-4 > 0 ? i4_ <= 8 : i4_ >= 8); i4_ += -4) {
      if (z_[i4_ - 5 - 1] <= 0.0) {
        goto _l100;
      }
      if (qmin_ >= 4.0 * emax_) {
        qmin_ = _min (qmin_, z_[i4_ - 3 - 1]);
        emax_ = _max (emax_, z_[i4_ - 5 - 1]);
      }
      qmax_ = _max (qmax_, z_[i4_ - 7 - 1] + z_[i4_ - 5 - 1]);
      emin_ = _min (emin_, z_[i4_ - 5 - 1]);
    }
    i4_ = 4;
    _l100:;
    i0_ = i4_ / 4;
    pp_ = 0;
    if (n0_ - i0_ > 1) {
      dee_ = z_[4 * i0_ - 3 - 1];
      deemin_ = dee_;
      kmin_ = i0_;
      for (i4_ = 4 * i0_ + 1; (4 > 0 ? i4_ <= 4 * n0_ - 3 : i4_ >= 4 * n0_ - 3); i4_ += 4) {
        dee_ = z_[i4_ - 1] * (dee_ / (dee_ + z_[i4_ - 2 - 1]));
        if (dee_ <= deemin_) {
          deemin_ = dee_;
          kmin_ = (i4_ + 3) / 4;
        }
      }
      if ((kmin_ - i0_) * 2 < n0_ - kmin_ && deemin_ <= 0.5 * z_[4 * n0_ - 3 - 1]) {
        ipn4_ = 4 * (i0_ + n0_);
        pp_ = 2;
        for (i4_ = 4 * i0_; (4 > 0 ? i4_ <= 2 * (i0_ + n0_ - 1) : i4_ >= 2 * (i0_ + n0_ - 1)); i4_ += 4) {
          temp_ = z_[i4_ - 3 - 1];
          z_[i4_ - 3 - 1] = z_[ipn4_ - i4_ - 3 - 1];
          z_[ipn4_ - i4_ - 3 - 1] = temp_;
          temp_ = z_[i4_ - 2 - 1];
          z_[i4_ - 2 - 1] = z_[ipn4_ - i4_ - 2 - 1];
          z_[ipn4_ - i4_ - 2 - 1] = temp_;
          temp_ = z_[i4_ - 1 - 1];
          z_[i4_ - 1 - 1] = z_[ipn4_ - i4_ - 5 - 1];
          z_[ipn4_ - i4_ - 5 - 1] = temp_;
          temp_ = z_[i4_ - 1];
          z_[i4_ - 1] = z_[ipn4_ - i4_ - 4 - 1];
          z_[ipn4_ - i4_ - 4 - 1] = temp_;
        }
      }
    }
    dmin_ = -_max (0.0, qmin_ - 2.0 * sqrt (qmin_) * sqrt (emax_));
    nbig_ = 100 * (n0_ - i0_ + 1);
    for (iwhilb_ = 1; iwhilb_ <= nbig_; (iwhilb_)++) {
      if (i0_ > n0_) {
        goto _l150;
      }
      (void) _dlasq3 (&i0_, &n0_, z_, &pp_, &dmin_, &sigma_, &desig_, &qmax_, &nfail_, &iter_, &ndiv_, &ieee_, &ttype_, 
      &dmin1_, &dmin2_, &dn_, &dn1_, &dn2_, &g_, &tau_);
      pp_ = 1 - pp_;
      if (pp_ == 0 && n0_ - i0_ >= 3) {
        if (z_[4 * n0_ - 1] <= tol2_ * qmax_ || z_[4 * n0_ - 1 - 1] <= tol2_ * sigma_) {
          splt_ = i0_ - 1;
          qmax_ = z_[4 * i0_ - 3 - 1];
          emin_ = z_[4 * i0_ - 1 - 1];
          oldemn_ = z_[4 * i0_ - 1];
          for (i4_ = 4 * i0_; (4 > 0 ? i4_ <= 4 * (n0_ - 3) : i4_ >= 4 * (n0_ - 3)); i4_ += 4) {
            if (z_[i4_ - 1] <= tol2_ * z_[i4_ - 3 - 1] || z_[i4_ - 1 - 1] <= tol2_ * sigma_) {
              z_[i4_ - 1 - 1] = -sigma_;
              splt_ = i4_ / 4;
              qmax_ = 0.0;
              emin_ = z_[i4_ + 3 - 1];
              oldemn_ = z_[i4_ + 4 - 1];
            }
            else {
              qmax_ = _max (qmax_, z_[i4_ + 1 - 1]);
              emin_ = _min (emin_, z_[i4_ - 1 - 1]);
              oldemn_ = _min (oldemn_, z_[i4_ - 1]);
            }
          }
          z_[4 * n0_ - 1 - 1] = emin_;
          z_[4 * n0_ - 1] = oldemn_;
          i0_ = splt_ + 1;
        }
      }
    }
    (*info_) = 2;
    i1_ = i0_;
    n1_ = n0_;
    _l145:;
    tempq_ = z_[4 * i0_ - 3 - 1];
    z_[4 * i0_ - 3 - 1] = z_[4 * i0_ - 3 - 1] + sigma_;
    for (k_ = i0_ + 1; k_ <= n0_; (k_)++) {
      tempe_ = z_[4 * k_ - 5 - 1];
      z_[4 * k_ - 5 - 1] = z_[4 * k_ - 5 - 1] * (tempq_ / z_[4 * k_ - 7 - 1]);
      tempq_ = z_[4 * k_ - 3 - 1];
      z_[4 * k_ - 3 - 1] = z_[4 * k_ - 3 - 1] + sigma_ + tempe_ - z_[4 * k_ - 5 - 1];
    }
    if (i1_ > 1) {
      n1_ = i1_ - 1;
      while ((i1_ >= 2) && (z_[4 * i1_ - 5 - 1] >= 0.0)) {
        i1_ = i1_ - 1;
      }
      sigma_ = -z_[4 * n1_ - 1 - 1];
      goto _l145;
    }
    for (k_ = 1; k_ <= (*n_); (k_)++) {
      z_[2 * k_ - 1 - 1] = z_[4 * k_ - 3 - 1];
      if (k_ < n0_) {
        z_[2 * k_ - 1] = z_[4 * k_ - 1 - 1];
      }
      else {
        z_[2 * k_ - 1] = 0;
      }
    }
    goto _l0;
    _l150:;
  }
  (*info_) = 3;
  goto _l0;
  _l170:;
  for (k_ = 2; k_ <= (*n_); (k_)++) {
    z_[k_ - 1] = z_[4 * k_ - 3 - 1];
  }
  (void) _dlasrt (_dc_71, n_, z_, &iinfo_);
  e_ = 0.0;
  for (k_ = (*n_); k_ >= 1; (k_)--) {
    e_ = e_ + z_[k_ - 1];
  }
  z_[2 * (*n_) + 1 - 1] = trace_;
  z_[2 * (*n_) + 2 - 1] = e_;
  z_[2 * (*n_) + 3 - 1] = (real_8) (iter_);
  z_[2 * (*n_) + 4 - 1] = (real_8) (ndiv_) / (real_8) (((*n_) * (*n_)));
  z_[2 * (*n_) + 5 - 1] = 100.0 * nfail_ / (real_8) (iter_);
  _l0:;
  __calls[57].calls++;
  return 0;
}

int_4 _dlasq3 (int_4 _p_ i0_, int_4 _p_ n0_, real_8 _p_ z_, int_4 _p_ pp_, real_8 _p_ dmin_, real_8 _p_ sigma_, real_8 
_p_ desig_, real_8 _p_ qmax_, int_4 _p_ nfail_, int_4 _p_ iter_, int_4 _p_ ndiv_, logical_4 _p_ ieee_, int_4 _p_ ttype_
, real_8 _p_ dmin1_, real_8 _p_ dmin2_, real_8 _p_ dn_, real_8 _p_ dn1_, real_8 _p_ dn2_, real_8 _p_ g_, real_8 _p_ 
tau_)
{
  static int_4 ipn4_, j4_, n0in_, nn_;
  static real_8 eps_, s_, t_, temp_, tol_, tol2_;
  real_8 $0_, $1_, $2_;
  extern real_8 _dlamch ();
  n0in_ = (*n0_);
  eps_ = _dlamch (_dc_87);
  tol_ = eps_ * 100.0;
  tol2_ = (tol_ * tol_);
  _l10:;
  if ((*n0_) < (*i0_)) {
    goto _l0;
  }
  if ((*n0_) == (*i0_)) {
    goto _l20;
  }
  nn_ = 4 * (*n0_) + (*pp_);
  if ((*n0_) == ((*i0_) + 1)) {
    goto _l40;
  }
  if (z_[nn_ - 5 - 1] > tol2_ * ((*sigma_) + z_[nn_ - 3 - 1]) && z_[nn_ - 2 * (*pp_) - 4 - 1] > tol2_ * z_[nn_ - 7 - 1]) 
    {
    goto _l30;
  }
  _l20:;
  z_[4 * (*n0_) - 3 - 1] = z_[4 * (*n0_) + (*pp_) - 3 - 1] + (*sigma_);
  (*n0_) = (*n0_) - 1;
  goto _l10;
  _l30:;
  if (z_[nn_ - 9 - 1] > tol2_ * (*sigma_) && z_[nn_ - 2 * (*pp_) - 8 - 1] > tol2_ * z_[nn_ - 11 - 1]) {
    goto _l50;
  }
  _l40:;
  if (z_[nn_ - 3 - 1] > z_[nn_ - 7 - 1]) {
    s_ = z_[nn_ - 3 - 1];
    z_[nn_ - 3 - 1] = z_[nn_ - 7 - 1];
    z_[nn_ - 7 - 1] = s_;
  }
  t_ = 0.5 * ((z_[nn_ - 7 - 1] - z_[nn_ - 3 - 1]) + z_[nn_ - 5 - 1]);
  if (z_[nn_ - 5 - 1] > z_[nn_ - 3 - 1] * tol2_ && t_ != 0.0) {
    s_ = z_[nn_ - 3 - 1] * (z_[nn_ - 5 - 1] / t_);
    if (s_ <= t_) {
      s_ = z_[nn_ - 3 - 1] * (z_[nn_ - 5 - 1] / (t_ * (1.0 + sqrt (1.0 + s_ / t_))));
    }
    else {
      s_ = z_[nn_ - 3 - 1] * (z_[nn_ - 5 - 1] / (t_ + sqrt (t_) * sqrt (t_ + s_)));
    }
    t_ = z_[nn_ - 7 - 1] + (s_ + z_[nn_ - 5 - 1]);
    z_[nn_ - 3 - 1] = z_[nn_ - 3 - 1] * (z_[nn_ - 7 - 1] / t_);
    z_[nn_ - 7 - 1] = t_;
  }
  z_[4 * (*n0_) - 7 - 1] = z_[nn_ - 7 - 1] + (*sigma_);
  z_[4 * (*n0_) - 3 - 1] = z_[nn_ - 3 - 1] + (*sigma_);
  (*n0_) = (*n0_) - 2;
  goto _l10;
  _l50:;
  if ((*pp_) == 2) {
    (*pp_) = 0;
  }
  if ((*dmin_) <= 0.0 || (*n0_) < n0in_) {
    if (1.5 * z_[4 * (*i0_) + (*pp_) - 3 - 1] < z_[4 * (*n0_) + (*pp_) - 3 - 1]) {
      ipn4_ = 4 * ((*i0_) + (*n0_));
      for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 2 * ((*i0_) + (*n0_) - 1) : j4_ >= 2 * ((*i0_) + (*n0_) - 1)); j4_ += 4) {
        temp_ = z_[j4_ - 3 - 1];
        z_[j4_ - 3 - 1] = z_[ipn4_ - j4_ - 3 - 1];
        z_[ipn4_ - j4_ - 3 - 1] = temp_;
        temp_ = z_[j4_ - 2 - 1];
        z_[j4_ - 2 - 1] = z_[ipn4_ - j4_ - 2 - 1];
        z_[ipn4_ - j4_ - 2 - 1] = temp_;
        temp_ = z_[j4_ - 1 - 1];
        z_[j4_ - 1 - 1] = z_[ipn4_ - j4_ - 5 - 1];
        z_[ipn4_ - j4_ - 5 - 1] = temp_;
        temp_ = z_[j4_ - 1];
        z_[j4_ - 1] = z_[ipn4_ - j4_ - 4 - 1];
        z_[ipn4_ - j4_ - 4 - 1] = temp_;
      }
      if ((*n0_) - (*i0_) <= 4) {
        z_[4 * (*n0_) + (*pp_) - 1 - 1] = z_[4 * (*i0_) + (*pp_) - 1 - 1];
        z_[4 * (*n0_) - (*pp_) - 1] = z_[4 * (*i0_) - (*pp_) - 1];
      }
      (*dmin2_) = _min ((*dmin2_), z_[4 * (*n0_) + (*pp_) - 1 - 1]);
      z_[4 * (*n0_) + (*pp_) - 1 - 1] = ($0_ = _min (z_[4 * (*n0_) + (*pp_) - 1 - 1], z_[4 * (*i0_) + (*pp_) - 1 - 1]), _min 
      ($0_, z_[4 * (*i0_) + (*pp_) + 3 - 1]));
      z_[4 * (*n0_) - (*pp_) - 1] = ($1_ = _min (z_[4 * (*n0_) - (*pp_) - 1], z_[4 * (*i0_) - (*pp_) - 1]), _min ($1_, z_[4 * 
      (*i0_) - (*pp_) + 4 - 1]));
      (*qmax_) = ($2_ = _max ((*qmax_), z_[4 * (*i0_) + (*pp_) - 3 - 1]), _max ($2_, z_[4 * (*i0_) + (*pp_) + 1 - 1]));
      (*dmin_) = 0.0;
    }
  }
  (void) _dlasq4 (i0_, n0_, z_, pp_, &n0in_, dmin_, dmin1_, dmin2_, dn_, dn1_, dn2_, tau_, ttype_, g_);
  _l70:;
  (void) _dlasq5 (i0_, n0_, z_, pp_, tau_, sigma_, dmin_, dmin1_, dmin2_, dn_, dn1_, dn2_, ieee_, &eps_);
  (*ndiv_) = (*ndiv_) + ((*n0_) - (*i0_) + 2);
  (*iter_) = (*iter_) + 1;
  if ((*dmin_) >= 0.0 && (*dmin1_) >= 0.0) {
    goto _l90;
  }
  else if ((*dmin_) < 0.0 && (*dmin1_) > 0.0 && z_[4 * ((*n0_) - 1) - (*pp_) - 1] < tol_ * ((*sigma_) + (*dn1_)) && _abs 
    ((*dn_)) < tol_ * (*sigma_)) {
    z_[4 * ((*n0_) - 1) - (*pp_) + 2 - 1] = 0.0;
    (*dmin_) = 0.0;
    goto _l90;
  }
  else if ((*dmin_) < 0.0) {
    (*nfail_) = (*nfail_) + 1;
    if ((*ttype_) < -22) {
      (*tau_) = 0.0;
    }
    else if ((*dmin1_) > 0.0) {
      (*tau_) = ((*tau_) + (*dmin_)) * (1.0 - 2.0 * eps_);
      (*ttype_) = (*ttype_) - 11;
    }
    else {
      (*tau_) = 0.25 * (*tau_);
      (*ttype_) = (*ttype_) - 12;
    }
    goto _l70;
  }
  else if (_disnan (dmin_)) {
    if ((*tau_) == 0.0) {
      goto _l80;
    }
    else {
      (*tau_) = 0.0;
      goto _l70;
    }
  }
  else {
    goto _l80;
  }
  _l80:;
  (void) _dlasq6 (i0_, n0_, z_, pp_, dmin_, dmin1_, dmin2_, dn_, dn1_, dn2_);
  (*ndiv_) = (*ndiv_) + ((*n0_) - (*i0_) + 2);
  (*iter_) = (*iter_) + 1;
  (*tau_) = 0.0;
  _l90:;
  if ((*tau_) < (*sigma_)) {
    (*desig_) = (*desig_) + (*tau_);
    t_ = (*sigma_) + (*desig_);
    (*desig_) = (*desig_) - (t_ - (*sigma_));
  }
  else {
    t_ = (*sigma_) + (*tau_);
    (*desig_) = (*sigma_) - (t_ - (*tau_)) + (*desig_);
  }
  (*sigma_) = t_;
  _l0:;
  __calls[58].calls++;
  return 0;
}

int_4 _dlasq4 (int_4 _p_ i0_, int_4 _p_ n0_, real_8 _p_ z_, int_4 _p_ pp_, int_4 _p_ n0in_, real_8 _p_ dmin_, real_8 
_p_ dmin1_, real_8 _p_ dmin2_, real_8 _p_ dn_, real_8 _p_ dn1_, real_8 _p_ dn2_, real_8 _p_ tau_, int_4 _p_ ttype_, 
real_8 _p_ g_)
{
  static int_4 i4_, nn_, np_;
  static real_8 a2_, b1_, b2_, gam_, gap1_, gap2_, s_;
  if ((*dmin_) <= 0.0) {
    (*tau_) = -(*dmin_);
    (*ttype_) = -1;
    goto _l0;
  }
  nn_ = 4 * (*n0_) + (*pp_);
  if ((*n0in_) == (*n0_)) {
    if ((*dmin_) == (*dn_) || (*dmin_) == (*dn1_)) {
      b1_ = sqrt (z_[nn_ - 3 - 1]) * sqrt (z_[nn_ - 5 - 1]);
      b2_ = sqrt (z_[nn_ - 7 - 1]) * sqrt (z_[nn_ - 9 - 1]);
      a2_ = z_[nn_ - 7 - 1] + z_[nn_ - 5 - 1];
      if ((*dmin_) == (*dn_) && (*dmin1_) == (*dn1_)) {
        gap2_ = (*dmin2_) - a2_ - (*dmin2_) * 0.25;
        if (gap2_ > 0.0 && gap2_ > b2_) {
          gap1_ = a2_ - (*dn_) - (b2_ / gap2_) * b2_;
        }
        else {
          gap1_ = a2_ - (*dn_) - (b1_ + b2_);
        }
        if (gap1_ > 0.0 && gap1_ > b1_) {
          s_ = _max ((*dn_) - (b1_ / gap1_) * b1_, 0.5 * (*dmin_));
          (*ttype_) = -2;
        }
        else {
          s_ = 0.0;
          if ((*dn_) > b1_) {
            s_ = (*dn_) - b1_;
          }
          if (a2_ > (b1_ + b2_)) {
            s_ = _min (s_, a2_ - (b1_ + b2_));
          }
          s_ = _max (s_, 0.333 * (*dmin_));
          (*ttype_) = -3;
        }
      }
      else {
        (*ttype_) = -4;
        s_ = 0.25 * (*dmin_);
        if ((*dmin_) == (*dn_)) {
          gam_ = (*dn_);
          a2_ = 0.0;
          if (z_[nn_ - 5 - 1] > z_[nn_ - 7 - 1]) {
            goto _l0;
          }
          b2_ = z_[nn_ - 5 - 1] / z_[nn_ - 7 - 1];
          np_ = nn_ - 9;
        }
        else {
          np_ = nn_ - 2 * (*pp_);
          gam_ = (*dn1_);
          if (z_[np_ - 4 - 1] > z_[np_ - 2 - 1]) {
            goto _l0;
          }
          a2_ = z_[np_ - 4 - 1] / z_[np_ - 2 - 1];
          if (z_[nn_ - 9 - 1] > z_[nn_ - 11 - 1]) {
            goto _l0;
          }
          b2_ = z_[nn_ - 9 - 1] / z_[nn_ - 11 - 1];
          np_ = nn_ - 13;
        }
        a2_ = a2_ + b2_;
        for (i4_ = np_; (-4 > 0 ? i4_ <= 4 * (*i0_) - 1 + (*pp_) : i4_ >= 4 * (*i0_) - 1 + (*pp_)); i4_ += -4) {
          if (b2_ == 0.0) {
            goto _l20;
          }
          b1_ = b2_;
          if (z_[i4_ - 1] > z_[i4_ - 2 - 1]) {
            goto _l0;
          }
          b2_ = b2_ * (z_[i4_ - 1] / z_[i4_ - 2 - 1]);
          a2_ = a2_ + b2_;
          if (100.0 * _max (b2_, b1_) < a2_ || 0.563 < a2_) {
            goto _l20;
          }
        }
        _l20:;
        a2_ = 1.05 * a2_;
        if (a2_ < 0.563) {
          s_ = gam_ * (1.0 - sqrt (a2_)) / (1.0 + a2_);
        }
      }
    }
    else if ((*dmin_) == (*dn2_)) {
      (*ttype_) = -5;
      s_ = 0.25 * (*dmin_);
      np_ = nn_ - 2 * (*pp_);
      b1_ = z_[np_ - 2 - 1];
      b2_ = z_[np_ - 6 - 1];
      gam_ = (*dn2_);
      if (z_[np_ - 8 - 1] > b2_ || z_[np_ - 4 - 1] > b1_) {
        goto _l0;
      }
      a2_ = (z_[np_ - 8 - 1] / b2_) * (1.0 + z_[np_ - 4 - 1] / b1_);
      if ((*n0_) - (*i0_) > 2) {
        b2_ = z_[nn_ - 13 - 1] / z_[nn_ - 15 - 1];
        a2_ = a2_ + b2_;
        for (i4_ = nn_ - 17; (-4 > 0 ? i4_ <= 4 * (*i0_) - 1 + (*pp_) : i4_ >= 4 * (*i0_) - 1 + (*pp_)); i4_ += -4) {
          if (b2_ == 0.0) {
            goto _l40;
          }
          b1_ = b2_;
          if (z_[i4_ - 1] > z_[i4_ - 2 - 1]) {
            goto _l0;
          }
          b2_ = b2_ * (z_[i4_ - 1] / z_[i4_ - 2 - 1]);
          a2_ = a2_ + b2_;
          if (100.0 * _max (b2_, b1_) < a2_ || 0.563 < a2_) {
            goto _l40;
          }
        }
        _l40:;
        a2_ = 1.05 * a2_;
      }
      if (a2_ < 0.563) {
        s_ = gam_ * (1.0 - sqrt (a2_)) / (1.0 + a2_);
      }
    }
    else {
      if ((*ttype_) == -6) {
        (*g_) = (*g_) + 0.333 * (1.0 - (*g_));
      }
      else if ((*ttype_) == -18) {
        (*g_) = 8.325e-2;
      }
      else {
        (*g_) = 0.25;
      }
      s_ = (*g_) * (*dmin_);
      (*ttype_) = -6;
    }
  }
  else if ((*n0in_) == ((*n0_) + 1)) {
    if ((*dmin1_) == (*dn1_) && (*dmin2_) == (*dn2_)) {
      (*ttype_) = -7;
      s_ = 0.333 * (*dmin1_);
      if (z_[nn_ - 5 - 1] > z_[nn_ - 7 - 1]) {
        goto _l0;
      }
      b1_ = z_[nn_ - 5 - 1] / z_[nn_ - 7 - 1];
      b2_ = b1_;
      if (b2_ == 0.0) {
        goto _l60;
      }
      for (i4_ = 4 * (*n0_) - 9 + (*pp_); (-4 > 0 ? i4_ <= 4 * (*i0_) - 1 + (*pp_) : i4_ >= 4 * (*i0_) - 1 + (*pp_)); i4_ += 
        -4) {
        a2_ = b1_;
        if (z_[i4_ - 1] > z_[i4_ - 2 - 1]) {
          goto _l0;
        }
        b1_ = b1_ * (z_[i4_ - 1] / z_[i4_ - 2 - 1]);
        b2_ = b2_ + b1_;
        if (100.0 * _max (b1_, a2_) < b2_) {
          goto _l60;
        }
      }
      _l60:;
      b2_ = sqrt (1.05 * b2_);
      a2_ = (*dmin1_) / (1.0 + (b2_ * b2_));
      gap2_ = 0.5 * (*dmin2_) - a2_;
      if (gap2_ > 0.0 && gap2_ > b2_ * a2_) {
        s_ = _max (s_, a2_ * (1.0 - 1.01 * a2_ * (b2_ / gap2_) * b2_));
      }
      else {
        s_ = _max (s_, a2_ * (1.0 - 1.01 * b2_));
        (*ttype_) = -8;
      }
    }
    else {
      s_ = 0.25 * (*dmin1_);
      if ((*dmin1_) == (*dn1_)) {
        s_ = 0.5 * (*dmin1_);
      }
      (*ttype_) = -9;
    }
  }
  else if ((*n0in_) == ((*n0_) + 2)) {
    if ((*dmin2_) == (*dn2_) && 2.0 * z_[nn_ - 5 - 1] < z_[nn_ - 7 - 1]) {
      (*ttype_) = -10;
      s_ = 0.333 * (*dmin2_);
      if (z_[nn_ - 5 - 1] > z_[nn_ - 7 - 1]) {
        goto _l0;
      }
      b1_ = z_[nn_ - 5 - 1] / z_[nn_ - 7 - 1];
      b2_ = b1_;
      if (b2_ == 0.0) {
        goto _l80;
      }
      for (i4_ = 4 * (*n0_) - 9 + (*pp_); (-4 > 0 ? i4_ <= 4 * (*i0_) - 1 + (*pp_) : i4_ >= 4 * (*i0_) - 1 + (*pp_)); i4_ += 
        -4) {
        if (z_[i4_ - 1] > z_[i4_ - 2 - 1]) {
          goto _l0;
        }
        b1_ = b1_ * (z_[i4_ - 1] / z_[i4_ - 2 - 1]);
        b2_ = b2_ + b1_;
        if (100.0 * b1_ < b2_) {
          goto _l80;
        }
      }
      _l80:;
      b2_ = sqrt (1.05 * b2_);
      a2_ = (*dmin2_) / (1.0 + (b2_ * b2_));
      gap2_ = z_[nn_ - 7 - 1] + z_[nn_ - 9 - 1] - sqrt (z_[nn_ - 11 - 1]) * sqrt (z_[nn_ - 9 - 1]) - a2_;
      if (gap2_ > 0.0 && gap2_ > b2_ * a2_) {
        s_ = _max (s_, a2_ * (1.0 - 1.01 * a2_ * (b2_ / gap2_) * b2_));
      }
      else {
        s_ = _max (s_, a2_ * (1.0 - 1.01 * b2_));
      }
    }
    else {
      s_ = 0.25 * (*dmin2_);
      (*ttype_) = -11;
    }
  }
  else if ((*n0in_) > ((*n0_) + 2)) {
    s_ = 0.0;
    (*ttype_) = -12;
  }
  (*tau_) = s_;
  _l0:;
  __calls[59].calls++;
  return 0;
}

int_4 _dlasq5 (int_4 _p_ i0_, int_4 _p_ n0_, real_8 _p_ z_, int_4 _p_ pp_, real_8 _p_ tau_, real_8 _p_ sigma_, real_8 
_p_ dmin_, real_8 _p_ dmin1_, real_8 _p_ dmin2_, real_8 _p_ dn_, real_8 _p_ dnm1_, real_8 _p_ dnm2_, logical_4 _p_ 
ieee_, real_8 _p_ eps_)
{
  static int_4 j4_, j4p2_;
  static real_8 d_, emin_, temp_, dthresh_;
  if (((*n0_) - (*i0_) - 1) <= 0) {
    goto _l0;
  }
  dthresh_ = (*eps_) * ((*sigma_) + (*tau_));
  if ((*tau_) < dthresh_ * 0.5) {
    (*tau_) = 0.0;
  }
  if ((*tau_) != 0.0) {
    j4_ = 4 * (*i0_) + (*pp_) - 3;
    emin_ = z_[j4_ + 4 - 1];
    d_ = z_[j4_ - 1] - (*tau_);
    (*dmin_) = d_;
    (*dmin1_) = -z_[j4_ - 1];
    if ((*ieee_)) {
      if ((*pp_) == 0) {
        for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
          z_[j4_ - 2 - 1] = d_ + z_[j4_ - 1 - 1];
          temp_ = z_[j4_ + 1 - 1] / z_[j4_ - 2 - 1];
          d_ = d_ * temp_ - (*tau_);
          (*dmin_) = _min ((*dmin_), d_);
          z_[j4_ - 1] = z_[j4_ - 1 - 1] * temp_;
          emin_ = _min (z_[j4_ - 1], emin_);
        }
      }
      else {
        for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
          z_[j4_ - 3 - 1] = d_ + z_[j4_ - 1];
          temp_ = z_[j4_ + 2 - 1] / z_[j4_ - 3 - 1];
          d_ = d_ * temp_ - (*tau_);
          (*dmin_) = _min ((*dmin_), d_);
          z_[j4_ - 1 - 1] = z_[j4_ - 1] * temp_;
          emin_ = _min (z_[j4_ - 1 - 1], emin_);
        }
      }
      (*dnm2_) = d_;
      (*dmin2_) = (*dmin_);
      j4_ = 4 * ((*n0_) - 2) - (*pp_);
      j4p2_ = j4_ + 2 * (*pp_) - 1;
      z_[j4_ - 2 - 1] = (*dnm2_) + z_[j4p2_ - 1];
      z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
      (*dnm1_) = z_[j4p2_ + 2 - 1] * ((*dnm2_) / z_[j4_ - 2 - 1]) - (*tau_);
      (*dmin_) = _min ((*dmin_), (*dnm1_));
      (*dmin1_) = (*dmin_);
      j4_ = j4_ + 4;
      j4p2_ = j4_ + 2 * (*pp_) - 1;
      z_[j4_ - 2 - 1] = (*dnm1_) + z_[j4p2_ - 1];
      z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
      (*dn_) = z_[j4p2_ + 2 - 1] * ((*dnm1_) / z_[j4_ - 2 - 1]) - (*tau_);
      (*dmin_) = _min ((*dmin_), (*dn_));
    }
    else {
      if ((*pp_) == 0) {
        for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
          z_[j4_ - 2 - 1] = d_ + z_[j4_ - 1 - 1];
          if (d_ < 0.0) {
            goto _l0;
          }
          else {
            z_[j4_ - 1] = z_[j4_ + 1 - 1] * (z_[j4_ - 1 - 1] / z_[j4_ - 2 - 1]);
            d_ = z_[j4_ + 1 - 1] * (d_ / z_[j4_ - 2 - 1]) - (*tau_);
          }
          (*dmin_) = _min ((*dmin_), d_);
          emin_ = _min (emin_, z_[j4_ - 1]);
        }
      }
      else {
        for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
          z_[j4_ - 3 - 1] = d_ + z_[j4_ - 1];
          if (d_ < 0.0) {
            goto _l0;
          }
          else {
            z_[j4_ - 1 - 1] = z_[j4_ + 2 - 1] * (z_[j4_ - 1] / z_[j4_ - 3 - 1]);
            d_ = z_[j4_ + 2 - 1] * (d_ / z_[j4_ - 3 - 1]) - (*tau_);
          }
          (*dmin_) = _min ((*dmin_), d_);
          emin_ = _min (emin_, z_[j4_ - 1 - 1]);
        }
      }
      (*dnm2_) = d_;
      (*dmin2_) = (*dmin_);
      j4_ = 4 * ((*n0_) - 2) - (*pp_);
      j4p2_ = j4_ + 2 * (*pp_) - 1;
      z_[j4_ - 2 - 1] = (*dnm2_) + z_[j4p2_ - 1];
      if ((*dnm2_) < 0.0) {
        goto _l0;
      }
      else {
        z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
        (*dnm1_) = z_[j4p2_ + 2 - 1] * ((*dnm2_) / z_[j4_ - 2 - 1]) - (*tau_);
      }
      (*dmin_) = _min ((*dmin_), (*dnm1_));
      (*dmin1_) = (*dmin_);
      j4_ = j4_ + 4;
      j4p2_ = j4_ + 2 * (*pp_) - 1;
      z_[j4_ - 2 - 1] = (*dnm1_) + z_[j4p2_ - 1];
      if ((*dnm1_) < 0.0) {
        goto _l0;
      }
      else {
        z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
        (*dn_) = z_[j4p2_ + 2 - 1] * ((*dnm1_) / z_[j4_ - 2 - 1]) - (*tau_);
      }
      (*dmin_) = _min ((*dmin_), (*dn_));
    }
  }
  else {
    j4_ = 4 * (*i0_) + (*pp_) - 3;
    emin_ = z_[j4_ + 4 - 1];
    d_ = z_[j4_ - 1] - (*tau_);
    (*dmin_) = d_;
    (*dmin1_) = -z_[j4_ - 1];
    if ((*ieee_)) {
      if ((*pp_) == 0) {
        for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
          z_[j4_ - 2 - 1] = d_ + z_[j4_ - 1 - 1];
          temp_ = z_[j4_ + 1 - 1] / z_[j4_ - 2 - 1];
          d_ = d_ * temp_ - (*tau_);
          if (d_ < dthresh_) {
            d_ = 0.0;
          }
          (*dmin_) = _min ((*dmin_), d_);
          z_[j4_ - 1] = z_[j4_ - 1 - 1] * temp_;
          emin_ = _min (z_[j4_ - 1], emin_);
        }
      }
      else {
        for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
          z_[j4_ - 3 - 1] = d_ + z_[j4_ - 1];
          temp_ = z_[j4_ + 2 - 1] / z_[j4_ - 3 - 1];
          d_ = d_ * temp_ - (*tau_);
          if (d_ < dthresh_) {
            d_ = 0.0;
          }
          (*dmin_) = _min ((*dmin_), d_);
          z_[j4_ - 1 - 1] = z_[j4_ - 1] * temp_;
          emin_ = _min (z_[j4_ - 1 - 1], emin_);
        }
      }
      (*dnm2_) = d_;
      (*dmin2_) = (*dmin_);
      j4_ = 4 * ((*n0_) - 2) - (*pp_);
      j4p2_ = j4_ + 2 * (*pp_) - 1;
      z_[j4_ - 2 - 1] = (*dnm2_) + z_[j4p2_ - 1];
      z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
      (*dnm1_) = z_[j4p2_ + 2 - 1] * ((*dnm2_) / z_[j4_ - 2 - 1]) - (*tau_);
      (*dmin_) = _min ((*dmin_), (*dnm1_));
      (*dmin1_) = (*dmin_);
      j4_ = j4_ + 4;
      j4p2_ = j4_ + 2 * (*pp_) - 1;
      z_[j4_ - 2 - 1] = (*dnm1_) + z_[j4p2_ - 1];
      z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
      (*dn_) = z_[j4p2_ + 2 - 1] * ((*dnm1_) / z_[j4_ - 2 - 1]) - (*tau_);
      (*dmin_) = _min ((*dmin_), (*dn_));
    }
    else {
      if ((*pp_) == 0) {
        for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
          z_[j4_ - 2 - 1] = d_ + z_[j4_ - 1 - 1];
          if (d_ < 0.0) {
            goto _l0;
          }
          else {
            z_[j4_ - 1] = z_[j4_ + 1 - 1] * (z_[j4_ - 1 - 1] / z_[j4_ - 2 - 1]);
            d_ = z_[j4_ + 1 - 1] * (d_ / z_[j4_ - 2 - 1]) - (*tau_);
          }
          if (d_ < dthresh_) {
            d_ = 0.0;
          }
          (*dmin_) = _min ((*dmin_), d_);
          emin_ = _min (emin_, z_[j4_ - 1]);
        }
      }
      else {
        for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
          z_[j4_ - 3 - 1] = d_ + z_[j4_ - 1];
          if (d_ < 0.0) {
            goto _l0;
          }
          else {
            z_[j4_ - 1 - 1] = z_[j4_ + 2 - 1] * (z_[j4_ - 1] / z_[j4_ - 3 - 1]);
            d_ = z_[j4_ + 2 - 1] * (d_ / z_[j4_ - 3 - 1]) - (*tau_);
          }
          if (d_ < dthresh_) {
            d_ = 0.0;
          }
          (*dmin_) = _min ((*dmin_), d_);
          emin_ = _min (emin_, z_[j4_ - 1 - 1]);
        }
      }
      (*dnm2_) = d_;
      (*dmin2_) = (*dmin_);
      j4_ = 4 * ((*n0_) - 2) - (*pp_);
      j4p2_ = j4_ + 2 * (*pp_) - 1;
      z_[j4_ - 2 - 1] = (*dnm2_) + z_[j4p2_ - 1];
      if ((*dnm2_) < 0.0) {
        goto _l0;
      }
      else {
        z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
        (*dnm1_) = z_[j4p2_ + 2 - 1] * ((*dnm2_) / z_[j4_ - 2 - 1]) - (*tau_);
      }
      (*dmin_) = _min ((*dmin_), (*dnm1_));
      (*dmin1_) = (*dmin_);
      j4_ = j4_ + 4;
      j4p2_ = j4_ + 2 * (*pp_) - 1;
      z_[j4_ - 2 - 1] = (*dnm1_) + z_[j4p2_ - 1];
      if ((*dnm1_) < 0.0) {
        goto _l0;
      }
      else {
        z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
        (*dn_) = z_[j4p2_ + 2 - 1] * ((*dnm1_) / z_[j4_ - 2 - 1]) - (*tau_);
      }
      (*dmin_) = _min ((*dmin_), (*dn_));
    }
  }
  z_[j4_ + 2 - 1] = (*dn_);
  z_[4 * (*n0_) - (*pp_) - 1] = emin_;
  _l0:;
  __calls[60].calls++;
  return 0;
}

int_4 _dlasq6 (int_4 _p_ i0_, int_4 _p_ n0_, real_8 _p_ z_, int_4 _p_ pp_, real_8 _p_ dmin_, real_8 _p_ dmin1_, real_8 
_p_ dmin2_, real_8 _p_ dn_, real_8 _p_ dnm1_, real_8 _p_ dnm2_)
{
  static int_4 j4_, j4p2_;
  static real_8 d_, emin_, safmin_, temp_;
  extern real_8 _dlamch ();
  if (((*n0_) - (*i0_) - 1) <= 0) {
    goto _l0;
  }
  safmin_ = _dlamch (_dc_14);
  j4_ = 4 * (*i0_) + (*pp_) - 3;
  emin_ = z_[j4_ + 4 - 1];
  d_ = z_[j4_ - 1];
  (*dmin_) = d_;
  if ((*pp_) == 0) {
    for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
      z_[j4_ - 2 - 1] = d_ + z_[j4_ - 1 - 1];
      if (z_[j4_ - 2 - 1] == 0.0) {
        z_[j4_ - 1] = 0.0;
        d_ = z_[j4_ + 1 - 1];
        (*dmin_) = d_;
        emin_ = 0.0;
      }
      else if (safmin_ * z_[j4_ + 1 - 1] < z_[j4_ - 2 - 1] && safmin_ * z_[j4_ - 2 - 1] < z_[j4_ + 1 - 1]) {
        temp_ = z_[j4_ + 1 - 1] / z_[j4_ - 2 - 1];
        z_[j4_ - 1] = z_[j4_ - 1 - 1] * temp_;
        d_ = d_ * temp_;
      }
      else {
        z_[j4_ - 1] = z_[j4_ + 1 - 1] * (z_[j4_ - 1 - 1] / z_[j4_ - 2 - 1]);
        d_ = z_[j4_ + 1 - 1] * (d_ / z_[j4_ - 2 - 1]);
      }
      (*dmin_) = _min ((*dmin_), d_);
      emin_ = _min (emin_, z_[j4_ - 1]);
    }
  }
  else {
    for (j4_ = 4 * (*i0_); (4 > 0 ? j4_ <= 4 * ((*n0_) - 3) : j4_ >= 4 * ((*n0_) - 3)); j4_ += 4) {
      z_[j4_ - 3 - 1] = d_ + z_[j4_ - 1];
      if (z_[j4_ - 3 - 1] == 0.0) {
        z_[j4_ - 1 - 1] = 0.0;
        d_ = z_[j4_ + 2 - 1];
        (*dmin_) = d_;
        emin_ = 0.0;
      }
      else if (safmin_ * z_[j4_ + 2 - 1] < z_[j4_ - 3 - 1] && safmin_ * z_[j4_ - 3 - 1] < z_[j4_ + 2 - 1]) {
        temp_ = z_[j4_ + 2 - 1] / z_[j4_ - 3 - 1];
        z_[j4_ - 1 - 1] = z_[j4_ - 1] * temp_;
        d_ = d_ * temp_;
      }
      else {
        z_[j4_ - 1 - 1] = z_[j4_ + 2 - 1] * (z_[j4_ - 1] / z_[j4_ - 3 - 1]);
        d_ = z_[j4_ + 2 - 1] * (d_ / z_[j4_ - 3 - 1]);
      }
      (*dmin_) = _min ((*dmin_), d_);
      emin_ = _min (emin_, z_[j4_ - 1 - 1]);
    }
  }
  (*dnm2_) = d_;
  (*dmin2_) = (*dmin_);
  j4_ = 4 * ((*n0_) - 2) - (*pp_);
  j4p2_ = j4_ + 2 * (*pp_) - 1;
  z_[j4_ - 2 - 1] = (*dnm2_) + z_[j4p2_ - 1];
  if (z_[j4_ - 2 - 1] == 0.0) {
    z_[j4_ - 1] = 0.0;
    (*dnm1_) = z_[j4p2_ + 2 - 1];
    (*dmin_) = (*dnm1_);
    emin_ = 0.0;
  }
  else if (safmin_ * z_[j4p2_ + 2 - 1] < z_[j4_ - 2 - 1] && safmin_ * z_[j4_ - 2 - 1] < z_[j4p2_ + 2 - 1]) {
    temp_ = z_[j4p2_ + 2 - 1] / z_[j4_ - 2 - 1];
    z_[j4_ - 1] = z_[j4p2_ - 1] * temp_;
    (*dnm1_) = (*dnm2_) * temp_;
  }
  else {
    z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
    (*dnm1_) = z_[j4p2_ + 2 - 1] * ((*dnm2_) / z_[j4_ - 2 - 1]);
  }
  (*dmin_) = _min ((*dmin_), (*dnm1_));
  (*dmin1_) = (*dmin_);
  j4_ = j4_ + 4;
  j4p2_ = j4_ + 2 * (*pp_) - 1;
  z_[j4_ - 2 - 1] = (*dnm1_) + z_[j4p2_ - 1];
  if (z_[j4_ - 2 - 1] == 0.0) {
    z_[j4_ - 1] = 0.0;
    (*dn_) = z_[j4p2_ + 2 - 1];
    (*dmin_) = (*dn_);
    emin_ = 0.0;
  }
  else if (safmin_ * z_[j4p2_ + 2 - 1] < z_[j4_ - 2 - 1] && safmin_ * z_[j4_ - 2 - 1] < z_[j4p2_ + 2 - 1]) {
    temp_ = z_[j4p2_ + 2 - 1] / z_[j4_ - 2 - 1];
    z_[j4_ - 1] = z_[j4p2_ - 1] * temp_;
    (*dn_) = (*dnm1_) * temp_;
  }
  else {
    z_[j4_ - 1] = z_[j4p2_ + 2 - 1] * (z_[j4p2_ - 1] / z_[j4_ - 2 - 1]);
    (*dn_) = z_[j4p2_ + 2 - 1] * ((*dnm1_) / z_[j4_ - 2 - 1]);
  }
  (*dmin_) = _min ((*dmin_), (*dn_));
  z_[j4_ + 2 - 1] = (*dn_);
  z_[4 * (*n0_) - (*pp_) - 1] = emin_;
  _l0:;
  __calls[61].calls++;
  return 0;
}

int_4 _dlasr (char _p_ side_, char _p_ pivot_, char _p_ direct_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ 
s_, real_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, info_, j_;
  static real_8 ctemp_, stemp_, temp_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  info_ = 0;
  if (! ((_lsame (side_, _dc_1) || _lsame (side_, _dc_15)))) {
    info_ = 1;
  }
  else if (! ((_lsame (pivot_, _dc_11) || _lsame (pivot_, _dc_25) || _lsame (pivot_, _dc_12)))) {
    info_ = 2;
  }
  else if (! ((_lsame (direct_, _dc_16) || _lsame (direct_, _dc_12)))) {
    info_ = 3;
  }
  else if ((*m_) < 0) {
    info_ = 4;
  }
  else if ((*n_) < 0) {
    info_ = 5;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    info_ = 9;
  }
  if (info_ != 0) {
    (void) _xerbla (_dc_89, &info_);
    goto _l0;
  }
  if (((*m_) == 0) || ((*n_) == 0)) {
    goto _l0;
  }
  if (_lsame (side_, _dc_1)) {
    if (_lsame (pivot_, _dc_11)) {
      if (_lsame (direct_, _dc_16)) {
        for (j_ = 1; j_ <= (*m_) - 1; (j_)++) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ + 1 - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ + 1 - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * temp_ - stemp_ * a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = stemp_ * temp_ + ctemp_ * a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_12)) {
        for (j_ = (*m_) - 1; j_ >= 1; (j_)--) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ + 1 - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ + 1 - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * temp_ - stemp_ * a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = stemp_ * temp_ + ctemp_ * a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
            }
          }
        }
      }
    }
    else if (_lsame (pivot_, _dc_25)) {
      if (_lsame (direct_, _dc_16)) {
        for (j_ = 2; j_ <= (*m_); (j_)++) {
          ctemp_ = c_[j_ - 1 - 1];
          stemp_ = s_[j_ - 1 - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * temp_ - stemp_ * a_[0 + ((*lda_)) * ((i_ - 1))];
              a_[0 + ((*lda_)) * ((i_ - 1))] = stemp_ * temp_ + ctemp_ * a_[0 + ((*lda_)) * ((i_ - 1))];
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_12)) {
        for (j_ = (*m_); j_ >= 2; (j_)--) {
          ctemp_ = c_[j_ - 1 - 1];
          stemp_ = s_[j_ - 1 - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * temp_ - stemp_ * a_[0 + ((*lda_)) * ((i_ - 1))];
              a_[0 + ((*lda_)) * ((i_ - 1))] = stemp_ * temp_ + ctemp_ * a_[0 + ((*lda_)) * ((i_ - 1))];
            }
          }
        }
      }
    }
    else if (_lsame (pivot_, _dc_12)) {
      if (_lsame (direct_, _dc_16)) {
        for (j_ = 1; j_ <= (*m_) - 1; (j_)++) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = stemp_ * a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] + ctemp_ * temp_;
              a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] - stemp_ * temp_;
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_12)) {
        for (j_ = (*m_) - 1; j_ >= 1; (j_)--) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              temp_ = a_[j_ - 1 + ((*lda_)) * ((i_ - 1))];
              a_[j_ - 1 + ((*lda_)) * ((i_ - 1))] = stemp_ * a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] + ctemp_ * temp_;
              a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] = ctemp_ * a_[(*m_) - 1 + ((*lda_)) * ((i_ - 1))] - stemp_ * temp_;
            }
          }
        }
      }
    }
  }
  else if (_lsame (side_, _dc_15)) {
    if (_lsame (pivot_, _dc_11)) {
      if (_lsame (direct_, _dc_16)) {
        for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ + 1 - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ + 1 - 1))] = ctemp_ * temp_ - stemp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = stemp_ * temp_ + ctemp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_12)) {
        for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ + 1 - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ + 1 - 1))] = ctemp_ * temp_ - stemp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = stemp_ * temp_ + ctemp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
            }
          }
        }
      }
    }
    else if (_lsame (pivot_, _dc_25)) {
      if (_lsame (direct_, _dc_16)) {
        for (j_ = 2; j_ <= (*n_); (j_)++) {
          ctemp_ = c_[j_ - 1 - 1];
          stemp_ = s_[j_ - 1 - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = ctemp_ * temp_ - stemp_ * a_[i_ - 1 + ((*lda_)) * ((0))];
              a_[i_ - 1 + ((*lda_)) * ((0))] = stemp_ * temp_ + ctemp_ * a_[i_ - 1 + ((*lda_)) * ((0))];
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_12)) {
        for (j_ = (*n_); j_ >= 2; (j_)--) {
          ctemp_ = c_[j_ - 1 - 1];
          stemp_ = s_[j_ - 1 - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = ctemp_ * temp_ - stemp_ * a_[i_ - 1 + ((*lda_)) * ((0))];
              a_[i_ - 1 + ((*lda_)) * ((0))] = stemp_ * temp_ + ctemp_ * a_[i_ - 1 + ((*lda_)) * ((0))];
            }
          }
        }
      }
    }
    else if (_lsame (pivot_, _dc_12)) {
      if (_lsame (direct_, _dc_16)) {
        for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = stemp_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] + ctemp_ * temp_;
              a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] = ctemp_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] - stemp_ * temp_;
            }
          }
        }
      }
      else if (_lsame (direct_, _dc_12)) {
        for (j_ = (*n_) - 1; j_ >= 1; (j_)--) {
          ctemp_ = c_[j_ - 1];
          stemp_ = s_[j_ - 1];
          if ((ctemp_ != 1.0) || (stemp_ != 0.0)) {
            for (i_ = 1; i_ <= (*m_); (i_)++) {
              temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
              a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = stemp_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] + ctemp_ * temp_;
              a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] = ctemp_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] - stemp_ * temp_;
            }
          }
        }
      }
    }
  }
  _l0:;
  __calls[62].calls++;
  return 0;
}

int_4 _dlasrt (char _p_ id_, int_4 _p_ n_, real_8 _p_ d_, int_4 _p_ info_)
{
  static int_4 dir_, endd_, i_, j_, start_, stkpnt_, stack_[64];
  static real_8 d1_, d2_, d3_, dmnmx_, tmp_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  dir_ = -1;
  if (_lsame (id_, _dc_71)) {
    dir_ = 0;
  }
  else if (_lsame (id_, _dc_4)) {
    dir_ = 1;
  }
  if (dir_ == -1) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_90, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) <= 1) {
    goto _l0;
  }
  stkpnt_ = 1;
  stack_[0] = 1;
  stack_[1] = (*n_);
  _l10:;
  start_ = stack_[0 + (2) * ((stkpnt_ - 1))];
  endd_ = stack_[1 + (2) * ((stkpnt_ - 1))];
  stkpnt_ = stkpnt_ - 1;
  if (endd_ - start_ <= 20 && endd_ - start_ > 0) {
    if (dir_ == 0) {
      for (i_ = start_ + 1; i_ <= endd_; (i_)++) {
        for (j_ = i_; j_ >= start_ + 1; (j_)--) {
          if (d_[j_ - 1] > d_[j_ - 1 - 1]) {
            dmnmx_ = d_[j_ - 1];
            d_[j_ - 1] = d_[j_ - 1 - 1];
            d_[j_ - 1 - 1] = dmnmx_;
          }
          else {
            goto _l30;
          }
        }
        _l30:;
      }
    }
    else {
      for (i_ = start_ + 1; i_ <= endd_; (i_)++) {
        for (j_ = i_; j_ >= start_ + 1; (j_)--) {
          if (d_[j_ - 1] < d_[j_ - 1 - 1]) {
            dmnmx_ = d_[j_ - 1];
            d_[j_ - 1] = d_[j_ - 1 - 1];
            d_[j_ - 1 - 1] = dmnmx_;
          }
          else {
            goto _l50;
          }
        }
        _l50:;
      }
    }
  }
  else if (endd_ - start_ > 20) {
    d1_ = d_[start_ - 1];
    d2_ = d_[endd_ - 1];
    i_ = (start_ + endd_) / 2;
    d3_ = d_[i_ - 1];
    if (d1_ < d2_) {
      if (d3_ < d1_) {
        dmnmx_ = d1_;
      }
      else if (d3_ < d2_) {
        dmnmx_ = d3_;
      }
      else {
        dmnmx_ = d2_;
      }
    }
    else {
      if (d3_ < d2_) {
        dmnmx_ = d2_;
      }
      else if (d3_ < d1_) {
        dmnmx_ = d3_;
      }
      else {
        dmnmx_ = d1_;
      }
    }
    if (dir_ == 0) {
      i_ = start_ - 1;
      j_ = endd_ + 1;
      _l60:;
      _l70:;
      j_ = j_ - 1;
      if (d_[j_ - 1] < dmnmx_) {
        goto _l70;
      }
      _l80:;
      i_ = i_ + 1;
      if (d_[i_ - 1] > dmnmx_) {
        goto _l80;
      }
      if (i_ < j_) {
        tmp_ = d_[i_ - 1];
        d_[i_ - 1] = d_[j_ - 1];
        d_[j_ - 1] = tmp_;
        goto _l60;
      }
      if (j_ - start_ > endd_ - j_ - 1) {
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = start_;
        stack_[1 + (2) * ((stkpnt_ - 1))] = j_;
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = j_ + 1;
        stack_[1 + (2) * ((stkpnt_ - 1))] = endd_;
      }
      else {
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = j_ + 1;
        stack_[1 + (2) * ((stkpnt_ - 1))] = endd_;
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = start_;
        stack_[1 + (2) * ((stkpnt_ - 1))] = j_;
      }
    }
    else {
      i_ = start_ - 1;
      j_ = endd_ + 1;
      _l90:;
      _l100:;
      j_ = j_ - 1;
      if (d_[j_ - 1] > dmnmx_) {
        goto _l100;
      }
      _l110:;
      i_ = i_ + 1;
      if (d_[i_ - 1] < dmnmx_) {
        goto _l110;
      }
      if (i_ < j_) {
        tmp_ = d_[i_ - 1];
        d_[i_ - 1] = d_[j_ - 1];
        d_[j_ - 1] = tmp_;
        goto _l90;
      }
      if (j_ - start_ > endd_ - j_ - 1) {
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = start_;
        stack_[1 + (2) * ((stkpnt_ - 1))] = j_;
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = j_ + 1;
        stack_[1 + (2) * ((stkpnt_ - 1))] = endd_;
      }
      else {
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = j_ + 1;
        stack_[1 + (2) * ((stkpnt_ - 1))] = endd_;
        stkpnt_ = stkpnt_ + 1;
        stack_[0 + (2) * ((stkpnt_ - 1))] = start_;
        stack_[1 + (2) * ((stkpnt_ - 1))] = j_;
      }
    }
  }
  if (stkpnt_ > 0) {
    goto _l10;
  }
  _l0:;
  __calls[63].calls++;
  return 0;
}

int_4 _dlassq (int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ incx_, real_8 _p_ scale_, real_8 _p_ sumsq_)
{
  static int_4 ix_;
  static real_8 absxi_;
  real_8 $0_, $1_;
  if ((*n_) > 0) {
    for (ix_ = 1; ((*incx_) > 0 ? ix_ <= 1 + ((*n_) - 1) * (*incx_) : ix_ >= 1 + ((*n_) - 1) * (*incx_)); ix_ += (*incx_)) 
      {
      absxi_ = _abs (x_[ix_ - 1]);
      if (absxi_ > 0.0 || _disnan (&absxi_)) {
        if ((*scale_) < absxi_) {
          (*sumsq_) = 1 + (*sumsq_) * ($0_ = ((*scale_) / absxi_), $0_ * $0_);
          (*scale_) = absxi_;
        }
        else {
          (*sumsq_) = (*sumsq_) + ($1_ = (absxi_ / (*scale_)), $1_ * $1_);
        }
      }
    }
  }
  __calls[64].calls++;
  return 0;
}

int_4 _dlasv2 (real_8 _p_ f_, real_8 _p_ g_, real_8 _p_ h_, real_8 _p_ ssmin_, real_8 _p_ ssmax_, real_8 _p_ snr_, 
real_8 _p_ csr_, real_8 _p_ snl_, real_8 _p_ csl_)
{
  static int_4 pmax_;
  static logical_4 gasmal_, swap_;
  static real_8 a_, clt_, crt_, d_, fa_, ft_, ga_, gt_, ha_, ht_, l_, m_, mm_, r_, s_, slt_, srt_, t_, temp_, tsign_, tt_
  ;
  extern real_8 _dlamch ();
  ft_ = (*f_);
  fa_ = _abs (ft_);
  ht_ = (*h_);
  ha_ = _abs ((*h_));
  pmax_ = 1;
  swap_ = (ha_ > fa_);
  if (swap_) {
    pmax_ = 3;
    temp_ = ft_;
    ft_ = ht_;
    ht_ = temp_;
    temp_ = fa_;
    fa_ = ha_;
    ha_ = temp_;
  }
  gt_ = (*g_);
  ga_ = _abs (gt_);
  if (ga_ == 0.0) {
    (*ssmin_) = ha_;
    (*ssmax_) = fa_;
    clt_ = 1.0;
    crt_ = 1.0;
    slt_ = 0.0;
    srt_ = 0.0;
  }
  else {
    gasmal_ = TRUE;
    if (ga_ > fa_) {
      pmax_ = 2;
      if ((fa_ / ga_) < _dlamch (_dc_91)) {
        gasmal_ = FALSE;
        (*ssmax_) = ga_;
        if (ha_ > 1.0) {
          (*ssmin_) = fa_ / (ga_ / ha_);
        }
        else {
          (*ssmin_) = (fa_ / ga_) * ha_;
        }
        clt_ = 1.0;
        slt_ = ht_ / gt_;
        srt_ = 1.0;
        crt_ = ft_ / gt_;
      }
    }
    if (gasmal_) {
      d_ = fa_ - ha_;
      if (d_ == fa_) {
        l_ = 1.0;
      }
      else {
        l_ = d_ / fa_;
      }
      m_ = gt_ / ft_;
      t_ = 2.0 - l_;
      mm_ = m_ * m_;
      tt_ = t_ * t_;
      s_ = sqrt (tt_ + mm_);
      if (l_ == 0.0) {
        r_ = _abs (m_);
      }
      else {
        r_ = sqrt (l_ * l_ + mm_);
      }
      a_ = 0.5 * (s_ + r_);
      (*ssmin_) = ha_ / a_;
      (*ssmax_) = fa_ * a_;
      if (mm_ == 0.0) {
        if (l_ == 0.0) {
          t_ = _sign (2.0, ft_) * _sign (1.0, gt_);
        }
        else {
          t_ = gt_ / _sign (d_, ft_) + m_ / t_;
        }
      }
      else {
        t_ = (m_ / (s_ + t_) + m_ / (r_ + l_)) * (1.0 + a_);
      }
      l_ = sqrt (t_ * t_ + 4.0);
      crt_ = 2.0 / l_;
      srt_ = t_ / l_;
      clt_ = (crt_ + srt_ * m_) / a_;
      slt_ = (ht_ / ft_) * srt_ / a_;
    }
  }
  if (swap_) {
    (*csl_) = srt_;
    (*snl_) = crt_;
    (*csr_) = slt_;
    (*snr_) = clt_;
  }
  else {
    (*csl_) = clt_;
    (*snl_) = slt_;
    (*csr_) = crt_;
    (*snr_) = srt_;
  }
  if (pmax_ == 1) {
    tsign_ = _sign (1.0, (*csr_)) * _sign (1.0, (*csl_)) * _sign (1.0, (*f_));
  }
  if (pmax_ == 2) {
    tsign_ = _sign (1.0, (*snr_)) * _sign (1.0, (*csl_)) * _sign (1.0, (*g_));
  }
  if (pmax_ == 3) {
    tsign_ = _sign (1.0, (*snr_)) * _sign (1.0, (*snl_)) * _sign (1.0, (*h_));
  }
  (*ssmax_) = _sign ((*ssmax_), tsign_);
  (*ssmin_) = _sign ((*ssmin_), tsign_ * _sign (1.0, (*f_)) * _sign (1.0, (*h_)));
  __calls[65].calls++;
  return 0;
}

int_4 _dlaswp (int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ k1_, int_4 _p_ k2_, int_4 _p_ ipiv_, int_4 _p_ 
incx_)
{
  static int_4 i_, i1_, i2_, inc_, ip_, ix_, ix0_, j_, k_, n32_;
  static real_8 temp_;
  if ((*incx_) > 0) {
    ix0_ = (*k1_);
    i1_ = (*k1_);
    i2_ = (*k2_);
    inc_ = 1;
  }
  else if ((*incx_) < 0) {
    ix0_ = (*k1_) + ((*k1_) - (*k2_)) * (*incx_);
    i1_ = (*k2_);
    i2_ = (*k1_);
    inc_ = -1;
  }
  else {
    goto _l0;
  }
  n32_ = ((*n_) / 32) * 32;
  if (n32_ != 0) {
    for (j_ = 1; (32 > 0 ? j_ <= n32_ : j_ >= n32_); j_ += 32) {
      ix_ = ix0_;
      for (i_ = i1_; (inc_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += inc_) {
        ip_ = ipiv_[ix_ - 1];
        if (ip_ != i_) {
          for (k_ = j_; k_ <= j_ + 31; (k_)++) {
            temp_ = a_[i_ - 1 + ((*lda_)) * ((k_ - 1))];
            a_[i_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[ip_ - 1 + ((*lda_)) * ((k_ - 1))];
            a_[ip_ - 1 + ((*lda_)) * ((k_ - 1))] = temp_;
          }
        }
        ix_ = ix_ + (*incx_);
      }
    }
  }
  if (n32_ != (*n_)) {
    n32_ = n32_ + 1;
    ix_ = ix0_;
    for (i_ = i1_; (inc_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += inc_) {
      ip_ = ipiv_[ix_ - 1];
      if (ip_ != i_) {
        for (k_ = n32_; k_ <= (*n_); (k_)++) {
          temp_ = a_[i_ - 1 + ((*lda_)) * ((k_ - 1))];
          a_[i_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[ip_ - 1 + ((*lda_)) * ((k_ - 1))];
          a_[ip_ - 1 + ((*lda_)) * ((k_ - 1))] = temp_;
        }
      }
      ix_ = ix_ + (*incx_);
    }
  }
  _l0:;
  __calls[66].calls++;
  return 0;
}

int_4 _dlatrs (char _p_ uplo_, char _p_ trans_, char _p_ diag_, char _p_ normin_, int_4 _p_ n_, real_8 _p_ a_, int_4 
_p_ lda_, real_8 _p_ x_, real_8 _p_ scale_, real_8 _p_ cnorm_, int_4 _p_ info_)
{
  static int_4 i_, imax_, j_, jfirst_, jinc_, jlast_;
  static logical_4 notran_, nounit_, upper_;
  static real_8 bignum_, grow_, rec_, smlnum_, sumj_, tjj_, tjjs_, tmax_, tscal_, uscal_, xbnd_, xj_, xmax_;
  int_4 $0_, $1_, $2_, $4_, $6_, $7_, $9_, $10_, $11_;
  real_8 $3_, $5_, $8_, $12_;
  extern logical_4 _lsame ();
  extern int_4 _idamax ();
  extern real_8 _dasum ();
  extern real_8 _ddot ();
  extern real_8 _dlamch ();
  extern int_4 _daxpy ();
  extern int_4 _dscal ();
  extern int_4 _dtrsv ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  upper_ = _lsame (uplo_, _dc_0);
  notran_ = _lsame (trans_, _dc_2);
  nounit_ = _lsame (diag_, _dc_2);
  if (! (upper_) && ! (_lsame (uplo_, _dc_1))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_25)) && ! (_lsame (trans_, _dc_26))) {
    (*info_) = -2;
  }
  else if (! (nounit_) && ! (_lsame (diag_, _dc_0))) {
    (*info_) = -3;
  }
  else if (! (_lsame (normin_, _dc_92)) && ! (_lsame (normin_, _dc_2))) {
    (*info_) = -4;
  }
  else if ((*n_) < 0) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    (*info_) = -7;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_93, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) == 0) {
    goto _l0;
  }
  smlnum_ = _dlamch (_dc_14) / _dlamch (_dc_87);
  bignum_ = 1.0 / smlnum_;
  (*scale_) = 1.0;
  if (_lsame (normin_, _dc_2)) {
    if (upper_) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        cnorm_[j_ - 1] = _dasum (($1_ = j_ - 1, &$1_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
      }
    }
    else {
      for (j_ = 1; j_ <= (*n_) - 1; (j_)++) {
        cnorm_[j_ - 1] = _dasum (($2_ = (*n_) - j_, &$2_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
      }
      cnorm_[(*n_) - 1] = 0.0;
    }
  }
  imax_ = _idamax (n_, cnorm_, &_k1);
  tmax_ = cnorm_[imax_ - 1];
  if (tmax_ <= bignum_) {
    tscal_ = 1.0;
  }
  else {
    tscal_ = 1.0 / (smlnum_ * tmax_);
    (void) _dscal (n_, &tscal_, cnorm_, &_k1);
  }
  j_ = _idamax (n_, x_, &_k1);
  xmax_ = _abs (x_[j_ - 1]);
  xbnd_ = xmax_;
  if (notran_) {
    if (upper_) {
      jfirst_ = (*n_);
      jlast_ = 1;
      jinc_ = -1;
    }
    else {
      jfirst_ = 1;
      jlast_ = (*n_);
      jinc_ = 1;
    }
    if (tscal_ != 1.0) {
      grow_ = 0.0;
      goto _l50;
    }
    if (nounit_) {
      grow_ = 1.0 / _max (xbnd_, smlnum_);
      xbnd_ = grow_;
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l50;
        }
        tjj_ = _abs (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
        xbnd_ = _min (xbnd_, _min (1.0, tjj_) * grow_);
        if (tjj_ + cnorm_[j_ - 1] >= smlnum_) {
          grow_ = grow_ * (tjj_ / (tjj_ + cnorm_[j_ - 1]));
        }
        else {
          grow_ = 0.0;
        }
      }
      grow_ = xbnd_;
    }
    else {
      grow_ = _min (1.0, 1.0 / _max (xbnd_, smlnum_));
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l50;
        }
        grow_ = grow_ * (1.0 / (1.0 + cnorm_[j_ - 1]));
      }
    }
    _l50:;
  }
  else {
    if (upper_) {
      jfirst_ = 1;
      jlast_ = (*n_);
      jinc_ = 1;
    }
    else {
      jfirst_ = (*n_);
      jlast_ = 1;
      jinc_ = -1;
    }
    if (tscal_ != 1.0) {
      grow_ = 0.0;
      goto _l80;
    }
    if (nounit_) {
      grow_ = 1.0 / _max (xbnd_, smlnum_);
      xbnd_ = grow_;
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l80;
        }
        xj_ = 1.0 + cnorm_[j_ - 1];
        grow_ = _min (grow_, xbnd_ / xj_);
        tjj_ = _abs (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
        if (xj_ > tjj_) {
          xbnd_ = xbnd_ * (tjj_ / xj_);
        }
      }
      grow_ = _min (grow_, xbnd_);
    }
    else {
      grow_ = _min (1.0, 1.0 / _max (xbnd_, smlnum_));
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        if (grow_ <= smlnum_) {
          goto _l80;
        }
        xj_ = 1.0 + cnorm_[j_ - 1];
        grow_ = grow_ / xj_;
      }
    }
    _l80:;
  }
  if ((grow_ * tscal_) > smlnum_) {
    (void) _dtrsv (uplo_, trans_, diag_, n_, a_, lda_, x_, &_k1);
  }
  else {
    if (xmax_ > bignum_) {
      (*scale_) = bignum_ / xmax_;
      (void) _dscal (n_, scale_, x_, &_k1);
      xmax_ = bignum_;
    }
    if (notran_) {
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        xj_ = _abs (x_[j_ - 1]);
        if (nounit_) {
          tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
        }
        else {
          tjjs_ = tscal_;
          if (tscal_ == 1.0) {
            goto _l100;
          }
        }
        tjj_ = _abs (tjjs_);
        if (tjj_ > smlnum_) {
          if (tjj_ < 1.0) {
            if (xj_ > tjj_ * bignum_) {
              rec_ = 1.0 / xj_;
              (void) _dscal (n_, &rec_, x_, &_k1);
              (*scale_) = (*scale_) * rec_;
              xmax_ = xmax_ * rec_;
            }
          }
          x_[j_ - 1] = x_[j_ - 1] / tjjs_;
          xj_ = _abs (x_[j_ - 1]);
        }
        else if (tjj_ > 0.0) {
          if (xj_ > tjj_ * bignum_) {
            rec_ = (tjj_ * bignum_) / xj_;
            if (cnorm_[j_ - 1] > 1.0) {
              rec_ = rec_ / cnorm_[j_ - 1];
            }
            (void) _dscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
            xmax_ = xmax_ * rec_;
          }
          x_[j_ - 1] = x_[j_ - 1] / tjjs_;
          xj_ = _abs (x_[j_ - 1]);
        }
        else {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            x_[i_ - 1] = 0.0;
          }
          x_[j_ - 1] = 1.0;
          xj_ = 1.0;
          (*scale_) = 0.0;
          xmax_ = 0.0;
        }
        _l100:;
        if (xj_ > 1.0) {
          rec_ = 1.0 / xj_;
          if (cnorm_[j_ - 1] > (bignum_ - xmax_) * rec_) {
            rec_ = rec_ * 0.5;
            (void) _dscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
          }
        }
        else if (xj_ * cnorm_[j_ - 1] > (bignum_ - xmax_)) {
          (void) _dscal (n_, ($3_ = 0.5, &$3_), x_, &_k1);
          (*scale_) = (*scale_) * 0.5;
        }
        if (upper_) {
          if (j_ > 1) {
            (void) _daxpy (($4_ = j_ - 1, &$4_), ($5_ = -x_[j_ - 1] * tscal_, &$5_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, x_, 
            &_k1);
            i_ = _idamax (($6_ = j_ - 1, &$6_), x_, &_k1);
            xmax_ = _abs (x_[i_ - 1]);
          }
        }
        else {
          if (j_ < (*n_)) {
            (void) _daxpy (($7_ = (*n_) - j_, &$7_), ($8_ = -x_[j_ - 1] * tscal_, &$8_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], 
            &_k1, &x_[j_ + 1 - 1], &_k1);
            i_ = j_ + _idamax (($9_ = (*n_) - j_, &$9_), &x_[j_ + 1 - 1], &_k1);
            xmax_ = _abs (x_[i_ - 1]);
          }
        }
      }
    }
    else {
      for (j_ = jfirst_; (jinc_ > 0 ? j_ <= jlast_ : j_ >= jlast_); j_ += jinc_) {
        xj_ = _abs (x_[j_ - 1]);
        uscal_ = tscal_;
        rec_ = 1.0 / _max (xmax_, 1.0);
        if (cnorm_[j_ - 1] > (bignum_ - xj_) * rec_) {
          rec_ = rec_ * 0.5;
          if (nounit_) {
            tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
          }
          else {
            tjjs_ = tscal_;
          }
          tjj_ = _abs (tjjs_);
          if (tjj_ > 1.0) {
            rec_ = _min (1.0, rec_ * tjj_);
            uscal_ = uscal_ / tjjs_;
          }
          if (rec_ < 1.0) {
            (void) _dscal (n_, &rec_, x_, &_k1);
            (*scale_) = (*scale_) * rec_;
            xmax_ = xmax_ * rec_;
          }
        }
        sumj_ = 0.0;
        if (uscal_ == 1.0) {
          if (upper_) {
            sumj_ = _ddot (($10_ = j_ - 1, &$10_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, x_, &_k1);
          }
          else if (j_ < (*n_)) {
            sumj_ = _ddot (($11_ = (*n_) - j_, &$11_), &a_[j_ + 1 - 1 + ((*lda_)) * ((j_ - 1))], &_k1, &x_[j_ + 1 - 1], &_k1);
          }
        }
        else {
          if (upper_) {
            for (i_ = 1; i_ <= j_ - 1; (i_)++) {
              sumj_ = sumj_ + (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * uscal_) * x_[i_ - 1];
            }
          }
          else if (j_ < (*n_)) {
            for (i_ = j_ + 1; i_ <= (*n_); (i_)++) {
              sumj_ = sumj_ + (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * uscal_) * x_[i_ - 1];
            }
          }
        }
        if (uscal_ == tscal_) {
          x_[j_ - 1] = x_[j_ - 1] - sumj_;
          xj_ = _abs (x_[j_ - 1]);
          if (nounit_) {
            tjjs_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] * tscal_;
          }
          else {
            tjjs_ = tscal_;
            if (tscal_ == 1.0) {
              goto _l150;
            }
          }
          tjj_ = _abs (tjjs_);
          if (tjj_ > smlnum_) {
            if (tjj_ < 1.0) {
              if (xj_ > tjj_ * bignum_) {
                rec_ = 1.0 / xj_;
                (void) _dscal (n_, &rec_, x_, &_k1);
                (*scale_) = (*scale_) * rec_;
                xmax_ = xmax_ * rec_;
              }
            }
            x_[j_ - 1] = x_[j_ - 1] / tjjs_;
          }
          else if (tjj_ > 0.0) {
            if (xj_ > tjj_ * bignum_) {
              rec_ = (tjj_ * bignum_) / xj_;
              (void) _dscal (n_, &rec_, x_, &_k1);
              (*scale_) = (*scale_) * rec_;
              xmax_ = xmax_ * rec_;
            }
            x_[j_ - 1] = x_[j_ - 1] / tjjs_;
          }
          else {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              x_[i_ - 1] = 0.0;
            }
            x_[j_ - 1] = 1.0;
            (*scale_) = 0.0;
            xmax_ = 0.0;
          }
          _l150:;
        }
        else {
          x_[j_ - 1] = x_[j_ - 1] / tjjs_ - sumj_;
        }
        xmax_ = _max (xmax_, _abs (x_[j_ - 1]));
      }
    }
    (*scale_) = (*scale_) / tscal_;
  }
  if (tscal_ != 1.0) {
    (void) _dscal (n_, ($12_ = 1.0 / tscal_, &$12_), cnorm_, &_k1);
  }
  _l0:;
  __calls[67].calls++;
  return 0;
}

int_4 _dorg2r (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ 
work_, int_4 _p_ info_)
{
  static int_4 i_, j_, l_;
  int_4 $0_, $1_, $2_, $3_;
  real_8 $4_;
  extern int_4 _dscal ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0 || (*n_) > (*m_)) {
    (*info_) = -2;
  }
  else if ((*k_) < 0 || (*k_) > (*n_)) {
    (*info_) = -3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -5;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_94, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*n_) <= 0) {
    goto _l0;
  }
  for (j_ = (*k_) + 1; j_ <= (*n_); (j_)++) {
    for (l_ = 1; l_ <= (*m_); (l_)++) {
      a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
    }
    a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = 1.0;
  }
  for (i_ = (*k_); i_ >= 1; (i_)--) {
    if (i_ < (*n_)) {
      a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
      (void) _dlarf (_dc_18, ($1_ = (*m_) - i_ + 1, &$1_), ($2_ = (*n_) - i_, &$2_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
      &_k1, &tau_[i_ - 1], &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_, work_);
    }
    if (i_ < (*m_)) {
      (void) _dscal (($3_ = (*m_) - i_, &$3_), ($4_ = -tau_[i_ - 1], &$4_), &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], &_k1);
    }
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0 - tau_[i_ - 1];
    for (l_ = 1; l_ <= i_ - 1; (l_)++) {
      a_[l_ - 1 + ((*lda_)) * ((i_ - 1))] = 0.0;
    }
  }
  _l0:;
  __calls[68].calls++;
  return 0;
}

int_4 _dorgbr (char _p_ vect_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_
, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 i_, iinfo_, j_, lwkopt_, mn_;
  static logical_4 lquery_, wantq_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  wantq_ = _lsame (vect_, _dc_53);
  mn_ = _min ((*m_), (*n_));
  lquery_ = ((*lwork_) == -1);
  if (! (wantq_) && ! (_lsame (vect_, _dc_3))) {
    (*info_) = -1;
  }
  else if ((*m_) < 0) {
    (*info_) = -2;
  }
  else if ((*n_) < 0 || (wantq_ && ((*n_) > (*m_) || (*n_) < _min ((*m_), (*k_)))) || (! (wantq_) && ((*m_) > (*n_) || 
    (*m_) < _min ((*n_), (*k_))))) {
    (*info_) = -3;
  }
  else if ((*k_) < 0) {
    (*info_) = -4;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -6;
  }
  else if ((*lwork_) < _max (1, mn_) && ! (lquery_)) {
    (*info_) = -9;
  }
  if ((*info_) == 0) {
    work_[0] = 1;
    if (wantq_) {
      if ((*m_) >= (*k_)) {
        (void) _dorgqr (m_, n_, k_, a_, lda_, tau_, work_, &_km1, &iinfo_);
      }
      else {
        if ((*m_) > 1) {
          (void) _dorgqr (($0_ = (*m_) - 1, &$0_), ($1_ = (*m_) - 1, &$1_), ($2_ = (*m_) - 1, &$2_), &a_[1 + ((*lda_)) * ((1))], 
          lda_, tau_, work_, &_km1, &iinfo_);
        }
      }
    }
    else {
      if ((*k_) < (*n_)) {
        (void) _dorglq (m_, n_, k_, a_, lda_, tau_, work_, &_km1, &iinfo_);
      }
      else {
        if ((*n_) > 1) {
          (void) _dorglq (($3_ = (*n_) - 1, &$3_), ($4_ = (*n_) - 1, &$4_), ($5_ = (*n_) - 1, &$5_), &a_[1 + ((*lda_)) * ((1))], 
          lda_, tau_, work_, &_km1, &iinfo_);
        }
      }
    }
    lwkopt_ = work_[0];
    lwkopt_ = _max (lwkopt_, mn_);
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_95, ($6_ = -(*info_), &$6_));
    goto _l0;
  }
  else if (lquery_) {
    work_[0] = lwkopt_;
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0) {
    work_[0] = 1;
    goto _l0;
  }
  if (wantq_) {
    if ((*m_) >= (*k_)) {
      (void) _dorgqr (m_, n_, k_, a_, lda_, tau_, work_, lwork_, &iinfo_);
    }
    else {
      for (j_ = (*m_); j_ >= 2; (j_)--) {
        a_[0 + ((*lda_)) * ((j_ - 1))] = 0.0;
        for (i_ = j_ + 1; i_ <= (*m_); (i_)++) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1 - 1))];
        }
      }
      a_[0 + ((*lda_)) * ((0))] = 1.0;
      for (i_ = 2; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((0))] = 0.0;
      }
      if ((*m_) > 1) {
        (void) _dorgqr (($7_ = (*m_) - 1, &$7_), ($8_ = (*m_) - 1, &$8_), ($9_ = (*m_) - 1, &$9_), &a_[1 + ((*lda_)) * ((1))], 
        lda_, tau_, work_, lwork_, &iinfo_);
      }
    }
  }
  else {
    if ((*k_) < (*n_)) {
      (void) _dorglq (m_, n_, k_, a_, lda_, tau_, work_, lwork_, &iinfo_);
    }
    else {
      a_[0 + ((*lda_)) * ((0))] = 1.0;
      for (i_ = 2; i_ <= (*n_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((0))] = 0.0;
      }
      for (j_ = 2; j_ <= (*n_); (j_)++) {
        for (i_ = j_ - 1; i_ >= 2; (i_)--) {
          a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 - 1 + ((*lda_)) * ((j_ - 1))];
        }
        a_[0 + ((*lda_)) * ((j_ - 1))] = 0.0;
      }
      if ((*n_) > 1) {
        (void) _dorglq (($10_ = (*n_) - 1, &$10_), ($11_ = (*n_) - 1, &$11_), ($12_ = (*n_) - 1, &$12_), &a_[1 + ((*lda_)) * 
        ((1))], lda_, tau_, work_, lwork_, &iinfo_);
      }
    }
  }
  work_[0] = lwkopt_;
  _l0:;
  __calls[69].calls++;
  return 0;
}

int_4 _dorgl2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ 
work_, int_4 _p_ info_)
{
  static int_4 i_, j_, l_;
  int_4 $0_, $1_, $2_, $3_;
  real_8 $4_;
  extern int_4 _dscal ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < (*m_)) {
    (*info_) = -2;
  }
  else if ((*k_) < 0 || (*k_) > (*m_)) {
    (*info_) = -3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -5;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_96, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) <= 0) {
    goto _l0;
  }
  if ((*k_) < (*m_)) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      for (l_ = (*k_) + 1; l_ <= (*m_); (l_)++) {
        a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
      }
      if (j_ > (*k_) && j_ <= (*m_)) {
        a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = 1.0;
      }
    }
  }
  for (i_ = (*k_); i_ >= 1; (i_)--) {
    if (i_ < (*n_)) {
      if (i_ < (*m_)) {
        a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
        (void) _dlarf (_dc_19, ($1_ = (*m_) - i_, &$1_), ($2_ = (*n_) - i_ + 1, &$2_), &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], 
        lda_, &tau_[i_ - 1], &a_[i_ + 1 - 1 + ((*lda_)) * ((i_ - 1))], lda_, work_);
      }
      (void) _dscal (($3_ = (*n_) - i_, &$3_), ($4_ = -tau_[i_ - 1], &$4_), &a_[i_ - 1 + ((*lda_)) * ((i_ + 1 - 1))], lda_);
    }
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0 - tau_[i_ - 1];
    for (l_ = 1; l_ <= i_ - 1; (l_)++) {
      a_[i_ - 1 + ((*lda_)) * ((l_ - 1))] = 0.0;
    }
  }
  _l0:;
  __calls[70].calls++;
  return 0;
}

int_4 _dorglq (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ 
work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 i_, ib_, iinfo_, iws_, j_, ki_, kk_, l_, ldwork_, lwkopt_, nb_, nbmin_, nx_;
  static logical_4 lquery_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  nb_ = _ilaenv (&_k1, _dc_97, _dc_6, m_, n_, k_, &_km1);
  lwkopt_ = _max (1, (*m_)) * nb_;
  work_[0] = lwkopt_;
  lquery_ = ((*lwork_) == -1);
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < (*m_)) {
    (*info_) = -2;
  }
  else if ((*k_) < 0 || (*k_) > (*m_)) {
    (*info_) = -3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -5;
  }
  else if ((*lwork_) < _max (1, (*m_)) && ! (lquery_)) {
    (*info_) = -8;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_97, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  if ((*m_) <= 0) {
    work_[0] = 1;
    goto _l0;
  }
  nbmin_ = 2;
  nx_ = 0;
  iws_ = (*m_);
  if (nb_ > 1 && nb_ < (*k_)) {
    nx_ = _max (0, _ilaenv (($1_ = 3, &$1_), _dc_97, _dc_6, m_, n_, k_, &_km1));
    if (nx_ < (*k_)) {
      ldwork_ = (*m_);
      iws_ = ldwork_ * nb_;
      if ((*lwork_) < iws_) {
        nb_ = (*lwork_) / ldwork_;
        nbmin_ = _max (2, _ilaenv (($2_ = 2, &$2_), _dc_97, _dc_6, m_, n_, k_, &_km1));
      }
    }
  }
  if (nb_ >= nbmin_ && nb_ < (*k_) && nx_ < (*k_)) {
    ki_ = (((*k_) - nx_ - 1) / nb_) * nb_;
    kk_ = _min ((*k_), ki_ + nb_);
    for (j_ = 1; j_ <= kk_; (j_)++) {
      for (i_ = kk_ + 1; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
      }
    }
  }
  else {
    kk_ = 0;
  }
  if (kk_ < (*m_)) {
    (void) _dorgl2 (($3_ = (*m_) - kk_, &$3_), ($4_ = (*n_) - kk_, &$4_), ($5_ = (*k_) - kk_, &$5_), &a_[kk_ + 1 - 1 + 
    ((*lda_)) * ((kk_ + 1 - 1))], lda_, &tau_[kk_ + 1 - 1], work_, &iinfo_);
  }
  if (kk_ > 0) {
    for (i_ = ki_ + 1; (-nb_ > 0 ? i_ <= 1 : i_ >= 1); i_ += -nb_) {
      ib_ = _min (nb_, (*k_) - i_ + 1);
      if (i_ + ib_ <= (*m_)) {
        (void) _dlarft (_dc_42, _dc_43, ($6_ = (*n_) - i_ + 1, &$6_), &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
        &tau_[i_ - 1], work_, &ldwork_);
        (void) _dlarfb (_dc_19, _dc_22, _dc_42, _dc_43, ($7_ = (*m_) - i_ - ib_ + 1, &$7_), ($8_ = (*n_) - i_ + 1, &$8_), &ib_, 
        &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, work_, &ldwork_, &a_[i_ + ib_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
        &work_[ib_ + 1 - 1], &ldwork_);
      }
      (void) _dorgl2 (&ib_, ($9_ = (*n_) - i_ + 1, &$9_), &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, &tau_[i_ - 1], 
      work_, &iinfo_);
      for (j_ = 1; j_ <= i_ - 1; (j_)++) {
        for (l_ = i_; l_ <= i_ + ib_ - 1; (l_)++) {
          a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
        }
      }
    }
  }
  work_[0] = iws_;
  _l0:;
  __calls[71].calls++;
  return 0;
}

int_4 _dorgqr (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ 
work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 i_, ib_, iinfo_, iws_, j_, ki_, kk_, l_, ldwork_, lwkopt_, nb_, nbmin_, nx_;
  static logical_4 lquery_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  extern int_4 _xerbla ();
  (*info_) = 0;
  nb_ = _ilaenv (&_k1, _dc_98, _dc_6, m_, n_, k_, &_km1);
  lwkopt_ = _max (1, (*n_)) * nb_;
  work_[0] = lwkopt_;
  lquery_ = ((*lwork_) == -1);
  if ((*m_) < 0) {
    (*info_) = -1;
  }
  else if ((*n_) < 0 || (*n_) > (*m_)) {
    (*info_) = -2;
  }
  else if ((*k_) < 0 || (*k_) > (*n_)) {
    (*info_) = -3;
  }
  else if ((*lda_) < _max (1, (*m_))) {
    (*info_) = -5;
  }
  else if ((*lwork_) < _max (1, (*n_)) && ! (lquery_)) {
    (*info_) = -8;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_98, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  if ((*n_) <= 0) {
    work_[0] = 1;
    goto _l0;
  }
  nbmin_ = 2;
  nx_ = 0;
  iws_ = (*n_);
  if (nb_ > 1 && nb_ < (*k_)) {
    nx_ = _max (0, _ilaenv (($1_ = 3, &$1_), _dc_98, _dc_6, m_, n_, k_, &_km1));
    if (nx_ < (*k_)) {
      ldwork_ = (*n_);
      iws_ = ldwork_ * nb_;
      if ((*lwork_) < iws_) {
        nb_ = (*lwork_) / ldwork_;
        nbmin_ = _max (2, _ilaenv (($2_ = 2, &$2_), _dc_98, _dc_6, m_, n_, k_, &_km1));
      }
    }
  }
  if (nb_ >= nbmin_ && nb_ < (*k_) && nx_ < (*k_)) {
    ki_ = (((*k_) - nx_ - 1) / nb_) * nb_;
    kk_ = _min ((*k_), ki_ + nb_);
    for (j_ = kk_ + 1; j_ <= (*n_); (j_)++) {
      for (i_ = 1; i_ <= kk_; (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
      }
    }
  }
  else {
    kk_ = 0;
  }
  if (kk_ < (*n_)) {
    (void) _dorg2r (($3_ = (*m_) - kk_, &$3_), ($4_ = (*n_) - kk_, &$4_), ($5_ = (*k_) - kk_, &$5_), &a_[kk_ + 1 - 1 + 
    ((*lda_)) * ((kk_ + 1 - 1))], lda_, &tau_[kk_ + 1 - 1], work_, &iinfo_);
  }
  if (kk_ > 0) {
    for (i_ = ki_ + 1; (-nb_ > 0 ? i_ <= 1 : i_ >= 1); i_ += -nb_) {
      ib_ = _min (nb_, (*k_) - i_ + 1);
      if (i_ + ib_ <= (*n_)) {
        (void) _dlarft (_dc_42, _dc_57, ($6_ = (*m_) - i_ + 1, &$6_), &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
        &tau_[i_ - 1], work_, &ldwork_);
        (void) _dlarfb (_dc_18, _dc_21, _dc_42, _dc_57, ($7_ = (*m_) - i_ + 1, &$7_), ($8_ = (*n_) - i_ - ib_ + 1, &$8_), &ib_, 
        &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, work_, &ldwork_, &a_[i_ - 1 + ((*lda_)) * ((i_ + ib_ - 1))], lda_, 
        &work_[ib_ + 1 - 1], &ldwork_);
      }
      (void) _dorg2r (($9_ = (*m_) - i_ + 1, &$9_), &ib_, &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, &tau_[i_ - 1], 
      work_, &iinfo_);
      for (j_ = i_; j_ <= i_ + ib_ - 1; (j_)++) {
        for (l_ = 1; l_ <= i_ - 1; (l_)++) {
          a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
        }
      }
    }
  }
  work_[0] = iws_;
  _l0:;
  __calls[72].calls++;
  return 0;
}

int_4 _dorm2r (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_
, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, i3_, ic_, jc_, mi_, ni_, nq_;
  static logical_4 left_, notran_;
  static real_8 aii_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  left_ = _lsame (side_, _dc_1);
  notran_ = _lsame (trans_, _dc_2);
  if (left_) {
    nq_ = (*m_);
  }
  else {
    nq_ = (*n_);
  }
  if (! (left_) && ! (_lsame (side_, _dc_15))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_25))) {
    (*info_) = -2;
  }
  else if ((*m_) < 0) {
    (*info_) = -3;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*k_) < 0 || (*k_) > nq_) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, nq_)) {
    (*info_) = -7;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_99, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0 || (*k_) == 0) {
    goto _l0;
  }
  if ((left_ && ! (notran_)) || (! (left_) && notran_)) {
    i1_ = 1;
    i2_ = (*k_);
    i3_ = 1;
  }
  else {
    i1_ = (*k_);
    i2_ = 1;
    i3_ = -1;
  }
  if (left_) {
    ni_ = (*n_);
    jc_ = 1;
  }
  else {
    mi_ = (*m_);
    ic_ = 1;
  }
  for (i_ = i1_; (i3_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += i3_) {
    if (left_) {
      mi_ = (*m_) - i_ + 1;
      ic_ = i_;
    }
    else {
      ni_ = (*n_) - i_ + 1;
      jc_ = i_;
    }
    aii_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
    (void) _dlarf (side_, &mi_, &ni_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], &_k1, &tau_[i_ - 1], &c_[ic_ - 1 + ((*ldc_)) * 
    ((jc_ - 1))], ldc_, work_);
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
  }
  _l0:;
  __calls[73].calls++;
  return 0;
}

int_4 _dormbr (char _p_ vect_, char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_
, int_4 _p_ lda_, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 i1_, i2_, iinfo_, lwkopt_, mi_, nb_, ni_, nq_, nw_;
  static logical_4 applyq_, left_, lquery_, notran_;
  static char_1 transt_;
  int_4 $2_, $3_, $6_, $7_, $10_, $11_, $14_, $15_, $16_, $17_, $18_;
  char_3 $0_, $1_, $4_, $5_, $8_, $9_, $12_, $13_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  applyq_ = _lsame (vect_, _dc_53);
  left_ = _lsame (side_, _dc_1);
  notran_ = _lsame (trans_, _dc_2);
  lquery_ = ((*lwork_) == -1);
  if (left_) {
    nq_ = (*m_);
    nw_ = (*n_);
  }
  else {
    nq_ = (*n_);
    nw_ = (*m_);
  }
  if (! (applyq_) && ! (_lsame (vect_, _dc_3))) {
    (*info_) = -1;
  }
  else if (! (left_) && ! (_lsame (side_, _dc_15))) {
    (*info_) = -2;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_25))) {
    (*info_) = -3;
  }
  else if ((*m_) < 0) {
    (*info_) = -4;
  }
  else if ((*n_) < 0) {
    (*info_) = -5;
  }
  else if ((*k_) < 0) {
    (*info_) = -6;
  }
  else if ((applyq_ && (*lda_) < _max (1, nq_)) || (! (applyq_) && (*lda_) < _max (1, _min (nq_, (*k_))))) {
    (*info_) = -8;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -11;
  }
  else if ((*lwork_) < _max (1, nw_) && ! (lquery_)) {
    (*info_) = -13;
  }
  if ((*info_) == 0) {
    if (applyq_) {
      if (left_) {
        nb_ = _ilaenv (&_k1, _dc_46, (bufcpy ($1_, concat ($0_, side_, trans_), 3), $1_), ($2_ = (*m_) - 1, &$2_), n_, ($3_ = 
        (*m_) - 1, &$3_), &_km1);
      }
      else {
        nb_ = _ilaenv (&_k1, _dc_46, (bufcpy ($5_, concat ($4_, side_, trans_), 3), $5_), m_, ($6_ = (*n_) - 1, &$6_), ($7_ = 
        (*n_) - 1, &$7_), &_km1);
      }
    }
    else {
      if (left_) {
        nb_ = _ilaenv (&_k1, _dc_51, (bufcpy ($9_, concat ($8_, side_, trans_), 3), $9_), ($10_ = (*m_) - 1, &$10_), n_, ($11_ 
        = (*m_) - 1, &$11_), &_km1);
      }
      else {
        nb_ = _ilaenv (&_k1, _dc_51, (bufcpy ($13_, concat ($12_, side_, trans_), 3), $13_), m_, ($14_ = (*n_) - 1, &$14_), 
        ($15_ = (*n_) - 1, &$15_), &_km1);
      }
    }
    lwkopt_ = _max (1, nw_) * nb_;
    work_[0] = lwkopt_;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_48, ($16_ = -(*info_), &$16_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  work_[0] = 1;
  if ((*m_) == 0 || (*n_) == 0) {
    goto _l0;
  }
  if (applyq_) {
    if (nq_ >= (*k_)) {
      (void) _dormqr (side_, trans_, m_, n_, k_, a_, lda_, tau_, c_, ldc_, work_, lwork_, &iinfo_);
    }
    else if (nq_ > 1) {
      if (left_) {
        mi_ = (*m_) - 1;
        ni_ = (*n_);
        i1_ = 2;
        i2_ = 1;
      }
      else {
        mi_ = (*m_);
        ni_ = (*n_) - 1;
        i1_ = 1;
        i2_ = 2;
      }
      (void) _dormqr (side_, trans_, &mi_, &ni_, ($17_ = nq_ - 1, &$17_), &a_[1 + ((*lda_)) * ((0))], lda_, tau_, &c_[i1_ - 1 
      + ((*ldc_)) * ((i2_ - 1))], ldc_, work_, lwork_, &iinfo_);
    }
  }
  else {
    if (notran_) {
      bufcpy (transt_, _dc_25, 1);
    }
    else {
      bufcpy (transt_, _dc_2, 1);
    }
    if (nq_ > (*k_)) {
      (void) _dormlq (side_, transt_, m_, n_, k_, a_, lda_, tau_, c_, ldc_, work_, lwork_, &iinfo_);
    }
    else if (nq_ > 1) {
      if (left_) {
        mi_ = (*m_) - 1;
        ni_ = (*n_);
        i1_ = 2;
        i2_ = 1;
      }
      else {
        mi_ = (*m_);
        ni_ = (*n_) - 1;
        i1_ = 1;
        i2_ = 2;
      }
      (void) _dormlq (side_, transt_, &mi_, &ni_, ($18_ = nq_ - 1, &$18_), &a_[0 + ((*lda_)) * ((1))], lda_, tau_, &c_[i1_ - 
      1 + ((*ldc_)) * ((i2_ - 1))], ldc_, work_, lwork_, &iinfo_);
    }
  }
  work_[0] = lwkopt_;
  _l0:;
  __calls[74].calls++;
  return 0;
}

int_4 _dorml2 (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_
, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, i3_, ic_, jc_, mi_, ni_, nq_;
  static logical_4 left_, notran_;
  static real_8 aii_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  left_ = _lsame (side_, _dc_1);
  notran_ = _lsame (trans_, _dc_2);
  if (left_) {
    nq_ = (*m_);
  }
  else {
    nq_ = (*n_);
  }
  if (! (left_) && ! (_lsame (side_, _dc_15))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_25))) {
    (*info_) = -2;
  }
  else if ((*m_) < 0) {
    (*info_) = -3;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*k_) < 0 || (*k_) > nq_) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*k_))) {
    (*info_) = -7;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -10;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_100, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0 || (*k_) == 0) {
    goto _l0;
  }
  if ((left_ && notran_) || (! (left_) && ! (notran_))) {
    i1_ = 1;
    i2_ = (*k_);
    i3_ = 1;
  }
  else {
    i1_ = (*k_);
    i2_ = 1;
    i3_ = -1;
  }
  if (left_) {
    ni_ = (*n_);
    jc_ = 1;
  }
  else {
    mi_ = (*m_);
    ic_ = 1;
  }
  for (i_ = i1_; (i3_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += i3_) {
    if (left_) {
      mi_ = (*m_) - i_ + 1;
      ic_ = i_;
    }
    else {
      ni_ = (*n_) - i_ + 1;
      jc_ = i_;
    }
    aii_ = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))];
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = 1.0;
    (void) _dlarf (side_, &mi_, &ni_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, &tau_[i_ - 1], &c_[ic_ - 1 + ((*ldc_)) * 
    ((jc_ - 1))], ldc_, work_);
    a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] = aii_;
  }
  _l0:;
  __calls[75].calls++;
  return 0;
}

int_4 _dormlq (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_
, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, i3_, ib_, ic_, iinfo_, iwt_, jc_, ldwork_, lwkopt_, mi_, nb_, nbmin_, ni_, nq_, nw_;
  static logical_4 left_, lquery_, notran_;
  static char_1 transt_;
  int_4 $2_, $3_, $6_, $7_, $8_;
  char_3 $0_, $1_, $4_, $5_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  left_ = _lsame (side_, _dc_1);
  notran_ = _lsame (trans_, _dc_2);
  lquery_ = ((*lwork_) == -1);
  if (left_) {
    nq_ = (*m_);
    nw_ = (*n_);
  }
  else {
    nq_ = (*n_);
    nw_ = (*m_);
  }
  if (! (left_) && ! (_lsame (side_, _dc_15))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_25))) {
    (*info_) = -2;
  }
  else if ((*m_) < 0) {
    (*info_) = -3;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*k_) < 0 || (*k_) > nq_) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, (*k_))) {
    (*info_) = -7;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -10;
  }
  else if ((*lwork_) < _max (1, nw_) && ! (lquery_)) {
    (*info_) = -12;
  }
  if ((*info_) == 0) {
    nb_ = _min (64, _ilaenv (&_k1, _dc_51, (bufcpy ($1_, concat ($0_, side_, trans_), 3), $1_), m_, n_, k_, &_km1));
    lwkopt_ = _max (1, nw_) * nb_ + 4160;
    work_[0] = lwkopt_;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_51, ($2_ = -(*info_), &$2_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0 || (*k_) == 0) {
    work_[0] = 1;
    goto _l0;
  }
  nbmin_ = 2;
  ldwork_ = nw_;
  if (nb_ > 1 && nb_ < (*k_)) {
    if ((*lwork_) < nw_ * nb_ + 4160) {
      nb_ = ((*lwork_) - 4160) / ldwork_;
      nbmin_ = _max (2, _ilaenv (($3_ = 2, &$3_), _dc_51, (bufcpy ($5_, concat ($4_, side_, trans_), 3), $5_), m_, n_, k_, 
      &_km1));
    }
  }
  if (nb_ < nbmin_ || nb_ >= (*k_)) {
    (void) _dorml2 (side_, trans_, m_, n_, k_, a_, lda_, tau_, c_, ldc_, work_, &iinfo_);
  }
  else {
    iwt_ = 1 + nw_ * nb_;
    if ((left_ && notran_) || (! (left_) && ! (notran_))) {
      i1_ = 1;
      i2_ = (*k_);
      i3_ = nb_;
    }
    else {
      i1_ = (((*k_) - 1) / nb_) * nb_ + 1;
      i2_ = 1;
      i3_ = -nb_;
    }
    if (left_) {
      ni_ = (*n_);
      jc_ = 1;
    }
    else {
      mi_ = (*m_);
      ic_ = 1;
    }
    if (notran_) {
      bufcpy (transt_, _dc_25, 1);
    }
    else {
      bufcpy (transt_, _dc_2, 1);
    }
    for (i_ = i1_; (i3_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += i3_) {
      ib_ = _min (nb_, (*k_) - i_ + 1);
      (void) _dlarft (_dc_42, _dc_43, ($6_ = nq_ - i_ + 1, &$6_), &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, &tau_[i_ 
      - 1], &work_[iwt_ - 1], ($7_ = 65, &$7_));
      if (left_) {
        mi_ = (*m_) - i_ + 1;
        ic_ = i_;
      }
      else {
        ni_ = (*n_) - i_ + 1;
        jc_ = i_;
      }
      (void) _dlarfb (side_, transt_, _dc_42, _dc_43, &mi_, &ni_, &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
      &work_[iwt_ - 1], ($8_ = 65, &$8_), &c_[ic_ - 1 + ((*ldc_)) * ((jc_ - 1))], ldc_, work_, &ldwork_);
    }
  }
  work_[0] = lwkopt_;
  _l0:;
  __calls[76].calls++;
  return 0;
}

int_4 _dormqr (char _p_ side_, char _p_ trans_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ a_, int_4 _p_ lda_
, real_8 _p_ tau_, real_8 _p_ c_, int_4 _p_ ldc_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ info_)
{
  static int_4 i_, i1_, i2_, i3_, ib_, ic_, iinfo_, iwt_, jc_, ldwork_, lwkopt_, mi_, nb_, nbmin_, ni_, nq_, nw_;
  static logical_4 left_, lquery_, notran_;
  int_4 $2_, $3_, $6_, $7_, $8_;
  char_3 $0_, $1_, $4_, $5_;
  extern logical_4 _lsame ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  left_ = _lsame (side_, _dc_1);
  notran_ = _lsame (trans_, _dc_2);
  lquery_ = ((*lwork_) == -1);
  if (left_) {
    nq_ = (*m_);
    nw_ = (*n_);
  }
  else {
    nq_ = (*n_);
    nw_ = (*m_);
  }
  if (! (left_) && ! (_lsame (side_, _dc_15))) {
    (*info_) = -1;
  }
  else if (! (notran_) && ! (_lsame (trans_, _dc_25))) {
    (*info_) = -2;
  }
  else if ((*m_) < 0) {
    (*info_) = -3;
  }
  else if ((*n_) < 0) {
    (*info_) = -4;
  }
  else if ((*k_) < 0 || (*k_) > nq_) {
    (*info_) = -5;
  }
  else if ((*lda_) < _max (1, nq_)) {
    (*info_) = -7;
  }
  else if ((*ldc_) < _max (1, (*m_))) {
    (*info_) = -10;
  }
  else if ((*lwork_) < _max (1, nw_) && ! (lquery_)) {
    (*info_) = -12;
  }
  if ((*info_) == 0) {
    nb_ = _min (64, _ilaenv (&_k1, _dc_46, (bufcpy ($1_, concat ($0_, side_, trans_), 3), $1_), m_, n_, k_, &_km1));
    lwkopt_ = _max (1, nw_) * nb_ + 4160;
    work_[0] = lwkopt_;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_46, ($2_ = -(*info_), &$2_));
    goto _l0;
  }
  else if (lquery_) {
    goto _l0;
  }
  if ((*m_) == 0 || (*n_) == 0 || (*k_) == 0) {
    work_[0] = 1;
    goto _l0;
  }
  nbmin_ = 2;
  ldwork_ = nw_;
  if (nb_ > 1 && nb_ < (*k_)) {
    if ((*lwork_) < nw_ * nb_ + 4160) {
      nb_ = ((*lwork_) - 4160) / ldwork_;
      nbmin_ = _max (2, _ilaenv (($3_ = 2, &$3_), _dc_46, (bufcpy ($5_, concat ($4_, side_, trans_), 3), $5_), m_, n_, k_, 
      &_km1));
    }
  }
  if (nb_ < nbmin_ || nb_ >= (*k_)) {
    (void) _dorm2r (side_, trans_, m_, n_, k_, a_, lda_, tau_, c_, ldc_, work_, &iinfo_);
  }
  else {
    iwt_ = 1 + nw_ * nb_;
    if ((left_ && ! (notran_)) || (! (left_) && notran_)) {
      i1_ = 1;
      i2_ = (*k_);
      i3_ = nb_;
    }
    else {
      i1_ = (((*k_) - 1) / nb_) * nb_ + 1;
      i2_ = 1;
      i3_ = -nb_;
    }
    if (left_) {
      ni_ = (*n_);
      jc_ = 1;
    }
    else {
      mi_ = (*m_);
      ic_ = 1;
    }
    for (i_ = i1_; (i3_ > 0 ? i_ <= i2_ : i_ >= i2_); i_ += i3_) {
      ib_ = _min (nb_, (*k_) - i_ + 1);
      (void) _dlarft (_dc_42, _dc_57, ($6_ = nq_ - i_ + 1, &$6_), &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, &tau_[i_ 
      - 1], &work_[iwt_ - 1], ($7_ = 65, &$7_));
      if (left_) {
        mi_ = (*m_) - i_ + 1;
        ic_ = i_;
      }
      else {
        ni_ = (*n_) - i_ + 1;
        jc_ = i_;
      }
      (void) _dlarfb (side_, trans_, _dc_42, _dc_57, &mi_, &ni_, &ib_, &a_[i_ - 1 + ((*lda_)) * ((i_ - 1))], lda_, 
      &work_[iwt_ - 1], ($8_ = 65, &$8_), &c_[ic_ - 1 + ((*ldc_)) * ((jc_ - 1))], ldc_, work_, &ldwork_);
    }
  }
  work_[0] = lwkopt_;
  _l0:;
  __calls[77].calls++;
  return 0;
}

int_4 _dpocon (char _p_ uplo_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ anorm_, real_8 _p_ rcond_, 
real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ info_)
{
  static int_4 ix_, kase_, isave_[3];
  static logical_4 upper_;
  static real_8 ainvnm_, scale_, scalel_, scaleu_, smlnum_;
  static char_1 normin_;
  int_4 $0_;
  extern logical_4 _lsame ();
  extern int_4 _idamax ();
  extern real_8 _dlamch ();
  extern int_4 _xerbla ();
  (*info_) = 0;
  upper_ = _lsame (uplo_, _dc_0);
  if (! (upper_) && ! (_lsame (uplo_, _dc_1))) {
    (*info_) = -1;
  }
  else if ((*n_) < 0) {
    (*info_) = -2;
  }
  else if ((*lda_) < _max (1, (*n_))) {
    (*info_) = -4;
  }
  else if ((*anorm_) < 0.0) {
    (*info_) = -5;
  }
  if ((*info_) != 0) {
    (void) _xerbla (_dc_101, ($0_ = -(*info_), &$0_));
    goto _l0;
  }
  (*rcond_) = 0.0;
  if ((*n_) == 0) {
    (*rcond_) = 1.0;
    goto _l0;
  }
  else if ((*anorm_) == 0.0) {
    goto _l0;
  }
  smlnum_ = _dlamch (_dc_14);
  kase_ = 0;
  bufcpy (normin_, _dc_2, 1);
  _l10:;
  (void) _dlacn2 (n_, &work_[(*n_) + 1 - 1], work_, iwork_, &ainvnm_, &kase_, isave_);
  if (kase_ != 0) {
    if (upper_) {
      (void) _dlatrs (_dc_33, _dc_22, _dc_74, normin_, n_, a_, lda_, work_, &scalel_, &work_[2 * (*n_) + 1 - 1], info_);
      bufcpy (normin_, _dc_92, 1);
      (void) _dlatrs (_dc_33, _dc_21, _dc_74, normin_, n_, a_, lda_, work_, &scaleu_, &work_[2 * (*n_) + 1 - 1], info_);
    }
    else {
      (void) _dlatrs (_dc_34, _dc_21, _dc_74, normin_, n_, a_, lda_, work_, &scalel_, &work_[2 * (*n_) + 1 - 1], info_);
      bufcpy (normin_, _dc_92, 1);
      (void) _dlatrs (_dc_34, _dc_22, _dc_74, normin_, n_, a_, lda_, work_, &scaleu_, &work_[2 * (*n_) + 1 - 1], info_);
    }
    scale_ = scalel_ * scaleu_;
    if (scale_ != 1.0) {
      ix_ = _idamax (n_, work_, &_k1);
      if (scale_ < _abs (work_[ix_ - 1]) * smlnum_ || scale_ == 0.0) {
        goto _l20;
      }
      (void) _drscl (n_, &scale_, work_, &_k1);
    }
    goto _l10;
  }
  if (ainvnm_ != 0.0) {
    (*rcond_) = (1.0 / ainvnm_) / (*anorm_);
  }
  _l20:;
  _l0:;
  __calls[78].calls++;
  return 0;
}

int_4 _drscl (int_4 _p_ n_, real_8 _p_ sa_, real_8 _p_ sx_, int_4 _p_ incx_)
{
  static logical_4 done_;
  static real_8 bignum_, cden_, cden1_, cnum_, cnum1_, mul_, smlnum_;
  extern real_8 _dlamch ();
  extern int_4 _dscal ();
  if ((*n_) <= 0) {
    goto _l0;
  }
  smlnum_ = _dlamch (_dc_52);
  bignum_ = 1.0 / smlnum_;
  (void) _dlabad (&smlnum_, &bignum_);
  cden_ = (*sa_);
  cnum_ = 1.0;
  _l10:;
  cden1_ = cden_ * smlnum_;
  cnum1_ = cnum_ / bignum_;
  if (_abs (cden1_) > _abs (cnum_) && cnum_ != 0.0) {
    mul_ = smlnum_;
    done_ = FALSE;
    cden_ = cden1_;
  }
  else if (_abs (cnum1_) > _abs (cden_)) {
    mul_ = bignum_;
    done_ = FALSE;
    cnum_ = cnum1_;
  }
  else {
    mul_ = cnum_ / cden_;
    done_ = TRUE;
  }
  (void) _dscal (n_, &mul_, sx_, incx_);
  if (! (done_)) {
    goto _l10;
  }
  _l0:;
  __calls[79].calls++;
  return 0;
}

int_4 _ieeeck (int_4 _p_ ispec_, real_4 _p_ zero_, real_4 _p_ one_)
{
  static real_4 nan1_, nan2_, nan3_, nan4_, nan5_, nan6_, neginf_, negzro_, newzro_, posinf_;
  int_4 ieeeck_;
  ieeeck_ = 1;
  posinf_ = (*one_) / (*zero_);
  if (posinf_ <= (*one_)) {
    ieeeck_ = 0;
    goto _l0;
  }
  neginf_ = -(*one_) / (*zero_);
  if (neginf_ >= (*zero_)) {
    ieeeck_ = 0;
    goto _l0;
  }
  negzro_ = (*one_) / (neginf_ + (*one_));
  if (negzro_ != (*zero_)) {
    ieeeck_ = 0;
    goto _l0;
  }
  neginf_ = (*one_) / negzro_;
  if (neginf_ >= (*zero_)) {
    ieeeck_ = 0;
    goto _l0;
  }
  newzro_ = negzro_ + (*zero_);
  if (newzro_ != (*zero_)) {
    ieeeck_ = 0;
    goto _l0;
  }
  posinf_ = (*one_) / newzro_;
  if (posinf_ <= (*one_)) {
    ieeeck_ = 0;
    goto _l0;
  }
  neginf_ = neginf_ * posinf_;
  if (neginf_ >= (*zero_)) {
    ieeeck_ = 0;
    goto _l0;
  }
  posinf_ = posinf_ * posinf_;
  if (posinf_ <= (*one_)) {
    ieeeck_ = 0;
    goto _l0;
  }
  if ((*ispec_) == 0) {
    goto _l0;
  }
  nan1_ = posinf_ + neginf_;
  nan2_ = posinf_ / neginf_;
  nan3_ = posinf_ / posinf_;
  nan4_ = posinf_ * (*zero_);
  nan5_ = neginf_ * negzro_;
  nan6_ = nan5_ * (*zero_);
  if (nan1_ == nan1_) {
    ieeeck_ = 0;
    goto _l0;
  }
  if (nan2_ == nan2_) {
    ieeeck_ = 0;
    goto _l0;
  }
  if (nan3_ == nan3_) {
    ieeeck_ = 0;
    goto _l0;
  }
  if (nan4_ == nan4_) {
    ieeeck_ = 0;
    goto _l0;
  }
  if (nan5_ == nan5_) {
    ieeeck_ = 0;
    goto _l0;
  }
  if (nan6_ == nan6_) {
    ieeeck_ = 0;
    goto _l0;
  }
  _l0:;
  __calls[80].calls++;
  return ieeeck_;
}

int_4 _iladlc (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_;
  int_4 iladlc_;
  if ((*n_) == 0) {
    iladlc_ = (*n_);
  }
  else if (a_[0 + ((*lda_)) * (((*n_) - 1))] != 0.0 || a_[(*m_) - 1 + ((*lda_)) * (((*n_) - 1))] != 0.0) {
    iladlc_ = (*n_);
  }
  else {
    for (iladlc_ = (*n_); iladlc_ >= 1; (iladlc_)--) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        if (a_[i_ - 1 + ((*lda_)) * ((iladlc_ - 1))] != 0.0) {
          goto _l0;
        }
      }
    }
  }
  _l0:;
  __calls[81].calls++;
  return iladlc_;
}

int_4 _iladlr (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, j_;
  int_4 iladlr_;
  if ((*m_) == 0) {
    iladlr_ = (*m_);
  }
  else if (a_[(*m_) - 1 + ((*lda_)) * ((0))] != 0.0 || a_[(*m_) - 1 + ((*lda_)) * (((*n_) - 1))] != 0.0) {
    iladlr_ = (*m_);
  }
  else {
    iladlr_ = 0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      i_ = (*m_);
      while ((a_[_max (i_, 1) - 1 + ((*lda_)) * ((j_ - 1))] == 0.0) && (i_ >= 1)) {
        i_ = i_ - 1;
      }
      iladlr_ = _max (iladlr_, i_);
    }
  }
  __calls[82].calls++;
  return iladlr_;
}

int_4 _ilaenv (int_4 _p_ ispec_, char _p_ name_, char _p_ opts_, int_4 _p_ n1_, int_4 _p_ n2_, int_4 _p_ n3_, int_4 _p_ 
n4_)
{
  static int_4 i_, ic_, iz_, nb_, nbmin_, nx_;
  static logical_4 cname_, sname_, twostage_;
  static char_1 c1_;
  static char_3 c2_, c4_, c3_;
  static char_31 subnam_;
  real_4 $20_, $21_, $22_, $23_;
  char_3 $7_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_;
  char_31 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $8_, $9_;
  int_4 ilaenv_;
  switch ((*ispec_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l10;
    case 3: goto _l10;
    case 4: goto _l80;
    case 5: goto _l90;
    case 6: goto _l100;
    case 7: goto _l110;
    case 8: goto _l120;
    case 9: goto _l130;
    case 10: goto _l140;
    case 11: goto _l150;
    case 12: goto _l160;
    case 13: goto _l160;
    case 14: goto _l160;
    case 15: goto _l160;
    case 16: goto _l160;
  }
  ilaenv_ = -1;
  goto _l0;
  _l10:;
  ilaenv_ = 1;
  bufcpy (subnam_, name_, 31);
  ic_ = _ichar (_bufsub ((char *) $0_, (char *) subnam_, 1, 1));
  iz_ = _ichar (_dc_75);
  if (iz_ == 90 || iz_ == 122) {
    if (ic_ >= 97 && ic_ <= 122) {
      bufrep ((char *) &(subnam_[0]), _char (ic_ - 32));
      for (i_ = 2; i_ <= 6; (i_)++) {
        ic_ = _ichar (_bufsub ((char *) $1_, (char *) subnam_, i_, i_));
        if (ic_ >= 97 && ic_ <= 122) {
          bufrep ((char *) &(subnam_[i_ - 1]), _char (ic_ - 32));
        }
      }
    }
  }
  else if (iz_ == 233 || iz_ == 169) {
    if ((ic_ >= 129 && ic_ <= 137) || (ic_ >= 145 && ic_ <= 153) || (ic_ >= 162 && ic_ <= 169)) {
      bufrep ((char *) &(subnam_[0]), _char (ic_ + 64));
      for (i_ = 2; i_ <= 6; (i_)++) {
        ic_ = _ichar (_bufsub ((char *) $2_, (char *) subnam_, i_, i_));
        if ((ic_ >= 129 && ic_ <= 137) || (ic_ >= 145 && ic_ <= 153) || (ic_ >= 162 && ic_ <= 169)) {
          bufrep ((char *) &(subnam_[i_ - 1]), _char (ic_ + 64));
        }
      }
    }
  }
  else if (iz_ == 218 || iz_ == 250) {
    if (ic_ >= 225 && ic_ <= 250) {
      bufrep ((char *) &(subnam_[0]), _char (ic_ - 32));
      for (i_ = 2; i_ <= 6; (i_)++) {
        ic_ = _ichar (_bufsub ((char *) $3_, (char *) subnam_, i_, i_));
        if (ic_ >= 225 && ic_ <= 250) {
          bufrep ((char *) &(subnam_[i_ - 1]), _char (ic_ - 32));
        }
      }
    }
  }
  bufcpy (c1_, _bufsub ((char *) $4_, (char *) subnam_, 1, 1), 1);
  sname_ = (strcmp (c1_, _dc_52) == 0) || (strcmp (c1_, _dc_71) == 0);
  cname_ = (strcmp (c1_, _dc_26) == 0) || (strcmp (c1_, _dc_75) == 0);
  if (! ((cname_ || sname_))) {
    goto _l0;
  }
  bufcpy (c2_, _bufsub ((char *) $5_, (char *) subnam_, 2, 3), 3);
  bufcpy (c3_, _bufsub ((char *) $6_, (char *) subnam_, 4, 6), 3);
  bufcpy (c4_, _bufsub ((char *) $7_, (char *) c3_, 2, 3), 3);
  twostage_ = (int_4) strlen (subnam_) >= 11 && (strcmp (_bufsub ((char *) $8_, (char *) subnam_, 11, 11), _dc_102) == 0)
  ;
  switch ((*ispec_)) {
    default:
    case 1: goto _l50;
    case 2: goto _l60;
    case 3: goto _l70;
  }
  _l50:;
  nb_ = 1;
  if ((strcmp (_bufsub ((char *) $9_, (char *) subnam_, 2, 6), _dc_103) == 0)) {
    if (sname_) {
      nb_ = 32;
    }
    else {
      nb_ = 32;
    }
  }
  else if ((strcmp (c2_, _dc_104) == 0)) {
    if ((strcmp (c3_, _dc_105) == 0)) {
      if (sname_) {
        nb_ = 64;
      }
      else {
        nb_ = 64;
      }
    }
    else if ((strcmp (c3_, _dc_106) == 0) || (strcmp (c3_, _dc_107) == 0) || (strcmp (c3_, _dc_108) == 0) || (strcmp (c3_, 
      _dc_109) == 0)) {
      if (sname_) {
        nb_ = 32;
      }
      else {
        nb_ = 32;
      }
    }
    else if ((strcmp (c3_, _dc_110) == 0)) {
      if ((*n3_) == 1) {
        if (sname_) {
          if (((*n1_) * (*n2_) <= 131072) || ((*n1_) <= 8192)) {
            nb_ = (*n1_);
          }
          else {
            nb_ = 32768 / (*n2_);
          }
        }
        else {
          if (((*n1_) * (*n2_) <= 131072) || ((*n1_) <= 8192)) {
            nb_ = (*n1_);
          }
          else {
            nb_ = 32768 / (*n2_);
          }
        }
      }
      else {
        if (sname_) {
          nb_ = 1;
        }
        else {
          nb_ = 1;
        }
      }
    }
    else if ((strcmp (c3_, _dc_111) == 0)) {
      if ((*n3_) == 2) {
        if (sname_) {
          if (((*n1_) * (*n2_) <= 131072) || ((*n1_) <= 8192)) {
            nb_ = (*n1_);
          }
          else {
            nb_ = 32768 / (*n2_);
          }
        }
        else {
          if (((*n1_) * (*n2_) <= 131072) || ((*n1_) <= 8192)) {
            nb_ = (*n1_);
          }
          else {
            nb_ = 32768 / (*n2_);
          }
        }
      }
      else {
        if (sname_) {
          nb_ = 1;
        }
        else {
          nb_ = 1;
        }
      }
    }
    else if ((strcmp (c3_, _dc_112) == 0)) {
      if (sname_) {
        nb_ = 32;
      }
      else {
        nb_ = 32;
      }
    }
    else if ((strcmp (c3_, _dc_113) == 0)) {
      if (sname_) {
        nb_ = 32;
      }
      else {
        nb_ = 32;
      }
    }
    else if ((strcmp (c3_, _dc_114) == 0)) {
      if (sname_) {
        nb_ = 64;
      }
      else {
        nb_ = 64;
      }
    }
  }
  else if ((strcmp (c2_, _dc_115) == 0)) {
    if ((strcmp (c3_, _dc_105) == 0)) {
      if (sname_) {
        nb_ = 64;
      }
      else {
        nb_ = 64;
      }
    }
  }
  else if ((strcmp (c2_, _dc_116) == 0)) {
    if ((strcmp (c3_, _dc_105) == 0)) {
      if (sname_) {
        if (twostage_) {
          nb_ = 192;
        }
        else {
          nb_ = 64;
        }
      }
      else {
        if (twostage_) {
          nb_ = 192;
        }
        else {
          nb_ = 64;
        }
      }
    }
    else if (sname_ && (strcmp (c3_, _dc_117) == 0)) {
      nb_ = 32;
    }
    else if (sname_ && (strcmp (c3_, _dc_118) == 0)) {
      nb_ = 64;
    }
  }
  else if (cname_ && (strcmp (c2_, _dc_119) == 0)) {
    if ((strcmp (c3_, _dc_105) == 0)) {
      if (twostage_) {
        nb_ = 192;
      }
      else {
        nb_ = 64;
      }
    }
    else if ((strcmp (c3_, _dc_117) == 0)) {
      nb_ = 32;
    }
    else if ((strcmp (c3_, _dc_118) == 0)) {
      nb_ = 64;
    }
  }
  else if (sname_ && (strcmp (c2_, _dc_120) == 0)) {
    if ((strcmp (_bufsub ((char *) $10_, (char *) c3_, 1, 1), _dc_9) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nb_ = 32;
      }
    }
    else if ((strcmp (_bufsub ((char *) $11_, (char *) c3_, 1, 1), _dc_8) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nb_ = 32;
      }
    }
  }
  else if (cname_ && (strcmp (c2_, _dc_128) == 0)) {
    if ((strcmp (_bufsub ((char *) $12_, (char *) c3_, 1, 1), _dc_9) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nb_ = 32;
      }
    }
    else if ((strcmp (_bufsub ((char *) $13_, (char *) c3_, 1, 1), _dc_8) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nb_ = 32;
      }
    }
  }
  else if ((strcmp (c2_, _dc_129) == 0)) {
    if ((strcmp (c3_, _dc_105) == 0)) {
      if (sname_) {
        if ((*n4_) <= 64) {
          nb_ = 1;
        }
        else {
          nb_ = 32;
        }
      }
      else {
        if ((*n4_) <= 64) {
          nb_ = 1;
        }
        else {
          nb_ = 32;
        }
      }
    }
  }
  else if ((strcmp (c2_, _dc_130) == 0)) {
    if ((strcmp (c3_, _dc_105) == 0)) {
      if (sname_) {
        if ((*n2_) <= 64) {
          nb_ = 1;
        }
        else {
          nb_ = 32;
        }
      }
      else {
        if ((*n2_) <= 64) {
          nb_ = 1;
        }
        else {
          nb_ = 32;
        }
      }
    }
  }
  else if ((strcmp (c2_, _dc_126) == 0)) {
    if ((strcmp (c3_, _dc_114) == 0)) {
      if (sname_) {
        nb_ = 64;
      }
      else {
        nb_ = 64;
      }
    }
    else if ((strcmp (c3_, _dc_131) == 0)) {
      if (sname_) {
        nb_ = 64;
      }
      else {
        nb_ = 64;
      }
    }
  }
  else if ((strcmp (c2_, _dc_132) == 0)) {
    if ((strcmp (c3_, _dc_133) == 0)) {
      if (sname_) {
        nb_ = 64;
      }
      else {
        nb_ = 64;
      }
    }
  }
  else if (sname_ && (strcmp (c2_, _dc_134) == 0)) {
    if ((strcmp (c3_, _dc_135) == 0)) {
      nb_ = 1;
    }
  }
  else if ((strcmp (c2_, _dc_136) == 0)) {
    nb_ = 32;
    if ((strcmp (c3_, _dc_137) == 0)) {
      if (sname_) {
        nb_ = 32;
      }
      else {
        nb_ = 32;
      }
    }
  }
  ilaenv_ = nb_;
  goto _l0;
  _l60:;
  nbmin_ = 2;
  if ((strcmp (c2_, _dc_104) == 0)) {
    if ((strcmp (c3_, _dc_106) == 0) || (strcmp (c3_, _dc_107) == 0) || (strcmp (c3_, _dc_108) == 0) || (strcmp (c3_, 
      _dc_109) == 0)) {
      if (sname_) {
        nbmin_ = 2;
      }
      else {
        nbmin_ = 2;
      }
    }
    else if ((strcmp (c3_, _dc_112) == 0)) {
      if (sname_) {
        nbmin_ = 2;
      }
      else {
        nbmin_ = 2;
      }
    }
    else if ((strcmp (c3_, _dc_113) == 0)) {
      if (sname_) {
        nbmin_ = 2;
      }
      else {
        nbmin_ = 2;
      }
    }
    else if ((strcmp (c3_, _dc_114) == 0)) {
      if (sname_) {
        nbmin_ = 2;
      }
      else {
        nbmin_ = 2;
      }
    }
  }
  else if ((strcmp (c2_, _dc_116) == 0)) {
    if ((strcmp (c3_, _dc_105) == 0)) {
      if (sname_) {
        nbmin_ = 8;
      }
      else {
        nbmin_ = 8;
      }
    }
    else if (sname_ && (strcmp (c3_, _dc_117) == 0)) {
      nbmin_ = 2;
    }
  }
  else if (cname_ && (strcmp (c2_, _dc_119) == 0)) {
    if ((strcmp (c3_, _dc_117) == 0)) {
      nbmin_ = 2;
    }
  }
  else if (sname_ && (strcmp (c2_, _dc_120) == 0)) {
    if ((strcmp (_bufsub ((char *) $14_, (char *) c3_, 1, 1), _dc_9) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nbmin_ = 2;
      }
    }
    else if ((strcmp (_bufsub ((char *) $15_, (char *) c3_, 1, 1), _dc_8) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nbmin_ = 2;
      }
    }
  }
  else if (cname_ && (strcmp (c2_, _dc_128) == 0)) {
    if ((strcmp (_bufsub ((char *) $16_, (char *) c3_, 1, 1), _dc_9) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nbmin_ = 2;
      }
    }
    else if ((strcmp (_bufsub ((char *) $17_, (char *) c3_, 1, 1), _dc_8) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nbmin_ = 2;
      }
    }
  }
  else if ((strcmp (c2_, _dc_136) == 0)) {
    nbmin_ = 2;
    if ((strcmp (c3_, _dc_137) == 0)) {
      nbmin_ = 2;
    }
  }
  ilaenv_ = nbmin_;
  goto _l0;
  _l70:;
  nx_ = 0;
  if ((strcmp (c2_, _dc_104) == 0)) {
    if ((strcmp (c3_, _dc_106) == 0) || (strcmp (c3_, _dc_107) == 0) || (strcmp (c3_, _dc_108) == 0) || (strcmp (c3_, 
      _dc_109) == 0)) {
      if (sname_) {
        nx_ = 128;
      }
      else {
        nx_ = 128;
      }
    }
    else if ((strcmp (c3_, _dc_112) == 0)) {
      if (sname_) {
        nx_ = 128;
      }
      else {
        nx_ = 128;
      }
    }
    else if ((strcmp (c3_, _dc_113) == 0)) {
      if (sname_) {
        nx_ = 128;
      }
      else {
        nx_ = 128;
      }
    }
  }
  else if ((strcmp (c2_, _dc_116) == 0)) {
    if (sname_ && (strcmp (c3_, _dc_117) == 0)) {
      nx_ = 32;
    }
  }
  else if (cname_ && (strcmp (c2_, _dc_119) == 0)) {
    if ((strcmp (c3_, _dc_117) == 0)) {
      nx_ = 32;
    }
  }
  else if (sname_ && (strcmp (c2_, _dc_120) == 0)) {
    if ((strcmp (_bufsub ((char *) $18_, (char *) c3_, 1, 1), _dc_9) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nx_ = 128;
      }
    }
  }
  else if (cname_ && (strcmp (c2_, _dc_128) == 0)) {
    if ((strcmp (_bufsub ((char *) $19_, (char *) c3_, 1, 1), _dc_9) == 0)) {
      if ((strcmp (c4_, _dc_121) == 0) || (strcmp (c4_, _dc_122) == 0) || (strcmp (c4_, _dc_123) == 0) || (strcmp (c4_, 
        _dc_124) == 0) || (strcmp (c4_, _dc_125) == 0) || (strcmp (c4_, _dc_126) == 0) || (strcmp (c4_, _dc_127) == 0)) {
        nx_ = 128;
      }
    }
  }
  else if ((strcmp (c2_, _dc_136) == 0)) {
    nx_ = 128;
    if ((strcmp (c3_, _dc_137) == 0)) {
      nx_ = 128;
    }
  }
  ilaenv_ = nx_;
  goto _l0;
  _l80:;
  ilaenv_ = 6;
  goto _l0;
  _l90:;
  ilaenv_ = 2;
  goto _l0;
  _l100:;
  ilaenv_ = (int_4) (_aintd ((real_4) (_min ((*n1_), (*n2_))) * 1.6e0));
  goto _l0;
  _l110:;
  ilaenv_ = 1;
  goto _l0;
  _l120:;
  ilaenv_ = 50;
  goto _l0;
  _l130:;
  ilaenv_ = 25;
  goto _l0;
  _l140:;
  ilaenv_ = 1;
  if (ilaenv_ == 1) {
    ilaenv_ = _ieeeck (&_k1, ($20_ = 0.0, &$20_), ($21_ = 1.0, &$21_));
  }
  goto _l0;
  _l150:;
  ilaenv_ = 1;
  if (ilaenv_ == 1) {
    ilaenv_ = _ieeeck (&_k0, ($22_ = 0.0, &$22_), ($23_ = 1.0, &$23_));
  }
  goto _l0;
  _l160:;
  ilaenv_ = _iparmq (ispec_, name_, opts_, n1_, n2_, n3_, n4_);
  _l0:;
  __calls[83].calls++;
  return ilaenv_;
}

int_4 _iparmq (int_4 _p_ ispec_, char _p_ name_, char _p_ opts_, int_4 _p_ n_, int_4 _p_ ilo_, int_4 _p_ ihi_, int_4 
_p_ lwork_)
{
  static int_4 nh_, ns_, i_, ic_, iz_;
  static char_7 subnam_;
  char_7 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  int_4 iparmq_;
  if (((*ispec_) == 15) || ((*ispec_) == 13) || ((*ispec_) == 16)) {
    nh_ = (*ihi_) - (*ilo_) + 1;
    ns_ = 2;
    if (nh_ >= 30) {
      ns_ = 4;
    }
    if (nh_ >= 60) {
      ns_ = 10;
    }
    if (nh_ >= 150) {
      ns_ = _max (10, nh_ / _nintf (logf ((real_4) (nh_)) / 
      6.9314718055994530941723212145817656807550013436025525412068000949339362e-1));
    }
    if (nh_ >= 590) {
      ns_ = 64;
    }
    if (nh_ >= 3000) {
      ns_ = 128;
    }
    if (nh_ >= 6000) {
      ns_ = 256;
    }
    ns_ = _max (2, ns_ - _imod (ns_, 2));
  }
  if ((*ispec_) == 12) {
    iparmq_ = 75;
  }
  else if ((*ispec_) == 14) {
    iparmq_ = 14;
  }
  else if ((*ispec_) == 15) {
    iparmq_ = ns_;
  }
  else if ((*ispec_) == 13) {
    if (nh_ <= 500) {
      iparmq_ = ns_;
    }
    else {
      iparmq_ = 3 * ns_ / 2;
    }
  }
  else if ((*ispec_) == 16) {
    iparmq_ = 0;
    bufcpy (subnam_, name_, 7);
    ic_ = _ichar (_bufsub ((char *) $0_, (char *) subnam_, 1, 1));
    iz_ = _ichar (_dc_75);
    if (iz_ == 90 || iz_ == 122) {
      if (ic_ >= 97 && ic_ <= 122) {
        bufrep ((char *) &(subnam_[0]), _char (ic_ - 32));
        for (i_ = 2; i_ <= 6; (i_)++) {
          ic_ = _ichar (_bufsub ((char *) $1_, (char *) subnam_, i_, i_));
          if (ic_ >= 97 && ic_ <= 122) {
            bufrep ((char *) &(subnam_[i_ - 1]), _char (ic_ - 32));
          }
        }
      }
    }
    else if (iz_ == 233 || iz_ == 169) {
      if ((ic_ >= 129 && ic_ <= 137) || (ic_ >= 145 && ic_ <= 153) || (ic_ >= 162 && ic_ <= 169)) {
        bufrep ((char *) &(subnam_[0]), _char (ic_ + 64));
        for (i_ = 2; i_ <= 6; (i_)++) {
          ic_ = _ichar (_bufsub ((char *) $2_, (char *) subnam_, i_, i_));
          if ((ic_ >= 129 && ic_ <= 137) || (ic_ >= 145 && ic_ <= 153) || (ic_ >= 162 && ic_ <= 169)) {
            bufrep ((char *) &(subnam_[i_ - 1]), _char (ic_ + 64));
          }
        }
      }
    }
    else if (iz_ == 218 || iz_ == 250) {
      if (ic_ >= 225 && ic_ <= 250) {
        bufrep ((char *) &(subnam_[0]), _char (ic_ - 32));
        for (i_ = 2; i_ <= 6; (i_)++) {
          ic_ = _ichar (_bufsub ((char *) $3_, (char *) subnam_, i_, i_));
          if (ic_ >= 225 && ic_ <= 250) {
            bufrep ((char *) &(subnam_[i_ - 1]), _char (ic_ - 32));
          }
        }
      }
    }
    if ((strcmp (_bufsub ((char *) $4_, (char *) subnam_, 2, 6), _dc_138) == 0) || (strcmp (_bufsub ((char *) $5_, (char *) 
      subnam_, 2, 6), _dc_139) == 0)) {
      iparmq_ = 1;
      if (nh_ >= 14) {
        iparmq_ = 2;
      }
    }
    else if ((strcmp (_bufsub ((char *) $6_, (char *) subnam_, 4, 6), _dc_140) == 0)) {
      if (nh_ >= 14) {
        iparmq_ = 1;
      }
      if (nh_ >= 14) {
        iparmq_ = 2;
      }
    }
    else if ((strcmp (_bufsub ((char *) $7_, (char *) subnam_, 2, 6), _dc_141) == 0) || (strcmp (_bufsub ((char *) $8_, 
      (char *) subnam_, 2, 5), _dc_142) == 0)) {
      if (ns_ >= 14) {
        iparmq_ = 1;
      }
      if (ns_ >= 14) {
        iparmq_ = 2;
      }
    }
  }
  else {
    iparmq_ = -1;
  }
  __calls[84].calls++;
  return iparmq_;
}

