//! @file mathlib-linpack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 177 subprograms from LINPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CCHDC  CHPDI  CSICO  DGBFA  DPPSL  SCHEX  SPOSL  STRDI  ZHIFA  ZPPFA
// CCHDD  CHPFA  CSIDI  DGBSL  DPTSL  SCHUD  SPPCO  STRSL  ZHISL  ZPPSL
// CCHEX  CHPSL  CSIFA  DGECO  DQRDC  SGBCO  SPPDI  ZCHDC  ZHPCO  ZPTSL
// CCHUD  CPBCO  CSISL  DGEDI  DQRSL  SGBDI  SPPFA  ZCHDD  ZHPDI  ZQRDC
// CGBCO  CPBDI  CSPCO  DGEFA  DSICO  SGBFA  SPPSL  ZCHEX  ZHPFA  ZQRSL
// CGBDI  CPBFA  CSPDI  DGESL  DSIDI  SGBSL  SPTSL  ZCHUD  ZHPSL  ZSICO
// CGBFA  CPBSL  CSPFA  DGTSL  DSIFA  SGECO  SQRDC  ZGBCO  ZMACH  ZSIDI
// CGBSL  CPOCO  CSPSL  DPBCO  DSISL  SGEDI  SQRSL  ZGBDI  ZPBCO  ZSIFA
// CGECO  CPODI  CSVDC  DPBDI  DSPCO  SGEFA  SSICO  ZGBFA  ZPBDI  ZSISL
// CGEDI  CPOFA  CTRCO  DPBFA  DSPDI  SGESL  SSIDI  ZGBSL  ZPBFA  ZSPCO
// CGEFA  CPOSL  CTRDI  DPBSL  DSPFA  SGTSL  SSIFA  ZGECO  ZPBSL  ZSPDI
// CGESL  CPPCO  CTRSL  DPOCO  DSPSL  SPBCO  SSISL  ZGEDI  ZPOCO  ZSPFA
// CGTSL  CPPDI  DCHDC  DPODI  DSVDC  SPBDI  SSPCO  ZGEFA  ZPODI  ZSPSL
// CHICO  CPPFA  DCHDD  DPOFA  DTRCO  SPBFA  SSPDI  ZGESL  ZPOFA  ZSVDC
// CHIDI  CPPSL  DCHEX  DPOSL  DTRDI  SPBSL  SSPFA  ZGTSL  ZPOSL  ZTRCO
// CHIFA  CPTSL  DCHUD  DPPCO  DTRSL  SPOCO  SSPSL  ZHICO  ZPPCO  ZTRDI
// CHISL  CQRDC  DGBCO  DPPDI  SCHDC  SPODI  SSVDC  ZHIDI  ZPPDI  ZTRSL
// CHPCO  CQRSL  DGBDI  DPPFA  SCHDD  SPOFA  STRCO

// LINPACK is a collection of Fortran subroutines that analyze and
// solve linear equations and linear least-squares probles.  The
// package solves linear systems whose matrices are general, banded,
// symmetric indefinite, symmetric positive definite, triangular,
// and tridiagonal square.  In addition, the package computes
// the QR and singular value decompositions of rectangular matrices
// and applies them to least-squares problems.  LINPACK uses
// column-oriented algorithms to increase efficiency by preserving
// locality of reference.
// 
// LINPACK was designed for supercomputers in use in the 1970s and
// early 1980s. LINPACK has been largely superceded by LAPACK
// which has been designed to run efficiently on shared-memory, vector
// supercomputers.
// 
// Original authors are Jack Dongarra, Jim Bunch, Cleve Moler,
// Pete Stewart, et alii.
// 
// Source: netlib/linpack/

// The license for LINPACK Fortran source code is:
//
// LINPACK is licensed under the Modified 3 clause BSD license.
// 
// Prof. Jack Dongarra; Innovative Computing Laboratory; EECS Department;
// 1122 Volunteer Blvd; University of Tennessee; Knoxville TN 37996-3450;
// +1-865-974-8295; dongarra.edu; http://www.cs.utk.edu/~dongarra/
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// 
// * Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
// 
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
// 
// * Neither the name of [project] nor the names of its
//   contributors may be used to endorse or promote products derived from
//   this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
static FORMAT *__fmt_a = NULL;
#define __ncalls 178
static CALLS __calls[__ncalls] = {
  {"cchdc", 0}, // subroutine
  {"cchdd", 0}, // subroutine
  {"cchex", 0}, // subroutine
  {"cchud", 0}, // subroutine
  {"cgbco", 0}, // subroutine
  {"cgbdi", 0}, // subroutine
  {"cgbfa", 0}, // subroutine
  {"cgbsl", 0}, // subroutine
  {"cgeco", 0}, // subroutine
  {"cgedi", 0}, // subroutine
  {"cgefa", 0}, // subroutine
  {"cgesl", 0}, // subroutine
  {"cgtsl", 0}, // subroutine
  {"chico", 0}, // subroutine
  {"chidi", 0}, // subroutine
  {"chifa", 0}, // subroutine
  {"chisl", 0}, // subroutine
  {"chpco", 0}, // subroutine
  {"chpdi", 0}, // subroutine
  {"chpfa", 0}, // subroutine
  {"chpsl", 0}, // subroutine
  {"cpbco", 0}, // subroutine
  {"cpbdi", 0}, // subroutine
  {"cpbfa", 0}, // subroutine
  {"cpbsl", 0}, // subroutine
  {"cpoco", 0}, // subroutine
  {"cpodi", 0}, // subroutine
  {"cpofa", 0}, // subroutine
  {"cposl", 0}, // subroutine
  {"cppco", 0}, // subroutine
  {"cppdi", 0}, // subroutine
  {"cppfa", 0}, // subroutine
  {"cppsl", 0}, // subroutine
  {"cptsl", 0}, // subroutine
  {"cqrdc", 0}, // subroutine
  {"cqrsl", 0}, // subroutine
  {"csico", 0}, // subroutine
  {"csidi", 0}, // subroutine
  {"csifa", 0}, // subroutine
  {"csisl", 0}, // subroutine
  {"cspco", 0}, // subroutine
  {"cspdi", 0}, // subroutine
  {"cspfa", 0}, // subroutine
  {"cspsl", 0}, // subroutine
  {"csvdc", 0}, // subroutine
  {"ctrco", 0}, // subroutine
  {"ctrdi", 0}, // subroutine
  {"ctrsl", 0}, // subroutine
  {"dchdc", 0}, // subroutine
  {"dchdd", 0}, // subroutine
  {"dchex", 0}, // subroutine
  {"dchud", 0}, // subroutine
  {"dgbco", 0}, // subroutine
  {"dgbdi", 0}, // subroutine
  {"dgbfa", 0}, // subroutine
  {"dgbsl", 0}, // subroutine
  {"dgeco", 0}, // subroutine
  {"dgedi", 0}, // subroutine
  {"dgefa", 0}, // subroutine
  {"dgesl", 0}, // subroutine
  {"dgtsl", 0}, // subroutine
  {"dpbco", 0}, // subroutine
  {"dpbdi", 0}, // subroutine
  {"dpbfa", 0}, // subroutine
  {"dpbsl", 0}, // subroutine
  {"dpoco", 0}, // subroutine
  {"dpodi", 0}, // subroutine
  {"dpofa", 0}, // subroutine
  {"dposl", 0}, // subroutine
  {"dppco", 0}, // subroutine
  {"dppdi", 0}, // subroutine
  {"dppfa", 0}, // subroutine
  {"dppsl", 0}, // subroutine
  {"dptsl", 0}, // subroutine
  {"dqrdc", 0}, // subroutine
  {"dqrsl", 0}, // subroutine
  {"dsico", 0}, // subroutine
  {"dsidi", 0}, // subroutine
  {"dsifa", 0}, // subroutine
  {"dsisl", 0}, // subroutine
  {"dspco", 0}, // subroutine
  {"dspdi", 0}, // subroutine
  {"dspfa", 0}, // subroutine
  {"dspsl", 0}, // subroutine
  {"dsvdc", 0}, // subroutine
  {"dtrco", 0}, // subroutine
  {"dtrdi", 0}, // subroutine
  {"dtrsl", 0}, // subroutine
  {"schdc", 0}, // subroutine
  {"schdd", 0}, // subroutine
  {"schex", 0}, // subroutine
  {"schud", 0}, // subroutine
  {"sgbco", 0}, // subroutine
  {"sgbdi", 0}, // subroutine
  {"sgbfa", 0}, // subroutine
  {"sgbsl", 0}, // subroutine
  {"sgeco", 0}, // subroutine
  {"sgedi", 0}, // subroutine
  {"sgefa", 0}, // subroutine
  {"sgesl", 0}, // subroutine
  {"sgtsl", 0}, // subroutine
  {"spbco", 0}, // subroutine
  {"spbdi", 0}, // subroutine
  {"spbfa", 0}, // subroutine
  {"spbsl", 0}, // subroutine
  {"spoco", 0}, // subroutine
  {"spodi", 0}, // subroutine
  {"spofa", 0}, // subroutine
  {"sposl", 0}, // subroutine
  {"sppco", 0}, // subroutine
  {"sppdi", 0}, // subroutine
  {"sppfa", 0}, // subroutine
  {"sppsl", 0}, // subroutine
  {"sptsl", 0}, // subroutine
  {"sqrdc", 0}, // subroutine
  {"sqrsl", 0}, // subroutine
  {"ssico", 0}, // subroutine
  {"ssidi", 0}, // subroutine
  {"ssifa", 0}, // subroutine
  {"ssisl", 0}, // subroutine
  {"sspco", 0}, // subroutine
  {"sspdi", 0}, // subroutine
  {"sspfa", 0}, // subroutine
  {"sspsl", 0}, // subroutine
  {"ssvdc", 0}, // subroutine
  {"strco", 0}, // subroutine
  {"strdi", 0}, // subroutine
  {"strsl", 0}, // subroutine
  {"zchdc", 0}, // subroutine
  {"zchdd", 0}, // subroutine
  {"zchex", 0}, // subroutine
  {"zchud", 0}, // subroutine
  {"zgbco", 0}, // subroutine
  {"zgbdi", 0}, // subroutine
  {"zgbfa", 0}, // subroutine
  {"zgbsl", 0}, // subroutine
  {"zgeco", 0}, // subroutine
  {"zgedi", 0}, // subroutine
  {"zgefa", 0}, // subroutine
  {"zgesl", 0}, // subroutine
  {"zgtsl", 0}, // subroutine
  {"zhico", 0}, // subroutine
  {"zhidi", 0}, // subroutine
  {"zhifa", 0}, // subroutine
  {"zhisl", 0}, // subroutine
  {"zhpco", 0}, // subroutine
  {"zhpdi", 0}, // subroutine
  {"zhpfa", 0}, // subroutine
  {"zhpsl", 0}, // subroutine
  {"zmach", 0}, // real*8 function
  {"zpbco", 0}, // subroutine
  {"zpbdi", 0}, // subroutine
  {"zpbfa", 0}, // subroutine
  {"zpbsl", 0}, // subroutine
  {"zpoco", 0}, // subroutine
  {"zpodi", 0}, // subroutine
  {"zpofa", 0}, // subroutine
  {"zposl", 0}, // subroutine
  {"zppco", 0}, // subroutine
  {"zppdi", 0}, // subroutine
  {"zppfa", 0}, // subroutine
  {"zppsl", 0}, // subroutine
  {"zptsl", 0}, // subroutine
  {"zqrdc", 0}, // subroutine
  {"zqrsl", 0}, // subroutine
  {"zsico", 0}, // subroutine
  {"zsidi", 0}, // subroutine
  {"zsifa", 0}, // subroutine
  {"zsisl", 0}, // subroutine
  {"zspco", 0}, // subroutine
  {"zspdi", 0}, // subroutine
  {"zspfa", 0}, // subroutine
  {"zspsl", 0}, // subroutine
  {"zsvdc", 0}, // subroutine
  {"ztrco", 0}, // subroutine
  {"ztrdi", 0}, // subroutine
  {"ztrsl", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _cchdc (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ p_, complex_8 _p_ work_, int_4 _p_ jpvt_, int_4 _p_ 
job_, int_4 _p_ info_);
prototype int_4 _cchdd (complex_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, complex_8 _p_ x_, complex_8 _p_ z_, int_4 _p_ 
ldz_, int_4 _p_ nz_, complex_8 _p_ y_, real_4 _p_ rho_, real_4 _p_ c_, complex_8 _p_ s_, int_4 _p_ info_);
prototype int_4 _cchex (complex_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, int_4 _p_ k_, int_4 _p_ l_, complex_8 _p_ z_, 
int_4 _p_ ldz_, int_4 _p_ nz_, real_4 _p_ c_, complex_8 _p_ s_, int_4 _p_ job_);
prototype int_4 _cchud (complex_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, complex_8 _p_ x_, complex_8 _p_ z_, int_4 _p_ 
ldz_, int_4 _p_ nz_, complex_8 _p_ y_, real_4 _p_ rho_, real_4 _p_ c_, complex_8 _p_ s_);
prototype int_4 _cgbco (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_
, real_4 _p_ rcond_, complex_8 _p_ z_);
prototype int_4 _cgbdi (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_
, complex_8 _p_ det_);
prototype int_4 _cgbfa (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_
, int_4 _p_ info_);
prototype int_4 _cgbsl (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_
, complex_8 _p_ b_, int_4 _p_ job_);
prototype int_4 _cgeco (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_4 _p_ rcond_, complex_8 
_p_ z_);
prototype int_4 _cgedi (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, complex_8 _p_ det_, complex_8 
_p_ work_, int_4 _p_ job_);
prototype int_4 _cgefa (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_);
prototype int_4 _cgesl (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, complex_8 _p_ b_, int_4 _p_ 
job_);
prototype int_4 _cgtsl (int_4 _p_ n_, complex_8 _p_ c_, complex_8 _p_ d_, complex_8 _p_ e_, complex_8 _p_ b_, int_4 _p_ 
info_);
prototype int_4 _chico (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, complex_8 
_p_ z_);
prototype int_4 _chidi (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ det_, int_4 _p_ 
inert_, complex_8 _p_ work_, int_4 _p_ job_);
prototype int_4 _chifa (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _chisl (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ b_);
prototype int_4 _chpco (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, complex_8 _p_ z_);
prototype int_4 _chpdi (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ det_, int_4 _p_ inert_, complex_8 
_p_ work_, int_4 _p_ job_);
prototype int_4 _chpfa (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _chpsl (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ b_);
prototype int_4 _cpbco (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ rcond_, complex_8 
_p_ z_, int_4 _p_ info_);
prototype int_4 _cpbdi (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ det_);
prototype int_4 _cpbfa (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ info_);
prototype int_4 _cpbsl (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, complex_8 _p_ b_);
prototype int_4 _cpoco (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ rcond_, complex_8 _p_ z_, int_4 _p_ 
info_);
prototype int_4 _cpodi (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_);
prototype int_4 _cpofa (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _cposl (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ b_);
prototype int_4 _cppco (complex_8 _p_ ap_, int_4 _p_ n_, real_4 _p_ rcond_, complex_8 _p_ z_, int_4 _p_ info_);
prototype int_4 _cppdi (complex_8 _p_ ap_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_);
prototype int_4 _cppfa (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _cppsl (complex_8 _p_ ap_, int_4 _p_ n_, complex_8 _p_ b_);
prototype int_4 _cptsl (int_4 _p_ n_, complex_8 _p_ d_, complex_8 _p_ e_, complex_8 _p_ b_);
prototype int_4 _cqrdc (complex_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, complex_8 _p_ qraux_, int_4 _p_ 
jpvt_, complex_8 _p_ work_, int_4 _p_ job_);
prototype int_4 _cqrsl (complex_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ qraux_, complex_8 
_p_ y_, complex_8 _p_ qy_, complex_8 _p_ qty_, complex_8 _p_ b_, complex_8 _p_ rsd_, complex_8 _p_ xb_, int_4 _p_ job_, 
int_4 _p_ info_);
prototype int_4 _csico (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, complex_8 
_p_ z_);
prototype int_4 _csidi (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ det_, complex_8 
_p_ work_, int_4 _p_ job_);
prototype int_4 _csifa (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _csisl (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ b_);
prototype int_4 _cspco (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, complex_8 _p_ z_);
prototype int_4 _cspdi (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ det_, complex_8 _p_ work_, 
int_4 _p_ job_);
prototype int_4 _cspfa (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _cspsl (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ b_);
prototype int_4 _csvdc (complex_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, complex_8 _p_ s_, complex_8 _p_ 
e_, complex_8 _p_ u_, int_4 _p_ ldu_, complex_8 _p_ v_, int_4 _p_ ldv_, complex_8 _p_ work_, int_4 _p_ job_, int_4 _p_ 
info_);
prototype int_4 _ctrco (complex_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_4 _p_ rcond_, complex_8 _p_ z_, int_4 _p_ 
job_);
prototype int_4 _ctrdi (complex_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, complex_8 _p_ det_, int_4 _p_ job_, int_4 _p_ 
info_);
prototype int_4 _ctrsl (complex_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, complex_8 _p_ b_, int_4 _p_ job_, int_4 _p_ 
info_);
prototype int_4 _dchdc (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ p_, real_8 _p_ work_, int_4 _p_ jpvt_, int_4 _p_ job_, 
int_4 _p_ info_);
prototype int_4 _dchdd (real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, real_8 _p_ x_, real_8 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ nz_, real_8 _p_ y_, real_8 _p_ rho_, real_8 _p_ c_, real_8 _p_ s_, int_4 _p_ info_);
prototype int_4 _dchex (real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, int_4 _p_ k_, int_4 _p_ l_, real_8 _p_ z_, int_4 
_p_ ldz_, int_4 _p_ nz_, real_8 _p_ c_, real_8 _p_ s_, int_4 _p_ job_);
prototype int_4 _dchud (real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, real_8 _p_ x_, real_8 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ nz_, real_8 _p_ y_, real_8 _p_ rho_, real_8 _p_ c_, real_8 _p_ s_);
prototype int_4 _dgbco (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_8 _p_ rcond_, real_8 _p_ z_);
prototype int_4 _dgbdi (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_8 _p_ det_);
prototype int_4 _dgbfa (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
int_4 _p_ info_);
prototype int_4 _dgbsl (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_8 _p_ b_, int_4 _p_ job_);
prototype int_4 _dgeco (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ rcond_, real_8 _p_ z_)
;
prototype int_4 _dgedi (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ det_, real_8 _p_ work_
, int_4 _p_ job_);
prototype int_4 _dgefa (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_);
prototype int_4 _dgesl (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ b_, int_4 _p_ job_);
prototype int_4 _dgtsl (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ b_, int_4 _p_ info_);
prototype int_4 _dpbco (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ rcond_, real_8 _p_ z_, 
int_4 _p_ info_);
prototype int_4 _dpbdi (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ det_);
prototype int_4 _dpbfa (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ info_);
prototype int_4 _dpbsl (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ b_);
prototype int_4 _dpoco (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ rcond_, real_8 _p_ z_, int_4 _p_ info_)
;
prototype int_4 _dpodi (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_);
prototype int_4 _dpofa (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _dposl (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ b_);
prototype int_4 _dppco (real_8 _p_ ap_, int_4 _p_ n_, real_8 _p_ rcond_, real_8 _p_ z_, int_4 _p_ info_);
prototype int_4 _dppdi (real_8 _p_ ap_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_);
prototype int_4 _dppfa (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _dppsl (real_8 _p_ ap_, int_4 _p_ n_, real_8 _p_ b_);
prototype int_4 _dptsl (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ b_);
prototype int_4 _dqrdc (real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, real_8 _p_ qraux_, int_4 _p_ jpvt_, 
real_8 _p_ work_, int_4 _p_ job_);
prototype int_4 _dqrsl (real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ qraux_, real_8 _p_ y_, 
real_8 _p_ qy_, real_8 _p_ qty_, real_8 _p_ b_, real_8 _p_ rsd_, real_8 _p_ xb_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _dsico (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, real_8 _p_ z_)
;
prototype int_4 _dsidi (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ det_, int_4 _p_ inert_
, real_8 _p_ work_, int_4 _p_ job_);
prototype int_4 _dsifa (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _dsisl (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ b_);
prototype int_4 _dspco (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, real_8 _p_ z_);
prototype int_4 _dspdi (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ det_, int_4 _p_ inert_, real_8 _p_ 
work_, int_4 _p_ job_);
prototype int_4 _dspfa (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _dspsl (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ b_);
prototype int_4 _dsvdc (real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, real_8 _p_ s_, real_8 _p_ e_, real_8 
_p_ u_, int_4 _p_ ldu_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ work_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _dtrco (real_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_8 _p_ rcond_, real_8 _p_ z_, int_4 _p_ job_);
prototype int_4 _dtrdi (real_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _dtrsl (real_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _schdc (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ p_, real_4 _p_ work_, int_4 _p_ jpvt_, int_4 _p_ job_, 
int_4 _p_ info_);
prototype int_4 _schdd (real_4 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, real_4 _p_ x_, real_4 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ nz_, real_4 _p_ y_, real_4 _p_ rho_, real_4 _p_ c_, real_4 _p_ s_, int_4 _p_ info_);
prototype int_4 _schex (real_4 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, int_4 _p_ k_, int_4 _p_ l_, real_4 _p_ z_, int_4 
_p_ ldz_, int_4 _p_ nz_, real_4 _p_ c_, real_4 _p_ s_, int_4 _p_ job_);
prototype int_4 _schud (real_4 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, real_4 _p_ x_, real_4 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ nz_, real_4 _p_ y_, real_4 _p_ rho_, real_4 _p_ c_, real_4 _p_ s_);
prototype int_4 _sgbco (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_4 _p_ rcond_, real_4 _p_ z_);
prototype int_4 _sgbdi (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_4 _p_ det_);
prototype int_4 _sgbfa (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
int_4 _p_ info_);
prototype int_4 _sgbsl (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_4 _p_ b_, int_4 _p_ job_);
prototype int_4 _sgeco (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_4 _p_ rcond_, real_4 _p_ z_)
;
prototype int_4 _sgedi (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_4 _p_ det_, real_4 _p_ work_
, int_4 _p_ job_);
prototype int_4 _sgefa (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_);
prototype int_4 _sgesl (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_4 _p_ b_, int_4 _p_ job_);
prototype int_4 _sgtsl (int_4 _p_ n_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ b_, int_4 _p_ info_);
prototype int_4 _spbco (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ rcond_, real_4 _p_ z_, 
int_4 _p_ info_);
prototype int_4 _spbdi (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ det_);
prototype int_4 _spbfa (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ info_);
prototype int_4 _spbsl (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ b_);
prototype int_4 _spoco (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ rcond_, real_4 _p_ z_, int_4 _p_ info_)
;
prototype int_4 _spodi (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_);
prototype int_4 _spofa (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _sposl (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ b_);
prototype int_4 _sppco (real_4 _p_ ap_, int_4 _p_ n_, real_4 _p_ rcond_, real_4 _p_ z_, int_4 _p_ info_);
prototype int_4 _sppdi (real_4 _p_ ap_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_);
prototype int_4 _sppfa (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _sppsl (real_4 _p_ ap_, int_4 _p_ n_, real_4 _p_ b_);
prototype int_4 _sptsl (int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ b_);
prototype int_4 _sqrdc (real_4 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, real_4 _p_ qraux_, int_4 _p_ jpvt_, 
real_4 _p_ work_, int_4 _p_ job_);
prototype int_4 _sqrsl (real_4 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ qraux_, real_4 _p_ y_, 
real_4 _p_ qy_, real_4 _p_ qty_, real_4 _p_ b_, real_4 _p_ rsd_, real_4 _p_ xb_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _ssico (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, real_4 _p_ z_)
;
prototype int_4 _ssidi (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ det_, int_4 _p_ inert_
, real_4 _p_ work_, int_4 _p_ job_);
prototype int_4 _ssifa (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _ssisl (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ b_);
prototype int_4 _sspco (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, real_4 _p_ z_);
prototype int_4 _sspdi (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ det_, int_4 _p_ inert_, real_4 _p_ 
work_, int_4 _p_ job_);
prototype int_4 _sspfa (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _sspsl (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ b_);
prototype int_4 _ssvdc (real_4 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, real_4 _p_ s_, real_4 _p_ e_, real_4 
_p_ u_, int_4 _p_ ldu_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ work_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _strco (real_4 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_4 _p_ rcond_, real_4 _p_ z_, int_4 _p_ job_);
prototype int_4 _strdi (real_4 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _strsl (real_4 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_4 _p_ b_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _zchdc (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ p_, complex_16 _p_ work_, int_4 _p_ jpvt_, int_4 
_p_ job_, int_4 _p_ info_);
prototype int_4 _zchdd (complex_16 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, complex_16 _p_ x_, complex_16 _p_ z_, int_4 
_p_ ldz_, int_4 _p_ nz_, complex_16 _p_ y_, real_8 _p_ rho_, real_8 _p_ c_, complex_16 _p_ s_, int_4 _p_ info_);
prototype int_4 _zchex (complex_16 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, int_4 _p_ k_, int_4 _p_ l_, complex_16 _p_ z_, 
int_4 _p_ ldz_, int_4 _p_ nz_, real_8 _p_ c_, complex_16 _p_ s_, int_4 _p_ job_);
prototype int_4 _zchud (complex_16 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, complex_16 _p_ x_, complex_16 _p_ z_, int_4 
_p_ ldz_, int_4 _p_ nz_, complex_16 _p_ y_, real_8 _p_ rho_, real_8 _p_ c_, complex_16 _p_ s_);
prototype int_4 _zgbco (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ 
ipvt_, real_8 _p_ rcond_, complex_16 _p_ z_);
prototype int_4 _zgbdi (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ 
ipvt_, complex_16 _p_ det_);
prototype int_4 _zgbfa (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ 
ipvt_, int_4 _p_ info_);
prototype int_4 _zgbsl (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ 
ipvt_, complex_16 _p_ b_, int_4 _p_ job_);
prototype int_4 _zgeco (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ rcond_, complex_16 
_p_ z_);
prototype int_4 _zgedi (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, complex_16 _p_ det_, 
complex_16 _p_ work_, int_4 _p_ job_);
prototype int_4 _zgefa (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_);
prototype int_4 _zgesl (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, complex_16 _p_ b_, int_4 _p_ 
job_);
prototype int_4 _zgtsl (int_4 _p_ n_, complex_16 _p_ c_, complex_16 _p_ d_, complex_16 _p_ e_, complex_16 _p_ b_, int_4 
_p_ info_);
prototype int_4 _zhico (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, complex_16 
_p_ z_);
prototype int_4 _zhidi (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ det_, int_4 _p_ 
inert_, complex_16 _p_ work_, int_4 _p_ job_);
prototype int_4 _zhifa (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _zhisl (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ b_);
prototype int_4 _zhpco (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, complex_16 _p_ z_);
prototype int_4 _zhpdi (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ det_, int_4 _p_ inert_, 
complex_16 _p_ work_, int_4 _p_ job_);
prototype int_4 _zhpfa (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _zhpsl (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ b_);
prototype real_8 _zmach (int_4 _p_ job_);
prototype int_4 _zpbco (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ rcond_, complex_16 
_p_ z_, int_4 _p_ info_);
prototype int_4 _zpbdi (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ det_);
prototype int_4 _zpbfa (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ info_);
prototype int_4 _zpbsl (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, complex_16 _p_ b_);
prototype int_4 _zpoco (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ rcond_, complex_16 _p_ z_, int_4 
_p_ info_);
prototype int_4 _zpodi (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_);
prototype int_4 _zpofa (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _zposl (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_16 _p_ b_);
prototype int_4 _zppco (complex_16 _p_ ap_, int_4 _p_ n_, real_8 _p_ rcond_, complex_16 _p_ z_, int_4 _p_ info_);
prototype int_4 _zppdi (complex_16 _p_ ap_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_);
prototype int_4 _zppfa (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _zppsl (complex_16 _p_ ap_, int_4 _p_ n_, complex_16 _p_ b_);
prototype int_4 _zptsl (int_4 _p_ n_, complex_16 _p_ d_, complex_16 _p_ e_, complex_16 _p_ b_);
prototype int_4 _zqrdc (complex_16 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, complex_16 _p_ qraux_, int_4 _p_ 
jpvt_, complex_16 _p_ work_, int_4 _p_ job_);
prototype int_4 _zqrsl (complex_16 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ qraux_, 
complex_16 _p_ y_, complex_16 _p_ qy_, complex_16 _p_ qty_, complex_16 _p_ b_, complex_16 _p_ rsd_, complex_16 _p_ xb_, 
int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _zsico (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, complex_16 
_p_ z_);
prototype int_4 _zsidi (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ det_, 
complex_16 _p_ work_, int_4 _p_ job_);
prototype int_4 _zsifa (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _zsisl (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ b_);
prototype int_4 _zspco (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, complex_16 _p_ z_);
prototype int_4 _zspdi (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ det_, complex_16 _p_ work_, 
int_4 _p_ job_);
prototype int_4 _zspfa (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_);
prototype int_4 _zspsl (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ b_);
prototype int_4 _zsvdc (complex_16 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, complex_16 _p_ s_, complex_16 
_p_ e_, complex_16 _p_ u_, int_4 _p_ ldu_, complex_16 _p_ v_, int_4 _p_ ldv_, complex_16 _p_ work_, int_4 _p_ job_, 
int_4 _p_ info_);
prototype int_4 _ztrco (complex_16 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_8 _p_ rcond_, complex_16 _p_ z_, int_4 
_p_ job_);
prototype int_4 _ztrdi (complex_16 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, complex_16 _p_ det_, int_4 _p_ job_, int_4 _p_ 
info_);
prototype int_4 _ztrsl (complex_16 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, complex_16 _p_ b_, int_4 _p_ job_, int_4 _p_ 
info_);
int_4 _cchdc (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ p_, complex_8 _p_ work_, int_4 _p_ jpvt_, int_4 _p_ job_, 
int_4 _p_ info_)
{
  static int_4 pu_, pl_, plp1_, i_, j_, jp_, jt_, k_, kb_, km1_, kp1_, l_, maxl_;
  static logical_4 swapk_, negk_;
  static real_4 maxdia_;
  static complex_8 temp_;
  int_4 $0_, $1_, $2_;
  pl_ = 1;
  pu_ = 0;
  (*info_) = (*p_);
  if ((*job_) == 0) {
    goto _l160;
  }
  for (k_ = 1; k_ <= (*p_); (k_)++) {
    swapk_ = jpvt_[k_ - 1] > 0;
    negk_ = jpvt_[k_ - 1] < 0;
    jpvt_[k_ - 1] = k_;
    if (negk_) {
      jpvt_[k_ - 1] = -jpvt_[k_ - 1];
    }
    if (! (swapk_)) {
      goto _l60;
    }
    if (k_ == pl_) {
      goto _l50;
    }
    (void) _cswap (($0_ = pl_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((pl_ - 1))], &_k1);
    temp_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[pl_ - 1 + ((*lda_)) * ((pl_ - 1))];
    a_[pl_ - 1 + ((*lda_)) * ((pl_ - 1))] = temp_;
    a_[pl_ - 1 + ((*lda_)) * ((k_ - 1))] = conjf (a_[pl_ - 1 + ((*lda_)) * ((k_ - 1))]);
    plp1_ = pl_ + 1;
    if ((*p_) < plp1_) {
      goto _l40;
    }
    for (j_ = plp1_; j_ <= (*p_); (j_)++) {
      if (j_ >= k_) {
        goto _l10;
      }
      temp_ = conjf (a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))]);
      a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))] = conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
      a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = temp_;
      goto _l20;
      _l10:;
      if (j_ == k_) {
        goto _l20;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l20:;
    }
    _l40:;
    jpvt_[k_ - 1] = jpvt_[pl_ - 1];
    jpvt_[pl_ - 1] = k_;
    _l50:;
    pl_ = pl_ + 1;
    _l60:;
  }
  pu_ = (*p_);
  if ((*p_) < pl_) {
    goto _l150;
  }
  for (kb_ = pl_; kb_ <= (*p_); (kb_)++) {
    k_ = (*p_) - kb_ + pl_;
    if (jpvt_[k_ - 1] >= 0) {
      goto _l130;
    }
    jpvt_[k_ - 1] = -jpvt_[k_ - 1];
    if (pu_ == k_) {
      goto _l120;
    }
    (void) _cswap (($1_ = k_ - 1, &$1_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((pu_ - 1))], &_k1);
    temp_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[pu_ - 1 + ((*lda_)) * ((pu_ - 1))];
    a_[pu_ - 1 + ((*lda_)) * ((pu_ - 1))] = temp_;
    a_[k_ - 1 + ((*lda_)) * ((pu_ - 1))] = conjf (a_[k_ - 1 + ((*lda_)) * ((pu_ - 1))]);
    kp1_ = k_ + 1;
    if ((*p_) < kp1_) {
      goto _l110;
    }
    for (j_ = kp1_; j_ <= (*p_); (j_)++) {
      if (j_ >= pu_) {
        goto _l80;
      }
      temp_ = conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = conjf (a_[j_ - 1 + ((*lda_)) * ((pu_ - 1))]);
      a_[j_ - 1 + ((*lda_)) * ((pu_ - 1))] = temp_;
      goto _l90;
      _l80:;
      if (j_ == pu_) {
        goto _l90;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[pu_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pu_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l90:;
    }
    _l110:;
    jt_ = jpvt_[k_ - 1];
    jpvt_[k_ - 1] = jpvt_[pu_ - 1];
    jpvt_[pu_ - 1] = jt_;
    _l120:;
    pu_ = pu_ - 1;
    _l130:;
  }
  _l150:;
  _l160:;
  for (k_ = 1; k_ <= (*p_); (k_)++) {
    maxdia_ = (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]));
    kp1_ = k_ + 1;
    maxl_ = k_;
    if (k_ < pl_ || k_ >= pu_) {
      goto _l190;
    }
    for (l_ = kp1_; l_ <= pu_; (l_)++) {
      if ((real_4) (crealf (a_[l_ - 1 + ((*lda_)) * ((l_ - 1))])) <= maxdia_) {
        goto _l170;
      }
      maxdia_ = (real_4) (crealf (a_[l_ - 1 + ((*lda_)) * ((l_ - 1))]));
      maxl_ = l_;
      _l170:;
    }
    _l190:;
    if (maxdia_ > 0.0e0) {
      goto _l200;
    }
    (*info_) = k_ - 1;
    goto _l280;
    _l200:;
    if (k_ == maxl_) {
      goto _l210;
    }
    km1_ = k_ - 1;
    (void) _cswap (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((maxl_ - 1))], &_k1);
    a_[maxl_ - 1 + ((*lda_)) * ((maxl_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLXF (maxdia_, 0.0);
    jp_ = jpvt_[maxl_ - 1];
    jpvt_[maxl_ - 1] = jpvt_[k_ - 1];
    jpvt_[k_ - 1] = jp_;
    a_[k_ - 1 + ((*lda_)) * ((maxl_ - 1))] = conjf (a_[k_ - 1 + ((*lda_)) * ((maxl_ - 1))]);
    _l210:;
    work_[k_ - 1] = CMPLXF (sqrtf ((real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]))), 0.0);
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = work_[k_ - 1];
    if ((*p_) < kp1_) {
      goto _l260;
    }
    for (j_ = kp1_; j_ <= (*p_); (j_)++) {
      if (k_ == maxl_) {
        goto _l240;
      }
      if (j_ >= maxl_) {
        goto _l220;
      }
      temp_ = conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = conjf (a_[j_ - 1 + ((*lda_)) * ((maxl_ - 1))]);
      a_[j_ - 1 + ((*lda_)) * ((maxl_ - 1))] = temp_;
      goto _l230;
      _l220:;
      if (j_ == maxl_) {
        goto _l230;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[maxl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[maxl_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l230:;
      _l240:;
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] / work_[k_ - 1];
      work_[j_ - 1] = conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      temp_ = -a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      (void) _caxpy (($2_ = j_ - k_, &$2_), &temp_, &work_[kp1_ - 1], &_k1, &a_[kp1_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l260:;
  }
  _l280:;
  __calls[0].calls++;
  return 0;
}

int_4 _cchdd (complex_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, complex_8 _p_ x_, complex_8 _p_ z_, int_4 _p_ ldz_, int_4 
_p_ nz_, complex_8 _p_ y_, real_4 _p_ rho_, real_4 _p_ c_, complex_8 _p_ s_, int_4 _p_ info_)
{
  static int_4 i_, ii_, j_;
  static real_4 a_, alpha_, azeta_, norm_, scale_;
  static complex_8 t_, zeta_, b_, xx_;
  int_4 $0_;
  real_4 $1_, $2_, $3_;
  extern real_4 _scnrm2 ();
  extern complex_8 _cdotc ();
  (*info_) = 0;
  s_[0] = conjf (x_[0]) / conjf (r_[0 + ((*ldr_)) * ((0))]);
  if ((*p_) < 2) {
    goto _l20;
  }
  for (j_ = 2; j_ <= (*p_); (j_)++) {
    s_[j_ - 1] = conjf (x_[j_ - 1]) - _cdotc (($0_ = j_ - 1, &$0_), &r_[0 + ((*ldr_)) * ((j_ - 1))], &_k1, s_, &_k1);
    s_[j_ - 1] = s_[j_ - 1] / conjf (r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))]);
  }
  _l20:;
  norm_ = _scnrm2 (p_, s_, &_k1);
  if (norm_ < 1.0e0) {
    goto _l30;
  }
  (*info_) = -1;
  goto _l120;
  _l30:;
  alpha_ = sqrtf (1.0e0 - (norm_ * norm_));
  for (ii_ = 1; ii_ <= (*p_); (ii_)++) {
    i_ = (*p_) - ii_ + 1;
    scale_ = alpha_ + cabsf (s_[i_ - 1]);
    a_ = alpha_ / scale_;
    b_ = s_[i_ - 1] / scale_;
    norm_ = sqrtf ((a_ * a_) + ($1_ = (real_4) (crealf (b_)), $1_ * $1_) + ($2_ = cimagf (b_), $2_ * $2_));
    c_[i_ - 1] = a_ / norm_;
    s_[i_ - 1] = conjf (b_) / norm_;
    alpha_ = scale_ * norm_;
  }
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    xx_ = CMPLXF (0.0, 0.0);
    for (ii_ = 1; ii_ <= j_; (ii_)++) {
      i_ = j_ - ii_ + 1;
      t_ = c_[i_ - 1] * xx_ + s_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = c_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] - conjf (s_[i_ - 1]) * xx_;
      xx_ = t_;
    }
  }
  if ((*nz_) < 1) {
    goto _l110;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    zeta_ = y_[j_ - 1];
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = (z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] - conjf (s_[i_ - 1]) * zeta_) / c_[i_ - 1];
      zeta_ = c_[i_ - 1] * zeta_ - s_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
    }
    azeta_ = cabsf (zeta_);
    if (azeta_ <= rho_[j_ - 1]) {
      goto _l80;
    }
    (*info_) = 1;
    rho_[j_ - 1] = -1.0;
    goto _l90;
    _l80:;
    rho_[j_ - 1] = rho_[j_ - 1] * sqrtf (1.0e0 - ($3_ = (azeta_ / rho_[j_ - 1]), $3_ * $3_));
    _l90:;
  }
  _l110:;
  _l120:;
  __calls[1].calls++;
  return 0;
}

int_4 _cchex (complex_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, int_4 _p_ k_, int_4 _p_ l_, complex_8 _p_ z_, int_4 _p_ 
ldz_, int_4 _p_ nz_, real_4 _p_ c_, complex_8 _p_ s_, int_4 _p_ job_)
{
  static int_4 i_, ii_, il_, iu_, j_, jj_, km1_, kp1_, lmk_, lm1_;
  static complex_8 rjp1j_, t_;
  km1_ = (*k_) - 1;
  kp1_ = (*k_) + 1;
  lmk_ = (*l_) - (*k_);
  lm1_ = (*l_) - 1;
  switch ((*job_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l130;
  }
  _l10:;
  for (i_ = 1; i_ <= (*l_); (i_)++) {
    ii_ = (*l_) - i_ + 1;
    s_[i_ - 1] = r_[ii_ - 1 + ((*ldr_)) * (((*l_) - 1))];
  }
  for (jj_ = (*k_); jj_ <= lm1_; (jj_)++) {
    j_ = lm1_ - jj_ + (*k_);
    for (i_ = 1; i_ <= j_; (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ + 1 - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
    }
    r_[j_ + 1 - 1 + ((*ldr_)) * ((j_ + 1 - 1))] = CMPLXF (0.0, 0.0);
  }
  if ((*k_) == 1) {
    goto _l60;
  }
  for (i_ = 1; i_ <= km1_; (i_)++) {
    ii_ = (*l_) - i_ + 1;
    r_[i_ - 1 + ((*ldr_)) * (((*k_) - 1))] = s_[ii_ - 1];
  }
  _l60:;
  t_ = s_[0];
  for (i_ = 1; i_ <= lmk_; (i_)++) {
    (void) _crotg (&s_[i_ + 1 - 1], &t_, &c_[i_ - 1], &s_[i_ - 1]);
    t_ = s_[i_ + 1 - 1];
  }
  r_[(*k_) - 1 + ((*ldr_)) * (((*k_) - 1))] = t_;
  for (j_ = kp1_; j_ <= (*p_); (j_)++) {
    il_ = _max (1, (*l_) - j_ + 1);
    for (ii_ = il_; ii_ <= lmk_; (ii_)++) {
      i_ = (*l_) - ii_;
      t_ = c_[ii_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] = c_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] - conjf (s_[ii_ - 1]) * 
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
  }
  if ((*nz_) < 1) {
    goto _l120;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    for (ii_ = 1; ii_ <= lmk_; (ii_)++) {
      i_ = (*l_) - ii_;
      t_ = c_[ii_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] = c_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] - conjf (s_[ii_ - 1]) * 
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
  }
  _l120:;
  goto _l260;
  _l130:;
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    ii_ = lmk_ + i_;
    s_[ii_ - 1] = r_[i_ - 1 + ((*ldr_)) * (((*k_) - 1))];
  }
  for (j_ = (*k_); j_ <= lm1_; (j_)++) {
    for (i_ = 1; i_ <= j_; (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ + 1 - 1))];
    }
    jj_ = j_ - km1_;
    s_[jj_ - 1] = r_[j_ + 1 - 1 + ((*ldr_)) * ((j_ + 1 - 1))];
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    ii_ = lmk_ + i_;
    r_[i_ - 1 + ((*ldr_)) * (((*l_) - 1))] = s_[ii_ - 1];
  }
  for (i_ = kp1_; i_ <= (*l_); (i_)++) {
    r_[i_ - 1 + ((*ldr_)) * (((*l_) - 1))] = CMPLXF (0.0, 0.0);
  }
  for (j_ = (*k_); j_ <= (*p_); (j_)++) {
    if (j_ == (*k_)) {
      goto _l200;
    }
    iu_ = _min (j_ - 1, (*l_) - 1);
    for (i_ = (*k_); i_ <= iu_; (i_)++) {
      ii_ = i_ - (*k_) + 1;
      t_ = c_[ii_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] = c_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] - conjf (s_[ii_ - 1]) * 
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
    _l200:;
    if (j_ >= (*l_)) {
      goto _l210;
    }
    jj_ = j_ - (*k_) + 1;
    t_ = s_[jj_ - 1];
    (void) _crotg (&r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))], &t_, &c_[jj_ - 1], &s_[jj_ - 1]);
    _l210:;
  }
  if ((*nz_) < 1) {
    goto _l250;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    for (i_ = (*k_); i_ <= lm1_; (i_)++) {
      ii_ = i_ - km1_;
      t_ = c_[ii_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] = c_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] - conjf (s_[ii_ - 1]) * 
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
  }
  _l250:;
  _l260:;
  __calls[2].calls++;
  return 0;
}

int_4 _cchud (complex_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, complex_8 _p_ x_, complex_8 _p_ z_, int_4 _p_ ldz_, int_4 
_p_ nz_, complex_8 _p_ y_, real_4 _p_ rho_, real_4 _p_ c_, complex_8 _p_ s_)
{
  static int_4 i_, j_, jm1_;
  static real_4 azeta_, scale_;
  static complex_8 t_, xj_, zeta_;
  real_4 $0_, $1_;
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    xj_ = x_[j_ - 1];
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      t_ = c_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[i_ - 1] * xj_;
      xj_ = c_[i_ - 1] * xj_ - conjf (s_[i_ - 1]) * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
    _l20:;
    (void) _crotg (&r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))], &xj_, &c_[j_ - 1], &s_[j_ - 1]);
  }
  if ((*nz_) < 1) {
    goto _l70;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    zeta_ = y_[j_ - 1];
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      t_ = c_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[i_ - 1] * zeta_;
      zeta_ = c_[i_ - 1] * zeta_ - conjf (s_[i_ - 1]) * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
    azeta_ = cabsf (zeta_);
    if (azeta_ == 0.0e0 || rho_[j_ - 1] < 0.0e0) {
      goto _l50;
    }
    scale_ = azeta_ + rho_[j_ - 1];
    rho_[j_ - 1] = scale_ * sqrtf (($0_ = (azeta_ / scale_), $0_ * $0_) + ($1_ = (rho_[j_ - 1] / scale_), $1_ * $1_));
    _l50:;
  }
  _l70:;
  __calls[3].calls++;
  return 0;
}

int_4 _cgbco (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_4 
_p_ rcond_, complex_8 _p_ z_)
{
  static int_4 is_, info_, j_, ju_, k_, kb_, kp1_, l_, la_, lm_, lz_, m_, mm_;
  static real_4 anorm_, s_, sm_, ynorm_;
  static complex_8 ek_, t_, wk_, wkm_, zdum_, zdum1_, zdum2_;
  extern complex_8 _cdotc ();
  extern real_4 _scasum ();
  anorm_ = 0.0;
  l_ = (*ml_) + 1;
  is_ = l_ + (*mu_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _scasum (&l_, &abd_[is_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1));
    if (is_ > (*ml_) + 1) {
      is_ = is_ - 1;
    }
    if (j_ <= (*mu_)) {
      l_ = l_ + 1;
    }
    if (j_ >= (*n_) - (*ml_)) {
      l_ = l_ - 1;
    }
  }
  (void) _cgbfa (abd_, lda_, n_, ml_, mu_, ipvt_, &info_);
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  m_ = (*ml_) + (*mu_) + 1;
  ju_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_8 zdum1__1_ = ek_; complex_8 zdum2__1_ = -z_[k_ - 1]; ({complex_8 zdum__2_ = zdum1__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
  }
  if (({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 
  ({complex_8 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));})) {
  goto _l30;
}

s_ = ({complex_8 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l30:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_8 zdum__1_ = wk_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
sm_ = ({complex_8 zdum__1_ = wkm_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
if (({complex_8 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
goto _l40;
}

wk_ = wk_ / conjf (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]);
wkm_ = wkm_ / conjf (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]);
goto _l50;
_l40:;
wk_ = CMPLXF (1.0, 0.0);
wkm_ = CMPLXF (1.0, 0.0);
_l50:;
kp1_ = k_ + 1;
ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
mm_ = m_;
if (kp1_ > ju_) {
  goto _l90;
}

for (j_ = kp1_; j_ <= ju_; (j_)++) {
  mm_ = mm_ - 1;
  sm_ = sm_ + ({complex_8 zdum__1_ = z_[j_ - 1] + wkm_ * conjf (abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))]); _abs ((real_4) 
  (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conjf (abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_8 zdum__1_ = z_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l80;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
mm_ = m_;
for (j_ = kp1_; j_ <= ju_; (j_)++) {
  mm_ = mm_ - 1;
  z_[j_ - 1] = z_[j_ - 1] + t_ * conjf (abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))]);
}

_l80:;
_l90:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  lm_ = _min ((*ml_), (*n_) - k_);
  if (k_ < (*n_)) {
    z_[k_ - 1] = z_[k_ - 1] + _cdotc (&lm_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
  }
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 1.0e0) {
  goto _l110;
}
s_ = 1.0e0 / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
_l110:;
l_ = ipvt_[k_ - 1];
t_ = z_[l_ - 1];
z_[l_ - 1] = z_[k_ - 1];
z_[k_ - 1] = t_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  l_ = ipvt_[k_ - 1];
  t_ = z_[l_ - 1];
  z_[l_ - 1] = z_[k_ - 1];
  z_[k_ - 1] = t_;
  lm_ = _min ((*ml_), (*n_) - k_);
  if (k_ < (*n_)) {
    (void) _caxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
  }
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 1.0e0) {
  goto _l130;
}

s_ = 1.0e0 / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l130:;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
  zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
  goto _l150;
}

s_ = ({complex_8 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l150:;
if (({complex_8 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_8 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}
lm_ = _min (k_, m_) - 1;
la_ = m_ - lm_;
lz_ = k_ - lm_;
t_ = -z_[k_ - 1];
(void) _caxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lz_ - 1], &_k1);
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[4].calls++;
return 0;
}

int_4 _cgbdi (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
complex_8 _p_ det_)
{
  static int_4 i_, m_;
  static real_4 ten_;
  static complex_8 zdum_;
  m_ = (*ml_) + (*mu_) + 1;
  det_[0] = CMPLXF (1.0, 0.0);
  det_[1] = CMPLXF (0.0, 0.0);
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = abd_[m_ - 1 + ((*lda_)) * ((i_ - 1))] * det_[0];
    if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
    goto _l60;
  }
  _l10:;
  if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) >= 1.0e0) {
  goto _l20;
}

det_[0] = CMPLXF (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLXF (1.0, 0.0);
goto _l10;
_l20:;
_l30:;
if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < ten_) {
goto _l40;
}

det_[0] = det_[0] / CMPLXF (ten_, 0.0);
det_[1] = det_[1] + CMPLXF (1.0, 0.0);
goto _l30;
_l40:;
}

_l60:;
__calls[5].calls++;
return 0;
}

int_4 _cgbfa (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, int_4 
_p_ info_)
{
  static int_4 i_, i0_, j_, ju_, jz_, j0_, j1_, k_, kp1_, l_, lm_, m_, mm_, nm1_;
  static complex_8 t_, zdum_;
  int_4 $0_;
  extern int_4 _icamax ();
  m_ = (*ml_) + (*mu_) + 1;
  (*info_) = 0;
  j0_ = (*mu_) + 2;
  j1_ = _min ((*n_), m_) - 1;
  if (j1_ < j0_) {
    goto _l30;
  }
  for (jz_ = j0_; jz_ <= j1_; (jz_)++) {
    i0_ = m_ + 1 - jz_;
    for (i_ = i0_; i_ <= (*ml_); (i_)++) {
      abd_[i_ - 1 + ((*lda_)) * ((jz_ - 1))] = CMPLXF (0.0, 0.0);
    }
  }
  _l30:;
  jz_ = j1_;
  ju_ = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l130;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    jz_ = jz_ + 1;
    if (jz_ > (*n_)) {
      goto _l50;
    }
    if ((*ml_) < 1) {
      goto _l50;
    }
    for (i_ = 1; i_ <= (*ml_); (i_)++) {
      abd_[i_ - 1 + ((*lda_)) * ((jz_ - 1))] = CMPLXF (0.0, 0.0);
    }
    _l50:;
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = _icamax (($0_ = lm_ + 1, &$0_), &abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + m_ - 1;
    ipvt_[k_ - 1] = l_ + k_ - m_;
    if (({complex_8 zdum__1_ = abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
    (zdum__1_));}) == 0.0e0) {
    goto _l100;
  }
  if (l_ == m_) {
    goto _l60;
  }
  t_ = abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
  abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
  abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
  _l60:;
  t_ = -CMPLXF (1.0, 0.0) / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
  (void) _cscal (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1);
  ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
  mm_ = m_;
  if (ju_ < kp1_) {
    goto _l90;
  }
  for (j_ = kp1_; j_ <= ju_; (j_)++) {
    l_ = l_ - 1;
    mm_ = mm_ - 1;
    t_ = abd_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
    if (l_ == mm_) {
      goto _l70;
    }
    abd_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))];
    abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
    _l70:;
    (void) _caxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &abd_[mm_ + 1 - 1 + ((*lda_)) * ((j_ - 
    1))], &_k1);
  }
  _l90:;
  goto _l110;
  _l100:;
  (*info_) = k_;
  _l110:;
}

_l130:;
ipvt_[(*n_) - 1] = (*n_);
if (({complex_8 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * (((*n_) - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
(*info_) = (*n_);
}

__calls[6].calls++;
return 0;
}

int_4 _cgbsl (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
complex_8 _p_ b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, la_, lb_, lm_, m_, nm1_;
  static complex_8 t_;
  extern complex_8 _cdotc ();
  m_ = (*mu_) + (*ml_) + 1;
  nm1_ = (*n_) - 1;
  if ((*job_) != 0) {
    goto _l50;
  }
  if ((*ml_) == 0) {
    goto _l30;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    (void) _caxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lb_ = k_ - lm_;
    t_ = -b_[k_ - 1];
    (void) _caxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lb_ = k_ - lm_;
    t_ = _cdotc (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / conjf (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]);
  }
  if ((*ml_) == 0) {
    goto _l90;
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    lm_ = _min ((*ml_), (*n_) - k_);
    b_[k_ - 1] = b_[k_ - 1] + _cdotc (&lm_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[7].calls++;
  return 0;
}

int_4 _cgeco (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_4 _p_ rcond_, complex_8 _p_ z_)
{
  static int_4 info_, j_, k_, kb_, kp1_, l_;
  static real_4 anorm_, s_, sm_, ynorm_;
  static complex_8 ek_, t_, wk_, wkm_, zdum_, zdum1_, zdum2_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotc ();
  extern real_4 _scasum ();
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _scasum (n_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1));
  }
  (void) _cgefa (a_, lda_, n_, ipvt_, &info_);
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_8 zdum1__1_ = ek_; complex_8 zdum2__1_ = -z_[k_ - 1]; ({complex_8 zdum__2_ = zdum1__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
  }
  if (({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 
  ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));})) {
  goto _l30;
}

s_ = ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l30:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_8 zdum__1_ = wk_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
sm_ = ({complex_8 zdum__1_ = wkm_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
goto _l40;
}

wk_ = wk_ / conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
wkm_ = wkm_ / conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
goto _l50;
_l40:;
wk_ = CMPLXF (1.0, 0.0);
wkm_ = CMPLXF (1.0, 0.0);
_l50:;
kp1_ = k_ + 1;
if (kp1_ > (*n_)) {
  goto _l90;
}

for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  sm_ = sm_ + ({complex_8 zdum__1_ = z_[j_ - 1] + wkm_ * conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]); _abs ((real_4) 
  (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_8 zdum__1_ = z_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l80;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  z_[j_ - 1] = z_[j_ - 1] + t_ * conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
}

_l80:;
_l90:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (k_ < (*n_)) {
    z_[k_ - 1] = z_[k_ - 1] + _cdotc (($0_ = (*n_) - k_, &$0_), &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 
    - 1], &_k1);
  }
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 1.0e0) {
  goto _l110;
}

s_ = 1.0e0 / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
_l110:;
l_ = ipvt_[k_ - 1];
t_ = z_[l_ - 1];
z_[l_ - 1] = z_[k_ - 1];
z_[k_ - 1] = t_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  l_ = ipvt_[k_ - 1];
  t_ = z_[l_ - 1];
  z_[l_ - 1] = z_[k_ - 1];
  z_[k_ - 1] = t_;
  if (k_ < (*n_)) {
    (void) _caxpy (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
  }
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 1.0e0) {
  goto _l130;
}

s_ = 1.0e0 / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l130:;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
  zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
  goto _l150;
}

s_ = ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l150:;
if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

t_ = -z_[k_ - 1];
(void) _caxpy (($2_ = k_ - 1, &$2_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[8].calls++;
return 0;
}

int_4 _cgedi (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, complex_8 _p_ det_, complex_8 _p_ work_, 
int_4 _p_ job_)
{
  static int_4 i_, j_, k_, kb_, kp1_, l_, nm1_;
  static real_4 ten_;
  static complex_8 t_, zdum_;
  int_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = CMPLXF (1.0, 0.0);
  det_[1] = CMPLXF (0.0, 0.0);
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] * det_[0];
    if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
    goto _l60;
  }
  _l10:;
  if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) >= 1.0e0) {
  goto _l20;
}

det_[0] = CMPLXF (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLXF (1.0, 0.0);
goto _l10;
_l20:;
_l30:;
if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < ten_) {
goto _l40;
}

det_[0] = det_[0] / CMPLXF (ten_, 0.0);
det_[1] = det_[1] + CMPLXF (1.0, 0.0);
goto _l30;
_l40:;
}

_l60:;
_l70:;
if (_imod ((*job_), 10) == 0) {
  goto _l150;
}

for (k_ = 1; k_ <= (*n_); (k_)++) {
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLXF (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  t_ = -a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  (void) _cscal (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  kp1_ = k_ + 1;
  if ((*n_) < kp1_) {
    goto _l90;
  }
  for (j_ = kp1_; j_ <= (*n_); (j_)++) {
    t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
    (void) _caxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  }
  _l90:;
}

nm1_ = (*n_) - 1;
if (nm1_ < 1) {
  goto _l140;
}

for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
  k_ = (*n_) - kb_;
  kp1_ = k_ + 1;
  for (i_ = kp1_; i_ <= (*n_); (i_)++) {
    work_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[i_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLXF (0.0, 0.0);
  }
  for (j_ = kp1_; j_ <= (*n_); (j_)++) {
    t_ = work_[j_ - 1];
    (void) _caxpy (n_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  }
  l_ = ipvt_[k_ - 1];
  if (l_ != k_) {
    (void) _cswap (n_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((l_ - 1))], &_k1);
  }
}

_l140:;
_l150:;
__calls[9].calls++;
return 0;
}

int_4 _cgefa (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_)
{
  static int_4 j_, k_, kp1_, l_, nm1_;
  static complex_8 t_, zdum_;
  int_4 $0_, $1_, $2_;
  extern int_4 _icamax ();
  (*info_) = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l70;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    l_ = _icamax (($0_ = (*n_) - k_ + 1, &$0_), &a_[k_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + k_ - 1;
    ipvt_[k_ - 1] = l_;
    if (({complex_8 zdum__1_ = a_[l_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
    (zdum__1_));}) == 0.0e0) {
    goto _l40;
  }
  if (l_ == k_) {
    goto _l10;
  }
  t_ = a_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
  _l10:;
  t_ = -CMPLXF (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  (void) _cscal (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1);
  for (j_ = kp1_; j_ <= (*n_); (j_)++) {
    t_ = a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
    if (l_ == k_) {
      goto _l20;
    }
    a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
    _l20:;
    (void) _caxpy (($2_ = (*n_) - k_, &$2_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[k_ + 1 - 1 + 
    ((*lda_)) * ((j_ - 1))], &_k1);
  }
  goto _l50;
  _l40:;
  (*info_) = k_;
  _l50:;
}

_l70:;
ipvt_[(*n_) - 1] = (*n_);
if (({complex_8 zdum__1_ = a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));}) == 0.0e0) {
(*info_) = (*n_);
}
__calls[10].calls++;
return 0;
}

int_4 _cgesl (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, complex_8 _p_ b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, nm1_;
  static complex_8 t_;
  int_4 $0_, $1_, $2_, $3_;
  extern complex_8 _cdotc ();
  nm1_ = (*n_) - 1;
  if ((*job_) != 0) {
    goto _l50;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    (void) _caxpy (($0_ = (*n_) - k_, &$0_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _caxpy (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _cdotc (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / conjf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    b_[k_ - 1] = b_[k_ - 1] + _cdotc (($3_ = (*n_) - k_, &$3_), &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 
    - 1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[11].calls++;
  return 0;
}

int_4 _cgtsl (int_4 _p_ n_, complex_8 _p_ c_, complex_8 _p_ d_, complex_8 _p_ e_, complex_8 _p_ b_, int_4 _p_ info_)
{
  static int_4 k_, kb_, kp1_, nm1_, nm2_;
  static complex_8 t_, zdum_;
  (*info_) = 0;
  c_[0] = d_[0];
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l40;
  }
  d_[0] = e_[0];
  e_[0] = CMPLXF (0.0, 0.0);
  e_[(*n_) - 1] = CMPLXF (0.0, 0.0);
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    if (({complex_8 zdum__1_ = c_[kp1_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < 
    ({complex_8 zdum__1_ = c_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
    goto _l10;
  }
  t_ = c_[kp1_ - 1];
  c_[kp1_ - 1] = c_[k_ - 1];
  c_[k_ - 1] = t_;
  t_ = d_[kp1_ - 1];
  d_[kp1_ - 1] = d_[k_ - 1];
  d_[k_ - 1] = t_;
  t_ = e_[kp1_ - 1];
  e_[kp1_ - 1] = e_[k_ - 1];
  e_[k_ - 1] = t_;
  t_ = b_[kp1_ - 1];
  b_[kp1_ - 1] = b_[k_ - 1];
  b_[k_ - 1] = t_;
  _l10:;
  if (({complex_8 zdum__1_ = c_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
  goto _l20;
}

(*info_) = k_;
goto _l100;
_l20:;
t_ = -c_[kp1_ - 1] / c_[k_ - 1];
c_[kp1_ - 1] = d_[kp1_ - 1] + t_ * d_[k_ - 1];
d_[kp1_ - 1] = e_[kp1_ - 1] + t_ * e_[k_ - 1];
e_[kp1_ - 1] = CMPLXF (0.0, 0.0);
b_[kp1_ - 1] = b_[kp1_ - 1] + t_ * b_[k_ - 1];
}

_l40:;
if (({complex_8 zdum__1_ = c_[(*n_) - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) 
{
goto _l50;
}

(*info_) = (*n_);
goto _l90;
_l50:;
nm2_ = (*n_) - 2;
b_[(*n_) - 1] = b_[(*n_) - 1] / c_[(*n_) - 1];
if ((*n_) == 1) {
  goto _l80;
}

b_[nm1_ - 1] = (b_[nm1_ - 1] - d_[nm1_ - 1] * b_[(*n_) - 1]) / c_[nm1_ - 1];
if (nm2_ < 1) {
  goto _l70;
}

for (kb_ = 1; kb_ <= nm2_; (kb_)++) {
  k_ = nm2_ - kb_ + 1;
  b_[k_ - 1] = (b_[k_ - 1] - d_[k_ - 1] * b_[k_ + 1 - 1] - e_[k_ - 1] * b_[k_ + 2 - 1]) / c_[k_ - 1];
}

_l70:;
_l80:;
_l90:;
_l100:;
__calls[12].calls++;
return 0;
}

int_4 _chico (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, complex_8 _p_ z_)
{
  static int_4 i_, info_, j_, jm1_, k_, kp_, kps_, ks_;
  static real_4 anorm_, s_, ynorm_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, zdum_, zdum2_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_8 _cdotc ();
  extern real_4 _scasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (_scasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1), 0.0);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLXF ((real_4) (crealf (z_[i_ - 1])) + ({complex_8 zdum__1_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs 
      ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}), 0.0);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, (real_4) (crealf (z_[j_ - 1])));
  }
  (void) _chifa (a_, lda_, n_, kpvt_, &info_);
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  k_ = (*n_);
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
  ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = z_[k_ - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
  (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
  (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
}

z_[k_ - 1] = z_[k_ - 1] + ek_;
(void) _caxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 1) {
  goto _l80;
}

if (({complex_8 zdum__1_ = z_[k_ - 1 - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) 
{
ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = z_[k_ - 1 - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
(crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
(crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
}

z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
(void) _caxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
_l80:;
if (ks_ == 2) {
  goto _l100;
}

if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
goto _l90;
}

s_ = ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l90:;
if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

goto _l110;
_l100:;
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / conjf (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bk_ = z_[k_ - 1] / conjf (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l110:;
k_ = k_ - ks_;
goto _l60;
_l120:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
k_ = 1;
_l130:;
if (k_ > (*n_)) {
  goto _l160;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l150;
}

z_[k_ - 1] = z_[k_ - 1] + _cdotc (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _cdotc (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], 
  &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l140;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l140:;
_l150:;
k_ = k_ + ks_;
goto _l130;
_l160:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
k_ = (*n_);
_l170:;
if (k_ == 0) {
  goto _l230;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == ks_) {
  goto _l190;
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
kps_ = k_ + 1 - ks_;
if (kp_ == kps_) {
  goto _l180;
}
t_ = z_[kps_ - 1];
z_[kps_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l180:;
(void) _caxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  (void) _caxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
}

_l190:;
if (ks_ == 2) {
  goto _l210;
}

if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
goto _l200;
}

s_ = ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l200:;
if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

goto _l220;
_l210:;
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / conjf (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bk_ = z_[k_ - 1] / conjf (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l220:;
k_ = k_ - ks_;
goto _l170;
_l230:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
k_ = 1;
_l240:;
if (k_ > (*n_)) {
  goto _l270;
}
ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l260;
}

z_[k_ - 1] = z_[k_ - 1] + _cdotc (($6_ = k_ - 1, &$6_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _cdotc (($7_ = k_ - 1, &$7_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], 
  &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l250;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l250:;
_l260:;
k_ = k_ + ks_;
goto _l240;
_l270:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[13].calls++;
return 0;
}

int_4 _chidi (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ det_, int_4 _p_ inert_, 
complex_8 _p_ work_, int_4 _p_ job_)
{
  static int_4 j_, jb_, k_, km1_, ks_, kstep_;
  static logical_4 noinv_, nodet_, noert_;
  static real_4 ten_, d_, t_, ak_, akp1_;
  static complex_8 akkp1_, temp_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotc ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  noert_ = _imod ((*job_), 1000) / 100 == 0;
  if (nodet_ && noert_) {
    goto _l140;
  }
  if (noert_) {
    goto _l10;
  }
  inert_[0] = 0;
  inert_[1] = 0;
  inert_[2] = 0;
  _l10:;
  if (nodet_) {
    goto _l20;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  _l20:;
  t_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    d_ = (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]));
    if (kpvt_[k_ - 1] > 0) {
      goto _l50;
    }
    if (t_ != 0.0e0) {
      goto _l30;
    }
    t_ = cabsf (a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))]);
    d_ = (d_ / t_) * (real_4) (crealf (a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))])) - t_;
    goto _l40;
    _l30:;
    d_ = t_;
    t_ = 0.0;
    _l40:;
    _l50:;
    if (noert_) {
      goto _l60;
    }
    if (d_ > 0.0e0) {
      inert_[0] = inert_[0] + 1;
    }
    if (d_ < 0.0e0) {
      inert_[1] = inert_[1] + 1;
    }
    if (d_ == 0.0e0) {
      inert_[2] = inert_[2] + 1;
    }
    _l60:;
    if (nodet_) {
      goto _l120;
    }
    det_[0] = d_ * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l110;
    }
    _l70:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l80;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l70;
    _l80:;
    _l90:;
    if (_abs (det_[0]) < ten_) {
      goto _l100;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l90;
    _l100:;
    _l110:;
    _l120:;
  }
  _l140:;
  if (noinv_) {
    goto _l270;
  }
  k_ = 1;
  _l150:;
  if (k_ > (*n_)) {
    goto _l260;
  }
  km1_ = k_ - 1;
  if (kpvt_[k_ - 1] < 0) {
    goto _l180;
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLXF (1.0e0 / (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])), 0.0);
  if (km1_ < 1) {
    goto _l170;
  }
  (void) _ccopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _cdotc (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _caxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
    1))], &_k1);
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + CMPLXF ((real_4) (crealf (_cdotc (&km1_, 
  work_, &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1))), 0.0);
  _l170:;
  kstep_ = 1;
  goto _l220;
  _l180:;
  t_ = cabsf (a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))]);
  ak_ = (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) / t_;
  akp1_ = (real_4) (crealf (a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))])) / t_;
  akkp1_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
  d_ = t_ * (ak_ * akp1_ - 1.0e0);
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLXF (akp1_ / d_, 0.0);
  a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = CMPLXF (ak_ / d_, 0.0);
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = -akkp1_ / d_;
  if (km1_ < 1) {
    goto _l210;
  }
  (void) _ccopy (&km1_, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = _cdotc (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _caxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 
    1 - 1))], &_k1);
  }
  a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] + CMPLXF ((real_4) (crealf 
  (_cdotc (&km1_, work_, &_k1, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1))), 0.0);
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _cdotc (&km1_, &a_[0 + ((*lda_)) * 
  ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
  (void) _ccopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _cdotc (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _caxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
    1))], &_k1);
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + CMPLXF ((real_4) (crealf (_cdotc (&km1_, 
  work_, &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1))), 0.0);
  _l210:;
  kstep_ = 2;
  _l220:;
  ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (ks_ == k_) {
    goto _l250;
  }
  (void) _cswap (&ks_, &a_[0 + ((*lda_)) * ((ks_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  for (jb_ = ks_; jb_ <= k_; (jb_)++) {
    j_ = k_ + ks_ - jb_;
    temp_ = conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = conjf (a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))]);
    a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
  }
  if (kstep_ == 1) {
    goto _l240;
  }
  temp_ = a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = temp_;
  _l240:;
  _l250:;
  k_ = k_ + kstep_;
  goto _l150;
  _l260:;
  _l270:;
  __calls[14].calls++;
  return 0;
}

int_4 _chifa (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 imax_, imaxp1_, j_, jj_, jmax_, k_, km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_4 absakk_, alpha_, colmax_, rowmax_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, zdum_;
  int_4 $0_, $1_;
  extern int_4 _icamax ();
  alpha_ = 0.6403882;
  (*info_) = 0;
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (({complex_8 zdum__1_ = a_[0 + ((*lda_)) * ((0))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) 
  == 0.0e0) {
  (*info_) = 1;
}

goto _l200;
_l20:;
km1_ = k_ - 1;
absakk_ = ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));});
imax_ = _icamax (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
colmax_ = ({complex_8 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));});
if (absakk_ < alpha_ * colmax_) {
  goto _l30;
}

kstep_ = 1;
swap_ = FALSE;
goto _l90;
_l30:;
rowmax_ = 0.0;
imaxp1_ = imax_ + 1;
for (j_ = imaxp1_; j_ <= k_; (j_)++) {
  rowmax_ = _max (rowmax_, ({complex_8 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs ((real_4) (crealf 
  (zdum__1_))) + _abs (cimagf (zdum__1_));}));
}

if (imax_ == 1) {
  goto _l50;
}

jmax_ = _icamax (($1_ = imax_ - 1, &$1_), &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1);
rowmax_ = _max (rowmax_, ({complex_8 zdum__1_ = a_[jmax_ - 1 + ((*lda_)) * ((imax_ - 1))]; _abs ((real_4) (crealf 
(zdum__1_))) + _abs (cimagf (zdum__1_));}));
_l50:;
if (({complex_8 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((imax_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));}) < alpha_ * rowmax_) {
goto _l60;
}

kstep_ = 1;
swap_ = TRUE;
goto _l80;
_l60:;
if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
  goto _l70;
}

kstep_ = 1;
swap_ = FALSE;
goto _l80;
_l70:;
kstep_ = 2;
swap_ = imax_ != km1_;
_l80:;
_l90:;
if (_max (absakk_, colmax_) != 0.0e0) {
  goto _l100;
}

kpvt_[k_ - 1] = k_;
(*info_) = k_;
goto _l190;
_l100:;
if (kstep_ == 2) {
  goto _l140;
}

if (! (swap_)) {
  goto _l120;
}

(void) _cswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
for (jj_ = imax_; jj_ <= k_; (jj_)++) {
  j_ = k_ + imax_ - jj_;
  t_ = conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = conjf (a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]);
  a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
}

_l120:;
for (jj_ = 1; jj_ <= km1_; (jj_)++) {
  j_ = k_ - jj_;
  mulk_ = -a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  t_ = conjf (mulk_);
  (void) _caxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLXF ((real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])), 0.0);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
}

kpvt_[k_ - 1] = k_;
if (swap_) {
  kpvt_[k_ - 1] = imax_;
}

goto _l190;
_l140:;
if (! (swap_)) {
  goto _l160;
}

(void) _cswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1);
for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
  j_ = km1_ + imax_ - jj_;
  t_ = conjf (a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))]);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = conjf (a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]);
  a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
}

t_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))];
a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
_l160:;
km2_ = k_ - 2;
if (km2_ == 0) {
  goto _l180;
}

ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / conjf (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
denom_ = 1.0e0 - ak_ * akm1_;
for (jj_ = 1; jj_ <= km2_; (jj_)++) {
  j_ = km1_ - jj_;
  bk_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] / conjf (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
  mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
  mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
  t_ = conjf (mulk_);
  (void) _caxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  t_ = conjf (mulkm1_);
  (void) _caxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = mulkm1_;
  a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLXF ((real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])), 0.0);
}

_l180:;
kpvt_[k_ - 1] = 1 - k_;
if (swap_) {
  kpvt_[k_ - 1] = -imax_;
}

kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
_l190:;
k_ = k_ - kstep_;
goto _l10;
_l200:;
__calls[15].calls++;
return 0;
}

int_4 _chisl (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ b_)
{
  static int_4 k_, kp_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern complex_8 _cdotc ();
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _caxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  k_ = k_ - 1;
  goto _l70;
  _l40:;
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _caxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  (void) _caxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &b_[0], &_k1);
  _l60:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / conjf (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = b_[k_ - 1] / conjf (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
  bkm1_ = b_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _cdotc (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _cdotc (($4_ = k_ - 1, &$4_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _cdotc (($5_ = k_ - 1, &$5_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &b_[0], 
  &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[16].calls++;
  return 0;
}

int_4 _chpco (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, complex_8 _p_ z_)
{
  static int_4 i_, ij_, ik_, ikm1_, ikp1_, info_, j_, jm1_, j1_, k_, kk_, km1k_, km1km1_, kp_, kps_, ks_;
  static real_4 anorm_, s_, ynorm_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, zdum_, zdum2_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_8 _cdotc ();
  extern real_4 _scasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (_scasum (&j_, &ap_[j1_ - 1], &_k1), 0.0);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLXF ((real_4) (crealf (z_[i_ - 1])) + ({complex_8 zdum__1_ = ap_[ij_ - 1]; _abs ((real_4) (crealf 
      (zdum__1_))) + _abs (cimagf (zdum__1_));}), 0.0);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, (real_4) (crealf (z_[j_ - 1])));
  }
  (void) _chpfa (ap_, n_, kpvt_, &info_);
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  kk_ = ik_ + k_;
  ikm1_ = ik_ - (k_ - 1);
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
  ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = z_[k_ - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
  (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
  (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
}

z_[k_ - 1] = z_[k_ - 1] + ek_;
(void) _caxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
if (ks_ == 1) {
  goto _l80;
}

if (({complex_8 zdum__1_ = z_[k_ - 1 - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) 
{
ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = z_[k_ - 1 - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
(crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
(crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
}

z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
(void) _caxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
_l80:;
if (ks_ == 2) {
  goto _l100;
}

if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
goto _l90;
}

s_ = ({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) / 
({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l90:;
if (({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

if (({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

goto _l110;
_l100:;
km1k_ = ik_ + k_ - 1;
km1km1_ = ikm1_ + k_ - 1;
ak_ = ap_[kk_ - 1] / conjf (ap_[km1k_ - 1]);
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
bk_ = z_[k_ - 1] / conjf (ap_[km1k_ - 1]);
bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l110:;
k_ = k_ - ks_;
ik_ = ik_ - k_;
if (ks_ == 2) {
  ik_ = ik_ - (k_ + 1);
}

goto _l60;
_l120:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
k_ = 1;
ik_ = 0;
_l130:;
if (k_ > (*n_)) {
  goto _l160;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l150;
}

z_[k_ - 1] = z_[k_ - 1] + _cdotc (($2_ = k_ - 1, &$2_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
ikp1_ = ik_ + k_;
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _cdotc (($3_ = k_ - 1, &$3_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l140;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l140:;
_l150:;
ik_ = ik_ + k_;
if (ks_ == 2) {
  ik_ = ik_ + (k_ + 1);
}

k_ = k_ + ks_;
goto _l130;
_l160:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
k_ = (*n_);
ik_ = (*n_) * ((*n_) - 1) / 2;
_l170:;
if (k_ == 0) {
  goto _l230;
}

kk_ = ik_ + k_;
ikm1_ = ik_ - (k_ - 1);
ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == ks_) {
  goto _l190;
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
kps_ = k_ + 1 - ks_;
if (kp_ == kps_) {
  goto _l180;
}

t_ = z_[kps_ - 1];
z_[kps_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l180:;
(void) _caxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  (void) _caxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

_l190:;
if (ks_ == 2) {
  goto _l210;
}

if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
goto _l200;
}

s_ = ({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) / 
({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l200:;
if (({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

if (({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

goto _l220;
_l210:;
km1k_ = ik_ + k_ - 1;
km1km1_ = ikm1_ + k_ - 1;
ak_ = ap_[kk_ - 1] / conjf (ap_[km1k_ - 1]);
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
bk_ = z_[k_ - 1] / conjf (ap_[km1k_ - 1]);
bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l220:;
k_ = k_ - ks_;
ik_ = ik_ - k_;
if (ks_ == 2) {
  ik_ = ik_ - (k_ + 1);
}

goto _l170;
_l230:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
k_ = 1;
ik_ = 0;
_l240:;
if (k_ > (*n_)) {
  goto _l270;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l260;
}

z_[k_ - 1] = z_[k_ - 1] + _cdotc (($6_ = k_ - 1, &$6_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
ikp1_ = ik_ + k_;
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _cdotc (($7_ = k_ - 1, &$7_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l250;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l250:;
_l260:;
ik_ = ik_ + k_;
if (ks_ == 2) {
  ik_ = ik_ + (k_ + 1);
}

k_ = k_ + ks_;
goto _l240;
_l270:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[17].calls++;
return 0;
}

int_4 _chpdi (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ det_, int_4 _p_ inert_, complex_8 _p_ work_, 
int_4 _p_ job_)
{
  static int_4 ij_, ik_, ikp1_, iks_, j_, jb_, jk_, jkp1_, k_, kk_, kkp1_, km1_, ks_, ksj_, kskp1_, kstep_;
  static logical_4 noinv_, nodet_, noert_;
  static real_4 ten_, d_, t_, ak_, akp1_;
  static complex_8 akkp1_, temp_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotc ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  noert_ = _imod ((*job_), 1000) / 100 == 0;
  if (nodet_ && noert_) {
    goto _l140;
  }
  if (noert_) {
    goto _l10;
  }
  inert_[0] = 0;
  inert_[1] = 0;
  inert_[2] = 0;
  _l10:;
  if (nodet_) {
    goto _l20;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  _l20:;
  t_ = 0.0;
  ik_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = ik_ + k_;
    d_ = (real_4) (crealf (ap_[kk_ - 1]));
    if (kpvt_[k_ - 1] > 0) {
      goto _l50;
    }
    if (t_ != 0.0e0) {
      goto _l30;
    }
    ikp1_ = ik_ + k_;
    kkp1_ = ikp1_ + k_;
    t_ = cabsf (ap_[kkp1_ - 1]);
    d_ = (d_ / t_) * (real_4) (crealf (ap_[kkp1_ + 1 - 1])) - t_;
    goto _l40;
    _l30:;
    d_ = t_;
    t_ = 0.0;
    _l40:;
    _l50:;
    if (noert_) {
      goto _l60;
    }
    if (d_ > 0.0e0) {
      inert_[0] = inert_[0] + 1;
    }
    if (d_ < 0.0e0) {
      inert_[1] = inert_[1] + 1;
    }
    if (d_ == 0.0e0) {
      inert_[2] = inert_[2] + 1;
    }
    _l60:;
    if (nodet_) {
      goto _l120;
    }
    det_[0] = d_ * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l110;
    }
    _l70:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l80;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l70;
    _l80:;
    _l90:;
    if (_abs (det_[0]) < ten_) {
      goto _l100;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l90;
    _l100:;
    _l110:;
    _l120:;
    ik_ = ik_ + k_;
  }
  _l140:;
  if (noinv_) {
    goto _l270;
  }
  k_ = 1;
  ik_ = 0;
  _l150:;
  if (k_ > (*n_)) {
    goto _l260;
  }
  km1_ = k_ - 1;
  kk_ = ik_ + k_;
  ikp1_ = ik_ + k_;
  kkp1_ = ikp1_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l180;
  }
  ap_[kk_ - 1] = CMPLXF (1.0e0 / (real_4) (crealf (ap_[kk_ - 1])), 0.0);
  if (km1_ < 1) {
    goto _l170;
  }
  (void) _ccopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jk_ = ik_ + j_;
    ap_[jk_ - 1] = _cdotc (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _caxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kk_ - 1] = ap_[kk_ - 1] + CMPLXF ((real_4) (crealf (_cdotc (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1))), 0.0);
  _l170:;
  kstep_ = 1;
  goto _l220;
  _l180:;
  t_ = cabsf (ap_[kkp1_ - 1]);
  ak_ = (real_4) (crealf (ap_[kk_ - 1])) / t_;
  akp1_ = (real_4) (crealf (ap_[kkp1_ + 1 - 1])) / t_;
  akkp1_ = ap_[kkp1_ - 1] / t_;
  d_ = t_ * (ak_ * akp1_ - 1.0e0);
  ap_[kk_ - 1] = CMPLXF (akp1_ / d_, 0.0);
  ap_[kkp1_ + 1 - 1] = CMPLXF (ak_ / d_, 0.0);
  ap_[kkp1_ - 1] = -akkp1_ / d_;
  if (km1_ < 1) {
    goto _l210;
  }
  (void) _ccopy (&km1_, &ap_[ikp1_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jkp1_ = ikp1_ + j_;
    ap_[jkp1_ - 1] = _cdotc (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _caxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kkp1_ + 1 - 1] = ap_[kkp1_ + 1 - 1] + CMPLXF ((real_4) (crealf (_cdotc (&km1_, work_, &_k1, &ap_[ikp1_ + 1 - 1], 
  &_k1))), 0.0);
  ap_[kkp1_ - 1] = ap_[kkp1_ - 1] + _cdotc (&km1_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
  (void) _ccopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jk_ = ik_ + j_;
    ap_[jk_ - 1] = _cdotc (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _caxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kk_ - 1] = ap_[kk_ - 1] + CMPLXF ((real_4) (crealf (_cdotc (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1))), 0.0);
  _l210:;
  kstep_ = 2;
  _l220:;
  ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (ks_ == k_) {
    goto _l250;
  }
  iks_ = (ks_ * (ks_ - 1)) / 2;
  (void) _cswap (&ks_, &ap_[iks_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  ksj_ = ik_ + ks_;
  for (jb_ = ks_; jb_ <= k_; (jb_)++) {
    j_ = k_ + ks_ - jb_;
    jk_ = ik_ + j_;
    temp_ = conjf (ap_[jk_ - 1]);
    ap_[jk_ - 1] = conjf (ap_[ksj_ - 1]);
    ap_[ksj_ - 1] = temp_;
    ksj_ = ksj_ - (j_ - 1);
  }
  if (kstep_ == 1) {
    goto _l240;
  }
  kskp1_ = ikp1_ + ks_;
  temp_ = ap_[kskp1_ - 1];
  ap_[kskp1_ - 1] = ap_[kkp1_ - 1];
  ap_[kkp1_ - 1] = temp_;
  _l240:;
  _l250:;
  ik_ = ik_ + k_;
  if (kstep_ == 2) {
    ik_ = ik_ + k_ + 1;
  }
  k_ = k_ + kstep_;
  goto _l150;
  _l260:;
  _l270:;
  __calls[18].calls++;
  return 0;
}

int_4 _chpfa (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 ij_, ijj_, ik_, ikm1_, im_, imax_, imaxp1_, imim_, imj_, imk_, j_, jj_, jk_, jkm1_, jmax_, jmim_, k_, kk_, 
  km1_, km1k_, km1km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_4 absakk_, alpha_, colmax_, rowmax_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, zdum_;
  int_4 $0_, $1_;
  extern int_4 _icamax ();
  alpha_ = 0.6403882;
  (*info_) = 0;
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (({complex_8 zdum__1_ = ap_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
  (*info_) = 1;
}

goto _l200;
_l20:;
km1_ = k_ - 1;
kk_ = ik_ + k_;
absakk_ = ({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
imax_ = _icamax (($0_ = k_ - 1, &$0_), &ap_[ik_ + 1 - 1], &_k1);
imk_ = ik_ + imax_;
colmax_ = ({complex_8 zdum__1_ = ap_[imk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
if (absakk_ < alpha_ * colmax_) {
  goto _l30;
}

kstep_ = 1;
swap_ = FALSE;
goto _l90;
_l30:;
rowmax_ = 0.0;
imaxp1_ = imax_ + 1;
im_ = imax_ * (imax_ - 1) / 2;
imj_ = im_ + 2 * imax_;
for (j_ = imaxp1_; j_ <= k_; (j_)++) {
  rowmax_ = _max (rowmax_, ({complex_8 zdum__1_ = ap_[imj_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));}));
  imj_ = imj_ + j_;
}

if (imax_ == 1) {
  goto _l50;
}

jmax_ = _icamax (($1_ = imax_ - 1, &$1_), &ap_[im_ + 1 - 1], &_k1);
jmim_ = jmax_ + im_;
rowmax_ = _max (rowmax_, ({complex_8 zdum__1_ = ap_[jmim_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}));
_l50:;
imim_ = imax_ + im_;
if (({complex_8 zdum__1_ = ap_[imim_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < alpha_ * 
rowmax_) {
goto _l60;
}

kstep_ = 1;
swap_ = TRUE;
goto _l80;
_l60:;
if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
  goto _l70;
}

kstep_ = 1;
swap_ = FALSE;
goto _l80;
_l70:;
kstep_ = 2;
swap_ = imax_ != km1_;
_l80:;
_l90:;
if (_max (absakk_, colmax_) != 0.0e0) {
  goto _l100;
}

kpvt_[k_ - 1] = k_;
(*info_) = k_;
goto _l190;
_l100:;
if (kstep_ == 2) {
  goto _l140;
}

if (! (swap_)) {
  goto _l120;
}

(void) _cswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
imj_ = ik_ + imax_;
for (jj_ = imax_; jj_ <= k_; (jj_)++) {
  j_ = k_ + imax_ - jj_;
  jk_ = ik_ + j_;
  t_ = conjf (ap_[jk_ - 1]);
  ap_[jk_ - 1] = conjf (ap_[imj_ - 1]);
  ap_[imj_ - 1] = t_;
  imj_ = imj_ - (j_ - 1);
}

_l120:;
ij_ = ik_ - (k_ - 1);
for (jj_ = 1; jj_ <= km1_; (jj_)++) {
  j_ = k_ - jj_;
  jk_ = ik_ + j_;
  mulk_ = -ap_[jk_ - 1] / ap_[kk_ - 1];
  t_ = conjf (mulk_);
  (void) _caxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  ijj_ = ij_ + j_;
  ap_[ijj_ - 1] = CMPLXF ((real_4) (crealf (ap_[ijj_ - 1])), 0.0);
  ap_[jk_ - 1] = mulk_;
  ij_ = ij_ - (j_ - 1);
}

kpvt_[k_ - 1] = k_;
if (swap_) {
  kpvt_[k_ - 1] = imax_;
}

goto _l190;
_l140:;
km1k_ = ik_ + k_ - 1;
ikm1_ = ik_ - (k_ - 1);
if (! (swap_)) {
  goto _l160;
}

(void) _cswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ikm1_ + 1 - 1], &_k1);
imj_ = ikm1_ + imax_;
for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
  j_ = km1_ + imax_ - jj_;
  jkm1_ = ikm1_ + j_;
  t_ = conjf (ap_[jkm1_ - 1]);
  ap_[jkm1_ - 1] = conjf (ap_[imj_ - 1]);
  ap_[imj_ - 1] = t_;
  imj_ = imj_ - (j_ - 1);
}

t_ = ap_[km1k_ - 1];
ap_[km1k_ - 1] = ap_[imk_ - 1];
ap_[imk_ - 1] = t_;
_l160:;
km2_ = k_ - 2;
if (km2_ == 0) {
  goto _l180;
}

ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
km1km1_ = ikm1_ + k_ - 1;
akm1_ = ap_[km1km1_ - 1] / conjf (ap_[km1k_ - 1]);
denom_ = 1.0e0 - ak_ * akm1_;
ij_ = ik_ - (k_ - 1) - (k_ - 2);
for (jj_ = 1; jj_ <= km2_; (jj_)++) {
  j_ = km1_ - jj_;
  jk_ = ik_ + j_;
  bk_ = ap_[jk_ - 1] / ap_[km1k_ - 1];
  jkm1_ = ikm1_ + j_;
  bkm1_ = ap_[jkm1_ - 1] / conjf (ap_[km1k_ - 1]);
  mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
  mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
  t_ = conjf (mulk_);
  (void) _caxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  t_ = conjf (mulkm1_);
  (void) _caxpy (&j_, &t_, &ap_[ikm1_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  ap_[jk_ - 1] = mulk_;
  ap_[jkm1_ - 1] = mulkm1_;
  ijj_ = ij_ + j_;
  ap_[ijj_ - 1] = CMPLXF ((real_4) (crealf (ap_[ijj_ - 1])), 0.0);
  ij_ = ij_ - (j_ - 1);
}

_l180:;
kpvt_[k_ - 1] = 1 - k_;
if (swap_) {
  kpvt_[k_ - 1] = -imax_;
}

kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
_l190:;
ik_ = ik_ - (k_ - 1);
if (kstep_ == 2) {
  ik_ = ik_ - (k_ - 2);
}

k_ = k_ - kstep_;
goto _l10;
_l200:;
__calls[19].calls++;
return 0;
}

int_4 _chpsl (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ b_)
{
  static int_4 ik_, ikm1_, ikp1_, k_, kk_, km1k_, km1km1_, kp_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern complex_8 _cdotc ();
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  kk_ = ik_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _caxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
  k_ = k_ - 1;
  ik_ = ik_ - k_;
  goto _l70;
  _l40:;
  ikm1_ = ik_ - (k_ - 1);
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _caxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  (void) _caxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l60:;
  km1k_ = ik_ + k_ - 1;
  kk_ = ik_ + k_;
  ak_ = ap_[kk_ - 1] / conjf (ap_[km1k_ - 1]);
  km1km1_ = ikm1_ + k_ - 1;
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = b_[k_ - 1] / conjf (ap_[km1k_ - 1]);
  bkm1_ = b_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  ik_ = ik_ - (k_ + 1) - k_;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  ik_ = 0;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _cdotc (($3_ = k_ - 1, &$3_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  ik_ = ik_ + k_;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _cdotc (($4_ = k_ - 1, &$4_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  ikp1_ = ik_ + k_;
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _cdotc (($5_ = k_ - 1, &$5_), &ap_[ikp1_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  ik_ = ik_ + k_ + k_ + 1;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[20].calls++;
  return 0;
}

int_4 _cpbco (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ rcond_, complex_8 _p_ z_, 
int_4 _p_ info_)
{
  static int_4 i_, j_, j2_, k_, kb_, kp1_, l_, la_, lb_, lm_, mu_;
  static real_4 anorm_, s_, sm_, ynorm_;
  static complex_8 ek_, t_, wk_, wkm_, zdum_, zdum2_;
  extern complex_8 _cdotc ();
  extern real_4 _scasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = _min (j_, (*m_) + 1);
    mu_ = _max ((*m_) + 2 - j_, 1);
    z_[j_ - 1] = CMPLXF (_scasum (&l_, &abd_[mu_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1), 0.0);
    k_ = j_ - l_;
    if ((*m_) < mu_) {
      goto _l20;
    }
    for (i_ = mu_; i_ <= (*m_); (i_)++) {
      k_ = k_ + 1;
      z_[k_ - 1] = CMPLXF ((real_4) (crealf (z_[k_ - 1])) + ({complex_8 zdum__1_ = abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]; 
      _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}), 0.0);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, (real_4) (crealf (z_[j_ - 1])));
  }
  (void) _cpbfa (abd_, lda_, n_, m_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = -z_[k_ - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
  }
  if (({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 
  (real_4) (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]))) {
  goto _l60;
}

s_ = (real_4) (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))])) / ({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs 
((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l60:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_8 zdum__1_ = wk_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
sm_ = ({complex_8 zdum__1_ = wkm_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
wk_ = wk_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
wkm_ = wkm_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
kp1_ = k_ + 1;
j2_ = _min (k_ + (*m_), (*n_));
i_ = (*m_) + 1;
if (kp1_ > j2_) {
  goto _l100;
}

for (j_ = kp1_; j_ <= j2_; (j_)++) {
  i_ = i_ - 1;
  sm_ = sm_ + ({complex_8 zdum__1_ = z_[j_ - 1] + wkm_ * conjf (abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]); _abs ((real_4) 
  (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conjf (abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_8 zdum__1_ = z_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l90;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
i_ = (*m_) + 1;
for (j_ = kp1_; j_ <= j2_; (j_)++) {
  i_ = i_ - 1;
  z_[j_ - 1] = z_[j_ - 1] + t_ * conjf (abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
}

_l90:;
_l100:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]))) {
  goto _l120;
}

s_ = (real_4) (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs 
((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
_l120:;
z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
lm_ = _min (k_ - 1, (*m_));
la_ = (*m_) + 1 - lm_;
lb_ = k_ - lm_;
t_ = -z_[k_ - 1];
(void) _caxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  lm_ = _min (k_ - 1, (*m_));
  la_ = (*m_) + 1 - lm_;
  lb_ = k_ - lm_;
  z_[k_ - 1] = z_[k_ - 1] - _cdotc (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]))) {
  goto _l140;
}

s_ = (real_4) (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs 
((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l140:;
z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]))) {
  goto _l160;
}

s_ = (real_4) (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs 
((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l160:;
z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
lm_ = _min (k_ - 1, (*m_));
la_ = (*m_) + 1 - lm_;
lb_ = k_ - lm_;
t_ = -z_[k_ - 1];
(void) _caxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

_l180:;
__calls[21].calls++;
return 0;
}

int_4 _cpbdi (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ det_)
{
  static int_4 i_;
  static real_4 s_;
  real_4 $0_;
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = ($0_ = (real_4) (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((i_ - 1))])), $0_ * $0_) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  __calls[22].calls++;
  return 0;
}

int_4 _cpbfa (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ info_)
{
  static int_4 ik_, j_, jk_, k_, mu_;
  static real_4 s_;
  static complex_8 t_;
  int_4 $0_;
  extern complex_8 _cdotc ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    ik_ = (*m_) + 1;
    jk_ = _max (j_ - (*m_), 1);
    mu_ = _max ((*m_) + 2 - j_, 1);
    if ((*m_) < mu_) {
      goto _l20;
    }
    for (k_ = mu_; k_ <= (*m_); (k_)++) {
      t_ = abd_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _cdotc (($0_ = k_ - mu_, &$0_), &abd_[ik_ - 1 + ((*lda_)) * ((jk_ - 1))], 
      &_k1, &abd_[mu_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
      t_ = t_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((jk_ - 1))];
      abd_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + (real_4) (crealf (t_ * conjf (t_)));
      ik_ = ik_ - 1;
      jk_ = jk_ + 1;
    }
    _l20:;
    s_ = (real_4) (crealf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))])) - s_;
    if (s_ <= 0.0e0 || cimagf (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))]) != 0.0e0) {
      goto _l40;
    }
    abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))] = CMPLXF (sqrtf (s_), 0.0);
  }
  (*info_) = 0;
  _l40:;
  __calls[23].calls++;
  return 0;
}

int_4 _cpbsl (complex_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, complex_8 _p_ b_)
{
  static int_4 k_, kb_, la_, lb_, lm_;
  static complex_8 t_;
  extern complex_8 _cdotc ();
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    t_ = _cdotc (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    b_[k_ - 1] = b_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _caxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
  }
  __calls[24].calls++;
  return 0;
}

int_4 _cpoco (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ rcond_, complex_8 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, j_, jm1_, k_, kb_, kp1_;
  static real_4 anorm_, s_, sm_, ynorm_;
  static complex_8 ek_, t_, wk_, wkm_, zdum_, zdum2_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotc ();
  extern real_4 _scasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (_scasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1), 0.0);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLXF ((real_4) (crealf (z_[i_ - 1])) + ({complex_8 zdum__1_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs 
      ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}), 0.0);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, (real_4) (crealf (z_[j_ - 1])));
  }
  (void) _cpofa (a_, lda_, n_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = -z_[k_ - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
  }
  if (({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 
  (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]))) {
  goto _l60;
}

s_ = (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) / ({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) 
(crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l60:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_8 zdum__1_ = wk_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
sm_ = ({complex_8 zdum__1_ = wkm_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
wk_ = wk_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
wkm_ = wkm_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
kp1_ = k_ + 1;
if (kp1_ > (*n_)) {
  goto _l100;
}

for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  sm_ = sm_ + ({complex_8 zdum__1_ = z_[j_ - 1] + wkm_ * conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]); _abs ((real_4) 
  (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_8 zdum__1_ = z_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l90;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  z_[j_ - 1] = z_[j_ - 1] + t_ * conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
}

_l90:;
_l100:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]))) {
  goto _l120;
}

s_ = (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) 
(crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
_l120:;
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
t_ = -z_[k_ - 1];
(void) _caxpy (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  z_[k_ - 1] = z_[k_ - 1] - _cdotc (($1_ = k_ - 1, &$1_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]))) {
  goto _l140;
}
s_ = (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) 
(crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l140:;
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]))) {
  goto _l160;
}

s_ = (real_4) (crealf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) 
(crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l160:;
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
t_ = -z_[k_ - 1];
(void) _caxpy (($2_ = k_ - 1, &$2_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

_l180:;
__calls[25].calls++;
return 0;
}

int_4 _cpodi (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_)
{
  static int_4 i_, j_, jm1_, k_, kp1_;
  static real_4 s_;
  static complex_8 t_;
  int_4 $1_;
  real_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = ($0_ = (real_4) (crealf (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))])), $0_ * $0_) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l140;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLXF (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _cscal (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    kp1_ = k_ + 1;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
      (void) _caxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l90:;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l120;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = conjf (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      (void) _caxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    }
    _l120:;
    t_ = conjf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
    (void) _cscal (&j_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  }
  _l140:;
  __calls[26].calls++;
  return 0;
}

int_4 _cpofa (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, jm1_, k_;
  static real_4 s_;
  static complex_8 t_;
  int_4 $0_;
  extern complex_8 _cdotc ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _cdotc (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + 
      ((*lda_)) * ((j_ - 1))], &_k1);
      t_ = t_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + (real_4) (crealf (t_ * conjf (t_)));
    }
    _l20:;
    s_ = (real_4) (crealf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) - s_;
    if (s_ <= 0.0e0 || cimagf (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]) != 0.0e0) {
      goto _l40;
    }
    a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLXF (sqrtf (s_), 0.0);
  }
  (*info_) = 0;
  _l40:;
  __calls[27].calls++;
  return 0;
}

int_4 _cposl (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ b_)
{
  static int_4 k_, kb_;
  static complex_8 t_;
  int_4 $0_, $1_;
  extern complex_8 _cdotc ();
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _cdotc (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _caxpy (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  __calls[28].calls++;
  return 0;
}

int_4 _cppco (complex_8 _p_ ap_, int_4 _p_ n_, real_4 _p_ rcond_, complex_8 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, ij_, j_, jm1_, j1_, k_, kb_, kj_, kk_, kp1_;
  static real_4 anorm_, s_, sm_, ynorm_;
  static complex_8 ek_, t_, wk_, wkm_, zdum_, zdum2_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotc ();
  extern real_4 _scasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (_scasum (&j_, &ap_[j1_ - 1], &_k1), 0.0);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLXF ((real_4) (crealf (z_[i_ - 1])) + ({complex_8 zdum__1_ = ap_[ij_ - 1]; _abs ((real_4) (crealf 
      (zdum__1_))) + _abs (cimagf (zdum__1_));}), 0.0);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, (real_4) (crealf (z_[j_ - 1])));
  }
  (void) _cppfa (ap_, n_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = kk_ + k_;
    if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = -z_[k_ - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
  }
  if (({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 
  (real_4) (crealf (ap_[kk_ - 1]))) {
  goto _l60;
}

s_ = (real_4) (crealf (ap_[kk_ - 1])) / ({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + 
_abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l60:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_8 zdum__1_ = wk_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
sm_ = ({complex_8 zdum__1_ = wkm_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
wk_ = wk_ / ap_[kk_ - 1];
wkm_ = wkm_ / ap_[kk_ - 1];
kp1_ = k_ + 1;
kj_ = kk_ + k_;
if (kp1_ > (*n_)) {
  goto _l100;
}

for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  sm_ = sm_ + ({complex_8 zdum__1_ = z_[j_ - 1] + wkm_ * conjf (ap_[kj_ - 1]); _abs ((real_4) (crealf (zdum__1_))) + _abs 
  (cimagf (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conjf (ap_[kj_ - 1]);
  s_ = s_ + ({complex_8 zdum__1_ = z_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
  kj_ = kj_ + j_;
}

if (s_ >= sm_) {
  goto _l90;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
kj_ = kk_ + k_;
for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  z_[j_ - 1] = z_[j_ - 1] + t_ * conjf (ap_[kj_ - 1]);
  kj_ = kj_ + j_;
}

_l90:;
_l100:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (ap_[kk_ - 1]))) {
  goto _l120;
}

s_ = (real_4) (crealf (ap_[kk_ - 1])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
_l120:;
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
kk_ = kk_ - k_;
t_ = -z_[k_ - 1];
(void) _caxpy (($0_ = k_ - 1, &$0_), &t_, &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  z_[k_ - 1] = z_[k_ - 1] - _cdotc (($1_ = k_ - 1, &$1_), &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
  kk_ = kk_ + k_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (ap_[kk_ - 1]))) {
  goto _l140;
}

s_ = (real_4) (crealf (ap_[kk_ - 1])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l140:;
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= (real_4) 
  (crealf (ap_[kk_ - 1]))) {
  goto _l160;
}

s_ = (real_4) (crealf (ap_[kk_ - 1])) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l160:;
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
kk_ = kk_ - k_;
t_ = -z_[k_ - 1];
(void) _caxpy (($2_ = k_ - 1, &$2_), &t_, &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

_l180:;
__calls[29].calls++;
return 0;
}

int_4 _cppdi (complex_8 _p_ ap_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_)
{
  static int_4 i_, ii_, j_, jj_, jm1_, j1_, k_, kj_, kk_, kp1_, k1_;
  static real_4 s_;
  static complex_8 t_;
  int_4 $1_;
  real_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  ii_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ii_ = ii_ + i_;
    det_[0] = ($0_ = (real_4) (crealf (ap_[ii_ - 1])), $0_ * $0_) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l140;
  }
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    k1_ = kk_ + 1;
    kk_ = kk_ + k_;
    ap_[kk_ - 1] = CMPLXF (1.0, 0.0) / ap_[kk_ - 1];
    t_ = -ap_[kk_ - 1];
    (void) _cscal (($1_ = k_ - 1, &$1_), &t_, &ap_[k1_ - 1], &_k1);
    kp1_ = k_ + 1;
    j1_ = kk_ + 1;
    kj_ = kk_ + k_;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = ap_[kj_ - 1];
      ap_[kj_ - 1] = CMPLXF (0.0, 0.0);
      (void) _caxpy (&k_, &t_, &ap_[k1_ - 1], &_k1, &ap_[j1_ - 1], &_k1);
      j1_ = j1_ + j_;
      kj_ = kj_ + j_;
    }
    _l90:;
  }
  jj_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    j1_ = jj_ + 1;
    jj_ = jj_ + j_;
    jm1_ = j_ - 1;
    k1_ = 1;
    kj_ = j1_;
    if (jm1_ < 1) {
      goto _l120;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = conjf (ap_[kj_ - 1]);
      (void) _caxpy (&k_, &t_, &ap_[j1_ - 1], &_k1, &ap_[k1_ - 1], &_k1);
      k1_ = k1_ + k_;
      kj_ = kj_ + 1;
    }
    _l120:;
    t_ = conjf (ap_[jj_ - 1]);
    (void) _cscal (&j_, &t_, &ap_[j1_ - 1], &_k1);
  }
  _l140:;
  __calls[30].calls++;
  return 0;
}

int_4 _cppfa (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, jj_, jm1_, k_, kj_, kk_;
  static real_4 s_;
  static complex_8 t_;
  int_4 $0_;
  extern complex_8 _cdotc ();
  jj_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    jm1_ = j_ - 1;
    kj_ = jj_;
    kk_ = 0;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      kj_ = kj_ + 1;
      t_ = ap_[kj_ - 1] - _cdotc (($0_ = k_ - 1, &$0_), &ap_[kk_ + 1 - 1], &_k1, &ap_[jj_ + 1 - 1], &_k1);
      kk_ = kk_ + k_;
      t_ = t_ / ap_[kk_ - 1];
      ap_[kj_ - 1] = t_;
      s_ = s_ + (real_4) (crealf (t_ * conjf (t_)));
    }
    _l20:;
    jj_ = jj_ + j_;
    s_ = (real_4) (crealf (ap_[jj_ - 1])) - s_;
    if (s_ <= 0.0e0 || cimagf (ap_[jj_ - 1]) != 0.0e0) {
      goto _l40;
    }
    ap_[jj_ - 1] = CMPLXF (sqrtf (s_), 0.0);
  }
  (*info_) = 0;
  _l40:;
  __calls[31].calls++;
  return 0;
}

int_4 _cppsl (complex_8 _p_ ap_, int_4 _p_ n_, complex_8 _p_ b_)
{
  static int_4 k_, kb_, kk_;
  static complex_8 t_;
  int_4 $0_, $1_;
  extern complex_8 _cdotc ();
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _cdotc (($0_ = k_ - 1, &$0_), &ap_[kk_ + 1 - 1], &_k1, &b_[0], &_k1);
    kk_ = kk_ + k_;
    b_[k_ - 1] = (b_[k_ - 1] - t_) / ap_[kk_ - 1];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
    kk_ = kk_ - k_;
    t_ = -b_[k_ - 1];
    (void) _caxpy (($1_ = k_ - 1, &$1_), &t_, &ap_[kk_ + 1 - 1], &_k1, &b_[0], &_k1);
  }
  __calls[32].calls++;
  return 0;
}

int_4 _cptsl (int_4 _p_ n_, complex_8 _p_ d_, complex_8 _p_ e_, complex_8 _p_ b_)
{
  static int_4 k_, kbm1_, ke_, kf_, kp1_, nm1_, nm1d2_;
  static complex_8 t1_, t2_;
  if ((*n_) != 1) {
    goto _l10;
  }
  b_[0] = b_[0] / d_[0];
  goto _l70;
  _l10:;
  nm1_ = (*n_) - 1;
  nm1d2_ = nm1_ / 2;
  if ((*n_) == 2) {
    goto _l30;
  }
  kbm1_ = (*n_) - 1;
  for (k_ = 1; k_ <= nm1d2_; (k_)++) {
    t1_ = conjf (e_[k_ - 1]) / d_[k_ - 1];
    d_[k_ + 1 - 1] = d_[k_ + 1 - 1] - t1_ * e_[k_ - 1];
    b_[k_ + 1 - 1] = b_[k_ + 1 - 1] - t1_ * b_[k_ - 1];
    t2_ = e_[kbm1_ - 1] / d_[kbm1_ + 1 - 1];
    d_[kbm1_ - 1] = d_[kbm1_ - 1] - t2_ * conjf (e_[kbm1_ - 1]);
    b_[kbm1_ - 1] = b_[kbm1_ - 1] - t2_ * b_[kbm1_ + 1 - 1];
    kbm1_ = kbm1_ - 1;
  }
  _l30:;
  kp1_ = nm1d2_ + 1;
  if (_imod ((*n_), 2) != 0) {
    goto _l40;
  }
  t1_ = conjf (e_[kp1_ - 1]) / d_[kp1_ - 1];
  d_[kp1_ + 1 - 1] = d_[kp1_ + 1 - 1] - t1_ * e_[kp1_ - 1];
  b_[kp1_ + 1 - 1] = b_[kp1_ + 1 - 1] - t1_ * b_[kp1_ - 1];
  kp1_ = kp1_ + 1;
  _l40:;
  b_[kp1_ - 1] = b_[kp1_ - 1] / d_[kp1_ - 1];
  if ((*n_) == 2) {
    goto _l60;
  }
  k_ = kp1_ - 1;
  ke_ = kp1_ + nm1d2_ - 1;
  for (kf_ = kp1_; kf_ <= ke_; (kf_)++) {
    b_[k_ - 1] = (b_[k_ - 1] - e_[k_ - 1] * b_[k_ + 1 - 1]) / d_[k_ - 1];
    b_[kf_ + 1 - 1] = (b_[kf_ + 1 - 1] - conjf (e_[kf_ - 1]) * b_[kf_ - 1]) / d_[kf_ + 1 - 1];
    k_ = k_ - 1;
  }
  _l60:;
  if (_imod ((*n_), 2) == 0) {
    b_[0] = (b_[0] - e_[0] * b_[1]) / d_[0];
  }
  _l70:;
  __calls[33].calls++;
  return 0;
}

int_4 _cqrdc (complex_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, complex_8 _p_ qraux_, int_4 _p_ jpvt_, 
complex_8 _p_ work_, int_4 _p_ job_)
{
  static int_4 j_, jp_, l_, lp1_, lup_, maxj_, pl_, pu_, jj_;
  static logical_4 negj_, swapj_;
  static real_4 maxnrm_, tt_;
  static complex_8 nrmxl_, t_, zdum_, zdum1_, zdum2_;
  int_4 $0_, $1_, $3_, $4_, $7_;
  real_4 $5_, $6_;
  complex_8 $2_;
  extern real_4 _scnrm2 ();
  extern complex_8 _cdotc ();
  pl_ = 1;
  pu_ = 0;
  if ((*job_) == 0) {
    goto _l60;
  }
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    swapj_ = jpvt_[j_ - 1] > 0;
    negj_ = jpvt_[j_ - 1] < 0;
    jpvt_[j_ - 1] = j_;
    if (negj_) {
      jpvt_[j_ - 1] = -j_;
    }
    if (! (swapj_)) {
      goto _l10;
    }
    if (j_ != pl_) {
      (void) _cswap (n_, &x_[0 + ((*ldx_)) * ((pl_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    }
    jpvt_[j_ - 1] = jpvt_[pl_ - 1];
    jpvt_[pl_ - 1] = j_;
    pl_ = pl_ + 1;
    _l10:;
  }
  pu_ = (*p_);
  for (jj_ = 1; jj_ <= (*p_); (jj_)++) {
    j_ = (*p_) - jj_ + 1;
    if (jpvt_[j_ - 1] >= 0) {
      goto _l40;
    }
    jpvt_[j_ - 1] = -jpvt_[j_ - 1];
    if (j_ == pu_) {
      goto _l30;
    }
    (void) _cswap (n_, &x_[0 + ((*ldx_)) * ((pu_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    jp_ = jpvt_[pu_ - 1];
    jpvt_[pu_ - 1] = jpvt_[j_ - 1];
    jpvt_[j_ - 1] = jp_;
    _l30:;
    pu_ = pu_ - 1;
    _l40:;
  }
  _l60:;
  if (pu_ < pl_) {
    goto _l80;
  }
  for (j_ = pl_; j_ <= pu_; (j_)++) {
    qraux_[j_ - 1] = CMPLXF (_scnrm2 (n_, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1), 0.0);
    work_[j_ - 1] = qraux_[j_ - 1];
  }
  _l80:;
  lup_ = _min ((*n_), (*p_));
  for (l_ = 1; l_ <= lup_; (l_)++) {
    if (l_ < pl_ || l_ >= pu_) {
      goto _l120;
    }
    maxnrm_ = 0.0;
    maxj_ = l_;
    for (j_ = l_; j_ <= pu_; (j_)++) {
      if ((real_4) (crealf (qraux_[j_ - 1])) <= maxnrm_) {
        goto _l90;
      }
      maxnrm_ = (real_4) (crealf (qraux_[j_ - 1]));
      maxj_ = j_;
      _l90:;
    }
    if (maxj_ == l_) {
      goto _l110;
    }
    (void) _cswap (n_, &x_[0 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((maxj_ - 1))], &_k1);
    qraux_[maxj_ - 1] = qraux_[l_ - 1];
    work_[maxj_ - 1] = work_[l_ - 1];
    jp_ = jpvt_[maxj_ - 1];
    jpvt_[maxj_ - 1] = jpvt_[l_ - 1];
    jpvt_[l_ - 1] = jp_;
    _l110:;
    _l120:;
    qraux_[l_ - 1] = CMPLXF (0.0, 0.0);
    if (l_ == (*n_)) {
      goto _l190;
    }
    nrmxl_ = CMPLXF (_scnrm2 (($0_ = (*n_) - l_ + 1, &$0_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1), 0.0);
    if (({complex_8 zdum__1_ = nrmxl_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
    goto _l180;
  }
  if (({complex_8 zdum__1_ = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));}) != 0.0e0) {
  nrmxl_ = ({complex_8 zdum1__1_ = nrmxl_; complex_8 zdum2__1_ = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]; cabsf (zdum1__1_) * 
  (zdum2__1_ / cabsf (zdum2__1_));});
}

(void) _cscal (($1_ = (*n_) - l_ + 1, &$1_), ($2_ = CMPLXF (1.0, 0.0) / nrmxl_, &$2_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 
1))], &_k1);
x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = CMPLXF (1.0, 0.0) + x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
lp1_ = l_ + 1;
if ((*p_) < lp1_) {
  goto _l170;
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  t_ = -_cdotc (($3_ = (*n_) - l_ + 1, &$3_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * ((j_ - 
  1))], &_k1) / x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
  (void) _caxpy (($4_ = (*n_) - l_ + 1, &$4_), &t_, &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * 
  ((j_ - 1))], &_k1);
  if (j_ < pl_ || j_ > pu_) {
    goto _l150;
  }
  if (({complex_8 zdum__1_ = qraux_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) 
  {
  goto _l150;
}

tt_ = 1.0e0 - ($5_ = (cabsf (x_[l_ - 1 + ((*ldx_)) * ((j_ - 1))]) / (real_4) (crealf (qraux_[j_ - 1]))), $5_ * $5_);
tt_ = _max (tt_, 0.0);
t_ = CMPLXF (tt_, 0.0);
tt_ = 1.0e0 + 0.05e0 * tt_ * ($6_ = ((real_4) (crealf (qraux_[j_ - 1])) / (real_4) (crealf (work_[j_ - 1]))), $6_ * 
$6_);
if (tt_ == 1.0e0) {
  goto _l130;
}

qraux_[j_ - 1] = qraux_[j_ - 1] * csqrtf (t_);
goto _l140;
_l130:;
qraux_[j_ - 1] = CMPLXF (_scnrm2 (($7_ = (*n_) - l_, &$7_), &x_[l_ + 1 - 1 + ((*ldx_)) * ((j_ - 1))], &_k1), 0.0);
work_[j_ - 1] = qraux_[j_ - 1];
_l140:;
_l150:;
}

_l170:;
qraux_[l_ - 1] = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = -nrmxl_;
_l180:;
_l190:;
}

__calls[34].calls++;
return 0;
}

int_4 _cqrsl (complex_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ k_, complex_8 _p_ qraux_, complex_8 _p_ y_, 
complex_8 _p_ qy_, complex_8 _p_ qty_, complex_8 _p_ b_, complex_8 _p_ rsd_, complex_8 _p_ xb_, int_4 _p_ job_, int_4 
_p_ info_)
{
  static int_4 i_, j_, jj_, ju_, kp1_;
  static logical_4 cb_, cqy_, cqty_, cr_, cxb_;
  static complex_8 t_, temp_, zdum_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  extern complex_8 _cdotc ();
  (*info_) = 0;
  cqy_ = (*job_) / 10000 != 0;
  cqty_ = _imod ((*job_), 10000) != 0;
  cb_ = _imod ((*job_), 1000) / 100 != 0;
  cr_ = _imod ((*job_), 100) / 10 != 0;
  cxb_ = _imod ((*job_), 10) != 0;
  ju_ = _min ((*k_), (*n_) - 1);
  if (ju_ != 0) {
    goto _l40;
  }
  if (cqy_) {
    qy_[0] = y_[0];
  }
  if (cqty_) {
    qty_[0] = y_[0];
  }
  if (cxb_) {
    xb_[0] = y_[0];
  }
  if (! (cb_)) {
    goto _l30;
  }
  if (({complex_8 zdum__1_ = x_[0 + ((*ldx_)) * ((0))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) 
  != 0.0e0) {
  goto _l10;
}

(*info_) = 1;
goto _l20;
_l10:;
b_[0] = y_[0] / x_[0 + ((*ldx_)) * ((0))];
_l20:;
_l30:;
if (cr_) {
  rsd_[0] = CMPLXF (0.0, 0.0);
}

goto _l250;
_l40:;
if (cqy_) {
  (void) _ccopy (n_, y_, &_k1, qy_, &_k1);
}

if (cqty_) {
  (void) _ccopy (n_, y_, &_k1, qty_, &_k1);
}

if (! (cqy_)) {
  goto _l70;
}

for (jj_ = 1; jj_ <= ju_; (jj_)++) {
  j_ = ju_ - jj_ + 1;
  if (({complex_8 zdum__1_ = qraux_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) 
  {
  goto _l50;
}

temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
t_ = -_cdotc (($0_ = (*n_) - j_ + 1, &$0_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qy_[j_ - 1], &_k1) / x_[j_ - 1 
+ ((*ldx_)) * ((j_ - 1))];
(void) _caxpy (($1_ = (*n_) - j_ + 1, &$1_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qy_[j_ - 1], &_k1);
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
_l50:;
}

_l70:;
if (! (cqty_)) {
  goto _l100;
}

for (j_ = 1; j_ <= ju_; (j_)++) {
  if (({complex_8 zdum__1_ = qraux_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) 
  {
  goto _l80;
}

temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
t_ = -_cdotc (($2_ = (*n_) - j_ + 1, &$2_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qty_[j_ - 1], &_k1) / x_[j_ - 
1 + ((*ldx_)) * ((j_ - 1))];
(void) _caxpy (($3_ = (*n_) - j_ + 1, &$3_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qty_[j_ - 1], &_k1);
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
_l80:;
}

_l100:;
if (cb_) {
  (void) _ccopy (k_, qty_, &_k1, b_, &_k1);
}

kp1_ = (*k_) + 1;
if (cxb_) {
  (void) _ccopy (k_, qty_, &_k1, xb_, &_k1);
}

if (cr_ && (*k_) < (*n_)) {
  (void) _ccopy (($4_ = (*n_) - (*k_), &$4_), &qty_[kp1_ - 1], &_k1, &rsd_[kp1_ - 1], &_k1);
}

if (! (cxb_) || kp1_ > (*n_)) {
  goto _l120;
}
for (i_ = kp1_; i_ <= (*n_); (i_)++) {
  xb_[i_ - 1] = CMPLXF (0.0, 0.0);
}

_l120:;
if (! (cr_)) {
  goto _l140;
}

for (i_ = 1; i_ <= (*k_); (i_)++) {
  rsd_[i_ - 1] = CMPLXF (0.0, 0.0);
}

_l140:;
if (! (cb_)) {
  goto _l190;
}

for (jj_ = 1; jj_ <= (*k_); (jj_)++) {
  j_ = (*k_) - jj_ + 1;
  if (({complex_8 zdum__1_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));}) != 0.0e0) {
  goto _l150;
}

(*info_) = j_;
goto _l180;
_l150:;
b_[j_ - 1] = b_[j_ - 1] / x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
if (j_ == 1) {
  goto _l160;
}

t_ = -b_[j_ - 1];
(void) _caxpy (($5_ = j_ - 1, &$5_), &t_, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1, b_, &_k1);
_l160:;
}

_l180:;
_l190:;
if (! (cr_) && ! (cxb_)) {
  goto _l240;
}

for (jj_ = 1; jj_ <= ju_; (jj_)++) {
  j_ = ju_ - jj_ + 1;
  if (({complex_8 zdum__1_ = qraux_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) 
  {
  goto _l220;
}

temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
if (! (cr_)) {
  goto _l200;
}

t_ = -_cdotc (($6_ = (*n_) - j_ + 1, &$6_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &rsd_[j_ - 1], &_k1) / x_[j_ - 
1 + ((*ldx_)) * ((j_ - 1))];
(void) _caxpy (($7_ = (*n_) - j_ + 1, &$7_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &rsd_[j_ - 1], &_k1);
_l200:;
if (! (cxb_)) {
  goto _l210;
}

t_ = -_cdotc (($8_ = (*n_) - j_ + 1, &$8_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &xb_[j_ - 1], &_k1) / x_[j_ - 1 
+ ((*ldx_)) * ((j_ - 1))];
(void) _caxpy (($9_ = (*n_) - j_ + 1, &$9_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &xb_[j_ - 1], &_k1);
_l210:;
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
_l220:;
}

_l240:;
_l250:;
__calls[35].calls++;
return 0;
}

int_4 _csico (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, complex_8 _p_ z_)
{
  static int_4 i_, info_, j_, jm1_, k_, kp_, kps_, ks_;
  static real_4 anorm_, s_, ynorm_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, zdum_, zdum2_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_8 _cdotu ();
  extern real_4 _scasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (_scasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1), 0.0);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLXF ((real_4) (crealf (z_[i_ - 1])) + ({complex_8 zdum__1_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs 
      ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}), 0.0);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, (real_4) (crealf (z_[j_ - 1])));
  }
  (void) _csifa (a_, lda_, n_, kpvt_, &info_);
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  k_ = (*n_);
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
  ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = z_[k_ - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
  (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
  (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
}

z_[k_ - 1] = z_[k_ - 1] + ek_;
(void) _caxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 1) {
  goto _l80;
}

if (({complex_8 zdum__1_ = z_[k_ - 1 - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) 
{
ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = z_[k_ - 1 - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
(crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
(crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
}

z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
(void) _caxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
_l80:;
if (ks_ == 2) {
  goto _l100;
}

if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
goto _l90;
}

s_ = ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l90:;
if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

goto _l110;
_l100:;
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bk_ = z_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l110:;
k_ = k_ - ks_;
goto _l60;
_l120:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
k_ = 1;
_l130:;
if (k_ > (*n_)) {
  goto _l160;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l150;
}

z_[k_ - 1] = z_[k_ - 1] + _cdotu (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _cdotu (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], 
  &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l140;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l140:;
_l150:;
k_ = k_ + ks_;
goto _l130;
_l160:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
k_ = (*n_);
_l170:;
if (k_ == 0) {
  goto _l230;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == ks_) {
  goto _l190;
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
kps_ = k_ + 1 - ks_;
if (kp_ == kps_) {
  goto _l180;
}
t_ = z_[kps_ - 1];
z_[kps_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l180:;
(void) _caxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  (void) _caxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
}

_l190:;
if (ks_ == 2) {
  goto _l210;
}

if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
goto _l200;
}

s_ = ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l200:;
if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

goto _l220;
_l210:;
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bk_ = z_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l220:;
k_ = k_ - ks_;
goto _l170;
_l230:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
k_ = 1;
_l240:;
if (k_ > (*n_)) {
  goto _l270;
}
ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l260;
}

z_[k_ - 1] = z_[k_ - 1] + _cdotu (($6_ = k_ - 1, &$6_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _cdotu (($7_ = k_ - 1, &$7_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], 
  &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l250;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l250:;
_l260:;
k_ = k_ + ks_;
goto _l240;
_l270:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[36].calls++;
return 0;
}

int_4 _csidi (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ det_, complex_8 _p_ work_, 
int_4 _p_ job_)
{
  static int_4 j_, jb_, k_, km1_, ks_, kstep_;
  static logical_4 noinv_, nodet_;
  static real_4 ten_;
  static complex_8 ak_, akp1_, akkp1_, d_, t_, temp_, zdum_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotu ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  if (nodet_) {
    goto _l100;
  }
  det_[0] = CMPLXF (1.0, 0.0);
  det_[1] = CMPLXF (0.0, 0.0);
  ten_ = 10.0;
  t_ = CMPLXF (0.0, 0.0);
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    d_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    if (kpvt_[k_ - 1] > 0) {
      goto _l30;
    }
    if (({complex_8 zdum__1_ = t_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    goto _l10;
  }
  t_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  d_ = (d_ / t_) * a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] - t_;
  goto _l20;
  _l10:;
  d_ = t_;
  t_ = CMPLXF (0.0, 0.0);
  _l20:;
  _l30:;
  det_[0] = d_ * det_[0];
  if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
  goto _l80;
}

_l40:;
if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) >= 1.0e0) {
goto _l50;
}

det_[0] = CMPLXF (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLXF (1.0, 0.0);
goto _l40;
_l50:;
_l60:;
if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < ten_) {
goto _l70;
}
det_[0] = det_[0] / CMPLXF (ten_, 0.0);
det_[1] = det_[1] + CMPLXF (1.0, 0.0);
goto _l60;
_l70:;
_l80:;
}

_l100:;
if (noinv_) {
  goto _l230;
}

k_ = 1;
_l110:;
if (k_ > (*n_)) {
  goto _l220;
}

km1_ = k_ - 1;
if (kpvt_[k_ - 1] < 0) {
  goto _l140;
}

a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLXF (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
if (km1_ < 1) {
  goto _l130;
}

(void) _ccopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
for (j_ = 1; j_ <= km1_; (j_)++) {
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _cdotu (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
  (void) _caxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
  1))], &_k1);
}

a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + _cdotu (&km1_, work_, &_k1, &a_[0 + 
((*lda_)) * ((k_ - 1))], &_k1);
_l130:;
kstep_ = 1;
goto _l180;
_l140:;
t_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / t_;
akp1_ = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
akkp1_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
d_ = t_ * (ak_ * akp1_ - CMPLXF (1.0, 0.0));
a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = akp1_ / d_;
a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = ak_ / d_;
a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = -akkp1_ / d_;
if (km1_ < 1) {
  goto _l170;
}

(void) _ccopy (&km1_, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, work_, &_k1);
for (j_ = 1; j_ <= km1_; (j_)++) {
  a_[j_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = _cdotu (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
  (void) _caxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 
  1 - 1))], &_k1);
}

a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _cdotu (&km1_, work_, &_k1, 
&a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _cdotu (&km1_, &a_[0 + ((*lda_)) * 
((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
(void) _ccopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
for (j_ = 1; j_ <= km1_; (j_)++) {
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _cdotu (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
  (void) _caxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
  1))], &_k1);
}

a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + _cdotu (&km1_, work_, &_k1, &a_[0 + 
((*lda_)) * ((k_ - 1))], &_k1);
_l170:;
kstep_ = 2;
_l180:;
ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (ks_ == k_) {
  goto _l210;
}

(void) _cswap (&ks_, &a_[0 + ((*lda_)) * ((ks_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
for (jb_ = ks_; jb_ <= k_; (jb_)++) {
  j_ = k_ + ks_ - jb_;
  temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))];
  a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
}

if (kstep_ == 1) {
  goto _l200;
}

temp_ = a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = temp_;
_l200:;
_l210:;
k_ = k_ + kstep_;
goto _l110;
_l220:;
_l230:;
__calls[37].calls++;
return 0;
}

int_4 _csifa (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 imax_, imaxp1_, j_, jj_, jmax_, k_, km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_4 absakk_, alpha_, colmax_, rowmax_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, zdum_;
  int_4 $0_, $1_;
  extern int_4 _icamax ();
  alpha_ = 0.6403882;
  (*info_) = 0;
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (({complex_8 zdum__1_ = a_[0 + ((*lda_)) * ((0))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) 
  == 0.0e0) {
  (*info_) = 1;
}

goto _l200;
_l20:;
km1_ = k_ - 1;
absakk_ = ({complex_8 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));});
imax_ = _icamax (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
colmax_ = ({complex_8 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));});
if (absakk_ < alpha_ * colmax_) {
  goto _l30;
}

kstep_ = 1;
swap_ = FALSE;
goto _l90;
_l30:;
rowmax_ = 0.0;
imaxp1_ = imax_ + 1;
for (j_ = imaxp1_; j_ <= k_; (j_)++) {
  rowmax_ = _max (rowmax_, ({complex_8 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs ((real_4) (crealf 
  (zdum__1_))) + _abs (cimagf (zdum__1_));}));
}

if (imax_ == 1) {
  goto _l50;
}

jmax_ = _icamax (($1_ = imax_ - 1, &$1_), &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1);
rowmax_ = _max (rowmax_, ({complex_8 zdum__1_ = a_[jmax_ - 1 + ((*lda_)) * ((imax_ - 1))]; _abs ((real_4) (crealf 
(zdum__1_))) + _abs (cimagf (zdum__1_));}));
_l50:;
if (({complex_8 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((imax_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));}) < alpha_ * rowmax_) {
goto _l60;
}

kstep_ = 1;
swap_ = TRUE;
goto _l80;
_l60:;
if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
  goto _l70;
}

kstep_ = 1;
swap_ = FALSE;
goto _l80;
_l70:;
kstep_ = 2;
swap_ = imax_ != km1_;
_l80:;
_l90:;
if (_max (absakk_, colmax_) != 0.0e0) {
  goto _l100;
}

kpvt_[k_ - 1] = k_;
(*info_) = k_;
goto _l190;
_l100:;
if (kstep_ == 2) {
  goto _l140;
}

if (! (swap_)) {
  goto _l120;
}

(void) _cswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
for (jj_ = imax_; jj_ <= k_; (jj_)++) {
  j_ = k_ + imax_ - jj_;
  t_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))];
  a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
}

_l120:;
for (jj_ = 1; jj_ <= km1_; (jj_)++) {
  j_ = k_ - jj_;
  mulk_ = -a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  t_ = mulk_;
  (void) _caxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
}

kpvt_[k_ - 1] = k_;
if (swap_) {
  kpvt_[k_ - 1] = imax_;
}

goto _l190;
_l140:;
if (! (swap_)) {
  goto _l160;
}

(void) _cswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1);
for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
  j_ = km1_ + imax_ - jj_;
  t_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))];
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))];
  a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
}

t_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))];
a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
_l160:;
km2_ = k_ - 2;
if (km2_ == 0) {
  goto _l180;
}

ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = 1.0e0 - ak_ * akm1_;
for (jj_ = 1; jj_ <= km2_; (jj_)++) {
  j_ = km1_ - jj_;
  bk_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
  mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
  t_ = mulk_;
  (void) _caxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  t_ = mulkm1_;
  (void) _caxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = mulkm1_;
}

_l180:;
kpvt_[k_ - 1] = 1 - k_;
if (swap_) {
  kpvt_[k_ - 1] = -imax_;
}

kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
_l190:;
k_ = k_ - kstep_;
goto _l10;
_l200:;
__calls[38].calls++;
return 0;
}

int_4 _csisl (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ b_)
{
  static int_4 k_, kp_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern complex_8 _cdotu ();
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _caxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  k_ = k_ - 1;
  goto _l70;
  _l40:;
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _caxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  (void) _caxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &b_[0], &_k1);
  _l60:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = b_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = b_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _cdotu (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _cdotu (($4_ = k_ - 1, &$4_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _cdotu (($5_ = k_ - 1, &$5_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &b_[0], 
  &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[39].calls++;
  return 0;
}

int_4 _cspco (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, complex_8 _p_ z_)
{
  static int_4 i_, ij_, ik_, ikm1_, ikp1_, info_, j_, jm1_, j1_, k_, kk_, km1k_, km1km1_, kp_, kps_, ks_;
  static real_4 anorm_, s_, ynorm_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, zdum_, zdum2_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_8 _cdotu ();
  extern real_4 _scasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (_scasum (&j_, &ap_[j1_ - 1], &_k1), 0.0);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLXF ((real_4) (crealf (z_[i_ - 1])) + ({complex_8 zdum__1_ = ap_[ij_ - 1]; _abs ((real_4) (crealf 
      (zdum__1_))) + _abs (cimagf (zdum__1_));}), 0.0);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, (real_4) (crealf (z_[j_ - 1])));
  }
  (void) _cspfa (ap_, n_, kpvt_, &info_);
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  kk_ = ik_ + k_;
  ikm1_ = ik_ - (k_ - 1);
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
  ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = z_[k_ - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
  (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
  (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
}

z_[k_ - 1] = z_[k_ - 1] + ek_;
(void) _caxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
if (ks_ == 1) {
  goto _l80;
}

if (({complex_8 zdum__1_ = z_[k_ - 1 - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) 
{
ek_ = ({complex_8 zdum__1_ = ek_; complex_8 zdum2__1_ = z_[k_ - 1 - 1]; ({complex_8 zdum__2_ = zdum__1_; _abs ((real_4) 
(crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
(crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
}

z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
(void) _caxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
_l80:;
if (ks_ == 2) {
  goto _l100;
}

if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
goto _l90;
}

s_ = ({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) / 
({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l90:;
if (({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

if (({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

goto _l110;
_l100:;
km1k_ = ik_ + k_ - 1;
km1km1_ = ikm1_ + k_ - 1;
ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
bk_ = z_[k_ - 1] / ap_[km1k_ - 1];
bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l110:;
k_ = k_ - ks_;
ik_ = ik_ - k_;
if (ks_ == 2) {
  ik_ = ik_ - (k_ + 1);
}

goto _l60;
_l120:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
k_ = 1;
ik_ = 0;
_l130:;
if (k_ > (*n_)) {
  goto _l160;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l150;
}

z_[k_ - 1] = z_[k_ - 1] + _cdotu (($2_ = k_ - 1, &$2_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
ikp1_ = ik_ + k_;
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _cdotu (($3_ = k_ - 1, &$3_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l140;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l140:;
_l150:;
ik_ = ik_ + k_;
if (ks_ == 2) {
  ik_ = ik_ + (k_ + 1);
}

k_ = k_ + ks_;
goto _l130;
_l160:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
k_ = (*n_);
ik_ = (*n_) * ((*n_) - 1) / 2;
_l170:;
if (k_ == 0) {
  goto _l230;
}

kk_ = ik_ + k_;
ikm1_ = ik_ - (k_ - 1);
ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == ks_) {
  goto _l190;
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
kps_ = k_ + 1 - ks_;
if (kp_ == kps_) {
  goto _l180;
}

t_ = z_[kps_ - 1];
z_[kps_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l180:;
(void) _caxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  (void) _caxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

_l190:;
if (ks_ == 2) {
  goto _l210;
}

if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
goto _l200;
}

s_ = ({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) / 
({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l200:;
if (({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

if (({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

goto _l220;
_l210:;
km1k_ = ik_ + k_ - 1;
km1km1_ = ikm1_ + k_ - 1;
ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
bk_ = z_[k_ - 1] / ap_[km1k_ - 1];
bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l220:;
k_ = k_ - ks_;
ik_ = ik_ - k_;
if (ks_ == 2) {
  ik_ = ik_ - (k_ + 1);
}

goto _l170;
_l230:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
k_ = 1;
ik_ = 0;
_l240:;
if (k_ > (*n_)) {
  goto _l270;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l260;
}

z_[k_ - 1] = z_[k_ - 1] + _cdotu (($6_ = k_ - 1, &$6_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
ikp1_ = ik_ + k_;
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _cdotu (($7_ = k_ - 1, &$7_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l250;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l250:;
_l260:;
ik_ = ik_ + k_;
if (ks_ == 2) {
  ik_ = ik_ + (k_ + 1);
}

k_ = k_ + ks_;
goto _l240;
_l270:;
s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[40].calls++;
return 0;
}

int_4 _cspdi (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ det_, complex_8 _p_ work_, int_4 _p_ job_
)
{
  static int_4 ij_, ik_, ikp1_, iks_, j_, jb_, jk_, jkp1_, k_, kk_, kkp1_, km1_, ks_, ksj_, kskp1_, kstep_;
  static logical_4 noinv_, nodet_;
  static real_4 ten_;
  static complex_8 ak_, akkp1_, akp1_, d_, t_, temp_, zdum_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotu ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  if (nodet_) {
    goto _l110;
  }
  det_[0] = CMPLXF (1.0, 0.0);
  det_[1] = CMPLXF (0.0, 0.0);
  ten_ = 10.0;
  t_ = CMPLXF (0.0, 0.0);
  ik_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = ik_ + k_;
    d_ = ap_[kk_ - 1];
    if (kpvt_[k_ - 1] > 0) {
      goto _l30;
    }
    if (({complex_8 zdum__1_ = t_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    goto _l10;
  }
  ikp1_ = ik_ + k_;
  kkp1_ = ikp1_ + k_;
  t_ = ap_[kkp1_ - 1];
  d_ = (d_ / t_) * ap_[kkp1_ + 1 - 1] - t_;
  goto _l20;
  _l10:;
  d_ = t_;
  t_ = CMPLXF (0.0, 0.0);
  _l20:;
  _l30:;
  if (nodet_) {
    goto _l90;
  }
  det_[0] = d_ * det_[0];
  if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
  goto _l80;
}

_l40:;
if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) >= 1.0e0) {
goto _l50;
}

det_[0] = CMPLXF (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLXF (1.0, 0.0);
goto _l40;
_l50:;
_l60:;
if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < ten_) {
goto _l70;
}

det_[0] = det_[0] / CMPLXF (ten_, 0.0);
det_[1] = det_[1] + CMPLXF (1.0, 0.0);
goto _l60;
_l70:;
_l80:;
_l90:;
ik_ = ik_ + k_;
}

_l110:;
if (noinv_) {
  goto _l240;
}

k_ = 1;
ik_ = 0;
_l120:;
if (k_ > (*n_)) {
  goto _l230;
}

km1_ = k_ - 1;
kk_ = ik_ + k_;
ikp1_ = ik_ + k_;
if (kpvt_[k_ - 1] < 0) {
  goto _l150;
}

ap_[kk_ - 1] = CMPLXF (1.0, 0.0) / ap_[kk_ - 1];
if (km1_ < 1) {
  goto _l140;
}

(void) _ccopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
ij_ = 0;
for (j_ = 1; j_ <= km1_; (j_)++) {
  jk_ = ik_ + j_;
  ap_[jk_ - 1] = _cdotu (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
  (void) _caxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  ij_ = ij_ + j_;
}

ap_[kk_ - 1] = ap_[kk_ - 1] + _cdotu (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1);
_l140:;
kstep_ = 1;
goto _l190;
_l150:;
kkp1_ = ikp1_ + k_;
t_ = ap_[kkp1_ - 1];
ak_ = ap_[kk_ - 1] / t_;
akp1_ = ap_[kkp1_ + 1 - 1] / t_;
akkp1_ = ap_[kkp1_ - 1] / t_;
d_ = t_ * (ak_ * akp1_ - CMPLXF (1.0, 0.0));
ap_[kk_ - 1] = akp1_ / d_;
ap_[kkp1_ + 1 - 1] = ak_ / d_;
ap_[kkp1_ - 1] = -akkp1_ / d_;
if (km1_ < 1) {
  goto _l180;
}

(void) _ccopy (&km1_, &ap_[ikp1_ + 1 - 1], &_k1, work_, &_k1);
ij_ = 0;
for (j_ = 1; j_ <= km1_; (j_)++) {
  jkp1_ = ikp1_ + j_;
  ap_[jkp1_ - 1] = _cdotu (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
  (void) _caxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
  ij_ = ij_ + j_;
}

ap_[kkp1_ + 1 - 1] = ap_[kkp1_ + 1 - 1] + _cdotu (&km1_, work_, &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
ap_[kkp1_ - 1] = ap_[kkp1_ - 1] + _cdotu (&km1_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
(void) _ccopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
ij_ = 0;
for (j_ = 1; j_ <= km1_; (j_)++) {
  jk_ = ik_ + j_;
  ap_[jk_ - 1] = _cdotu (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
  (void) _caxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  ij_ = ij_ + j_;
}

ap_[kk_ - 1] = ap_[kk_ - 1] + _cdotu (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1);
_l180:;
kstep_ = 2;
_l190:;
ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (ks_ == k_) {
  goto _l220;
}

iks_ = (ks_ * (ks_ - 1)) / 2;
(void) _cswap (&ks_, &ap_[iks_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
ksj_ = ik_ + ks_;
for (jb_ = ks_; jb_ <= k_; (jb_)++) {
  j_ = k_ + ks_ - jb_;
  jk_ = ik_ + j_;
  temp_ = ap_[jk_ - 1];
  ap_[jk_ - 1] = ap_[ksj_ - 1];
  ap_[ksj_ - 1] = temp_;
  ksj_ = ksj_ - (j_ - 1);
}

if (kstep_ == 1) {
  goto _l210;
}
kskp1_ = ikp1_ + ks_;
temp_ = ap_[kskp1_ - 1];
ap_[kskp1_ - 1] = ap_[kkp1_ - 1];
ap_[kkp1_ - 1] = temp_;
_l210:;
_l220:;
ik_ = ik_ + k_;
if (kstep_ == 2) {
  ik_ = ik_ + k_ + 1;
}

k_ = k_ + kstep_;
goto _l120;
_l230:;
_l240:;
__calls[41].calls++;
return 0;
}

int_4 _cspfa (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 ij_, ijj_, ik_, ikm1_, im_, imax_, imaxp1_, imim_, imj_, imk_, j_, jj_, jk_, jkm1_, jmax_, jmim_, k_, kk_, 
  km1_, km1k_, km1km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_4 absakk_, alpha_, colmax_, rowmax_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, zdum_;
  int_4 $0_, $1_;
  extern int_4 _icamax ();
  alpha_ = 0.6403882;
  (*info_) = 0;
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (({complex_8 zdum__1_ = ap_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
  (*info_) = 1;
}

goto _l200;
_l20:;
km1_ = k_ - 1;
kk_ = ik_ + k_;
absakk_ = ({complex_8 zdum__1_ = ap_[kk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
imax_ = _icamax (($0_ = k_ - 1, &$0_), &ap_[ik_ + 1 - 1], &_k1);
imk_ = ik_ + imax_;
colmax_ = ({complex_8 zdum__1_ = ap_[imk_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
if (absakk_ < alpha_ * colmax_) {
  goto _l30;
}

kstep_ = 1;
swap_ = FALSE;
goto _l90;
_l30:;
rowmax_ = 0.0;
imaxp1_ = imax_ + 1;
im_ = imax_ * (imax_ - 1) / 2;
imj_ = im_ + 2 * imax_;
for (j_ = imaxp1_; j_ <= k_; (j_)++) {
  rowmax_ = _max (rowmax_, ({complex_8 zdum__1_ = ap_[imj_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));}));
  imj_ = imj_ + j_;
}

if (imax_ == 1) {
  goto _l50;
}

jmax_ = _icamax (($1_ = imax_ - 1, &$1_), &ap_[im_ + 1 - 1], &_k1);
jmim_ = jmax_ + im_;
rowmax_ = _max (rowmax_, ({complex_8 zdum__1_ = ap_[jmim_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}));
_l50:;
imim_ = imax_ + im_;
if (({complex_8 zdum__1_ = ap_[imim_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < alpha_ * 
rowmax_) {
goto _l60;
}

kstep_ = 1;
swap_ = TRUE;
goto _l80;
_l60:;
if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
  goto _l70;
}

kstep_ = 1;
swap_ = FALSE;
goto _l80;
_l70:;
kstep_ = 2;
swap_ = imax_ != km1_;
_l80:;
_l90:;
if (_max (absakk_, colmax_) != 0.0e0) {
  goto _l100;
}

kpvt_[k_ - 1] = k_;
(*info_) = k_;
goto _l190;
_l100:;
if (kstep_ == 2) {
  goto _l140;
}

if (! (swap_)) {
  goto _l120;
}

(void) _cswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
imj_ = ik_ + imax_;
for (jj_ = imax_; jj_ <= k_; (jj_)++) {
  j_ = k_ + imax_ - jj_;
  jk_ = ik_ + j_;
  t_ = ap_[jk_ - 1];
  ap_[jk_ - 1] = ap_[imj_ - 1];
  ap_[imj_ - 1] = t_;
  imj_ = imj_ - (j_ - 1);
}

_l120:;
ij_ = ik_ - (k_ - 1);
for (jj_ = 1; jj_ <= km1_; (jj_)++) {
  j_ = k_ - jj_;
  jk_ = ik_ + j_;
  mulk_ = -ap_[jk_ - 1] / ap_[kk_ - 1];
  t_ = mulk_;
  (void) _caxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  ijj_ = ij_ + j_;
  ap_[jk_ - 1] = mulk_;
  ij_ = ij_ - (j_ - 1);
}

kpvt_[k_ - 1] = k_;
if (swap_) {
  kpvt_[k_ - 1] = imax_;
}

goto _l190;
_l140:;
km1k_ = ik_ + k_ - 1;
ikm1_ = ik_ - (k_ - 1);
if (! (swap_)) {
  goto _l160;
}

(void) _cswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ikm1_ + 1 - 1], &_k1);
imj_ = ikm1_ + imax_;
for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
  j_ = km1_ + imax_ - jj_;
  jkm1_ = ikm1_ + j_;
  t_ = ap_[jkm1_ - 1];
  ap_[jkm1_ - 1] = ap_[imj_ - 1];
  ap_[imj_ - 1] = t_;
  imj_ = imj_ - (j_ - 1);
}

t_ = ap_[km1k_ - 1];
ap_[km1k_ - 1] = ap_[imk_ - 1];
ap_[imk_ - 1] = t_;
_l160:;
km2_ = k_ - 2;
if (km2_ == 0) {
  goto _l180;
}

ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
km1km1_ = ikm1_ + k_ - 1;
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
denom_ = 1.0e0 - ak_ * akm1_;
ij_ = ik_ - (k_ - 1) - (k_ - 2);
for (jj_ = 1; jj_ <= km2_; (jj_)++) {
  j_ = km1_ - jj_;
  jk_ = ik_ + j_;
  bk_ = ap_[jk_ - 1] / ap_[km1k_ - 1];
  jkm1_ = ikm1_ + j_;
  bkm1_ = ap_[jkm1_ - 1] / ap_[km1k_ - 1];
  mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
  mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
  t_ = mulk_;
  (void) _caxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  t_ = mulkm1_;
  (void) _caxpy (&j_, &t_, &ap_[ikm1_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  ap_[jk_ - 1] = mulk_;
  ap_[jkm1_ - 1] = mulkm1_;
  ijj_ = ij_ + j_;
  ij_ = ij_ - (j_ - 1);
}

_l180:;
kpvt_[k_ - 1] = 1 - k_;
if (swap_) {
  kpvt_[k_ - 1] = -imax_;
}

kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
_l190:;
ik_ = ik_ - (k_ - 1);
if (kstep_ == 2) {
  ik_ = ik_ - (k_ - 2);
}

k_ = k_ - kstep_;
goto _l10;
_l200:;
__calls[42].calls++;
return 0;
}

int_4 _cspsl (complex_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_8 _p_ b_)
{
  static int_4 ik_, ikm1_, ikp1_, k_, kk_, km1k_, km1km1_, kp_;
  static complex_8 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern complex_8 _cdotu ();
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  kk_ = ik_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _caxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
  k_ = k_ - 1;
  ik_ = ik_ - k_;
  goto _l70;
  _l40:;
  ikm1_ = ik_ - (k_ - 1);
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _caxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  (void) _caxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l60:;
  km1k_ = ik_ + k_ - 1;
  kk_ = ik_ + k_;
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  km1km1_ = ikm1_ + k_ - 1;
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = b_[k_ - 1] / ap_[km1k_ - 1];
  bkm1_ = b_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  ik_ = ik_ - (k_ + 1) - k_;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  ik_ = 0;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _cdotu (($3_ = k_ - 1, &$3_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  ik_ = ik_ + k_;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _cdotu (($4_ = k_ - 1, &$4_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  ikp1_ = ik_ + k_;
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _cdotu (($5_ = k_ - 1, &$5_), &ap_[ikp1_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  ik_ = ik_ + k_ + k_ + 1;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[43].calls++;
  return 0;
}

int_4 _csvdc (complex_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, complex_8 _p_ s_, complex_8 _p_ e_, 
complex_8 _p_ u_, int_4 _p_ ldu_, complex_8 _p_ v_, int_4 _p_ ldv_, complex_8 _p_ work_, int_4 _p_ job_, int_4 _p_ 
info_)
{
  static int_4 i_, iter_, j_, jobu_, k_, kase_, kk_, l_, ll_, lls_, lm1_, lp1_, ls_, lu_, m_, maxit_, mm_, mm1_, mp1_, 
  nct_, nctp1_, ncu_, nrt_, nrtp1_;
  static logical_4 wantu_, wantv_;
  static real_4 b_, c_, cs_, el_, emm1_, f_, g_, scale_, shift_, sl_, sm_, sn_, smm1_, t1_, test_, ztest_;
  static complex_8 t_, r_, zdum_, zdum1_, zdum2_;
  int_4 $0_, $1_, $3_, $4_, $5_, $6_, $8_, $9_, $11_, $12_, $13_, $15_, $16_;
  real_4 $17_, $18_;
  complex_8 $2_, $7_, $10_, $14_, $19_;
  extern complex_8 _cdotc ();
  extern real_4 _scnrm2 ();
  maxit_ = 30;
  wantu_ = FALSE;
  wantv_ = FALSE;
  jobu_ = _imod ((*job_), 100) / 10;
  ncu_ = (*n_);
  if (jobu_ > 1) {
    ncu_ = _min ((*n_), (*p_));
  }
  if (jobu_ != 0) {
    wantu_ = TRUE;
  }
  if (_imod ((*job_), 10) != 0) {
    wantv_ = TRUE;
  }
  (*info_) = 0;
  nct_ = _min ((*n_) - 1, (*p_));
  nrt_ = _max (0, _min ((*p_) - 2, (*n_)));
  lu_ = _max (nct_, nrt_);
  if (lu_ < 1) {
    goto _l170;
  }
  for (l_ = 1; l_ <= lu_; (l_)++) {
    lp1_ = l_ + 1;
    if (l_ > nct_) {
      goto _l20;
    }
    s_[l_ - 1] = CMPLXF (_scnrm2 (($0_ = (*n_) - l_ + 1, &$0_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1), 0.0);
    if (({complex_8 zdum__1_ = s_[l_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
    goto _l10;
  }
  if (({complex_8 zdum__1_ = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));}) != 0.0e0) {
  s_[l_ - 1] = ({complex_8 zdum1__1_ = s_[l_ - 1]; complex_8 zdum2__1_ = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]; cabsf 
  (zdum1__1_) * (zdum2__1_ / cabsf (zdum2__1_));});
}

(void) _cscal (($1_ = (*n_) - l_ + 1, &$1_), ($2_ = 1.0e0 / s_[l_ - 1], &$2_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], 
&_k1);
x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = CMPLXF (1.0, 0.0) + x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
_l10:;
s_[l_ - 1] = -s_[l_ - 1];
_l20:;
if ((*p_) < lp1_) {
  goto _l50;
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  if (l_ > nct_) {
    goto _l30;
  }
  if (({complex_8 zdum__1_ = s_[l_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
  goto _l30;
}

t_ = -_cdotc (($3_ = (*n_) - l_ + 1, &$3_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * ((j_ - 
1))], &_k1) / x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
(void) _caxpy (($4_ = (*n_) - l_ + 1, &$4_), &t_, &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * 
((j_ - 1))], &_k1);
_l30:;
e_[j_ - 1] = conjf (x_[l_ - 1 + ((*ldx_)) * ((j_ - 1))]);
}

_l50:;
if (! (wantu_) || l_ > nct_) {
  goto _l70;
}

for (i_ = l_; i_ <= (*n_); (i_)++) {
  u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((l_ - 1))];
}

_l70:;
if (l_ > nrt_) {
  goto _l150;
}

e_[l_ - 1] = CMPLXF (_scnrm2 (($5_ = (*p_) - l_, &$5_), &e_[lp1_ - 1], &_k1), 0.0);
if (({complex_8 zdum__1_ = e_[l_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
goto _l80;
}

if (({complex_8 zdum__1_ = e_[lp1_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
e_[l_ - 1] = ({complex_8 zdum1__1_ = e_[l_ - 1]; complex_8 zdum2__1_ = e_[lp1_ - 1]; cabsf (zdum1__1_) * (zdum2__1_ / 
cabsf (zdum2__1_));});
}

(void) _cscal (($6_ = (*p_) - l_, &$6_), ($7_ = 1.0e0 / e_[l_ - 1], &$7_), &e_[lp1_ - 1], &_k1);
e_[lp1_ - 1] = CMPLXF (1.0, 0.0) + e_[lp1_ - 1];
_l80:;
e_[l_ - 1] = -conjf (e_[l_ - 1]);
if (lp1_ > (*n_) || ({complex_8 zdum__1_ = e_[l_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
goto _l120;
}

for (i_ = lp1_; i_ <= (*n_); (i_)++) {
  work_[i_ - 1] = CMPLXF (0.0, 0.0);
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  (void) _caxpy (($8_ = (*n_) - l_, &$8_), &e_[j_ - 1], &x_[lp1_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &work_[lp1_ - 1], 
  &_k1);
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  (void) _caxpy (($9_ = (*n_) - l_, &$9_), ($10_ = conjf (-e_[j_ - 1] / e_[lp1_ - 1]), &$10_), &work_[lp1_ - 1], &_k1, 
  &x_[lp1_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1);
}

_l120:;
if (! (wantv_)) {
  goto _l140;
}

for (i_ = lp1_; i_ <= (*p_); (i_)++) {
  v_[i_ - 1 + ((*ldv_)) * ((l_ - 1))] = e_[i_ - 1];
}

_l140:;
_l150:;
}

_l170:;
m_ = _min ((*p_), (*n_) + 1);
nctp1_ = nct_ + 1;
nrtp1_ = nrt_ + 1;
if (nct_ < (*p_)) {
  s_[nctp1_ - 1] = x_[nctp1_ - 1 + ((*ldx_)) * ((nctp1_ - 1))];
}

if ((*n_) < m_) {
  s_[m_ - 1] = CMPLXF (0.0, 0.0);
}

if (nrtp1_ < m_) {
  e_[nrtp1_ - 1] = x_[nrtp1_ - 1 + ((*ldx_)) * ((m_ - 1))];
}

e_[m_ - 1] = CMPLXF (0.0, 0.0);
if (! (wantu_)) {
  goto _l300;
}

if (ncu_ < nctp1_) {
  goto _l200;
}

for (j_ = nctp1_; j_ <= ncu_; (j_)++) {
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    u_[i_ - 1 + ((*ldu_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
  }
  u_[j_ - 1 + ((*ldu_)) * ((j_ - 1))] = CMPLXF (1.0, 0.0);
}

_l200:;
if (nct_ < 1) {
  goto _l290;
}
for (ll_ = 1; ll_ <= nct_; (ll_)++) {
  l_ = nct_ - ll_ + 1;
  if (({complex_8 zdum__1_ = s_[l_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
  goto _l250;
}

lp1_ = l_ + 1;
if (ncu_ < lp1_) {
  goto _l220;
}

for (j_ = lp1_; j_ <= ncu_; (j_)++) {
  t_ = -_cdotc (($11_ = (*n_) - l_ + 1, &$11_), &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[l_ - 1 + ((*ldu_)) * ((j_ 
  - 1))], &_k1) / u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))];
  (void) _caxpy (($12_ = (*n_) - l_ + 1, &$12_), &t_, &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[l_ - 1 + ((*ldu_)) 
  * ((j_ - 1))], &_k1);
}

_l220:;
(void) _cscal (($13_ = (*n_) - l_ + 1, &$13_), ($14_ = CMPLXF (-1.0, 0.0), &$14_), &u_[l_ - 1 + ((*ldu_)) * ((l_ - 
1))], &_k1);
u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))] = CMPLXF (1.0, 0.0) + u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))];
lm1_ = l_ - 1;
if (lm1_ < 1) {
  goto _l240;
}

for (i_ = 1; i_ <= lm1_; (i_)++) {
  u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = CMPLXF (0.0, 0.0);
}

_l240:;
goto _l270;
_l250:;
for (i_ = 1; i_ <= (*n_); (i_)++) {
  u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = CMPLXF (0.0, 0.0);
}

u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))] = CMPLXF (1.0, 0.0);
_l270:;
}

_l290:;
_l300:;
if (! (wantv_)) {
  goto _l350;
}

for (ll_ = 1; ll_ <= (*p_); (ll_)++) {
  l_ = (*p_) - ll_ + 1;
  lp1_ = l_ + 1;
  if (l_ > nrt_) {
    goto _l320;
  }
  if (({complex_8 zdum__1_ = e_[l_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
  goto _l320;
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  t_ = -_cdotc (($15_ = (*p_) - l_, &$15_), &v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[lp1_ - 1 + ((*ldv_)) * ((j_ 
  - 1))], &_k1) / v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))];
  (void) _caxpy (($16_ = (*p_) - l_, &$16_), &t_, &v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[lp1_ - 1 + ((*ldv_)) 
  * ((j_ - 1))], &_k1);
}

_l320:;
for (i_ = 1; i_ <= (*p_); (i_)++) {
  v_[i_ - 1 + ((*ldv_)) * ((l_ - 1))] = CMPLXF (0.0, 0.0);
}

v_[l_ - 1 + ((*ldv_)) * ((l_ - 1))] = CMPLXF (1.0, 0.0);
}

_l350:;
for (i_ = 1; i_ <= m_; (i_)++) {
  if (({complex_8 zdum__1_ = s_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
  goto _l360;
}

t_ = CMPLXF (cabsf (s_[i_ - 1]), 0.0);
r_ = s_[i_ - 1] / t_;
s_[i_ - 1] = t_;
if (i_ < m_) {
  e_[i_ - 1] = e_[i_ - 1] / r_;
}

if (wantu_) {
  (void) _cscal (n_, &r_, &u_[0 + ((*ldu_)) * ((i_ - 1))], &_k1);
}

_l360:;
if (i_ == m_) {
  goto _l390;
}

if (({complex_8 zdum__1_ = e_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
goto _l370;
}

t_ = CMPLXF (cabsf (e_[i_ - 1]), 0.0);
r_ = t_ / e_[i_ - 1];
e_[i_ - 1] = t_;
s_[i_ + 1 - 1] = s_[i_ + 1 - 1] * r_;
if (wantv_) {
  (void) _cscal (p_, &r_, &v_[0 + ((*ldv_)) * ((i_ + 1 - 1))], &_k1);
}

_l370:;
}

_l390:;
mm_ = m_;
iter_ = 0;
_l400:;
if (m_ == 0) {
  goto _l660;
}

if (iter_ < maxit_) {
  goto _l410;
}

(*info_) = m_;
goto _l660;
_l410:;
for (ll_ = 1; ll_ <= m_; (ll_)++) {
  l_ = m_ - ll_;
  if (l_ == 0) {
    goto _l440;
  }
  test_ = cabsf (s_[l_ - 1]) + cabsf (s_[l_ + 1 - 1]);
  ztest_ = test_ + cabsf (e_[l_ - 1]);
  if (ztest_ != test_) {
    goto _l420;
  }
  e_[l_ - 1] = CMPLXF (0.0, 0.0);
  goto _l440;
  _l420:;
}

_l440:;
if (l_ != m_ - 1) {
  goto _l450;
}

kase_ = 4;
goto _l520;
_l450:;
lp1_ = l_ + 1;
mp1_ = m_ + 1;
for (lls_ = lp1_; lls_ <= mp1_; (lls_)++) {
  ls_ = m_ - lls_ + lp1_;
  if (ls_ == l_) {
    goto _l480;
  }
  test_ = 0.0;
  if (ls_ != m_) {
    test_ = test_ + cabsf (e_[ls_ - 1]);
  }
  if (ls_ != l_ + 1) {
    test_ = test_ + cabsf (e_[ls_ - 1 - 1]);
  }
  ztest_ = test_ + cabsf (s_[ls_ - 1]);
  if (ztest_ != test_) {
    goto _l460;
  }
  s_[ls_ - 1] = CMPLXF (0.0, 0.0);
  goto _l480;
  _l460:;
}

_l480:;
if (ls_ != l_) {
  goto _l490;
}

kase_ = 3;
goto _l510;
_l490:;
if (ls_ != m_) {
  goto _l500;
}

kase_ = 1;
goto _l510;
_l500:;
kase_ = 2;
l_ = ls_;
_l510:;
_l520:;
l_ = l_ + 1;
switch (kase_) {
  default:
  case 1: goto _l530;
  case 2: goto _l560;
  case 3: goto _l580;
  case 4: goto _l610;
}

_l530:;
mm1_ = m_ - 1;
f_ = (real_4) (crealf (e_[m_ - 1 - 1]));
e_[m_ - 1 - 1] = CMPLXF (0.0, 0.0);
for (kk_ = l_; kk_ <= mm1_; (kk_)++) {
  k_ = mm1_ - kk_ + l_;
  t1_ = (real_4) (crealf (s_[k_ - 1]));
  (void) _srotg (&t1_, &f_, &cs_, &sn_);
  s_[k_ - 1] = CMPLXF (t1_, 0.0);
  if (k_ == l_) {
    goto _l540;
  }
  f_ = -sn_ * (real_4) (crealf (e_[k_ - 1 - 1]));
  e_[k_ - 1 - 1] = cs_ * e_[k_ - 1 - 1];
  _l540:;
  if (wantv_) {
    (void) _csrot (p_, &v_[0 + ((*ldv_)) * ((k_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((m_ - 1))], &_k1, &cs_, &sn_);
  }
}

goto _l650;
_l560:;
f_ = (real_4) (crealf (e_[l_ - 1 - 1]));
e_[l_ - 1 - 1] = CMPLXF (0.0, 0.0);
for (k_ = l_; k_ <= m_; (k_)++) {
  t1_ = (real_4) (crealf (s_[k_ - 1]));
  (void) _srotg (&t1_, &f_, &cs_, &sn_);
  s_[k_ - 1] = CMPLXF (t1_, 0.0);
  f_ = -sn_ * (real_4) (crealf (e_[k_ - 1]));
  e_[k_ - 1] = cs_ * e_[k_ - 1];
  if (wantu_) {
    (void) _csrot (n_, &u_[0 + ((*ldu_)) * ((k_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((l_ - 1 - 1))], &_k1, &cs_, &sn_);
  }
}

goto _l650;
_l580:;
scale_ = ($17_ = _max (cabsf (s_[m_ - 1]), cabsf (s_[m_ - 1 - 1])), $17_ = _max ($17_, cabsf (e_[m_ - 1 - 1])), $17_ = 
_max ($17_, cabsf (s_[l_ - 1])), _max ($17_, cabsf (e_[l_ - 1])));
sm_ = (real_4) (crealf (s_[m_ - 1])) / scale_;
smm1_ = (real_4) (crealf (s_[m_ - 1 - 1])) / scale_;
emm1_ = (real_4) (crealf (e_[m_ - 1 - 1])) / scale_;
sl_ = (real_4) (crealf (s_[l_ - 1])) / scale_;
el_ = (real_4) (crealf (e_[l_ - 1])) / scale_;
b_ = ((smm1_ + sm_) * (smm1_ - sm_) + (emm1_ * emm1_)) / 2.0e0;
c_ = ($18_ = (sm_ * emm1_), $18_ * $18_);
shift_ = 0.0;
if (b_ == 0.0e0 && c_ == 0.0e0) {
  goto _l590;
}

shift_ = sqrtf ((b_ * b_) + c_);
if (b_ < 0.0e0) {
  shift_ = -shift_;
}

shift_ = c_ / (b_ + shift_);
_l590:;
f_ = (sl_ + sm_) * (sl_ - sm_) + shift_;
g_ = sl_ * el_;
mm1_ = m_ - 1;
for (k_ = l_; k_ <= mm1_; (k_)++) {
  (void) _srotg (&f_, &g_, &cs_, &sn_);
  if (k_ != l_) {
    e_[k_ - 1 - 1] = CMPLXF (f_, 0.0);
  }
  f_ = cs_ * (real_4) (crealf (s_[k_ - 1])) + sn_ * (real_4) (crealf (e_[k_ - 1]));
  e_[k_ - 1] = cs_ * e_[k_ - 1] - sn_ * s_[k_ - 1];
  g_ = sn_ * (real_4) (crealf (s_[k_ + 1 - 1]));
  s_[k_ + 1 - 1] = cs_ * s_[k_ + 1 - 1];
  if (wantv_) {
    (void) _csrot (p_, &v_[0 + ((*ldv_)) * ((k_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((k_ + 1 - 1))], &_k1, &cs_, &sn_);
  }
  (void) _srotg (&f_, &g_, &cs_, &sn_);
  s_[k_ - 1] = CMPLXF (f_, 0.0);
  f_ = cs_ * (real_4) (crealf (e_[k_ - 1])) + sn_ * (real_4) (crealf (s_[k_ + 1 - 1]));
  s_[k_ + 1 - 1] = -sn_ * e_[k_ - 1] + cs_ * s_[k_ + 1 - 1];
  g_ = sn_ * (real_4) (crealf (e_[k_ + 1 - 1]));
  e_[k_ + 1 - 1] = cs_ * e_[k_ + 1 - 1];
  if (wantu_ && k_ < (*n_)) {
    (void) _csrot (n_, &u_[0 + ((*ldu_)) * ((k_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((k_ + 1 - 1))], &_k1, &cs_, &sn_);
  }
}

e_[m_ - 1 - 1] = CMPLXF (f_, 0.0);
iter_ = iter_ + 1;
goto _l650;
_l610:;
if ((real_4) (crealf (s_[l_ - 1])) >= 0.0e0) {
  goto _l620;
}

s_[l_ - 1] = -s_[l_ - 1];
if (wantv_) {
  (void) _cscal (p_, ($19_ = CMPLXF (-1.0, 0.0), &$19_), &v_[0 + ((*ldv_)) * ((l_ - 1))], &_k1);
}

_l620:;
_l630:;
if (l_ == mm_) {
  goto _l640;
}

if ((real_4) (crealf (s_[l_ - 1])) >= (real_4) (crealf (s_[l_ + 1 - 1]))) {
  goto _l640;
}

t_ = s_[l_ - 1];
s_[l_ - 1] = s_[l_ + 1 - 1];
s_[l_ + 1 - 1] = t_;
if (wantv_ && l_ < (*p_)) {
  (void) _cswap (p_, &v_[0 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((l_ + 1 - 1))], &_k1);
}

if (wantu_ && l_ < (*n_)) {
  (void) _cswap (n_, &u_[0 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((l_ + 1 - 1))], &_k1);
}

l_ = l_ + 1;
goto _l630;
_l640:;
iter_ = 0;
m_ = m_ - 1;
_l650:;
goto _l400;
_l660:;
__calls[44].calls++;
return 0;
}

int_4 _ctrco (complex_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_4 _p_ rcond_, complex_8 _p_ z_, int_4 _p_ job_)
{
  static int_4 i1_, j_, j1_, j2_, k_, kk_, l_;
  static logical_4 lower_;
  static real_4 tnorm_, ynorm_, s_, sm_;
  static complex_8 w_, wk_, wkm_, ek_, zdum_, zdum1_, zdum2_;
  int_4 $0_;
  extern real_4 _scasum ();
  lower_ = (*job_) == 0;
  tnorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = j_;
    if (lower_) {
      l_ = (*n_) + 1 - j_;
    }
    i1_ = 1;
    if (lower_) {
      i1_ = j_;
    }
    tnorm_ = _max (tnorm_, _scasum (&l_, &t_[i1_ - 1 + ((*ldt_)) * ((j_ - 1))], &_k1));
  }
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
    k_ = kk_;
    if (lower_) {
      k_ = (*n_) + 1 - kk_;
    }
    if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_8 zdum1__1_ = ek_; complex_8 zdum2__1_ = -z_[k_ - 1]; ({complex_8 zdum__2_ = zdum1__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
  }
  if (({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 
  ({complex_8 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));})) {
  goto _l30;
}

s_ = ({complex_8 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l30:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_8 zdum__1_ = wk_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
sm_ = ({complex_8 zdum__1_ = wkm_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
if (({complex_8 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
goto _l40;
}

wk_ = wk_ / conjf (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]);
wkm_ = wkm_ / conjf (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]);
goto _l50;
_l40:;
wk_ = CMPLXF (1.0, 0.0);
wkm_ = CMPLXF (1.0, 0.0);
_l50:;
if (kk_ == (*n_)) {
  goto _l90;
}

j1_ = k_ + 1;
if (lower_) {
  j1_ = 1;
}

j2_ = (*n_);
if (lower_) {
  j2_ = k_ - 1;
}

for (j_ = j1_; j_ <= j2_; (j_)++) {
  sm_ = sm_ + ({complex_8 zdum__1_ = z_[j_ - 1] + wkm_ * conjf (t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))]); _abs ((real_4) 
  (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conjf (t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_8 zdum__1_ = z_[j_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l80;
}

w_ = wkm_ - wk_;
wk_ = wkm_;
for (j_ = j1_; j_ <= j2_; (j_)++) {
  z_[j_ - 1] = z_[j_ - 1] + w_ * conjf (t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))]);
}

_l80:;
_l90:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
  k_ = (*n_) + 1 - kk_;
  if (lower_) {
    k_ = kk_;
  }
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
  zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) {
  goto _l110;
}

s_ = ({complex_8 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l110:;
if (({complex_8 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
}

if (({complex_8 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLXF (1.0, 0.0);
}

i1_ = 1;
if (lower_) {
  i1_ = k_ + 1;
}

if (kk_ >= (*n_)) {
  goto _l120;
}

w_ = -z_[k_ - 1];
(void) _caxpy (($0_ = (*n_) - kk_, &$0_), &w_, &t_[i1_ - 1 + ((*ldt_)) * ((k_ - 1))], &_k1, &z_[i1_ - 1], &_k1);
_l120:;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (tnorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / tnorm_;
}

if (tnorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[45].calls++;
return 0;
}

int_4 _ctrdi (complex_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, complex_8 _p_ det_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, j_, k_, kb_, km1_, kp1_;
  static real_4 ten_;
  static complex_8 temp_, zdum_;
  int_4 $0_, $1_, $2_;
  if ((*job_) / 100 == 0) {
    goto _l70;
  }
  det_[0] = CMPLXF (1.0, 0.0);
  det_[1] = CMPLXF (0.0, 0.0);
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = t_[i_ - 1 + ((*ldt_)) * ((i_ - 1))] * det_[0];
    if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
    goto _l60;
  }
  _l10:;
  if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) >= 1.0e0) {
  goto _l20;
}

det_[0] = CMPLXF (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLXF (1.0, 0.0);
goto _l10;
_l20:;
_l30:;
if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < ten_) {
goto _l40;
}

det_[0] = det_[0] / CMPLXF (ten_, 0.0);
det_[1] = det_[1] + CMPLXF (1.0, 0.0);
goto _l30;
_l40:;
}

_l60:;
_l70:;
if (_imod ((*job_) / 10, 10) == 0) {
  goto _l170;
}

if (_imod ((*job_), 10) == 0) {
  goto _l120;
}

for (k_ = 1; k_ <= (*n_); (k_)++) {
  (*info_) = k_;
  if (({complex_8 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));}) == 0.0e0) {
  goto _l110;
}

t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = CMPLXF (1.0, 0.0) / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
temp_ = -t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
(void) _cscal (($0_ = k_ - 1, &$0_), &temp_, &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1);
kp1_ = k_ + 1;
if ((*n_) < kp1_) {
  goto _l90;
}

for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  temp_ = t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
  t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
  (void) _caxpy (&k_, &temp_, &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1);
}

_l90:;
}

(*info_) = 0;
_l110:;
goto _l160;
_l120:;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  (*info_) = k_;
  if (({complex_8 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));}) == 0.0e0) {
  goto _l180;
}

t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = CMPLXF (1.0, 0.0) / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
temp_ = -t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
if (k_ != (*n_)) {
  (void) _cscal (($1_ = (*n_) - k_, &$1_), &temp_, &t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))], &_k1);
}

km1_ = k_ - 1;
if (km1_ < 1) {
  goto _l140;
}

for (j_ = 1; j_ <= km1_; (j_)++) {
  temp_ = t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
  t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
  (void) _caxpy (($2_ = (*n_) - k_ + 1, &$2_), &temp_, &t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[k_ - 1 + ((*ldt_)) 
  * ((j_ - 1))], &_k1);
}

_l140:;
}

(*info_) = 0;
_l160:;
_l170:;
_l180:;
__calls[46].calls++;
return 0;
}

int_4 _ctrsl (complex_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, complex_8 _p_ b_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 case_, j_, jj_;
  static complex_8 temp_, zdum_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotc ();
  for ((*info_) = 1; (*info_) <= (*n_); ((*info_))++) {
    if (({complex_8 zdum__1_ = t_[(*info_) - 1 + ((*ldt_)) * (((*info_) - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
    (cimagf (zdum__1_));}) == 0.0e0) {
    goto _l150;
  }
}

(*info_) = 0;
case_ = 1;
if (_imod ((*job_), 10) != 0) {
  case_ = 2;
}

if (_imod ((*job_), 100) / 10 != 0) {
  case_ = case_ + 2;
}

switch (case_) {
  default:
  case 1: goto _l20;
  case 2: goto _l50;
  case 3: goto _l80;
  case 4: goto _l110;
}

_l20:;
b_[0] = b_[0] / t_[0 + ((*ldt_)) * ((0))];
if ((*n_) < 2) {
  goto _l40;
}

for (j_ = 2; j_ <= (*n_); (j_)++) {
  temp_ = -b_[j_ - 1 - 1];
  (void) _caxpy (($0_ = (*n_) - j_ + 1, &$0_), &temp_, &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &b_[j_ - 1], &_k1)
  ;
  b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
}

_l40:;
goto _l140;
_l50:;
b_[(*n_) - 1] = b_[(*n_) - 1] / t_[(*n_) - 1 + ((*ldt_)) * (((*n_) - 1))];
if ((*n_) < 2) {
  goto _l70;
}

for (jj_ = 2; jj_ <= (*n_); (jj_)++) {
  j_ = (*n_) - jj_ + 1;
  temp_ = -b_[j_ + 1 - 1];
  (void) _caxpy (&j_, &temp_, &t_[0 + ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &b_[0], &_k1);
  b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
}

_l70:;
goto _l140;
_l80:;
b_[(*n_) - 1] = b_[(*n_) - 1] / conjf (t_[(*n_) - 1 + ((*ldt_)) * (((*n_) - 1))]);
if ((*n_) < 2) {
  goto _l100;
}

for (jj_ = 2; jj_ <= (*n_); (jj_)++) {
  j_ = (*n_) - jj_ + 1;
  b_[j_ - 1] = b_[j_ - 1] - _cdotc (($1_ = jj_ - 1, &$1_), &t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))], &_k1, &b_[j_ + 1 - 
  1], &_k1);
  b_[j_ - 1] = b_[j_ - 1] / conjf (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))]);
}

_l100:;
goto _l140;
_l110:;
b_[0] = b_[0] / conjf (t_[0 + ((*ldt_)) * ((0))]);
if ((*n_) < 2) {
  goto _l130;
}

for (j_ = 2; j_ <= (*n_); (j_)++) {
  b_[j_ - 1] = b_[j_ - 1] - _cdotc (($2_ = j_ - 1, &$2_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &b_[0], &_k1);
  b_[j_ - 1] = b_[j_ - 1] / conjf (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))]);
}

_l130:;
_l140:;
_l150:;
__calls[47].calls++;
return 0;
}

int_4 _dchdc (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ p_, real_8 _p_ work_, int_4 _p_ jpvt_, int_4 _p_ job_, int_4 _p_ 
info_)
{
  static int_4 pu_, pl_, plp1_, i_, j_, jp_, jt_, k_, kb_, km1_, kp1_, l_, maxl_;
  static logical_4 swapk_, negk_;
  static real_8 temp_, maxdia_;
  int_4 $0_, $1_, $2_;
  pl_ = 1;
  pu_ = 0;
  (*info_) = (*p_);
  if ((*job_) == 0) {
    goto _l160;
  }
  for (k_ = 1; k_ <= (*p_); (k_)++) {
    swapk_ = jpvt_[k_ - 1] > 0;
    negk_ = jpvt_[k_ - 1] < 0;
    jpvt_[k_ - 1] = k_;
    if (negk_) {
      jpvt_[k_ - 1] = -jpvt_[k_ - 1];
    }
    if (! (swapk_)) {
      goto _l60;
    }
    if (k_ == pl_) {
      goto _l50;
    }
    (void) _dswap (($0_ = pl_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((pl_ - 1))], &_k1);
    temp_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[pl_ - 1 + ((*lda_)) * ((pl_ - 1))];
    a_[pl_ - 1 + ((*lda_)) * ((pl_ - 1))] = temp_;
    plp1_ = pl_ + 1;
    if ((*p_) < plp1_) {
      goto _l40;
    }
    for (j_ = plp1_; j_ <= (*p_); (j_)++) {
      if (j_ >= k_) {
        goto _l10;
      }
      temp_ = a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
      a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = temp_;
      goto _l20;
      _l10:;
      if (j_ == k_) {
        goto _l20;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l20:;
    }
    _l40:;
    jpvt_[k_ - 1] = jpvt_[pl_ - 1];
    jpvt_[pl_ - 1] = k_;
    _l50:;
    pl_ = pl_ + 1;
    _l60:;
  }
  pu_ = (*p_);
  if ((*p_) < pl_) {
    goto _l150;
  }
  for (kb_ = pl_; kb_ <= (*p_); (kb_)++) {
    k_ = (*p_) - kb_ + pl_;
    if (jpvt_[k_ - 1] >= 0) {
      goto _l130;
    }
    jpvt_[k_ - 1] = -jpvt_[k_ - 1];
    if (pu_ == k_) {
      goto _l120;
    }
    (void) _dswap (($1_ = k_ - 1, &$1_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((pu_ - 1))], &_k1);
    temp_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[pu_ - 1 + ((*lda_)) * ((pu_ - 1))];
    a_[pu_ - 1 + ((*lda_)) * ((pu_ - 1))] = temp_;
    kp1_ = k_ + 1;
    if ((*p_) < kp1_) {
      goto _l110;
    }
    for (j_ = kp1_; j_ <= (*p_); (j_)++) {
      if (j_ >= pu_) {
        goto _l80;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[j_ - 1 + ((*lda_)) * ((pu_ - 1))];
      a_[j_ - 1 + ((*lda_)) * ((pu_ - 1))] = temp_;
      goto _l90;
      _l80:;
      if (j_ == pu_) {
        goto _l90;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[pu_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pu_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l90:;
    }
    _l110:;
    jt_ = jpvt_[k_ - 1];
    jpvt_[k_ - 1] = jpvt_[pu_ - 1];
    jpvt_[pu_ - 1] = jt_;
    _l120:;
    pu_ = pu_ - 1;
    _l130:;
  }
  _l150:;
  _l160:;
  for (k_ = 1; k_ <= (*p_); (k_)++) {
    maxdia_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    kp1_ = k_ + 1;
    maxl_ = k_;
    if (k_ < pl_ || k_ >= pu_) {
      goto _l190;
    }
    for (l_ = kp1_; l_ <= pu_; (l_)++) {
      if (a_[l_ - 1 + ((*lda_)) * ((l_ - 1))] <= maxdia_) {
        goto _l170;
      }
      maxdia_ = a_[l_ - 1 + ((*lda_)) * ((l_ - 1))];
      maxl_ = l_;
      _l170:;
    }
    _l190:;
    if (maxdia_ > 0.0e0) {
      goto _l200;
    }
    (*info_) = k_ - 1;
    goto _l280;
    _l200:;
    if (k_ == maxl_) {
      goto _l210;
    }
    km1_ = k_ - 1;
    (void) _dswap (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((maxl_ - 1))], &_k1);
    a_[maxl_ - 1 + ((*lda_)) * ((maxl_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = maxdia_;
    jp_ = jpvt_[maxl_ - 1];
    jpvt_[maxl_ - 1] = jpvt_[k_ - 1];
    jpvt_[k_ - 1] = jp_;
    _l210:;
    work_[k_ - 1] = sqrt (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = work_[k_ - 1];
    if ((*p_) < kp1_) {
      goto _l260;
    }
    for (j_ = kp1_; j_ <= (*p_); (j_)++) {
      if (k_ == maxl_) {
        goto _l240;
      }
      if (j_ >= maxl_) {
        goto _l220;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[j_ - 1 + ((*lda_)) * ((maxl_ - 1))];
      a_[j_ - 1 + ((*lda_)) * ((maxl_ - 1))] = temp_;
      goto _l230;
      _l220:;
      if (j_ == maxl_) {
        goto _l230;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[maxl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[maxl_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l230:;
      _l240:;
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] / work_[k_ - 1];
      work_[j_ - 1] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      temp_ = -a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      (void) _daxpy (($2_ = j_ - k_, &$2_), &temp_, &work_[kp1_ - 1], &_k1, &a_[kp1_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l260:;
  }
  _l280:;
  __calls[48].calls++;
  return 0;
}

int_4 _dchdd (real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, real_8 _p_ x_, real_8 _p_ z_, int_4 _p_ ldz_, int_4 _p_ nz_, 
real_8 _p_ y_, real_8 _p_ rho_, real_8 _p_ c_, real_8 _p_ s_, int_4 _p_ info_)
{
  static int_4 i_, ii_, j_;
  static real_4 scale_;
  static real_8 a_, alpha_, azeta_, norm_, t_, zeta_, b_, xx_;
  int_4 $0_;
  real_8 $1_;
  extern real_8 _dnrm2 ();
  extern real_8 _ddot ();
  (*info_) = 0;
  s_[0] = x_[0] / r_[0 + ((*ldr_)) * ((0))];
  if ((*p_) < 2) {
    goto _l20;
  }
  for (j_ = 2; j_ <= (*p_); (j_)++) {
    s_[j_ - 1] = x_[j_ - 1] - _ddot (($0_ = j_ - 1, &$0_), &r_[0 + ((*ldr_)) * ((j_ - 1))], &_k1, s_, &_k1);
    s_[j_ - 1] = s_[j_ - 1] / r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))];
  }
  _l20:;
  norm_ = _dnrm2 (p_, s_, &_k1);
  if (norm_ < 1.0e0) {
    goto _l30;
  }
  (*info_) = -1;
  goto _l120;
  _l30:;
  alpha_ = sqrt (1.0e0 - (norm_ * norm_));
  for (ii_ = 1; ii_ <= (*p_); (ii_)++) {
    i_ = (*p_) - ii_ + 1;
    scale_ = alpha_ + _abs (s_[i_ - 1]);
    a_ = alpha_ / scale_;
    b_ = s_[i_ - 1] / scale_;
    norm_ = sqrt ((a_ * a_) + (b_ * b_) + (0.0e0 * 0.0e0));
    c_[i_ - 1] = a_ / norm_;
    s_[i_ - 1] = b_ / norm_;
    alpha_ = scale_ * norm_;
  }
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    xx_ = 0.0;
    for (ii_ = 1; ii_ <= j_; (ii_)++) {
      i_ = j_ - ii_ + 1;
      t_ = c_[i_ - 1] * xx_ + s_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = c_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] - s_[i_ - 1] * xx_;
      xx_ = t_;
    }
  }
  if ((*nz_) < 1) {
    goto _l110;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    zeta_ = y_[j_ - 1];
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = (z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] - s_[i_ - 1] * zeta_) / c_[i_ - 1];
      zeta_ = c_[i_ - 1] * zeta_ - s_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
    }
    azeta_ = _abs (zeta_);
    if (azeta_ <= rho_[j_ - 1]) {
      goto _l80;
    }
    (*info_) = 1;
    rho_[j_ - 1] = -1.0;
    goto _l90;
    _l80:;
    rho_[j_ - 1] = rho_[j_ - 1] * sqrt (1.0e0 - ($1_ = (azeta_ / rho_[j_ - 1]), $1_ * $1_));
    _l90:;
  }
  _l110:;
  _l120:;
  __calls[49].calls++;
  return 0;
}

int_4 _dchex (real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, int_4 _p_ k_, int_4 _p_ l_, real_8 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ nz_, real_8 _p_ c_, real_8 _p_ s_, int_4 _p_ job_)
{
  static int_4 i_, ii_, il_, iu_, j_, jj_, km1_, kp1_, lmk_, lm1_;
  static real_8 rjp1j_, t_;
  km1_ = (*k_) - 1;
  kp1_ = (*k_) + 1;
  lmk_ = (*l_) - (*k_);
  lm1_ = (*l_) - 1;
  switch ((*job_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l130;
  }
  _l10:;
  for (i_ = 1; i_ <= (*l_); (i_)++) {
    ii_ = (*l_) - i_ + 1;
    s_[i_ - 1] = r_[ii_ - 1 + ((*ldr_)) * (((*l_) - 1))];
  }
  for (jj_ = (*k_); jj_ <= lm1_; (jj_)++) {
    j_ = lm1_ - jj_ + (*k_);
    for (i_ = 1; i_ <= j_; (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ + 1 - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
    }
    r_[j_ + 1 - 1 + ((*ldr_)) * ((j_ + 1 - 1))] = 0.0;
  }
  if ((*k_) == 1) {
    goto _l60;
  }
  for (i_ = 1; i_ <= km1_; (i_)++) {
    ii_ = (*l_) - i_ + 1;
    r_[i_ - 1 + ((*ldr_)) * (((*k_) - 1))] = s_[ii_ - 1];
  }
  _l60:;
  t_ = s_[0];
  for (i_ = 1; i_ <= lmk_; (i_)++) {
    (void) _drotg (&s_[i_ + 1 - 1], &t_, &c_[i_ - 1], &s_[i_ - 1]);
    t_ = s_[i_ + 1 - 1];
  }
  r_[(*k_) - 1 + ((*ldr_)) * (((*k_) - 1))] = t_;
  for (j_ = kp1_; j_ <= (*p_); (j_)++) {
    il_ = _max (1, (*l_) - j_ + 1);
    for (ii_ = il_; ii_ <= lmk_; (ii_)++) {
      i_ = (*l_) - ii_;
      t_ = c_[ii_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] = c_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] - s_[ii_ - 1] * r_[i_ - 
      1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
  }
  if ((*nz_) < 1) {
    goto _l120;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    for (ii_ = 1; ii_ <= lmk_; (ii_)++) {
      i_ = (*l_) - ii_;
      t_ = c_[ii_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] = c_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] - s_[ii_ - 1] * z_[i_ - 
      1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
  }
  _l120:;
  goto _l260;
  _l130:;
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    ii_ = lmk_ + i_;
    s_[ii_ - 1] = r_[i_ - 1 + ((*ldr_)) * (((*k_) - 1))];
  }
  for (j_ = (*k_); j_ <= lm1_; (j_)++) {
    for (i_ = 1; i_ <= j_; (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ + 1 - 1))];
    }
    jj_ = j_ - km1_;
    s_[jj_ - 1] = r_[j_ + 1 - 1 + ((*ldr_)) * ((j_ + 1 - 1))];
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    ii_ = lmk_ + i_;
    r_[i_ - 1 + ((*ldr_)) * (((*l_) - 1))] = s_[ii_ - 1];
  }
  for (i_ = kp1_; i_ <= (*l_); (i_)++) {
    r_[i_ - 1 + ((*ldr_)) * (((*l_) - 1))] = 0.0;
  }
  for (j_ = (*k_); j_ <= (*p_); (j_)++) {
    if (j_ == (*k_)) {
      goto _l200;
    }
    iu_ = _min (j_ - 1, (*l_) - 1);
    for (i_ = (*k_); i_ <= iu_; (i_)++) {
      ii_ = i_ - (*k_) + 1;
      t_ = c_[ii_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] = c_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] - s_[ii_ - 1] * r_[i_ - 
      1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
    _l200:;
    if (j_ >= (*l_)) {
      goto _l210;
    }
    jj_ = j_ - (*k_) + 1;
    t_ = s_[jj_ - 1];
    (void) _drotg (&r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))], &t_, &c_[jj_ - 1], &s_[jj_ - 1]);
    _l210:;
  }
  if ((*nz_) < 1) {
    goto _l250;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    for (i_ = (*k_); i_ <= lm1_; (i_)++) {
      ii_ = i_ - km1_;
      t_ = c_[ii_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] = c_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] - s_[ii_ - 1] * z_[i_ - 
      1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
  }
  _l250:;
  _l260:;
  __calls[50].calls++;
  return 0;
}

int_4 _dchud (real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, real_8 _p_ x_, real_8 _p_ z_, int_4 _p_ ldz_, int_4 _p_ nz_, 
real_8 _p_ y_, real_8 _p_ rho_, real_8 _p_ c_, real_8 _p_ s_)
{
  static int_4 i_, j_, jm1_;
  static real_8 azeta_, scale_, t_, xj_, zeta_;
  real_8 $0_, $1_;
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    xj_ = x_[j_ - 1];
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      t_ = c_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[i_ - 1] * xj_;
      xj_ = c_[i_ - 1] * xj_ - s_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
    _l20:;
    (void) _drotg (&r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))], &xj_, &c_[j_ - 1], &s_[j_ - 1]);
  }
  if ((*nz_) < 1) {
    goto _l70;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    zeta_ = y_[j_ - 1];
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      t_ = c_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[i_ - 1] * zeta_;
      zeta_ = c_[i_ - 1] * zeta_ - s_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
    azeta_ = _abs (zeta_);
    if (azeta_ == 0.0e0 || rho_[j_ - 1] < 0.0e0) {
      goto _l50;
    }
    scale_ = azeta_ + rho_[j_ - 1];
    rho_[j_ - 1] = scale_ * sqrt (($0_ = (azeta_ / scale_), $0_ * $0_) + ($1_ = (rho_[j_ - 1] / scale_), $1_ * $1_));
    _l50:;
  }
  _l70:;
  __calls[51].calls++;
  return 0;
}

int_4 _dgbco (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_8 _p_ 
rcond_, real_8 _p_ z_)
{
  static int_4 is_, info_, j_, ju_, k_, kb_, kp1_, l_, la_, lm_, lz_, m_, mm_;
  static real_8 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  extern real_8 _ddot ();
  extern real_8 _dasum ();
  anorm_ = 0.0;
  l_ = (*ml_) + 1;
  is_ = l_ + (*mu_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _dasum (&l_, &abd_[is_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1));
    if (is_ > (*ml_) + 1) {
      is_ = is_ - 1;
    }
    if (j_ <= (*mu_)) {
      l_ = l_ + 1;
    }
    if (j_ >= (*n_) - (*ml_)) {
      l_ = l_ - 1;
    }
  }
  (void) _dgbfa (abd_, lda_, n_, ml_, mu_, ipvt_, &info_);
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  m_ = (*ml_) + (*mu_) + 1;
  ju_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= _abs (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))])) {
      goto _l30;
    }
    s_ = _abs (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (ek_ - z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l30:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    if (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    wk_ = wk_ / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    wkm_ = wkm_ / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    goto _l50;
    _l40:;
    wk_ = 1.0;
    wkm_ = 1.0;
    _l50:;
    kp1_ = k_ + 1;
    ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
    mm_ = m_;
    if (kp1_ > ju_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= ju_; (j_)++) {
      mm_ = mm_ - 1;
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l80;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    mm_ = m_;
    for (j_ = kp1_; j_ <= ju_; (j_)++) {
      mm_ = mm_ - 1;
      z_[j_ - 1] = z_[j_ - 1] + t_ * abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))];
    }
    _l80:;
    _l90:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    lm_ = _min ((*ml_), (*n_) - k_);
    if (k_ < (*n_)) {
      z_[k_ - 1] = z_[k_ - 1] + _ddot (&lm_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
    }
    if (_abs (z_[k_ - 1]) <= 1.0e0) {
      goto _l110;
    }
    s_ = 1.0e0 / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    _l110:;
    l_ = ipvt_[k_ - 1];
    t_ = z_[l_ - 1];
    z_[l_ - 1] = z_[k_ - 1];
    z_[k_ - 1] = t_;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = z_[l_ - 1];
    z_[l_ - 1] = z_[k_ - 1];
    z_[k_ - 1] = t_;
    lm_ = _min ((*ml_), (*n_) - k_);
    if (k_ < (*n_)) {
      (void) _daxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
    }
    if (_abs (z_[k_ - 1]) <= 1.0e0) {
      goto _l130;
    }
    s_ = 1.0e0 / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l130:;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= _abs (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))])) {
      goto _l150;
    }
    s_ = _abs (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l150:;
    if (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0e0) {
      z_[k_ - 1] = z_[k_ - 1] / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    }
    if (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      z_[k_ - 1] = 1.0;
    }
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lz_ = k_ - lm_;
    t_ = -z_[k_ - 1];
    (void) _daxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lz_ - 1], &_k1);
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[52].calls++;
  return 0;
}

int_4 _dgbdi (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_8 _p_ 
det_)
{
  static int_4 i_, m_;
  static real_8 ten_;
  m_ = (*ml_) + (*mu_) + 1;
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = abd_[m_ - 1 + ((*lda_)) * ((i_ - 1))] * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l20;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (_abs (det_[0]) < ten_) {
      goto _l40;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  __calls[53].calls++;
  return 0;
}

int_4 _dgbfa (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, int_4 _p_ 
info_)
{
  static int_4 i_, i0_, j_, ju_, jz_, j0_, j1_, k_, kp1_, l_, lm_, m_, mm_, nm1_;
  static real_8 t_;
  int_4 $0_;
  extern int_4 _idamax ();
  m_ = (*ml_) + (*mu_) + 1;
  (*info_) = 0;
  j0_ = (*mu_) + 2;
  j1_ = _min ((*n_), m_) - 1;
  if (j1_ < j0_) {
    goto _l30;
  }
  for (jz_ = j0_; jz_ <= j1_; (jz_)++) {
    i0_ = m_ + 1 - jz_;
    for (i_ = i0_; i_ <= (*ml_); (i_)++) {
      abd_[i_ - 1 + ((*lda_)) * ((jz_ - 1))] = 0.0;
    }
  }
  _l30:;
  jz_ = j1_;
  ju_ = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l130;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    jz_ = jz_ + 1;
    if (jz_ > (*n_)) {
      goto _l50;
    }
    if ((*ml_) < 1) {
      goto _l50;
    }
    for (i_ = 1; i_ <= (*ml_); (i_)++) {
      abd_[i_ - 1 + ((*lda_)) * ((jz_ - 1))] = 0.0;
    }
    _l50:;
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = _idamax (($0_ = lm_ + 1, &$0_), &abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + m_ - 1;
    ipvt_[k_ - 1] = l_ + k_ - m_;
    if (abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l100;
    }
    if (l_ == m_) {
      goto _l60;
    }
    t_ = abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
    abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
    _l60:;
    t_ = -1.0e0 / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _dscal (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1);
    ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
    mm_ = m_;
    if (ju_ < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= ju_; (j_)++) {
      l_ = l_ - 1;
      mm_ = mm_ - 1;
      t_ = abd_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
      if (l_ == mm_) {
        goto _l70;
      }
      abd_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))];
      abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      _l70:;
      (void) _daxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &abd_[mm_ + 1 - 1 + ((*lda_)) * ((j_ - 
      1))], &_k1);
    }
    _l90:;
    goto _l110;
    _l100:;
    (*info_) = k_;
    _l110:;
  }
  _l130:;
  ipvt_[(*n_) - 1] = (*n_);
  if (abd_[m_ - 1 + ((*lda_)) * (((*n_) - 1))] == 0.0e0) {
    (*info_) = (*n_);
  }
  __calls[54].calls++;
  return 0;
}

int_4 _dgbsl (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_8 _p_ 
b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, la_, lb_, lm_, m_, nm1_;
  static real_8 t_;
  extern real_8 _ddot ();
  m_ = (*mu_) + (*ml_) + 1;
  nm1_ = (*n_) - 1;
  if ((*job_) != 0) {
    goto _l50;
  }
  if ((*ml_) == 0) {
    goto _l30;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    (void) _daxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lb_ = k_ - lm_;
    t_ = -b_[k_ - 1];
    (void) _daxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lb_ = k_ - lm_;
    t_ = _ddot (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  if ((*ml_) == 0) {
    goto _l90;
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    lm_ = _min ((*ml_), (*n_) - k_);
    b_[k_ - 1] = b_[k_ - 1] + _ddot (&lm_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[55].calls++;
  return 0;
}

int_4 _dgeco (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ rcond_, real_8 _p_ z_)
{
  static int_4 info_, j_, k_, kb_, kp1_, l_;
  static real_8 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  int_4 $0_, $1_, $2_;
  extern real_8 _ddot ();
  extern real_8 _dasum ();
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _dasum (n_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1));
  }
  (void) _dgefa (a_, lda_, n_, ipvt_, &info_);
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) {
      goto _l30;
    }
    s_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (ek_ - z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l30:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    wk_ = wk_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    wkm_ = wkm_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    goto _l50;
    _l40:;
    wk_ = 1.0;
    wkm_ = 1.0;
    _l50:;
    kp1_ = k_ + 1;
    if (kp1_ > (*n_)) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l80;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      z_[j_ - 1] = z_[j_ - 1] + t_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
    }
    _l80:;
    _l90:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (k_ < (*n_)) {
      z_[k_ - 1] = z_[k_ - 1] + _ddot (($0_ = (*n_) - k_, &$0_), &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 
      1], &_k1);
    }
    if (_abs (z_[k_ - 1]) <= 1.0e0) {
      goto _l110;
    }
    s_ = 1.0e0 / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    _l110:;
    l_ = ipvt_[k_ - 1];
    t_ = z_[l_ - 1];
    z_[l_ - 1] = z_[k_ - 1];
    z_[k_ - 1] = t_;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = z_[l_ - 1];
    z_[l_ - 1] = z_[k_ - 1];
    z_[k_ - 1] = t_;
    if (k_ < (*n_)) {
      (void) _daxpy (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
    }
    if (_abs (z_[k_ - 1]) <= 1.0e0) {
      goto _l130;
    }
    s_ = 1.0e0 / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l130:;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) {
      goto _l150;
    }
    s_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l150:;
    if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0e0) {
      z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    }
    if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      z_[k_ - 1] = 1.0;
    }
    t_ = -z_[k_ - 1];
    (void) _daxpy (($2_ = k_ - 1, &$2_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[56].calls++;
  return 0;
}

int_4 _dgedi (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ det_, real_8 _p_ work_, int_4 
_p_ job_)
{
  static int_4 i_, j_, k_, kb_, kp1_, l_, nm1_;
  static real_8 t_, ten_;
  int_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l20;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (_abs (det_[0]) < ten_) {
      goto _l40;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l150;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = 1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _dscal (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    kp1_ = k_ + 1;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
      (void) _daxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l90:;
  }
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l140;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    kp1_ = k_ + 1;
    for (i_ = kp1_; i_ <= (*n_); (i_)++) {
      work_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((k_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((k_ - 1))] = 0.0;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = work_[j_ - 1];
      (void) _daxpy (n_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    }
    l_ = ipvt_[k_ - 1];
    if (l_ != k_) {
      (void) _dswap (n_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((l_ - 1))], &_k1);
    }
  }
  _l140:;
  _l150:;
  __calls[57].calls++;
  return 0;
}

int_4 _dgefa (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_)
{
  static int_4 j_, k_, kp1_, l_, nm1_;
  static real_8 t_;
  int_4 $0_, $1_, $2_;
  extern int_4 _idamax ();
  (*info_) = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l70;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    l_ = _idamax (($0_ = (*n_) - k_ + 1, &$0_), &a_[k_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + k_ - 1;
    ipvt_[k_ - 1] = l_;
    if (a_[l_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    if (l_ == k_) {
      goto _l10;
    }
    t_ = a_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
    _l10:;
    t_ = -1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _dscal (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1);
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
      if (l_ == k_) {
        goto _l20;
      }
      a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      _l20:;
      (void) _daxpy (($2_ = (*n_) - k_, &$2_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[k_ + 1 - 1 + 
      ((*lda_)) * ((j_ - 1))], &_k1);
    }
    goto _l50;
    _l40:;
    (*info_) = k_;
    _l50:;
  }
  _l70:;
  ipvt_[(*n_) - 1] = (*n_);
  if (a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))] == 0.0e0) {
    (*info_) = (*n_);
  }
  __calls[58].calls++;
  return 0;
}

int_4 _dgesl (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, nm1_;
  static real_8 t_;
  int_4 $0_, $1_, $2_, $3_;
  extern real_8 _ddot ();
  nm1_ = (*n_) - 1;
  if ((*job_) != 0) {
    goto _l50;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    (void) _daxpy (($0_ = (*n_) - k_, &$0_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _daxpy (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _ddot (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    b_[k_ - 1] = b_[k_ - 1] + _ddot (($3_ = (*n_) - k_, &$3_), &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 
    1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[59].calls++;
  return 0;
}

int_4 _dgtsl (int_4 _p_ n_, real_8 _p_ c_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ b_, int_4 _p_ info_)
{
  static int_4 k_, kb_, kp1_, nm1_, nm2_;
  static real_8 t_;
  (*info_) = 0;
  c_[0] = d_[0];
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l40;
  }
  d_[0] = e_[0];
  e_[0] = 0.0;
  e_[(*n_) - 1] = 0.0;
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    if (_abs (c_[kp1_ - 1]) < _abs (c_[k_ - 1])) {
      goto _l10;
    }
    t_ = c_[kp1_ - 1];
    c_[kp1_ - 1] = c_[k_ - 1];
    c_[k_ - 1] = t_;
    t_ = d_[kp1_ - 1];
    d_[kp1_ - 1] = d_[k_ - 1];
    d_[k_ - 1] = t_;
    t_ = e_[kp1_ - 1];
    e_[kp1_ - 1] = e_[k_ - 1];
    e_[k_ - 1] = t_;
    t_ = b_[kp1_ - 1];
    b_[kp1_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    if (c_[k_ - 1] != 0.0e0) {
      goto _l20;
    }
    (*info_) = k_;
    goto _l100;
    _l20:;
    t_ = -c_[kp1_ - 1] / c_[k_ - 1];
    c_[kp1_ - 1] = d_[kp1_ - 1] + t_ * d_[k_ - 1];
    d_[kp1_ - 1] = e_[kp1_ - 1] + t_ * e_[k_ - 1];
    e_[kp1_ - 1] = 0.0;
    b_[kp1_ - 1] = b_[kp1_ - 1] + t_ * b_[k_ - 1];
  }
  _l40:;
  if (c_[(*n_) - 1] != 0.0e0) {
    goto _l50;
  }
  (*info_) = (*n_);
  goto _l90;
  _l50:;
  nm2_ = (*n_) - 2;
  b_[(*n_) - 1] = b_[(*n_) - 1] / c_[(*n_) - 1];
  if ((*n_) == 1) {
    goto _l80;
  }
  b_[nm1_ - 1] = (b_[nm1_ - 1] - d_[nm1_ - 1] * b_[(*n_) - 1]) / c_[nm1_ - 1];
  if (nm2_ < 1) {
    goto _l70;
  }
  for (kb_ = 1; kb_ <= nm2_; (kb_)++) {
    k_ = nm2_ - kb_ + 1;
    b_[k_ - 1] = (b_[k_ - 1] - d_[k_ - 1] * b_[k_ + 1 - 1] - e_[k_ - 1] * b_[k_ + 2 - 1]) / c_[k_ - 1];
  }
  _l70:;
  _l80:;
  _l90:;
  _l100:;
  __calls[60].calls++;
  return 0;
}

int_4 _dpbco (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ rcond_, real_8 _p_ z_, int_4 _p_ 
info_)
{
  static int_4 i_, j_, j2_, k_, kb_, kp1_, l_, la_, lb_, lm_, mu_;
  static real_8 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  extern real_8 _ddot ();
  extern real_8 _dasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = _min (j_, (*m_) + 1);
    mu_ = _max ((*m_) + 2 - j_, 1);
    z_[j_ - 1] = _dasum (&l_, &abd_[mu_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
    k_ = j_ - l_;
    if ((*m_) < mu_) {
      goto _l20;
    }
    for (i_ = mu_; i_ <= (*m_); (i_)++) {
      k_ = k_ + 1;
      z_[k_ - 1] = z_[k_ - 1] + _abs (abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _dpbfa (abd_, lda_, n_, m_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l60;
    }
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))] / _abs (ek_ - z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l60:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    wk_ = wk_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    wkm_ = wkm_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    kp1_ = k_ + 1;
    j2_ = _min (k_ + (*m_), (*n_));
    i_ = (*m_) + 1;
    if (kp1_ > j2_) {
      goto _l100;
    }
    for (j_ = kp1_; j_ <= j2_; (j_)++) {
      i_ = i_ - 1;
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l90;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    i_ = (*m_) + 1;
    for (j_ = kp1_; j_ <= j2_; (j_)++) {
      i_ = i_ - 1;
      z_[j_ - 1] = z_[j_ - 1] + t_ * abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
    }
    _l90:;
    _l100:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l120;
    }
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    _l120:;
    z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    t_ = -z_[k_ - 1];
    (void) _daxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    z_[k_ - 1] = z_[k_ - 1] - _ddot (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
    if (_abs (z_[k_ - 1]) <= abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l140;
    }
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l140:;
    z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l160;
    }
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l160:;
    z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    t_ = -z_[k_ - 1];
    (void) _daxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  _l180:;
  __calls[61].calls++;
  return 0;
}

int_4 _dpbdi (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ det_)
{
  static int_4 i_;
  static real_8 s_;
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((i_ - 1))] * abd_[(*m_) + 1 - 1 + ((*lda_)) * ((i_ - 1))]) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  __calls[62].calls++;
  return 0;
}

int_4 _dpbfa (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ info_)
{
  static int_4 ik_, j_, jk_, k_, mu_;
  static real_8 t_, s_;
  int_4 $0_;
  extern real_8 _ddot ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    ik_ = (*m_) + 1;
    jk_ = _max (j_ - (*m_), 1);
    mu_ = _max ((*m_) + 2 - j_, 1);
    if ((*m_) < mu_) {
      goto _l20;
    }
    for (k_ = mu_; k_ <= (*m_); (k_)++) {
      t_ = abd_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _ddot (($0_ = k_ - mu_, &$0_), &abd_[ik_ - 1 + ((*lda_)) * ((jk_ - 1))], 
      &_k1, &abd_[mu_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
      t_ = t_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((jk_ - 1))];
      abd_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + t_ * t_;
      ik_ = ik_ - 1;
      jk_ = jk_ + 1;
    }
    _l20:;
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))] - s_;
    if (s_ <= 0.0e0) {
      goto _l40;
    }
    abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))] = sqrt (s_);
  }
  (*info_) = 0;
  _l40:;
  __calls[63].calls++;
  return 0;
}

int_4 _dpbsl (real_8 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ b_)
{
  static int_4 k_, kb_, la_, lb_, lm_;
  static real_8 t_;
  extern real_8 _ddot ();
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    t_ = _ddot (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    b_[k_ - 1] = b_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _daxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
  }
  __calls[64].calls++;
  return 0;
}

int_4 _dpoco (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ rcond_, real_8 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, j_, jm1_, k_, kb_, kp1_;
  static real_8 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  int_4 $0_, $1_, $2_;
  extern real_8 _ddot ();
  extern real_8 _dasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = _dasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = z_[i_ - 1] + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _dpofa (a_, lda_, n_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l60;
    }
    s_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / _abs (ek_ - z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l60:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    wk_ = wk_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    wkm_ = wkm_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    kp1_ = k_ + 1;
    if (kp1_ > (*n_)) {
      goto _l100;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l90;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      z_[j_ - 1] = z_[j_ - 1] + t_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
    }
    _l90:;
    _l100:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l120;
    }
    s_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    _l120:;
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -z_[k_ - 1];
    (void) _daxpy (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    z_[k_ - 1] = z_[k_ - 1] - _ddot (($1_ = k_ - 1, &$1_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
    if (_abs (z_[k_ - 1]) <= a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l140;
    }
    s_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l140:;
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l160;
    }
    s_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l160:;
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -z_[k_ - 1];
    (void) _daxpy (($2_ = k_ - 1, &$2_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  _l180:;
  __calls[65].calls++;
  return 0;
}

int_4 _dpodi (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_)
{
  static int_4 i_, j_, jm1_, k_, kp1_;
  static real_8 t_, s_;
  int_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l140;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = 1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _dscal (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    kp1_ = k_ + 1;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
      (void) _daxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l90:;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l120;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      (void) _daxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    }
    _l120:;
    t_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
    (void) _dscal (&j_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  }
  _l140:;
  __calls[66].calls++;
  return 0;
}

int_4 _dpofa (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, jm1_, k_;
  static real_8 t_, s_;
  int_4 $0_;
  extern real_8 _ddot ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _ddot (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + 
      ((*lda_)) * ((j_ - 1))], &_k1);
      t_ = t_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + t_ * t_;
    }
    _l20:;
    s_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] - s_;
    if (s_ <= 0.0e0) {
      goto _l40;
    }
    a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = sqrt (s_);
  }
  (*info_) = 0;
  _l40:;
  __calls[67].calls++;
  return 0;
}

int_4 _dposl (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ b_)
{
  static int_4 k_, kb_;
  static real_8 t_;
  int_4 $0_, $1_;
  extern real_8 _ddot ();
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _ddot (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _daxpy (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  __calls[68].calls++;
  return 0;
}

int_4 _dppco (real_8 _p_ ap_, int_4 _p_ n_, real_8 _p_ rcond_, real_8 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, ij_, j_, jm1_, j1_, k_, kb_, kj_, kk_, kp1_;
  static real_8 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  int_4 $0_, $1_, $2_;
  extern real_8 _ddot ();
  extern real_8 _dasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = _dasum (&j_, &ap_[j1_ - 1], &_k1);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = z_[i_ - 1] + _abs (ap_[ij_ - 1]);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _dppfa (ap_, n_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = kk_ + k_;
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= ap_[kk_ - 1]) {
      goto _l60;
    }
    s_ = ap_[kk_ - 1] / _abs (ek_ - z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l60:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    wk_ = wk_ / ap_[kk_ - 1];
    wkm_ = wkm_ / ap_[kk_ - 1];
    kp1_ = k_ + 1;
    kj_ = kk_ + k_;
    if (kp1_ > (*n_)) {
      goto _l100;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * ap_[kj_ - 1]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * ap_[kj_ - 1];
      s_ = s_ + _abs (z_[j_ - 1]);
      kj_ = kj_ + j_;
    }
    if (s_ >= sm_) {
      goto _l90;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    kj_ = kk_ + k_;
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      z_[j_ - 1] = z_[j_ - 1] + t_ * ap_[kj_ - 1];
      kj_ = kj_ + j_;
    }
    _l90:;
    _l100:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= ap_[kk_ - 1]) {
      goto _l120;
    }
    s_ = ap_[kk_ - 1] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    _l120:;
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
    kk_ = kk_ - k_;
    t_ = -z_[k_ - 1];
    (void) _daxpy (($0_ = k_ - 1, &$0_), &t_, &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    z_[k_ - 1] = z_[k_ - 1] - _ddot (($1_ = k_ - 1, &$1_), &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
    kk_ = kk_ + k_;
    if (_abs (z_[k_ - 1]) <= ap_[kk_ - 1]) {
      goto _l140;
    }
    s_ = ap_[kk_ - 1] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l140:;
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= ap_[kk_ - 1]) {
      goto _l160;
    }
    s_ = ap_[kk_ - 1] / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l160:;
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
    kk_ = kk_ - k_;
    t_ = -z_[k_ - 1];
    (void) _daxpy (($2_ = k_ - 1, &$2_), &t_, &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  _l180:;
  __calls[69].calls++;
  return 0;
}

int_4 _dppdi (real_8 _p_ ap_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_)
{
  static int_4 i_, ii_, j_, jj_, jm1_, j1_, k_, kj_, kk_, kp1_, k1_;
  static real_8 t_, s_;
  int_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  ii_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ii_ = ii_ + i_;
    det_[0] = (ap_[ii_ - 1] * ap_[ii_ - 1]) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l140;
  }
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    k1_ = kk_ + 1;
    kk_ = kk_ + k_;
    ap_[kk_ - 1] = 1.0e0 / ap_[kk_ - 1];
    t_ = -ap_[kk_ - 1];
    (void) _dscal (($0_ = k_ - 1, &$0_), &t_, &ap_[k1_ - 1], &_k1);
    kp1_ = k_ + 1;
    j1_ = kk_ + 1;
    kj_ = kk_ + k_;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = ap_[kj_ - 1];
      ap_[kj_ - 1] = 0.0;
      (void) _daxpy (&k_, &t_, &ap_[k1_ - 1], &_k1, &ap_[j1_ - 1], &_k1);
      j1_ = j1_ + j_;
      kj_ = kj_ + j_;
    }
    _l90:;
  }
  jj_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    j1_ = jj_ + 1;
    jj_ = jj_ + j_;
    jm1_ = j_ - 1;
    k1_ = 1;
    kj_ = j1_;
    if (jm1_ < 1) {
      goto _l120;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = ap_[kj_ - 1];
      (void) _daxpy (&k_, &t_, &ap_[j1_ - 1], &_k1, &ap_[k1_ - 1], &_k1);
      k1_ = k1_ + k_;
      kj_ = kj_ + 1;
    }
    _l120:;
    t_ = ap_[jj_ - 1];
    (void) _dscal (&j_, &t_, &ap_[j1_ - 1], &_k1);
  }
  _l140:;
  __calls[70].calls++;
  return 0;
}

int_4 _dppfa (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, jj_, jm1_, k_, kj_, kk_;
  static real_8 t_, s_;
  int_4 $0_;
  extern real_8 _ddot ();
  jj_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    jm1_ = j_ - 1;
    kj_ = jj_;
    kk_ = 0;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      kj_ = kj_ + 1;
      t_ = ap_[kj_ - 1] - _ddot (($0_ = k_ - 1, &$0_), &ap_[kk_ + 1 - 1], &_k1, &ap_[jj_ + 1 - 1], &_k1);
      kk_ = kk_ + k_;
      t_ = t_ / ap_[kk_ - 1];
      ap_[kj_ - 1] = t_;
      s_ = s_ + t_ * t_;
    }
    _l20:;
    jj_ = jj_ + j_;
    s_ = ap_[jj_ - 1] - s_;
    if (s_ <= 0.0e0) {
      goto _l40;
    }
    ap_[jj_ - 1] = sqrt (s_);
  }
  (*info_) = 0;
  _l40:;
  __calls[71].calls++;
  return 0;
}

int_4 _dppsl (real_8 _p_ ap_, int_4 _p_ n_, real_8 _p_ b_)
{
  static int_4 k_, kb_, kk_;
  static real_8 t_;
  int_4 $0_, $1_;
  extern real_8 _ddot ();
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _ddot (($0_ = k_ - 1, &$0_), &ap_[kk_ + 1 - 1], &_k1, &b_[0], &_k1);
    kk_ = kk_ + k_;
    b_[k_ - 1] = (b_[k_ - 1] - t_) / ap_[kk_ - 1];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
    kk_ = kk_ - k_;
    t_ = -b_[k_ - 1];
    (void) _daxpy (($1_ = k_ - 1, &$1_), &t_, &ap_[kk_ + 1 - 1], &_k1, &b_[0], &_k1);
  }
  __calls[72].calls++;
  return 0;
}

int_4 _dptsl (int_4 _p_ n_, real_8 _p_ d_, real_8 _p_ e_, real_8 _p_ b_)
{
  static int_4 k_, kbm1_, ke_, kf_, kp1_, nm1_, nm1d2_;
  static real_8 t1_, t2_;
  if ((*n_) != 1) {
    goto _l10;
  }
  b_[0] = b_[0] / d_[0];
  goto _l70;
  _l10:;
  nm1_ = (*n_) - 1;
  nm1d2_ = nm1_ / 2;
  if ((*n_) == 2) {
    goto _l30;
  }
  kbm1_ = (*n_) - 1;
  for (k_ = 1; k_ <= nm1d2_; (k_)++) {
    t1_ = e_[k_ - 1] / d_[k_ - 1];
    d_[k_ + 1 - 1] = d_[k_ + 1 - 1] - t1_ * e_[k_ - 1];
    b_[k_ + 1 - 1] = b_[k_ + 1 - 1] - t1_ * b_[k_ - 1];
    t2_ = e_[kbm1_ - 1] / d_[kbm1_ + 1 - 1];
    d_[kbm1_ - 1] = d_[kbm1_ - 1] - t2_ * e_[kbm1_ - 1];
    b_[kbm1_ - 1] = b_[kbm1_ - 1] - t2_ * b_[kbm1_ + 1 - 1];
    kbm1_ = kbm1_ - 1;
  }
  _l30:;
  kp1_ = nm1d2_ + 1;
  if (_imod ((*n_), 2) != 0) {
    goto _l40;
  }
  t1_ = e_[kp1_ - 1] / d_[kp1_ - 1];
  d_[kp1_ + 1 - 1] = d_[kp1_ + 1 - 1] - t1_ * e_[kp1_ - 1];
  b_[kp1_ + 1 - 1] = b_[kp1_ + 1 - 1] - t1_ * b_[kp1_ - 1];
  kp1_ = kp1_ + 1;
  _l40:;
  b_[kp1_ - 1] = b_[kp1_ - 1] / d_[kp1_ - 1];
  if ((*n_) == 2) {
    goto _l60;
  }
  k_ = kp1_ - 1;
  ke_ = kp1_ + nm1d2_ - 1;
  for (kf_ = kp1_; kf_ <= ke_; (kf_)++) {
    b_[k_ - 1] = (b_[k_ - 1] - e_[k_ - 1] * b_[k_ + 1 - 1]) / d_[k_ - 1];
    b_[kf_ + 1 - 1] = (b_[kf_ + 1 - 1] - e_[kf_ - 1] * b_[kf_ - 1]) / d_[kf_ + 1 - 1];
    k_ = k_ - 1;
  }
  _l60:;
  if (_imod ((*n_), 2) == 0) {
    b_[0] = (b_[0] - e_[0] * b_[1]) / d_[0];
  }
  _l70:;
  __calls[73].calls++;
  return 0;
}

int_4 _dqrdc (real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, real_8 _p_ qraux_, int_4 _p_ jpvt_, real_8 _p_ 
work_, int_4 _p_ job_)
{
  static int_4 j_, jp_, l_, lp1_, lup_, maxj_, pl_, pu_, jj_;
  static logical_4 negj_, swapj_;
  static real_8 maxnrm_, tt_, nrmxl_, t_;
  int_4 $0_, $1_, $3_, $4_, $7_;
  real_8 $2_, $5_, $6_;
  extern real_8 _dnrm2 ();
  extern real_8 _ddot ();
  pl_ = 1;
  pu_ = 0;
  if ((*job_) == 0) {
    goto _l60;
  }
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    swapj_ = jpvt_[j_ - 1] > 0;
    negj_ = jpvt_[j_ - 1] < 0;
    jpvt_[j_ - 1] = j_;
    if (negj_) {
      jpvt_[j_ - 1] = -j_;
    }
    if (! (swapj_)) {
      goto _l10;
    }
    if (j_ != pl_) {
      (void) _dswap (n_, &x_[0 + ((*ldx_)) * ((pl_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    }
    jpvt_[j_ - 1] = jpvt_[pl_ - 1];
    jpvt_[pl_ - 1] = j_;
    pl_ = pl_ + 1;
    _l10:;
  }
  pu_ = (*p_);
  for (jj_ = 1; jj_ <= (*p_); (jj_)++) {
    j_ = (*p_) - jj_ + 1;
    if (jpvt_[j_ - 1] >= 0) {
      goto _l40;
    }
    jpvt_[j_ - 1] = -jpvt_[j_ - 1];
    if (j_ == pu_) {
      goto _l30;
    }
    (void) _dswap (n_, &x_[0 + ((*ldx_)) * ((pu_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    jp_ = jpvt_[pu_ - 1];
    jpvt_[pu_ - 1] = jpvt_[j_ - 1];
    jpvt_[j_ - 1] = jp_;
    _l30:;
    pu_ = pu_ - 1;
    _l40:;
  }
  _l60:;
  if (pu_ < pl_) {
    goto _l80;
  }
  for (j_ = pl_; j_ <= pu_; (j_)++) {
    qraux_[j_ - 1] = _dnrm2 (n_, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    work_[j_ - 1] = qraux_[j_ - 1];
  }
  _l80:;
  lup_ = _min ((*n_), (*p_));
  for (l_ = 1; l_ <= lup_; (l_)++) {
    if (l_ < pl_ || l_ >= pu_) {
      goto _l120;
    }
    maxnrm_ = 0.0;
    maxj_ = l_;
    for (j_ = l_; j_ <= pu_; (j_)++) {
      if (qraux_[j_ - 1] <= maxnrm_) {
        goto _l90;
      }
      maxnrm_ = qraux_[j_ - 1];
      maxj_ = j_;
      _l90:;
    }
    if (maxj_ == l_) {
      goto _l110;
    }
    (void) _dswap (n_, &x_[0 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((maxj_ - 1))], &_k1);
    qraux_[maxj_ - 1] = qraux_[l_ - 1];
    work_[maxj_ - 1] = work_[l_ - 1];
    jp_ = jpvt_[maxj_ - 1];
    jpvt_[maxj_ - 1] = jpvt_[l_ - 1];
    jpvt_[l_ - 1] = jp_;
    _l110:;
    _l120:;
    qraux_[l_ - 1] = 0.0;
    if (l_ == (*n_)) {
      goto _l190;
    }
    nrmxl_ = _dnrm2 (($0_ = (*n_) - l_ + 1, &$0_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1);
    if (nrmxl_ == 0.0e0) {
      goto _l180;
    }
    if (x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] != 0.0e0) {
      nrmxl_ = _sign (nrmxl_, x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]);
    }
    (void) _dscal (($1_ = (*n_) - l_ + 1, &$1_), ($2_ = 1.0e0 / nrmxl_, &$2_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1)
    ;
    x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = 1.0e0 + x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
    lp1_ = l_ + 1;
    if ((*p_) < lp1_) {
      goto _l170;
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      t_ = -_ddot (($3_ = (*n_) - l_ + 1, &$3_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * ((j_ - 
      1))], &_k1) / x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
      (void) _daxpy (($4_ = (*n_) - l_ + 1, &$4_), &t_, &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * 
      ((j_ - 1))], &_k1);
      if (j_ < pl_ || j_ > pu_) {
        goto _l150;
      }
      if (qraux_[j_ - 1] == 0.0e0) {
        goto _l150;
      }
      tt_ = 1.0e0 - ($5_ = (_abs (x_[l_ - 1 + ((*ldx_)) * ((j_ - 1))]) / qraux_[j_ - 1]), $5_ * $5_);
      tt_ = _max (tt_, 0.0);
      t_ = tt_;
      tt_ = 1.0e0 + 0.05e0 * tt_ * ($6_ = (qraux_[j_ - 1] / work_[j_ - 1]), $6_ * $6_);
      if (tt_ == 1.0e0) {
        goto _l130;
      }
      qraux_[j_ - 1] = qraux_[j_ - 1] * sqrt (t_);
      goto _l140;
      _l130:;
      qraux_[j_ - 1] = _dnrm2 (($7_ = (*n_) - l_, &$7_), &x_[l_ + 1 - 1 + ((*ldx_)) * ((j_ - 1))], &_k1);
      work_[j_ - 1] = qraux_[j_ - 1];
      _l140:;
      _l150:;
    }
    _l170:;
    qraux_[l_ - 1] = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
    x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = -nrmxl_;
    _l180:;
    _l190:;
  }
  __calls[74].calls++;
  return 0;
}

int_4 _dqrsl (real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ k_, real_8 _p_ qraux_, real_8 _p_ y_, real_8 _p_ 
qy_, real_8 _p_ qty_, real_8 _p_ b_, real_8 _p_ rsd_, real_8 _p_ xb_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, j_, jj_, ju_, kp1_;
  static logical_4 cb_, cqy_, cqty_, cr_, cxb_;
  static real_8 t_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  extern real_8 _ddot ();
  (*info_) = 0;
  cqy_ = (*job_) / 10000 != 0;
  cqty_ = _imod ((*job_), 10000) != 0;
  cb_ = _imod ((*job_), 1000) / 100 != 0;
  cr_ = _imod ((*job_), 100) / 10 != 0;
  cxb_ = _imod ((*job_), 10) != 0;
  ju_ = _min ((*k_), (*n_) - 1);
  if (ju_ != 0) {
    goto _l40;
  }
  if (cqy_) {
    qy_[0] = y_[0];
  }
  if (cqty_) {
    qty_[0] = y_[0];
  }
  if (cxb_) {
    xb_[0] = y_[0];
  }
  if (! (cb_)) {
    goto _l30;
  }
  if (x_[0 + ((*ldx_)) * ((0))] != 0.0e0) {
    goto _l10;
  }
  (*info_) = 1;
  goto _l20;
  _l10:;
  b_[0] = y_[0] / x_[0 + ((*ldx_)) * ((0))];
  _l20:;
  _l30:;
  if (cr_) {
    rsd_[0] = 0.0;
  }
  goto _l250;
  _l40:;
  if (cqy_) {
    (void) _dcopy (n_, y_, &_k1, qy_, &_k1);
  }
  if (cqty_) {
    (void) _dcopy (n_, y_, &_k1, qty_, &_k1);
  }
  if (! (cqy_)) {
    goto _l70;
  }
  for (jj_ = 1; jj_ <= ju_; (jj_)++) {
    j_ = ju_ - jj_ + 1;
    if (qraux_[j_ - 1] == 0.0e0) {
      goto _l50;
    }
    temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
    t_ = -_ddot (($0_ = (*n_) - j_ + 1, &$0_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qy_[j_ - 1], &_k1) / x_[j_ - 1 
    + ((*ldx_)) * ((j_ - 1))];
    (void) _daxpy (($1_ = (*n_) - j_ + 1, &$1_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qy_[j_ - 1], &_k1);
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
    _l50:;
  }
  _l70:;
  if (! (cqty_)) {
    goto _l100;
  }
  for (j_ = 1; j_ <= ju_; (j_)++) {
    if (qraux_[j_ - 1] == 0.0e0) {
      goto _l80;
    }
    temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
    t_ = -_ddot (($2_ = (*n_) - j_ + 1, &$2_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qty_[j_ - 1], &_k1) / x_[j_ - 1 
    + ((*ldx_)) * ((j_ - 1))];
    (void) _daxpy (($3_ = (*n_) - j_ + 1, &$3_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qty_[j_ - 1], &_k1);
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
    _l80:;
  }
  _l100:;
  if (cb_) {
    (void) _dcopy (k_, qty_, &_k1, b_, &_k1);
  }
  kp1_ = (*k_) + 1;
  if (cxb_) {
    (void) _dcopy (k_, qty_, &_k1, xb_, &_k1);
  }
  if (cr_ && (*k_) < (*n_)) {
    (void) _dcopy (($4_ = (*n_) - (*k_), &$4_), &qty_[kp1_ - 1], &_k1, &rsd_[kp1_ - 1], &_k1);
  }
  if (! (cxb_) || kp1_ > (*n_)) {
    goto _l120;
  }
  for (i_ = kp1_; i_ <= (*n_); (i_)++) {
    xb_[i_ - 1] = 0.0;
  }
  _l120:;
  if (! (cr_)) {
    goto _l140;
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    rsd_[i_ - 1] = 0.0;
  }
  _l140:;
  if (! (cb_)) {
    goto _l190;
  }
  for (jj_ = 1; jj_ <= (*k_); (jj_)++) {
    j_ = (*k_) - jj_ + 1;
    if (x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] != 0.0e0) {
      goto _l150;
    }
    (*info_) = j_;
    goto _l180;
    _l150:;
    b_[j_ - 1] = b_[j_ - 1] / x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
    if (j_ == 1) {
      goto _l160;
    }
    t_ = -b_[j_ - 1];
    (void) _daxpy (($5_ = j_ - 1, &$5_), &t_, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1, b_, &_k1);
    _l160:;
  }
  _l180:;
  _l190:;
  if (! (cr_) && ! (cxb_)) {
    goto _l240;
  }
  for (jj_ = 1; jj_ <= ju_; (jj_)++) {
    j_ = ju_ - jj_ + 1;
    if (qraux_[j_ - 1] == 0.0e0) {
      goto _l220;
    }
    temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
    if (! (cr_)) {
      goto _l200;
    }
    t_ = -_ddot (($6_ = (*n_) - j_ + 1, &$6_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &rsd_[j_ - 1], &_k1) / x_[j_ - 1 
    + ((*ldx_)) * ((j_ - 1))];
    (void) _daxpy (($7_ = (*n_) - j_ + 1, &$7_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &rsd_[j_ - 1], &_k1);
    _l200:;
    if (! (cxb_)) {
      goto _l210;
    }
    t_ = -_ddot (($8_ = (*n_) - j_ + 1, &$8_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &xb_[j_ - 1], &_k1) / x_[j_ - 1 
    + ((*ldx_)) * ((j_ - 1))];
    (void) _daxpy (($9_ = (*n_) - j_ + 1, &$9_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &xb_[j_ - 1], &_k1);
    _l210:;
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
    _l220:;
  }
  _l240:;
  _l250:;
  __calls[75].calls++;
  return 0;
}

int_4 _dsico (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, real_8 _p_ z_)
{
  static int_4 i_, info_, j_, jm1_, k_, kp_, kps_, ks_;
  static real_8 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, anorm_, s_, ynorm_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern real_8 _ddot ();
  extern real_8 _dasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = _dasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = z_[i_ - 1] + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _dsifa (a_, lda_, n_, kpvt_, &info_);
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  k_ = (*n_);
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (z_[k_ - 1] != 0.0e0) {
    ek_ = _sign (ek_, z_[k_ - 1]);
  }
  z_[k_ - 1] = z_[k_ - 1] + ek_;
  (void) _daxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (ks_ == 1) {
    goto _l80;
  }
  if (z_[k_ - 1 - 1] != 0.0e0) {
    ek_ = _sign (ek_, z_[k_ - 1 - 1]);
  }
  z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
  (void) _daxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
  _l80:;
  if (ks_ == 2) {
    goto _l100;
  }
  if (_abs (z_[k_ - 1]) <= _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) {
    goto _l90;
  }
  s_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
  (void) _dscal (n_, &s_, z_, &_k1);
  ek_ = s_ * ek_;
  _l90:;
  if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0e0) {
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
    z_[k_ - 1] = 1.0;
  }
  goto _l110;
  _l100:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = z_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  _l110:;
  k_ = k_ - ks_;
  goto _l60;
  _l120:;
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  k_ = 1;
  _l130:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == 1) {
    goto _l150;
  }
  z_[k_ - 1] = z_[k_ - 1] + _ddot (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (ks_ == 2) {
    z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _ddot (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], &_k1)
    ;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l140;
  }
  t_ = z_[k_ - 1];
  z_[k_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l140:;
  _l150:;
  k_ = k_ + ks_;
  goto _l130;
  _l160:;
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  k_ = (*n_);
  _l170:;
  if (k_ == 0) {
    goto _l230;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == ks_) {
    goto _l190;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l180;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l180:;
  (void) _daxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (ks_ == 2) {
    (void) _daxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
  }
  _l190:;
  if (ks_ == 2) {
    goto _l210;
  }
  if (_abs (z_[k_ - 1]) <= _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) {
    goto _l200;
  }
  s_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  _l200:;
  if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0e0) {
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
    z_[k_ - 1] = 1.0;
  }
  goto _l220;
  _l210:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = z_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  _l220:;
  k_ = k_ - ks_;
  goto _l170;
  _l230:;
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  k_ = 1;
  _l240:;
  if (k_ > (*n_)) {
    goto _l270;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == 1) {
    goto _l260;
  }
  z_[k_ - 1] = z_[k_ - 1] + _ddot (($6_ = k_ - 1, &$6_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (ks_ == 2) {
    z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _ddot (($7_ = k_ - 1, &$7_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], &_k1)
    ;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l250;
  }
  t_ = z_[k_ - 1];
  z_[k_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l250:;
  _l260:;
  k_ = k_ + ks_;
  goto _l240;
  _l270:;
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[76].calls++;
  return 0;
}

int_4 _dsidi (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ det_, int_4 _p_ inert_, real_8 
_p_ work_, int_4 _p_ job_)
{
  static int_4 j_, jb_, k_, km1_, ks_, kstep_;
  static logical_4 noinv_, nodet_, noert_;
  static real_8 akkp1_, temp_, ten_, d_, t_, ak_, akp1_;
  int_4 $0_, $1_, $2_;
  extern real_8 _ddot ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  noert_ = _imod ((*job_), 1000) / 100 == 0;
  if (nodet_ && noert_) {
    goto _l140;
  }
  if (noert_) {
    goto _l10;
  }
  inert_[0] = 0;
  inert_[1] = 0;
  inert_[2] = 0;
  _l10:;
  if (nodet_) {
    goto _l20;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  _l20:;
  t_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    d_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    if (kpvt_[k_ - 1] > 0) {
      goto _l50;
    }
    if (t_ != 0.0e0) {
      goto _l30;
    }
    t_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))]);
    d_ = (d_ / t_) * a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] - t_;
    goto _l40;
    _l30:;
    d_ = t_;
    t_ = 0.0;
    _l40:;
    _l50:;
    if (noert_) {
      goto _l60;
    }
    if (d_ > 0.0e0) {
      inert_[0] = inert_[0] + 1;
    }
    if (d_ < 0.0e0) {
      inert_[1] = inert_[1] + 1;
    }
    if (d_ == 0.0e0) {
      inert_[2] = inert_[2] + 1;
    }
    _l60:;
    if (nodet_) {
      goto _l120;
    }
    det_[0] = d_ * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l110;
    }
    _l70:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l80;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l70;
    _l80:;
    _l90:;
    if (_abs (det_[0]) < ten_) {
      goto _l100;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l90;
    _l100:;
    _l110:;
    _l120:;
  }
  _l140:;
  if (noinv_) {
    goto _l270;
  }
  k_ = 1;
  _l150:;
  if (k_ > (*n_)) {
    goto _l260;
  }
  km1_ = k_ - 1;
  if (kpvt_[k_ - 1] < 0) {
    goto _l180;
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = 1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  if (km1_ < 1) {
    goto _l170;
  }
  (void) _dcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _ddot (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _daxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
    1))], &_k1);
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + _ddot (&km1_, work_, &_k1, &a_[0 + 
  ((*lda_)) * ((k_ - 1))], &_k1);
  _l170:;
  kstep_ = 1;
  goto _l220;
  _l180:;
  t_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))]);
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / t_;
  akp1_ = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
  akkp1_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
  d_ = t_ * (ak_ * akp1_ - 1.0e0);
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = akp1_ / d_;
  a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = ak_ / d_;
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = -akkp1_ / d_;
  if (km1_ < 1) {
    goto _l210;
  }
  (void) _dcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = _ddot (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _daxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 
    1 - 1))], &_k1);
  }
  a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _ddot (&km1_, work_, &_k1, 
  &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _ddot (&km1_, &a_[0 + ((*lda_)) * 
  ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
  (void) _dcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _ddot (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _daxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
    1))], &_k1);
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + _ddot (&km1_, work_, &_k1, &a_[0 + 
  ((*lda_)) * ((k_ - 1))], &_k1);
  _l210:;
  kstep_ = 2;
  _l220:;
  ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (ks_ == k_) {
    goto _l250;
  }
  (void) _dswap (&ks_, &a_[0 + ((*lda_)) * ((ks_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  for (jb_ = ks_; jb_ <= k_; (jb_)++) {
    j_ = k_ + ks_ - jb_;
    temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
  }
  if (kstep_ == 1) {
    goto _l240;
  }
  temp_ = a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = temp_;
  _l240:;
  _l250:;
  k_ = k_ + kstep_;
  goto _l150;
  _l260:;
  _l270:;
  __calls[77].calls++;
  return 0;
}

int_4 _dsifa (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 imax_, imaxp1_, j_, jj_, jmax_, k_, km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_8 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, absakk_, alpha_, colmax_, rowmax_;
  int_4 $0_, $1_;
  extern int_4 _idamax ();
  alpha_ = 6.4038820320220756e-1;
  (*info_) = 0;
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (a_[0 + ((*lda_)) * ((0))] == 0.0e0) {
    (*info_) = 1;
  }
  goto _l200;
  _l20:;
  km1_ = k_ - 1;
  absakk_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
  imax_ = _idamax (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  colmax_ = _abs (a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))]);
  if (absakk_ < alpha_ * colmax_) {
    goto _l30;
  }
  kstep_ = 1;
  swap_ = FALSE;
  goto _l90;
  _l30:;
  rowmax_ = 0.0;
  imaxp1_ = imax_ + 1;
  for (j_ = imaxp1_; j_ <= k_; (j_)++) {
    rowmax_ = _max (rowmax_, _abs (a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]));
  }
  if (imax_ == 1) {
    goto _l50;
  }
  jmax_ = _idamax (($1_ = imax_ - 1, &$1_), &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1);
  rowmax_ = _max (rowmax_, _abs (a_[jmax_ - 1 + ((*lda_)) * ((imax_ - 1))]));
  _l50:;
  if (_abs (a_[imax_ - 1 + ((*lda_)) * ((imax_ - 1))]) < alpha_ * rowmax_) {
    goto _l60;
  }
  kstep_ = 1;
  swap_ = TRUE;
  goto _l80;
  _l60:;
  if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
    goto _l70;
  }
  kstep_ = 1;
  swap_ = FALSE;
  goto _l80;
  _l70:;
  kstep_ = 2;
  swap_ = imax_ != km1_;
  _l80:;
  _l90:;
  if (_max (absakk_, colmax_) != 0.0e0) {
    goto _l100;
  }
  kpvt_[k_ - 1] = k_;
  (*info_) = k_;
  goto _l190;
  _l100:;
  if (kstep_ == 2) {
    goto _l140;
  }
  if (! (swap_)) {
    goto _l120;
  }
  (void) _dswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  for (jj_ = imax_; jj_ <= k_; (jj_)++) {
    j_ = k_ + imax_ - jj_;
    t_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
  }
  _l120:;
  for (jj_ = 1; jj_ <= km1_; (jj_)++) {
    j_ = k_ - jj_;
    mulk_ = -a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = mulk_;
    (void) _daxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
  }
  kpvt_[k_ - 1] = k_;
  if (swap_) {
    kpvt_[k_ - 1] = imax_;
  }
  goto _l190;
  _l140:;
  if (! (swap_)) {
    goto _l160;
  }
  (void) _dswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1);
  for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
    j_ = km1_ + imax_ - jj_;
    t_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))];
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
  }
  t_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
  _l160:;
  km2_ = k_ - 2;
  if (km2_ == 0) {
    goto _l180;
  }
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = 1.0e0 - ak_ * akm1_;
  for (jj_ = 1; jj_ <= km2_; (jj_)++) {
    j_ = km1_ - jj_;
    bk_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
    bkm1_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
    mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
    mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
    t_ = mulk_;
    (void) _daxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    t_ = mulkm1_;
    (void) _daxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = mulkm1_;
  }
  _l180:;
  kpvt_[k_ - 1] = 1 - k_;
  if (swap_) {
    kpvt_[k_ - 1] = -imax_;
  }
  kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
  _l190:;
  k_ = k_ - kstep_;
  goto _l10;
  _l200:;
  __calls[78].calls++;
  return 0;
}

int_4 _dsisl (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ b_)
{
  static int_4 k_, kp_;
  static real_8 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern real_8 _ddot ();
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _daxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  k_ = k_ - 1;
  goto _l70;
  _l40:;
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _daxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  (void) _daxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &b_[0], &_k1);
  _l60:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = b_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = b_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _ddot (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _ddot (($4_ = k_ - 1, &$4_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _ddot (($5_ = k_ - 1, &$5_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &b_[0], &_k1)
  ;
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[79].calls++;
  return 0;
}

int_4 _dspco (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, real_8 _p_ z_)
{
  static int_4 i_, ij_, ik_, ikm1_, ikp1_, info_, j_, jm1_, j1_, k_, kk_, km1k_, km1km1_, kp_, kps_, ks_;
  static real_8 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, anorm_, s_, ynorm_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern real_8 _ddot ();
  extern real_8 _dasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = _dasum (&j_, &ap_[j1_ - 1], &_k1);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = z_[i_ - 1] + _abs (ap_[ij_ - 1]);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _dspfa (ap_, n_, kpvt_, &info_);
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  kk_ = ik_ + k_;
  ikm1_ = ik_ - (k_ - 1);
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (z_[k_ - 1] != 0.0e0) {
    ek_ = _sign (ek_, z_[k_ - 1]);
  }
  z_[k_ - 1] = z_[k_ - 1] + ek_;
  (void) _daxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
  if (ks_ == 1) {
    goto _l80;
  }
  if (z_[k_ - 1 - 1] != 0.0e0) {
    ek_ = _sign (ek_, z_[k_ - 1 - 1]);
  }
  z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
  (void) _daxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
  _l80:;
  if (ks_ == 2) {
    goto _l100;
  }
  if (_abs (z_[k_ - 1]) <= _abs (ap_[kk_ - 1])) {
    goto _l90;
  }
  s_ = _abs (ap_[kk_ - 1]) / _abs (z_[k_ - 1]);
  (void) _dscal (n_, &s_, z_, &_k1);
  ek_ = s_ * ek_;
  _l90:;
  if (ap_[kk_ - 1] != 0.0e0) {
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
  }
  if (ap_[kk_ - 1] == 0.0e0) {
    z_[k_ - 1] = 1.0;
  }
  goto _l110;
  _l100:;
  km1k_ = ik_ + k_ - 1;
  km1km1_ = ikm1_ + k_ - 1;
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = z_[k_ - 1] / ap_[km1k_ - 1];
  bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  _l110:;
  k_ = k_ - ks_;
  ik_ = ik_ - k_;
  if (ks_ == 2) {
    ik_ = ik_ - (k_ + 1);
  }
  goto _l60;
  _l120:;
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  k_ = 1;
  ik_ = 0;
  _l130:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == 1) {
    goto _l150;
  }
  z_[k_ - 1] = z_[k_ - 1] + _ddot (($2_ = k_ - 1, &$2_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
  ikp1_ = ik_ + k_;
  if (ks_ == 2) {
    z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _ddot (($3_ = k_ - 1, &$3_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l140;
  }
  t_ = z_[k_ - 1];
  z_[k_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l140:;
  _l150:;
  ik_ = ik_ + k_;
  if (ks_ == 2) {
    ik_ = ik_ + (k_ + 1);
  }
  k_ = k_ + ks_;
  goto _l130;
  _l160:;
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  k_ = (*n_);
  ik_ = (*n_) * ((*n_) - 1) / 2;
  _l170:;
  if (k_ == 0) {
    goto _l230;
  }
  kk_ = ik_ + k_;
  ikm1_ = ik_ - (k_ - 1);
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == ks_) {
    goto _l190;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l180;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l180:;
  (void) _daxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
  if (ks_ == 2) {
    (void) _daxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  _l190:;
  if (ks_ == 2) {
    goto _l210;
  }
  if (_abs (z_[k_ - 1]) <= _abs (ap_[kk_ - 1])) {
    goto _l200;
  }
  s_ = _abs (ap_[kk_ - 1]) / _abs (z_[k_ - 1]);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  _l200:;
  if (ap_[kk_ - 1] != 0.0e0) {
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
  }
  if (ap_[kk_ - 1] == 0.0e0) {
    z_[k_ - 1] = 1.0;
  }
  goto _l220;
  _l210:;
  km1k_ = ik_ + k_ - 1;
  km1km1_ = ikm1_ + k_ - 1;
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = z_[k_ - 1] / ap_[km1k_ - 1];
  bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  _l220:;
  k_ = k_ - ks_;
  ik_ = ik_ - k_;
  if (ks_ == 2) {
    ik_ = ik_ - (k_ + 1);
  }
  goto _l170;
  _l230:;
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  k_ = 1;
  ik_ = 0;
  _l240:;
  if (k_ > (*n_)) {
    goto _l270;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == 1) {
    goto _l260;
  }
  z_[k_ - 1] = z_[k_ - 1] + _ddot (($6_ = k_ - 1, &$6_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
  ikp1_ = ik_ + k_;
  if (ks_ == 2) {
    z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _ddot (($7_ = k_ - 1, &$7_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l250;
  }
  t_ = z_[k_ - 1];
  z_[k_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l250:;
  _l260:;
  ik_ = ik_ + k_;
  if (ks_ == 2) {
    ik_ = ik_ + (k_ + 1);
  }
  k_ = k_ + ks_;
  goto _l240;
  _l270:;
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[80].calls++;
  return 0;
}

int_4 _dspdi (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ det_, int_4 _p_ inert_, real_8 _p_ work_, int_4 
_p_ job_)
{
  static int_4 ij_, ik_, ikp1_, iks_, j_, jb_, jk_, jkp1_, k_, kk_, kkp1_, km1_, ks_, ksj_, kskp1_, kstep_;
  static logical_4 noinv_, nodet_, noert_;
  static real_8 akkp1_, temp_, ten_, d_, t_, ak_, akp1_;
  int_4 $0_, $1_, $2_;
  extern real_8 _ddot ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  noert_ = _imod ((*job_), 1000) / 100 == 0;
  if (nodet_ && noert_) {
    goto _l140;
  }
  if (noert_) {
    goto _l10;
  }
  inert_[0] = 0;
  inert_[1] = 0;
  inert_[2] = 0;
  _l10:;
  if (nodet_) {
    goto _l20;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  _l20:;
  t_ = 0.0;
  ik_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = ik_ + k_;
    d_ = ap_[kk_ - 1];
    if (kpvt_[k_ - 1] > 0) {
      goto _l50;
    }
    if (t_ != 0.0e0) {
      goto _l30;
    }
    ikp1_ = ik_ + k_;
    kkp1_ = ikp1_ + k_;
    t_ = _abs (ap_[kkp1_ - 1]);
    d_ = (d_ / t_) * ap_[kkp1_ + 1 - 1] - t_;
    goto _l40;
    _l30:;
    d_ = t_;
    t_ = 0.0;
    _l40:;
    _l50:;
    if (noert_) {
      goto _l60;
    }
    if (d_ > 0.0e0) {
      inert_[0] = inert_[0] + 1;
    }
    if (d_ < 0.0e0) {
      inert_[1] = inert_[1] + 1;
    }
    if (d_ == 0.0e0) {
      inert_[2] = inert_[2] + 1;
    }
    _l60:;
    if (nodet_) {
      goto _l120;
    }
    det_[0] = d_ * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l110;
    }
    _l70:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l80;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l70;
    _l80:;
    _l90:;
    if (_abs (det_[0]) < ten_) {
      goto _l100;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l90;
    _l100:;
    _l110:;
    _l120:;
    ik_ = ik_ + k_;
  }
  _l140:;
  if (noinv_) {
    goto _l270;
  }
  k_ = 1;
  ik_ = 0;
  _l150:;
  if (k_ > (*n_)) {
    goto _l260;
  }
  km1_ = k_ - 1;
  kk_ = ik_ + k_;
  ikp1_ = ik_ + k_;
  kkp1_ = ikp1_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l180;
  }
  ap_[kk_ - 1] = 1.0e0 / ap_[kk_ - 1];
  if (km1_ < 1) {
    goto _l170;
  }
  (void) _dcopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jk_ = ik_ + j_;
    ap_[jk_ - 1] = _ddot (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _daxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kk_ - 1] = ap_[kk_ - 1] + _ddot (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1);
  _l170:;
  kstep_ = 1;
  goto _l220;
  _l180:;
  t_ = _abs (ap_[kkp1_ - 1]);
  ak_ = ap_[kk_ - 1] / t_;
  akp1_ = ap_[kkp1_ + 1 - 1] / t_;
  akkp1_ = ap_[kkp1_ - 1] / t_;
  d_ = t_ * (ak_ * akp1_ - 1.0e0);
  ap_[kk_ - 1] = akp1_ / d_;
  ap_[kkp1_ + 1 - 1] = ak_ / d_;
  ap_[kkp1_ - 1] = -akkp1_ / d_;
  if (km1_ < 1) {
    goto _l210;
  }
  (void) _dcopy (&km1_, &ap_[ikp1_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jkp1_ = ikp1_ + j_;
    ap_[jkp1_ - 1] = _ddot (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _daxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kkp1_ + 1 - 1] = ap_[kkp1_ + 1 - 1] + _ddot (&km1_, work_, &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
  ap_[kkp1_ - 1] = ap_[kkp1_ - 1] + _ddot (&km1_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
  (void) _dcopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jk_ = ik_ + j_;
    ap_[jk_ - 1] = _ddot (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _daxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kk_ - 1] = ap_[kk_ - 1] + _ddot (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1);
  _l210:;
  kstep_ = 2;
  _l220:;
  ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (ks_ == k_) {
    goto _l250;
  }
  iks_ = (ks_ * (ks_ - 1)) / 2;
  (void) _dswap (&ks_, &ap_[iks_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  ksj_ = ik_ + ks_;
  for (jb_ = ks_; jb_ <= k_; (jb_)++) {
    j_ = k_ + ks_ - jb_;
    jk_ = ik_ + j_;
    temp_ = ap_[jk_ - 1];
    ap_[jk_ - 1] = ap_[ksj_ - 1];
    ap_[ksj_ - 1] = temp_;
    ksj_ = ksj_ - (j_ - 1);
  }
  if (kstep_ == 1) {
    goto _l240;
  }
  kskp1_ = ikp1_ + ks_;
  temp_ = ap_[kskp1_ - 1];
  ap_[kskp1_ - 1] = ap_[kkp1_ - 1];
  ap_[kkp1_ - 1] = temp_;
  _l240:;
  _l250:;
  ik_ = ik_ + k_;
  if (kstep_ == 2) {
    ik_ = ik_ + k_ + 1;
  }
  k_ = k_ + kstep_;
  goto _l150;
  _l260:;
  _l270:;
  __calls[81].calls++;
  return 0;
}

int_4 _dspfa (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 ij_, ijj_, ik_, ikm1_, im_, imax_, imaxp1_, imim_, imj_, imk_, j_, jj_, jk_, jkm1_, jmax_, jmim_, k_, kk_, 
  km1_, km1k_, km1km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_8 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, absakk_, alpha_, colmax_, rowmax_;
  int_4 $0_, $1_;
  extern int_4 _idamax ();
  alpha_ = 6.4038820320220756e-1;
  (*info_) = 0;
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (ap_[0] == 0.0e0) {
    (*info_) = 1;
  }
  goto _l200;
  _l20:;
  km1_ = k_ - 1;
  kk_ = ik_ + k_;
  absakk_ = _abs (ap_[kk_ - 1]);
  imax_ = _idamax (($0_ = k_ - 1, &$0_), &ap_[ik_ + 1 - 1], &_k1);
  imk_ = ik_ + imax_;
  colmax_ = _abs (ap_[imk_ - 1]);
  if (absakk_ < alpha_ * colmax_) {
    goto _l30;
  }
  kstep_ = 1;
  swap_ = FALSE;
  goto _l90;
  _l30:;
  rowmax_ = 0.0;
  imaxp1_ = imax_ + 1;
  im_ = imax_ * (imax_ - 1) / 2;
  imj_ = im_ + 2 * imax_;
  for (j_ = imaxp1_; j_ <= k_; (j_)++) {
    rowmax_ = _max (rowmax_, _abs (ap_[imj_ - 1]));
    imj_ = imj_ + j_;
  }
  if (imax_ == 1) {
    goto _l50;
  }
  jmax_ = _idamax (($1_ = imax_ - 1, &$1_), &ap_[im_ + 1 - 1], &_k1);
  jmim_ = jmax_ + im_;
  rowmax_ = _max (rowmax_, _abs (ap_[jmim_ - 1]));
  _l50:;
  imim_ = imax_ + im_;
  if (_abs (ap_[imim_ - 1]) < alpha_ * rowmax_) {
    goto _l60;
  }
  kstep_ = 1;
  swap_ = TRUE;
  goto _l80;
  _l60:;
  if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
    goto _l70;
  }
  kstep_ = 1;
  swap_ = FALSE;
  goto _l80;
  _l70:;
  kstep_ = 2;
  swap_ = imax_ != km1_;
  _l80:;
  _l90:;
  if (_max (absakk_, colmax_) != 0.0e0) {
    goto _l100;
  }
  kpvt_[k_ - 1] = k_;
  (*info_) = k_;
  goto _l190;
  _l100:;
  if (kstep_ == 2) {
    goto _l140;
  }
  if (! (swap_)) {
    goto _l120;
  }
  (void) _dswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  imj_ = ik_ + imax_;
  for (jj_ = imax_; jj_ <= k_; (jj_)++) {
    j_ = k_ + imax_ - jj_;
    jk_ = ik_ + j_;
    t_ = ap_[jk_ - 1];
    ap_[jk_ - 1] = ap_[imj_ - 1];
    ap_[imj_ - 1] = t_;
    imj_ = imj_ - (j_ - 1);
  }
  _l120:;
  ij_ = ik_ - (k_ - 1);
  for (jj_ = 1; jj_ <= km1_; (jj_)++) {
    j_ = k_ - jj_;
    jk_ = ik_ + j_;
    mulk_ = -ap_[jk_ - 1] / ap_[kk_ - 1];
    t_ = mulk_;
    (void) _daxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
    ijj_ = ij_ + j_;
    ap_[jk_ - 1] = mulk_;
    ij_ = ij_ - (j_ - 1);
  }
  kpvt_[k_ - 1] = k_;
  if (swap_) {
    kpvt_[k_ - 1] = imax_;
  }
  goto _l190;
  _l140:;
  km1k_ = ik_ + k_ - 1;
  ikm1_ = ik_ - (k_ - 1);
  if (! (swap_)) {
    goto _l160;
  }
  (void) _dswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ikm1_ + 1 - 1], &_k1);
  imj_ = ikm1_ + imax_;
  for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
    j_ = km1_ + imax_ - jj_;
    jkm1_ = ikm1_ + j_;
    t_ = ap_[jkm1_ - 1];
    ap_[jkm1_ - 1] = ap_[imj_ - 1];
    ap_[imj_ - 1] = t_;
    imj_ = imj_ - (j_ - 1);
  }
  t_ = ap_[km1k_ - 1];
  ap_[km1k_ - 1] = ap_[imk_ - 1];
  ap_[imk_ - 1] = t_;
  _l160:;
  km2_ = k_ - 2;
  if (km2_ == 0) {
    goto _l180;
  }
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  km1km1_ = ikm1_ + k_ - 1;
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  denom_ = 1.0e0 - ak_ * akm1_;
  ij_ = ik_ - (k_ - 1) - (k_ - 2);
  for (jj_ = 1; jj_ <= km2_; (jj_)++) {
    j_ = km1_ - jj_;
    jk_ = ik_ + j_;
    bk_ = ap_[jk_ - 1] / ap_[km1k_ - 1];
    jkm1_ = ikm1_ + j_;
    bkm1_ = ap_[jkm1_ - 1] / ap_[km1k_ - 1];
    mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
    mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
    t_ = mulk_;
    (void) _daxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
    t_ = mulkm1_;
    (void) _daxpy (&j_, &t_, &ap_[ikm1_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
    ap_[jk_ - 1] = mulk_;
    ap_[jkm1_ - 1] = mulkm1_;
    ijj_ = ij_ + j_;
    ij_ = ij_ - (j_ - 1);
  }
  _l180:;
  kpvt_[k_ - 1] = 1 - k_;
  if (swap_) {
    kpvt_[k_ - 1] = -imax_;
  }
  kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
  _l190:;
  ik_ = ik_ - (k_ - 1);
  if (kstep_ == 2) {
    ik_ = ik_ - (k_ - 2);
  }
  k_ = k_ - kstep_;
  goto _l10;
  _l200:;
  __calls[82].calls++;
  return 0;
}

int_4 _dspsl (real_8 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ b_)
{
  static int_4 ik_, ikm1_, ikp1_, k_, kk_, km1k_, km1km1_, kp_;
  static real_8 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern real_8 _ddot ();
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  kk_ = ik_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _daxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
  k_ = k_ - 1;
  ik_ = ik_ - k_;
  goto _l70;
  _l40:;
  ikm1_ = ik_ - (k_ - 1);
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _daxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  (void) _daxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l60:;
  km1k_ = ik_ + k_ - 1;
  kk_ = ik_ + k_;
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  km1km1_ = ikm1_ + k_ - 1;
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = b_[k_ - 1] / ap_[km1k_ - 1];
  bkm1_ = b_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  ik_ = ik_ - (k_ + 1) - k_;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  ik_ = 0;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _ddot (($3_ = k_ - 1, &$3_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  ik_ = ik_ + k_;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _ddot (($4_ = k_ - 1, &$4_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  ikp1_ = ik_ + k_;
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _ddot (($5_ = k_ - 1, &$5_), &ap_[ikp1_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  ik_ = ik_ + k_ + k_ + 1;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[83].calls++;
  return 0;
}

int_4 _dsvdc (real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, real_8 _p_ s_, real_8 _p_ e_, real_8 _p_ u_, 
int_4 _p_ ldu_, real_8 _p_ v_, int_4 _p_ ldv_, real_8 _p_ work_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, iter_, j_, jobu_, k_, kase_, kk_, l_, ll_, lls_, lm1_, lp1_, ls_, lu_, m_, maxit_, mm_, mm1_, mp1_, 
  nct_, nctp1_, ncu_, nrt_, nrtp1_;
  static logical_4 wantu_, wantv_;
  static real_8 t_, r_, b_, c_, cs_, el_, emm1_, f_, g_, scale_, shift_, sl_, sm_, sn_, smm1_, t1_, test_, ztest_;
  int_4 $0_, $1_, $3_, $4_, $5_, $6_, $8_, $9_, $11_, $12_, $13_, $15_, $16_;
  real_8 $2_, $7_, $10_, $14_, $17_, $18_, $19_;
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  maxit_ = 30;
  wantu_ = FALSE;
  wantv_ = FALSE;
  jobu_ = _imod ((*job_), 100) / 10;
  ncu_ = (*n_);
  if (jobu_ > 1) {
    ncu_ = _min ((*n_), (*p_));
  }
  if (jobu_ != 0) {
    wantu_ = TRUE;
  }
  if (_imod ((*job_), 10) != 0) {
    wantv_ = TRUE;
  }
  (*info_) = 0;
  nct_ = _min ((*n_) - 1, (*p_));
  nrt_ = _max (0, _min ((*p_) - 2, (*n_)));
  lu_ = _max (nct_, nrt_);
  if (lu_ < 1) {
    goto _l170;
  }
  for (l_ = 1; l_ <= lu_; (l_)++) {
    lp1_ = l_ + 1;
    if (l_ > nct_) {
      goto _l20;
    }
    s_[l_ - 1] = _dnrm2 (($0_ = (*n_) - l_ + 1, &$0_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1);
    if (s_[l_ - 1] == 0.0e0) {
      goto _l10;
    }
    if (x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] != 0.0e0) {
      s_[l_ - 1] = _sign (s_[l_ - 1], x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]);
    }
    (void) _dscal (($1_ = (*n_) - l_ + 1, &$1_), ($2_ = 1.0e0 / s_[l_ - 1], &$2_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], 
    &_k1);
    x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = 1.0e0 + x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
    _l10:;
    s_[l_ - 1] = -s_[l_ - 1];
    _l20:;
    if ((*p_) < lp1_) {
      goto _l50;
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      if (l_ > nct_) {
        goto _l30;
      }
      if (s_[l_ - 1] == 0.0e0) {
        goto _l30;
      }
      t_ = -_ddot (($3_ = (*n_) - l_ + 1, &$3_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * ((j_ - 
      1))], &_k1) / x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
      (void) _daxpy (($4_ = (*n_) - l_ + 1, &$4_), &t_, &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * 
      ((j_ - 1))], &_k1);
      _l30:;
      e_[j_ - 1] = x_[l_ - 1 + ((*ldx_)) * ((j_ - 1))];
    }
    _l50:;
    if (! (wantu_) || l_ > nct_) {
      goto _l70;
    }
    for (i_ = l_; i_ <= (*n_); (i_)++) {
      u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((l_ - 1))];
    }
    _l70:;
    if (l_ > nrt_) {
      goto _l150;
    }
    e_[l_ - 1] = _dnrm2 (($5_ = (*p_) - l_, &$5_), &e_[lp1_ - 1], &_k1);
    if (e_[l_ - 1] == 0.0e0) {
      goto _l80;
    }
    if (e_[lp1_ - 1] != 0.0e0) {
      e_[l_ - 1] = _sign (e_[l_ - 1], e_[lp1_ - 1]);
    }
    (void) _dscal (($6_ = (*p_) - l_, &$6_), ($7_ = 1.0e0 / e_[l_ - 1], &$7_), &e_[lp1_ - 1], &_k1);
    e_[lp1_ - 1] = 1.0e0 + e_[lp1_ - 1];
    _l80:;
    e_[l_ - 1] = -e_[l_ - 1];
    if (lp1_ > (*n_) || e_[l_ - 1] == 0.0e0) {
      goto _l120;
    }
    for (i_ = lp1_; i_ <= (*n_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      (void) _daxpy (($8_ = (*n_) - l_, &$8_), &e_[j_ - 1], &x_[lp1_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &work_[lp1_ - 1], 
      &_k1);
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      (void) _daxpy (($9_ = (*n_) - l_, &$9_), ($10_ = -e_[j_ - 1] / e_[lp1_ - 1], &$10_), &work_[lp1_ - 1], &_k1, &x_[lp1_ - 
      1 + ((*ldx_)) * ((j_ - 1))], &_k1);
    }
    _l120:;
    if (! (wantv_)) {
      goto _l140;
    }
    for (i_ = lp1_; i_ <= (*p_); (i_)++) {
      v_[i_ - 1 + ((*ldv_)) * ((l_ - 1))] = e_[i_ - 1];
    }
    _l140:;
    _l150:;
  }
  _l170:;
  m_ = _min ((*p_), (*n_) + 1);
  nctp1_ = nct_ + 1;
  nrtp1_ = nrt_ + 1;
  if (nct_ < (*p_)) {
    s_[nctp1_ - 1] = x_[nctp1_ - 1 + ((*ldx_)) * ((nctp1_ - 1))];
  }
  if ((*n_) < m_) {
    s_[m_ - 1] = 0.0;
  }
  if (nrtp1_ < m_) {
    e_[nrtp1_ - 1] = x_[nrtp1_ - 1 + ((*ldx_)) * ((m_ - 1))];
  }
  e_[m_ - 1] = 0.0;
  if (! (wantu_)) {
    goto _l300;
  }
  if (ncu_ < nctp1_) {
    goto _l200;
  }
  for (j_ = nctp1_; j_ <= ncu_; (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      u_[i_ - 1 + ((*ldu_)) * ((j_ - 1))] = 0.0;
    }
    u_[j_ - 1 + ((*ldu_)) * ((j_ - 1))] = 1.0;
  }
  _l200:;
  if (nct_ < 1) {
    goto _l290;
  }
  for (ll_ = 1; ll_ <= nct_; (ll_)++) {
    l_ = nct_ - ll_ + 1;
    if (s_[l_ - 1] == 0.0e0) {
      goto _l250;
    }
    lp1_ = l_ + 1;
    if (ncu_ < lp1_) {
      goto _l220;
    }
    for (j_ = lp1_; j_ <= ncu_; (j_)++) {
      t_ = -_ddot (($11_ = (*n_) - l_ + 1, &$11_), &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[l_ - 1 + ((*ldu_)) * ((j_ 
      - 1))], &_k1) / u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))];
      (void) _daxpy (($12_ = (*n_) - l_ + 1, &$12_), &t_, &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[l_ - 1 + ((*ldu_)) 
      * ((j_ - 1))], &_k1);
    }
    _l220:;
    (void) _dscal (($13_ = (*n_) - l_ + 1, &$13_), ($14_ = -1.0, &$14_), &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1);
    u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))] = 1.0e0 + u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))];
    lm1_ = l_ - 1;
    if (lm1_ < 1) {
      goto _l240;
    }
    for (i_ = 1; i_ <= lm1_; (i_)++) {
      u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = 0.0;
    }
    _l240:;
    goto _l270;
    _l250:;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = 0.0;
    }
    u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))] = 1.0;
    _l270:;
  }
  _l290:;
  _l300:;
  if (! (wantv_)) {
    goto _l350;
  }
  for (ll_ = 1; ll_ <= (*p_); (ll_)++) {
    l_ = (*p_) - ll_ + 1;
    lp1_ = l_ + 1;
    if (l_ > nrt_) {
      goto _l320;
    }
    if (e_[l_ - 1] == 0.0e0) {
      goto _l320;
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      t_ = -_ddot (($15_ = (*p_) - l_, &$15_), &v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[lp1_ - 1 + ((*ldv_)) * ((j_ 
      - 1))], &_k1) / v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))];
      (void) _daxpy (($16_ = (*p_) - l_, &$16_), &t_, &v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[lp1_ - 1 + ((*ldv_)) 
      * ((j_ - 1))], &_k1);
    }
    _l320:;
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      v_[i_ - 1 + ((*ldv_)) * ((l_ - 1))] = 0.0;
    }
    v_[l_ - 1 + ((*ldv_)) * ((l_ - 1))] = 1.0;
  }
  _l350:;
  mm_ = m_;
  iter_ = 0;
  _l360:;
  if (m_ == 0) {
    goto _l620;
  }
  if (iter_ < maxit_) {
    goto _l370;
  }
  (*info_) = m_;
  goto _l620;
  _l370:;
  for (ll_ = 1; ll_ <= m_; (ll_)++) {
    l_ = m_ - ll_;
    if (l_ == 0) {
      goto _l400;
    }
    test_ = _abs (s_[l_ - 1]) + _abs (s_[l_ + 1 - 1]);
    ztest_ = test_ + _abs (e_[l_ - 1]);
    if (ztest_ != test_) {
      goto _l380;
    }
    e_[l_ - 1] = 0.0;
    goto _l400;
    _l380:;
  }
  _l400:;
  if (l_ != m_ - 1) {
    goto _l410;
  }
  kase_ = 4;
  goto _l480;
  _l410:;
  lp1_ = l_ + 1;
  mp1_ = m_ + 1;
  for (lls_ = lp1_; lls_ <= mp1_; (lls_)++) {
    ls_ = m_ - lls_ + lp1_;
    if (ls_ == l_) {
      goto _l440;
    }
    test_ = 0.0;
    if (ls_ != m_) {
      test_ = test_ + _abs (e_[ls_ - 1]);
    }
    if (ls_ != l_ + 1) {
      test_ = test_ + _abs (e_[ls_ - 1 - 1]);
    }
    ztest_ = test_ + _abs (s_[ls_ - 1]);
    if (ztest_ != test_) {
      goto _l420;
    }
    s_[ls_ - 1] = 0.0;
    goto _l440;
    _l420:;
  }
  _l440:;
  if (ls_ != l_) {
    goto _l450;
  }
  kase_ = 3;
  goto _l470;
  _l450:;
  if (ls_ != m_) {
    goto _l460;
  }
  kase_ = 1;
  goto _l470;
  _l460:;
  kase_ = 2;
  l_ = ls_;
  _l470:;
  _l480:;
  l_ = l_ + 1;
  switch (kase_) {
    default:
    case 1: goto _l490;
    case 2: goto _l520;
    case 3: goto _l540;
    case 4: goto _l570;
  }
  _l490:;
  mm1_ = m_ - 1;
  f_ = e_[m_ - 1 - 1];
  e_[m_ - 1 - 1] = 0.0;
  for (kk_ = l_; kk_ <= mm1_; (kk_)++) {
    k_ = mm1_ - kk_ + l_;
    t1_ = s_[k_ - 1];
    (void) _drotg (&t1_, &f_, &cs_, &sn_);
    s_[k_ - 1] = t1_;
    if (k_ == l_) {
      goto _l500;
    }
    f_ = -sn_ * e_[k_ - 1 - 1];
    e_[k_ - 1 - 1] = cs_ * e_[k_ - 1 - 1];
    _l500:;
    if (wantv_) {
      (void) _drot (p_, &v_[0 + ((*ldv_)) * ((k_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((m_ - 1))], &_k1, &cs_, &sn_);
    }
  }
  goto _l610;
  _l520:;
  f_ = e_[l_ - 1 - 1];
  e_[l_ - 1 - 1] = 0.0;
  for (k_ = l_; k_ <= m_; (k_)++) {
    t1_ = s_[k_ - 1];
    (void) _drotg (&t1_, &f_, &cs_, &sn_);
    s_[k_ - 1] = t1_;
    f_ = -sn_ * e_[k_ - 1];
    e_[k_ - 1] = cs_ * e_[k_ - 1];
    if (wantu_) {
      (void) _drot (n_, &u_[0 + ((*ldu_)) * ((k_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((l_ - 1 - 1))], &_k1, &cs_, &sn_);
    }
  }
  goto _l610;
  _l540:;
  scale_ = ($17_ = _max (_abs (s_[m_ - 1]), _abs (s_[m_ - 1 - 1])), $17_ = _max ($17_, _abs (e_[m_ - 1 - 1])), $17_ = 
  _max ($17_, _abs (s_[l_ - 1])), _max ($17_, _abs (e_[l_ - 1])));
  sm_ = s_[m_ - 1] / scale_;
  smm1_ = s_[m_ - 1 - 1] / scale_;
  emm1_ = e_[m_ - 1 - 1] / scale_;
  sl_ = s_[l_ - 1] / scale_;
  el_ = e_[l_ - 1] / scale_;
  b_ = ((smm1_ + sm_) * (smm1_ - sm_) + (emm1_ * emm1_)) / 2.0e0;
  c_ = ($18_ = (sm_ * emm1_), $18_ * $18_);
  shift_ = 0.0;
  if (b_ == 0.0e0 && c_ == 0.0e0) {
    goto _l550;
  }
  shift_ = sqrt ((b_ * b_) + c_);
  if (b_ < 0.0e0) {
    shift_ = -shift_;
  }
  shift_ = c_ / (b_ + shift_);
  _l550:;
  f_ = (sl_ + sm_) * (sl_ - sm_) + shift_;
  g_ = sl_ * el_;
  mm1_ = m_ - 1;
  for (k_ = l_; k_ <= mm1_; (k_)++) {
    (void) _drotg (&f_, &g_, &cs_, &sn_);
    if (k_ != l_) {
      e_[k_ - 1 - 1] = f_;
    }
    f_ = cs_ * s_[k_ - 1] + sn_ * e_[k_ - 1];
    e_[k_ - 1] = cs_ * e_[k_ - 1] - sn_ * s_[k_ - 1];
    g_ = sn_ * s_[k_ + 1 - 1];
    s_[k_ + 1 - 1] = cs_ * s_[k_ + 1 - 1];
    if (wantv_) {
      (void) _drot (p_, &v_[0 + ((*ldv_)) * ((k_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((k_ + 1 - 1))], &_k1, &cs_, &sn_);
    }
    (void) _drotg (&f_, &g_, &cs_, &sn_);
    s_[k_ - 1] = f_;
    f_ = cs_ * e_[k_ - 1] + sn_ * s_[k_ + 1 - 1];
    s_[k_ + 1 - 1] = -sn_ * e_[k_ - 1] + cs_ * s_[k_ + 1 - 1];
    g_ = sn_ * e_[k_ + 1 - 1];
    e_[k_ + 1 - 1] = cs_ * e_[k_ + 1 - 1];
    if (wantu_ && k_ < (*n_)) {
      (void) _drot (n_, &u_[0 + ((*ldu_)) * ((k_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((k_ + 1 - 1))], &_k1, &cs_, &sn_);
    }
  }
  e_[m_ - 1 - 1] = f_;
  iter_ = iter_ + 1;
  goto _l610;
  _l570:;
  if (s_[l_ - 1] >= 0.0e0) {
    goto _l580;
  }
  s_[l_ - 1] = -s_[l_ - 1];
  if (wantv_) {
    (void) _dscal (p_, ($19_ = -1.0, &$19_), &v_[0 + ((*ldv_)) * ((l_ - 1))], &_k1);
  }
  _l580:;
  _l590:;
  if (l_ == mm_) {
    goto _l600;
  }
  if (s_[l_ - 1] >= s_[l_ + 1 - 1]) {
    goto _l600;
  }
  t_ = s_[l_ - 1];
  s_[l_ - 1] = s_[l_ + 1 - 1];
  s_[l_ + 1 - 1] = t_;
  if (wantv_ && l_ < (*p_)) {
    (void) _dswap (p_, &v_[0 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((l_ + 1 - 1))], &_k1);
  }
  if (wantu_ && l_ < (*n_)) {
    (void) _dswap (n_, &u_[0 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((l_ + 1 - 1))], &_k1);
  }
  l_ = l_ + 1;
  goto _l590;
  _l600:;
  iter_ = 0;
  m_ = m_ - 1;
  _l610:;
  goto _l360;
  _l620:;
  __calls[84].calls++;
  return 0;
}

int_4 _dtrco (real_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_8 _p_ rcond_, real_8 _p_ z_, int_4 _p_ job_)
{
  static int_4 i1_, j_, j1_, j2_, k_, kk_, l_;
  static logical_4 lower_;
  static real_8 w_, wk_, wkm_, ek_, tnorm_, ynorm_, s_, sm_;
  int_4 $0_;
  extern real_8 _dasum ();
  lower_ = (*job_) == 0;
  tnorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = j_;
    if (lower_) {
      l_ = (*n_) + 1 - j_;
    }
    i1_ = 1;
    if (lower_) {
      i1_ = j_;
    }
    tnorm_ = _max (tnorm_, _dasum (&l_, &t_[i1_ - 1 + ((*ldt_)) * ((j_ - 1))], &_k1));
  }
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
    k_ = kk_;
    if (lower_) {
      k_ = (*n_) + 1 - kk_;
    }
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= _abs (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))])) {
      goto _l30;
    }
    s_ = _abs (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]) / _abs (ek_ - z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l30:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    wk_ = wk_ / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    wkm_ = wkm_ / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    goto _l50;
    _l40:;
    wk_ = 1.0;
    wkm_ = 1.0;
    _l50:;
    if (kk_ == (*n_)) {
      goto _l90;
    }
    j1_ = k_ + 1;
    if (lower_) {
      j1_ = 1;
    }
    j2_ = (*n_);
    if (lower_) {
      j2_ = k_ - 1;
    }
    for (j_ = j1_; j_ <= j2_; (j_)++) {
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l80;
    }
    w_ = wkm_ - wk_;
    wk_ = wkm_;
    for (j_ = j1_; j_ <= j2_; (j_)++) {
      z_[j_ - 1] = z_[j_ - 1] + w_ * t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
    }
    _l80:;
    _l90:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
    k_ = (*n_) + 1 - kk_;
    if (lower_) {
      k_ = kk_;
    }
    if (_abs (z_[k_ - 1]) <= _abs (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))])) {
      goto _l110;
    }
    s_ = _abs (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
    (void) _dscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l110:;
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] != 0.0e0) {
      z_[k_ - 1] = z_[k_ - 1] / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    }
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0e0) {
      z_[k_ - 1] = 1.0;
    }
    i1_ = 1;
    if (lower_) {
      i1_ = k_ + 1;
    }
    if (kk_ >= (*n_)) {
      goto _l120;
    }
    w_ = -z_[k_ - 1];
    (void) _daxpy (($0_ = (*n_) - kk_, &$0_), &w_, &t_[i1_ - 1 + ((*ldt_)) * ((k_ - 1))], &_k1, &z_[i1_ - 1], &_k1);
    _l120:;
  }
  s_ = 1.0e0 / _dasum (n_, z_, &_k1);
  (void) _dscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (tnorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / tnorm_;
  }
  if (tnorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[85].calls++;
  return 0;
}

int_4 _dtrdi (real_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, j_, k_, kb_, km1_, kp1_;
  static real_8 temp_, ten_;
  int_4 $0_, $1_, $2_;
  if ((*job_) / 100 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = t_[i_ - 1 + ((*ldt_)) * ((i_ - 1))] * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l20;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (_abs (det_[0]) < ten_) {
      goto _l40;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_) / 10, 10) == 0) {
    goto _l170;
  }
  if (_imod ((*job_), 10) == 0) {
    goto _l120;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    (*info_) = k_;
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0e0) {
      goto _l110;
    }
    t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = 1.0e0 / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    temp_ = -t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    (void) _dscal (($0_ = k_ - 1, &$0_), &temp_, &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1);
    kp1_ = k_ + 1;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      temp_ = t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
      t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))] = 0.0;
      (void) _daxpy (&k_, &temp_, &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1);
    }
    _l90:;
  }
  (*info_) = 0;
  _l110:;
  goto _l160;
  _l120:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    (*info_) = k_;
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0e0) {
      goto _l180;
    }
    t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = 1.0e0 / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    temp_ = -t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    if (k_ != (*n_)) {
      (void) _dscal (($1_ = (*n_) - k_, &$1_), &temp_, &t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))], &_k1);
    }
    km1_ = k_ - 1;
    if (km1_ < 1) {
      goto _l140;
    }
    for (j_ = 1; j_ <= km1_; (j_)++) {
      temp_ = t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
      t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))] = 0.0;
      (void) _daxpy (($2_ = (*n_) - k_ + 1, &$2_), &temp_, &t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[k_ - 1 + ((*ldt_)) 
      * ((j_ - 1))], &_k1);
    }
    _l140:;
  }
  (*info_) = 0;
  _l160:;
  _l170:;
  _l180:;
  __calls[86].calls++;
  return 0;
}

int_4 _dtrsl (real_8 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 case_, j_, jj_;
  static real_8 temp_;
  int_4 $0_, $1_, $2_;
  extern real_8 _ddot ();
  for ((*info_) = 1; (*info_) <= (*n_); ((*info_))++) {
    if (t_[(*info_) - 1 + ((*ldt_)) * (((*info_) - 1))] == 0.0e0) {
      goto _l150;
    }
  }
  (*info_) = 0;
  case_ = 1;
  if (_imod ((*job_), 10) != 0) {
    case_ = 2;
  }
  if (_imod ((*job_), 100) / 10 != 0) {
    case_ = case_ + 2;
  }
  switch (case_) {
    default:
    case 1: goto _l20;
    case 2: goto _l50;
    case 3: goto _l80;
    case 4: goto _l110;
  }
  _l20:;
  b_[0] = b_[0] / t_[0 + ((*ldt_)) * ((0))];
  if ((*n_) < 2) {
    goto _l40;
  }
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    temp_ = -b_[j_ - 1 - 1];
    (void) _daxpy (($0_ = (*n_) - j_ + 1, &$0_), &temp_, &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &b_[j_ - 1], &_k1)
    ;
    b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
  }
  _l40:;
  goto _l140;
  _l50:;
  b_[(*n_) - 1] = b_[(*n_) - 1] / t_[(*n_) - 1 + ((*ldt_)) * (((*n_) - 1))];
  if ((*n_) < 2) {
    goto _l70;
  }
  for (jj_ = 2; jj_ <= (*n_); (jj_)++) {
    j_ = (*n_) - jj_ + 1;
    temp_ = -b_[j_ + 1 - 1];
    (void) _daxpy (&j_, &temp_, &t_[0 + ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &b_[0], &_k1);
    b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
  }
  _l70:;
  goto _l140;
  _l80:;
  b_[(*n_) - 1] = b_[(*n_) - 1] / t_[(*n_) - 1 + ((*ldt_)) * (((*n_) - 1))];
  if ((*n_) < 2) {
    goto _l100;
  }
  for (jj_ = 2; jj_ <= (*n_); (jj_)++) {
    j_ = (*n_) - jj_ + 1;
    b_[j_ - 1] = b_[j_ - 1] - _ddot (($1_ = jj_ - 1, &$1_), &t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))], &_k1, &b_[j_ + 1 - 
    1], &_k1);
    b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
  }
  _l100:;
  goto _l140;
  _l110:;
  b_[0] = b_[0] / t_[0 + ((*ldt_)) * ((0))];
  if ((*n_) < 2) {
    goto _l130;
  }
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    b_[j_ - 1] = b_[j_ - 1] - _ddot (($2_ = j_ - 1, &$2_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &b_[0], &_k1);
    b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
  }
  _l130:;
  _l140:;
  _l150:;
  __calls[87].calls++;
  return 0;
}

int_4 _schdc (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ p_, real_4 _p_ work_, int_4 _p_ jpvt_, int_4 _p_ job_, int_4 _p_ 
info_)
{
  static int_4 pu_, pl_, plp1_, i_, j_, jp_, jt_, k_, kb_, km1_, kp1_, l_, maxl_;
  static logical_4 swapk_, negk_;
  static real_4 temp_, maxdia_;
  int_4 $0_, $1_, $2_;
  pl_ = 1;
  pu_ = 0;
  (*info_) = (*p_);
  if ((*job_) == 0) {
    goto _l160;
  }
  for (k_ = 1; k_ <= (*p_); (k_)++) {
    swapk_ = jpvt_[k_ - 1] > 0;
    negk_ = jpvt_[k_ - 1] < 0;
    jpvt_[k_ - 1] = k_;
    if (negk_) {
      jpvt_[k_ - 1] = -jpvt_[k_ - 1];
    }
    if (! (swapk_)) {
      goto _l60;
    }
    if (k_ == pl_) {
      goto _l50;
    }
    (void) _sswap (($0_ = pl_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((pl_ - 1))], &_k1);
    temp_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[pl_ - 1 + ((*lda_)) * ((pl_ - 1))];
    a_[pl_ - 1 + ((*lda_)) * ((pl_ - 1))] = temp_;
    plp1_ = pl_ + 1;
    if ((*p_) < plp1_) {
      goto _l40;
    }
    for (j_ = plp1_; j_ <= (*p_); (j_)++) {
      if (j_ >= k_) {
        goto _l10;
      }
      temp_ = a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
      a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = temp_;
      goto _l20;
      _l10:;
      if (j_ == k_) {
        goto _l20;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l20:;
    }
    _l40:;
    jpvt_[k_ - 1] = jpvt_[pl_ - 1];
    jpvt_[pl_ - 1] = k_;
    _l50:;
    pl_ = pl_ + 1;
    _l60:;
  }
  pu_ = (*p_);
  if ((*p_) < pl_) {
    goto _l150;
  }
  for (kb_ = pl_; kb_ <= (*p_); (kb_)++) {
    k_ = (*p_) - kb_ + pl_;
    if (jpvt_[k_ - 1] >= 0) {
      goto _l130;
    }
    jpvt_[k_ - 1] = -jpvt_[k_ - 1];
    if (pu_ == k_) {
      goto _l120;
    }
    (void) _sswap (($1_ = k_ - 1, &$1_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((pu_ - 1))], &_k1);
    temp_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[pu_ - 1 + ((*lda_)) * ((pu_ - 1))];
    a_[pu_ - 1 + ((*lda_)) * ((pu_ - 1))] = temp_;
    kp1_ = k_ + 1;
    if ((*p_) < kp1_) {
      goto _l110;
    }
    for (j_ = kp1_; j_ <= (*p_); (j_)++) {
      if (j_ >= pu_) {
        goto _l80;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[j_ - 1 + ((*lda_)) * ((pu_ - 1))];
      a_[j_ - 1 + ((*lda_)) * ((pu_ - 1))] = temp_;
      goto _l90;
      _l80:;
      if (j_ == pu_) {
        goto _l90;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[pu_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pu_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l90:;
    }
    _l110:;
    jt_ = jpvt_[k_ - 1];
    jpvt_[k_ - 1] = jpvt_[pu_ - 1];
    jpvt_[pu_ - 1] = jt_;
    _l120:;
    pu_ = pu_ - 1;
    _l130:;
  }
  _l150:;
  _l160:;
  for (k_ = 1; k_ <= (*p_); (k_)++) {
    maxdia_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    kp1_ = k_ + 1;
    maxl_ = k_;
    if (k_ < pl_ || k_ >= pu_) {
      goto _l190;
    }
    for (l_ = kp1_; l_ <= pu_; (l_)++) {
      if (a_[l_ - 1 + ((*lda_)) * ((l_ - 1))] <= maxdia_) {
        goto _l170;
      }
      maxdia_ = a_[l_ - 1 + ((*lda_)) * ((l_ - 1))];
      maxl_ = l_;
      _l170:;
    }
    _l190:;
    if (maxdia_ > 0.0e0) {
      goto _l200;
    }
    (*info_) = k_ - 1;
    goto _l280;
    _l200:;
    if (k_ == maxl_) {
      goto _l210;
    }
    km1_ = k_ - 1;
    (void) _sswap (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((maxl_ - 1))], &_k1);
    a_[maxl_ - 1 + ((*lda_)) * ((maxl_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = maxdia_;
    jp_ = jpvt_[maxl_ - 1];
    jpvt_[maxl_ - 1] = jpvt_[k_ - 1];
    jpvt_[k_ - 1] = jp_;
    _l210:;
    work_[k_ - 1] = sqrtf (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = work_[k_ - 1];
    if ((*p_) < kp1_) {
      goto _l260;
    }
    for (j_ = kp1_; j_ <= (*p_); (j_)++) {
      if (k_ == maxl_) {
        goto _l240;
      }
      if (j_ >= maxl_) {
        goto _l220;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[j_ - 1 + ((*lda_)) * ((maxl_ - 1))];
      a_[j_ - 1 + ((*lda_)) * ((maxl_ - 1))] = temp_;
      goto _l230;
      _l220:;
      if (j_ == maxl_) {
        goto _l230;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[maxl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[maxl_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l230:;
      _l240:;
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] / work_[k_ - 1];
      work_[j_ - 1] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      temp_ = -a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      (void) _saxpy (($2_ = j_ - k_, &$2_), &temp_, &work_[kp1_ - 1], &_k1, &a_[kp1_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l260:;
  }
  _l280:;
  __calls[88].calls++;
  return 0;
}

int_4 _schdd (real_4 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, real_4 _p_ x_, real_4 _p_ z_, int_4 _p_ ldz_, int_4 _p_ nz_, 
real_4 _p_ y_, real_4 _p_ rho_, real_4 _p_ c_, real_4 _p_ s_, int_4 _p_ info_)
{
  static int_4 i_, ii_, j_;
  static real_4 a_, alpha_, azeta_, norm_, t_, zeta_, b_, xx_, scale_;
  int_4 $0_;
  real_4 $1_;
  extern real_4 _snrm2 ();
  extern real_4 _sdot ();
  (*info_) = 0;
  s_[0] = x_[0] / r_[0 + ((*ldr_)) * ((0))];
  if ((*p_) < 2) {
    goto _l20;
  }
  for (j_ = 2; j_ <= (*p_); (j_)++) {
    s_[j_ - 1] = x_[j_ - 1] - _sdot (($0_ = j_ - 1, &$0_), &r_[0 + ((*ldr_)) * ((j_ - 1))], &_k1, s_, &_k1);
    s_[j_ - 1] = s_[j_ - 1] / r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))];
  }
  _l20:;
  norm_ = _snrm2 (p_, s_, &_k1);
  if (norm_ < 1.0e0) {
    goto _l30;
  }
  (*info_) = -1;
  goto _l120;
  _l30:;
  alpha_ = sqrtf (1.0e0 - (norm_ * norm_));
  for (ii_ = 1; ii_ <= (*p_); (ii_)++) {
    i_ = (*p_) - ii_ + 1;
    scale_ = alpha_ + _abs (s_[i_ - 1]);
    a_ = alpha_ / scale_;
    b_ = s_[i_ - 1] / scale_;
    norm_ = sqrtf ((a_ * a_) + (b_ * b_) + (0.0e0 * 0.0e0));
    c_[i_ - 1] = a_ / norm_;
    s_[i_ - 1] = b_ / norm_;
    alpha_ = scale_ * norm_;
  }
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    xx_ = 0.0;
    for (ii_ = 1; ii_ <= j_; (ii_)++) {
      i_ = j_ - ii_ + 1;
      t_ = c_[i_ - 1] * xx_ + s_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = c_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] - s_[i_ - 1] * xx_;
      xx_ = t_;
    }
  }
  if ((*nz_) < 1) {
    goto _l110;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    zeta_ = y_[j_ - 1];
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = (z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] - s_[i_ - 1] * zeta_) / c_[i_ - 1];
      zeta_ = c_[i_ - 1] * zeta_ - s_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
    }
    azeta_ = _abs (zeta_);
    if (azeta_ <= rho_[j_ - 1]) {
      goto _l80;
    }
    (*info_) = 1;
    rho_[j_ - 1] = -1.0;
    goto _l90;
    _l80:;
    rho_[j_ - 1] = rho_[j_ - 1] * sqrtf (1.0e0 - ($1_ = (azeta_ / rho_[j_ - 1]), $1_ * $1_));
    _l90:;
  }
  _l110:;
  _l120:;
  __calls[89].calls++;
  return 0;
}

int_4 _schex (real_4 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, int_4 _p_ k_, int_4 _p_ l_, real_4 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ nz_, real_4 _p_ c_, real_4 _p_ s_, int_4 _p_ job_)
{
  static int_4 i_, ii_, il_, iu_, j_, jj_, km1_, kp1_, lmk_, lm1_;
  static real_4 rjp1j_, t_;
  km1_ = (*k_) - 1;
  kp1_ = (*k_) + 1;
  lmk_ = (*l_) - (*k_);
  lm1_ = (*l_) - 1;
  switch ((*job_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l130;
  }
  _l10:;
  for (i_ = 1; i_ <= (*l_); (i_)++) {
    ii_ = (*l_) - i_ + 1;
    s_[i_ - 1] = r_[ii_ - 1 + ((*ldr_)) * (((*l_) - 1))];
  }
  for (jj_ = (*k_); jj_ <= lm1_; (jj_)++) {
    j_ = lm1_ - jj_ + (*k_);
    for (i_ = 1; i_ <= j_; (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ + 1 - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
    }
    r_[j_ + 1 - 1 + ((*ldr_)) * ((j_ + 1 - 1))] = 0.0;
  }
  if ((*k_) == 1) {
    goto _l60;
  }
  for (i_ = 1; i_ <= km1_; (i_)++) {
    ii_ = (*l_) - i_ + 1;
    r_[i_ - 1 + ((*ldr_)) * (((*k_) - 1))] = s_[ii_ - 1];
  }
  _l60:;
  t_ = s_[0];
  for (i_ = 1; i_ <= lmk_; (i_)++) {
    (void) _srotg (&s_[i_ + 1 - 1], &t_, &c_[i_ - 1], &s_[i_ - 1]);
    t_ = s_[i_ + 1 - 1];
  }
  r_[(*k_) - 1 + ((*ldr_)) * (((*k_) - 1))] = t_;
  for (j_ = kp1_; j_ <= (*p_); (j_)++) {
    il_ = _max (1, (*l_) - j_ + 1);
    for (ii_ = il_; ii_ <= lmk_; (ii_)++) {
      i_ = (*l_) - ii_;
      t_ = c_[ii_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] = c_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] - s_[ii_ - 1] * r_[i_ - 
      1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
  }
  if ((*nz_) < 1) {
    goto _l120;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    for (ii_ = 1; ii_ <= lmk_; (ii_)++) {
      i_ = (*l_) - ii_;
      t_ = c_[ii_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] = c_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] - s_[ii_ - 1] * z_[i_ - 
      1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
  }
  _l120:;
  goto _l260;
  _l130:;
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    ii_ = lmk_ + i_;
    s_[ii_ - 1] = r_[i_ - 1 + ((*ldr_)) * (((*k_) - 1))];
  }
  for (j_ = (*k_); j_ <= lm1_; (j_)++) {
    for (i_ = 1; i_ <= j_; (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ + 1 - 1))];
    }
    jj_ = j_ - km1_;
    s_[jj_ - 1] = r_[j_ + 1 - 1 + ((*ldr_)) * ((j_ + 1 - 1))];
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    ii_ = lmk_ + i_;
    r_[i_ - 1 + ((*ldr_)) * (((*l_) - 1))] = s_[ii_ - 1];
  }
  for (i_ = kp1_; i_ <= (*l_); (i_)++) {
    r_[i_ - 1 + ((*ldr_)) * (((*l_) - 1))] = 0.0;
  }
  for (j_ = (*k_); j_ <= (*p_); (j_)++) {
    if (j_ == (*k_)) {
      goto _l200;
    }
    iu_ = _min (j_ - 1, (*l_) - 1);
    for (i_ = (*k_); i_ <= iu_; (i_)++) {
      ii_ = i_ - (*k_) + 1;
      t_ = c_[ii_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] = c_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] - s_[ii_ - 1] * r_[i_ - 
      1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
    _l200:;
    if (j_ >= (*l_)) {
      goto _l210;
    }
    jj_ = j_ - (*k_) + 1;
    t_ = s_[jj_ - 1];
    (void) _srotg (&r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))], &t_, &c_[jj_ - 1], &s_[jj_ - 1]);
    _l210:;
  }
  if ((*nz_) < 1) {
    goto _l250;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    for (i_ = (*k_); i_ <= lm1_; (i_)++) {
      ii_ = i_ - km1_;
      t_ = c_[ii_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] = c_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] - s_[ii_ - 1] * z_[i_ - 
      1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
  }
  _l250:;
  _l260:;
  __calls[90].calls++;
  return 0;
}

int_4 _schud (real_4 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, real_4 _p_ x_, real_4 _p_ z_, int_4 _p_ ldz_, int_4 _p_ nz_, 
real_4 _p_ y_, real_4 _p_ rho_, real_4 _p_ c_, real_4 _p_ s_)
{
  static int_4 i_, j_, jm1_;
  static real_4 azeta_, scale_, t_, xj_, zeta_;
  real_4 $0_, $1_;
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    xj_ = x_[j_ - 1];
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      t_ = c_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[i_ - 1] * xj_;
      xj_ = c_[i_ - 1] * xj_ - s_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
    _l20:;
    (void) _srotg (&r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))], &xj_, &c_[j_ - 1], &s_[j_ - 1]);
  }
  if ((*nz_) < 1) {
    goto _l70;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    zeta_ = y_[j_ - 1];
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      t_ = c_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[i_ - 1] * zeta_;
      zeta_ = c_[i_ - 1] * zeta_ - s_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
    azeta_ = _abs (zeta_);
    if (azeta_ == 0.0e0 || rho_[j_ - 1] < 0.0e0) {
      goto _l50;
    }
    scale_ = azeta_ + rho_[j_ - 1];
    rho_[j_ - 1] = scale_ * sqrtf (($0_ = (azeta_ / scale_), $0_ * $0_) + ($1_ = (rho_[j_ - 1] / scale_), $1_ * $1_));
    _l50:;
  }
  _l70:;
  __calls[91].calls++;
  return 0;
}

int_4 _sgbco (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_4 _p_ 
rcond_, real_4 _p_ z_)
{
  static int_4 is_, info_, j_, ju_, k_, kb_, kp1_, l_, la_, lm_, lz_, m_, mm_;
  static real_4 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  extern real_4 _sdot ();
  extern real_4 _sasum ();
  anorm_ = 0.0;
  l_ = (*ml_) + 1;
  is_ = l_ + (*mu_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _sasum (&l_, &abd_[is_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1));
    if (is_ > (*ml_) + 1) {
      is_ = is_ - 1;
    }
    if (j_ <= (*mu_)) {
      l_ = l_ + 1;
    }
    if (j_ >= (*n_) - (*ml_)) {
      l_ = l_ - 1;
    }
  }
  (void) _sgbfa (abd_, lda_, n_, ml_, mu_, ipvt_, &info_);
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  m_ = (*ml_) + (*mu_) + 1;
  ju_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= _abs (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))])) {
      goto _l30;
    }
    s_ = _abs (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (ek_ - z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l30:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    if (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    wk_ = wk_ / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    wkm_ = wkm_ / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    goto _l50;
    _l40:;
    wk_ = 1.0;
    wkm_ = 1.0;
    _l50:;
    kp1_ = k_ + 1;
    ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
    mm_ = m_;
    if (kp1_ > ju_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= ju_; (j_)++) {
      mm_ = mm_ - 1;
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l80;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    mm_ = m_;
    for (j_ = kp1_; j_ <= ju_; (j_)++) {
      mm_ = mm_ - 1;
      z_[j_ - 1] = z_[j_ - 1] + t_ * abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))];
    }
    _l80:;
    _l90:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    lm_ = _min ((*ml_), (*n_) - k_);
    if (k_ < (*n_)) {
      z_[k_ - 1] = z_[k_ - 1] + _sdot (&lm_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
    }
    if (_abs (z_[k_ - 1]) <= 1.0e0) {
      goto _l110;
    }
    s_ = 1.0e0 / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    _l110:;
    l_ = ipvt_[k_ - 1];
    t_ = z_[l_ - 1];
    z_[l_ - 1] = z_[k_ - 1];
    z_[k_ - 1] = t_;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = z_[l_ - 1];
    z_[l_ - 1] = z_[k_ - 1];
    z_[k_ - 1] = t_;
    lm_ = _min ((*ml_), (*n_) - k_);
    if (k_ < (*n_)) {
      (void) _saxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
    }
    if (_abs (z_[k_ - 1]) <= 1.0e0) {
      goto _l130;
    }
    s_ = 1.0e0 / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l130:;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= _abs (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))])) {
      goto _l150;
    }
    s_ = _abs (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l150:;
    if (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0e0) {
      z_[k_ - 1] = z_[k_ - 1] / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    }
    if (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      z_[k_ - 1] = 1.0;
    }
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lz_ = k_ - lm_;
    t_ = -z_[k_ - 1];
    (void) _saxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lz_ - 1], &_k1);
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[92].calls++;
  return 0;
}

int_4 _sgbdi (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_4 _p_ 
det_)
{
  static int_4 i_, m_;
  static real_4 ten_;
  m_ = (*ml_) + (*mu_) + 1;
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = abd_[m_ - 1 + ((*lda_)) * ((i_ - 1))] * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l20;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (_abs (det_[0]) < ten_) {
      goto _l40;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  __calls[93].calls++;
  return 0;
}

int_4 _sgbfa (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, int_4 _p_ 
info_)
{
  static int_4 i_, i0_, j_, ju_, jz_, j0_, j1_, k_, kp1_, l_, lm_, m_, mm_, nm1_;
  static real_4 t_;
  int_4 $0_;
  extern int_4 _isamax ();
  m_ = (*ml_) + (*mu_) + 1;
  (*info_) = 0;
  j0_ = (*mu_) + 2;
  j1_ = _min ((*n_), m_) - 1;
  if (j1_ < j0_) {
    goto _l30;
  }
  for (jz_ = j0_; jz_ <= j1_; (jz_)++) {
    i0_ = m_ + 1 - jz_;
    for (i_ = i0_; i_ <= (*ml_); (i_)++) {
      abd_[i_ - 1 + ((*lda_)) * ((jz_ - 1))] = 0.0;
    }
  }
  _l30:;
  jz_ = j1_;
  ju_ = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l130;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    jz_ = jz_ + 1;
    if (jz_ > (*n_)) {
      goto _l50;
    }
    if ((*ml_) < 1) {
      goto _l50;
    }
    for (i_ = 1; i_ <= (*ml_); (i_)++) {
      abd_[i_ - 1 + ((*lda_)) * ((jz_ - 1))] = 0.0;
    }
    _l50:;
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = _isamax (($0_ = lm_ + 1, &$0_), &abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + m_ - 1;
    ipvt_[k_ - 1] = l_ + k_ - m_;
    if (abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l100;
    }
    if (l_ == m_) {
      goto _l60;
    }
    t_ = abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
    abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
    _l60:;
    t_ = -1.0e0 / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _sscal (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1);
    ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
    mm_ = m_;
    if (ju_ < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= ju_; (j_)++) {
      l_ = l_ - 1;
      mm_ = mm_ - 1;
      t_ = abd_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
      if (l_ == mm_) {
        goto _l70;
      }
      abd_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))];
      abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      _l70:;
      (void) _saxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &abd_[mm_ + 1 - 1 + ((*lda_)) * ((j_ - 
      1))], &_k1);
    }
    _l90:;
    goto _l110;
    _l100:;
    (*info_) = k_;
    _l110:;
  }
  _l130:;
  ipvt_[(*n_) - 1] = (*n_);
  if (abd_[m_ - 1 + ((*lda_)) * (((*n_) - 1))] == 0.0e0) {
    (*info_) = (*n_);
  }
  __calls[94].calls++;
  return 0;
}

int_4 _sgbsl (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_4 _p_ 
b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, la_, lb_, lm_, m_, nm1_;
  static real_4 t_;
  extern real_4 _sdot ();
  m_ = (*mu_) + (*ml_) + 1;
  nm1_ = (*n_) - 1;
  if ((*job_) != 0) {
    goto _l50;
  }
  if ((*ml_) == 0) {
    goto _l30;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    (void) _saxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lb_ = k_ - lm_;
    t_ = -b_[k_ - 1];
    (void) _saxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lb_ = k_ - lm_;
    t_ = _sdot (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  if ((*ml_) == 0) {
    goto _l90;
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    lm_ = _min ((*ml_), (*n_) - k_);
    b_[k_ - 1] = b_[k_ - 1] + _sdot (&lm_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[95].calls++;
  return 0;
}

int_4 _sgeco (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_4 _p_ rcond_, real_4 _p_ z_)
{
  static int_4 info_, j_, k_, kb_, kp1_, l_;
  static real_4 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  int_4 $0_, $1_, $2_;
  extern real_4 _sdot ();
  extern real_4 _sasum ();
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _sasum (n_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1));
  }
  (void) _sgefa (a_, lda_, n_, ipvt_, &info_);
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) {
      goto _l30;
    }
    s_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (ek_ - z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l30:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    wk_ = wk_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    wkm_ = wkm_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    goto _l50;
    _l40:;
    wk_ = 1.0;
    wkm_ = 1.0;
    _l50:;
    kp1_ = k_ + 1;
    if (kp1_ > (*n_)) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l80;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      z_[j_ - 1] = z_[j_ - 1] + t_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
    }
    _l80:;
    _l90:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (k_ < (*n_)) {
      z_[k_ - 1] = z_[k_ - 1] + _sdot (($0_ = (*n_) - k_, &$0_), &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 
      1], &_k1);
    }
    if (_abs (z_[k_ - 1]) <= 1.0e0) {
      goto _l110;
    }
    s_ = 1.0e0 / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    _l110:;
    l_ = ipvt_[k_ - 1];
    t_ = z_[l_ - 1];
    z_[l_ - 1] = z_[k_ - 1];
    z_[k_ - 1] = t_;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = z_[l_ - 1];
    z_[l_ - 1] = z_[k_ - 1];
    z_[k_ - 1] = t_;
    if (k_ < (*n_)) {
      (void) _saxpy (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
    }
    if (_abs (z_[k_ - 1]) <= 1.0e0) {
      goto _l130;
    }
    s_ = 1.0e0 / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l130:;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) {
      goto _l150;
    }
    s_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l150:;
    if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0e0) {
      z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    }
    if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      z_[k_ - 1] = 1.0;
    }
    t_ = -z_[k_ - 1];
    (void) _saxpy (($2_ = k_ - 1, &$2_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[96].calls++;
  return 0;
}

int_4 _sgedi (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_4 _p_ det_, real_4 _p_ work_, int_4 
_p_ job_)
{
  static int_4 i_, j_, k_, kb_, kp1_, l_, nm1_;
  static real_4 t_, ten_;
  int_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l20;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (_abs (det_[0]) < ten_) {
      goto _l40;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l150;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = 1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _sscal (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    kp1_ = k_ + 1;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
      (void) _saxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l90:;
  }
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l140;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    kp1_ = k_ + 1;
    for (i_ = kp1_; i_ <= (*n_); (i_)++) {
      work_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((k_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((k_ - 1))] = 0.0;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = work_[j_ - 1];
      (void) _saxpy (n_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    }
    l_ = ipvt_[k_ - 1];
    if (l_ != k_) {
      (void) _sswap (n_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((l_ - 1))], &_k1);
    }
  }
  _l140:;
  _l150:;
  __calls[97].calls++;
  return 0;
}

int_4 _sgefa (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_)
{
  static int_4 j_, k_, kp1_, l_, nm1_;
  static real_4 t_;
  int_4 $0_, $1_, $2_;
  extern int_4 _isamax ();
  (*info_) = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l70;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    l_ = _isamax (($0_ = (*n_) - k_ + 1, &$0_), &a_[k_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + k_ - 1;
    ipvt_[k_ - 1] = l_;
    if (a_[l_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    if (l_ == k_) {
      goto _l10;
    }
    t_ = a_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
    _l10:;
    t_ = -1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _sscal (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1);
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
      if (l_ == k_) {
        goto _l20;
      }
      a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      _l20:;
      (void) _saxpy (($2_ = (*n_) - k_, &$2_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[k_ + 1 - 1 + 
      ((*lda_)) * ((j_ - 1))], &_k1);
    }
    goto _l50;
    _l40:;
    (*info_) = k_;
    _l50:;
  }
  _l70:;
  ipvt_[(*n_) - 1] = (*n_);
  if (a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))] == 0.0e0) {
    (*info_) = (*n_);
  }
  __calls[98].calls++;
  return 0;
}

int_4 _sgesl (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_4 _p_ b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, nm1_;
  static real_4 t_;
  int_4 $0_, $1_, $2_, $3_;
  extern real_4 _sdot ();
  nm1_ = (*n_) - 1;
  if ((*job_) != 0) {
    goto _l50;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    (void) _saxpy (($0_ = (*n_) - k_, &$0_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _saxpy (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _sdot (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    b_[k_ - 1] = b_[k_ - 1] + _sdot (($3_ = (*n_) - k_, &$3_), &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 
    1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[99].calls++;
  return 0;
}

int_4 _sgtsl (int_4 _p_ n_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ b_, int_4 _p_ info_)
{
  static int_4 k_, kb_, kp1_, nm1_, nm2_;
  static real_4 t_;
  (*info_) = 0;
  c_[0] = d_[0];
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l40;
  }
  d_[0] = e_[0];
  e_[0] = 0.0;
  e_[(*n_) - 1] = 0.0;
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    if (_abs (c_[kp1_ - 1]) < _abs (c_[k_ - 1])) {
      goto _l10;
    }
    t_ = c_[kp1_ - 1];
    c_[kp1_ - 1] = c_[k_ - 1];
    c_[k_ - 1] = t_;
    t_ = d_[kp1_ - 1];
    d_[kp1_ - 1] = d_[k_ - 1];
    d_[k_ - 1] = t_;
    t_ = e_[kp1_ - 1];
    e_[kp1_ - 1] = e_[k_ - 1];
    e_[k_ - 1] = t_;
    t_ = b_[kp1_ - 1];
    b_[kp1_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    if (c_[k_ - 1] != 0.0e0) {
      goto _l20;
    }
    (*info_) = k_;
    goto _l100;
    _l20:;
    t_ = -c_[kp1_ - 1] / c_[k_ - 1];
    c_[kp1_ - 1] = d_[kp1_ - 1] + t_ * d_[k_ - 1];
    d_[kp1_ - 1] = e_[kp1_ - 1] + t_ * e_[k_ - 1];
    e_[kp1_ - 1] = 0.0;
    b_[kp1_ - 1] = b_[kp1_ - 1] + t_ * b_[k_ - 1];
  }
  _l40:;
  if (c_[(*n_) - 1] != 0.0e0) {
    goto _l50;
  }
  (*info_) = (*n_);
  goto _l90;
  _l50:;
  nm2_ = (*n_) - 2;
  b_[(*n_) - 1] = b_[(*n_) - 1] / c_[(*n_) - 1];
  if ((*n_) == 1) {
    goto _l80;
  }
  b_[nm1_ - 1] = (b_[nm1_ - 1] - d_[nm1_ - 1] * b_[(*n_) - 1]) / c_[nm1_ - 1];
  if (nm2_ < 1) {
    goto _l70;
  }
  for (kb_ = 1; kb_ <= nm2_; (kb_)++) {
    k_ = nm2_ - kb_ + 1;
    b_[k_ - 1] = (b_[k_ - 1] - d_[k_ - 1] * b_[k_ + 1 - 1] - e_[k_ - 1] * b_[k_ + 2 - 1]) / c_[k_ - 1];
  }
  _l70:;
  _l80:;
  _l90:;
  _l100:;
  __calls[100].calls++;
  return 0;
}

int_4 _spbco (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ rcond_, real_4 _p_ z_, int_4 _p_ 
info_)
{
  static int_4 i_, j_, j2_, k_, kb_, kp1_, l_, la_, lb_, lm_, mu_;
  static real_4 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  extern real_4 _sdot ();
  extern real_4 _sasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = _min (j_, (*m_) + 1);
    mu_ = _max ((*m_) + 2 - j_, 1);
    z_[j_ - 1] = _sasum (&l_, &abd_[mu_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
    k_ = j_ - l_;
    if ((*m_) < mu_) {
      goto _l20;
    }
    for (i_ = mu_; i_ <= (*m_); (i_)++) {
      k_ = k_ + 1;
      z_[k_ - 1] = z_[k_ - 1] + _abs (abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _spbfa (abd_, lda_, n_, m_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l60;
    }
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))] / _abs (ek_ - z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l60:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    wk_ = wk_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    wkm_ = wkm_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    kp1_ = k_ + 1;
    j2_ = _min (k_ + (*m_), (*n_));
    i_ = (*m_) + 1;
    if (kp1_ > j2_) {
      goto _l100;
    }
    for (j_ = kp1_; j_ <= j2_; (j_)++) {
      i_ = i_ - 1;
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l90;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    i_ = (*m_) + 1;
    for (j_ = kp1_; j_ <= j2_; (j_)++) {
      i_ = i_ - 1;
      z_[j_ - 1] = z_[j_ - 1] + t_ * abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
    }
    _l90:;
    _l100:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l120;
    }
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    _l120:;
    z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    t_ = -z_[k_ - 1];
    (void) _saxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    z_[k_ - 1] = z_[k_ - 1] - _sdot (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
    if (_abs (z_[k_ - 1]) <= abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l140;
    }
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l140:;
    z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l160;
    }
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l160:;
    z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    t_ = -z_[k_ - 1];
    (void) _saxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  _l180:;
  __calls[101].calls++;
  return 0;
}

int_4 _spbdi (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ det_)
{
  static int_4 i_;
  static real_4 s_;
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((i_ - 1))] * abd_[(*m_) + 1 - 1 + ((*lda_)) * ((i_ - 1))]) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  __calls[102].calls++;
  return 0;
}

int_4 _spbfa (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ info_)
{
  static int_4 ik_, j_, jk_, k_, mu_;
  static real_4 t_, s_;
  int_4 $0_;
  extern real_4 _sdot ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    ik_ = (*m_) + 1;
    jk_ = _max (j_ - (*m_), 1);
    mu_ = _max ((*m_) + 2 - j_, 1);
    if ((*m_) < mu_) {
      goto _l20;
    }
    for (k_ = mu_; k_ <= (*m_); (k_)++) {
      t_ = abd_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _sdot (($0_ = k_ - mu_, &$0_), &abd_[ik_ - 1 + ((*lda_)) * ((jk_ - 1))], 
      &_k1, &abd_[mu_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
      t_ = t_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((jk_ - 1))];
      abd_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + t_ * t_;
      ik_ = ik_ - 1;
      jk_ = jk_ + 1;
    }
    _l20:;
    s_ = abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))] - s_;
    if (s_ <= 0.0e0) {
      goto _l40;
    }
    abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))] = sqrtf (s_);
  }
  (*info_) = 0;
  _l40:;
  __calls[103].calls++;
  return 0;
}

int_4 _spbsl (real_4 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ b_)
{
  static int_4 k_, kb_, la_, lb_, lm_;
  static real_4 t_;
  extern real_4 _sdot ();
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    t_ = _sdot (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    b_[k_ - 1] = b_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _saxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
  }
  __calls[104].calls++;
  return 0;
}

int_4 _spoco (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ rcond_, real_4 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, j_, jm1_, k_, kb_, kp1_;
  static real_4 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  int_4 $0_, $1_, $2_;
  extern real_4 _sdot ();
  extern real_4 _sasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = _sasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = z_[i_ - 1] + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _spofa (a_, lda_, n_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l60;
    }
    s_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / _abs (ek_ - z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l60:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    wk_ = wk_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    wkm_ = wkm_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    kp1_ = k_ + 1;
    if (kp1_ > (*n_)) {
      goto _l100;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l90;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      z_[j_ - 1] = z_[j_ - 1] + t_ * a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
    }
    _l90:;
    _l100:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l120;
    }
    s_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    _l120:;
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -z_[k_ - 1];
    (void) _saxpy (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    z_[k_ - 1] = z_[k_ - 1] - _sdot (($1_ = k_ - 1, &$1_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
    if (_abs (z_[k_ - 1]) <= a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l140;
    }
    s_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l140:;
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) {
      goto _l160;
    }
    s_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l160:;
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -z_[k_ - 1];
    (void) _saxpy (($2_ = k_ - 1, &$2_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  _l180:;
  __calls[105].calls++;
  return 0;
}

int_4 _spodi (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_)
{
  static int_4 i_, j_, jm1_, k_, kp1_;
  static real_4 t_, s_;
  int_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] * a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l140;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = 1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _sscal (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    kp1_ = k_ + 1;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = 0.0;
      (void) _saxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l90:;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l120;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      (void) _saxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    }
    _l120:;
    t_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
    (void) _sscal (&j_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  }
  _l140:;
  __calls[106].calls++;
  return 0;
}

int_4 _spofa (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, jm1_, k_;
  static real_4 t_, s_;
  int_4 $0_;
  extern real_4 _sdot ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _sdot (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + 
      ((*lda_)) * ((j_ - 1))], &_k1);
      t_ = t_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + t_ * t_;
    }
    _l20:;
    s_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] - s_;
    if (s_ <= 0.0e0) {
      goto _l40;
    }
    a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = sqrtf (s_);
  }
  (*info_) = 0;
  _l40:;
  __calls[107].calls++;
  return 0;
}

int_4 _sposl (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ b_)
{
  static int_4 k_, kb_;
  static real_4 t_;
  int_4 $0_, $1_;
  extern real_4 _sdot ();
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _sdot (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _saxpy (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  __calls[108].calls++;
  return 0;
}

int_4 _sppco (real_4 _p_ ap_, int_4 _p_ n_, real_4 _p_ rcond_, real_4 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, ij_, j_, jm1_, j1_, k_, kb_, kj_, kk_, kp1_;
  static real_4 ek_, t_, wk_, wkm_, anorm_, s_, sm_, ynorm_;
  int_4 $0_, $1_, $2_;
  extern real_4 _sdot ();
  extern real_4 _sasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = _sasum (&j_, &ap_[j1_ - 1], &_k1);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = z_[i_ - 1] + _abs (ap_[ij_ - 1]);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _sppfa (ap_, n_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = kk_ + k_;
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= ap_[kk_ - 1]) {
      goto _l60;
    }
    s_ = ap_[kk_ - 1] / _abs (ek_ - z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l60:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    wk_ = wk_ / ap_[kk_ - 1];
    wkm_ = wkm_ / ap_[kk_ - 1];
    kp1_ = k_ + 1;
    kj_ = kk_ + k_;
    if (kp1_ > (*n_)) {
      goto _l100;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * ap_[kj_ - 1]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * ap_[kj_ - 1];
      s_ = s_ + _abs (z_[j_ - 1]);
      kj_ = kj_ + j_;
    }
    if (s_ >= sm_) {
      goto _l90;
    }
    t_ = wkm_ - wk_;
    wk_ = wkm_;
    kj_ = kk_ + k_;
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      z_[j_ - 1] = z_[j_ - 1] + t_ * ap_[kj_ - 1];
      kj_ = kj_ + j_;
    }
    _l90:;
    _l100:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= ap_[kk_ - 1]) {
      goto _l120;
    }
    s_ = ap_[kk_ - 1] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    _l120:;
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
    kk_ = kk_ - k_;
    t_ = -z_[k_ - 1];
    (void) _saxpy (($0_ = k_ - 1, &$0_), &t_, &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    z_[k_ - 1] = z_[k_ - 1] - _sdot (($1_ = k_ - 1, &$1_), &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
    kk_ = kk_ + k_;
    if (_abs (z_[k_ - 1]) <= ap_[kk_ - 1]) {
      goto _l140;
    }
    s_ = ap_[kk_ - 1] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l140:;
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    if (_abs (z_[k_ - 1]) <= ap_[kk_ - 1]) {
      goto _l160;
    }
    s_ = ap_[kk_ - 1] / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l160:;
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
    kk_ = kk_ - k_;
    t_ = -z_[k_ - 1];
    (void) _saxpy (($2_ = k_ - 1, &$2_), &t_, &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  _l180:;
  __calls[109].calls++;
  return 0;
}

int_4 _sppdi (real_4 _p_ ap_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_)
{
  static int_4 i_, ii_, j_, jj_, jm1_, j1_, k_, kj_, kk_, kp1_, k1_;
  static real_4 t_, s_;
  int_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  ii_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ii_ = ii_ + i_;
    det_[0] = (ap_[ii_ - 1] * ap_[ii_ - 1]) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l140;
  }
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    k1_ = kk_ + 1;
    kk_ = kk_ + k_;
    ap_[kk_ - 1] = 1.0e0 / ap_[kk_ - 1];
    t_ = -ap_[kk_ - 1];
    (void) _sscal (($0_ = k_ - 1, &$0_), &t_, &ap_[k1_ - 1], &_k1);
    kp1_ = k_ + 1;
    j1_ = kk_ + 1;
    kj_ = kk_ + k_;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = ap_[kj_ - 1];
      ap_[kj_ - 1] = 0.0;
      (void) _saxpy (&k_, &t_, &ap_[k1_ - 1], &_k1, &ap_[j1_ - 1], &_k1);
      j1_ = j1_ + j_;
      kj_ = kj_ + j_;
    }
    _l90:;
  }
  jj_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    j1_ = jj_ + 1;
    jj_ = jj_ + j_;
    jm1_ = j_ - 1;
    k1_ = 1;
    kj_ = j1_;
    if (jm1_ < 1) {
      goto _l120;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = ap_[kj_ - 1];
      (void) _saxpy (&k_, &t_, &ap_[j1_ - 1], &_k1, &ap_[k1_ - 1], &_k1);
      k1_ = k1_ + k_;
      kj_ = kj_ + 1;
    }
    _l120:;
    t_ = ap_[jj_ - 1];
    (void) _sscal (&j_, &t_, &ap_[j1_ - 1], &_k1);
  }
  _l140:;
  __calls[110].calls++;
  return 0;
}

int_4 _sppfa (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, jj_, jm1_, k_, kj_, kk_;
  static real_4 t_, s_;
  int_4 $0_;
  extern real_4 _sdot ();
  jj_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    jm1_ = j_ - 1;
    kj_ = jj_;
    kk_ = 0;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      kj_ = kj_ + 1;
      t_ = ap_[kj_ - 1] - _sdot (($0_ = k_ - 1, &$0_), &ap_[kk_ + 1 - 1], &_k1, &ap_[jj_ + 1 - 1], &_k1);
      kk_ = kk_ + k_;
      t_ = t_ / ap_[kk_ - 1];
      ap_[kj_ - 1] = t_;
      s_ = s_ + t_ * t_;
    }
    _l20:;
    jj_ = jj_ + j_;
    s_ = ap_[jj_ - 1] - s_;
    if (s_ <= 0.0e0) {
      goto _l40;
    }
    ap_[jj_ - 1] = sqrtf (s_);
  }
  (*info_) = 0;
  _l40:;
  __calls[111].calls++;
  return 0;
}

int_4 _sppsl (real_4 _p_ ap_, int_4 _p_ n_, real_4 _p_ b_)
{
  static int_4 k_, kb_, kk_;
  static real_4 t_;
  int_4 $0_, $1_;
  extern real_4 _sdot ();
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _sdot (($0_ = k_ - 1, &$0_), &ap_[kk_ + 1 - 1], &_k1, &b_[0], &_k1);
    kk_ = kk_ + k_;
    b_[k_ - 1] = (b_[k_ - 1] - t_) / ap_[kk_ - 1];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
    kk_ = kk_ - k_;
    t_ = -b_[k_ - 1];
    (void) _saxpy (($1_ = k_ - 1, &$1_), &t_, &ap_[kk_ + 1 - 1], &_k1, &b_[0], &_k1);
  }
  __calls[112].calls++;
  return 0;
}

int_4 _sptsl (int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e_, real_4 _p_ b_)
{
  static int_4 k_, kbm1_, ke_, kf_, kp1_, nm1_, nm1d2_;
  static real_4 t1_, t2_;
  if ((*n_) != 1) {
    goto _l10;
  }
  b_[0] = b_[0] / d_[0];
  goto _l70;
  _l10:;
  nm1_ = (*n_) - 1;
  nm1d2_ = nm1_ / 2;
  if ((*n_) == 2) {
    goto _l30;
  }
  kbm1_ = (*n_) - 1;
  for (k_ = 1; k_ <= nm1d2_; (k_)++) {
    t1_ = e_[k_ - 1] / d_[k_ - 1];
    d_[k_ + 1 - 1] = d_[k_ + 1 - 1] - t1_ * e_[k_ - 1];
    b_[k_ + 1 - 1] = b_[k_ + 1 - 1] - t1_ * b_[k_ - 1];
    t2_ = e_[kbm1_ - 1] / d_[kbm1_ + 1 - 1];
    d_[kbm1_ - 1] = d_[kbm1_ - 1] - t2_ * e_[kbm1_ - 1];
    b_[kbm1_ - 1] = b_[kbm1_ - 1] - t2_ * b_[kbm1_ + 1 - 1];
    kbm1_ = kbm1_ - 1;
  }
  _l30:;
  kp1_ = nm1d2_ + 1;
  if (_imod ((*n_), 2) != 0) {
    goto _l40;
  }
  t1_ = e_[kp1_ - 1] / d_[kp1_ - 1];
  d_[kp1_ + 1 - 1] = d_[kp1_ + 1 - 1] - t1_ * e_[kp1_ - 1];
  b_[kp1_ + 1 - 1] = b_[kp1_ + 1 - 1] - t1_ * b_[kp1_ - 1];
  kp1_ = kp1_ + 1;
  _l40:;
  b_[kp1_ - 1] = b_[kp1_ - 1] / d_[kp1_ - 1];
  if ((*n_) == 2) {
    goto _l60;
  }
  k_ = kp1_ - 1;
  ke_ = kp1_ + nm1d2_ - 1;
  for (kf_ = kp1_; kf_ <= ke_; (kf_)++) {
    b_[k_ - 1] = (b_[k_ - 1] - e_[k_ - 1] * b_[k_ + 1 - 1]) / d_[k_ - 1];
    b_[kf_ + 1 - 1] = (b_[kf_ + 1 - 1] - e_[kf_ - 1] * b_[kf_ - 1]) / d_[kf_ + 1 - 1];
    k_ = k_ - 1;
  }
  _l60:;
  if (_imod ((*n_), 2) == 0) {
    b_[0] = (b_[0] - e_[0] * b_[1]) / d_[0];
  }
  _l70:;
  __calls[113].calls++;
  return 0;
}

int_4 _sqrdc (real_4 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, real_4 _p_ qraux_, int_4 _p_ jpvt_, real_4 _p_ 
work_, int_4 _p_ job_)
{
  static int_4 j_, jp_, l_, lp1_, lup_, maxj_, pl_, pu_, jj_;
  static logical_4 negj_, swapj_;
  static real_4 maxnrm_, tt_, nrmxl_, t_;
  int_4 $0_, $1_, $3_, $4_, $7_;
  real_4 $2_, $5_, $6_;
  extern real_4 _snrm2 ();
  extern real_4 _sdot ();
  pl_ = 1;
  pu_ = 0;
  if ((*job_) == 0) {
    goto _l60;
  }
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    swapj_ = jpvt_[j_ - 1] > 0;
    negj_ = jpvt_[j_ - 1] < 0;
    jpvt_[j_ - 1] = j_;
    if (negj_) {
      jpvt_[j_ - 1] = -j_;
    }
    if (! (swapj_)) {
      goto _l10;
    }
    if (j_ != pl_) {
      (void) _sswap (n_, &x_[0 + ((*ldx_)) * ((pl_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    }
    jpvt_[j_ - 1] = jpvt_[pl_ - 1];
    jpvt_[pl_ - 1] = j_;
    pl_ = pl_ + 1;
    _l10:;
  }
  pu_ = (*p_);
  for (jj_ = 1; jj_ <= (*p_); (jj_)++) {
    j_ = (*p_) - jj_ + 1;
    if (jpvt_[j_ - 1] >= 0) {
      goto _l40;
    }
    jpvt_[j_ - 1] = -jpvt_[j_ - 1];
    if (j_ == pu_) {
      goto _l30;
    }
    (void) _sswap (n_, &x_[0 + ((*ldx_)) * ((pu_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    jp_ = jpvt_[pu_ - 1];
    jpvt_[pu_ - 1] = jpvt_[j_ - 1];
    jpvt_[j_ - 1] = jp_;
    _l30:;
    pu_ = pu_ - 1;
    _l40:;
  }
  _l60:;
  if (pu_ < pl_) {
    goto _l80;
  }
  for (j_ = pl_; j_ <= pu_; (j_)++) {
    qraux_[j_ - 1] = _snrm2 (n_, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    work_[j_ - 1] = qraux_[j_ - 1];
  }
  _l80:;
  lup_ = _min ((*n_), (*p_));
  for (l_ = 1; l_ <= lup_; (l_)++) {
    if (l_ < pl_ || l_ >= pu_) {
      goto _l120;
    }
    maxnrm_ = 0.0;
    maxj_ = l_;
    for (j_ = l_; j_ <= pu_; (j_)++) {
      if (qraux_[j_ - 1] <= maxnrm_) {
        goto _l90;
      }
      maxnrm_ = qraux_[j_ - 1];
      maxj_ = j_;
      _l90:;
    }
    if (maxj_ == l_) {
      goto _l110;
    }
    (void) _sswap (n_, &x_[0 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((maxj_ - 1))], &_k1);
    qraux_[maxj_ - 1] = qraux_[l_ - 1];
    work_[maxj_ - 1] = work_[l_ - 1];
    jp_ = jpvt_[maxj_ - 1];
    jpvt_[maxj_ - 1] = jpvt_[l_ - 1];
    jpvt_[l_ - 1] = jp_;
    _l110:;
    _l120:;
    qraux_[l_ - 1] = 0.0;
    if (l_ == (*n_)) {
      goto _l190;
    }
    nrmxl_ = _snrm2 (($0_ = (*n_) - l_ + 1, &$0_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1);
    if (nrmxl_ == 0.0e0) {
      goto _l180;
    }
    if (x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] != 0.0e0) {
      nrmxl_ = _sign (nrmxl_, x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]);
    }
    (void) _sscal (($1_ = (*n_) - l_ + 1, &$1_), ($2_ = 1.0e0 / nrmxl_, &$2_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1)
    ;
    x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = 1.0e0 + x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
    lp1_ = l_ + 1;
    if ((*p_) < lp1_) {
      goto _l170;
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      t_ = -_sdot (($3_ = (*n_) - l_ + 1, &$3_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * ((j_ - 
      1))], &_k1) / x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
      (void) _saxpy (($4_ = (*n_) - l_ + 1, &$4_), &t_, &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * 
      ((j_ - 1))], &_k1);
      if (j_ < pl_ || j_ > pu_) {
        goto _l150;
      }
      if (qraux_[j_ - 1] == 0.0e0) {
        goto _l150;
      }
      tt_ = 1.0e0 - ($5_ = (_abs (x_[l_ - 1 + ((*ldx_)) * ((j_ - 1))]) / qraux_[j_ - 1]), $5_ * $5_);
      tt_ = _max (tt_, 0.0);
      t_ = tt_;
      tt_ = 1.0e0 + 0.05e0 * tt_ * ($6_ = (qraux_[j_ - 1] / work_[j_ - 1]), $6_ * $6_);
      if (tt_ == 1.0e0) {
        goto _l130;
      }
      qraux_[j_ - 1] = qraux_[j_ - 1] * sqrtf (t_);
      goto _l140;
      _l130:;
      qraux_[j_ - 1] = _snrm2 (($7_ = (*n_) - l_, &$7_), &x_[l_ + 1 - 1 + ((*ldx_)) * ((j_ - 1))], &_k1);
      work_[j_ - 1] = qraux_[j_ - 1];
      _l140:;
      _l150:;
    }
    _l170:;
    qraux_[l_ - 1] = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
    x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = -nrmxl_;
    _l180:;
    _l190:;
  }
  __calls[114].calls++;
  return 0;
}

int_4 _sqrsl (real_4 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ k_, real_4 _p_ qraux_, real_4 _p_ y_, real_4 _p_ 
qy_, real_4 _p_ qty_, real_4 _p_ b_, real_4 _p_ rsd_, real_4 _p_ xb_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, j_, jj_, ju_, kp1_;
  static logical_4 cb_, cqy_, cqty_, cr_, cxb_;
  static real_4 t_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  extern real_4 _sdot ();
  (*info_) = 0;
  cqy_ = (*job_) / 10000 != 0;
  cqty_ = _imod ((*job_), 10000) != 0;
  cb_ = _imod ((*job_), 1000) / 100 != 0;
  cr_ = _imod ((*job_), 100) / 10 != 0;
  cxb_ = _imod ((*job_), 10) != 0;
  ju_ = _min ((*k_), (*n_) - 1);
  if (ju_ != 0) {
    goto _l40;
  }
  if (cqy_) {
    qy_[0] = y_[0];
  }
  if (cqty_) {
    qty_[0] = y_[0];
  }
  if (cxb_) {
    xb_[0] = y_[0];
  }
  if (! (cb_)) {
    goto _l30;
  }
  if (x_[0 + ((*ldx_)) * ((0))] != 0.0e0) {
    goto _l10;
  }
  (*info_) = 1;
  goto _l20;
  _l10:;
  b_[0] = y_[0] / x_[0 + ((*ldx_)) * ((0))];
  _l20:;
  _l30:;
  if (cr_) {
    rsd_[0] = 0.0;
  }
  goto _l250;
  _l40:;
  if (cqy_) {
    (void) _scopy (n_, y_, &_k1, qy_, &_k1);
  }
  if (cqty_) {
    (void) _scopy (n_, y_, &_k1, qty_, &_k1);
  }
  if (! (cqy_)) {
    goto _l70;
  }
  for (jj_ = 1; jj_ <= ju_; (jj_)++) {
    j_ = ju_ - jj_ + 1;
    if (qraux_[j_ - 1] == 0.0e0) {
      goto _l50;
    }
    temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
    t_ = -_sdot (($0_ = (*n_) - j_ + 1, &$0_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qy_[j_ - 1], &_k1) / x_[j_ - 1 
    + ((*ldx_)) * ((j_ - 1))];
    (void) _saxpy (($1_ = (*n_) - j_ + 1, &$1_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qy_[j_ - 1], &_k1);
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
    _l50:;
  }
  _l70:;
  if (! (cqty_)) {
    goto _l100;
  }
  for (j_ = 1; j_ <= ju_; (j_)++) {
    if (qraux_[j_ - 1] == 0.0e0) {
      goto _l80;
    }
    temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
    t_ = -_sdot (($2_ = (*n_) - j_ + 1, &$2_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qty_[j_ - 1], &_k1) / x_[j_ - 1 
    + ((*ldx_)) * ((j_ - 1))];
    (void) _saxpy (($3_ = (*n_) - j_ + 1, &$3_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qty_[j_ - 1], &_k1);
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
    _l80:;
  }
  _l100:;
  if (cb_) {
    (void) _scopy (k_, qty_, &_k1, b_, &_k1);
  }
  kp1_ = (*k_) + 1;
  if (cxb_) {
    (void) _scopy (k_, qty_, &_k1, xb_, &_k1);
  }
  if (cr_ && (*k_) < (*n_)) {
    (void) _scopy (($4_ = (*n_) - (*k_), &$4_), &qty_[kp1_ - 1], &_k1, &rsd_[kp1_ - 1], &_k1);
  }
  if (! (cxb_) || kp1_ > (*n_)) {
    goto _l120;
  }
  for (i_ = kp1_; i_ <= (*n_); (i_)++) {
    xb_[i_ - 1] = 0.0;
  }
  _l120:;
  if (! (cr_)) {
    goto _l140;
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    rsd_[i_ - 1] = 0.0;
  }
  _l140:;
  if (! (cb_)) {
    goto _l190;
  }
  for (jj_ = 1; jj_ <= (*k_); (jj_)++) {
    j_ = (*k_) - jj_ + 1;
    if (x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] != 0.0e0) {
      goto _l150;
    }
    (*info_) = j_;
    goto _l180;
    _l150:;
    b_[j_ - 1] = b_[j_ - 1] / x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
    if (j_ == 1) {
      goto _l160;
    }
    t_ = -b_[j_ - 1];
    (void) _saxpy (($5_ = j_ - 1, &$5_), &t_, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1, b_, &_k1);
    _l160:;
  }
  _l180:;
  _l190:;
  if (! (cr_) && ! (cxb_)) {
    goto _l240;
  }
  for (jj_ = 1; jj_ <= ju_; (jj_)++) {
    j_ = ju_ - jj_ + 1;
    if (qraux_[j_ - 1] == 0.0e0) {
      goto _l220;
    }
    temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
    if (! (cr_)) {
      goto _l200;
    }
    t_ = -_sdot (($6_ = (*n_) - j_ + 1, &$6_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &rsd_[j_ - 1], &_k1) / x_[j_ - 1 
    + ((*ldx_)) * ((j_ - 1))];
    (void) _saxpy (($7_ = (*n_) - j_ + 1, &$7_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &rsd_[j_ - 1], &_k1);
    _l200:;
    if (! (cxb_)) {
      goto _l210;
    }
    t_ = -_sdot (($8_ = (*n_) - j_ + 1, &$8_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &xb_[j_ - 1], &_k1) / x_[j_ - 1 
    + ((*ldx_)) * ((j_ - 1))];
    (void) _saxpy (($9_ = (*n_) - j_ + 1, &$9_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &xb_[j_ - 1], &_k1);
    _l210:;
    x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
    _l220:;
  }
  _l240:;
  _l250:;
  __calls[115].calls++;
  return 0;
}

int_4 _ssico (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, real_4 _p_ z_)
{
  static int_4 i_, info_, j_, jm1_, k_, kp_, kps_, ks_;
  static real_4 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, anorm_, s_, ynorm_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern real_4 _sdot ();
  extern real_4 _sasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = _sasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = z_[i_ - 1] + _abs (a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _ssifa (a_, lda_, n_, kpvt_, &info_);
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  k_ = (*n_);
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (z_[k_ - 1] != 0.0e0) {
    ek_ = _sign (ek_, z_[k_ - 1]);
  }
  z_[k_ - 1] = z_[k_ - 1] + ek_;
  (void) _saxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (ks_ == 1) {
    goto _l80;
  }
  if (z_[k_ - 1 - 1] != 0.0e0) {
    ek_ = _sign (ek_, z_[k_ - 1 - 1]);
  }
  z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
  (void) _saxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
  _l80:;
  if (ks_ == 2) {
    goto _l100;
  }
  if (_abs (z_[k_ - 1]) <= _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) {
    goto _l90;
  }
  s_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
  (void) _sscal (n_, &s_, z_, &_k1);
  ek_ = s_ * ek_;
  _l90:;
  if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0e0) {
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
    z_[k_ - 1] = 1.0;
  }
  goto _l110;
  _l100:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = z_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  _l110:;
  k_ = k_ - ks_;
  goto _l60;
  _l120:;
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  k_ = 1;
  _l130:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == 1) {
    goto _l150;
  }
  z_[k_ - 1] = z_[k_ - 1] + _sdot (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (ks_ == 2) {
    z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _sdot (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], &_k1)
    ;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l140;
  }
  t_ = z_[k_ - 1];
  z_[k_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l140:;
  _l150:;
  k_ = k_ + ks_;
  goto _l130;
  _l160:;
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  k_ = (*n_);
  _l170:;
  if (k_ == 0) {
    goto _l230;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == ks_) {
    goto _l190;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l180;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l180:;
  (void) _saxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (ks_ == 2) {
    (void) _saxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
  }
  _l190:;
  if (ks_ == 2) {
    goto _l210;
  }
  if (_abs (z_[k_ - 1]) <= _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])) {
    goto _l200;
  }
  s_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  _l200:;
  if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] != 0.0e0) {
    z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
    z_[k_ - 1] = 1.0;
  }
  goto _l220;
  _l210:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = z_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  _l220:;
  k_ = k_ - ks_;
  goto _l170;
  _l230:;
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  k_ = 1;
  _l240:;
  if (k_ > (*n_)) {
    goto _l270;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == 1) {
    goto _l260;
  }
  z_[k_ - 1] = z_[k_ - 1] + _sdot (($6_ = k_ - 1, &$6_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (ks_ == 2) {
    z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _sdot (($7_ = k_ - 1, &$7_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], &_k1)
    ;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l250;
  }
  t_ = z_[k_ - 1];
  z_[k_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l250:;
  _l260:;
  k_ = k_ + ks_;
  goto _l240;
  _l270:;
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[116].calls++;
  return 0;
}

int_4 _ssidi (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ det_, int_4 _p_ inert_, real_4 
_p_ work_, int_4 _p_ job_)
{
  static int_4 j_, jb_, k_, km1_, ks_, kstep_;
  static logical_4 noinv_, nodet_, noert_;
  static real_4 akkp1_, temp_, ten_, d_, t_, ak_, akp1_;
  int_4 $0_, $1_, $2_;
  extern real_4 _sdot ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  noert_ = _imod ((*job_), 1000) / 100 == 0;
  if (nodet_ && noert_) {
    goto _l140;
  }
  if (noert_) {
    goto _l10;
  }
  inert_[0] = 0;
  inert_[1] = 0;
  inert_[2] = 0;
  _l10:;
  if (nodet_) {
    goto _l20;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  _l20:;
  t_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    d_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    if (kpvt_[k_ - 1] > 0) {
      goto _l50;
    }
    if (t_ != 0.0e0) {
      goto _l30;
    }
    t_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))]);
    d_ = (d_ / t_) * a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] - t_;
    goto _l40;
    _l30:;
    d_ = t_;
    t_ = 0.0;
    _l40:;
    _l50:;
    if (noert_) {
      goto _l60;
    }
    if (d_ > 0.0e0) {
      inert_[0] = inert_[0] + 1;
    }
    if (d_ < 0.0e0) {
      inert_[1] = inert_[1] + 1;
    }
    if (d_ == 0.0e0) {
      inert_[2] = inert_[2] + 1;
    }
    _l60:;
    if (nodet_) {
      goto _l120;
    }
    det_[0] = d_ * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l110;
    }
    _l70:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l80;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l70;
    _l80:;
    _l90:;
    if (_abs (det_[0]) < ten_) {
      goto _l100;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l90;
    _l100:;
    _l110:;
    _l120:;
  }
  _l140:;
  if (noinv_) {
    goto _l270;
  }
  k_ = 1;
  _l150:;
  if (k_ > (*n_)) {
    goto _l260;
  }
  km1_ = k_ - 1;
  if (kpvt_[k_ - 1] < 0) {
    goto _l180;
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = 1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  if (km1_ < 1) {
    goto _l170;
  }
  (void) _scopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _sdot (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _saxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
    1))], &_k1);
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + _sdot (&km1_, work_, &_k1, &a_[0 + 
  ((*lda_)) * ((k_ - 1))], &_k1);
  _l170:;
  kstep_ = 1;
  goto _l220;
  _l180:;
  t_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))]);
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / t_;
  akp1_ = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
  akkp1_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
  d_ = t_ * (ak_ * akp1_ - 1.0e0);
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = akp1_ / d_;
  a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = ak_ / d_;
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = -akkp1_ / d_;
  if (km1_ < 1) {
    goto _l210;
  }
  (void) _scopy (&km1_, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = _sdot (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _saxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 
    1 - 1))], &_k1);
  }
  a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _sdot (&km1_, work_, &_k1, 
  &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _sdot (&km1_, &a_[0 + ((*lda_)) * 
  ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
  (void) _scopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _sdot (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _saxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
    1))], &_k1);
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + _sdot (&km1_, work_, &_k1, &a_[0 + 
  ((*lda_)) * ((k_ - 1))], &_k1);
  _l210:;
  kstep_ = 2;
  _l220:;
  ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (ks_ == k_) {
    goto _l250;
  }
  (void) _sswap (&ks_, &a_[0 + ((*lda_)) * ((ks_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  for (jb_ = ks_; jb_ <= k_; (jb_)++) {
    j_ = k_ + ks_ - jb_;
    temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
  }
  if (kstep_ == 1) {
    goto _l240;
  }
  temp_ = a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = temp_;
  _l240:;
  _l250:;
  k_ = k_ + kstep_;
  goto _l150;
  _l260:;
  _l270:;
  __calls[117].calls++;
  return 0;
}

int_4 _ssifa (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 imax_, imaxp1_, j_, jj_, jmax_, k_, km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_4 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, absakk_, alpha_, colmax_, rowmax_;
  int_4 $0_, $1_;
  extern int_4 _isamax ();
  alpha_ = 0.6403882;
  (*info_) = 0;
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (a_[0 + ((*lda_)) * ((0))] == 0.0e0) {
    (*info_) = 1;
  }
  goto _l200;
  _l20:;
  km1_ = k_ - 1;
  absakk_ = _abs (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
  imax_ = _isamax (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  colmax_ = _abs (a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))]);
  if (absakk_ < alpha_ * colmax_) {
    goto _l30;
  }
  kstep_ = 1;
  swap_ = FALSE;
  goto _l90;
  _l30:;
  rowmax_ = 0.0;
  imaxp1_ = imax_ + 1;
  for (j_ = imaxp1_; j_ <= k_; (j_)++) {
    rowmax_ = _max (rowmax_, _abs (a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]));
  }
  if (imax_ == 1) {
    goto _l50;
  }
  jmax_ = _isamax (($1_ = imax_ - 1, &$1_), &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1);
  rowmax_ = _max (rowmax_, _abs (a_[jmax_ - 1 + ((*lda_)) * ((imax_ - 1))]));
  _l50:;
  if (_abs (a_[imax_ - 1 + ((*lda_)) * ((imax_ - 1))]) < alpha_ * rowmax_) {
    goto _l60;
  }
  kstep_ = 1;
  swap_ = TRUE;
  goto _l80;
  _l60:;
  if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
    goto _l70;
  }
  kstep_ = 1;
  swap_ = FALSE;
  goto _l80;
  _l70:;
  kstep_ = 2;
  swap_ = imax_ != km1_;
  _l80:;
  _l90:;
  if (_max (absakk_, colmax_) != 0.0e0) {
    goto _l100;
  }
  kpvt_[k_ - 1] = k_;
  (*info_) = k_;
  goto _l190;
  _l100:;
  if (kstep_ == 2) {
    goto _l140;
  }
  if (! (swap_)) {
    goto _l120;
  }
  (void) _sswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  for (jj_ = imax_; jj_ <= k_; (jj_)++) {
    j_ = k_ + imax_ - jj_;
    t_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
  }
  _l120:;
  for (jj_ = 1; jj_ <= km1_; (jj_)++) {
    j_ = k_ - jj_;
    mulk_ = -a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = mulk_;
    (void) _saxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
  }
  kpvt_[k_ - 1] = k_;
  if (swap_) {
    kpvt_[k_ - 1] = imax_;
  }
  goto _l190;
  _l140:;
  if (! (swap_)) {
    goto _l160;
  }
  (void) _sswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1);
  for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
    j_ = km1_ + imax_ - jj_;
    t_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))];
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
  }
  t_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
  _l160:;
  km2_ = k_ - 2;
  if (km2_ == 0) {
    goto _l180;
  }
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = 1.0e0 - ak_ * akm1_;
  for (jj_ = 1; jj_ <= km2_; (jj_)++) {
    j_ = km1_ - jj_;
    bk_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
    bkm1_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
    mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
    mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
    t_ = mulk_;
    (void) _saxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    t_ = mulkm1_;
    (void) _saxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = mulkm1_;
  }
  _l180:;
  kpvt_[k_ - 1] = 1 - k_;
  if (swap_) {
    kpvt_[k_ - 1] = -imax_;
  }
  kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
  _l190:;
  k_ = k_ - kstep_;
  goto _l10;
  _l200:;
  __calls[118].calls++;
  return 0;
}

int_4 _ssisl (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ b_)
{
  static int_4 k_, kp_;
  static real_4 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern real_4 _sdot ();
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _saxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  k_ = k_ - 1;
  goto _l70;
  _l40:;
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _saxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  (void) _saxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &b_[0], &_k1);
  _l60:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = b_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = b_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _sdot (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _sdot (($4_ = k_ - 1, &$4_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _sdot (($5_ = k_ - 1, &$5_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &b_[0], &_k1)
  ;
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[119].calls++;
  return 0;
}

int_4 _sspco (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ rcond_, real_4 _p_ z_)
{
  static int_4 i_, ij_, ik_, ikm1_, ikp1_, info_, j_, jm1_, j1_, k_, kk_, km1k_, km1km1_, kp_, kps_, ks_;
  static real_4 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, anorm_, s_, ynorm_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern real_4 _sdot ();
  extern real_4 _sasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = _sasum (&j_, &ap_[j1_ - 1], &_k1);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = z_[i_ - 1] + _abs (ap_[ij_ - 1]);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, z_[j_ - 1]);
  }
  (void) _sspfa (ap_, n_, kpvt_, &info_);
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  kk_ = ik_ + k_;
  ikm1_ = ik_ - (k_ - 1);
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (z_[k_ - 1] != 0.0e0) {
    ek_ = _sign (ek_, z_[k_ - 1]);
  }
  z_[k_ - 1] = z_[k_ - 1] + ek_;
  (void) _saxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
  if (ks_ == 1) {
    goto _l80;
  }
  if (z_[k_ - 1 - 1] != 0.0e0) {
    ek_ = _sign (ek_, z_[k_ - 1 - 1]);
  }
  z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
  (void) _saxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
  _l80:;
  if (ks_ == 2) {
    goto _l100;
  }
  if (_abs (z_[k_ - 1]) <= _abs (ap_[kk_ - 1])) {
    goto _l90;
  }
  s_ = _abs (ap_[kk_ - 1]) / _abs (z_[k_ - 1]);
  (void) _sscal (n_, &s_, z_, &_k1);
  ek_ = s_ * ek_;
  _l90:;
  if (ap_[kk_ - 1] != 0.0e0) {
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
  }
  if (ap_[kk_ - 1] == 0.0e0) {
    z_[k_ - 1] = 1.0;
  }
  goto _l110;
  _l100:;
  km1k_ = ik_ + k_ - 1;
  km1km1_ = ikm1_ + k_ - 1;
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = z_[k_ - 1] / ap_[km1k_ - 1];
  bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  _l110:;
  k_ = k_ - ks_;
  ik_ = ik_ - k_;
  if (ks_ == 2) {
    ik_ = ik_ - (k_ + 1);
  }
  goto _l60;
  _l120:;
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  k_ = 1;
  ik_ = 0;
  _l130:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == 1) {
    goto _l150;
  }
  z_[k_ - 1] = z_[k_ - 1] + _sdot (($2_ = k_ - 1, &$2_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
  ikp1_ = ik_ + k_;
  if (ks_ == 2) {
    z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _sdot (($3_ = k_ - 1, &$3_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l140;
  }
  t_ = z_[k_ - 1];
  z_[k_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l140:;
  _l150:;
  ik_ = ik_ + k_;
  if (ks_ == 2) {
    ik_ = ik_ + (k_ + 1);
  }
  k_ = k_ + ks_;
  goto _l130;
  _l160:;
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  k_ = (*n_);
  ik_ = (*n_) * ((*n_) - 1) / 2;
  _l170:;
  if (k_ == 0) {
    goto _l230;
  }
  kk_ = ik_ + k_;
  ikm1_ = ik_ - (k_ - 1);
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == ks_) {
    goto _l190;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l180;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l180:;
  (void) _saxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
  if (ks_ == 2) {
    (void) _saxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  _l190:;
  if (ks_ == 2) {
    goto _l210;
  }
  if (_abs (z_[k_ - 1]) <= _abs (ap_[kk_ - 1])) {
    goto _l200;
  }
  s_ = _abs (ap_[kk_ - 1]) / _abs (z_[k_ - 1]);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  _l200:;
  if (ap_[kk_ - 1] != 0.0e0) {
    z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
  }
  if (ap_[kk_ - 1] == 0.0e0) {
    z_[k_ - 1] = 1.0;
  }
  goto _l220;
  _l210:;
  km1k_ = ik_ + k_ - 1;
  km1km1_ = ikm1_ + k_ - 1;
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = z_[k_ - 1] / ap_[km1k_ - 1];
  bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  _l220:;
  k_ = k_ - ks_;
  ik_ = ik_ - k_;
  if (ks_ == 2) {
    ik_ = ik_ - (k_ + 1);
  }
  goto _l170;
  _l230:;
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  k_ = 1;
  ik_ = 0;
  _l240:;
  if (k_ > (*n_)) {
    goto _l270;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  if (k_ == 1) {
    goto _l260;
  }
  z_[k_ - 1] = z_[k_ - 1] + _sdot (($6_ = k_ - 1, &$6_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
  ikp1_ = ik_ + k_;
  if (ks_ == 2) {
    z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _sdot (($7_ = k_ - 1, &$7_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l250;
  }
  t_ = z_[k_ - 1];
  z_[k_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l250:;
  _l260:;
  ik_ = ik_ + k_;
  if (ks_ == 2) {
    ik_ = ik_ + (k_ + 1);
  }
  k_ = k_ + ks_;
  goto _l240;
  _l270:;
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (anorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / anorm_;
  }
  if (anorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[120].calls++;
  return 0;
}

int_4 _sspdi (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ det_, int_4 _p_ inert_, real_4 _p_ work_, int_4 
_p_ job_)
{
  static int_4 ij_, ik_, ikp1_, iks_, j_, jb_, jk_, jkp1_, k_, kk_, kkp1_, km1_, ks_, ksj_, kskp1_, kstep_;
  static logical_4 noinv_, nodet_, noert_;
  static real_4 akkp1_, temp_, ten_, d_, t_, ak_, akp1_;
  int_4 $0_, $1_, $2_;
  extern real_4 _sdot ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  noert_ = _imod ((*job_), 1000) / 100 == 0;
  if (nodet_ && noert_) {
    goto _l140;
  }
  if (noert_) {
    goto _l10;
  }
  inert_[0] = 0;
  inert_[1] = 0;
  inert_[2] = 0;
  _l10:;
  if (nodet_) {
    goto _l20;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  _l20:;
  t_ = 0.0;
  ik_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = ik_ + k_;
    d_ = ap_[kk_ - 1];
    if (kpvt_[k_ - 1] > 0) {
      goto _l50;
    }
    if (t_ != 0.0e0) {
      goto _l30;
    }
    ikp1_ = ik_ + k_;
    kkp1_ = ikp1_ + k_;
    t_ = _abs (ap_[kkp1_ - 1]);
    d_ = (d_ / t_) * ap_[kkp1_ + 1 - 1] - t_;
    goto _l40;
    _l30:;
    d_ = t_;
    t_ = 0.0;
    _l40:;
    _l50:;
    if (noert_) {
      goto _l60;
    }
    if (d_ > 0.0e0) {
      inert_[0] = inert_[0] + 1;
    }
    if (d_ < 0.0e0) {
      inert_[1] = inert_[1] + 1;
    }
    if (d_ == 0.0e0) {
      inert_[2] = inert_[2] + 1;
    }
    _l60:;
    if (nodet_) {
      goto _l120;
    }
    det_[0] = d_ * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l110;
    }
    _l70:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l80;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l70;
    _l80:;
    _l90:;
    if (_abs (det_[0]) < ten_) {
      goto _l100;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l90;
    _l100:;
    _l110:;
    _l120:;
    ik_ = ik_ + k_;
  }
  _l140:;
  if (noinv_) {
    goto _l270;
  }
  k_ = 1;
  ik_ = 0;
  _l150:;
  if (k_ > (*n_)) {
    goto _l260;
  }
  km1_ = k_ - 1;
  kk_ = ik_ + k_;
  ikp1_ = ik_ + k_;
  kkp1_ = ikp1_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l180;
  }
  ap_[kk_ - 1] = 1.0e0 / ap_[kk_ - 1];
  if (km1_ < 1) {
    goto _l170;
  }
  (void) _scopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jk_ = ik_ + j_;
    ap_[jk_ - 1] = _sdot (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _saxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kk_ - 1] = ap_[kk_ - 1] + _sdot (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1);
  _l170:;
  kstep_ = 1;
  goto _l220;
  _l180:;
  t_ = _abs (ap_[kkp1_ - 1]);
  ak_ = ap_[kk_ - 1] / t_;
  akp1_ = ap_[kkp1_ + 1 - 1] / t_;
  akkp1_ = ap_[kkp1_ - 1] / t_;
  d_ = t_ * (ak_ * akp1_ - 1.0e0);
  ap_[kk_ - 1] = akp1_ / d_;
  ap_[kkp1_ + 1 - 1] = ak_ / d_;
  ap_[kkp1_ - 1] = -akkp1_ / d_;
  if (km1_ < 1) {
    goto _l210;
  }
  (void) _scopy (&km1_, &ap_[ikp1_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jkp1_ = ikp1_ + j_;
    ap_[jkp1_ - 1] = _sdot (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _saxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kkp1_ + 1 - 1] = ap_[kkp1_ + 1 - 1] + _sdot (&km1_, work_, &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
  ap_[kkp1_ - 1] = ap_[kkp1_ - 1] + _sdot (&km1_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
  (void) _scopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jk_ = ik_ + j_;
    ap_[jk_ - 1] = _sdot (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _saxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kk_ - 1] = ap_[kk_ - 1] + _sdot (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1);
  _l210:;
  kstep_ = 2;
  _l220:;
  ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (ks_ == k_) {
    goto _l250;
  }
  iks_ = (ks_ * (ks_ - 1)) / 2;
  (void) _sswap (&ks_, &ap_[iks_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  ksj_ = ik_ + ks_;
  for (jb_ = ks_; jb_ <= k_; (jb_)++) {
    j_ = k_ + ks_ - jb_;
    jk_ = ik_ + j_;
    temp_ = ap_[jk_ - 1];
    ap_[jk_ - 1] = ap_[ksj_ - 1];
    ap_[ksj_ - 1] = temp_;
    ksj_ = ksj_ - (j_ - 1);
  }
  if (kstep_ == 1) {
    goto _l240;
  }
  kskp1_ = ikp1_ + ks_;
  temp_ = ap_[kskp1_ - 1];
  ap_[kskp1_ - 1] = ap_[kkp1_ - 1];
  ap_[kkp1_ - 1] = temp_;
  _l240:;
  _l250:;
  ik_ = ik_ + k_;
  if (kstep_ == 2) {
    ik_ = ik_ + k_ + 1;
  }
  k_ = k_ + kstep_;
  goto _l150;
  _l260:;
  _l270:;
  __calls[121].calls++;
  return 0;
}

int_4 _sspfa (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 ij_, ijj_, ik_, ikm1_, im_, imax_, imaxp1_, imim_, imj_, imk_, j_, jj_, jk_, jkm1_, jmax_, jmim_, k_, kk_, 
  km1_, km1k_, km1km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_4 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, absakk_, alpha_, colmax_, rowmax_;
  int_4 $0_, $1_;
  extern int_4 _isamax ();
  alpha_ = 0.6403882;
  (*info_) = 0;
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (ap_[0] == 0.0e0) {
    (*info_) = 1;
  }
  goto _l200;
  _l20:;
  km1_ = k_ - 1;
  kk_ = ik_ + k_;
  absakk_ = _abs (ap_[kk_ - 1]);
  imax_ = _isamax (($0_ = k_ - 1, &$0_), &ap_[ik_ + 1 - 1], &_k1);
  imk_ = ik_ + imax_;
  colmax_ = _abs (ap_[imk_ - 1]);
  if (absakk_ < alpha_ * colmax_) {
    goto _l30;
  }
  kstep_ = 1;
  swap_ = FALSE;
  goto _l90;
  _l30:;
  rowmax_ = 0.0;
  imaxp1_ = imax_ + 1;
  im_ = imax_ * (imax_ - 1) / 2;
  imj_ = im_ + 2 * imax_;
  for (j_ = imaxp1_; j_ <= k_; (j_)++) {
    rowmax_ = _max (rowmax_, _abs (ap_[imj_ - 1]));
    imj_ = imj_ + j_;
  }
  if (imax_ == 1) {
    goto _l50;
  }
  jmax_ = _isamax (($1_ = imax_ - 1, &$1_), &ap_[im_ + 1 - 1], &_k1);
  jmim_ = jmax_ + im_;
  rowmax_ = _max (rowmax_, _abs (ap_[jmim_ - 1]));
  _l50:;
  imim_ = imax_ + im_;
  if (_abs (ap_[imim_ - 1]) < alpha_ * rowmax_) {
    goto _l60;
  }
  kstep_ = 1;
  swap_ = TRUE;
  goto _l80;
  _l60:;
  if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
    goto _l70;
  }
  kstep_ = 1;
  swap_ = FALSE;
  goto _l80;
  _l70:;
  kstep_ = 2;
  swap_ = imax_ != km1_;
  _l80:;
  _l90:;
  if (_max (absakk_, colmax_) != 0.0e0) {
    goto _l100;
  }
  kpvt_[k_ - 1] = k_;
  (*info_) = k_;
  goto _l190;
  _l100:;
  if (kstep_ == 2) {
    goto _l140;
  }
  if (! (swap_)) {
    goto _l120;
  }
  (void) _sswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  imj_ = ik_ + imax_;
  for (jj_ = imax_; jj_ <= k_; (jj_)++) {
    j_ = k_ + imax_ - jj_;
    jk_ = ik_ + j_;
    t_ = ap_[jk_ - 1];
    ap_[jk_ - 1] = ap_[imj_ - 1];
    ap_[imj_ - 1] = t_;
    imj_ = imj_ - (j_ - 1);
  }
  _l120:;
  ij_ = ik_ - (k_ - 1);
  for (jj_ = 1; jj_ <= km1_; (jj_)++) {
    j_ = k_ - jj_;
    jk_ = ik_ + j_;
    mulk_ = -ap_[jk_ - 1] / ap_[kk_ - 1];
    t_ = mulk_;
    (void) _saxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
    ijj_ = ij_ + j_;
    ap_[jk_ - 1] = mulk_;
    ij_ = ij_ - (j_ - 1);
  }
  kpvt_[k_ - 1] = k_;
  if (swap_) {
    kpvt_[k_ - 1] = imax_;
  }
  goto _l190;
  _l140:;
  km1k_ = ik_ + k_ - 1;
  ikm1_ = ik_ - (k_ - 1);
  if (! (swap_)) {
    goto _l160;
  }
  (void) _sswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ikm1_ + 1 - 1], &_k1);
  imj_ = ikm1_ + imax_;
  for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
    j_ = km1_ + imax_ - jj_;
    jkm1_ = ikm1_ + j_;
    t_ = ap_[jkm1_ - 1];
    ap_[jkm1_ - 1] = ap_[imj_ - 1];
    ap_[imj_ - 1] = t_;
    imj_ = imj_ - (j_ - 1);
  }
  t_ = ap_[km1k_ - 1];
  ap_[km1k_ - 1] = ap_[imk_ - 1];
  ap_[imk_ - 1] = t_;
  _l160:;
  km2_ = k_ - 2;
  if (km2_ == 0) {
    goto _l180;
  }
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  km1km1_ = ikm1_ + k_ - 1;
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  denom_ = 1.0e0 - ak_ * akm1_;
  ij_ = ik_ - (k_ - 1) - (k_ - 2);
  for (jj_ = 1; jj_ <= km2_; (jj_)++) {
    j_ = km1_ - jj_;
    jk_ = ik_ + j_;
    bk_ = ap_[jk_ - 1] / ap_[km1k_ - 1];
    jkm1_ = ikm1_ + j_;
    bkm1_ = ap_[jkm1_ - 1] / ap_[km1k_ - 1];
    mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
    mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
    t_ = mulk_;
    (void) _saxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
    t_ = mulkm1_;
    (void) _saxpy (&j_, &t_, &ap_[ikm1_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
    ap_[jk_ - 1] = mulk_;
    ap_[jkm1_ - 1] = mulkm1_;
    ijj_ = ij_ + j_;
    ij_ = ij_ - (j_ - 1);
  }
  _l180:;
  kpvt_[k_ - 1] = 1 - k_;
  if (swap_) {
    kpvt_[k_ - 1] = -imax_;
  }
  kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
  _l190:;
  ik_ = ik_ - (k_ - 1);
  if (kstep_ == 2) {
    ik_ = ik_ - (k_ - 2);
  }
  k_ = k_ - kstep_;
  goto _l10;
  _l200:;
  __calls[122].calls++;
  return 0;
}

int_4 _sspsl (real_4 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_4 _p_ b_)
{
  static int_4 ik_, ikm1_, ikp1_, k_, kk_, km1k_, km1km1_, kp_;
  static real_4 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern real_4 _sdot ();
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  kk_ = ik_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _saxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
  k_ = k_ - 1;
  ik_ = ik_ - k_;
  goto _l70;
  _l40:;
  ikm1_ = ik_ - (k_ - 1);
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _saxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  (void) _saxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l60:;
  km1k_ = ik_ + k_ - 1;
  kk_ = ik_ + k_;
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  km1km1_ = ikm1_ + k_ - 1;
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = b_[k_ - 1] / ap_[km1k_ - 1];
  bkm1_ = b_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  ik_ = ik_ - (k_ + 1) - k_;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  ik_ = 0;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _sdot (($3_ = k_ - 1, &$3_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  ik_ = ik_ + k_;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _sdot (($4_ = k_ - 1, &$4_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  ikp1_ = ik_ + k_;
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _sdot (($5_ = k_ - 1, &$5_), &ap_[ikp1_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  ik_ = ik_ + k_ + k_ + 1;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[123].calls++;
  return 0;
}

int_4 _ssvdc (real_4 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, real_4 _p_ s_, real_4 _p_ e_, real_4 _p_ u_, 
int_4 _p_ ldu_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ work_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, iter_, j_, jobu_, k_, kase_, kk_, l_, ll_, lls_, lm1_, lp1_, ls_, lu_, m_, maxit_, mm_, mm1_, mp1_, 
  nct_, nctp1_, ncu_, nrt_, nrtp1_;
  static logical_4 wantu_, wantv_;
  static real_4 t_, r_, b_, c_, cs_, el_, emm1_, f_, g_, scale_, shift_, sl_, sm_, sn_, smm1_, t1_, test_, ztest_;
  int_4 $0_, $1_, $3_, $4_, $5_, $6_, $8_, $9_, $11_, $12_, $13_, $15_, $16_;
  real_4 $2_, $7_, $10_, $14_, $17_, $18_, $19_;
  extern real_4 _sdot ();
  extern real_4 _snrm2 ();
  maxit_ = 30;
  wantu_ = FALSE;
  wantv_ = FALSE;
  jobu_ = _imod ((*job_), 100) / 10;
  ncu_ = (*n_);
  if (jobu_ > 1) {
    ncu_ = _min ((*n_), (*p_));
  }
  if (jobu_ != 0) {
    wantu_ = TRUE;
  }
  if (_imod ((*job_), 10) != 0) {
    wantv_ = TRUE;
  }
  (*info_) = 0;
  nct_ = _min ((*n_) - 1, (*p_));
  nrt_ = _max (0, _min ((*p_) - 2, (*n_)));
  lu_ = _max (nct_, nrt_);
  if (lu_ < 1) {
    goto _l170;
  }
  for (l_ = 1; l_ <= lu_; (l_)++) {
    lp1_ = l_ + 1;
    if (l_ > nct_) {
      goto _l20;
    }
    s_[l_ - 1] = _snrm2 (($0_ = (*n_) - l_ + 1, &$0_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1);
    if (s_[l_ - 1] == 0.0e0) {
      goto _l10;
    }
    if (x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] != 0.0e0) {
      s_[l_ - 1] = _sign (s_[l_ - 1], x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]);
    }
    (void) _sscal (($1_ = (*n_) - l_ + 1, &$1_), ($2_ = 1.0e0 / s_[l_ - 1], &$2_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], 
    &_k1);
    x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = 1.0e0 + x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
    _l10:;
    s_[l_ - 1] = -s_[l_ - 1];
    _l20:;
    if ((*p_) < lp1_) {
      goto _l50;
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      if (l_ > nct_) {
        goto _l30;
      }
      if (s_[l_ - 1] == 0.0e0) {
        goto _l30;
      }
      t_ = -_sdot (($3_ = (*n_) - l_ + 1, &$3_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * ((j_ - 
      1))], &_k1) / x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
      (void) _saxpy (($4_ = (*n_) - l_ + 1, &$4_), &t_, &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * 
      ((j_ - 1))], &_k1);
      _l30:;
      e_[j_ - 1] = x_[l_ - 1 + ((*ldx_)) * ((j_ - 1))];
    }
    _l50:;
    if (! (wantu_) || l_ > nct_) {
      goto _l70;
    }
    for (i_ = l_; i_ <= (*n_); (i_)++) {
      u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((l_ - 1))];
    }
    _l70:;
    if (l_ > nrt_) {
      goto _l150;
    }
    e_[l_ - 1] = _snrm2 (($5_ = (*p_) - l_, &$5_), &e_[lp1_ - 1], &_k1);
    if (e_[l_ - 1] == 0.0e0) {
      goto _l80;
    }
    if (e_[lp1_ - 1] != 0.0e0) {
      e_[l_ - 1] = _sign (e_[l_ - 1], e_[lp1_ - 1]);
    }
    (void) _sscal (($6_ = (*p_) - l_, &$6_), ($7_ = 1.0e0 / e_[l_ - 1], &$7_), &e_[lp1_ - 1], &_k1);
    e_[lp1_ - 1] = 1.0e0 + e_[lp1_ - 1];
    _l80:;
    e_[l_ - 1] = -e_[l_ - 1];
    if (lp1_ > (*n_) || e_[l_ - 1] == 0.0e0) {
      goto _l120;
    }
    for (i_ = lp1_; i_ <= (*n_); (i_)++) {
      work_[i_ - 1] = 0.0;
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      (void) _saxpy (($8_ = (*n_) - l_, &$8_), &e_[j_ - 1], &x_[lp1_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &work_[lp1_ - 1], 
      &_k1);
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      (void) _saxpy (($9_ = (*n_) - l_, &$9_), ($10_ = -e_[j_ - 1] / e_[lp1_ - 1], &$10_), &work_[lp1_ - 1], &_k1, &x_[lp1_ - 
      1 + ((*ldx_)) * ((j_ - 1))], &_k1);
    }
    _l120:;
    if (! (wantv_)) {
      goto _l140;
    }
    for (i_ = lp1_; i_ <= (*p_); (i_)++) {
      v_[i_ - 1 + ((*ldv_)) * ((l_ - 1))] = e_[i_ - 1];
    }
    _l140:;
    _l150:;
  }
  _l170:;
  m_ = _min ((*p_), (*n_) + 1);
  nctp1_ = nct_ + 1;
  nrtp1_ = nrt_ + 1;
  if (nct_ < (*p_)) {
    s_[nctp1_ - 1] = x_[nctp1_ - 1 + ((*ldx_)) * ((nctp1_ - 1))];
  }
  if ((*n_) < m_) {
    s_[m_ - 1] = 0.0;
  }
  if (nrtp1_ < m_) {
    e_[nrtp1_ - 1] = x_[nrtp1_ - 1 + ((*ldx_)) * ((m_ - 1))];
  }
  e_[m_ - 1] = 0.0;
  if (! (wantu_)) {
    goto _l300;
  }
  if (ncu_ < nctp1_) {
    goto _l200;
  }
  for (j_ = nctp1_; j_ <= ncu_; (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      u_[i_ - 1 + ((*ldu_)) * ((j_ - 1))] = 0.0;
    }
    u_[j_ - 1 + ((*ldu_)) * ((j_ - 1))] = 1.0;
  }
  _l200:;
  if (nct_ < 1) {
    goto _l290;
  }
  for (ll_ = 1; ll_ <= nct_; (ll_)++) {
    l_ = nct_ - ll_ + 1;
    if (s_[l_ - 1] == 0.0e0) {
      goto _l250;
    }
    lp1_ = l_ + 1;
    if (ncu_ < lp1_) {
      goto _l220;
    }
    for (j_ = lp1_; j_ <= ncu_; (j_)++) {
      t_ = -_sdot (($11_ = (*n_) - l_ + 1, &$11_), &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[l_ - 1 + ((*ldu_)) * ((j_ 
      - 1))], &_k1) / u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))];
      (void) _saxpy (($12_ = (*n_) - l_ + 1, &$12_), &t_, &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[l_ - 1 + ((*ldu_)) 
      * ((j_ - 1))], &_k1);
    }
    _l220:;
    (void) _sscal (($13_ = (*n_) - l_ + 1, &$13_), ($14_ = -1.0, &$14_), &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1);
    u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))] = 1.0e0 + u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))];
    lm1_ = l_ - 1;
    if (lm1_ < 1) {
      goto _l240;
    }
    for (i_ = 1; i_ <= lm1_; (i_)++) {
      u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = 0.0;
    }
    _l240:;
    goto _l270;
    _l250:;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = 0.0;
    }
    u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))] = 1.0;
    _l270:;
  }
  _l290:;
  _l300:;
  if (! (wantv_)) {
    goto _l350;
  }
  for (ll_ = 1; ll_ <= (*p_); (ll_)++) {
    l_ = (*p_) - ll_ + 1;
    lp1_ = l_ + 1;
    if (l_ > nrt_) {
      goto _l320;
    }
    if (e_[l_ - 1] == 0.0e0) {
      goto _l320;
    }
    for (j_ = lp1_; j_ <= (*p_); (j_)++) {
      t_ = -_sdot (($15_ = (*p_) - l_, &$15_), &v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[lp1_ - 1 + ((*ldv_)) * ((j_ 
      - 1))], &_k1) / v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))];
      (void) _saxpy (($16_ = (*p_) - l_, &$16_), &t_, &v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[lp1_ - 1 + ((*ldv_)) 
      * ((j_ - 1))], &_k1);
    }
    _l320:;
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      v_[i_ - 1 + ((*ldv_)) * ((l_ - 1))] = 0.0;
    }
    v_[l_ - 1 + ((*ldv_)) * ((l_ - 1))] = 1.0;
  }
  _l350:;
  mm_ = m_;
  iter_ = 0;
  _l360:;
  if (m_ == 0) {
    goto _l620;
  }
  if (iter_ < maxit_) {
    goto _l370;
  }
  (*info_) = m_;
  goto _l620;
  _l370:;
  for (ll_ = 1; ll_ <= m_; (ll_)++) {
    l_ = m_ - ll_;
    if (l_ == 0) {
      goto _l400;
    }
    test_ = _abs (s_[l_ - 1]) + _abs (s_[l_ + 1 - 1]);
    ztest_ = test_ + _abs (e_[l_ - 1]);
    if (ztest_ != test_) {
      goto _l380;
    }
    e_[l_ - 1] = 0.0;
    goto _l400;
    _l380:;
  }
  _l400:;
  if (l_ != m_ - 1) {
    goto _l410;
  }
  kase_ = 4;
  goto _l480;
  _l410:;
  lp1_ = l_ + 1;
  mp1_ = m_ + 1;
  for (lls_ = lp1_; lls_ <= mp1_; (lls_)++) {
    ls_ = m_ - lls_ + lp1_;
    if (ls_ == l_) {
      goto _l440;
    }
    test_ = 0.0;
    if (ls_ != m_) {
      test_ = test_ + _abs (e_[ls_ - 1]);
    }
    if (ls_ != l_ + 1) {
      test_ = test_ + _abs (e_[ls_ - 1 - 1]);
    }
    ztest_ = test_ + _abs (s_[ls_ - 1]);
    if (ztest_ != test_) {
      goto _l420;
    }
    s_[ls_ - 1] = 0.0;
    goto _l440;
    _l420:;
  }
  _l440:;
  if (ls_ != l_) {
    goto _l450;
  }
  kase_ = 3;
  goto _l470;
  _l450:;
  if (ls_ != m_) {
    goto _l460;
  }
  kase_ = 1;
  goto _l470;
  _l460:;
  kase_ = 2;
  l_ = ls_;
  _l470:;
  _l480:;
  l_ = l_ + 1;
  switch (kase_) {
    default:
    case 1: goto _l490;
    case 2: goto _l520;
    case 3: goto _l540;
    case 4: goto _l570;
  }
  _l490:;
  mm1_ = m_ - 1;
  f_ = e_[m_ - 1 - 1];
  e_[m_ - 1 - 1] = 0.0;
  for (kk_ = l_; kk_ <= mm1_; (kk_)++) {
    k_ = mm1_ - kk_ + l_;
    t1_ = s_[k_ - 1];
    (void) _srotg (&t1_, &f_, &cs_, &sn_);
    s_[k_ - 1] = t1_;
    if (k_ == l_) {
      goto _l500;
    }
    f_ = -sn_ * e_[k_ - 1 - 1];
    e_[k_ - 1 - 1] = cs_ * e_[k_ - 1 - 1];
    _l500:;
    if (wantv_) {
      (void) _srot (p_, &v_[0 + ((*ldv_)) * ((k_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((m_ - 1))], &_k1, &cs_, &sn_);
    }
  }
  goto _l610;
  _l520:;
  f_ = e_[l_ - 1 - 1];
  e_[l_ - 1 - 1] = 0.0;
  for (k_ = l_; k_ <= m_; (k_)++) {
    t1_ = s_[k_ - 1];
    (void) _srotg (&t1_, &f_, &cs_, &sn_);
    s_[k_ - 1] = t1_;
    f_ = -sn_ * e_[k_ - 1];
    e_[k_ - 1] = cs_ * e_[k_ - 1];
    if (wantu_) {
      (void) _srot (n_, &u_[0 + ((*ldu_)) * ((k_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((l_ - 1 - 1))], &_k1, &cs_, &sn_);
    }
  }
  goto _l610;
  _l540:;
  scale_ = ($17_ = _max (_abs (s_[m_ - 1]), _abs (s_[m_ - 1 - 1])), $17_ = _max ($17_, _abs (e_[m_ - 1 - 1])), $17_ = 
  _max ($17_, _abs (s_[l_ - 1])), _max ($17_, _abs (e_[l_ - 1])));
  sm_ = s_[m_ - 1] / scale_;
  smm1_ = s_[m_ - 1 - 1] / scale_;
  emm1_ = e_[m_ - 1 - 1] / scale_;
  sl_ = s_[l_ - 1] / scale_;
  el_ = e_[l_ - 1] / scale_;
  b_ = ((smm1_ + sm_) * (smm1_ - sm_) + (emm1_ * emm1_)) / 2.0e0;
  c_ = ($18_ = (sm_ * emm1_), $18_ * $18_);
  shift_ = 0.0;
  if (b_ == 0.0e0 && c_ == 0.0e0) {
    goto _l550;
  }
  shift_ = sqrtf ((b_ * b_) + c_);
  if (b_ < 0.0e0) {
    shift_ = -shift_;
  }
  shift_ = c_ / (b_ + shift_);
  _l550:;
  f_ = (sl_ + sm_) * (sl_ - sm_) + shift_;
  g_ = sl_ * el_;
  mm1_ = m_ - 1;
  for (k_ = l_; k_ <= mm1_; (k_)++) {
    (void) _srotg (&f_, &g_, &cs_, &sn_);
    if (k_ != l_) {
      e_[k_ - 1 - 1] = f_;
    }
    f_ = cs_ * s_[k_ - 1] + sn_ * e_[k_ - 1];
    e_[k_ - 1] = cs_ * e_[k_ - 1] - sn_ * s_[k_ - 1];
    g_ = sn_ * s_[k_ + 1 - 1];
    s_[k_ + 1 - 1] = cs_ * s_[k_ + 1 - 1];
    if (wantv_) {
      (void) _srot (p_, &v_[0 + ((*ldv_)) * ((k_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((k_ + 1 - 1))], &_k1, &cs_, &sn_);
    }
    (void) _srotg (&f_, &g_, &cs_, &sn_);
    s_[k_ - 1] = f_;
    f_ = cs_ * e_[k_ - 1] + sn_ * s_[k_ + 1 - 1];
    s_[k_ + 1 - 1] = -sn_ * e_[k_ - 1] + cs_ * s_[k_ + 1 - 1];
    g_ = sn_ * e_[k_ + 1 - 1];
    e_[k_ + 1 - 1] = cs_ * e_[k_ + 1 - 1];
    if (wantu_ && k_ < (*n_)) {
      (void) _srot (n_, &u_[0 + ((*ldu_)) * ((k_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((k_ + 1 - 1))], &_k1, &cs_, &sn_);
    }
  }
  e_[m_ - 1 - 1] = f_;
  iter_ = iter_ + 1;
  goto _l610;
  _l570:;
  if (s_[l_ - 1] >= 0.0e0) {
    goto _l580;
  }
  s_[l_ - 1] = -s_[l_ - 1];
  if (wantv_) {
    (void) _sscal (p_, ($19_ = -1.0, &$19_), &v_[0 + ((*ldv_)) * ((l_ - 1))], &_k1);
  }
  _l580:;
  _l590:;
  if (l_ == mm_) {
    goto _l600;
  }
  if (s_[l_ - 1] >= s_[l_ + 1 - 1]) {
    goto _l600;
  }
  t_ = s_[l_ - 1];
  s_[l_ - 1] = s_[l_ + 1 - 1];
  s_[l_ + 1 - 1] = t_;
  if (wantv_ && l_ < (*p_)) {
    (void) _sswap (p_, &v_[0 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((l_ + 1 - 1))], &_k1);
  }
  if (wantu_ && l_ < (*n_)) {
    (void) _sswap (n_, &u_[0 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((l_ + 1 - 1))], &_k1);
  }
  l_ = l_ + 1;
  goto _l590;
  _l600:;
  iter_ = 0;
  m_ = m_ - 1;
  _l610:;
  goto _l360;
  _l620:;
  __calls[124].calls++;
  return 0;
}

int_4 _strco (real_4 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_4 _p_ rcond_, real_4 _p_ z_, int_4 _p_ job_)
{
  static int_4 i1_, j_, j1_, j2_, k_, kk_, l_;
  static logical_4 lower_;
  static real_4 w_, wk_, wkm_, ek_, tnorm_, ynorm_, s_, sm_;
  int_4 $0_;
  extern real_4 _sasum ();
  lower_ = (*job_) == 0;
  tnorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = j_;
    if (lower_) {
      l_ = (*n_) + 1 - j_;
    }
    i1_ = 1;
    if (lower_) {
      i1_ = j_;
    }
    tnorm_ = _max (tnorm_, _sasum (&l_, &t_[i1_ - 1 + ((*ldt_)) * ((j_ - 1))], &_k1));
  }
  ek_ = 1.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = 0.0;
  }
  for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
    k_ = kk_;
    if (lower_) {
      k_ = (*n_) + 1 - kk_;
    }
    if (z_[k_ - 1] != 0.0e0) {
      ek_ = _sign (ek_, -z_[k_ - 1]);
    }
    if (_abs (ek_ - z_[k_ - 1]) <= _abs (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))])) {
      goto _l30;
    }
    s_ = _abs (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]) / _abs (ek_ - z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ek_ = s_ * ek_;
    _l30:;
    wk_ = ek_ - z_[k_ - 1];
    wkm_ = -ek_ - z_[k_ - 1];
    s_ = _abs (wk_);
    sm_ = _abs (wkm_);
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    wk_ = wk_ / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    wkm_ = wkm_ / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    goto _l50;
    _l40:;
    wk_ = 1.0;
    wkm_ = 1.0;
    _l50:;
    if (kk_ == (*n_)) {
      goto _l90;
    }
    j1_ = k_ + 1;
    if (lower_) {
      j1_ = 1;
    }
    j2_ = (*n_);
    if (lower_) {
      j2_ = k_ - 1;
    }
    for (j_ = j1_; j_ <= j2_; (j_)++) {
      sm_ = sm_ + _abs (z_[j_ - 1] + wkm_ * t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))]);
      z_[j_ - 1] = z_[j_ - 1] + wk_ * t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
      s_ = s_ + _abs (z_[j_ - 1]);
    }
    if (s_ >= sm_) {
      goto _l80;
    }
    w_ = wkm_ - wk_;
    wk_ = wkm_;
    for (j_ = j1_; j_ <= j2_; (j_)++) {
      z_[j_ - 1] = z_[j_ - 1] + w_ * t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
    }
    _l80:;
    _l90:;
    z_[k_ - 1] = wk_;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = 1.0;
  for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
    k_ = (*n_) + 1 - kk_;
    if (lower_) {
      k_ = kk_;
    }
    if (_abs (z_[k_ - 1]) <= _abs (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))])) {
      goto _l110;
    }
    s_ = _abs (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]) / _abs (z_[k_ - 1]);
    (void) _sscal (n_, &s_, z_, &_k1);
    ynorm_ = s_ * ynorm_;
    _l110:;
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] != 0.0e0) {
      z_[k_ - 1] = z_[k_ - 1] / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    }
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0e0) {
      z_[k_ - 1] = 1.0;
    }
    i1_ = 1;
    if (lower_) {
      i1_ = k_ + 1;
    }
    if (kk_ >= (*n_)) {
      goto _l120;
    }
    w_ = -z_[k_ - 1];
    (void) _saxpy (($0_ = (*n_) - kk_, &$0_), &w_, &t_[i1_ - 1 + ((*ldt_)) * ((k_ - 1))], &_k1, &z_[i1_ - 1], &_k1);
    _l120:;
  }
  s_ = 1.0e0 / _sasum (n_, z_, &_k1);
  (void) _sscal (n_, &s_, z_, &_k1);
  ynorm_ = s_ * ynorm_;
  if (tnorm_ != 0.0e0) {
    (*rcond_) = ynorm_ / tnorm_;
  }
  if (tnorm_ == 0.0e0) {
    (*rcond_) = 0.0;
  }
  __calls[125].calls++;
  return 0;
}

int_4 _strdi (real_4 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_4 _p_ det_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, j_, k_, kb_, km1_, kp1_;
  static real_4 temp_, ten_;
  int_4 $0_, $1_, $2_;
  if ((*job_) / 100 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = t_[i_ - 1 + ((*ldt_)) * ((i_ - 1))] * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l20;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (_abs (det_[0]) < ten_) {
      goto _l40;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_) / 10, 10) == 0) {
    goto _l170;
  }
  if (_imod ((*job_), 10) == 0) {
    goto _l120;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    (*info_) = k_;
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0e0) {
      goto _l110;
    }
    t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = 1.0e0 / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    temp_ = -t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    (void) _sscal (($0_ = k_ - 1, &$0_), &temp_, &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1);
    kp1_ = k_ + 1;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      temp_ = t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
      t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))] = 0.0;
      (void) _saxpy (&k_, &temp_, &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1);
    }
    _l90:;
  }
  (*info_) = 0;
  _l110:;
  goto _l160;
  _l120:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    (*info_) = k_;
    if (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] == 0.0e0) {
      goto _l180;
    }
    t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = 1.0e0 / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    temp_ = -t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
    if (k_ != (*n_)) {
      (void) _sscal (($1_ = (*n_) - k_, &$1_), &temp_, &t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))], &_k1);
    }
    km1_ = k_ - 1;
    if (km1_ < 1) {
      goto _l140;
    }
    for (j_ = 1; j_ <= km1_; (j_)++) {
      temp_ = t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
      t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))] = 0.0;
      (void) _saxpy (($2_ = (*n_) - k_ + 1, &$2_), &temp_, &t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[k_ - 1 + ((*ldt_)) 
      * ((j_ - 1))], &_k1);
    }
    _l140:;
  }
  (*info_) = 0;
  _l160:;
  _l170:;
  _l180:;
  __calls[126].calls++;
  return 0;
}

int_4 _strsl (real_4 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_4 _p_ b_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 case_, j_, jj_;
  static real_4 temp_;
  int_4 $0_, $1_, $2_;
  extern real_4 _sdot ();
  for ((*info_) = 1; (*info_) <= (*n_); ((*info_))++) {
    if (t_[(*info_) - 1 + ((*ldt_)) * (((*info_) - 1))] == 0.0e0) {
      goto _l150;
    }
  }
  (*info_) = 0;
  case_ = 1;
  if (_imod ((*job_), 10) != 0) {
    case_ = 2;
  }
  if (_imod ((*job_), 100) / 10 != 0) {
    case_ = case_ + 2;
  }
  switch (case_) {
    default:
    case 1: goto _l20;
    case 2: goto _l50;
    case 3: goto _l80;
    case 4: goto _l110;
  }
  _l20:;
  b_[0] = b_[0] / t_[0 + ((*ldt_)) * ((0))];
  if ((*n_) < 2) {
    goto _l40;
  }
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    temp_ = -b_[j_ - 1 - 1];
    (void) _saxpy (($0_ = (*n_) - j_ + 1, &$0_), &temp_, &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &b_[j_ - 1], &_k1)
    ;
    b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
  }
  _l40:;
  goto _l140;
  _l50:;
  b_[(*n_) - 1] = b_[(*n_) - 1] / t_[(*n_) - 1 + ((*ldt_)) * (((*n_) - 1))];
  if ((*n_) < 2) {
    goto _l70;
  }
  for (jj_ = 2; jj_ <= (*n_); (jj_)++) {
    j_ = (*n_) - jj_ + 1;
    temp_ = -b_[j_ + 1 - 1];
    (void) _saxpy (&j_, &temp_, &t_[0 + ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &b_[0], &_k1);
    b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
  }
  _l70:;
  goto _l140;
  _l80:;
  b_[(*n_) - 1] = b_[(*n_) - 1] / t_[(*n_) - 1 + ((*ldt_)) * (((*n_) - 1))];
  if ((*n_) < 2) {
    goto _l100;
  }
  for (jj_ = 2; jj_ <= (*n_); (jj_)++) {
    j_ = (*n_) - jj_ + 1;
    b_[j_ - 1] = b_[j_ - 1] - _sdot (($1_ = jj_ - 1, &$1_), &t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))], &_k1, &b_[j_ + 1 - 
    1], &_k1);
    b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
  }
  _l100:;
  goto _l140;
  _l110:;
  b_[0] = b_[0] / t_[0 + ((*ldt_)) * ((0))];
  if ((*n_) < 2) {
    goto _l130;
  }
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    b_[j_ - 1] = b_[j_ - 1] - _sdot (($2_ = j_ - 1, &$2_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &b_[0], &_k1);
    b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
  }
  _l130:;
  _l140:;
  _l150:;
  __calls[127].calls++;
  return 0;
}

int_4 _zchdc (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ p_, complex_16 _p_ work_, int_4 _p_ jpvt_, int_4 _p_ job_, 
int_4 _p_ info_)
{
  static int_4 pu_, pl_, plp1_, i_, j_, jp_, jt_, k_, kb_, km1_, kp1_, l_, maxl_;
  static logical_4 swapk_, negk_;
  static real_8 maxdia_;
  static complex_16 temp_, zdumr_;
  int_4 $0_, $1_, $2_;
  pl_ = 1;
  pu_ = 0;
  (*info_) = (*p_);
  if ((*job_) == 0) {
    goto _l160;
  }
  for (k_ = 1; k_ <= (*p_); (k_)++) {
    swapk_ = jpvt_[k_ - 1] > 0;
    negk_ = jpvt_[k_ - 1] < 0;
    jpvt_[k_ - 1] = k_;
    if (negk_) {
      jpvt_[k_ - 1] = -jpvt_[k_ - 1];
    }
    if (! (swapk_)) {
      goto _l60;
    }
    if (k_ == pl_) {
      goto _l50;
    }
    (void) _zswap (($0_ = pl_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((pl_ - 1))], &_k1);
    temp_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[pl_ - 1 + ((*lda_)) * ((pl_ - 1))];
    a_[pl_ - 1 + ((*lda_)) * ((pl_ - 1))] = temp_;
    a_[pl_ - 1 + ((*lda_)) * ((k_ - 1))] = conj (a_[pl_ - 1 + ((*lda_)) * ((k_ - 1))]);
    plp1_ = pl_ + 1;
    if ((*p_) < plp1_) {
      goto _l40;
    }
    for (j_ = plp1_; j_ <= (*p_); (j_)++) {
      if (j_ >= k_) {
        goto _l10;
      }
      temp_ = conj (a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))]);
      a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))] = conj (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
      a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = temp_;
      goto _l20;
      _l10:;
      if (j_ == k_) {
        goto _l20;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pl_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l20:;
    }
    _l40:;
    jpvt_[k_ - 1] = jpvt_[pl_ - 1];
    jpvt_[pl_ - 1] = k_;
    _l50:;
    pl_ = pl_ + 1;
    _l60:;
  }
  pu_ = (*p_);
  if ((*p_) < pl_) {
    goto _l150;
  }
  for (kb_ = pl_; kb_ <= (*p_); (kb_)++) {
    k_ = (*p_) - kb_ + pl_;
    if (jpvt_[k_ - 1] >= 0) {
      goto _l130;
    }
    jpvt_[k_ - 1] = -jpvt_[k_ - 1];
    if (pu_ == k_) {
      goto _l120;
    }
    (void) _zswap (($1_ = k_ - 1, &$1_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((pu_ - 1))], &_k1);
    temp_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[pu_ - 1 + ((*lda_)) * ((pu_ - 1))];
    a_[pu_ - 1 + ((*lda_)) * ((pu_ - 1))] = temp_;
    a_[k_ - 1 + ((*lda_)) * ((pu_ - 1))] = conj (a_[k_ - 1 + ((*lda_)) * ((pu_ - 1))]);
    kp1_ = k_ + 1;
    if ((*p_) < kp1_) {
      goto _l110;
    }
    for (j_ = kp1_; j_ <= (*p_); (j_)++) {
      if (j_ >= pu_) {
        goto _l80;
      }
      temp_ = conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = conj (a_[j_ - 1 + ((*lda_)) * ((pu_ - 1))]);
      a_[j_ - 1 + ((*lda_)) * ((pu_ - 1))] = temp_;
      goto _l90;
      _l80:;
      if (j_ == pu_) {
        goto _l90;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[pu_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[pu_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l90:;
    }
    _l110:;
    jt_ = jpvt_[k_ - 1];
    jpvt_[k_ - 1] = jpvt_[pu_ - 1];
    jpvt_[pu_ - 1] = jt_;
    _l120:;
    pu_ = pu_ - 1;
    _l130:;
  }
  _l150:;
  _l160:;
  for (k_ = 1; k_ <= (*p_); (k_)++) {
    maxdia_ = creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
    kp1_ = k_ + 1;
    maxl_ = k_;
    if (k_ < pl_ || k_ >= pu_) {
      goto _l190;
    }
    for (l_ = kp1_; l_ <= pu_; (l_)++) {
      if (creal (a_[l_ - 1 + ((*lda_)) * ((l_ - 1))]) <= maxdia_) {
        goto _l170;
      }
      maxdia_ = creal (a_[l_ - 1 + ((*lda_)) * ((l_ - 1))]);
      maxl_ = l_;
      _l170:;
    }
    _l190:;
    if (maxdia_ > 0.0e0) {
      goto _l200;
    }
    (*info_) = k_ - 1;
    goto _l280;
    _l200:;
    if (k_ == maxl_) {
      goto _l210;
    }
    km1_ = k_ - 1;
    (void) _zswap (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((maxl_ - 1))], &_k1);
    a_[maxl_ - 1 + ((*lda_)) * ((maxl_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLX (maxdia_, 0.0);
    jp_ = jpvt_[maxl_ - 1];
    jpvt_[maxl_ - 1] = jpvt_[k_ - 1];
    jpvt_[k_ - 1] = jp_;
    a_[k_ - 1 + ((*lda_)) * ((maxl_ - 1))] = conj (a_[k_ - 1 + ((*lda_)) * ((maxl_ - 1))]);
    _l210:;
    work_[k_ - 1] = CMPLX (sqrt (creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))])), 0.0);
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = work_[k_ - 1];
    if ((*p_) < kp1_) {
      goto _l260;
    }
    for (j_ = kp1_; j_ <= (*p_); (j_)++) {
      if (k_ == maxl_) {
        goto _l240;
      }
      if (j_ >= maxl_) {
        goto _l220;
      }
      temp_ = conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = conj (a_[j_ - 1 + ((*lda_)) * ((maxl_ - 1))]);
      a_[j_ - 1 + ((*lda_)) * ((maxl_ - 1))] = temp_;
      goto _l230;
      _l220:;
      if (j_ == maxl_) {
        goto _l230;
      }
      temp_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[maxl_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[maxl_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
      _l230:;
      _l240:;
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] / work_[k_ - 1];
      work_[j_ - 1] = conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      temp_ = -a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      (void) _zaxpy (($2_ = j_ - k_, &$2_), &temp_, &work_[kp1_ - 1], &_k1, &a_[kp1_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l260:;
  }
  _l280:;
  __calls[128].calls++;
  return 0;
}

int_4 _zchdd (complex_16 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, complex_16 _p_ x_, complex_16 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ nz_, complex_16 _p_ y_, real_8 _p_ rho_, real_8 _p_ c_, complex_16 _p_ s_, int_4 _p_ info_)
{
  static int_4 i_, ii_, j_;
  static real_4 scale_;
  static real_8 a_, alpha_, azeta_, norm_;
  static complex_16 t_, zeta_, b_, xx_, zdumr_, zdumi_;
  int_4 $0_;
  real_8 $1_, $2_, $3_;
  extern real_8 _dznrm2 ();
  extern complex_16 _zdotc ();
  (*info_) = 0;
  s_[0] = conj (x_[0]) / conj (r_[0 + ((*ldr_)) * ((0))]);
  if ((*p_) < 2) {
    goto _l20;
  }
  for (j_ = 2; j_ <= (*p_); (j_)++) {
    s_[j_ - 1] = conj (x_[j_ - 1]) - _zdotc (($0_ = j_ - 1, &$0_), &r_[0 + ((*ldr_)) * ((j_ - 1))], &_k1, s_, &_k1);
    s_[j_ - 1] = s_[j_ - 1] / conj (r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))]);
  }
  _l20:;
  norm_ = _dznrm2 (p_, s_, &_k1);
  if (norm_ < 1.0e0) {
    goto _l30;
  }
  (*info_) = -1;
  goto _l120;
  _l30:;
  alpha_ = sqrt (1.0e0 - (norm_ * norm_));
  for (ii_ = 1; ii_ <= (*p_); (ii_)++) {
    i_ = (*p_) - ii_ + 1;
    scale_ = alpha_ + cabs (s_[i_ - 1]);
    a_ = alpha_ / scale_;
    b_ = s_[i_ - 1] / scale_;
    norm_ = sqrt ((a_ * a_) + ($1_ = creal (b_), $1_ * $1_) + ($2_ = cimag (b_), $2_ * $2_));
    c_[i_ - 1] = a_ / norm_;
    s_[i_ - 1] = conj (b_) / norm_;
    alpha_ = scale_ * norm_;
  }
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    xx_ = CMPLX (0.0, 0.0);
    for (ii_ = 1; ii_ <= j_; (ii_)++) {
      i_ = j_ - ii_ + 1;
      t_ = c_[i_ - 1] * xx_ + s_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = c_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] - conj (s_[i_ - 1]) * xx_;
      xx_ = t_;
    }
  }
  if ((*nz_) < 1) {
    goto _l110;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    zeta_ = y_[j_ - 1];
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = (z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] - conj (s_[i_ - 1]) * zeta_) / c_[i_ - 1];
      zeta_ = c_[i_ - 1] * zeta_ - s_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
    }
    azeta_ = cabs (zeta_);
    if (azeta_ <= rho_[j_ - 1]) {
      goto _l80;
    }
    (*info_) = 1;
    rho_[j_ - 1] = -1.0;
    goto _l90;
    _l80:;
    rho_[j_ - 1] = rho_[j_ - 1] * sqrt (1.0e0 - ($3_ = (azeta_ / rho_[j_ - 1]), $3_ * $3_));
    _l90:;
  }
  _l110:;
  _l120:;
  __calls[129].calls++;
  return 0;
}

int_4 _zchex (complex_16 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, int_4 _p_ k_, int_4 _p_ l_, complex_16 _p_ z_, int_4 _p_ 
ldz_, int_4 _p_ nz_, real_8 _p_ c_, complex_16 _p_ s_, int_4 _p_ job_)
{
  static int_4 i_, ii_, il_, iu_, j_, jj_, km1_, kp1_, lmk_, lm1_;
  static complex_16 rjp1j_, t_, zdumr_, zdumi_;
  km1_ = (*k_) - 1;
  kp1_ = (*k_) + 1;
  lmk_ = (*l_) - (*k_);
  lm1_ = (*l_) - 1;
  switch ((*job_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l130;
  }
  _l10:;
  for (i_ = 1; i_ <= (*l_); (i_)++) {
    ii_ = (*l_) - i_ + 1;
    s_[i_ - 1] = r_[ii_ - 1 + ((*ldr_)) * (((*l_) - 1))];
  }
  for (jj_ = (*k_); jj_ <= lm1_; (jj_)++) {
    j_ = lm1_ - jj_ + (*k_);
    for (i_ = 1; i_ <= j_; (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ + 1 - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
    }
    r_[j_ + 1 - 1 + ((*ldr_)) * ((j_ + 1 - 1))] = CMPLX (0.0, 0.0);
  }
  if ((*k_) == 1) {
    goto _l60;
  }
  for (i_ = 1; i_ <= km1_; (i_)++) {
    ii_ = (*l_) - i_ + 1;
    r_[i_ - 1 + ((*ldr_)) * (((*k_) - 1))] = s_[ii_ - 1];
  }
  _l60:;
  t_ = s_[0];
  for (i_ = 1; i_ <= lmk_; (i_)++) {
    (void) _zrotg (&s_[i_ + 1 - 1], &t_, &c_[i_ - 1], &s_[i_ - 1]);
    t_ = s_[i_ + 1 - 1];
  }
  r_[(*k_) - 1 + ((*ldr_)) * (((*k_) - 1))] = t_;
  for (j_ = kp1_; j_ <= (*p_); (j_)++) {
    il_ = _max (1, (*l_) - j_ + 1);
    for (ii_ = il_; ii_ <= lmk_; (ii_)++) {
      i_ = (*l_) - ii_;
      t_ = c_[ii_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] = c_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] - conj (s_[ii_ - 1]) * 
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
  }
  if ((*nz_) < 1) {
    goto _l120;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    for (ii_ = 1; ii_ <= lmk_; (ii_)++) {
      i_ = (*l_) - ii_;
      t_ = c_[ii_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] = c_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] - conj (s_[ii_ - 1]) * 
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
  }
  _l120:;
  goto _l260;
  _l130:;
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    ii_ = lmk_ + i_;
    s_[ii_ - 1] = r_[i_ - 1 + ((*ldr_)) * (((*k_) - 1))];
  }
  for (j_ = (*k_); j_ <= lm1_; (j_)++) {
    for (i_ = 1; i_ <= j_; (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = r_[i_ - 1 + ((*ldr_)) * ((j_ + 1 - 1))];
    }
    jj_ = j_ - km1_;
    s_[jj_ - 1] = r_[j_ + 1 - 1 + ((*ldr_)) * ((j_ + 1 - 1))];
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    ii_ = lmk_ + i_;
    r_[i_ - 1 + ((*ldr_)) * (((*l_) - 1))] = s_[ii_ - 1];
  }
  for (i_ = kp1_; i_ <= (*l_); (i_)++) {
    r_[i_ - 1 + ((*ldr_)) * (((*l_) - 1))] = CMPLX (0.0, 0.0);
  }
  for (j_ = (*k_); j_ <= (*p_); (j_)++) {
    if (j_ == (*k_)) {
      goto _l200;
    }
    iu_ = _min (j_ - 1, (*l_) - 1);
    for (i_ = (*k_); i_ <= iu_; (i_)++) {
      ii_ = i_ - (*k_) + 1;
      t_ = c_[ii_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] = c_[ii_ - 1] * r_[i_ + 1 - 1 + ((*ldr_)) * ((j_ - 1))] - conj (s_[ii_ - 1]) * 
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
    _l200:;
    if (j_ >= (*l_)) {
      goto _l210;
    }
    jj_ = j_ - (*k_) + 1;
    t_ = s_[jj_ - 1];
    (void) _zrotg (&r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))], &t_, &c_[jj_ - 1], &s_[jj_ - 1]);
    _l210:;
  }
  if ((*nz_) < 1) {
    goto _l250;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    for (i_ = (*k_); i_ <= lm1_; (i_)++) {
      ii_ = i_ - km1_;
      t_ = c_[ii_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] = c_[ii_ - 1] * z_[i_ + 1 - 1 + ((*ldz_)) * ((j_ - 1))] - conj (s_[ii_ - 1]) * 
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
  }
  _l250:;
  _l260:;
  __calls[130].calls++;
  return 0;
}

int_4 _zchud (complex_16 _p_ r_, int_4 _p_ ldr_, int_4 _p_ p_, complex_16 _p_ x_, complex_16 _p_ z_, int_4 _p_ ldz_, 
int_4 _p_ nz_, complex_16 _p_ y_, real_8 _p_ rho_, real_8 _p_ c_, complex_16 _p_ s_)
{
  static int_4 i_, j_, jm1_;
  static real_8 azeta_, scale_;
  static complex_16 t_, xj_, zeta_;
  real_8 $0_, $1_;
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    xj_ = x_[j_ - 1];
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      t_ = c_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + s_[i_ - 1] * xj_;
      xj_ = c_[i_ - 1] * xj_ - conj (s_[i_ - 1]) * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))];
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = t_;
    }
    _l20:;
    (void) _zrotg (&r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))], &xj_, &c_[j_ - 1], &s_[j_ - 1]);
  }
  if ((*nz_) < 1) {
    goto _l70;
  }
  for (j_ = 1; j_ <= (*nz_); (j_)++) {
    zeta_ = y_[j_ - 1];
    for (i_ = 1; i_ <= (*p_); (i_)++) {
      t_ = c_[i_ - 1] * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] + s_[i_ - 1] * zeta_;
      zeta_ = c_[i_ - 1] * zeta_ - conj (s_[i_ - 1]) * z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))];
      z_[i_ - 1 + ((*ldz_)) * ((j_ - 1))] = t_;
    }
    azeta_ = cabs (zeta_);
    if (azeta_ == 0.0e0 || rho_[j_ - 1] < 0.0e0) {
      goto _l50;
    }
    scale_ = azeta_ + rho_[j_ - 1];
    rho_[j_ - 1] = scale_ * sqrt (($0_ = (azeta_ / scale_), $0_ * $0_) + ($1_ = (rho_[j_ - 1] / scale_), $1_ * $1_));
    _l50:;
  }
  _l70:;
  __calls[131].calls++;
  return 0;
}

int_4 _zgbco (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_8 
_p_ rcond_, complex_16 _p_ z_)
{
  static int_4 is_, info_, j_, ju_, k_, kb_, kp1_, l_, la_, lm_, lz_, m_, mm_;
  static real_8 anorm_, s_, sm_, ynorm_;
  static complex_16 ek_, t_, wk_, wkm_, zdum_, zdum1_, zdum2_, zdumr_, zdumi_;
  extern complex_16 _zdotc ();
  extern real_8 _dzasum ();
  anorm_ = 0.0;
  l_ = (*ml_) + 1;
  is_ = l_ + (*mu_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _dzasum (&l_, &abd_[is_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1));
    if (is_ > (*ml_) + 1) {
      is_ = is_ - 1;
    }
    if (j_ <= (*mu_)) {
      l_ = l_ + 1;
    }
    if (j_ >= (*n_) - (*ml_)) {
      l_ = l_ - 1;
    }
  }
  (void) _zgbfa (abd_, lda_, n_, ml_, mu_, ipvt_, &info_);
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  m_ = (*ml_) + (*mu_) + 1;
  ju_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_16 zdum1__1_ = ek_; complex_16 zdum2__1_ = -z_[k_ - 1]; ({complex_16 zdum__2_ = zdum1__1_; _abs (creal 
    (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
    _abs (cimag (zdum__2_));}));});
  }
  if (({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 
  zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
  goto _l30;
}

s_ = ({complex_16 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));}) / ({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l30:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_16 zdum__1_ = wk_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
sm_ = ({complex_16 zdum__1_ = wkm_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
if (({complex_16 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
goto _l40;
}

wk_ = wk_ / conj (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]);
wkm_ = wkm_ / conj (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]);
goto _l50;
_l40:;
wk_ = CMPLX (1.0, 0.0);
wkm_ = CMPLX (1.0, 0.0);
_l50:;
kp1_ = k_ + 1;
ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
mm_ = m_;
if (kp1_ > ju_) {
  goto _l90;
}

for (j_ = kp1_; j_ <= ju_; (j_)++) {
  mm_ = mm_ - 1;
  sm_ = sm_ + ({complex_16 zdum__1_ = z_[j_ - 1] + wkm_ * conj (abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))]); _abs (creal 
  (zdum__1_)) + _abs (cimag (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conj (abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_16 zdum__1_ = z_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l80;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
mm_ = m_;
for (j_ = kp1_; j_ <= ju_; (j_)++) {
  mm_ = mm_ - 1;
  z_[j_ - 1] = z_[j_ - 1] + t_ * conj (abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))]);
}

_l80:;
_l90:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  lm_ = _min ((*ml_), (*n_) - k_);
  if (k_ < (*n_)) {
    z_[k_ - 1] = z_[k_ - 1] + _zdotc (&lm_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
  }
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= 1.0e0) {
  goto _l110;
}

s_ = 1.0e0 / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
_l110:;
l_ = ipvt_[k_ - 1];
t_ = z_[l_ - 1];
z_[l_ - 1] = z_[k_ - 1];
z_[k_ - 1] = t_;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  l_ = ipvt_[k_ - 1];
  t_ = z_[l_ - 1];
  z_[l_ - 1] = z_[k_ - 1];
  z_[k_ - 1] = t_;
  lm_ = _min ((*ml_), (*n_) - k_);
  if (k_ < (*n_)) {
    (void) _zaxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
  }
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= 1.0e0) {
  goto _l130;
}

s_ = 1.0e0 / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l130:;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
  abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
  goto _l150;
}

s_ = ({complex_16 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));}) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l150:;
if (({complex_16 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
!= 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_16 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

lm_ = _min (k_, m_) - 1;
la_ = m_ - lm_;
lz_ = k_ - lm_;
t_ = -z_[k_ - 1];
(void) _zaxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lz_ - 1], &_k1);
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[132].calls++;
return 0;
}

int_4 _zgbdi (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
complex_16 _p_ det_)
{
  static int_4 i_, m_;
  static real_8 ten_;
  static complex_16 zdum_, zdumr_, zdumi_;
  m_ = (*ml_) + (*mu_) + 1;
  det_[0] = CMPLX (1.0, 0.0);
  det_[1] = CMPLX (0.0, 0.0);
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = abd_[m_ - 1 + ((*lda_)) * ((i_ - 1))] * det_[0];
    if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
    goto _l60;
  }
  _l10:;
  if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) >= 1.0e0) {
  goto _l20;
}

det_[0] = CMPLX (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLX (1.0, 0.0);
goto _l10;
_l20:;
_l30:;
if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) < ten_) {
goto _l40;
}

det_[0] = det_[0] / CMPLX (ten_, 0.0);
det_[1] = det_[1] + CMPLX (1.0, 0.0);
goto _l30;
_l40:;
}

_l60:;
__calls[133].calls++;
return 0;
}

int_4 _zgbfa (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, int_4 
_p_ info_)
{
  static int_4 i_, i0_, j_, ju_, jz_, j0_, j1_, k_, kp1_, l_, lm_, m_, mm_, nm1_;
  static complex_16 t_, zdum_, zdumr_, zdumi_;
  int_4 $0_;
  extern int_4 _izamax ();
  m_ = (*ml_) + (*mu_) + 1;
  (*info_) = 0;
  j0_ = (*mu_) + 2;
  j1_ = _min ((*n_), m_) - 1;
  if (j1_ < j0_) {
    goto _l30;
  }
  for (jz_ = j0_; jz_ <= j1_; (jz_)++) {
    i0_ = m_ + 1 - jz_;
    for (i_ = i0_; i_ <= (*ml_); (i_)++) {
      abd_[i_ - 1 + ((*lda_)) * ((jz_ - 1))] = CMPLX (0.0, 0.0);
    }
  }
  _l30:;
  jz_ = j1_;
  ju_ = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l130;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    jz_ = jz_ + 1;
    if (jz_ > (*n_)) {
      goto _l50;
    }
    if ((*ml_) < 1) {
      goto _l50;
    }
    for (i_ = 1; i_ <= (*ml_); (i_)++) {
      abd_[i_ - 1 + ((*lda_)) * ((jz_ - 1))] = CMPLX (0.0, 0.0);
    }
    _l50:;
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = _izamax (($0_ = lm_ + 1, &$0_), &abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + m_ - 1;
    ipvt_[k_ - 1] = l_ + k_ - m_;
    if (({complex_16 zdum__1_ = abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
    == 0.0e0) {
    goto _l100;
  }
  if (l_ == m_) {
    goto _l60;
  }
  t_ = abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
  abd_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
  abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
  _l60:;
  t_ = -CMPLX (1.0, 0.0) / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
  (void) _zscal (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1);
  ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
  mm_ = m_;
  if (ju_ < kp1_) {
    goto _l90;
  }
  for (j_ = kp1_; j_ <= ju_; (j_)++) {
    l_ = l_ - 1;
    mm_ = mm_ - 1;
    t_ = abd_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
    if (l_ == mm_) {
      goto _l70;
    }
    abd_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))];
    abd_[mm_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
    _l70:;
    (void) _zaxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &abd_[mm_ + 1 - 1 + ((*lda_)) * ((j_ - 
    1))], &_k1);
  }
  _l90:;
  goto _l110;
  _l100:;
  (*info_) = k_;
  _l110:;
}

_l130:;
ipvt_[(*n_) - 1] = (*n_);
if (({complex_16 zdum__1_ = abd_[m_ - 1 + ((*lda_)) * (((*n_) - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));}) == 0.0e0) {
(*info_) = (*n_);
}

__calls[134].calls++;
return 0;
}

int_4 _zgbsl (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
complex_16 _p_ b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, la_, lb_, lm_, m_, nm1_;
  static complex_16 t_, zdumr_, zdumi_;
  extern complex_16 _zdotc ();
  m_ = (*mu_) + (*ml_) + 1;
  nm1_ = (*n_) - 1;
  if ((*job_) != 0) {
    goto _l50;
  }
  if ((*ml_) == 0) {
    goto _l30;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    (void) _zaxpy (&lm_, &t_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))];
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lb_ = k_ - lm_;
    t_ = -b_[k_ - 1];
    (void) _zaxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_, m_) - 1;
    la_ = m_ - lm_;
    lb_ = k_ - lm_;
    t_ = _zdotc (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / conj (abd_[m_ - 1 + ((*lda_)) * ((k_ - 1))]);
  }
  if ((*ml_) == 0) {
    goto _l90;
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    lm_ = _min ((*ml_), (*n_) - k_);
    b_[k_ - 1] = b_[k_ - 1] + _zdotc (&lm_, &abd_[m_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[135].calls++;
  return 0;
}

int_4 _zgeco (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ rcond_, complex_16 _p_ z_)
{
  static int_4 info_, j_, k_, kb_, kp1_, l_;
  static real_8 anorm_, s_, sm_, ynorm_;
  static complex_16 ek_, t_, wk_, wkm_, zdum_, zdum1_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_;
  extern complex_16 _zdotc ();
  extern real_8 _dzasum ();
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _dzasum (n_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1));
  }
  (void) _zgefa (a_, lda_, n_, ipvt_, &info_);
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_16 zdum1__1_ = ek_; complex_16 zdum2__1_ = -z_[k_ - 1]; ({complex_16 zdum__2_ = zdum1__1_; _abs (creal 
    (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
    _abs (cimag (zdum__2_));}));});
  }
  if (({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 
  zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
  goto _l30;
}

s_ = ({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
/ ({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l30:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_16 zdum__1_ = wk_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
sm_ = ({complex_16 zdum__1_ = wkm_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
goto _l40;
}

wk_ = wk_ / conj (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
wkm_ = wkm_ / conj (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
goto _l50;
_l40:;
wk_ = CMPLX (1.0, 0.0);
wkm_ = CMPLX (1.0, 0.0);
_l50:;
kp1_ = k_ + 1;
if (kp1_ > (*n_)) {
  goto _l90;
}

for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  sm_ = sm_ + ({complex_16 zdum__1_ = z_[j_ - 1] + wkm_ * conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]); _abs (creal 
  (zdum__1_)) + _abs (cimag (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_16 zdum__1_ = z_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l80;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  z_[j_ - 1] = z_[j_ - 1] + t_ * conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
}

_l80:;
_l90:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (k_ < (*n_)) {
    z_[k_ - 1] = z_[k_ - 1] + _zdotc (($0_ = (*n_) - k_, &$0_), &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 
    - 1], &_k1);
  }
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= 1.0e0) {
  goto _l110;
}

s_ = 1.0e0 / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
_l110:;
l_ = ipvt_[k_ - 1];
t_ = z_[l_ - 1];
z_[l_ - 1] = z_[k_ - 1];
z_[k_ - 1] = t_;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  l_ = ipvt_[k_ - 1];
  t_ = z_[l_ - 1];
  z_[l_ - 1] = z_[k_ - 1];
  z_[k_ - 1] = t_;
  if (k_ < (*n_)) {
    (void) _zaxpy (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[k_ + 1 - 1], &_k1);
  }
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= 1.0e0) {
  goto _l130;
}

s_ = 1.0e0 / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l130:;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
  goto _l150;
}

s_ = ({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
/ ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l150:;
if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
!= 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

t_ = -z_[k_ - 1];
(void) _zaxpy (($2_ = k_ - 1, &$2_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[136].calls++;
return 0;
}

int_4 _zgedi (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, complex_16 _p_ det_, complex_16 _p_ 
work_, int_4 _p_ job_)
{
  static int_4 i_, j_, k_, kb_, kp1_, l_, nm1_;
  static real_8 ten_;
  static complex_16 t_, zdum_, zdumr_, zdumi_;
  int_4 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = CMPLX (1.0, 0.0);
  det_[1] = CMPLX (0.0, 0.0);
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = a_[i_ - 1 + ((*lda_)) * ((i_ - 1))] * det_[0];
    if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
    goto _l60;
  }
  _l10:;
  if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) >= 1.0e0) {
  goto _l20;
}

det_[0] = CMPLX (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLX (1.0, 0.0);
goto _l10;
_l20:;
_l30:;
if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) < ten_) {
goto _l40;
}

det_[0] = det_[0] / CMPLX (ten_, 0.0);
det_[1] = det_[1] + CMPLX (1.0, 0.0);
goto _l30;
_l40:;
}

_l60:;
_l70:;
if (_imod ((*job_), 10) == 0) {
  goto _l150;
}

for (k_ = 1; k_ <= (*n_); (k_)++) {
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLX (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  t_ = -a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  (void) _zscal (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  kp1_ = k_ + 1;
  if ((*n_) < kp1_) {
    goto _l90;
  }
  for (j_ = kp1_; j_ <= (*n_); (j_)++) {
    t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
    (void) _zaxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  }
  _l90:;
}

nm1_ = (*n_) - 1;
if (nm1_ < 1) {
  goto _l140;
}

for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
  k_ = (*n_) - kb_;
  kp1_ = k_ + 1;
  for (i_ = kp1_; i_ <= (*n_); (i_)++) {
    work_[i_ - 1] = a_[i_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[i_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLX (0.0, 0.0);
  }
  for (j_ = kp1_; j_ <= (*n_); (j_)++) {
    t_ = work_[j_ - 1];
    (void) _zaxpy (n_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  }
  l_ = ipvt_[k_ - 1];
  if (l_ != k_) {
    (void) _zswap (n_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((l_ - 1))], &_k1);
  }
}

_l140:;
_l150:;
__calls[137].calls++;
return 0;
}

int_4 _zgefa (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_)
{
  static int_4 j_, k_, kp1_, l_, nm1_;
  static complex_16 t_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_;
  extern int_4 _izamax ();
  (*info_) = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l70;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    l_ = _izamax (($0_ = (*n_) - k_ + 1, &$0_), &a_[k_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + k_ - 1;
    ipvt_[k_ - 1] = l_;
    if (({complex_16 zdum__1_ = a_[l_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
    == 0.0e0) {
    goto _l40;
  }
  if (l_ == k_) {
    goto _l10;
  }
  t_ = a_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
  _l10:;
  t_ = -CMPLX (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  (void) _zscal (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1);
  for (j_ = kp1_; j_ <= (*n_); (j_)++) {
    t_ = a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
    if (l_ == k_) {
      goto _l20;
    }
    a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
    _l20:;
    (void) _zaxpy (($2_ = (*n_) - k_, &$2_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[k_ + 1 - 1 + 
    ((*lda_)) * ((j_ - 1))], &_k1);
  }
  goto _l50;
  _l40:;
  (*info_) = k_;
  _l50:;
}

_l70:;
ipvt_[(*n_) - 1] = (*n_);
if (({complex_16 zdum__1_ = a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));}) == 0.0e0) {
(*info_) = (*n_);
}
__calls[138].calls++;
return 0;
}

int_4 _zgesl (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, complex_16 _p_ b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, nm1_;
  static complex_16 t_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_, $3_;
  extern complex_16 _zdotc ();
  nm1_ = (*n_) - 1;
  if ((*job_) != 0) {
    goto _l50;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    (void) _zaxpy (($0_ = (*n_) - k_, &$0_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _zaxpy (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _zdotc (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / conj (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    b_[k_ - 1] = b_[k_ - 1] + _zdotc (($3_ = (*n_) - k_, &$3_), &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[k_ + 1 
    - 1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[139].calls++;
  return 0;
}

int_4 _zgtsl (int_4 _p_ n_, complex_16 _p_ c_, complex_16 _p_ d_, complex_16 _p_ e_, complex_16 _p_ b_, int_4 _p_ info_
)
{
  static int_4 k_, kb_, kp1_, nm1_, nm2_;
  static complex_16 t_, zdum_, zdumr_, zdumi_;
  (*info_) = 0;
  c_[0] = d_[0];
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l40;
  }
  d_[0] = e_[0];
  e_[0] = CMPLX (0.0, 0.0);
  e_[(*n_) - 1] = CMPLX (0.0, 0.0);
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    if (({complex_16 zdum__1_ = c_[kp1_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) < ({complex_16 zdum__1_ 
    = c_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
    goto _l10;
  }
  t_ = c_[kp1_ - 1];
  c_[kp1_ - 1] = c_[k_ - 1];
  c_[k_ - 1] = t_;
  t_ = d_[kp1_ - 1];
  d_[kp1_ - 1] = d_[k_ - 1];
  d_[k_ - 1] = t_;
  t_ = e_[kp1_ - 1];
  e_[kp1_ - 1] = e_[k_ - 1];
  e_[k_ - 1] = t_;
  t_ = b_[kp1_ - 1];
  b_[kp1_ - 1] = b_[k_ - 1];
  b_[k_ - 1] = t_;
  _l10:;
  if (({complex_16 zdum__1_ = c_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
  goto _l20;
}

(*info_) = k_;
goto _l100;
_l20:;
t_ = -c_[kp1_ - 1] / c_[k_ - 1];
c_[kp1_ - 1] = d_[kp1_ - 1] + t_ * d_[k_ - 1];
d_[kp1_ - 1] = e_[kp1_ - 1] + t_ * e_[k_ - 1];
e_[kp1_ - 1] = CMPLX (0.0, 0.0);
b_[kp1_ - 1] = b_[kp1_ - 1] + t_ * b_[k_ - 1];
}

_l40:;
if (({complex_16 zdum__1_ = c_[(*n_) - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
goto _l50;
}

(*info_) = (*n_);
goto _l90;
_l50:;
nm2_ = (*n_) - 2;
b_[(*n_) - 1] = b_[(*n_) - 1] / c_[(*n_) - 1];
if ((*n_) == 1) {
  goto _l80;
}

b_[nm1_ - 1] = (b_[nm1_ - 1] - d_[nm1_ - 1] * b_[(*n_) - 1]) / c_[nm1_ - 1];
if (nm2_ < 1) {
  goto _l70;
}

for (kb_ = 1; kb_ <= nm2_; (kb_)++) {
  k_ = nm2_ - kb_ + 1;
  b_[k_ - 1] = (b_[k_ - 1] - d_[k_ - 1] * b_[k_ + 1 - 1] - e_[k_ - 1] * b_[k_ + 2 - 1]) / c_[k_ - 1];
}

_l70:;
_l80:;
_l90:;
_l100:;
__calls[140].calls++;
return 0;
}

int_4 _zhico (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, complex_16 _p_ z_)
{
  static int_4 i_, info_, j_, jm1_, k_, kp_, kps_, ks_;
  static real_8 anorm_, s_, ynorm_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, zdum_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_16 _zdotc ();
  extern real_8 _dzasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (_dzasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1), 0.0);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLX (creal (z_[i_ - 1]) + ({complex_16 zdum__1_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs (creal 
      (zdum__1_)) + _abs (cimag (zdum__1_));}), 0.0);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, creal (z_[j_ - 1]));
  }
  (void) _zhifa (a_, lda_, n_, kpvt_, &info_);
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  k_ = (*n_);
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
  ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = z_[k_ - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
  (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
  _abs (cimag (zdum__2_));}));});
}

z_[k_ - 1] = z_[k_ - 1] + ek_;
(void) _zaxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 1) {
  goto _l80;
}

if (({complex_16 zdum__1_ = z_[k_ - 1 - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = z_[k_ - 1 - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
(zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
_abs (cimag (zdum__2_));}));});
}

z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
(void) _zaxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
_l80:;
if (ks_ == 2) {
  goto _l100;
}

if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
goto _l90;
}

s_ = ({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
/ ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l90:;
if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
!= 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

goto _l110;
_l100:;
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / conj (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bk_ = z_[k_ - 1] / conj (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l110:;
k_ = k_ - ks_;
goto _l60;
_l120:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
k_ = 1;
_l130:;
if (k_ > (*n_)) {
  goto _l160;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l150;
}

z_[k_ - 1] = z_[k_ - 1] + _zdotc (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _zdotc (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], 
  &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l140;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l140:;
_l150:;
k_ = k_ + ks_;
goto _l130;
_l160:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
k_ = (*n_);
_l170:;
if (k_ == 0) {
  goto _l230;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == ks_) {
  goto _l190;
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
kps_ = k_ + 1 - ks_;
if (kp_ == kps_) {
  goto _l180;
}

t_ = z_[kps_ - 1];
z_[kps_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l180:;
(void) _zaxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  (void) _zaxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
}

_l190:;
if (ks_ == 2) {
  goto _l210;
}

if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
goto _l200;
}

s_ = ({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
/ ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l200:;
if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
!= 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

goto _l220;
_l210:;
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / conj (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bk_ = z_[k_ - 1] / conj (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l220:;
k_ = k_ - ks_;
goto _l170;
_l230:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
k_ = 1;
_l240:;
if (k_ > (*n_)) {
  goto _l270;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l260;
}

z_[k_ - 1] = z_[k_ - 1] + _zdotc (($6_ = k_ - 1, &$6_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _zdotc (($7_ = k_ - 1, &$7_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], 
  &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l250;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l250:;
_l260:;
k_ = k_ + ks_;
goto _l240;
_l270:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[141].calls++;
return 0;
}

int_4 _zhidi (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ det_, int_4 _p_ inert_, 
complex_16 _p_ work_, int_4 _p_ job_)
{
  static int_4 j_, jb_, k_, km1_, ks_, kstep_;
  static logical_4 noinv_, nodet_, noert_;
  static real_8 ten_, d_, t_, ak_, akp1_;
  static complex_16 akkp1_, temp_, zdumr_;
  int_4 $0_, $1_, $2_;
  extern complex_16 _zdotc ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  noert_ = _imod ((*job_), 1000) / 100 == 0;
  if (nodet_ && noert_) {
    goto _l140;
  }
  if (noert_) {
    goto _l10;
  }
  inert_[0] = 0;
  inert_[1] = 0;
  inert_[2] = 0;
  _l10:;
  if (nodet_) {
    goto _l20;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  _l20:;
  t_ = 0.0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    d_ = creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]);
    if (kpvt_[k_ - 1] > 0) {
      goto _l50;
    }
    if (t_ != 0.0e0) {
      goto _l30;
    }
    t_ = cabs (a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))]);
    d_ = (d_ / t_) * creal (a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))]) - t_;
    goto _l40;
    _l30:;
    d_ = t_;
    t_ = 0.0;
    _l40:;
    _l50:;
    if (noert_) {
      goto _l60;
    }
    if (d_ > 0.0e0) {
      inert_[0] = inert_[0] + 1;
    }
    if (d_ < 0.0e0) {
      inert_[1] = inert_[1] + 1;
    }
    if (d_ == 0.0e0) {
      inert_[2] = inert_[2] + 1;
    }
    _l60:;
    if (nodet_) {
      goto _l120;
    }
    det_[0] = d_ * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l110;
    }
    _l70:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l80;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l70;
    _l80:;
    _l90:;
    if (_abs (det_[0]) < ten_) {
      goto _l100;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l90;
    _l100:;
    _l110:;
    _l120:;
  }
  _l140:;
  if (noinv_) {
    goto _l270;
  }
  k_ = 1;
  _l150:;
  if (k_ > (*n_)) {
    goto _l260;
  }
  km1_ = k_ - 1;
  if (kpvt_[k_ - 1] < 0) {
    goto _l180;
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLX (1.0e0 / creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]), 0.0);
  if (km1_ < 1) {
    goto _l170;
  }
  (void) _zcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _zdotc (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _zaxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
    1))], &_k1);
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + CMPLX (creal (_zdotc (&km1_, work_, &_k1, 
  &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1)), 0.0);
  _l170:;
  kstep_ = 1;
  goto _l220;
  _l180:;
  t_ = cabs (a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))]);
  ak_ = creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / t_;
  akp1_ = creal (a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))]) / t_;
  akkp1_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
  d_ = t_ * (ak_ * akp1_ - 1.0e0);
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLX (akp1_ / d_, 0.0);
  a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = CMPLX (ak_ / d_, 0.0);
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = -akkp1_ / d_;
  if (km1_ < 1) {
    goto _l210;
  }
  (void) _zcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = _zdotc (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _zaxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 
    1 - 1))], &_k1);
  }
  a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] + CMPLX (creal (_zdotc 
  (&km1_, work_, &_k1, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1)), 0.0);
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _zdotc (&km1_, &a_[0 + ((*lda_)) * 
  ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
  (void) _zcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
  for (j_ = 1; j_ <= km1_; (j_)++) {
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _zdotc (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
    (void) _zaxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
    1))], &_k1);
  }
  a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + CMPLX (creal (_zdotc (&km1_, work_, &_k1, 
  &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1)), 0.0);
  _l210:;
  kstep_ = 2;
  _l220:;
  ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (ks_ == k_) {
    goto _l250;
  }
  (void) _zswap (&ks_, &a_[0 + ((*lda_)) * ((ks_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
  for (jb_ = ks_; jb_ <= k_; (jb_)++) {
    j_ = k_ + ks_ - jb_;
    temp_ = conj (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
    a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = conj (a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))]);
    a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
  }
  if (kstep_ == 1) {
    goto _l240;
  }
  temp_ = a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = temp_;
  _l240:;
  _l250:;
  k_ = k_ + kstep_;
  goto _l150;
  _l260:;
  _l270:;
  __calls[142].calls++;
  return 0;
}

int_4 _zhifa (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 imax_, imaxp1_, j_, jj_, jmax_, k_, km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_8 absakk_, alpha_, colmax_, rowmax_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_;
  extern int_4 _izamax ();
  alpha_ = 6.4038820320220756e-1;
  (*info_) = 0;
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (({complex_16 zdum__1_ = a_[0 + ((*lda_)) * ((0))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) 
  {
  (*info_) = 1;
}

goto _l200;
_l20:;
km1_ = k_ - 1;
absakk_ = ({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));});
imax_ = _izamax (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
colmax_ = ({complex_16 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));});
if (absakk_ < alpha_ * colmax_) {
  goto _l30;
}

kstep_ = 1;
swap_ = FALSE;
goto _l90;
_l30:;
rowmax_ = 0.0;
imaxp1_ = imax_ + 1;
for (j_ = imaxp1_; j_ <= k_; (j_)++) {
  rowmax_ = _max (rowmax_, ({complex_16 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs (creal (zdum__1_)) + _abs 
  (cimag (zdum__1_));}));
}

if (imax_ == 1) {
  goto _l50;
}

jmax_ = _izamax (($1_ = imax_ - 1, &$1_), &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1);
rowmax_ = _max (rowmax_, ({complex_16 zdum__1_ = a_[jmax_ - 1 + ((*lda_)) * ((imax_ - 1))]; _abs (creal (zdum__1_)) + 
_abs (cimag (zdum__1_));}));
_l50:;
if (({complex_16 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((imax_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));}) < alpha_ * rowmax_) {
goto _l60;
}

kstep_ = 1;
swap_ = TRUE;
goto _l80;
_l60:;
if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
  goto _l70;
}

kstep_ = 1;
swap_ = FALSE;
goto _l80;
_l70:;
kstep_ = 2;
swap_ = imax_ != km1_;
_l80:;
_l90:;
if (_max (absakk_, colmax_) != 0.0e0) {
  goto _l100;
}

kpvt_[k_ - 1] = k_;
(*info_) = k_;
goto _l190;
_l100:;
if (kstep_ == 2) {
  goto _l140;
}

if (! (swap_)) {
  goto _l120;
}

(void) _zswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
for (jj_ = imax_; jj_ <= k_; (jj_)++) {
  j_ = k_ + imax_ - jj_;
  t_ = conj (a_[j_ - 1 + ((*lda_)) * ((k_ - 1))]);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = conj (a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]);
  a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
}

_l120:;
for (jj_ = 1; jj_ <= km1_; (jj_)++) {
  j_ = k_ - jj_;
  mulk_ = -a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  t_ = conj (mulk_);
  (void) _zaxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLX (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]), 0.0);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
}

kpvt_[k_ - 1] = k_;
if (swap_) {
  kpvt_[k_ - 1] = imax_;
}

goto _l190;
_l140:;
if (! (swap_)) {
  goto _l160;
}

(void) _zswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1);
for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
  j_ = km1_ + imax_ - jj_;
  t_ = conj (a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))]);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = conj (a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]);
  a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
}

t_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))];
a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
_l160:;
km2_ = k_ - 2;
if (km2_ == 0) {
  goto _l180;
}

ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / conj (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
denom_ = 1.0e0 - ak_ * akm1_;
for (jj_ = 1; jj_ <= km2_; (jj_)++) {
  j_ = km1_ - jj_;
  bk_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] / conj (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
  mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
  mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
  t_ = conj (mulk_);
  (void) _zaxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  t_ = conj (mulkm1_);
  (void) _zaxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = mulkm1_;
  a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLX (creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]), 0.0);
}

_l180:;
kpvt_[k_ - 1] = 1 - k_;
if (swap_) {
  kpvt_[k_ - 1] = -imax_;
}

kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
_l190:;
k_ = k_ - kstep_;
goto _l10;
_l200:;
__calls[143].calls++;
return 0;
}

int_4 _zhisl (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ b_)
{
  static int_4 k_, kp_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern complex_16 _zdotc ();
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _zaxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  k_ = k_ - 1;
  goto _l70;
  _l40:;
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _zaxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  (void) _zaxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &b_[0], &_k1);
  _l60:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / conj (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = b_[k_ - 1] / conj (a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))]);
  bkm1_ = b_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _zdotc (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _zdotc (($4_ = k_ - 1, &$4_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _zdotc (($5_ = k_ - 1, &$5_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &b_[0], 
  &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[144].calls++;
  return 0;
}

int_4 _zhpco (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, complex_16 _p_ z_)
{
  static int_4 i_, ij_, ik_, ikm1_, ikp1_, info_, j_, jm1_, j1_, k_, kk_, km1k_, km1km1_, kp_, kps_, ks_;
  static real_8 anorm_, s_, ynorm_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, zdum_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_16 _zdotc ();
  extern real_8 _dzasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (_dzasum (&j_, &ap_[j1_ - 1], &_k1), 0.0);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLX (creal (z_[i_ - 1]) + ({complex_16 zdum__1_ = ap_[ij_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag 
      (zdum__1_));}), 0.0);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, creal (z_[j_ - 1]));
  }
  (void) _zhpfa (ap_, n_, kpvt_, &info_);
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  kk_ = ik_ + k_;
  ikm1_ = ik_ - (k_ - 1);
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
  ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = z_[k_ - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
  (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
  _abs (cimag (zdum__2_));}));});
}

z_[k_ - 1] = z_[k_ - 1] + ek_;
(void) _zaxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
if (ks_ == 1) {
  goto _l80;
}

if (({complex_16 zdum__1_ = z_[k_ - 1 - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = z_[k_ - 1 - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
(zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
_abs (cimag (zdum__2_));}));});
}

z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
(void) _zaxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
_l80:;
if (ks_ == 2) {
  goto _l100;
}

if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
goto _l90;
}

s_ = ({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) / ({complex_16 zdum__1_ 
= z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l90:;
if (({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

if (({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

goto _l110;
_l100:;
km1k_ = ik_ + k_ - 1;
km1km1_ = ikm1_ + k_ - 1;
ak_ = ap_[kk_ - 1] / conj (ap_[km1k_ - 1]);
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
bk_ = z_[k_ - 1] / conj (ap_[km1k_ - 1]);
bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l110:;
k_ = k_ - ks_;
ik_ = ik_ - k_;
if (ks_ == 2) {
  ik_ = ik_ - (k_ + 1);
}

goto _l60;
_l120:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
k_ = 1;
ik_ = 0;
_l130:;
if (k_ > (*n_)) {
  goto _l160;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l150;
}

z_[k_ - 1] = z_[k_ - 1] + _zdotc (($2_ = k_ - 1, &$2_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
ikp1_ = ik_ + k_;
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _zdotc (($3_ = k_ - 1, &$3_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l140;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l140:;
_l150:;
ik_ = ik_ + k_;
if (ks_ == 2) {
  ik_ = ik_ + (k_ + 1);
}

k_ = k_ + ks_;
goto _l130;
_l160:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
k_ = (*n_);
ik_ = (*n_) * ((*n_) - 1) / 2;
_l170:;
if (k_ == 0) {
  goto _l230;
}

kk_ = ik_ + k_;
ikm1_ = ik_ - (k_ - 1);
ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == ks_) {
  goto _l190;
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
kps_ = k_ + 1 - ks_;
if (kp_ == kps_) {
  goto _l180;
}

t_ = z_[kps_ - 1];
z_[kps_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l180:;
(void) _zaxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  (void) _zaxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

_l190:;
if (ks_ == 2) {
  goto _l210;
}

if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
goto _l200;
}

s_ = ({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) / ({complex_16 zdum__1_ 
= z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l200:;
if (({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

if (({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

goto _l220;
_l210:;
km1k_ = ik_ + k_ - 1;
km1km1_ = ikm1_ + k_ - 1;
ak_ = ap_[kk_ - 1] / conj (ap_[km1k_ - 1]);
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
bk_ = z_[k_ - 1] / conj (ap_[km1k_ - 1]);
bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l220:;
k_ = k_ - ks_;
ik_ = ik_ - k_;
if (ks_ == 2) {
  ik_ = ik_ - (k_ + 1);
}

goto _l170;
_l230:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
k_ = 1;
ik_ = 0;
_l240:;
if (k_ > (*n_)) {
  goto _l270;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l260;
}

z_[k_ - 1] = z_[k_ - 1] + _zdotc (($6_ = k_ - 1, &$6_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
ikp1_ = ik_ + k_;
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _zdotc (($7_ = k_ - 1, &$7_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l250;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l250:;
_l260:;
ik_ = ik_ + k_;
if (ks_ == 2) {
  ik_ = ik_ + (k_ + 1);
}

k_ = k_ + ks_;
goto _l240;
_l270:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[145].calls++;
return 0;
}

int_4 _zhpdi (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ det_, int_4 _p_ inert_, complex_16 _p_ 
work_, int_4 _p_ job_)
{
  static int_4 ij_, ik_, ikp1_, iks_, j_, jb_, jk_, jkp1_, k_, kk_, kkp1_, km1_, ks_, ksj_, kskp1_, kstep_;
  static logical_4 noinv_, nodet_, noert_;
  static real_8 ten_, d_, t_, ak_, akp1_;
  static complex_16 akkp1_, temp_, zdumr_;
  int_4 $0_, $1_, $2_;
  extern complex_16 _zdotc ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  noert_ = _imod ((*job_), 1000) / 100 == 0;
  if (nodet_ && noert_) {
    goto _l140;
  }
  if (noert_) {
    goto _l10;
  }
  inert_[0] = 0;
  inert_[1] = 0;
  inert_[2] = 0;
  _l10:;
  if (nodet_) {
    goto _l20;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  ten_ = 10.0;
  _l20:;
  t_ = 0.0;
  ik_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = ik_ + k_;
    d_ = creal (ap_[kk_ - 1]);
    if (kpvt_[k_ - 1] > 0) {
      goto _l50;
    }
    if (t_ != 0.0e0) {
      goto _l30;
    }
    ikp1_ = ik_ + k_;
    kkp1_ = ikp1_ + k_;
    t_ = cabs (ap_[kkp1_ - 1]);
    d_ = (d_ / t_) * creal (ap_[kkp1_ + 1 - 1]) - t_;
    goto _l40;
    _l30:;
    d_ = t_;
    t_ = 0.0;
    _l40:;
    _l50:;
    if (noert_) {
      goto _l60;
    }
    if (d_ > 0.0e0) {
      inert_[0] = inert_[0] + 1;
    }
    if (d_ < 0.0e0) {
      inert_[1] = inert_[1] + 1;
    }
    if (d_ == 0.0e0) {
      inert_[2] = inert_[2] + 1;
    }
    _l60:;
    if (nodet_) {
      goto _l120;
    }
    det_[0] = d_ * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l110;
    }
    _l70:;
    if (_abs (det_[0]) >= 1.0e0) {
      goto _l80;
    }
    det_[0] = ten_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l70;
    _l80:;
    _l90:;
    if (_abs (det_[0]) < ten_) {
      goto _l100;
    }
    det_[0] = det_[0] / ten_;
    det_[1] = det_[1] + 1.0e0;
    goto _l90;
    _l100:;
    _l110:;
    _l120:;
    ik_ = ik_ + k_;
  }
  _l140:;
  if (noinv_) {
    goto _l270;
  }
  k_ = 1;
  ik_ = 0;
  _l150:;
  if (k_ > (*n_)) {
    goto _l260;
  }
  km1_ = k_ - 1;
  kk_ = ik_ + k_;
  ikp1_ = ik_ + k_;
  kkp1_ = ikp1_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l180;
  }
  ap_[kk_ - 1] = CMPLX (1.0e0 / creal (ap_[kk_ - 1]), 0.0);
  if (km1_ < 1) {
    goto _l170;
  }
  (void) _zcopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jk_ = ik_ + j_;
    ap_[jk_ - 1] = _zdotc (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _zaxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kk_ - 1] = ap_[kk_ - 1] + CMPLX (creal (_zdotc (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1)), 0.0);
  _l170:;
  kstep_ = 1;
  goto _l220;
  _l180:;
  t_ = cabs (ap_[kkp1_ - 1]);
  ak_ = creal (ap_[kk_ - 1]) / t_;
  akp1_ = creal (ap_[kkp1_ + 1 - 1]) / t_;
  akkp1_ = ap_[kkp1_ - 1] / t_;
  d_ = t_ * (ak_ * akp1_ - 1.0e0);
  ap_[kk_ - 1] = CMPLX (akp1_ / d_, 0.0);
  ap_[kkp1_ + 1 - 1] = CMPLX (ak_ / d_, 0.0);
  ap_[kkp1_ - 1] = -akkp1_ / d_;
  if (km1_ < 1) {
    goto _l210;
  }
  (void) _zcopy (&km1_, &ap_[ikp1_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jkp1_ = ikp1_ + j_;
    ap_[jkp1_ - 1] = _zdotc (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _zaxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kkp1_ + 1 - 1] = ap_[kkp1_ + 1 - 1] + CMPLX (creal (_zdotc (&km1_, work_, &_k1, &ap_[ikp1_ + 1 - 1], &_k1)), 0.0);
  ap_[kkp1_ - 1] = ap_[kkp1_ - 1] + _zdotc (&km1_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
  (void) _zcopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
  ij_ = 0;
  for (j_ = 1; j_ <= km1_; (j_)++) {
    jk_ = ik_ + j_;
    ap_[jk_ - 1] = _zdotc (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
    (void) _zaxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
    ij_ = ij_ + j_;
  }
  ap_[kk_ - 1] = ap_[kk_ - 1] + CMPLX (creal (_zdotc (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1)), 0.0);
  _l210:;
  kstep_ = 2;
  _l220:;
  ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (ks_ == k_) {
    goto _l250;
  }
  iks_ = (ks_ * (ks_ - 1)) / 2;
  (void) _zswap (&ks_, &ap_[iks_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  ksj_ = ik_ + ks_;
  for (jb_ = ks_; jb_ <= k_; (jb_)++) {
    j_ = k_ + ks_ - jb_;
    jk_ = ik_ + j_;
    temp_ = conj (ap_[jk_ - 1]);
    ap_[jk_ - 1] = conj (ap_[ksj_ - 1]);
    ap_[ksj_ - 1] = temp_;
    ksj_ = ksj_ - (j_ - 1);
  }
  if (kstep_ == 1) {
    goto _l240;
  }
  kskp1_ = ikp1_ + ks_;
  temp_ = ap_[kskp1_ - 1];
  ap_[kskp1_ - 1] = ap_[kkp1_ - 1];
  ap_[kkp1_ - 1] = temp_;
  _l240:;
  _l250:;
  ik_ = ik_ + k_;
  if (kstep_ == 2) {
    ik_ = ik_ + k_ + 1;
  }
  k_ = k_ + kstep_;
  goto _l150;
  _l260:;
  _l270:;
  __calls[146].calls++;
  return 0;
}

int_4 _zhpfa (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 ij_, ijj_, ik_, ikm1_, im_, imax_, imaxp1_, imim_, imj_, imk_, j_, jj_, jk_, jkm1_, jmax_, jmim_, k_, kk_, 
  km1_, km1k_, km1km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_8 absakk_, alpha_, colmax_, rowmax_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_;
  extern int_4 _izamax ();
  alpha_ = 6.4038820320220756e-1;
  (*info_) = 0;
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (({complex_16 zdum__1_ = ap_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  (*info_) = 1;
}

goto _l200;
_l20:;
km1_ = k_ - 1;
kk_ = ik_ + k_;
absakk_ = ({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
imax_ = _izamax (($0_ = k_ - 1, &$0_), &ap_[ik_ + 1 - 1], &_k1);
imk_ = ik_ + imax_;
colmax_ = ({complex_16 zdum__1_ = ap_[imk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
if (absakk_ < alpha_ * colmax_) {
  goto _l30;
}

kstep_ = 1;
swap_ = FALSE;
goto _l90;
_l30:;
rowmax_ = 0.0;
imaxp1_ = imax_ + 1;
im_ = imax_ * (imax_ - 1) / 2;
imj_ = im_ + 2 * imax_;
for (j_ = imaxp1_; j_ <= k_; (j_)++) {
  rowmax_ = _max (rowmax_, ({complex_16 zdum__1_ = ap_[imj_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}));
  imj_ = imj_ + j_;
}

if (imax_ == 1) {
  goto _l50;
}
jmax_ = _izamax (($1_ = imax_ - 1, &$1_), &ap_[im_ + 1 - 1], &_k1);
jmim_ = jmax_ + im_;
rowmax_ = _max (rowmax_, ({complex_16 zdum__1_ = ap_[jmim_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}))
;
_l50:;
imim_ = imax_ + im_;
if (({complex_16 zdum__1_ = ap_[imim_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) < alpha_ * rowmax_) {
goto _l60;
}

kstep_ = 1;
swap_ = TRUE;
goto _l80;
_l60:;
if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
  goto _l70;
}

kstep_ = 1;
swap_ = FALSE;
goto _l80;
_l70:;
kstep_ = 2;
swap_ = imax_ != km1_;
_l80:;
_l90:;
if (_max (absakk_, colmax_) != 0.0e0) {
  goto _l100;
}

kpvt_[k_ - 1] = k_;
(*info_) = k_;
goto _l190;
_l100:;
if (kstep_ == 2) {
  goto _l140;
}

if (! (swap_)) {
  goto _l120;
}

(void) _zswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
imj_ = ik_ + imax_;
for (jj_ = imax_; jj_ <= k_; (jj_)++) {
  j_ = k_ + imax_ - jj_;
  jk_ = ik_ + j_;
  t_ = conj (ap_[jk_ - 1]);
  ap_[jk_ - 1] = conj (ap_[imj_ - 1]);
  ap_[imj_ - 1] = t_;
  imj_ = imj_ - (j_ - 1);
}

_l120:;
ij_ = ik_ - (k_ - 1);
for (jj_ = 1; jj_ <= km1_; (jj_)++) {
  j_ = k_ - jj_;
  jk_ = ik_ + j_;
  mulk_ = -ap_[jk_ - 1] / ap_[kk_ - 1];
  t_ = conj (mulk_);
  (void) _zaxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  ijj_ = ij_ + j_;
  ap_[ijj_ - 1] = CMPLX (creal (ap_[ijj_ - 1]), 0.0);
  ap_[jk_ - 1] = mulk_;
  ij_ = ij_ - (j_ - 1);
}

kpvt_[k_ - 1] = k_;
if (swap_) {
  kpvt_[k_ - 1] = imax_;
}

goto _l190;
_l140:;
km1k_ = ik_ + k_ - 1;
ikm1_ = ik_ - (k_ - 1);
if (! (swap_)) {
  goto _l160;
}

(void) _zswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ikm1_ + 1 - 1], &_k1);
imj_ = ikm1_ + imax_;
for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
  j_ = km1_ + imax_ - jj_;
  jkm1_ = ikm1_ + j_;
  t_ = conj (ap_[jkm1_ - 1]);
  ap_[jkm1_ - 1] = conj (ap_[imj_ - 1]);
  ap_[imj_ - 1] = t_;
  imj_ = imj_ - (j_ - 1);
}

t_ = ap_[km1k_ - 1];
ap_[km1k_ - 1] = ap_[imk_ - 1];
ap_[imk_ - 1] = t_;
_l160:;
km2_ = k_ - 2;
if (km2_ == 0) {
  goto _l180;
}

ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
km1km1_ = ikm1_ + k_ - 1;
akm1_ = ap_[km1km1_ - 1] / conj (ap_[km1k_ - 1]);
denom_ = 1.0e0 - ak_ * akm1_;
ij_ = ik_ - (k_ - 1) - (k_ - 2);
for (jj_ = 1; jj_ <= km2_; (jj_)++) {
  j_ = km1_ - jj_;
  jk_ = ik_ + j_;
  bk_ = ap_[jk_ - 1] / ap_[km1k_ - 1];
  jkm1_ = ikm1_ + j_;
  bkm1_ = ap_[jkm1_ - 1] / conj (ap_[km1k_ - 1]);
  mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
  mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
  t_ = conj (mulk_);
  (void) _zaxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  t_ = conj (mulkm1_);
  (void) _zaxpy (&j_, &t_, &ap_[ikm1_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  ap_[jk_ - 1] = mulk_;
  ap_[jkm1_ - 1] = mulkm1_;
  ijj_ = ij_ + j_;
  ap_[ijj_ - 1] = CMPLX (creal (ap_[ijj_ - 1]), 0.0);
  ij_ = ij_ - (j_ - 1);
}

_l180:;
kpvt_[k_ - 1] = 1 - k_;
if (swap_) {
  kpvt_[k_ - 1] = -imax_;
}

kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
_l190:;
ik_ = ik_ - (k_ - 1);
if (kstep_ == 2) {
  ik_ = ik_ - (k_ - 2);
}

k_ = k_ - kstep_;
goto _l10;
_l200:;
__calls[147].calls++;
return 0;
}

int_4 _zhpsl (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ b_)
{
  static int_4 ik_, ikm1_, ikp1_, k_, kk_, km1k_, km1km1_, kp_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern complex_16 _zdotc ();
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  kk_ = ik_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _zaxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
  k_ = k_ - 1;
  ik_ = ik_ - k_;
  goto _l70;
  _l40:;
  ikm1_ = ik_ - (k_ - 1);
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _zaxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  (void) _zaxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l60:;
  km1k_ = ik_ + k_ - 1;
  kk_ = ik_ + k_;
  ak_ = ap_[kk_ - 1] / conj (ap_[km1k_ - 1]);
  km1km1_ = ikm1_ + k_ - 1;
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = b_[k_ - 1] / conj (ap_[km1k_ - 1]);
  bkm1_ = b_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  ik_ = ik_ - (k_ + 1) - k_;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  ik_ = 0;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _zdotc (($3_ = k_ - 1, &$3_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  ik_ = ik_ + k_;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _zdotc (($4_ = k_ - 1, &$4_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  ikp1_ = ik_ + k_;
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _zdotc (($5_ = k_ - 1, &$5_), &ap_[ikp1_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  ik_ = ik_ + k_ + k_ + 1;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[148].calls++;
  return 0;
}

real_8 _zmach (int_4 _p_ job_)
{
  static real_8 eps_, tiny_, huge_, s_;
  real_8 zmach_;
  eps_ = 1.0;
  _l10:;
  eps_ = eps_ / 2.0e0;
  s_ = 1.0e0 + eps_;
  if (s_ > 1.0e0) {
    goto _l10;
  }
  eps_ = 2.0e0 * eps_;
  s_ = 1.0;
  _l20:;
  tiny_ = s_;
  s_ = s_ / 16.0e0;
  if (s_ * 1.0e0 != 0.0e0) {
    goto _l20;
  }
  tiny_ = tiny_ / eps_;
  s_ = (real_8) (creal (CMPLX (1.0, 0.0) / CMPLX (tiny_, 0.0)));
  if (s_ != 1.0e0 / tiny_) {
    tiny_ = sqrt (tiny_);
  }
  huge_ = 1.0e0 / tiny_;
  if ((*job_) == 1) {
    zmach_ = eps_;
  }
  if ((*job_) == 2) {
    zmach_ = tiny_;
  }
  if ((*job_) == 3) {
    zmach_ = huge_;
  }
  __calls[149].calls++;
  return zmach_;
}

int_4 _zpbco (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ rcond_, complex_16 _p_ z_, 
int_4 _p_ info_)
{
  static int_4 i_, j_, j2_, k_, kb_, kp1_, l_, la_, lb_, lm_, mu_;
  static real_8 anorm_, s_, sm_, ynorm_;
  static complex_16 ek_, t_, wk_, wkm_, zdum_, zdum2_, zdumr_, zdumi_;
  extern complex_16 _zdotc ();
  extern real_8 _dzasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = _min (j_, (*m_) + 1);
    mu_ = _max ((*m_) + 2 - j_, 1);
    z_[j_ - 1] = CMPLX (_dzasum (&l_, &abd_[mu_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1), 0.0);
    k_ = j_ - l_;
    if ((*m_) < mu_) {
      goto _l20;
    }
    for (i_ = mu_; i_ <= (*m_); (i_)++) {
      k_ = k_ + 1;
      z_[k_ - 1] = CMPLX (creal (z_[k_ - 1]) + ({complex_16 zdum__1_ = abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs (creal 
      (zdum__1_)) + _abs (cimag (zdum__1_));}), 0.0);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, creal (z_[j_ - 1]));
  }
  (void) _zpbfa (abd_, lda_, n_, m_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = -z_[k_ - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
    (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
    _abs (cimag (zdum__2_));}));});
  }
  if (({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (abd_[(*m_) 
  + 1 - 1 + ((*lda_)) * ((k_ - 1))])) {
  goto _l60;
}

s_ = creal (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) / ({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal 
(zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l60:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_16 zdum__1_ = wk_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
sm_ = ({complex_16 zdum__1_ = wkm_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
wk_ = wk_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
wkm_ = wkm_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
kp1_ = k_ + 1;
j2_ = _min (k_ + (*m_), (*n_));
i_ = (*m_) + 1;
if (kp1_ > j2_) {
  goto _l100;
}

for (j_ = kp1_; j_ <= j2_; (j_)++) {
  i_ = i_ - 1;
  sm_ = sm_ + ({complex_16 zdum__1_ = z_[j_ - 1] + wkm_ * conj (abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]); _abs (creal 
  (zdum__1_)) + _abs (cimag (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conj (abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_16 zdum__1_ = z_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l90;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
i_ = (*m_) + 1;
for (j_ = kp1_; j_ <= j2_; (j_)++) {
  i_ = i_ - 1;
  z_[j_ - 1] = z_[j_ - 1] + t_ * conj (abd_[i_ - 1 + ((*lda_)) * ((j_ - 1))]);
}

_l90:;
_l100:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (abd_[(*m_) + 1 - 
  1 + ((*lda_)) * ((k_ - 1))])) {
  goto _l120;
}

s_ = creal (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) 
+ _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
_l120:;
z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
lm_ = _min (k_ - 1, (*m_));
la_ = (*m_) + 1 - lm_;
lb_ = k_ - lm_;
t_ = -z_[k_ - 1];
(void) _zaxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  lm_ = _min (k_ - 1, (*m_));
  la_ = (*m_) + 1 - lm_;
  lb_ = k_ - lm_;
  z_[k_ - 1] = z_[k_ - 1] - _zdotc (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (abd_[(*m_) + 1 - 
  1 + ((*lda_)) * ((k_ - 1))])) {
  goto _l140;
}

s_ = creal (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) 
+ _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l140:;
z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (abd_[(*m_) + 1 - 
  1 + ((*lda_)) * ((k_ - 1))])) {
  goto _l160;
}

s_ = creal (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) 
+ _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l160:;
z_[k_ - 1] = z_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
lm_ = _min (k_ - 1, (*m_));
la_ = (*m_) + 1 - lm_;
lb_ = k_ - lm_;
t_ = -z_[k_ - 1];
(void) _zaxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[lb_ - 1], &_k1);
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

_l180:;
__calls[150].calls++;
return 0;
}

int_4 _zpbdi (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ det_)
{
  static int_4 i_;
  static real_8 s_;
  static complex_16 zdumr_;
  real_8 $0_;
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = ($0_ = creal (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((i_ - 1))]), $0_ * $0_) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  __calls[151].calls++;
  return 0;
}

int_4 _zpbfa (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ info_)
{
  static int_4 ik_, j_, jk_, k_, mu_;
  static real_8 s_;
  static complex_16 t_, zdumr_, zdumi_;
  int_4 $0_;
  extern complex_16 _zdotc ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    ik_ = (*m_) + 1;
    jk_ = _max (j_ - (*m_), 1);
    mu_ = _max ((*m_) + 2 - j_, 1);
    if ((*m_) < mu_) {
      goto _l20;
    }
    for (k_ = mu_; k_ <= (*m_); (k_)++) {
      t_ = abd_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _zdotc (($0_ = k_ - mu_, &$0_), &abd_[ik_ - 1 + ((*lda_)) * ((jk_ - 1))], 
      &_k1, &abd_[mu_ - 1 + ((*lda_)) * ((j_ - 1))], &_k1);
      t_ = t_ / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((jk_ - 1))];
      abd_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + creal (t_ * conj (t_));
      ik_ = ik_ - 1;
      jk_ = jk_ + 1;
    }
    _l20:;
    s_ = creal (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))]) - s_;
    if (s_ <= 0.0e0 || cimag (abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))]) != 0.0e0) {
      goto _l40;
    }
    abd_[(*m_) + 1 - 1 + ((*lda_)) * ((j_ - 1))] = CMPLX (sqrt (s_), 0.0);
  }
  (*info_) = 0;
  _l40:;
  __calls[152].calls++;
  return 0;
}

int_4 _zpbsl (complex_16 _p_ abd_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ m_, complex_16 _p_ b_)
{
  static int_4 k_, kb_, la_, lb_, lm_;
  static complex_16 t_, zdumr_, zdumi_;
  extern complex_16 _zdotc ();
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    t_ = _zdotc (&lm_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    lm_ = _min (k_ - 1, (*m_));
    la_ = (*m_) + 1 - lm_;
    lb_ = k_ - lm_;
    b_[k_ - 1] = b_[k_ - 1] / abd_[(*m_) + 1 - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _zaxpy (&lm_, &t_, &abd_[la_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[lb_ - 1], &_k1);
  }
  __calls[153].calls++;
  return 0;
}

int_4 _zpoco (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ rcond_, complex_16 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, j_, jm1_, k_, kb_, kp1_;
  static real_8 anorm_, s_, sm_, ynorm_;
  static complex_16 ek_, t_, wk_, wkm_, zdum_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_;
  extern complex_16 _zdotc ();
  extern real_8 _dzasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (_dzasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1), 0.0);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLX (creal (z_[i_ - 1]) + ({complex_16 zdum__1_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs (creal 
      (zdum__1_)) + _abs (cimag (zdum__1_));}), 0.0);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, creal (z_[j_ - 1]));
  }
  (void) _zpofa (a_, lda_, n_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = -z_[k_ - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
    (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
    _abs (cimag (zdum__2_));}));});
  }
  if (({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (a_[k_ - 1 
  + ((*lda_)) * ((k_ - 1))])) {
  goto _l60;
}

s_ = creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / ({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + 
_abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l60:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_16 zdum__1_ = wk_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
sm_ = ({complex_16 zdum__1_ = wkm_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
wk_ = wk_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
wkm_ = wkm_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
kp1_ = k_ + 1;
if (kp1_ > (*n_)) {
  goto _l100;
}

for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  sm_ = sm_ + ({complex_16 zdum__1_ = z_[j_ - 1] + wkm_ * conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]); _abs (creal 
  (zdum__1_)) + _abs (cimag (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_16 zdum__1_ = z_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l90;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  z_[j_ - 1] = z_[j_ - 1] + t_ * conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
}

_l90:;
_l100:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (a_[k_ - 1 + 
  ((*lda_)) * ((k_ - 1))])) {
  goto _l120;
}

s_ = creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs 
(cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
_l120:;
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
t_ = -z_[k_ - 1];
(void) _zaxpy (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  z_[k_ - 1] = z_[k_ - 1] - _zdotc (($1_ = k_ - 1, &$1_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (a_[k_ - 1 + 
  ((*lda_)) * ((k_ - 1))])) {
  goto _l140;
}
s_ = creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs 
(cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l140:;
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (a_[k_ - 1 + 
  ((*lda_)) * ((k_ - 1))])) {
  goto _l160;
}

s_ = creal (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs 
(cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l160:;
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
t_ = -z_[k_ - 1];
(void) _zaxpy (($2_ = k_ - 1, &$2_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

_l180:;
__calls[154].calls++;
return 0;
}

int_4 _zpodi (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_)
{
  static int_4 i_, j_, jm1_, k_, kp1_;
  static real_8 s_;
  static complex_16 t_, zdumr_;
  int_4 $1_;
  real_8 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = ($0_ = creal (a_[i_ - 1 + ((*lda_)) * ((i_ - 1))]), $0_ * $0_) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l140;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLX (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    (void) _zscal (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    kp1_ = k_ + 1;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
      (void) _zaxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
    }
    _l90:;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l120;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = conj (a_[k_ - 1 + ((*lda_)) * ((j_ - 1))]);
      (void) _zaxpy (&k_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
    }
    _l120:;
    t_ = conj (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
    (void) _zscal (&j_, &t_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  }
  _l140:;
  __calls[155].calls++;
  return 0;
}

int_4 _zpofa (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, jm1_, k_;
  static real_8 s_;
  static complex_16 t_, zdumr_, zdumi_;
  int_4 $0_;
  extern complex_16 _zdotc ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _zdotc (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + 
      ((*lda_)) * ((j_ - 1))], &_k1);
      t_ = t_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + creal (t_ * conj (t_));
    }
    _l20:;
    s_ = creal (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]) - s_;
    if (s_ <= 0.0e0 || cimag (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]) != 0.0e0) {
      goto _l40;
    }
    a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = CMPLX (sqrt (s_), 0.0);
  }
  (*info_) = 0;
  _l40:;
  __calls[156].calls++;
  return 0;
}

int_4 _zposl (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_16 _p_ b_)
{
  static int_4 k_, kb_;
  static complex_16 t_, zdumr_, zdumi_;
  int_4 $0_, $1_;
  extern complex_16 _zdotc ();
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _zdotc (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _zaxpy (($1_ = k_ - 1, &$1_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  __calls[157].calls++;
  return 0;
}

int_4 _zppco (complex_16 _p_ ap_, int_4 _p_ n_, real_8 _p_ rcond_, complex_16 _p_ z_, int_4 _p_ info_)
{
  static int_4 i_, ij_, j_, jm1_, j1_, k_, kb_, kj_, kk_, kp1_;
  static real_8 anorm_, s_, sm_, ynorm_;
  static complex_16 ek_, t_, wk_, wkm_, zdum_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_;
  extern complex_16 _zdotc ();
  extern real_8 _dzasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (_dzasum (&j_, &ap_[j1_ - 1], &_k1), 0.0);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLX (creal (z_[i_ - 1]) + ({complex_16 zdum__1_ = ap_[ij_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag 
      (zdum__1_));}), 0.0);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, creal (z_[j_ - 1]));
  }
  (void) _zppfa (ap_, n_, info_);
  if ((*info_) != 0) {
    goto _l180;
  }
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = kk_ + k_;
    if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = -z_[k_ - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
    (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
    _abs (cimag (zdum__2_));}));});
  }
  if (({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (ap_[kk_ - 
  1])) {
  goto _l60;
}

s_ = creal (ap_[kk_ - 1]) / ({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l60:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_16 zdum__1_ = wk_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
sm_ = ({complex_16 zdum__1_ = wkm_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
wk_ = wk_ / ap_[kk_ - 1];
wkm_ = wkm_ / ap_[kk_ - 1];
kp1_ = k_ + 1;
kj_ = kk_ + k_;
if (kp1_ > (*n_)) {
  goto _l100;
}

for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  sm_ = sm_ + ({complex_16 zdum__1_ = z_[j_ - 1] + wkm_ * conj (ap_[kj_ - 1]); _abs (creal (zdum__1_)) + _abs (cimag 
  (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conj (ap_[kj_ - 1]);
  s_ = s_ + ({complex_16 zdum__1_ = z_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
  kj_ = kj_ + j_;
}

if (s_ >= sm_) {
  goto _l90;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
kj_ = kk_ + k_;
for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  z_[j_ - 1] = z_[j_ - 1] + t_ * conj (ap_[kj_ - 1]);
  kj_ = kj_ + j_;
}

_l90:;
_l100:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (ap_[kk_ - 1])) 
  {
  goto _l120;
}

s_ = creal (ap_[kk_ - 1]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
_l120:;
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
kk_ = kk_ - k_;
t_ = -z_[k_ - 1];
(void) _zaxpy (($0_ = k_ - 1, &$0_), &t_, &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  z_[k_ - 1] = z_[k_ - 1] - _zdotc (($1_ = k_ - 1, &$1_), &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
  kk_ = kk_ + k_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (ap_[kk_ - 1])) 
  {
  goto _l140;
}

s_ = creal (ap_[kk_ - 1]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l140:;
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= creal (ap_[kk_ - 1])) 
  {
  goto _l160;
}

s_ = creal (ap_[kk_ - 1]) / ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l160:;
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
kk_ = kk_ - k_;
t_ = -z_[k_ - 1];
(void) _zaxpy (($2_ = k_ - 1, &$2_), &t_, &ap_[kk_ + 1 - 1], &_k1, &z_[0], &_k1);
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

_l180:;
__calls[158].calls++;
return 0;
}

int_4 _zppdi (complex_16 _p_ ap_, int_4 _p_ n_, real_8 _p_ det_, int_4 _p_ job_)
{
  static int_4 i_, ii_, j_, jj_, jm1_, j1_, k_, kj_, kk_, kp1_, k1_;
  static real_8 s_;
  static complex_16 t_, zdumr_;
  int_4 $1_;
  real_8 $0_;
  if ((*job_) / 10 == 0) {
    goto _l70;
  }
  det_[0] = 1.0;
  det_[1] = 0.0;
  s_ = 10.0;
  ii_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ii_ = ii_ + i_;
    det_[0] = ($0_ = creal (ap_[ii_ - 1]), $0_ * $0_) * det_[0];
    if (det_[0] == 0.0e0) {
      goto _l60;
    }
    _l10:;
    if (det_[0] >= 1.0e0) {
      goto _l20;
    }
    det_[0] = s_ * det_[0];
    det_[1] = det_[1] - 1.0e0;
    goto _l10;
    _l20:;
    _l30:;
    if (det_[0] < s_) {
      goto _l40;
    }
    det_[0] = det_[0] / s_;
    det_[1] = det_[1] + 1.0e0;
    goto _l30;
    _l40:;
  }
  _l60:;
  _l70:;
  if (_imod ((*job_), 10) == 0) {
    goto _l140;
  }
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    k1_ = kk_ + 1;
    kk_ = kk_ + k_;
    ap_[kk_ - 1] = CMPLX (1.0, 0.0) / ap_[kk_ - 1];
    t_ = -ap_[kk_ - 1];
    (void) _zscal (($1_ = k_ - 1, &$1_), &t_, &ap_[k1_ - 1], &_k1);
    kp1_ = k_ + 1;
    j1_ = kk_ + 1;
    kj_ = kk_ + k_;
    if ((*n_) < kp1_) {
      goto _l90;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = ap_[kj_ - 1];
      ap_[kj_ - 1] = CMPLX (0.0, 0.0);
      (void) _zaxpy (&k_, &t_, &ap_[k1_ - 1], &_k1, &ap_[j1_ - 1], &_k1);
      j1_ = j1_ + j_;
      kj_ = kj_ + j_;
    }
    _l90:;
  }
  jj_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    j1_ = jj_ + 1;
    jj_ = jj_ + j_;
    jm1_ = j_ - 1;
    k1_ = 1;
    kj_ = j1_;
    if (jm1_ < 1) {
      goto _l120;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      t_ = conj (ap_[kj_ - 1]);
      (void) _zaxpy (&k_, &t_, &ap_[j1_ - 1], &_k1, &ap_[k1_ - 1], &_k1);
      k1_ = k1_ + k_;
      kj_ = kj_ + 1;
    }
    _l120:;
    t_ = conj (ap_[jj_ - 1]);
    (void) _zscal (&j_, &t_, &ap_[j1_ - 1], &_k1);
  }
  _l140:;
  __calls[159].calls++;
  return 0;
}

int_4 _zppfa (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, jj_, jm1_, k_, kj_, kk_;
  static real_8 s_;
  static complex_16 t_, zdumr_, zdumi_;
  int_4 $0_;
  extern complex_16 _zdotc ();
  jj_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = 0.0;
    jm1_ = j_ - 1;
    kj_ = jj_;
    kk_ = 0;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (k_ = 1; k_ <= jm1_; (k_)++) {
      kj_ = kj_ + 1;
      t_ = ap_[kj_ - 1] - _zdotc (($0_ = k_ - 1, &$0_), &ap_[kk_ + 1 - 1], &_k1, &ap_[jj_ + 1 - 1], &_k1);
      kk_ = kk_ + k_;
      t_ = t_ / ap_[kk_ - 1];
      ap_[kj_ - 1] = t_;
      s_ = s_ + creal (t_ * conj (t_));
    }
    _l20:;
    jj_ = jj_ + j_;
    s_ = creal (ap_[jj_ - 1]) - s_;
    if (s_ <= 0.0e0 || cimag (ap_[jj_ - 1]) != 0.0e0) {
      goto _l40;
    }
    ap_[jj_ - 1] = CMPLX (sqrt (s_), 0.0);
  }
  (*info_) = 0;
  _l40:;
  __calls[160].calls++;
  return 0;
}

int_4 _zppsl (complex_16 _p_ ap_, int_4 _p_ n_, complex_16 _p_ b_)
{
  static int_4 k_, kb_, kk_;
  static complex_16 t_, zdumr_, zdumi_;
  int_4 $0_, $1_;
  extern complex_16 _zdotc ();
  kk_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    t_ = _zdotc (($0_ = k_ - 1, &$0_), &ap_[kk_ + 1 - 1], &_k1, &b_[0], &_k1);
    kk_ = kk_ + k_;
    b_[k_ - 1] = (b_[k_ - 1] - t_) / ap_[kk_ - 1];
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
    kk_ = kk_ - k_;
    t_ = -b_[k_ - 1];
    (void) _zaxpy (($1_ = k_ - 1, &$1_), &t_, &ap_[kk_ + 1 - 1], &_k1, &b_[0], &_k1);
  }
  __calls[161].calls++;
  return 0;
}

int_4 _zptsl (int_4 _p_ n_, complex_16 _p_ d_, complex_16 _p_ e_, complex_16 _p_ b_)
{
  static int_4 k_, kbm1_, ke_, kf_, kp1_, nm1_, nm1d2_;
  static complex_16 t1_, t2_;
  if ((*n_) != 1) {
    goto _l10;
  }
  b_[0] = b_[0] / d_[0];
  goto _l70;
  _l10:;
  nm1_ = (*n_) - 1;
  nm1d2_ = nm1_ / 2;
  if ((*n_) == 2) {
    goto _l30;
  }
  kbm1_ = (*n_) - 1;
  for (k_ = 1; k_ <= nm1d2_; (k_)++) {
    t1_ = conj (e_[k_ - 1]) / d_[k_ - 1];
    d_[k_ + 1 - 1] = d_[k_ + 1 - 1] - t1_ * e_[k_ - 1];
    b_[k_ + 1 - 1] = b_[k_ + 1 - 1] - t1_ * b_[k_ - 1];
    t2_ = e_[kbm1_ - 1] / d_[kbm1_ + 1 - 1];
    d_[kbm1_ - 1] = d_[kbm1_ - 1] - t2_ * conj (e_[kbm1_ - 1]);
    b_[kbm1_ - 1] = b_[kbm1_ - 1] - t2_ * b_[kbm1_ + 1 - 1];
    kbm1_ = kbm1_ - 1;
  }
  _l30:;
  kp1_ = nm1d2_ + 1;
  if (_imod ((*n_), 2) != 0) {
    goto _l40;
  }
  t1_ = conj (e_[kp1_ - 1]) / d_[kp1_ - 1];
  d_[kp1_ + 1 - 1] = d_[kp1_ + 1 - 1] - t1_ * e_[kp1_ - 1];
  b_[kp1_ + 1 - 1] = b_[kp1_ + 1 - 1] - t1_ * b_[kp1_ - 1];
  kp1_ = kp1_ + 1;
  _l40:;
  b_[kp1_ - 1] = b_[kp1_ - 1] / d_[kp1_ - 1];
  if ((*n_) == 2) {
    goto _l60;
  }
  k_ = kp1_ - 1;
  ke_ = kp1_ + nm1d2_ - 1;
  for (kf_ = kp1_; kf_ <= ke_; (kf_)++) {
    b_[k_ - 1] = (b_[k_ - 1] - e_[k_ - 1] * b_[k_ + 1 - 1]) / d_[k_ - 1];
    b_[kf_ + 1 - 1] = (b_[kf_ + 1 - 1] - conj (e_[kf_ - 1]) * b_[kf_ - 1]) / d_[kf_ + 1 - 1];
    k_ = k_ - 1;
  }
  _l60:;
  if (_imod ((*n_), 2) == 0) {
    b_[0] = (b_[0] - e_[0] * b_[1]) / d_[0];
  }
  _l70:;
  __calls[162].calls++;
  return 0;
}

int_4 _zqrdc (complex_16 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, complex_16 _p_ qraux_, int_4 _p_ jpvt_, 
complex_16 _p_ work_, int_4 _p_ job_)
{
  static int_4 j_, jp_, l_, lp1_, lup_, maxj_, pl_, pu_, jj_;
  static logical_4 negj_, swapj_;
  static real_8 maxnrm_, tt_;
  static complex_16 nrmxl_, t_, zdum_, zdum1_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $3_, $4_, $7_;
  real_8 $5_, $6_;
  complex_16 $2_;
  extern real_8 _dznrm2 ();
  extern complex_16 _zdotc ();
  pl_ = 1;
  pu_ = 0;
  if ((*job_) == 0) {
    goto _l60;
  }
  for (j_ = 1; j_ <= (*p_); (j_)++) {
    swapj_ = jpvt_[j_ - 1] > 0;
    negj_ = jpvt_[j_ - 1] < 0;
    jpvt_[j_ - 1] = j_;
    if (negj_) {
      jpvt_[j_ - 1] = -j_;
    }
    if (! (swapj_)) {
      goto _l10;
    }
    if (j_ != pl_) {
      (void) _zswap (n_, &x_[0 + ((*ldx_)) * ((pl_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    }
    jpvt_[j_ - 1] = jpvt_[pl_ - 1];
    jpvt_[pl_ - 1] = j_;
    pl_ = pl_ + 1;
    _l10:;
  }
  pu_ = (*p_);
  for (jj_ = 1; jj_ <= (*p_); (jj_)++) {
    j_ = (*p_) - jj_ + 1;
    if (jpvt_[j_ - 1] >= 0) {
      goto _l40;
    }
    jpvt_[j_ - 1] = -jpvt_[j_ - 1];
    if (j_ == pu_) {
      goto _l30;
    }
    (void) _zswap (n_, &x_[0 + ((*ldx_)) * ((pu_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1);
    jp_ = jpvt_[pu_ - 1];
    jpvt_[pu_ - 1] = jpvt_[j_ - 1];
    jpvt_[j_ - 1] = jp_;
    _l30:;
    pu_ = pu_ - 1;
    _l40:;
  }
  _l60:;
  if (pu_ < pl_) {
    goto _l80;
  }
  for (j_ = pl_; j_ <= pu_; (j_)++) {
    qraux_[j_ - 1] = CMPLX (_dznrm2 (n_, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1), 0.0);
    work_[j_ - 1] = qraux_[j_ - 1];
  }
  _l80:;
  lup_ = _min ((*n_), (*p_));
  for (l_ = 1; l_ <= lup_; (l_)++) {
    if (l_ < pl_ || l_ >= pu_) {
      goto _l120;
    }
    maxnrm_ = 0.0;
    maxj_ = l_;
    for (j_ = l_; j_ <= pu_; (j_)++) {
      if (creal (qraux_[j_ - 1]) <= maxnrm_) {
        goto _l90;
      }
      maxnrm_ = creal (qraux_[j_ - 1]);
      maxj_ = j_;
      _l90:;
    }
    if (maxj_ == l_) {
      goto _l110;
    }
    (void) _zswap (n_, &x_[0 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[0 + ((*ldx_)) * ((maxj_ - 1))], &_k1);
    qraux_[maxj_ - 1] = qraux_[l_ - 1];
    work_[maxj_ - 1] = work_[l_ - 1];
    jp_ = jpvt_[maxj_ - 1];
    jpvt_[maxj_ - 1] = jpvt_[l_ - 1];
    jpvt_[l_ - 1] = jp_;
    _l110:;
    _l120:;
    qraux_[l_ - 1] = CMPLX (0.0, 0.0);
    if (l_ == (*n_)) {
      goto _l190;
    }
    nrmxl_ = CMPLX (_dznrm2 (($0_ = (*n_) - l_ + 1, &$0_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1), 0.0);
    if (({complex_16 zdum__1_ = nrmxl_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
    goto _l180;
  }
  if (({complex_16 zdum__1_ = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
  != 0.0e0) {
  nrmxl_ = ({complex_16 zdum1__1_ = nrmxl_; complex_16 zdum2__1_ = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]; cabs (zdum1__1_) 
  * (zdum2__1_ / cabs (zdum2__1_));});
}

(void) _zscal (($1_ = (*n_) - l_ + 1, &$1_), ($2_ = CMPLX (1.0, 0.0) / nrmxl_, &$2_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 
1))], &_k1);
x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = CMPLX (1.0, 0.0) + x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
lp1_ = l_ + 1;
if ((*p_) < lp1_) {
  goto _l170;
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  t_ = -_zdotc (($3_ = (*n_) - l_ + 1, &$3_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * ((j_ - 
  1))], &_k1) / x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
  (void) _zaxpy (($4_ = (*n_) - l_ + 1, &$4_), &t_, &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * 
  ((j_ - 1))], &_k1);
  if (j_ < pl_ || j_ > pu_) {
    goto _l150;
  }
  if (({complex_16 zdum__1_ = qraux_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l150;
}

tt_ = 1.0e0 - ($5_ = (cabs (x_[l_ - 1 + ((*ldx_)) * ((j_ - 1))]) / creal (qraux_[j_ - 1])), $5_ * $5_);
tt_ = _max (tt_, 0.0);
t_ = CMPLX (tt_, 0.0);
tt_ = 1.0e0 + 0.05e0 * tt_ * ($6_ = (creal (qraux_[j_ - 1]) / creal (work_[j_ - 1])), $6_ * $6_);
if (tt_ == 1.0e0) {
  goto _l130;
}

qraux_[j_ - 1] = qraux_[j_ - 1] * csqrt (t_);
goto _l140;
_l130:;
qraux_[j_ - 1] = CMPLX (_dznrm2 (($7_ = (*n_) - l_, &$7_), &x_[l_ + 1 - 1 + ((*ldx_)) * ((j_ - 1))], &_k1), 0.0);
work_[j_ - 1] = qraux_[j_ - 1];
_l140:;
_l150:;
}

_l170:;
qraux_[l_ - 1] = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = -nrmxl_;
_l180:;
_l190:;
}

__calls[163].calls++;
return 0;
}

int_4 _zqrsl (complex_16 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ k_, complex_16 _p_ qraux_, complex_16 _p_ y_, 
complex_16 _p_ qy_, complex_16 _p_ qty_, complex_16 _p_ b_, complex_16 _p_ rsd_, complex_16 _p_ xb_, int_4 _p_ job_, 
int_4 _p_ info_)
{
  static int_4 i_, j_, jj_, ju_, kp1_;
  static logical_4 cb_, cqy_, cqty_, cr_, cxb_;
  static complex_16 t_, temp_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_;
  extern complex_16 _zdotc ();
  (*info_) = 0;
  cqy_ = (*job_) / 10000 != 0;
  cqty_ = _imod ((*job_), 10000) != 0;
  cb_ = _imod ((*job_), 1000) / 100 != 0;
  cr_ = _imod ((*job_), 100) / 10 != 0;
  cxb_ = _imod ((*job_), 10) != 0;
  ju_ = _min ((*k_), (*n_) - 1);
  if (ju_ != 0) {
    goto _l40;
  }
  if (cqy_) {
    qy_[0] = y_[0];
  }
  if (cqty_) {
    qty_[0] = y_[0];
  }
  if (cxb_) {
    xb_[0] = y_[0];
  }
  if (! (cb_)) {
    goto _l30;
  }
  if (({complex_16 zdum__1_ = x_[0 + ((*ldx_)) * ((0))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) 
  {
  goto _l10;
}

(*info_) = 1;
goto _l20;
_l10:;
b_[0] = y_[0] / x_[0 + ((*ldx_)) * ((0))];
_l20:;
_l30:;
if (cr_) {
  rsd_[0] = CMPLX (0.0, 0.0);
}

goto _l250;
_l40:;
if (cqy_) {
  (void) _zcopy (n_, y_, &_k1, qy_, &_k1);
}

if (cqty_) {
  (void) _zcopy (n_, y_, &_k1, qty_, &_k1);
}

if (! (cqy_)) {
  goto _l70;
}

for (jj_ = 1; jj_ <= ju_; (jj_)++) {
  j_ = ju_ - jj_ + 1;
  if (({complex_16 zdum__1_ = qraux_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l50;
}

temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
t_ = -_zdotc (($0_ = (*n_) - j_ + 1, &$0_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qy_[j_ - 1], &_k1) / x_[j_ - 1 
+ ((*ldx_)) * ((j_ - 1))];
(void) _zaxpy (($1_ = (*n_) - j_ + 1, &$1_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qy_[j_ - 1], &_k1);
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
_l50:;
}

_l70:;
if (! (cqty_)) {
  goto _l100;
}

for (j_ = 1; j_ <= ju_; (j_)++) {
  if (({complex_16 zdum__1_ = qraux_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l80;
}

temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
t_ = -_zdotc (($2_ = (*n_) - j_ + 1, &$2_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qty_[j_ - 1], &_k1) / x_[j_ - 
1 + ((*ldx_)) * ((j_ - 1))];
(void) _zaxpy (($3_ = (*n_) - j_ + 1, &$3_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &qty_[j_ - 1], &_k1);
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
_l80:;
}

_l100:;
if (cb_) {
  (void) _zcopy (k_, qty_, &_k1, b_, &_k1);
}

kp1_ = (*k_) + 1;
if (cxb_) {
  (void) _zcopy (k_, qty_, &_k1, xb_, &_k1);
}

if (cr_ && (*k_) < (*n_)) {
  (void) _zcopy (($4_ = (*n_) - (*k_), &$4_), &qty_[kp1_ - 1], &_k1, &rsd_[kp1_ - 1], &_k1);
}

if (! (cxb_) || kp1_ > (*n_)) {
  goto _l120;
}

for (i_ = kp1_; i_ <= (*n_); (i_)++) {
  xb_[i_ - 1] = CMPLX (0.0, 0.0);
}

_l120:;
if (! (cr_)) {
  goto _l140;
}

for (i_ = 1; i_ <= (*k_); (i_)++) {
  rsd_[i_ - 1] = CMPLX (0.0, 0.0);
}

_l140:;
if (! (cb_)) {
  goto _l190;
}

for (jj_ = 1; jj_ <= (*k_); (jj_)++) {
  j_ = (*k_) - jj_ + 1;
  if (({complex_16 zdum__1_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
  != 0.0e0) {
  goto _l150;
}

(*info_) = j_;
goto _l180;
_l150:;
b_[j_ - 1] = b_[j_ - 1] / x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
if (j_ == 1) {
  goto _l160;
}

t_ = -b_[j_ - 1];
(void) _zaxpy (($5_ = j_ - 1, &$5_), &t_, &x_[0 + ((*ldx_)) * ((j_ - 1))], &_k1, b_, &_k1);
_l160:;
}

_l180:;
_l190:;
if (! (cr_) && ! (cxb_)) {
  goto _l240;
}

for (jj_ = 1; jj_ <= ju_; (jj_)++) {
  j_ = ju_ - jj_ + 1;
  if (({complex_16 zdum__1_ = qraux_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l220;
}

temp_ = x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))];
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = qraux_[j_ - 1];
if (! (cr_)) {
  goto _l200;
}

t_ = -_zdotc (($6_ = (*n_) - j_ + 1, &$6_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &rsd_[j_ - 1], &_k1) / x_[j_ - 
1 + ((*ldx_)) * ((j_ - 1))];
(void) _zaxpy (($7_ = (*n_) - j_ + 1, &$7_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &rsd_[j_ - 1], &_k1);
_l200:;
if (! (cxb_)) {
  goto _l210;
}

t_ = -_zdotc (($8_ = (*n_) - j_ + 1, &$8_), &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &xb_[j_ - 1], &_k1) / x_[j_ - 1 
+ ((*ldx_)) * ((j_ - 1))];
(void) _zaxpy (($9_ = (*n_) - j_ + 1, &$9_), &t_, &x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &xb_[j_ - 1], &_k1);
_l210:;
x_[j_ - 1 + ((*ldx_)) * ((j_ - 1))] = temp_;
_l220:;
}

_l240:;
_l250:;
__calls[164].calls++;
return 0;
}

int_4 _zsico (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, complex_16 _p_ z_)
{
  static int_4 i_, info_, j_, jm1_, k_, kp_, kps_, ks_;
  static real_8 anorm_, s_, ynorm_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, zdum_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_16 _zdotu ();
  extern real_8 _dzasum ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (_dzasum (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1), 0.0);
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLX (creal (z_[i_ - 1]) + ({complex_16 zdum__1_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs (creal 
      (zdum__1_)) + _abs (cimag (zdum__1_));}), 0.0);
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, creal (z_[j_ - 1]));
  }
  (void) _zsifa (a_, lda_, n_, kpvt_, &info_);
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  k_ = (*n_);
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
  ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = z_[k_ - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
  (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
  _abs (cimag (zdum__2_));}));});
}

z_[k_ - 1] = z_[k_ - 1] + ek_;
(void) _zaxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 1) {
  goto _l80;
}

if (({complex_16 zdum__1_ = z_[k_ - 1 - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = z_[k_ - 1 - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
(zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
_abs (cimag (zdum__2_));}));});
}

z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
(void) _zaxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
_l80:;
if (ks_ == 2) {
  goto _l100;
}

if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
goto _l90;
}

s_ = ({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
/ ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l90:;
if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
!= 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

goto _l110;
_l100:;
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bk_ = z_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l110:;
k_ = k_ - ks_;
goto _l60;
_l120:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
k_ = 1;
_l130:;
if (k_ > (*n_)) {
  goto _l160;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l150;
}

z_[k_ - 1] = z_[k_ - 1] + _zdotu (($2_ = k_ - 1, &$2_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _zdotu (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], 
  &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l140;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l140:;
_l150:;
k_ = k_ + ks_;
goto _l130;
_l160:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
k_ = (*n_);
_l170:;
if (k_ == 0) {
  goto _l230;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == ks_) {
  goto _l190;
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
kps_ = k_ + 1 - ks_;
if (kp_ == kps_) {
  goto _l180;
}

t_ = z_[kps_ - 1];
z_[kps_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l180:;
(void) _zaxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  (void) _zaxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &z_[0], &_k1);
}

_l190:;
if (ks_ == 2) {
  goto _l210;
}

if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
goto _l200;
}

s_ = ({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
/ ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l200:;
if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
!= 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
}

if (({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

goto _l220;
_l210:;
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bk_ = z_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
bkm1_ = z_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l220:;
k_ = k_ - ks_;
goto _l170;
_l230:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
k_ = 1;
_l240:;
if (k_ > (*n_)) {
  goto _l270;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l260;
}

z_[k_ - 1] = z_[k_ - 1] + _zdotu (($6_ = k_ - 1, &$6_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _zdotu (($7_ = k_ - 1, &$7_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &z_[0], 
  &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l250;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l250:;
_l260:;
k_ = k_ + ks_;
goto _l240;
_l270:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[165].calls++;
return 0;
}

int_4 _zsidi (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ det_, complex_16 _p_ 
work_, int_4 _p_ job_)
{
  static int_4 j_, jb_, k_, km1_, ks_, kstep_;
  static logical_4 noinv_, nodet_;
  static real_8 ten_;
  static complex_16 ak_, akp1_, akkp1_, d_, t_, temp_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_;
  extern complex_16 _zdotu ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  if (nodet_) {
    goto _l100;
  }
  det_[0] = CMPLX (1.0, 0.0);
  det_[1] = CMPLX (0.0, 0.0);
  ten_ = 10.0;
  t_ = CMPLX (0.0, 0.0);
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    d_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    if (kpvt_[k_ - 1] > 0) {
      goto _l30;
    }
    if (({complex_16 zdum__1_ = t_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
    goto _l10;
  }
  t_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
  d_ = (d_ / t_) * a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] - t_;
  goto _l20;
  _l10:;
  d_ = t_;
  t_ = CMPLX (0.0, 0.0);
  _l20:;
  _l30:;
  det_[0] = d_ * det_[0];
  if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l80;
}

_l40:;
if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) >= 1.0e0) {
goto _l50;
}

det_[0] = CMPLX (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLX (1.0, 0.0);
goto _l40;
_l50:;
_l60:;
if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) < ten_) {
goto _l70;
}
det_[0] = det_[0] / CMPLX (ten_, 0.0);
det_[1] = det_[1] + CMPLX (1.0, 0.0);
goto _l60;
_l70:;
_l80:;
}

_l100:;
if (noinv_) {
  goto _l230;
}

k_ = 1;
_l110:;
if (k_ > (*n_)) {
  goto _l220;
}

km1_ = k_ - 1;
if (kpvt_[k_ - 1] < 0) {
  goto _l140;
}

a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = CMPLX (1.0, 0.0) / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
if (km1_ < 1) {
  goto _l130;
}

(void) _zcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
for (j_ = 1; j_ <= km1_; (j_)++) {
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _zdotu (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
  (void) _zaxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
  1))], &_k1);
}

a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + _zdotu (&km1_, work_, &_k1, &a_[0 + 
((*lda_)) * ((k_ - 1))], &_k1);
_l130:;
kstep_ = 1;
goto _l180;
_l140:;
t_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / t_;
akp1_ = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
akkp1_ = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] / t_;
d_ = t_ * (ak_ * akp1_ - CMPLX (1.0, 0.0));
a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = akp1_ / d_;
a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = ak_ / d_;
a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = -akkp1_ / d_;
if (km1_ < 1) {
  goto _l170;
}

(void) _zcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, work_, &_k1);
for (j_ = 1; j_ <= km1_; (j_)++) {
  a_[j_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = _zdotu (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
  (void) _zaxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 
  1 - 1))], &_k1);
}

a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _zdotu (&km1_, work_, &_k1, 
&a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] + _zdotu (&km1_, &a_[0 + ((*lda_)) * 
((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1);
(void) _zcopy (&km1_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, work_, &_k1);
for (j_ = 1; j_ <= km1_; (j_)++) {
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = _zdotu (&j_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, work_, &_k1);
  (void) _zaxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 
  1))], &_k1);
}

a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] + _zdotu (&km1_, work_, &_k1, &a_[0 + 
((*lda_)) * ((k_ - 1))], &_k1);
_l170:;
kstep_ = 2;
_l180:;
ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (ks_ == k_) {
  goto _l210;
}

(void) _zswap (&ks_, &a_[0 + ((*lda_)) * ((ks_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
for (jb_ = ks_; jb_ <= k_; (jb_)++) {
  j_ = k_ + ks_ - jb_;
  temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))];
  a_[ks_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
}

if (kstep_ == 1) {
  goto _l200;
}

temp_ = a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
a_[ks_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))];
a_[k_ - 1 + ((*lda_)) * ((k_ + 1 - 1))] = temp_;
_l200:;
_l210:;
k_ = k_ + kstep_;
goto _l110;
_l220:;
_l230:;
__calls[166].calls++;
return 0;
}

int_4 _zsifa (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 imax_, imaxp1_, j_, jj_, jmax_, k_, km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_8 absakk_, alpha_, colmax_, rowmax_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_;
  extern int_4 _izamax ();
  alpha_ = 6.4038820320220756e-1;
  (*info_) = 0;
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (({complex_16 zdum__1_ = a_[0 + ((*lda_)) * ((0))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) 
  {
  (*info_) = 1;
}

goto _l200;
_l20:;
km1_ = k_ - 1;
absakk_ = ({complex_16 zdum__1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));});
imax_ = _izamax (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
colmax_ = ({complex_16 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));});
if (absakk_ < alpha_ * colmax_) {
  goto _l30;
}

kstep_ = 1;
swap_ = FALSE;
goto _l90;
_l30:;
rowmax_ = 0.0;
imaxp1_ = imax_ + 1;
for (j_ = imaxp1_; j_ <= k_; (j_)++) {
  rowmax_ = _max (rowmax_, ({complex_16 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))]; _abs (creal (zdum__1_)) + _abs 
  (cimag (zdum__1_));}));
}

if (imax_ == 1) {
  goto _l50;
}

jmax_ = _izamax (($1_ = imax_ - 1, &$1_), &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1);
rowmax_ = _max (rowmax_, ({complex_16 zdum__1_ = a_[jmax_ - 1 + ((*lda_)) * ((imax_ - 1))]; _abs (creal (zdum__1_)) + 
_abs (cimag (zdum__1_));}));
_l50:;
if (({complex_16 zdum__1_ = a_[imax_ - 1 + ((*lda_)) * ((imax_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
(zdum__1_));}) < alpha_ * rowmax_) {
goto _l60;
}

kstep_ = 1;
swap_ = TRUE;
goto _l80;
_l60:;
if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
  goto _l70;
}

kstep_ = 1;
swap_ = FALSE;
goto _l80;
_l70:;
kstep_ = 2;
swap_ = imax_ != km1_;
_l80:;
_l90:;
if (_max (absakk_, colmax_) != 0.0e0) {
  goto _l100;
}

kpvt_[k_ - 1] = k_;
(*info_) = k_;
goto _l190;
_l100:;
if (kstep_ == 2) {
  goto _l140;
}

if (! (swap_)) {
  goto _l120;
}

(void) _zswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1);
for (jj_ = imax_; jj_ <= k_; (jj_)++) {
  j_ = k_ + imax_ - jj_;
  t_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))];
  a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
}

_l120:;
for (jj_ = 1; jj_ <= km1_; (jj_)++) {
  j_ = k_ - jj_;
  mulk_ = -a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  t_ = mulk_;
  (void) _zaxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
}

kpvt_[k_ - 1] = k_;
if (swap_) {
  kpvt_[k_ - 1] = imax_;
}

goto _l190;
_l140:;
if (! (swap_)) {
  goto _l160;
}

(void) _zswap (&imax_, &a_[0 + ((*lda_)) * ((imax_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1);
for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
  j_ = km1_ + imax_ - jj_;
  t_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))];
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))];
  a_[imax_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
}

t_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))] = a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))];
a_[imax_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
_l160:;
km2_ = k_ - 2;
if (km2_ == 0) {
  goto _l180;
}

ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
denom_ = 1.0e0 - ak_ * akm1_;
for (jj_ = 1; jj_ <= km2_; (jj_)++) {
  j_ = km1_ - jj_;
  bk_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
  mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
  t_ = mulk_;
  (void) _zaxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  t_ = mulkm1_;
  (void) _zaxpy (&j_, &t_, &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1);
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = mulk_;
  a_[j_ - 1 + ((*lda_)) * ((k_ - 1 - 1))] = mulkm1_;
}

_l180:;
kpvt_[k_ - 1] = 1 - k_;
if (swap_) {
  kpvt_[k_ - 1] = -imax_;
}

kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
_l190:;
k_ = k_ - kstep_;
goto _l10;
_l200:;
__calls[167].calls++;
return 0;
}

int_4 _zsisl (complex_16 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ b_)
{
  static int_4 k_, kp_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern complex_16 _zdotu ();
  k_ = (*n_);
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _zaxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
  k_ = k_ - 1;
  goto _l70;
  _l40:;
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _zaxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  (void) _zaxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &a_[0 + ((*lda_)) * ((k_ - 1 - 1))], &_k1, &b_[0], &_k1);
  _l60:;
  ak_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  akm1_ = a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1 - 1))] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bk_ = b_[k_ - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  bkm1_ = b_[k_ - 1 - 1] / a_[k_ - 1 - 1 + ((*lda_)) * ((k_ - 1))];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _zdotu (($3_ = k_ - 1, &$3_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _zdotu (($4_ = k_ - 1, &$4_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _zdotu (($5_ = k_ - 1, &$5_), &a_[0 + ((*lda_)) * ((k_ + 1 - 1))], &_k1, &b_[0], 
  &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[168].calls++;
  return 0;
}

int_4 _zspco (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, real_8 _p_ rcond_, complex_16 _p_ z_)
{
  static int_4 i_, ij_, ik_, ikm1_, ikp1_, info_, j_, jm1_, j1_, k_, kk_, km1k_, km1km1_, kp_, kps_, ks_;
  static real_8 anorm_, s_, ynorm_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, ek_, t_, zdum_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern complex_16 _zdotu ();
  extern real_8 _dzasum ();
  j1_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (_dzasum (&j_, &ap_[j1_ - 1], &_k1), 0.0);
    ij_ = j1_;
    j1_ = j1_ + j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      z_[i_ - 1] = CMPLX (creal (z_[i_ - 1]) + ({complex_16 zdum__1_ = ap_[ij_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag 
      (zdum__1_));}), 0.0);
      ij_ = ij_ + 1;
    }
    _l20:;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, creal (z_[j_ - 1]));
  }
  (void) _zspfa (ap_, n_, kpvt_, &info_);
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l60:;
  if (k_ == 0) {
    goto _l120;
  }
  kk_ = ik_ + k_;
  ikm1_ = ik_ - (k_ - 1);
  ks_ = 1;
  if (kpvt_[k_ - 1] < 0) {
    ks_ = 2;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  kps_ = k_ + 1 - ks_;
  if (kp_ == kps_) {
    goto _l70;
  }
  t_ = z_[kps_ - 1];
  z_[kps_ - 1] = z_[kp_ - 1];
  z_[kp_ - 1] = t_;
  _l70:;
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
  ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = z_[k_ - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
  (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
  _abs (cimag (zdum__2_));}));});
}

z_[k_ - 1] = z_[k_ - 1] + ek_;
(void) _zaxpy (($0_ = k_ - ks_, &$0_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
if (ks_ == 1) {
  goto _l80;
}

if (({complex_16 zdum__1_ = z_[k_ - 1 - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
ek_ = ({complex_16 zdum__1_ = ek_; complex_16 zdum2__1_ = z_[k_ - 1 - 1]; ({complex_16 zdum__2_ = zdum__1_; _abs (creal 
(zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
_abs (cimag (zdum__2_));}));});
}

z_[k_ - 1 - 1] = z_[k_ - 1 - 1] + ek_;
(void) _zaxpy (($1_ = k_ - ks_, &$1_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
_l80:;
if (ks_ == 2) {
  goto _l100;
}

if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
goto _l90;
}

s_ = ({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) / ({complex_16 zdum__1_ 
= z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l90:;
if (({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

if (({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

goto _l110;
_l100:;
km1k_ = ik_ + k_ - 1;
km1km1_ = ikm1_ + k_ - 1;
ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
bk_ = z_[k_ - 1] / ap_[km1k_ - 1];
bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l110:;
k_ = k_ - ks_;
ik_ = ik_ - k_;
if (ks_ == 2) {
  ik_ = ik_ - (k_ + 1);
}

goto _l60;
_l120:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
k_ = 1;
ik_ = 0;
_l130:;
if (k_ > (*n_)) {
  goto _l160;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l150;
}

z_[k_ - 1] = z_[k_ - 1] + _zdotu (($2_ = k_ - 1, &$2_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
ikp1_ = ik_ + k_;
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _zdotu (($3_ = k_ - 1, &$3_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l140;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l140:;
_l150:;
ik_ = ik_ + k_;
if (ks_ == 2) {
  ik_ = ik_ + (k_ + 1);
}

k_ = k_ + ks_;
goto _l130;
_l160:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
k_ = (*n_);
ik_ = (*n_) * ((*n_) - 1) / 2;
_l170:;
if (k_ == 0) {
  goto _l230;
}

kk_ = ik_ + k_;
ikm1_ = ik_ - (k_ - 1);
ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == ks_) {
  goto _l190;
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
kps_ = k_ + 1 - ks_;
if (kp_ == kps_) {
  goto _l180;
}

t_ = z_[kps_ - 1];
z_[kps_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l180:;
(void) _zaxpy (($4_ = k_ - ks_, &$4_), &z_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
if (ks_ == 2) {
  (void) _zaxpy (($5_ = k_ - ks_, &$5_), &z_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

_l190:;
if (ks_ == 2) {
  goto _l210;
}

if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
goto _l200;
}

s_ = ({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) / ({complex_16 zdum__1_ 
= z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l200:;
if (({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / ap_[kk_ - 1];
}

if (({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

goto _l220;
_l210:;
km1k_ = ik_ + k_ - 1;
km1km1_ = ikm1_ + k_ - 1;
ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
bk_ = z_[k_ - 1] / ap_[km1k_ - 1];
bkm1_ = z_[k_ - 1 - 1] / ap_[km1k_ - 1];
denom_ = ak_ * akm1_ - 1.0e0;
z_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
z_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
_l220:;
k_ = k_ - ks_;
ik_ = ik_ - k_;
if (ks_ == 2) {
  ik_ = ik_ - (k_ + 1);
}

goto _l170;
_l230:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
k_ = 1;
ik_ = 0;
_l240:;
if (k_ > (*n_)) {
  goto _l270;
}

ks_ = 1;
if (kpvt_[k_ - 1] < 0) {
  ks_ = 2;
}

if (k_ == 1) {
  goto _l260;
}

z_[k_ - 1] = z_[k_ - 1] + _zdotu (($6_ = k_ - 1, &$6_), &ap_[ik_ + 1 - 1], &_k1, &z_[0], &_k1);
ikp1_ = ik_ + k_;
if (ks_ == 2) {
  z_[k_ + 1 - 1] = z_[k_ + 1 - 1] + _zdotu (($7_ = k_ - 1, &$7_), &ap_[ikp1_ + 1 - 1], &_k1, &z_[0], &_k1);
}

kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (kp_ == k_) {
  goto _l250;
}

t_ = z_[k_ - 1];
z_[k_ - 1] = z_[kp_ - 1];
z_[kp_ - 1] = t_;
_l250:;
_l260:;
ik_ = ik_ + k_;
if (ks_ == 2) {
  ik_ = ik_ + (k_ + 1);
}

k_ = k_ + ks_;
goto _l240;
_l270:;
s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[169].calls++;
return 0;
}

int_4 _zspdi (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ det_, complex_16 _p_ work_, int_4 _p_ 
job_)
{
  static int_4 ij_, ik_, ikp1_, iks_, j_, jb_, jk_, jkp1_, k_, kk_, kkp1_, km1_, ks_, ksj_, kskp1_, kstep_;
  static logical_4 noinv_, nodet_;
  static real_8 ten_;
  static complex_16 ak_, akkp1_, akp1_, d_, t_, temp_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_;
  extern complex_16 _zdotu ();
  noinv_ = _imod ((*job_), 10) == 0;
  nodet_ = _imod ((*job_), 100) / 10 == 0;
  if (nodet_) {
    goto _l110;
  }
  det_[0] = CMPLX (1.0, 0.0);
  det_[1] = CMPLX (0.0, 0.0);
  ten_ = 10.0;
  t_ = CMPLX (0.0, 0.0);
  ik_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = ik_ + k_;
    d_ = ap_[kk_ - 1];
    if (kpvt_[k_ - 1] > 0) {
      goto _l30;
    }
    if (({complex_16 zdum__1_ = t_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
    goto _l10;
  }
  ikp1_ = ik_ + k_;
  kkp1_ = ikp1_ + k_;
  t_ = ap_[kkp1_ - 1];
  d_ = (d_ / t_) * ap_[kkp1_ + 1 - 1] - t_;
  goto _l20;
  _l10:;
  d_ = t_;
  t_ = CMPLX (0.0, 0.0);
  _l20:;
  _l30:;
  if (nodet_) {
    goto _l90;
  }
  det_[0] = d_ * det_[0];
  if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l80;
}

_l40:;
if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) >= 1.0e0) {
goto _l50;
}

det_[0] = CMPLX (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLX (1.0, 0.0);
goto _l40;
_l50:;
_l60:;
if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) < ten_) {
goto _l70;
}

det_[0] = det_[0] / CMPLX (ten_, 0.0);
det_[1] = det_[1] + CMPLX (1.0, 0.0);
goto _l60;
_l70:;
_l80:;
_l90:;
ik_ = ik_ + k_;
}

_l110:;
if (noinv_) {
  goto _l240;
}

k_ = 1;
ik_ = 0;
_l120:;
if (k_ > (*n_)) {
  goto _l230;
}

km1_ = k_ - 1;
kk_ = ik_ + k_;
ikp1_ = ik_ + k_;
if (kpvt_[k_ - 1] < 0) {
  goto _l150;
}

ap_[kk_ - 1] = CMPLX (1.0, 0.0) / ap_[kk_ - 1];
if (km1_ < 1) {
  goto _l140;
}

(void) _zcopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
ij_ = 0;
for (j_ = 1; j_ <= km1_; (j_)++) {
  jk_ = ik_ + j_;
  ap_[jk_ - 1] = _zdotu (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
  (void) _zaxpy (($0_ = j_ - 1, &$0_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  ij_ = ij_ + j_;
}

ap_[kk_ - 1] = ap_[kk_ - 1] + _zdotu (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1);
_l140:;
kstep_ = 1;
goto _l190;
_l150:;
kkp1_ = ikp1_ + k_;
t_ = ap_[kkp1_ - 1];
ak_ = ap_[kk_ - 1] / t_;
akp1_ = ap_[kkp1_ + 1 - 1] / t_;
akkp1_ = ap_[kkp1_ - 1] / t_;
d_ = t_ * (ak_ * akp1_ - CMPLX (1.0, 0.0));
ap_[kk_ - 1] = akp1_ / d_;
ap_[kkp1_ + 1 - 1] = ak_ / d_;
ap_[kkp1_ - 1] = -akkp1_ / d_;
if (km1_ < 1) {
  goto _l180;
}

(void) _zcopy (&km1_, &ap_[ikp1_ + 1 - 1], &_k1, work_, &_k1);
ij_ = 0;
for (j_ = 1; j_ <= km1_; (j_)++) {
  jkp1_ = ikp1_ + j_;
  ap_[jkp1_ - 1] = _zdotu (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
  (void) _zaxpy (($1_ = j_ - 1, &$1_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
  ij_ = ij_ + j_;
}

ap_[kkp1_ + 1 - 1] = ap_[kkp1_ + 1 - 1] + _zdotu (&km1_, work_, &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
ap_[kkp1_ - 1] = ap_[kkp1_ - 1] + _zdotu (&km1_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ikp1_ + 1 - 1], &_k1);
(void) _zcopy (&km1_, &ap_[ik_ + 1 - 1], &_k1, work_, &_k1);
ij_ = 0;
for (j_ = 1; j_ <= km1_; (j_)++) {
  jk_ = ik_ + j_;
  ap_[jk_ - 1] = _zdotu (&j_, &ap_[ij_ + 1 - 1], &_k1, work_, &_k1);
  (void) _zaxpy (($2_ = j_ - 1, &$2_), &work_[j_ - 1], &ap_[ij_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
  ij_ = ij_ + j_;
}

ap_[kk_ - 1] = ap_[kk_ - 1] + _zdotu (&km1_, work_, &_k1, &ap_[ik_ + 1 - 1], &_k1);
_l180:;
kstep_ = 2;
_l190:;
ks_ = (int_4) (_abs (kpvt_[k_ - 1]));
if (ks_ == k_) {
  goto _l220;
}

iks_ = (ks_ * (ks_ - 1)) / 2;
(void) _zswap (&ks_, &ap_[iks_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
ksj_ = ik_ + ks_;
for (jb_ = ks_; jb_ <= k_; (jb_)++) {
  j_ = k_ + ks_ - jb_;
  jk_ = ik_ + j_;
  temp_ = ap_[jk_ - 1];
  ap_[jk_ - 1] = ap_[ksj_ - 1];
  ap_[ksj_ - 1] = temp_;
  ksj_ = ksj_ - (j_ - 1);
}

if (kstep_ == 1) {
  goto _l210;
}
kskp1_ = ikp1_ + ks_;
temp_ = ap_[kskp1_ - 1];
ap_[kskp1_ - 1] = ap_[kkp1_ - 1];
ap_[kkp1_ - 1] = temp_;
_l210:;
_l220:;
ik_ = ik_ + k_;
if (kstep_ == 2) {
  ik_ = ik_ + k_ + 1;
}

k_ = k_ + kstep_;
goto _l120;
_l230:;
_l240:;
__calls[170].calls++;
return 0;
}

int_4 _zspfa (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, int_4 _p_ info_)
{
  static int_4 ij_, ijj_, ik_, ikm1_, im_, imax_, imaxp1_, imim_, imj_, imk_, j_, jj_, jk_, jkm1_, jmax_, jmim_, k_, kk_, 
  km1_, km1k_, km1km1_, km2_, kstep_;
  static logical_4 swap_;
  static real_8 absakk_, alpha_, colmax_, rowmax_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, mulk_, mulkm1_, t_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_;
  extern int_4 _izamax ();
  alpha_ = 6.4038820320220756e-1;
  (*info_) = 0;
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l200;
  }
  if (k_ > 1) {
    goto _l20;
  }
  kpvt_[0] = 1;
  if (({complex_16 zdum__1_ = ap_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  (*info_) = 1;
}

goto _l200;
_l20:;
km1_ = k_ - 1;
kk_ = ik_ + k_;
absakk_ = ({complex_16 zdum__1_ = ap_[kk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
imax_ = _izamax (($0_ = k_ - 1, &$0_), &ap_[ik_ + 1 - 1], &_k1);
imk_ = ik_ + imax_;
colmax_ = ({complex_16 zdum__1_ = ap_[imk_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
if (absakk_ < alpha_ * colmax_) {
  goto _l30;
}

kstep_ = 1;
swap_ = FALSE;
goto _l90;
_l30:;
rowmax_ = 0.0;
imaxp1_ = imax_ + 1;
im_ = imax_ * (imax_ - 1) / 2;
imj_ = im_ + 2 * imax_;
for (j_ = imaxp1_; j_ <= k_; (j_)++) {
  rowmax_ = _max (rowmax_, ({complex_16 zdum__1_ = ap_[imj_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}));
  imj_ = imj_ + j_;
}

if (imax_ == 1) {
  goto _l50;
}
jmax_ = _izamax (($1_ = imax_ - 1, &$1_), &ap_[im_ + 1 - 1], &_k1);
jmim_ = jmax_ + im_;
rowmax_ = _max (rowmax_, ({complex_16 zdum__1_ = ap_[jmim_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}))
;
_l50:;
imim_ = imax_ + im_;
if (({complex_16 zdum__1_ = ap_[imim_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) < alpha_ * rowmax_) {
goto _l60;
}

kstep_ = 1;
swap_ = TRUE;
goto _l80;
_l60:;
if (absakk_ < alpha_ * colmax_ * (colmax_ / rowmax_)) {
  goto _l70;
}

kstep_ = 1;
swap_ = FALSE;
goto _l80;
_l70:;
kstep_ = 2;
swap_ = imax_ != km1_;
_l80:;
_l90:;
if (_max (absakk_, colmax_) != 0.0e0) {
  goto _l100;
}

kpvt_[k_ - 1] = k_;
(*info_) = k_;
goto _l190;
_l100:;
if (kstep_ == 2) {
  goto _l140;
}

if (! (swap_)) {
  goto _l120;
}

(void) _zswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ik_ + 1 - 1], &_k1);
imj_ = ik_ + imax_;
for (jj_ = imax_; jj_ <= k_; (jj_)++) {
  j_ = k_ + imax_ - jj_;
  jk_ = ik_ + j_;
  t_ = ap_[jk_ - 1];
  ap_[jk_ - 1] = ap_[imj_ - 1];
  ap_[imj_ - 1] = t_;
  imj_ = imj_ - (j_ - 1);
}

_l120:;
ij_ = ik_ - (k_ - 1);
for (jj_ = 1; jj_ <= km1_; (jj_)++) {
  j_ = k_ - jj_;
  jk_ = ik_ + j_;
  mulk_ = -ap_[jk_ - 1] / ap_[kk_ - 1];
  t_ = mulk_;
  (void) _zaxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  ijj_ = ij_ + j_;
  ap_[jk_ - 1] = mulk_;
  ij_ = ij_ - (j_ - 1);
}

kpvt_[k_ - 1] = k_;
if (swap_) {
  kpvt_[k_ - 1] = imax_;
}

goto _l190;
_l140:;
km1k_ = ik_ + k_ - 1;
ikm1_ = ik_ - (k_ - 1);
if (! (swap_)) {
  goto _l160;
}

(void) _zswap (&imax_, &ap_[im_ + 1 - 1], &_k1, &ap_[ikm1_ + 1 - 1], &_k1);
imj_ = ikm1_ + imax_;
for (jj_ = imax_; jj_ <= km1_; (jj_)++) {
  j_ = km1_ + imax_ - jj_;
  jkm1_ = ikm1_ + j_;
  t_ = ap_[jkm1_ - 1];
  ap_[jkm1_ - 1] = ap_[imj_ - 1];
  ap_[imj_ - 1] = t_;
  imj_ = imj_ - (j_ - 1);
}

t_ = ap_[km1k_ - 1];
ap_[km1k_ - 1] = ap_[imk_ - 1];
ap_[imk_ - 1] = t_;
_l160:;
km2_ = k_ - 2;
if (km2_ == 0) {
  goto _l180;
}

ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
km1km1_ = ikm1_ + k_ - 1;
akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
denom_ = 1.0e0 - ak_ * akm1_;
ij_ = ik_ - (k_ - 1) - (k_ - 2);
for (jj_ = 1; jj_ <= km2_; (jj_)++) {
  j_ = km1_ - jj_;
  jk_ = ik_ + j_;
  bk_ = ap_[jk_ - 1] / ap_[km1k_ - 1];
  jkm1_ = ikm1_ + j_;
  bkm1_ = ap_[jkm1_ - 1] / ap_[km1k_ - 1];
  mulk_ = (akm1_ * bk_ - bkm1_) / denom_;
  mulkm1_ = (ak_ * bkm1_ - bk_) / denom_;
  t_ = mulk_;
  (void) _zaxpy (&j_, &t_, &ap_[ik_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  t_ = mulkm1_;
  (void) _zaxpy (&j_, &t_, &ap_[ikm1_ + 1 - 1], &_k1, &ap_[ij_ + 1 - 1], &_k1);
  ap_[jk_ - 1] = mulk_;
  ap_[jkm1_ - 1] = mulkm1_;
  ijj_ = ij_ + j_;
  ij_ = ij_ - (j_ - 1);
}

_l180:;
kpvt_[k_ - 1] = 1 - k_;
if (swap_) {
  kpvt_[k_ - 1] = -imax_;
}

kpvt_[k_ - 1 - 1] = kpvt_[k_ - 1];
_l190:;
ik_ = ik_ - (k_ - 1);
if (kstep_ == 2) {
  ik_ = ik_ - (k_ - 2);
}

k_ = k_ - kstep_;
goto _l10;
_l200:;
__calls[171].calls++;
return 0;
}

int_4 _zspsl (complex_16 _p_ ap_, int_4 _p_ n_, int_4 _p_ kpvt_, complex_16 _p_ b_)
{
  static int_4 ik_, ikm1_, ikp1_, k_, kk_, km1k_, km1km1_, kp_;
  static complex_16 ak_, akm1_, bk_, bkm1_, denom_, temp_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_;
  extern complex_16 _zdotu ();
  k_ = (*n_);
  ik_ = ((*n_) * ((*n_) - 1)) / 2;
  _l10:;
  if (k_ == 0) {
    goto _l80;
  }
  kk_ = ik_ + k_;
  if (kpvt_[k_ - 1] < 0) {
    goto _l40;
  }
  if (k_ == 1) {
    goto _l30;
  }
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l20;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l20:;
  (void) _zaxpy (($0_ = k_ - 1, &$0_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l30:;
  b_[k_ - 1] = b_[k_ - 1] / ap_[kk_ - 1];
  k_ = k_ - 1;
  ik_ = ik_ - k_;
  goto _l70;
  _l40:;
  ikm1_ = ik_ - (k_ - 1);
  if (k_ == 2) {
    goto _l60;
  }
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_ - 1) {
    goto _l50;
  }
  temp_ = b_[k_ - 1 - 1];
  b_[k_ - 1 - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l50:;
  (void) _zaxpy (($1_ = k_ - 2, &$1_), &b_[k_ - 1], &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  (void) _zaxpy (($2_ = k_ - 2, &$2_), &b_[k_ - 1 - 1], &ap_[ikm1_ + 1 - 1], &_k1, &b_[0], &_k1);
  _l60:;
  km1k_ = ik_ + k_ - 1;
  kk_ = ik_ + k_;
  ak_ = ap_[kk_ - 1] / ap_[km1k_ - 1];
  km1km1_ = ikm1_ + k_ - 1;
  akm1_ = ap_[km1km1_ - 1] / ap_[km1k_ - 1];
  bk_ = b_[k_ - 1] / ap_[km1k_ - 1];
  bkm1_ = b_[k_ - 1 - 1] / ap_[km1k_ - 1];
  denom_ = ak_ * akm1_ - 1.0e0;
  b_[k_ - 1] = (akm1_ * bk_ - bkm1_) / denom_;
  b_[k_ - 1 - 1] = (ak_ * bkm1_ - bk_) / denom_;
  k_ = k_ - 2;
  ik_ = ik_ - (k_ + 1) - k_;
  _l70:;
  goto _l10;
  _l80:;
  k_ = 1;
  ik_ = 0;
  _l90:;
  if (k_ > (*n_)) {
    goto _l160;
  }
  if (kpvt_[k_ - 1] < 0) {
    goto _l120;
  }
  if (k_ == 1) {
    goto _l110;
  }
  b_[k_ - 1] = b_[k_ - 1] + _zdotu (($3_ = k_ - 1, &$3_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = kpvt_[k_ - 1];
  if (kp_ == k_) {
    goto _l100;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l100:;
  _l110:;
  ik_ = ik_ + k_;
  k_ = k_ + 1;
  goto _l150;
  _l120:;
  if (k_ == 1) {
    goto _l140;
  }
  b_[k_ - 1] = b_[k_ - 1] + _zdotu (($4_ = k_ - 1, &$4_), &ap_[ik_ + 1 - 1], &_k1, &b_[0], &_k1);
  ikp1_ = ik_ + k_;
  b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + _zdotu (($5_ = k_ - 1, &$5_), &ap_[ikp1_ + 1 - 1], &_k1, &b_[0], &_k1);
  kp_ = (int_4) (_abs (kpvt_[k_ - 1]));
  if (kp_ == k_) {
    goto _l130;
  }
  temp_ = b_[k_ - 1];
  b_[k_ - 1] = b_[kp_ - 1];
  b_[kp_ - 1] = temp_;
  _l130:;
  _l140:;
  ik_ = ik_ + k_ + k_ + 1;
  k_ = k_ + 2;
  _l150:;
  goto _l90;
  _l160:;
  __calls[172].calls++;
  return 0;
}

int_4 _zsvdc (complex_16 _p_ x_, int_4 _p_ ldx_, int_4 _p_ n_, int_4 _p_ p_, complex_16 _p_ s_, complex_16 _p_ e_, 
complex_16 _p_ u_, int_4 _p_ ldu_, complex_16 _p_ v_, int_4 _p_ ldv_, complex_16 _p_ work_, int_4 _p_ job_, int_4 _p_ 
info_)
{
  static int_4 i_, iter_, j_, jobu_, k_, kase_, kk_, l_, ll_, lls_, lm1_, lp1_, ls_, lu_, m_, maxit_, mm_, mm1_, mp1_, 
  nct_, nctp1_, ncu_, nrt_, nrtp1_;
  static logical_4 wantu_, wantv_;
  static real_8 b_, c_, cs_, el_, emm1_, f_, g_, scale_, shift_, sl_, sm_, sn_, smm1_, t1_, test_, ztest_;
  static complex_16 t_, r_, zdum_, zdum1_, zdum2_, zdumr_, zdumi_;
  int_4 $0_, $1_, $3_, $4_, $5_, $6_, $8_, $9_, $11_, $12_, $13_, $15_, $16_;
  real_8 $17_, $18_;
  complex_16 $2_, $7_, $10_, $14_, $19_;
  extern complex_16 _zdotc ();
  extern real_8 _dznrm2 ();
  maxit_ = 30;
  wantu_ = FALSE;
  wantv_ = FALSE;
  jobu_ = _imod ((*job_), 100) / 10;
  ncu_ = (*n_);
  if (jobu_ > 1) {
    ncu_ = _min ((*n_), (*p_));
  }
  if (jobu_ != 0) {
    wantu_ = TRUE;
  }
  if (_imod ((*job_), 10) != 0) {
    wantv_ = TRUE;
  }
  (*info_) = 0;
  nct_ = _min ((*n_) - 1, (*p_));
  nrt_ = _max (0, _min ((*p_) - 2, (*n_)));
  lu_ = _max (nct_, nrt_);
  if (lu_ < 1) {
    goto _l170;
  }
  for (l_ = 1; l_ <= lu_; (l_)++) {
    lp1_ = l_ + 1;
    if (l_ > nct_) {
      goto _l20;
    }
    s_[l_ - 1] = CMPLX (_dznrm2 (($0_ = (*n_) - l_ + 1, &$0_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1), 0.0);
    if (({complex_16 zdum__1_ = s_[l_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
    goto _l10;
  }
  if (({complex_16 zdum__1_ = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
  != 0.0e0) {
  s_[l_ - 1] = ({complex_16 zdum1__1_ = s_[l_ - 1]; complex_16 zdum2__1_ = x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))]; cabs 
  (zdum1__1_) * (zdum2__1_ / cabs (zdum2__1_));});
}

(void) _zscal (($1_ = (*n_) - l_ + 1, &$1_), ($2_ = 1.0e0 / s_[l_ - 1], &$2_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], 
&_k1);
x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))] = CMPLX (1.0, 0.0) + x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
_l10:;
s_[l_ - 1] = -s_[l_ - 1];
_l20:;
if ((*p_) < lp1_) {
  goto _l50;
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  if (l_ > nct_) {
    goto _l30;
  }
  if (({complex_16 zdum__1_ = s_[l_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l30;
}

t_ = -_zdotc (($3_ = (*n_) - l_ + 1, &$3_), &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * ((j_ - 
1))], &_k1) / x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))];
(void) _zaxpy (($4_ = (*n_) - l_ + 1, &$4_), &t_, &x_[l_ - 1 + ((*ldx_)) * ((l_ - 1))], &_k1, &x_[l_ - 1 + ((*ldx_)) * 
((j_ - 1))], &_k1);
_l30:;
e_[j_ - 1] = conj (x_[l_ - 1 + ((*ldx_)) * ((j_ - 1))]);
}

_l50:;
if (! (wantu_) || l_ > nct_) {
  goto _l70;
}

for (i_ = l_; i_ <= (*n_); (i_)++) {
  u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((l_ - 1))];
}

_l70:;
if (l_ > nrt_) {
  goto _l150;
}

e_[l_ - 1] = CMPLX (_dznrm2 (($5_ = (*p_) - l_, &$5_), &e_[lp1_ - 1], &_k1), 0.0);
if (({complex_16 zdum__1_ = e_[l_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
goto _l80;
}

if (({complex_16 zdum__1_ = e_[lp1_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
e_[l_ - 1] = ({complex_16 zdum1__1_ = e_[l_ - 1]; complex_16 zdum2__1_ = e_[lp1_ - 1]; cabs (zdum1__1_) * (zdum2__1_ / 
cabs (zdum2__1_));});
}

(void) _zscal (($6_ = (*p_) - l_, &$6_), ($7_ = 1.0e0 / e_[l_ - 1], &$7_), &e_[lp1_ - 1], &_k1);
e_[lp1_ - 1] = CMPLX (1.0, 0.0) + e_[lp1_ - 1];
_l80:;
e_[l_ - 1] = -conj (e_[l_ - 1]);
if (lp1_ > (*n_) || ({complex_16 zdum__1_ = e_[l_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) 
{
goto _l120;
}

for (i_ = lp1_; i_ <= (*n_); (i_)++) {
  work_[i_ - 1] = CMPLX (0.0, 0.0);
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  (void) _zaxpy (($8_ = (*n_) - l_, &$8_), &e_[j_ - 1], &x_[lp1_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1, &work_[lp1_ - 1], 
  &_k1);
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  (void) _zaxpy (($9_ = (*n_) - l_, &$9_), ($10_ = conj (-e_[j_ - 1] / e_[lp1_ - 1]), &$10_), &work_[lp1_ - 1], &_k1, 
  &x_[lp1_ - 1 + ((*ldx_)) * ((j_ - 1))], &_k1);
}

_l120:;
if (! (wantv_)) {
  goto _l140;
}

for (i_ = lp1_; i_ <= (*p_); (i_)++) {
  v_[i_ - 1 + ((*ldv_)) * ((l_ - 1))] = e_[i_ - 1];
}

_l140:;
_l150:;
}

_l170:;
m_ = _min ((*p_), (*n_) + 1);
nctp1_ = nct_ + 1;
nrtp1_ = nrt_ + 1;
if (nct_ < (*p_)) {
  s_[nctp1_ - 1] = x_[nctp1_ - 1 + ((*ldx_)) * ((nctp1_ - 1))];
}

if ((*n_) < m_) {
  s_[m_ - 1] = CMPLX (0.0, 0.0);
}

if (nrtp1_ < m_) {
  e_[nrtp1_ - 1] = x_[nrtp1_ - 1 + ((*ldx_)) * ((m_ - 1))];
}

e_[m_ - 1] = CMPLX (0.0, 0.0);
if (! (wantu_)) {
  goto _l300;
}

if (ncu_ < nctp1_) {
  goto _l200;
}

for (j_ = nctp1_; j_ <= ncu_; (j_)++) {
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    u_[i_ - 1 + ((*ldu_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
  }
  u_[j_ - 1 + ((*ldu_)) * ((j_ - 1))] = CMPLX (1.0, 0.0);
}

_l200:;
if (nct_ < 1) {
  goto _l290;
}
for (ll_ = 1; ll_ <= nct_; (ll_)++) {
  l_ = nct_ - ll_ + 1;
  if (({complex_16 zdum__1_ = s_[l_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l250;
}

lp1_ = l_ + 1;
if (ncu_ < lp1_) {
  goto _l220;
}

for (j_ = lp1_; j_ <= ncu_; (j_)++) {
  t_ = -_zdotc (($11_ = (*n_) - l_ + 1, &$11_), &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[l_ - 1 + ((*ldu_)) * ((j_ 
  - 1))], &_k1) / u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))];
  (void) _zaxpy (($12_ = (*n_) - l_ + 1, &$12_), &t_, &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[l_ - 1 + ((*ldu_)) 
  * ((j_ - 1))], &_k1);
}

_l220:;
(void) _zscal (($13_ = (*n_) - l_ + 1, &$13_), ($14_ = CMPLX (-1.0, 0.0), &$14_), &u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))], 
&_k1);
u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))] = CMPLX (1.0, 0.0) + u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))];
lm1_ = l_ - 1;
if (lm1_ < 1) {
  goto _l240;
}

for (i_ = 1; i_ <= lm1_; (i_)++) {
  u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = CMPLX (0.0, 0.0);
}

_l240:;
goto _l270;
_l250:;
for (i_ = 1; i_ <= (*n_); (i_)++) {
  u_[i_ - 1 + ((*ldu_)) * ((l_ - 1))] = CMPLX (0.0, 0.0);
}

u_[l_ - 1 + ((*ldu_)) * ((l_ - 1))] = CMPLX (1.0, 0.0);
_l270:;
}

_l290:;
_l300:;
if (! (wantv_)) {
  goto _l350;
}

for (ll_ = 1; ll_ <= (*p_); (ll_)++) {
  l_ = (*p_) - ll_ + 1;
  lp1_ = l_ + 1;
  if (l_ > nrt_) {
    goto _l320;
  }
  if (({complex_16 zdum__1_ = e_[l_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l320;
}

for (j_ = lp1_; j_ <= (*p_); (j_)++) {
  t_ = -_zdotc (($15_ = (*p_) - l_, &$15_), &v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[lp1_ - 1 + ((*ldv_)) * ((j_ 
  - 1))], &_k1) / v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))];
  (void) _zaxpy (($16_ = (*p_) - l_, &$16_), &t_, &v_[lp1_ - 1 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[lp1_ - 1 + ((*ldv_)) 
  * ((j_ - 1))], &_k1);
}

_l320:;
for (i_ = 1; i_ <= (*p_); (i_)++) {
  v_[i_ - 1 + ((*ldv_)) * ((l_ - 1))] = CMPLX (0.0, 0.0);
}

v_[l_ - 1 + ((*ldv_)) * ((l_ - 1))] = CMPLX (1.0, 0.0);
}

_l350:;
for (i_ = 1; i_ <= m_; (i_)++) {
  if (({complex_16 zdum__1_ = s_[i_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
  goto _l360;
}

t_ = CMPLX (cabs (s_[i_ - 1]), 0.0);
r_ = s_[i_ - 1] / t_;
s_[i_ - 1] = t_;
if (i_ < m_) {
  e_[i_ - 1] = e_[i_ - 1] / r_;
}

if (wantu_) {
  (void) _zscal (n_, &r_, &u_[0 + ((*ldu_)) * ((i_ - 1))], &_k1);
}

_l360:;
if (i_ == m_) {
  goto _l390;
}

if (({complex_16 zdum__1_ = e_[i_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
goto _l370;
}

t_ = CMPLX (cabs (e_[i_ - 1]), 0.0);
r_ = t_ / e_[i_ - 1];
e_[i_ - 1] = t_;
s_[i_ + 1 - 1] = s_[i_ + 1 - 1] * r_;
if (wantv_) {
  (void) _zscal (p_, &r_, &v_[0 + ((*ldv_)) * ((i_ + 1 - 1))], &_k1);
}

_l370:;
}

_l390:;
mm_ = m_;
iter_ = 0;
_l400:;
if (m_ == 0) {
  goto _l660;
}

if (iter_ < maxit_) {
  goto _l410;
}

(*info_) = m_;
goto _l660;
_l410:;
for (ll_ = 1; ll_ <= m_; (ll_)++) {
  l_ = m_ - ll_;
  if (l_ == 0) {
    goto _l440;
  }
  test_ = cabs (s_[l_ - 1]) + cabs (s_[l_ + 1 - 1]);
  ztest_ = test_ + cabs (e_[l_ - 1]);
  if (ztest_ != test_) {
    goto _l420;
  }
  e_[l_ - 1] = CMPLX (0.0, 0.0);
  goto _l440;
  _l420:;
}

_l440:;
if (l_ != m_ - 1) {
  goto _l450;
}

kase_ = 4;
goto _l520;
_l450:;
lp1_ = l_ + 1;
mp1_ = m_ + 1;
for (lls_ = lp1_; lls_ <= mp1_; (lls_)++) {
  ls_ = m_ - lls_ + lp1_;
  if (ls_ == l_) {
    goto _l480;
  }
  test_ = 0.0;
  if (ls_ != m_) {
    test_ = test_ + cabs (e_[ls_ - 1]);
  }
  if (ls_ != l_ + 1) {
    test_ = test_ + cabs (e_[ls_ - 1 - 1]);
  }
  ztest_ = test_ + cabs (s_[ls_ - 1]);
  if (ztest_ != test_) {
    goto _l460;
  }
  s_[ls_ - 1] = CMPLX (0.0, 0.0);
  goto _l480;
  _l460:;
}

_l480:;
if (ls_ != l_) {
  goto _l490;
}

kase_ = 3;
goto _l510;
_l490:;
if (ls_ != m_) {
  goto _l500;
}

kase_ = 1;
goto _l510;
_l500:;
kase_ = 2;
l_ = ls_;
_l510:;
_l520:;
l_ = l_ + 1;
switch (kase_) {
  default:
  case 1: goto _l530;
  case 2: goto _l560;
  case 3: goto _l580;
  case 4: goto _l610;
}

_l530:;
mm1_ = m_ - 1;
f_ = creal (e_[m_ - 1 - 1]);
e_[m_ - 1 - 1] = CMPLX (0.0, 0.0);
for (kk_ = l_; kk_ <= mm1_; (kk_)++) {
  k_ = mm1_ - kk_ + l_;
  t1_ = creal (s_[k_ - 1]);
  (void) _drotg (&t1_, &f_, &cs_, &sn_);
  s_[k_ - 1] = CMPLX (t1_, 0.0);
  if (k_ == l_) {
    goto _l540;
  }
  f_ = -sn_ * creal (e_[k_ - 1 - 1]);
  e_[k_ - 1 - 1] = cs_ * e_[k_ - 1 - 1];
  _l540:;
  if (wantv_) {
    (void) _zdrot (p_, &v_[0 + ((*ldv_)) * ((k_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((m_ - 1))], &_k1, &cs_, &sn_);
  }
}

goto _l650;
_l560:;
f_ = creal (e_[l_ - 1 - 1]);
e_[l_ - 1 - 1] = CMPLX (0.0, 0.0);
for (k_ = l_; k_ <= m_; (k_)++) {
  t1_ = creal (s_[k_ - 1]);
  (void) _drotg (&t1_, &f_, &cs_, &sn_);
  s_[k_ - 1] = CMPLX (t1_, 0.0);
  f_ = -sn_ * creal (e_[k_ - 1]);
  e_[k_ - 1] = cs_ * e_[k_ - 1];
  if (wantu_) {
    (void) _zdrot (n_, &u_[0 + ((*ldu_)) * ((k_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((l_ - 1 - 1))], &_k1, &cs_, &sn_);
  }
}

goto _l650;
_l580:;
scale_ = ($17_ = _max (cabs (s_[m_ - 1]), cabs (s_[m_ - 1 - 1])), $17_ = _max ($17_, cabs (e_[m_ - 1 - 1])), $17_ = 
_max ($17_, cabs (s_[l_ - 1])), _max ($17_, cabs (e_[l_ - 1])));
sm_ = creal (s_[m_ - 1]) / scale_;
smm1_ = creal (s_[m_ - 1 - 1]) / scale_;
emm1_ = creal (e_[m_ - 1 - 1]) / scale_;
sl_ = creal (s_[l_ - 1]) / scale_;
el_ = creal (e_[l_ - 1]) / scale_;
b_ = ((smm1_ + sm_) * (smm1_ - sm_) + (emm1_ * emm1_)) / 2.0e0;
c_ = ($18_ = (sm_ * emm1_), $18_ * $18_);
shift_ = 0.0;
if (b_ == 0.0e0 && c_ == 0.0e0) {
  goto _l590;
}

shift_ = sqrt ((b_ * b_) + c_);
if (b_ < 0.0e0) {
  shift_ = -shift_;
}

shift_ = c_ / (b_ + shift_);
_l590:;
f_ = (sl_ + sm_) * (sl_ - sm_) + shift_;
g_ = sl_ * el_;
mm1_ = m_ - 1;
for (k_ = l_; k_ <= mm1_; (k_)++) {
  (void) _drotg (&f_, &g_, &cs_, &sn_);
  if (k_ != l_) {
    e_[k_ - 1 - 1] = CMPLX (f_, 0.0);
  }
  f_ = cs_ * creal (s_[k_ - 1]) + sn_ * creal (e_[k_ - 1]);
  e_[k_ - 1] = cs_ * e_[k_ - 1] - sn_ * s_[k_ - 1];
  g_ = sn_ * creal (s_[k_ + 1 - 1]);
  s_[k_ + 1 - 1] = cs_ * s_[k_ + 1 - 1];
  if (wantv_) {
    (void) _zdrot (p_, &v_[0 + ((*ldv_)) * ((k_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((k_ + 1 - 1))], &_k1, &cs_, &sn_);
  }
  (void) _drotg (&f_, &g_, &cs_, &sn_);
  s_[k_ - 1] = CMPLX (f_, 0.0);
  f_ = cs_ * creal (e_[k_ - 1]) + sn_ * creal (s_[k_ + 1 - 1]);
  s_[k_ + 1 - 1] = -sn_ * e_[k_ - 1] + cs_ * s_[k_ + 1 - 1];
  g_ = sn_ * creal (e_[k_ + 1 - 1]);
  e_[k_ + 1 - 1] = cs_ * e_[k_ + 1 - 1];
  if (wantu_ && k_ < (*n_)) {
    (void) _zdrot (n_, &u_[0 + ((*ldu_)) * ((k_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((k_ + 1 - 1))], &_k1, &cs_, &sn_);
  }
}

e_[m_ - 1 - 1] = CMPLX (f_, 0.0);
iter_ = iter_ + 1;
goto _l650;
_l610:;
if (creal (s_[l_ - 1]) >= 0.0e0) {
  goto _l620;
}

s_[l_ - 1] = -s_[l_ - 1];
if (wantv_) {
  (void) _zscal (p_, ($19_ = CMPLX (-1.0, 0.0), &$19_), &v_[0 + ((*ldv_)) * ((l_ - 1))], &_k1);
}

_l620:;
_l630:;
if (l_ == mm_) {
  goto _l640;
}

if (creal (s_[l_ - 1]) >= creal (s_[l_ + 1 - 1])) {
  goto _l640;
}

t_ = s_[l_ - 1];
s_[l_ - 1] = s_[l_ + 1 - 1];
s_[l_ + 1 - 1] = t_;
if (wantv_ && l_ < (*p_)) {
  (void) _zswap (p_, &v_[0 + ((*ldv_)) * ((l_ - 1))], &_k1, &v_[0 + ((*ldv_)) * ((l_ + 1 - 1))], &_k1);
}

if (wantu_ && l_ < (*n_)) {
  (void) _zswap (n_, &u_[0 + ((*ldu_)) * ((l_ - 1))], &_k1, &u_[0 + ((*ldu_)) * ((l_ + 1 - 1))], &_k1);
}

l_ = l_ + 1;
goto _l630;
_l640:;
iter_ = 0;
m_ = m_ - 1;
_l650:;
goto _l400;
_l660:;
__calls[173].calls++;
return 0;
}

int_4 _ztrco (complex_16 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, real_8 _p_ rcond_, complex_16 _p_ z_, int_4 _p_ job_)
{
  static int_4 i1_, j_, j1_, j2_, k_, kk_, l_;
  static logical_4 lower_;
  static real_8 tnorm_, ynorm_, s_, sm_;
  static complex_16 w_, wk_, wkm_, ek_, zdum_, zdum1_, zdum2_, zdumr_, zdumi_;
  int_4 $0_;
  extern real_8 _dzasum ();
  lower_ = (*job_) == 0;
  tnorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = j_;
    if (lower_) {
      l_ = (*n_) + 1 - j_;
    }
    i1_ = 1;
    if (lower_) {
      i1_ = j_;
    }
    tnorm_ = _max (tnorm_, _dzasum (&l_, &t_[i1_ - 1 + ((*ldt_)) * ((j_ - 1))], &_k1));
  }
  ek_ = CMPLX (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLX (0.0, 0.0);
  }
  for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
    k_ = kk_;
    if (lower_) {
      k_ = (*n_) + 1 - kk_;
    }
    if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_16 zdum1__1_ = ek_; complex_16 zdum2__1_ = -z_[k_ - 1]; ({complex_16 zdum__2_ = zdum1__1_; _abs (creal 
    (zdum__2_)) + _abs (cimag (zdum__2_));}) * (zdum2__1_ / ({complex_16 zdum__2_ = zdum2__1_; _abs (creal (zdum__2_)) + 
    _abs (cimag (zdum__2_));}));});
  }
  if (({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 
  zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
  goto _l30;
}

s_ = ({complex_16 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
/ ({complex_16 zdum__1_ = ek_ - z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ek_ = CMPLX (s_, 0.0) * ek_;
_l30:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_16 zdum__1_ = wk_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
sm_ = ({complex_16 zdum__1_ = wkm_; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
if (({complex_16 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
goto _l40;
}

wk_ = wk_ / conj (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]);
wkm_ = wkm_ / conj (t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]);
goto _l50;
_l40:;
wk_ = CMPLX (1.0, 0.0);
wkm_ = CMPLX (1.0, 0.0);
_l50:;
if (kk_ == (*n_)) {
  goto _l90;
}

j1_ = k_ + 1;
if (lower_) {
  j1_ = 1;
}

j2_ = (*n_);
if (lower_) {
  j2_ = k_ - 1;
}

for (j_ = j1_; j_ <= j2_; (j_)++) {
  sm_ = sm_ + ({complex_16 zdum__1_ = z_[j_ - 1] + wkm_ * conj (t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))]); _abs (creal 
  (zdum__1_)) + _abs (cimag (zdum__1_));});
  z_[j_ - 1] = z_[j_ - 1] + wk_ * conj (t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))]);
  s_ = s_ + ({complex_16 zdum__1_ = z_[j_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l80;
}

w_ = wkm_ - wk_;
wk_ = wkm_;
for (j_ = j1_; j_ <= j2_; (j_)++) {
  z_[j_ - 1] = z_[j_ - 1] + w_ * conj (t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))]);
}

_l80:;
_l90:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (kk_ = 1; kk_ <= (*n_); (kk_)++) {
  k_ = (*n_) + 1 - kk_;
  if (lower_) {
    k_ = kk_;
  }
  if (({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) <= ({complex_16 zdum__1_ = 
  t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));})) {
  goto _l110;
}
s_ = ({complex_16 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
/ ({complex_16 zdum__1_ = z_[k_ - 1]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));});
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l110:;
if (({complex_16 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
!= 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
}

if (({complex_16 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
== 0.0e0) {
z_[k_ - 1] = CMPLX (1.0, 0.0);
}

i1_ = 1;
if (lower_) {
  i1_ = k_ + 1;
}

if (kk_ >= (*n_)) {
  goto _l120;
}

w_ = -z_[k_ - 1];
(void) _zaxpy (($0_ = (*n_) - kk_, &$0_), &w_, &t_[i1_ - 1 + ((*ldt_)) * ((k_ - 1))], &_k1, &z_[i1_ - 1], &_k1);
_l120:;
}

s_ = 1.0e0 / _dzasum (n_, z_, &_k1);
(void) _zdscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (tnorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / tnorm_;
}

if (tnorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[174].calls++;
return 0;
}

int_4 _ztrdi (complex_16 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, complex_16 _p_ det_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, j_, k_, kb_, km1_, kp1_;
  static real_8 ten_;
  static complex_16 temp_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_;
  if ((*job_) / 100 == 0) {
    goto _l70;
  }
  det_[0] = CMPLX (1.0, 0.0);
  det_[1] = CMPLX (0.0, 0.0);
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    det_[0] = t_[i_ - 1 + ((*ldt_)) * ((i_ - 1))] * det_[0];
    if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) == 0.0e0) {
    goto _l60;
  }
  _l10:;
  if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) >= 1.0e0) {
  goto _l20;
}

det_[0] = CMPLX (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLX (1.0, 0.0);
goto _l10;
_l20:;
_l30:;
if (({complex_16 zdum__1_ = det_[0]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) < ten_) {
goto _l40;
}

det_[0] = det_[0] / CMPLX (ten_, 0.0);
det_[1] = det_[1] + CMPLX (1.0, 0.0);
goto _l30;
_l40:;
}

_l60:;
_l70:;
if (_imod ((*job_) / 10, 10) == 0) {
  goto _l170;
}

if (_imod ((*job_), 10) == 0) {
  goto _l120;
}

for (k_ = 1; k_ <= (*n_); (k_)++) {
  (*info_) = k_;
  if (({complex_16 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
  == 0.0e0) {
  goto _l110;
}

t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = CMPLX (1.0, 0.0) / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
temp_ = -t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
(void) _zscal (($0_ = k_ - 1, &$0_), &temp_, &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1);
kp1_ = k_ + 1;
if ((*n_) < kp1_) {
  goto _l90;
}

for (j_ = kp1_; j_ <= (*n_); (j_)++) {
  temp_ = t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
  t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
  (void) _zaxpy (&k_, &temp_, &t_[0 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1);
}

_l90:;
}

(*info_) = 0;
_l110:;
goto _l160;
_l120:;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  (*info_) = k_;
  if (({complex_16 zdum__1_ = t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))]; _abs (creal (zdum__1_)) + _abs (cimag (zdum__1_));}) 
  == 0.0e0) {
  goto _l180;
}

t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))] = CMPLX (1.0, 0.0) / t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
temp_ = -t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))];
if (k_ != (*n_)) {
  (void) _zscal (($1_ = (*n_) - k_, &$1_), &temp_, &t_[k_ + 1 - 1 + ((*ldt_)) * ((k_ - 1))], &_k1);
}

km1_ = k_ - 1;
if (km1_ < 1) {
  goto _l140;
}

for (j_ = 1; j_ <= km1_; (j_)++) {
  temp_ = t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))];
  t_[k_ - 1 + ((*ldt_)) * ((j_ - 1))] = CMPLX (0.0, 0.0);
  (void) _zaxpy (($2_ = (*n_) - k_ + 1, &$2_), &temp_, &t_[k_ - 1 + ((*ldt_)) * ((k_ - 1))], &_k1, &t_[k_ - 1 + ((*ldt_)) 
  * ((j_ - 1))], &_k1);
}

_l140:;
}

(*info_) = 0;
_l160:;
_l170:;
_l180:;
__calls[175].calls++;
return 0;
}

int_4 _ztrsl (complex_16 _p_ t_, int_4 _p_ ldt_, int_4 _p_ n_, complex_16 _p_ b_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 case_, j_, jj_;
  static complex_16 temp_, zdum_, zdumr_, zdumi_;
  int_4 $0_, $1_, $2_;
  extern complex_16 _zdotc ();
  for ((*info_) = 1; (*info_) <= (*n_); ((*info_))++) {
    if (({complex_16 zdum__1_ = t_[(*info_) - 1 + ((*ldt_)) * (((*info_) - 1))]; _abs (creal (zdum__1_)) + _abs (cimag 
    (zdum__1_));}) == 0.0e0) {
    goto _l150;
  }
}

(*info_) = 0;
case_ = 1;
if (_imod ((*job_), 10) != 0) {
  case_ = 2;
}

if (_imod ((*job_), 100) / 10 != 0) {
  case_ = case_ + 2;
}

switch (case_) {
  default:
  case 1: goto _l20;
  case 2: goto _l50;
  case 3: goto _l80;
  case 4: goto _l110;
}

_l20:;
b_[0] = b_[0] / t_[0 + ((*ldt_)) * ((0))];
if ((*n_) < 2) {
  goto _l40;
}

for (j_ = 2; j_ <= (*n_); (j_)++) {
  temp_ = -b_[j_ - 1 - 1];
  (void) _zaxpy (($0_ = (*n_) - j_ + 1, &$0_), &temp_, &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &b_[j_ - 1], &_k1)
  ;
  b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
}

_l40:;
goto _l140;
_l50:;
b_[(*n_) - 1] = b_[(*n_) - 1] / t_[(*n_) - 1 + ((*ldt_)) * (((*n_) - 1))];
if ((*n_) < 2) {
  goto _l70;
}

for (jj_ = 2; jj_ <= (*n_); (jj_)++) {
  j_ = (*n_) - jj_ + 1;
  temp_ = -b_[j_ + 1 - 1];
  (void) _zaxpy (&j_, &temp_, &t_[0 + ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &b_[0], &_k1);
  b_[j_ - 1] = b_[j_ - 1] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
}

_l70:;
goto _l140;
_l80:;
b_[(*n_) - 1] = b_[(*n_) - 1] / conj (t_[(*n_) - 1 + ((*ldt_)) * (((*n_) - 1))]);
if ((*n_) < 2) {
  goto _l100;
}

for (jj_ = 2; jj_ <= (*n_); (jj_)++) {
  j_ = (*n_) - jj_ + 1;
  b_[j_ - 1] = b_[j_ - 1] - _zdotc (($1_ = jj_ - 1, &$1_), &t_[j_ + 1 - 1 + ((*ldt_)) * ((j_ - 1))], &_k1, &b_[j_ + 1 - 
  1], &_k1);
  b_[j_ - 1] = b_[j_ - 1] / conj (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))]);
}

_l100:;
goto _l140;
_l110:;
b_[0] = b_[0] / conj (t_[0 + ((*ldt_)) * ((0))]);
if ((*n_) < 2) {
  goto _l130;
}

for (j_ = 2; j_ <= (*n_); (j_)++) {
  b_[j_ - 1] = b_[j_ - 1] - _zdotc (($2_ = j_ - 1, &$2_), &t_[0 + ((*ldt_)) * ((j_ - 1))], &_k1, &b_[0], &_k1);
  b_[j_ - 1] = b_[j_ - 1] / conj (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))]);
}

_l130:;
_l140:;
_l150:;
__calls[176].calls++;
return 0;
}

