//! @file mathlib-minpack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 23 subprograms from MINPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CHKDER ENORM  HYBRD  HYBRJ1 LMDER1 LMDIF1 LMSTR  QFORM  QRSOLV R1UPDT
// DOGLEG FDJAC1 HYBRD1 LMDER  LMDIF  LMPAR  LMSTR1 QRFAC  R1MPYQ RWUPDT
// DPMPAR FDJAC2 HYBRJ

// Minpack includes software for solving nonlinear equations and
// nonlinear least squares problems.  Five algorithmic paths each include
// a core subroutine and an easy-to-use driver.  The algorithms proceed
// either from an analytic specification of the Jacobian matrix or
// directly from the problem functions.  The paths include facilities for
// systems of equations with a banded Jacobian matrix, for least squares
// problems with a large amount of data, and for checking the consistency
// of the Jacobian matrix with the functions.
// 
// This directory contains the double-precision versions.
// 
// Origonal authors are Jorge More, Burt Garbow, and Ken Hillstrom.
// 
// This version of MINPACK is adapted for VIF.
// Adaptations are trivial, concerning choosing alternative names for
// variable names that coincided with intrinsic functions.
// 
// Source: netlib.org/minpack/

// The license for MINPACK Fortran source code is:
//
// Minpack Copyright Notice (1999) University of Chicago.  All rights reserved
// 
// Redistribution and use in source and binary forms, with or
// without modification, are permitted provided that the
// following conditions are met:
// 
// 1. Redistributions of source code must retain the above
// copyright notice, this list of conditions and the following
// disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following
// disclaimer in the documentation and/or other materials
// provided with the distribution.
// 
// 3. The end-user documentation included with the
// redistribution, if any, must include the following
// acknowledgment:
// 
//    "This product includes software developed by the
//    University of Chicago, as Operator of Argonne National
//    Laboratory.
// 
// Alternately, this acknowledgment may appear in the software
// itself, if and wherever such third-party acknowledgments
// normally appear.
// 
// 4. WARRANTY DISCLAIMER. THE SOFTWARE IS SUPPLIED "AS IS"
// WITHOUT WARRANTY OF ANY KIND. THE COPYRIGHT HOLDER, THE
// UNITED STATES, THE UNITED STATES DEPARTMENT OF ENERGY, AND
// THEIR EMPLOYEES: (1) DISCLAIM ANY WARRANTIES, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO ANY IMPLIED WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE
// OR NON-INFRINGEMENT, (2) DO NOT ASSUME ANY LEGAL LIABILITY
// OR RESPONSIBILITY FOR THE ACCURACY, COMPLETENESS, OR
// USEFULNESS OF THE SOFTWARE, (3) DO NOT REPRESENT THAT USE OF
// THE SOFTWARE WOULD NOT INFRINGE PRIVATELY OWNED RIGHTS, (4)
// DO NOT WARRANT THAT THE SOFTWARE WILL FUNCTION
// UNINTERRUPTED, THAT IT IS ERROR-FREE OR THAT ANY ERRORS WILL
// BE CORRECTED.
// 
// 5. LIMITATION OF LIABILITY. IN NO EVENT WILL THE COPYRIGHT
// HOLDER, THE UNITED STATES, THE UNITED STATES DEPARTMENT OF
// ENERGY, OR THEIR EMPLOYEES: BE LIABLE FOR ANY INDIRECT,
// INCIDENTAL, CONSEQUENTIAL, SPECIAL OR PUNITIVE DAMAGES OF
// ANY KIND OR NATURE, INCLUDING BUT NOT LIMITED TO LOSS OF
// PROFITS OR LOSS OF DATA, FOR ANY REASON WHATSOEVER, WHETHER
// SUCH LIABILITY IS ASSERTED ON THE BASIS OF CONTRACT, TORT
// (INCLUDING NEGLIGENCE OR STRICT LIABILITY), OR OTHERWISE,
// EVEN IF ANY OF SAID PARTIES HAS BEEN WARNED OF THE
// POSSIBILITY OF SUCH LOSS OR DAMAGES.
// 
// 

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
static FORMAT *__fmt_a = NULL;
#define __ncalls 24
static CALLS __calls[__ncalls] = {
  {"chkder", 0}, // subroutine
  {"dogleg", 0}, // subroutine
  {"dpmpar", 0}, // real*8 function
  {"enorm", 0}, // real*8 function
  {"fdjac1", 0}, // subroutine
  {"fdjac2", 0}, // subroutine
  {"hybrd1", 0}, // subroutine
  {"hybrd", 0}, // subroutine
  {"hybrj1", 0}, // subroutine
  {"hybrj", 0}, // subroutine
  {"lmder1", 0}, // subroutine
  {"lmder", 0}, // subroutine
  {"lmdif1", 0}, // subroutine
  {"lmdif", 0}, // subroutine
  {"lmpar", 0}, // subroutine
  {"lmstr1", 0}, // subroutine
  {"lmstr", 0}, // subroutine
  {"qform", 0}, // subroutine
  {"qrfac", 0}, // subroutine
  {"qrsolv", 0}, // subroutine
  {"r1mpyq", 0}, // subroutine
  {"r1updt", 0}, // subroutine
  {"rwupdt", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _chkder (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ 
ldfjac_, real_8 _p_ xp_, real_8 _p_ fvecp_, int_4 _p_ mode_, real_8 _p_ err_);
prototype int_4 _dogleg (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ lr_, real_8 _p_ diag_, real_8 _p_ qtb_, real_8 _p_ 
delta_, real_8 _p_ x_, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype real_8 _dpmpar (int_4 _p_ i_);
prototype real_8 _enorm (int_4 _p_ n_, real_8 _p_ x_);
prototype int_4 _fdjac1 (int_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ 
ldfjac_, int_4 _p_ iflag_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ epsfcn_, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _fdjac2 (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_
, int_4 _p_ ldfjac_, int_4 _p_ iflag_, real_8 _p_ epsfcn_, real_8 _p_ wa_);
prototype int_4 _hybrd1 (real_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ tol_, int_4 _p_ 
info_, real_8 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _hybrd (int_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ xtol_, int_4 _p_ 
maxfev_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ epsfcn_, real_8 _p_ diag_, int_4 _p_ mode_, real_8 _p_ factor_, int_4 
_p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, real_8 _p_ r_, int_4 _p_ lr_, 
real_8 _p_ qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _hybrj1 (real_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ 
ldfjac_, real_8 _p_ tol_, int_4 _p_ info_, real_8 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _hybrj (int_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ 
ldfjac_, real_8 _p_ xtol_, int_4 _p_ maxfev_, real_8 _p_ diag_, int_4 _p_ mode_, real_8 _p_ factor_, int_4 _p_ nprint_, 
int_4 _p_ info_, int_4 _p_ nfev_, int_4 _p_ njev_, real_8 _p_ r_, int_4 _p_ lr_, real_8 _p_ qtf_, real_8 _p_ wa1_, 
real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _lmder1 (real_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ 
fjac_, int_4 _p_ ldfjac_, real_8 _p_ tol_, int_4 _p_ info_, int_4 _p_ ipvt_, real_8 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _lmder (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, 
int_4 _p_ ldfjac_, real_8 _p_ ftol_, real_8 _p_ xtol_, real_8 _p_ gtol_, int_4 _p_ maxfev_, real_8 _p_ diag_, int_4 _p_ 
mode_, real_8 _p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, int_4 _p_ njev_, int_4 _p_ ipvt_, 
real_8 _p_ qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _lmdif1 (real_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ tol_
, int_4 _p_ info_, int_4 _p_ iwa_, real_8 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _lmdif (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ ftol_, 
real_8 _p_ xtol_, real_8 _p_ gtol_, int_4 _p_ maxfev_, real_8 _p_ epsfcn_, real_8 _p_ diag_, int_4 _p_ mode_, real_8 
_p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, int_4 _p_ ipvt_, 
real_8 _p_ qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _lmpar (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ ipvt_, real_8 _p_ diag_, real_8 _p_ qtb_
, real_8 _p_ delta_, real_8 _p_ par_, real_8 _p_ x_, real_8 _p_ sdiag_, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _lmstr1 (real_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ 
fjac_, int_4 _p_ ldfjac_, real_8 _p_ tol_, int_4 _p_ info_, int_4 _p_ ipvt_, real_8 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _lmstr (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, 
int_4 _p_ ldfjac_, real_8 _p_ ftol_, real_8 _p_ xtol_, real_8 _p_ gtol_, int_4 _p_ maxfev_, real_8 _p_ diag_, int_4 _p_ 
mode_, real_8 _p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, int_4 _p_ njev_, int_4 _p_ ipvt_, 
real_8 _p_ qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _qform (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ wa_);
prototype int_4 _qrfac (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, logical_4 _p_ pivot_, int_4 _p_ 
ipvt_, int_4 _p_ lipvt_, real_8 _p_ rdiag_, real_8 _p_ acnorm_, real_8 _p_ wa_);
prototype int_4 _qrsolv (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ ipvt_, real_8 _p_ diag_, real_8 _p_ 
qtb_, real_8 _p_ x_, real_8 _p_ sdiag_, real_8 _p_ wa_);
prototype int_4 _r1mpyq (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ v_, real_8 _p_ w_);
prototype int_4 _r1updt (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ s_, int_4 _p_ ls_, real_8 _p_ u_, real_8 _p_ v_, real_8 
_p_ w_, logical_4 _p_ sing_);
prototype int_4 _rwupdt (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, real_8 _p_ w_, real_8 _p_ b_, real_8 _p_ alpha_, 
real_8 _p_ cost_, real_8 _p_ sint_);
int_4 _chkder (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, real_8 
_p_ xp_, real_8 _p_ fvecp_, int_4 _p_ mode_, real_8 _p_ err_)
{
  static int_4 i_, j_;
  static real_8 eps_, epsf_, epslog_, epsmch_, factor_, one_, temp_, zero_;
  int_4 _data_k_0;
#define _data_n_0 3
  static real_8 _data_l_0[_data_n_0] = {
    1.0e2,
    1.0e0,
    0.0e0
  };
  if (__calls[0].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    factor_ = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    one_ = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    zero_ = _data_l_0[_data_k_0++];
  }
  epsmch_ = _dpmpar (&_k1);
  eps_ = sqrt (epsmch_);
  if ((*mode_) == 2) {
    goto _l20;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = eps_ * _abs (x_[j_ - 1]);
    if (temp_ == zero_) {
      temp_ = eps_;
    }
    xp_[j_ - 1] = x_[j_ - 1] + temp_;
  }
  goto _l70;
  _l20:;
  epsf_ = factor_ * epsmch_;
  epslog_ = log10 (eps_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    err_[i_ - 1] = zero_;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = _abs (x_[j_ - 1]);
    if (temp_ == zero_) {
      temp_ = one_;
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      err_[i_ - 1] = err_[i_ - 1] + temp_ * fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
    }
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    temp_ = one_;
    if (fvec_[i_ - 1] != zero_ && fvecp_[i_ - 1] != zero_ && _abs (fvecp_[i_ - 1] - fvec_[i_ - 1]) >= epsf_ * _abs 
      (fvec_[i_ - 1])) {
      temp_ = eps_ * _abs ((fvecp_[i_ - 1] - fvec_[i_ - 1]) / eps_ - err_[i_ - 1]) / (_abs (fvec_[i_ - 1]) + _abs (fvecp_[i_ 
      - 1]));
    }
    err_[i_ - 1] = one_;
    if (temp_ > epsmch_ && temp_ < eps_) {
      err_[i_ - 1] = (log10 (temp_) - epslog_) / epslog_;
    }
    if (temp_ >= eps_) {
      err_[i_ - 1] = zero_;
    }
  }
  _l70:;
  __calls[0].calls++;
  return 0;
}

int_4 _dogleg (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ lr_, real_8 _p_ diag_, real_8 _p_ qtb_, real_8 _p_ delta_, real_8 
_p_ x_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 i_, j_, jj_, jp1_, k_, l_;
  static real_8 alpha_, bnorm_, epsmch_, gnorm_, one_, qnorm_, sgnorm_, sum_, temp_, zero_;
  int_4 _data_k_1;
  real_8 $0_, $1_, $2_, $3_, $4_;
#define _data_n_1 2
  static real_8 _data_l_1[_data_n_1] = {
    1.0e0,
    0.0e0
  };
  if (__calls[1].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    one_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    zero_ = _data_l_1[_data_k_1++];
  }
  epsmch_ = _dpmpar (&_k1);
  jj_ = ((*n_) * ((*n_) + 1)) / 2 + 1;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    j_ = (*n_) - k_ + 1;
    jp1_ = j_ + 1;
    jj_ = jj_ - k_;
    l_ = jj_ + 1;
    sum_ = zero_;
    if ((*n_) < jp1_) {
      goto _l20;
    }
    for (i_ = jp1_; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + r_[l_ - 1] * x_[i_ - 1];
      l_ = l_ + 1;
    }
    _l20:;
    temp_ = r_[jj_ - 1];
    if (temp_ != zero_) {
      goto _l40;
    }
    l_ = j_;
    for (i_ = 1; i_ <= j_; (i_)++) {
      temp_ = _max (temp_, _abs (r_[l_ - 1]));
      l_ = l_ + (*n_) - i_;
    }
    temp_ = epsmch_ * temp_;
    if (temp_ == zero_) {
      temp_ = epsmch_;
    }
    _l40:;
    x_[j_ - 1] = (qtb_[j_ - 1] - sum_) / temp_;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = zero_;
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  qnorm_ = _enorm (n_, wa2_);
  if (qnorm_ <= (*delta_)) {
    goto _l140;
  }
  l_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = qtb_[j_ - 1];
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      wa1_[i_ - 1] = wa1_[i_ - 1] + r_[l_ - 1] * temp_;
      l_ = l_ + 1;
    }
    wa1_[j_ - 1] = wa1_[j_ - 1] / diag_[j_ - 1];
  }
  gnorm_ = _enorm (n_, wa1_);
  sgnorm_ = zero_;
  alpha_ = (*delta_) / qnorm_;
  if (gnorm_ == zero_) {
    goto _l120;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = (wa1_[j_ - 1] / gnorm_) / diag_[j_ - 1];
  }
  l_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    sum_ = zero_;
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + r_[l_ - 1] * wa1_[i_ - 1];
      l_ = l_ + 1;
    }
    wa2_[j_ - 1] = sum_;
  }
  temp_ = _enorm (n_, wa2_);
  sgnorm_ = (gnorm_ / temp_) / temp_;
  alpha_ = zero_;
  if (sgnorm_ >= (*delta_)) {
    goto _l120;
  }
  bnorm_ = _enorm (n_, qtb_);
  temp_ = (bnorm_ / gnorm_) * (bnorm_ / qnorm_) * (sgnorm_ / (*delta_));
  temp_ = temp_ - ((*delta_) / qnorm_) * ($0_ = (sgnorm_ / (*delta_)), $0_ * $0_) + sqrt (($1_ = (temp_ - ((*delta_) / 
  qnorm_)), $1_ * $1_) + (one_ - ($2_ = ((*delta_) / qnorm_), $2_ * $2_)) * (one_ - ($3_ = (sgnorm_ / (*delta_)), $3_ * 
  $3_)));
  alpha_ = (((*delta_) / qnorm_) * (one_ - ($4_ = (sgnorm_ / (*delta_)), $4_ * $4_))) / temp_;
  _l120:;
  temp_ = (one_ - alpha_) * _min (sgnorm_, (*delta_));
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = temp_ * wa1_[j_ - 1] + alpha_ * x_[j_ - 1];
  }
  _l140:;
  __calls[1].calls++;
  return 0;
}

real_8 _dpmpar (int_4 _p_ i_)
{
  int_4 $0_, $1_;
  real_8 dpmpar_;
  extern real_4 _dmach ();
  switch ((*i_)) {
    default:
    case 1: goto _l1;
    case 2: goto _l2;
    case 3: goto _l3;
  }
  _l1:;
  dpmpar_ = _dmach (($0_ = 4, &$0_));
  goto _l0;
  _l2:;
  dpmpar_ = _dmach (&_k1);
  goto _l0;
  _l3:;
  dpmpar_ = _dmach (($1_ = 2, &$1_));
  _l0:;
  __calls[2].calls++;
  return dpmpar_;
}

real_8 _enorm (int_4 _p_ n_, real_8 _p_ x_)
{
  static int_4 i_;
  static real_8 agiant_, floatn_, one_, rdwarf_, rgiant_, s1_, s2_, s3_, xabs_, x1max_, x3max_, zero_;
  int_4 _data_k_2;
  real_8 $0_, $1_, $2_, $3_;
  real_8 enorm_;
#define _data_n_2 4
  static real_8 _data_l_2[_data_n_2] = {
    1.0e0,
    0.0e0,
    3.834e-20,
    1.304e19
  };
  if (__calls[3].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    one_ = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    zero_ = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    rdwarf_ = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    rgiant_ = _data_l_2[_data_k_2++];
  }
  s1_ = zero_;
  s2_ = zero_;
  s3_ = zero_;
  x1max_ = zero_;
  x3max_ = zero_;
  floatn_ = (*n_);
  agiant_ = rgiant_ / floatn_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    xabs_ = _abs (x_[i_ - 1]);
    if (xabs_ > rdwarf_ && xabs_ < agiant_) {
      goto _l70;
    }
    if (xabs_ <= rdwarf_) {
      goto _l30;
    }
    if (xabs_ <= x1max_) {
      goto _l10;
    }
    s1_ = one_ + s1_ * ($0_ = (x1max_ / xabs_), $0_ * $0_);
    x1max_ = xabs_;
    goto _l20;
    _l10:;
    s1_ = s1_ + ($1_ = (xabs_ / x1max_), $1_ * $1_);
    _l20:;
    goto _l60;
    _l30:;
    if (xabs_ <= x3max_) {
      goto _l40;
    }
    s3_ = one_ + s3_ * ($2_ = (x3max_ / xabs_), $2_ * $2_);
    x3max_ = xabs_;
    goto _l50;
    _l40:;
    if (xabs_ != zero_) {
      s3_ = s3_ + ($3_ = (xabs_ / x3max_), $3_ * $3_);
    }
    _l50:;
    _l60:;
    goto _l80;
    _l70:;
    s2_ = s2_ + (xabs_ * xabs_);
    _l80:;
  }
  if (s1_ == zero_) {
    goto _l100;
  }
  enorm_ = x1max_ * sqrt (s1_ + (s2_ / x1max_) / x1max_);
  goto _l130;
  _l100:;
  if (s2_ == zero_) {
    goto _l110;
  }
  if (s2_ >= x3max_) {
    enorm_ = sqrt (s2_ * (one_ + (x3max_ / s2_) * (x3max_ * s3_)));
  }
  if (s2_ < x3max_) {
    enorm_ = sqrt (x3max_ * ((s2_ / x3max_) + (x3max_ * s3_)));
  }
  goto _l120;
  _l110:;
  enorm_ = x3max_ * sqrt (s3_);
  _l120:;
  _l130:;
  __calls[3].calls++;
  return enorm_;
}

int_4 _fdjac1 (int_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, 
int_4 _p_ iflag_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ epsfcn_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 i_, j_, k_, msum_;
  static real_8 eps_, epsmch_, h_, temp_, zero_;
  int_4 _data_k_3;
#define _data_n_3 1
  static real_8 _data_l_3[_data_n_3] = {
    0.0e0
  };
  if (__calls[4].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    zero_ = _data_l_3[_data_k_3++];
  }
  epsmch_ = _dpmpar (&_k1);
  eps_ = sqrt (_max ((*epsfcn_), epsmch_));
  msum_ = (*ml_) + (*mu_) + 1;
  if (msum_ < (*n_)) {
    goto _l40;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = x_[j_ - 1];
    h_ = eps_ * _abs (temp_);
    if (h_ == zero_) {
      h_ = eps_;
    }
    x_[j_ - 1] = temp_ + h_;
    (void) _fcn (n_, x_, wa1_, iflag_);
    if ((*iflag_) < 0) {
      goto _l30;
    }
    x_[j_ - 1] = temp_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = (wa1_[i_ - 1] - fvec_[i_ - 1]) / h_;
    }
  }
  _l30:;
  goto _l110;
  _l40:;
  for (k_ = 1; k_ <= msum_; (k_)++) {
    for (j_ = k_; (msum_ > 0 ? j_ <= (*n_) : j_ >= (*n_)); j_ += msum_) {
      wa2_[j_ - 1] = x_[j_ - 1];
      h_ = eps_ * _abs (wa2_[j_ - 1]);
      if (h_ == zero_) {
        h_ = eps_;
      }
      x_[j_ - 1] = wa2_[j_ - 1] + h_;
    }
    (void) _fcn (n_, x_, wa1_, iflag_);
    if ((*iflag_) < 0) {
      goto _l100;
    }
    for (j_ = k_; (msum_ > 0 ? j_ <= (*n_) : j_ >= (*n_)); j_ += msum_) {
      x_[j_ - 1] = wa2_[j_ - 1];
      h_ = eps_ * _abs (wa2_[j_ - 1]);
      if (h_ == zero_) {
        h_ = eps_;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = zero_;
        if (i_ >= j_ - (*mu_) && i_ <= j_ + (*ml_)) {
          fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = (wa1_[i_ - 1] - fvec_[i_ - 1]) / h_;
        }
      }
    }
  }
  _l100:;
  _l110:;
  __calls[4].calls++;
  return 0;
}

int_4 _fdjac2 (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 
_p_ ldfjac_, int_4 _p_ iflag_, real_8 _p_ epsfcn_, real_8 _p_ wa_)
{
  static int_4 i_, j_;
  static real_8 eps_, epsmch_, h_, temp_, zero_;
  int_4 _data_k_4;
#define _data_n_4 1
  static real_8 _data_l_4[_data_n_4] = {
    0.0e0
  };
  if (__calls[5].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    zero_ = _data_l_4[_data_k_4++];
  }
  epsmch_ = _dpmpar (&_k1);
  eps_ = sqrt (_max ((*epsfcn_), epsmch_));
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = x_[j_ - 1];
    h_ = eps_ * _abs (temp_);
    if (h_ == zero_) {
      h_ = eps_;
    }
    x_[j_ - 1] = temp_ + h_;
    (void) _fcn (m_, n_, x_, wa_, iflag_);
    if ((*iflag_) < 0) {
      goto _l30;
    }
    x_[j_ - 1] = temp_;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = (wa_[i_ - 1] - fvec_[i_ - 1]) / h_;
    }
  }
  _l30:;
  __calls[5].calls++;
  return 0;
}

int_4 _hybrd1 (real_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ tol_, int_4 _p_ info_, 
real_8 _p_ wa_, int_4 _p_ lwa_)
{
  static int_4 index_, j_, lr_, maxfev_, ml_, mode_, mu_, nfev_, nprint_;
  static real_8 epsfcn_, factor_, one_, xtol_, zero_;
  int_4 _data_k_5;
#define _data_n_5 3
  static real_8 _data_l_5[_data_n_5] = {
    1.0e2,
    1.0e0,
    0.0e0
  };
  if (__calls[6].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    factor_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    one_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    zero_ = _data_l_5[_data_k_5++];
  }
  (*info_) = 0;
  if ((*n_) <= 0 || (*tol_) < zero_ || (*lwa_) < ((*n_) * (3 * (*n_) + 13)) / 2) {
    goto _l20;
  }
  maxfev_ = 200 * ((*n_) + 1);
  xtol_ = (*tol_);
  ml_ = (*n_) - 1;
  mu_ = (*n_) - 1;
  epsfcn_ = zero_;
  mode_ = 2;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa_[j_ - 1] = one_;
  }
  nprint_ = 0;
  lr_ = ((*n_) * ((*n_) + 1)) / 2;
  index_ = 6 * (*n_) + lr_;
  (void) _hybrd (_fcn, n_, x_, fvec_, &xtol_, &maxfev_, &ml_, &mu_, &epsfcn_, &wa_[0], &mode_, &factor_, &nprint_, info_, 
  &nfev_, &wa_[index_ + 1 - 1], n_, &wa_[6 * (*n_) + 1 - 1], &lr_, &wa_[(*n_) + 1 - 1], &wa_[2 * (*n_) + 1 - 1], &wa_[3 * 
  (*n_) + 1 - 1], &wa_[4 * (*n_) + 1 - 1], &wa_[5 * (*n_) + 1 - 1]);
  if ((*info_) == 5) {
    (*info_) = 4;
  }
  _l20:;
  __calls[6].calls++;
  return 0;
}

int_4 _hybrd (int_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ xtol_, int_4 _p_ maxfev_, 
int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ epsfcn_, real_8 _p_ diag_, int_4 _p_ mode_, real_8 _p_ factor_, int_4 _p_ 
nprint_, int_4 _p_ info_, int_4 _p_ nfev_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, real_8 _p_ r_, int_4 _p_ lr_, real_8 
_p_ qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 i_, iflag_, iter_, j_, jm1_, l_, msum_, ncfail_, ncsuc_, nslow1_, nslow2_, iwa_[1];
  static logical_4 jeval_, sing_;
  static real_8 actred_, delta_, epsmch_, fnorm_, fnorm1_, one_, pnorm_, prered_, p1_, p5_, p001_, p0001_, ratio_, sum_, 
  temp_, xnorm_, zero_;
  int_4 _data_k_6;
  logical_4 $0_;
  real_8 $1_, $2_;
#define _data_n_6 6
  static real_8 _data_l_6[_data_n_6] = {
    1.0e0,
    1.0e-1,
    5.0e-1,
    1.0e-3,
    1.0e-4,
    0.0e0
  };
  if (__calls[7].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    one_ = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    p1_ = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    p5_ = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    p001_ = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    p0001_ = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    zero_ = _data_l_6[_data_k_6++];
  }
  epsmch_ = _dpmpar (&_k1);
  (*info_) = 0;
  iflag_ = 0;
  (*nfev_) = 0;
  if ((*n_) <= 0 || (*xtol_) < zero_ || (*maxfev_) <= 0 || (*ml_) < 0 || (*mu_) < 0 || (*factor_) <= zero_ || (*ldfjac_) 
    < (*n_) || (*lr_) < ((*n_) * ((*n_) + 1)) / 2) {
    goto _l300;
  }
  if ((*mode_) != 2) {
    goto _l20;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (diag_[j_ - 1] <= zero_) {
      goto _l300;
    }
  }
  _l20:;
  iflag_ = 1;
  (void) _fcn (n_, x_, fvec_, &iflag_);
  (*nfev_) = 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  fnorm_ = _enorm (n_, fvec_);
  msum_ = _min ((*ml_) + (*mu_) + 1, (*n_));
  iter_ = 1;
  ncsuc_ = 0;
  ncfail_ = 0;
  nslow1_ = 0;
  nslow2_ = 0;
  _l30:;
  jeval_ = TRUE;
  iflag_ = 2;
  (void) _fdjac1 (_fcn, n_, x_, fvec_, fjac_, ldfjac_, &iflag_, ml_, mu_, epsfcn_, wa1_, wa2_);
  (*nfev_) = (*nfev_) + msum_;
  if (iflag_ < 0) {
    goto _l300;
  }
  (void) _qrfac (n_, n_, fjac_, ldfjac_, ($0_ = FALSE, &$0_), iwa_, &_k1, wa1_, wa2_, wa3_);
  if (iter_ != 1) {
    goto _l70;
  }
  if ((*mode_) == 2) {
    goto _l50;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = wa2_[j_ - 1];
    if (wa2_[j_ - 1] == zero_) {
      diag_[j_ - 1] = one_;
    }
  }
  _l50:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa3_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  xnorm_ = _enorm (n_, wa3_);
  delta_ = (*factor_) * xnorm_;
  if (delta_ == zero_) {
    delta_ = (*factor_);
  }
  _l70:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    qtf_[i_ - 1] = fvec_[i_ - 1];
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] == zero_) {
      goto _l110;
    }
    sum_ = zero_;
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * qtf_[i_ - 1];
    }
    temp_ = -sum_ / fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      qtf_[i_ - 1] = qtf_[i_ - 1] + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * temp_;
    }
    _l110:;
  }
  sing_ = FALSE;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l140;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      r_[l_ - 1] = fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
      l_ = l_ + (*n_) - i_;
    }
    _l140:;
    r_[l_ - 1] = wa1_[j_ - 1];
    if (wa1_[j_ - 1] == zero_) {
      sing_ = TRUE;
    }
  }
  (void) _qform (n_, n_, fjac_, ldfjac_, wa1_);
  if ((*mode_) == 2) {
    goto _l170;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = _max (diag_[j_ - 1], wa2_[j_ - 1]);
  }
  _l170:;
  _l180:;
  if ((*nprint_) <= 0) {
    goto _l190;
  }
  iflag_ = 0;
  if (_imod (iter_ - 1, (*nprint_)) == 0) {
    (void) _fcn (n_, x_, fvec_, &iflag_);
  }
  if (iflag_ < 0) {
    goto _l300;
  }
  _l190:;
  (void) _dogleg (n_, r_, lr_, diag_, qtf_, &delta_, wa1_, wa2_, wa3_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = -wa1_[j_ - 1];
    wa2_[j_ - 1] = x_[j_ - 1] + wa1_[j_ - 1];
    wa3_[j_ - 1] = diag_[j_ - 1] * wa1_[j_ - 1];
  }
  pnorm_ = _enorm (n_, wa3_);
  if (iter_ == 1) {
    delta_ = _min (delta_, pnorm_);
  }
  iflag_ = 1;
  (void) _fcn (n_, wa2_, wa4_, &iflag_);
  (*nfev_) = (*nfev_) + 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  fnorm1_ = _enorm (n_, wa4_);
  actred_ = -one_;
  if (fnorm1_ < fnorm_) {
    actred_ = one_ - ($1_ = (fnorm1_ / fnorm_), $1_ * $1_);
  }
  l_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sum_ = zero_;
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      sum_ = sum_ + r_[l_ - 1] * wa1_[j_ - 1];
      l_ = l_ + 1;
    }
    wa3_[i_ - 1] = qtf_[i_ - 1] + sum_;
  }
  temp_ = _enorm (n_, wa3_);
  prered_ = zero_;
  if (temp_ < fnorm_) {
    prered_ = one_ - ($2_ = (temp_ / fnorm_), $2_ * $2_);
  }
  ratio_ = zero_;
  if (prered_ > zero_) {
    ratio_ = actred_ / prered_;
  }
  if (ratio_ >= p1_) {
    goto _l230;
  }
  ncsuc_ = 0;
  ncfail_ = ncfail_ + 1;
  delta_ = p5_ * delta_;
  goto _l240;
  _l230:;
  ncfail_ = 0;
  ncsuc_ = ncsuc_ + 1;
  if (ratio_ >= p5_ || ncsuc_ > 1) {
    delta_ = _max (delta_, pnorm_ / p5_);
  }
  if (_abs (ratio_ - one_) <= p1_) {
    delta_ = pnorm_ / p5_;
  }
  _l240:;
  if (ratio_ < p0001_) {
    goto _l260;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = wa2_[j_ - 1];
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
    fvec_[j_ - 1] = wa4_[j_ - 1];
  }
  xnorm_ = _enorm (n_, wa2_);
  fnorm_ = fnorm1_;
  iter_ = iter_ + 1;
  _l260:;
  nslow1_ = nslow1_ + 1;
  if (actred_ >= p001_) {
    nslow1_ = 0;
  }
  if (jeval_) {
    nslow2_ = nslow2_ + 1;
  }
  if (actred_ >= p1_) {
    nslow2_ = 0;
  }
  if (delta_ <= (*xtol_) * xnorm_ || fnorm_ == zero_) {
    (*info_) = 1;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if ((*nfev_) >= (*maxfev_)) {
    (*info_) = 2;
  }
  if (p1_ * _max (p1_ * delta_, pnorm_) <= epsmch_ * xnorm_) {
    (*info_) = 3;
  }
  if (nslow2_ == 5) {
    (*info_) = 4;
  }
  if (nslow1_ == 10) {
    (*info_) = 5;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if (ncfail_ == 2) {
    goto _l290;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    sum_ = zero_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * wa4_[i_ - 1];
    }
    wa2_[j_ - 1] = (sum_ - wa3_[j_ - 1]) / pnorm_;
    wa1_[j_ - 1] = diag_[j_ - 1] * ((diag_[j_ - 1] * wa1_[j_ - 1]) / pnorm_);
    if (ratio_ >= p0001_) {
      qtf_[j_ - 1] = sum_;
    }
  }
  (void) _r1updt (n_, n_, r_, lr_, wa1_, wa2_, wa3_, &sing_);
  (void) _r1mpyq (n_, n_, fjac_, ldfjac_, wa2_, wa3_);
  (void) _r1mpyq (&_k1, n_, qtf_, &_k1, wa2_, wa3_);
  jeval_ = FALSE;
  goto _l180;
  _l290:;
  goto _l30;
  _l300:;
  if (iflag_ < 0) {
    (*info_) = iflag_;
  }
  iflag_ = 0;
  if ((*nprint_) > 0) {
    (void) _fcn (n_, x_, fvec_, &iflag_);
  }
  __calls[7].calls++;
  return 0;
}
int_4 _hybrj1 (real_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, 
real_8 _p_ tol_, int_4 _p_ info_, real_8 _p_ wa_, int_4 _p_ lwa_)
{
  static int_4 j_, lr_, maxfev_, mode_, nfev_, njev_, nprint_;
  static real_8 factor_, one_, xtol_, zero_;
  int_4 _data_k_7;
#define _data_n_7 3
  static real_8 _data_l_7[_data_n_7] = {
    1.0e2,
    1.0e0,
    0.0e0
  };
  if (__calls[8].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    factor_ = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    one_ = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    zero_ = _data_l_7[_data_k_7++];
  }
  (*info_) = 0;
  if ((*n_) <= 0 || (*ldfjac_) < (*n_) || (*tol_) < zero_ || (*lwa_) < ((*n_) * ((*n_) + 13)) / 2) {
    goto _l20;
  }
  maxfev_ = 100 * ((*n_) + 1);
  xtol_ = (*tol_);
  mode_ = 2;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa_[j_ - 1] = one_;
  }
  nprint_ = 0;
  lr_ = ((*n_) * ((*n_) + 1)) / 2;
  (void) _hybrj (_fcn, n_, x_, fvec_, fjac_, ldfjac_, &xtol_, &maxfev_, &wa_[0], &mode_, &factor_, &nprint_, info_, 
  &nfev_, &njev_, &wa_[6 * (*n_) + 1 - 1], &lr_, &wa_[(*n_) + 1 - 1], &wa_[2 * (*n_) + 1 - 1], &wa_[3 * (*n_) + 1 - 1], 
  &wa_[4 * (*n_) + 1 - 1], &wa_[5 * (*n_) + 1 - 1]);
  if ((*info_) == 5) {
    (*info_) = 4;
  }
  _l20:;
  __calls[8].calls++;
  return 0;
}

int_4 _hybrj (int_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, 
real_8 _p_ xtol_, int_4 _p_ maxfev_, real_8 _p_ diag_, int_4 _p_ mode_, real_8 _p_ factor_, int_4 _p_ nprint_, int_4 
_p_ info_, int_4 _p_ nfev_, int_4 _p_ njev_, real_8 _p_ r_, int_4 _p_ lr_, real_8 _p_ qtf_, real_8 _p_ wa1_, real_8 _p_ 
wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 i_, iflag_, iter_, j_, jm1_, l_, ncfail_, ncsuc_, nslow1_, nslow2_, iwa_[1];
  static logical_4 jeval_, sing_;
  static real_8 actred_, delta_, epsmch_, fnorm_, fnorm1_, one_, pnorm_, prered_, p1_, p5_, p001_, p0001_, ratio_, sum_, 
  temp_, xnorm_, zero_;
  int_4 _data_k_8;
  logical_4 $0_;
  real_8 $1_, $2_;
#define _data_n_8 6
  static real_8 _data_l_8[_data_n_8] = {
    1.0e0,
    1.0e-1,
    5.0e-1,
    1.0e-3,
    1.0e-4,
    0.0e0
  };
  if (__calls[9].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    one_ = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    p1_ = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    p5_ = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    p001_ = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    p0001_ = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    zero_ = _data_l_8[_data_k_8++];
  }
  epsmch_ = _dpmpar (&_k1);
  (*info_) = 0;
  iflag_ = 0;
  (*nfev_) = 0;
  (*njev_) = 0;
  if ((*n_) <= 0 || (*ldfjac_) < (*n_) || (*xtol_) < zero_ || (*maxfev_) <= 0 || (*factor_) <= zero_ || (*lr_) < ((*n_) * 
    ((*n_) + 1)) / 2) {
    goto _l300;
  }
  if ((*mode_) != 2) {
    goto _l20;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (diag_[j_ - 1] <= zero_) {
      goto _l300;
    }
  }
  _l20:;
  iflag_ = 1;
  (void) _fcn (n_, x_, fvec_, fjac_, ldfjac_, &iflag_);
  (*nfev_) = 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  fnorm_ = _enorm (n_, fvec_);
  iter_ = 1;
  ncsuc_ = 0;
  ncfail_ = 0;
  nslow1_ = 0;
  nslow2_ = 0;
  _l30:;
  jeval_ = TRUE;
  iflag_ = 2;
  (void) _fcn (n_, x_, fvec_, fjac_, ldfjac_, &iflag_);
  (*njev_) = (*njev_) + 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  (void) _qrfac (n_, n_, fjac_, ldfjac_, ($0_ = FALSE, &$0_), iwa_, &_k1, wa1_, wa2_, wa3_);
  if (iter_ != 1) {
    goto _l70;
  }
  if ((*mode_) == 2) {
    goto _l50;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = wa2_[j_ - 1];
    if (wa2_[j_ - 1] == zero_) {
      diag_[j_ - 1] = one_;
    }
  }
  _l50:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa3_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  xnorm_ = _enorm (n_, wa3_);
  delta_ = (*factor_) * xnorm_;
  if (delta_ == zero_) {
    delta_ = (*factor_);
  }
  _l70:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    qtf_[i_ - 1] = fvec_[i_ - 1];
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] == zero_) {
      goto _l110;
    }
    sum_ = zero_;
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * qtf_[i_ - 1];
    }
    temp_ = -sum_ / fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      qtf_[i_ - 1] = qtf_[i_ - 1] + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * temp_;
    }
    _l110:;
  }
  sing_ = FALSE;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = j_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l140;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      r_[l_ - 1] = fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
      l_ = l_ + (*n_) - i_;
    }
    _l140:;
    r_[l_ - 1] = wa1_[j_ - 1];
    if (wa1_[j_ - 1] == zero_) {
      sing_ = TRUE;
    }
  }
  (void) _qform (n_, n_, fjac_, ldfjac_, wa1_);
  if ((*mode_) == 2) {
    goto _l170;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = _max (diag_[j_ - 1], wa2_[j_ - 1]);
  }
  _l170:;
  _l180:;
  if ((*nprint_) <= 0) {
    goto _l190;
  }
  iflag_ = 0;
  if (_imod (iter_ - 1, (*nprint_)) == 0) {
    (void) _fcn (n_, x_, fvec_, fjac_, ldfjac_, &iflag_);
  }
  if (iflag_ < 0) {
    goto _l300;
  }
  _l190:;
  (void) _dogleg (n_, r_, lr_, diag_, qtf_, &delta_, wa1_, wa2_, wa3_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = -wa1_[j_ - 1];
    wa2_[j_ - 1] = x_[j_ - 1] + wa1_[j_ - 1];
    wa3_[j_ - 1] = diag_[j_ - 1] * wa1_[j_ - 1];
  }
  pnorm_ = _enorm (n_, wa3_);
  if (iter_ == 1) {
    delta_ = _min (delta_, pnorm_);
  }
  iflag_ = 1;
  (void) _fcn (n_, wa2_, wa4_, fjac_, ldfjac_, &iflag_);
  (*nfev_) = (*nfev_) + 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  fnorm1_ = _enorm (n_, wa4_);
  actred_ = -one_;
  if (fnorm1_ < fnorm_) {
    actred_ = one_ - ($1_ = (fnorm1_ / fnorm_), $1_ * $1_);
  }
  l_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sum_ = zero_;
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      sum_ = sum_ + r_[l_ - 1] * wa1_[j_ - 1];
      l_ = l_ + 1;
    }
    wa3_[i_ - 1] = qtf_[i_ - 1] + sum_;
  }
  temp_ = _enorm (n_, wa3_);
  prered_ = zero_;
  if (temp_ < fnorm_) {
    prered_ = one_ - ($2_ = (temp_ / fnorm_), $2_ * $2_);
  }
  ratio_ = zero_;
  if (prered_ > zero_) {
    ratio_ = actred_ / prered_;
  }
  if (ratio_ >= p1_) {
    goto _l230;
  }
  ncsuc_ = 0;
  ncfail_ = ncfail_ + 1;
  delta_ = p5_ * delta_;
  goto _l240;
  _l230:;
  ncfail_ = 0;
  ncsuc_ = ncsuc_ + 1;
  if (ratio_ >= p5_ || ncsuc_ > 1) {
    delta_ = _max (delta_, pnorm_ / p5_);
  }
  if (_abs (ratio_ - one_) <= p1_) {
    delta_ = pnorm_ / p5_;
  }
  _l240:;
  if (ratio_ < p0001_) {
    goto _l260;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = wa2_[j_ - 1];
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
    fvec_[j_ - 1] = wa4_[j_ - 1];
  }
  xnorm_ = _enorm (n_, wa2_);
  fnorm_ = fnorm1_;
  iter_ = iter_ + 1;
  _l260:;
  nslow1_ = nslow1_ + 1;
  if (actred_ >= p001_) {
    nslow1_ = 0;
  }
  if (jeval_) {
    nslow2_ = nslow2_ + 1;
  }
  if (actred_ >= p1_) {
    nslow2_ = 0;
  }
  if (delta_ <= (*xtol_) * xnorm_ || fnorm_ == zero_) {
    (*info_) = 1;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if ((*nfev_) >= (*maxfev_)) {
    (*info_) = 2;
  }
  if (p1_ * _max (p1_ * delta_, pnorm_) <= epsmch_ * xnorm_) {
    (*info_) = 3;
  }
  if (nslow2_ == 5) {
    (*info_) = 4;
  }
  if (nslow1_ == 10) {
    (*info_) = 5;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if (ncfail_ == 2) {
    goto _l290;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    sum_ = zero_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * wa4_[i_ - 1];
    }
    wa2_[j_ - 1] = (sum_ - wa3_[j_ - 1]) / pnorm_;
    wa1_[j_ - 1] = diag_[j_ - 1] * ((diag_[j_ - 1] * wa1_[j_ - 1]) / pnorm_);
    if (ratio_ >= p0001_) {
      qtf_[j_ - 1] = sum_;
    }
  }
  (void) _r1updt (n_, n_, r_, lr_, wa1_, wa2_, wa3_, &sing_);
  (void) _r1mpyq (n_, n_, fjac_, ldfjac_, wa2_, wa3_);
  (void) _r1mpyq (&_k1, n_, qtf_, &_k1, wa2_, wa3_);
  jeval_ = FALSE;
  goto _l180;
  _l290:;
  goto _l30;
  _l300:;
  if (iflag_ < 0) {
    (*info_) = iflag_;
  }
  iflag_ = 0;
  if ((*nprint_) > 0) {
    (void) _fcn (n_, x_, fvec_, fjac_, ldfjac_, &iflag_);
  }
  __calls[9].calls++;
  return 0;
}
int_4 _lmder1 (real_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 
_p_ ldfjac_, real_8 _p_ tol_, int_4 _p_ info_, int_4 _p_ ipvt_, real_8 _p_ wa_, int_4 _p_ lwa_)
{
  static int_4 maxfev_, mode_, nfev_, njev_, nprint_;
  static real_8 factor_, ftol_, gtol_, xtol_, zero_;
  int_4 _data_k_9;
#define _data_n_9 2
  static real_8 _data_l_9[_data_n_9] = {
    1.0e2,
    0.0e0
  };
  if (__calls[10].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    factor_ = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    zero_ = _data_l_9[_data_k_9++];
  }
  (*info_) = 0;
  if ((*n_) <= 0 || (*m_) < (*n_) || (*ldfjac_) < (*m_) || (*tol_) < zero_ || (*lwa_) < 5 * (*n_) + (*m_)) {
    goto _l10;
  }
  maxfev_ = 100 * ((*n_) + 1);
  ftol_ = (*tol_);
  xtol_ = (*tol_);
  gtol_ = zero_;
  mode_ = 1;
  nprint_ = 0;
  (void) _lmder (_fcn, m_, n_, x_, fvec_, fjac_, ldfjac_, &ftol_, &xtol_, &gtol_, &maxfev_, &wa_[0], &mode_, &factor_, 
  &nprint_, info_, &nfev_, &njev_, ipvt_, &wa_[(*n_) + 1 - 1], &wa_[2 * (*n_) + 1 - 1], &wa_[3 * (*n_) + 1 - 1], &wa_[4 * 
  (*n_) + 1 - 1], &wa_[5 * (*n_) + 1 - 1]);
  if ((*info_) == 8) {
    (*info_) = 4;
  }
  _l10:;
  __calls[10].calls++;
  return 0;
}

int_4 _lmder (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ 
ldfjac_, real_8 _p_ ftol_, real_8 _p_ xtol_, real_8 _p_ gtol_, int_4 _p_ maxfev_, real_8 _p_ diag_, int_4 _p_ mode_, 
real_8 _p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, int_4 _p_ njev_, int_4 _p_ ipvt_, real_8 _p_ 
qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 i_, iflag_, iter_, j_, l_;
  static real_8 actred_, delta_, dirder_, epsmch_, fnorm_, fnorm1_, gnorm_, one_, par_, pnorm_, prered_, p1_, p5_, p25_, 
  p75_, p0001_, ratio_, sum_, temp_, temp1_, temp2_, xnorm_, zero_;
  int_4 _data_k_10;
  logical_4 $0_;
  real_8 $1_;
#define _data_n_10 7
  static real_8 _data_l_10[_data_n_10] = {
    1.0e0,
    1.0e-1,
    5.0e-1,
    2.5e-1,
    7.5e-1,
    1.0e-4,
    0.0e0
  };
  if (__calls[11].calls == 0) {
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    one_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    p1_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    p5_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    p25_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    p75_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    p0001_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    zero_ = _data_l_10[_data_k_10++];
  }
  epsmch_ = _dpmpar (&_k1);
  (*info_) = 0;
  iflag_ = 0;
  (*nfev_) = 0;
  (*njev_) = 0;
  if ((*n_) <= 0 || (*m_) < (*n_) || (*ldfjac_) < (*m_) || (*ftol_) < zero_ || (*xtol_) < zero_ || (*gtol_) < zero_ || 
    (*maxfev_) <= 0 || (*factor_) <= zero_) {
    goto _l300;
  }
  if ((*mode_) != 2) {
    goto _l20;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (diag_[j_ - 1] <= zero_) {
      goto _l300;
    }
  }
  _l20:;
  iflag_ = 1;
  (void) _fcn (m_, n_, x_, fvec_, fjac_, ldfjac_, &iflag_);
  (*nfev_) = 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  fnorm_ = _enorm (m_, fvec_);
  par_ = zero_;
  iter_ = 1;
  _l30:;
  iflag_ = 2;
  (void) _fcn (m_, n_, x_, fvec_, fjac_, ldfjac_, &iflag_);
  (*njev_) = (*njev_) + 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  if ((*nprint_) <= 0) {
    goto _l40;
  }
  iflag_ = 0;
  if (_imod (iter_ - 1, (*nprint_)) == 0) {
    (void) _fcn (m_, n_, x_, fvec_, fjac_, ldfjac_, &iflag_);
  }
  if (iflag_ < 0) {
    goto _l300;
  }
  _l40:;
  (void) _qrfac (m_, n_, fjac_, ldfjac_, ($0_ = TRUE, &$0_), ipvt_, n_, wa1_, wa2_, wa3_);
  if (iter_ != 1) {
    goto _l80;
  }
  if ((*mode_) == 2) {
    goto _l60;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = wa2_[j_ - 1];
    if (wa2_[j_ - 1] == zero_) {
      diag_[j_ - 1] = one_;
    }
  }
  _l60:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa3_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  xnorm_ = _enorm (n_, wa3_);
  delta_ = (*factor_) * xnorm_;
  if (delta_ == zero_) {
    delta_ = (*factor_);
  }
  _l80:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    wa4_[i_ - 1] = fvec_[i_ - 1];
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] == zero_) {
      goto _l120;
    }
    sum_ = zero_;
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * wa4_[i_ - 1];
    }
    temp_ = -sum_ / fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      wa4_[i_ - 1] = wa4_[i_ - 1] + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * temp_;
    }
    _l120:;
    fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = wa1_[j_ - 1];
    qtf_[j_ - 1] = wa4_[j_ - 1];
  }
  gnorm_ = zero_;
  if (fnorm_ == zero_) {
    goto _l170;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = ipvt_[j_ - 1];
    if (wa2_[l_ - 1] == zero_) {
      goto _l150;
    }
    sum_ = zero_;
    for (i_ = 1; i_ <= j_; (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * (qtf_[i_ - 1] / fnorm_);
    }
    gnorm_ = _max (gnorm_, _abs (sum_ / wa2_[l_ - 1]));
    _l150:;
  }
  _l170:;
  if (gnorm_ <= (*gtol_)) {
    (*info_) = 4;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if ((*mode_) == 2) {
    goto _l190;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = _max (diag_[j_ - 1], wa2_[j_ - 1]);
  }
  _l190:;
  _l200:;
  (void) _lmpar (n_, fjac_, ldfjac_, ipvt_, diag_, qtf_, &delta_, &par_, wa1_, wa2_, wa3_, wa4_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = -wa1_[j_ - 1];
    wa2_[j_ - 1] = x_[j_ - 1] + wa1_[j_ - 1];
    wa3_[j_ - 1] = diag_[j_ - 1] * wa1_[j_ - 1];
  }
  pnorm_ = _enorm (n_, wa3_);
  if (iter_ == 1) {
    delta_ = _min (delta_, pnorm_);
  }
  iflag_ = 1;
  (void) _fcn (m_, n_, wa2_, wa4_, fjac_, ldfjac_, &iflag_);
  (*nfev_) = (*nfev_) + 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  fnorm1_ = _enorm (m_, wa4_);
  actred_ = -one_;
  if (p1_ * fnorm1_ < fnorm_) {
    actred_ = one_ - ($1_ = (fnorm1_ / fnorm_), $1_ * $1_);
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa3_[j_ - 1] = zero_;
    l_ = ipvt_[j_ - 1];
    temp_ = wa1_[l_ - 1];
    for (i_ = 1; i_ <= j_; (i_)++) {
      wa3_[i_ - 1] = wa3_[i_ - 1] + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * temp_;
    }
  }
  temp1_ = _enorm (n_, wa3_) / fnorm_;
  temp2_ = (sqrt (par_) * pnorm_) / fnorm_;
  prered_ = (temp1_ * temp1_) + (temp2_ * temp2_) / p5_;
  dirder_ = -((temp1_ * temp1_) + (temp2_ * temp2_));
  ratio_ = zero_;
  if (prered_ != zero_) {
    ratio_ = actred_ / prered_;
  }
  if (ratio_ > p25_) {
    goto _l240;
  }
  if (actred_ >= zero_) {
    temp_ = p5_;
  }
  if (actred_ < zero_) {
    temp_ = p5_ * dirder_ / (dirder_ + p5_ * actred_);
  }
  if (p1_ * fnorm1_ >= fnorm_ || temp_ < p1_) {
    temp_ = p1_;
  }
  delta_ = temp_ * _min (delta_, pnorm_ / p1_);
  par_ = par_ / temp_;
  goto _l260;
  _l240:;
  if (par_ != zero_ && ratio_ < p75_) {
    goto _l250;
  }
  delta_ = pnorm_ / p5_;
  par_ = p5_ * par_;
  _l250:;
  _l260:;
  if (ratio_ < p0001_) {
    goto _l290;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = wa2_[j_ - 1];
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    fvec_[i_ - 1] = wa4_[i_ - 1];
  }
  xnorm_ = _enorm (n_, wa2_);
  fnorm_ = fnorm1_;
  iter_ = iter_ + 1;
  _l290:;
  if (_abs (actred_) <= (*ftol_) && prered_ <= (*ftol_) && p5_ * ratio_ <= one_) {
    (*info_) = 1;
  }
  if (delta_ <= (*xtol_) * xnorm_) {
    (*info_) = 2;
  }
  if (_abs (actred_) <= (*ftol_) && prered_ <= (*ftol_) && p5_ * ratio_ <= one_ && (*info_) == 2) {
    (*info_) = 3;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if ((*nfev_) >= (*maxfev_)) {
    (*info_) = 5;
  }
  if (_abs (actred_) <= epsmch_ && prered_ <= epsmch_ && p5_ * ratio_ <= one_) {
    (*info_) = 6;
  }
  if (delta_ <= epsmch_ * xnorm_) {
    (*info_) = 7;
  }
  if (gnorm_ <= epsmch_) {
    (*info_) = 8;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if (ratio_ < p0001_) {
    goto _l200;
  }
  goto _l30;
  _l300:;
  if (iflag_ < 0) {
    (*info_) = iflag_;
  }
  iflag_ = 0;
  if ((*nprint_) > 0) {
    (void) _fcn (m_, n_, x_, fvec_, fjac_, ldfjac_, &iflag_);
  }
  __calls[11].calls++;
  return 0;
}

int_4 _lmdif1 (real_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ tol_, int_4 
_p_ info_, int_4 _p_ iwa_, real_8 _p_ wa_, int_4 _p_ lwa_)
{
  static int_4 maxfev_, mode_, mp5n_, nfev_, nprint_;
  static real_8 epsfcn_, factor_, ftol_, gtol_, xtol_, zero_;
  int_4 _data_k_11;
#define _data_n_11 2
  static real_8 _data_l_11[_data_n_11] = {
    1.0e2,
    0.0e0
  };
  if (__calls[12].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    factor_ = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    zero_ = _data_l_11[_data_k_11++];
  }
  (*info_) = 0;
  if ((*n_) <= 0 || (*m_) < (*n_) || (*tol_) < zero_ || (*lwa_) < (*m_) * (*n_) + 5 * (*n_) + (*m_)) {
    goto _l10;
  }
  maxfev_ = 200 * ((*n_) + 1);
  ftol_ = (*tol_);
  xtol_ = (*tol_);
  gtol_ = zero_;
  epsfcn_ = zero_;
  mode_ = 1;
  nprint_ = 0;
  mp5n_ = (*m_) + 5 * (*n_);
  (void) _lmdif (_fcn, m_, n_, x_, fvec_, &ftol_, &xtol_, &gtol_, &maxfev_, &epsfcn_, &wa_[0], &mode_, &factor_, 
  &nprint_, info_, &nfev_, &wa_[mp5n_ + 1 - 1], m_, iwa_, &wa_[(*n_) + 1 - 1], &wa_[2 * (*n_) + 1 - 1], &wa_[3 * (*n_) + 
  1 - 1], &wa_[4 * (*n_) + 1 - 1], &wa_[5 * (*n_) + 1 - 1]);
  if ((*info_) == 8) {
    (*info_) = 4;
  }
  _l10:;
  __calls[12].calls++;
  return 0;
}

int_4 _lmdif (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ ftol_, real_8 
_p_ xtol_, real_8 _p_ gtol_, int_4 _p_ maxfev_, real_8 _p_ epsfcn_, real_8 _p_ diag_, int_4 _p_ mode_, real_8 _p_ 
factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, int_4 _p_ ipvt_, 
real_8 _p_ qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 i_, iflag_, iter_, j_, l_;
  static real_8 actred_, delta_, dirder_, epsmch_, fnorm_, fnorm1_, gnorm_, one_, par_, pnorm_, prered_, p1_, p5_, p25_, 
  p75_, p0001_, ratio_, sum_, temp_, temp1_, temp2_, xnorm_, zero_;
  int_4 _data_k_12;
  logical_4 $0_;
  real_8 $1_;
#define _data_n_12 7
  static real_8 _data_l_12[_data_n_12] = {
    1.0e0,
    1.0e-1,
    5.0e-1,
    2.5e-1,
    7.5e-1,
    1.0e-4,
    0.0e0
  };
  if (__calls[13].calls == 0) {
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    one_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    p1_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    p5_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    p25_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    p75_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    p0001_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    zero_ = _data_l_12[_data_k_12++];
  }
  epsmch_ = _dpmpar (&_k1);
  (*info_) = 0;
  iflag_ = 0;
  (*nfev_) = 0;
  if ((*n_) <= 0 || (*m_) < (*n_) || (*ldfjac_) < (*m_) || (*ftol_) < zero_ || (*xtol_) < zero_ || (*gtol_) < zero_ || 
    (*maxfev_) <= 0 || (*factor_) <= zero_) {
    goto _l300;
  }
  if ((*mode_) != 2) {
    goto _l20;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (diag_[j_ - 1] <= zero_) {
      goto _l300;
    }
  }
  _l20:;
  iflag_ = 1;
  (void) _fcn (m_, n_, x_, fvec_, &iflag_);
  (*nfev_) = 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  fnorm_ = _enorm (m_, fvec_);
  par_ = zero_;
  iter_ = 1;
  _l30:;
  iflag_ = 2;
  (void) _fdjac2 (_fcn, m_, n_, x_, fvec_, fjac_, ldfjac_, &iflag_, epsfcn_, wa4_);
  (*nfev_) = (*nfev_) + (*n_);
  if (iflag_ < 0) {
    goto _l300;
  }
  if ((*nprint_) <= 0) {
    goto _l40;
  }
  iflag_ = 0;
  if (_imod (iter_ - 1, (*nprint_)) == 0) {
    (void) _fcn (m_, n_, x_, fvec_, &iflag_);
  }
  if (iflag_ < 0) {
    goto _l300;
  }
  _l40:;
  (void) _qrfac (m_, n_, fjac_, ldfjac_, ($0_ = TRUE, &$0_), ipvt_, n_, wa1_, wa2_, wa3_);
  if (iter_ != 1) {
    goto _l80;
  }
  if ((*mode_) == 2) {
    goto _l60;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = wa2_[j_ - 1];
    if (wa2_[j_ - 1] == zero_) {
      diag_[j_ - 1] = one_;
    }
  }
  _l60:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa3_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  xnorm_ = _enorm (n_, wa3_);
  delta_ = (*factor_) * xnorm_;
  if (delta_ == zero_) {
    delta_ = (*factor_);
  }
  _l80:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    wa4_[i_ - 1] = fvec_[i_ - 1];
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] == zero_) {
      goto _l120;
    }
    sum_ = zero_;
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * wa4_[i_ - 1];
    }
    temp_ = -sum_ / fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      wa4_[i_ - 1] = wa4_[i_ - 1] + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * temp_;
    }
    _l120:;
    fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = wa1_[j_ - 1];
    qtf_[j_ - 1] = wa4_[j_ - 1];
  }
  gnorm_ = zero_;
  if (fnorm_ == zero_) {
    goto _l170;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = ipvt_[j_ - 1];
    if (wa2_[l_ - 1] == zero_) {
      goto _l150;
    }
    sum_ = zero_;
    for (i_ = 1; i_ <= j_; (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * (qtf_[i_ - 1] / fnorm_);
    }
    gnorm_ = _max (gnorm_, _abs (sum_ / wa2_[l_ - 1]));
    _l150:;
  }
  _l170:;
  if (gnorm_ <= (*gtol_)) {
    (*info_) = 4;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if ((*mode_) == 2) {
    goto _l190;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = _max (diag_[j_ - 1], wa2_[j_ - 1]);
  }
  _l190:;
  _l200:;
  (void) _lmpar (n_, fjac_, ldfjac_, ipvt_, diag_, qtf_, &delta_, &par_, wa1_, wa2_, wa3_, wa4_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = -wa1_[j_ - 1];
    wa2_[j_ - 1] = x_[j_ - 1] + wa1_[j_ - 1];
    wa3_[j_ - 1] = diag_[j_ - 1] * wa1_[j_ - 1];
  }
  pnorm_ = _enorm (n_, wa3_);
  if (iter_ == 1) {
    delta_ = _min (delta_, pnorm_);
  }
  iflag_ = 1;
  (void) _fcn (m_, n_, wa2_, wa4_, &iflag_);
  (*nfev_) = (*nfev_) + 1;
  if (iflag_ < 0) {
    goto _l300;
  }
  fnorm1_ = _enorm (m_, wa4_);
  actred_ = -one_;
  if (p1_ * fnorm1_ < fnorm_) {
    actred_ = one_ - ($1_ = (fnorm1_ / fnorm_), $1_ * $1_);
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa3_[j_ - 1] = zero_;
    l_ = ipvt_[j_ - 1];
    temp_ = wa1_[l_ - 1];
    for (i_ = 1; i_ <= j_; (i_)++) {
      wa3_[i_ - 1] = wa3_[i_ - 1] + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * temp_;
    }
  }
  temp1_ = _enorm (n_, wa3_) / fnorm_;
  temp2_ = (sqrt (par_) * pnorm_) / fnorm_;
  prered_ = (temp1_ * temp1_) + (temp2_ * temp2_) / p5_;
  dirder_ = -((temp1_ * temp1_) + (temp2_ * temp2_));
  ratio_ = zero_;
  if (prered_ != zero_) {
    ratio_ = actred_ / prered_;
  }
  if (ratio_ > p25_) {
    goto _l240;
  }
  if (actred_ >= zero_) {
    temp_ = p5_;
  }
  if (actred_ < zero_) {
    temp_ = p5_ * dirder_ / (dirder_ + p5_ * actred_);
  }
  if (p1_ * fnorm1_ >= fnorm_ || temp_ < p1_) {
    temp_ = p1_;
  }
  delta_ = temp_ * _min (delta_, pnorm_ / p1_);
  par_ = par_ / temp_;
  goto _l260;
  _l240:;
  if (par_ != zero_ && ratio_ < p75_) {
    goto _l250;
  }
  delta_ = pnorm_ / p5_;
  par_ = p5_ * par_;
  _l250:;
  _l260:;
  if (ratio_ < p0001_) {
    goto _l290;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = wa2_[j_ - 1];
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    fvec_[i_ - 1] = wa4_[i_ - 1];
  }
  xnorm_ = _enorm (n_, wa2_);
  fnorm_ = fnorm1_;
  iter_ = iter_ + 1;
  _l290:;
  if (_abs (actred_) <= (*ftol_) && prered_ <= (*ftol_) && p5_ * ratio_ <= one_) {
    (*info_) = 1;
  }
  if (delta_ <= (*xtol_) * xnorm_) {
    (*info_) = 2;
  }
  if (_abs (actred_) <= (*ftol_) && prered_ <= (*ftol_) && p5_ * ratio_ <= one_ && (*info_) == 2) {
    (*info_) = 3;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if ((*nfev_) >= (*maxfev_)) {
    (*info_) = 5;
  }
  if (_abs (actred_) <= epsmch_ && prered_ <= epsmch_ && p5_ * ratio_ <= one_) {
    (*info_) = 6;
  }
  if (delta_ <= epsmch_ * xnorm_) {
    (*info_) = 7;
  }
  if (gnorm_ <= epsmch_) {
    (*info_) = 8;
  }
  if ((*info_) != 0) {
    goto _l300;
  }
  if (ratio_ < p0001_) {
    goto _l200;
  }
  goto _l30;
  _l300:;
  if (iflag_ < 0) {
    (*info_) = iflag_;
  }
  iflag_ = 0;
  if ((*nprint_) > 0) {
    (void) _fcn (m_, n_, x_, fvec_, &iflag_);
  }
  __calls[13].calls++;
  return 0;
}

int_4 _lmpar (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ ipvt_, real_8 _p_ diag_, real_8 _p_ qtb_, real_8 
_p_ delta_, real_8 _p_ par_, real_8 _p_ x_, real_8 _p_ sdiag_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 i_, iter_, j_, jm1_, jp1_, k_, l_, nsing_;
  static real_8 dxnorm_, dwarf_, fp_, gnorm_, parc_, parl_, paru_, p1_, p001_, sum_, temp_, zero_;
  int_4 _data_k_13, $0_;
#define _data_n_13 3
  static real_8 _data_l_13[_data_n_13] = {
    1.0e-1,
    1.0e-3,
    0.0e0
  };
  if (__calls[14].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    p1_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    p001_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    zero_ = _data_l_13[_data_k_13++];
  }
  dwarf_ = _dpmpar (($0_ = 2, &$0_));
  nsing_ = (*n_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = qtb_[j_ - 1];
    if (r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))] == zero_ && nsing_ == (*n_)) {
      nsing_ = j_ - 1;
    }
    if (nsing_ < (*n_)) {
      wa1_[j_ - 1] = zero_;
    }
  }
  if (nsing_ < 1) {
    goto _l50;
  }
  for (k_ = 1; k_ <= nsing_; (k_)++) {
    j_ = nsing_ - k_ + 1;
    wa1_[j_ - 1] = wa1_[j_ - 1] / r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))];
    temp_ = wa1_[j_ - 1];
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l30;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      wa1_[i_ - 1] = wa1_[i_ - 1] - r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] * temp_;
    }
    _l30:;
  }
  _l50:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = ipvt_[j_ - 1];
    x_[l_ - 1] = wa1_[j_ - 1];
  }
  iter_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  dxnorm_ = _enorm (n_, wa2_);
  fp_ = dxnorm_ - (*delta_);
  if (fp_ <= p1_ * (*delta_)) {
    goto _l220;
  }
  parl_ = zero_;
  if (nsing_ < (*n_)) {
    goto _l120;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = ipvt_[j_ - 1];
    wa1_[j_ - 1] = diag_[l_ - 1] * (wa2_[l_ - 1] / dxnorm_);
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    sum_ = zero_;
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l100;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      sum_ = sum_ + r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] * wa1_[i_ - 1];
    }
    _l100:;
    wa1_[j_ - 1] = (wa1_[j_ - 1] - sum_) / r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))];
  }
  temp_ = _enorm (n_, wa1_);
  parl_ = ((fp_ / (*delta_)) / temp_) / temp_;
  _l120:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    sum_ = zero_;
    for (i_ = 1; i_ <= j_; (i_)++) {
      sum_ = sum_ + r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] * qtb_[i_ - 1];
    }
    l_ = ipvt_[j_ - 1];
    wa1_[j_ - 1] = sum_ / diag_[l_ - 1];
  }
  gnorm_ = _enorm (n_, wa1_);
  paru_ = gnorm_ / (*delta_);
  if (paru_ == zero_) {
    paru_ = dwarf_ / _min ((*delta_), p1_);
  }
  (*par_) = _max ((*par_), parl_);
  (*par_) = _min ((*par_), paru_);
  if ((*par_) == zero_) {
    (*par_) = gnorm_ / dxnorm_;
  }
  _l150:;
  iter_ = iter_ + 1;
  if ((*par_) == zero_) {
    (*par_) = _max (dwarf_, p001_ * paru_);
  }
  temp_ = sqrt ((*par_));
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = temp_ * diag_[j_ - 1];
  }
  (void) _qrsolv (n_, r_, ldr_, ipvt_, wa1_, qtb_, x_, sdiag_, wa2_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  dxnorm_ = _enorm (n_, wa2_);
  temp_ = fp_;
  fp_ = dxnorm_ - (*delta_);
  if (_abs (fp_) <= p1_ * (*delta_) || parl_ == zero_ && fp_ <= temp_ && temp_ < zero_ || iter_ == 10) {
    goto _l220;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = ipvt_[j_ - 1];
    wa1_[j_ - 1] = diag_[l_ - 1] * (wa2_[l_ - 1] / dxnorm_);
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = wa1_[j_ - 1] / sdiag_[j_ - 1];
    temp_ = wa1_[j_ - 1];
    jp1_ = j_ + 1;
    if ((*n_) < jp1_) {
      goto _l200;
    }
    for (i_ = jp1_; i_ <= (*n_); (i_)++) {
      wa1_[i_ - 1] = wa1_[i_ - 1] - r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] * temp_;
    }
    _l200:;
  }
  temp_ = _enorm (n_, wa1_);
  parc_ = ((fp_ / (*delta_)) / temp_) / temp_;
  if (fp_ > zero_) {
    parl_ = _max (parl_, (*par_));
  }
  if (fp_ < zero_) {
    paru_ = _min (paru_, (*par_));
  }
  (*par_) = _max (parl_, (*par_) + parc_);
  goto _l150;
  _l220:;
  if (iter_ == 0) {
    (*par_) = zero_;
  }
  __calls[14].calls++;
  return 0;
}

int_4 _lmstr1 (real_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 
_p_ ldfjac_, real_8 _p_ tol_, int_4 _p_ info_, int_4 _p_ ipvt_, real_8 _p_ wa_, int_4 _p_ lwa_)
{
  static int_4 maxfev_, mode_, nfev_, njev_, nprint_;
  static real_8 factor_, ftol_, gtol_, xtol_, zero_;
  int_4 _data_k_14;
#define _data_n_14 2
  static real_8 _data_l_14[_data_n_14] = {
    1.0e2,
    0.0e0
  };
  if (__calls[15].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    factor_ = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    zero_ = _data_l_14[_data_k_14++];
  }
  (*info_) = 0;
  if ((*n_) <= 0 || (*m_) < (*n_) || (*ldfjac_) < (*n_) || (*tol_) < zero_ || (*lwa_) < 5 * (*n_) + (*m_)) {
    goto _l10;
  }
  maxfev_ = 100 * ((*n_) + 1);
  ftol_ = (*tol_);
  xtol_ = (*tol_);
  gtol_ = zero_;
  mode_ = 1;
  nprint_ = 0;
  (void) _lmstr (_fcn, m_, n_, x_, fvec_, fjac_, ldfjac_, &ftol_, &xtol_, &gtol_, &maxfev_, &wa_[0], &mode_, &factor_, 
  &nprint_, info_, &nfev_, &njev_, ipvt_, &wa_[(*n_) + 1 - 1], &wa_[2 * (*n_) + 1 - 1], &wa_[3 * (*n_) + 1 - 1], &wa_[4 * 
  (*n_) + 1 - 1], &wa_[5 * (*n_) + 1 - 1]);
  if ((*info_) == 8) {
    (*info_) = 4;
  }
  _l10:;
  __calls[15].calls++;
  return 0;
}

int_4 _lmstr (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ 
ldfjac_, real_8 _p_ ftol_, real_8 _p_ xtol_, real_8 _p_ gtol_, int_4 _p_ maxfev_, real_8 _p_ diag_, int_4 _p_ mode_, 
real_8 _p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, int_4 _p_ njev_, int_4 _p_ ipvt_, real_8 _p_ 
qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 i_, iflag_, iter_, j_, l_;
  static logical_4 sing_;
  static real_8 actred_, delta_, dirder_, epsmch_, fnorm_, fnorm1_, gnorm_, one_, par_, pnorm_, prered_, p1_, p5_, p25_, 
  p75_, p0001_, ratio_, sum_, temp_, temp1_, temp2_, xnorm_, zero_;
  int_4 _data_k_15;
  logical_4 $0_;
  real_8 $1_;
#define _data_n_15 7
  static real_8 _data_l_15[_data_n_15] = {
    1.0e0,
    1.0e-1,
    5.0e-1,
    2.5e-1,
    7.5e-1,
    1.0e-4,
    0.0e0
  };
  if (__calls[16].calls == 0) {
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    one_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    p1_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    p5_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    p25_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    p75_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    p0001_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    zero_ = _data_l_15[_data_k_15++];
  }
  epsmch_ = _dpmpar (&_k1);
  (*info_) = 0;
  iflag_ = 0;
  (*nfev_) = 0;
  (*njev_) = 0;
  if ((*n_) <= 0 || (*m_) < (*n_) || (*ldfjac_) < (*n_) || (*ftol_) < zero_ || (*xtol_) < zero_ || (*gtol_) < zero_ || 
    (*maxfev_) <= 0 || (*factor_) <= zero_) {
    goto _l340;
  }
  if ((*mode_) != 2) {
    goto _l20;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (diag_[j_ - 1] <= zero_) {
      goto _l340;
    }
  }
  _l20:;
  iflag_ = 1;
  (void) _fcn (m_, n_, x_, fvec_, wa3_, &iflag_);
  (*nfev_) = 1;
  if (iflag_ < 0) {
    goto _l340;
  }
  fnorm_ = _enorm (m_, fvec_);
  par_ = zero_;
  iter_ = 1;
  _l30:;
  if ((*nprint_) <= 0) {
    goto _l40;
  }
  iflag_ = 0;
  if (_imod (iter_ - 1, (*nprint_)) == 0) {
    (void) _fcn (m_, n_, x_, fvec_, wa3_, &iflag_);
  }
  if (iflag_ < 0) {
    goto _l340;
  }
  _l40:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    qtf_[j_ - 1] = zero_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = zero_;
    }
  }
  iflag_ = 2;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    (void) _fcn (m_, n_, x_, fvec_, wa3_, &iflag_);
    if (iflag_ < 0) {
      goto _l340;
    }
    temp_ = fvec_[i_ - 1];
    (void) _rwupdt (n_, fjac_, ldfjac_, wa3_, qtf_, &temp_, wa1_, wa2_);
    iflag_ = iflag_ + 1;
  }
  (*njev_) = (*njev_) + 1;
  sing_ = FALSE;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] == zero_) {
      sing_ = TRUE;
    }
    ipvt_[j_ - 1] = j_;
    wa2_[j_ - 1] = _enorm (&j_, &fjac_[0 + ((*ldfjac_)) * ((j_ - 1))]);
  }
  if (! (sing_)) {
    goto _l130;
  }
  (void) _qrfac (n_, n_, fjac_, ldfjac_, ($0_ = TRUE, &$0_), ipvt_, n_, wa1_, wa2_, wa3_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] == zero_) {
      goto _l110;
    }
    sum_ = zero_;
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * qtf_[i_ - 1];
    }
    temp_ = -sum_ / fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      qtf_[i_ - 1] = qtf_[i_ - 1] + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * temp_;
    }
    _l110:;
    fjac_[j_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = wa1_[j_ - 1];
  }
  _l130:;
  if (iter_ != 1) {
    goto _l170;
  }
  if ((*mode_) == 2) {
    goto _l150;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = wa2_[j_ - 1];
    if (wa2_[j_ - 1] == zero_) {
      diag_[j_ - 1] = one_;
    }
  }
  _l150:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa3_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  xnorm_ = _enorm (n_, wa3_);
  delta_ = (*factor_) * xnorm_;
  if (delta_ == zero_) {
    delta_ = (*factor_);
  }
  _l170:;
  gnorm_ = zero_;
  if (fnorm_ == zero_) {
    goto _l210;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = ipvt_[j_ - 1];
    if (wa2_[l_ - 1] == zero_) {
      goto _l190;
    }
    sum_ = zero_;
    for (i_ = 1; i_ <= j_; (i_)++) {
      sum_ = sum_ + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * (qtf_[i_ - 1] / fnorm_);
    }
    gnorm_ = _max (gnorm_, _abs (sum_ / wa2_[l_ - 1]));
    _l190:;
  }
  _l210:;
  if (gnorm_ <= (*gtol_)) {
    (*info_) = 4;
  }
  if ((*info_) != 0) {
    goto _l340;
  }
  if ((*mode_) == 2) {
    goto _l230;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    diag_[j_ - 1] = _max (diag_[j_ - 1], wa2_[j_ - 1]);
  }
  _l230:;
  _l240:;
  (void) _lmpar (n_, fjac_, ldfjac_, ipvt_, diag_, qtf_, &delta_, &par_, wa1_, wa2_, wa3_, wa4_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = -wa1_[j_ - 1];
    wa2_[j_ - 1] = x_[j_ - 1] + wa1_[j_ - 1];
    wa3_[j_ - 1] = diag_[j_ - 1] * wa1_[j_ - 1];
  }
  pnorm_ = _enorm (n_, wa3_);
  if (iter_ == 1) {
    delta_ = _min (delta_, pnorm_);
  }
  iflag_ = 1;
  (void) _fcn (m_, n_, wa2_, wa4_, wa3_, &iflag_);
  (*nfev_) = (*nfev_) + 1;
  if (iflag_ < 0) {
    goto _l340;
  }
  fnorm1_ = _enorm (m_, wa4_);
  actred_ = -one_;
  if (p1_ * fnorm1_ < fnorm_) {
    actred_ = one_ - ($1_ = (fnorm1_ / fnorm_), $1_ * $1_);
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa3_[j_ - 1] = zero_;
    l_ = ipvt_[j_ - 1];
    temp_ = wa1_[l_ - 1];
    for (i_ = 1; i_ <= j_; (i_)++) {
      wa3_[i_ - 1] = wa3_[i_ - 1] + fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] * temp_;
    }
  }
  temp1_ = _enorm (n_, wa3_) / fnorm_;
  temp2_ = (sqrt (par_) * pnorm_) / fnorm_;
  prered_ = (temp1_ * temp1_) + (temp2_ * temp2_) / p5_;
  dirder_ = -((temp1_ * temp1_) + (temp2_ * temp2_));
  ratio_ = zero_;
  if (prered_ != zero_) {
    ratio_ = actred_ / prered_;
  }
  if (ratio_ > p25_) {
    goto _l280;
  }
  if (actred_ >= zero_) {
    temp_ = p5_;
  }
  if (actred_ < zero_) {
    temp_ = p5_ * dirder_ / (dirder_ + p5_ * actred_);
  }
  if (p1_ * fnorm1_ >= fnorm_ || temp_ < p1_) {
    temp_ = p1_;
  }
  delta_ = temp_ * _min (delta_, pnorm_ / p1_);
  par_ = par_ / temp_;
  goto _l300;
  _l280:;
  if (par_ != zero_ && ratio_ < p75_) {
    goto _l290;
  }
  delta_ = pnorm_ / p5_;
  par_ = p5_ * par_;
  _l290:;
  _l300:;
  if (ratio_ < p0001_) {
    goto _l330;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = wa2_[j_ - 1];
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    fvec_[i_ - 1] = wa4_[i_ - 1];
  }
  xnorm_ = _enorm (n_, wa2_);
  fnorm_ = fnorm1_;
  iter_ = iter_ + 1;
  _l330:;
  if (_abs (actred_) <= (*ftol_) && prered_ <= (*ftol_) && p5_ * ratio_ <= one_) {
    (*info_) = 1;
  }
  if (delta_ <= (*xtol_) * xnorm_) {
    (*info_) = 2;
  }
  if (_abs (actred_) <= (*ftol_) && prered_ <= (*ftol_) && p5_ * ratio_ <= one_ && (*info_) == 2) {
    (*info_) = 3;
  }
  if ((*info_) != 0) {
    goto _l340;
  }
  if ((*nfev_) >= (*maxfev_)) {
    (*info_) = 5;
  }
  if (_abs (actred_) <= epsmch_ && prered_ <= epsmch_ && p5_ * ratio_ <= one_) {
    (*info_) = 6;
  }
  if (delta_ <= epsmch_ * xnorm_) {
    (*info_) = 7;
  }
  if (gnorm_ <= epsmch_) {
    (*info_) = 8;
  }
  if ((*info_) != 0) {
    goto _l340;
  }
  if (ratio_ < p0001_) {
    goto _l240;
  }
  goto _l30;
  _l340:;
  if (iflag_ < 0) {
    (*info_) = iflag_;
  }
  iflag_ = 0;
  if ((*nprint_) > 0) {
    (void) _fcn (m_, n_, x_, fvec_, wa3_, &iflag_);
  }
  __calls[16].calls++;
  return 0;
}

int_4 _qform (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ wa_)
{
  static int_4 i_, j_, jm1_, k_, l_, minmn_, np1_;
  static real_8 one_, sum_, temp_, zero_;
  int_4 _data_k_16;
#define _data_n_16 2
  static real_8 _data_l_16[_data_n_16] = {
    1.0e0,
    0.0e0
  };
  if (__calls[17].calls == 0) {
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    one_ = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    zero_ = _data_l_16[_data_k_16++];
  }
  minmn_ = _min ((*m_), (*n_));
  if (minmn_ < 2) {
    goto _l30;
  }
  for (j_ = 2; j_ <= minmn_; (j_)++) {
    jm1_ = j_ - 1;
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      q_[i_ - 1 + ((*ldq_)) * ((j_ - 1))] = zero_;
    }
  }
  _l30:;
  np1_ = (*n_) + 1;
  if ((*m_) < np1_) {
    goto _l60;
  }
  for (j_ = np1_; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      q_[i_ - 1 + ((*ldq_)) * ((j_ - 1))] = zero_;
    }
    q_[j_ - 1 + ((*ldq_)) * ((j_ - 1))] = one_;
  }
  _l60:;
  for (l_ = 1; l_ <= minmn_; (l_)++) {
    k_ = minmn_ - l_ + 1;
    for (i_ = k_; i_ <= (*m_); (i_)++) {
      wa_[i_ - 1] = q_[i_ - 1 + ((*ldq_)) * ((k_ - 1))];
      q_[i_ - 1 + ((*ldq_)) * ((k_ - 1))] = zero_;
    }
    q_[k_ - 1 + ((*ldq_)) * ((k_ - 1))] = one_;
    if (wa_[k_ - 1] == zero_) {
      goto _l110;
    }
    for (j_ = k_; j_ <= (*m_); (j_)++) {
      sum_ = zero_;
      for (i_ = k_; i_ <= (*m_); (i_)++) {
        sum_ = sum_ + q_[i_ - 1 + ((*ldq_)) * ((j_ - 1))] * wa_[i_ - 1];
      }
      temp_ = sum_ / wa_[k_ - 1];
      for (i_ = k_; i_ <= (*m_); (i_)++) {
        q_[i_ - 1 + ((*ldq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*ldq_)) * ((j_ - 1))] - temp_ * wa_[i_ - 1];
      }
    }
    _l110:;
  }
  __calls[17].calls++;
  return 0;
}

int_4 _qrfac (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, logical_4 _p_ pivot_, int_4 _p_ ipvt_, int_4 
_p_ lipvt_, real_8 _p_ rdiag_, real_8 _p_ acnorm_, real_8 _p_ wa_)
{
  static int_4 i_, j_, jp1_, k_, kmax_, minmn_;
  static real_8 ajnorm_, epsmch_, one_, p05_, sum_, temp_, zero_;
  int_4 _data_k_17, $0_, $2_;
  real_8 $1_;
#define _data_n_17 3
  static real_8 _data_l_17[_data_n_17] = {
    1.0e0,
    5.0e-2,
    0.0e0
  };
  if (__calls[18].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    one_ = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    p05_ = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    zero_ = _data_l_17[_data_k_17++];
  }
  epsmch_ = _dpmpar (&_k1);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    acnorm_[j_ - 1] = _enorm (m_, &a_[0 + ((*lda_)) * ((j_ - 1))]);
    rdiag_[j_ - 1] = acnorm_[j_ - 1];
    wa_[j_ - 1] = rdiag_[j_ - 1];
    if ((*pivot_)) {
      ipvt_[j_ - 1] = j_;
    }
  }
  minmn_ = _min ((*m_), (*n_));
  for (j_ = 1; j_ <= minmn_; (j_)++) {
    if (! ((*pivot_))) {
      goto _l40;
    }
    kmax_ = j_;
    for (k_ = j_; k_ <= (*n_); (k_)++) {
      if (rdiag_[k_ - 1] > rdiag_[kmax_ - 1]) {
        kmax_ = k_;
      }
    }
    if (kmax_ == j_) {
      goto _l40;
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      temp_ = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((kmax_ - 1))];
      a_[i_ - 1 + ((*lda_)) * ((kmax_ - 1))] = temp_;
    }
    rdiag_[kmax_ - 1] = rdiag_[j_ - 1];
    wa_[kmax_ - 1] = wa_[j_ - 1];
    k_ = ipvt_[j_ - 1];
    ipvt_[j_ - 1] = ipvt_[kmax_ - 1];
    ipvt_[kmax_ - 1] = k_;
    _l40:;
    ajnorm_ = _enorm (($0_ = (*m_) - j_ + 1, &$0_), &a_[j_ - 1 + ((*lda_)) * ((j_ - 1))]);
    if (ajnorm_ == zero_) {
      goto _l100;
    }
    if (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] < zero_) {
      ajnorm_ = -ajnorm_;
    }
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] / ajnorm_;
    }
    a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] + one_;
    jp1_ = j_ + 1;
    if ((*n_) < jp1_) {
      goto _l100;
    }
    for (k_ = jp1_; k_ <= (*n_); (k_)++) {
      sum_ = zero_;
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        sum_ = sum_ + a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] * a_[i_ - 1 + ((*lda_)) * ((k_ - 1))];
      }
      temp_ = sum_ / a_[j_ - 1 + ((*lda_)) * ((j_ - 1))];
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        a_[i_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[i_ - 1 + ((*lda_)) * ((k_ - 1))] - temp_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))]
        ;
      }
      if (! ((*pivot_)) || rdiag_[k_ - 1] == zero_) {
        goto _l80;
      }
      temp_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] / rdiag_[k_ - 1];
      rdiag_[k_ - 1] = rdiag_[k_ - 1] * sqrt (_max (zero_, one_ - (temp_ * temp_)));
      if (p05_ * ($1_ = (rdiag_[k_ - 1] / wa_[k_ - 1]), $1_ * $1_) > epsmch_) {
        goto _l80;
      }
      rdiag_[k_ - 1] = _enorm (($2_ = (*m_) - j_, &$2_), &a_[jp1_ - 1 + ((*lda_)) * ((k_ - 1))]);
      wa_[k_ - 1] = rdiag_[k_ - 1];
      _l80:;
    }
    _l100:;
    rdiag_[j_ - 1] = -ajnorm_;
  }
  __calls[18].calls++;
  return 0;
}

int_4 _qrsolv (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ ipvt_, real_8 _p_ diag_, real_8 _p_ qtb_, real_8 
_p_ x_, real_8 _p_ sdiag_, real_8 _p_ wa_)
{
  static int_4 i_, j_, jp1_, k_, kp1_, l_, nsing_;
  static real_8 cos_, cotan_, p5_, p25_, qtbpj_, sin_, sum_, tan_, temp_, zero_;
  int_4 _data_k_18;
#define _data_n_18 3
  static real_8 _data_l_18[_data_n_18] = {
    5.0e-1,
    2.5e-1,
    0.0e0
  };
  if (__calls[19].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    p5_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    p25_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    zero_ = _data_l_18[_data_k_18++];
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = r_[j_ - 1 + ((*ldr_)) * ((i_ - 1))];
    }
    x_[j_ - 1] = r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))];
    wa_[j_ - 1] = qtb_[j_ - 1];
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = ipvt_[j_ - 1];
    if (diag_[l_ - 1] == zero_) {
      goto _l90;
    }
    for (k_ = j_; k_ <= (*n_); (k_)++) {
      sdiag_[k_ - 1] = zero_;
    }
    sdiag_[j_ - 1] = diag_[l_ - 1];
    qtbpj_ = zero_;
    for (k_ = j_; k_ <= (*n_); (k_)++) {
      if (sdiag_[k_ - 1] == zero_) {
        goto _l70;
      }
      if (_abs (r_[k_ - 1 + ((*ldr_)) * ((k_ - 1))]) >= _abs (sdiag_[k_ - 1])) {
        goto _l40;
      }
      cotan_ = r_[k_ - 1 + ((*ldr_)) * ((k_ - 1))] / sdiag_[k_ - 1];
      sin_ = p5_ / sqrt (p25_ + p25_ * (cotan_ * cotan_));
      cos_ = sin_ * cotan_;
      goto _l50;
      _l40:;
      tan_ = sdiag_[k_ - 1] / r_[k_ - 1 + ((*ldr_)) * ((k_ - 1))];
      cos_ = p5_ / sqrt (p25_ + p25_ * (tan_ * tan_));
      sin_ = cos_ * tan_;
      _l50:;
      r_[k_ - 1 + ((*ldr_)) * ((k_ - 1))] = cos_ * r_[k_ - 1 + ((*ldr_)) * ((k_ - 1))] + sin_ * sdiag_[k_ - 1];
      temp_ = cos_ * wa_[k_ - 1] + sin_ * qtbpj_;
      qtbpj_ = -sin_ * wa_[k_ - 1] + cos_ * qtbpj_;
      wa_[k_ - 1] = temp_;
      kp1_ = k_ + 1;
      if ((*n_) < kp1_) {
        goto _l70;
      }
      for (i_ = kp1_; i_ <= (*n_); (i_)++) {
        temp_ = cos_ * r_[i_ - 1 + ((*ldr_)) * ((k_ - 1))] + sin_ * sdiag_[i_ - 1];
        sdiag_[i_ - 1] = -sin_ * r_[i_ - 1 + ((*ldr_)) * ((k_ - 1))] + cos_ * sdiag_[i_ - 1];
        r_[i_ - 1 + ((*ldr_)) * ((k_ - 1))] = temp_;
      }
      _l70:;
    }
    _l90:;
    sdiag_[j_ - 1] = r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))];
    r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))] = x_[j_ - 1];
  }
  nsing_ = (*n_);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (sdiag_[j_ - 1] == zero_ && nsing_ == (*n_)) {
      nsing_ = j_ - 1;
    }
    if (nsing_ < (*n_)) {
      wa_[j_ - 1] = zero_;
    }
  }
  if (nsing_ < 1) {
    goto _l150;
  }
  for (k_ = 1; k_ <= nsing_; (k_)++) {
    j_ = nsing_ - k_ + 1;
    sum_ = zero_;
    jp1_ = j_ + 1;
    if (nsing_ < jp1_) {
      goto _l130;
    }
    for (i_ = jp1_; i_ <= nsing_; (i_)++) {
      sum_ = sum_ + r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] * wa_[i_ - 1];
    }
    _l130:;
    wa_[j_ - 1] = (wa_[j_ - 1] - sum_) / sdiag_[j_ - 1];
  }
  _l150:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    l_ = ipvt_[j_ - 1];
    x_[l_ - 1] = wa_[j_ - 1];
  }
  __calls[19].calls++;
  return 0;
}

int_4 _r1mpyq (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ v_, real_8 _p_ w_)
{
  static int_4 i_, j_, nmj_, nm1_;
  static real_8 cos_, one_, sin_, temp_;
  int_4 _data_k_19;
#define _data_n_19 1
  static real_8 _data_l_19[_data_n_19] = {
    1.0e0
  };
  if (__calls[20].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    one_ = _data_l_19[_data_k_19++];
  }
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l50;
  }
  for (nmj_ = 1; nmj_ <= nm1_; (nmj_)++) {
    j_ = (*n_) - nmj_;
    if (_abs (v_[j_ - 1]) > one_) {
      cos_ = one_ / v_[j_ - 1];
    }
    if (_abs (v_[j_ - 1]) > one_) {
      sin_ = sqrt (one_ - (cos_ * cos_));
    }
    if (_abs (v_[j_ - 1]) <= one_) {
      sin_ = v_[j_ - 1];
    }
    if (_abs (v_[j_ - 1]) <= one_) {
      cos_ = sqrt (one_ - (sin_ * sin_));
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      temp_ = cos_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] - sin_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))];
      a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] = sin_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + cos_ * a_[i_ - 1 + ((*lda_)) * 
      (((*n_) - 1))];
      a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
    }
  }
  for (j_ = 1; j_ <= nm1_; (j_)++) {
    if (_abs (w_[j_ - 1]) > one_) {
      cos_ = one_ / w_[j_ - 1];
    }
    if (_abs (w_[j_ - 1]) > one_) {
      sin_ = sqrt (one_ - (cos_ * cos_));
    }
    if (_abs (w_[j_ - 1]) <= one_) {
      sin_ = w_[j_ - 1];
    }
    if (_abs (w_[j_ - 1]) <= one_) {
      cos_ = sqrt (one_ - (sin_ * sin_));
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      temp_ = cos_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + sin_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))];
      a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] = -sin_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + cos_ * a_[i_ - 1 + ((*lda_)) * 
      (((*n_) - 1))];
      a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
    }
  }
  _l50:;
  __calls[20].calls++;
  return 0;
}

int_4 _r1updt (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ s_, int_4 _p_ ls_, real_8 _p_ u_, real_8 _p_ v_, real_8 _p_ w_, 
logical_4 _p_ sing_)
{
  static int_4 i_, j_, jj_, l_, nmj_, nm1_;
  static real_8 cos_, cotan_, giant_, one_, p5_, p25_, sin_, tan_, tau_, temp_, zero_;
  int_4 _data_k_20, $0_;
#define _data_n_20 4
  static real_8 _data_l_20[_data_n_20] = {
    1.0e0,
    5.0e-1,
    2.5e-1,
    0.0e0
  };
  if (__calls[21].calls == 0) {
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    one_ = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    p5_ = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    p25_ = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    zero_ = _data_l_20[_data_k_20++];
  }
  giant_ = _dpmpar (($0_ = 3, &$0_));
  jj_ = ((*n_) * (2 * (*m_) - (*n_) + 1)) / 2 - ((*m_) - (*n_));
  l_ = jj_;
  for (i_ = (*n_); i_ <= (*m_); (i_)++) {
    w_[i_ - 1] = s_[l_ - 1];
    l_ = l_ + 1;
  }
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l70;
  }
  for (nmj_ = 1; nmj_ <= nm1_; (nmj_)++) {
    j_ = (*n_) - nmj_;
    jj_ = jj_ - ((*m_) - j_ + 1);
    w_[j_ - 1] = zero_;
    if (v_[j_ - 1] == zero_) {
      goto _l50;
    }
    if (_abs (v_[(*n_) - 1]) >= _abs (v_[j_ - 1])) {
      goto _l20;
    }
    cotan_ = v_[(*n_) - 1] / v_[j_ - 1];
    sin_ = p5_ / sqrt (p25_ + p25_ * (cotan_ * cotan_));
    cos_ = sin_ * cotan_;
    tau_ = one_;
    if (_abs (cos_) * giant_ > one_) {
      tau_ = one_ / cos_;
    }
    goto _l30;
    _l20:;
    tan_ = v_[j_ - 1] / v_[(*n_) - 1];
    cos_ = p5_ / sqrt (p25_ + p25_ * (tan_ * tan_));
    sin_ = cos_ * tan_;
    tau_ = sin_;
    _l30:;
    v_[(*n_) - 1] = sin_ * v_[j_ - 1] + cos_ * v_[(*n_) - 1];
    v_[j_ - 1] = tau_;
    l_ = jj_;
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      temp_ = cos_ * s_[l_ - 1] - sin_ * w_[i_ - 1];
      w_[i_ - 1] = sin_ * s_[l_ - 1] + cos_ * w_[i_ - 1];
      s_[l_ - 1] = temp_;
      l_ = l_ + 1;
    }
    _l50:;
  }
  _l70:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    w_[i_ - 1] = w_[i_ - 1] + v_[(*n_) - 1] * u_[i_ - 1];
  }
  (*sing_) = FALSE;
  if (nm1_ < 1) {
    goto _l140;
  }
  for (j_ = 1; j_ <= nm1_; (j_)++) {
    if (w_[j_ - 1] == zero_) {
      goto _l120;
    }
    if (_abs (s_[jj_ - 1]) >= _abs (w_[j_ - 1])) {
      goto _l90;
    }
    cotan_ = s_[jj_ - 1] / w_[j_ - 1];
    sin_ = p5_ / sqrt (p25_ + p25_ * (cotan_ * cotan_));
    cos_ = sin_ * cotan_;
    tau_ = one_;
    if (_abs (cos_) * giant_ > one_) {
      tau_ = one_ / cos_;
    }
    goto _l100;
    _l90:;
    tan_ = w_[j_ - 1] / s_[jj_ - 1];
    cos_ = p5_ / sqrt (p25_ + p25_ * (tan_ * tan_));
    sin_ = cos_ * tan_;
    tau_ = sin_;
    _l100:;
    l_ = jj_;
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      temp_ = cos_ * s_[l_ - 1] + sin_ * w_[i_ - 1];
      w_[i_ - 1] = -sin_ * s_[l_ - 1] + cos_ * w_[i_ - 1];
      s_[l_ - 1] = temp_;
      l_ = l_ + 1;
    }
    w_[j_ - 1] = tau_;
    _l120:;
    if (s_[jj_ - 1] == zero_) {
      (*sing_) = TRUE;
    }
    jj_ = jj_ + ((*m_) - j_ + 1);
  }
  _l140:;
  l_ = jj_;
  for (i_ = (*n_); i_ <= (*m_); (i_)++) {
    s_[l_ - 1] = w_[i_ - 1];
    l_ = l_ + 1;
  }
  if (s_[jj_ - 1] == zero_) {
    (*sing_) = TRUE;
  }
  __calls[21].calls++;
  return 0;
}

int_4 _rwupdt (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, real_8 _p_ w_, real_8 _p_ b_, real_8 _p_ alpha_, real_8 _p_ 
cost_, real_8 _p_ sint_)
{
  static int_4 i_, j_, jm1_;
  static real_8 cotant_, one_, p5_, p25_, rowj_, tant_, temp_, zero_;
  int_4 _data_k_21;
#define _data_n_21 4
  static real_8 _data_l_21[_data_n_21] = {
    1.0e0,
    5.0e-1,
    2.5e-1,
    0.0e0
  };
  if (__calls[22].calls == 0) {
    _data_k_21 = 0;
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    one_ = _data_l_21[_data_k_21++];
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    p5_ = _data_l_21[_data_k_21++];
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    p25_ = _data_l_21[_data_k_21++];
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    zero_ = _data_l_21[_data_k_21++];
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    rowj_ = w_[j_ - 1];
    jm1_ = j_ - 1;
    if (jm1_ < 1) {
      goto _l20;
    }
    for (i_ = 1; i_ <= jm1_; (i_)++) {
      temp_ = cost_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + sint_[i_ - 1] * rowj_;
      rowj_ = -sint_[i_ - 1] * r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] + cost_[i_ - 1] * rowj_;
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = temp_;
    }
    _l20:;
    cost_[j_ - 1] = one_;
    sint_[j_ - 1] = zero_;
    if (rowj_ == zero_) {
      goto _l50;
    }
    if (_abs (r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))]) >= _abs (rowj_)) {
      goto _l30;
    }
    cotant_ = r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))] / rowj_;
    sint_[j_ - 1] = p5_ / sqrt (p25_ + p25_ * (cotant_ * cotant_));
    cost_[j_ - 1] = sint_[j_ - 1] * cotant_;
    goto _l40;
    _l30:;
    tant_ = rowj_ / r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))];
    cost_[j_ - 1] = p5_ / sqrt (p25_ + p25_ * (tant_ * tant_));
    sint_[j_ - 1] = cost_[j_ - 1] * tant_;
    _l40:;
    r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))] = cost_[j_ - 1] * r_[j_ - 1 + ((*ldr_)) * ((j_ - 1))] + sint_[j_ - 1] * rowj_;
    temp_ = cost_[j_ - 1] * b_[j_ - 1] + sint_[j_ - 1] * (*alpha_);
    (*alpha_) = -sint_[j_ - 1] * b_[j_ - 1] + cost_[j_ - 1] * (*alpha_);
    b_[j_ - 1] = temp_;
    _l50:;
  }
  __calls[22].calls++;
  return 0;
}

