//! @file mathlib-odepack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 84 subprograms from ODEPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// ADJLR  DCFODE DIPREP DLSODK DPREP  DROOTS DSPIOM DSTODE IUMACH NNFC
// CDRV   DDECBT DIPREP DLSODP DPREPI DSETPK DSRCAR DSTODI IXSAV  NNSC
// CNTNZU DEWSET DLHIN  DLSOIB DPREPJ DSLSBT DSRCKR DSTODP JGROUP NNTC
// DAIGBT DFNORM DLSODA DMNORM DPREPJ DSOLBT DSRCMA DSTOKA MD     NROC
// DAINVG DHEFA  DLSODA DORTHO DPRJA  DSOLPK DSRCMS DUMACH MDI    NSFC
// DAINVG DHELS  DLSODE DPCG   DPRJIS DSOLSS DSRCOM DUMSUM MDM    ODRV
// DATP   DHEQR  DLSODE DPCGS  DPRJS  DSOLSY DSRCPK DUSOL  MDP    SRO
// DATV   DHESL  DLSODI DPJIBT DRCHEK DSPIGM DSTODA DVNORM MDU    XERRWD
// DBNORM DINTDY DLSODI DPKSET

// ODEPACK - A Systematized Collection of ODE Solvers
// 
// Source: netlib.org/odepack
// 
// Original author is Alan C. Hindmarsh.
// 
// Work performed under the auspices of the U.S. Department of Energy
// by the Lawrence Livermore National Laboratory under contract
// No. W-7405-Eng-48, and supported (formerly) by the DOE Office of 
// Energy Research, Applied Mathematical Sciences Research Program.
// 

// The license for ODEPACK Fortran source code is:
//
// NOTICE
// 
// This work was produced at the University of California, Lawrence Livermore
// National Laboratory (UC LLNL) under contract no. W-7405-ENG-48 (Contract
// 48) between the U.S. Department of Energy (DOE) and The Regents of the
// University of California (University) for the operation of UC LLNL. The
// rights of the Federal Government are reserved under Contract 48 subject
// to the restrictions agreed upon by the DOE and University as allowed
// under DOE Acquisition Letter 97-1.
// 
// The ODEPACK package has been declared to be in the Public Domain.
// 
// DISCLAIMER
// 
// This work was prepared as an account of work sponsored by an agency of
// the United States Government. Neither the United States Government nor the
// University of California nor any of their employees, makes any warranty,
// express or implied, or assumes any liability or responsibility for the
// accuracy, completeness, or usefulness of any information, apparatus,
// product, or process disclosed, or represents that its use would not
// infringe privately-owned rights. Reference herein to any specific
// commercial products, process, or service by trade name, trademark,
// manufacturer or otherwise does not necessarily constitute or imply
// its endorsement, recommendation, or favoring by the United States
// Government or the University of California. The views and opinions of
// authors expressed herein do not necessarily state or reflect those of
// the United States Government or the University of California, and shall
// not be used for advertising or product endorsement purposes.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "dintdy-  k (=i1) illegal      "
#define _dc_1 "dintdy-  t (=r1) illegal      "
#define _dc_2 "      t not in interval tcur - hu (= r1) to tcur (=r2)      "
#define _dc_3 "dlsoda-  warning.. rwork length is sufficient for now, but  "
#define _dc_4 "      may not be later.  integration will proceed anyway.   "
#define _dc_5 "      length needed is lenrw = i1, while lrw = i2."
#define _dc_6 "dlsoda-  warning.. iwork length is sufficient for now, but  "
#define _dc_7 "      length needed is leniw = i1, while liw = i2."
#define _dc_8 "dlsoda-  warning..internal t (=r1) and h (=r2) are"
#define _dc_9 "      such that in the machine, t + h = t on the next step  "
#define _dc_10 "     (h = step size). solver will continue anyway."
#define _dc_11 "dlsoda-  above warning has been issued i1 times.  "
#define _dc_12 "     it will not be issued again for this problem."
#define _dc_13 "dlsoda- a switch to the bdf (stiff) method has occurred     "
#define _dc_14 "dlsoda- a switch to the adams (nonstiff) method has occurred"
#define _dc_15 "     at t = r1,  tentative step size h = r2,  step nst = i1 "
#define _dc_16 "dlsoda-  at current t (=r1), mxstep (=i1) steps   "
#define _dc_17 "      taken on this call before reaching tout     "
#define _dc_18 "dlsoda-  at t (=r1), ewt(i1) has become r2 .le. 0."
#define _dc_19 "dlsoda-  at t (=r1), too much accuracy requested  "
#define _dc_20 "      for precision of machine..  see tolsf (=r2) "
#define _dc_21 "dlsoda-  at t(=r1) and step size h(=r2), the error"
#define _dc_22 "      test failed repeatedly or with abs(h) = hmin"
#define _dc_23 "dlsoda-  at t (=r1) and step size h (=r2), the    "
#define _dc_24 "      corrector convergence failed repeatedly     "
#define _dc_25 "      or with abs(h) = hmin   "
#define _dc_26 "dlsoda-  at current t(=r1), rwork length too small"
#define _dc_27 "      to proceed.  the integration was otherwise successful."
#define _dc_28 "dlsoda-  at current t(=r1), iwork length too small"
#define _dc_29 "dlsoda-  istate (=i1) illegal."
#define _dc_30 "dlsoda-  itask (=i1) illegal. "
#define _dc_31 "dlsoda-  istate .gt. 1 but dlsoda not initialized."
#define _dc_32 "dlsoda-  neq (=i1) .lt. 1     "
#define _dc_33 "dlsoda-  istate = 3 and neq increased (i1 to i2). "
#define _dc_34 "dlsoda-  itol (=i1) illegal.  "
#define _dc_35 "dlsoda-  iopt (=i1) illegal.  "
#define _dc_36 "dlsoda-  jt (=i1) illegal.    "
#define _dc_37 "dlsoda-  ml (=i1) illegal: .lt.0 or .ge.neq (=i2) "
#define _dc_38 "dlsoda-  mu (=i1) illegal: .lt.0 or .ge.neq (=i2) "
#define _dc_39 "dlsoda-  ixpr (=i1) illegal.  "
#define _dc_40 "dlsoda-  mxstep (=i1) .lt. 0  "
#define _dc_41 "dlsoda-  mxhnil (=i1) .lt. 0  "
#define _dc_42 "dlsoda-  tout (=r1) behind t (=r2)      "
#define _dc_43 "      integration direction is given by h0 (=r1)  "
#define _dc_44 "dlsoda-  hmax (=r1) .lt. 0.0  "
#define _dc_45 "dlsoda-  hmin (=r1) .lt. 0.0  "
#define _dc_46 "dlsoda-  rwork length needed, lenrw (=i1), exceeds lrw (=i2)"
#define _dc_47 "dlsoda-  iwork length needed, leniw (=i1), exceeds liw (=i2)"
#define _dc_48 "dlsoda-  rtol(i1) is r1 .lt. 0.0        "
#define _dc_49 "dlsoda-  atol(i1) is r1 .lt. 0.0        "
#define _dc_50 "dlsoda-  ewt(i1) is r1 .le. 0.0         "
#define _dc_51 "dlsoda-  tout(=r1) too close to t(=r2) to start integration."
#define _dc_52 "dlsoda-  itask = i1 and tout (=r1) behind tcur - hu (= r2)  "
#define _dc_53 "dlsoda-  itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)   "
#define _dc_54 "dlsoda-  itask = 4 or 5 and tcrit (=r1) behind tout (=r2)   "
#define _dc_55 "dlsoda-  at start of problem, too much accuracy   "
#define _dc_56 "      requested for precision of machine..  see tolsf (=r1) "
#define _dc_57 "dlsoda-  trouble in dintdy.  itask = i1, tout = r1"
#define _dc_58 "dlsoda-  mxordn (=i1) .lt. 0  "
#define _dc_59 "dlsoda-  mxords (=i1) .lt. 0  "
#define _dc_60 "dlsoda-  run aborted.. apparent infinite loop.    "
#define _dc_61 "dlsodar-  warning.. rwork length is sufficient for now, but "
#define _dc_62 "dlsodar-  warning.. iwork length is sufficient for now, but "
#define _dc_63 "dlsodar-  warning..internal t(=r1) and h(=r2) are "
#define _dc_64 "dlsodar-  above warning has been issued i1 times. "
#define _dc_65 "dlsodar- a switch to the bdf (stiff) method has occurred    "
#define _dc_66 "dlsodar- a switch to the adams (nonstiff) method occurred   "
#define _dc_67 "dlsodar-  at current t (=r1), mxstep (=i1) steps  "
#define _dc_68 "dlsodar-  at t(=r1), ewt(i1) has become r2 .le. 0."
#define _dc_69 "dlsodar-  at t (=r1), too much accuracy requested "
#define _dc_70 "dlsodar-  at t(=r1), step size h(=r2), the error  "
#define _dc_71 "dlsodar-  at t (=r1) and step size h (=r2), the   "
#define _dc_72 "dlsodar- at current t(=r1), rwork length too small"
#define _dc_73 "dlsodar- at current t(=r1), iwork length too small"
#define _dc_74 "dlsodar-  istate(=i1) illegal."
#define _dc_75 "dlsodar-  itask (=i1) illegal."
#define _dc_76 "dlsodar-  istate.gt.1 but dlsodar not initialized."
#define _dc_77 "dlsodar-  neq (=i1) .lt. 1    "
#define _dc_78 "dlsodar-  istate = 3 and neq increased (i1 to i2)."
#define _dc_79 "dlsodar-  itol (=i1) illegal. "
#define _dc_80 "dlsodar-  iopt (=i1) illegal. "
#define _dc_81 "dlsodar-  jt (=i1) illegal.   "
#define _dc_82 "dlsodar-  ml (=i1) illegal: .lt.0 or .ge.neq (=i2)"
#define _dc_83 "dlsodar-  mu (=i1) illegal: .lt.0 or .ge.neq (=i2)"
#define _dc_84 "dlsodar-  ixpr (=i1) illegal. "
#define _dc_85 "dlsodar-  mxstep (=i1) .lt. 0 "
#define _dc_86 "dlsodar-  mxhnil (=i1) .lt. 0 "
#define _dc_87 "dlsodar-  tout (=r1) behind t (=r2)     "
#define _dc_88 "dlsodar-  hmax (=r1) .lt. 0.0 "
#define _dc_89 "dlsodar-  hmin (=r1) .lt. 0.0 "
#define _dc_90 "dlsodar-  rwork length needed, lenrw(=i1), exceeds lrw(=i2) "
#define _dc_91 "dlsodar-  iwork length needed, leniw(=i1), exceeds liw(=i2) "
#define _dc_92 "dlsodar-  rtol(i1) is r1 .lt. 0.0       "
#define _dc_93 "dlsodar-  atol(i1) is r1 .lt. 0.0       "
#define _dc_94 "dlsodar-  ewt(i1) is r1 .le. 0.0        "
#define _dc_95 "dlsodar- tout(=r1) too close to t(=r2) to start integration."
#define _dc_96 "dlsodar-  itask = i1 and tout (=r1) behind tcur - hu (= r2) "
#define _dc_97 "dlsodar-  itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)  "
#define _dc_98 "dlsodar-  itask = 4 or 5 and tcrit (=r1) behind tout (=r2)  "
#define _dc_99 "dlsodar-  at start of problem, too much accuracy  "
#define _dc_100 "dlsodar-  trouble in dintdy. itask = i1, tout = r1"
#define _dc_101 "dlsodar-  mxordn (=i1) .lt. 0 "
#define _dc_102 "dlsodar-  mxords (=i1) .lt. 0 "
#define _dc_103 "dlsodar-  ng (=i1) .lt. 0     "
#define _dc_104 "dlsodar-  ng changed (from i1 to i2) illegally,   "
#define _dc_105 "      i.e. not immediately after a root was found."
#define _dc_106 "dlsodar-  one or more components of g has a root  "
#define _dc_107 "      too near to the initial point.    "
#define _dc_108 "dlsodar-  run aborted.. apparent infinite loop.   "
#define _dc_109 "dlsode-  warning..internal t (=r1) and h (=r2) are"
#define _dc_110 "      (h = step size). solver will continue anyway"
#define _dc_111 "dlsode-  above warning has been issued i1 times.  "
#define _dc_112 "      it will not be issued again for this problem"
#define _dc_113 "dlsode-  at current t (=r1), mxstep (=i1) steps   "
#define _dc_114 "dlsode-  at t (=r1), ewt(i1) has become r2 .le. 0."
#define _dc_115 "dlsode-  at t (=r1), too much accuracy requested  "
#define _dc_116 "dlsode-  at t(=r1) and step size h(=r2), the error"
#define _dc_117 "dlsode-  at t (=r1) and step size h (=r2), the    "
#define _dc_118 "dlsode-  istate (=i1) illegal "
#define _dc_119 "dlsode-  itask (=i1) illegal  "
#define _dc_120 "dlsode-  istate .gt. 1 but dlsode not initialized "
#define _dc_121 "dlsode-  neq (=i1) .lt. 1     "
#define _dc_122 "dlsode-  istate = 3 and neq increased (i1 to i2)  "
#define _dc_123 "dlsode-  itol (=i1) illegal   "
#define _dc_124 "dlsode-  iopt (=i1) illegal   "
#define _dc_125 "dlsode-  mf (=i1) illegal     "
#define _dc_126 "dlsode-  ml (=i1) illegal.. .lt.0 or .ge.neq (=i2)"
#define _dc_127 "dlsode-  mu (=i1) illegal.. .lt.0 or .ge.neq (=i2)"
#define _dc_128 "dlsode-  maxord (=i1) .lt. 0  "
#define _dc_129 "dlsode-  mxstep (=i1) .lt. 0  "
#define _dc_130 "dlsode-  mxhnil (=i1) .lt. 0  "
#define _dc_131 "dlsode-  tout (=r1) behind t (=r2)      "
#define _dc_132 "dlsode-  hmax (=r1) .lt. 0.0  "
#define _dc_133 "dlsode-  hmin (=r1) .lt. 0.0  "
#define _dc_134 "dlsode-  rwork length needed, lenrw (=i1), exceeds lrw (=i2)"
#define _dc_135 "dlsode-  iwork length needed, leniw (=i1), exceeds liw (=i2)"
#define _dc_136 "dlsode-  rtol(i1) is r1 .lt. 0.0        "
#define _dc_137 "dlsode-  atol(i1) is r1 .lt. 0.0        "
#define _dc_138 "dlsode-  ewt(i1) is r1 .le. 0.0         "
#define _dc_139 "dlsode-  tout (=r1) too close to t(=r2) to start integration"
#define _dc_140 "dlsode-  itask = i1 and tout (=r1) behind tcur - hu (= r2)  "
#define _dc_141 "dlsode-  itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)   "
#define _dc_142 "dlsode-  itask = 4 or 5 and tcrit (=r1) behind tout (=r2)   "
#define _dc_143 "dlsode-  at start of problem, too much accuracy   "
#define _dc_144 "dlsode-  trouble in dintdy.  itask = i1, tout = r1"
#define _dc_145 "dlsode-  run aborted.. apparent infinite loop     "
#define _dc_146 "dlsodes- warning..internal t (=r1) and h (=r2) are"
#define _dc_147 "dlsodes- above warning has been issued i1 times.  "
#define _dc_148 "dlsodes- at current t (=r1), mxstep (=i1) steps   "
#define _dc_149 "dlsodes- at t (=r1), ewt(i1) has become r2 .le. 0."
#define _dc_150 "dlsodes- at t (=r1), too much accuracy requested  "
#define _dc_151 "dlsodes- at t(=r1) and step size h(=r2), the error"
#define _dc_152 "dlsodes- at t (=r1) and step size h (=r2), the    "
#define _dc_153 "dlsodes- at t (=r1) and step size h (=r2), a fatal"
#define _dc_154 "      error flag was returned by cdrv (by way of  "
#define _dc_155 "      subroutine dprjs or dsolss)       "
#define _dc_156 "dlsodes- istate (=i1) illegal."
#define _dc_157 "dlsodes- itask (=i1) illegal. "
#define _dc_158 "dlsodes- istate.gt.1 but dlsodes not initialized. "
#define _dc_159 "dlsodes- neq (=i1) .lt. 1     "
#define _dc_160 "dlsodes- istate = 3 and neq increased (i1 to i2). "
#define _dc_161 "dlsodes- itol (=i1) illegal.  "
#define _dc_162 "dlsodes- iopt (=i1) illegal.  "
#define _dc_163 "dlsodes- mf (=i1) illegal.    "
#define _dc_164 "dlsodes- seth (=r1) .lt. 0.0  "
#define _dc_165 "dlsodes- maxord (=i1) .lt. 0  "
#define _dc_166 "dlsodes- mxstep (=i1) .lt. 0  "
#define _dc_167 "dlsodes- mxhnil (=i1) .lt. 0  "
#define _dc_168 "dlsodes- tout (=r1) behind t (=r2)      "
#define _dc_169 "dlsodes- hmax (=r1) .lt. 0.0  "
#define _dc_170 "dlsodes- hmin (=r1) .lt. 0.0  "
#define _dc_171 "dlsodes- rwork length is insufficient to proceed. "
#define _dc_172 "        length needed is .ge. lenrw (=i1), exceeds lrw (=i2)"
#define _dc_173 "dlsodes- iwork length is insufficient to proceed. "
#define _dc_174 "        length needed is .ge. leniw (=i1), exceeds liw (=i2)"
#define _dc_175 "dlsodes- rtol(i1) is r1 .lt. 0.0        "
#define _dc_176 "dlsodes- atol(i1) is r1 .lt. 0.0        "
#define _dc_177 "dlsodes- ewt(i1) is r1 .le. 0.0         "
#define _dc_178 "dlsodes- tout(=r1) too close to t(=r2) to start integration."
#define _dc_179 "dlsodes- itask = i1 and tout (=r1) behind tcur - hu (= r2)  "
#define _dc_180 "dlsodes- itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)   "
#define _dc_181 "dlsodes- itask = 4 or 5 and tcrit (=r1) behind tout (=r2)   "
#define _dc_182 "dlsodes- at start of problem, too much accuracy   "
#define _dc_183 "dlsodes- trouble in dintdy.  itask = i1, tout = r1"
#define _dc_184 "dlsodes- rwork length insufficient (for subroutine dprep).  "
#define _dc_185 "dlsodes- rwork length insufficient (for subroutine jgroup). "
#define _dc_186 "dlsodes- rwork length insufficient (for subroutine odrv).   "
#define _dc_187 "dlsodes- error from odrv in yale sparse matrix package.     "
#define _dc_188 "      at t (=r1), odrv returned error flag = i1*neq + i2.   "
#define _dc_189 "dlsodes- rwork length insufficient (for subroutine cdrv).   "
#define _dc_190 "dlsodes- error from cdrv in yale sparse matrix package.     "
#define _dc_191 "      at t (=r1), cdrv returned error flag = i1*neq + i2.   "
#define _dc_192 "        duplicate entry in sparsity structure descriptors.  "
#define _dc_193 "        insufficient storage for nsfc (called by cdrv).     "
#define _dc_194 "dlsodes- run aborted.. apparent infinite loop.    "
#define _dc_195 "dlsoibt- warning..internal t (=r1) and h (=r2) are"
#define _dc_196 "dlsoibt- above warning has been issued i1 times.  "
#define _dc_197 "dlsoibt- at current t (=r1), mxstep (=i1) steps   "
#define _dc_198 "dlsoibt- at t (=r1), ewt(i1) has become r2 .le. 0."
#define _dc_199 "dlsoibt- at t (=r1), too much accuracy requested  "
#define _dc_200 "dlsoibt- at t (=r1) and step size h (=r2), the    "
#define _dc_201 "error test failed repeatedly or with abs(h) = hmin"
#define _dc_202 "dlsoibt- at t (=r1) residual routine returned     "
#define _dc_203 "      error ires = 3 repeatedly.        "
#define _dc_204 "dlsoibt- attempt to initialize dy/dt failed:  matrix a has a"
#define _dc_205 "      singular diagonal block, block no. = (i1)   "
#define _dc_206 "dlsoibt- attempt to initialize dy/dt failed       "
#define _dc_207 "      because residual routine set its error flag "
#define _dc_208 "      to ires = (i1)"
#define _dc_209 "dlsoibt- residual routine set its flag ires       "
#define _dc_210 "      to (i1) when called for final output.       "
#define _dc_211 "dlsoibt- istate (=i1) illegal."
#define _dc_212 "dlsoibt- itask (=i1) illegal. "
#define _dc_213 "dlsoibt- istate.gt.1 but dlsoibt not initialized. "
#define _dc_214 "dlsoibt- neq (=i1) .lt. 1     "
#define _dc_215 "dlsoibt- istate = 3 and neq increased (i1 to i2). "
#define _dc_216 "dlsoibt- itol (=i1) illegal.  "
#define _dc_217 "dlsoibt- iopt (=i1) illegal.  "
#define _dc_218 "dlsoibt- mf (=i1) illegal.    "
#define _dc_219 "dlsoibt- mb (=i1) or nb (=i2) illegal.  "
#define _dc_220 "dlsoibt- nb (=i1) .lt. 4 illegal.       "
#define _dc_221 "dlsoibt- maxord (=i1) .lt. 0  "
#define _dc_222 "dlsoibt- mxstep (=i1) .lt. 0  "
#define _dc_223 "dlsoibt- mxhnil (=i1) .lt. 0  "
#define _dc_224 "dlsoibt- tout (=r1) behind t (=r2)      "
#define _dc_225 "dlsoibt- hmax (=r1) .lt. 0.0  "
#define _dc_226 "dlsoibt- hmin (=r1) .lt. 0.0  "
#define _dc_227 "dlsoibt- rwork length needed, lenrw (=i1), exceeds lrw (=i2)"
#define _dc_228 "dlsoibt- iwork length needed, leniw (=i1), exceeds liw (=i2)"
#define _dc_229 "dlsoibt- rtol(=i1) is r1 .lt. 0.0       "
#define _dc_230 "dlsoibt- atol(=i1) is r1 .lt. 0.0       "
#define _dc_231 "dlsoibt- ewt(i1) is r1 .le. 0.0         "
#define _dc_232 "dlsoibt- tout(=r1) too close to t(=r2) to start integration."
#define _dc_233 "dlsoibt- itask = i1 and tout (=r1) behind tcur - hu (= r2)  "
#define _dc_234 "dlsoibt- itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)   "
#define _dc_235 "dlsoibt- itask = 4 or 5 and tcrit (=r1) behind tout (=r2)   "
#define _dc_236 "dlsoibt- at start of problem, too much accuracy   "
#define _dc_237 "dlsoibt- trouble in dintdy.  itask = i1, tout = r1"
#define _dc_238 "dlsoibt- run aborted.. apparent infinite loop.    "
#define _dc_239 "dlsodi-  warning..internal t (=r1) and h (=r2) are"
#define _dc_240 "dlsodi-  above warning has been issued i1 times.  "
#define _dc_241 "dlsodi-  at current t (=r1), mxstep (=i1) steps   "
#define _dc_242 "dlsodi-  at t (=r1), ewt(i1) has become r2 .le. 0."
#define _dc_243 "dlsodi-  at t (=r1), too much accuracy requested  "
#define _dc_244 "dlsodi-  at t(=r1) and step size h(=r2), the error"
#define _dc_245 "dlsodi-  at t (=r1) and step size h (=r2), the    "
#define _dc_246 "dlsodi-  at t (=r1) residual routine returned     "
#define _dc_247 "dlsodi- attempt to initialize dy/dt failed:  matrix a is    "
#define _dc_248 "      singular.  dgefa or dgbfa returned info = i1"
#define _dc_249 "dlsodi-  attempt to initialize dy/dt failed       "
#define _dc_250 "dlsodi-  residual routine set its flag ires       "
#define _dc_251 "dlsodi-  istate (=i1) illegal."
#define _dc_252 "dlsodi-  itask (=i1) illegal. "
#define _dc_253 "dlsodi-  istate .gt. 1 but dlsodi not initialized."
#define _dc_254 "dlsodi-  neq (=i1) .lt. 1     "
#define _dc_255 "dlsodi-  istate = 3 and neq increased (i1 to i2). "
#define _dc_256 "dlsodi-  itol (=i1) illegal.  "
#define _dc_257 "dlsodi-  iopt (=i1) illegal.  "
#define _dc_258 "dlsodi-  mf (=i1) illegal.    "
#define _dc_259 "dlsodi-  ml(=i1) illegal: .lt. 0 or .ge. neq(=i2) "
#define _dc_260 "dlsodi-  mu(=i1) illegal: .lt. 0 or .ge. neq(=i2) "
#define _dc_261 "dlsodi-  maxord (=i1) .lt. 0  "
#define _dc_262 "dlsodi-  mxstep (=i1) .lt. 0  "
#define _dc_263 "dlsodi-  mxhnil (=i1) .lt. 0  "
#define _dc_264 "dlsodi-  tout (=r1) behind t (=r2)      "
#define _dc_265 "dlsodi-  hmax (=r1) .lt. 0.0  "
#define _dc_266 "dlsodi-  hmin (=r1) .lt. 0.0  "
#define _dc_267 "dlsodi-  rwork length needed, lenrw (=i1), exceeds lrw (=i2)"
#define _dc_268 "dlsodi-  iwork length needed, leniw (=i1), exceeds liw (=i2)"
#define _dc_269 "dlsodi-  rtol(=i1) is r1 .lt. 0.0       "
#define _dc_270 "dlsodi-  atol(=i1) is r1 .lt. 0.0       "
#define _dc_271 "dlsodi-  ewt(i1) is r1 .le. 0.0         "
#define _dc_272 "dlsodi-  tout(=r1) too close to t(=r2) to start integration."
#define _dc_273 "dlsodi-  itask = i1 and tout (=r1) behind tcur - hu (= r2)  "
#define _dc_274 "dlsodi-  itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)   "
#define _dc_275 "dlsodi-  itask = 4 or 5 and tcrit (=r1) behind tout (=r2)   "
#define _dc_276 "dlsodi-  at start of problem, too much accuracy   "
#define _dc_277 "dlsodi-  trouble in dintdy.  itask = i1, tout = r1"
#define _dc_278 "dlsodi-  run aborted.. apparent infinite loop.    "
#define _dc_279 "dlsodis- warning..internal t (=r1) and h (=r2) are"
#define _dc_280 "dlsodis- above warning has been issued i1 times.  "
#define _dc_281 "dlsodis- at current t (=r1), mxstep (=i1) steps   "
#define _dc_282 "dlsodis- at t (=r1), ewt(i1) has become r2 .le. 0."
#define _dc_283 "dlsodis- at t (=r1), too much accuracy requested  "
#define _dc_284 "dlsodis- at t (=r1) and step size h (=r2), the    "
#define _dc_285 "     error test failed repeatedly or with abs(h) = hmin     "
#define _dc_286 "dlsodis- at t (=r1) residual routine returned     "
#define _dc_287 "    error ires = 3 repeatedly."
#define _dc_288 "dlsodis- at t (=r1) and step size h (=r2), a fatal"
#define _dc_289 "      subroutine dprjis or dsolss)      "
#define _dc_290 "dlsodis- attempt to initialize dy/dt failed because matrix a"
#define _dc_291 "     was singular.  cdrv returned zero pivot error flag.    "
#define _dc_292 "dainvgs set its error flag to ier = (i1)"
#define _dc_293 "dlsodis- attempt to initialize dy/dt failed       "
#define _dc_294 "dlsodis- residual routine set its flag ires       "
#define _dc_295 "dlsodis- istate (=i1) illegal."
#define _dc_296 "dlsodis- itask (=i1) illegal. "
#define _dc_297 "dlsodis-istate .gt. 1 but dlsodis not initialized."
#define _dc_298 "dlsodis- neq (=i1) .lt. 1     "
#define _dc_299 "dlsodis- istate = 3 and neq increased (i1 to i2). "
#define _dc_300 "dlsodis- itol (=i1) illegal.  "
#define _dc_301 "dlsodis- iopt (=i1) illegal.  "
#define _dc_302 "dlsodis- mf (=i1) illegal.    "
#define _dc_303 "dlsodis- maxord (=i1) .lt. 0  "
#define _dc_304 "dlsodis- mxstep (=i1) .lt. 0  "
#define _dc_305 "dlsodis- mxhnil (=i1) .lt. 0  "
#define _dc_306 "dlsodis- tout (=r1) behind t (=r2)      "
#define _dc_307 "dlsodis- hmax (=r1) .lt. 0.0  "
#define _dc_308 "dlsodis- hmin (=r1) .lt. 0.0  "
#define _dc_309 "dlsodis- rwork length is insufficient to proceed. "
#define _dc_310 "dlsodis- iwork length is insufficient to proceed. "
#define _dc_311 "dlsodis- rtol(=i1) is r1 .lt. 0.0       "
#define _dc_312 "dlsodis- atol(=i1) is r1 .lt. 0.0       "
#define _dc_313 "dlsodis- ewt(i1) is r1 .le. 0.0         "
#define _dc_314 "dlsodis- tout(=r1) too close to t(=r2) to start integration."
#define _dc_315 "dlsodis- itask = i1 and tout (=r1) behind tcur - hu (= r2)  "
#define _dc_316 "dlsodis- itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)   "
#define _dc_317 "dlsodis- itask = 4 or 5 and tcrit (=r1) behind tout (=r2)   "
#define _dc_318 "dlsodis- at start of problem, too much accuracy   "
#define _dc_319 "dlsodis- trouble in dintdy.  itask = i1, tout = r1"
#define _dc_320 "dlsodis- rwork length insufficient (for subroutine dprepi). "
#define _dc_321 "dlsodis- rwork length insufficient (for subroutine jgroup). "
#define _dc_322 "dlsodis- rwork length insufficient (for subroutine odrv).   "
#define _dc_323 "dlsodis- error from odrv in yale sparse matrix package.     "
#define _dc_324 "dlsodis- rwork length insufficient (for subroutine cdrv).   "
#define _dc_325 "dlsodis- error from cdrv in yale sparse matrix package.     "
#define _dc_326 "dlsodis- at t (=r1) residual routine (called by dprepi)     "
#define _dc_327 "     returned error ires (=i1)"
#define _dc_328 "dlsodis- run aborted.. apparent infinite loop.    "
#define _dc_329 "dlsodkr- warning. poor iterative algorithm performance seen "
#define _dc_330 "      at t = r1 by average no. of linear iterations = r2    "
#define _dc_331 "      at t = r1 by nonlinear convergence failure rate = r2  "
#define _dc_332 "      at t = r1 by linear convergence failure rate = r2     "
#define _dc_333 "dlsodkr-  warning.. internal t(=r1) and h(=r2) are"
#define _dc_334 "dlsodkr-  above warning has been issued i1 times. "
#define _dc_335 "dlsodkr-  at current t (=r1), mxstep (=i1) steps  "
#define _dc_336 "dlsodkr-  at t(=r1), ewt(i1) has become r2 .le. 0."
#define _dc_337 "dlsodkr-  at t (=r1), too much accuracy requested "
#define _dc_338 "dlsodkr- at t(=r1) and step size h(=r2), the error"
#define _dc_339 "dlsodkr-  at t (=r1) and step size h (=r2), the   "
#define _dc_340 "dlsodkr-  at t (=r1) an unrecoverable error return"
#define _dc_341 "      was made from subroutine psol     "
#define _dc_342 "dlsodkr-  istate(=i1) illegal."
#define _dc_343 "dlsodkr-  itask (=i1) illegal."
#define _dc_344 "dlsodkr- istate.gt.1 but dlsodkr not initialized. "
#define _dc_345 "dlsodkr-  neq (=i1) .lt. 1    "
#define _dc_346 "dlsodkr-  istate = 3 and neq increased (i1 to i2)."
#define _dc_347 "dlsodkr-  itol (=i1) illegal. "
#define _dc_348 "dlsodkr-  iopt (=i1) illegal. "
#define _dc_349 "dlsodkr-  mf (=i1) illegal.   "
#define _dc_350 "dlsodkr-  maxord (=i1) .lt. 0 "
#define _dc_351 "dlsodkr-  mxstep (=i1) .lt. 0 "
#define _dc_352 "dlsodkr-  mxhnil (=i1) .lt. 0 "
#define _dc_353 "dlsodkr-  tout (=r1) behind t (=r2)     "
#define _dc_354 "dlsodkr-  hmax (=r1) .lt. 0.0 "
#define _dc_355 "dlsodkr-  hmin (=r1) .lt. 0.0 "
#define _dc_356 "dlsodkr-  rwork length needed, lenrw(=i1), exceeds lrw(=i2) "
#define _dc_357 "dlsodkr-  iwork length needed, leniw(=i1), exceeds liw(=i2) "
#define _dc_358 "dlsodkr-  rtol(i1) is r1 .lt. 0.0       "
#define _dc_359 "dlsodkr-  atol(i1) is r1 .lt. 0.0       "
#define _dc_360 "dlsodkr-  ewt(i1) is r1 .le. 0.0        "
#define _dc_361 "dlsodkr- tout(=r1) too close to t(=r2) to start integration."
#define _dc_362 "dlsodkr-  itask = i1 and tout (=r1) behind tcur - hu (= r2) "
#define _dc_363 "dlsodkr-  itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)  "
#define _dc_364 "dlsodkr-  itask = 4 or 5 and tcrit (=r1) behind tout (=r2)  "
#define _dc_365 "dlsodkr-  at start of problem, too much accuracy  "
#define _dc_366 "dlsodkr-  trouble in dintdy. itask = i1, tout = r1"
#define _dc_367 "dlsodkr-  ng (=i1) .lt. 0     "
#define _dc_368 "dlsodkr-  ng changed (from i1 to i2) illegally,   "
#define _dc_369 "dlsodkr-  one or more components of g has a root  "
#define _dc_370 "dlsodkr-  run aborted.. apparent infinite loop.   "
#define _dc_371 "dlsodpk- warning. poor iterative algorithm performance seen "
#define _dc_372 "dlsodpk-  warning..internal t(=r1) and h(=r2) are "
#define _dc_373 "dlsodpk-  above warning has been issued i1 times. "
#define _dc_374 "dlsodpk-  at current t (=r1), mxstep (=i1) steps  "
#define _dc_375 "dlsodpk-  at t (=r1), ewt(i1) has become r2.le.0. "
#define _dc_376 "dlsodpk-  at t (=r1), too much accuracy requested "
#define _dc_377 "dlsodpk-  at t(=r1), step size h(=r2), the error  "
#define _dc_378 "dlsodpk-  at t (=r1) and step size h (=r2), the   "
#define _dc_379 "dlsodpk-  at t (=r1) an unrecoverable error return"
#define _dc_380 "dlsodpk-  istate(=i1) illegal."
#define _dc_381 "dlsodpk-  itask (=i1) illegal."
#define _dc_382 "dlsodpk-  istate.gt.1 but dlsodpk not initialized."
#define _dc_383 "dlsodpk-  neq (=i1) .lt. 1    "
#define _dc_384 "dlsodpk-  istate = 3 and neq increased (i1 to i2)."
#define _dc_385 "dlsodpk-  itol (=i1) illegal. "
#define _dc_386 "dlsodpk-  iopt (=i1) illegal. "
#define _dc_387 "dlsodpk-  mf (=i1) illegal.   "
#define _dc_388 "dlsodpk-  maxord (=i1) .lt. 0 "
#define _dc_389 "dlsodpk-  mxstep (=i1) .lt. 0 "
#define _dc_390 "dlsodpk-  mxhnil (=i1) .lt. 0 "
#define _dc_391 "dlsodpk-  tout (=r1) behind t (=r2)     "
#define _dc_392 "dlsodpk-  hmax (=r1) .lt. 0.0 "
#define _dc_393 "dlsodpk-  hmin (=r1) .lt. 0.0 "
#define _dc_394 "dlsodpk-  rwork length needed, lenrw(=i1), exceeds lrw(=i2) "
#define _dc_395 "dlsodpk-  iwork length needed, leniw(=i1), exceeds liw(=i2) "
#define _dc_396 "dlsodpk-  rtol(i1) is r1 .lt. 0.0       "
#define _dc_397 "dlsodpk-  atol(i1) is r1 .lt. 0.0       "
#define _dc_398 "dlsodpk-  ewt(i1) is r1 .le. 0.0        "
#define _dc_399 "dlsodpk- tout(=r1) too close to t(=r2) to start integration."
#define _dc_400 "dlsodpk-  itask = i1 and tout (=r1) behind tcur - hu (= r2) "
#define _dc_401 "dlsodpk-  itask = 4 or 5 and tcrit (=r1) behind tcur (=r2)  "
#define _dc_402 "dlsodpk-  itask = 4 or 5 and tcrit (=r1) behind tout (=r2)  "
#define _dc_403 "dlsodpk-  at start of problem, too much accuracy  "
#define _dc_404 "dlsodpk-  trouble in dintdy. itask = i1, tout = r1"
#define _dc_405 "dlsodpk-  run aborted.. apparent infinite loop.   "
#define _dc_406 " "
#define _dc_407 "      "
#define _dc_408 "in above message,  i1 ="
#define _dc_409 "   "
#define _dc_410 "i2 ="
#define _dc_411 "in above message,  r1 ="
#define _dc_412 "in above,  r1 ="
#define _dc_413 "r2 ="
static FORMAT *__fmt_a = NULL;
typedef char char_31[32];
typedef char char_63[64];
typedef char char_127[128];
#define __ncalls 85
static CALLS __calls[__ncalls] = {
  {"adjlr", 0}, // subroutine
  {"cdrv", 0}, // subroutine
  {"nroc", 0}, // subroutine
  {"nsfc", 0}, // subroutine
  {"nnfc", 0}, // subroutine
  {"nnsc", 0}, // subroutine
  {"nntc", 0}, // subroutine
  {"cntnzu", 0}, // subroutine
  {"daigbt", 0}, // subroutine
  {"dainvg", 0}, // subroutine
  {"dainvgs", 0}, // subroutine
  {"datp", 0}, // subroutine
  {"datv", 0}, // subroutine
  {"dbnorm", 0}, // real*8 function
  {"dcfode", 0}, // subroutine
  {"ddecbt", 0}, // subroutine
  {"dewset", 0}, // subroutine
  {"dfnorm", 0}, // real*8 function
  {"dhefa", 0}, // subroutine
  {"dhels", 0}, // subroutine
  {"dheqr", 0}, // subroutine
  {"dhesl", 0}, // subroutine
  {"dintdy", 0}, // subroutine
  {"diprep", 0}, // subroutine
  {"diprepi", 0}, // subroutine
  {"dlhin", 0}, // subroutine
  {"dlsoda", 0}, // subroutine
  {"dlsodar", 0}, // subroutine
  {"dlsode", 0}, // subroutine
  {"dlsodes", 0}, // subroutine
  {"dlsoibt", 0}, // subroutine
  {"dlsodi", 0}, // subroutine
  {"dlsodis", 0}, // subroutine
  {"dlsodkr", 0}, // subroutine
  {"dlsodpk", 0}, // subroutine
  {"dmnorm", 0}, // real*8 function
  {"dorthog", 0}, // subroutine
  {"dpcg", 0}, // subroutine
  {"dpcgs", 0}, // subroutine
  {"dpjibt", 0}, // subroutine
  {"dpkset", 0}, // subroutine
  {"dprep", 0}, // subroutine
  {"dprepi", 0}, // subroutine
  {"dprepj", 0}, // subroutine
  {"dprepji", 0}, // subroutine
  {"dprja", 0}, // subroutine
  {"dprjis", 0}, // subroutine
  {"dprjs", 0}, // subroutine
  {"drchek", 0}, // subroutine
  {"droots", 0}, // subroutine
  {"dsetpk", 0}, // subroutine
  {"dslsbt", 0}, // subroutine
  {"dsolbt", 0}, // subroutine
  {"dsolpk", 0}, // subroutine
  {"dsolss", 0}, // subroutine
  {"dsolsy", 0}, // subroutine
  {"dspigmr", 0}, // subroutine
  {"dspiom", 0}, // subroutine
  {"dsrcar", 0}, // subroutine
  {"dsrckr", 0}, // subroutine
  {"dsrcma", 0}, // subroutine
  {"dsrcms", 0}, // subroutine
  {"dsrcom", 0}, // subroutine
  {"dsrcpk", 0}, // subroutine
  {"dstoda", 0}, // subroutine
  {"dstode", 0}, // subroutine
  {"dstodi", 0}, // subroutine
  {"dstodpk", 0}, // subroutine
  {"dstoka", 0}, // subroutine
  {"dumach", 0}, // real*8 function
  {"dumsum", 0}, // subroutine
  {"dusol", 0}, // subroutine
  {"dvnorm", 0}, // real*8 function
  {"iumach", 0}, // integer*4 function
  {"ixsav", 0}, // integer*4 function
  {"jgroup", 0}, // subroutine
  {"odrv", 0}, // subroutine
  {"md", 0}, // subroutine
  {"mdi", 0}, // subroutine
  {"mdm", 0}, // subroutine
  {"mdp", 0}, // subroutine
  {"mdu", 0}, // subroutine
  {"sro", 0}, // subroutine
  {"xerrwd", 0}, // subroutine
  {NULL, 0}
};

static struct {
  int_4 iplost_, iesp_, istatc_, iys_, iba_, ibian_, ibjan_, ibjgp_, ipian_, ipjan_, ipjgp_, ipigp_, ipr_, ipc_, ipic_, 
  ipisp_, iprsp_, ipa_, lenyh_, lenyhm_, lenwk_, lreq_, lrat_, lrest_, lwmin_, moss_, msbj_, nslj_, ngp_, nlu_, nnz_, 
  nsp_, nzl_, nzu_, ilss_[34];
  real_8 rlss_[6], con0_, conmin_, ccmxj_, psmall_, rbig_, seth_;
} dlss01_;
static struct {
  int_4 iownd_[6], iowns_[6], icf_, ierpj_, iersl_, jcur_, jstart_, kflag_, l_, lyh_, lewt_, lacor_, lsavf_, lwm_, liwm_, 
  meth_, miter_, maxord_, maxcor_, msbp_, mxncf_, n_, nq_, nst_, nfe_, nje_, nqu_, init_, mxstep_, mxhnil_, nhnil_, 
  nslast_, nyh_, ils_[37], ialth_, ipup_, lmax_, meo_, nqnyh_, nslp_;
  real_8 rowns_[209], ccmax_, el0_, h_, hmin_, hmxi_, hu_, rc_, tn_, uround_, rls_[218], conit_, crate_, el_[13], 
  elco_[156], hold_, rmax_, tesco_[36];
} dls001_;
static struct {
  int_4 insufr_, insufi_, ixpr_, iowns2_[2], jtyp_, mused_, mxordn_, mxords_, iownd2_[3], ilsa_[9], icount_, irflag_;
  real_8 tsw_, rowns2_[20], pdnorm_, rownd2_, rlsa_[22], cm1_[12], cm2_[5], pdest_, pdlast_, ratio_;
} dlsa01_;
static struct {
  int_4 lg0_, lg1_, lgx_, iownr3_[2], irfnd_, itaskc_, ngc_, nge_, iownd3_[3], imax_, last_, idum3_[4], ilsr_[9];
  real_8 rownr3_[2], t0_, tlast_, toutc_, alpha_, x2_, rdum3_[3], rlsr_[5];
} dlsr01_;
static struct {
  int_4 newt_, nsfi_, nslj_, njev_, ils2_[4];
  real_8 stifr_, rls2_;
} dls002_;
static struct {
  int_4 jpre_, jacflg_, locwp_, lociwp_, lsavx_, kmp_, maxl_, mnewt_, nni_, nli_, nps_, ncfn_, ncfl_, ilsp_[13];
  real_8 delt_, epcon_, sqrtn_, rsqrtn_, rlsp_[4];
} dlpk01_;
prototype int_4 _adjlr (int_4 _p_ n_, int_4 _p_ isp_, int_4 _p_ ldif_);
prototype int_4 _cdrv (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ c_, int_4 _p_ ic_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 
_p_ a_, real_8 _p_ b_, real_8 _p_ z_, int_4 _p_ nsp_, int_4 _p_ isp_, real_8 _p_ rsp_, int_4 _p_ esp_, int_4 _p_ path_, 
int_4 _p_ flag_);
prototype int_4 _nroc (int_4 _p_ n_, int_4 _p_ ic_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ a_, int_4 _p_ jar_, real_8 
_p_ ar_, int_4 _p_ p_, int_4 _p_ flag_);
prototype int_4 _nsfc (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ ic_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ jlmax_, int_4 
_p_ il_, int_4 _p_ jl_, int_4 _p_ ijl_, int_4 _p_ jumax_, int_4 _p_ iu_, int_4 _p_ ju_, int_4 _p_ iju_, int_4 _p_ q_, 
int_4 _p_ ira_, int_4 _p_ jra_, int_4 _p_ irac_, int_4 _p_ irl_, int_4 _p_ jrl_, int_4 _p_ iru_, int_4 _p_ jru_, int_4 
_p_ flag_);
prototype int_4 _nnfc (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ c_, int_4 _p_ ic_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 
_p_ a_, real_8 _p_ z_, real_8 _p_ b_, int_4 _p_ lmax_, int_4 _p_ il_, int_4 _p_ jl_, int_4 _p_ ijl_, real_8 _p_ l_, 
real_8 _p_ d_, int_4 _p_ umax_, int_4 _p_ iu_, int_4 _p_ ju_, int_4 _p_ iju_, real_8 _p_ u_, real_8 _p_ row_, real_8 
_p_ tmp_, int_4 _p_ irl_, int_4 _p_ jrl_, int_4 _p_ flag_);
prototype int_4 _nnsc (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ c_, int_4 _p_ il_, int_4 _p_ jl_, int_4 _p_ ijl_, real_8 
_p_ l_, real_8 _p_ d_, int_4 _p_ iu_, int_4 _p_ ju_, int_4 _p_ iju_, real_8 _p_ u_, real_8 _p_ z_, real_8 _p_ b_, 
real_8 _p_ tmp_);
prototype int_4 _nntc (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ c_, int_4 _p_ il_, int_4 _p_ jl_, int_4 _p_ ijl_, real_8 
_p_ l_, real_8 _p_ d_, int_4 _p_ iu_, int_4 _p_ ju_, int_4 _p_ iju_, real_8 _p_ u_, real_8 _p_ z_, real_8 _p_ b_, 
real_8 _p_ tmp_);
prototype int_4 _cntnzu (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ nzsut_);
prototype int_4 _daigbt (int_4 (*_res)(), int_4 (*_adda)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ 
ydot_, int_4 _p_ mb_, int_4 _p_ nb_, real_8 _p_ pw_, int_4 _p_ ipvt_, int_4 _p_ ier_);
prototype int_4 _dainvg (int_4 (*_res)(), int_4 (*_adda)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ 
ydot_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ pw_, int_4 _p_ ipvt_, int_4 _p_ ier_);
prototype int_4 _dainvgs (int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ wk_, int_4 _p_ iwk_, real_8 _p_ tem_
, real_8 _p_ ydot_, int_4 _p_ ier_, int_4 (*_res)(), int_4 (*_adda)());
prototype int_4 _datp (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ p_, real_8 _p_ wght_, real_8 _p_ 
hl0_, real_8 _p_ wk_, int_4 (*_f)(), real_8 _p_ w_);
prototype int_4 _datv (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ v_, real_8 _p_ wght_, real_8 _p_ 
ftem_, int_4 (*_f)(), int_4 (*_psol)(), real_8 _p_ z_, real_8 _p_ vtem_, real_8 _p_ wp_, int_4 _p_ iwp_, real_8 _p_ 
hl0_, int_4 _p_ jpre_, int_4 _p_ ier_, int_4 _p_ npsl_);
prototype real_8 _dbnorm (int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ nra_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ w_);
prototype int_4 _dcfode (int_4 _p_ meth_, real_8 _p_ elco_, real_8 _p_ tesco_);
prototype int_4 _ddecbt (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, int_4 _p_ ip_, int_4 
_p_ ier_);
prototype int_4 _dewset (int_4 _p_ n_, int_4 _p_ itol_, real_8 _p_ rtol_, real_8 _p_ atol_, real_8 _p_ ycur_, real_8 
_p_ ewt_);
prototype real_8 _dfnorm (int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_);
prototype int_4 _dhefa (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_, int_4 _p_ job_);
prototype int_4 _dhels (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ q_, real_8 _p_ b_);
prototype int_4 _dheqr (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ q_, int_4 _p_ info_, int_4 _p_ ijob_);
prototype int_4 _dhesl (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ b_);
prototype int_4 _dintdy (real_8 _p_ t_, int_4 _p_ k_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ dky_, int_4 _p_ iflag_
);
prototype int_4 _diprep (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ rwork_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ 
ipflag_, real_4 (*_f)(), int_4 (*_jac)());
prototype int_4 _diprepi (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ s_, real_8 _p_ rwork_, int_4 _p_ ia_, int_4 _p_ ja_
, int_4 _p_ ic_, int_4 _p_ jc_, int_4 _p_ ipflag_, real_4 (*_res)(), int_4 (*_jac)(), real_4 (*_adda)());
prototype int_4 _dlhin (int_4 _p_ neq_, int_4 _p_ n_, real_8 _p_ t0_, real_8 _p_ y0_, real_8 _p_ ydot_, int_4 (*_f)(), 
real_8 _p_ tout_, real_8 _p_ uround_, real_8 _p_ ewt_, int_4 _p_ itol_, real_8 _p_ atol_, real_8 _p_ y_, real_8 _p_ 
temp_, real_8 _p_ h0_, int_4 _p_ niter_, int_4 _p_ ier_);
prototype int_4 _dlsoda (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_
, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 
_p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), int_4 _p_ jt_);
prototype int_4 _dlsodar (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ 
itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, 
int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), int_4 _p_ jt_, real_4 (*_g)(), int_4 _p_ ng_, int_4 
_p_ jroot_);
prototype int_4 _dlsode (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_
, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 
_p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), int_4 _p_ mf_);
prototype int_4 _dlsodes (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ 
itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, 
int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), int_4 _p_ mf_);
prototype int_4 _dlsoibt (int_4 (*_res)(), real_4 (*_adda)(), int_4 (*_jac)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 
_p_ ydoti_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, 
int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ mf_)
;
prototype int_4 _dlsodi (int_4 (*_res)(), real_4 (*_adda)(), int_4 (*_jac)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ 
ydoti_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 
_p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ mf_);
prototype int_4 _dlsodis (int_4 (*_res)(), real_4 (*_adda)(), int_4 (*_jac)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 
_p_ ydoti_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, 
int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ mf_)
;
prototype int_4 _dlsodkr (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ 
itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, 
int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), real_4 (*_psol)(), int_4 _p_ mf_, real_4 (*_g)(), 
int_4 _p_ ng_, int_4 _p_ jroot_);
prototype int_4 _dlsodpk (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ 
itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, 
int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), real_4 (*_psol)(), int_4 _p_ mf_);
prototype real_8 _dmnorm (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ w_);
prototype int_4 _dorthog (real_8 _p_ vnew_, real_8 _p_ v_, real_8 _p_ hes_, int_4 _p_ n_, int_4 _p_ ll_, int_4 _p_ 
ldhes_, int_4 _p_ kmp_, real_8 _p_ snormw_);
prototype int_4 _dpcg (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ r_, real_8 _p_ wght_
, int_4 _p_ n_, int_4 _p_ maxl_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ jpre_, int_4 _p_ mnewt_, real_4 (*_f)(), 
int_4 (*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 _p_ p_, real_8 _p_ w_, real_8 _p_ z_, int_4 _p_ lpcg_, real_8 
_p_ wp_, int_4 _p_ iwp_, real_8 _p_ wk_, int_4 _p_ iflag_);
prototype int_4 _dpcgs (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ r_, real_8 _p_ 
wght_, int_4 _p_ n_, int_4 _p_ maxl_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ jpre_, int_4 _p_ mnewt_, real_4 
(*_f)(), int_4 (*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 _p_ p_, real_8 _p_ w_, real_8 _p_ z_, int_4 _p_ lpcg_
, real_8 _p_ wp_, int_4 _p_ iwp_, real_8 _p_ wk_, int_4 _p_ iflag_);
prototype int_4 _dpjibt (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ 
rtem_, real_8 _p_ savr_, real_8 _p_ s_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), int_4 (*_jac)(), int_4 
(*_adda)());
prototype int_4 _dpkset (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ ysv_, real_8 _p_ ewt_, real_8 _p_ ftem_, real_8 _p_ 
savf_, real_8 _p_ wm_, int_4 _p_ iwm_, real_4 (*_f)(), int_4 (*_jac)());
prototype int_4 _dprep (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, real_8 _p_ savf_, real_8 _p_ ewt_, real_8 _p_ 
ftem_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ wk_, int_4 _p_ iwk_, int_4 _p_ ipper_, int_4 (*_f)(), int_4 (*_jac)());
prototype int_4 _dprepi (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ s_, real_8 _p_ yh_, real_8 _p_ savr_, real_8 _p_ 
ewt_, real_8 _p_ rtem_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ ic_, int_4 _p_ jc_, real_8 _p_ wk_, int_4 _p_ iwk_, 
int_4 _p_ ipper_, int_4 (*_res)(), int_4 (*_jac)(), int_4 (*_adda)());
prototype int_4 _dprepj (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ 
ftem_, real_8 _p_ savf_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)());
prototype int_4 _dprepji (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ 
rtem_, real_8 _p_ savr_, real_8 _p_ s_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), int_4 (*_jac)(), int_4 
(*_adda)());
prototype int_4 _dprja (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ 
ftem_, real_8 _p_ savf_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)());
prototype int_4 _dprjis (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ 
rtem_, real_8 _p_ savr_, real_8 _p_ s_, real_8 _p_ wk_, int_4 _p_ iwk_, int_4 (*_res)(), int_4 (*_jac)(), int_4 
(*_adda)());
prototype int_4 _dprjs (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ 
ftem_, real_8 _p_ savf_, real_8 _p_ wk_, int_4 _p_ iwk_, int_4 (*_f)(), int_4 (*_jac)());
prototype int_4 _drchek (int_4 _p_ job_, int_4 (*_g)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, 
real_8 _p_ g0_, real_8 _p_ g1_, real_8 _p_ gx_, int_4 _p_ jroot_, int_4 _p_ irt_);
prototype int_4 _droots (int_4 _p_ ng_, real_8 _p_ hmin_, int_4 _p_ jflag_, real_8 _p_ x0_, real_8 _p_ x1_, real_8 _p_ 
g0_, real_8 _p_ g1_, real_8 _p_ gx_, real_8 _p_ x_, int_4 _p_ jroot_);
prototype int_4 _dsetpk (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ ysv_, real_8 _p_ ewt_, real_8 _p_ ftem_, real_8 _p_ 
savf_, int_4 _p_ jok_, real_8 _p_ wm_, int_4 _p_ iwm_, real_4 (*_f)(), int_4 (*_jac)());
prototype int_4 _dslsbt (real_8 _p_ wm_, int_4 _p_ iwm_, real_8 _p_ x_, real_8 _p_ tem_);
prototype int_4 _dsolbt (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ y_, int_4 
_p_ ip_);
prototype int_4 _dsolpk (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ x_, real_8 _p_ ewt_, real_8 _p_ 
wm_, int_4 _p_ iwm_, real_4 (*_f)(), real_4 (*_psol)());
prototype int_4 _dsolss (real_8 _p_ wk_, int_4 _p_ iwk_, real_8 _p_ x_, real_8 _p_ tem_);
prototype int_4 _dsolsy (real_8 _p_ wm_, int_4 _p_ iwm_, real_8 _p_ x_, real_8 _p_ tem_);
prototype int_4 _dspigmr (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ b_, real_8 _p_ 
wght_, int_4 _p_ n_, int_4 _p_ maxl_, int_4 _p_ maxlp1_, int_4 _p_ kmp_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ 
jpre_, int_4 _p_ mnewt_, real_4 (*_f)(), int_4 (*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 _p_ v_, real_8 _p_ 
hes_, real_8 _p_ q_, int_4 _p_ lgmr_, real_8 _p_ wp_, int_4 _p_ iwp_, real_8 _p_ wk_, real_8 _p_ dl_, int_4 _p_ iflag_)
;
prototype int_4 _dspiom (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ b_, real_8 _p_ 
wght_, int_4 _p_ n_, int_4 _p_ maxl_, int_4 _p_ kmp_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ jpre_, int_4 _p_ 
mnewt_, real_4 (*_f)(), int_4 (*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 _p_ v_, real_8 _p_ hes_, int_4 _p_ 
ipvt_, int_4 _p_ liom_, real_8 _p_ wp_, int_4 _p_ iwp_, real_8 _p_ wk_, int_4 _p_ iflag_);
prototype int_4 _dsrcar (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_);
prototype int_4 _dsrckr (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_);
prototype int_4 _dsrcma (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_);
prototype int_4 _dsrcms (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_);
prototype int_4 _dsrcom (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_);
prototype int_4 _dsrcpk (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_);
prototype int_4 _dstoda (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ 
ewt_, real_8 _p_ savf_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)(), int_4 
(*_pjac)(), int_4 (*_slvs)());
prototype int_4 _dstode (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ 
ewt_, real_8 _p_ savf_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)(), int_4 
(*_pjac)(), int_4 (*_slvs)());
prototype int_4 _dstodi (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ 
ewt_, real_8 _p_ savf_, real_8 _p_ savr_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), real_4 
(*_adda)(), int_4 (*_jac)(), int_4 (*_pjac)(), int_4 (*_slvs)());
prototype int_4 _dstodpk (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ 
ewt_, real_8 _p_ savf_, real_8 _p_ savx_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 
(*_jac)(), real_4 (*_psol)());
prototype int_4 _dstoka (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ 
ewt_, real_8 _p_ savf_, real_8 _p_ savx_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 
(*_jac)(), real_4 (*_psol)());
prototype real_8 _dumach (void);
prototype int_4 _dumsum (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_);
prototype int_4 _dusol (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ b_, real_8 _p_ 
wght_, int_4 _p_ n_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ mnewt_, int_4 (*_psol)(), int_4 _p_ npsl_, real_8 
_p_ x_, real_8 _p_ wp_, int_4 _p_ iwp_, real_8 _p_ wk_, int_4 _p_ iflag_);
prototype real_8 _dvnorm (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ w_);
prototype int_4 _iumach (void);
prototype int_4 _ixsav (int_4 _p_ ipar_, int_4 _p_ ivalue_, logical_4 _p_ iset_);
prototype int_4 _jgroup (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ maxg_, int_4 _p_ ngrp_, int_4 _p_ igp_, 
int_4 _p_ jgp_, int_4 _p_ incl_, int_4 _p_ jdone_, int_4 _p_ ier_);
prototype int_4 _odrv (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ a_, int_4 _p_ p_, int_4 _p_ ip_, int_4 
_p_ nsp_, int_4 _p_ isp_, int_4 _p_ path_, int_4 _p_ flag_);
prototype int_4 _md (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ max_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ 
head_, int_4 _p_ last_, int_4 _p_ next_, int_4 _p_ mark_, int_4 _p_ flag_);
prototype int_4 _mdi (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ max_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ 
head_, int_4 _p_ last_, int_4 _p_ next_, int_4 _p_ mark_, int_4 _p_ tag_, int_4 _p_ flag_);
prototype int_4 _mdm (int_4 _p_ vk_, int_4 _p_ tail_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ last_, int_4 _p_ next_, 
int_4 _p_ mark_);
prototype int_4 _mdp (int_4 _p_ k_, int_4 _p_ ek_, int_4 _p_ tail_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ head_, int_4 
_p_ last_, int_4 _p_ next_, int_4 _p_ mark_);
prototype int_4 _mdu (int_4 _p_ ek_, int_4 _p_ dmin_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ head_, int_4 _p_ last_, 
int_4 _p_ next_, int_4 _p_ mark_);
prototype int_4 _sro (int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ a_, int_4 _p_ q_, int_4 _p_ 
r_, logical_4 _p_ dflag_);
prototype int_4 _xerrwd (char _p_ msg_, int_4 _p_ nmes_, int_4 _p_ nerr_, int_4 _p_ level_, int_4 _p_ ni_, int_4 _p_ 
i1_, int_4 _p_ i2_, int_4 _p_ nr_, real_8 _p_ r1_, real_8 _p_ r2_);
int_4 _adjlr (int_4 _p_ n_, int_4 _p_ isp_, int_4 _p_ ldif_)
{
  static int_4 ip_, jlmax_, jumax_, lnfc_, lsfc_, nzlu_;
  ip_ = 2 * (*n_) + 1;
  jlmax_ = isp_[ip_ - 1];
  jumax_ = isp_[ip_ + ip_ - 1];
  nzlu_ = isp_[(*n_) + 1 - 1] - isp_[0] + isp_[ip_ + (*n_) + 1 - 1] - isp_[ip_ + 1 - 1];
  lsfc_ = 12 * (*n_) + 3 + 2 * _max (jlmax_, jumax_);
  lnfc_ = 9 * (*n_) + 2 + jlmax_ + jumax_ + nzlu_;
  (*ldif_) = _max (0, lsfc_ - lnfc_);
  __calls[0].calls++;
  return 0;
}

int_4 _cdrv (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ c_, int_4 _p_ ic_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ a_, 
real_8 _p_ b_, real_8 _p_ z_, int_4 _p_ nsp_, int_4 _p_ isp_, real_8 _p_ rsp_, int_4 _p_ esp_, int_4 _p_ path_, int_4 
_p_ flag_)
{
  static int_4 d_, u_, q_, row_, tmp_, ar_, umax_, lratio_, il_, ijl_, iu_, iju_, irl_, jrl_, jl_, max_, jlmax_, ira_, 
  jra_, irac_, iru_, jru_, jutmp_, jumax_, i_, ju_, j_, l_, lmax_;
  int_4 _data_k_0;
#define _data_n_0 1
  static int_4 _data_l_0[_data_n_0] = {
    2
  };
  if (__calls[1].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    lratio_ = _data_l_0[_data_k_0++];
  }
  if ((*path_) < 1 || 5 < (*path_)) {
    goto _l111;
  }
  il_ = 1;
  ijl_ = il_ + ((*n_) + 1);
  iu_ = ijl_ + (*n_);
  iju_ = iu_ + ((*n_) + 1);
  irl_ = iju_ + (*n_);
  jrl_ = irl_ + (*n_);
  jl_ = jrl_ + (*n_);
  if (((*path_) - 1) * ((*path_) - 5) != 0) {
    goto _l5;
  }
  max_ = (lratio_ * (*nsp_) + 1 - jl_) - ((*n_) + 1) - 5 * (*n_);
  jlmax_ = max_ / 2;
  q_ = jl_ + jlmax_;
  ira_ = q_ + ((*n_) + 1);
  jra_ = ira_ + (*n_);
  irac_ = jra_ + (*n_);
  iru_ = irac_ + (*n_);
  jru_ = iru_ + (*n_);
  jutmp_ = jru_ + (*n_);
  jumax_ = lratio_ * (*nsp_) + 1 - jutmp_;
  (*esp_) = max_ / lratio_;
  if (jlmax_ <= 0 || jumax_ <= 0) {
    goto _l110;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (c_[i_ - 1] != i_) {
      goto _l2;
    }
  }
  goto _l3;
  _l2:;
  ar_ = (*nsp_) + 1 - (*n_);
  (void) _nroc (n_, ic_, ia_, ja_, a_, &isp_[il_ - 1], &rsp_[ar_ - 1], &isp_[iu_ - 1], flag_);
  if ((*flag_) != 0) {
    goto _l100;
  }
  _l3:;
  (void) _nsfc (n_, r_, ic_, ia_, ja_, &jlmax_, &isp_[il_ - 1], &isp_[jl_ - 1], &isp_[ijl_ - 1], &jumax_, &isp_[iu_ - 1], 
  &isp_[jutmp_ - 1], &isp_[iju_ - 1], &isp_[q_ - 1], &isp_[ira_ - 1], &isp_[jra_ - 1], &isp_[irac_ - 1], &isp_[irl_ - 1], 
  &isp_[jrl_ - 1], &isp_[iru_ - 1], &isp_[jru_ - 1], flag_);
  if ((*flag_) != 0) {
    goto _l100;
  }
  jlmax_ = isp_[ijl_ + (*n_) - 1 - 1];
  ju_ = jl_ + jlmax_;
  jumax_ = isp_[iju_ + (*n_) - 1 - 1];
  if (jumax_ <= 0) {
    goto _l5;
  }
  for (j_ = 1; j_ <= jumax_; (j_)++) {
    isp_[ju_ + j_ - 1 - 1] = isp_[jutmp_ + j_ - 1 - 1];
  }
  _l5:;
  jlmax_ = isp_[ijl_ + (*n_) - 1 - 1];
  ju_ = jl_ + jlmax_;
  jumax_ = isp_[iju_ + (*n_) - 1 - 1];
  l_ = (ju_ + jumax_ - 2 + lratio_) / lratio_ + 1;
  lmax_ = isp_[il_ + (*n_) - 1] - 1;
  d_ = l_ + lmax_;
  u_ = d_ + (*n_);
  row_ = (*nsp_) + 1 - (*n_);
  tmp_ = row_ - (*n_);
  umax_ = tmp_ - u_;
  (*esp_) = umax_ - (isp_[iu_ + (*n_) - 1] - 1);
  if (((*path_) - 1) * ((*path_) - 2) != 0) {
    goto _l6;
  }
  if (umax_ < 0) {
    goto _l110;
  }
  (void) _nnfc (n_, r_, c_, ic_, ia_, ja_, a_, z_, b_, &lmax_, &isp_[il_ - 1], &isp_[jl_ - 1], &isp_[ijl_ - 1], &rsp_[l_ 
  - 1], &rsp_[d_ - 1], &umax_, &isp_[iu_ - 1], &isp_[ju_ - 1], &isp_[iju_ - 1], &rsp_[u_ - 1], &rsp_[row_ - 1], 
  &rsp_[tmp_ - 1], &isp_[irl_ - 1], &isp_[jrl_ - 1], flag_);
  if ((*flag_) != 0) {
    goto _l100;
  }
  _l6:;
  if (((*path_) - 3) != 0) {
    goto _l7;
  }
  (void) _nnsc (n_, r_, c_, &isp_[il_ - 1], &isp_[jl_ - 1], &isp_[ijl_ - 1], &rsp_[l_ - 1], &rsp_[d_ - 1], &isp_[iu_ - 
  1], &isp_[ju_ - 1], &isp_[iju_ - 1], &rsp_[u_ - 1], z_, b_, &rsp_[tmp_ - 1]);
  _l7:;
  if (((*path_) - 4) != 0) {
    goto _l8;
  }
  (void) _nntc (n_, r_, c_, &isp_[il_ - 1], &isp_[jl_ - 1], &isp_[ijl_ - 1], &rsp_[l_ - 1], &rsp_[d_ - 1], &isp_[iu_ - 
  1], &isp_[ju_ - 1], &isp_[iju_ - 1], &rsp_[u_ - 1], z_, b_, &rsp_[tmp_ - 1]);
  _l8:;
  goto _l0;
  _l100:;
  goto _l0;
  _l110:;
  (*flag_) = 10 * (*n_) + 1;
  goto _l0;
  _l111:;
  (*flag_) = 11 * (*n_) + 1;
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _nroc (int_4 _p_ n_, int_4 _p_ ic_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ a_, int_4 _p_ jar_, real_8 _p_ ar_, 
int_4 _p_ p_, int_4 _p_ flag_)
{
  static int_4 k_, jmin_, jmax_, j_, newj_, i_;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    jmin_ = ia_[k_ - 1];
    jmax_ = ia_[k_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l5;
    }
    p_[(*n_) + 1 - 1] = (*n_) + 1;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      newj_ = ic_[ja_[j_ - 1] - 1];
      i_ = (*n_) + 1;
      _l1:;
      if (p_[i_ - 1] >= newj_) {
        goto _l2;
      }
      i_ = p_[i_ - 1];
      goto _l1;
      _l2:;
      if (p_[i_ - 1] == newj_) {
        goto _l102;
      }
      p_[newj_ - 1] = p_[i_ - 1];
      p_[i_ - 1] = newj_;
      jar_[newj_ - 1] = ja_[j_ - 1];
      ar_[newj_ - 1] = a_[j_ - 1];
    }
    i_ = (*n_) + 1;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      i_ = p_[i_ - 1];
      ja_[j_ - 1] = jar_[i_ - 1];
      a_[j_ - 1] = ar_[i_ - 1];
    }
    _l5:;
  }
  (*flag_) = 0;
  goto _l0;
  _l102:;
  (*flag_) = (*n_) + k_;
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _nsfc (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ ic_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ jlmax_, int_4 _p_ il_, 
int_4 _p_ jl_, int_4 _p_ ijl_, int_4 _p_ jumax_, int_4 _p_ iu_, int_4 _p_ ju_, int_4 _p_ iju_, int_4 _p_ q_, int_4 _p_ 
ira_, int_4 _p_ jra_, int_4 _p_ irac_, int_4 _p_ irl_, int_4 _p_ jrl_, int_4 _p_ iru_, int_4 _p_ jru_, int_4 _p_ flag_)
{
  static int_4 cend_, qm_, rend_, rk_, vj_, np1_, jlmin_, jlptr_, jumin_, juptr_, k_, iak_, jaiak_, luk_, m_, lastid_, 
  lasti_, i_, jmin_, jmax_, long_, jtmp_, j_, irll_, i1_, irul_, irai_, jairai_;
  int_4 $0_, $1_;
  np1_ = (*n_) + 1;
  jlmin_ = 1;
  jlptr_ = 0;
  il_[0] = 1;
  jumin_ = 1;
  juptr_ = 0;
  iu_[0] = 1;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    irac_[k_ - 1] = 0;
    jra_[k_ - 1] = 0;
    jrl_[k_ - 1] = 0;
    jru_[k_ - 1] = 0;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    rk_ = r_[k_ - 1];
    iak_ = ia_[rk_ - 1];
    if (iak_ >= ia_[rk_ + 1 - 1]) {
      goto _l101;
    }
    jaiak_ = ic_[ja_[iak_ - 1] - 1];
    if (jaiak_ > k_) {
      goto _l105;
    }
    jra_[k_ - 1] = irac_[jaiak_ - 1];
    irac_[jaiak_ - 1] = k_;
    ira_[k_ - 1] = iak_;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    q_[np1_ - 1] = np1_;
    luk_ = -1;
    vj_ = irac_[k_ - 1];
    if (vj_ == 0) {
      goto _l5;
    }
    _l3:;
    qm_ = np1_;
    _l4:;
    m_ = qm_;
    qm_ = q_[m_ - 1];
    if (qm_ < vj_) {
      goto _l4;
    }
    if (qm_ == vj_) {
      goto _l102;
    }
    luk_ = luk_ + 1;
    q_[m_ - 1] = vj_;
    q_[vj_ - 1] = qm_;
    vj_ = jra_[vj_ - 1];
    if (vj_ != 0) {
      goto _l3;
    }
    _l5:;
    lastid_ = 0;
    lasti_ = 0;
    ijl_[k_ - 1] = jlptr_;
    i_ = k_;
    _l6:;
    i_ = jru_[i_ - 1];
    if (i_ == 0) {
      goto _l10;
    }
    qm_ = np1_;
    jmin_ = irl_[i_ - 1];
    jmax_ = ijl_[i_ - 1] + il_[i_ + 1 - 1] - il_[i_ - 1] - 1;
    long_ = jmax_ - jmin_;
    if (long_ < 0) {
      goto _l6;
    }
    jtmp_ = jl_[jmin_ - 1];
    if (jtmp_ != k_) {
      long_ = long_ + 1;
    }
    if (jtmp_ == k_) {
      r_[i_ - 1] = -r_[i_ - 1];
    }
    if (lastid_ >= long_) {
      goto _l7;
    }
    lasti_ = i_;
    lastid_ = long_;
    _l7:;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      vj_ = jl_[j_ - 1];
      _l8:;
      m_ = qm_;
      qm_ = q_[m_ - 1];
      if (qm_ < vj_) {
        goto _l8;
      }
      if (qm_ == vj_) {
        goto _l9;
      }
      luk_ = luk_ + 1;
      q_[m_ - 1] = vj_;
      q_[vj_ - 1] = qm_;
      qm_ = vj_;
      _l9:;
    }
    goto _l6;
    _l10:;
    qm_ = q_[np1_ - 1];
    if (qm_ != k_) {
      goto _l105;
    }
    if (luk_ == 0) {
      goto _l17;
    }
    if (lastid_ != luk_) {
      goto _l11;
    }
    irll_ = irl_[lasti_ - 1];
    ijl_[k_ - 1] = irll_ + 1;
    if (jl_[irll_ - 1] != k_) {
      ijl_[k_ - 1] = ijl_[k_ - 1] - 1;
    }
    goto _l17;
    _l11:;
    if (jlmin_ > jlptr_) {
      goto _l15;
    }
    qm_ = q_[qm_ - 1];
    for (j_ = jlmin_; j_ <= jlptr_; (j_)++) {
      $0_ = jl_[j_ - 1] - qm_;
      if ($0_ < 0) {
        goto _l12;
      } else if ($0_ == 0) {
        goto _l13;
      } else {
        goto _l15;
      }
      _l12:;
    }
    goto _l15;
    _l13:;
    ijl_[k_ - 1] = j_;
    for (i_ = j_; i_ <= jlptr_; (i_)++) {
      if (jl_[i_ - 1] != qm_) {
        goto _l15;
      }
      qm_ = q_[qm_ - 1];
      if (qm_ > (*n_)) {
        goto _l17;
      }
    }
    jlptr_ = j_ - 1;
    _l15:;
    jlmin_ = jlptr_ + 1;
    ijl_[k_ - 1] = jlmin_;
    if (luk_ == 0) {
      goto _l17;
    }
    jlptr_ = jlptr_ + luk_;
    if (jlptr_ > (*jlmax_)) {
      goto _l103;
    }
    qm_ = q_[np1_ - 1];
    for (j_ = jlmin_; j_ <= jlptr_; (j_)++) {
      qm_ = q_[qm_ - 1];
      jl_[j_ - 1] = qm_;
    }
    _l17:;
    irl_[k_ - 1] = ijl_[k_ - 1];
    il_[k_ + 1 - 1] = il_[k_ - 1] + luk_;
    q_[np1_ - 1] = np1_;
    luk_ = -1;
    rk_ = r_[k_ - 1];
    jmin_ = ira_[k_ - 1];
    jmax_ = ia_[rk_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l20;
    }
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      vj_ = ic_[ja_[j_ - 1] - 1];
      qm_ = np1_;
      _l18:;
      m_ = qm_;
      qm_ = q_[m_ - 1];
      if (qm_ < vj_) {
        goto _l18;
      }
      if (qm_ == vj_) {
        goto _l102;
      }
      luk_ = luk_ + 1;
      q_[m_ - 1] = vj_;
      q_[vj_ - 1] = qm_;
    }
    _l20:;
    lastid_ = 0;
    lasti_ = 0;
    iju_[k_ - 1] = juptr_;
    i_ = k_;
    i1_ = jrl_[k_ - 1];
    _l21:;
    i_ = i1_;
    if (i_ == 0) {
      goto _l26;
    }
    i1_ = jrl_[i_ - 1];
    qm_ = np1_;
    jmin_ = iru_[i_ - 1];
    jmax_ = iju_[i_ - 1] + iu_[i_ + 1 - 1] - iu_[i_ - 1] - 1;
    long_ = jmax_ - jmin_;
    if (long_ < 0) {
      goto _l21;
    }
    jtmp_ = ju_[jmin_ - 1];
    if (jtmp_ == k_) {
      goto _l22;
    }
    long_ = long_ + 1;
    cend_ = ijl_[i_ - 1] + il_[i_ + 1 - 1] - il_[i_ - 1];
    irl_[i_ - 1] = irl_[i_ - 1] + 1;
    if (irl_[i_ - 1] >= cend_) {
      goto _l22;
    }
    j_ = jl_[irl_[i_ - 1] - 1];
    jrl_[i_ - 1] = jrl_[j_ - 1];
    jrl_[j_ - 1] = i_;
    _l22:;
    if (lastid_ >= long_) {
      goto _l23;
    }
    lasti_ = i_;
    lastid_ = long_;
    _l23:;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      vj_ = ju_[j_ - 1];
      _l24:;
      m_ = qm_;
      qm_ = q_[m_ - 1];
      if (qm_ < vj_) {
        goto _l24;
      }
      if (qm_ == vj_) {
        goto _l25;
      }
      luk_ = luk_ + 1;
      q_[m_ - 1] = vj_;
      q_[vj_ - 1] = qm_;
      qm_ = vj_;
      _l25:;
    }
    goto _l21;
    _l26:;
    if (il_[k_ + 1 - 1] <= il_[k_ - 1]) {
      goto _l27;
    }
    j_ = jl_[irl_[k_ - 1] - 1];
    jrl_[k_ - 1] = jrl_[j_ - 1];
    jrl_[j_ - 1] = k_;
    _l27:;
    qm_ = q_[np1_ - 1];
    if (qm_ != k_) {
      goto _l105;
    }
    if (luk_ == 0) {
      goto _l34;
    }
    if (lastid_ != luk_) {
      goto _l28;
    }
    irul_ = iru_[lasti_ - 1];
    iju_[k_ - 1] = irul_ + 1;
    if (ju_[irul_ - 1] != k_) {
      iju_[k_ - 1] = iju_[k_ - 1] - 1;
    }
    goto _l34;
    _l28:;
    if (jumin_ > juptr_) {
      goto _l32;
    }
    qm_ = q_[qm_ - 1];
    for (j_ = jumin_; j_ <= juptr_; (j_)++) {
      $1_ = ju_[j_ - 1] - qm_;
      if ($1_ < 0) {
        goto _l29;
      } else if ($1_ == 0) {
        goto _l30;
      } else {
        goto _l32;
      }
      _l29:;
    }
    goto _l32;
    _l30:;
    iju_[k_ - 1] = j_;
    for (i_ = j_; i_ <= juptr_; (i_)++) {
      if (ju_[i_ - 1] != qm_) {
        goto _l32;
      }
      qm_ = q_[qm_ - 1];
      if (qm_ > (*n_)) {
        goto _l34;
      }
    }
    juptr_ = j_ - 1;
    _l32:;
    jumin_ = juptr_ + 1;
    iju_[k_ - 1] = jumin_;
    if (luk_ == 0) {
      goto _l34;
    }
    juptr_ = juptr_ + luk_;
    if (juptr_ > (*jumax_)) {
      goto _l106;
    }
    qm_ = q_[np1_ - 1];
    for (j_ = jumin_; j_ <= juptr_; (j_)++) {
      qm_ = q_[qm_ - 1];
      ju_[j_ - 1] = qm_;
    }
    _l34:;
    iru_[k_ - 1] = iju_[k_ - 1];
    iu_[k_ + 1 - 1] = iu_[k_ - 1] + luk_;
    i_ = k_;
    _l35:;
    i1_ = jru_[i_ - 1];
    if (r_[i_ - 1] < 0) {
      goto _l36;
    }
    rend_ = iju_[i_ - 1] + iu_[i_ + 1 - 1] - iu_[i_ - 1];
    if (iru_[i_ - 1] >= rend_) {
      goto _l37;
    }
    j_ = ju_[iru_[i_ - 1] - 1];
    jru_[i_ - 1] = jru_[j_ - 1];
    jru_[j_ - 1] = i_;
    goto _l37;
    _l36:;
    r_[i_ - 1] = -r_[i_ - 1];
    _l37:;
    i_ = i1_;
    if (i_ == 0) {
      goto _l38;
    }
    iru_[i_ - 1] = iru_[i_ - 1] + 1;
    goto _l35;
    _l38:;
    i_ = irac_[k_ - 1];
    if (i_ == 0) {
      goto _l41;
    }
    _l39:;
    i1_ = jra_[i_ - 1];
    ira_[i_ - 1] = ira_[i_ - 1] + 1;
    if (ira_[i_ - 1] >= ia_[r_[i_ - 1] + 1 - 1]) {
      goto _l40;
    }
    irai_ = ira_[i_ - 1];
    jairai_ = ic_[ja_[irai_ - 1] - 1];
    if (jairai_ > i_) {
      goto _l40;
    }
    jra_[i_ - 1] = irac_[jairai_ - 1];
    irac_[jairai_ - 1] = i_;
    _l40:;
    i_ = i1_;
    if (i_ != 0) {
      goto _l39;
    }
    _l41:;
  }
  ijl_[(*n_) - 1] = jlptr_;
  iju_[(*n_) - 1] = juptr_;
  (*flag_) = 0;
  goto _l0;
  _l101:;
  (*flag_) = (*n_) + rk_;
  goto _l0;
  _l102:;
  (*flag_) = 2 * (*n_) + rk_;
  goto _l0;
  _l103:;
  (*flag_) = 3 * (*n_) + k_;
  goto _l0;
  _l105:;
  (*flag_) = 5 * (*n_) + k_;
  goto _l0;
  _l106:;
  (*flag_) = 6 * (*n_) + k_;
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _nnfc (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ c_, int_4 _p_ ic_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ a_, 
real_8 _p_ z_, real_8 _p_ b_, int_4 _p_ lmax_, int_4 _p_ il_, int_4 _p_ jl_, int_4 _p_ ijl_, real_8 _p_ l_, real_8 _p_ 
d_, int_4 _p_ umax_, int_4 _p_ iu_, int_4 _p_ ju_, int_4 _p_ iju_, real_8 _p_ u_, real_8 _p_ row_, real_8 _p_ tmp_, 
int_4 _p_ irl_, int_4 _p_ jrl_, int_4 _p_ flag_)
{
  static int_4 rk_, k_, i1_, i_, i2_, jmin_, jmax_, j_, mu_, ijlb_;
  static real_8 lki_, sum_, dk_;
  if (il_[(*n_) + 1 - 1] - 1 > (*lmax_)) {
    goto _l104;
  }
  if (iu_[(*n_) + 1 - 1] - 1 > (*umax_)) {
    goto _l107;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    irl_[k_ - 1] = il_[k_ - 1];
    jrl_[k_ - 1] = 0;
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    row_[k_ - 1] = 0;
    i1_ = 0;
    if (jrl_[k_ - 1] == 0) {
      goto _l3;
    }
    i_ = jrl_[k_ - 1];
    _l2:;
    i2_ = jrl_[i_ - 1];
    jrl_[i_ - 1] = i1_;
    i1_ = i_;
    row_[i_ - 1] = 0;
    i_ = i2_;
    if (i_ != 0) {
      goto _l2;
    }
    _l3:;
    jmin_ = iju_[k_ - 1];
    jmax_ = jmin_ + iu_[k_ + 1 - 1] - iu_[k_ - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l5;
    }
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      row_[ju_[j_ - 1] - 1] = 0;
    }
    _l5:;
    rk_ = r_[k_ - 1];
    jmin_ = ia_[rk_ - 1];
    jmax_ = ia_[rk_ + 1 - 1] - 1;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      row_[ic_[ja_[j_ - 1] - 1] - 1] = a_[j_ - 1];
    }
    sum_ = b_[rk_ - 1];
    i_ = i1_;
    if (i_ == 0) {
      goto _l10;
    }
    _l7:;
    lki_ = -row_[i_ - 1];
    l_[irl_[i_ - 1] - 1] = -lki_;
    sum_ = sum_ + lki_ * tmp_[i_ - 1];
    jmin_ = iu_[i_ - 1];
    jmax_ = iu_[i_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l9;
    }
    mu_ = iju_[i_ - 1] - jmin_;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      row_[ju_[mu_ + j_ - 1] - 1] = row_[ju_[mu_ + j_ - 1] - 1] + lki_ * u_[j_ - 1];
    }
    _l9:;
    i_ = jrl_[i_ - 1];
    if (i_ != 0) {
      goto _l7;
    }
    _l10:;
    if (row_[k_ - 1] == 0.0e0) {
      goto _l108;
    }
    dk_ = 1.0e0 / row_[k_ - 1];
    d_[k_ - 1] = dk_;
    tmp_[k_ - 1] = sum_ * dk_;
    if (k_ == (*n_)) {
      goto _l19;
    }
    jmin_ = iu_[k_ - 1];
    jmax_ = iu_[k_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l12;
    }
    mu_ = iju_[k_ - 1] - jmin_;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      u_[j_ - 1] = row_[ju_[mu_ + j_ - 1] - 1] * dk_;
    }
    _l12:;
    i_ = i1_;
    if (i_ == 0) {
      goto _l18;
    }
    _l14:;
    irl_[i_ - 1] = irl_[i_ - 1] + 1;
    i1_ = jrl_[i_ - 1];
    if (irl_[i_ - 1] >= il_[i_ + 1 - 1]) {
      goto _l17;
    }
    ijlb_ = irl_[i_ - 1] - il_[i_ - 1] + ijl_[i_ - 1];
    j_ = jl_[ijlb_ - 1];
    _l15:;
    if (i_ > jrl_[j_ - 1]) {
      goto _l16;
    }
    j_ = jrl_[j_ - 1];
    goto _l15;
    _l16:;
    jrl_[i_ - 1] = jrl_[j_ - 1];
    jrl_[j_ - 1] = i_;
    _l17:;
    i_ = i1_;
    if (i_ != 0) {
      goto _l14;
    }
    _l18:;
    if (irl_[k_ - 1] >= il_[k_ + 1 - 1]) {
      goto _l19;
    }
    j_ = jl_[ijl_[k_ - 1] - 1];
    jrl_[k_ - 1] = jrl_[j_ - 1];
    jrl_[j_ - 1] = k_;
    _l19:;
  }
  k_ = (*n_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sum_ = tmp_[k_ - 1];
    jmin_ = iu_[k_ - 1];
    jmax_ = iu_[k_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l21;
    }
    mu_ = iju_[k_ - 1] - jmin_;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      sum_ = sum_ - u_[j_ - 1] * tmp_[ju_[mu_ + j_ - 1] - 1];
    }
    _l21:;
    tmp_[k_ - 1] = sum_;
    z_[c_[k_ - 1] - 1] = sum_;
    k_ = k_ - 1;
  }
  (*flag_) = 0;
  goto _l0;
  _l104:;
  (*flag_) = 4 * (*n_) + 1;
  goto _l0;
  _l107:;
  (*flag_) = 7 * (*n_) + 1;
  goto _l0;
  _l108:;
  (*flag_) = 8 * (*n_) + k_;
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _nnsc (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ c_, int_4 _p_ il_, int_4 _p_ jl_, int_4 _p_ ijl_, real_8 _p_ l_, 
real_8 _p_ d_, int_4 _p_ iu_, int_4 _p_ ju_, int_4 _p_ iju_, real_8 _p_ u_, real_8 _p_ z_, real_8 _p_ b_, real_8 _p_ 
tmp_)
{
  static int_4 k_, jmin_, jmax_, ml_, j_, i_, mu_;
  static real_8 tmpk_, sum_;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    tmp_[k_ - 1] = b_[r_[k_ - 1] - 1];
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    jmin_ = il_[k_ - 1];
    jmax_ = il_[k_ + 1 - 1] - 1;
    tmpk_ = -d_[k_ - 1] * tmp_[k_ - 1];
    tmp_[k_ - 1] = -tmpk_;
    if (jmin_ > jmax_) {
      goto _l3;
    }
    ml_ = ijl_[k_ - 1] - jmin_;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      tmp_[jl_[ml_ + j_ - 1] - 1] = tmp_[jl_[ml_ + j_ - 1] - 1] + tmpk_ * l_[j_ - 1];
    }
    _l3:;
  }
  k_ = (*n_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sum_ = -tmp_[k_ - 1];
    jmin_ = iu_[k_ - 1];
    jmax_ = iu_[k_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l5;
    }
    mu_ = iju_[k_ - 1] - jmin_;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      sum_ = sum_ + u_[j_ - 1] * tmp_[ju_[mu_ + j_ - 1] - 1];
    }
    _l5:;
    tmp_[k_ - 1] = -sum_;
    z_[c_[k_ - 1] - 1] = -sum_;
    k_ = k_ - 1;
  }
  __calls[5].calls++;
  return 0;
}

int_4 _nntc (int_4 _p_ n_, int_4 _p_ r_, int_4 _p_ c_, int_4 _p_ il_, int_4 _p_ jl_, int_4 _p_ ijl_, real_8 _p_ l_, 
real_8 _p_ d_, int_4 _p_ iu_, int_4 _p_ ju_, int_4 _p_ iju_, real_8 _p_ u_, real_8 _p_ z_, real_8 _p_ b_, real_8 _p_ 
tmp_)
{
  static int_4 k_, jmin_, jmax_, mu_, j_, i_, ml_;
  static real_8 tmpk_, sum_;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    tmp_[k_ - 1] = b_[c_[k_ - 1] - 1];
  }
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    jmin_ = iu_[k_ - 1];
    jmax_ = iu_[k_ + 1 - 1] - 1;
    tmpk_ = -tmp_[k_ - 1];
    if (jmin_ > jmax_) {
      goto _l3;
    }
    mu_ = iju_[k_ - 1] - jmin_;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      tmp_[ju_[mu_ + j_ - 1] - 1] = tmp_[ju_[mu_ + j_ - 1] - 1] + tmpk_ * u_[j_ - 1];
    }
    _l3:;
  }
  k_ = (*n_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sum_ = -tmp_[k_ - 1];
    jmin_ = il_[k_ - 1];
    jmax_ = il_[k_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l5;
    }
    ml_ = ijl_[k_ - 1] - jmin_;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      sum_ = sum_ + l_[j_ - 1] * tmp_[jl_[ml_ + j_ - 1] - 1];
    }
    _l5:;
    tmp_[k_ - 1] = -sum_ * d_[k_ - 1];
    z_[r_[k_ - 1] - 1] = tmp_[k_ - 1];
    k_ = k_ - 1;
  }
  __calls[6].calls++;
  return 0;
}

int_4 _cntnzu (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ nzsut_)
{
  static int_4 ii_, jj_, j_, jmin_, jmax_, k_, kmin_, kmax_, num_;
  int_4 $0_;
  num_ = 0;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    jmin_ = ia_[ii_ - 1];
    jmax_ = ia_[ii_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l50;
    }
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      $0_ = ja_[j_ - 1] - ii_;
      if ($0_ < 0) {
        goto _l10;
      } else if ($0_ == 0) {
        goto _l40;
      } else {
        goto _l30;
      }
      _l10:;
      jj_ = ja_[j_ - 1];
      kmin_ = ia_[jj_ - 1];
      kmax_ = ia_[jj_ + 1 - 1] - 1;
      if (kmin_ > kmax_) {
        goto _l30;
      }
      for (k_ = kmin_; k_ <= kmax_; (k_)++) {
        if (ja_[k_ - 1] == ii_) {
          goto _l40;
        }
      }
      _l30:;
      num_ = num_ + 1;
      _l40:;
    }
    _l50:;
  }
  (*nzsut_) = num_;
  __calls[7].calls++;
  return 0;
}

int_4 _daigbt (int_4 (*_res)(), int_4 (*_adda)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ ydot_, int_4 
_p_ mb_, int_4 _p_ nb_, real_8 _p_ pw_, int_4 _p_ ipvt_, int_4 _p_ ier_)
{
  static int_4 i_, lenpw_, lblox_, lpb_, lpc_;
  lblox_ = (*mb_) * (*mb_) * (*nb_);
  lpb_ = 1 + lblox_;
  lpc_ = lpb_ + lblox_;
  lenpw_ = 3 * lblox_;
  for (i_ = 1; i_ <= lenpw_; (i_)++) {
    pw_[i_ - 1] = 0.0;
  }
  (*ier_) = 1;
  (void) _res (neq_, t_, y_, pw_, ydot_, ier_);
  if ((*ier_) > 1) {
    goto _l0;
  }
  (void) _adda (neq_, t_, y_, mb_, nb_, &pw_[0], &pw_[lpb_ - 1], &pw_[lpc_ - 1]);
  (void) _ddecbt (mb_, nb_, pw_, &pw_[lpb_ - 1], &pw_[lpc_ - 1], ipvt_, ier_);
  if ((*ier_) == 0) {
    goto _l20;
  }
  (*ier_) = -(*ier_);
  goto _l0;
  _l20:;
  (void) _dsolbt (mb_, nb_, pw_, &pw_[lpb_ - 1], &pw_[lpc_ - 1], ydot_, ipvt_);
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _dainvg (int_4 (*_res)(), int_4 (*_adda)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ ydot_, int_4 
_p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ pw_, int_4 _p_ ipvt_, int_4 _p_ ier_)
{
  static int_4 i_, lenpw_, mlp1_, nrowpw_;
  if ((*miter_) >= 4) {
    goto _l100;
  }
  lenpw_ = (*neq_) * (*neq_);
  for (i_ = 1; i_ <= lenpw_; (i_)++) {
    pw_[i_ - 1] = 0.0;
  }
  (*ier_) = 1;
  (void) _res (neq_, t_, y_, pw_, ydot_, ier_);
  if ((*ier_) > 1) {
    goto _l0;
  }
  (void) _adda (neq_, t_, y_, &_k0, &_k0, pw_, neq_);
  (void) _dgefa (pw_, neq_, neq_, ipvt_, ier_);
  if ((*ier_) == 0) {
    goto _l20;
  }
  (*ier_) = -(*ier_);
  goto _l0;
  _l20:;
  (void) _dgesl (pw_, neq_, neq_, ipvt_, ydot_, &_k0);
  goto _l0;
  _l100:;
  nrowpw_ = 2 * (*ml_) + (*mu_) + 1;
  lenpw_ = (*neq_) * nrowpw_;
  for (i_ = 1; i_ <= lenpw_; (i_)++) {
    pw_[i_ - 1] = 0.0;
  }
  (*ier_) = 1;
  (void) _res (neq_, t_, y_, pw_, ydot_, ier_);
  if ((*ier_) > 1) {
    goto _l0;
  }
  mlp1_ = (*ml_) + 1;
  (void) _adda (neq_, t_, y_, ml_, mu_, &pw_[mlp1_ - 1], &nrowpw_);
  (void) _dgbfa (pw_, &nrowpw_, neq_, ml_, mu_, ipvt_, ier_);
  if ((*ier_) == 0) {
    goto _l120;
  }
  (*ier_) = -(*ier_);
  goto _l0;
  _l120:;
  (void) _dgbsl (pw_, &nrowpw_, neq_, ml_, mu_, ipvt_, ydot_, &_k0);
  _l0:;
  __calls[9].calls++;
  return 0;
}

int_4 _dainvgs (int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ wk_, int_4 _p_ iwk_, real_8 _p_ tem_, real_8 
_p_ ydot_, int_4 _p_ ier_, int_4 (*_res)(), int_4 (*_adda)())
{
  static int_4 i_, imul_, j_, k_, kmin_, kmax_;
  int_4 $0_, $1_;
  for (i_ = 1; i_ <= dlss01_.nnz_; (i_)++) {
    wk_[dlss01_.iba_ + i_ - 1] = 0.0;
  }
  (*ier_) = 1;
  (void) _res (neq_, t_, y_, &wk_[dlss01_.ipa_ - 1], ydot_, ier_);
  if ((*ier_) > 1) {
    goto _l0;
  }
  kmin_ = iwk_[dlss01_.ipian_ - 1];
  for (j_ = 1; j_ <= (*neq_); (j_)++) {
    kmax_ = iwk_[dlss01_.ipian_ + j_ - 1] - 1;
    for (k_ = kmin_; k_ <= kmax_; (k_)++) {
      i_ = iwk_[dlss01_.ibjan_ + k_ - 1];
      tem_[i_ - 1] = 0.0;
    }
    (void) _adda (neq_, t_, y_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], tem_);
    for (k_ = kmin_; k_ <= kmax_; (k_)++) {
      i_ = iwk_[dlss01_.ibjan_ + k_ - 1];
      wk_[dlss01_.iba_ + k_ - 1] = tem_[i_ - 1];
    }
    kmin_ = kmax_ + 1;
  }
  dlss01_.nlu_ = dlss01_.nlu_ + 1;
  (*ier_) = 0;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    tem_[i_ - 1] = 0.0;
  }
  (void) _cdrv (neq_, &iwk_[dlss01_.ipr_ - 1], &iwk_[dlss01_.ipc_ - 1], &iwk_[dlss01_.ipic_ - 1], &iwk_[dlss01_.ipian_ - 
  1], &iwk_[dlss01_.ipjan_ - 1], &wk_[dlss01_.ipa_ - 1], tem_, tem_, &dlss01_.nsp_, &iwk_[dlss01_.ipisp_ - 1], 
  &wk_[dlss01_.iprsp_ - 1], &dlss01_.iesp_, ($0_ = 2, &$0_), &dlss01_.iys_);
  if (dlss01_.iys_ == 0) {
    goto _l50;
  }
  imul_ = (dlss01_.iys_ - 1) / (*neq_);
  (*ier_) = 5;
  if (imul_ == 8) {
    (*ier_) = 1;
  }
  if (imul_ == 10) {
    (*ier_) = 4;
  }
  goto _l0;
  _l50:;
  (void) _cdrv (neq_, &iwk_[dlss01_.ipr_ - 1], &iwk_[dlss01_.ipc_ - 1], &iwk_[dlss01_.ipic_ - 1], &iwk_[dlss01_.ipian_ - 
  1], &iwk_[dlss01_.ipjan_ - 1], &wk_[dlss01_.ipa_ - 1], ydot_, ydot_, &dlss01_.nsp_, &iwk_[dlss01_.ipisp_ - 1], 
  &wk_[dlss01_.iprsp_ - 1], &dlss01_.iesp_, ($1_ = 4, &$1_), &dlss01_.iys_);
  if (dlss01_.iys_ != 0) {
    (*ier_) = 5;
  }
  _l0:;
  __calls[10].calls++;
  return 0;
}

int_4 _datp (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ p_, real_8 _p_ wght_, real_8 _p_ hl0_, real_8 
_p_ wk_, int_4 (*_f)(), real_8 _p_ w_)
{
  static int_4 i_;
  static real_8 fac_, pnrm_, rpnrm_;
  pnrm_ = _dvnorm (&dls001_.n_, p_, wght_);
  rpnrm_ = 1.0e0 / pnrm_;
  (void) _dcopy (&dls001_.n_, y_, &_k1, w_, &_k1);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = w_[i_ - 1] + p_[i_ - 1] * rpnrm_;
  }
  (void) _f (neq_, &dls001_.tn_, y_, wk_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  (void) _dcopy (&dls001_.n_, w_, &_k1, y_, &_k1);
  fac_ = (*hl0_) * pnrm_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    w_[i_ - 1] = p_[i_ - 1] - fac_ * (wk_[i_ - 1] - savf_[i_ - 1]);
  }
  __calls[11].calls++;
  return 0;
}

int_4 _datv (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ v_, real_8 _p_ wght_, real_8 _p_ ftem_, int_4 
(*_f)(), int_4 (*_psol)(), real_8 _p_ z_, real_8 _p_ vtem_, real_8 _p_ wp_, int_4 _p_ iwp_, real_8 _p_ hl0_, int_4 _p_ 
jpre_, int_4 _p_ ier_, int_4 _p_ npsl_)
{
  static int_4 i_;
  static real_8 fac_, rnorm_, tempn_;
  int_4 $0_;
  extern real_8 _dnrm2 ();
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    vtem_[i_ - 1] = v_[i_ - 1] / wght_[i_ - 1];
  }
  (*ier_) = 0;
  if ((*jpre_) >= 2) {
    goto _l30;
  }
  (void) _dcopy (&dls001_.n_, y_, &_k1, z_, &_k1);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = z_[i_ - 1] + vtem_[i_ - 1];
  }
  fac_ = (*hl0_);
  goto _l60;
  _l30:;
  (void) _psol (neq_, &dls001_.tn_, y_, savf_, ftem_, hl0_, wp_, iwp_, vtem_, ($0_ = 2, &$0_), ier_);
  (*npsl_) = (*npsl_) + 1;
  if ((*ier_) != 0) {
    goto _l0;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    z_[i_ - 1] = vtem_[i_ - 1] * wght_[i_ - 1];
  }
  tempn_ = _dnrm2 (&dls001_.n_, z_, &_k1);
  rnorm_ = 1.0e0 / tempn_;
  (void) _dcopy (&dls001_.n_, y_, &_k1, z_, &_k1);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = z_[i_ - 1] + vtem_[i_ - 1] * rnorm_;
  }
  fac_ = (*hl0_) * tempn_;
  _l60:;
  (void) _f (neq_, &dls001_.tn_, y_, ftem_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  (void) _dcopy (&dls001_.n_, z_, &_k1, y_, &_k1);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    z_[i_ - 1] = ftem_[i_ - 1] - savf_[i_ - 1];
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    z_[i_ - 1] = vtem_[i_ - 1] - fac_ * z_[i_ - 1];
  }
  if ((*jpre_) == 0 || (*jpre_) == 2) {
    goto _l85;
  }
  (void) _psol (neq_, &dls001_.tn_, y_, savf_, ftem_, hl0_, wp_, iwp_, z_, &_k1, ier_);
  (*npsl_) = (*npsl_) + 1;
  if ((*ier_) != 0) {
    goto _l0;
  }
  _l85:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    z_[i_ - 1] = z_[i_ - 1] * wght_[i_ - 1];
  }
  _l0:;
  __calls[12].calls++;
  return 0;
}

real_8 _dbnorm (int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ nra_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ w_)
{
  static int_4 i_, i1_, jlo_, jhi_, j_;
  static real_8 an_, sum_;
  real_8 dbnorm_;
  an_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sum_ = 0.0;
    i1_ = i_ + (*mu_) + 1;
    jlo_ = _max (i_ - (*ml_), 1);
    jhi_ = _min (i_ + (*mu_), (*n_));
    for (j_ = jlo_; j_ <= jhi_; (j_)++) {
      sum_ = sum_ + _abs (a_[i1_ - j_ - 1 + ((*nra_)) * ((j_ - 1))]) / w_[j_ - 1];
    }
    an_ = _max (an_, sum_ * w_[i_ - 1]);
  }
  dbnorm_ = an_;
  __calls[13].calls++;
  return dbnorm_;
}

int_4 _dcfode (int_4 _p_ meth_, real_8 _p_ elco_, real_8 _p_ tesco_)
{
  static int_4 i_, ib_, nq_, nqm1_, nqp1_;
  static real_8 agamq_, fnq_, fnqm1_, pc_[12], pint_, ragq_, rqfac_, rq1fac_, tsign_, xpin_;
  switch ((*meth_)) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
  }
  _l100:;
  elco_[0] = 1.0;
  elco_[1] = 1.0;
  tesco_[0] = 0.0;
  tesco_[1] = 2.0;
  tesco_[3] = 1.0;
  tesco_[35] = 0.0;
  pc_[0] = 1.0;
  rqfac_ = 1.0;
  for (nq_ = 2; nq_ <= 12; (nq_)++) {
    rq1fac_ = rqfac_;
    rqfac_ = rqfac_ / nq_;
    nqm1_ = nq_ - 1;
    fnqm1_ = nqm1_;
    nqp1_ = nq_ + 1;
    pc_[nq_ - 1] = 0.0;
    for (ib_ = 1; ib_ <= nqm1_; (ib_)++) {
      i_ = nqp1_ - ib_;
      pc_[i_ - 1] = pc_[i_ - 1 - 1] + fnqm1_ * pc_[i_ - 1];
    }
    pc_[0] = fnqm1_ * pc_[0];
    pint_ = pc_[0];
    xpin_ = pc_[0] / 2.0e0;
    tsign_ = 1.0;
    for (i_ = 2; i_ <= nq_; (i_)++) {
      tsign_ = -tsign_;
      pint_ = pint_ + tsign_ * pc_[i_ - 1] / i_;
      xpin_ = xpin_ + tsign_ * pc_[i_ - 1] / (i_ + 1);
    }
    elco_[0 + (13) * ((nq_ - 1))] = pint_ * rq1fac_;
    elco_[1 + (13) * ((nq_ - 1))] = 1.0;
    for (i_ = 2; i_ <= nq_; (i_)++) {
      elco_[i_ + 1 - 1 + (13) * ((nq_ - 1))] = rq1fac_ * pc_[i_ - 1] / i_;
    }
    agamq_ = rqfac_ * xpin_;
    ragq_ = 1.0e0 / agamq_;
    tesco_[1 + (3) * ((nq_ - 1))] = ragq_;
    if (nq_ < 12) {
      tesco_[0 + (3) * ((nqp1_ - 1))] = ragq_ * rqfac_ / nqp1_;
    }
    tesco_[2 + (3) * ((nqm1_ - 1))] = ragq_;
  }
  goto _l0;
  _l200:;
  pc_[0] = 1.0;
  rq1fac_ = 1.0;
  for (nq_ = 1; nq_ <= 5; (nq_)++) {
    fnq_ = nq_;
    nqp1_ = nq_ + 1;
    pc_[nqp1_ - 1] = 0.0;
    for (ib_ = 1; ib_ <= nq_; (ib_)++) {
      i_ = nq_ + 2 - ib_;
      pc_[i_ - 1] = pc_[i_ - 1 - 1] + fnq_ * pc_[i_ - 1];
    }
    pc_[0] = fnq_ * pc_[0];
    for (i_ = 1; i_ <= nqp1_; (i_)++) {
      elco_[i_ - 1 + (13) * ((nq_ - 1))] = pc_[i_ - 1] / pc_[1];
    }
    elco_[1 + (13) * ((nq_ - 1))] = 1.0;
    tesco_[0 + (3) * ((nq_ - 1))] = rq1fac_;
    tesco_[1 + (3) * ((nq_ - 1))] = nqp1_ / elco_[0 + (13) * ((nq_ - 1))];
    tesco_[2 + (3) * ((nq_ - 1))] = (nq_ + 2) / elco_[0 + (13) * ((nq_ - 1))];
    rq1fac_ = rq1fac_ / fnq_;
  }
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _ddecbt (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, int_4 _p_ ip_, int_4 _p_ ier_)
{
  static int_4 nm1_, nm2_, km1_, i_, j_, k_;
  static real_8 dp_;
  extern real_8 _ddot ();
  if ((*m_) < 1 || (*n_) < 4) {
    goto _l210;
  }
  nm1_ = (*n_) - 1;
  nm2_ = (*n_) - 2;
  (void) _dgefa (a_, m_, m_, ip_, ier_);
  k_ = 1;
  if ((*ier_) != 0) {
    goto _l200;
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    (void) _dgesl (a_, m_, m_, ip_, &b_[0 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))], &_k0);
    (void) _dgesl (a_, m_, m_, ip_, &c_[0 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))], &_k0);
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      dp_ = _ddot (m_, &c_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * ((1)))], m_, &c_[0 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))], 
      &_k1);
      b_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((1)))] = b_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((1)))] - dp_;
    }
  }
  for (k_ = 2; k_ <= nm1_; (k_)++) {
    km1_ = k_ - 1;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        dp_ = _ddot (m_, &c_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * ((k_ - 1)))], m_, &b_[0 + ((*m_)) * ((j_ - 1) + ((*m_)) * 
        ((km1_ - 1)))], &_k1);
        a_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((k_ - 1)))] = a_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((k_ - 1)))] - 
        dp_;
      }
    }
    (void) _dgefa (&a_[0 + ((*m_)) * ((0) + ((*m_)) * ((k_ - 1)))], m_, m_, &ip_[0 + ((*m_)) * ((k_ - 1))], ier_);
    if ((*ier_) != 0) {
      goto _l200;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      (void) _dgesl (&a_[0 + ((*m_)) * ((0) + ((*m_)) * ((k_ - 1)))], m_, m_, &ip_[0 + ((*m_)) * ((k_ - 1))], &b_[0 + ((*m_)) 
      * ((j_ - 1) + ((*m_)) * ((k_ - 1)))], &_k0);
    }
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      dp_ = _ddot (m_, &b_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * (((*n_) - 1)))], m_, &b_[0 + ((*m_)) * ((j_ - 1) + ((*m_)) * 
      ((nm2_ - 1)))], &_k1);
      c_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * (((*n_) - 1)))] = c_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * (((*n_) - 
      1)))] - dp_;
    }
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      dp_ = _ddot (m_, &c_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * (((*n_) - 1)))], m_, &b_[0 + ((*m_)) * ((j_ - 1) + ((*m_)) * 
      ((nm1_ - 1)))], &_k1);
      a_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * (((*n_) - 1)))] = a_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * (((*n_) - 
      1)))] - dp_;
    }
  }
  (void) _dgefa (&a_[0 + ((*m_)) * ((0) + ((*m_)) * (((*n_) - 1)))], m_, m_, &ip_[0 + ((*m_)) * (((*n_) - 1))], ier_);
  k_ = (*n_);
  if ((*ier_) != 0) {
    goto _l200;
  }
  goto _l0;
  _l200:;
  (*ier_) = k_;
  goto _l0;
  _l210:;
  (*ier_) = -1;
  _l0:;
  __calls[15].calls++;
  return 0;
}

int_4 _dewset (int_4 _p_ n_, int_4 _p_ itol_, real_8 _p_ rtol_, real_8 _p_ atol_, real_8 _p_ ycur_, real_8 _p_ ewt_)
{
  static int_4 i_;
  switch ((*itol_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
    case 3: goto _l30;
    case 4: goto _l40;
  }
  _l10:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ewt_[i_ - 1] = rtol_[0] * _abs (ycur_[i_ - 1]) + atol_[0];
  }
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ewt_[i_ - 1] = rtol_[0] * _abs (ycur_[i_ - 1]) + atol_[i_ - 1];
  }
  goto _l0;
  _l30:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ewt_[i_ - 1] = rtol_[i_ - 1] * _abs (ycur_[i_ - 1]) + atol_[0];
  }
  goto _l0;
  _l40:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ewt_[i_ - 1] = rtol_[i_ - 1] * _abs (ycur_[i_ - 1]) + atol_[i_ - 1];
  }
  _l0:;
  __calls[16].calls++;
  return 0;
}

real_8 _dfnorm (int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ w_)
{
  static int_4 i_, j_;
  static real_8 an_, sum_;
  real_8 dfnorm_;
  an_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sum_ = 0.0;
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      sum_ = sum_ + _abs (a_[i_ - 1 + ((*n_)) * ((j_ - 1))]) / w_[j_ - 1];
    }
    an_ = _max (an_, sum_ * w_[i_ - 1]);
  }
  dfnorm_ = an_;
  __calls[17].calls++;
  return dfnorm_;
}

int_4 _dhefa (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, int_4 _p_ info_, int_4 _p_ job_)
{
  static int_4 j_, k_, km1_, kp1_, l_, nm1_;
  static real_8 t_;
  int_4 $0_, $1_, $2_;
  extern int_4 _idamax ();
  if ((*job_) > 1) {
    goto _l80;
  }
  (*info_) = 0;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l70;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    kp1_ = k_ + 1;
    l_ = _idamax (($0_ = 2, &$0_), &a_[k_ - 1 + ((*lda_)) * ((k_ - 1))], &_k1) + k_ - 1;
    ipvt_[k_ - 1] = l_;
    if (a_[l_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      goto _l40;
    }
    if (l_ == k_) {
      goto _l10;
    }
    t_ = a_[l_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[l_ - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = t_;
    _l10:;
    t_ = -1.0e0 / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))] = a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))] * t_;
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      t_ = a_[l_ - 1 + ((*lda_)) * ((j_ - 1))];
      if (l_ == k_) {
        goto _l20;
      }
      a_[l_ - 1 + ((*lda_)) * ((j_ - 1))] = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))];
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      _l20:;
      (void) _daxpy (($1_ = (*n_) - k_, &$1_), &t_, &a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[k_ + 1 - 1 + 
      ((*lda_)) * ((j_ - 1))], &_k1);
    }
    goto _l50;
    _l40:;
    (*info_) = k_;
    _l50:;
  }
  _l70:;
  ipvt_[(*n_) - 1] = (*n_);
  if (a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))] == 0.0e0) {
    (*info_) = (*n_);
  }
  goto _l0;
  _l80:;
  nm1_ = (*n_) - 1;
  if (nm1_ <= 1) {
    goto _l105;
  }
  for (k_ = 2; k_ <= nm1_; (k_)++) {
    km1_ = k_ - 1;
    l_ = ipvt_[km1_ - 1];
    t_ = a_[l_ - 1 + ((*lda_)) * (((*n_) - 1))];
    if (l_ == km1_) {
      goto _l90;
    }
    a_[l_ - 1 + ((*lda_)) * (((*n_) - 1))] = a_[km1_ - 1 + ((*lda_)) * (((*n_) - 1))];
    a_[km1_ - 1 + ((*lda_)) * (((*n_) - 1))] = t_;
    _l90:;
    a_[k_ - 1 + ((*lda_)) * (((*n_) - 1))] = a_[k_ - 1 + ((*lda_)) * (((*n_) - 1))] + a_[k_ - 1 + ((*lda_)) * ((km1_ - 1))] 
    * t_;
  }
  _l105:;
  (*info_) = 0;
  l_ = _idamax (($2_ = 2, &$2_), &a_[nm1_ - 1 + ((*lda_)) * ((nm1_ - 1))], &_k1) + nm1_ - 1;
  ipvt_[nm1_ - 1] = l_;
  if (a_[l_ - 1 + ((*lda_)) * ((nm1_ - 1))] == 0.0e0) {
    goto _l140;
  }
  if (l_ == nm1_) {
    goto _l110;
  }
  t_ = a_[l_ - 1 + ((*lda_)) * ((nm1_ - 1))];
  a_[l_ - 1 + ((*lda_)) * ((nm1_ - 1))] = a_[nm1_ - 1 + ((*lda_)) * ((nm1_ - 1))];
  a_[nm1_ - 1 + ((*lda_)) * ((nm1_ - 1))] = t_;
  _l110:;
  t_ = -1.0e0 / a_[nm1_ - 1 + ((*lda_)) * ((nm1_ - 1))];
  a_[(*n_) - 1 + ((*lda_)) * ((nm1_ - 1))] = a_[(*n_) - 1 + ((*lda_)) * ((nm1_ - 1))] * t_;
  t_ = a_[l_ - 1 + ((*lda_)) * (((*n_) - 1))];
  if (l_ == nm1_) {
    goto _l120;
  }
  a_[l_ - 1 + ((*lda_)) * (((*n_) - 1))] = a_[nm1_ - 1 + ((*lda_)) * (((*n_) - 1))];
  a_[nm1_ - 1 + ((*lda_)) * (((*n_) - 1))] = t_;
  _l120:;
  a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))] = a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))] + t_ * a_[(*n_) - 1 + ((*lda_)) * 
  ((nm1_ - 1))];
  goto _l150;
  _l140:;
  (*info_) = nm1_;
  _l150:;
  ipvt_[(*n_) - 1] = (*n_);
  if (a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))] == 0.0e0) {
    (*info_) = (*n_);
  }
  _l0:;
  __calls[18].calls++;
  return 0;
}

int_4 _dhels (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ q_, real_8 _p_ b_)
{
  static int_4 iq_, k_, kb_, kp1_;
  static real_8 c_, s_, t_, t1_, t2_;
  int_4 $0_;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kp1_ = k_ + 1;
    iq_ = 2 * (k_ - 1) + 1;
    c_ = q_[iq_ - 1];
    s_ = q_[iq_ + 1 - 1];
    t1_ = b_[k_ - 1];
    t2_ = b_[kp1_ - 1];
    b_[k_ - 1] = c_ * t1_ - s_ * t2_;
    b_[kp1_ - 1] = s_ * t1_ + c_ * t2_;
  }
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _daxpy (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  __calls[19].calls++;
  return 0;
}

int_4 _dheqr (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ q_, int_4 _p_ info_, int_4 _p_ ijob_)
{
  static int_4 i_, iq_, j_, k_, km1_, kp1_, nm1_;
  static real_8 c_, s_, t_, t1_, t2_;
  if ((*ijob_) > 1) {
    goto _l70;
  }
  (*info_) = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    km1_ = k_ - 1;
    kp1_ = k_ + 1;
    if (km1_ < 1) {
      goto _l20;
    }
    for (j_ = 1; j_ <= km1_; (j_)++) {
      i_ = 2 * (j_ - 1) + 1;
      t1_ = a_[j_ - 1 + ((*lda_)) * ((k_ - 1))];
      t2_ = a_[j_ + 1 - 1 + ((*lda_)) * ((k_ - 1))];
      c_ = q_[i_ - 1];
      s_ = q_[i_ + 1 - 1];
      a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = c_ * t1_ - s_ * t2_;
      a_[j_ + 1 - 1 + ((*lda_)) * ((k_ - 1))] = s_ * t1_ + c_ * t2_;
    }
    _l20:;
    iq_ = 2 * km1_ + 1;
    t1_ = a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t2_ = a_[kp1_ - 1 + ((*lda_)) * ((k_ - 1))];
    if (t2_ != 0.0e0) {
      goto _l30;
    }
    c_ = 1.0;
    s_ = 0.0;
    goto _l50;
    _l30:;
    if (_abs (t2_) < _abs (t1_)) {
      goto _l40;
    }
    t_ = t1_ / t2_;
    s_ = -1.0e0 / sqrt (1.0e0 + t_ * t_);
    c_ = -s_ * t_;
    goto _l50;
    _l40:;
    t_ = t2_ / t1_;
    c_ = 1.0e0 / sqrt (1.0e0 + t_ * t_);
    s_ = -c_ * t_;
    _l50:;
    q_[iq_ - 1] = c_;
    q_[iq_ + 1 - 1] = s_;
    a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] = c_ * t1_ - s_ * t2_;
    if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == 0.0e0) {
      (*info_) = k_;
    }
  }
  goto _l0;
  _l70:;
  nm1_ = (*n_) - 1;
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    i_ = 2 * (k_ - 1) + 1;
    t1_ = a_[k_ - 1 + ((*lda_)) * (((*n_) - 1))];
    t2_ = a_[k_ + 1 - 1 + ((*lda_)) * (((*n_) - 1))];
    c_ = q_[i_ - 1];
    s_ = q_[i_ + 1 - 1];
    a_[k_ - 1 + ((*lda_)) * (((*n_) - 1))] = c_ * t1_ - s_ * t2_;
    a_[k_ + 1 - 1 + ((*lda_)) * (((*n_) - 1))] = s_ * t1_ + c_ * t2_;
  }
  (*info_) = 0;
  t1_ = a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))];
  t2_ = a_[(*n_) + 1 - 1 + ((*lda_)) * (((*n_) - 1))];
  if (t2_ != 0.0e0) {
    goto _l110;
  }
  c_ = 1.0;
  s_ = 0.0;
  goto _l130;
  _l110:;
  if (_abs (t2_) < _abs (t1_)) {
    goto _l120;
  }
  t_ = t1_ / t2_;
  s_ = -1.0e0 / sqrt (1.0e0 + t_ * t_);
  c_ = -s_ * t_;
  goto _l130;
  _l120:;
  t_ = t2_ / t1_;
  c_ = 1.0e0 / sqrt (1.0e0 + t_ * t_);
  s_ = -c_ * t_;
  _l130:;
  iq_ = 2 * (*n_) - 1;
  q_[iq_ - 1] = c_;
  q_[iq_ + 1 - 1] = s_;
  a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))] = c_ * t1_ - s_ * t2_;
  if (a_[(*n_) - 1 + ((*lda_)) * (((*n_) - 1))] == 0.0e0) {
    (*info_) = (*n_);
  }
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _dhesl (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ipvt_, real_8 _p_ b_)
{
  static int_4 k_, kb_, l_, nm1_;
  static real_8 t_;
  int_4 $0_;
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    b_[k_ + 1 - 1] = b_[k_ + 1 - 1] + t_ * a_[k_ + 1 - 1 + ((*lda_)) * ((k_ - 1))];
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
    t_ = -b_[k_ - 1];
    (void) _daxpy (($0_ = k_ - 1, &$0_), &t_, &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &b_[0], &_k1);
  }
  __calls[21].calls++;
  return 0;
}

int_4 _dintdy (real_8 _p_ t_, int_4 _p_ k_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ dky_, int_4 _p_ iflag_)
{
  static int_4 i_, ic_, j_, jb_, jb2_, jj_, jj1_, jp1_;
  static real_8 c_, r_, s_, tp_;
  static char_127 msg_;
  int_4 $0_, $1_, $4_, $5_, $7_, $8_, $9_;
  real_8 $2_, $3_, $6_;
  (*iflag_) = 0;
  if ((*k_) < 0 || (*k_) > dls001_.nq_) {
    goto _l80;
  }
  tp_ = dls001_.tn_ - dls001_.hu_ - 100.0e0 * dls001_.uround_ * _sign (_abs (dls001_.tn_) + _abs (dls001_.hu_), 
  dls001_.hu_);
  if (((*t_) - tp_) * ((*t_) - dls001_.tn_) > 0.0e0) {
    goto _l90;
  }
  s_ = ((*t_) - dls001_.tn_) / dls001_.h_;
  ic_ = 1;
  if ((*k_) == 0) {
    goto _l15;
  }
  jj1_ = dls001_.l_ - (*k_);
  for (jj_ = jj1_; jj_ <= dls001_.nq_; (jj_)++) {
    ic_ = ic_ * jj_;
  }
  _l15:;
  c_ = ic_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    dky_[i_ - 1] = c_ * yh_[i_ - 1 + ((*nyh_)) * ((dls001_.l_ - 1))];
  }
  if ((*k_) == dls001_.nq_) {
    goto _l55;
  }
  jb2_ = dls001_.nq_ - (*k_);
  for (jb_ = 1; jb_ <= jb2_; (jb_)++) {
    j_ = dls001_.nq_ - jb_;
    jp1_ = j_ + 1;
    ic_ = 1;
    if ((*k_) == 0) {
      goto _l35;
    }
    jj1_ = jp1_ - (*k_);
    for (jj_ = jj1_; jj_ <= j_; (jj_)++) {
      ic_ = ic_ * jj_;
    }
    _l35:;
    c_ = ic_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      dky_[i_ - 1] = c_ * yh_[i_ - 1 + ((*nyh_)) * ((jp1_ - 1))] + s_ * dky_[i_ - 1];
    }
  }
  if ((*k_) == 0) {
    goto _l0;
  }
  _l55:;
  r_ = _up_real_8 (dls001_.h_, (-(*k_)));
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    dky_[i_ - 1] = r_ * dky_[i_ - 1];
  }
  goto _l0;
  _l80:;
  bufcpy (msg_, _dc_0, 127);
  (void) _xerrwd (msg_, ($0_ = 30, &$0_), ($1_ = 51, &$1_), &_k0, &_k1, k_, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
  &$3_));
  (*iflag_) = -1;
  goto _l0;
  _l90:;
  bufcpy (msg_, _dc_1, 127);
  (void) _xerrwd (msg_, ($4_ = 30, &$4_), ($5_ = 52, &$5_), &_k0, &_k0, &_k0, &_k0, &_k1, t_, ($6_ = 0.0, &$6_));
  bufcpy (msg_, _dc_2, 127);
  (void) _xerrwd (msg_, ($7_ = 60, &$7_), ($8_ = 52, &$8_), &_k0, &_k0, &_k0, &_k0, ($9_ = 2, &$9_), &tp_, &dls001_.tn_)
  ;
  (*iflag_) = -2;
  _l0:;
  __calls[22].calls++;
  return 0;
}

int_4 _diprep (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ rwork_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ ipflag_, 
real_4 (*_f)(), int_4 (*_jac)())
{
  static int_4 i_, imax_, lewtn_, lyhd_, lyhn_;
  (*ipflag_) = 0;
  (void) _dprep (neq_, y_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lewt_ - 1], 
  &rwork_[dls001_.lacor_ - 1], ia_, ja_, &rwork_[dls001_.lwm_ - 1], &rwork_[dls001_.lwm_ - 1], ipflag_, _f, _jac);
  dlss01_.lenwk_ = _max (dlss01_.lreq_, dlss01_.lwmin_);
  if ((*ipflag_) < 0) {
    goto _l0;
  }
  lyhn_ = dls001_.lwm_ + dlss01_.lenwk_;
  if (lyhn_ > dls001_.lyh_) {
    goto _l0;
  }
  lyhd_ = dls001_.lyh_ - lyhn_;
  if (lyhd_ == 0) {
    goto _l20;
  }
  imax_ = lyhn_ - 1 + dlss01_.lenyhm_;
  for (i_ = lyhn_; i_ <= imax_; (i_)++) {
    rwork_[i_ - 1] = rwork_[i_ + lyhd_ - 1];
  }
  dls001_.lyh_ = lyhn_;
  _l20:;
  dls001_.lsavf_ = dls001_.lyh_ + dlss01_.lenyh_;
  lewtn_ = dls001_.lsavf_ + dls001_.n_;
  dls001_.lacor_ = lewtn_ + dls001_.n_;
  if (dlss01_.istatc_ == 3) {
    goto _l40;
  }
  if (lewtn_ > dls001_.lewt_) {
    goto _l0;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lewtn_ - 1 - 1] = rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l40:;
  dls001_.lewt_ = lewtn_;
  _l0:;
  __calls[23].calls++;
  return 0;
}

int_4 _diprepi (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ s_, real_8 _p_ rwork_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 
_p_ ic_, int_4 _p_ jc_, int_4 _p_ ipflag_, real_4 (*_res)(), int_4 (*_jac)(), real_4 (*_adda)())
{
  static int_4 i_, imax_, lewtn_, lyhd_, lyhn_;
  (*ipflag_) = 0;
  (void) _dprepi (neq_, y_, s_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lewt_ - 1], 
  &rwork_[dls001_.lacor_ - 1], ia_, ja_, ic_, jc_, &rwork_[dls001_.lwm_ - 1], &rwork_[dls001_.lwm_ - 1], ipflag_, _res, 
  _jac, _adda);
  dlss01_.lenwk_ = _max (dlss01_.lreq_, dlss01_.lwmin_);
  if ((*ipflag_) < 0) {
    goto _l0;
  }
  lyhn_ = dls001_.lwm_ + dlss01_.lenwk_;
  if (lyhn_ > dls001_.lyh_) {
    goto _l0;
  }
  lyhd_ = dls001_.lyh_ - lyhn_;
  if (lyhd_ == 0) {
    goto _l20;
  }
  imax_ = lyhn_ - 1 + dlss01_.lenyhm_;
  for (i_ = lyhn_; i_ <= imax_; (i_)++) {
    rwork_[i_ - 1] = rwork_[i_ + lyhd_ - 1];
  }
  dls001_.lyh_ = lyhn_;
  _l20:;
  dls001_.lsavf_ = dls001_.lyh_ + dlss01_.lenyh_;
  lewtn_ = dls001_.lsavf_ + dls001_.n_;
  dls001_.lacor_ = lewtn_ + dls001_.n_;
  if (dlss01_.istatc_ == 3) {
    goto _l40;
  }
  if (lewtn_ > dls001_.lewt_) {
    goto _l0;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lewtn_ - 1 - 1] = rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l40:;
  dls001_.lewt_ = lewtn_;
  _l0:;
  __calls[24].calls++;
  return 0;
}

int_4 _dlhin (int_4 _p_ neq_, int_4 _p_ n_, real_8 _p_ t0_, real_8 _p_ y0_, real_8 _p_ ydot_, int_4 (*_f)(), real_8 _p_ 
tout_, real_8 _p_ uround_, real_8 _p_ ewt_, int_4 _p_ itol_, real_8 _p_ atol_, real_8 _p_ y_, real_8 _p_ temp_, real_8 
_p_ h0_, int_4 _p_ niter_, int_4 _p_ ier_)
{
  static int_4 i_, iter_;
  static real_8 afi_, atoli_, delyi_, half_, hg_, hlb_, hnew_, hrat_, hub_, hun_, pt1_, t1_, tdist_, tround_, two_, 
  yddnrm_;
  int_4 _data_k_1, _data_k_2, _data_k_3, _data_k_4;
#define _data_n_1 1
  static real_8 _data_l_1[_data_n_1] = {
    0.5e0
  };
#define _data_n_2 1
  static real_8 _data_l_2[_data_n_2] = {
    100.0e0
  };
#define _data_n_3 1
  static real_8 _data_l_3[_data_n_3] = {
    0.1e0
  };
#define _data_n_4 1
  static real_8 _data_l_4[_data_n_4] = {
    2.0e0
  };
  if (__calls[25].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    half_ = _data_l_1[_data_k_1++];
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    hun_ = _data_l_2[_data_k_2++];
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    pt1_ = _data_l_3[_data_k_3++];
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    two_ = _data_l_4[_data_k_4++];
  }
  (*niter_) = 0;
  tdist_ = _abs ((*tout_) - (*t0_));
  tround_ = (*uround_) * _max (_abs ((*t0_)), _abs ((*tout_)));
  if (tdist_ < two_ * tround_) {
    goto _l100;
  }
  hlb_ = hun_ * tround_;
  hub_ = pt1_ * tdist_;
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    delyi_ = pt1_ * _abs (y0_[i_ - 1]) + atoli_;
    afi_ = _abs (ydot_[i_ - 1]);
    if (afi_ * hub_ > delyi_) {
      hub_ = delyi_ / afi_;
    }
  }
  iter_ = 0;
  hg_ = sqrt (hlb_ * hub_);
  if (hub_ < hlb_) {
    (*h0_) = hg_;
    goto _l90;
  }
  _l50:;
  t1_ = (*t0_) + hg_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = y0_[i_ - 1] + hg_ * ydot_[i_ - 1];
  }
  (void) _f (neq_, &t1_, y_, temp_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    temp_[i_ - 1] = (temp_[i_ - 1] - ydot_[i_ - 1]) / hg_;
  }
  yddnrm_ = _dvnorm (n_, temp_, ewt_);
  if (yddnrm_ * hub_ * hub_ > two_) {
    hnew_ = sqrt (two_ / yddnrm_);
  }
  else {
    hnew_ = sqrt (hg_ * hub_);
  }
  iter_ = iter_ + 1;
  if (iter_ >= 4) {
    goto _l80;
  }
  hrat_ = hnew_ / hg_;
  if ((hrat_ > half_) && (hrat_ < two_)) {
    goto _l80;
  }
  if ((iter_ >= 2) && (hnew_ > two_ * hg_)) {
    hnew_ = hg_;
    goto _l80;
  }
  hg_ = hnew_;
  goto _l50;
  _l80:;
  (*h0_) = hnew_ * half_;
  if ((*h0_) < hlb_) {
    (*h0_) = hlb_;
  }
  if ((*h0_) > hub_) {
    (*h0_) = hub_;
  }
  _l90:;
  (*h0_) = _sign ((*h0_), (*tout_) - (*t0_));
  (void) _dcopy (n_, y0_, &_k1, y_, &_k1);
  (*niter_) = iter_;
  (*ier_) = 0;
  goto _l0;
  _l100:;
  (*ier_) = -1;
  _l0:;
  __calls[25].calls++;
  return 0;
}

int_4 _dlsoda (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, 
int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), int_4 _p_ jt_)
{
  static int_4 i_, i1_, i2_, iflag_, imxer_, kgo_, lf0_, leniw_, lenrw_, lenwm_, ml_, mord_[2], mu_, mxhnl0_, mxstp0_, 
  len1_, len1c_, len1n_, len1s_, len2_, leniwc_, lenrwc_;
  static logical_4 ihit_;
  static real_8 atoli_, ayi_, big_, ewti_, h0_, hmax_, hmx_, rh_, rtoli_, tcrit_, tdist_, tnext_, tol_, tolsf_, tp_, 
  size_, sum_, w0_;
  static char_63 msg_;
  int_4 _data_k_5, _data_k_6, _data_k_7, $0_, $1_, $4_, $5_, $8_, $9_, $10_, $13_, $14_, $17_, $18_, $21_, $22_, $23_, 
  $26_, $27_, $30_, $31_, $34_, $35_, $36_, $37_, $38_, $41_, $42_, $45_, $46_, $49_, $50_, $53_, $54_, $55_, $56_, $57_, 
  $60_, $61_, $63_, $64_, $65_, $66_, $67_, $70_, $71_, $72_, $73_, $74_, $77_, $78_, $79_, $80_, $81_, $84_, $85_, $88_, 
  $89_, $90_, $91_, $92_, $95_, $96_, $98_, $99_, $102_, $103_, $105_, $108_, $109_, $112_, $113_, $116_, $117_, $120_, 
  $121_, $122_, $125_, $126_, $129_, $130_, $133_, $134_, $137_, $138_, $139_, $142_, $143_, $144_, $147_, $148_, $151_, 
  $152_, $155_, $156_, $159_, $160_, $161_, $162_, $163_, $165_, $166_, $168_, $169_, $171_, $172_, $173_, $176_, $177_, 
  $178_, $181_, $182_, $184_, $185_, $187_, $188_, $190_, $191_, $192_, $193_, $194_, $195_, $196_, $197_, $198_, $199_, 
  $200_, $201_, $202_, $203_, $206_, $207_, $209_, $210_, $212_, $213_, $216_, $217_, $220_, $221_, $222_;
  real_8 $2_, $3_, $6_, $7_, $11_, $12_, $15_, $16_, $19_, $20_, $24_, $25_, $28_, $29_, $32_, $33_, $39_, $40_, $43_, 
  $44_, $47_, $48_, $51_, $52_, $58_, $59_, $62_, $68_, $69_, $75_, $76_, $82_, $83_, $86_, $87_, $93_, $94_, $97_, $100_
  , $101_, $104_, $106_, $107_, $110_, $111_, $114_, $115_, $118_, $119_, $123_, $124_, $127_, $128_, $131_, $132_, $135_
  , $136_, $140_, $141_, $145_, $146_, $149_, $150_, $153_, $154_, $157_, $158_, $164_, $167_, $170_, $174_, $175_, $179_
  , $180_, $183_, $186_, $189_, $204_, $205_, $208_, $211_, $214_, $215_, $218_, $219_, $223_, $224_;
#define _data_n_5 2
  static int_4 _data_l_5[_data_n_5] = {
    12,
    5
  };
#define _data_n_6 1
  static int_4 _data_l_6[_data_n_6] = {
    500
  };
#define _data_n_7 1
  static int_4 _data_l_7[_data_n_7] = {
    10
  };
  if (__calls[26].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    mord_[0] = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    mord_[1] = _data_l_5[_data_k_5++];
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    mxstp0_ = _data_l_6[_data_k_6++];
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    mxhnl0_ = _data_l_7[_data_k_7++];
  }
  if ((*istate_) < 1 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  if ((*istate_) == 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) == 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  if ((*jt_) == 3 || (*jt_) < 1 || (*jt_) > 5) {
    goto _l608;
  }
  dlsa01_.jtyp_ = (*jt_);
  if ((*jt_) <= 2) {
    goto _l30;
  }
  ml_ = iwork_[0];
  mu_ = iwork_[1];
  if (ml_ < 0 || ml_ >= dls001_.n_) {
    goto _l609;
  }
  if (mu_ < 0 || mu_ >= dls001_.n_) {
    goto _l610;
  }
  _l30:;
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dlsa01_.ixpr_ = 0;
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  if ((*istate_) != 1) {
    goto _l60;
  }
  h0_ = 0.0;
  dlsa01_.mxordn_ = mord_[0];
  dlsa01_.mxords_ = mord_[1];
  goto _l60;
  _l40:;
  dlsa01_.ixpr_ = iwork_[4];
  if (dlsa01_.ixpr_ < 0 || dlsa01_.ixpr_ > 1) {
    goto _l611;
  }
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) != 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  dlsa01_.mxordn_ = iwork_[7];
  if (dlsa01_.mxordn_ < 0) {
    goto _l628;
  }
  if (dlsa01_.mxordn_ == 0) {
    dlsa01_.mxordn_ = 100;
  }
  dlsa01_.mxordn_ = _min (dlsa01_.mxordn_, mord_[0]);
  dlsa01_.mxords_ = iwork_[8];
  if (dlsa01_.mxords_ < 0) {
    goto _l629;
  }
  if (dlsa01_.mxords_ == 0) {
    dlsa01_.mxords_ = 100;
  }
  dlsa01_.mxords_ = _min (dlsa01_.mxords_, mord_[1]);
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  _l60:;
  if ((*istate_) == 1) {
    dls001_.meth_ = 1;
  }
  if ((*istate_) == 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  dls001_.lyh_ = 21;
  len1n_ = 20 + (dlsa01_.mxordn_ + 1) * dls001_.nyh_;
  len1s_ = 20 + (dlsa01_.mxords_ + 1) * dls001_.nyh_;
  dls001_.lwm_ = len1s_ + 1;
  if ((*jt_) <= 2) {
    lenwm_ = dls001_.n_ * dls001_.n_ + 2;
  }
  if ((*jt_) >= 4) {
    lenwm_ = (2 * ml_ + mu_ + 1) * dls001_.n_ + 2;
  }
  len1s_ = len1s_ + lenwm_;
  len1c_ = len1n_;
  if (dls001_.meth_ == 2) {
    len1c_ = len1s_;
  }
  len1_ = _max (len1n_, len1s_);
  len2_ = 3 * dls001_.n_;
  lenrw_ = len1_ + len2_;
  lenrwc_ = len1c_ + len2_;
  iwork_[16] = lenrw_;
  dls001_.liwm_ = 1;
  leniw_ = 20 + dls001_.n_;
  leniwc_ = 20;
  if (dls001_.meth_ == 2) {
    leniwc_ = leniw_;
  }
  iwork_[17] = leniw_;
  if ((*istate_) == 1 && (*lrw_) < lenrwc_) {
    goto _l617;
  }
  if ((*istate_) == 1 && (*liw_) < leniwc_) {
    goto _l618;
  }
  if ((*istate_) == 3 && (*lrw_) < lenrwc_) {
    goto _l550;
  }
  if ((*istate_) == 3 && (*liw_) < leniwc_) {
    goto _l555;
  }
  dls001_.lewt_ = len1_ + 1;
  dlsa01_.insufr_ = 0;
  if ((*lrw_) >= lenrw_) {
    goto _l65;
  }
  dlsa01_.insufr_ = 2;
  dls001_.lewt_ = len1c_ + 1;
  bufcpy (msg_, _dc_3, 63);
  (void) _xerrwd (msg_, ($0_ = 60, &$0_), ($1_ = 103, &$1_), &_k0, &_k0, &_k0, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
  &$3_));
  bufcpy (msg_, _dc_4, 63);
  (void) _xerrwd (msg_, ($4_ = 60, &$4_), ($5_ = 103, &$5_), &_k0, &_k0, &_k0, &_k0, &_k0, ($6_ = 0.0, &$6_), ($7_ = 0.0, 
  &$7_));
  bufcpy (msg_, _dc_5, 63);
  (void) _xerrwd (msg_, ($8_ = 50, &$8_), ($9_ = 103, &$9_), &_k0, ($10_ = 2, &$10_), &lenrw_, lrw_, &_k0, ($11_ = 0.0, 
  &$11_), ($12_ = 0.0, &$12_));
  _l65:;
  dls001_.lsavf_ = dls001_.lewt_ + dls001_.n_;
  dls001_.lacor_ = dls001_.lsavf_ + dls001_.n_;
  dlsa01_.insufi_ = 0;
  if ((*liw_) >= leniw_) {
    goto _l70;
  }
  dlsa01_.insufi_ = 2;
  bufcpy (msg_, _dc_6, 63);
  (void) _xerrwd (msg_, ($13_ = 60, &$13_), ($14_ = 104, &$14_), &_k0, &_k0, &_k0, &_k0, &_k0, ($15_ = 0.0, &$15_), ($16_ 
  = 0.0, &$16_));
  bufcpy (msg_, _dc_4, 63);
  (void) _xerrwd (msg_, ($17_ = 60, &$17_), ($18_ = 104, &$18_), &_k0, &_k0, &_k0, &_k0, &_k0, ($19_ = 0.0, &$19_), ($20_ 
  = 0.0, &$20_));
  bufcpy (msg_, _dc_7, 63);
  (void) _xerrwd (msg_, ($21_ = 50, &$21_), ($22_ = 104, &$22_), &_k0, ($23_ = 2, &$23_), &leniw_, liw_, &_k0, ($24_ = 
  0.0, &$24_), ($25_ = 0.0, &$25_));
  _l70:;
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  if ((*istate_) == 1) {
    goto _l100;
  }
  dls001_.jstart_ = -1;
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.uround_ = _dumach ();
  dls001_.tn_ = (*t_);
  dlsa01_.tsw_ = (*t_);
  dls001_.maxord_ = dlsa01_.mxordn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l110;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l110:;
  dls001_.jstart_ = 0;
  dls001_.nhnil_ = 0;
  dls001_.nst_ = 0;
  dls001_.nje_ = 0;
  dls001_.nslast_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dlsa01_.mused_ = 0;
  dls001_.miter_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  lf0_ = dls001_.lyh_ + dls001_.nyh_;
  (void) _f (neq_, t_, y_, &rwork_[lf0_ - 1]);
  dls001_.nfe_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  dls001_.nq_ = 1;
  dls001_.h_ = 1.0;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  tdist_ = _abs ((*tout_) - (*t_));
  w0_ = _max (_abs ((*t_)), _abs ((*tout_)));
  if (tdist_ < 2.0e0 * dls001_.uround_ * w0_) {
    goto _l622;
  }
  tol_ = rtol_[0];
  if ((*itol_) <= 2) {
    goto _l140;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    tol_ = _max (tol_, rtol_[i_ - 1]);
  }
  _l140:;
  if (tol_ > 0.0e0) {
    goto _l160;
  }
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    ayi_ = _abs (y_[i_ - 1]);
    if (ayi_ != 0.0e0) {
      tol_ = _max (tol_, atoli_ / ayi_);
    }
  }
  _l160:;
  tol_ = _max (tol_, 100.0e0 * dls001_.uround_);
  tol_ = _min (tol_, 1.0e-3);
  sum_ = _dmnorm (&dls001_.n_, &rwork_[lf0_ - 1], &rwork_[dls001_.lewt_ - 1]);
  sum_ = 1.0e0 / (tol_ * w0_ * w0_) + tol_ * (sum_ * sum_);
  h0_ = 1.0e0 / sqrt (sum_);
  h0_ = _min (h0_, tdist_);
  h0_ = _sign (h0_, (*tout_) - (*t_));
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lf0_ - 1 - 1] = h0_ * rwork_[i_ + lf0_ - 1 - 1];
  }
  goto _l270;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (*t_) = dls001_.tn_;
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    (*t_) = tcrit_;
  }
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2 && dls001_.jstart_ >= 0) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if (dls001_.meth_ == dlsa01_.mused_) {
    goto _l255;
  }
  if (dlsa01_.insufr_ == 1) {
    goto _l550;
  }
  if (dlsa01_.insufi_ == 1) {
    goto _l555;
  }
  _l255:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dmnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_8, 63);
  (void) _xerrwd (msg_, ($26_ = 50, &$26_), ($27_ = 101, &$27_), &_k0, &_k0, &_k0, &_k0, &_k0, ($28_ = 0.0, &$28_), ($29_ 
  = 0.0, &$29_));
  bufcpy (msg_, _dc_9, 63);
  (void) _xerrwd (msg_, ($30_ = 60, &$30_), ($31_ = 101, &$31_), &_k0, &_k0, &_k0, &_k0, &_k0, ($32_ = 0.0, &$32_), ($33_ 
  = 0.0, &$33_));
  bufcpy (msg_, _dc_10, 63);
  (void) _xerrwd (msg_, ($34_ = 50, &$34_), ($35_ = 101, &$35_), &_k0, &_k0, &_k0, &_k0, ($36_ = 2, &$36_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_11, 63);
  (void) _xerrwd (msg_, ($37_ = 50, &$37_), ($38_ = 102, &$38_), &_k0, &_k0, &_k0, &_k0, &_k0, ($39_ = 0.0, &$39_), ($40_ 
  = 0.0, &$40_));
  bufcpy (msg_, _dc_12, 63);
  (void) _xerrwd (msg_, ($41_ = 50, &$41_), ($42_ = 102, &$42_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($43_ = 0.0, 
  &$43_), ($44_ = 0.0, &$44_));
  _l290:;
  (void) _dstoda (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], &iwork_[dls001_.liwm_ - 1], 
  _f, _jac, _dprja, _dsolsy);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
  }
  _l300:;
  dls001_.init_ = 1;
  if (dls001_.meth_ == dlsa01_.mused_) {
    goto _l310;
  }
  dlsa01_.tsw_ = dls001_.tn_;
  dls001_.maxord_ = dlsa01_.mxordn_;
  if (dls001_.meth_ == 2) {
    dls001_.maxord_ = dlsa01_.mxords_;
  }
  if (dls001_.meth_ == 2) {
    rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  }
  dlsa01_.insufr_ = _min (dlsa01_.insufr_, 1);
  dlsa01_.insufi_ = _min (dlsa01_.insufi_, 1);
  dls001_.jstart_ = -1;
  if (dlsa01_.ixpr_ == 0) {
    goto _l310;
  }
  if (dls001_.meth_ == 2) {
    bufcpy (msg_, _dc_13, 63);
    (void) _xerrwd (msg_, ($45_ = 60, &$45_), ($46_ = 105, &$46_), &_k0, &_k0, &_k0, &_k0, &_k0, ($47_ = 0.0, &$47_), ($48_ 
    = 0.0, &$48_));
  }
  if (dls001_.meth_ == 1) {
    bufcpy (msg_, _dc_14, 63);
    (void) _xerrwd (msg_, ($49_ = 60, &$49_), ($50_ = 106, &$50_), &_k0, &_k0, &_k0, &_k0, &_k0, ($51_ = 0.0, &$51_), ($52_ 
    = 0.0, &$52_));
  }
  bufcpy (msg_, _dc_15, 63);
  (void) _xerrwd (msg_, ($53_ = 60, &$53_), ($54_ = 107, &$54_), &_k0, &_k1, &dls001_.nst_, &_k0, ($55_ = 2, &$55_), 
  &dls001_.tn_, &dls001_.h_);
  _l310:;
  switch ((*itask_)) {
    default:
    case 1: goto _l320;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l320:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if (dls001_.jstart_ >= 0) {
    dls001_.jstart_ = -2;
  }
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  rwork_[14] = dlsa01_.tsw_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlsa01_.mused_;
  iwork_[19] = dls001_.meth_;
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_16, 63);
  (void) _xerrwd (msg_, ($56_ = 50, &$56_), ($57_ = 201, &$57_), &_k0, &_k0, &_k0, &_k0, &_k0, ($58_ = 0.0, &$58_), ($59_ 
  = 0.0, &$59_));
  bufcpy (msg_, _dc_17, 63);
  (void) _xerrwd (msg_, ($60_ = 50, &$60_), ($61_ = 201, &$61_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($62_ = 0.0, &$62_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_18, 63);
  (void) _xerrwd (msg_, ($63_ = 50, &$63_), ($64_ = 202, &$64_), &_k0, &_k1, &i_, &_k0, ($65_ = 2, &$65_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l580;
  _l520:;
  bufcpy (msg_, _dc_19, 63);
  (void) _xerrwd (msg_, ($66_ = 50, &$66_), ($67_ = 203, &$67_), &_k0, &_k0, &_k0, &_k0, &_k0, ($68_ = 0.0, &$68_), ($69_ 
  = 0.0, &$69_));
  bufcpy (msg_, _dc_20, 63);
  (void) _xerrwd (msg_, ($70_ = 50, &$70_), ($71_ = 203, &$71_), &_k0, &_k0, &_k0, &_k0, ($72_ = 2, &$72_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l580;
  _l530:;
  bufcpy (msg_, _dc_21, 63);
  (void) _xerrwd (msg_, ($73_ = 50, &$73_), ($74_ = 204, &$74_), &_k0, &_k0, &_k0, &_k0, &_k0, ($75_ = 0.0, &$75_), ($76_ 
  = 0.0, &$76_));
  bufcpy (msg_, _dc_22, 63);
  (void) _xerrwd (msg_, ($77_ = 50, &$77_), ($78_ = 204, &$78_), &_k0, &_k0, &_k0, &_k0, ($79_ = 2, &$79_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l560;
  _l540:;
  bufcpy (msg_, _dc_23, 63);
  (void) _xerrwd (msg_, ($80_ = 50, &$80_), ($81_ = 205, &$81_), &_k0, &_k0, &_k0, &_k0, &_k0, ($82_ = 0.0, &$82_), ($83_ 
  = 0.0, &$83_));
  bufcpy (msg_, _dc_24, 63);
  (void) _xerrwd (msg_, ($84_ = 50, &$84_), ($85_ = 205, &$85_), &_k0, &_k0, &_k0, &_k0, &_k0, ($86_ = 0.0, &$86_), ($87_ 
  = 0.0, &$87_));
  bufcpy (msg_, _dc_25, 63);
  (void) _xerrwd (msg_, ($88_ = 30, &$88_), ($89_ = 205, &$89_), &_k0, &_k0, &_k0, &_k0, ($90_ = 2, &$90_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  goto _l560;
  _l550:;
  bufcpy (msg_, _dc_26, 63);
  (void) _xerrwd (msg_, ($91_ = 50, &$91_), ($92_ = 206, &$92_), &_k0, &_k0, &_k0, &_k0, &_k0, ($93_ = 0.0, &$93_), ($94_ 
  = 0.0, &$94_));
  bufcpy (msg_, _dc_27, 63);
  (void) _xerrwd (msg_, ($95_ = 60, &$95_), ($96_ = 206, &$96_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.tn_, ($97_ = 0.0, 
  &$97_));
  (*istate_) = -7;
  goto _l580;
  _l555:;
  bufcpy (msg_, _dc_28, 63);
  (void) _xerrwd (msg_, ($98_ = 50, &$98_), ($99_ = 207, &$99_), &_k0, &_k0, &_k0, &_k0, &_k0, ($100_ = 0.0, &$100_), 
  ($101_ = 0.0, &$101_));
  bufcpy (msg_, _dc_27, 63);
  (void) _xerrwd (msg_, ($102_ = 60, &$102_), ($103_ = 207, &$103_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.tn_, ($104_ = 
  0.0, &$104_));
  (*istate_) = -7;
  goto _l580;
  _l560:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l570;
    }
    big_ = size_;
    imxer_ = i_;
    _l570:;
  }
  iwork_[15] = imxer_;
  _l580:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  rwork_[14] = dlsa01_.tsw_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlsa01_.mused_;
  iwork_[19] = dls001_.meth_;
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_29, 63);
  (void) _xerrwd (msg_, ($105_ = 30, &$105_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($106_ = 0.0, &$106_), ($107_ = 0.0, 
  &$107_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_30, 63);
  (void) _xerrwd (msg_, ($108_ = 30, &$108_), ($109_ = 2, &$109_), &_k0, &_k1, itask_, &_k0, &_k0, ($110_ = 0.0, &$110_), 
  ($111_ = 0.0, &$111_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_31, 63);
  (void) _xerrwd (msg_, ($112_ = 50, &$112_), ($113_ = 3, &$113_), &_k0, &_k0, &_k0, &_k0, &_k0, ($114_ = 0.0, &$114_), 
  ($115_ = 0.0, &$115_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_32, 63);
  (void) _xerrwd (msg_, ($116_ = 30, &$116_), ($117_ = 4, &$117_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($118_ = 0.0, 
  &$118_), ($119_ = 0.0, &$119_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_33, 63);
  (void) _xerrwd (msg_, ($120_ = 50, &$120_), ($121_ = 5, &$121_), &_k0, ($122_ = 2, &$122_), &dls001_.n_, &neq_[0], 
  &_k0, ($123_ = 0.0, &$123_), ($124_ = 0.0, &$124_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_34, 63);
  (void) _xerrwd (msg_, ($125_ = 30, &$125_), ($126_ = 6, &$126_), &_k0, &_k1, itol_, &_k0, &_k0, ($127_ = 0.0, &$127_), 
  ($128_ = 0.0, &$128_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_35, 63);
  (void) _xerrwd (msg_, ($129_ = 30, &$129_), ($130_ = 7, &$130_), &_k0, &_k1, iopt_, &_k0, &_k0, ($131_ = 0.0, &$131_), 
  ($132_ = 0.0, &$132_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_36, 63);
  (void) _xerrwd (msg_, ($133_ = 30, &$133_), ($134_ = 8, &$134_), &_k0, &_k1, jt_, &_k0, &_k0, ($135_ = 0.0, &$135_), 
  ($136_ = 0.0, &$136_));
  goto _l700;
  _l609:;
  bufcpy (msg_, _dc_37, 63);
  (void) _xerrwd (msg_, ($137_ = 50, &$137_), ($138_ = 9, &$138_), &_k0, ($139_ = 2, &$139_), &ml_, &neq_[0], &_k0, 
  ($140_ = 0.0, &$140_), ($141_ = 0.0, &$141_));
  goto _l700;
  _l610:;
  bufcpy (msg_, _dc_38, 63);
  (void) _xerrwd (msg_, ($142_ = 50, &$142_), ($143_ = 10, &$143_), &_k0, ($144_ = 2, &$144_), &mu_, &neq_[0], &_k0, 
  ($145_ = 0.0, &$145_), ($146_ = 0.0, &$146_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_39, 63);
  (void) _xerrwd (msg_, ($147_ = 30, &$147_), ($148_ = 11, &$148_), &_k0, &_k1, &dlsa01_.ixpr_, &_k0, &_k0, ($149_ = 0.0, 
  &$149_), ($150_ = 0.0, &$150_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_40, 63);
  (void) _xerrwd (msg_, ($151_ = 30, &$151_), ($152_ = 12, &$152_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($153_ = 
  0.0, &$153_), ($154_ = 0.0, &$154_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_41, 63);
  (void) _xerrwd (msg_, ($155_ = 30, &$155_), ($156_ = 13, &$156_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($157_ = 
  0.0, &$157_), ($158_ = 0.0, &$158_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_42, 63);
  (void) _xerrwd (msg_, ($159_ = 40, &$159_), ($160_ = 14, &$160_), &_k0, &_k0, &_k0, &_k0, ($161_ = 2, &$161_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 63);
  (void) _xerrwd (msg_, ($162_ = 50, &$162_), ($163_ = 14, &$163_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($164_ = 0.0, 
  &$164_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_44, 63);
  (void) _xerrwd (msg_, ($165_ = 30, &$165_), ($166_ = 15, &$166_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($167_ = 0.0, 
  &$167_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_45, 63);
  (void) _xerrwd (msg_, ($168_ = 30, &$168_), ($169_ = 16, &$169_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($170_ 
  = 0.0, &$170_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_46, 63);
  (void) _xerrwd (msg_, ($171_ = 60, &$171_), ($172_ = 17, &$172_), &_k0, ($173_ = 2, &$173_), &lenrw_, lrw_, &_k0, 
  ($174_ = 0.0, &$174_), ($175_ = 0.0, &$175_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_47, 63);
  (void) _xerrwd (msg_, ($176_ = 60, &$176_), ($177_ = 18, &$177_), &_k0, ($178_ = 2, &$178_), &leniw_, liw_, &_k0, 
  ($179_ = 0.0, &$179_), ($180_ = 0.0, &$180_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_48, 63);
  (void) _xerrwd (msg_, ($181_ = 40, &$181_), ($182_ = 19, &$182_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($183_ = 0.0, 
  &$183_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_49, 63);
  (void) _xerrwd (msg_, ($184_ = 40, &$184_), ($185_ = 20, &$185_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($186_ = 0.0, 
  &$186_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_50, 63);
  (void) _xerrwd (msg_, ($187_ = 40, &$187_), ($188_ = 21, &$188_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($189_ = 0.0, 
  &$189_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_51, 63);
  (void) _xerrwd (msg_, ($190_ = 60, &$190_), ($191_ = 22, &$191_), &_k0, &_k0, &_k0, &_k0, ($192_ = 2, &$192_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_52, 63);
  (void) _xerrwd (msg_, ($193_ = 60, &$193_), ($194_ = 23, &$194_), &_k0, &_k1, itask_, &_k0, ($195_ = 2, &$195_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_53, 63);
  (void) _xerrwd (msg_, ($196_ = 60, &$196_), ($197_ = 24, &$197_), &_k0, &_k0, &_k0, &_k0, ($198_ = 2, &$198_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_54, 63);
  (void) _xerrwd (msg_, ($199_ = 60, &$199_), ($200_ = 25, &$200_), &_k0, &_k0, &_k0, &_k0, ($201_ = 2, &$201_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_55, 63);
  (void) _xerrwd (msg_, ($202_ = 50, &$202_), ($203_ = 26, &$203_), &_k0, &_k0, &_k0, &_k0, &_k0, ($204_ = 0.0, &$204_), 
  ($205_ = 0.0, &$205_));
  bufcpy (msg_, _dc_56, 63);
  (void) _xerrwd (msg_, ($206_ = 60, &$206_), ($207_ = 26, &$207_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($208_ = 0.0, 
  &$208_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_57, 63);
  (void) _xerrwd (msg_, ($209_ = 50, &$209_), ($210_ = 27, &$210_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($211_ = 0.0, 
  &$211_));
  goto _l700;
  _l628:;
  bufcpy (msg_, _dc_58, 63);
  (void) _xerrwd (msg_, ($212_ = 30, &$212_), ($213_ = 28, &$213_), &_k0, &_k1, &dlsa01_.mxordn_, &_k0, &_k0, ($214_ = 
  0.0, &$214_), ($215_ = 0.0, &$215_));
  goto _l700;
  _l629:;
  bufcpy (msg_, _dc_59, 63);
  (void) _xerrwd (msg_, ($216_ = 30, &$216_), ($217_ = 29, &$217_), &_k0, &_k1, &dlsa01_.mxords_, &_k0, &_k0, ($218_ = 
  0.0, &$218_), ($219_ = 0.0, &$219_));
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_60, 63);
  (void) _xerrwd (msg_, ($220_ = 50, &$220_), ($221_ = 303, &$221_), ($222_ = 2, &$222_), &_k0, &_k0, &_k0, &_k0, ($223_ 
  = 0.0, &$223_), ($224_ = 0.0, &$224_));
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _dlsodar (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, 
int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), int_4 _p_ jt_, real_4 (*_g)(), int_4 _p_ ng_, int_4 _p_ jroot_)
{
  static int_4 i_, i1_, i2_, iflag_, imxer_, kgo_, leniw_, lenrw_, lenwm_, lf0_, ml_, mord_[2], mu_, mxhnl0_, mxstp0_, 
  len1_, len1c_, len1n_, len1s_, len2_, leniwc_, lenrwc_, irfp_, irt_, lenyh_, lyhnew_;
  static logical_4 ihit_;
  static real_8 atoli_, ayi_, big_, ewti_, h0_, hmax_, hmx_, rh_, rtoli_, tcrit_, tdist_, tnext_, tol_, tolsf_, tp_, 
  size_, sum_, w0_;
  static char_63 msg_;
  int_4 _data_k_8, _data_k_9, _data_k_10, $0_, $1_, $4_, $5_, $8_, $9_, $10_, $13_, $14_, $17_, $18_, $21_, $22_, $23_, 
  $26_, $27_, $28_, $31_, $32_, $35_, $36_, $37_, $38_, $39_, $42_, $43_, $46_, $47_, $50_, $51_, $54_, $55_, $56_, $57_, 
  $58_, $59_, $62_, $63_, $65_, $66_, $67_, $68_, $69_, $72_, $73_, $74_, $75_, $76_, $79_, $80_, $81_, $82_, $83_, $86_, 
  $87_, $90_, $91_, $92_, $93_, $94_, $97_, $98_, $100_, $101_, $104_, $105_, $107_, $110_, $111_, $114_, $115_, $118_, 
  $119_, $122_, $123_, $124_, $127_, $128_, $131_, $132_, $135_, $136_, $139_, $140_, $141_, $144_, $145_, $146_, $149_, 
  $150_, $153_, $154_, $157_, $158_, $161_, $162_, $163_, $164_, $165_, $167_, $168_, $170_, $171_, $173_, $174_, $175_, 
  $178_, $179_, $180_, $183_, $184_, $186_, $187_, $189_, $190_, $192_, $193_, $194_, $195_, $196_, $197_, $198_, $199_, 
  $200_, $201_, $202_, $203_, $204_, $205_, $208_, $209_, $211_, $212_, $214_, $215_, $218_, $219_, $222_, $223_, $226_, 
  $227_, $230_, $231_, $232_, $235_, $236_, $239_, $240_, $243_, $244_, $245_;
  real_8 $2_, $3_, $6_, $7_, $11_, $12_, $15_, $16_, $19_, $20_, $24_, $25_, $29_, $30_, $33_, $34_, $40_, $41_, $44_, 
  $45_, $48_, $49_, $52_, $53_, $60_, $61_, $64_, $70_, $71_, $77_, $78_, $84_, $85_, $88_, $89_, $95_, $96_, $99_, $102_
  , $103_, $106_, $108_, $109_, $112_, $113_, $116_, $117_, $120_, $121_, $125_, $126_, $129_, $130_, $133_, $134_, $137_
  , $138_, $142_, $143_, $147_, $148_, $151_, $152_, $155_, $156_, $159_, $160_, $166_, $169_, $172_, $176_, $177_, $181_
  , $182_, $185_, $188_, $191_, $206_, $207_, $210_, $213_, $216_, $217_, $220_, $221_, $224_, $225_, $228_, $229_, $233_
  , $234_, $237_, $238_, $241_, $242_, $246_, $247_;
#define _data_n_8 2
  static int_4 _data_l_8[_data_n_8] = {
    12,
    5
  };
#define _data_n_9 1
  static int_4 _data_l_9[_data_n_9] = {
    500
  };
#define _data_n_10 1
  static int_4 _data_l_10[_data_n_10] = {
    10
  };
  if (__calls[27].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    mord_[0] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    mord_[1] = _data_l_8[_data_k_8++];
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    mxstp0_ = _data_l_9[_data_k_9++];
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    mxhnl0_ = _data_l_10[_data_k_10++];
  }
  if ((*istate_) < 1 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  dlsr01_.itaskc_ = (*itask_);
  if ((*istate_) == 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) == 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  if ((*jt_) == 3 || (*jt_) < 1 || (*jt_) > 5) {
    goto _l608;
  }
  dlsa01_.jtyp_ = (*jt_);
  if ((*jt_) <= 2) {
    goto _l30;
  }
  ml_ = iwork_[0];
  mu_ = iwork_[1];
  if (ml_ < 0 || ml_ >= dls001_.n_) {
    goto _l609;
  }
  if (mu_ < 0 || mu_ >= dls001_.n_) {
    goto _l610;
  }
  _l30:;
  if ((*ng_) < 0) {
    goto _l630;
  }
  if ((*istate_) == 1) {
    goto _l35;
  }
  if (dlsr01_.irfnd_ == 0 && (*ng_) != dlsr01_.ngc_) {
    goto _l631;
  }
  _l35:;
  dlsr01_.ngc_ = (*ng_);
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dlsa01_.ixpr_ = 0;
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  if ((*istate_) != 1) {
    goto _l60;
  }
  h0_ = 0.0;
  dlsa01_.mxordn_ = mord_[0];
  dlsa01_.mxords_ = mord_[1];
  goto _l60;
  _l40:;
  dlsa01_.ixpr_ = iwork_[4];
  if (dlsa01_.ixpr_ < 0 || dlsa01_.ixpr_ > 1) {
    goto _l611;
  }
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) != 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  dlsa01_.mxordn_ = iwork_[7];
  if (dlsa01_.mxordn_ < 0) {
    goto _l628;
  }
  if (dlsa01_.mxordn_ == 0) {
    dlsa01_.mxordn_ = 100;
  }
  dlsa01_.mxordn_ = _min (dlsa01_.mxordn_, mord_[0]);
  dlsa01_.mxords_ = iwork_[8];
  if (dlsa01_.mxords_ < 0) {
    goto _l629;
  }
  if (dlsa01_.mxords_ == 0) {
    dlsa01_.mxords_ = 100;
  }
  dlsa01_.mxords_ = _min (dlsa01_.mxords_, mord_[1]);
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  _l60:;
  if ((*istate_) == 1) {
    dls001_.meth_ = 1;
  }
  if ((*istate_) == 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  dlsr01_.lg0_ = 21;
  dlsr01_.lg1_ = dlsr01_.lg0_ + (*ng_);
  dlsr01_.lgx_ = dlsr01_.lg1_ + (*ng_);
  lyhnew_ = dlsr01_.lgx_ + (*ng_);
  if ((*istate_) == 1) {
    dls001_.lyh_ = lyhnew_;
  }
  if (lyhnew_ == dls001_.lyh_) {
    goto _l62;
  }
  lenyh_ = dls001_.l_ * dls001_.nyh_;
  if ((*lrw_) < lyhnew_ - 1 + lenyh_) {
    goto _l62;
  }
  i1_ = 1;
  if (lyhnew_ > dls001_.lyh_) {
    i1_ = -1;
  }
  (void) _dcopy (&lenyh_, &rwork_[dls001_.lyh_ - 1], &i1_, &rwork_[lyhnew_ - 1], &i1_);
  dls001_.lyh_ = lyhnew_;
  _l62:;
  len1n_ = lyhnew_ - 1 + (dlsa01_.mxordn_ + 1) * dls001_.nyh_;
  len1s_ = lyhnew_ - 1 + (dlsa01_.mxords_ + 1) * dls001_.nyh_;
  dls001_.lwm_ = len1s_ + 1;
  if ((*jt_) <= 2) {
    lenwm_ = dls001_.n_ * dls001_.n_ + 2;
  }
  if ((*jt_) >= 4) {
    lenwm_ = (2 * ml_ + mu_ + 1) * dls001_.n_ + 2;
  }
  len1s_ = len1s_ + lenwm_;
  len1c_ = len1n_;
  if (dls001_.meth_ == 2) {
    len1c_ = len1s_;
  }
  len1_ = _max (len1n_, len1s_);
  len2_ = 3 * dls001_.n_;
  lenrw_ = len1_ + len2_;
  lenrwc_ = len1c_ + len2_;
  iwork_[16] = lenrw_;
  dls001_.liwm_ = 1;
  leniw_ = 20 + dls001_.n_;
  leniwc_ = 20;
  if (dls001_.meth_ == 2) {
    leniwc_ = leniw_;
  }
  iwork_[17] = leniw_;
  if ((*istate_) == 1 && (*lrw_) < lenrwc_) {
    goto _l617;
  }
  if ((*istate_) == 1 && (*liw_) < leniwc_) {
    goto _l618;
  }
  if ((*istate_) == 3 && (*lrw_) < lenrwc_) {
    goto _l550;
  }
  if ((*istate_) == 3 && (*liw_) < leniwc_) {
    goto _l555;
  }
  dls001_.lewt_ = len1_ + 1;
  dlsa01_.insufr_ = 0;
  if ((*lrw_) >= lenrw_) {
    goto _l65;
  }
  dlsa01_.insufr_ = 2;
  dls001_.lewt_ = len1c_ + 1;
  bufcpy (msg_, _dc_61, 63);
  (void) _xerrwd (msg_, ($0_ = 60, &$0_), ($1_ = 103, &$1_), &_k0, &_k0, &_k0, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
  &$3_));
  bufcpy (msg_, _dc_4, 63);
  (void) _xerrwd (msg_, ($4_ = 60, &$4_), ($5_ = 103, &$5_), &_k0, &_k0, &_k0, &_k0, &_k0, ($6_ = 0.0, &$6_), ($7_ = 0.0, 
  &$7_));
  bufcpy (msg_, _dc_5, 63);
  (void) _xerrwd (msg_, ($8_ = 50, &$8_), ($9_ = 103, &$9_), &_k0, ($10_ = 2, &$10_), &lenrw_, lrw_, &_k0, ($11_ = 0.0, 
  &$11_), ($12_ = 0.0, &$12_));
  _l65:;
  dls001_.lsavf_ = dls001_.lewt_ + dls001_.n_;
  dls001_.lacor_ = dls001_.lsavf_ + dls001_.n_;
  dlsa01_.insufi_ = 0;
  if ((*liw_) >= leniw_) {
    goto _l70;
  }
  dlsa01_.insufi_ = 2;
  bufcpy (msg_, _dc_62, 63);
  (void) _xerrwd (msg_, ($13_ = 60, &$13_), ($14_ = 104, &$14_), &_k0, &_k0, &_k0, &_k0, &_k0, ($15_ = 0.0, &$15_), ($16_ 
  = 0.0, &$16_));
  bufcpy (msg_, _dc_4, 63);
  (void) _xerrwd (msg_, ($17_ = 60, &$17_), ($18_ = 104, &$18_), &_k0, &_k0, &_k0, &_k0, &_k0, ($19_ = 0.0, &$19_), ($20_ 
  = 0.0, &$20_));
  bufcpy (msg_, _dc_7, 63);
  (void) _xerrwd (msg_, ($21_ = 50, &$21_), ($22_ = 104, &$22_), &_k0, ($23_ = 2, &$23_), &leniw_, liw_, &_k0, ($24_ = 
  0.0, &$24_), ($25_ = 0.0, &$25_));
  _l70:;
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  if ((*istate_) == 1) {
    goto _l100;
  }
  dls001_.jstart_ = -1;
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.uround_ = _dumach ();
  dls001_.tn_ = (*t_);
  dlsa01_.tsw_ = (*t_);
  dls001_.maxord_ = dlsa01_.mxordn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l110;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l110:;
  dls001_.jstart_ = 0;
  dls001_.nhnil_ = 0;
  dls001_.nst_ = 0;
  dls001_.nje_ = 0;
  dls001_.nslast_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dlsa01_.mused_ = 0;
  dls001_.miter_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  lf0_ = dls001_.lyh_ + dls001_.nyh_;
  (void) _f (neq_, t_, y_, &rwork_[lf0_ - 1]);
  dls001_.nfe_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  dls001_.nq_ = 1;
  dls001_.h_ = 1.0;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  tdist_ = _abs ((*tout_) - (*t_));
  w0_ = _max (_abs ((*t_)), _abs ((*tout_)));
  if (tdist_ < 2.0e0 * dls001_.uround_ * w0_) {
    goto _l622;
  }
  tol_ = rtol_[0];
  if ((*itol_) <= 2) {
    goto _l140;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    tol_ = _max (tol_, rtol_[i_ - 1]);
  }
  _l140:;
  if (tol_ > 0.0e0) {
    goto _l160;
  }
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    ayi_ = _abs (y_[i_ - 1]);
    if (ayi_ != 0.0e0) {
      tol_ = _max (tol_, atoli_ / ayi_);
    }
  }
  _l160:;
  tol_ = _max (tol_, 100.0e0 * dls001_.uround_);
  tol_ = _min (tol_, 1.0e-3);
  sum_ = _dmnorm (&dls001_.n_, &rwork_[lf0_ - 1], &rwork_[dls001_.lewt_ - 1]);
  sum_ = 1.0e0 / (tol_ * w0_ * w0_) + tol_ * (sum_ * sum_);
  h0_ = 1.0e0 / sqrt (sum_);
  h0_ = _min (h0_, tdist_);
  h0_ = _sign (h0_, (*tout_) - (*t_));
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lf0_ - 1 - 1] = h0_ * rwork_[i_ + lf0_ - 1 - 1];
  }
  dlsr01_.irfnd_ = 0;
  dlsr01_.toutc_ = (*tout_);
  if (dlsr01_.ngc_ == 0) {
    goto _l270;
  }
  (void) _drchek (&_k1, _g, neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dlsr01_.lg0_ - 1], 
  &rwork_[dlsr01_.lg1_ - 1], &rwork_[dlsr01_.lgx_ - 1], jroot_, &irt_);
  if (irt_ == 0) {
    goto _l270;
  }
  goto _l632;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  irfp_ = dlsr01_.irfnd_;
  if (dlsr01_.ngc_ == 0) {
    goto _l205;
  }
  if ((*itask_) == 1 || (*itask_) == 4) {
    dlsr01_.toutc_ = (*tout_);
  }
  (void) _drchek (($26_ = 2, &$26_), _g, neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dlsr01_.lg0_ - 1], 
  &rwork_[dlsr01_.lg1_ - 1], &rwork_[dlsr01_.lgx_ - 1], jroot_, &irt_);
  if (irt_ != 1) {
    goto _l205;
  }
  dlsr01_.irfnd_ = 1;
  (*istate_) = 3;
  (*t_) = dlsr01_.t0_;
  goto _l425;
  _l205:;
  dlsr01_.irfnd_ = 0;
  if (irfp_ == 1 && dlsr01_.tlast_ != dls001_.tn_ && (*itask_) == 2) {
    goto _l400;
  }
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (*t_) = dls001_.tn_;
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    (*t_) = tcrit_;
  }
  if (irfp_ == 1 && dlsr01_.tlast_ != dls001_.tn_ && (*itask_) == 5) {
    goto _l400;
  }
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2 && dls001_.jstart_ >= 0) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if (dls001_.meth_ == dlsa01_.mused_) {
    goto _l255;
  }
  if (dlsa01_.insufr_ == 1) {
    goto _l550;
  }
  if (dlsa01_.insufi_ == 1) {
    goto _l555;
  }
  _l255:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dmnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_63, 63);
  (void) _xerrwd (msg_, ($27_ = 50, &$27_), ($28_ = 101, &$28_), &_k0, &_k0, &_k0, &_k0, &_k0, ($29_ = 0.0, &$29_), ($30_ 
  = 0.0, &$30_));
  bufcpy (msg_, _dc_9, 63);
  (void) _xerrwd (msg_, ($31_ = 60, &$31_), ($32_ = 101, &$32_), &_k0, &_k0, &_k0, &_k0, &_k0, ($33_ = 0.0, &$33_), ($34_ 
  = 0.0, &$34_));
  bufcpy (msg_, _dc_10, 63);
  (void) _xerrwd (msg_, ($35_ = 50, &$35_), ($36_ = 101, &$36_), &_k0, &_k0, &_k0, &_k0, ($37_ = 2, &$37_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_64, 63);
  (void) _xerrwd (msg_, ($38_ = 50, &$38_), ($39_ = 102, &$39_), &_k0, &_k0, &_k0, &_k0, &_k0, ($40_ = 0.0, &$40_), ($41_ 
  = 0.0, &$41_));
  bufcpy (msg_, _dc_12, 63);
  (void) _xerrwd (msg_, ($42_ = 50, &$42_), ($43_ = 102, &$43_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($44_ = 0.0, 
  &$44_), ($45_ = 0.0, &$45_));
  _l290:;
  (void) _dstoda (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], &iwork_[dls001_.liwm_ - 1], 
  _f, _jac, _dprja, _dsolsy);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
  }
  _l300:;
  dls001_.init_ = 1;
  if (dls001_.meth_ == dlsa01_.mused_) {
    goto _l310;
  }
  dlsa01_.tsw_ = dls001_.tn_;
  dls001_.maxord_ = dlsa01_.mxordn_;
  if (dls001_.meth_ == 2) {
    dls001_.maxord_ = dlsa01_.mxords_;
  }
  if (dls001_.meth_ == 2) {
    rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  }
  dlsa01_.insufr_ = _min (dlsa01_.insufr_, 1);
  dlsa01_.insufi_ = _min (dlsa01_.insufi_, 1);
  dls001_.jstart_ = -1;
  if (dlsa01_.ixpr_ == 0) {
    goto _l310;
  }
  if (dls001_.meth_ == 2) {
    bufcpy (msg_, _dc_65, 63);
    (void) _xerrwd (msg_, ($46_ = 60, &$46_), ($47_ = 105, &$47_), &_k0, &_k0, &_k0, &_k0, &_k0, ($48_ = 0.0, &$48_), ($49_ 
    = 0.0, &$49_));
  }
  if (dls001_.meth_ == 1) {
    bufcpy (msg_, _dc_66, 63);
    (void) _xerrwd (msg_, ($50_ = 60, &$50_), ($51_ = 106, &$51_), &_k0, &_k0, &_k0, &_k0, &_k0, ($52_ = 0.0, &$52_), ($53_ 
    = 0.0, &$53_));
  }
  bufcpy (msg_, _dc_15, 63);
  (void) _xerrwd (msg_, ($54_ = 60, &$54_), ($55_ = 107, &$55_), &_k0, &_k1, &dls001_.nst_, &_k0, ($56_ = 2, &$56_), 
  &dls001_.tn_, &dls001_.h_);
  _l310:;
  if (dlsr01_.ngc_ == 0) {
    goto _l315;
  }
  (void) _drchek (($57_ = 3, &$57_), _g, neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dlsr01_.lg0_ - 1], 
  &rwork_[dlsr01_.lg1_ - 1], &rwork_[dlsr01_.lgx_ - 1], jroot_, &irt_);
  if (irt_ != 1) {
    goto _l315;
  }
  dlsr01_.irfnd_ = 1;
  (*istate_) = 3;
  (*t_) = dlsr01_.t0_;
  goto _l425;
  _l315:;
  switch ((*itask_)) {
    default:
    case 1: goto _l320;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l320:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if (dls001_.jstart_ >= 0) {
    dls001_.jstart_ = -2;
  }
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  _l425:;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  rwork_[14] = dlsa01_.tsw_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlsa01_.mused_;
  iwork_[19] = dls001_.meth_;
  iwork_[9] = dlsr01_.nge_;
  dlsr01_.tlast_ = (*t_);
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_67, 63);
  (void) _xerrwd (msg_, ($58_ = 50, &$58_), ($59_ = 201, &$59_), &_k0, &_k0, &_k0, &_k0, &_k0, ($60_ = 0.0, &$60_), ($61_ 
  = 0.0, &$61_));
  bufcpy (msg_, _dc_17, 63);
  (void) _xerrwd (msg_, ($62_ = 50, &$62_), ($63_ = 201, &$63_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($64_ = 0.0, &$64_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_68, 63);
  (void) _xerrwd (msg_, ($65_ = 50, &$65_), ($66_ = 202, &$66_), &_k0, &_k1, &i_, &_k0, ($67_ = 2, &$67_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l580;
  _l520:;
  bufcpy (msg_, _dc_69, 63);
  (void) _xerrwd (msg_, ($68_ = 50, &$68_), ($69_ = 203, &$69_), &_k0, &_k0, &_k0, &_k0, &_k0, ($70_ = 0.0, &$70_), ($71_ 
  = 0.0, &$71_));
  bufcpy (msg_, _dc_20, 63);
  (void) _xerrwd (msg_, ($72_ = 50, &$72_), ($73_ = 203, &$73_), &_k0, &_k0, &_k0, &_k0, ($74_ = 2, &$74_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l580;
  _l530:;
  bufcpy (msg_, _dc_70, 63);
  (void) _xerrwd (msg_, ($75_ = 50, &$75_), ($76_ = 204, &$76_), &_k0, &_k0, &_k0, &_k0, &_k0, ($77_ = 0.0, &$77_), ($78_ 
  = 0.0, &$78_));
  bufcpy (msg_, _dc_22, 63);
  (void) _xerrwd (msg_, ($79_ = 50, &$79_), ($80_ = 204, &$80_), &_k0, &_k0, &_k0, &_k0, ($81_ = 2, &$81_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l560;
  _l540:;
  bufcpy (msg_, _dc_71, 63);
  (void) _xerrwd (msg_, ($82_ = 50, &$82_), ($83_ = 205, &$83_), &_k0, &_k0, &_k0, &_k0, &_k0, ($84_ = 0.0, &$84_), ($85_ 
  = 0.0, &$85_));
  bufcpy (msg_, _dc_24, 63);
  (void) _xerrwd (msg_, ($86_ = 50, &$86_), ($87_ = 205, &$87_), &_k0, &_k0, &_k0, &_k0, &_k0, ($88_ = 0.0, &$88_), ($89_ 
  = 0.0, &$89_));
  bufcpy (msg_, _dc_25, 63);
  (void) _xerrwd (msg_, ($90_ = 30, &$90_), ($91_ = 205, &$91_), &_k0, &_k0, &_k0, &_k0, ($92_ = 2, &$92_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  goto _l560;
  _l550:;
  bufcpy (msg_, _dc_72, 63);
  (void) _xerrwd (msg_, ($93_ = 50, &$93_), ($94_ = 206, &$94_), &_k0, &_k0, &_k0, &_k0, &_k0, ($95_ = 0.0, &$95_), ($96_ 
  = 0.0, &$96_));
  bufcpy (msg_, _dc_27, 63);
  (void) _xerrwd (msg_, ($97_ = 60, &$97_), ($98_ = 206, &$98_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.tn_, ($99_ = 0.0, 
  &$99_));
  (*istate_) = -7;
  goto _l580;
  _l555:;
  bufcpy (msg_, _dc_73, 63);
  (void) _xerrwd (msg_, ($100_ = 50, &$100_), ($101_ = 207, &$101_), &_k0, &_k0, &_k0, &_k0, &_k0, ($102_ = 0.0, &$102_), 
  ($103_ = 0.0, &$103_));
  bufcpy (msg_, _dc_27, 63);
  (void) _xerrwd (msg_, ($104_ = 60, &$104_), ($105_ = 207, &$105_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.tn_, ($106_ = 
  0.0, &$106_));
  (*istate_) = -7;
  goto _l580;
  _l560:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l570;
    }
    big_ = size_;
    imxer_ = i_;
    _l570:;
  }
  iwork_[15] = imxer_;
  _l580:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  rwork_[14] = dlsa01_.tsw_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlsa01_.mused_;
  iwork_[19] = dls001_.meth_;
  iwork_[9] = dlsr01_.nge_;
  dlsr01_.tlast_ = (*t_);
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_74, 63);
  (void) _xerrwd (msg_, ($107_ = 30, &$107_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($108_ = 0.0, &$108_), ($109_ = 0.0, 
  &$109_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_75, 63);
  (void) _xerrwd (msg_, ($110_ = 30, &$110_), ($111_ = 2, &$111_), &_k0, &_k1, itask_, &_k0, &_k0, ($112_ = 0.0, &$112_), 
  ($113_ = 0.0, &$113_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_76, 63);
  (void) _xerrwd (msg_, ($114_ = 50, &$114_), ($115_ = 3, &$115_), &_k0, &_k0, &_k0, &_k0, &_k0, ($116_ = 0.0, &$116_), 
  ($117_ = 0.0, &$117_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_77, 63);
  (void) _xerrwd (msg_, ($118_ = 30, &$118_), ($119_ = 4, &$119_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($120_ = 0.0, 
  &$120_), ($121_ = 0.0, &$121_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_78, 63);
  (void) _xerrwd (msg_, ($122_ = 50, &$122_), ($123_ = 5, &$123_), &_k0, ($124_ = 2, &$124_), &dls001_.n_, &neq_[0], 
  &_k0, ($125_ = 0.0, &$125_), ($126_ = 0.0, &$126_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_79, 63);
  (void) _xerrwd (msg_, ($127_ = 30, &$127_), ($128_ = 6, &$128_), &_k0, &_k1, itol_, &_k0, &_k0, ($129_ = 0.0, &$129_), 
  ($130_ = 0.0, &$130_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_80, 63);
  (void) _xerrwd (msg_, ($131_ = 30, &$131_), ($132_ = 7, &$132_), &_k0, &_k1, iopt_, &_k0, &_k0, ($133_ = 0.0, &$133_), 
  ($134_ = 0.0, &$134_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_81, 63);
  (void) _xerrwd (msg_, ($135_ = 30, &$135_), ($136_ = 8, &$136_), &_k0, &_k1, jt_, &_k0, &_k0, ($137_ = 0.0, &$137_), 
  ($138_ = 0.0, &$138_));
  goto _l700;
  _l609:;
  bufcpy (msg_, _dc_82, 63);
  (void) _xerrwd (msg_, ($139_ = 50, &$139_), ($140_ = 9, &$140_), &_k0, ($141_ = 2, &$141_), &ml_, &neq_[0], &_k0, 
  ($142_ = 0.0, &$142_), ($143_ = 0.0, &$143_));
  goto _l700;
  _l610:;
  bufcpy (msg_, _dc_83, 63);
  (void) _xerrwd (msg_, ($144_ = 50, &$144_), ($145_ = 10, &$145_), &_k0, ($146_ = 2, &$146_), &mu_, &neq_[0], &_k0, 
  ($147_ = 0.0, &$147_), ($148_ = 0.0, &$148_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_84, 63);
  (void) _xerrwd (msg_, ($149_ = 30, &$149_), ($150_ = 11, &$150_), &_k0, &_k1, &dlsa01_.ixpr_, &_k0, &_k0, ($151_ = 0.0, 
  &$151_), ($152_ = 0.0, &$152_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_85, 63);
  (void) _xerrwd (msg_, ($153_ = 30, &$153_), ($154_ = 12, &$154_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($155_ = 
  0.0, &$155_), ($156_ = 0.0, &$156_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_86, 63);
  (void) _xerrwd (msg_, ($157_ = 30, &$157_), ($158_ = 13, &$158_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($159_ = 
  0.0, &$159_), ($160_ = 0.0, &$160_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_87, 63);
  (void) _xerrwd (msg_, ($161_ = 40, &$161_), ($162_ = 14, &$162_), &_k0, &_k0, &_k0, &_k0, ($163_ = 2, &$163_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 63);
  (void) _xerrwd (msg_, ($164_ = 50, &$164_), ($165_ = 14, &$165_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($166_ = 0.0, 
  &$166_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_88, 63);
  (void) _xerrwd (msg_, ($167_ = 30, &$167_), ($168_ = 15, &$168_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($169_ = 0.0, 
  &$169_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_89, 63);
  (void) _xerrwd (msg_, ($170_ = 30, &$170_), ($171_ = 16, &$171_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($172_ 
  = 0.0, &$172_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_90, 63);
  (void) _xerrwd (msg_, ($173_ = 60, &$173_), ($174_ = 17, &$174_), &_k0, ($175_ = 2, &$175_), &lenrw_, lrw_, &_k0, 
  ($176_ = 0.0, &$176_), ($177_ = 0.0, &$177_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_91, 63);
  (void) _xerrwd (msg_, ($178_ = 60, &$178_), ($179_ = 18, &$179_), &_k0, ($180_ = 2, &$180_), &leniw_, liw_, &_k0, 
  ($181_ = 0.0, &$181_), ($182_ = 0.0, &$182_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_92, 63);
  (void) _xerrwd (msg_, ($183_ = 40, &$183_), ($184_ = 19, &$184_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($185_ = 0.0, 
  &$185_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_93, 63);
  (void) _xerrwd (msg_, ($186_ = 40, &$186_), ($187_ = 20, &$187_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($188_ = 0.0, 
  &$188_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_94, 63);
  (void) _xerrwd (msg_, ($189_ = 40, &$189_), ($190_ = 21, &$190_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($191_ = 0.0, 
  &$191_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_95, 63);
  (void) _xerrwd (msg_, ($192_ = 60, &$192_), ($193_ = 22, &$193_), &_k0, &_k0, &_k0, &_k0, ($194_ = 2, &$194_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_96, 63);
  (void) _xerrwd (msg_, ($195_ = 60, &$195_), ($196_ = 23, &$196_), &_k0, &_k1, itask_, &_k0, ($197_ = 2, &$197_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_97, 63);
  (void) _xerrwd (msg_, ($198_ = 60, &$198_), ($199_ = 24, &$199_), &_k0, &_k0, &_k0, &_k0, ($200_ = 2, &$200_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_98, 63);
  (void) _xerrwd (msg_, ($201_ = 60, &$201_), ($202_ = 25, &$202_), &_k0, &_k0, &_k0, &_k0, ($203_ = 2, &$203_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_99, 63);
  (void) _xerrwd (msg_, ($204_ = 50, &$204_), ($205_ = 26, &$205_), &_k0, &_k0, &_k0, &_k0, &_k0, ($206_ = 0.0, &$206_), 
  ($207_ = 0.0, &$207_));
  bufcpy (msg_, _dc_56, 63);
  (void) _xerrwd (msg_, ($208_ = 60, &$208_), ($209_ = 26, &$209_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($210_ = 0.0, 
  &$210_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_100, 63);
  (void) _xerrwd (msg_, ($211_ = 50, &$211_), ($212_ = 27, &$212_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($213_ = 0.0, 
  &$213_));
  goto _l700;
  _l628:;
  bufcpy (msg_, _dc_101, 63);
  (void) _xerrwd (msg_, ($214_ = 30, &$214_), ($215_ = 28, &$215_), &_k0, &_k1, &dlsa01_.mxordn_, &_k0, &_k0, ($216_ = 
  0.0, &$216_), ($217_ = 0.0, &$217_));
  goto _l700;
  _l629:;
  bufcpy (msg_, _dc_102, 63);
  (void) _xerrwd (msg_, ($218_ = 30, &$218_), ($219_ = 29, &$219_), &_k0, &_k1, &dlsa01_.mxords_, &_k0, &_k0, ($220_ = 
  0.0, &$220_), ($221_ = 0.0, &$221_));
  goto _l700;
  _l630:;
  bufcpy (msg_, _dc_103, 63);
  (void) _xerrwd (msg_, ($222_ = 30, &$222_), ($223_ = 30, &$223_), &_k0, &_k1, ng_, &_k0, &_k0, ($224_ = 0.0, &$224_), 
  ($225_ = 0.0, &$225_));
  goto _l700;
  _l631:;
  bufcpy (msg_, _dc_104, 63);
  (void) _xerrwd (msg_, ($226_ = 50, &$226_), ($227_ = 31, &$227_), &_k0, &_k0, &_k0, &_k0, &_k0, ($228_ = 0.0, &$228_), 
  ($229_ = 0.0, &$229_));
  bufcpy (msg_, _dc_105, 63);
  (void) _xerrwd (msg_, ($230_ = 50, &$230_), ($231_ = 31, &$231_), &_k0, ($232_ = 2, &$232_), &dlsr01_.ngc_, ng_, &_k0, 
  ($233_ = 0.0, &$233_), ($234_ = 0.0, &$234_));
  goto _l700;
  _l632:;
  bufcpy (msg_, _dc_106, 63);
  (void) _xerrwd (msg_, ($235_ = 50, &$235_), ($236_ = 32, &$236_), &_k0, &_k0, &_k0, &_k0, &_k0, ($237_ = 0.0, &$237_), 
  ($238_ = 0.0, &$238_));
  bufcpy (msg_, _dc_107, 63);
  (void) _xerrwd (msg_, ($239_ = 40, &$239_), ($240_ = 32, &$240_), &_k0, &_k0, &_k0, &_k0, &_k0, ($241_ = 0.0, &$241_), 
  ($242_ = 0.0, &$242_));
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_108, 63);
  (void) _xerrwd (msg_, ($243_ = 50, &$243_), ($244_ = 303, &$244_), ($245_ = 2, &$245_), &_k0, &_k0, &_k0, &_k0, ($246_ 
  = 0.0, &$246_), ($247_ = 0.0, &$247_));
  _l0:;
  __calls[27].calls++;
  return 0;
}

int_4 _dlsode (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, 
int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), int_4 _p_ mf_)
{
  static int_4 i_, i1_, i2_, iflag_, imxer_, kgo_, lf0_, leniw_, lenrw_, lenwm_, ml_, mord_[2], mu_, mxhnl0_, mxstp0_;
  static logical_4 ihit_;
  static real_8 atoli_, ayi_, big_, ewti_, h0_, hmax_, hmx_, rh_, rtoli_, tcrit_, tdist_, tnext_, tol_, tolsf_, tp_, 
  size_, sum_, w0_;
  static char_127 msg_;
  int_4 _data_k_11, _data_k_12, _data_k_13, $0_, $1_, $4_, $5_, $8_, $9_, $10_, $11_, $12_, $15_, $16_, $19_, $20_, $23_, 
  $24_, $26_, $27_, $28_, $29_, $30_, $33_, $34_, $35_, $36_, $37_, $40_, $41_, $42_, $43_, $44_, $47_, $48_, $51_, $52_, 
  $53_, $54_, $57_, $58_, $61_, $62_, $65_, $66_, $69_, $70_, $71_, $74_, $75_, $78_, $79_, $82_, $83_, $86_, $87_, $88_, 
  $91_, $92_, $93_, $96_, $97_, $100_, $101_, $104_, $105_, $108_, $109_, $110_, $111_, $112_, $114_, $115_, $117_, $118_
  , $120_, $121_, $122_, $125_, $126_, $127_, $130_, $131_, $133_, $134_, $136_, $137_, $139_, $140_, $141_, $142_, $143_
  , $144_, $145_, $146_, $147_, $148_, $149_, $150_, $151_, $152_, $155_, $156_, $158_, $159_, $161_, $162_, $163_;
  real_8 $2_, $3_, $6_, $7_, $13_, $14_, $17_, $18_, $21_, $22_, $25_, $31_, $32_, $38_, $39_, $45_, $46_, $49_, $50_, 
  $55_, $56_, $59_, $60_, $63_, $64_, $67_, $68_, $72_, $73_, $76_, $77_, $80_, $81_, $84_, $85_, $89_, $90_, $94_, $95_, 
  $98_, $99_, $102_, $103_, $106_, $107_, $113_, $116_, $119_, $123_, $124_, $128_, $129_, $132_, $135_, $138_, $153_, 
  $154_, $157_, $160_, $164_, $165_;
#define _data_n_11 2
  static int_4 _data_l_11[_data_n_11] = {
    12,
    5
  };
#define _data_n_12 1
  static int_4 _data_l_12[_data_n_12] = {
    500
  };
#define _data_n_13 1
  static int_4 _data_l_13[_data_n_13] = {
    10
  };
  if (__calls[28].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    mord_[0] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    mord_[1] = _data_l_11[_data_k_11++];
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    mxstp0_ = _data_l_12[_data_k_12++];
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    mxhnl0_ = _data_l_13[_data_k_13++];
  }
  if ((*istate_) < 1 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  if ((*istate_) == 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) == 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  dls001_.meth_ = (*mf_) / 10;
  dls001_.miter_ = (*mf_) - 10 * dls001_.meth_;
  if (dls001_.meth_ < 1 || dls001_.meth_ > 2) {
    goto _l608;
  }
  if (dls001_.miter_ < 0 || dls001_.miter_ > 5) {
    goto _l608;
  }
  if (dls001_.miter_ <= 3) {
    goto _l30;
  }
  ml_ = iwork_[0];
  mu_ = iwork_[1];
  if (ml_ < 0 || ml_ >= dls001_.n_) {
    goto _l609;
  }
  if (mu_ < 0 || mu_ >= dls001_.n_) {
    goto _l610;
  }
  _l30:;
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dls001_.maxord_ = mord_[dls001_.meth_ - 1];
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  if ((*istate_) == 1) {
    h0_ = 0.0;
  }
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  goto _l60;
  _l40:;
  dls001_.maxord_ = iwork_[4];
  if (dls001_.maxord_ < 0) {
    goto _l611;
  }
  if (dls001_.maxord_ == 0) {
    dls001_.maxord_ = 100;
  }
  dls001_.maxord_ = _min (dls001_.maxord_, mord_[dls001_.meth_ - 1]);
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) != 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  _l60:;
  dls001_.lyh_ = 21;
  if ((*istate_) == 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  dls001_.lwm_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_;
  if (dls001_.miter_ == 0) {
    lenwm_ = 0;
  }
  if (dls001_.miter_ == 1 || dls001_.miter_ == 2) {
    lenwm_ = dls001_.n_ * dls001_.n_ + 2;
  }
  if (dls001_.miter_ == 3) {
    lenwm_ = dls001_.n_ + 2;
  }
  if (dls001_.miter_ >= 4) {
    lenwm_ = (2 * ml_ + mu_ + 1) * dls001_.n_ + 2;
  }
  dls001_.lewt_ = dls001_.lwm_ + lenwm_;
  dls001_.lsavf_ = dls001_.lewt_ + dls001_.n_;
  dls001_.lacor_ = dls001_.lsavf_ + dls001_.n_;
  lenrw_ = dls001_.lacor_ + dls001_.n_ - 1;
  iwork_[16] = lenrw_;
  dls001_.liwm_ = 1;
  leniw_ = 20 + dls001_.n_;
  if (dls001_.miter_ == 0 || dls001_.miter_ == 3) {
    leniw_ = 20;
  }
  iwork_[17] = leniw_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  if ((*istate_) == 1) {
    goto _l100;
  }
  dls001_.jstart_ = -1;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l90;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lsavf_ - 1 - 1] = rwork_[i_ + dls001_.lwm_ - 1 - 1];
  }
  _l90:;
  if (dls001_.miter_ > 0) {
    rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  }
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.uround_ = _dumach ();
  dls001_.tn_ = (*t_);
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l110;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l110:;
  dls001_.jstart_ = 0;
  if (dls001_.miter_ > 0) {
    rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  }
  dls001_.nhnil_ = 0;
  dls001_.nst_ = 0;
  dls001_.nje_ = 0;
  dls001_.nslast_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  lf0_ = dls001_.lyh_ + dls001_.nyh_;
  (void) _f (neq_, t_, y_, &rwork_[lf0_ - 1]);
  dls001_.nfe_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  dls001_.nq_ = 1;
  dls001_.h_ = 1.0;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  tdist_ = _abs ((*tout_) - (*t_));
  w0_ = _max (_abs ((*t_)), _abs ((*tout_)));
  if (tdist_ < 2.0e0 * dls001_.uround_ * w0_) {
    goto _l622;
  }
  tol_ = rtol_[0];
  if ((*itol_) <= 2) {
    goto _l140;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    tol_ = _max (tol_, rtol_[i_ - 1]);
  }
  _l140:;
  if (tol_ > 0.0e0) {
    goto _l160;
  }
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    ayi_ = _abs (y_[i_ - 1]);
    if (ayi_ != 0.0e0) {
      tol_ = _max (tol_, atoli_ / ayi_);
    }
  }
  _l160:;
  tol_ = _max (tol_, 100.0e0 * dls001_.uround_);
  tol_ = _min (tol_, 1.0e-3);
  sum_ = _dvnorm (&dls001_.n_, &rwork_[lf0_ - 1], &rwork_[dls001_.lewt_ - 1]);
  sum_ = 1.0e0 / (tol_ * w0_ * w0_) + tol_ * (sum_ * sum_);
  h0_ = 1.0e0 / sqrt (sum_);
  h0_ = _min (h0_, tdist_);
  h0_ = _sign (h0_, (*tout_) - (*t_));
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lf0_ - 1 - 1] = h0_ * rwork_[i_ + lf0_ - 1 - 1];
  }
  goto _l270;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dvnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_109, 127);
  (void) _xerrwd (msg_, ($0_ = 50, &$0_), ($1_ = 101, &$1_), &_k0, &_k0, &_k0, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
  &$3_));
  bufcpy (msg_, _dc_9, 127);
  (void) _xerrwd (msg_, ($4_ = 60, &$4_), ($5_ = 101, &$5_), &_k0, &_k0, &_k0, &_k0, &_k0, ($6_ = 0.0, &$6_), ($7_ = 0.0, 
  &$7_));
  bufcpy (msg_, _dc_110, 127);
  (void) _xerrwd (msg_, ($8_ = 50, &$8_), ($9_ = 101, &$9_), &_k0, &_k0, &_k0, &_k0, ($10_ = 2, &$10_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_111, 127);
  (void) _xerrwd (msg_, ($11_ = 50, &$11_), ($12_ = 102, &$12_), &_k0, &_k0, &_k0, &_k0, &_k0, ($13_ = 0.0, &$13_), ($14_ 
  = 0.0, &$14_));
  bufcpy (msg_, _dc_112, 127);
  (void) _xerrwd (msg_, ($15_ = 50, &$15_), ($16_ = 102, &$16_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($17_ = 0.0, 
  &$17_), ($18_ = 0.0, &$18_));
  _l290:;
  (void) _dstode (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], &iwork_[dls001_.liwm_ - 1], 
  _f, _jac, _dprepj, _dsolsy);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
  }
  _l300:;
  dls001_.init_ = 1;
  switch ((*itask_)) {
    default:
    case 1: goto _l310;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l310:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  dls001_.jstart_ = -2;
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_113, 127);
  (void) _xerrwd (msg_, ($19_ = 50, &$19_), ($20_ = 201, &$20_), &_k0, &_k0, &_k0, &_k0, &_k0, ($21_ = 0.0, &$21_), ($22_ 
  = 0.0, &$22_));
  bufcpy (msg_, _dc_17, 127);
  (void) _xerrwd (msg_, ($23_ = 50, &$23_), ($24_ = 201, &$24_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($25_ = 0.0, &$25_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_114, 127);
  (void) _xerrwd (msg_, ($26_ = 50, &$26_), ($27_ = 202, &$27_), &_k0, &_k1, &i_, &_k0, ($28_ = 2, &$28_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l580;
  _l520:;
  bufcpy (msg_, _dc_115, 127);
  (void) _xerrwd (msg_, ($29_ = 50, &$29_), ($30_ = 203, &$30_), &_k0, &_k0, &_k0, &_k0, &_k0, ($31_ = 0.0, &$31_), ($32_ 
  = 0.0, &$32_));
  bufcpy (msg_, _dc_20, 127);
  (void) _xerrwd (msg_, ($33_ = 50, &$33_), ($34_ = 203, &$34_), &_k0, &_k0, &_k0, &_k0, ($35_ = 2, &$35_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l580;
  _l530:;
  bufcpy (msg_, _dc_116, 127);
  (void) _xerrwd (msg_, ($36_ = 50, &$36_), ($37_ = 204, &$37_), &_k0, &_k0, &_k0, &_k0, &_k0, ($38_ = 0.0, &$38_), ($39_ 
  = 0.0, &$39_));
  bufcpy (msg_, _dc_22, 127);
  (void) _xerrwd (msg_, ($40_ = 50, &$40_), ($41_ = 204, &$41_), &_k0, &_k0, &_k0, &_k0, ($42_ = 2, &$42_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l560;
  _l540:;
  bufcpy (msg_, _dc_117, 127);
  (void) _xerrwd (msg_, ($43_ = 50, &$43_), ($44_ = 205, &$44_), &_k0, &_k0, &_k0, &_k0, &_k0, ($45_ = 0.0, &$45_), ($46_ 
  = 0.0, &$46_));
  bufcpy (msg_, _dc_24, 127);
  (void) _xerrwd (msg_, ($47_ = 50, &$47_), ($48_ = 205, &$48_), &_k0, &_k0, &_k0, &_k0, &_k0, ($49_ = 0.0, &$49_), ($50_ 
  = 0.0, &$50_));
  bufcpy (msg_, _dc_25, 127);
  (void) _xerrwd (msg_, ($51_ = 30, &$51_), ($52_ = 205, &$52_), &_k0, &_k0, &_k0, &_k0, ($53_ = 2, &$53_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  _l560:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l570;
    }
    big_ = size_;
    imxer_ = i_;
    _l570:;
  }
  iwork_[15] = imxer_;
  _l580:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_118, 127);
  (void) _xerrwd (msg_, ($54_ = 30, &$54_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($55_ = 0.0, &$55_), ($56_ = 0.0, 
  &$56_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_119, 127);
  (void) _xerrwd (msg_, ($57_ = 30, &$57_), ($58_ = 2, &$58_), &_k0, &_k1, itask_, &_k0, &_k0, ($59_ = 0.0, &$59_), ($60_ 
  = 0.0, &$60_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_120, 127);
  (void) _xerrwd (msg_, ($61_ = 50, &$61_), ($62_ = 3, &$62_), &_k0, &_k0, &_k0, &_k0, &_k0, ($63_ = 0.0, &$63_), ($64_ = 
  0.0, &$64_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_121, 127);
  (void) _xerrwd (msg_, ($65_ = 30, &$65_), ($66_ = 4, &$66_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($67_ = 0.0, &$67_), 
  ($68_ = 0.0, &$68_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_122, 127);
  (void) _xerrwd (msg_, ($69_ = 50, &$69_), ($70_ = 5, &$70_), &_k0, ($71_ = 2, &$71_), &dls001_.n_, &neq_[0], &_k0, 
  ($72_ = 0.0, &$72_), ($73_ = 0.0, &$73_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_123, 127);
  (void) _xerrwd (msg_, ($74_ = 30, &$74_), ($75_ = 6, &$75_), &_k0, &_k1, itol_, &_k0, &_k0, ($76_ = 0.0, &$76_), ($77_ 
  = 0.0, &$77_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_124, 127);
  (void) _xerrwd (msg_, ($78_ = 30, &$78_), ($79_ = 7, &$79_), &_k0, &_k1, iopt_, &_k0, &_k0, ($80_ = 0.0, &$80_), ($81_ 
  = 0.0, &$81_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_125, 127);
  (void) _xerrwd (msg_, ($82_ = 30, &$82_), ($83_ = 8, &$83_), &_k0, &_k1, mf_, &_k0, &_k0, ($84_ = 0.0, &$84_), ($85_ = 
  0.0, &$85_));
  goto _l700;
  _l609:;
  bufcpy (msg_, _dc_126, 127);
  (void) _xerrwd (msg_, ($86_ = 50, &$86_), ($87_ = 9, &$87_), &_k0, ($88_ = 2, &$88_), &ml_, &neq_[0], &_k0, ($89_ = 
  0.0, &$89_), ($90_ = 0.0, &$90_));
  goto _l700;
  _l610:;
  bufcpy (msg_, _dc_127, 127);
  (void) _xerrwd (msg_, ($91_ = 50, &$91_), ($92_ = 10, &$92_), &_k0, ($93_ = 2, &$93_), &mu_, &neq_[0], &_k0, ($94_ = 
  0.0, &$94_), ($95_ = 0.0, &$95_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_128, 127);
  (void) _xerrwd (msg_, ($96_ = 30, &$96_), ($97_ = 11, &$97_), &_k0, &_k1, &dls001_.maxord_, &_k0, &_k0, ($98_ = 0.0, 
  &$98_), ($99_ = 0.0, &$99_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_129, 127);
  (void) _xerrwd (msg_, ($100_ = 30, &$100_), ($101_ = 12, &$101_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($102_ = 
  0.0, &$102_), ($103_ = 0.0, &$103_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_130, 127);
  (void) _xerrwd (msg_, ($104_ = 30, &$104_), ($105_ = 13, &$105_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($106_ = 
  0.0, &$106_), ($107_ = 0.0, &$107_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_131, 127);
  (void) _xerrwd (msg_, ($108_ = 40, &$108_), ($109_ = 14, &$109_), &_k0, &_k0, &_k0, &_k0, ($110_ = 2, &$110_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 127);
  (void) _xerrwd (msg_, ($111_ = 50, &$111_), ($112_ = 14, &$112_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($113_ = 0.0, 
  &$113_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_132, 127);
  (void) _xerrwd (msg_, ($114_ = 30, &$114_), ($115_ = 15, &$115_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($116_ = 0.0, 
  &$116_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_133, 127);
  (void) _xerrwd (msg_, ($117_ = 30, &$117_), ($118_ = 16, &$118_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($119_ 
  = 0.0, &$119_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_134, 127);
  (void) _xerrwd (msg_, ($120_ = 60, &$120_), ($121_ = 17, &$121_), &_k0, ($122_ = 2, &$122_), &lenrw_, lrw_, &_k0, 
  ($123_ = 0.0, &$123_), ($124_ = 0.0, &$124_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_135, 127);
  (void) _xerrwd (msg_, ($125_ = 60, &$125_), ($126_ = 18, &$126_), &_k0, ($127_ = 2, &$127_), &leniw_, liw_, &_k0, 
  ($128_ = 0.0, &$128_), ($129_ = 0.0, &$129_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_136, 127);
  (void) _xerrwd (msg_, ($130_ = 40, &$130_), ($131_ = 19, &$131_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($132_ = 0.0, 
  &$132_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_137, 127);
  (void) _xerrwd (msg_, ($133_ = 40, &$133_), ($134_ = 20, &$134_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($135_ = 0.0, 
  &$135_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_138, 127);
  (void) _xerrwd (msg_, ($136_ = 40, &$136_), ($137_ = 21, &$137_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($138_ = 0.0, 
  &$138_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_139, 127);
  (void) _xerrwd (msg_, ($139_ = 60, &$139_), ($140_ = 22, &$140_), &_k0, &_k0, &_k0, &_k0, ($141_ = 2, &$141_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_140, 127);
  (void) _xerrwd (msg_, ($142_ = 60, &$142_), ($143_ = 23, &$143_), &_k0, &_k1, itask_, &_k0, ($144_ = 2, &$144_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_141, 127);
  (void) _xerrwd (msg_, ($145_ = 60, &$145_), ($146_ = 24, &$146_), &_k0, &_k0, &_k0, &_k0, ($147_ = 2, &$147_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_142, 127);
  (void) _xerrwd (msg_, ($148_ = 60, &$148_), ($149_ = 25, &$149_), &_k0, &_k0, &_k0, &_k0, ($150_ = 2, &$150_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_143, 127);
  (void) _xerrwd (msg_, ($151_ = 50, &$151_), ($152_ = 26, &$152_), &_k0, &_k0, &_k0, &_k0, &_k0, ($153_ = 0.0, &$153_), 
  ($154_ = 0.0, &$154_));
  bufcpy (msg_, _dc_56, 127);
  (void) _xerrwd (msg_, ($155_ = 60, &$155_), ($156_ = 26, &$156_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($157_ = 0.0, 
  &$157_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_144, 127);
  (void) _xerrwd (msg_, ($158_ = 50, &$158_), ($159_ = 27, &$159_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($160_ = 0.0, 
  &$160_));
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_145, 127);
  (void) _xerrwd (msg_, ($161_ = 50, &$161_), ($162_ = 303, &$162_), ($163_ = 2, &$163_), &_k0, &_k0, &_k0, &_k0, ($164_ 
  = 0.0, &$164_), ($165_ = 0.0, &$165_));
  _l0:;
  __calls[28].calls++;
  return 0;
}

int_4 _dlsodes (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, 
int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), int_4 _p_ mf_)
{
  static int_4 i_, i1_, i2_, iflag_, imax_, imul_, imxer_, ipflag_, ipgo_, irem_, j_, kgo_, lenrat_, lenyht_, leniw_, 
  lenrw_, lf0_, lia_, lja_, lrtem_, lwtem_, lyhd_, lyhn_, mf1_, mord_[2], mxhnl0_, mxstp0_, ncolm_;
  static logical_4 ihit_;
  static real_8 atoli_, ayi_, big_, ewti_, h0_, hmax_, hmx_, rh_, rtoli_, tcrit_, tdist_, tnext_, tol_, tolsf_, tp_, 
  size_, sum_, w0_;
  static char_63 msg_;
  int_4 _data_k_14, _data_k_15, _data_k_16, _data_k_17, $0_, $1_, $4_, $5_, $8_, $9_, $10_, $11_, $12_, $15_, $16_, $19_, 
  $20_, $23_, $24_, $26_, $27_, $28_, $29_, $30_, $33_, $34_, $35_, $36_, $37_, $40_, $41_, $42_, $43_, $44_, $47_, $48_, 
  $51_, $52_, $53_, $54_, $55_, $58_, $59_, $62_, $63_, $64_, $65_, $68_, $69_, $72_, $73_, $76_, $77_, $80_, $81_, $82_, 
  $85_, $86_, $89_, $90_, $93_, $94_, $97_, $98_, $100_, $101_, $104_, $105_, $108_, $109_, $112_, $113_, $114_, $115_, 
  $116_, $118_, $119_, $121_, $122_, $124_, $125_, $128_, $129_, $130_, $133_, $134_, $137_, $138_, $139_, $142_, $143_, 
  $145_, $146_, $148_, $149_, $151_, $152_, $153_, $154_, $155_, $156_, $157_, $158_, $159_, $160_, $161_, $162_, $163_, 
  $164_, $167_, $168_, $170_, $171_, $173_, $174_, $177_, $178_, $179_, $182_, $183_, $186_, $187_, $188_, $191_, $192_, 
  $195_, $196_, $197_, $200_, $201_, $204_, $205_, $206_, $208_, $209_, $212_, $213_, $214_, $217_, $218_, $221_, $222_, 
  $223_, $225_, $226_, $229_, $230_, $233_, $234_, $235_;
  real_8 $2_, $3_, $6_, $7_, $13_, $14_, $17_, $18_, $21_, $22_, $25_, $31_, $32_, $38_, $39_, $45_, $46_, $49_, $50_, 
  $56_, $57_, $60_, $61_, $66_, $67_, $70_, $71_, $74_, $75_, $78_, $79_, $83_, $84_, $87_, $88_, $91_, $92_, $95_, $96_, 
  $99_, $102_, $103_, $106_, $107_, $110_, $111_, $117_, $120_, $123_, $126_, $127_, $131_, $132_, $135_, $136_, $140_, 
  $141_, $144_, $147_, $150_, $165_, $166_, $169_, $172_, $175_, $176_, $180_, $181_, $184_, $185_, $189_, $190_, $193_, 
  $194_, $198_, $199_, $202_, $203_, $207_, $210_, $211_, $215_, $216_, $219_, $220_, $224_, $227_, $228_, $231_, $232_, 
  $236_, $237_;
#define _data_n_14 2
  static int_4 _data_l_14[_data_n_14] = {
    12,
    5
  };
#define _data_n_15 1
  static int_4 _data_l_15[_data_n_15] = {
    500
  };
#define _data_n_16 1
  static int_4 _data_l_16[_data_n_16] = {
    10
  };
#define _data_n_17 1
  static int_4 _data_l_17[_data_n_17] = {
    2
  };
  if (__calls[29].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    mord_[0] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    mord_[1] = _data_l_14[_data_k_14++];
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    mxstp0_ = _data_l_15[_data_k_15++];
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    mxhnl0_ = _data_l_16[_data_k_16++];
  }
  if (__calls[29].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    lenrat_ = _data_l_17[_data_k_17++];
  }
  if ((*istate_) < 1 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  if ((*istate_) == 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) == 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  dlss01_.moss_ = (*mf_) / 100;
  mf1_ = (*mf_) - 100 * dlss01_.moss_;
  dls001_.meth_ = mf1_ / 10;
  dls001_.miter_ = mf1_ - 10 * dls001_.meth_;
  if (dlss01_.moss_ < 0 || dlss01_.moss_ > 2) {
    goto _l608;
  }
  if (dls001_.meth_ < 1 || dls001_.meth_ > 2) {
    goto _l608;
  }
  if (dls001_.miter_ < 0 || dls001_.miter_ > 3) {
    goto _l608;
  }
  if (dls001_.miter_ == 0 || dls001_.miter_ == 3) {
    dlss01_.moss_ = 0;
  }
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dls001_.maxord_ = mord_[dls001_.meth_ - 1];
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  if ((*istate_) == 1) {
    h0_ = 0.0;
  }
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  dlss01_.seth_ = 0.0;
  goto _l60;
  _l40:;
  dls001_.maxord_ = iwork_[4];
  if (dls001_.maxord_ < 0) {
    goto _l611;
  }
  if (dls001_.maxord_ == 0) {
    dls001_.maxord_ = 100;
  }
  dls001_.maxord_ = _min (dls001_.maxord_, mord_[dls001_.meth_ - 1]);
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) != 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  dlss01_.seth_ = rwork_[7];
  if (dlss01_.seth_ < 0.0e0) {
    goto _l609;
  }
  _l60:;
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  dlss01_.lrat_ = lenrat_;
  if ((*istate_) == 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  dlss01_.lwmin_ = 0;
  if (dls001_.miter_ == 1) {
    dlss01_.lwmin_ = 4 * dls001_.n_ + 10 * dls001_.n_ / dlss01_.lrat_;
  }
  if (dls001_.miter_ == 2) {
    dlss01_.lwmin_ = 4 * dls001_.n_ + 11 * dls001_.n_ / dlss01_.lrat_;
  }
  if (dls001_.miter_ == 3) {
    dlss01_.lwmin_ = dls001_.n_ + 2;
  }
  dlss01_.lenyh_ = (dls001_.maxord_ + 1) * dls001_.nyh_;
  dlss01_.lrest_ = dlss01_.lenyh_ + 3 * dls001_.n_;
  lenrw_ = 20 + dlss01_.lwmin_ + dlss01_.lrest_;
  iwork_[16] = lenrw_;
  leniw_ = 30;
  if (dlss01_.moss_ == 0 && dls001_.miter_ != 0 && dls001_.miter_ != 3) {
    leniw_ = leniw_ + dls001_.n_ + 1;
  }
  iwork_[17] = leniw_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  lia_ = 31;
  if (dlss01_.moss_ == 0 && dls001_.miter_ != 0 && dls001_.miter_ != 3) {
    leniw_ = leniw_ + iwork_[lia_ + dls001_.n_ - 1] - 1;
  }
  iwork_[17] = leniw_;
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  lja_ = lia_ + dls001_.n_ + 1;
  lia_ = _min (lia_, (*liw_));
  lja_ = _min (lja_, (*liw_));
  dls001_.lwm_ = 21;
  if ((*istate_) == 1) {
    dls001_.nq_ = 1;
  }
  ncolm_ = _min (dls001_.nq_ + 1, dls001_.maxord_ + 2);
  dlss01_.lenyhm_ = ncolm_ * dls001_.nyh_;
  lenyht_ = dlss01_.lenyh_;
  if (dls001_.miter_ == 1 || dls001_.miter_ == 2) {
    lenyht_ = dlss01_.lenyhm_;
  }
  imul_ = 2;
  if ((*istate_) == 3) {
    imul_ = dlss01_.moss_;
  }
  if (dlss01_.moss_ == 2) {
    imul_ = 3;
  }
  lrtem_ = lenyht_ + imul_ * dls001_.n_;
  lwtem_ = dlss01_.lwmin_;
  if (dls001_.miter_ == 1 || dls001_.miter_ == 2) {
    lwtem_ = (*lrw_) - 20 - lrtem_;
  }
  dlss01_.lenwk_ = lwtem_;
  lyhn_ = dls001_.lwm_ + lwtem_;
  dls001_.lsavf_ = lyhn_ + lenyht_;
  dls001_.lewt_ = dls001_.lsavf_ + dls001_.n_;
  dls001_.lacor_ = dls001_.lewt_ + dls001_.n_;
  dlss01_.istatc_ = (*istate_);
  if ((*istate_) == 1) {
    goto _l100;
  }
  lyhd_ = dls001_.lyh_ - lyhn_;
  imax_ = lyhn_ - 1 + dlss01_.lenyhm_;
  if (lyhd_ < 0) {
    for (i_ = lyhn_; i_ <= imax_; (i_)++) {
      j_ = imax_ + lyhn_ - i_;
      rwork_[j_ - 1] = rwork_[j_ + lyhd_ - 1];
    }
  }
  if (lyhd_ > 0) {
    for (i_ = lyhn_; i_ <= imax_; (i_)++) {
      rwork_[i_ - 1] = rwork_[i_ + lyhd_ - 1];
    }
  }
  dls001_.lyh_ = lyhn_;
  iwork_[21] = dls001_.lyh_;
  if (dls001_.miter_ == 0 || dls001_.miter_ == 3) {
    goto _l92;
  }
  if (dlss01_.moss_ != 2) {
    goto _l85;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l85:;
  dls001_.lsavf_ = _min (dls001_.lsavf_, (*lrw_));
  dls001_.lewt_ = _min (dls001_.lewt_, (*lrw_));
  dls001_.lacor_ = _min (dls001_.lacor_, (*lrw_));
  (void) _diprep (neq_, y_, rwork_, &iwork_[lia_ - 1], &iwork_[lja_ - 1], &ipflag_, _f, _jac);
  lenrw_ = dls001_.lwm_ - 1 + dlss01_.lenwk_ + dlss01_.lrest_;
  iwork_[16] = lenrw_;
  if (ipflag_ != -1) {
    iwork_[22] = dlss01_.ipian_;
  }
  if (ipflag_ != -1) {
    iwork_[23] = dlss01_.ipjan_;
  }
  ipgo_ = -ipflag_ + 1;
  switch (ipgo_) {
    default:
    case 1: goto _l90;
    case 2: goto _l628;
    case 3: goto _l629;
    case 4: goto _l630;
    case 5: goto _l631;
    case 6: goto _l632;
    case 7: goto _l633;
  }
  _l90:;
  iwork_[21] = dls001_.lyh_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  _l92:;
  dls001_.jstart_ = -1;
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.lyh_ = lyhn_;
  iwork_[21] = dls001_.lyh_;
  dls001_.tn_ = (*t_);
  dls001_.nst_ = 0;
  dls001_.h_ = 1.0;
  dlss01_.nnz_ = 0;
  dlss01_.ngp_ = 0;
  dlss01_.nzl_ = 0;
  dlss01_.nzu_ = 0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  lf0_ = dls001_.lyh_ + dls001_.nyh_;
  (void) _f (neq_, t_, y_, &rwork_[lf0_ - 1]);
  dls001_.nfe_ = 1;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  if (dls001_.miter_ == 0 || dls001_.miter_ == 3) {
    goto _l120;
  }
  dls001_.lacor_ = _min (dls001_.lacor_, (*lrw_));
  (void) _diprep (neq_, y_, rwork_, &iwork_[lia_ - 1], &iwork_[lja_ - 1], &ipflag_, _f, _jac);
  lenrw_ = dls001_.lwm_ - 1 + dlss01_.lenwk_ + dlss01_.lrest_;
  iwork_[16] = lenrw_;
  if (ipflag_ != -1) {
    iwork_[22] = dlss01_.ipian_;
  }
  if (ipflag_ != -1) {
    iwork_[23] = dlss01_.ipjan_;
  }
  ipgo_ = -ipflag_ + 1;
  switch (ipgo_) {
    default:
    case 1: goto _l115;
    case 2: goto _l628;
    case 3: goto _l629;
    case 4: goto _l630;
    case 5: goto _l631;
    case 6: goto _l632;
    case 7: goto _l633;
  }
  _l115:;
  iwork_[21] = dls001_.lyh_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  _l120:;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l125;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l125:;
  dls001_.uround_ = _dumach ();
  dls001_.jstart_ = 0;
  if (dls001_.miter_ != 0) {
    rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  }
  dlss01_.msbj_ = 50;
  dlss01_.nslj_ = 0;
  dlss01_.ccmxj_ = 0.2;
  dlss01_.psmall_ = 1000.0e0 * dls001_.uround_;
  dlss01_.rbig_ = 0.01e0 / dlss01_.psmall_;
  dls001_.nhnil_ = 0;
  dls001_.nje_ = 0;
  dlss01_.nlu_ = 0;
  dls001_.nslast_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  lf0_ = dls001_.lyh_ + dls001_.nyh_;
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  tdist_ = _abs ((*tout_) - (*t_));
  w0_ = _max (_abs ((*t_)), _abs ((*tout_)));
  if (tdist_ < 2.0e0 * dls001_.uround_ * w0_) {
    goto _l622;
  }
  tol_ = rtol_[0];
  if ((*itol_) <= 2) {
    goto _l140;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    tol_ = _max (tol_, rtol_[i_ - 1]);
  }
  _l140:;
  if (tol_ > 0.0e0) {
    goto _l160;
  }
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    ayi_ = _abs (y_[i_ - 1]);
    if (ayi_ != 0.0e0) {
      tol_ = _max (tol_, atoli_ / ayi_);
    }
  }
  _l160:;
  tol_ = _max (tol_, 100.0e0 * dls001_.uround_);
  tol_ = _min (tol_, 1.0e-3);
  sum_ = _dvnorm (&dls001_.n_, &rwork_[lf0_ - 1], &rwork_[dls001_.lewt_ - 1]);
  sum_ = 1.0e0 / (tol_ * w0_ * w0_) + tol_ * (sum_ * sum_);
  h0_ = 1.0e0 / sqrt (sum_);
  h0_ = _min (h0_, tdist_);
  h0_ = _sign (h0_, (*tout_) - (*t_));
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lf0_ - 1 - 1] = h0_ * rwork_[i_ + lf0_ - 1 - 1];
  }
  goto _l270;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dvnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_146, 63);
  (void) _xerrwd (msg_, ($0_ = 50, &$0_), ($1_ = 101, &$1_), &_k0, &_k0, &_k0, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
  &$3_));
  bufcpy (msg_, _dc_9, 63);
  (void) _xerrwd (msg_, ($4_ = 60, &$4_), ($5_ = 101, &$5_), &_k0, &_k0, &_k0, &_k0, &_k0, ($6_ = 0.0, &$6_), ($7_ = 0.0, 
  &$7_));
  bufcpy (msg_, _dc_10, 63);
  (void) _xerrwd (msg_, ($8_ = 50, &$8_), ($9_ = 101, &$9_), &_k0, &_k0, &_k0, &_k0, ($10_ = 2, &$10_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_147, 63);
  (void) _xerrwd (msg_, ($11_ = 50, &$11_), ($12_ = 102, &$12_), &_k0, &_k0, &_k0, &_k0, &_k0, ($13_ = 0.0, &$13_), ($14_ 
  = 0.0, &$14_));
  bufcpy (msg_, _dc_12, 63);
  (void) _xerrwd (msg_, ($15_ = 50, &$15_), ($16_ = 102, &$16_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($17_ = 0.0, 
  &$17_), ($18_ = 0.0, &$18_));
  _l290:;
  (void) _dstode (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], &rwork_[dls001_.lwm_ - 1], _f, 
  _jac, _dprjs, _dsolss);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
    case 4: goto _l550;
  }
  _l300:;
  dls001_.init_ = 1;
  switch ((*itask_)) {
    default:
    case 1: goto _l310;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l310:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  dls001_.jstart_ = -2;
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlss01_.nnz_;
  iwork_[19] = dlss01_.ngp_;
  iwork_[20] = dlss01_.nlu_;
  iwork_[24] = dlss01_.nzl_;
  iwork_[25] = dlss01_.nzu_;
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_148, 63);
  (void) _xerrwd (msg_, ($19_ = 50, &$19_), ($20_ = 201, &$20_), &_k0, &_k0, &_k0, &_k0, &_k0, ($21_ = 0.0, &$21_), ($22_ 
  = 0.0, &$22_));
  bufcpy (msg_, _dc_17, 63);
  (void) _xerrwd (msg_, ($23_ = 50, &$23_), ($24_ = 201, &$24_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($25_ = 0.0, &$25_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_149, 63);
  (void) _xerrwd (msg_, ($26_ = 50, &$26_), ($27_ = 202, &$27_), &_k0, &_k1, &i_, &_k0, ($28_ = 2, &$28_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l580;
  _l520:;
  bufcpy (msg_, _dc_150, 63);
  (void) _xerrwd (msg_, ($29_ = 50, &$29_), ($30_ = 203, &$30_), &_k0, &_k0, &_k0, &_k0, &_k0, ($31_ = 0.0, &$31_), ($32_ 
  = 0.0, &$32_));
  bufcpy (msg_, _dc_20, 63);
  (void) _xerrwd (msg_, ($33_ = 50, &$33_), ($34_ = 203, &$34_), &_k0, &_k0, &_k0, &_k0, ($35_ = 2, &$35_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l580;
  _l530:;
  bufcpy (msg_, _dc_151, 63);
  (void) _xerrwd (msg_, ($36_ = 50, &$36_), ($37_ = 204, &$37_), &_k0, &_k0, &_k0, &_k0, &_k0, ($38_ = 0.0, &$38_), ($39_ 
  = 0.0, &$39_));
  bufcpy (msg_, _dc_22, 63);
  (void) _xerrwd (msg_, ($40_ = 50, &$40_), ($41_ = 204, &$41_), &_k0, &_k0, &_k0, &_k0, ($42_ = 2, &$42_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l560;
  _l540:;
  bufcpy (msg_, _dc_152, 63);
  (void) _xerrwd (msg_, ($43_ = 50, &$43_), ($44_ = 205, &$44_), &_k0, &_k0, &_k0, &_k0, &_k0, ($45_ = 0.0, &$45_), ($46_ 
  = 0.0, &$46_));
  bufcpy (msg_, _dc_24, 63);
  (void) _xerrwd (msg_, ($47_ = 50, &$47_), ($48_ = 205, &$48_), &_k0, &_k0, &_k0, &_k0, &_k0, ($49_ = 0.0, &$49_), ($50_ 
  = 0.0, &$50_));
  bufcpy (msg_, _dc_25, 63);
  (void) _xerrwd (msg_, ($51_ = 30, &$51_), ($52_ = 205, &$52_), &_k0, &_k0, &_k0, &_k0, ($53_ = 2, &$53_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  goto _l560;
  _l550:;
  bufcpy (msg_, _dc_153, 63);
  (void) _xerrwd (msg_, ($54_ = 50, &$54_), ($55_ = 207, &$55_), &_k0, &_k0, &_k0, &_k0, &_k0, ($56_ = 0.0, &$56_), ($57_ 
  = 0.0, &$57_));
  bufcpy (msg_, _dc_154, 63);
  (void) _xerrwd (msg_, ($58_ = 50, &$58_), ($59_ = 207, &$59_), &_k0, &_k0, &_k0, &_k0, &_k0, ($60_ = 0.0, &$60_), ($61_ 
  = 0.0, &$61_));
  bufcpy (msg_, _dc_155, 63);
  (void) _xerrwd (msg_, ($62_ = 40, &$62_), ($63_ = 207, &$63_), &_k0, &_k0, &_k0, &_k0, ($64_ = 2, &$64_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -7;
  goto _l580;
  _l560:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l570;
    }
    big_ = size_;
    imxer_ = i_;
    _l570:;
  }
  iwork_[15] = imxer_;
  _l580:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlss01_.nnz_;
  iwork_[19] = dlss01_.ngp_;
  iwork_[20] = dlss01_.nlu_;
  iwork_[24] = dlss01_.nzl_;
  iwork_[25] = dlss01_.nzu_;
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_156, 63);
  (void) _xerrwd (msg_, ($65_ = 30, &$65_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($66_ = 0.0, &$66_), ($67_ = 0.0, 
  &$67_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_157, 63);
  (void) _xerrwd (msg_, ($68_ = 30, &$68_), ($69_ = 2, &$69_), &_k0, &_k1, itask_, &_k0, &_k0, ($70_ = 0.0, &$70_), ($71_ 
  = 0.0, &$71_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_158, 63);
  (void) _xerrwd (msg_, ($72_ = 50, &$72_), ($73_ = 3, &$73_), &_k0, &_k0, &_k0, &_k0, &_k0, ($74_ = 0.0, &$74_), ($75_ = 
  0.0, &$75_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_159, 63);
  (void) _xerrwd (msg_, ($76_ = 30, &$76_), ($77_ = 4, &$77_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($78_ = 0.0, &$78_), 
  ($79_ = 0.0, &$79_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_160, 63);
  (void) _xerrwd (msg_, ($80_ = 50, &$80_), ($81_ = 5, &$81_), &_k0, ($82_ = 2, &$82_), &dls001_.n_, &neq_[0], &_k0, 
  ($83_ = 0.0, &$83_), ($84_ = 0.0, &$84_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_161, 63);
  (void) _xerrwd (msg_, ($85_ = 30, &$85_), ($86_ = 6, &$86_), &_k0, &_k1, itol_, &_k0, &_k0, ($87_ = 0.0, &$87_), ($88_ 
  = 0.0, &$88_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_162, 63);
  (void) _xerrwd (msg_, ($89_ = 30, &$89_), ($90_ = 7, &$90_), &_k0, &_k1, iopt_, &_k0, &_k0, ($91_ = 0.0, &$91_), ($92_ 
  = 0.0, &$92_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_163, 63);
  (void) _xerrwd (msg_, ($93_ = 30, &$93_), ($94_ = 8, &$94_), &_k0, &_k1, mf_, &_k0, &_k0, ($95_ = 0.0, &$95_), ($96_ = 
  0.0, &$96_));
  goto _l700;
  _l609:;
  bufcpy (msg_, _dc_164, 63);
  (void) _xerrwd (msg_, ($97_ = 30, &$97_), ($98_ = 9, &$98_), &_k0, &_k0, &_k0, &_k0, &_k1, &dlss01_.seth_, ($99_ = 0.0, 
  &$99_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_165, 63);
  (void) _xerrwd (msg_, ($100_ = 30, &$100_), ($101_ = 11, &$101_), &_k0, &_k1, &dls001_.maxord_, &_k0, &_k0, ($102_ = 
  0.0, &$102_), ($103_ = 0.0, &$103_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_166, 63);
  (void) _xerrwd (msg_, ($104_ = 30, &$104_), ($105_ = 12, &$105_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($106_ = 
  0.0, &$106_), ($107_ = 0.0, &$107_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_167, 63);
  (void) _xerrwd (msg_, ($108_ = 30, &$108_), ($109_ = 13, &$109_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($110_ = 
  0.0, &$110_), ($111_ = 0.0, &$111_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_168, 63);
  (void) _xerrwd (msg_, ($112_ = 40, &$112_), ($113_ = 14, &$113_), &_k0, &_k0, &_k0, &_k0, ($114_ = 2, &$114_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 63);
  (void) _xerrwd (msg_, ($115_ = 50, &$115_), ($116_ = 14, &$116_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($117_ = 0.0, 
  &$117_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_169, 63);
  (void) _xerrwd (msg_, ($118_ = 30, &$118_), ($119_ = 15, &$119_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($120_ = 0.0, 
  &$120_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_170, 63);
  (void) _xerrwd (msg_, ($121_ = 30, &$121_), ($122_ = 16, &$122_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($123_ 
  = 0.0, &$123_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_171, 63);
  (void) _xerrwd (msg_, ($124_ = 50, &$124_), ($125_ = 17, &$125_), &_k0, &_k0, &_k0, &_k0, &_k0, ($126_ = 0.0, &$126_), 
  ($127_ = 0.0, &$127_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($128_ = 60, &$128_), ($129_ = 17, &$129_), &_k0, ($130_ = 2, &$130_), &lenrw_, lrw_, &_k0, 
  ($131_ = 0.0, &$131_), ($132_ = 0.0, &$132_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_173, 63);
  (void) _xerrwd (msg_, ($133_ = 50, &$133_), ($134_ = 18, &$134_), &_k0, &_k0, &_k0, &_k0, &_k0, ($135_ = 0.0, &$135_), 
  ($136_ = 0.0, &$136_));
  bufcpy (msg_, _dc_174, 63);
  (void) _xerrwd (msg_, ($137_ = 60, &$137_), ($138_ = 18, &$138_), &_k0, ($139_ = 2, &$139_), &leniw_, liw_, &_k0, 
  ($140_ = 0.0, &$140_), ($141_ = 0.0, &$141_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_175, 63);
  (void) _xerrwd (msg_, ($142_ = 40, &$142_), ($143_ = 19, &$143_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($144_ = 0.0, 
  &$144_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_176, 63);
  (void) _xerrwd (msg_, ($145_ = 40, &$145_), ($146_ = 20, &$146_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($147_ = 0.0, 
  &$147_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_177, 63);
  (void) _xerrwd (msg_, ($148_ = 40, &$148_), ($149_ = 21, &$149_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($150_ = 0.0, 
  &$150_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_178, 63);
  (void) _xerrwd (msg_, ($151_ = 60, &$151_), ($152_ = 22, &$152_), &_k0, &_k0, &_k0, &_k0, ($153_ = 2, &$153_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_179, 63);
  (void) _xerrwd (msg_, ($154_ = 60, &$154_), ($155_ = 23, &$155_), &_k0, &_k1, itask_, &_k0, ($156_ = 2, &$156_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_180, 63);
  (void) _xerrwd (msg_, ($157_ = 60, &$157_), ($158_ = 24, &$158_), &_k0, &_k0, &_k0, &_k0, ($159_ = 2, &$159_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_181, 63);
  (void) _xerrwd (msg_, ($160_ = 60, &$160_), ($161_ = 25, &$161_), &_k0, &_k0, &_k0, &_k0, ($162_ = 2, &$162_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_182, 63);
  (void) _xerrwd (msg_, ($163_ = 50, &$163_), ($164_ = 26, &$164_), &_k0, &_k0, &_k0, &_k0, &_k0, ($165_ = 0.0, &$165_), 
  ($166_ = 0.0, &$166_));
  bufcpy (msg_, _dc_56, 63);
  (void) _xerrwd (msg_, ($167_ = 60, &$167_), ($168_ = 26, &$168_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($169_ = 0.0, 
  &$169_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_183, 63);
  (void) _xerrwd (msg_, ($170_ = 50, &$170_), ($171_ = 27, &$171_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($172_ = 0.0, 
  &$172_));
  goto _l700;
  _l628:;
  bufcpy (msg_, _dc_184, 63);
  (void) _xerrwd (msg_, ($173_ = 60, &$173_), ($174_ = 28, &$174_), &_k0, &_k0, &_k0, &_k0, &_k0, ($175_ = 0.0, &$175_), 
  ($176_ = 0.0, &$176_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($177_ = 60, &$177_), ($178_ = 28, &$178_), &_k0, ($179_ = 2, &$179_), &lenrw_, lrw_, &_k0, 
  ($180_ = 0.0, &$180_), ($181_ = 0.0, &$181_));
  goto _l700;
  _l629:;
  bufcpy (msg_, _dc_185, 63);
  (void) _xerrwd (msg_, ($182_ = 60, &$182_), ($183_ = 29, &$183_), &_k0, &_k0, &_k0, &_k0, &_k0, ($184_ = 0.0, &$184_), 
  ($185_ = 0.0, &$185_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($186_ = 60, &$186_), ($187_ = 29, &$187_), &_k0, ($188_ = 2, &$188_), &lenrw_, lrw_, &_k0, 
  ($189_ = 0.0, &$189_), ($190_ = 0.0, &$190_));
  goto _l700;
  _l630:;
  bufcpy (msg_, _dc_186, 63);
  (void) _xerrwd (msg_, ($191_ = 60, &$191_), ($192_ = 30, &$192_), &_k0, &_k0, &_k0, &_k0, &_k0, ($193_ = 0.0, &$193_), 
  ($194_ = 0.0, &$194_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($195_ = 60, &$195_), ($196_ = 30, &$196_), &_k0, ($197_ = 2, &$197_), &lenrw_, lrw_, &_k0, 
  ($198_ = 0.0, &$198_), ($199_ = 0.0, &$199_));
  goto _l700;
  _l631:;
  bufcpy (msg_, _dc_187, 63);
  (void) _xerrwd (msg_, ($200_ = 60, &$200_), ($201_ = 31, &$201_), &_k0, &_k0, &_k0, &_k0, &_k0, ($202_ = 0.0, &$202_), 
  ($203_ = 0.0, &$203_));
  imul_ = (dlss01_.iys_ - 1) / dls001_.n_;
  irem_ = dlss01_.iys_ - imul_ * dls001_.n_;
  bufcpy (msg_, _dc_188, 63);
  (void) _xerrwd (msg_, ($204_ = 60, &$204_), ($205_ = 31, &$205_), &_k0, ($206_ = 2, &$206_), &imul_, &irem_, &_k1, 
  &dls001_.tn_, ($207_ = 0.0, &$207_));
  goto _l700;
  _l632:;
  bufcpy (msg_, _dc_189, 63);
  (void) _xerrwd (msg_, ($208_ = 60, &$208_), ($209_ = 32, &$209_), &_k0, &_k0, &_k0, &_k0, &_k0, ($210_ = 0.0, &$210_), 
  ($211_ = 0.0, &$211_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($212_ = 60, &$212_), ($213_ = 32, &$213_), &_k0, ($214_ = 2, &$214_), &lenrw_, lrw_, &_k0, 
  ($215_ = 0.0, &$215_), ($216_ = 0.0, &$216_));
  goto _l700;
  _l633:;
  bufcpy (msg_, _dc_190, 63);
  (void) _xerrwd (msg_, ($217_ = 60, &$217_), ($218_ = 33, &$218_), &_k0, &_k0, &_k0, &_k0, &_k0, ($219_ = 0.0, &$219_), 
  ($220_ = 0.0, &$220_));
  imul_ = (dlss01_.iys_ - 1) / dls001_.n_;
  irem_ = dlss01_.iys_ - imul_ * dls001_.n_;
  bufcpy (msg_, _dc_191, 63);
  (void) _xerrwd (msg_, ($221_ = 60, &$221_), ($222_ = 33, &$222_), &_k0, ($223_ = 2, &$223_), &imul_, &irem_, &_k1, 
  &dls001_.tn_, ($224_ = 0.0, &$224_));
  if (imul_ == 2) {
    bufcpy (msg_, _dc_192, 63);
    (void) _xerrwd (msg_, ($225_ = 60, &$225_), ($226_ = 33, &$226_), &_k0, &_k0, &_k0, &_k0, &_k0, ($227_ = 0.0, &$227_), 
    ($228_ = 0.0, &$228_));
  }
  if (imul_ == 3 || imul_ == 6) {
    bufcpy (msg_, _dc_193, 63);
    (void) _xerrwd (msg_, ($229_ = 60, &$229_), ($230_ = 33, &$230_), &_k0, &_k0, &_k0, &_k0, &_k0, ($231_ = 0.0, &$231_), 
    ($232_ = 0.0, &$232_));
  }
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_194, 63);
  (void) _xerrwd (msg_, ($233_ = 50, &$233_), ($234_ = 303, &$234_), ($235_ = 2, &$235_), &_k0, &_k0, &_k0, &_k0, ($236_ 
  = 0.0, &$236_), ($237_ = 0.0, &$237_));
  _l0:;
  __calls[29].calls++;
  return 0;
}

int_4 _dlsoibt (int_4 (*_res)(), real_4 (*_adda)(), int_4 (*_jac)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ ydoti_, 
real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ 
istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ mf_)
{
  static int_4 i_, i1_, i2_, ier_, iflag_, imxer_, ires_, kgo_, leniw_, lenrw_, lenwm_, lp_, lyd0_, mb_, mord_[2], 
  mxhnl0_, mxstp0_, nb_;
  static logical_4 ihit_;
  static real_8 atoli_, ayi_, big_, ewti_, h0_, hmax_, hmx_, rh_, rtoli_, tcrit_, tdist_, tnext_, tol_, tolsf_, tp_, 
  size_, sum_, w0_;
  static char_63 msg_;
  int_4 _data_k_18, _data_k_19, _data_k_20, $0_, $1_, $4_, $5_, $8_, $9_, $10_, $11_, $12_, $15_, $16_, $19_, $20_, $23_, 
  $24_, $26_, $27_, $28_, $29_, $30_, $33_, $34_, $35_, $36_, $37_, $40_, $41_, $42_, $43_, $44_, $47_, $48_, $51_, $52_, 
  $53_, $54_, $55_, $58_, $59_, $61_, $62_, $65_, $66_, $69_, $70_, $73_, $74_, $77_, $78_, $81_, $82_, $85_, $86_, $89_, 
  $92_, $93_, $96_, $97_, $100_, $101_, $104_, $105_, $106_, $109_, $110_, $113_, $114_, $117_, $118_, $121_, $122_, 
  $123_, $126_, $127_, $130_, $131_, $134_, $135_, $138_, $139_, $142_, $143_, $144_, $145_, $146_, $148_, $149_, $151_, 
  $152_, $154_, $155_, $156_, $159_, $160_, $161_, $164_, $165_, $167_, $168_, $170_, $171_, $173_, $174_, $175_, $176_, 
  $177_, $178_, $179_, $180_, $181_, $182_, $183_, $184_, $185_, $186_, $189_, $190_, $192_, $193_, $195_, $196_, $197_;
  real_8 $2_, $3_, $6_, $7_, $13_, $14_, $17_, $18_, $21_, $22_, $25_, $31_, $32_, $38_, $39_, $45_, $46_, $49_, $50_, 
  $56_, $57_, $60_, $63_, $64_, $67_, $68_, $71_, $72_, $75_, $76_, $79_, $80_, $83_, $84_, $87_, $88_, $90_, $91_, $94_, 
  $95_, $98_, $99_, $102_, $103_, $107_, $108_, $111_, $112_, $115_, $116_, $119_, $120_, $124_, $125_, $128_, $129_, 
  $132_, $133_, $136_, $137_, $140_, $141_, $147_, $150_, $153_, $157_, $158_, $162_, $163_, $166_, $169_, $172_, $187_, 
  $188_, $191_, $194_, $198_, $199_;
#define _data_n_18 2
  static int_4 _data_l_18[_data_n_18] = {
    12,
    5
  };
#define _data_n_19 1
  static int_4 _data_l_19[_data_n_19] = {
    500
  };
#define _data_n_20 1
  static int_4 _data_l_20[_data_n_20] = {
    10
  };
  if (__calls[30].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    mord_[0] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    mord_[1] = _data_l_18[_data_k_18++];
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    mxstp0_ = _data_l_19[_data_k_19++];
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    mxhnl0_ = _data_l_20[_data_k_20++];
  }
  if ((*istate_) < 0 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  if ((*istate_) <= 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) <= 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  dls001_.meth_ = (*mf_) / 10;
  dls001_.miter_ = (*mf_) - 10 * dls001_.meth_;
  if (dls001_.meth_ < 1 || dls001_.meth_ > 2) {
    goto _l608;
  }
  if (dls001_.miter_ < 1 || dls001_.miter_ > 2) {
    goto _l608;
  }
  mb_ = iwork_[0];
  nb_ = iwork_[1];
  if (mb_ < 1 || mb_ > dls001_.n_) {
    goto _l609;
  }
  if (nb_ < 4) {
    goto _l610;
  }
  if (mb_ * nb_ != dls001_.n_) {
    goto _l609;
  }
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dls001_.maxord_ = mord_[dls001_.meth_ - 1];
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  if ((*istate_) <= 1) {
    h0_ = 0.0;
  }
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  goto _l60;
  _l40:;
  dls001_.maxord_ = iwork_[4];
  if (dls001_.maxord_ < 0) {
    goto _l611;
  }
  if (dls001_.maxord_ == 0) {
    dls001_.maxord_ = 100;
  }
  dls001_.maxord_ = _min (dls001_.maxord_, mord_[dls001_.meth_ - 1]);
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) > 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  _l60:;
  dls001_.lyh_ = 21;
  if ((*istate_) <= 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  dls001_.lwm_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_;
  lenwm_ = 3 * mb_ * mb_ * nb_ + 2;
  dls001_.lewt_ = dls001_.lwm_ + lenwm_;
  dls001_.lsavf_ = dls001_.lewt_ + dls001_.n_;
  dls001_.lacor_ = dls001_.lsavf_ + dls001_.n_;
  lenrw_ = dls001_.lacor_ + dls001_.n_ - 1;
  iwork_[16] = lenrw_;
  dls001_.liwm_ = 1;
  leniw_ = 20 + dls001_.n_;
  iwork_[17] = leniw_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  if ((*istate_) <= 1) {
    goto _l100;
  }
  dls001_.jstart_ = -1;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l90;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    ydoti_[i_ - 1] = rwork_[i_ + dls001_.lwm_ - 1 - 1];
  }
  _l90:;
  rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.uround_ = _dumach ();
  dls001_.tn_ = (*t_);
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l105;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l105:;
  dls001_.jstart_ = 0;
  rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  dls001_.nhnil_ = 0;
  dls001_.nst_ = 0;
  dls001_.nfe_ = 0;
  dls001_.nje_ = 0;
  dls001_.nslast_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  lyd0_ = dls001_.lyh_ + dls001_.nyh_;
  lp_ = dls001_.lwm_ + 1;
  if ((*istate_) == 1) {
    goto _l120;
  }
  (void) _daigbt (_res, _adda, neq_, t_, y_, &rwork_[lyd0_ - 1], &mb_, &nb_, &rwork_[lp_ - 1], &iwork_[20], &ier_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ier_ < 0) {
    goto _l560;
  }
  if (ier_ > 0) {
    goto _l565;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  goto _l130;
  _l120:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
    rwork_[i_ + lyd0_ - 1 - 1] = ydoti_[i_ - 1];
  }
  _l130:;
  dls001_.nq_ = 1;
  dls001_.h_ = 1.0;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  tdist_ = _abs ((*tout_) - (*t_));
  w0_ = _max (_abs ((*t_)), _abs ((*tout_)));
  if (tdist_ < 2.0e0 * dls001_.uround_ * w0_) {
    goto _l622;
  }
  tol_ = rtol_[0];
  if ((*itol_) <= 2) {
    goto _l145;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    tol_ = _max (tol_, rtol_[i_ - 1]);
  }
  _l145:;
  if (tol_ > 0.0e0) {
    goto _l160;
  }
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    ayi_ = _abs (y_[i_ - 1]);
    if (ayi_ != 0.0e0) {
      tol_ = _max (tol_, atoli_ / ayi_);
    }
  }
  _l160:;
  tol_ = _max (tol_, 100.0e0 * dls001_.uround_);
  tol_ = _min (tol_, 1.0e-3);
  sum_ = _dvnorm (&dls001_.n_, &rwork_[lyd0_ - 1], &rwork_[dls001_.lewt_ - 1]);
  sum_ = 1.0e0 / (tol_ * w0_ * w0_) + tol_ * (sum_ * sum_);
  h0_ = 1.0e0 / sqrt (sum_);
  h0_ = _min (h0_, tdist_);
  h0_ = _sign (h0_, (*tout_) - (*t_));
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lyd0_ - 1 - 1] = h0_ * rwork_[i_ + lyd0_ - 1 - 1];
  }
  goto _l270;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dvnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_195, 63);
  (void) _xerrwd (msg_, ($0_ = 50, &$0_), ($1_ = 101, &$1_), &_k0, &_k0, &_k0, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
  &$3_));
  bufcpy (msg_, _dc_9, 63);
  (void) _xerrwd (msg_, ($4_ = 60, &$4_), ($5_ = 101, &$5_), &_k0, &_k0, &_k0, &_k0, &_k0, ($6_ = 0.0, &$6_), ($7_ = 0.0, 
  &$7_));
  bufcpy (msg_, _dc_10, 63);
  (void) _xerrwd (msg_, ($8_ = 50, &$8_), ($9_ = 101, &$9_), &_k0, &_k0, &_k0, &_k0, ($10_ = 2, &$10_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_196, 63);
  (void) _xerrwd (msg_, ($11_ = 50, &$11_), ($12_ = 102, &$12_), &_k0, &_k0, &_k0, &_k0, &_k0, ($13_ = 0.0, &$13_), ($14_ 
  = 0.0, &$14_));
  bufcpy (msg_, _dc_12, 63);
  (void) _xerrwd (msg_, ($15_ = 50, &$15_), ($16_ = 102, &$16_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($17_ = 0.0, 
  &$17_), ($18_ = 0.0, &$18_));
  _l290:;
  (void) _dstodi (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], ydoti_, &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], &iwork_[dls001_.liwm_ 
  - 1], _res, _adda, _jac, _dpjibt, _dslsbt);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
    case 4: goto _l400;
    case 5: goto _l550;
  }
  _l300:;
  dls001_.init_ = 1;
  switch ((*itask_)) {
    default:
    case 1: goto _l310;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l310:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  dls001_.jstart_ = -2;
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  if (dls001_.kflag_ == -3) {
    (*istate_) = 3;
  }
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_197, 63);
  (void) _xerrwd (msg_, ($19_ = 50, &$19_), ($20_ = 201, &$20_), &_k0, &_k0, &_k0, &_k0, &_k0, ($21_ = 0.0, &$21_), ($22_ 
  = 0.0, &$22_));
  bufcpy (msg_, _dc_17, 63);
  (void) _xerrwd (msg_, ($23_ = 50, &$23_), ($24_ = 201, &$24_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($25_ = 0.0, &$25_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_198, 63);
  (void) _xerrwd (msg_, ($26_ = 50, &$26_), ($27_ = 202, &$27_), &_k0, &_k1, &i_, &_k0, ($28_ = 2, &$28_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l590;
  _l520:;
  bufcpy (msg_, _dc_199, 63);
  (void) _xerrwd (msg_, ($29_ = 50, &$29_), ($30_ = 203, &$30_), &_k0, &_k0, &_k0, &_k0, &_k0, ($31_ = 0.0, &$31_), ($32_ 
  = 0.0, &$32_));
  bufcpy (msg_, _dc_20, 63);
  (void) _xerrwd (msg_, ($33_ = 50, &$33_), ($34_ = 203, &$34_), &_k0, &_k0, &_k0, &_k0, ($35_ = 2, &$35_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l590;
  _l530:;
  bufcpy (msg_, _dc_200, 63);
  (void) _xerrwd (msg_, ($36_ = 50, &$36_), ($37_ = 204, &$37_), &_k0, &_k0, &_k0, &_k0, &_k0, ($38_ = 0.0, &$38_), ($39_ 
  = 0.0, &$39_));
  bufcpy (msg_, _dc_201, 63);
  (void) _xerrwd (msg_, ($40_ = 50, &$40_), ($41_ = 204, &$41_), &_k0, &_k0, &_k0, &_k0, ($42_ = 2, &$42_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l570;
  _l540:;
  bufcpy (msg_, _dc_200, 63);
  (void) _xerrwd (msg_, ($43_ = 50, &$43_), ($44_ = 205, &$44_), &_k0, &_k0, &_k0, &_k0, &_k0, ($45_ = 0.0, &$45_), ($46_ 
  = 0.0, &$46_));
  bufcpy (msg_, _dc_24, 63);
  (void) _xerrwd (msg_, ($47_ = 50, &$47_), ($48_ = 205, &$48_), &_k0, &_k0, &_k0, &_k0, &_k0, ($49_ = 0.0, &$49_), ($50_ 
  = 0.0, &$50_));
  bufcpy (msg_, _dc_25, 63);
  (void) _xerrwd (msg_, ($51_ = 30, &$51_), ($52_ = 205, &$52_), &_k0, &_k0, &_k0, &_k0, ($53_ = 2, &$53_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  goto _l570;
  _l550:;
  bufcpy (msg_, _dc_202, 63);
  (void) _xerrwd (msg_, ($54_ = 50, &$54_), ($55_ = 206, &$55_), &_k0, &_k0, &_k0, &_k0, &_k0, ($56_ = 0.0, &$56_), ($57_ 
  = 0.0, &$57_));
  bufcpy (msg_, _dc_203, 63);
  (void) _xerrwd (msg_, ($58_ = 40, &$58_), ($59_ = 206, &$59_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.tn_, ($60_ = 0.0, 
  &$60_));
  (*istate_) = -7;
  goto _l590;
  _l560:;
  ier_ = -ier_;
  bufcpy (msg_, _dc_204, 63);
  (void) _xerrwd (msg_, ($61_ = 60, &$61_), ($62_ = 207, &$62_), &_k0, &_k0, &_k0, &_k0, &_k0, ($63_ = 0.0, &$63_), ($64_ 
  = 0.0, &$64_));
  bufcpy (msg_, _dc_205, 63);
  (void) _xerrwd (msg_, ($65_ = 50, &$65_), ($66_ = 207, &$66_), &_k0, &_k1, &ier_, &_k0, &_k0, ($67_ = 0.0, &$67_), 
  ($68_ = 0.0, &$68_));
  (*istate_) = -8;
  goto _l0;
  _l565:;
  bufcpy (msg_, _dc_206, 63);
  (void) _xerrwd (msg_, ($69_ = 50, &$69_), ($70_ = 208, &$70_), &_k0, &_k0, &_k0, &_k0, &_k0, ($71_ = 0.0, &$71_), ($72_ 
  = 0.0, &$72_));
  bufcpy (msg_, _dc_207, 63);
  (void) _xerrwd (msg_, ($73_ = 50, &$73_), ($74_ = 208, &$74_), &_k0, &_k0, &_k0, &_k0, &_k0, ($75_ = 0.0, &$75_), ($76_ 
  = 0.0, &$76_));
  bufcpy (msg_, _dc_208, 63);
  (void) _xerrwd (msg_, ($77_ = 20, &$77_), ($78_ = 208, &$78_), &_k0, &_k1, &ier_, &_k0, &_k0, ($79_ = 0.0, &$79_), 
  ($80_ = 0.0, &$80_));
  (*istate_) = -8;
  goto _l0;
  _l570:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l575;
    }
    big_ = size_;
    imxer_ = i_;
    _l575:;
  }
  iwork_[15] = imxer_;
  _l580:;
  lyd0_ = dls001_.lyh_ + dls001_.nyh_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lsavf_ - 1 - 1] = rwork_[i_ + lyd0_ - 1 - 1] / dls001_.h_;
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, &rwork_[dls001_.lsavf_ - 1], ydoti_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ <= 1) {
    goto _l595;
  }
  bufcpy (msg_, _dc_209, 63);
  (void) _xerrwd (msg_, ($81_ = 50, &$81_), ($82_ = 210, &$82_), &_k0, &_k0, &_k0, &_k0, &_k0, ($83_ = 0.0, &$83_), ($84_ 
  = 0.0, &$84_));
  bufcpy (msg_, _dc_210, 63);
  (void) _xerrwd (msg_, ($85_ = 50, &$85_), ($86_ = 210, &$86_), &_k0, &_k1, &ires_, &_k0, &_k0, ($87_ = 0.0, &$87_), 
  ($88_ = 0.0, &$88_));
  goto _l595;
  _l590:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  _l595:;
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_211, 63);
  (void) _xerrwd (msg_, ($89_ = 30, &$89_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($90_ = 0.0, &$90_), ($91_ = 0.0, 
  &$91_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_212, 63);
  (void) _xerrwd (msg_, ($92_ = 30, &$92_), ($93_ = 2, &$93_), &_k0, &_k1, itask_, &_k0, &_k0, ($94_ = 0.0, &$94_), ($95_ 
  = 0.0, &$95_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_213, 63);
  (void) _xerrwd (msg_, ($96_ = 50, &$96_), ($97_ = 3, &$97_), &_k0, &_k0, &_k0, &_k0, &_k0, ($98_ = 0.0, &$98_), ($99_ = 
  0.0, &$99_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_214, 63);
  (void) _xerrwd (msg_, ($100_ = 30, &$100_), ($101_ = 4, &$101_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($102_ = 0.0, 
  &$102_), ($103_ = 0.0, &$103_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_215, 63);
  (void) _xerrwd (msg_, ($104_ = 50, &$104_), ($105_ = 5, &$105_), &_k0, ($106_ = 2, &$106_), &dls001_.n_, &neq_[0], 
  &_k0, ($107_ = 0.0, &$107_), ($108_ = 0.0, &$108_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_216, 63);
  (void) _xerrwd (msg_, ($109_ = 30, &$109_), ($110_ = 6, &$110_), &_k0, &_k1, itol_, &_k0, &_k0, ($111_ = 0.0, &$111_), 
  ($112_ = 0.0, &$112_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_217, 63);
  (void) _xerrwd (msg_, ($113_ = 30, &$113_), ($114_ = 7, &$114_), &_k0, &_k1, iopt_, &_k0, &_k0, ($115_ = 0.0, &$115_), 
  ($116_ = 0.0, &$116_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_218, 63);
  (void) _xerrwd (msg_, ($117_ = 30, &$117_), ($118_ = 8, &$118_), &_k0, &_k1, mf_, &_k0, &_k0, ($119_ = 0.0, &$119_), 
  ($120_ = 0.0, &$120_));
  goto _l700;
  _l609:;
  bufcpy (msg_, _dc_219, 63);
  (void) _xerrwd (msg_, ($121_ = 40, &$121_), ($122_ = 9, &$122_), &_k0, ($123_ = 2, &$123_), &mb_, &nb_, &_k0, ($124_ = 
  0.0, &$124_), ($125_ = 0.0, &$125_));
  goto _l700;
  _l610:;
  bufcpy (msg_, _dc_220, 63);
  (void) _xerrwd (msg_, ($126_ = 40, &$126_), ($127_ = 10, &$127_), &_k0, &_k1, &nb_, &_k0, &_k0, ($128_ = 0.0, &$128_), 
  ($129_ = 0.0, &$129_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_221, 63);
  (void) _xerrwd (msg_, ($130_ = 30, &$130_), ($131_ = 11, &$131_), &_k0, &_k1, &dls001_.maxord_, &_k0, &_k0, ($132_ = 
  0.0, &$132_), ($133_ = 0.0, &$133_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_222, 63);
  (void) _xerrwd (msg_, ($134_ = 30, &$134_), ($135_ = 12, &$135_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($136_ = 
  0.0, &$136_), ($137_ = 0.0, &$137_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_223, 63);
  (void) _xerrwd (msg_, ($138_ = 30, &$138_), ($139_ = 13, &$139_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($140_ = 
  0.0, &$140_), ($141_ = 0.0, &$141_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_224, 63);
  (void) _xerrwd (msg_, ($142_ = 40, &$142_), ($143_ = 14, &$143_), &_k0, &_k0, &_k0, &_k0, ($144_ = 2, &$144_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 63);
  (void) _xerrwd (msg_, ($145_ = 50, &$145_), ($146_ = 14, &$146_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($147_ = 0.0, 
  &$147_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_225, 63);
  (void) _xerrwd (msg_, ($148_ = 30, &$148_), ($149_ = 15, &$149_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($150_ = 0.0, 
  &$150_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_226, 63);
  (void) _xerrwd (msg_, ($151_ = 30, &$151_), ($152_ = 16, &$152_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($153_ 
  = 0.0, &$153_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_227, 63);
  (void) _xerrwd (msg_, ($154_ = 60, &$154_), ($155_ = 17, &$155_), &_k0, ($156_ = 2, &$156_), &lenrw_, lrw_, &_k0, 
  ($157_ = 0.0, &$157_), ($158_ = 0.0, &$158_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_228, 63);
  (void) _xerrwd (msg_, ($159_ = 60, &$159_), ($160_ = 18, &$160_), &_k0, ($161_ = 2, &$161_), &leniw_, liw_, &_k0, 
  ($162_ = 0.0, &$162_), ($163_ = 0.0, &$163_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_229, 63);
  (void) _xerrwd (msg_, ($164_ = 40, &$164_), ($165_ = 19, &$165_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($166_ = 0.0, 
  &$166_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_230, 63);
  (void) _xerrwd (msg_, ($167_ = 40, &$167_), ($168_ = 20, &$168_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($169_ = 0.0, 
  &$169_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_231, 63);
  (void) _xerrwd (msg_, ($170_ = 40, &$170_), ($171_ = 21, &$171_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($172_ = 0.0, 
  &$172_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_232, 63);
  (void) _xerrwd (msg_, ($173_ = 60, &$173_), ($174_ = 22, &$174_), &_k0, &_k0, &_k0, &_k0, ($175_ = 2, &$175_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_233, 63);
  (void) _xerrwd (msg_, ($176_ = 60, &$176_), ($177_ = 23, &$177_), &_k0, &_k1, itask_, &_k0, ($178_ = 2, &$178_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_234, 63);
  (void) _xerrwd (msg_, ($179_ = 60, &$179_), ($180_ = 24, &$180_), &_k0, &_k0, &_k0, &_k0, ($181_ = 2, &$181_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_235, 63);
  (void) _xerrwd (msg_, ($182_ = 60, &$182_), ($183_ = 25, &$183_), &_k0, &_k0, &_k0, &_k0, ($184_ = 2, &$184_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_236, 63);
  (void) _xerrwd (msg_, ($185_ = 50, &$185_), ($186_ = 26, &$186_), &_k0, &_k0, &_k0, &_k0, &_k0, ($187_ = 0.0, &$187_), 
  ($188_ = 0.0, &$188_));
  bufcpy (msg_, _dc_56, 63);
  (void) _xerrwd (msg_, ($189_ = 60, &$189_), ($190_ = 26, &$190_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($191_ = 0.0, 
  &$191_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_237, 63);
  (void) _xerrwd (msg_, ($192_ = 50, &$192_), ($193_ = 27, &$193_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($194_ = 0.0, 
  &$194_));
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_238, 63);
  (void) _xerrwd (msg_, ($195_ = 50, &$195_), ($196_ = 303, &$196_), ($197_ = 2, &$197_), &_k0, &_k0, &_k0, &_k0, ($198_ 
  = 0.0, &$198_), ($199_ = 0.0, &$199_));
  _l0:;
  __calls[30].calls++;
  return 0;
}

int_4 _dlsodi (int_4 (*_res)(), real_4 (*_adda)(), int_4 (*_jac)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ ydoti_, 
real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ 
istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ mf_)
{
  static int_4 i_, i1_, i2_, ier_, iflag_, imxer_, ires_, kgo_, leniw_, lenrw_, lenwm_, lp_, lyd0_, ml_, mord_[2], mu_, 
  mxhnl0_, mxstp0_;
  static logical_4 ihit_;
  static real_8 atoli_, ayi_, big_, ewti_, h0_, hmax_, hmx_, rh_, rtoli_, tcrit_, tdist_, tnext_, tol_, tolsf_, tp_, 
  size_, sum_, w0_;
  static char_63 msg_;
  int_4 _data_k_21, _data_k_22, _data_k_23, $0_, $1_, $4_, $5_, $8_, $9_, $10_, $11_, $12_, $15_, $16_, $19_, $20_, $23_, 
  $24_, $26_, $27_, $28_, $29_, $30_, $33_, $34_, $35_, $36_, $37_, $40_, $41_, $42_, $43_, $44_, $47_, $48_, $51_, $52_, 
  $53_, $54_, $55_, $58_, $59_, $61_, $62_, $65_, $66_, $69_, $70_, $73_, $74_, $77_, $78_, $81_, $82_, $85_, $86_, $89_, 
  $92_, $93_, $96_, $97_, $100_, $101_, $104_, $105_, $106_, $109_, $110_, $113_, $114_, $117_, $118_, $121_, $122_, 
  $123_, $126_, $127_, $128_, $131_, $132_, $135_, $136_, $139_, $140_, $143_, $144_, $145_, $146_, $147_, $149_, $150_, 
  $152_, $153_, $155_, $156_, $157_, $160_, $161_, $162_, $165_, $166_, $168_, $169_, $171_, $172_, $174_, $175_, $176_, 
  $177_, $178_, $179_, $180_, $181_, $182_, $183_, $184_, $185_, $186_, $187_, $190_, $191_, $193_, $194_, $196_, $197_, 
  $198_;
  real_8 $2_, $3_, $6_, $7_, $13_, $14_, $17_, $18_, $21_, $22_, $25_, $31_, $32_, $38_, $39_, $45_, $46_, $49_, $50_, 
  $56_, $57_, $60_, $63_, $64_, $67_, $68_, $71_, $72_, $75_, $76_, $79_, $80_, $83_, $84_, $87_, $88_, $90_, $91_, $94_, 
  $95_, $98_, $99_, $102_, $103_, $107_, $108_, $111_, $112_, $115_, $116_, $119_, $120_, $124_, $125_, $129_, $130_, 
  $133_, $134_, $137_, $138_, $141_, $142_, $148_, $151_, $154_, $158_, $159_, $163_, $164_, $167_, $170_, $173_, $188_, 
  $189_, $192_, $195_, $199_, $200_;
#define _data_n_21 2
  static int_4 _data_l_21[_data_n_21] = {
    12,
    5
  };
#define _data_n_22 1
  static int_4 _data_l_22[_data_n_22] = {
    500
  };
#define _data_n_23 1
  static int_4 _data_l_23[_data_n_23] = {
    10
  };
  if (__calls[31].calls == 0) {
    _data_k_21 = 0;
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    mord_[0] = _data_l_21[_data_k_21++];
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    mord_[1] = _data_l_21[_data_k_21++];
    _data_k_22 = 0;
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    mxstp0_ = _data_l_22[_data_k_22++];
    _data_k_23 = 0;
    if (_data_k_23 >= _data_n_23) {
      _data_k_23 = 0;
    }
    mxhnl0_ = _data_l_23[_data_k_23++];
  }
  if ((*istate_) < 0 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  if ((*istate_) <= 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) <= 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  dls001_.meth_ = (*mf_) / 10;
  dls001_.miter_ = (*mf_) - 10 * dls001_.meth_;
  if (dls001_.meth_ < 1 || dls001_.meth_ > 2) {
    goto _l608;
  }
  if (dls001_.miter_ <= 0 || dls001_.miter_ > 5) {
    goto _l608;
  }
  if (dls001_.miter_ == 3) {
    goto _l608;
  }
  if (dls001_.miter_ < 3) {
    goto _l30;
  }
  ml_ = iwork_[0];
  mu_ = iwork_[1];
  if (ml_ < 0 || ml_ >= dls001_.n_) {
    goto _l609;
  }
  if (mu_ < 0 || mu_ >= dls001_.n_) {
    goto _l610;
  }
  _l30:;
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dls001_.maxord_ = mord_[dls001_.meth_ - 1];
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  if ((*istate_) <= 1) {
    h0_ = 0.0;
  }
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  goto _l60;
  _l40:;
  dls001_.maxord_ = iwork_[4];
  if (dls001_.maxord_ < 0) {
    goto _l611;
  }
  if (dls001_.maxord_ == 0) {
    dls001_.maxord_ = 100;
  }
  dls001_.maxord_ = _min (dls001_.maxord_, mord_[dls001_.meth_ - 1]);
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) > 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  _l60:;
  dls001_.lyh_ = 21;
  if ((*istate_) <= 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  dls001_.lwm_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_;
  if (dls001_.miter_ <= 2) {
    lenwm_ = dls001_.n_ * dls001_.n_ + 2;
  }
  if (dls001_.miter_ >= 4) {
    lenwm_ = (2 * ml_ + mu_ + 1) * dls001_.n_ + 2;
  }
  dls001_.lewt_ = dls001_.lwm_ + lenwm_;
  dls001_.lsavf_ = dls001_.lewt_ + dls001_.n_;
  dls001_.lacor_ = dls001_.lsavf_ + dls001_.n_;
  lenrw_ = dls001_.lacor_ + dls001_.n_ - 1;
  iwork_[16] = lenrw_;
  dls001_.liwm_ = 1;
  leniw_ = 20 + dls001_.n_;
  iwork_[17] = leniw_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  if ((*istate_) <= 1) {
    goto _l100;
  }
  dls001_.jstart_ = -1;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l90;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    ydoti_[i_ - 1] = rwork_[i_ + dls001_.lwm_ - 1 - 1];
  }
  _l90:;
  rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.uround_ = _dumach ();
  dls001_.tn_ = (*t_);
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l105;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l105:;
  dls001_.jstart_ = 0;
  rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  dls001_.nhnil_ = 0;
  dls001_.nst_ = 0;
  dls001_.nfe_ = 0;
  dls001_.nje_ = 0;
  dls001_.nslast_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  lyd0_ = dls001_.lyh_ + dls001_.nyh_;
  lp_ = dls001_.lwm_ + 1;
  if ((*istate_) == 1) {
    goto _l120;
  }
  (void) _dainvg (_res, _adda, neq_, t_, y_, &rwork_[lyd0_ - 1], &dls001_.miter_, &ml_, &mu_, &rwork_[lp_ - 1], 
  &iwork_[20], &ier_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ier_ < 0) {
    goto _l560;
  }
  if (ier_ > 0) {
    goto _l565;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  goto _l130;
  _l120:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
    rwork_[i_ + lyd0_ - 1 - 1] = ydoti_[i_ - 1];
  }
  _l130:;
  dls001_.nq_ = 1;
  dls001_.h_ = 1.0;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  tdist_ = _abs ((*tout_) - (*t_));
  w0_ = _max (_abs ((*t_)), _abs ((*tout_)));
  if (tdist_ < 2.0e0 * dls001_.uround_ * w0_) {
    goto _l622;
  }
  tol_ = rtol_[0];
  if ((*itol_) <= 2) {
    goto _l145;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    tol_ = _max (tol_, rtol_[i_ - 1]);
  }
  _l145:;
  if (tol_ > 0.0e0) {
    goto _l160;
  }
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    ayi_ = _abs (y_[i_ - 1]);
    if (ayi_ != 0.0e0) {
      tol_ = _max (tol_, atoli_ / ayi_);
    }
  }
  _l160:;
  tol_ = _max (tol_, 100.0e0 * dls001_.uround_);
  tol_ = _min (tol_, 1.0e-3);
  sum_ = _dvnorm (&dls001_.n_, &rwork_[lyd0_ - 1], &rwork_[dls001_.lewt_ - 1]);
  sum_ = 1.0e0 / (tol_ * w0_ * w0_) + tol_ * (sum_ * sum_);
  h0_ = 1.0e0 / sqrt (sum_);
  h0_ = _min (h0_, tdist_);
  h0_ = _sign (h0_, (*tout_) - (*t_));
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lyd0_ - 1 - 1] = h0_ * rwork_[i_ + lyd0_ - 1 - 1];
  }
  goto _l270;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dvnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_239, 63);
  (void) _xerrwd (msg_, ($0_ = 50, &$0_), ($1_ = 101, &$1_), &_k0, &_k0, &_k0, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
  &$3_));
  bufcpy (msg_, _dc_9, 63);
  (void) _xerrwd (msg_, ($4_ = 60, &$4_), ($5_ = 101, &$5_), &_k0, &_k0, &_k0, &_k0, &_k0, ($6_ = 0.0, &$6_), ($7_ = 0.0, 
  &$7_));
  bufcpy (msg_, _dc_10, 63);
  (void) _xerrwd (msg_, ($8_ = 50, &$8_), ($9_ = 101, &$9_), &_k0, &_k0, &_k0, &_k0, ($10_ = 2, &$10_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_240, 63);
  (void) _xerrwd (msg_, ($11_ = 50, &$11_), ($12_ = 102, &$12_), &_k0, &_k0, &_k0, &_k0, &_k0, ($13_ = 0.0, &$13_), ($14_ 
  = 0.0, &$14_));
  bufcpy (msg_, _dc_12, 63);
  (void) _xerrwd (msg_, ($15_ = 50, &$15_), ($16_ = 102, &$16_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($17_ = 0.0, 
  &$17_), ($18_ = 0.0, &$18_));
  _l290:;
  (void) _dstodi (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], ydoti_, &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], &iwork_[dls001_.liwm_ 
  - 1], _res, _adda, _jac, _dprepji, _dsolsy);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
    case 4: goto _l400;
    case 5: goto _l550;
  }
  _l300:;
  dls001_.init_ = 1;
  switch ((*itask_)) {
    default:
    case 1: goto _l310;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l310:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  dls001_.jstart_ = -2;
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  if (dls001_.kflag_ == -3) {
    (*istate_) = 3;
  }
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_241, 63);
  (void) _xerrwd (msg_, ($19_ = 50, &$19_), ($20_ = 201, &$20_), &_k0, &_k0, &_k0, &_k0, &_k0, ($21_ = 0.0, &$21_), ($22_ 
  = 0.0, &$22_));
  bufcpy (msg_, _dc_17, 63);
  (void) _xerrwd (msg_, ($23_ = 50, &$23_), ($24_ = 201, &$24_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($25_ = 0.0, &$25_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_242, 63);
  (void) _xerrwd (msg_, ($26_ = 50, &$26_), ($27_ = 202, &$27_), &_k0, &_k1, &i_, &_k0, ($28_ = 2, &$28_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l590;
  _l520:;
  bufcpy (msg_, _dc_243, 63);
  (void) _xerrwd (msg_, ($29_ = 50, &$29_), ($30_ = 203, &$30_), &_k0, &_k0, &_k0, &_k0, &_k0, ($31_ = 0.0, &$31_), ($32_ 
  = 0.0, &$32_));
  bufcpy (msg_, _dc_20, 63);
  (void) _xerrwd (msg_, ($33_ = 50, &$33_), ($34_ = 203, &$34_), &_k0, &_k0, &_k0, &_k0, ($35_ = 2, &$35_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l590;
  _l530:;
  bufcpy (msg_, _dc_244, 63);
  (void) _xerrwd (msg_, ($36_ = 50, &$36_), ($37_ = 204, &$37_), &_k0, &_k0, &_k0, &_k0, &_k0, ($38_ = 0.0, &$38_), ($39_ 
  = 0.0, &$39_));
  bufcpy (msg_, _dc_22, 63);
  (void) _xerrwd (msg_, ($40_ = 50, &$40_), ($41_ = 204, &$41_), &_k0, &_k0, &_k0, &_k0, ($42_ = 2, &$42_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l570;
  _l540:;
  bufcpy (msg_, _dc_245, 63);
  (void) _xerrwd (msg_, ($43_ = 50, &$43_), ($44_ = 205, &$44_), &_k0, &_k0, &_k0, &_k0, &_k0, ($45_ = 0.0, &$45_), ($46_ 
  = 0.0, &$46_));
  bufcpy (msg_, _dc_24, 63);
  (void) _xerrwd (msg_, ($47_ = 50, &$47_), ($48_ = 205, &$48_), &_k0, &_k0, &_k0, &_k0, &_k0, ($49_ = 0.0, &$49_), ($50_ 
  = 0.0, &$50_));
  bufcpy (msg_, _dc_25, 63);
  (void) _xerrwd (msg_, ($51_ = 30, &$51_), ($52_ = 205, &$52_), &_k0, &_k0, &_k0, &_k0, ($53_ = 2, &$53_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  goto _l570;
  _l550:;
  bufcpy (msg_, _dc_246, 63);
  (void) _xerrwd (msg_, ($54_ = 50, &$54_), ($55_ = 206, &$55_), &_k0, &_k0, &_k0, &_k0, &_k0, ($56_ = 0.0, &$56_), ($57_ 
  = 0.0, &$57_));
  bufcpy (msg_, _dc_203, 63);
  (void) _xerrwd (msg_, ($58_ = 40, &$58_), ($59_ = 206, &$59_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.tn_, ($60_ = 0.0, 
  &$60_));
  (*istate_) = -7;
  goto _l590;
  _l560:;
  ier_ = -ier_;
  bufcpy (msg_, _dc_247, 63);
  (void) _xerrwd (msg_, ($61_ = 60, &$61_), ($62_ = 207, &$62_), &_k0, &_k0, &_k0, &_k0, &_k0, ($63_ = 0.0, &$63_), ($64_ 
  = 0.0, &$64_));
  bufcpy (msg_, _dc_248, 63);
  (void) _xerrwd (msg_, ($65_ = 50, &$65_), ($66_ = 207, &$66_), &_k0, &_k1, &ier_, &_k0, &_k0, ($67_ = 0.0, &$67_), 
  ($68_ = 0.0, &$68_));
  (*istate_) = -8;
  goto _l0;
  _l565:;
  bufcpy (msg_, _dc_249, 63);
  (void) _xerrwd (msg_, ($69_ = 50, &$69_), ($70_ = 208, &$70_), &_k0, &_k0, &_k0, &_k0, &_k0, ($71_ = 0.0, &$71_), ($72_ 
  = 0.0, &$72_));
  bufcpy (msg_, _dc_207, 63);
  (void) _xerrwd (msg_, ($73_ = 50, &$73_), ($74_ = 208, &$74_), &_k0, &_k0, &_k0, &_k0, &_k0, ($75_ = 0.0, &$75_), ($76_ 
  = 0.0, &$76_));
  bufcpy (msg_, _dc_208, 63);
  (void) _xerrwd (msg_, ($77_ = 20, &$77_), ($78_ = 208, &$78_), &_k0, &_k1, &ier_, &_k0, &_k0, ($79_ = 0.0, &$79_), 
  ($80_ = 0.0, &$80_));
  (*istate_) = -8;
  goto _l0;
  _l570:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l575;
    }
    big_ = size_;
    imxer_ = i_;
    _l575:;
  }
  iwork_[15] = imxer_;
  _l580:;
  lyd0_ = dls001_.lyh_ + dls001_.nyh_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lsavf_ - 1 - 1] = rwork_[i_ + lyd0_ - 1 - 1] / dls001_.h_;
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, &rwork_[dls001_.lsavf_ - 1], ydoti_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ <= 1) {
    goto _l595;
  }
  bufcpy (msg_, _dc_250, 63);
  (void) _xerrwd (msg_, ($81_ = 50, &$81_), ($82_ = 210, &$82_), &_k0, &_k0, &_k0, &_k0, &_k0, ($83_ = 0.0, &$83_), ($84_ 
  = 0.0, &$84_));
  bufcpy (msg_, _dc_210, 63);
  (void) _xerrwd (msg_, ($85_ = 50, &$85_), ($86_ = 210, &$86_), &_k0, &_k1, &ires_, &_k0, &_k0, ($87_ = 0.0, &$87_), 
  ($88_ = 0.0, &$88_));
  goto _l595;
  _l590:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  _l595:;
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_251, 63);
  (void) _xerrwd (msg_, ($89_ = 30, &$89_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($90_ = 0.0, &$90_), ($91_ = 0.0, 
  &$91_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_252, 63);
  (void) _xerrwd (msg_, ($92_ = 30, &$92_), ($93_ = 2, &$93_), &_k0, &_k1, itask_, &_k0, &_k0, ($94_ = 0.0, &$94_), ($95_ 
  = 0.0, &$95_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_253, 63);
  (void) _xerrwd (msg_, ($96_ = 50, &$96_), ($97_ = 3, &$97_), &_k0, &_k0, &_k0, &_k0, &_k0, ($98_ = 0.0, &$98_), ($99_ = 
  0.0, &$99_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_254, 63);
  (void) _xerrwd (msg_, ($100_ = 30, &$100_), ($101_ = 4, &$101_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($102_ = 0.0, 
  &$102_), ($103_ = 0.0, &$103_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_255, 63);
  (void) _xerrwd (msg_, ($104_ = 50, &$104_), ($105_ = 5, &$105_), &_k0, ($106_ = 2, &$106_), &dls001_.n_, &neq_[0], 
  &_k0, ($107_ = 0.0, &$107_), ($108_ = 0.0, &$108_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_256, 63);
  (void) _xerrwd (msg_, ($109_ = 30, &$109_), ($110_ = 6, &$110_), &_k0, &_k1, itol_, &_k0, &_k0, ($111_ = 0.0, &$111_), 
  ($112_ = 0.0, &$112_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_257, 63);
  (void) _xerrwd (msg_, ($113_ = 30, &$113_), ($114_ = 7, &$114_), &_k0, &_k1, iopt_, &_k0, &_k0, ($115_ = 0.0, &$115_), 
  ($116_ = 0.0, &$116_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_258, 63);
  (void) _xerrwd (msg_, ($117_ = 30, &$117_), ($118_ = 8, &$118_), &_k0, &_k1, mf_, &_k0, &_k0, ($119_ = 0.0, &$119_), 
  ($120_ = 0.0, &$120_));
  goto _l700;
  _l609:;
  bufcpy (msg_, _dc_259, 63);
  (void) _xerrwd (msg_, ($121_ = 50, &$121_), ($122_ = 9, &$122_), &_k0, ($123_ = 2, &$123_), &ml_, &neq_[0], &_k0, 
  ($124_ = 0.0, &$124_), ($125_ = 0.0, &$125_));
  goto _l700;
  _l610:;
  bufcpy (msg_, _dc_260, 63);
  (void) _xerrwd (msg_, ($126_ = 50, &$126_), ($127_ = 10, &$127_), &_k0, ($128_ = 2, &$128_), &mu_, &neq_[0], &_k0, 
  ($129_ = 0.0, &$129_), ($130_ = 0.0, &$130_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_261, 63);
  (void) _xerrwd (msg_, ($131_ = 30, &$131_), ($132_ = 11, &$132_), &_k0, &_k1, &dls001_.maxord_, &_k0, &_k0, ($133_ = 
  0.0, &$133_), ($134_ = 0.0, &$134_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_262, 63);
  (void) _xerrwd (msg_, ($135_ = 30, &$135_), ($136_ = 12, &$136_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($137_ = 
  0.0, &$137_), ($138_ = 0.0, &$138_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_263, 63);
  (void) _xerrwd (msg_, ($139_ = 30, &$139_), ($140_ = 13, &$140_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($141_ = 
  0.0, &$141_), ($142_ = 0.0, &$142_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_264, 63);
  (void) _xerrwd (msg_, ($143_ = 40, &$143_), ($144_ = 14, &$144_), &_k0, &_k0, &_k0, &_k0, ($145_ = 2, &$145_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 63);
  (void) _xerrwd (msg_, ($146_ = 50, &$146_), ($147_ = 14, &$147_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($148_ = 0.0, 
  &$148_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_265, 63);
  (void) _xerrwd (msg_, ($149_ = 30, &$149_), ($150_ = 15, &$150_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($151_ = 0.0, 
  &$151_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_266, 63);
  (void) _xerrwd (msg_, ($152_ = 30, &$152_), ($153_ = 16, &$153_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($154_ 
  = 0.0, &$154_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_267, 63);
  (void) _xerrwd (msg_, ($155_ = 60, &$155_), ($156_ = 17, &$156_), &_k0, ($157_ = 2, &$157_), &lenrw_, lrw_, &_k0, 
  ($158_ = 0.0, &$158_), ($159_ = 0.0, &$159_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_268, 63);
  (void) _xerrwd (msg_, ($160_ = 60, &$160_), ($161_ = 18, &$161_), &_k0, ($162_ = 2, &$162_), &leniw_, liw_, &_k0, 
  ($163_ = 0.0, &$163_), ($164_ = 0.0, &$164_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_269, 63);
  (void) _xerrwd (msg_, ($165_ = 40, &$165_), ($166_ = 19, &$166_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($167_ = 0.0, 
  &$167_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_270, 63);
  (void) _xerrwd (msg_, ($168_ = 40, &$168_), ($169_ = 20, &$169_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($170_ = 0.0, 
  &$170_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_271, 63);
  (void) _xerrwd (msg_, ($171_ = 40, &$171_), ($172_ = 21, &$172_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($173_ = 0.0, 
  &$173_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_272, 63);
  (void) _xerrwd (msg_, ($174_ = 60, &$174_), ($175_ = 22, &$175_), &_k0, &_k0, &_k0, &_k0, ($176_ = 2, &$176_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_273, 63);
  (void) _xerrwd (msg_, ($177_ = 60, &$177_), ($178_ = 23, &$178_), &_k0, &_k1, itask_, &_k0, ($179_ = 2, &$179_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_274, 63);
  (void) _xerrwd (msg_, ($180_ = 60, &$180_), ($181_ = 24, &$181_), &_k0, &_k0, &_k0, &_k0, ($182_ = 2, &$182_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_275, 63);
  (void) _xerrwd (msg_, ($183_ = 60, &$183_), ($184_ = 25, &$184_), &_k0, &_k0, &_k0, &_k0, ($185_ = 2, &$185_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_276, 63);
  (void) _xerrwd (msg_, ($186_ = 50, &$186_), ($187_ = 26, &$187_), &_k0, &_k0, &_k0, &_k0, &_k0, ($188_ = 0.0, &$188_), 
  ($189_ = 0.0, &$189_));
  bufcpy (msg_, _dc_56, 63);
  (void) _xerrwd (msg_, ($190_ = 60, &$190_), ($191_ = 26, &$191_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($192_ = 0.0, 
  &$192_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_277, 63);
  (void) _xerrwd (msg_, ($193_ = 50, &$193_), ($194_ = 27, &$194_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($195_ = 0.0, 
  &$195_));
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_278, 63);
  (void) _xerrwd (msg_, ($196_ = 50, &$196_), ($197_ = 303, &$197_), ($198_ = 2, &$198_), &_k0, &_k0, &_k0, &_k0, ($199_ 
  = 0.0, &$199_), ($200_ = 0.0, &$200_));
  _l0:;
  __calls[31].calls++;
  return 0;
}

int_4 _dlsodis (int_4 (*_res)(), real_4 (*_adda)(), int_4 (*_jac)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ ydoti_, 
real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ 
istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ mf_)
{
  static int_4 i_, i1_, i2_, ier_, igo_, iflag_, imax_, imul_, imxer_, ipflag_, ipgo_, irem_, ires_, j_, kgo_, lenrat_, 
  lenyht_, leniw_, lenrw_, lia_, lic_, lja_, ljc_, lrtem_, lwtem_, lyd0_, lyhd_, lyhn_, mf1_, mord_[2], mxhnl0_, mxstp0_, 
  ncolm_;
  static logical_4 ihit_;
  static real_8 atoli_, ayi_, big_, ewti_, h0_, hmax_, hmx_, rh_, rtoli_, tcrit_, tdist_, tnext_, tol_, tolsf_, tp_, 
  size_, sum_, w0_;
  static char_63 msg_;
  int_4 _data_k_24, _data_k_25, _data_k_26, _data_k_27, $0_, $1_, $4_, $5_, $8_, $9_, $10_, $11_, $12_, $15_, $16_, $19_, 
  $20_, $23_, $24_, $26_, $27_, $28_, $29_, $30_, $33_, $34_, $35_, $36_, $37_, $40_, $41_, $42_, $43_, $44_, $47_, $48_, 
  $51_, $52_, $53_, $54_, $55_, $58_, $59_, $61_, $62_, $65_, $66_, $69_, $70_, $71_, $72_, $73_, $76_, $77_, $80_, $81_, 
  $84_, $85_, $88_, $89_, $92_, $93_, $96_, $97_, $100_, $101_, $104_, $107_, $108_, $111_, $112_, $115_, $116_, $119_, 
  $120_, $121_, $124_, $125_, $128_, $129_, $132_, $133_, $136_, $137_, $140_, $141_, $144_, $145_, $148_, $149_, $150_, 
  $151_, $152_, $154_, $155_, $157_, $158_, $160_, $161_, $164_, $165_, $166_, $169_, $170_, $173_, $174_, $175_, $178_, 
  $179_, $181_, $182_, $184_, $185_, $187_, $188_, $189_, $190_, $191_, $192_, $193_, $194_, $195_, $196_, $197_, $198_, 
  $199_, $200_, $203_, $204_, $206_, $207_, $209_, $210_, $213_, $214_, $215_, $218_, $219_, $222_, $223_, $224_, $227_, 
  $228_, $231_, $232_, $233_, $236_, $237_, $240_, $241_, $242_, $244_, $245_, $248_, $249_, $250_, $253_, $254_, $257_, 
  $258_, $259_, $261_, $262_, $265_, $266_, $269_, $270_, $273_, $274_, $276_, $277_, $278_;
  real_8 $2_, $3_, $6_, $7_, $13_, $14_, $17_, $18_, $21_, $22_, $25_, $31_, $32_, $38_, $39_, $45_, $46_, $49_, $50_, 
  $56_, $57_, $60_, $63_, $64_, $67_, $68_, $74_, $75_, $78_, $79_, $82_, $83_, $86_, $87_, $90_, $91_, $94_, $95_, $98_, 
  $99_, $102_, $103_, $105_, $106_, $109_, $110_, $113_, $114_, $117_, $118_, $122_, $123_, $126_, $127_, $130_, $131_, 
  $134_, $135_, $138_, $139_, $142_, $143_, $146_, $147_, $153_, $156_, $159_, $162_, $163_, $167_, $168_, $171_, $172_, 
  $176_, $177_, $180_, $183_, $186_, $201_, $202_, $205_, $208_, $211_, $212_, $216_, $217_, $220_, $221_, $225_, $226_, 
  $229_, $230_, $234_, $235_, $238_, $239_, $243_, $246_, $247_, $251_, $252_, $255_, $256_, $260_, $263_, $264_, $267_, 
  $268_, $271_, $272_, $275_, $279_, $280_;
#define _data_n_24 2
  static int_4 _data_l_24[_data_n_24] = {
    12,
    5
  };
#define _data_n_25 1
  static int_4 _data_l_25[_data_n_25] = {
    500
  };
#define _data_n_26 1
  static int_4 _data_l_26[_data_n_26] = {
    10
  };
#define _data_n_27 1
  static int_4 _data_l_27[_data_n_27] = {
    2
  };
  if (__calls[32].calls == 0) {
    _data_k_24 = 0;
    if (_data_k_24 >= _data_n_24) {
      _data_k_24 = 0;
    }
    mord_[0] = _data_l_24[_data_k_24++];
    if (_data_k_24 >= _data_n_24) {
      _data_k_24 = 0;
    }
    mord_[1] = _data_l_24[_data_k_24++];
    _data_k_25 = 0;
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    mxstp0_ = _data_l_25[_data_k_25++];
    _data_k_26 = 0;
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    mxhnl0_ = _data_l_26[_data_k_26++];
  }
  if (__calls[32].calls == 0) {
    _data_k_27 = 0;
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    lenrat_ = _data_l_27[_data_k_27++];
  }
  if ((*istate_) < 0 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  if ((*istate_) <= 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) <= 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  dlss01_.moss_ = (*mf_) / 100;
  mf1_ = (*mf_) - 100 * dlss01_.moss_;
  dls001_.meth_ = mf1_ / 10;
  dls001_.miter_ = mf1_ - 10 * dls001_.meth_;
  if (dlss01_.moss_ < 0 || dlss01_.moss_ > 4) {
    goto _l608;
  }
  if (dls001_.miter_ == 2 && dlss01_.moss_ == 1) {
    dlss01_.moss_ = dlss01_.moss_ + 1;
  }
  if (dls001_.miter_ == 2 && dlss01_.moss_ == 3) {
    dlss01_.moss_ = dlss01_.moss_ + 1;
  }
  if (dls001_.miter_ == 1 && dlss01_.moss_ == 2) {
    dlss01_.moss_ = dlss01_.moss_ - 1;
  }
  if (dls001_.miter_ == 1 && dlss01_.moss_ == 4) {
    dlss01_.moss_ = dlss01_.moss_ - 1;
  }
  if (dls001_.meth_ < 1 || dls001_.meth_ > 2) {
    goto _l608;
  }
  if (dls001_.miter_ < 1 || dls001_.miter_ > 2) {
    goto _l608;
  }
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dls001_.maxord_ = mord_[dls001_.meth_ - 1];
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  if ((*istate_) <= 1) {
    h0_ = 0.0;
  }
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  goto _l60;
  _l40:;
  dls001_.maxord_ = iwork_[4];
  if (dls001_.maxord_ < 0) {
    goto _l611;
  }
  if (dls001_.maxord_ == 0) {
    dls001_.maxord_ = 100;
  }
  dls001_.maxord_ = _min (dls001_.maxord_, mord_[dls001_.meth_ - 1]);
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) > 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  _l60:;
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  dlss01_.lrat_ = lenrat_;
  if ((*istate_) <= 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  if (dls001_.miter_ == 1) {
    dlss01_.lwmin_ = 4 * dls001_.n_ + 10 * dls001_.n_ / dlss01_.lrat_;
  }
  if (dls001_.miter_ == 2) {
    dlss01_.lwmin_ = 4 * dls001_.n_ + 11 * dls001_.n_ / dlss01_.lrat_;
  }
  dlss01_.lenyh_ = (dls001_.maxord_ + 1) * dls001_.nyh_;
  dlss01_.lrest_ = dlss01_.lenyh_ + 3 * dls001_.n_;
  lenrw_ = 20 + dlss01_.lwmin_ + dlss01_.lrest_;
  iwork_[16] = lenrw_;
  leniw_ = 30;
  if (dlss01_.moss_ != 1 && dlss01_.moss_ != 2) {
    leniw_ = leniw_ + dls001_.n_ + 1;
  }
  iwork_[17] = leniw_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  lia_ = 31;
  if (dlss01_.moss_ != 1 && dlss01_.moss_ != 2) {
    leniw_ = leniw_ + iwork_[lia_ + dls001_.n_ - 1] - 1;
  }
  iwork_[17] = leniw_;
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  lja_ = lia_ + dls001_.n_ + 1;
  lia_ = _min (lia_, (*liw_));
  lja_ = _min (lja_, (*liw_));
  lic_ = leniw_ + 1;
  if (dlss01_.moss_ == 0) {
    leniw_ = leniw_ + dls001_.n_ + 1;
  }
  iwork_[17] = leniw_;
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  if (dlss01_.moss_ == 0) {
    leniw_ = leniw_ + iwork_[lic_ + dls001_.n_ - 1] - 1;
  }
  iwork_[17] = leniw_;
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  ljc_ = lic_ + dls001_.n_ + 1;
  lic_ = _min (lic_, (*liw_));
  ljc_ = _min (ljc_, (*liw_));
  dls001_.lwm_ = 21;
  if ((*istate_) <= 1) {
    dls001_.nq_ = (*istate_);
  }
  ncolm_ = _min (dls001_.nq_ + 1, dls001_.maxord_ + 2);
  dlss01_.lenyhm_ = ncolm_ * dls001_.nyh_;
  lenyht_ = dlss01_.lenyhm_;
  imul_ = 2;
  if ((*istate_) == 3) {
    imul_ = dlss01_.moss_;
  }
  if ((*istate_) == 3 && dlss01_.moss_ == 3) {
    imul_ = 1;
  }
  if (dlss01_.moss_ == 2 || dlss01_.moss_ == 4) {
    imul_ = 3;
  }
  lrtem_ = lenyht_ + imul_ * dls001_.n_;
  lwtem_ = (*lrw_) - 20 - lrtem_;
  dlss01_.lenwk_ = lwtem_;
  lyhn_ = dls001_.lwm_ + lwtem_;
  dls001_.lsavf_ = lyhn_ + lenyht_;
  dls001_.lewt_ = dls001_.lsavf_ + dls001_.n_;
  dls001_.lacor_ = dls001_.lewt_ + dls001_.n_;
  dlss01_.istatc_ = (*istate_);
  if ((*istate_) <= 1) {
    goto _l100;
  }
  lyhd_ = dls001_.lyh_ - lyhn_;
  imax_ = lyhn_ - 1 + dlss01_.lenyhm_;
  if (lyhd_ < 0) {
    for (i_ = lyhn_; i_ <= imax_; (i_)++) {
      j_ = imax_ + lyhn_ - i_;
      rwork_[j_ - 1] = rwork_[j_ + lyhd_ - 1];
    }
  }
  if (lyhd_ > 0) {
    for (i_ = lyhn_; i_ <= imax_; (i_)++) {
      rwork_[i_ - 1] = rwork_[i_ + lyhd_ - 1];
    }
  }
  dls001_.lyh_ = lyhn_;
  iwork_[21] = dls001_.lyh_;
  if (dlss01_.moss_ != 2 && dlss01_.moss_ != 4) {
    goto _l85;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l85:;
  dls001_.lsavf_ = _min (dls001_.lsavf_, (*lrw_));
  dls001_.lewt_ = _min (dls001_.lewt_, (*lrw_));
  dls001_.lacor_ = _min (dls001_.lacor_, (*lrw_));
  (void) _diprepi (neq_, y_, ydoti_, rwork_, &iwork_[lia_ - 1], &iwork_[lja_ - 1], &iwork_[lic_ - 1], &iwork_[ljc_ - 1], 
  &ipflag_, _res, _jac, _adda);
  lenrw_ = dls001_.lwm_ - 1 + dlss01_.lenwk_ + dlss01_.lrest_;
  iwork_[16] = lenrw_;
  if (ipflag_ != -1) {
    iwork_[22] = dlss01_.ipian_;
  }
  if (ipflag_ != -1) {
    iwork_[23] = dlss01_.ipjan_;
  }
  ipgo_ = -ipflag_ + 1;
  switch (ipgo_) {
    default:
    case 1: goto _l90;
    case 2: goto _l628;
    case 3: goto _l629;
    case 4: goto _l630;
    case 5: goto _l631;
    case 6: goto _l632;
    case 7: goto _l633;
    case 8: goto _l634;
    case 9: goto _l634;
  }
  _l90:;
  iwork_[21] = dls001_.lyh_;
  lyd0_ = dls001_.lyh_ + dls001_.n_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  dls001_.jstart_ = -1;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l94;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    ydoti_[i_ - 1] = rwork_[i_ + dls001_.lsavf_ - 1 - 1];
  }
  _l94:;
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.lyh_ = lyhn_;
  iwork_[21] = dls001_.lyh_;
  dls001_.tn_ = (*t_);
  dls001_.nst_ = 0;
  dls001_.nfe_ = 0;
  dls001_.h_ = 1.0;
  dlss01_.nnz_ = 0;
  dlss01_.ngp_ = 0;
  dlss01_.nzl_ = 0;
  dlss01_.nzu_ = 0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  if ((*istate_) != 1) {
    goto _l108;
  }
  lyd0_ = dls001_.lyh_ + dls001_.nyh_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lyd0_ - 1 - 1] = ydoti_[i_ - 1];
  }
  _l108:;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  dls001_.lacor_ = _min (dls001_.lacor_, (*lrw_));
  (void) _diprepi (neq_, y_, ydoti_, rwork_, &iwork_[lia_ - 1], &iwork_[lja_ - 1], &iwork_[lic_ - 1], &iwork_[ljc_ - 1], 
  &ipflag_, _res, _jac, _adda);
  lenrw_ = dls001_.lwm_ - 1 + dlss01_.lenwk_ + dlss01_.lrest_;
  iwork_[16] = lenrw_;
  if (ipflag_ != -1) {
    iwork_[22] = dlss01_.ipian_;
  }
  if (ipflag_ != -1) {
    iwork_[23] = dlss01_.ipjan_;
  }
  ipgo_ = -ipflag_ + 1;
  switch (ipgo_) {
    default:
    case 1: goto _l115;
    case 2: goto _l628;
    case 3: goto _l629;
    case 4: goto _l630;
    case 5: goto _l631;
    case 6: goto _l632;
    case 7: goto _l633;
    case 8: goto _l634;
    case 9: goto _l634;
  }
  _l115:;
  iwork_[21] = dls001_.lyh_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  lyd0_ = dls001_.lyh_ + dls001_.n_;
  if ((*istate_) != 0) {
    goto _l120;
  }
  (void) _dainvgs (neq_, t_, y_, &rwork_[dls001_.lwm_ - 1], &rwork_[dls001_.lwm_ - 1], &rwork_[dls001_.lacor_ - 1], 
  &rwork_[lyd0_ - 1], &ier_, _res, _adda);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  igo_ = ier_ + 1;
  switch (igo_) {
    default:
    case 1: goto _l120;
    case 2: goto _l565;
    case 3: goto _l560;
    case 4: goto _l560;
  }
  _l120:;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l125;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l125:;
  dls001_.uround_ = _dumach ();
  dls001_.jstart_ = 0;
  rwork_[dls001_.lwm_ - 1] = sqrt (dls001_.uround_);
  dls001_.nhnil_ = 0;
  dls001_.nje_ = 0;
  dlss01_.nlu_ = 0;
  dls001_.nslast_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  tdist_ = _abs ((*tout_) - (*t_));
  w0_ = _max (_abs ((*t_)), _abs ((*tout_)));
  if (tdist_ < 2.0e0 * dls001_.uround_ * w0_) {
    goto _l622;
  }
  tol_ = rtol_[0];
  if ((*itol_) <= 2) {
    goto _l145;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    tol_ = _max (tol_, rtol_[i_ - 1]);
  }
  _l145:;
  if (tol_ > 0.0e0) {
    goto _l160;
  }
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    ayi_ = _abs (y_[i_ - 1]);
    if (ayi_ != 0.0e0) {
      tol_ = _max (tol_, atoli_ / ayi_);
    }
  }
  _l160:;
  tol_ = _max (tol_, 100.0e0 * dls001_.uround_);
  tol_ = _min (tol_, 1.0e-3);
  sum_ = _dvnorm (&dls001_.n_, &rwork_[lyd0_ - 1], &rwork_[dls001_.lewt_ - 1]);
  sum_ = 1.0e0 / (tol_ * w0_ * w0_) + tol_ * (sum_ * sum_);
  h0_ = 1.0e0 / sqrt (sum_);
  h0_ = _min (h0_, tdist_);
  h0_ = _sign (h0_, (*tout_) - (*t_));
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lyd0_ - 1 - 1] = h0_ * rwork_[i_ + lyd0_ - 1 - 1];
  }
  goto _l270;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dvnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_279, 63);
  (void) _xerrwd (msg_, ($0_ = 50, &$0_), ($1_ = 101, &$1_), &_k0, &_k0, &_k0, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
  &$3_));
  bufcpy (msg_, _dc_9, 63);
  (void) _xerrwd (msg_, ($4_ = 60, &$4_), ($5_ = 101, &$5_), &_k0, &_k0, &_k0, &_k0, &_k0, ($6_ = 0.0, &$6_), ($7_ = 0.0, 
  &$7_));
  bufcpy (msg_, _dc_10, 63);
  (void) _xerrwd (msg_, ($8_ = 50, &$8_), ($9_ = 101, &$9_), &_k0, &_k0, &_k0, &_k0, ($10_ = 2, &$10_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_280, 63);
  (void) _xerrwd (msg_, ($11_ = 50, &$11_), ($12_ = 102, &$12_), &_k0, &_k0, &_k0, &_k0, &_k0, ($13_ = 0.0, &$13_), ($14_ 
  = 0.0, &$14_));
  bufcpy (msg_, _dc_12, 63);
  (void) _xerrwd (msg_, ($15_ = 50, &$15_), ($16_ = 102, &$16_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($17_ = 0.0, 
  &$17_), ($18_ = 0.0, &$18_));
  _l290:;
  (void) _dstodi (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], ydoti_, &rwork_[dls001_.lsavf_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], &rwork_[dls001_.lwm_ - 
  1], _res, _adda, _jac, _dprjis, _dsolss);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
    case 4: goto _l400;
    case 5: goto _l550;
    case 6: goto _l555;
  }
  _l300:;
  dls001_.init_ = 1;
  switch ((*itask_)) {
    default:
    case 1: goto _l310;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l310:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  dls001_.jstart_ = -2;
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  if (dls001_.kflag_ == -3) {
    (*istate_) = 3;
  }
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlss01_.nnz_;
  iwork_[19] = dlss01_.ngp_;
  iwork_[20] = dlss01_.nlu_;
  iwork_[24] = dlss01_.nzl_;
  iwork_[25] = dlss01_.nzu_;
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_281, 63);
  (void) _xerrwd (msg_, ($19_ = 50, &$19_), ($20_ = 201, &$20_), &_k0, &_k0, &_k0, &_k0, &_k0, ($21_ = 0.0, &$21_), ($22_ 
  = 0.0, &$22_));
  bufcpy (msg_, _dc_17, 63);
  (void) _xerrwd (msg_, ($23_ = 50, &$23_), ($24_ = 201, &$24_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($25_ = 0.0, &$25_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_282, 63);
  (void) _xerrwd (msg_, ($26_ = 50, &$26_), ($27_ = 202, &$27_), &_k0, &_k1, &i_, &_k0, ($28_ = 2, &$28_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l590;
  _l520:;
  bufcpy (msg_, _dc_283, 63);
  (void) _xerrwd (msg_, ($29_ = 50, &$29_), ($30_ = 203, &$30_), &_k0, &_k0, &_k0, &_k0, &_k0, ($31_ = 0.0, &$31_), ($32_ 
  = 0.0, &$32_));
  bufcpy (msg_, _dc_20, 63);
  (void) _xerrwd (msg_, ($33_ = 50, &$33_), ($34_ = 203, &$34_), &_k0, &_k0, &_k0, &_k0, ($35_ = 2, &$35_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l590;
  _l530:;
  bufcpy (msg_, _dc_284, 63);
  (void) _xerrwd (msg_, ($36_ = 50, &$36_), ($37_ = 204, &$37_), &_k0, &_k0, &_k0, &_k0, &_k0, ($38_ = 0.0, &$38_), ($39_ 
  = 0.0, &$39_));
  bufcpy (msg_, _dc_285, 63);
  (void) _xerrwd (msg_, ($40_ = 60, &$40_), ($41_ = 204, &$41_), &_k0, &_k0, &_k0, &_k0, ($42_ = 2, &$42_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l570;
  _l540:;
  bufcpy (msg_, _dc_284, 63);
  (void) _xerrwd (msg_, ($43_ = 50, &$43_), ($44_ = 205, &$44_), &_k0, &_k0, &_k0, &_k0, &_k0, ($45_ = 0.0, &$45_), ($46_ 
  = 0.0, &$46_));
  bufcpy (msg_, _dc_24, 63);
  (void) _xerrwd (msg_, ($47_ = 50, &$47_), ($48_ = 205, &$48_), &_k0, &_k0, &_k0, &_k0, &_k0, ($49_ = 0.0, &$49_), ($50_ 
  = 0.0, &$50_));
  bufcpy (msg_, _dc_25, 63);
  (void) _xerrwd (msg_, ($51_ = 30, &$51_), ($52_ = 205, &$52_), &_k0, &_k0, &_k0, &_k0, ($53_ = 2, &$53_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  goto _l570;
  _l550:;
  bufcpy (msg_, _dc_286, 63);
  (void) _xerrwd (msg_, ($54_ = 50, &$54_), ($55_ = 206, &$55_), &_k0, &_k0, &_k0, &_k0, &_k0, ($56_ = 0.0, &$56_), ($57_ 
  = 0.0, &$57_));
  bufcpy (msg_, _dc_287, 63);
  (void) _xerrwd (msg_, ($58_ = 30, &$58_), ($59_ = 206, &$59_), &_k1, &_k0, &_k0, &_k0, &_k0, &dls001_.tn_, ($60_ = 0.0, 
  &$60_));
  (*istate_) = -7;
  goto _l590;
  _l555:;
  bufcpy (msg_, _dc_288, 63);
  (void) _xerrwd (msg_, ($61_ = 50, &$61_), ($62_ = 207, &$62_), &_k0, &_k0, &_k0, &_k0, &_k0, ($63_ = 0.0, &$63_), ($64_ 
  = 0.0, &$64_));
  bufcpy (msg_, _dc_154, 63);
  (void) _xerrwd (msg_, ($65_ = 50, &$65_), ($66_ = 207, &$66_), &_k0, &_k0, &_k0, &_k0, &_k0, ($67_ = 0.0, &$67_), ($68_ 
  = 0.0, &$68_));
  bufcpy (msg_, _dc_289, 63);
  (void) _xerrwd (msg_, ($69_ = 40, &$69_), ($70_ = 207, &$70_), &_k0, &_k0, &_k0, &_k0, ($71_ = 2, &$71_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -9;
  goto _l580;
  _l560:;
  bufcpy (msg_, _dc_290, 63);
  (void) _xerrwd (msg_, ($72_ = 60, &$72_), ($73_ = 208, &$73_), &_k0, &_k0, &_k0, &_k0, &_k0, ($74_ = 0.0, &$74_), ($75_ 
  = 0.0, &$75_));
  bufcpy (msg_, _dc_291, 63);
  (void) _xerrwd (msg_, ($76_ = 60, &$76_), ($77_ = 208, &$77_), &_k0, &_k0, &_k0, &_k0, &_k0, ($78_ = 0.0, &$78_), ($79_ 
  = 0.0, &$79_));
  bufcpy (msg_, _dc_292, 63);
  (void) _xerrwd (msg_, ($80_ = 40, &$80_), ($81_ = 208, &$81_), &_k0, &_k1, &ier_, &_k0, &_k0, ($82_ = 0.0, &$82_), 
  ($83_ = 0.0, &$83_));
  (*istate_) = -8;
  goto _l0;
  _l565:;
  bufcpy (msg_, _dc_293, 63);
  (void) _xerrwd (msg_, ($84_ = 50, &$84_), ($85_ = 209, &$85_), &_k0, &_k0, &_k0, &_k0, &_k0, ($86_ = 0.0, &$86_), ($87_ 
  = 0.0, &$87_));
  bufcpy (msg_, _dc_207, 63);
  (void) _xerrwd (msg_, ($88_ = 50, &$88_), ($89_ = 209, &$89_), &_k0, &_k0, &_k0, &_k0, &_k0, ($90_ = 0.0, &$90_), ($91_ 
  = 0.0, &$91_));
  bufcpy (msg_, _dc_208, 63);
  (void) _xerrwd (msg_, ($92_ = 20, &$92_), ($93_ = 209, &$93_), &_k0, &_k1, &ier_, &_k0, &_k0, ($94_ = 0.0, &$94_), 
  ($95_ = 0.0, &$95_));
  (*istate_) = -8;
  goto _l0;
  _l570:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l575;
    }
    big_ = size_;
    imxer_ = i_;
    _l575:;
  }
  iwork_[15] = imxer_;
  _l580:;
  lyd0_ = dls001_.lyh_ + dls001_.nyh_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lsavf_ - 1 - 1] = rwork_[i_ + lyd0_ - 1 - 1] / dls001_.h_;
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, &rwork_[dls001_.lsavf_ - 1], ydoti_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ <= 1) {
    goto _l595;
  }
  bufcpy (msg_, _dc_294, 63);
  (void) _xerrwd (msg_, ($96_ = 50, &$96_), ($97_ = 210, &$97_), &_k0, &_k0, &_k0, &_k0, &_k0, ($98_ = 0.0, &$98_), ($99_ 
  = 0.0, &$99_));
  bufcpy (msg_, _dc_210, 63);
  (void) _xerrwd (msg_, ($100_ = 50, &$100_), ($101_ = 210, &$101_), &_k0, &_k1, &ires_, &_k0, &_k0, ($102_ = 0.0, 
  &$102_), ($103_ = 0.0, &$103_));
  goto _l595;
  _l590:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  _l595:;
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlss01_.nnz_;
  iwork_[19] = dlss01_.ngp_;
  iwork_[20] = dlss01_.nlu_;
  iwork_[24] = dlss01_.nzl_;
  iwork_[25] = dlss01_.nzu_;
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_295, 63);
  (void) _xerrwd (msg_, ($104_ = 30, &$104_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($105_ = 0.0, &$105_), ($106_ = 0.0, 
  &$106_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_296, 63);
  (void) _xerrwd (msg_, ($107_ = 30, &$107_), ($108_ = 2, &$108_), &_k0, &_k1, itask_, &_k0, &_k0, ($109_ = 0.0, &$109_), 
  ($110_ = 0.0, &$110_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_297, 63);
  (void) _xerrwd (msg_, ($111_ = 50, &$111_), ($112_ = 3, &$112_), &_k0, &_k0, &_k0, &_k0, &_k0, ($113_ = 0.0, &$113_), 
  ($114_ = 0.0, &$114_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_298, 63);
  (void) _xerrwd (msg_, ($115_ = 30, &$115_), ($116_ = 4, &$116_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($117_ = 0.0, 
  &$117_), ($118_ = 0.0, &$118_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_299, 63);
  (void) _xerrwd (msg_, ($119_ = 50, &$119_), ($120_ = 5, &$120_), &_k0, ($121_ = 2, &$121_), &dls001_.n_, &neq_[0], 
  &_k0, ($122_ = 0.0, &$122_), ($123_ = 0.0, &$123_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_300, 63);
  (void) _xerrwd (msg_, ($124_ = 30, &$124_), ($125_ = 6, &$125_), &_k0, &_k1, itol_, &_k0, &_k0, ($126_ = 0.0, &$126_), 
  ($127_ = 0.0, &$127_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_301, 63);
  (void) _xerrwd (msg_, ($128_ = 30, &$128_), ($129_ = 7, &$129_), &_k0, &_k1, iopt_, &_k0, &_k0, ($130_ = 0.0, &$130_), 
  ($131_ = 0.0, &$131_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_302, 63);
  (void) _xerrwd (msg_, ($132_ = 30, &$132_), ($133_ = 8, &$133_), &_k0, &_k1, mf_, &_k0, &_k0, ($134_ = 0.0, &$134_), 
  ($135_ = 0.0, &$135_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_303, 63);
  (void) _xerrwd (msg_, ($136_ = 30, &$136_), ($137_ = 11, &$137_), &_k0, &_k1, &dls001_.maxord_, &_k0, &_k0, ($138_ = 
  0.0, &$138_), ($139_ = 0.0, &$139_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_304, 63);
  (void) _xerrwd (msg_, ($140_ = 30, &$140_), ($141_ = 12, &$141_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($142_ = 
  0.0, &$142_), ($143_ = 0.0, &$143_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_305, 63);
  (void) _xerrwd (msg_, ($144_ = 30, &$144_), ($145_ = 13, &$145_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($146_ = 
  0.0, &$146_), ($147_ = 0.0, &$147_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_306, 63);
  (void) _xerrwd (msg_, ($148_ = 40, &$148_), ($149_ = 14, &$149_), &_k0, &_k0, &_k0, &_k0, ($150_ = 2, &$150_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 63);
  (void) _xerrwd (msg_, ($151_ = 50, &$151_), ($152_ = 14, &$152_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($153_ = 0.0, 
  &$153_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_307, 63);
  (void) _xerrwd (msg_, ($154_ = 30, &$154_), ($155_ = 15, &$155_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($156_ = 0.0, 
  &$156_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_308, 63);
  (void) _xerrwd (msg_, ($157_ = 30, &$157_), ($158_ = 16, &$158_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($159_ 
  = 0.0, &$159_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_309, 63);
  (void) _xerrwd (msg_, ($160_ = 50, &$160_), ($161_ = 17, &$161_), &_k0, &_k0, &_k0, &_k0, &_k0, ($162_ = 0.0, &$162_), 
  ($163_ = 0.0, &$163_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($164_ = 60, &$164_), ($165_ = 17, &$165_), &_k0, ($166_ = 2, &$166_), &lenrw_, lrw_, &_k0, 
  ($167_ = 0.0, &$167_), ($168_ = 0.0, &$168_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_310, 63);
  (void) _xerrwd (msg_, ($169_ = 50, &$169_), ($170_ = 18, &$170_), &_k0, &_k0, &_k0, &_k0, &_k0, ($171_ = 0.0, &$171_), 
  ($172_ = 0.0, &$172_));
  bufcpy (msg_, _dc_174, 63);
  (void) _xerrwd (msg_, ($173_ = 60, &$173_), ($174_ = 18, &$174_), &_k0, ($175_ = 2, &$175_), &leniw_, liw_, &_k0, 
  ($176_ = 0.0, &$176_), ($177_ = 0.0, &$177_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_311, 63);
  (void) _xerrwd (msg_, ($178_ = 40, &$178_), ($179_ = 19, &$179_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($180_ = 0.0, 
  &$180_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_312, 63);
  (void) _xerrwd (msg_, ($181_ = 40, &$181_), ($182_ = 20, &$182_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($183_ = 0.0, 
  &$183_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_313, 63);
  (void) _xerrwd (msg_, ($184_ = 40, &$184_), ($185_ = 21, &$185_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($186_ = 0.0, 
  &$186_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_314, 63);
  (void) _xerrwd (msg_, ($187_ = 60, &$187_), ($188_ = 22, &$188_), &_k0, &_k0, &_k0, &_k0, ($189_ = 2, &$189_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_315, 63);
  (void) _xerrwd (msg_, ($190_ = 60, &$190_), ($191_ = 23, &$191_), &_k0, &_k1, itask_, &_k0, ($192_ = 2, &$192_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_316, 63);
  (void) _xerrwd (msg_, ($193_ = 60, &$193_), ($194_ = 24, &$194_), &_k0, &_k0, &_k0, &_k0, ($195_ = 2, &$195_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_317, 63);
  (void) _xerrwd (msg_, ($196_ = 60, &$196_), ($197_ = 25, &$197_), &_k0, &_k0, &_k0, &_k0, ($198_ = 2, &$198_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_318, 63);
  (void) _xerrwd (msg_, ($199_ = 50, &$199_), ($200_ = 26, &$200_), &_k0, &_k0, &_k0, &_k0, &_k0, ($201_ = 0.0, &$201_), 
  ($202_ = 0.0, &$202_));
  bufcpy (msg_, _dc_56, 63);
  (void) _xerrwd (msg_, ($203_ = 60, &$203_), ($204_ = 26, &$204_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($205_ = 0.0, 
  &$205_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_319, 63);
  (void) _xerrwd (msg_, ($206_ = 50, &$206_), ($207_ = 27, &$207_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($208_ = 0.0, 
  &$208_));
  goto _l700;
  _l628:;
  bufcpy (msg_, _dc_320, 63);
  (void) _xerrwd (msg_, ($209_ = 60, &$209_), ($210_ = 28, &$210_), &_k0, &_k0, &_k0, &_k0, &_k0, ($211_ = 0.0, &$211_), 
  ($212_ = 0.0, &$212_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($213_ = 60, &$213_), ($214_ = 28, &$214_), &_k0, ($215_ = 2, &$215_), &lenrw_, lrw_, &_k0, 
  ($216_ = 0.0, &$216_), ($217_ = 0.0, &$217_));
  goto _l700;
  _l629:;
  bufcpy (msg_, _dc_321, 63);
  (void) _xerrwd (msg_, ($218_ = 60, &$218_), ($219_ = 29, &$219_), &_k0, &_k0, &_k0, &_k0, &_k0, ($220_ = 0.0, &$220_), 
  ($221_ = 0.0, &$221_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($222_ = 60, &$222_), ($223_ = 29, &$223_), &_k0, ($224_ = 2, &$224_), &lenrw_, lrw_, &_k0, 
  ($225_ = 0.0, &$225_), ($226_ = 0.0, &$226_));
  goto _l700;
  _l630:;
  bufcpy (msg_, _dc_322, 63);
  (void) _xerrwd (msg_, ($227_ = 60, &$227_), ($228_ = 30, &$228_), &_k0, &_k0, &_k0, &_k0, &_k0, ($229_ = 0.0, &$229_), 
  ($230_ = 0.0, &$230_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($231_ = 60, &$231_), ($232_ = 30, &$232_), &_k0, ($233_ = 2, &$233_), &lenrw_, lrw_, &_k0, 
  ($234_ = 0.0, &$234_), ($235_ = 0.0, &$235_));
  goto _l700;
  _l631:;
  bufcpy (msg_, _dc_323, 63);
  (void) _xerrwd (msg_, ($236_ = 60, &$236_), ($237_ = 31, &$237_), &_k0, &_k0, &_k0, &_k0, &_k0, ($238_ = 0.0, &$238_), 
  ($239_ = 0.0, &$239_));
  imul_ = (dlss01_.iys_ - 1) / dls001_.n_;
  irem_ = dlss01_.iys_ - imul_ * dls001_.n_;
  bufcpy (msg_, _dc_188, 63);
  (void) _xerrwd (msg_, ($240_ = 60, &$240_), ($241_ = 31, &$241_), &_k0, ($242_ = 2, &$242_), &imul_, &irem_, &_k1, 
  &dls001_.tn_, ($243_ = 0.0, &$243_));
  goto _l700;
  _l632:;
  bufcpy (msg_, _dc_324, 63);
  (void) _xerrwd (msg_, ($244_ = 60, &$244_), ($245_ = 32, &$245_), &_k0, &_k0, &_k0, &_k0, &_k0, ($246_ = 0.0, &$246_), 
  ($247_ = 0.0, &$247_));
  bufcpy (msg_, _dc_172, 63);
  (void) _xerrwd (msg_, ($248_ = 60, &$248_), ($249_ = 32, &$249_), &_k0, ($250_ = 2, &$250_), &lenrw_, lrw_, &_k0, 
  ($251_ = 0.0, &$251_), ($252_ = 0.0, &$252_));
  goto _l700;
  _l633:;
  bufcpy (msg_, _dc_325, 63);
  (void) _xerrwd (msg_, ($253_ = 60, &$253_), ($254_ = 33, &$254_), &_k0, &_k0, &_k0, &_k0, &_k0, ($255_ = 0.0, &$255_), 
  ($256_ = 0.0, &$256_));
  imul_ = (dlss01_.iys_ - 1) / dls001_.n_;
  irem_ = dlss01_.iys_ - imul_ * dls001_.n_;
  bufcpy (msg_, _dc_191, 63);
  (void) _xerrwd (msg_, ($257_ = 60, &$257_), ($258_ = 33, &$258_), &_k0, ($259_ = 2, &$259_), &imul_, &irem_, &_k1, 
  &dls001_.tn_, ($260_ = 0.0, &$260_));
  if (imul_ == 2) {
    bufcpy (msg_, _dc_192, 63);
    (void) _xerrwd (msg_, ($261_ = 60, &$261_), ($262_ = 33, &$262_), &_k0, &_k0, &_k0, &_k0, &_k0, ($263_ = 0.0, &$263_), 
    ($264_ = 0.0, &$264_));
  }
  if (imul_ == 3 || imul_ == 6) {
    bufcpy (msg_, _dc_193, 63);
    (void) _xerrwd (msg_, ($265_ = 60, &$265_), ($266_ = 33, &$266_), &_k0, &_k0, &_k0, &_k0, &_k0, ($267_ = 0.0, &$267_), 
    ($268_ = 0.0, &$268_));
  }
  goto _l700;
  _l634:;
  bufcpy (msg_, _dc_326, 63);
  (void) _xerrwd (msg_, ($269_ = 60, &$269_), ($270_ = 34, &$270_), &_k0, &_k0, &_k0, &_k0, &_k0, ($271_ = 0.0, &$271_), 
  ($272_ = 0.0, &$272_));
  ier_ = -ipflag_ - 5;
  bufcpy (msg_, _dc_327, 63);
  (void) _xerrwd (msg_, ($273_ = 30, &$273_), ($274_ = 34, &$274_), &_k0, &_k1, &ier_, &_k0, &_k1, &dls001_.tn_, ($275_ = 
  0.0, &$275_));
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_328, 63);
  (void) _xerrwd (msg_, ($276_ = 50, &$276_), ($277_ = 303, &$277_), ($278_ = 2, &$278_), &_k0, &_k0, &_k0, &_k0, ($279_ 
  = 0.0, &$279_), ($280_ = 0.0, &$280_));
  _l0:;
  __calls[32].calls++;
  return 0;
}

int_4 _dlsodkr (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, 
int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), real_4 (*_psol)(), int_4 _p_ mf_, real_4 (*_g)(), int_4 _p_ ng_, 
int_4 _p_ jroot_)
{
  static int_4 i_, i1_, i2_, ier_, iflag_, imxer_, kgo_, lf0_, leniw_, leniwk_, lenrw_, lenwm_, lenwk_, liwp_, lwp_, 
  mord_[2], mxhnl0_, mxstp0_, ncfn0_, ncfl0_, niter_, nli0_, nni0_, nnid_, nstd_, nwarn_, irfp_, irt_, lenyh_, lyhnew_;
  static logical_4 ihit_, lavd_, lcfn_, lcfl_, lwarn_;
  static real_8 atoli_, avdim_, big_, ewti_, h0_, hmax_, hmx_, rcfl_, rcfn_, rh_, rtoli_, tcrit_, tnext_, tolsf_, tp_, 
  size_;
  static char_63 msg_;
  int_4 _data_k_28, _data_k_29, _data_k_30, $0_, $1_, $2_, $5_, $6_, $7_, $8_, $9_, $12_, $13_, $14_, $15_, $16_, $19_, 
  $20_, $21_, $22_, $23_, $26_, $27_, $30_, $31_, $32_, $33_, $34_, $37_, $38_, $41_, $42_, $43_, $46_, $47_, $49_, $50_, 
  $51_, $52_, $53_, $56_, $57_, $58_, $59_, $60_, $63_, $64_, $65_, $66_, $67_, $70_, $71_, $74_, $75_, $76_, $77_, $78_, 
  $81_, $82_, $84_, $87_, $88_, $91_, $92_, $95_, $96_, $99_, $100_, $101_, $104_, $105_, $108_, $109_, $112_, $113_, 
  $116_, $117_, $120_, $121_, $124_, $125_, $128_, $129_, $130_, $131_, $132_, $134_, $135_, $137_, $138_, $140_, $141_, 
  $142_, $145_, $146_, $147_, $150_, $151_, $153_, $154_, $156_, $157_, $159_, $160_, $161_, $162_, $163_, $164_, $165_, 
  $166_, $167_, $168_, $169_, $170_, $171_, $172_, $175_, $176_, $178_, $179_, $181_, $182_, $185_, $186_, $189_, $190_, 
  $191_, $194_, $195_, $198_, $199_, $202_, $203_, $204_;
  real_8 $3_, $4_, $10_, $11_, $17_, $18_, $24_, $25_, $28_, $29_, $35_, $36_, $39_, $40_, $44_, $45_, $48_, $54_, $55_, 
  $61_, $62_, $68_, $69_, $72_, $73_, $79_, $80_, $83_, $85_, $86_, $89_, $90_, $93_, $94_, $97_, $98_, $102_, $103_, 
  $106_, $107_, $110_, $111_, $114_, $115_, $118_, $119_, $122_, $123_, $126_, $127_, $133_, $136_, $139_, $143_, $144_, 
  $148_, $149_, $152_, $155_, $158_, $173_, $174_, $177_, $180_, $183_, $184_, $187_, $188_, $192_, $193_, $196_, $197_, 
  $200_, $201_, $205_, $206_;
#define _data_n_28 2
  static int_4 _data_l_28[_data_n_28] = {
    12,
    5
  };
#define _data_n_29 1
  static int_4 _data_l_29[_data_n_29] = {
    500
  };
#define _data_n_30 1
  static int_4 _data_l_30[_data_n_30] = {
    10
  };
  if (__calls[33].calls == 0) {
    _data_k_28 = 0;
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    mord_[0] = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    mord_[1] = _data_l_28[_data_k_28++];
    _data_k_29 = 0;
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    mxstp0_ = _data_l_29[_data_k_29++];
    _data_k_30 = 0;
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    mxhnl0_ = _data_l_30[_data_k_30++];
  }
  if ((*istate_) < 1 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  dlsr01_.itaskc_ = (*itask_);
  if ((*istate_) == 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) == 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  dls001_.meth_ = (*mf_) / 10;
  dls001_.miter_ = (*mf_) - 10 * dls001_.meth_;
  if (dls001_.meth_ < 1 || dls001_.meth_ > 2) {
    goto _l608;
  }
  if (dls001_.miter_ < 0) {
    goto _l608;
  }
  if (dls001_.miter_ > 4 && dls001_.miter_ < 9) {
    goto _l608;
  }
  if (dls001_.miter_ >= 1) {
    dlpk01_.jpre_ = iwork_[2];
  }
  dlpk01_.jacflg_ = 0;
  if (dls001_.miter_ >= 1) {
    dlpk01_.jacflg_ = iwork_[3];
  }
  if ((*ng_) < 0) {
    goto _l630;
  }
  if ((*istate_) == 1) {
    goto _l35;
  }
  if (dlsr01_.irfnd_ == 0 && (*ng_) != dlsr01_.ngc_) {
    goto _l631;
  }
  _l35:;
  dlsr01_.ngc_ = (*ng_);
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dls001_.maxord_ = mord_[dls001_.meth_ - 1];
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  if ((*istate_) == 1) {
    h0_ = 0.0;
  }
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  dlpk01_.maxl_ = _min (5, dls001_.n_);
  dlpk01_.kmp_ = dlpk01_.maxl_;
  dlpk01_.delt_ = 5.0e-2;
  goto _l60;
  _l40:;
  dls001_.maxord_ = iwork_[4];
  if (dls001_.maxord_ < 0) {
    goto _l611;
  }
  if (dls001_.maxord_ == 0) {
    dls001_.maxord_ = 100;
  }
  dls001_.maxord_ = _min (dls001_.maxord_, mord_[dls001_.meth_ - 1]);
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) != 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  dlpk01_.maxl_ = iwork_[7];
  if (dlpk01_.maxl_ == 0) {
    dlpk01_.maxl_ = 5;
  }
  dlpk01_.maxl_ = _min (dlpk01_.maxl_, dls001_.n_);
  dlpk01_.kmp_ = iwork_[8];
  if (dlpk01_.kmp_ == 0 || dlpk01_.kmp_ > dlpk01_.maxl_) {
    dlpk01_.kmp_ = dlpk01_.maxl_;
  }
  dlpk01_.delt_ = rwork_[7];
  if (dlpk01_.delt_ == 0.0e0) {
    dlpk01_.delt_ = 5.0e-2;
  }
  _l60:;
  if ((*istate_) == 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  dlsr01_.lg0_ = 21;
  dlsr01_.lg1_ = dlsr01_.lg0_ + (*ng_);
  dlsr01_.lgx_ = dlsr01_.lg1_ + (*ng_);
  lyhnew_ = dlsr01_.lgx_ + (*ng_);
  if ((*istate_) == 1) {
    dls001_.lyh_ = lyhnew_;
  }
  if (lyhnew_ == dls001_.lyh_) {
    goto _l62;
  }
  lenyh_ = dls001_.l_ * dls001_.nyh_;
  if ((*lrw_) < lyhnew_ - 1 + lenyh_) {
    goto _l62;
  }
  i1_ = 1;
  if (lyhnew_ > dls001_.lyh_) {
    i1_ = -1;
  }
  (void) _dcopy (&lenyh_, &rwork_[dls001_.lyh_ - 1], &i1_, &rwork_[lyhnew_ - 1], &i1_);
  dls001_.lyh_ = lyhnew_;
  _l62:;
  dls001_.lwm_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_;
  if (dls001_.miter_ == 0) {
    lenwk_ = 0;
  }
  if (dls001_.miter_ == 1) {
    lenwk_ = dls001_.n_ * (dlpk01_.maxl_ + 2) + dlpk01_.maxl_ * dlpk01_.maxl_;
  }
  if (dls001_.miter_ == 2) {
    lenwk_ = dls001_.n_ * (dlpk01_.maxl_ + 2 + _min (1, dlpk01_.maxl_ - dlpk01_.kmp_)) + (dlpk01_.maxl_ + 3) * 
    dlpk01_.maxl_ + 1;
  }
  if (dls001_.miter_ == 3 || dls001_.miter_ == 4) {
    lenwk_ = 5 * dls001_.n_;
  }
  if (dls001_.miter_ == 9) {
    lenwk_ = 2 * dls001_.n_;
  }
  lwp_ = 0;
  if (dls001_.miter_ >= 1) {
    lwp_ = iwork_[0];
  }
  lenwm_ = lenwk_ + lwp_;
  dlpk01_.locwp_ = lenwk_ + 1;
  dls001_.lewt_ = dls001_.lwm_ + lenwm_;
  dls001_.lsavf_ = dls001_.lewt_ + dls001_.n_;
  dlpk01_.lsavx_ = dls001_.lsavf_ + dls001_.n_;
  dls001_.lacor_ = dlpk01_.lsavx_ + dls001_.n_;
  if (dls001_.miter_ == 0) {
    dls001_.lacor_ = dls001_.lsavf_ + dls001_.n_;
  }
  lenrw_ = dls001_.lacor_ + dls001_.n_ - 1;
  iwork_[16] = lenrw_;
  dls001_.liwm_ = 31;
  leniwk_ = 0;
  if (dls001_.miter_ == 1) {
    leniwk_ = dlpk01_.maxl_;
  }
  liwp_ = 0;
  if (dls001_.miter_ >= 1) {
    liwp_ = iwork_[1];
  }
  leniw_ = 30 + leniwk_ + liwp_;
  dlpk01_.lociwp_ = leniwk_ + 1;
  iwork_[17] = leniw_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  dlpk01_.sqrtn_ = sqrtf ((real_4) (dls001_.n_));
  dlpk01_.rsqrtn_ = 1.0e0 / dlpk01_.sqrtn_;
  if ((*istate_) == 1) {
    goto _l100;
  }
  dls001_.jstart_ = -1;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l90;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lsavf_ - 1 - 1] = rwork_[i_ + dls001_.lwm_ - 1 - 1];
  }
  _l90:;
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.uround_ = _dumach ();
  dls001_.tn_ = (*t_);
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l110;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l110:;
  dls001_.jstart_ = 0;
  dls001_.nhnil_ = 0;
  dls001_.nst_ = 0;
  dls001_.nje_ = 0;
  dls001_.nslast_ = 0;
  nli0_ = 0;
  nni0_ = 0;
  ncfn0_ = 0;
  ncfl0_ = 0;
  nwarn_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  dlpk01_.nni_ = 0;
  dlpk01_.nli_ = 0;
  dlpk01_.nps_ = 0;
  dlpk01_.ncfn_ = 0;
  dlpk01_.ncfl_ = 0;
  dls002_.nsfi_ = 0;
  dls002_.njev_ = 0;
  lf0_ = dls001_.lyh_ + dls001_.nyh_;
  (void) _f (neq_, t_, y_, &rwork_[lf0_ - 1]);
  dls001_.nfe_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  dls001_.nq_ = 1;
  dls001_.h_ = 1.0;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  (void) _dlhin (neq_, &dls001_.n_, t_, &rwork_[dls001_.lyh_ - 1], &rwork_[lf0_ - 1], _f, tout_, &dls001_.uround_, 
  &rwork_[dls001_.lewt_ - 1], itol_, atol_, y_, &rwork_[dls001_.lacor_ - 1], &h0_, &niter_, &ier_);
  dls001_.nfe_ = dls001_.nfe_ + niter_;
  if (ier_ != 0) {
    goto _l622;
  }
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lf0_ - 1 - 1] = h0_ * rwork_[i_ + lf0_ - 1 - 1];
  }
  dlsr01_.irfnd_ = 0;
  dlsr01_.toutc_ = (*tout_);
  if (dlsr01_.ngc_ == 0) {
    goto _l270;
  }
  (void) _drchek (&_k1, _g, neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dlsr01_.lg0_ - 1], 
  &rwork_[dlsr01_.lg1_ - 1], &rwork_[dlsr01_.lgx_ - 1], jroot_, &irt_);
  if (irt_ == 0) {
    goto _l270;
  }
  goto _l632;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  irfp_ = dlsr01_.irfnd_;
  if (dlsr01_.ngc_ == 0) {
    goto _l205;
  }
  if ((*itask_) == 1 || (*itask_) == 4) {
    dlsr01_.toutc_ = (*tout_);
  }
  (void) _drchek (($0_ = 2, &$0_), _g, neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dlsr01_.lg0_ - 1], 
  &rwork_[dlsr01_.lg1_ - 1], &rwork_[dlsr01_.lgx_ - 1], jroot_, &irt_);
  if (irt_ != 1) {
    goto _l205;
  }
  dlsr01_.irfnd_ = 1;
  (*istate_) = 3;
  (*t_) = dlsr01_.t0_;
  goto _l425;
  _l205:;
  dlsr01_.irfnd_ = 0;
  if (irfp_ == 1 && dlsr01_.tlast_ != dls001_.tn_ && (*itask_) == 2) {
    goto _l400;
  }
  nli0_ = dlpk01_.nli_;
  nni0_ = dlpk01_.nni_;
  ncfn0_ = dlpk01_.ncfn_;
  ncfl0_ = dlpk01_.ncfl_;
  nwarn_ = 0;
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    (*t_) = tcrit_;
  }
  if (irfp_ == 1 && dlsr01_.tlast_ != dls001_.tn_ && (*itask_) == 5) {
    goto _l400;
  }
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  nstd_ = dls001_.nst_ - dls001_.nslast_;
  nnid_ = dlpk01_.nni_ - nni0_;
  if (nstd_ < 10 || nnid_ == 0) {
    goto _l255;
  }
  avdim_ = (real_4) (dlpk01_.nli_ - nli0_) / (real_4) (nnid_);
  rcfn_ = (real_4) (dlpk01_.ncfn_ - ncfn0_) / (real_4) (nstd_);
  rcfl_ = (real_4) (dlpk01_.ncfl_ - ncfl0_) / (real_4) (nnid_);
  lavd_ = avdim_ > (dlpk01_.maxl_ - 0.05e0);
  lcfn_ = rcfn_ > 0.9e0;
  lcfl_ = rcfl_ > 0.9e0;
  lwarn_ = lavd_ || lcfn_ || lcfl_;
  if (! (lwarn_)) {
    goto _l255;
  }
  nwarn_ = nwarn_ + 1;
  if (nwarn_ > 10) {
    goto _l255;
  }
  if (lavd_) {
    bufcpy (msg_, _dc_329, 63);
    (void) _xerrwd (msg_, ($1_ = 60, &$1_), ($2_ = 111, &$2_), &_k0, &_k0, &_k0, &_k0, &_k0, ($3_ = 0.0, &$3_), ($4_ = 0.0, 
    &$4_));
  }
  if (lavd_) {
    bufcpy (msg_, _dc_330, 63);
    (void) _xerrwd (msg_, ($5_ = 60, &$5_), ($6_ = 111, &$6_), &_k0, &_k0, &_k0, &_k0, ($7_ = 2, &$7_), &dls001_.tn_, 
    &avdim_);
  }
  if (lcfn_) {
    bufcpy (msg_, _dc_329, 63);
    (void) _xerrwd (msg_, ($8_ = 60, &$8_), ($9_ = 112, &$9_), &_k0, &_k0, &_k0, &_k0, &_k0, ($10_ = 0.0, &$10_), ($11_ = 
    0.0, &$11_));
  }
  if (lcfn_) {
    bufcpy (msg_, _dc_331, 63);
    (void) _xerrwd (msg_, ($12_ = 60, &$12_), ($13_ = 112, &$13_), &_k0, &_k0, &_k0, &_k0, ($14_ = 2, &$14_), &dls001_.tn_, 
    &rcfn_);
  }
  if (lcfl_) {
    bufcpy (msg_, _dc_329, 63);
    (void) _xerrwd (msg_, ($15_ = 60, &$15_), ($16_ = 113, &$16_), &_k0, &_k0, &_k0, &_k0, &_k0, ($17_ = 0.0, &$17_), ($18_ 
    = 0.0, &$18_));
  }
  if (lcfl_) {
    bufcpy (msg_, _dc_332, 63);
    (void) _xerrwd (msg_, ($19_ = 60, &$19_), ($20_ = 113, &$20_), &_k0, &_k0, &_k0, &_k0, ($21_ = 2, &$21_), &dls001_.tn_, 
    &rcfl_);
  }
  _l255:;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dvnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_333, 63);
  (void) _xerrwd (msg_, ($22_ = 50, &$22_), ($23_ = 101, &$23_), &_k0, &_k0, &_k0, &_k0, &_k0, ($24_ = 0.0, &$24_), ($25_ 
  = 0.0, &$25_));
  bufcpy (msg_, _dc_9, 63);
  (void) _xerrwd (msg_, ($26_ = 60, &$26_), ($27_ = 101, &$27_), &_k0, &_k0, &_k0, &_k0, &_k0, ($28_ = 0.0, &$28_), ($29_ 
  = 0.0, &$29_));
  bufcpy (msg_, _dc_10, 63);
  (void) _xerrwd (msg_, ($30_ = 50, &$30_), ($31_ = 101, &$31_), &_k0, &_k0, &_k0, &_k0, ($32_ = 2, &$32_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_334, 63);
  (void) _xerrwd (msg_, ($33_ = 50, &$33_), ($34_ = 102, &$34_), &_k0, &_k0, &_k0, &_k0, &_k0, ($35_ = 0.0, &$35_), ($36_ 
  = 0.0, &$36_));
  bufcpy (msg_, _dc_12, 63);
  (void) _xerrwd (msg_, ($37_ = 50, &$37_), ($38_ = 102, &$38_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($39_ = 0.0, 
  &$39_), ($40_ = 0.0, &$40_));
  _l290:;
  (void) _dstoka (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], &rwork_[dls001_.lsavf_ - 1], &rwork_[dlpk01_.lsavx_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], 
  &iwork_[dls001_.liwm_ - 1], _f, _jac, _psol);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
    case 4: goto _l550;
  }
  _l300:;
  dls001_.init_ = 1;
  if (dlsr01_.ngc_ == 0) {
    goto _l315;
  }
  (void) _drchek (($41_ = 3, &$41_), _g, neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dlsr01_.lg0_ - 1], 
  &rwork_[dlsr01_.lg1_ - 1], &rwork_[dlsr01_.lgx_ - 1], jroot_, &irt_);
  if (irt_ != 1) {
    goto _l315;
  }
  dlsr01_.irfnd_ = 1;
  (*istate_) = 3;
  (*t_) = dlsr01_.t0_;
  goto _l425;
  _l315:;
  switch ((*itask_)) {
    default:
    case 1: goto _l310;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l310:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  dls001_.jstart_ = -2;
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  _l425:;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlpk01_.nni_;
  iwork_[19] = dlpk01_.nli_;
  iwork_[20] = dlpk01_.nps_;
  iwork_[21] = dlpk01_.ncfn_;
  iwork_[22] = dlpk01_.ncfl_;
  iwork_[23] = dls002_.nsfi_;
  iwork_[24] = dls002_.njev_;
  iwork_[9] = dlsr01_.nge_;
  dlsr01_.tlast_ = (*t_);
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_335, 63);
  (void) _xerrwd (msg_, ($42_ = 50, &$42_), ($43_ = 201, &$43_), &_k0, &_k0, &_k0, &_k0, &_k0, ($44_ = 0.0, &$44_), ($45_ 
  = 0.0, &$45_));
  bufcpy (msg_, _dc_17, 63);
  (void) _xerrwd (msg_, ($46_ = 50, &$46_), ($47_ = 201, &$47_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($48_ = 0.0, &$48_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_336, 63);
  (void) _xerrwd (msg_, ($49_ = 50, &$49_), ($50_ = 202, &$50_), &_k0, &_k1, &i_, &_k0, ($51_ = 2, &$51_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l580;
  _l520:;
  bufcpy (msg_, _dc_337, 63);
  (void) _xerrwd (msg_, ($52_ = 50, &$52_), ($53_ = 203, &$53_), &_k0, &_k0, &_k0, &_k0, &_k0, ($54_ = 0.0, &$54_), ($55_ 
  = 0.0, &$55_));
  bufcpy (msg_, _dc_20, 63);
  (void) _xerrwd (msg_, ($56_ = 50, &$56_), ($57_ = 203, &$57_), &_k0, &_k0, &_k0, &_k0, ($58_ = 2, &$58_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l580;
  _l530:;
  bufcpy (msg_, _dc_338, 63);
  (void) _xerrwd (msg_, ($59_ = 50, &$59_), ($60_ = 204, &$60_), &_k0, &_k0, &_k0, &_k0, &_k0, ($61_ = 0.0, &$61_), ($62_ 
  = 0.0, &$62_));
  bufcpy (msg_, _dc_22, 63);
  (void) _xerrwd (msg_, ($63_ = 50, &$63_), ($64_ = 204, &$64_), &_k0, &_k0, &_k0, &_k0, ($65_ = 2, &$65_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l560;
  _l540:;
  bufcpy (msg_, _dc_339, 63);
  (void) _xerrwd (msg_, ($66_ = 50, &$66_), ($67_ = 205, &$67_), &_k0, &_k0, &_k0, &_k0, &_k0, ($68_ = 0.0, &$68_), ($69_ 
  = 0.0, &$69_));
  bufcpy (msg_, _dc_24, 63);
  (void) _xerrwd (msg_, ($70_ = 50, &$70_), ($71_ = 205, &$71_), &_k0, &_k0, &_k0, &_k0, &_k0, ($72_ = 0.0, &$72_), ($73_ 
  = 0.0, &$73_));
  bufcpy (msg_, _dc_25, 63);
  (void) _xerrwd (msg_, ($74_ = 30, &$74_), ($75_ = 205, &$75_), &_k0, &_k0, &_k0, &_k0, ($76_ = 2, &$76_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  goto _l580;
  _l550:;
  bufcpy (msg_, _dc_340, 63);
  (void) _xerrwd (msg_, ($77_ = 50, &$77_), ($78_ = 206, &$78_), &_k0, &_k0, &_k0, &_k0, &_k0, ($79_ = 0.0, &$79_), ($80_ 
  = 0.0, &$80_));
  bufcpy (msg_, _dc_341, 63);
  (void) _xerrwd (msg_, ($81_ = 40, &$81_), ($82_ = 206, &$82_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.tn_, ($83_ = 0.0, 
  &$83_));
  (*istate_) = -7;
  goto _l580;
  _l560:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l570;
    }
    big_ = size_;
    imxer_ = i_;
    _l570:;
  }
  iwork_[15] = imxer_;
  _l580:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlpk01_.nni_;
  iwork_[19] = dlpk01_.nli_;
  iwork_[20] = dlpk01_.nps_;
  iwork_[21] = dlpk01_.ncfn_;
  iwork_[22] = dlpk01_.ncfl_;
  iwork_[23] = dls002_.nsfi_;
  iwork_[24] = dls002_.njev_;
  iwork_[9] = dlsr01_.nge_;
  dlsr01_.tlast_ = (*t_);
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_342, 63);
  (void) _xerrwd (msg_, ($84_ = 30, &$84_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($85_ = 0.0, &$85_), ($86_ = 0.0, 
  &$86_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_343, 63);
  (void) _xerrwd (msg_, ($87_ = 30, &$87_), ($88_ = 2, &$88_), &_k0, &_k1, itask_, &_k0, &_k0, ($89_ = 0.0, &$89_), ($90_ 
  = 0.0, &$90_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_344, 63);
  (void) _xerrwd (msg_, ($91_ = 50, &$91_), ($92_ = 3, &$92_), &_k0, &_k0, &_k0, &_k0, &_k0, ($93_ = 0.0, &$93_), ($94_ = 
  0.0, &$94_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_345, 63);
  (void) _xerrwd (msg_, ($95_ = 30, &$95_), ($96_ = 4, &$96_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($97_ = 0.0, &$97_), 
  ($98_ = 0.0, &$98_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_346, 63);
  (void) _xerrwd (msg_, ($99_ = 50, &$99_), ($100_ = 5, &$100_), &_k0, ($101_ = 2, &$101_), &dls001_.n_, &neq_[0], &_k0, 
  ($102_ = 0.0, &$102_), ($103_ = 0.0, &$103_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_347, 63);
  (void) _xerrwd (msg_, ($104_ = 30, &$104_), ($105_ = 6, &$105_), &_k0, &_k1, itol_, &_k0, &_k0, ($106_ = 0.0, &$106_), 
  ($107_ = 0.0, &$107_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_348, 63);
  (void) _xerrwd (msg_, ($108_ = 30, &$108_), ($109_ = 7, &$109_), &_k0, &_k1, iopt_, &_k0, &_k0, ($110_ = 0.0, &$110_), 
  ($111_ = 0.0, &$111_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_349, 63);
  (void) _xerrwd (msg_, ($112_ = 30, &$112_), ($113_ = 8, &$113_), &_k0, &_k1, mf_, &_k0, &_k0, ($114_ = 0.0, &$114_), 
  ($115_ = 0.0, &$115_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_350, 63);
  (void) _xerrwd (msg_, ($116_ = 30, &$116_), ($117_ = 11, &$117_), &_k0, &_k1, &dls001_.maxord_, &_k0, &_k0, ($118_ = 
  0.0, &$118_), ($119_ = 0.0, &$119_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_351, 63);
  (void) _xerrwd (msg_, ($120_ = 30, &$120_), ($121_ = 12, &$121_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($122_ = 
  0.0, &$122_), ($123_ = 0.0, &$123_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_352, 63);
  (void) _xerrwd (msg_, ($124_ = 30, &$124_), ($125_ = 13, &$125_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($126_ = 
  0.0, &$126_), ($127_ = 0.0, &$127_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_353, 63);
  (void) _xerrwd (msg_, ($128_ = 40, &$128_), ($129_ = 14, &$129_), &_k0, &_k0, &_k0, &_k0, ($130_ = 2, &$130_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 63);
  (void) _xerrwd (msg_, ($131_ = 50, &$131_), ($132_ = 14, &$132_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($133_ = 0.0, 
  &$133_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_354, 63);
  (void) _xerrwd (msg_, ($134_ = 30, &$134_), ($135_ = 15, &$135_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($136_ = 0.0, 
  &$136_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_355, 63);
  (void) _xerrwd (msg_, ($137_ = 30, &$137_), ($138_ = 16, &$138_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($139_ 
  = 0.0, &$139_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_356, 63);
  (void) _xerrwd (msg_, ($140_ = 60, &$140_), ($141_ = 17, &$141_), &_k0, ($142_ = 2, &$142_), &lenrw_, lrw_, &_k0, 
  ($143_ = 0.0, &$143_), ($144_ = 0.0, &$144_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_357, 63);
  (void) _xerrwd (msg_, ($145_ = 60, &$145_), ($146_ = 18, &$146_), &_k0, ($147_ = 2, &$147_), &leniw_, liw_, &_k0, 
  ($148_ = 0.0, &$148_), ($149_ = 0.0, &$149_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_358, 63);
  (void) _xerrwd (msg_, ($150_ = 40, &$150_), ($151_ = 19, &$151_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($152_ = 0.0, 
  &$152_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_359, 63);
  (void) _xerrwd (msg_, ($153_ = 40, &$153_), ($154_ = 20, &$154_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($155_ = 0.0, 
  &$155_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_360, 63);
  (void) _xerrwd (msg_, ($156_ = 40, &$156_), ($157_ = 21, &$157_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($158_ = 0.0, 
  &$158_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_361, 63);
  (void) _xerrwd (msg_, ($159_ = 60, &$159_), ($160_ = 22, &$160_), &_k0, &_k0, &_k0, &_k0, ($161_ = 2, &$161_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_362, 63);
  (void) _xerrwd (msg_, ($162_ = 60, &$162_), ($163_ = 23, &$163_), &_k0, &_k1, itask_, &_k0, ($164_ = 2, &$164_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_363, 63);
  (void) _xerrwd (msg_, ($165_ = 60, &$165_), ($166_ = 24, &$166_), &_k0, &_k0, &_k0, &_k0, ($167_ = 2, &$167_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_364, 63);
  (void) _xerrwd (msg_, ($168_ = 60, &$168_), ($169_ = 25, &$169_), &_k0, &_k0, &_k0, &_k0, ($170_ = 2, &$170_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_365, 63);
  (void) _xerrwd (msg_, ($171_ = 50, &$171_), ($172_ = 26, &$172_), &_k0, &_k0, &_k0, &_k0, &_k0, ($173_ = 0.0, &$173_), 
  ($174_ = 0.0, &$174_));
  bufcpy (msg_, _dc_56, 63);
  (void) _xerrwd (msg_, ($175_ = 60, &$175_), ($176_ = 26, &$176_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($177_ = 0.0, 
  &$177_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_366, 63);
  (void) _xerrwd (msg_, ($178_ = 50, &$178_), ($179_ = 27, &$179_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($180_ = 0.0, 
  &$180_));
  goto _l700;
  _l630:;
  bufcpy (msg_, _dc_367, 63);
  (void) _xerrwd (msg_, ($181_ = 30, &$181_), ($182_ = 30, &$182_), &_k0, &_k1, ng_, &_k0, &_k0, ($183_ = 0.0, &$183_), 
  ($184_ = 0.0, &$184_));
  goto _l700;
  _l631:;
  bufcpy (msg_, _dc_368, 63);
  (void) _xerrwd (msg_, ($185_ = 50, &$185_), ($186_ = 31, &$186_), &_k0, &_k0, &_k0, &_k0, &_k0, ($187_ = 0.0, &$187_), 
  ($188_ = 0.0, &$188_));
  bufcpy (msg_, _dc_105, 63);
  (void) _xerrwd (msg_, ($189_ = 50, &$189_), ($190_ = 31, &$190_), &_k0, ($191_ = 2, &$191_), &dlsr01_.ngc_, ng_, &_k0, 
  ($192_ = 0.0, &$192_), ($193_ = 0.0, &$193_));
  goto _l700;
  _l632:;
  bufcpy (msg_, _dc_369, 63);
  (void) _xerrwd (msg_, ($194_ = 50, &$194_), ($195_ = 32, &$195_), &_k0, &_k0, &_k0, &_k0, &_k0, ($196_ = 0.0, &$196_), 
  ($197_ = 0.0, &$197_));
  bufcpy (msg_, _dc_107, 63);
  (void) _xerrwd (msg_, ($198_ = 40, &$198_), ($199_ = 32, &$199_), &_k0, &_k0, &_k0, &_k0, &_k0, ($200_ = 0.0, &$200_), 
  ($201_ = 0.0, &$201_));
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_370, 63);
  (void) _xerrwd (msg_, ($202_ = 50, &$202_), ($203_ = 303, &$203_), ($204_ = 2, &$204_), &_k0, &_k0, &_k0, &_k0, ($205_ 
  = 0.0, &$205_), ($206_ = 0.0, &$206_));
  _l0:;
  __calls[33].calls++;
  return 0;
}

int_4 _dlsodpk (int_4 (*_f)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ t_, real_8 _p_ tout_, int_4 _p_ itol_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ itask_, int_4 _p_ istate_, int_4 _p_ iopt_, real_8 _p_ rwork_, int_4 _p_ lrw_, 
int_4 _p_ iwork_, int_4 _p_ liw_, int_4 (*_jac)(), real_4 (*_psol)(), int_4 _p_ mf_)
{
  static int_4 i_, i1_, i2_, iflag_, imxer_, kgo_, lf0_, leniw_, leniwk_, lenrw_, lenwm_, lenwk_, liwp_, lwp_, mord_[2], 
  mxhnl0_, mxstp0_, ncfn0_, ncfl0_, nli0_, nni0_, nnid_, nstd_, nwarn_;
  static logical_4 ihit_, lavd_, lcfn_, lcfl_, lwarn_;
  static real_8 atoli_, avdim_, ayi_, big_, ewti_, h0_, hmax_, hmx_, rcfl_, rcfn_, rh_, rtoli_, tcrit_, tdist_, tnext_, 
  tol_, tolsf_, tp_, size_, sum_, w0_;
  static char_63 msg_;
  int_4 _data_k_31, _data_k_32, _data_k_33, $0_, $1_, $4_, $5_, $6_, $7_, $8_, $11_, $12_, $13_, $14_, $15_, $18_, $19_, 
  $20_, $21_, $22_, $25_, $26_, $29_, $30_, $31_, $32_, $33_, $36_, $37_, $40_, $41_, $44_, $45_, $47_, $48_, $49_, $50_, 
  $51_, $54_, $55_, $56_, $57_, $58_, $61_, $62_, $63_, $64_, $65_, $68_, $69_, $72_, $73_, $74_, $75_, $76_, $79_, $80_, 
  $82_, $85_, $86_, $89_, $90_, $93_, $94_, $97_, $98_, $99_, $102_, $103_, $106_, $107_, $110_, $111_, $114_, $115_, 
  $118_, $119_, $122_, $123_, $126_, $127_, $128_, $129_, $130_, $132_, $133_, $135_, $136_, $138_, $139_, $140_, $143_, 
  $144_, $145_, $148_, $149_, $151_, $152_, $154_, $155_, $157_, $158_, $159_, $160_, $161_, $162_, $163_, $164_, $165_, 
  $166_, $167_, $168_, $169_, $170_, $173_, $174_, $176_, $177_, $179_, $180_, $181_;
  real_8 $2_, $3_, $9_, $10_, $16_, $17_, $23_, $24_, $27_, $28_, $34_, $35_, $38_, $39_, $42_, $43_, $46_, $52_, $53_, 
  $59_, $60_, $66_, $67_, $70_, $71_, $77_, $78_, $81_, $83_, $84_, $87_, $88_, $91_, $92_, $95_, $96_, $100_, $101_, 
  $104_, $105_, $108_, $109_, $112_, $113_, $116_, $117_, $120_, $121_, $124_, $125_, $131_, $134_, $137_, $141_, $142_, 
  $146_, $147_, $150_, $153_, $156_, $171_, $172_, $175_, $178_, $182_, $183_;
#define _data_n_31 2
  static int_4 _data_l_31[_data_n_31] = {
    12,
    5
  };
#define _data_n_32 1
  static int_4 _data_l_32[_data_n_32] = {
    500
  };
#define _data_n_33 1
  static int_4 _data_l_33[_data_n_33] = {
    10
  };
  if (__calls[34].calls == 0) {
    _data_k_31 = 0;
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    mord_[0] = _data_l_31[_data_k_31++];
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    mord_[1] = _data_l_31[_data_k_31++];
    _data_k_32 = 0;
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    mxstp0_ = _data_l_32[_data_k_32++];
    _data_k_33 = 0;
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    mxhnl0_ = _data_l_33[_data_k_33++];
  }
  if ((*istate_) < 1 || (*istate_) > 3) {
    goto _l601;
  }
  if ((*itask_) < 1 || (*itask_) > 5) {
    goto _l602;
  }
  if ((*istate_) == 1) {
    goto _l10;
  }
  if (dls001_.init_ == 0) {
    goto _l603;
  }
  if ((*istate_) == 2) {
    goto _l200;
  }
  goto _l20;
  _l10:;
  dls001_.init_ = 0;
  if ((*tout_) == (*t_)) {
    goto _l0;
  }
  _l20:;
  if (neq_[0] <= 0) {
    goto _l604;
  }
  if ((*istate_) == 1) {
    goto _l25;
  }
  if (neq_[0] > dls001_.n_) {
    goto _l605;
  }
  _l25:;
  dls001_.n_ = neq_[0];
  if ((*itol_) < 1 || (*itol_) > 4) {
    goto _l606;
  }
  if ((*iopt_) < 0 || (*iopt_) > 1) {
    goto _l607;
  }
  dls001_.meth_ = (*mf_) / 10;
  dls001_.miter_ = (*mf_) - 10 * dls001_.meth_;
  if (dls001_.meth_ < 1 || dls001_.meth_ > 2) {
    goto _l608;
  }
  if (dls001_.miter_ < 0) {
    goto _l608;
  }
  if (dls001_.miter_ > 4 && dls001_.miter_ < 9) {
    goto _l608;
  }
  if (dls001_.miter_ >= 1) {
    dlpk01_.jpre_ = iwork_[2];
  }
  dlpk01_.jacflg_ = 0;
  if (dls001_.miter_ >= 1) {
    dlpk01_.jacflg_ = iwork_[3];
  }
  if ((*iopt_) == 1) {
    goto _l40;
  }
  dls001_.maxord_ = mord_[dls001_.meth_ - 1];
  dls001_.mxstep_ = mxstp0_;
  dls001_.mxhnil_ = mxhnl0_;
  if ((*istate_) == 1) {
    h0_ = 0.0;
  }
  dls001_.hmxi_ = 0.0;
  dls001_.hmin_ = 0.0;
  dlpk01_.maxl_ = _min (5, dls001_.n_);
  dlpk01_.kmp_ = dlpk01_.maxl_;
  dlpk01_.delt_ = 5.0e-2;
  goto _l60;
  _l40:;
  dls001_.maxord_ = iwork_[4];
  if (dls001_.maxord_ < 0) {
    goto _l611;
  }
  if (dls001_.maxord_ == 0) {
    dls001_.maxord_ = 100;
  }
  dls001_.maxord_ = _min (dls001_.maxord_, mord_[dls001_.meth_ - 1]);
  dls001_.mxstep_ = iwork_[5];
  if (dls001_.mxstep_ < 0) {
    goto _l612;
  }
  if (dls001_.mxstep_ == 0) {
    dls001_.mxstep_ = mxstp0_;
  }
  dls001_.mxhnil_ = iwork_[6];
  if (dls001_.mxhnil_ < 0) {
    goto _l613;
  }
  if (dls001_.mxhnil_ == 0) {
    dls001_.mxhnil_ = mxhnl0_;
  }
  if ((*istate_) != 1) {
    goto _l50;
  }
  h0_ = rwork_[4];
  if (((*tout_) - (*t_)) * h0_ < 0.0e0) {
    goto _l614;
  }
  _l50:;
  hmax_ = rwork_[5];
  if (hmax_ < 0.0e0) {
    goto _l615;
  }
  dls001_.hmxi_ = 0.0;
  if (hmax_ > 0.0e0) {
    dls001_.hmxi_ = 1.0e0 / hmax_;
  }
  dls001_.hmin_ = rwork_[6];
  if (dls001_.hmin_ < 0.0e0) {
    goto _l616;
  }
  dlpk01_.maxl_ = iwork_[7];
  if (dlpk01_.maxl_ == 0) {
    dlpk01_.maxl_ = 5;
  }
  dlpk01_.maxl_ = _min (dlpk01_.maxl_, dls001_.n_);
  dlpk01_.kmp_ = iwork_[8];
  if (dlpk01_.kmp_ == 0 || dlpk01_.kmp_ > dlpk01_.maxl_) {
    dlpk01_.kmp_ = dlpk01_.maxl_;
  }
  dlpk01_.delt_ = rwork_[7];
  if (dlpk01_.delt_ == 0.0e0) {
    dlpk01_.delt_ = 5.0e-2;
  }
  _l60:;
  dls001_.lyh_ = 21;
  if ((*istate_) == 1) {
    dls001_.nyh_ = dls001_.n_;
  }
  dls001_.lwm_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_;
  if (dls001_.miter_ == 0) {
    lenwk_ = 0;
  }
  if (dls001_.miter_ == 1) {
    lenwk_ = dls001_.n_ * (dlpk01_.maxl_ + 2) + dlpk01_.maxl_ * dlpk01_.maxl_;
  }
  if (dls001_.miter_ == 2) {
    lenwk_ = dls001_.n_ * (dlpk01_.maxl_ + 2 + _min (1, dlpk01_.maxl_ - dlpk01_.kmp_)) + (dlpk01_.maxl_ + 3) * 
    dlpk01_.maxl_ + 1;
  }
  if (dls001_.miter_ == 3 || dls001_.miter_ == 4) {
    lenwk_ = 5 * dls001_.n_;
  }
  if (dls001_.miter_ == 9) {
    lenwk_ = 2 * dls001_.n_;
  }
  lwp_ = 0;
  if (dls001_.miter_ >= 1) {
    lwp_ = iwork_[0];
  }
  lenwm_ = lenwk_ + lwp_;
  dlpk01_.locwp_ = lenwk_ + 1;
  dls001_.lewt_ = dls001_.lwm_ + lenwm_;
  dls001_.lsavf_ = dls001_.lewt_ + dls001_.n_;
  dlpk01_.lsavx_ = dls001_.lsavf_ + dls001_.n_;
  dls001_.lacor_ = dlpk01_.lsavx_ + dls001_.n_;
  if (dls001_.miter_ == 0) {
    dls001_.lacor_ = dls001_.lsavf_ + dls001_.n_;
  }
  lenrw_ = dls001_.lacor_ + dls001_.n_ - 1;
  iwork_[16] = lenrw_;
  dls001_.liwm_ = 31;
  leniwk_ = 0;
  if (dls001_.miter_ == 1) {
    leniwk_ = dlpk01_.maxl_;
  }
  liwp_ = 0;
  if (dls001_.miter_ >= 1) {
    liwp_ = iwork_[1];
  }
  leniw_ = 30 + leniwk_ + liwp_;
  dlpk01_.lociwp_ = leniwk_ + 1;
  iwork_[17] = leniw_;
  if (lenrw_ > (*lrw_)) {
    goto _l617;
  }
  if (leniw_ > (*liw_)) {
    goto _l618;
  }
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) >= 3) {
      rtoli_ = rtol_[i_ - 1];
    }
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ < 0.0e0) {
      goto _l619;
    }
    if (atoli_ < 0.0e0) {
      goto _l620;
    }
  }
  dlpk01_.sqrtn_ = sqrtf ((real_4) (dls001_.n_));
  dlpk01_.rsqrtn_ = 1.0e0 / dlpk01_.sqrtn_;
  if ((*istate_) == 1) {
    goto _l100;
  }
  dls001_.jstart_ = -1;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l90;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lsavf_ - 1 - 1] = rwork_[i_ + dls001_.lwm_ - 1 - 1];
  }
  _l90:;
  if (dls001_.n_ == dls001_.nyh_) {
    goto _l200;
  }
  i1_ = dls001_.lyh_ + dls001_.l_ * dls001_.nyh_;
  i2_ = dls001_.lyh_ + (dls001_.maxord_ + 1) * dls001_.nyh_ - 1;
  if (i1_ > i2_) {
    goto _l200;
  }
  for (i_ = i1_; i_ <= i2_; (i_)++) {
    rwork_[i_ - 1] = 0.0;
  }
  goto _l200;
  _l100:;
  dls001_.uround_ = _dumach ();
  dls001_.tn_ = (*t_);
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l110;
  }
  tcrit_ = rwork_[0];
  if ((tcrit_ - (*tout_)) * ((*tout_) - (*t_)) < 0.0e0) {
    goto _l625;
  }
  if (h0_ != 0.0e0 && ((*t_) + h0_ - tcrit_) * h0_ > 0.0e0) {
    h0_ = tcrit_ - (*t_);
  }
  _l110:;
  dls001_.jstart_ = 0;
  dls001_.nhnil_ = 0;
  dls001_.nst_ = 0;
  dls001_.nje_ = 0;
  dls001_.nslast_ = 0;
  nli0_ = 0;
  nni0_ = 0;
  ncfn0_ = 0;
  ncfl0_ = 0;
  nwarn_ = 0;
  dls001_.hu_ = 0.0;
  dls001_.nqu_ = 0;
  dls001_.ccmax_ = 0.3;
  dls001_.maxcor_ = 3;
  dls001_.msbp_ = 20;
  dls001_.mxncf_ = 10;
  dlpk01_.nni_ = 0;
  dlpk01_.nli_ = 0;
  dlpk01_.nps_ = 0;
  dlpk01_.ncfn_ = 0;
  dlpk01_.ncfl_ = 0;
  lf0_ = dls001_.lyh_ + dls001_.nyh_;
  (void) _f (neq_, t_, y_, &rwork_[lf0_ - 1]);
  dls001_.nfe_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + dls001_.lyh_ - 1 - 1] = y_[i_ - 1];
  }
  dls001_.nq_ = 1;
  dls001_.h_ = 1.0;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l621;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  if (h0_ != 0.0e0) {
    goto _l180;
  }
  tdist_ = _abs ((*tout_) - (*t_));
  w0_ = _max (_abs ((*t_)), _abs ((*tout_)));
  if (tdist_ < 2.0e0 * dls001_.uround_ * w0_) {
    goto _l622;
  }
  tol_ = rtol_[0];
  if ((*itol_) <= 2) {
    goto _l140;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    tol_ = _max (tol_, rtol_[i_ - 1]);
  }
  _l140:;
  if (tol_ > 0.0e0) {
    goto _l160;
  }
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if ((*itol_) == 2 || (*itol_) == 4) {
      atoli_ = atol_[i_ - 1];
    }
    ayi_ = _abs (y_[i_ - 1]);
    if (ayi_ != 0.0e0) {
      tol_ = _max (tol_, atoli_ / ayi_);
    }
  }
  _l160:;
  tol_ = _max (tol_, 100.0e0 * dls001_.uround_);
  tol_ = _min (tol_, 1.0e-3);
  sum_ = _dvnorm (&dls001_.n_, &rwork_[lf0_ - 1], &rwork_[dls001_.lewt_ - 1]);
  sum_ = 1.0e0 / (tol_ * w0_ * w0_) + tol_ * (sum_ * sum_);
  h0_ = 1.0e0 / sqrt (sum_);
  h0_ = _min (h0_, tdist_);
  h0_ = _sign (h0_, (*tout_) - (*t_));
  _l180:;
  rh_ = _abs (h0_) * dls001_.hmxi_;
  if (rh_ > 1.0e0) {
    h0_ = h0_ / rh_;
  }
  dls001_.h_ = h0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rwork_[i_ + lf0_ - 1 - 1] = h0_ * rwork_[i_ + lf0_ - 1 - 1];
  }
  goto _l270;
  _l200:;
  dls001_.nslast_ = dls001_.nst_;
  nli0_ = dlpk01_.nli_;
  nni0_ = dlpk01_.nni_;
  ncfn0_ = dlpk01_.ncfn_;
  ncfl0_ = dlpk01_.ncfl_;
  nwarn_ = 0;
  switch ((*itask_)) {
    default:
    case 1: goto _l210;
    case 2: goto _l250;
    case 3: goto _l220;
    case 4: goto _l230;
    case 5: goto _l240;
  }
  _l210:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l220:;
  tp_ = dls001_.tn_ - dls001_.hu_ * (1.0e0 + 100.0e0 * dls001_.uround_);
  if ((tp_ - (*tout_)) * dls001_.h_ > 0.0e0) {
    goto _l623;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  goto _l400;
  _l230:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  if ((tcrit_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l625;
  }
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l245;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  if (iflag_ != 0) {
    goto _l627;
  }
  (*t_) = (*tout_);
  goto _l420;
  _l240:;
  tcrit_ = rwork_[0];
  if ((dls001_.tn_ - tcrit_) * dls001_.h_ > 0.0e0) {
    goto _l624;
  }
  _l245:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  if ((*istate_) == 2) {
    dls001_.jstart_ = -2;
  }
  _l250:;
  if ((dls001_.nst_ - dls001_.nslast_) >= dls001_.mxstep_) {
    goto _l500;
  }
  nstd_ = dls001_.nst_ - dls001_.nslast_;
  nnid_ = dlpk01_.nni_ - nni0_;
  if (nstd_ < 10 || nnid_ == 0) {
    goto _l255;
  }
  avdim_ = (real_4) (dlpk01_.nli_ - nli0_) / (real_4) (nnid_);
  rcfn_ = (real_4) (dlpk01_.ncfn_ - ncfn0_) / (real_4) (nstd_);
  rcfl_ = (real_4) (dlpk01_.ncfl_ - ncfl0_) / (real_4) (nnid_);
  lavd_ = avdim_ > (dlpk01_.maxl_ - 0.05e0);
  lcfn_ = rcfn_ > 0.9e0;
  lcfl_ = rcfl_ > 0.9e0;
  lwarn_ = lavd_ || lcfn_ || lcfl_;
  if (! (lwarn_)) {
    goto _l255;
  }
  nwarn_ = nwarn_ + 1;
  if (nwarn_ > 10) {
    goto _l255;
  }
  if (lavd_) {
    bufcpy (msg_, _dc_371, 63);
    (void) _xerrwd (msg_, ($0_ = 60, &$0_), ($1_ = 111, &$1_), &_k0, &_k0, &_k0, &_k0, &_k0, ($2_ = 0.0, &$2_), ($3_ = 0.0, 
    &$3_));
  }
  if (lavd_) {
    bufcpy (msg_, _dc_330, 63);
    (void) _xerrwd (msg_, ($4_ = 60, &$4_), ($5_ = 111, &$5_), &_k0, &_k0, &_k0, &_k0, ($6_ = 2, &$6_), &dls001_.tn_, 
    &avdim_);
  }
  if (lcfn_) {
    bufcpy (msg_, _dc_371, 63);
    (void) _xerrwd (msg_, ($7_ = 60, &$7_), ($8_ = 112, &$8_), &_k0, &_k0, &_k0, &_k0, &_k0, ($9_ = 0.0, &$9_), ($10_ = 
    0.0, &$10_));
  }
  if (lcfn_) {
    bufcpy (msg_, _dc_331, 63);
    (void) _xerrwd (msg_, ($11_ = 60, &$11_), ($12_ = 112, &$12_), &_k0, &_k0, &_k0, &_k0, ($13_ = 2, &$13_), &dls001_.tn_, 
    &rcfn_);
  }
  if (lcfl_) {
    bufcpy (msg_, _dc_371, 63);
    (void) _xerrwd (msg_, ($14_ = 60, &$14_), ($15_ = 113, &$15_), &_k0, &_k0, &_k0, &_k0, &_k0, ($16_ = 0.0, &$16_), ($17_ 
    = 0.0, &$17_));
  }
  if (lcfl_) {
    bufcpy (msg_, _dc_332, 63);
    (void) _xerrwd (msg_, ($18_ = 60, &$18_), ($19_ = 113, &$19_), &_k0, &_k0, &_k0, &_k0, ($20_ = 2, &$20_), &dls001_.tn_, 
    &rcfl_);
  }
  _l255:;
  (void) _dewset (&dls001_.n_, itol_, rtol_, atol_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    if (rwork_[i_ + dls001_.lewt_ - 1 - 1] <= 0.0e0) {
      goto _l510;
    }
    rwork_[i_ + dls001_.lewt_ - 1 - 1] = 1.0e0 / rwork_[i_ + dls001_.lewt_ - 1 - 1];
  }
  _l270:;
  tolsf_ = dls001_.uround_ * _dvnorm (&dls001_.n_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 1]);
  if (tolsf_ <= 1.0e0) {
    goto _l280;
  }
  tolsf_ = tolsf_ * 2.0e0;
  if (dls001_.nst_ == 0) {
    goto _l626;
  }
  goto _l520;
  _l280:;
  if ((dls001_.tn_ + dls001_.h_) != dls001_.tn_) {
    goto _l290;
  }
  dls001_.nhnil_ = dls001_.nhnil_ + 1;
  if (dls001_.nhnil_ > dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_372, 63);
  (void) _xerrwd (msg_, ($21_ = 50, &$21_), ($22_ = 101, &$22_), &_k0, &_k0, &_k0, &_k0, &_k0, ($23_ = 0.0, &$23_), ($24_ 
  = 0.0, &$24_));
  bufcpy (msg_, _dc_9, 63);
  (void) _xerrwd (msg_, ($25_ = 60, &$25_), ($26_ = 101, &$26_), &_k0, &_k0, &_k0, &_k0, &_k0, ($27_ = 0.0, &$27_), ($28_ 
  = 0.0, &$28_));
  bufcpy (msg_, _dc_10, 63);
  (void) _xerrwd (msg_, ($29_ = 50, &$29_), ($30_ = 101, &$30_), &_k0, &_k0, &_k0, &_k0, ($31_ = 2, &$31_), &dls001_.tn_, 
  &dls001_.h_);
  if (dls001_.nhnil_ < dls001_.mxhnil_) {
    goto _l290;
  }
  bufcpy (msg_, _dc_373, 63);
  (void) _xerrwd (msg_, ($32_ = 50, &$32_), ($33_ = 102, &$33_), &_k0, &_k0, &_k0, &_k0, &_k0, ($34_ = 0.0, &$34_), ($35_ 
  = 0.0, &$35_));
  bufcpy (msg_, _dc_12, 63);
  (void) _xerrwd (msg_, ($36_ = 50, &$36_), ($37_ = 102, &$37_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($38_ = 0.0, 
  &$38_), ($39_ = 0.0, &$39_));
  _l290:;
  (void) _dstodpk (neq_, y_, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, &rwork_[dls001_.lyh_ - 1], &rwork_[dls001_.lewt_ - 
  1], &rwork_[dls001_.lsavf_ - 1], &rwork_[dlpk01_.lsavx_ - 1], &rwork_[dls001_.lacor_ - 1], &rwork_[dls001_.lwm_ - 1], 
  &iwork_[dls001_.liwm_ - 1], _f, _jac, _psol);
  kgo_ = 1 - dls001_.kflag_;
  switch (kgo_) {
    default:
    case 1: goto _l300;
    case 2: goto _l530;
    case 3: goto _l540;
    case 4: goto _l550;
  }
  _l300:;
  dls001_.init_ = 1;
  switch ((*itask_)) {
    default:
    case 1: goto _l310;
    case 2: goto _l400;
    case 3: goto _l330;
    case 4: goto _l340;
    case 5: goto _l350;
  }
  _l310:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l250;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l330:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ >= 0.0e0) {
    goto _l400;
  }
  goto _l250;
  _l340:;
  if ((dls001_.tn_ - (*tout_)) * dls001_.h_ < 0.0e0) {
    goto _l345;
  }
  (void) _dintdy (tout_, &_k0, &rwork_[dls001_.lyh_ - 1], &dls001_.nyh_, y_, &iflag_);
  (*t_) = (*tout_);
  goto _l420;
  _l345:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  if (ihit_) {
    goto _l400;
  }
  tnext_ = dls001_.tn_ + dls001_.h_ * (1.0e0 + 4.0e0 * dls001_.uround_);
  if ((tnext_ - tcrit_) * dls001_.h_ <= 0.0e0) {
    goto _l250;
  }
  dls001_.h_ = (tcrit_ - dls001_.tn_) * (1.0e0 - 4.0e0 * dls001_.uround_);
  dls001_.jstart_ = -2;
  goto _l250;
  _l350:;
  hmx_ = _abs (dls001_.tn_) + _abs (dls001_.h_);
  ihit_ = _abs (dls001_.tn_ - tcrit_) <= 100.0e0 * dls001_.uround_ * hmx_;
  _l400:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  if ((*itask_) != 4 && (*itask_) != 5) {
    goto _l420;
  }
  if (ihit_) {
    (*t_) = tcrit_;
  }
  _l420:;
  (*istate_) = 2;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlpk01_.nni_;
  iwork_[19] = dlpk01_.nli_;
  iwork_[20] = dlpk01_.nps_;
  iwork_[21] = dlpk01_.ncfn_;
  iwork_[22] = dlpk01_.ncfl_;
  goto _l0;
  _l500:;
  bufcpy (msg_, _dc_374, 63);
  (void) _xerrwd (msg_, ($40_ = 50, &$40_), ($41_ = 201, &$41_), &_k0, &_k0, &_k0, &_k0, &_k0, ($42_ = 0.0, &$42_), ($43_ 
  = 0.0, &$43_));
  bufcpy (msg_, _dc_17, 63);
  (void) _xerrwd (msg_, ($44_ = 50, &$44_), ($45_ = 201, &$45_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k1, &dls001_.tn_, 
  ($46_ = 0.0, &$46_));
  (*istate_) = -1;
  goto _l580;
  _l510:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_375, 63);
  (void) _xerrwd (msg_, ($47_ = 50, &$47_), ($48_ = 202, &$48_), &_k0, &_k1, &i_, &_k0, ($49_ = 2, &$49_), &dls001_.tn_, 
  &ewti_);
  (*istate_) = -6;
  goto _l580;
  _l520:;
  bufcpy (msg_, _dc_376, 63);
  (void) _xerrwd (msg_, ($50_ = 50, &$50_), ($51_ = 203, &$51_), &_k0, &_k0, &_k0, &_k0, &_k0, ($52_ = 0.0, &$52_), ($53_ 
  = 0.0, &$53_));
  bufcpy (msg_, _dc_20, 63);
  (void) _xerrwd (msg_, ($54_ = 50, &$54_), ($55_ = 203, &$55_), &_k0, &_k0, &_k0, &_k0, ($56_ = 2, &$56_), &dls001_.tn_, 
  &tolsf_);
  rwork_[13] = tolsf_;
  (*istate_) = -2;
  goto _l580;
  _l530:;
  bufcpy (msg_, _dc_377, 63);
  (void) _xerrwd (msg_, ($57_ = 50, &$57_), ($58_ = 204, &$58_), &_k0, &_k0, &_k0, &_k0, &_k0, ($59_ = 0.0, &$59_), ($60_ 
  = 0.0, &$60_));
  bufcpy (msg_, _dc_22, 63);
  (void) _xerrwd (msg_, ($61_ = 50, &$61_), ($62_ = 204, &$62_), &_k0, &_k0, &_k0, &_k0, ($63_ = 2, &$63_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -4;
  goto _l560;
  _l540:;
  bufcpy (msg_, _dc_378, 63);
  (void) _xerrwd (msg_, ($64_ = 50, &$64_), ($65_ = 205, &$65_), &_k0, &_k0, &_k0, &_k0, &_k0, ($66_ = 0.0, &$66_), ($67_ 
  = 0.0, &$67_));
  bufcpy (msg_, _dc_24, 63);
  (void) _xerrwd (msg_, ($68_ = 50, &$68_), ($69_ = 205, &$69_), &_k0, &_k0, &_k0, &_k0, &_k0, ($70_ = 0.0, &$70_), ($71_ 
  = 0.0, &$71_));
  bufcpy (msg_, _dc_25, 63);
  (void) _xerrwd (msg_, ($72_ = 30, &$72_), ($73_ = 205, &$73_), &_k0, &_k0, &_k0, &_k0, ($74_ = 2, &$74_), &dls001_.tn_, 
  &dls001_.h_);
  (*istate_) = -5;
  goto _l560;
  _l550:;
  bufcpy (msg_, _dc_379, 63);
  (void) _xerrwd (msg_, ($75_ = 50, &$75_), ($76_ = 205, &$76_), &_k0, &_k0, &_k0, &_k0, &_k0, ($77_ = 0.0, &$77_), ($78_ 
  = 0.0, &$78_));
  bufcpy (msg_, _dc_341, 63);
  (void) _xerrwd (msg_, ($79_ = 40, &$79_), ($80_ = 205, &$80_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.tn_, ($81_ = 0.0, 
  &$81_));
  (*istate_) = -7;
  goto _l580;
  _l560:;
  big_ = 0.0;
  imxer_ = 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    size_ = _abs (rwork_[i_ + dls001_.lacor_ - 1 - 1] * rwork_[i_ + dls001_.lewt_ - 1 - 1]);
    if (big_ >= size_) {
      goto _l570;
    }
    big_ = size_;
    imxer_ = i_;
    _l570:;
  }
  iwork_[15] = imxer_;
  _l580:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = rwork_[i_ + dls001_.lyh_ - 1 - 1];
  }
  (*t_) = dls001_.tn_;
  rwork_[10] = dls001_.hu_;
  rwork_[11] = dls001_.h_;
  rwork_[12] = dls001_.tn_;
  iwork_[10] = dls001_.nst_;
  iwork_[11] = dls001_.nfe_;
  iwork_[12] = dls001_.nje_;
  iwork_[13] = dls001_.nqu_;
  iwork_[14] = dls001_.nq_;
  iwork_[18] = dlpk01_.nni_;
  iwork_[19] = dlpk01_.nli_;
  iwork_[20] = dlpk01_.nps_;
  iwork_[21] = dlpk01_.ncfn_;
  iwork_[22] = dlpk01_.ncfl_;
  goto _l0;
  _l601:;
  bufcpy (msg_, _dc_380, 63);
  (void) _xerrwd (msg_, ($82_ = 30, &$82_), &_k1, &_k0, &_k1, istate_, &_k0, &_k0, ($83_ = 0.0, &$83_), ($84_ = 0.0, 
  &$84_));
  if ((*istate_) < 0) {
    goto _l800;
  }
  goto _l700;
  _l602:;
  bufcpy (msg_, _dc_381, 63);
  (void) _xerrwd (msg_, ($85_ = 30, &$85_), ($86_ = 2, &$86_), &_k0, &_k1, itask_, &_k0, &_k0, ($87_ = 0.0, &$87_), ($88_ 
  = 0.0, &$88_));
  goto _l700;
  _l603:;
  bufcpy (msg_, _dc_382, 63);
  (void) _xerrwd (msg_, ($89_ = 50, &$89_), ($90_ = 3, &$90_), &_k0, &_k0, &_k0, &_k0, &_k0, ($91_ = 0.0, &$91_), ($92_ = 
  0.0, &$92_));
  goto _l700;
  _l604:;
  bufcpy (msg_, _dc_383, 63);
  (void) _xerrwd (msg_, ($93_ = 30, &$93_), ($94_ = 4, &$94_), &_k0, &_k1, &neq_[0], &_k0, &_k0, ($95_ = 0.0, &$95_), 
  ($96_ = 0.0, &$96_));
  goto _l700;
  _l605:;
  bufcpy (msg_, _dc_384, 63);
  (void) _xerrwd (msg_, ($97_ = 50, &$97_), ($98_ = 5, &$98_), &_k0, ($99_ = 2, &$99_), &dls001_.n_, &neq_[0], &_k0, 
  ($100_ = 0.0, &$100_), ($101_ = 0.0, &$101_));
  goto _l700;
  _l606:;
  bufcpy (msg_, _dc_385, 63);
  (void) _xerrwd (msg_, ($102_ = 30, &$102_), ($103_ = 6, &$103_), &_k0, &_k1, itol_, &_k0, &_k0, ($104_ = 0.0, &$104_), 
  ($105_ = 0.0, &$105_));
  goto _l700;
  _l607:;
  bufcpy (msg_, _dc_386, 63);
  (void) _xerrwd (msg_, ($106_ = 30, &$106_), ($107_ = 7, &$107_), &_k0, &_k1, iopt_, &_k0, &_k0, ($108_ = 0.0, &$108_), 
  ($109_ = 0.0, &$109_));
  goto _l700;
  _l608:;
  bufcpy (msg_, _dc_387, 63);
  (void) _xerrwd (msg_, ($110_ = 30, &$110_), ($111_ = 8, &$111_), &_k0, &_k1, mf_, &_k0, &_k0, ($112_ = 0.0, &$112_), 
  ($113_ = 0.0, &$113_));
  goto _l700;
  _l611:;
  bufcpy (msg_, _dc_388, 63);
  (void) _xerrwd (msg_, ($114_ = 30, &$114_), ($115_ = 11, &$115_), &_k0, &_k1, &dls001_.maxord_, &_k0, &_k0, ($116_ = 
  0.0, &$116_), ($117_ = 0.0, &$117_));
  goto _l700;
  _l612:;
  bufcpy (msg_, _dc_389, 63);
  (void) _xerrwd (msg_, ($118_ = 30, &$118_), ($119_ = 12, &$119_), &_k0, &_k1, &dls001_.mxstep_, &_k0, &_k0, ($120_ = 
  0.0, &$120_), ($121_ = 0.0, &$121_));
  goto _l700;
  _l613:;
  bufcpy (msg_, _dc_390, 63);
  (void) _xerrwd (msg_, ($122_ = 30, &$122_), ($123_ = 13, &$123_), &_k0, &_k1, &dls001_.mxhnil_, &_k0, &_k0, ($124_ = 
  0.0, &$124_), ($125_ = 0.0, &$125_));
  goto _l700;
  _l614:;
  bufcpy (msg_, _dc_391, 63);
  (void) _xerrwd (msg_, ($126_ = 40, &$126_), ($127_ = 14, &$127_), &_k0, &_k0, &_k0, &_k0, ($128_ = 2, &$128_), tout_, 
  t_);
  bufcpy (msg_, _dc_43, 63);
  (void) _xerrwd (msg_, ($129_ = 50, &$129_), ($130_ = 14, &$130_), &_k0, &_k0, &_k0, &_k0, &_k1, &h0_, ($131_ = 0.0, 
  &$131_));
  goto _l700;
  _l615:;
  bufcpy (msg_, _dc_392, 63);
  (void) _xerrwd (msg_, ($132_ = 30, &$132_), ($133_ = 15, &$133_), &_k0, &_k0, &_k0, &_k0, &_k1, &hmax_, ($134_ = 0.0, 
  &$134_));
  goto _l700;
  _l616:;
  bufcpy (msg_, _dc_393, 63);
  (void) _xerrwd (msg_, ($135_ = 30, &$135_), ($136_ = 16, &$136_), &_k0, &_k0, &_k0, &_k0, &_k1, &dls001_.hmin_, ($137_ 
  = 0.0, &$137_));
  goto _l700;
  _l617:;
  bufcpy (msg_, _dc_394, 63);
  (void) _xerrwd (msg_, ($138_ = 60, &$138_), ($139_ = 17, &$139_), &_k0, ($140_ = 2, &$140_), &lenrw_, lrw_, &_k0, 
  ($141_ = 0.0, &$141_), ($142_ = 0.0, &$142_));
  goto _l700;
  _l618:;
  bufcpy (msg_, _dc_395, 63);
  (void) _xerrwd (msg_, ($143_ = 60, &$143_), ($144_ = 18, &$144_), &_k0, ($145_ = 2, &$145_), &leniw_, liw_, &_k0, 
  ($146_ = 0.0, &$146_), ($147_ = 0.0, &$147_));
  goto _l700;
  _l619:;
  bufcpy (msg_, _dc_396, 63);
  (void) _xerrwd (msg_, ($148_ = 40, &$148_), ($149_ = 19, &$149_), &_k0, &_k1, &i_, &_k0, &_k1, &rtoli_, ($150_ = 0.0, 
  &$150_));
  goto _l700;
  _l620:;
  bufcpy (msg_, _dc_397, 63);
  (void) _xerrwd (msg_, ($151_ = 40, &$151_), ($152_ = 20, &$152_), &_k0, &_k1, &i_, &_k0, &_k1, &atoli_, ($153_ = 0.0, 
  &$153_));
  goto _l700;
  _l621:;
  ewti_ = rwork_[dls001_.lewt_ + i_ - 1 - 1];
  bufcpy (msg_, _dc_398, 63);
  (void) _xerrwd (msg_, ($154_ = 40, &$154_), ($155_ = 21, &$155_), &_k0, &_k1, &i_, &_k0, &_k1, &ewti_, ($156_ = 0.0, 
  &$156_));
  goto _l700;
  _l622:;
  bufcpy (msg_, _dc_399, 63);
  (void) _xerrwd (msg_, ($157_ = 60, &$157_), ($158_ = 22, &$158_), &_k0, &_k0, &_k0, &_k0, ($159_ = 2, &$159_), tout_, 
  t_);
  goto _l700;
  _l623:;
  bufcpy (msg_, _dc_400, 63);
  (void) _xerrwd (msg_, ($160_ = 60, &$160_), ($161_ = 23, &$161_), &_k0, &_k1, itask_, &_k0, ($162_ = 2, &$162_), tout_, 
  &tp_);
  goto _l700;
  _l624:;
  bufcpy (msg_, _dc_401, 63);
  (void) _xerrwd (msg_, ($163_ = 60, &$163_), ($164_ = 24, &$164_), &_k0, &_k0, &_k0, &_k0, ($165_ = 2, &$165_), &tcrit_, 
  &dls001_.tn_);
  goto _l700;
  _l625:;
  bufcpy (msg_, _dc_402, 63);
  (void) _xerrwd (msg_, ($166_ = 60, &$166_), ($167_ = 25, &$167_), &_k0, &_k0, &_k0, &_k0, ($168_ = 2, &$168_), &tcrit_, 
  tout_);
  goto _l700;
  _l626:;
  bufcpy (msg_, _dc_403, 63);
  (void) _xerrwd (msg_, ($169_ = 50, &$169_), ($170_ = 26, &$170_), &_k0, &_k0, &_k0, &_k0, &_k0, ($171_ = 0.0, &$171_), 
  ($172_ = 0.0, &$172_));
  bufcpy (msg_, _dc_56, 63);
  (void) _xerrwd (msg_, ($173_ = 60, &$173_), ($174_ = 26, &$174_), &_k0, &_k0, &_k0, &_k0, &_k1, &tolsf_, ($175_ = 0.0, 
  &$175_));
  rwork_[13] = tolsf_;
  goto _l700;
  _l627:;
  bufcpy (msg_, _dc_404, 63);
  (void) _xerrwd (msg_, ($176_ = 50, &$176_), ($177_ = 27, &$177_), &_k0, &_k1, itask_, &_k0, &_k1, tout_, ($178_ = 0.0, 
  &$178_));
  _l700:;
  (*istate_) = -3;
  goto _l0;
  _l800:;
  bufcpy (msg_, _dc_405, 63);
  (void) _xerrwd (msg_, ($179_ = 50, &$179_), ($180_ = 303, &$180_), ($181_ = 2, &$181_), &_k0, &_k0, &_k0, &_k0, ($182_ 
  = 0.0, &$182_), ($183_ = 0.0, &$183_));
  _l0:;
  __calls[34].calls++;
  return 0;
}

real_8 _dmnorm (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ w_)
{
  static int_4 i_;
  static real_8 vm_;
  real_8 dmnorm_;
  vm_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    vm_ = _max (vm_, _abs (v_[i_ - 1]) * w_[i_ - 1]);
  }
  dmnorm_ = vm_;
  __calls[35].calls++;
  return dmnorm_;
}

int_4 _dorthog (real_8 _p_ vnew_, real_8 _p_ v_, real_8 _p_ hes_, int_4 _p_ n_, int_4 _p_ ll_, int_4 _p_ ldhes_, int_4 
_p_ kmp_, real_8 _p_ snormw_)
{
  static int_4 i_, i0_;
  static real_8 arg_, sumdsq_, tem_, vnrm_;
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  vnrm_ = _dnrm2 (n_, vnew_, &_k1);
  i0_ = _max (1, (*ll_) - (*kmp_) + 1);
  for (i_ = i0_; i_ <= (*ll_); (i_)++) {
    hes_[i_ - 1 + ((*ldhes_)) * (((*ll_) - 1))] = _ddot (n_, &v_[0 + ((*n_)) * ((i_ - 1))], &_k1, vnew_, &_k1);
    tem_ = -hes_[i_ - 1 + ((*ldhes_)) * (((*ll_) - 1))];
    (void) _daxpy (n_, &tem_, &v_[0 + ((*n_)) * ((i_ - 1))], &_k1, vnew_, &_k1);
  }
  (*snormw_) = _dnrm2 (n_, vnew_, &_k1);
  if (vnrm_ + 0.001e0 * (*snormw_) != vnrm_) {
    goto _l0;
  }
  sumdsq_ = 0.0;
  for (i_ = i0_; i_ <= (*ll_); (i_)++) {
    tem_ = -_ddot (n_, &v_[0 + ((*n_)) * ((i_ - 1))], &_k1, vnew_, &_k1);
    if (hes_[i_ - 1 + ((*ldhes_)) * (((*ll_) - 1))] + 0.001e0 * tem_ == hes_[i_ - 1 + ((*ldhes_)) * (((*ll_) - 1))]) {
      goto _l30;
    }
    hes_[i_ - 1 + ((*ldhes_)) * (((*ll_) - 1))] = hes_[i_ - 1 + ((*ldhes_)) * (((*ll_) - 1))] - tem_;
    (void) _daxpy (n_, &tem_, &v_[0 + ((*n_)) * ((i_ - 1))], &_k1, vnew_, &_k1);
    sumdsq_ = sumdsq_ + (tem_ * tem_);
    _l30:;
  }
  if (sumdsq_ == 0.0e0) {
    goto _l0;
  }
  arg_ = _max (0.0, ((*snormw_) * (*snormw_)) - sumdsq_);
  (*snormw_) = sqrt (arg_);
  _l0:;
  __calls[36].calls++;
  return 0;
}

int_4 _dpcg (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ r_, real_8 _p_ wght_, int_4 
_p_ n_, int_4 _p_ maxl_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ jpre_, int_4 _p_ mnewt_, real_4 (*_f)(), int_4 
(*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 _p_ p_, real_8 _p_ w_, real_8 _p_ z_, int_4 _p_ lpcg_, real_8 _p_ 
wp_, int_4 _p_ iwp_, real_8 _p_ wk_, int_4 _p_ iflag_)
{
  static int_4 i_, ier_;
  static real_8 alpha_, beta_, bnrm_, ptw_, rnrm_, ztr_, ztr0_;
  int_4 $0_;
  extern real_8 _ddot ();
  (*iflag_) = 0;
  (*npsl_) = 0;
  (*lpcg_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = 0.0;
  }
  bnrm_ = _dvnorm (n_, r_, wght_);
  if (bnrm_ > (*delta_)) {
    goto _l20;
  }
  if ((*mnewt_) > 0) {
    goto _l0;
  }
  (void) _dcopy (n_, r_, &_k1, x_, &_k1);
  goto _l0;
  _l20:;
  ztr_ = 0.0;
  _l30:;
  (*lpcg_) = (*lpcg_) + 1;
  (void) _dcopy (n_, r_, &_k1, z_, &_k1);
  ier_ = 0;
  if ((*jpre_) == 0) {
    goto _l40;
  }
  (void) _psol (neq_, tn_, y_, savf_, wk_, hl0_, wp_, iwp_, z_, ($0_ = 3, &$0_), &ier_);
  (*npsl_) = (*npsl_) + 1;
  if (ier_ != 0) {
    goto _l100;
  }
  _l40:;
  ztr0_ = ztr_;
  ztr_ = _ddot (n_, z_, &_k1, r_, &_k1);
  if ((*lpcg_) != 1) {
    goto _l50;
  }
  (void) _dcopy (n_, z_, &_k1, p_, &_k1);
  goto _l70;
  _l50:;
  if (ztr0_ == 0.0e0) {
    goto _l200;
  }
  beta_ = ztr_ / ztr0_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    p_[i_ - 1] = z_[i_ - 1] + beta_ * p_[i_ - 1];
  }
  _l70:;
  (void) _datp (neq_, y_, savf_, p_, wght_, hl0_, wk_, _f, w_);
  ptw_ = _ddot (n_, p_, &_k1, w_, &_k1);
  if (ptw_ == 0.0e0) {
    goto _l200;
  }
  alpha_ = ztr_ / ptw_;
  (void) _daxpy (n_, &alpha_, p_, &_k1, x_, &_k1);
  alpha_ = -alpha_;
  (void) _daxpy (n_, &alpha_, w_, &_k1, r_, &_k1);
  rnrm_ = _dvnorm (n_, r_, wght_);
  if (rnrm_ <= (*delta_)) {
    goto _l0;
  }
  if ((*lpcg_) < (*maxl_)) {
    goto _l30;
  }
  (*iflag_) = 2;
  if (rnrm_ <= 1.0e0) {
    (*iflag_) = 1;
  }
  if (rnrm_ <= bnrm_ && (*mnewt_) == 0) {
    (*iflag_) = 1;
  }
  goto _l0;
  _l100:;
  if (ier_ < 0) {
    (*iflag_) = -1;
  }
  if (ier_ > 0) {
    (*iflag_) = 3;
  }
  goto _l0;
  _l200:;
  (*iflag_) = 4;
  _l0:;
  __calls[37].calls++;
  return 0;
}

int_4 _dpcgs (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ r_, real_8 _p_ wght_, int_4 
_p_ n_, int_4 _p_ maxl_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ jpre_, int_4 _p_ mnewt_, real_4 (*_f)(), int_4 
(*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 _p_ p_, real_8 _p_ w_, real_8 _p_ z_, int_4 _p_ lpcg_, real_8 _p_ 
wp_, int_4 _p_ iwp_, real_8 _p_ wk_, int_4 _p_ iflag_)
{
  static int_4 i_, ier_;
  static real_8 alpha_, beta_, bnrm_, ptw_, rnrm_, ztr_, ztr0_;
  int_4 $0_;
  (*iflag_) = 0;
  (*npsl_) = 0;
  (*lpcg_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = 0.0;
  }
  bnrm_ = _dvnorm (n_, r_, wght_);
  if (bnrm_ > (*delta_)) {
    goto _l20;
  }
  if ((*mnewt_) > 0) {
    goto _l0;
  }
  (void) _dcopy (n_, r_, &_k1, x_, &_k1);
  goto _l0;
  _l20:;
  ztr_ = 0.0;
  _l30:;
  (*lpcg_) = (*lpcg_) + 1;
  (void) _dcopy (n_, r_, &_k1, z_, &_k1);
  ier_ = 0;
  if ((*jpre_) == 0) {
    goto _l40;
  }
  (void) _psol (neq_, tn_, y_, savf_, wk_, hl0_, wp_, iwp_, z_, ($0_ = 3, &$0_), &ier_);
  (*npsl_) = (*npsl_) + 1;
  if (ier_ != 0) {
    goto _l100;
  }
  _l40:;
  ztr0_ = ztr_;
  ztr_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ztr_ = ztr_ + z_[i_ - 1] * r_[i_ - 1] * (wght_[i_ - 1] * wght_[i_ - 1]);
  }
  if ((*lpcg_) != 1) {
    goto _l50;
  }
  (void) _dcopy (n_, z_, &_k1, p_, &_k1);
  goto _l70;
  _l50:;
  if (ztr0_ == 0.0e0) {
    goto _l200;
  }
  beta_ = ztr_ / ztr0_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    p_[i_ - 1] = z_[i_ - 1] + beta_ * p_[i_ - 1];
  }
  _l70:;
  (void) _datp (neq_, y_, savf_, p_, wght_, hl0_, wk_, _f, w_);
  ptw_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ptw_ = ptw_ + p_[i_ - 1] * w_[i_ - 1] * (wght_[i_ - 1] * wght_[i_ - 1]);
  }
  if (ptw_ == 0.0e0) {
    goto _l200;
  }
  alpha_ = ztr_ / ptw_;
  (void) _daxpy (n_, &alpha_, p_, &_k1, x_, &_k1);
  alpha_ = -alpha_;
  (void) _daxpy (n_, &alpha_, w_, &_k1, r_, &_k1);
  rnrm_ = _dvnorm (n_, r_, wght_);
  if (rnrm_ <= (*delta_)) {
    goto _l0;
  }
  if ((*lpcg_) < (*maxl_)) {
    goto _l30;
  }
  (*iflag_) = 2;
  if (rnrm_ <= 1.0e0) {
    (*iflag_) = 1;
  }
  if (rnrm_ <= bnrm_ && (*mnewt_) == 0) {
    (*iflag_) = 1;
  }
  goto _l0;
  _l100:;
  if (ier_ < 0) {
    (*iflag_) = -1;
  }
  if (ier_ > 0) {
    (*iflag_) = 3;
  }
  goto _l0;
  _l200:;
  (*iflag_) = 4;
  _l0:;
  __calls[38].calls++;
  return 0;
}

int_4 _dpjibt (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ rtem_, real_8 
_p_ savr_, real_8 _p_ s_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), int_4 (*_jac)(), int_4 (*_adda)())
{
  static int_4 i_, ier_, iia_, iib_, iic_, ipa_, ipb_, ipc_, ires_, j_, j1_, j2_, k_, k1_, lenp_, lblox_, lpb_, lpc_, mb_
  , mbsq_, mwid_, nb_;
  static real_8 con_, fac_, hl0_, r_, srur_;
  dls001_.nje_ = dls001_.nje_ + 1;
  hl0_ = dls001_.h_ * dls001_.el0_;
  dls001_.ierpj_ = 0;
  dls001_.jcur_ = 1;
  mb_ = iwm_[0];
  nb_ = iwm_[1];
  mbsq_ = mb_ * mb_;
  lblox_ = mbsq_ * nb_;
  lpb_ = 3 + lblox_;
  lpc_ = lpb_ + lblox_;
  lenp_ = 3 * lblox_;
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
  }
  _l100:;
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = 0.0;
  }
  (void) _jac (neq_, &dls001_.tn_, y_, s_, &mb_, &nb_, &wm_[2], &wm_[lpb_ - 1], &wm_[lpc_ - 1]);
  con_ = -hl0_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = wm_[i_ + 2 - 1] * con_;
  }
  goto _l260;
  _l200:;
  ires_ = -1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  mwid_ = 3 * mb_;
  srur_ = wm_[0];
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[2 + i_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= 3; (k_)++) {
    for (j_ = 1; j_ <= mb_; (j_)++) {
      j1_ = j_ + (k_ - 1) * mb_;
      for (i_ = j1_; (mwid_ > 0 ? i_ <= dls001_.n_ : i_ >= dls001_.n_); i_ += mwid_) {
        r_ = _max (srur_ * _abs (y_[i_ - 1]), 0.01e0 / ewt_[i_ - 1]);
        y_[i_ - 1] = y_[i_ - 1] + r_;
      }
      (void) _res (neq_, &dls001_.tn_, y_, s_, rtem_, &ires_);
      dls001_.nfe_ = dls001_.nfe_ + 1;
      if (ires_ > 1) {
        goto _l600;
      }
      for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
        rtem_[i_ - 1] = rtem_[i_ - 1] - savr_[i_ - 1];
      }
      k1_ = k_;
      for (i_ = j1_; (mwid_ > 0 ? i_ <= dls001_.n_ : i_ >= dls001_.n_); i_ += mwid_) {
        y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
        r_ = _max (srur_ * _abs (y_[i_ - 1]), 0.01e0 / ewt_[i_ - 1]);
        fac_ = -hl0_ / r_;
        iia_ = i_ - j_;
        ipa_ = 2 + (j_ - 1) * mb_ + (k1_ - 1) * mbsq_;
        for (j2_ = 1; j2_ <= mb_; (j2_)++) {
          wm_[ipa_ + j2_ - 1] = rtem_[iia_ + j2_ - 1] * fac_;
        }
        if (k1_ <= 1) {
          goto _l223;
        }
        iib_ = iia_ - mb_;
        ipb_ = ipa_ + lblox_ - mbsq_;
        for (j2_ = 1; j2_ <= mb_; (j2_)++) {
          wm_[ipb_ + j2_ - 1] = rtem_[iib_ + j2_ - 1] * fac_;
        }
        _l223:;
        if (k1_ >= nb_) {
          goto _l225;
        }
        iic_ = iia_ + mb_;
        ipc_ = ipa_ + 2 * lblox_ + mbsq_;
        for (j2_ = 1; j2_ <= mb_; (j2_)++) {
          wm_[ipc_ + j2_ - 1] = rtem_[iic_ + j2_ - 1] * fac_;
        }
        _l225:;
        if (k1_ != 3) {
          goto _l227;
        }
        ipc_ = ipa_ - 2 * mbsq_ + 2 * lblox_;
        for (j2_ = 1; j2_ <= mb_; (j2_)++) {
          wm_[ipc_ + j2_ - 1] = rtem_[j2_ - 1] * fac_;
        }
        _l227:;
        if (k1_ != nb_ - 2) {
          goto _l229;
        }
        iib_ = dls001_.n_ - mb_;
        ipb_ = ipa_ + 2 * mbsq_ + lblox_;
        for (j2_ = 1; j2_ <= mb_; (j2_)++) {
          wm_[ipb_ + j2_ - 1] = rtem_[iib_ + j2_ - 1] * fac_;
        }
        _l229:;
        k1_ = k1_ + 3;
      }
    }
  }
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  _l260:;
  (void) _adda (neq_, &dls001_.tn_, y_, &mb_, &nb_, &wm_[2], &wm_[lpb_ - 1], &wm_[lpc_ - 1]);
  (void) _ddecbt (&mb_, &nb_, &wm_[2], &wm_[lpb_ - 1], &wm_[lpc_ - 1], &iwm_[20], &ier_);
  if (ier_ != 0) {
    dls001_.ierpj_ = 1;
  }
  goto _l0;
  _l600:;
  dls001_.ierpj_ = ires_;
  _l0:;
  __calls[39].calls++;
  return 0;
}

int_4 _dpkset (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ ysv_, real_8 _p_ ewt_, real_8 _p_ ftem_, real_8 _p_ savf_, 
real_8 _p_ wm_, int_4 _p_ iwm_, real_4 (*_f)(), int_4 (*_jac)())
{
  static int_4 ier_;
  static real_8 hl0_;
  dls001_.ierpj_ = 0;
  dls001_.jcur_ = 1;
  hl0_ = dls001_.el0_ * dls001_.h_;
  (void) _jac (_f, neq_, &dls001_.tn_, y_, ysv_, ewt_, savf_, ftem_, &hl0_, &wm_[dlpk01_.locwp_ - 1], 
  &iwm_[dlpk01_.lociwp_ - 1], &ier_);
  dls001_.nje_ = dls001_.nje_ + 1;
  if (ier_ == 0) {
    goto _l0;
  }
  dls001_.ierpj_ = 1;
  _l0:;
  __calls[40].calls++;
  return 0;
}

int_4 _dprep (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, real_8 _p_ savf_, real_8 _p_ ewt_, real_8 _p_ ftem_, int_4 
_p_ ia_, int_4 _p_ ja_, real_8 _p_ wk_, int_4 _p_ iwk_, int_4 _p_ ipper_, int_4 (*_f)(), int_4 (*_jac)())
{
  static int_4 i_, ibr_, ier_, ipil_, ipiu_, iptt1_, iptt2_, j_, jfound_, k_, knew_, kmax_, kmin_, ldif_, lenigp_, liwk_, 
  maxg_, np1_, nzsut_;
  static real_8 dq_, dyj_, erwt_, fac_, yj_;
  int_4 $0_;
  dlss01_.ibian_ = dlss01_.lrat_ * 2;
  dlss01_.ipian_ = dlss01_.ibian_ + 1;
  np1_ = dls001_.n_ + 1;
  dlss01_.ipjan_ = dlss01_.ipian_ + np1_;
  dlss01_.ibjan_ = dlss01_.ipjan_ - 1;
  liwk_ = dlss01_.lenwk_ * dlss01_.lrat_;
  if (dlss01_.ipjan_ + dls001_.n_ - 1 > liwk_) {
    goto _l210;
  }
  if (dlss01_.moss_ == 0) {
    goto _l30;
  }
  if (dlss01_.istatc_ == 3) {
    goto _l20;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    erwt_ = 1.0e0 / ewt_[i_ - 1];
    fac_ = 1.0e0 + 1.0e0 / (i_ + 1.0e0);
    y_[i_ - 1] = y_[i_ - 1] + fac_ * _sign (erwt_, y_[i_ - 1]);
  }
  switch (dlss01_.moss_) {
    default:
    case 1: goto _l70;
    case 2: goto _l100;
  }
  _l20:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1];
  }
  switch (dlss01_.moss_) {
    default:
    case 1: goto _l70;
    case 2: goto _l100;
  }
  _l30:;
  knew_ = dlss01_.ipjan_;
  kmin_ = ia_[0];
  iwk_[dlss01_.ipian_ - 1] = 1;
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    jfound_ = 0;
    kmax_ = ia_[j_ + 1 - 1] - 1;
    if (kmin_ > kmax_) {
      goto _l45;
    }
    for (k_ = kmin_; k_ <= kmax_; (k_)++) {
      i_ = ja_[k_ - 1];
      if (i_ == j_) {
        jfound_ = 1;
      }
      if (knew_ > liwk_) {
        goto _l210;
      }
      iwk_[knew_ - 1] = i_;
      knew_ = knew_ + 1;
    }
    if (jfound_ == 1) {
      goto _l50;
    }
    _l45:;
    if (knew_ > liwk_) {
      goto _l210;
    }
    iwk_[knew_ - 1] = j_;
    knew_ = knew_ + 1;
    _l50:;
    iwk_[dlss01_.ipian_ + j_ - 1] = knew_ + 1 - dlss01_.ipjan_;
    kmin_ = kmax_ + 1;
  }
  goto _l140;
  _l70:;
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  k_ = dlss01_.ipjan_;
  iwk_[dlss01_.ipian_ - 1] = 1;
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    if (k_ > liwk_) {
      goto _l210;
    }
    iwk_[k_ - 1] = j_;
    k_ = k_ + 1;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      savf_[i_ - 1] = 0.0;
    }
    (void) _jac (neq_, &dls001_.tn_, y_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], savf_);
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      if (_abs (savf_[i_ - 1]) <= dlss01_.seth_) {
        goto _l80;
      }
      if (i_ == j_) {
        goto _l80;
      }
      if (k_ > liwk_) {
        goto _l210;
      }
      iwk_[k_ - 1] = i_;
      k_ = k_ + 1;
      _l80:;
    }
    iwk_[dlss01_.ipian_ + j_ - 1] = k_ + 1 - dlss01_.ipjan_;
  }
  goto _l140;
  _l100:;
  k_ = dlss01_.ipjan_;
  iwk_[dlss01_.ipian_ - 1] = 1;
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    if (k_ > liwk_) {
      goto _l210;
    }
    iwk_[k_ - 1] = j_;
    k_ = k_ + 1;
    yj_ = y_[j_ - 1];
    erwt_ = 1.0e0 / ewt_[j_ - 1];
    dyj_ = _sign (erwt_, yj_);
    y_[j_ - 1] = yj_ + dyj_;
    (void) _f (neq_, &dls001_.tn_, y_, ftem_);
    y_[j_ - 1] = yj_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      dq_ = (ftem_[i_ - 1] - savf_[i_ - 1]) / dyj_;
      if (_abs (dq_) <= dlss01_.seth_) {
        goto _l110;
      }
      if (i_ == j_) {
        goto _l110;
      }
      if (k_ > liwk_) {
        goto _l210;
      }
      iwk_[k_ - 1] = i_;
      k_ = k_ + 1;
      _l110:;
    }
    iwk_[dlss01_.ipian_ + j_ - 1] = k_ + 1 - dlss01_.ipjan_;
  }
  _l140:;
  if (dlss01_.moss_ == 0 || dlss01_.istatc_ != 1) {
    goto _l150;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1];
  }
  _l150:;
  dlss01_.nnz_ = iwk_[dlss01_.ipian_ + dls001_.n_ - 1] - 1;
  lenigp_ = 0;
  dlss01_.ipigp_ = dlss01_.ipjan_ + dlss01_.nnz_;
  if (dls001_.miter_ != 2) {
    goto _l160;
  }
  maxg_ = np1_;
  dlss01_.ipjgp_ = dlss01_.ipjan_ + dlss01_.nnz_;
  dlss01_.ibjgp_ = dlss01_.ipjgp_ - 1;
  dlss01_.ipigp_ = dlss01_.ipjgp_ + dls001_.n_;
  iptt1_ = dlss01_.ipigp_ + np1_;
  iptt2_ = iptt1_ + dls001_.n_;
  dlss01_.lreq_ = iptt2_ + dls001_.n_ - 1;
  if (dlss01_.lreq_ > liwk_) {
    goto _l220;
  }
  (void) _jgroup (&dls001_.n_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &maxg_, &dlss01_.ngp_, 
  &iwk_[dlss01_.ipigp_ - 1], &iwk_[dlss01_.ipjgp_ - 1], &iwk_[iptt1_ - 1], &iwk_[iptt2_ - 1], &ier_);
  if (ier_ != 0) {
    goto _l220;
  }
  lenigp_ = dlss01_.ngp_ + 1;
  _l160:;
  dlss01_.ipr_ = dlss01_.ipigp_ + lenigp_;
  dlss01_.ipc_ = dlss01_.ipr_;
  dlss01_.ipic_ = dlss01_.ipc_ + dls001_.n_;
  dlss01_.ipisp_ = dlss01_.ipic_ + dls001_.n_;
  dlss01_.iprsp_ = (dlss01_.ipisp_ - 2) / dlss01_.lrat_ + 2;
  dlss01_.iesp_ = dlss01_.lenwk_ + 1 - dlss01_.iprsp_;
  if (dlss01_.iesp_ < 0) {
    goto _l230;
  }
  ibr_ = dlss01_.ipr_ - 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    iwk_[ibr_ + i_ - 1] = i_;
  }
  dlss01_.nsp_ = liwk_ + 1 - dlss01_.ipisp_;
  (void) _odrv (&dls001_.n_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], wk_, &iwk_[dlss01_.ipr_ - 1], 
  &iwk_[dlss01_.ipic_ - 1], &dlss01_.nsp_, &iwk_[dlss01_.ipisp_ - 1], &_k1, &dlss01_.iys_);
  if (dlss01_.iys_ == 11 * dls001_.n_ + 1) {
    goto _l240;
  }
  if (dlss01_.iys_ != 0) {
    goto _l230;
  }
  dlss01_.ipa_ = dlss01_.lenwk_ + 1 - dlss01_.nnz_;
  dlss01_.nsp_ = dlss01_.ipa_ - dlss01_.iprsp_;
  dlss01_.lreq_ = _max (12 * dls001_.n_ / dlss01_.lrat_, 6 * dls001_.n_ / dlss01_.lrat_ + 2 * dls001_.n_ + dlss01_.nnz_) 
  + 3;
  dlss01_.lreq_ = dlss01_.lreq_ + dlss01_.iprsp_ - 1 + dlss01_.nnz_;
  if (dlss01_.lreq_ > dlss01_.lenwk_) {
    goto _l250;
  }
  dlss01_.iba_ = dlss01_.ipa_ - 1;
  for (i_ = 1; i_ <= dlss01_.nnz_; (i_)++) {
    wk_[dlss01_.iba_ + i_ - 1] = 0.0;
  }
  dlss01_.ipisp_ = dlss01_.lrat_ * (dlss01_.iprsp_ - 1) + 1;
  (void) _cdrv (&dls001_.n_, &iwk_[dlss01_.ipr_ - 1], &iwk_[dlss01_.ipc_ - 1], &iwk_[dlss01_.ipic_ - 1], 
  &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &wk_[dlss01_.ipa_ - 1], &wk_[dlss01_.ipa_ - 1], &wk_[dlss01_.ipa_ 
  - 1], &dlss01_.nsp_, &iwk_[dlss01_.ipisp_ - 1], &wk_[dlss01_.iprsp_ - 1], &dlss01_.iesp_, ($0_ = 5, &$0_), 
  &dlss01_.iys_);
  dlss01_.lreq_ = dlss01_.lenwk_ - dlss01_.iesp_;
  if (dlss01_.iys_ == 10 * dls001_.n_ + 1) {
    goto _l250;
  }
  if (dlss01_.iys_ != 0) {
    goto _l260;
  }
  ipil_ = dlss01_.ipisp_;
  ipiu_ = ipil_ + 2 * dls001_.n_ + 1;
  dlss01_.nzu_ = iwk_[ipil_ + dls001_.n_ - 1] - iwk_[ipil_ - 1];
  dlss01_.nzl_ = iwk_[ipiu_ + dls001_.n_ - 1] - iwk_[ipiu_ - 1];
  if (dlss01_.lrat_ > 1) {
    goto _l190;
  }
  (void) _adjlr (&dls001_.n_, &iwk_[dlss01_.ipisp_ - 1], &ldif_);
  dlss01_.lreq_ = dlss01_.lreq_ + ldif_;
  _l190:;
  if (dlss01_.lrat_ == 2 && dlss01_.nnz_ == dls001_.n_) {
    dlss01_.lreq_ = dlss01_.lreq_ + 1;
  }
  dlss01_.nsp_ = dlss01_.nsp_ + dlss01_.lreq_ - dlss01_.lenwk_;
  dlss01_.ipa_ = dlss01_.lreq_ + 1 - dlss01_.nnz_;
  dlss01_.iba_ = dlss01_.ipa_ - 1;
  (*ipper_) = 0;
  goto _l0;
  _l210:;
  (*ipper_) = -1;
  dlss01_.lreq_ = 2 + (2 * dls001_.n_ + 1) / dlss01_.lrat_;
  dlss01_.lreq_ = _max (dlss01_.lenwk_ + 1, dlss01_.lreq_);
  goto _l0;
  _l220:;
  (*ipper_) = -2;
  dlss01_.lreq_ = (dlss01_.lreq_ - 1) / dlss01_.lrat_ + 1;
  goto _l0;
  _l230:;
  (*ipper_) = -3;
  (void) _cntnzu (&dls001_.n_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &nzsut_);
  dlss01_.lreq_ = dlss01_.lenwk_ - dlss01_.iesp_ + (3 * dls001_.n_ + 4 * nzsut_ - 1) / dlss01_.lrat_ + 1;
  goto _l0;
  _l240:;
  (*ipper_) = -4;
  goto _l0;
  _l250:;
  (*ipper_) = -5;
  goto _l0;
  _l260:;
  (*ipper_) = -6;
  dlss01_.lreq_ = dlss01_.lenwk_;
  _l0:;
  __calls[41].calls++;
  return 0;
}

int_4 _dprepi (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ s_, real_8 _p_ yh_, real_8 _p_ savr_, real_8 _p_ ewt_, real_8 
_p_ rtem_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ ic_, int_4 _p_ jc_, real_8 _p_ wk_, int_4 _p_ iwk_, int_4 _p_ ipper_
, int_4 (*_res)(), int_4 (*_jac)(), int_4 (*_adda)())
{
  static int_4 i_, ibr_, ier_, ipil_, ipiu_, iptt1_, iptt2_, j_, k_, knew_, kamax_, kamin_, kcmax_, kcmin_, ldif_, 
  lenigp_, lenwk1_, liwk_, ljfo_, maxg_, np1_, nzsut_;
  static real_8 erwt_, fac_, yj_;
  int_4 $0_;
  dlss01_.ibian_ = dlss01_.lrat_ * 2;
  dlss01_.ipian_ = dlss01_.ibian_ + 1;
  np1_ = dls001_.n_ + 1;
  dlss01_.ipjan_ = dlss01_.ipian_ + np1_;
  dlss01_.ibjan_ = dlss01_.ipjan_ - 1;
  lenwk1_ = dlss01_.lenwk_ - dls001_.n_;
  liwk_ = dlss01_.lenwk_ * dlss01_.lrat_;
  if (dlss01_.moss_ == 0) {
    liwk_ = liwk_ - dls001_.n_;
  }
  if (dlss01_.moss_ == 1 || dlss01_.moss_ == 2) {
    liwk_ = lenwk1_ * dlss01_.lrat_;
  }
  if (dlss01_.ipjan_ + dls001_.n_ - 1 > liwk_) {
    goto _l310;
  }
  if (dlss01_.moss_ == 0) {
    goto _l30;
  }
  if (dlss01_.istatc_ == 3) {
    goto _l20;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    erwt_ = 1.0e0 / ewt_[i_ - 1];
    fac_ = 1.0e0 + 1.0e0 / (i_ + 1.0e0);
    y_[i_ - 1] = y_[i_ - 1] + fac_ * _sign (erwt_, y_[i_ - 1]);
    s_[i_ - 1] = 1.0e0 + fac_ * erwt_;
  }
  switch (dlss01_.moss_) {
    default:
    case 1: goto _l70;
    case 2: goto _l100;
    case 3: goto _l150;
    case 4: goto _l200;
  }
  _l20:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1];
    s_[i_ - 1] = yh_[dls001_.n_ + i_ - 1];
  }
  switch (dlss01_.moss_) {
    default:
    case 1: goto _l70;
    case 2: goto _l100;
    case 3: goto _l150;
    case 4: goto _l200;
  }
  _l30:;
  knew_ = dlss01_.ipjan_;
  kamin_ = ia_[0];
  kcmin_ = ic_[0];
  iwk_[dlss01_.ipian_ - 1] = 1;
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      iwk_[liwk_ + i_ - 1] = 0;
    }
    kamax_ = ia_[j_ + 1 - 1] - 1;
    if (kamin_ > kamax_) {
      goto _l45;
    }
    for (k_ = kamin_; k_ <= kamax_; (k_)++) {
      i_ = ja_[k_ - 1];
      iwk_[liwk_ + i_ - 1] = 1;
      if (knew_ > liwk_) {
        goto _l310;
      }
      iwk_[knew_ - 1] = i_;
      knew_ = knew_ + 1;
    }
    _l45:;
    kamin_ = kamax_ + 1;
    kcmax_ = ic_[j_ + 1 - 1] - 1;
    if (kcmin_ > kcmax_) {
      goto _l55;
    }
    for (k_ = kcmin_; k_ <= kcmax_; (k_)++) {
      i_ = jc_[k_ - 1];
      if (iwk_[liwk_ + i_ - 1] != 0) {
        goto _l50;
      }
      if (knew_ > liwk_) {
        goto _l310;
      }
      iwk_[knew_ - 1] = i_;
      knew_ = knew_ + 1;
      _l50:;
    }
    _l55:;
    iwk_[dlss01_.ipian_ + j_ - 1] = knew_ + 1 - dlss01_.ipjan_;
    kcmin_ = kcmax_ + 1;
  }
  goto _l240;
  _l70:;
  ier_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ier_);
  if (ier_ > 1) {
    goto _l370;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savr_[i_ - 1] = 0.0;
    wk_[lenwk1_ + i_ - 1] = 0.0;
  }
  k_ = dlss01_.ipjan_;
  iwk_[dlss01_.ipian_ - 1] = 1;
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    (void) _adda (neq_, &dls001_.tn_, y_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &wk_[lenwk1_ + 1 - 1])
    ;
    (void) _jac (neq_, &dls001_.tn_, y_, s_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], savr_);
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      ljfo_ = lenwk1_ + i_;
      if (wk_[ljfo_ - 1] == 0.0e0) {
        goto _l80;
      }
      wk_[ljfo_ - 1] = 0.0;
      savr_[i_ - 1] = 0.0;
      goto _l85;
      _l80:;
      if (savr_[i_ - 1] == 0.0e0) {
        goto _l90;
      }
      savr_[i_ - 1] = 0.0;
      _l85:;
      if (k_ > liwk_) {
        goto _l310;
      }
      iwk_[k_ - 1] = i_;
      k_ = k_ + 1;
      _l90:;
    }
    iwk_[dlss01_.ipian_ + j_ - 1] = k_ + 1 - dlss01_.ipjan_;
  }
  goto _l240;
  _l100:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    wk_[lenwk1_ + i_ - 1] = 0.0;
  }
  k_ = dlss01_.ipjan_;
  iwk_[dlss01_.ipian_ - 1] = 1;
  ier_ = -1;
  if (dls001_.miter_ == 1) {
    ier_ = 1;
  }
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ier_);
  if (ier_ > 1) {
    goto _l370;
  }
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    (void) _adda (neq_, &dls001_.tn_, y_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &wk_[lenwk1_ + 1 - 1])
    ;
    yj_ = y_[j_ - 1];
    erwt_ = 1.0e0 / ewt_[j_ - 1];
    y_[j_ - 1] = yj_ + _sign (erwt_, yj_);
    (void) _res (neq_, &dls001_.tn_, y_, s_, rtem_, &ier_);
    if (ier_ > 1) {
      goto _l0;
    }
    y_[j_ - 1] = yj_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      ljfo_ = lenwk1_ + i_;
      if (wk_[ljfo_ - 1] == 0.0e0) {
        goto _l110;
      }
      wk_[ljfo_ - 1] = 0.0;
      goto _l115;
      _l110:;
      if (rtem_[i_ - 1] == savr_[i_ - 1]) {
        goto _l120;
      }
      _l115:;
      if (k_ > liwk_) {
        goto _l310;
      }
      iwk_[k_ - 1] = i_;
      k_ = k_ + 1;
      _l120:;
    }
    iwk_[dlss01_.ipian_ + j_ - 1] = k_ + 1 - dlss01_.ipjan_;
  }
  goto _l240;
  _l150:;
  ier_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ier_);
  if (ier_ > 1) {
    goto _l370;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savr_[i_ - 1] = 0.0;
  }
  knew_ = dlss01_.ipjan_;
  kamin_ = ia_[0];
  iwk_[dlss01_.ipian_ - 1] = 1;
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    (void) _jac (neq_, &dls001_.tn_, y_, s_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], savr_);
    kamax_ = ia_[j_ + 1 - 1] - 1;
    if (kamin_ > kamax_) {
      goto _l170;
    }
    for (k_ = kamin_; k_ <= kamax_; (k_)++) {
      i_ = ja_[k_ - 1];
      savr_[i_ - 1] = 0.0;
      if (knew_ > liwk_) {
        goto _l310;
      }
      iwk_[knew_ - 1] = i_;
      knew_ = knew_ + 1;
    }
    _l170:;
    kamin_ = kamax_ + 1;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      if (savr_[i_ - 1] == 0.0e0) {
        goto _l180;
      }
      savr_[i_ - 1] = 0.0;
      if (knew_ > liwk_) {
        goto _l310;
      }
      iwk_[knew_ - 1] = i_;
      knew_ = knew_ + 1;
      _l180:;
    }
    iwk_[dlss01_.ipian_ + j_ - 1] = knew_ + 1 - dlss01_.ipjan_;
  }
  goto _l240;
  _l200:;
  knew_ = dlss01_.ipjan_;
  kamin_ = ia_[0];
  iwk_[dlss01_.ipian_ - 1] = 1;
  ier_ = -1;
  if (dls001_.miter_ == 1) {
    ier_ = 1;
  }
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ier_);
  if (ier_ > 1) {
    goto _l370;
  }
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    yj_ = y_[j_ - 1];
    erwt_ = 1.0e0 / ewt_[j_ - 1];
    y_[j_ - 1] = yj_ + _sign (erwt_, yj_);
    (void) _res (neq_, &dls001_.tn_, y_, s_, rtem_, &ier_);
    if (ier_ > 1) {
      goto _l0;
    }
    y_[j_ - 1] = yj_;
    kamax_ = ia_[j_ + 1 - 1] - 1;
    if (kamin_ > kamax_) {
      goto _l225;
    }
    for (k_ = kamin_; k_ <= kamax_; (k_)++) {
      i_ = ja_[k_ - 1];
      rtem_[i_ - 1] = savr_[i_ - 1];
      if (knew_ > liwk_) {
        goto _l310;
      }
      iwk_[knew_ - 1] = i_;
      knew_ = knew_ + 1;
    }
    _l225:;
    kamin_ = kamax_ + 1;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      if (rtem_[i_ - 1] == savr_[i_ - 1]) {
        goto _l230;
      }
      if (knew_ > liwk_) {
        goto _l310;
      }
      iwk_[knew_ - 1] = i_;
      knew_ = knew_ + 1;
      _l230:;
    }
    iwk_[dlss01_.ipian_ + j_ - 1] = knew_ + 1 - dlss01_.ipjan_;
  }
  _l240:;
  if (dlss01_.moss_ == 0 || dlss01_.istatc_ == 3) {
    goto _l250;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1];
  }
  _l250:;
  dlss01_.nnz_ = iwk_[dlss01_.ipian_ + dls001_.n_ - 1] - 1;
  (*ipper_) = 0;
  dlss01_.ngp_ = 0;
  lenigp_ = 0;
  dlss01_.ipigp_ = dlss01_.ipjan_ + dlss01_.nnz_;
  if (dls001_.miter_ != 2) {
    goto _l260;
  }
  maxg_ = np1_;
  dlss01_.ipjgp_ = dlss01_.ipjan_ + dlss01_.nnz_;
  dlss01_.ibjgp_ = dlss01_.ipjgp_ - 1;
  dlss01_.ipigp_ = dlss01_.ipjgp_ + dls001_.n_;
  iptt1_ = dlss01_.ipigp_ + np1_;
  iptt2_ = iptt1_ + dls001_.n_;
  dlss01_.lreq_ = iptt2_ + dls001_.n_ - 1;
  if (dlss01_.lreq_ > liwk_) {
    goto _l320;
  }
  (void) _jgroup (&dls001_.n_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &maxg_, &dlss01_.ngp_, 
  &iwk_[dlss01_.ipigp_ - 1], &iwk_[dlss01_.ipjgp_ - 1], &iwk_[iptt1_ - 1], &iwk_[iptt2_ - 1], &ier_);
  if (ier_ != 0) {
    goto _l320;
  }
  lenigp_ = dlss01_.ngp_ + 1;
  _l260:;
  dlss01_.ipr_ = dlss01_.ipigp_ + lenigp_;
  dlss01_.ipc_ = dlss01_.ipr_;
  dlss01_.ipic_ = dlss01_.ipc_ + dls001_.n_;
  dlss01_.ipisp_ = dlss01_.ipic_ + dls001_.n_;
  dlss01_.iprsp_ = (dlss01_.ipisp_ - 2) / dlss01_.lrat_ + 2;
  dlss01_.iesp_ = dlss01_.lenwk_ + 1 - dlss01_.iprsp_;
  if (dlss01_.iesp_ < 0) {
    goto _l330;
  }
  ibr_ = dlss01_.ipr_ - 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    iwk_[ibr_ + i_ - 1] = i_;
  }
  dlss01_.nsp_ = liwk_ + 1 - dlss01_.ipisp_;
  (void) _odrv (&dls001_.n_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], wk_, &iwk_[dlss01_.ipr_ - 1], 
  &iwk_[dlss01_.ipic_ - 1], &dlss01_.nsp_, &iwk_[dlss01_.ipisp_ - 1], &_k1, &dlss01_.iys_);
  if (dlss01_.iys_ == 11 * dls001_.n_ + 1) {
    goto _l340;
  }
  if (dlss01_.iys_ != 0) {
    goto _l330;
  }
  dlss01_.ipa_ = dlss01_.lenwk_ + 1 - dlss01_.nnz_;
  dlss01_.nsp_ = dlss01_.ipa_ - dlss01_.iprsp_;
  dlss01_.lreq_ = _max (12 * dls001_.n_ / dlss01_.lrat_, 6 * dls001_.n_ / dlss01_.lrat_ + 2 * dls001_.n_ + dlss01_.nnz_) 
  + 3;
  dlss01_.lreq_ = dlss01_.lreq_ + dlss01_.iprsp_ - 1 + dlss01_.nnz_;
  if (dlss01_.lreq_ > dlss01_.lenwk_) {
    goto _l350;
  }
  dlss01_.iba_ = dlss01_.ipa_ - 1;
  for (i_ = 1; i_ <= dlss01_.nnz_; (i_)++) {
    wk_[dlss01_.iba_ + i_ - 1] = 0.0;
  }
  dlss01_.ipisp_ = dlss01_.lrat_ * (dlss01_.iprsp_ - 1) + 1;
  (void) _cdrv (&dls001_.n_, &iwk_[dlss01_.ipr_ - 1], &iwk_[dlss01_.ipc_ - 1], &iwk_[dlss01_.ipic_ - 1], 
  &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &wk_[dlss01_.ipa_ - 1], &wk_[dlss01_.ipa_ - 1], &wk_[dlss01_.ipa_ 
  - 1], &dlss01_.nsp_, &iwk_[dlss01_.ipisp_ - 1], &wk_[dlss01_.iprsp_ - 1], &dlss01_.iesp_, ($0_ = 5, &$0_), 
  &dlss01_.iys_);
  dlss01_.lreq_ = dlss01_.lenwk_ - dlss01_.iesp_;
  if (dlss01_.iys_ == 10 * dls001_.n_ + 1) {
    goto _l350;
  }
  if (dlss01_.iys_ != 0) {
    goto _l360;
  }
  ipil_ = dlss01_.ipisp_;
  ipiu_ = ipil_ + 2 * dls001_.n_ + 1;
  dlss01_.nzu_ = iwk_[ipil_ + dls001_.n_ - 1] - iwk_[ipil_ - 1];
  dlss01_.nzl_ = iwk_[ipiu_ + dls001_.n_ - 1] - iwk_[ipiu_ - 1];
  if (dlss01_.lrat_ > 1) {
    goto _l290;
  }
  (void) _adjlr (&dls001_.n_, &iwk_[dlss01_.ipisp_ - 1], &ldif_);
  dlss01_.lreq_ = dlss01_.lreq_ + ldif_;
  _l290:;
  if (dlss01_.lrat_ == 2 && dlss01_.nnz_ == dls001_.n_) {
    dlss01_.lreq_ = dlss01_.lreq_ + 1;
  }
  dlss01_.nsp_ = dlss01_.nsp_ + dlss01_.lreq_ - dlss01_.lenwk_;
  dlss01_.ipa_ = dlss01_.lreq_ + 1 - dlss01_.nnz_;
  dlss01_.iba_ = dlss01_.ipa_ - 1;
  (*ipper_) = 0;
  goto _l0;
  _l310:;
  (*ipper_) = -1;
  dlss01_.lreq_ = 2 + (2 * dls001_.n_ + 1) / dlss01_.lrat_;
  dlss01_.lreq_ = _max (dlss01_.lenwk_ + 1, dlss01_.lreq_);
  goto _l0;
  _l320:;
  (*ipper_) = -2;
  dlss01_.lreq_ = (dlss01_.lreq_ - 1) / dlss01_.lrat_ + 1;
  goto _l0;
  _l330:;
  (*ipper_) = -3;
  (void) _cntnzu (&dls001_.n_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &nzsut_);
  dlss01_.lreq_ = dlss01_.lenwk_ - dlss01_.iesp_ + (3 * dls001_.n_ + 4 * nzsut_ - 1) / dlss01_.lrat_ + 1;
  goto _l0;
  _l340:;
  (*ipper_) = -4;
  goto _l0;
  _l350:;
  (*ipper_) = -5;
  goto _l0;
  _l360:;
  (*ipper_) = -6;
  dlss01_.lreq_ = dlss01_.lenwk_;
  goto _l0;
  _l370:;
  (*ipper_) = -ier_ - 5;
  dlss01_.lreq_ = 2 + (2 * dls001_.n_ + 1) / dlss01_.lrat_;
  _l0:;
  __calls[42].calls++;
  return 0;
}

int_4 _dprepj (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ ftem_, real_8 
_p_ savf_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)())
{
  static int_4 i_, i1_, i2_, ier_, ii_, j_, j1_, jj_, lenp_, mba_, mband_, meb1_, meband_, ml_, ml3_, mu_, np1_;
  static real_8 con_, di_, fac_, hl0_, r_, r0_, srur_, yi_, yj_, yjj_;
  dls001_.nje_ = dls001_.nje_ + 1;
  dls001_.ierpj_ = 0;
  dls001_.jcur_ = 1;
  hl0_ = dls001_.h_ * dls001_.el0_;
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l500;
  }
  _l100:;
  lenp_ = dls001_.n_ * dls001_.n_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = 0.0;
  }
  (void) _jac (neq_, &dls001_.tn_, y_, &_k0, &_k0, &wm_[2], &dls001_.n_);
  con_ = -hl0_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = wm_[i_ + 2 - 1] * con_;
  }
  goto _l240;
  _l200:;
  fac_ = _dvnorm (&dls001_.n_, savf_, ewt_);
  r0_ = 1000.0e0 * _abs (dls001_.h_) * dls001_.uround_ * dls001_.n_ * fac_;
  if (r0_ == 0.0e0) {
    r0_ = 1.0;
  }
  srur_ = wm_[0];
  j1_ = 2;
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    yj_ = y_[j_ - 1];
    r_ = _max (srur_ * _abs (yj_), r0_ / ewt_[j_ - 1]);
    y_[j_ - 1] = y_[j_ - 1] + r_;
    fac_ = -hl0_ / r_;
    (void) _f (neq_, &dls001_.tn_, y_, ftem_);
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      wm_[i_ + j1_ - 1] = (ftem_[i_ - 1] - savf_[i_ - 1]) * fac_;
    }
    y_[j_ - 1] = yj_;
    j1_ = j1_ + dls001_.n_;
  }
  dls001_.nfe_ = dls001_.nfe_ + dls001_.n_;
  _l240:;
  j_ = 3;
  np1_ = dls001_.n_ + 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    wm_[j_ - 1] = wm_[j_ - 1] + 1.0e0;
    j_ = j_ + np1_;
  }
  (void) _dgefa (&wm_[2], &dls001_.n_, &dls001_.n_, &iwm_[20], &ier_);
  if (ier_ != 0) {
    dls001_.ierpj_ = 1;
  }
  goto _l0;
  _l300:;
  wm_[1] = hl0_;
  r_ = dls001_.el0_ * 0.1e0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] + r_ * (dls001_.h_ * savf_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((1))]);
  }
  (void) _f (neq_, &dls001_.tn_, y_, &wm_[2]);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    r0_ = dls001_.h_ * savf_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((1))];
    di_ = 0.1e0 * r0_ - dls001_.h_ * (wm_[i_ + 2 - 1] - savf_[i_ - 1]);
    wm_[i_ + 2 - 1] = 1.0;
    if (_abs (r0_) < dls001_.uround_ / ewt_[i_ - 1]) {
      goto _l320;
    }
    if (_abs (di_) == 0.0e0) {
      goto _l330;
    }
    wm_[i_ + 2 - 1] = 0.1e0 * r0_ / di_;
    _l320:;
  }
  goto _l0;
  _l330:;
  dls001_.ierpj_ = 1;
  goto _l0;
  _l400:;
  ml_ = iwm_[0];
  mu_ = iwm_[1];
  ml3_ = ml_ + 3;
  mband_ = ml_ + mu_ + 1;
  meband_ = mband_ + ml_;
  lenp_ = meband_ * dls001_.n_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = 0.0;
  }
  (void) _jac (neq_, &dls001_.tn_, y_, &ml_, &mu_, &wm_[ml3_ - 1], &meband_);
  con_ = -hl0_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = wm_[i_ + 2 - 1] * con_;
  }
  goto _l570;
  _l500:;
  ml_ = iwm_[0];
  mu_ = iwm_[1];
  mband_ = ml_ + mu_ + 1;
  mba_ = _min (mband_, dls001_.n_);
  meband_ = mband_ + ml_;
  meb1_ = meband_ - 1;
  srur_ = wm_[0];
  fac_ = _dvnorm (&dls001_.n_, savf_, ewt_);
  r0_ = 1000.0e0 * _abs (dls001_.h_) * dls001_.uround_ * dls001_.n_ * fac_;
  if (r0_ == 0.0e0) {
    r0_ = 1.0;
  }
  for (j_ = 1; j_ <= mba_; (j_)++) {
    for (i_ = j_; (mband_ > 0 ? i_ <= dls001_.n_ : i_ >= dls001_.n_); i_ += mband_) {
      yi_ = y_[i_ - 1];
      r_ = _max (srur_ * _abs (yi_), r0_ / ewt_[i_ - 1]);
      y_[i_ - 1] = y_[i_ - 1] + r_;
    }
    (void) _f (neq_, &dls001_.tn_, y_, ftem_);
    for (jj_ = j_; (mband_ > 0 ? jj_ <= dls001_.n_ : jj_ >= dls001_.n_); jj_ += mband_) {
      y_[jj_ - 1] = yh_[jj_ - 1 + ((*nyh_)) * ((0))];
      yjj_ = y_[jj_ - 1];
      r_ = _max (srur_ * _abs (yjj_), r0_ / ewt_[jj_ - 1]);
      fac_ = -hl0_ / r_;
      i1_ = _max (jj_ - mu_, 1);
      i2_ = _min (jj_ + ml_, dls001_.n_);
      ii_ = jj_ * meb1_ - ml_ + 2;
      for (i_ = i1_; i_ <= i2_; (i_)++) {
        wm_[ii_ + i_ - 1] = (ftem_[i_ - 1] - savf_[i_ - 1]) * fac_;
      }
    }
  }
  dls001_.nfe_ = dls001_.nfe_ + mba_;
  _l570:;
  ii_ = mband_ + 2;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    wm_[ii_ - 1] = wm_[ii_ - 1] + 1.0e0;
    ii_ = ii_ + meband_;
  }
  (void) _dgbfa (&wm_[2], &meband_, &dls001_.n_, &ml_, &mu_, &iwm_[20], &ier_);
  if (ier_ != 0) {
    dls001_.ierpj_ = 1;
  }
  _l0:;
  __calls[43].calls++;
  return 0;
}
int_4 _dprepji (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ rtem_, 
real_8 _p_ savr_, real_8 _p_ s_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), int_4 (*_jac)(), int_4 (*_adda)())
{
  static int_4 i_, i1_, i2_, ier_, ii_, ires_, j_, j1_, jj_, lenp_, mba_, mband_, meb1_, meband_, ml_, ml3_, mu_;
  static real_8 con_, fac_, hl0_, r_, srur_, yi_, yj_, yjj_;
  dls001_.nje_ = dls001_.nje_ + 1;
  hl0_ = dls001_.h_ * dls001_.el0_;
  dls001_.ierpj_ = 0;
  dls001_.jcur_ = 1;
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l500;
  }
  _l100:;
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  lenp_ = dls001_.n_ * dls001_.n_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = 0.0;
  }
  (void) _jac (neq_, &dls001_.tn_, y_, s_, &_k0, &_k0, &wm_[2], &dls001_.n_);
  con_ = -hl0_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = wm_[i_ + 2 - 1] * con_;
  }
  goto _l240;
  _l200:;
  ires_ = -1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  srur_ = wm_[0];
  j1_ = 2;
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    yj_ = y_[j_ - 1];
    r_ = _max (srur_ * _abs (yj_), 0.01e0 / ewt_[j_ - 1]);
    y_[j_ - 1] = y_[j_ - 1] + r_;
    fac_ = -hl0_ / r_;
    (void) _res (neq_, &dls001_.tn_, y_, s_, rtem_, &ires_);
    dls001_.nfe_ = dls001_.nfe_ + 1;
    if (ires_ > 1) {
      goto _l600;
    }
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      wm_[i_ + j1_ - 1] = (rtem_[i_ - 1] - savr_[i_ - 1]) * fac_;
    }
    y_[j_ - 1] = yj_;
    j1_ = j1_ + dls001_.n_;
  }
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  _l240:;
  (void) _adda (neq_, &dls001_.tn_, y_, &_k0, &_k0, &wm_[2], &dls001_.n_);
  (void) _dgefa (&wm_[2], &dls001_.n_, &dls001_.n_, &iwm_[20], &ier_);
  if (ier_ != 0) {
    dls001_.ierpj_ = 1;
  }
  goto _l0;
  _l300:;
  goto _l0;
  _l400:;
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  ml_ = iwm_[0];
  mu_ = iwm_[1];
  ml3_ = ml_ + 3;
  mband_ = ml_ + mu_ + 1;
  meband_ = mband_ + ml_;
  lenp_ = meband_ * dls001_.n_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = 0.0;
  }
  (void) _jac (neq_, &dls001_.tn_, y_, s_, &ml_, &mu_, &wm_[ml3_ - 1], &meband_);
  con_ = -hl0_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = wm_[i_ + 2 - 1] * con_;
  }
  goto _l570;
  _l500:;
  ires_ = -1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  ml_ = iwm_[0];
  mu_ = iwm_[1];
  ml3_ = ml_ + 3;
  mband_ = ml_ + mu_ + 1;
  mba_ = _min (mband_, dls001_.n_);
  meband_ = mband_ + ml_;
  meb1_ = meband_ - 1;
  srur_ = wm_[0];
  for (j_ = 1; j_ <= mba_; (j_)++) {
    for (i_ = j_; (mband_ > 0 ? i_ <= dls001_.n_ : i_ >= dls001_.n_); i_ += mband_) {
      yi_ = y_[i_ - 1];
      r_ = _max (srur_ * _abs (yi_), 0.01e0 / ewt_[i_ - 1]);
      y_[i_ - 1] = y_[i_ - 1] + r_;
    }
    (void) _res (neq_, &dls001_.tn_, y_, s_, rtem_, &ires_);
    dls001_.nfe_ = dls001_.nfe_ + 1;
    if (ires_ > 1) {
      goto _l600;
    }
    for (jj_ = j_; (mband_ > 0 ? jj_ <= dls001_.n_ : jj_ >= dls001_.n_); jj_ += mband_) {
      y_[jj_ - 1] = yh_[jj_ - 1 + ((*nyh_)) * ((0))];
      yjj_ = y_[jj_ - 1];
      r_ = _max (srur_ * _abs (yjj_), 0.01e0 / ewt_[jj_ - 1]);
      fac_ = -hl0_ / r_;
      i1_ = _max (jj_ - mu_, 1);
      i2_ = _min (jj_ + ml_, dls001_.n_);
      ii_ = jj_ * meb1_ - ml_ + 2;
      for (i_ = i1_; i_ <= i2_; (i_)++) {
        wm_[ii_ + i_ - 1] = (rtem_[i_ - 1] - savr_[i_ - 1]) * fac_;
      }
    }
  }
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  _l570:;
  (void) _adda (neq_, &dls001_.tn_, y_, &ml_, &mu_, &wm_[ml3_ - 1], &meband_);
  (void) _dgbfa (&wm_[2], &meband_, &dls001_.n_, &ml_, &mu_, &iwm_[20], &ier_);
  if (ier_ != 0) {
    dls001_.ierpj_ = 1;
  }
  goto _l0;
  _l600:;
  dls001_.ierpj_ = ires_;
  _l0:;
  __calls[44].calls++;
  return 0;
}

int_4 _dprja (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ ftem_, real_8 
_p_ savf_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)())
{
  static int_4 i_, i1_, i2_, ier_, ii_, j_, j1_, jj_, lenp_, mba_, mband_, meb1_, meband_, ml_, ml3_, mu_, np1_;
  static real_8 con_, fac_, hl0_, r_, r0_, srur_, yi_, yj_, yjj_;
  dls001_.nje_ = dls001_.nje_ + 1;
  dls001_.ierpj_ = 0;
  dls001_.jcur_ = 1;
  hl0_ = dls001_.h_ * dls001_.el0_;
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l500;
  }
  _l100:;
  lenp_ = dls001_.n_ * dls001_.n_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = 0.0;
  }
  (void) _jac (neq_, &dls001_.tn_, y_, &_k0, &_k0, &wm_[2], &dls001_.n_);
  con_ = -hl0_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = wm_[i_ + 2 - 1] * con_;
  }
  goto _l240;
  _l200:;
  fac_ = _dmnorm (&dls001_.n_, savf_, ewt_);
  r0_ = 1000.0e0 * _abs (dls001_.h_) * dls001_.uround_ * dls001_.n_ * fac_;
  if (r0_ == 0.0e0) {
    r0_ = 1.0;
  }
  srur_ = wm_[0];
  j1_ = 2;
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    yj_ = y_[j_ - 1];
    r_ = _max (srur_ * _abs (yj_), r0_ / ewt_[j_ - 1]);
    y_[j_ - 1] = y_[j_ - 1] + r_;
    fac_ = -hl0_ / r_;
    (void) _f (neq_, &dls001_.tn_, y_, ftem_);
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      wm_[i_ + j1_ - 1] = (ftem_[i_ - 1] - savf_[i_ - 1]) * fac_;
    }
    y_[j_ - 1] = yj_;
    j1_ = j1_ + dls001_.n_;
  }
  dls001_.nfe_ = dls001_.nfe_ + dls001_.n_;
  _l240:;
  dlsa01_.pdnorm_ = _dfnorm (&dls001_.n_, &wm_[2], ewt_) / _abs (hl0_);
  j_ = 3;
  np1_ = dls001_.n_ + 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    wm_[j_ - 1] = wm_[j_ - 1] + 1.0e0;
    j_ = j_ + np1_;
  }
  (void) _dgefa (&wm_[2], &dls001_.n_, &dls001_.n_, &iwm_[20], &ier_);
  if (ier_ != 0) {
    dls001_.ierpj_ = 1;
  }
  goto _l0;
  _l300:;
  goto _l0;
  _l400:;
  ml_ = iwm_[0];
  mu_ = iwm_[1];
  ml3_ = ml_ + 3;
  mband_ = ml_ + mu_ + 1;
  meband_ = mband_ + ml_;
  lenp_ = meband_ * dls001_.n_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = 0.0;
  }
  (void) _jac (neq_, &dls001_.tn_, y_, &ml_, &mu_, &wm_[ml3_ - 1], &meband_);
  con_ = -hl0_;
  for (i_ = 1; i_ <= lenp_; (i_)++) {
    wm_[i_ + 2 - 1] = wm_[i_ + 2 - 1] * con_;
  }
  goto _l570;
  _l500:;
  ml_ = iwm_[0];
  mu_ = iwm_[1];
  mband_ = ml_ + mu_ + 1;
  mba_ = _min (mband_, dls001_.n_);
  meband_ = mband_ + ml_;
  meb1_ = meband_ - 1;
  srur_ = wm_[0];
  fac_ = _dmnorm (&dls001_.n_, savf_, ewt_);
  r0_ = 1000.0e0 * _abs (dls001_.h_) * dls001_.uround_ * dls001_.n_ * fac_;
  if (r0_ == 0.0e0) {
    r0_ = 1.0;
  }
  for (j_ = 1; j_ <= mba_; (j_)++) {
    for (i_ = j_; (mband_ > 0 ? i_ <= dls001_.n_ : i_ >= dls001_.n_); i_ += mband_) {
      yi_ = y_[i_ - 1];
      r_ = _max (srur_ * _abs (yi_), r0_ / ewt_[i_ - 1]);
      y_[i_ - 1] = y_[i_ - 1] + r_;
    }
    (void) _f (neq_, &dls001_.tn_, y_, ftem_);
    for (jj_ = j_; (mband_ > 0 ? jj_ <= dls001_.n_ : jj_ >= dls001_.n_); jj_ += mband_) {
      y_[jj_ - 1] = yh_[jj_ - 1 + ((*nyh_)) * ((0))];
      yjj_ = y_[jj_ - 1];
      r_ = _max (srur_ * _abs (yjj_), r0_ / ewt_[jj_ - 1]);
      fac_ = -hl0_ / r_;
      i1_ = _max (jj_ - mu_, 1);
      i2_ = _min (jj_ + ml_, dls001_.n_);
      ii_ = jj_ * meb1_ - ml_ + 2;
      for (i_ = i1_; i_ <= i2_; (i_)++) {
        wm_[ii_ + i_ - 1] = (ftem_[i_ - 1] - savf_[i_ - 1]) * fac_;
      }
    }
  }
  dls001_.nfe_ = dls001_.nfe_ + mba_;
  _l570:;
  dlsa01_.pdnorm_ = _dbnorm (&dls001_.n_, &wm_[ml_ + 3 - 1], &meband_, &ml_, &mu_, ewt_) / _abs (hl0_);
  ii_ = mband_ + 2;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    wm_[ii_ - 1] = wm_[ii_ - 1] + 1.0e0;
    ii_ = ii_ + meband_;
  }
  (void) _dgbfa (&wm_[2], &meband_, &dls001_.n_, &ml_, &mu_, &iwm_[20], &ier_);
  if (ier_ != 0) {
    dls001_.ierpj_ = 1;
  }
  _l0:;
  __calls[45].calls++;
  return 0;
}

int_4 _dprjis (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ rtem_, real_8 
_p_ savr_, real_8 _p_ s_, real_8 _p_ wk_, int_4 _p_ iwk_, int_4 (*_res)(), int_4 (*_jac)(), int_4 (*_adda)())
{
  static int_4 i_, imul_, ires_, j_, jj_, jmax_, jmin_, k_, kmax_, kmin_, ng_;
  static real_8 con_, fac_, hl0_, r_, srur_;
  int_4 $0_;
  hl0_ = dls001_.h_ * dls001_.el0_;
  con_ = -hl0_;
  dls001_.jcur_ = 1;
  dls001_.nje_ = dls001_.nje_ + 1;
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
  }
  _l100:;
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  kmin_ = iwk_[dlss01_.ipian_ - 1];
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    kmax_ = iwk_[dlss01_.ipian_ + j_ - 1] - 1;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      rtem_[i_ - 1] = 0.0;
    }
    (void) _jac (neq_, &dls001_.tn_, y_, s_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], rtem_);
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      rtem_[i_ - 1] = rtem_[i_ - 1] * con_;
    }
    (void) _adda (neq_, &dls001_.tn_, y_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], rtem_);
    for (k_ = kmin_; k_ <= kmax_; (k_)++) {
      i_ = iwk_[dlss01_.ibjan_ + k_ - 1];
      wk_[dlss01_.iba_ + k_ - 1] = rtem_[i_ - 1];
    }
    kmin_ = kmax_ + 1;
  }
  goto _l290;
  _l200:;
  ires_ = -1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  srur_ = wk_[0];
  jmin_ = iwk_[dlss01_.ipigp_ - 1];
  for (ng_ = 1; ng_ <= dlss01_.ngp_; (ng_)++) {
    jmax_ = iwk_[dlss01_.ipigp_ + ng_ - 1] - 1;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      jj_ = iwk_[dlss01_.ibjgp_ + j_ - 1];
      r_ = _max (srur_ * _abs (y_[jj_ - 1]), 0.01e0 / ewt_[jj_ - 1]);
      y_[jj_ - 1] = y_[jj_ - 1] + r_;
    }
    (void) _res (neq_, &dls001_.tn_, y_, s_, rtem_, &ires_);
    dls001_.nfe_ = dls001_.nfe_ + 1;
    if (ires_ > 1) {
      goto _l600;
    }
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      jj_ = iwk_[dlss01_.ibjgp_ + j_ - 1];
      y_[jj_ - 1] = yh_[jj_ - 1 + ((*nyh_)) * ((0))];
      r_ = _max (srur_ * _abs (y_[jj_ - 1]), 0.01e0 / ewt_[jj_ - 1]);
      fac_ = -hl0_ / r_;
      kmin_ = iwk_[dlss01_.ibian_ + jj_ - 1];
      kmax_ = iwk_[dlss01_.ibian_ + jj_ + 1 - 1] - 1;
      for (k_ = kmin_; k_ <= kmax_; (k_)++) {
        i_ = iwk_[dlss01_.ibjan_ + k_ - 1];
        rtem_[i_ - 1] = (rtem_[i_ - 1] - savr_[i_ - 1]) * fac_;
      }
      (void) _adda (neq_, &dls001_.tn_, y_, &jj_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], rtem_);
      for (k_ = kmin_; k_ <= kmax_; (k_)++) {
        i_ = iwk_[dlss01_.ibjan_ + k_ - 1];
        wk_[dlss01_.iba_ + k_ - 1] = rtem_[i_ - 1];
      }
    }
    jmin_ = jmax_ + 1;
  }
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, s_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (ires_ > 1) {
    goto _l600;
  }
  _l290:;
  dlss01_.nlu_ = dlss01_.nlu_ + 1;
  dls001_.ierpj_ = 0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    rtem_[i_ - 1] = 0.0;
  }
  (void) _cdrv (&dls001_.n_, &iwk_[dlss01_.ipr_ - 1], &iwk_[dlss01_.ipc_ - 1], &iwk_[dlss01_.ipic_ - 1], 
  &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &wk_[dlss01_.ipa_ - 1], rtem_, rtem_, &dlss01_.nsp_, 
  &iwk_[dlss01_.ipisp_ - 1], &wk_[dlss01_.iprsp_ - 1], &dlss01_.iesp_, ($0_ = 2, &$0_), &dlss01_.iys_);
  if (dlss01_.iys_ == 0) {
    goto _l0;
  }
  imul_ = (dlss01_.iys_ - 1) / dls001_.n_;
  dls001_.ierpj_ = -2;
  if (imul_ == 8) {
    dls001_.ierpj_ = 1;
  }
  if (imul_ == 10) {
    dls001_.ierpj_ = -1;
  }
  goto _l0;
  _l600:;
  dls001_.ierpj_ = ires_;
  _l0:;
  __calls[46].calls++;
  return 0;
}

int_4 _dprjs (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ ewt_, real_8 _p_ ftem_, real_8 
_p_ savf_, real_8 _p_ wk_, int_4 _p_ iwk_, int_4 (*_f)(), int_4 (*_jac)())
{
  static int_4 i_, imul_, j_, jj_, jok_, jmax_, jmin_, k_, kmax_, kmin_, ng_;
  static real_8 con_, di_, fac_, hl0_, pij_, r_, r0_, rcon_, rcont_, srur_;
  int_4 $0_;
  hl0_ = dls001_.h_ * dls001_.el0_;
  con_ = -hl0_;
  if (dls001_.miter_ == 3) {
    goto _l300;
  }
  jok_ = 1;
  if (dls001_.nst_ == 0 || dls001_.nst_ >= dlss01_.nslj_ + dlss01_.msbj_) {
    jok_ = 0;
  }
  if (dls001_.icf_ == 1 && _abs (dls001_.rc_ - 1.0e0) < dlss01_.ccmxj_) {
    jok_ = 0;
  }
  if (dls001_.icf_ == 2) {
    jok_ = 0;
  }
  if (jok_ == 1) {
    goto _l250;
  }
  _l20:;
  dls001_.jcur_ = 1;
  dls001_.nje_ = dls001_.nje_ + 1;
  dlss01_.nslj_ = dls001_.nst_;
  dlss01_.iplost_ = 0;
  dlss01_.conmin_ = _abs (con_);
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
  }
  _l100:;
  kmin_ = iwk_[dlss01_.ipian_ - 1];
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    kmax_ = iwk_[dlss01_.ipian_ + j_ - 1] - 1;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      ftem_[i_ - 1] = 0.0;
    }
    (void) _jac (neq_, &dls001_.tn_, y_, &j_, &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], ftem_);
    for (k_ = kmin_; k_ <= kmax_; (k_)++) {
      i_ = iwk_[dlss01_.ibjan_ + k_ - 1];
      wk_[dlss01_.iba_ + k_ - 1] = ftem_[i_ - 1] * con_;
      if (i_ == j_) {
        wk_[dlss01_.iba_ + k_ - 1] = wk_[dlss01_.iba_ + k_ - 1] + 1.0e0;
      }
    }
    kmin_ = kmax_ + 1;
  }
  goto _l290;
  _l200:;
  fac_ = _dvnorm (&dls001_.n_, savf_, ewt_);
  r0_ = 1000.0e0 * _abs (dls001_.h_) * dls001_.uround_ * dls001_.n_ * fac_;
  if (r0_ == 0.0e0) {
    r0_ = 1.0;
  }
  srur_ = wk_[0];
  jmin_ = iwk_[dlss01_.ipigp_ - 1];
  for (ng_ = 1; ng_ <= dlss01_.ngp_; (ng_)++) {
    jmax_ = iwk_[dlss01_.ipigp_ + ng_ - 1] - 1;
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      jj_ = iwk_[dlss01_.ibjgp_ + j_ - 1];
      r_ = _max (srur_ * _abs (y_[jj_ - 1]), r0_ / ewt_[jj_ - 1]);
      y_[jj_ - 1] = y_[jj_ - 1] + r_;
    }
    (void) _f (neq_, &dls001_.tn_, y_, ftem_);
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      jj_ = iwk_[dlss01_.ibjgp_ + j_ - 1];
      y_[jj_ - 1] = yh_[jj_ - 1 + ((*nyh_)) * ((0))];
      r_ = _max (srur_ * _abs (y_[jj_ - 1]), r0_ / ewt_[jj_ - 1]);
      fac_ = -hl0_ / r_;
      kmin_ = iwk_[dlss01_.ibian_ + jj_ - 1];
      kmax_ = iwk_[dlss01_.ibian_ + jj_ + 1 - 1] - 1;
      for (k_ = kmin_; k_ <= kmax_; (k_)++) {
        i_ = iwk_[dlss01_.ibjan_ + k_ - 1];
        wk_[dlss01_.iba_ + k_ - 1] = (ftem_[i_ - 1] - savf_[i_ - 1]) * fac_;
        if (i_ == jj_) {
          wk_[dlss01_.iba_ + k_ - 1] = wk_[dlss01_.iba_ + k_ - 1] + 1.0e0;
        }
      }
    }
    jmin_ = jmax_ + 1;
  }
  dls001_.nfe_ = dls001_.nfe_ + dlss01_.ngp_;
  goto _l290;
  _l250:;
  dls001_.jcur_ = 0;
  rcon_ = con_ / dlss01_.con0_;
  rcont_ = _abs (con_) / dlss01_.conmin_;
  if (rcont_ > dlss01_.rbig_ && dlss01_.iplost_ == 1) {
    goto _l20;
  }
  kmin_ = iwk_[dlss01_.ipian_ - 1];
  for (j_ = 1; j_ <= dls001_.n_; (j_)++) {
    kmax_ = iwk_[dlss01_.ipian_ + j_ - 1] - 1;
    for (k_ = kmin_; k_ <= kmax_; (k_)++) {
      i_ = iwk_[dlss01_.ibjan_ + k_ - 1];
      pij_ = wk_[dlss01_.iba_ + k_ - 1];
      if (i_ != j_) {
        goto _l260;
      }
      pij_ = pij_ - 1.0e0;
      if (_abs (pij_) >= dlss01_.psmall_) {
        goto _l260;
      }
      dlss01_.iplost_ = 1;
      dlss01_.conmin_ = _min (_abs (dlss01_.con0_), dlss01_.conmin_);
      _l260:;
      pij_ = pij_ * rcon_;
      if (i_ == j_) {
        pij_ = pij_ + 1.0e0;
      }
      wk_[dlss01_.iba_ + k_ - 1] = pij_;
    }
    kmin_ = kmax_ + 1;
  }
  _l290:;
  dlss01_.nlu_ = dlss01_.nlu_ + 1;
  dlss01_.con0_ = con_;
  dls001_.ierpj_ = 0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    ftem_[i_ - 1] = 0.0;
  }
  (void) _cdrv (&dls001_.n_, &iwk_[dlss01_.ipr_ - 1], &iwk_[dlss01_.ipc_ - 1], &iwk_[dlss01_.ipic_ - 1], 
  &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &wk_[dlss01_.ipa_ - 1], ftem_, ftem_, &dlss01_.nsp_, 
  &iwk_[dlss01_.ipisp_ - 1], &wk_[dlss01_.iprsp_ - 1], &dlss01_.iesp_, ($0_ = 2, &$0_), &dlss01_.iys_);
  if (dlss01_.iys_ == 0) {
    goto _l0;
  }
  imul_ = (dlss01_.iys_ - 1) / dls001_.n_;
  dls001_.ierpj_ = -2;
  if (imul_ == 8) {
    dls001_.ierpj_ = 1;
  }
  if (imul_ == 10) {
    dls001_.ierpj_ = -1;
  }
  goto _l0;
  _l300:;
  dls001_.jcur_ = 1;
  dls001_.nje_ = dls001_.nje_ + 1;
  wk_[1] = hl0_;
  dls001_.ierpj_ = 0;
  r_ = dls001_.el0_ * 0.1e0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] + r_ * (dls001_.h_ * savf_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((1))]);
  }
  (void) _f (neq_, &dls001_.tn_, y_, &wk_[2]);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    r0_ = dls001_.h_ * savf_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((1))];
    di_ = 0.1e0 * r0_ - dls001_.h_ * (wk_[i_ + 2 - 1] - savf_[i_ - 1]);
    wk_[i_ + 2 - 1] = 1.0;
    if (_abs (r0_) < dls001_.uround_ / ewt_[i_ - 1]) {
      goto _l320;
    }
    if (_abs (di_) == 0.0e0) {
      goto _l330;
    }
    wk_[i_ + 2 - 1] = 0.1e0 * r0_ / di_;
    _l320:;
  }
  goto _l0;
  _l330:;
  dls001_.ierpj_ = 2;
  _l0:;
  __calls[47].calls++;
  return 0;
}

int_4 _drchek (int_4 _p_ job_, int_4 (*_g)(), int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ 
g0_, real_8 _p_ g1_, real_8 _p_ gx_, int_4 _p_ jroot_, int_4 _p_ irt_)
{
  static int_4 i_, iflag_, jflag_;
  static logical_4 zroot_;
  static real_8 hming_, t1_, temp1_, temp2_, x_;
  (*irt_) = 0;
  for (i_ = 1; i_ <= dlsr01_.ngc_; (i_)++) {
    jroot_[i_ - 1] = 0;
  }
  hming_ = (_abs (dls001_.tn_) + _abs (dls001_.h_)) * dls001_.uround_ * 100.0e0;
  switch ((*job_)) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
    case 3: goto _l300;
  }
  _l100:;
  dlsr01_.t0_ = dls001_.tn_;
  (void) _g (neq_, &dlsr01_.t0_, y_, &dlsr01_.ngc_, g0_);
  dlsr01_.nge_ = 1;
  zroot_ = FALSE;
  for (i_ = 1; i_ <= dlsr01_.ngc_; (i_)++) {
    if (_abs (g0_[i_ - 1]) <= 0.0e0) {
      zroot_ = TRUE;
    }
  }
  if (! (zroot_)) {
    goto _l190;
  }
  temp2_ = _max (hming_ / _abs (dls001_.h_), 0.1);
  temp1_ = temp2_ * dls001_.h_;
  dlsr01_.t0_ = dlsr01_.t0_ + temp1_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] + temp2_ * yh_[i_ - 1 + ((*nyh_)) * ((1))];
  }
  (void) _g (neq_, &dlsr01_.t0_, y_, &dlsr01_.ngc_, g0_);
  dlsr01_.nge_ = dlsr01_.nge_ + 1;
  zroot_ = FALSE;
  for (i_ = 1; i_ <= dlsr01_.ngc_; (i_)++) {
    if (_abs (g0_[i_ - 1]) <= 0.0e0) {
      zroot_ = TRUE;
    }
  }
  if (! (zroot_)) {
    goto _l190;
  }
  (*irt_) = -1;
  goto _l0;
  _l190:;
  goto _l0;
  _l200:;
  if (dlsr01_.irfnd_ == 0) {
    goto _l260;
  }
  (void) _dintdy (&dlsr01_.t0_, &_k0, yh_, nyh_, y_, &iflag_);
  (void) _g (neq_, &dlsr01_.t0_, y_, &dlsr01_.ngc_, g0_);
  dlsr01_.nge_ = dlsr01_.nge_ + 1;
  zroot_ = FALSE;
  for (i_ = 1; i_ <= dlsr01_.ngc_; (i_)++) {
    if (_abs (g0_[i_ - 1]) <= 0.0e0) {
      zroot_ = TRUE;
    }
  }
  if (! (zroot_)) {
    goto _l260;
  }
  temp1_ = _sign (hming_, dls001_.h_);
  dlsr01_.t0_ = dlsr01_.t0_ + temp1_;
  if ((dlsr01_.t0_ - dls001_.tn_) * dls001_.h_ < 0.0e0) {
    goto _l230;
  }
  temp2_ = temp1_ / dls001_.h_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] + temp2_ * yh_[i_ - 1 + ((*nyh_)) * ((1))];
  }
  goto _l240;
  _l230:;
  (void) _dintdy (&dlsr01_.t0_, &_k0, yh_, nyh_, y_, &iflag_);
  _l240:;
  (void) _g (neq_, &dlsr01_.t0_, y_, &dlsr01_.ngc_, g0_);
  dlsr01_.nge_ = dlsr01_.nge_ + 1;
  zroot_ = FALSE;
  for (i_ = 1; i_ <= dlsr01_.ngc_; (i_)++) {
    if (_abs (g0_[i_ - 1]) > 0.0e0) {
      goto _l250;
    }
    jroot_[i_ - 1] = 1;
    zroot_ = TRUE;
    _l250:;
  }
  if (! (zroot_)) {
    goto _l260;
  }
  (*irt_) = 1;
  goto _l0;
  _l260:;
  if (dls001_.tn_ == dlsr01_.tlast_) {
    goto _l390;
  }
  _l300:;
  if (dlsr01_.itaskc_ == 2 || dlsr01_.itaskc_ == 3 || dlsr01_.itaskc_ == 5) {
    goto _l310;
  }
  if ((dlsr01_.toutc_ - dls001_.tn_) * dls001_.h_ >= 0.0e0) {
    goto _l310;
  }
  t1_ = dlsr01_.toutc_;
  if ((t1_ - dlsr01_.t0_) * dls001_.h_ <= 0.0e0) {
    goto _l390;
  }
  (void) _dintdy (&t1_, &_k0, yh_, nyh_, y_, &iflag_);
  goto _l330;
  _l310:;
  t1_ = dls001_.tn_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  _l330:;
  (void) _g (neq_, &t1_, y_, &dlsr01_.ngc_, g1_);
  dlsr01_.nge_ = dlsr01_.nge_ + 1;
  jflag_ = 0;
  _l350:;
  (void) _droots (&dlsr01_.ngc_, &hming_, &jflag_, &dlsr01_.t0_, &t1_, g0_, g1_, gx_, &x_, jroot_);
  if (jflag_ > 1) {
    goto _l360;
  }
  (void) _dintdy (&x_, &_k0, yh_, nyh_, y_, &iflag_);
  (void) _g (neq_, &x_, y_, &dlsr01_.ngc_, gx_);
  dlsr01_.nge_ = dlsr01_.nge_ + 1;
  goto _l350;
  _l360:;
  dlsr01_.t0_ = x_;
  (void) _dcopy (&dlsr01_.ngc_, gx_, &_k1, g0_, &_k1);
  if (jflag_ == 4) {
    goto _l390;
  }
  (void) _dintdy (&x_, &_k0, yh_, nyh_, y_, &iflag_);
  (*irt_) = 1;
  goto _l0;
  _l390:;
  _l0:;
  __calls[48].calls++;
  return 0;
}

int_4 _droots (int_4 _p_ ng_, real_8 _p_ hmin_, int_4 _p_ jflag_, real_8 _p_ x0_, real_8 _p_ x1_, real_8 _p_ g0_, 
real_8 _p_ g1_, real_8 _p_ gx_, real_8 _p_ x_, int_4 _p_ jroot_)
{
  static int_4 i_, imxold_, nxlast_;
  static logical_4 zroot_, sgnchg_, xroot_;
  static real_8 t2_, tmax_, fracint_, fracsub_, zero_, half_, tenth_, five_;
  int_4 _data_k_34, _data_k_35, _data_k_36, _data_k_37;
#define _data_n_34 1
  static real_8 _data_l_34[_data_n_34] = {
    0.0e0
  };
#define _data_n_35 1
  static real_8 _data_l_35[_data_n_35] = {
    0.5e0
  };
#define _data_n_36 1
  static real_8 _data_l_36[_data_n_36] = {
    0.1e0
  };
#define _data_n_37 1
  static real_8 _data_l_37[_data_n_37] = {
    5.0e0
  };
  if (__calls[49].calls == 0) {
    _data_k_34 = 0;
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    zero_ = _data_l_34[_data_k_34++];
    _data_k_35 = 0;
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    half_ = _data_l_35[_data_k_35++];
    _data_k_36 = 0;
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    tenth_ = _data_l_36[_data_k_36++];
    _data_k_37 = 0;
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    five_ = _data_l_37[_data_k_37++];
  }
  if ((*jflag_) == 1) {
    goto _l200;
  }
  dlsr01_.imax_ = 0;
  tmax_ = zero_;
  zroot_ = FALSE;
  for (i_ = 1; i_ <= (*ng_); (i_)++) {
    if (_abs (g1_[i_ - 1]) > zero_) {
      goto _l110;
    }
    zroot_ = TRUE;
    goto _l120;
    _l110:;
    if (_sign (1.0, g0_[i_ - 1]) == _sign (1.0, g1_[i_ - 1])) {
      goto _l120;
    }
    t2_ = _abs (g1_[i_ - 1] / (g1_[i_ - 1] - g0_[i_ - 1]));
    if (t2_ <= tmax_) {
      goto _l120;
    }
    tmax_ = t2_;
    dlsr01_.imax_ = i_;
    _l120:;
  }
  if (dlsr01_.imax_ > 0) {
    goto _l130;
  }
  sgnchg_ = FALSE;
  goto _l140;
  _l130:;
  sgnchg_ = TRUE;
  _l140:;
  if (! (sgnchg_)) {
    goto _l400;
  }
  xroot_ = FALSE;
  nxlast_ = 0;
  dlsr01_.last_ = 1;
  _l150:;
  if (xroot_) {
    goto _l300;
  }
  if (nxlast_ == dlsr01_.last_) {
    goto _l160;
  }
  dlsr01_.alpha_ = 1.0;
  goto _l180;
  _l160:;
  if (dlsr01_.last_ == 0) {
    goto _l170;
  }
  dlsr01_.alpha_ = 0.5e0 * dlsr01_.alpha_;
  goto _l180;
  _l170:;
  dlsr01_.alpha_ = 2.0e0 * dlsr01_.alpha_;
  _l180:;
  dlsr01_.x2_ = (*x1_) - ((*x1_) - (*x0_)) * g1_[dlsr01_.imax_ - 1] / (g1_[dlsr01_.imax_ - 1] - dlsr01_.alpha_ * 
  g0_[dlsr01_.imax_ - 1]);
  if (_abs (dlsr01_.x2_ - (*x0_)) < half_ * (*hmin_)) {
    fracint_ = _abs ((*x1_) - (*x0_)) / (*hmin_);
    fracsub_ = tenth_;
    if (fracint_ <= five_) {
      fracsub_ = half_ / fracint_;
    }
    dlsr01_.x2_ = (*x0_) + fracsub_ * ((*x1_) - (*x0_));
  }
  if (_abs ((*x1_) - dlsr01_.x2_) < half_ * (*hmin_)) {
    fracint_ = _abs ((*x1_) - (*x0_)) / (*hmin_);
    fracsub_ = tenth_;
    if (fracint_ <= five_) {
      fracsub_ = half_ / fracint_;
    }
    dlsr01_.x2_ = (*x1_) - fracsub_ * ((*x1_) - (*x0_));
  }
  (*jflag_) = 1;
  (*x_) = dlsr01_.x2_;
  goto _l0;
  _l200:;
  imxold_ = dlsr01_.imax_;
  dlsr01_.imax_ = 0;
  tmax_ = zero_;
  zroot_ = FALSE;
  for (i_ = 1; i_ <= (*ng_); (i_)++) {
    if (_abs (gx_[i_ - 1]) > zero_) {
      goto _l210;
    }
    zroot_ = TRUE;
    goto _l220;
    _l210:;
    if (_sign (1.0, g0_[i_ - 1]) == _sign (1.0, gx_[i_ - 1])) {
      goto _l220;
    }
    t2_ = _abs (gx_[i_ - 1] / (gx_[i_ - 1] - g0_[i_ - 1]));
    if (t2_ <= tmax_) {
      goto _l220;
    }
    tmax_ = t2_;
    dlsr01_.imax_ = i_;
    _l220:;
  }
  if (dlsr01_.imax_ > 0) {
    goto _l230;
  }
  sgnchg_ = FALSE;
  dlsr01_.imax_ = imxold_;
  goto _l240;
  _l230:;
  sgnchg_ = TRUE;
  _l240:;
  nxlast_ = dlsr01_.last_;
  if (! (sgnchg_)) {
    goto _l250;
  }
  (*x1_) = dlsr01_.x2_;
  (void) _dcopy (ng_, gx_, &_k1, g1_, &_k1);
  dlsr01_.last_ = 1;
  xroot_ = FALSE;
  goto _l270;
  _l250:;
  if (! (zroot_)) {
    goto _l260;
  }
  (*x1_) = dlsr01_.x2_;
  (void) _dcopy (ng_, gx_, &_k1, g1_, &_k1);
  xroot_ = TRUE;
  goto _l270;
  _l260:;
  (void) _dcopy (ng_, gx_, &_k1, g0_, &_k1);
  (*x0_) = dlsr01_.x2_;
  dlsr01_.last_ = 0;
  xroot_ = FALSE;
  _l270:;
  if (_abs ((*x1_) - (*x0_)) <= (*hmin_)) {
    xroot_ = TRUE;
  }
  goto _l150;
  _l300:;
  (*jflag_) = 2;
  (*x_) = (*x1_);
  (void) _dcopy (ng_, g1_, &_k1, gx_, &_k1);
  for (i_ = 1; i_ <= (*ng_); (i_)++) {
    jroot_[i_ - 1] = 0;
    if (_abs (g1_[i_ - 1]) > zero_) {
      goto _l310;
    }
    jroot_[i_ - 1] = 1;
    goto _l320;
    _l310:;
    if (_sign (1.0, g0_[i_ - 1]) != _sign (1.0, g1_[i_ - 1])) {
      jroot_[i_ - 1] = 1;
    }
    _l320:;
  }
  goto _l0;
  _l400:;
  if (! (zroot_)) {
    goto _l420;
  }
  (*x_) = (*x1_);
  (void) _dcopy (ng_, g1_, &_k1, gx_, &_k1);
  for (i_ = 1; i_ <= (*ng_); (i_)++) {
    jroot_[i_ - 1] = 0;
    if (_abs (g1_[i_ - 1]) <= zero_) {
      jroot_[i_ - 1] = 1;
    }
  }
  (*jflag_) = 3;
  goto _l0;
  _l420:;
  (void) _dcopy (ng_, g1_, &_k1, gx_, &_k1);
  (*x_) = (*x1_);
  (*jflag_) = 4;
  _l0:;
  __calls[49].calls++;
  return 0;
}

int_4 _dsetpk (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ ysv_, real_8 _p_ ewt_, real_8 _p_ ftem_, real_8 _p_ savf_, 
int_4 _p_ jok_, real_8 _p_ wm_, int_4 _p_ iwm_, real_4 (*_f)(), int_4 (*_jac)())
{
  static int_4 ier_;
  static real_8 hl0_;
  dls001_.ierpj_ = 0;
  dls001_.jcur_ = 0;
  if ((*jok_) == -1) {
    dls001_.jcur_ = 1;
  }
  hl0_ = dls001_.el0_ * dls001_.h_;
  (void) _jac (_f, neq_, &dls001_.tn_, y_, ysv_, ewt_, savf_, ftem_, &hl0_, jok_, &wm_[dlpk01_.locwp_ - 1], 
  &iwm_[dlpk01_.lociwp_ - 1], &ier_);
  dls001_.nje_ = dls001_.nje_ + 1;
  if (ier_ == 0) {
    goto _l0;
  }
  dls001_.ierpj_ = 1;
  _l0:;
  __calls[50].calls++;
  return 0;
}

int_4 _dslsbt (real_8 _p_ wm_, int_4 _p_ iwm_, real_8 _p_ x_, real_8 _p_ tem_)
{
  static int_4 lblox_, lpb_, lpc_, mb_, nb_;
  mb_ = iwm_[0];
  nb_ = iwm_[1];
  lblox_ = mb_ * mb_ * nb_;
  lpb_ = 3 + lblox_;
  lpc_ = lpb_ + lblox_;
  (void) _dsolbt (&mb_, &nb_, &wm_[2], &wm_[lpb_ - 1], &wm_[lpc_ - 1], x_, &iwm_[20]);
  __calls[51].calls++;
  return 0;
}

int_4 _dsolbt (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ y_, int_4 _p_ ip_)
{
  static int_4 nm1_, nm2_, i_, k_, kb_, km1_, kp1_;
  static real_8 dp_;
  extern real_8 _ddot ();
  nm1_ = (*n_) - 1;
  nm2_ = (*n_) - 2;
  (void) _dgesl (a_, m_, m_, ip_, y_, &_k0);
  for (k_ = 2; k_ <= nm1_; (k_)++) {
    km1_ = k_ - 1;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      dp_ = _ddot (m_, &c_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * ((k_ - 1)))], m_, &y_[0 + ((*m_)) * ((km1_ - 1))], &_k1);
      y_[i_ - 1 + ((*m_)) * ((k_ - 1))] = y_[i_ - 1 + ((*m_)) * ((k_ - 1))] - dp_;
    }
    (void) _dgesl (&a_[0 + ((*m_)) * ((0) + ((*m_)) * ((k_ - 1)))], m_, m_, &ip_[0 + ((*m_)) * ((k_ - 1))], &y_[0 + ((*m_)) 
    * ((k_ - 1))], &_k0);
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    dp_ = _ddot (m_, &c_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * (((*n_) - 1)))], m_, &y_[0 + ((*m_)) * ((nm1_ - 1))], &_k1) + 
    _ddot (m_, &b_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * (((*n_) - 1)))], m_, &y_[0 + ((*m_)) * ((nm2_ - 1))], &_k1);
    y_[i_ - 1 + ((*m_)) * (((*n_) - 1))] = y_[i_ - 1 + ((*m_)) * (((*n_) - 1))] - dp_;
  }
  (void) _dgesl (&a_[0 + ((*m_)) * ((0) + ((*m_)) * (((*n_) - 1)))], m_, m_, &ip_[0 + ((*m_)) * (((*n_) - 1))], &y_[0 + 
  ((*m_)) * (((*n_) - 1))], &_k0);
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    kp1_ = k_ + 1;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      dp_ = _ddot (m_, &b_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * ((k_ - 1)))], m_, &y_[0 + ((*m_)) * ((kp1_ - 1))], &_k1);
      y_[i_ - 1 + ((*m_)) * ((k_ - 1))] = y_[i_ - 1 + ((*m_)) * ((k_ - 1))] - dp_;
    }
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    dp_ = _ddot (m_, &c_[i_ - 1 + ((*m_)) * ((0) + ((*m_)) * ((0)))], m_, &y_[0 + ((*m_)) * ((2))], &_k1);
    y_[i_ - 1 + ((*m_)) * ((0))] = y_[i_ - 1 + ((*m_)) * ((0))] - dp_;
  }
  __calls[52].calls++;
  return 0;
}

int_4 _dsolpk (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ x_, real_8 _p_ ewt_, real_8 _p_ wm_, int_4 
_p_ iwm_, real_4 (*_f)(), real_4 (*_psol)())
{
  static int_4 iflag_, lb_, ldl_, lhes_, liom_, lgmr_, lpcg_, lp_, lq_, lr_, lv_, lw_, lwk_, lz_, maxlp1_, npsl_;
  static real_8 delta_, hl0_;
  dls001_.iersl_ = 0;
  hl0_ = dls001_.h_ * dls001_.el0_;
  delta_ = dlpk01_.delt_ * dlpk01_.epcon_;
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l900;
    case 6: goto _l900;
    case 7: goto _l900;
    case 8: goto _l900;
    case 9: goto _l900;
  }
  _l100:;
  lv_ = 1;
  lb_ = lv_ + dls001_.n_ * dlpk01_.maxl_;
  lhes_ = lb_ + dls001_.n_;
  lwk_ = lhes_ + dlpk01_.maxl_ * dlpk01_.maxl_;
  (void) _dcopy (&dls001_.n_, x_, &_k1, &wm_[lb_ - 1], &_k1);
  (void) _dscal (&dls001_.n_, &dlpk01_.rsqrtn_, ewt_, &_k1);
  (void) _dspiom (neq_, &dls001_.tn_, y_, savf_, &wm_[lb_ - 1], ewt_, &dls001_.n_, &dlpk01_.maxl_, &dlpk01_.kmp_, 
  &delta_, &hl0_, &dlpk01_.jpre_, &dlpk01_.mnewt_, _f, _psol, &npsl_, x_, &wm_[lv_ - 1], &wm_[lhes_ - 1], iwm_, &liom_, 
  &wm_[dlpk01_.locwp_ - 1], &iwm_[dlpk01_.lociwp_ - 1], &wm_[lwk_ - 1], &iflag_);
  dlpk01_.nni_ = dlpk01_.nni_ + 1;
  dlpk01_.nli_ = dlpk01_.nli_ + liom_;
  dlpk01_.nps_ = dlpk01_.nps_ + npsl_;
  (void) _dscal (&dls001_.n_, &dlpk01_.sqrtn_, ewt_, &_k1);
  if (iflag_ != 0) {
    dlpk01_.ncfl_ = dlpk01_.ncfl_ + 1;
  }
  if (iflag_ >= 2) {
    dls001_.iersl_ = 1;
  }
  if (iflag_ < 0) {
    dls001_.iersl_ = -1;
  }
  goto _l0;
  _l200:;
  maxlp1_ = dlpk01_.maxl_ + 1;
  lv_ = 1;
  lb_ = lv_ + dls001_.n_ * dlpk01_.maxl_;
  lhes_ = lb_ + dls001_.n_ + 1;
  lq_ = lhes_ + dlpk01_.maxl_ * maxlp1_;
  lwk_ = lq_ + 2 * dlpk01_.maxl_;
  ldl_ = lwk_ + _min (1, dlpk01_.maxl_ - dlpk01_.kmp_) * dls001_.n_;
  (void) _dcopy (&dls001_.n_, x_, &_k1, &wm_[lb_ - 1], &_k1);
  (void) _dscal (&dls001_.n_, &dlpk01_.rsqrtn_, ewt_, &_k1);
  (void) _dspigmr (neq_, &dls001_.tn_, y_, savf_, &wm_[lb_ - 1], ewt_, &dls001_.n_, &dlpk01_.maxl_, &maxlp1_, 
  &dlpk01_.kmp_, &delta_, &hl0_, &dlpk01_.jpre_, &dlpk01_.mnewt_, _f, _psol, &npsl_, x_, &wm_[lv_ - 1], &wm_[lhes_ - 1], 
  &wm_[lq_ - 1], &lgmr_, &wm_[dlpk01_.locwp_ - 1], &iwm_[dlpk01_.lociwp_ - 1], &wm_[lwk_ - 1], &wm_[ldl_ - 1], &iflag_);
  dlpk01_.nni_ = dlpk01_.nni_ + 1;
  dlpk01_.nli_ = dlpk01_.nli_ + lgmr_;
  dlpk01_.nps_ = dlpk01_.nps_ + npsl_;
  (void) _dscal (&dls001_.n_, &dlpk01_.sqrtn_, ewt_, &_k1);
  if (iflag_ != 0) {
    dlpk01_.ncfl_ = dlpk01_.ncfl_ + 1;
  }
  if (iflag_ >= 2) {
    dls001_.iersl_ = 1;
  }
  if (iflag_ < 0) {
    dls001_.iersl_ = -1;
  }
  goto _l0;
  _l300:;
  lr_ = 1;
  lp_ = lr_ + dls001_.n_;
  lw_ = lp_ + dls001_.n_;
  lz_ = lw_ + dls001_.n_;
  lwk_ = lz_ + dls001_.n_;
  (void) _dcopy (&dls001_.n_, x_, &_k1, &wm_[lr_ - 1], &_k1);
  (void) _dpcg (neq_, &dls001_.tn_, y_, savf_, &wm_[lr_ - 1], ewt_, &dls001_.n_, &dlpk01_.maxl_, &delta_, &hl0_, 
  &dlpk01_.jpre_, &dlpk01_.mnewt_, _f, _psol, &npsl_, x_, &wm_[lp_ - 1], &wm_[lw_ - 1], &wm_[lz_ - 1], &lpcg_, 
  &wm_[dlpk01_.locwp_ - 1], &iwm_[dlpk01_.lociwp_ - 1], &wm_[lwk_ - 1], &iflag_);
  dlpk01_.nni_ = dlpk01_.nni_ + 1;
  dlpk01_.nli_ = dlpk01_.nli_ + lpcg_;
  dlpk01_.nps_ = dlpk01_.nps_ + npsl_;
  if (iflag_ != 0) {
    dlpk01_.ncfl_ = dlpk01_.ncfl_ + 1;
  }
  if (iflag_ >= 2) {
    dls001_.iersl_ = 1;
  }
  if (iflag_ < 0) {
    dls001_.iersl_ = -1;
  }
  goto _l0;
  _l400:;
  lr_ = 1;
  lp_ = lr_ + dls001_.n_;
  lw_ = lp_ + dls001_.n_;
  lz_ = lw_ + dls001_.n_;
  lwk_ = lz_ + dls001_.n_;
  (void) _dcopy (&dls001_.n_, x_, &_k1, &wm_[lr_ - 1], &_k1);
  (void) _dpcgs (neq_, &dls001_.tn_, y_, savf_, &wm_[lr_ - 1], ewt_, &dls001_.n_, &dlpk01_.maxl_, &delta_, &hl0_, 
  &dlpk01_.jpre_, &dlpk01_.mnewt_, _f, _psol, &npsl_, x_, &wm_[lp_ - 1], &wm_[lw_ - 1], &wm_[lz_ - 1], &lpcg_, 
  &wm_[dlpk01_.locwp_ - 1], &iwm_[dlpk01_.lociwp_ - 1], &wm_[lwk_ - 1], &iflag_);
  dlpk01_.nni_ = dlpk01_.nni_ + 1;
  dlpk01_.nli_ = dlpk01_.nli_ + lpcg_;
  dlpk01_.nps_ = dlpk01_.nps_ + npsl_;
  if (iflag_ != 0) {
    dlpk01_.ncfl_ = dlpk01_.ncfl_ + 1;
  }
  if (iflag_ >= 2) {
    dls001_.iersl_ = 1;
  }
  if (iflag_ < 0) {
    dls001_.iersl_ = -1;
  }
  goto _l0;
  _l900:;
  lb_ = 1;
  lwk_ = lb_ + dls001_.n_;
  (void) _dcopy (&dls001_.n_, x_, &_k1, &wm_[lb_ - 1], &_k1);
  (void) _dusol (neq_, &dls001_.tn_, y_, savf_, &wm_[lb_ - 1], ewt_, &dls001_.n_, &delta_, &hl0_, &dlpk01_.mnewt_, _psol, 
  &npsl_, x_, &wm_[dlpk01_.locwp_ - 1], &iwm_[dlpk01_.lociwp_ - 1], &wm_[lwk_ - 1], &iflag_);
  dlpk01_.nni_ = dlpk01_.nni_ + 1;
  dlpk01_.nps_ = dlpk01_.nps_ + npsl_;
  if (iflag_ != 0) {
    dlpk01_.ncfl_ = dlpk01_.ncfl_ + 1;
  }
  if (iflag_ == 3) {
    dls001_.iersl_ = 1;
  }
  if (iflag_ < 0) {
    dls001_.iersl_ = -1;
  }
  _l0:;
  __calls[53].calls++;
  return 0;
}

int_4 _dsolss (real_8 _p_ wk_, int_4 _p_ iwk_, real_8 _p_ x_, real_8 _p_ tem_)
{
  static int_4 i_;
  static real_8 di_, hl0_, phl0_, r_;
  int_4 $0_;
  dls001_.iersl_ = 0;
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l100;
    case 3: goto _l300;
  }
  _l100:;
  (void) _cdrv (&dls001_.n_, &iwk_[dlss01_.ipr_ - 1], &iwk_[dlss01_.ipc_ - 1], &iwk_[dlss01_.ipic_ - 1], 
  &iwk_[dlss01_.ipian_ - 1], &iwk_[dlss01_.ipjan_ - 1], &wk_[dlss01_.ipa_ - 1], x_, x_, &dlss01_.nsp_, 
  &iwk_[dlss01_.ipisp_ - 1], &wk_[dlss01_.iprsp_ - 1], &dlss01_.iesp_, ($0_ = 4, &$0_), &dls001_.iersl_);
  if (dls001_.iersl_ != 0) {
    dls001_.iersl_ = -1;
  }
  goto _l0;
  _l300:;
  phl0_ = wk_[1];
  hl0_ = dls001_.h_ * dls001_.el0_;
  wk_[1] = hl0_;
  if (hl0_ == phl0_) {
    goto _l330;
  }
  r_ = hl0_ / phl0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    di_ = 1.0e0 - r_ * (1.0e0 - 1.0e0 / wk_[i_ + 2 - 1]);
    if (_abs (di_) == 0.0e0) {
      goto _l390;
    }
    wk_[i_ + 2 - 1] = 1.0e0 / di_;
  }
  _l330:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    x_[i_ - 1] = wk_[i_ + 2 - 1] * x_[i_ - 1];
  }
  goto _l0;
  _l390:;
  dls001_.iersl_ = 1;
  _l0:;
  __calls[54].calls++;
  return 0;
}

int_4 _dsolsy (real_8 _p_ wm_, int_4 _p_ iwm_, real_8 _p_ x_, real_8 _p_ tem_)
{
  static int_4 i_, meband_, ml_, mu_;
  static real_8 di_, hl0_, phl0_, r_;
  dls001_.iersl_ = 0;
  switch (dls001_.miter_) {
    default:
    case 1: goto _l100;
    case 2: goto _l100;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l400;
  }
  _l100:;
  (void) _dgesl (&wm_[2], &dls001_.n_, &dls001_.n_, &iwm_[20], x_, &_k0);
  goto _l0;
  _l300:;
  phl0_ = wm_[1];
  hl0_ = dls001_.h_ * dls001_.el0_;
  wm_[1] = hl0_;
  if (hl0_ == phl0_) {
    goto _l330;
  }
  r_ = hl0_ / phl0_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    di_ = 1.0e0 - r_ * (1.0e0 - 1.0e0 / wm_[i_ + 2 - 1]);
    if (_abs (di_) == 0.0e0) {
      goto _l390;
    }
    wm_[i_ + 2 - 1] = 1.0e0 / di_;
  }
  _l330:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    x_[i_ - 1] = wm_[i_ + 2 - 1] * x_[i_ - 1];
  }
  goto _l0;
  _l390:;
  dls001_.iersl_ = 1;
  goto _l0;
  _l400:;
  ml_ = iwm_[0];
  mu_ = iwm_[1];
  meband_ = 2 * ml_ + mu_ + 1;
  (void) _dgbsl (&wm_[2], &meband_, &dls001_.n_, &ml_, &mu_, &iwm_[20], x_, &_k0);
  _l0:;
  __calls[55].calls++;
  return 0;
}

int_4 _dspigmr (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ b_, real_8 _p_ wght_, int_4 
_p_ n_, int_4 _p_ maxl_, int_4 _p_ maxlp1_, int_4 _p_ kmp_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ jpre_, int_4 
_p_ mnewt_, real_4 (*_f)(), int_4 (*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 _p_ v_, real_8 _p_ hes_, real_8 
_p_ q_, int_4 _p_ lgmr_, real_8 _p_ wp_, int_4 _p_ iwp_, real_8 _p_ wk_, real_8 _p_ dl_, int_4 _p_ iflag_)
{
  static int_4 i_, ier_, info_, ip1_, i2_, j_, k_, ll_, llp1_;
  static real_8 bnrm_, bnrm0_, c_, dlnrm_, prod_, rho_, s_, snormw_, tem_;
  int_4 $0_;
  extern real_8 _dnrm2 ();
  (*iflag_) = 0;
  (*lgmr_) = 0;
  (*npsl_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    v_[i_ - 1 + ((*n_)) * ((0))] = b_[i_ - 1] * wght_[i_ - 1];
  }
  bnrm0_ = _dnrm2 (n_, v_, &_k1);
  bnrm_ = bnrm0_;
  if (bnrm0_ > (*delta_)) {
    goto _l30;
  }
  if ((*mnewt_) > 0) {
    goto _l20;
  }
  (void) _dcopy (n_, b_, &_k1, x_, &_k1);
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = 0.0;
  }
  goto _l0;
  _l30:;
  ier_ = 0;
  if ((*jpre_) == 0 || (*jpre_) == 2) {
    goto _l55;
  }
  (void) _psol (neq_, tn_, y_, savf_, wk_, hl0_, wp_, iwp_, b_, &_k1, &ier_);
  (*npsl_) = 1;
  if (ier_ != 0) {
    goto _l300;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    v_[i_ - 1 + ((*n_)) * ((0))] = b_[i_ - 1] * wght_[i_ - 1];
  }
  bnrm_ = _dnrm2 (n_, v_, &_k1);
  (*delta_) = (*delta_) * (bnrm_ / bnrm0_);
  _l55:;
  tem_ = 1.0e0 / bnrm_;
  (void) _dscal (n_, &tem_, &v_[0 + ((*n_)) * ((0))], &_k1);
  for (j_ = 1; j_ <= (*maxl_); (j_)++) {
    for (i_ = 1; i_ <= (*maxlp1_); (i_)++) {
      hes_[i_ - 1 + ((*maxlp1_)) * ((j_ - 1))] = 0.0;
    }
  }
  prod_ = 1.0;
  for (ll_ = 1; ll_ <= (*maxl_); (ll_)++) {
    (*lgmr_) = ll_;
    (void) _datv (neq_, y_, savf_, &v_[0 + ((*n_)) * ((ll_ - 1))], wght_, x_, _f, _psol, &v_[0 + ((*n_)) * ((ll_ + 1 - 
    1))], wk_, wp_, iwp_, hl0_, jpre_, &ier_, npsl_);
    if (ier_ != 0) {
      goto _l300;
    }
    (void) _dorthog (&v_[0 + ((*n_)) * ((ll_ + 1 - 1))], v_, hes_, n_, &ll_, maxlp1_, kmp_, &snormw_);
    hes_[ll_ + 1 - 1 + ((*maxlp1_)) * ((ll_ - 1))] = snormw_;
    (void) _dheqr (hes_, maxlp1_, &ll_, q_, &info_, &ll_);
    if (info_ == ll_) {
      goto _l120;
    }
    prod_ = prod_ * q_[2 * ll_ - 1];
    rho_ = _abs (prod_ * bnrm_);
    if ((ll_ > (*kmp_)) && ((*kmp_) < (*maxl_))) {
      if (ll_ == (*kmp_) + 1) {
        (void) _dcopy (n_, &v_[0 + ((*n_)) * ((0))], &_k1, dl_, &_k1);
        for (i_ = 1; i_ <= (*kmp_); (i_)++) {
          ip1_ = i_ + 1;
          i2_ = i_ * 2;
          s_ = q_[i2_ - 1];
          c_ = q_[i2_ - 1 - 1];
          for (k_ = 1; k_ <= (*n_); (k_)++) {
            dl_[k_ - 1] = s_ * dl_[k_ - 1] + c_ * v_[k_ - 1 + ((*n_)) * ((ip1_ - 1))];
          }
        }
      }
      s_ = q_[2 * ll_ - 1];
      c_ = q_[2 * ll_ - 1 - 1] / snormw_;
      llp1_ = ll_ + 1;
      for (k_ = 1; k_ <= (*n_); (k_)++) {
        dl_[k_ - 1] = s_ * dl_[k_ - 1] + c_ * v_[k_ - 1 + ((*n_)) * ((llp1_ - 1))];
      }
      dlnrm_ = _dnrm2 (n_, dl_, &_k1);
      rho_ = rho_ * dlnrm_;
    }
    if (rho_ <= (*delta_)) {
      goto _l200;
    }
    if (ll_ == (*maxl_)) {
      goto _l100;
    }
    tem_ = 1.0e0 / snormw_;
    (void) _dscal (n_, &tem_, &v_[0 + ((*n_)) * ((ll_ + 1 - 1))], &_k1);
  }
  _l100:;
  if (rho_ <= 1.0e0) {
    goto _l150;
  }
  if (rho_ <= bnrm_ && (*mnewt_) == 0) {
    goto _l150;
  }
  _l120:;
  (*iflag_) = 2;
  goto _l0;
  _l150:;
  (*iflag_) = 1;
  _l200:;
  ll_ = (*lgmr_);
  llp1_ = ll_ + 1;
  for (k_ = 1; k_ <= llp1_; (k_)++) {
    b_[k_ - 1] = 0.0;
  }
  b_[0] = bnrm_;
  (void) _dhels (hes_, maxlp1_, &ll_, q_, b_);
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    x_[k_ - 1] = 0.0;
  }
  for (i_ = 1; i_ <= ll_; (i_)++) {
    (void) _daxpy (n_, &b_[i_ - 1], &v_[0 + ((*n_)) * ((i_ - 1))], &_k1, x_, &_k1);
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = x_[i_ - 1] / wght_[i_ - 1];
  }
  if ((*jpre_) <= 1) {
    goto _l0;
  }
  (void) _psol (neq_, tn_, y_, savf_, wk_, hl0_, wp_, iwp_, x_, ($0_ = 2, &$0_), &ier_);
  (*npsl_) = (*npsl_) + 1;
  if (ier_ != 0) {
    goto _l300;
  }
  goto _l0;
  _l300:;
  if (ier_ < 0) {
    (*iflag_) = -1;
  }
  if (ier_ > 0) {
    (*iflag_) = 3;
  }
  _l0:;
  __calls[56].calls++;
  return 0;
}

int_4 _dspiom (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ b_, real_8 _p_ wght_, int_4 
_p_ n_, int_4 _p_ maxl_, int_4 _p_ kmp_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ jpre_, int_4 _p_ mnewt_, real_4 
(*_f)(), int_4 (*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 _p_ v_, real_8 _p_ hes_, int_4 _p_ ipvt_, int_4 _p_ 
liom_, real_8 _p_ wp_, int_4 _p_ iwp_, real_8 _p_ wk_, int_4 _p_ iflag_)
{
  static int_4 i_, ier_, info_, j_, k_, ll_, lm1_;
  static real_8 bnrm_, bnrm0_, prod_, rho_, snormw_, tem_;
  int_4 $0_;
  extern real_8 _dnrm2 ();
  (*iflag_) = 0;
  (*liom_) = 0;
  (*npsl_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    v_[i_ - 1 + ((*n_)) * ((0))] = b_[i_ - 1] * wght_[i_ - 1];
  }
  bnrm0_ = _dnrm2 (n_, v_, &_k1);
  bnrm_ = bnrm0_;
  if (bnrm0_ > (*delta_)) {
    goto _l30;
  }
  if ((*mnewt_) > 0) {
    goto _l20;
  }
  (void) _dcopy (n_, b_, &_k1, x_, &_k1);
  goto _l0;
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = 0.0;
  }
  goto _l0;
  _l30:;
  ier_ = 0;
  if ((*jpre_) == 0 || (*jpre_) == 2) {
    goto _l55;
  }
  (void) _psol (neq_, tn_, y_, savf_, wk_, hl0_, wp_, iwp_, b_, &_k1, &ier_);
  (*npsl_) = 1;
  if (ier_ != 0) {
    goto _l300;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    v_[i_ - 1 + ((*n_)) * ((0))] = b_[i_ - 1] * wght_[i_ - 1];
  }
  bnrm_ = _dnrm2 (n_, v_, &_k1);
  (*delta_) = (*delta_) * (bnrm_ / bnrm0_);
  _l55:;
  tem_ = 1.0e0 / bnrm_;
  (void) _dscal (n_, &tem_, &v_[0 + ((*n_)) * ((0))], &_k1);
  for (j_ = 1; j_ <= (*maxl_); (j_)++) {
    for (i_ = 1; i_ <= (*maxl_); (i_)++) {
      hes_[i_ - 1 + ((*maxl_)) * ((j_ - 1))] = 0.0;
    }
  }
  prod_ = 1.0;
  for (ll_ = 1; ll_ <= (*maxl_); (ll_)++) {
    (*liom_) = ll_;
    (void) _datv (neq_, y_, savf_, &v_[0 + ((*n_)) * ((ll_ - 1))], wght_, x_, _f, _psol, &v_[0 + ((*n_)) * ((ll_ + 1 - 
    1))], wk_, wp_, iwp_, hl0_, jpre_, &ier_, npsl_);
    if (ier_ != 0) {
      goto _l300;
    }
    (void) _dorthog (&v_[0 + ((*n_)) * ((ll_ + 1 - 1))], v_, hes_, n_, &ll_, maxl_, kmp_, &snormw_);
    (void) _dhefa (hes_, maxl_, &ll_, ipvt_, &info_, &ll_);
    lm1_ = ll_ - 1;
    if (ll_ > 1 && ipvt_[lm1_ - 1] == lm1_) {
      prod_ = prod_ * hes_[ll_ - 1 + ((*maxl_)) * ((lm1_ - 1))];
    }
    if (info_ != ll_) {
      goto _l70;
    }
    if (snormw_ == 0.0e0) {
      goto _l120;
    }
    if (ll_ == (*maxl_)) {
      goto _l120;
    }
    goto _l80;
    _l70:;
    rho_ = bnrm_ * snormw_ * _abs (prod_ / hes_[ll_ - 1 + ((*maxl_)) * ((ll_ - 1))]);
    if (rho_ <= (*delta_)) {
      goto _l200;
    }
    if (ll_ == (*maxl_)) {
      goto _l100;
    }
    _l80:;
    hes_[ll_ + 1 - 1 + ((*maxl_)) * ((ll_ - 1))] = snormw_;
    tem_ = 1.0e0 / snormw_;
    (void) _dscal (n_, &tem_, &v_[0 + ((*n_)) * ((ll_ + 1 - 1))], &_k1);
  }
  _l100:;
  if (rho_ <= 1.0e0) {
    goto _l150;
  }
  if (rho_ <= bnrm_ && (*mnewt_) == 0) {
    goto _l150;
  }
  _l120:;
  (*iflag_) = 2;
  goto _l0;
  _l150:;
  (*iflag_) = 1;
  _l200:;
  ll_ = (*liom_);
  for (k_ = 1; k_ <= ll_; (k_)++) {
    b_[k_ - 1] = 0.0;
  }
  b_[0] = bnrm_;
  (void) _dhesl (hes_, maxl_, &ll_, ipvt_, b_);
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    x_[k_ - 1] = 0.0;
  }
  for (i_ = 1; i_ <= ll_; (i_)++) {
    (void) _daxpy (n_, &b_[i_ - 1], &v_[0 + ((*n_)) * ((i_ - 1))], &_k1, x_, &_k1);
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = x_[i_ - 1] / wght_[i_ - 1];
  }
  if ((*jpre_) <= 1) {
    goto _l0;
  }
  (void) _psol (neq_, tn_, y_, savf_, wk_, hl0_, wp_, iwp_, x_, ($0_ = 2, &$0_), &ier_);
  (*npsl_) = (*npsl_) + 1;
  if (ier_ != 0) {
    goto _l300;
  }
  goto _l0;
  _l300:;
  if (ier_ < 0) {
    (*iflag_) = -1;
  }
  if (ier_ > 0) {
    (*iflag_) = 3;
  }
  _l0:;
  __calls[57].calls++;
  return 0;
}

int_4 _dsrcar (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_)
{
  static int_4 i_, ioff_, lenrls_, lenils_, lenrla_, lenila_, lenrlr_, lenilr_;
  int_4 _data_k_38, _data_k_39, _data_k_40, _data_k_41, _data_k_42, _data_k_43;
#define _data_n_38 1
  static int_4 _data_l_38[_data_n_38] = {
    218
  };
#define _data_n_39 1
  static int_4 _data_l_39[_data_n_39] = {
    37
  };
#define _data_n_40 1
  static int_4 _data_l_40[_data_n_40] = {
    22
  };
#define _data_n_41 1
  static int_4 _data_l_41[_data_n_41] = {
    9
  };
#define _data_n_42 1
  static int_4 _data_l_42[_data_n_42] = {
    5
  };
#define _data_n_43 1
  static int_4 _data_l_43[_data_n_43] = {
    9
  };
  if (__calls[58].calls == 0) {
    _data_k_38 = 0;
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    lenrls_ = _data_l_38[_data_k_38++];
    _data_k_39 = 0;
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    lenils_ = _data_l_39[_data_k_39++];
    _data_k_40 = 0;
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    lenrla_ = _data_l_40[_data_k_40++];
    _data_k_41 = 0;
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    lenila_ = _data_l_41[_data_k_41++];
  }
  if (__calls[58].calls == 0) {
    _data_k_42 = 0;
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    lenrlr_ = _data_l_42[_data_k_42++];
    _data_k_43 = 0;
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    lenilr_ = _data_l_43[_data_k_43++];
  }
  if ((*job_) == 2) {
    goto _l100;
  }
  for (i_ = 1; i_ <= lenrls_; (i_)++) {
    rsav_[i_ - 1] = dls001_.rls_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenrla_; (i_)++) {
    rsav_[lenrls_ + i_ - 1] = dlsa01_.rlsa_[i_ - 1];
  }
  ioff_ = lenrls_ + lenrla_;
  for (i_ = 1; i_ <= lenrlr_; (i_)++) {
    rsav_[ioff_ + i_ - 1] = dlsr01_.rlsr_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    isav_[i_ - 1] = dls001_.ils_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenila_; (i_)++) {
    isav_[lenils_ + i_ - 1] = dlsa01_.ilsa_[i_ - 1];
  }
  ioff_ = lenils_ + lenila_;
  for (i_ = 1; i_ <= lenilr_; (i_)++) {
    isav_[ioff_ + i_ - 1] = dlsr01_.ilsr_[i_ - 1];
  }
  goto _l0;
  _l100:;
  for (i_ = 1; i_ <= lenrls_; (i_)++) {
    dls001_.rls_[i_ - 1] = rsav_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenrla_; (i_)++) {
    dlsa01_.rlsa_[i_ - 1] = rsav_[lenrls_ + i_ - 1];
  }
  ioff_ = lenrls_ + lenrla_;
  for (i_ = 1; i_ <= lenrlr_; (i_)++) {
    dlsr01_.rlsr_[i_ - 1] = rsav_[ioff_ + i_ - 1];
  }
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    dls001_.ils_[i_ - 1] = isav_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenila_; (i_)++) {
    dlsa01_.ilsa_[i_ - 1] = isav_[lenils_ + i_ - 1];
  }
  ioff_ = lenils_ + lenila_;
  for (i_ = 1; i_ <= lenilr_; (i_)++) {
    dlsr01_.ilsr_[i_ - 1] = isav_[ioff_ + i_ - 1];
  }
  _l0:;
  __calls[58].calls++;
  return 0;
}

int_4 _dsrckr (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_)
{
  static int_4 i_, ioff_, lenilp_, lenrlp_, lenils_, lenrls_, lenilr_, lenrlr_;
  int_4 _data_k_44, _data_k_45, _data_k_46, _data_k_47, _data_k_48, _data_k_49;
#define _data_n_44 1
  static int_4 _data_l_44[_data_n_44] = {
    218
  };
#define _data_n_45 1
  static int_4 _data_l_45[_data_n_45] = {
    37
  };
#define _data_n_46 1
  static int_4 _data_l_46[_data_n_46] = {
    4
  };
#define _data_n_47 1
  static int_4 _data_l_47[_data_n_47] = {
    13
  };
#define _data_n_48 1
  static int_4 _data_l_48[_data_n_48] = {
    5
  };
#define _data_n_49 1
  static int_4 _data_l_49[_data_n_49] = {
    9
  };
  if (__calls[59].calls == 0) {
    _data_k_44 = 0;
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    lenrls_ = _data_l_44[_data_k_44++];
    _data_k_45 = 0;
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    lenils_ = _data_l_45[_data_k_45++];
    _data_k_46 = 0;
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    lenrlp_ = _data_l_46[_data_k_46++];
    _data_k_47 = 0;
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    lenilp_ = _data_l_47[_data_k_47++];
  }
  if (__calls[59].calls == 0) {
    _data_k_48 = 0;
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    lenrlr_ = _data_l_48[_data_k_48++];
    _data_k_49 = 0;
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    lenilr_ = _data_l_49[_data_k_49++];
  }
  if ((*job_) == 2) {
    goto _l100;
  }
  (void) _dcopy (&lenrls_, dls001_.rls_, &_k1, rsav_, &_k1);
  rsav_[lenrls_ + 1 - 1] = dls002_.rls2_;
  (void) _dcopy (&lenrlr_, dlsr01_.rlsr_, &_k1, &rsav_[lenrls_ + 2 - 1], &_k1);
  (void) _dcopy (&lenrlp_, dlpk01_.rlsp_, &_k1, &rsav_[lenrls_ + lenrlr_ + 2 - 1], &_k1);
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    isav_[i_ - 1] = dls001_.ils_[i_ - 1];
  }
  isav_[lenils_ + 1 - 1] = dls002_.ils2_[0];
  isav_[lenils_ + 2 - 1] = dls002_.ils2_[1];
  isav_[lenils_ + 3 - 1] = dls002_.ils2_[2];
  isav_[lenils_ + 4 - 1] = dls002_.ils2_[3];
  ioff_ = lenils_ + 2;
  for (i_ = 1; i_ <= lenilr_; (i_)++) {
    isav_[ioff_ + i_ - 1] = dlsr01_.ilsr_[i_ - 1];
  }
  ioff_ = ioff_ + lenilr_;
  for (i_ = 1; i_ <= lenilp_; (i_)++) {
    isav_[ioff_ + i_ - 1] = dlpk01_.ilsp_[i_ - 1];
  }
  goto _l0;
  _l100:;
  (void) _dcopy (&lenrls_, rsav_, &_k1, dls001_.rls_, &_k1);
  dls002_.rls2_ = rsav_[lenrls_ + 1 - 1];
  (void) _dcopy (&lenrlr_, &rsav_[lenrls_ + 2 - 1], &_k1, dlsr01_.rlsr_, &_k1);
  (void) _dcopy (&lenrlp_, &rsav_[lenrls_ + lenrlr_ + 2 - 1], &_k1, dlpk01_.rlsp_, &_k1);
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    dls001_.ils_[i_ - 1] = isav_[i_ - 1];
  }
  dls002_.ils2_[0] = isav_[lenils_ + 1 - 1];
  dls002_.ils2_[1] = isav_[lenils_ + 2 - 1];
  dls002_.ils2_[2] = isav_[lenils_ + 3 - 1];
  dls002_.ils2_[3] = isav_[lenils_ + 4 - 1];
  ioff_ = lenils_ + 2;
  for (i_ = 1; i_ <= lenilr_; (i_)++) {
    dlsr01_.ilsr_[i_ - 1] = isav_[ioff_ + i_ - 1];
  }
  ioff_ = ioff_ + lenilr_;
  for (i_ = 1; i_ <= lenilp_; (i_)++) {
    dlpk01_.ilsp_[i_ - 1] = isav_[ioff_ + i_ - 1];
  }
  _l0:;
  __calls[59].calls++;
  return 0;
}

int_4 _dsrcma (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_)
{
  static int_4 i_, lenrls_, lenils_, lenrla_, lenila_;
  int_4 _data_k_50, _data_k_51, _data_k_52, _data_k_53;
#define _data_n_50 1
  static int_4 _data_l_50[_data_n_50] = {
    218
  };
#define _data_n_51 1
  static int_4 _data_l_51[_data_n_51] = {
    37
  };
#define _data_n_52 1
  static int_4 _data_l_52[_data_n_52] = {
    22
  };
#define _data_n_53 1
  static int_4 _data_l_53[_data_n_53] = {
    9
  };
  if (__calls[60].calls == 0) {
    _data_k_50 = 0;
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    lenrls_ = _data_l_50[_data_k_50++];
    _data_k_51 = 0;
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    lenils_ = _data_l_51[_data_k_51++];
    _data_k_52 = 0;
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    lenrla_ = _data_l_52[_data_k_52++];
    _data_k_53 = 0;
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    lenila_ = _data_l_53[_data_k_53++];
  }
  if ((*job_) == 2) {
    goto _l100;
  }
  for (i_ = 1; i_ <= lenrls_; (i_)++) {
    rsav_[i_ - 1] = dls001_.rls_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenrla_; (i_)++) {
    rsav_[lenrls_ + i_ - 1] = dlsa01_.rlsa_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    isav_[i_ - 1] = dls001_.ils_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenila_; (i_)++) {
    isav_[lenils_ + i_ - 1] = dlsa01_.ilsa_[i_ - 1];
  }
  goto _l0;
  _l100:;
  for (i_ = 1; i_ <= lenrls_; (i_)++) {
    dls001_.rls_[i_ - 1] = rsav_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenrla_; (i_)++) {
    dlsa01_.rlsa_[i_ - 1] = rsav_[lenrls_ + i_ - 1];
  }
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    dls001_.ils_[i_ - 1] = isav_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenila_; (i_)++) {
    dlsa01_.ilsa_[i_ - 1] = isav_[lenils_ + i_ - 1];
  }
  _l0:;
  __calls[60].calls++;
  return 0;
}

int_4 _dsrcms (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_)
{
  static int_4 i_, lenils_, leniss_, lenrls_, lenrss_;
  int_4 _data_k_54, _data_k_55, _data_k_56, _data_k_57;
#define _data_n_54 1
  static int_4 _data_l_54[_data_n_54] = {
    218
  };
#define _data_n_55 1
  static int_4 _data_l_55[_data_n_55] = {
    37
  };
#define _data_n_56 1
  static int_4 _data_l_56[_data_n_56] = {
    6
  };
#define _data_n_57 1
  static int_4 _data_l_57[_data_n_57] = {
    34
  };
  if (__calls[61].calls == 0) {
    _data_k_54 = 0;
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    lenrls_ = _data_l_54[_data_k_54++];
    _data_k_55 = 0;
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    lenils_ = _data_l_55[_data_k_55++];
    _data_k_56 = 0;
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    lenrss_ = _data_l_56[_data_k_56++];
    _data_k_57 = 0;
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    leniss_ = _data_l_57[_data_k_57++];
  }
  if ((*job_) == 2) {
    goto _l100;
  }
  for (i_ = 1; i_ <= lenrls_; (i_)++) {
    rsav_[i_ - 1] = dls001_.rls_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenrss_; (i_)++) {
    rsav_[lenrls_ + i_ - 1] = dlss01_.rlss_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    isav_[i_ - 1] = dls001_.ils_[i_ - 1];
  }
  for (i_ = 1; i_ <= leniss_; (i_)++) {
    isav_[lenils_ + i_ - 1] = dlss01_.ilss_[i_ - 1];
  }
  goto _l0;
  _l100:;
  for (i_ = 1; i_ <= lenrls_; (i_)++) {
    dls001_.rls_[i_ - 1] = rsav_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenrss_; (i_)++) {
    dlss01_.rlss_[i_ - 1] = rsav_[lenrls_ + i_ - 1];
  }
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    dls001_.ils_[i_ - 1] = isav_[i_ - 1];
  }
  for (i_ = 1; i_ <= leniss_; (i_)++) {
    dlss01_.ilss_[i_ - 1] = isav_[lenils_ + i_ - 1];
  }
  _l0:;
  __calls[61].calls++;
  return 0;
}

int_4 _dsrcom (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_)
{
  static int_4 i_, lenils_, lenrls_;
  int_4 _data_k_58, _data_k_59;
#define _data_n_58 1
  static int_4 _data_l_58[_data_n_58] = {
    218
  };
#define _data_n_59 1
  static int_4 _data_l_59[_data_n_59] = {
    37
  };
  if (__calls[62].calls == 0) {
    _data_k_58 = 0;
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    lenrls_ = _data_l_58[_data_k_58++];
    _data_k_59 = 0;
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    lenils_ = _data_l_59[_data_k_59++];
  }
  if ((*job_) == 2) {
    goto _l100;
  }
  for (i_ = 1; i_ <= lenrls_; (i_)++) {
    rsav_[i_ - 1] = dls001_.rls_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    isav_[i_ - 1] = dls001_.ils_[i_ - 1];
  }
  goto _l0;
  _l100:;
  for (i_ = 1; i_ <= lenrls_; (i_)++) {
    dls001_.rls_[i_ - 1] = rsav_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    dls001_.ils_[i_ - 1] = isav_[i_ - 1];
  }
  _l0:;
  __calls[62].calls++;
  return 0;
}

int_4 _dsrcpk (real_8 _p_ rsav_, int_4 _p_ isav_, int_4 _p_ job_)
{
  static int_4 i_, lenilp_, lenrlp_, lenils_, lenrls_;
  int_4 _data_k_60, _data_k_61, _data_k_62, _data_k_63;
#define _data_n_60 1
  static int_4 _data_l_60[_data_n_60] = {
    218
  };
#define _data_n_61 1
  static int_4 _data_l_61[_data_n_61] = {
    37
  };
#define _data_n_62 1
  static int_4 _data_l_62[_data_n_62] = {
    4
  };
#define _data_n_63 1
  static int_4 _data_l_63[_data_n_63] = {
    13
  };
  if (__calls[63].calls == 0) {
    _data_k_60 = 0;
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    lenrls_ = _data_l_60[_data_k_60++];
    _data_k_61 = 0;
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    lenils_ = _data_l_61[_data_k_61++];
    _data_k_62 = 0;
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    lenrlp_ = _data_l_62[_data_k_62++];
    _data_k_63 = 0;
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    lenilp_ = _data_l_63[_data_k_63++];
  }
  if ((*job_) == 2) {
    goto _l100;
  }
  (void) _dcopy (&lenrls_, dls001_.rls_, &_k1, rsav_, &_k1);
  (void) _dcopy (&lenrlp_, dlpk01_.rlsp_, &_k1, &rsav_[lenrls_ + 1 - 1], &_k1);
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    isav_[i_ - 1] = dls001_.ils_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenilp_; (i_)++) {
    isav_[lenils_ + i_ - 1] = dlpk01_.ilsp_[i_ - 1];
  }
  goto _l0;
  _l100:;
  (void) _dcopy (&lenrls_, rsav_, &_k1, dls001_.rls_, &_k1);
  (void) _dcopy (&lenrlp_, &rsav_[lenrls_ + 1 - 1], &_k1, dlpk01_.rlsp_, &_k1);
  for (i_ = 1; i_ <= lenils_; (i_)++) {
    dls001_.ils_[i_ - 1] = isav_[i_ - 1];
  }
  for (i_ = 1; i_ <= lenilp_; (i_)++) {
    dlpk01_.ilsp_[i_ - 1] = isav_[lenils_ + i_ - 1];
  }
  _l0:;
  __calls[63].calls++;
  return 0;
}

int_4 _dstoda (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ ewt_, real_8 
_p_ savf_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)(), int_4 (*_pjac)(), int_4 
(*_slvs)())
{
  static int_4 i_, i1_, iredo_, iret_, j_, jb_, m_, ncf_, newq_, lm1_, lm1p1_, lm2_, lm2p1_, nqm1_, nqm2_;
  static real_8 dcon_, ddn_, del_, delp_, dsm_, dup_, exdn_, exsm_, exup_, r_, rh_, rhdn_, rhsm_, rhup_, told_, alpha_, 
  dm1_, dm2_, exm1_, exm2_, pdh_, pnorm_, rate_, rh1_, rh1it_, rh2_, rm_, sm1_[12];
  int_4 _data_k_64, _k_1, $2_;
  real_8 _p_ _arr_0;
#define _data_n_64 12
  static real_8 _data_l_64[_data_n_64] = {
    0.5e0,
    0.575e0,
    0.55e0,
    0.45e0,
    0.35e0,
    0.25e0,
    0.2e0,
    0.15e0,
    0.1e0,
    0.075e0,
    0.05e0,
    0.025e0
  };
  if (__calls[64].calls == 0) {
    _data_k_64 = 0;
    for (_arr_0 = (real_8 *) sm1_, _k_1 = 0; _k_1 < 12; _arr_0++, _k_1++) {
      if (_data_k_64 >= _data_n_64) {
        _data_k_64 = 0;
      }
      sm1_[_k_1] = _data_l_64[_data_k_64++];
    }
  }
  dls001_.kflag_ = 0;
  told_ = dls001_.tn_;
  ncf_ = 0;
  dls001_.ierpj_ = 0;
  dls001_.iersl_ = 0;
  dls001_.jcur_ = 0;
  dls001_.icf_ = 0;
  delp_ = 0.0;
  if (dls001_.jstart_ > 0) {
    goto _l200;
  }
  if (dls001_.jstart_ == -1) {
    goto _l100;
  }
  if (dls001_.jstart_ == -2) {
    goto _l160;
  }
  dls001_.lmax_ = dls001_.maxord_ + 1;
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  dls001_.ialth_ = 2;
  dls001_.rmax_ = 10000.0;
  dls001_.rc_ = 0.0;
  dls001_.el0_ = 1.0;
  dls001_.crate_ = 0.7;
  dls001_.hold_ = dls001_.h_;
  dls001_.nslp_ = 0;
  dls001_.ipup_ = dls001_.miter_;
  iret_ = 3;
  dlsa01_.icount_ = 20;
  dlsa01_.irflag_ = 0;
  dlsa01_.pdest_ = 0.0;
  dlsa01_.pdlast_ = 0.0;
  dlsa01_.ratio_ = 5.0;
  (void) _dcfode (($2_ = 2, &$2_), dls001_.elco_, dls001_.tesco_);
  for (i_ = 1; i_ <= 5; (i_)++) {
    dlsa01_.cm2_[i_ - 1] = dls001_.tesco_[1 + (3) * ((i_ - 1))] * dls001_.elco_[i_ + 1 - 1 + (13) * ((i_ - 1))];
  }
  (void) _dcfode (&_k1, dls001_.elco_, dls001_.tesco_);
  for (i_ = 1; i_ <= 12; (i_)++) {
    dlsa01_.cm1_[i_ - 1] = dls001_.tesco_[1 + (3) * ((i_ - 1))] * dls001_.elco_[i_ + 1 - 1 + (13) * ((i_ - 1))];
  }
  goto _l150;
  _l100:;
  dls001_.ipup_ = dls001_.miter_;
  dls001_.lmax_ = dls001_.maxord_ + 1;
  if (dls001_.ialth_ == 1) {
    dls001_.ialth_ = 2;
  }
  if (dls001_.meth_ == dlsa01_.mused_) {
    goto _l160;
  }
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  dls001_.ialth_ = dls001_.l_;
  iret_ = 1;
  _l150:;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  switch (iret_) {
    default:
    case 1: goto _l160;
    case 2: goto _l170;
    case 3: goto _l200;
  }
  _l160:;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l200;
  }
  rh_ = dls001_.h_ / dls001_.hold_;
  dls001_.h_ = dls001_.hold_;
  iredo_ = 3;
  goto _l175;
  _l170:;
  rh_ = _max (rh_, dls001_.hmin_ / _abs (dls001_.h_));
  _l175:;
  rh_ = _min (rh_, dls001_.rmax_);
  rh_ = rh_ / _max (1.0, _abs (dls001_.h_) * dls001_.hmxi_ * rh_);
  if (dls001_.meth_ == 2) {
    goto _l178;
  }
  dlsa01_.irflag_ = 0;
  pdh_ = _max (_abs (dls001_.h_) * dlsa01_.pdlast_, 1.0e-6);
  if (rh_ * pdh_ * 1.00001e0 < sm1_[dls001_.nq_ - 1]) {
    goto _l178;
  }
  rh_ = sm1_[dls001_.nq_ - 1] / pdh_;
  dlsa01_.irflag_ = 1;
  _l178:;
  r_ = 1.0;
  for (j_ = 2; j_ <= dls001_.l_; (j_)++) {
    r_ = r_ * rh_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] * r_;
    }
  }
  dls001_.h_ = dls001_.h_ * rh_;
  dls001_.rc_ = dls001_.rc_ * rh_;
  dls001_.ialth_ = dls001_.l_;
  if (iredo_ == 0) {
    goto _l690;
  }
  _l200:;
  if (_abs (dls001_.rc_ - 1.0e0) > dls001_.ccmax_) {
    dls001_.ipup_ = dls001_.miter_;
  }
  if (dls001_.nst_ >= dls001_.nslp_ + dls001_.msbp_) {
    dls001_.ipup_ = dls001_.miter_;
  }
  dls001_.tn_ = dls001_.tn_ + dls001_.h_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] + yh1_[i_ + (*nyh_) - 1];
    }
  }
  pnorm_ = _dmnorm (&dls001_.n_, yh1_, ewt_);
  _l220:;
  m_ = 0;
  rate_ = 0.0;
  del_ = 0.0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (dls001_.ipup_ <= 0) {
    goto _l250;
  }
  (void) _pjac (neq_, y_, yh_, nyh_, ewt_, acor_, savf_, wm_, iwm_, _f, _jac);
  dls001_.ipup_ = 0;
  dls001_.rc_ = 1.0;
  dls001_.nslp_ = dls001_.nst_;
  dls001_.crate_ = 0.7;
  if (dls001_.ierpj_ != 0) {
    goto _l430;
  }
  _l250:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = 0.0;
  }
  _l270:;
  if (dls001_.miter_ != 0) {
    goto _l350;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = dls001_.h_ * savf_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((1))];
    y_[i_ - 1] = savf_[i_ - 1] - acor_[i_ - 1];
  }
  del_ = _dmnorm (&dls001_.n_, y_, ewt_);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + dls001_.el_[0] * savf_[i_ - 1];
    acor_[i_ - 1] = savf_[i_ - 1];
  }
  goto _l400;
  _l350:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = dls001_.h_ * savf_[i_ - 1] - (yh_[i_ - 1 + ((*nyh_)) * ((1))] + acor_[i_ - 1]);
  }
  (void) _slvs (wm_, iwm_, y_, savf_);
  if (dls001_.iersl_ < 0) {
    goto _l430;
  }
  if (dls001_.iersl_ > 0) {
    goto _l410;
  }
  del_ = _dmnorm (&dls001_.n_, y_, ewt_);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] + y_[i_ - 1];
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + dls001_.el_[0] * acor_[i_ - 1];
  }
  _l400:;
  if (del_ <= 100.0e0 * pnorm_ * dls001_.uround_) {
    goto _l450;
  }
  if (m_ == 0 && dls001_.meth_ == 1) {
    goto _l405;
  }
  if (m_ == 0) {
    goto _l402;
  }
  rm_ = 1024.0;
  if (del_ <= 1024.0e0 * delp_) {
    rm_ = del_ / delp_;
  }
  rate_ = _max (rate_, rm_);
  dls001_.crate_ = _max (0.2e0 * dls001_.crate_, rm_);
  _l402:;
  dcon_ = del_ * _min (1.0, 1.5e0 * dls001_.crate_) / (dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))] * dls001_.conit_);
  if (dcon_ > 1.0e0) {
    goto _l405;
  }
  dlsa01_.pdest_ = _max (dlsa01_.pdest_, rate_ / _abs (dls001_.h_ * dls001_.el_[0]));
  if (dlsa01_.pdest_ != 0.0e0) {
    dlsa01_.pdlast_ = dlsa01_.pdest_;
  }
  goto _l450;
  _l405:;
  m_ = m_ + 1;
  if (m_ == dls001_.maxcor_) {
    goto _l410;
  }
  if (m_ >= 2 && del_ > 2.0e0 * delp_) {
    goto _l410;
  }
  delp_ = del_;
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  goto _l270;
  _l410:;
  if (dls001_.miter_ == 0 || dls001_.jcur_ == 1) {
    goto _l430;
  }
  dls001_.icf_ = 1;
  dls001_.ipup_ = dls001_.miter_;
  goto _l220;
  _l430:;
  dls001_.icf_ = 2;
  ncf_ = ncf_ + 1;
  dls001_.rmax_ = 2.0;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  if (dls001_.ierpj_ < 0 || dls001_.iersl_ < 0) {
    goto _l680;
  }
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l670;
  }
  if (ncf_ == dls001_.mxncf_) {
    goto _l670;
  }
  rh_ = 0.25;
  dls001_.ipup_ = dls001_.miter_;
  iredo_ = 1;
  goto _l170;
  _l450:;
  dls001_.jcur_ = 0;
  if (m_ == 0) {
    dsm_ = del_ / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (m_ > 0) {
    dsm_ = _dmnorm (&dls001_.n_, acor_, ewt_) / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (dsm_ > 1.0e0) {
    goto _l500;
  }
  dls001_.kflag_ = 0;
  iredo_ = 0;
  dls001_.nst_ = dls001_.nst_ + 1;
  dls001_.hu_ = dls001_.h_;
  dls001_.nqu_ = dls001_.nq_;
  dlsa01_.mused_ = dls001_.meth_;
  for (j_ = 1; j_ <= dls001_.l_; (j_)++) {
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] + dls001_.el_[j_ - 1] * acor_[i_ - 1];
    }
  }
  dlsa01_.icount_ = dlsa01_.icount_ - 1;
  if (dlsa01_.icount_ >= 0) {
    goto _l488;
  }
  if (dls001_.meth_ == 2) {
    goto _l480;
  }
  if (dls001_.nq_ > 5) {
    goto _l488;
  }
  if (dsm_ > 100.0e0 * pnorm_ * dls001_.uround_ && dlsa01_.pdest_ != 0.0e0) {
    goto _l470;
  }
  if (dlsa01_.irflag_ == 0) {
    goto _l488;
  }
  rh2_ = 2.0;
  nqm2_ = _min (dls001_.nq_, dlsa01_.mxords_);
  goto _l478;
  _l470:;
  exsm_ = 1.0e0 / dls001_.l_;
  rh1_ = 1.0e0 / (1.2e0 * pow (dsm_, exsm_) + 0.0000012e0);
  rh1it_ = 2.0e0 * rh1_;
  pdh_ = dlsa01_.pdlast_ * _abs (dls001_.h_);
  if (pdh_ * rh1_ > 0.00001e0) {
    rh1it_ = sm1_[dls001_.nq_ - 1] / pdh_;
  }
  rh1_ = _min (rh1_, rh1it_);
  if (dls001_.nq_ <= dlsa01_.mxords_) {
    goto _l474;
  }
  nqm2_ = dlsa01_.mxords_;
  lm2_ = dlsa01_.mxords_ + 1;
  exm2_ = 1.0e0 / lm2_;
  lm2p1_ = lm2_ + 1;
  dm2_ = _dmnorm (&dls001_.n_, &yh_[0 + ((*nyh_)) * ((lm2p1_ - 1))], ewt_) / dlsa01_.cm2_[dlsa01_.mxords_ - 1];
  rh2_ = 1.0e0 / (1.2e0 * pow (dm2_, exm2_) + 0.0000012e0);
  goto _l476;
  _l474:;
  dm2_ = dsm_ * (dlsa01_.cm1_[dls001_.nq_ - 1] / dlsa01_.cm2_[dls001_.nq_ - 1]);
  rh2_ = 1.0e0 / (1.2e0 * pow (dm2_, exsm_) + 0.0000012e0);
  nqm2_ = dls001_.nq_;
  _l476:;
  if (rh2_ < dlsa01_.ratio_ * rh1_) {
    goto _l488;
  }
  _l478:;
  rh_ = rh2_;
  dlsa01_.icount_ = 20;
  dls001_.meth_ = 2;
  dls001_.miter_ = dlsa01_.jtyp_;
  dlsa01_.pdlast_ = 0.0;
  dls001_.nq_ = nqm2_;
  dls001_.l_ = dls001_.nq_ + 1;
  goto _l170;
  _l480:;
  exsm_ = 1.0e0 / dls001_.l_;
  if (dlsa01_.mxordn_ >= dls001_.nq_) {
    goto _l484;
  }
  nqm1_ = dlsa01_.mxordn_;
  lm1_ = dlsa01_.mxordn_ + 1;
  exm1_ = 1.0e0 / lm1_;
  lm1p1_ = lm1_ + 1;
  dm1_ = _dmnorm (&dls001_.n_, &yh_[0 + ((*nyh_)) * ((lm1p1_ - 1))], ewt_) / dlsa01_.cm1_[dlsa01_.mxordn_ - 1];
  rh1_ = 1.0e0 / (1.2e0 * pow (dm1_, exm1_) + 0.0000012e0);
  goto _l486;
  _l484:;
  dm1_ = dsm_ * (dlsa01_.cm2_[dls001_.nq_ - 1] / dlsa01_.cm1_[dls001_.nq_ - 1]);
  rh1_ = 1.0e0 / (1.2e0 * pow (dm1_, exsm_) + 0.0000012e0);
  nqm1_ = dls001_.nq_;
  exm1_ = exsm_;
  _l486:;
  rh1it_ = 2.0e0 * rh1_;
  pdh_ = dlsa01_.pdnorm_ * _abs (dls001_.h_);
  if (pdh_ * rh1_ > 0.00001e0) {
    rh1it_ = sm1_[nqm1_ - 1] / pdh_;
  }
  rh1_ = _min (rh1_, rh1it_);
  rh2_ = 1.0e0 / (1.2e0 * pow (dsm_, exsm_) + 0.0000012e0);
  if (rh1_ * dlsa01_.ratio_ < 5.0e0 * rh2_) {
    goto _l488;
  }
  alpha_ = _max (1.0e-3, rh1_);
  dm1_ = (pow (alpha_, exm1_)) * dm1_;
  if (dm1_ <= 1000.0e0 * dls001_.uround_ * pnorm_) {
    goto _l488;
  }
  rh_ = rh1_;
  dlsa01_.icount_ = 20;
  dls001_.meth_ = 1;
  dls001_.miter_ = 0;
  dlsa01_.pdlast_ = 0.0;
  dls001_.nq_ = nqm1_;
  dls001_.l_ = dls001_.nq_ + 1;
  goto _l170;
  _l488:;
  dls001_.ialth_ = dls001_.ialth_ - 1;
  if (dls001_.ialth_ == 0) {
    goto _l520;
  }
  if (dls001_.ialth_ > 1) {
    goto _l700;
  }
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l700;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))] = acor_[i_ - 1];
  }
  goto _l700;
  _l500:;
  dls001_.kflag_ = dls001_.kflag_ - 1;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  dls001_.rmax_ = 2.0;
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l660;
  }
  if (dls001_.kflag_ <= -3) {
    goto _l640;
  }
  iredo_ = 2;
  rhup_ = 0.0;
  goto _l540;
  _l520:;
  rhup_ = 0.0;
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l540;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = acor_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))];
  }
  dup_ = _dmnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[2 + (3) * ((dls001_.nq_ - 1))];
  exup_ = 1.0e0 / (dls001_.l_ + 1);
  rhup_ = 1.0e0 / (1.4e0 * pow (dup_, exup_) + 0.0000014e0);
  _l540:;
  exsm_ = 1.0e0 / dls001_.l_;
  rhsm_ = 1.0e0 / (1.2e0 * pow (dsm_, exsm_) + 0.0000012e0);
  rhdn_ = 0.0;
  if (dls001_.nq_ == 1) {
    goto _l550;
  }
  ddn_ = _dmnorm (&dls001_.n_, &yh_[0 + ((*nyh_)) * ((dls001_.l_ - 1))], ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.nq_ - 
  1))];
  exdn_ = 1.0e0 / dls001_.nq_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  _l550:;
  if (dls001_.meth_ == 2) {
    goto _l560;
  }
  pdh_ = _max (_abs (dls001_.h_) * dlsa01_.pdlast_, 1.0e-6);
  if (dls001_.l_ < dls001_.lmax_) {
    rhup_ = _min (rhup_, sm1_[dls001_.l_ - 1] / pdh_);
  }
  rhsm_ = _min (rhsm_, sm1_[dls001_.nq_ - 1] / pdh_);
  if (dls001_.nq_ > 1) {
    rhdn_ = _min (rhdn_, sm1_[dls001_.nq_ - 1 - 1] / pdh_);
  }
  dlsa01_.pdest_ = 0.0;
  _l560:;
  if (rhsm_ >= rhup_) {
    goto _l570;
  }
  if (rhup_ > rhdn_) {
    goto _l590;
  }
  goto _l580;
  _l570:;
  if (rhsm_ < rhdn_) {
    goto _l580;
  }
  newq_ = dls001_.nq_;
  rh_ = rhsm_;
  goto _l620;
  _l580:;
  newq_ = dls001_.nq_ - 1;
  rh_ = rhdn_;
  if (dls001_.kflag_ < 0 && rh_ > 1.0e0) {
    rh_ = 1.0;
  }
  goto _l620;
  _l590:;
  newq_ = dls001_.l_;
  rh_ = rhup_;
  if (rh_ < 1.1e0) {
    goto _l610;
  }
  r_ = dls001_.el_[dls001_.l_ - 1] / dls001_.l_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((newq_ + 1 - 1))] = acor_[i_ - 1] * r_;
  }
  goto _l630;
  _l610:;
  dls001_.ialth_ = 3;
  goto _l700;
  _l620:;
  if (dls001_.meth_ == 2) {
    goto _l622;
  }
  if (rh_ * pdh_ * 1.00001e0 >= sm1_[newq_ - 1]) {
    goto _l625;
  }
  _l622:;
  if (dls001_.kflag_ == 0 && rh_ < 1.1e0) {
    goto _l610;
  }
  _l625:;
  if (dls001_.kflag_ <= -2) {
    rh_ = _min (rh_, 0.2);
  }
  if (newq_ == dls001_.nq_) {
    goto _l170;
  }
  _l630:;
  dls001_.nq_ = newq_;
  dls001_.l_ = dls001_.nq_ + 1;
  iret_ = 2;
  goto _l150;
  _l640:;
  if (dls001_.kflag_ == -10) {
    goto _l660;
  }
  rh_ = 0.1;
  rh_ = _max (dls001_.hmin_ / _abs (dls001_.h_), rh_);
  dls001_.h_ = dls001_.h_ * rh_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((1))] = dls001_.h_ * savf_[i_ - 1];
  }
  dls001_.ipup_ = dls001_.miter_;
  dls001_.ialth_ = 5;
  if (dls001_.nq_ == 1) {
    goto _l200;
  }
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  iret_ = 3;
  goto _l150;
  _l660:;
  dls001_.kflag_ = -1;
  goto _l720;
  _l670:;
  dls001_.kflag_ = -2;
  goto _l720;
  _l680:;
  dls001_.kflag_ = -3;
  goto _l720;
  _l690:;
  dls001_.rmax_ = 10.0;
  _l700:;
  r_ = 1.0e0 / dls001_.tesco_[1 + (3) * ((dls001_.nqu_ - 1))];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] * r_;
  }
  _l720:;
  dls001_.hold_ = dls001_.h_;
  dls001_.jstart_ = 1;
  __calls[64].calls++;
  return 0;
}

int_4 _dstode (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ ewt_, real_8 
_p_ savf_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)(), int_4 (*_pjac)(), int_4 
(*_slvs)())
{
  static int_4 i_, i1_, iredo_, iret_, j_, jb_, m_, ncf_, newq_;
  static real_8 dcon_, ddn_, del_, delp_, dsm_, dup_, exdn_, exsm_, exup_, r_, rh_, rhdn_, rhsm_, rhup_, told_;
  dls001_.kflag_ = 0;
  told_ = dls001_.tn_;
  ncf_ = 0;
  dls001_.ierpj_ = 0;
  dls001_.iersl_ = 0;
  dls001_.jcur_ = 0;
  dls001_.icf_ = 0;
  delp_ = 0.0;
  if (dls001_.jstart_ > 0) {
    goto _l200;
  }
  if (dls001_.jstart_ == -1) {
    goto _l100;
  }
  if (dls001_.jstart_ == -2) {
    goto _l160;
  }
  dls001_.lmax_ = dls001_.maxord_ + 1;
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  dls001_.ialth_ = 2;
  dls001_.rmax_ = 10000.0;
  dls001_.rc_ = 0.0;
  dls001_.el0_ = 1.0;
  dls001_.crate_ = 0.7;
  dls001_.hold_ = dls001_.h_;
  dls001_.meo_ = dls001_.meth_;
  dls001_.nslp_ = 0;
  dls001_.ipup_ = dls001_.miter_;
  iret_ = 3;
  goto _l140;
  _l100:;
  dls001_.ipup_ = dls001_.miter_;
  dls001_.lmax_ = dls001_.maxord_ + 1;
  if (dls001_.ialth_ == 1) {
    dls001_.ialth_ = 2;
  }
  if (dls001_.meth_ == dls001_.meo_) {
    goto _l110;
  }
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  dls001_.meo_ = dls001_.meth_;
  if (dls001_.nq_ > dls001_.maxord_) {
    goto _l120;
  }
  dls001_.ialth_ = dls001_.l_;
  iret_ = 1;
  goto _l150;
  _l110:;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l160;
  }
  _l120:;
  dls001_.nq_ = dls001_.maxord_;
  dls001_.l_ = dls001_.lmax_;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  ddn_ = _dvnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.l_ - 1))];
  exdn_ = 1.0e0 / dls001_.l_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  rh_ = _min (rhdn_, 1.0);
  iredo_ = 3;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l170;
  }
  rh_ = _min (rh_, _abs (dls001_.h_ / dls001_.hold_));
  dls001_.h_ = dls001_.hold_;
  goto _l175;
  _l140:;
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  _l150:;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  switch (iret_) {
    default:
    case 1: goto _l160;
    case 2: goto _l170;
    case 3: goto _l200;
  }
  _l160:;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l200;
  }
  rh_ = dls001_.h_ / dls001_.hold_;
  dls001_.h_ = dls001_.hold_;
  iredo_ = 3;
  goto _l175;
  _l170:;
  rh_ = _max (rh_, dls001_.hmin_ / _abs (dls001_.h_));
  _l175:;
  rh_ = _min (rh_, dls001_.rmax_);
  rh_ = rh_ / _max (1.0, _abs (dls001_.h_) * dls001_.hmxi_ * rh_);
  r_ = 1.0;
  for (j_ = 2; j_ <= dls001_.l_; (j_)++) {
    r_ = r_ * rh_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] * r_;
    }
  }
  dls001_.h_ = dls001_.h_ * rh_;
  dls001_.rc_ = dls001_.rc_ * rh_;
  dls001_.ialth_ = dls001_.l_;
  if (iredo_ == 0) {
    goto _l690;
  }
  _l200:;
  if (_abs (dls001_.rc_ - 1.0e0) > dls001_.ccmax_) {
    dls001_.ipup_ = dls001_.miter_;
  }
  if (dls001_.nst_ >= dls001_.nslp_ + dls001_.msbp_) {
    dls001_.ipup_ = dls001_.miter_;
  }
  dls001_.tn_ = dls001_.tn_ + dls001_.h_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] + yh1_[i_ + (*nyh_) - 1];
    }
  }
  _l220:;
  m_ = 0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (dls001_.ipup_ <= 0) {
    goto _l250;
  }
  (void) _pjac (neq_, y_, yh_, nyh_, ewt_, acor_, savf_, wm_, iwm_, _f, _jac);
  dls001_.ipup_ = 0;
  dls001_.rc_ = 1.0;
  dls001_.nslp_ = dls001_.nst_;
  dls001_.crate_ = 0.7;
  if (dls001_.ierpj_ != 0) {
    goto _l430;
  }
  _l250:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = 0.0;
  }
  _l270:;
  if (dls001_.miter_ != 0) {
    goto _l350;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = dls001_.h_ * savf_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((1))];
    y_[i_ - 1] = savf_[i_ - 1] - acor_[i_ - 1];
  }
  del_ = _dvnorm (&dls001_.n_, y_, ewt_);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + dls001_.el_[0] * savf_[i_ - 1];
    acor_[i_ - 1] = savf_[i_ - 1];
  }
  goto _l400;
  _l350:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = dls001_.h_ * savf_[i_ - 1] - (yh_[i_ - 1 + ((*nyh_)) * ((1))] + acor_[i_ - 1]);
  }
  (void) _slvs (wm_, iwm_, y_, savf_);
  if (dls001_.iersl_ < 0) {
    goto _l430;
  }
  if (dls001_.iersl_ > 0) {
    goto _l410;
  }
  del_ = _dvnorm (&dls001_.n_, y_, ewt_);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] + y_[i_ - 1];
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + dls001_.el_[0] * acor_[i_ - 1];
  }
  _l400:;
  if (m_ != 0) {
    dls001_.crate_ = _max (0.2e0 * dls001_.crate_, del_ / delp_);
  }
  dcon_ = del_ * _min (1.0, 1.5e0 * dls001_.crate_) / (dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))] * dls001_.conit_);
  if (dcon_ <= 1.0e0) {
    goto _l450;
  }
  m_ = m_ + 1;
  if (m_ == dls001_.maxcor_) {
    goto _l410;
  }
  if (m_ >= 2 && del_ > 2.0e0 * delp_) {
    goto _l410;
  }
  delp_ = del_;
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  goto _l270;
  _l410:;
  if (dls001_.miter_ == 0 || dls001_.jcur_ == 1) {
    goto _l430;
  }
  dls001_.icf_ = 1;
  dls001_.ipup_ = dls001_.miter_;
  goto _l220;
  _l430:;
  dls001_.icf_ = 2;
  ncf_ = ncf_ + 1;
  dls001_.rmax_ = 2.0;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  if (dls001_.ierpj_ < 0 || dls001_.iersl_ < 0) {
    goto _l680;
  }
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l670;
  }
  if (ncf_ == dls001_.mxncf_) {
    goto _l670;
  }
  rh_ = 0.25;
  dls001_.ipup_ = dls001_.miter_;
  iredo_ = 1;
  goto _l170;
  _l450:;
  dls001_.jcur_ = 0;
  if (m_ == 0) {
    dsm_ = del_ / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (m_ > 0) {
    dsm_ = _dvnorm (&dls001_.n_, acor_, ewt_) / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (dsm_ > 1.0e0) {
    goto _l500;
  }
  dls001_.kflag_ = 0;
  iredo_ = 0;
  dls001_.nst_ = dls001_.nst_ + 1;
  dls001_.hu_ = dls001_.h_;
  dls001_.nqu_ = dls001_.nq_;
  for (j_ = 1; j_ <= dls001_.l_; (j_)++) {
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] + dls001_.el_[j_ - 1] * acor_[i_ - 1];
    }
  }
  dls001_.ialth_ = dls001_.ialth_ - 1;
  if (dls001_.ialth_ == 0) {
    goto _l520;
  }
  if (dls001_.ialth_ > 1) {
    goto _l700;
  }
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l700;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))] = acor_[i_ - 1];
  }
  goto _l700;
  _l500:;
  dls001_.kflag_ = dls001_.kflag_ - 1;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  dls001_.rmax_ = 2.0;
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l660;
  }
  if (dls001_.kflag_ <= -3) {
    goto _l640;
  }
  iredo_ = 2;
  rhup_ = 0.0;
  goto _l540;
  _l520:;
  rhup_ = 0.0;
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l540;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = acor_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))];
  }
  dup_ = _dvnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[2 + (3) * ((dls001_.nq_ - 1))];
  exup_ = 1.0e0 / (dls001_.l_ + 1);
  rhup_ = 1.0e0 / (1.4e0 * pow (dup_, exup_) + 0.0000014e0);
  _l540:;
  exsm_ = 1.0e0 / dls001_.l_;
  rhsm_ = 1.0e0 / (1.2e0 * pow (dsm_, exsm_) + 0.0000012e0);
  rhdn_ = 0.0;
  if (dls001_.nq_ == 1) {
    goto _l560;
  }
  ddn_ = _dvnorm (&dls001_.n_, &yh_[0 + ((*nyh_)) * ((dls001_.l_ - 1))], ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.nq_ - 
  1))];
  exdn_ = 1.0e0 / dls001_.nq_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  _l560:;
  if (rhsm_ >= rhup_) {
    goto _l570;
  }
  if (rhup_ > rhdn_) {
    goto _l590;
  }
  goto _l580;
  _l570:;
  if (rhsm_ < rhdn_) {
    goto _l580;
  }
  newq_ = dls001_.nq_;
  rh_ = rhsm_;
  goto _l620;
  _l580:;
  newq_ = dls001_.nq_ - 1;
  rh_ = rhdn_;
  if (dls001_.kflag_ < 0 && rh_ > 1.0e0) {
    rh_ = 1.0;
  }
  goto _l620;
  _l590:;
  newq_ = dls001_.l_;
  rh_ = rhup_;
  if (rh_ < 1.1e0) {
    goto _l610;
  }
  r_ = dls001_.el_[dls001_.l_ - 1] / dls001_.l_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((newq_ + 1 - 1))] = acor_[i_ - 1] * r_;
  }
  goto _l630;
  _l610:;
  dls001_.ialth_ = 3;
  goto _l700;
  _l620:;
  if ((dls001_.kflag_ == 0) && (rh_ < 1.1e0)) {
    goto _l610;
  }
  if (dls001_.kflag_ <= -2) {
    rh_ = _min (rh_, 0.2);
  }
  if (newq_ == dls001_.nq_) {
    goto _l170;
  }
  _l630:;
  dls001_.nq_ = newq_;
  dls001_.l_ = dls001_.nq_ + 1;
  iret_ = 2;
  goto _l150;
  _l640:;
  if (dls001_.kflag_ == -10) {
    goto _l660;
  }
  rh_ = 0.1;
  rh_ = _max (dls001_.hmin_ / _abs (dls001_.h_), rh_);
  dls001_.h_ = dls001_.h_ * rh_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((1))] = dls001_.h_ * savf_[i_ - 1];
  }
  dls001_.ipup_ = dls001_.miter_;
  dls001_.ialth_ = 5;
  if (dls001_.nq_ == 1) {
    goto _l200;
  }
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  iret_ = 3;
  goto _l150;
  _l660:;
  dls001_.kflag_ = -1;
  goto _l720;
  _l670:;
  dls001_.kflag_ = -2;
  goto _l720;
  _l680:;
  dls001_.kflag_ = -3;
  goto _l720;
  _l690:;
  dls001_.rmax_ = 10.0;
  _l700:;
  r_ = 1.0e0 / dls001_.tesco_[1 + (3) * ((dls001_.nqu_ - 1))];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] * r_;
  }
  _l720:;
  dls001_.hold_ = dls001_.h_;
  dls001_.jstart_ = 1;
  __calls[65].calls++;
  return 0;
}

int_4 _dstodi (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ ewt_, real_8 
_p_ savf_, real_8 _p_ savr_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), real_4 (*_adda)(), 
int_4 (*_jac)(), int_4 (*_pjac)(), int_4 (*_slvs)())
{
  static int_4 i_, i1_, iredo_, ires_, iret_, j_, jb_, kgo_, m_, ncf_, newq_;
  static real_8 dcon_, ddn_, del_, delp_, dsm_, dup_, eljh_, el1h_, exdn_, exsm_, exup_, r_, rh_, rhdn_, rhsm_, rhup_, 
  told_;
  dls001_.kflag_ = 0;
  told_ = dls001_.tn_;
  ncf_ = 0;
  dls001_.ierpj_ = 0;
  dls001_.iersl_ = 0;
  dls001_.jcur_ = 0;
  dls001_.icf_ = 0;
  delp_ = 0.0;
  if (dls001_.jstart_ > 0) {
    goto _l200;
  }
  if (dls001_.jstart_ == -1) {
    goto _l100;
  }
  if (dls001_.jstart_ == -2) {
    goto _l160;
  }
  dls001_.lmax_ = dls001_.maxord_ + 1;
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  dls001_.ialth_ = 2;
  dls001_.rmax_ = 10000.0;
  dls001_.rc_ = 0.0;
  dls001_.el0_ = 1.0;
  dls001_.crate_ = 0.7;
  dls001_.hold_ = dls001_.h_;
  dls001_.meo_ = dls001_.meth_;
  dls001_.nslp_ = 0;
  dls001_.ipup_ = dls001_.miter_;
  iret_ = 3;
  goto _l140;
  _l100:;
  dls001_.ipup_ = dls001_.miter_;
  dls001_.lmax_ = dls001_.maxord_ + 1;
  if (dls001_.ialth_ == 1) {
    dls001_.ialth_ = 2;
  }
  if (dls001_.meth_ == dls001_.meo_) {
    goto _l110;
  }
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  dls001_.meo_ = dls001_.meth_;
  if (dls001_.nq_ > dls001_.maxord_) {
    goto _l120;
  }
  dls001_.ialth_ = dls001_.l_;
  iret_ = 1;
  goto _l150;
  _l110:;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l160;
  }
  _l120:;
  dls001_.nq_ = dls001_.maxord_;
  dls001_.l_ = dls001_.lmax_;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  ddn_ = _dvnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.l_ - 1))];
  exdn_ = 1.0e0 / dls001_.l_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  rh_ = _min (rhdn_, 1.0);
  iredo_ = 3;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l170;
  }
  rh_ = _min (rh_, _abs (dls001_.h_ / dls001_.hold_));
  dls001_.h_ = dls001_.hold_;
  goto _l175;
  _l140:;
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  _l150:;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  switch (iret_) {
    default:
    case 1: goto _l160;
    case 2: goto _l170;
    case 3: goto _l200;
  }
  _l160:;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l200;
  }
  rh_ = dls001_.h_ / dls001_.hold_;
  dls001_.h_ = dls001_.hold_;
  iredo_ = 3;
  goto _l175;
  _l170:;
  rh_ = _max (rh_, dls001_.hmin_ / _abs (dls001_.h_));
  _l175:;
  rh_ = _min (rh_, dls001_.rmax_);
  rh_ = rh_ / _max (1.0, _abs (dls001_.h_) * dls001_.hmxi_ * rh_);
  r_ = 1.0;
  for (j_ = 2; j_ <= dls001_.l_; (j_)++) {
    r_ = r_ * rh_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] * r_;
    }
  }
  dls001_.h_ = dls001_.h_ * rh_;
  dls001_.rc_ = dls001_.rc_ * rh_;
  dls001_.ialth_ = dls001_.l_;
  if (iredo_ == 0) {
    goto _l690;
  }
  _l200:;
  if (_abs (dls001_.rc_ - 1.0e0) > dls001_.ccmax_) {
    dls001_.ipup_ = dls001_.miter_;
  }
  if (dls001_.nst_ >= dls001_.nslp_ + dls001_.msbp_) {
    dls001_.ipup_ = dls001_.miter_;
  }
  dls001_.tn_ = dls001_.tn_ + dls001_.h_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] + yh1_[i_ + (*nyh_) - 1];
    }
  }
  _l220:;
  m_ = 0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((1))] / dls001_.h_;
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  if (dls001_.ipup_ <= 0) {
    goto _l240;
  }
  (void) _pjac (neq_, y_, yh_, nyh_, ewt_, acor_, savr_, savf_, wm_, iwm_, _res, _jac, _adda);
  dls001_.ipup_ = 0;
  dls001_.rc_ = 1.0;
  dls001_.nslp_ = dls001_.nst_;
  dls001_.crate_ = 0.7;
  if (dls001_.ierpj_ == 0) {
    goto _l250;
  }
  if (dls001_.ierpj_ < 0) {
    goto _l435;
  }
  ires_ = dls001_.ierpj_;
  switch (ires_) {
    default:
    case 1: goto _l430;
    case 2: goto _l435;
    case 3: goto _l430;
  }
  _l240:;
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, savf_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  kgo_ = _abs (ires_);
  switch (kgo_) {
    default:
    case 1: goto _l250;
    case 2: goto _l435;
    case 3: goto _l430;
  }
  _l250:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = 0.0;
  }
  _l270:;
  (void) _slvs (wm_, iwm_, savr_, savf_);
  if (dls001_.iersl_ < 0) {
    goto _l430;
  }
  if (dls001_.iersl_ > 0) {
    goto _l410;
  }
  el1h_ = dls001_.el_[0] * dls001_.h_;
  del_ = _dvnorm (&dls001_.n_, savr_, ewt_) * _abs (dls001_.h_);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] + savr_[i_ - 1];
    savf_[i_ - 1] = acor_[i_ - 1] + yh_[i_ - 1 + ((*nyh_)) * ((1))] / dls001_.h_;
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + el1h_ * acor_[i_ - 1];
  }
  if (m_ != 0) {
    dls001_.crate_ = _max (0.2e0 * dls001_.crate_, del_ / delp_);
  }
  dcon_ = del_ * _min (1.0, 1.5e0 * dls001_.crate_) / (dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))] * dls001_.conit_);
  if (dcon_ <= 1.0e0) {
    goto _l460;
  }
  m_ = m_ + 1;
  if (m_ == dls001_.maxcor_) {
    goto _l410;
  }
  if (m_ >= 2 && del_ > 2.0e0 * delp_) {
    goto _l410;
  }
  delp_ = del_;
  ires_ = 1;
  (void) _res (neq_, &dls001_.tn_, y_, savf_, savr_, &ires_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  kgo_ = _abs (ires_);
  switch (kgo_) {
    default:
    case 1: goto _l270;
    case 2: goto _l435;
    case 3: goto _l410;
  }
  _l410:;
  dls001_.icf_ = 1;
  if (dls001_.jcur_ == 1) {
    goto _l430;
  }
  dls001_.ipup_ = dls001_.miter_;
  goto _l220;
  _l430:;
  dls001_.icf_ = 2;
  ncf_ = ncf_ + 1;
  dls001_.rmax_ = 2.0;
  _l435:;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  if (ires_ == 2) {
    goto _l680;
  }
  if (dls001_.ierpj_ < 0 || dls001_.iersl_ < 0) {
    goto _l685;
  }
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l450;
  }
  if (ncf_ == dls001_.mxncf_) {
    goto _l450;
  }
  rh_ = 0.25;
  dls001_.ipup_ = dls001_.miter_;
  iredo_ = 1;
  goto _l170;
  _l450:;
  if (ires_ == 3) {
    goto _l680;
  }
  goto _l670;
  _l460:;
  dls001_.jcur_ = 0;
  if (m_ == 0) {
    dsm_ = del_ / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (m_ > 0) {
    dsm_ = _abs (dls001_.h_) * _dvnorm (&dls001_.n_, acor_, ewt_) / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (dsm_ > 1.0e0) {
    goto _l500;
  }
  dls001_.kflag_ = 0;
  iredo_ = 0;
  dls001_.nst_ = dls001_.nst_ + 1;
  dls001_.hu_ = dls001_.h_;
  dls001_.nqu_ = dls001_.nq_;
  for (j_ = 1; j_ <= dls001_.l_; (j_)++) {
    eljh_ = dls001_.el_[j_ - 1] * dls001_.h_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] + eljh_ * acor_[i_ - 1];
    }
  }
  dls001_.ialth_ = dls001_.ialth_ - 1;
  if (dls001_.ialth_ == 0) {
    goto _l520;
  }
  if (dls001_.ialth_ > 1) {
    goto _l700;
  }
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l700;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))] = acor_[i_ - 1];
  }
  goto _l700;
  _l500:;
  dls001_.kflag_ = dls001_.kflag_ - 1;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  dls001_.rmax_ = 2.0;
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l660;
  }
  if (dls001_.kflag_ <= -7) {
    goto _l660;
  }
  iredo_ = 2;
  rhup_ = 0.0;
  goto _l540;
  _l520:;
  rhup_ = 0.0;
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l540;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = acor_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))];
  }
  dup_ = _abs (dls001_.h_) * _dvnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[2 + (3) * ((dls001_.nq_ - 1))];
  exup_ = 1.0e0 / (dls001_.l_ + 1);
  rhup_ = 1.0e0 / (1.4e0 * pow (dup_, exup_) + 0.0000014e0);
  _l540:;
  exsm_ = 1.0e0 / dls001_.l_;
  rhsm_ = 1.0e0 / (1.2e0 * pow (dsm_, exsm_) + 0.0000012e0);
  rhdn_ = 0.0;
  if (dls001_.nq_ == 1) {
    goto _l560;
  }
  ddn_ = _dvnorm (&dls001_.n_, &yh_[0 + ((*nyh_)) * ((dls001_.l_ - 1))], ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.nq_ - 
  1))];
  exdn_ = 1.0e0 / dls001_.nq_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  _l560:;
  if (rhsm_ >= rhup_) {
    goto _l570;
  }
  if (rhup_ > rhdn_) {
    goto _l590;
  }
  goto _l580;
  _l570:;
  if (rhsm_ < rhdn_) {
    goto _l580;
  }
  newq_ = dls001_.nq_;
  rh_ = rhsm_;
  goto _l620;
  _l580:;
  newq_ = dls001_.nq_ - 1;
  rh_ = rhdn_;
  if (dls001_.kflag_ < 0 && rh_ > 1.0e0) {
    rh_ = 1.0;
  }
  goto _l620;
  _l590:;
  newq_ = dls001_.l_;
  rh_ = rhup_;
  if (rh_ < 1.1e0) {
    goto _l610;
  }
  r_ = dls001_.h_ * dls001_.el_[dls001_.l_ - 1] / dls001_.l_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((newq_ + 1 - 1))] = acor_[i_ - 1] * r_;
  }
  goto _l630;
  _l610:;
  dls001_.ialth_ = 3;
  goto _l700;
  _l620:;
  if ((dls001_.kflag_ == 0) && (rh_ < 1.1e0)) {
    goto _l610;
  }
  if (dls001_.kflag_ <= -2) {
    rh_ = _min (rh_, 0.1);
  }
  if (newq_ == dls001_.nq_) {
    goto _l170;
  }
  _l630:;
  dls001_.nq_ = newq_;
  dls001_.l_ = dls001_.nq_ + 1;
  iret_ = 2;
  goto _l150;
  _l660:;
  dls001_.kflag_ = -1;
  goto _l720;
  _l670:;
  dls001_.kflag_ = -2;
  goto _l720;
  _l680:;
  dls001_.kflag_ = -1 - ires_;
  goto _l720;
  _l685:;
  dls001_.kflag_ = -5;
  goto _l720;
  _l690:;
  dls001_.rmax_ = 10.0;
  _l700:;
  r_ = dls001_.h_ / dls001_.tesco_[1 + (3) * ((dls001_.nqu_ - 1))];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] * r_;
  }
  _l720:;
  dls001_.hold_ = dls001_.h_;
  dls001_.jstart_ = 1;
  __calls[66].calls++;
  return 0;
}

int_4 _dstodpk (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ ewt_, real_8 
_p_ savf_, real_8 _p_ savx_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)(), real_4 
(*_psol)())
{
  static int_4 i_, i1_, iredo_, iret_, j_, jb_, m_, ncf_, newq_;
  static real_8 dcon_, ddn_, del_, delp_, dsm_, dup_, exdn_, exsm_, exup_, r_, rh_, rhdn_, rhsm_, rhup_, told_;
  dls001_.kflag_ = 0;
  told_ = dls001_.tn_;
  ncf_ = 0;
  dls001_.ierpj_ = 0;
  dls001_.iersl_ = 0;
  dls001_.jcur_ = 0;
  dls001_.icf_ = 0;
  delp_ = 0.0;
  if (dls001_.jstart_ > 0) {
    goto _l200;
  }
  if (dls001_.jstart_ == -1) {
    goto _l100;
  }
  if (dls001_.jstart_ == -2) {
    goto _l160;
  }
  dls001_.lmax_ = dls001_.maxord_ + 1;
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  dls001_.ialth_ = 2;
  dls001_.rmax_ = 10000.0;
  dls001_.rc_ = 0.0;
  dls001_.el0_ = 1.0;
  dls001_.crate_ = 0.7;
  dls001_.hold_ = dls001_.h_;
  dls001_.meo_ = dls001_.meth_;
  dls001_.nslp_ = 0;
  dls001_.ipup_ = dls001_.miter_;
  iret_ = 3;
  goto _l140;
  _l100:;
  dls001_.ipup_ = dls001_.miter_;
  dls001_.lmax_ = dls001_.maxord_ + 1;
  if (dls001_.ialth_ == 1) {
    dls001_.ialth_ = 2;
  }
  if (dls001_.meth_ == dls001_.meo_) {
    goto _l110;
  }
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  dls001_.meo_ = dls001_.meth_;
  if (dls001_.nq_ > dls001_.maxord_) {
    goto _l120;
  }
  dls001_.ialth_ = dls001_.l_;
  iret_ = 1;
  goto _l150;
  _l110:;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l160;
  }
  _l120:;
  dls001_.nq_ = dls001_.maxord_;
  dls001_.l_ = dls001_.lmax_;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  dlpk01_.epcon_ = dls001_.conit_ * dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  ddn_ = _dvnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.l_ - 1))];
  exdn_ = 1.0e0 / dls001_.l_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  rh_ = _min (rhdn_, 1.0);
  iredo_ = 3;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l170;
  }
  rh_ = _min (rh_, _abs (dls001_.h_ / dls001_.hold_));
  dls001_.h_ = dls001_.hold_;
  goto _l175;
  _l140:;
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  _l150:;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  dlpk01_.epcon_ = dls001_.conit_ * dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  switch (iret_) {
    default:
    case 1: goto _l160;
    case 2: goto _l170;
    case 3: goto _l200;
  }
  _l160:;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l200;
  }
  rh_ = dls001_.h_ / dls001_.hold_;
  dls001_.h_ = dls001_.hold_;
  iredo_ = 3;
  goto _l175;
  _l170:;
  rh_ = _max (rh_, dls001_.hmin_ / _abs (dls001_.h_));
  _l175:;
  rh_ = _min (rh_, dls001_.rmax_);
  rh_ = rh_ / _max (1.0, _abs (dls001_.h_) * dls001_.hmxi_ * rh_);
  r_ = 1.0;
  for (j_ = 2; j_ <= dls001_.l_; (j_)++) {
    r_ = r_ * rh_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] * r_;
    }
  }
  dls001_.h_ = dls001_.h_ * rh_;
  dls001_.rc_ = dls001_.rc_ * rh_;
  dls001_.ialth_ = dls001_.l_;
  if (iredo_ == 0) {
    goto _l690;
  }
  _l200:;
  if (dlpk01_.jacflg_ != 0) {
    goto _l202;
  }
  dls001_.ipup_ = 0;
  dls001_.crate_ = 0.7;
  goto _l205;
  _l202:;
  if (_abs (dls001_.rc_ - 1.0e0) > dls001_.ccmax_) {
    dls001_.ipup_ = dls001_.miter_;
  }
  if (dls001_.nst_ >= dls001_.nslp_ + dls001_.msbp_) {
    dls001_.ipup_ = dls001_.miter_;
  }
  _l205:;
  dls001_.tn_ = dls001_.tn_ + dls001_.h_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] + yh1_[i_ + (*nyh_) - 1];
    }
  }
  _l220:;
  m_ = 0;
  dlpk01_.mnewt_ = 0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (dls001_.ipup_ <= 0) {
    goto _l250;
  }
  (void) _dpkset (neq_, y_, yh1_, ewt_, acor_, savf_, wm_, iwm_, _f, _jac);
  dls001_.ipup_ = 0;
  dls001_.rc_ = 1.0;
  dls001_.nslp_ = dls001_.nst_;
  dls001_.crate_ = 0.7;
  if (dls001_.ierpj_ != 0) {
    goto _l430;
  }
  _l250:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = 0.0;
  }
  _l270:;
  if (dls001_.miter_ != 0) {
    goto _l350;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = dls001_.h_ * savf_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((1))];
    y_[i_ - 1] = savf_[i_ - 1] - acor_[i_ - 1];
  }
  del_ = _dvnorm (&dls001_.n_, y_, ewt_);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + dls001_.el_[0] * savf_[i_ - 1];
    acor_[i_ - 1] = savf_[i_ - 1];
  }
  goto _l400;
  _l350:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savx_[i_ - 1] = dls001_.h_ * savf_[i_ - 1] - (yh_[i_ - 1 + ((*nyh_)) * ((1))] + acor_[i_ - 1]);
  }
  (void) _dsolpk (neq_, y_, savf_, savx_, ewt_, wm_, iwm_, _f, _psol);
  if (dls001_.iersl_ < 0) {
    goto _l430;
  }
  if (dls001_.iersl_ > 0) {
    goto _l410;
  }
  del_ = _dvnorm (&dls001_.n_, savx_, ewt_);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] + savx_[i_ - 1];
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + dls001_.el_[0] * acor_[i_ - 1];
  }
  _l400:;
  if (m_ != 0) {
    dls001_.crate_ = _max (0.2e0 * dls001_.crate_, del_ / delp_);
  }
  dcon_ = del_ * _min (1.0, 1.5e0 * dls001_.crate_) / dlpk01_.epcon_;
  if (dcon_ <= 1.0e0) {
    goto _l450;
  }
  m_ = m_ + 1;
  if (m_ == dls001_.maxcor_) {
    goto _l410;
  }
  if (m_ >= 2 && del_ > 2.0e0 * delp_) {
    goto _l410;
  }
  dlpk01_.mnewt_ = m_;
  delp_ = del_;
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  goto _l270;
  _l410:;
  if (dls001_.miter_ == 0 || dls001_.jcur_ == 1 || dlpk01_.jacflg_ == 0) {
    goto _l430;
  }
  dls001_.icf_ = 1;
  dls001_.ipup_ = dls001_.miter_;
  goto _l220;
  _l430:;
  dls001_.icf_ = 2;
  ncf_ = ncf_ + 1;
  dlpk01_.ncfn_ = dlpk01_.ncfn_ + 1;
  dls001_.rmax_ = 2.0;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  if (dls001_.ierpj_ < 0 || dls001_.iersl_ < 0) {
    goto _l680;
  }
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l670;
  }
  if (ncf_ == dls001_.mxncf_) {
    goto _l670;
  }
  rh_ = 0.5;
  dls001_.ipup_ = dls001_.miter_;
  iredo_ = 1;
  goto _l170;
  _l450:;
  dls001_.jcur_ = 0;
  if (m_ == 0) {
    dsm_ = del_ / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (m_ > 0) {
    dsm_ = _dvnorm (&dls001_.n_, acor_, ewt_) / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (dsm_ > 1.0e0) {
    goto _l500;
  }
  dls001_.kflag_ = 0;
  iredo_ = 0;
  dls001_.nst_ = dls001_.nst_ + 1;
  dls001_.hu_ = dls001_.h_;
  dls001_.nqu_ = dls001_.nq_;
  for (j_ = 1; j_ <= dls001_.l_; (j_)++) {
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] + dls001_.el_[j_ - 1] * acor_[i_ - 1];
    }
  }
  dls001_.ialth_ = dls001_.ialth_ - 1;
  if (dls001_.ialth_ == 0) {
    goto _l520;
  }
  if (dls001_.ialth_ > 1) {
    goto _l700;
  }
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l700;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))] = acor_[i_ - 1];
  }
  goto _l700;
  _l500:;
  dls001_.kflag_ = dls001_.kflag_ - 1;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  dls001_.rmax_ = 2.0;
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l660;
  }
  if (dls001_.kflag_ <= -3) {
    goto _l640;
  }
  iredo_ = 2;
  rhup_ = 0.0;
  goto _l540;
  _l520:;
  rhup_ = 0.0;
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l540;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = acor_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))];
  }
  dup_ = _dvnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[2 + (3) * ((dls001_.nq_ - 1))];
  exup_ = 1.0e0 / (dls001_.l_ + 1);
  rhup_ = 1.0e0 / (1.4e0 * pow (dup_, exup_) + 0.0000014e0);
  _l540:;
  exsm_ = 1.0e0 / dls001_.l_;
  rhsm_ = 1.0e0 / (1.2e0 * pow (dsm_, exsm_) + 0.0000012e0);
  rhdn_ = 0.0;
  if (dls001_.nq_ == 1) {
    goto _l560;
  }
  ddn_ = _dvnorm (&dls001_.n_, &yh_[0 + ((*nyh_)) * ((dls001_.l_ - 1))], ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.nq_ - 
  1))];
  exdn_ = 1.0e0 / dls001_.nq_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  _l560:;
  if (rhsm_ >= rhup_) {
    goto _l570;
  }
  if (rhup_ > rhdn_) {
    goto _l590;
  }
  goto _l580;
  _l570:;
  if (rhsm_ < rhdn_) {
    goto _l580;
  }
  newq_ = dls001_.nq_;
  rh_ = rhsm_;
  goto _l620;
  _l580:;
  newq_ = dls001_.nq_ - 1;
  rh_ = rhdn_;
  if (dls001_.kflag_ < 0 && rh_ > 1.0e0) {
    rh_ = 1.0;
  }
  goto _l620;
  _l590:;
  newq_ = dls001_.l_;
  rh_ = rhup_;
  if (rh_ < 1.1e0) {
    goto _l610;
  }
  r_ = dls001_.el_[dls001_.l_ - 1] / dls001_.l_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((newq_ + 1 - 1))] = acor_[i_ - 1] * r_;
  }
  goto _l630;
  _l610:;
  dls001_.ialth_ = 3;
  goto _l700;
  _l620:;
  if ((dls001_.kflag_ == 0) && (rh_ < 1.1e0)) {
    goto _l610;
  }
  if (dls001_.kflag_ <= -2) {
    rh_ = _min (rh_, 0.2);
  }
  if (newq_ == dls001_.nq_) {
    goto _l170;
  }
  _l630:;
  dls001_.nq_ = newq_;
  dls001_.l_ = dls001_.nq_ + 1;
  iret_ = 2;
  goto _l150;
  _l640:;
  if (dls001_.kflag_ == -10) {
    goto _l660;
  }
  rh_ = 0.1;
  rh_ = _max (dls001_.hmin_ / _abs (dls001_.h_), rh_);
  dls001_.h_ = dls001_.h_ * rh_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((1))] = dls001_.h_ * savf_[i_ - 1];
  }
  dls001_.ipup_ = dls001_.miter_;
  dls001_.ialth_ = 5;
  if (dls001_.nq_ == 1) {
    goto _l200;
  }
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  iret_ = 3;
  goto _l150;
  _l660:;
  dls001_.kflag_ = -1;
  goto _l720;
  _l670:;
  dls001_.kflag_ = -2;
  goto _l720;
  _l680:;
  dls001_.kflag_ = -3;
  goto _l720;
  _l690:;
  dls001_.rmax_ = 10.0;
  _l700:;
  r_ = 1.0e0 / dls001_.tesco_[1 + (3) * ((dls001_.nqu_ - 1))];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] * r_;
  }
  _l720:;
  dls001_.hold_ = dls001_.h_;
  dls001_.jstart_ = 1;
  __calls[67].calls++;
  return 0;
}

int_4 _dstoka (int_4 _p_ neq_, real_8 _p_ y_, real_8 _p_ yh_, int_4 _p_ nyh_, real_8 _p_ yh1_, real_8 _p_ ewt_, real_8 
_p_ savf_, real_8 _p_ savx_, real_8 _p_ acor_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_f)(), int_4 (*_jac)(), real_4 
(*_psol)())
{
  static int_4 i_, i1_, iredo_, iret_, j_, jb_, jok_, m_, ncf_, newq_, nslow_;
  static real_8 dcon_, ddn_, del_, delp_, drc_, dsm_, dup_, exdn_, exsm_, exup_, dfnorm_, r_, rh_, rhdn_, rhsm_, rhup_, 
  roc_, stiff_, told_;
  dls001_.kflag_ = 0;
  told_ = dls001_.tn_;
  ncf_ = 0;
  dls001_.ierpj_ = 0;
  dls001_.iersl_ = 0;
  dls001_.jcur_ = 0;
  dls001_.icf_ = 0;
  delp_ = 0.0;
  if (dls001_.jstart_ > 0) {
    goto _l200;
  }
  if (dls001_.jstart_ == -1) {
    goto _l100;
  }
  if (dls001_.jstart_ == -2) {
    goto _l160;
  }
  dls001_.lmax_ = dls001_.maxord_ + 1;
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  dls001_.ialth_ = 2;
  dls001_.rmax_ = 10000.0;
  dls001_.rc_ = 0.0;
  dls001_.el0_ = 1.0;
  dls001_.crate_ = 0.7;
  dls001_.hold_ = dls001_.h_;
  dls001_.meo_ = dls001_.meth_;
  dls001_.nslp_ = 0;
  dls002_.nslj_ = 0;
  dls001_.ipup_ = 0;
  iret_ = 3;
  dls002_.newt_ = 0;
  dls002_.stifr_ = 0.0;
  goto _l140;
  _l100:;
  dls001_.ipup_ = dls001_.miter_;
  dls001_.lmax_ = dls001_.maxord_ + 1;
  if (dls001_.ialth_ == 1) {
    dls001_.ialth_ = 2;
  }
  if (dls001_.meth_ == dls001_.meo_) {
    goto _l110;
  }
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  dls001_.meo_ = dls001_.meth_;
  if (dls001_.nq_ > dls001_.maxord_) {
    goto _l120;
  }
  dls001_.ialth_ = dls001_.l_;
  iret_ = 1;
  goto _l150;
  _l110:;
  if (dls001_.nq_ <= dls001_.maxord_) {
    goto _l160;
  }
  _l120:;
  dls001_.nq_ = dls001_.maxord_;
  dls001_.l_ = dls001_.lmax_;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  dlpk01_.epcon_ = dls001_.conit_ * dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  ddn_ = _dvnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.l_ - 1))];
  exdn_ = 1.0e0 / dls001_.l_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  rh_ = _min (rhdn_, 1.0);
  iredo_ = 3;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l170;
  }
  rh_ = _min (rh_, _abs (dls001_.h_ / dls001_.hold_));
  dls001_.h_ = dls001_.hold_;
  goto _l175;
  _l140:;
  (void) _dcfode (&dls001_.meth_, dls001_.elco_, dls001_.tesco_);
  _l150:;
  for (i_ = 1; i_ <= dls001_.l_; (i_)++) {
    dls001_.el_[i_ - 1] = dls001_.elco_[i_ - 1 + (13) * ((dls001_.nq_ - 1))];
  }
  dls001_.nqnyh_ = dls001_.nq_ * (*nyh_);
  dls001_.rc_ = dls001_.rc_ * dls001_.el_[0] / dls001_.el0_;
  dls001_.el0_ = dls001_.el_[0];
  dls001_.conit_ = 0.5e0 / (dls001_.nq_ + 2);
  dlpk01_.epcon_ = dls001_.conit_ * dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  switch (iret_) {
    default:
    case 1: goto _l160;
    case 2: goto _l170;
    case 3: goto _l200;
  }
  _l160:;
  if (dls001_.h_ == dls001_.hold_) {
    goto _l200;
  }
  rh_ = dls001_.h_ / dls001_.hold_;
  dls001_.h_ = dls001_.hold_;
  iredo_ = 3;
  goto _l175;
  _l170:;
  rh_ = _max (rh_, dls001_.hmin_ / _abs (dls001_.h_));
  _l175:;
  rh_ = _min (rh_, dls001_.rmax_);
  rh_ = rh_ / _max (1.0, _abs (dls001_.h_) * dls001_.hmxi_ * rh_);
  r_ = 1.0;
  for (j_ = 2; j_ <= dls001_.l_; (j_)++) {
    r_ = r_ * rh_;
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] * r_;
    }
  }
  dls001_.h_ = dls001_.h_ * rh_;
  dls001_.rc_ = dls001_.rc_ * rh_;
  dls001_.ialth_ = dls001_.l_;
  if (iredo_ == 0) {
    goto _l690;
  }
  _l200:;
  if (dls002_.newt_ == 0 || dlpk01_.jacflg_ == 0) {
    drc_ = 0.0;
    dls001_.ipup_ = 0;
    dls001_.crate_ = 0.7;
  }
  else {
    drc_ = _abs (dls001_.rc_ - 1.0e0);
    if (drc_ > dls001_.ccmax_) {
      dls001_.ipup_ = dls001_.miter_;
    }
    if (dls001_.nst_ >= dls001_.nslp_ + dls001_.msbp_) {
      dls001_.ipup_ = dls001_.miter_;
    }
  }
  dls001_.tn_ = dls001_.tn_ + dls001_.h_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] + yh1_[i_ + (*nyh_) - 1];
    }
  }
  _l220:;
  m_ = 0;
  dlpk01_.mnewt_ = 0;
  stiff_ = 0.0;
  roc_ = 5.0e-2;
  nslow_ = 0;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  if (dls002_.newt_ == 0 || dls001_.ipup_ <= 0) {
    goto _l250;
  }
  jok_ = 1;
  if (dls001_.nst_ == 0 || dls001_.nst_ > dls002_.nslj_ + 50) {
    jok_ = -1;
  }
  if (dls001_.icf_ == 1 && drc_ < 0.2e0) {
    jok_ = -1;
  }
  if (dls001_.icf_ == 2) {
    jok_ = -1;
  }
  if (jok_ == -1) {
    dls002_.nslj_ = dls001_.nst_;
    dls002_.njev_ = dls002_.njev_ + 1;
  }
  (void) _dsetpk (neq_, y_, yh1_, ewt_, acor_, savf_, &jok_, wm_, iwm_, _f, _jac);
  dls001_.ipup_ = 0;
  dls001_.rc_ = 1.0;
  drc_ = 0.0;
  dls001_.nslp_ = dls001_.nst_;
  dls001_.crate_ = 0.7;
  if (dls001_.ierpj_ != 0) {
    goto _l430;
  }
  _l250:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = 0.0;
  }
  _l270:;
  if (dls002_.newt_ != 0) {
    goto _l350;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = dls001_.h_ * savf_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((1))];
    y_[i_ - 1] = savf_[i_ - 1] - acor_[i_ - 1];
  }
  del_ = _dvnorm (&dls001_.n_, y_, ewt_);
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + dls001_.el_[0] * savf_[i_ - 1];
    acor_[i_ - 1] = savf_[i_ - 1];
  }
  stiff_ = 1.0;
  goto _l400;
  _l350:;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savx_[i_ - 1] = dls001_.h_ * savf_[i_ - 1] - (yh_[i_ - 1 + ((*nyh_)) * ((1))] + acor_[i_ - 1]);
  }
  dfnorm_ = _dvnorm (&dls001_.n_, savx_, ewt_);
  (void) _dsolpk (neq_, y_, savf_, savx_, ewt_, wm_, iwm_, _f, _psol);
  if (dls001_.iersl_ < 0) {
    goto _l430;
  }
  if (dls001_.iersl_ > 0) {
    goto _l410;
  }
  del_ = _dvnorm (&dls001_.n_, savx_, ewt_);
  if (del_ > 1.0e-8) {
    stiff_ = _max (stiff_, dfnorm_ / del_);
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] + savx_[i_ - 1];
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))] + dls001_.el_[0] * acor_[i_ - 1];
  }
  _l400:;
  if (m_ != 0) {
    roc_ = _max (5.0e-2, del_ / delp_);
    dls001_.crate_ = _max (0.2e0 * dls001_.crate_, roc_);
  }
  dcon_ = del_ * _min (1.0, 1.5e0 * dls001_.crate_) / dlpk01_.epcon_;
  if (dcon_ <= 1.0e0) {
    goto _l450;
  }
  m_ = m_ + 1;
  if (m_ == dls001_.maxcor_) {
    goto _l410;
  }
  if (m_ >= 2 && del_ > 2.0e0 * delp_) {
    goto _l410;
  }
  if (roc_ > 10.0e0) {
    goto _l410;
  }
  if (roc_ > 0.8e0) {
    nslow_ = nslow_ + 1;
  }
  if (nslow_ >= 2) {
    goto _l410;
  }
  dlpk01_.mnewt_ = m_;
  delp_ = del_;
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  goto _l270;
  _l410:;
  dls001_.icf_ = 1;
  if (dls002_.newt_ == 0) {
    if (dls001_.nst_ == 0) {
      goto _l430;
    }
    if (dls001_.miter_ == 0) {
      goto _l430;
    }
    dls002_.newt_ = dls001_.miter_;
    dls002_.stifr_ = 1023.0;
    dls001_.ipup_ = dls001_.miter_;
    goto _l220;
  }
  if (dls001_.jcur_ == 1 || dlpk01_.jacflg_ == 0) {
    goto _l430;
  }
  dls001_.ipup_ = dls001_.miter_;
  goto _l220;
  _l430:;
  dls001_.icf_ = 2;
  ncf_ = ncf_ + 1;
  dlpk01_.ncfn_ = dlpk01_.ncfn_ + 1;
  dls001_.rmax_ = 2.0;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  if (dls001_.ierpj_ < 0 || dls001_.iersl_ < 0) {
    goto _l680;
  }
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l670;
  }
  if (ncf_ == dls001_.mxncf_) {
    goto _l670;
  }
  rh_ = 0.5;
  dls001_.ipup_ = dls001_.miter_;
  iredo_ = 1;
  goto _l170;
  _l450:;
  dls001_.jcur_ = 0;
  if (dls002_.newt_ > 0) {
    dls002_.stifr_ = 0.5e0 * (dls002_.stifr_ + stiff_);
  }
  if (m_ == 0) {
    dsm_ = del_ / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (m_ > 0) {
    dsm_ = _dvnorm (&dls001_.n_, acor_, ewt_) / dls001_.tesco_[1 + (3) * ((dls001_.nq_ - 1))];
  }
  if (dsm_ > 1.0e0) {
    goto _l500;
  }
  dls001_.kflag_ = 0;
  iredo_ = 0;
  dls001_.nst_ = dls001_.nst_ + 1;
  if (dls002_.newt_ == 0) {
    dls002_.nsfi_ = dls002_.nsfi_ + 1;
  }
  if (dls002_.newt_ > 0 && dls002_.stifr_ < 1.5e0) {
    dls002_.newt_ = 0;
  }
  dls001_.hu_ = dls001_.h_;
  dls001_.nqu_ = dls001_.nq_;
  for (j_ = 1; j_ <= dls001_.l_; (j_)++) {
    for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
      yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*nyh_)) * ((j_ - 1))] + dls001_.el_[j_ - 1] * acor_[i_ - 1];
    }
  }
  dls001_.ialth_ = dls001_.ialth_ - 1;
  if (dls001_.ialth_ == 0) {
    goto _l520;
  }
  if (dls001_.ialth_ > 1) {
    goto _l700;
  }
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l700;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))] = acor_[i_ - 1];
  }
  goto _l700;
  _l500:;
  dls001_.kflag_ = dls001_.kflag_ - 1;
  dls001_.tn_ = told_;
  i1_ = dls001_.nqnyh_ + 1;
  for (jb_ = 1; jb_ <= dls001_.nq_; (jb_)++) {
    i1_ = i1_ - (*nyh_);
    for (i_ = i1_; i_ <= dls001_.nqnyh_; (i_)++) {
      yh1_[i_ - 1] = yh1_[i_ - 1] - yh1_[i_ + (*nyh_) - 1];
    }
  }
  dls001_.rmax_ = 2.0;
  if (_abs (dls001_.h_) <= dls001_.hmin_ * 1.00001e0) {
    goto _l660;
  }
  if (dls001_.kflag_ <= -3) {
    goto _l640;
  }
  iredo_ = 2;
  rhup_ = 0.0;
  goto _l540;
  _l520:;
  rhup_ = 0.0;
  if (dls001_.l_ == dls001_.lmax_) {
    goto _l540;
  }
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    savf_[i_ - 1] = acor_[i_ - 1] - yh_[i_ - 1 + ((*nyh_)) * ((dls001_.lmax_ - 1))];
  }
  dup_ = _dvnorm (&dls001_.n_, savf_, ewt_) / dls001_.tesco_[2 + (3) * ((dls001_.nq_ - 1))];
  exup_ = 1.0e0 / (dls001_.l_ + 1);
  rhup_ = 1.0e0 / (1.4e0 * pow (dup_, exup_) + 0.0000014e0);
  _l540:;
  exsm_ = 1.0e0 / dls001_.l_;
  rhsm_ = 1.0e0 / (1.2e0 * pow (dsm_, exsm_) + 0.0000012e0);
  rhdn_ = 0.0;
  if (dls001_.nq_ == 1) {
    goto _l560;
  }
  ddn_ = _dvnorm (&dls001_.n_, &yh_[0 + ((*nyh_)) * ((dls001_.l_ - 1))], ewt_) / dls001_.tesco_[0 + (3) * ((dls001_.nq_ - 
  1))];
  exdn_ = 1.0e0 / dls001_.nq_;
  rhdn_ = 1.0e0 / (1.3e0 * pow (ddn_, exdn_) + 0.0000013e0);
  _l560:;
  if (rhsm_ >= rhup_) {
    goto _l570;
  }
  if (rhup_ > rhdn_) {
    goto _l590;
  }
  goto _l580;
  _l570:;
  if (rhsm_ < rhdn_) {
    goto _l580;
  }
  newq_ = dls001_.nq_;
  rh_ = rhsm_;
  goto _l620;
  _l580:;
  newq_ = dls001_.nq_ - 1;
  rh_ = rhdn_;
  if (dls001_.kflag_ < 0 && rh_ > 1.0e0) {
    rh_ = 1.0;
  }
  goto _l620;
  _l590:;
  newq_ = dls001_.l_;
  rh_ = rhup_;
  if (rh_ < 1.1e0) {
    goto _l610;
  }
  r_ = dls001_.el_[dls001_.l_ - 1] / dls001_.l_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((newq_ + 1 - 1))] = acor_[i_ - 1] * r_;
  }
  goto _l630;
  _l610:;
  dls001_.ialth_ = 3;
  goto _l700;
  _l620:;
  if ((dls001_.kflag_ == 0) && (rh_ < 1.1e0)) {
    goto _l610;
  }
  if (dls001_.kflag_ <= -2) {
    rh_ = _min (rh_, 0.2);
  }
  if (newq_ == dls001_.nq_) {
    goto _l170;
  }
  _l630:;
  dls001_.nq_ = newq_;
  dls001_.l_ = dls001_.nq_ + 1;
  iret_ = 2;
  goto _l150;
  _l640:;
  if (dls001_.kflag_ == -10) {
    goto _l660;
  }
  rh_ = 0.1;
  rh_ = _max (dls001_.hmin_ / _abs (dls001_.h_), rh_);
  dls001_.h_ = dls001_.h_ * rh_;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*nyh_)) * ((0))];
  }
  (void) _f (neq_, &dls001_.tn_, y_, savf_);
  dls001_.nfe_ = dls001_.nfe_ + 1;
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    yh_[i_ - 1 + ((*nyh_)) * ((1))] = dls001_.h_ * savf_[i_ - 1];
  }
  dls001_.ipup_ = dls001_.miter_;
  dls001_.ialth_ = 5;
  if (dls001_.nq_ == 1) {
    goto _l200;
  }
  dls001_.nq_ = 1;
  dls001_.l_ = 2;
  iret_ = 3;
  goto _l150;
  _l660:;
  dls001_.kflag_ = -1;
  goto _l720;
  _l670:;
  dls001_.kflag_ = -2;
  goto _l720;
  _l680:;
  dls001_.kflag_ = -3;
  goto _l720;
  _l690:;
  dls001_.rmax_ = 10.0;
  _l700:;
  r_ = 1.0e0 / dls001_.tesco_[1 + (3) * ((dls001_.nqu_ - 1))];
  for (i_ = 1; i_ <= dls001_.n_; (i_)++) {
    acor_[i_ - 1] = acor_[i_ - 1] * r_;
  }
  _l720:;
  dls001_.hold_ = dls001_.h_;
  dls001_.jstart_ = 1;
  __calls[68].calls++;
  return 0;
}

real_8 _dumach (void)
{
  static real_8 u_, comp_;
  real_8 $0_;
  real_8 dumach_;
  u_ = 1.0;
  _l10:;
  u_ = u_ * 0.5e0;
  (void) _dumsum (($0_ = 1.0, &$0_), &u_, &comp_);
  if (comp_ != 1.0e0) {
    goto _l10;
  }
  dumach_ = u_ * 2.0e0;
  __calls[69].calls++;
  return dumach_;
}

int_4 _dumsum (real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_)
{
  (*c_) = (*a_) + (*b_);
  __calls[70].calls++;
  return 0;
}

int_4 _dusol (int_4 _p_ neq_, real_8 _p_ tn_, real_8 _p_ y_, real_8 _p_ savf_, real_8 _p_ b_, real_8 _p_ wght_, int_4 
_p_ n_, real_8 _p_ delta_, real_8 _p_ hl0_, int_4 _p_ mnewt_, int_4 (*_psol)(), int_4 _p_ npsl_, real_8 _p_ x_, real_8 
_p_ wp_, int_4 _p_ iwp_, real_8 _p_ wk_, int_4 _p_ iflag_)
{
  static int_4 i_, ier_;
  static real_8 bnrm_;
  (*iflag_) = 0;
  (*npsl_) = 0;
  bnrm_ = _dvnorm (n_, b_, wght_);
  if (bnrm_ > (*delta_)) {
    goto _l30;
  }
  if ((*mnewt_) > 0) {
    goto _l10;
  }
  (void) _dcopy (n_, b_, &_k1, x_, &_k1);
  goto _l0;
  _l10:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_[i_ - 1] = 0.0;
  }
  goto _l0;
  _l30:;
  ier_ = 0;
  (void) _psol (neq_, tn_, y_, savf_, wk_, hl0_, wp_, iwp_, b_, &_k0, &ier_);
  (*npsl_) = 1;
  if (ier_ != 0) {
    goto _l100;
  }
  (void) _dcopy (n_, b_, &_k1, x_, &_k1);
  goto _l0;
  _l100:;
  if (ier_ < 0) {
    (*iflag_) = -1;
  }
  if (ier_ > 0) {
    (*iflag_) = 3;
  }
  _l0:;
  __calls[71].calls++;
  return 0;
}

real_8 _dvnorm (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ w_)
{
  static int_4 i_;
  static real_8 sum_;
  real_8 $0_;
  real_8 dvnorm_;
  sum_ = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    sum_ = sum_ + ($0_ = (v_[i_ - 1] * w_[i_ - 1]), $0_ * $0_);
  }
  dvnorm_ = sqrt (sum_ / (*n_));
  __calls[72].calls++;
  return dvnorm_;
}

int_4 _iumach (void)
{
  int_4 iumach_;
  iumach_ = 6;
  __calls[73].calls++;
  return iumach_;
}

int_4 _ixsav (int_4 _p_ ipar_, int_4 _p_ ivalue_, logical_4 _p_ iset_)
{
  static int_4 lunit_, mesflg_;
  int_4 _data_k_65, _data_k_66;
  int_4 ixsav_;
#define _data_n_65 1
  static int_4 _data_l_65[_data_n_65] = {
    -1
  };
#define _data_n_66 1
  static int_4 _data_l_66[_data_n_66] = {
    1
  };
  if (__calls[74].calls == 0) {
    _data_k_65 = 0;
    if (_data_k_65 >= _data_n_65) {
      _data_k_65 = 0;
    }
    lunit_ = _data_l_65[_data_k_65++];
    _data_k_66 = 0;
    if (_data_k_66 >= _data_n_66) {
      _data_k_66 = 0;
    }
    mesflg_ = _data_l_66[_data_k_66++];
  }
  if ((*ipar_) == 1) {
    if (lunit_ == -1) {
      lunit_ = _iumach ();
    }
    ixsav_ = lunit_;
    if ((*iset_)) {
      lunit_ = (*ivalue_);
    }
  }
  if ((*ipar_) == 2) {
    ixsav_ = mesflg_;
    if ((*iset_)) {
      mesflg_ = (*ivalue_);
    }
  }
  __calls[74].calls++;
  return ixsav_;
}

int_4 _jgroup (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ maxg_, int_4 _p_ ngrp_, int_4 _p_ igp_, int_4 _p_ 
jgp_, int_4 _p_ incl_, int_4 _p_ jdone_, int_4 _p_ ier_)
{
  static int_4 i_, j_, k_, kmin_, kmax_, ncol_, ng_;
  (*ier_) = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    jdone_[j_ - 1] = 0;
  }
  ncol_ = 1;
  for (ng_ = 1; ng_ <= (*maxg_); (ng_)++) {
    igp_[ng_ - 1] = ncol_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      incl_[i_ - 1] = 0;
    }
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      if (jdone_[j_ - 1] == 1) {
        goto _l50;
      }
      kmin_ = ia_[j_ - 1];
      kmax_ = ia_[j_ + 1 - 1] - 1;
      for (k_ = kmin_; k_ <= kmax_; (k_)++) {
        i_ = ja_[k_ - 1];
        if (incl_[i_ - 1] == 1) {
          goto _l50;
        }
      }
      jgp_[ncol_ - 1] = j_;
      ncol_ = ncol_ + 1;
      jdone_[j_ - 1] = 1;
      for (k_ = kmin_; k_ <= kmax_; (k_)++) {
        i_ = ja_[k_ - 1];
        incl_[i_ - 1] = 1;
      }
      _l50:;
    }
    if (ncol_ == igp_[ng_ - 1]) {
      goto _l70;
    }
  }
  if (ncol_ <= (*n_)) {
    goto _l80;
  }
  ng_ = (*maxg_);
  _l70:;
  (*ngrp_) = ng_ - 1;
  goto _l0;
  _l80:;
  (*ier_) = 1;
  _l0:;
  __calls[75].calls++;
  return 0;
}

int_4 _odrv (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ a_, int_4 _p_ p_, int_4 _p_ ip_, int_4 _p_ nsp_, 
int_4 _p_ isp_, int_4 _p_ path_, int_4 _p_ flag_)
{
  static int_4 v_, l_, head_, tmp_, q_, max_, next_;
  static logical_4 dflag_;
  (*flag_) = 0;
  if ((*path_) < 1 || 5 < (*path_)) {
    goto _l111;
  }
  if (((*path_) - 1) * ((*path_) - 2) * ((*path_) - 4) != 0) {
    goto _l1;
  }
  max_ = ((*nsp_) - (*n_)) / 2;
  v_ = 1;
  l_ = v_ + max_;
  head_ = l_ + max_;
  next_ = head_ + (*n_);
  if (max_ < (*n_)) {
    goto _l110;
  }
  (void) _md (n_, ia_, ja_, &max_, &isp_[v_ - 1], &isp_[l_ - 1], &isp_[head_ - 1], p_, ip_, &isp_[v_ - 1], flag_);
  if ((*flag_) != 0) {
    goto _l100;
  }
  _l1:;
  if (((*path_) - 2) * ((*path_) - 3) * ((*path_) - 4) * ((*path_) - 5) != 0) {
    goto _l2;
  }
  tmp_ = ((*nsp_) + 1) - (*n_);
  q_ = tmp_ - (ia_[(*n_) + 1 - 1] - 1);
  if (q_ < 1) {
    goto _l110;
  }
  dflag_ = (*path_) == 4 || (*path_) == 5;
  (void) _sro (n_, ip_, ia_, ja_, a_, &isp_[tmp_ - 1], &isp_[q_ - 1], &dflag_);
  _l2:;
  goto _l0;
  _l100:;
  goto _l0;
  _l110:;
  (*flag_) = 10 * (*n_) + 1;
  goto _l0;
  _l111:;
  (*flag_) = 11 * (*n_) + 1;
  _l0:;
  __calls[76].calls++;
  return 0;
}

int_4 _md (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ max_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ head_, 
int_4 _p_ last_, int_4 _p_ next_, int_4 _p_ mark_, int_4 _p_ flag_)
{
  static int_4 tag_, dmin_, vk_, tail_, k_;
  static int_4 _p_ const ek_ = (int_4 _p_) &(vk_);
  tag_ = 0;
  (void) _mdi (n_, ia_, ja_, max_, v_, l_, head_, last_, next_, mark_, &tag_, flag_);
  if ((*flag_) != 0) {
    goto _l0;
  }
  k_ = 0;
  dmin_ = 1;
  _l1:;
  if (k_ >= (*n_)) {
    goto _l4;
  }
  _l2:;
  if (head_[dmin_ - 1] > 0) {
    goto _l3;
  }
  dmin_ = dmin_ + 1;
  goto _l2;
  _l3:;
  vk_ = head_[dmin_ - 1];
  head_[dmin_ - 1] = next_[vk_ - 1];
  if (head_[dmin_ - 1] > 0) {
    last_[head_[dmin_ - 1] - 1] = -dmin_;
  }
  k_ = k_ + 1;
  next_[vk_ - 1] = -k_;
  last_[(*ek_) - 1] = dmin_ - 1;
  tag_ = tag_ + last_[(*ek_) - 1];
  mark_[vk_ - 1] = tag_;
  (void) _mdm (&vk_, &tail_, v_, l_, last_, next_, mark_);
  (void) _mdp (&k_, ek_, &tail_, v_, l_, head_, last_, next_, mark_);
  (void) _mdu (ek_, &dmin_, v_, l_, head_, last_, next_, mark_);
  goto _l1;
  _l4:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    next_[k_ - 1] = -next_[k_ - 1];
    last_[next_[k_ - 1] - 1] = k_;
  }
  _l0:;
  __calls[77].calls++;
  return 0;
}

int_4 _mdi (int_4 _p_ n_, int_4 _p_ ia_, int_4 _p_ ja_, int_4 _p_ max_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ head_, 
int_4 _p_ last_, int_4 _p_ next_, int_4 _p_ mark_, int_4 _p_ tag_, int_4 _p_ flag_)
{
  static int_4 sfs_, vi_, dvi_, vj_, jmin_, jmax_, j_, lvk_, kmax_, k_, nextvi_;
  int_4 $0_;
  for (vi_ = 1; vi_ <= (*n_); (vi_)++) {
    mark_[vi_ - 1] = 1;
    l_[vi_ - 1] = 0;
    head_[vi_ - 1] = 0;
  }
  sfs_ = (*n_) + 1;
  for (vi_ = 1; vi_ <= (*n_); (vi_)++) {
    jmin_ = ia_[vi_ - 1];
    jmax_ = ia_[vi_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l6;
    }
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      vj_ = ja_[j_ - 1];
      $0_ = vj_ - vi_;
      if ($0_ < 0) {
        goto _l2;
      } else if ($0_ == 0) {
        goto _l5;
      } else {
        goto _l4;
      }
      _l2:;
      lvk_ = vi_;
      kmax_ = mark_[vi_ - 1] - 1;
      if (kmax_ == 0) {
        goto _l4;
      }
      for (k_ = 1; k_ <= kmax_; (k_)++) {
        lvk_ = l_[lvk_ - 1];
        if (v_[lvk_ - 1] == vj_) {
          goto _l5;
        }
      }
      _l4:;
      if (sfs_ >= (*max_)) {
        goto _l101;
      }
      mark_[vi_ - 1] = mark_[vi_ - 1] + 1;
      v_[sfs_ - 1] = vj_;
      l_[sfs_ - 1] = l_[vi_ - 1];
      l_[vi_ - 1] = sfs_;
      sfs_ = sfs_ + 1;
      mark_[vj_ - 1] = mark_[vj_ - 1] + 1;
      v_[sfs_ - 1] = vi_;
      l_[sfs_ - 1] = l_[vj_ - 1];
      l_[vj_ - 1] = sfs_;
      sfs_ = sfs_ + 1;
      _l5:;
    }
    _l6:;
  }
  for (vi_ = 1; vi_ <= (*n_); (vi_)++) {
    dvi_ = mark_[vi_ - 1];
    next_[vi_ - 1] = head_[dvi_ - 1];
    head_[dvi_ - 1] = vi_;
    last_[vi_ - 1] = -dvi_;
    nextvi_ = next_[vi_ - 1];
    if (nextvi_ > 0) {
      last_[nextvi_ - 1] = vi_;
    }
    mark_[vi_ - 1] = (*tag_);
  }
  goto _l0;
  _l101:;
  (*flag_) = 9 * (*n_) + vi_;
  _l0:;
  __calls[78].calls++;
  return 0;
}

int_4 _mdm (int_4 _p_ vk_, int_4 _p_ tail_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ last_, int_4 _p_ next_, int_4 _p_ 
mark_)
{
  static int_4 tag_, s_, ls_, vs_, b_, lb_, vb_, blp_, blpmax_;
  static int_4 _p_ const es_ = (int_4 _p_) &(vs_);
  tag_ = mark_[(*vk_) - 1];
  (*tail_) = (*vk_);
  ls_ = l_[(*vk_) - 1];
  _l1:;
  s_ = ls_;
  if (s_ == 0) {
    goto _l5;
  }
  ls_ = l_[s_ - 1];
  vs_ = v_[s_ - 1];
  if (next_[vs_ - 1] < 0) {
    goto _l2;
  }
  mark_[vs_ - 1] = tag_;
  l_[(*tail_) - 1] = s_;
  (*tail_) = s_;
  goto _l4;
  _l2:;
  lb_ = l_[(*es_) - 1];
  blpmax_ = last_[(*es_) - 1];
  for (blp_ = 1; blp_ <= blpmax_; (blp_)++) {
    b_ = lb_;
    lb_ = l_[b_ - 1];
    vb_ = v_[b_ - 1];
    if (mark_[vb_ - 1] >= tag_) {
      goto _l3;
    }
    mark_[vb_ - 1] = tag_;
    l_[(*tail_) - 1] = b_;
    (*tail_) = b_;
    _l3:;
  }
  mark_[(*es_) - 1] = tag_;
  _l4:;
  goto _l1;
  _l5:;
  l_[(*tail_) - 1] = 0;
  __calls[79].calls++;
  return 0;
}

int_4 _mdp (int_4 _p_ k_, int_4 _p_ ek_, int_4 _p_ tail_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ head_, int_4 _p_ last_, 
int_4 _p_ next_, int_4 _p_ mark_)
{
  static int_4 tag_, free_, li_, vi_, lvi_, evi_, s_, ls_, es_, ilp_, ilpmax_, i_;
  tag_ = mark_[(*ek_) - 1];
  li_ = (*ek_);
  ilpmax_ = last_[(*ek_) - 1];
  if (ilpmax_ <= 0) {
    goto _l12;
  }
  for (ilp_ = 1; ilp_ <= ilpmax_; (ilp_)++) {
    i_ = li_;
    li_ = l_[i_ - 1];
    vi_ = v_[li_ - 1];
    if (last_[vi_ - 1] == 0) {
      goto _l3;
    }
    if (last_[vi_ - 1] > 0) {
      goto _l1;
    }
    head_[-last_[vi_ - 1] - 1] = next_[vi_ - 1];
    goto _l2;
    _l1:;
    next_[last_[vi_ - 1] - 1] = next_[vi_ - 1];
    _l2:;
    if (next_[vi_ - 1] > 0) {
      last_[next_[vi_ - 1] - 1] = last_[vi_ - 1];
    }
    _l3:;
    ls_ = vi_;
    _l4:;
    s_ = ls_;
    ls_ = l_[s_ - 1];
    if (ls_ == 0) {
      goto _l6;
    }
    es_ = v_[ls_ - 1];
    if (mark_[es_ - 1] < tag_) {
      goto _l5;
    }
    free_ = ls_;
    l_[s_ - 1] = l_[ls_ - 1];
    ls_ = s_;
    _l5:;
    goto _l4;
    _l6:;
    lvi_ = l_[vi_ - 1];
    if (lvi_ != 0) {
      goto _l7;
    }
    l_[i_ - 1] = l_[li_ - 1];
    li_ = i_;
    (*k_) = (*k_) + 1;
    next_[vi_ - 1] = -(*k_);
    last_[(*ek_) - 1] = last_[(*ek_) - 1] - 1;
    goto _l11;
    _l7:;
    if (l_[lvi_ - 1] != 0) {
      goto _l9;
    }
    evi_ = v_[lvi_ - 1];
    if (next_[evi_ - 1] >= 0) {
      goto _l9;
    }
    if (mark_[evi_ - 1] < 0) {
      goto _l8;
    }
    last_[vi_ - 1] = evi_;
    mark_[evi_ - 1] = -1;
    l_[(*tail_) - 1] = li_;
    (*tail_) = li_;
    l_[i_ - 1] = l_[li_ - 1];
    li_ = i_;
    goto _l10;
    _l8:;
    last_[vi_ - 1] = 0;
    mark_[evi_ - 1] = mark_[evi_ - 1] - 1;
    goto _l10;
    _l9:;
    last_[vi_ - 1] = -(*ek_);
    _l10:;
    v_[free_ - 1] = (*ek_);
    l_[free_ - 1] = l_[vi_ - 1];
    l_[vi_ - 1] = free_;
    _l11:;
  }
  _l12:;
  l_[(*tail_) - 1] = 0;
  __calls[80].calls++;
  return 0;
}

int_4 _mdu (int_4 _p_ ek_, int_4 _p_ dmin_, int_4 _p_ v_, int_4 _p_ l_, int_4 _p_ head_, int_4 _p_ last_, int_4 _p_ 
next_, int_4 _p_ mark_)
{
  static int_4 tag_, vi_, evi_, dvi_, s_, vs_, b_, vb_, ilp_, ilpmax_, blp_, blpmax_, i_;
  int_4 $0_;
  static int_4 _p_ const es_ = (int_4 _p_) &(vs_);
  tag_ = mark_[(*ek_) - 1] - last_[(*ek_) - 1];
  i_ = (*ek_);
  ilpmax_ = last_[(*ek_) - 1];
  if (ilpmax_ <= 0) {
    goto _l11;
  }
  for (ilp_ = 1; ilp_ <= ilpmax_; (ilp_)++) {
    i_ = l_[i_ - 1];
    vi_ = v_[i_ - 1];
    $0_ = last_[vi_ - 1];
    if ($0_ < 0) {
      goto _l1;
    } else if ($0_ == 0) {
      goto _l10;
    } else {
      goto _l8;
    }
    _l1:;
    tag_ = tag_ + 1;
    dvi_ = last_[(*ek_) - 1];
    s_ = l_[vi_ - 1];
    _l2:;
    s_ = l_[s_ - 1];
    if (s_ == 0) {
      goto _l9;
    }
    vs_ = v_[s_ - 1];
    if (next_[vs_ - 1] < 0) {
      goto _l3;
    }
    mark_[vs_ - 1] = tag_;
    dvi_ = dvi_ + 1;
    goto _l5;
    _l3:;
    if (mark_[(*es_) - 1] < 0) {
      goto _l6;
    }
    b_ = (*es_);
    blpmax_ = last_[(*es_) - 1];
    for (blp_ = 1; blp_ <= blpmax_; (blp_)++) {
      b_ = l_[b_ - 1];
      vb_ = v_[b_ - 1];
      if (mark_[vb_ - 1] >= tag_) {
        goto _l4;
      }
      mark_[vb_ - 1] = tag_;
      dvi_ = dvi_ + 1;
      _l4:;
    }
    _l5:;
    goto _l2;
    _l6:;
    last_[vi_ - 1] = 0;
    mark_[(*es_) - 1] = mark_[(*es_) - 1] - 1;
    _l7:;
    s_ = l_[s_ - 1];
    if (s_ == 0) {
      goto _l10;
    }
    (*es_) = v_[s_ - 1];
    if (mark_[(*es_) - 1] < 0) {
      mark_[(*es_) - 1] = mark_[(*es_) - 1] - 1;
    }
    goto _l7;
    _l8:;
    evi_ = last_[vi_ - 1];
    dvi_ = last_[(*ek_) - 1] + last_[evi_ - 1] + mark_[evi_ - 1];
    mark_[evi_ - 1] = 0;
    _l9:;
    next_[vi_ - 1] = head_[dvi_ - 1];
    head_[dvi_ - 1] = vi_;
    last_[vi_ - 1] = -dvi_;
    if (next_[vi_ - 1] > 0) {
      last_[next_[vi_ - 1] - 1] = vi_;
    }
    if (dvi_ < (*dmin_)) {
      (*dmin_) = dvi_;
    }
    _l10:;
  }
  _l11:;
  __calls[81].calls++;
  return 0;
}

int_4 _sro (int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ ia_, int_4 _p_ ja_, real_8 _p_ a_, int_4 _p_ q_, int_4 _p_ r_, 
logical_4 _p_ dflag_)
{
  static int_4 i_, jmin_, jmax_, j_, k_, ilast_, jdummy_, jak_;
  static real_8 ak_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    q_[i_ - 1] = 0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    jmin_ = ia_[i_ - 1];
    jmax_ = ia_[i_ + 1 - 1] - 1;
    if (jmin_ > jmax_) {
      goto _l3;
    }
    for (j_ = jmin_; j_ <= jmax_; (j_)++) {
      k_ = ja_[j_ - 1];
      if (ip_[k_ - 1] < ip_[i_ - 1]) {
        ja_[j_ - 1] = i_;
      }
      if (ip_[k_ - 1] >= ip_[i_ - 1]) {
        k_ = i_;
      }
      r_[j_ - 1] = k_;
      q_[k_ - 1] = q_[k_ - 1] + 1;
    }
    _l3:;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ia_[i_ + 1 - 1] = ia_[i_ - 1] + q_[i_ - 1];
    q_[i_ - 1] = ia_[i_ + 1 - 1];
  }
  ilast_ = 0;
  jmin_ = ia_[0];
  jmax_ = ia_[(*n_) + 1 - 1] - 1;
  j_ = jmax_;
  for (jdummy_ = jmin_; jdummy_ <= jmax_; (jdummy_)++) {
    i_ = r_[j_ - 1];
    if (! ((*dflag_)) || ja_[j_ - 1] != i_ || i_ == ilast_) {
      goto _l5;
    }
    r_[j_ - 1] = ia_[i_ - 1];
    ilast_ = i_;
    goto _l6;
    _l5:;
    q_[i_ - 1] = q_[i_ - 1] - 1;
    r_[j_ - 1] = q_[i_ - 1];
    _l6:;
    j_ = j_ - 1;
  }
  for (j_ = jmin_; j_ <= jmax_; (j_)++) {
    _l7:;
    if (r_[j_ - 1] == j_) {
      goto _l8;
    }
    k_ = r_[j_ - 1];
    r_[j_ - 1] = r_[k_ - 1];
    r_[k_ - 1] = k_;
    jak_ = ja_[k_ - 1];
    ja_[k_ - 1] = ja_[j_ - 1];
    ja_[j_ - 1] = jak_;
    ak_ = a_[k_ - 1];
    a_[k_ - 1] = a_[j_ - 1];
    a_[j_ - 1] = ak_;
    goto _l7;
    _l8:;
  }
  __calls[82].calls++;
  return 0;
}

int_4 _xerrwd (char _p_ msg_, int_4 _p_ nmes_, int_4 _p_ nerr_, int_4 _p_ level_, int_4 _p_ ni_, int_4 _p_ i1_, int_4 
_p_ i2_, int_4 _p_ nr_, real_8 _p_ r1_, real_8 _p_ r2_)
{
  static int_4 lunit_, mesflg_;
  int_4 $1_, $u_3_, __fcnt, __rc, $u_4_, $u_5_, $u_6_, $u_7_;
  logical_4 $0_, $2_;
  static FORMAT $f_10_[] = {
    FMT_TEXT, _dc_406, _dc_406,
    FMT_CHAR,"%s","%s",
    NULL, NULL, NULL
  };
  static FORMAT $f_20_[] = {
    FMT_TEXT, _dc_407, _dc_407,
    FMT_TEXT, _dc_408, _dc_408,
    FMT_INT,"%10d","%10d",
    NULL, NULL, NULL
  };
  static FORMAT $f_30_[] = {
    FMT_TEXT, _dc_407, _dc_407,
    FMT_TEXT, _dc_408, _dc_408,
    FMT_INT,"%10d","%10d",
    FMT_TEXT, _dc_409, _dc_409,
    FMT_TEXT, _dc_410, _dc_410,
    FMT_INT,"%10d","%10d",
    NULL, NULL, NULL
  };
  static FORMAT $f_40_[] = {
    FMT_TEXT, _dc_407, _dc_407,
    FMT_TEXT, _dc_411, _dc_411,
    FMT_REAL,"%21e","%21.13.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_50_[] = {
    FMT_TEXT, _dc_407, _dc_407,
    FMT_TEXT, _dc_412, _dc_412,
    FMT_REAL,"%21e","%21.13.0e",
    FMT_TEXT, _dc_409, _dc_409,
    FMT_TEXT, _dc_413, _dc_413,
    FMT_REAL,"%21e","%21.13.0e",
    NULL, NULL, NULL
  };
  lunit_ = _ixsav (&_k1, &_k0, ($0_ = FALSE, &$0_));
  mesflg_ = _ixsav (($1_ = 2, &$1_), &_k0, ($2_ = FALSE, &$2_));
  if (mesflg_ == 0) {
    goto _l100;
  }
  $u_3_ = lunit_;
  _fcheck ("odepack:xerrwd:79", $u_3_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_10_[__fcnt] != NULL && $f_10_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_3_, $f_10_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_3_, _ioerr_write ("odepack:xerrwd:79", $u_3_));
    __fcnt += 3;
  }
  if ($f_10_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_3_].unit, "\n");
    while ($f_10_[__fcnt] != NULL && $f_10_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_3_, $f_10_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_3_, _ioerr_write ("odepack:xerrwd:79", $u_3_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_3_, $f_10_[__fcnt + 2], msg_, CHARACTER, 0);
  _write_err (__rc, $u_3_, _ioerr_write ("odepack:xerrwd:79", $u_3_));
  __fcnt += 3;
  while ($f_10_[__fcnt] != NULL && $f_10_[__fcnt] == FMT_TEXT) {
    if ($f_10_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_3_, $f_10_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_3_, _ioerr_write ("odepack:xerrwd:79", $u_3_));
    __fcnt += 3;
  }
  _write_eol ($u_3_);
  _l10:;
  if ((*ni_) == 1) {
    $u_4_ = lunit_;
    _fcheck ("odepack:xerrwd:81", $u_4_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_20_[__fcnt] != NULL && $f_20_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_4_, $f_20_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_4_, _ioerr_write ("odepack:xerrwd:81", $u_4_));
      __fcnt += 3;
    }
    if ($f_20_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_4_].unit, "\n");
      while ($f_20_[__fcnt] != NULL && $f_20_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_4_, $f_20_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_4_, _ioerr_write ("odepack:xerrwd:81", $u_4_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_4_, $f_20_[__fcnt + 2], &(*i1_), INTEGER, 4);
    _write_err (__rc, $u_4_, _ioerr_write ("odepack:xerrwd:81", $u_4_));
    __fcnt += 3;
    while ($f_20_[__fcnt] != NULL && $f_20_[__fcnt] == FMT_TEXT) {
      if ($f_20_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_4_, $f_20_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_4_, _ioerr_write ("odepack:xerrwd:81", $u_4_));
      __fcnt += 3;
    }
    _write_eol ($u_4_);
  }
  _l20:;
  if ((*ni_) == 2) {
    $u_5_ = lunit_;
    _fcheck ("odepack:xerrwd:83", $u_5_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_30_[__fcnt] != NULL && $f_30_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_5_, $f_30_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odepack:xerrwd:83", $u_5_));
      __fcnt += 3;
    }
    if ($f_30_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_30_[__fcnt] != NULL && $f_30_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_30_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odepack:xerrwd:83", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_30_[__fcnt + 2], &(*i1_), INTEGER, 4);
    _write_err (__rc, $u_5_, _ioerr_write ("odepack:xerrwd:83", $u_5_));
    __fcnt += 3;
    while ($f_30_[__fcnt] != NULL && $f_30_[__fcnt] == FMT_TEXT) {
      if ($f_30_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_30_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odepack:xerrwd:83", $u_5_));
      __fcnt += 3;
    }
    if ($f_30_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_30_[__fcnt] != NULL && $f_30_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_30_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odepack:xerrwd:83", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_30_[__fcnt + 2], &(*i2_), INTEGER, 4);
    _write_err (__rc, $u_5_, _ioerr_write ("odepack:xerrwd:83", $u_5_));
    __fcnt += 3;
    while ($f_30_[__fcnt] != NULL && $f_30_[__fcnt] == FMT_TEXT) {
      if ($f_30_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_30_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odepack:xerrwd:83", $u_5_));
      __fcnt += 3;
    }
    _write_eol ($u_5_);
  }
  _l30:;
  if ((*nr_) == 1) {
    $u_6_ = lunit_;
    _fcheck ("odepack:xerrwd:85", $u_6_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_40_[__fcnt] != NULL && $f_40_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_6_, $f_40_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_6_, _ioerr_write ("odepack:xerrwd:85", $u_6_));
      __fcnt += 3;
    }
    if ($f_40_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_6_].unit, "\n");
      while ($f_40_[__fcnt] != NULL && $f_40_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_6_, $f_40_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odepack:xerrwd:85", $u_6_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_6_, $f_40_[__fcnt + 2], &(*r1_), REAL, 8);
    _write_err (__rc, $u_6_, _ioerr_write ("odepack:xerrwd:85", $u_6_));
    __fcnt += 3;
    while ($f_40_[__fcnt] != NULL && $f_40_[__fcnt] == FMT_TEXT) {
      if ($f_40_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_6_, $f_40_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_6_, _ioerr_write ("odepack:xerrwd:85", $u_6_));
      __fcnt += 3;
    }
    _write_eol ($u_6_);
  }
  _l40:;
  if ((*nr_) == 2) {
    $u_7_ = lunit_;
    _fcheck ("odepack:xerrwd:87", $u_7_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_50_[__fcnt] != NULL && $f_50_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_7_, $f_50_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_7_, _ioerr_write ("odepack:xerrwd:87", $u_7_));
      __fcnt += 3;
    }
    if ($f_50_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_7_].unit, "\n");
      while ($f_50_[__fcnt] != NULL && $f_50_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_7_, $f_50_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odepack:xerrwd:87", $u_7_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_7_, $f_50_[__fcnt + 2], &(*r1_), REAL, 8);
    _write_err (__rc, $u_7_, _ioerr_write ("odepack:xerrwd:87", $u_7_));
    __fcnt += 3;
    while ($f_50_[__fcnt] != NULL && $f_50_[__fcnt] == FMT_TEXT) {
      if ($f_50_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_7_, $f_50_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_7_, _ioerr_write ("odepack:xerrwd:87", $u_7_));
      __fcnt += 3;
    }
    if ($f_50_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_7_].unit, "\n");
      while ($f_50_[__fcnt] != NULL && $f_50_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_7_, $f_50_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odepack:xerrwd:87", $u_7_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_7_, $f_50_[__fcnt + 2], &(*r2_), REAL, 8);
    _write_err (__rc, $u_7_, _ioerr_write ("odepack:xerrwd:87", $u_7_));
    __fcnt += 3;
    while ($f_50_[__fcnt] != NULL && $f_50_[__fcnt] == FMT_TEXT) {
      if ($f_50_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_7_, $f_50_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_7_, _ioerr_write ("odepack:xerrwd:87", $u_7_));
      __fcnt += 3;
    }
    _write_eol ($u_7_);
  }
  _l50:;
  _l100:;
  if ((*level_) != 2) {
    goto _l0;
  }
  exit (EXIT_SUCCESS);
  _l0:;
  __calls[83].calls++;
  return 0;
}

