//! @file mathlib-odrpack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 63 subprograms from ODRPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// DACCES DC_89  DHSTEP DJCKC  DMPREC DODPC1 DODPE3 DODVCV DSCALE DVEVTR
// DC_106 DESUBI DIFIX  DJCKF  DODCHK DODPC2 DODPER DPACK  DSCLB  DWGHT
// DC_161 DETAF  DINIWK DJCKM  DODCNT DODPC3 DODPHD DPPNML DSCLD  DWINF
// DC_179 DEVJAC DIWINF DJCKZ  DODDRV DODPCR DODR   DPPT   DSETN  DXMY
// DC_190 DFCTR  DJACCD DLUNC  DODLM  DODPE1 DODRC  DPVB   DSOLVE DXPY
// DC_396 DFCTRW DJACFD DLUNO  DODMN  DODPE2 DODSTP DPVD   DUNPAC DZERO
// DC_65  DFLAGS DJCK

// ODRPACK 2.01 -- Software for Weighted Orthogonal Distance Regression
// 
// ODRPACK originates from the National Institute of Standards and Technology.
// The source code for ODRPACK was retrieved from:
// 
//   netlib.org/odrpack
// 
// ODRPACK currently lives on for instance in Python library scipy.odr.
// 
// VIF only includes the double precision version of ODRPACK.
// 
// The code needed trivial adaptation for use with VIF - the only modification 
// needed was to replace the variable name 'UNIT' that is a reserved word in VIF, 
// with 'FILENO'.
// 

// The license for ODRPACK Fortran source code is:
//
// NIST-developed software is provided by NIST as a public service. You may use, 
// copy and distribute copies of the software in any medium, provided that you 
// keep intact this entire notice. You may improve, modify and create derivative 
// works of the software or any portion of the software, and you may copy and 
// distribute such modifications or works. Modified works should carry a notice 
// stating that you changed the software and should note the date and nature of 
// any such change. Please explicitly acknowledge the National Institute of 
// Standards and Technology as the source of the software.
// 
// NIST-developed software is expressly provided "AS IS." NIST MAKES NO WARRANTY 
// OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
// INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
// FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
// REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
// UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
// NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
// THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
// RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
// 
// You are solely responsible for determining the appropriateness of using and 
// distributing the software and you assume all risks associated with its use, 
// including but not limited to the risks and costs of program errors, compliance 
// with applicable laws, damage to or loss of data, programs or equipment, and the 
// unavailability or interruption of operation. This software is not intended to 
// be used in any situation where a failure could cause risk of injury or damage 
// to property. The software developed by NIST employees is not subject to 
// copyright protection within the United States.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "   no"
#define _dc_1 "  yes"
#define _dc_2 "    unchecked"
#define _dc_3 "     verified"
#define _dc_4 " questionable"
#define _dc_5 "             "
#define _dc_6 "1,"
#define _dc_7 "n,"
#define _dc_8 " --- problem size:"
#define _dc_9 "            n = "
#define _dc_10 "          (number with nonzero weight = "
#define _dc_11 ")"
#define _dc_12 "           nq = "
#define _dc_13 "            m = "
#define _dc_14 "           np = "
#define _dc_15 "          (number unfixed = "
#define _dc_16 " --- control values:"
#define _dc_17 "          job = "
#define _dc_18 "              = abcde, where"
#define _dc_19 "                       a="
#define _dc_20 " ==> fit is a restart."
#define _dc_21 " ==> fit is not a restart."
#define _dc_22 "                       b="
#define _dc_23 " ==> deltas are initialized"
#define _dc_24 " to zero."
#define _dc_25 " by user."
#define _dc_26 " ==> deltas are fixed at"
#define _dc_27 " zero since e="
#define _dc_28 "."
#define _dc_29 "                       c="
#define _dc_30 " ==> covariance matrix will"
#define _dc_31 " be computed using"
#define _dc_32 "                               derivatives re-"
#define _dc_33 "evaluated at the solution."
#define _dc_34 "                               derivatives from the"
#define _dc_35 " last iteration."
#define _dc_36 " not be computed."
#define _dc_37 "                       d="
#define _dc_38 " ==> derivatives are"
#define _dc_39 " supplied by user."
#define _dc_40 "                               derivatives were checked."
#define _dc_41 "                               results appear questionable."
#define _dc_42 "                               results appear correct."
#define _dc_43 "                               derivatives were not"
#define _dc_44 " checked."
#define _dc_45 " estimated by central"
#define _dc_46 " differences."
#define _dc_47 " estimated by forward"
#define _dc_48 "                       e="
#define _dc_49 " ==> method is implicit odr."
#define _dc_50 " ==> method is explicit odr."
#define _dc_51 " ==> method is explicit ols."
#define _dc_52 "       ndigit = "
#define _dc_53 "          (estimated by odrpack)"
#define _dc_54 "          (supplied by user)"
#define _dc_55 "       taufac = "
#define _dc_56 " --- stopping criteria:"
#define _dc_57 "        sstol = "
#define _dc_58 "   (sum of squares stopping tolerance)"
#define _dc_59 "       partol = "
#define _dc_60 "   (parameter stopping tolerance)"
#define _dc_61 "        maxit = "
#define _dc_62 "          (maximum number of iterations)"
#define _dc_63 " --- initial sum of squared weighted deltas ="
#define _dc_64 "                 "
#define _dc_65 "         initial penalty function value     ="
#define _dc_66 "                 penalty term               ="
#define _dc_67 "                 penalty parameter          ="
#define _dc_68 " --- initial weighted sum of squares        ="
#define _dc_69 "         sum of squared weighted deltas     ="
#define _dc_70 "         sum of squared weighted epsilons   ="
#define _dc_71 " --- explanatory variable and delta weight summary:"
#define _dc_72 " --- explanatory variable summary:"
#define _dc_73 "       index      x(i,j)  delta(i,j)    fixed"
#define _dc_74 "     scale    weight    derivative"
#define _dc_75 "                                             "
#define _dc_76 "                        assessment"
#define _dc_77 "       (i,j)                          (ifixx)"
#define _dc_78 "    (scld)      (wd)              "
#define _dc_79 "     scale    weight              "
#define _dc_80 "                                  "
#define _dc_81 "                         step size"
#define _dc_82 "    (scld)      (wd)        (stpd)"
#define _dc_83 "       index      x(i,j)"
#define _dc_84 "       (i,j)            "
#define _dc_85 " --- response variable and epsilon error weight"
#define _dc_86 " summary:"
#define _dc_87 "       index      y(i,l)      weight"
#define _dc_88 "       (i,l)                    (we)"
#define _dc_89 " --- function parameter summary:"
#define _dc_90 "       index         beta(k)    fixed           scale"
#define _dc_91 "    derivative"
#define _dc_92 "                                                     "
#define _dc_93 "    assessment"
#define _dc_94 "         (k)                  (ifixb)          (sclb)"
#define _dc_95 "              "
#define _dc_96 "     step size"
#define _dc_97 "        (stpb)"
#define _dc_98 "       "
#define _dc_99 "    "
#define _dc_100 " "
#define _dc_101 "         "
#define _dc_102 "        "
#define _dc_103 "yes"
#define _dc_104 " no"
#define _dc_105 "         cum.      penalty    act. rel.   pred. rel."
#define _dc_106 "  it.  no. fn     function   sum-of-sqs   sum-of-sqs"
#define _dc_107 "              g-n"
#define _dc_108 " num.   evals        value    reduction    reduction"
#define _dc_109 "  tau/pnorm  step"
#define _dc_110 " ----  ------  -----------  -----------  -----------"
#define _dc_111 "  ---------  ----"
#define _dc_112 "         cum.                 act. rel.   pred. rel."
#define _dc_113 "  it.  no. fn     weighted   sum-of-sqs   sum-of-sqs"
#define _dc_114 " num.   evals   sum-of-sqs    reduction    reduction"
#define _dc_115 "              g-n      beta -------------->"
#define _dc_116 "  tau/pnorm  step     index           value"
#define _dc_117 "  ---------  ----     -----           -----"
#define _dc_118 " penalty parameter value = "
#define _dc_119 "   "
#define _dc_120 " to"
#define _dc_121 "                                                                            "
#define _dc_122 "                                                                      "
#define _dc_123 " --- stopping conditions:"
#define _dc_124 "         info = "
#define _dc_125 " ==> sum of squares convergence."
#define _dc_126 " ==> parameter convergence."
#define _dc_127 " ==> sum of squares convergence and"
#define _dc_128 " parameter convergence."
#define _dc_129 " ==> iteration limit reached."
#define _dc_130 " ==> unexpected value,"
#define _dc_131 " probably indicating"
#define _dc_132 "                           incorrectly specified"
#define _dc_133 " user input."
#define _dc_134 "              =  abcd, where a nonzero value for digit a,"
#define _dc_135 " b, or c indicates why"
#define _dc_136 "                       the results might be questionable,"
#define _dc_137 " and digit d indicates"
#define _dc_138 "                       the actual stopping condition."
#define _dc_139 "                       a=1 ==> derivatives are"
#define _dc_140 " questionable."
#define _dc_141 "                       b=1 ==> user set istop to"
#define _dc_142 " nonzero value during last"
#define _dc_143 "                               call to subroutine fcn."
#define _dc_144 "                       c=1 ==> derivatives are not"
#define _dc_145 " full rank at the solution."
#define _dc_146 "                       c=2 ==> derivatives are zero"
#define _dc_147 " rank at the solution."
#define _dc_148 "                       d=1 ==> sum of squares convergence."
#define _dc_149 "                       d=2 ==> parameter convergence."
#define _dc_150 "                       d=3 ==> sum of squares convergence"
#define _dc_151 " and parameter convergence."
#define _dc_152 "                       d=4 ==> iteration limit reached."
#define _dc_153 "                               incorrectly specified"
#define _dc_154 "              = abcde, where a nonzero value for a given"
#define _dc_155 " digit indicates an"
#define _dc_156 "                       abnormal stopping condition."
#define _dc_157 "                       a=5 ==> user stopped computations"
#define _dc_158 " in subroutine fcn."
#define _dc_159 " ==> computations were"
#define _dc_160 " stopped during the"
#define _dc_161 "                                    function evaluation."
#define _dc_162 " stopped because"
#define _dc_163 "                                    derivatives with"
#define _dc_164 " respect to delta were"
#define _dc_165 "                                    computed by"
#define _dc_166 " subroutine fcn when"
#define _dc_167 "                                    fit is ols."
#define _dc_168 "                                    jacobian evaluation."
#define _dc_169 "                       a=6 ==> numerical instabilities"
#define _dc_170 " have been detected,"
#define _dc_171 "                               possibly indicating"
#define _dc_172 " a discontinuity in the"
#define _dc_173 "                               derivatives or a poor"
#define _dc_174 " poor choice of problem"
#define _dc_175 "                               scale or weights."
#define _dc_176 "        niter = "
#define _dc_177 "          (number of iterations)"
#define _dc_178 "         nfev = "
#define _dc_179 "          (number of function evaluations)"
#define _dc_180 "         njev = "
#define _dc_181 "          (number of jacobian evaluations)"
#define _dc_182 "        irank = "
#define _dc_183 "          (rank deficiency)"
#define _dc_184 "        rcond = "
#define _dc_185 "   (inverse condition number)"
#define _dc_186 "        istop = "
#define _dc_187 "          (returned by user from"
#define _dc_188 " subroutine fcn)"
#define _dc_189 " --- final sum of squared weighted deltas = "
#define _dc_190 "         final penalty function value     = "
#define _dc_191 "               penalty term               = "
#define _dc_192 "               penalty parameter          = "
#define _dc_193 " --- final weighted sums of squares       = "
#define _dc_194 "         sum of squared weighted deltas   = "
#define _dc_195 "         sum of squared weighted epsilons = "
#define _dc_196 " --- residual standard deviation          = "
#define _dc_197 "         degrees of freedom               ="
#define _dc_198 " --- estimated beta(j), j = 1, ..., np:"
#define _dc_199 " --- estimated delta(i,*), i = 1, ..., n:"
#define _dc_200 " --- estimated epsilon(i) and delta(i,*), i = 1, ..., n:"
#define _dc_201 " --- estimated epsilon(i), i = 1, ..., n:"
#define _dc_202 "     "
#define _dc_203 " --- estimated epsilon(i,"
#define _dc_204 "), i = 1, ..., n:"
#define _dc_205 " --- estimated delta(i,"
#define _dc_206 "           index           value"
#define _dc_207 "           index           value -------------->"
#define _dc_208 "                     beta      s.d. beta"
#define _dc_209 "    ---- 95%  confidence interval ----"
#define _dc_210 "     n.b. standard errors and confidence intervals are"
#define _dc_211 " computed using"
#define _dc_212 "          derivatives calculated at the beginning"
#define _dc_213 " of the last iteration,"
#define _dc_214 "          and not using derivatives re-evaluated at the"
#define _dc_215 " final solution."
#define _dc_216 "     n.b. the standard errors of the estimated betas were"
#define _dc_217 " not computed because"
#define _dc_218 "          the derivatives were not available.  either maxit"
#define _dc_219 " is 0 and the third"
#define _dc_220 "          digit of job is greater than 1, or the most"
#define _dc_221 " recently tried values of"
#define _dc_222 "          beta and/or x+delta were identified as"
#define _dc_223 " unacceptable by user supplied"
#define _dc_224 "          subroutine fcn."
#define _dc_225 " not computed."
#define _dc_226 "          (see info above.)"
#define _dc_227 "                     beta         status"
#define _dc_228 "           "
#define _dc_229 "to"
#define _dc_230 "      "
#define _dc_231 "estimated"
#define _dc_232 "    fixed"
#define _dc_233 "  dropped"
#define _dc_234 "     n.b. no parameters were fixed by the user or"
#define _dc_235 " dropped at the last"
#define _dc_236 "          iteration because they caused the model to be"
#define _dc_237 " rank deficient."
#define _dc_238 "     n.b. no change was made to the user supplied parameter"
#define _dc_239 " values because"
#define _dc_240 "          maxit=0."
#define _dc_241 "(/'         i',"
#define _dc_242 "('      delta(i,',i1,')')/)"
#define _dc_243 "('    epsilon(i,',i1,')'),"
#define _dc_244 "('    epsilon(i,',i1,')')/)"
#define _dc_245 "odr"
#define _dc_246 "ols"
#define _dc_247 " *** initial summary for fit by method of "
#define _dc_248 " ***"
#define _dc_249 " *** iteration reports for fit by method of "
#define _dc_250 " *** final summary for fit by method of "
#define _dc_251 " error :  n is less than one."
#define _dc_252 " error :  m is less than one."
#define _dc_253 " error :  np is less than one"
#define _dc_254 "          or np is greater than n."
#define _dc_255 " error :  nq is less than one."
#define _dc_256 " error :  ldx is less than n."
#define _dc_257 " error :  ldy is less than n."
#define _dc_258 " error :  ldifx is less than n"
#define _dc_259 "          and ldifx is not equal to one."
#define _dc_260 " error :  ldscld is less than n"
#define _dc_261 "          and ldscld is not equal to one."
#define _dc_262 " error :  ldstpd is less than n"
#define _dc_263 "          and ldstpd is not equal to one."
#define _dc_264 " error :  ldwe is less than n"
#define _dc_265 "          and ldwe is not equal to one or"
#define _dc_266 "          or"
#define _dc_267 "          ld2we is less than nq"
#define _dc_268 "          and ld2we is not equal to one."
#define _dc_269 " error :  ldwd is less than n"
#define _dc_270 "          and ldwd is not equal to one."
#define _dc_271 " error :  lwork is less than "
#define _dc_272 ","
#define _dc_273 "          the smallest acceptable dimension of array work."
#define _dc_274 " error :  liwork is less than "
#define _dc_275 "          the smallest acceptable dimension of array"
#define _dc_276 " iwork."
#define _dc_277 " error :  scld(i,j) is less than or equal to zero"
#define _dc_278 "          for some i = 1, ..., n and j = 1, ..., m."
#define _dc_279 "          when scld(1,1) is greater than zero"
#define _dc_280 "          and ldscld is greater than or equal to n then"
#define _dc_281 "          each of the n by m elements of"
#define _dc_282 "          scld must be greater than zero."
#define _dc_283 " error :  scld(1,j) is less than or equal to zero"
#define _dc_284 "          for some j = 1, ..., m."
#define _dc_285 "          and ldscld is equal to one then"
#define _dc_286 "          each of the 1 by m elements of"
#define _dc_287 " error :  sclb(k) is less than or equal to zero"
#define _dc_288 "          for some k = 1, ..., np."
#define _dc_289 "          all np elements of"
#define _dc_290 " sclb must be greater than zero."
#define _dc_291 " error :  stpd(i,j) is less than or equal to zero"
#define _dc_292 "          when stpd(1,1) is greater than zero"
#define _dc_293 "          and ldstpd is greater than or equal to n then"
#define _dc_294 "          stpd must be greater than zero."
#define _dc_295 " error :  stpd(1,j) is less than or equal to zero"
#define _dc_296 "          and ldstpd is equal to one then"
#define _dc_297 " error :  stpb(k) is less than or equal to zero"
#define _dc_298 " stpb must be greater than zero."
#define _dc_299 " error :  at least one of the (nq by nq) arrays starting"
#define _dc_300 "          in we(i,1,1), i = 1, ..., n, is not positive"
#define _dc_301 "          semidefinite.  when we(1,1,1) is greater than"
#define _dc_302 "          or equal to zero, and ldwe is greater than or"
#define _dc_303 "          equal to n, and ld2we is greater than or equal"
#define _dc_304 "          to nq, then each of the (nq by nq) arrays in we"
#define _dc_305 "          must be positive semidefinite."
#define _dc_306 " error :  at least one of the (1 by nq) arrays starting"
#define _dc_307 "          in we(i,1,1), i = 1, ..., n, has a negative"
#define _dc_308 "          element.  when we(1,1,1) is greater than or"
#define _dc_309 "          equal to zero, and ldwe is greater than or equal"
#define _dc_310 "          to n, and ld2we is equal to 1, then each of the"
#define _dc_311 "          (1 by nq) arrays in we must have only non-"
#define _dc_312 "          negative elements."
#define _dc_313 " error :  the (nq by nq) array starting in we(1,1,1) is"
#define _dc_314 "          not positive semidefinite.  when we(1,1,1) is"
#define _dc_315 "          greater than or equal to zero, and ldwe is equal"
#define _dc_316 "          to 1, and ld2we is greater than or equal to nq,"
#define _dc_317 "          then the (nq by nq) array in we must be positive"
#define _dc_318 "          semidefinite."
#define _dc_319 " error :  the (1 by nq) array starting in we(1,1,1) has"
#define _dc_320 "          a negative element.  when we(1,1,1) is greater"
#define _dc_321 "          than or equal to zero, and ldwe is equal to 1,"
#define _dc_322 "          and ld2we is equal to 1, then the (1 by nq)"
#define _dc_323 "          array in we must have only nonnegative elements."
#define _dc_324 " error :  the number of nonzero arrays in array we is"
#define _dc_325 "          less than np."
#define _dc_326 " error :  at least one of the (m by m) arrays starting"
#define _dc_327 "          in wd(i,1,1), i = 1, ..., n, is not positive"
#define _dc_328 "          definite.  when wd(1,1,1) is greater than zero,"
#define _dc_329 "          and ldwd is greater than or equal to n, and"
#define _dc_330 "          ld2wd is greater than or equal to m, then each"
#define _dc_331 "          of the (m by m) arrays in wd must be positive"
#define _dc_332 "          definite."
#define _dc_333 " error :  at least one of the (1 by m) arrays starting"
#define _dc_334 "          in wd(i,1,1), i = 1, ..., n, has a nonpositive"
#define _dc_335 "          element.  when wd(1,1,1) is greater than zero,"
#define _dc_336 "          ld2wd is equal to 1, then each of the (1 by m)"
#define _dc_337 "          arrays in wd must have only positive elements."
#define _dc_338 " error :  the (m by m) array starting in wd(1,1,1) is"
#define _dc_339 "          not positive definite.  when wd(1,1,1) is"
#define _dc_340 "          greater than zero, and ldwd is equal to 1, and"
#define _dc_341 "          ld2wd is greater than or equal to m, then the"
#define _dc_342 "          (m by m) array in wd must be positive definite."
#define _dc_343 " error :  the (1 by m) array starting in wd(1,1,1) has a"
#define _dc_344 "          nonpositive element.  when wd(1,1,1) is greater"
#define _dc_345 "          than zero, and ldwd is equal to 1, and ld2wd is"
#define _dc_346 "          equal to 1, then the (1 by m) array in wd must"
#define _dc_347 "          have only positive elements."
#define _dc_348 "*"
#define _dc_349 " *** derivative checking report for fit by method of "
#define _dc_350 "     for response "
#define _dc_351 " of observation "
#define _dc_352 "                      "
#define _dc_353 "         user"
#define _dc_354 "               "
#define _dc_355 "                "
#define _dc_356 "     supplied"
#define _dc_357 "     relative"
#define _dc_358 "    derivative "
#define _dc_359 "        derivative wrt"
#define _dc_360 "        value"
#define _dc_361 "   difference"
#define _dc_362 "    assessment "
#define _dc_363 "             beta("
#define _dc_364 "       ---   "
#define _dc_365 "verified"
#define _dc_366 "questionable (see note "
#define _dc_367 "          delta("
#define _dc_368 "     notes:"
#define _dc_369 "      (1) user supplied and finite difference derivatives"
#define _dc_370 " agree, but"
#define _dc_371 "          results are questionable because both are zero."
#define _dc_372 "      (2) user supplied and finite difference derivatives"
#define _dc_373 "          results are questionable because one is"
#define _dc_374 " identically zero"
#define _dc_375 "          and the other is only approximately zero."
#define _dc_376 "      (3) user supplied and finite difference derivatives"
#define _dc_377 " disagree, but"
#define _dc_378 "          and the other is not."
#define _dc_379 "      (4) user supplied and finite difference derivatives"
#define _dc_380 "          finite difference derivative is questionable"
#define _dc_381 " because either"
#define _dc_382 "          the ratio of relative curvature to relative"
#define _dc_383 " slope is too high"
#define _dc_384 "          or the scale is wrong."
#define _dc_385 "      (5) user supplied and finite difference derivatives"
#define _dc_386 " because the"
#define _dc_387 "          ratio of relative curvature to relative slope is"
#define _dc_388 " too high."
#define _dc_389 "      (6) user supplied and finite difference derivatives"
#define _dc_390 "          have at least 2 digits in common."
#define _dc_391 "      (7) user supplied and finite difference derivatives"
#define _dc_392 " disagree, and"
#define _dc_393 "          have fewer than 2 digits in common.  derivative"
#define _dc_394 " checking must"
#define _dc_395 "          be turned off in order to proceed."
#define _dc_396 "     number of reliable digits in function results       "
#define _dc_397 "        (estimated by odrpack)"
#define _dc_398 "        (supplied by user)"
#define _dc_399 "     number of digits of agreement required between      "
#define _dc_400 "     user supplied and finite difference derivative for  "
#define _dc_401 "     user supplied derivative to be considered verified  "
#define _dc_402 "     row number at which derivatives were checked        "
#define _dc_403 "       -values of the explanatory variables at this row"
#define _dc_404 "          "
#define _dc_405 "x("
#define _dc_406 " variable istop has been returned with a nonzero value  "
#define _dc_407 " from user supplied subroutine fcn when invoked using the"
#define _dc_408 " initial estimates of beta and delta supplied by the     "
#define _dc_409 " user.  the initial estimates must be adjusted to allow  "
#define _dc_410 " proper evaluation of subroutine fcn before the          "
#define _dc_411 " regression procedure can continue."
#define _dc_412 " from user supplied subroutine fcn.  this occurred during"
#define _dc_413 " the computation of the number of reliable digits in the "
#define _dc_414 " predicted values (f) returned from subroutine fcn, indi-"
#define _dc_415 " cating that changes in the initial estimates of beta(k),"
#define _dc_416 " k=1,np, as small as 2*beta(k)*sqrt(machine precision),  "
#define _dc_417 " where machine precision is defined as the smallest value"
#define _dc_418 " e such that 1+e>1 on the computer being used, prevent   "
#define _dc_419 " subroutine fcn from being properly evaluated.  the      "
#define _dc_420 " initial estimates must be adjusted to allow proper      "
#define _dc_421 " evaluation of subroutine fcn during these computations  "
#define _dc_422 " before the regression procedure can continue."
#define _dc_423 " the derivative checking procedure, indicating that      "
#define _dc_424 " changes in the initial estimates of beta(k), k=1,np, as "
#define _dc_425 " small as max[beta(k),1/sclb(k)]*10**(-neta/2), and/or   "
#define _dc_426 " of delta(i,j), i=1,n and j=1,m, as small as             "
#define _dc_427 " max[delta(i,j),1/scld(i,j)]*10**(-neta/2), where neta   "
#define _dc_428 " is defined to be the number of reliable digits in       "
#define _dc_429 " predicted values (f) returned from subroutine fcn,      "
#define _dc_430 " prevent subroutine fcn from being properly evaluated.   "
#define _dc_431 " the initial estimates must be adjusted to allow proper  "
#define _dc_432 " from user supplied subroutine fcn when invoked for "
#define _dc_433 " derivative evaluations using the initial estimates of "
#define _dc_434 " beta and delta supplied by the user.  the initial "
#define _dc_435 " estimates must be adjusted to allow proper evaluation "
#define _dc_436 " of subroutine fcn before the regression procedure can "
#define _dc_437 " continue."
#define _dc_438 " the correct form of the call statement is "
#define _dc_439 "       call dodr"
#define _dc_440 "      +     (fcn,"
#define _dc_441 "      +     n,m,np,nq,"
#define _dc_442 "      +     beta,"
#define _dc_443 "      +     y,ldy,x,ldx,"
#define _dc_444 "      +     we,ldwe,ld2we,wd,ldwd,ld2wd,"
#define _dc_445 "      +     job,"
#define _dc_446 "      +     iprint,lunerr,lunrpt,"
#define _dc_447 "      +     work,lwork,iwork,liwork,"
#define _dc_448 "      +     info)"
#define _dc_449 "       call dodrc"
#define _dc_450 "      +     ifixb,ifixx,ldifx,"
#define _dc_451 "      +     job,ndigit,taufac,"
#define _dc_452 "      +     sstol,partol,maxit,"
#define _dc_453 "      +     stpb,stpd,ldstpd,"
#define _dc_454 "      +     sclb,scld,ldscld,"
#define _dc_455 " ******************************************************* "
#define _dc_456 " * odrpack version 2.01 of 06-19-92 (double precision) * "
static FORMAT *__fmt_a = NULL;
typedef char char_1[2];
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_127[128];
#define __ncalls 57
static CALLS __calls[__ncalls] = {
  {"dacces", 0}, // subroutine
  {"desubi", 0}, // subroutine
  {"detaf", 0}, // subroutine
  {"devjac", 0}, // subroutine
  {"dfctr", 0}, // subroutine
  {"dfctrw", 0}, // subroutine
  {"dflags", 0}, // subroutine
  {"dhstep", 0}, // real*8 function
  {"difix", 0}, // subroutine
  {"diniwk", 0}, // subroutine
  {"diwinf", 0}, // subroutine
  {"djaccd", 0}, // subroutine
  {"djacfd", 0}, // subroutine
  {"djckc", 0}, // subroutine
  {"djck", 0}, // subroutine
  {"djckf", 0}, // subroutine
  {"djckm", 0}, // subroutine
  {"djckz", 0}, // subroutine
  {"dluno", 0}, // subroutine
  {"dlunc", 0}, // subroutine
  {"dmprec", 0}, // real*8 function
  {"dodchk", 0}, // subroutine
  {"dodcnt", 0}, // subroutine
  {"doddrv", 0}, // subroutine
  {"dodlm", 0}, // subroutine
  {"dodmn", 0}, // subroutine
  {"dodpc1", 0}, // subroutine
  {"dodpc2", 0}, // subroutine
  {"dodpc3", 0}, // subroutine
  {"dodpcr", 0}, // subroutine
  {"dodpe1", 0}, // subroutine
  {"dodpe2", 0}, // subroutine
  {"dodpe3", 0}, // subroutine
  {"dodper", 0}, // subroutine
  {"dodphd", 0}, // subroutine
  {"dodrc", 0}, // subroutine
  {"dodr", 0}, // subroutine
  {"dodstp", 0}, // subroutine
  {"dodvcv", 0}, // subroutine
  {"dpack", 0}, // subroutine
  {"dppnml", 0}, // real*8 function
  {"dppt", 0}, // real*8 function
  {"dpvb", 0}, // subroutine
  {"dpvd", 0}, // subroutine
  {"dscale", 0}, // subroutine
  {"dsclb", 0}, // subroutine
  {"dscld", 0}, // subroutine
  {"dsetn", 0}, // subroutine
  {"dsolve", 0}, // subroutine
  {"dunpac", 0}, // subroutine
  {"dvevtr", 0}, // subroutine
  {"dwght", 0}, // subroutine
  {"dwinf", 0}, // subroutine
  {"dxmy", 0}, // subroutine
  {"dxpy", 0}, // subroutine
  {"dzero", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _dacces (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, 
real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, logical_4 _p_ access_, logical_4 _p_ isodr_, 
int_4 _p_ jpvt_, int_4 _p_ omega_, int_4 _p_ u_, int_4 _p_ qraux_, int_4 _p_ sd_, int_4 _p_ vcv_, int_4 _p_ wrk1_, 
int_4 _p_ wrk2_, int_4 _p_ wrk3_, int_4 _p_ wrk4_, int_4 _p_ wrk5_, int_4 _p_ wrk6_, int_4 _p_ nnzw_, int_4 _p_ npp_, 
int_4 _p_ job_, real_8 _p_ partol_, real_8 _p_ sstol_, int_4 _p_ maxit_, real_8 _p_ taufac_, real_8 _p_ eta_, int_4 _p_ 
neta_, int_4 _p_ lunrpt_, int_4 _p_ ipr1_, int_4 _p_ ipr2_, int_4 _p_ ipr2f_, int_4 _p_ ipr3_, real_8 _p_ wss_, real_8 
_p_ rvar_, int_4 _p_ idf_, real_8 _p_ tau_, real_8 _p_ alpha_, int_4 _p_ niter_, int_4 _p_ nfev_, int_4 _p_ njev_, 
int_4 _p_ int2_, real_8 _p_ olmavg_, real_8 _p_ rcond_, int_4 _p_ irank_, real_8 _p_ actrs_, real_8 _p_ pnorm_, real_8 
_p_ prers_, real_8 _p_ rnorms_, int_4 _p_ istop_);
prototype int_4 _desubi (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ 
alpha_, real_8 _p_ tt_, int_4 _p_ ldtt_, int_4 _p_ i_, real_8 _p_ e_);
prototype int_4 _detaf (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ xplusd_, 
real_8 _p_ beta_, real_8 _p_ epsmac_, int_4 _p_ nrow_, real_8 _p_ partmp_, real_8 _p_ pv0_, int_4 _p_ ifixb_, int_4 _p_ 
ifixx_, int_4 _p_ ldifx_, int_4 _p_ istop_, int_4 _p_ nfev_, real_8 _p_ eta_, int_4 _p_ neta_, real_8 _p_ wrk1_, real_8 
_p_ wrk2_, real_8 _p_ wrk6_, real_8 _p_ wrk7_);
prototype int_4 _devjac (int_4 (*_fcn)(), logical_4 _p_ anajac_, logical_4 _p_ cdjac_, int_4 _p_ n_, int_4 _p_ m_, 
int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ betac_, real_8 _p_ beta_, real_8 _p_ stpb_, int_4 _p_ ifixb_, int_4 _p_ ifixx_
, int_4 _p_ ldifx_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ delta_, real_8 _p_ xplusd_, real_8 _p_ stpd_, int_4 _p_ 
ldstpd_, real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ ldtt_, int_4 _p_ neta_, real_8 _p_ fn_, real_8 _p_ stp_, real_8 _p_ 
wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk6_, real_8 _p_ fjacb_, logical_4 _p_ isodr_, real_8 _p_ fjacd_
, real_8 _p_ we1_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, int_4 _p_ njev_, int_4 _p_ nfev_, int_4 _p_ istop_, int_4 _p_ 
info_);
prototype int_4 _dfctr (logical_4 _p_ oksemi_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_);
prototype int_4 _dfctrw (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ nq_, int_4 _p_ npp_, logical_4 _p_ isodr_, real_8 _p_ 
we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ wrk0_, real_8 _p_ 
wrk4_, real_8 _p_ we1_, int_4 _p_ nnzw_, int_4 _p_ info_);
prototype int_4 _dflags (int_4 _p_ job_, logical_4 _p_ restrt_, logical_4 _p_ initd_, logical_4 _p_ dovcv_, logical_4 
_p_ redoj_, logical_4 _p_ anajac_, logical_4 _p_ cdjac_, logical_4 _p_ chkjac_, logical_4 _p_ isodr_, logical_4 _p_ 
implct_);
prototype real_8 _dhstep (int_4 _p_ itype_, int_4 _p_ neta_, int_4 _p_ i_, int_4 _p_ j_, real_8 _p_ stp_, int_4 _p_ 
ldstp_);
prototype int_4 _difix (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ ifix_, int_4 _p_ ldifix_, real_8 _p_ t_, int_4 _p_ ldt_, 
real_8 _p_ tfix_, int_4 _p_ ldtfix_);
prototype int_4 _diniwk (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ 
iwork_, int_4 _p_ liwork_, real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ scld_, int_4 
_p_ ldscld_, real_8 _p_ beta_, real_8 _p_ sclb_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, real_8 _p_ 
taufac_, int_4 _p_ job_, int_4 _p_ iprint_, int_4 _p_ lunerr_, int_4 _p_ lunrpt_, int_4 _p_ epsmai_, int_4 _p_ sstoli_, 
int_4 _p_ partli_, int_4 _p_ maxiti_, int_4 _p_ taufci_, int_4 _p_ jobi_, int_4 _p_ iprini_, int_4 _p_ luneri_, int_4 
_p_ lunrpi_, int_4 _p_ ssfi_, int_4 _p_ tti_, int_4 _p_ ldtti_, int_4 _p_ deltai_);
prototype int_4 _diwinf (int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ msgbi_, int_4 _p_ msgdi_, int_4 _p_ 
ifix2i_, int_4 _p_ istopi_, int_4 _p_ nnzwi_, int_4 _p_ nppi_, int_4 _p_ idfi_, int_4 _p_ jobi_, int_4 _p_ iprini_, 
int_4 _p_ luneri_, int_4 _p_ lunrpi_, int_4 _p_ nrowi_, int_4 _p_ ntoli_, int_4 _p_ netai_, int_4 _p_ maxiti_, int_4 
_p_ niteri_, int_4 _p_ nfevi_, int_4 _p_ njevi_, int_4 _p_ int2i_, int_4 _p_ iranki_, int_4 _p_ ldtti_, int_4 _p_ 
liwkmn_);
prototype int_4 _djaccd (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ delta_, real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ 
ldifx_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ ldtt_, int_4 
_p_ neta_, real_8 _p_ stp_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk6_, real_8 _p_ fjacb_, 
logical_4 _p_ isodr_, real_8 _p_ fjacd_, int_4 _p_ nfev_, int_4 _p_ istop_);
prototype int_4 _djacfd (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ delta_, real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ 
ldifx_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ ldtt_, int_4 
_p_ neta_, real_8 _p_ fn_, real_8 _p_ stp_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk6_, 
real_8 _p_ fjacb_, logical_4 _p_ isodr_, real_8 _p_ fjacd_, int_4 _p_ nfev_, int_4 _p_ istop_);
prototype int_4 _djckc (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ eta_, real_8 _p_ tol_, int_4 _p_ 
nrow_, real_8 _p_ epsmac_, int_4 _p_ j_, int_4 _p_ lq_, real_8 _p_ hc_, logical_4 _p_ iswrtb_, real_8 _p_ fd_, real_8 
_p_ typj_, real_8 _p_ pvpstp_, real_8 _p_ stp0_, real_8 _p_ pv_, real_8 _p_ d_, real_8 _p_ diffj_, int_4 _p_ msg_, 
int_4 _p_ istop_, int_4 _p_ nfev_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_);
prototype int_4 _djck (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ 
ldstpd_, real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ ldtt_, real_8 _p_ eta_, int_4 _p_ neta_, int_4 _p_ ntol_, int_4 _p_ 
nrow_, logical_4 _p_ isodr_, real_8 _p_ epsmac_, real_8 _p_ pv0_, real_8 _p_ fjacb_, real_8 _p_ fjacd_, int_4 _p_ msgb_
, int_4 _p_ msgd_, real_8 _p_ diff_, int_4 _p_ istop_, int_4 _p_ nfev_, int_4 _p_ njev_, real_8 _p_ wrk1_, real_8 _p_ 
wrk2_, real_8 _p_ wrk6_);
prototype int_4 _djckf (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ eta_, real_8 _p_ tol_, int_4 _p_ 
nrow_, int_4 _p_ j_, int_4 _p_ lq_, logical_4 _p_ iswrtb_, real_8 _p_ fd_, real_8 _p_ typj_, real_8 _p_ pvpstp_, real_8 
_p_ stp0_, real_8 _p_ curve_, real_8 _p_ pv_, real_8 _p_ d_, real_8 _p_ diffj_, int_4 _p_ msg_, int_4 _p_ istop_, int_4 
_p_ nfev_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_);
prototype int_4 _djckm (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ eta_, real_8 _p_ tol_, int_4 _p_ 
nrow_, real_8 _p_ epsmac_, int_4 _p_ j_, int_4 _p_ lq_, real_8 _p_ typj_, real_8 _p_ h0_, real_8 _p_ hc0_, logical_4 
_p_ iswrtb_, real_8 _p_ pv_, real_8 _p_ d_, real_8 _p_ diffj_, int_4 _p_ msg1_, int_4 _p_ msg_, int_4 _p_ istop_, int_4 
_p_ nfev_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_);
prototype int_4 _djckz (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ nrow_, real_8 _p_ epsmac_, int_4 
_p_ j_, int_4 _p_ lq_, logical_4 _p_ iswrtb_, real_8 _p_ tol_, real_8 _p_ d_, real_8 _p_ fd_, real_8 _p_ typj_, real_8 
_p_ pvpstp_, real_8 _p_ stp0_, real_8 _p_ pv_, real_8 _p_ diffj_, int_4 _p_ msg_, int_4 _p_ istop_, int_4 _p_ nfev_, 
real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_);
prototype int_4 _dluno (int_4 _p_ lun_, char _p_ fn_);
prototype int_4 _dlunc (int_4 _p_ lun_);
prototype real_8 _dmprec (void);
prototype int_4 _dodchk (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, logical_4 _p_ isodr_, logical_4 _p_ 
anajac_, logical_4 _p_ implct_, int_4 _p_ ifixb_, int_4 _p_ ldx_, int_4 _p_ ldifx_, int_4 _p_ ldscld_, int_4 _p_ 
ldstpd_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ ldy_, int_4 _p_ lwork_, int_4 
_p_ lwkmn_, int_4 _p_ liwork_, int_4 _p_ liwkmn_, real_8 _p_ sclb_, real_8 _p_ scld_, real_8 _p_ stpb_, real_8 _p_ 
stpd_, int_4 _p_ info_);
prototype int_4 _dodcnt (logical_4 _p_ short_, real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ 
nq_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ we_, int_4 _p_ ldwe_, 
int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ 
ldifx_, int_4 _p_ job_, int_4 _p_ ndigit_, real_8 _p_ taufac_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, 
int_4 _p_ iprint_, int_4 _p_ lunerr_, int_4 _p_ lunrpt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 
_p_ sclb_, real_8 _p_ scld_, int_4 _p_ ldscld_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_
, int_4 _p_ info_);
prototype int_4 _doddrv (logical_4 _p_ short_, logical_4 _p_ head_, logical_4 _p_ fstitr_, logical_4 _p_ prtpen_, int_4 
(*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ ldy_, 
real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_, 
int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ job_, int_4 _p_ ndigit_, real_8 _p_ 
taufac_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, int_4 _p_ iprint_, int_4 _p_ lunerr_, int_4 _p_ 
lunrpt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ sclb_, real_8 _p_ scld_, int_4 _p_ ldscld_, 
real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ maxit1_, real_8 _p_ tstimp_, int_4 
_p_ info_);
prototype int_4 _dodlm (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, real_8 _p_ f_, real_8 
_p_ fjacb_, real_8 _p_ fjacd_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ ss_, real_8 _p_ tt_, int_4 
_p_ ldtt_, real_8 _p_ delta_, real_8 _p_ alpha2_, real_8 _p_ tau_, real_8 _p_ epsfcn_, logical_4 _p_ isodr_, real_8 _p_ 
tfjacb_, real_8 _p_ omega_, real_8 _p_ u_, real_8 _p_ qraux_, int_4 _p_ jpvt_, real_8 _p_ s_, real_8 _p_ t_, int_4 _p_ 
nlms_, real_8 _p_ rcond_, int_4 _p_ irank_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk4_, 
real_8 _p_ wrk5_, real_8 _p_ wrk_, int_4 _p_ lwrk_, int_4 _p_ istopc_);
prototype int_4 _dodmn (logical_4 _p_ head_, logical_4 _p_ fstitr_, logical_4 _p_ prtpen_, int_4 (*_fcn)(), int_4 _p_ 
n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ job_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 
_p_ x_, int_4 _p_ ldx_, real_8 _p_ we_, real_8 _p_ we1_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ 
ldwd_, int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ betac_, real_8 _p_ betan_, 
real_8 _p_ betas_, real_8 _p_ s_, real_8 _p_ delta_, real_8 _p_ deltan_, real_8 _p_ deltas_, real_8 _p_ t_, real_8 _p_ 
f_, real_8 _p_ fn_, real_8 _p_ fs_, real_8 _p_ fjacb_, int_4 _p_ msgb_, real_8 _p_ fjacd_, int_4 _p_ msgd_, real_8 _p_ 
ssf_, real_8 _p_ ss_, real_8 _p_ tt_, int_4 _p_ ldtt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 
_p_ xplusd_, real_8 _p_ wrk_, int_4 _p_ lwrk_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, 
int_4 _p_ info_);
prototype int_4 _dodpc1 (int_4 _p_ ipr_, int_4 _p_ lunrpt_, logical_4 _p_ anajac_, logical_4 _p_ cdjac_, logical_4 _p_ 
chkjac_, logical_4 _p_ initd_, logical_4 _p_ restrt_, logical_4 _p_ isodr_, logical_4 _p_ implct_, logical_4 _p_ dovcv_
, logical_4 _p_ redoj_, int_4 _p_ msgb1_, int_4 _p_ msgb_, int_4 _p_ msgd1_, int_4 _p_ msgd_, int_4 _p_ n_, int_4 _p_ 
m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, int_4 _p_ nnzw_, real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ ifixx_, 
int_4 _p_ ldifx_, real_8 _p_ delta_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ tt_, int_4 _p_ ldtt_
, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_
, real_8 _p_ pnlty_, real_8 _p_ beta_, int_4 _p_ ifixb_, real_8 _p_ ssf_, real_8 _p_ stpb_, int_4 _p_ job_, int_4 _p_ 
neta_, real_8 _p_ taufac_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, real_8 _p_ wss_, real_8 _p_ wssdel_
, real_8 _p_ wsseps_);
prototype int_4 _dodpc2 (int_4 _p_ ipr_, int_4 _p_ lunrpt_, logical_4 _p_ fstitr_, logical_4 _p_ implct_, logical_4 _p_ 
prtpen_, real_8 _p_ pnlty_, int_4 _p_ niter_, int_4 _p_ nfev_, real_8 _p_ wss_, real_8 _p_ actred_, real_8 _p_ prered_, 
real_8 _p_ alpha_, real_8 _p_ tau_, real_8 _p_ pnorm_, int_4 _p_ np_, real_8 _p_ beta_);
prototype int_4 _dodpc3 (int_4 _p_ ipr_, int_4 _p_ lunrpt_, logical_4 _p_ isodr_, logical_4 _p_ implct_, logical_4 _p_ 
didvcv_, logical_4 _p_ dovcv_, logical_4 _p_ redoj_, logical_4 _p_ anajac_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, 
int_4 _p_ nq_, int_4 _p_ npp_, int_4 _p_ info_, int_4 _p_ niter_, int_4 _p_ nfev_, int_4 _p_ njev_, int_4 _p_ irank_, 
real_8 _p_ rcond_, int_4 _p_ istop_, real_8 _p_ wss_, real_8 _p_ wssdel_, real_8 _p_ wsseps_, real_8 _p_ pnlty_, real_8 
_p_ rvar_, int_4 _p_ idf_, real_8 _p_ beta_, real_8 _p_ sdbeta_, int_4 _p_ ifixb2_, real_8 _p_ f_, real_8 _p_ delta_);
prototype int_4 _dodpcr (int_4 _p_ ipr_, int_4 _p_ lunrpt_, logical_4 _p_ head_, logical_4 _p_ prtpen_, logical_4 _p_ 
fstitr_, logical_4 _p_ didvcv_, int_4 _p_ iflag_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ 
npp_, int_4 _p_ nnzw_, int_4 _p_ msgb_, int_4 _p_ msgd_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ x_
, int_4 _p_ ldx_, real_8 _p_ delta_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_
, int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ 
ldtt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, int_4 _p_ job_, int_4 _p_ neta_, real_8 _p_ taufac_, 
real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, real_8 _p_ wss_, real_8 _p_ rvar_, int_4 _p_ idf_, real_8 _p_ 
sdbeta_, int_4 _p_ niter_, int_4 _p_ nfev_, int_4 _p_ njev_, real_8 _p_ actred_, real_8 _p_ prered_, real_8 _p_ tau_, 
real_8 _p_ pnorm_, real_8 _p_ alpha_, real_8 _p_ f_, real_8 _p_ rcond_, int_4 _p_ irank_, int_4 _p_ info_, int_4 _p_ 
istop_);
prototype int_4 _dodpe1 (int_4 _p_ fileno_, int_4 _p_ d1_, int_4 _p_ d2_, int_4 _p_ d3_, int_4 _p_ d4_, int_4 _p_ d5_, 
int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ nq_, int_4 _p_ ldscld_, int_4 _p_ ldstpd_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, 
int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ lwkmn_, int_4 _p_ liwkmn_);
prototype int_4 _dodpe2 (int_4 _p_ fileno_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ fjacb_
, real_8 _p_ fjacd_, real_8 _p_ diff_, int_4 _p_ msgb1_, int_4 _p_ msgb_, logical_4 _p_ isodr_, int_4 _p_ msgd1_, int_4 
_p_ msgd_, real_8 _p_ xplusd_, int_4 _p_ nrow_, int_4 _p_ neta_, int_4 _p_ ntol_);
prototype int_4 _dodpe3 (int_4 _p_ fileno_, int_4 _p_ d2_, int_4 _p_ d3_);
prototype int_4 _dodper (int_4 _p_ info_, int_4 _p_ lunerr_, logical_4 _p_ short_, int_4 _p_ n_, int_4 _p_ m_, int_4 
_p_ np_, int_4 _p_ nq_, int_4 _p_ ldscld_, int_4 _p_ ldstpd_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, int_4 _p_ ldwd_, int_4 
_p_ ld2wd_, int_4 _p_ lwkmn_, int_4 _p_ liwkmn_, real_8 _p_ fjacb_, real_8 _p_ fjacd_, real_8 _p_ diff_, int_4 _p_ 
msgb_, logical_4 _p_ isodr_, int_4 _p_ msgd_, real_8 _p_ xplusd_, int_4 _p_ nrow_, int_4 _p_ neta_, int_4 _p_ ntol_);
prototype int_4 _dodphd (logical_4 _p_ head_, int_4 _p_ fileno_);
prototype int_4 _dodrc (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 
_p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ job_, int_4 
_p_ ndigit_, real_8 _p_ taufac_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, int_4 _p_ iprint_, int_4 _p_ 
lunerr_, int_4 _p_ lunrpt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ sclb_, real_8 _p_ scld_, 
int_4 _p_ ldscld_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ info_);
prototype int_4 _dodr (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 
_p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ job_, int_4 _p_ iprint_, int_4 _p_ lunerr_, int_4 _p_ lunrpt_, 
real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ info_);
prototype int_4 _dodstp (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, real_8 _p_ f_, 
real_8 _p_ fjacb_, real_8 _p_ fjacd_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ ss_, real_8 _p_ tt_
, int_4 _p_ ldtt_, real_8 _p_ delta_, real_8 _p_ alpha_, real_8 _p_ epsfcn_, logical_4 _p_ isodr_, real_8 _p_ tfjacb_, 
real_8 _p_ omega_, real_8 _p_ u_, real_8 _p_ qraux_, int_4 _p_ kpvt_, real_8 _p_ s_, real_8 _p_ t_, real_8 _p_ phi_, 
int_4 _p_ irank_, real_8 _p_ rcond_, logical_4 _p_ forvcv_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, 
real_8 _p_ wrk4_, real_8 _p_ wrk5_, real_8 _p_ wrk_, int_4 _p_ lwrk_, int_4 _p_ istopc_);
prototype int_4 _dodvcv (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, real_8 _p_ f_, 
real_8 _p_ fjacb_, real_8 _p_ fjacd_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ ssf_, real_8 _p_ 
ss_, real_8 _p_ tt_, int_4 _p_ ldtt_, real_8 _p_ delta_, real_8 _p_ epsfcn_, logical_4 _p_ isodr_, real_8 _p_ vcv_, 
real_8 _p_ sd_, real_8 _p_ wrk6_, real_8 _p_ omega_, real_8 _p_ u_, real_8 _p_ qraux_, int_4 _p_ jpvt_, real_8 _p_ s_, 
real_8 _p_ t_, int_4 _p_ irank_, real_8 _p_ rcond_, real_8 _p_ rss_, int_4 _p_ idf_, real_8 _p_ rvar_, int_4 _p_ ifixb_
, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk4_, real_8 _p_ wrk5_, real_8 _p_ wrk_, int_4 _p_ 
lwrk_, int_4 _p_ istopc_);
prototype int_4 _dpack (int_4 _p_ n2_, int_4 _p_ n1_, real_8 _p_ v1_, real_8 _p_ v2_, int_4 _p_ ifix_);
prototype real_8 _dppnml (real_8 _p_ p_);
prototype real_8 _dppt (real_8 _p_ p_, int_4 _p_ idf_);
prototype int_4 _dpvb (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ nrow_, int_4 _p_ j_, int_4 _p_ lq_, 
real_8 _p_ stp_, int_4 _p_ istop_, int_4 _p_ nfev_, real_8 _p_ pvb_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ 
wrk6_);
prototype int_4 _dpvd (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, 
real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ nrow_, int_4 _p_ j_, int_4 _p_ lq_, 
real_8 _p_ stp_, int_4 _p_ istop_, int_4 _p_ nfev_, real_8 _p_ pvd_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ 
wrk6_);
prototype int_4 _dscale (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ scl_, int_4 _p_ ldscl_, real_8 _p_ t_, int_4 _p_ ldt_, 
real_8 _p_ sclt_, int_4 _p_ ldsclt_);
prototype int_4 _dsclb (int_4 _p_ np_, real_8 _p_ beta_, real_8 _p_ ssf_);
prototype int_4 _dscld (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ tt_, int_4 _p_ ldtt_);
prototype int_4 _dsetn (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ nrow_);
prototype int_4 _dsolve (int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ job_);
prototype int_4 _dunpac (int_4 _p_ n2_, real_8 _p_ v1_, real_8 _p_ v2_, int_4 _p_ ifix_);
prototype int_4 _dvevtr (int_4 _p_ m_, int_4 _p_ nq_, int_4 _p_ indx_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ ld2v_, 
real_8 _p_ e_, int_4 _p_ lde_, real_8 _p_ ve_, int_4 _p_ ldve_, int_4 _p_ ld2ve_, real_8 _p_ vev_, int_4 _p_ ldvev_, 
real_8 _p_ wrk5_);
prototype int_4 _dwght (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ wt_, int_4 _p_ ldwt_, int_4 _p_ ld2wt_, real_8 _p_ t_, 
int_4 _p_ ldt_, real_8 _p_ wtt_, int_4 _p_ ldwtt_);
prototype int_4 _dwinf (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, 
logical_4 _p_ isodr_, int_4 _p_ deltai_, int_4 _p_ epsi_, int_4 _p_ xplusi_, int_4 _p_ fni_, int_4 _p_ sdi_, int_4 _p_ 
vcvi_, int_4 _p_ rvari_, int_4 _p_ wssi_, int_4 _p_ wssdei_, int_4 _p_ wssepi_, int_4 _p_ rcondi_, int_4 _p_ etai_, 
int_4 _p_ olmavi_, int_4 _p_ taui_, int_4 _p_ alphai_, int_4 _p_ actrsi_, int_4 _p_ pnormi_, int_4 _p_ rnorsi_, int_4 
_p_ prersi_, int_4 _p_ partli_, int_4 _p_ sstoli_, int_4 _p_ taufci_, int_4 _p_ epsmai_, int_4 _p_ beta0i_, int_4 _p_ 
betaci_, int_4 _p_ betasi_, int_4 _p_ betani_, int_4 _p_ si_, int_4 _p_ ssi_, int_4 _p_ ssfi_, int_4 _p_ qrauxi_, int_4 
_p_ ui_, int_4 _p_ fsi_, int_4 _p_ fjacbi_, int_4 _p_ we1i_, int_4 _p_ diffi_, int_4 _p_ deltsi_, int_4 _p_ deltni_, 
int_4 _p_ ti_, int_4 _p_ tti_, int_4 _p_ omegai_, int_4 _p_ fjacdi_, int_4 _p_ wrk1i_, int_4 _p_ wrk2i_, int_4 _p_ 
wrk3i_, int_4 _p_ wrk4i_, int_4 _p_ wrk5i_, int_4 _p_ wrk6i_, int_4 _p_ wrk7i_, int_4 _p_ lwkmn_);
prototype int_4 _dxmy (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 
_p_ xmy_, int_4 _p_ ldxmy_);
prototype int_4 _dxpy (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 
_p_ xpy_, int_4 _p_ ldxpy_);
prototype int_4 _dzero (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ a_, int_4 _p_ lda_);
int_4 _dacces (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ 
work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, logical_4 _p_ access_, logical_4 _p_ isodr_, int_4 _p_ 
jpvt_, int_4 _p_ omega_, int_4 _p_ u_, int_4 _p_ qraux_, int_4 _p_ sd_, int_4 _p_ vcv_, int_4 _p_ wrk1_, int_4 _p_ 
wrk2_, int_4 _p_ wrk3_, int_4 _p_ wrk4_, int_4 _p_ wrk5_, int_4 _p_ wrk6_, int_4 _p_ nnzw_, int_4 _p_ npp_, int_4 _p_ 
job_, real_8 _p_ partol_, real_8 _p_ sstol_, int_4 _p_ maxit_, real_8 _p_ taufac_, real_8 _p_ eta_, int_4 _p_ neta_, 
int_4 _p_ lunrpt_, int_4 _p_ ipr1_, int_4 _p_ ipr2_, int_4 _p_ ipr2f_, int_4 _p_ ipr3_, real_8 _p_ wss_, real_8 _p_ 
rvar_, int_4 _p_ idf_, real_8 _p_ tau_, real_8 _p_ alpha_, int_4 _p_ niter_, int_4 _p_ nfev_, int_4 _p_ njev_, int_4 
_p_ int2_, real_8 _p_ olmavg_, real_8 _p_ rcond_, int_4 _p_ irank_, real_8 _p_ actrs_, real_8 _p_ pnorm_, real_8 _p_ 
prers_, real_8 _p_ rnorms_, int_4 _p_ istop_)
{
  static int_4 istopi_, actrsi_, alphai_, betaci_, betani_, betasi_, beta0i_, deltai_, deltni_, deltsi_, diffi_, epsi_, 
  epsmai_, etai_, fjacbi_, fjacdi_, fni_, fsi_, idfi_, int2i_, iprini_, iprint_, iranki_, jobi_, jpvti_, ldtti_, liwkmn_, 
  luneri_, lunrpi_, lwkmn_, maxiti_, msgb_, msgd_, netai_, nfevi_, niteri_, njevi_, nnzwi_, nppi_, nrowi_, ntoli_, 
  olmavi_, omegai_, partli_, pnormi_, prersi_, qrauxi_, rcondi_, rnorsi_, rvari_, sdi_, si_, ssfi_, ssi_, sstoli_, 
  taufci_, taui_, ti_, tti_, ui_, vcvi_, we1i_, wrk1i_, wrk2i_, wrk3i_, wrk4i_, wrk5i_, wrk6i_, wrk7i_, wssi_, wssdei_, 
  wssepi_, xplusi_;
  (void) _diwinf (m_, np_, nq_, &msgb_, &msgd_, &jpvti_, &istopi_, &nnzwi_, &nppi_, &idfi_, &jobi_, &iprini_, &luneri_, 
  &lunrpi_, &nrowi_, &ntoli_, &netai_, &maxiti_, &niteri_, &nfevi_, &njevi_, &int2i_, &iranki_, &ldtti_, &liwkmn_);
  (void) _dwinf (n_, m_, np_, nq_, ldwe_, ld2we_, isodr_, &deltai_, &epsi_, &xplusi_, &fni_, &sdi_, &vcvi_, &rvari_, 
  &wssi_, &wssdei_, &wssepi_, &rcondi_, &etai_, &olmavi_, &taui_, &alphai_, &actrsi_, &pnormi_, &rnorsi_, &prersi_, 
  &partli_, &sstoli_, &taufci_, &epsmai_, &beta0i_, &betaci_, &betasi_, &betani_, &si_, &ssi_, &ssfi_, &qrauxi_, &ui_, 
  &fsi_, &fjacbi_, &we1i_, &diffi_, &deltsi_, &deltni_, &ti_, &tti_, &omegai_, &fjacdi_, &wrk1i_, &wrk2i_, &wrk3i_, 
  &wrk4i_, &wrk5i_, &wrk6i_, &wrk7i_, &lwkmn_);
  if ((*access_)) {
    (*jpvt_) = jpvti_;
    (*omega_) = omegai_;
    (*qraux_) = qrauxi_;
    (*sd_) = sdi_;
    (*vcv_) = vcvi_;
    (*u_) = ui_;
    (*wrk1_) = wrk1i_;
    (*wrk2_) = wrk2i_;
    (*wrk3_) = wrk3i_;
    (*wrk4_) = wrk4i_;
    (*wrk5_) = wrk5i_;
    (*wrk6_) = wrk6i_;
    (*actrs_) = work_[actrsi_ - 1];
    (*alpha_) = work_[alphai_ - 1];
    (*eta_) = work_[etai_ - 1];
    (*olmavg_) = work_[olmavi_ - 1];
    (*partol_) = work_[partli_ - 1];
    (*pnorm_) = work_[pnormi_ - 1];
    (*prers_) = work_[prersi_ - 1];
    (*rcond_) = work_[rcondi_ - 1];
    wss_[0] = work_[wssi_ - 1];
    wss_[1] = work_[wssdei_ - 1];
    wss_[2] = work_[wssepi_ - 1];
    (*rvar_) = work_[rvari_ - 1];
    (*rnorms_) = work_[rnorsi_ - 1];
    (*sstol_) = work_[sstoli_ - 1];
    (*tau_) = work_[taui_ - 1];
    (*taufac_) = work_[taufci_ - 1];
    (*neta_) = iwork_[netai_ - 1];
    (*irank_) = iwork_[iranki_ - 1];
    (*job_) = iwork_[jobi_ - 1];
    (*lunrpt_) = iwork_[lunrpi_ - 1];
    (*maxit_) = iwork_[maxiti_ - 1];
    (*nfev_) = iwork_[nfevi_ - 1];
    (*niter_) = iwork_[niteri_ - 1];
    (*njev_) = iwork_[njevi_ - 1];
    (*nnzw_) = iwork_[nnzwi_ - 1];
    (*npp_) = iwork_[nppi_ - 1];
    (*idf_) = iwork_[idfi_ - 1];
    (*int2_) = iwork_[int2i_ - 1];
    iprint_ = iwork_[iprini_ - 1];
    (*ipr1_) = _imod (iprint_, 10000) / 1000;
    (*ipr2_) = _imod (iprint_, 1000) / 100;
    (*ipr2f_) = _imod (iprint_, 100) / 10;
    (*ipr3_) = _imod (iprint_, 10);
  }
  else {
    work_[actrsi_ - 1] = (*actrs_);
    work_[alphai_ - 1] = (*alpha_);
    work_[olmavi_ - 1] = (*olmavg_);
    work_[partli_ - 1] = (*partol_);
    work_[pnormi_ - 1] = (*pnorm_);
    work_[prersi_ - 1] = (*prers_);
    work_[rcondi_ - 1] = (*rcond_);
    work_[wssi_ - 1] = wss_[0];
    work_[wssdei_ - 1] = wss_[1];
    work_[wssepi_ - 1] = wss_[2];
    work_[rvari_ - 1] = (*rvar_);
    work_[rnorsi_ - 1] = (*rnorms_);
    work_[sstoli_ - 1] = (*sstol_);
    work_[taui_ - 1] = (*tau_);
    iwork_[iranki_ - 1] = (*irank_);
    iwork_[istopi_ - 1] = (*istop_);
    iwork_[nfevi_ - 1] = (*nfev_);
    iwork_[niteri_ - 1] = (*niter_);
    iwork_[njevi_ - 1] = (*njev_);
    iwork_[idfi_ - 1] = (*idf_);
    iwork_[int2i_ - 1] = (*int2_);
  }
  __calls[0].calls++;
  return 0;
}

int_4 _desubi (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ alpha_, real_8 
_p_ tt_, int_4 _p_ ldtt_, int_4 _p_ i_, real_8 _p_ e_)
{
  static int_4 j_, j1_, j2_;
  static real_8 zero_;
  int_4 _data_k_0;
#define _data_n_0 1
  static real_8 _data_l_0[_data_n_0] = {
    0.0e0
  };
  if (__calls[1].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    zero_ = _data_l_0[_data_k_0++];
  }
  if ((*n_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  if (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))] >= zero_) {
    if ((*ldwd_) >= (*n_)) {
      if ((*ld2wd_) == 1) {
        (void) _dzero (m_, m_, e_, m_);
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = wd_[(*i_) - 1 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((j_ - 1)))];
        }
      }
      else {
        for (j1_ = 1; j1_ <= (*m_); (j1_)++) {
          for (j2_ = 1; j2_ <= (*m_); (j2_)++) {
            e_[j1_ - 1 + ((*m_)) * ((j2_ - 1))] = wd_[(*i_) - 1 + ((*ldwd_)) * ((j1_ - 1) + ((*ld2wd_)) * ((j2_ - 1)))];
          }
        }
      }
      if (tt_[0 + ((*ldtt_)) * ((0))] > zero_) {
        if ((*ldtt_) >= (*n_)) {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = e_[j_ - 1 + ((*m_)) * ((j_ - 1))] + (*alpha_) * (tt_[(*i_) - 1 + ((*ldtt_)) * ((j_ 
            - 1))] * tt_[(*i_) - 1 + ((*ldtt_)) * ((j_ - 1))]);
          }
        }
        else {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = e_[j_ - 1 + ((*m_)) * ((j_ - 1))] + (*alpha_) * (tt_[0 + ((*ldtt_)) * ((j_ - 1))] * 
            tt_[0 + ((*ldtt_)) * ((j_ - 1))]);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = e_[j_ - 1 + ((*m_)) * ((j_ - 1))] + (*alpha_) * (tt_[0 + ((*ldtt_)) * ((0))] * 
          tt_[0 + ((*ldtt_)) * ((0))]);
        }
      }
    }
    else {
      if ((*ld2wd_) == 1) {
        (void) _dzero (m_, m_, e_, m_);
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((j_ - 1)))];
        }
      }
      else {
        for (j1_ = 1; j1_ <= (*m_); (j1_)++) {
          for (j2_ = 1; j2_ <= (*m_); (j2_)++) {
            e_[j1_ - 1 + ((*m_)) * ((j2_ - 1))] = wd_[0 + ((*ldwd_)) * ((j1_ - 1) + ((*ld2wd_)) * ((j2_ - 1)))];
          }
        }
      }
      if (tt_[0 + ((*ldtt_)) * ((0))] > zero_) {
        if ((*ldtt_) >= (*n_)) {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = e_[j_ - 1 + ((*m_)) * ((j_ - 1))] + (*alpha_) * (tt_[(*i_) - 1 + ((*ldtt_)) * ((j_ 
            - 1))] * tt_[(*i_) - 1 + ((*ldtt_)) * ((j_ - 1))]);
          }
        }
        else {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = e_[j_ - 1 + ((*m_)) * ((j_ - 1))] + (*alpha_) * (tt_[0 + ((*ldtt_)) * ((j_ - 1))] * 
            tt_[0 + ((*ldtt_)) * ((j_ - 1))]);
          }
        }
      }
      else {
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = e_[j_ - 1 + ((*m_)) * ((j_ - 1))] + (*alpha_) * (tt_[0 + ((*ldtt_)) * ((0))] * 
          tt_[0 + ((*ldtt_)) * ((0))]);
        }
      }
    }
  }
  else {
    (void) _dzero (m_, m_, e_, m_);
    if (tt_[0 + ((*ldtt_)) * ((0))] > zero_) {
      if ((*ldtt_) >= (*n_)) {
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = _abs (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))]) + (*alpha_) * (tt_[(*i_) - 
          1 + ((*ldtt_)) * ((j_ - 1))] * tt_[(*i_) - 1 + ((*ldtt_)) * ((j_ - 1))]);
        }
      }
      else {
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = _abs (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))]) + (*alpha_) * (tt_[0 + 
          ((*ldtt_)) * ((j_ - 1))] * tt_[0 + ((*ldtt_)) * ((j_ - 1))]);
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        e_[j_ - 1 + ((*m_)) * ((j_ - 1))] = _abs (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))]) + (*alpha_) * (tt_[0 + 
        ((*ldtt_)) * ((0))] * tt_[0 + ((*ldtt_)) * ((0))]);
      }
    }
  }
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _detaf (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ xplusd_, real_8 _p_ 
beta_, real_8 _p_ epsmac_, int_4 _p_ nrow_, real_8 _p_ partmp_, real_8 _p_ pv0_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, 
int_4 _p_ ldifx_, int_4 _p_ istop_, int_4 _p_ nfev_, real_8 _p_ eta_, int_4 _p_ neta_, real_8 _p_ wrk1_, real_8 _p_ 
wrk2_, real_8 _p_ wrk6_, real_8 _p_ wrk7_)
{
  static int_4 j_, k_, l_;
  static real_8 a_, b_, fac_, hundrd_, one_, p1_, p2_, p5_, stp_, two_, zero_;
  int_4 _data_k_1, $0_;
#define _data_n_1 7
  static real_8 _data_l_1[_data_n_1] = {
    0.0e0,
    0.1e0,
    0.2e0,
    0.5e0,
    1.0e0,
    2.0e0,
    1.0e2
  };
  if (__calls[2].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    zero_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    p1_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    p2_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    p5_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    one_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    two_ = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    hundrd_ = _data_l_1[_data_k_1++];
  }
  stp_ = hundrd_ * (*epsmac_);
  (*eta_) = (*epsmac_);
  for (j_ = -2; j_ <= 2; (j_)++) {
    if (j_ == 0) {
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        wrk7_[j_ - -2 + (5) * ((l_ - 1))] = pv0_[(*nrow_) - 1 + ((*n_)) * ((l_ - 1))];
      }
    }
    else {
      for (k_ = 1; k_ <= (*np_); (k_)++) {
        if (ifixb_[0] < 0) {
          partmp_[k_ - 1] = beta_[k_ - 1] + j_ * stp_ * beta_[k_ - 1];
        }
        else if (ifixb_[k_ - 1] != 0) {
          partmp_[k_ - 1] = beta_[k_ - 1] + j_ * stp_ * beta_[k_ - 1];
        }
        else {
          partmp_[k_ - 1] = beta_[k_ - 1];
        }
      }
      (*istop_) = 0;
      (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, partmp_, xplusd_, ifixb_, ifixx_, ldifx_, ($0_ = 3, &$0_), wrk2_, wrk6_, 
      wrk1_, istop_);
      if ((*istop_) != 0) {
        goto _l0;
      }
      else {
        (*nfev_) = (*nfev_) + 1;
      }
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        wrk7_[j_ - -2 + (5) * ((l_ - 1))] = wrk2_[(*nrow_) - 1 + ((*n_)) * ((l_ - 1))];
      }
    }
  }
  for (l_ = 1; l_ <= (*nq_); (l_)++) {
    a_ = zero_;
    b_ = zero_;
    for (j_ = -2; j_ <= 2; (j_)++) {
      a_ = a_ + wrk7_[j_ - -2 + (5) * ((l_ - 1))];
      b_ = b_ + j_ * wrk7_[j_ - -2 + (5) * ((l_ - 1))];
    }
    a_ = p2_ * a_;
    b_ = p1_ * b_;
    if ((wrk7_[2 + (5) * ((l_ - 1))] != zero_) && (_abs (wrk7_[3 + (5) * ((l_ - 1))] + wrk7_[1 + (5) * ((l_ - 1))]) > 
      hundrd_ * (*epsmac_))) {
      fac_ = one_ / _abs (wrk7_[2 + (5) * ((l_ - 1))]);
    }
    else {
      fac_ = one_;
    }
    for (j_ = -2; j_ <= 2; (j_)++) {
      wrk7_[j_ - -2 + (5) * ((l_ - 1))] = _abs ((wrk7_[j_ - -2 + (5) * ((l_ - 1))] - (a_ + j_ * b_)) * fac_);
      (*eta_) = _max (wrk7_[j_ - -2 + (5) * ((l_ - 1))], (*eta_));
    }
  }
  (*neta_) = _max (two_, p5_ - log10 ((*eta_)));
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _devjac (int_4 (*_fcn)(), logical_4 _p_ anajac_, logical_4 _p_ cdjac_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, 
int_4 _p_ nq_, real_8 _p_ betac_, real_8 _p_ beta_, real_8 _p_ stpb_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ 
ldifx_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ delta_, real_8 _p_ xplusd_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, 
real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ ldtt_, int_4 _p_ neta_, real_8 _p_ fn_, real_8 _p_ stp_, real_8 _p_ wrk1_, 
real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk6_, real_8 _p_ fjacb_, logical_4 _p_ isodr_, real_8 _p_ fjacd_, 
real_8 _p_ we1_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, int_4 _p_ njev_, int_4 _p_ nfev_, int_4 _p_ istop_, int_4 _p_ info_
)
{
  static int_4 ideval_, j_, k_, k1_, l_;
  static logical_4 error_;
  static real_8 zero_;
  int_4 _data_k_2, $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  extern real_8 _ddot ();
#define _data_n_2 1
  static real_8 _data_l_2[_data_n_2] = {
    0.0e0
  };
  if (__calls[3].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    zero_ = _data_l_2[_data_k_2++];
  }
  (void) _dunpac (np_, betac_, beta_, ifixb_);
  (void) _dxpy (n_, m_, x_, ldx_, delta_, n_, xplusd_, n_);
  (*istop_) = 0;
  if ((*isodr_)) {
    ideval_ = 110;
  }
  else {
    ideval_ = 10;
  }
  if ((*anajac_)) {
    (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, &ideval_, wrk2_, fjacb_, fjacd_, 
    istop_);
    if ((*istop_) != 0) {
      goto _l0;
    }
    else {
      (*njev_) = (*njev_) + 1;
    }
    if ((*isodr_)) {
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        (void) _difix (n_, m_, ifixx_, ldifx_, &fjacd_[0 + ((*n_)) * ((0) + ((*m_)) * ((l_ - 1)))], n_, &fjacd_[0 + ((*n_)) * 
        ((0) + ((*m_)) * ((l_ - 1)))], n_);
      }
    }
  }
  else if ((*cdjac_)) {
    (void) _djaccd (_fcn, n_, m_, np_, nq_, beta_, x_, ldx_, delta_, xplusd_, ifixb_, ifixx_, ldifx_, stpb_, stpd_, 
    ldstpd_, ssf_, tt_, ldtt_, neta_, stp_, wrk1_, wrk2_, wrk3_, wrk6_, fjacb_, isodr_, fjacd_, nfev_, istop_);
  }
  else {
    (void) _djacfd (_fcn, n_, m_, np_, nq_, beta_, x_, ldx_, delta_, xplusd_, ifixb_, ifixx_, ldifx_, stpb_, stpd_, 
    ldstpd_, ssf_, tt_, ldtt_, neta_, fn_, stp_, wrk1_, wrk2_, wrk3_, wrk6_, fjacb_, isodr_, fjacd_, nfev_, istop_);
  }
  if ((*istop_) < 0) {
    goto _l0;
  }
  else if (! ((*isodr_))) {
    error_ = _ddot (($0_ = (*n_) * (*m_), &$0_), delta_, &_k1, delta_, &_k1) != zero_;
    if (error_) {
      (*info_) = 50300;
      goto _l0;
    }
  }
  if (ifixb_[0] < 0) {
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      (void) _dwght (n_, nq_, we1_, ldwe_, ld2we_, &fjacb_[0 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((0)))], ($1_ = (*n_) * 
      (*np_), &$1_), &fjacb_[0 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((0)))], ($2_ = (*n_) * (*np_), &$2_));
    }
  }
  else {
    k1_ = 0;
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      if (ifixb_[k_ - 1] >= 1) {
        k1_ = k1_ + 1;
        (void) _dwght (n_, nq_, we1_, ldwe_, ld2we_, &fjacb_[0 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((0)))], ($3_ = (*n_) * 
        (*np_), &$3_), &fjacb_[0 + ((*n_)) * ((k1_ - 1) + ((*np_)) * ((0)))], ($4_ = (*n_) * (*np_), &$4_));
      }
    }
  }
  if ((*isodr_)) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      (void) _dwght (n_, nq_, we1_, ldwe_, ld2we_, &fjacd_[0 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((0)))], ($5_ = (*n_) * (*m_), 
      &$5_), &fjacd_[0 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((0)))], ($6_ = (*n_) * (*m_), &$6_));
    }
  }
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _dfctr (logical_4 _p_ oksemi_, real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ info_)
{
  static int_4 j_, k_;
  static real_8 xi_, s_, t_, ten_, zero_;
  int_4 _data_k_3, $0_;
  extern real_8 _ddot ();
#define _data_n_3 2
  static real_8 _data_l_3[_data_n_3] = {
    0.0e0,
    10.0e0
  };
  if (__calls[4].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    zero_ = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    ten_ = _data_l_3[_data_k_3++];
  }
  xi_ = -ten_ * _dmprec ();
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (*info_) = j_;
    s_ = zero_;
    for (k_ = 1; k_ <= j_ - 1; (k_)++) {
      if (a_[k_ - 1 + ((*lda_)) * ((k_ - 1))] == zero_) {
        t_ = zero_;
      }
      else {
        t_ = a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] - _ddot (($0_ = k_ - 1, &$0_), &a_[0 + ((*lda_)) * ((k_ - 1))], &_k1, &a_[0 + 
        ((*lda_)) * ((j_ - 1))], &_k1);
        t_ = t_ / a_[k_ - 1 + ((*lda_)) * ((k_ - 1))];
      }
      a_[k_ - 1 + ((*lda_)) * ((j_ - 1))] = t_;
      s_ = s_ + t_ * t_;
    }
    s_ = a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] - s_;
    if (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] < zero_ || s_ < xi_ * _abs (a_[j_ - 1 + ((*lda_)) * ((j_ - 1))])) {
      goto _l0;
    }
    else if (! ((*oksemi_)) && s_ <= zero_) {
      goto _l0;
    }
    else if (s_ <= zero_) {
      a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = zero_;
    }
    else {
      a_[j_ - 1 + ((*lda_)) * ((j_ - 1))] = sqrt (s_);
    }
  }
  (*info_) = 0;
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    for (k_ = 1; k_ <= j_ - 1; (k_)++) {
      a_[j_ - 1 + ((*lda_)) * ((k_ - 1))] = zero_;
    }
  }
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _dfctrw (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ nq_, int_4 _p_ npp_, logical_4 _p_ isodr_, real_8 _p_ we_, int_4 
_p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ wrk0_, real_8 _p_ wrk4_, 
real_8 _p_ we1_, int_4 _p_ nnzw_, int_4 _p_ info_)
{
  static int_4 i_, inf_, j_, j1_, j2_, l_, l1_, l2_;
  static logical_4 notzro_;
  static real_8 zero_;
  int_4 _data_k_4;
  logical_4 $0_, $1_, $2_, $3_;
#define _data_n_4 1
  static real_8 _data_l_4[_data_n_4] = {
    0.0e0
  };
  if (__calls[5].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    zero_ = _data_l_4[_data_k_4++];
  }
  if (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))] < zero_) {
    we1_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))] = -sqrt (_abs (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))]));
    (*nnzw_) = (*n_);
  }
  else {
    (*nnzw_) = 0;
    if ((*ldwe_) == 1) {
      if ((*ld2we_) == 1) {
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          if (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))] > zero_) {
            (*nnzw_) = (*n_);
            we1_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))] = sqrt (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))])
            ;
          }
          else if (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))] < zero_) {
            (*info_) = 30010;
            goto _l300;
          }
        }
      }
      else {
        for (l1_ = 1; l1_ <= (*nq_); (l1_)++) {
          for (l2_ = l1_; l2_ <= (*nq_); (l2_)++) {
            wrk0_[l1_ - 1 + ((*nq_)) * ((l2_ - 1))] = we_[0 + ((*ldwe_)) * ((l1_ - 1) + ((*ld2we_)) * ((l2_ - 1)))];
          }
        }
        (void) _dfctr (($0_ = TRUE, &$0_), wrk0_, nq_, nq_, &inf_);
        if (inf_ != 0) {
          (*info_) = 30010;
          goto _l300;
        }
        else {
          for (l1_ = 1; l1_ <= (*nq_); (l1_)++) {
            for (l2_ = 1; l2_ <= (*nq_); (l2_)++) {
              we1_[0 + ((*ldwe_)) * ((l1_ - 1) + ((*ld2we_)) * ((l2_ - 1)))] = wrk0_[l1_ - 1 + ((*nq_)) * ((l2_ - 1))];
            }
            if (we1_[0 + ((*ldwe_)) * ((l1_ - 1) + ((*ld2we_)) * ((l1_ - 1)))] != zero_) {
              (*nnzw_) = (*n_);
            }
          }
        }
      }
    }
    else {
      if ((*ld2we_) == 1) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          notzro_ = FALSE;
          for (l_ = 1; l_ <= (*nq_); (l_)++) {
            if (we_[i_ - 1 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))] > zero_) {
              notzro_ = TRUE;
              we1_[i_ - 1 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))] = sqrt (we_[i_ - 1 + ((*ldwe_)) * ((0) + ((*ld2we_)) * 
              ((l_ - 1)))]);
            }
            else if (we_[i_ - 1 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))] < zero_) {
              (*info_) = 30010;
              goto _l300;
            }
          }
          if (notzro_) {
            (*nnzw_) = (*nnzw_) + 1;
          }
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          for (l1_ = 1; l1_ <= (*nq_); (l1_)++) {
            for (l2_ = l1_; l2_ <= (*nq_); (l2_)++) {
              wrk0_[l1_ - 1 + ((*nq_)) * ((l2_ - 1))] = we_[i_ - 1 + ((*ldwe_)) * ((l1_ - 1) + ((*ld2we_)) * ((l2_ - 1)))];
            }
          }
          (void) _dfctr (($1_ = TRUE, &$1_), wrk0_, nq_, nq_, &inf_);
          if (inf_ != 0) {
            (*info_) = 30010;
            goto _l300;
          }
          else {
            notzro_ = FALSE;
            for (l1_ = 1; l1_ <= (*nq_); (l1_)++) {
              for (l2_ = 1; l2_ <= (*nq_); (l2_)++) {
                we1_[i_ - 1 + ((*ldwe_)) * ((l1_ - 1) + ((*ld2we_)) * ((l2_ - 1)))] = wrk0_[l1_ - 1 + ((*nq_)) * ((l2_ - 1))];
              }
              if (we1_[i_ - 1 + ((*ldwe_)) * ((l1_ - 1) + ((*ld2we_)) * ((l1_ - 1)))] != zero_) {
                notzro_ = TRUE;
              }
            }
          }
          if (notzro_) {
            (*nnzw_) = (*nnzw_) + 1;
          }
        }
      }
    }
  }
  if ((*nnzw_) < (*npp_)) {
    (*info_) = 30020;
  }
  _l300:;
  if (! ((*isodr_)) || wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))] < zero_) {
    goto _l0;
  }
  else {
    if ((*ldwd_) == 1) {
      if ((*ld2wd_) == 1) {
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          if (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((j_ - 1)))] <= zero_) {
            (*info_) = _max (30001, (*info_) + 1);
            goto _l0;
          }
        }
      }
      else {
        for (j1_ = 1; j1_ <= (*m_); (j1_)++) {
          for (j2_ = j1_; j2_ <= (*m_); (j2_)++) {
            wrk4_[j1_ - 1 + ((*m_)) * ((j2_ - 1))] = wd_[0 + ((*ldwd_)) * ((j1_ - 1) + ((*ld2wd_)) * ((j2_ - 1)))];
          }
        }
        (void) _dfctr (($2_ = FALSE, &$2_), wrk4_, m_, m_, &inf_);
        if (inf_ != 0) {
          (*info_) = _max (30001, (*info_) + 1);
          goto _l0;
        }
      }
    }
    else {
      if ((*ld2wd_) == 1) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            if (wd_[i_ - 1 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((j_ - 1)))] <= zero_) {
              (*info_) = _max (30001, (*info_) + 1);
              goto _l0;
            }
          }
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          for (j1_ = 1; j1_ <= (*m_); (j1_)++) {
            for (j2_ = j1_; j2_ <= (*m_); (j2_)++) {
              wrk4_[j1_ - 1 + ((*m_)) * ((j2_ - 1))] = wd_[i_ - 1 + ((*ldwd_)) * ((j1_ - 1) + ((*ld2wd_)) * ((j2_ - 1)))];
            }
          }
          (void) _dfctr (($3_ = FALSE, &$3_), wrk4_, m_, m_, &inf_);
          if (inf_ != 0) {
            (*info_) = _max (30001, (*info_) + 1);
            goto _l0;
          }
        }
      }
    }
  }
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _dflags (int_4 _p_ job_, logical_4 _p_ restrt_, logical_4 _p_ initd_, logical_4 _p_ dovcv_, logical_4 _p_ redoj_, 
logical_4 _p_ anajac_, logical_4 _p_ cdjac_, logical_4 _p_ chkjac_, logical_4 _p_ isodr_, logical_4 _p_ implct_)
{
  static int_4 j_;
  if ((*job_) >= 0) {
    (*restrt_) = (*job_) >= 10000;
    (*initd_) = _imod ((*job_), 10000) / 1000 == 0;
    j_ = _imod ((*job_), 1000) / 100;
    if (j_ == 0) {
      (*dovcv_) = TRUE;
      (*redoj_) = TRUE;
    }
    else if (j_ == 1) {
      (*dovcv_) = TRUE;
      (*redoj_) = FALSE;
    }
    else {
      (*dovcv_) = FALSE;
      (*redoj_) = FALSE;
    }
    j_ = _imod ((*job_), 100) / 10;
    if (j_ == 0) {
      (*anajac_) = FALSE;
      (*cdjac_) = FALSE;
      (*chkjac_) = FALSE;
    }
    else if (j_ == 1) {
      (*anajac_) = FALSE;
      (*cdjac_) = TRUE;
      (*chkjac_) = FALSE;
    }
    else if (j_ == 2) {
      (*anajac_) = TRUE;
      (*cdjac_) = FALSE;
      (*chkjac_) = TRUE;
    }
    else {
      (*anajac_) = TRUE;
      (*cdjac_) = FALSE;
      (*chkjac_) = FALSE;
    }
    j_ = _imod ((*job_), 10);
    if (j_ == 0) {
      (*isodr_) = TRUE;
      (*implct_) = FALSE;
    }
    else if (j_ == 1) {
      (*isodr_) = TRUE;
      (*implct_) = TRUE;
    }
    else {
      (*isodr_) = FALSE;
      (*implct_) = FALSE;
    }
  }
  else {
    (*restrt_) = FALSE;
    (*initd_) = TRUE;
    (*dovcv_) = TRUE;
    (*redoj_) = TRUE;
    (*anajac_) = FALSE;
    (*cdjac_) = FALSE;
    (*chkjac_) = FALSE;
    (*isodr_) = TRUE;
    (*implct_) = FALSE;
  }
  __calls[6].calls++;
  return 0;
}

real_8 _dhstep (int_4 _p_ itype_, int_4 _p_ neta_, int_4 _p_ i_, int_4 _p_ j_, real_8 _p_ stp_, int_4 _p_ ldstp_)
{
  static real_8 ten_, three_, two_, zero_;
  int_4 _data_k_5;
  real_8 dhstep_;
#define _data_n_5 4
  static real_8 _data_l_5[_data_n_5] = {
    0.0e0,
    2.0e0,
    3.0e0,
    10.0e0
  };
  if (__calls[7].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    zero_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    two_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    three_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    ten_ = _data_l_5[_data_k_5++];
  }
  if (stp_[0 + ((*ldstp_)) * ((0))] <= zero_) {
    if ((*itype_) == 0) {
      dhstep_ = pow (ten_, (-_abs ((*neta_)) / two_ - two_));
    }
    else {
      dhstep_ = pow (ten_, (-_abs ((*neta_)) / three_));
    }
  }
  else if ((*ldstp_) == 1) {
    dhstep_ = stp_[0 + ((*ldstp_)) * (((*j_) - 1))];
  }
  else {
    dhstep_ = stp_[(*i_) - 1 + ((*ldstp_)) * (((*j_) - 1))];
  }
  __calls[7].calls++;
  return dhstep_;
}

int_4 _difix (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ ifix_, int_4 _p_ ldifix_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ 
tfix_, int_4 _p_ ldtfix_)
{
  static int_4 i_, j_;
  static real_8 zero_;
  int_4 _data_k_6;
#define _data_n_6 1
  static real_8 _data_l_6[_data_n_6] = {
    0.0e0
  };
  if (__calls[8].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    zero_ = _data_l_6[_data_k_6++];
  }
  if ((*n_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  if (ifix_[0 + ((*ldifix_)) * ((0))] >= zero_) {
    if ((*ldifix_) >= (*n_)) {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          if (ifix_[i_ - 1 + ((*ldifix_)) * ((j_ - 1))] == 0) {
            tfix_[i_ - 1 + ((*ldtfix_)) * ((j_ - 1))] = zero_;
          }
          else {
            tfix_[i_ - 1 + ((*ldtfix_)) * ((j_ - 1))] = t_[i_ - 1 + ((*ldt_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        if (ifix_[0 + ((*ldifix_)) * ((j_ - 1))] == 0) {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            tfix_[i_ - 1 + ((*ldtfix_)) * ((j_ - 1))] = zero_;
          }
        }
        else {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            tfix_[i_ - 1 + ((*ldtfix_)) * ((j_ - 1))] = t_[i_ - 1 + ((*ldt_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _diniwk (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 
_p_ liwork_, real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ scld_, int_4 _p_ ldscld_, 
real_8 _p_ beta_, real_8 _p_ sclb_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, real_8 _p_ taufac_, int_4 
_p_ job_, int_4 _p_ iprint_, int_4 _p_ lunerr_, int_4 _p_ lunrpt_, int_4 _p_ epsmai_, int_4 _p_ sstoli_, int_4 _p_ 
partli_, int_4 _p_ maxiti_, int_4 _p_ taufci_, int_4 _p_ jobi_, int_4 _p_ iprini_, int_4 _p_ luneri_, int_4 _p_ lunrpi_
, int_4 _p_ ssfi_, int_4 _p_ tti_, int_4 _p_ ldtti_, int_4 _p_ deltai_)
{
  static int_4 i_, j_;
  static logical_4 anajac_, cdjac_, chkjac_, dovcv_, implct_, initd_, isodr_, redoj_, restrt_;
  static real_8 one_, three_, two_, zero_;
  int_4 _data_k_7;
  extern int_4 _dcopy ();
#define _data_n_7 4
  static real_8 _data_l_7[_data_n_7] = {
    0.0e0,
    1.0e0,
    2.0e0,
    3.0e0
  };
  if (__calls[9].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    zero_ = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    one_ = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    two_ = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    three_ = _data_l_7[_data_k_7++];
  }
  (void) _dflags (job_, &restrt_, &initd_, &dovcv_, &redoj_, &anajac_, &cdjac_, &chkjac_, &isodr_, &implct_);
  work_[(*epsmai_) - 1] = _dmprec ();
  if ((*partol_) < zero_) {
    work_[(*partli_) - 1] = pow (work_[(*epsmai_) - 1], (two_ / three_));
  }
  else {
    work_[(*partli_) - 1] = _min ((*partol_), one_);
  }
  if ((*sstol_) < zero_) {
    work_[(*sstoli_) - 1] = sqrt (work_[(*epsmai_) - 1]);
  }
  else {
    work_[(*sstoli_) - 1] = _min ((*sstol_), one_);
  }
  if ((*taufac_) <= zero_) {
    work_[(*taufci_) - 1] = one_;
  }
  else {
    work_[(*taufci_) - 1] = _min ((*taufac_), one_);
  }
  if ((*maxit_) < 0) {
    iwork_[(*maxiti_) - 1] = 50;
  }
  else {
    iwork_[(*maxiti_) - 1] = (*maxit_);
  }
  if ((*job_) <= 0) {
    iwork_[(*jobi_) - 1] = 0;
  }
  else {
    iwork_[(*jobi_) - 1] = (*job_);
  }
  if ((*iprint_) < 0) {
    iwork_[(*iprini_) - 1] = 2001;
  }
  else {
    iwork_[(*iprini_) - 1] = (*iprint_);
  }
  if ((*lunerr_) < 0) {
    iwork_[(*luneri_) - 1] = 6;
  }
  else {
    iwork_[(*luneri_) - 1] = (*lunerr_);
  }
  if ((*lunrpt_) < 0) {
    iwork_[(*lunrpi_) - 1] = 6;
  }
  else {
    iwork_[(*lunrpi_) - 1] = (*lunrpt_);
  }
  if (sclb_[0] <= zero_) {
    (void) _dsclb (np_, beta_, &work_[(*ssfi_) - 1]);
  }
  else {
    (void) _dcopy (np_, sclb_, &_k1, &work_[(*ssfi_) - 1], &_k1);
  }
  if (isodr_) {
    if (scld_[0 + ((*ldscld_)) * ((0))] <= zero_) {
      iwork_[(*ldtti_) - 1] = (*n_);
      (void) _dscld (n_, m_, x_, ldx_, &work_[(*tti_) - 1], &iwork_[(*ldtti_) - 1]);
    }
    else {
      if ((*ldscld_) == 1) {
        iwork_[(*ldtti_) - 1] = 1;
        (void) _dcopy (m_, &scld_[0 + ((*ldscld_)) * ((0))], &_k1, &work_[(*tti_) - 1], &_k1);
      }
      else {
        iwork_[(*ldtti_) - 1] = (*n_);
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          (void) _dcopy (n_, &scld_[0 + ((*ldscld_)) * ((j_ - 1))], &_k1, &work_[(*tti_) + (j_ - 1) * iwork_[(*ldtti_) - 1] - 1], 
          &_k1);
        }
      }
    }
  }
  if (isodr_) {
    if (initd_) {
      (void) _dzero (n_, m_, &work_[(*deltai_) - 1], n_);
    }
    else {
      if (ifixx_[0 + ((*ldifx_)) * ((0))] >= 0) {
        if ((*ldifx_) == 1) {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            if (ifixx_[0 + ((*ldifx_)) * ((j_ - 1))] == 0) {
              (void) _dzero (n_, &_k1, &work_[(*deltai_) + (j_ - 1) * (*n_) - 1], n_);
            }
          }
        }
        else {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              if (ifixx_[i_ - 1 + ((*ldifx_)) * ((j_ - 1))] == 0) {
                work_[(*deltai_) - 1 + i_ + (j_ - 1) * (*n_) - 1] = zero_;
              }
            }
          }
        }
      }
    }
  }
  else {
    (void) _dzero (n_, m_, &work_[(*deltai_) - 1], n_);
  }
  __calls[9].calls++;
  return 0;
}
int_4 _diwinf (int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ msgbi_, int_4 _p_ msgdi_, int_4 _p_ ifix2i_, int_4 
_p_ istopi_, int_4 _p_ nnzwi_, int_4 _p_ nppi_, int_4 _p_ idfi_, int_4 _p_ jobi_, int_4 _p_ iprini_, int_4 _p_ luneri_, 
int_4 _p_ lunrpi_, int_4 _p_ nrowi_, int_4 _p_ ntoli_, int_4 _p_ netai_, int_4 _p_ maxiti_, int_4 _p_ niteri_, int_4 
_p_ nfevi_, int_4 _p_ njevi_, int_4 _p_ int2i_, int_4 _p_ iranki_, int_4 _p_ ldtti_, int_4 _p_ liwkmn_)
{
  if ((*np_) >= 1 && (*m_) >= 1) {
    (*msgbi_) = 1;
    (*msgdi_) = (*msgbi_) + (*nq_) * (*np_) + 1;
    (*ifix2i_) = (*msgdi_) + (*nq_) * (*m_) + 1;
    (*istopi_) = (*ifix2i_) + (*np_);
    (*nnzwi_) = (*istopi_) + 1;
    (*nppi_) = (*nnzwi_) + 1;
    (*idfi_) = (*nppi_) + 1;
    (*jobi_) = (*idfi_) + 1;
    (*iprini_) = (*jobi_) + 1;
    (*luneri_) = (*iprini_) + 1;
    (*lunrpi_) = (*luneri_) + 1;
    (*nrowi_) = (*lunrpi_) + 1;
    (*ntoli_) = (*nrowi_) + 1;
    (*netai_) = (*ntoli_) + 1;
    (*maxiti_) = (*netai_) + 1;
    (*niteri_) = (*maxiti_) + 1;
    (*nfevi_) = (*niteri_) + 1;
    (*njevi_) = (*nfevi_) + 1;
    (*int2i_) = (*njevi_) + 1;
    (*iranki_) = (*int2i_) + 1;
    (*ldtti_) = (*iranki_) + 1;
    (*liwkmn_) = (*ldtti_);
  }
  else {
    (*msgbi_) = 1;
    (*msgdi_) = 1;
    (*ifix2i_) = 1;
    (*istopi_) = 1;
    (*nnzwi_) = 1;
    (*nppi_) = 1;
    (*idfi_) = 1;
    (*jobi_) = 1;
    (*iprini_) = 1;
    (*luneri_) = 1;
    (*lunrpi_) = 1;
    (*nrowi_) = 1;
    (*ntoli_) = 1;
    (*netai_) = 1;
    (*maxiti_) = 1;
    (*niteri_) = 1;
    (*nfevi_) = 1;
    (*njevi_) = 1;
    (*int2i_) = 1;
    (*iranki_) = 1;
    (*ldtti_) = 1;
    (*liwkmn_) = 1;
  }
  __calls[10].calls++;
  return 0;
}

int_4 _djaccd (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
x_, int_4 _p_ ldx_, real_8 _p_ delta_, real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 
_p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ ldtt_, int_4 _p_ neta_, 
real_8 _p_ stp_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk6_, real_8 _p_ fjacb_, logical_4 
_p_ isodr_, real_8 _p_ fjacd_, int_4 _p_ nfev_, int_4 _p_ istop_)
{
  static int_4 i_, j_, k_, l_;
  static logical_4 doit_, setzro_;
  static real_8 betak_, one_, typj_, zero_;
  int_4 _data_k_8;
#define _data_n_8 2
  static real_8 _data_l_8[_data_n_8] = {
    0.0e0,
    1.0e0
  };
  if (__calls[11].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    zero_ = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    one_ = _data_l_8[_data_k_8++];
  }
  for (k_ = 1; k_ <= (*np_); (k_)++) {
    if (ifixb_[0] >= 0) {
      if (ifixb_[k_ - 1] == 0) {
        doit_ = FALSE;
      }
      else {
        doit_ = TRUE;
      }
    }
    else {
      doit_ = TRUE;
    }
    if (! (doit_)) {
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        (void) _dzero (n_, &_k1, &fjacb_[0 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((l_ - 1)))], n_);
      }
    }
    else {
      betak_ = beta_[k_ - 1];
      if (betak_ == zero_) {
        if (ssf_[0] < zero_) {
          typj_ = one_ / _abs (ssf_[0]);
        }
        else {
          typj_ = one_ / ssf_[k_ - 1];
        }
      }
      else {
        typj_ = _abs (betak_);
      }
      wrk3_[k_ - 1] = betak_ + _sign (one_, betak_) * typj_ * _dhstep (&_k1, neta_, &_k1, &k_, stpb_, &_k1);
      wrk3_[k_ - 1] = wrk3_[k_ - 1] - betak_;
      beta_[k_ - 1] = betak_ + wrk3_[k_ - 1];
      (*istop_) = 0;
      (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, &_k1, wrk2_, wrk6_, wrk1_, istop_)
      ;
      if ((*istop_) != 0) {
        goto _l0;
      }
      else {
        (*nfev_) = (*nfev_) + 1;
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            fjacb_[i_ - 1 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((l_ - 1)))] = wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))];
          }
        }
      }
      beta_[k_ - 1] = betak_ - wrk3_[k_ - 1];
      (*istop_) = 0;
      (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, &_k1, wrk2_, wrk6_, wrk1_, istop_)
      ;
      if ((*istop_) != 0) {
        goto _l0;
      }
      else {
        (*nfev_) = (*nfev_) + 1;
      }
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          fjacb_[i_ - 1 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((l_ - 1)))] = (fjacb_[i_ - 1 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((l_ 
          - 1)))] - wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))]) / (2 * wrk3_[k_ - 1]);
        }
      }
      beta_[k_ - 1] = betak_;
    }
  }
  if ((*isodr_)) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      if (ifixx_[0 + ((*ldifx_)) * ((0))] < 0) {
        doit_ = TRUE;
        setzro_ = FALSE;
      }
      else if ((*ldifx_) == 1) {
        if (ifixx_[0 + ((*ldifx_)) * ((j_ - 1))] == 0) {
          doit_ = FALSE;
        }
        else {
          doit_ = TRUE;
        }
        setzro_ = FALSE;
      }
      else {
        doit_ = FALSE;
        setzro_ = FALSE;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          if (ifixx_[i_ - 1 + ((*ldifx_)) * ((j_ - 1))] != 0) {
            doit_ = TRUE;
          }
          else {
            setzro_ = TRUE;
          }
        }
      }
      if (! (doit_)) {
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          (void) _dzero (n_, &_k1, &fjacd_[0 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))], n_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          if (xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] == zero_) {
            if (tt_[0 + ((*ldtt_)) * ((0))] < zero_) {
              typj_ = one_ / _abs (tt_[0 + ((*ldtt_)) * ((0))]);
            }
            else if ((*ldtt_) == 1) {
              typj_ = one_ / tt_[0 + ((*ldtt_)) * ((j_ - 1))];
            }
            else {
              typj_ = one_ / tt_[i_ - 1 + ((*ldtt_)) * ((j_ - 1))];
            }
          }
          else {
            typj_ = _abs (xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))]);
          }
          stp_[i_ - 1] = xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] + _sign (one_, xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))]) * typj_ * 
          _dhstep (&_k1, neta_, &i_, &j_, stpd_, ldstpd_);
          stp_[i_ - 1] = stp_[i_ - 1] - xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))];
          xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] = xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] + stp_[i_ - 1];
        }
        (*istop_) = 0;
        (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, &_k1, wrk2_, wrk6_, wrk1_, istop_)
        ;
        if ((*istop_) != 0) {
          goto _l0;
        }
        else {
          (*nfev_) = (*nfev_) + 1;
          for (l_ = 1; l_ <= (*nq_); (l_)++) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] = wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))];
            }
          }
        }
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + delta_[i_ - 1 + ((*n_)) * ((j_ - 1))] - 
          stp_[i_ - 1];
        }
        (*istop_) = 0;
        (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, &_k1, wrk2_, wrk6_, wrk1_, istop_)
        ;
        if ((*istop_) != 0) {
          goto _l0;
        }
        else {
          (*nfev_) = (*nfev_) + 1;
        }
        if (setzro_) {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            if (ifixx_[i_ - 1 + ((*ldifx_)) * ((j_ - 1))] == 0) {
              for (l_ = 1; l_ <= (*nq_); (l_)++) {
                fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] = zero_;
              }
            }
            else {
              for (l_ = 1; l_ <= (*nq_); (l_)++) {
                fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] = (fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 
                1)))] - wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))]) / (2 * stp_[i_ - 1]);
              }
            }
          }
        }
        else {
          for (l_ = 1; l_ <= (*nq_); (l_)++) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] = (fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 
              1)))] - wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))]) / (2 * stp_[i_ - 1]);
            }
          }
        }
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + delta_[i_ - 1 + ((*n_)) * ((j_ - 1))];
        }
      }
    }
  }
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _djacfd (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
x_, int_4 _p_ ldx_, real_8 _p_ delta_, real_8 _p_ xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 
_p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ ldtt_, int_4 _p_ neta_, 
real_8 _p_ fn_, real_8 _p_ stp_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk6_, real_8 _p_ 
fjacb_, logical_4 _p_ isodr_, real_8 _p_ fjacd_, int_4 _p_ nfev_, int_4 _p_ istop_)
{
  static int_4 i_, j_, k_, l_;
  static logical_4 doit_, setzro_;
  static real_8 betak_, one_, typj_, zero_;
  int_4 _data_k_9;
#define _data_n_9 2
  static real_8 _data_l_9[_data_n_9] = {
    0.0e0,
    1.0e0
  };
  if (__calls[12].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    zero_ = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    one_ = _data_l_9[_data_k_9++];
  }
  for (k_ = 1; k_ <= (*np_); (k_)++) {
    if (ifixb_[0] >= 0) {
      if (ifixb_[k_ - 1] == 0) {
        doit_ = FALSE;
      }
      else {
        doit_ = TRUE;
      }
    }
    else {
      doit_ = TRUE;
    }
    if (! (doit_)) {
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        (void) _dzero (n_, &_k1, &fjacb_[0 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((l_ - 1)))], n_);
      }
    }
    else {
      betak_ = beta_[k_ - 1];
      if (betak_ == zero_) {
        if (ssf_[0] < zero_) {
          typj_ = one_ / _abs (ssf_[0]);
        }
        else {
          typj_ = one_ / ssf_[k_ - 1];
        }
      }
      else {
        typj_ = _abs (betak_);
      }
      wrk3_[k_ - 1] = betak_ + _sign (one_, betak_) * typj_ * _dhstep (&_k0, neta_, &_k1, &k_, stpb_, &_k1);
      wrk3_[k_ - 1] = wrk3_[k_ - 1] - betak_;
      beta_[k_ - 1] = betak_ + wrk3_[k_ - 1];
      (*istop_) = 0;
      (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, &_k1, wrk2_, wrk6_, wrk1_, istop_)
      ;
      if ((*istop_) != 0) {
        goto _l0;
      }
      else {
        (*nfev_) = (*nfev_) + 1;
      }
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          fjacb_[i_ - 1 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((l_ - 1)))] = (wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] - fn_[i_ - 1 + 
          ((*n_)) * ((l_ - 1))]) / wrk3_[k_ - 1];
        }
      }
      beta_[k_ - 1] = betak_;
    }
  }
  if ((*isodr_)) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      if (ifixx_[0 + ((*ldifx_)) * ((0))] < 0) {
        doit_ = TRUE;
        setzro_ = FALSE;
      }
      else if ((*ldifx_) == 1) {
        if (ifixx_[0 + ((*ldifx_)) * ((j_ - 1))] == 0) {
          doit_ = FALSE;
        }
        else {
          doit_ = TRUE;
        }
        setzro_ = FALSE;
      }
      else {
        doit_ = FALSE;
        setzro_ = FALSE;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          if (ifixx_[i_ - 1 + ((*ldifx_)) * ((j_ - 1))] != 0) {
            doit_ = TRUE;
          }
          else {
            setzro_ = TRUE;
          }
        }
      }
      if (! (doit_)) {
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          (void) _dzero (n_, &_k1, &fjacd_[0 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))], n_);
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          if (xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] == zero_) {
            if (tt_[0 + ((*ldtt_)) * ((0))] < zero_) {
              typj_ = one_ / _abs (tt_[0 + ((*ldtt_)) * ((0))]);
            }
            else if ((*ldtt_) == 1) {
              typj_ = one_ / tt_[0 + ((*ldtt_)) * ((j_ - 1))];
            }
            else {
              typj_ = one_ / tt_[i_ - 1 + ((*ldtt_)) * ((j_ - 1))];
            }
          }
          else {
            typj_ = _abs (xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))]);
          }
          stp_[i_ - 1] = xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] + _sign (one_, xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))]) * typj_ * 
          _dhstep (&_k0, neta_, &i_, &j_, stpd_, ldstpd_);
          stp_[i_ - 1] = stp_[i_ - 1] - xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))];
          xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] = xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] + stp_[i_ - 1];
        }
        (*istop_) = 0;
        (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, &_k1, wrk2_, wrk6_, wrk1_, istop_)
        ;
        if ((*istop_) != 0) {
          goto _l0;
        }
        else {
          (*nfev_) = (*nfev_) + 1;
          for (l_ = 1; l_ <= (*nq_); (l_)++) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] = wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))];
            }
          }
        }
        if (setzro_) {
          for (i_ = 1; i_ <= (*n_); (i_)++) {
            if (ifixx_[i_ - 1 + ((*ldifx_)) * ((j_ - 1))] == 0) {
              for (l_ = 1; l_ <= (*nq_); (l_)++) {
                fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] = zero_;
              }
            }
            else {
              for (l_ = 1; l_ <= (*nq_); (l_)++) {
                fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] = (fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 
                1)))] - fn_[i_ - 1 + ((*n_)) * ((l_ - 1))]) / stp_[i_ - 1];
              }
            }
          }
        }
        else {
          for (l_ = 1; l_ <= (*nq_); (l_)++) {
            for (i_ = 1; i_ <= (*n_); (i_)++) {
              fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] = (fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 
              1)))] - fn_[i_ - 1 + ((*n_)) * ((l_ - 1))]) / stp_[i_ - 1];
            }
          }
        }
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          xplusd_[i_ - 1 + ((*n_)) * ((j_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + delta_[i_ - 1 + ((*n_)) * ((j_ - 1))];
        }
      }
    }
  }
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _djckc (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ eta_, real_8 _p_ tol_, int_4 _p_ nrow_, 
real_8 _p_ epsmac_, int_4 _p_ j_, int_4 _p_ lq_, real_8 _p_ hc_, logical_4 _p_ iswrtb_, real_8 _p_ fd_, real_8 _p_ 
typj_, real_8 _p_ pvpstp_, real_8 _p_ stp0_, real_8 _p_ pv_, real_8 _p_ d_, real_8 _p_ diffj_, int_4 _p_ msg_, int_4 
_p_ istop_, int_4 _p_ nfev_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_)
{
  static real_8 curve_, one_, pvmcrv_, pvpcrv_, p01_, stp_, stpcrv_, ten_, two_;
  int_4 _data_k_10;
  real_8 $0_, $1_, $2_;
#define _data_n_10 4
  static real_8 _data_l_10[_data_n_10] = {
    0.01e0,
    1.0e0,
    2.0e0,
    10.0e0
  };
  if (__calls[13].calls == 0) {
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    p01_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    one_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    two_ = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    ten_ = _data_l_10[_data_k_10++];
  }
  if ((*iswrtb_)) {
    stpcrv_ = ((*hc_) * (*typj_) * _sign (one_, beta_[(*j_) - 1]) + beta_[(*j_) - 1]) - beta_[(*j_) - 1];
    (void) _dpvb (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, &stpcrv_, istop_, nfev_, 
    &pvpcrv_, wrk1_, wrk2_, wrk6_);
    if ((*istop_) != 0) {
      goto _l0;
    }
    (void) _dpvb (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, ($0_ = -stpcrv_, &$0_), 
    istop_, nfev_, &pvmcrv_, wrk1_, wrk2_, wrk6_);
    if ((*istop_) != 0) {
      goto _l0;
    }
  }
  else {
    stpcrv_ = ((*hc_) * (*typj_) * _sign (one_, xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))]) + xplusd_[(*nrow_) - 1 + 
    ((*n_)) * (((*j_) - 1))]) - xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))];
    (void) _dpvd (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, &stpcrv_, istop_, nfev_, 
    &pvpcrv_, wrk1_, wrk2_, wrk6_);
    if ((*istop_) != 0) {
      goto _l0;
    }
    (void) _dpvd (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, ($1_ = -stpcrv_, &$1_), 
    istop_, nfev_, &pvmcrv_, wrk1_, wrk2_, wrk6_);
    if ((*istop_) != 0) {
      goto _l0;
    }
  }
  curve_ = _abs ((pvpcrv_ - (*pv_)) + (pvmcrv_ - (*pv_))) / (stpcrv_ * stpcrv_);
  curve_ = curve_ + (*eta_) * (_abs (pvpcrv_) + _abs (pvmcrv_) + two_ * _abs ((*pv_))) / ((stpcrv_ * stpcrv_));
  (void) _djckf (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, eta_, tol_, nrow_, j_, lq_, iswrtb_, 
  fd_, typj_, pvpstp_, stp0_, &curve_, pv_, d_, diffj_, msg_, istop_, nfev_, wrk1_, wrk2_, wrk6_);
  if ((*istop_) != 0) {
    goto _l0;
  }
  if (msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] == 0) {
    goto _l0;
  }
  stp_ = two_ * _max ((*tol_) * _abs ((*d_)) / curve_, (*epsmac_));
  if (stp_ < _abs (ten_ * (*stp0_))) {
    stp_ = _min (stp_, p01_ * _abs ((*stp0_)));
  }
  if ((*iswrtb_)) {
    stp_ = (stp_ * _sign (one_, beta_[(*j_) - 1]) + beta_[(*j_) - 1]) - beta_[(*j_) - 1];
    (void) _dpvb (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, &stp_, istop_, nfev_, 
    pvpstp_, wrk1_, wrk2_, wrk6_);
    if ((*istop_) != 0) {
      goto _l0;
    }
  }
  else {
    stp_ = (stp_ * _sign (one_, xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))]) + xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) 
    - 1))]) - xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))];
    (void) _dpvd (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, &stp_, istop_, nfev_, 
    pvpstp_, wrk1_, wrk2_, wrk6_);
    if ((*istop_) != 0) {
      goto _l0;
    }
  }
  (*fd_) = ((*pvpstp_) - (*pv_)) / stp_;
  (*diffj_) = _min ((*diffj_), _abs ((*fd_) - (*d_)) / _abs ((*d_)));
  if (_abs ((*fd_) - (*d_)) <= (*tol_) * _abs ((*d_))) {
    msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 0;
  }
  else if (_abs (stp_ * ((*fd_) - (*d_))) < two_ * (*eta_) * (_abs ((*pv_)) + _abs ((*pvpstp_))) + curve_ * ($2_ = 
    ((*epsmac_) * (*typj_)), $2_ * $2_)) {
    msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 5;
  }
  _l0:;
  __calls[13].calls++;
  return 0;
}

int_4 _djck (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, 
real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ ldtt_, real_8 _p_ eta_, int_4 _p_ neta_, int_4 _p_ ntol_, int_4 _p_ nrow_, 
logical_4 _p_ isodr_, real_8 _p_ epsmac_, real_8 _p_ pv0_, real_8 _p_ fjacb_, real_8 _p_ fjacd_, int_4 _p_ msgb_, int_4 
_p_ msgd_, real_8 _p_ diff_, int_4 _p_ istop_, int_4 _p_ nfev_, int_4 _p_ njev_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, 
real_8 _p_ wrk6_)
{
  static int_4 ideval_, j_, lq_, msgb1_, msgd1_;
  static logical_4 isfixd_, iswrtb_;
  static real_8 diffj_, h0_, hc0_, one_, p5_, pv_, tol_, typj_, zero_;
  int_4 _data_k_11;
#define _data_n_11 3
  static real_8 _data_l_11[_data_n_11] = {
    0.0e0,
    0.5e0,
    1.0e0
  };
  if (__calls[14].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    zero_ = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    p5_ = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    one_ = _data_l_11[_data_k_11++];
  }
  tol_ = pow ((*eta_), 0.25);
  (*ntol_) = _max (one_, p5_ - log10 (tol_));
  (*istop_) = 0;
  if ((*isodr_)) {
    ideval_ = 110;
  }
  else {
    ideval_ = 10;
  }
  (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, &ideval_, wrk2_, fjacb_, fjacd_, 
  istop_);
  if ((*istop_) != 0) {
    goto _l0;
  }
  else {
    (*njev_) = (*njev_) + 1;
  }
  msgb1_ = 0;
  msgd1_ = 0;
  for (lq_ = 1; lq_ <= (*nq_); (lq_)++) {
    pv_ = pv0_[(*nrow_) - 1 + ((*n_)) * ((lq_ - 1))];
    iswrtb_ = TRUE;
    for (j_ = 1; j_ <= (*np_); (j_)++) {
      if (ifixb_[0] < 0) {
        isfixd_ = FALSE;
      }
      else if (ifixb_[j_ - 1] == 0) {
        isfixd_ = TRUE;
      }
      else {
        isfixd_ = FALSE;
      }
      if (isfixd_) {
        msgb_[1 + lq_ + (j_ - 1) * (*nq_) - 1] = -1;
      }
      else {
        if (beta_[j_ - 1] == zero_) {
          if (ssf_[0] < zero_) {
            typj_ = one_ / _abs (ssf_[0]);
          }
          else {
            typj_ = one_ / ssf_[j_ - 1];
          }
        }
        else {
          typj_ = _abs (beta_[j_ - 1]);
        }
        h0_ = _dhstep (&_k0, neta_, &_k1, &j_, stpb_, &_k1);
        hc0_ = h0_;
        (void) _djckm (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, eta_, &tol_, nrow_, epsmac_, &j_, &lq_, 
        &typj_, &h0_, &hc0_, &iswrtb_, &pv_, &fjacb_[(*nrow_) - 1 + ((*n_)) * ((j_ - 1) + ((*np_)) * ((lq_ - 1)))], &diffj_, 
        &msgb1_, &msgb_[1], istop_, nfev_, wrk1_, wrk2_, wrk6_);
        if ((*istop_) != 0) {
          msgb_[0] = -1;
          goto _l0;
        }
        else {
          diff_[lq_ - 1 + ((*nq_)) * ((j_ - 1))] = diffj_;
        }
      }
    }
    if ((*isodr_)) {
      iswrtb_ = FALSE;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        if (ifixx_[0 + ((*ldifx_)) * ((0))] < 0) {
          isfixd_ = FALSE;
        }
        else if ((*ldifx_) == 1) {
          if (ifixx_[0 + ((*ldifx_)) * ((j_ - 1))] == 0) {
            isfixd_ = TRUE;
          }
          else {
            isfixd_ = FALSE;
          }
        }
        else {
          isfixd_ = FALSE;
        }
        if (isfixd_) {
          msgd_[1 + lq_ + (j_ - 1) * (*nq_) - 1] = -1;
        }
        else {
          if (xplusd_[(*nrow_) - 1 + ((*n_)) * ((j_ - 1))] == zero_) {
            if (tt_[0 + ((*ldtt_)) * ((0))] < zero_) {
              typj_ = one_ / _abs (tt_[0 + ((*ldtt_)) * ((0))]);
            }
            else if ((*ldtt_) == 1) {
              typj_ = one_ / tt_[0 + ((*ldtt_)) * ((j_ - 1))];
            }
            else {
              typj_ = one_ / tt_[(*nrow_) - 1 + ((*ldtt_)) * ((j_ - 1))];
            }
          }
          else {
            typj_ = _abs (xplusd_[(*nrow_) - 1 + ((*n_)) * ((j_ - 1))]);
          }
          h0_ = _dhstep (&_k0, neta_, nrow_, &j_, stpd_, ldstpd_);
          hc0_ = _dhstep (&_k1, neta_, nrow_, &j_, stpd_, ldstpd_);
          (void) _djckm (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, eta_, &tol_, nrow_, epsmac_, &j_, &lq_, 
          &typj_, &h0_, &hc0_, &iswrtb_, &pv_, &fjacd_[(*nrow_) - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((lq_ - 1)))], &diffj_, 
          &msgd1_, &msgd_[1], istop_, nfev_, wrk1_, wrk2_, wrk6_);
          if ((*istop_) != 0) {
            msgd_[0] = -1;
            goto _l0;
          }
          else {
            diff_[lq_ - 1 + ((*nq_)) * (((*np_) + j_ - 1))] = diffj_;
          }
        }
      }
    }
  }
  msgb_[0] = msgb1_;
  msgd_[0] = msgd1_;
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _djckf (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ eta_, real_8 _p_ tol_, int_4 _p_ nrow_, int_4 
_p_ j_, int_4 _p_ lq_, logical_4 _p_ iswrtb_, real_8 _p_ fd_, real_8 _p_ typj_, real_8 _p_ pvpstp_, real_8 _p_ stp0_, 
real_8 _p_ curve_, real_8 _p_ pv_, real_8 _p_ d_, real_8 _p_ diffj_, int_4 _p_ msg_, int_4 _p_ istop_, int_4 _p_ nfev_, 
real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_)
{
  static logical_4 large_;
  static real_8 hundrd_, one_, p1_, stp_, two_;
  int_4 _data_k_12;
#define _data_n_12 4
  static real_8 _data_l_12[_data_n_12] = {
    0.1e0,
    1.0e0,
    2.0e0,
    100.0e0
  };
  if (__calls[15].calls == 0) {
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    p1_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    one_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    two_ = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    hundrd_ = _data_l_12[_data_k_12++];
  }
  stp_ = (*eta_) * (_abs ((*pv_)) + _abs ((*pvpstp_))) / ((*tol_) * _abs ((*d_)));
  if (stp_ > _abs (p1_ * (*stp0_))) {
    stp_ = _max (stp_, hundrd_ * _abs ((*stp0_)));
  }
  if (stp_ > (*typj_)) {
    stp_ = (*typj_);
    large_ = TRUE;
  }
  else {
    large_ = FALSE;
  }
  if ((*iswrtb_)) {
    stp_ = (stp_ * _sign (one_, beta_[(*j_) - 1]) + beta_[(*j_) - 1]) - beta_[(*j_) - 1];
    (void) _dpvb (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, &stp_, istop_, nfev_, 
    pvpstp_, wrk1_, wrk2_, wrk6_);
  }
  else {
    stp_ = (stp_ * _sign (one_, xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))]) + xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) 
    - 1))]) - xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))];
    (void) _dpvd (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, &stp_, istop_, nfev_, 
    pvpstp_, wrk1_, wrk2_, wrk6_);
  }
  if ((*istop_) != 0) {
    goto _l0;
  }
  (*fd_) = ((*pvpstp_) - (*pv_)) / stp_;
  (*diffj_) = _min ((*diffj_), _abs ((*fd_) - (*d_)) / _abs ((*d_)));
  if ((_abs ((*fd_) - (*d_))) <= (*tol_) * _abs ((*d_))) {
    msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 0;
  }
  else if ((_abs ((*fd_) - (*d_)) <= _abs (two_ * (*curve_) * stp_)) || large_) {
    if (large_) {
      msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 4;
    }
    else {
      msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 5;
    }
  }
  _l0:;
  __calls[15].calls++;
  return 0;
}

int_4 _djckm (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ eta_, real_8 _p_ tol_, int_4 _p_ nrow_, 
real_8 _p_ epsmac_, int_4 _p_ j_, int_4 _p_ lq_, real_8 _p_ typj_, real_8 _p_ h0_, real_8 _p_ hc0_, logical_4 _p_ 
iswrtb_, real_8 _p_ pv_, real_8 _p_ d_, real_8 _p_ diffj_, int_4 _p_ msg1_, int_4 _p_ msg_, int_4 _p_ istop_, int_4 _p_ 
nfev_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_)
{
  static int_4 i_;
  static real_8 big_, fd_, h_, hc_, h1_, hc1_, hundrd_, one_, pvpstp_, p01_, p1_, stp0_, ten_, three_, tol2_, two_, zero_
  ;
  int_4 _data_k_13, _data_k_14;
#define _data_n_13 8
  static real_8 _data_l_13[_data_n_13] = {
    0.0e0,
    0.01e0,
    0.1e0,
    1.0e0,
    2.0e0,
    3.0e0,
    1.0e1,
    1.0e2
  };
#define _data_n_14 2
  static real_8 _data_l_14[_data_n_14] = {
    1.0e19,
    5.0e-2
  };
  if (__calls[16].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    zero_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    p01_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    p1_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    one_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    two_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    three_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    ten_ = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    hundrd_ = _data_l_13[_data_k_13++];
  }
  if (__calls[16].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    big_ = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    tol2_ = _data_l_14[_data_k_14++];
  }
  h1_ = sqrt ((*eta_));
  hc1_ = pow ((*eta_), (one_ / three_));
  msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 7;
  (*diffj_) = big_;
  for (i_ = 1; i_ <= 3; (i_)++) {
    if (i_ == 1) {
      h_ = (*h0_);
      hc_ = (*hc0_);
    }
    else if (i_ == 2) {
      h_ = _max (ten_ * h1_, _min (hundrd_ * (*h0_), one_));
      hc_ = _max (ten_ * hc1_, _min (hundrd_ * (*hc0_), one_));
    }
    else if (i_ == 3) {
      h_ = _min (p1_ * h1_, _max (p01_ * h_, two_ * (*epsmac_)));
      hc_ = _min (p1_ * hc1_, _max (p01_ * hc_, two_ * (*epsmac_)));
    }
    if ((*iswrtb_)) {
      stp0_ = (h_ * (*typj_) * _sign (one_, beta_[(*j_) - 1]) + beta_[(*j_) - 1]) - beta_[(*j_) - 1];
      (void) _dpvb (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, &stp0_, istop_, nfev_, 
      &pvpstp_, wrk1_, wrk2_, wrk6_);
    }
    else {
      stp0_ = (h_ * (*typj_) * _sign (one_, xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))]) + xplusd_[(*nrow_) - 1 + ((*n_)) 
      * (((*j_) - 1))]) - xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))];
      (void) _dpvd (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, &stp0_, istop_, nfev_, 
      &pvpstp_, wrk1_, wrk2_, wrk6_);
    }
    if ((*istop_) != 0) {
      goto _l0;
    }
    fd_ = (pvpstp_ - (*pv_)) / stp0_;
    if (_abs (fd_ - (*d_)) <= (*tol_) * _abs ((*d_))) {
      if (((*d_) == zero_) || (fd_ == zero_)) {
        (*diffj_) = _abs (fd_ - (*d_));
      }
      else {
        (*diffj_) = _abs (fd_ - (*d_)) / _abs ((*d_));
      }
      if ((*d_) == zero_) {
        msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 1;
      }
      else {
        msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 0;
      }
    }
    else {
      if (((*d_) == zero_) || (fd_ == zero_)) {
        (void) _djckz (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, epsmac_, j_, lq_, iswrtb_, tol_, 
        d_, &fd_, typj_, &pvpstp_, &stp0_, pv_, diffj_, msg_, istop_, nfev_, wrk1_, wrk2_, wrk6_);
      }
      else {
        (void) _djckc (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, eta_, tol_, nrow_, epsmac_, j_, lq_, 
        &hc_, iswrtb_, &fd_, typj_, &pvpstp_, &stp0_, pv_, d_, diffj_, msg_, istop_, nfev_, wrk1_, wrk2_, wrk6_);
      }
      if (msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] <= 2) {
        goto _l20;
      }
    }
  }
  _l20:;
  if ((msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] >= 7) && ((*diffj_) <= tol2_)) {
    msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 6;
  }
  if ((msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] >= 1) && (msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] <= 6)) {
    (*msg1_) = _max ((*msg1_), 1);
  }
  else if (msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] >= 7) {
    (*msg1_) = 2;
  }
  _l0:;
  __calls[16].calls++;
  return 0;
}

int_4 _djckz (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ nrow_, real_8 _p_ epsmac_, int_4 _p_ j_, int_4 
_p_ lq_, logical_4 _p_ iswrtb_, real_8 _p_ tol_, real_8 _p_ d_, real_8 _p_ fd_, real_8 _p_ typj_, real_8 _p_ pvpstp_, 
real_8 _p_ stp0_, real_8 _p_ pv_, real_8 _p_ diffj_, int_4 _p_ msg_, int_4 _p_ istop_, int_4 _p_ nfev_, real_8 _p_ 
wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_)
{
  static real_8 cd_, one_, pvmstp_, three_, two_, zero_;
  int_4 _data_k_15;
  real_8 $0_, $1_;
#define _data_n_15 4
  static real_8 _data_l_15[_data_n_15] = {
    0.0e0,
    1.0e0,
    2.0e0,
    3.0e0
  };
  if (__calls[17].calls == 0) {
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    zero_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    one_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    two_ = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    three_ = _data_l_15[_data_k_15++];
  }
  if ((*iswrtb_)) {
    (void) _dpvb (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, ($0_ = -(*stp0_), &$0_), 
    istop_, nfev_, &pvmstp_, wrk1_, wrk2_, wrk6_);
  }
  else {
    (void) _dpvd (_fcn, n_, m_, np_, nq_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, nrow_, j_, lq_, ($1_ = -(*stp0_), &$1_), 
    istop_, nfev_, &pvmstp_, wrk1_, wrk2_, wrk6_);
  }
  if ((*istop_) != 0) {
    goto _l0;
  }
  cd_ = ((*pvpstp_) - pvmstp_) / (two_ * (*stp0_));
  (*diffj_) = _min (_abs (cd_ - (*d_)), _abs ((*fd_) - (*d_)));
  if ((*diffj_) <= (*tol_) * _abs ((*d_))) {
    if ((*d_) == zero_) {
      msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 1;
    }
    else {
      msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 0;
    }
  }
  else if ((*diffj_) * (*typj_) <= _abs ((*pv_) * pow ((*epsmac_), (one_ / three_)))) {
    msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 2;
  }
  else {
    msg_[(*lq_) - 1 + ((*nq_)) * (((*j_) - 1))] = 3;
  }
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _dluno (int_4 _p_ lun_, char _p_ fn_)
{
  int_4 $u_0_;
  $u_0_ = (*lun_);
  _fregister ("odrpack:dluno:7", $u_0_, 0, fn_, form_unformatted, action_default, disp_new);
  __calls[18].calls++;
  return 0;
}

int_4 _dlunc (int_4 _p_ lun_)
{
  int_4 $u_0_;
  $u_0_ = (*lun_);
  _fcheck ("odrpack:dlunc:14", $u_0_, NULL, NULL);
  if (_ffile[$u_0_].unit != NULL) {
    _funregister ("odrpack:dlunc:14", $u_0_);
    if (errno != 0) {
      _ioerr ("odrpack:dlunc:14", $u_0_);
    }
  }
  __calls[19].calls++;
  return 0;
}

real_8 _dmprec (void)
{
  static int_4 td_, ts_;
  static real_8 b_;
  int_4 $0_;
  real_8 dmprec_;
  extern real_8 _d1mach ();
  dmprec_ = _d1mach (($0_ = 4, &$0_));
  __calls[20].calls++;
  return dmprec_;
}

int_4 _dodchk (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, logical_4 _p_ isodr_, logical_4 _p_ anajac_, 
logical_4 _p_ implct_, int_4 _p_ ifixb_, int_4 _p_ ldx_, int_4 _p_ ldifx_, int_4 _p_ ldscld_, int_4 _p_ ldstpd_, int_4 
_p_ ldwe_, int_4 _p_ ld2we_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ ldy_, int_4 _p_ lwork_, int_4 _p_ lwkmn_, 
int_4 _p_ liwork_, int_4 _p_ liwkmn_, real_8 _p_ sclb_, real_8 _p_ scld_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ 
info_)
{
  static int_4 i_, j_, k_, last_, npp_;
  if ((*np_) <= 0 || ifixb_[0] < 0) {
    npp_ = (*np_);
  }
  else {
    npp_ = 0;
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      if (ifixb_[k_ - 1] != 0) {
        npp_ = npp_ + 1;
      }
    }
  }
  if ((*n_) <= 0 || (*m_) <= 0 || (npp_ <= 0 || npp_ > (*n_)) || ((*nq_) <= 0)) {
    (*info_) = 10000;
    if ((*n_) <= 0) {
      (*info_) = (*info_) + 1000;
    }
    if ((*m_) <= 0) {
      (*info_) = (*info_) + 100;
    }
    if (npp_ <= 0 || npp_ > (*n_)) {
      (*info_) = (*info_) + 10;
    }
    if ((*nq_) <= 0) {
      (*info_) = (*info_) + 1;
    }
    goto _l0;
  }
  if ((! ((*implct_)) && (*ldy_) < (*n_)) || ((*ldx_) < (*n_)) || ((*ldwe_) != 1 && (*ldwe_) < (*n_)) || ((*ld2we_) != 1 
    && (*ld2we_) < (*nq_)) || ((*isodr_) && ((*ldwd_) != 1 && (*ldwd_) < (*n_))) || ((*isodr_) && ((*ld2wd_) != 1 && 
    (*ld2wd_) < (*m_))) || ((*isodr_) && ((*ldifx_) != 1 && (*ldifx_) < (*n_))) || ((*isodr_) && ((*ldstpd_) != 1 && 
    (*ldstpd_) < (*n_))) || ((*isodr_) && ((*ldscld_) != 1 && (*ldscld_) < (*n_))) || ((*lwork_) < (*lwkmn_)) || 
    ((*liwork_) < (*liwkmn_))) {
    (*info_) = 20000;
    if (! ((*implct_)) && (*ldy_) < (*n_)) {
      (*info_) = (*info_) + 1000;
    }
    if ((*ldx_) < (*n_)) {
      (*info_) = (*info_) + 2000;
    }
    if (((*ldwe_) != 1 && (*ldwe_) < (*n_)) || ((*ld2we_) != 1 && (*ld2we_) < (*nq_))) {
      (*info_) = (*info_) + 100;
    }
    if ((*isodr_) && (((*ldwd_) != 1 && (*ldwd_) < (*n_)) || ((*ld2wd_) != 1 && (*ld2wd_) < (*m_)))) {
      (*info_) = (*info_) + 200;
    }
    if ((*isodr_) && ((*ldifx_) != 1 && (*ldifx_) < (*n_))) {
      (*info_) = (*info_) + 10;
    }
    if ((*isodr_) && ((*ldstpd_) != 1 && (*ldstpd_) < (*n_))) {
      (*info_) = (*info_) + 20;
    }
    if ((*isodr_) && ((*ldscld_) != 1 && (*ldscld_) < (*n_))) {
      (*info_) = (*info_) + 40;
    }
    if ((*lwork_) < (*lwkmn_)) {
      (*info_) = (*info_) + 1;
    }
    if ((*liwork_) < (*liwkmn_)) {
      (*info_) = (*info_) + 2;
    }
    goto _l0;
  }
  if ((*isodr_) && scld_[0 + ((*ldscld_)) * ((0))] > 0) {
    if ((*ldscld_) >= (*n_)) {
      last_ = (*n_);
    }
    else {
      last_ = 1;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= last_; (i_)++) {
        if (scld_[i_ - 1 + ((*ldscld_)) * ((j_ - 1))] <= 0) {
          (*info_) = 30200;
          goto _l130;
        }
      }
    }
  }
  _l130:;
  if (sclb_[0] > 0) {
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      if (sclb_[k_ - 1] <= 0) {
        if ((*info_) == 0) {
          (*info_) = 30100;
        }
        else {
          (*info_) = (*info_) + 100;
        }
        goto _l220;
      }
    }
  }
  _l220:;
  if ((*anajac_) && (*isodr_) && stpd_[0 + ((*ldstpd_)) * ((0))] > 0) {
    if ((*ldstpd_) >= (*n_)) {
      last_ = (*n_);
    }
    else {
      last_ = 1;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= last_; (i_)++) {
        if (stpd_[i_ - 1 + ((*ldstpd_)) * ((j_ - 1))] <= 0) {
          if ((*info_) == 0) {
            (*info_) = 32000;
          }
          else {
            (*info_) = (*info_) + 2000;
          }
          goto _l330;
        }
      }
    }
  }
  _l330:;
  if ((*anajac_) && stpb_[0] > 0) {
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      if (stpb_[k_ - 1] <= 0) {
        if ((*info_) == 0) {
          (*info_) = 31000;
        }
        else {
          (*info_) = (*info_) + 1000;
        }
        goto _l420;
      }
    }
  }
  _l420:;
  _l0:;
  __calls[21].calls++;
  return 0;
}

int_4 _dodcnt (logical_4 _p_ short_, real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 
_p_ beta_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ 
ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 
_p_ job_, int_4 _p_ ndigit_, real_8 _p_ taufac_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, int_4 _p_ 
iprint_, int_4 _p_ lunerr_, int_4 _p_ lunrpt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ sclb_, 
real_8 _p_ scld_, int_4 _p_ ldscld_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ 
info_)
{
  static int_4 iprnti_, ipr1_, ipr2_, ipr2f_, ipr3_, jobi_, job1_, job2_, job3_, job4_, job5_, maxiti_, maxit1_;
  static logical_4 done_, fstitr_, head_, implct_, prtpen_;
  static real_8 cnvtol_, one_, pcheck_, pfac_, pstart_, three_, tstimp_, zero_, pnlty_[1];
  int_4 _data_k_16;
#define _data_n_16 6
  static real_8 _data_l_16[_data_n_16] = {
    1.0e3,
    1.0e1,
    1.0e1,
    0.0e0,
    1.0e0,
    3.0e0
  };
  if (__calls[22].calls == 0) {
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    pcheck_ = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    pstart_ = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    pfac_ = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    zero_ = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    one_ = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    three_ = _data_l_16[_data_k_16++];
  }
  implct_ = _imod ((*job_), 10) == 1;
  fstitr_ = TRUE;
  head_ = TRUE;
  prtpen_ = FALSE;
  if (implct_) {
    if ((*iprint_) >= 0) {
      ipr1_ = _imod ((*iprint_), 10000) / 1000;
      ipr2_ = _imod ((*iprint_), 1000) / 100;
      ipr2f_ = _imod ((*iprint_), 100) / 10;
      ipr3_ = _imod ((*iprint_), 10);
    }
    else {
      ipr1_ = 2;
      ipr2_ = 0;
      ipr2f_ = 0;
      ipr3_ = 1;
    }
    iprnti_ = ipr1_ * 1000 + ipr2_ * 100 + ipr2f_ * 10;
    job5_ = _imod ((*job_), 100000) / 10000;
    job4_ = _imod ((*job_), 10000) / 1000;
    job3_ = _imod ((*job_), 1000) / 100;
    job2_ = _imod ((*job_), 100) / 10;
    job1_ = _imod ((*job_), 10);
    jobi_ = job5_ * 10000 + job4_ * 1000 + job3_ * 100 + job2_ * 10 + job1_;
    if (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))] <= zero_) {
      pnlty_[0] = -pstart_;
    }
    else {
      pnlty_[0] = -we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))];
    }
    if ((*partol_) < zero_) {
      cnvtol_ = pow (_dmprec (), (one_ / three_));
    }
    else {
      cnvtol_ = _min ((*partol_), one_);
    }
    if ((*maxit_) >= 1) {
      maxiti_ = (*maxit_);
    }
    else {
      maxiti_ = 100;
    }
    done_ = maxiti_ == 0;
    prtpen_ = TRUE;
    _l10:;
    (void) _doddrv (short_, &head_, &fstitr_, &prtpen_, _fcn, n_, m_, np_, nq_, beta_, y_, ldy_, x_, ldx_, pnlty_, &_k1, 
    &_k1, wd_, ldwd_, ld2wd_, ifixb_, ifixx_, ldifx_, &jobi_, ndigit_, taufac_, sstol_, &cnvtol_, &maxiti_, &iprnti_, 
    lunerr_, lunrpt_, stpb_, stpd_, ldstpd_, sclb_, scld_, ldscld_, work_, lwork_, iwork_, liwork_, &maxit1_, &tstimp_, 
    info_);
    if (done_) {
      goto _l0;
    }
    else {
      done_ = maxit1_ <= 0 || (_abs (pnlty_[0]) >= pcheck_ && tstimp_ <= cnvtol_);
    }
    if (done_) {
      if (tstimp_ <= cnvtol_) {
        (*info_) = ((*info_) / 10) * 10 + 2;
      }
      else {
        (*info_) = ((*info_) / 10) * 10 + 4;
      }
      jobi_ = 10000 + 1000 + job3_ * 100 + job2_ * 10 + job1_;
      maxiti_ = 0;
      iprnti_ = ipr3_;
    }
    else {
      prtpen_ = TRUE;
      pnlty_[0] = pfac_ * pnlty_[0];
      jobi_ = 10000 + 1000 + 0 + job2_ * 10 + job1_;
      maxiti_ = maxit1_;
      iprnti_ = 00 + ipr2_ * 100 + ipr2f_ * 10;
    }
    goto _l10;
  }
  else {
    (void) _doddrv (short_, &head_, &fstitr_, &prtpen_, _fcn, n_, m_, np_, nq_, beta_, y_, ldy_, x_, ldx_, we_, ldwe_, 
    ld2we_, wd_, ldwd_, ld2wd_, ifixb_, ifixx_, ldifx_, job_, ndigit_, taufac_, sstol_, partol_, maxit_, iprint_, lunerr_, 
    lunrpt_, stpb_, stpd_, ldstpd_, sclb_, scld_, ldscld_, work_, lwork_, iwork_, liwork_, &maxit1_, &tstimp_, info_);
  }
  _l0:;
  __calls[22].calls++;
  return 0;
}

int_4 _doddrv (logical_4 _p_ short_, logical_4 _p_ head_, logical_4 _p_ fstitr_, logical_4 _p_ prtpen_, int_4 (*_fcn)()
, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ 
x_, int_4 _p_ ldx_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ 
ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ job_, int_4 _p_ ndigit_, real_8 _p_ taufac_, 
real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, int_4 _p_ iprint_, int_4 _p_ lunerr_, int_4 _p_ lunrpt_, 
real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ sclb_, real_8 _p_ scld_, int_4 _p_ ldscld_, real_8 
_p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ maxit1_, real_8 _p_ tstimp_, int_4 _p_ 
info_)
{
  static int_4 actrsi_, alphai_, betaci_, betani_, betasi_, beta0i_, deltai_, deltni_, deltsi_, diffi_, epsmai_, etai_, 
  fi_, fjacbi_, fjacdi_, fni_, fsi_, i_, idfi_, int2i_, iprini_, iranki_, istop_, istopi_, jobi_, jpvti_, k_, ldtt_, 
  ldtti_, liwkmn_, luneri_, lunrpi_, lwkmn_, lwrk_, maxiti_, msgb_, msgd_, neta_, netai_, nfev_, nfevi_, niteri_, njev_, 
  njevi_, nnzw_, nnzwi_, npp_, nppi_, nrow_, nrowi_, ntol_, ntoli_, olmavi_, omegai_, partli_, pnormi_, prersi_, qrauxi_, 
  rcondi_, rnorsi_, rvari_, sdi_, si_, ssfi_, ssi_, sstoli_, taufci_, taui_, ti_, tti_, ui_, vcvi_, we1i_, wrk1i_, wrk2i_
  , wrk3i_, wrk4i_, wrk5i_, wrk6i_, wrk7i_, wrk_, wssi_, wssdei_, wssepi_, xplusi_;
  static logical_4 anajac_, cdjac_, chkjac_, dovcv_, implct_, initd_, isodr_, redoj_, restrt_;
  static real_8 epsmac_, eta_, p5_, one_, ten_, zero_;
  int_4 _data_k_17, $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern int_4 _dcopy ();
#define _data_n_17 4
  static real_8 _data_l_17[_data_n_17] = {
    0.0e0,
    0.5e0,
    1.0e0,
    10.0e0
  };
  if (__calls[23].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    zero_ = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    p5_ = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    one_ = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    ten_ = _data_l_17[_data_k_17++];
  }
  (void) _dflags (job_, &restrt_, &initd_, &dovcv_, &redoj_, &anajac_, &cdjac_, &chkjac_, &isodr_, &implct_);
  (void) _diwinf (m_, np_, nq_, &msgb_, &msgd_, &jpvti_, &istopi_, &nnzwi_, &nppi_, &idfi_, &jobi_, &iprini_, &luneri_, 
  &lunrpi_, &nrowi_, &ntoli_, &netai_, &maxiti_, &niteri_, &nfevi_, &njevi_, &int2i_, &iranki_, &ldtti_, &liwkmn_);
  (void) _dwinf (n_, m_, np_, nq_, ldwe_, ld2we_, &isodr_, &deltai_, &fi_, &xplusi_, &fni_, &sdi_, &vcvi_, &rvari_, 
  &wssi_, &wssdei_, &wssepi_, &rcondi_, &etai_, &olmavi_, &taui_, &alphai_, &actrsi_, &pnormi_, &rnorsi_, &prersi_, 
  &partli_, &sstoli_, &taufci_, &epsmai_, &beta0i_, &betaci_, &betasi_, &betani_, &si_, &ssi_, &ssfi_, &qrauxi_, &ui_, 
  &fsi_, &fjacbi_, &we1i_, &diffi_, &deltsi_, &deltni_, &ti_, &tti_, &omegai_, &fjacdi_, &wrk1i_, &wrk2i_, &wrk3i_, 
  &wrk4i_, &wrk5i_, &wrk6i_, &wrk7i_, &lwkmn_);
  if (isodr_) {
    wrk_ = wrk1i_;
    lwrk_ = (*n_) * (*m_) * (*nq_) + (*n_) * (*nq_);
  }
  else {
    wrk_ = wrk2i_;
    lwrk_ = (*n_) * (*nq_);
  }
  if (restrt_ && implct_) {
    we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))] = _max ((work_[we1i_ - 1] * work_[we1i_ - 1]), _abs (we_[0 + 
    ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))]));
    work_[we1i_ - 1] = -sqrt (_abs (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))]));
  }
  if (restrt_) {
    if ((*maxit_) >= 0) {
      iwork_[maxiti_ - 1] = iwork_[niteri_ - 1] + (*maxit_);
    }
    else {
      iwork_[maxiti_ - 1] = iwork_[niteri_ - 1] + 10;
    }
    if (iwork_[niteri_ - 1] < iwork_[maxiti_ - 1]) {
      (*info_) = 0;
    }
    if ((*job_) >= 0) {
      iwork_[jobi_ - 1] = (*job_);
    }
    if ((*iprint_) >= 0) {
      iwork_[iprini_ - 1] = (*iprint_);
    }
    if ((*partol_) >= zero_ && (*partol_) < one_) {
      work_[partli_ - 1] = (*partol_);
    }
    if ((*sstol_) >= zero_ && (*sstol_) < one_) {
      work_[sstoli_ - 1] = (*sstol_);
    }
    work_[olmavi_ - 1] = work_[olmavi_ - 1] * iwork_[niteri_ - 1];
    if (implct_) {
      (void) _dcopy (($0_ = (*n_) * (*nq_), &$0_), &work_[fni_ - 1], &_k1, &work_[fi_ - 1], &_k1);
    }
    else {
      (void) _dxmy (n_, nq_, &work_[fni_ - 1], n_, y_, ldy_, &work_[fi_ - 1], n_);
    }
    (void) _dwght (n_, nq_, &work_[we1i_ - 1], ldwe_, ld2we_, &work_[fi_ - 1], n_, &work_[fi_ - 1], n_);
    work_[wssepi_ - 1] = _ddot (($1_ = (*n_) * (*nq_), &$1_), &work_[fi_ - 1], &_k1, &work_[fi_ - 1], &_k1);
    work_[wssi_ - 1] = work_[wssepi_ - 1] + work_[wssdei_ - 1];
  }
  else {
    (*info_) = 0;
    (void) _dodchk (n_, m_, np_, nq_, &isodr_, &anajac_, &implct_, ifixb_, ldx_, ldifx_, ldscld_, ldstpd_, ldwe_, ld2we_, 
    ldwd_, ld2wd_, ldy_, lwork_, &lwkmn_, liwork_, &liwkmn_, sclb_, scld_, stpb_, stpd_, info_);
    if ((*info_) > 0) {
      goto _l50;
    }
    for (i_ = (*n_) * (*m_) + (*n_) * (*nq_) + 1; i_ <= (*lwork_); (i_)++) {
      work_[i_ - 1] = zero_;
    }
    for (i_ = 1; i_ <= (*liwork_); (i_)++) {
      iwork_[i_ - 1] = 0;
    }
    (void) _diniwk (n_, m_, np_, work_, lwork_, iwork_, liwork_, x_, ldx_, ifixx_, ldifx_, scld_, ldscld_, beta_, sclb_, 
    sstol_, partol_, maxit_, taufac_, job_, iprint_, lunerr_, lunrpt_, &epsmai_, &sstoli_, &partli_, &maxiti_, &taufci_, 
    &jobi_, &iprini_, &luneri_, &lunrpi_, &ssfi_, &tti_, &ldtti_, &deltai_);
    iwork_[msgb_ - 1] = -1;
    iwork_[msgd_ - 1] = -1;
    work_[taui_ - 1] = -work_[taufci_ - 1];
    (void) _dpack (np_, &iwork_[nppi_ - 1], &work_[betaci_ - 1], beta_, ifixb_);
    (void) _dpack (np_, &iwork_[nppi_ - 1], &work_[ssi_ - 1], &work_[ssfi_ - 1], ifixb_);
    npp_ = iwork_[nppi_ - 1];
    (void) _dfctrw (n_, m_, nq_, &npp_, &isodr_, we_, ldwe_, ld2we_, wd_, ldwd_, ld2wd_, &work_[wrk2i_ - 1], &work_[wrk4i_ 
    - 1], &work_[we1i_ - 1], &nnzw_, info_);
    iwork_[nnzwi_ - 1] = nnzw_;
    if ((*info_) != 0) {
      goto _l50;
    }
    (void) _dunpac (np_, &work_[betaci_ - 1], beta_, ifixb_);
    (void) _dxpy (n_, m_, x_, ldx_, &work_[deltai_ - 1], n_, &work_[xplusi_ - 1], n_);
    istop_ = 0;
    (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, &work_[xplusi_ - 1], ifixb_, ifixx_, ldifx_, ($2_ = 2, &$2_), 
    &work_[fni_ - 1], &work_[wrk6i_ - 1], &work_[wrk1i_ - 1], &istop_);
    iwork_[istopi_ - 1] = istop_;
    if (istop_ == 0) {
      iwork_[nfevi_ - 1] = iwork_[nfevi_ - 1] + 1;
      if (implct_) {
        (void) _dcopy (($3_ = (*n_) * (*nq_), &$3_), &work_[fni_ - 1], &_k1, &work_[fi_ - 1], &_k1);
      }
      else {
        (void) _dxmy (n_, nq_, &work_[fni_ - 1], n_, y_, ldy_, &work_[fi_ - 1], n_);
      }
      (void) _dwght (n_, nq_, &work_[we1i_ - 1], ldwe_, ld2we_, &work_[fi_ - 1], n_, &work_[fi_ - 1], n_);
    }
    else {
      (*info_) = 52000;
      goto _l50;
    }
    (void) _dwght (&npp_, &_k1, &work_[ssi_ - 1], &npp_, &_k1, &work_[betaci_ - 1], &npp_, &work_[wrk_ - 1], &npp_);
    if (isodr_) {
      (void) _dwght (n_, m_, &work_[tti_ - 1], &iwork_[ldtti_ - 1], &_k1, &work_[deltai_ - 1], n_, &work_[wrk_ + npp_ - 1], 
      n_);
      work_[pnormi_ - 1] = _dnrm2 (($4_ = npp_ + (*n_) * (*m_), &$4_), &work_[wrk_ - 1], &_k1);
    }
    else {
      work_[pnormi_ - 1] = _dnrm2 (&npp_, &work_[wrk_ - 1], &_k1);
    }
    work_[wssepi_ - 1] = _ddot (($5_ = (*n_) * (*nq_), &$5_), &work_[fi_ - 1], &_k1, &work_[fi_ - 1], &_k1);
    if (isodr_) {
      (void) _dwght (n_, m_, wd_, ldwd_, ld2wd_, &work_[deltai_ - 1], n_, &work_[wrk_ - 1], n_);
      work_[wssdei_ - 1] = _ddot (($6_ = (*n_) * (*m_), &$6_), &work_[deltai_ - 1], &_k1, &work_[wrk_ - 1], &_k1);
    }
    else {
      work_[wssdei_ - 1] = zero_;
    }
    work_[wssi_ - 1] = work_[wssepi_ - 1] + work_[wssdei_ - 1];
    nrow_ = -1;
    (void) _dsetn (n_, m_, &work_[xplusi_ - 1], n_, &nrow_);
    iwork_[nrowi_ - 1] = nrow_;
    epsmac_ = work_[epsmai_ - 1];
    if ((*ndigit_) < 2) {
      iwork_[netai_ - 1] = -1;
      nfev_ = iwork_[nfevi_ - 1];
      (void) _detaf (_fcn, n_, m_, np_, nq_, &work_[xplusi_ - 1], beta_, &epsmac_, &nrow_, &work_[betani_ - 1], &work_[fni_ - 
      1], ifixb_, ifixx_, ldifx_, &istop_, &nfev_, &eta_, &neta_, &work_[wrk1i_ - 1], &work_[wrk2i_ - 1], &work_[wrk6i_ - 1], 
      &work_[wrk7i_ - 1]);
      iwork_[istopi_ - 1] = istop_;
      iwork_[nfevi_ - 1] = nfev_;
      if (istop_ != 0) {
        (*info_) = 53000;
        iwork_[netai_ - 1] = 0;
        work_[etai_ - 1] = zero_;
        goto _l50;
      }
      else {
        iwork_[netai_ - 1] = -neta_;
        work_[etai_ - 1] = eta_;
      }
    }
    else {
      iwork_[netai_ - 1] = _min ((*ndigit_), (int_4) (_aintd (p5_ - log10 (epsmac_))));
      work_[etai_ - 1] = _max (epsmac_, _up_real_8 (ten_, (-(*ndigit_))));
    }
    if (chkjac_ && anajac_) {
      ntol_ = -1;
      nfev_ = iwork_[nfevi_ - 1];
      njev_ = iwork_[njevi_ - 1];
      neta_ = iwork_[netai_ - 1];
      ldtt_ = iwork_[ldtti_ - 1];
      eta_ = work_[etai_ - 1];
      epsmac_ = work_[epsmai_ - 1];
      (void) _djck (_fcn, n_, m_, np_, nq_, beta_, &work_[xplusi_ - 1], ifixb_, ifixx_, ldifx_, stpb_, stpd_, ldstpd_, 
      &work_[ssfi_ - 1], &work_[tti_ - 1], &ldtt_, &eta_, &neta_, &ntol_, &nrow_, &isodr_, &epsmac_, &work_[fni_ - 1], 
      &work_[fjacbi_ - 1], &work_[fjacdi_ - 1], &iwork_[msgb_ - 1], &iwork_[msgd_ - 1], &work_[diffi_ - 1], &istop_, &nfev_, 
      &njev_, &work_[wrk1i_ - 1], &work_[wrk2i_ - 1], &work_[wrk6i_ - 1]);
      iwork_[istopi_ - 1] = istop_;
      iwork_[nfevi_ - 1] = nfev_;
      iwork_[njevi_ - 1] = njev_;
      iwork_[ntoli_ - 1] = ntol_;
      if (istop_ != 0) {
        (*info_) = 54000;
      }
      else if (iwork_[msgb_ - 1] != 0 || iwork_[msgd_ - 1] != 0) {
        (*info_) = 40000;
      }
    }
    else {
      iwork_[msgb_ - 1] = -1;
      iwork_[msgd_ - 1] = -1;
    }
    _l50:;
    if (((*info_) != 0) || (iwork_[msgb_ - 1] != -1)) {
      if ((*lunerr_) != 0 && (*iprint_) != 0) {
        (void) _dodper (info_, lunerr_, short_, n_, m_, np_, nq_, ldscld_, ldstpd_, ldwe_, ld2we_, ldwd_, ld2wd_, &lwkmn_, 
        &liwkmn_, &work_[fjacbi_ - 1], &work_[fjacdi_ - 1], &work_[diffi_ - 1], &iwork_[msgb_ - 1], &isodr_, &iwork_[msgd_ - 
        1], &work_[xplusi_ - 1], &iwork_[nrowi_ - 1], &iwork_[netai_ - 1], &iwork_[ntoli_ - 1]);
      }
      if ((*info_) == 40000) {
        if (iwork_[msgb_ - 1] == 2 || iwork_[msgd_ - 1] == 2) {
          if (iwork_[msgb_ - 1] == 2) {
            (*info_) = (*info_) + 1000;
          }
          if (iwork_[msgd_ - 1] == 2) {
            (*info_) = (*info_) + 100;
          }
        }
        else {
          (*info_) = 0;
        }
      }
      if ((*info_) != 0) {
        goto _l0;
      }
    }
  }
  (void) _dcopy (np_, beta_, &_k1, &work_[beta0i_ - 1], &_k1);
  (void) _dcopy (($7_ = (*n_) * (*nq_), &$7_), &work_[fni_ - 1], &_k1, &work_[fsi_ - 1], &_k1);
  ldtt_ = iwork_[ldtti_ - 1];
  (void) _dodmn (head_, fstitr_, prtpen_, _fcn, n_, m_, np_, nq_, job_, beta_, y_, ldy_, x_, ldx_, we_, &work_[we1i_ - 
  1], ldwe_, ld2we_, wd_, ldwd_, ld2wd_, ifixb_, ifixx_, ldifx_, &work_[betaci_ - 1], &work_[betani_ - 1], &work_[betasi_ 
  - 1], &work_[si_ - 1], &work_[deltai_ - 1], &work_[deltni_ - 1], &work_[deltsi_ - 1], &work_[ti_ - 1], &work_[fi_ - 1], 
  &work_[fni_ - 1], &work_[fsi_ - 1], &work_[fjacbi_ - 1], &iwork_[msgb_ - 1], &work_[fjacdi_ - 1], &iwork_[msgd_ - 1], 
  &work_[ssfi_ - 1], &work_[ssi_ - 1], &work_[tti_ - 1], &ldtt_, stpb_, stpd_, ldstpd_, &work_[xplusi_ - 1], &work_[wrk_ 
  - 1], &lwrk_, work_, lwork_, iwork_, liwork_, info_);
  (*maxit1_) = iwork_[maxiti_ - 1] - iwork_[niteri_ - 1];
  (*tstimp_) = zero_;
  for (k_ = 1; k_ <= (*np_); (k_)++) {
    if (beta_[k_ - 1] == zero_) {
      (*tstimp_) = _max ((*tstimp_), _abs (beta_[k_ - 1] - work_[beta0i_ - 1 + k_ - 1]) / work_[ssfi_ - 1 + k_ - 1]);
    }
    else {
      (*tstimp_) = _max ((*tstimp_), _abs (beta_[k_ - 1] - work_[beta0i_ - 1 + k_ - 1]) / _abs (beta_[k_ - 1]));
    }
  }
  _l0:;
  __calls[23].calls++;
  return 0;
}

int_4 _dodlm (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, real_8 _p_ f_, real_8 _p_ 
fjacb_, real_8 _p_ fjacd_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ ss_, real_8 _p_ tt_, int_4 _p_ 
ldtt_, real_8 _p_ delta_, real_8 _p_ alpha2_, real_8 _p_ tau_, real_8 _p_ epsfcn_, logical_4 _p_ isodr_, real_8 _p_ 
tfjacb_, real_8 _p_ omega_, real_8 _p_ u_, real_8 _p_ qraux_, int_4 _p_ jpvt_, real_8 _p_ s_, real_8 _p_ t_, int_4 _p_ 
nlms_, real_8 _p_ rcond_, int_4 _p_ irank_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk4_, 
real_8 _p_ wrk5_, real_8 _p_ wrk_, int_4 _p_ lwrk_, int_4 _p_ istopc_)
{
  static int_4 i_, iwrk_, j_, k_, l_;
  static logical_4 forvcv_;
  static real_8 alpha1_, alphan_, bot_, p001_, p1_, phi1_, phi2_, sa_, top_, zero_;
  int_4 _data_k_18, $0_, $1_, $2_;
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
#define _data_n_18 3
  static real_8 _data_l_18[_data_n_18] = {
    0.0e0,
    0.001e0,
    0.1e0
  };
  if (__calls[24].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    zero_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    p001_ = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    p1_ = _data_l_18[_data_k_18++];
  }
  forvcv_ = FALSE;
  (*istopc_) = 0;
  alpha1_ = zero_;
  (void) _dodstp (n_, m_, np_, nq_, npp_, f_, fjacb_, fjacd_, wd_, ldwd_, ld2wd_, ss_, tt_, ldtt_, delta_, &alpha1_, 
  epsfcn_, isodr_, tfjacb_, omega_, u_, qraux_, jpvt_, s_, t_, &phi1_, irank_, rcond_, &forvcv_, wrk1_, wrk2_, wrk3_, 
  wrk4_, wrk5_, wrk_, lwrk_, istopc_);
  if ((*istopc_) != 0) {
    goto _l0;
  }
  if ((*tau_) < zero_) {
    (*tau_) = _abs ((*tau_)) * phi1_;
  }
  if ((phi1_ - (*tau_)) <= p1_ * (*tau_)) {
    (*nlms_) = 1;
    (*alpha2_) = zero_;
    goto _l0;
  }
  phi1_ = phi1_ - (*tau_);
  bot_ = zero_;
  for (k_ = 1; k_ <= (*npp_); (k_)++) {
    for (l_ = 1; l_ <= (*nq_); (l_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ - 1)))] = fjacb_[i_ - 1 + ((*n_)) * ((k_ - 1) + ((*np_)) * ((l_ 
        - 1)))];
      }
    }
    wrk_[k_ - 1] = _ddot (($0_ = (*n_) * (*nq_), &$0_), &tfjacb_[0 + ((*n_)) * ((0) + ((*nq_)) * ((k_ - 1)))], &_k1, &f_[0 
    + ((*n_)) * ((0))], &_k1);
  }
  (void) _dscale (npp_, &_k1, ss_, npp_, wrk_, npp_, wrk_, npp_);
  if ((*isodr_)) {
    (void) _dwght (n_, m_, wd_, ldwd_, ld2wd_, delta_, n_, &wrk_[(*npp_) + 1 - 1], n_);
    iwrk_ = (*npp_);
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        iwrk_ = iwrk_ + 1;
        wrk_[iwrk_ - 1] = wrk_[iwrk_ - 1] + _ddot (nq_, &fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((0)))], ($1_ = (*n_) 
        * (*m_), &$1_), &f_[i_ - 1 + ((*n_)) * ((0))], n_);
      }
    }
    (void) _dscale (n_, m_, tt_, ldtt_, &wrk_[(*npp_) + 1 - 1], n_, &wrk_[(*npp_) + 1 - 1], n_);
    top_ = _dnrm2 (($2_ = (*npp_) + (*n_) * (*m_), &$2_), wrk_, &_k1) / (*tau_);
  }
  else {
    top_ = _dnrm2 (npp_, wrk_, &_k1) / (*tau_);
  }
  if ((*alpha2_) > top_ || (*alpha2_) == zero_) {
    (*alpha2_) = p001_ * top_;
  }
  for (i_ = 1; i_ <= 10; (i_)++) {
    (void) _dodstp (n_, m_, np_, nq_, npp_, f_, fjacb_, fjacd_, wd_, ldwd_, ld2wd_, ss_, tt_, ldtt_, delta_, alpha2_, 
    epsfcn_, isodr_, tfjacb_, omega_, u_, qraux_, jpvt_, s_, t_, &phi2_, irank_, rcond_, &forvcv_, wrk1_, wrk2_, wrk3_, 
    wrk4_, wrk5_, wrk_, lwrk_, istopc_);
    if ((*istopc_) != 0) {
      goto _l0;
    }
    phi2_ = phi2_ - (*tau_);
    if (_abs (phi2_) <= p1_ * (*tau_) || ((*alpha2_) == bot_ && phi2_ < zero_)) {
      (*nlms_) = i_ + 1;
      goto _l0;
    }
    if (phi1_ - phi2_ == zero_) {
      (*nlms_) = 12;
      goto _l0;
    }
    sa_ = phi2_ * (alpha1_ - (*alpha2_)) / (phi1_ - phi2_);
    if (phi2_ < zero_) {
      top_ = _min (top_, (*alpha2_));
    }
    else {
      bot_ = _max (bot_, (*alpha2_));
    }
    if (phi1_ * phi2_ > zero_) {
      bot_ = _max (bot_, (*alpha2_) - sa_);
    }
    else {
      top_ = _min (top_, (*alpha2_) - sa_);
    }
    alphan_ = (*alpha2_) - sa_ * (phi1_ + (*tau_)) / (*tau_);
    if (alphan_ >= top_ || alphan_ <= bot_) {
      alphan_ = _max (p001_ * top_, sqrt (top_ * bot_));
    }
    alpha1_ = (*alpha2_);
    (*alpha2_) = alphan_;
    phi1_ = phi2_;
  }
  (*nlms_) = 12;
  _l0:;
  __calls[24].calls++;
  return 0;
}

int_4 _dodmn (logical_4 _p_ head_, logical_4 _p_ fstitr_, logical_4 _p_ prtpen_, int_4 (*_fcn)(), int_4 _p_ n_, int_4 
_p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ job_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ x_, 
int_4 _p_ ldx_, real_8 _p_ we_, real_8 _p_ we1_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_, 
int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ betac_, real_8 _p_ betan_, real_8 
_p_ betas_, real_8 _p_ s_, real_8 _p_ delta_, real_8 _p_ deltan_, real_8 _p_ deltas_, real_8 _p_ t_, real_8 _p_ f_, 
real_8 _p_ fn_, real_8 _p_ fs_, real_8 _p_ fjacb_, int_4 _p_ msgb_, real_8 _p_ fjacd_, int_4 _p_ msgd_, real_8 _p_ ssf_
, real_8 _p_ ss_, real_8 _p_ tt_, int_4 _p_ ldtt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ 
xplusd_, real_8 _p_ wrk_, int_4 _p_ lwrk_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, 
int_4 _p_ info_)
{
  static int_4 i_, idf_, iflag_, int2_, ipr_, ipr1_, ipr2_, ipr2f_, ipr3_, irank_, istop_, istopc_, iwrk_, j_, jpvt_, l_, 
  looped_, ludflt_, lunr_, lunrpt_, maxit_, neta_, nfev_, niter_, njev_, nlms_, nnzw_, npp_, npr_, omega_, qraux_, sd_, 
  u_, vcv_, wrk1_, wrk2_, wrk3_, wrk4_, wrk5_, wrk6_;
  static logical_4 access_, anajac_, cdjac_, chkjac_, cnvpar_, cnvss_, didvcv_, dovcv_, implct_, initd_, intdbl_, isodr_, 
  lstep_, redoj_, restrt_;
  static real_8 actred_, actrs_, alpha_, dirder_, eta_, olmavg_, one_, p0001_, p1_, p25_, p5_, p75_, partol_, pnorm_, 
  prered_, prers_, ratio_, rcond_, rnorm_, rnormn_, rnorms_, rss_, rvar_, sstol_, tau_, taufac_, temp_, temp1_, temp2_, 
  tsnorm_, zero_, wss_[3];
  int_4 _data_k_19, _data_k_20, $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, 
  $17_, $18_, $19_, $20_, $21_;
  real_8 $9_;
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern int_4 _dcopy ();
#define _data_n_19 7
  static real_8 _data_l_19[_data_n_19] = {
    0.0e0,
    0.0001e0,
    0.1e0,
    0.25e0,
    0.5e0,
    0.75e0,
    1.0e0
  };
#define _data_n_20 1
  static int_4 _data_l_20[_data_n_20] = {
    6
  };
  if (__calls[25].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    zero_ = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    p0001_ = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    p1_ = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    p25_ = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    p5_ = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    p75_ = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    one_ = _data_l_19[_data_k_19++];
  }
  if (__calls[25].calls == 0) {
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    ludflt_ = _data_l_20[_data_k_20++];
  }
  (void) _dflags (job_, &restrt_, &initd_, &dovcv_, &redoj_, &anajac_, &cdjac_, &chkjac_, &isodr_, &implct_);
  access_ = TRUE;
  (void) _dacces (n_, m_, np_, nq_, ldwe_, ld2we_, work_, lwork_, iwork_, liwork_, &access_, &isodr_, &jpvt_, &omega_, 
  &u_, &qraux_, &sd_, &vcv_, &wrk1_, &wrk2_, &wrk3_, &wrk4_, &wrk5_, &wrk6_, &nnzw_, &npp_, job_, &partol_, &sstol_, 
  &maxit_, &taufac_, &eta_, &neta_, &lunrpt_, &ipr1_, &ipr2_, &ipr2f_, &ipr3_, wss_, &rvar_, &idf_, &tau_, &alpha_, 
  &niter_, &nfev_, &njev_, &int2_, &olmavg_, &rcond_, &irank_, &actrs_, &pnorm_, &prers_, &rnorms_, &istop_);
  rnorm_ = sqrt (wss_[0]);
  didvcv_ = FALSE;
  intdbl_ = FALSE;
  lstep_ = TRUE;
  if (ipr1_ != 0 && lunrpt_ != 0) {
    iflag_ = 1;
    if (ipr1_ >= 3 && lunrpt_ != ludflt_) {
      npr_ = 2;
    }
    else {
      npr_ = 1;
    }
    if (ipr1_ >= 6) {
      ipr_ = 2;
    }
    else {
      ipr_ = 2 - _imod (ipr1_, 2);
    }
    lunr_ = lunrpt_;
    for (i_ = 1; i_ <= npr_; (i_)++) {
      (void) _dodpcr (&ipr_, &lunr_, head_, prtpen_, fstitr_, &didvcv_, &iflag_, n_, m_, np_, nq_, &npp_, &nnzw_, msgb_, 
      msgd_, beta_, y_, ldy_, x_, ldx_, delta_, we_, ldwe_, ld2we_, wd_, ldwd_, ld2wd_, ifixb_, ifixx_, ldifx_, ssf_, tt_, 
      ldtt_, stpb_, stpd_, ldstpd_, job_, &neta_, &taufac_, &sstol_, &partol_, &maxit_, wss_, &rvar_, &idf_, &work_[sd_ - 1], 
      &niter_, &nfev_, &njev_, &actred_, &prered_, &tau_, &pnorm_, &alpha_, f_, &rcond_, &irank_, info_, &istop_);
      if (ipr1_ >= 5) {
        ipr_ = 2;
      }
      else {
        ipr_ = 1;
      }
      lunr_ = ludflt_;
    }
  }
  if (rnorm_ == zero_) {
    (*info_) = 1;
    olmavg_ = zero_;
    istop_ = 0;
    goto _l150;
  }
  if (restrt_ && (niter_ >= maxit_)) {
    istop_ = 0;
    goto _l150;
  }
  else if (niter_ >= maxit_) {
    (*info_) = 4;
    istop_ = 0;
    goto _l150;
  }
  _l100:;
  niter_ = niter_ + 1;
  rnorms_ = rnorm_;
  looped_ = 0;
  if ((niter_ == 1) && (anajac_ && chkjac_)) {
    istop_ = 0;
  }
  else {
    (void) _devjac (_fcn, &anajac_, &cdjac_, n_, m_, np_, nq_, betac_, beta_, stpb_, ifixb_, ifixx_, ldifx_, x_, ldx_, 
    delta_, xplusd_, stpd_, ldstpd_, ssf_, tt_, ldtt_, &neta_, fs_, t_, &work_[wrk1_ - 1], &work_[wrk2_ - 1], &work_[wrk3_ 
    - 1], &work_[wrk6_ - 1], fjacb_, &isodr_, fjacd_, we1_, ldwe_, ld2we_, &njev_, &nfev_, &istop_, info_);
  }
  if (istop_ != 0) {
    (*info_) = 51000;
    goto _l200;
  }
  else if ((*info_) == 50300) {
    goto _l200;
  }
  _l110:;
  if (looped_ > 100) {
    (*info_) = 60000;
    goto _l200;
  }
  else {
    looped_ = looped_ + 1;
    (void) _dodlm (n_, m_, np_, nq_, &npp_, f_, fjacb_, fjacd_, wd_, ldwd_, ld2wd_, ss_, tt_, ldtt_, delta_, &alpha_, 
    &tau_, &eta_, &isodr_, &work_[wrk6_ - 1], &work_[omega_ - 1], &work_[u_ - 1], &work_[qraux_ - 1], &iwork_[jpvt_ - 1], 
    s_, t_, &nlms_, &rcond_, &irank_, &work_[wrk1_ - 1], &work_[wrk2_ - 1], &work_[wrk3_ - 1], &work_[wrk4_ - 1], 
    &work_[wrk5_ - 1], wrk_, lwrk_, &istopc_);
  }
  if (istopc_ != 0) {
    (*info_) = istopc_;
    goto _l200;
  }
  olmavg_ = olmavg_ + nlms_;
  (void) _dxpy (&npp_, &_k1, betac_, &npp_, s_, &npp_, betan_, &npp_);
  if (isodr_) {
    (void) _dxpy (n_, m_, delta_, n_, t_, n_, deltan_, n_);
  }
  (void) _dwght (&npp_, &_k1, ss_, &npp_, &_k1, s_, &npp_, wrk_, &npp_);
  if (isodr_) {
    (void) _dwght (n_, m_, tt_, ldtt_, &_k1, t_, n_, &wrk_[npp_ + 1 - 1], n_);
    tsnorm_ = _dnrm2 (($0_ = npp_ + (*n_) * (*m_), &$0_), wrk_, &_k1);
  }
  else {
    tsnorm_ = _dnrm2 (&npp_, wrk_, &_k1);
  }
  iwrk_ = 0;
  for (l_ = 1; l_ <= (*nq_); (l_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      iwrk_ = iwrk_ + 1;
      wrk_[iwrk_ - 1] = _ddot (&npp_, &fjacb_[i_ - 1 + ((*n_)) * ((0) + ((*np_)) * ((l_ - 1)))], n_, s_, &_k1);
      if (isodr_) {
        wrk_[iwrk_ - 1] = wrk_[iwrk_ - 1] + _ddot (m_, &fjacd_[i_ - 1 + ((*n_)) * ((0) + ((*m_)) * ((l_ - 1)))], n_, &t_[i_ - 1 
        + ((*n_)) * ((0))], n_);
      }
    }
  }
  if (isodr_) {
    (void) _dwght (n_, m_, wd_, ldwd_, ld2wd_, t_, n_, &wrk_[(*n_) * (*nq_) + 1 - 1], n_);
    temp1_ = _ddot (($1_ = (*n_) * (*nq_), &$1_), wrk_, &_k1, wrk_, &_k1) + _ddot (($2_ = (*n_) * (*m_), &$2_), t_, &_k1, 
    &wrk_[(*n_) * (*nq_) + 1 - 1], &_k1);
    temp1_ = sqrt (temp1_) / rnorm_;
  }
  else {
    temp1_ = _dnrm2 (($3_ = (*n_) * (*nq_), &$3_), wrk_, &_k1) / rnorm_;
  }
  temp2_ = sqrt (alpha_) * tsnorm_ / rnorm_;
  prered_ = (temp1_ * temp1_) + (temp2_ * temp2_) / p5_;
  dirder_ = -((temp1_ * temp1_) + (temp2_ * temp2_));
  (void) _dunpac (np_, betan_, beta_, ifixb_);
  (void) _dxpy (n_, m_, x_, ldx_, deltan_, n_, xplusd_, n_);
  istop_ = 0;
  (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, ($4_ = 2, &$4_), fn_, &work_[wrk6_ 
  - 1], &work_[wrk1_ - 1], &istop_);
  if (istop_ == 0) {
    nfev_ = nfev_ + 1;
  }
  if (istop_ < 0) {
    (*info_) = 51000;
    goto _l200;
  }
  else if (istop_ > 0) {
    rnormn_ = rnorm_ / (p1_ * p75_);
  }
  else {
    if (implct_) {
      (void) _dcopy (($5_ = (*n_) * (*nq_), &$5_), fn_, &_k1, wrk_, &_k1);
    }
    else {
      (void) _dxmy (n_, nq_, fn_, n_, y_, ldy_, wrk_, n_);
    }
    (void) _dwght (n_, nq_, we1_, ldwe_, ld2we_, wrk_, n_, wrk_, n_);
    if (isodr_) {
      (void) _dwght (n_, m_, wd_, ldwd_, ld2wd_, deltan_, n_, &wrk_[(*n_) * (*nq_) + 1 - 1], n_);
      rnormn_ = sqrt (_ddot (($6_ = (*n_) * (*nq_), &$6_), wrk_, &_k1, wrk_, &_k1) + _ddot (($7_ = (*n_) * (*m_), &$7_), 
      deltan_, &_k1, &wrk_[(*n_) * (*nq_) + 1 - 1], &_k1));
    }
    else {
      rnormn_ = _dnrm2 (($8_ = (*n_) * (*nq_), &$8_), wrk_, &_k1);
    }
  }
  if (p1_ * rnormn_ < rnorm_) {
    actred_ = one_ - ($9_ = (rnormn_ / rnorm_), $9_ * $9_);
  }
  else {
    actred_ = -one_;
  }
  if (prered_ == zero_) {
    ratio_ = zero_;
  }
  else {
    ratio_ = actred_ / prered_;
  }
  if (intdbl_ && (ratio_ < p0001_ || rnormn_ > rnorms_)) {
    istop_ = 0;
    tau_ = tau_ * p5_;
    alpha_ = alpha_ / p5_;
    (void) _dcopy (&npp_, betas_, &_k1, betan_, &_k1);
    (void) _dcopy (($10_ = (*n_) * (*m_), &$10_), deltas_, &_k1, deltan_, &_k1);
    (void) _dcopy (($11_ = (*n_) * (*nq_), &$11_), fs_, &_k1, fn_, &_k1);
    actred_ = actrs_;
    prered_ = prers_;
    rnormn_ = rnorms_;
    ratio_ = p5_;
  }
  intdbl_ = FALSE;
  if (ratio_ < p25_) {
    if (actred_ >= zero_) {
      temp_ = p5_;
    }
    else {
      temp_ = p5_ * dirder_ / (dirder_ + p5_ * actred_);
    }
    if (p1_ * rnormn_ >= rnorm_ || temp_ < p1_) {
      temp_ = p1_;
    }
    tau_ = temp_ * _min (tau_, tsnorm_ / p1_);
    alpha_ = alpha_ / temp_;
  }
  else if (alpha_ == zero_) {
    tau_ = tsnorm_ / p5_;
  }
  else if (ratio_ >= p75_ && nlms_ <= 11) {
    intdbl_ = TRUE;
    tau_ = tsnorm_ / p5_;
    alpha_ = alpha_ * p5_;
    (void) _dcopy (&npp_, betan_, &_k1, betas_, &_k1);
    (void) _dcopy (($12_ = (*n_) * (*m_), &$12_), deltan_, &_k1, deltas_, &_k1);
    (void) _dcopy (($13_ = (*n_) * (*nq_), &$13_), fn_, &_k1, fs_, &_k1);
    actrs_ = actred_;
    prers_ = prered_;
    rnorms_ = rnormn_;
  }
  if (intdbl_ && tau_ > zero_) {
    int2_ = int2_ + 1;
    goto _l110;
  }
  if (ratio_ >= p0001_) {
    (void) _dcopy (($14_ = (*n_) * (*nq_), &$14_), fn_, &_k1, fs_, &_k1);
    if (implct_) {
      (void) _dcopy (($15_ = (*n_) * (*nq_), &$15_), fs_, &_k1, f_, &_k1);
    }
    else {
      (void) _dxmy (n_, nq_, fs_, n_, y_, ldy_, f_, n_);
    }
    (void) _dwght (n_, nq_, we1_, ldwe_, ld2we_, f_, n_, f_, n_);
    (void) _dcopy (&npp_, betan_, &_k1, betac_, &_k1);
    (void) _dcopy (($16_ = (*n_) * (*m_), &$16_), deltan_, &_k1, delta_, &_k1);
    rnorm_ = rnormn_;
    (void) _dwght (&npp_, &_k1, ss_, &npp_, &_k1, betac_, &npp_, wrk_, &npp_);
    if (isodr_) {
      (void) _dwght (n_, m_, tt_, ldtt_, &_k1, delta_, n_, &wrk_[npp_ + 1 - 1], n_);
      pnorm_ = _dnrm2 (($17_ = npp_ + (*n_) * (*m_), &$17_), wrk_, &_k1);
    }
    else {
      pnorm_ = _dnrm2 (&npp_, wrk_, &_k1);
    }
    lstep_ = TRUE;
  }
  else {
    lstep_ = FALSE;
  }
  (*info_) = 0;
  cnvss_ = rnorm_ == zero_ || (_abs (actred_) <= sstol_ && prered_ <= sstol_ && p5_ * ratio_ <= one_);
  cnvpar_ = (tau_ <= partol_ * pnorm_) && (! (implct_));
  if (cnvss_) {
    (*info_) = 1;
  }
  if (cnvpar_) {
    (*info_) = 2;
  }
  if (cnvss_ && cnvpar_) {
    (*info_) = 3;
  }
  if ((*info_) != 0 || lstep_) {
    if (ipr2_ != 0 && ipr2f_ != 0 && lunrpt_ != 0) {
      if (ipr2f_ == 1 || _imod (niter_, ipr2f_) == 1) {
        iflag_ = 2;
        (void) _dunpac (np_, betac_, beta_, ifixb_);
        wss_[0] = rnorm_ * rnorm_;
        if (ipr2_ >= 3 && lunrpt_ != ludflt_) {
          npr_ = 2;
        }
        else {
          npr_ = 1;
        }
        if (ipr2_ >= 6) {
          ipr_ = 2;
        }
        else {
          ipr_ = 2 - _imod (ipr2_, 2);
        }
        lunr_ = lunrpt_;
        for (i_ = 1; i_ <= npr_; (i_)++) {
          (void) _dodpcr (&ipr_, &lunr_, head_, prtpen_, fstitr_, &didvcv_, &iflag_, n_, m_, np_, nq_, &npp_, &nnzw_, msgb_, 
          msgd_, beta_, y_, ldy_, x_, ldx_, delta_, we_, ldwe_, ld2we_, wd_, ldwd_, ld2wd_, ifixb_, ifixx_, ldifx_, ssf_, tt_, 
          ldtt_, stpb_, stpd_, ldstpd_, job_, &neta_, &taufac_, &sstol_, &partol_, &maxit_, wss_, &rvar_, &idf_, &work_[sd_ - 1], 
          &niter_, &nfev_, &njev_, &actred_, &prered_, &tau_, &pnorm_, &alpha_, f_, &rcond_, &irank_, info_, &istop_);
          if (ipr2_ >= 5) {
            ipr_ = 2;
          }
          else {
            ipr_ = 1;
          }
          lunr_ = ludflt_;
        }
        (*fstitr_) = FALSE;
        (*prtpen_) = FALSE;
      }
    }
  }
  if ((*info_) == 0) {
    if (lstep_) {
      if (niter_ >= maxit_) {
        (*info_) = 4;
      }
      else {
        goto _l100;
      }
    }
    else {
      goto _l110;
    }
  }
  _l150:;
  if (istop_ > 0) {
    (*info_) = (*info_) + 100;
  }
  if (implct_) {
    (void) _dcopy (($18_ = (*n_) * (*nq_), &$18_), fs_, &_k1, f_, &_k1);
  }
  else {
    (void) _dxmy (n_, nq_, fs_, n_, y_, ldy_, f_, n_);
  }
  (void) _dunpac (np_, betac_, beta_, ifixb_);
  (void) _dxpy (n_, m_, x_, ldx_, delta_, n_, xplusd_, n_);
  if (dovcv_ && istop_ == 0) {
    if (redoj_) {
      (void) _devjac (_fcn, &anajac_, &cdjac_, n_, m_, np_, nq_, betac_, beta_, stpb_, ifixb_, ifixx_, ldifx_, x_, ldx_, 
      delta_, xplusd_, stpd_, ldstpd_, ssf_, tt_, ldtt_, &neta_, fs_, t_, &work_[wrk1_ - 1], &work_[wrk2_ - 1], &work_[wrk3_ 
      - 1], &work_[wrk6_ - 1], fjacb_, &isodr_, fjacd_, we1_, ldwe_, ld2we_, &njev_, &nfev_, &istop_, info_);
      if (istop_ != 0) {
        (*info_) = 51000;
        goto _l200;
      }
      else if ((*info_) == 50300) {
        goto _l200;
      }
    }
    if (implct_) {
      (void) _dwght (n_, m_, wd_, ldwd_, ld2wd_, delta_, n_, &wrk_[(*n_) * (*nq_) + 1 - 1], n_);
      rss_ = _ddot (($19_ = (*n_) * (*m_), &$19_), delta_, &_k1, &wrk_[(*n_) * (*nq_) + 1 - 1], &_k1);
    }
    else {
      rss_ = rnorm_ * rnorm_;
    }
    if (redoj_ || niter_ >= 1) {
      (void) _dodvcv (n_, m_, np_, nq_, &npp_, f_, fjacb_, fjacd_, wd_, ldwd_, ld2wd_, ssf_, ss_, tt_, ldtt_, delta_, &eta_, 
      &isodr_, &work_[vcv_ - 1], &work_[sd_ - 1], &work_[wrk6_ - 1], &work_[omega_ - 1], &work_[u_ - 1], &work_[qraux_ - 1], 
      &iwork_[jpvt_ - 1], s_, t_, &irank_, &rcond_, &rss_, &idf_, &rvar_, ifixb_, &work_[wrk1_ - 1], &work_[wrk2_ - 1], 
      &work_[wrk3_ - 1], &work_[wrk4_ - 1], &work_[wrk5_ - 1], wrk_, lwrk_, &istopc_);
      if (istopc_ != 0) {
        (*info_) = istopc_;
        goto _l200;
      }
      didvcv_ = TRUE;
    }
  }
  _l200:;
  for (i_ = 0; i_ <= (*np_) - 1; (i_)++) {
    work_[wrk3_ + i_ - 1] = iwork_[jpvt_ + i_ - 1];
    iwork_[jpvt_ + i_ - 1] = -2;
  }
  if (redoj_ || niter_ >= 1) {
    for (i_ = 0; i_ <= npp_ - 1; (i_)++) {
      j_ = work_[wrk3_ + i_ - 1] - 1;
      if (i_ <= npp_ - irank_ - 1) {
        iwork_[jpvt_ + j_ - 1] = 1;
      }
      else {
        iwork_[jpvt_ + j_ - 1] = -1;
      }
    }
    if (npp_ < (*np_)) {
      j_ = npp_ - 1;
      for (i_ = (*np_) - 1; i_ >= 0; (i_)--) {
        if (ifixb_[i_ + 1 - 1] == 0) {
          iwork_[jpvt_ + i_ - 1] = 0;
        }
        else {
          iwork_[jpvt_ + i_ - 1] = iwork_[jpvt_ + j_ - 1];
          j_ = j_ - 1;
        }
      }
    }
  }
  if (niter_ >= 1) {
    olmavg_ = olmavg_ / niter_;
  }
  else {
    olmavg_ = zero_;
  }
  (void) _dwght (n_, nq_, we1_, ldwe_, ld2we_, f_, n_, wrk_, n_);
  wss_[2] = _ddot (($20_ = (*n_) * (*nq_), &$20_), wrk_, &_k1, wrk_, &_k1);
  if (isodr_) {
    (void) _dwght (n_, m_, wd_, ldwd_, ld2wd_, delta_, n_, &wrk_[(*n_) * (*nq_) + 1 - 1], n_);
    wss_[1] = _ddot (($21_ = (*n_) * (*m_), &$21_), delta_, &_k1, &wrk_[(*n_) * (*nq_) + 1 - 1], &_k1);
  }
  else {
    wss_[1] = zero_;
  }
  wss_[0] = wss_[1] + wss_[2];
  access_ = FALSE;
  (void) _dacces (n_, m_, np_, nq_, ldwe_, ld2we_, work_, lwork_, iwork_, liwork_, &access_, &isodr_, &jpvt_, &omega_, 
  &u_, &qraux_, &sd_, &vcv_, &wrk1_, &wrk2_, &wrk3_, &wrk4_, &wrk5_, &wrk6_, &nnzw_, &npp_, job_, &partol_, &sstol_, 
  &maxit_, &taufac_, &eta_, &neta_, &lunrpt_, &ipr1_, &ipr2_, &ipr2f_, &ipr3_, wss_, &rvar_, &idf_, &tau_, &alpha_, 
  &niter_, &nfev_, &njev_, &int2_, &olmavg_, &rcond_, &irank_, &actrs_, &pnorm_, &prers_, &rnorms_, &istop_);
  if ((*info_) <= 9 || (*info_) >= 60000) {
    if (msgb_[0] == 1 || msgd_[0] == 1) {
      (*info_) = (*info_) + 1000;
    }
    if (istop_ != 0) {
      (*info_) = (*info_) + 100;
    }
    if (irank_ >= 1) {
      if (npp_ > irank_) {
        (*info_) = (*info_) + 10;
      }
      else {
        (*info_) = (*info_) + 20;
      }
    }
  }
  if (ipr3_ != 0 && lunrpt_ != 0) {
    iflag_ = 3;
    if (ipr3_ >= 3 && lunrpt_ != ludflt_) {
      npr_ = 2;
    }
    else {
      npr_ = 1;
    }
    if (ipr3_ >= 6) {
      ipr_ = 2;
    }
    else {
      ipr_ = 2 - _imod (ipr3_, 2);
    }
    lunr_ = lunrpt_;
    for (i_ = 1; i_ <= npr_; (i_)++) {
      (void) _dodpcr (&ipr_, &lunr_, head_, prtpen_, fstitr_, &didvcv_, &iflag_, n_, m_, np_, nq_, &npp_, &nnzw_, msgb_, 
      msgd_, beta_, y_, ldy_, x_, ldx_, delta_, we_, ldwe_, ld2we_, wd_, ldwd_, ld2wd_, &iwork_[jpvt_ - 1], ifixx_, ldifx_, 
      ssf_, tt_, ldtt_, stpb_, stpd_, ldstpd_, job_, &neta_, &taufac_, &sstol_, &partol_, &maxit_, wss_, &rvar_, &idf_, 
      &work_[sd_ - 1], &niter_, &nfev_, &njev_, &actred_, &prered_, &tau_, &pnorm_, &alpha_, f_, &rcond_, &irank_, info_, 
      &istop_);
      if (ipr3_ >= 5) {
        ipr_ = 2;
      }
      else {
        ipr_ = 1;
      }
      lunr_ = ludflt_;
    }
  }
  __calls[25].calls++;
  return 0;
}

int_4 _dodpc1 (int_4 _p_ ipr_, int_4 _p_ lunrpt_, logical_4 _p_ anajac_, logical_4 _p_ cdjac_, logical_4 _p_ chkjac_, 
logical_4 _p_ initd_, logical_4 _p_ restrt_, logical_4 _p_ isodr_, logical_4 _p_ implct_, logical_4 _p_ dovcv_, 
logical_4 _p_ redoj_, int_4 _p_ msgb1_, int_4 _p_ msgb_, int_4 _p_ msgd1_, int_4 _p_ msgd_, int_4 _p_ n_, int_4 _p_ m_, 
int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, int_4 _p_ nnzw_, real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ ifixx_, int_4 
_p_ ldifx_, real_8 _p_ delta_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ tt_, int_4 _p_ ldtt_, 
real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, 
real_8 _p_ pnlty_, real_8 _p_ beta_, int_4 _p_ ifixb_, real_8 _p_ ssf_, real_8 _p_ stpb_, int_4 _p_ job_, int_4 _p_ 
neta_, real_8 _p_ taufac_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, real_8 _p_ wss_, real_8 _p_ wssdel_
, real_8 _p_ wsseps_)
{
  static int_4 i_, itemp_, j_, job1_, job2_, job3_, job4_, job5_, l_;
  static real_8 temp1_, temp2_, temp3_, zero_;
  static char_3 tempc0_;
  static char_7 tempc1_;
  static char_15 tempc2_;
  int_4 _data_k_21, $u_0_, __fcnt, __rc, $u_1_, $u_2_, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_, $u_10_, $u_11_, 
  $u_12_, $u_13_, $u_14_, $u_15_, $u_16_, $u_17_, $u_18_, $u_19_, $u_20_, $21_, $u_22_, $u_23_, $u_24_, $u_25_, $u_26_, 
  $u_27_, $u_28_, $u_29_, $u_30_, $u_31_, $u_32_, $u_33_, $u_34_, $u_35_, $u_36_, $u_37_, $u_38_, $u_39_, $u_40_, $u_41_, 
  $u_42_, $u_43_, $u_44_, $u_45_, $u_46_, $u_47_, $u_48_, $u_49_, $u_50_, $u_51_, $u_52_, $u_53_;
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_8, _dc_8,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_9, _dc_9,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_10, _dc_10,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_12, _dc_12,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_13, _dc_13,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_14, _dc_14,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_15, _dc_15,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  static FORMAT $f_1100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_16, _dc_16,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_17, _dc_17,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_18, _dc_18,
    NULL, NULL, NULL
  };
  static FORMAT $f_1110_[] = {
    FMT_TEXT, _dc_19, _dc_19,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_20, _dc_20,
    NULL, NULL, NULL
  };
  static FORMAT $f_1111_[] = {
    FMT_TEXT, _dc_19, _dc_19,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_21, _dc_21,
    NULL, NULL, NULL
  };
  static FORMAT $f_1120_[] = {
    FMT_TEXT, _dc_22, _dc_22,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_23, _dc_23,
    FMT_TEXT, _dc_24, _dc_24,
    NULL, NULL, NULL
  };
  static FORMAT $f_1121_[] = {
    FMT_TEXT, _dc_22, _dc_22,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_23, _dc_23,
    FMT_TEXT, _dc_25, _dc_25,
    NULL, NULL, NULL
  };
  static FORMAT $f_1122_[] = {
    FMT_TEXT, _dc_22, _dc_22,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_26, _dc_26,
    FMT_TEXT, _dc_27, _dc_27,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_28, _dc_28,
    NULL, NULL, NULL
  };
  static FORMAT $f_1130_[] = {
    FMT_TEXT, _dc_29, _dc_29,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_30, _dc_30,
    FMT_TEXT, _dc_31, _dc_31,
    NULL, NULL, NULL
  };
  static FORMAT $f_1131_[] = {
    FMT_TEXT, _dc_32, _dc_32,
    FMT_TEXT, _dc_33, _dc_33,
    NULL, NULL, NULL
  };
  static FORMAT $f_1132_[] = {
    FMT_TEXT, _dc_34, _dc_34,
    FMT_TEXT, _dc_35, _dc_35,
    NULL, NULL, NULL
  };
  static FORMAT $f_1133_[] = {
    FMT_TEXT, _dc_29, _dc_29,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_30, _dc_30,
    FMT_TEXT, _dc_36, _dc_36,
    NULL, NULL, NULL
  };
  static FORMAT $f_1140_[] = {
    FMT_TEXT, _dc_37, _dc_37,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_38, _dc_38,
    FMT_TEXT, _dc_39, _dc_39,
    NULL, NULL, NULL
  };
  static FORMAT $f_1141_[] = {
    FMT_TEXT, _dc_40, _dc_40,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_41, _dc_41,
    NULL, NULL, NULL
  };
  static FORMAT $f_1142_[] = {
    FMT_TEXT, _dc_40, _dc_40,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_42, _dc_42,
    NULL, NULL, NULL
  };
  static FORMAT $f_1143_[] = {
    FMT_TEXT, _dc_43, _dc_43,
    FMT_TEXT, _dc_44, _dc_44,
    NULL, NULL, NULL
  };
  static FORMAT $f_1144_[] = {
    FMT_TEXT, _dc_37, _dc_37,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_38, _dc_38,
    FMT_TEXT, _dc_45, _dc_45,
    FMT_TEXT, _dc_46, _dc_46,
    NULL, NULL, NULL
  };
  static FORMAT $f_1145_[] = {
    FMT_TEXT, _dc_37, _dc_37,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_38, _dc_38,
    FMT_TEXT, _dc_47, _dc_47,
    FMT_TEXT, _dc_46, _dc_46,
    NULL, NULL, NULL
  };
  static FORMAT $f_1150_[] = {
    FMT_TEXT, _dc_48, _dc_48,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_49, _dc_49,
    NULL, NULL, NULL
  };
  static FORMAT $f_1151_[] = {
    FMT_TEXT, _dc_48, _dc_48,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_50, _dc_50,
    NULL, NULL, NULL
  };
  static FORMAT $f_1152_[] = {
    FMT_TEXT, _dc_48, _dc_48,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_51, _dc_51,
    NULL, NULL, NULL
  };
  static FORMAT $f_1200_[] = {
    FMT_TEXT, _dc_52, _dc_52,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_53, _dc_53,
    NULL, NULL, NULL
  };
  static FORMAT $f_1210_[] = {
    FMT_TEXT, _dc_52, _dc_52,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_54, _dc_54,
    NULL, NULL, NULL
  };
  static FORMAT $f_1300_[] = {
    FMT_TEXT, _dc_55, _dc_55,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.2.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_1400_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_56, _dc_56,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_57, _dc_57,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.2.0e",
    FMT_TEXT, _dc_58, _dc_58,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_59, _dc_59,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.2.0e",
    FMT_TEXT, _dc_60, _dc_60,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_61, _dc_61,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_62, _dc_62,
    NULL, NULL, NULL
  };
  static FORMAT $f_1500_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_63, _dc_63,
    FMT_TEXT, _dc_64, _dc_64,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_1510_[] = {
    FMT_TEXT, _dc_65, _dc_65,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_66, _dc_66,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_67, _dc_67,
    FMT_TEXT,"","1",
    FMT_REAL,"%10e","%10.1.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_1600_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_68, _dc_68,
    FMT_TEXT, _dc_64, _dc_64,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_1610_[] = {
    FMT_TEXT, _dc_69, _dc_69,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_70, _dc_70,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_2010_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_71, _dc_71,
    NULL, NULL, NULL
  };
  static FORMAT $f_2020_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_72, _dc_72,
    NULL, NULL, NULL
  };
  static FORMAT $f_2110_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_73, _dc_73,
    FMT_TEXT, _dc_74, _dc_74,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_75, _dc_75,
    FMT_TEXT, _dc_76, _dc_76,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_77, _dc_77,
    FMT_TEXT, _dc_78, _dc_78,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_2120_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_73, _dc_73,
    FMT_TEXT, _dc_79, _dc_79,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_75, _dc_75,
    FMT_TEXT, _dc_80, _dc_80,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_77, _dc_77,
    FMT_TEXT, _dc_78, _dc_78,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_2130_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_73, _dc_73,
    FMT_TEXT, _dc_74, _dc_74,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_75, _dc_75,
    FMT_TEXT, _dc_81, _dc_81,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_77, _dc_77,
    FMT_TEXT, _dc_82, _dc_82,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_2140_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_83, _dc_83,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_84, _dc_84,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_3000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_85, _dc_85,
    FMT_TEXT, _dc_86, _dc_86,
    NULL, NULL, NULL
  };
  static FORMAT $f_3100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_87, _dc_87,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_88, _dc_88,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_4000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_89, _dc_89,
    NULL, NULL, NULL
  };
  static FORMAT $f_4110_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_90, _dc_90,
    FMT_TEXT, _dc_91, _dc_91,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_92, _dc_92,
    FMT_TEXT, _dc_93, _dc_93,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_94, _dc_94,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_4120_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_90, _dc_90,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_92, _dc_92,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_94, _dc_94,
    FMT_TEXT, _dc_95, _dc_95,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_4200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_90, _dc_90,
    FMT_TEXT, _dc_91, _dc_91,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_92, _dc_92,
    FMT_TEXT, _dc_96, _dc_96,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_94, _dc_94,
    FMT_TEXT, _dc_97, _dc_97,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_4310_[] = {
    FMT_TEXT, _dc_98, _dc_98,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_99, _dc_99,
    FMT_CHAR,"%5s","%-5s",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_CHAR,"%13s","%-13s",
    NULL, NULL, NULL
  };
  static FORMAT $f_4320_[] = {
    FMT_TEXT, _dc_98, _dc_98,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_99, _dc_99,
    FMT_CHAR,"%5s","%-5s",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%13e","%13.5.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_5110_[] = {
    FMT_TEXT, _dc_101, _dc_101,
    FMT_CHAR,"%2s","%-2s",
    FMT_INT,"%1d","%1d",
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_TEXT, _dc_99, _dc_99,
    FMT_CHAR,"%5s","%-5s",
    FMT_REAL,"%10e","%10.2.0e",
    FMT_REAL,"%10e","%10.2.0e",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_CHAR,"%13s","%-13s",
    NULL, NULL, NULL
  };
  static FORMAT $f_5120_[] = {
    FMT_TEXT, _dc_102, _dc_102,
    FMT_CHAR,"%2s","%-2s",
    FMT_INT,"%2d","%2d",
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_TEXT, _dc_99, _dc_99,
    FMT_CHAR,"%5s","%-5s",
    FMT_REAL,"%10e","%10.2.0e",
    FMT_REAL,"%10e","%10.2.0e",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_CHAR,"%13s","%-13s",
    NULL, NULL, NULL
  };
  static FORMAT $f_5210_[] = {
    FMT_TEXT, _dc_101, _dc_101,
    FMT_CHAR,"%2s","%-2s",
    FMT_INT,"%1d","%1d",
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_TEXT, _dc_99, _dc_99,
    FMT_CHAR,"%5s","%-5s",
    FMT_REAL,"%10e","%10.2.0e",
    FMT_REAL,"%10e","%10.2.0e",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%13e","%13.5.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_5220_[] = {
    FMT_TEXT, _dc_102, _dc_102,
    FMT_CHAR,"%2s","%-2s",
    FMT_INT,"%2d","%2d",
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_REAL,"%12e","%12.3.0e",
    FMT_TEXT, _dc_99, _dc_99,
    FMT_CHAR,"%5s","%-5s",
    FMT_REAL,"%10e","%10.2.0e",
    FMT_REAL,"%10e","%10.2.0e",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_REAL,"%13e","%13.5.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_6000_[] = {
    FMT_TEXT, _dc_100, _dc_100,
    NULL, NULL, NULL
  };
#define _data_n_21 1
  static real_8 _data_l_21[_data_n_21] = {
    0.0e0
  };
  if (__calls[26].calls == 0) {
    _data_k_21 = 0;
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    zero_ = _data_l_21[_data_k_21++];
  }
  $u_0_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc1:159", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
    __fcnt += 3;
  }
  if ($f_1000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], &(*n_), INTEGER, 4);
  _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
  __fcnt += 3;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    if ($f_1000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
    __fcnt += 3;
  }
  if ($f_1000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], &(*nnzw_), INTEGER, 4);
  _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
  __fcnt += 3;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    if ($f_1000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
    __fcnt += 3;
  }
  if ($f_1000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], &(*nq_), INTEGER, 4);
  _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
  __fcnt += 3;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    if ($f_1000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
    __fcnt += 3;
  }
  if ($f_1000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], &(*m_), INTEGER, 4);
  _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
  __fcnt += 3;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    if ($f_1000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
    __fcnt += 3;
  }
  if ($f_1000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], &(*np_), INTEGER, 4);
  _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
  __fcnt += 3;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    if ($f_1000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
    __fcnt += 3;
  }
  if ($f_1000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], &(*npp_), INTEGER, 4);
  _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
  __fcnt += 3;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    if ($f_1000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc1:159", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  job1_ = (*job_) / 10000;
  job2_ = _imod ((*job_), 10000) / 1000;
  job3_ = _imod ((*job_), 1000) / 100;
  job4_ = _imod ((*job_), 100) / 10;
  job5_ = _imod ((*job_), 10);
  $u_1_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc1:169", $u_1_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_1_, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc1:169", $u_1_));
    __fcnt += 3;
  }
  if ($f_1100_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_1_].unit, "\n");
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_1_, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc1:169", $u_1_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_1_, $f_1100_[__fcnt + 2], &(*job_), INTEGER, 4);
  _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc1:169", $u_1_));
  __fcnt += 3;
  while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
    if ($f_1100_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_1_, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc1:169", $u_1_));
    __fcnt += 3;
  }
  _write_eol ($u_1_);
  if ((*restrt_)) {
    $u_2_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:171", $u_2_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1110_[__fcnt] != NULL && $f_1110_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_2_, $f_1110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc1:171", $u_2_));
      __fcnt += 3;
    }
    if ($f_1110_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_2_].unit, "\n");
      while ($f_1110_[__fcnt] != NULL && $f_1110_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_2_, $f_1110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc1:171", $u_2_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_2_, $f_1110_[__fcnt + 2], &job1_, INTEGER, 4);
    _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc1:171", $u_2_));
    __fcnt += 3;
    while ($f_1110_[__fcnt] != NULL && $f_1110_[__fcnt] == FMT_TEXT) {
      if ($f_1110_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_2_, $f_1110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc1:171", $u_2_));
      __fcnt += 3;
    }
    _write_eol ($u_2_);
  }
  else {
    $u_3_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:173", $u_3_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1111_[__fcnt] != NULL && $f_1111_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_3_, $f_1111_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc1:173", $u_3_));
      __fcnt += 3;
    }
    if ($f_1111_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_3_].unit, "\n");
      while ($f_1111_[__fcnt] != NULL && $f_1111_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_3_, $f_1111_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc1:173", $u_3_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_3_, $f_1111_[__fcnt + 2], &job1_, INTEGER, 4);
    _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc1:173", $u_3_));
    __fcnt += 3;
    while ($f_1111_[__fcnt] != NULL && $f_1111_[__fcnt] == FMT_TEXT) {
      if ($f_1111_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_3_, $f_1111_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc1:173", $u_3_));
      __fcnt += 3;
    }
    _write_eol ($u_3_);
  }
  if ((*isodr_)) {
    if ((*initd_)) {
      $u_4_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:177", $u_4_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1120_[__fcnt] != NULL && $f_1120_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_4_, $f_1120_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc1:177", $u_4_));
        __fcnt += 3;
      }
      if ($f_1120_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_4_].unit, "\n");
        while ($f_1120_[__fcnt] != NULL && $f_1120_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_4_, $f_1120_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc1:177", $u_4_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_4_, $f_1120_[__fcnt + 2], &job2_, INTEGER, 4);
      _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc1:177", $u_4_));
      __fcnt += 3;
      while ($f_1120_[__fcnt] != NULL && $f_1120_[__fcnt] == FMT_TEXT) {
        if ($f_1120_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_4_, $f_1120_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc1:177", $u_4_));
        __fcnt += 3;
      }
      _write_eol ($u_4_);
    }
    else {
      $u_5_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:179", $u_5_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1121_[__fcnt] != NULL && $f_1121_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1121_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc1:179", $u_5_));
        __fcnt += 3;
      }
      if ($f_1121_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_5_].unit, "\n");
        while ($f_1121_[__fcnt] != NULL && $f_1121_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_5_, $f_1121_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc1:179", $u_5_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_5_, $f_1121_[__fcnt + 2], &job2_, INTEGER, 4);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc1:179", $u_5_));
      __fcnt += 3;
      while ($f_1121_[__fcnt] != NULL && $f_1121_[__fcnt] == FMT_TEXT) {
        if ($f_1121_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_5_, $f_1121_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc1:179", $u_5_));
        __fcnt += 3;
      }
      _write_eol ($u_5_);
    }
  }
  else {
    $u_6_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:182", $u_6_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1122_[__fcnt] != NULL && $f_1122_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_6_, $f_1122_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc1:182", $u_6_));
      __fcnt += 3;
    }
    if ($f_1122_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_6_].unit, "\n");
      while ($f_1122_[__fcnt] != NULL && $f_1122_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_6_, $f_1122_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc1:182", $u_6_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_6_, $f_1122_[__fcnt + 2], &job2_, INTEGER, 4);
    _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc1:182", $u_6_));
    __fcnt += 3;
    while ($f_1122_[__fcnt] != NULL && $f_1122_[__fcnt] == FMT_TEXT) {
      if ($f_1122_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_6_, $f_1122_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc1:182", $u_6_));
      __fcnt += 3;
    }
    if ($f_1122_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_6_].unit, "\n");
      while ($f_1122_[__fcnt] != NULL && $f_1122_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_6_, $f_1122_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc1:182", $u_6_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_6_, $f_1122_[__fcnt + 2], &job5_, INTEGER, 4);
    _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc1:182", $u_6_));
    __fcnt += 3;
    while ($f_1122_[__fcnt] != NULL && $f_1122_[__fcnt] == FMT_TEXT) {
      if ($f_1122_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_6_, $f_1122_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc1:182", $u_6_));
      __fcnt += 3;
    }
    _write_eol ($u_6_);
  }
  if ((*dovcv_)) {
    $u_7_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:185", $u_7_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1130_[__fcnt] != NULL && $f_1130_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_7_, $f_1130_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc1:185", $u_7_));
      __fcnt += 3;
    }
    if ($f_1130_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_7_].unit, "\n");
      while ($f_1130_[__fcnt] != NULL && $f_1130_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_7_, $f_1130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc1:185", $u_7_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_7_, $f_1130_[__fcnt + 2], &job3_, INTEGER, 4);
    _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc1:185", $u_7_));
    __fcnt += 3;
    while ($f_1130_[__fcnt] != NULL && $f_1130_[__fcnt] == FMT_TEXT) {
      if ($f_1130_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_7_, $f_1130_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc1:185", $u_7_));
      __fcnt += 3;
    }
    _write_eol ($u_7_);
    if ((*redoj_)) {
      $u_8_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:187", $u_8_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1131_[__fcnt] != NULL && $f_1131_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_8_, $f_1131_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc1:187", $u_8_));
        __fcnt += 3;
      }
      _write_eol ($u_8_);
    }
    else {
      $u_9_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:189", $u_9_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1132_[__fcnt] != NULL && $f_1132_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_9_, $f_1132_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc1:189", $u_9_));
        __fcnt += 3;
      }
      _write_eol ($u_9_);
    }
  }
  else {
    $u_10_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:192", $u_10_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1133_[__fcnt] != NULL && $f_1133_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_10_, $f_1133_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_10_, _ioerr_write ("odrpack:dodpc1:192", $u_10_));
      __fcnt += 3;
    }
    if ($f_1133_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_10_].unit, "\n");
      while ($f_1133_[__fcnt] != NULL && $f_1133_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_10_, $f_1133_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_10_, _ioerr_write ("odrpack:dodpc1:192", $u_10_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_10_, $f_1133_[__fcnt + 2], &job3_, INTEGER, 4);
    _write_err (__rc, $u_10_, _ioerr_write ("odrpack:dodpc1:192", $u_10_));
    __fcnt += 3;
    while ($f_1133_[__fcnt] != NULL && $f_1133_[__fcnt] == FMT_TEXT) {
      if ($f_1133_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_10_, $f_1133_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_10_, _ioerr_write ("odrpack:dodpc1:192", $u_10_));
      __fcnt += 3;
    }
    _write_eol ($u_10_);
  }
  if ((*anajac_)) {
    $u_11_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:195", $u_11_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1140_[__fcnt] != NULL && $f_1140_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_11_, $f_1140_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpc1:195", $u_11_));
      __fcnt += 3;
    }
    if ($f_1140_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_11_].unit, "\n");
      while ($f_1140_[__fcnt] != NULL && $f_1140_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_11_, $f_1140_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpc1:195", $u_11_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_11_, $f_1140_[__fcnt + 2], &job4_, INTEGER, 4);
    _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpc1:195", $u_11_));
    __fcnt += 3;
    while ($f_1140_[__fcnt] != NULL && $f_1140_[__fcnt] == FMT_TEXT) {
      if ($f_1140_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_11_, $f_1140_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpc1:195", $u_11_));
      __fcnt += 3;
    }
    _write_eol ($u_11_);
    if ((*chkjac_)) {
      if ((*msgb1_) >= 1 || (*msgd1_) >= 1) {
        $u_12_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc1:198", $u_12_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_12_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_12_, _ioerr_write ("odrpack:dodpc1:198", $u_12_));
          __fcnt += 3;
        }
        _write_eol ($u_12_);
      }
      else {
        $u_13_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc1:200", $u_13_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_13_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_13_, _ioerr_write ("odrpack:dodpc1:200", $u_13_));
          __fcnt += 3;
        }
        _write_eol ($u_13_);
      }
    }
    else {
      $u_14_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:203", $u_14_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1143_[__fcnt] != NULL && $f_1143_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_14_, $f_1143_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_14_, _ioerr_write ("odrpack:dodpc1:203", $u_14_));
        __fcnt += 3;
      }
      _write_eol ($u_14_);
    }
  }
  else if ((*cdjac_)) {
    $u_15_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:206", $u_15_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1144_[__fcnt] != NULL && $f_1144_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_15_, $f_1144_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpc1:206", $u_15_));
      __fcnt += 3;
    }
    if ($f_1144_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_15_].unit, "\n");
      while ($f_1144_[__fcnt] != NULL && $f_1144_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_15_, $f_1144_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpc1:206", $u_15_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_15_, $f_1144_[__fcnt + 2], &job4_, INTEGER, 4);
    _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpc1:206", $u_15_));
    __fcnt += 3;
    while ($f_1144_[__fcnt] != NULL && $f_1144_[__fcnt] == FMT_TEXT) {
      if ($f_1144_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_15_, $f_1144_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpc1:206", $u_15_));
      __fcnt += 3;
    }
    _write_eol ($u_15_);
  }
  else {
    $u_16_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:208", $u_16_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1145_[__fcnt] != NULL && $f_1145_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_16_, $f_1145_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpc1:208", $u_16_));
      __fcnt += 3;
    }
    if ($f_1145_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_16_].unit, "\n");
      while ($f_1145_[__fcnt] != NULL && $f_1145_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_16_, $f_1145_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpc1:208", $u_16_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_16_, $f_1145_[__fcnt + 2], &job4_, INTEGER, 4);
    _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpc1:208", $u_16_));
    __fcnt += 3;
    while ($f_1145_[__fcnt] != NULL && $f_1145_[__fcnt] == FMT_TEXT) {
      if ($f_1145_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_16_, $f_1145_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpc1:208", $u_16_));
      __fcnt += 3;
    }
    _write_eol ($u_16_);
  }
  if ((*isodr_)) {
    if ((*implct_)) {
      $u_17_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:212", $u_17_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1150_[__fcnt] != NULL && $f_1150_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_17_, $f_1150_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpc1:212", $u_17_));
        __fcnt += 3;
      }
      if ($f_1150_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_17_].unit, "\n");
        while ($f_1150_[__fcnt] != NULL && $f_1150_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_17_, $f_1150_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpc1:212", $u_17_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_17_, $f_1150_[__fcnt + 2], &job5_, INTEGER, 4);
      _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpc1:212", $u_17_));
      __fcnt += 3;
      while ($f_1150_[__fcnt] != NULL && $f_1150_[__fcnt] == FMT_TEXT) {
        if ($f_1150_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_17_, $f_1150_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpc1:212", $u_17_));
        __fcnt += 3;
      }
      _write_eol ($u_17_);
    }
    else {
      $u_18_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:214", $u_18_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1151_[__fcnt] != NULL && $f_1151_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_18_, $f_1151_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpc1:214", $u_18_));
        __fcnt += 3;
      }
      if ($f_1151_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_18_].unit, "\n");
        while ($f_1151_[__fcnt] != NULL && $f_1151_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_18_, $f_1151_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpc1:214", $u_18_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_18_, $f_1151_[__fcnt + 2], &job5_, INTEGER, 4);
      _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpc1:214", $u_18_));
      __fcnt += 3;
      while ($f_1151_[__fcnt] != NULL && $f_1151_[__fcnt] == FMT_TEXT) {
        if ($f_1151_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_18_, $f_1151_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpc1:214", $u_18_));
        __fcnt += 3;
      }
      _write_eol ($u_18_);
    }
  }
  else {
    $u_19_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:217", $u_19_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_19_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpc1:217", $u_19_));
      __fcnt += 3;
    }
    if ($f_1152_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_19_].unit, "\n");
      while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_19_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpc1:217", $u_19_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_19_, $f_1152_[__fcnt + 2], &job5_, INTEGER, 4);
    _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpc1:217", $u_19_));
    __fcnt += 3;
    while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
      if ($f_1152_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_19_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpc1:217", $u_19_));
      __fcnt += 3;
    }
    _write_eol ($u_19_);
  }
  if ((*neta_) < 0) {
    $u_20_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:220", $u_20_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_20_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpc1:220", $u_20_));
      __fcnt += 3;
    }
    $21_ = -(*neta_);
    if ($f_1200_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_20_].unit, "\n");
      while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_20_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpc1:220", $u_20_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_20_, $f_1200_[__fcnt + 2], &$21_, INTEGER, 4);
    _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpc1:220", $u_20_));
    __fcnt += 3;
    while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
      if ($f_1200_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_20_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpc1:220", $u_20_));
      __fcnt += 3;
    }
    _write_eol ($u_20_);
  }
  else {
    $u_22_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:222", $u_22_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1210_[__fcnt] != NULL && $f_1210_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_22_, $f_1210_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpc1:222", $u_22_));
      __fcnt += 3;
    }
    if ($f_1210_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_22_].unit, "\n");
      while ($f_1210_[__fcnt] != NULL && $f_1210_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_22_, $f_1210_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpc1:222", $u_22_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_22_, $f_1210_[__fcnt + 2], &(*neta_), INTEGER, 4);
    _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpc1:222", $u_22_));
    __fcnt += 3;
    while ($f_1210_[__fcnt] != NULL && $f_1210_[__fcnt] == FMT_TEXT) {
      if ($f_1210_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_22_, $f_1210_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpc1:222", $u_22_));
      __fcnt += 3;
    }
    _write_eol ($u_22_);
  }
  $u_23_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc1:224", $u_23_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_23_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpc1:224", $u_23_));
    __fcnt += 3;
  }
  if ($f_1300_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_23_].unit, "\n");
    while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_23_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpc1:224", $u_23_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_23_, $f_1300_[__fcnt + 2], &(*taufac_), REAL, 8);
  _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpc1:224", $u_23_));
  __fcnt += 3;
  while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
    if ($f_1300_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_23_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpc1:224", $u_23_));
    __fcnt += 3;
  }
  _write_eol ($u_23_);
  $u_24_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc1:229", $u_24_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
    __fcnt += 3;
  }
  if ($f_1400_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_24_].unit, "\n");
    while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], &(*sstol_), REAL, 8);
  _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
  __fcnt += 3;
  while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
    if ($f_1400_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
    __fcnt += 3;
  }
  if ($f_1400_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_24_].unit, "\n");
    while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], &(*partol_), REAL, 8);
  _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
  __fcnt += 3;
  while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
    if ($f_1400_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
    __fcnt += 3;
  }
  if ($f_1400_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_24_].unit, "\n");
    while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], &(*maxit_), INTEGER, 4);
  _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
  __fcnt += 3;
  while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
    if ($f_1400_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_24_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc1:229", $u_24_));
    __fcnt += 3;
  }
  _write_eol ($u_24_);
  if ((*implct_)) {
    $u_25_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:235", $u_25_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1500_[__fcnt] != NULL && $f_1500_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_25_, $f_1500_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpc1:235", $u_25_));
      __fcnt += 3;
    }
    if ($f_1500_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_25_].unit, "\n");
      while ($f_1500_[__fcnt] != NULL && $f_1500_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_25_, $f_1500_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpc1:235", $u_25_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_25_, $f_1500_[__fcnt + 2], &(*wssdel_), REAL, 8);
    _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpc1:235", $u_25_));
    __fcnt += 3;
    while ($f_1500_[__fcnt] != NULL && $f_1500_[__fcnt] == FMT_TEXT) {
      if ($f_1500_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_25_, $f_1500_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpc1:235", $u_25_));
      __fcnt += 3;
    }
    _write_eol ($u_25_);
    if ((*isodr_)) {
      $u_26_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:237", $u_26_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1510_[__fcnt] != NULL && $f_1510_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
        __fcnt += 3;
      }
      if ($f_1510_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_26_].unit, "\n");
        while ($f_1510_[__fcnt] != NULL && $f_1510_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], &(*wss_), REAL, 8);
      _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
      __fcnt += 3;
      while ($f_1510_[__fcnt] != NULL && $f_1510_[__fcnt] == FMT_TEXT) {
        if ($f_1510_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
        __fcnt += 3;
      }
      if ($f_1510_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_26_].unit, "\n");
        while ($f_1510_[__fcnt] != NULL && $f_1510_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], &(*wsseps_), REAL, 8);
      _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
      __fcnt += 3;
      while ($f_1510_[__fcnt] != NULL && $f_1510_[__fcnt] == FMT_TEXT) {
        if ($f_1510_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
        __fcnt += 3;
      }
      if ($f_1510_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_26_].unit, "\n");
        while ($f_1510_[__fcnt] != NULL && $f_1510_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], &(*pnlty_), REAL, 8);
      _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
      __fcnt += 3;
      while ($f_1510_[__fcnt] != NULL && $f_1510_[__fcnt] == FMT_TEXT) {
        if ($f_1510_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_26_, $f_1510_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc1:237", $u_26_));
        __fcnt += 3;
      }
      _write_eol ($u_26_);
    }
  }
  else {
    $u_27_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:240", $u_27_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1600_[__fcnt] != NULL && $f_1600_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_27_, $f_1600_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpc1:240", $u_27_));
      __fcnt += 3;
    }
    if ($f_1600_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_27_].unit, "\n");
      while ($f_1600_[__fcnt] != NULL && $f_1600_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_27_, $f_1600_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpc1:240", $u_27_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_27_, $f_1600_[__fcnt + 2], &(*wss_), REAL, 8);
    _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpc1:240", $u_27_));
    __fcnt += 3;
    while ($f_1600_[__fcnt] != NULL && $f_1600_[__fcnt] == FMT_TEXT) {
      if ($f_1600_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_27_, $f_1600_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpc1:240", $u_27_));
      __fcnt += 3;
    }
    _write_eol ($u_27_);
    if ((*isodr_)) {
      $u_28_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:242", $u_28_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1610_[__fcnt] != NULL && $f_1610_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_28_, $f_1610_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc1:242", $u_28_));
        __fcnt += 3;
      }
      if ($f_1610_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_28_].unit, "\n");
        while ($f_1610_[__fcnt] != NULL && $f_1610_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_28_, $f_1610_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc1:242", $u_28_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_28_, $f_1610_[__fcnt + 2], &(*wssdel_), REAL, 8);
      _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc1:242", $u_28_));
      __fcnt += 3;
      while ($f_1610_[__fcnt] != NULL && $f_1610_[__fcnt] == FMT_TEXT) {
        if ($f_1610_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_28_, $f_1610_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc1:242", $u_28_));
        __fcnt += 3;
      }
      if ($f_1610_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_28_].unit, "\n");
        while ($f_1610_[__fcnt] != NULL && $f_1610_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_28_, $f_1610_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc1:242", $u_28_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_28_, $f_1610_[__fcnt + 2], &(*wsseps_), REAL, 8);
      _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc1:242", $u_28_));
      __fcnt += 3;
      while ($f_1610_[__fcnt] != NULL && $f_1610_[__fcnt] == FMT_TEXT) {
        if ($f_1610_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_28_, $f_1610_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc1:242", $u_28_));
        __fcnt += 3;
      }
      _write_eol ($u_28_);
    }
  }
  if ((*ipr_) >= 2) {
    $u_29_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc1:252", $u_29_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_4000_[__fcnt] != NULL && $f_4000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_29_, $f_4000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_29_, _ioerr_write ("odrpack:dodpc1:252", $u_29_));
      __fcnt += 3;
    }
    _write_eol ($u_29_);
    if ((*chkjac_) && (((*msgb1_) >= 1) || ((*msgd1_) >= 1))) {
      $u_30_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:254", $u_30_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_4110_[__fcnt] != NULL && $f_4110_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_30_, $f_4110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc1:254", $u_30_));
        __fcnt += 3;
      }
      _write_eol ($u_30_);
    }
    else if ((*anajac_)) {
      $u_31_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:256", $u_31_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_4120_[__fcnt] != NULL && $f_4120_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_31_, $f_4120_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_31_, _ioerr_write ("odrpack:dodpc1:256", $u_31_));
        __fcnt += 3;
      }
      _write_eol ($u_31_);
    }
    else {
      $u_32_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:258", $u_32_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_32_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_32_, _ioerr_write ("odrpack:dodpc1:258", $u_32_));
        __fcnt += 3;
      }
      _write_eol ($u_32_);
    }
    for (j_ = 1; j_ <= (*np_); (j_)++) {
      if (ifixb_[0] < 0) {
        bufcpy (tempc1_, _dc_0, 7);
      }
      else {
        if (ifixb_[j_ - 1] != 0) {
          bufcpy (tempc1_, _dc_0, 7);
        }
        else {
          bufcpy (tempc1_, _dc_1, 7);
        }
      }
      if ((*anajac_)) {
        if ((*chkjac_) && (((*msgb1_) >= 1) || ((*msgd1_) >= 1))) {
          itemp_ = -1;
          for (l_ = 1; l_ <= (*nq_); (l_)++) {
            itemp_ = _max (itemp_, msgb_[l_ - 1 + ((*nq_)) * ((j_ - 1))]);
          }
          if (itemp_ <= -1) {
            bufcpy (tempc2_, _dc_2, 15);
          }
          else if (itemp_ == 0) {
            bufcpy (tempc2_, _dc_3, 15);
          }
          else if (itemp_ >= 1) {
            bufcpy (tempc2_, _dc_4, 15);
          }
        }
        else {
          bufcpy (tempc2_, _dc_5, 15);
        }
      }
      else {
        bufcpy (tempc2_, _dc_5, 15);
      }
      if (ssf_[0] < zero_) {
        temp1_ = _abs (ssf_[0]);
      }
      else {
        temp1_ = ssf_[j_ - 1];
      }
      if ((*anajac_)) {
        $u_33_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc1:295", $u_33_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
          __fcnt += 3;
        }
        if ($f_4310_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_33_].unit, "\n");
          while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
        __fcnt += 3;
        while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
          if ($f_4310_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
          __fcnt += 3;
        }
        if ($f_4310_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_33_].unit, "\n");
          while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
        _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
        __fcnt += 3;
        while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
          if ($f_4310_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
          __fcnt += 3;
        }
        if ($f_4310_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_33_].unit, "\n");
          while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], tempc1_, CHARACTER, 7);
        _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
        __fcnt += 3;
        while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
          if ($f_4310_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
          __fcnt += 3;
        }
        if ($f_4310_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_33_].unit, "\n");
          while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], &temp1_, REAL, 8);
        _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
        __fcnt += 3;
        while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
          if ($f_4310_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
          __fcnt += 3;
        }
        if ($f_4310_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_33_].unit, "\n");
          while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], tempc2_, CHARACTER, 15);
        _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
        __fcnt += 3;
        while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
          if ($f_4310_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_33_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc1:295", $u_33_));
          __fcnt += 3;
        }
        _write_eol ($u_33_);
      }
      else {
        if ((*cdjac_)) {
          temp2_ = _dhstep (&_k1, neta_, &_k1, &j_, stpb_, &_k1);
        }
        else {
          temp2_ = _dhstep (&_k0, neta_, &_k1, &j_, stpb_, &_k1);
        }
        $u_34_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc1:302", $u_34_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
          __fcnt += 3;
        }
        if ($f_4320_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_34_].unit, "\n");
          while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
        __fcnt += 3;
        while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
          if ($f_4320_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
          __fcnt += 3;
        }
        if ($f_4320_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_34_].unit, "\n");
          while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
        _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
        __fcnt += 3;
        while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
          if ($f_4320_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
          __fcnt += 3;
        }
        if ($f_4320_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_34_].unit, "\n");
          while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], tempc1_, CHARACTER, 7);
        _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
        __fcnt += 3;
        while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
          if ($f_4320_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
          __fcnt += 3;
        }
        if ($f_4320_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_34_].unit, "\n");
          while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], &temp1_, REAL, 8);
        _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
        __fcnt += 3;
        while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
          if ($f_4320_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
          __fcnt += 3;
        }
        if ($f_4320_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_34_].unit, "\n");
          while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], &temp2_, REAL, 8);
        _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
        __fcnt += 3;
        while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
          if ($f_4320_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_34_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_34_, _ioerr_write ("odrpack:dodpc1:302", $u_34_));
          __fcnt += 3;
        }
        _write_eol ($u_34_);
      }
    }
    if ((*isodr_)) {
      $u_35_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:309", $u_35_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_2010_[__fcnt] != NULL && $f_2010_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_35_, $f_2010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_35_, _ioerr_write ("odrpack:dodpc1:309", $u_35_));
        __fcnt += 3;
      }
      _write_eol ($u_35_);
      if ((*chkjac_) && (((*msgb1_) >= 1) || ((*msgd1_) >= 1))) {
        $u_36_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc1:311", $u_36_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2110_[__fcnt] != NULL && $f_2110_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_36_, $f_2110_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_36_, _ioerr_write ("odrpack:dodpc1:311", $u_36_));
          __fcnt += 3;
        }
        _write_eol ($u_36_);
      }
      else if ((*anajac_)) {
        $u_37_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc1:313", $u_37_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2120_[__fcnt] != NULL && $f_2120_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_37_, $f_2120_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_37_, _ioerr_write ("odrpack:dodpc1:313", $u_37_));
          __fcnt += 3;
        }
        _write_eol ($u_37_);
      }
      else {
        $u_38_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc1:315", $u_38_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2130_[__fcnt] != NULL && $f_2130_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_38_, $f_2130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc1:315", $u_38_));
          __fcnt += 3;
        }
        _write_eol ($u_38_);
      }
    }
    else {
      $u_39_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:318", $u_39_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_2020_[__fcnt] != NULL && $f_2020_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_39_, $f_2020_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_39_, _ioerr_write ("odrpack:dodpc1:318", $u_39_));
        __fcnt += 3;
      }
      _write_eol ($u_39_);
      $u_40_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:319", $u_40_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_2140_[__fcnt] != NULL && $f_2140_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_40_, $f_2140_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_40_, _ioerr_write ("odrpack:dodpc1:319", $u_40_));
        __fcnt += 3;
      }
      _write_eol ($u_40_);
    }
    if ((*isodr_)) {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        bufcpy (tempc0_, _dc_6, 3);
        for (i_ = 1; ((*n_) - 1 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += (*n_) - 1) {
          if (ifixx_[0 + ((*ldifx_)) * ((0))] < 0) {
            bufcpy (tempc1_, _dc_0, 7);
          }
          else {
            if ((*ldifx_) == 1) {
              if (ifixx_[0 + ((*ldifx_)) * ((j_ - 1))] == 0) {
                bufcpy (tempc1_, _dc_1, 7);
              }
              else {
                bufcpy (tempc1_, _dc_0, 7);
              }
            }
            else {
              if (ifixx_[i_ - 1 + ((*ldifx_)) * ((j_ - 1))] == 0) {
                bufcpy (tempc1_, _dc_1, 7);
              }
              else {
                bufcpy (tempc1_, _dc_0, 7);
              }
            }
          }
          if (tt_[0 + ((*ldtt_)) * ((0))] < zero_) {
            temp1_ = _abs (tt_[0 + ((*ldtt_)) * ((0))]);
          }
          else {
            if ((*ldtt_) == 1) {
              temp1_ = tt_[0 + ((*ldtt_)) * ((j_ - 1))];
            }
            else {
              temp1_ = tt_[i_ - 1 + ((*ldtt_)) * ((j_ - 1))];
            }
          }
          if (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))] < zero_) {
            temp2_ = _abs (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))]);
          }
          else {
            if ((*ldwd_) == 1) {
              if ((*ld2wd_) == 1) {
                temp2_ = wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((j_ - 1)))];
              }
              else {
                temp2_ = wd_[0 + ((*ldwd_)) * ((j_ - 1) + ((*ld2wd_)) * ((j_ - 1)))];
              }
            }
            else {
              if ((*ld2wd_) == 1) {
                temp2_ = wd_[i_ - 1 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((j_ - 1)))];
              }
              else {
                temp2_ = wd_[i_ - 1 + ((*ldwd_)) * ((j_ - 1) + ((*ld2wd_)) * ((j_ - 1)))];
              }
            }
          }
          if ((*anajac_)) {
            if ((*chkjac_) && ((((*msgb1_) >= 1) || ((*msgd1_) >= 1)) && (i_ == 1))) {
              itemp_ = -1;
              for (l_ = 1; l_ <= (*nq_); (l_)++) {
                itemp_ = _max (itemp_, msgd_[l_ - 1 + ((*nq_)) * ((j_ - 1))]);
              }
              if (itemp_ <= -1) {
                bufcpy (tempc2_, _dc_2, 15);
              }
              else if (itemp_ == 0) {
                bufcpy (tempc2_, _dc_3, 15);
              }
              else if (itemp_ >= 1) {
                bufcpy (tempc2_, _dc_4, 15);
              }
            }
            else {
              bufcpy (tempc2_, _dc_5, 15);
            }
            if ((*m_) <= 9) {
              $u_41_ = (*lunrpt_);
              _fcheck ("odrpack:dodpc1:391", $u_41_, action_write, form_formatted);
              __fcnt = 0;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              if ($f_5110_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_41_].unit, "\n");
                while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], tempc0_, CHARACTER, 3);
              _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
              __fcnt += 3;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              if ($f_5110_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_41_].unit, "\n");
                while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], &j_, INTEGER, 4);
              _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
              __fcnt += 3;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              if ($f_5110_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_41_].unit, "\n");
                while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], &x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
              __fcnt += 3;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              if ($f_5110_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_41_].unit, "\n");
                while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], &delta_[i_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
              __fcnt += 3;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              if ($f_5110_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_41_].unit, "\n");
                while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], tempc1_, CHARACTER, 7);
              _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
              __fcnt += 3;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              if ($f_5110_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_41_].unit, "\n");
                while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], &temp1_, REAL, 8);
              _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
              __fcnt += 3;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              if ($f_5110_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_41_].unit, "\n");
                while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], &temp2_, REAL, 8);
              _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
              __fcnt += 3;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              if ($f_5110_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_41_].unit, "\n");
                while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], tempc2_, CHARACTER, 15);
              _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
              __fcnt += 3;
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_41_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc1:391", $u_41_));
                __fcnt += 3;
              }
              _write_eol ($u_41_);
            }
            else {
              $u_42_ = (*lunrpt_);
              _fcheck ("odrpack:dodpc1:395", $u_42_, action_write, form_formatted);
              __fcnt = 0;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              if ($f_5120_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_42_].unit, "\n");
                while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], tempc0_, CHARACTER, 3);
              _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
              __fcnt += 3;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              if ($f_5120_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_42_].unit, "\n");
                while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], &j_, INTEGER, 4);
              _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
              __fcnt += 3;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              if ($f_5120_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_42_].unit, "\n");
                while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], &x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
              __fcnt += 3;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              if ($f_5120_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_42_].unit, "\n");
                while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], &delta_[i_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
              __fcnt += 3;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              if ($f_5120_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_42_].unit, "\n");
                while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], tempc1_, CHARACTER, 7);
              _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
              __fcnt += 3;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              if ($f_5120_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_42_].unit, "\n");
                while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], &temp1_, REAL, 8);
              _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
              __fcnt += 3;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              if ($f_5120_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_42_].unit, "\n");
                while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], &temp2_, REAL, 8);
              _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
              __fcnt += 3;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              if ($f_5120_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_42_].unit, "\n");
                while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], tempc2_, CHARACTER, 15);
              _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
              __fcnt += 3;
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_42_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc1:395", $u_42_));
                __fcnt += 3;
              }
              _write_eol ($u_42_);
            }
          }
          else {
            bufcpy (tempc2_, _dc_5, 15);
            if ((*cdjac_)) {
              temp3_ = _dhstep (&_k1, neta_, &i_, &j_, stpd_, ldstpd_);
            }
            else {
              temp3_ = _dhstep (&_k0, neta_, &i_, &j_, stpd_, ldstpd_);
            }
            if ((*m_) <= 9) {
              $u_43_ = (*lunrpt_);
              _fcheck ("odrpack:dodpc1:407", $u_43_, action_write, form_formatted);
              __fcnt = 0;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              if ($f_5210_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_43_].unit, "\n");
                while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], tempc0_, CHARACTER, 3);
              _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
              __fcnt += 3;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                if ($f_5210_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              if ($f_5210_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_43_].unit, "\n");
                while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], &j_, INTEGER, 4);
              _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
              __fcnt += 3;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                if ($f_5210_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              if ($f_5210_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_43_].unit, "\n");
                while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], &x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
              __fcnt += 3;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                if ($f_5210_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              if ($f_5210_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_43_].unit, "\n");
                while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], &delta_[i_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
              __fcnt += 3;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                if ($f_5210_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              if ($f_5210_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_43_].unit, "\n");
                while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], tempc1_, CHARACTER, 7);
              _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
              __fcnt += 3;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                if ($f_5210_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              if ($f_5210_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_43_].unit, "\n");
                while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], &temp1_, REAL, 8);
              _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
              __fcnt += 3;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                if ($f_5210_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              if ($f_5210_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_43_].unit, "\n");
                while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], &temp2_, REAL, 8);
              _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
              __fcnt += 3;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                if ($f_5210_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              if ($f_5210_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_43_].unit, "\n");
                while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], &temp3_, REAL, 8);
              _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
              __fcnt += 3;
              while ($f_5210_[__fcnt] != NULL && $f_5210_[__fcnt] == FMT_TEXT) {
                if ($f_5210_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_43_, $f_5210_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc1:407", $u_43_));
                __fcnt += 3;
              }
              _write_eol ($u_43_);
            }
            else {
              $u_44_ = (*lunrpt_);
              _fcheck ("odrpack:dodpc1:411", $u_44_, action_write, form_formatted);
              __fcnt = 0;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              if ($f_5220_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], tempc0_, CHARACTER, 3);
              _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
              __fcnt += 3;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                if ($f_5220_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              if ($f_5220_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], &j_, INTEGER, 4);
              _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
              __fcnt += 3;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                if ($f_5220_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              if ($f_5220_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], &x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
              __fcnt += 3;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                if ($f_5220_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              if ($f_5220_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], &delta_[i_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
              __fcnt += 3;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                if ($f_5220_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              if ($f_5220_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], tempc1_, CHARACTER, 7);
              _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
              __fcnt += 3;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                if ($f_5220_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              if ($f_5220_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], &temp1_, REAL, 8);
              _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
              __fcnt += 3;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                if ($f_5220_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              if ($f_5220_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], &temp2_, REAL, 8);
              _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
              __fcnt += 3;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                if ($f_5220_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              if ($f_5220_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_44_].unit, "\n");
                while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], &temp3_, REAL, 8);
              _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
              __fcnt += 3;
              while ($f_5220_[__fcnt] != NULL && $f_5220_[__fcnt] == FMT_TEXT) {
                if ($f_5220_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_44_, $f_5220_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc1:411", $u_44_));
                __fcnt += 3;
              }
              _write_eol ($u_44_);
            }
          }
          bufcpy (tempc0_, _dc_7, 3);
        }
        if (j_ < (*m_)) {
          $u_45_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc1:420", $u_45_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_6000_[__fcnt] != NULL && $f_6000_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_45_, $f_6000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_45_, _ioerr_write ("odrpack:dodpc1:420", $u_45_));
            __fcnt += 3;
          }
          _write_eol ($u_45_);
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        bufcpy (tempc0_, _dc_6, 3);
        for (i_ = 1; ((*n_) - 1 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += (*n_) - 1) {
          if ((*m_) <= 9) {
            $u_46_ = (*lunrpt_);
            _fcheck ("odrpack:dodpc1:428", $u_46_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
              __fcnt += 3;
            }
            if ($f_5110_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_46_].unit, "\n");
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], tempc0_, CHARACTER, 3);
            _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
            __fcnt += 3;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
              __fcnt += 3;
            }
            if ($f_5110_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_46_].unit, "\n");
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], &j_, INTEGER, 4);
            _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
            __fcnt += 3;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
              __fcnt += 3;
            }
            if ($f_5110_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_46_].unit, "\n");
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], &x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
            __fcnt += 3;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_46_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc1:428", $u_46_));
              __fcnt += 3;
            }
            _write_eol ($u_46_);
          }
          else {
            $u_47_ = (*lunrpt_);
            _fcheck ("odrpack:dodpc1:431", $u_47_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
              __fcnt += 3;
            }
            if ($f_5120_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_47_].unit, "\n");
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], tempc0_, CHARACTER, 3);
            _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
            __fcnt += 3;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
              __fcnt += 3;
            }
            if ($f_5120_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_47_].unit, "\n");
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], &j_, INTEGER, 4);
            _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
            __fcnt += 3;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
              __fcnt += 3;
            }
            if ($f_5120_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_47_].unit, "\n");
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], &x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
            __fcnt += 3;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_47_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc1:431", $u_47_));
              __fcnt += 3;
            }
            _write_eol ($u_47_);
          }
          bufcpy (tempc0_, _dc_7, 3);
        }
        if (j_ < (*m_)) {
          $u_48_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc1:436", $u_48_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_6000_[__fcnt] != NULL && $f_6000_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_48_, $f_6000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_48_, _ioerr_write ("odrpack:dodpc1:436", $u_48_));
            __fcnt += 3;
          }
          _write_eol ($u_48_);
        }
      }
    }
    if (! ((*implct_))) {
      $u_49_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:443", $u_49_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_3000_[__fcnt] != NULL && $f_3000_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_49_, $f_3000_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc1:443", $u_49_));
        __fcnt += 3;
      }
      _write_eol ($u_49_);
      $u_50_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc1:444", $u_50_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_3100_[__fcnt] != NULL && $f_3100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_50_, $f_3100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_50_, _ioerr_write ("odrpack:dodpc1:444", $u_50_));
        __fcnt += 3;
      }
      _write_eol ($u_50_);
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        bufcpy (tempc0_, _dc_6, 3);
        for (i_ = 1; ((*n_) - 1 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += (*n_) - 1) {
          if (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))] < zero_) {
            temp1_ = _abs (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))]);
          }
          else if ((*ldwe_) == 1) {
            if ((*ld2we_) == 1) {
              temp1_ = we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))];
            }
            else {
              temp1_ = we_[0 + ((*ldwe_)) * ((l_ - 1) + ((*ld2we_)) * ((l_ - 1)))];
            }
          }
          else {
            if ((*ld2we_) == 1) {
              temp1_ = we_[i_ - 1 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((l_ - 1)))];
            }
            else {
              temp1_ = we_[i_ - 1 + ((*ldwe_)) * ((l_ - 1) + ((*ld2we_)) * ((l_ - 1)))];
            }
          }
          if ((*nq_) <= 9) {
            $u_51_ = (*lunrpt_);
            _fcheck ("odrpack:dodpc1:464", $u_51_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
              __fcnt += 3;
            }
            if ($f_5110_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_51_].unit, "\n");
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], tempc0_, CHARACTER, 3);
            _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
            __fcnt += 3;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
              __fcnt += 3;
            }
            if ($f_5110_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_51_].unit, "\n");
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], &l_, INTEGER, 4);
            _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
            __fcnt += 3;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
              __fcnt += 3;
            }
            if ($f_5110_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_51_].unit, "\n");
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], &y_[i_ - 1 + ((*ldy_)) * ((l_ - 1))], REAL, 8);
            _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
            __fcnt += 3;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
              __fcnt += 3;
            }
            if ($f_5110_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_51_].unit, "\n");
              while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], &temp1_, REAL, 8);
            _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
            __fcnt += 3;
            while ($f_5110_[__fcnt] != NULL && $f_5110_[__fcnt] == FMT_TEXT) {
              if ($f_5110_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_51_, $f_5110_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc1:464", $u_51_));
              __fcnt += 3;
            }
            _write_eol ($u_51_);
          }
          else {
            $u_52_ = (*lunrpt_);
            _fcheck ("odrpack:dodpc1:467", $u_52_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
              __fcnt += 3;
            }
            if ($f_5120_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_52_].unit, "\n");
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], tempc0_, CHARACTER, 3);
            _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
            __fcnt += 3;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
              __fcnt += 3;
            }
            if ($f_5120_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_52_].unit, "\n");
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], &l_, INTEGER, 4);
            _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
            __fcnt += 3;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
              __fcnt += 3;
            }
            if ($f_5120_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_52_].unit, "\n");
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], &y_[i_ - 1 + ((*ldy_)) * ((l_ - 1))], REAL, 8);
            _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
            __fcnt += 3;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
              __fcnt += 3;
            }
            if ($f_5120_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_52_].unit, "\n");
              while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], &temp1_, REAL, 8);
            _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
            __fcnt += 3;
            while ($f_5120_[__fcnt] != NULL && $f_5120_[__fcnt] == FMT_TEXT) {
              if ($f_5120_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_52_, $f_5120_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc1:467", $u_52_));
              __fcnt += 3;
            }
            _write_eol ($u_52_);
          }
          bufcpy (tempc0_, _dc_7, 3);
        }
        if (l_ < (*nq_)) {
          $u_53_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc1:472", $u_53_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_6000_[__fcnt] != NULL && $f_6000_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_53_, $f_6000_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_53_, _ioerr_write ("odrpack:dodpc1:472", $u_53_));
            __fcnt += 3;
          }
          _write_eol ($u_53_);
        }
      }
    }
  }
  goto _l0;
  _l1000:;
  _l1100:;
  _l1110:;
  _l1111:;
  _l1120:;
  _l1121:;
  _l1122:;
  _l1130:;
  _l1131:;
  _l1132:;
  _l1133:;
  _l1140:;
  _l1141:;
  _l1142:;
  _l1143:;
  _l1144:;
  _l1145:;
  _l1150:;
  _l1151:;
  _l1152:;
  _l1200:;
  _l1210:;
  _l1300:;
  _l1400:;
  _l1500:;
  _l1510:;
  _l1600:;
  _l1610:;
  _l2010:;
  _l2020:;
  _l2110:;
  _l2120:;
  _l2130:;
  _l2140:;
  _l3000:;
  _l3100:;
  _l4000:;
  _l4110:;
  _l4120:;
  _l4200:;
  _l4310:;
  _l4320:;
  _l5110:;
  _l5120:;
  _l5210:;
  _l5220:;
  _l6000:;
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _dodpc2 (int_4 _p_ ipr_, int_4 _p_ lunrpt_, logical_4 _p_ fstitr_, logical_4 _p_ implct_, logical_4 _p_ prtpen_, 
real_8 _p_ pnlty_, int_4 _p_ niter_, int_4 _p_ nfev_, real_8 _p_ wss_, real_8 _p_ actred_, real_8 _p_ prered_, real_8 
_p_ alpha_, real_8 _p_ tau_, real_8 _p_ pnorm_, int_4 _p_ np_, real_8 _p_ beta_)
{
  static int_4 j_, k_, l_;
  static real_8 ratio_, zero_;
  static char_3 gn_;
  int_4 _data_k_22, $u_0_, __fcnt, __rc, $u_1_, $u_2_, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_;
  static FORMAT $f_1121_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_105, _dc_105,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_106, _dc_106,
    FMT_TEXT, _dc_107, _dc_107,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_108, _dc_108,
    FMT_TEXT, _dc_109, _dc_109,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_110, _dc_110,
    FMT_TEXT, _dc_111, _dc_111,
    NULL, NULL, NULL
  };
  static FORMAT $f_1122_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_112, _dc_112,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_113, _dc_113,
    FMT_TEXT, _dc_107, _dc_107,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_114, _dc_114,
    FMT_TEXT, _dc_109, _dc_109,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_110, _dc_110,
    FMT_TEXT, _dc_111, _dc_111,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_1131_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_105, _dc_105,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_106, _dc_106,
    FMT_TEXT, _dc_115, _dc_115,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_108, _dc_108,
    FMT_TEXT, _dc_116, _dc_116,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_110, _dc_110,
    FMT_TEXT, _dc_117, _dc_117,
    NULL, NULL, NULL
  };
  static FORMAT $f_1132_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_112, _dc_112,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_113, _dc_113,
    FMT_TEXT, _dc_115, _dc_115,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_114, _dc_114,
    FMT_TEXT, _dc_116, _dc_116,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_110, _dc_110,
    FMT_TEXT, _dc_117, _dc_117,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_1133_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_118, _dc_118,
    FMT_TEXT,"","1",
    FMT_REAL,"%10e","%10.1.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_1141_[] = {
    FMT_TEXT, _dc_100, _dc_100,
    FMT_INT,"%4d","%4d",
    FMT_INT,"%8d","%8d",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.5.0e",
    FMT_REAL,"%13e","%13.4.0e",
    FMT_REAL,"%13e","%13.4.0e",
    FMT_REAL,"%11e","%11.3.0e",
    FMT_TEXT, _dc_119, _dc_119,
    FMT_CHAR,"%3s","%-3s",
    FMT_TEXT, _dc_98, _dc_98,
    FMT_INT,"%3d","%3d",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_1142_[] = {
    FMT_TEXT, _dc_100, _dc_100,
    FMT_INT,"%4d","%4d",
    FMT_INT,"%8d","%8d",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.5.0e",
    FMT_REAL,"%13e","%13.4.0e",
    FMT_REAL,"%13e","%13.4.0e",
    FMT_REAL,"%11e","%11.3.0e",
    FMT_TEXT, _dc_119, _dc_119,
    FMT_CHAR,"%3s","%-3s",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_INT,"%3d","%3d",
    FMT_TEXT, _dc_120, _dc_120,
    FMT_INT,"%3d","%3d",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_1151_[] = {
    FMT_TEXT, _dc_121, _dc_121,
    FMT_INT,"%3d","%3d",
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_1152_[] = {
    FMT_TEXT, _dc_122, _dc_122,
    FMT_INT,"%3d","%3d",
    FMT_TEXT, _dc_120, _dc_120,
    FMT_INT,"%3d","%3d",
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
#define _data_n_22 1
  static real_8 _data_l_22[_data_n_22] = {
    0.0e0
  };
  if (__calls[27].calls == 0) {
    _data_k_22 = 0;
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    zero_ = _data_l_22[_data_k_22++];
  }
  if ((*fstitr_)) {
    if ((*ipr_) == 1) {
      if ((*implct_)) {
        $u_0_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc2:78", $u_0_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1121_[__fcnt] != NULL && $f_1121_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_0_, $f_1121_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc2:78", $u_0_));
          __fcnt += 3;
        }
        _write_eol ($u_0_);
      }
      else {
        $u_1_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc2:80", $u_1_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1122_[__fcnt] != NULL && $f_1122_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_1_, $f_1122_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc2:80", $u_1_));
          __fcnt += 3;
        }
        _write_eol ($u_1_);
      }
    }
    else {
      if ((*implct_)) {
        $u_2_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc2:84", $u_2_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1131_[__fcnt] != NULL && $f_1131_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_2_, $f_1131_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc2:84", $u_2_));
          __fcnt += 3;
        }
        _write_eol ($u_2_);
      }
      else {
        $u_3_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc2:86", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1132_[__fcnt] != NULL && $f_1132_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_1132_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc2:86", $u_3_));
          __fcnt += 3;
        }
        _write_eol ($u_3_);
      }
    }
  }
  if ((*prtpen_)) {
    $u_4_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc2:91", $u_4_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1133_[__fcnt] != NULL && $f_1133_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_4_, $f_1133_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc2:91", $u_4_));
      __fcnt += 3;
    }
    if ($f_1133_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_4_].unit, "\n");
      while ($f_1133_[__fcnt] != NULL && $f_1133_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_4_, $f_1133_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc2:91", $u_4_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_4_, $f_1133_[__fcnt + 2], &(*pnlty_), REAL, 8);
    _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc2:91", $u_4_));
    __fcnt += 3;
    while ($f_1133_[__fcnt] != NULL && $f_1133_[__fcnt] == FMT_TEXT) {
      if ($f_1133_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_4_, $f_1133_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc2:91", $u_4_));
      __fcnt += 3;
    }
    _write_eol ($u_4_);
  }
  if ((*alpha_) == zero_) {
    bufcpy (gn_, _dc_103, 3);
  }
  else {
    bufcpy (gn_, _dc_104, 3);
  }
  if ((*pnorm_) != zero_) {
    ratio_ = (*tau_) / (*pnorm_);
  }
  else {
    ratio_ = zero_;
  }
  if ((*ipr_) == 1) {
    $u_5_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc2:105", $u_5_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
      __fcnt += 3;
    }
    if ($f_1141_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], &(*niter_), INTEGER, 4);
    _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
    __fcnt += 3;
    while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
      if ($f_1141_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
      __fcnt += 3;
    }
    if ($f_1141_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], &(*nfev_), INTEGER, 4);
    _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
    __fcnt += 3;
    while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
      if ($f_1141_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
      __fcnt += 3;
    }
    if ($f_1141_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], &(*wss_), REAL, 8);
    _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
    __fcnt += 3;
    while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
      if ($f_1141_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
      __fcnt += 3;
    }
    if ($f_1141_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], &(*actred_), REAL, 8);
    _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
    __fcnt += 3;
    while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
      if ($f_1141_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
      __fcnt += 3;
    }
    if ($f_1141_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], &(*prered_), REAL, 8);
    _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
    __fcnt += 3;
    while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
      if ($f_1141_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
      __fcnt += 3;
    }
    if ($f_1141_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], &ratio_, REAL, 8);
    _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
    __fcnt += 3;
    while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
      if ($f_1141_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
      __fcnt += 3;
    }
    if ($f_1141_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_5_].unit, "\n");
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], gn_, CHARACTER, 3);
    _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
    __fcnt += 3;
    while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
      if ($f_1141_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_5_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc2:105", $u_5_));
      __fcnt += 3;
    }
    _write_eol ($u_5_);
  }
  else {
    j_ = 1;
    k_ = _min (3, (*np_));
    if (j_ == k_) {
      $u_6_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc2:111", $u_6_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], &(*niter_), INTEGER, 4);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], &(*nfev_), INTEGER, 4);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], &(*wss_), REAL, 8);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], &(*actred_), REAL, 8);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], &(*prered_), REAL, 8);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], &ratio_, REAL, 8);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], gn_, CHARACTER, 3);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], &j_, INTEGER, 4);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      if ($f_1141_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_6_].unit, "\n");
        while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
      __fcnt += 3;
      while ($f_1141_[__fcnt] != NULL && $f_1141_[__fcnt] == FMT_TEXT) {
        if ($f_1141_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_6_, $f_1141_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc2:111", $u_6_));
        __fcnt += 3;
      }
      _write_eol ($u_6_);
    }
    else {
      $u_7_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc2:114", $u_7_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &(*niter_), INTEGER, 4);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &(*nfev_), INTEGER, 4);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &(*wss_), REAL, 8);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &(*actred_), REAL, 8);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &(*prered_), REAL, 8);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &ratio_, REAL, 8);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], gn_, CHARACTER, 3);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &j_, INTEGER, 4);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      if ($f_1142_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_7_].unit, "\n");
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &k_, INTEGER, 4);
      _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
      __fcnt += 3;
      while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
        if ($f_1142_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
      }
      for (l_ = j_; l_ <= k_; l_++) {
        if ($f_1142_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_7_].unit, "\n");
          while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], &beta_[l_ - 1], REAL, 8);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
        __fcnt += 3;
        while ($f_1142_[__fcnt] != NULL && $f_1142_[__fcnt] == FMT_TEXT) {
          if ($f_1142_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_7_, $f_1142_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc2:114", $u_7_));
          __fcnt += 3;
        }
      }; // implied DO 
      _write_eol ($u_7_);
    }
    if ((*np_) > 3) {
      for (j_ = 4; (3 > 0 ? j_ <= (*np_) : j_ >= (*np_)); j_ += 3) {
        k_ = _min (j_ + 2, (*np_));
        if (j_ == k_) {
          $u_8_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc2:121", $u_8_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_1151_[__fcnt] != NULL && $f_1151_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_1151_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc2:121", $u_8_));
            __fcnt += 3;
          }
          if ($f_1151_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_1151_[__fcnt] != NULL && $f_1151_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_1151_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc2:121", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_1151_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc2:121", $u_8_));
          __fcnt += 3;
          while ($f_1151_[__fcnt] != NULL && $f_1151_[__fcnt] == FMT_TEXT) {
            if ($f_1151_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_1151_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc2:121", $u_8_));
            __fcnt += 3;
          }
          if ($f_1151_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_1151_[__fcnt] != NULL && $f_1151_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_1151_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc2:121", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_1151_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc2:121", $u_8_));
          __fcnt += 3;
          while ($f_1151_[__fcnt] != NULL && $f_1151_[__fcnt] == FMT_TEXT) {
            if ($f_1151_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_1151_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc2:121", $u_8_));
            __fcnt += 3;
          }
          _write_eol ($u_8_);
        }
        else {
          $u_9_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc2:123", $u_9_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
            __fcnt += 3;
          }
          if ($f_1152_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_9_].unit, "\n");
            while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
          __fcnt += 3;
          while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
            if ($f_1152_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
            __fcnt += 3;
          }
          if ($f_1152_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_9_].unit, "\n");
            while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], &k_, INTEGER, 4);
          _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
          __fcnt += 3;
          while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
            if ($f_1152_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
            __fcnt += 3;
          }
          for (l_ = j_; l_ <= k_; l_++) {
            if ($f_1152_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_9_].unit, "\n");
              while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], &beta_[l_ - 1], REAL, 8);
            _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
            __fcnt += 3;
            while ($f_1152_[__fcnt] != NULL && $f_1152_[__fcnt] == FMT_TEXT) {
              if ($f_1152_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_9_, $f_1152_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc2:123", $u_9_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_9_);
        }
      }
    }
  }
  goto _l0;
  _l1121:;
  _l1122:;
  _l1131:;
  _l1132:;
  _l1133:;
  _l1141:;
  _l1142:;
  _l1151:;
  _l1152:;
  _l0:;
  __calls[27].calls++;
  return 0;
}

int_4 _dodpc3 (int_4 _p_ ipr_, int_4 _p_ lunrpt_, logical_4 _p_ isodr_, logical_4 _p_ implct_, logical_4 _p_ didvcv_, 
logical_4 _p_ dovcv_, logical_4 _p_ redoj_, logical_4 _p_ anajac_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ 
nq_, int_4 _p_ npp_, int_4 _p_ info_, int_4 _p_ niter_, int_4 _p_ nfev_, int_4 _p_ njev_, int_4 _p_ irank_, real_8 _p_ 
rcond_, int_4 _p_ istop_, real_8 _p_ wss_, real_8 _p_ wssdel_, real_8 _p_ wsseps_, real_8 _p_ pnlty_, real_8 _p_ rvar_, 
int_4 _p_ idf_, real_8 _p_ beta_, real_8 _p_ sdbeta_, int_4 _p_ ifixb2_, real_8 _p_ f_, real_8 _p_ delta_)
{
  static int_4 d1_, d2_, d3_, d4_, d5_, i_, j_, k_, l_, nplm1_;
  static real_8 tval_;
  static char_127 fmt1_;
  int_4 $u_0_, __fcnt, __rc, $u_1_, $u_2_, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_, $u_10_, $u_11_, $u_12_, 
  $u_13_, $u_14_, $u_15_, $u_16_, $u_17_, $u_18_, $u_19_, $u_20_, $u_21_, $u_22_, $u_23_, $u_24_, $u_25_, $u_26_, $u_27_, 
  $u_28_, $u_29_, $u_30_, $u_31_, $u_32_, $u_33_, $u_35_, $u_36_, $u_38_, $u_41_, $u_42_, $u_43_, $u_44_, $u_45_, $u_46_, 
  $u_47_, $u_48_, $u_49_, $u_50_, $u_51_, $u_52_, $u_53_, $u_54_, $u_55_, $u_56_, $u_57_, $u_58_, $u_59_, $u_60_, $u_61_, 
  $u_62_, $u_63_, $u_64_, $u_65_, $u_66_, $u_67_, $u_68_, $u_69_, $u_70_, $u_71_, $u_72_, $u_73_, $u_74_;
  real_8 $34_, $37_, $39_, $40_;
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_123, _dc_123,
    NULL, NULL, NULL
  };
  static FORMAT $f_1011_[] = {
    FMT_TEXT, _dc_124, _dc_124,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_125, _dc_125,
    NULL, NULL, NULL
  };
  static FORMAT $f_1012_[] = {
    FMT_TEXT, _dc_124, _dc_124,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_126, _dc_126,
    NULL, NULL, NULL
  };
  static FORMAT $f_1013_[] = {
    FMT_TEXT, _dc_124, _dc_124,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_127, _dc_127,
    FMT_TEXT, _dc_128, _dc_128,
    NULL, NULL, NULL
  };
  static FORMAT $f_1014_[] = {
    FMT_TEXT, _dc_124, _dc_124,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_129, _dc_129,
    NULL, NULL, NULL
  };
  static FORMAT $f_1015_[] = {
    FMT_TEXT, _dc_124, _dc_124,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_130, _dc_130,
    FMT_TEXT, _dc_131, _dc_131,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_132, _dc_132,
    FMT_TEXT, _dc_133, _dc_133,
    NULL, NULL, NULL
  };
  static FORMAT $f_1020_[] = {
    FMT_TEXT, _dc_124, _dc_124,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_134, _dc_134,
    FMT_TEXT, _dc_135, _dc_135,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_136, _dc_136,
    FMT_TEXT, _dc_137, _dc_137,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_138, _dc_138,
    NULL, NULL, NULL
  };
  static FORMAT $f_1021_[] = {
    FMT_TEXT, _dc_139, _dc_139,
    FMT_TEXT, _dc_140, _dc_140,
    NULL, NULL, NULL
  };
  static FORMAT $f_1022_[] = {
    FMT_TEXT, _dc_141, _dc_141,
    FMT_TEXT, _dc_142, _dc_142,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_143, _dc_143,
    NULL, NULL, NULL
  };
  static FORMAT $f_1023_[] = {
    FMT_TEXT, _dc_144, _dc_144,
    FMT_TEXT, _dc_145, _dc_145,
    NULL, NULL, NULL
  };
  static FORMAT $f_1024_[] = {
    FMT_TEXT, _dc_146, _dc_146,
    FMT_TEXT, _dc_147, _dc_147,
    NULL, NULL, NULL
  };
  static FORMAT $f_1031_[] = {
    FMT_TEXT, _dc_148, _dc_148,
    NULL, NULL, NULL
  };
  static FORMAT $f_1032_[] = {
    FMT_TEXT, _dc_149, _dc_149,
    NULL, NULL, NULL
  };
  static FORMAT $f_1033_[] = {
    FMT_TEXT, _dc_150, _dc_150,
    FMT_TEXT, _dc_151, _dc_151,
    NULL, NULL, NULL
  };
  static FORMAT $f_1034_[] = {
    FMT_TEXT, _dc_152, _dc_152,
    NULL, NULL, NULL
  };
  static FORMAT $f_1035_[] = {
    FMT_TEXT, _dc_37, _dc_37,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_130, _dc_130,
    FMT_TEXT, _dc_131, _dc_131,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_153, _dc_153,
    FMT_TEXT, _dc_133, _dc_133,
    NULL, NULL, NULL
  };
  static FORMAT $f_1040_[] = {
    FMT_TEXT, _dc_124, _dc_124,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_154, _dc_154,
    FMT_TEXT, _dc_155, _dc_155,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_156, _dc_156,
    NULL, NULL, NULL
  };
  static FORMAT $f_1042_[] = {
    FMT_TEXT, _dc_157, _dc_157,
    FMT_TEXT, _dc_158, _dc_158,
    NULL, NULL, NULL
  };
  static FORMAT $f_1043_[] = {
    FMT_TEXT, _dc_22, _dc_22,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_159, _dc_159,
    FMT_TEXT, _dc_160, _dc_160,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_161, _dc_161,
    NULL, NULL, NULL
  };
  static FORMAT $f_1044_[] = {
    FMT_TEXT, _dc_29, _dc_29,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_159, _dc_159,
    FMT_TEXT, _dc_162, _dc_162,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_163, _dc_163,
    FMT_TEXT, _dc_164, _dc_164,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_165, _dc_165,
    FMT_TEXT, _dc_166, _dc_166,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_167, _dc_167,
    NULL, NULL, NULL
  };
  static FORMAT $f_1045_[] = {
    FMT_TEXT, _dc_29, _dc_29,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_159, _dc_159,
    FMT_TEXT, _dc_160, _dc_160,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_168, _dc_168,
    NULL, NULL, NULL
  };
  static FORMAT $f_1050_[] = {
    FMT_TEXT, _dc_169, _dc_169,
    FMT_TEXT, _dc_170, _dc_170,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_171, _dc_171,
    FMT_TEXT, _dc_172, _dc_172,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_173, _dc_173,
    FMT_TEXT, _dc_174, _dc_174,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_175, _dc_175,
    NULL, NULL, NULL
  };
  static FORMAT $f_1060_[] = {
    FMT_TEXT, _dc_19, _dc_19,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_130, _dc_130,
    FMT_TEXT, _dc_131, _dc_131,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_153, _dc_153,
    FMT_TEXT, _dc_133, _dc_133,
    NULL, NULL, NULL
  };
  static FORMAT $f_1300_[] = {
    FMT_TEXT, _dc_176, _dc_176,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_177, _dc_177,
    NULL, NULL, NULL
  };
  static FORMAT $f_1310_[] = {
    FMT_TEXT, _dc_178, _dc_178,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_179, _dc_179,
    NULL, NULL, NULL
  };
  static FORMAT $f_1320_[] = {
    FMT_TEXT, _dc_180, _dc_180,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_181, _dc_181,
    NULL, NULL, NULL
  };
  static FORMAT $f_1330_[] = {
    FMT_TEXT, _dc_182, _dc_182,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_183, _dc_183,
    NULL, NULL, NULL
  };
  static FORMAT $f_1340_[] = {
    FMT_TEXT, _dc_184, _dc_184,
    FMT_TEXT,"","1",
    FMT_REAL,"%12e","%12.2.0e",
    FMT_TEXT, _dc_185, _dc_185,
    NULL, NULL, NULL
  };
  static FORMAT $f_1350_[] = {
    FMT_TEXT, _dc_186, _dc_186,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_187, _dc_187,
    FMT_TEXT, _dc_188, _dc_188,
    NULL, NULL, NULL
  };
  static FORMAT $f_2000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_189, _dc_189,
    FMT_TEXT, _dc_64, _dc_64,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_2010_[] = {
    FMT_TEXT, _dc_190, _dc_190,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_191, _dc_191,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_192, _dc_192,
    FMT_TEXT,"","1",
    FMT_REAL,"%10e","%10.1.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_2100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_193, _dc_193,
    FMT_TEXT, _dc_64, _dc_64,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_2110_[] = {
    FMT_TEXT, _dc_194, _dc_194,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_195, _dc_195,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_2200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_196, _dc_196,
    FMT_TEXT, _dc_64, _dc_64,
    FMT_TEXT,"","1",
    FMT_REAL,"%17e","%17.8.0e",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_197, _dc_197,
    FMT_INT,"%5d","%5d",
    NULL, NULL, NULL
  };
  static FORMAT $f_3000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_198, _dc_198,
    NULL, NULL, NULL
  };
  static FORMAT $f_4100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_199, _dc_199,
    NULL, NULL, NULL
  };
  static FORMAT $f_4110_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_200, _dc_200,
    NULL, NULL, NULL
  };
  static FORMAT $f_4120_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_201, _dc_201,
    NULL, NULL, NULL
  };
  static FORMAT $f_4130_[] = {
    FMT_TEXT, _dc_202, _dc_202,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_4200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_203, _dc_203,
    FMT_INT,"%3d","%3d",
    FMT_TEXT, _dc_204, _dc_204,
    NULL, NULL, NULL
  };
  static FORMAT $f_4300_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_205, _dc_205,
    FMT_INT,"%3d","%3d",
    FMT_TEXT, _dc_204, _dc_204,
    NULL, NULL, NULL
  };
  static FORMAT $f_7100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_206, _dc_206,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_7200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_207, _dc_207,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_7300_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_208, _dc_208,
    FMT_TEXT, _dc_209, _dc_209,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_7310_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_210, _dc_210,
    FMT_TEXT, _dc_211, _dc_211,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_212, _dc_212,
    FMT_TEXT, _dc_213, _dc_213,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_214, _dc_214,
    FMT_TEXT, _dc_215, _dc_215,
    NULL, NULL, NULL
  };
  static FORMAT $f_7410_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_216, _dc_216,
    FMT_TEXT, _dc_217, _dc_217,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_218, _dc_218,
    FMT_TEXT, _dc_219, _dc_219,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_220, _dc_220,
    FMT_TEXT, _dc_221, _dc_221,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_222, _dc_222,
    FMT_TEXT, _dc_223, _dc_223,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_224, _dc_224,
    NULL, NULL, NULL
  };
  static FORMAT $f_7420_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_216, _dc_216,
    FMT_TEXT, _dc_225, _dc_225,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_226, _dc_226,
    NULL, NULL, NULL
  };
  static FORMAT $f_7500_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_227, _dc_227,
    NULL, NULL, NULL
  };
  static FORMAT $f_8100_[] = {
    FMT_TEXT, _dc_228, _dc_228,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_8200_[] = {
    FMT_TEXT, _dc_119, _dc_119,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_120, _dc_120,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_8400_[] = {
    FMT_TEXT, _dc_119, _dc_119,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_119, _dc_119,
    FMT_REAL,"%12e","%12.4.0e",
    FMT_TEXT, _dc_119, _dc_119,
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_TEXT, _dc_229, _dc_229,
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_8500_[] = {
    FMT_TEXT, _dc_119, _dc_119,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_230, _dc_230,
    FMT_TEXT, _dc_231, _dc_231,
    NULL, NULL, NULL
  };
  static FORMAT $f_8600_[] = {
    FMT_TEXT, _dc_119, _dc_119,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_230, _dc_230,
    FMT_TEXT, _dc_232, _dc_232,
    NULL, NULL, NULL
  };
  static FORMAT $f_8700_[] = {
    FMT_TEXT, _dc_119, _dc_119,
    FMT_INT,"%5d","%5d",
    FMT_TEXT, _dc_100, _dc_100,
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_TEXT, _dc_230, _dc_230,
    FMT_TEXT, _dc_233, _dc_233,
    NULL, NULL, NULL
  };
  static FORMAT $f_8800_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_234, _dc_234,
    FMT_TEXT, _dc_235, _dc_235,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_236, _dc_236,
    FMT_TEXT, _dc_237, _dc_237,
    NULL, NULL, NULL
  };
  static FORMAT $f_8900_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_238, _dc_238,
    FMT_TEXT, _dc_239, _dc_239,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_240, _dc_240,
    NULL, NULL, NULL
  };
  static FORMAT $f_9110_[] = {
    FMT_TEXT, _dc_241, _dc_241,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_242, _dc_242,
    NULL, NULL, NULL
  };
  static FORMAT $f_9120_[] = {
    FMT_TEXT, _dc_241, _dc_241,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_243, _dc_243,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_242, _dc_242,
    NULL, NULL, NULL
  };
  static FORMAT $f_9130_[] = {
    FMT_TEXT, _dc_241, _dc_241,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_244, _dc_244,
    NULL, NULL, NULL
  };
  d1_ = (*info_) / 10000;
  d2_ = _imod ((*info_), 10000) / 1000;
  d3_ = _imod ((*info_), 1000) / 100;
  d4_ = _imod ((*info_), 100) / 10;
  d5_ = _imod ((*info_), 10);
  $u_0_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc3:121", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpc3:121", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  if ((*info_) <= 9) {
    if ((*info_) == 1) {
      $u_1_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:124", $u_1_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1011_[__fcnt] != NULL && $f_1011_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_1_, $f_1011_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc3:124", $u_1_));
        __fcnt += 3;
      }
      if ($f_1011_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_1_].unit, "\n");
        while ($f_1011_[__fcnt] != NULL && $f_1011_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_1_, $f_1011_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc3:124", $u_1_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_1_, $f_1011_[__fcnt + 2], &(*info_), INTEGER, 4);
      _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc3:124", $u_1_));
      __fcnt += 3;
      while ($f_1011_[__fcnt] != NULL && $f_1011_[__fcnt] == FMT_TEXT) {
        if ($f_1011_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_1_, $f_1011_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpc3:124", $u_1_));
        __fcnt += 3;
      }
      _write_eol ($u_1_);
    }
    else if ((*info_) == 2) {
      $u_2_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:126", $u_2_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1012_[__fcnt] != NULL && $f_1012_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_2_, $f_1012_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc3:126", $u_2_));
        __fcnt += 3;
      }
      if ($f_1012_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_2_].unit, "\n");
        while ($f_1012_[__fcnt] != NULL && $f_1012_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_2_, $f_1012_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc3:126", $u_2_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_2_, $f_1012_[__fcnt + 2], &(*info_), INTEGER, 4);
      _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc3:126", $u_2_));
      __fcnt += 3;
      while ($f_1012_[__fcnt] != NULL && $f_1012_[__fcnt] == FMT_TEXT) {
        if ($f_1012_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_2_, $f_1012_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpc3:126", $u_2_));
        __fcnt += 3;
      }
      _write_eol ($u_2_);
    }
    else if ((*info_) == 3) {
      $u_3_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:128", $u_3_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1013_[__fcnt] != NULL && $f_1013_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_3_, $f_1013_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc3:128", $u_3_));
        __fcnt += 3;
      }
      if ($f_1013_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_3_].unit, "\n");
        while ($f_1013_[__fcnt] != NULL && $f_1013_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_1013_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc3:128", $u_3_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_3_, $f_1013_[__fcnt + 2], &(*info_), INTEGER, 4);
      _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc3:128", $u_3_));
      __fcnt += 3;
      while ($f_1013_[__fcnt] != NULL && $f_1013_[__fcnt] == FMT_TEXT) {
        if ($f_1013_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_3_, $f_1013_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpc3:128", $u_3_));
        __fcnt += 3;
      }
      _write_eol ($u_3_);
    }
    else if ((*info_) == 4) {
      $u_4_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:130", $u_4_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1014_[__fcnt] != NULL && $f_1014_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_4_, $f_1014_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc3:130", $u_4_));
        __fcnt += 3;
      }
      if ($f_1014_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_4_].unit, "\n");
        while ($f_1014_[__fcnt] != NULL && $f_1014_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_4_, $f_1014_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc3:130", $u_4_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_4_, $f_1014_[__fcnt + 2], &(*info_), INTEGER, 4);
      _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc3:130", $u_4_));
      __fcnt += 3;
      while ($f_1014_[__fcnt] != NULL && $f_1014_[__fcnt] == FMT_TEXT) {
        if ($f_1014_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_4_, $f_1014_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpc3:130", $u_4_));
        __fcnt += 3;
      }
      _write_eol ($u_4_);
    }
    else if ((*info_) <= 9) {
      $u_5_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:132", $u_5_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1015_[__fcnt] != NULL && $f_1015_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_5_, $f_1015_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc3:132", $u_5_));
        __fcnt += 3;
      }
      if ($f_1015_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_5_].unit, "\n");
        while ($f_1015_[__fcnt] != NULL && $f_1015_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_5_, $f_1015_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc3:132", $u_5_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_5_, $f_1015_[__fcnt + 2], &(*info_), INTEGER, 4);
      _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc3:132", $u_5_));
      __fcnt += 3;
      while ($f_1015_[__fcnt] != NULL && $f_1015_[__fcnt] == FMT_TEXT) {
        if ($f_1015_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_5_, $f_1015_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpc3:132", $u_5_));
        __fcnt += 3;
      }
      _write_eol ($u_5_);
    }
  }
  else if ((*info_) <= 9999) {
    $u_6_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:138", $u_6_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1020_[__fcnt] != NULL && $f_1020_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_6_, $f_1020_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc3:138", $u_6_));
      __fcnt += 3;
    }
    if ($f_1020_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_6_].unit, "\n");
      while ($f_1020_[__fcnt] != NULL && $f_1020_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_6_, $f_1020_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc3:138", $u_6_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_6_, $f_1020_[__fcnt + 2], &(*info_), INTEGER, 4);
    _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc3:138", $u_6_));
    __fcnt += 3;
    while ($f_1020_[__fcnt] != NULL && $f_1020_[__fcnt] == FMT_TEXT) {
      if ($f_1020_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_6_, $f_1020_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpc3:138", $u_6_));
      __fcnt += 3;
    }
    _write_eol ($u_6_);
    if (d2_ == 1) {
      $u_7_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:139", $u_7_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1021_[__fcnt] != NULL && $f_1021_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_7_, $f_1021_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpc3:139", $u_7_));
        __fcnt += 3;
      }
      _write_eol ($u_7_);
    }
    if (d3_ == 1) {
      $u_8_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:140", $u_8_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1022_[__fcnt] != NULL && $f_1022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_8_, $f_1022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpc3:140", $u_8_));
        __fcnt += 3;
      }
      _write_eol ($u_8_);
    }
    if (d4_ == 1) {
      $u_9_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:141", $u_9_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1023_[__fcnt] != NULL && $f_1023_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_9_, $f_1023_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpc3:141", $u_9_));
        __fcnt += 3;
      }
      _write_eol ($u_9_);
    }
    if (d4_ == 2) {
      $u_10_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:142", $u_10_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1024_[__fcnt] != NULL && $f_1024_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_10_, $f_1024_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_10_, _ioerr_write ("odrpack:dodpc3:142", $u_10_));
        __fcnt += 3;
      }
      _write_eol ($u_10_);
    }
    if (d5_ == 1) {
      $u_11_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:144", $u_11_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1031_[__fcnt] != NULL && $f_1031_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_11_, $f_1031_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpc3:144", $u_11_));
        __fcnt += 3;
      }
      _write_eol ($u_11_);
    }
    else if (d5_ == 2) {
      $u_12_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:146", $u_12_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1032_[__fcnt] != NULL && $f_1032_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_12_, $f_1032_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_12_, _ioerr_write ("odrpack:dodpc3:146", $u_12_));
        __fcnt += 3;
      }
      _write_eol ($u_12_);
    }
    else if (d5_ == 3) {
      $u_13_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:148", $u_13_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1033_[__fcnt] != NULL && $f_1033_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_13_, $f_1033_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_13_, _ioerr_write ("odrpack:dodpc3:148", $u_13_));
        __fcnt += 3;
      }
      _write_eol ($u_13_);
    }
    else if (d5_ == 4) {
      $u_14_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:150", $u_14_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1034_[__fcnt] != NULL && $f_1034_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_14_, $f_1034_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_14_, _ioerr_write ("odrpack:dodpc3:150", $u_14_));
        __fcnt += 3;
      }
      _write_eol ($u_14_);
    }
    else if (d5_ <= 9) {
      $u_15_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:152", $u_15_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1035_[__fcnt] != NULL && $f_1035_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_15_, $f_1035_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpc3:152", $u_15_));
        __fcnt += 3;
      }
      if ($f_1035_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_15_].unit, "\n");
        while ($f_1035_[__fcnt] != NULL && $f_1035_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_15_, $f_1035_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpc3:152", $u_15_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_15_, $f_1035_[__fcnt + 2], &d5_, INTEGER, 4);
      _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpc3:152", $u_15_));
      __fcnt += 3;
      while ($f_1035_[__fcnt] != NULL && $f_1035_[__fcnt] == FMT_TEXT) {
        if ($f_1035_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_15_, $f_1035_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpc3:152", $u_15_));
        __fcnt += 3;
      }
      _write_eol ($u_15_);
    }
  }
  else {
    $u_16_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:158", $u_16_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1040_[__fcnt] != NULL && $f_1040_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_16_, $f_1040_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpc3:158", $u_16_));
      __fcnt += 3;
    }
    if ($f_1040_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_16_].unit, "\n");
      while ($f_1040_[__fcnt] != NULL && $f_1040_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_16_, $f_1040_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpc3:158", $u_16_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_16_, $f_1040_[__fcnt + 2], &(*info_), INTEGER, 4);
    _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpc3:158", $u_16_));
    __fcnt += 3;
    while ($f_1040_[__fcnt] != NULL && $f_1040_[__fcnt] == FMT_TEXT) {
      if ($f_1040_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_16_, $f_1040_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpc3:158", $u_16_));
      __fcnt += 3;
    }
    _write_eol ($u_16_);
    if (d1_ == 5) {
      $u_17_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:160", $u_17_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1042_[__fcnt] != NULL && $f_1042_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_17_, $f_1042_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpc3:160", $u_17_));
        __fcnt += 3;
      }
      _write_eol ($u_17_);
      if (d2_ != 0) {
        $u_18_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:161", $u_18_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1043_[__fcnt] != NULL && $f_1043_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_18_, $f_1043_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpc3:161", $u_18_));
          __fcnt += 3;
        }
        if ($f_1043_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_18_].unit, "\n");
          while ($f_1043_[__fcnt] != NULL && $f_1043_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_18_, $f_1043_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpc3:161", $u_18_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_18_, $f_1043_[__fcnt + 2], &d2_, INTEGER, 4);
        _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpc3:161", $u_18_));
        __fcnt += 3;
        while ($f_1043_[__fcnt] != NULL && $f_1043_[__fcnt] == FMT_TEXT) {
          if ($f_1043_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_18_, $f_1043_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpc3:161", $u_18_));
          __fcnt += 3;
        }
        _write_eol ($u_18_);
      }
      if (d3_ == 3) {
        $u_19_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:163", $u_19_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1044_[__fcnt] != NULL && $f_1044_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_19_, $f_1044_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpc3:163", $u_19_));
          __fcnt += 3;
        }
        if ($f_1044_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_19_].unit, "\n");
          while ($f_1044_[__fcnt] != NULL && $f_1044_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_19_, $f_1044_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpc3:163", $u_19_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_19_, $f_1044_[__fcnt + 2], &d3_, INTEGER, 4);
        _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpc3:163", $u_19_));
        __fcnt += 3;
        while ($f_1044_[__fcnt] != NULL && $f_1044_[__fcnt] == FMT_TEXT) {
          if ($f_1044_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_19_, $f_1044_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpc3:163", $u_19_));
          __fcnt += 3;
        }
        _write_eol ($u_19_);
      }
      else if (d3_ != 0) {
        $u_20_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:165", $u_20_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_1045_[__fcnt] != NULL && $f_1045_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_20_, $f_1045_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpc3:165", $u_20_));
          __fcnt += 3;
        }
        if ($f_1045_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_20_].unit, "\n");
          while ($f_1045_[__fcnt] != NULL && $f_1045_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_20_, $f_1045_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpc3:165", $u_20_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_20_, $f_1045_[__fcnt + 2], &d3_, INTEGER, 4);
        _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpc3:165", $u_20_));
        __fcnt += 3;
        while ($f_1045_[__fcnt] != NULL && $f_1045_[__fcnt] == FMT_TEXT) {
          if ($f_1045_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_20_, $f_1045_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpc3:165", $u_20_));
          __fcnt += 3;
        }
        _write_eol ($u_20_);
      }
    }
    else if (d1_ == 6) {
      $u_21_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:168", $u_21_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1050_[__fcnt] != NULL && $f_1050_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_21_, $f_1050_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_21_, _ioerr_write ("odrpack:dodpc3:168", $u_21_));
        __fcnt += 3;
      }
      _write_eol ($u_21_);
    }
    else {
      $u_22_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:170", $u_22_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1060_[__fcnt] != NULL && $f_1060_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_22_, $f_1060_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpc3:170", $u_22_));
        __fcnt += 3;
      }
      if ($f_1060_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_22_].unit, "\n");
        while ($f_1060_[__fcnt] != NULL && $f_1060_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_22_, $f_1060_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpc3:170", $u_22_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_22_, $f_1060_[__fcnt + 2], &d1_, INTEGER, 4);
      _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpc3:170", $u_22_));
      __fcnt += 3;
      while ($f_1060_[__fcnt] != NULL && $f_1060_[__fcnt] == FMT_TEXT) {
        if ($f_1060_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_22_, $f_1060_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpc3:170", $u_22_));
        __fcnt += 3;
      }
      _write_eol ($u_22_);
    }
  }
  $u_23_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc3:176", $u_23_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_23_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpc3:176", $u_23_));
    __fcnt += 3;
  }
  if ($f_1300_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_23_].unit, "\n");
    while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_23_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpc3:176", $u_23_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_23_, $f_1300_[__fcnt + 2], &(*niter_), INTEGER, 4);
  _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpc3:176", $u_23_));
  __fcnt += 3;
  while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
    if ($f_1300_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_23_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpc3:176", $u_23_));
    __fcnt += 3;
  }
  _write_eol ($u_23_);
  $u_24_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc3:177", $u_24_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1310_[__fcnt] != NULL && $f_1310_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_24_, $f_1310_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc3:177", $u_24_));
    __fcnt += 3;
  }
  if ($f_1310_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_24_].unit, "\n");
    while ($f_1310_[__fcnt] != NULL && $f_1310_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_24_, $f_1310_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc3:177", $u_24_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_24_, $f_1310_[__fcnt + 2], &(*nfev_), INTEGER, 4);
  _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc3:177", $u_24_));
  __fcnt += 3;
  while ($f_1310_[__fcnt] != NULL && $f_1310_[__fcnt] == FMT_TEXT) {
    if ($f_1310_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_24_, $f_1310_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpc3:177", $u_24_));
    __fcnt += 3;
  }
  _write_eol ($u_24_);
  if ((*anajac_)) {
    $u_25_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:178", $u_25_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1320_[__fcnt] != NULL && $f_1320_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_25_, $f_1320_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpc3:178", $u_25_));
      __fcnt += 3;
    }
    if ($f_1320_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_25_].unit, "\n");
      while ($f_1320_[__fcnt] != NULL && $f_1320_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_25_, $f_1320_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpc3:178", $u_25_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_25_, $f_1320_[__fcnt + 2], &(*njev_), INTEGER, 4);
    _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpc3:178", $u_25_));
    __fcnt += 3;
    while ($f_1320_[__fcnt] != NULL && $f_1320_[__fcnt] == FMT_TEXT) {
      if ($f_1320_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_25_, $f_1320_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpc3:178", $u_25_));
      __fcnt += 3;
    }
    _write_eol ($u_25_);
  }
  $u_26_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc3:179", $u_26_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1330_[__fcnt] != NULL && $f_1330_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_26_, $f_1330_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc3:179", $u_26_));
    __fcnt += 3;
  }
  if ($f_1330_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_26_].unit, "\n");
    while ($f_1330_[__fcnt] != NULL && $f_1330_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_26_, $f_1330_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc3:179", $u_26_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_26_, $f_1330_[__fcnt + 2], &(*irank_), INTEGER, 4);
  _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc3:179", $u_26_));
  __fcnt += 3;
  while ($f_1330_[__fcnt] != NULL && $f_1330_[__fcnt] == FMT_TEXT) {
    if ($f_1330_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_26_, $f_1330_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpc3:179", $u_26_));
    __fcnt += 3;
  }
  _write_eol ($u_26_);
  $u_27_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc3:180", $u_27_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1340_[__fcnt] != NULL && $f_1340_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_27_, $f_1340_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpc3:180", $u_27_));
    __fcnt += 3;
  }
  if ($f_1340_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_27_].unit, "\n");
    while ($f_1340_[__fcnt] != NULL && $f_1340_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_27_, $f_1340_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpc3:180", $u_27_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_27_, $f_1340_[__fcnt + 2], &(*rcond_), REAL, 8);
  _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpc3:180", $u_27_));
  __fcnt += 3;
  while ($f_1340_[__fcnt] != NULL && $f_1340_[__fcnt] == FMT_TEXT) {
    if ($f_1340_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_27_, $f_1340_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpc3:180", $u_27_));
    __fcnt += 3;
  }
  _write_eol ($u_27_);
  $u_28_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc3:181", $u_28_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1350_[__fcnt] != NULL && $f_1350_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_28_, $f_1350_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc3:181", $u_28_));
    __fcnt += 3;
  }
  if ($f_1350_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_28_].unit, "\n");
    while ($f_1350_[__fcnt] != NULL && $f_1350_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_28_, $f_1350_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc3:181", $u_28_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_28_, $f_1350_[__fcnt + 2], &(*istop_), INTEGER, 4);
  _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc3:181", $u_28_));
  __fcnt += 3;
  while ($f_1350_[__fcnt] != NULL && $f_1350_[__fcnt] == FMT_TEXT) {
    if ($f_1350_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_28_, $f_1350_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_28_, _ioerr_write ("odrpack:dodpc3:181", $u_28_));
    __fcnt += 3;
  }
  _write_eol ($u_28_);
  if ((*implct_)) {
    $u_29_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:186", $u_29_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_2000_[__fcnt] != NULL && $f_2000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_29_, $f_2000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_29_, _ioerr_write ("odrpack:dodpc3:186", $u_29_));
      __fcnt += 3;
    }
    if ($f_2000_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_29_].unit, "\n");
      while ($f_2000_[__fcnt] != NULL && $f_2000_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_29_, $f_2000_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_29_, _ioerr_write ("odrpack:dodpc3:186", $u_29_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_29_, $f_2000_[__fcnt + 2], &(*wssdel_), REAL, 8);
    _write_err (__rc, $u_29_, _ioerr_write ("odrpack:dodpc3:186", $u_29_));
    __fcnt += 3;
    while ($f_2000_[__fcnt] != NULL && $f_2000_[__fcnt] == FMT_TEXT) {
      if ($f_2000_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_29_, $f_2000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_29_, _ioerr_write ("odrpack:dodpc3:186", $u_29_));
      __fcnt += 3;
    }
    _write_eol ($u_29_);
    if ((*isodr_)) {
      $u_30_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:188", $u_30_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_2010_[__fcnt] != NULL && $f_2010_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
        __fcnt += 3;
      }
      if ($f_2010_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_30_].unit, "\n");
        while ($f_2010_[__fcnt] != NULL && $f_2010_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], &(*wss_), REAL, 8);
      _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
      __fcnt += 3;
      while ($f_2010_[__fcnt] != NULL && $f_2010_[__fcnt] == FMT_TEXT) {
        if ($f_2010_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
        __fcnt += 3;
      }
      if ($f_2010_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_30_].unit, "\n");
        while ($f_2010_[__fcnt] != NULL && $f_2010_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], &(*wsseps_), REAL, 8);
      _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
      __fcnt += 3;
      while ($f_2010_[__fcnt] != NULL && $f_2010_[__fcnt] == FMT_TEXT) {
        if ($f_2010_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
        __fcnt += 3;
      }
      if ($f_2010_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_30_].unit, "\n");
        while ($f_2010_[__fcnt] != NULL && $f_2010_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], &(*pnlty_), REAL, 8);
      _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
      __fcnt += 3;
      while ($f_2010_[__fcnt] != NULL && $f_2010_[__fcnt] == FMT_TEXT) {
        if ($f_2010_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_30_, $f_2010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_30_, _ioerr_write ("odrpack:dodpc3:188", $u_30_));
        __fcnt += 3;
      }
      _write_eol ($u_30_);
    }
  }
  else {
    $u_31_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:191", $u_31_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_2100_[__fcnt] != NULL && $f_2100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_31_, $f_2100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_31_, _ioerr_write ("odrpack:dodpc3:191", $u_31_));
      __fcnt += 3;
    }
    if ($f_2100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_31_].unit, "\n");
      while ($f_2100_[__fcnt] != NULL && $f_2100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_31_, $f_2100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_31_, _ioerr_write ("odrpack:dodpc3:191", $u_31_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_31_, $f_2100_[__fcnt + 2], &(*wss_), REAL, 8);
    _write_err (__rc, $u_31_, _ioerr_write ("odrpack:dodpc3:191", $u_31_));
    __fcnt += 3;
    while ($f_2100_[__fcnt] != NULL && $f_2100_[__fcnt] == FMT_TEXT) {
      if ($f_2100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_31_, $f_2100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_31_, _ioerr_write ("odrpack:dodpc3:191", $u_31_));
      __fcnt += 3;
    }
    _write_eol ($u_31_);
    if ((*isodr_)) {
      $u_32_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:193", $u_32_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_2110_[__fcnt] != NULL && $f_2110_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_32_, $f_2110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_32_, _ioerr_write ("odrpack:dodpc3:193", $u_32_));
        __fcnt += 3;
      }
      if ($f_2110_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_32_].unit, "\n");
        while ($f_2110_[__fcnt] != NULL && $f_2110_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_32_, $f_2110_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_32_, _ioerr_write ("odrpack:dodpc3:193", $u_32_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_32_, $f_2110_[__fcnt + 2], &(*wssdel_), REAL, 8);
      _write_err (__rc, $u_32_, _ioerr_write ("odrpack:dodpc3:193", $u_32_));
      __fcnt += 3;
      while ($f_2110_[__fcnt] != NULL && $f_2110_[__fcnt] == FMT_TEXT) {
        if ($f_2110_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_32_, $f_2110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_32_, _ioerr_write ("odrpack:dodpc3:193", $u_32_));
        __fcnt += 3;
      }
      if ($f_2110_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_32_].unit, "\n");
        while ($f_2110_[__fcnt] != NULL && $f_2110_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_32_, $f_2110_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_32_, _ioerr_write ("odrpack:dodpc3:193", $u_32_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_32_, $f_2110_[__fcnt + 2], &(*wsseps_), REAL, 8);
      _write_err (__rc, $u_32_, _ioerr_write ("odrpack:dodpc3:193", $u_32_));
      __fcnt += 3;
      while ($f_2110_[__fcnt] != NULL && $f_2110_[__fcnt] == FMT_TEXT) {
        if ($f_2110_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_32_, $f_2110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_32_, _ioerr_write ("odrpack:dodpc3:193", $u_32_));
        __fcnt += 3;
      }
      _write_eol ($u_32_);
    }
  }
  if ((*didvcv_)) {
    $u_33_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:197", $u_33_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_2200_[__fcnt] != NULL && $f_2200_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_33_, $f_2200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc3:197", $u_33_));
      __fcnt += 3;
    }
    $34_ = sqrt ((*rvar_));
    if ($f_2200_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_33_].unit, "\n");
      while ($f_2200_[__fcnt] != NULL && $f_2200_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_33_, $f_2200_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc3:197", $u_33_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_33_, $f_2200_[__fcnt + 2], &$34_, REAL, 8);
    _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc3:197", $u_33_));
    __fcnt += 3;
    while ($f_2200_[__fcnt] != NULL && $f_2200_[__fcnt] == FMT_TEXT) {
      if ($f_2200_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_33_, $f_2200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc3:197", $u_33_));
      __fcnt += 3;
    }
    if ($f_2200_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_33_].unit, "\n");
      while ($f_2200_[__fcnt] != NULL && $f_2200_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_33_, $f_2200_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc3:197", $u_33_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_33_, $f_2200_[__fcnt + 2], &(*idf_), INTEGER, 4);
    _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc3:197", $u_33_));
    __fcnt += 3;
    while ($f_2200_[__fcnt] != NULL && $f_2200_[__fcnt] == FMT_TEXT) {
      if ($f_2200_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_33_, $f_2200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_33_, _ioerr_write ("odrpack:dodpc3:197", $u_33_));
      __fcnt += 3;
    }
    _write_eol ($u_33_);
  }
  nplm1_ = 3;
  $u_35_ = (*lunrpt_);
  _fcheck ("odrpack:dodpc3:205", $u_35_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_3000_[__fcnt] != NULL && $f_3000_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_35_, $f_3000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_35_, _ioerr_write ("odrpack:dodpc3:205", $u_35_));
    __fcnt += 3;
  }
  _write_eol ($u_35_);
  if ((*didvcv_)) {
    $u_36_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:207", $u_36_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_7300_[__fcnt] != NULL && $f_7300_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_36_, $f_7300_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_36_, _ioerr_write ("odrpack:dodpc3:207", $u_36_));
      __fcnt += 3;
    }
    _write_eol ($u_36_);
    tval_ = _dppt (($37_ = 0.975, &$37_), idf_);
    for (j_ = 1; j_ <= (*np_); (j_)++) {
      if (ifixb2_[j_ - 1] >= 1) {
        $u_38_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:211", $u_38_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
          __fcnt += 3;
        }
        if ($f_8400_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_38_].unit, "\n");
          while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
        __fcnt += 3;
        while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
          if ($f_8400_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
          __fcnt += 3;
        }
        if ($f_8400_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_38_].unit, "\n");
          while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
        _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
        __fcnt += 3;
        while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
          if ($f_8400_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
          __fcnt += 3;
        }
        if ($f_8400_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_38_].unit, "\n");
          while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], &sdbeta_[j_ - 1], REAL, 8);
        _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
        __fcnt += 3;
        while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
          if ($f_8400_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
          __fcnt += 3;
        }
        $39_ = beta_[j_ - 1] - tval_ * sdbeta_[j_ - 1];
        if ($f_8400_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_38_].unit, "\n");
          while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], &$39_, REAL, 8);
        _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
        __fcnt += 3;
        while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
          if ($f_8400_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
          __fcnt += 3;
        }
        $40_ = beta_[j_ - 1] + tval_ * sdbeta_[j_ - 1];
        if ($f_8400_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_38_].unit, "\n");
          while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], &$40_, REAL, 8);
        _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
        __fcnt += 3;
        while ($f_8400_[__fcnt] != NULL && $f_8400_[__fcnt] == FMT_TEXT) {
          if ($f_8400_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_38_, $f_8400_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_38_, _ioerr_write ("odrpack:dodpc3:211", $u_38_));
          __fcnt += 3;
        }
        _write_eol ($u_38_);
      }
      else if (ifixb2_[j_ - 1] == 0) {
        $u_41_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:215", $u_41_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_41_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc3:215", $u_41_));
          __fcnt += 3;
        }
        if ($f_8600_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_41_].unit, "\n");
          while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_41_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc3:215", $u_41_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_41_, $f_8600_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc3:215", $u_41_));
        __fcnt += 3;
        while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
          if ($f_8600_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_41_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc3:215", $u_41_));
          __fcnt += 3;
        }
        if ($f_8600_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_41_].unit, "\n");
          while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_41_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc3:215", $u_41_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_41_, $f_8600_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
        _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc3:215", $u_41_));
        __fcnt += 3;
        while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
          if ($f_8600_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_41_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_41_, _ioerr_write ("odrpack:dodpc3:215", $u_41_));
          __fcnt += 3;
        }
        _write_eol ($u_41_);
      }
      else {
        $u_42_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:217", $u_42_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_42_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc3:217", $u_42_));
          __fcnt += 3;
        }
        if ($f_8700_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_42_].unit, "\n");
          while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_42_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc3:217", $u_42_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_42_, $f_8700_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc3:217", $u_42_));
        __fcnt += 3;
        while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
          if ($f_8700_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_42_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc3:217", $u_42_));
          __fcnt += 3;
        }
        if ($f_8700_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_42_].unit, "\n");
          while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_42_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc3:217", $u_42_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_42_, $f_8700_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
        _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc3:217", $u_42_));
        __fcnt += 3;
        while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
          if ($f_8700_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_42_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_42_, _ioerr_write ("odrpack:dodpc3:217", $u_42_));
          __fcnt += 3;
        }
        _write_eol ($u_42_);
      }
    }
    if (! ((*redoj_))) {
      $u_43_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:220", $u_43_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_7310_[__fcnt] != NULL && $f_7310_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_43_, $f_7310_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_43_, _ioerr_write ("odrpack:dodpc3:220", $u_43_));
        __fcnt += 3;
      }
      _write_eol ($u_43_);
    }
  }
  else {
    if ((*dovcv_)) {
      if (d1_ <= 5) {
        $u_44_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:224", $u_44_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_7410_[__fcnt] != NULL && $f_7410_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_44_, $f_7410_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_44_, _ioerr_write ("odrpack:dodpc3:224", $u_44_));
          __fcnt += 3;
        }
        _write_eol ($u_44_);
      }
      else {
        $u_45_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:226", $u_45_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_7420_[__fcnt] != NULL && $f_7420_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_45_, $f_7420_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_45_, _ioerr_write ("odrpack:dodpc3:226", $u_45_));
          __fcnt += 3;
        }
        _write_eol ($u_45_);
      }
    }
    if (((*irank_) == 0 && (*npp_) == (*np_)) || (*niter_) == 0) {
      if ((*np_) == 1) {
        $u_46_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:232", $u_46_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_7100_[__fcnt] != NULL && $f_7100_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_46_, $f_7100_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_46_, _ioerr_write ("odrpack:dodpc3:232", $u_46_));
          __fcnt += 3;
        }
        _write_eol ($u_46_);
      }
      else {
        $u_47_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:234", $u_47_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_7200_[__fcnt] != NULL && $f_7200_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_47_, $f_7200_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_47_, _ioerr_write ("odrpack:dodpc3:234", $u_47_));
          __fcnt += 3;
        }
        _write_eol ($u_47_);
      }
      for (j_ = 1; (nplm1_ + 1 > 0 ? j_ <= (*np_) : j_ >= (*np_)); j_ += nplm1_ + 1) {
        k_ = _min (j_ + nplm1_, (*np_));
        if (k_ == j_) {
          $u_48_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:239", $u_48_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_48_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_48_, _ioerr_write ("odrpack:dodpc3:239", $u_48_));
            __fcnt += 3;
          }
          if ($f_8100_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_48_].unit, "\n");
            while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_48_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_48_, _ioerr_write ("odrpack:dodpc3:239", $u_48_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_48_, $f_8100_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, $u_48_, _ioerr_write ("odrpack:dodpc3:239", $u_48_));
          __fcnt += 3;
          while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
            if ($f_8100_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_48_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_48_, _ioerr_write ("odrpack:dodpc3:239", $u_48_));
            __fcnt += 3;
          }
          if ($f_8100_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_48_].unit, "\n");
            while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_48_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_48_, _ioerr_write ("odrpack:dodpc3:239", $u_48_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_48_, $f_8100_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
          _write_err (__rc, $u_48_, _ioerr_write ("odrpack:dodpc3:239", $u_48_));
          __fcnt += 3;
          while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
            if ($f_8100_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_48_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_48_, _ioerr_write ("odrpack:dodpc3:239", $u_48_));
            __fcnt += 3;
          }
          _write_eol ($u_48_);
        }
        else {
          $u_49_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:241", $u_49_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
            __fcnt += 3;
          }
          if ($f_8200_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_49_].unit, "\n");
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
          __fcnt += 3;
          while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
            if ($f_8200_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
            __fcnt += 3;
          }
          if ($f_8200_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_49_].unit, "\n");
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], &k_, INTEGER, 4);
          _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
          __fcnt += 3;
          while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
            if ($f_8200_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
            __fcnt += 3;
          }
          for (l_ = j_; l_ <= k_; l_++) {
            if ($f_8200_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_49_].unit, "\n");
              while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], &beta_[l_ - 1], REAL, 8);
            _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
            __fcnt += 3;
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              if ($f_8200_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_49_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_49_, _ioerr_write ("odrpack:dodpc3:241", $u_49_));
              __fcnt += 3;
            }
          }; // implied DO 
          _write_eol ($u_49_);
        }
      }
      if ((*niter_) >= 1) {
        $u_50_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:245", $u_50_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_8800_[__fcnt] != NULL && $f_8800_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_50_, $f_8800_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_50_, _ioerr_write ("odrpack:dodpc3:245", $u_50_));
          __fcnt += 3;
        }
        _write_eol ($u_50_);
      }
      else {
        $u_51_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:247", $u_51_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_8900_[__fcnt] != NULL && $f_8900_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_51_, $f_8900_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_51_, _ioerr_write ("odrpack:dodpc3:247", $u_51_));
          __fcnt += 3;
        }
        _write_eol ($u_51_);
      }
    }
    else {
      $u_52_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:250", $u_52_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_7500_[__fcnt] != NULL && $f_7500_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_52_, $f_7500_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_52_, _ioerr_write ("odrpack:dodpc3:250", $u_52_));
        __fcnt += 3;
      }
      _write_eol ($u_52_);
      for (j_ = 1; j_ <= (*np_); (j_)++) {
        if (ifixb2_[j_ - 1] >= 1) {
          $u_53_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:253", $u_53_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_8500_[__fcnt] != NULL && $f_8500_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_53_, $f_8500_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_53_, _ioerr_write ("odrpack:dodpc3:253", $u_53_));
            __fcnt += 3;
          }
          if ($f_8500_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_53_].unit, "\n");
            while ($f_8500_[__fcnt] != NULL && $f_8500_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_53_, $f_8500_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_53_, _ioerr_write ("odrpack:dodpc3:253", $u_53_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_53_, $f_8500_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, $u_53_, _ioerr_write ("odrpack:dodpc3:253", $u_53_));
          __fcnt += 3;
          while ($f_8500_[__fcnt] != NULL && $f_8500_[__fcnt] == FMT_TEXT) {
            if ($f_8500_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_53_, $f_8500_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_53_, _ioerr_write ("odrpack:dodpc3:253", $u_53_));
            __fcnt += 3;
          }
          if ($f_8500_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_53_].unit, "\n");
            while ($f_8500_[__fcnt] != NULL && $f_8500_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_53_, $f_8500_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_53_, _ioerr_write ("odrpack:dodpc3:253", $u_53_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_53_, $f_8500_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
          _write_err (__rc, $u_53_, _ioerr_write ("odrpack:dodpc3:253", $u_53_));
          __fcnt += 3;
          while ($f_8500_[__fcnt] != NULL && $f_8500_[__fcnt] == FMT_TEXT) {
            if ($f_8500_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_53_, $f_8500_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_53_, _ioerr_write ("odrpack:dodpc3:253", $u_53_));
            __fcnt += 3;
          }
          _write_eol ($u_53_);
        }
        else if (ifixb2_[j_ - 1] == 0) {
          $u_54_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:255", $u_54_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_54_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_54_, _ioerr_write ("odrpack:dodpc3:255", $u_54_));
            __fcnt += 3;
          }
          if ($f_8600_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_54_].unit, "\n");
            while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_54_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_54_, _ioerr_write ("odrpack:dodpc3:255", $u_54_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_54_, $f_8600_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, $u_54_, _ioerr_write ("odrpack:dodpc3:255", $u_54_));
          __fcnt += 3;
          while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
            if ($f_8600_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_54_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_54_, _ioerr_write ("odrpack:dodpc3:255", $u_54_));
            __fcnt += 3;
          }
          if ($f_8600_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_54_].unit, "\n");
            while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_54_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_54_, _ioerr_write ("odrpack:dodpc3:255", $u_54_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_54_, $f_8600_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
          _write_err (__rc, $u_54_, _ioerr_write ("odrpack:dodpc3:255", $u_54_));
          __fcnt += 3;
          while ($f_8600_[__fcnt] != NULL && $f_8600_[__fcnt] == FMT_TEXT) {
            if ($f_8600_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_54_, $f_8600_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_54_, _ioerr_write ("odrpack:dodpc3:255", $u_54_));
            __fcnt += 3;
          }
          _write_eol ($u_54_);
        }
        else {
          $u_55_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:257", $u_55_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_55_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_55_, _ioerr_write ("odrpack:dodpc3:257", $u_55_));
            __fcnt += 3;
          }
          if ($f_8700_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_55_].unit, "\n");
            while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_55_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_55_, _ioerr_write ("odrpack:dodpc3:257", $u_55_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_55_, $f_8700_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, $u_55_, _ioerr_write ("odrpack:dodpc3:257", $u_55_));
          __fcnt += 3;
          while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
            if ($f_8700_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_55_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_55_, _ioerr_write ("odrpack:dodpc3:257", $u_55_));
            __fcnt += 3;
          }
          if ($f_8700_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_55_].unit, "\n");
            while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_55_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_55_, _ioerr_write ("odrpack:dodpc3:257", $u_55_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_55_, $f_8700_[__fcnt + 2], &beta_[j_ - 1], REAL, 8);
          _write_err (__rc, $u_55_, _ioerr_write ("odrpack:dodpc3:257", $u_55_));
          __fcnt += 3;
          while ($f_8700_[__fcnt] != NULL && $f_8700_[__fcnt] == FMT_TEXT) {
            if ($f_8700_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_55_, $f_8700_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_55_, _ioerr_write ("odrpack:dodpc3:257", $u_55_));
            __fcnt += 3;
          }
          _write_eol ($u_55_);
        }
      }
    }
  }
  if ((*ipr_) == 1) {
    goto _l0;
  }
  if ((*implct_) && ((*m_) <= 4)) {
    $u_56_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:270", $u_56_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_4100_[__fcnt] != NULL && $f_4100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_56_, $f_4100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_56_, _ioerr_write ("odrpack:dodpc3:270", $u_56_));
      __fcnt += 3;
    }
    _write_eol ($u_56_);
    _ffile[0].buff = _ffile[0].rewind = (char *) (fmt1_);
    _ffile[0].lrecl = 127;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (fmt1_, 127, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("odrpack:dodpc3:271", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_9110_[__fcnt] != NULL && $f_9110_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_9110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:271", 0));
      __fcnt += 3;
    }
    if ($f_9110_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_9110_[__fcnt] != NULL && $f_9110_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_9110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:271", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_9110_[__fcnt + 2], &(*m_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:271", 0));
    __fcnt += 3;
    while ($f_9110_[__fcnt] != NULL && $f_9110_[__fcnt] == FMT_TEXT) {
      if ($f_9110_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_9110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:271", 0));
      __fcnt += 3;
    }
    $u_57_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:272", $u_57_, action_write, form_formatted);
    __fcnt = 0;
    __fmt_a = _vif_jit ("odrpack:dodpc3:272", fmt1_);
    while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_57_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_57_, _ioerr_write ("odrpack:dodpc3:272", $u_57_));
      __fcnt += 3;
    }
    for (j_ = 1; j_ <= (*m_); j_++) {
      if (__fmt_a[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_57_].unit, "\n");
        while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_57_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_57_, _ioerr_write ("odrpack:dodpc3:272", $u_57_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_57_, __fmt_a[__fcnt + 2], &j_, INTEGER, 4);
      _write_err (__rc, $u_57_, _ioerr_write ("odrpack:dodpc3:272", $u_57_));
      __fcnt += 3;
      while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
        if (__fmt_a[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_57_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_57_, _ioerr_write ("odrpack:dodpc3:272", $u_57_));
        __fcnt += 3;
      }
    }; // implied DO 
    _write_eol ($u_57_);
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      $u_58_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:274", $u_58_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_58_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_58_, _ioerr_write ("odrpack:dodpc3:274", $u_58_));
        __fcnt += 3;
      }
      if ($f_4130_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_58_].unit, "\n");
        while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_58_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_58_, _ioerr_write ("odrpack:dodpc3:274", $u_58_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_58_, $f_4130_[__fcnt + 2], &i_, INTEGER, 4);
      _write_err (__rc, $u_58_, _ioerr_write ("odrpack:dodpc3:274", $u_58_));
      __fcnt += 3;
      while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
        if ($f_4130_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_58_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_58_, _ioerr_write ("odrpack:dodpc3:274", $u_58_));
        __fcnt += 3;
      }
      for (j_ = 1; j_ <= (*m_); j_++) {
        if ($f_4130_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_58_].unit, "\n");
          while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_58_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_58_, _ioerr_write ("odrpack:dodpc3:274", $u_58_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_58_, $f_4130_[__fcnt + 2], &delta_[i_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
        _write_err (__rc, $u_58_, _ioerr_write ("odrpack:dodpc3:274", $u_58_));
        __fcnt += 3;
        while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
          if ($f_4130_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_58_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_58_, _ioerr_write ("odrpack:dodpc3:274", $u_58_));
          __fcnt += 3;
        }
      }; // implied DO 
      _write_eol ($u_58_);
    }
  }
  else if ((*isodr_) && ((*nq_) + (*m_) <= 4)) {
    $u_59_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:278", $u_59_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_4110_[__fcnt] != NULL && $f_4110_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_59_, $f_4110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_59_, _ioerr_write ("odrpack:dodpc3:278", $u_59_));
      __fcnt += 3;
    }
    _write_eol ($u_59_);
    _ffile[0].buff = _ffile[0].rewind = (char *) (fmt1_);
    _ffile[0].lrecl = 127;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (fmt1_, 127, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("odrpack:dodpc3:279", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_9120_[__fcnt] != NULL && $f_9120_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_9120_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:279", 0));
      __fcnt += 3;
    }
    if ($f_9120_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_9120_[__fcnt] != NULL && $f_9120_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_9120_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:279", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_9120_[__fcnt + 2], &(*nq_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:279", 0));
    __fcnt += 3;
    while ($f_9120_[__fcnt] != NULL && $f_9120_[__fcnt] == FMT_TEXT) {
      if ($f_9120_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_9120_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:279", 0));
      __fcnt += 3;
    }
    if ($f_9120_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_9120_[__fcnt] != NULL && $f_9120_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_9120_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:279", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_9120_[__fcnt + 2], &(*m_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:279", 0));
    __fcnt += 3;
    while ($f_9120_[__fcnt] != NULL && $f_9120_[__fcnt] == FMT_TEXT) {
      if ($f_9120_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_9120_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:279", 0));
      __fcnt += 3;
    }
    $u_60_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:280", $u_60_, action_write, form_formatted);
    __fcnt = 0;
    __fmt_a = _vif_jit ("odrpack:dodpc3:280", fmt1_);
    while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_60_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_60_, _ioerr_write ("odrpack:dodpc3:280", $u_60_));
      __fcnt += 3;
    }
    for (l_ = 1; l_ <= (*nq_); l_++) {
      if (__fmt_a[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_60_].unit, "\n");
        while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_60_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_60_, _ioerr_write ("odrpack:dodpc3:280", $u_60_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_60_, __fmt_a[__fcnt + 2], &l_, INTEGER, 4);
      _write_err (__rc, $u_60_, _ioerr_write ("odrpack:dodpc3:280", $u_60_));
      __fcnt += 3;
      while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
        if (__fmt_a[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_60_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_60_, _ioerr_write ("odrpack:dodpc3:280", $u_60_));
        __fcnt += 3;
      }
    }; // implied DO 
    for (j_ = 1; j_ <= (*m_); j_++) {
      if (__fmt_a[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_60_].unit, "\n");
        while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_60_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_60_, _ioerr_write ("odrpack:dodpc3:280", $u_60_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_60_, __fmt_a[__fcnt + 2], &j_, INTEGER, 4);
      _write_err (__rc, $u_60_, _ioerr_write ("odrpack:dodpc3:280", $u_60_));
      __fcnt += 3;
      while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
        if (__fmt_a[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_60_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_60_, _ioerr_write ("odrpack:dodpc3:280", $u_60_));
        __fcnt += 3;
      }
    }; // implied DO 
    _write_eol ($u_60_);
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      $u_61_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:282", $u_61_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
        __fcnt += 3;
      }
      if ($f_4130_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_61_].unit, "\n");
        while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], &i_, INTEGER, 4);
      _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
      __fcnt += 3;
      while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
        if ($f_4130_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
        __fcnt += 3;
      }
      for (l_ = 1; l_ <= (*nq_); l_++) {
        if ($f_4130_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_61_].unit, "\n");
          while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], &f_[i_ - 1 + ((*n_)) * ((l_ - 1))], REAL, 8);
        _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
        __fcnt += 3;
        while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
          if ($f_4130_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
          __fcnt += 3;
        }
      }; // implied DO 
      for (j_ = 1; j_ <= (*m_); j_++) {
        if ($f_4130_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_61_].unit, "\n");
          while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], &delta_[i_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
        _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
        __fcnt += 3;
        while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
          if ($f_4130_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_61_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_61_, _ioerr_write ("odrpack:dodpc3:282", $u_61_));
          __fcnt += 3;
        }
      }; // implied DO 
      _write_eol ($u_61_);
    }
  }
  else if (! ((*isodr_)) && (((*nq_) >= 2) && ((*nq_) <= 4))) {
    $u_62_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:286", $u_62_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_4120_[__fcnt] != NULL && $f_4120_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_62_, $f_4120_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_62_, _ioerr_write ("odrpack:dodpc3:286", $u_62_));
      __fcnt += 3;
    }
    _write_eol ($u_62_);
    _ffile[0].buff = _ffile[0].rewind = (char *) (fmt1_);
    _ffile[0].lrecl = 127;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (fmt1_, 127, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("odrpack:dodpc3:287", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_9130_[__fcnt] != NULL && $f_9130_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_9130_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:287", 0));
      __fcnt += 3;
    }
    if ($f_9130_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_9130_[__fcnt] != NULL && $f_9130_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_9130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:287", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_9130_[__fcnt + 2], &(*nq_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:287", 0));
    __fcnt += 3;
    while ($f_9130_[__fcnt] != NULL && $f_9130_[__fcnt] == FMT_TEXT) {
      if ($f_9130_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_9130_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("odrpack:dodpc3:287", 0));
      __fcnt += 3;
    }
    $u_63_ = (*lunrpt_);
    _fcheck ("odrpack:dodpc3:288", $u_63_, action_write, form_formatted);
    __fcnt = 0;
    __fmt_a = _vif_jit ("odrpack:dodpc3:288", fmt1_);
    while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_63_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_63_, _ioerr_write ("odrpack:dodpc3:288", $u_63_));
      __fcnt += 3;
    }
    for (l_ = 1; l_ <= (*nq_); l_++) {
      if (__fmt_a[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_63_].unit, "\n");
        while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_63_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_63_, _ioerr_write ("odrpack:dodpc3:288", $u_63_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_63_, __fmt_a[__fcnt + 2], &l_, INTEGER, 4);
      _write_err (__rc, $u_63_, _ioerr_write ("odrpack:dodpc3:288", $u_63_));
      __fcnt += 3;
      while (__fmt_a[__fcnt] != NULL && __fmt_a[__fcnt] == FMT_TEXT) {
        if (__fmt_a[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_63_, __fmt_a[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_63_, _ioerr_write ("odrpack:dodpc3:288", $u_63_));
        __fcnt += 3;
      }
    }; // implied DO 
    _write_eol ($u_63_);
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      $u_64_ = (*lunrpt_);
      _fcheck ("odrpack:dodpc3:290", $u_64_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_64_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_64_, _ioerr_write ("odrpack:dodpc3:290", $u_64_));
        __fcnt += 3;
      }
      if ($f_4130_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_64_].unit, "\n");
        while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_64_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_64_, _ioerr_write ("odrpack:dodpc3:290", $u_64_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_64_, $f_4130_[__fcnt + 2], &i_, INTEGER, 4);
      _write_err (__rc, $u_64_, _ioerr_write ("odrpack:dodpc3:290", $u_64_));
      __fcnt += 3;
      while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
        if ($f_4130_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_64_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_64_, _ioerr_write ("odrpack:dodpc3:290", $u_64_));
        __fcnt += 3;
      }
      for (l_ = 1; l_ <= (*nq_); l_++) {
        if ($f_4130_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_64_].unit, "\n");
          while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_64_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_64_, _ioerr_write ("odrpack:dodpc3:290", $u_64_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_64_, $f_4130_[__fcnt + 2], &f_[i_ - 1 + ((*n_)) * ((l_ - 1))], REAL, 8);
        _write_err (__rc, $u_64_, _ioerr_write ("odrpack:dodpc3:290", $u_64_));
        __fcnt += 3;
        while ($f_4130_[__fcnt] != NULL && $f_4130_[__fcnt] == FMT_TEXT) {
          if ($f_4130_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_64_, $f_4130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_64_, _ioerr_write ("odrpack:dodpc3:290", $u_64_));
          __fcnt += 3;
        }
      }; // implied DO 
      _write_eol ($u_64_);
    }
  }
  else {
    if (! ((*implct_))) {
      for (j_ = 1; j_ <= (*nq_); (j_)++) {
        $u_65_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:301", $u_65_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_65_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_65_, _ioerr_write ("odrpack:dodpc3:301", $u_65_));
          __fcnt += 3;
        }
        if ($f_4200_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_65_].unit, "\n");
          while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_65_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_65_, _ioerr_write ("odrpack:dodpc3:301", $u_65_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_65_, $f_4200_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, $u_65_, _ioerr_write ("odrpack:dodpc3:301", $u_65_));
        __fcnt += 3;
        while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
          if ($f_4200_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_65_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_65_, _ioerr_write ("odrpack:dodpc3:301", $u_65_));
          __fcnt += 3;
        }
        _write_eol ($u_65_);
        if ((*n_) == 1) {
          $u_66_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:303", $u_66_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_7100_[__fcnt] != NULL && $f_7100_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_66_, $f_7100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_66_, _ioerr_write ("odrpack:dodpc3:303", $u_66_));
            __fcnt += 3;
          }
          _write_eol ($u_66_);
        }
        else {
          $u_67_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:305", $u_67_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_7200_[__fcnt] != NULL && $f_7200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_67_, $f_7200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_67_, _ioerr_write ("odrpack:dodpc3:305", $u_67_));
            __fcnt += 3;
          }
          _write_eol ($u_67_);
        }
        for (i_ = 1; (nplm1_ + 1 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += nplm1_ + 1) {
          k_ = _min (i_ + nplm1_, (*n_));
          if (i_ == k_) {
            $u_68_ = (*lunrpt_);
            _fcheck ("odrpack:dodpc3:310", $u_68_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_68_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_68_, _ioerr_write ("odrpack:dodpc3:310", $u_68_));
              __fcnt += 3;
            }
            if ($f_8100_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_68_].unit, "\n");
              while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_68_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_68_, _ioerr_write ("odrpack:dodpc3:310", $u_68_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_68_, $f_8100_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_68_, _ioerr_write ("odrpack:dodpc3:310", $u_68_));
            __fcnt += 3;
            while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
              if ($f_8100_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_68_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_68_, _ioerr_write ("odrpack:dodpc3:310", $u_68_));
              __fcnt += 3;
            }
            if ($f_8100_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_68_].unit, "\n");
              while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_68_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_68_, _ioerr_write ("odrpack:dodpc3:310", $u_68_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_68_, $f_8100_[__fcnt + 2], &f_[i_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_68_, _ioerr_write ("odrpack:dodpc3:310", $u_68_));
            __fcnt += 3;
            while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
              if ($f_8100_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_68_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_68_, _ioerr_write ("odrpack:dodpc3:310", $u_68_));
              __fcnt += 3;
            }
            _write_eol ($u_68_);
          }
          else {
            $u_69_ = (*lunrpt_);
            _fcheck ("odrpack:dodpc3:312", $u_69_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
              __fcnt += 3;
            }
            if ($f_8200_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_69_].unit, "\n");
              while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
            __fcnt += 3;
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              if ($f_8200_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
              __fcnt += 3;
            }
            if ($f_8200_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_69_].unit, "\n");
              while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], &k_, INTEGER, 4);
            _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
            __fcnt += 3;
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              if ($f_8200_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
              __fcnt += 3;
            }
            for (l_ = i_; l_ <= k_; l_++) {
              if ($f_8200_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_69_].unit, "\n");
                while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], &f_[l_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
              __fcnt += 3;
              while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                if ($f_8200_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_69_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_69_, _ioerr_write ("odrpack:dodpc3:312", $u_69_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_69_);
          }
        }
      }
    }
    if ((*isodr_)) {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        $u_70_ = (*lunrpt_);
        _fcheck ("odrpack:dodpc3:322", $u_70_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_70_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_70_, _ioerr_write ("odrpack:dodpc3:322", $u_70_));
          __fcnt += 3;
        }
        if ($f_4300_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_70_].unit, "\n");
          while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_70_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_70_, _ioerr_write ("odrpack:dodpc3:322", $u_70_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_70_, $f_4300_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, $u_70_, _ioerr_write ("odrpack:dodpc3:322", $u_70_));
        __fcnt += 3;
        while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
          if ($f_4300_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_70_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_70_, _ioerr_write ("odrpack:dodpc3:322", $u_70_));
          __fcnt += 3;
        }
        _write_eol ($u_70_);
        if ((*n_) == 1) {
          $u_71_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:324", $u_71_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_7100_[__fcnt] != NULL && $f_7100_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_71_, $f_7100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_71_, _ioerr_write ("odrpack:dodpc3:324", $u_71_));
            __fcnt += 3;
          }
          _write_eol ($u_71_);
        }
        else {
          $u_72_ = (*lunrpt_);
          _fcheck ("odrpack:dodpc3:326", $u_72_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_7200_[__fcnt] != NULL && $f_7200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_72_, $f_7200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_72_, _ioerr_write ("odrpack:dodpc3:326", $u_72_));
            __fcnt += 3;
          }
          _write_eol ($u_72_);
        }
        for (i_ = 1; (nplm1_ + 1 > 0 ? i_ <= (*n_) : i_ >= (*n_)); i_ += nplm1_ + 1) {
          k_ = _min (i_ + nplm1_, (*n_));
          if (i_ == k_) {
            $u_73_ = (*lunrpt_);
            _fcheck ("odrpack:dodpc3:331", $u_73_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_73_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_73_, _ioerr_write ("odrpack:dodpc3:331", $u_73_));
              __fcnt += 3;
            }
            if ($f_8100_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_73_].unit, "\n");
              while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_73_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_73_, _ioerr_write ("odrpack:dodpc3:331", $u_73_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_73_, $f_8100_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_73_, _ioerr_write ("odrpack:dodpc3:331", $u_73_));
            __fcnt += 3;
            while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
              if ($f_8100_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_73_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_73_, _ioerr_write ("odrpack:dodpc3:331", $u_73_));
              __fcnt += 3;
            }
            if ($f_8100_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_73_].unit, "\n");
              while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_73_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_73_, _ioerr_write ("odrpack:dodpc3:331", $u_73_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_73_, $f_8100_[__fcnt + 2], &delta_[i_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
            _write_err (__rc, $u_73_, _ioerr_write ("odrpack:dodpc3:331", $u_73_));
            __fcnt += 3;
            while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
              if ($f_8100_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_73_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_73_, _ioerr_write ("odrpack:dodpc3:331", $u_73_));
              __fcnt += 3;
            }
            _write_eol ($u_73_);
          }
          else {
            $u_74_ = (*lunrpt_);
            _fcheck ("odrpack:dodpc3:333", $u_74_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
              __fcnt += 3;
            }
            if ($f_8200_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_74_].unit, "\n");
              while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], &i_, INTEGER, 4);
            _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
            __fcnt += 3;
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              if ($f_8200_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
              __fcnt += 3;
            }
            if ($f_8200_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[$u_74_].unit, "\n");
              while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], &k_, INTEGER, 4);
            _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
            __fcnt += 3;
            while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
              if ($f_8200_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
              __fcnt += 3;
            }
            for (l_ = i_; l_ <= k_; l_++) {
              if ($f_8200_[__fcnt] == NULL) {
                __fcnt = 0;
                __rc = fprintf (_ffile[$u_74_].unit, "\n");
                while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                  __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                  _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
                  __fcnt += 3;
                }
              };
              __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], &delta_[l_ - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
              _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
              __fcnt += 3;
              while ($f_8200_[__fcnt] != NULL && $f_8200_[__fcnt] == FMT_TEXT) {
                if ($f_8200_[__fcnt + 2] == FMT_TERM) {
                  break;
                }
                __rc = _vif_printf ($u_74_, $f_8200_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, $u_74_, _ioerr_write ("odrpack:dodpc3:333", $u_74_));
                __fcnt += 3;
              }
            }; // implied DO 
            _write_eol ($u_74_);
          }
        }
      }
    }
  }
  goto _l0;
  _l1000:;
  _l1011:;
  _l1012:;
  _l1013:;
  _l1014:;
  _l1015:;
  _l1020:;
  _l1021:;
  _l1022:;
  _l1023:;
  _l1024:;
  _l1031:;
  _l1032:;
  _l1033:;
  _l1034:;
  _l1035:;
  _l1040:;
  _l1042:;
  _l1043:;
  _l1044:;
  _l1045:;
  _l1050:;
  _l1060:;
  _l1300:;
  _l1310:;
  _l1320:;
  _l1330:;
  _l1340:;
  _l1350:;
  _l2000:;
  _l2010:;
  _l2100:;
  _l2110:;
  _l2200:;
  _l3000:;
  _l4100:;
  _l4110:;
  _l4120:;
  _l4130:;
  _l4200:;
  _l4300:;
  _l7100:;
  _l7200:;
  _l7300:;
  _l7310:;
  _l7410:;
  _l7420:;
  _l7500:;
  _l8100:;
  _l8200:;
  _l8400:;
  _l8500:;
  _l8600:;
  _l8700:;
  _l8800:;
  _l8900:;
  _l9110:;
  _l9120:;
  _l9130:;
  _l0:;
  __calls[28].calls++;
  return 0;
}

int_4 _dodpcr (int_4 _p_ ipr_, int_4 _p_ lunrpt_, logical_4 _p_ head_, logical_4 _p_ prtpen_, logical_4 _p_ fstitr_, 
logical_4 _p_ didvcv_, int_4 _p_ iflag_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, 
int_4 _p_ nnzw_, int_4 _p_ msgb_, int_4 _p_ msgd_, real_8 _p_ beta_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ x_, 
int_4 _p_ ldx_, real_8 _p_ delta_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, int_4 _p_ ldwd_, 
int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, real_8 _p_ ssf_, real_8 _p_ tt_, int_4 _p_ 
ldtt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, int_4 _p_ job_, int_4 _p_ neta_, real_8 _p_ taufac_, 
real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, real_8 _p_ wss_, real_8 _p_ rvar_, int_4 _p_ idf_, real_8 _p_ 
sdbeta_, int_4 _p_ niter_, int_4 _p_ nfev_, int_4 _p_ njev_, real_8 _p_ actred_, real_8 _p_ prered_, real_8 _p_ tau_, 
real_8 _p_ pnorm_, real_8 _p_ alpha_, real_8 _p_ f_, real_8 _p_ rcond_, int_4 _p_ irank_, int_4 _p_ info_, int_4 _p_ 
istop_)
{
  static logical_4 anajac_, cdjac_, chkjac_, dovcv_, implct_, initd_, isodr_, redoj_, restrt_;
  static real_8 pnlty_;
  static char_3 typ_;
  int_4 $u_0_, __fcnt, __rc, $u_1_, $u_2_;
  static FORMAT $f_1200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_247, _dc_247,
    FMT_CHAR,"%3s","%-3s",
    FMT_TEXT, _dc_248, _dc_248,
    NULL, NULL, NULL
  };
  static FORMAT $f_1300_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_249, _dc_249,
    FMT_CHAR,"%3s","%-3s",
    FMT_TEXT, _dc_248, _dc_248,
    NULL, NULL, NULL
  };
  static FORMAT $f_1400_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_250, _dc_250,
    FMT_CHAR,"%3s","%-3s",
    FMT_TEXT, _dc_248, _dc_248,
    NULL, NULL, NULL
  };
  (void) _dflags (job_, &restrt_, &initd_, &dovcv_, &redoj_, &anajac_, &cdjac_, &chkjac_, &isodr_, &implct_);
  pnlty_ = _abs (we_[0 + ((*ldwe_)) * ((0) + ((*ld2we_)) * ((0)))]);
  if ((*head_)) {
    (void) _dodphd (head_, lunrpt_);
  }
  if (isodr_) {
    bufcpy (typ_, _dc_245, 3);
  }
  else {
    bufcpy (typ_, _dc_246, 3);
  }
  if ((*iflag_) == 1) {
    $u_0_ = (*lunrpt_);
    _fcheck ("odrpack:dodpcr:173", $u_0_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpcr:173", $u_0_));
      __fcnt += 3;
    }
    if ($f_1200_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_0_].unit, "\n");
      while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_0_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpcr:173", $u_0_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_0_, $f_1200_[__fcnt + 2], typ_, CHARACTER, 3);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpcr:173", $u_0_));
    __fcnt += 3;
    while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
      if ($f_1200_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_0_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpcr:173", $u_0_));
      __fcnt += 3;
    }
    _write_eol ($u_0_);
    (void) _dodpc1 (ipr_, lunrpt_, &anajac_, &cdjac_, &chkjac_, &initd_, &restrt_, &isodr_, &implct_, &dovcv_, &redoj_, 
    &msgb_[0], &msgb_[1], &msgd_[0], &msgd_[1], n_, m_, np_, nq_, npp_, nnzw_, x_, ldx_, ifixx_, ldifx_, delta_, wd_, 
    ldwd_, ld2wd_, tt_, ldtt_, stpd_, ldstpd_, y_, ldy_, we_, ldwe_, ld2we_, &pnlty_, beta_, ifixb_, ssf_, stpb_, job_, 
    neta_, taufac_, sstol_, partol_, maxit_, &wss_[0], &wss_[1], &wss_[2]);
  }
  else if ((*iflag_) == 2) {
    if ((*fstitr_)) {
      $u_1_ = (*lunrpt_);
      _fcheck ("odrpack:dodpcr:190", $u_1_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_1_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpcr:190", $u_1_));
        __fcnt += 3;
      }
      if ($f_1300_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[$u_1_].unit, "\n");
        while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_1_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpcr:190", $u_1_));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf ($u_1_, $f_1300_[__fcnt + 2], typ_, CHARACTER, 3);
      _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpcr:190", $u_1_));
      __fcnt += 3;
      while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
        if ($f_1300_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf ($u_1_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpcr:190", $u_1_));
        __fcnt += 3;
      }
      _write_eol ($u_1_);
    }
    (void) _dodpc2 (ipr_, lunrpt_, fstitr_, &implct_, prtpen_, &pnlty_, niter_, nfev_, &wss_[0], actred_, prered_, alpha_, 
    tau_, pnorm_, np_, beta_);
  }
  else if ((*iflag_) == 3) {
    $u_2_ = (*lunrpt_);
    _fcheck ("odrpack:dodpcr:201", $u_2_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_2_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpcr:201", $u_2_));
      __fcnt += 3;
    }
    if ($f_1400_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_2_].unit, "\n");
      while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_2_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpcr:201", $u_2_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_2_, $f_1400_[__fcnt + 2], typ_, CHARACTER, 3);
    _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpcr:201", $u_2_));
    __fcnt += 3;
    while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
      if ($f_1400_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_2_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpcr:201", $u_2_));
      __fcnt += 3;
    }
    _write_eol ($u_2_);
    (void) _dodpc3 (ipr_, lunrpt_, &isodr_, &implct_, didvcv_, &dovcv_, &redoj_, &anajac_, n_, m_, np_, nq_, npp_, info_, 
    niter_, nfev_, njev_, irank_, rcond_, istop_, &wss_[0], &wss_[1], &wss_[2], &pnlty_, rvar_, idf_, beta_, sdbeta_, 
    ifixb_, f_, delta_);
  }
  goto _l0;
  _l1200:;
  _l1300:;
  _l1400:;
  _l0:;
  __calls[29].calls++;
  return 0;
}

int_4 _dodpe1 (int_4 _p_ fileno_, int_4 _p_ d1_, int_4 _p_ d2_, int_4 _p_ d3_, int_4 _p_ d4_, int_4 _p_ d5_, int_4 _p_ 
n_, int_4 _p_ m_, int_4 _p_ nq_, int_4 _p_ ldscld_, int_4 _p_ ldstpd_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, int_4 _p_ 
ldwd_, int_4 _p_ ld2wd_, int_4 _p_ lwkmn_, int_4 _p_ liwkmn_)
{
  int_4 $u_0_, __fcnt, __rc, $u_1_, $u_2_, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_, $u_10_, $u_11_, $u_12_, 
  $u_13_, $u_14_, $u_15_, $u_16_, $u_17_, $u_18_, $u_19_, $u_20_, $u_21_, $u_22_, $u_23_, $u_24_, $u_25_, $u_26_, $u_27_
  ;
  static FORMAT $f_1100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_251, _dc_251,
    NULL, NULL, NULL
  };
  static FORMAT $f_1200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_252, _dc_252,
    NULL, NULL, NULL
  };
  static FORMAT $f_1300_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_253, _dc_253,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_254, _dc_254,
    NULL, NULL, NULL
  };
  static FORMAT $f_1400_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_255, _dc_255,
    NULL, NULL, NULL
  };
  static FORMAT $f_2110_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_256, _dc_256,
    NULL, NULL, NULL
  };
  static FORMAT $f_2120_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_257, _dc_257,
    NULL, NULL, NULL
  };
  static FORMAT $f_2210_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_258, _dc_258,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_259, _dc_259,
    NULL, NULL, NULL
  };
  static FORMAT $f_2220_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_260, _dc_260,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_261, _dc_261,
    NULL, NULL, NULL
  };
  static FORMAT $f_2230_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_262, _dc_262,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_263, _dc_263,
    NULL, NULL, NULL
  };
  static FORMAT $f_2310_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_264, _dc_264,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_265, _dc_265,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_266, _dc_266,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_267, _dc_267,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_268, _dc_268,
    NULL, NULL, NULL
  };
  static FORMAT $f_2320_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_269, _dc_269,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_270, _dc_270,
    NULL, NULL, NULL
  };
  static FORMAT $f_2410_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_271, _dc_271,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_272, _dc_272,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_273, _dc_273,
    NULL, NULL, NULL
  };
  static FORMAT $f_2420_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_274, _dc_274,
    FMT_INT,"%7d","%7d",
    FMT_TEXT, _dc_272, _dc_272,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_275, _dc_275,
    FMT_TEXT, _dc_276, _dc_276,
    NULL, NULL, NULL
  };
  static FORMAT $f_3110_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_277, _dc_277,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_278, _dc_278,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_279, _dc_279,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_280, _dc_280,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_281, _dc_281,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_282, _dc_282,
    NULL, NULL, NULL
  };
  static FORMAT $f_3120_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_283, _dc_283,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_284, _dc_284,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_279, _dc_279,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_285, _dc_285,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_286, _dc_286,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_282, _dc_282,
    NULL, NULL, NULL
  };
  static FORMAT $f_3130_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_287, _dc_287,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_288, _dc_288,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_289, _dc_289,
    FMT_TEXT, _dc_290, _dc_290,
    NULL, NULL, NULL
  };
  static FORMAT $f_3210_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_291, _dc_291,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_278, _dc_278,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_292, _dc_292,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_293, _dc_293,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_281, _dc_281,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_294, _dc_294,
    NULL, NULL, NULL
  };
  static FORMAT $f_3220_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_295, _dc_295,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_284, _dc_284,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_292, _dc_292,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_296, _dc_296,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_286, _dc_286,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_294, _dc_294,
    NULL, NULL, NULL
  };
  static FORMAT $f_3230_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_297, _dc_297,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_288, _dc_288,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_289, _dc_289,
    FMT_TEXT, _dc_298, _dc_298,
    NULL, NULL, NULL
  };
  static FORMAT $f_3310_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_299, _dc_299,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_300, _dc_300,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_301, _dc_301,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_302, _dc_302,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_303, _dc_303,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_304, _dc_304,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_305, _dc_305,
    NULL, NULL, NULL
  };
  static FORMAT $f_3320_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_306, _dc_306,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_307, _dc_307,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_308, _dc_308,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_309, _dc_309,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_310, _dc_310,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_311, _dc_311,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_312, _dc_312,
    NULL, NULL, NULL
  };
  static FORMAT $f_3410_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_313, _dc_313,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_314, _dc_314,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_315, _dc_315,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_316, _dc_316,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_317, _dc_317,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_318, _dc_318,
    NULL, NULL, NULL
  };
  static FORMAT $f_3420_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_319, _dc_319,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_320, _dc_320,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_321, _dc_321,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_322, _dc_322,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_323, _dc_323,
    NULL, NULL, NULL
  };
  static FORMAT $f_3500_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_324, _dc_324,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_325, _dc_325,
    NULL, NULL, NULL
  };
  static FORMAT $f_4310_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_326, _dc_326,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_327, _dc_327,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_328, _dc_328,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_329, _dc_329,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_330, _dc_330,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_331, _dc_331,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_332, _dc_332,
    NULL, NULL, NULL
  };
  static FORMAT $f_4320_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_333, _dc_333,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_334, _dc_334,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_335, _dc_335,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_329, _dc_329,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_336, _dc_336,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_337, _dc_337,
    NULL, NULL, NULL
  };
  static FORMAT $f_4410_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_338, _dc_338,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_339, _dc_339,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_340, _dc_340,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_341, _dc_341,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_342, _dc_342,
    NULL, NULL, NULL
  };
  static FORMAT $f_4420_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_343, _dc_343,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_344, _dc_344,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_345, _dc_345,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_346, _dc_346,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_347, _dc_347,
    NULL, NULL, NULL
  };
  if ((*d1_) == 1) {
    if ((*d2_) != 0) {
      $u_0_ = (*fileno_);
      _fcheck ("odrpack:dodpe1:49", $u_0_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_0_, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpe1:49", $u_0_));
        __fcnt += 3;
      }
      _write_eol ($u_0_);
    }
    if ((*d3_) != 0) {
      $u_1_ = (*fileno_);
      _fcheck ("odrpack:dodpe1:52", $u_1_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_1_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe1:52", $u_1_));
        __fcnt += 3;
      }
      _write_eol ($u_1_);
    }
    if ((*d4_) != 0) {
      $u_2_ = (*fileno_);
      _fcheck ("odrpack:dodpe1:55", $u_2_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_2_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpe1:55", $u_2_));
        __fcnt += 3;
      }
      _write_eol ($u_2_);
    }
    if ((*d5_) != 0) {
      $u_3_ = (*fileno_);
      _fcheck ("odrpack:dodpe1:58", $u_3_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_3_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpe1:58", $u_3_));
        __fcnt += 3;
      }
      _write_eol ($u_3_);
    }
  }
  else if ((*d1_) == 2) {
    if ((*d2_) != 0) {
      if ((*d2_) == 1 || (*d2_) == 3) {
        $u_4_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:68", $u_4_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2110_[__fcnt] != NULL && $f_2110_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_4_, $f_2110_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe1:68", $u_4_));
          __fcnt += 3;
        }
        _write_eol ($u_4_);
      }
      if ((*d2_) == 2 || (*d2_) == 3) {
        $u_5_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:71", $u_5_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2120_[__fcnt] != NULL && $f_2120_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_5_, $f_2120_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe1:71", $u_5_));
          __fcnt += 3;
        }
        _write_eol ($u_5_);
      }
    }
    if ((*d3_) != 0) {
      if ((*d3_) == 1 || (*d3_) == 3 || (*d3_) == 5 || (*d3_) == 7) {
        $u_6_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:77", $u_6_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2210_[__fcnt] != NULL && $f_2210_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_6_, $f_2210_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpe1:77", $u_6_));
          __fcnt += 3;
        }
        _write_eol ($u_6_);
      }
      if ((*d3_) == 2 || (*d3_) == 3 || (*d3_) == 6 || (*d3_) == 7) {
        $u_7_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:80", $u_7_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2220_[__fcnt] != NULL && $f_2220_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_7_, $f_2220_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe1:80", $u_7_));
          __fcnt += 3;
        }
        _write_eol ($u_7_);
      }
      if ((*d3_) == 4 || (*d3_) == 5 || (*d3_) == 6 || (*d3_) == 7) {
        $u_8_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:83", $u_8_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2230_[__fcnt] != NULL && $f_2230_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_8_, $f_2230_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe1:83", $u_8_));
          __fcnt += 3;
        }
        _write_eol ($u_8_);
      }
    }
    if ((*d4_) != 0) {
      if ((*d4_) == 1 || (*d4_) == 3) {
        $u_9_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:89", $u_9_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2310_[__fcnt] != NULL && $f_2310_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_9_, $f_2310_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpe1:89", $u_9_));
          __fcnt += 3;
        }
        _write_eol ($u_9_);
      }
      if ((*d4_) == 2 || (*d4_) == 3) {
        $u_10_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:92", $u_10_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2320_[__fcnt] != NULL && $f_2320_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_10_, $f_2320_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_10_, _ioerr_write ("odrpack:dodpe1:92", $u_10_));
          __fcnt += 3;
        }
        _write_eol ($u_10_);
      }
    }
    if ((*d5_) != 0) {
      if ((*d5_) == 1 || (*d5_) == 3) {
        $u_11_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:98", $u_11_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2410_[__fcnt] != NULL && $f_2410_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_11_, $f_2410_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpe1:98", $u_11_));
          __fcnt += 3;
        }
        if ($f_2410_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_11_].unit, "\n");
          while ($f_2410_[__fcnt] != NULL && $f_2410_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_11_, $f_2410_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpe1:98", $u_11_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_11_, $f_2410_[__fcnt + 2], &(*lwkmn_), INTEGER, 4);
        _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpe1:98", $u_11_));
        __fcnt += 3;
        while ($f_2410_[__fcnt] != NULL && $f_2410_[__fcnt] == FMT_TEXT) {
          if ($f_2410_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_11_, $f_2410_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpe1:98", $u_11_));
          __fcnt += 3;
        }
        _write_eol ($u_11_);
      }
      if ((*d5_) == 2 || (*d5_) == 3) {
        $u_12_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:101", $u_12_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_2420_[__fcnt] != NULL && $f_2420_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_12_, $f_2420_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_12_, _ioerr_write ("odrpack:dodpe1:101", $u_12_));
          __fcnt += 3;
        }
        if ($f_2420_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_12_].unit, "\n");
          while ($f_2420_[__fcnt] != NULL && $f_2420_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_12_, $f_2420_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_12_, _ioerr_write ("odrpack:dodpe1:101", $u_12_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_12_, $f_2420_[__fcnt + 2], &(*liwkmn_), INTEGER, 4);
        _write_err (__rc, $u_12_, _ioerr_write ("odrpack:dodpe1:101", $u_12_));
        __fcnt += 3;
        while ($f_2420_[__fcnt] != NULL && $f_2420_[__fcnt] == FMT_TEXT) {
          if ($f_2420_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_12_, $f_2420_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_12_, _ioerr_write ("odrpack:dodpe1:101", $u_12_));
          __fcnt += 3;
        }
        _write_eol ($u_12_);
      }
    }
  }
  else if ((*d1_) == 3) {
    if ((*d2_) != 0) {
      if ((*d2_) == 1 || (*d2_) == 3) {
        if ((*ldscld_) >= (*n_)) {
          $u_13_ = (*fileno_);
          _fcheck ("odrpack:dodpe1:112", $u_13_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_3110_[__fcnt] != NULL && $f_3110_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_13_, $f_3110_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_13_, _ioerr_write ("odrpack:dodpe1:112", $u_13_));
            __fcnt += 3;
          }
          _write_eol ($u_13_);
        }
        else {
          $u_14_ = (*fileno_);
          _fcheck ("odrpack:dodpe1:114", $u_14_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_3120_[__fcnt] != NULL && $f_3120_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_14_, $f_3120_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_14_, _ioerr_write ("odrpack:dodpe1:114", $u_14_));
            __fcnt += 3;
          }
          _write_eol ($u_14_);
        }
      }
      if ((*d2_) == 2 || (*d2_) == 3) {
        $u_15_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:118", $u_15_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_3130_[__fcnt] != NULL && $f_3130_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_15_, $f_3130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpe1:118", $u_15_));
          __fcnt += 3;
        }
        _write_eol ($u_15_);
      }
    }
    if ((*d3_) != 0) {
      if ((*d3_) == 1 || (*d3_) == 3) {
        if ((*ldstpd_) >= (*n_)) {
          $u_16_ = (*fileno_);
          _fcheck ("odrpack:dodpe1:127", $u_16_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_3210_[__fcnt] != NULL && $f_3210_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_16_, $f_3210_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpe1:127", $u_16_));
            __fcnt += 3;
          }
          _write_eol ($u_16_);
        }
        else {
          $u_17_ = (*fileno_);
          _fcheck ("odrpack:dodpe1:129", $u_17_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_3220_[__fcnt] != NULL && $f_3220_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_17_, $f_3220_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpe1:129", $u_17_));
            __fcnt += 3;
          }
          _write_eol ($u_17_);
        }
      }
      if ((*d3_) == 2 || (*d3_) == 3) {
        $u_18_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:133", $u_18_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_3230_[__fcnt] != NULL && $f_3230_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_18_, $f_3230_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_18_, _ioerr_write ("odrpack:dodpe1:133", $u_18_));
          __fcnt += 3;
        }
        _write_eol ($u_18_);
      }
    }
    if ((*d4_) != 0) {
      if ((*d4_) == 1) {
        if ((*ldwe_) >= (*n_)) {
          if ((*ld2we_) >= (*nq_)) {
            $u_19_ = (*fileno_);
            _fcheck ("odrpack:dodpe1:143", $u_19_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_3310_[__fcnt] != NULL && $f_3310_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_19_, $f_3310_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpe1:143", $u_19_));
              __fcnt += 3;
            }
            _write_eol ($u_19_);
          }
          else {
            $u_20_ = (*fileno_);
            _fcheck ("odrpack:dodpe1:145", $u_20_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_3320_[__fcnt] != NULL && $f_3320_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_20_, $f_3320_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpe1:145", $u_20_));
              __fcnt += 3;
            }
            _write_eol ($u_20_);
          }
        }
        else {
          if ((*ld2we_) >= (*nq_)) {
            $u_21_ = (*fileno_);
            _fcheck ("odrpack:dodpe1:149", $u_21_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_3410_[__fcnt] != NULL && $f_3410_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_21_, $f_3410_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_21_, _ioerr_write ("odrpack:dodpe1:149", $u_21_));
              __fcnt += 3;
            }
            _write_eol ($u_21_);
          }
          else {
            $u_22_ = (*fileno_);
            _fcheck ("odrpack:dodpe1:151", $u_22_, action_write, form_formatted);
            __fcnt = 0;
            while ($f_3420_[__fcnt] != NULL && $f_3420_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_22_, $f_3420_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe1:151", $u_22_));
              __fcnt += 3;
            }
            _write_eol ($u_22_);
          }
        }
      }
      if ((*d4_) == 2) {
        $u_23_ = (*fileno_);
        _fcheck ("odrpack:dodpe1:156", $u_23_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_3500_[__fcnt] != NULL && $f_3500_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_23_, $f_3500_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_23_, _ioerr_write ("odrpack:dodpe1:156", $u_23_));
          __fcnt += 3;
        }
        _write_eol ($u_23_);
      }
    }
    if ((*d5_) != 0) {
      if ((*ldwd_) >= (*n_)) {
        if ((*ld2wd_) >= (*m_)) {
          $u_24_ = (*fileno_);
          _fcheck ("odrpack:dodpe1:165", $u_24_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_4310_[__fcnt] != NULL && $f_4310_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_24_, $f_4310_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_24_, _ioerr_write ("odrpack:dodpe1:165", $u_24_));
            __fcnt += 3;
          }
          _write_eol ($u_24_);
        }
        else {
          $u_25_ = (*fileno_);
          _fcheck ("odrpack:dodpe1:167", $u_25_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_4320_[__fcnt] != NULL && $f_4320_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_25_, $f_4320_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_25_, _ioerr_write ("odrpack:dodpe1:167", $u_25_));
            __fcnt += 3;
          }
          _write_eol ($u_25_);
        }
      }
      else {
        if ((*ld2wd_) >= (*m_)) {
          $u_26_ = (*fileno_);
          _fcheck ("odrpack:dodpe1:171", $u_26_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_4410_[__fcnt] != NULL && $f_4410_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_26_, $f_4410_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_26_, _ioerr_write ("odrpack:dodpe1:171", $u_26_));
            __fcnt += 3;
          }
          _write_eol ($u_26_);
        }
        else {
          $u_27_ = (*fileno_);
          _fcheck ("odrpack:dodpe1:173", $u_27_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_4420_[__fcnt] != NULL && $f_4420_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_27_, $f_4420_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_27_, _ioerr_write ("odrpack:dodpe1:173", $u_27_));
            __fcnt += 3;
          }
          _write_eol ($u_27_);
        }
      }
    }
  }
  _l1100:;
  _l1200:;
  _l1300:;
  _l1400:;
  _l2110:;
  _l2120:;
  _l2210:;
  _l2220:;
  _l2230:;
  _l2310:;
  _l2320:;
  _l2410:;
  _l2420:;
  _l3110:;
  _l3120:;
  _l3130:;
  _l3210:;
  _l3220:;
  _l3230:;
  _l3310:;
  _l3320:;
  _l3410:;
  _l3420:;
  _l3500:;
  _l4310:;
  _l4320:;
  _l4410:;
  _l4420:;
  __calls[30].calls++;
  return 0;
}

int_4 _dodpe2 (int_4 _p_ fileno_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ fjacb_, real_8 
_p_ fjacd_, real_8 _p_ diff_, int_4 _p_ msgb1_, int_4 _p_ msgb_, logical_4 _p_ isodr_, int_4 _p_ msgd1_, int_4 _p_ 
msgd_, real_8 _p_ xplusd_, int_4 _p_ nrow_, int_4 _p_ neta_, int_4 _p_ ntol_)
{
  static int_4 i_, j_, k_, l_;
  static logical_4 ftnote_[8];
  static char_1 flag_;
  static char_3 typ_;
  int_4 $u_0_, __fcnt, __rc, $u_1_, $u_2_, $u_3_, $u_4_, $u_5_, $u_6_, $u_7_, $u_8_, $u_9_, $u_10_, $u_11_, $u_12_, 
  $u_13_, $u_14_, $u_15_, $u_16_, $u_17_, $18_, $u_19_, $u_20_, $u_21_, $u_22_;
  static FORMAT $f_1000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_349, _dc_349,
    FMT_CHAR,"%3s","%-3s",
    FMT_TEXT, _dc_248, _dc_248,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_2100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_350, _dc_350,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_351, _dc_351,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_2200_[] = {
    FMT_TEXT, _dc_352, _dc_352,
    FMT_TEXT, _dc_353, _dc_353,
    FMT_TEXT, _dc_354, _dc_354,
    FMT_TEXT, _dc_355, _dc_355,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_352, _dc_352,
    FMT_TEXT, _dc_356, _dc_356,
    FMT_TEXT, _dc_357, _dc_357,
    FMT_TEXT, _dc_358, _dc_358,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_359, _dc_359,
    FMT_TEXT, _dc_360, _dc_360,
    FMT_TEXT, _dc_361, _dc_361,
    FMT_TEXT, _dc_362, _dc_362,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_3100_[] = {
    FMT_TEXT, _dc_363, _dc_363,
    FMT_INT,"%3d","%3d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_364, _dc_364,
    FMT_TEXT, _dc_364, _dc_364,
    FMT_TEXT, _dc_2, _dc_2,
    NULL, NULL, NULL
  };
  static FORMAT $f_3200_[] = {
    FMT_TEXT, _dc_363, _dc_363,
    FMT_INT,"%3d","%3d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%13e","%13.2.0e",
    FMT_REAL,"%13e","%13.2.0e",
    FMT_TEXT, _dc_119, _dc_119,
    FMT_CHAR,"%1s","%-1s",
    FMT_TEXT, _dc_365, _dc_365,
    NULL, NULL, NULL
  };
  static FORMAT $f_3300_[] = {
    FMT_TEXT, _dc_363, _dc_363,
    FMT_INT,"%3d","%3d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%13e","%13.2.0e",
    FMT_REAL,"%13e","%13.2.0e",
    FMT_TEXT, _dc_119, _dc_119,
    FMT_CHAR,"%1s","%-1s",
    FMT_TEXT, _dc_366, _dc_366,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  static FORMAT $f_4100_[] = {
    FMT_TEXT, _dc_367, _dc_367,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_272, _dc_272,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_364, _dc_364,
    FMT_TEXT, _dc_364, _dc_364,
    FMT_TEXT, _dc_2, _dc_2,
    NULL, NULL, NULL
  };
  static FORMAT $f_4200_[] = {
    FMT_TEXT, _dc_367, _dc_367,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_272, _dc_272,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%13e","%13.2.0e",
    FMT_REAL,"%13e","%13.2.0e",
    FMT_TEXT, _dc_119, _dc_119,
    FMT_CHAR,"%1s","%-1s",
    FMT_TEXT, _dc_365, _dc_365,
    NULL, NULL, NULL
  };
  static FORMAT $f_4300_[] = {
    FMT_TEXT, _dc_367, _dc_367,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_272, _dc_272,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT,"","1",
    FMT_REAL,"%13e","%13.2.0e",
    FMT_REAL,"%13e","%13.2.0e",
    FMT_TEXT, _dc_119, _dc_119,
    FMT_CHAR,"%1s","%-1s",
    FMT_TEXT, _dc_366, _dc_366,
    FMT_INT,"%1d","%1d",
    FMT_TEXT, _dc_11, _dc_11,
    NULL, NULL, NULL
  };
  static FORMAT $f_5000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_368, _dc_368,
    NULL, NULL, NULL
  };
  static FORMAT $f_5100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_369, _dc_369,
    FMT_TEXT, _dc_370, _dc_370,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_371, _dc_371,
    NULL, NULL, NULL
  };
  static FORMAT $f_5200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_372, _dc_372,
    FMT_TEXT, _dc_370, _dc_370,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_373, _dc_373,
    FMT_TEXT, _dc_374, _dc_374,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_375, _dc_375,
    NULL, NULL, NULL
  };
  static FORMAT $f_5300_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_376, _dc_376,
    FMT_TEXT, _dc_377, _dc_377,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_373, _dc_373,
    FMT_TEXT, _dc_374, _dc_374,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_378, _dc_378,
    NULL, NULL, NULL
  };
  static FORMAT $f_5400_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_379, _dc_379,
    FMT_TEXT, _dc_377, _dc_377,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_380, _dc_380,
    FMT_TEXT, _dc_381, _dc_381,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_382, _dc_382,
    FMT_TEXT, _dc_383, _dc_383,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_384, _dc_384,
    NULL, NULL, NULL
  };
  static FORMAT $f_5500_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_385, _dc_385,
    FMT_TEXT, _dc_377, _dc_377,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_380, _dc_380,
    FMT_TEXT, _dc_386, _dc_386,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_387, _dc_387,
    FMT_TEXT, _dc_388, _dc_388,
    NULL, NULL, NULL
  };
  static FORMAT $f_5600_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_389, _dc_389,
    FMT_TEXT, _dc_377, _dc_377,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_390, _dc_390,
    NULL, NULL, NULL
  };
  static FORMAT $f_5700_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_391, _dc_391,
    FMT_TEXT, _dc_392, _dc_392,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_393, _dc_393,
    FMT_TEXT, _dc_394, _dc_394,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_395, _dc_395,
    NULL, NULL, NULL
  };
  static FORMAT $f_6000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_396, _dc_396,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_397, _dc_397,
    NULL, NULL, NULL
  };
  static FORMAT $f_6100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_396, _dc_396,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_398, _dc_398,
    NULL, NULL, NULL
  };
  static FORMAT $f_7000_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_399, _dc_399,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_400, _dc_400,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_401, _dc_401,
    FMT_INT,"%5d","%5d",
    NULL, NULL, NULL
  };
  static FORMAT $f_8100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_402, _dc_402,
    FMT_INT,"%5d","%5d",
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_403, _dc_403,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  static FORMAT $f_8110_[] = {
    FMT_TEXT, _dc_404, _dc_404,
    FMT_TEXT, _dc_405, _dc_405,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_272, _dc_272,
    FMT_INT,"%2d","%2d",
    FMT_TEXT, _dc_11, _dc_11,
    FMT_TEXT, _dc_100, _dc_100,
    FMT_TEXT,"","1",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    FMT_REAL,"%16e","%16.8.0e",
    NULL, NULL, NULL
  };
  for (i_ = 0; i_ <= 7; (i_)++) {
    ftnote_[i_] = FALSE;
  }
  for (l_ = 1; l_ <= (*nq_); (l_)++) {
    if ((*msgb1_) >= 1) {
      for (i_ = 1; i_ <= (*np_); (i_)++) {
        if (msgb_[l_ - 1 + ((*nq_)) * ((i_ - 1))] >= 1) {
          ftnote_[0] = TRUE;
          ftnote_[msgb_[l_ - 1 + ((*nq_)) * ((i_ - 1))]] = TRUE;
        }
      }
    }
    if ((*msgd1_) >= 1) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        if (msgd_[l_ - 1 + ((*nq_)) * ((i_ - 1))] >= 1) {
          ftnote_[0] = TRUE;
          ftnote_[msgd_[l_ - 1 + ((*nq_)) * ((i_ - 1))]] = TRUE;
        }
      }
    }
  }
  if ((*isodr_)) {
    bufcpy (typ_, _dc_245, 3);
  }
  else {
    bufcpy (typ_, _dc_246, 3);
  }
  $u_0_ = (*fileno_);
  _fcheck ("odrpack:dodpe2:105", $u_0_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpe2:105", $u_0_));
    __fcnt += 3;
  }
  if ($f_1000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_0_].unit, "\n");
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpe2:105", $u_0_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], typ_, CHARACTER, 3);
  _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpe2:105", $u_0_));
  __fcnt += 3;
  while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
    if ($f_1000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpe2:105", $u_0_));
    __fcnt += 3;
  }
  _write_eol ($u_0_);
  for (l_ = 1; l_ <= (*nq_); (l_)++) {
    $u_1_ = (*fileno_);
    _fcheck ("odrpack:dodpe2:109", $u_1_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_2100_[__fcnt] != NULL && $f_2100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_1_, $f_2100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe2:109", $u_1_));
      __fcnt += 3;
    }
    if ($f_2100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_1_].unit, "\n");
      while ($f_2100_[__fcnt] != NULL && $f_2100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_1_, $f_2100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe2:109", $u_1_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_1_, $f_2100_[__fcnt + 2], &l_, INTEGER, 4);
    _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe2:109", $u_1_));
    __fcnt += 3;
    while ($f_2100_[__fcnt] != NULL && $f_2100_[__fcnt] == FMT_TEXT) {
      if ($f_2100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_1_, $f_2100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe2:109", $u_1_));
      __fcnt += 3;
    }
    if ($f_2100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_1_].unit, "\n");
      while ($f_2100_[__fcnt] != NULL && $f_2100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_1_, $f_2100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe2:109", $u_1_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_1_, $f_2100_[__fcnt + 2], &(*nrow_), INTEGER, 4);
    _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe2:109", $u_1_));
    __fcnt += 3;
    while ($f_2100_[__fcnt] != NULL && $f_2100_[__fcnt] == FMT_TEXT) {
      if ($f_2100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_1_, $f_2100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe2:109", $u_1_));
      __fcnt += 3;
    }
    _write_eol ($u_1_);
    $u_2_ = (*fileno_);
    _fcheck ("odrpack:dodpe2:110", $u_2_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_2200_[__fcnt] != NULL && $f_2200_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_2_, $f_2200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpe2:110", $u_2_));
      __fcnt += 3;
    }
    _write_eol ($u_2_);
    for (i_ = 1; i_ <= (*np_); (i_)++) {
      k_ = msgb_[l_ - 1 + ((*nq_)) * ((i_ - 1))];
      if (k_ >= 7) {
        bufcpy (flag_, _dc_348, 1);
      }
      else {
        bufcpy (flag_, _dc_100, 1);
      }
      if (k_ <= -1) {
        $u_3_ = (*fileno_);
        _fcheck ("odrpack:dodpe2:120", $u_3_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_3100_[__fcnt] != NULL && $f_3100_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_3_, $f_3100_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpe2:120", $u_3_));
          __fcnt += 3;
        }
        if ($f_3100_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_3_].unit, "\n");
          while ($f_3100_[__fcnt] != NULL && $f_3100_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_3_, $f_3100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpe2:120", $u_3_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_3_, $f_3100_[__fcnt + 2], &i_, INTEGER, 4);
        _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpe2:120", $u_3_));
        __fcnt += 3;
        while ($f_3100_[__fcnt] != NULL && $f_3100_[__fcnt] == FMT_TEXT) {
          if ($f_3100_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_3_, $f_3100_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpe2:120", $u_3_));
          __fcnt += 3;
        }
        _write_eol ($u_3_);
      }
      else if (k_ == 0) {
        $u_4_ = (*fileno_);
        _fcheck ("odrpack:dodpe2:122", $u_4_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
          __fcnt += 3;
        }
        if ($f_3200_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], &i_, INTEGER, 4);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
        __fcnt += 3;
        while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
          if ($f_3200_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
          __fcnt += 3;
        }
        if ($f_3200_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], &fjacb_[(*nrow_) - 1 + ((*n_)) * ((i_ - 1) + ((*np_)) * ((l_ - 1)))], 
        REAL, 8);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
        __fcnt += 3;
        while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
          if ($f_3200_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
          __fcnt += 3;
        }
        if ($f_3200_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], &diff_[l_ - 1 + ((*nq_)) * ((i_ - 1))], REAL, 8);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
        __fcnt += 3;
        while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
          if ($f_3200_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
          __fcnt += 3;
        }
        if ($f_3200_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_4_].unit, "\n");
          while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], flag_, CHARACTER, 1);
        _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
        __fcnt += 3;
        while ($f_3200_[__fcnt] != NULL && $f_3200_[__fcnt] == FMT_TEXT) {
          if ($f_3200_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_4_, $f_3200_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_4_, _ioerr_write ("odrpack:dodpe2:122", $u_4_));
          __fcnt += 3;
        }
        _write_eol ($u_4_);
      }
      else if (k_ >= 1) {
        $u_5_ = (*fileno_);
        _fcheck ("odrpack:dodpe2:124", $u_5_, action_write, form_formatted);
        __fcnt = 0;
        while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
          __fcnt += 3;
        }
        if ($f_3300_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], &i_, INTEGER, 4);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
        __fcnt += 3;
        while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
          if ($f_3300_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
          __fcnt += 3;
        }
        if ($f_3300_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], &fjacb_[(*nrow_) - 1 + ((*n_)) * ((i_ - 1) + ((*np_)) * ((l_ - 1)))], 
        REAL, 8);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
        __fcnt += 3;
        while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
          if ($f_3300_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
          __fcnt += 3;
        }
        if ($f_3300_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], &diff_[l_ - 1 + ((*nq_)) * ((i_ - 1))], REAL, 8);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
        __fcnt += 3;
        while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
          if ($f_3300_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
          __fcnt += 3;
        }
        if ($f_3300_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], flag_, CHARACTER, 1);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
        __fcnt += 3;
        while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
          if ($f_3300_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
          __fcnt += 3;
        }
        if ($f_3300_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[$u_5_].unit, "\n");
          while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], &k_, INTEGER, 4);
        _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
        __fcnt += 3;
        while ($f_3300_[__fcnt] != NULL && $f_3300_[__fcnt] == FMT_TEXT) {
          if ($f_3300_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf ($u_5_, $f_3300_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, $u_5_, _ioerr_write ("odrpack:dodpe2:124", $u_5_));
          __fcnt += 3;
        }
        _write_eol ($u_5_);
      }
    }
    if ((*isodr_)) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        k_ = msgd_[l_ - 1 + ((*nq_)) * ((i_ - 1))];
        if (k_ >= 7) {
          bufcpy (flag_, _dc_348, 1);
        }
        else {
          bufcpy (flag_, _dc_100, 1);
        }
        if (k_ <= -1) {
          $u_6_ = (*fileno_);
          _fcheck ("odrpack:dodpe2:136", $u_6_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_4100_[__fcnt] != NULL && $f_4100_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_6_, $f_4100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpe2:136", $u_6_));
            __fcnt += 3;
          }
          if ($f_4100_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_4100_[__fcnt] != NULL && $f_4100_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_4100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpe2:136", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_4100_[__fcnt + 2], &(*nrow_), INTEGER, 4);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpe2:136", $u_6_));
          __fcnt += 3;
          while ($f_4100_[__fcnt] != NULL && $f_4100_[__fcnt] == FMT_TEXT) {
            if ($f_4100_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_4100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpe2:136", $u_6_));
            __fcnt += 3;
          }
          if ($f_4100_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_6_].unit, "\n");
            while ($f_4100_[__fcnt] != NULL && $f_4100_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_6_, $f_4100_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpe2:136", $u_6_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_6_, $f_4100_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpe2:136", $u_6_));
          __fcnt += 3;
          while ($f_4100_[__fcnt] != NULL && $f_4100_[__fcnt] == FMT_TEXT) {
            if ($f_4100_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_6_, $f_4100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_6_, _ioerr_write ("odrpack:dodpe2:136", $u_6_));
            __fcnt += 3;
          }
          _write_eol ($u_6_);
        }
        else if (k_ == 0) {
          $u_7_ = (*fileno_);
          _fcheck ("odrpack:dodpe2:138", $u_7_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
            __fcnt += 3;
          }
          if ($f_4200_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], &(*nrow_), INTEGER, 4);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
          __fcnt += 3;
          while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
            if ($f_4200_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
            __fcnt += 3;
          }
          if ($f_4200_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
          __fcnt += 3;
          while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
            if ($f_4200_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
            __fcnt += 3;
          }
          if ($f_4200_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], &fjacd_[(*nrow_) - 1 + ((*n_)) * ((i_ - 1) + ((*m_)) * ((l_ - 1)))], 
          REAL, 8);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
          __fcnt += 3;
          while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
            if ($f_4200_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
            __fcnt += 3;
          }
          if ($f_4200_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], &diff_[l_ - 1 + ((*nq_)) * (((*np_) + i_ - 1))], REAL, 8);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
          __fcnt += 3;
          while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
            if ($f_4200_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
            __fcnt += 3;
          }
          if ($f_4200_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_7_].unit, "\n");
            while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], flag_, CHARACTER, 1);
          _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
          __fcnt += 3;
          while ($f_4200_[__fcnt] != NULL && $f_4200_[__fcnt] == FMT_TEXT) {
            if ($f_4200_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_7_, $f_4200_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_7_, _ioerr_write ("odrpack:dodpe2:138", $u_7_));
            __fcnt += 3;
          }
          _write_eol ($u_7_);
        }
        else if (k_ >= 1) {
          $u_8_ = (*fileno_);
          _fcheck ("odrpack:dodpe2:141", $u_8_, action_write, form_formatted);
          __fcnt = 0;
          while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
            __fcnt += 3;
          }
          if ($f_4300_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], &(*nrow_), INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
          __fcnt += 3;
          while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
            if ($f_4300_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
            __fcnt += 3;
          }
          if ($f_4300_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], &i_, INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
          __fcnt += 3;
          while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
            if ($f_4300_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
            __fcnt += 3;
          }
          if ($f_4300_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], &fjacd_[(*nrow_) - 1 + ((*n_)) * ((i_ - 1) + ((*m_)) * ((l_ - 1)))], 
          REAL, 8);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
          __fcnt += 3;
          while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
            if ($f_4300_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
            __fcnt += 3;
          }
          if ($f_4300_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], &diff_[l_ - 1 + ((*nq_)) * (((*np_) + i_ - 1))], REAL, 8);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
          __fcnt += 3;
          while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
            if ($f_4300_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
            __fcnt += 3;
          }
          if ($f_4300_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], flag_, CHARACTER, 1);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
          __fcnt += 3;
          while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
            if ($f_4300_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
            __fcnt += 3;
          }
          if ($f_4300_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[$u_8_].unit, "\n");
            while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], &k_, INTEGER, 4);
          _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
          __fcnt += 3;
          while ($f_4300_[__fcnt] != NULL && $f_4300_[__fcnt] == FMT_TEXT) {
            if ($f_4300_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf ($u_8_, $f_4300_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, $u_8_, _ioerr_write ("odrpack:dodpe2:141", $u_8_));
            __fcnt += 3;
          }
          _write_eol ($u_8_);
        }
      }
    }
  }
  if (ftnote_[0]) {
    $u_9_ = (*fileno_);
    _fcheck ("odrpack:dodpe2:152", $u_9_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_5000_[__fcnt] != NULL && $f_5000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_9_, $f_5000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_9_, _ioerr_write ("odrpack:dodpe2:152", $u_9_));
      __fcnt += 3;
    }
    _write_eol ($u_9_);
    if (ftnote_[1]) {
      $u_10_ = (*fileno_);
      _fcheck ("odrpack:dodpe2:153", $u_10_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_5100_[__fcnt] != NULL && $f_5100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_10_, $f_5100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_10_, _ioerr_write ("odrpack:dodpe2:153", $u_10_));
        __fcnt += 3;
      }
      _write_eol ($u_10_);
    }
    if (ftnote_[2]) {
      $u_11_ = (*fileno_);
      _fcheck ("odrpack:dodpe2:154", $u_11_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_5200_[__fcnt] != NULL && $f_5200_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_11_, $f_5200_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_11_, _ioerr_write ("odrpack:dodpe2:154", $u_11_));
        __fcnt += 3;
      }
      _write_eol ($u_11_);
    }
    if (ftnote_[3]) {
      $u_12_ = (*fileno_);
      _fcheck ("odrpack:dodpe2:155", $u_12_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_5300_[__fcnt] != NULL && $f_5300_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_12_, $f_5300_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_12_, _ioerr_write ("odrpack:dodpe2:155", $u_12_));
        __fcnt += 3;
      }
      _write_eol ($u_12_);
    }
    if (ftnote_[4]) {
      $u_13_ = (*fileno_);
      _fcheck ("odrpack:dodpe2:156", $u_13_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_5400_[__fcnt] != NULL && $f_5400_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_13_, $f_5400_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_13_, _ioerr_write ("odrpack:dodpe2:156", $u_13_));
        __fcnt += 3;
      }
      _write_eol ($u_13_);
    }
    if (ftnote_[5]) {
      $u_14_ = (*fileno_);
      _fcheck ("odrpack:dodpe2:157", $u_14_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_5500_[__fcnt] != NULL && $f_5500_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_14_, $f_5500_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_14_, _ioerr_write ("odrpack:dodpe2:157", $u_14_));
        __fcnt += 3;
      }
      _write_eol ($u_14_);
    }
    if (ftnote_[6]) {
      $u_15_ = (*fileno_);
      _fcheck ("odrpack:dodpe2:158", $u_15_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_5600_[__fcnt] != NULL && $f_5600_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_15_, $f_5600_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_15_, _ioerr_write ("odrpack:dodpe2:158", $u_15_));
        __fcnt += 3;
      }
      _write_eol ($u_15_);
    }
    if (ftnote_[7]) {
      $u_16_ = (*fileno_);
      _fcheck ("odrpack:dodpe2:159", $u_16_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_5700_[__fcnt] != NULL && $f_5700_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_16_, $f_5700_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_16_, _ioerr_write ("odrpack:dodpe2:159", $u_16_));
        __fcnt += 3;
      }
      _write_eol ($u_16_);
    }
  }
  if ((*neta_) < 0) {
    $u_17_ = (*fileno_);
    _fcheck ("odrpack:dodpe2:163", $u_17_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_6000_[__fcnt] != NULL && $f_6000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_17_, $f_6000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpe2:163", $u_17_));
      __fcnt += 3;
    }
    $18_ = -(*neta_);
    if ($f_6000_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_17_].unit, "\n");
      while ($f_6000_[__fcnt] != NULL && $f_6000_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_17_, $f_6000_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpe2:163", $u_17_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_17_, $f_6000_[__fcnt + 2], &$18_, INTEGER, 4);
    _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpe2:163", $u_17_));
    __fcnt += 3;
    while ($f_6000_[__fcnt] != NULL && $f_6000_[__fcnt] == FMT_TEXT) {
      if ($f_6000_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_17_, $f_6000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_17_, _ioerr_write ("odrpack:dodpe2:163", $u_17_));
      __fcnt += 3;
    }
    _write_eol ($u_17_);
  }
  else {
    $u_19_ = (*fileno_);
    _fcheck ("odrpack:dodpe2:165", $u_19_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_6100_[__fcnt] != NULL && $f_6100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_19_, $f_6100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpe2:165", $u_19_));
      __fcnt += 3;
    }
    if ($f_6100_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_19_].unit, "\n");
      while ($f_6100_[__fcnt] != NULL && $f_6100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_19_, $f_6100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpe2:165", $u_19_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_19_, $f_6100_[__fcnt + 2], &(*neta_), INTEGER, 4);
    _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpe2:165", $u_19_));
    __fcnt += 3;
    while ($f_6100_[__fcnt] != NULL && $f_6100_[__fcnt] == FMT_TEXT) {
      if ($f_6100_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_19_, $f_6100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_19_, _ioerr_write ("odrpack:dodpe2:165", $u_19_));
      __fcnt += 3;
    }
    _write_eol ($u_19_);
  }
  $u_20_ = (*fileno_);
  _fcheck ("odrpack:dodpe2:167", $u_20_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_7000_[__fcnt] != NULL && $f_7000_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_20_, $f_7000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpe2:167", $u_20_));
    __fcnt += 3;
  }
  if ($f_7000_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_20_].unit, "\n");
    while ($f_7000_[__fcnt] != NULL && $f_7000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_20_, $f_7000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpe2:167", $u_20_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_20_, $f_7000_[__fcnt + 2], &(*ntol_), INTEGER, 4);
  _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpe2:167", $u_20_));
  __fcnt += 3;
  while ($f_7000_[__fcnt] != NULL && $f_7000_[__fcnt] == FMT_TEXT) {
    if ($f_7000_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_20_, $f_7000_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_20_, _ioerr_write ("odrpack:dodpe2:167", $u_20_));
    __fcnt += 3;
  }
  _write_eol ($u_20_);
  $u_21_ = (*fileno_);
  _fcheck ("odrpack:dodpe2:171", $u_21_, action_write, form_formatted);
  __fcnt = 0;
  while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf ($u_21_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_21_, _ioerr_write ("odrpack:dodpe2:171", $u_21_));
    __fcnt += 3;
  }
  if ($f_8100_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[$u_21_].unit, "\n");
    while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_21_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_21_, _ioerr_write ("odrpack:dodpe2:171", $u_21_));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf ($u_21_, $f_8100_[__fcnt + 2], &(*nrow_), INTEGER, 4);
  _write_err (__rc, $u_21_, _ioerr_write ("odrpack:dodpe2:171", $u_21_));
  __fcnt += 3;
  while ($f_8100_[__fcnt] != NULL && $f_8100_[__fcnt] == FMT_TEXT) {
    if ($f_8100_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf ($u_21_, $f_8100_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, $u_21_, _ioerr_write ("odrpack:dodpe2:171", $u_21_));
    __fcnt += 3;
  }
  _write_eol ($u_21_);
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    $u_22_ = (*fileno_);
    _fcheck ("odrpack:dodpe2:174", $u_22_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_8110_[__fcnt] != NULL && $f_8110_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
      __fcnt += 3;
    }
    if ($f_8110_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_22_].unit, "\n");
      while ($f_8110_[__fcnt] != NULL && $f_8110_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], &(*nrow_), INTEGER, 4);
    _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
    __fcnt += 3;
    while ($f_8110_[__fcnt] != NULL && $f_8110_[__fcnt] == FMT_TEXT) {
      if ($f_8110_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
      __fcnt += 3;
    }
    if ($f_8110_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_22_].unit, "\n");
      while ($f_8110_[__fcnt] != NULL && $f_8110_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], &j_, INTEGER, 4);
    _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
    __fcnt += 3;
    while ($f_8110_[__fcnt] != NULL && $f_8110_[__fcnt] == FMT_TEXT) {
      if ($f_8110_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
      __fcnt += 3;
    }
    if ($f_8110_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[$u_22_].unit, "\n");
      while ($f_8110_[__fcnt] != NULL && $f_8110_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], &xplusd_[(*nrow_) - 1 + ((*n_)) * ((j_ - 1))], REAL, 8);
    _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
    __fcnt += 3;
    while ($f_8110_[__fcnt] != NULL && $f_8110_[__fcnt] == FMT_TEXT) {
      if ($f_8110_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf ($u_22_, $f_8110_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_22_, _ioerr_write ("odrpack:dodpe2:174", $u_22_));
      __fcnt += 3;
    }
    _write_eol ($u_22_);
  }
  goto _l0;
  _l1000:;
  _l2100:;
  _l2200:;
  _l3100:;
  _l3200:;
  _l3300:;
  _l4100:;
  _l4200:;
  _l4300:;
  _l5000:;
  _l5100:;
  _l5200:;
  _l5300:;
  _l5400:;
  _l5500:;
  _l5600:;
  _l5700:;
  _l6000:;
  _l6100:;
  _l7000:;
  _l8100:;
  _l8110:;
  _l0:;
  __calls[31].calls++;
  return 0;
}

int_4 _dodpe3 (int_4 _p_ fileno_, int_4 _p_ d2_, int_4 _p_ d3_)
{
  int_4 $u_0_, __fcnt, __rc, $u_1_, $u_2_, $u_3_;
  static FORMAT $f_1100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_406, _dc_406,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_407, _dc_407,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_408, _dc_408,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_409, _dc_409,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_410, _dc_410,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_411, _dc_411,
    NULL, NULL, NULL
  };
  static FORMAT $f_1200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_406, _dc_406,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_412, _dc_412,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_413, _dc_413,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_414, _dc_414,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_415, _dc_415,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_416, _dc_416,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_417, _dc_417,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_418, _dc_418,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_419, _dc_419,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_420, _dc_420,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_421, _dc_421,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_422, _dc_422,
    NULL, NULL, NULL
  };
  static FORMAT $f_1300_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_406, _dc_406,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_412, _dc_412,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_423, _dc_423,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_424, _dc_424,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_425, _dc_425,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_426, _dc_426,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_427, _dc_427,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_428, _dc_428,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_429, _dc_429,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_430, _dc_430,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_431, _dc_431,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_421, _dc_421,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_422, _dc_422,
    NULL, NULL, NULL
  };
  static FORMAT $f_1400_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_406, _dc_406,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_432, _dc_432,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_433, _dc_433,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_434, _dc_434,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_435, _dc_435,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_436, _dc_436,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_437, _dc_437,
    NULL, NULL, NULL
  };
  if ((*d2_) == 2) {
    $u_0_ = (*fileno_);
    _fcheck ("odrpack:dodpe3:31", $u_0_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodpe3:31", $u_0_));
      __fcnt += 3;
    }
    _write_eol ($u_0_);
  }
  else if ((*d2_) == 3) {
    $u_1_ = (*fileno_);
    _fcheck ("odrpack:dodpe3:33", $u_1_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_1_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodpe3:33", $u_1_));
      __fcnt += 3;
    }
    _write_eol ($u_1_);
  }
  else if ((*d2_) == 4) {
    $u_2_ = (*fileno_);
    _fcheck ("odrpack:dodpe3:35", $u_2_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1300_[__fcnt] != NULL && $f_1300_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_2_, $f_1300_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_2_, _ioerr_write ("odrpack:dodpe3:35", $u_2_));
      __fcnt += 3;
    }
    _write_eol ($u_2_);
  }
  if ((*d3_) == 2) {
    $u_3_ = (*fileno_);
    _fcheck ("odrpack:dodpe3:38", $u_3_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1400_[__fcnt] != NULL && $f_1400_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_3_, $f_1400_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_3_, _ioerr_write ("odrpack:dodpe3:38", $u_3_));
      __fcnt += 3;
    }
    _write_eol ($u_3_);
  }
  _l1100:;
  _l1200:;
  _l1300:;
  _l1400:;
  __calls[32].calls++;
  return 0;
}
int_4 _dodper (int_4 _p_ info_, int_4 _p_ lunerr_, logical_4 _p_ short_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, 
int_4 _p_ nq_, int_4 _p_ ldscld_, int_4 _p_ ldstpd_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, int_4 _p_ ldwd_, int_4 _p_ 
ld2wd_, int_4 _p_ lwkmn_, int_4 _p_ liwkmn_, real_8 _p_ fjacb_, real_8 _p_ fjacd_, real_8 _p_ diff_, int_4 _p_ msgb_, 
logical_4 _p_ isodr_, int_4 _p_ msgd_, real_8 _p_ xplusd_, int_4 _p_ nrow_, int_4 _p_ neta_, int_4 _p_ ntol_)
{
  static int_4 d1_, d2_, d3_, d4_, d5_, fileno_;
  static logical_4 head_;
  int_4 $u_0_, __fcnt, __rc, $u_1_;
  static FORMAT $f_1100_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_438, _dc_438,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_439, _dc_439,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_440, _dc_440,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_441, _dc_441,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_442, _dc_442,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_443, _dc_443,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_444, _dc_444,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_445, _dc_445,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_446, _dc_446,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_447, _dc_447,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_448, _dc_448,
    NULL, NULL, NULL
  };
  static FORMAT $f_1200_[] = {
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_438, _dc_438,
    FMT_TEXT,"\n","\n",
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_449, _dc_449,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_440, _dc_440,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_441, _dc_441,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_442, _dc_442,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_443, _dc_443,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_444, _dc_444,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_450, _dc_450,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_451, _dc_451,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_452, _dc_452,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_446, _dc_446,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_453, _dc_453,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_454, _dc_454,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_447, _dc_447,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_448, _dc_448,
    NULL, NULL, NULL
  };
  if ((*lunerr_) == 0) {
    goto _l0;
  }
  else if ((*lunerr_) < 0) {
    fileno_ = 6;
  }
  else {
    fileno_ = (*lunerr_);
  }
  head_ = TRUE;
  (void) _dodphd (&head_, &fileno_);
  d1_ = _imod ((*info_), 100000) / 10000;
  d2_ = _imod ((*info_), 10000) / 1000;
  d3_ = _imod ((*info_), 1000) / 100;
  d4_ = _imod ((*info_), 100) / 10;
  d5_ = _imod ((*info_), 10);
  if (d1_ >= 1 && d1_ <= 3) {
    (void) _dodpe1 (&fileno_, &d1_, &d2_, &d3_, &d4_, &d5_, n_, m_, nq_, ldscld_, ldstpd_, ldwe_, ld2we_, ldwd_, ld2wd_, 
    lwkmn_, liwkmn_);
  }
  else if ((d1_ == 4) || (msgb_[0] >= 0)) {
    (void) _dodpe2 (&fileno_, n_, m_, np_, nq_, fjacb_, fjacd_, diff_, &msgb_[0], &msgb_[1], isodr_, &msgd_[0], &msgd_[1], 
    xplusd_, nrow_, neta_, ntol_);
  }
  else if (d1_ == 5) {
    (void) _dodpe3 (&fileno_, &d2_, &d3_);
  }
  if ((d1_ >= 1 && d1_ <= 3) || (d1_ == 4 && (d2_ == 2 || d3_ == 2)) || (d1_ == 5)) {
    if ((*short_)) {
      $u_0_ = fileno_;
      _fcheck ("odrpack:dodper:153", $u_0_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1100_[__fcnt] != NULL && $f_1100_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_0_, $f_1100_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodper:153", $u_0_));
        __fcnt += 3;
      }
      _write_eol ($u_0_);
    }
    else {
      $u_1_ = fileno_;
      _fcheck ("odrpack:dodper:155", $u_1_, action_write, form_formatted);
      __fcnt = 0;
      while ($f_1200_[__fcnt] != NULL && $f_1200_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf ($u_1_, $f_1200_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, $u_1_, _ioerr_write ("odrpack:dodper:155", $u_1_));
        __fcnt += 3;
      }
      _write_eol ($u_1_);
    }
  }
  goto _l0;
  _l1100:;
  _l1200:;
  _l0:;
  __calls[33].calls++;
  return 0;
}

int_4 _dodphd (logical_4 _p_ head_, int_4 _p_ fileno_)
{
  int_4 $u_0_, __fcnt, __rc;
  static FORMAT $f_1000_[] = {
    FMT_TEXT, _dc_455, _dc_455,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_456, _dc_456,
    FMT_TEXT,"\n","\n",
    FMT_TEXT, _dc_455, _dc_455,
    FMT_TEXT,"\n","\n",
    NULL, NULL, NULL
  };
  if ((*head_)) {
    $u_0_ = (*fileno_);
    _fcheck ("odrpack:dodphd:29", $u_0_, action_write, form_formatted);
    __fcnt = 0;
    while ($f_1000_[__fcnt] != NULL && $f_1000_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf ($u_0_, $f_1000_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, $u_0_, _ioerr_write ("odrpack:dodphd:29", $u_0_));
      __fcnt += 3;
    }
    _write_eol ($u_0_);
    (*head_) = FALSE;
  }
  goto _l0;
  _l1000:;
  _l0:;
  __calls[34].calls++;
  return 0;
}

int_4 _dodrc (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
y_, int_4 _p_ ldy_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, 
int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ job_, int_4 _p_ 
ndigit_, real_8 _p_ taufac_, real_8 _p_ sstol_, real_8 _p_ partol_, int_4 _p_ maxit_, int_4 _p_ iprint_, int_4 _p_ 
lunerr_, int_4 _p_ lunrpt_, real_8 _p_ stpb_, real_8 _p_ stpd_, int_4 _p_ ldstpd_, real_8 _p_ sclb_, real_8 _p_ scld_, 
int_4 _p_ ldscld_, real_8 _p_ work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ info_)
{
  static logical_4 short_;
  static real_8 negone_, zero_, wd1_[1];
  int_4 _data_k_23;
#define _data_n_23 2
  static real_8 _data_l_23[_data_n_23] = {
    -1.0e0,
    0.0e0
  };
  if (__calls[35].calls == 0) {
    _data_k_23 = 0;
    if (_data_k_23 >= _data_n_23) {
      _data_k_23 = 0;
    }
    negone_ = _data_l_23[_data_k_23++];
    if (_data_k_23 >= _data_n_23) {
      _data_k_23 = 0;
    }
    zero_ = _data_l_23[_data_k_23++];
  }
  short_ = FALSE;
  if (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))] != zero_) {
    (void) _dodcnt (&short_, _fcn, n_, m_, np_, nq_, beta_, y_, ldy_, x_, ldx_, we_, ldwe_, ld2we_, wd_, ldwd_, ld2wd_, 
    ifixb_, ifixx_, ldifx_, job_, ndigit_, taufac_, sstol_, partol_, maxit_, iprint_, lunerr_, lunrpt_, stpb_, stpd_, 
    ldstpd_, sclb_, scld_, ldscld_, work_, lwork_, iwork_, liwork_, info_);
  }
  else {
    wd1_[0] = negone_;
    (void) _dodcnt (&short_, _fcn, n_, m_, np_, nq_, beta_, y_, ldy_, x_, ldx_, we_, ldwe_, ld2we_, wd1_, &_k1, &_k1, 
    ifixb_, ifixx_, ldifx_, job_, ndigit_, taufac_, sstol_, partol_, maxit_, iprint_, lunerr_, lunrpt_, stpb_, stpd_, 
    ldstpd_, sclb_, scld_, ldscld_, work_, lwork_, iwork_, liwork_, info_);
  }
  __calls[35].calls++;
  return 0;
}

int_4 _dodr (real_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
y_, int_4 _p_ ldy_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ we_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, real_8 _p_ wd_, 
int_4 _p_ ldwd_, int_4 _p_ ld2wd_, int_4 _p_ job_, int_4 _p_ iprint_, int_4 _p_ lunerr_, int_4 _p_ lunrpt_, real_8 _p_ 
work_, int_4 _p_ lwork_, int_4 _p_ iwork_, int_4 _p_ liwork_, int_4 _p_ info_)
{
  static int_4 ndigit_, ldifx_, ldscld_, ldstpd_, maxit_, ifixb_[1], ifixx_[1];
  static logical_4 short_;
  static real_8 negone_, partol_, sstol_, taufac_, zero_, sclb_[1], scld_[1], stpb_[1], stpd_[1], wd1_[1];
  int_4 _data_k_24;
#define _data_n_24 2
  static real_8 _data_l_24[_data_n_24] = {
    -1.0e0,
    0.0e0
  };
  if (__calls[36].calls == 0) {
    _data_k_24 = 0;
    if (_data_k_24 >= _data_n_24) {
      _data_k_24 = 0;
    }
    negone_ = _data_l_24[_data_k_24++];
    if (_data_k_24 >= _data_n_24) {
      _data_k_24 = 0;
    }
    zero_ = _data_l_24[_data_k_24++];
  }
  ifixb_[0] = -1;
  ifixx_[0] = -1;
  ldifx_ = 1;
  ndigit_ = -1;
  taufac_ = negone_;
  sstol_ = negone_;
  partol_ = negone_;
  maxit_ = -1;
  stpb_[0] = negone_;
  stpd_[0] = negone_;
  ldstpd_ = 1;
  sclb_[0] = negone_;
  scld_[0] = negone_;
  ldscld_ = 1;
  short_ = TRUE;
  if (wd_[0 + ((*ldwd_)) * ((0) + ((*ld2wd_)) * ((0)))] != zero_) {
    (void) _dodcnt (&short_, _fcn, n_, m_, np_, nq_, beta_, y_, ldy_, x_, ldx_, we_, ldwe_, ld2we_, wd_, ldwd_, ld2wd_, 
    ifixb_, ifixx_, &ldifx_, job_, &ndigit_, &taufac_, &sstol_, &partol_, &maxit_, iprint_, lunerr_, lunrpt_, stpb_, stpd_, 
    &ldstpd_, sclb_, scld_, &ldscld_, work_, lwork_, iwork_, liwork_, info_);
  }
  else {
    wd1_[0] = negone_;
    (void) _dodcnt (&short_, _fcn, n_, m_, np_, nq_, beta_, y_, ldy_, x_, ldx_, we_, ldwe_, ld2we_, wd1_, &_k1, &_k1, 
    ifixb_, ifixx_, &ldifx_, job_, &ndigit_, &taufac_, &sstol_, &partol_, &maxit_, iprint_, lunerr_, lunrpt_, stpb_, stpd_, 
    &ldstpd_, sclb_, scld_, &ldscld_, work_, lwork_, iwork_, liwork_, info_);
  }
  __calls[36].calls++;
  return 0;
}

int_4 _dodstp (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, real_8 _p_ f_, real_8 _p_ 
fjacb_, real_8 _p_ fjacd_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ ss_, real_8 _p_ tt_, int_4 _p_ 
ldtt_, real_8 _p_ delta_, real_8 _p_ alpha_, real_8 _p_ epsfcn_, logical_4 _p_ isodr_, real_8 _p_ tfjacb_, real_8 _p_ 
omega_, real_8 _p_ u_, real_8 _p_ qraux_, int_4 _p_ kpvt_, real_8 _p_ s_, real_8 _p_ t_, real_8 _p_ phi_, int_4 _p_ 
irank_, real_8 _p_ rcond_, logical_4 _p_ forvcv_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ 
wrk4_, real_8 _p_ wrk5_, real_8 _p_ wrk_, int_4 _p_ lwrk_, int_4 _p_ istopc_)
{
  static int_4 i_, imax_, inf_, ipvt_, j_, k_, k1_, k2_, kp_, l_;
  static logical_4 elim_;
  static real_8 co_, one_, si_, temp_, zero_, dum_[2];
  int_4 _data_k_25, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, 
  $21_, $22_, $23_, $24_, $25_;
  logical_4 $0_, $1_, $20_;
  extern real_8 _dnrm2 ();
  extern int_4 _idamax ();
  extern int_4 _dchex ();
  extern int_4 _dqrdc ();
  extern int_4 _dqrsl ();
  extern int_4 _drot ();
  extern int_4 _drotg ();
  extern int_4 _dtrco ();
  extern int_4 _dtrsl ();
#define _data_n_25 2
  static real_8 _data_l_25[_data_n_25] = {
    0.0e0,
    1.0e0
  };
  if (__calls[37].calls == 0) {
    _data_k_25 = 0;
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    zero_ = _data_l_25[_data_k_25++];
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    one_ = _data_l_25[_data_k_25++];
  }
  if ((*alpha_) == zero_) {
    kp_ = (*npp_);
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      kpvt_[k_ - 1] = k_;
    }
  }
  else {
    if ((*npp_) >= 1) {
      kp_ = (*npp_) - (*irank_);
    }
    else {
      kp_ = (*npp_);
    }
  }
  if ((*isodr_)) {
    (void) _dwght (n_, m_, wd_, ldwd_, ld2wd_, delta_, n_, t_, n_);
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      (void) _desubi (n_, m_, wd_, ldwd_, ld2wd_, alpha_, tt_, ldtt_, &i_, wrk4_);
      (void) _dfctr (($0_ = FALSE, &$0_), wrk4_, m_, m_, &inf_);
      if (inf_ != 0) {
        (*istopc_) = 60000;
        goto _l0;
      }
      (void) _dvevtr (m_, nq_, &i_, fjacd_, n_, m_, wrk4_, m_, wrk1_, n_, nq_, omega_, nq_, wrk5_);
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        omega_[l_ - 1 + ((*nq_)) * ((l_ - 1))] = one_ + omega_[l_ - 1 + ((*nq_)) * ((l_ - 1))];
      }
      (void) _dfctr (($1_ = FALSE, &$1_), omega_, nq_, nq_, &inf_);
      if (inf_ != 0) {
        (*istopc_) = 60000;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          wrk1_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((j_ - 1)))] = fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 
          1)))];
        }
        (void) _dsolve (nq_, omega_, nq_, &wrk1_[i_ - 1 + ((*n_)) * ((0) + ((*nq_)) * ((j_ - 1)))], n_, ($2_ = 4, &$2_));
        (void) _dsolve (nq_, omega_, nq_, &wrk1_[i_ - 1 + ((*n_)) * ((0) + ((*nq_)) * ((j_ - 1)))], n_, ($3_ = 2, &$3_));
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        wrk5_[j_ - 1] = t_[i_ - 1 + ((*n_)) * ((j_ - 1))];
      }
      (void) _dsolve (m_, wrk4_, m_, wrk5_, &_k1, ($4_ = 4, &$4_));
      (void) _dsolve (m_, wrk4_, m_, wrk5_, &_k1, ($5_ = 2, &$5_));
      for (k_ = 1; k_ <= kp_; (k_)++) {
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ - 1)))] = fjacb_[i_ - 1 + ((*n_)) * ((kpvt_[k_ - 1] - 1) + 
          ((*np_)) * ((l_ - 1)))];
        }
        (void) _dsolve (nq_, omega_, nq_, &tfjacb_[i_ - 1 + ((*n_)) * ((0) + ((*nq_)) * ((k_ - 1)))], n_, ($6_ = 4, &$6_));
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          if (ss_[0] > zero_) {
            tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ - 1)))] = tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ 
            - 1)))] / ss_[kpvt_[k_ - 1] - 1];
          }
          else {
            tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ - 1)))] = tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ 
            - 1)))] / _abs (ss_[0]);
          }
        }
      }
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] = zero_;
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] = wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] + fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + 
          ((*m_)) * ((l_ - 1)))] * wrk5_[j_ - 1];
        }
        wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] = wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] - f_[i_ - 1 + ((*n_)) * ((l_ - 1))];
      }
      (void) _dsolve (nq_, omega_, nq_, &wrk2_[i_ - 1 + ((*n_)) * ((0))], n_, ($7_ = 4, &$7_));
    }
  }
  else {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        for (k_ = 1; k_ <= kp_; (k_)++) {
          tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ - 1)))] = fjacb_[i_ - 1 + ((*n_)) * ((kpvt_[k_ - 1] - 1) + 
          ((*np_)) * ((l_ - 1)))];
          if (ss_[0] > zero_) {
            tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ - 1)))] = tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ 
            - 1)))] / ss_[kpvt_[k_ - 1] - 1];
          }
          else {
            tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ - 1)))] = tfjacb_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((k_ 
            - 1)))] / _abs (ss_[0]);
          }
        }
        wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] = -f_[i_ - 1 + ((*n_)) * ((l_ - 1))];
      }
    }
  }
  if ((*alpha_) == zero_) {
    ipvt_ = 1;
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      kpvt_[k_ - 1] = 0;
    }
  }
  else {
    ipvt_ = 0;
  }
  (void) _dqrdc (tfjacb_, ($8_ = (*n_) * (*nq_), &$8_), ($9_ = (*n_) * (*nq_), &$9_), &kp_, qraux_, kpvt_, wrk3_, &ipvt_)
  ;
  (void) _dqrsl (tfjacb_, ($10_ = (*n_) * (*nq_), &$10_), ($11_ = (*n_) * (*nq_), &$11_), &kp_, qraux_, wrk2_, dum_, 
  wrk2_, dum_, dum_, dum_, ($12_ = 1000, &$12_), &inf_);
  if (inf_ != 0) {
    (*istopc_) = 60000;
    goto _l0;
  }
  if ((*alpha_) != zero_) {
    (void) _dzero (npp_, &_k1, s_, npp_);
    for (k1_ = 1; k1_ <= kp_; (k1_)++) {
      (void) _dzero (&kp_, &_k1, wrk3_, &kp_);
      wrk3_[k1_ - 1] = sqrt ((*alpha_));
      for (k2_ = k1_; k2_ <= kp_; (k2_)++) {
        (void) _drotg (&tfjacb_[k2_ - 1 + ((*n_)) * ((0) + ((*nq_)) * ((k2_ - 1)))], &wrk3_[k2_ - 1], &co_, &si_);
        if (kp_ - k2_ >= 1) {
          (void) _drot (($13_ = kp_ - k2_, &$13_), &tfjacb_[k2_ - 1 + ((*n_)) * ((0) + ((*nq_)) * ((k2_ + 1 - 1)))], ($14_ = 
          (*n_) * (*nq_), &$14_), &wrk3_[k2_ + 1 - 1], &_k1, &co_, &si_);
        }
        temp_ = co_ * wrk2_[k2_ - 1 + ((*n_)) * ((0))] + si_ * s_[kpvt_[k1_ - 1] - 1];
        s_[kpvt_[k1_ - 1] - 1] = -si_ * wrk2_[k2_ - 1 + ((*n_)) * ((0))] + co_ * s_[kpvt_[k1_ - 1] - 1];
        wrk2_[k2_ - 1 + ((*n_)) * ((0))] = temp_;
      }
    }
  }
  if ((*npp_) >= 1) {
    if ((*alpha_) == zero_) {
      kp_ = (*npp_);
      _l440:;
      (void) _dtrco (tfjacb_, ($15_ = (*n_) * (*nq_), &$15_), &kp_, rcond_, u_, &_k1);
      if ((*rcond_) <= (*epsfcn_)) {
        elim_ = TRUE;
        imax_ = _idamax (&kp_, u_, &_k1);
        if (imax_ != kp_) {
          (void) _dchex (tfjacb_, ($16_ = (*n_) * (*nq_), &$16_), &kp_, &imax_, &kp_, wrk2_, ($17_ = (*n_) * (*nq_), &$17_), 
          &_k1, qraux_, wrk3_, ($18_ = 2, &$18_));
          k_ = kpvt_[imax_ - 1];
          for (i_ = imax_; i_ <= kp_ - 1; (i_)++) {
            kpvt_[i_ - 1] = kpvt_[i_ + 1 - 1];
          }
          kpvt_[kp_ - 1] = k_;
        }
        kp_ = kp_ - 1;
      }
      else {
        elim_ = FALSE;
      }
      if (elim_ && kp_ >= 1) {
        goto _l440;
      }
      else {
        (*irank_) = (*npp_) - kp_;
      }
    }
  }
  if ((*forvcv_)) {
    goto _l0;
  }
  if ((*npp_) >= 1) {
    for (i_ = kp_ + 1; i_ <= (*npp_); (i_)++) {
      wrk2_[i_ - 1 + ((*n_)) * ((0))] = zero_;
    }
    if (kp_ >= 1) {
      (void) _dtrsl (tfjacb_, ($19_ = (*n_) * (*nq_), &$19_), &kp_, wrk2_, &_k1, &inf_);
      if (inf_ != 0) {
        (*istopc_) = 60000;
        goto _l0;
      }
    }
    for (i_ = 1; i_ <= (*npp_); (i_)++) {
      if (ss_[0] > zero_) {
        s_[kpvt_[i_ - 1] - 1] = wrk2_[i_ - 1 + ((*n_)) * ((0))] / ss_[kpvt_[i_ - 1] - 1];
      }
      else {
        s_[kpvt_[i_ - 1] - 1] = wrk2_[i_ - 1 + ((*n_)) * ((0))] / _abs (ss_[0]);
      }
    }
  }
  if ((*isodr_)) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      (void) _desubi (n_, m_, wd_, ldwd_, ld2wd_, alpha_, tt_, ldtt_, &i_, wrk4_);
      (void) _dfctr (($20_ = FALSE, &$20_), wrk4_, m_, m_, &inf_);
      if (inf_ != 0) {
        (*istopc_) = 60000;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        wrk5_[j_ - 1] = t_[i_ - 1 + ((*n_)) * ((j_ - 1))];
      }
      (void) _dsolve (m_, wrk4_, m_, wrk5_, &_k1, ($21_ = 4, &$21_));
      (void) _dsolve (m_, wrk4_, m_, wrk5_, &_k1, ($22_ = 2, &$22_));
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] = f_[i_ - 1 + ((*n_)) * ((l_ - 1))];
        for (k_ = 1; k_ <= (*npp_); (k_)++) {
          wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] = wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] + fjacb_[i_ - 1 + ((*n_)) * ((k_ - 1) + 
          ((*np_)) * ((l_ - 1)))] * s_[k_ - 1];
        }
        for (j_ = 1; j_ <= (*m_); (j_)++) {
          wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] = wrk2_[i_ - 1 + ((*n_)) * ((l_ - 1))] - fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + 
          ((*m_)) * ((l_ - 1)))] * wrk5_[j_ - 1];
        }
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        wrk5_[j_ - 1] = zero_;
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          wrk5_[j_ - 1] = wrk5_[j_ - 1] + wrk1_[i_ - 1 + ((*n_)) * ((l_ - 1) + ((*nq_)) * ((j_ - 1)))] * wrk2_[i_ - 1 + ((*n_)) * 
          ((l_ - 1))];
        }
        t_[i_ - 1 + ((*n_)) * ((j_ - 1))] = -(wrk5_[j_ - 1] + t_[i_ - 1 + ((*n_)) * ((j_ - 1))]);
      }
      (void) _dsolve (m_, wrk4_, m_, &t_[i_ - 1 + ((*n_)) * ((0))], n_, ($23_ = 4, &$23_));
      (void) _dsolve (m_, wrk4_, m_, &t_[i_ - 1 + ((*n_)) * ((0))], n_, ($24_ = 2, &$24_));
    }
  }
  (void) _dwght (npp_, &_k1, ss_, npp_, &_k1, s_, npp_, wrk_, npp_);
  if ((*isodr_)) {
    (void) _dwght (n_, m_, tt_, ldtt_, &_k1, t_, n_, &wrk_[(*npp_) + 1 - 1], n_);
    (*phi_) = _dnrm2 (($25_ = (*npp_) + (*n_) * (*m_), &$25_), wrk_, &_k1);
  }
  else {
    (*phi_) = _dnrm2 (npp_, wrk_, &_k1);
  }
  _l0:;
  __calls[37].calls++;
  return 0;
}

int_4 _dodvcv (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ npp_, real_8 _p_ f_, real_8 _p_ 
fjacb_, real_8 _p_ fjacd_, real_8 _p_ wd_, int_4 _p_ ldwd_, int_4 _p_ ld2wd_, real_8 _p_ ssf_, real_8 _p_ ss_, real_8 
_p_ tt_, int_4 _p_ ldtt_, real_8 _p_ delta_, real_8 _p_ epsfcn_, logical_4 _p_ isodr_, real_8 _p_ vcv_, real_8 _p_ sd_, 
real_8 _p_ wrk6_, real_8 _p_ omega_, real_8 _p_ u_, real_8 _p_ qraux_, int_4 _p_ jpvt_, real_8 _p_ s_, real_8 _p_ t_, 
int_4 _p_ irank_, real_8 _p_ rcond_, real_8 _p_ rss_, int_4 _p_ idf_, real_8 _p_ rvar_, int_4 _p_ ifixb_, real_8 _p_ 
wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk3_, real_8 _p_ wrk4_, real_8 _p_ wrk5_, real_8 _p_ wrk_, int_4 _p_ lwrk_, int_4 
_p_ istopc_)
{
  static int_4 i_, iunfix_, j_, junfix_, kp_, l_;
  static logical_4 forvcv_;
  static real_8 temp_, zero_;
  int_4 _data_k_26, $0_;
  extern int_4 _dpodi ();
#define _data_n_26 1
  static real_8 _data_l_26[_data_n_26] = {
    0.0e0
  };
  if (__calls[38].calls == 0) {
    _data_k_26 = 0;
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    zero_ = _data_l_26[_data_k_26++];
  }
  forvcv_ = TRUE;
  (*istopc_) = 0;
  (void) _dodstp (n_, m_, np_, nq_, npp_, f_, fjacb_, fjacd_, wd_, ldwd_, ld2wd_, ss_, tt_, ldtt_, delta_, &zero_, 
  epsfcn_, isodr_, wrk6_, omega_, u_, qraux_, jpvt_, s_, t_, &temp_, irank_, rcond_, &forvcv_, wrk1_, wrk2_, wrk3_, 
  wrk4_, wrk5_, wrk_, lwrk_, istopc_);
  if ((*istopc_) != 0) {
    goto _l0;
  }
  kp_ = (*npp_) - (*irank_);
  (void) _dpodi (wrk6_, ($0_ = (*n_) * (*nq_), &$0_), &kp_, wrk3_, &_k1);
  (*idf_) = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*npp_); (j_)++) {
      for (l_ = 1; l_ <= (*nq_); (l_)++) {
        if (fjacb_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*np_)) * ((l_ - 1)))] != zero_) {
          (*idf_) = (*idf_) + 1;
          goto _l150;
        }
      }
    }
    if ((*isodr_)) {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (l_ = 1; l_ <= (*nq_); (l_)++) {
          if (fjacd_[i_ - 1 + ((*n_)) * ((j_ - 1) + ((*m_)) * ((l_ - 1)))] != zero_) {
            (*idf_) = (*idf_) + 1;
            goto _l150;
          }
        }
      }
    }
    _l150:;
  }
  if ((*idf_) > kp_) {
    (*idf_) = (*idf_) - kp_;
    (*rvar_) = (*rss_) / (*idf_);
  }
  else {
    (*idf_) = 0;
    (*rvar_) = (*rss_);
  }
  for (i_ = 1; i_ <= (*np_); (i_)++) {
    sd_[i_ - 1] = zero_;
  }
  for (i_ = 1; i_ <= kp_; (i_)++) {
    sd_[jpvt_[i_ - 1] - 1] = wrk6_[i_ - 1 + ((*n_) * (*nq_)) * ((i_ - 1))];
  }
  if ((*np_) > (*npp_)) {
    junfix_ = (*npp_);
    for (j_ = (*np_); j_ >= 1; (j_)--) {
      if (ifixb_[j_ - 1] == 0) {
        sd_[j_ - 1] = zero_;
      }
      else {
        sd_[j_ - 1] = sd_[junfix_ - 1];
        junfix_ = junfix_ - 1;
      }
    }
  }
  for (i_ = 1; i_ <= (*np_); (i_)++) {
    for (j_ = 1; j_ <= i_; (j_)++) {
      vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))] = zero_;
    }
  }
  for (i_ = 1; i_ <= kp_; (i_)++) {
    for (j_ = i_ + 1; j_ <= kp_; (j_)++) {
      if (jpvt_[i_ - 1] > jpvt_[j_ - 1]) {
        vcv_[jpvt_[i_ - 1] - 1 + ((*np_)) * ((jpvt_[j_ - 1] - 1))] = wrk6_[i_ - 1 + ((*n_) * (*nq_)) * ((j_ - 1))];
      }
      else {
        vcv_[jpvt_[j_ - 1] - 1 + ((*np_)) * ((jpvt_[i_ - 1] - 1))] = wrk6_[i_ - 1 + ((*n_) * (*nq_)) * ((j_ - 1))];
      }
    }
  }
  if ((*np_) > (*npp_)) {
    iunfix_ = (*npp_);
    for (i_ = (*np_); i_ >= 1; (i_)--) {
      if (ifixb_[i_ - 1] == 0) {
        for (j_ = i_; j_ >= 1; (j_)--) {
          vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))] = zero_;
        }
      }
      else {
        junfix_ = (*npp_);
        for (j_ = (*np_); j_ >= 1; (j_)--) {
          if (ifixb_[j_ - 1] == 0) {
            vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))] = zero_;
          }
          else {
            vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))] = vcv_[iunfix_ - 1 + ((*np_)) * ((junfix_ - 1))];
            junfix_ = junfix_ - 1;
          }
        }
        iunfix_ = iunfix_ - 1;
      }
    }
  }
  for (i_ = 1; i_ <= (*np_); (i_)++) {
    vcv_[i_ - 1 + ((*np_)) * ((i_ - 1))] = sd_[i_ - 1];
    sd_[i_ - 1] = sqrt ((*rvar_) * sd_[i_ - 1]);
    for (j_ = 1; j_ <= i_; (j_)++) {
      vcv_[j_ - 1 + ((*np_)) * ((i_ - 1))] = vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))];
    }
  }
  for (i_ = 1; i_ <= (*np_); (i_)++) {
    if (ssf_[0] > zero_) {
      sd_[i_ - 1] = sd_[i_ - 1] / ssf_[i_ - 1];
    }
    else {
      sd_[i_ - 1] = sd_[i_ - 1] / _abs (ssf_[0]);
    }
    for (j_ = 1; j_ <= (*np_); (j_)++) {
      if (ssf_[0] > zero_) {
        vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))] = vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))] / (ssf_[i_ - 1] * ssf_[j_ - 1]);
      }
      else {
        vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))] = vcv_[i_ - 1 + ((*np_)) * ((j_ - 1))] / (ssf_[0] * ssf_[0]);
      }
    }
  }
  _l0:;
  __calls[38].calls++;
  return 0;
}
int_4 _dpack (int_4 _p_ n2_, int_4 _p_ n1_, real_8 _p_ v1_, real_8 _p_ v2_, int_4 _p_ ifix_)
{
  static int_4 i_;
  extern int_4 _dcopy ();
  (*n1_) = 0;
  if (ifix_[0] >= 0) {
    for (i_ = 1; i_ <= (*n2_); (i_)++) {
      if (ifix_[i_ - 1] != 0) {
        (*n1_) = (*n1_) + 1;
        v1_[(*n1_) - 1] = v2_[i_ - 1];
      }
    }
  }
  else {
    (*n1_) = (*n2_);
    (void) _dcopy (n2_, v2_, &_k1, v1_, &_k1);
  }
  __calls[39].calls++;
  return 0;
}

real_8 _dppnml (real_8 _p_ p_)
{
  static real_8 aden_, anum_, half_, one_, p0_, p1_, p2_, p3_, p4_, q0_, q1_, q2_, q3_, q4_, r_, t_, two_, zero_;
  int_4 _data_k_27, _data_k_28, _data_k_29;
  real_8 dppnml_;
#define _data_n_27 5
  static real_8 _data_l_27[_data_n_27] = {
    -0.322232431088e0,
    -1.0e0,
    -0.342242088547e0,
    -0.204231210245e-1,
    -0.453642210148e-4
  };
#define _data_n_28 5
  static real_8 _data_l_28[_data_n_28] = {
    0.99348462606e-1,
    0.588581570495e0,
    0.531103462366e0,
    0.10353775285e0,
    0.38560700634e-2
  };
#define _data_n_29 4
  static real_8 _data_l_29[_data_n_29] = {
    0.0e0,
    0.5e0,
    1.0e0,
    2.0e0
  };
  if (__calls[40].calls == 0) {
    _data_k_27 = 0;
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    p0_ = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    p1_ = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    p2_ = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    p3_ = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    p4_ = _data_l_27[_data_k_27++];
  }
  if (__calls[40].calls == 0) {
    _data_k_28 = 0;
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    q0_ = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    q1_ = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    q2_ = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    q3_ = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    q4_ = _data_l_28[_data_k_28++];
  }
  if (__calls[40].calls == 0) {
    _data_k_29 = 0;
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    zero_ = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    half_ = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    one_ = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    two_ = _data_l_29[_data_k_29++];
  }
  if ((*p_) == half_) {
    dppnml_ = zero_;
  }
  else {
    r_ = (*p_);
    if ((*p_) > half_) {
      r_ = one_ - r_;
    }
    t_ = sqrt (-two_ * log (r_));
    anum_ = ((((t_ * p4_ + p3_) * t_ + p2_) * t_ + p1_) * t_ + p0_);
    aden_ = ((((t_ * q4_ + q3_) * t_ + q2_) * t_ + q1_) * t_ + q0_);
    dppnml_ = t_ + (anum_ / aden_);
    if ((*p_) < half_) {
      dppnml_ = -dppnml_;
    }
  }
  __calls[40].calls++;
  return dppnml_;
}

real_8 _dppt (real_8 _p_ p_, int_4 _p_ idf_)
{
  static int_4 ipass_, maxit_;
  static real_8 arg_, b21_, b31_, b32_, b33_, b34_, b41_, b42_, b43_, b44_, b45_, b51_, b52_, b53_, b54_, b55_, b56_, c_, 
  con_, d1_, d3_, d5_, d7_, d9_, df_, eight_, fiftn_, half_, one_, pi_, ppfn_, s_, term1_, term2_, term3_, term4_, term5_
  , three_, two_, z_, zero_;
  int_4 _data_k_30, _data_k_31, _data_k_32, _data_k_33, _data_k_34;
  real_8 $0_, $1_, $2_, $3_, $4_;
  real_8 dppt_;
#define _data_n_30 1
  static real_8 _data_l_30[_data_n_30] = {
    4.0e0
  };
#define _data_n_31 4
  static real_8 _data_l_31[_data_n_31] = {
    96.0e0,
    5.0e0,
    16.0e0,
    3.0e0
  };
#define _data_n_32 5
  static real_8 _data_l_32[_data_n_32] = {
    384.0e0,
    3.0e0,
    19.0e0,
    17.0e0,
    -15.0e0
  };
#define _data_n_33 6
  static real_8 _data_l_33[_data_n_33] = {
    9216.0e0,
    79.0e0,
    776.0e0,
    1482.0e0,
    -1920.0e0,
    -945.0e0
  };
#define _data_n_34 7
  static real_8 _data_l_34[_data_n_34] = {
    0.0e0,
    0.5e0,
    1.0e0,
    2.0e0,
    3.0e0,
    8.0e0,
    15.0e0
  };
  if (__calls[41].calls == 0) {
    _data_k_30 = 0;
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    b21_ = _data_l_30[_data_k_30++];
  }
  if (__calls[41].calls == 0) {
    _data_k_31 = 0;
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    b31_ = _data_l_31[_data_k_31++];
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    b32_ = _data_l_31[_data_k_31++];
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    b33_ = _data_l_31[_data_k_31++];
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    b34_ = _data_l_31[_data_k_31++];
  }
  if (__calls[41].calls == 0) {
    _data_k_32 = 0;
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    b41_ = _data_l_32[_data_k_32++];
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    b42_ = _data_l_32[_data_k_32++];
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    b43_ = _data_l_32[_data_k_32++];
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    b44_ = _data_l_32[_data_k_32++];
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    b45_ = _data_l_32[_data_k_32++];
  }
  if (__calls[41].calls == 0) {
    _data_k_33 = 0;
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    b51_ = _data_l_33[_data_k_33++];
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    b52_ = _data_l_33[_data_k_33++];
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    b53_ = _data_l_33[_data_k_33++];
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    b54_ = _data_l_33[_data_k_33++];
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    b55_ = _data_l_33[_data_k_33++];
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    b56_ = _data_l_33[_data_k_33++];
  }
  if (__calls[41].calls == 0) {
    _data_k_34 = 0;
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    zero_ = _data_l_34[_data_k_34++];
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    half_ = _data_l_34[_data_k_34++];
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    one_ = _data_l_34[_data_k_34++];
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    two_ = _data_l_34[_data_k_34++];
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    three_ = _data_l_34[_data_k_34++];
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    eight_ = _data_l_34[_data_k_34++];
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    fiftn_ = _data_l_34[_data_k_34++];
  }
  pi_ = 3.1415926535897932;
  df_ = (*idf_);
  maxit_ = 5;
  if ((*idf_) <= 0) {
    dppt_ = zero_;
  }
  else if ((*idf_) == 1) {
    arg_ = pi_ * (*p_);
    dppt_ = -cos (arg_) / sin (arg_);
  }
  else if ((*idf_) == 2) {
    term1_ = sqrt (two_) / two_;
    term2_ = two_ * (*p_) - one_;
    term3_ = sqrt ((*p_) * (one_ - (*p_)));
    dppt_ = term1_ * term2_ / term3_;
  }
  else if ((*idf_) >= 3) {
    ppfn_ = _dppnml (p_);
    d1_ = ppfn_;
    d3_ = (ppfn_ * ppfn_ * ppfn_);
    d5_ = ($0_ = ppfn_ * ppfn_, ppfn_ * $0_ * $0_);
    d7_ = _up_real_8 (ppfn_, 7);
    d9_ = _up_real_8 (ppfn_, 9);
    term1_ = d1_;
    term2_ = (one_ / b21_) * (d3_ + d1_) / df_;
    term3_ = (one_ / b31_) * (b32_ * d5_ + b33_ * d3_ + b34_ * d1_) / ((df_ * df_));
    term4_ = (one_ / b41_) * (b42_ * d7_ + b43_ * d5_ + b44_ * d3_ + b45_ * d1_) / ((df_ * df_ * df_));
    term5_ = (one_ / b51_) * (b52_ * d9_ + b53_ * d7_ + b54_ * d5_ + b55_ * d3_ + b56_ * d1_) / (($1_ = df_ * df_, $1_ * 
    $1_));
    dppt_ = term1_ + term2_ + term3_ + term4_ + term5_;
    if ((*idf_) == 3) {
      con_ = pi_ * ((*p_) - half_);
      arg_ = dppt_ / sqrt (df_);
      z_ = atan (arg_);
      for (ipass_ = 1; ipass_ <= maxit_; (ipass_)++) {
        s_ = sin (z_);
        c_ = cos (z_);
        z_ = z_ - (z_ + s_ * c_ - con_) / (two_ * (c_ * c_));
      }
      dppt_ = sqrt (df_) * s_ / c_;
    }
    else if ((*idf_) == 4) {
      con_ = two_ * ((*p_) - half_);
      arg_ = dppt_ / sqrt (df_);
      z_ = atan (arg_);
      for (ipass_ = 1; ipass_ <= maxit_; (ipass_)++) {
        s_ = sin (z_);
        c_ = cos (z_);
        z_ = z_ - ((one_ + half_ * (c_ * c_)) * s_ - con_) / ((one_ + half_) * (c_ * c_ * c_));
      }
      dppt_ = sqrt (df_) * s_ / c_;
    }
    else if ((*idf_) == 5) {
      con_ = pi_ * ((*p_) - half_);
      arg_ = dppt_ / sqrt (df_);
      z_ = atan (arg_);
      for (ipass_ = 1; ipass_ <= maxit_; (ipass_)++) {
        s_ = sin (z_);
        c_ = cos (z_);
        z_ = z_ - (z_ + (c_ + (two_ / three_) * (c_ * c_ * c_)) * s_ - con_) / ((eight_ / three_) * ($2_ = c_ * c_, $2_ * $2_))
        ;
      }
      dppt_ = sqrt (df_) * s_ / c_;
    }
    else if ((*idf_) == 6) {
      con_ = two_ * ((*p_) - half_);
      arg_ = dppt_ / sqrt (df_);
      z_ = atan (arg_);
      for (ipass_ = 1; ipass_ <= maxit_; (ipass_)++) {
        s_ = sin (z_);
        c_ = cos (z_);
        z_ = z_ - ((one_ + half_ * (c_ * c_) + (three_ / eight_) * ($3_ = c_ * c_, $3_ * $3_)) * s_ - con_) / ((fiftn_ / 
        eight_) * ($4_ = c_ * c_, c_ * $4_ * $4_));
      }
      dppt_ = sqrt (df_) * s_ / c_;
    }
  }
  __calls[41].calls++;
  return dppt_;
}

int_4 _dpvb (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ nrow_, int_4 _p_ j_, int_4 _p_ lq_, real_8 _p_ 
stp_, int_4 _p_ istop_, int_4 _p_ nfev_, real_8 _p_ pvb_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_)
{
  static real_8 betaj_;
  int_4 $0_;
  betaj_ = beta_[(*j_) - 1];
  beta_[(*j_) - 1] = beta_[(*j_) - 1] + (*stp_);
  (*istop_) = 0;
  (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, ($0_ = 3, &$0_), wrk2_, wrk6_, 
  wrk1_, istop_);
  if ((*istop_) == 0) {
    (*nfev_) = (*nfev_) + 1;
  }
  else {
    goto _l0;
  }
  beta_[(*j_) - 1] = betaj_;
  (*pvb_) = wrk2_[(*nrow_) - 1 + ((*n_)) * (((*lq_) - 1))];
  _l0:;
  __calls[42].calls++;
  return 0;
}

int_4 _dpvd (int_4 (*_fcn)(), int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, real_8 _p_ beta_, real_8 _p_ 
xplusd_, int_4 _p_ ifixb_, int_4 _p_ ifixx_, int_4 _p_ ldifx_, int_4 _p_ nrow_, int_4 _p_ j_, int_4 _p_ lq_, real_8 _p_ 
stp_, int_4 _p_ istop_, int_4 _p_ nfev_, real_8 _p_ pvd_, real_8 _p_ wrk1_, real_8 _p_ wrk2_, real_8 _p_ wrk6_)
{
  static real_8 xpdj_;
  int_4 $0_;
  xpdj_ = xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))];
  xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))] = xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))] + (*stp_);
  (*istop_) = 0;
  (void) _fcn (n_, m_, np_, nq_, n_, m_, np_, beta_, xplusd_, ifixb_, ifixx_, ldifx_, ($0_ = 3, &$0_), wrk2_, wrk6_, 
  wrk1_, istop_);
  if ((*istop_) == 0) {
    (*nfev_) = (*nfev_) + 1;
  }
  else {
    goto _l0;
  }
  xplusd_[(*nrow_) - 1 + ((*n_)) * (((*j_) - 1))] = xpdj_;
  (*pvd_) = wrk2_[(*nrow_) - 1 + ((*n_)) * (((*lq_) - 1))];
  _l0:;
  __calls[43].calls++;
  return 0;
}

int_4 _dscale (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ scl_, int_4 _p_ ldscl_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ 
sclt_, int_4 _p_ ldsclt_)
{
  static int_4 i_, j_;
  static real_8 one_, temp_, zero_;
  int_4 _data_k_35;
#define _data_n_35 2
  static real_8 _data_l_35[_data_n_35] = {
    1.0e0,
    0.0e0
  };
  if (__calls[44].calls == 0) {
    _data_k_35 = 0;
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    one_ = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    zero_ = _data_l_35[_data_k_35++];
  }
  if ((*n_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  if (scl_[0 + ((*ldscl_)) * ((0))] >= zero_) {
    if ((*ldscl_) >= (*n_)) {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          sclt_[i_ - 1 + ((*ldsclt_)) * ((j_ - 1))] = t_[i_ - 1 + ((*ldt_)) * ((j_ - 1))] / scl_[i_ - 1 + ((*ldscl_)) * ((j_ - 
          1))];
        }
      }
    }
    else {
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        temp_ = one_ / scl_[0 + ((*ldscl_)) * ((j_ - 1))];
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          sclt_[i_ - 1 + ((*ldsclt_)) * ((j_ - 1))] = t_[i_ - 1 + ((*ldt_)) * ((j_ - 1))] * temp_;
        }
      }
    }
  }
  else {
    temp_ = one_ / _abs (scl_[0 + ((*ldscl_)) * ((0))]);
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        sclt_[i_ - 1 + ((*ldsclt_)) * ((j_ - 1))] = t_[i_ - 1 + ((*ldt_)) * ((j_ - 1))] * temp_;
      }
    }
  }
  _l0:;
  __calls[44].calls++;
  return 0;
}

int_4 _dsclb (int_4 _p_ np_, real_8 _p_ beta_, real_8 _p_ ssf_)
{
  static int_4 k_;
  static logical_4 bigdif_;
  static real_8 bmax_, bmin_, one_, ten_, zero_;
  int_4 _data_k_36;
#define _data_n_36 3
  static real_8 _data_l_36[_data_n_36] = {
    0.0e0,
    1.0e0,
    10.0e0
  };
  if (__calls[45].calls == 0) {
    _data_k_36 = 0;
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    zero_ = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    one_ = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    ten_ = _data_l_36[_data_k_36++];
  }
  bmax_ = _abs (beta_[0]);
  for (k_ = 2; k_ <= (*np_); (k_)++) {
    bmax_ = _max (bmax_, _abs (beta_[k_ - 1]));
  }
  if (bmax_ == zero_) {
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      ssf_[k_ - 1] = one_;
    }
  }
  else {
    bmin_ = bmax_;
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      if (beta_[k_ - 1] != zero_) {
        bmin_ = _min (bmin_, _abs (beta_[k_ - 1]));
      }
    }
    bigdif_ = log10 (bmax_) - log10 (bmin_) >= one_;
    for (k_ = 1; k_ <= (*np_); (k_)++) {
      if (beta_[k_ - 1] == zero_) {
        ssf_[k_ - 1] = ten_ / bmin_;
      }
      else {
        if (bigdif_) {
          ssf_[k_ - 1] = one_ / _abs (beta_[k_ - 1]);
        }
        else {
          ssf_[k_ - 1] = one_ / bmax_;
        }
      }
    }
  }
  __calls[45].calls++;
  return 0;
}

int_4 _dscld (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ tt_, int_4 _p_ ldtt_)
{
  static int_4 i_, j_;
  static logical_4 bigdif_;
  static real_8 one_, ten_, xmax_, xmin_, zero_;
  int_4 _data_k_37;
#define _data_n_37 3
  static real_8 _data_l_37[_data_n_37] = {
    0.0e0,
    1.0e0,
    10.0e0
  };
  if (__calls[46].calls == 0) {
    _data_k_37 = 0;
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    zero_ = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    one_ = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    ten_ = _data_l_37[_data_k_37++];
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    xmax_ = _abs (x_[0 + ((*ldx_)) * ((j_ - 1))]);
    for (i_ = 2; i_ <= (*n_); (i_)++) {
      xmax_ = _max (xmax_, _abs (x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))]));
    }
    if (xmax_ == zero_) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        tt_[i_ - 1 + ((*ldtt_)) * ((j_ - 1))] = one_;
      }
    }
    else {
      xmin_ = xmax_;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        if (x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] != zero_) {
          xmin_ = _min (xmin_, _abs (x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))]));
        }
      }
      bigdif_ = log10 (xmax_) - log10 (xmin_) >= one_;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        if (x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] != zero_) {
          if (bigdif_) {
            tt_[i_ - 1 + ((*ldtt_)) * ((j_ - 1))] = one_ / _abs (x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))]);
          }
          else {
            tt_[i_ - 1 + ((*ldtt_)) * ((j_ - 1))] = one_ / xmax_;
          }
        }
        else {
          tt_[i_ - 1 + ((*ldtt_)) * ((j_ - 1))] = ten_ / xmin_;
        }
      }
    }
  }
  __calls[46].calls++;
  return 0;
}

int_4 _dsetn (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ x_, int_4 _p_ ldx_, int_4 _p_ nrow_)
{
  static int_4 i_, j_;
  if (((*nrow_) >= 1) && ((*nrow_) <= (*n_))) {
    goto _l0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      if (x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] == 0.0) {
        goto _l20;
      }
    }
    (*nrow_) = i_;
    goto _l0;
    _l20:;
  }
  (*nrow_) = 1;
  _l0:;
  __calls[47].calls++;
  return 0;
}

int_4 _dsolve (int_4 _p_ n_, real_8 _p_ t_, int_4 _p_ ldt_, real_8 _p_ b_, int_4 _p_ ldb_, int_4 _p_ job_)
{
  static int_4 j1_, j_, jn_;
  static real_8 temp_, zero_;
  int_4 _data_k_38, $0_, $1_, $2_;
  extern real_8 _ddot ();
  extern int_4 _daxpy ();
#define _data_n_38 1
  static real_8 _data_l_38[_data_n_38] = {
    0.0e0
  };
  if (__calls[48].calls == 0) {
    _data_k_38 = 0;
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    zero_ = _data_l_38[_data_k_38++];
  }
  j1_ = 0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    if (j1_ == 0 && t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))] != zero_) {
      j1_ = j_;
    }
    else if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))] == zero_) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = zero_;
    }
  }
  if (j1_ == 0) {
    goto _l0;
  }
  jn_ = 0;
  for (j_ = (*n_); j_ >= j1_; (j_)--) {
    if (jn_ == 0 && t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))] != zero_) {
      jn_ = j_;
    }
    else if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))] == zero_) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = zero_;
    }
  }
  if ((*job_) == 1) {
    b_[0 + ((*ldb_)) * ((j1_ - 1))] = b_[0 + ((*ldb_)) * ((j1_ - 1))] / t_[j1_ - 1 + ((*ldt_)) * ((j1_ - 1))];
    for (j_ = j1_ + 1; j_ <= jn_; (j_)++) {
      temp_ = -b_[0 + ((*ldb_)) * ((j_ - 1 - 1))];
      (void) _daxpy (($0_ = jn_ - j_ + 1, &$0_), &temp_, &t_[j_ - 1 + ((*ldt_)) * ((j_ - 1 - 1))], &_k1, &b_[0 + ((*ldb_)) * 
      ((j_ - 1))], ldb_);
      if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))] != zero_) {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
      }
      else {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = zero_;
      }
    }
  }
  else if ((*job_) == 2) {
    b_[0 + ((*ldb_)) * ((jn_ - 1))] = b_[0 + ((*ldb_)) * ((jn_ - 1))] / t_[jn_ - 1 + ((*ldt_)) * ((jn_ - 1))];
    for (j_ = jn_ - 1; j_ >= j1_; (j_)--) {
      temp_ = -b_[0 + ((*ldb_)) * ((j_ + 1 - 1))];
      (void) _daxpy (&j_, &temp_, &t_[0 + ((*ldt_)) * ((j_ + 1 - 1))], &_k1, &b_[0 + ((*ldb_)) * ((0))], ldb_);
      if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))] != zero_) {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
      }
      else {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = zero_;
      }
    }
  }
  else if ((*job_) == 3) {
    b_[0 + ((*ldb_)) * ((jn_ - 1))] = b_[0 + ((*ldb_)) * ((jn_ - 1))] / t_[jn_ - 1 + ((*ldt_)) * ((jn_ - 1))];
    for (j_ = jn_ - 1; j_ >= j1_; (j_)--) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - _ddot (($1_ = jn_ - j_ + 1, &$1_), &t_[j_ + 1 - 1 + 
      ((*ldt_)) * ((j_ - 1))], &_k1, &b_[0 + ((*ldb_)) * ((j_ + 1 - 1))], ldb_);
      if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))] != zero_) {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
      }
      else {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = zero_;
      }
    }
  }
  else if ((*job_) == 4) {
    b_[0 + ((*ldb_)) * ((j1_ - 1))] = b_[0 + ((*ldb_)) * ((j1_ - 1))] / t_[j1_ - 1 + ((*ldt_)) * ((j1_ - 1))];
    for (j_ = j1_ + 1; j_ <= jn_; (j_)++) {
      b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] - _ddot (($2_ = j_ - 1, &$2_), &t_[0 + ((*ldt_)) * ((j_ 
      - 1))], &_k1, &b_[0 + ((*ldb_)) * ((0))], ldb_);
      if (t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))] != zero_) {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = b_[0 + ((*ldb_)) * ((j_ - 1))] / t_[j_ - 1 + ((*ldt_)) * ((j_ - 1))];
      }
      else {
        b_[0 + ((*ldb_)) * ((j_ - 1))] = zero_;
      }
    }
  }
  _l0:;
  __calls[48].calls++;
  return 0;
}

int_4 _dunpac (int_4 _p_ n2_, real_8 _p_ v1_, real_8 _p_ v2_, int_4 _p_ ifix_)
{
  static int_4 i_, n1_;
  extern int_4 _dcopy ();
  n1_ = 0;
  if (ifix_[0] >= 0) {
    for (i_ = 1; i_ <= (*n2_); (i_)++) {
      if (ifix_[i_ - 1] != 0) {
        n1_ = n1_ + 1;
        v2_[i_ - 1] = v1_[n1_ - 1];
      }
    }
  }
  else {
    n1_ = (*n2_);
    (void) _dcopy (n2_, v1_, &_k1, v2_, &_k1);
  }
  __calls[49].calls++;
  return 0;
}

int_4 _dvevtr (int_4 _p_ m_, int_4 _p_ nq_, int_4 _p_ indx_, real_8 _p_ v_, int_4 _p_ ldv_, int_4 _p_ ld2v_, real_8 _p_ 
e_, int_4 _p_ lde_, real_8 _p_ ve_, int_4 _p_ ldve_, int_4 _p_ ld2ve_, real_8 _p_ vev_, int_4 _p_ ldvev_, real_8 _p_ 
wrk5_)
{
  static int_4 j_, l1_, l2_;
  static real_8 zero_;
  int_4 _data_k_39, $0_;
#define _data_n_39 1
  static real_8 _data_l_39[_data_n_39] = {
    0.0e0
  };
  if (__calls[50].calls == 0) {
    _data_k_39 = 0;
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    zero_ = _data_l_39[_data_k_39++];
  }
  if ((*nq_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  for (l1_ = 1; l1_ <= (*nq_); (l1_)++) {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      wrk5_[j_ - 1] = v_[(*indx_) - 1 + ((*ldv_)) * ((j_ - 1) + ((*ld2v_)) * ((l1_ - 1)))];
    }
    (void) _dsolve (m_, e_, lde_, wrk5_, &_k1, ($0_ = 4, &$0_));
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      ve_[(*indx_) - 1 + ((*ldve_)) * ((l1_ - 1) + ((*ld2ve_)) * ((j_ - 1)))] = wrk5_[j_ - 1];
    }
  }
  for (l1_ = 1; l1_ <= (*nq_); (l1_)++) {
    for (l2_ = 1; l2_ <= l1_; (l2_)++) {
      vev_[l1_ - 1 + ((*ldvev_)) * ((l2_ - 1))] = zero_;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        vev_[l1_ - 1 + ((*ldvev_)) * ((l2_ - 1))] = vev_[l1_ - 1 + ((*ldvev_)) * ((l2_ - 1))] + ve_[(*indx_) - 1 + ((*ldve_)) * 
        ((l1_ - 1) + ((*ld2ve_)) * ((j_ - 1)))] * ve_[(*indx_) - 1 + ((*ldve_)) * ((l2_ - 1) + ((*ld2ve_)) * ((j_ - 1)))];
      }
      vev_[l2_ - 1 + ((*ldvev_)) * ((l1_ - 1))] = vev_[l1_ - 1 + ((*ldvev_)) * ((l2_ - 1))];
    }
  }
  _l0:;
  __calls[50].calls++;
  return 0;
}

int_4 _dwght (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ wt_, int_4 _p_ ldwt_, int_4 _p_ ld2wt_, real_8 _p_ t_, int_4 _p_ 
ldt_, real_8 _p_ wtt_, int_4 _p_ ldwtt_)
{
  static int_4 i_, j_, k_;
  static real_8 temp_, zero_;
  int_4 _data_k_40;
#define _data_n_40 1
  static real_8 _data_l_40[_data_n_40] = {
    0.0e0
  };
  if (__calls[51].calls == 0) {
    _data_k_40 = 0;
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    zero_ = _data_l_40[_data_k_40++];
  }
  if ((*n_) == 0 || (*m_) == 0) {
    goto _l0;
  }
  if (wt_[0 + ((*ldwt_)) * ((0) + ((*ld2wt_)) * ((0)))] >= zero_) {
    if ((*ldwt_) >= (*n_)) {
      if ((*ld2wt_) >= (*m_)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            temp_ = zero_;
            for (k_ = 1; k_ <= (*m_); (k_)++) {
              temp_ = temp_ + wt_[i_ - 1 + ((*ldwt_)) * ((j_ - 1) + ((*ld2wt_)) * ((k_ - 1)))] * t_[i_ - 1 + ((*ldt_)) * ((k_ - 1))]
              ;
            }
            wtt_[i_ - 1 + ((*ldwtt_)) * ((j_ - 1))] = temp_;
          }
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            wtt_[i_ - 1 + ((*ldwtt_)) * ((j_ - 1))] = wt_[i_ - 1 + ((*ldwt_)) * ((0) + ((*ld2wt_)) * ((j_ - 1)))] * t_[i_ - 1 + 
            ((*ldt_)) * ((j_ - 1))];
          }
        }
      }
    }
    else {
      if ((*ld2wt_) >= (*m_)) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            temp_ = zero_;
            for (k_ = 1; k_ <= (*m_); (k_)++) {
              temp_ = temp_ + wt_[0 + ((*ldwt_)) * ((j_ - 1) + ((*ld2wt_)) * ((k_ - 1)))] * t_[i_ - 1 + ((*ldt_)) * ((k_ - 1))];
            }
            wtt_[i_ - 1 + ((*ldwtt_)) * ((j_ - 1))] = temp_;
          }
        }
      }
      else {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          for (j_ = 1; j_ <= (*m_); (j_)++) {
            wtt_[i_ - 1 + ((*ldwtt_)) * ((j_ - 1))] = wt_[0 + ((*ldwt_)) * ((0) + ((*ld2wt_)) * ((j_ - 1)))] * t_[i_ - 1 + 
            ((*ldt_)) * ((j_ - 1))];
          }
        }
      }
    }
  }
  else {
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        wtt_[i_ - 1 + ((*ldwtt_)) * ((j_ - 1))] = _abs (wt_[0 + ((*ldwt_)) * ((0) + ((*ld2wt_)) * ((0)))]) * t_[i_ - 1 + 
        ((*ldt_)) * ((j_ - 1))];
      }
    }
  }
  _l0:;
  __calls[51].calls++;
  return 0;
}

int_4 _dwinf (int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ np_, int_4 _p_ nq_, int_4 _p_ ldwe_, int_4 _p_ ld2we_, logical_4 
_p_ isodr_, int_4 _p_ deltai_, int_4 _p_ epsi_, int_4 _p_ xplusi_, int_4 _p_ fni_, int_4 _p_ sdi_, int_4 _p_ vcvi_, 
int_4 _p_ rvari_, int_4 _p_ wssi_, int_4 _p_ wssdei_, int_4 _p_ wssepi_, int_4 _p_ rcondi_, int_4 _p_ etai_, int_4 _p_ 
olmavi_, int_4 _p_ taui_, int_4 _p_ alphai_, int_4 _p_ actrsi_, int_4 _p_ pnormi_, int_4 _p_ rnorsi_, int_4 _p_ prersi_
, int_4 _p_ partli_, int_4 _p_ sstoli_, int_4 _p_ taufci_, int_4 _p_ epsmai_, int_4 _p_ beta0i_, int_4 _p_ betaci_, 
int_4 _p_ betasi_, int_4 _p_ betani_, int_4 _p_ si_, int_4 _p_ ssi_, int_4 _p_ ssfi_, int_4 _p_ qrauxi_, int_4 _p_ ui_, 
int_4 _p_ fsi_, int_4 _p_ fjacbi_, int_4 _p_ we1i_, int_4 _p_ diffi_, int_4 _p_ deltsi_, int_4 _p_ deltni_, int_4 _p_ 
ti_, int_4 _p_ tti_, int_4 _p_ omegai_, int_4 _p_ fjacdi_, int_4 _p_ wrk1i_, int_4 _p_ wrk2i_, int_4 _p_ wrk3i_, int_4 
_p_ wrk4i_, int_4 _p_ wrk5i_, int_4 _p_ wrk6i_, int_4 _p_ wrk7i_, int_4 _p_ lwkmn_)
{
  static int_4 next_;
  if ((*n_) >= 1 && (*m_) >= 1 && (*np_) >= 1 && (*nq_) >= 1 && (*ldwe_) >= 1 && (*ld2we_) >= 1) {
    (*deltai_) = 1;
    (*epsi_) = (*deltai_) + (*n_) * (*m_);
    (*xplusi_) = (*epsi_) + (*n_) * (*nq_);
    (*fni_) = (*xplusi_) + (*n_) * (*m_);
    (*sdi_) = (*fni_) + (*n_) * (*nq_);
    (*vcvi_) = (*sdi_) + (*np_);
    (*rvari_) = (*vcvi_) + (*np_) * (*np_);
    (*wssi_) = (*rvari_) + 1;
    (*wssdei_) = (*wssi_) + 1;
    (*wssepi_) = (*wssdei_) + 1;
    (*rcondi_) = (*wssepi_) + 1;
    (*etai_) = (*rcondi_) + 1;
    (*olmavi_) = (*etai_) + 1;
    (*taui_) = (*olmavi_) + 1;
    (*alphai_) = (*taui_) + 1;
    (*actrsi_) = (*alphai_) + 1;
    (*pnormi_) = (*actrsi_) + 1;
    (*rnorsi_) = (*pnormi_) + 1;
    (*prersi_) = (*rnorsi_) + 1;
    (*partli_) = (*prersi_) + 1;
    (*sstoli_) = (*partli_) + 1;
    (*taufci_) = (*sstoli_) + 1;
    (*epsmai_) = (*taufci_) + 1;
    (*beta0i_) = (*epsmai_) + 1;
    (*betaci_) = (*beta0i_) + (*np_);
    (*betasi_) = (*betaci_) + (*np_);
    (*betani_) = (*betasi_) + (*np_);
    (*si_) = (*betani_) + (*np_);
    (*ssi_) = (*si_) + (*np_);
    (*ssfi_) = (*ssi_) + (*np_);
    (*qrauxi_) = (*ssfi_) + (*np_);
    (*ui_) = (*qrauxi_) + (*np_);
    (*fsi_) = (*ui_) + (*np_);
    (*fjacbi_) = (*fsi_) + (*n_) * (*nq_);
    (*we1i_) = (*fjacbi_) + (*n_) * (*np_) * (*nq_);
    (*diffi_) = (*we1i_) + (*ldwe_) * (*ld2we_) * (*nq_);
    next_ = (*diffi_) + (*nq_) * ((*np_) + (*m_));
    if ((*isodr_)) {
      (*deltsi_) = next_;
      (*deltni_) = (*deltsi_) + (*n_) * (*m_);
      (*ti_) = (*deltni_) + (*n_) * (*m_);
      (*tti_) = (*ti_) + (*n_) * (*m_);
      (*omegai_) = (*tti_) + (*n_) * (*m_);
      (*fjacdi_) = (*omegai_) + (*nq_) * (*nq_);
      (*wrk1i_) = (*fjacdi_) + (*n_) * (*m_) * (*nq_);
      next_ = (*wrk1i_) + (*n_) * (*m_) * (*nq_);
    }
    else {
      (*deltsi_) = (*deltai_);
      (*deltni_) = (*deltai_);
      (*ti_) = (*deltai_);
      (*tti_) = (*deltai_);
      (*omegai_) = (*deltai_);
      (*fjacdi_) = (*deltai_);
      (*wrk1i_) = (*deltai_);
    }
    (*wrk2i_) = next_;
    (*wrk3i_) = (*wrk2i_) + (*n_) * (*nq_);
    (*wrk4i_) = (*wrk3i_) + (*np_);
    (*wrk5i_) = (*wrk4i_) + (*m_) * (*m_);
    (*wrk6i_) = (*wrk5i_) + (*m_);
    (*wrk7i_) = (*wrk6i_) + (*n_) * (*nq_) * (*np_);
    next_ = (*wrk7i_) + 5 * (*nq_);
    (*lwkmn_) = next_;
  }
  else {
    (*deltai_) = 1;
    (*epsi_) = 1;
    (*xplusi_) = 1;
    (*fni_) = 1;
    (*sdi_) = 1;
    (*vcvi_) = 1;
    (*rvari_) = 1;
    (*wssi_) = 1;
    (*wssdei_) = 1;
    (*wssepi_) = 1;
    (*rcondi_) = 1;
    (*etai_) = 1;
    (*olmavi_) = 1;
    (*taui_) = 1;
    (*alphai_) = 1;
    (*actrsi_) = 1;
    (*pnormi_) = 1;
    (*rnorsi_) = 1;
    (*prersi_) = 1;
    (*partli_) = 1;
    (*sstoli_) = 1;
    (*taufci_) = 1;
    (*epsmai_) = 1;
    (*beta0i_) = 1;
    (*betaci_) = 1;
    (*betasi_) = 1;
    (*betani_) = 1;
    (*si_) = 1;
    (*ssi_) = 1;
    (*ssfi_) = 1;
    (*qrauxi_) = 1;
    (*fsi_) = 1;
    (*ui_) = 1;
    (*fjacbi_) = 1;
    (*we1i_) = 1;
    (*diffi_) = 1;
    (*deltsi_) = 1;
    (*deltni_) = 1;
    (*ti_) = 1;
    (*tti_) = 1;
    (*fjacdi_) = 1;
    (*omegai_) = 1;
    (*wrk1i_) = 1;
    (*wrk2i_) = 1;
    (*wrk3i_) = 1;
    (*wrk4i_) = 1;
    (*wrk5i_) = 1;
    (*wrk6i_) = 1;
    (*wrk7i_) = 1;
    (*lwkmn_) = 1;
  }
  __calls[52].calls++;
  return 0;
}

int_4 _dxmy (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ xmy_, 
int_4 _p_ ldxmy_)
{
  static int_4 i_, j_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      xmy_[i_ - 1 + ((*ldxmy_)) * ((j_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] - y_[i_ - 1 + ((*ldy_)) * ((j_ - 1))];
    }
  }
  __calls[53].calls++;
  return 0;
}

int_4 _dxpy (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ x_, int_4 _p_ ldx_, real_8 _p_ y_, int_4 _p_ ldy_, real_8 _p_ xpy_, 
int_4 _p_ ldxpy_)
{
  static int_4 i_, j_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      xpy_[i_ - 1 + ((*ldxpy_)) * ((j_ - 1))] = x_[i_ - 1 + ((*ldx_)) * ((j_ - 1))] + y_[i_ - 1 + ((*ldy_)) * ((j_ - 1))];
    }
  }
  __calls[54].calls++;
  return 0;
}

int_4 _dzero (int_4 _p_ n_, int_4 _p_ m_, real_8 _p_ a_, int_4 _p_ lda_)
{
  static int_4 i_, j_;
  static real_8 zero_;
  int_4 _data_k_41;
#define _data_n_41 1
  static real_8 _data_l_41[_data_n_41] = {
    0.0e0
  };
  if (__calls[55].calls == 0) {
    _data_k_41 = 0;
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    zero_ = _data_l_41[_data_k_41++];
  }
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = zero_;
    }
  }
  __calls[55].calls++;
  return 0;
}

