//! @file mathlib-pchip.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 41 subprograms from PCHIP

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CHFCM  DCHFDV DPCHCE DPCHDF DPCHIC DPCHSP PCHCE  PCHDF  PCHIA  PCHKT
// CHFDV  DCHFEV DPCHCI DPCHFD DPCHID DPCHST PCHCI  PCHDOC PCHIC  PCHSP
// CHFEV  DCHFIE DPCHCM DPCHFE DPCHIM DPCHSW PCHCM  PCHFD  PCHID  PCHST
// CHFIE  DPCHBS DPCHCS DPCHIA DPCHKT PCHBS  PCHCS  PCHFE  PCHIM  PCHSW
// DCHFCM

// PCHIP routines from SLATEC.
// 
// Source: netlib.org/slatec/

// The license for PCHIP Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "slatec"
#define _dc_1 "chfdv"
#define _dc_2 "number of evaluation points less than one"
#define _dc_3 "interval endpoints equal"
#define _dc_4 "chfev"
#define _dc_5 "dchfdv"
#define _dc_6 "dchfev"
#define _dc_7 "dpchbs"
#define _dc_8 "knotyp greater than 2"
#define _dc_9 "knotyp.lt.0 and nknots.ne.(2*n+4)"
#define _dc_10 "dpchce"
#define _dc_11 "error return from dpchdf"
#define _dc_12 "dpchcm"
#define _dc_13 "number of data points less than two"
#define _dc_14 "increment less than one"
#define _dc_15 "x-array not strictly increasing"
#define _dc_16 "dpchdf"
#define _dc_17 "k less than three"
#define _dc_18 "dpchfd"
#define _dc_19 "error return from dchfdv -- fatal"
#define _dc_20 "dpchfe"
#define _dc_21 "error return from dchfev -- fatal"
#define _dc_22 "dpchia"
#define _dc_23 "trouble in dpchid"
#define _dc_24 "dpchic"
#define _dc_25 "ic out of range"
#define _dc_26 "work array too small"
#define _dc_27 "error return from dpchcs"
#define _dc_28 "error return from dpchce"
#define _dc_29 "dpchid"
#define _dc_30 "ia or ib out of range"
#define _dc_31 "dpchim"
#define _dc_32 "dpchsp"
#define _dc_33 "singular linear system"
#define _dc_34 "dpchsw"
#define _dc_35 "d1 and/or d2 invalid"
#define _dc_36 "negative radical"
#define _dc_37 "pchbs"
#define _dc_38 "pchce"
#define _dc_39 "error return from pchdf"
#define _dc_40 "pchcm"
#define _dc_41 "pchdf"
#define _dc_42 "pchfd"
#define _dc_43 "error return from chfdv -- fatal"
#define _dc_44 "pchfe"
#define _dc_45 "error return from chfev -- fatal"
#define _dc_46 "pchia"
#define _dc_47 "trouble in pchid"
#define _dc_48 "pchic"
#define _dc_49 "error return from pchcs"
#define _dc_50 "error return from pchce"
#define _dc_51 "pchid"
#define _dc_52 "pchim"
#define _dc_53 "pchsp"
#define _dc_54 "pchsw"
static FORMAT *__fmt_a = NULL;
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
#define __ncalls 42
static CALLS __calls[__ncalls] = {
  {"chfcm", 0}, // integer*4 function
  {"chfdv", 0}, // subroutine
  {"chfev", 0}, // subroutine
  {"chfie", 0}, // real*4 function
  {"dchfcm", 0}, // integer*4 function
  {"dchfdv", 0}, // subroutine
  {"dchfev", 0}, // subroutine
  {"dchfie", 0}, // real*8 function
  {"dpchbs", 0}, // subroutine
  {"dpchce", 0}, // subroutine
  {"dpchci", 0}, // subroutine
  {"dpchcm", 0}, // subroutine
  {"dpchcs", 0}, // subroutine
  {"dpchdf", 0}, // real*8 function
  {"dpchfd", 0}, // subroutine
  {"dpchfe", 0}, // subroutine
  {"dpchia", 0}, // real*8 function
  {"dpchic", 0}, // subroutine
  {"dpchid", 0}, // real*8 function
  {"dpchim", 0}, // subroutine
  {"dpchkt", 0}, // subroutine
  {"dpchsp", 0}, // subroutine
  {"dpchst", 0}, // real*8 function
  {"dpchsw", 0}, // subroutine
  {"pchbs", 0}, // subroutine
  {"pchce", 0}, // subroutine
  {"pchci", 0}, // subroutine
  {"pchcm", 0}, // subroutine
  {"pchcs", 0}, // subroutine
  {"pchdf", 0}, // real*4 function
  {"pchdoc", 0}, // subroutine
  {"pchfd", 0}, // subroutine
  {"pchfe", 0}, // subroutine
  {"pchia", 0}, // real*4 function
  {"pchic", 0}, // subroutine
  {"pchid", 0}, // real*4 function
  {"pchim", 0}, // subroutine
  {"pchkt", 0}, // subroutine
  {"pchsp", 0}, // subroutine
  {"pchst", 0}, // real*4 function
  {"pchsw", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _chfcm (real_4 _p_ d1_, real_4 _p_ d2_, real_4 _p_ delta_);
prototype int_4 _chfdv (real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ f1_, real_4 _p_ f2_, real_4 _p_ d1_, real_4 _p_ d2_, 
int_4 _p_ ne_, real_4 _p_ xe_, real_4 _p_ fe_, real_4 _p_ de_, int_4 _p_ next_, int_4 _p_ ierr_);
prototype int_4 _chfev (real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ f1_, real_4 _p_ f2_, real_4 _p_ d1_, real_4 _p_ d2_, 
int_4 _p_ ne_, real_4 _p_ xe_, real_4 _p_ fe_, int_4 _p_ next_, int_4 _p_ ierr_);
prototype real_4 _chfie (real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ f1_, real_4 _p_ f2_, real_4 _p_ d1_, real_4 _p_ d2_
, real_4 _p_ a_, real_4 _p_ b_);
prototype int_4 _dchfcm (real_8 _p_ d1_, real_8 _p_ d2_, real_8 _p_ delta_);
prototype int_4 _dchfdv (real_8 _p_ x1_, real_8 _p_ x2_, real_8 _p_ f1_, real_8 _p_ f2_, real_8 _p_ d1_, real_8 _p_ d2_
, int_4 _p_ ne_, real_8 _p_ xe_, real_8 _p_ fe_, real_8 _p_ de_, int_4 _p_ next_, int_4 _p_ ierr_);
prototype int_4 _dchfev (real_8 _p_ x1_, real_8 _p_ x2_, real_8 _p_ f1_, real_8 _p_ f2_, real_8 _p_ d1_, real_8 _p_ d2_
, int_4 _p_ ne_, real_8 _p_ xe_, real_8 _p_ fe_, int_4 _p_ next_, int_4 _p_ ierr_);
prototype real_8 _dchfie (real_8 _p_ x1_, real_8 _p_ x2_, real_8 _p_ f1_, real_8 _p_ f2_, real_8 _p_ d1_, real_8 _p_ 
d2_, real_8 _p_ a_, real_8 _p_ b_);
prototype int_4 _dpchbs (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, int_4 _p_ knotyp_
, int_4 _p_ nknots_, real_8 _p_ t_, real_8 _p_ bcoef_, int_4 _p_ ndim_, int_4 _p_ kord_, int_4 _p_ ierr_);
prototype int_4 _dpchce (int_4 _p_ ic_, real_8 _p_ vc_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ h_, real_8 _p_ slope_, 
real_8 _p_ d_, int_4 _p_ incfd_, int_4 _p_ ierr_);
prototype int_4 _dpchci (int_4 _p_ n_, real_8 _p_ h_, real_8 _p_ slope_, real_8 _p_ d_, int_4 _p_ incfd_);
prototype int_4 _dpchcm (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, int_4 _p_ ismon_, int_4 _p_ ierr_);
prototype int_4 _dpchcs (real_8 _p_ switch_, int_4 _p_ n_, real_8 _p_ h_, real_8 _p_ slope_, real_8 _p_ d_, int_4 _p_ 
incfd_, int_4 _p_ ierr_);
prototype real_8 _dpchdf (int_4 _p_ k_, real_8 _p_ x_, real_8 _p_ s_, int_4 _p_ ierr_);
prototype int_4 _dpchfd (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, int_4 _p_ ne_, real_8 _p_ xe_, real_8 _p_ fe_, real_8 _p_ de_, int_4 _p_ ierr_);
prototype int_4 _dpchfe (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, int_4 _p_ ne_, real_8 _p_ xe_, real_8 _p_ fe_, int_4 _p_ ierr_);
prototype real_8 _dpchia (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, real_8 _p_ a_, real_8 _p_ b_, int_4 _p_ ierr_);
prototype int_4 _dpchic (int_4 _p_ ic_, real_8 _p_ vc_, real_8 _p_ switch_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, 
real_8 _p_ d_, int_4 _p_ incfd_, real_8 _p_ wk_, int_4 _p_ nwk_, int_4 _p_ ierr_);
prototype real_8 _dpchid (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, int_4 _p_ ia_, int_4 _p_ ib_, int_4 _p_ ierr_);
prototype int_4 _dpchim (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, int_4 _p_ ierr_);
prototype int_4 _dpchkt (int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ knotyp_, real_8 _p_ t_);
prototype int_4 _dpchsp (int_4 _p_ ic_, real_8 _p_ vc_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, 
int_4 _p_ incfd_, real_8 _p_ wk_, int_4 _p_ nwk_, int_4 _p_ ierr_);
prototype real_8 _dpchst (real_8 _p_ arg1_, real_8 _p_ arg2_);
prototype int_4 _dpchsw (real_8 _p_ dfmax_, int_4 _p_ iextrm_, real_8 _p_ d1_, real_8 _p_ d2_, real_8 _p_ h_, real_8 
_p_ slope_, int_4 _p_ ierr_);
prototype int_4 _pchbs (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, int_4 _p_ knotyp_, 
int_4 _p_ nknots_, real_4 _p_ t_, real_4 _p_ bcoef_, int_4 _p_ ndim_, int_4 _p_ kord_, int_4 _p_ ierr_);
prototype int_4 _pchce (int_4 _p_ ic_, real_4 _p_ vc_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ h_, real_4 _p_ slope_, 
real_4 _p_ d_, int_4 _p_ incfd_, int_4 _p_ ierr_);
prototype int_4 _pchci (int_4 _p_ n_, real_4 _p_ h_, real_4 _p_ slope_, real_4 _p_ d_, int_4 _p_ incfd_);
prototype int_4 _pchcm (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, int_4 _p_ ismon_, int_4 _p_ ierr_);
prototype int_4 _pchcs (real_4 _p_ switch_, int_4 _p_ n_, real_4 _p_ h_, real_4 _p_ slope_, real_4 _p_ d_, int_4 _p_ 
incfd_, int_4 _p_ ierr_);
prototype real_4 _pchdf (int_4 _p_ k_, real_4 _p_ x_, real_4 _p_ s_, int_4 _p_ ierr_);
prototype int_4 _pchdoc (void);
prototype int_4 _pchfd (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, int_4 _p_ ne_, real_4 _p_ xe_, real_4 _p_ fe_, real_4 _p_ de_, int_4 _p_ ierr_);
prototype int_4 _pchfe (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, int_4 _p_ ne_, real_4 _p_ xe_, real_4 _p_ fe_, int_4 _p_ ierr_);
prototype real_4 _pchia (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ ierr_);
prototype int_4 _pchic (int_4 _p_ ic_, real_4 _p_ vc_, real_4 _p_ switch_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, 
real_4 _p_ d_, int_4 _p_ incfd_, real_4 _p_ wk_, int_4 _p_ nwk_, int_4 _p_ ierr_);
prototype real_4 _pchid (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ 
skip_, int_4 _p_ ia_, int_4 _p_ ib_, int_4 _p_ ierr_);
prototype int_4 _pchim (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, int_4 _p_ ierr_);
prototype int_4 _pchkt (int_4 _p_ n_, real_4 _p_ x_, int_4 _p_ knotyp_, real_4 _p_ t_);
prototype int_4 _pchsp (int_4 _p_ ic_, real_4 _p_ vc_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 
_p_ incfd_, real_4 _p_ wk_, int_4 _p_ nwk_, int_4 _p_ ierr_);
prototype real_4 _pchst (real_4 _p_ arg1_, real_4 _p_ arg2_);
prototype int_4 _pchsw (real_4 _p_ dfmax_, int_4 _p_ iextrm_, real_4 _p_ d1_, real_4 _p_ d2_, real_4 _p_ h_, real_4 _p_ 
slope_, int_4 _p_ ierr_);
int_4 _chfcm (real_4 _p_ d1_, real_4 _p_ d2_, real_4 _p_ delta_)
{
  static int_4 ismon_, itrue_;
  static real_4 a_, b_, eps_, four_, one_, phi_, ten_, three_, two_, zero_;
  int_4 _data_k_0, _data_k_1, _data_k_2, _data_k_3, _data_k_4, _data_k_5, $0_;
  int_4 chfcm_;
  extern real_4 _r1mach ();
#define _data_n_0 1
  static real_4 _data_l_0[_data_n_0] = {
    0.0
  };
#define _data_n_1 1
  static real_4 _data_l_1[_data_n_1] = {
    1.0
  };
#define _data_n_2 1
  static real_4 _data_l_2[_data_n_2] = {
    2.0
  };
#define _data_n_3 1
  static real_4 _data_l_3[_data_n_3] = {
    3.0
  };
#define _data_n_4 1
  static real_4 _data_l_4[_data_n_4] = {
    4.0
  };
#define _data_n_5 1
  static real_4 _data_l_5[_data_n_5] = {
    10.0
  };
  if (__calls[0].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    zero_ = _data_l_0[_data_k_0++];
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    one_ = _data_l_1[_data_k_1++];
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_ = _data_l_2[_data_k_2++];
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    three_ = _data_l_3[_data_k_3++];
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    four_ = _data_l_4[_data_k_4++];
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    ten_ = _data_l_5[_data_k_5++];
  }
  eps_ = ten_ * _r1mach (($0_ = 4, &$0_));
  if ((*delta_) == zero_) {
    if (((*d1_) == zero_) && ((*d2_) == zero_)) {
      ismon_ = 0;
    }
    else {
      ismon_ = 2;
    }
  }
  else {
    itrue_ = _sign (one_, (*delta_));
    a_ = (*d1_) / (*delta_);
    b_ = (*d2_) / (*delta_);
    if ((a_ < zero_) || (b_ < zero_)) {
      ismon_ = 2;
    }
    else if ((a_ <= three_ - eps_) && (b_ <= three_ - eps_)) {
      ismon_ = itrue_;
    }
    else if ((a_ > four_ + eps_) && (b_ > four_ + eps_)) {
      ismon_ = 2;
    }
    else {
      a_ = a_ - two_;
      b_ = b_ - two_;
      phi_ = ((a_ * a_ + b_ * b_) + a_ * b_) - three_;
      if (phi_ < -eps_) {
        ismon_ = itrue_;
      }
      else if (phi_ > eps_) {
        ismon_ = 2;
      }
      else {
        ismon_ = 3 * itrue_;
      }
    }
  }
  chfcm_ = ismon_;
  __calls[0].calls++;
  return chfcm_;
}

int_4 _chfdv (real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ f1_, real_4 _p_ f2_, real_4 _p_ d1_, real_4 _p_ d2_, int_4 _p_ 
ne_, real_4 _p_ xe_, real_4 _p_ fe_, real_4 _p_ de_, int_4 _p_ next_, int_4 _p_ ierr_)
{
  static int_4 i_;
  static real_4 c2_, c2t2_, c3_, c3t3_, del1_, del2_, delta_, h_, x_, xmi_, xma_, zero_;
  int_4 _data_k_6;
#define _data_n_6 1
  static real_4 _data_l_6[_data_n_6] = {
    0.0
  };
  if (__calls[1].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    zero_ = _data_l_6[_data_k_6++];
  }
  if ((*ne_) < 1) {
    goto _l5001;
  }
  h_ = (*x2_) - (*x1_);
  if (h_ == zero_) {
    goto _l5002;
  }
  (*ierr_) = 0;
  next_[0] = 0;
  next_[1] = 0;
  xmi_ = _min (zero_, h_);
  xma_ = _max (zero_, h_);
  delta_ = ((*f2_) - (*f1_)) / h_;
  del1_ = ((*d1_) - delta_) / h_;
  del2_ = ((*d2_) - delta_) / h_;
  c2_ = -(del1_ + del1_ + del2_);
  c2t2_ = c2_ + c2_;
  c3_ = (del1_ + del2_) / h_;
  c3t3_ = c3_ + c3_ + c3_;
  for (i_ = 1; i_ <= (*ne_); (i_)++) {
    x_ = xe_[i_ - 1] - (*x1_);
    fe_[i_ - 1] = (*f1_) + x_ * ((*d1_) + x_ * (c2_ + x_ * c3_));
    de_[i_ - 1] = (*d1_) + x_ * (c2t2_ + x_ * c3t3_);
    if (x_ < xmi_) {
      next_[0] = next_[0] + 1;
    }
    if (x_ > xma_) {
      next_[1] = next_[1] + 1;
    }
  }
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_1, _dc_2, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_1, _dc_3, ierr_, &_k1);
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _chfev (real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ f1_, real_4 _p_ f2_, real_4 _p_ d1_, real_4 _p_ d2_, int_4 _p_ 
ne_, real_4 _p_ xe_, real_4 _p_ fe_, int_4 _p_ next_, int_4 _p_ ierr_)
{
  static int_4 i_;
  static real_4 c2_, c3_, del1_, del2_, delta_, h_, x_, xmi_, xma_, zero_;
  int_4 _data_k_7;
#define _data_n_7 1
  static real_4 _data_l_7[_data_n_7] = {
    0.0
  };
  if (__calls[2].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    zero_ = _data_l_7[_data_k_7++];
  }
  if ((*ne_) < 1) {
    goto _l5001;
  }
  h_ = (*x2_) - (*x1_);
  if (h_ == zero_) {
    goto _l5002;
  }
  (*ierr_) = 0;
  next_[0] = 0;
  next_[1] = 0;
  xmi_ = _min (zero_, h_);
  xma_ = _max (zero_, h_);
  delta_ = ((*f2_) - (*f1_)) / h_;
  del1_ = ((*d1_) - delta_) / h_;
  del2_ = ((*d2_) - delta_) / h_;
  c2_ = -(del1_ + del1_ + del2_);
  c3_ = (del1_ + del2_) / h_;
  for (i_ = 1; i_ <= (*ne_); (i_)++) {
    x_ = xe_[i_ - 1] - (*x1_);
    fe_[i_ - 1] = (*f1_) + x_ * ((*d1_) + x_ * (c2_ + x_ * c3_));
    if (x_ < xmi_) {
      next_[0] = next_[0] + 1;
    }
    if (x_ > xma_) {
      next_[1] = next_[1] + 1;
    }
  }
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_4, _dc_2, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_4, _dc_3, ierr_, &_k1);
  _l0:;
  __calls[2].calls++;
  return 0;
}

real_4 _chfie (real_4 _p_ x1_, real_4 _p_ x2_, real_4 _p_ f1_, real_4 _p_ f2_, real_4 _p_ d1_, real_4 _p_ d2_, real_4 
_p_ a_, real_4 _p_ b_)
{
  static real_4 dterm_, four_, fterm_, h_, half_, phia1_, phia2_, phib1_, phib2_, psia1_, psia2_, psib1_, psib2_, six_, 
  ta1_, ta2_, tb1_, tb2_, three_, two_, ua1_, ua2_, ub1_, ub2_;
  int_4 _data_k_8, _data_k_9, _data_k_10, _data_k_11, _data_k_12;
  real_4 chfie_;
#define _data_n_8 1
  static real_4 _data_l_8[_data_n_8] = {
    0.5
  };
#define _data_n_9 1
  static real_4 _data_l_9[_data_n_9] = {
    2.0
  };
#define _data_n_10 1
  static real_4 _data_l_10[_data_n_10] = {
    3.0
  };
#define _data_n_11 1
  static real_4 _data_l_11[_data_n_11] = {
    4.0
  };
#define _data_n_12 1
  static real_4 _data_l_12[_data_n_12] = {
    6.0
  };
  if (__calls[3].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    half_ = _data_l_8[_data_k_8++];
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    two_ = _data_l_9[_data_k_9++];
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    three_ = _data_l_10[_data_k_10++];
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    four_ = _data_l_11[_data_k_11++];
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    six_ = _data_l_12[_data_k_12++];
  }
  if ((*x1_) == (*x2_)) {
    chfie_ = 0;
  }
  else {
    h_ = (*x2_) - (*x1_);
    ta1_ = ((*a_) - (*x1_)) / h_;
    ta2_ = ((*x2_) - (*a_)) / h_;
    tb1_ = ((*b_) - (*x1_)) / h_;
    tb2_ = ((*x2_) - (*b_)) / h_;
    ua1_ = (ta1_ * ta1_ * ta1_);
    phia1_ = ua1_ * (two_ - ta1_);
    psia1_ = ua1_ * (three_ * ta1_ - four_);
    ua2_ = (ta2_ * ta2_ * ta2_);
    phia2_ = ua2_ * (two_ - ta2_);
    psia2_ = -ua2_ * (three_ * ta2_ - four_);
    ub1_ = (tb1_ * tb1_ * tb1_);
    phib1_ = ub1_ * (two_ - tb1_);
    psib1_ = ub1_ * (three_ * tb1_ - four_);
    ub2_ = (tb2_ * tb2_ * tb2_);
    phib2_ = ub2_ * (two_ - tb2_);
    psib2_ = -ub2_ * (three_ * tb2_ - four_);
    fterm_ = (*f1_) * (phia2_ - phib2_) + (*f2_) * (phib1_ - phia1_);
    dterm_ = ((*d1_) * (psia2_ - psib2_) + (*d2_) * (psib1_ - psia1_)) * (h_ / six_);
    chfie_ = (half_ * h_) * (fterm_ + dterm_);
  }
  __calls[3].calls++;
  return chfie_;
}

int_4 _dchfcm (real_8 _p_ d1_, real_8 _p_ d2_, real_8 _p_ delta_)
{
  static int_4 ismon_, itrue_;
  static real_8 a_, b_, eps_, four_, one_, phi_, ten_, three_, two_, zero_;
  int_4 _data_k_13, _data_k_14, _data_k_15, _data_k_16, _data_k_17, _data_k_18, $0_;
  int_4 dchfcm_;
  extern real_8 _d1mach ();
#define _data_n_13 1
  static real_8 _data_l_13[_data_n_13] = {
    0.0e0
  };
#define _data_n_14 1
  static real_8 _data_l_14[_data_n_14] = {
    1.0e0
  };
#define _data_n_15 1
  static real_8 _data_l_15[_data_n_15] = {
    2.0e0
  };
#define _data_n_16 1
  static real_8 _data_l_16[_data_n_16] = {
    3.0e0
  };
#define _data_n_17 1
  static real_8 _data_l_17[_data_n_17] = {
    4.0e0
  };
#define _data_n_18 1
  static real_8 _data_l_18[_data_n_18] = {
    10.0e0
  };
  if (__calls[4].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    zero_ = _data_l_13[_data_k_13++];
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    one_ = _data_l_14[_data_k_14++];
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    two_ = _data_l_15[_data_k_15++];
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    three_ = _data_l_16[_data_k_16++];
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    four_ = _data_l_17[_data_k_17++];
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    ten_ = _data_l_18[_data_k_18++];
  }
  eps_ = ten_ * _d1mach (($0_ = 4, &$0_));
  if ((*delta_) == zero_) {
    if (((*d1_) == zero_) && ((*d2_) == zero_)) {
      ismon_ = 0;
    }
    else {
      ismon_ = 2;
    }
  }
  else {
    itrue_ = _sign (one_, (*delta_));
    a_ = (*d1_) / (*delta_);
    b_ = (*d2_) / (*delta_);
    if ((a_ < zero_) || (b_ < zero_)) {
      ismon_ = 2;
    }
    else if ((a_ <= three_ - eps_) && (b_ <= three_ - eps_)) {
      ismon_ = itrue_;
    }
    else if ((a_ > four_ + eps_) && (b_ > four_ + eps_)) {
      ismon_ = 2;
    }
    else {
      a_ = a_ - two_;
      b_ = b_ - two_;
      phi_ = ((a_ * a_ + b_ * b_) + a_ * b_) - three_;
      if (phi_ < -eps_) {
        ismon_ = itrue_;
      }
      else if (phi_ > eps_) {
        ismon_ = 2;
      }
      else {
        ismon_ = 3 * itrue_;
      }
    }
  }
  dchfcm_ = ismon_;
  __calls[4].calls++;
  return dchfcm_;
}

int_4 _dchfdv (real_8 _p_ x1_, real_8 _p_ x2_, real_8 _p_ f1_, real_8 _p_ f2_, real_8 _p_ d1_, real_8 _p_ d2_, int_4 
_p_ ne_, real_8 _p_ xe_, real_8 _p_ fe_, real_8 _p_ de_, int_4 _p_ next_, int_4 _p_ ierr_)
{
  static int_4 i_;
  static real_8 c2_, c2t2_, c3_, c3t3_, del1_, del2_, delta_, h_, x_, xmi_, xma_, zero_;
  int_4 _data_k_19;
#define _data_n_19 1
  static real_8 _data_l_19[_data_n_19] = {
    0.0e0
  };
  if (__calls[5].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    zero_ = _data_l_19[_data_k_19++];
  }
  if ((*ne_) < 1) {
    goto _l5001;
  }
  h_ = (*x2_) - (*x1_);
  if (h_ == zero_) {
    goto _l5002;
  }
  (*ierr_) = 0;
  next_[0] = 0;
  next_[1] = 0;
  xmi_ = _min (zero_, h_);
  xma_ = _max (zero_, h_);
  delta_ = ((*f2_) - (*f1_)) / h_;
  del1_ = ((*d1_) - delta_) / h_;
  del2_ = ((*d2_) - delta_) / h_;
  c2_ = -(del1_ + del1_ + del2_);
  c2t2_ = c2_ + c2_;
  c3_ = (del1_ + del2_) / h_;
  c3t3_ = c3_ + c3_ + c3_;
  for (i_ = 1; i_ <= (*ne_); (i_)++) {
    x_ = xe_[i_ - 1] - (*x1_);
    fe_[i_ - 1] = (*f1_) + x_ * ((*d1_) + x_ * (c2_ + x_ * c3_));
    de_[i_ - 1] = (*d1_) + x_ * (c2t2_ + x_ * c3t3_);
    if (x_ < xmi_) {
      next_[0] = next_[0] + 1;
    }
    if (x_ > xma_) {
      next_[1] = next_[1] + 1;
    }
  }
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_5, _dc_2, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_5, _dc_3, ierr_, &_k1);
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _dchfev (real_8 _p_ x1_, real_8 _p_ x2_, real_8 _p_ f1_, real_8 _p_ f2_, real_8 _p_ d1_, real_8 _p_ d2_, int_4 
_p_ ne_, real_8 _p_ xe_, real_8 _p_ fe_, int_4 _p_ next_, int_4 _p_ ierr_)
{
  static int_4 i_;
  static real_8 c2_, c3_, del1_, del2_, delta_, h_, x_, xmi_, xma_, zero_;
  int_4 _data_k_20;
#define _data_n_20 1
  static real_8 _data_l_20[_data_n_20] = {
    0.0e0
  };
  if (__calls[6].calls == 0) {
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    zero_ = _data_l_20[_data_k_20++];
  }
  if ((*ne_) < 1) {
    goto _l5001;
  }
  h_ = (*x2_) - (*x1_);
  if (h_ == zero_) {
    goto _l5002;
  }
  (*ierr_) = 0;
  next_[0] = 0;
  next_[1] = 0;
  xmi_ = _min (zero_, h_);
  xma_ = _max (zero_, h_);
  delta_ = ((*f2_) - (*f1_)) / h_;
  del1_ = ((*d1_) - delta_) / h_;
  del2_ = ((*d2_) - delta_) / h_;
  c2_ = -(del1_ + del1_ + del2_);
  c3_ = (del1_ + del2_) / h_;
  for (i_ = 1; i_ <= (*ne_); (i_)++) {
    x_ = xe_[i_ - 1] - (*x1_);
    fe_[i_ - 1] = (*f1_) + x_ * ((*d1_) + x_ * (c2_ + x_ * c3_));
    if (x_ < xmi_) {
      next_[0] = next_[0] + 1;
    }
    if (x_ > xma_) {
      next_[1] = next_[1] + 1;
    }
  }
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_6, _dc_2, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_6, _dc_3, ierr_, &_k1);
  _l0:;
  __calls[6].calls++;
  return 0;
}

real_8 _dchfie (real_8 _p_ x1_, real_8 _p_ x2_, real_8 _p_ f1_, real_8 _p_ f2_, real_8 _p_ d1_, real_8 _p_ d2_, real_8 
_p_ a_, real_8 _p_ b_)
{
  static real_8 dterm_, four_, fterm_, h_, half_, phia1_, phia2_, phib1_, phib2_, psia1_, psia2_, psib1_, psib2_, six_, 
  ta1_, ta2_, tb1_, tb2_, three_, two_, ua1_, ua2_, ub1_, ub2_;
  int_4 _data_k_21, _data_k_22, _data_k_23, _data_k_24, _data_k_25;
  real_8 dchfie_;
#define _data_n_21 1
  static real_8 _data_l_21[_data_n_21] = {
    .5e0
  };
#define _data_n_22 1
  static real_8 _data_l_22[_data_n_22] = {
    2.0e0
  };
#define _data_n_23 1
  static real_8 _data_l_23[_data_n_23] = {
    3.0e0
  };
#define _data_n_24 1
  static real_8 _data_l_24[_data_n_24] = {
    4.0e0
  };
#define _data_n_25 1
  static real_8 _data_l_25[_data_n_25] = {
    6.0e0
  };
  if (__calls[7].calls == 0) {
    _data_k_21 = 0;
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    half_ = _data_l_21[_data_k_21++];
    _data_k_22 = 0;
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    two_ = _data_l_22[_data_k_22++];
    _data_k_23 = 0;
    if (_data_k_23 >= _data_n_23) {
      _data_k_23 = 0;
    }
    three_ = _data_l_23[_data_k_23++];
    _data_k_24 = 0;
    if (_data_k_24 >= _data_n_24) {
      _data_k_24 = 0;
    }
    four_ = _data_l_24[_data_k_24++];
    _data_k_25 = 0;
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    six_ = _data_l_25[_data_k_25++];
  }
  if ((*x1_) == (*x2_)) {
    dchfie_ = 0;
  }
  else {
    h_ = (*x2_) - (*x1_);
    ta1_ = ((*a_) - (*x1_)) / h_;
    ta2_ = ((*x2_) - (*a_)) / h_;
    tb1_ = ((*b_) - (*x1_)) / h_;
    tb2_ = ((*x2_) - (*b_)) / h_;
    ua1_ = (ta1_ * ta1_ * ta1_);
    phia1_ = ua1_ * (two_ - ta1_);
    psia1_ = ua1_ * (three_ * ta1_ - four_);
    ua2_ = (ta2_ * ta2_ * ta2_);
    phia2_ = ua2_ * (two_ - ta2_);
    psia2_ = -ua2_ * (three_ * ta2_ - four_);
    ub1_ = (tb1_ * tb1_ * tb1_);
    phib1_ = ub1_ * (two_ - tb1_);
    psib1_ = ub1_ * (three_ * tb1_ - four_);
    ub2_ = (tb2_ * tb2_ * tb2_);
    phib2_ = ub2_ * (two_ - tb2_);
    psib2_ = -ub2_ * (three_ * tb2_ - four_);
    fterm_ = (*f1_) * (phia2_ - phib2_) + (*f2_) * (phib1_ - phia1_);
    dterm_ = ((*d1_) * (psia2_ - psib2_) + (*d2_) * (psib1_ - psia1_)) * (h_ / six_);
    dchfie_ = (half_ * h_) * (fterm_ + dterm_);
  }
  __calls[7].calls++;
  return dchfie_;
}

int_4 _dpchbs (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, int_4 _p_ knotyp_, int_4 
_p_ nknots_, real_8 _p_ t_, real_8 _p_ bcoef_, int_4 _p_ ndim_, int_4 _p_ kord_, int_4 _p_ ierr_)
{
  static int_4 k_, kk_;
  static real_8 dov3_, hnew_, hold_;
  static char_15 libnam_, subnam_;
  (*ndim_) = 2 * (*n_);
  (*kord_) = 4;
  (*ierr_) = 0;
  bufcpy (libnam_, _dc_0, 15);
  bufcpy (subnam_, _dc_7, 15);
  if ((*knotyp_) > 2) {
    (*ierr_) = -1;
    (void) _xermsg (libnam_, subnam_, _dc_8, ierr_, &_k1);
    goto _l0;
  }
  if ((*knotyp_) < 0) {
    if ((*nknots_) != (*ndim_) + 4) {
      (*ierr_) = -2;
      (void) _xermsg (libnam_, subnam_, _dc_9, ierr_, &_k1);
      goto _l0;
    }
  }
  else {
    (*nknots_) = (*ndim_) + 4;
    (void) _dpchkt (n_, x_, knotyp_, t_);
  }
  hnew_ = t_[2] - t_[0];
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = 2 * k_;
    hold_ = hnew_;
    dov3_ = d_[0 + ((*incfd_)) * ((k_ - 1))] / 3;
    bcoef_[kk_ - 1 - 1] = f_[0 + ((*incfd_)) * ((k_ - 1))] - hold_ * dov3_;
    hnew_ = t_[kk_ + 3 - 1] - t_[kk_ + 1 - 1];
    bcoef_[kk_ - 1] = f_[0 + ((*incfd_)) * ((k_ - 1))] + hnew_ * dov3_;
  }
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _dpchce (int_4 _p_ ic_, real_8 _p_ vc_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ h_, real_8 _p_ slope_, real_8 _p_ 
d_, int_4 _p_ incfd_, int_4 _p_ ierr_)
{
  static int_4 ibeg_, iend_, ierf_, index_, j_, k_;
  static real_8 half_, stemp_[3], three_, two_, xtemp_[4], zero_;
  int_4 _data_k_26, _data_k_27, _data_k_28, _data_k_29;
#define _data_n_26 1
  static real_8 _data_l_26[_data_n_26] = {
    0.0e0
  };
#define _data_n_27 1
  static real_8 _data_l_27[_data_n_27] = {
    .5e0
  };
#define _data_n_28 1
  static real_8 _data_l_28[_data_n_28] = {
    2.0e0
  };
#define _data_n_29 1
  static real_8 _data_l_29[_data_n_29] = {
    3.0e0
  };
  if (__calls[9].calls == 0) {
    _data_k_26 = 0;
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    zero_ = _data_l_26[_data_k_26++];
    _data_k_27 = 0;
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    half_ = _data_l_27[_data_k_27++];
    _data_k_28 = 0;
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    two_ = _data_l_28[_data_k_28++];
    _data_k_29 = 0;
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    three_ = _data_l_29[_data_k_29++];
  }
  ibeg_ = ic_[0];
  iend_ = ic_[1];
  (*ierr_) = 0;
  if (_abs (ibeg_) > (*n_)) {
    ibeg_ = 0;
  }
  if (_abs (iend_) > (*n_)) {
    iend_ = 0;
  }
  if (ibeg_ == 0) {
    goto _l2000;
  }
  k_ = _abs (ibeg_);
  if (k_ == 1) {
    d_[0 + ((*incfd_)) * ((0))] = vc_[0];
  }
  else if (k_ == 2) {
    d_[0 + ((*incfd_)) * ((0))] = half_ * ((three_ * slope_[0] - d_[0 + ((*incfd_)) * ((1))]) - half_ * vc_[0] * h_[0]);
  }
  else if (k_ < 5) {
    for (j_ = 1; j_ <= k_; (j_)++) {
      index_ = k_ - j_ + 1;
      xtemp_[j_ - 1] = x_[index_ - 1];
      if (j_ < k_) {
        stemp_[j_ - 1] = slope_[index_ - 1 - 1];
      }
    }
    d_[0 + ((*incfd_)) * ((0))] = _dpchdf (&k_, xtemp_, stemp_, &ierf_);
    if (ierf_ != 0) {
      goto _l5001;
    }
  }
  else {
    d_[0 + ((*incfd_)) * ((0))] = (three_ * (h_[0] * slope_[1] + h_[1] * slope_[0]) - two_ * (h_[0] + h_[1]) * d_[0 + 
    ((*incfd_)) * ((1))] - h_[0] * d_[0 + ((*incfd_)) * ((2))]) / h_[1];
  }
  if (ibeg_ > 0) {
    goto _l2000;
  }
  if (slope_[0] == zero_) {
    if (d_[0 + ((*incfd_)) * ((0))] != zero_) {
      d_[0 + ((*incfd_)) * ((0))] = zero_;
      (*ierr_) = (*ierr_) + 1;
    }
  }
  else if (_dpchst (&d_[0 + ((*incfd_)) * ((0))], &slope_[0]) < zero_) {
    d_[0 + ((*incfd_)) * ((0))] = zero_;
    (*ierr_) = (*ierr_) + 1;
  }
  else if (_abs (d_[0 + ((*incfd_)) * ((0))]) > three_ * _abs (slope_[0])) {
    d_[0 + ((*incfd_)) * ((0))] = three_ * slope_[0];
    (*ierr_) = (*ierr_) + 1;
  }
  _l2000:;
  if (iend_ == 0) {
    goto _l5000;
  }
  k_ = _abs (iend_);
  if (k_ == 1) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = vc_[1];
  }
  else if (k_ == 2) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = half_ * ((three_ * slope_[(*n_) - 1 - 1] - d_[0 + ((*incfd_)) * (((*n_) - 1 - 
    1))]) + half_ * vc_[1] * h_[(*n_) - 1 - 1]);
  }
  else if (k_ < 5) {
    for (j_ = 1; j_ <= k_; (j_)++) {
      index_ = (*n_) - k_ + j_;
      xtemp_[j_ - 1] = x_[index_ - 1];
      if (j_ < k_) {
        stemp_[j_ - 1] = slope_[index_ - 1];
      }
    }
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = _dpchdf (&k_, xtemp_, stemp_, &ierf_);
    if (ierf_ != 0) {
      goto _l5001;
    }
  }
  else {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = (three_ * (h_[(*n_) - 1 - 1] * slope_[(*n_) - 2 - 1] + h_[(*n_) - 2 - 1] * 
    slope_[(*n_) - 1 - 1]) - two_ * (h_[(*n_) - 1 - 1] + h_[(*n_) - 2 - 1]) * d_[0 + ((*incfd_)) * (((*n_) - 1 - 1))] - 
    h_[(*n_) - 1 - 1] * d_[0 + ((*incfd_)) * (((*n_) - 2 - 1))]) / h_[(*n_) - 2 - 1];
  }
  if (iend_ > 0) {
    goto _l5000;
  }
  if (slope_[(*n_) - 1 - 1] == zero_) {
    if (d_[0 + ((*incfd_)) * (((*n_) - 1))] != zero_) {
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = zero_;
      (*ierr_) = (*ierr_) + 2;
    }
  }
  else if (_dpchst (&d_[0 + ((*incfd_)) * (((*n_) - 1))], &slope_[(*n_) - 1 - 1]) < zero_) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = zero_;
    (*ierr_) = (*ierr_) + 2;
  }
  else if (_abs (d_[0 + ((*incfd_)) * (((*n_) - 1))]) > three_ * _abs (slope_[(*n_) - 1 - 1])) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = three_ * slope_[(*n_) - 1 - 1];
    (*ierr_) = (*ierr_) + 2;
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_10, _dc_11, ierr_, &_k1);
  _l0:;
  __calls[9].calls++;
  return 0;
}

int_4 _dpchci (int_4 _p_ n_, real_8 _p_ h_, real_8 _p_ slope_, real_8 _p_ d_, int_4 _p_ incfd_)
{
  static int_4 i_, nless1_;
  static real_8 del1_, del2_, dmax_, dmin_, drat1_, drat2_, hsum_, hsumt3_, three_, w1_, w2_, zero_;
  int_4 _data_k_30, _data_k_31;
#define _data_n_30 1
  static real_8 _data_l_30[_data_n_30] = {
    0.0e0
  };
#define _data_n_31 1
  static real_8 _data_l_31[_data_n_31] = {
    3.0e0
  };
  if (__calls[10].calls == 0) {
    _data_k_30 = 0;
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    zero_ = _data_l_30[_data_k_30++];
    _data_k_31 = 0;
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    three_ = _data_l_31[_data_k_31++];
  }
  nless1_ = (*n_) - 1;
  del1_ = slope_[0];
  if (nless1_ > 1) {
    goto _l10;
  }
  d_[0 + ((*incfd_)) * ((0))] = del1_;
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = del1_;
  goto _l5000;
  _l10:;
  del2_ = slope_[1];
  hsum_ = h_[0] + h_[1];
  w1_ = (h_[0] + hsum_) / hsum_;
  w2_ = -h_[0] / hsum_;
  d_[0 + ((*incfd_)) * ((0))] = w1_ * del1_ + w2_ * del2_;
  if (_dpchst (&d_[0 + ((*incfd_)) * ((0))], &del1_) <= zero_) {
    d_[0 + ((*incfd_)) * ((0))] = zero_;
  }
  else if (_dpchst (&del1_, &del2_) < zero_) {
    dmax_ = three_ * del1_;
    if (_abs (d_[0 + ((*incfd_)) * ((0))]) > _abs (dmax_)) {
      d_[0 + ((*incfd_)) * ((0))] = dmax_;
    }
  }
  for (i_ = 2; i_ <= nless1_; (i_)++) {
    if (i_ == 2) {
      goto _l40;
    }
    hsum_ = h_[i_ - 1 - 1] + h_[i_ - 1];
    del1_ = del2_;
    del2_ = slope_[i_ - 1];
    _l40:;
    d_[0 + ((*incfd_)) * ((i_ - 1))] = zero_;
    if (_dpchst (&del1_, &del2_) <= zero_) {
      goto _l50;
    }
    hsumt3_ = hsum_ + hsum_ + hsum_;
    w1_ = (hsum_ + h_[i_ - 1 - 1]) / hsumt3_;
    w2_ = (hsum_ + h_[i_ - 1]) / hsumt3_;
    dmax_ = _max (_abs (del1_), _abs (del2_));
    dmin_ = _min (_abs (del1_), _abs (del2_));
    drat1_ = del1_ / dmax_;
    drat2_ = del2_ / dmax_;
    d_[0 + ((*incfd_)) * ((i_ - 1))] = dmin_ / (w1_ * drat1_ + w2_ * drat2_);
    _l50:;
  }
  w1_ = -h_[(*n_) - 1 - 1] / hsum_;
  w2_ = (h_[(*n_) - 1 - 1] + hsum_) / hsum_;
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = w1_ * del1_ + w2_ * del2_;
  if (_dpchst (&d_[0 + ((*incfd_)) * (((*n_) - 1))], &del2_) <= zero_) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = zero_;
  }
  else if (_dpchst (&del1_, &del2_) < zero_) {
    dmax_ = three_ * del2_;
    if (_abs (d_[0 + ((*incfd_)) * (((*n_) - 1))]) > _abs (dmax_)) {
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = dmax_;
    }
  }
  _l5000:;
  __calls[10].calls++;
  return 0;
}

int_4 _dpchcm (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, int_4 
_p_ ismon_, int_4 _p_ ierr_)
{
  static int_4 i_, nseg_;
  static real_8 delta_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  (*skip_) = TRUE;
  _l5:;
  nseg_ = (*n_) - 1;
  for (i_ = 1; i_ <= nseg_; (i_)++) {
    delta_ = (f_[0 + ((*incfd_)) * ((i_ + 1 - 1))] - f_[0 + ((*incfd_)) * ((i_ - 1))]) / (x_[i_ + 1 - 1] - x_[i_ - 1]);
    ismon_[i_ - 1] = _dchfcm (&d_[0 + ((*incfd_)) * ((i_ - 1))], &d_[0 + ((*incfd_)) * ((i_ + 1 - 1))], &delta_);
    if (i_ == 1) {
      ismon_[(*n_) - 1] = ismon_[0];
    }
    else {
      if ((ismon_[i_ - 1] != ismon_[(*n_) - 1]) && (ismon_[i_ - 1] != 0) && (ismon_[(*n_) - 1] != 2)) {
        if ((ismon_[i_ - 1] == 2) || (ismon_[(*n_) - 1] == 0)) {
          ismon_[(*n_) - 1] = ismon_[i_ - 1];
        }
        else if (ismon_[i_ - 1] * ismon_[(*n_) - 1] < 0) {
          ismon_[(*n_) - 1] = 2;
        }
        else {
          ismon_[(*n_) - 1] = (int_4) (_sign (3, ismon_[(*n_) - 1]));
        }
      }
    }
  }
  (*ierr_) = 0;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_12, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_12, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_12, _dc_15, ierr_, &_k1);
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _dpchcs (real_8 _p_ switch_, int_4 _p_ n_, real_8 _p_ h_, real_8 _p_ slope_, real_8 _p_ d_, int_4 _p_ incfd_, 
int_4 _p_ ierr_)
{
  static int_4 i_, indx_, k_, nless1_;
  static real_8 del_[3], dext_, dfloc_, dfmx_, fact_, fudge_, one_, slmax_, wtave_[2], zero_, s1_, s2_, h1_, h2_;
  int_4 _data_k_32, _data_k_33, _data_k_34;
  real_8 $0_, $1_;
#define _data_n_32 1
  static real_8 _data_l_32[_data_n_32] = {
    0.0e0
  };
#define _data_n_33 1
  static real_8 _data_l_33[_data_n_33] = {
    1.0e0
  };
#define _data_n_34 1
  static real_8 _data_l_34[_data_n_34] = {
    4.0e0
  };
  if (__calls[12].calls == 0) {
    _data_k_32 = 0;
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    zero_ = _data_l_32[_data_k_32++];
    _data_k_33 = 0;
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    one_ = _data_l_33[_data_k_33++];
  }
  if (__calls[12].calls == 0) {
    _data_k_34 = 0;
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    fudge_ = _data_l_34[_data_k_34++];
  }
  (*ierr_) = 0;
  nless1_ = (*n_) - 1;
  for (i_ = 2; i_ <= nless1_; (i_)++) {
    $0_ = _dpchst (&slope_[i_ - 1 - 1], &slope_[i_ - 1]);
    if ($0_ < 0) {
      goto _l100;
    } else if ($0_ == 0) {
      goto _l300;
    } else {
      goto _l900;
    }
    _l100:;
    if (i_ > 2) {
      if (_dpchst (&slope_[i_ - 2 - 1], &slope_[i_ - 1]) > zero_) {
        goto _l900;
      }
    }
    if (i_ < nless1_) {
      if (_dpchst (&slope_[i_ + 1 - 1], &slope_[i_ - 1 - 1]) > zero_) {
        goto _l900;
      }
    }
    dext_ = ({real_8 s1__1_ = slope_[i_ - 1 - 1]; real_8 s2__1_ = slope_[i_ - 1]; real_8 h1__1_ = h_[i_ - 1 - 1]; real_8 
    h2__1_ = h_[i_ - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    $1_ = _dpchst (&dext_, &slope_[i_ - 1 - 1]);
    if ($1_ < 0) {
      goto _l200;
    } else if ($1_ == 0) {
      goto _l900;
    } else {
      goto _l250;
    }
    _l200:;
    k_ = i_ - 1;
    wtave_[1] = dext_;
    if (k_ > 1) {
      wtave_[0] = ({real_8 s1__1_ = slope_[k_ - 1 - 1]; real_8 s2__1_ = slope_[k_ - 1]; real_8 h1__1_ = h_[k_ - 1 - 1]; 
      real_8 h2__1_ = h_[k_ - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    }
    goto _l400;
    _l250:;
    k_ = i_;
    wtave_[0] = dext_;
    if (k_ < nless1_) {
      wtave_[1] = ({real_8 s1__1_ = slope_[k_ - 1]; real_8 s2__1_ = slope_[k_ + 1 - 1]; real_8 h1__1_ = h_[k_ - 1]; real_8 
      h2__1_ = h_[k_ + 1 - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    }
    goto _l400;
    _l300:;
    if (i_ == nless1_) {
      goto _l900;
    }
    if (_dpchst (&slope_[i_ - 1 - 1], &slope_[i_ + 1 - 1]) >= zero_) {
      goto _l900;
    }
    k_ = i_;
    wtave_[0] = ({real_8 s1__1_ = slope_[k_ - 1 - 1]; real_8 s2__1_ = slope_[k_ - 1]; real_8 h1__1_ = h_[k_ - 1 - 1]; 
    real_8 h2__1_ = h_[k_ - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    wtave_[1] = ({real_8 s1__1_ = slope_[k_ - 1]; real_8 s2__1_ = slope_[k_ + 1 - 1]; real_8 h1__1_ = h_[k_ - 1]; real_8 
    h2__1_ = h_[k_ + 1 - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    _l400:;
    slmax_ = _abs (slope_[k_ - 1]);
    if (k_ > 1) {
      slmax_ = _max (slmax_, _abs (slope_[k_ - 1 - 1]));
    }
    if (k_ < nless1_) {
      slmax_ = _max (slmax_, _abs (slope_[k_ + 1 - 1]));
    }
    if (k_ > 1) {
      del_[0] = slope_[k_ - 1 - 1] / slmax_;
    }
    del_[1] = slope_[k_ - 1] / slmax_;
    if (k_ < nless1_) {
      del_[2] = slope_[k_ + 1 - 1] / slmax_;
    }
    if ((k_ > 1) && (k_ < nless1_)) {
      fact_ = fudge_ * _abs (del_[2] * (del_[0] - del_[1]) * (wtave_[1] / slmax_));
      d_[0 + ((*incfd_)) * ((k_ - 1))] = d_[0 + ((*incfd_)) * ((k_ - 1))] + _min (fact_, one_) * (wtave_[0] - d_[0 + 
      ((*incfd_)) * ((k_ - 1))]);
      fact_ = fudge_ * _abs (del_[0] * (del_[2] - del_[1]) * (wtave_[0] / slmax_));
      d_[0 + ((*incfd_)) * ((k_ + 1 - 1))] = d_[0 + ((*incfd_)) * ((k_ + 1 - 1))] + _min (fact_, one_) * (wtave_[1] - d_[0 + 
      ((*incfd_)) * ((k_ + 1 - 1))]);
    }
    else {
      fact_ = fudge_ * _abs (del_[1]);
      d_[0 + ((*incfd_)) * ((i_ - 1))] = _min (fact_, one_) * wtave_[i_ - k_ + 1 - 1];
    }
    if ((*switch_) <= zero_) {
      goto _l900;
    }
    dfloc_ = h_[k_ - 1] * _abs (slope_[k_ - 1]);
    if (k_ > 1) {
      dfloc_ = _max (dfloc_, h_[k_ - 1 - 1] * _abs (slope_[k_ - 1 - 1]));
    }
    if (k_ < nless1_) {
      dfloc_ = _max (dfloc_, h_[k_ + 1 - 1] * _abs (slope_[k_ + 1 - 1]));
    }
    dfmx_ = (*switch_) * dfloc_;
    indx_ = i_ - k_ + 1;
    (void) _dpchsw (&dfmx_, &indx_, &d_[0 + ((*incfd_)) * ((k_ - 1))], &d_[0 + ((*incfd_)) * ((k_ + 1 - 1))], &h_[k_ - 1], 
    &slope_[k_ - 1], ierr_);
    if ((*ierr_) != 0) {
      goto _l0;
    }
    _l900:;
  }
  _l0:;
  __calls[12].calls++;
  return 0;
}

real_8 _dpchdf (int_4 _p_ k_, real_8 _p_ x_, real_8 _p_ s_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  static real_8 value_, zero_;
  int_4 _data_k_35;
  real_8 dpchdf_;
#define _data_n_35 1
  static real_8 _data_l_35[_data_n_35] = {
    0.0e0
  };
  if (__calls[13].calls == 0) {
    _data_k_35 = 0;
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    zero_ = _data_l_35[_data_k_35++];
  }
  if ((*k_) < 3) {
    goto _l5001;
  }
  for (j_ = 2; j_ <= (*k_) - 1; (j_)++) {
    for (i_ = 1; i_ <= (*k_) - j_; (i_)++) {
      s_[i_ - 1] = (s_[i_ + 1 - 1] - s_[i_ - 1]) / (x_[i_ + j_ - 1] - x_[i_ - 1]);
    }
  }
  value_ = s_[0];
  for (i_ = 2; i_ <= (*k_) - 1; (i_)++) {
    value_ = s_[i_ - 1] + value_ * (x_[(*k_) - 1] - x_[i_ - 1]);
  }
  (*ierr_) = 0;
  dpchdf_ = value_;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_16, _dc_17, ierr_, &_k1);
  dpchdf_ = zero_;
  _l0:;
  __calls[13].calls++;
  return dpchdf_;
}

int_4 _dpchfd (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, int_4 
_p_ ne_, real_8 _p_ xe_, real_8 _p_ fe_, real_8 _p_ de_, int_4 _p_ ierr_)
{
  static int_4 i_, ierc_, ir_, j_, jfirst_, next_[2], nj_;
  int_4 $0_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  _l5:;
  if ((*ne_) < 1) {
    goto _l5004;
  }
  (*ierr_) = 0;
  (*skip_) = TRUE;
  jfirst_ = 1;
  ir_ = 2;
  _l10:;
  if (jfirst_ > (*ne_)) {
    goto _l5000;
  }
  for (j_ = jfirst_; j_ <= (*ne_); (j_)++) {
    if (xe_[j_ - 1] >= x_[ir_ - 1]) {
      goto _l30;
    }
  }
  j_ = (*ne_) + 1;
  goto _l40;
  _l30:;
  if (ir_ == (*n_)) {
    j_ = (*ne_) + 1;
  }
  _l40:;
  nj_ = j_ - jfirst_;
  if (nj_ == 0) {
    goto _l50;
  }
  (void) _dchfdv (&x_[ir_ - 1 - 1], &x_[ir_ - 1], &f_[0 + ((*incfd_)) * ((ir_ - 1 - 1))], &f_[0 + ((*incfd_)) * ((ir_ - 
  1))], &d_[0 + ((*incfd_)) * ((ir_ - 1 - 1))], &d_[0 + ((*incfd_)) * ((ir_ - 1))], &nj_, &xe_[jfirst_ - 1], &fe_[jfirst_ 
  - 1], &de_[jfirst_ - 1], next_, &ierc_);
  if (ierc_ < 0) {
    goto _l5005;
  }
  if (next_[1] == 0) {
    goto _l42;
  }
  if (ir_ < (*n_)) {
    goto _l41;
  }
  (*ierr_) = (*ierr_) + next_[1];
  goto _l42;
  _l41:;
  goto _l5005;
  _l42:;
  if (next_[0] == 0) {
    goto _l49;
  }
  if (ir_ > 2) {
    goto _l43;
  }
  (*ierr_) = (*ierr_) + next_[0];
  goto _l49;
  _l43:;
  for (i_ = jfirst_; i_ <= j_ - 1; (i_)++) {
    if (xe_[i_ - 1] < x_[ir_ - 1 - 1]) {
      goto _l45;
    }
  }
  goto _l5005;
  _l45:;
  j_ = i_;
  for (i_ = 1; i_ <= ir_ - 1; (i_)++) {
    if (xe_[j_ - 1] < x_[i_ - 1]) {
      goto _l47;
    }
  }
  _l47:;
  ir_ = _max (1, i_ - 1);
  _l49:;
  jfirst_ = j_;
  _l50:;
  ir_ = ir_ + 1;
  if (ir_ <= (*n_)) {
    goto _l10;
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_18, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_18, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_18, _dc_15, ierr_, &_k1);
  goto _l0;
  _l5004:;
  (*ierr_) = -4;
  (void) _xermsg (_dc_0, _dc_18, _dc_2, ierr_, &_k1);
  goto _l0;
  _l5005:;
  (*ierr_) = -5;
  (void) _xermsg (_dc_0, _dc_18, _dc_19, ierr_, ($0_ = 2, &$0_));
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _dpchfe (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, int_4 
_p_ ne_, real_8 _p_ xe_, real_8 _p_ fe_, int_4 _p_ ierr_)
{
  static int_4 i_, ierc_, ir_, j_, jfirst_, next_[2], nj_;
  int_4 $0_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  _l5:;
  if ((*ne_) < 1) {
    goto _l5004;
  }
  (*ierr_) = 0;
  (*skip_) = TRUE;
  jfirst_ = 1;
  ir_ = 2;
  _l10:;
  if (jfirst_ > (*ne_)) {
    goto _l5000;
  }
  for (j_ = jfirst_; j_ <= (*ne_); (j_)++) {
    if (xe_[j_ - 1] >= x_[ir_ - 1]) {
      goto _l30;
    }
  }
  j_ = (*ne_) + 1;
  goto _l40;
  _l30:;
  if (ir_ == (*n_)) {
    j_ = (*ne_) + 1;
  }
  _l40:;
  nj_ = j_ - jfirst_;
  if (nj_ == 0) {
    goto _l50;
  }
  (void) _dchfev (&x_[ir_ - 1 - 1], &x_[ir_ - 1], &f_[0 + ((*incfd_)) * ((ir_ - 1 - 1))], &f_[0 + ((*incfd_)) * ((ir_ - 
  1))], &d_[0 + ((*incfd_)) * ((ir_ - 1 - 1))], &d_[0 + ((*incfd_)) * ((ir_ - 1))], &nj_, &xe_[jfirst_ - 1], &fe_[jfirst_ 
  - 1], next_, &ierc_);
  if (ierc_ < 0) {
    goto _l5005;
  }
  if (next_[1] == 0) {
    goto _l42;
  }
  if (ir_ < (*n_)) {
    goto _l41;
  }
  (*ierr_) = (*ierr_) + next_[1];
  goto _l42;
  _l41:;
  goto _l5005;
  _l42:;
  if (next_[0] == 0) {
    goto _l49;
  }
  if (ir_ > 2) {
    goto _l43;
  }
  (*ierr_) = (*ierr_) + next_[0];
  goto _l49;
  _l43:;
  for (i_ = jfirst_; i_ <= j_ - 1; (i_)++) {
    if (xe_[i_ - 1] < x_[ir_ - 1 - 1]) {
      goto _l45;
    }
  }
  goto _l5005;
  _l45:;
  j_ = i_;
  for (i_ = 1; i_ <= ir_ - 1; (i_)++) {
    if (xe_[j_ - 1] < x_[i_ - 1]) {
      goto _l47;
    }
  }
  _l47:;
  ir_ = _max (1, i_ - 1);
  _l49:;
  jfirst_ = j_;
  _l50:;
  ir_ = ir_ + 1;
  if (ir_ <= (*n_)) {
    goto _l10;
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_20, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_20, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_20, _dc_15, ierr_, &_k1);
  goto _l0;
  _l5004:;
  (*ierr_) = -4;
  (void) _xermsg (_dc_0, _dc_20, _dc_2, ierr_, &_k1);
  goto _l0;
  _l5005:;
  (*ierr_) = -5;
  (void) _xermsg (_dc_0, _dc_20, _dc_21, ierr_, ($0_ = 2, &$0_));
  _l0:;
  __calls[15].calls++;
  return 0;
}

real_8 _dpchia (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, 
real_8 _p_ a_, real_8 _p_ b_, int_4 _p_ ierr_)
{
  static int_4 i_, ia_, ib_, ierd_, il_, ir_;
  static real_8 value_, xa_, xb_, zero_;
  int_4 _data_k_36;
  real_8 dpchia_;
#define _data_n_36 1
  static real_8 _data_l_36[_data_n_36] = {
    0.0e0
  };
  if (__calls[16].calls == 0) {
    _data_k_36 = 0;
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    zero_ = _data_l_36[_data_k_36++];
  }
  value_ = zero_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  _l5:;
  (*skip_) = TRUE;
  (*ierr_) = 0;
  if (((*a_) < x_[0]) || ((*a_) > x_[(*n_) - 1])) {
    (*ierr_) = (*ierr_) + 1;
  }
  if (((*b_) < x_[0]) || ((*b_) > x_[(*n_) - 1])) {
    (*ierr_) = (*ierr_) + 2;
  }
  if ((*a_) != (*b_)) {
    xa_ = _min ((*a_), (*b_));
    xb_ = _max ((*a_), (*b_));
    if (xb_ <= x_[1]) {
      value_ = _dchfie (&x_[0], &x_[1], &f_[0 + ((*incfd_)) * ((0))], &f_[0 + ((*incfd_)) * ((1))], &d_[0 + ((*incfd_)) * 
      ((0))], &d_[0 + ((*incfd_)) * ((1))], a_, b_);
    }
    else if (xa_ >= x_[(*n_) - 1 - 1]) {
      value_ = _dchfie (&x_[(*n_) - 1 - 1], &x_[(*n_) - 1], &f_[0 + ((*incfd_)) * (((*n_) - 1 - 1))], &f_[0 + ((*incfd_)) * 
      (((*n_) - 1))], &d_[0 + ((*incfd_)) * (((*n_) - 1 - 1))], &d_[0 + ((*incfd_)) * (((*n_) - 1))], a_, b_);
    }
    else {
      ia_ = 1;
      for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
        if (xa_ > x_[i_ - 1]) {
          ia_ = i_ + 1;
        }
      }
      ib_ = (*n_);
      for (i_ = (*n_); i_ >= ia_; (i_)--) {
        if (xb_ < x_[i_ - 1]) {
          ib_ = i_ - 1;
        }
      }
      if (ib_ < ia_) {
        value_ = _dchfie (&x_[ib_ - 1], &x_[ia_ - 1], &f_[0 + ((*incfd_)) * ((ib_ - 1))], &f_[0 + ((*incfd_)) * ((ia_ - 1))], 
        &d_[0 + ((*incfd_)) * ((ib_ - 1))], &d_[0 + ((*incfd_)) * ((ia_ - 1))], a_, b_);
      }
      else {
        if (ib_ > ia_) {
          value_ = _dpchid (n_, x_, f_, d_, incfd_, skip_, &ia_, &ib_, &ierd_);
          if (ierd_ < 0) {
            goto _l5004;
          }
        }
        if (xa_ < x_[ia_ - 1]) {
          il_ = _max (1, ia_ - 1);
          ir_ = il_ + 1;
          value_ = value_ + _dchfie (&x_[il_ - 1], &x_[ir_ - 1], &f_[0 + ((*incfd_)) * ((il_ - 1))], &f_[0 + ((*incfd_)) * ((ir_ 
          - 1))], &d_[0 + ((*incfd_)) * ((il_ - 1))], &d_[0 + ((*incfd_)) * ((ir_ - 1))], &xa_, &x_[ia_ - 1]);
        }
        if (xb_ > x_[ib_ - 1]) {
          ir_ = _min (ib_ + 1, (*n_));
          il_ = ir_ - 1;
          value_ = value_ + _dchfie (&x_[il_ - 1], &x_[ir_ - 1], &f_[0 + ((*incfd_)) * ((il_ - 1))], &f_[0 + ((*incfd_)) * ((ir_ 
          - 1))], &d_[0 + ((*incfd_)) * ((il_ - 1))], &d_[0 + ((*incfd_)) * ((ir_ - 1))], &x_[ib_ - 1], &xb_);
        }
        if ((*a_) > (*b_)) {
          value_ = -value_;
        }
      }
    }
  }
  _l5000:;
  dpchia_ = value_;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_22, _dc_13, ierr_, &_k1);
  goto _l5000;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_22, _dc_14, ierr_, &_k1);
  goto _l5000;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_22, _dc_15, ierr_, &_k1);
  goto _l5000;
  _l5004:;
  (*ierr_) = -4;
  (void) _xermsg (_dc_0, _dc_22, _dc_23, ierr_, &_k1);
  goto _l5000;
  _l0:;
  __calls[16].calls++;
  return dpchia_;
}

int_4 _dpchic (int_4 _p_ ic_, real_8 _p_ vc_, real_8 _p_ switch_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 
_p_ d_, int_4 _p_ incfd_, real_8 _p_ wk_, int_4 _p_ nwk_, int_4 _p_ ierr_)
{
  static int_4 i_, ibeg_, iend_, nless1_;
  static real_8 zero_;
  int_4 _data_k_37;
#define _data_n_37 1
  static real_8 _data_l_37[_data_n_37] = {
    0.0e0
  };
  if (__calls[17].calls == 0) {
    _data_k_37 = 0;
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    zero_ = _data_l_37[_data_k_37++];
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  ibeg_ = ic_[0];
  iend_ = ic_[1];
  (*ierr_) = 0;
  if (_abs (ibeg_) > 5) {
    (*ierr_) = (*ierr_) - 1;
  }
  if (_abs (iend_) > 5) {
    (*ierr_) = (*ierr_) - 2;
  }
  if ((*ierr_) < 0) {
    goto _l5004;
  }
  nless1_ = (*n_) - 1;
  if ((*nwk_) < 2 * nless1_) {
    goto _l5007;
  }
  for (i_ = 1; i_ <= nless1_; (i_)++) {
    wk_[i_ - 1] = x_[i_ + 1 - 1] - x_[i_ - 1];
    wk_[nless1_ + i_ - 1] = (f_[0 + ((*incfd_)) * ((i_ + 1 - 1))] - f_[0 + ((*incfd_)) * ((i_ - 1))]) / wk_[i_ - 1];
  }
  if (nless1_ > 1) {
    goto _l1000;
  }
  d_[0 + ((*incfd_)) * ((0))] = wk_[1];
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = wk_[1];
  goto _l3000;
  _l1000:;
  (void) _dpchci (n_, &wk_[0], &wk_[(*n_) - 1], d_, incfd_);
  if ((*switch_) == zero_) {
    goto _l3000;
  }
  (void) _dpchcs (switch_, n_, &wk_[0], &wk_[(*n_) - 1], d_, incfd_, ierr_);
  if ((*ierr_) != 0) {
    goto _l5008;
  }
  _l3000:;
  if ((ibeg_ == 0) && (iend_ == 0)) {
    goto _l5000;
  }
  (void) _dpchce (ic_, vc_, n_, x_, &wk_[0], &wk_[(*n_) - 1], d_, incfd_, ierr_);
  if ((*ierr_) < 0) {
    goto _l5009;
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_24, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_24, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_24, _dc_15, ierr_, &_k1);
  goto _l0;
  _l5004:;
  (*ierr_) = (*ierr_) - 3;
  (void) _xermsg (_dc_0, _dc_24, _dc_25, ierr_, &_k1);
  goto _l0;
  _l5007:;
  (*ierr_) = -7;
  (void) _xermsg (_dc_0, _dc_24, _dc_26, ierr_, &_k1);
  goto _l0;
  _l5008:;
  (*ierr_) = -8;
  (void) _xermsg (_dc_0, _dc_24, _dc_27, ierr_, &_k1);
  goto _l0;
  _l5009:;
  (*ierr_) = -9;
  (void) _xermsg (_dc_0, _dc_24, _dc_28, ierr_, &_k1);
  _l0:;
  __calls[17].calls++;
  return 0;
}

real_8 _dpchid (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, int_4 
_p_ ia_, int_4 _p_ ib_, int_4 _p_ ierr_)
{
  static int_4 i_, iup_, low_;
  static real_8 h_, half_, six_, sum_, value_, zero_;
  int_4 _data_k_38, _data_k_39, _data_k_40;
  real_8 dpchid_;
#define _data_n_38 1
  static real_8 _data_l_38[_data_n_38] = {
    0.0e0
  };
#define _data_n_39 1
  static real_8 _data_l_39[_data_n_39] = {
    .5e0
  };
#define _data_n_40 1
  static real_8 _data_l_40[_data_n_40] = {
    6.0e0
  };
  if (__calls[18].calls == 0) {
    _data_k_38 = 0;
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    zero_ = _data_l_38[_data_k_38++];
    _data_k_39 = 0;
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    half_ = _data_l_39[_data_k_39++];
    _data_k_40 = 0;
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    six_ = _data_l_40[_data_k_40++];
  }
  value_ = zero_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  _l5:;
  (*skip_) = TRUE;
  if (((*ia_) < 1) || ((*ia_) > (*n_))) {
    goto _l5004;
  }
  if (((*ib_) < 1) || ((*ib_) > (*n_))) {
    goto _l5004;
  }
  (*ierr_) = 0;
  if ((*ia_) != (*ib_)) {
    low_ = _min ((*ia_), (*ib_));
    iup_ = _max ((*ia_), (*ib_)) - 1;
    sum_ = zero_;
    for (i_ = low_; i_ <= iup_; (i_)++) {
      h_ = x_[i_ + 1 - 1] - x_[i_ - 1];
      sum_ = sum_ + h_ * ((f_[0 + ((*incfd_)) * ((i_ - 1))] + f_[0 + ((*incfd_)) * ((i_ + 1 - 1))]) + (d_[0 + ((*incfd_)) * 
      ((i_ - 1))] - d_[0 + ((*incfd_)) * ((i_ + 1 - 1))]) * (h_ / six_));
    }
    value_ = half_ * sum_;
    if ((*ia_) > (*ib_)) {
      value_ = -value_;
    }
  }
  _l5000:;
  dpchid_ = value_;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_29, _dc_13, ierr_, &_k1);
  goto _l5000;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_29, _dc_14, ierr_, &_k1);
  goto _l5000;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_29, _dc_15, ierr_, &_k1);
  goto _l5000;
  _l5004:;
  (*ierr_) = -4;
  (void) _xermsg (_dc_0, _dc_29, _dc_30, ierr_, &_k1);
  goto _l5000;
  _l0:;
  __calls[18].calls++;
  return dpchid_;
}
int_4 _dpchim (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ incfd_, int_4 _p_ ierr_)
{
  static int_4 i_, nless1_;
  static real_8 del1_, del2_, dmax_, dmin_, drat1_, drat2_, dsave_, h1_, h2_, hsum_, hsumt3_, three_, w1_, w2_, zero_;
  int_4 _data_k_41, _data_k_42;
  real_8 $0_;
#define _data_n_41 1
  static real_8 _data_l_41[_data_n_41] = {
    0.0e0
  };
#define _data_n_42 1
  static real_8 _data_l_42[_data_n_42] = {
    3.0e0
  };
  if (__calls[19].calls == 0) {
    _data_k_41 = 0;
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    zero_ = _data_l_41[_data_k_41++];
    _data_k_42 = 0;
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    three_ = _data_l_42[_data_k_42++];
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  (*ierr_) = 0;
  nless1_ = (*n_) - 1;
  h1_ = x_[1] - x_[0];
  del1_ = (f_[0 + ((*incfd_)) * ((1))] - f_[0 + ((*incfd_)) * ((0))]) / h1_;
  dsave_ = del1_;
  if (nless1_ > 1) {
    goto _l10;
  }
  d_[0 + ((*incfd_)) * ((0))] = del1_;
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = del1_;
  goto _l5000;
  _l10:;
  h2_ = x_[2] - x_[1];
  del2_ = (f_[0 + ((*incfd_)) * ((2))] - f_[0 + ((*incfd_)) * ((1))]) / h2_;
  hsum_ = h1_ + h2_;
  w1_ = (h1_ + hsum_) / hsum_;
  w2_ = -h1_ / hsum_;
  d_[0 + ((*incfd_)) * ((0))] = w1_ * del1_ + w2_ * del2_;
  if (_dpchst (&d_[0 + ((*incfd_)) * ((0))], &del1_) <= zero_) {
    d_[0 + ((*incfd_)) * ((0))] = zero_;
  }
  else if (_dpchst (&del1_, &del2_) < zero_) {
    dmax_ = three_ * del1_;
    if (_abs (d_[0 + ((*incfd_)) * ((0))]) > _abs (dmax_)) {
      d_[0 + ((*incfd_)) * ((0))] = dmax_;
    }
  }
  for (i_ = 2; i_ <= nless1_; (i_)++) {
    if (i_ == 2) {
      goto _l40;
    }
    h1_ = h2_;
    h2_ = x_[i_ + 1 - 1] - x_[i_ - 1];
    hsum_ = h1_ + h2_;
    del1_ = del2_;
    del2_ = (f_[0 + ((*incfd_)) * ((i_ + 1 - 1))] - f_[0 + ((*incfd_)) * ((i_ - 1))]) / h2_;
    _l40:;
    d_[0 + ((*incfd_)) * ((i_ - 1))] = zero_;
    $0_ = _dpchst (&del1_, &del2_);
    if ($0_ < 0) {
      goto _l42;
    } else if ($0_ == 0) {
      goto _l41;
    } else {
      goto _l45;
    }
    _l41:;
    if (del2_ == zero_) {
      goto _l50;
    }
    if (_dpchst (&dsave_, &del2_) < zero_) {
      (*ierr_) = (*ierr_) + 1;
    }
    dsave_ = del2_;
    goto _l50;
    _l42:;
    (*ierr_) = (*ierr_) + 1;
    dsave_ = del2_;
    goto _l50;
    _l45:;
    hsumt3_ = hsum_ + hsum_ + hsum_;
    w1_ = (hsum_ + h1_) / hsumt3_;
    w2_ = (hsum_ + h2_) / hsumt3_;
    dmax_ = _max (_abs (del1_), _abs (del2_));
    dmin_ = _min (_abs (del1_), _abs (del2_));
    drat1_ = del1_ / dmax_;
    drat2_ = del2_ / dmax_;
    d_[0 + ((*incfd_)) * ((i_ - 1))] = dmin_ / (w1_ * drat1_ + w2_ * drat2_);
    _l50:;
  }
  w1_ = -h2_ / hsum_;
  w2_ = (h2_ + hsum_) / hsum_;
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = w1_ * del1_ + w2_ * del2_;
  if (_dpchst (&d_[0 + ((*incfd_)) * (((*n_) - 1))], &del2_) <= zero_) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = zero_;
  }
  else if (_dpchst (&del1_, &del2_) < zero_) {
    dmax_ = three_ * del2_;
    if (_abs (d_[0 + ((*incfd_)) * (((*n_) - 1))]) > _abs (dmax_)) {
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = dmax_;
    }
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_31, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_31, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_31, _dc_15, ierr_, &_k1);
  _l0:;
  __calls[19].calls++;
  return 0;
}

int_4 _dpchkt (int_4 _p_ n_, real_8 _p_ x_, int_4 _p_ knotyp_, real_8 _p_ t_)
{
  static int_4 j_, k_, ndim_;
  static real_8 hbeg_, hend_;
  ndim_ = 2 * (*n_);
  j_ = 1;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    j_ = j_ + 2;
    t_[j_ - 1] = x_[k_ - 1];
    t_[j_ + 1 - 1] = t_[j_ - 1];
  }
  hbeg_ = x_[1] - x_[0];
  hend_ = x_[(*n_) - 1] - x_[(*n_) - 1 - 1];
  if ((*knotyp_) == 1) {
    t_[1] = x_[0] - hbeg_;
    t_[ndim_ + 3 - 1] = x_[(*n_) - 1] + hend_;
  }
  else if ((*knotyp_) == 2) {
    t_[1] = x_[0] - hend_;
    t_[ndim_ + 3 - 1] = x_[(*n_) - 1] + hbeg_;
  }
  else {
    t_[1] = x_[0];
    t_[ndim_ + 3 - 1] = x_[(*n_) - 1];
  }
  t_[0] = t_[1];
  t_[ndim_ + 4 - 1] = t_[ndim_ + 3 - 1];
  __calls[20].calls++;
  return 0;
}

int_4 _dpchsp (int_4 _p_ ic_, real_8 _p_ vc_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ f_, real_8 _p_ d_, int_4 _p_ 
incfd_, real_8 _p_ wk_, int_4 _p_ nwk_, int_4 _p_ ierr_)
{
  static int_4 ibeg_, iend_, index_, j_, nm1_;
  static real_8 g_, half_, one_, stemp_[3], three_, two_, xtemp_[4], zero_;
  int_4 _data_k_43, _data_k_44, _data_k_45, _data_k_46, _data_k_47;
#define _data_n_43 1
  static real_8 _data_l_43[_data_n_43] = {
    0.0e0
  };
#define _data_n_44 1
  static real_8 _data_l_44[_data_n_44] = {
    .5e0
  };
#define _data_n_45 1
  static real_8 _data_l_45[_data_n_45] = {
    1.0e0
  };
#define _data_n_46 1
  static real_8 _data_l_46[_data_n_46] = {
    2.0e0
  };
#define _data_n_47 1
  static real_8 _data_l_47[_data_n_47] = {
    3.0e0
  };
  if (__calls[21].calls == 0) {
    _data_k_43 = 0;
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    zero_ = _data_l_43[_data_k_43++];
    _data_k_44 = 0;
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    half_ = _data_l_44[_data_k_44++];
    _data_k_45 = 0;
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    one_ = _data_l_45[_data_k_45++];
    _data_k_46 = 0;
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    two_ = _data_l_46[_data_k_46++];
    _data_k_47 = 0;
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    three_ = _data_l_47[_data_k_47++];
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    if (x_[j_ - 1] <= x_[j_ - 1 - 1]) {
      goto _l5003;
    }
  }
  ibeg_ = ic_[0];
  iend_ = ic_[1];
  (*ierr_) = 0;
  if ((ibeg_ < 0) || (ibeg_ > 4)) {
    (*ierr_) = (*ierr_) - 1;
  }
  if ((iend_ < 0) || (iend_ > 4)) {
    (*ierr_) = (*ierr_) - 2;
  }
  if ((*ierr_) < 0) {
    goto _l5004;
  }
  if ((*nwk_) < 2 * (*n_)) {
    goto _l5007;
  }
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    wk_[0 + (2) * ((j_ - 1))] = x_[j_ - 1] - x_[j_ - 1 - 1];
    wk_[1 + (2) * ((j_ - 1))] = (f_[0 + ((*incfd_)) * ((j_ - 1))] - f_[0 + ((*incfd_)) * ((j_ - 1 - 1))]) / wk_[0 + (2) * 
    ((j_ - 1))];
  }
  if (ibeg_ > (*n_)) {
    ibeg_ = 0;
  }
  if (iend_ > (*n_)) {
    iend_ = 0;
  }
  if ((ibeg_ == 1) || (ibeg_ == 2)) {
    d_[0 + ((*incfd_)) * ((0))] = vc_[0];
  }
  else if (ibeg_ > 2) {
    for (j_ = 1; j_ <= ibeg_; (j_)++) {
      index_ = ibeg_ - j_ + 1;
      xtemp_[j_ - 1] = x_[index_ - 1];
      if (j_ < ibeg_) {
        stemp_[j_ - 1] = wk_[1 + (2) * ((index_ - 1))];
      }
    }
    d_[0 + ((*incfd_)) * ((0))] = _dpchdf (&ibeg_, xtemp_, stemp_, ierr_);
    if ((*ierr_) != 0) {
      goto _l5009;
    }
    ibeg_ = 1;
  }
  if ((iend_ == 1) || (iend_ == 2)) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = vc_[1];
  }
  else if (iend_ > 2) {
    for (j_ = 1; j_ <= iend_; (j_)++) {
      index_ = (*n_) - iend_ + j_;
      xtemp_[j_ - 1] = x_[index_ - 1];
      if (j_ < iend_) {
        stemp_[j_ - 1] = wk_[1 + (2) * ((index_ + 1 - 1))];
      }
    }
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = _dpchdf (&iend_, xtemp_, stemp_, ierr_);
    if ((*ierr_) != 0) {
      goto _l5009;
    }
    iend_ = 1;
  }
  if (ibeg_ == 0) {
    if ((*n_) == 2) {
      wk_[1] = one_;
      wk_[0] = one_;
      d_[0 + ((*incfd_)) * ((0))] = two_ * wk_[3];
    }
    else {
      wk_[1] = wk_[4];
      wk_[0] = wk_[2] + wk_[4];
      d_[0 + ((*incfd_)) * ((0))] = ((wk_[2] + two_ * wk_[0]) * wk_[3] * wk_[4] + (wk_[2] * wk_[2]) * wk_[5]) / wk_[0];
    }
  }
  else if (ibeg_ == 1) {
    wk_[1] = one_;
    wk_[0] = zero_;
  }
  else {
    wk_[1] = two_;
    wk_[0] = one_;
    d_[0 + ((*incfd_)) * ((0))] = three_ * wk_[3] - half_ * wk_[2] * d_[0 + ((*incfd_)) * ((0))];
  }
  nm1_ = (*n_) - 1;
  if (nm1_ > 1) {
    for (j_ = 2; j_ <= nm1_; (j_)++) {
      if (wk_[1 + (2) * ((j_ - 1 - 1))] == zero_) {
        goto _l5008;
      }
      g_ = -wk_[0 + (2) * ((j_ + 1 - 1))] / wk_[1 + (2) * ((j_ - 1 - 1))];
      d_[0 + ((*incfd_)) * ((j_ - 1))] = g_ * d_[0 + ((*incfd_)) * ((j_ - 1 - 1))] + three_ * (wk_[0 + (2) * ((j_ - 1))] * 
      wk_[1 + (2) * ((j_ + 1 - 1))] + wk_[0 + (2) * ((j_ + 1 - 1))] * wk_[1 + (2) * ((j_ - 1))]);
      wk_[1 + (2) * ((j_ - 1))] = g_ * wk_[0 + (2) * ((j_ - 1 - 1))] + two_ * (wk_[0 + (2) * ((j_ - 1))] + wk_[0 + (2) * ((j_ 
      + 1 - 1))]);
    }
  }
  if (iend_ == 1) {
    goto _l30;
  }
  if (iend_ == 0) {
    if ((*n_) == 2 && ibeg_ == 0) {
      d_[0 + ((*incfd_)) * ((1))] = wk_[3];
      goto _l30;
    }
    else if (((*n_) == 2) || ((*n_) == 3 && ibeg_ == 0)) {
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = two_ * wk_[1 + (2) * (((*n_) - 1))];
      wk_[1 + (2) * (((*n_) - 1))] = one_;
      if (wk_[1 + (2) * (((*n_) - 1 - 1))] == zero_) {
        goto _l5008;
      }
      g_ = -one_ / wk_[1 + (2) * (((*n_) - 1 - 1))];
    }
    else {
      g_ = wk_[0 + (2) * (((*n_) - 1 - 1))] + wk_[0 + (2) * (((*n_) - 1))];
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = ((wk_[0 + (2) * (((*n_) - 1))] + two_ * g_) * wk_[1 + (2) * (((*n_) - 1))] * 
      wk_[0 + (2) * (((*n_) - 1 - 1))] + (wk_[0 + (2) * (((*n_) - 1))] * wk_[0 + (2) * (((*n_) - 1))]) * (f_[0 + ((*incfd_)) 
      * (((*n_) - 1 - 1))] - f_[0 + ((*incfd_)) * (((*n_) - 2 - 1))]) / wk_[0 + (2) * (((*n_) - 1 - 1))]) / g_;
      if (wk_[1 + (2) * (((*n_) - 1 - 1))] == zero_) {
        goto _l5008;
      }
      g_ = -g_ / wk_[1 + (2) * (((*n_) - 1 - 1))];
      wk_[1 + (2) * (((*n_) - 1))] = wk_[0 + (2) * (((*n_) - 1 - 1))];
    }
  }
  else {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = three_ * wk_[1 + (2) * (((*n_) - 1))] + half_ * wk_[0 + (2) * (((*n_) - 1))] * 
    d_[0 + ((*incfd_)) * (((*n_) - 1))];
    wk_[1 + (2) * (((*n_) - 1))] = two_;
    if (wk_[1 + (2) * (((*n_) - 1 - 1))] == zero_) {
      goto _l5008;
    }
    g_ = -one_ / wk_[1 + (2) * (((*n_) - 1 - 1))];
  }
  wk_[1 + (2) * (((*n_) - 1))] = g_ * wk_[0 + (2) * (((*n_) - 1 - 1))] + wk_[1 + (2) * (((*n_) - 1))];
  if (wk_[1 + (2) * (((*n_) - 1))] == zero_) {
    goto _l5008;
  }
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = (g_ * d_[0 + ((*incfd_)) * (((*n_) - 1 - 1))] + d_[0 + ((*incfd_)) * (((*n_) - 
  1))]) / wk_[1 + (2) * (((*n_) - 1))];
  _l30:;
  for (j_ = nm1_; j_ >= 1; (j_)--) {
    if (wk_[1 + (2) * ((j_ - 1))] == zero_) {
      goto _l5008;
    }
    d_[0 + ((*incfd_)) * ((j_ - 1))] = (d_[0 + ((*incfd_)) * ((j_ - 1))] - wk_[0 + (2) * ((j_ - 1))] * d_[0 + ((*incfd_)) * 
    ((j_ + 1 - 1))]) / wk_[1 + (2) * ((j_ - 1))];
  }
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_32, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_32, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_32, _dc_15, ierr_, &_k1);
  goto _l0;
  _l5004:;
  (*ierr_) = (*ierr_) - 3;
  (void) _xermsg (_dc_0, _dc_32, _dc_25, ierr_, &_k1);
  goto _l0;
  _l5007:;
  (*ierr_) = -7;
  (void) _xermsg (_dc_0, _dc_32, _dc_26, ierr_, &_k1);
  goto _l0;
  _l5008:;
  (*ierr_) = -8;
  (void) _xermsg (_dc_0, _dc_32, _dc_33, ierr_, &_k1);
  goto _l0;
  _l5009:;
  (*ierr_) = -9;
  (void) _xermsg (_dc_0, _dc_32, _dc_11, ierr_, &_k1);
  _l0:;
  __calls[21].calls++;
  return 0;
}

real_8 _dpchst (real_8 _p_ arg1_, real_8 _p_ arg2_)
{
  static real_8 one_, zero_;
  int_4 _data_k_48, _data_k_49;
  real_8 dpchst_;
#define _data_n_48 1
  static real_8 _data_l_48[_data_n_48] = {
    0.0e0
  };
#define _data_n_49 1
  static real_8 _data_l_49[_data_n_49] = {
    1.0e0
  };
  if (__calls[22].calls == 0) {
    _data_k_48 = 0;
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    zero_ = _data_l_48[_data_k_48++];
    _data_k_49 = 0;
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    one_ = _data_l_49[_data_k_49++];
  }
  dpchst_ = _sign (one_, (*arg1_)) * _sign (one_, (*arg2_));
  if (((*arg1_) == zero_) || ((*arg2_) == zero_)) {
    dpchst_ = zero_;
  }
  __calls[22].calls++;
  return dpchst_;
}

int_4 _dpchsw (real_8 _p_ dfmax_, int_4 _p_ iextrm_, real_8 _p_ d1_, real_8 _p_ d2_, real_8 _p_ h_, real_8 _p_ slope_, 
int_4 _p_ ierr_)
{
  static real_8 cp_, fact_, hphi_, lambda_, nu_, one_, phi_, radcal_, rho_, sigma_, small_, that_, third_, three_, two_, 
  zero_;
  int_4 _data_k_50, _data_k_51, _data_k_52, _data_k_53, _data_k_54, _data_k_55, $0_;
  extern real_8 _d1mach ();
#define _data_n_50 1
  static real_8 _data_l_50[_data_n_50] = {
    0.0e0
  };
#define _data_n_51 1
  static real_8 _data_l_51[_data_n_51] = {
    1.0e0
  };
#define _data_n_52 1
  static real_8 _data_l_52[_data_n_52] = {
    2.0e0
  };
#define _data_n_53 1
  static real_8 _data_l_53[_data_n_53] = {
    3.0e0
  };
#define _data_n_54 1
  static real_8 _data_l_54[_data_n_54] = {
    100.0e0
  };
#define _data_n_55 1
  static real_8 _data_l_55[_data_n_55] = {
    0.33333e0
  };
  if (__calls[23].calls == 0) {
    _data_k_50 = 0;
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    zero_ = _data_l_50[_data_k_50++];
    _data_k_51 = 0;
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    one_ = _data_l_51[_data_k_51++];
    _data_k_52 = 0;
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    two_ = _data_l_52[_data_k_52++];
    _data_k_53 = 0;
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    three_ = _data_l_53[_data_k_53++];
    _data_k_54 = 0;
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    fact_ = _data_l_54[_data_k_54++];
  }
  if (__calls[23].calls == 0) {
    _data_k_55 = 0;
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    third_ = _data_l_55[_data_k_55++];
  }
  small_ = fact_ * _d1mach (($0_ = 4, &$0_));
  if ((*d1_) == zero_) {
    if ((*d2_) == zero_) {
      goto _l5001;
    }
    rho_ = (*slope_) / (*d2_);
    if (rho_ >= third_) {
      goto _l5000;
    }
    that_ = (two_ * (three_ * rho_ - one_)) / (three_ * (two_ * rho_ - one_));
    phi_ = (that_ * that_) * ((three_ * rho_ - one_) / three_);
    if ((*iextrm_) != 1) {
      phi_ = phi_ - rho_;
    }
    hphi_ = (*h_) * _abs (phi_);
    if (hphi_ * _abs ((*d2_)) > (*dfmax_)) {
      (*d2_) = _sign ((*dfmax_) / hphi_, (*d2_));
    }
  }
  else {
    rho_ = (*slope_) / (*d1_);
    lambda_ = -(*d2_) / (*d1_);
    if ((*d2_) == zero_) {
      if (rho_ >= third_) {
        goto _l5000;
      }
      cp_ = two_ - three_ * rho_;
      nu_ = one_ - two_ * rho_;
      that_ = one_ / (three_ * nu_);
    }
    else {
      if (lambda_ <= zero_) {
        goto _l5001;
      }
      nu_ = one_ - lambda_ - two_ * rho_;
      sigma_ = one_ - rho_;
      cp_ = nu_ + sigma_;
      if (_abs (nu_) > small_) {
        radcal_ = (nu_ - (two_ * rho_ + one_)) * nu_ + (sigma_ * sigma_);
        if (radcal_ < zero_) {
          goto _l5002;
        }
        that_ = (cp_ - sqrt (radcal_)) / (three_ * nu_);
      }
      else {
        that_ = one_ / (two_ * sigma_);
      }
    }
    phi_ = that_ * ((nu_ * that_ - cp_) * that_ + one_);
    if ((*iextrm_) != 1) {
      phi_ = phi_ - rho_;
    }
    hphi_ = (*h_) * _abs (phi_);
    if (hphi_ * _abs ((*d1_)) > (*dfmax_)) {
      (*d1_) = _sign ((*dfmax_) / hphi_, (*d1_));
      (*d2_) = -lambda_ * (*d1_);
    }
  }
  _l5000:;
  (*ierr_) = 0;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_34, _dc_35, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_34, _dc_36, ierr_, &_k1);
  _l0:;
  __calls[23].calls++;
  return 0;
}

int_4 _pchbs (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, int_4 _p_ knotyp_, int_4 _p_ 
nknots_, real_4 _p_ t_, real_4 _p_ bcoef_, int_4 _p_ ndim_, int_4 _p_ kord_, int_4 _p_ ierr_)
{
  static int_4 k_, kk_;
  static real_4 dov3_, hnew_, hold_;
  static char_15 libnam_, subnam_;
  (*ndim_) = 2 * (*n_);
  (*kord_) = 4;
  (*ierr_) = 0;
  bufcpy (libnam_, _dc_0, 15);
  bufcpy (subnam_, _dc_37, 15);
  if ((*knotyp_) > 2) {
    (*ierr_) = -1;
    (void) _xermsg (libnam_, subnam_, _dc_8, ierr_, &_k1);
    goto _l0;
  }
  if ((*knotyp_) < 0) {
    if ((*nknots_) != (*ndim_) + 4) {
      (*ierr_) = -2;
      (void) _xermsg (libnam_, subnam_, _dc_9, ierr_, &_k1);
      goto _l0;
    }
  }
  else {
    (*nknots_) = (*ndim_) + 4;
    (void) _pchkt (n_, x_, knotyp_, t_);
  }
  hnew_ = t_[2] - t_[0];
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    kk_ = 2 * k_;
    hold_ = hnew_;
    dov3_ = d_[0 + ((*incfd_)) * ((k_ - 1))] / 3;
    bcoef_[kk_ - 1 - 1] = f_[0 + ((*incfd_)) * ((k_ - 1))] - hold_ * dov3_;
    hnew_ = t_[kk_ + 3 - 1] - t_[kk_ + 1 - 1];
    bcoef_[kk_ - 1] = f_[0 + ((*incfd_)) * ((k_ - 1))] + hnew_ * dov3_;
  }
  _l0:;
  __calls[24].calls++;
  return 0;
}

int_4 _pchce (int_4 _p_ ic_, real_4 _p_ vc_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ h_, real_4 _p_ slope_, real_4 _p_ 
d_, int_4 _p_ incfd_, int_4 _p_ ierr_)
{
  static int_4 ibeg_, iend_, ierf_, index_, j_, k_;
  static real_4 half_, stemp_[3], three_, two_, xtemp_[4], zero_;
  int_4 _data_k_56, _data_k_57, _data_k_58, _data_k_59;
#define _data_n_56 1
  static real_4 _data_l_56[_data_n_56] = {
    0.0
  };
#define _data_n_57 1
  static real_4 _data_l_57[_data_n_57] = {
    0.5
  };
#define _data_n_58 1
  static real_4 _data_l_58[_data_n_58] = {
    2.0
  };
#define _data_n_59 1
  static real_4 _data_l_59[_data_n_59] = {
    3.0
  };
  if (__calls[25].calls == 0) {
    _data_k_56 = 0;
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    zero_ = _data_l_56[_data_k_56++];
    _data_k_57 = 0;
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    half_ = _data_l_57[_data_k_57++];
    _data_k_58 = 0;
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    two_ = _data_l_58[_data_k_58++];
    _data_k_59 = 0;
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    three_ = _data_l_59[_data_k_59++];
  }
  ibeg_ = ic_[0];
  iend_ = ic_[1];
  (*ierr_) = 0;
  if (_abs (ibeg_) > (*n_)) {
    ibeg_ = 0;
  }
  if (_abs (iend_) > (*n_)) {
    iend_ = 0;
  }
  if (ibeg_ == 0) {
    goto _l2000;
  }
  k_ = _abs (ibeg_);
  if (k_ == 1) {
    d_[0 + ((*incfd_)) * ((0))] = vc_[0];
  }
  else if (k_ == 2) {
    d_[0 + ((*incfd_)) * ((0))] = half_ * ((three_ * slope_[0] - d_[0 + ((*incfd_)) * ((1))]) - half_ * vc_[0] * h_[0]);
  }
  else if (k_ < 5) {
    for (j_ = 1; j_ <= k_; (j_)++) {
      index_ = k_ - j_ + 1;
      xtemp_[j_ - 1] = x_[index_ - 1];
      if (j_ < k_) {
        stemp_[j_ - 1] = slope_[index_ - 1 - 1];
      }
    }
    d_[0 + ((*incfd_)) * ((0))] = _pchdf (&k_, xtemp_, stemp_, &ierf_);
    if (ierf_ != 0) {
      goto _l5001;
    }
  }
  else {
    d_[0 + ((*incfd_)) * ((0))] = (three_ * (h_[0] * slope_[1] + h_[1] * slope_[0]) - two_ * (h_[0] + h_[1]) * d_[0 + 
    ((*incfd_)) * ((1))] - h_[0] * d_[0 + ((*incfd_)) * ((2))]) / h_[1];
  }
  if (ibeg_ > 0) {
    goto _l2000;
  }
  if (slope_[0] == zero_) {
    if (d_[0 + ((*incfd_)) * ((0))] != zero_) {
      d_[0 + ((*incfd_)) * ((0))] = zero_;
      (*ierr_) = (*ierr_) + 1;
    }
  }
  else if (_pchst (&d_[0 + ((*incfd_)) * ((0))], &slope_[0]) < zero_) {
    d_[0 + ((*incfd_)) * ((0))] = zero_;
    (*ierr_) = (*ierr_) + 1;
  }
  else if (_abs (d_[0 + ((*incfd_)) * ((0))]) > three_ * _abs (slope_[0])) {
    d_[0 + ((*incfd_)) * ((0))] = three_ * slope_[0];
    (*ierr_) = (*ierr_) + 1;
  }
  _l2000:;
  if (iend_ == 0) {
    goto _l5000;
  }
  k_ = _abs (iend_);
  if (k_ == 1) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = vc_[1];
  }
  else if (k_ == 2) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = half_ * ((three_ * slope_[(*n_) - 1 - 1] - d_[0 + ((*incfd_)) * (((*n_) - 1 - 
    1))]) + half_ * vc_[1] * h_[(*n_) - 1 - 1]);
  }
  else if (k_ < 5) {
    for (j_ = 1; j_ <= k_; (j_)++) {
      index_ = (*n_) - k_ + j_;
      xtemp_[j_ - 1] = x_[index_ - 1];
      if (j_ < k_) {
        stemp_[j_ - 1] = slope_[index_ - 1];
      }
    }
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = _pchdf (&k_, xtemp_, stemp_, &ierf_);
    if (ierf_ != 0) {
      goto _l5001;
    }
  }
  else {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = (three_ * (h_[(*n_) - 1 - 1] * slope_[(*n_) - 2 - 1] + h_[(*n_) - 2 - 1] * 
    slope_[(*n_) - 1 - 1]) - two_ * (h_[(*n_) - 1 - 1] + h_[(*n_) - 2 - 1]) * d_[0 + ((*incfd_)) * (((*n_) - 1 - 1))] - 
    h_[(*n_) - 1 - 1] * d_[0 + ((*incfd_)) * (((*n_) - 2 - 1))]) / h_[(*n_) - 2 - 1];
  }
  if (iend_ > 0) {
    goto _l5000;
  }
  if (slope_[(*n_) - 1 - 1] == zero_) {
    if (d_[0 + ((*incfd_)) * (((*n_) - 1))] != zero_) {
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = zero_;
      (*ierr_) = (*ierr_) + 2;
    }
  }
  else if (_pchst (&d_[0 + ((*incfd_)) * (((*n_) - 1))], &slope_[(*n_) - 1 - 1]) < zero_) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = zero_;
    (*ierr_) = (*ierr_) + 2;
  }
  else if (_abs (d_[0 + ((*incfd_)) * (((*n_) - 1))]) > three_ * _abs (slope_[(*n_) - 1 - 1])) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = three_ * slope_[(*n_) - 1 - 1];
    (*ierr_) = (*ierr_) + 2;
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_38, _dc_39, ierr_, &_k1);
  _l0:;
  __calls[25].calls++;
  return 0;
}

int_4 _pchci (int_4 _p_ n_, real_4 _p_ h_, real_4 _p_ slope_, real_4 _p_ d_, int_4 _p_ incfd_)
{
  static int_4 i_, nless1_;
  static real_4 del1_, del2_, dmax_, dmin_, drat1_, drat2_, hsum_, hsumt3_, three_, w1_, w2_, zero_;
  int_4 _data_k_60, _data_k_61;
#define _data_n_60 1
  static real_4 _data_l_60[_data_n_60] = {
    0.0
  };
#define _data_n_61 1
  static real_4 _data_l_61[_data_n_61] = {
    3.0
  };
  if (__calls[26].calls == 0) {
    _data_k_60 = 0;
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    zero_ = _data_l_60[_data_k_60++];
    _data_k_61 = 0;
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    three_ = _data_l_61[_data_k_61++];
  }
  nless1_ = (*n_) - 1;
  del1_ = slope_[0];
  if (nless1_ > 1) {
    goto _l10;
  }
  d_[0 + ((*incfd_)) * ((0))] = del1_;
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = del1_;
  goto _l5000;
  _l10:;
  del2_ = slope_[1];
  hsum_ = h_[0] + h_[1];
  w1_ = (h_[0] + hsum_) / hsum_;
  w2_ = -h_[0] / hsum_;
  d_[0 + ((*incfd_)) * ((0))] = w1_ * del1_ + w2_ * del2_;
  if (_pchst (&d_[0 + ((*incfd_)) * ((0))], &del1_) <= zero_) {
    d_[0 + ((*incfd_)) * ((0))] = zero_;
  }
  else if (_pchst (&del1_, &del2_) < zero_) {
    dmax_ = three_ * del1_;
    if (_abs (d_[0 + ((*incfd_)) * ((0))]) > _abs (dmax_)) {
      d_[0 + ((*incfd_)) * ((0))] = dmax_;
    }
  }
  for (i_ = 2; i_ <= nless1_; (i_)++) {
    if (i_ == 2) {
      goto _l40;
    }
    hsum_ = h_[i_ - 1 - 1] + h_[i_ - 1];
    del1_ = del2_;
    del2_ = slope_[i_ - 1];
    _l40:;
    d_[0 + ((*incfd_)) * ((i_ - 1))] = zero_;
    if (_pchst (&del1_, &del2_) <= zero_) {
      goto _l50;
    }
    hsumt3_ = hsum_ + hsum_ + hsum_;
    w1_ = (hsum_ + h_[i_ - 1 - 1]) / hsumt3_;
    w2_ = (hsum_ + h_[i_ - 1]) / hsumt3_;
    dmax_ = _max (_abs (del1_), _abs (del2_));
    dmin_ = _min (_abs (del1_), _abs (del2_));
    drat1_ = del1_ / dmax_;
    drat2_ = del2_ / dmax_;
    d_[0 + ((*incfd_)) * ((i_ - 1))] = dmin_ / (w1_ * drat1_ + w2_ * drat2_);
    _l50:;
  }
  w1_ = -h_[(*n_) - 1 - 1] / hsum_;
  w2_ = (h_[(*n_) - 1 - 1] + hsum_) / hsum_;
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = w1_ * del1_ + w2_ * del2_;
  if (_pchst (&d_[0 + ((*incfd_)) * (((*n_) - 1))], &del2_) <= zero_) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = zero_;
  }
  else if (_pchst (&del1_, &del2_) < zero_) {
    dmax_ = three_ * del2_;
    if (_abs (d_[0 + ((*incfd_)) * (((*n_) - 1))]) > _abs (dmax_)) {
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = dmax_;
    }
  }
  _l5000:;
  __calls[26].calls++;
  return 0;
}

int_4 _pchcm (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, int_4 
_p_ ismon_, int_4 _p_ ierr_)
{
  static int_4 i_, nseg_;
  static real_4 delta_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  (*skip_) = TRUE;
  _l5:;
  nseg_ = (*n_) - 1;
  for (i_ = 1; i_ <= nseg_; (i_)++) {
    delta_ = (f_[0 + ((*incfd_)) * ((i_ + 1 - 1))] - f_[0 + ((*incfd_)) * ((i_ - 1))]) / (x_[i_ + 1 - 1] - x_[i_ - 1]);
    ismon_[i_ - 1] = _chfcm (&d_[0 + ((*incfd_)) * ((i_ - 1))], &d_[0 + ((*incfd_)) * ((i_ + 1 - 1))], &delta_);
    if (i_ == 1) {
      ismon_[(*n_) - 1] = ismon_[0];
    }
    else {
      if ((ismon_[i_ - 1] != ismon_[(*n_) - 1]) && (ismon_[i_ - 1] != 0) && (ismon_[(*n_) - 1] != 2)) {
        if ((ismon_[i_ - 1] == 2) || (ismon_[(*n_) - 1] == 0)) {
          ismon_[(*n_) - 1] = ismon_[i_ - 1];
        }
        else if (ismon_[i_ - 1] * ismon_[(*n_) - 1] < 0) {
          ismon_[(*n_) - 1] = 2;
        }
        else {
          ismon_[(*n_) - 1] = (int_4) (_sign (3, ismon_[(*n_) - 1]));
        }
      }
    }
  }
  (*ierr_) = 0;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_40, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_40, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_40, _dc_15, ierr_, &_k1);
  _l0:;
  __calls[27].calls++;
  return 0;
}

int_4 _pchcs (real_4 _p_ switch_, int_4 _p_ n_, real_4 _p_ h_, real_4 _p_ slope_, real_4 _p_ d_, int_4 _p_ incfd_, 
int_4 _p_ ierr_)
{
  static int_4 i_, indx_, k_, nless1_;
  static real_4 del_[3], dext_, dfloc_, dfmx_, fact_, fudge_, one_, slmax_, wtave_[2], zero_, s1_, s2_, h1_, h2_;
  int_4 _data_k_62, _data_k_63, _data_k_64;
  real_4 $0_, $1_;
#define _data_n_62 1
  static real_4 _data_l_62[_data_n_62] = {
    0.0
  };
#define _data_n_63 1
  static real_4 _data_l_63[_data_n_63] = {
    1.0
  };
#define _data_n_64 1
  static real_4 _data_l_64[_data_n_64] = {
    4.0
  };
  if (__calls[28].calls == 0) {
    _data_k_62 = 0;
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    zero_ = _data_l_62[_data_k_62++];
    _data_k_63 = 0;
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    one_ = _data_l_63[_data_k_63++];
  }
  if (__calls[28].calls == 0) {
    _data_k_64 = 0;
    if (_data_k_64 >= _data_n_64) {
      _data_k_64 = 0;
    }
    fudge_ = _data_l_64[_data_k_64++];
  }
  (*ierr_) = 0;
  nless1_ = (*n_) - 1;
  for (i_ = 2; i_ <= nless1_; (i_)++) {
    $0_ = _pchst (&slope_[i_ - 1 - 1], &slope_[i_ - 1]);
    if ($0_ < 0) {
      goto _l100;
    } else if ($0_ == 0) {
      goto _l300;
    } else {
      goto _l900;
    }
    _l100:;
    if (i_ > 2) {
      if (_pchst (&slope_[i_ - 2 - 1], &slope_[i_ - 1]) > zero_) {
        goto _l900;
      }
    }
    if (i_ < nless1_) {
      if (_pchst (&slope_[i_ + 1 - 1], &slope_[i_ - 1 - 1]) > zero_) {
        goto _l900;
      }
    }
    dext_ = ({real_4 s1__1_ = slope_[i_ - 1 - 1]; real_4 s2__1_ = slope_[i_ - 1]; real_4 h1__1_ = h_[i_ - 1 - 1]; real_4 
    h2__1_ = h_[i_ - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    $1_ = _pchst (&dext_, &slope_[i_ - 1 - 1]);
    if ($1_ < 0) {
      goto _l200;
    } else if ($1_ == 0) {
      goto _l900;
    } else {
      goto _l250;
    }
    _l200:;
    k_ = i_ - 1;
    wtave_[1] = dext_;
    if (k_ > 1) {
      wtave_[0] = ({real_4 s1__1_ = slope_[k_ - 1 - 1]; real_4 s2__1_ = slope_[k_ - 1]; real_4 h1__1_ = h_[k_ - 1 - 1]; 
      real_4 h2__1_ = h_[k_ - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    }
    goto _l400;
    _l250:;
    k_ = i_;
    wtave_[0] = dext_;
    if (k_ < nless1_) {
      wtave_[1] = ({real_4 s1__1_ = slope_[k_ - 1]; real_4 s2__1_ = slope_[k_ + 1 - 1]; real_4 h1__1_ = h_[k_ - 1]; real_4 
      h2__1_ = h_[k_ + 1 - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    }
    goto _l400;
    _l300:;
    if (i_ == nless1_) {
      goto _l900;
    }
    if (_pchst (&slope_[i_ - 1 - 1], &slope_[i_ + 1 - 1]) >= zero_) {
      goto _l900;
    }
    k_ = i_;
    wtave_[0] = ({real_4 s1__1_ = slope_[k_ - 1 - 1]; real_4 s2__1_ = slope_[k_ - 1]; real_4 h1__1_ = h_[k_ - 1 - 1]; 
    real_4 h2__1_ = h_[k_ - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    wtave_[1] = ({real_4 s1__1_ = slope_[k_ - 1]; real_4 s2__1_ = slope_[k_ + 1 - 1]; real_4 h1__1_ = h_[k_ - 1]; real_4 
    h2__1_ = h_[k_ + 1 - 1]; (h2__1_ / (h1__1_ + h2__1_)) * s1__1_ + (h1__1_ / (h1__1_ + h2__1_)) * s2__1_;});
    _l400:;
    slmax_ = _abs (slope_[k_ - 1]);
    if (k_ > 1) {
      slmax_ = _max (slmax_, _abs (slope_[k_ - 1 - 1]));
    }
    if (k_ < nless1_) {
      slmax_ = _max (slmax_, _abs (slope_[k_ + 1 - 1]));
    }
    if (k_ > 1) {
      del_[0] = slope_[k_ - 1 - 1] / slmax_;
    }
    del_[1] = slope_[k_ - 1] / slmax_;
    if (k_ < nless1_) {
      del_[2] = slope_[k_ + 1 - 1] / slmax_;
    }
    if ((k_ > 1) && (k_ < nless1_)) {
      fact_ = fudge_ * _abs (del_[2] * (del_[0] - del_[1]) * (wtave_[1] / slmax_));
      d_[0 + ((*incfd_)) * ((k_ - 1))] = d_[0 + ((*incfd_)) * ((k_ - 1))] + _min (fact_, one_) * (wtave_[0] - d_[0 + 
      ((*incfd_)) * ((k_ - 1))]);
      fact_ = fudge_ * _abs (del_[0] * (del_[2] - del_[1]) * (wtave_[0] / slmax_));
      d_[0 + ((*incfd_)) * ((k_ + 1 - 1))] = d_[0 + ((*incfd_)) * ((k_ + 1 - 1))] + _min (fact_, one_) * (wtave_[1] - d_[0 + 
      ((*incfd_)) * ((k_ + 1 - 1))]);
    }
    else {
      fact_ = fudge_ * _abs (del_[1]);
      d_[0 + ((*incfd_)) * ((i_ - 1))] = _min (fact_, one_) * wtave_[i_ - k_ + 1 - 1];
    }
    if ((*switch_) <= zero_) {
      goto _l900;
    }
    dfloc_ = h_[k_ - 1] * _abs (slope_[k_ - 1]);
    if (k_ > 1) {
      dfloc_ = _max (dfloc_, h_[k_ - 1 - 1] * _abs (slope_[k_ - 1 - 1]));
    }
    if (k_ < nless1_) {
      dfloc_ = _max (dfloc_, h_[k_ + 1 - 1] * _abs (slope_[k_ + 1 - 1]));
    }
    dfmx_ = (*switch_) * dfloc_;
    indx_ = i_ - k_ + 1;
    (void) _pchsw (&dfmx_, &indx_, &d_[0 + ((*incfd_)) * ((k_ - 1))], &d_[0 + ((*incfd_)) * ((k_ + 1 - 1))], &h_[k_ - 1], 
    &slope_[k_ - 1], ierr_);
    if ((*ierr_) != 0) {
      goto _l0;
    }
    _l900:;
  }
  _l0:;
  __calls[28].calls++;
  return 0;
}

real_4 _pchdf (int_4 _p_ k_, real_4 _p_ x_, real_4 _p_ s_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  static real_4 value_, zero_;
  int_4 _data_k_65;
  real_4 pchdf_;
#define _data_n_65 1
  static real_4 _data_l_65[_data_n_65] = {
    0.0
  };
  if (__calls[29].calls == 0) {
    _data_k_65 = 0;
    if (_data_k_65 >= _data_n_65) {
      _data_k_65 = 0;
    }
    zero_ = _data_l_65[_data_k_65++];
  }
  if ((*k_) < 3) {
    goto _l5001;
  }
  for (j_ = 2; j_ <= (*k_) - 1; (j_)++) {
    for (i_ = 1; i_ <= (*k_) - j_; (i_)++) {
      s_[i_ - 1] = (s_[i_ + 1 - 1] - s_[i_ - 1]) / (x_[i_ + j_ - 1] - x_[i_ - 1]);
    }
  }
  value_ = s_[0];
  for (i_ = 2; i_ <= (*k_) - 1; (i_)++) {
    value_ = s_[i_ - 1] + value_ * (x_[(*k_) - 1] - x_[i_ - 1]);
  }
  (*ierr_) = 0;
  pchdf_ = value_;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_41, _dc_17, ierr_, &_k1);
  pchdf_ = zero_;
  _l0:;
  __calls[29].calls++;
  return pchdf_;
}

int_4 _pchdoc (void)
{
  __calls[30].calls++;
  return 0;
}

int_4 _pchfd (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, int_4 
_p_ ne_, real_4 _p_ xe_, real_4 _p_ fe_, real_4 _p_ de_, int_4 _p_ ierr_)
{
  static int_4 i_, ierc_, ir_, j_, jfirst_, next_[2], nj_;
  int_4 $0_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  _l5:;
  if ((*ne_) < 1) {
    goto _l5004;
  }
  (*ierr_) = 0;
  (*skip_) = TRUE;
  jfirst_ = 1;
  ir_ = 2;
  _l10:;
  if (jfirst_ > (*ne_)) {
    goto _l5000;
  }
  for (j_ = jfirst_; j_ <= (*ne_); (j_)++) {
    if (xe_[j_ - 1] >= x_[ir_ - 1]) {
      goto _l30;
    }
  }
  j_ = (*ne_) + 1;
  goto _l40;
  _l30:;
  if (ir_ == (*n_)) {
    j_ = (*ne_) + 1;
  }
  _l40:;
  nj_ = j_ - jfirst_;
  if (nj_ == 0) {
    goto _l50;
  }
  (void) _chfdv (&x_[ir_ - 1 - 1], &x_[ir_ - 1], &f_[0 + ((*incfd_)) * ((ir_ - 1 - 1))], &f_[0 + ((*incfd_)) * ((ir_ - 
  1))], &d_[0 + ((*incfd_)) * ((ir_ - 1 - 1))], &d_[0 + ((*incfd_)) * ((ir_ - 1))], &nj_, &xe_[jfirst_ - 1], &fe_[jfirst_ 
  - 1], &de_[jfirst_ - 1], next_, &ierc_);
  if (ierc_ < 0) {
    goto _l5005;
  }
  if (next_[1] == 0) {
    goto _l42;
  }
  if (ir_ < (*n_)) {
    goto _l41;
  }
  (*ierr_) = (*ierr_) + next_[1];
  goto _l42;
  _l41:;
  goto _l5005;
  _l42:;
  if (next_[0] == 0) {
    goto _l49;
  }
  if (ir_ > 2) {
    goto _l43;
  }
  (*ierr_) = (*ierr_) + next_[0];
  goto _l49;
  _l43:;
  for (i_ = jfirst_; i_ <= j_ - 1; (i_)++) {
    if (xe_[i_ - 1] < x_[ir_ - 1 - 1]) {
      goto _l45;
    }
  }
  goto _l5005;
  _l45:;
  j_ = i_;
  for (i_ = 1; i_ <= ir_ - 1; (i_)++) {
    if (xe_[j_ - 1] < x_[i_ - 1]) {
      goto _l47;
    }
  }
  _l47:;
  ir_ = _max (1, i_ - 1);
  _l49:;
  jfirst_ = j_;
  _l50:;
  ir_ = ir_ + 1;
  if (ir_ <= (*n_)) {
    goto _l10;
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_42, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_42, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_42, _dc_15, ierr_, &_k1);
  goto _l0;
  _l5004:;
  (*ierr_) = -4;
  (void) _xermsg (_dc_0, _dc_42, _dc_2, ierr_, &_k1);
  goto _l0;
  _l5005:;
  (*ierr_) = -5;
  (void) _xermsg (_dc_0, _dc_42, _dc_43, ierr_, ($0_ = 2, &$0_));
  _l0:;
  __calls[31].calls++;
  return 0;
}

int_4 _pchfe (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, int_4 
_p_ ne_, real_4 _p_ xe_, real_4 _p_ fe_, int_4 _p_ ierr_)
{
  static int_4 i_, ierc_, ir_, j_, jfirst_, next_[2], nj_;
  int_4 $0_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  _l5:;
  if ((*ne_) < 1) {
    goto _l5004;
  }
  (*ierr_) = 0;
  (*skip_) = TRUE;
  jfirst_ = 1;
  ir_ = 2;
  _l10:;
  if (jfirst_ > (*ne_)) {
    goto _l5000;
  }
  for (j_ = jfirst_; j_ <= (*ne_); (j_)++) {
    if (xe_[j_ - 1] >= x_[ir_ - 1]) {
      goto _l30;
    }
  }
  j_ = (*ne_) + 1;
  goto _l40;
  _l30:;
  if (ir_ == (*n_)) {
    j_ = (*ne_) + 1;
  }
  _l40:;
  nj_ = j_ - jfirst_;
  if (nj_ == 0) {
    goto _l50;
  }
  (void) _chfev (&x_[ir_ - 1 - 1], &x_[ir_ - 1], &f_[0 + ((*incfd_)) * ((ir_ - 1 - 1))], &f_[0 + ((*incfd_)) * ((ir_ - 
  1))], &d_[0 + ((*incfd_)) * ((ir_ - 1 - 1))], &d_[0 + ((*incfd_)) * ((ir_ - 1))], &nj_, &xe_[jfirst_ - 1], &fe_[jfirst_ 
  - 1], next_, &ierc_);
  if (ierc_ < 0) {
    goto _l5005;
  }
  if (next_[1] == 0) {
    goto _l42;
  }
  if (ir_ < (*n_)) {
    goto _l41;
  }
  (*ierr_) = (*ierr_) + next_[1];
  goto _l42;
  _l41:;
  goto _l5005;
  _l42:;
  if (next_[0] == 0) {
    goto _l49;
  }
  if (ir_ > 2) {
    goto _l43;
  }
  (*ierr_) = (*ierr_) + next_[0];
  goto _l49;
  _l43:;
  for (i_ = jfirst_; i_ <= j_ - 1; (i_)++) {
    if (xe_[i_ - 1] < x_[ir_ - 1 - 1]) {
      goto _l45;
    }
  }
  goto _l5005;
  _l45:;
  j_ = i_;
  for (i_ = 1; i_ <= ir_ - 1; (i_)++) {
    if (xe_[j_ - 1] < x_[i_ - 1]) {
      goto _l47;
    }
  }
  _l47:;
  ir_ = _max (1, i_ - 1);
  _l49:;
  jfirst_ = j_;
  _l50:;
  ir_ = ir_ + 1;
  if (ir_ <= (*n_)) {
    goto _l10;
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_44, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_44, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_44, _dc_15, ierr_, &_k1);
  goto _l0;
  _l5004:;
  (*ierr_) = -4;
  (void) _xermsg (_dc_0, _dc_44, _dc_2, ierr_, &_k1);
  goto _l0;
  _l5005:;
  (*ierr_) = -5;
  (void) _xermsg (_dc_0, _dc_44, _dc_45, ierr_, ($0_ = 2, &$0_));
  _l0:;
  __calls[32].calls++;
  return 0;
}

real_4 _pchia (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, real_4 
_p_ a_, real_4 _p_ b_, int_4 _p_ ierr_)
{
  static int_4 i_, ia_, ib_, ierd_, il_, ir_;
  static real_4 value_, xa_, xb_, zero_;
  int_4 _data_k_66;
  real_4 pchia_;
#define _data_n_66 1
  static real_4 _data_l_66[_data_n_66] = {
    0.0
  };
  if (__calls[33].calls == 0) {
    _data_k_66 = 0;
    if (_data_k_66 >= _data_n_66) {
      _data_k_66 = 0;
    }
    zero_ = _data_l_66[_data_k_66++];
  }
  value_ = zero_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  _l5:;
  (*skip_) = TRUE;
  (*ierr_) = 0;
  if (((*a_) < x_[0]) || ((*a_) > x_[(*n_) - 1])) {
    (*ierr_) = (*ierr_) + 1;
  }
  if (((*b_) < x_[0]) || ((*b_) > x_[(*n_) - 1])) {
    (*ierr_) = (*ierr_) + 2;
  }
  if ((*a_) != (*b_)) {
    xa_ = _min ((*a_), (*b_));
    xb_ = _max ((*a_), (*b_));
    if (xb_ <= x_[1]) {
      value_ = _chfie (&x_[0], &x_[1], &f_[0 + ((*incfd_)) * ((0))], &f_[0 + ((*incfd_)) * ((1))], &d_[0 + ((*incfd_)) * 
      ((0))], &d_[0 + ((*incfd_)) * ((1))], a_, b_);
    }
    else if (xa_ >= x_[(*n_) - 1 - 1]) {
      value_ = _chfie (&x_[(*n_) - 1 - 1], &x_[(*n_) - 1], &f_[0 + ((*incfd_)) * (((*n_) - 1 - 1))], &f_[0 + ((*incfd_)) * 
      (((*n_) - 1))], &d_[0 + ((*incfd_)) * (((*n_) - 1 - 1))], &d_[0 + ((*incfd_)) * (((*n_) - 1))], a_, b_);
    }
    else {
      ia_ = 1;
      for (i_ = 1; i_ <= (*n_) - 1; (i_)++) {
        if (xa_ > x_[i_ - 1]) {
          ia_ = i_ + 1;
        }
      }
      ib_ = (*n_);
      for (i_ = (*n_); i_ >= ia_; (i_)--) {
        if (xb_ < x_[i_ - 1]) {
          ib_ = i_ - 1;
        }
      }
      if (ib_ < ia_) {
        value_ = _chfie (&x_[ib_ - 1], &x_[ia_ - 1], &f_[0 + ((*incfd_)) * ((ib_ - 1))], &f_[0 + ((*incfd_)) * ((ia_ - 1))], 
        &d_[0 + ((*incfd_)) * ((ib_ - 1))], &d_[0 + ((*incfd_)) * ((ia_ - 1))], a_, b_);
      }
      else {
        if (ib_ > ia_) {
          value_ = _pchid (n_, x_, f_, d_, incfd_, skip_, &ia_, &ib_, &ierd_);
          if (ierd_ < 0) {
            goto _l5004;
          }
        }
        if (xa_ < x_[ia_ - 1]) {
          il_ = _max (1, ia_ - 1);
          ir_ = il_ + 1;
          value_ = value_ + _chfie (&x_[il_ - 1], &x_[ir_ - 1], &f_[0 + ((*incfd_)) * ((il_ - 1))], &f_[0 + ((*incfd_)) * ((ir_ - 
          1))], &d_[0 + ((*incfd_)) * ((il_ - 1))], &d_[0 + ((*incfd_)) * ((ir_ - 1))], &xa_, &x_[ia_ - 1]);
        }
        if (xb_ > x_[ib_ - 1]) {
          ir_ = _min (ib_ + 1, (*n_));
          il_ = ir_ - 1;
          value_ = value_ + _chfie (&x_[il_ - 1], &x_[ir_ - 1], &f_[0 + ((*incfd_)) * ((il_ - 1))], &f_[0 + ((*incfd_)) * ((ir_ - 
          1))], &d_[0 + ((*incfd_)) * ((il_ - 1))], &d_[0 + ((*incfd_)) * ((ir_ - 1))], &x_[ib_ - 1], &xb_);
        }
        if ((*a_) > (*b_)) {
          value_ = -value_;
        }
      }
    }
  }
  _l5000:;
  pchia_ = value_;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_46, _dc_13, ierr_, &_k1);
  goto _l5000;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_46, _dc_14, ierr_, &_k1);
  goto _l5000;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_46, _dc_15, ierr_, &_k1);
  goto _l5000;
  _l5004:;
  (*ierr_) = -4;
  (void) _xermsg (_dc_0, _dc_46, _dc_47, ierr_, &_k1);
  goto _l5000;
  _l0:;
  __calls[33].calls++;
  return pchia_;
}

int_4 _pchic (int_4 _p_ ic_, real_4 _p_ vc_, real_4 _p_ switch_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ 
d_, int_4 _p_ incfd_, real_4 _p_ wk_, int_4 _p_ nwk_, int_4 _p_ ierr_)
{
  static int_4 i_, ibeg_, iend_, nless1_;
  static real_4 zero_;
  int_4 _data_k_67;
#define _data_n_67 1
  static real_4 _data_l_67[_data_n_67] = {
    0.0
  };
  if (__calls[34].calls == 0) {
    _data_k_67 = 0;
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    zero_ = _data_l_67[_data_k_67++];
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  ibeg_ = ic_[0];
  iend_ = ic_[1];
  (*ierr_) = 0;
  if (_abs (ibeg_) > 5) {
    (*ierr_) = (*ierr_) - 1;
  }
  if (_abs (iend_) > 5) {
    (*ierr_) = (*ierr_) - 2;
  }
  if ((*ierr_) < 0) {
    goto _l5004;
  }
  nless1_ = (*n_) - 1;
  if ((*nwk_) < 2 * nless1_) {
    goto _l5007;
  }
  for (i_ = 1; i_ <= nless1_; (i_)++) {
    wk_[i_ - 1] = x_[i_ + 1 - 1] - x_[i_ - 1];
    wk_[nless1_ + i_ - 1] = (f_[0 + ((*incfd_)) * ((i_ + 1 - 1))] - f_[0 + ((*incfd_)) * ((i_ - 1))]) / wk_[i_ - 1];
  }
  if (nless1_ > 1) {
    goto _l1000;
  }
  d_[0 + ((*incfd_)) * ((0))] = wk_[1];
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = wk_[1];
  goto _l3000;
  _l1000:;
  (void) _pchci (n_, &wk_[0], &wk_[(*n_) - 1], d_, incfd_);
  if ((*switch_) == zero_) {
    goto _l3000;
  }
  (void) _pchcs (switch_, n_, &wk_[0], &wk_[(*n_) - 1], d_, incfd_, ierr_);
  if ((*ierr_) != 0) {
    goto _l5008;
  }
  _l3000:;
  if ((ibeg_ == 0) && (iend_ == 0)) {
    goto _l5000;
  }
  (void) _pchce (ic_, vc_, n_, x_, &wk_[0], &wk_[(*n_) - 1], d_, incfd_, ierr_);
  if ((*ierr_) < 0) {
    goto _l5009;
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_48, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_48, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_48, _dc_15, ierr_, &_k1);
  goto _l0;
  _l5004:;
  (*ierr_) = (*ierr_) - 3;
  (void) _xermsg (_dc_0, _dc_48, _dc_25, ierr_, &_k1);
  goto _l0;
  _l5007:;
  (*ierr_) = -7;
  (void) _xermsg (_dc_0, _dc_48, _dc_26, ierr_, &_k1);
  goto _l0;
  _l5008:;
  (*ierr_) = -8;
  (void) _xermsg (_dc_0, _dc_48, _dc_49, ierr_, &_k1);
  goto _l0;
  _l5009:;
  (*ierr_) = -9;
  (void) _xermsg (_dc_0, _dc_48, _dc_50, ierr_, &_k1);
  _l0:;
  __calls[34].calls++;
  return 0;
}

real_4 _pchid (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, logical_4 _p_ skip_, int_4 
_p_ ia_, int_4 _p_ ib_, int_4 _p_ ierr_)
{
  static int_4 i_, iup_, low_;
  static real_4 h_, half_, six_, sum_, value_, zero_;
  int_4 _data_k_68, _data_k_69, _data_k_70;
  real_4 pchid_;
#define _data_n_68 1
  static real_4 _data_l_68[_data_n_68] = {
    0.0
  };
#define _data_n_69 1
  static real_4 _data_l_69[_data_n_69] = {
    0.5
  };
#define _data_n_70 1
  static real_4 _data_l_70[_data_n_70] = {
    6.0
  };
  if (__calls[35].calls == 0) {
    _data_k_68 = 0;
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    zero_ = _data_l_68[_data_k_68++];
    _data_k_69 = 0;
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    half_ = _data_l_69[_data_k_69++];
    _data_k_70 = 0;
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    six_ = _data_l_70[_data_k_70++];
  }
  value_ = zero_;
  if ((*skip_)) {
    goto _l5;
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  _l5:;
  (*skip_) = TRUE;
  if (((*ia_) < 1) || ((*ia_) > (*n_))) {
    goto _l5004;
  }
  if (((*ib_) < 1) || ((*ib_) > (*n_))) {
    goto _l5004;
  }
  (*ierr_) = 0;
  if ((*ia_) != (*ib_)) {
    low_ = _min ((*ia_), (*ib_));
    iup_ = _max ((*ia_), (*ib_)) - 1;
    sum_ = zero_;
    for (i_ = low_; i_ <= iup_; (i_)++) {
      h_ = x_[i_ + 1 - 1] - x_[i_ - 1];
      sum_ = sum_ + h_ * ((f_[0 + ((*incfd_)) * ((i_ - 1))] + f_[0 + ((*incfd_)) * ((i_ + 1 - 1))]) + (d_[0 + ((*incfd_)) * 
      ((i_ - 1))] - d_[0 + ((*incfd_)) * ((i_ + 1 - 1))]) * (h_ / six_));
    }
    value_ = half_ * sum_;
    if ((*ia_) > (*ib_)) {
      value_ = -value_;
    }
  }
  _l5000:;
  pchid_ = value_;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_51, _dc_13, ierr_, &_k1);
  goto _l5000;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_51, _dc_14, ierr_, &_k1);
  goto _l5000;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_51, _dc_15, ierr_, &_k1);
  goto _l5000;
  _l5004:;
  (*ierr_) = -4;
  (void) _xermsg (_dc_0, _dc_51, _dc_30, ierr_, &_k1);
  goto _l5000;
  _l0:;
  __calls[35].calls++;
  return pchid_;
}
int_4 _pchim (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ incfd_, int_4 _p_ ierr_)
{
  static int_4 i_, nless1_;
  static real_4 del1_, del2_, dmax_, dmin_, drat1_, drat2_, dsave_, h1_, h2_, hsum_, hsumt3_, three_, w1_, w2_, zero_;
  int_4 _data_k_71, _data_k_72;
  real_4 $0_;
#define _data_n_71 1
  static real_4 _data_l_71[_data_n_71] = {
    0.0
  };
#define _data_n_72 1
  static real_4 _data_l_72[_data_n_72] = {
    3.0
  };
  if (__calls[36].calls == 0) {
    _data_k_71 = 0;
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    zero_ = _data_l_71[_data_k_71++];
    _data_k_72 = 0;
    if (_data_k_72 >= _data_n_72) {
      _data_k_72 = 0;
    }
    three_ = _data_l_72[_data_k_72++];
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l5003;
    }
  }
  (*ierr_) = 0;
  nless1_ = (*n_) - 1;
  h1_ = x_[1] - x_[0];
  del1_ = (f_[0 + ((*incfd_)) * ((1))] - f_[0 + ((*incfd_)) * ((0))]) / h1_;
  dsave_ = del1_;
  if (nless1_ > 1) {
    goto _l10;
  }
  d_[0 + ((*incfd_)) * ((0))] = del1_;
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = del1_;
  goto _l5000;
  _l10:;
  h2_ = x_[2] - x_[1];
  del2_ = (f_[0 + ((*incfd_)) * ((2))] - f_[0 + ((*incfd_)) * ((1))]) / h2_;
  hsum_ = h1_ + h2_;
  w1_ = (h1_ + hsum_) / hsum_;
  w2_ = -h1_ / hsum_;
  d_[0 + ((*incfd_)) * ((0))] = w1_ * del1_ + w2_ * del2_;
  if (_pchst (&d_[0 + ((*incfd_)) * ((0))], &del1_) <= zero_) {
    d_[0 + ((*incfd_)) * ((0))] = zero_;
  }
  else if (_pchst (&del1_, &del2_) < zero_) {
    dmax_ = three_ * del1_;
    if (_abs (d_[0 + ((*incfd_)) * ((0))]) > _abs (dmax_)) {
      d_[0 + ((*incfd_)) * ((0))] = dmax_;
    }
  }
  for (i_ = 2; i_ <= nless1_; (i_)++) {
    if (i_ == 2) {
      goto _l40;
    }
    h1_ = h2_;
    h2_ = x_[i_ + 1 - 1] - x_[i_ - 1];
    hsum_ = h1_ + h2_;
    del1_ = del2_;
    del2_ = (f_[0 + ((*incfd_)) * ((i_ + 1 - 1))] - f_[0 + ((*incfd_)) * ((i_ - 1))]) / h2_;
    _l40:;
    d_[0 + ((*incfd_)) * ((i_ - 1))] = zero_;
    $0_ = _pchst (&del1_, &del2_);
    if ($0_ < 0) {
      goto _l42;
    } else if ($0_ == 0) {
      goto _l41;
    } else {
      goto _l45;
    }
    _l41:;
    if (del2_ == zero_) {
      goto _l50;
    }
    if (_pchst (&dsave_, &del2_) < zero_) {
      (*ierr_) = (*ierr_) + 1;
    }
    dsave_ = del2_;
    goto _l50;
    _l42:;
    (*ierr_) = (*ierr_) + 1;
    dsave_ = del2_;
    goto _l50;
    _l45:;
    hsumt3_ = hsum_ + hsum_ + hsum_;
    w1_ = (hsum_ + h1_) / hsumt3_;
    w2_ = (hsum_ + h2_) / hsumt3_;
    dmax_ = _max (_abs (del1_), _abs (del2_));
    dmin_ = _min (_abs (del1_), _abs (del2_));
    drat1_ = del1_ / dmax_;
    drat2_ = del2_ / dmax_;
    d_[0 + ((*incfd_)) * ((i_ - 1))] = dmin_ / (w1_ * drat1_ + w2_ * drat2_);
    _l50:;
  }
  w1_ = -h2_ / hsum_;
  w2_ = (h2_ + hsum_) / hsum_;
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = w1_ * del1_ + w2_ * del2_;
  if (_pchst (&d_[0 + ((*incfd_)) * (((*n_) - 1))], &del2_) <= zero_) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = zero_;
  }
  else if (_pchst (&del1_, &del2_) < zero_) {
    dmax_ = three_ * del2_;
    if (_abs (d_[0 + ((*incfd_)) * (((*n_) - 1))]) > _abs (dmax_)) {
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = dmax_;
    }
  }
  _l5000:;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_52, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_52, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_52, _dc_15, ierr_, &_k1);
  _l0:;
  __calls[36].calls++;
  return 0;
}

int_4 _pchkt (int_4 _p_ n_, real_4 _p_ x_, int_4 _p_ knotyp_, real_4 _p_ t_)
{
  static int_4 j_, k_, ndim_;
  static real_4 hbeg_, hend_;
  ndim_ = 2 * (*n_);
  j_ = 1;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    j_ = j_ + 2;
    t_[j_ - 1] = x_[k_ - 1];
    t_[j_ + 1 - 1] = t_[j_ - 1];
  }
  hbeg_ = x_[1] - x_[0];
  hend_ = x_[(*n_) - 1] - x_[(*n_) - 1 - 1];
  if ((*knotyp_) == 1) {
    t_[1] = x_[0] - hbeg_;
    t_[ndim_ + 3 - 1] = x_[(*n_) - 1] + hend_;
  }
  else if ((*knotyp_) == 2) {
    t_[1] = x_[0] - hend_;
    t_[ndim_ + 3 - 1] = x_[(*n_) - 1] + hbeg_;
  }
  else {
    t_[1] = x_[0];
    t_[ndim_ + 3 - 1] = x_[(*n_) - 1];
  }
  t_[0] = t_[1];
  t_[ndim_ + 4 - 1] = t_[ndim_ + 3 - 1];
  __calls[37].calls++;
  return 0;
}

int_4 _pchsp (int_4 _p_ ic_, real_4 _p_ vc_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ f_, real_4 _p_ d_, int_4 _p_ 
incfd_, real_4 _p_ wk_, int_4 _p_ nwk_, int_4 _p_ ierr_)
{
  static int_4 ibeg_, iend_, index_, j_, nm1_;
  static real_4 g_, half_, one_, stemp_[3], three_, two_, xtemp_[4], zero_;
  int_4 _data_k_73, _data_k_74, _data_k_75, _data_k_76, _data_k_77;
#define _data_n_73 1
  static real_4 _data_l_73[_data_n_73] = {
    0.0
  };
#define _data_n_74 1
  static real_4 _data_l_74[_data_n_74] = {
    0.5
  };
#define _data_n_75 1
  static real_4 _data_l_75[_data_n_75] = {
    1.0
  };
#define _data_n_76 1
  static real_4 _data_l_76[_data_n_76] = {
    2.0
  };
#define _data_n_77 1
  static real_4 _data_l_77[_data_n_77] = {
    3.0
  };
  if (__calls[38].calls == 0) {
    _data_k_73 = 0;
    if (_data_k_73 >= _data_n_73) {
      _data_k_73 = 0;
    }
    zero_ = _data_l_73[_data_k_73++];
    _data_k_74 = 0;
    if (_data_k_74 >= _data_n_74) {
      _data_k_74 = 0;
    }
    half_ = _data_l_74[_data_k_74++];
    _data_k_75 = 0;
    if (_data_k_75 >= _data_n_75) {
      _data_k_75 = 0;
    }
    one_ = _data_l_75[_data_k_75++];
    _data_k_76 = 0;
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    two_ = _data_l_76[_data_k_76++];
    _data_k_77 = 0;
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    three_ = _data_l_77[_data_k_77++];
  }
  if ((*n_) < 2) {
    goto _l5001;
  }
  if ((*incfd_) < 1) {
    goto _l5002;
  }
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    if (x_[j_ - 1] <= x_[j_ - 1 - 1]) {
      goto _l5003;
    }
  }
  ibeg_ = ic_[0];
  iend_ = ic_[1];
  (*ierr_) = 0;
  if ((ibeg_ < 0) || (ibeg_ > 4)) {
    (*ierr_) = (*ierr_) - 1;
  }
  if ((iend_ < 0) || (iend_ > 4)) {
    (*ierr_) = (*ierr_) - 2;
  }
  if ((*ierr_) < 0) {
    goto _l5004;
  }
  if ((*nwk_) < 2 * (*n_)) {
    goto _l5007;
  }
  for (j_ = 2; j_ <= (*n_); (j_)++) {
    wk_[0 + (2) * ((j_ - 1))] = x_[j_ - 1] - x_[j_ - 1 - 1];
    wk_[1 + (2) * ((j_ - 1))] = (f_[0 + ((*incfd_)) * ((j_ - 1))] - f_[0 + ((*incfd_)) * ((j_ - 1 - 1))]) / wk_[0 + (2) * 
    ((j_ - 1))];
  }
  if (ibeg_ > (*n_)) {
    ibeg_ = 0;
  }
  if (iend_ > (*n_)) {
    iend_ = 0;
  }
  if ((ibeg_ == 1) || (ibeg_ == 2)) {
    d_[0 + ((*incfd_)) * ((0))] = vc_[0];
  }
  else if (ibeg_ > 2) {
    for (j_ = 1; j_ <= ibeg_; (j_)++) {
      index_ = ibeg_ - j_ + 1;
      xtemp_[j_ - 1] = x_[index_ - 1];
      if (j_ < ibeg_) {
        stemp_[j_ - 1] = wk_[1 + (2) * ((index_ - 1))];
      }
    }
    d_[0 + ((*incfd_)) * ((0))] = _pchdf (&ibeg_, xtemp_, stemp_, ierr_);
    if ((*ierr_) != 0) {
      goto _l5009;
    }
    ibeg_ = 1;
  }
  if ((iend_ == 1) || (iend_ == 2)) {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = vc_[1];
  }
  else if (iend_ > 2) {
    for (j_ = 1; j_ <= iend_; (j_)++) {
      index_ = (*n_) - iend_ + j_;
      xtemp_[j_ - 1] = x_[index_ - 1];
      if (j_ < iend_) {
        stemp_[j_ - 1] = wk_[1 + (2) * ((index_ + 1 - 1))];
      }
    }
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = _pchdf (&iend_, xtemp_, stemp_, ierr_);
    if ((*ierr_) != 0) {
      goto _l5009;
    }
    iend_ = 1;
  }
  if (ibeg_ == 0) {
    if ((*n_) == 2) {
      wk_[1] = one_;
      wk_[0] = one_;
      d_[0 + ((*incfd_)) * ((0))] = two_ * wk_[3];
    }
    else {
      wk_[1] = wk_[4];
      wk_[0] = wk_[2] + wk_[4];
      d_[0 + ((*incfd_)) * ((0))] = ((wk_[2] + two_ * wk_[0]) * wk_[3] * wk_[4] + (wk_[2] * wk_[2]) * wk_[5]) / wk_[0];
    }
  }
  else if (ibeg_ == 1) {
    wk_[1] = one_;
    wk_[0] = zero_;
  }
  else {
    wk_[1] = two_;
    wk_[0] = one_;
    d_[0 + ((*incfd_)) * ((0))] = three_ * wk_[3] - half_ * wk_[2] * d_[0 + ((*incfd_)) * ((0))];
  }
  nm1_ = (*n_) - 1;
  if (nm1_ > 1) {
    for (j_ = 2; j_ <= nm1_; (j_)++) {
      if (wk_[1 + (2) * ((j_ - 1 - 1))] == zero_) {
        goto _l5008;
      }
      g_ = -wk_[0 + (2) * ((j_ + 1 - 1))] / wk_[1 + (2) * ((j_ - 1 - 1))];
      d_[0 + ((*incfd_)) * ((j_ - 1))] = g_ * d_[0 + ((*incfd_)) * ((j_ - 1 - 1))] + three_ * (wk_[0 + (2) * ((j_ - 1))] * 
      wk_[1 + (2) * ((j_ + 1 - 1))] + wk_[0 + (2) * ((j_ + 1 - 1))] * wk_[1 + (2) * ((j_ - 1))]);
      wk_[1 + (2) * ((j_ - 1))] = g_ * wk_[0 + (2) * ((j_ - 1 - 1))] + two_ * (wk_[0 + (2) * ((j_ - 1))] + wk_[0 + (2) * ((j_ 
      + 1 - 1))]);
    }
  }
  if (iend_ == 1) {
    goto _l30;
  }
  if (iend_ == 0) {
    if ((*n_) == 2 && ibeg_ == 0) {
      d_[0 + ((*incfd_)) * ((1))] = wk_[3];
      goto _l30;
    }
    else if (((*n_) == 2) || ((*n_) == 3 && ibeg_ == 0)) {
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = two_ * wk_[1 + (2) * (((*n_) - 1))];
      wk_[1 + (2) * (((*n_) - 1))] = one_;
      if (wk_[1 + (2) * (((*n_) - 1 - 1))] == zero_) {
        goto _l5008;
      }
      g_ = -one_ / wk_[1 + (2) * (((*n_) - 1 - 1))];
    }
    else {
      g_ = wk_[0 + (2) * (((*n_) - 1 - 1))] + wk_[0 + (2) * (((*n_) - 1))];
      d_[0 + ((*incfd_)) * (((*n_) - 1))] = ((wk_[0 + (2) * (((*n_) - 1))] + two_ * g_) * wk_[1 + (2) * (((*n_) - 1))] * 
      wk_[0 + (2) * (((*n_) - 1 - 1))] + (wk_[0 + (2) * (((*n_) - 1))] * wk_[0 + (2) * (((*n_) - 1))]) * (f_[0 + ((*incfd_)) 
      * (((*n_) - 1 - 1))] - f_[0 + ((*incfd_)) * (((*n_) - 2 - 1))]) / wk_[0 + (2) * (((*n_) - 1 - 1))]) / g_;
      if (wk_[1 + (2) * (((*n_) - 1 - 1))] == zero_) {
        goto _l5008;
      }
      g_ = -g_ / wk_[1 + (2) * (((*n_) - 1 - 1))];
      wk_[1 + (2) * (((*n_) - 1))] = wk_[0 + (2) * (((*n_) - 1 - 1))];
    }
  }
  else {
    d_[0 + ((*incfd_)) * (((*n_) - 1))] = three_ * wk_[1 + (2) * (((*n_) - 1))] + half_ * wk_[0 + (2) * (((*n_) - 1))] * 
    d_[0 + ((*incfd_)) * (((*n_) - 1))];
    wk_[1 + (2) * (((*n_) - 1))] = two_;
    if (wk_[1 + (2) * (((*n_) - 1 - 1))] == zero_) {
      goto _l5008;
    }
    g_ = -one_ / wk_[1 + (2) * (((*n_) - 1 - 1))];
  }
  wk_[1 + (2) * (((*n_) - 1))] = g_ * wk_[0 + (2) * (((*n_) - 1 - 1))] + wk_[1 + (2) * (((*n_) - 1))];
  if (wk_[1 + (2) * (((*n_) - 1))] == zero_) {
    goto _l5008;
  }
  d_[0 + ((*incfd_)) * (((*n_) - 1))] = (g_ * d_[0 + ((*incfd_)) * (((*n_) - 1 - 1))] + d_[0 + ((*incfd_)) * (((*n_) - 
  1))]) / wk_[1 + (2) * (((*n_) - 1))];
  _l30:;
  for (j_ = nm1_; j_ >= 1; (j_)--) {
    if (wk_[1 + (2) * ((j_ - 1))] == zero_) {
      goto _l5008;
    }
    d_[0 + ((*incfd_)) * ((j_ - 1))] = (d_[0 + ((*incfd_)) * ((j_ - 1))] - wk_[0 + (2) * ((j_ - 1))] * d_[0 + ((*incfd_)) * 
    ((j_ + 1 - 1))]) / wk_[1 + (2) * ((j_ - 1))];
  }
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_53, _dc_13, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_53, _dc_14, ierr_, &_k1);
  goto _l0;
  _l5003:;
  (*ierr_) = -3;
  (void) _xermsg (_dc_0, _dc_53, _dc_15, ierr_, &_k1);
  goto _l0;
  _l5004:;
  (*ierr_) = (*ierr_) - 3;
  (void) _xermsg (_dc_0, _dc_53, _dc_25, ierr_, &_k1);
  goto _l0;
  _l5007:;
  (*ierr_) = -7;
  (void) _xermsg (_dc_0, _dc_53, _dc_26, ierr_, &_k1);
  goto _l0;
  _l5008:;
  (*ierr_) = -8;
  (void) _xermsg (_dc_0, _dc_53, _dc_33, ierr_, &_k1);
  goto _l0;
  _l5009:;
  (*ierr_) = -9;
  (void) _xermsg (_dc_0, _dc_53, _dc_39, ierr_, &_k1);
  _l0:;
  __calls[38].calls++;
  return 0;
}

real_4 _pchst (real_4 _p_ arg1_, real_4 _p_ arg2_)
{
  static real_4 one_, zero_;
  int_4 _data_k_78, _data_k_79;
  real_4 pchst_;
#define _data_n_78 1
  static real_4 _data_l_78[_data_n_78] = {
    0.0
  };
#define _data_n_79 1
  static real_4 _data_l_79[_data_n_79] = {
    1.0
  };
  if (__calls[39].calls == 0) {
    _data_k_78 = 0;
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    zero_ = _data_l_78[_data_k_78++];
    _data_k_79 = 0;
    if (_data_k_79 >= _data_n_79) {
      _data_k_79 = 0;
    }
    one_ = _data_l_79[_data_k_79++];
  }
  pchst_ = _sign (one_, (*arg1_)) * _sign (one_, (*arg2_));
  if (((*arg1_) == zero_) || ((*arg2_) == zero_)) {
    pchst_ = zero_;
  }
  __calls[39].calls++;
  return pchst_;
}

int_4 _pchsw (real_4 _p_ dfmax_, int_4 _p_ iextrm_, real_4 _p_ d1_, real_4 _p_ d2_, real_4 _p_ h_, real_4 _p_ slope_, 
int_4 _p_ ierr_)
{
  static real_4 cp_, fact_, hphi_, lambda_, nu_, one_, phi_, radcal_, rho_, sigma_, small_, that_, third_, three_, two_, 
  zero_;
  int_4 _data_k_80, _data_k_81, _data_k_82, _data_k_83, _data_k_84, _data_k_85, $0_;
  extern real_4 _r1mach ();
#define _data_n_80 1
  static real_4 _data_l_80[_data_n_80] = {
    0.0
  };
#define _data_n_81 1
  static real_4 _data_l_81[_data_n_81] = {
    1.0
  };
#define _data_n_82 1
  static real_4 _data_l_82[_data_n_82] = {
    2.0
  };
#define _data_n_83 1
  static real_4 _data_l_83[_data_n_83] = {
    3.0
  };
#define _data_n_84 1
  static real_4 _data_l_84[_data_n_84] = {
    100.0
  };
#define _data_n_85 1
  static real_4 _data_l_85[_data_n_85] = {
    0.33333
  };
  if (__calls[40].calls == 0) {
    _data_k_80 = 0;
    if (_data_k_80 >= _data_n_80) {
      _data_k_80 = 0;
    }
    zero_ = _data_l_80[_data_k_80++];
    _data_k_81 = 0;
    if (_data_k_81 >= _data_n_81) {
      _data_k_81 = 0;
    }
    one_ = _data_l_81[_data_k_81++];
    _data_k_82 = 0;
    if (_data_k_82 >= _data_n_82) {
      _data_k_82 = 0;
    }
    two_ = _data_l_82[_data_k_82++];
    _data_k_83 = 0;
    if (_data_k_83 >= _data_n_83) {
      _data_k_83 = 0;
    }
    three_ = _data_l_83[_data_k_83++];
    _data_k_84 = 0;
    if (_data_k_84 >= _data_n_84) {
      _data_k_84 = 0;
    }
    fact_ = _data_l_84[_data_k_84++];
  }
  if (__calls[40].calls == 0) {
    _data_k_85 = 0;
    if (_data_k_85 >= _data_n_85) {
      _data_k_85 = 0;
    }
    third_ = _data_l_85[_data_k_85++];
  }
  small_ = fact_ * _r1mach (($0_ = 4, &$0_));
  if ((*d1_) == zero_) {
    if ((*d2_) == zero_) {
      goto _l5001;
    }
    rho_ = (*slope_) / (*d2_);
    if (rho_ >= third_) {
      goto _l5000;
    }
    that_ = (two_ * (three_ * rho_ - one_)) / (three_ * (two_ * rho_ - one_));
    phi_ = (that_ * that_) * ((three_ * rho_ - one_) / three_);
    if ((*iextrm_) != 1) {
      phi_ = phi_ - rho_;
    }
    hphi_ = (*h_) * _abs (phi_);
    if (hphi_ * _abs ((*d2_)) > (*dfmax_)) {
      (*d2_) = _sign ((*dfmax_) / hphi_, (*d2_));
    }
  }
  else {
    rho_ = (*slope_) / (*d1_);
    lambda_ = -(*d2_) / (*d1_);
    if ((*d2_) == zero_) {
      if (rho_ >= third_) {
        goto _l5000;
      }
      cp_ = two_ - three_ * rho_;
      nu_ = one_ - two_ * rho_;
      that_ = one_ / (three_ * nu_);
    }
    else {
      if (lambda_ <= zero_) {
        goto _l5001;
      }
      nu_ = one_ - lambda_ - two_ * rho_;
      sigma_ = one_ - rho_;
      cp_ = nu_ + sigma_;
      if (_abs (nu_) > small_) {
        radcal_ = (nu_ - (two_ * rho_ + one_)) * nu_ + (sigma_ * sigma_);
        if (radcal_ < zero_) {
          goto _l5002;
        }
        that_ = (cp_ - sqrtf (radcal_)) / (three_ * nu_);
      }
      else {
        that_ = one_ / (two_ * sigma_);
      }
    }
    phi_ = that_ * ((nu_ * that_ - cp_) * that_ + one_);
    if ((*iextrm_) != 1) {
      phi_ = phi_ - rho_;
    }
    hphi_ = (*h_) * _abs (phi_);
    if (hphi_ * _abs ((*d1_)) > (*dfmax_)) {
      (*d1_) = _sign ((*dfmax_) / hphi_, (*d1_));
      (*d2_) = -lambda_ * (*d1_);
    }
  }
  _l5000:;
  (*ierr_) = 0;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_54, _dc_35, ierr_, &_k1);
  goto _l0;
  _l5002:;
  (*ierr_) = -2;
  (void) _xermsg (_dc_0, _dc_54, _dc_36, ierr_, &_k1);
  _l0:;
  __calls[40].calls++;
  return 0;
}

