//! @file mathlib-quadpack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 73 subprograms from QUADPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// DQAG   DQAWC  DQC25C DQK21  DQNG   QAGI   QAWCE  QC25C  QK15W  QNC79
// DQAGE  DQAWCE DQC25F DQK31  DQPSRT QAGIE  QAWF   QC25F  QK21   QNG
// DQAGI  DQAWF  DQC25S DQK41  DQWGTC QAGP   QAWFE  QC25S  QK31   QPDOC
// DQAGIE DQAWFE DQCHEB DQK51  DQWGTF QAGPE  QAWO   QCHEB  QK41   QPSRT
// DQAGP  DQAWO  DQELG  DQK61  DQWGTS QAGS   QAWOE  QELG   QK51   QWGTC
// DQAGPE DQAWOE DQK15  DQMOMO QAG    QAGSE  QAWS   QK15   QK61   QWGTF
// DQAGS  DQAWS  DQK15I DQNC79 QAGE   QAWC   QAWSE  QK15I  QMOMO  QWGTS
// DQAGSE DQAWSE DQK15W

// QUADPACK is a FORTRAN 77 library for numerical integration of one-dimensional functions. 
// It was included in the SLATEC Common Mathematical Library and is therefore in the public domain. 
// The individual subprograms are also available on netlib. 
// 
// See also:
//   R. Piessens, E. deDoncker-Kapenga, C. Uberhuber, D. Kahaner
//   Quadpack: a Subroutine Package for Automatic Integration
//   Springer Verlag, 1983.    Series in Computational Mathematics v.1
//   515.43/Q1S  100394Z

// The license for QUADPACK Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "slatec"
#define _dc_1 "dqag"
#define _dc_2 "abnormal return"
#define _dc_3 "dqagi"
#define _dc_4 "dqagp"
#define _dc_5 "dqags"
#define _dc_6 "dqawc"
#define _dc_7 "dqawf"
#define _dc_8 "dqawo"
#define _dc_9 "dqaws"
#define _dc_10 "dqnc79"
#define _dc_11 "ans is probably insufficiently accurate."
#define _dc_12 "a and b are too nearly equal to allow normal integration. $$"
#define _dc_13 "ans is set to zero and ierr to -1."
#define _dc_14 "dqng"
#define _dc_15 "qag"
#define _dc_16 "qagi"
#define _dc_17 "qagp"
#define _dc_18 "qags"
#define _dc_19 "qawc"
#define _dc_20 "qawf"
#define _dc_21 "qawo"
#define _dc_22 "qaws"
#define _dc_23 "qnc79"
#define _dc_24 "qng"
static FORMAT *__fmt_a = NULL;
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_63[64];
typedef char char_127[128];
#define __ncalls 74
static CALLS __calls[__ncalls] = {
  {"dqage", 0}, // subroutine
  {"dqag", 0}, // subroutine
  {"dqagie", 0}, // subroutine
  {"dqagi", 0}, // subroutine
  {"dqagpe", 0}, // subroutine
  {"dqagp", 0}, // subroutine
  {"dqagse", 0}, // subroutine
  {"dqags", 0}, // subroutine
  {"dqawce", 0}, // subroutine
  {"dqawc", 0}, // subroutine
  {"dqawfe", 0}, // subroutine
  {"dqawf", 0}, // subroutine
  {"dqawoe", 0}, // subroutine
  {"dqawo", 0}, // subroutine
  {"dqawse", 0}, // subroutine
  {"dqaws", 0}, // subroutine
  {"dqc25c", 0}, // subroutine
  {"dqc25f", 0}, // subroutine
  {"dqc25s", 0}, // subroutine
  {"dqcheb", 0}, // subroutine
  {"dqelg", 0}, // subroutine
  {"dqk15", 0}, // subroutine
  {"dqk15i", 0}, // subroutine
  {"dqk15w", 0}, // subroutine
  {"dqk21", 0}, // subroutine
  {"dqk31", 0}, // subroutine
  {"dqk41", 0}, // subroutine
  {"dqk51", 0}, // subroutine
  {"dqk61", 0}, // subroutine
  {"dqmomo", 0}, // subroutine
  {"dqnc79", 0}, // subroutine
  {"dqng", 0}, // subroutine
  {"dqpsrt", 0}, // subroutine
  {"dqwgtc", 0}, // real*8 function
  {"dqwgtf", 0}, // real*8 function
  {"dqwgts", 0}, // real*8 function
  {"qage", 0}, // subroutine
  {"qag", 0}, // subroutine
  {"qagie", 0}, // subroutine
  {"qagi", 0}, // subroutine
  {"qagpe", 0}, // subroutine
  {"qagp", 0}, // subroutine
  {"qagse", 0}, // subroutine
  {"qags", 0}, // subroutine
  {"qawce", 0}, // subroutine
  {"qawc", 0}, // subroutine
  {"qawfe", 0}, // subroutine
  {"qawf", 0}, // subroutine
  {"qawoe", 0}, // subroutine
  {"qawo", 0}, // subroutine
  {"qawse", 0}, // subroutine
  {"qaws", 0}, // subroutine
  {"qc25c", 0}, // subroutine
  {"qc25f", 0}, // subroutine
  {"qc25s", 0}, // subroutine
  {"qcheb", 0}, // subroutine
  {"qelg", 0}, // subroutine
  {"qk15", 0}, // subroutine
  {"qk15i", 0}, // subroutine
  {"qk15w", 0}, // subroutine
  {"qk21", 0}, // subroutine
  {"qk31", 0}, // subroutine
  {"qk41", 0}, // subroutine
  {"qk51", 0}, // subroutine
  {"qk61", 0}, // subroutine
  {"qmomo", 0}, // subroutine
  {"qnc79", 0}, // subroutine
  {"qng", 0}, // subroutine
  {"qpdoc", 0}, // subroutine
  {"qpsrt", 0}, // subroutine
  {"qwgtc", 0}, // real*4 function
  {"qwgtf", 0}, // real*4 function
  {"qwgts", 0}, // real*4 function
  {NULL, 0}
};

prototype int_4 _dqage (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 _p_ 
key_, int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 _p_ alist_, 
real_8 _p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_);
prototype int_4 _dqag (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 _p_ 
key_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, 
int_4 _p_ last_, int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dqagie (real_8 (*_f)(), real_8 _p_ bound_, int_4 _p_ inf_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, 
int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 _p_ alist_, real_8 
_p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_);
prototype int_4 _dqagi (real_8 (*_f)(), real_8 _p_ bound_, int_4 _p_ inf_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, 
real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ 
last_, int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dqagpe (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, int_4 _p_ npts2_, real_8 _p_ points_, real_8 _p_ 
epsabs_, real_8 _p_ epsrel_, int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_
, real_8 _p_ alist_, real_8 _p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, real_8 _p_ pts_, int_4 _p_ iord_, int_4 
_p_ level_, int_4 _p_ ndin_, int_4 _p_ last_);
prototype int_4 _dqagp (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, int_4 _p_ npts2_, real_8 _p_ points_, real_8 _p_ 
epsabs_, real_8 _p_ epsrel_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ leniw_
, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dqagse (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 
_p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 _p_ alist_, real_8 _p_ 
blist_, real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_);
prototype int_4 _dqags (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, real_8 
_p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, 
int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dqawce (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ epsabs_, real_8 _p_ 
epsrel_, int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 _p_ alist_, 
real_8 _p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_);
prototype int_4 _dqawc (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ epsabs_, real_8 _p_ 
epsrel_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, 
int_4 _p_ last_, int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dqawfe (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ omega_, int_4 _p_ integr_, real_8 _p_ epsabs_, int_4 
_p_ limlst_, int_4 _p_ limit_, int_4 _p_ maxp1_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ 
ier_, real_8 _p_ rslst_, real_8 _p_ erlst_, int_4 _p_ ierlst_, int_4 _p_ lst_, real_8 _p_ alist_, real_8 _p_ blist_, 
real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ nnlog_, real_8 _p_ chebmo_);
prototype int_4 _dqawf (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ omega_, int_4 _p_ integr_, real_8 _p_ epsabs_, real_8 
_p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limlst_, int_4 _p_ lst_, int_4 _p_ leniw_, 
int_4 _p_ maxp1_, int_4 _p_ lenw_, int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dqawoe (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ omega_, int_4 _p_ integr_, real_8 _p_ 
epsabs_, real_8 _p_ epsrel_, int_4 _p_ limit_, int_4 _p_ icall_, int_4 _p_ maxp1_, real_8 _p_ result_, real_8 _p_ 
abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ last_, real_8 _p_ alist_, real_8 _p_ blist_, real_8 _p_ rlist_, 
real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ nnlog_, int_4 _p_ momcom_, real_8 _p_ chebmo_);
prototype int_4 _dqawo (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ omega_, int_4 _p_ integr_, real_8 _p_ 
epsabs_, real_8 _p_ epsrel_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ leniw_
, int_4 _p_ maxp1_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dqawse (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfa_, real_8 _p_ beta_, int_4 _p_ 
integr_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ 
neval_, int_4 _p_ ier_, real_8 _p_ alist_, real_8 _p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, 
int_4 _p_ last_);
prototype int_4 _dqaws (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfa_, real_8 _p_ beta_, int_4 _p_ 
integr_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ 
ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dqc25c (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ result_, real_8 _p_ 
abserr_, int_4 _p_ krul_, int_4 _p_ neval_);
prototype int_4 _dqc25f (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ omega_, int_4 _p_ integr_, int_4 _p_ 
nrmom_, int_4 _p_ maxp1_, int_4 _p_ ksave_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, real_8 _p_ 
resabs_, real_8 _p_ resasc_, int_4 _p_ momcom_, real_8 _p_ chebmo_);
prototype int_4 _dqc25s (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ bl_, real_8 _p_ br_, real_8 _p_ alfa_
, real_8 _p_ beta_, real_8 _p_ ri_, real_8 _p_ rj_, real_8 _p_ rg_, real_8 _p_ rh_, real_8 _p_ result_, real_8 _p_ 
abserr_, real_8 _p_ resasc_, int_4 _p_ integr_, int_4 _p_ nev_);
prototype int_4 _dqcheb (real_8 _p_ x_, real_8 _p_ fval_, real_8 _p_ cheb12_, real_8 _p_ cheb24_);
prototype int_4 _dqelg (int_4 _p_ n_, real_8 _p_ epstab_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ res3la_, 
int_4 _p_ nres_);
prototype int_4 _dqk15 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 
_p_ resabs_, real_8 _p_ resasc_);
prototype int_4 _dqk15i (real_8 (*_f)(), real_8 _p_ boun_, int_4 _p_ inf_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ 
result_, real_8 _p_ abserr_, real_8 _p_ resabs_, real_8 _p_ resasc_);
prototype int_4 _dqk15w (real_8 (*_f)(), real_8 (*_w)(), real_8 _p_ p1_, real_8 _p_ p2_, real_8 _p_ p3_, real_8 _p_ p4_
, int_4 _p_ kp_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ resabs_, real_8 _p_ 
resasc_);
prototype int_4 _dqk21 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 
_p_ resabs_, real_8 _p_ resasc_);
prototype int_4 _dqk31 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 
_p_ resabs_, real_8 _p_ resasc_);
prototype int_4 _dqk41 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 
_p_ resabs_, real_8 _p_ resasc_);
prototype int_4 _dqk51 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 
_p_ resabs_, real_8 _p_ resasc_);
prototype int_4 _dqk61 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 
_p_ resabs_, real_8 _p_ resasc_);
prototype int_4 _dqmomo (real_8 _p_ alfa_, real_8 _p_ beta_, real_8 _p_ ri_, real_8 _p_ rj_, real_8 _p_ rg_, real_8 _p_ 
rh_, int_4 _p_ integr_);
prototype int_4 _dqnc79 (real_8 (*_fun)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ err_, real_8 _p_ ans_, int_4 _p_ 
ierr_, int_4 _p_ k_);
prototype int_4 _dqng (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, real_8 _p_ 
result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_);
prototype int_4 _dqpsrt (int_4 _p_ limit_, int_4 _p_ last_, int_4 _p_ maxerr_, real_8 _p_ ermax_, real_8 _p_ elist_, 
int_4 _p_ iord_, int_4 _p_ nrmax_);
prototype real_8 _dqwgtc (real_8 _p_ x_, real_8 _p_ c_, real_8 _p_ p2_, real_8 _p_ p3_, real_8 _p_ p4_, int_4 _p_ kp_);
prototype real_8 _dqwgtf (real_8 _p_ x_, real_8 _p_ omega_, real_8 _p_ p2_, real_8 _p_ p3_, real_8 _p_ p4_, int_4 _p_ 
integr_);
prototype real_8 _dqwgts (real_8 _p_ x_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfa_, real_8 _p_ beta_, int_4 _p_ 
integr_);
prototype int_4 _qage (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ 
key_, int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 _p_ alist_, 
real_4 _p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_);
prototype int_4 _qag (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ 
key_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, 
int_4 _p_ last_, int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _qagie (real_4 (*_f)(), real_4 _p_ bound_, int_4 _p_ inf_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, 
int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 _p_ alist_, real_4 
_p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_);
prototype int_4 _qagi (real_4 (*_f)(), real_4 _p_ bound_, int_4 _p_ inf_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, 
real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ 
last_, int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _qagpe (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ npts2_, real_4 _p_ points_, real_4 _p_ 
epsabs_, real_4 _p_ epsrel_, int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_
, real_4 _p_ alist_, real_4 _p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, real_4 _p_ pts_, int_4 _p_ iord_, int_4 
_p_ level_, int_4 _p_ ndin_, int_4 _p_ last_);
prototype int_4 _qagp (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ npts2_, real_4 _p_ points_, real_4 _p_ 
epsabs_, real_4 _p_ epsrel_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ leniw_
, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _qagse (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ 
limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 _p_ alist_, real_4 _p_ blist_, 
real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_);
prototype int_4 _qags (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, real_4 _p_ 
result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, 
int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _qawce (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ epsabs_, real_4 _p_ 
epsrel_, int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 _p_ alist_, 
real_4 _p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_);
prototype int_4 _qawc (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ epsabs_, real_4 _p_ 
epsrel_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, 
int_4 _p_ last_, int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _qawfe (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ omega_, int_4 _p_ integr_, real_4 _p_ epsabs_, int_4 
_p_ limlst_, int_4 _p_ limit_, int_4 _p_ maxp1_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ 
ier_, real_4 _p_ rslst_, real_4 _p_ erlst_, int_4 _p_ ierlst_, int_4 _p_ lst_, real_4 _p_ alist_, real_4 _p_ blist_, 
real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ nnlog_, real_4 _p_ chebmo_);
prototype int_4 _qawf (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ omega_, int_4 _p_ integr_, real_4 _p_ epsabs_, real_4 
_p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limlst_, int_4 _p_ lst_, int_4 _p_ leniw_, 
int_4 _p_ maxp1_, int_4 _p_ lenw_, int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _qawoe (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ omega_, int_4 _p_ integr_, real_4 _p_ 
epsabs_, real_4 _p_ epsrel_, int_4 _p_ limit_, int_4 _p_ icall_, int_4 _p_ maxp1_, real_4 _p_ result_, real_4 _p_ 
abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ last_, real_4 _p_ alist_, real_4 _p_ blist_, real_4 _p_ rlist_, 
real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ nnlog_, int_4 _p_ momcom_, real_4 _p_ chebmo_);
prototype int_4 _qawo (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ omega_, int_4 _p_ integr_, real_4 _p_ 
epsabs_, real_4 _p_ epsrel_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ leniw_
, int_4 _p_ maxp1_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _qawse (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ alfa_, real_4 _p_ beta_, int_4 _p_ 
integr_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ 
neval_, int_4 _p_ ier_, real_4 _p_ alist_, real_4 _p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, 
int_4 _p_ last_);
prototype int_4 _qaws (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ alfa_, real_4 _p_ beta_, int_4 _p_ 
integr_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ 
ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _qc25c (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ result_, real_4 _p_ 
abserr_, int_4 _p_ krul_, int_4 _p_ neval_);
prototype int_4 _qc25f (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ omega_, int_4 _p_ integr_, int_4 _p_ 
nrmom_, int_4 _p_ maxp1_, int_4 _p_ ksave_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, real_4 _p_ 
resabs_, real_4 _p_ resasc_, int_4 _p_ momcom_, real_4 _p_ chebmo_);
prototype int_4 _qc25s (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ bl_, real_4 _p_ br_, real_4 _p_ alfa_, 
real_4 _p_ beta_, real_4 _p_ ri_, real_4 _p_ rj_, real_4 _p_ rg_, real_4 _p_ rh_, real_4 _p_ result_, real_4 _p_ 
abserr_, real_4 _p_ resasc_, int_4 _p_ integr_, int_4 _p_ nev_);
prototype int_4 _qcheb (real_4 _p_ x_, real_4 _p_ fval_, real_4 _p_ cheb12_, real_4 _p_ cheb24_);
prototype int_4 _qelg (int_4 _p_ n_, real_4 _p_ epstab_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ res3la_, 
int_4 _p_ nres_);
prototype int_4 _qk15 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ 
resabs_, real_4 _p_ resasc_);
prototype int_4 _qk15i (real_4 (*_f)(), real_4 _p_ boun_, int_4 _p_ inf_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ 
result_, real_4 _p_ abserr_, real_4 _p_ resabs_, real_4 _p_ resasc_);
prototype int_4 _qk15w (real_4 (*_f)(), real_4 (*_w)(), real_4 _p_ p1_, real_4 _p_ p2_, real_4 _p_ p3_, real_4 _p_ p4_, 
int_4 _p_ kp_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ resabs_, real_4 _p_ 
resasc_);
prototype int_4 _qk21 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ 
resabs_, real_4 _p_ resasc_);
prototype int_4 _qk31 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ 
resabs_, real_4 _p_ resasc_);
prototype int_4 _qk41 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ 
resabs_, real_4 _p_ resasc_);
prototype int_4 _qk51 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ 
resabs_, real_4 _p_ resasc_);
prototype int_4 _qk61 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ 
resabs_, real_4 _p_ resasc_);
prototype int_4 _qmomo (real_4 _p_ alfa_, real_4 _p_ beta_, real_4 _p_ ri_, real_4 _p_ rj_, real_4 _p_ rg_, real_4 _p_ 
rh_, int_4 _p_ integr_);
prototype int_4 _qnc79 (real_4 (*_fun)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ err_, real_4 _p_ ans_, int_4 _p_ 
ierr_, int_4 _p_ k_);
prototype int_4 _qng (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, real_4 _p_ 
result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_);
prototype int_4 _qpdoc (void);
prototype int_4 _qpsrt (int_4 _p_ limit_, int_4 _p_ last_, int_4 _p_ maxerr_, real_4 _p_ ermax_, real_4 _p_ elist_, 
int_4 _p_ iord_, int_4 _p_ nrmax_);
prototype real_4 _qwgtc (real_4 _p_ x_, real_4 _p_ c_, real_4 _p_ p2_, real_4 _p_ p3_, real_4 _p_ p4_, int_4 _p_ kp_);
prototype real_4 _qwgtf (real_4 _p_ x_, real_4 _p_ omega_, real_4 _p_ p2_, real_4 _p_ p3_, real_4 _p_ p4_, int_4 _p_ 
integr_);
prototype real_4 _qwgts (real_4 _p_ x_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ alfa_, real_4 _p_ beta_, int_4 _p_ 
integr_);
int_4 _dqage (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 _p_ key_, 
int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 _p_ alist_, real_8 
_p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_)
{
  static int_4 iroff1_, iroff2_, k_, keyf_, maxerr_, nrmax_;
  static real_8 area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, defabs_, defab1_, defab2_, epmach_, errbnd_, errmax_, 
  error1_, error2_, erro12_, errsum_, resabs_, uflow_;
  int_4 $0_;
  extern real_8 _d1mach ();
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  if ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-29)) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  keyf_ = (*key_);
  if ((*key_) <= 0) {
    keyf_ = 1;
  }
  if ((*key_) >= 7) {
    keyf_ = 6;
  }
  (*neval_) = 0;
  if (keyf_ == 1) {
    (void) _dqk15 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 2) {
    (void) _dqk21 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 3) {
    (void) _dqk31 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 4) {
    (void) _dqk41 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 5) {
    (void) _dqk51 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 6) {
    (void) _dqk61 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  (*last_) = 1;
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs ((*result_)));
  if ((*abserr_) <= 0.5e2 * epmach_ * defabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*ier_) != 0 || ((*abserr_) <= errbnd_ && (*abserr_) != resabs_) || (*abserr_) == 0.0e+00) {
    goto _l60;
  }
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  nrmax_ = 1;
  iroff1_ = 0;
  iroff2_ = 0;
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    if (keyf_ == 1) {
      (void) _dqk15 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 2) {
      (void) _dqk21 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 3) {
      (void) _dqk31 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 4) {
      (void) _dqk41 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 5) {
      (void) _dqk51 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 6) {
      (void) _dqk61 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 1) {
      (void) _dqk15 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 2) {
      (void) _dqk21 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 3) {
      (void) _dqk31 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 4) {
      (void) _dqk41 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 5) {
      (void) _dqk51 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 6) {
      (void) _dqk61 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    (*neval_) = (*neval_) + 1;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l5;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) <= 0.1e-4 * _abs (area12_) && erro12_ >= 0.99e+00 * errmax_) {
      iroff1_ = iroff1_ + 1;
    }
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff2_ = iroff2_ + 1;
    }
    _l5:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (errsum_ <= errbnd_) {
      goto _l8;
    }
    if (iroff1_ >= 6 || iroff2_ >= 20) {
      (*ier_) = 2;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 3;
    }
    _l8:;
    if (error2_ > error1_) {
      goto _l10;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l20;
    _l10:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l20:;
    (void) _dqpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if ((*ier_) != 0 || errsum_ <= errbnd_) {
      goto _l40;
    }
  }
  _l40:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l60:;
  if (keyf_ != 1) {
    (*neval_) = (10 * keyf_ + 1) * (2 * (*neval_) + 1);
  }
  if (keyf_ == 1) {
    (*neval_) = 30 * (*neval_) + 15;
  }
  _l999:;
  __calls[0].calls++;
  return 0;
}

int_4 _dqag (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 _p_ key_, 
real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ 
last_, int_4 _p_ iwork_, real_8 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) >= 1 && (*lenw_) >= (*limit_) * 4) {
    l1_ = (*limit_) + 1;
    l2_ = (*limit_) + l1_;
    l3_ = (*limit_) + l2_;
    (void) _dqage (_f, a_, b_, epsabs_, epsrel_, key_, limit_, result_, abserr_, neval_, ier_, &work_[0], &work_[l1_ - 1], 
    &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
    lvl_ = 0;
  }
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_1, _dc_2, ier_, &lvl_);
  }
  __calls[1].calls++;
  return 0;
}

int_4 _dqagie (real_8 (*_f)(), real_8 _p_ bound_, int_4 _p_ inf_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 _p_ 
limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 _p_ alist_, real_8 _p_ blist_, 
real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_)
{
  static int_4 id_, ierro_, iroff1_, iroff2_, iroff3_, jupbnd_, k_, ksgn_, ktmin_, maxerr_, nres_, nrmax_, numrl2_;
  static logical_4 extrap_, noext_;
  static real_8 abseps_, area_, area1_, area12_, area2_, a1_, a2_, boun_, b1_, b2_, correc_, defabs_, defab1_, defab2_, 
  dres_, epmach_, erlarg_, erlast_, errbnd_, errmax_, error1_, error2_, erro12_, errsum_, ertest_, oflow_, resabs_, 
  reseps_, res3la_[3], rlist2_[52], small_, uflow_;
  int_4 $0_, $3_;
  real_8 $1_, $2_;
  extern real_8 _d1mach ();
  epmach_ = _d1mach (($0_ = 4, &$0_));
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = 0.0;
  blist_[0] = 1.0;
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  if ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-29)) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  boun_ = (*bound_);
  if ((*inf_) == 2) {
    boun_ = 0.0;
  }
  (void) _dqk15i (_f, &boun_, inf_, ($1_ = 0.0, &$1_), ($2_ = 1.0, &$2_), result_, abserr_, &defabs_, &resabs_);
  (*last_) = 1;
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  dres_ = _abs ((*result_));
  errbnd_ = _max ((*epsabs_), (*epsrel_) * dres_);
  if ((*abserr_) <= 1.0e2 * epmach_ * defabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*ier_) != 0 || ((*abserr_) <= errbnd_ && (*abserr_) != resabs_) || (*abserr_) == 0.0e+00) {
    goto _l130;
  }
  uflow_ = _d1mach (&_k1);
  oflow_ = _d1mach (($3_ = 2, &$3_));
  rlist2_[0] = (*result_);
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  (*abserr_) = oflow_;
  nrmax_ = 1;
  nres_ = 0;
  ktmin_ = 0;
  numrl2_ = 2;
  extrap_ = FALSE;
  noext_ = FALSE;
  ierro_ = 0;
  iroff1_ = 0;
  iroff2_ = 0;
  iroff3_ = 0;
  ksgn_ = -1;
  if (dres_ >= (0.1e1 - 0.5e2 * epmach_) * defabs_) {
    ksgn_ = 1;
  }
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    erlast_ = errmax_;
    (void) _dqk15i (_f, &boun_, inf_, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    (void) _dqk15i (_f, &boun_, inf_, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l15;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) > 0.1e-4 * _abs (area12_) || erro12_ < 0.99e+00 * errmax_) {
      goto _l10;
    }
    if (extrap_) {
      iroff2_ = iroff2_ + 1;
    }
    if (! (extrap_)) {
      iroff1_ = iroff1_ + 1;
    }
    _l10:;
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff3_ = iroff3_ + 1;
    }
    _l15:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (iroff1_ + iroff2_ >= 10 || iroff3_ >= 20) {
      (*ier_) = 2;
    }
    if (iroff2_ >= 5) {
      ierro_ = 3;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 4;
    }
    if (error2_ > error1_) {
      goto _l20;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l30;
    _l20:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l30:;
    (void) _dqpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if (errsum_ <= errbnd_) {
      goto _l115;
    }
    if ((*ier_) != 0) {
      goto _l100;
    }
    if ((*last_) == 2) {
      goto _l80;
    }
    if (noext_) {
      goto _l90;
    }
    erlarg_ = erlarg_ - erlast_;
    if (_abs (b1_ - a1_) > small_) {
      erlarg_ = erlarg_ + erro12_;
    }
    if (extrap_) {
      goto _l40;
    }
    if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
      goto _l90;
    }
    extrap_ = TRUE;
    nrmax_ = 2;
    _l40:;
    if (ierro_ == 3 || erlarg_ <= ertest_) {
      goto _l60;
    }
    id_ = nrmax_;
    jupbnd_ = (*last_);
    if ((*last_) > (2 + (*limit_) / 2)) {
      jupbnd_ = (*limit_) + 3 - (*last_);
    }
    for (k_ = id_; k_ <= jupbnd_; (k_)++) {
      maxerr_ = iord_[nrmax_ - 1];
      errmax_ = elist_[maxerr_ - 1];
      if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
        goto _l90;
      }
      nrmax_ = nrmax_ + 1;
    }
    _l60:;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    (void) _dqelg (&numrl2_, rlist2_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ > 5 && (*abserr_) < 0.1e-2 * errsum_) {
      (*ier_) = 5;
    }
    if (abseps_ >= (*abserr_)) {
      goto _l70;
    }
    ktmin_ = 0;
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    correc_ = erlarg_;
    ertest_ = _max ((*epsabs_), (*epsrel_) * _abs (reseps_));
    if ((*abserr_) <= ertest_) {
      goto _l100;
    }
    _l70:;
    if (numrl2_ == 1) {
      noext_ = TRUE;
    }
    if ((*ier_) == 5) {
      goto _l100;
    }
    maxerr_ = iord_[0];
    errmax_ = elist_[maxerr_ - 1];
    nrmax_ = 1;
    extrap_ = FALSE;
    small_ = small_ * 0.5e+00;
    erlarg_ = errsum_;
    goto _l90;
    _l80:;
    small_ = 0.375;
    erlarg_ = errsum_;
    ertest_ = errbnd_;
    rlist2_[1] = area_;
    _l90:;
  }
  _l100:;
  if ((*abserr_) == oflow_) {
    goto _l115;
  }
  if (((*ier_) + ierro_) == 0) {
    goto _l110;
  }
  if (ierro_ == 3) {
    (*abserr_) = (*abserr_) + correc_;
  }
  if ((*ier_) == 0) {
    (*ier_) = 3;
  }
  if ((*result_) != 0.0e+00 && area_ != 0.0e+00) {
    goto _l105;
  }
  if ((*abserr_) > errsum_) {
    goto _l115;
  }
  if (area_ == 0.0e+00) {
    goto _l130;
  }
  goto _l110;
  _l105:;
  if ((*abserr_) / _abs ((*result_)) > errsum_ / _abs (area_)) {
    goto _l115;
  }
  _l110:;
  if (ksgn_ == -1 && _max (_abs ((*result_)), _abs (area_)) <= defabs_ * 0.1e-1) {
    goto _l130;
  }
  if (0.1e-1 > ((*result_) / area_) || ((*result_) / area_) > 0.1e3 || errsum_ > _abs (area_)) {
    (*ier_) = 6;
  }
  goto _l130;
  _l115:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l130:;
  (*neval_) = 30 * (*last_) - 15;
  if ((*inf_) == 2) {
    (*neval_) = 2 * (*neval_);
  }
  if ((*ier_) > 2) {
    (*ier_) = (*ier_) - 1;
  }
  _l999:;
  __calls[2].calls++;
  return 0;
}

int_4 _dqagi (real_8 (*_f)(), real_8 _p_ bound_, int_4 _p_ inf_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, real_8 _p_ 
result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, 
int_4 _p_ iwork_, real_8 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) < 1 || (*lenw_) < (*limit_) * 4) {
    goto _l10;
  }
  l1_ = (*limit_) + 1;
  l2_ = (*limit_) + l1_;
  l3_ = (*limit_) + l2_;
  (void) _dqagie (_f, bound_, inf_, epsabs_, epsrel_, limit_, result_, abserr_, neval_, ier_, &work_[0], &work_[l1_ - 1], 
  &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_3, _dc_2, ier_, &lvl_);
  }
  __calls[3].calls++;
  return 0;
}

int_4 _dqagpe (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, int_4 _p_ npts2_, real_8 _p_ points_, real_8 _p_ epsabs_, 
real_8 _p_ epsrel_, int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 
_p_ alist_, real_8 _p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, real_8 _p_ pts_, int_4 _p_ iord_, int_4 _p_ level_
, int_4 _p_ ndin_, int_4 _p_ last_)
{
  static int_4 i_, id_, ierro_, ind1_, ind2_, ip1_, iroff1_, iroff2_, iroff3_, j_, jlow_, jupbnd_, k_, ksgn_, ktmin_, 
  levcur_, levmax_, maxerr_, nint_, nintp1_, npts_, nres_, nrmax_, numrl2_;
  static logical_4 extrap_, noext_;
  static real_8 abseps_, area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, correc_, defabs_, defab1_, defab2_, dres_, 
  epmach_, erlarg_, erlast_, errbnd_, errmax_, error1_, erro12_, error2_, errsum_, ertest_, oflow_, resa_, resabs_, 
  reseps_, res3la_[3], rlist2_[52], sign_, temp_, uflow_;
  int_4 $0_, $1_;
  extern real_8 _d1mach ();
  epmach_ = _d1mach (($0_ = 4, &$0_));
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  level_[0] = 0;
  npts_ = (*npts2_) - 2;
  if ((*npts2_) < 2 || (*limit_) <= npts_ || ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-29))) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  sign_ = 1.0;
  if ((*a_) > (*b_)) {
    sign_ = -1.0;
  }
  pts_[0] = _min ((*a_), (*b_));
  if (npts_ == 0) {
    goto _l15;
  }
  for (i_ = 1; i_ <= npts_; (i_)++) {
    pts_[i_ + 1 - 1] = points_[i_ - 1];
  }
  _l15:;
  pts_[npts_ + 2 - 1] = _max ((*a_), (*b_));
  nint_ = npts_ + 1;
  a1_ = pts_[0];
  if (npts_ == 0) {
    goto _l40;
  }
  nintp1_ = nint_ + 1;
  for (i_ = 1; i_ <= nint_; (i_)++) {
    ip1_ = i_ + 1;
    for (j_ = ip1_; j_ <= nintp1_; (j_)++) {
      if (pts_[i_ - 1] <= pts_[j_ - 1]) {
        goto _l20;
      }
      temp_ = pts_[i_ - 1];
      pts_[i_ - 1] = pts_[j_ - 1];
      pts_[j_ - 1] = temp_;
      _l20:;
    }
  }
  if (pts_[0] != _min ((*a_), (*b_)) || pts_[nintp1_ - 1] != _max ((*a_), (*b_))) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  _l40:;
  resabs_ = 0.0;
  for (i_ = 1; i_ <= nint_; (i_)++) {
    b1_ = pts_[i_ + 1 - 1];
    (void) _dqk21 (_f, &a1_, &b1_, &area1_, &error1_, &defabs_, &resa_);
    (*abserr_) = (*abserr_) + error1_;
    (*result_) = (*result_) + area1_;
    ndin_[i_ - 1] = 0;
    if (error1_ == resa_ && error1_ != 0.0e+00) {
      ndin_[i_ - 1] = 1;
    }
    resabs_ = resabs_ + defabs_;
    level_[i_ - 1] = 0;
    elist_[i_ - 1] = error1_;
    alist_[i_ - 1] = a1_;
    blist_[i_ - 1] = b1_;
    rlist_[i_ - 1] = area1_;
    iord_[i_ - 1] = i_;
    a1_ = b1_;
  }
  errsum_ = 0.0;
  for (i_ = 1; i_ <= nint_; (i_)++) {
    if (ndin_[i_ - 1] == 1) {
      elist_[i_ - 1] = (*abserr_);
    }
    errsum_ = errsum_ + elist_[i_ - 1];
  }
  (*last_) = nint_;
  (*neval_) = 21 * nint_;
  dres_ = _abs ((*result_));
  errbnd_ = _max ((*epsabs_), (*epsrel_) * dres_);
  if ((*abserr_) <= 0.1e3 * epmach_ * resabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if (nint_ == 1) {
    goto _l80;
  }
  for (i_ = 1; i_ <= npts_; (i_)++) {
    jlow_ = i_ + 1;
    ind1_ = iord_[i_ - 1];
    for (j_ = jlow_; j_ <= nint_; (j_)++) {
      ind2_ = iord_[j_ - 1];
      if (elist_[ind1_ - 1] > elist_[ind2_ - 1]) {
        goto _l60;
      }
      ind1_ = ind2_;
      k_ = j_;
      _l60:;
    }
    if (ind1_ == iord_[i_ - 1]) {
      goto _l70;
    }
    iord_[k_ - 1] = iord_[i_ - 1];
    iord_[i_ - 1] = ind1_;
    _l70:;
  }
  if ((*limit_) < (*npts2_)) {
    (*ier_) = 1;
  }
  _l80:;
  if ((*ier_) != 0 || (*abserr_) <= errbnd_) {
    goto _l999;
  }
  rlist2_[0] = (*result_);
  maxerr_ = iord_[0];
  errmax_ = elist_[maxerr_ - 1];
  area_ = (*result_);
  nrmax_ = 1;
  nres_ = 0;
  numrl2_ = 1;
  ktmin_ = 0;
  extrap_ = FALSE;
  noext_ = FALSE;
  erlarg_ = errsum_;
  ertest_ = errbnd_;
  levmax_ = 1;
  iroff1_ = 0;
  iroff2_ = 0;
  iroff3_ = 0;
  ierro_ = 0;
  uflow_ = _d1mach (&_k1);
  oflow_ = _d1mach (($1_ = 2, &$1_));
  (*abserr_) = oflow_;
  ksgn_ = -1;
  if (dres_ >= (0.1e1 - 0.5e2 * epmach_) * resabs_) {
    ksgn_ = 1;
  }
  for ((*last_) = (*npts2_); (*last_) <= (*limit_); ((*last_))++) {
    levcur_ = level_[maxerr_ - 1] + 1;
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    erlast_ = errmax_;
    (void) _dqk21 (_f, &a1_, &b1_, &area1_, &error1_, &resa_, &defab1_);
    (void) _dqk21 (_f, &a2_, &b2_, &area2_, &error2_, &resa_, &defab2_);
    (*neval_) = (*neval_) + 42;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l95;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) > 0.1e-4 * _abs (area12_) || erro12_ < 0.99e+00 * errmax_) {
      goto _l90;
    }
    if (extrap_) {
      iroff2_ = iroff2_ + 1;
    }
    if (! (extrap_)) {
      iroff1_ = iroff1_ + 1;
    }
    _l90:;
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff3_ = iroff3_ + 1;
    }
    _l95:;
    level_[maxerr_ - 1] = levcur_;
    level_[(*last_) - 1] = levcur_;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (iroff1_ + iroff2_ >= 10 || iroff3_ >= 20) {
      (*ier_) = 2;
    }
    if (iroff2_ >= 5) {
      ierro_ = 3;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 4;
    }
    if (error2_ > error1_) {
      goto _l100;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l110;
    _l100:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l110:;
    (void) _dqpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if (errsum_ <= errbnd_) {
      goto _l190;
    }
    if ((*ier_) != 0) {
      goto _l170;
    }
    if (noext_) {
      goto _l160;
    }
    erlarg_ = erlarg_ - erlast_;
    if (levcur_ + 1 <= levmax_) {
      erlarg_ = erlarg_ + erro12_;
    }
    if (extrap_) {
      goto _l120;
    }
    if (level_[maxerr_ - 1] + 1 <= levmax_) {
      goto _l160;
    }
    extrap_ = TRUE;
    nrmax_ = 2;
    _l120:;
    if (ierro_ == 3 || erlarg_ <= ertest_) {
      goto _l140;
    }
    id_ = nrmax_;
    jupbnd_ = (*last_);
    if ((*last_) > (2 + (*limit_) / 2)) {
      jupbnd_ = (*limit_) + 3 - (*last_);
    }
    for (k_ = id_; k_ <= jupbnd_; (k_)++) {
      maxerr_ = iord_[nrmax_ - 1];
      errmax_ = elist_[maxerr_ - 1];
      if (level_[maxerr_ - 1] + 1 <= levmax_) {
        goto _l160;
      }
      nrmax_ = nrmax_ + 1;
    }
    _l140:;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    if (numrl2_ <= 2) {
      goto _l155;
    }
    (void) _dqelg (&numrl2_, rlist2_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ > 5 && (*abserr_) < 0.1e-2 * errsum_) {
      (*ier_) = 5;
    }
    if (abseps_ >= (*abserr_)) {
      goto _l150;
    }
    ktmin_ = 0;
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    correc_ = erlarg_;
    ertest_ = _max ((*epsabs_), (*epsrel_) * _abs (reseps_));
    if ((*abserr_) < ertest_) {
      goto _l170;
    }
    _l150:;
    if (numrl2_ == 1) {
      noext_ = TRUE;
    }
    if ((*ier_) >= 5) {
      goto _l170;
    }
    _l155:;
    maxerr_ = iord_[0];
    errmax_ = elist_[maxerr_ - 1];
    nrmax_ = 1;
    extrap_ = FALSE;
    levmax_ = levmax_ + 1;
    erlarg_ = errsum_;
    _l160:;
  }
  _l170:;
  if ((*abserr_) == oflow_) {
    goto _l190;
  }
  if (((*ier_) + ierro_) == 0) {
    goto _l180;
  }
  if (ierro_ == 3) {
    (*abserr_) = (*abserr_) + correc_;
  }
  if ((*ier_) == 0) {
    (*ier_) = 3;
  }
  if ((*result_) != 0.0e+00 && area_ != 0.0e+00) {
    goto _l175;
  }
  if ((*abserr_) > errsum_) {
    goto _l190;
  }
  if (area_ == 0.0e+00) {
    goto _l210;
  }
  goto _l180;
  _l175:;
  if ((*abserr_) / _abs ((*result_)) > errsum_ / _abs (area_)) {
    goto _l190;
  }
  _l180:;
  if (ksgn_ == -1 && _max (_abs ((*result_)), _abs (area_)) <= defabs_ * 0.1e-1) {
    goto _l210;
  }
  if (0.1e-1 > ((*result_) / area_) || ((*result_) / area_) > 0.1e3 || errsum_ > _abs (area_)) {
    (*ier_) = 6;
  }
  goto _l210;
  _l190:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l210:;
  if ((*ier_) > 2) {
    (*ier_) = (*ier_) - 1;
  }
  (*result_) = (*result_) * sign_;
  _l999:;
  __calls[4].calls++;
  return 0;
}

int_4 _dqagp (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, int_4 _p_ npts2_, real_8 _p_ points_, real_8 _p_ epsabs_, 
real_8 _p_ epsrel_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ leniw_, int_4 
_p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_8 _p_ work_)
{
  static int_4 limit_, lvl_, l1_, l2_, l3_, l4_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*leniw_) < (3 * (*npts2_) - 2) || (*lenw_) < ((*leniw_) * 2 - (*npts2_)) || (*npts2_) < 2) {
    goto _l10;
  }
  limit_ = ((*leniw_) - (*npts2_)) / 2;
  l1_ = limit_ + 1;
  l2_ = limit_ + l1_;
  l3_ = limit_ + l2_;
  l4_ = limit_ + l3_;
  (void) _dqagpe (_f, a_, b_, npts2_, points_, epsabs_, epsrel_, &limit_, result_, abserr_, neval_, ier_, &work_[0], 
  &work_[l1_ - 1], &work_[l2_ - 1], &work_[l3_ - 1], &work_[l4_ - 1], &iwork_[0], &iwork_[l1_ - 1], &iwork_[l2_ - 1], 
  last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_4, _dc_2, ier_, &lvl_);
  }
  __calls[5].calls++;
  return 0;
}

int_4 _dqagse (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 _p_ limit_, 
real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 _p_ alist_, real_8 _p_ blist_, real_8 
_p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_)
{
  static int_4 id_, ierro_, iroff1_, iroff2_, iroff3_, jupbnd_, k_, ksgn_, ktmin_, maxerr_, nres_, nrmax_, numrl2_;
  static logical_4 extrap_, noext_;
  static real_8 abseps_, area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, correc_, defabs_, defab1_, defab2_, dres_, 
  epmach_, erlarg_, erlast_, errbnd_, errmax_, error1_, error2_, erro12_, errsum_, ertest_, oflow_, resabs_, reseps_, 
  res3la_[3], rlist2_[52], small_, uflow_;
  int_4 $0_, $1_;
  extern real_8 _d1mach ();
  epmach_ = _d1mach (($0_ = 4, &$0_));
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  if ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-29)) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  uflow_ = _d1mach (&_k1);
  oflow_ = _d1mach (($1_ = 2, &$1_));
  ierro_ = 0;
  (void) _dqk21 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  dres_ = _abs ((*result_));
  errbnd_ = _max ((*epsabs_), (*epsrel_) * dres_);
  (*last_) = 1;
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  if ((*abserr_) <= 1.0e2 * epmach_ * defabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*ier_) != 0 || ((*abserr_) <= errbnd_ && (*abserr_) != resabs_) || (*abserr_) == 0.0e+00) {
    goto _l140;
  }
  rlist2_[0] = (*result_);
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  (*abserr_) = oflow_;
  nrmax_ = 1;
  nres_ = 0;
  numrl2_ = 2;
  ktmin_ = 0;
  extrap_ = FALSE;
  noext_ = FALSE;
  iroff1_ = 0;
  iroff2_ = 0;
  iroff3_ = 0;
  ksgn_ = -1;
  if (dres_ >= (0.1e1 - 0.5e2 * epmach_) * defabs_) {
    ksgn_ = 1;
  }
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    erlast_ = errmax_;
    (void) _dqk21 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    (void) _dqk21 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l15;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) > 0.1e-4 * _abs (area12_) || erro12_ < 0.99e+00 * errmax_) {
      goto _l10;
    }
    if (extrap_) {
      iroff2_ = iroff2_ + 1;
    }
    if (! (extrap_)) {
      iroff1_ = iroff1_ + 1;
    }
    _l10:;
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff3_ = iroff3_ + 1;
    }
    _l15:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (iroff1_ + iroff2_ >= 10 || iroff3_ >= 20) {
      (*ier_) = 2;
    }
    if (iroff2_ >= 5) {
      ierro_ = 3;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 4;
    }
    if (error2_ > error1_) {
      goto _l20;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l30;
    _l20:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l30:;
    (void) _dqpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if (errsum_ <= errbnd_) {
      goto _l115;
    }
    if ((*ier_) != 0) {
      goto _l100;
    }
    if ((*last_) == 2) {
      goto _l80;
    }
    if (noext_) {
      goto _l90;
    }
    erlarg_ = erlarg_ - erlast_;
    if (_abs (b1_ - a1_) > small_) {
      erlarg_ = erlarg_ + erro12_;
    }
    if (extrap_) {
      goto _l40;
    }
    if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
      goto _l90;
    }
    extrap_ = TRUE;
    nrmax_ = 2;
    _l40:;
    if (ierro_ == 3 || erlarg_ <= ertest_) {
      goto _l60;
    }
    id_ = nrmax_;
    jupbnd_ = (*last_);
    if ((*last_) > (2 + (*limit_) / 2)) {
      jupbnd_ = (*limit_) + 3 - (*last_);
    }
    for (k_ = id_; k_ <= jupbnd_; (k_)++) {
      maxerr_ = iord_[nrmax_ - 1];
      errmax_ = elist_[maxerr_ - 1];
      if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
        goto _l90;
      }
      nrmax_ = nrmax_ + 1;
    }
    _l60:;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    (void) _dqelg (&numrl2_, rlist2_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ > 5 && (*abserr_) < 0.1e-2 * errsum_) {
      (*ier_) = 5;
    }
    if (abseps_ >= (*abserr_)) {
      goto _l70;
    }
    ktmin_ = 0;
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    correc_ = erlarg_;
    ertest_ = _max ((*epsabs_), (*epsrel_) * _abs (reseps_));
    if ((*abserr_) <= ertest_) {
      goto _l100;
    }
    _l70:;
    if (numrl2_ == 1) {
      noext_ = TRUE;
    }
    if ((*ier_) == 5) {
      goto _l100;
    }
    maxerr_ = iord_[0];
    errmax_ = elist_[maxerr_ - 1];
    nrmax_ = 1;
    extrap_ = FALSE;
    small_ = small_ * 0.5e+00;
    erlarg_ = errsum_;
    goto _l90;
    _l80:;
    small_ = _abs ((*b_) - (*a_)) * 0.375e+00;
    erlarg_ = errsum_;
    ertest_ = errbnd_;
    rlist2_[1] = area_;
    _l90:;
  }
  _l100:;
  if ((*abserr_) == oflow_) {
    goto _l115;
  }
  if ((*ier_) + ierro_ == 0) {
    goto _l110;
  }
  if (ierro_ == 3) {
    (*abserr_) = (*abserr_) + correc_;
  }
  if ((*ier_) == 0) {
    (*ier_) = 3;
  }
  if ((*result_) != 0.0e+00 && area_ != 0.0e+00) {
    goto _l105;
  }
  if ((*abserr_) > errsum_) {
    goto _l115;
  }
  if (area_ == 0.0e+00) {
    goto _l130;
  }
  goto _l110;
  _l105:;
  if ((*abserr_) / _abs ((*result_)) > errsum_ / _abs (area_)) {
    goto _l115;
  }
  _l110:;
  if (ksgn_ == -1 && _max (_abs ((*result_)), _abs (area_)) <= defabs_ * 0.1e-1) {
    goto _l130;
  }
  if (0.1e-1 > ((*result_) / area_) || ((*result_) / area_) > 0.1e3 || errsum_ > _abs (area_)) {
    (*ier_) = 6;
  }
  goto _l130;
  _l115:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l130:;
  if ((*ier_) > 2) {
    (*ier_) = (*ier_) - 1;
  }
  _l140:;
  (*neval_) = 42 * (*last_) - 21;
  _l999:;
  __calls[6].calls++;
  return 0;
}

int_4 _dqags (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, real_8 _p_ result_, 
real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ 
iwork_, real_8 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) < 1 || (*lenw_) < (*limit_) * 4) {
    goto _l10;
  }
  l1_ = (*limit_) + 1;
  l2_ = (*limit_) + l1_;
  l3_ = (*limit_) + l2_;
  (void) _dqagse (_f, a_, b_, epsabs_, epsrel_, limit_, result_, abserr_, neval_, ier_, &work_[0], &work_[l1_ - 1], 
  &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_5, _dc_2, ier_, &lvl_);
  }
  __calls[7].calls++;
  return 0;
}

int_4 _dqawce (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, 
int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_8 _p_ alist_, real_8 
_p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_)
{
  static int_4 iroff1_, iroff2_, k_, krule_, maxerr_, nev_, nrmax_;
  static real_8 aa_, area_, area1_, area12_, area2_, a1_, a2_, bb_, b1_, b2_, epmach_, errbnd_, errmax_, error1_, erro12_
  , error2_, errsum_, uflow_;
  int_4 $0_;
  extern real_8 _d1mach ();
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*c_) == (*a_) || (*c_) == (*b_) || ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-29))) {
    goto _l999;
  }
  aa_ = (*a_);
  bb_ = (*b_);
  if ((*a_) <= (*b_)) {
    goto _l10;
  }
  aa_ = (*b_);
  bb_ = (*a_);
  _l10:;
  (*ier_) = 0;
  krule_ = 1;
  (void) _dqc25c (_f, &aa_, &bb_, c_, result_, abserr_, &krule_, neval_);
  (*last_) = 1;
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs ((*result_)));
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*abserr_) < _min (0.1e-1 * _abs ((*result_)), errbnd_) || (*ier_) == 1) {
    goto _l70;
  }
  alist_[0] = aa_;
  blist_[0] = bb_;
  rlist_[0] = (*result_);
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  nrmax_ = 1;
  iroff1_ = 0;
  iroff2_ = 0;
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    b2_ = blist_[maxerr_ - 1];
    if ((*c_) <= b1_ && (*c_) > a1_) {
      b1_ = 0.5e+00 * ((*c_) + b2_);
    }
    if ((*c_) > b1_ && (*c_) < b2_) {
      b1_ = 0.5e+00 * (a1_ + (*c_));
    }
    a2_ = b1_;
    krule_ = 2;
    (void) _dqc25c (_f, &a1_, &b1_, c_, &area1_, &error1_, &krule_, &nev_);
    (*neval_) = (*neval_) + nev_;
    (void) _dqc25c (_f, &a2_, &b2_, c_, &area2_, &error2_, &krule_, &nev_);
    (*neval_) = (*neval_) + nev_;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (_abs (rlist_[maxerr_ - 1] - area12_) < 0.1e-4 * _abs (area12_) && erro12_ >= 0.99e+00 * errmax_ && krule_ == 0) {
      iroff1_ = iroff1_ + 1;
    }
    if ((*last_) > 10 && erro12_ > errmax_ && krule_ == 0) {
      iroff2_ = iroff2_ + 1;
    }
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (errsum_ <= errbnd_) {
      goto _l15;
    }
    if (iroff1_ >= 6 && iroff2_ > 20) {
      (*ier_) = 2;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 3;
    }
    _l15:;
    if (error2_ > error1_) {
      goto _l20;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l30;
    _l20:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l30:;
    (void) _dqpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if ((*ier_) != 0 || errsum_ <= errbnd_) {
      goto _l50;
    }
  }
  _l50:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l70:;
  if (aa_ == (*b_)) {
    (*result_) = -(*result_);
  }
  _l999:;
  __calls[8].calls++;
  return 0;
}

int_4 _dqawc (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, 
real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ 
last_, int_4 _p_ iwork_, real_8 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) < 1 || (*lenw_) < (*limit_) * 4) {
    goto _l10;
  }
  l1_ = (*limit_) + 1;
  l2_ = (*limit_) + l1_;
  l3_ = (*limit_) + l2_;
  (void) _dqawce (_f, a_, b_, c_, epsabs_, epsrel_, limit_, result_, abserr_, neval_, ier_, &work_[0], &work_[l1_ - 1], 
  &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_6, _dc_2, ier_, &lvl_);
  }
  __calls[9].calls++;
  return 0;
}

int_4 _dqawfe (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ omega_, int_4 _p_ integr_, real_8 _p_ epsabs_, int_4 _p_ 
limlst_, int_4 _p_ limit_, int_4 _p_ maxp1_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, 
real_8 _p_ rslst_, real_8 _p_ erlst_, int_4 _p_ ierlst_, int_4 _p_ lst_, real_8 _p_ alist_, real_8 _p_ blist_, real_8 
_p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ nnlog_, real_8 _p_ chebmo_)
{
  static int_4 ktmin_, l_, last_, ll_, momcom_, nev_, nres_, numrl2_;
  static real_8 abseps_, correc_, cycle_, c1_, c2_, dl_, drl_, ep_, eps_, epsa_, errsum_, fact_, p_, pi_, p1_, psum_[52], 
  reseps_, res3la_[3], uflow_;
  int_4 _data_k_0, _data_k_1;
  real_8 $0_, $1_;
  extern real_8 _d1mach ();
#define _data_n_0 1
  static real_8 _data_l_0[_data_n_0] = {
    0.9e+00
  };
#define _data_n_1 1
  static real_8 _data_l_1[_data_n_1] = {
    3.1415926535897932384626433832795e0
  };
  if (__calls[10].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    p_ = _data_l_0[_data_k_0++];
  }
  if (__calls[10].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    pi_ = _data_l_1[_data_k_1++];
  }
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  (*neval_) = 0;
  (*lst_) = 0;
  (*ier_) = 0;
  if (((*integr_) != 1 && (*integr_) != 2) || (*epsabs_) <= 0.0e+00 || (*limlst_) < 3) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  if ((*omega_) != 0.0e+00) {
    goto _l10;
  }
  if ((*integr_) == 1) {
    (void) _dqagie (_f, a_, &_k1, epsabs_, ($0_ = 0.0, &$0_), limit_, result_, abserr_, neval_, ier_, alist_, blist_, 
    rlist_, elist_, iord_, &last_);
  }
  rslst_[0] = (*result_);
  erlst_[0] = (*abserr_);
  ierlst_[0] = (*ier_);
  (*lst_) = 1;
  goto _l999;
  _l10:;
  l_ = _abs ((*omega_));
  dl_ = 2 * l_ + 1;
  cycle_ = dl_ * pi_ / _abs ((*omega_));
  (*ier_) = 0;
  ktmin_ = 0;
  (*neval_) = 0;
  numrl2_ = 0;
  nres_ = 0;
  c1_ = (*a_);
  c2_ = cycle_ + (*a_);
  p1_ = 0.1e1 - p_;
  uflow_ = _d1mach (&_k1);
  eps_ = (*epsabs_);
  if ((*epsabs_) > uflow_ / p1_) {
    eps_ = (*epsabs_) * p1_;
  }
  ep_ = eps_;
  fact_ = 1.0;
  correc_ = 0.0;
  (*abserr_) = 0.0;
  errsum_ = 0.0;
  for ((*lst_) = 1; (*lst_) <= (*limlst_); ((*lst_))++) {
    epsa_ = eps_ * fact_;
    (void) _dqawoe (_f, &c1_, &c2_, omega_, integr_, &epsa_, ($1_ = 0.0, &$1_), limit_, lst_, maxp1_, &rslst_[(*lst_) - 1], 
    &erlst_[(*lst_) - 1], &nev_, &ierlst_[(*lst_) - 1], &last_, alist_, blist_, rlist_, elist_, iord_, nnlog_, &momcom_, 
    chebmo_);
    (*neval_) = (*neval_) + nev_;
    fact_ = fact_ * p_;
    errsum_ = errsum_ + erlst_[(*lst_) - 1];
    drl_ = 0.5e2 * _abs (rslst_[(*lst_) - 1]);
    if ((errsum_ + drl_) <= (*epsabs_) && (*lst_) >= 6) {
      goto _l80;
    }
    correc_ = _max (correc_, erlst_[(*lst_) - 1]);
    if (ierlst_[(*lst_) - 1] != 0) {
      eps_ = _max (ep_, correc_ * p1_);
    }
    if (ierlst_[(*lst_) - 1] != 0) {
      (*ier_) = 7;
    }
    if ((*ier_) == 7 && (errsum_ + drl_) <= correc_ * 0.1e2 && (*lst_) > 5) {
      goto _l80;
    }
    numrl2_ = numrl2_ + 1;
    if ((*lst_) > 1) {
      goto _l20;
    }
    psum_[0] = rslst_[0];
    goto _l40;
    _l20:;
    psum_[numrl2_ - 1] = psum_[ll_ - 1] + rslst_[(*lst_) - 1];
    if ((*lst_) == 2) {
      goto _l40;
    }
    if ((*lst_) == (*limlst_)) {
      (*ier_) = 1;
    }
    (void) _dqelg (&numrl2_, psum_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ >= 15 && (*abserr_) <= 0.1e-2 * (errsum_ + drl_)) {
      (*ier_) = 4;
    }
    if (abseps_ > (*abserr_) && (*lst_) != 3) {
      goto _l30;
    }
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    ktmin_ = 0;
    if (((*abserr_) + 0.1e2 * correc_) <= (*epsabs_) || ((*abserr_) <= (*epsabs_) && 0.1e2 * correc_ >= (*epsabs_))) {
      goto _l60;
    }
    _l30:;
    if ((*ier_) != 0 && (*ier_) != 7) {
      goto _l60;
    }
    _l40:;
    ll_ = numrl2_;
    c1_ = c2_;
    c2_ = c2_ + cycle_;
  }
  _l60:;
  (*abserr_) = (*abserr_) + 0.1e2 * correc_;
  if ((*ier_) == 0) {
    goto _l999;
  }
  if ((*result_) != 0.0e+00 && psum_[numrl2_ - 1] != 0.0e+00) {
    goto _l70;
  }
  if ((*abserr_) > errsum_) {
    goto _l80;
  }
  if (psum_[numrl2_ - 1] == 0.0e+00) {
    goto _l999;
  }
  _l70:;
  if ((*abserr_) / _abs ((*result_)) > (errsum_ + drl_) / _abs (psum_[numrl2_ - 1])) {
    goto _l80;
  }
  if ((*ier_) >= 1 && (*ier_) != 7) {
    (*abserr_) = (*abserr_) + drl_;
  }
  goto _l999;
  _l80:;
  (*result_) = psum_[numrl2_ - 1];
  (*abserr_) = errsum_ + drl_;
  _l999:;
  __calls[10].calls++;
  return 0;
}

int_4 _dqawf (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ omega_, int_4 _p_ integr_, real_8 _p_ epsabs_, real_8 _p_ 
result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limlst_, int_4 _p_ lst_, int_4 _p_ leniw_, 
int_4 _p_ maxp1_, int_4 _p_ lenw_, int_4 _p_ iwork_, real_8 _p_ work_)
{
  static int_4 limit_, ll2_, lvl_, l1_, l2_, l3_, l4_, l5_, l6_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limlst_) < 3 || (*leniw_) < ((*limlst_) + 2) || (*maxp1_) < 1 || (*lenw_) < ((*leniw_) * 2 + (*maxp1_) * 25)) {
    goto _l10;
  }
  limit_ = ((*leniw_) - (*limlst_)) / 2;
  l1_ = (*limlst_) + 1;
  l2_ = (*limlst_) + l1_;
  l3_ = limit_ + l2_;
  l4_ = limit_ + l3_;
  l5_ = limit_ + l4_;
  l6_ = limit_ + l5_;
  ll2_ = limit_ + l1_;
  (void) _dqawfe (_f, a_, omega_, integr_, epsabs_, limlst_, &limit_, maxp1_, result_, abserr_, neval_, ier_, &work_[0], 
  &work_[l1_ - 1], &iwork_[0], lst_, &work_[l2_ - 1], &work_[l3_ - 1], &work_[l4_ - 1], &work_[l5_ - 1], &iwork_[l1_ - 
  1], &iwork_[ll2_ - 1], &work_[l6_ - 1]);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_7, _dc_2, ier_, &lvl_);
  }
  __calls[11].calls++;
  return 0;
}

int_4 _dqawoe (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ omega_, int_4 _p_ integr_, real_8 _p_ epsabs_, 
real_8 _p_ epsrel_, int_4 _p_ limit_, int_4 _p_ icall_, int_4 _p_ maxp1_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 
_p_ neval_, int_4 _p_ ier_, int_4 _p_ last_, real_8 _p_ alist_, real_8 _p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_
, int_4 _p_ iord_, int_4 _p_ nnlog_, int_4 _p_ momcom_, real_8 _p_ chebmo_)
{
  static int_4 id_, ierro_, iroff1_, iroff2_, iroff3_, jupbnd_, k_, ksgn_, ktmin_, maxerr_, nev_, nres_, nrmax_, nrmom_, 
  numrl2_;
  static logical_4 extrap_, noext_, extall_;
  static real_8 abseps_, area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, correc_, defab1_, defab2_, defabs_, domega_, 
  dres_, epmach_, erlarg_, erlast_, errbnd_, errmax_, error1_, erro12_, error2_, errsum_, ertest_, oflow_, resabs_, 
  reseps_, res3la_[3], rlist2_[52], small_, uflow_, width_;
  int_4 $0_, $1_;
  extern real_8 _d1mach ();
  epmach_ = _d1mach (($0_ = 4, &$0_));
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  nnlog_[0] = 0;
  if (((*integr_) != 1 && (*integr_) != 2) || ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-29)) || 
    (*icall_) < 1 || (*maxp1_) < 1) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  domega_ = _abs ((*omega_));
  nrmom_ = 0;
  if ((*icall_) > 1) {
    goto _l5;
  }
  (*momcom_) = 0;
  _l5:;
  (void) _dqc25f (_f, a_, b_, &domega_, integr_, &nrmom_, maxp1_, &_k0, result_, abserr_, neval_, &defabs_, &resabs_, 
  momcom_, chebmo_);
  dres_ = _abs ((*result_));
  errbnd_ = _max ((*epsabs_), (*epsrel_) * dres_);
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  if ((*abserr_) <= 0.1e3 * epmach_ * defabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*ier_) != 0 || (*abserr_) <= errbnd_) {
    goto _l200;
  }
  uflow_ = _d1mach (&_k1);
  oflow_ = _d1mach (($1_ = 2, &$1_));
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  (*abserr_) = oflow_;
  nrmax_ = 1;
  extrap_ = FALSE;
  noext_ = FALSE;
  ierro_ = 0;
  iroff1_ = 0;
  iroff2_ = 0;
  iroff3_ = 0;
  ktmin_ = 0;
  small_ = _abs ((*b_) - (*a_)) * 0.75e+00;
  nres_ = 0;
  numrl2_ = 0;
  extall_ = FALSE;
  if (0.5e+00 * _abs ((*b_) - (*a_)) * domega_ > 0.2e1) {
    goto _l10;
  }
  numrl2_ = 1;
  extall_ = TRUE;
  rlist2_[0] = (*result_);
  _l10:;
  if (0.25e+00 * _abs ((*b_) - (*a_)) * domega_ <= 0.2e1) {
    extall_ = TRUE;
  }
  ksgn_ = -1;
  if (dres_ >= (0.1e1 - 0.5e2 * epmach_) * defabs_) {
    ksgn_ = 1;
  }
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    nrmom_ = nnlog_[maxerr_ - 1] + 1;
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    erlast_ = errmax_;
    (void) _dqc25f (_f, &a1_, &b1_, &domega_, integr_, &nrmom_, maxp1_, &_k0, &area1_, &error1_, &nev_, &resabs_, &defab1_, 
    momcom_, chebmo_);
    (*neval_) = (*neval_) + nev_;
    (void) _dqc25f (_f, &a2_, &b2_, &domega_, integr_, &nrmom_, maxp1_, &_k1, &area2_, &error2_, &nev_, &resabs_, &defab2_, 
    momcom_, chebmo_);
    (*neval_) = (*neval_) + nev_;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l25;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) > 0.1e-4 * _abs (area12_) || erro12_ < 0.99e+00 * errmax_) {
      goto _l20;
    }
    if (extrap_) {
      iroff2_ = iroff2_ + 1;
    }
    if (! (extrap_)) {
      iroff1_ = iroff1_ + 1;
    }
    _l20:;
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff3_ = iroff3_ + 1;
    }
    _l25:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    nnlog_[maxerr_ - 1] = nrmom_;
    nnlog_[(*last_) - 1] = nrmom_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (iroff1_ + iroff2_ >= 10 || iroff3_ >= 20) {
      (*ier_) = 2;
    }
    if (iroff2_ >= 5) {
      ierro_ = 3;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 4;
    }
    if (error2_ > error1_) {
      goto _l30;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l40;
    _l30:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l40:;
    (void) _dqpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if (errsum_ <= errbnd_) {
      goto _l170;
    }
    if ((*ier_) != 0) {
      goto _l150;
    }
    if ((*last_) == 2 && extall_) {
      goto _l120;
    }
    if (noext_) {
      goto _l140;
    }
    if (! (extall_)) {
      goto _l50;
    }
    erlarg_ = erlarg_ - erlast_;
    if (_abs (b1_ - a1_) > small_) {
      erlarg_ = erlarg_ + erro12_;
    }
    if (extrap_) {
      goto _l70;
    }
    _l50:;
    width_ = _abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]);
    if (width_ > small_) {
      goto _l140;
    }
    if (extall_) {
      goto _l60;
    }
    small_ = small_ * 0.5e+00;
    if (0.25e+00 * width_ * domega_ > 0.2e1) {
      goto _l140;
    }
    extall_ = TRUE;
    goto _l130;
    _l60:;
    extrap_ = TRUE;
    nrmax_ = 2;
    _l70:;
    if (ierro_ == 3 || erlarg_ <= ertest_) {
      goto _l90;
    }
    jupbnd_ = (*last_);
    if ((*last_) > ((*limit_) / 2 + 2)) {
      jupbnd_ = (*limit_) + 3 - (*last_);
    }
    id_ = nrmax_;
    for (k_ = id_; k_ <= jupbnd_; (k_)++) {
      maxerr_ = iord_[nrmax_ - 1];
      errmax_ = elist_[maxerr_ - 1];
      if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
        goto _l140;
      }
      nrmax_ = nrmax_ + 1;
    }
    _l90:;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    if (numrl2_ < 3) {
      goto _l110;
    }
    (void) _dqelg (&numrl2_, rlist2_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ > 5 && (*abserr_) < 0.1e-2 * errsum_) {
      (*ier_) = 5;
    }
    if (abseps_ >= (*abserr_)) {
      goto _l100;
    }
    ktmin_ = 0;
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    correc_ = erlarg_;
    ertest_ = _max ((*epsabs_), (*epsrel_) * _abs (reseps_));
    if ((*abserr_) <= ertest_) {
      goto _l150;
    }
    _l100:;
    if (numrl2_ == 1) {
      noext_ = TRUE;
    }
    if ((*ier_) == 5) {
      goto _l150;
    }
    _l110:;
    maxerr_ = iord_[0];
    errmax_ = elist_[maxerr_ - 1];
    nrmax_ = 1;
    extrap_ = FALSE;
    small_ = small_ * 0.5e+00;
    erlarg_ = errsum_;
    goto _l140;
    _l120:;
    small_ = small_ * 0.5e+00;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    _l130:;
    ertest_ = errbnd_;
    erlarg_ = errsum_;
    _l140:;
  }
  _l150:;
  if ((*abserr_) == oflow_ || nres_ == 0) {
    goto _l170;
  }
  if ((*ier_) + ierro_ == 0) {
    goto _l165;
  }
  if (ierro_ == 3) {
    (*abserr_) = (*abserr_) + correc_;
  }
  if ((*ier_) == 0) {
    (*ier_) = 3;
  }
  if ((*result_) != 0.0e+00 && area_ != 0.0e+00) {
    goto _l160;
  }
  if ((*abserr_) > errsum_) {
    goto _l170;
  }
  if (area_ == 0.0e+00) {
    goto _l190;
  }
  goto _l165;
  _l160:;
  if ((*abserr_) / _abs ((*result_)) > errsum_ / _abs (area_)) {
    goto _l170;
  }
  _l165:;
  if (ksgn_ == -1 && _max (_abs ((*result_)), _abs (area_)) <= defabs_ * 0.1e-1) {
    goto _l190;
  }
  if (0.1e-1 > ((*result_) / area_) || ((*result_) / area_) > 0.1e3 || errsum_ >= _abs (area_)) {
    (*ier_) = 6;
  }
  goto _l190;
  _l170:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l190:;
  if ((*ier_) > 2) {
    (*ier_) = (*ier_) - 1;
  }
  _l200:;
  if ((*integr_) == 2 && (*omega_) < 0.0e+00) {
    (*result_) = -(*result_);
  }
  _l999:;
  __calls[12].calls++;
  return 0;
}

int_4 _dqawo (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ omega_, int_4 _p_ integr_, real_8 _p_ epsabs_, 
real_8 _p_ epsrel_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ leniw_, int_4 
_p_ maxp1_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_8 _p_ work_)
{
  static int_4 limit_, lvl_, l1_, l2_, l3_, l4_, momcom_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*leniw_) < 2 || (*maxp1_) < 1 || (*lenw_) < ((*leniw_) * 2 + (*maxp1_) * 25)) {
    goto _l10;
  }
  limit_ = (*leniw_) / 2;
  l1_ = limit_ + 1;
  l2_ = limit_ + l1_;
  l3_ = limit_ + l2_;
  l4_ = limit_ + l3_;
  (void) _dqawoe (_f, a_, b_, omega_, integr_, epsabs_, epsrel_, &limit_, &_k1, maxp1_, result_, abserr_, neval_, ier_, 
  last_, &work_[0], &work_[l1_ - 1], &work_[l2_ - 1], &work_[l3_ - 1], &iwork_[0], &iwork_[l1_ - 1], &momcom_, &work_[l4_ 
  - 1]);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 0;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_8, _dc_2, ier_, &lvl_);
  }
  __calls[13].calls++;
  return 0;
}

int_4 _dqawse (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfa_, real_8 _p_ beta_, int_4 _p_ integr_, 
real_8 _p_ epsabs_, real_8 _p_ epsrel_, int_4 _p_ limit_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, 
int_4 _p_ ier_, real_8 _p_ alist_, real_8 _p_ blist_, real_8 _p_ rlist_, real_8 _p_ elist_, int_4 _p_ iord_, int_4 _p_ 
last_)
{
  static int_4 iroff1_, iroff2_, k_, maxerr_, nev_, nrmax_;
  static real_8 area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, centre_, epmach_, errbnd_, errmax_, error1_, erro12_, 
  error2_, errsum_, resas1_, resas2_, rg_[25], rh_[25], ri_[25], rj_[25], uflow_;
  int_4 $0_;
  extern real_8 _d1mach ();
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*b_) <= (*a_) || ((*epsabs_) == 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-29)) || (*alfa_) <= -1.0 || 
    (*beta_) <= -1.0 || (*integr_) < 1 || (*integr_) > 4 || (*limit_) < 2) {
    goto _l999;
  }
  (*ier_) = 0;
  (void) _dqmomo (alfa_, beta_, ri_, rj_, rg_, rh_, integr_);
  centre_ = 0.5e+00 * ((*b_) + (*a_));
  (void) _dqc25s (_f, a_, b_, a_, &centre_, alfa_, beta_, ri_, rj_, rg_, rh_, &area1_, &error1_, &resas1_, integr_, 
  &nev_);
  (*neval_) = nev_;
  (void) _dqc25s (_f, a_, b_, &centre_, b_, alfa_, beta_, ri_, rj_, rg_, rh_, &area2_, &error2_, &resas2_, integr_, 
  &nev_);
  (*last_) = 2;
  (*neval_) = (*neval_) + nev_;
  (*result_) = area1_ + area2_;
  (*abserr_) = error1_ + error2_;
  errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs ((*result_)));
  if (error2_ > error1_) {
    goto _l10;
  }
  alist_[0] = (*a_);
  alist_[1] = centre_;
  blist_[0] = centre_;
  blist_[1] = (*b_);
  rlist_[0] = area1_;
  rlist_[1] = area2_;
  elist_[0] = error1_;
  elist_[1] = error2_;
  goto _l20;
  _l10:;
  alist_[0] = centre_;
  alist_[1] = (*a_);
  blist_[0] = (*b_);
  blist_[1] = centre_;
  rlist_[0] = area2_;
  rlist_[1] = area1_;
  elist_[0] = error2_;
  elist_[1] = error1_;
  _l20:;
  iord_[0] = 1;
  iord_[1] = 2;
  if ((*limit_) == 2) {
    (*ier_) = 1;
  }
  if ((*abserr_) <= errbnd_ || (*ier_) == 1) {
    goto _l999;
  }
  errmax_ = elist_[0];
  maxerr_ = 1;
  nrmax_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  iroff1_ = 0;
  iroff2_ = 0;
  for ((*last_) = 3; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    (void) _dqc25s (_f, a_, b_, &a1_, &b1_, alfa_, beta_, ri_, rj_, rg_, rh_, &area1_, &error1_, &resas1_, integr_, &nev_)
    ;
    (*neval_) = (*neval_) + nev_;
    (void) _dqc25s (_f, a_, b_, &a2_, &b2_, alfa_, beta_, ri_, rj_, rg_, rh_, &area2_, &error2_, &resas2_, integr_, &nev_)
    ;
    (*neval_) = (*neval_) + nev_;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if ((*a_) == a1_ || (*b_) == b2_) {
      goto _l30;
    }
    if (resas1_ == error1_ || resas2_ == error2_) {
      goto _l30;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) < 0.1e-4 * _abs (area12_) && erro12_ >= 0.99e+00 * errmax_) {
      iroff1_ = iroff1_ + 1;
    }
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff2_ = iroff2_ + 1;
    }
    _l30:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (errsum_ <= errbnd_) {
      goto _l35;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (iroff1_ >= 6 || iroff2_ >= 20) {
      (*ier_) = 2;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 3;
    }
    _l35:;
    if (error2_ > error1_) {
      goto _l40;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l50;
    _l40:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l50:;
    (void) _dqpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if ((*ier_) != 0 || errsum_ <= errbnd_) {
      goto _l70;
    }
  }
  _l70:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l999:;
  __calls[14].calls++;
  return 0;
}

int_4 _dqaws (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfa_, real_8 _p_ beta_, int_4 _p_ integr_, 
real_8 _p_ epsabs_, real_8 _p_ epsrel_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 
_p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_8 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) < 2 || (*lenw_) < (*limit_) * 4) {
    goto _l10;
  }
  l1_ = (*limit_) + 1;
  l2_ = (*limit_) + l1_;
  l3_ = (*limit_) + l2_;
  (void) _dqawse (_f, a_, b_, alfa_, beta_, integr_, epsabs_, epsrel_, limit_, result_, abserr_, neval_, ier_, &work_[0], 
  &work_[l1_ - 1], &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_9, _dc_2, ier_, &lvl_);
  }
  __calls[15].calls++;
  return 0;
}

int_4 _dqc25c (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ result_, real_8 _p_ abserr_, 
int_4 _p_ krul_, int_4 _p_ neval_)
{
  static int_4 i_, isym_, k_, kp_;
  static real_8 ak22_, amom0_, amom1_, amom2_, cc_, centr_, cheb12_[13], cheb24_[25], fval_[25], hlgth_, p2_, p3_, p4_, 
  resabs_, resasc_, res12_, res24_, u_, x_[11];
  int_4 _data_k_2;
  real_8 $0_, $1_, $2_, $3_;
#define _data_n_2 11
  static real_8 _data_l_2[_data_n_2] = {
    0.9914448613738104e+00,
    0.9659258262890683e+00,
    0.9238795325112868e+00,
    0.8660254037844386e+00,
    0.7933533402912352e+00,
    0.7071067811865475e+00,
    0.6087614290087206e+00,
    0.5e+00,
    0.3826834323650898e+00,
    0.2588190451025208e+00,
    0.1305261922200516e+00
  };
  if (__calls[16].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[0] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[1] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[2] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[3] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[4] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[5] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[6] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[7] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[8] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[9] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    x_[10] = _data_l_2[_data_k_2++];
  }
  cc_ = (0.2e1 * (*c_) - (*b_) - (*a_)) / ((*b_) - (*a_));
  if (_abs (cc_) < 0.11e1) {
    goto _l10;
  }
  (*krul_) = (*krul_) - 1;
  (void) _dqk15w (_f, _dqwgtc, c_, &p2_, &p3_, &p4_, &kp_, a_, b_, result_, abserr_, &resabs_, &resasc_);
  (*neval_) = 15;
  if (resasc_ == (*abserr_)) {
    (*krul_) = (*krul_) + 1;
  }
  goto _l50;
  _l10:;
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  centr_ = 0.5e+00 * ((*b_) + (*a_));
  (*neval_) = 25;
  fval_[0] = 0.5e+00 * _f (($0_ = hlgth_ + centr_, &$0_));
  fval_[12] = _f (&centr_);
  fval_[24] = 0.5e+00 * _f (($1_ = centr_ - hlgth_, &$1_));
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = _f (($2_ = u_ + centr_, &$2_));
    fval_[isym_ - 1] = _f (($3_ = centr_ - u_, &$3_));
  }
  (void) _dqcheb (x_, fval_, cheb12_, cheb24_);
  amom0_ = log (_abs ((0.1e1 - cc_) / (0.1e1 + cc_)));
  amom1_ = 0.2e1 + cc_ * amom0_;
  res12_ = cheb12_[0] * amom0_ + cheb12_[1] * amom1_;
  res24_ = cheb24_[0] * amom0_ + cheb24_[1] * amom1_;
  for (k_ = 3; k_ <= 13; (k_)++) {
    amom2_ = 0.2e1 * cc_ * amom1_ - amom0_;
    ak22_ = (k_ - 2) * (k_ - 2);
    if ((k_ / 2) * 2 == k_) {
      amom2_ = amom2_ - 0.4e1 / (ak22_ - 0.1e1);
    }
    res12_ = res12_ + cheb12_[k_ - 1] * amom2_;
    res24_ = res24_ + cheb24_[k_ - 1] * amom2_;
    amom0_ = amom1_;
    amom1_ = amom2_;
  }
  for (k_ = 14; k_ <= 25; (k_)++) {
    amom2_ = 0.2e1 * cc_ * amom1_ - amom0_;
    ak22_ = (k_ - 2) * (k_ - 2);
    if ((k_ / 2) * 2 == k_) {
      amom2_ = amom2_ - 0.4e1 / (ak22_ - 0.1e1);
    }
    res24_ = res24_ + cheb24_[k_ - 1] * amom2_;
    amom0_ = amom1_;
    amom1_ = amom2_;
  }
  (*result_) = res24_;
  (*abserr_) = _abs (res24_ - res12_);
  _l50:;
  __calls[16].calls++;
  return 0;
}

int_4 _dqc25f (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ omega_, int_4 _p_ integr_, int_4 _p_ nrmom_, 
int_4 _p_ maxp1_, int_4 _p_ ksave_, real_8 _p_ result_, real_8 _p_ abserr_, int_4 _p_ neval_, real_8 _p_ resabs_, 
real_8 _p_ resasc_, int_4 _p_ momcom_, real_8 _p_ chebmo_)
{
  static int_4 i_, iers_, isym_, j_, k_, m_, noequ_, noeq1_;
  static real_8 ac_, an_, an2_, as_, asap_, ass_, centr_, cheb12_[13], cheb24_[25], conc_, cons_, cospar_, d_[25], 
  d1_[25], d2_[25], estc_, ests_, fval_[25], hlgth_, oflow_, parint_, par2_, par22_, p2_, p3_, p4_, resc12_, resc24_, 
  ress12_, ress24_, sinpar_, v_[28], x_[11];
  int_4 _data_k_3, $0_;
  real_8 $1_, $2_, $3_, $4_;
  extern real_8 _d1mach ();
#define _data_n_3 11
  static real_8 _data_l_3[_data_n_3] = {
    0.9914448613738104e+00,
    0.9659258262890683e+00,
    0.9238795325112868e+00,
    0.8660254037844386e+00,
    0.7933533402912352e+00,
    0.7071067811865475e+00,
    0.6087614290087206e+00,
    0.5e+00,
    0.3826834323650898e+00,
    0.2588190451025208e+00,
    0.1305261922200516e+00
  };
  if (__calls[17].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[0] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[1] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[2] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[3] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[4] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[5] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[6] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[7] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[8] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[9] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    x_[10] = _data_l_3[_data_k_3++];
  }
  oflow_ = _d1mach (($0_ = 2, &$0_));
  centr_ = 0.5e+00 * ((*b_) + (*a_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  parint_ = (*omega_) * hlgth_;
  if (_abs (parint_) > 0.2e1) {
    goto _l10;
  }
  (void) _dqk15w (_f, _dqwgtf, omega_, &p2_, &p3_, &p4_, integr_, a_, b_, result_, abserr_, resabs_, resasc_);
  (*neval_) = 15;
  goto _l170;
  _l10:;
  conc_ = hlgth_ * cos (centr_ * (*omega_));
  cons_ = hlgth_ * sin (centr_ * (*omega_));
  (*resasc_) = oflow_;
  (*neval_) = 25;
  if ((*nrmom_) < (*momcom_) || (*ksave_) == 1) {
    goto _l120;
  }
  m_ = (*momcom_) + 1;
  par2_ = parint_ * parint_;
  par22_ = par2_ + 0.2e1;
  sinpar_ = sin (parint_);
  cospar_ = cos (parint_);
  v_[0] = 0.2e1 * sinpar_ / parint_;
  v_[1] = (0.8e1 * cospar_ + (par2_ + par2_ - 0.8e1) * sinpar_ / parint_) / par2_;
  v_[2] = (0.32e2 * (par2_ - 0.12e2) * cospar_ + (0.2e1 * ((par2_ - 0.8e2) * par2_ + 0.192e3) * sinpar_) / parint_) / 
  (par2_ * par2_);
  ac_ = 0.8e1 * cospar_;
  as_ = 0.24e2 * parint_ * sinpar_;
  if (_abs (parint_) > 0.24e2) {
    goto _l30;
  }
  noequ_ = 25;
  noeq1_ = noequ_ - 1;
  an_ = 6.0;
  for (k_ = 1; k_ <= noeq1_; (k_)++) {
    an2_ = an_ * an_;
    d_[k_ - 1] = -0.2e1 * (an2_ - 0.4e1) * (par22_ - an2_ - an2_);
    d2_[k_ - 1] = (an_ - 0.1e1) * (an_ - 0.2e1) * par2_;
    d1_[k_ + 1 - 1] = (an_ + 0.3e1) * (an_ + 0.4e1) * par2_;
    v_[k_ + 3 - 1] = as_ - (an2_ - 0.4e1) * ac_;
    an_ = an_ + 0.2e1;
  }
  an2_ = an_ * an_;
  d_[noequ_ - 1] = -0.2e1 * (an2_ - 0.4e1) * (par22_ - an2_ - an2_);
  v_[noequ_ + 3 - 1] = as_ - (an2_ - 0.4e1) * ac_;
  v_[3] = v_[3] - 0.56e2 * par2_ * v_[2];
  ass_ = parint_ * sinpar_;
  asap_ = (((((0.21e3 * par2_ - 0.1e1) * cospar_ - (0.105e3 * par2_ - 0.63e2) * ass_) / an2_ - (0.1e1 - 0.15e2 * par2_) * 
  cospar_ + 0.15e2 * ass_) / an2_ - cospar_ + 0.3e1 * ass_) / an2_ - cospar_) / an2_;
  v_[noequ_ + 3 - 1] = v_[noequ_ + 3 - 1] - 0.2e1 * asap_ * par2_ * (an_ - 0.1e1) * (an_ - 0.2e1);
  (void) _dgtsl (&noequ_, d1_, d_, d2_, &v_[3], &iers_);
  goto _l50;
  _l30:;
  an_ = 4.0;
  for (i_ = 4; i_ <= 13; (i_)++) {
    an2_ = an_ * an_;
    v_[i_ - 1] = ((an2_ - 0.4e1) * (0.2e1 * (par22_ - an2_ - an2_) * v_[i_ - 1 - 1] - ac_) + as_ - par2_ * (an_ + 0.1e1) * 
    (an_ + 0.2e1) * v_[i_ - 2 - 1]) / (par2_ * (an_ - 0.1e1) * (an_ - 0.2e1));
    an_ = an_ + 0.2e1;
  }
  _l50:;
  for (j_ = 1; j_ <= 13; (j_)++) {
    chebmo_[m_ - 1 + ((*maxp1_)) * ((2 * j_ - 1 - 1))] = v_[j_ - 1];
  }
  v_[0] = 0.2e1 * (sinpar_ - parint_ * cospar_) / par2_;
  v_[1] = (0.18e2 - 0.48e2 / par2_) * sinpar_ / par2_ + (-0.2e1 + 0.48e2 / par2_) * cospar_ / parint_;
  ac_ = -0.24e2 * parint_ * cospar_;
  as_ = -0.8e1 * sinpar_;
  if (_abs (parint_) > 0.24e2) {
    goto _l80;
  }
  an_ = 5.0;
  for (k_ = 1; k_ <= noeq1_; (k_)++) {
    an2_ = an_ * an_;
    d_[k_ - 1] = -0.2e1 * (an2_ - 0.4e1) * (par22_ - an2_ - an2_);
    d2_[k_ - 1] = (an_ - 0.1e1) * (an_ - 0.2e1) * par2_;
    d1_[k_ + 1 - 1] = (an_ + 0.3e1) * (an_ + 0.4e1) * par2_;
    v_[k_ + 2 - 1] = ac_ + (an2_ - 0.4e1) * as_;
    an_ = an_ + 0.2e1;
  }
  an2_ = an_ * an_;
  d_[noequ_ - 1] = -0.2e1 * (an2_ - 0.4e1) * (par22_ - an2_ - an2_);
  v_[noequ_ + 2 - 1] = ac_ + (an2_ - 0.4e1) * as_;
  v_[2] = v_[2] - 0.42e2 * par2_ * v_[1];
  ass_ = parint_ * cospar_;
  asap_ = (((((0.105e3 * par2_ - 0.63e2) * ass_ + (0.21e3 * par2_ - 0.1e1) * sinpar_) / an2_ + (0.15e2 * par2_ - 0.1e1) * 
  sinpar_ - 0.15e2 * ass_) / an2_ - 0.3e1 * ass_ - sinpar_) / an2_ - sinpar_) / an2_;
  v_[noequ_ + 2 - 1] = v_[noequ_ + 2 - 1] - 0.2e1 * asap_ * par2_ * (an_ - 0.1e1) * (an_ - 0.2e1);
  (void) _dgtsl (&noequ_, d1_, d_, d2_, &v_[2], &iers_);
  goto _l100;
  _l80:;
  an_ = 3.0;
  for (i_ = 3; i_ <= 12; (i_)++) {
    an2_ = an_ * an_;
    v_[i_ - 1] = ((an2_ - 0.4e1) * (0.2e1 * (par22_ - an2_ - an2_) * v_[i_ - 1 - 1] + as_) + ac_ - par2_ * (an_ + 0.1e1) * 
    (an_ + 0.2e1) * v_[i_ - 2 - 1]) / (par2_ * (an_ - 0.1e1) * (an_ - 0.2e1));
    an_ = an_ + 0.2e1;
  }
  _l100:;
  for (j_ = 1; j_ <= 12; (j_)++) {
    chebmo_[m_ - 1 + ((*maxp1_)) * ((2 * j_ - 1))] = v_[j_ - 1];
  }
  _l120:;
  if ((*nrmom_) < (*momcom_)) {
    m_ = (*nrmom_) + 1;
  }
  if ((*momcom_) < ((*maxp1_) - 1) && (*nrmom_) >= (*momcom_)) {
    (*momcom_) = (*momcom_) + 1;
  }
  fval_[0] = 0.5e+00 * _f (($1_ = centr_ + hlgth_, &$1_));
  fval_[12] = _f (&centr_);
  fval_[24] = 0.5e+00 * _f (($2_ = centr_ - hlgth_, &$2_));
  for (i_ = 2; i_ <= 12; (i_)++) {
    isym_ = 26 - i_;
    fval_[i_ - 1] = _f (($3_ = hlgth_ * x_[i_ - 1 - 1] + centr_, &$3_));
    fval_[isym_ - 1] = _f (($4_ = centr_ - hlgth_ * x_[i_ - 1 - 1], &$4_));
  }
  (void) _dqcheb (x_, fval_, cheb12_, cheb24_);
  resc12_ = cheb12_[12] * chebmo_[m_ - 1 + ((*maxp1_)) * ((12))];
  ress12_ = 0.0;
  k_ = 11;
  for (j_ = 1; j_ <= 6; (j_)++) {
    resc12_ = resc12_ + cheb12_[k_ - 1] * chebmo_[m_ - 1 + ((*maxp1_)) * ((k_ - 1))];
    ress12_ = ress12_ + cheb12_[k_ + 1 - 1] * chebmo_[m_ - 1 + ((*maxp1_)) * ((k_ + 1 - 1))];
    k_ = k_ - 2;
  }
  resc24_ = cheb24_[24] * chebmo_[m_ - 1 + ((*maxp1_)) * ((24))];
  ress24_ = 0.0;
  (*resabs_) = _abs (cheb24_[24]);
  k_ = 23;
  for (j_ = 1; j_ <= 12; (j_)++) {
    resc24_ = resc24_ + cheb24_[k_ - 1] * chebmo_[m_ - 1 + ((*maxp1_)) * ((k_ - 1))];
    ress24_ = ress24_ + cheb24_[k_ + 1 - 1] * chebmo_[m_ - 1 + ((*maxp1_)) * ((k_ + 1 - 1))];
    (*resabs_) = _abs (cheb24_[k_ - 1]) + _abs (cheb24_[k_ + 1 - 1]);
    k_ = k_ - 2;
  }
  estc_ = _abs (resc24_ - resc12_);
  ests_ = _abs (ress24_ - ress12_);
  (*resabs_) = (*resabs_) * _abs (hlgth_);
  if ((*integr_) == 2) {
    goto _l160;
  }
  (*result_) = conc_ * resc24_ - cons_ * ress24_;
  (*abserr_) = _abs (conc_ * estc_) + _abs (cons_ * ests_);
  goto _l170;
  _l160:;
  (*result_) = conc_ * ress24_ + cons_ * resc24_;
  (*abserr_) = _abs (conc_ * ests_) + _abs (cons_ * estc_);
  _l170:;
  __calls[17].calls++;
  return 0;
}

int_4 _dqc25s (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ bl_, real_8 _p_ br_, real_8 _p_ alfa_, real_8 
_p_ beta_, real_8 _p_ ri_, real_8 _p_ rj_, real_8 _p_ rg_, real_8 _p_ rh_, real_8 _p_ result_, real_8 _p_ abserr_, 
real_8 _p_ resasc_, int_4 _p_ integr_, int_4 _p_ nev_)
{
  static int_4 i_, isym_;
  static real_8 centr_, cheb12_[13], cheb24_[25], dc_, factor_, fix_, fval_[25], hlgth_, resabs_, res12_, res24_, u_, 
  x_[11];
  int_4 _data_k_4;
  real_8 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
#define _data_n_4 11
  static real_8 _data_l_4[_data_n_4] = {
    0.9914448613738104e+00,
    0.9659258262890683e+00,
    0.9238795325112868e+00,
    0.8660254037844386e+00,
    0.7933533402912352e+00,
    0.7071067811865475e+00,
    0.6087614290087206e+00,
    0.5e+00,
    0.3826834323650898e+00,
    0.2588190451025208e+00,
    0.1305261922200516e+00
  };
  if (__calls[18].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[0] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[1] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[2] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[3] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[4] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[5] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[6] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[7] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[8] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[9] = _data_l_4[_data_k_4++];
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    x_[10] = _data_l_4[_data_k_4++];
  }
  (*nev_) = 25;
  if ((*bl_) == (*a_) && ((*alfa_) != 0.0e+00 || (*integr_) == 2 || (*integr_) == 4)) {
    goto _l10;
  }
  if ((*br_) == (*b_) && ((*beta_) != 0.0e+00 || (*integr_) == 3 || (*integr_) == 4)) {
    goto _l140;
  }
  (void) _dqk15w (_f, _dqwgts, a_, b_, alfa_, beta_, integr_, bl_, br_, result_, abserr_, &resabs_, resasc_);
  (*nev_) = 15;
  goto _l270;
  _l10:;
  hlgth_ = 0.5e+00 * ((*br_) - (*bl_));
  centr_ = 0.5e+00 * ((*br_) + (*bl_));
  fix_ = (*b_) - centr_;
  fval_[0] = 0.5e+00 * _f (($0_ = hlgth_ + centr_, &$0_)) * pow ((fix_ - hlgth_), (*beta_));
  fval_[12] = _f (&centr_) * (pow (fix_, (*beta_)));
  fval_[24] = 0.5e+00 * _f (($1_ = centr_ - hlgth_, &$1_)) * pow ((fix_ + hlgth_), (*beta_));
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = _f (($2_ = u_ + centr_, &$2_)) * pow ((fix_ - u_), (*beta_));
    fval_[isym_ - 1] = _f (($3_ = centr_ - u_, &$3_)) * pow ((fix_ + u_), (*beta_));
  }
  factor_ = pow (hlgth_, ((*alfa_) + 0.1e1));
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  res12_ = 0.0;
  res24_ = 0.0;
  if ((*integr_) > 2) {
    goto _l70;
  }
  (void) _dqcheb (x_, fval_, cheb12_, cheb24_);
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * ri_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * ri_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * ri_[i_ - 1];
  }
  if ((*integr_) == 1) {
    goto _l130;
  }
  dc_ = log ((*br_) - (*bl_));
  (*result_) = res24_ * dc_;
  (*abserr_) = _abs ((res24_ - res12_) * dc_);
  res12_ = 0.0;
  res24_ = 0.0;
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rg_[i_ - 1];
    res24_ = res12_ + cheb24_[i_ - 1] * rg_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rg_[i_ - 1];
  }
  goto _l130;
  _l70:;
  fval_[0] = fval_[0] * log (fix_ - hlgth_);
  fval_[12] = fval_[12] * log (fix_);
  fval_[24] = fval_[24] * log (fix_ + hlgth_);
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = fval_[i_ - 1] * log (fix_ - u_);
    fval_[isym_ - 1] = fval_[isym_ - 1] * log (fix_ + u_);
  }
  (void) _dqcheb (x_, fval_, cheb12_, cheb24_);
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * ri_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * ri_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * ri_[i_ - 1];
  }
  if ((*integr_) == 3) {
    goto _l130;
  }
  dc_ = log ((*br_) - (*bl_));
  (*result_) = res24_ * dc_;
  (*abserr_) = _abs ((res24_ - res12_) * dc_);
  res12_ = 0.0;
  res24_ = 0.0;
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rg_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rg_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rg_[i_ - 1];
  }
  _l130:;
  (*result_) = ((*result_) + res24_) * factor_;
  (*abserr_) = ((*abserr_) + _abs (res24_ - res12_)) * factor_;
  goto _l270;
  _l140:;
  hlgth_ = 0.5e+00 * ((*br_) - (*bl_));
  centr_ = 0.5e+00 * ((*br_) + (*bl_));
  fix_ = centr_ - (*a_);
  fval_[0] = 0.5e+00 * _f (($4_ = hlgth_ + centr_, &$4_)) * pow ((fix_ + hlgth_), (*alfa_));
  fval_[12] = _f (&centr_) * (pow (fix_, (*alfa_)));
  fval_[24] = 0.5e+00 * _f (($5_ = centr_ - hlgth_, &$5_)) * pow ((fix_ - hlgth_), (*alfa_));
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = _f (($6_ = u_ + centr_, &$6_)) * pow ((fix_ + u_), (*alfa_));
    fval_[isym_ - 1] = _f (($7_ = centr_ - u_, &$7_)) * pow ((fix_ - u_), (*alfa_));
  }
  factor_ = pow (hlgth_, ((*beta_) + 0.1e1));
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  res12_ = 0.0;
  res24_ = 0.0;
  if ((*integr_) == 2 || (*integr_) == 4) {
    goto _l200;
  }
  (void) _dqcheb (x_, fval_, cheb12_, cheb24_);
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rj_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rj_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rj_[i_ - 1];
  }
  if ((*integr_) == 1) {
    goto _l260;
  }
  dc_ = log ((*br_) - (*bl_));
  (*result_) = res24_ * dc_;
  (*abserr_) = _abs ((res24_ - res12_) * dc_);
  res12_ = 0.0;
  res24_ = 0.0;
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rh_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rh_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rh_[i_ - 1];
  }
  goto _l260;
  _l200:;
  fval_[0] = fval_[0] * log (fix_ + hlgth_);
  fval_[12] = fval_[12] * log (fix_);
  fval_[24] = fval_[24] * log (fix_ - hlgth_);
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = fval_[i_ - 1] * log (u_ + fix_);
    fval_[isym_ - 1] = fval_[isym_ - 1] * log (fix_ - u_);
  }
  (void) _dqcheb (x_, fval_, cheb12_, cheb24_);
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rj_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rj_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rj_[i_ - 1];
  }
  if ((*integr_) == 2) {
    goto _l260;
  }
  dc_ = log ((*br_) - (*bl_));
  (*result_) = res24_ * dc_;
  (*abserr_) = _abs ((res24_ - res12_) * dc_);
  res12_ = 0.0;
  res24_ = 0.0;
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rh_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rh_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rh_[i_ - 1];
  }
  _l260:;
  (*result_) = ((*result_) + res24_) * factor_;
  (*abserr_) = ((*abserr_) + _abs (res24_ - res12_)) * factor_;
  _l270:;
  __calls[18].calls++;
  return 0;
}

int_4 _dqcheb (real_8 _p_ x_, real_8 _p_ fval_, real_8 _p_ cheb12_, real_8 _p_ cheb24_)
{
  static int_4 i_, j_;
  static real_8 alam_, alam1_, alam2_, part1_, part2_, part3_, v_[12];
  for (i_ = 1; i_ <= 12; (i_)++) {
    j_ = 26 - i_;
    v_[i_ - 1] = fval_[i_ - 1] - fval_[j_ - 1];
    fval_[i_ - 1] = fval_[i_ - 1] + fval_[j_ - 1];
  }
  alam1_ = v_[0] - v_[8];
  alam2_ = x_[5] * (v_[2] - v_[6] - v_[10]);
  cheb12_[3] = alam1_ + alam2_;
  cheb12_[9] = alam1_ - alam2_;
  alam1_ = v_[1] - v_[7] - v_[9];
  alam2_ = v_[3] - v_[5] - v_[11];
  alam_ = x_[2] * alam1_ + x_[8] * alam2_;
  cheb24_[3] = cheb12_[3] + alam_;
  cheb24_[21] = cheb12_[3] - alam_;
  alam_ = x_[8] * alam1_ - x_[2] * alam2_;
  cheb24_[9] = cheb12_[9] + alam_;
  cheb24_[15] = cheb12_[9] - alam_;
  part1_ = x_[3] * v_[4];
  part2_ = x_[7] * v_[8];
  part3_ = x_[5] * v_[6];
  alam1_ = v_[0] + part1_ + part2_;
  alam2_ = x_[1] * v_[2] + part3_ + x_[9] * v_[10];
  cheb12_[1] = alam1_ + alam2_;
  cheb12_[11] = alam1_ - alam2_;
  alam_ = x_[0] * v_[1] + x_[2] * v_[3] + x_[4] * v_[5] + x_[6] * v_[7] + x_[8] * v_[9] + x_[10] * v_[11];
  cheb24_[1] = cheb12_[1] + alam_;
  cheb24_[23] = cheb12_[1] - alam_;
  alam_ = x_[10] * v_[1] - x_[8] * v_[3] + x_[6] * v_[5] - x_[4] * v_[7] + x_[2] * v_[9] - x_[0] * v_[11];
  cheb24_[11] = cheb12_[11] + alam_;
  cheb24_[13] = cheb12_[11] - alam_;
  alam1_ = v_[0] - part1_ + part2_;
  alam2_ = x_[9] * v_[2] - part3_ + x_[1] * v_[10];
  cheb12_[5] = alam1_ + alam2_;
  cheb12_[7] = alam1_ - alam2_;
  alam_ = x_[4] * v_[1] - x_[8] * v_[3] - x_[0] * v_[5] - x_[10] * v_[7] + x_[2] * v_[9] + x_[6] * v_[11];
  cheb24_[5] = cheb12_[5] + alam_;
  cheb24_[19] = cheb12_[5] - alam_;
  alam_ = x_[6] * v_[1] - x_[2] * v_[3] - x_[10] * v_[5] + x_[0] * v_[7] - x_[8] * v_[9] - x_[4] * v_[11];
  cheb24_[7] = cheb12_[7] + alam_;
  cheb24_[17] = cheb12_[7] - alam_;
  for (i_ = 1; i_ <= 6; (i_)++) {
    j_ = 14 - i_;
    v_[i_ - 1] = fval_[i_ - 1] - fval_[j_ - 1];
    fval_[i_ - 1] = fval_[i_ - 1] + fval_[j_ - 1];
  }
  alam1_ = v_[0] + x_[7] * v_[4];
  alam2_ = x_[3] * v_[2];
  cheb12_[2] = alam1_ + alam2_;
  cheb12_[10] = alam1_ - alam2_;
  cheb12_[6] = v_[0] - v_[4];
  alam_ = x_[1] * v_[1] + x_[5] * v_[3] + x_[9] * v_[5];
  cheb24_[2] = cheb12_[2] + alam_;
  cheb24_[22] = cheb12_[2] - alam_;
  alam_ = x_[5] * (v_[1] - v_[3] - v_[5]);
  cheb24_[6] = cheb12_[6] + alam_;
  cheb24_[18] = cheb12_[6] - alam_;
  alam_ = x_[9] * v_[1] - x_[5] * v_[3] + x_[1] * v_[5];
  cheb24_[10] = cheb12_[10] + alam_;
  cheb24_[14] = cheb12_[10] - alam_;
  for (i_ = 1; i_ <= 3; (i_)++) {
    j_ = 8 - i_;
    v_[i_ - 1] = fval_[i_ - 1] - fval_[j_ - 1];
    fval_[i_ - 1] = fval_[i_ - 1] + fval_[j_ - 1];
  }
  cheb12_[4] = v_[0] + x_[7] * v_[2];
  cheb12_[8] = fval_[0] - x_[7] * fval_[2];
  alam_ = x_[3] * v_[1];
  cheb24_[4] = cheb12_[4] + alam_;
  cheb24_[20] = cheb12_[4] - alam_;
  alam_ = x_[7] * fval_[1] - fval_[3];
  cheb24_[8] = cheb12_[8] + alam_;
  cheb24_[16] = cheb12_[8] - alam_;
  cheb12_[0] = fval_[0] + fval_[2];
  alam_ = fval_[1] + fval_[3];
  cheb24_[0] = cheb12_[0] + alam_;
  cheb24_[24] = cheb12_[0] - alam_;
  cheb12_[12] = v_[0] - v_[2];
  cheb24_[12] = cheb12_[12];
  alam_ = 1.6666666666666667e-1;
  for (i_ = 2; i_ <= 12; (i_)++) {
    cheb12_[i_ - 1] = cheb12_[i_ - 1] * alam_;
  }
  alam_ = 0.5e+00 * alam_;
  cheb12_[0] = cheb12_[0] * alam_;
  cheb12_[12] = cheb12_[12] * alam_;
  for (i_ = 2; i_ <= 24; (i_)++) {
    cheb24_[i_ - 1] = cheb24_[i_ - 1] * alam_;
  }
  cheb24_[0] = 0.5e+00 * alam_ * cheb24_[0];
  cheb24_[24] = 0.5e+00 * alam_ * cheb24_[24];
  __calls[19].calls++;
  return 0;
}

int_4 _dqelg (int_4 _p_ n_, real_8 _p_ epstab_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ res3la_, int_4 _p_ 
nres_)
{
  static int_4 i_, ib_, ib2_, ie_, indx_, k1_, k2_, k3_, limexp_, newelm_, num_;
  static real_8 dabs_, delta1_, delta2_, delta3_, dmax1_, epmach_, epsinf_, error_, err1_, err2_, err3_, e0_, e1_, e1abs_
  , e2_, e3_, oflow_, res_, ss_, tol1_, tol2_, tol3_;
  int_4 $0_, $1_;
  extern real_8 _d1mach ();
  epmach_ = _d1mach (($0_ = 4, &$0_));
  oflow_ = _d1mach (($1_ = 2, &$1_));
  (*nres_) = (*nres_) + 1;
  (*abserr_) = oflow_;
  (*result_) = epstab_[(*n_) - 1];
  if ((*n_) < 3) {
    goto _l100;
  }
  limexp_ = 50;
  epstab_[(*n_) + 2 - 1] = epstab_[(*n_) - 1];
  newelm_ = ((*n_) - 1) / 2;
  epstab_[(*n_) - 1] = oflow_;
  num_ = (*n_);
  k1_ = (*n_);
  for (i_ = 1; i_ <= newelm_; (i_)++) {
    k2_ = k1_ - 1;
    k3_ = k1_ - 2;
    res_ = epstab_[k1_ + 2 - 1];
    e0_ = epstab_[k3_ - 1];
    e1_ = epstab_[k2_ - 1];
    e2_ = res_;
    e1abs_ = _abs (e1_);
    delta2_ = e2_ - e1_;
    err2_ = _abs (delta2_);
    tol2_ = _max (_abs (e2_), e1abs_) * epmach_;
    delta3_ = e1_ - e0_;
    err3_ = _abs (delta3_);
    tol3_ = _max (e1abs_, _abs (e0_)) * epmach_;
    if (err2_ > tol2_ || err3_ > tol3_) {
      goto _l10;
    }
    (*result_) = res_;
    (*abserr_) = err2_ + err3_;
    goto _l100;
    _l10:;
    e3_ = epstab_[k1_ - 1];
    epstab_[k1_ - 1] = e1_;
    delta1_ = e1_ - e3_;
    err1_ = _abs (delta1_);
    tol1_ = _max (e1abs_, _abs (e3_)) * epmach_;
    if (err1_ <= tol1_ || err2_ <= tol2_ || err3_ <= tol3_) {
      goto _l20;
    }
    ss_ = 0.1e1 / delta1_ + 0.1e1 / delta2_ - 0.1e1 / delta3_;
    epsinf_ = _abs (ss_ * e1_);
    if (epsinf_ > 0.1e-3) {
      goto _l30;
    }
    _l20:;
    (*n_) = i_ + i_ - 1;
    goto _l50;
    _l30:;
    res_ = e1_ + 0.1e1 / ss_;
    epstab_[k1_ - 1] = res_;
    k1_ = k1_ - 2;
    error_ = err2_ + _abs (res_ - e2_) + err3_;
    if (error_ > (*abserr_)) {
      goto _l40;
    }
    (*abserr_) = error_;
    (*result_) = res_;
    _l40:;
  }
  _l50:;
  if ((*n_) == limexp_) {
    (*n_) = 2 * (limexp_ / 2) - 1;
  }
  ib_ = 1;
  if ((num_ / 2) * 2 == num_) {
    ib_ = 2;
  }
  ie_ = newelm_ + 1;
  for (i_ = 1; i_ <= ie_; (i_)++) {
    ib2_ = ib_ + 2;
    epstab_[ib_ - 1] = epstab_[ib2_ - 1];
    ib_ = ib2_;
  }
  if (num_ == (*n_)) {
    goto _l80;
  }
  indx_ = num_ - (*n_) + 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    epstab_[i_ - 1] = epstab_[indx_ - 1];
    indx_ = indx_ + 1;
  }
  _l80:;
  if ((*nres_) >= 4) {
    goto _l90;
  }
  res3la_[(*nres_) - 1] = (*result_);
  (*abserr_) = oflow_;
  goto _l100;
  _l90:;
  (*abserr_) = _abs ((*result_) - res3la_[2]) + _abs ((*result_) - res3la_[1]) + _abs ((*result_) - res3la_[0]);
  res3la_[0] = res3la_[1];
  res3la_[1] = res3la_[2];
  res3la_[2] = (*result_);
  _l100:;
  (*abserr_) = _max ((*abserr_), 0.5e1 * epmach_ * _abs ((*result_)));
  __calls[20].calls++;
  return 0;
}

int_4 _dqk15 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ resabs_, 
real_8 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_8 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[7], fv2_[7], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[4], wgk_[8], xgk_[8];
  int_4 _data_k_5, _data_k_6, _data_k_7, _data_k_8, _data_k_9, _data_k_10, _data_k_11, _data_k_12, _data_k_13, _data_k_14
  , _data_k_15, _data_k_16, _data_k_17, _data_k_18, _data_k_19, _data_k_20, _data_k_21, _data_k_22, _data_k_23, 
  _data_k_24, $0_;
  real_8 $1_, $2_, $3_, $4_;
  extern real_8 _d1mach ();
#define _data_n_5 1
  static real_8 _data_l_5[_data_n_5] = {
    0.129484966168869693270611432679082e0
  };
#define _data_n_6 1
  static real_8 _data_l_6[_data_n_6] = {
    0.27970539148927666790146777142378e0
  };
#define _data_n_7 1
  static real_8 _data_l_7[_data_n_7] = {
    0.381830050505118944950369775488975e0
  };
#define _data_n_8 1
  static real_8 _data_l_8[_data_n_8] = {
    0.417959183673469387755102040816327e0
  };
#define _data_n_9 1
  static real_8 _data_l_9[_data_n_9] = {
    0.991455371120812639206854697526329e0
  };
#define _data_n_10 1
  static real_8 _data_l_10[_data_n_10] = {
    0.949107912342758524526189684047851e0
  };
#define _data_n_11 1
  static real_8 _data_l_11[_data_n_11] = {
    0.864864423359769072789712788640926e0
  };
#define _data_n_12 1
  static real_8 _data_l_12[_data_n_12] = {
    0.741531185599394439863864773280788e0
  };
#define _data_n_13 1
  static real_8 _data_l_13[_data_n_13] = {
    0.58608723546769113029414483825873e0
  };
#define _data_n_14 1
  static real_8 _data_l_14[_data_n_14] = {
    0.405845151377397166906606412076961e0
  };
#define _data_n_15 1
  static real_8 _data_l_15[_data_n_15] = {
    0.207784955007898467600689403773245e0
  };
#define _data_n_16 1
  static real_8 _data_l_16[_data_n_16] = {
    0.0e0
  };
#define _data_n_17 1
  static real_8 _data_l_17[_data_n_17] = {
    0.02293532201052922496373200805897e0
  };
#define _data_n_18 1
  static real_8 _data_l_18[_data_n_18] = {
    0.063092092629978553290700663189204e0
  };
#define _data_n_19 1
  static real_8 _data_l_19[_data_n_19] = {
    0.104790010322250183839876322541518e0
  };
#define _data_n_20 1
  static real_8 _data_l_20[_data_n_20] = {
    0.140653259715525918745189590510238e0
  };
#define _data_n_21 1
  static real_8 _data_l_21[_data_n_21] = {
    0.16900472663926790282658342659855e0
  };
#define _data_n_22 1
  static real_8 _data_l_22[_data_n_22] = {
    0.190350578064785409913256402421014e0
  };
#define _data_n_23 1
  static real_8 _data_l_23[_data_n_23] = {
    0.204432940075298892414161999234649e0
  };
#define _data_n_24 1
  static real_8 _data_l_24[_data_n_24] = {
    0.209482141084727828012999174891714e0
  };
  if (__calls[21].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    wg_[0] = _data_l_5[_data_k_5++];
  }
  if (__calls[21].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    wg_[1] = _data_l_6[_data_k_6++];
  }
  if (__calls[21].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    wg_[2] = _data_l_7[_data_k_7++];
  }
  if (__calls[21].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    wg_[3] = _data_l_8[_data_k_8++];
  }
  if (__calls[21].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    xgk_[0] = _data_l_9[_data_k_9++];
  }
  if (__calls[21].calls == 0) {
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    xgk_[1] = _data_l_10[_data_k_10++];
  }
  if (__calls[21].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    xgk_[2] = _data_l_11[_data_k_11++];
  }
  if (__calls[21].calls == 0) {
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    xgk_[3] = _data_l_12[_data_k_12++];
  }
  if (__calls[21].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    xgk_[4] = _data_l_13[_data_k_13++];
  }
  if (__calls[21].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    xgk_[5] = _data_l_14[_data_k_14++];
  }
  if (__calls[21].calls == 0) {
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    xgk_[6] = _data_l_15[_data_k_15++];
  }
  if (__calls[21].calls == 0) {
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    xgk_[7] = _data_l_16[_data_k_16++];
  }
  if (__calls[21].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    wgk_[0] = _data_l_17[_data_k_17++];
  }
  if (__calls[21].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    wgk_[1] = _data_l_18[_data_k_18++];
  }
  if (__calls[21].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    wgk_[2] = _data_l_19[_data_k_19++];
  }
  if (__calls[21].calls == 0) {
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    wgk_[3] = _data_l_20[_data_k_20++];
  }
  if (__calls[21].calls == 0) {
    _data_k_21 = 0;
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    wgk_[4] = _data_l_21[_data_k_21++];
  }
  if (__calls[21].calls == 0) {
    _data_k_22 = 0;
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    wgk_[5] = _data_l_22[_data_k_22++];
  }
  if (__calls[21].calls == 0) {
    _data_k_23 = 0;
    if (_data_k_23 >= _data_n_23) {
      _data_k_23 = 0;
    }
    wgk_[6] = _data_l_23[_data_k_23++];
  }
  if (__calls[21].calls == 0) {
    _data_k_24 = 0;
    if (_data_k_24 >= _data_n_24) {
      _data_k_24 = 0;
    }
    wgk_[7] = _data_l_24[_data_k_24++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  fc_ = _f (&centr_);
  resg_ = fc_ * wg_[3];
  resk_ = fc_ * wgk_[7];
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 3; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 4; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[7] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, pow ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[21].calls++;
  return 0;
}

int_4 _dqk15i (real_8 (*_f)(), real_8 _p_ boun_, int_4 _p_ inf_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, 
real_8 _p_ abserr_, real_8 _p_ resabs_, real_8 _p_ resasc_)
{
  static int_4 j_;
  static real_8 absc_, absc1_, absc2_, centr_, dinf_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[7], fv2_[7], hlgth_, 
  resg_, resk_, reskh_, tabsc1_, tabsc2_, uflow_, wg_[8], wgk_[8], xgk_[8];
  int_4 _data_k_25, _data_k_26, _data_k_27, $0_;
  real_8 $1_, $2_, $3_;
  extern real_8 _d1mach ();
#define _data_n_25 8
  static real_8 _data_l_25[_data_n_25] = {
    0.9914553711208126e+00,
    0.9491079123427585e+00,
    0.8648644233597691e+00,
    0.7415311855993944e+00,
    0.5860872354676911e+00,
    0.4058451513773972e+00,
    0.2077849550078985e+00,
    0.0e+00
  };
#define _data_n_26 8
  static real_8 _data_l_26[_data_n_26] = {
    0.2293532201052922e-1,
    0.6309209262997855e-1,
    0.1047900103222502e+00,
    0.1406532597155259e+00,
    0.1690047266392679e+00,
    0.1903505780647854e+00,
    0.2044329400752989e+00,
    0.2094821410847278e+00
  };
#define _data_n_27 8
  static real_8 _data_l_27[_data_n_27] = {
    0.0e+00,
    0.1294849661688697e+00,
    0.0e+00,
    0.2797053914892767e+00,
    0.0e+00,
    0.3818300505051189e+00,
    0.0e+00,
    0.4179591836734694e+00
  };
  if (__calls[22].calls == 0) {
    _data_k_25 = 0;
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    xgk_[0] = _data_l_25[_data_k_25++];
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    xgk_[1] = _data_l_25[_data_k_25++];
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    xgk_[2] = _data_l_25[_data_k_25++];
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    xgk_[3] = _data_l_25[_data_k_25++];
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    xgk_[4] = _data_l_25[_data_k_25++];
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    xgk_[5] = _data_l_25[_data_k_25++];
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    xgk_[6] = _data_l_25[_data_k_25++];
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    xgk_[7] = _data_l_25[_data_k_25++];
  }
  if (__calls[22].calls == 0) {
    _data_k_26 = 0;
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    wgk_[0] = _data_l_26[_data_k_26++];
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    wgk_[1] = _data_l_26[_data_k_26++];
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    wgk_[2] = _data_l_26[_data_k_26++];
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    wgk_[3] = _data_l_26[_data_k_26++];
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    wgk_[4] = _data_l_26[_data_k_26++];
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    wgk_[5] = _data_l_26[_data_k_26++];
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    wgk_[6] = _data_l_26[_data_k_26++];
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    wgk_[7] = _data_l_26[_data_k_26++];
  }
  if (__calls[22].calls == 0) {
    _data_k_27 = 0;
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    wg_[0] = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    wg_[1] = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    wg_[2] = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    wg_[3] = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    wg_[4] = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    wg_[5] = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    wg_[6] = _data_l_27[_data_k_27++];
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    wg_[7] = _data_l_27[_data_k_27++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  dinf_ = _min (1, (*inf_));
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  tabsc1_ = (*boun_) + dinf_ * (0.1e1 - centr_) / centr_;
  fval1_ = _f (&tabsc1_);
  if ((*inf_) == 2) {
    fval1_ = fval1_ + _f (($1_ = -tabsc1_, &$1_));
  }
  fc_ = (fval1_ / centr_) / centr_;
  resg_ = wg_[7] * fc_;
  resk_ = wgk_[7] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    absc_ = hlgth_ * xgk_[j_ - 1];
    absc1_ = centr_ - absc_;
    absc2_ = centr_ + absc_;
    tabsc1_ = (*boun_) + dinf_ * (0.1e1 - absc1_) / absc1_;
    tabsc2_ = (*boun_) + dinf_ * (0.1e1 - absc2_) / absc2_;
    fval1_ = _f (&tabsc1_);
    fval2_ = _f (&tabsc2_);
    if ((*inf_) == 2) {
      fval1_ = fval1_ + _f (($2_ = -tabsc1_, &$2_));
    }
    if ((*inf_) == 2) {
      fval2_ = fval2_ + _f (($3_ = -tabsc2_, &$3_));
    }
    fval1_ = (fval1_ / absc1_) / absc1_;
    fval2_ = (fval2_ / absc2_) / absc2_;
    fv1_[j_ - 1] = fval1_;
    fv2_[j_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[j_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[j_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[7] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resasc_) = (*resasc_) * hlgth_;
  (*resabs_) = (*resabs_) * hlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e0) {
    (*abserr_) = (*resasc_) * _min (1.0, pow ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[22].calls++;
  return 0;
}

int_4 _dqk15w (real_8 (*_f)(), real_8 (*_w)(), real_8 _p_ p1_, real_8 _p_ p2_, real_8 _p_ p3_, real_8 _p_ p4_, int_4 
_p_ kp_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ resabs_, real_8 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_8 absc_, absc1_, absc2_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[7], fv2_[7], hlgth_, 
  resg_, resk_, reskh_, uflow_, wg_[4], wgk_[8], xgk_[8];
  int_4 _data_k_28, _data_k_29, _data_k_30, $0_;
  extern real_8 _d1mach ();
#define _data_n_28 8
  static real_8 _data_l_28[_data_n_28] = {
    0.9914553711208126e+00,
    0.9491079123427585e+00,
    0.8648644233597691e+00,
    0.7415311855993944e+00,
    0.5860872354676911e+00,
    0.4058451513773972e+00,
    0.2077849550078985e+00,
    0.0e+00
  };
#define _data_n_29 8
  static real_8 _data_l_29[_data_n_29] = {
    0.2293532201052922e-1,
    0.6309209262997855e-1,
    0.1047900103222502e+00,
    0.1406532597155259e+00,
    0.1690047266392679e+00,
    0.1903505780647854e+00,
    0.2044329400752989e+00,
    0.2094821410847278e+00
  };
#define _data_n_30 4
  static real_8 _data_l_30[_data_n_30] = {
    0.1294849661688697e+00,
    0.2797053914892767e+00,
    0.3818300505051189e+00,
    0.4179591836734694e+00
  };
  if (__calls[23].calls == 0) {
    _data_k_28 = 0;
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    xgk_[0] = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    xgk_[1] = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    xgk_[2] = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    xgk_[3] = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    xgk_[4] = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    xgk_[5] = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    xgk_[6] = _data_l_28[_data_k_28++];
    if (_data_k_28 >= _data_n_28) {
      _data_k_28 = 0;
    }
    xgk_[7] = _data_l_28[_data_k_28++];
  }
  if (__calls[23].calls == 0) {
    _data_k_29 = 0;
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    wgk_[0] = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    wgk_[1] = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    wgk_[2] = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    wgk_[3] = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    wgk_[4] = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    wgk_[5] = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    wgk_[6] = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    wgk_[7] = _data_l_29[_data_k_29++];
  }
  if (__calls[23].calls == 0) {
    _data_k_30 = 0;
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    wg_[0] = _data_l_30[_data_k_30++];
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    wg_[1] = _data_l_30[_data_k_30++];
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    wg_[2] = _data_l_30[_data_k_30++];
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    wg_[3] = _data_l_30[_data_k_30++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  fc_ = _f (&centr_) * _w (&centr_, p1_, p2_, p3_, p4_, kp_);
  resg_ = wg_[3] * fc_;
  resk_ = wgk_[7] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 3; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    absc1_ = centr_ - absc_;
    absc2_ = centr_ + absc_;
    fval1_ = _f (&absc1_) * _w (&absc1_, p1_, p2_, p3_, p4_, kp_);
    fval2_ = _f (&absc2_) * _w (&absc2_, p1_, p2_, p3_, p4_, kp_);
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 4; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    absc1_ = centr_ - absc_;
    absc2_ = centr_ + absc_;
    fval1_ = _f (&absc1_) * _w (&absc1_, p1_, p2_, p3_, p4_, kp_);
    fval2_ = _f (&absc2_) * _w (&absc2_, p1_, p2_, p3_, p4_, kp_);
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[7] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, pow ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[23].calls++;
  return 0;
}
int_4 _dqk21 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ resabs_, 
real_8 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_8 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[10], fv2_[10], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[5], wgk_[11], xgk_[11];
  int_4 _data_k_31, _data_k_32, _data_k_33, _data_k_34, _data_k_35, _data_k_36, _data_k_37, _data_k_38, _data_k_39, 
  _data_k_40, _data_k_41, _data_k_42, _data_k_43, _data_k_44, _data_k_45, _data_k_46, _data_k_47, _data_k_48, _data_k_49, 
  _data_k_50, _data_k_51, _data_k_52, _data_k_53, _data_k_54, _data_k_55, _data_k_56, _data_k_57, $0_;
  real_8 $1_, $2_, $3_, $4_;
  extern real_8 _d1mach ();
#define _data_n_31 1
  static real_8 _data_l_31[_data_n_31] = {
    0.066671344308688137593568809893332e0
  };
#define _data_n_32 1
  static real_8 _data_l_32[_data_n_32] = {
    0.149451349150580593145776339657697e0
  };
#define _data_n_33 1
  static real_8 _data_l_33[_data_n_33] = {
    0.219086362515982043995534934228163e0
  };
#define _data_n_34 1
  static real_8 _data_l_34[_data_n_34] = {
    0.269266719309996355091226921569469e0
  };
#define _data_n_35 1
  static real_8 _data_l_35[_data_n_35] = {
    0.295524224714752870173892994651338e0
  };
#define _data_n_36 1
  static real_8 _data_l_36[_data_n_36] = {
    0.995657163025808080735527280689003e0
  };
#define _data_n_37 1
  static real_8 _data_l_37[_data_n_37] = {
    0.973906528517171720077964012084452e0
  };
#define _data_n_38 1
  static real_8 _data_l_38[_data_n_38] = {
    0.930157491355708226001207180059508e0
  };
#define _data_n_39 1
  static real_8 _data_l_39[_data_n_39] = {
    0.865063366688984510732096688423493e0
  };
#define _data_n_40 1
  static real_8 _data_l_40[_data_n_40] = {
    0.780817726586416897063717578345042e0
  };
#define _data_n_41 1
  static real_8 _data_l_41[_data_n_41] = {
    0.679409568299024406234327365114874e0
  };
#define _data_n_42 1
  static real_8 _data_l_42[_data_n_42] = {
    0.562757134668604683339000099272694e0
  };
#define _data_n_43 1
  static real_8 _data_l_43[_data_n_43] = {
    0.433395394129247190799265943165784e0
  };
#define _data_n_44 1
  static real_8 _data_l_44[_data_n_44] = {
    0.294392862701460198131126603103866e0
  };
#define _data_n_45 1
  static real_8 _data_l_45[_data_n_45] = {
    0.14887433898163121088482600112972e0
  };
#define _data_n_46 1
  static real_8 _data_l_46[_data_n_46] = {
    0.0e0
  };
#define _data_n_47 1
  static real_8 _data_l_47[_data_n_47] = {
    0.011694638867371874278064396062192e0
  };
#define _data_n_48 1
  static real_8 _data_l_48[_data_n_48] = {
    0.03255816230796472747881897245939e0
  };
#define _data_n_49 1
  static real_8 _data_l_49[_data_n_49] = {
    0.05475589657435199603138130024458e0
  };
#define _data_n_50 1
  static real_8 _data_l_50[_data_n_50] = {
    0.07503967481091995276704314091619e0
  };
#define _data_n_51 1
  static real_8 _data_l_51[_data_n_51] = {
    0.093125454583697605535065465083366e0
  };
#define _data_n_52 1
  static real_8 _data_l_52[_data_n_52] = {
    0.109387158802297641899210590325805e0
  };
#define _data_n_53 1
  static real_8 _data_l_53[_data_n_53] = {
    0.123491976262065851077958109831074e0
  };
#define _data_n_54 1
  static real_8 _data_l_54[_data_n_54] = {
    0.134709217311473325928054001771707e0
  };
#define _data_n_55 1
  static real_8 _data_l_55[_data_n_55] = {
    0.142775938577060080797094273138717e0
  };
#define _data_n_56 1
  static real_8 _data_l_56[_data_n_56] = {
    0.147739104901338491374841515972068e0
  };
#define _data_n_57 1
  static real_8 _data_l_57[_data_n_57] = {
    0.149445554002916905664936468389821e0
  };
  if (__calls[24].calls == 0) {
    _data_k_31 = 0;
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    wg_[0] = _data_l_31[_data_k_31++];
  }
  if (__calls[24].calls == 0) {
    _data_k_32 = 0;
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    wg_[1] = _data_l_32[_data_k_32++];
  }
  if (__calls[24].calls == 0) {
    _data_k_33 = 0;
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    wg_[2] = _data_l_33[_data_k_33++];
  }
  if (__calls[24].calls == 0) {
    _data_k_34 = 0;
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    wg_[3] = _data_l_34[_data_k_34++];
  }
  if (__calls[24].calls == 0) {
    _data_k_35 = 0;
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    wg_[4] = _data_l_35[_data_k_35++];
  }
  if (__calls[24].calls == 0) {
    _data_k_36 = 0;
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    xgk_[0] = _data_l_36[_data_k_36++];
  }
  if (__calls[24].calls == 0) {
    _data_k_37 = 0;
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    xgk_[1] = _data_l_37[_data_k_37++];
  }
  if (__calls[24].calls == 0) {
    _data_k_38 = 0;
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    xgk_[2] = _data_l_38[_data_k_38++];
  }
  if (__calls[24].calls == 0) {
    _data_k_39 = 0;
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    xgk_[3] = _data_l_39[_data_k_39++];
  }
  if (__calls[24].calls == 0) {
    _data_k_40 = 0;
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    xgk_[4] = _data_l_40[_data_k_40++];
  }
  if (__calls[24].calls == 0) {
    _data_k_41 = 0;
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    xgk_[5] = _data_l_41[_data_k_41++];
  }
  if (__calls[24].calls == 0) {
    _data_k_42 = 0;
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    xgk_[6] = _data_l_42[_data_k_42++];
  }
  if (__calls[24].calls == 0) {
    _data_k_43 = 0;
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    xgk_[7] = _data_l_43[_data_k_43++];
  }
  if (__calls[24].calls == 0) {
    _data_k_44 = 0;
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    xgk_[8] = _data_l_44[_data_k_44++];
  }
  if (__calls[24].calls == 0) {
    _data_k_45 = 0;
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    xgk_[9] = _data_l_45[_data_k_45++];
  }
  if (__calls[24].calls == 0) {
    _data_k_46 = 0;
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    xgk_[10] = _data_l_46[_data_k_46++];
  }
  if (__calls[24].calls == 0) {
    _data_k_47 = 0;
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    wgk_[0] = _data_l_47[_data_k_47++];
  }
  if (__calls[24].calls == 0) {
    _data_k_48 = 0;
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    wgk_[1] = _data_l_48[_data_k_48++];
  }
  if (__calls[24].calls == 0) {
    _data_k_49 = 0;
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    wgk_[2] = _data_l_49[_data_k_49++];
  }
  if (__calls[24].calls == 0) {
    _data_k_50 = 0;
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    wgk_[3] = _data_l_50[_data_k_50++];
  }
  if (__calls[24].calls == 0) {
    _data_k_51 = 0;
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    wgk_[4] = _data_l_51[_data_k_51++];
  }
  if (__calls[24].calls == 0) {
    _data_k_52 = 0;
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    wgk_[5] = _data_l_52[_data_k_52++];
  }
  if (__calls[24].calls == 0) {
    _data_k_53 = 0;
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    wgk_[6] = _data_l_53[_data_k_53++];
  }
  if (__calls[24].calls == 0) {
    _data_k_54 = 0;
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    wgk_[7] = _data_l_54[_data_k_54++];
  }
  if (__calls[24].calls == 0) {
    _data_k_55 = 0;
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    wgk_[8] = _data_l_55[_data_k_55++];
  }
  if (__calls[24].calls == 0) {
    _data_k_56 = 0;
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    wgk_[9] = _data_l_56[_data_k_56++];
  }
  if (__calls[24].calls == 0) {
    _data_k_57 = 0;
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    wgk_[10] = _data_l_57[_data_k_57++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  resg_ = 0.0;
  fc_ = _f (&centr_);
  resk_ = wgk_[10] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 5; (j_)++) {
    jtw_ = 2 * j_;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 5; (j_)++) {
    jtwm1_ = 2 * j_ - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[10] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 10; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, pow ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[24].calls++;
  return 0;
}

int_4 _dqk31 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ resabs_, 
real_8 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_8 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[15], fv2_[15], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[8], wgk_[16], xgk_[16];
  int_4 _data_k_58, _data_k_59, _data_k_60, _data_k_61, _data_k_62, _data_k_63, _data_k_64, _data_k_65, _data_k_66, 
  _data_k_67, _data_k_68, _data_k_69, _data_k_70, _data_k_71, _data_k_72, _data_k_73, _data_k_74, _data_k_75, _data_k_76, 
  _data_k_77, _data_k_78, _data_k_79, _data_k_80, _data_k_81, _data_k_82, _data_k_83, _data_k_84, _data_k_85, _data_k_86, 
  _data_k_87, _data_k_88, _data_k_89, _data_k_90, _data_k_91, _data_k_92, _data_k_93, _data_k_94, _data_k_95, _data_k_96, 
  _data_k_97, $0_;
  real_8 $1_, $2_, $3_, $4_;
  extern real_8 _d1mach ();
#define _data_n_58 1
  static real_8 _data_l_58[_data_n_58] = {
    0.030753241996117268354628393577204e0
  };
#define _data_n_59 1
  static real_8 _data_l_59[_data_n_59] = {
    0.070366047488108124709267416450667e0
  };
#define _data_n_60 1
  static real_8 _data_l_60[_data_n_60] = {
    0.107159220467171935011869546685869e0
  };
#define _data_n_61 1
  static real_8 _data_l_61[_data_n_61] = {
    0.139570677926154314447804794511028e0
  };
#define _data_n_62 1
  static real_8 _data_l_62[_data_n_62] = {
    0.166269205816993933553200860481209e0
  };
#define _data_n_63 1
  static real_8 _data_l_63[_data_n_63] = {
    0.186161000015562211026800561866423e0
  };
#define _data_n_64 1
  static real_8 _data_l_64[_data_n_64] = {
    0.198431485327111576456118326443839e0
  };
#define _data_n_65 1
  static real_8 _data_l_65[_data_n_65] = {
    0.202578241925561272880620199967519e0
  };
#define _data_n_66 1
  static real_8 _data_l_66[_data_n_66] = {
    0.998002298693397060285172840152271e0
  };
#define _data_n_67 1
  static real_8 _data_l_67[_data_n_67] = {
    0.987992518020485428489565718586613e0
  };
#define _data_n_68 1
  static real_8 _data_l_68[_data_n_68] = {
    0.967739075679139134257347978784337e0
  };
#define _data_n_69 1
  static real_8 _data_l_69[_data_n_69] = {
    0.937273392400705904307758947710209e0
  };
#define _data_n_70 1
  static real_8 _data_l_70[_data_n_70] = {
    0.897264532344081900882509656454496e0
  };
#define _data_n_71 1
  static real_8 _data_l_71[_data_n_71] = {
    0.848206583410427216200648320774217e0
  };
#define _data_n_72 1
  static real_8 _data_l_72[_data_n_72] = {
    0.790418501442465932967649294817947e0
  };
#define _data_n_73 1
  static real_8 _data_l_73[_data_n_73] = {
    0.724417731360170047416186054613938e0
  };
#define _data_n_74 1
  static real_8 _data_l_74[_data_n_74] = {
    0.650996741297416970533735895313275e0
  };
#define _data_n_75 1
  static real_8 _data_l_75[_data_n_75] = {
    0.570972172608538847537226737253911e0
  };
#define _data_n_76 1
  static real_8 _data_l_76[_data_n_76] = {
    0.485081863640239680693655740232351e0
  };
#define _data_n_77 1
  static real_8 _data_l_77[_data_n_77] = {
    0.394151347077563369897207370981045e0
  };
#define _data_n_78 1
  static real_8 _data_l_78[_data_n_78] = {
    0.299180007153168812166780024266389e0
  };
#define _data_n_79 1
  static real_8 _data_l_79[_data_n_79] = {
    0.201194093997434522300628303394596e0
  };
#define _data_n_80 1
  static real_8 _data_l_80[_data_n_80] = {
    0.101142066918717499027074231447392e0
  };
#define _data_n_81 1
  static real_8 _data_l_81[_data_n_81] = {
    0.0e0
  };
#define _data_n_82 1
  static real_8 _data_l_82[_data_n_82] = {
    0.005377479872923348987792051430128e0
  };
#define _data_n_83 1
  static real_8 _data_l_83[_data_n_83] = {
    0.015007947329316122538374763075807e0
  };
#define _data_n_84 1
  static real_8 _data_l_84[_data_n_84] = {
    0.025460847326715320186874001019653e0
  };
#define _data_n_85 1
  static real_8 _data_l_85[_data_n_85] = {
    0.03534636079137584622203794847836e0
  };
#define _data_n_86 1
  static real_8 _data_l_86[_data_n_86] = {
    0.04458975132476487660822729937328e0
  };
#define _data_n_87 1
  static real_8 _data_l_87[_data_n_87] = {
    0.05348152469092808726534314723943e0
  };
#define _data_n_88 1
  static real_8 _data_l_88[_data_n_88] = {
    0.062009567800670640285139230960803e0
  };
#define _data_n_89 1
  static real_8 _data_l_89[_data_n_89] = {
    0.069854121318728258709520077099147e0
  };
#define _data_n_90 1
  static real_8 _data_l_90[_data_n_90] = {
    0.076849680757720378894432777482659e0
  };
#define _data_n_91 1
  static real_8 _data_l_91[_data_n_91] = {
    0.083080502823133021038289247286104e0
  };
#define _data_n_92 1
  static real_8 _data_l_92[_data_n_92] = {
    0.088564443056211770647275443693774e0
  };
#define _data_n_93 1
  static real_8 _data_l_93[_data_n_93] = {
    0.093126598170825321225486872747346e0
  };
#define _data_n_94 1
  static real_8 _data_l_94[_data_n_94] = {
    0.096642726983623678505179907627589e0
  };
#define _data_n_95 1
  static real_8 _data_l_95[_data_n_95] = {
    0.099173598721791959332393173484603e0
  };
#define _data_n_96 1
  static real_8 _data_l_96[_data_n_96] = {
    0.10076984552387559504494666261757e0
  };
#define _data_n_97 1
  static real_8 _data_l_97[_data_n_97] = {
    0.101330007014791549017374792767493e0
  };
  if (__calls[25].calls == 0) {
    _data_k_58 = 0;
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    wg_[0] = _data_l_58[_data_k_58++];
  }
  if (__calls[25].calls == 0) {
    _data_k_59 = 0;
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    wg_[1] = _data_l_59[_data_k_59++];
  }
  if (__calls[25].calls == 0) {
    _data_k_60 = 0;
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    wg_[2] = _data_l_60[_data_k_60++];
  }
  if (__calls[25].calls == 0) {
    _data_k_61 = 0;
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    wg_[3] = _data_l_61[_data_k_61++];
  }
  if (__calls[25].calls == 0) {
    _data_k_62 = 0;
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    wg_[4] = _data_l_62[_data_k_62++];
  }
  if (__calls[25].calls == 0) {
    _data_k_63 = 0;
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    wg_[5] = _data_l_63[_data_k_63++];
  }
  if (__calls[25].calls == 0) {
    _data_k_64 = 0;
    if (_data_k_64 >= _data_n_64) {
      _data_k_64 = 0;
    }
    wg_[6] = _data_l_64[_data_k_64++];
  }
  if (__calls[25].calls == 0) {
    _data_k_65 = 0;
    if (_data_k_65 >= _data_n_65) {
      _data_k_65 = 0;
    }
    wg_[7] = _data_l_65[_data_k_65++];
  }
  if (__calls[25].calls == 0) {
    _data_k_66 = 0;
    if (_data_k_66 >= _data_n_66) {
      _data_k_66 = 0;
    }
    xgk_[0] = _data_l_66[_data_k_66++];
  }
  if (__calls[25].calls == 0) {
    _data_k_67 = 0;
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    xgk_[1] = _data_l_67[_data_k_67++];
  }
  if (__calls[25].calls == 0) {
    _data_k_68 = 0;
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    xgk_[2] = _data_l_68[_data_k_68++];
  }
  if (__calls[25].calls == 0) {
    _data_k_69 = 0;
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    xgk_[3] = _data_l_69[_data_k_69++];
  }
  if (__calls[25].calls == 0) {
    _data_k_70 = 0;
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    xgk_[4] = _data_l_70[_data_k_70++];
  }
  if (__calls[25].calls == 0) {
    _data_k_71 = 0;
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    xgk_[5] = _data_l_71[_data_k_71++];
  }
  if (__calls[25].calls == 0) {
    _data_k_72 = 0;
    if (_data_k_72 >= _data_n_72) {
      _data_k_72 = 0;
    }
    xgk_[6] = _data_l_72[_data_k_72++];
  }
  if (__calls[25].calls == 0) {
    _data_k_73 = 0;
    if (_data_k_73 >= _data_n_73) {
      _data_k_73 = 0;
    }
    xgk_[7] = _data_l_73[_data_k_73++];
  }
  if (__calls[25].calls == 0) {
    _data_k_74 = 0;
    if (_data_k_74 >= _data_n_74) {
      _data_k_74 = 0;
    }
    xgk_[8] = _data_l_74[_data_k_74++];
  }
  if (__calls[25].calls == 0) {
    _data_k_75 = 0;
    if (_data_k_75 >= _data_n_75) {
      _data_k_75 = 0;
    }
    xgk_[9] = _data_l_75[_data_k_75++];
  }
  if (__calls[25].calls == 0) {
    _data_k_76 = 0;
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    xgk_[10] = _data_l_76[_data_k_76++];
  }
  if (__calls[25].calls == 0) {
    _data_k_77 = 0;
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    xgk_[11] = _data_l_77[_data_k_77++];
  }
  if (__calls[25].calls == 0) {
    _data_k_78 = 0;
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    xgk_[12] = _data_l_78[_data_k_78++];
  }
  if (__calls[25].calls == 0) {
    _data_k_79 = 0;
    if (_data_k_79 >= _data_n_79) {
      _data_k_79 = 0;
    }
    xgk_[13] = _data_l_79[_data_k_79++];
  }
  if (__calls[25].calls == 0) {
    _data_k_80 = 0;
    if (_data_k_80 >= _data_n_80) {
      _data_k_80 = 0;
    }
    xgk_[14] = _data_l_80[_data_k_80++];
  }
  if (__calls[25].calls == 0) {
    _data_k_81 = 0;
    if (_data_k_81 >= _data_n_81) {
      _data_k_81 = 0;
    }
    xgk_[15] = _data_l_81[_data_k_81++];
  }
  if (__calls[25].calls == 0) {
    _data_k_82 = 0;
    if (_data_k_82 >= _data_n_82) {
      _data_k_82 = 0;
    }
    wgk_[0] = _data_l_82[_data_k_82++];
  }
  if (__calls[25].calls == 0) {
    _data_k_83 = 0;
    if (_data_k_83 >= _data_n_83) {
      _data_k_83 = 0;
    }
    wgk_[1] = _data_l_83[_data_k_83++];
  }
  if (__calls[25].calls == 0) {
    _data_k_84 = 0;
    if (_data_k_84 >= _data_n_84) {
      _data_k_84 = 0;
    }
    wgk_[2] = _data_l_84[_data_k_84++];
  }
  if (__calls[25].calls == 0) {
    _data_k_85 = 0;
    if (_data_k_85 >= _data_n_85) {
      _data_k_85 = 0;
    }
    wgk_[3] = _data_l_85[_data_k_85++];
  }
  if (__calls[25].calls == 0) {
    _data_k_86 = 0;
    if (_data_k_86 >= _data_n_86) {
      _data_k_86 = 0;
    }
    wgk_[4] = _data_l_86[_data_k_86++];
  }
  if (__calls[25].calls == 0) {
    _data_k_87 = 0;
    if (_data_k_87 >= _data_n_87) {
      _data_k_87 = 0;
    }
    wgk_[5] = _data_l_87[_data_k_87++];
  }
  if (__calls[25].calls == 0) {
    _data_k_88 = 0;
    if (_data_k_88 >= _data_n_88) {
      _data_k_88 = 0;
    }
    wgk_[6] = _data_l_88[_data_k_88++];
  }
  if (__calls[25].calls == 0) {
    _data_k_89 = 0;
    if (_data_k_89 >= _data_n_89) {
      _data_k_89 = 0;
    }
    wgk_[7] = _data_l_89[_data_k_89++];
  }
  if (__calls[25].calls == 0) {
    _data_k_90 = 0;
    if (_data_k_90 >= _data_n_90) {
      _data_k_90 = 0;
    }
    wgk_[8] = _data_l_90[_data_k_90++];
  }
  if (__calls[25].calls == 0) {
    _data_k_91 = 0;
    if (_data_k_91 >= _data_n_91) {
      _data_k_91 = 0;
    }
    wgk_[9] = _data_l_91[_data_k_91++];
  }
  if (__calls[25].calls == 0) {
    _data_k_92 = 0;
    if (_data_k_92 >= _data_n_92) {
      _data_k_92 = 0;
    }
    wgk_[10] = _data_l_92[_data_k_92++];
  }
  if (__calls[25].calls == 0) {
    _data_k_93 = 0;
    if (_data_k_93 >= _data_n_93) {
      _data_k_93 = 0;
    }
    wgk_[11] = _data_l_93[_data_k_93++];
  }
  if (__calls[25].calls == 0) {
    _data_k_94 = 0;
    if (_data_k_94 >= _data_n_94) {
      _data_k_94 = 0;
    }
    wgk_[12] = _data_l_94[_data_k_94++];
  }
  if (__calls[25].calls == 0) {
    _data_k_95 = 0;
    if (_data_k_95 >= _data_n_95) {
      _data_k_95 = 0;
    }
    wgk_[13] = _data_l_95[_data_k_95++];
  }
  if (__calls[25].calls == 0) {
    _data_k_96 = 0;
    if (_data_k_96 >= _data_n_96) {
      _data_k_96 = 0;
    }
    wgk_[14] = _data_l_96[_data_k_96++];
  }
  if (__calls[25].calls == 0) {
    _data_k_97 = 0;
    if (_data_k_97 >= _data_n_97) {
      _data_k_97 = 0;
    }
    wgk_[15] = _data_l_97[_data_k_97++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  fc_ = _f (&centr_);
  resg_ = wg_[7] * fc_;
  resk_ = wgk_[15] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 8; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[15] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 15; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, pow ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[25].calls++;
  return 0;
}

int_4 _dqk41 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ resabs_, 
real_8 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_8 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[20], fv2_[20], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[10], wgk_[21], xgk_[21];
  int_4 _data_k_98, _data_k_99, _data_k_100, _data_k_101, _data_k_102, _data_k_103, _data_k_104, _data_k_105, _data_k_106
  , _data_k_107, _data_k_108, _data_k_109, _data_k_110, _data_k_111, _data_k_112, _data_k_113, _data_k_114, _data_k_115, 
  _data_k_116, _data_k_117, _data_k_118, _data_k_119, _data_k_120, _data_k_121, _data_k_122, _data_k_123, _data_k_124, 
  _data_k_125, _data_k_126, _data_k_127, _data_k_128, _data_k_129, _data_k_130, _data_k_131, _data_k_132, _data_k_133, 
  _data_k_134, _data_k_135, _data_k_136, _data_k_137, _data_k_138, _data_k_139, _data_k_140, _data_k_141, _data_k_142, 
  _data_k_143, _data_k_144, _data_k_145, _data_k_146, _data_k_147, _data_k_148, _data_k_149, $0_;
  real_8 $1_, $2_, $3_, $4_;
  extern real_8 _d1mach ();
#define _data_n_98 1
  static real_8 _data_l_98[_data_n_98] = {
    0.017614007139152118311861962351853e0
  };
#define _data_n_99 1
  static real_8 _data_l_99[_data_n_99] = {
    0.040601429800386941331039952274932e0
  };
#define _data_n_100 1
  static real_8 _data_l_100[_data_n_100] = {
    0.062672048334109063569506535187042e0
  };
#define _data_n_101 1
  static real_8 _data_l_101[_data_n_101] = {
    0.083276741576704748724758143222046e0
  };
#define _data_n_102 1
  static real_8 _data_l_102[_data_n_102] = {
    0.10193011981724043503675013548035e0
  };
#define _data_n_103 1
  static real_8 _data_l_103[_data_n_103] = {
    0.118194531961518417312377377711382e0
  };
#define _data_n_104 1
  static real_8 _data_l_104[_data_n_104] = {
    0.131688638449176626898494499748163e0
  };
#define _data_n_105 1
  static real_8 _data_l_105[_data_n_105] = {
    0.142096109318382051329298325067165e0
  };
#define _data_n_106 1
  static real_8 _data_l_106[_data_n_106] = {
    0.149172986472603746787828737001969e0
  };
#define _data_n_107 1
  static real_8 _data_l_107[_data_n_107] = {
    0.152753387130725850698084331955098e0
  };
#define _data_n_108 1
  static real_8 _data_l_108[_data_n_108] = {
    0.998859031588277663838315576545863e0
  };
#define _data_n_109 1
  static real_8 _data_l_109[_data_n_109] = {
    0.99312859918509492478612238847132e0
  };
#define _data_n_110 1
  static real_8 _data_l_110[_data_n_110] = {
    0.981507877450250259193342994720217e0
  };
#define _data_n_111 1
  static real_8 _data_l_111[_data_n_111] = {
    0.963971927277913791267666131197277e0
  };
#define _data_n_112 1
  static real_8 _data_l_112[_data_n_112] = {
    0.940822633831754753519982722212443e0
  };
#define _data_n_113 1
  static real_8 _data_l_113[_data_n_113] = {
    0.912234428251325905867752441203298e0
  };
#define _data_n_114 1
  static real_8 _data_l_114[_data_n_114] = {
    0.878276811252281976077442995113078e0
  };
#define _data_n_115 1
  static real_8 _data_l_115[_data_n_115] = {
    0.839116971822218823394529061701521e0
  };
#define _data_n_116 1
  static real_8 _data_l_116[_data_n_116] = {
    0.795041428837551198350638833272788e0
  };
#define _data_n_117 1
  static real_8 _data_l_117[_data_n_117] = {
    0.746331906460150792614305070355642e0
  };
#define _data_n_118 1
  static real_8 _data_l_118[_data_n_118] = {
    0.693237656334751384805490711845932e0
  };
#define _data_n_119 1
  static real_8 _data_l_119[_data_n_119] = {
    0.636053680726515025452836696226286e0
  };
#define _data_n_120 1
  static real_8 _data_l_120[_data_n_120] = {
    0.575140446819710315342946036586425e0
  };
#define _data_n_121 1
  static real_8 _data_l_121[_data_n_121] = {
    0.510867001950827098004364050955251e0
  };
#define _data_n_122 1
  static real_8 _data_l_122[_data_n_122] = {
    0.44359317523872510319999221349264e0
  };
#define _data_n_123 1
  static real_8 _data_l_123[_data_n_123] = {
    0.373706088715419560672548177024927e0
  };
#define _data_n_124 1
  static real_8 _data_l_124[_data_n_124] = {
    0.301627868114913004320555356858592e0
  };
#define _data_n_125 1
  static real_8 _data_l_125[_data_n_125] = {
    0.227785851141645078080496195368575e0
  };
#define _data_n_126 1
  static real_8 _data_l_126[_data_n_126] = {
    0.152605465240922675505220241022678e0
  };
#define _data_n_127 1
  static real_8 _data_l_127[_data_n_127] = {
    0.076526521133497333754640409398838e0
  };
#define _data_n_128 1
  static real_8 _data_l_128[_data_n_128] = {
    0.0e0
  };
#define _data_n_129 1
  static real_8 _data_l_129[_data_n_129] = {
    0.003073583718520531501218293246031e0
  };
#define _data_n_130 1
  static real_8 _data_l_130[_data_n_130] = {
    0.008600269855642942198661787950102e0
  };
#define _data_n_131 1
  static real_8 _data_l_131[_data_n_131] = {
    0.014626169256971252983787960308868e0
  };
#define _data_n_132 1
  static real_8 _data_l_132[_data_n_132] = {
    0.020388373461266523598010231432755e0
  };
#define _data_n_133 1
  static real_8 _data_l_133[_data_n_133] = {
    0.025882133604951158834505067096153e0
  };
#define _data_n_134 1
  static real_8 _data_l_134[_data_n_134] = {
    0.031287306777032798958543119323801e0
  };
#define _data_n_135 1
  static real_8 _data_l_135[_data_n_135] = {
    0.036600169758200798030557240707211e0
  };
#define _data_n_136 1
  static real_8 _data_l_136[_data_n_136] = {
    0.041668873327973686263788305936895e0
  };
#define _data_n_137 1
  static real_8 _data_l_137[_data_n_137] = {
    0.046434821867497674720231880926108e0
  };
#define _data_n_138 1
  static real_8 _data_l_138[_data_n_138] = {
    0.050944573923728691932707670050345e0
  };
#define _data_n_139 1
  static real_8 _data_l_139[_data_n_139] = {
    0.055195105348285994744832372419777e0
  };
#define _data_n_140 1
  static real_8 _data_l_140[_data_n_140] = {
    0.059111400880639572374967220648594e0
  };
#define _data_n_141 1
  static real_8 _data_l_141[_data_n_141] = {
    0.062653237554781168025870122174255e0
  };
#define _data_n_142 1
  static real_8 _data_l_142[_data_n_142] = {
    0.065834597133618422111563556969398e0
  };
#define _data_n_143 1
  static real_8 _data_l_143[_data_n_143] = {
    0.068648672928521619345623411885368e0
  };
#define _data_n_144 1
  static real_8 _data_l_144[_data_n_144] = {
    0.07105442355344406830579036172321e0
  };
#define _data_n_145 1
  static real_8 _data_l_145[_data_n_145] = {
    0.073030690332786667495189417658913e0
  };
#define _data_n_146 1
  static real_8 _data_l_146[_data_n_146] = {
    0.074582875400499188986581418362488e0
  };
#define _data_n_147 1
  static real_8 _data_l_147[_data_n_147] = {
    0.075704497684556674659542775376617e0
  };
#define _data_n_148 1
  static real_8 _data_l_148[_data_n_148] = {
    0.076377867672080736705502835038061e0
  };
#define _data_n_149 1
  static real_8 _data_l_149[_data_n_149] = {
    0.076600711917999656445049901530102e0
  };
  if (__calls[26].calls == 0) {
    _data_k_98 = 0;
    if (_data_k_98 >= _data_n_98) {
      _data_k_98 = 0;
    }
    wg_[0] = _data_l_98[_data_k_98++];
  }
  if (__calls[26].calls == 0) {
    _data_k_99 = 0;
    if (_data_k_99 >= _data_n_99) {
      _data_k_99 = 0;
    }
    wg_[1] = _data_l_99[_data_k_99++];
  }
  if (__calls[26].calls == 0) {
    _data_k_100 = 0;
    if (_data_k_100 >= _data_n_100) {
      _data_k_100 = 0;
    }
    wg_[2] = _data_l_100[_data_k_100++];
  }
  if (__calls[26].calls == 0) {
    _data_k_101 = 0;
    if (_data_k_101 >= _data_n_101) {
      _data_k_101 = 0;
    }
    wg_[3] = _data_l_101[_data_k_101++];
  }
  if (__calls[26].calls == 0) {
    _data_k_102 = 0;
    if (_data_k_102 >= _data_n_102) {
      _data_k_102 = 0;
    }
    wg_[4] = _data_l_102[_data_k_102++];
  }
  if (__calls[26].calls == 0) {
    _data_k_103 = 0;
    if (_data_k_103 >= _data_n_103) {
      _data_k_103 = 0;
    }
    wg_[5] = _data_l_103[_data_k_103++];
  }
  if (__calls[26].calls == 0) {
    _data_k_104 = 0;
    if (_data_k_104 >= _data_n_104) {
      _data_k_104 = 0;
    }
    wg_[6] = _data_l_104[_data_k_104++];
  }
  if (__calls[26].calls == 0) {
    _data_k_105 = 0;
    if (_data_k_105 >= _data_n_105) {
      _data_k_105 = 0;
    }
    wg_[7] = _data_l_105[_data_k_105++];
  }
  if (__calls[26].calls == 0) {
    _data_k_106 = 0;
    if (_data_k_106 >= _data_n_106) {
      _data_k_106 = 0;
    }
    wg_[8] = _data_l_106[_data_k_106++];
  }
  if (__calls[26].calls == 0) {
    _data_k_107 = 0;
    if (_data_k_107 >= _data_n_107) {
      _data_k_107 = 0;
    }
    wg_[9] = _data_l_107[_data_k_107++];
  }
  if (__calls[26].calls == 0) {
    _data_k_108 = 0;
    if (_data_k_108 >= _data_n_108) {
      _data_k_108 = 0;
    }
    xgk_[0] = _data_l_108[_data_k_108++];
  }
  if (__calls[26].calls == 0) {
    _data_k_109 = 0;
    if (_data_k_109 >= _data_n_109) {
      _data_k_109 = 0;
    }
    xgk_[1] = _data_l_109[_data_k_109++];
  }
  if (__calls[26].calls == 0) {
    _data_k_110 = 0;
    if (_data_k_110 >= _data_n_110) {
      _data_k_110 = 0;
    }
    xgk_[2] = _data_l_110[_data_k_110++];
  }
  if (__calls[26].calls == 0) {
    _data_k_111 = 0;
    if (_data_k_111 >= _data_n_111) {
      _data_k_111 = 0;
    }
    xgk_[3] = _data_l_111[_data_k_111++];
  }
  if (__calls[26].calls == 0) {
    _data_k_112 = 0;
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    xgk_[4] = _data_l_112[_data_k_112++];
  }
  if (__calls[26].calls == 0) {
    _data_k_113 = 0;
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    xgk_[5] = _data_l_113[_data_k_113++];
  }
  if (__calls[26].calls == 0) {
    _data_k_114 = 0;
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    xgk_[6] = _data_l_114[_data_k_114++];
  }
  if (__calls[26].calls == 0) {
    _data_k_115 = 0;
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    xgk_[7] = _data_l_115[_data_k_115++];
  }
  if (__calls[26].calls == 0) {
    _data_k_116 = 0;
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    xgk_[8] = _data_l_116[_data_k_116++];
  }
  if (__calls[26].calls == 0) {
    _data_k_117 = 0;
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    xgk_[9] = _data_l_117[_data_k_117++];
  }
  if (__calls[26].calls == 0) {
    _data_k_118 = 0;
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    xgk_[10] = _data_l_118[_data_k_118++];
  }
  if (__calls[26].calls == 0) {
    _data_k_119 = 0;
    if (_data_k_119 >= _data_n_119) {
      _data_k_119 = 0;
    }
    xgk_[11] = _data_l_119[_data_k_119++];
  }
  if (__calls[26].calls == 0) {
    _data_k_120 = 0;
    if (_data_k_120 >= _data_n_120) {
      _data_k_120 = 0;
    }
    xgk_[12] = _data_l_120[_data_k_120++];
  }
  if (__calls[26].calls == 0) {
    _data_k_121 = 0;
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    xgk_[13] = _data_l_121[_data_k_121++];
  }
  if (__calls[26].calls == 0) {
    _data_k_122 = 0;
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    xgk_[14] = _data_l_122[_data_k_122++];
  }
  if (__calls[26].calls == 0) {
    _data_k_123 = 0;
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    xgk_[15] = _data_l_123[_data_k_123++];
  }
  if (__calls[26].calls == 0) {
    _data_k_124 = 0;
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    xgk_[16] = _data_l_124[_data_k_124++];
  }
  if (__calls[26].calls == 0) {
    _data_k_125 = 0;
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    xgk_[17] = _data_l_125[_data_k_125++];
  }
  if (__calls[26].calls == 0) {
    _data_k_126 = 0;
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    xgk_[18] = _data_l_126[_data_k_126++];
  }
  if (__calls[26].calls == 0) {
    _data_k_127 = 0;
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    xgk_[19] = _data_l_127[_data_k_127++];
  }
  if (__calls[26].calls == 0) {
    _data_k_128 = 0;
    if (_data_k_128 >= _data_n_128) {
      _data_k_128 = 0;
    }
    xgk_[20] = _data_l_128[_data_k_128++];
  }
  if (__calls[26].calls == 0) {
    _data_k_129 = 0;
    if (_data_k_129 >= _data_n_129) {
      _data_k_129 = 0;
    }
    wgk_[0] = _data_l_129[_data_k_129++];
  }
  if (__calls[26].calls == 0) {
    _data_k_130 = 0;
    if (_data_k_130 >= _data_n_130) {
      _data_k_130 = 0;
    }
    wgk_[1] = _data_l_130[_data_k_130++];
  }
  if (__calls[26].calls == 0) {
    _data_k_131 = 0;
    if (_data_k_131 >= _data_n_131) {
      _data_k_131 = 0;
    }
    wgk_[2] = _data_l_131[_data_k_131++];
  }
  if (__calls[26].calls == 0) {
    _data_k_132 = 0;
    if (_data_k_132 >= _data_n_132) {
      _data_k_132 = 0;
    }
    wgk_[3] = _data_l_132[_data_k_132++];
  }
  if (__calls[26].calls == 0) {
    _data_k_133 = 0;
    if (_data_k_133 >= _data_n_133) {
      _data_k_133 = 0;
    }
    wgk_[4] = _data_l_133[_data_k_133++];
  }
  if (__calls[26].calls == 0) {
    _data_k_134 = 0;
    if (_data_k_134 >= _data_n_134) {
      _data_k_134 = 0;
    }
    wgk_[5] = _data_l_134[_data_k_134++];
  }
  if (__calls[26].calls == 0) {
    _data_k_135 = 0;
    if (_data_k_135 >= _data_n_135) {
      _data_k_135 = 0;
    }
    wgk_[6] = _data_l_135[_data_k_135++];
  }
  if (__calls[26].calls == 0) {
    _data_k_136 = 0;
    if (_data_k_136 >= _data_n_136) {
      _data_k_136 = 0;
    }
    wgk_[7] = _data_l_136[_data_k_136++];
  }
  if (__calls[26].calls == 0) {
    _data_k_137 = 0;
    if (_data_k_137 >= _data_n_137) {
      _data_k_137 = 0;
    }
    wgk_[8] = _data_l_137[_data_k_137++];
  }
  if (__calls[26].calls == 0) {
    _data_k_138 = 0;
    if (_data_k_138 >= _data_n_138) {
      _data_k_138 = 0;
    }
    wgk_[9] = _data_l_138[_data_k_138++];
  }
  if (__calls[26].calls == 0) {
    _data_k_139 = 0;
    if (_data_k_139 >= _data_n_139) {
      _data_k_139 = 0;
    }
    wgk_[10] = _data_l_139[_data_k_139++];
  }
  if (__calls[26].calls == 0) {
    _data_k_140 = 0;
    if (_data_k_140 >= _data_n_140) {
      _data_k_140 = 0;
    }
    wgk_[11] = _data_l_140[_data_k_140++];
  }
  if (__calls[26].calls == 0) {
    _data_k_141 = 0;
    if (_data_k_141 >= _data_n_141) {
      _data_k_141 = 0;
    }
    wgk_[12] = _data_l_141[_data_k_141++];
  }
  if (__calls[26].calls == 0) {
    _data_k_142 = 0;
    if (_data_k_142 >= _data_n_142) {
      _data_k_142 = 0;
    }
    wgk_[13] = _data_l_142[_data_k_142++];
  }
  if (__calls[26].calls == 0) {
    _data_k_143 = 0;
    if (_data_k_143 >= _data_n_143) {
      _data_k_143 = 0;
    }
    wgk_[14] = _data_l_143[_data_k_143++];
  }
  if (__calls[26].calls == 0) {
    _data_k_144 = 0;
    if (_data_k_144 >= _data_n_144) {
      _data_k_144 = 0;
    }
    wgk_[15] = _data_l_144[_data_k_144++];
  }
  if (__calls[26].calls == 0) {
    _data_k_145 = 0;
    if (_data_k_145 >= _data_n_145) {
      _data_k_145 = 0;
    }
    wgk_[16] = _data_l_145[_data_k_145++];
  }
  if (__calls[26].calls == 0) {
    _data_k_146 = 0;
    if (_data_k_146 >= _data_n_146) {
      _data_k_146 = 0;
    }
    wgk_[17] = _data_l_146[_data_k_146++];
  }
  if (__calls[26].calls == 0) {
    _data_k_147 = 0;
    if (_data_k_147 >= _data_n_147) {
      _data_k_147 = 0;
    }
    wgk_[18] = _data_l_147[_data_k_147++];
  }
  if (__calls[26].calls == 0) {
    _data_k_148 = 0;
    if (_data_k_148 >= _data_n_148) {
      _data_k_148 = 0;
    }
    wgk_[19] = _data_l_148[_data_k_148++];
  }
  if (__calls[26].calls == 0) {
    _data_k_149 = 0;
    if (_data_k_149 >= _data_n_149) {
      _data_k_149 = 0;
    }
    wgk_[20] = _data_l_149[_data_k_149++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  resg_ = 0.0;
  fc_ = _f (&centr_);
  resk_ = wgk_[20] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 10; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 10; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[20] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 20; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, pow ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[26].calls++;
  return 0;
}

int_4 _dqk51 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ resabs_, 
real_8 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_8 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[25], fv2_[25], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[13], wgk_[26], xgk_[26];
  int_4 _data_k_150, _data_k_151, _data_k_152, _data_k_153, _data_k_154, _data_k_155, _data_k_156, _data_k_157, 
  _data_k_158, _data_k_159, _data_k_160, _data_k_161, _data_k_162, _data_k_163, _data_k_164, _data_k_165, _data_k_166, 
  _data_k_167, _data_k_168, _data_k_169, _data_k_170, _data_k_171, _data_k_172, _data_k_173, _data_k_174, _data_k_175, 
  _data_k_176, _data_k_177, _data_k_178, _data_k_179, _data_k_180, _data_k_181, _data_k_182, _data_k_183, _data_k_184, 
  _data_k_185, _data_k_186, _data_k_187, _data_k_188, _data_k_189, _data_k_190, _data_k_191, _data_k_192, _data_k_193, 
  _data_k_194, _data_k_195, _data_k_196, _data_k_197, _data_k_198, _data_k_199, _data_k_200, _data_k_201, _data_k_202, 
  _data_k_203, _data_k_204, _data_k_205, _data_k_206, _data_k_207, _data_k_208, _data_k_209, _data_k_210, _data_k_211, 
  _data_k_212, _data_k_213, _data_k_214, $0_;
  real_8 $1_, $2_, $3_, $4_;
  extern real_8 _d1mach ();
#define _data_n_150 1
  static real_8 _data_l_150[_data_n_150] = {
    0.011393798501026287947902964113235e0
  };
#define _data_n_151 1
  static real_8 _data_l_151[_data_n_151] = {
    0.026354986615032137261901815295299e0
  };
#define _data_n_152 1
  static real_8 _data_l_152[_data_n_152] = {
    0.040939156701306312655623487711646e0
  };
#define _data_n_153 1
  static real_8 _data_l_153[_data_n_153] = {
    0.054904695975835191925936891540473e0
  };
#define _data_n_154 1
  static real_8 _data_l_154[_data_n_154] = {
    0.068038333812356917207187185656708e0
  };
#define _data_n_155 1
  static real_8 _data_l_155[_data_n_155] = {
    0.080140700335001018013234959669111e0
  };
#define _data_n_156 1
  static real_8 _data_l_156[_data_n_156] = {
    0.091028261982963649811497220702892e0
  };
#define _data_n_157 1
  static real_8 _data_l_157[_data_n_157] = {
    0.100535949067050644202206890392686e0
  };
#define _data_n_158 1
  static real_8 _data_l_158[_data_n_158] = {
    0.108519624474263653116093957050117e0
  };
#define _data_n_159 1
  static real_8 _data_l_159[_data_n_159] = {
    0.114858259145711648339325545869556e0
  };
#define _data_n_160 1
  static real_8 _data_l_160[_data_n_160] = {
    0.119455763535784772228178126512901e0
  };
#define _data_n_161 1
  static real_8 _data_l_161[_data_n_161] = {
    0.122242442990310041688959518945852e0
  };
#define _data_n_162 1
  static real_8 _data_l_162[_data_n_162] = {
    0.12317605372671545120390287307905e0
  };
#define _data_n_163 1
  static real_8 _data_l_163[_data_n_163] = {
    0.999262104992609834193457486540341e0
  };
#define _data_n_164 1
  static real_8 _data_l_164[_data_n_164] = {
    0.995556969790498097908784946893902e0
  };
#define _data_n_165 1
  static real_8 _data_l_165[_data_n_165] = {
    0.988035794534077247637331014577406e0
  };
#define _data_n_166 1
  static real_8 _data_l_166[_data_n_166] = {
    0.976663921459517511498315386479594e0
  };
#define _data_n_167 1
  static real_8 _data_l_167[_data_n_167] = {
    0.961614986425842512418130033660167e0
  };
#define _data_n_168 1
  static real_8 _data_l_168[_data_n_168] = {
    0.942974571228974339414011169658471e0
  };
#define _data_n_169 1
  static real_8 _data_l_169[_data_n_169] = {
    0.920747115281701561746346084546331e0
  };
#define _data_n_170 1
  static real_8 _data_l_170[_data_n_170] = {
    0.894991997878275368851042006782805e0
  };
#define _data_n_171 1
  static real_8 _data_l_171[_data_n_171] = {
    0.86584706529327559544899696958834e0
  };
#define _data_n_172 1
  static real_8 _data_l_172[_data_n_172] = {
    0.83344262876083400142102110869357e0
  };
#define _data_n_173 1
  static real_8 _data_l_173[_data_n_173] = {
    0.797873797998500059410410904994307e0
  };
#define _data_n_174 1
  static real_8 _data_l_174[_data_n_174] = {
    0.759259263037357630577282865204361e0
  };
#define _data_n_175 1
  static real_8 _data_l_175[_data_n_175] = {
    0.717766406813084388186654079773298e0
  };
#define _data_n_176 1
  static real_8 _data_l_176[_data_n_176] = {
    0.673566368473468364485120633247622e0
  };
#define _data_n_177 1
  static real_8 _data_l_177[_data_n_177] = {
    0.626810099010317412788122681624518e0
  };
#define _data_n_178 1
  static real_8 _data_l_178[_data_n_178] = {
    0.577662930241222967723689841612654e0
  };
#define _data_n_179 1
  static real_8 _data_l_179[_data_n_179] = {
    0.52632528433471918259962377815801e0
  };
#define _data_n_180 1
  static real_8 _data_l_180[_data_n_180] = {
    0.473002731445714960522182115009192e0
  };
#define _data_n_181 1
  static real_8 _data_l_181[_data_n_181] = {
    0.417885382193037748851814394594572e0
  };
#define _data_n_182 1
  static real_8 _data_l_182[_data_n_182] = {
    0.361172305809387837735821730127641e0
  };
#define _data_n_183 1
  static real_8 _data_l_183[_data_n_183] = {
    0.303089538931107830167478909980339e0
  };
#define _data_n_184 1
  static real_8 _data_l_184[_data_n_184] = {
    0.243866883720988432045190362797452e0
  };
#define _data_n_185 1
  static real_8 _data_l_185[_data_n_185] = {
    0.183718939421048892015969888759528e0
  };
#define _data_n_186 1
  static real_8 _data_l_186[_data_n_186] = {
    0.122864692610710396387359818808037e0
  };
#define _data_n_187 1
  static real_8 _data_l_187[_data_n_187] = {
    0.061544483005685078886546392366797e0
  };
#define _data_n_188 1
  static real_8 _data_l_188[_data_n_188] = {
    0.0e0
  };
#define _data_n_189 1
  static real_8 _data_l_189[_data_n_189] = {
    0.001987383892330315926507851882843e0
  };
#define _data_n_190 1
  static real_8 _data_l_190[_data_n_190] = {
    0.005561932135356713758040236901066e0
  };
#define _data_n_191 1
  static real_8 _data_l_191[_data_n_191] = {
    0.009473973386174151607207710523655e0
  };
#define _data_n_192 1
  static real_8 _data_l_192[_data_n_192] = {
    0.013236229195571674813656405846976e0
  };
#define _data_n_193 1
  static real_8 _data_l_193[_data_n_193] = {
    0.016847817709128298231516667536336e0
  };
#define _data_n_194 1
  static real_8 _data_l_194[_data_n_194] = {
    0.020435371145882835456568292235939e0
  };
#define _data_n_195 1
  static real_8 _data_l_195[_data_n_195] = {
    0.024009945606953216220092489164881e0
  };
#define _data_n_196 1
  static real_8 _data_l_196[_data_n_196] = {
    0.027475317587851737802948455517811e0
  };
#define _data_n_197 1
  static real_8 _data_l_197[_data_n_197] = {
    0.030792300167387488891109020215229e0
  };
#define _data_n_198 1
  static real_8 _data_l_198[_data_n_198] = {
    0.034002130274329337836748795229551e0
  };
#define _data_n_199 1
  static real_8 _data_l_199[_data_n_199] = {
    0.03711627148341554356033062536762e0
  };
#define _data_n_200 1
  static real_8 _data_l_200[_data_n_200] = {
    0.040083825504032382074839284467076e0
  };
#define _data_n_201 1
  static real_8 _data_l_201[_data_n_201] = {
    0.042872845020170049476895792439495e0
  };
#define _data_n_202 1
  static real_8 _data_l_202[_data_n_202] = {
    0.04550291304992178890987058475266e0
  };
#define _data_n_203 1
  static real_8 _data_l_203[_data_n_203] = {
    0.047982537138836713906392255756915e0
  };
#define _data_n_204 1
  static real_8 _data_l_204[_data_n_204] = {
    0.05027767908071567196332525943344e0
  };
#define _data_n_205 1
  static real_8 _data_l_205[_data_n_205] = {
    0.052362885806407475864366712137873e0
  };
#define _data_n_206 1
  static real_8 _data_l_206[_data_n_206] = {
    0.054251129888545490144543370459876e0
  };
#define _data_n_207 1
  static real_8 _data_l_207[_data_n_207] = {
    0.055950811220412317308240686382747e0
  };
#define _data_n_208 1
  static real_8 _data_l_208[_data_n_208] = {
    0.057437116361567832853582693939506e0
  };
#define _data_n_209 1
  static real_8 _data_l_209[_data_n_209] = {
    0.058689680022394207961974175856788e0
  };
#define _data_n_210 1
  static real_8 _data_l_210[_data_n_210] = {
    0.059720340324174059979099291932562e0
  };
#define _data_n_211 1
  static real_8 _data_l_211[_data_n_211] = {
    0.060539455376045862945360267517565e0
  };
#define _data_n_212 1
  static real_8 _data_l_212[_data_n_212] = {
    0.061128509717053048305859030416293e0
  };
#define _data_n_213 1
  static real_8 _data_l_213[_data_n_213] = {
    0.061471189871425316661544131965264e0
  };
#define _data_n_214 1
  static real_8 _data_l_214[_data_n_214] = {
    0.061580818067832935078759824240055e0
  };
  if (__calls[27].calls == 0) {
    _data_k_150 = 0;
    if (_data_k_150 >= _data_n_150) {
      _data_k_150 = 0;
    }
    wg_[0] = _data_l_150[_data_k_150++];
  }
  if (__calls[27].calls == 0) {
    _data_k_151 = 0;
    if (_data_k_151 >= _data_n_151) {
      _data_k_151 = 0;
    }
    wg_[1] = _data_l_151[_data_k_151++];
  }
  if (__calls[27].calls == 0) {
    _data_k_152 = 0;
    if (_data_k_152 >= _data_n_152) {
      _data_k_152 = 0;
    }
    wg_[2] = _data_l_152[_data_k_152++];
  }
  if (__calls[27].calls == 0) {
    _data_k_153 = 0;
    if (_data_k_153 >= _data_n_153) {
      _data_k_153 = 0;
    }
    wg_[3] = _data_l_153[_data_k_153++];
  }
  if (__calls[27].calls == 0) {
    _data_k_154 = 0;
    if (_data_k_154 >= _data_n_154) {
      _data_k_154 = 0;
    }
    wg_[4] = _data_l_154[_data_k_154++];
  }
  if (__calls[27].calls == 0) {
    _data_k_155 = 0;
    if (_data_k_155 >= _data_n_155) {
      _data_k_155 = 0;
    }
    wg_[5] = _data_l_155[_data_k_155++];
  }
  if (__calls[27].calls == 0) {
    _data_k_156 = 0;
    if (_data_k_156 >= _data_n_156) {
      _data_k_156 = 0;
    }
    wg_[6] = _data_l_156[_data_k_156++];
  }
  if (__calls[27].calls == 0) {
    _data_k_157 = 0;
    if (_data_k_157 >= _data_n_157) {
      _data_k_157 = 0;
    }
    wg_[7] = _data_l_157[_data_k_157++];
  }
  if (__calls[27].calls == 0) {
    _data_k_158 = 0;
    if (_data_k_158 >= _data_n_158) {
      _data_k_158 = 0;
    }
    wg_[8] = _data_l_158[_data_k_158++];
  }
  if (__calls[27].calls == 0) {
    _data_k_159 = 0;
    if (_data_k_159 >= _data_n_159) {
      _data_k_159 = 0;
    }
    wg_[9] = _data_l_159[_data_k_159++];
  }
  if (__calls[27].calls == 0) {
    _data_k_160 = 0;
    if (_data_k_160 >= _data_n_160) {
      _data_k_160 = 0;
    }
    wg_[10] = _data_l_160[_data_k_160++];
  }
  if (__calls[27].calls == 0) {
    _data_k_161 = 0;
    if (_data_k_161 >= _data_n_161) {
      _data_k_161 = 0;
    }
    wg_[11] = _data_l_161[_data_k_161++];
  }
  if (__calls[27].calls == 0) {
    _data_k_162 = 0;
    if (_data_k_162 >= _data_n_162) {
      _data_k_162 = 0;
    }
    wg_[12] = _data_l_162[_data_k_162++];
  }
  if (__calls[27].calls == 0) {
    _data_k_163 = 0;
    if (_data_k_163 >= _data_n_163) {
      _data_k_163 = 0;
    }
    xgk_[0] = _data_l_163[_data_k_163++];
  }
  if (__calls[27].calls == 0) {
    _data_k_164 = 0;
    if (_data_k_164 >= _data_n_164) {
      _data_k_164 = 0;
    }
    xgk_[1] = _data_l_164[_data_k_164++];
  }
  if (__calls[27].calls == 0) {
    _data_k_165 = 0;
    if (_data_k_165 >= _data_n_165) {
      _data_k_165 = 0;
    }
    xgk_[2] = _data_l_165[_data_k_165++];
  }
  if (__calls[27].calls == 0) {
    _data_k_166 = 0;
    if (_data_k_166 >= _data_n_166) {
      _data_k_166 = 0;
    }
    xgk_[3] = _data_l_166[_data_k_166++];
  }
  if (__calls[27].calls == 0) {
    _data_k_167 = 0;
    if (_data_k_167 >= _data_n_167) {
      _data_k_167 = 0;
    }
    xgk_[4] = _data_l_167[_data_k_167++];
  }
  if (__calls[27].calls == 0) {
    _data_k_168 = 0;
    if (_data_k_168 >= _data_n_168) {
      _data_k_168 = 0;
    }
    xgk_[5] = _data_l_168[_data_k_168++];
  }
  if (__calls[27].calls == 0) {
    _data_k_169 = 0;
    if (_data_k_169 >= _data_n_169) {
      _data_k_169 = 0;
    }
    xgk_[6] = _data_l_169[_data_k_169++];
  }
  if (__calls[27].calls == 0) {
    _data_k_170 = 0;
    if (_data_k_170 >= _data_n_170) {
      _data_k_170 = 0;
    }
    xgk_[7] = _data_l_170[_data_k_170++];
  }
  if (__calls[27].calls == 0) {
    _data_k_171 = 0;
    if (_data_k_171 >= _data_n_171) {
      _data_k_171 = 0;
    }
    xgk_[8] = _data_l_171[_data_k_171++];
  }
  if (__calls[27].calls == 0) {
    _data_k_172 = 0;
    if (_data_k_172 >= _data_n_172) {
      _data_k_172 = 0;
    }
    xgk_[9] = _data_l_172[_data_k_172++];
  }
  if (__calls[27].calls == 0) {
    _data_k_173 = 0;
    if (_data_k_173 >= _data_n_173) {
      _data_k_173 = 0;
    }
    xgk_[10] = _data_l_173[_data_k_173++];
  }
  if (__calls[27].calls == 0) {
    _data_k_174 = 0;
    if (_data_k_174 >= _data_n_174) {
      _data_k_174 = 0;
    }
    xgk_[11] = _data_l_174[_data_k_174++];
  }
  if (__calls[27].calls == 0) {
    _data_k_175 = 0;
    if (_data_k_175 >= _data_n_175) {
      _data_k_175 = 0;
    }
    xgk_[12] = _data_l_175[_data_k_175++];
  }
  if (__calls[27].calls == 0) {
    _data_k_176 = 0;
    if (_data_k_176 >= _data_n_176) {
      _data_k_176 = 0;
    }
    xgk_[13] = _data_l_176[_data_k_176++];
  }
  if (__calls[27].calls == 0) {
    _data_k_177 = 0;
    if (_data_k_177 >= _data_n_177) {
      _data_k_177 = 0;
    }
    xgk_[14] = _data_l_177[_data_k_177++];
  }
  if (__calls[27].calls == 0) {
    _data_k_178 = 0;
    if (_data_k_178 >= _data_n_178) {
      _data_k_178 = 0;
    }
    xgk_[15] = _data_l_178[_data_k_178++];
  }
  if (__calls[27].calls == 0) {
    _data_k_179 = 0;
    if (_data_k_179 >= _data_n_179) {
      _data_k_179 = 0;
    }
    xgk_[16] = _data_l_179[_data_k_179++];
  }
  if (__calls[27].calls == 0) {
    _data_k_180 = 0;
    if (_data_k_180 >= _data_n_180) {
      _data_k_180 = 0;
    }
    xgk_[17] = _data_l_180[_data_k_180++];
  }
  if (__calls[27].calls == 0) {
    _data_k_181 = 0;
    if (_data_k_181 >= _data_n_181) {
      _data_k_181 = 0;
    }
    xgk_[18] = _data_l_181[_data_k_181++];
  }
  if (__calls[27].calls == 0) {
    _data_k_182 = 0;
    if (_data_k_182 >= _data_n_182) {
      _data_k_182 = 0;
    }
    xgk_[19] = _data_l_182[_data_k_182++];
  }
  if (__calls[27].calls == 0) {
    _data_k_183 = 0;
    if (_data_k_183 >= _data_n_183) {
      _data_k_183 = 0;
    }
    xgk_[20] = _data_l_183[_data_k_183++];
  }
  if (__calls[27].calls == 0) {
    _data_k_184 = 0;
    if (_data_k_184 >= _data_n_184) {
      _data_k_184 = 0;
    }
    xgk_[21] = _data_l_184[_data_k_184++];
  }
  if (__calls[27].calls == 0) {
    _data_k_185 = 0;
    if (_data_k_185 >= _data_n_185) {
      _data_k_185 = 0;
    }
    xgk_[22] = _data_l_185[_data_k_185++];
  }
  if (__calls[27].calls == 0) {
    _data_k_186 = 0;
    if (_data_k_186 >= _data_n_186) {
      _data_k_186 = 0;
    }
    xgk_[23] = _data_l_186[_data_k_186++];
  }
  if (__calls[27].calls == 0) {
    _data_k_187 = 0;
    if (_data_k_187 >= _data_n_187) {
      _data_k_187 = 0;
    }
    xgk_[24] = _data_l_187[_data_k_187++];
  }
  if (__calls[27].calls == 0) {
    _data_k_188 = 0;
    if (_data_k_188 >= _data_n_188) {
      _data_k_188 = 0;
    }
    xgk_[25] = _data_l_188[_data_k_188++];
  }
  if (__calls[27].calls == 0) {
    _data_k_189 = 0;
    if (_data_k_189 >= _data_n_189) {
      _data_k_189 = 0;
    }
    wgk_[0] = _data_l_189[_data_k_189++];
  }
  if (__calls[27].calls == 0) {
    _data_k_190 = 0;
    if (_data_k_190 >= _data_n_190) {
      _data_k_190 = 0;
    }
    wgk_[1] = _data_l_190[_data_k_190++];
  }
  if (__calls[27].calls == 0) {
    _data_k_191 = 0;
    if (_data_k_191 >= _data_n_191) {
      _data_k_191 = 0;
    }
    wgk_[2] = _data_l_191[_data_k_191++];
  }
  if (__calls[27].calls == 0) {
    _data_k_192 = 0;
    if (_data_k_192 >= _data_n_192) {
      _data_k_192 = 0;
    }
    wgk_[3] = _data_l_192[_data_k_192++];
  }
  if (__calls[27].calls == 0) {
    _data_k_193 = 0;
    if (_data_k_193 >= _data_n_193) {
      _data_k_193 = 0;
    }
    wgk_[4] = _data_l_193[_data_k_193++];
  }
  if (__calls[27].calls == 0) {
    _data_k_194 = 0;
    if (_data_k_194 >= _data_n_194) {
      _data_k_194 = 0;
    }
    wgk_[5] = _data_l_194[_data_k_194++];
  }
  if (__calls[27].calls == 0) {
    _data_k_195 = 0;
    if (_data_k_195 >= _data_n_195) {
      _data_k_195 = 0;
    }
    wgk_[6] = _data_l_195[_data_k_195++];
  }
  if (__calls[27].calls == 0) {
    _data_k_196 = 0;
    if (_data_k_196 >= _data_n_196) {
      _data_k_196 = 0;
    }
    wgk_[7] = _data_l_196[_data_k_196++];
  }
  if (__calls[27].calls == 0) {
    _data_k_197 = 0;
    if (_data_k_197 >= _data_n_197) {
      _data_k_197 = 0;
    }
    wgk_[8] = _data_l_197[_data_k_197++];
  }
  if (__calls[27].calls == 0) {
    _data_k_198 = 0;
    if (_data_k_198 >= _data_n_198) {
      _data_k_198 = 0;
    }
    wgk_[9] = _data_l_198[_data_k_198++];
  }
  if (__calls[27].calls == 0) {
    _data_k_199 = 0;
    if (_data_k_199 >= _data_n_199) {
      _data_k_199 = 0;
    }
    wgk_[10] = _data_l_199[_data_k_199++];
  }
  if (__calls[27].calls == 0) {
    _data_k_200 = 0;
    if (_data_k_200 >= _data_n_200) {
      _data_k_200 = 0;
    }
    wgk_[11] = _data_l_200[_data_k_200++];
  }
  if (__calls[27].calls == 0) {
    _data_k_201 = 0;
    if (_data_k_201 >= _data_n_201) {
      _data_k_201 = 0;
    }
    wgk_[12] = _data_l_201[_data_k_201++];
  }
  if (__calls[27].calls == 0) {
    _data_k_202 = 0;
    if (_data_k_202 >= _data_n_202) {
      _data_k_202 = 0;
    }
    wgk_[13] = _data_l_202[_data_k_202++];
  }
  if (__calls[27].calls == 0) {
    _data_k_203 = 0;
    if (_data_k_203 >= _data_n_203) {
      _data_k_203 = 0;
    }
    wgk_[14] = _data_l_203[_data_k_203++];
  }
  if (__calls[27].calls == 0) {
    _data_k_204 = 0;
    if (_data_k_204 >= _data_n_204) {
      _data_k_204 = 0;
    }
    wgk_[15] = _data_l_204[_data_k_204++];
  }
  if (__calls[27].calls == 0) {
    _data_k_205 = 0;
    if (_data_k_205 >= _data_n_205) {
      _data_k_205 = 0;
    }
    wgk_[16] = _data_l_205[_data_k_205++];
  }
  if (__calls[27].calls == 0) {
    _data_k_206 = 0;
    if (_data_k_206 >= _data_n_206) {
      _data_k_206 = 0;
    }
    wgk_[17] = _data_l_206[_data_k_206++];
  }
  if (__calls[27].calls == 0) {
    _data_k_207 = 0;
    if (_data_k_207 >= _data_n_207) {
      _data_k_207 = 0;
    }
    wgk_[18] = _data_l_207[_data_k_207++];
  }
  if (__calls[27].calls == 0) {
    _data_k_208 = 0;
    if (_data_k_208 >= _data_n_208) {
      _data_k_208 = 0;
    }
    wgk_[19] = _data_l_208[_data_k_208++];
  }
  if (__calls[27].calls == 0) {
    _data_k_209 = 0;
    if (_data_k_209 >= _data_n_209) {
      _data_k_209 = 0;
    }
    wgk_[20] = _data_l_209[_data_k_209++];
  }
  if (__calls[27].calls == 0) {
    _data_k_210 = 0;
    if (_data_k_210 >= _data_n_210) {
      _data_k_210 = 0;
    }
    wgk_[21] = _data_l_210[_data_k_210++];
  }
  if (__calls[27].calls == 0) {
    _data_k_211 = 0;
    if (_data_k_211 >= _data_n_211) {
      _data_k_211 = 0;
    }
    wgk_[22] = _data_l_211[_data_k_211++];
  }
  if (__calls[27].calls == 0) {
    _data_k_212 = 0;
    if (_data_k_212 >= _data_n_212) {
      _data_k_212 = 0;
    }
    wgk_[23] = _data_l_212[_data_k_212++];
  }
  if (__calls[27].calls == 0) {
    _data_k_213 = 0;
    if (_data_k_213 >= _data_n_213) {
      _data_k_213 = 0;
    }
    wgk_[24] = _data_l_213[_data_k_213++];
  }
  if (__calls[27].calls == 0) {
    _data_k_214 = 0;
    if (_data_k_214 >= _data_n_214) {
      _data_k_214 = 0;
    }
    wgk_[25] = _data_l_214[_data_k_214++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  fc_ = _f (&centr_);
  resg_ = wg_[12] * fc_;
  resk_ = wgk_[25] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 12; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 13; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[25] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 25; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, pow ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[27].calls++;
  return 0;
}

int_4 _dqk61 (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ result_, real_8 _p_ abserr_, real_8 _p_ resabs_, 
real_8 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_8 dabsc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[30], fv2_[30], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[15], wgk_[31], xgk_[31];
  int_4 _data_k_215, _data_k_216, _data_k_217, _data_k_218, _data_k_219, _data_k_220, _data_k_221, _data_k_222, 
  _data_k_223, _data_k_224, _data_k_225, _data_k_226, _data_k_227, _data_k_228, _data_k_229, _data_k_230, _data_k_231, 
  _data_k_232, _data_k_233, _data_k_234, _data_k_235, _data_k_236, _data_k_237, _data_k_238, _data_k_239, _data_k_240, 
  _data_k_241, _data_k_242, _data_k_243, _data_k_244, _data_k_245, _data_k_246, _data_k_247, _data_k_248, _data_k_249, 
  _data_k_250, _data_k_251, _data_k_252, _data_k_253, _data_k_254, _data_k_255, _data_k_256, _data_k_257, _data_k_258, 
  _data_k_259, _data_k_260, _data_k_261, _data_k_262, _data_k_263, _data_k_264, _data_k_265, _data_k_266, _data_k_267, 
  _data_k_268, _data_k_269, _data_k_270, _data_k_271, _data_k_272, _data_k_273, _data_k_274, _data_k_275, _data_k_276, 
  _data_k_277, _data_k_278, _data_k_279, _data_k_280, _data_k_281, _data_k_282, _data_k_283, _data_k_284, _data_k_285, 
  _data_k_286, _data_k_287, _data_k_288, _data_k_289, _data_k_290, _data_k_291, $0_;
  real_8 $1_, $2_, $3_, $4_;
  extern real_8 _d1mach ();
#define _data_n_215 1
  static real_8 _data_l_215[_data_n_215] = {
    0.007968192496166605615465883474674e0
  };
#define _data_n_216 1
  static real_8 _data_l_216[_data_n_216] = {
    0.018466468311090959142302131912047e0
  };
#define _data_n_217 1
  static real_8 _data_l_217[_data_n_217] = {
    0.028784707883323369349719179611292e0
  };
#define _data_n_218 1
  static real_8 _data_l_218[_data_n_218] = {
    0.038799192569627049596801936446348e0
  };
#define _data_n_219 1
  static real_8 _data_l_219[_data_n_219] = {
    0.048402672830594052902938140422808e0
  };
#define _data_n_220 1
  static real_8 _data_l_220[_data_n_220] = {
    0.057493156217619066481721689402056e0
  };
#define _data_n_221 1
  static real_8 _data_l_221[_data_n_221] = {
    0.065974229882180495128128515115962e0
  };
#define _data_n_222 1
  static real_8 _data_l_222[_data_n_222] = {
    0.073755974737705206268243850022191e0
  };
#define _data_n_223 1
  static real_8 _data_l_223[_data_n_223] = {
    0.08075589522942021535469493846053e0
  };
#define _data_n_224 1
  static real_8 _data_l_224[_data_n_224] = {
    0.086899787201082979802387530715126e0
  };
#define _data_n_225 1
  static real_8 _data_l_225[_data_n_225] = {
    0.092122522237786128717632707087619e0
  };
#define _data_n_226 1
  static real_8 _data_l_226[_data_n_226] = {
    0.09636873717464425963946862635181e0
  };
#define _data_n_227 1
  static real_8 _data_l_227[_data_n_227] = {
    0.099593420586795267062780282103569e0
  };
#define _data_n_228 1
  static real_8 _data_l_228[_data_n_228] = {
    0.101762389748405504596428952168554e0
  };
#define _data_n_229 1
  static real_8 _data_l_229[_data_n_229] = {
    0.102852652893558840341285636705415e0
  };
#define _data_n_230 1
  static real_8 _data_l_230[_data_n_230] = {
    0.999484410050490637571325895705811e0
  };
#define _data_n_231 1
  static real_8 _data_l_231[_data_n_231] = {
    0.996893484074649540271630050918695e0
  };
#define _data_n_232 1
  static real_8 _data_l_232[_data_n_232] = {
    0.991630996870404594858628366109486e0
  };
#define _data_n_233 1
  static real_8 _data_l_233[_data_n_233] = {
    0.983668123279747209970032581605663e0
  };
#define _data_n_234 1
  static real_8 _data_l_234[_data_n_234] = {
    0.973116322501126268374693868423707e0
  };
#define _data_n_235 1
  static real_8 _data_l_235[_data_n_235] = {
    0.960021864968307512216871025581798e0
  };
#define _data_n_236 1
  static real_8 _data_l_236[_data_n_236] = {
    0.944374444748559979415831324037439e0
  };
#define _data_n_237 1
  static real_8 _data_l_237[_data_n_237] = {
    0.926200047429274325879324277080474e0
  };
#define _data_n_238 1
  static real_8 _data_l_238[_data_n_238] = {
    0.905573307699907798546522558925958e0
  };
#define _data_n_239 1
  static real_8 _data_l_239[_data_n_239] = {
    0.882560535792052681543116462530226e0
  };
#define _data_n_240 1
  static real_8 _data_l_240[_data_n_240] = {
    0.857205233546061098958658510658944e0
  };
#define _data_n_241 1
  static real_8 _data_l_241[_data_n_241] = {
    0.829565762382768397442898119732502e0
  };
#define _data_n_242 1
  static real_8 _data_l_242[_data_n_242] = {
    0.799727835821839083013668942322683e0
  };
#define _data_n_243 1
  static real_8 _data_l_243[_data_n_243] = {
    0.767777432104826194917977340974503e0
  };
#define _data_n_244 1
  static real_8 _data_l_244[_data_n_244] = {
    0.733790062453226804726171131369528e0
  };
#define _data_n_245 1
  static real_8 _data_l_245[_data_n_245] = {
    0.69785049479331579693229238802664e0
  };
#define _data_n_246 1
  static real_8 _data_l_246[_data_n_246] = {
    0.660061064126626961370053668149271e0
  };
#define _data_n_247 1
  static real_8 _data_l_247[_data_n_247] = {
    0.620526182989242861140477556431189e0
  };
#define _data_n_248 1
  static real_8 _data_l_248[_data_n_248] = {
    0.57934523582636169175602493217254e0
  };
#define _data_n_249 1
  static real_8 _data_l_249[_data_n_249] = {
    0.536624148142019899264169793311073e0
  };
#define _data_n_250 1
  static real_8 _data_l_250[_data_n_250] = {
    0.492480467861778574993693061207709e0
  };
#define _data_n_251 1
  static real_8 _data_l_251[_data_n_251] = {
    0.447033769538089176780609900322854e0
  };
#define _data_n_252 1
  static real_8 _data_l_252[_data_n_252] = {
    0.400401254830394392535476211542661e0
  };
#define _data_n_253 1
  static real_8 _data_l_253[_data_n_253] = {
    0.352704725530878113471037207089374e0
  };
#define _data_n_254 1
  static real_8 _data_l_254[_data_n_254] = {
    0.304073202273625077372677107199257e0
  };
#define _data_n_255 1
  static real_8 _data_l_255[_data_n_255] = {
    0.254636926167889846439805129817805e0
  };
#define _data_n_256 1
  static real_8 _data_l_256[_data_n_256] = {
    0.204525116682309891438957671002025e0
  };
#define _data_n_257 1
  static real_8 _data_l_257[_data_n_257] = {
    0.153869913608583546963794672743256e0
  };
#define _data_n_258 1
  static real_8 _data_l_258[_data_n_258] = {
    0.102806937966737030147096751318001e0
  };
#define _data_n_259 1
  static real_8 _data_l_259[_data_n_259] = {
    0.051471842555317695833025213166723e0
  };
#define _data_n_260 1
  static real_8 _data_l_260[_data_n_260] = {
    0.0e0
  };
#define _data_n_261 1
  static real_8 _data_l_261[_data_n_261] = {
    0.00138901369867700762455159122676e0
  };
#define _data_n_262 1
  static real_8 _data_l_262[_data_n_262] = {
    0.003890461127099884051267201844516e0
  };
#define _data_n_263 1
  static real_8 _data_l_263[_data_n_263] = {
    0.00663070391593129217331982636975e0
  };
#define _data_n_264 1
  static real_8 _data_l_264[_data_n_264] = {
    0.009273279659517763428441146892024e0
  };
#define _data_n_265 1
  static real_8 _data_l_265[_data_n_265] = {
    0.011823015253496341742232898853251e0
  };
#define _data_n_266 1
  static real_8 _data_l_266[_data_n_266] = {
    0.01436972950704580481245143244358e0
  };
#define _data_n_267 1
  static real_8 _data_l_267[_data_n_267] = {
    0.016920889189053272627572289420322e0
  };
#define _data_n_268 1
  static real_8 _data_l_268[_data_n_268] = {
    0.019414141193942381173408951050128e0
  };
#define _data_n_269 1
  static real_8 _data_l_269[_data_n_269] = {
    0.021828035821609192297167485738339e0
  };
#define _data_n_270 1
  static real_8 _data_l_270[_data_n_270] = {
    0.024191162078080601365686370725232e0
  };
#define _data_n_271 1
  static real_8 _data_l_271[_data_n_271] = {
    0.026509954882333101610601709335075e0
  };
#define _data_n_272 1
  static real_8 _data_l_272[_data_n_272] = {
    0.028754048765041292843978785354334e0
  };
#define _data_n_273 1
  static real_8 _data_l_273[_data_n_273] = {
    0.030907257562387762472884252943092e0
  };
#define _data_n_274 1
  static real_8 _data_l_274[_data_n_274] = {
    0.032981447057483726031814191016854e0
  };
#define _data_n_275 1
  static real_8 _data_l_275[_data_n_275] = {
    0.034979338028060024137499670731468e0
  };
#define _data_n_276 1
  static real_8 _data_l_276[_data_n_276] = {
    0.036882364651821229223911065617136e0
  };
#define _data_n_277 1
  static real_8 _data_l_277[_data_n_277] = {
    0.038678945624727592950348651532281e0
  };
#define _data_n_278 1
  static real_8 _data_l_278[_data_n_278] = {
    0.040374538951535959111995279752468e0
  };
#define _data_n_279 1
  static real_8 _data_l_279[_data_n_279] = {
    0.04196981021516424614714754128597e0
  };
#define _data_n_280 1
  static real_8 _data_l_280[_data_n_280] = {
    0.043452539701356069316831728117073e0
  };
#define _data_n_281 1
  static real_8 _data_l_281[_data_n_281] = {
    0.044814800133162663192355551616723e0
  };
#define _data_n_282 1
  static real_8 _data_l_282[_data_n_282] = {
    0.046059238271006988116271735559374e0
  };
#define _data_n_283 1
  static real_8 _data_l_283[_data_n_283] = {
    0.047185546569299153945261478181099e0
  };
#define _data_n_284 1
  static real_8 _data_l_284[_data_n_284] = {
    0.048185861757087129140779492298305e0
  };
#define _data_n_285 1
  static real_8 _data_l_285[_data_n_285] = {
    0.049055434555029778887528165367238e0
  };
#define _data_n_286 1
  static real_8 _data_l_286[_data_n_286] = {
    0.049795683427074206357811569379942e0
  };
#define _data_n_287 1
  static real_8 _data_l_287[_data_n_287] = {
    0.050405921402782346840893085653585e0
  };
#define _data_n_288 1
  static real_8 _data_l_288[_data_n_288] = {
    0.050881795898749606492297473049805e0
  };
#define _data_n_289 1
  static real_8 _data_l_289[_data_n_289] = {
    0.051221547849258772170656282604944e0
  };
#define _data_n_290 1
  static real_8 _data_l_290[_data_n_290] = {
    0.051426128537459025933862879215781e0
  };
#define _data_n_291 1
  static real_8 _data_l_291[_data_n_291] = {
    0.051494729429451567558340433647099e0
  };
  if (__calls[28].calls == 0) {
    _data_k_215 = 0;
    if (_data_k_215 >= _data_n_215) {
      _data_k_215 = 0;
    }
    wg_[0] = _data_l_215[_data_k_215++];
  }
  if (__calls[28].calls == 0) {
    _data_k_216 = 0;
    if (_data_k_216 >= _data_n_216) {
      _data_k_216 = 0;
    }
    wg_[1] = _data_l_216[_data_k_216++];
  }
  if (__calls[28].calls == 0) {
    _data_k_217 = 0;
    if (_data_k_217 >= _data_n_217) {
      _data_k_217 = 0;
    }
    wg_[2] = _data_l_217[_data_k_217++];
  }
  if (__calls[28].calls == 0) {
    _data_k_218 = 0;
    if (_data_k_218 >= _data_n_218) {
      _data_k_218 = 0;
    }
    wg_[3] = _data_l_218[_data_k_218++];
  }
  if (__calls[28].calls == 0) {
    _data_k_219 = 0;
    if (_data_k_219 >= _data_n_219) {
      _data_k_219 = 0;
    }
    wg_[4] = _data_l_219[_data_k_219++];
  }
  if (__calls[28].calls == 0) {
    _data_k_220 = 0;
    if (_data_k_220 >= _data_n_220) {
      _data_k_220 = 0;
    }
    wg_[5] = _data_l_220[_data_k_220++];
  }
  if (__calls[28].calls == 0) {
    _data_k_221 = 0;
    if (_data_k_221 >= _data_n_221) {
      _data_k_221 = 0;
    }
    wg_[6] = _data_l_221[_data_k_221++];
  }
  if (__calls[28].calls == 0) {
    _data_k_222 = 0;
    if (_data_k_222 >= _data_n_222) {
      _data_k_222 = 0;
    }
    wg_[7] = _data_l_222[_data_k_222++];
  }
  if (__calls[28].calls == 0) {
    _data_k_223 = 0;
    if (_data_k_223 >= _data_n_223) {
      _data_k_223 = 0;
    }
    wg_[8] = _data_l_223[_data_k_223++];
  }
  if (__calls[28].calls == 0) {
    _data_k_224 = 0;
    if (_data_k_224 >= _data_n_224) {
      _data_k_224 = 0;
    }
    wg_[9] = _data_l_224[_data_k_224++];
  }
  if (__calls[28].calls == 0) {
    _data_k_225 = 0;
    if (_data_k_225 >= _data_n_225) {
      _data_k_225 = 0;
    }
    wg_[10] = _data_l_225[_data_k_225++];
  }
  if (__calls[28].calls == 0) {
    _data_k_226 = 0;
    if (_data_k_226 >= _data_n_226) {
      _data_k_226 = 0;
    }
    wg_[11] = _data_l_226[_data_k_226++];
  }
  if (__calls[28].calls == 0) {
    _data_k_227 = 0;
    if (_data_k_227 >= _data_n_227) {
      _data_k_227 = 0;
    }
    wg_[12] = _data_l_227[_data_k_227++];
  }
  if (__calls[28].calls == 0) {
    _data_k_228 = 0;
    if (_data_k_228 >= _data_n_228) {
      _data_k_228 = 0;
    }
    wg_[13] = _data_l_228[_data_k_228++];
  }
  if (__calls[28].calls == 0) {
    _data_k_229 = 0;
    if (_data_k_229 >= _data_n_229) {
      _data_k_229 = 0;
    }
    wg_[14] = _data_l_229[_data_k_229++];
  }
  if (__calls[28].calls == 0) {
    _data_k_230 = 0;
    if (_data_k_230 >= _data_n_230) {
      _data_k_230 = 0;
    }
    xgk_[0] = _data_l_230[_data_k_230++];
  }
  if (__calls[28].calls == 0) {
    _data_k_231 = 0;
    if (_data_k_231 >= _data_n_231) {
      _data_k_231 = 0;
    }
    xgk_[1] = _data_l_231[_data_k_231++];
  }
  if (__calls[28].calls == 0) {
    _data_k_232 = 0;
    if (_data_k_232 >= _data_n_232) {
      _data_k_232 = 0;
    }
    xgk_[2] = _data_l_232[_data_k_232++];
  }
  if (__calls[28].calls == 0) {
    _data_k_233 = 0;
    if (_data_k_233 >= _data_n_233) {
      _data_k_233 = 0;
    }
    xgk_[3] = _data_l_233[_data_k_233++];
  }
  if (__calls[28].calls == 0) {
    _data_k_234 = 0;
    if (_data_k_234 >= _data_n_234) {
      _data_k_234 = 0;
    }
    xgk_[4] = _data_l_234[_data_k_234++];
  }
  if (__calls[28].calls == 0) {
    _data_k_235 = 0;
    if (_data_k_235 >= _data_n_235) {
      _data_k_235 = 0;
    }
    xgk_[5] = _data_l_235[_data_k_235++];
  }
  if (__calls[28].calls == 0) {
    _data_k_236 = 0;
    if (_data_k_236 >= _data_n_236) {
      _data_k_236 = 0;
    }
    xgk_[6] = _data_l_236[_data_k_236++];
  }
  if (__calls[28].calls == 0) {
    _data_k_237 = 0;
    if (_data_k_237 >= _data_n_237) {
      _data_k_237 = 0;
    }
    xgk_[7] = _data_l_237[_data_k_237++];
  }
  if (__calls[28].calls == 0) {
    _data_k_238 = 0;
    if (_data_k_238 >= _data_n_238) {
      _data_k_238 = 0;
    }
    xgk_[8] = _data_l_238[_data_k_238++];
  }
  if (__calls[28].calls == 0) {
    _data_k_239 = 0;
    if (_data_k_239 >= _data_n_239) {
      _data_k_239 = 0;
    }
    xgk_[9] = _data_l_239[_data_k_239++];
  }
  if (__calls[28].calls == 0) {
    _data_k_240 = 0;
    if (_data_k_240 >= _data_n_240) {
      _data_k_240 = 0;
    }
    xgk_[10] = _data_l_240[_data_k_240++];
  }
  if (__calls[28].calls == 0) {
    _data_k_241 = 0;
    if (_data_k_241 >= _data_n_241) {
      _data_k_241 = 0;
    }
    xgk_[11] = _data_l_241[_data_k_241++];
  }
  if (__calls[28].calls == 0) {
    _data_k_242 = 0;
    if (_data_k_242 >= _data_n_242) {
      _data_k_242 = 0;
    }
    xgk_[12] = _data_l_242[_data_k_242++];
  }
  if (__calls[28].calls == 0) {
    _data_k_243 = 0;
    if (_data_k_243 >= _data_n_243) {
      _data_k_243 = 0;
    }
    xgk_[13] = _data_l_243[_data_k_243++];
  }
  if (__calls[28].calls == 0) {
    _data_k_244 = 0;
    if (_data_k_244 >= _data_n_244) {
      _data_k_244 = 0;
    }
    xgk_[14] = _data_l_244[_data_k_244++];
  }
  if (__calls[28].calls == 0) {
    _data_k_245 = 0;
    if (_data_k_245 >= _data_n_245) {
      _data_k_245 = 0;
    }
    xgk_[15] = _data_l_245[_data_k_245++];
  }
  if (__calls[28].calls == 0) {
    _data_k_246 = 0;
    if (_data_k_246 >= _data_n_246) {
      _data_k_246 = 0;
    }
    xgk_[16] = _data_l_246[_data_k_246++];
  }
  if (__calls[28].calls == 0) {
    _data_k_247 = 0;
    if (_data_k_247 >= _data_n_247) {
      _data_k_247 = 0;
    }
    xgk_[17] = _data_l_247[_data_k_247++];
  }
  if (__calls[28].calls == 0) {
    _data_k_248 = 0;
    if (_data_k_248 >= _data_n_248) {
      _data_k_248 = 0;
    }
    xgk_[18] = _data_l_248[_data_k_248++];
  }
  if (__calls[28].calls == 0) {
    _data_k_249 = 0;
    if (_data_k_249 >= _data_n_249) {
      _data_k_249 = 0;
    }
    xgk_[19] = _data_l_249[_data_k_249++];
  }
  if (__calls[28].calls == 0) {
    _data_k_250 = 0;
    if (_data_k_250 >= _data_n_250) {
      _data_k_250 = 0;
    }
    xgk_[20] = _data_l_250[_data_k_250++];
  }
  if (__calls[28].calls == 0) {
    _data_k_251 = 0;
    if (_data_k_251 >= _data_n_251) {
      _data_k_251 = 0;
    }
    xgk_[21] = _data_l_251[_data_k_251++];
  }
  if (__calls[28].calls == 0) {
    _data_k_252 = 0;
    if (_data_k_252 >= _data_n_252) {
      _data_k_252 = 0;
    }
    xgk_[22] = _data_l_252[_data_k_252++];
  }
  if (__calls[28].calls == 0) {
    _data_k_253 = 0;
    if (_data_k_253 >= _data_n_253) {
      _data_k_253 = 0;
    }
    xgk_[23] = _data_l_253[_data_k_253++];
  }
  if (__calls[28].calls == 0) {
    _data_k_254 = 0;
    if (_data_k_254 >= _data_n_254) {
      _data_k_254 = 0;
    }
    xgk_[24] = _data_l_254[_data_k_254++];
  }
  if (__calls[28].calls == 0) {
    _data_k_255 = 0;
    if (_data_k_255 >= _data_n_255) {
      _data_k_255 = 0;
    }
    xgk_[25] = _data_l_255[_data_k_255++];
  }
  if (__calls[28].calls == 0) {
    _data_k_256 = 0;
    if (_data_k_256 >= _data_n_256) {
      _data_k_256 = 0;
    }
    xgk_[26] = _data_l_256[_data_k_256++];
  }
  if (__calls[28].calls == 0) {
    _data_k_257 = 0;
    if (_data_k_257 >= _data_n_257) {
      _data_k_257 = 0;
    }
    xgk_[27] = _data_l_257[_data_k_257++];
  }
  if (__calls[28].calls == 0) {
    _data_k_258 = 0;
    if (_data_k_258 >= _data_n_258) {
      _data_k_258 = 0;
    }
    xgk_[28] = _data_l_258[_data_k_258++];
  }
  if (__calls[28].calls == 0) {
    _data_k_259 = 0;
    if (_data_k_259 >= _data_n_259) {
      _data_k_259 = 0;
    }
    xgk_[29] = _data_l_259[_data_k_259++];
  }
  if (__calls[28].calls == 0) {
    _data_k_260 = 0;
    if (_data_k_260 >= _data_n_260) {
      _data_k_260 = 0;
    }
    xgk_[30] = _data_l_260[_data_k_260++];
  }
  if (__calls[28].calls == 0) {
    _data_k_261 = 0;
    if (_data_k_261 >= _data_n_261) {
      _data_k_261 = 0;
    }
    wgk_[0] = _data_l_261[_data_k_261++];
  }
  if (__calls[28].calls == 0) {
    _data_k_262 = 0;
    if (_data_k_262 >= _data_n_262) {
      _data_k_262 = 0;
    }
    wgk_[1] = _data_l_262[_data_k_262++];
  }
  if (__calls[28].calls == 0) {
    _data_k_263 = 0;
    if (_data_k_263 >= _data_n_263) {
      _data_k_263 = 0;
    }
    wgk_[2] = _data_l_263[_data_k_263++];
  }
  if (__calls[28].calls == 0) {
    _data_k_264 = 0;
    if (_data_k_264 >= _data_n_264) {
      _data_k_264 = 0;
    }
    wgk_[3] = _data_l_264[_data_k_264++];
  }
  if (__calls[28].calls == 0) {
    _data_k_265 = 0;
    if (_data_k_265 >= _data_n_265) {
      _data_k_265 = 0;
    }
    wgk_[4] = _data_l_265[_data_k_265++];
  }
  if (__calls[28].calls == 0) {
    _data_k_266 = 0;
    if (_data_k_266 >= _data_n_266) {
      _data_k_266 = 0;
    }
    wgk_[5] = _data_l_266[_data_k_266++];
  }
  if (__calls[28].calls == 0) {
    _data_k_267 = 0;
    if (_data_k_267 >= _data_n_267) {
      _data_k_267 = 0;
    }
    wgk_[6] = _data_l_267[_data_k_267++];
  }
  if (__calls[28].calls == 0) {
    _data_k_268 = 0;
    if (_data_k_268 >= _data_n_268) {
      _data_k_268 = 0;
    }
    wgk_[7] = _data_l_268[_data_k_268++];
  }
  if (__calls[28].calls == 0) {
    _data_k_269 = 0;
    if (_data_k_269 >= _data_n_269) {
      _data_k_269 = 0;
    }
    wgk_[8] = _data_l_269[_data_k_269++];
  }
  if (__calls[28].calls == 0) {
    _data_k_270 = 0;
    if (_data_k_270 >= _data_n_270) {
      _data_k_270 = 0;
    }
    wgk_[9] = _data_l_270[_data_k_270++];
  }
  if (__calls[28].calls == 0) {
    _data_k_271 = 0;
    if (_data_k_271 >= _data_n_271) {
      _data_k_271 = 0;
    }
    wgk_[10] = _data_l_271[_data_k_271++];
  }
  if (__calls[28].calls == 0) {
    _data_k_272 = 0;
    if (_data_k_272 >= _data_n_272) {
      _data_k_272 = 0;
    }
    wgk_[11] = _data_l_272[_data_k_272++];
  }
  if (__calls[28].calls == 0) {
    _data_k_273 = 0;
    if (_data_k_273 >= _data_n_273) {
      _data_k_273 = 0;
    }
    wgk_[12] = _data_l_273[_data_k_273++];
  }
  if (__calls[28].calls == 0) {
    _data_k_274 = 0;
    if (_data_k_274 >= _data_n_274) {
      _data_k_274 = 0;
    }
    wgk_[13] = _data_l_274[_data_k_274++];
  }
  if (__calls[28].calls == 0) {
    _data_k_275 = 0;
    if (_data_k_275 >= _data_n_275) {
      _data_k_275 = 0;
    }
    wgk_[14] = _data_l_275[_data_k_275++];
  }
  if (__calls[28].calls == 0) {
    _data_k_276 = 0;
    if (_data_k_276 >= _data_n_276) {
      _data_k_276 = 0;
    }
    wgk_[15] = _data_l_276[_data_k_276++];
  }
  if (__calls[28].calls == 0) {
    _data_k_277 = 0;
    if (_data_k_277 >= _data_n_277) {
      _data_k_277 = 0;
    }
    wgk_[16] = _data_l_277[_data_k_277++];
  }
  if (__calls[28].calls == 0) {
    _data_k_278 = 0;
    if (_data_k_278 >= _data_n_278) {
      _data_k_278 = 0;
    }
    wgk_[17] = _data_l_278[_data_k_278++];
  }
  if (__calls[28].calls == 0) {
    _data_k_279 = 0;
    if (_data_k_279 >= _data_n_279) {
      _data_k_279 = 0;
    }
    wgk_[18] = _data_l_279[_data_k_279++];
  }
  if (__calls[28].calls == 0) {
    _data_k_280 = 0;
    if (_data_k_280 >= _data_n_280) {
      _data_k_280 = 0;
    }
    wgk_[19] = _data_l_280[_data_k_280++];
  }
  if (__calls[28].calls == 0) {
    _data_k_281 = 0;
    if (_data_k_281 >= _data_n_281) {
      _data_k_281 = 0;
    }
    wgk_[20] = _data_l_281[_data_k_281++];
  }
  if (__calls[28].calls == 0) {
    _data_k_282 = 0;
    if (_data_k_282 >= _data_n_282) {
      _data_k_282 = 0;
    }
    wgk_[21] = _data_l_282[_data_k_282++];
  }
  if (__calls[28].calls == 0) {
    _data_k_283 = 0;
    if (_data_k_283 >= _data_n_283) {
      _data_k_283 = 0;
    }
    wgk_[22] = _data_l_283[_data_k_283++];
  }
  if (__calls[28].calls == 0) {
    _data_k_284 = 0;
    if (_data_k_284 >= _data_n_284) {
      _data_k_284 = 0;
    }
    wgk_[23] = _data_l_284[_data_k_284++];
  }
  if (__calls[28].calls == 0) {
    _data_k_285 = 0;
    if (_data_k_285 >= _data_n_285) {
      _data_k_285 = 0;
    }
    wgk_[24] = _data_l_285[_data_k_285++];
  }
  if (__calls[28].calls == 0) {
    _data_k_286 = 0;
    if (_data_k_286 >= _data_n_286) {
      _data_k_286 = 0;
    }
    wgk_[25] = _data_l_286[_data_k_286++];
  }
  if (__calls[28].calls == 0) {
    _data_k_287 = 0;
    if (_data_k_287 >= _data_n_287) {
      _data_k_287 = 0;
    }
    wgk_[26] = _data_l_287[_data_k_287++];
  }
  if (__calls[28].calls == 0) {
    _data_k_288 = 0;
    if (_data_k_288 >= _data_n_288) {
      _data_k_288 = 0;
    }
    wgk_[27] = _data_l_288[_data_k_288++];
  }
  if (__calls[28].calls == 0) {
    _data_k_289 = 0;
    if (_data_k_289 >= _data_n_289) {
      _data_k_289 = 0;
    }
    wgk_[28] = _data_l_289[_data_k_289++];
  }
  if (__calls[28].calls == 0) {
    _data_k_290 = 0;
    if (_data_k_290 >= _data_n_290) {
      _data_k_290 = 0;
    }
    wgk_[29] = _data_l_290[_data_k_290++];
  }
  if (__calls[28].calls == 0) {
    _data_k_291 = 0;
    if (_data_k_291 >= _data_n_291) {
      _data_k_291 = 0;
    }
    wgk_[30] = _data_l_291[_data_k_291++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  centr_ = 0.5e+00 * ((*b_) + (*a_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  resg_ = 0.0;
  fc_ = _f (&centr_);
  resk_ = wgk_[30] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 15; (j_)++) {
    jtw_ = j_ * 2;
    dabsc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - dabsc_, &$1_));
    fval2_ = _f (($2_ = centr_ + dabsc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 15; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    dabsc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - dabsc_, &$3_));
    fval2_ = _f (($4_ = centr_ + dabsc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[30] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 30; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, pow ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[28].calls++;
  return 0;
}

int_4 _dqmomo (real_8 _p_ alfa_, real_8 _p_ beta_, real_8 _p_ ri_, real_8 _p_ rj_, real_8 _p_ rg_, real_8 _p_ rh_, 
int_4 _p_ integr_)
{
  static int_4 i_, im1_;
  static real_8 alfp1_, alfp2_, an_, anm1_, betp1_, betp2_, ralf_, rbet_;
  alfp1_ = (*alfa_) + 0.1e1;
  betp1_ = (*beta_) + 0.1e1;
  alfp2_ = (*alfa_) + 0.2e1;
  betp2_ = (*beta_) + 0.2e1;
  ralf_ = pow (0.2e1, alfp1_);
  rbet_ = pow (0.2e1, betp1_);
  ri_[0] = ralf_ / alfp1_;
  rj_[0] = rbet_ / betp1_;
  ri_[1] = ri_[0] * (*alfa_) / alfp2_;
  rj_[1] = rj_[0] * (*beta_) / betp2_;
  an_ = 2.0;
  anm1_ = 1.0;
  for (i_ = 3; i_ <= 25; (i_)++) {
    ri_[i_ - 1] = -(ralf_ + an_ * (an_ - alfp2_) * ri_[i_ - 1 - 1]) / (anm1_ * (an_ + alfp1_));
    rj_[i_ - 1] = -(rbet_ + an_ * (an_ - betp2_) * rj_[i_ - 1 - 1]) / (anm1_ * (an_ + betp1_));
    anm1_ = an_;
    an_ = an_ + 0.1e1;
  }
  if ((*integr_) == 1) {
    goto _l70;
  }
  if ((*integr_) == 3) {
    goto _l40;
  }
  rg_[0] = -ri_[0] / alfp1_;
  rg_[1] = -(ralf_ + ralf_) / (alfp2_ * alfp2_) - rg_[0];
  an_ = 2.0;
  anm1_ = 1.0;
  im1_ = 2;
  for (i_ = 3; i_ <= 25; (i_)++) {
    rg_[i_ - 1] = -(an_ * (an_ - alfp2_) * rg_[im1_ - 1] - an_ * ri_[im1_ - 1] + anm1_ * ri_[i_ - 1]) / (anm1_ * (an_ + 
    alfp1_));
    anm1_ = an_;
    an_ = an_ + 0.1e1;
    im1_ = i_;
  }
  if ((*integr_) == 2) {
    goto _l70;
  }
  _l40:;
  rh_[0] = -rj_[0] / betp1_;
  rh_[1] = -(rbet_ + rbet_) / (betp2_ * betp2_) - rh_[0];
  an_ = 2.0;
  anm1_ = 1.0;
  im1_ = 2;
  for (i_ = 3; i_ <= 25; (i_)++) {
    rh_[i_ - 1] = -(an_ * (an_ - betp2_) * rh_[im1_ - 1] - an_ * rj_[im1_ - 1] + anm1_ * rj_[i_ - 1]) / (anm1_ * (an_ + 
    betp1_));
    anm1_ = an_;
    an_ = an_ + 0.1e1;
    im1_ = i_;
  }
  for (i_ = 2; (2 > 0 ? i_ <= 25 : i_ >= 25); i_ += 2) {
    rh_[i_ - 1] = -rh_[i_ - 1];
  }
  _l70:;
  for (i_ = 2; (2 > 0 ? i_ <= 25 : i_ >= 25); i_ += 2) {
    rj_[i_ - 1] = -rj_[i_ - 1];
  }
  __calls[29].calls++;
  return 0;
}

int_4 _dqnc79 (real_8 (*_fun)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ err_, real_8 _p_ ans_, int_4 _p_ ierr_, int_4 
_p_ k_)
{
  static int_4 i_, kml_, kmx_, l_, lmn_, lmx_, nbits_, nib_, nlmn_, nlmx_, lr_[99];
  static logical_4 first_;
  static real_8 ae_, area_, bank_, blocal_, c_, ce_, ee_, ef_, eps_, q13_, q7_, q7l_, sq2_, test_, tol_, vr_, w1_, w2_, 
  w3_, w4_, aa_[99], f_[13], f1_[99], f2_[99], f3_[99], f4_[99], f5_[99], f6_[99], f7_[99], hh_[99], q7r_[99], vl_[99];
  int_4 _data_k_292, _data_k_293, _data_k_294, _data_k_295, $0_, $1_, $2_, $7_, $8_, $9_;
  real_8 $3_, $4_, $5_, $6_;
  char_127 $10_;
  extern real_8 _d1mach ();
  extern int_4 _i1mach ();
  extern int_4 _xermsg ();
#define _data_n_292 1
  static int_4 _data_l_292[_data_n_292] = {
    7
  };
#define _data_n_293 1
  static int_4 _data_l_293[_data_n_293] = {
    5000
  };
#define _data_n_294 1
  static int_4 _data_l_294[_data_n_294] = {
    2
  };
#define _data_n_295 1
  static logical_4 _data_l_295[_data_n_295] = {
    TRUE
  };
  if (__calls[30].calls == 0) {
    _data_k_292 = 0;
    if (_data_k_292 >= _data_n_292) {
      _data_k_292 = 0;
    }
    kml_ = _data_l_292[_data_k_292++];
    _data_k_293 = 0;
    if (_data_k_293 >= _data_n_293) {
      _data_k_293 = 0;
    }
    kmx_ = _data_l_293[_data_k_293++];
    _data_k_294 = 0;
    if (_data_k_294 >= _data_n_294) {
      _data_k_294 = 0;
    }
    nlmn_ = _data_l_294[_data_k_294++];
  }
  if (__calls[30].calls == 0) {
    _data_k_295 = 0;
    if (_data_k_295 >= _data_n_295) {
      _data_k_295 = 0;
    }
    first_ = _data_l_295[_data_k_295++];
  }
  if (first_) {
    w1_ = 2.9285714285714286e-1;
    w2_ = 1.5428571428571429;
    w3_ = 1.9285714285714286e-1;
    w4_ = 1.9428571428571429;
    nbits_ = _d1mach (($0_ = 5, &$0_)) * _i1mach (($1_ = 14, &$1_)) / 0.30102e0;
    nlmx_ = _min (99, (nbits_ * 4) / 5);
    sq2_ = 1.414213562373095;
  }
  first_ = FALSE;
  (*ans_) = 0.0;
  (*ierr_) = 1;
  ce_ = 0.0;
  if ((*a_) == (*b_)) {
    goto _l260;
  }
  lmx_ = nlmx_;
  lmn_ = nlmn_;
  if ((*b_) == 0.0e0) {
    goto _l100;
  }
  if (_sign (1.0, (*b_)) * (*a_) <= 0.0e0) {
    goto _l100;
  }
  c_ = _abs (1.0e0 - (*a_) / (*b_));
  if (c_ > 0.1e0) {
    goto _l100;
  }
  if (c_ <= 0.0e0) {
    goto _l260;
  }
  nib_ = 0.5e0 - log (c_) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1;
  lmx_ = _min (nlmx_, nbits_ - nib_ - 4);
  if (lmx_ < 2) {
    goto _l260;
  }
  lmn_ = _min (lmn_, lmx_);
  _l100:;
  tol_ = _max (_abs ((*err_)), _up_real_8 (2.0e0, (5 - nbits_)));
  if ((*err_) == 0.0e0) {
    tol_ = sqrt (_d1mach (($2_ = 4, &$2_)));
  }
  eps_ = tol_;
  hh_[0] = ((*b_) - (*a_)) / 12.0e0;
  aa_[0] = (*a_);
  lr_[0] = 1;
  for (i_ = 1; (2 > 0 ? i_ <= 11 : i_ >= 11); i_ += 2) {
    f_[i_ - 1] = _fun (($3_ = (*a_) + (i_ - 1) * hh_[0], &$3_));
  }
  blocal_ = (*b_);
  f_[12] = _fun (&blocal_);
  (*k_) = 7;
  l_ = 1;
  area_ = 0.0;
  q7_ = 0.0;
  ef_ = 1.003921568627451;
  bank_ = 0.0;
  _l120:;
  for (i_ = 2; (2 > 0 ? i_ <= 12 : i_ >= 12); i_ += 2) {
    f_[i_ - 1] = _fun (($4_ = aa_[l_ - 1] + (i_ - 1) * hh_[l_ - 1], &$4_));
  }
  (*k_) = (*k_) + 6;
  q7l_ = hh_[l_ - 1] * ((w1_ * (f_[0] + f_[6]) + w2_ * (f_[1] + f_[5])) + (w3_ * (f_[2] + f_[4]) + w4_ * f_[3]));
  q7r_[l_ - 1] = hh_[l_ - 1] * ((w1_ * (f_[6] + f_[12]) + w2_ * (f_[7] + f_[11])) + (w3_ * (f_[8] + f_[10]) + w4_ * 
  f_[9]));
  area_ = area_ + (_abs (q7l_) + _abs (q7r_[l_ - 1]) - _abs (q7_));
  if (l_ < lmn_) {
    goto _l180;
  }
  q13_ = q7l_ + q7r_[l_ - 1];
  ee_ = _abs (q7_ - q13_) * ef_;
  ae_ = eps_ * area_;
  test_ = _min (ae_ + 0.8e0 * bank_, 10.0e0 * ae_);
  test_ = ($5_ = _max (test_, tol_ * _abs (q13_)), _max ($5_, 0.00003e0 * tol_ * area_));
  $6_ = ee_ - test_;
  if ($6_ < 0) {
    goto _l150;
  } else if ($6_ == 0) {
    goto _l150;
  } else {
    goto _l170;
  }
  _l140:;
  ce_ = ce_ + (q7_ - q13_);
  goto _l160;
  _l150:;
  ce_ = ce_ + (q7_ - q13_) / 255.0e0;
  _l160:;
  bank_ = bank_ + (ae_ - ee_);
  if (bank_ < 0.0e0) {
    bank_ = 0.0;
  }
  $7_ = lr_[l_ - 1];
  if ($7_ < 0) {
    goto _l190;
  } else if ($7_ == 0) {
    goto _l190;
  } else {
    goto _l210;
  }
  _l170:;
  if ((*k_) > kmx_) {
    lmx_ = _min (kml_, lmx_);
  }
  if (l_ >= lmx_) {
    goto _l140;
  }
  _l180:;
  l_ = l_ + 1;
  eps_ = eps_ * 0.5e0;
  if (l_ <= 17) {
    ef_ = ef_ / sq2_;
  }
  hh_[l_ - 1] = hh_[l_ - 1 - 1] * 0.5e0;
  lr_[l_ - 1] = -1;
  aa_[l_ - 1] = aa_[l_ - 1 - 1];
  q7_ = q7l_;
  f1_[l_ - 1] = f_[6];
  f2_[l_ - 1] = f_[7];
  f3_[l_ - 1] = f_[8];
  f4_[l_ - 1] = f_[9];
  f5_[l_ - 1] = f_[10];
  f6_[l_ - 1] = f_[11];
  f7_[l_ - 1] = f_[12];
  f_[12] = f_[6];
  f_[10] = f_[5];
  f_[8] = f_[4];
  f_[6] = f_[3];
  f_[4] = f_[2];
  f_[2] = f_[1];
  goto _l120;
  _l190:;
  vl_[l_ - 1] = q13_;
  _l200:;
  q7_ = q7r_[l_ - 1 - 1];
  lr_[l_ - 1] = 1;
  aa_[l_ - 1] = aa_[l_ - 1] + 12.0e0 * hh_[l_ - 1];
  f_[0] = f1_[l_ - 1];
  f_[2] = f2_[l_ - 1];
  f_[4] = f3_[l_ - 1];
  f_[6] = f4_[l_ - 1];
  f_[8] = f5_[l_ - 1];
  f_[10] = f6_[l_ - 1];
  f_[12] = f7_[l_ - 1];
  goto _l120;
  _l210:;
  vr_ = q13_;
  _l220:;
  if (l_ <= 1) {
    goto _l250;
  }
  if (l_ <= 17) {
    ef_ = ef_ * sq2_;
  }
  eps_ = eps_ * 2.0e0;
  l_ = l_ - 1;
  $8_ = lr_[l_ - 1];
  if ($8_ < 0) {
    goto _l230;
  } else if ($8_ == 0) {
    goto _l230;
  } else {
    goto _l240;
  }
  _l230:;
  vl_[l_ - 1] = vl_[l_ + 1 - 1] + vr_;
  goto _l200;
  _l240:;
  vr_ = vl_[l_ + 1 - 1] + vr_;
  goto _l220;
  _l250:;
  (*ans_) = vr_;
  if (_abs (ce_) <= 2.0e0 * tol_ * area_) {
    goto _l270;
  }
  (*ierr_) = 2;
  (void) _xermsg (_dc_0, _dc_10, _dc_11, ($9_ = 2, &$9_), &_k1);
  goto _l270;
  _l260:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_10, concat ($10_, _dc_12, _dc_13), &_km1, &_km1);
  _l270:;
  __calls[30].calls++;
  return 0;
}

int_4 _dqng (real_8 (*_f)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ epsabs_, real_8 _p_ epsrel_, real_8 _p_ result_, 
real_8 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_)
{
  static int_4 ipx_, k_, l_;
  static real_8 absc_, centr_, dhlgth_, epmach_, fcentr_, fval_, fval1_, fval2_, fv1_[5], fv2_[5], fv3_[5], fv4_[5], 
  hlgth_, res10_, res21_, res43_, res87_, resabs_, resasc_, reskh_, savfun_[21], uflow_, w10_[5], w21a_[5], w21b_[6], 
  w43a_[10], w43b_[12], w87a_[21], w87b_[23], x1_[5], x2_[5], x3_[11], x4_[22];
  int_4 _data_k_296, _data_k_297, _data_k_298, _data_k_299, _data_k_300, _data_k_301, _data_k_302, _data_k_303, 
  _data_k_304, _data_k_305, _data_k_306, _data_k_307, _data_k_308, _data_k_309, _data_k_310, _data_k_311, _data_k_312, 
  _data_k_313, _data_k_314, _data_k_315, _data_k_316, _data_k_317, _data_k_318, _data_k_319, _data_k_320, _data_k_321, 
  _data_k_322, _data_k_323, _data_k_324, _data_k_325, _data_k_326, _data_k_327, _data_k_328, _data_k_329, _data_k_330, 
  _data_k_331, _data_k_332, _data_k_333, _data_k_334, _data_k_335, _data_k_336, _data_k_337, _data_k_338, _data_k_339, 
  _data_k_340, _data_k_341, _data_k_342, _data_k_343, _data_k_344, _data_k_345, _data_k_346, _data_k_347, _data_k_348, 
  _data_k_349, _data_k_350, _data_k_351, _data_k_352, _data_k_353, _data_k_354, _data_k_355, _data_k_356, _data_k_357, 
  _data_k_358, _data_k_359, _data_k_360, _data_k_361, _data_k_362, _data_k_363, _data_k_364, _data_k_365, _data_k_366, 
  _data_k_367, _data_k_368, _data_k_369, _data_k_370, _data_k_371, _data_k_372, _data_k_373, _data_k_374, _data_k_375, 
  _data_k_376, _data_k_377, _data_k_378, _data_k_379, _data_k_380, _data_k_381, _data_k_382, _data_k_383, _data_k_384, 
  _data_k_385, _data_k_386, _data_k_387, _data_k_388, _data_k_389, _data_k_390, _data_k_391, _data_k_392, _data_k_393, 
  _data_k_394, _data_k_395, _data_k_396, _data_k_397, _data_k_398, _data_k_399, _data_k_400, _data_k_401, _data_k_402, 
  _data_k_403, _data_k_404, _data_k_405, _data_k_406, _data_k_407, _data_k_408, _data_k_409, _data_k_410, _data_k_411, 
  _data_k_412, _data_k_413, _data_k_414, _data_k_415, _data_k_416, _data_k_417, _data_k_418, _data_k_419, _data_k_420, 
  $0_;
  real_8 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern real_8 _d1mach ();
#define _data_n_296 1
  static real_8 _data_l_296[_data_n_296] = {
    0.973906528517171720077964012084452e0
  };
#define _data_n_297 1
  static real_8 _data_l_297[_data_n_297] = {
    0.865063366688984510732096688423493e0
  };
#define _data_n_298 1
  static real_8 _data_l_298[_data_n_298] = {
    0.679409568299024406234327365114874e0
  };
#define _data_n_299 1
  static real_8 _data_l_299[_data_n_299] = {
    0.433395394129247190799265943165784e0
  };
#define _data_n_300 1
  static real_8 _data_l_300[_data_n_300] = {
    0.14887433898163121088482600112972e0
  };
#define _data_n_301 1
  static real_8 _data_l_301[_data_n_301] = {
    0.066671344308688137593568809893332e0
  };
#define _data_n_302 1
  static real_8 _data_l_302[_data_n_302] = {
    0.149451349150580593145776339657697e0
  };
#define _data_n_303 1
  static real_8 _data_l_303[_data_n_303] = {
    0.219086362515982043995534934228163e0
  };
#define _data_n_304 1
  static real_8 _data_l_304[_data_n_304] = {
    0.269266719309996355091226921569469e0
  };
#define _data_n_305 1
  static real_8 _data_l_305[_data_n_305] = {
    0.295524224714752870173892994651338e0
  };
#define _data_n_306 1
  static real_8 _data_l_306[_data_n_306] = {
    0.995657163025808080735527280689003e0
  };
#define _data_n_307 1
  static real_8 _data_l_307[_data_n_307] = {
    0.930157491355708226001207180059508e0
  };
#define _data_n_308 1
  static real_8 _data_l_308[_data_n_308] = {
    0.780817726586416897063717578345042e0
  };
#define _data_n_309 1
  static real_8 _data_l_309[_data_n_309] = {
    0.562757134668604683339000099272694e0
  };
#define _data_n_310 1
  static real_8 _data_l_310[_data_n_310] = {
    0.294392862701460198131126603103866e0
  };
#define _data_n_311 1
  static real_8 _data_l_311[_data_n_311] = {
    0.03255816230796472747881897245939e0
  };
#define _data_n_312 1
  static real_8 _data_l_312[_data_n_312] = {
    0.07503967481091995276704314091619e0
  };
#define _data_n_313 1
  static real_8 _data_l_313[_data_n_313] = {
    0.109387158802297641899210590325805e0
  };
#define _data_n_314 1
  static real_8 _data_l_314[_data_n_314] = {
    0.134709217311473325928054001771707e0
  };
#define _data_n_315 1
  static real_8 _data_l_315[_data_n_315] = {
    0.147739104901338491374841515972068e0
  };
#define _data_n_316 1
  static real_8 _data_l_316[_data_n_316] = {
    0.011694638867371874278064396062192e0
  };
#define _data_n_317 1
  static real_8 _data_l_317[_data_n_317] = {
    0.05475589657435199603138130024458e0
  };
#define _data_n_318 1
  static real_8 _data_l_318[_data_n_318] = {
    0.093125454583697605535065465083366e0
  };
#define _data_n_319 1
  static real_8 _data_l_319[_data_n_319] = {
    0.123491976262065851077958109831074e0
  };
#define _data_n_320 1
  static real_8 _data_l_320[_data_n_320] = {
    0.142775938577060080797094273138717e0
  };
#define _data_n_321 1
  static real_8 _data_l_321[_data_n_321] = {
    0.149445554002916905664936468389821e0
  };
#define _data_n_322 1
  static real_8 _data_l_322[_data_n_322] = {
    0.999333360901932081394099323919911e0
  };
#define _data_n_323 1
  static real_8 _data_l_323[_data_n_323] = {
    0.987433402908088869795961478381209e0
  };
#define _data_n_324 1
  static real_8 _data_l_324[_data_n_324] = {
    0.954807934814266299257919200290473e0
  };
#define _data_n_325 1
  static real_8 _data_l_325[_data_n_325] = {
    0.900148695748328293625099494069092e0
  };
#define _data_n_326 1
  static real_8 _data_l_326[_data_n_326] = {
    0.82519831498311415084706673258852e0
  };
#define _data_n_327 1
  static real_8 _data_l_327[_data_n_327] = {
    0.732148388989304982612354848755461e0
  };
#define _data_n_328 1
  static real_8 _data_l_328[_data_n_328] = {
    0.622847970537725238641159120344323e0
  };
#define _data_n_329 1
  static real_8 _data_l_329[_data_n_329] = {
    0.499479574071056499952214885499755e0
  };
#define _data_n_330 1
  static real_8 _data_l_330[_data_n_330] = {
    0.364901661346580768043989548502644e0
  };
#define _data_n_331 1
  static real_8 _data_l_331[_data_n_331] = {
    0.222254919776601296498260928066212e0
  };
#define _data_n_332 1
  static real_8 _data_l_332[_data_n_332] = {
    0.074650617461383322043914435796506e0
  };
#define _data_n_333 1
  static real_8 _data_l_333[_data_n_333] = {
    0.016296734289666564924281974617663e0
  };
#define _data_n_334 1
  static real_8 _data_l_334[_data_n_334] = {
    0.037522876120869501461613795898115e0
  };
#define _data_n_335 1
  static real_8 _data_l_335[_data_n_335] = {
    0.054694902058255442147212685465005e0
  };
#define _data_n_336 1
  static real_8 _data_l_336[_data_n_336] = {
    0.067355414609478086075553166302174e0
  };
#define _data_n_337 1
  static real_8 _data_l_337[_data_n_337] = {
    0.073870199632393953432140695251367e0
  };
#define _data_n_338 1
  static real_8 _data_l_338[_data_n_338] = {
    0.005768556059769796184184327908655e0
  };
#define _data_n_339 1
  static real_8 _data_l_339[_data_n_339] = {
    0.027371890593248842081276069289151e0
  };
#define _data_n_340 1
  static real_8 _data_l_340[_data_n_340] = {
    0.046560826910428830743339154433824e0
  };
#define _data_n_341 1
  static real_8 _data_l_341[_data_n_341] = {
    0.061744995201442564496240336030883e0
  };
#define _data_n_342 1
  static real_8 _data_l_342[_data_n_342] = {
    0.071387267268693397768559114425516e0
  };
#define _data_n_343 1
  static real_8 _data_l_343[_data_n_343] = {
    0.001844477640212414100389106552965e0
  };
#define _data_n_344 1
  static real_8 _data_l_344[_data_n_344] = {
    0.010798689585891651740465406741293e0
  };
#define _data_n_345 1
  static real_8 _data_l_345[_data_n_345] = {
    0.021895363867795428102523123075149e0
  };
#define _data_n_346 1
  static real_8 _data_l_346[_data_n_346] = {
    0.032597463975345689443882222526137e0
  };
#define _data_n_347 1
  static real_8 _data_l_347[_data_n_347] = {
    0.042163137935191811847627924327955e0
  };
#define _data_n_348 1
  static real_8 _data_l_348[_data_n_348] = {
    0.050741939600184577780189020092084e0
  };
#define _data_n_349 1
  static real_8 _data_l_349[_data_n_349] = {
    0.058379395542619248375475369330206e0
  };
#define _data_n_350 1
  static real_8 _data_l_350[_data_n_350] = {
    0.064746404951445885544689259517511e0
  };
#define _data_n_351 1
  static real_8 _data_l_351[_data_n_351] = {
    0.069566197912356484528633315038405e0
  };
#define _data_n_352 1
  static real_8 _data_l_352[_data_n_352] = {
    0.072824441471833208150939535192842e0
  };
#define _data_n_353 1
  static real_8 _data_l_353[_data_n_353] = {
    0.074507751014175118273571813842889e0
  };
#define _data_n_354 1
  static real_8 _data_l_354[_data_n_354] = {
    0.074722147517403005594425168280423e0
  };
#define _data_n_355 1
  static real_8 _data_l_355[_data_n_355] = {
    0.999902977262729234490529830591582e0
  };
#define _data_n_356 1
  static real_8 _data_l_356[_data_n_356] = {
    0.99798989598667874542749632236596e0
  };
#define _data_n_357 1
  static real_8 _data_l_357[_data_n_357] = {
    0.992175497860687222808523352251425e0
  };
#define _data_n_358 1
  static real_8 _data_l_358[_data_n_358] = {
    0.981358163572712773571916941623894e0
  };
#define _data_n_359 1
  static real_8 _data_l_359[_data_n_359] = {
    0.965057623858384619128284110607926e0
  };
#define _data_n_360 1
  static real_8 _data_l_360[_data_n_360] = {
    0.943167613133670596816416634507426e0
  };
#define _data_n_361 1
  static real_8 _data_l_361[_data_n_361] = {
    0.91580641468550720959182643072005e0
  };
#define _data_n_362 1
  static real_8 _data_l_362[_data_n_362] = {
    0.883221657771316501372117548744163e0
  };
#define _data_n_363 1
  static real_8 _data_l_363[_data_n_363] = {
    0.845710748462415666605902011504855e0
  };
#define _data_n_364 1
  static real_8 _data_l_364[_data_n_364] = {
    0.803557658035230982788739474980964e0
  };
#define _data_n_365 1
  static real_8 _data_l_365[_data_n_365] = {
    0.75700573068549555832894279343202e0
  };
#define _data_n_366 1
  static real_8 _data_l_366[_data_n_366] = {
    0.70627320978732181982409427474084e0
  };
#define _data_n_367 1
  static real_8 _data_l_367[_data_n_367] = {
    0.651589466501177922534422205016736e0
  };
#define _data_n_368 1
  static real_8 _data_l_368[_data_n_368] = {
    0.593223374057961088875273770349144e0
  };
#define _data_n_369 1
  static real_8 _data_l_369[_data_n_369] = {
    0.531493605970831932285268948562671e0
  };
#define _data_n_370 1
  static real_8 _data_l_370[_data_n_370] = {
    0.46676362304202284487196678165927e0
  };
#define _data_n_371 1
  static real_8 _data_l_371[_data_n_371] = {
    0.399424847859218804732101665817923e0
  };
#define _data_n_372 1
  static real_8 _data_l_372[_data_n_372] = {
    0.329874877106188288265053371824597e0
  };
#define _data_n_373 1
  static real_8 _data_l_373[_data_n_373] = {
    0.258503559202161551802280975429025e0
  };
#define _data_n_374 1
  static real_8 _data_l_374[_data_n_374] = {
    0.185695396568346652015917141167606e0
  };
#define _data_n_375 1
  static real_8 _data_l_375[_data_n_375] = {
    0.111842213179907468172398359241362e0
  };
#define _data_n_376 1
  static real_8 _data_l_376[_data_n_376] = {
    0.037352123394619870814998165437704e0
  };
#define _data_n_377 1
  static real_8 _data_l_377[_data_n_377] = {
    0.00814837738414917290000287844819e0
  };
#define _data_n_378 1
  static real_8 _data_l_378[_data_n_378] = {
    0.018761438201562822243935059003794e0
  };
#define _data_n_379 1
  static real_8 _data_l_379[_data_n_379] = {
    0.027347451050052286161582829741283e0
  };
#define _data_n_380 1
  static real_8 _data_l_380[_data_n_380] = {
    0.033677707311637930046581056957588e0
  };
#define _data_n_381 1
  static real_8 _data_l_381[_data_n_381] = {
    0.036935099820427907614589586742499e0
  };
#define _data_n_382 1
  static real_8 _data_l_382[_data_n_382] = {
    0.002884872430211530501334156248695e0
  };
#define _data_n_383 1
  static real_8 _data_l_383[_data_n_383] = {
    0.013685946022712701888950035273128e0
  };
#define _data_n_384 1
  static real_8 _data_l_384[_data_n_384] = {
    0.023280413502888311123409291030404e0
  };
#define _data_n_385 1
  static real_8 _data_l_385[_data_n_385] = {
    0.030872497611713358675466394126442e0
  };
#define _data_n_386 1
  static real_8 _data_l_386[_data_n_386] = {
    0.035693633639418770719351355457044e0
  };
#define _data_n_387 1
  static real_8 _data_l_387[_data_n_387] = {
    0.000915283345202241360843392549948e0
  };
#define _data_n_388 1
  static real_8 _data_l_388[_data_n_388] = {
    0.005399280219300471367738743391053e0
  };
#define _data_n_389 1
  static real_8 _data_l_389[_data_n_389] = {
    0.010947679601118931134327826856808e0
  };
#define _data_n_390 1
  static real_8 _data_l_390[_data_n_390] = {
    0.01629873169678733526266570322328e0
  };
#define _data_n_391 1
  static real_8 _data_l_391[_data_n_391] = {
    0.02108156888920383511243306018819e0
  };
#define _data_n_392 1
  static real_8 _data_l_392[_data_n_392] = {
    0.02537096976925382724346799983171e0
  };
#define _data_n_393 1
  static real_8 _data_l_393[_data_n_393] = {
    0.02918969775647575250144615408492e0
  };
#define _data_n_394 1
  static real_8 _data_l_394[_data_n_394] = {
    0.032373202467202789685788194889595e0
  };
#define _data_n_395 1
  static real_8 _data_l_395[_data_n_395] = {
    0.034783098950365142750781997949596e0
  };
#define _data_n_396 1
  static real_8 _data_l_396[_data_n_396] = {
    0.036412220731351787562801163687577e0
  };
#define _data_n_397 1
  static real_8 _data_l_397[_data_n_397] = {
    0.037253875503047708539592001191226e0
  };
#define _data_n_398 1
  static real_8 _data_l_398[_data_n_398] = {
    0.000274145563762072350016527092881e0
  };
#define _data_n_399 1
  static real_8 _data_l_399[_data_n_399] = {
    0.001807124155057942948341311753254e0
  };
#define _data_n_400 1
  static real_8 _data_l_400[_data_n_400] = {
    0.00409686928275916486445807068348e0
  };
#define _data_n_401 1
  static real_8 _data_l_401[_data_n_401] = {
    0.006758290051847378699816577897424e0
  };
#define _data_n_402 1
  static real_8 _data_l_402[_data_n_402] = {
    0.009549957672201646536053581325377e0
  };
#define _data_n_403 1
  static real_8 _data_l_403[_data_n_403] = {
    0.01232944765224485369462663996378e0
  };
#define _data_n_404 1
  static real_8 _data_l_404[_data_n_404] = {
    0.015010447346388952376697286041943e0
  };
#define _data_n_405 1
  static real_8 _data_l_405[_data_n_405] = {
    0.0175489679862431910996653529259e0
  };
#define _data_n_406 1
  static real_8 _data_l_406[_data_n_406] = {
    0.019938037786440888202278192730714e0
  };
#define _data_n_407 1
  static real_8 _data_l_407[_data_n_407] = {
    0.022194935961012286796332102959499e0
  };
#define _data_n_408 1
  static real_8 _data_l_408[_data_n_408] = {
    0.024339147126000805470360647041454e0
  };
#define _data_n_409 1
  static real_8 _data_l_409[_data_n_409] = {
    0.026374505414839207241503786552615e0
  };
#define _data_n_410 1
  static real_8 _data_l_410[_data_n_410] = {
    0.02828691078877120065996800298796e0
  };
#define _data_n_411 1
  static real_8 _data_l_411[_data_n_411] = {
    0.030052581128092695322521110347341e0
  };
#define _data_n_412 1
  static real_8 _data_l_412[_data_n_412] = {
    0.031646751371439929404586051078883e0
  };
#define _data_n_413 1
  static real_8 _data_l_413[_data_n_413] = {
    0.033050413419978503290785944862689e0
  };
#define _data_n_414 1
  static real_8 _data_l_414[_data_n_414] = {
    0.034255099704226061787082821046821e0
  };
#define _data_n_415 1
  static real_8 _data_l_415[_data_n_415] = {
    0.035262412660156681033782717998428e0
  };
#define _data_n_416 1
  static real_8 _data_l_416[_data_n_416] = {
    0.036076989622888701185500318003895e0
  };
#define _data_n_417 1
  static real_8 _data_l_417[_data_n_417] = {
    0.036698604498456094498018047441094e0
  };
#define _data_n_418 1
  static real_8 _data_l_418[_data_n_418] = {
    0.037120549269832576114119958413599e0
  };
#define _data_n_419 1
  static real_8 _data_l_419[_data_n_419] = {
    0.037334228751935040321235449094698e0
  };
#define _data_n_420 1
  static real_8 _data_l_420[_data_n_420] = {
    0.037361073762679023410321241766599e0
  };
  if (__calls[31].calls == 0) {
    _data_k_296 = 0;
    if (_data_k_296 >= _data_n_296) {
      _data_k_296 = 0;
    }
    x1_[0] = _data_l_296[_data_k_296++];
  }
  if (__calls[31].calls == 0) {
    _data_k_297 = 0;
    if (_data_k_297 >= _data_n_297) {
      _data_k_297 = 0;
    }
    x1_[1] = _data_l_297[_data_k_297++];
  }
  if (__calls[31].calls == 0) {
    _data_k_298 = 0;
    if (_data_k_298 >= _data_n_298) {
      _data_k_298 = 0;
    }
    x1_[2] = _data_l_298[_data_k_298++];
  }
  if (__calls[31].calls == 0) {
    _data_k_299 = 0;
    if (_data_k_299 >= _data_n_299) {
      _data_k_299 = 0;
    }
    x1_[3] = _data_l_299[_data_k_299++];
  }
  if (__calls[31].calls == 0) {
    _data_k_300 = 0;
    if (_data_k_300 >= _data_n_300) {
      _data_k_300 = 0;
    }
    x1_[4] = _data_l_300[_data_k_300++];
  }
  if (__calls[31].calls == 0) {
    _data_k_301 = 0;
    if (_data_k_301 >= _data_n_301) {
      _data_k_301 = 0;
    }
    w10_[0] = _data_l_301[_data_k_301++];
  }
  if (__calls[31].calls == 0) {
    _data_k_302 = 0;
    if (_data_k_302 >= _data_n_302) {
      _data_k_302 = 0;
    }
    w10_[1] = _data_l_302[_data_k_302++];
  }
  if (__calls[31].calls == 0) {
    _data_k_303 = 0;
    if (_data_k_303 >= _data_n_303) {
      _data_k_303 = 0;
    }
    w10_[2] = _data_l_303[_data_k_303++];
  }
  if (__calls[31].calls == 0) {
    _data_k_304 = 0;
    if (_data_k_304 >= _data_n_304) {
      _data_k_304 = 0;
    }
    w10_[3] = _data_l_304[_data_k_304++];
  }
  if (__calls[31].calls == 0) {
    _data_k_305 = 0;
    if (_data_k_305 >= _data_n_305) {
      _data_k_305 = 0;
    }
    w10_[4] = _data_l_305[_data_k_305++];
  }
  if (__calls[31].calls == 0) {
    _data_k_306 = 0;
    if (_data_k_306 >= _data_n_306) {
      _data_k_306 = 0;
    }
    x2_[0] = _data_l_306[_data_k_306++];
  }
  if (__calls[31].calls == 0) {
    _data_k_307 = 0;
    if (_data_k_307 >= _data_n_307) {
      _data_k_307 = 0;
    }
    x2_[1] = _data_l_307[_data_k_307++];
  }
  if (__calls[31].calls == 0) {
    _data_k_308 = 0;
    if (_data_k_308 >= _data_n_308) {
      _data_k_308 = 0;
    }
    x2_[2] = _data_l_308[_data_k_308++];
  }
  if (__calls[31].calls == 0) {
    _data_k_309 = 0;
    if (_data_k_309 >= _data_n_309) {
      _data_k_309 = 0;
    }
    x2_[3] = _data_l_309[_data_k_309++];
  }
  if (__calls[31].calls == 0) {
    _data_k_310 = 0;
    if (_data_k_310 >= _data_n_310) {
      _data_k_310 = 0;
    }
    x2_[4] = _data_l_310[_data_k_310++];
  }
  if (__calls[31].calls == 0) {
    _data_k_311 = 0;
    if (_data_k_311 >= _data_n_311) {
      _data_k_311 = 0;
    }
    w21a_[0] = _data_l_311[_data_k_311++];
  }
  if (__calls[31].calls == 0) {
    _data_k_312 = 0;
    if (_data_k_312 >= _data_n_312) {
      _data_k_312 = 0;
    }
    w21a_[1] = _data_l_312[_data_k_312++];
  }
  if (__calls[31].calls == 0) {
    _data_k_313 = 0;
    if (_data_k_313 >= _data_n_313) {
      _data_k_313 = 0;
    }
    w21a_[2] = _data_l_313[_data_k_313++];
  }
  if (__calls[31].calls == 0) {
    _data_k_314 = 0;
    if (_data_k_314 >= _data_n_314) {
      _data_k_314 = 0;
    }
    w21a_[3] = _data_l_314[_data_k_314++];
  }
  if (__calls[31].calls == 0) {
    _data_k_315 = 0;
    if (_data_k_315 >= _data_n_315) {
      _data_k_315 = 0;
    }
    w21a_[4] = _data_l_315[_data_k_315++];
  }
  if (__calls[31].calls == 0) {
    _data_k_316 = 0;
    if (_data_k_316 >= _data_n_316) {
      _data_k_316 = 0;
    }
    w21b_[0] = _data_l_316[_data_k_316++];
  }
  if (__calls[31].calls == 0) {
    _data_k_317 = 0;
    if (_data_k_317 >= _data_n_317) {
      _data_k_317 = 0;
    }
    w21b_[1] = _data_l_317[_data_k_317++];
  }
  if (__calls[31].calls == 0) {
    _data_k_318 = 0;
    if (_data_k_318 >= _data_n_318) {
      _data_k_318 = 0;
    }
    w21b_[2] = _data_l_318[_data_k_318++];
  }
  if (__calls[31].calls == 0) {
    _data_k_319 = 0;
    if (_data_k_319 >= _data_n_319) {
      _data_k_319 = 0;
    }
    w21b_[3] = _data_l_319[_data_k_319++];
  }
  if (__calls[31].calls == 0) {
    _data_k_320 = 0;
    if (_data_k_320 >= _data_n_320) {
      _data_k_320 = 0;
    }
    w21b_[4] = _data_l_320[_data_k_320++];
  }
  if (__calls[31].calls == 0) {
    _data_k_321 = 0;
    if (_data_k_321 >= _data_n_321) {
      _data_k_321 = 0;
    }
    w21b_[5] = _data_l_321[_data_k_321++];
  }
  if (__calls[31].calls == 0) {
    _data_k_322 = 0;
    if (_data_k_322 >= _data_n_322) {
      _data_k_322 = 0;
    }
    x3_[0] = _data_l_322[_data_k_322++];
  }
  if (__calls[31].calls == 0) {
    _data_k_323 = 0;
    if (_data_k_323 >= _data_n_323) {
      _data_k_323 = 0;
    }
    x3_[1] = _data_l_323[_data_k_323++];
  }
  if (__calls[31].calls == 0) {
    _data_k_324 = 0;
    if (_data_k_324 >= _data_n_324) {
      _data_k_324 = 0;
    }
    x3_[2] = _data_l_324[_data_k_324++];
  }
  if (__calls[31].calls == 0) {
    _data_k_325 = 0;
    if (_data_k_325 >= _data_n_325) {
      _data_k_325 = 0;
    }
    x3_[3] = _data_l_325[_data_k_325++];
  }
  if (__calls[31].calls == 0) {
    _data_k_326 = 0;
    if (_data_k_326 >= _data_n_326) {
      _data_k_326 = 0;
    }
    x3_[4] = _data_l_326[_data_k_326++];
  }
  if (__calls[31].calls == 0) {
    _data_k_327 = 0;
    if (_data_k_327 >= _data_n_327) {
      _data_k_327 = 0;
    }
    x3_[5] = _data_l_327[_data_k_327++];
  }
  if (__calls[31].calls == 0) {
    _data_k_328 = 0;
    if (_data_k_328 >= _data_n_328) {
      _data_k_328 = 0;
    }
    x3_[6] = _data_l_328[_data_k_328++];
  }
  if (__calls[31].calls == 0) {
    _data_k_329 = 0;
    if (_data_k_329 >= _data_n_329) {
      _data_k_329 = 0;
    }
    x3_[7] = _data_l_329[_data_k_329++];
  }
  if (__calls[31].calls == 0) {
    _data_k_330 = 0;
    if (_data_k_330 >= _data_n_330) {
      _data_k_330 = 0;
    }
    x3_[8] = _data_l_330[_data_k_330++];
  }
  if (__calls[31].calls == 0) {
    _data_k_331 = 0;
    if (_data_k_331 >= _data_n_331) {
      _data_k_331 = 0;
    }
    x3_[9] = _data_l_331[_data_k_331++];
  }
  if (__calls[31].calls == 0) {
    _data_k_332 = 0;
    if (_data_k_332 >= _data_n_332) {
      _data_k_332 = 0;
    }
    x3_[10] = _data_l_332[_data_k_332++];
  }
  if (__calls[31].calls == 0) {
    _data_k_333 = 0;
    if (_data_k_333 >= _data_n_333) {
      _data_k_333 = 0;
    }
    w43a_[0] = _data_l_333[_data_k_333++];
  }
  if (__calls[31].calls == 0) {
    _data_k_334 = 0;
    if (_data_k_334 >= _data_n_334) {
      _data_k_334 = 0;
    }
    w43a_[1] = _data_l_334[_data_k_334++];
  }
  if (__calls[31].calls == 0) {
    _data_k_335 = 0;
    if (_data_k_335 >= _data_n_335) {
      _data_k_335 = 0;
    }
    w43a_[2] = _data_l_335[_data_k_335++];
  }
  if (__calls[31].calls == 0) {
    _data_k_336 = 0;
    if (_data_k_336 >= _data_n_336) {
      _data_k_336 = 0;
    }
    w43a_[3] = _data_l_336[_data_k_336++];
  }
  if (__calls[31].calls == 0) {
    _data_k_337 = 0;
    if (_data_k_337 >= _data_n_337) {
      _data_k_337 = 0;
    }
    w43a_[4] = _data_l_337[_data_k_337++];
  }
  if (__calls[31].calls == 0) {
    _data_k_338 = 0;
    if (_data_k_338 >= _data_n_338) {
      _data_k_338 = 0;
    }
    w43a_[5] = _data_l_338[_data_k_338++];
  }
  if (__calls[31].calls == 0) {
    _data_k_339 = 0;
    if (_data_k_339 >= _data_n_339) {
      _data_k_339 = 0;
    }
    w43a_[6] = _data_l_339[_data_k_339++];
  }
  if (__calls[31].calls == 0) {
    _data_k_340 = 0;
    if (_data_k_340 >= _data_n_340) {
      _data_k_340 = 0;
    }
    w43a_[7] = _data_l_340[_data_k_340++];
  }
  if (__calls[31].calls == 0) {
    _data_k_341 = 0;
    if (_data_k_341 >= _data_n_341) {
      _data_k_341 = 0;
    }
    w43a_[8] = _data_l_341[_data_k_341++];
  }
  if (__calls[31].calls == 0) {
    _data_k_342 = 0;
    if (_data_k_342 >= _data_n_342) {
      _data_k_342 = 0;
    }
    w43a_[9] = _data_l_342[_data_k_342++];
  }
  if (__calls[31].calls == 0) {
    _data_k_343 = 0;
    if (_data_k_343 >= _data_n_343) {
      _data_k_343 = 0;
    }
    w43b_[0] = _data_l_343[_data_k_343++];
  }
  if (__calls[31].calls == 0) {
    _data_k_344 = 0;
    if (_data_k_344 >= _data_n_344) {
      _data_k_344 = 0;
    }
    w43b_[1] = _data_l_344[_data_k_344++];
  }
  if (__calls[31].calls == 0) {
    _data_k_345 = 0;
    if (_data_k_345 >= _data_n_345) {
      _data_k_345 = 0;
    }
    w43b_[2] = _data_l_345[_data_k_345++];
  }
  if (__calls[31].calls == 0) {
    _data_k_346 = 0;
    if (_data_k_346 >= _data_n_346) {
      _data_k_346 = 0;
    }
    w43b_[3] = _data_l_346[_data_k_346++];
  }
  if (__calls[31].calls == 0) {
    _data_k_347 = 0;
    if (_data_k_347 >= _data_n_347) {
      _data_k_347 = 0;
    }
    w43b_[4] = _data_l_347[_data_k_347++];
  }
  if (__calls[31].calls == 0) {
    _data_k_348 = 0;
    if (_data_k_348 >= _data_n_348) {
      _data_k_348 = 0;
    }
    w43b_[5] = _data_l_348[_data_k_348++];
  }
  if (__calls[31].calls == 0) {
    _data_k_349 = 0;
    if (_data_k_349 >= _data_n_349) {
      _data_k_349 = 0;
    }
    w43b_[6] = _data_l_349[_data_k_349++];
  }
  if (__calls[31].calls == 0) {
    _data_k_350 = 0;
    if (_data_k_350 >= _data_n_350) {
      _data_k_350 = 0;
    }
    w43b_[7] = _data_l_350[_data_k_350++];
  }
  if (__calls[31].calls == 0) {
    _data_k_351 = 0;
    if (_data_k_351 >= _data_n_351) {
      _data_k_351 = 0;
    }
    w43b_[8] = _data_l_351[_data_k_351++];
  }
  if (__calls[31].calls == 0) {
    _data_k_352 = 0;
    if (_data_k_352 >= _data_n_352) {
      _data_k_352 = 0;
    }
    w43b_[9] = _data_l_352[_data_k_352++];
  }
  if (__calls[31].calls == 0) {
    _data_k_353 = 0;
    if (_data_k_353 >= _data_n_353) {
      _data_k_353 = 0;
    }
    w43b_[10] = _data_l_353[_data_k_353++];
  }
  if (__calls[31].calls == 0) {
    _data_k_354 = 0;
    if (_data_k_354 >= _data_n_354) {
      _data_k_354 = 0;
    }
    w43b_[11] = _data_l_354[_data_k_354++];
  }
  if (__calls[31].calls == 0) {
    _data_k_355 = 0;
    if (_data_k_355 >= _data_n_355) {
      _data_k_355 = 0;
    }
    x4_[0] = _data_l_355[_data_k_355++];
  }
  if (__calls[31].calls == 0) {
    _data_k_356 = 0;
    if (_data_k_356 >= _data_n_356) {
      _data_k_356 = 0;
    }
    x4_[1] = _data_l_356[_data_k_356++];
  }
  if (__calls[31].calls == 0) {
    _data_k_357 = 0;
    if (_data_k_357 >= _data_n_357) {
      _data_k_357 = 0;
    }
    x4_[2] = _data_l_357[_data_k_357++];
  }
  if (__calls[31].calls == 0) {
    _data_k_358 = 0;
    if (_data_k_358 >= _data_n_358) {
      _data_k_358 = 0;
    }
    x4_[3] = _data_l_358[_data_k_358++];
  }
  if (__calls[31].calls == 0) {
    _data_k_359 = 0;
    if (_data_k_359 >= _data_n_359) {
      _data_k_359 = 0;
    }
    x4_[4] = _data_l_359[_data_k_359++];
  }
  if (__calls[31].calls == 0) {
    _data_k_360 = 0;
    if (_data_k_360 >= _data_n_360) {
      _data_k_360 = 0;
    }
    x4_[5] = _data_l_360[_data_k_360++];
  }
  if (__calls[31].calls == 0) {
    _data_k_361 = 0;
    if (_data_k_361 >= _data_n_361) {
      _data_k_361 = 0;
    }
    x4_[6] = _data_l_361[_data_k_361++];
  }
  if (__calls[31].calls == 0) {
    _data_k_362 = 0;
    if (_data_k_362 >= _data_n_362) {
      _data_k_362 = 0;
    }
    x4_[7] = _data_l_362[_data_k_362++];
  }
  if (__calls[31].calls == 0) {
    _data_k_363 = 0;
    if (_data_k_363 >= _data_n_363) {
      _data_k_363 = 0;
    }
    x4_[8] = _data_l_363[_data_k_363++];
  }
  if (__calls[31].calls == 0) {
    _data_k_364 = 0;
    if (_data_k_364 >= _data_n_364) {
      _data_k_364 = 0;
    }
    x4_[9] = _data_l_364[_data_k_364++];
  }
  if (__calls[31].calls == 0) {
    _data_k_365 = 0;
    if (_data_k_365 >= _data_n_365) {
      _data_k_365 = 0;
    }
    x4_[10] = _data_l_365[_data_k_365++];
  }
  if (__calls[31].calls == 0) {
    _data_k_366 = 0;
    if (_data_k_366 >= _data_n_366) {
      _data_k_366 = 0;
    }
    x4_[11] = _data_l_366[_data_k_366++];
  }
  if (__calls[31].calls == 0) {
    _data_k_367 = 0;
    if (_data_k_367 >= _data_n_367) {
      _data_k_367 = 0;
    }
    x4_[12] = _data_l_367[_data_k_367++];
  }
  if (__calls[31].calls == 0) {
    _data_k_368 = 0;
    if (_data_k_368 >= _data_n_368) {
      _data_k_368 = 0;
    }
    x4_[13] = _data_l_368[_data_k_368++];
  }
  if (__calls[31].calls == 0) {
    _data_k_369 = 0;
    if (_data_k_369 >= _data_n_369) {
      _data_k_369 = 0;
    }
    x4_[14] = _data_l_369[_data_k_369++];
  }
  if (__calls[31].calls == 0) {
    _data_k_370 = 0;
    if (_data_k_370 >= _data_n_370) {
      _data_k_370 = 0;
    }
    x4_[15] = _data_l_370[_data_k_370++];
  }
  if (__calls[31].calls == 0) {
    _data_k_371 = 0;
    if (_data_k_371 >= _data_n_371) {
      _data_k_371 = 0;
    }
    x4_[16] = _data_l_371[_data_k_371++];
  }
  if (__calls[31].calls == 0) {
    _data_k_372 = 0;
    if (_data_k_372 >= _data_n_372) {
      _data_k_372 = 0;
    }
    x4_[17] = _data_l_372[_data_k_372++];
  }
  if (__calls[31].calls == 0) {
    _data_k_373 = 0;
    if (_data_k_373 >= _data_n_373) {
      _data_k_373 = 0;
    }
    x4_[18] = _data_l_373[_data_k_373++];
  }
  if (__calls[31].calls == 0) {
    _data_k_374 = 0;
    if (_data_k_374 >= _data_n_374) {
      _data_k_374 = 0;
    }
    x4_[19] = _data_l_374[_data_k_374++];
  }
  if (__calls[31].calls == 0) {
    _data_k_375 = 0;
    if (_data_k_375 >= _data_n_375) {
      _data_k_375 = 0;
    }
    x4_[20] = _data_l_375[_data_k_375++];
  }
  if (__calls[31].calls == 0) {
    _data_k_376 = 0;
    if (_data_k_376 >= _data_n_376) {
      _data_k_376 = 0;
    }
    x4_[21] = _data_l_376[_data_k_376++];
  }
  if (__calls[31].calls == 0) {
    _data_k_377 = 0;
    if (_data_k_377 >= _data_n_377) {
      _data_k_377 = 0;
    }
    w87a_[0] = _data_l_377[_data_k_377++];
  }
  if (__calls[31].calls == 0) {
    _data_k_378 = 0;
    if (_data_k_378 >= _data_n_378) {
      _data_k_378 = 0;
    }
    w87a_[1] = _data_l_378[_data_k_378++];
  }
  if (__calls[31].calls == 0) {
    _data_k_379 = 0;
    if (_data_k_379 >= _data_n_379) {
      _data_k_379 = 0;
    }
    w87a_[2] = _data_l_379[_data_k_379++];
  }
  if (__calls[31].calls == 0) {
    _data_k_380 = 0;
    if (_data_k_380 >= _data_n_380) {
      _data_k_380 = 0;
    }
    w87a_[3] = _data_l_380[_data_k_380++];
  }
  if (__calls[31].calls == 0) {
    _data_k_381 = 0;
    if (_data_k_381 >= _data_n_381) {
      _data_k_381 = 0;
    }
    w87a_[4] = _data_l_381[_data_k_381++];
  }
  if (__calls[31].calls == 0) {
    _data_k_382 = 0;
    if (_data_k_382 >= _data_n_382) {
      _data_k_382 = 0;
    }
    w87a_[5] = _data_l_382[_data_k_382++];
  }
  if (__calls[31].calls == 0) {
    _data_k_383 = 0;
    if (_data_k_383 >= _data_n_383) {
      _data_k_383 = 0;
    }
    w87a_[6] = _data_l_383[_data_k_383++];
  }
  if (__calls[31].calls == 0) {
    _data_k_384 = 0;
    if (_data_k_384 >= _data_n_384) {
      _data_k_384 = 0;
    }
    w87a_[7] = _data_l_384[_data_k_384++];
  }
  if (__calls[31].calls == 0) {
    _data_k_385 = 0;
    if (_data_k_385 >= _data_n_385) {
      _data_k_385 = 0;
    }
    w87a_[8] = _data_l_385[_data_k_385++];
  }
  if (__calls[31].calls == 0) {
    _data_k_386 = 0;
    if (_data_k_386 >= _data_n_386) {
      _data_k_386 = 0;
    }
    w87a_[9] = _data_l_386[_data_k_386++];
  }
  if (__calls[31].calls == 0) {
    _data_k_387 = 0;
    if (_data_k_387 >= _data_n_387) {
      _data_k_387 = 0;
    }
    w87a_[10] = _data_l_387[_data_k_387++];
  }
  if (__calls[31].calls == 0) {
    _data_k_388 = 0;
    if (_data_k_388 >= _data_n_388) {
      _data_k_388 = 0;
    }
    w87a_[11] = _data_l_388[_data_k_388++];
  }
  if (__calls[31].calls == 0) {
    _data_k_389 = 0;
    if (_data_k_389 >= _data_n_389) {
      _data_k_389 = 0;
    }
    w87a_[12] = _data_l_389[_data_k_389++];
  }
  if (__calls[31].calls == 0) {
    _data_k_390 = 0;
    if (_data_k_390 >= _data_n_390) {
      _data_k_390 = 0;
    }
    w87a_[13] = _data_l_390[_data_k_390++];
  }
  if (__calls[31].calls == 0) {
    _data_k_391 = 0;
    if (_data_k_391 >= _data_n_391) {
      _data_k_391 = 0;
    }
    w87a_[14] = _data_l_391[_data_k_391++];
  }
  if (__calls[31].calls == 0) {
    _data_k_392 = 0;
    if (_data_k_392 >= _data_n_392) {
      _data_k_392 = 0;
    }
    w87a_[15] = _data_l_392[_data_k_392++];
  }
  if (__calls[31].calls == 0) {
    _data_k_393 = 0;
    if (_data_k_393 >= _data_n_393) {
      _data_k_393 = 0;
    }
    w87a_[16] = _data_l_393[_data_k_393++];
  }
  if (__calls[31].calls == 0) {
    _data_k_394 = 0;
    if (_data_k_394 >= _data_n_394) {
      _data_k_394 = 0;
    }
    w87a_[17] = _data_l_394[_data_k_394++];
  }
  if (__calls[31].calls == 0) {
    _data_k_395 = 0;
    if (_data_k_395 >= _data_n_395) {
      _data_k_395 = 0;
    }
    w87a_[18] = _data_l_395[_data_k_395++];
  }
  if (__calls[31].calls == 0) {
    _data_k_396 = 0;
    if (_data_k_396 >= _data_n_396) {
      _data_k_396 = 0;
    }
    w87a_[19] = _data_l_396[_data_k_396++];
  }
  if (__calls[31].calls == 0) {
    _data_k_397 = 0;
    if (_data_k_397 >= _data_n_397) {
      _data_k_397 = 0;
    }
    w87a_[20] = _data_l_397[_data_k_397++];
  }
  if (__calls[31].calls == 0) {
    _data_k_398 = 0;
    if (_data_k_398 >= _data_n_398) {
      _data_k_398 = 0;
    }
    w87b_[0] = _data_l_398[_data_k_398++];
  }
  if (__calls[31].calls == 0) {
    _data_k_399 = 0;
    if (_data_k_399 >= _data_n_399) {
      _data_k_399 = 0;
    }
    w87b_[1] = _data_l_399[_data_k_399++];
  }
  if (__calls[31].calls == 0) {
    _data_k_400 = 0;
    if (_data_k_400 >= _data_n_400) {
      _data_k_400 = 0;
    }
    w87b_[2] = _data_l_400[_data_k_400++];
  }
  if (__calls[31].calls == 0) {
    _data_k_401 = 0;
    if (_data_k_401 >= _data_n_401) {
      _data_k_401 = 0;
    }
    w87b_[3] = _data_l_401[_data_k_401++];
  }
  if (__calls[31].calls == 0) {
    _data_k_402 = 0;
    if (_data_k_402 >= _data_n_402) {
      _data_k_402 = 0;
    }
    w87b_[4] = _data_l_402[_data_k_402++];
  }
  if (__calls[31].calls == 0) {
    _data_k_403 = 0;
    if (_data_k_403 >= _data_n_403) {
      _data_k_403 = 0;
    }
    w87b_[5] = _data_l_403[_data_k_403++];
  }
  if (__calls[31].calls == 0) {
    _data_k_404 = 0;
    if (_data_k_404 >= _data_n_404) {
      _data_k_404 = 0;
    }
    w87b_[6] = _data_l_404[_data_k_404++];
  }
  if (__calls[31].calls == 0) {
    _data_k_405 = 0;
    if (_data_k_405 >= _data_n_405) {
      _data_k_405 = 0;
    }
    w87b_[7] = _data_l_405[_data_k_405++];
  }
  if (__calls[31].calls == 0) {
    _data_k_406 = 0;
    if (_data_k_406 >= _data_n_406) {
      _data_k_406 = 0;
    }
    w87b_[8] = _data_l_406[_data_k_406++];
  }
  if (__calls[31].calls == 0) {
    _data_k_407 = 0;
    if (_data_k_407 >= _data_n_407) {
      _data_k_407 = 0;
    }
    w87b_[9] = _data_l_407[_data_k_407++];
  }
  if (__calls[31].calls == 0) {
    _data_k_408 = 0;
    if (_data_k_408 >= _data_n_408) {
      _data_k_408 = 0;
    }
    w87b_[10] = _data_l_408[_data_k_408++];
  }
  if (__calls[31].calls == 0) {
    _data_k_409 = 0;
    if (_data_k_409 >= _data_n_409) {
      _data_k_409 = 0;
    }
    w87b_[11] = _data_l_409[_data_k_409++];
  }
  if (__calls[31].calls == 0) {
    _data_k_410 = 0;
    if (_data_k_410 >= _data_n_410) {
      _data_k_410 = 0;
    }
    w87b_[12] = _data_l_410[_data_k_410++];
  }
  if (__calls[31].calls == 0) {
    _data_k_411 = 0;
    if (_data_k_411 >= _data_n_411) {
      _data_k_411 = 0;
    }
    w87b_[13] = _data_l_411[_data_k_411++];
  }
  if (__calls[31].calls == 0) {
    _data_k_412 = 0;
    if (_data_k_412 >= _data_n_412) {
      _data_k_412 = 0;
    }
    w87b_[14] = _data_l_412[_data_k_412++];
  }
  if (__calls[31].calls == 0) {
    _data_k_413 = 0;
    if (_data_k_413 >= _data_n_413) {
      _data_k_413 = 0;
    }
    w87b_[15] = _data_l_413[_data_k_413++];
  }
  if (__calls[31].calls == 0) {
    _data_k_414 = 0;
    if (_data_k_414 >= _data_n_414) {
      _data_k_414 = 0;
    }
    w87b_[16] = _data_l_414[_data_k_414++];
  }
  if (__calls[31].calls == 0) {
    _data_k_415 = 0;
    if (_data_k_415 >= _data_n_415) {
      _data_k_415 = 0;
    }
    w87b_[17] = _data_l_415[_data_k_415++];
  }
  if (__calls[31].calls == 0) {
    _data_k_416 = 0;
    if (_data_k_416 >= _data_n_416) {
      _data_k_416 = 0;
    }
    w87b_[18] = _data_l_416[_data_k_416++];
  }
  if (__calls[31].calls == 0) {
    _data_k_417 = 0;
    if (_data_k_417 >= _data_n_417) {
      _data_k_417 = 0;
    }
    w87b_[19] = _data_l_417[_data_k_417++];
  }
  if (__calls[31].calls == 0) {
    _data_k_418 = 0;
    if (_data_k_418 >= _data_n_418) {
      _data_k_418 = 0;
    }
    w87b_[20] = _data_l_418[_data_k_418++];
  }
  if (__calls[31].calls == 0) {
    _data_k_419 = 0;
    if (_data_k_419 >= _data_n_419) {
      _data_k_419 = 0;
    }
    w87b_[21] = _data_l_419[_data_k_419++];
  }
  if (__calls[31].calls == 0) {
    _data_k_420 = 0;
    if (_data_k_420 >= _data_n_420) {
      _data_k_420 = 0;
    }
    w87b_[22] = _data_l_420[_data_k_420++];
  }
  epmach_ = _d1mach (($0_ = 4, &$0_));
  uflow_ = _d1mach (&_k1);
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  (*neval_) = 0;
  (*ier_) = 6;
  if ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-29)) {
    goto _l80;
  }
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  centr_ = 0.5e+00 * ((*b_) + (*a_));
  fcentr_ = _f (&centr_);
  (*neval_) = 21;
  (*ier_) = 1;
  for (l_ = 1; l_ <= 3; (l_)++) {
    switch (l_) {
      default:
      case 1: goto _l5;
      case 2: goto _l25;
      case 3: goto _l45;
    }
    _l5:;
    res10_ = 0.0;
    res21_ = w21b_[5] * fcentr_;
    resabs_ = w21b_[5] * _abs (fcentr_);
    for (k_ = 1; k_ <= 5; (k_)++) {
      absc_ = hlgth_ * x1_[k_ - 1];
      fval1_ = _f (($1_ = centr_ + absc_, &$1_));
      fval2_ = _f (($2_ = centr_ - absc_, &$2_));
      fval_ = fval1_ + fval2_;
      res10_ = res10_ + w10_[k_ - 1] * fval_;
      res21_ = res21_ + w21a_[k_ - 1] * fval_;
      resabs_ = resabs_ + w21a_[k_ - 1] * (_abs (fval1_) + _abs (fval2_));
      savfun_[k_ - 1] = fval_;
      fv1_[k_ - 1] = fval1_;
      fv2_[k_ - 1] = fval2_;
    }
    ipx_ = 5;
    for (k_ = 1; k_ <= 5; (k_)++) {
      ipx_ = ipx_ + 1;
      absc_ = hlgth_ * x2_[k_ - 1];
      fval1_ = _f (($3_ = centr_ + absc_, &$3_));
      fval2_ = _f (($4_ = centr_ - absc_, &$4_));
      fval_ = fval1_ + fval2_;
      res21_ = res21_ + w21b_[k_ - 1] * fval_;
      resabs_ = resabs_ + w21b_[k_ - 1] * (_abs (fval1_) + _abs (fval2_));
      savfun_[ipx_ - 1] = fval_;
      fv3_[k_ - 1] = fval1_;
      fv4_[k_ - 1] = fval2_;
    }
    (*result_) = res21_ * hlgth_;
    resabs_ = resabs_ * dhlgth_;
    reskh_ = 0.5e+00 * res21_;
    resasc_ = w21b_[5] * _abs (fcentr_ - reskh_);
    for (k_ = 1; k_ <= 5; (k_)++) {
      resasc_ = resasc_ + w21a_[k_ - 1] * (_abs (fv1_[k_ - 1] - reskh_) + _abs (fv2_[k_ - 1] - reskh_)) + w21b_[k_ - 1] * 
      (_abs (fv3_[k_ - 1] - reskh_) + _abs (fv4_[k_ - 1] - reskh_));
    }
    (*abserr_) = _abs ((res21_ - res10_) * hlgth_);
    resasc_ = resasc_ * dhlgth_;
    goto _l65;
    _l25:;
    res43_ = w43b_[11] * fcentr_;
    (*neval_) = 43;
    for (k_ = 1; k_ <= 10; (k_)++) {
      res43_ = res43_ + savfun_[k_ - 1] * w43a_[k_ - 1];
    }
    for (k_ = 1; k_ <= 11; (k_)++) {
      ipx_ = ipx_ + 1;
      absc_ = hlgth_ * x3_[k_ - 1];
      fval_ = _f (($5_ = absc_ + centr_, &$5_)) + _f (($6_ = centr_ - absc_, &$6_));
      res43_ = res43_ + fval_ * w43b_[k_ - 1];
      savfun_[ipx_ - 1] = fval_;
    }
    (*result_) = res43_ * hlgth_;
    (*abserr_) = _abs ((res43_ - res21_) * hlgth_);
    goto _l65;
    _l45:;
    res87_ = w87b_[22] * fcentr_;
    (*neval_) = 87;
    for (k_ = 1; k_ <= 21; (k_)++) {
      res87_ = res87_ + savfun_[k_ - 1] * w87a_[k_ - 1];
    }
    for (k_ = 1; k_ <= 22; (k_)++) {
      absc_ = hlgth_ * x4_[k_ - 1];
      res87_ = res87_ + w87b_[k_ - 1] * (_f (($7_ = absc_ + centr_, &$7_)) + _f (($8_ = centr_ - absc_, &$8_)));
    }
    (*result_) = res87_ * hlgth_;
    (*abserr_) = _abs ((res87_ - res43_) * hlgth_);
    _l65:;
    if (resasc_ != 0.0e+00 && (*abserr_) != 0.0e+00) {
      (*abserr_) = resasc_ * _min (1.0, pow ((0.2e3 * (*abserr_) / resasc_), 1.5e+00));
    }
    if (resabs_ > uflow_ / (0.5e2 * epmach_)) {
      (*abserr_) = _max ((epmach_ * 0.5e2) * resabs_, (*abserr_));
    }
    if ((*abserr_) <= _max ((*epsabs_), (*epsrel_) * _abs ((*result_)))) {
      (*ier_) = 0;
    }
    if ((*ier_) == 0) {
      goto _l999;
    }
  }
  _l80:;
  (void) _xermsg (_dc_0, _dc_14, _dc_2, ier_, &_k0);
  _l999:;
  __calls[31].calls++;
  return 0;
}

int_4 _dqpsrt (int_4 _p_ limit_, int_4 _p_ last_, int_4 _p_ maxerr_, real_8 _p_ ermax_, real_8 _p_ elist_, int_4 _p_ 
iord_, int_4 _p_ nrmax_)
{
  static int_4 i_, ibeg_, ido_, isucc_, j_, jbnd_, jupbn_, k_;
  static real_8 errmax_, errmin_;
  if ((*last_) > 2) {
    goto _l10;
  }
  iord_[0] = 1;
  iord_[1] = 2;
  goto _l90;
  _l10:;
  errmax_ = elist_[(*maxerr_) - 1];
  if ((*nrmax_) == 1) {
    goto _l30;
  }
  ido_ = (*nrmax_) - 1;
  for (i_ = 1; i_ <= ido_; (i_)++) {
    isucc_ = iord_[(*nrmax_) - 1 - 1];
    if (errmax_ <= elist_[isucc_ - 1]) {
      goto _l30;
    }
    iord_[(*nrmax_) - 1] = isucc_;
    (*nrmax_) = (*nrmax_) - 1;
  }
  _l30:;
  jupbn_ = (*last_);
  if ((*last_) > ((*limit_) / 2 + 2)) {
    jupbn_ = (*limit_) + 3 - (*last_);
  }
  errmin_ = elist_[(*last_) - 1];
  jbnd_ = jupbn_ - 1;
  ibeg_ = (*nrmax_) + 1;
  if (ibeg_ > jbnd_) {
    goto _l50;
  }
  for (i_ = ibeg_; i_ <= jbnd_; (i_)++) {
    isucc_ = iord_[i_ - 1];
    if (errmax_ >= elist_[isucc_ - 1]) {
      goto _l60;
    }
    iord_[i_ - 1 - 1] = isucc_;
  }
  _l50:;
  iord_[jbnd_ - 1] = (*maxerr_);
  iord_[jupbn_ - 1] = (*last_);
  goto _l90;
  _l60:;
  iord_[i_ - 1 - 1] = (*maxerr_);
  k_ = jbnd_;
  for (j_ = i_; j_ <= jbnd_; (j_)++) {
    isucc_ = iord_[k_ - 1];
    if (errmin_ < elist_[isucc_ - 1]) {
      goto _l80;
    }
    iord_[k_ + 1 - 1] = isucc_;
    k_ = k_ - 1;
  }
  iord_[i_ - 1] = (*last_);
  goto _l90;
  _l80:;
  iord_[k_ + 1 - 1] = (*last_);
  _l90:;
  (*maxerr_) = iord_[(*nrmax_) - 1];
  (*ermax_) = elist_[(*maxerr_) - 1];
  __calls[32].calls++;
  return 0;
}

real_8 _dqwgtc (real_8 _p_ x_, real_8 _p_ c_, real_8 _p_ p2_, real_8 _p_ p3_, real_8 _p_ p4_, int_4 _p_ kp_)
{
  real_8 dqwgtc_;
  dqwgtc_ = 0.1e1 / ((*x_) - (*c_));
  __calls[33].calls++;
  return dqwgtc_;
}

real_8 _dqwgtf (real_8 _p_ x_, real_8 _p_ omega_, real_8 _p_ p2_, real_8 _p_ p3_, real_8 _p_ p4_, int_4 _p_ integr_)
{
  static real_8 dcos_, dsin_, omx_;
  real_8 dqwgtf_;
  omx_ = (*omega_) * (*x_);
  switch ((*integr_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  dqwgtf_ = cos (omx_);
  goto _l30;
  _l20:;
  dqwgtf_ = sin (omx_);
  _l30:;
  __calls[34].calls++;
  return dqwgtf_;
}

real_8 _dqwgts (real_8 _p_ x_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ alfa_, real_8 _p_ beta_, int_4 _p_ integr_)
{
  static real_8 bmx_, dlog_, xma_;
  real_8 dqwgts_;
  xma_ = (*x_) - (*a_);
  bmx_ = (*b_) - (*x_);
  dqwgts_ = pow (xma_, (*alfa_)) * pow (bmx_, (*beta_));
  switch ((*integr_)) {
    default:
    case 1: goto _l40;
    case 2: goto _l10;
    case 3: goto _l20;
    case 4: goto _l30;
  }
  _l10:;
  dqwgts_ = dqwgts_ * log (xma_);
  goto _l40;
  _l20:;
  dqwgts_ = dqwgts_ * log (bmx_);
  goto _l40;
  _l30:;
  dqwgts_ = dqwgts_ * log (xma_) * log (bmx_);
  _l40:;
  __calls[35].calls++;
  return dqwgts_;
}

int_4 _qage (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ key_, 
int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 _p_ alist_, real_4 
_p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_)
{
  static int_4 iroff1_, iroff2_, k_, keyf_, maxerr_, nrmax_;
  static real_4 area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, defabs_, defab1_, defab2_, epmach_, errbnd_, errmax_, 
  error1_, error2_, erro12_, errsum_, resabs_, uflow_;
  int_4 $0_;
  extern real_4 _r1mach ();
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  if ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-15)) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  keyf_ = (*key_);
  if ((*key_) <= 0) {
    keyf_ = 1;
  }
  if ((*key_) >= 7) {
    keyf_ = 6;
  }
  (*neval_) = 0;
  if (keyf_ == 1) {
    (void) _qk15 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 2) {
    (void) _qk21 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 3) {
    (void) _qk31 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 4) {
    (void) _qk41 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 5) {
    (void) _qk51 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  if (keyf_ == 6) {
    (void) _qk61 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  }
  (*last_) = 1;
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs ((*result_)));
  if ((*abserr_) <= 0.5e2 * epmach_ * defabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*ier_) != 0 || ((*abserr_) <= errbnd_ && (*abserr_) != resabs_) || (*abserr_) == 0.0e+00) {
    goto _l60;
  }
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  nrmax_ = 1;
  iroff1_ = 0;
  iroff2_ = 0;
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    if (keyf_ == 1) {
      (void) _qk15 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 2) {
      (void) _qk21 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 3) {
      (void) _qk31 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 4) {
      (void) _qk41 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 5) {
      (void) _qk51 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 6) {
      (void) _qk61 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    }
    if (keyf_ == 1) {
      (void) _qk15 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 2) {
      (void) _qk21 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 3) {
      (void) _qk31 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 4) {
      (void) _qk41 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 5) {
      (void) _qk51 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    if (keyf_ == 6) {
      (void) _qk61 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    }
    (*neval_) = (*neval_) + 1;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l5;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) <= 0.1e-4 * _abs (area12_) && erro12_ >= 0.99e+00 * errmax_) {
      iroff1_ = iroff1_ + 1;
    }
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff2_ = iroff2_ + 1;
    }
    _l5:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (errsum_ <= errbnd_) {
      goto _l8;
    }
    if (iroff1_ >= 6 || iroff2_ >= 20) {
      (*ier_) = 2;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 3;
    }
    _l8:;
    if (error2_ > error1_) {
      goto _l10;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l20;
    _l10:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l20:;
    (void) _qpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if ((*ier_) != 0 || errsum_ <= errbnd_) {
      goto _l40;
    }
  }
  _l40:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l60:;
  if (keyf_ != 1) {
    (*neval_) = (10 * keyf_ + 1) * (2 * (*neval_) + 1);
  }
  if (keyf_ == 1) {
    (*neval_) = 30 * (*neval_) + 15;
  }
  _l999:;
  __calls[36].calls++;
  return 0;
}

int_4 _qag (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ key_, 
real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ 
last_, int_4 _p_ iwork_, real_4 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) >= 1 && (*lenw_) >= (*limit_) * 4) {
    l1_ = (*limit_) + 1;
    l2_ = (*limit_) + l1_;
    l3_ = (*limit_) + l2_;
    (void) _qage (_f, a_, b_, epsabs_, epsrel_, key_, limit_, result_, abserr_, neval_, ier_, &work_[0], &work_[l1_ - 1], 
    &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
    lvl_ = 0;
  }
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_15, _dc_2, ier_, &lvl_);
  }
  __calls[37].calls++;
  return 0;
}

int_4 _qagie (real_4 (*_f)(), real_4 _p_ bound_, int_4 _p_ inf_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ 
limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 _p_ alist_, real_4 _p_ blist_, 
real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_)
{
  static int_4 id_, ierro_, iroff1_, iroff2_, iroff3_, jupbnd_, k_, ksgn_, ktmin_, maxerr_, nres_, nrmax_, numrl2_;
  static logical_4 extrap_, noext_;
  static real_4 abseps_, area_, area1_, area12_, area2_, a1_, a2_, boun_, b1_, b2_, correc_, defabs_, defab1_, defab2_, 
  dres_, epmach_, erlarg_, erlast_, errbnd_, errmax_, error1_, error2_, erro12_, errsum_, ertest_, oflow_, resabs_, 
  reseps_, res3la_[3], rlist2_[52], small_, uflow_;
  int_4 $0_, $3_;
  real_4 $1_, $2_;
  extern real_4 _r1mach ();
  epmach_ = _r1mach (($0_ = 4, &$0_));
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = 0.0;
  blist_[0] = 1.0;
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  if ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-15)) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  boun_ = (*bound_);
  if ((*inf_) == 2) {
    boun_ = 0.0;
  }
  (void) _qk15i (_f, &boun_, inf_, ($1_ = 0.0, &$1_), ($2_ = 1.0, &$2_), result_, abserr_, &defabs_, &resabs_);
  (*last_) = 1;
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  dres_ = _abs ((*result_));
  errbnd_ = _max ((*epsabs_), (*epsrel_) * dres_);
  if ((*abserr_) <= 1.0e2 * epmach_ * defabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*ier_) != 0 || ((*abserr_) <= errbnd_ && (*abserr_) != resabs_) || (*abserr_) == 0.0e+00) {
    goto _l130;
  }
  uflow_ = _r1mach (&_k1);
  oflow_ = _r1mach (($3_ = 2, &$3_));
  rlist2_[0] = (*result_);
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  (*abserr_) = oflow_;
  nrmax_ = 1;
  nres_ = 0;
  ktmin_ = 0;
  numrl2_ = 2;
  extrap_ = FALSE;
  noext_ = FALSE;
  ierro_ = 0;
  iroff1_ = 0;
  iroff2_ = 0;
  iroff3_ = 0;
  ksgn_ = -1;
  if (dres_ >= (0.1e1 - 0.5e2 * epmach_) * defabs_) {
    ksgn_ = 1;
  }
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    erlast_ = errmax_;
    (void) _qk15i (_f, &boun_, inf_, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    (void) _qk15i (_f, &boun_, inf_, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l15;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) > 0.1e-4 * _abs (area12_) || erro12_ < 0.99e+00 * errmax_) {
      goto _l10;
    }
    if (extrap_) {
      iroff2_ = iroff2_ + 1;
    }
    if (! (extrap_)) {
      iroff1_ = iroff1_ + 1;
    }
    _l10:;
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff3_ = iroff3_ + 1;
    }
    _l15:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (iroff1_ + iroff2_ >= 10 || iroff3_ >= 20) {
      (*ier_) = 2;
    }
    if (iroff2_ >= 5) {
      ierro_ = 3;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 4;
    }
    if (error2_ > error1_) {
      goto _l20;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l30;
    _l20:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l30:;
    (void) _qpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if (errsum_ <= errbnd_) {
      goto _l115;
    }
    if ((*ier_) != 0) {
      goto _l100;
    }
    if ((*last_) == 2) {
      goto _l80;
    }
    if (noext_) {
      goto _l90;
    }
    erlarg_ = erlarg_ - erlast_;
    if (_abs (b1_ - a1_) > small_) {
      erlarg_ = erlarg_ + erro12_;
    }
    if (extrap_) {
      goto _l40;
    }
    if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
      goto _l90;
    }
    extrap_ = TRUE;
    nrmax_ = 2;
    _l40:;
    if (ierro_ == 3 || erlarg_ <= ertest_) {
      goto _l60;
    }
    id_ = nrmax_;
    jupbnd_ = (*last_);
    if ((*last_) > (2 + (*limit_) / 2)) {
      jupbnd_ = (*limit_) + 3 - (*last_);
    }
    for (k_ = id_; k_ <= jupbnd_; (k_)++) {
      maxerr_ = iord_[nrmax_ - 1];
      errmax_ = elist_[maxerr_ - 1];
      if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
        goto _l90;
      }
      nrmax_ = nrmax_ + 1;
    }
    _l60:;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    (void) _qelg (&numrl2_, rlist2_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ > 5 && (*abserr_) < 0.1e-2 * errsum_) {
      (*ier_) = 5;
    }
    if (abseps_ >= (*abserr_)) {
      goto _l70;
    }
    ktmin_ = 0;
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    correc_ = erlarg_;
    ertest_ = _max ((*epsabs_), (*epsrel_) * _abs (reseps_));
    if ((*abserr_) <= ertest_) {
      goto _l100;
    }
    _l70:;
    if (numrl2_ == 1) {
      noext_ = TRUE;
    }
    if ((*ier_) == 5) {
      goto _l100;
    }
    maxerr_ = iord_[0];
    errmax_ = elist_[maxerr_ - 1];
    nrmax_ = 1;
    extrap_ = FALSE;
    small_ = small_ * 0.5e+00;
    erlarg_ = errsum_;
    goto _l90;
    _l80:;
    small_ = 0.375;
    erlarg_ = errsum_;
    ertest_ = errbnd_;
    rlist2_[1] = area_;
    _l90:;
  }
  _l100:;
  if ((*abserr_) == oflow_) {
    goto _l115;
  }
  if (((*ier_) + ierro_) == 0) {
    goto _l110;
  }
  if (ierro_ == 3) {
    (*abserr_) = (*abserr_) + correc_;
  }
  if ((*ier_) == 0) {
    (*ier_) = 3;
  }
  if ((*result_) != 0.0e+00 && area_ != 0.0e+00) {
    goto _l105;
  }
  if ((*abserr_) > errsum_) {
    goto _l115;
  }
  if (area_ == 0.0e+00) {
    goto _l130;
  }
  goto _l110;
  _l105:;
  if ((*abserr_) / _abs ((*result_)) > errsum_ / _abs (area_)) {
    goto _l115;
  }
  _l110:;
  if (ksgn_ == -1 && _max (_abs ((*result_)), _abs (area_)) <= defabs_ * 0.1e-1) {
    goto _l130;
  }
  if (0.1e-1 > ((*result_) / area_) || ((*result_) / area_) > 0.1e3 || errsum_ > _abs (area_)) {
    (*ier_) = 6;
  }
  goto _l130;
  _l115:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l130:;
  (*neval_) = 30 * (*last_) - 15;
  if ((*inf_) == 2) {
    (*neval_) = 2 * (*neval_);
  }
  if ((*ier_) > 2) {
    (*ier_) = (*ier_) - 1;
  }
  _l999:;
  __calls[38].calls++;
  return 0;
}

int_4 _qagi (real_4 (*_f)(), real_4 _p_ bound_, int_4 _p_ inf_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, real_4 _p_ 
result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, 
int_4 _p_ iwork_, real_4 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) < 1 || (*lenw_) < (*limit_) * 4) {
    goto _l10;
  }
  l1_ = (*limit_) + 1;
  l2_ = (*limit_) + l1_;
  l3_ = (*limit_) + l2_;
  (void) _qagie (_f, bound_, inf_, epsabs_, epsrel_, limit_, result_, abserr_, neval_, ier_, &work_[0], &work_[l1_ - 1], 
  &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_16, _dc_2, ier_, &lvl_);
  }
  __calls[39].calls++;
  return 0;
}

int_4 _qagpe (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ npts2_, real_4 _p_ points_, real_4 _p_ epsabs_, 
real_4 _p_ epsrel_, int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 
_p_ alist_, real_4 _p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, real_4 _p_ pts_, int_4 _p_ iord_, int_4 _p_ level_
, int_4 _p_ ndin_, int_4 _p_ last_)
{
  static int_4 i_, id_, ierro_, ind1_, ind2_, ip1_, iroff1_, iroff2_, iroff3_, j_, jlow_, jupbnd_, k_, ksgn_, ktmin_, 
  levcur_, levmax_, maxerr_, nint_, nintp1_, npts_, nres_, nrmax_, numrl2_;
  static logical_4 extrap_, noext_;
  static real_4 abseps_, area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, correc_, defabs_, defab1_, defab2_, dres_, 
  epmach_, erlarg_, erlast_, errbnd_, errmax_, error1_, erro12_, error2_, errsum_, ertest_, oflow_, resa_, resabs_, 
  reseps_, res3la_[3], rlist2_[52], sign_, temp_, uflow_;
  int_4 $0_, $1_;
  extern real_4 _r1mach ();
  epmach_ = _r1mach (($0_ = 4, &$0_));
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  level_[0] = 0;
  npts_ = (*npts2_) - 2;
  if ((*npts2_) < 2 || (*limit_) <= npts_ || ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-15))) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  sign_ = 1.0;
  if ((*a_) > (*b_)) {
    sign_ = -1.0;
  }
  pts_[0] = _min ((*a_), (*b_));
  if (npts_ == 0) {
    goto _l15;
  }
  for (i_ = 1; i_ <= npts_; (i_)++) {
    pts_[i_ + 1 - 1] = points_[i_ - 1];
  }
  _l15:;
  pts_[npts_ + 2 - 1] = _max ((*a_), (*b_));
  nint_ = npts_ + 1;
  a1_ = pts_[0];
  if (npts_ == 0) {
    goto _l40;
  }
  nintp1_ = nint_ + 1;
  for (i_ = 1; i_ <= nint_; (i_)++) {
    ip1_ = i_ + 1;
    for (j_ = ip1_; j_ <= nintp1_; (j_)++) {
      if (pts_[i_ - 1] <= pts_[j_ - 1]) {
        goto _l20;
      }
      temp_ = pts_[i_ - 1];
      pts_[i_ - 1] = pts_[j_ - 1];
      pts_[j_ - 1] = temp_;
      _l20:;
    }
  }
  if (pts_[0] != _min ((*a_), (*b_)) || pts_[nintp1_ - 1] != _max ((*a_), (*b_))) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  _l40:;
  resabs_ = 0.0;
  for (i_ = 1; i_ <= nint_; (i_)++) {
    b1_ = pts_[i_ + 1 - 1];
    (void) _qk21 (_f, &a1_, &b1_, &area1_, &error1_, &defabs_, &resa_);
    (*abserr_) = (*abserr_) + error1_;
    (*result_) = (*result_) + area1_;
    ndin_[i_ - 1] = 0;
    if (error1_ == resa_ && error1_ != 0.0e+00) {
      ndin_[i_ - 1] = 1;
    }
    resabs_ = resabs_ + defabs_;
    level_[i_ - 1] = 0;
    elist_[i_ - 1] = error1_;
    alist_[i_ - 1] = a1_;
    blist_[i_ - 1] = b1_;
    rlist_[i_ - 1] = area1_;
    iord_[i_ - 1] = i_;
    a1_ = b1_;
  }
  errsum_ = 0.0;
  for (i_ = 1; i_ <= nint_; (i_)++) {
    if (ndin_[i_ - 1] == 1) {
      elist_[i_ - 1] = (*abserr_);
    }
    errsum_ = errsum_ + elist_[i_ - 1];
  }
  (*last_) = nint_;
  (*neval_) = 21 * nint_;
  dres_ = _abs ((*result_));
  errbnd_ = _max ((*epsabs_), (*epsrel_) * dres_);
  if ((*abserr_) <= 0.1e3 * epmach_ * resabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if (nint_ == 1) {
    goto _l80;
  }
  for (i_ = 1; i_ <= npts_; (i_)++) {
    jlow_ = i_ + 1;
    ind1_ = iord_[i_ - 1];
    for (j_ = jlow_; j_ <= nint_; (j_)++) {
      ind2_ = iord_[j_ - 1];
      if (elist_[ind1_ - 1] > elist_[ind2_ - 1]) {
        goto _l60;
      }
      ind1_ = ind2_;
      k_ = j_;
      _l60:;
    }
    if (ind1_ == iord_[i_ - 1]) {
      goto _l70;
    }
    iord_[k_ - 1] = iord_[i_ - 1];
    iord_[i_ - 1] = ind1_;
    _l70:;
  }
  if ((*limit_) < (*npts2_)) {
    (*ier_) = 1;
  }
  _l80:;
  if ((*ier_) != 0 || (*abserr_) <= errbnd_) {
    goto _l999;
  }
  rlist2_[0] = (*result_);
  maxerr_ = iord_[0];
  errmax_ = elist_[maxerr_ - 1];
  area_ = (*result_);
  nrmax_ = 1;
  nres_ = 0;
  numrl2_ = 1;
  ktmin_ = 0;
  extrap_ = FALSE;
  noext_ = FALSE;
  erlarg_ = errsum_;
  ertest_ = errbnd_;
  levmax_ = 1;
  iroff1_ = 0;
  iroff2_ = 0;
  iroff3_ = 0;
  ierro_ = 0;
  uflow_ = _r1mach (&_k1);
  oflow_ = _r1mach (($1_ = 2, &$1_));
  (*abserr_) = oflow_;
  ksgn_ = -1;
  if (dres_ >= (0.1e1 - 0.5e2 * epmach_) * resabs_) {
    ksgn_ = 1;
  }
  for ((*last_) = (*npts2_); (*last_) <= (*limit_); ((*last_))++) {
    levcur_ = level_[maxerr_ - 1] + 1;
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    erlast_ = errmax_;
    (void) _qk21 (_f, &a1_, &b1_, &area1_, &error1_, &resa_, &defab1_);
    (void) _qk21 (_f, &a2_, &b2_, &area2_, &error2_, &resa_, &defab2_);
    (*neval_) = (*neval_) + 42;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l95;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) > 0.1e-4 * _abs (area12_) || erro12_ < 0.99e+00 * errmax_) {
      goto _l90;
    }
    if (extrap_) {
      iroff2_ = iroff2_ + 1;
    }
    if (! (extrap_)) {
      iroff1_ = iroff1_ + 1;
    }
    _l90:;
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff3_ = iroff3_ + 1;
    }
    _l95:;
    level_[maxerr_ - 1] = levcur_;
    level_[(*last_) - 1] = levcur_;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (iroff1_ + iroff2_ >= 10 || iroff3_ >= 20) {
      (*ier_) = 2;
    }
    if (iroff2_ >= 5) {
      ierro_ = 3;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 4;
    }
    if (error2_ > error1_) {
      goto _l100;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l110;
    _l100:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l110:;
    (void) _qpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if (errsum_ <= errbnd_) {
      goto _l190;
    }
    if ((*ier_) != 0) {
      goto _l170;
    }
    if (noext_) {
      goto _l160;
    }
    erlarg_ = erlarg_ - erlast_;
    if (levcur_ + 1 <= levmax_) {
      erlarg_ = erlarg_ + erro12_;
    }
    if (extrap_) {
      goto _l120;
    }
    if (level_[maxerr_ - 1] + 1 <= levmax_) {
      goto _l160;
    }
    extrap_ = TRUE;
    nrmax_ = 2;
    _l120:;
    if (ierro_ == 3 || erlarg_ <= ertest_) {
      goto _l140;
    }
    id_ = nrmax_;
    jupbnd_ = (*last_);
    if ((*last_) > (2 + (*limit_) / 2)) {
      jupbnd_ = (*limit_) + 3 - (*last_);
    }
    for (k_ = id_; k_ <= jupbnd_; (k_)++) {
      maxerr_ = iord_[nrmax_ - 1];
      errmax_ = elist_[maxerr_ - 1];
      if (level_[maxerr_ - 1] + 1 <= levmax_) {
        goto _l160;
      }
      nrmax_ = nrmax_ + 1;
    }
    _l140:;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    if (numrl2_ <= 2) {
      goto _l155;
    }
    (void) _qelg (&numrl2_, rlist2_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ > 5 && (*abserr_) < 0.1e-2 * errsum_) {
      (*ier_) = 5;
    }
    if (abseps_ >= (*abserr_)) {
      goto _l150;
    }
    ktmin_ = 0;
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    correc_ = erlarg_;
    ertest_ = _max ((*epsabs_), (*epsrel_) * _abs (reseps_));
    if ((*abserr_) < ertest_) {
      goto _l170;
    }
    _l150:;
    if (numrl2_ == 1) {
      noext_ = TRUE;
    }
    if ((*ier_) >= 5) {
      goto _l170;
    }
    _l155:;
    maxerr_ = iord_[0];
    errmax_ = elist_[maxerr_ - 1];
    nrmax_ = 1;
    extrap_ = FALSE;
    levmax_ = levmax_ + 1;
    erlarg_ = errsum_;
    _l160:;
  }
  _l170:;
  if ((*abserr_) == oflow_) {
    goto _l190;
  }
  if (((*ier_) + ierro_) == 0) {
    goto _l180;
  }
  if (ierro_ == 3) {
    (*abserr_) = (*abserr_) + correc_;
  }
  if ((*ier_) == 0) {
    (*ier_) = 3;
  }
  if ((*result_) != 0.0e+00 && area_ != 0.0e+00) {
    goto _l175;
  }
  if ((*abserr_) > errsum_) {
    goto _l190;
  }
  if (area_ == 0.0e+00) {
    goto _l210;
  }
  goto _l180;
  _l175:;
  if ((*abserr_) / _abs ((*result_)) > errsum_ / _abs (area_)) {
    goto _l190;
  }
  _l180:;
  if (ksgn_ == -1 && _max (_abs ((*result_)), _abs (area_)) <= defabs_ * 0.1e-1) {
    goto _l210;
  }
  if (0.1e-1 > ((*result_) / area_) || ((*result_) / area_) > 0.1e3 || errsum_ > _abs (area_)) {
    (*ier_) = 6;
  }
  goto _l210;
  _l190:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l210:;
  if ((*ier_) > 2) {
    (*ier_) = (*ier_) - 1;
  }
  (*result_) = (*result_) * sign_;
  _l999:;
  __calls[40].calls++;
  return 0;
}

int_4 _qagp (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ npts2_, real_4 _p_ points_, real_4 _p_ epsabs_, 
real_4 _p_ epsrel_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ leniw_, int_4 
_p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_4 _p_ work_)
{
  static int_4 limit_, lvl_, l1_, l2_, l3_, l4_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*leniw_) < (3 * (*npts2_) - 2) || (*lenw_) < ((*leniw_) * 2 - (*npts2_)) || (*npts2_) < 2) {
    goto _l10;
  }
  limit_ = ((*leniw_) - (*npts2_)) / 2;
  l1_ = limit_ + 1;
  l2_ = limit_ + l1_;
  l3_ = limit_ + l2_;
  l4_ = limit_ + l3_;
  (void) _qagpe (_f, a_, b_, npts2_, points_, epsabs_, epsrel_, &limit_, result_, abserr_, neval_, ier_, &work_[0], 
  &work_[l1_ - 1], &work_[l2_ - 1], &work_[l3_ - 1], &work_[l4_ - 1], &iwork_[0], &iwork_[l1_ - 1], &iwork_[l2_ - 1], 
  last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_17, _dc_2, ier_, &lvl_);
  }
  __calls[41].calls++;
  return 0;
}

int_4 _qagse (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ limit_, 
real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 _p_ alist_, real_4 _p_ blist_, real_4 
_p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_)
{
  static int_4 id_, ierro_, iroff1_, iroff2_, iroff3_, jupbnd_, k_, ksgn_, ktmin_, maxerr_, nres_, nrmax_, numrl2_;
  static logical_4 extrap_, noext_;
  static real_4 abseps_, area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, correc_, defabs_, defab1_, defab2_, dres_, 
  epmach_, erlarg_, erlast_, errbnd_, errmax_, error1_, error2_, erro12_, errsum_, ertest_, oflow_, resabs_, reseps_, 
  res3la_[3], rlist2_[52], small_, uflow_;
  int_4 $0_, $1_;
  extern real_4 _r1mach ();
  epmach_ = _r1mach (($0_ = 4, &$0_));
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  if ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-15)) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  uflow_ = _r1mach (&_k1);
  oflow_ = _r1mach (($1_ = 2, &$1_));
  ierro_ = 0;
  (void) _qk21 (_f, a_, b_, result_, abserr_, &defabs_, &resabs_);
  dres_ = _abs ((*result_));
  errbnd_ = _max ((*epsabs_), (*epsrel_) * dres_);
  (*last_) = 1;
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  if ((*abserr_) <= 1.0e2 * epmach_ * defabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*ier_) != 0 || ((*abserr_) <= errbnd_ && (*abserr_) != resabs_) || (*abserr_) == 0.0e+00) {
    goto _l140;
  }
  rlist2_[0] = (*result_);
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  (*abserr_) = oflow_;
  nrmax_ = 1;
  nres_ = 0;
  numrl2_ = 2;
  ktmin_ = 0;
  extrap_ = FALSE;
  noext_ = FALSE;
  iroff1_ = 0;
  iroff2_ = 0;
  iroff3_ = 0;
  ksgn_ = -1;
  if (dres_ >= (0.1e1 - 0.5e2 * epmach_) * defabs_) {
    ksgn_ = 1;
  }
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    erlast_ = errmax_;
    (void) _qk21 (_f, &a1_, &b1_, &area1_, &error1_, &resabs_, &defab1_);
    (void) _qk21 (_f, &a2_, &b2_, &area2_, &error2_, &resabs_, &defab2_);
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l15;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) > 0.1e-4 * _abs (area12_) || erro12_ < 0.99e+00 * errmax_) {
      goto _l10;
    }
    if (extrap_) {
      iroff2_ = iroff2_ + 1;
    }
    if (! (extrap_)) {
      iroff1_ = iroff1_ + 1;
    }
    _l10:;
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff3_ = iroff3_ + 1;
    }
    _l15:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (iroff1_ + iroff2_ >= 10 || iroff3_ >= 20) {
      (*ier_) = 2;
    }
    if (iroff2_ >= 5) {
      ierro_ = 3;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 4;
    }
    if (error2_ > error1_) {
      goto _l20;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l30;
    _l20:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l30:;
    (void) _qpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if (errsum_ <= errbnd_) {
      goto _l115;
    }
    if ((*ier_) != 0) {
      goto _l100;
    }
    if ((*last_) == 2) {
      goto _l80;
    }
    if (noext_) {
      goto _l90;
    }
    erlarg_ = erlarg_ - erlast_;
    if (_abs (b1_ - a1_) > small_) {
      erlarg_ = erlarg_ + erro12_;
    }
    if (extrap_) {
      goto _l40;
    }
    if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
      goto _l90;
    }
    extrap_ = TRUE;
    nrmax_ = 2;
    _l40:;
    if (ierro_ == 3 || erlarg_ <= ertest_) {
      goto _l60;
    }
    id_ = nrmax_;
    jupbnd_ = (*last_);
    if ((*last_) > (2 + (*limit_) / 2)) {
      jupbnd_ = (*limit_) + 3 - (*last_);
    }
    for (k_ = id_; k_ <= jupbnd_; (k_)++) {
      maxerr_ = iord_[nrmax_ - 1];
      errmax_ = elist_[maxerr_ - 1];
      if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
        goto _l90;
      }
      nrmax_ = nrmax_ + 1;
    }
    _l60:;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    (void) _qelg (&numrl2_, rlist2_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ > 5 && (*abserr_) < 0.1e-2 * errsum_) {
      (*ier_) = 5;
    }
    if (abseps_ >= (*abserr_)) {
      goto _l70;
    }
    ktmin_ = 0;
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    correc_ = erlarg_;
    ertest_ = _max ((*epsabs_), (*epsrel_) * _abs (reseps_));
    if ((*abserr_) <= ertest_) {
      goto _l100;
    }
    _l70:;
    if (numrl2_ == 1) {
      noext_ = TRUE;
    }
    if ((*ier_) == 5) {
      goto _l100;
    }
    maxerr_ = iord_[0];
    errmax_ = elist_[maxerr_ - 1];
    nrmax_ = 1;
    extrap_ = FALSE;
    small_ = small_ * 0.5e+00;
    erlarg_ = errsum_;
    goto _l90;
    _l80:;
    small_ = _abs ((*b_) - (*a_)) * 0.375e+00;
    erlarg_ = errsum_;
    ertest_ = errbnd_;
    rlist2_[1] = area_;
    _l90:;
  }
  _l100:;
  if ((*abserr_) == oflow_) {
    goto _l115;
  }
  if ((*ier_) + ierro_ == 0) {
    goto _l110;
  }
  if (ierro_ == 3) {
    (*abserr_) = (*abserr_) + correc_;
  }
  if ((*ier_) == 0) {
    (*ier_) = 3;
  }
  if ((*result_) != 0.0e+00 && area_ != 0.0e+00) {
    goto _l105;
  }
  if ((*abserr_) > errsum_) {
    goto _l115;
  }
  if (area_ == 0.0e+00) {
    goto _l130;
  }
  goto _l110;
  _l105:;
  if ((*abserr_) / _abs ((*result_)) > errsum_ / _abs (area_)) {
    goto _l115;
  }
  _l110:;
  if (ksgn_ == -1 && _max (_abs ((*result_)), _abs (area_)) <= defabs_ * 0.1e-1) {
    goto _l130;
  }
  if (0.1e-1 > ((*result_) / area_) || ((*result_) / area_) > 0.1e3 || errsum_ > _abs (area_)) {
    (*ier_) = 6;
  }
  goto _l130;
  _l115:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l130:;
  if ((*ier_) > 2) {
    (*ier_) = (*ier_) - 1;
  }
  _l140:;
  (*neval_) = 42 * (*last_) - 21;
  _l999:;
  __calls[42].calls++;
  return 0;
}

int_4 _qags (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, real_4 _p_ result_, 
real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ 
iwork_, real_4 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) < 1 || (*lenw_) < (*limit_) * 4) {
    goto _l10;
  }
  l1_ = (*limit_) + 1;
  l2_ = (*limit_) + l1_;
  l3_ = (*limit_) + l2_;
  (void) _qagse (_f, a_, b_, epsabs_, epsrel_, limit_, result_, abserr_, neval_, ier_, &work_[0], &work_[l1_ - 1], 
  &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_18, _dc_2, ier_, &lvl_);
  }
  __calls[43].calls++;
  return 0;
}

int_4 _qawce (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, 
int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, real_4 _p_ alist_, real_4 
_p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ last_)
{
  static int_4 iroff1_, iroff2_, k_, krule_, maxerr_, nev_, nrmax_;
  static real_4 aa_, area_, area1_, area12_, area2_, a1_, a2_, bb_, b1_, b2_, epmach_, errbnd_, errmax_, error1_, error2_
  , errsum_, uflow_, erro12_;
  int_4 $0_;
  extern real_4 _r1mach ();
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*c_) == (*a_) || (*c_) == (*b_) || ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-15))) {
    goto _l999;
  }
  aa_ = (*a_);
  bb_ = (*b_);
  if ((*a_) <= (*b_)) {
    goto _l10;
  }
  aa_ = (*b_);
  bb_ = (*a_);
  _l10:;
  (*ier_) = 0;
  krule_ = 1;
  (void) _qc25c (_f, &aa_, &bb_, c_, result_, abserr_, &krule_, neval_);
  (*last_) = 1;
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs ((*result_)));
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*abserr_) < _min (0.1e-1 * _abs ((*result_)), errbnd_) || (*ier_) == 1) {
    goto _l70;
  }
  alist_[0] = aa_;
  blist_[0] = bb_;
  rlist_[0] = (*result_);
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  nrmax_ = 1;
  iroff1_ = 0;
  iroff2_ = 0;
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    b2_ = blist_[maxerr_ - 1];
    if ((*c_) <= b1_ && (*c_) > a1_) {
      b1_ = 0.5e+00 * ((*c_) + b2_);
    }
    if ((*c_) > b1_ && (*c_) < b2_) {
      b1_ = 0.5e+00 * (a1_ + (*c_));
    }
    a2_ = b1_;
    krule_ = 2;
    (void) _qc25c (_f, &a1_, &b1_, c_, &area1_, &error1_, &krule_, &nev_);
    (*neval_) = (*neval_) + nev_;
    (void) _qc25c (_f, &a2_, &b2_, c_, &area2_, &error2_, &krule_, &nev_);
    (*neval_) = (*neval_) + nev_;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (_abs (rlist_[maxerr_ - 1] - area12_) < 0.1e-4 * _abs (area12_) && erro12_ >= 0.99e+00 * errmax_ && krule_ == 0) {
      iroff1_ = iroff1_ + 1;
    }
    if ((*last_) > 10 && erro12_ > errmax_ && krule_ == 0) {
      iroff2_ = iroff2_ + 1;
    }
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (errsum_ <= errbnd_) {
      goto _l15;
    }
    if (iroff1_ >= 6 && iroff2_ > 20) {
      (*ier_) = 2;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 3;
    }
    _l15:;
    if (error2_ > error1_) {
      goto _l20;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l30;
    _l20:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l30:;
    (void) _qpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if ((*ier_) != 0 || errsum_ <= errbnd_) {
      goto _l50;
    }
  }
  _l50:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l70:;
  if (aa_ == (*b_)) {
    (*result_) = -(*result_);
  }
  _l999:;
  __calls[44].calls++;
  return 0;
}

int_4 _qawc (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, 
real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limit_, int_4 _p_ lenw_, int_4 _p_ 
last_, int_4 _p_ iwork_, real_4 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) < 1 || (*lenw_) < (*limit_) * 4) {
    goto _l10;
  }
  l1_ = (*limit_) + 1;
  l2_ = (*limit_) + l1_;
  l3_ = (*limit_) + l2_;
  (void) _qawce (_f, a_, b_, c_, epsabs_, epsrel_, limit_, result_, abserr_, neval_, ier_, &work_[0], &work_[l1_ - 1], 
  &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_19, _dc_2, ier_, &lvl_);
  }
  __calls[45].calls++;
  return 0;
}

int_4 _qawfe (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ omega_, int_4 _p_ integr_, real_4 _p_ epsabs_, int_4 _p_ 
limlst_, int_4 _p_ limit_, int_4 _p_ maxp1_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, 
real_4 _p_ rslst_, real_4 _p_ erlst_, int_4 _p_ ierlst_, int_4 _p_ lst_, real_4 _p_ alist_, real_4 _p_ blist_, real_4 
_p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ nnlog_, real_4 _p_ chebmo_)
{
  static int_4 ktmin_, l_, ll_, nev_, nres_, numrl2_, last_, momcom_;
  static real_4 abseps_, correc_, cycle_, c1_, c2_, dl_, drl_, ep_, eps_, epsa_, errsum_, fact_, p_, pi_, p1_, psum_[52], 
  reseps_, res3la_[3], uflow_;
  int_4 _data_k_421, _data_k_422;
  real_4 $0_, $1_;
  extern real_4 _r1mach ();
#define _data_n_421 1
  static real_4 _data_l_421[_data_n_421] = {
    0.9e+00
  };
#define _data_n_422 1
  static real_4 _data_l_422[_data_n_422] = {
    0.31415926535897932e1
  };
  if (__calls[46].calls == 0) {
    _data_k_421 = 0;
    if (_data_k_421 >= _data_n_421) {
      _data_k_421 = 0;
    }
    p_ = _data_l_421[_data_k_421++];
    _data_k_422 = 0;
    if (_data_k_422 >= _data_n_422) {
      _data_k_422 = 0;
    }
    pi_ = _data_l_422[_data_k_422++];
  }
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  (*neval_) = 0;
  (*lst_) = 0;
  (*ier_) = 0;
  if (((*integr_) != 1 && (*integr_) != 2) || (*epsabs_) <= 0.0e+00 || (*limlst_) < 3) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  if ((*omega_) != 0.0e+00) {
    goto _l10;
  }
  if ((*integr_) == 1) {
    (void) _qagie (_f, a_, &_k1, epsabs_, ($0_ = 0.0, &$0_), limit_, result_, abserr_, neval_, ier_, alist_, blist_, 
    rlist_, elist_, iord_, &last_);
  }
  rslst_[0] = (*result_);
  erlst_[0] = (*abserr_);
  ierlst_[0] = (*ier_);
  (*lst_) = 1;
  goto _l999;
  _l10:;
  l_ = _abs ((*omega_));
  dl_ = 2 * l_ + 1;
  cycle_ = dl_ * pi_ / _abs ((*omega_));
  (*ier_) = 0;
  ktmin_ = 0;
  (*neval_) = 0;
  numrl2_ = 0;
  nres_ = 0;
  c1_ = (*a_);
  c2_ = cycle_ + (*a_);
  p1_ = 0.1e1 - p_;
  eps_ = (*epsabs_);
  uflow_ = _r1mach (&_k1);
  if ((*epsabs_) > uflow_ / p1_) {
    eps_ = (*epsabs_) * p1_;
  }
  ep_ = eps_;
  fact_ = 1.0;
  correc_ = 0.0;
  (*abserr_) = 0.0;
  errsum_ = 0.0;
  for ((*lst_) = 1; (*lst_) <= (*limlst_); ((*lst_))++) {
    epsa_ = eps_ * fact_;
    (void) _qawoe (_f, &c1_, &c2_, omega_, integr_, &epsa_, ($1_ = 0.0, &$1_), limit_, lst_, maxp1_, &rslst_[(*lst_) - 1], 
    &erlst_[(*lst_) - 1], &nev_, &ierlst_[(*lst_) - 1], &last_, alist_, blist_, rlist_, elist_, iord_, nnlog_, &momcom_, 
    chebmo_);
    (*neval_) = (*neval_) + nev_;
    fact_ = fact_ * p_;
    errsum_ = errsum_ + erlst_[(*lst_) - 1];
    drl_ = 0.5e2 * _abs (rslst_[(*lst_) - 1]);
    if (errsum_ + drl_ <= (*epsabs_) && (*lst_) >= 6) {
      goto _l80;
    }
    correc_ = _max (correc_, erlst_[(*lst_) - 1]);
    if (ierlst_[(*lst_) - 1] != 0) {
      eps_ = _max (ep_, correc_ * p1_);
    }
    if (ierlst_[(*lst_) - 1] != 0) {
      (*ier_) = 7;
    }
    if ((*ier_) == 7 && (errsum_ + drl_) <= correc_ * 0.1e2 && (*lst_) > 5) {
      goto _l80;
    }
    numrl2_ = numrl2_ + 1;
    if ((*lst_) > 1) {
      goto _l20;
    }
    psum_[0] = rslst_[0];
    goto _l40;
    _l20:;
    psum_[numrl2_ - 1] = psum_[ll_ - 1] + rslst_[(*lst_) - 1];
    if ((*lst_) == 2) {
      goto _l40;
    }
    if ((*lst_) == (*limlst_)) {
      (*ier_) = 1;
    }
    (void) _qelg (&numrl2_, psum_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ >= 15 && (*abserr_) <= 0.1e-2 * (errsum_ + drl_)) {
      (*ier_) = 4;
    }
    if (abseps_ > (*abserr_) && (*lst_) != 3) {
      goto _l30;
    }
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    ktmin_ = 0;
    if (((*abserr_) + 0.1e2 * correc_) <= (*epsabs_) || ((*abserr_) <= (*epsabs_) && 0.1e2 * correc_ >= (*epsabs_))) {
      goto _l60;
    }
    _l30:;
    if ((*ier_) != 0 && (*ier_) != 7) {
      goto _l60;
    }
    _l40:;
    ll_ = numrl2_;
    c1_ = c2_;
    c2_ = c2_ + cycle_;
  }
  _l60:;
  (*abserr_) = (*abserr_) + 0.1e2 * correc_;
  if ((*ier_) == 0) {
    goto _l999;
  }
  if ((*result_) != 0.0e+00 && psum_[numrl2_ - 1] != 0.0e+00) {
    goto _l70;
  }
  if ((*abserr_) > errsum_) {
    goto _l80;
  }
  if (psum_[numrl2_ - 1] == 0.0e+00) {
    goto _l999;
  }
  _l70:;
  if ((*abserr_) / _abs ((*result_)) > (errsum_ + drl_) / _abs (psum_[numrl2_ - 1])) {
    goto _l80;
  }
  if ((*ier_) >= 1 && (*ier_) != 7) {
    (*abserr_) = (*abserr_) + drl_;
  }
  goto _l999;
  _l80:;
  (*result_) = psum_[numrl2_ - 1];
  (*abserr_) = errsum_ + drl_;
  _l999:;
  __calls[46].calls++;
  return 0;
}

int_4 _qawf (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ omega_, int_4 _p_ integr_, real_4 _p_ epsabs_, real_4 _p_ 
result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ limlst_, int_4 _p_ lst_, int_4 _p_ leniw_, 
int_4 _p_ maxp1_, int_4 _p_ lenw_, int_4 _p_ iwork_, real_4 _p_ work_)
{
  static int_4 limit_, lvl_, l1_, l2_, l3_, l4_, l5_, l6_, ll2_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limlst_) < 3 || (*leniw_) < ((*limlst_) + 2) || (*maxp1_) < 1 || (*lenw_) < ((*leniw_) * 2 + (*maxp1_) * 25)) {
    goto _l10;
  }
  limit_ = ((*leniw_) - (*limlst_)) / 2;
  l1_ = (*limlst_) + 1;
  l2_ = (*limlst_) + l1_;
  l3_ = limit_ + l2_;
  l4_ = limit_ + l3_;
  l5_ = limit_ + l4_;
  l6_ = limit_ + l5_;
  ll2_ = limit_ + l1_;
  (void) _qawfe (_f, a_, omega_, integr_, epsabs_, limlst_, &limit_, maxp1_, result_, abserr_, neval_, ier_, &work_[0], 
  &work_[l1_ - 1], &iwork_[0], lst_, &work_[l2_ - 1], &work_[l3_ - 1], &work_[l4_ - 1], &work_[l5_ - 1], &iwork_[l1_ - 
  1], &iwork_[ll2_ - 1], &work_[l6_ - 1]);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_20, _dc_2, ier_, &lvl_);
  }
  __calls[47].calls++;
  return 0;
}

int_4 _qawoe (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ omega_, int_4 _p_ integr_, real_4 _p_ epsabs_, 
real_4 _p_ epsrel_, int_4 _p_ limit_, int_4 _p_ icall_, int_4 _p_ maxp1_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 
_p_ neval_, int_4 _p_ ier_, int_4 _p_ last_, real_4 _p_ alist_, real_4 _p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_
, int_4 _p_ iord_, int_4 _p_ nnlog_, int_4 _p_ momcom_, real_4 _p_ chebmo_)
{
  static int_4 id_, ierro_, iroff1_, iroff2_, iroff3_, jupbnd_, k_, ksgn_, ktmin_, maxerr_, nev_, nres_, nrmax_, nrmom_, 
  numrl2_;
  static logical_4 extrap_, noext_, extall_;
  static real_4 abseps_, area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, correc_, defab1_, defab2_, defabs_, domega_, 
  dres_, epmach_, erlarg_, erlast_, errbnd_, errmax_, error1_, erro12_, error2_, errsum_, ertest_, oflow_, resabs_, 
  reseps_, res3la_[3], rlist2_[52], small_, uflow_, width_;
  int_4 $0_, $1_;
  extern real_4 _r1mach ();
  epmach_ = _r1mach (($0_ = 4, &$0_));
  (*ier_) = 0;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  alist_[0] = (*a_);
  blist_[0] = (*b_);
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  nnlog_[0] = 0;
  if (((*integr_) != 1 && (*integr_) != 2) || ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-15)) || 
    (*icall_) < 1 || (*maxp1_) < 1) {
    (*ier_) = 6;
  }
  if ((*ier_) == 6) {
    goto _l999;
  }
  domega_ = _abs ((*omega_));
  nrmom_ = 0;
  if ((*icall_) > 1) {
    goto _l5;
  }
  (*momcom_) = 0;
  _l5:;
  (void) _qc25f (_f, a_, b_, &domega_, integr_, &nrmom_, maxp1_, &_k0, result_, abserr_, neval_, &defabs_, &resabs_, 
  momcom_, chebmo_);
  dres_ = _abs ((*result_));
  errbnd_ = _max ((*epsabs_), (*epsrel_) * dres_);
  rlist_[0] = (*result_);
  elist_[0] = (*abserr_);
  iord_[0] = 1;
  if ((*abserr_) <= 0.1e3 * epmach_ * defabs_ && (*abserr_) > errbnd_) {
    (*ier_) = 2;
  }
  if ((*limit_) == 1) {
    (*ier_) = 1;
  }
  if ((*ier_) != 0 || (*abserr_) <= errbnd_) {
    goto _l200;
  }
  uflow_ = _r1mach (&_k1);
  oflow_ = _r1mach (($1_ = 2, &$1_));
  errmax_ = (*abserr_);
  maxerr_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  (*abserr_) = oflow_;
  nrmax_ = 1;
  extrap_ = FALSE;
  noext_ = FALSE;
  ierro_ = 0;
  iroff1_ = 0;
  iroff2_ = 0;
  iroff3_ = 0;
  ktmin_ = 0;
  small_ = _abs ((*b_) - (*a_)) * 0.75e+00;
  nres_ = 0;
  numrl2_ = 0;
  extall_ = FALSE;
  if (0.5e+00 * _abs ((*b_) - (*a_)) * domega_ > 0.2e1) {
    goto _l10;
  }
  numrl2_ = 1;
  extall_ = TRUE;
  rlist2_[0] = (*result_);
  _l10:;
  if (0.25e+00 * _abs ((*b_) - (*a_)) * domega_ <= 0.2e1) {
    extall_ = TRUE;
  }
  ksgn_ = -1;
  if (dres_ >= (0.1e1 - 0.5e2 * epmach_) * defabs_) {
    ksgn_ = 1;
  }
  for ((*last_) = 2; (*last_) <= (*limit_); ((*last_))++) {
    nrmom_ = nnlog_[maxerr_ - 1] + 1;
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    erlast_ = errmax_;
    (void) _qc25f (_f, &a1_, &b1_, &domega_, integr_, &nrmom_, maxp1_, &_k0, &area1_, &error1_, &nev_, &resabs_, &defab1_, 
    momcom_, chebmo_);
    (*neval_) = (*neval_) + nev_;
    (void) _qc25f (_f, &a2_, &b2_, &domega_, integr_, &nrmom_, maxp1_, &_k1, &area2_, &error2_, &nev_, &resabs_, &defab2_, 
    momcom_, chebmo_);
    (*neval_) = (*neval_) + nev_;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if (defab1_ == error1_ || defab2_ == error2_) {
      goto _l25;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) > 0.1e-4 * _abs (area12_) || erro12_ < 0.99e+00 * errmax_) {
      goto _l20;
    }
    if (extrap_) {
      iroff2_ = iroff2_ + 1;
    }
    if (! (extrap_)) {
      iroff1_ = iroff1_ + 1;
    }
    _l20:;
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff3_ = iroff3_ + 1;
    }
    _l25:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    nnlog_[maxerr_ - 1] = nrmom_;
    nnlog_[(*last_) - 1] = nrmom_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (iroff1_ + iroff2_ >= 10 || iroff3_ >= 20) {
      (*ier_) = 2;
    }
    if (iroff2_ >= 5) {
      ierro_ = 3;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 4;
    }
    if (error2_ > error1_) {
      goto _l30;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l40;
    _l30:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l40:;
    (void) _qpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if (errsum_ <= errbnd_) {
      goto _l170;
    }
    if ((*ier_) != 0) {
      goto _l150;
    }
    if ((*last_) == 2 && extall_) {
      goto _l120;
    }
    if (noext_) {
      goto _l140;
    }
    if (! (extall_)) {
      goto _l50;
    }
    erlarg_ = erlarg_ - erlast_;
    if (_abs (b1_ - a1_) > small_) {
      erlarg_ = erlarg_ + erro12_;
    }
    if (extrap_) {
      goto _l70;
    }
    _l50:;
    width_ = _abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]);
    if (width_ > small_) {
      goto _l140;
    }
    if (extall_) {
      goto _l60;
    }
    small_ = small_ * 0.5e+00;
    if (0.25e+00 * width_ * domega_ > 0.2e1) {
      goto _l140;
    }
    extall_ = TRUE;
    goto _l130;
    _l60:;
    extrap_ = TRUE;
    nrmax_ = 2;
    _l70:;
    if (ierro_ == 3 || erlarg_ <= ertest_) {
      goto _l90;
    }
    jupbnd_ = (*last_);
    if ((*last_) > ((*limit_) / 2 + 2)) {
      jupbnd_ = (*limit_) + 3 - (*last_);
    }
    id_ = nrmax_;
    for (k_ = id_; k_ <= jupbnd_; (k_)++) {
      maxerr_ = iord_[nrmax_ - 1];
      errmax_ = elist_[maxerr_ - 1];
      if (_abs (blist_[maxerr_ - 1] - alist_[maxerr_ - 1]) > small_) {
        goto _l140;
      }
      nrmax_ = nrmax_ + 1;
    }
    _l90:;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    if (numrl2_ < 3) {
      goto _l110;
    }
    (void) _qelg (&numrl2_, rlist2_, &reseps_, &abseps_, res3la_, &nres_);
    ktmin_ = ktmin_ + 1;
    if (ktmin_ > 5 && (*abserr_) < 0.1e-2 * errsum_) {
      (*ier_) = 5;
    }
    if (abseps_ >= (*abserr_)) {
      goto _l100;
    }
    ktmin_ = 0;
    (*abserr_) = abseps_;
    (*result_) = reseps_;
    correc_ = erlarg_;
    ertest_ = _max ((*epsabs_), (*epsrel_) * _abs (reseps_));
    if ((*abserr_) <= ertest_) {
      goto _l150;
    }
    _l100:;
    if (numrl2_ == 1) {
      noext_ = TRUE;
    }
    if ((*ier_) == 5) {
      goto _l150;
    }
    _l110:;
    maxerr_ = iord_[0];
    errmax_ = elist_[maxerr_ - 1];
    nrmax_ = 1;
    extrap_ = FALSE;
    small_ = small_ * 0.5e+00;
    erlarg_ = errsum_;
    goto _l140;
    _l120:;
    small_ = small_ * 0.5e+00;
    numrl2_ = numrl2_ + 1;
    rlist2_[numrl2_ - 1] = area_;
    _l130:;
    ertest_ = errbnd_;
    erlarg_ = errsum_;
    _l140:;
  }
  _l150:;
  if ((*abserr_) == oflow_ || nres_ == 0) {
    goto _l170;
  }
  if ((*ier_) + ierro_ == 0) {
    goto _l165;
  }
  if (ierro_ == 3) {
    (*abserr_) = (*abserr_) + correc_;
  }
  if ((*ier_) == 0) {
    (*ier_) = 3;
  }
  if ((*result_) != 0.0e+00 && area_ != 0.0e+00) {
    goto _l160;
  }
  if ((*abserr_) > errsum_) {
    goto _l170;
  }
  if (area_ == 0.0e+00) {
    goto _l190;
  }
  goto _l165;
  _l160:;
  if ((*abserr_) / _abs ((*result_)) > errsum_ / _abs (area_)) {
    goto _l170;
  }
  _l165:;
  if (ksgn_ == -1 && _max (_abs ((*result_)), _abs (area_)) <= defabs_ * 0.1e-1) {
    goto _l190;
  }
  if (0.1e-1 > ((*result_) / area_) || ((*result_) / area_) > 0.1e3 || errsum_ >= _abs (area_)) {
    (*ier_) = 6;
  }
  goto _l190;
  _l170:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l190:;
  if ((*ier_) > 2) {
    (*ier_) = (*ier_) - 1;
  }
  _l200:;
  if ((*integr_) == 2 && (*omega_) < 0.0e+00) {
    (*result_) = -(*result_);
  }
  _l999:;
  __calls[48].calls++;
  return 0;
}

int_4 _qawo (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ omega_, int_4 _p_ integr_, real_4 _p_ epsabs_, 
real_4 _p_ epsrel_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 _p_ leniw_, int_4 
_p_ maxp1_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_4 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_, l4_, momcom_, limit_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*leniw_) < 2 || (*maxp1_) < 1 || (*lenw_) < ((*leniw_) * 2 + (*maxp1_) * 25)) {
    goto _l10;
  }
  limit_ = (*leniw_) / 2;
  l1_ = limit_ + 1;
  l2_ = limit_ + l1_;
  l3_ = limit_ + l2_;
  l4_ = limit_ + l3_;
  (void) _qawoe (_f, a_, b_, omega_, integr_, epsabs_, epsrel_, &limit_, &_k1, maxp1_, result_, abserr_, neval_, ier_, 
  last_, &work_[0], &work_[l1_ - 1], &work_[l2_ - 1], &work_[l3_ - 1], &iwork_[0], &iwork_[l1_ - 1], &momcom_, &work_[l4_ 
  - 1]);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_21, _dc_2, ier_, &lvl_);
  }
  __calls[49].calls++;
  return 0;
}

int_4 _qawse (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ alfa_, real_4 _p_ beta_, int_4 _p_ integr_, 
real_4 _p_ epsabs_, real_4 _p_ epsrel_, int_4 _p_ limit_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, 
int_4 _p_ ier_, real_4 _p_ alist_, real_4 _p_ blist_, real_4 _p_ rlist_, real_4 _p_ elist_, int_4 _p_ iord_, int_4 _p_ 
last_)
{
  static int_4 iroff1_, iroff2_, k_, maxerr_, nev_, nrmax_;
  static real_4 area_, area1_, area12_, area2_, a1_, a2_, b1_, b2_, centre_, epmach_, errbnd_, errmax_, error1_, erro12_, 
  error2_, errsum_, resas1_, resas2_, rg_[25], rh_[25], ri_[25], rj_[25], uflow_;
  int_4 $0_;
  extern real_4 _r1mach ();
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  rlist_[0] = 0.0;
  elist_[0] = 0.0;
  iord_[0] = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*b_) <= (*a_) || ((*epsabs_) == 0.0e+00 && (*epsrel_) < _max (0.5e2 * epmach_, 5.0e-15)) || (*alfa_) <= -1.0 || 
    (*beta_) <= -1.0 || (*integr_) < 1 || (*integr_) > 4 || (*limit_) < 2) {
    goto _l999;
  }
  (*ier_) = 0;
  (void) _qmomo (alfa_, beta_, ri_, rj_, rg_, rh_, integr_);
  centre_ = 0.5e+00 * ((*b_) + (*a_));
  (void) _qc25s (_f, a_, b_, a_, &centre_, alfa_, beta_, ri_, rj_, rg_, rh_, &area1_, &error1_, &resas1_, integr_, &nev_)
  ;
  (*neval_) = nev_;
  (void) _qc25s (_f, a_, b_, &centre_, b_, alfa_, beta_, ri_, rj_, rg_, rh_, &area2_, &error2_, &resas2_, integr_, &nev_)
  ;
  (*last_) = 2;
  (*neval_) = (*neval_) + nev_;
  (*result_) = area1_ + area2_;
  (*abserr_) = error1_ + error2_;
  errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs ((*result_)));
  if (error2_ > error1_) {
    goto _l10;
  }
  alist_[0] = (*a_);
  alist_[1] = centre_;
  blist_[0] = centre_;
  blist_[1] = (*b_);
  rlist_[0] = area1_;
  rlist_[1] = area2_;
  elist_[0] = error1_;
  elist_[1] = error2_;
  goto _l20;
  _l10:;
  alist_[0] = centre_;
  alist_[1] = (*a_);
  blist_[0] = (*b_);
  blist_[1] = centre_;
  rlist_[0] = area2_;
  rlist_[1] = area1_;
  elist_[0] = error2_;
  elist_[1] = error1_;
  _l20:;
  iord_[0] = 1;
  iord_[1] = 2;
  if ((*limit_) == 2) {
    (*ier_) = 1;
  }
  if ((*abserr_) <= errbnd_ || (*ier_) == 1) {
    goto _l999;
  }
  errmax_ = elist_[0];
  maxerr_ = 1;
  nrmax_ = 1;
  area_ = (*result_);
  errsum_ = (*abserr_);
  iroff1_ = 0;
  iroff2_ = 0;
  for ((*last_) = 3; (*last_) <= (*limit_); ((*last_))++) {
    a1_ = alist_[maxerr_ - 1];
    b1_ = 0.5e+00 * (alist_[maxerr_ - 1] + blist_[maxerr_ - 1]);
    a2_ = b1_;
    b2_ = blist_[maxerr_ - 1];
    (void) _qc25s (_f, a_, b_, &a1_, &b1_, alfa_, beta_, ri_, rj_, rg_, rh_, &area1_, &error1_, &resas1_, integr_, &nev_);
    (*neval_) = (*neval_) + nev_;
    (void) _qc25s (_f, a_, b_, &a2_, &b2_, alfa_, beta_, ri_, rj_, rg_, rh_, &area2_, &error2_, &resas2_, integr_, &nev_);
    (*neval_) = (*neval_) + nev_;
    area12_ = area1_ + area2_;
    erro12_ = error1_ + error2_;
    errsum_ = errsum_ + erro12_ - errmax_;
    area_ = area_ + area12_ - rlist_[maxerr_ - 1];
    if ((*a_) == a1_ || (*b_) == b2_) {
      goto _l30;
    }
    if (resas1_ == error1_ || resas2_ == error2_) {
      goto _l30;
    }
    if (_abs (rlist_[maxerr_ - 1] - area12_) < 0.1e-4 * _abs (area12_) && erro12_ >= 0.99e+00 * errmax_) {
      iroff1_ = iroff1_ + 1;
    }
    if ((*last_) > 10 && erro12_ > errmax_) {
      iroff2_ = iroff2_ + 1;
    }
    _l30:;
    rlist_[maxerr_ - 1] = area1_;
    rlist_[(*last_) - 1] = area2_;
    errbnd_ = _max ((*epsabs_), (*epsrel_) * _abs (area_));
    if (errsum_ <= errbnd_) {
      goto _l35;
    }
    if ((*last_) == (*limit_)) {
      (*ier_) = 1;
    }
    if (iroff1_ >= 6 || iroff2_ >= 20) {
      (*ier_) = 2;
    }
    if (_max (_abs (a1_), _abs (b2_)) <= (0.1e1 + 0.1e3 * epmach_) * (_abs (a2_) + 0.1e4 * uflow_)) {
      (*ier_) = 3;
    }
    _l35:;
    if (error2_ > error1_) {
      goto _l40;
    }
    alist_[(*last_) - 1] = a2_;
    blist_[maxerr_ - 1] = b1_;
    blist_[(*last_) - 1] = b2_;
    elist_[maxerr_ - 1] = error1_;
    elist_[(*last_) - 1] = error2_;
    goto _l50;
    _l40:;
    alist_[maxerr_ - 1] = a2_;
    alist_[(*last_) - 1] = a1_;
    blist_[(*last_) - 1] = b1_;
    rlist_[maxerr_ - 1] = area2_;
    rlist_[(*last_) - 1] = area1_;
    elist_[maxerr_ - 1] = error2_;
    elist_[(*last_) - 1] = error1_;
    _l50:;
    (void) _qpsrt (limit_, last_, &maxerr_, &errmax_, elist_, iord_, &nrmax_);
    if ((*ier_) != 0 || errsum_ <= errbnd_) {
      goto _l70;
    }
  }
  _l70:;
  (*result_) = 0.0;
  for (k_ = 1; k_ <= (*last_); (k_)++) {
    (*result_) = (*result_) + rlist_[k_ - 1];
  }
  (*abserr_) = errsum_;
  _l999:;
  __calls[50].calls++;
  return 0;
}

int_4 _qaws (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ alfa_, real_4 _p_ beta_, int_4 _p_ integr_, 
real_4 _p_ epsabs_, real_4 _p_ epsrel_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_, int_4 
_p_ limit_, int_4 _p_ lenw_, int_4 _p_ last_, int_4 _p_ iwork_, real_4 _p_ work_)
{
  static int_4 lvl_, l1_, l2_, l3_;
  (*ier_) = 6;
  (*neval_) = 0;
  (*last_) = 0;
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  if ((*limit_) < 2 || (*lenw_) < (*limit_) * 4) {
    goto _l10;
  }
  l1_ = (*limit_) + 1;
  l2_ = (*limit_) + l1_;
  l3_ = (*limit_) + l2_;
  (void) _qawse (_f, a_, b_, alfa_, beta_, integr_, epsabs_, epsrel_, limit_, result_, abserr_, neval_, ier_, &work_[0], 
  &work_[l1_ - 1], &work_[l2_ - 1], &work_[l3_ - 1], iwork_, last_);
  lvl_ = 0;
  _l10:;
  if ((*ier_) == 6) {
    lvl_ = 1;
  }
  if ((*ier_) != 0) {
    (void) _xermsg (_dc_0, _dc_22, _dc_2, ier_, &lvl_);
  }
  __calls[51].calls++;
  return 0;
}

int_4 _qc25c (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ result_, real_4 _p_ abserr_, 
int_4 _p_ krul_, int_4 _p_ neval_)
{
  static int_4 i_, isym_, k_, kp_;
  static real_4 ak22_, amom0_, amom1_, amom2_, cc_, centr_, cheb12_[13], cheb24_[25], fval_[25], hlgth_, p2_, p3_, p4_, 
  resabs_, resasc_, res12_, res24_, u_, x_[11];
  int_4 _data_k_423;
  real_4 $0_, $1_, $2_, $3_;
#define _data_n_423 11
  static real_4 _data_l_423[_data_n_423] = {
    0.9914448613738104e+00,
    0.9659258262890683e+00,
    0.9238795325112868e+00,
    0.8660254037844386e+00,
    0.7933533402912352e+00,
    0.7071067811865475e+00,
    0.6087614290087206e+00,
    0.5e+00,
    0.3826834323650898e+00,
    0.2588190451025208e+00,
    0.1305261922200516e+00
  };
  if (__calls[52].calls == 0) {
    _data_k_423 = 0;
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[0] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[1] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[2] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[3] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[4] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[5] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[6] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[7] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[8] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[9] = _data_l_423[_data_k_423++];
    if (_data_k_423 >= _data_n_423) {
      _data_k_423 = 0;
    }
    x_[10] = _data_l_423[_data_k_423++];
  }
  cc_ = (0.2e1 * (*c_) - (*b_) - (*a_)) / ((*b_) - (*a_));
  if (_abs (cc_) < 0.11e1) {
    goto _l10;
  }
  (*krul_) = (*krul_) - 1;
  (void) _qk15w (_f, _qwgtc, c_, &p2_, &p3_, &p4_, &kp_, a_, b_, result_, abserr_, &resabs_, &resasc_);
  (*neval_) = 15;
  if (resasc_ == (*abserr_)) {
    (*krul_) = (*krul_) + 1;
  }
  goto _l50;
  _l10:;
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  centr_ = 0.5e+00 * ((*b_) + (*a_));
  (*neval_) = 25;
  fval_[0] = 0.5e+00 * _f (($0_ = hlgth_ + centr_, &$0_));
  fval_[12] = _f (&centr_);
  fval_[24] = 0.5e+00 * _f (($1_ = centr_ - hlgth_, &$1_));
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = _f (($2_ = u_ + centr_, &$2_));
    fval_[isym_ - 1] = _f (($3_ = centr_ - u_, &$3_));
  }
  (void) _qcheb (x_, fval_, cheb12_, cheb24_);
  amom0_ = logf (_abs ((0.1e1 - cc_) / (0.1e1 + cc_)));
  amom1_ = 0.2e1 + cc_ * amom0_;
  res12_ = cheb12_[0] * amom0_ + cheb12_[1] * amom1_;
  res24_ = cheb24_[0] * amom0_ + cheb24_[1] * amom1_;
  for (k_ = 3; k_ <= 13; (k_)++) {
    amom2_ = 0.2e1 * cc_ * amom1_ - amom0_;
    ak22_ = (k_ - 2) * (k_ - 2);
    if ((k_ / 2) * 2 == k_) {
      amom2_ = amom2_ - 0.4e1 / (ak22_ - 0.1e1);
    }
    res12_ = res12_ + cheb12_[k_ - 1] * amom2_;
    res24_ = res24_ + cheb24_[k_ - 1] * amom2_;
    amom0_ = amom1_;
    amom1_ = amom2_;
  }
  for (k_ = 14; k_ <= 25; (k_)++) {
    amom2_ = 0.2e1 * cc_ * amom1_ - amom0_;
    ak22_ = (k_ - 2) * (k_ - 2);
    if ((k_ / 2) * 2 == k_) {
      amom2_ = amom2_ - 0.4e1 / (ak22_ - 0.1e1);
    }
    res24_ = res24_ + cheb24_[k_ - 1] * amom2_;
    amom0_ = amom1_;
    amom1_ = amom2_;
  }
  (*result_) = res24_;
  (*abserr_) = _abs (res24_ - res12_);
  _l50:;
  __calls[52].calls++;
  return 0;
}

int_4 _qc25f (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ omega_, int_4 _p_ integr_, int_4 _p_ nrmom_, 
int_4 _p_ maxp1_, int_4 _p_ ksave_, real_4 _p_ result_, real_4 _p_ abserr_, int_4 _p_ neval_, real_4 _p_ resabs_, 
real_4 _p_ resasc_, int_4 _p_ momcom_, real_4 _p_ chebmo_)
{
  static int_4 i_, iers_, isym_, j_, k_, m_, noequ_, noeq1_;
  static real_4 ac_, an_, an2_, as_, asap_, ass_, centr_, cheb12_[13], cheb24_[25], conc_, cons_, cospar_, d_[25], 
  d1_[25], d2_[25], estc_, ests_, fval_[25], hlgth_, oflow_, parint_, par2_, par22_, p2_, p3_, p4_, resc12_, resc24_, 
  ress12_, ress24_, sinpar_, v_[28], x_[11];
  int_4 _data_k_424, $0_;
  real_4 $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_424 11
  static real_4 _data_l_424[_data_n_424] = {
    0.9914448613738104e+00,
    0.9659258262890683e+00,
    0.9238795325112868e+00,
    0.8660254037844386e+00,
    0.7933533402912352e+00,
    0.7071067811865475e+00,
    0.6087614290087206e+00,
    0.5e+00,
    0.3826834323650898e+00,
    0.2588190451025208e+00,
    0.1305261922200516e+00
  };
  if (__calls[53].calls == 0) {
    _data_k_424 = 0;
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[0] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[1] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[2] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[3] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[4] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[5] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[6] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[7] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[8] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[9] = _data_l_424[_data_k_424++];
    if (_data_k_424 >= _data_n_424) {
      _data_k_424 = 0;
    }
    x_[10] = _data_l_424[_data_k_424++];
  }
  oflow_ = _r1mach (($0_ = 2, &$0_));
  centr_ = 0.5e+00 * ((*b_) + (*a_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  parint_ = (*omega_) * hlgth_;
  if (_abs (parint_) > 0.2e1) {
    goto _l10;
  }
  (void) _qk15w (_f, _qwgtf, omega_, &p2_, &p3_, &p4_, integr_, a_, b_, result_, abserr_, resabs_, resasc_);
  (*neval_) = 15;
  goto _l170;
  _l10:;
  conc_ = hlgth_ * cosf (centr_ * (*omega_));
  cons_ = hlgth_ * sinf (centr_ * (*omega_));
  (*resasc_) = oflow_;
  (*neval_) = 25;
  if ((*nrmom_) < (*momcom_) || (*ksave_) == 1) {
    goto _l120;
  }
  m_ = (*momcom_) + 1;
  par2_ = parint_ * parint_;
  par22_ = par2_ + 0.2e1;
  sinpar_ = sinf (parint_);
  cospar_ = cosf (parint_);
  v_[0] = 0.2e1 * sinpar_ / parint_;
  v_[1] = (0.8e1 * cospar_ + (par2_ + par2_ - 0.8e1) * sinpar_ / parint_) / par2_;
  v_[2] = (0.32e2 * (par2_ - 0.12e2) * cospar_ + (0.2e1 * ((par2_ - 0.8e2) * par2_ + 0.192e3) * sinpar_) / parint_) / 
  (par2_ * par2_);
  ac_ = 0.8e1 * cospar_;
  as_ = 0.24e2 * parint_ * sinpar_;
  if (_abs (parint_) > 0.24e2) {
    goto _l30;
  }
  noequ_ = 25;
  noeq1_ = noequ_ - 1;
  an_ = 6.0;
  for (k_ = 1; k_ <= noeq1_; (k_)++) {
    an2_ = an_ * an_;
    d_[k_ - 1] = -0.2e1 * (an2_ - 0.4e1) * (par22_ - an2_ - an2_);
    d2_[k_ - 1] = (an_ - 0.1e1) * (an_ - 0.2e1) * par2_;
    d1_[k_ + 1 - 1] = (an_ + 0.3e1) * (an_ + 0.4e1) * par2_;
    v_[k_ + 3 - 1] = as_ - (an2_ - 0.4e1) * ac_;
    an_ = an_ + 0.2e1;
  }
  an2_ = an_ * an_;
  d_[noequ_ - 1] = -0.2e1 * (an2_ - 0.4e1) * (par22_ - an2_ - an2_);
  v_[noequ_ + 3 - 1] = as_ - (an2_ - 0.4e1) * ac_;
  v_[3] = v_[3] - 0.56e2 * par2_ * v_[2];
  ass_ = parint_ * sinpar_;
  asap_ = (((((0.21e3 * par2_ - 0.1e1) * cospar_ - (0.105e3 * par2_ - 0.63e2) * ass_) / an2_ - (0.1e1 - 0.15e2 * par2_) * 
  cospar_ + 0.15e2 * ass_) / an2_ - cospar_ + 0.3e1 * ass_) / an2_ - cospar_) / an2_;
  v_[noequ_ + 3 - 1] = v_[noequ_ + 3 - 1] - 0.2e1 * asap_ * par2_ * (an_ - 0.1e1) * (an_ - 0.2e1);
  (void) _sgtsl (&noequ_, d1_, d_, d2_, &v_[3], &iers_);
  goto _l50;
  _l30:;
  an_ = 4.0;
  for (i_ = 4; i_ <= 13; (i_)++) {
    an2_ = an_ * an_;
    v_[i_ - 1] = ((an2_ - 0.4e1) * (0.2e1 * (par22_ - an2_ - an2_) * v_[i_ - 1 - 1] - ac_) + as_ - par2_ * (an_ + 0.1e1) * 
    (an_ + 0.2e1) * v_[i_ - 2 - 1]) / (par2_ * (an_ - 0.1e1) * (an_ - 0.2e1));
    an_ = an_ + 0.2e1;
  }
  _l50:;
  for (j_ = 1; j_ <= 13; (j_)++) {
    chebmo_[m_ - 1 + ((*maxp1_)) * ((2 * j_ - 1 - 1))] = v_[j_ - 1];
  }
  v_[0] = 0.2e1 * (sinpar_ - parint_ * cospar_) / par2_;
  v_[1] = (0.18e2 - 0.48e2 / par2_) * sinpar_ / par2_ + (-0.2e1 + 0.48e2 / par2_) * cospar_ / parint_;
  ac_ = -0.24e2 * parint_ * cospar_;
  as_ = -0.8e1 * sinpar_;
  if (_abs (parint_) > 0.24e2) {
    goto _l80;
  }
  an_ = 5.0;
  for (k_ = 1; k_ <= noeq1_; (k_)++) {
    an2_ = an_ * an_;
    d_[k_ - 1] = -0.2e1 * (an2_ - 0.4e1) * (par22_ - an2_ - an2_);
    d2_[k_ - 1] = (an_ - 0.1e1) * (an_ - 0.2e1) * par2_;
    d1_[k_ + 1 - 1] = (an_ + 0.3e1) * (an_ + 0.4e1) * par2_;
    v_[k_ + 2 - 1] = ac_ + (an2_ - 0.4e1) * as_;
    an_ = an_ + 0.2e1;
  }
  an2_ = an_ * an_;
  d_[noequ_ - 1] = -0.2e1 * (an2_ - 0.4e1) * (par22_ - an2_ - an2_);
  v_[noequ_ + 2 - 1] = ac_ + (an2_ - 0.4e1) * as_;
  v_[2] = v_[2] - 0.42e2 * par2_ * v_[1];
  ass_ = parint_ * cospar_;
  asap_ = (((((0.105e3 * par2_ - 0.63e2) * ass_ + (0.21e3 * par2_ - 0.1e1) * sinpar_) / an2_ + (0.15e2 * par2_ - 0.1e1) * 
  sinpar_ - 0.15e2 * ass_) / an2_ - 0.3e1 * ass_ - sinpar_) / an2_ - sinpar_) / an2_;
  v_[noequ_ + 2 - 1] = v_[noequ_ + 2 - 1] - 0.2e1 * asap_ * par2_ * (an_ - 0.1e1) * (an_ - 0.2e1);
  (void) _sgtsl (&noequ_, d1_, d_, d2_, &v_[2], &iers_);
  goto _l100;
  _l80:;
  an_ = 3.0;
  for (i_ = 3; i_ <= 12; (i_)++) {
    an2_ = an_ * an_;
    v_[i_ - 1] = ((an2_ - 0.4e1) * (0.2e1 * (par22_ - an2_ - an2_) * v_[i_ - 1 - 1] + as_) + ac_ - par2_ * (an_ + 0.1e1) * 
    (an_ + 0.2e1) * v_[i_ - 2 - 1]) / (par2_ * (an_ - 0.1e1) * (an_ - 0.2e1));
    an_ = an_ + 0.2e1;
  }
  _l100:;
  for (j_ = 1; j_ <= 12; (j_)++) {
    chebmo_[m_ - 1 + ((*maxp1_)) * ((2 * j_ - 1))] = v_[j_ - 1];
  }
  _l120:;
  if ((*nrmom_) < (*momcom_)) {
    m_ = (*nrmom_) + 1;
  }
  if ((*momcom_) < (*maxp1_) - 1 && (*nrmom_) >= (*momcom_)) {
    (*momcom_) = (*momcom_) + 1;
  }
  fval_[0] = 0.5e+00 * _f (($1_ = centr_ + hlgth_, &$1_));
  fval_[12] = _f (&centr_);
  fval_[24] = 0.5e+00 * _f (($2_ = centr_ - hlgth_, &$2_));
  for (i_ = 2; i_ <= 12; (i_)++) {
    isym_ = 26 - i_;
    fval_[i_ - 1] = _f (($3_ = hlgth_ * x_[i_ - 1 - 1] + centr_, &$3_));
    fval_[isym_ - 1] = _f (($4_ = centr_ - hlgth_ * x_[i_ - 1 - 1], &$4_));
  }
  (void) _qcheb (x_, fval_, cheb12_, cheb24_);
  resc12_ = cheb12_[12] * chebmo_[m_ - 1 + ((*maxp1_)) * ((12))];
  ress12_ = 0.0;
  k_ = 11;
  for (j_ = 1; j_ <= 6; (j_)++) {
    resc12_ = resc12_ + cheb12_[k_ - 1] * chebmo_[m_ - 1 + ((*maxp1_)) * ((k_ - 1))];
    ress12_ = ress12_ + cheb12_[k_ + 1 - 1] * chebmo_[m_ - 1 + ((*maxp1_)) * ((k_ + 1 - 1))];
    k_ = k_ - 2;
  }
  resc24_ = cheb24_[24] * chebmo_[m_ - 1 + ((*maxp1_)) * ((24))];
  ress24_ = 0.0;
  (*resabs_) = _abs (cheb24_[24]);
  k_ = 23;
  for (j_ = 1; j_ <= 12; (j_)++) {
    resc24_ = resc24_ + cheb24_[k_ - 1] * chebmo_[m_ - 1 + ((*maxp1_)) * ((k_ - 1))];
    ress24_ = ress24_ + cheb24_[k_ + 1 - 1] * chebmo_[m_ - 1 + ((*maxp1_)) * ((k_ + 1 - 1))];
    (*resabs_) = _abs (cheb24_[k_ - 1]) + _abs (cheb24_[k_ + 1 - 1]);
    k_ = k_ - 2;
  }
  estc_ = _abs (resc24_ - resc12_);
  ests_ = _abs (ress24_ - ress12_);
  (*resabs_) = (*resabs_) * _abs (hlgth_);
  if ((*integr_) == 2) {
    goto _l160;
  }
  (*result_) = conc_ * resc24_ - cons_ * ress24_;
  (*abserr_) = _abs (conc_ * estc_) + _abs (cons_ * ests_);
  goto _l170;
  _l160:;
  (*result_) = conc_ * ress24_ + cons_ * resc24_;
  (*abserr_) = _abs (conc_ * ests_) + _abs (cons_ * estc_);
  _l170:;
  __calls[53].calls++;
  return 0;
}

int_4 _qc25s (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ bl_, real_4 _p_ br_, real_4 _p_ alfa_, real_4 
_p_ beta_, real_4 _p_ ri_, real_4 _p_ rj_, real_4 _p_ rg_, real_4 _p_ rh_, real_4 _p_ result_, real_4 _p_ abserr_, 
real_4 _p_ resasc_, int_4 _p_ integr_, int_4 _p_ nev_)
{
  static int_4 i_, isym_;
  static real_4 centr_, cheb12_[13], cheb24_[25], dc_, factor_, fix_, fval_[25], hlgth_, resabs_, res12_, res24_, u_, 
  x_[11];
  int_4 _data_k_425;
  real_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_;
#define _data_n_425 11
  static real_4 _data_l_425[_data_n_425] = {
    0.9914448613738104e+00,
    0.9659258262890683e+00,
    0.9238795325112868e+00,
    0.8660254037844386e+00,
    0.7933533402912352e+00,
    0.7071067811865475e+00,
    0.6087614290087206e+00,
    0.5e+00,
    0.3826834323650898e+00,
    0.2588190451025208e+00,
    0.1305261922200516e+00
  };
  if (__calls[54].calls == 0) {
    _data_k_425 = 0;
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[0] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[1] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[2] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[3] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[4] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[5] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[6] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[7] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[8] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[9] = _data_l_425[_data_k_425++];
    if (_data_k_425 >= _data_n_425) {
      _data_k_425 = 0;
    }
    x_[10] = _data_l_425[_data_k_425++];
  }
  (*nev_) = 25;
  if ((*bl_) == (*a_) && ((*alfa_) != 0.0e+00 || (*integr_) == 2 || (*integr_) == 4)) {
    goto _l10;
  }
  if ((*br_) == (*b_) && ((*beta_) != 0.0e+00 || (*integr_) == 3 || (*integr_) == 4)) {
    goto _l140;
  }
  (void) _qk15w (_f, _qwgts, a_, b_, alfa_, beta_, integr_, bl_, br_, result_, abserr_, &resabs_, resasc_);
  (*nev_) = 15;
  goto _l270;
  _l10:;
  hlgth_ = 0.5e+00 * ((*br_) - (*bl_));
  centr_ = 0.5e+00 * ((*br_) + (*bl_));
  fix_ = (*b_) - centr_;
  fval_[0] = 0.5e+00 * _f (($0_ = hlgth_ + centr_, &$0_)) * powl ((fix_ - hlgth_), (*beta_));
  fval_[12] = _f (&centr_) * (powl (fix_, (*beta_)));
  fval_[24] = 0.5e+00 * _f (($1_ = centr_ - hlgth_, &$1_)) * powl ((fix_ + hlgth_), (*beta_));
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = _f (($2_ = u_ + centr_, &$2_)) * powl ((fix_ - u_), (*beta_));
    fval_[isym_ - 1] = _f (($3_ = centr_ - u_, &$3_)) * powl ((fix_ + u_), (*beta_));
  }
  factor_ = powl (hlgth_, ((*alfa_) + 0.1e1));
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  res12_ = 0.0;
  res24_ = 0.0;
  if ((*integr_) > 2) {
    goto _l70;
  }
  (void) _qcheb (x_, fval_, cheb12_, cheb24_);
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * ri_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * ri_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * ri_[i_ - 1];
  }
  if ((*integr_) == 1) {
    goto _l130;
  }
  dc_ = logf ((*br_) - (*bl_));
  (*result_) = res24_ * dc_;
  (*abserr_) = _abs ((res24_ - res12_) * dc_);
  res12_ = 0.0;
  res24_ = 0.0;
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rg_[i_ - 1];
    res24_ = res12_ + cheb24_[i_ - 1] * rg_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rg_[i_ - 1];
  }
  goto _l130;
  _l70:;
  fval_[0] = fval_[0] * logf (fix_ - hlgth_);
  fval_[12] = fval_[12] * logf (fix_);
  fval_[24] = fval_[24] * logf (fix_ + hlgth_);
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = fval_[i_ - 1] * logf (fix_ - u_);
    fval_[isym_ - 1] = fval_[isym_ - 1] * logf (fix_ + u_);
  }
  (void) _qcheb (x_, fval_, cheb12_, cheb24_);
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * ri_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * ri_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * ri_[i_ - 1];
  }
  if ((*integr_) == 3) {
    goto _l130;
  }
  dc_ = logf ((*br_) - (*bl_));
  (*result_) = res24_ * dc_;
  (*abserr_) = _abs ((res24_ - res12_) * dc_);
  res12_ = 0.0;
  res24_ = 0.0;
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rg_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rg_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rg_[i_ - 1];
  }
  _l130:;
  (*result_) = ((*result_) + res24_) * factor_;
  (*abserr_) = ((*abserr_) + _abs (res24_ - res12_)) * factor_;
  goto _l270;
  _l140:;
  hlgth_ = 0.5e+00 * ((*br_) - (*bl_));
  centr_ = 0.5e+00 * ((*br_) + (*bl_));
  fix_ = centr_ - (*a_);
  fval_[0] = 0.5e+00 * _f (($4_ = hlgth_ + centr_, &$4_)) * powl ((fix_ + hlgth_), (*alfa_));
  fval_[12] = _f (&centr_) * (powl (fix_, (*alfa_)));
  fval_[24] = 0.5e+00 * _f (($5_ = centr_ - hlgth_, &$5_)) * powl ((fix_ - hlgth_), (*alfa_));
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = _f (($6_ = u_ + centr_, &$6_)) * powl ((fix_ + u_), (*alfa_));
    fval_[isym_ - 1] = _f (($7_ = centr_ - u_, &$7_)) * powl ((fix_ - u_), (*alfa_));
  }
  factor_ = powl (hlgth_, ((*beta_) + 0.1e1));
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  res12_ = 0.0;
  res24_ = 0.0;
  if ((*integr_) == 2 || (*integr_) == 4) {
    goto _l200;
  }
  (void) _qcheb (x_, fval_, cheb12_, cheb24_);
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rj_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rj_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rj_[i_ - 1];
  }
  if ((*integr_) == 1) {
    goto _l260;
  }
  dc_ = logf ((*br_) - (*bl_));
  (*result_) = res24_ * dc_;
  (*abserr_) = _abs ((res24_ - res12_) * dc_);
  res12_ = 0.0;
  res24_ = 0.0;
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rh_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rh_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rh_[i_ - 1];
  }
  goto _l260;
  _l200:;
  fval_[0] = fval_[0] * logf (fix_ + hlgth_);
  fval_[12] = fval_[12] * logf (fix_);
  fval_[24] = fval_[24] * logf (fix_ - hlgth_);
  for (i_ = 2; i_ <= 12; (i_)++) {
    u_ = hlgth_ * x_[i_ - 1 - 1];
    isym_ = 26 - i_;
    fval_[i_ - 1] = fval_[i_ - 1] * logf (fix_ + u_);
    fval_[isym_ - 1] = fval_[isym_ - 1] * logf (fix_ - u_);
  }
  (void) _qcheb (x_, fval_, cheb12_, cheb24_);
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rj_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rj_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rj_[i_ - 1];
  }
  if ((*integr_) == 2) {
    goto _l260;
  }
  dc_ = logf ((*br_) - (*bl_));
  (*result_) = res24_ * dc_;
  (*abserr_) = _abs ((res24_ - res12_) * dc_);
  res12_ = 0.0;
  res24_ = 0.0;
  for (i_ = 1; i_ <= 13; (i_)++) {
    res12_ = res12_ + cheb12_[i_ - 1] * rh_[i_ - 1];
    res24_ = res24_ + cheb24_[i_ - 1] * rh_[i_ - 1];
  }
  for (i_ = 14; i_ <= 25; (i_)++) {
    res24_ = res24_ + cheb24_[i_ - 1] * rh_[i_ - 1];
  }
  _l260:;
  (*result_) = ((*result_) + res24_) * factor_;
  (*abserr_) = ((*abserr_) + _abs (res24_ - res12_)) * factor_;
  _l270:;
  __calls[54].calls++;
  return 0;
}

int_4 _qcheb (real_4 _p_ x_, real_4 _p_ fval_, real_4 _p_ cheb12_, real_4 _p_ cheb24_)
{
  static int_4 i_, j_;
  static real_4 alam_, alam1_, alam2_, part1_, part2_, part3_, v_[12];
  for (i_ = 1; i_ <= 12; (i_)++) {
    j_ = 26 - i_;
    v_[i_ - 1] = fval_[i_ - 1] - fval_[j_ - 1];
    fval_[i_ - 1] = fval_[i_ - 1] + fval_[j_ - 1];
  }
  alam1_ = v_[0] - v_[8];
  alam2_ = x_[5] * (v_[2] - v_[6] - v_[10]);
  cheb12_[3] = alam1_ + alam2_;
  cheb12_[9] = alam1_ - alam2_;
  alam1_ = v_[1] - v_[7] - v_[9];
  alam2_ = v_[3] - v_[5] - v_[11];
  alam_ = x_[2] * alam1_ + x_[8] * alam2_;
  cheb24_[3] = cheb12_[3] + alam_;
  cheb24_[21] = cheb12_[3] - alam_;
  alam_ = x_[8] * alam1_ - x_[2] * alam2_;
  cheb24_[9] = cheb12_[9] + alam_;
  cheb24_[15] = cheb12_[9] - alam_;
  part1_ = x_[3] * v_[4];
  part2_ = x_[7] * v_[8];
  part3_ = x_[5] * v_[6];
  alam1_ = v_[0] + part1_ + part2_;
  alam2_ = x_[1] * v_[2] + part3_ + x_[9] * v_[10];
  cheb12_[1] = alam1_ + alam2_;
  cheb12_[11] = alam1_ - alam2_;
  alam_ = x_[0] * v_[1] + x_[2] * v_[3] + x_[4] * v_[5] + x_[6] * v_[7] + x_[8] * v_[9] + x_[10] * v_[11];
  cheb24_[1] = cheb12_[1] + alam_;
  cheb24_[23] = cheb12_[1] - alam_;
  alam_ = x_[10] * v_[1] - x_[8] * v_[3] + x_[6] * v_[5] - x_[4] * v_[7] + x_[2] * v_[9] - x_[0] * v_[11];
  cheb24_[11] = cheb12_[11] + alam_;
  cheb24_[13] = cheb12_[11] - alam_;
  alam1_ = v_[0] - part1_ + part2_;
  alam2_ = x_[9] * v_[2] - part3_ + x_[1] * v_[10];
  cheb12_[5] = alam1_ + alam2_;
  cheb12_[7] = alam1_ - alam2_;
  alam_ = x_[4] * v_[1] - x_[8] * v_[3] - x_[0] * v_[5] - x_[10] * v_[7] + x_[2] * v_[9] + x_[6] * v_[11];
  cheb24_[5] = cheb12_[5] + alam_;
  cheb24_[19] = cheb12_[5] - alam_;
  alam_ = x_[6] * v_[1] - x_[2] * v_[3] - x_[10] * v_[5] + x_[0] * v_[7] - x_[8] * v_[9] - x_[4] * v_[11];
  cheb24_[7] = cheb12_[7] + alam_;
  cheb24_[17] = cheb12_[7] - alam_;
  for (i_ = 1; i_ <= 6; (i_)++) {
    j_ = 14 - i_;
    v_[i_ - 1] = fval_[i_ - 1] - fval_[j_ - 1];
    fval_[i_ - 1] = fval_[i_ - 1] + fval_[j_ - 1];
  }
  alam1_ = v_[0] + x_[7] * v_[4];
  alam2_ = x_[3] * v_[2];
  cheb12_[2] = alam1_ + alam2_;
  cheb12_[10] = alam1_ - alam2_;
  cheb12_[6] = v_[0] - v_[4];
  alam_ = x_[1] * v_[1] + x_[5] * v_[3] + x_[9] * v_[5];
  cheb24_[2] = cheb12_[2] + alam_;
  cheb24_[22] = cheb12_[2] - alam_;
  alam_ = x_[5] * (v_[1] - v_[3] - v_[5]);
  cheb24_[6] = cheb12_[6] + alam_;
  cheb24_[18] = cheb12_[6] - alam_;
  alam_ = x_[9] * v_[1] - x_[5] * v_[3] + x_[1] * v_[5];
  cheb24_[10] = cheb12_[10] + alam_;
  cheb24_[14] = cheb12_[10] - alam_;
  for (i_ = 1; i_ <= 3; (i_)++) {
    j_ = 8 - i_;
    v_[i_ - 1] = fval_[i_ - 1] - fval_[j_ - 1];
    fval_[i_ - 1] = fval_[i_ - 1] + fval_[j_ - 1];
  }
  cheb12_[4] = v_[0] + x_[7] * v_[2];
  cheb12_[8] = fval_[0] - x_[7] * fval_[2];
  alam_ = x_[3] * v_[1];
  cheb24_[4] = cheb12_[4] + alam_;
  cheb24_[20] = cheb12_[4] - alam_;
  alam_ = x_[7] * fval_[1] - fval_[3];
  cheb24_[8] = cheb12_[8] + alam_;
  cheb24_[16] = cheb12_[8] - alam_;
  cheb12_[0] = fval_[0] + fval_[2];
  alam_ = fval_[1] + fval_[3];
  cheb24_[0] = cheb12_[0] + alam_;
  cheb24_[24] = cheb12_[0] - alam_;
  cheb12_[12] = v_[0] - v_[2];
  cheb24_[12] = cheb12_[12];
  alam_ = 1.6666667e-1;
  for (i_ = 2; i_ <= 12; (i_)++) {
    cheb12_[i_ - 1] = cheb12_[i_ - 1] * alam_;
  }
  alam_ = 0.5e+00 * alam_;
  cheb12_[0] = cheb12_[0] * alam_;
  cheb12_[12] = cheb12_[12] * alam_;
  for (i_ = 2; i_ <= 24; (i_)++) {
    cheb24_[i_ - 1] = cheb24_[i_ - 1] * alam_;
  }
  cheb24_[0] = 0.5e+00 * alam_ * cheb24_[0];
  cheb24_[24] = 0.5e+00 * alam_ * cheb24_[24];
  __calls[55].calls++;
  return 0;
}

int_4 _qelg (int_4 _p_ n_, real_4 _p_ epstab_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ res3la_, int_4 _p_ 
nres_)
{
  static int_4 i_, ib_, ib2_, ie_, indx_, k1_, k2_, k3_, limexp_, newelm_, num_;
  static real_4 delta1_, delta2_, delta3_, epmach_, epsinf_, error_, err1_, err2_, err3_, e0_, e1_, e1abs_, e2_, e3_, 
  oflow_, res_, ss_, tol1_, tol2_, tol3_;
  int_4 $0_, $1_;
  extern real_4 _r1mach ();
  epmach_ = _r1mach (($0_ = 4, &$0_));
  oflow_ = _r1mach (($1_ = 2, &$1_));
  (*nres_) = (*nres_) + 1;
  (*abserr_) = oflow_;
  (*result_) = epstab_[(*n_) - 1];
  if ((*n_) < 3) {
    goto _l100;
  }
  limexp_ = 50;
  epstab_[(*n_) + 2 - 1] = epstab_[(*n_) - 1];
  newelm_ = ((*n_) - 1) / 2;
  epstab_[(*n_) - 1] = oflow_;
  num_ = (*n_);
  k1_ = (*n_);
  for (i_ = 1; i_ <= newelm_; (i_)++) {
    k2_ = k1_ - 1;
    k3_ = k1_ - 2;
    res_ = epstab_[k1_ + 2 - 1];
    e0_ = epstab_[k3_ - 1];
    e1_ = epstab_[k2_ - 1];
    e2_ = res_;
    e1abs_ = _abs (e1_);
    delta2_ = e2_ - e1_;
    err2_ = _abs (delta2_);
    tol2_ = _max (_abs (e2_), e1abs_) * epmach_;
    delta3_ = e1_ - e0_;
    err3_ = _abs (delta3_);
    tol3_ = _max (e1abs_, _abs (e0_)) * epmach_;
    if (err2_ > tol2_ || err3_ > tol3_) {
      goto _l10;
    }
    (*result_) = res_;
    (*abserr_) = err2_ + err3_;
    goto _l100;
    _l10:;
    e3_ = epstab_[k1_ - 1];
    epstab_[k1_ - 1] = e1_;
    delta1_ = e1_ - e3_;
    err1_ = _abs (delta1_);
    tol1_ = _max (e1abs_, _abs (e3_)) * epmach_;
    if (err1_ <= tol1_ || err2_ <= tol2_ || err3_ <= tol3_) {
      goto _l20;
    }
    ss_ = 0.1e1 / delta1_ + 0.1e1 / delta2_ - 0.1e1 / delta3_;
    epsinf_ = _abs (ss_ * e1_);
    if (epsinf_ > 0.1e-3) {
      goto _l30;
    }
    _l20:;
    (*n_) = i_ + i_ - 1;
    goto _l50;
    _l30:;
    res_ = e1_ + 0.1e1 / ss_;
    epstab_[k1_ - 1] = res_;
    k1_ = k1_ - 2;
    error_ = err2_ + _abs (res_ - e2_) + err3_;
    if (error_ > (*abserr_)) {
      goto _l40;
    }
    (*abserr_) = error_;
    (*result_) = res_;
    _l40:;
  }
  _l50:;
  if ((*n_) == limexp_) {
    (*n_) = 2 * (limexp_ / 2) - 1;
  }
  ib_ = 1;
  if ((num_ / 2) * 2 == num_) {
    ib_ = 2;
  }
  ie_ = newelm_ + 1;
  for (i_ = 1; i_ <= ie_; (i_)++) {
    ib2_ = ib_ + 2;
    epstab_[ib_ - 1] = epstab_[ib2_ - 1];
    ib_ = ib2_;
  }
  if (num_ == (*n_)) {
    goto _l80;
  }
  indx_ = num_ - (*n_) + 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    epstab_[i_ - 1] = epstab_[indx_ - 1];
    indx_ = indx_ + 1;
  }
  _l80:;
  if ((*nres_) >= 4) {
    goto _l90;
  }
  res3la_[(*nres_) - 1] = (*result_);
  (*abserr_) = oflow_;
  goto _l100;
  _l90:;
  (*abserr_) = _abs ((*result_) - res3la_[2]) + _abs ((*result_) - res3la_[1]) + _abs ((*result_) - res3la_[0]);
  res3la_[0] = res3la_[1];
  res3la_[1] = res3la_[2];
  res3la_[2] = (*result_);
  _l100:;
  (*abserr_) = _max ((*abserr_), 0.5e1 * epmach_ * _abs ((*result_)));
  __calls[56].calls++;
  return 0;
}

int_4 _qk15 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ resabs_, 
real_4 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_4 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[7], fv2_[7], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[4], wgk_[8], xgk_[8];
  int_4 _data_k_426, _data_k_427, _data_k_428, $0_;
  real_4 $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_426 8
  static real_4 _data_l_426[_data_n_426] = {
    0.9914553711208126e+00,
    0.9491079123427585e+00,
    0.8648644233597691e+00,
    0.7415311855993944e+00,
    0.5860872354676911e+00,
    0.4058451513773972e+00,
    0.2077849550078985e+00,
    0.0e+00
  };
#define _data_n_427 8
  static real_4 _data_l_427[_data_n_427] = {
    0.2293532201052922e-1,
    0.6309209262997855e-1,
    0.1047900103222502e+00,
    0.1406532597155259e+00,
    0.1690047266392679e+00,
    0.1903505780647854e+00,
    0.2044329400752989e+00,
    0.2094821410847278e+00
  };
#define _data_n_428 4
  static real_4 _data_l_428[_data_n_428] = {
    0.1294849661688697e+00,
    0.2797053914892767e+00,
    0.3818300505051189e+00,
    0.4179591836734694e+00
  };
  if (__calls[57].calls == 0) {
    _data_k_426 = 0;
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    xgk_[0] = _data_l_426[_data_k_426++];
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    xgk_[1] = _data_l_426[_data_k_426++];
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    xgk_[2] = _data_l_426[_data_k_426++];
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    xgk_[3] = _data_l_426[_data_k_426++];
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    xgk_[4] = _data_l_426[_data_k_426++];
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    xgk_[5] = _data_l_426[_data_k_426++];
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    xgk_[6] = _data_l_426[_data_k_426++];
    if (_data_k_426 >= _data_n_426) {
      _data_k_426 = 0;
    }
    xgk_[7] = _data_l_426[_data_k_426++];
  }
  if (__calls[57].calls == 0) {
    _data_k_427 = 0;
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    wgk_[0] = _data_l_427[_data_k_427++];
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    wgk_[1] = _data_l_427[_data_k_427++];
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    wgk_[2] = _data_l_427[_data_k_427++];
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    wgk_[3] = _data_l_427[_data_k_427++];
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    wgk_[4] = _data_l_427[_data_k_427++];
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    wgk_[5] = _data_l_427[_data_k_427++];
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    wgk_[6] = _data_l_427[_data_k_427++];
    if (_data_k_427 >= _data_n_427) {
      _data_k_427 = 0;
    }
    wgk_[7] = _data_l_427[_data_k_427++];
  }
  if (__calls[57].calls == 0) {
    _data_k_428 = 0;
    if (_data_k_428 >= _data_n_428) {
      _data_k_428 = 0;
    }
    wg_[0] = _data_l_428[_data_k_428++];
    if (_data_k_428 >= _data_n_428) {
      _data_k_428 = 0;
    }
    wg_[1] = _data_l_428[_data_k_428++];
    if (_data_k_428 >= _data_n_428) {
      _data_k_428 = 0;
    }
    wg_[2] = _data_l_428[_data_k_428++];
    if (_data_k_428 >= _data_n_428) {
      _data_k_428 = 0;
    }
    wg_[3] = _data_l_428[_data_k_428++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  fc_ = _f (&centr_);
  resg_ = fc_ * wg_[3];
  resk_ = fc_ * wgk_[7];
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 3; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 4; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[7] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, powl ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[57].calls++;
  return 0;
}

int_4 _qk15i (real_4 (*_f)(), real_4 _p_ boun_, int_4 _p_ inf_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, 
real_4 _p_ abserr_, real_4 _p_ resabs_, real_4 _p_ resasc_)
{
  static int_4 j_;
  static real_4 absc_, absc1_, absc2_, centr_, dinf_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[7], fv2_[7], hlgth_, 
  resg_, resk_, reskh_, tabsc1_, tabsc2_, uflow_, wg_[8], wgk_[8], xgk_[8];
  int_4 _data_k_429, _data_k_430, _data_k_431, $0_;
  real_4 $1_, $2_, $3_;
  extern real_4 _r1mach ();
#define _data_n_429 8
  static real_4 _data_l_429[_data_n_429] = {
    0.9914553711208126e+00,
    0.9491079123427585e+00,
    0.8648644233597691e+00,
    0.7415311855993944e+00,
    0.5860872354676911e+00,
    0.4058451513773972e+00,
    0.2077849550078985e+00,
    0.0e+00
  };
#define _data_n_430 8
  static real_4 _data_l_430[_data_n_430] = {
    0.2293532201052922e-1,
    0.6309209262997855e-1,
    0.1047900103222502e+00,
    0.1406532597155259e+00,
    0.1690047266392679e+00,
    0.1903505780647854e+00,
    0.2044329400752989e+00,
    0.2094821410847278e+00
  };
#define _data_n_431 8
  static real_4 _data_l_431[_data_n_431] = {
    0.0e+00,
    0.1294849661688697e+00,
    0.0e+00,
    0.2797053914892767e+00,
    0.0e+00,
    0.3818300505051189e+00,
    0.0e+00,
    0.4179591836734694e+00
  };
  if (__calls[58].calls == 0) {
    _data_k_429 = 0;
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    xgk_[0] = _data_l_429[_data_k_429++];
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    xgk_[1] = _data_l_429[_data_k_429++];
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    xgk_[2] = _data_l_429[_data_k_429++];
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    xgk_[3] = _data_l_429[_data_k_429++];
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    xgk_[4] = _data_l_429[_data_k_429++];
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    xgk_[5] = _data_l_429[_data_k_429++];
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    xgk_[6] = _data_l_429[_data_k_429++];
    if (_data_k_429 >= _data_n_429) {
      _data_k_429 = 0;
    }
    xgk_[7] = _data_l_429[_data_k_429++];
  }
  if (__calls[58].calls == 0) {
    _data_k_430 = 0;
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    wgk_[0] = _data_l_430[_data_k_430++];
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    wgk_[1] = _data_l_430[_data_k_430++];
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    wgk_[2] = _data_l_430[_data_k_430++];
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    wgk_[3] = _data_l_430[_data_k_430++];
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    wgk_[4] = _data_l_430[_data_k_430++];
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    wgk_[5] = _data_l_430[_data_k_430++];
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    wgk_[6] = _data_l_430[_data_k_430++];
    if (_data_k_430 >= _data_n_430) {
      _data_k_430 = 0;
    }
    wgk_[7] = _data_l_430[_data_k_430++];
  }
  if (__calls[58].calls == 0) {
    _data_k_431 = 0;
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    wg_[0] = _data_l_431[_data_k_431++];
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    wg_[1] = _data_l_431[_data_k_431++];
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    wg_[2] = _data_l_431[_data_k_431++];
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    wg_[3] = _data_l_431[_data_k_431++];
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    wg_[4] = _data_l_431[_data_k_431++];
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    wg_[5] = _data_l_431[_data_k_431++];
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    wg_[6] = _data_l_431[_data_k_431++];
    if (_data_k_431 >= _data_n_431) {
      _data_k_431 = 0;
    }
    wg_[7] = _data_l_431[_data_k_431++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  dinf_ = _min (1, (*inf_));
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  tabsc1_ = (*boun_) + dinf_ * (0.1e1 - centr_) / centr_;
  fval1_ = _f (&tabsc1_);
  if ((*inf_) == 2) {
    fval1_ = fval1_ + _f (($1_ = -tabsc1_, &$1_));
  }
  fc_ = (fval1_ / centr_) / centr_;
  resg_ = wg_[7] * fc_;
  resk_ = wgk_[7] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    absc_ = hlgth_ * xgk_[j_ - 1];
    absc1_ = centr_ - absc_;
    absc2_ = centr_ + absc_;
    tabsc1_ = (*boun_) + dinf_ * (0.1e1 - absc1_) / absc1_;
    tabsc2_ = (*boun_) + dinf_ * (0.1e1 - absc2_) / absc2_;
    fval1_ = _f (&tabsc1_);
    fval2_ = _f (&tabsc2_);
    if ((*inf_) == 2) {
      fval1_ = fval1_ + _f (($2_ = -tabsc1_, &$2_));
    }
    if ((*inf_) == 2) {
      fval2_ = fval2_ + _f (($3_ = -tabsc2_, &$3_));
    }
    fval1_ = (fval1_ / absc1_) / absc1_;
    fval2_ = (fval2_ / absc2_) / absc2_;
    fv1_[j_ - 1] = fval1_;
    fv2_[j_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[j_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[j_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[7] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resasc_) = (*resasc_) * hlgth_;
  (*resabs_) = (*resabs_) * hlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e0) {
    (*abserr_) = (*resasc_) * _min (1.0, powl ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[58].calls++;
  return 0;
}

int_4 _qk15w (real_4 (*_f)(), real_4 (*_w)(), real_4 _p_ p1_, real_4 _p_ p2_, real_4 _p_ p3_, real_4 _p_ p4_, int_4 _p_ 
kp_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ resabs_, real_4 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_4 absc_, absc1_, absc2_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[7], fv2_[7], hlgth_, 
  resg_, resk_, reskh_, uflow_, wg_[4], wgk_[8], xgk_[8];
  int_4 _data_k_432, _data_k_433, _data_k_434, $0_;
  extern real_4 _r1mach ();
#define _data_n_432 8
  static real_4 _data_l_432[_data_n_432] = {
    0.9914553711208126e+00,
    0.9491079123427585e+00,
    0.8648644233597691e+00,
    0.7415311855993944e+00,
    0.5860872354676911e+00,
    0.4058451513773972e+00,
    0.2077849550078985e+00,
    0.0e+00
  };
#define _data_n_433 8
  static real_4 _data_l_433[_data_n_433] = {
    0.2293532201052922e-1,
    0.6309209262997855e-1,
    0.1047900103222502e+00,
    0.1406532597155259e+00,
    0.1690047266392679e+00,
    0.1903505780647854e+00,
    0.2044329400752989e+00,
    0.2094821410847278e+00
  };
#define _data_n_434 4
  static real_4 _data_l_434[_data_n_434] = {
    0.1294849661688697e+00,
    0.2797053914892767e+00,
    0.3818300505051189e+00,
    0.4179591836734694e+00
  };
  if (__calls[59].calls == 0) {
    _data_k_432 = 0;
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    xgk_[0] = _data_l_432[_data_k_432++];
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    xgk_[1] = _data_l_432[_data_k_432++];
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    xgk_[2] = _data_l_432[_data_k_432++];
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    xgk_[3] = _data_l_432[_data_k_432++];
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    xgk_[4] = _data_l_432[_data_k_432++];
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    xgk_[5] = _data_l_432[_data_k_432++];
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    xgk_[6] = _data_l_432[_data_k_432++];
    if (_data_k_432 >= _data_n_432) {
      _data_k_432 = 0;
    }
    xgk_[7] = _data_l_432[_data_k_432++];
  }
  if (__calls[59].calls == 0) {
    _data_k_433 = 0;
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    wgk_[0] = _data_l_433[_data_k_433++];
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    wgk_[1] = _data_l_433[_data_k_433++];
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    wgk_[2] = _data_l_433[_data_k_433++];
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    wgk_[3] = _data_l_433[_data_k_433++];
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    wgk_[4] = _data_l_433[_data_k_433++];
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    wgk_[5] = _data_l_433[_data_k_433++];
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    wgk_[6] = _data_l_433[_data_k_433++];
    if (_data_k_433 >= _data_n_433) {
      _data_k_433 = 0;
    }
    wgk_[7] = _data_l_433[_data_k_433++];
  }
  if (__calls[59].calls == 0) {
    _data_k_434 = 0;
    if (_data_k_434 >= _data_n_434) {
      _data_k_434 = 0;
    }
    wg_[0] = _data_l_434[_data_k_434++];
    if (_data_k_434 >= _data_n_434) {
      _data_k_434 = 0;
    }
    wg_[1] = _data_l_434[_data_k_434++];
    if (_data_k_434 >= _data_n_434) {
      _data_k_434 = 0;
    }
    wg_[2] = _data_l_434[_data_k_434++];
    if (_data_k_434 >= _data_n_434) {
      _data_k_434 = 0;
    }
    wg_[3] = _data_l_434[_data_k_434++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  fc_ = _f (&centr_) * _w (&centr_, p1_, p2_, p3_, p4_, kp_);
  resg_ = wg_[3] * fc_;
  resk_ = wgk_[7] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 3; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    absc1_ = centr_ - absc_;
    absc2_ = centr_ + absc_;
    fval1_ = _f (&absc1_) * _w (&absc1_, p1_, p2_, p3_, p4_, kp_);
    fval2_ = _f (&absc2_) * _w (&absc2_, p1_, p2_, p3_, p4_, kp_);
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 4; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    absc1_ = centr_ - absc_;
    absc2_ = centr_ + absc_;
    fval1_ = _f (&absc1_) * _w (&absc1_, p1_, p2_, p3_, p4_, kp_);
    fval2_ = _f (&absc2_) * _w (&absc2_, p1_, p2_, p3_, p4_, kp_);
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[7] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, powl ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[59].calls++;
  return 0;
}
int_4 _qk21 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ resabs_, 
real_4 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_4 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[10], fv2_[10], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[5], wgk_[11], xgk_[11];
  int_4 _data_k_435, _data_k_436, _data_k_437, $0_;
  real_4 $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_435 11
  static real_4 _data_l_435[_data_n_435] = {
    0.9956571630258081e+00,
    0.9739065285171717e+00,
    0.9301574913557082e+00,
    0.8650633666889845e+00,
    0.7808177265864169e+00,
    0.6794095682990244e+00,
    0.5627571346686047e+00,
    0.4333953941292472e+00,
    0.2943928627014602e+00,
    0.1488743389816312e+00,
    0.0e+00
  };
#define _data_n_436 11
  static real_4 _data_l_436[_data_n_436] = {
    0.1169463886737187e-1,
    0.3255816230796473e-1,
    0.54755896574352e-1,
    0.7503967481091995e-1,
    0.9312545458369761e-1,
    0.1093871588022976e+00,
    0.1234919762620659e+00,
    0.1347092173114733e+00,
    0.1427759385770601e+00,
    0.1477391049013385e+00,
    0.1494455540029169e+00
  };
#define _data_n_437 5
  static real_4 _data_l_437[_data_n_437] = {
    0.6667134430868814e-1,
    0.1494513491505806e+00,
    0.219086362515982e+00,
    0.2692667193099964e+00,
    0.2955242247147529e+00
  };
  if (__calls[60].calls == 0) {
    _data_k_435 = 0;
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[0] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[1] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[2] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[3] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[4] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[5] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[6] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[7] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[8] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[9] = _data_l_435[_data_k_435++];
    if (_data_k_435 >= _data_n_435) {
      _data_k_435 = 0;
    }
    xgk_[10] = _data_l_435[_data_k_435++];
  }
  if (__calls[60].calls == 0) {
    _data_k_436 = 0;
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[0] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[1] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[2] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[3] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[4] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[5] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[6] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[7] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[8] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[9] = _data_l_436[_data_k_436++];
    if (_data_k_436 >= _data_n_436) {
      _data_k_436 = 0;
    }
    wgk_[10] = _data_l_436[_data_k_436++];
  }
  if (__calls[60].calls == 0) {
    _data_k_437 = 0;
    if (_data_k_437 >= _data_n_437) {
      _data_k_437 = 0;
    }
    wg_[0] = _data_l_437[_data_k_437++];
    if (_data_k_437 >= _data_n_437) {
      _data_k_437 = 0;
    }
    wg_[1] = _data_l_437[_data_k_437++];
    if (_data_k_437 >= _data_n_437) {
      _data_k_437 = 0;
    }
    wg_[2] = _data_l_437[_data_k_437++];
    if (_data_k_437 >= _data_n_437) {
      _data_k_437 = 0;
    }
    wg_[3] = _data_l_437[_data_k_437++];
    if (_data_k_437 >= _data_n_437) {
      _data_k_437 = 0;
    }
    wg_[4] = _data_l_437[_data_k_437++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  resg_ = 0.0;
  fc_ = _f (&centr_);
  resk_ = wgk_[10] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 5; (j_)++) {
    jtw_ = 2 * j_;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 5; (j_)++) {
    jtwm1_ = 2 * j_ - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[10] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 10; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, powl ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[60].calls++;
  return 0;
}

int_4 _qk31 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ resabs_, 
real_4 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_4 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[15], fv2_[15], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[8], wgk_[16], xgk_[16];
  int_4 _data_k_438, _data_k_439, _data_k_440, $0_;
  real_4 $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_438 16
  static real_4 _data_l_438[_data_n_438] = {
    0.9980022986933971e+00,
    0.9879925180204854e+00,
    0.9677390756791391e+00,
    0.9372733924007059e+00,
    0.8972645323440819e+00,
    0.8482065834104272e+00,
    0.7904185014424659e+00,
    0.72441773136017e+00,
    0.650996741297417e+00,
    0.5709721726085388e+00,
    0.4850818636402397e+00,
    0.3941513470775634e+00,
    0.2991800071531688e+00,
    0.2011940939974345e+00,
    0.1011420669187175e+00,
    0.0e+00
  };
#define _data_n_439 16
  static real_4 _data_l_439[_data_n_439] = {
    0.5377479872923349e-2,
    0.1500794732931612e-1,
    0.2546084732671532e-1,
    0.3534636079137585e-1,
    0.4458975132476488e-1,
    0.5348152469092809e-1,
    0.6200956780067064e-1,
    0.6985412131872826e-1,
    0.7684968075772038e-1,
    0.8308050282313302e-1,
    0.8856444305621177e-1,
    0.9312659817082532e-1,
    0.9664272698362368e-1,
    0.9917359872179196e-1,
    0.1007698455238756e+00,
    0.1013300070147915e+00
  };
#define _data_n_440 8
  static real_4 _data_l_440[_data_n_440] = {
    0.3075324199611727e-1,
    0.7036604748810812e-1,
    0.1071592204671719e+00,
    0.1395706779261543e+00,
    0.1662692058169939e+00,
    0.1861610000155622e+00,
    0.1984314853271116e+00,
    0.2025782419255613e+00
  };
  if (__calls[61].calls == 0) {
    _data_k_438 = 0;
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[0] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[1] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[2] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[3] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[4] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[5] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[6] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[7] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[8] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[9] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[10] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[11] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[12] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[13] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[14] = _data_l_438[_data_k_438++];
    if (_data_k_438 >= _data_n_438) {
      _data_k_438 = 0;
    }
    xgk_[15] = _data_l_438[_data_k_438++];
  }
  if (__calls[61].calls == 0) {
    _data_k_439 = 0;
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[0] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[1] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[2] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[3] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[4] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[5] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[6] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[7] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[8] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[9] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[10] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[11] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[12] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[13] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[14] = _data_l_439[_data_k_439++];
    if (_data_k_439 >= _data_n_439) {
      _data_k_439 = 0;
    }
    wgk_[15] = _data_l_439[_data_k_439++];
  }
  if (__calls[61].calls == 0) {
    _data_k_440 = 0;
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    wg_[0] = _data_l_440[_data_k_440++];
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    wg_[1] = _data_l_440[_data_k_440++];
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    wg_[2] = _data_l_440[_data_k_440++];
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    wg_[3] = _data_l_440[_data_k_440++];
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    wg_[4] = _data_l_440[_data_k_440++];
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    wg_[5] = _data_l_440[_data_k_440++];
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    wg_[6] = _data_l_440[_data_k_440++];
    if (_data_k_440 >= _data_n_440) {
      _data_k_440 = 0;
    }
    wg_[7] = _data_l_440[_data_k_440++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  fc_ = _f (&centr_);
  resg_ = wg_[7] * fc_;
  resk_ = wgk_[15] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 7; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 8; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[15] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 15; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, powl ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[61].calls++;
  return 0;
}

int_4 _qk41 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ resabs_, 
real_4 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_4 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[20], fv2_[20], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[10], wgk_[21], xgk_[21];
  int_4 _data_k_441, _data_k_442, _data_k_443, $0_;
  real_4 $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_441 21
  static real_4 _data_l_441[_data_n_441] = {
    0.9988590315882777e+00,
    0.9931285991850949e+00,
    0.9815078774502503e+00,
    0.9639719272779138e+00,
    0.9408226338317548e+00,
    0.9122344282513259e+00,
    0.878276811252282e+00,
    0.8391169718222188e+00,
    0.7950414288375512e+00,
    0.7463319064601508e+00,
    0.6932376563347514e+00,
    0.636053680726515e+00,
    0.5751404468197103e+00,
    0.5108670019508271e+00,
    0.4435931752387251e+00,
    0.3737060887154196e+00,
    0.301627868114913e+00,
    0.2277858511416451e+00,
    0.1526054652409227e+00,
    0.7652652113349733e-1,
    0.0e+00
  };
#define _data_n_442 21
  static real_4 _data_l_442[_data_n_442] = {
    0.3073583718520532e-2,
    0.8600269855642942e-2,
    0.1462616925697125e-1,
    0.2038837346126652e-1,
    0.2588213360495116e-1,
    0.312873067770328e-1,
    0.366001697582008e-1,
    0.4166887332797369e-1,
    0.4643482186749767e-1,
    0.5094457392372869e-1,
    0.5519510534828599e-1,
    0.5911140088063957e-1,
    0.6265323755478117e-1,
    0.6583459713361842e-1,
    0.6864867292852162e-1,
    0.7105442355344407e-1,
    0.7303069033278667e-1,
    0.7458287540049919e-1,
    0.7570449768455667e-1,
    0.7637786767208074e-1,
    0.7660071191799966e-1
  };
#define _data_n_443 10
  static real_4 _data_l_443[_data_n_443] = {
    0.1761400713915212e-1,
    0.4060142980038694e-1,
    0.6267204833410906e-1,
    0.8327674157670475e-1,
    0.1019301198172404e+00,
    0.1181945319615184e+00,
    0.1316886384491766e+00,
    0.1420961093183821e+00,
    0.1491729864726037e+00,
    0.1527533871307259e+00
  };
  if (__calls[62].calls == 0) {
    _data_k_441 = 0;
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[0] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[1] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[2] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[3] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[4] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[5] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[6] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[7] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[8] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[9] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[10] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[11] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[12] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[13] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[14] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[15] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[16] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[17] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[18] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[19] = _data_l_441[_data_k_441++];
    if (_data_k_441 >= _data_n_441) {
      _data_k_441 = 0;
    }
    xgk_[20] = _data_l_441[_data_k_441++];
  }
  if (__calls[62].calls == 0) {
    _data_k_442 = 0;
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[0] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[1] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[2] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[3] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[4] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[5] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[6] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[7] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[8] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[9] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[10] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[11] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[12] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[13] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[14] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[15] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[16] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[17] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[18] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[19] = _data_l_442[_data_k_442++];
    if (_data_k_442 >= _data_n_442) {
      _data_k_442 = 0;
    }
    wgk_[20] = _data_l_442[_data_k_442++];
  }
  if (__calls[62].calls == 0) {
    _data_k_443 = 0;
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[0] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[1] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[2] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[3] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[4] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[5] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[6] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[7] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[8] = _data_l_443[_data_k_443++];
    if (_data_k_443 >= _data_n_443) {
      _data_k_443 = 0;
    }
    wg_[9] = _data_l_443[_data_k_443++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  resg_ = 0.0;
  fc_ = _f (&centr_);
  resk_ = wgk_[20] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 10; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 10; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[20] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 20; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, powl ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[62].calls++;
  return 0;
}

int_4 _qk51 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ resabs_, 
real_4 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_4 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[25], fv2_[25], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[13], wgk_[26], xgk_[26];
  int_4 _data_k_444, _data_k_445, _data_k_446, _data_k_447, _data_k_448, $0_;
  real_4 $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_444 14
  static real_4 _data_l_444[_data_n_444] = {
    0.9992621049926098e+00,
    0.9955569697904981e+00,
    0.9880357945340772e+00,
    0.9766639214595175e+00,
    0.9616149864258425e+00,
    0.9429745712289743e+00,
    0.9207471152817016e+00,
    0.8949919978782754e+00,
    0.8658470652932756e+00,
    0.833442628760834e+00,
    0.7978737979985001e+00,
    0.7592592630373576e+00,
    0.7177664068130844e+00,
    0.6735663684734684e+00
  };
#define _data_n_445 12
  static real_4 _data_l_445[_data_n_445] = {
    0.6268100990103174e+00,
    0.577662930241223e+00,
    0.5263252843347192e+00,
    0.473002731445715e+00,
    0.4178853821930377e+00,
    0.3611723058093878e+00,
    0.3030895389311078e+00,
    0.2438668837209884e+00,
    0.1837189394210489e+00,
    0.1228646926107104e+00,
    0.6154448300568508e-1,
    0.0e+00
  };
#define _data_n_446 14
  static real_4 _data_l_446[_data_n_446] = {
    0.1987383892330316e-2,
    0.5561932135356714e-2,
    0.9473973386174152e-2,
    0.1323622919557167e-1,
    0.168478177091283e-1,
    0.2043537114588284e-1,
    0.2400994560695322e-1,
    0.2747531758785174e-1,
    0.3079230016738749e-1,
    0.3400213027432934e-1,
    0.3711627148341554e-1,
    0.4008382550403238e-1,
    0.4287284502017005e-1,
    0.4550291304992179e-1
  };
#define _data_n_447 12
  static real_4 _data_l_447[_data_n_447] = {
    0.4798253713883671e-1,
    0.5027767908071567e-1,
    0.5236288580640748e-1,
    0.5425112988854549e-1,
    0.5595081122041232e-1,
    0.5743711636156783e-1,
    0.5868968002239421e-1,
    0.5972034032417406e-1,
    0.6053945537604586e-1,
    0.6112850971705305e-1,
    0.6147118987142532e-1,
    0.6158081806783294e-1
  };
#define _data_n_448 13
  static real_4 _data_l_448[_data_n_448] = {
    0.1139379850102629e-1,
    0.2635498661503214e-1,
    0.4093915670130631e-1,
    0.5490469597583519e-1,
    0.6803833381235692e-1,
    0.8014070033500102e-1,
    0.9102826198296365e-1,
    0.1005359490670506e+00,
    0.1085196244742637e+00,
    0.1148582591457116e+00,
    0.1194557635357848e+00,
    0.12224244299031e+00,
    0.1231760537267155e+00
  };
  if (__calls[63].calls == 0) {
    _data_k_444 = 0;
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[0] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[1] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[2] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[3] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[4] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[5] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[6] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[7] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[8] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[9] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[10] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[11] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[12] = _data_l_444[_data_k_444++];
    if (_data_k_444 >= _data_n_444) {
      _data_k_444 = 0;
    }
    xgk_[13] = _data_l_444[_data_k_444++];
  }
  if (__calls[63].calls == 0) {
    _data_k_445 = 0;
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[14] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[15] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[16] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[17] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[18] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[19] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[20] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[21] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[22] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[23] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[24] = _data_l_445[_data_k_445++];
    if (_data_k_445 >= _data_n_445) {
      _data_k_445 = 0;
    }
    xgk_[25] = _data_l_445[_data_k_445++];
  }
  if (__calls[63].calls == 0) {
    _data_k_446 = 0;
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[0] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[1] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[2] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[3] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[4] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[5] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[6] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[7] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[8] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[9] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[10] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[11] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[12] = _data_l_446[_data_k_446++];
    if (_data_k_446 >= _data_n_446) {
      _data_k_446 = 0;
    }
    wgk_[13] = _data_l_446[_data_k_446++];
  }
  if (__calls[63].calls == 0) {
    _data_k_447 = 0;
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[14] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[15] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[16] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[17] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[18] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[19] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[20] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[21] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[22] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[23] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[24] = _data_l_447[_data_k_447++];
    if (_data_k_447 >= _data_n_447) {
      _data_k_447 = 0;
    }
    wgk_[25] = _data_l_447[_data_k_447++];
  }
  if (__calls[63].calls == 0) {
    _data_k_448 = 0;
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[0] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[1] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[2] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[3] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[4] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[5] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[6] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[7] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[8] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[9] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[10] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[11] = _data_l_448[_data_k_448++];
    if (_data_k_448 >= _data_n_448) {
      _data_k_448 = 0;
    }
    wg_[12] = _data_l_448[_data_k_448++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  centr_ = 0.5e+00 * ((*a_) + (*b_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  fc_ = _f (&centr_);
  resg_ = wg_[12] * fc_;
  resk_ = wgk_[25] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 12; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 13; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[25] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 25; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, powl ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[63].calls++;
  return 0;
}

int_4 _qk61 (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ result_, real_4 _p_ abserr_, real_4 _p_ resabs_, 
real_4 _p_ resasc_)
{
  static int_4 j_, jtw_, jtwm1_;
  static real_4 absc_, centr_, dhlgth_, epmach_, fc_, fsum_, fval1_, fval2_, fv1_[30], fv2_[30], hlgth_, resg_, resk_, 
  reskh_, uflow_, wg_[15], wgk_[31], xgk_[31];
  int_4 _data_k_449, _data_k_450, _data_k_451, _data_k_452, _data_k_453, _data_k_454, _data_k_455, _data_k_456, $0_;
  real_4 $1_, $2_, $3_, $4_;
  extern real_4 _r1mach ();
#define _data_n_449 10
  static real_4 _data_l_449[_data_n_449] = {
    0.9994844100504906e+00,
    0.9968934840746495e+00,
    0.9916309968704046e+00,
    0.9836681232797472e+00,
    0.9731163225011263e+00,
    0.9600218649683075e+00,
    0.94437444474856e+00,
    0.9262000474292743e+00,
    0.9055733076999078e+00,
    0.8825605357920527e+00
  };
#define _data_n_450 10
  static real_4 _data_l_450[_data_n_450] = {
    0.8572052335460611e+00,
    0.8295657623827684e+00,
    0.7997278358218391e+00,
    0.7677774321048262e+00,
    0.7337900624532268e+00,
    0.6978504947933158e+00,
    0.660061064126627e+00,
    0.6205261829892429e+00,
    0.5793452358263617e+00,
    0.5366241481420199e+00
  };
#define _data_n_451 11
  static real_4 _data_l_451[_data_n_451] = {
    0.4924804678617786e+00,
    0.4470337695380892e+00,
    0.4004012548303944e+00,
    0.3527047255308781e+00,
    0.3040732022736251e+00,
    0.2546369261678898e+00,
    0.2045251166823099e+00,
    0.1538699136085835e+00,
    0.102806937966737e+00,
    0.514718425553177e-1,
    0.0e+00
  };
#define _data_n_452 10
  static real_4 _data_l_452[_data_n_452] = {
    0.1389013698677008e-2,
    0.3890461127099884e-2,
    0.6630703915931292e-2,
    0.9273279659517763e-2,
    0.1182301525349634e-1,
    0.143697295070458e-1,
    0.1692088918905327e-1,
    0.1941414119394238e-1,
    0.2182803582160919e-1,
    0.241911620780806e-1
  };
#define _data_n_453 10
  static real_4 _data_l_453[_data_n_453] = {
    0.265099548823331e-1,
    0.2875404876504129e-1,
    0.3090725756238776e-1,
    0.3298144705748373e-1,
    0.3497933802806002e-1,
    0.3688236465182123e-1,
    0.3867894562472759e-1,
    0.4037453895153596e-1,
    0.4196981021516425e-1,
    0.4345253970135607e-1
  };
#define _data_n_454 11
  static real_4 _data_l_454[_data_n_454] = {
    0.4481480013316266e-1,
    0.4605923827100699e-1,
    0.4718554656929915e-1,
    0.4818586175708713e-1,
    0.4905543455502978e-1,
    0.4979568342707421e-1,
    0.5040592140278235e-1,
    0.5088179589874961e-1,
    0.5122154784925877e-1,
    0.5142612853745903e-1,
    0.5149472942945157e-1
  };
#define _data_n_455 8
  static real_4 _data_l_455[_data_n_455] = {
    0.7968192496166606e-2,
    0.1846646831109096e-1,
    0.2878470788332337e-1,
    0.3879919256962705e-1,
    0.4840267283059405e-1,
    0.5749315621761907e-1,
    0.659742298821805e-1,
    0.7375597473770521e-1
  };
#define _data_n_456 7
  static real_4 _data_l_456[_data_n_456] = {
    0.8075589522942022e-1,
    0.8689978720108298e-1,
    0.9212252223778613e-1,
    0.9636873717464426e-1,
    0.9959342058679527e-1,
    0.1017623897484055e+00,
    0.1028526528935588e+00
  };
  if (__calls[64].calls == 0) {
    _data_k_449 = 0;
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[0] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[1] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[2] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[3] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[4] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[5] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[6] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[7] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[8] = _data_l_449[_data_k_449++];
    if (_data_k_449 >= _data_n_449) {
      _data_k_449 = 0;
    }
    xgk_[9] = _data_l_449[_data_k_449++];
  }
  if (__calls[64].calls == 0) {
    _data_k_450 = 0;
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[10] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[11] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[12] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[13] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[14] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[15] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[16] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[17] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[18] = _data_l_450[_data_k_450++];
    if (_data_k_450 >= _data_n_450) {
      _data_k_450 = 0;
    }
    xgk_[19] = _data_l_450[_data_k_450++];
  }
  if (__calls[64].calls == 0) {
    _data_k_451 = 0;
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[20] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[21] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[22] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[23] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[24] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[25] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[26] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[27] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[28] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[29] = _data_l_451[_data_k_451++];
    if (_data_k_451 >= _data_n_451) {
      _data_k_451 = 0;
    }
    xgk_[30] = _data_l_451[_data_k_451++];
  }
  if (__calls[64].calls == 0) {
    _data_k_452 = 0;
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[0] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[1] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[2] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[3] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[4] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[5] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[6] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[7] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[8] = _data_l_452[_data_k_452++];
    if (_data_k_452 >= _data_n_452) {
      _data_k_452 = 0;
    }
    wgk_[9] = _data_l_452[_data_k_452++];
  }
  if (__calls[64].calls == 0) {
    _data_k_453 = 0;
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[10] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[11] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[12] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[13] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[14] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[15] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[16] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[17] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[18] = _data_l_453[_data_k_453++];
    if (_data_k_453 >= _data_n_453) {
      _data_k_453 = 0;
    }
    wgk_[19] = _data_l_453[_data_k_453++];
  }
  if (__calls[64].calls == 0) {
    _data_k_454 = 0;
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[20] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[21] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[22] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[23] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[24] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[25] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[26] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[27] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[28] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[29] = _data_l_454[_data_k_454++];
    if (_data_k_454 >= _data_n_454) {
      _data_k_454 = 0;
    }
    wgk_[30] = _data_l_454[_data_k_454++];
  }
  if (__calls[64].calls == 0) {
    _data_k_455 = 0;
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    wg_[0] = _data_l_455[_data_k_455++];
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    wg_[1] = _data_l_455[_data_k_455++];
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    wg_[2] = _data_l_455[_data_k_455++];
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    wg_[3] = _data_l_455[_data_k_455++];
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    wg_[4] = _data_l_455[_data_k_455++];
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    wg_[5] = _data_l_455[_data_k_455++];
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    wg_[6] = _data_l_455[_data_k_455++];
    if (_data_k_455 >= _data_n_455) {
      _data_k_455 = 0;
    }
    wg_[7] = _data_l_455[_data_k_455++];
  }
  if (__calls[64].calls == 0) {
    _data_k_456 = 0;
    if (_data_k_456 >= _data_n_456) {
      _data_k_456 = 0;
    }
    wg_[8] = _data_l_456[_data_k_456++];
    if (_data_k_456 >= _data_n_456) {
      _data_k_456 = 0;
    }
    wg_[9] = _data_l_456[_data_k_456++];
    if (_data_k_456 >= _data_n_456) {
      _data_k_456 = 0;
    }
    wg_[10] = _data_l_456[_data_k_456++];
    if (_data_k_456 >= _data_n_456) {
      _data_k_456 = 0;
    }
    wg_[11] = _data_l_456[_data_k_456++];
    if (_data_k_456 >= _data_n_456) {
      _data_k_456 = 0;
    }
    wg_[12] = _data_l_456[_data_k_456++];
    if (_data_k_456 >= _data_n_456) {
      _data_k_456 = 0;
    }
    wg_[13] = _data_l_456[_data_k_456++];
    if (_data_k_456 >= _data_n_456) {
      _data_k_456 = 0;
    }
    wg_[14] = _data_l_456[_data_k_456++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  centr_ = 0.5e+00 * ((*b_) + (*a_));
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  resg_ = 0.0;
  fc_ = _f (&centr_);
  resk_ = wgk_[30] * fc_;
  (*resabs_) = _abs (resk_);
  for (j_ = 1; j_ <= 15; (j_)++) {
    jtw_ = j_ * 2;
    absc_ = hlgth_ * xgk_[jtw_ - 1];
    fval1_ = _f (($1_ = centr_ - absc_, &$1_));
    fval2_ = _f (($2_ = centr_ + absc_, &$2_));
    fv1_[jtw_ - 1] = fval1_;
    fv2_[jtw_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resg_ = resg_ + wg_[j_ - 1] * fsum_;
    resk_ = resk_ + wgk_[jtw_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtw_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  for (j_ = 1; j_ <= 15; (j_)++) {
    jtwm1_ = j_ * 2 - 1;
    absc_ = hlgth_ * xgk_[jtwm1_ - 1];
    fval1_ = _f (($3_ = centr_ - absc_, &$3_));
    fval2_ = _f (($4_ = centr_ + absc_, &$4_));
    fv1_[jtwm1_ - 1] = fval1_;
    fv2_[jtwm1_ - 1] = fval2_;
    fsum_ = fval1_ + fval2_;
    resk_ = resk_ + wgk_[jtwm1_ - 1] * fsum_;
    (*resabs_) = (*resabs_) + wgk_[jtwm1_ - 1] * (_abs (fval1_) + _abs (fval2_));
  }
  reskh_ = resk_ * 0.5e+00;
  (*resasc_) = wgk_[30] * _abs (fc_ - reskh_);
  for (j_ = 1; j_ <= 30; (j_)++) {
    (*resasc_) = (*resasc_) + wgk_[j_ - 1] * (_abs (fv1_[j_ - 1] - reskh_) + _abs (fv2_[j_ - 1] - reskh_));
  }
  (*result_) = resk_ * hlgth_;
  (*resabs_) = (*resabs_) * dhlgth_;
  (*resasc_) = (*resasc_) * dhlgth_;
  (*abserr_) = _abs ((resk_ - resg_) * hlgth_);
  if ((*resasc_) != 0.0e+00 && (*abserr_) != 0.0e+00) {
    (*abserr_) = (*resasc_) * _min (1.0, powl ((0.2e3 * (*abserr_) / (*resasc_)), 1.5e+00));
  }
  if ((*resabs_) > uflow_ / (0.5e2 * epmach_)) {
    (*abserr_) = _max ((epmach_ * 0.5e2) * (*resabs_), (*abserr_));
  }
  __calls[64].calls++;
  return 0;
}

int_4 _qmomo (real_4 _p_ alfa_, real_4 _p_ beta_, real_4 _p_ ri_, real_4 _p_ rj_, real_4 _p_ rg_, real_4 _p_ rh_, int_4 
_p_ integr_)
{
  static int_4 i_, im1_;
  static real_4 alfp1_, alfp2_, an_, anm1_, betp1_, betp2_, ralf_, rbet_;
  alfp1_ = (*alfa_) + 0.1e1;
  betp1_ = (*beta_) + 0.1e1;
  alfp2_ = (*alfa_) + 0.2e1;
  betp2_ = (*beta_) + 0.2e1;
  ralf_ = powl (0.2e1, alfp1_);
  rbet_ = powl (0.2e1, betp1_);
  ri_[0] = ralf_ / alfp1_;
  rj_[0] = rbet_ / betp1_;
  ri_[1] = ri_[0] * (*alfa_) / alfp2_;
  rj_[1] = rj_[0] * (*beta_) / betp2_;
  an_ = 2.0;
  anm1_ = 1.0;
  for (i_ = 3; i_ <= 25; (i_)++) {
    ri_[i_ - 1] = -(ralf_ + an_ * (an_ - alfp2_) * ri_[i_ - 1 - 1]) / (anm1_ * (an_ + alfp1_));
    rj_[i_ - 1] = -(rbet_ + an_ * (an_ - betp2_) * rj_[i_ - 1 - 1]) / (anm1_ * (an_ + betp1_));
    anm1_ = an_;
    an_ = an_ + 0.1e1;
  }
  if ((*integr_) == 1) {
    goto _l70;
  }
  if ((*integr_) == 3) {
    goto _l40;
  }
  rg_[0] = -ri_[0] / alfp1_;
  rg_[1] = -(ralf_ + ralf_) / (alfp2_ * alfp2_) - rg_[0];
  an_ = 2.0;
  anm1_ = 1.0;
  im1_ = 2;
  for (i_ = 3; i_ <= 25; (i_)++) {
    rg_[i_ - 1] = -(an_ * (an_ - alfp2_) * rg_[im1_ - 1] - an_ * ri_[im1_ - 1] + anm1_ * ri_[i_ - 1]) / (anm1_ * (an_ + 
    alfp1_));
    anm1_ = an_;
    an_ = an_ + 0.1e1;
    im1_ = i_;
  }
  if ((*integr_) == 2) {
    goto _l70;
  }
  _l40:;
  rh_[0] = -rj_[0] / betp1_;
  rh_[1] = -(rbet_ + rbet_) / (betp2_ * betp2_) - rh_[0];
  an_ = 2.0;
  anm1_ = 1.0;
  im1_ = 2;
  for (i_ = 3; i_ <= 25; (i_)++) {
    rh_[i_ - 1] = -(an_ * (an_ - betp2_) * rh_[im1_ - 1] - an_ * rj_[im1_ - 1] + anm1_ * rj_[i_ - 1]) / (anm1_ * (an_ + 
    betp1_));
    anm1_ = an_;
    an_ = an_ + 0.1e1;
    im1_ = i_;
  }
  for (i_ = 2; (2 > 0 ? i_ <= 25 : i_ >= 25); i_ += 2) {
    rh_[i_ - 1] = -rh_[i_ - 1];
  }
  _l70:;
  for (i_ = 2; (2 > 0 ? i_ <= 25 : i_ >= 25); i_ += 2) {
    rj_[i_ - 1] = -rj_[i_ - 1];
  }
  __calls[65].calls++;
  return 0;
}

int_4 _qnc79 (real_4 (*_fun)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ err_, real_4 _p_ ans_, int_4 _p_ ierr_, int_4 
_p_ k_)
{
  static int_4 i_, kml_, kmx_, l_, lmn_, lmx_, nbits_, nib_, nlmn_, nlmx_, lr_[40];
  static logical_4 first_;
  static real_4 ae_, area_, bank_, blocal_, c_, ce_, ee_, ef_, eps_, q13_, q7_, q7l_, sq2_, test_, tol_, vr_, w1_, w2_, 
  w3_, w4_, aa_[40], f_[13], f1_[40], f2_[40], f3_[40], f4_[40], f5_[40], f6_[40], f7_[40], hh_[40], q7r_[40], vl_[40];
  int_4 _data_k_457, _data_k_458, _data_k_459, _data_k_460, $0_, $1_, $2_, $7_, $8_, $9_;
  real_4 $3_, $4_, $5_, $6_;
  char_127 $10_;
  extern real_4 _r1mach ();
  extern int_4 _i1mach ();
  extern int_4 _xermsg ();
#define _data_n_457 1
  static int_4 _data_l_457[_data_n_457] = {
    7
  };
#define _data_n_458 1
  static int_4 _data_l_458[_data_n_458] = {
    2000
  };
#define _data_n_459 1
  static int_4 _data_l_459[_data_n_459] = {
    2
  };
#define _data_n_460 1
  static logical_4 _data_l_460[_data_n_460] = {
    TRUE
  };
  if (__calls[66].calls == 0) {
    _data_k_457 = 0;
    if (_data_k_457 >= _data_n_457) {
      _data_k_457 = 0;
    }
    kml_ = _data_l_457[_data_k_457++];
    _data_k_458 = 0;
    if (_data_k_458 >= _data_n_458) {
      _data_k_458 = 0;
    }
    kmx_ = _data_l_458[_data_k_458++];
    _data_k_459 = 0;
    if (_data_k_459 >= _data_n_459) {
      _data_k_459 = 0;
    }
    nlmn_ = _data_l_459[_data_k_459++];
  }
  if (__calls[66].calls == 0) {
    _data_k_460 = 0;
    if (_data_k_460 >= _data_n_460) {
      _data_k_460 = 0;
    }
    first_ = _data_l_460[_data_k_460++];
  }
  if (first_) {
    w1_ = 2.9285714e-1;
    w2_ = 1.5428571;
    w3_ = 1.9285714e-1;
    w4_ = 1.9428571;
    nbits_ = _r1mach (($0_ = 5, &$0_)) * _i1mach (($1_ = 11, &$1_)) / 0.30102e0;
    nlmx_ = _min (40, (nbits_ * 4) / 5);
    sq2_ = 1.4142136;
  }
  first_ = FALSE;
  (*ans_) = 0.0;
  (*ierr_) = 1;
  ce_ = 0.0;
  if ((*a_) == (*b_)) {
    goto _l260;
  }
  lmx_ = nlmx_;
  lmn_ = nlmn_;
  if ((*b_) == 0.0e0) {
    goto _l100;
  }
  if (_sign (1.0, (*b_)) * (*a_) <= 0.0e0) {
    goto _l100;
  }
  c_ = _abs (1.0e0 - (*a_) / (*b_));
  if (c_ > 0.1e0) {
    goto _l100;
  }
  if (c_ <= 0.0e0) {
    goto _l260;
  }
  nib_ = 0.5e0 - logf (c_) / 6.9314718055994530941723212145817656807550013436025525412068000949339362e-1;
  lmx_ = _min (nlmx_, nbits_ - nib_ - 4);
  if (lmx_ < 2) {
    goto _l260;
  }
  lmn_ = _min (lmn_, lmx_);
  _l100:;
  tol_ = _max (_abs ((*err_)), _up_real_4 (2.0e0, (5 - nbits_)));
  if ((*err_) == 0.0e0) {
    tol_ = sqrtf (_r1mach (($2_ = 4, &$2_)));
  }
  eps_ = tol_;
  hh_[0] = ((*b_) - (*a_)) / 12.0e0;
  aa_[0] = (*a_);
  lr_[0] = 1;
  for (i_ = 1; (2 > 0 ? i_ <= 11 : i_ >= 11); i_ += 2) {
    f_[i_ - 1] = _fun (($3_ = (*a_) + (i_ - 1) * hh_[0], &$3_));
  }
  blocal_ = (*b_);
  f_[12] = _fun (&blocal_);
  (*k_) = 7;
  l_ = 1;
  area_ = 0.0;
  q7_ = 0.0;
  ef_ = 1.0039216;
  bank_ = 0.0;
  _l120:;
  for (i_ = 2; (2 > 0 ? i_ <= 12 : i_ >= 12); i_ += 2) {
    f_[i_ - 1] = _fun (($4_ = aa_[l_ - 1] + (i_ - 1) * hh_[l_ - 1], &$4_));
  }
  (*k_) = (*k_) + 6;
  q7l_ = hh_[l_ - 1] * ((w1_ * (f_[0] + f_[6]) + w2_ * (f_[1] + f_[5])) + (w3_ * (f_[2] + f_[4]) + w4_ * f_[3]));
  q7r_[l_ - 1] = hh_[l_ - 1] * ((w1_ * (f_[6] + f_[12]) + w2_ * (f_[7] + f_[11])) + (w3_ * (f_[8] + f_[10]) + w4_ * 
  f_[9]));
  area_ = area_ + (_abs (q7l_) + _abs (q7r_[l_ - 1]) - _abs (q7_));
  if (l_ < lmn_) {
    goto _l180;
  }
  q13_ = q7l_ + q7r_[l_ - 1];
  ee_ = _abs (q7_ - q13_) * ef_;
  ae_ = eps_ * area_;
  test_ = _min (ae_ + 0.8e0 * bank_, 10.0e0 * ae_);
  test_ = ($5_ = _max (test_, tol_ * _abs (q13_)), _max ($5_, 0.00003e0 * tol_ * area_));
  $6_ = ee_ - test_;
  if ($6_ < 0) {
    goto _l150;
  } else if ($6_ == 0) {
    goto _l150;
  } else {
    goto _l170;
  }
  _l140:;
  ce_ = ce_ + (q7_ - q13_);
  goto _l160;
  _l150:;
  ce_ = ce_ + (q7_ - q13_) / 255.0;
  _l160:;
  bank_ = bank_ + (ae_ - ee_);
  if (bank_ < 0.0e0) {
    bank_ = 0.0;
  }
  $7_ = lr_[l_ - 1];
  if ($7_ < 0) {
    goto _l190;
  } else if ($7_ == 0) {
    goto _l190;
  } else {
    goto _l210;
  }
  _l170:;
  if ((*k_) > kmx_) {
    lmx_ = _min (kml_, lmx_);
  }
  if (l_ >= lmx_) {
    goto _l140;
  }
  _l180:;
  l_ = l_ + 1;
  eps_ = eps_ * 0.5e0;
  if (l_ <= 17) {
    ef_ = ef_ / sq2_;
  }
  hh_[l_ - 1] = hh_[l_ - 1 - 1] * 0.5e0;
  lr_[l_ - 1] = -1;
  aa_[l_ - 1] = aa_[l_ - 1 - 1];
  q7_ = q7l_;
  f1_[l_ - 1] = f_[6];
  f2_[l_ - 1] = f_[7];
  f3_[l_ - 1] = f_[8];
  f4_[l_ - 1] = f_[9];
  f5_[l_ - 1] = f_[10];
  f6_[l_ - 1] = f_[11];
  f7_[l_ - 1] = f_[12];
  f_[12] = f_[6];
  f_[10] = f_[5];
  f_[8] = f_[4];
  f_[6] = f_[3];
  f_[4] = f_[2];
  f_[2] = f_[1];
  goto _l120;
  _l190:;
  vl_[l_ - 1] = q13_;
  _l200:;
  q7_ = q7r_[l_ - 1 - 1];
  lr_[l_ - 1] = 1;
  aa_[l_ - 1] = aa_[l_ - 1] + 12.0e0 * hh_[l_ - 1];
  f_[0] = f1_[l_ - 1];
  f_[2] = f2_[l_ - 1];
  f_[4] = f3_[l_ - 1];
  f_[6] = f4_[l_ - 1];
  f_[8] = f5_[l_ - 1];
  f_[10] = f6_[l_ - 1];
  f_[12] = f7_[l_ - 1];
  goto _l120;
  _l210:;
  vr_ = q13_;
  _l220:;
  if (l_ <= 1) {
    goto _l250;
  }
  if (l_ <= 17) {
    ef_ = ef_ * sq2_;
  }
  eps_ = eps_ * 2.0e0;
  l_ = l_ - 1;
  $8_ = lr_[l_ - 1];
  if ($8_ < 0) {
    goto _l230;
  } else if ($8_ == 0) {
    goto _l230;
  } else {
    goto _l240;
  }
  _l230:;
  vl_[l_ - 1] = vl_[l_ + 1 - 1] + vr_;
  goto _l200;
  _l240:;
  vr_ = vl_[l_ + 1 - 1] + vr_;
  goto _l220;
  _l250:;
  (*ans_) = vr_;
  if (_abs (ce_) <= 2.0e0 * tol_ * area_) {
    goto _l270;
  }
  (*ierr_) = 2;
  (void) _xermsg (_dc_0, _dc_23, _dc_11, ($9_ = 2, &$9_), &_k1);
  goto _l270;
  _l260:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_23, concat ($10_, _dc_12, _dc_13), &_km1, &_km1);
  _l270:;
  __calls[66].calls++;
  return 0;
}

int_4 _qng (real_4 (*_f)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ epsabs_, real_4 _p_ epsrel_, real_4 _p_ result_, 
real_4 _p_ abserr_, int_4 _p_ neval_, int_4 _p_ ier_)
{
  static int_4 ipx_, k_, l_;
  static real_4 absc_, centr_, dhlgth_, epmach_, fcentr_, fval_, fval1_, fval2_, fv1_[5], fv2_[5], fv3_[5], fv4_[5], 
  hlgth_, res10_, res21_, res43_, res87_, resabs_, resasc_, reskh_, savfun_[21], uflow_, w10_[5], w21a_[5], w43a_[10], 
  w43b_[12], w87a_[21], w87b_[23], x1_[5], x2_[5], x3_[11], x4_[22], w21b_[6];
  int_4 _data_k_461, _data_k_462, _data_k_463, _data_k_464, _data_k_465, _data_k_466, _data_k_467, _data_k_468, 
  _data_k_469, _data_k_470, _data_k_471, $0_;
  real_4 $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_;
  extern real_4 _r1mach ();
#define _data_n_461 5
  static real_4 _data_l_461[_data_n_461] = {
    0.9739065285171717e+00,
    0.8650633666889845e+00,
    0.6794095682990244e+00,
    0.4333953941292472e+00,
    0.1488743389816312e+00
  };
#define _data_n_462 5
  static real_4 _data_l_462[_data_n_462] = {
    0.9956571630258081e+00,
    0.9301574913557082e+00,
    0.7808177265864169e+00,
    0.5627571346686047e+00,
    0.2943928627014602e+00
  };
#define _data_n_463 11
  static real_4 _data_l_463[_data_n_463] = {
    0.9993333609019321e+00,
    0.9874334029080889e+00,
    0.9548079348142663e+00,
    0.9001486957483283e+00,
    0.8251983149831142e+00,
    0.732148388989305e+00,
    0.6228479705377252e+00,
    0.4994795740710565e+00,
    0.3649016613465808e+00,
    0.2222549197766013e+00,
    0.7465061746138332e-1
  };
#define _data_n_464 22
  static real_4 _data_l_464[_data_n_464] = {
    0.9999029772627292e+00,
    0.9979898959866787e+00,
    0.9921754978606872e+00,
    0.9813581635727128e+00,
    0.9650576238583846e+00,
    0.9431676131336706e+00,
    0.9158064146855072e+00,
    0.8832216577713165e+00,
    0.8457107484624157e+00,
    0.803557658035231e+00,
    0.7570057306854956e+00,
    0.7062732097873218e+00,
    0.6515894665011779e+00,
    0.5932233740579611e+00,
    0.5314936059708319e+00,
    0.4667636230420228e+00,
    0.3994248478592188e+00,
    0.3298748771061883e+00,
    0.2585035592021616e+00,
    0.1856953965683467e+00,
    0.1118422131799075e+00,
    0.3735212339461987e-1
  };
#define _data_n_465 5
  static real_4 _data_l_465[_data_n_465] = {
    0.6667134430868814e-1,
    0.1494513491505806e+00,
    0.219086362515982e+00,
    0.2692667193099964e+00,
    0.2955242247147529e+00
  };
#define _data_n_466 5
  static real_4 _data_l_466[_data_n_466] = {
    0.3255816230796473e-1,
    0.7503967481091995e-1,
    0.1093871588022976e+00,
    0.1347092173114733e+00,
    0.1477391049013385e+00
  };
#define _data_n_467 6
  static real_4 _data_l_467[_data_n_467] = {
    0.1169463886737187e-1,
    0.54755896574352e-1,
    0.9312545458369761e-1,
    0.1234919762620659e+00,
    0.1427759385770601e+00,
    0.1494455540029169e+00
  };
#define _data_n_468 10
  static real_4 _data_l_468[_data_n_468] = {
    0.1629673428966656e-1,
    0.375228761208695e-1,
    0.5469490205825544e-1,
    0.6735541460947809e-1,
    0.7387019963239395e-1,
    0.5768556059769796e-2,
    0.2737189059324884e-1,
    0.4656082691042883e-1,
    0.6174499520144256e-1,
    0.713872672686934e-1
  };
#define _data_n_469 12
  static real_4 _data_l_469[_data_n_469] = {
    0.1844477640212414e-2,
    0.1079868958589165e-1,
    0.2189536386779543e-1,
    0.3259746397534569e-1,
    0.4216313793519181e-1,
    0.5074193960018458e-1,
    0.5837939554261925e-1,
    0.6474640495144589e-1,
    0.6956619791235648e-1,
    0.7282444147183321e-1,
    0.7450775101417512e-1,
    0.7472214751740301e-1
  };
#define _data_n_470 21
  static real_4 _data_l_470[_data_n_470] = {
    0.8148377384149173e-2,
    0.1876143820156282e-1,
    0.2734745105005229e-1,
    0.3367770731163793e-1,
    0.3693509982042791e-1,
    0.2884872430211531e-2,
    0.136859460227127e-1,
    0.2328041350288831e-1,
    0.3087249761171336e-1,
    0.3569363363941877e-1,
    0.9152833452022414e-3,
    0.5399280219300471e-2,
    0.1094767960111893e-1,
    0.1629873169678734e-1,
    0.2108156888920384e-1,
    0.2537096976925383e-1,
    0.2918969775647575e-1,
    0.3237320246720279e-1,
    0.3478309895036514e-1,
    0.3641222073135179e-1,
    0.3725387550304771e-1
  };
#define _data_n_471 23
  static real_4 _data_l_471[_data_n_471] = {
    0.2741455637620724e-3,
    0.1807124155057943e-2,
    0.4096869282759165e-2,
    0.6758290051847379e-2,
    0.9549957672201647e-2,
    0.1232944765224485e-1,
    0.1501044734638895e-1,
    0.1754896798624319e-1,
    0.1993803778644089e-1,
    0.2219493596101229e-1,
    0.2433914712600081e-1,
    0.2637450541483921e-1,
    0.282869107887712e-1,
    0.300525811280927e-1,
    0.3164675137143993e-1,
    0.330504134199785e-1,
    0.3425509970422606e-1,
    0.3526241266015668e-1,
    0.360769896228887e-1,
    0.3669860449845609e-1,
    0.3712054926983258e-1,
    0.3733422875193504e-1,
    0.3736107376267902e-1
  };
  if (__calls[67].calls == 0) {
    _data_k_461 = 0;
    if (_data_k_461 >= _data_n_461) {
      _data_k_461 = 0;
    }
    x1_[0] = _data_l_461[_data_k_461++];
    if (_data_k_461 >= _data_n_461) {
      _data_k_461 = 0;
    }
    x1_[1] = _data_l_461[_data_k_461++];
    if (_data_k_461 >= _data_n_461) {
      _data_k_461 = 0;
    }
    x1_[2] = _data_l_461[_data_k_461++];
    if (_data_k_461 >= _data_n_461) {
      _data_k_461 = 0;
    }
    x1_[3] = _data_l_461[_data_k_461++];
    if (_data_k_461 >= _data_n_461) {
      _data_k_461 = 0;
    }
    x1_[4] = _data_l_461[_data_k_461++];
  }
  if (__calls[67].calls == 0) {
    _data_k_462 = 0;
    if (_data_k_462 >= _data_n_462) {
      _data_k_462 = 0;
    }
    x2_[0] = _data_l_462[_data_k_462++];
    if (_data_k_462 >= _data_n_462) {
      _data_k_462 = 0;
    }
    x2_[1] = _data_l_462[_data_k_462++];
    if (_data_k_462 >= _data_n_462) {
      _data_k_462 = 0;
    }
    x2_[2] = _data_l_462[_data_k_462++];
    if (_data_k_462 >= _data_n_462) {
      _data_k_462 = 0;
    }
    x2_[3] = _data_l_462[_data_k_462++];
    if (_data_k_462 >= _data_n_462) {
      _data_k_462 = 0;
    }
    x2_[4] = _data_l_462[_data_k_462++];
  }
  if (__calls[67].calls == 0) {
    _data_k_463 = 0;
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[0] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[1] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[2] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[3] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[4] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[5] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[6] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[7] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[8] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[9] = _data_l_463[_data_k_463++];
    if (_data_k_463 >= _data_n_463) {
      _data_k_463 = 0;
    }
    x3_[10] = _data_l_463[_data_k_463++];
  }
  if (__calls[67].calls == 0) {
    _data_k_464 = 0;
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[0] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[1] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[2] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[3] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[4] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[5] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[6] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[7] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[8] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[9] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[10] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[11] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[12] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[13] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[14] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[15] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[16] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[17] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[18] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[19] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[20] = _data_l_464[_data_k_464++];
    if (_data_k_464 >= _data_n_464) {
      _data_k_464 = 0;
    }
    x4_[21] = _data_l_464[_data_k_464++];
  }
  if (__calls[67].calls == 0) {
    _data_k_465 = 0;
    if (_data_k_465 >= _data_n_465) {
      _data_k_465 = 0;
    }
    w10_[0] = _data_l_465[_data_k_465++];
    if (_data_k_465 >= _data_n_465) {
      _data_k_465 = 0;
    }
    w10_[1] = _data_l_465[_data_k_465++];
    if (_data_k_465 >= _data_n_465) {
      _data_k_465 = 0;
    }
    w10_[2] = _data_l_465[_data_k_465++];
    if (_data_k_465 >= _data_n_465) {
      _data_k_465 = 0;
    }
    w10_[3] = _data_l_465[_data_k_465++];
    if (_data_k_465 >= _data_n_465) {
      _data_k_465 = 0;
    }
    w10_[4] = _data_l_465[_data_k_465++];
  }
  if (__calls[67].calls == 0) {
    _data_k_466 = 0;
    if (_data_k_466 >= _data_n_466) {
      _data_k_466 = 0;
    }
    w21a_[0] = _data_l_466[_data_k_466++];
    if (_data_k_466 >= _data_n_466) {
      _data_k_466 = 0;
    }
    w21a_[1] = _data_l_466[_data_k_466++];
    if (_data_k_466 >= _data_n_466) {
      _data_k_466 = 0;
    }
    w21a_[2] = _data_l_466[_data_k_466++];
    if (_data_k_466 >= _data_n_466) {
      _data_k_466 = 0;
    }
    w21a_[3] = _data_l_466[_data_k_466++];
    if (_data_k_466 >= _data_n_466) {
      _data_k_466 = 0;
    }
    w21a_[4] = _data_l_466[_data_k_466++];
  }
  if (__calls[67].calls == 0) {
    _data_k_467 = 0;
    if (_data_k_467 >= _data_n_467) {
      _data_k_467 = 0;
    }
    w21b_[0] = _data_l_467[_data_k_467++];
    if (_data_k_467 >= _data_n_467) {
      _data_k_467 = 0;
    }
    w21b_[1] = _data_l_467[_data_k_467++];
    if (_data_k_467 >= _data_n_467) {
      _data_k_467 = 0;
    }
    w21b_[2] = _data_l_467[_data_k_467++];
    if (_data_k_467 >= _data_n_467) {
      _data_k_467 = 0;
    }
    w21b_[3] = _data_l_467[_data_k_467++];
    if (_data_k_467 >= _data_n_467) {
      _data_k_467 = 0;
    }
    w21b_[4] = _data_l_467[_data_k_467++];
    if (_data_k_467 >= _data_n_467) {
      _data_k_467 = 0;
    }
    w21b_[5] = _data_l_467[_data_k_467++];
  }
  if (__calls[67].calls == 0) {
    _data_k_468 = 0;
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[0] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[1] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[2] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[3] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[4] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[5] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[6] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[7] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[8] = _data_l_468[_data_k_468++];
    if (_data_k_468 >= _data_n_468) {
      _data_k_468 = 0;
    }
    w43a_[9] = _data_l_468[_data_k_468++];
  }
  if (__calls[67].calls == 0) {
    _data_k_469 = 0;
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[0] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[1] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[2] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[3] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[4] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[5] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[6] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[7] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[8] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[9] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[10] = _data_l_469[_data_k_469++];
    if (_data_k_469 >= _data_n_469) {
      _data_k_469 = 0;
    }
    w43b_[11] = _data_l_469[_data_k_469++];
  }
  if (__calls[67].calls == 0) {
    _data_k_470 = 0;
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[0] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[1] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[2] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[3] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[4] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[5] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[6] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[7] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[8] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[9] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[10] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[11] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[12] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[13] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[14] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[15] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[16] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[17] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[18] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[19] = _data_l_470[_data_k_470++];
    if (_data_k_470 >= _data_n_470) {
      _data_k_470 = 0;
    }
    w87a_[20] = _data_l_470[_data_k_470++];
  }
  if (__calls[67].calls == 0) {
    _data_k_471 = 0;
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[0] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[1] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[2] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[3] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[4] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[5] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[6] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[7] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[8] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[9] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[10] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[11] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[12] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[13] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[14] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[15] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[16] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[17] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[18] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[19] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[20] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[21] = _data_l_471[_data_k_471++];
    if (_data_k_471 >= _data_n_471) {
      _data_k_471 = 0;
    }
    w87b_[22] = _data_l_471[_data_k_471++];
  }
  epmach_ = _r1mach (($0_ = 4, &$0_));
  uflow_ = _r1mach (&_k1);
  (*result_) = 0.0;
  (*abserr_) = 0.0;
  (*neval_) = 0;
  (*ier_) = 6;
  if ((*epsabs_) <= 0.0e+00 && (*epsrel_) < _max (5.0e-15, 0.5e2 * epmach_)) {
    goto _l80;
  }
  hlgth_ = 0.5e+00 * ((*b_) - (*a_));
  dhlgth_ = _abs (hlgth_);
  centr_ = 0.5e+00 * ((*b_) + (*a_));
  fcentr_ = _f (&centr_);
  (*neval_) = 21;
  (*ier_) = 1;
  for (l_ = 1; l_ <= 3; (l_)++) {
    switch (l_) {
      default:
      case 1: goto _l5;
      case 2: goto _l25;
      case 3: goto _l45;
    }
    _l5:;
    res10_ = 0.0;
    res21_ = w21b_[5] * fcentr_;
    resabs_ = w21b_[5] * _abs (fcentr_);
    for (k_ = 1; k_ <= 5; (k_)++) {
      absc_ = hlgth_ * x1_[k_ - 1];
      fval1_ = _f (($1_ = centr_ + absc_, &$1_));
      fval2_ = _f (($2_ = centr_ - absc_, &$2_));
      fval_ = fval1_ + fval2_;
      res10_ = res10_ + w10_[k_ - 1] * fval_;
      res21_ = res21_ + w21a_[k_ - 1] * fval_;
      resabs_ = resabs_ + w21a_[k_ - 1] * (_abs (fval1_) + _abs (fval2_));
      savfun_[k_ - 1] = fval_;
      fv1_[k_ - 1] = fval1_;
      fv2_[k_ - 1] = fval2_;
    }
    ipx_ = 5;
    for (k_ = 1; k_ <= 5; (k_)++) {
      ipx_ = ipx_ + 1;
      absc_ = hlgth_ * x2_[k_ - 1];
      fval1_ = _f (($3_ = centr_ + absc_, &$3_));
      fval2_ = _f (($4_ = centr_ - absc_, &$4_));
      fval_ = fval1_ + fval2_;
      res21_ = res21_ + w21b_[k_ - 1] * fval_;
      resabs_ = resabs_ + w21b_[k_ - 1] * (_abs (fval1_) + _abs (fval2_));
      savfun_[ipx_ - 1] = fval_;
      fv3_[k_ - 1] = fval1_;
      fv4_[k_ - 1] = fval2_;
    }
    (*result_) = res21_ * hlgth_;
    resabs_ = resabs_ * dhlgth_;
    reskh_ = 0.5e+00 * res21_;
    resasc_ = w21b_[5] * _abs (fcentr_ - reskh_);
    for (k_ = 1; k_ <= 5; (k_)++) {
      resasc_ = resasc_ + w21a_[k_ - 1] * (_abs (fv1_[k_ - 1] - reskh_) + _abs (fv2_[k_ - 1] - reskh_)) + w21b_[k_ - 1] * 
      (_abs (fv3_[k_ - 1] - reskh_) + _abs (fv4_[k_ - 1] - reskh_));
    }
    (*abserr_) = _abs ((res21_ - res10_) * hlgth_);
    resasc_ = resasc_ * dhlgth_;
    goto _l65;
    _l25:;
    res43_ = w43b_[11] * fcentr_;
    (*neval_) = 43;
    for (k_ = 1; k_ <= 10; (k_)++) {
      res43_ = res43_ + savfun_[k_ - 1] * w43a_[k_ - 1];
    }
    for (k_ = 1; k_ <= 11; (k_)++) {
      ipx_ = ipx_ + 1;
      absc_ = hlgth_ * x3_[k_ - 1];
      fval_ = _f (($5_ = absc_ + centr_, &$5_)) + _f (($6_ = centr_ - absc_, &$6_));
      res43_ = res43_ + fval_ * w43b_[k_ - 1];
      savfun_[ipx_ - 1] = fval_;
    }
    (*result_) = res43_ * hlgth_;
    (*abserr_) = _abs ((res43_ - res21_) * hlgth_);
    goto _l65;
    _l45:;
    res87_ = w87b_[22] * fcentr_;
    (*neval_) = 87;
    for (k_ = 1; k_ <= 21; (k_)++) {
      res87_ = res87_ + savfun_[k_ - 1] * w87a_[k_ - 1];
    }
    for (k_ = 1; k_ <= 22; (k_)++) {
      absc_ = hlgth_ * x4_[k_ - 1];
      res87_ = res87_ + w87b_[k_ - 1] * (_f (($7_ = absc_ + centr_, &$7_)) + _f (($8_ = centr_ - absc_, &$8_)));
    }
    (*result_) = res87_ * hlgth_;
    (*abserr_) = _abs ((res87_ - res43_) * hlgth_);
    _l65:;
    if (resasc_ != 0.0e+00 && (*abserr_) != 0.0e+00) {
      (*abserr_) = resasc_ * _min (1.0, powl ((0.2e3 * (*abserr_) / resasc_), 1.5e+00));
    }
    if (resabs_ > uflow_ / (0.5e2 * epmach_)) {
      (*abserr_) = _max ((epmach_ * 0.5e2) * resabs_, (*abserr_));
    }
    if ((*abserr_) <= _max ((*epsabs_), (*epsrel_) * _abs ((*result_)))) {
      (*ier_) = 0;
    }
    if ((*ier_) == 0) {
      goto _l999;
    }
  }
  _l80:;
  (void) _xermsg (_dc_0, _dc_24, _dc_2, ier_, &_k0);
  _l999:;
  __calls[67].calls++;
  return 0;
}

int_4 _qpdoc (void)
{
  __calls[68].calls++;
  return 0;
}

int_4 _qpsrt (int_4 _p_ limit_, int_4 _p_ last_, int_4 _p_ maxerr_, real_4 _p_ ermax_, real_4 _p_ elist_, int_4 _p_ 
iord_, int_4 _p_ nrmax_)
{
  static int_4 i_, ibeg_, ido_, isucc_, j_, jbnd_, jupbn_, k_;
  static real_4 errmax_, errmin_;
  if ((*last_) > 2) {
    goto _l10;
  }
  iord_[0] = 1;
  iord_[1] = 2;
  goto _l90;
  _l10:;
  errmax_ = elist_[(*maxerr_) - 1];
  if ((*nrmax_) == 1) {
    goto _l30;
  }
  ido_ = (*nrmax_) - 1;
  for (i_ = 1; i_ <= ido_; (i_)++) {
    isucc_ = iord_[(*nrmax_) - 1 - 1];
    if (errmax_ <= elist_[isucc_ - 1]) {
      goto _l30;
    }
    iord_[(*nrmax_) - 1] = isucc_;
    (*nrmax_) = (*nrmax_) - 1;
  }
  _l30:;
  jupbn_ = (*last_);
  if ((*last_) > ((*limit_) / 2 + 2)) {
    jupbn_ = (*limit_) + 3 - (*last_);
  }
  errmin_ = elist_[(*last_) - 1];
  jbnd_ = jupbn_ - 1;
  ibeg_ = (*nrmax_) + 1;
  if (ibeg_ > jbnd_) {
    goto _l50;
  }
  for (i_ = ibeg_; i_ <= jbnd_; (i_)++) {
    isucc_ = iord_[i_ - 1];
    if (errmax_ >= elist_[isucc_ - 1]) {
      goto _l60;
    }
    iord_[i_ - 1 - 1] = isucc_;
  }
  _l50:;
  iord_[jbnd_ - 1] = (*maxerr_);
  iord_[jupbn_ - 1] = (*last_);
  goto _l90;
  _l60:;
  iord_[i_ - 1 - 1] = (*maxerr_);
  k_ = jbnd_;
  for (j_ = i_; j_ <= jbnd_; (j_)++) {
    isucc_ = iord_[k_ - 1];
    if (errmin_ < elist_[isucc_ - 1]) {
      goto _l80;
    }
    iord_[k_ + 1 - 1] = isucc_;
    k_ = k_ - 1;
  }
  iord_[i_ - 1] = (*last_);
  goto _l90;
  _l80:;
  iord_[k_ + 1 - 1] = (*last_);
  _l90:;
  (*maxerr_) = iord_[(*nrmax_) - 1];
  (*ermax_) = elist_[(*maxerr_) - 1];
  __calls[69].calls++;
  return 0;
}

real_4 _qwgtc (real_4 _p_ x_, real_4 _p_ c_, real_4 _p_ p2_, real_4 _p_ p3_, real_4 _p_ p4_, int_4 _p_ kp_)
{
  real_4 qwgtc_;
  qwgtc_ = 0.1e1 / ((*x_) - (*c_));
  __calls[70].calls++;
  return qwgtc_;
}

real_4 _qwgtf (real_4 _p_ x_, real_4 _p_ omega_, real_4 _p_ p2_, real_4 _p_ p3_, real_4 _p_ p4_, int_4 _p_ integr_)
{
  static real_4 omx_;
  real_4 qwgtf_;
  omx_ = (*omega_) * (*x_);
  switch ((*integr_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  qwgtf_ = cosf (omx_);
  goto _l30;
  _l20:;
  qwgtf_ = sinf (omx_);
  _l30:;
  __calls[71].calls++;
  return qwgtf_;
}

real_4 _qwgts (real_4 _p_ x_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ alfa_, real_4 _p_ beta_, int_4 _p_ integr_)
{
  static real_4 bmx_, xma_;
  real_4 qwgts_;
  xma_ = (*x_) - (*a_);
  bmx_ = (*b_) - (*x_);
  qwgts_ = powl (xma_, (*alfa_)) * powl (bmx_, (*beta_));
  switch ((*integr_)) {
    default:
    case 1: goto _l40;
    case 2: goto _l10;
    case 3: goto _l20;
    case 4: goto _l30;
  }
  _l10:;
  qwgts_ = qwgts_ * logf (xma_);
  goto _l40;
  _l20:;
  qwgts_ = qwgts_ * logf (bmx_);
  goto _l40;
  _l30:;
  qwgts_ = qwgts_ * logf (xma_) * logf (bmx_);
  _l40:;
  __calls[72].calls++;
  return qwgts_;
}

