//! @file mathlib-slatec-dassl.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 16 subprograms from SLATEC-DASSL

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// DDAINI DDANRM DDASSL DDATRP SDAINI SDANRM SDASSL SDASTP SDATRP SDAWTS
// DDAJAC DDASLV DDASTP DDAWTS SDAJAC SDASLV

// The license for SLATEC Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "SLATEC"
#define _dc_1 "DDASSL"
#define _dc_2 "THE LAST STEP TERMINATED WITH A NEGATIVE VALUE OF IDID = "
#define _dc_3 " AND NO APPROPRIATE ACTION WAS TAKEN.  "
#define _dc_4 "RUN TERMINATED"
#define _dc_5 "AT CURRENT T = "
#define _dc_6 " 500 STEPS TAKEN ON THIS "
#define _dc_7 "CALL BEFORE REACHING TOUT"
#define _dc_8 "AT T = "
#define _dc_9 " TOO MUCH ACCURACY REQUESTED FOR "
#define _dc_10 "PRECISION OF MACHINE. RTOL AND ATOL WERE INCREASED TO "
#define _dc_11 "APPROPRIATE VALUES"
#define _dc_12 " SOME ELEMENT OF WT HAS BECOME .LE. "
#define _dc_13 "0.0"
#define _dc_14 " AND STEPSIZE H = "
#define _dc_15 " THE ERROR TEST FAILED REPEATEDLY OR WITH ABS(H)=HMIN"
#define _dc_16 " THE CORRECTOR FAILED TO CONVERGE REPEATEDLY OR WITH "
#define _dc_17 "ABS(H)=HMIN"
#define _dc_18 " THE ITERATION MATRIX IS SINGULAR"
#define _dc_19 " THE CORRECTOR COULD NOT CONVERGE.  ALSO, THE ERROR TEST "
#define _dc_20 "FAILED REPEATEDLY."
#define _dc_21 " THE CORRECTOR COULD NOT CONVERGE BECAUSE IRES WAS EQUAL "
#define _dc_22 "TO MINUS ONE"
#define _dc_23 " IRES WAS EQUAL TO MINUS TWO"
#define _dc_24 " THE INITIAL YPRIME COULD NOT BE COMPUTED"
#define _dc_25 "SOME ELEMENT OF INFO VECTOR IS NOT ZERO OR ONE"
#define _dc_26 "NEQ = "
#define _dc_27 " .LE. 0"
#define _dc_28 "MAXORD = "
#define _dc_29 " NOT IN RANGE"
#define _dc_30 "RWORK LENGTH NEEDED, LENRW = "
#define _dc_31 ", EXCEEDS LRW = "
#define _dc_32 "IWORK LENGTH NEEDED, LENIW = "
#define _dc_33 ", EXCEEDS LIW = "
#define _dc_34 "SOME ELEMENT OF RTOL IS .LT. 0"
#define _dc_35 "SOME ELEMENT OF ATOL IS .LT. 0"
#define _dc_36 "ALL ELEMENTS OF RTOL AND ATOL ARE ZERO"
#define _dc_37 "INFO(4) = 1 AND TSTOP = "
#define _dc_38 " BEHIND TOUT = "
#define _dc_39 "HMAX = "
#define _dc_40 " .LT. 0.0"
#define _dc_41 "TOUT = "
#define _dc_42 " BEHIND T = "
#define _dc_43 "INFO(8)=1 AND H0=0.0"
#define _dc_44 "SOME ELEMENT OF WT IS .LE. 0.0"
#define _dc_45 " TOO CLOSE TO T = "
#define _dc_46 " TO START INTEGRATION"
#define _dc_47 "INFO(4)=1 AND TSTOP = "
#define _dc_48 "ML = "
#define _dc_49 " ILLEGAL.  EITHER .LT. 0 OR .GT. NEQ"
#define _dc_50 "MU = "
#define _dc_51 "TOUT = T = "
#define _dc_52 "REPEATED OCCURRENCES OF ILLEGAL INPUT$$"
#define _dc_53 "RUN TERMINATED. APPARENT INFINITE LOOP"
#define _dc_54 "SDASSL"
static FORMAT *__fmt_a = NULL;
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
typedef char char_127[128];
typedef char char_255[256];
typedef char char_511[512];
typedef char char_1023[1024];
#define __ncalls 17
static CALLS __calls[__ncalls] = {
  {"ddaini", 0}, // subroutine
  {"ddajac", 0}, // subroutine
  {"ddanrm", 0}, // real*8 function
  {"ddaslv", 0}, // subroutine
  {"ddassl", 0}, // subroutine
  {"ddastp", 0}, // subroutine
  {"ddatrp", 0}, // subroutine
  {"ddawts", 0}, // subroutine
  {"sdaini", 0}, // subroutine
  {"sdajac", 0}, // subroutine
  {"sdanrm", 0}, // real*4 function
  {"sdaslv", 0}, // subroutine
  {"sdassl", 0}, // subroutine
  {"sdastp", 0}, // subroutine
  {"sdatrp", 0}, // subroutine
  {"sdawts", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _ddaini (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ yprime_, int_4 _p_ neq_, int_4 (*_res)(), int_4 
(*_jac)(), real_8 _p_ h_, real_8 _p_ wt_, int_4 _p_ idid_, real_8 _p_ rpar_, int_4 _p_ ipar_, real_8 _p_ phi_, real_8 
_p_ delta_, real_8 _p_ e_, real_8 _p_ wm_, int_4 _p_ iwm_, real_8 _p_ hmin_, real_8 _p_ uround_, int_4 _p_ nonneg_, 
int_4 _p_ ntemp_);
prototype int_4 _ddajac (int_4 _p_ neq_, real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ yprime_, real_8 _p_ delta_, real_8 
_p_ cj_, real_8 _p_ h_, int_4 _p_ ier_, real_8 _p_ wt_, real_8 _p_ e_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), 
int_4 _p_ ires_, real_8 _p_ uround_, int_4 (*_jac)(), real_8 _p_ rpar_, int_4 _p_ ipar_, int_4 _p_ ntemp_);
prototype real_8 _ddanrm (int_4 _p_ neq_, real_8 _p_ v_, real_8 _p_ wt_, real_8 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _ddaslv (int_4 _p_ neq_, real_8 _p_ delta_, real_8 _p_ wm_, int_4 _p_ iwm_);
prototype int_4 _ddassl (real_4 (*_res)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ yprime_, real_8 _p_ 
tout_, int_4 _p_ info_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 
_p_ iwork_, int_4 _p_ liw_, real_8 _p_ rpar_, int_4 _p_ ipar_, int_4 (*_jac)());
prototype int_4 _ddastp (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ yprime_, int_4 _p_ neq_, int_4 (*_res)(), int_4 
(*_jac)(), real_8 _p_ h_, real_8 _p_ wt_, int_4 _p_ jstart_, int_4 _p_ idid_, real_8 _p_ rpar_, int_4 _p_ ipar_, real_8 
_p_ phi_, real_8 _p_ delta_, real_8 _p_ e_, real_8 _p_ wm_, int_4 _p_ iwm_, real_8 _p_ alpha_, real_8 _p_ beta_, real_8 
_p_ gamma_, real_8 _p_ psi_, real_8 _p_ sigma_, real_8 _p_ cj_, real_8 _p_ cjold_, real_8 _p_ hold_, real_8 _p_ s_, 
real_8 _p_ hmin_, real_8 _p_ uround_, int_4 _p_ iphase_, int_4 _p_ jcalc_, int_4 _p_ k_, int_4 _p_ kold_, int_4 _p_ ns_
, int_4 _p_ nonneg_, int_4 _p_ ntemp_);
prototype int_4 _ddatrp (real_8 _p_ x_, real_8 _p_ xout_, real_8 _p_ yout_, real_8 _p_ ypout_, int_4 _p_ neq_, int_4 
_p_ kold_, real_8 _p_ phi_, real_8 _p_ psi_);
prototype int_4 _ddawts (int_4 _p_ neq_, int_4 _p_ iwt_, real_8 _p_ rtol_, real_8 _p_ atol_, real_8 _p_ y_, real_8 _p_ 
wt_, real_8 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _sdaini (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ yprime_, int_4 _p_ neq_, int_4 (*_res)(), int_4 
(*_jac)(), real_4 _p_ h_, real_4 _p_ wt_, int_4 _p_ idid_, real_4 _p_ rpar_, int_4 _p_ ipar_, real_4 _p_ phi_, real_4 
_p_ delta_, real_4 _p_ e_, real_4 _p_ wm_, int_4 _p_ iwm_, real_4 _p_ hmin_, real_4 _p_ uround_, int_4 _p_ nonneg_, 
int_4 _p_ ntemp_);
prototype int_4 _sdajac (int_4 _p_ neq_, real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ yprime_, real_4 _p_ delta_, real_4 
_p_ cj_, real_4 _p_ h_, int_4 _p_ ier_, real_4 _p_ wt_, real_4 _p_ e_, real_4 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), 
int_4 _p_ ires_, real_4 _p_ uround_, int_4 (*_jac)(), real_4 _p_ rpar_, int_4 _p_ ipar_, int_4 _p_ ntemp_);
prototype real_4 _sdanrm (int_4 _p_ neq_, real_4 _p_ v_, real_4 _p_ wt_, real_4 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _sdaslv (int_4 _p_ neq_, real_4 _p_ delta_, real_4 _p_ wm_, int_4 _p_ iwm_);
prototype int_4 _sdassl (real_4 (*_res)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ yprime_, real_4 _p_ 
tout_, int_4 _p_ info_, real_4 _p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ rwork_, int_4 _p_ lrw_, int_4 
_p_ iwork_, int_4 _p_ liw_, real_4 _p_ rpar_, int_4 _p_ ipar_, int_4 (*_jac)());
prototype int_4 _sdastp (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ yprime_, int_4 _p_ neq_, int_4 (*_res)(), int_4 
(*_jac)(), real_4 _p_ h_, real_4 _p_ wt_, int_4 _p_ jstart_, int_4 _p_ idid_, real_4 _p_ rpar_, int_4 _p_ ipar_, real_4 
_p_ phi_, real_4 _p_ delta_, real_4 _p_ e_, real_4 _p_ wm_, int_4 _p_ iwm_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 
_p_ gamma_, real_4 _p_ psi_, real_4 _p_ sigma_, real_4 _p_ cj_, real_4 _p_ cjold_, real_4 _p_ hold_, real_4 _p_ s_, 
real_4 _p_ hmin_, real_4 _p_ uround_, int_4 _p_ iphase_, int_4 _p_ jcalc_, int_4 _p_ k_, int_4 _p_ kold_, int_4 _p_ ns_
, int_4 _p_ nonneg_, int_4 _p_ ntemp_);
prototype int_4 _sdatrp (real_4 _p_ x_, real_4 _p_ xout_, real_4 _p_ yout_, real_4 _p_ ypout_, int_4 _p_ neq_, int_4 
_p_ kold_, real_4 _p_ phi_, real_4 _p_ psi_);
prototype int_4 _sdawts (int_4 _p_ neq_, int_4 _p_ iwt_, real_4 _p_ rtol_, real_4 _p_ atol_, real_4 _p_ y_, real_4 _p_ 
wt_, real_4 _p_ rpar_, int_4 _p_ ipar_);
int_4 _ddaini (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ yprime_, int_4 _p_ neq_, int_4 (*_res)(), int_4 (*_jac)(), 
real_8 _p_ h_, real_8 _p_ wt_, int_4 _p_ idid_, real_8 _p_ rpar_, int_4 _p_ ipar_, real_8 _p_ phi_, real_8 _p_ delta_, 
real_8 _p_ e_, real_8 _p_ wm_, int_4 _p_ iwm_, real_8 _p_ hmin_, real_8 _p_ uround_, int_4 _p_ nonneg_, int_4 _p_ 
ntemp_)
{
  static int_4 i_, ier_, ires_, jcalc_, m_, maxit_, mjac_, ncf_, nef_, nsf_;
  static logical_4 convgd_;
  static real_8 cj_, damp_, delnrm_, err_, oldnrm_, r_, rate_, s_, xold_, ynorm_;
  int_4 _data_k_0, _data_k_1, _data_k_2;
#define _data_n_0 1
  static int_4 _data_l_0[_data_n_0] = {
    10
  };
#define _data_n_1 1
  static int_4 _data_l_1[_data_n_1] = {
    5
  };
#define _data_n_2 1
  static real_8 _data_l_2[_data_n_2] = {
    0.75e0
  };
  if (__calls[0].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    maxit_ = _data_l_0[_data_k_0++];
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    mjac_ = _data_l_1[_data_k_1++];
  }
  if (__calls[0].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    damp_ = _data_l_2[_data_k_2++];
  }
  (*idid_) = 1;
  nef_ = 0;
  ncf_ = 0;
  nsf_ = 0;
  xold_ = (*x_);
  ynorm_ = _ddanrm (neq_, y_, wt_, rpar_, ipar_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    phi_[i_ - 1 + ((*neq_)) * ((0))] = y_[i_ - 1];
    phi_[i_ - 1 + ((*neq_)) * ((1))] = yprime_[i_ - 1];
  }
  _l200:;
  cj_ = 1.0e0 / (*h_);
  (*x_) = (*x_) + (*h_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] + (*h_) * yprime_[i_ - 1];
  }
  jcalc_ = -1;
  m_ = 0;
  convgd_ = TRUE;
  _l300:;
  iwm_[11] = iwm_[11] + 1;
  ires_ = 0;
  (void) _res (x_, y_, yprime_, delta_, &ires_, rpar_, ipar_);
  if (ires_ < 0) {
    goto _l430;
  }
  if (jcalc_ != -1) {
    goto _l310;
  }
  iwm_[12] = iwm_[12] + 1;
  jcalc_ = 0;
  (void) _ddajac (neq_, x_, y_, yprime_, delta_, &cj_, h_, &ier_, wt_, e_, wm_, iwm_, _res, &ires_, uround_, _jac, rpar_, 
  ipar_, ntemp_);
  s_ = 1000000.0;
  if (ires_ < 0) {
    goto _l430;
  }
  if (ier_ != 0) {
    goto _l430;
  }
  nsf_ = 0;
  _l310:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = delta_[i_ - 1] * damp_;
  }
  (void) _ddaslv (neq_, delta_, wm_, iwm_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] - delta_[i_ - 1];
    yprime_[i_ - 1] = yprime_[i_ - 1] - cj_ * delta_[i_ - 1];
  }
  delnrm_ = _ddanrm (neq_, delta_, wt_, rpar_, ipar_);
  if (delnrm_ <= 100.0e0 * (*uround_) * ynorm_) {
    goto _l400;
  }
  if (m_ > 0) {
    goto _l340;
  }
  oldnrm_ = delnrm_;
  goto _l350;
  _l340:;
  rate_ = pow ((delnrm_ / oldnrm_), (1.0e0 / m_));
  if (rate_ > 0.9e0) {
    goto _l430;
  }
  s_ = rate_ / (1.0e0 - rate_);
  _l350:;
  if (s_ * delnrm_ <= 0.33e0) {
    goto _l400;
  }
  m_ = m_ + 1;
  if (m_ >= maxit_) {
    goto _l430;
  }
  if ((m_ / mjac_) * mjac_ == m_) {
    jcalc_ = -1;
  }
  goto _l300;
  _l400:;
  if ((*nonneg_) == 0) {
    goto _l450;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = _min (y_[i_ - 1], 0.0);
  }
  delnrm_ = _ddanrm (neq_, delta_, wt_, rpar_, ipar_);
  if (delnrm_ > 0.33e0) {
    goto _l430;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] - delta_[i_ - 1];
    yprime_[i_ - 1] = yprime_[i_ - 1] - cj_ * delta_[i_ - 1];
  }
  goto _l450;
  _l430:;
  convgd_ = FALSE;
  _l450:;
  if (! (convgd_)) {
    goto _l600;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    e_[i_ - 1] = y_[i_ - 1] - phi_[i_ - 1 + ((*neq_)) * ((0))];
  }
  err_ = _ddanrm (neq_, e_, wt_, rpar_, ipar_);
  if (err_ <= 1.0e0) {
    goto _l0;
  }
  _l600:;
  (*x_) = xold_;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((0))];
    yprime_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((1))];
  }
  if (convgd_) {
    goto _l640;
  }
  if (ier_ == 0) {
    goto _l620;
  }
  nsf_ = nsf_ + 1;
  (*h_) = (*h_) * 0.25e0;
  if (nsf_ < 3 && _abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -12;
  goto _l0;
  _l620:;
  if (ires_ > -2) {
    goto _l630;
  }
  (*idid_) = -12;
  goto _l0;
  _l630:;
  ncf_ = ncf_ + 1;
  (*h_) = (*h_) * 0.25e0;
  if (ncf_ < 10 && _abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -12;
  goto _l0;
  _l640:;
  nef_ = nef_ + 1;
  r_ = 0.9e0 / (2.0e0 * err_ + 0.0001e0);
  r_ = _max (0.1, _min (0.5, r_));
  (*h_) = (*h_) * r_;
  if (_abs ((*h_)) >= (*hmin_) && nef_ < 10) {
    goto _l690;
  }
  (*idid_) = -12;
  goto _l0;
  _l690:;
  goto _l200;
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _ddajac (int_4 _p_ neq_, real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ yprime_, real_8 _p_ delta_, real_8 _p_ cj_, 
real_8 _p_ h_, int_4 _p_ ier_, real_8 _p_ wt_, real_8 _p_ e_, real_8 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), int_4 
_p_ ires_, real_8 _p_ uround_, int_4 (*_jac)(), real_8 _p_ rpar_, int_4 _p_ ipar_, int_4 _p_ ntemp_)
{
  static int_4 i_, i1_, i2_, ii_, ipsave_, isave_, j_, k_, l_, lenpd_, mba_, mband_, meb1_, meband_, msave_, mtype_, n_, 
  npdm1_, nrow_;
  static real_8 del_, delinv_, squr_, ypsave_, ysave_;
  real_8 $0_, $1_, $2_;
  extern int_4 _dgbfa ();
  extern int_4 _dgefa ();
  (*ier_) = 0;
  npdm1_ = 0;
  mtype_ = iwm_[3];
  switch (mtype_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l500;
  }
  _l100:;
  lenpd_ = (*neq_) * (*neq_);
  for (i_ = 1; i_ <= lenpd_; (i_)++) {
    wm_[npdm1_ + i_ - 1] = 0.0;
  }
  (void) _jac (x_, y_, yprime_, &wm_[0], cj_, rpar_, ipar_);
  goto _l230;
  _l200:;
  (*ires_) = 0;
  nrow_ = npdm1_;
  squr_ = sqrt ((*uround_));
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    del_ = squr_ * ($0_ = _max (_abs (y_[i_ - 1]), _abs ((*h_) * yprime_[i_ - 1])), _max ($0_, _abs (wt_[i_ - 1])));
    del_ = _sign (del_, (*h_) * yprime_[i_ - 1]);
    del_ = (y_[i_ - 1] + del_) - y_[i_ - 1];
    ysave_ = y_[i_ - 1];
    ypsave_ = yprime_[i_ - 1];
    y_[i_ - 1] = y_[i_ - 1] + del_;
    yprime_[i_ - 1] = yprime_[i_ - 1] + (*cj_) * del_;
    (void) _res (x_, y_, yprime_, e_, ires_, rpar_, ipar_);
    if ((*ires_) < 0) {
      goto _l0;
    }
    delinv_ = 1.0e0 / del_;
    for (l_ = 1; l_ <= (*neq_); (l_)++) {
      wm_[nrow_ + l_ - 1] = (e_[l_ - 1] - delta_[l_ - 1]) * delinv_;
    }
    nrow_ = nrow_ + (*neq_);
    y_[i_ - 1] = ysave_;
    yprime_[i_ - 1] = ypsave_;
  }
  _l230:;
  (void) _dgefa (&wm_[0], neq_, neq_, &iwm_[20], ier_);
  goto _l0;
  _l300:;
  goto _l0;
  _l400:;
  lenpd_ = (2 * iwm_[0] + iwm_[1] + 1) * (*neq_);
  for (i_ = 1; i_ <= lenpd_; (i_)++) {
    wm_[npdm1_ + i_ - 1] = 0.0;
  }
  (void) _jac (x_, y_, yprime_, &wm_[0], cj_, rpar_, ipar_);
  meband_ = 2 * iwm_[0] + iwm_[1] + 1;
  goto _l550;
  _l500:;
  mband_ = iwm_[0] + iwm_[1] + 1;
  mba_ = _min (mband_, (*neq_));
  meband_ = mband_ + iwm_[0];
  meb1_ = meband_ - 1;
  msave_ = ((*neq_) / mband_) + 1;
  isave_ = (*ntemp_) - 1;
  ipsave_ = isave_ + msave_;
  (*ires_) = 0;
  squr_ = sqrt ((*uround_));
  for (j_ = 1; j_ <= mba_; (j_)++) {
    for (n_ = j_; (mband_ > 0 ? n_ <= (*neq_) : n_ >= (*neq_)); n_ += mband_) {
      k_ = (n_ - j_) / mband_ + 1;
      wm_[isave_ + k_ - 1] = y_[n_ - 1];
      wm_[ipsave_ + k_ - 1] = yprime_[n_ - 1];
      del_ = squr_ * ($1_ = _max (_abs (y_[n_ - 1]), _abs ((*h_) * yprime_[n_ - 1])), _max ($1_, _abs (wt_[n_ - 1])));
      del_ = _sign (del_, (*h_) * yprime_[n_ - 1]);
      del_ = (y_[n_ - 1] + del_) - y_[n_ - 1];
      y_[n_ - 1] = y_[n_ - 1] + del_;
      yprime_[n_ - 1] = yprime_[n_ - 1] + (*cj_) * del_;
    }
    (void) _res (x_, y_, yprime_, e_, ires_, rpar_, ipar_);
    if ((*ires_) < 0) {
      goto _l0;
    }
    for (n_ = j_; (mband_ > 0 ? n_ <= (*neq_) : n_ >= (*neq_)); n_ += mband_) {
      k_ = (n_ - j_) / mband_ + 1;
      y_[n_ - 1] = wm_[isave_ + k_ - 1];
      yprime_[n_ - 1] = wm_[ipsave_ + k_ - 1];
      del_ = squr_ * ($2_ = _max (_abs (y_[n_ - 1]), _abs ((*h_) * yprime_[n_ - 1])), _max ($2_, _abs (wt_[n_ - 1])));
      del_ = _sign (del_, (*h_) * yprime_[n_ - 1]);
      del_ = (y_[n_ - 1] + del_) - y_[n_ - 1];
      delinv_ = 1.0e0 / del_;
      i1_ = _max (1, (n_ - iwm_[1]));
      i2_ = _min ((*neq_), (n_ + iwm_[0]));
      ii_ = n_ * meb1_ - iwm_[0] + npdm1_;
      for (i_ = i1_; i_ <= i2_; (i_)++) {
        wm_[ii_ + i_ - 1] = (e_[i_ - 1] - delta_[i_ - 1]) * delinv_;
      }
    }
  }
  _l550:;
  (void) _dgbfa (&wm_[0], &meband_, neq_, &iwm_[0], &iwm_[1], &iwm_[20], ier_);
  _l0:;
  __calls[1].calls++;
  return 0;
}

real_8 _ddanrm (int_4 _p_ neq_, real_8 _p_ v_, real_8 _p_ wt_, real_8 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 i_;
  static real_8 sum_, vmax_;
  real_8 $0_;
  real_8 ddanrm_;
  ddanrm_ = 0.0;
  vmax_ = 0.0;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if (_abs (v_[i_ - 1] / wt_[i_ - 1]) > vmax_) {
      vmax_ = _abs (v_[i_ - 1] / wt_[i_ - 1]);
    }
  }
  if (vmax_ <= 0.0e0) {
    goto _l30;
  }
  sum_ = 0.0;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    sum_ = sum_ + ($0_ = ((v_[i_ - 1] / wt_[i_ - 1]) / vmax_), $0_ * $0_);
  }
  ddanrm_ = vmax_ * sqrt (sum_ / (*neq_));
  _l30:;
  __calls[2].calls++;
  return ddanrm_;
}

int_4 _ddaslv (int_4 _p_ neq_, real_8 _p_ delta_, real_8 _p_ wm_, int_4 _p_ iwm_)
{
  static int_4 meband_, mtype_;
  extern int_4 _dgbsl ();
  extern int_4 _dgesl ();
  mtype_ = iwm_[3];
  switch (mtype_) {
    default:
    case 1: goto _l100;
    case 2: goto _l100;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l400;
  }
  _l100:;
  (void) _dgesl (&wm_[0], neq_, neq_, &iwm_[20], delta_, &_k0);
  goto _l0;
  _l300:;
  goto _l0;
  _l400:;
  meband_ = 2 * iwm_[0] + iwm_[1] + 1;
  (void) _dgbsl (&wm_[0], &meband_, neq_, &iwm_[0], &iwm_[1], &iwm_[20], delta_, &_k0);
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _ddassl (real_4 (*_res)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ yprime_, real_8 _p_ tout_, 
int_4 _p_ info_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ 
iwork_, int_4 _p_ liw_, real_8 _p_ rpar_, int_4 _p_ ipar_, int_4 (*_jac)())
{
  static int_4 i_, itemp_, leniw_, lenpd_, lenrw_, le_, lpd_, lphi_, lwm_, lwt_, mband_, msave_, mxord_, ntemp_, nzflg_;
  static logical_4 done_;
  static real_8 atoli_, h_, hmax_, hmin_, ho_, r_, rh_, rtoli_, tdist_, tn_, tnext_, tstop_, uround_, ypnorm_;
  static char_15 xern1_, xern2_;
  static char_31 xern3_, xern4_;
  int_4 __fcnt, __rc, $4_, $5_, $6_, $61_, $65_, $70_, $75_, $76_, $77_, $78_, $83_, $87_, $92_, $93_, $94_, $100_, $105_
  , $109_, $113_, $116_, $118_, $119_;
  char_31 $58_, $62_, $106_, $110_;
  char_63 $7_, $11_, $16_, $20_, $25_, $31_, $36_, $42_, $48_, $53_, $59_, $60_, $63_, $64_, $66_, $71_, $79_, $84_, $88_
  , $95_, $101_, $114_, $115_;
  char_127 $0_, $8_, $12_, $17_, $21_, $26_, $32_, $37_, $43_, $49_, $54_, $67_, $72_, $80_, $85_, $86_, $89_, $96_, 
  $102_, $107_, $108_, $111_, $112_, $117_;
  char_255 $1_, $9_, $10_, $13_, $18_, $19_, $22_, $27_, $33_, $38_, $44_, $50_, $55_, $68_, $69_, $73_, $74_, $81_, $82_
  , $90_, $91_, $97_, $103_, $104_;
  char_511 $2_, $3_, $14_, $15_, $23_, $24_, $28_, $34_, $35_, $39_, $45_, $51_, $52_, $56_, $57_, $98_, $99_;
  char_1023 $29_, $30_, $40_, $41_, $46_, $47_;
  extern real_8 _d1mach ();
  extern int_4 _xermsg ();
  static FORMAT $f_100062_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100276_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100279_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100282_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100285_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100286_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100289_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100290_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100293_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100294_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100297_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100298_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100301_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100302_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100305_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100306_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100309_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100310_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100321_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100324_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100327_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100328_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100331_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100332_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100341_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100342_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100345_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100348_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100349_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100356_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100357_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100360_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100361_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100364_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100367_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100370_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  if (info_[0] != 0) {
    goto _l100;
  }
  for (i_ = 2; i_ <= 11; (i_)++) {
    if (info_[i_ - 1] != 0 && info_[i_ - 1] != 1) {
      goto _l701;
    }
  }
  if ((*neq_) <= 0) {
    goto _l702;
  }
  mxord_ = 5;
  if (info_[8] == 0) {
    goto _l20;
  }
  mxord_ = iwork_[2];
  if (mxord_ < 1 || mxord_ > 5) {
    goto _l703;
  }
  _l20:;
  iwork_[2] = mxord_;
  if (info_[5] != 0) {
    goto _l40;
  }
  lenpd_ = ((*neq_) * (*neq_));
  lenrw_ = 40 + (iwork_[2] + 4) * (*neq_) + lenpd_;
  if (info_[4] != 0) {
    goto _l30;
  }
  iwork_[3] = 2;
  goto _l60;
  _l30:;
  iwork_[3] = 1;
  goto _l60;
  _l40:;
  if (iwork_[0] < 0 || iwork_[0] >= (*neq_)) {
    goto _l717;
  }
  if (iwork_[1] < 0 || iwork_[1] >= (*neq_)) {
    goto _l718;
  }
  lenpd_ = (2 * iwork_[0] + iwork_[1] + 1) * (*neq_);
  if (info_[4] != 0) {
    goto _l50;
  }
  iwork_[3] = 5;
  mband_ = iwork_[0] + iwork_[1] + 1;
  msave_ = ((*neq_) / mband_) + 1;
  lenrw_ = 40 + (iwork_[2] + 4) * (*neq_) + lenpd_ + 2 * msave_;
  goto _l60;
  _l50:;
  iwork_[3] = 4;
  lenrw_ = 40 + (iwork_[2] + 4) * (*neq_) + lenpd_;
  _l60:;
  leniw_ = 20 + (*neq_);
  iwork_[15] = lenpd_;
  if ((*lrw_) < lenrw_) {
    goto _l704;
  }
  if ((*liw_) < leniw_) {
    goto _l705;
  }
  if ((*tout_) == (*t_)) {
    goto _l719;
  }
  if (info_[6] == 0) {
    goto _l70;
  }
  hmax_ = rwork_[1];
  if (hmax_ <= 0.0e0) {
    goto _l710;
  }
  _l70:;
  iwork_[10] = 0;
  iwork_[11] = 0;
  iwork_[12] = 0;
  iwork_[9] = 0;
  (*idid_) = 1;
  goto _l200;
  _l100:;
  if (info_[0] == 1) {
    goto _l110;
  }
  if (info_[0] != -1) {
    goto _l701;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1057", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1057", 0));
    __fcnt += 3;
  }
  if ($f_100062_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1057", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100062_[__fcnt + 2], &(*idid_), INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1057", 0));
  __fcnt += 3;
  while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
    if ($f_100062_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1057", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_2, xern1_), _dc_3), _dc_4), 
  511), $3_), ($4_ = -998, &$4_), ($5_ = 2, &$5_));
  goto _l0;
  _l110:;
  iwork_[9] = iwork_[10];
  _l200:;
  nzflg_ = 0;
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if (info_[1] == 1) {
      rtoli_ = rtol_[i_ - 1];
    }
    if (info_[1] == 1) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ > 0.0e0 || atoli_ > 0.0e0) {
      nzflg_ = 1;
    }
    if (rtoli_ < 0.0e0) {
      goto _l706;
    }
    if (atoli_ < 0.0e0) {
      goto _l707;
    }
  }
  if (nzflg_ == 0) {
    goto _l708;
  }
  le_ = 41 + (*neq_);
  lwt_ = le_ + (*neq_);
  lphi_ = lwt_ + (*neq_);
  lpd_ = lphi_ + (iwork_[2] + 1) * (*neq_);
  lwm_ = lpd_;
  ntemp_ = 1 + iwork_[15];
  if (info_[0] == 1) {
    goto _l400;
  }
  tn_ = (*t_);
  (*idid_) = 1;
  (void) _ddawts (neq_, &info_[1], rtol_, atol_, y_, &rwork_[lwt_ - 1], rpar_, ipar_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if (rwork_[lwt_ + i_ - 1 - 1] <= 0.0e0) {
      goto _l713;
    }
  }
  uround_ = _d1mach (($6_ = 4, &$6_));
  rwork_[8] = uround_;
  hmin_ = 4.0e0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)));
  tdist_ = _abs ((*tout_) - (*t_));
  if (tdist_ < hmin_) {
    goto _l714;
  }
  if (info_[7] == 0) {
    goto _l310;
  }
  ho_ = rwork_[2];
  if (((*tout_) - (*t_)) * ho_ < 0.0e0) {
    goto _l711;
  }
  if (ho_ == 0.0e0) {
    goto _l712;
  }
  goto _l320;
  _l310:;
  ho_ = 0.001e0 * tdist_;
  ypnorm_ = _ddanrm (neq_, yprime_, &rwork_[lwt_ - 1], rpar_, ipar_);
  if (ypnorm_ > 0.5e0 / ho_) {
    ho_ = 0.5e0 / ypnorm_;
  }
  ho_ = _sign (ho_, (*tout_) - (*t_));
  _l320:;
  if (info_[6] == 0) {
    goto _l330;
  }
  rh_ = _abs (ho_) / rwork_[1];
  if (rh_ > 1.0e0) {
    ho_ = ho_ / rh_;
  }
  _l330:;
  if (info_[3] == 0) {
    goto _l340;
  }
  tstop_ = rwork_[0];
  if ((tstop_ - (*t_)) * ho_ < 0.0e0) {
    goto _l715;
  }
  if (((*t_) + ho_ - tstop_) * ho_ > 0.0e0) {
    ho_ = tstop_ - (*t_);
  }
  if ((tstop_ - (*tout_)) * ho_ < 0.0e0) {
    goto _l709;
  }
  _l340:;
  if (info_[10] == 0) {
    goto _l350;
  }
  (void) _ddaini (&tn_, y_, yprime_, neq_, _res, _jac, &ho_, &rwork_[lwt_ - 1], idid_, rpar_, ipar_, &rwork_[lphi_ - 1], 
  &rwork_[40], &rwork_[le_ - 1], &rwork_[lwm_ - 1], &iwork_[0], &hmin_, &rwork_[8], &info_[9], &ntemp_);
  if ((*idid_) < 0) {
    goto _l390;
  }
  _l350:;
  h_ = ho_;
  rwork_[2] = h_;
  itemp_ = lphi_ + (*neq_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    rwork_[lphi_ + i_ - 1 - 1] = y_[i_ - 1];
    rwork_[itemp_ + i_ - 1 - 1] = h_ * yprime_[i_ - 1];
  }
  _l390:;
  goto _l500;
  _l400:;
  uround_ = rwork_[8];
  done_ = FALSE;
  tn_ = rwork_[3];
  h_ = rwork_[2];
  if (info_[6] == 0) {
    goto _l410;
  }
  rh_ = _abs (h_) / rwork_[1];
  if (rh_ > 1.0e0) {
    h_ = h_ / rh_;
  }
  _l410:;
  if ((*t_) == (*tout_)) {
    goto _l719;
  }
  if (((*t_) - (*tout_)) * h_ > 0.0e0) {
    goto _l711;
  }
  if (info_[3] == 1) {
    goto _l430;
  }
  if (info_[2] == 1) {
    goto _l420;
  }
  if ((tn_ - (*tout_)) * h_ < 0.0e0) {
    goto _l490;
  }
  (void) _ddatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  done_ = TRUE;
  goto _l490;
  _l420:;
  if ((tn_ - (*t_)) * h_ <= 0.0e0) {
    goto _l490;
  }
  if ((tn_ - (*tout_)) * h_ > 0.0e0) {
    goto _l425;
  }
  (void) _ddatrp (&tn_, &tn_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = tn_;
  (*idid_) = 1;
  done_ = TRUE;
  goto _l490;
  _l425:;
  (void) _ddatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  done_ = TRUE;
  goto _l490;
  _l430:;
  if (info_[2] == 1) {
    goto _l440;
  }
  tstop_ = rwork_[0];
  if ((tn_ - tstop_) * h_ > 0.0e0) {
    goto _l715;
  }
  if ((tstop_ - (*tout_)) * h_ < 0.0e0) {
    goto _l709;
  }
  if ((tn_ - (*tout_)) * h_ < 0.0e0) {
    goto _l450;
  }
  (void) _ddatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  done_ = TRUE;
  goto _l490;
  _l440:;
  tstop_ = rwork_[0];
  if ((tn_ - tstop_) * h_ > 0.0e0) {
    goto _l715;
  }
  if ((tstop_ - (*tout_)) * h_ < 0.0e0) {
    goto _l709;
  }
  if ((tn_ - (*t_)) * h_ <= 0.0e0) {
    goto _l450;
  }
  if ((tn_ - (*tout_)) * h_ > 0.0e0) {
    goto _l445;
  }
  (void) _ddatrp (&tn_, &tn_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = tn_;
  (*idid_) = 1;
  done_ = TRUE;
  goto _l490;
  _l445:;
  (void) _ddatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  done_ = TRUE;
  goto _l490;
  _l450:;
  if (_abs (tn_ - tstop_) > 100.0e0 * uround_ * (_abs (tn_) + _abs (h_))) {
    goto _l460;
  }
  (void) _ddatrp (&tn_, &tstop_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 2;
  (*t_) = tstop_;
  done_ = TRUE;
  goto _l490;
  _l460:;
  tnext_ = tn_ + h_;
  if ((tnext_ - tstop_) * h_ <= 0.0e0) {
    goto _l490;
  }
  h_ = tstop_ - tn_;
  rwork_[2] = h_;
  _l490:;
  if (done_) {
    goto _l580;
  }
  _l500:;
  if ((*idid_) == -12) {
    goto _l527;
  }
  if ((iwork_[10] - iwork_[9]) < 500) {
    goto _l510;
  }
  (*idid_) = -1;
  goto _l527;
  _l510:;
  (void) _ddawts (neq_, &info_[1], rtol_, atol_, &rwork_[lphi_ - 1], &rwork_[lwt_ - 1], rpar_, ipar_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if (rwork_[i_ + lwt_ - 1 - 1] > 0.0e0) {
      goto _l520;
    }
    (*idid_) = -3;
    goto _l527;
    _l520:;
  }
  r_ = _ddanrm (neq_, &rwork_[lphi_ - 1], &rwork_[lwt_ - 1], rpar_, ipar_) * 100.0e0 * uround_;
  if (r_ <= 1.0e0) {
    goto _l525;
  }
  if (info_[1] == 1) {
    goto _l523;
  }
  rtol_[0] = r_ * rtol_[0];
  atol_[0] = r_ * atol_[0];
  (*idid_) = -2;
  goto _l527;
  _l523:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    rtol_[i_ - 1] = r_ * rtol_[i_ - 1];
    atol_[i_ - 1] = r_ * atol_[i_ - 1];
  }
  (*idid_) = -2;
  goto _l527;
  _l525:;
  hmin_ = 4.0e0 * uround_ * _max (_abs (tn_), _abs ((*tout_)));
  if (info_[6] != 0) {
    rh_ = _abs (h_) / rwork_[1];
    if (rh_ > 1.0e0) {
      h_ = h_ / rh_;
    }
  }
  (void) _ddastp (&tn_, y_, yprime_, neq_, _res, _jac, &h_, &rwork_[lwt_ - 1], &info_[0], idid_, rpar_, ipar_, 
  &rwork_[lphi_ - 1], &rwork_[40], &rwork_[le_ - 1], &rwork_[lwm_ - 1], &iwork_[0], &rwork_[10], &rwork_[16], 
  &rwork_[22], &rwork_[28], &rwork_[34], &rwork_[4], &rwork_[5], &rwork_[6], &rwork_[7], &hmin_, &rwork_[8], &iwork_[5], 
  &iwork_[4], &iwork_[6], &iwork_[7], &iwork_[8], &info_[9], &ntemp_);
  _l527:;
  if ((*idid_) < 0) {
    goto _l600;
  }
  if (info_[3] != 0) {
    goto _l540;
  }
  if (info_[2] != 0) {
    goto _l530;
  }
  if ((tn_ - (*tout_)) * h_ < 0.0e0) {
    goto _l500;
  }
  (void) _ddatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 3;
  (*t_) = (*tout_);
  goto _l580;
  _l530:;
  if ((tn_ - (*tout_)) * h_ >= 0.0e0) {
    goto _l535;
  }
  (*t_) = tn_;
  (*idid_) = 1;
  goto _l580;
  _l535:;
  (void) _ddatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 3;
  (*t_) = (*tout_);
  goto _l580;
  _l540:;
  if (info_[2] != 0) {
    goto _l550;
  }
  if ((tn_ - (*tout_)) * h_ < 0.0e0) {
    goto _l542;
  }
  (void) _ddatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  goto _l580;
  _l542:;
  if (_abs (tn_ - tstop_) <= 100.0e0 * uround_ * (_abs (tn_) + _abs (h_))) {
    goto _l545;
  }
  tnext_ = tn_ + h_;
  if ((tnext_ - tstop_) * h_ <= 0.0e0) {
    goto _l500;
  }
  h_ = tstop_ - tn_;
  goto _l500;
  _l545:;
  (void) _ddatrp (&tn_, &tstop_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 2;
  (*t_) = tstop_;
  goto _l580;
  _l550:;
  if ((tn_ - (*tout_)) * h_ >= 0.0e0) {
    goto _l555;
  }
  if (_abs (tn_ - tstop_) <= 100.0e0 * uround_ * (_abs (tn_) + _abs (h_))) {
    goto _l552;
  }
  (*t_) = tn_;
  (*idid_) = 1;
  goto _l580;
  _l552:;
  (void) _ddatrp (&tn_, &tstop_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 2;
  (*t_) = tstop_;
  goto _l580;
  _l555:;
  (void) _ddatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  goto _l580;
  _l580:;
  rwork_[3] = tn_;
  rwork_[2] = h_;
  goto _l0;
  _l600:;
  itemp_ = -(*idid_);
  switch (itemp_) {
    default:
    case 1: goto _l610;
    case 2: goto _l620;
    case 3: goto _l630;
    case 4: goto _l690;
    case 5: goto _l690;
    case 6: goto _l640;
    case 7: goto _l650;
    case 8: goto _l660;
    case 9: goto _l670;
    case 10: goto _l675;
    case 11: goto _l680;
    case 12: goto _l685;
  }
  _l610:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1401", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100276_[__fcnt] != NULL && $f_100276_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100276_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1401", 0));
    __fcnt += 3;
  }
  if ($f_100276_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100276_[__fcnt] != NULL && $f_100276_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100276_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1401", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100276_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1401", 0));
  __fcnt += 3;
  while ($f_100276_[__fcnt] != NULL && $f_100276_[__fcnt] == FMT_TEXT) {
    if ($f_100276_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100276_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1401", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($10_, concat ($9_, concat ($8_, concat ($7_, _dc_5, xern3_), _dc_6), _dc_7), 
  255), $10_), idid_, &_k1);
  goto _l690;
  _l620:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1408", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100279_[__fcnt] != NULL && $f_100279_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100279_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1408", 0));
    __fcnt += 3;
  }
  if ($f_100279_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100279_[__fcnt] != NULL && $f_100279_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100279_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1408", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100279_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1408", 0));
  __fcnt += 3;
  while ($f_100279_[__fcnt] != NULL && $f_100279_[__fcnt] == FMT_TEXT) {
    if ($f_100279_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100279_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1408", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($15_, concat ($14_, concat ($13_, concat ($12_, concat ($11_, _dc_8, xern3_), 
  _dc_9), _dc_10), _dc_11), 511), $15_), idid_, &_k1);
  goto _l690;
  _l630:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1416", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100282_[__fcnt] != NULL && $f_100282_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100282_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1416", 0));
    __fcnt += 3;
  }
  if ($f_100282_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100282_[__fcnt] != NULL && $f_100282_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100282_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1416", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100282_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1416", 0));
  __fcnt += 3;
  while ($f_100282_[__fcnt] != NULL && $f_100282_[__fcnt] == FMT_TEXT) {
    if ($f_100282_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100282_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1416", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($19_, concat ($18_, concat ($17_, concat ($16_, _dc_8, xern3_), _dc_12), 
  _dc_13), 255), $19_), idid_, &_k1);
  goto _l690;
  _l640:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1423", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100285_[__fcnt] != NULL && $f_100285_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100285_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1423", 0));
    __fcnt += 3;
  }
  if ($f_100285_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100285_[__fcnt] != NULL && $f_100285_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100285_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1423", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100285_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1423", 0));
  __fcnt += 3;
  while ($f_100285_[__fcnt] != NULL && $f_100285_[__fcnt] == FMT_TEXT) {
    if ($f_100285_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100285_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1423", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1424", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100286_[__fcnt] != NULL && $f_100286_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100286_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1424", 0));
    __fcnt += 3;
  }
  if ($f_100286_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100286_[__fcnt] != NULL && $f_100286_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100286_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1424", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100286_[__fcnt + 2], &h_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1424", 0));
  __fcnt += 3;
  while ($f_100286_[__fcnt] != NULL && $f_100286_[__fcnt] == FMT_TEXT) {
    if ($f_100286_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100286_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1424", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($24_, concat ($23_, concat ($22_, concat ($21_, concat ($20_, _dc_8, xern3_), 
  _dc_14), xern4_), _dc_15), 511), $24_), idid_, &_k1);
  goto _l690;
  _l650:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1432", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100289_[__fcnt] != NULL && $f_100289_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100289_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1432", 0));
    __fcnt += 3;
  }
  if ($f_100289_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100289_[__fcnt] != NULL && $f_100289_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100289_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1432", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100289_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1432", 0));
  __fcnt += 3;
  while ($f_100289_[__fcnt] != NULL && $f_100289_[__fcnt] == FMT_TEXT) {
    if ($f_100289_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100289_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1432", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1433", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100290_[__fcnt] != NULL && $f_100290_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100290_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1433", 0));
    __fcnt += 3;
  }
  if ($f_100290_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100290_[__fcnt] != NULL && $f_100290_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100290_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1433", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100290_[__fcnt + 2], &h_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1433", 0));
  __fcnt += 3;
  while ($f_100290_[__fcnt] != NULL && $f_100290_[__fcnt] == FMT_TEXT) {
    if ($f_100290_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100290_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1433", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($30_, concat ($29_, concat ($28_, concat ($27_, concat ($26_, concat ($25_, 
  _dc_8, xern3_), _dc_14), xern4_), _dc_16), _dc_17), 1023), $30_), idid_, &_k1);
  goto _l690;
  _l660:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1441", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100293_[__fcnt] != NULL && $f_100293_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100293_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1441", 0));
    __fcnt += 3;
  }
  if ($f_100293_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100293_[__fcnt] != NULL && $f_100293_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100293_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1441", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100293_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1441", 0));
  __fcnt += 3;
  while ($f_100293_[__fcnt] != NULL && $f_100293_[__fcnt] == FMT_TEXT) {
    if ($f_100293_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100293_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1441", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1442", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100294_[__fcnt] != NULL && $f_100294_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100294_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1442", 0));
    __fcnt += 3;
  }
  if ($f_100294_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100294_[__fcnt] != NULL && $f_100294_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100294_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1442", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100294_[__fcnt + 2], &h_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1442", 0));
  __fcnt += 3;
  while ($f_100294_[__fcnt] != NULL && $f_100294_[__fcnt] == FMT_TEXT) {
    if ($f_100294_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100294_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1442", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($35_, concat ($34_, concat ($33_, concat ($32_, concat ($31_, _dc_8, xern3_), 
  _dc_14), xern4_), _dc_18), 511), $35_), idid_, &_k1);
  goto _l690;
  _l670:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1449", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100297_[__fcnt] != NULL && $f_100297_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100297_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1449", 0));
    __fcnt += 3;
  }
  if ($f_100297_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100297_[__fcnt] != NULL && $f_100297_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100297_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1449", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100297_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1449", 0));
  __fcnt += 3;
  while ($f_100297_[__fcnt] != NULL && $f_100297_[__fcnt] == FMT_TEXT) {
    if ($f_100297_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100297_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1449", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1450", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100298_[__fcnt] != NULL && $f_100298_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100298_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1450", 0));
    __fcnt += 3;
  }
  if ($f_100298_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100298_[__fcnt] != NULL && $f_100298_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100298_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1450", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100298_[__fcnt + 2], &h_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1450", 0));
  __fcnt += 3;
  while ($f_100298_[__fcnt] != NULL && $f_100298_[__fcnt] == FMT_TEXT) {
    if ($f_100298_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100298_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1450", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($41_, concat ($40_, concat ($39_, concat ($38_, concat ($37_, concat ($36_, 
  _dc_8, xern3_), _dc_14), xern4_), _dc_19), _dc_20), 1023), $41_), idid_, &_k1);
  goto _l690;
  _l675:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1458", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100301_[__fcnt] != NULL && $f_100301_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100301_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1458", 0));
    __fcnt += 3;
  }
  if ($f_100301_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100301_[__fcnt] != NULL && $f_100301_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100301_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1458", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100301_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1458", 0));
  __fcnt += 3;
  while ($f_100301_[__fcnt] != NULL && $f_100301_[__fcnt] == FMT_TEXT) {
    if ($f_100301_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100301_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1458", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1459", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100302_[__fcnt] != NULL && $f_100302_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100302_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1459", 0));
    __fcnt += 3;
  }
  if ($f_100302_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100302_[__fcnt] != NULL && $f_100302_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100302_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1459", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100302_[__fcnt + 2], &h_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1459", 0));
  __fcnt += 3;
  while ($f_100302_[__fcnt] != NULL && $f_100302_[__fcnt] == FMT_TEXT) {
    if ($f_100302_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100302_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1459", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($47_, concat ($46_, concat ($45_, concat ($44_, concat ($43_, concat ($42_, 
  _dc_8, xern3_), _dc_14), xern4_), _dc_21), _dc_22), 1023), $47_), idid_, &_k1);
  goto _l690;
  _l680:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1467", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100305_[__fcnt] != NULL && $f_100305_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100305_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1467", 0));
    __fcnt += 3;
  }
  if ($f_100305_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100305_[__fcnt] != NULL && $f_100305_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100305_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1467", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100305_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1467", 0));
  __fcnt += 3;
  while ($f_100305_[__fcnt] != NULL && $f_100305_[__fcnt] == FMT_TEXT) {
    if ($f_100305_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100305_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1467", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1468", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1468", 0));
    __fcnt += 3;
  }
  if ($f_100306_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1468", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100306_[__fcnt + 2], &h_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1468", 0));
  __fcnt += 3;
  while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
    if ($f_100306_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1468", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($52_, concat ($51_, concat ($50_, concat ($49_, concat ($48_, _dc_8, xern3_), 
  _dc_14), xern4_), _dc_23), 511), $52_), idid_, &_k1);
  goto _l690;
  _l685:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1475", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100309_[__fcnt] != NULL && $f_100309_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100309_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1475", 0));
    __fcnt += 3;
  }
  if ($f_100309_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100309_[__fcnt] != NULL && $f_100309_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100309_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1475", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100309_[__fcnt + 2], &tn_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1475", 0));
  __fcnt += 3;
  while ($f_100309_[__fcnt] != NULL && $f_100309_[__fcnt] == FMT_TEXT) {
    if ($f_100309_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100309_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1475", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1476", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100310_[__fcnt] != NULL && $f_100310_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100310_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1476", 0));
    __fcnt += 3;
  }
  if ($f_100310_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100310_[__fcnt] != NULL && $f_100310_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100310_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1476", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100310_[__fcnt + 2], &ho_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1476", 0));
  __fcnt += 3;
  while ($f_100310_[__fcnt] != NULL && $f_100310_[__fcnt] == FMT_TEXT) {
    if ($f_100310_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100310_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1476", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($57_, concat ($56_, concat ($55_, concat ($54_, concat ($53_, _dc_8, xern3_), 
  _dc_14), xern4_), _dc_24), 511), $57_), idid_, &_k1);
  goto _l690;
  _l690:;
  info_[0] = -1;
  (*t_) = tn_;
  rwork_[3] = tn_;
  rwork_[2] = h_;
  goto _l0;
  _l701:;
  (void) _xermsg (_dc_0, _dc_1, _dc_25, &_k1, &_k1);
  goto _l750;
  _l702:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1501", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100321_[__fcnt] != NULL && $f_100321_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100321_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1501", 0));
    __fcnt += 3;
  }
  if ($f_100321_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100321_[__fcnt] != NULL && $f_100321_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100321_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1501", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100321_[__fcnt + 2], &(*neq_), INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1501", 0));
  __fcnt += 3;
  while ($f_100321_[__fcnt] != NULL && $f_100321_[__fcnt] == FMT_TEXT) {
    if ($f_100321_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100321_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1501", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($60_, concat ($59_, concat ($58_, _dc_26, xern1_), _dc_27), 63), $60_), ($61_ = 
  2, &$61_), &_k1);
  goto _l750;
  _l703:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1506", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100324_[__fcnt] != NULL && $f_100324_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100324_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1506", 0));
    __fcnt += 3;
  }
  if ($f_100324_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100324_[__fcnt] != NULL && $f_100324_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100324_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1506", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100324_[__fcnt + 2], &mxord_, INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1506", 0));
  __fcnt += 3;
  while ($f_100324_[__fcnt] != NULL && $f_100324_[__fcnt] == FMT_TEXT) {
    if ($f_100324_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100324_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1506", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($64_, concat ($63_, concat ($62_, _dc_28, xern1_), _dc_29), 63), $64_), ($65_ = 
  3, &$65_), &_k1);
  goto _l750;
  _l704:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1511", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1511", 0));
    __fcnt += 3;
  }
  if ($f_100327_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1511", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100327_[__fcnt + 2], &lenrw_, INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1511", 0));
  __fcnt += 3;
  while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
    if ($f_100327_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1511", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern2_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1512", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100328_[__fcnt] != NULL && $f_100328_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100328_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1512", 0));
    __fcnt += 3;
  }
  if ($f_100328_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100328_[__fcnt] != NULL && $f_100328_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100328_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1512", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100328_[__fcnt + 2], &(*lrw_), INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1512", 0));
  __fcnt += 3;
  while ($f_100328_[__fcnt] != NULL && $f_100328_[__fcnt] == FMT_TEXT) {
    if ($f_100328_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100328_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1512", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($69_, concat ($68_, concat ($67_, concat ($66_, _dc_30, xern1_), _dc_31), 
  xern2_), 255), $69_), ($70_ = 4, &$70_), &_k1);
  goto _l750;
  _l705:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1518", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1518", 0));
    __fcnt += 3;
  }
  if ($f_100331_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1518", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100331_[__fcnt + 2], &leniw_, INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1518", 0));
  __fcnt += 3;
  while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
    if ($f_100331_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1518", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern2_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1519", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100332_[__fcnt] != NULL && $f_100332_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100332_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1519", 0));
    __fcnt += 3;
  }
  if ($f_100332_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100332_[__fcnt] != NULL && $f_100332_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100332_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1519", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100332_[__fcnt + 2], &(*liw_), INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1519", 0));
  __fcnt += 3;
  while ($f_100332_[__fcnt] != NULL && $f_100332_[__fcnt] == FMT_TEXT) {
    if ($f_100332_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100332_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1519", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($74_, concat ($73_, concat ($72_, concat ($71_, _dc_32, xern1_), _dc_33), 
  xern2_), 255), $74_), ($75_ = 5, &$75_), &_k1);
  goto _l750;
  _l706:;
  (void) _xermsg (_dc_0, _dc_1, _dc_34, ($76_ = 6, &$76_), &_k1);
  goto _l750;
  _l707:;
  (void) _xermsg (_dc_0, _dc_1, _dc_35, ($77_ = 7, &$77_), &_k1);
  goto _l750;
  _l708:;
  (void) _xermsg (_dc_0, _dc_1, _dc_36, ($78_ = 8, &$78_), &_k1);
  goto _l750;
  _l709:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1537", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1537", 0));
    __fcnt += 3;
  }
  if ($f_100341_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1537", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100341_[__fcnt + 2], &tstop_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1537", 0));
  __fcnt += 3;
  while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
    if ($f_100341_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1537", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1538", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1538", 0));
    __fcnt += 3;
  }
  if ($f_100342_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1538", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100342_[__fcnt + 2], &(*tout_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1538", 0));
  __fcnt += 3;
  while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
    if ($f_100342_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1538", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($82_, concat ($81_, concat ($80_, concat ($79_, _dc_37, xern3_), _dc_38), 
  xern4_), 255), $82_), ($83_ = 9, &$83_), &_k1);
  goto _l750;
  _l710:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1544", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100345_[__fcnt] != NULL && $f_100345_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100345_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1544", 0));
    __fcnt += 3;
  }
  if ($f_100345_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100345_[__fcnt] != NULL && $f_100345_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100345_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1544", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100345_[__fcnt + 2], &hmax_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1544", 0));
  __fcnt += 3;
  while ($f_100345_[__fcnt] != NULL && $f_100345_[__fcnt] == FMT_TEXT) {
    if ($f_100345_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100345_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1544", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($86_, concat ($85_, concat ($84_, _dc_39, xern3_), _dc_40), 127), $86_), ($87_ = 
  10, &$87_), &_k1);
  goto _l750;
  _l711:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1549", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1549", 0));
    __fcnt += 3;
  }
  if ($f_100348_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1549", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100348_[__fcnt + 2], &(*tout_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1549", 0));
  __fcnt += 3;
  while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
    if ($f_100348_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1549", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1550", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100349_[__fcnt] != NULL && $f_100349_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100349_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1550", 0));
    __fcnt += 3;
  }
  if ($f_100349_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100349_[__fcnt] != NULL && $f_100349_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100349_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1550", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100349_[__fcnt + 2], &(*t_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1550", 0));
  __fcnt += 3;
  while ($f_100349_[__fcnt] != NULL && $f_100349_[__fcnt] == FMT_TEXT) {
    if ($f_100349_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100349_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1550", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($91_, concat ($90_, concat ($89_, concat ($88_, _dc_41, xern3_), _dc_42), 
  xern4_), 255), $91_), ($92_ = 11, &$92_), &_k1);
  goto _l750;
  _l712:;
  (void) _xermsg (_dc_0, _dc_1, _dc_43, ($93_ = 12, &$93_), &_k1);
  goto _l750;
  _l713:;
  (void) _xermsg (_dc_0, _dc_1, _dc_44, ($94_ = 13, &$94_), &_k1);
  goto _l750;
  _l714:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1563", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100356_[__fcnt] != NULL && $f_100356_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100356_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1563", 0));
    __fcnt += 3;
  }
  if ($f_100356_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100356_[__fcnt] != NULL && $f_100356_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100356_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1563", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100356_[__fcnt + 2], &(*tout_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1563", 0));
  __fcnt += 3;
  while ($f_100356_[__fcnt] != NULL && $f_100356_[__fcnt] == FMT_TEXT) {
    if ($f_100356_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100356_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1563", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1564", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100357_[__fcnt] != NULL && $f_100357_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100357_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1564", 0));
    __fcnt += 3;
  }
  if ($f_100357_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100357_[__fcnt] != NULL && $f_100357_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100357_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1564", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100357_[__fcnt + 2], &(*t_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1564", 0));
  __fcnt += 3;
  while ($f_100357_[__fcnt] != NULL && $f_100357_[__fcnt] == FMT_TEXT) {
    if ($f_100357_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100357_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1564", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($99_, concat ($98_, concat ($97_, concat ($96_, concat ($95_, _dc_41, xern3_), 
  _dc_45), xern4_), _dc_46), 511), $99_), ($100_ = 14, &$100_), &_k1);
  goto _l750;
  _l715:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1570", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100360_[__fcnt] != NULL && $f_100360_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100360_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1570", 0));
    __fcnt += 3;
  }
  if ($f_100360_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100360_[__fcnt] != NULL && $f_100360_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100360_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1570", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100360_[__fcnt + 2], &tstop_, REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1570", 0));
  __fcnt += 3;
  while ($f_100360_[__fcnt] != NULL && $f_100360_[__fcnt] == FMT_TEXT) {
    if ($f_100360_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100360_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1570", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1571", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100361_[__fcnt] != NULL && $f_100361_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100361_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1571", 0));
    __fcnt += 3;
  }
  if ($f_100361_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100361_[__fcnt] != NULL && $f_100361_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100361_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1571", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100361_[__fcnt + 2], &(*t_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1571", 0));
  __fcnt += 3;
  while ($f_100361_[__fcnt] != NULL && $f_100361_[__fcnt] == FMT_TEXT) {
    if ($f_100361_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100361_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1571", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($104_, concat ($103_, concat ($102_, concat ($101_, _dc_47, xern3_), _dc_42), 
  xern4_), 255), $104_), ($105_ = 15, &$105_), &_k1);
  goto _l750;
  _l717:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1577", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100364_[__fcnt] != NULL && $f_100364_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100364_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1577", 0));
    __fcnt += 3;
  }
  if ($f_100364_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100364_[__fcnt] != NULL && $f_100364_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100364_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1577", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100364_[__fcnt + 2], &iwork_[0], INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1577", 0));
  __fcnt += 3;
  while ($f_100364_[__fcnt] != NULL && $f_100364_[__fcnt] == FMT_TEXT) {
    if ($f_100364_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100364_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1577", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($108_, concat ($107_, concat ($106_, _dc_48, xern1_), _dc_49), 127), $108_), 
  ($109_ = 17, &$109_), &_k1);
  goto _l750;
  _l718:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1583", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100367_[__fcnt] != NULL && $f_100367_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100367_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1583", 0));
    __fcnt += 3;
  }
  if ($f_100367_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100367_[__fcnt] != NULL && $f_100367_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100367_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1583", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100367_[__fcnt + 2], &iwork_[1], INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1583", 0));
  __fcnt += 3;
  while ($f_100367_[__fcnt] != NULL && $f_100367_[__fcnt] == FMT_TEXT) {
    if ($f_100367_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100367_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1583", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($112_, concat ($111_, concat ($110_, _dc_50, xern1_), _dc_49), 127), $112_), 
  ($113_ = 18, &$113_), &_k1);
  goto _l750;
  _l719:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:ddassl:1589", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100370_[__fcnt] != NULL && $f_100370_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100370_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1589", 0));
    __fcnt += 3;
  }
  if ($f_100370_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100370_[__fcnt] != NULL && $f_100370_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100370_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1589", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100370_[__fcnt + 2], &(*tout_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1589", 0));
  __fcnt += 3;
  while ($f_100370_[__fcnt] != NULL && $f_100370_[__fcnt] == FMT_TEXT) {
    if ($f_100370_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100370_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:ddassl:1589", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_1, (bufcpy ($115_, concat ($114_, _dc_51, xern3_), 63), $115_), ($116_ = 19, &$116_), &_k1)
  ;
  goto _l750;
  _l750:;
  (*idid_) = -33;
  if (info_[0] == -1) {
    (void) _xermsg (_dc_0, _dc_1, concat ($117_, _dc_52, _dc_53), ($118_ = -999, &$118_), ($119_ = 2, &$119_));
  }
  info_[0] = -1;
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _ddastp (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ yprime_, int_4 _p_ neq_, int_4 (*_res)(), int_4 (*_jac)(), 
real_8 _p_ h_, real_8 _p_ wt_, int_4 _p_ jstart_, int_4 _p_ idid_, real_8 _p_ rpar_, int_4 _p_ ipar_, real_8 _p_ phi_, 
real_8 _p_ delta_, real_8 _p_ e_, real_8 _p_ wm_, int_4 _p_ iwm_, real_8 _p_ alpha_, real_8 _p_ beta_, real_8 _p_ 
gamma_, real_8 _p_ psi_, real_8 _p_ sigma_, real_8 _p_ cj_, real_8 _p_ cjold_, real_8 _p_ hold_, real_8 _p_ s_, real_8 
_p_ hmin_, real_8 _p_ uround_, int_4 _p_ iphase_, int_4 _p_ jcalc_, int_4 _p_ k_, int_4 _p_ kold_, int_4 _p_ ns_, int_4 
_p_ nonneg_, int_4 _p_ ntemp_)
{
  static int_4 i_, ier_, ires_, j_, j1_, kdiff_, km1_, knew_, kp1_, kp2_, m_, maxit_, ncf_, nef_, nsf_, nsp1_;
  static logical_4 convgd_;
  static real_8 alpha0_, alphas_, cjlast_, ck_, delnrm_, enorm_, erk_, erkm1_, erkm2_, erkp1_, err_, est_, hnew_, oldnrm_
  , pnorm_, r_, rate_, temp1_, temp2_, terk_, terkm1_, terkm2_, terkp1_, xold_, xrate_;
  int_4 _data_k_3, _data_k_4;
#define _data_n_3 1
  static int_4 _data_l_3[_data_n_3] = {
    4
  };
#define _data_n_4 1
  static real_8 _data_l_4[_data_n_4] = {
    0.25e0
  };
  if (__calls[5].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    maxit_ = _data_l_3[_data_k_3++];
  }
  if (__calls[5].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    xrate_ = _data_l_4[_data_k_4++];
  }
  (*idid_) = 1;
  xold_ = (*x_);
  ncf_ = 0;
  nsf_ = 0;
  nef_ = 0;
  if ((*jstart_) != 0) {
    goto _l120;
  }
  iwm_[13] = 0;
  iwm_[14] = 0;
  (*k_) = 1;
  (*kold_) = 0;
  (*hold_) = 0.0;
  (*jstart_) = 1;
  psi_[0] = (*h_);
  (*cjold_) = 1.0e0 / (*h_);
  (*cj_) = (*cjold_);
  (*s_) = 100.0;
  (*jcalc_) = -1;
  delnrm_ = 1.0;
  (*iphase_) = 0;
  (*ns_) = 0;
  _l120:;
  _l200:;
  kp1_ = (*k_) + 1;
  kp2_ = (*k_) + 2;
  km1_ = (*k_) - 1;
  xold_ = (*x_);
  if ((*h_) != (*hold_) || (*k_) != (*kold_)) {
    (*ns_) = 0;
  }
  (*ns_) = _min ((*ns_) + 1, (*kold_) + 2);
  nsp1_ = (*ns_) + 1;
  if (kp1_ < (*ns_)) {
    goto _l230;
  }
  beta_[0] = 1.0;
  alpha_[0] = 1.0;
  temp1_ = (*h_);
  gamma_[0] = 0.0;
  sigma_[0] = 1.0;
  for (i_ = 2; i_ <= kp1_; (i_)++) {
    temp2_ = psi_[i_ - 1 - 1];
    psi_[i_ - 1 - 1] = temp1_;
    beta_[i_ - 1] = beta_[i_ - 1 - 1] * psi_[i_ - 1 - 1] / temp2_;
    temp1_ = temp2_ + (*h_);
    alpha_[i_ - 1] = (*h_) / temp1_;
    sigma_[i_ - 1] = (i_ - 1) * sigma_[i_ - 1 - 1] * alpha_[i_ - 1];
    gamma_[i_ - 1] = gamma_[i_ - 1 - 1] + alpha_[i_ - 1 - 1] / (*h_);
  }
  psi_[kp1_ - 1] = temp1_;
  _l230:;
  alphas_ = 0.0;
  alpha0_ = 0.0;
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    alphas_ = alphas_ - 1.0e0 / i_;
    alpha0_ = alpha0_ - alpha_[i_ - 1];
  }
  cjlast_ = (*cj_);
  (*cj_) = -alphas_ / (*h_);
  ck_ = _abs (alpha_[kp1_ - 1] + alphas_ - alpha0_);
  ck_ = _max (ck_, alpha_[kp1_ - 1]);
  temp1_ = (1.0e0 - xrate_) / (1.0e0 + xrate_);
  temp2_ = 1.0e0 / temp1_;
  if ((*cj_) / (*cjold_) < temp1_ || (*cj_) / (*cjold_) > temp2_) {
    (*jcalc_) = -1;
  }
  if ((*cj_) != cjlast_) {
    (*s_) = 100.0;
  }
  if (kp1_ < nsp1_) {
    goto _l280;
  }
  for (j_ = nsp1_; j_ <= kp1_; (j_)++) {
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))] = beta_[j_ - 1] * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
    }
  }
  _l280:;
  (*x_) = (*x_) + (*h_);
  _l300:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((0))];
    yprime_[i_ - 1] = 0.0;
  }
  for (j_ = 2; j_ <= kp1_; (j_)++) {
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      y_[i_ - 1] = y_[i_ - 1] + phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
      yprime_[i_ - 1] = yprime_[i_ - 1] + gamma_[j_ - 1] * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
    }
  }
  pnorm_ = _ddanrm (neq_, y_, wt_, rpar_, ipar_);
  convgd_ = TRUE;
  m_ = 0;
  iwm_[11] = iwm_[11] + 1;
  ires_ = 0;
  (void) _res (x_, y_, yprime_, delta_, &ires_, rpar_, ipar_);
  if (ires_ < 0) {
    goto _l380;
  }
  if ((*jcalc_) != -1) {
    goto _l340;
  }
  iwm_[12] = iwm_[12] + 1;
  (*jcalc_) = 0;
  (void) _ddajac (neq_, x_, y_, yprime_, delta_, cj_, h_, &ier_, wt_, e_, wm_, iwm_, _res, &ires_, uround_, _jac, rpar_, 
  ipar_, ntemp_);
  (*cjold_) = (*cj_);
  (*s_) = 100.0;
  if (ires_ < 0) {
    goto _l380;
  }
  if (ier_ != 0) {
    goto _l380;
  }
  nsf_ = 0;
  _l340:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    e_[i_ - 1] = 0.0;
  }
  _l350:;
  temp1_ = 2.0e0 / (1.0e0 + (*cj_) / (*cjold_));
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = delta_[i_ - 1] * temp1_;
  }
  (void) _ddaslv (neq_, delta_, wm_, iwm_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] - delta_[i_ - 1];
    e_[i_ - 1] = e_[i_ - 1] - delta_[i_ - 1];
    yprime_[i_ - 1] = yprime_[i_ - 1] - (*cj_) * delta_[i_ - 1];
  }
  delnrm_ = _ddanrm (neq_, delta_, wt_, rpar_, ipar_);
  if (delnrm_ <= 100.0e0 * (*uround_) * pnorm_) {
    goto _l375;
  }
  if (m_ > 0) {
    goto _l365;
  }
  oldnrm_ = delnrm_;
  goto _l367;
  _l365:;
  rate_ = pow ((delnrm_ / oldnrm_), (1.0e0 / m_));
  if (rate_ > 0.9e0) {
    goto _l370;
  }
  (*s_) = rate_ / (1.0e0 - rate_);
  _l367:;
  if ((*s_) * delnrm_ <= 0.33e0) {
    goto _l375;
  }
  m_ = m_ + 1;
  if (m_ >= maxit_) {
    goto _l370;
  }
  iwm_[11] = iwm_[11] + 1;
  ires_ = 0;
  (void) _res (x_, y_, yprime_, delta_, &ires_, rpar_, ipar_);
  if (ires_ < 0) {
    goto _l380;
  }
  goto _l350;
  _l370:;
  if ((*jcalc_) == 0) {
    goto _l380;
  }
  (*jcalc_) = -1;
  goto _l300;
  _l375:;
  if ((*nonneg_) == 0) {
    goto _l390;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = _min (y_[i_ - 1], 0.0);
  }
  delnrm_ = _ddanrm (neq_, delta_, wt_, rpar_, ipar_);
  if (delnrm_ > 0.33e0) {
    goto _l380;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    e_[i_ - 1] = e_[i_ - 1] - delta_[i_ - 1];
  }
  goto _l390;
  _l380:;
  convgd_ = FALSE;
  _l390:;
  (*jcalc_) = 1;
  if (! (convgd_)) {
    goto _l600;
  }
  enorm_ = _ddanrm (neq_, e_, wt_, rpar_, ipar_);
  erk_ = sigma_[(*k_) + 1 - 1] * enorm_;
  terk_ = ((*k_) + 1) * erk_;
  est_ = erk_;
  knew_ = (*k_);
  if ((*k_) == 1) {
    goto _l430;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((kp1_ - 1))] + e_[i_ - 1];
  }
  erkm1_ = sigma_[(*k_) - 1] * _ddanrm (neq_, delta_, wt_, rpar_, ipar_);
  terkm1_ = (*k_) * erkm1_;
  if ((*k_) > 2) {
    goto _l410;
  }
  if (terkm1_ <= 0.5e0 * terk_) {
    goto _l420;
  }
  goto _l430;
  _l410:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * (((*k_) - 1))] + delta_[i_ - 1];
  }
  erkm2_ = sigma_[(*k_) - 1 - 1] * _ddanrm (neq_, delta_, wt_, rpar_, ipar_);
  terkm2_ = ((*k_) - 1) * erkm2_;
  if (_max (terkm1_, terkm2_) > terk_) {
    goto _l430;
  }
  _l420:;
  knew_ = (*k_) - 1;
  est_ = erkm1_;
  _l430:;
  err_ = ck_ * enorm_;
  if (err_ > 1.0e0) {
    goto _l600;
  }
  (*idid_) = 1;
  iwm_[10] = iwm_[10] + 1;
  kdiff_ = (*k_) - (*kold_);
  (*kold_) = (*k_);
  (*hold_) = (*h_);
  if (knew_ == km1_ || (*k_) == iwm_[2]) {
    (*iphase_) = 1;
  }
  if ((*iphase_) == 0) {
    goto _l545;
  }
  if (knew_ == km1_) {
    goto _l540;
  }
  if ((*k_) == iwm_[2]) {
    goto _l550;
  }
  if (kp1_ >= (*ns_) || kdiff_ == 1) {
    goto _l550;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = e_[i_ - 1] - phi_[i_ - 1 + ((*neq_)) * ((kp2_ - 1))];
  }
  erkp1_ = (1.0e0 / ((*k_) + 2)) * _ddanrm (neq_, delta_, wt_, rpar_, ipar_);
  terkp1_ = ((*k_) + 2) * erkp1_;
  if ((*k_) > 1) {
    goto _l520;
  }
  if (terkp1_ >= 0.5e0 * terk_) {
    goto _l550;
  }
  goto _l530;
  _l520:;
  if (terkm1_ <= _min (terk_, terkp1_)) {
    goto _l540;
  }
  if (terkp1_ >= terk_ || (*k_) == iwm_[2]) {
    goto _l550;
  }
  _l530:;
  (*k_) = kp1_;
  est_ = erkp1_;
  goto _l550;
  _l540:;
  (*k_) = km1_;
  est_ = erkm1_;
  goto _l550;
  _l545:;
  (*k_) = kp1_;
  hnew_ = (*h_) * 2.0e0;
  (*h_) = hnew_;
  goto _l575;
  _l550:;
  hnew_ = (*h_);
  temp2_ = (*k_) + 1;
  r_ = pow ((2.0e0 * est_ + 0.0001e0), (-1.0e0 / temp2_));
  if (r_ < 2.0e0) {
    goto _l555;
  }
  hnew_ = 2.0e0 * (*h_);
  goto _l560;
  _l555:;
  if (r_ > 1.0e0) {
    goto _l560;
  }
  r_ = _max (0.5, _min (0.9, r_));
  hnew_ = (*h_) * r_;
  _l560:;
  (*h_) = hnew_;
  _l575:;
  if ((*kold_) == iwm_[2]) {
    goto _l585;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    phi_[i_ - 1 + ((*neq_)) * ((kp2_ - 1))] = e_[i_ - 1];
  }
  _l585:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    phi_[i_ - 1 + ((*neq_)) * ((kp1_ - 1))] = phi_[i_ - 1 + ((*neq_)) * ((kp1_ - 1))] + e_[i_ - 1];
  }
  for (j1_ = 2; j1_ <= kp1_; (j1_)++) {
    j_ = kp1_ - j1_ + 1;
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))] = phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))] + phi_[i_ - 1 + ((*neq_)) * ((j_ + 1 - 
      1))];
    }
  }
  goto _l0;
  _l600:;
  (*iphase_) = 1;
  (*x_) = xold_;
  if (kp1_ < nsp1_) {
    goto _l630;
  }
  for (j_ = nsp1_; j_ <= kp1_; (j_)++) {
    temp1_ = 1.0e0 / beta_[j_ - 1];
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))] = temp1_ * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
    }
  }
  _l630:;
  for (i_ = 2; i_ <= kp1_; (i_)++) {
    psi_[i_ - 1 - 1] = psi_[i_ - 1] - (*h_);
  }
  if (convgd_) {
    goto _l660;
  }
  iwm_[14] = iwm_[14] + 1;
  if (ier_ == 0) {
    goto _l650;
  }
  nsf_ = nsf_ + 1;
  r_ = 0.25;
  (*h_) = (*h_) * r_;
  if (nsf_ < 3 && _abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -8;
  goto _l675;
  _l650:;
  if (ires_ > -2) {
    goto _l655;
  }
  (*idid_) = -11;
  goto _l675;
  _l655:;
  ncf_ = ncf_ + 1;
  r_ = 0.25;
  (*h_) = (*h_) * r_;
  if (ncf_ < 10 && _abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -7;
  if (ires_ < 0) {
    (*idid_) = -10;
  }
  if (nef_ >= 3) {
    (*idid_) = -9;
  }
  goto _l675;
  _l660:;
  nef_ = nef_ + 1;
  iwm_[13] = iwm_[13] + 1;
  if (nef_ > 1) {
    goto _l665;
  }
  (*k_) = knew_;
  temp2_ = (*k_) + 1;
  r_ = 0.9e0 * pow ((2.0e0 * est_ + 0.0001e0), (-1.0e0 / temp2_));
  r_ = _max (0.25, _min (0.9, r_));
  (*h_) = (*h_) * r_;
  if (_abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -6;
  goto _l675;
  _l665:;
  if (nef_ > 2) {
    goto _l670;
  }
  (*k_) = knew_;
  (*h_) = 0.25e0 * (*h_);
  if (_abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -6;
  goto _l675;
  _l670:;
  (*k_) = 1;
  (*h_) = 0.25e0 * (*h_);
  if (_abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -6;
  goto _l675;
  _l675:;
  (void) _ddatrp (x_, x_, y_, yprime_, neq_, k_, phi_, psi_);
  goto _l0;
  _l690:;
  goto _l200;
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _ddatrp (real_8 _p_ x_, real_8 _p_ xout_, real_8 _p_ yout_, real_8 _p_ ypout_, int_4 _p_ neq_, int_4 _p_ kold_, 
real_8 _p_ phi_, real_8 _p_ psi_)
{
  static int_4 i_, j_, koldp1_;
  static real_8 c_, d_, gamma_, temp1_;
  koldp1_ = (*kold_) + 1;
  temp1_ = (*xout_) - (*x_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    yout_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((0))];
    ypout_[i_ - 1] = 0.0;
  }
  c_ = 1.0;
  d_ = 0.0;
  gamma_ = temp1_ / psi_[0];
  for (j_ = 2; j_ <= koldp1_; (j_)++) {
    d_ = d_ * gamma_ + c_ / psi_[j_ - 1 - 1];
    c_ = c_ * gamma_;
    gamma_ = (temp1_ + psi_[j_ - 1 - 1]) / psi_[j_ - 1];
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      yout_[i_ - 1] = yout_[i_ - 1] + c_ * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
      ypout_[i_ - 1] = ypout_[i_ - 1] + d_ * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
    }
  }
  __calls[6].calls++;
  return 0;
}

int_4 _ddawts (int_4 _p_ neq_, int_4 _p_ iwt_, real_8 _p_ rtol_, real_8 _p_ atol_, real_8 _p_ y_, real_8 _p_ wt_, 
real_8 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 i_;
  static real_8 atoli_, rtoli_;
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if ((*iwt_) == 0) {
      goto _l10;
    }
    rtoli_ = rtol_[i_ - 1];
    atoli_ = atol_[i_ - 1];
    _l10:;
    wt_[i_ - 1] = rtoli_ * _abs (y_[i_ - 1]) + atoli_;
  }
  __calls[7].calls++;
  return 0;
}

int_4 _sdaini (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ yprime_, int_4 _p_ neq_, int_4 (*_res)(), int_4 (*_jac)(), 
real_4 _p_ h_, real_4 _p_ wt_, int_4 _p_ idid_, real_4 _p_ rpar_, int_4 _p_ ipar_, real_4 _p_ phi_, real_4 _p_ delta_, 
real_4 _p_ e_, real_4 _p_ wm_, int_4 _p_ iwm_, real_4 _p_ hmin_, real_4 _p_ uround_, int_4 _p_ nonneg_, int_4 _p_ 
ntemp_)
{
  static int_4 i_, ier_, ires_, jcalc_, m_, maxit_, mjac_, ncf_, nef_, nsf_;
  static logical_4 convgd_;
  static real_4 cj_, damp_, delnrm_, err_, oldnrm_, r_, rate_, s_, xold_, ynorm_;
  int_4 _data_k_5, _data_k_6, _data_k_7;
#define _data_n_5 1
  static int_4 _data_l_5[_data_n_5] = {
    10
  };
#define _data_n_6 1
  static int_4 _data_l_6[_data_n_6] = {
    5
  };
#define _data_n_7 1
  static real_4 _data_l_7[_data_n_7] = {
    0.75e0
  };
  if (__calls[8].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    maxit_ = _data_l_5[_data_k_5++];
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    mjac_ = _data_l_6[_data_k_6++];
  }
  if (__calls[8].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    damp_ = _data_l_7[_data_k_7++];
  }
  (*idid_) = 1;
  nef_ = 0;
  ncf_ = 0;
  nsf_ = 0;
  xold_ = (*x_);
  ynorm_ = _sdanrm (neq_, y_, wt_, rpar_, ipar_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    phi_[i_ - 1 + ((*neq_)) * ((0))] = y_[i_ - 1];
    phi_[i_ - 1 + ((*neq_)) * ((1))] = yprime_[i_ - 1];
  }
  _l200:;
  cj_ = 1.0e0 / (*h_);
  (*x_) = (*x_) + (*h_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] + (*h_) * yprime_[i_ - 1];
  }
  jcalc_ = -1;
  m_ = 0;
  convgd_ = TRUE;
  _l300:;
  iwm_[11] = iwm_[11] + 1;
  ires_ = 0;
  (void) _res (x_, y_, yprime_, delta_, &ires_, rpar_, ipar_);
  if (ires_ < 0) {
    goto _l430;
  }
  if (jcalc_ != -1) {
    goto _l310;
  }
  iwm_[12] = iwm_[12] + 1;
  jcalc_ = 0;
  (void) _sdajac (neq_, x_, y_, yprime_, delta_, &cj_, h_, &ier_, wt_, e_, wm_, iwm_, _res, &ires_, uround_, _jac, rpar_, 
  ipar_, ntemp_);
  s_ = 1000000.0;
  if (ires_ < 0) {
    goto _l430;
  }
  if (ier_ != 0) {
    goto _l430;
  }
  nsf_ = 0;
  _l310:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = delta_[i_ - 1] * damp_;
  }
  (void) _sdaslv (neq_, delta_, wm_, iwm_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] - delta_[i_ - 1];
    yprime_[i_ - 1] = yprime_[i_ - 1] - cj_ * delta_[i_ - 1];
  }
  delnrm_ = _sdanrm (neq_, delta_, wt_, rpar_, ipar_);
  if (delnrm_ <= 100.0e0 * (*uround_) * ynorm_) {
    goto _l400;
  }
  if (m_ > 0) {
    goto _l340;
  }
  oldnrm_ = delnrm_;
  goto _l350;
  _l340:;
  rate_ = powl ((delnrm_ / oldnrm_), (1.0e0 / m_));
  if (rate_ > 0.9e0) {
    goto _l430;
  }
  s_ = rate_ / (1.0e0 - rate_);
  _l350:;
  if (s_ * delnrm_ <= 0.33e0) {
    goto _l400;
  }
  m_ = m_ + 1;
  if (m_ >= maxit_) {
    goto _l430;
  }
  if ((m_ / mjac_) * mjac_ == m_) {
    jcalc_ = -1;
  }
  goto _l300;
  _l400:;
  if ((*nonneg_) == 0) {
    goto _l450;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = _min (y_[i_ - 1], 0.0);
  }
  delnrm_ = _sdanrm (neq_, delta_, wt_, rpar_, ipar_);
  if (delnrm_ > 0.33e0) {
    goto _l430;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] - delta_[i_ - 1];
    yprime_[i_ - 1] = yprime_[i_ - 1] - cj_ * delta_[i_ - 1];
  }
  goto _l450;
  _l430:;
  convgd_ = FALSE;
  _l450:;
  if (! (convgd_)) {
    goto _l600;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    e_[i_ - 1] = y_[i_ - 1] - phi_[i_ - 1 + ((*neq_)) * ((0))];
  }
  err_ = _sdanrm (neq_, e_, wt_, rpar_, ipar_);
  if (err_ <= 1.0e0) {
    goto _l0;
  }
  _l600:;
  (*x_) = xold_;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((0))];
    yprime_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((1))];
  }
  if (convgd_) {
    goto _l640;
  }
  if (ier_ == 0) {
    goto _l620;
  }
  nsf_ = nsf_ + 1;
  (*h_) = (*h_) * 0.25e0;
  if (nsf_ < 3 && _abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -12;
  goto _l0;
  _l620:;
  if (ires_ > -2) {
    goto _l630;
  }
  (*idid_) = -12;
  goto _l0;
  _l630:;
  ncf_ = ncf_ + 1;
  (*h_) = (*h_) * 0.25e0;
  if (ncf_ < 10 && _abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -12;
  goto _l0;
  _l640:;
  nef_ = nef_ + 1;
  r_ = 0.9e0 / (2.0e0 * err_ + 0.0001e0);
  r_ = _max (0.1, _min (0.5, r_));
  (*h_) = (*h_) * r_;
  if (_abs ((*h_)) >= (*hmin_) && nef_ < 10) {
    goto _l690;
  }
  (*idid_) = -12;
  goto _l0;
  _l690:;
  goto _l200;
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _sdajac (int_4 _p_ neq_, real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ yprime_, real_4 _p_ delta_, real_4 _p_ cj_, 
real_4 _p_ h_, int_4 _p_ ier_, real_4 _p_ wt_, real_4 _p_ e_, real_4 _p_ wm_, int_4 _p_ iwm_, int_4 (*_res)(), int_4 
_p_ ires_, real_4 _p_ uround_, int_4 (*_jac)(), real_4 _p_ rpar_, int_4 _p_ ipar_, int_4 _p_ ntemp_)
{
  static int_4 i_, i1_, i2_, ii_, ipsave_, isave_, j_, k_, l_, lenpd_, mba_, mband_, meb1_, meband_, msave_, mtype_, n_, 
  npdm1_, nrow_;
  static real_4 del_, delinv_, squr_, ypsave_, ysave_;
  real_4 $0_, $1_, $2_;
  extern int_4 _sgbfa ();
  extern int_4 _sgefa ();
  (*ier_) = 0;
  npdm1_ = 0;
  mtype_ = iwm_[3];
  switch (mtype_) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l500;
  }
  _l100:;
  lenpd_ = (*neq_) * (*neq_);
  for (i_ = 1; i_ <= lenpd_; (i_)++) {
    wm_[npdm1_ + i_ - 1] = 0.0;
  }
  (void) _jac (x_, y_, yprime_, &wm_[0], cj_, rpar_, ipar_);
  goto _l230;
  _l200:;
  (*ires_) = 0;
  nrow_ = npdm1_;
  squr_ = sqrtf ((*uround_));
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    del_ = squr_ * ($0_ = _max (_abs (y_[i_ - 1]), _abs ((*h_) * yprime_[i_ - 1])), _max ($0_, _abs (wt_[i_ - 1])));
    del_ = _sign (del_, (*h_) * yprime_[i_ - 1]);
    del_ = (y_[i_ - 1] + del_) - y_[i_ - 1];
    ysave_ = y_[i_ - 1];
    ypsave_ = yprime_[i_ - 1];
    y_[i_ - 1] = y_[i_ - 1] + del_;
    yprime_[i_ - 1] = yprime_[i_ - 1] + (*cj_) * del_;
    (void) _res (x_, y_, yprime_, e_, ires_, rpar_, ipar_);
    if ((*ires_) < 0) {
      goto _l0;
    }
    delinv_ = 1.0e0 / del_;
    for (l_ = 1; l_ <= (*neq_); (l_)++) {
      wm_[nrow_ + l_ - 1] = (e_[l_ - 1] - delta_[l_ - 1]) * delinv_;
    }
    nrow_ = nrow_ + (*neq_);
    y_[i_ - 1] = ysave_;
    yprime_[i_ - 1] = ypsave_;
  }
  _l230:;
  (void) _sgefa (&wm_[0], neq_, neq_, &iwm_[20], ier_);
  goto _l0;
  _l300:;
  goto _l0;
  _l400:;
  lenpd_ = (2 * iwm_[0] + iwm_[1] + 1) * (*neq_);
  for (i_ = 1; i_ <= lenpd_; (i_)++) {
    wm_[npdm1_ + i_ - 1] = 0.0;
  }
  (void) _jac (x_, y_, yprime_, &wm_[0], cj_, rpar_, ipar_);
  meband_ = 2 * iwm_[0] + iwm_[1] + 1;
  goto _l550;
  _l500:;
  mband_ = iwm_[0] + iwm_[1] + 1;
  mba_ = _min (mband_, (*neq_));
  meband_ = mband_ + iwm_[0];
  meb1_ = meband_ - 1;
  msave_ = ((*neq_) / mband_) + 1;
  isave_ = (*ntemp_) - 1;
  ipsave_ = isave_ + msave_;
  (*ires_) = 0;
  squr_ = sqrtf ((*uround_));
  for (j_ = 1; j_ <= mba_; (j_)++) {
    for (n_ = j_; (mband_ > 0 ? n_ <= (*neq_) : n_ >= (*neq_)); n_ += mband_) {
      k_ = (n_ - j_) / mband_ + 1;
      wm_[isave_ + k_ - 1] = y_[n_ - 1];
      wm_[ipsave_ + k_ - 1] = yprime_[n_ - 1];
      del_ = squr_ * ($1_ = _max (_abs (y_[n_ - 1]), _abs ((*h_) * yprime_[n_ - 1])), _max ($1_, _abs (wt_[n_ - 1])));
      del_ = _sign (del_, (*h_) * yprime_[n_ - 1]);
      del_ = (y_[n_ - 1] + del_) - y_[n_ - 1];
      y_[n_ - 1] = y_[n_ - 1] + del_;
      yprime_[n_ - 1] = yprime_[n_ - 1] + (*cj_) * del_;
    }
    (void) _res (x_, y_, yprime_, e_, ires_, rpar_, ipar_);
    if ((*ires_) < 0) {
      goto _l0;
    }
    for (n_ = j_; (mband_ > 0 ? n_ <= (*neq_) : n_ >= (*neq_)); n_ += mband_) {
      k_ = (n_ - j_) / mband_ + 1;
      y_[n_ - 1] = wm_[isave_ + k_ - 1];
      yprime_[n_ - 1] = wm_[ipsave_ + k_ - 1];
      del_ = squr_ * ($2_ = _max (_abs (y_[n_ - 1]), _abs ((*h_) * yprime_[n_ - 1])), _max ($2_, _abs (wt_[n_ - 1])));
      del_ = _sign (del_, (*h_) * yprime_[n_ - 1]);
      del_ = (y_[n_ - 1] + del_) - y_[n_ - 1];
      delinv_ = 1.0e0 / del_;
      i1_ = _max (1, (n_ - iwm_[1]));
      i2_ = _min ((*neq_), (n_ + iwm_[0]));
      ii_ = n_ * meb1_ - iwm_[0] + npdm1_;
      for (i_ = i1_; i_ <= i2_; (i_)++) {
        wm_[ii_ + i_ - 1] = (e_[i_ - 1] - delta_[i_ - 1]) * delinv_;
      }
    }
  }
  _l550:;
  (void) _sgbfa (&wm_[0], &meband_, neq_, &iwm_[0], &iwm_[1], &iwm_[20], ier_);
  _l0:;
  __calls[9].calls++;
  return 0;
}

real_4 _sdanrm (int_4 _p_ neq_, real_4 _p_ v_, real_4 _p_ wt_, real_4 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 i_;
  static real_4 sum_, vmax_;
  real_4 $0_;
  real_4 sdanrm_;
  sdanrm_ = 0.0;
  vmax_ = 0.0;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if (_abs (v_[i_ - 1] / wt_[i_ - 1]) > vmax_) {
      vmax_ = _abs (v_[i_ - 1] / wt_[i_ - 1]);
    }
  }
  if (vmax_ <= 0.0e0) {
    goto _l30;
  }
  sum_ = 0.0;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    sum_ = sum_ + ($0_ = ((v_[i_ - 1] / wt_[i_ - 1]) / vmax_), $0_ * $0_);
  }
  sdanrm_ = vmax_ * sqrtf (sum_ / (*neq_));
  _l30:;
  __calls[10].calls++;
  return sdanrm_;
}

int_4 _sdaslv (int_4 _p_ neq_, real_4 _p_ delta_, real_4 _p_ wm_, int_4 _p_ iwm_)
{
  static int_4 meband_, mtype_;
  extern int_4 _sgbsl ();
  extern int_4 _sgesl ();
  mtype_ = iwm_[3];
  switch (mtype_) {
    default:
    case 1: goto _l100;
    case 2: goto _l100;
    case 3: goto _l300;
    case 4: goto _l400;
    case 5: goto _l400;
  }
  _l100:;
  (void) _sgesl (&wm_[0], neq_, neq_, &iwm_[20], delta_, &_k0);
  goto _l0;
  _l300:;
  goto _l0;
  _l400:;
  meband_ = 2 * iwm_[0] + iwm_[1] + 1;
  (void) _sgbsl (&wm_[0], &meband_, neq_, &iwm_[0], &iwm_[1], &iwm_[20], delta_, &_k0);
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _sdassl (real_4 (*_res)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ yprime_, real_4 _p_ tout_, 
int_4 _p_ info_, real_4 _p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ 
iwork_, int_4 _p_ liw_, real_4 _p_ rpar_, int_4 _p_ ipar_, int_4 (*_jac)())
{
  static int_4 i_, itemp_, leniw_, lenpd_, lenrw_, le_, lpd_, lphi_, lwm_, lwt_, mband_, msave_, mxord_, ntemp_, nzflg_;
  static logical_4 done_;
  static real_4 atoli_, h_, hmax_, hmin_, ho_, r_, rh_, rtoli_, tdist_, tn_, tnext_, tstop_, uround_, ypnorm_;
  static char_15 xern1_, xern2_;
  static char_31 xern3_, xern4_;
  int_4 __fcnt, __rc, $4_, $5_, $6_, $61_, $65_, $70_, $75_, $76_, $77_, $78_, $83_, $87_, $92_, $93_, $94_, $100_, $105_
  , $109_, $113_, $116_, $118_, $119_;
  char_31 $58_, $62_, $106_, $110_;
  char_63 $7_, $11_, $16_, $20_, $25_, $31_, $36_, $42_, $48_, $53_, $59_, $60_, $63_, $64_, $66_, $71_, $79_, $84_, $88_
  , $95_, $101_, $114_, $115_;
  char_127 $0_, $8_, $12_, $17_, $21_, $26_, $32_, $37_, $43_, $49_, $54_, $67_, $72_, $80_, $85_, $86_, $89_, $96_, 
  $102_, $107_, $108_, $111_, $112_, $117_;
  char_255 $1_, $9_, $10_, $13_, $18_, $19_, $22_, $27_, $33_, $38_, $44_, $50_, $55_, $68_, $69_, $73_, $74_, $81_, $82_
  , $90_, $91_, $97_, $103_, $104_;
  char_511 $2_, $3_, $14_, $15_, $23_, $24_, $28_, $34_, $35_, $39_, $45_, $51_, $52_, $56_, $57_, $98_, $99_;
  char_1023 $29_, $30_, $40_, $41_, $46_, $47_;
  extern real_4 _r1mach ();
  extern int_4 _xermsg ();
  static FORMAT $f_100062_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100276_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100279_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100282_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100285_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100286_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100289_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100290_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100293_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100294_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100297_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100298_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100301_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100302_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100305_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100306_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100309_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100310_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100321_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100324_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100327_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100328_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100331_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100332_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100341_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100342_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100345_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100348_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100349_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100356_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100357_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100360_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100361_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100364_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100367_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100370_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0E",
    NULL, NULL, NULL
  };
  if (info_[0] != 0) {
    goto _l100;
  }
  for (i_ = 2; i_ <= 11; (i_)++) {
    if (info_[i_ - 1] != 0 && info_[i_ - 1] != 1) {
      goto _l701;
    }
  }
  if ((*neq_) <= 0) {
    goto _l702;
  }
  mxord_ = 5;
  if (info_[8] == 0) {
    goto _l20;
  }
  mxord_ = iwork_[2];
  if (mxord_ < 1 || mxord_ > 5) {
    goto _l703;
  }
  _l20:;
  iwork_[2] = mxord_;
  if (info_[5] != 0) {
    goto _l40;
  }
  lenpd_ = ((*neq_) * (*neq_));
  lenrw_ = 40 + (iwork_[2] + 4) * (*neq_) + lenpd_;
  if (info_[4] != 0) {
    goto _l30;
  }
  iwork_[3] = 2;
  goto _l60;
  _l30:;
  iwork_[3] = 1;
  goto _l60;
  _l40:;
  if (iwork_[0] < 0 || iwork_[0] >= (*neq_)) {
    goto _l717;
  }
  if (iwork_[1] < 0 || iwork_[1] >= (*neq_)) {
    goto _l718;
  }
  lenpd_ = (2 * iwork_[0] + iwork_[1] + 1) * (*neq_);
  if (info_[4] != 0) {
    goto _l50;
  }
  iwork_[3] = 5;
  mband_ = iwork_[0] + iwork_[1] + 1;
  msave_ = ((*neq_) / mband_) + 1;
  lenrw_ = 40 + (iwork_[2] + 4) * (*neq_) + lenpd_ + 2 * msave_;
  goto _l60;
  _l50:;
  iwork_[3] = 4;
  lenrw_ = 40 + (iwork_[2] + 4) * (*neq_) + lenpd_;
  _l60:;
  leniw_ = 20 + (*neq_);
  iwork_[15] = lenpd_;
  if ((*lrw_) < lenrw_) {
    goto _l704;
  }
  if ((*liw_) < leniw_) {
    goto _l705;
  }
  if ((*tout_) == (*t_)) {
    goto _l719;
  }
  if (info_[6] == 0) {
    goto _l70;
  }
  hmax_ = rwork_[1];
  if (hmax_ <= 0.0e0) {
    goto _l710;
  }
  _l70:;
  iwork_[10] = 0;
  iwork_[11] = 0;
  iwork_[12] = 0;
  iwork_[9] = 0;
  (*idid_) = 1;
  goto _l200;
  _l100:;
  if (info_[0] == 1) {
    goto _l110;
  }
  if (info_[0] != -1) {
    goto _l701;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1051", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1051", 0));
    __fcnt += 3;
  }
  if ($f_100062_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1051", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100062_[__fcnt + 2], &(*idid_), INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1051", 0));
  __fcnt += 3;
  while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
    if ($f_100062_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1051", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_2, xern1_), _dc_3), _dc_4), 
  511), $3_), ($4_ = -998, &$4_), ($5_ = 2, &$5_));
  goto _l0;
  _l110:;
  iwork_[9] = iwork_[10];
  _l200:;
  nzflg_ = 0;
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if (info_[1] == 1) {
      rtoli_ = rtol_[i_ - 1];
    }
    if (info_[1] == 1) {
      atoli_ = atol_[i_ - 1];
    }
    if (rtoli_ > 0.0e0 || atoli_ > 0.0e0) {
      nzflg_ = 1;
    }
    if (rtoli_ < 0.0e0) {
      goto _l706;
    }
    if (atoli_ < 0.0e0) {
      goto _l707;
    }
  }
  if (nzflg_ == 0) {
    goto _l708;
  }
  le_ = 41 + (*neq_);
  lwt_ = le_ + (*neq_);
  lphi_ = lwt_ + (*neq_);
  lpd_ = lphi_ + (iwork_[2] + 1) * (*neq_);
  lwm_ = lpd_;
  ntemp_ = 1 + iwork_[15];
  if (info_[0] == 1) {
    goto _l400;
  }
  tn_ = (*t_);
  (*idid_) = 1;
  (void) _sdawts (neq_, &info_[1], rtol_, atol_, y_, &rwork_[lwt_ - 1], rpar_, ipar_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if (rwork_[lwt_ + i_ - 1 - 1] <= 0.0e0) {
      goto _l713;
    }
  }
  uround_ = _r1mach (($6_ = 4, &$6_));
  rwork_[8] = uround_;
  hmin_ = 4.0e0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)));
  tdist_ = _abs ((*tout_) - (*t_));
  if (tdist_ < hmin_) {
    goto _l714;
  }
  if (info_[7] == 0) {
    goto _l310;
  }
  ho_ = rwork_[2];
  if (((*tout_) - (*t_)) * ho_ < 0.0e0) {
    goto _l711;
  }
  if (ho_ == 0.0e0) {
    goto _l712;
  }
  goto _l320;
  _l310:;
  ho_ = 0.001e0 * tdist_;
  ypnorm_ = _sdanrm (neq_, yprime_, &rwork_[lwt_ - 1], rpar_, ipar_);
  if (ypnorm_ > 0.5e0 / ho_) {
    ho_ = 0.5e0 / ypnorm_;
  }
  ho_ = _sign (ho_, (*tout_) - (*t_));
  _l320:;
  if (info_[6] == 0) {
    goto _l330;
  }
  rh_ = _abs (ho_) / rwork_[1];
  if (rh_ > 1.0e0) {
    ho_ = ho_ / rh_;
  }
  _l330:;
  if (info_[3] == 0) {
    goto _l340;
  }
  tstop_ = rwork_[0];
  if ((tstop_ - (*t_)) * ho_ < 0.0e0) {
    goto _l715;
  }
  if (((*t_) + ho_ - tstop_) * ho_ > 0.0e0) {
    ho_ = tstop_ - (*t_);
  }
  if ((tstop_ - (*tout_)) * ho_ < 0.0e0) {
    goto _l709;
  }
  _l340:;
  if (info_[10] == 0) {
    goto _l350;
  }
  (void) _sdaini (&tn_, y_, yprime_, neq_, _res, _jac, &ho_, &rwork_[lwt_ - 1], idid_, rpar_, ipar_, &rwork_[lphi_ - 1], 
  &rwork_[40], &rwork_[le_ - 1], &rwork_[lwm_ - 1], &iwork_[0], &hmin_, &rwork_[8], &info_[9], &ntemp_);
  if ((*idid_) < 0) {
    goto _l390;
  }
  _l350:;
  h_ = ho_;
  rwork_[2] = h_;
  itemp_ = lphi_ + (*neq_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    rwork_[lphi_ + i_ - 1 - 1] = y_[i_ - 1];
    rwork_[itemp_ + i_ - 1 - 1] = h_ * yprime_[i_ - 1];
  }
  _l390:;
  goto _l500;
  _l400:;
  uround_ = rwork_[8];
  done_ = FALSE;
  tn_ = rwork_[3];
  h_ = rwork_[2];
  if (info_[6] == 0) {
    goto _l410;
  }
  rh_ = _abs (h_) / rwork_[1];
  if (rh_ > 1.0e0) {
    h_ = h_ / rh_;
  }
  _l410:;
  if ((*t_) == (*tout_)) {
    goto _l719;
  }
  if (((*t_) - (*tout_)) * h_ > 0.0e0) {
    goto _l711;
  }
  if (info_[3] == 1) {
    goto _l430;
  }
  if (info_[2] == 1) {
    goto _l420;
  }
  if ((tn_ - (*tout_)) * h_ < 0.0e0) {
    goto _l490;
  }
  (void) _sdatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  done_ = TRUE;
  goto _l490;
  _l420:;
  if ((tn_ - (*t_)) * h_ <= 0.0e0) {
    goto _l490;
  }
  if ((tn_ - (*tout_)) * h_ > 0.0e0) {
    goto _l425;
  }
  (void) _sdatrp (&tn_, &tn_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = tn_;
  (*idid_) = 1;
  done_ = TRUE;
  goto _l490;
  _l425:;
  (void) _sdatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  done_ = TRUE;
  goto _l490;
  _l430:;
  if (info_[2] == 1) {
    goto _l440;
  }
  tstop_ = rwork_[0];
  if ((tn_ - tstop_) * h_ > 0.0e0) {
    goto _l715;
  }
  if ((tstop_ - (*tout_)) * h_ < 0.0e0) {
    goto _l709;
  }
  if ((tn_ - (*tout_)) * h_ < 0.0e0) {
    goto _l450;
  }
  (void) _sdatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  done_ = TRUE;
  goto _l490;
  _l440:;
  tstop_ = rwork_[0];
  if ((tn_ - tstop_) * h_ > 0.0e0) {
    goto _l715;
  }
  if ((tstop_ - (*tout_)) * h_ < 0.0e0) {
    goto _l709;
  }
  if ((tn_ - (*t_)) * h_ <= 0.0e0) {
    goto _l450;
  }
  if ((tn_ - (*tout_)) * h_ > 0.0e0) {
    goto _l445;
  }
  (void) _sdatrp (&tn_, &tn_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = tn_;
  (*idid_) = 1;
  done_ = TRUE;
  goto _l490;
  _l445:;
  (void) _sdatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  done_ = TRUE;
  goto _l490;
  _l450:;
  if (_abs (tn_ - tstop_) > 100.0e0 * uround_ * (_abs (tn_) + _abs (h_))) {
    goto _l460;
  }
  (void) _sdatrp (&tn_, &tstop_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 2;
  (*t_) = tstop_;
  done_ = TRUE;
  goto _l490;
  _l460:;
  tnext_ = tn_ + h_;
  if ((tnext_ - tstop_) * h_ <= 0.0e0) {
    goto _l490;
  }
  h_ = tstop_ - tn_;
  rwork_[2] = h_;
  _l490:;
  if (done_) {
    goto _l580;
  }
  _l500:;
  if ((*idid_) == -12) {
    goto _l527;
  }
  if ((iwork_[10] - iwork_[9]) < 500) {
    goto _l510;
  }
  (*idid_) = -1;
  goto _l527;
  _l510:;
  (void) _sdawts (neq_, &info_[1], rtol_, atol_, &rwork_[lphi_ - 1], &rwork_[lwt_ - 1], rpar_, ipar_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if (rwork_[i_ + lwt_ - 1 - 1] > 0.0e0) {
      goto _l520;
    }
    (*idid_) = -3;
    goto _l527;
    _l520:;
  }
  r_ = _sdanrm (neq_, &rwork_[lphi_ - 1], &rwork_[lwt_ - 1], rpar_, ipar_) * 100.0e0 * uround_;
  if (r_ <= 1.0e0) {
    goto _l525;
  }
  if (info_[1] == 1) {
    goto _l523;
  }
  rtol_[0] = r_ * rtol_[0];
  atol_[0] = r_ * atol_[0];
  (*idid_) = -2;
  goto _l527;
  _l523:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    rtol_[i_ - 1] = r_ * rtol_[i_ - 1];
    atol_[i_ - 1] = r_ * atol_[i_ - 1];
  }
  (*idid_) = -2;
  goto _l527;
  _l525:;
  hmin_ = 4.0e0 * uround_ * _max (_abs (tn_), _abs ((*tout_)));
  if (info_[6] != 0) {
    rh_ = _abs (h_) / rwork_[1];
    if (rh_ > 1.0e0) {
      h_ = h_ / rh_;
    }
  }
  (void) _sdastp (&tn_, y_, yprime_, neq_, _res, _jac, &h_, &rwork_[lwt_ - 1], &info_[0], idid_, rpar_, ipar_, 
  &rwork_[lphi_ - 1], &rwork_[40], &rwork_[le_ - 1], &rwork_[lwm_ - 1], &iwork_[0], &rwork_[10], &rwork_[16], 
  &rwork_[22], &rwork_[28], &rwork_[34], &rwork_[4], &rwork_[5], &rwork_[6], &rwork_[7], &hmin_, &rwork_[8], &iwork_[5], 
  &iwork_[4], &iwork_[6], &iwork_[7], &iwork_[8], &info_[9], &ntemp_);
  _l527:;
  if ((*idid_) < 0) {
    goto _l600;
  }
  if (info_[3] != 0) {
    goto _l540;
  }
  if (info_[2] != 0) {
    goto _l530;
  }
  if ((tn_ - (*tout_)) * h_ < 0.0e0) {
    goto _l500;
  }
  (void) _sdatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 3;
  (*t_) = (*tout_);
  goto _l580;
  _l530:;
  if ((tn_ - (*tout_)) * h_ >= 0.0e0) {
    goto _l535;
  }
  (*t_) = tn_;
  (*idid_) = 1;
  goto _l580;
  _l535:;
  (void) _sdatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 3;
  (*t_) = (*tout_);
  goto _l580;
  _l540:;
  if (info_[2] != 0) {
    goto _l550;
  }
  if ((tn_ - (*tout_)) * h_ < 0.0e0) {
    goto _l542;
  }
  (void) _sdatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  goto _l580;
  _l542:;
  if (_abs (tn_ - tstop_) <= 100.0e0 * uround_ * (_abs (tn_) + _abs (h_))) {
    goto _l545;
  }
  tnext_ = tn_ + h_;
  if ((tnext_ - tstop_) * h_ <= 0.0e0) {
    goto _l500;
  }
  h_ = tstop_ - tn_;
  goto _l500;
  _l545:;
  (void) _sdatrp (&tn_, &tstop_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 2;
  (*t_) = tstop_;
  goto _l580;
  _l550:;
  if ((tn_ - (*tout_)) * h_ >= 0.0e0) {
    goto _l555;
  }
  if (_abs (tn_ - tstop_) <= 100.0e0 * uround_ * (_abs (tn_) + _abs (h_))) {
    goto _l552;
  }
  (*t_) = tn_;
  (*idid_) = 1;
  goto _l580;
  _l552:;
  (void) _sdatrp (&tn_, &tstop_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*idid_) = 2;
  (*t_) = tstop_;
  goto _l580;
  _l555:;
  (void) _sdatrp (&tn_, tout_, y_, yprime_, neq_, &iwork_[7], &rwork_[lphi_ - 1], &rwork_[28]);
  (*t_) = (*tout_);
  (*idid_) = 3;
  goto _l580;
  _l580:;
  rwork_[3] = tn_;
  rwork_[2] = h_;
  goto _l0;
  _l600:;
  itemp_ = -(*idid_);
  switch (itemp_) {
    default:
    case 1: goto _l610;
    case 2: goto _l620;
    case 3: goto _l630;
    case 4: goto _l690;
    case 5: goto _l690;
    case 6: goto _l640;
    case 7: goto _l650;
    case 8: goto _l660;
    case 9: goto _l670;
    case 10: goto _l675;
    case 11: goto _l680;
    case 12: goto _l685;
  }
  _l610:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1395", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100276_[__fcnt] != NULL && $f_100276_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100276_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1395", 0));
    __fcnt += 3;
  }
  if ($f_100276_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100276_[__fcnt] != NULL && $f_100276_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100276_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1395", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100276_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1395", 0));
  __fcnt += 3;
  while ($f_100276_[__fcnt] != NULL && $f_100276_[__fcnt] == FMT_TEXT) {
    if ($f_100276_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100276_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1395", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($10_, concat ($9_, concat ($8_, concat ($7_, _dc_5, xern3_), _dc_6), _dc_7), 
  255), $10_), idid_, &_k1);
  goto _l690;
  _l620:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1402", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100279_[__fcnt] != NULL && $f_100279_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100279_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1402", 0));
    __fcnt += 3;
  }
  if ($f_100279_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100279_[__fcnt] != NULL && $f_100279_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100279_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1402", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100279_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1402", 0));
  __fcnt += 3;
  while ($f_100279_[__fcnt] != NULL && $f_100279_[__fcnt] == FMT_TEXT) {
    if ($f_100279_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100279_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1402", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($15_, concat ($14_, concat ($13_, concat ($12_, concat ($11_, _dc_8, xern3_), 
  _dc_9), _dc_10), _dc_11), 511), $15_), idid_, &_k1);
  goto _l690;
  _l630:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1410", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100282_[__fcnt] != NULL && $f_100282_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100282_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1410", 0));
    __fcnt += 3;
  }
  if ($f_100282_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100282_[__fcnt] != NULL && $f_100282_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100282_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1410", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100282_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1410", 0));
  __fcnt += 3;
  while ($f_100282_[__fcnt] != NULL && $f_100282_[__fcnt] == FMT_TEXT) {
    if ($f_100282_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100282_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1410", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($19_, concat ($18_, concat ($17_, concat ($16_, _dc_8, xern3_), _dc_12), 
  _dc_13), 255), $19_), idid_, &_k1);
  goto _l690;
  _l640:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1417", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100285_[__fcnt] != NULL && $f_100285_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100285_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1417", 0));
    __fcnt += 3;
  }
  if ($f_100285_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100285_[__fcnt] != NULL && $f_100285_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100285_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1417", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100285_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1417", 0));
  __fcnt += 3;
  while ($f_100285_[__fcnt] != NULL && $f_100285_[__fcnt] == FMT_TEXT) {
    if ($f_100285_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100285_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1417", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1418", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100286_[__fcnt] != NULL && $f_100286_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100286_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1418", 0));
    __fcnt += 3;
  }
  if ($f_100286_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100286_[__fcnt] != NULL && $f_100286_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100286_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1418", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100286_[__fcnt + 2], &h_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1418", 0));
  __fcnt += 3;
  while ($f_100286_[__fcnt] != NULL && $f_100286_[__fcnt] == FMT_TEXT) {
    if ($f_100286_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100286_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1418", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($24_, concat ($23_, concat ($22_, concat ($21_, concat ($20_, _dc_8, xern3_), 
  _dc_14), xern4_), _dc_15), 511), $24_), idid_, &_k1);
  goto _l690;
  _l650:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1426", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100289_[__fcnt] != NULL && $f_100289_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100289_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1426", 0));
    __fcnt += 3;
  }
  if ($f_100289_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100289_[__fcnt] != NULL && $f_100289_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100289_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1426", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100289_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1426", 0));
  __fcnt += 3;
  while ($f_100289_[__fcnt] != NULL && $f_100289_[__fcnt] == FMT_TEXT) {
    if ($f_100289_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100289_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1426", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1427", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100290_[__fcnt] != NULL && $f_100290_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100290_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1427", 0));
    __fcnt += 3;
  }
  if ($f_100290_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100290_[__fcnt] != NULL && $f_100290_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100290_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1427", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100290_[__fcnt + 2], &h_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1427", 0));
  __fcnt += 3;
  while ($f_100290_[__fcnt] != NULL && $f_100290_[__fcnt] == FMT_TEXT) {
    if ($f_100290_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100290_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1427", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($30_, concat ($29_, concat ($28_, concat ($27_, concat ($26_, concat ($25_, 
  _dc_8, xern3_), _dc_14), xern4_), _dc_16), _dc_17), 1023), $30_), idid_, &_k1);
  goto _l690;
  _l660:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1435", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100293_[__fcnt] != NULL && $f_100293_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100293_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1435", 0));
    __fcnt += 3;
  }
  if ($f_100293_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100293_[__fcnt] != NULL && $f_100293_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100293_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1435", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100293_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1435", 0));
  __fcnt += 3;
  while ($f_100293_[__fcnt] != NULL && $f_100293_[__fcnt] == FMT_TEXT) {
    if ($f_100293_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100293_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1435", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1436", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100294_[__fcnt] != NULL && $f_100294_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100294_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1436", 0));
    __fcnt += 3;
  }
  if ($f_100294_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100294_[__fcnt] != NULL && $f_100294_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100294_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1436", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100294_[__fcnt + 2], &h_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1436", 0));
  __fcnt += 3;
  while ($f_100294_[__fcnt] != NULL && $f_100294_[__fcnt] == FMT_TEXT) {
    if ($f_100294_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100294_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1436", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($35_, concat ($34_, concat ($33_, concat ($32_, concat ($31_, _dc_8, xern3_), 
  _dc_14), xern4_), _dc_18), 511), $35_), idid_, &_k1);
  goto _l690;
  _l670:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1443", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100297_[__fcnt] != NULL && $f_100297_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100297_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1443", 0));
    __fcnt += 3;
  }
  if ($f_100297_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100297_[__fcnt] != NULL && $f_100297_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100297_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1443", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100297_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1443", 0));
  __fcnt += 3;
  while ($f_100297_[__fcnt] != NULL && $f_100297_[__fcnt] == FMT_TEXT) {
    if ($f_100297_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100297_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1443", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1444", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100298_[__fcnt] != NULL && $f_100298_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100298_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1444", 0));
    __fcnt += 3;
  }
  if ($f_100298_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100298_[__fcnt] != NULL && $f_100298_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100298_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1444", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100298_[__fcnt + 2], &h_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1444", 0));
  __fcnt += 3;
  while ($f_100298_[__fcnt] != NULL && $f_100298_[__fcnt] == FMT_TEXT) {
    if ($f_100298_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100298_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1444", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($41_, concat ($40_, concat ($39_, concat ($38_, concat ($37_, concat ($36_, 
  _dc_8, xern3_), _dc_14), xern4_), _dc_19), _dc_20), 1023), $41_), idid_, &_k1);
  goto _l690;
  _l675:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1452", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100301_[__fcnt] != NULL && $f_100301_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100301_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1452", 0));
    __fcnt += 3;
  }
  if ($f_100301_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100301_[__fcnt] != NULL && $f_100301_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100301_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1452", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100301_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1452", 0));
  __fcnt += 3;
  while ($f_100301_[__fcnt] != NULL && $f_100301_[__fcnt] == FMT_TEXT) {
    if ($f_100301_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100301_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1452", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1453", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100302_[__fcnt] != NULL && $f_100302_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100302_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1453", 0));
    __fcnt += 3;
  }
  if ($f_100302_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100302_[__fcnt] != NULL && $f_100302_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100302_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1453", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100302_[__fcnt + 2], &h_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1453", 0));
  __fcnt += 3;
  while ($f_100302_[__fcnt] != NULL && $f_100302_[__fcnt] == FMT_TEXT) {
    if ($f_100302_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100302_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1453", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($47_, concat ($46_, concat ($45_, concat ($44_, concat ($43_, concat ($42_, 
  _dc_8, xern3_), _dc_14), xern4_), _dc_21), _dc_22), 1023), $47_), idid_, &_k1);
  goto _l690;
  _l680:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1461", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100305_[__fcnt] != NULL && $f_100305_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100305_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1461", 0));
    __fcnt += 3;
  }
  if ($f_100305_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100305_[__fcnt] != NULL && $f_100305_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100305_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1461", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100305_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1461", 0));
  __fcnt += 3;
  while ($f_100305_[__fcnt] != NULL && $f_100305_[__fcnt] == FMT_TEXT) {
    if ($f_100305_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100305_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1461", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1462", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1462", 0));
    __fcnt += 3;
  }
  if ($f_100306_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1462", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100306_[__fcnt + 2], &h_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1462", 0));
  __fcnt += 3;
  while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
    if ($f_100306_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1462", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($52_, concat ($51_, concat ($50_, concat ($49_, concat ($48_, _dc_8, xern3_), 
  _dc_14), xern4_), _dc_23), 511), $52_), idid_, &_k1);
  goto _l690;
  _l685:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1469", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100309_[__fcnt] != NULL && $f_100309_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100309_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1469", 0));
    __fcnt += 3;
  }
  if ($f_100309_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100309_[__fcnt] != NULL && $f_100309_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100309_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1469", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100309_[__fcnt + 2], &tn_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1469", 0));
  __fcnt += 3;
  while ($f_100309_[__fcnt] != NULL && $f_100309_[__fcnt] == FMT_TEXT) {
    if ($f_100309_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100309_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1469", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1470", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100310_[__fcnt] != NULL && $f_100310_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100310_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1470", 0));
    __fcnt += 3;
  }
  if ($f_100310_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100310_[__fcnt] != NULL && $f_100310_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100310_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1470", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100310_[__fcnt + 2], &ho_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1470", 0));
  __fcnt += 3;
  while ($f_100310_[__fcnt] != NULL && $f_100310_[__fcnt] == FMT_TEXT) {
    if ($f_100310_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100310_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1470", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($57_, concat ($56_, concat ($55_, concat ($54_, concat ($53_, _dc_8, xern3_), 
  _dc_14), xern4_), _dc_24), 511), $57_), idid_, &_k1);
  goto _l690;
  _l690:;
  info_[0] = -1;
  (*t_) = tn_;
  rwork_[3] = tn_;
  rwork_[2] = h_;
  goto _l0;
  _l701:;
  (void) _xermsg (_dc_0, _dc_54, _dc_25, &_k1, &_k1);
  goto _l750;
  _l702:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1495", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100321_[__fcnt] != NULL && $f_100321_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100321_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1495", 0));
    __fcnt += 3;
  }
  if ($f_100321_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100321_[__fcnt] != NULL && $f_100321_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100321_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1495", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100321_[__fcnt + 2], &(*neq_), INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1495", 0));
  __fcnt += 3;
  while ($f_100321_[__fcnt] != NULL && $f_100321_[__fcnt] == FMT_TEXT) {
    if ($f_100321_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100321_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1495", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($60_, concat ($59_, concat ($58_, _dc_26, xern1_), _dc_27), 63), $60_), ($61_ = 
  2, &$61_), &_k1);
  goto _l750;
  _l703:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1500", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100324_[__fcnt] != NULL && $f_100324_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100324_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1500", 0));
    __fcnt += 3;
  }
  if ($f_100324_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100324_[__fcnt] != NULL && $f_100324_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100324_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1500", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100324_[__fcnt + 2], &mxord_, INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1500", 0));
  __fcnt += 3;
  while ($f_100324_[__fcnt] != NULL && $f_100324_[__fcnt] == FMT_TEXT) {
    if ($f_100324_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100324_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1500", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($64_, concat ($63_, concat ($62_, _dc_28, xern1_), _dc_29), 63), $64_), ($65_ = 
  3, &$65_), &_k1);
  goto _l750;
  _l704:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1505", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1505", 0));
    __fcnt += 3;
  }
  if ($f_100327_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1505", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100327_[__fcnt + 2], &lenrw_, INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1505", 0));
  __fcnt += 3;
  while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
    if ($f_100327_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1505", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern2_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1506", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100328_[__fcnt] != NULL && $f_100328_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100328_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1506", 0));
    __fcnt += 3;
  }
  if ($f_100328_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100328_[__fcnt] != NULL && $f_100328_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100328_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1506", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100328_[__fcnt + 2], &(*lrw_), INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1506", 0));
  __fcnt += 3;
  while ($f_100328_[__fcnt] != NULL && $f_100328_[__fcnt] == FMT_TEXT) {
    if ($f_100328_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100328_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1506", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($69_, concat ($68_, concat ($67_, concat ($66_, _dc_30, xern1_), _dc_31), 
  xern2_), 255), $69_), ($70_ = 4, &$70_), &_k1);
  goto _l750;
  _l705:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1512", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1512", 0));
    __fcnt += 3;
  }
  if ($f_100331_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1512", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100331_[__fcnt + 2], &leniw_, INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1512", 0));
  __fcnt += 3;
  while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
    if ($f_100331_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1512", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern2_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1513", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100332_[__fcnt] != NULL && $f_100332_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100332_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1513", 0));
    __fcnt += 3;
  }
  if ($f_100332_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100332_[__fcnt] != NULL && $f_100332_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100332_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1513", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100332_[__fcnt + 2], &(*liw_), INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1513", 0));
  __fcnt += 3;
  while ($f_100332_[__fcnt] != NULL && $f_100332_[__fcnt] == FMT_TEXT) {
    if ($f_100332_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100332_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1513", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($74_, concat ($73_, concat ($72_, concat ($71_, _dc_32, xern1_), _dc_33), 
  xern2_), 255), $74_), ($75_ = 5, &$75_), &_k1);
  goto _l750;
  _l706:;
  (void) _xermsg (_dc_0, _dc_54, _dc_34, ($76_ = 6, &$76_), &_k1);
  goto _l750;
  _l707:;
  (void) _xermsg (_dc_0, _dc_54, _dc_35, ($77_ = 7, &$77_), &_k1);
  goto _l750;
  _l708:;
  (void) _xermsg (_dc_0, _dc_54, _dc_36, ($78_ = 8, &$78_), &_k1);
  goto _l750;
  _l709:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1531", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1531", 0));
    __fcnt += 3;
  }
  if ($f_100341_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1531", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100341_[__fcnt + 2], &tstop_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1531", 0));
  __fcnt += 3;
  while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
    if ($f_100341_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1531", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1532", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1532", 0));
    __fcnt += 3;
  }
  if ($f_100342_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1532", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100342_[__fcnt + 2], &(*tout_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1532", 0));
  __fcnt += 3;
  while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
    if ($f_100342_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1532", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($82_, concat ($81_, concat ($80_, concat ($79_, _dc_37, xern3_), _dc_38), 
  xern4_), 255), $82_), ($83_ = 9, &$83_), &_k1);
  goto _l750;
  _l710:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1538", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100345_[__fcnt] != NULL && $f_100345_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100345_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1538", 0));
    __fcnt += 3;
  }
  if ($f_100345_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100345_[__fcnt] != NULL && $f_100345_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100345_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1538", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100345_[__fcnt + 2], &hmax_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1538", 0));
  __fcnt += 3;
  while ($f_100345_[__fcnt] != NULL && $f_100345_[__fcnt] == FMT_TEXT) {
    if ($f_100345_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100345_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1538", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($86_, concat ($85_, concat ($84_, _dc_39, xern3_), _dc_40), 127), $86_), ($87_ 
  = 10, &$87_), &_k1);
  goto _l750;
  _l711:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1543", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1543", 0));
    __fcnt += 3;
  }
  if ($f_100348_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1543", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100348_[__fcnt + 2], &(*tout_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1543", 0));
  __fcnt += 3;
  while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
    if ($f_100348_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1543", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1544", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100349_[__fcnt] != NULL && $f_100349_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100349_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1544", 0));
    __fcnt += 3;
  }
  if ($f_100349_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100349_[__fcnt] != NULL && $f_100349_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100349_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1544", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100349_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1544", 0));
  __fcnt += 3;
  while ($f_100349_[__fcnt] != NULL && $f_100349_[__fcnt] == FMT_TEXT) {
    if ($f_100349_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100349_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1544", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($91_, concat ($90_, concat ($89_, concat ($88_, _dc_41, xern3_), _dc_42), 
  xern4_), 255), $91_), ($92_ = 11, &$92_), &_k1);
  goto _l750;
  _l712:;
  (void) _xermsg (_dc_0, _dc_54, _dc_43, ($93_ = 12, &$93_), &_k1);
  goto _l750;
  _l713:;
  (void) _xermsg (_dc_0, _dc_54, _dc_44, ($94_ = 13, &$94_), &_k1);
  goto _l750;
  _l714:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1557", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100356_[__fcnt] != NULL && $f_100356_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100356_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1557", 0));
    __fcnt += 3;
  }
  if ($f_100356_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100356_[__fcnt] != NULL && $f_100356_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100356_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1557", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100356_[__fcnt + 2], &(*tout_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1557", 0));
  __fcnt += 3;
  while ($f_100356_[__fcnt] != NULL && $f_100356_[__fcnt] == FMT_TEXT) {
    if ($f_100356_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100356_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1557", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1558", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100357_[__fcnt] != NULL && $f_100357_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100357_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1558", 0));
    __fcnt += 3;
  }
  if ($f_100357_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100357_[__fcnt] != NULL && $f_100357_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100357_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1558", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100357_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1558", 0));
  __fcnt += 3;
  while ($f_100357_[__fcnt] != NULL && $f_100357_[__fcnt] == FMT_TEXT) {
    if ($f_100357_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100357_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1558", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($99_, concat ($98_, concat ($97_, concat ($96_, concat ($95_, _dc_41, xern3_), 
  _dc_45), xern4_), _dc_46), 511), $99_), ($100_ = 14, &$100_), &_k1);
  goto _l750;
  _l715:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1564", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100360_[__fcnt] != NULL && $f_100360_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100360_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1564", 0));
    __fcnt += 3;
  }
  if ($f_100360_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100360_[__fcnt] != NULL && $f_100360_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100360_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1564", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100360_[__fcnt + 2], &tstop_, REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1564", 0));
  __fcnt += 3;
  while ($f_100360_[__fcnt] != NULL && $f_100360_[__fcnt] == FMT_TEXT) {
    if ($f_100360_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100360_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1564", 0));
    __fcnt += 3;
  }
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern4_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1565", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100361_[__fcnt] != NULL && $f_100361_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100361_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1565", 0));
    __fcnt += 3;
  }
  if ($f_100361_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100361_[__fcnt] != NULL && $f_100361_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100361_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1565", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100361_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1565", 0));
  __fcnt += 3;
  while ($f_100361_[__fcnt] != NULL && $f_100361_[__fcnt] == FMT_TEXT) {
    if ($f_100361_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100361_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1565", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($104_, concat ($103_, concat ($102_, concat ($101_, _dc_47, xern3_), _dc_42), 
  xern4_), 255), $104_), ($105_ = 15, &$105_), &_k1);
  goto _l750;
  _l717:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1571", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100364_[__fcnt] != NULL && $f_100364_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100364_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1571", 0));
    __fcnt += 3;
  }
  if ($f_100364_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100364_[__fcnt] != NULL && $f_100364_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100364_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1571", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100364_[__fcnt + 2], &iwork_[0], INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1571", 0));
  __fcnt += 3;
  while ($f_100364_[__fcnt] != NULL && $f_100364_[__fcnt] == FMT_TEXT) {
    if ($f_100364_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100364_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1571", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($108_, concat ($107_, concat ($106_, _dc_48, xern1_), _dc_49), 127), $108_), 
  ($109_ = 17, &$109_), &_k1);
  goto _l750;
  _l718:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
  _ffile[0].lrecl = 15;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern1_, 15, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1577", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100367_[__fcnt] != NULL && $f_100367_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100367_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1577", 0));
    __fcnt += 3;
  }
  if ($f_100367_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100367_[__fcnt] != NULL && $f_100367_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100367_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1577", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100367_[__fcnt + 2], &iwork_[1], INTEGER, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1577", 0));
  __fcnt += 3;
  while ($f_100367_[__fcnt] != NULL && $f_100367_[__fcnt] == FMT_TEXT) {
    if ($f_100367_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100367_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1577", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($112_, concat ($111_, concat ($110_, _dc_50, xern1_), _dc_49), 127), $112_), 
  ($113_ = 18, &$113_), &_k1);
  goto _l750;
  _l719:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (xern3_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-dassl:sdassl:1583", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100370_[__fcnt] != NULL && $f_100370_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100370_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1583", 0));
    __fcnt += 3;
  }
  if ($f_100370_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100370_[__fcnt] != NULL && $f_100370_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100370_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1583", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100370_[__fcnt + 2], &(*tout_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1583", 0));
  __fcnt += 3;
  while ($f_100370_[__fcnt] != NULL && $f_100370_[__fcnt] == FMT_TEXT) {
    if ($f_100370_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100370_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-dassl:sdassl:1583", 0));
    __fcnt += 3;
  }
  (void) _xermsg (_dc_0, _dc_54, (bufcpy ($115_, concat ($114_, _dc_51, xern3_), 63), $115_), ($116_ = 19, &$116_), &_k1)
  ;
  goto _l750;
  _l750:;
  (*idid_) = -33;
  if (info_[0] == -1) {
    (void) _xermsg (_dc_0, _dc_54, concat ($117_, _dc_52, _dc_53), ($118_ = -999, &$118_), ($119_ = 2, &$119_));
  }
  info_[0] = -1;
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _sdastp (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ yprime_, int_4 _p_ neq_, int_4 (*_res)(), int_4 (*_jac)(), 
real_4 _p_ h_, real_4 _p_ wt_, int_4 _p_ jstart_, int_4 _p_ idid_, real_4 _p_ rpar_, int_4 _p_ ipar_, real_4 _p_ phi_, 
real_4 _p_ delta_, real_4 _p_ e_, real_4 _p_ wm_, int_4 _p_ iwm_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ 
gamma_, real_4 _p_ psi_, real_4 _p_ sigma_, real_4 _p_ cj_, real_4 _p_ cjold_, real_4 _p_ hold_, real_4 _p_ s_, real_4 
_p_ hmin_, real_4 _p_ uround_, int_4 _p_ iphase_, int_4 _p_ jcalc_, int_4 _p_ k_, int_4 _p_ kold_, int_4 _p_ ns_, int_4 
_p_ nonneg_, int_4 _p_ ntemp_)
{
  static int_4 i_, ier_, ires_, j_, j1_, kdiff_, km1_, knew_, kp1_, kp2_, m_, maxit_, ncf_, nef_, nsf_, nsp1_;
  static logical_4 convgd_;
  static real_4 alpha0_, alphas_, cjlast_, ck_, delnrm_, enorm_, erk_, erkm1_, erkm2_, erkp1_, err_, est_, hnew_, oldnrm_
  , pnorm_, r_, rate_, temp1_, temp2_, terk_, terkm1_, terkm2_, terkp1_, xold_, xrate_;
  int_4 _data_k_8, _data_k_9;
#define _data_n_8 1
  static int_4 _data_l_8[_data_n_8] = {
    4
  };
#define _data_n_9 1
  static real_4 _data_l_9[_data_n_9] = {
    0.25e0
  };
  if (__calls[13].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    maxit_ = _data_l_8[_data_k_8++];
  }
  if (__calls[13].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    xrate_ = _data_l_9[_data_k_9++];
  }
  (*idid_) = 1;
  xold_ = (*x_);
  ncf_ = 0;
  nsf_ = 0;
  nef_ = 0;
  if ((*jstart_) != 0) {
    goto _l120;
  }
  iwm_[13] = 0;
  iwm_[14] = 0;
  (*k_) = 1;
  (*kold_) = 0;
  (*hold_) = 0.0;
  (*jstart_) = 1;
  psi_[0] = (*h_);
  (*cjold_) = 1.0e0 / (*h_);
  (*cj_) = (*cjold_);
  (*s_) = 100.0;
  (*jcalc_) = -1;
  delnrm_ = 1.0;
  (*iphase_) = 0;
  (*ns_) = 0;
  _l120:;
  _l200:;
  kp1_ = (*k_) + 1;
  kp2_ = (*k_) + 2;
  km1_ = (*k_) - 1;
  xold_ = (*x_);
  if ((*h_) != (*hold_) || (*k_) != (*kold_)) {
    (*ns_) = 0;
  }
  (*ns_) = _min ((*ns_) + 1, (*kold_) + 2);
  nsp1_ = (*ns_) + 1;
  if (kp1_ < (*ns_)) {
    goto _l230;
  }
  beta_[0] = 1.0;
  alpha_[0] = 1.0;
  temp1_ = (*h_);
  gamma_[0] = 0.0;
  sigma_[0] = 1.0;
  for (i_ = 2; i_ <= kp1_; (i_)++) {
    temp2_ = psi_[i_ - 1 - 1];
    psi_[i_ - 1 - 1] = temp1_;
    beta_[i_ - 1] = beta_[i_ - 1 - 1] * psi_[i_ - 1 - 1] / temp2_;
    temp1_ = temp2_ + (*h_);
    alpha_[i_ - 1] = (*h_) / temp1_;
    sigma_[i_ - 1] = (i_ - 1) * sigma_[i_ - 1 - 1] * alpha_[i_ - 1];
    gamma_[i_ - 1] = gamma_[i_ - 1 - 1] + alpha_[i_ - 1 - 1] / (*h_);
  }
  psi_[kp1_ - 1] = temp1_;
  _l230:;
  alphas_ = 0.0;
  alpha0_ = 0.0;
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    alphas_ = alphas_ - 1.0e0 / i_;
    alpha0_ = alpha0_ - alpha_[i_ - 1];
  }
  cjlast_ = (*cj_);
  (*cj_) = -alphas_ / (*h_);
  ck_ = _abs (alpha_[kp1_ - 1] + alphas_ - alpha0_);
  ck_ = _max (ck_, alpha_[kp1_ - 1]);
  temp1_ = (1.0e0 - xrate_) / (1.0e0 + xrate_);
  temp2_ = 1.0e0 / temp1_;
  if ((*cj_) / (*cjold_) < temp1_ || (*cj_) / (*cjold_) > temp2_) {
    (*jcalc_) = -1;
  }
  if ((*cj_) != cjlast_) {
    (*s_) = 100.0;
  }
  if (kp1_ < nsp1_) {
    goto _l280;
  }
  for (j_ = nsp1_; j_ <= kp1_; (j_)++) {
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))] = beta_[j_ - 1] * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
    }
  }
  _l280:;
  (*x_) = (*x_) + (*h_);
  _l300:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((0))];
    yprime_[i_ - 1] = 0.0;
  }
  for (j_ = 2; j_ <= kp1_; (j_)++) {
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      y_[i_ - 1] = y_[i_ - 1] + phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
      yprime_[i_ - 1] = yprime_[i_ - 1] + gamma_[j_ - 1] * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
    }
  }
  pnorm_ = _sdanrm (neq_, y_, wt_, rpar_, ipar_);
  convgd_ = TRUE;
  m_ = 0;
  iwm_[11] = iwm_[11] + 1;
  ires_ = 0;
  (void) _res (x_, y_, yprime_, delta_, &ires_, rpar_, ipar_);
  if (ires_ < 0) {
    goto _l380;
  }
  if ((*jcalc_) != -1) {
    goto _l340;
  }
  iwm_[12] = iwm_[12] + 1;
  (*jcalc_) = 0;
  (void) _sdajac (neq_, x_, y_, yprime_, delta_, cj_, h_, &ier_, wt_, e_, wm_, iwm_, _res, &ires_, uround_, _jac, rpar_, 
  ipar_, ntemp_);
  (*cjold_) = (*cj_);
  (*s_) = 100.0;
  if (ires_ < 0) {
    goto _l380;
  }
  if (ier_ != 0) {
    goto _l380;
  }
  nsf_ = 0;
  _l340:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    e_[i_ - 1] = 0.0;
  }
  _l350:;
  temp1_ = 2.0e0 / (1.0e0 + (*cj_) / (*cjold_));
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = delta_[i_ - 1] * temp1_;
  }
  (void) _sdaslv (neq_, delta_, wm_, iwm_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] - delta_[i_ - 1];
    e_[i_ - 1] = e_[i_ - 1] - delta_[i_ - 1];
    yprime_[i_ - 1] = yprime_[i_ - 1] - (*cj_) * delta_[i_ - 1];
  }
  delnrm_ = _sdanrm (neq_, delta_, wt_, rpar_, ipar_);
  if (delnrm_ <= 100.0e0 * (*uround_) * pnorm_) {
    goto _l375;
  }
  if (m_ > 0) {
    goto _l365;
  }
  oldnrm_ = delnrm_;
  goto _l367;
  _l365:;
  rate_ = powl ((delnrm_ / oldnrm_), (1.0e0 / m_));
  if (rate_ > 0.9e0) {
    goto _l370;
  }
  (*s_) = rate_ / (1.0e0 - rate_);
  _l367:;
  if ((*s_) * delnrm_ <= 0.33e0) {
    goto _l375;
  }
  m_ = m_ + 1;
  if (m_ >= maxit_) {
    goto _l370;
  }
  iwm_[11] = iwm_[11] + 1;
  ires_ = 0;
  (void) _res (x_, y_, yprime_, delta_, &ires_, rpar_, ipar_);
  if (ires_ < 0) {
    goto _l380;
  }
  goto _l350;
  _l370:;
  if ((*jcalc_) == 0) {
    goto _l380;
  }
  (*jcalc_) = -1;
  goto _l300;
  _l375:;
  if ((*nonneg_) == 0) {
    goto _l390;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = _min (y_[i_ - 1], 0.0);
  }
  delnrm_ = _sdanrm (neq_, delta_, wt_, rpar_, ipar_);
  if (delnrm_ > 0.33e0) {
    goto _l380;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    e_[i_ - 1] = e_[i_ - 1] - delta_[i_ - 1];
  }
  goto _l390;
  _l380:;
  convgd_ = FALSE;
  _l390:;
  (*jcalc_) = 1;
  if (! (convgd_)) {
    goto _l600;
  }
  enorm_ = _sdanrm (neq_, e_, wt_, rpar_, ipar_);
  erk_ = sigma_[(*k_) + 1 - 1] * enorm_;
  terk_ = ((*k_) + 1) * erk_;
  est_ = erk_;
  knew_ = (*k_);
  if ((*k_) == 1) {
    goto _l430;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((kp1_ - 1))] + e_[i_ - 1];
  }
  erkm1_ = sigma_[(*k_) - 1] * _sdanrm (neq_, delta_, wt_, rpar_, ipar_);
  terkm1_ = (*k_) * erkm1_;
  if ((*k_) > 2) {
    goto _l410;
  }
  if (terkm1_ <= 0.5e0 * terk_) {
    goto _l420;
  }
  goto _l430;
  _l410:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * (((*k_) - 1))] + delta_[i_ - 1];
  }
  erkm2_ = sigma_[(*k_) - 1 - 1] * _sdanrm (neq_, delta_, wt_, rpar_, ipar_);
  terkm2_ = ((*k_) - 1) * erkm2_;
  if (_max (terkm1_, terkm2_) > terk_) {
    goto _l430;
  }
  _l420:;
  knew_ = (*k_) - 1;
  est_ = erkm1_;
  _l430:;
  err_ = ck_ * enorm_;
  if (err_ > 1.0e0) {
    goto _l600;
  }
  (*idid_) = 1;
  iwm_[10] = iwm_[10] + 1;
  kdiff_ = (*k_) - (*kold_);
  (*kold_) = (*k_);
  (*hold_) = (*h_);
  if (knew_ == km1_ || (*k_) == iwm_[2]) {
    (*iphase_) = 1;
  }
  if ((*iphase_) == 0) {
    goto _l545;
  }
  if (knew_ == km1_) {
    goto _l540;
  }
  if ((*k_) == iwm_[2]) {
    goto _l550;
  }
  if (kp1_ >= (*ns_) || kdiff_ == 1) {
    goto _l550;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    delta_[i_ - 1] = e_[i_ - 1] - phi_[i_ - 1 + ((*neq_)) * ((kp2_ - 1))];
  }
  erkp1_ = (1.0e0 / ((*k_) + 2)) * _sdanrm (neq_, delta_, wt_, rpar_, ipar_);
  terkp1_ = ((*k_) + 2) * erkp1_;
  if ((*k_) > 1) {
    goto _l520;
  }
  if (terkp1_ >= 0.5e0 * terk_) {
    goto _l550;
  }
  goto _l530;
  _l520:;
  if (terkm1_ <= _min (terk_, terkp1_)) {
    goto _l540;
  }
  if (terkp1_ >= terk_ || (*k_) == iwm_[2]) {
    goto _l550;
  }
  _l530:;
  (*k_) = kp1_;
  est_ = erkp1_;
  goto _l550;
  _l540:;
  (*k_) = km1_;
  est_ = erkm1_;
  goto _l550;
  _l545:;
  (*k_) = kp1_;
  hnew_ = (*h_) * 2.0e0;
  (*h_) = hnew_;
  goto _l575;
  _l550:;
  hnew_ = (*h_);
  temp2_ = (*k_) + 1;
  r_ = powl ((2.0e0 * est_ + 0.0001e0), (-1.0e0 / temp2_));
  if (r_ < 2.0e0) {
    goto _l555;
  }
  hnew_ = 2.0e0 * (*h_);
  goto _l560;
  _l555:;
  if (r_ > 1.0e0) {
    goto _l560;
  }
  r_ = _max (0.5, _min (0.9, r_));
  hnew_ = (*h_) * r_;
  _l560:;
  (*h_) = hnew_;
  _l575:;
  if ((*kold_) == iwm_[2]) {
    goto _l585;
  }
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    phi_[i_ - 1 + ((*neq_)) * ((kp2_ - 1))] = e_[i_ - 1];
  }
  _l585:;
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    phi_[i_ - 1 + ((*neq_)) * ((kp1_ - 1))] = phi_[i_ - 1 + ((*neq_)) * ((kp1_ - 1))] + e_[i_ - 1];
  }
  for (j1_ = 2; j1_ <= kp1_; (j1_)++) {
    j_ = kp1_ - j1_ + 1;
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))] = phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))] + phi_[i_ - 1 + ((*neq_)) * ((j_ + 1 - 
      1))];
    }
  }
  goto _l0;
  _l600:;
  (*iphase_) = 1;
  (*x_) = xold_;
  if (kp1_ < nsp1_) {
    goto _l630;
  }
  for (j_ = nsp1_; j_ <= kp1_; (j_)++) {
    temp1_ = 1.0e0 / beta_[j_ - 1];
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))] = temp1_ * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
    }
  }
  _l630:;
  for (i_ = 2; i_ <= kp1_; (i_)++) {
    psi_[i_ - 1 - 1] = psi_[i_ - 1] - (*h_);
  }
  if (convgd_) {
    goto _l660;
  }
  iwm_[14] = iwm_[14] + 1;
  if (ier_ == 0) {
    goto _l650;
  }
  nsf_ = nsf_ + 1;
  r_ = 0.25;
  (*h_) = (*h_) * r_;
  if (nsf_ < 3 && _abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -8;
  goto _l675;
  _l650:;
  if (ires_ > -2) {
    goto _l655;
  }
  (*idid_) = -11;
  goto _l675;
  _l655:;
  ncf_ = ncf_ + 1;
  r_ = 0.25;
  (*h_) = (*h_) * r_;
  if (ncf_ < 10 && _abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -7;
  if (ires_ < 0) {
    (*idid_) = -10;
  }
  if (nef_ >= 3) {
    (*idid_) = -9;
  }
  goto _l675;
  _l660:;
  nef_ = nef_ + 1;
  iwm_[13] = iwm_[13] + 1;
  if (nef_ > 1) {
    goto _l665;
  }
  (*k_) = knew_;
  temp2_ = (*k_) + 1;
  r_ = 0.9e0 * powl ((2.0e0 * est_ + 0.0001e0), (-1.0e0 / temp2_));
  r_ = _max (0.25, _min (0.9, r_));
  (*h_) = (*h_) * r_;
  if (_abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -6;
  goto _l675;
  _l665:;
  if (nef_ > 2) {
    goto _l670;
  }
  (*k_) = knew_;
  (*h_) = 0.25e0 * (*h_);
  if (_abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -6;
  goto _l675;
  _l670:;
  (*k_) = 1;
  (*h_) = 0.25e0 * (*h_);
  if (_abs ((*h_)) >= (*hmin_)) {
    goto _l690;
  }
  (*idid_) = -6;
  goto _l675;
  _l675:;
  (void) _sdatrp (x_, x_, y_, yprime_, neq_, k_, phi_, psi_);
  goto _l0;
  _l690:;
  goto _l200;
  _l0:;
  __calls[13].calls++;
  return 0;
}

int_4 _sdatrp (real_4 _p_ x_, real_4 _p_ xout_, real_4 _p_ yout_, real_4 _p_ ypout_, int_4 _p_ neq_, int_4 _p_ kold_, 
real_4 _p_ phi_, real_4 _p_ psi_)
{
  static int_4 i_, j_, koldp1_;
  static real_4 c_, d_, gamma_, temp1_;
  koldp1_ = (*kold_) + 1;
  temp1_ = (*xout_) - (*x_);
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    yout_[i_ - 1] = phi_[i_ - 1 + ((*neq_)) * ((0))];
    ypout_[i_ - 1] = 0.0;
  }
  c_ = 1.0;
  d_ = 0.0;
  gamma_ = temp1_ / psi_[0];
  for (j_ = 2; j_ <= koldp1_; (j_)++) {
    d_ = d_ * gamma_ + c_ / psi_[j_ - 1 - 1];
    c_ = c_ * gamma_;
    gamma_ = (temp1_ + psi_[j_ - 1 - 1]) / psi_[j_ - 1];
    for (i_ = 1; i_ <= (*neq_); (i_)++) {
      yout_[i_ - 1] = yout_[i_ - 1] + c_ * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
      ypout_[i_ - 1] = ypout_[i_ - 1] + d_ * phi_[i_ - 1 + ((*neq_)) * ((j_ - 1))];
    }
  }
  __calls[14].calls++;
  return 0;
}

int_4 _sdawts (int_4 _p_ neq_, int_4 _p_ iwt_, real_4 _p_ rtol_, real_4 _p_ atol_, real_4 _p_ y_, real_4 _p_ wt_, 
real_4 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 i_;
  static real_4 atoli_, rtoli_;
  rtoli_ = rtol_[0];
  atoli_ = atol_[0];
  for (i_ = 1; i_ <= (*neq_); (i_)++) {
    if ((*iwt_) == 0) {
      goto _l10;
    }
    rtoli_ = rtol_[i_ - 1];
    atoli_ = atol_[i_ - 1];
    _l10:;
    wt_[i_ - 1] = rtoli_ * _abs (y_[i_ - 1]) + atoli_;
  }
  __calls[15].calls++;
  return 0;
}

