//! @file mathlib-slatec-depac.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 8 subprograms from SLATEC-DEPAC

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// DDEABM DDERKF DEABM  DERKF  DINTP  DSTEPS SINTRP STEPS

// The license for SLATEC Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "slatec"
#define _dc_1 "ddeabm"
#define _dc_2 "an apparent infinite loop has been detected.$$"
#define _dc_3 "you have made repeated calls at t = "
#define _dc_4 " and the integration has not advanced.  check the "
#define _dc_5 "way you have set parameters for the call to the "
#define _dc_6 "code, particularly info(1)."
#define _dc_7 "the length of the rwork "
#define _dc_8 "array must be at least 130 + 21*neq.$$"
#define _dc_9 "you have called the code with lrw = "
#define _dc_10 "the length of the iwork "
#define _dc_11 "array must be at least 51.$$you have called the code "
#define _dc_12 "with liw = "
#define _dc_13 "dderkf"
#define _dc_14 "you have made repeated calls at  t = "
#define _dc_15 "length of rwork array "
#define _dc_16 "must be at least 30 + 7*neq.  you have called the "
#define _dc_17 "code with lrw = "
#define _dc_18 "length of iwork array "
#define _dc_19 "must be at least 34.  you have called the code with "
#define _dc_20 "liw = "
#define _dc_21 "deabm"
#define _dc_22 "derkf"
#define _dc_23 "must be at least  30 + 7*neq.  you have called the "
#define _dc_24 "code with  lrw = "
#define _dc_25 "must be at least  34.  you have called the code with "
static FORMAT *__fmt_a = NULL;
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
typedef char char_127[128];
typedef char char_255[256];
typedef char char_511[512];
typedef char char_1023[1024];
typedef char char_2047[2048];
#define __ncalls 9
static CALLS __calls[__ncalls] = {
  {"ddeabm", 0}, // subroutine
  {"dderkf", 0}, // subroutine
  {"deabm", 0}, // subroutine
  {"derkf", 0}, // subroutine
  {"dintp", 0}, // subroutine
  {"dsteps", 0}, // subroutine
  {"sintrp", 0}, // subroutine
  {"steps", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _ddeabm (real_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ tout_, int_4 _p_ 
info_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 
_p_ liw_, real_8 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _dderkf (real_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ tout_, int_4 _p_ 
info_, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 
_p_ liw_, real_8 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _deabm (real_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ tout_, int_4 _p_ info_
, real_4 _p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ 
liw_, real_4 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _derkf (real_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ tout_, int_4 _p_ info_
, real_4 _p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ 
liw_, real_4 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _dintp (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ xout_, real_8 _p_ yout_, real_8 _p_ ypout_, int_4 _p_ 
neqn_, int_4 _p_ kold_, real_8 _p_ phi_, int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_8 _p_ gi_, real_8 _p_ 
alpha_, real_8 _p_ og_, real_8 _p_ ow_, real_8 _p_ ox_, real_8 _p_ oy_);
prototype int_4 _dsteps (int_4 (*_df)(), int_4 _p_ neqn_, real_8 _p_ y_, real_8 _p_ x_, real_8 _p_ h_, real_8 _p_ eps_, 
real_8 _p_ wt_, logical_4 _p_ start_, real_8 _p_ hold_, int_4 _p_ k_, int_4 _p_ kold_, logical_4 _p_ crash_, real_8 _p_ 
phi_, real_8 _p_ p_, real_8 _p_ yp_, real_8 _p_ psi_, real_8 _p_ alpha_, real_8 _p_ beta_, real_8 _p_ sig_, real_8 _p_ 
v_, real_8 _p_ w_, real_8 _p_ g_, logical_4 _p_ phase1_, int_4 _p_ ns_, logical_4 _p_ nornd_, int_4 _p_ ksteps_, real_8 
_p_ twou_, real_8 _p_ fouru_, real_8 _p_ xold_, int_4 _p_ kprev_, int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_8 
_p_ gi_, real_8 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _sintrp (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ xout_, real_4 _p_ yout_, real_4 _p_ ypout_, int_4 _p_ 
neqn_, int_4 _p_ kold_, real_4 _p_ phi_, int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_4 _p_ gi_, real_4 _p_ 
alpha_, real_4 _p_ og_, real_4 _p_ ow_, real_4 _p_ ox_, real_4 _p_ oy_);
prototype int_4 _steps (int_4 (*_f)(), int_4 _p_ neqn_, real_4 _p_ y_, real_4 _p_ x_, real_4 _p_ h_, real_4 _p_ eps_, 
real_4 _p_ wt_, logical_4 _p_ start_, real_4 _p_ hold_, int_4 _p_ k_, int_4 _p_ kold_, logical_4 _p_ crash_, real_4 _p_ 
phi_, real_4 _p_ p_, real_4 _p_ yp_, real_4 _p_ psi_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ sig_, real_4 _p_ 
v_, real_4 _p_ w_, real_4 _p_ g_, logical_4 _p_ phase1_, int_4 _p_ ns_, logical_4 _p_ nornd_, int_4 _p_ ksteps_, real_4 
_p_ twou_, real_4 _p_ fouru_, real_4 _p_ xold_, int_4 _p_ kprev_, int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_4 
_p_ gi_, real_4 _p_ rpar_, int_4 _p_ ipar_);
int_4 _ddeabm (real_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ tout_, int_4 _p_ info_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, 
real_8 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 ialpha_, ibeta_, idelsn_, ifouru_, ig_, ihold_, ip_, iphi_, ipsi_, isig_, itold_, itstar_, itwou_, iv_, 
  iw_, iwt_, iyp_, iypout_, iyy_, igi_, ixold_;
  static logical_4 start_, phase1_, nornd_, stiff_, intout_;
  static char_15 xern1_;
  static char_31 xern3_;
  int_4 __fcnt, __rc, $6_, $7_, $16_;
  char_127 $0_, $8_, $12_;
  char_255 $1_, $9_, $13_;
  char_511 $2_, $10_, $11_, $14_, $15_;
  char_1023 $3_;
  char_2047 $4_, $5_;
  static FORMAT $f_100012_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100019_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100024_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if (info_[0] == 0) {
    iwork_[(*liw_) - 1] = 0;
  }
  if (iwork_[(*liw_) - 1] >= 5) {
    if ((*t_) == rwork_[21 + (*neq_) - 1]) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-depac:ddeabm:600", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:600", 0));
        __fcnt += 3;
      }
      if ($f_100012_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:600", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100012_[__fcnt + 2], &(*t_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:600", 0));
      __fcnt += 3;
      while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
        if ($f_100012_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:600", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_0, _dc_1, (bufcpy ($5_, concat ($4_, concat ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_2, 
      _dc_3), xern3_), _dc_4), _dc_5), _dc_6), 2047), $5_), ($6_ = 13, &$6_), ($7_ = 2, &$7_));
      goto _l0;
    }
  }
  (*idid_) = 0;
  if ((*lrw_) < 130 + 21 * (*neq_)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-depac:ddeabm:615", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:615", 0));
      __fcnt += 3;
    }
    if ($f_100019_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:615", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100019_[__fcnt + 2], &(*lrw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:615", 0));
    __fcnt += 3;
    while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
      if ($f_100019_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:615", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_7, _dc_8), _dc_9), xern1_), 
    511), $11_), &_k1, &_k1);
    (*idid_) = -33;
  }
  if ((*liw_) < 51) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-depac:ddeabm:623", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100024_[__fcnt] != NULL && $f_100024_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100024_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:623", 0));
      __fcnt += 3;
    }
    if ($f_100024_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100024_[__fcnt] != NULL && $f_100024_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100024_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:623", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100024_[__fcnt + 2], &(*liw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:623", 0));
    __fcnt += 3;
    while ($f_100024_[__fcnt] != NULL && $f_100024_[__fcnt] == FMT_TEXT) {
      if ($f_100024_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100024_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:ddeabm:623", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($15_, concat ($14_, concat ($13_, concat ($12_, _dc_10, _dc_11), _dc_12), 
    xern1_), 511), $15_), ($16_ = 2, &$16_), &_k1);
    (*idid_) = -33;
  }
  iypout_ = 21;
  itstar_ = (*neq_) + 21;
  iyp_ = 1 + itstar_;
  iyy_ = (*neq_) + iyp_;
  iwt_ = (*neq_) + iyy_;
  ip_ = (*neq_) + iwt_;
  iphi_ = (*neq_) + ip_;
  ialpha_ = ((*neq_) * 16) + iphi_;
  ibeta_ = 12 + ialpha_;
  ipsi_ = 12 + ibeta_;
  iv_ = 12 + ipsi_;
  iw_ = 12 + iv_;
  isig_ = 12 + iw_;
  ig_ = 13 + isig_;
  igi_ = 13 + ig_;
  ixold_ = 11 + igi_;
  ihold_ = 1 + ixold_;
  itold_ = 1 + ihold_;
  idelsn_ = 1 + itold_;
  itwou_ = 1 + idelsn_;
  ifouru_ = 1 + itwou_;
  rwork_[itstar_ - 1] = (*t_);
  if (info_[0] == 0) {
    goto _l50;
  }
  start_ = iwork_[20] != -1;
  phase1_ = iwork_[21] != -1;
  nornd_ = iwork_[22] != -1;
  stiff_ = iwork_[23] != -1;
  intout_ = iwork_[24] != -1;
  _l50:;
  (void) _ddes (_df, neq_, t_, y_, tout_, info_, rtol_, atol_, idid_, &rwork_[iypout_ - 1], &rwork_[iyp_ - 1], 
  &rwork_[iyy_ - 1], &rwork_[iwt_ - 1], &rwork_[ip_ - 1], &rwork_[iphi_ - 1], &rwork_[ialpha_ - 1], &rwork_[ibeta_ - 1], 
  &rwork_[ipsi_ - 1], &rwork_[iv_ - 1], &rwork_[iw_ - 1], &rwork_[isig_ - 1], &rwork_[ig_ - 1], &rwork_[igi_ - 1], 
  &rwork_[10], &rwork_[11], &rwork_[12], &rwork_[ixold_ - 1], &rwork_[ihold_ - 1], &rwork_[itold_ - 1], &rwork_[idelsn_ - 
  1], &rwork_[0], &rwork_[itwou_ - 1], &rwork_[ifouru_ - 1], &start_, &phase1_, &nornd_, &stiff_, &intout_, &iwork_[25], 
  &iwork_[26], &iwork_[27], &iwork_[28], &iwork_[29], &iwork_[30], &iwork_[31], &iwork_[32], &iwork_[33], &iwork_[34], 
  &iwork_[44], rpar_, ipar_);
  iwork_[20] = -1;
  if (start_) {
    iwork_[20] = 1;
  }
  iwork_[21] = -1;
  if (phase1_) {
    iwork_[21] = 1;
  }
  iwork_[22] = -1;
  if (nornd_) {
    iwork_[22] = 1;
  }
  iwork_[23] = -1;
  if (stiff_) {
    iwork_[23] = 1;
  }
  iwork_[24] = -1;
  if (intout_) {
    iwork_[24] = 1;
  }
  if ((*idid_) != -2) {
    iwork_[(*liw_) - 1] = iwork_[(*liw_) - 1] + 1;
  }
  if ((*t_) != rwork_[itstar_ - 1]) {
    iwork_[(*liw_) - 1] = 0;
  }
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _dderkf (real_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ tout_, int_4 _p_ info_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, 
real_8 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 kdi_, kf1_, kf2_, kf3_, kf4_, kf5_, kh_, krer_, ktf_, kto_, ktstar_, ku_, kyp_, kys_;
  static logical_4 stiff_, nonstf_;
  static char_15 xern1_;
  static char_31 xern3_;
  int_4 __fcnt, __rc, $6_, $7_, $16_;
  char_127 $0_, $8_, $12_;
  char_255 $1_, $9_, $13_;
  char_511 $2_, $10_, $11_, $14_, $15_;
  char_1023 $3_;
  char_2047 $4_, $5_;
  static FORMAT $f_100012_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100019_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100024_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if (info_[0] == 0) {
    iwork_[(*liw_) - 1] = 0;
  }
  if (iwork_[(*liw_) - 1] >= 5) {
    if ((*t_) == rwork_[21 + (*neq_) - 1]) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-depac:dderkf:623", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:623", 0));
        __fcnt += 3;
      }
      if ($f_100012_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:623", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100012_[__fcnt + 2], &(*t_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:623", 0));
      __fcnt += 3;
      while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
        if ($f_100012_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:623", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_0, _dc_13, (bufcpy ($5_, concat ($4_, concat ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_2, 
      _dc_14), xern3_), _dc_4), _dc_5), _dc_6), 2047), $5_), ($6_ = 13, &$6_), ($7_ = 2, &$7_));
      goto _l0;
    }
  }
  (*idid_) = 0;
  if ((*lrw_) < 30 + 7 * (*neq_)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-depac:dderkf:638", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:638", 0));
      __fcnt += 3;
    }
    if ($f_100019_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:638", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100019_[__fcnt + 2], &(*lrw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:638", 0));
    __fcnt += 3;
    while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
      if ($f_100019_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:638", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_13, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_15, _dc_16), _dc_17), 
    xern1_), 511), $11_), &_k1, &_k1);
    (*idid_) = -33;
  }
  if ((*liw_) < 34) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-depac:dderkf:646", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100024_[__fcnt] != NULL && $f_100024_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100024_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:646", 0));
      __fcnt += 3;
    }
    if ($f_100024_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100024_[__fcnt] != NULL && $f_100024_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100024_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:646", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100024_[__fcnt + 2], &(*liw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:646", 0));
    __fcnt += 3;
    while ($f_100024_[__fcnt] != NULL && $f_100024_[__fcnt] == FMT_TEXT) {
      if ($f_100024_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100024_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:dderkf:646", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_13, (bufcpy ($15_, concat ($14_, concat ($13_, concat ($12_, _dc_18, _dc_19), _dc_20), 
    xern1_), 511), $15_), ($16_ = 2, &$16_), &_k1);
    (*idid_) = -33;
  }
  kh_ = 11;
  ktf_ = 12;
  kyp_ = 21;
  ktstar_ = kyp_ + (*neq_);
  kf1_ = ktstar_ + 1;
  kf2_ = kf1_ + (*neq_);
  kf3_ = kf2_ + (*neq_);
  kf4_ = kf3_ + (*neq_);
  kf5_ = kf4_ + (*neq_);
  kys_ = kf5_ + (*neq_);
  kto_ = kys_ + (*neq_);
  kdi_ = kto_ + 1;
  ku_ = kdi_ + 1;
  krer_ = ku_ + 1;
  rwork_[ktstar_ - 1] = (*t_);
  if (info_[0] != 0) {
    stiff_ = (iwork_[24] == 0);
    nonstf_ = (iwork_[25] == 0);
  }
  (void) _drkfs (_df, neq_, t_, y_, tout_, info_, rtol_, atol_, idid_, &rwork_[kh_ - 1], &rwork_[ktf_ - 1], &rwork_[kyp_ 
  - 1], &rwork_[kf1_ - 1], &rwork_[kf2_ - 1], &rwork_[kf3_ - 1], &rwork_[kf4_ - 1], &rwork_[kf5_ - 1], &rwork_[kys_ - 1], 
  &rwork_[kto_ - 1], &rwork_[kdi_ - 1], &rwork_[ku_ - 1], &rwork_[krer_ - 1], &iwork_[20], &iwork_[21], &iwork_[22], 
  &iwork_[23], &stiff_, &nonstf_, &iwork_[26], &iwork_[27], rpar_, ipar_);
  iwork_[24] = 1;
  if (stiff_) {
    iwork_[24] = 0;
  }
  iwork_[25] = 1;
  if (nonstf_) {
    iwork_[25] = 0;
  }
  if ((*idid_) != -2) {
    iwork_[(*liw_) - 1] = iwork_[(*liw_) - 1] + 1;
  }
  if ((*t_) != rwork_[ktstar_ - 1]) {
    iwork_[(*liw_) - 1] = 0;
  }
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _deabm (real_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ tout_, int_4 _p_ info_, real_4 
_p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, 
real_4 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 iypout_, itstar_, iyp_, iyy_, iwt_, ip_, iphi_, ialpha_, ibeta_, ipsi_, iv_, iw_, isig_, ig_, igi_, ixold_
  , ihold_, itold_, idelsn_, itwou_, ifouru_;
  static logical_4 start_, phase1_, nornd_, stiff_, intout_;
  static char_15 xern1_;
  static char_31 xern3_;
  int_4 __fcnt, __rc, $6_, $7_, $16_;
  char_127 $0_, $8_, $12_;
  char_255 $1_, $9_, $13_;
  char_511 $2_, $10_, $11_, $14_, $15_;
  char_1023 $3_;
  char_2047 $4_, $5_;
  static FORMAT $f_100010_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100017_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if (info_[0] == 0) {
    iwork_[(*liw_) - 1] = 0;
  }
  if (iwork_[(*liw_) - 1] >= 5) {
    if ((*t_) == rwork_[21 + (*neq_) - 1]) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-depac:deabm:583", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:583", 0));
        __fcnt += 3;
      }
      if ($f_100010_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:583", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:583", 0));
      __fcnt += 3;
      while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
        if ($f_100010_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:583", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_0, _dc_21, (bufcpy ($5_, concat ($4_, concat ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_2, 
      _dc_3), xern3_), _dc_4), _dc_5), _dc_6), 2047), $5_), ($6_ = 13, &$6_), ($7_ = 2, &$7_));
      goto _l0;
    }
  }
  (*idid_) = 0;
  if ((*lrw_) < 130 + 21 * (*neq_)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-depac:deabm:598", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:598", 0));
      __fcnt += 3;
    }
    if ($f_100017_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:598", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100017_[__fcnt + 2], &(*lrw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:598", 0));
    __fcnt += 3;
    while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
      if ($f_100017_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:598", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_21, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_7, _dc_8), _dc_9), xern1_), 
    511), $11_), &_k1, &_k1);
    (*idid_) = -33;
  }
  if ((*liw_) < 51) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-depac:deabm:606", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:606", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:606", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*liw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:606", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:deabm:606", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_21, (bufcpy ($15_, concat ($14_, concat ($13_, concat ($12_, _dc_10, _dc_11), _dc_12), 
    xern1_), 511), $15_), ($16_ = 2, &$16_), &_k1);
    (*idid_) = -33;
  }
  iypout_ = 21;
  itstar_ = (*neq_) + 21;
  iyp_ = 1 + itstar_;
  iyy_ = (*neq_) + iyp_;
  iwt_ = (*neq_) + iyy_;
  ip_ = (*neq_) + iwt_;
  iphi_ = (*neq_) + ip_;
  ialpha_ = ((*neq_) * 16) + iphi_;
  ibeta_ = 12 + ialpha_;
  ipsi_ = 12 + ibeta_;
  iv_ = 12 + ipsi_;
  iw_ = 12 + iv_;
  isig_ = 12 + iw_;
  ig_ = 13 + isig_;
  igi_ = 13 + ig_;
  ixold_ = 11 + igi_;
  ihold_ = 1 + ixold_;
  itold_ = 1 + ihold_;
  idelsn_ = 1 + itold_;
  itwou_ = 1 + idelsn_;
  ifouru_ = 1 + itwou_;
  rwork_[itstar_ - 1] = (*t_);
  if (info_[0] == 0) {
    goto _l50;
  }
  start_ = iwork_[20] != -1;
  phase1_ = iwork_[21] != -1;
  nornd_ = iwork_[22] != -1;
  stiff_ = iwork_[23] != -1;
  intout_ = iwork_[24] != -1;
  _l50:;
  (void) _des (_f, neq_, t_, y_, tout_, info_, rtol_, atol_, idid_, &rwork_[iypout_ - 1], &rwork_[iyp_ - 1], &rwork_[iyy_ 
  - 1], &rwork_[iwt_ - 1], &rwork_[ip_ - 1], &rwork_[iphi_ - 1], &rwork_[ialpha_ - 1], &rwork_[ibeta_ - 1], &rwork_[ipsi_ 
  - 1], &rwork_[iv_ - 1], &rwork_[iw_ - 1], &rwork_[isig_ - 1], &rwork_[ig_ - 1], &rwork_[igi_ - 1], &rwork_[10], 
  &rwork_[11], &rwork_[12], &rwork_[ixold_ - 1], &rwork_[ihold_ - 1], &rwork_[itold_ - 1], &rwork_[idelsn_ - 1], 
  &rwork_[0], &rwork_[itwou_ - 1], &rwork_[ifouru_ - 1], &start_, &phase1_, &nornd_, &stiff_, &intout_, &iwork_[25], 
  &iwork_[26], &iwork_[27], &iwork_[28], &iwork_[29], &iwork_[30], &iwork_[31], &iwork_[32], &iwork_[33], &iwork_[34], 
  &iwork_[44], rpar_, ipar_);
  iwork_[20] = -1;
  if (start_) {
    iwork_[20] = 1;
  }
  iwork_[21] = -1;
  if (phase1_) {
    iwork_[21] = 1;
  }
  iwork_[22] = -1;
  if (nornd_) {
    iwork_[22] = 1;
  }
  iwork_[23] = -1;
  if (stiff_) {
    iwork_[23] = 1;
  }
  iwork_[24] = -1;
  if (intout_) {
    iwork_[24] = 1;
  }
  if ((*idid_) != -2) {
    iwork_[(*liw_) - 1] = iwork_[(*liw_) - 1] + 1;
  }
  if ((*t_) != rwork_[itstar_ - 1]) {
    iwork_[(*liw_) - 1] = 0;
  }
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _derkf (real_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ tout_, int_4 _p_ info_, real_4 
_p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ rwork_, int_4 _p_ lrw_, int_4 _p_ iwork_, int_4 _p_ liw_, 
real_4 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 kh_, ktf_, kyp_, ktstar_, kf1_, kf2_, kf3_, kf4_, kf5_, kys_, kto_, kdi_, ku_, krer_;
  static logical_4 stiff_, nonstf_;
  static char_15 xern1_;
  static char_31 xern3_;
  int_4 __fcnt, __rc, $6_, $7_, $16_;
  char_127 $0_, $8_, $12_;
  char_255 $1_, $9_, $13_;
  char_511 $2_, $10_, $11_, $14_, $15_;
  char_1023 $3_;
  char_2047 $4_, $5_;
  static FORMAT $f_100010_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100017_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if (info_[0] == 0) {
    iwork_[(*liw_) - 1] = 0;
  }
  if (iwork_[(*liw_) - 1] >= 5) {
    if ((*t_) == rwork_[21 + (*neq_) - 1]) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-depac:derkf:613", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:613", 0));
        __fcnt += 3;
      }
      if ($f_100010_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:613", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:613", 0));
      __fcnt += 3;
      while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
        if ($f_100010_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:613", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_0, _dc_22, (bufcpy ($5_, concat ($4_, concat ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_2, 
      _dc_14), xern3_), _dc_4), _dc_5), _dc_6), 2047), $5_), ($6_ = 13, &$6_), ($7_ = 2, &$7_));
      goto _l0;
    }
  }
  (*idid_) = 0;
  if ((*lrw_) < 30 + 7 * (*neq_)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-depac:derkf:628", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:628", 0));
      __fcnt += 3;
    }
    if ($f_100017_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:628", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100017_[__fcnt + 2], &(*lrw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:628", 0));
    __fcnt += 3;
    while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
      if ($f_100017_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:628", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_22, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_15, _dc_23), _dc_24), 
    xern1_), 511), $11_), &_k1, &_k1);
    (*idid_) = -33;
  }
  if ((*liw_) < 34) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-depac:derkf:636", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:636", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:636", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*liw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:636", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-depac:derkf:636", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_22, (bufcpy ($15_, concat ($14_, concat ($13_, concat ($12_, _dc_18, _dc_25), _dc_20), 
    xern1_), 511), $15_), ($16_ = 2, &$16_), &_k1);
    (*idid_) = -33;
  }
  kh_ = 11;
  ktf_ = 12;
  kyp_ = 21;
  ktstar_ = kyp_ + (*neq_);
  kf1_ = ktstar_ + 1;
  kf2_ = kf1_ + (*neq_);
  kf3_ = kf2_ + (*neq_);
  kf4_ = kf3_ + (*neq_);
  kf5_ = kf4_ + (*neq_);
  kys_ = kf5_ + (*neq_);
  kto_ = kys_ + (*neq_);
  kdi_ = kto_ + 1;
  ku_ = kdi_ + 1;
  krer_ = ku_ + 1;
  rwork_[ktstar_ - 1] = (*t_);
  if (info_[0] != 0) {
    stiff_ = (iwork_[24] == 0);
    nonstf_ = (iwork_[25] == 0);
  }
  (void) _derkfs (_f, neq_, t_, y_, tout_, info_, rtol_, atol_, idid_, &rwork_[kh_ - 1], &rwork_[ktf_ - 1], &rwork_[kyp_ 
  - 1], &rwork_[kf1_ - 1], &rwork_[kf2_ - 1], &rwork_[kf3_ - 1], &rwork_[kf4_ - 1], &rwork_[kf5_ - 1], &rwork_[kys_ - 1], 
  &rwork_[kto_ - 1], &rwork_[kdi_ - 1], &rwork_[ku_ - 1], &rwork_[krer_ - 1], &iwork_[20], &iwork_[21], &iwork_[22], 
  &iwork_[23], &stiff_, &nonstf_, &iwork_[26], &iwork_[27], rpar_, ipar_);
  iwork_[24] = 1;
  if (stiff_) {
    iwork_[24] = 0;
  }
  iwork_[25] = 1;
  if (nonstf_) {
    iwork_[25] = 0;
  }
  if ((*idid_) != -2) {
    iwork_[(*liw_) - 1] = iwork_[(*liw_) - 1] + 1;
  }
  if ((*t_) != rwork_[ktstar_ - 1]) {
    iwork_[(*liw_) - 1] = 0;
  }
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _dintp (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ xout_, real_8 _p_ yout_, real_8 _p_ ypout_, int_4 _p_ neqn_, 
int_4 _p_ kold_, real_8 _p_ phi_, int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_8 _p_ gi_, real_8 _p_ alpha_, 
real_8 _p_ og_, real_8 _p_ ow_, real_8 _p_ ox_, real_8 _p_ oy_)
{
  static int_4 i_, iq_, iw_, j_, jq_, kp1_, kp2_, l_, m_;
  static real_8 alp_, c_[13], g_[13], gdi_, gdif_, gamma_, h_, hi_, hmu_, rmu_, sigma_, temp1_, temp2_, temp3_, w_[13], 
  xi_, xim1_, xiq_;
  kp1_ = (*kold_) + 1;
  kp2_ = (*kold_) + 2;
  hi_ = (*xout_) - (*ox_);
  h_ = (*x_) - (*ox_);
  xi_ = hi_ / h_;
  xim1_ = xi_ - 1.0e0;
  xiq_ = xi_;
  for (iq_ = 1; iq_ <= kp1_; (iq_)++) {
    xiq_ = xi_ * xiq_;
    temp1_ = iq_ * (iq_ + 1);
    w_[iq_ - 1] = xiq_ / temp1_;
  }
  if ((*kold_) <= (*kgi_)) {
    goto _l50;
  }
  if ((*ivc_) > 0) {
    goto _l20;
  }
  gdi_ = 1.0e0 / temp1_;
  m_ = 2;
  goto _l30;
  _l20:;
  iw_ = iv_[(*ivc_) - 1];
  gdi_ = ow_[iw_ - 1];
  m_ = (*kold_) - iw_ + 3;
  _l30:;
  if (m_ > (*kold_)) {
    goto _l60;
  }
  for (i_ = m_; i_ <= (*kold_); (i_)++) {
    gdi_ = ow_[kp2_ - i_ - 1] - alpha_[i_ - 1] * gdi_;
  }
  goto _l60;
  _l50:;
  gdi_ = gi_[(*kold_) - 1];
  _l60:;
  g_[0] = xi_;
  g_[1] = 0.5e0 * xi_ * xi_;
  c_[0] = 1.0;
  c_[1] = xi_;
  if ((*kold_) < 2) {
    goto _l90;
  }
  for (i_ = 2; i_ <= (*kold_); (i_)++) {
    alp_ = alpha_[i_ - 1];
    gamma_ = 1.0e0 + xim1_ * alp_;
    l_ = kp2_ - i_;
    for (jq_ = 1; jq_ <= l_; (jq_)++) {
      w_[jq_ - 1] = gamma_ * w_[jq_ - 1] - alp_ * w_[jq_ + 1 - 1];
    }
    g_[i_ + 1 - 1] = w_[0];
    c_[i_ + 1 - 1] = gamma_ * c_[i_ - 1];
  }
  _l90:;
  sigma_ = (w_[1] - xim1_ * w_[0]) / gdi_;
  rmu_ = xim1_ * c_[kp1_ - 1] / gdi_;
  hmu_ = rmu_ / h_;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    yout_[l_ - 1] = 0.0;
    ypout_[l_ - 1] = 0.0;
  }
  for (j_ = 1; j_ <= (*kold_); (j_)++) {
    i_ = kp2_ - j_;
    gdif_ = og_[i_ - 1] - og_[i_ - 1 - 1];
    temp2_ = (g_[i_ - 1] - g_[i_ - 1 - 1]) - sigma_ * gdif_;
    temp3_ = (c_[i_ - 1] - c_[i_ - 1 - 1]) + rmu_ * gdif_;
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      yout_[l_ - 1] = yout_[l_ - 1] + temp2_ * phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))];
      ypout_[l_ - 1] = ypout_[l_ - 1] + temp3_ * phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))];
    }
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    yout_[l_ - 1] = ((1.0e0 - sigma_) * oy_[l_ - 1] + sigma_ * y_[l_ - 1]) + h_ * (yout_[l_ - 1] + (g_[0] - sigma_ * 
    og_[0]) * phi_[l_ - 1 + ((*neqn_)) * ((0))]);
    ypout_[l_ - 1] = hmu_ * (oy_[l_ - 1] - y_[l_ - 1]) + (ypout_[l_ - 1] + (c_[0] + rmu_ * og_[0]) * phi_[l_ - 1 + 
    ((*neqn_)) * ((0))]);
  }
  __calls[4].calls++;
  return 0;
}

int_4 _dsteps (int_4 (*_df)(), int_4 _p_ neqn_, real_8 _p_ y_, real_8 _p_ x_, real_8 _p_ h_, real_8 _p_ eps_, real_8 
_p_ wt_, logical_4 _p_ start_, real_8 _p_ hold_, int_4 _p_ k_, int_4 _p_ kold_, logical_4 _p_ crash_, real_8 _p_ phi_, 
real_8 _p_ p_, real_8 _p_ yp_, real_8 _p_ psi_, real_8 _p_ alpha_, real_8 _p_ beta_, real_8 _p_ sig_, real_8 _p_ v_, 
real_8 _p_ w_, real_8 _p_ g_, logical_4 _p_ phase1_, int_4 _p_ ns_, logical_4 _p_ nornd_, int_4 _p_ ksteps_, real_8 _p_ 
twou_, real_8 _p_ fouru_, real_8 _p_ xold_, int_4 _p_ kprev_, int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_8 _p_ 
gi_, real_8 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 i_, ifail_, im1_, ip1_, iq_, j_, km1_, km2_, knew_, kp1_, kp2_, l_, limit1_, limit2_, nsm2_, nsp1_, nsp2_, 
  jv_;
  static real_8 absh_, big_, erk_, erkm1_, erkm2_, erkp1_, err_, gstr_[13], hnew_, p5eps_, r_, reali_, realns_, rho_, 
  round_, tau_, temp1_, temp2_, temp3_, temp4_, temp5_, temp6_, two_[13], u_;
  int_4 _data_k_0, _data_k_1, $1_, $2_, $4_, $8_, $9_, $10_;
  real_8 $0_, $3_, $5_, $6_, $7_, $11_;
  extern real_8 _d1mach ();
#define _data_n_0 13
  static real_8 _data_l_0[_data_n_0] = {
    2.0e0,
    4.0e0,
    8.0e0,
    16.0e0,
    32.0e0,
    64.0e0,
    128.0e0,
    256.0e0,
    512.0e0,
    1024.0e0,
    2048.0e0,
    4096.0e0,
    8192.0e0
  };
#define _data_n_1 13
  static real_8 _data_l_1[_data_n_1] = {
    0.5e0,
    0.0833e0,
    0.0417e0,
    0.0264e0,
    0.0188e0,
    0.0143e0,
    0.0114e0,
    0.00936e0,
    0.00789e0,
    0.00679e0,
    0.00592e0,
    0.00524e0,
    0.00468e0
  };
  if (__calls[5].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[0] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[1] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[2] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[3] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[4] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[5] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[6] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[7] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[8] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[9] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[10] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[11] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    two_[12] = _data_l_0[_data_k_0++];
  }
  if (__calls[5].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[0] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[1] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[2] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[3] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[4] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[5] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[6] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[7] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[8] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[9] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[10] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[11] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    gstr_[12] = _data_l_1[_data_k_1++];
  }
  (*crash_) = TRUE;
  if (_abs ((*h_)) >= (*fouru_) * _abs ((*x_))) {
    goto _l5;
  }
  (*h_) = _sign ((*fouru_) * _abs ((*x_)), (*h_));
  goto _l0;
  _l5:;
  p5eps_ = 0.5e0 * (*eps_);
  round_ = 0.0;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    round_ = round_ + ($0_ = (y_[l_ - 1] / wt_[l_ - 1]), $0_ * $0_);
  }
  round_ = (*twou_) * sqrt (round_);
  if (p5eps_ >= round_) {
    goto _l15;
  }
  (*eps_) = 2.0e0 * round_ * (1.0e0 + (*fouru_));
  goto _l0;
  _l15:;
  (*crash_) = FALSE;
  g_[0] = 1.0;
  g_[1] = 0.5;
  sig_[0] = 1.0;
  if (! ((*start_))) {
    goto _l99;
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    phi_[l_ - 1 + ((*neqn_)) * ((0))] = yp_[l_ - 1];
    phi_[l_ - 1 + ((*neqn_)) * ((1))] = 0.0;
  }
  u_ = _d1mach (($1_ = 4, &$1_));
  big_ = sqrt (_d1mach (($2_ = 2, &$2_)));
  (void) _dhstrt (_df, neqn_, x_, ($3_ = (*x_) + (*h_), &$3_), y_, yp_, wt_, &_k1, &u_, &big_, &phi_[0 + ((*neqn_)) * 
  ((2))], &phi_[0 + ((*neqn_)) * ((3))], &phi_[0 + ((*neqn_)) * ((4))], &phi_[0 + ((*neqn_)) * ((5))], rpar_, ipar_, h_)
  ;
  (*hold_) = 0.0;
  (*k_) = 1;
  (*kold_) = 0;
  (*kprev_) = 0;
  (*start_) = FALSE;
  (*phase1_) = TRUE;
  (*nornd_) = TRUE;
  if (p5eps_ > 100.0e0 * round_) {
    goto _l99;
  }
  (*nornd_) = FALSE;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    phi_[l_ - 1 + ((*neqn_)) * ((14))] = 0.0;
  }
  _l99:;
  ifail_ = 0;
  _l100:;
  kp1_ = (*k_) + 1;
  kp2_ = (*k_) + 2;
  km1_ = (*k_) - 1;
  km2_ = (*k_) - 2;
  if ((*h_) != (*hold_)) {
    (*ns_) = 0;
  }
  if ((*ns_) <= (*kold_)) {
    (*ns_) = (*ns_) + 1;
  }
  nsp1_ = (*ns_) + 1;
  if ((*k_) < (*ns_)) {
    goto _l199;
  }
  beta_[(*ns_) - 1] = 1.0;
  realns_ = (*ns_);
  alpha_[(*ns_) - 1] = 1.0e0 / realns_;
  temp1_ = (*h_) * realns_;
  sig_[nsp1_ - 1] = 1.0;
  if ((*k_) < nsp1_) {
    goto _l110;
  }
  for (i_ = nsp1_; i_ <= (*k_); (i_)++) {
    im1_ = i_ - 1;
    temp2_ = psi_[im1_ - 1];
    psi_[im1_ - 1] = temp1_;
    beta_[i_ - 1] = beta_[im1_ - 1] * psi_[im1_ - 1] / temp2_;
    temp1_ = temp2_ + (*h_);
    alpha_[i_ - 1] = (*h_) / temp1_;
    reali_ = i_;
    sig_[i_ + 1 - 1] = reali_ * alpha_[i_ - 1] * sig_[i_ - 1];
  }
  _l110:;
  psi_[(*k_) - 1] = temp1_;
  if ((*ns_) > 1) {
    goto _l120;
  }
  for (iq_ = 1; iq_ <= (*k_); (iq_)++) {
    temp3_ = iq_ * (iq_ + 1);
    v_[iq_ - 1] = 1.0e0 / temp3_;
    w_[iq_ - 1] = v_[iq_ - 1];
  }
  (*ivc_) = 0;
  (*kgi_) = 0;
  if ((*k_) == 1) {
    goto _l140;
  }
  (*kgi_) = 1;
  gi_[0] = w_[1];
  goto _l140;
  _l120:;
  if ((*k_) <= (*kprev_)) {
    goto _l130;
  }
  if ((*ivc_) == 0) {
    goto _l122;
  }
  jv_ = kp1_ - iv_[(*ivc_) - 1];
  (*ivc_) = (*ivc_) - 1;
  goto _l123;
  _l122:;
  jv_ = 1;
  temp4_ = (*k_) * kp1_;
  v_[(*k_) - 1] = 1.0e0 / temp4_;
  w_[(*k_) - 1] = v_[(*k_) - 1];
  if ((*k_) != 2) {
    goto _l123;
  }
  (*kgi_) = 1;
  gi_[0] = w_[1];
  _l123:;
  nsm2_ = (*ns_) - 2;
  if (nsm2_ < jv_) {
    goto _l130;
  }
  for (j_ = jv_; j_ <= nsm2_; (j_)++) {
    i_ = (*k_) - j_;
    v_[i_ - 1] = v_[i_ - 1] - alpha_[j_ + 1 - 1] * v_[i_ + 1 - 1];
    w_[i_ - 1] = v_[i_ - 1];
  }
  if (i_ != 2) {
    goto _l130;
  }
  (*kgi_) = (*ns_) - 1;
  gi_[(*kgi_) - 1] = w_[1];
  _l130:;
  limit1_ = kp1_ - (*ns_);
  temp5_ = alpha_[(*ns_) - 1];
  for (iq_ = 1; iq_ <= limit1_; (iq_)++) {
    v_[iq_ - 1] = v_[iq_ - 1] - temp5_ * v_[iq_ + 1 - 1];
    w_[iq_ - 1] = v_[iq_ - 1];
  }
  g_[nsp1_ - 1] = w_[0];
  if (limit1_ == 1) {
    goto _l137;
  }
  (*kgi_) = (*ns_);
  gi_[(*kgi_) - 1] = w_[1];
  _l137:;
  w_[limit1_ + 1 - 1] = v_[limit1_ + 1 - 1];
  if ((*k_) >= (*kold_)) {
    goto _l140;
  }
  (*ivc_) = (*ivc_) + 1;
  iv_[(*ivc_) - 1] = limit1_ + 2;
  _l140:;
  nsp2_ = (*ns_) + 2;
  (*kprev_) = (*k_);
  if (kp1_ < nsp2_) {
    goto _l199;
  }
  for (i_ = nsp2_; i_ <= kp1_; (i_)++) {
    limit2_ = kp2_ - i_;
    temp6_ = alpha_[i_ - 1 - 1];
    for (iq_ = 1; iq_ <= limit2_; (iq_)++) {
      w_[iq_ - 1] = w_[iq_ - 1] - temp6_ * w_[iq_ + 1 - 1];
    }
    g_[i_ - 1] = w_[0];
  }
  _l199:;
  (*ksteps_) = (*ksteps_) + 1;
  if ((*k_) < nsp1_) {
    goto _l215;
  }
  for (i_ = nsp1_; i_ <= (*k_); (i_)++) {
    temp1_ = beta_[i_ - 1];
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] = temp1_ * phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))];
    }
  }
  _l215:;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    phi_[l_ - 1 + ((*neqn_)) * ((kp2_ - 1))] = phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 1))];
    phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 1))] = 0.0;
    p_[l_ - 1] = 0.0;
  }
  for (j_ = 1; j_ <= (*k_); (j_)++) {
    i_ = kp1_ - j_;
    ip1_ = i_ + 1;
    temp2_ = g_[i_ - 1];
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      p_[l_ - 1] = p_[l_ - 1] + temp2_ * phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))];
      phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] = phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] + phi_[l_ - 1 + ((*neqn_)) * ((ip1_ - 
      1))];
    }
  }
  if ((*nornd_)) {
    goto _l240;
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    tau_ = (*h_) * p_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((14))];
    p_[l_ - 1] = y_[l_ - 1] + tau_;
    phi_[l_ - 1 + ((*neqn_)) * ((15))] = (p_[l_ - 1] - y_[l_ - 1]) - tau_;
  }
  goto _l250;
  _l240:;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    p_[l_ - 1] = y_[l_ - 1] + (*h_) * p_[l_ - 1];
  }
  _l250:;
  (*xold_) = (*x_);
  (*x_) = (*x_) + (*h_);
  absh_ = _abs ((*h_));
  (void) _df (x_, p_, yp_, rpar_, ipar_);
  erkm2_ = 0.0;
  erkm1_ = 0.0;
  erk_ = 0.0;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    temp3_ = 1.0e0 / wt_[l_ - 1];
    temp4_ = yp_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((0))];
    $4_ = km2_;
    if ($4_ < 0) {
      goto _l265;
    } else if ($4_ == 0) {
      goto _l260;
    } else {
      goto _l255;
    }
    _l255:;
    erkm2_ = erkm2_ + ($5_ = ((phi_[l_ - 1 + ((*neqn_)) * ((km1_ - 1))] + temp4_) * temp3_), $5_ * $5_);
    _l260:;
    erkm1_ = erkm1_ + ($6_ = ((phi_[l_ - 1 + ((*neqn_)) * (((*k_) - 1))] + temp4_) * temp3_), $6_ * $6_);
    _l265:;
    erk_ = erk_ + ($7_ = (temp4_ * temp3_), $7_ * $7_);
  }
  $8_ = km2_;
  if ($8_ < 0) {
    goto _l280;
  } else if ($8_ == 0) {
    goto _l275;
  } else {
    goto _l270;
  }
  _l270:;
  erkm2_ = absh_ * sig_[km1_ - 1] * gstr_[km2_ - 1] * sqrt (erkm2_);
  _l275:;
  erkm1_ = absh_ * sig_[(*k_) - 1] * gstr_[km1_ - 1] * sqrt (erkm1_);
  _l280:;
  temp5_ = absh_ * sqrt (erk_);
  err_ = temp5_ * (g_[(*k_) - 1] - g_[kp1_ - 1]);
  erk_ = temp5_ * sig_[kp1_ - 1] * gstr_[(*k_) - 1];
  knew_ = (*k_);
  $9_ = km2_;
  if ($9_ < 0) {
    goto _l299;
  } else if ($9_ == 0) {
    goto _l290;
  } else {
    goto _l285;
  }
  _l285:;
  if (_max (erkm1_, erkm2_) <= erk_) {
    knew_ = km1_;
  }
  goto _l299;
  _l290:;
  if (erkm1_ <= 0.5e0 * erk_) {
    knew_ = km1_;
  }
  _l299:;
  if (err_ <= (*eps_)) {
    goto _l400;
  }
  (*phase1_) = FALSE;
  (*x_) = (*xold_);
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    temp1_ = 1.0e0 / beta_[i_ - 1];
    ip1_ = i_ + 1;
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] = temp1_ * (phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] - phi_[l_ - 1 + ((*neqn_)) * 
      ((ip1_ - 1))]);
    }
  }
  if ((*k_) < 2) {
    goto _l320;
  }
  for (i_ = 2; i_ <= (*k_); (i_)++) {
    psi_[i_ - 1 - 1] = psi_[i_ - 1] - (*h_);
  }
  _l320:;
  ifail_ = ifail_ + 1;
  temp2_ = 0.5;
  $10_ = ifail_ - 3;
  if ($10_ < 0) {
    goto _l335;
  } else if ($10_ == 0) {
    goto _l330;
  } else {
    goto _l325;
  }
  _l325:;
  if (p5eps_ < 0.25e0 * erk_) {
    temp2_ = sqrt (p5eps_ / erk_);
  }
  _l330:;
  knew_ = 1;
  _l335:;
  (*h_) = temp2_ * (*h_);
  (*k_) = knew_;
  (*ns_) = 0;
  if (_abs ((*h_)) >= (*fouru_) * _abs ((*x_))) {
    goto _l340;
  }
  (*crash_) = TRUE;
  (*h_) = _sign ((*fouru_) * _abs ((*x_)), (*h_));
  (*eps_) = (*eps_) + (*eps_);
  goto _l0;
  _l340:;
  goto _l100;
  _l400:;
  (*kold_) = (*k_);
  (*hold_) = (*h_);
  temp1_ = (*h_) * g_[kp1_ - 1];
  if ((*nornd_)) {
    goto _l410;
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    temp3_ = y_[l_ - 1];
    rho_ = temp1_ * (yp_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((0))]) - phi_[l_ - 1 + ((*neqn_)) * ((15))];
    y_[l_ - 1] = p_[l_ - 1] + rho_;
    phi_[l_ - 1 + ((*neqn_)) * ((14))] = (y_[l_ - 1] - p_[l_ - 1]) - rho_;
    p_[l_ - 1] = temp3_;
  }
  goto _l420;
  _l410:;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    temp3_ = y_[l_ - 1];
    y_[l_ - 1] = p_[l_ - 1] + temp1_ * (yp_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((0))]);
    p_[l_ - 1] = temp3_;
  }
  _l420:;
  (void) _df (x_, y_, yp_, rpar_, ipar_);
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 1))] = yp_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((0))];
    phi_[l_ - 1 + ((*neqn_)) * ((kp2_ - 1))] = phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 1))] - phi_[l_ - 1 + ((*neqn_)) * ((kp2_ 
    - 1))];
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] = phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] + phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 
      1))];
    }
  }
  erkp1_ = 0.0;
  if (knew_ == km1_ || (*k_) == 12) {
    (*phase1_) = FALSE;
  }
  if ((*phase1_)) {
    goto _l450;
  }
  if (knew_ == km1_) {
    goto _l455;
  }
  if (kp1_ > (*ns_)) {
    goto _l460;
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    erkp1_ = erkp1_ + ($11_ = (phi_[l_ - 1 + ((*neqn_)) * ((kp2_ - 1))] / wt_[l_ - 1]), $11_ * $11_);
  }
  erkp1_ = absh_ * gstr_[kp1_ - 1] * sqrt (erkp1_);
  if ((*k_) > 1) {
    goto _l445;
  }
  if (erkp1_ >= 0.5e0 * erk_) {
    goto _l460;
  }
  goto _l450;
  _l445:;
  if (erkm1_ <= _min (erk_, erkp1_)) {
    goto _l455;
  }
  if (erkp1_ >= erk_ || (*k_) == 12) {
    goto _l460;
  }
  _l450:;
  (*k_) = kp1_;
  erk_ = erkp1_;
  goto _l460;
  _l455:;
  (*k_) = km1_;
  erk_ = erkm1_;
  _l460:;
  hnew_ = (*h_) + (*h_);
  if ((*phase1_)) {
    goto _l465;
  }
  if (p5eps_ >= erk_ * two_[(*k_) + 1 - 1]) {
    goto _l465;
  }
  hnew_ = (*h_);
  if (p5eps_ >= erk_) {
    goto _l465;
  }
  temp2_ = (*k_) + 1;
  r_ = pow ((p5eps_ / erk_), (1.0e0 / temp2_));
  hnew_ = absh_ * _max (0.5, _min (0.9, r_));
  hnew_ = _sign (_max (hnew_, (*fouru_) * _abs ((*x_))), (*h_));
  _l465:;
  (*h_) = hnew_;
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _sintrp (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ xout_, real_4 _p_ yout_, real_4 _p_ ypout_, int_4 _p_ neqn_, 
int_4 _p_ kold_, real_4 _p_ phi_, int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_4 _p_ gi_, real_4 _p_ alpha_, 
real_4 _p_ og_, real_4 _p_ ow_, real_4 _p_ ox_, real_4 _p_ oy_)
{
  static int_4 kp1_, kp2_, iq_, m_, iw_, i_, l_, jq_, j_;
  static real_4 g_[13], c_[13], w_[13], hi_, h_, xi_, xim1_, xiq_, temp1_, gdi_, alp_, gamma_, sigma_, rmu_, hmu_, gdif_, 
  temp2_, temp3_;
  kp1_ = (*kold_) + 1;
  kp2_ = (*kold_) + 2;
  hi_ = (*xout_) - (*ox_);
  h_ = (*x_) - (*ox_);
  xi_ = hi_ / h_;
  xim1_ = xi_ - 1.0;
  xiq_ = xi_;
  for (iq_ = 1; iq_ <= kp1_; (iq_)++) {
    xiq_ = xi_ * xiq_;
    temp1_ = iq_ * (iq_ + 1);
    w_[iq_ - 1] = xiq_ / temp1_;
  }
  if ((*kold_) <= (*kgi_)) {
    goto _l50;
  }
  if ((*ivc_) > 0) {
    goto _l20;
  }
  gdi_ = 1.0 / temp1_;
  m_ = 2;
  goto _l30;
  _l20:;
  iw_ = iv_[(*ivc_) - 1];
  gdi_ = ow_[iw_ - 1];
  m_ = (*kold_) - iw_ + 3;
  _l30:;
  if (m_ > (*kold_)) {
    goto _l60;
  }
  for (i_ = m_; i_ <= (*kold_); (i_)++) {
    gdi_ = ow_[kp2_ - i_ - 1] - alpha_[i_ - 1] * gdi_;
  }
  goto _l60;
  _l50:;
  gdi_ = gi_[(*kold_) - 1];
  _l60:;
  g_[0] = xi_;
  g_[1] = 0.5 * xi_ * xi_;
  c_[0] = 1.0;
  c_[1] = xi_;
  if ((*kold_) < 2) {
    goto _l90;
  }
  for (i_ = 2; i_ <= (*kold_); (i_)++) {
    alp_ = alpha_[i_ - 1];
    gamma_ = 1.0 + xim1_ * alp_;
    l_ = kp2_ - i_;
    for (jq_ = 1; jq_ <= l_; (jq_)++) {
      w_[jq_ - 1] = gamma_ * w_[jq_ - 1] - alp_ * w_[jq_ + 1 - 1];
    }
    g_[i_ + 1 - 1] = w_[0];
    c_[i_ + 1 - 1] = gamma_ * c_[i_ - 1];
  }
  _l90:;
  sigma_ = (w_[1] - xim1_ * w_[0]) / gdi_;
  rmu_ = xim1_ * c_[kp1_ - 1] / gdi_;
  hmu_ = rmu_ / h_;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    yout_[l_ - 1] = 0.0;
    ypout_[l_ - 1] = 0.0;
  }
  for (j_ = 1; j_ <= (*kold_); (j_)++) {
    i_ = kp2_ - j_;
    gdif_ = og_[i_ - 1] - og_[i_ - 1 - 1];
    temp2_ = (g_[i_ - 1] - g_[i_ - 1 - 1]) - sigma_ * gdif_;
    temp3_ = (c_[i_ - 1] - c_[i_ - 1 - 1]) + rmu_ * gdif_;
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      yout_[l_ - 1] = yout_[l_ - 1] + temp2_ * phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))];
      ypout_[l_ - 1] = ypout_[l_ - 1] + temp3_ * phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))];
    }
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    yout_[l_ - 1] = ((1.0 - sigma_) * oy_[l_ - 1] + sigma_ * y_[l_ - 1]) + h_ * (yout_[l_ - 1] + (g_[0] - sigma_ * og_[0]) 
    * phi_[l_ - 1 + ((*neqn_)) * ((0))]);
    ypout_[l_ - 1] = hmu_ * (oy_[l_ - 1] - y_[l_ - 1]) + (ypout_[l_ - 1] + (c_[0] + rmu_ * og_[0]) * phi_[l_ - 1 + 
    ((*neqn_)) * ((0))]);
  }
  __calls[6].calls++;
  return 0;
}

int_4 _steps (int_4 (*_f)(), int_4 _p_ neqn_, real_4 _p_ y_, real_4 _p_ x_, real_4 _p_ h_, real_4 _p_ eps_, real_4 _p_ 
wt_, logical_4 _p_ start_, real_4 _p_ hold_, int_4 _p_ k_, int_4 _p_ kold_, logical_4 _p_ crash_, real_4 _p_ phi_, 
real_4 _p_ p_, real_4 _p_ yp_, real_4 _p_ psi_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ sig_, real_4 _p_ v_, 
real_4 _p_ w_, real_4 _p_ g_, logical_4 _p_ phase1_, int_4 _p_ ns_, logical_4 _p_ nornd_, int_4 _p_ ksteps_, real_4 _p_ 
twou_, real_4 _p_ fouru_, real_4 _p_ xold_, int_4 _p_ kprev_, int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_4 _p_ 
gi_, real_4 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 l_, ifail_, kp1_, kp2_, km1_, km2_, nsp1_, i_, im1_, iq_, jv_, nsm2_, j_, limit1_, nsp2_, limit2_, ip1_, 
  knew_;
  static real_4 two_[13], gstr_[13], p5eps_, round_, u_, big_, realns_, temp1_, temp2_, reali_, temp3_, temp4_, temp5_, 
  temp6_, tau_, absh_, erkm2_, erkm1_, erk_, err_, rho_, erkp1_, hnew_, r_;
  int_4 _data_k_2, _data_k_3, $1_, $2_, $4_, $8_, $9_, $10_;
  real_4 $0_, $3_, $5_, $6_, $7_, $11_;
  extern real_4 _r1mach ();
#define _data_n_2 13
  static real_4 _data_l_2[_data_n_2] = {
    2.0,
    4.0,
    8.0,
    16.0,
    32.0,
    64.0,
    128.0,
    256.0,
    512.0,
    1024.0,
    2048.0,
    4096.0,
    8192.0
  };
#define _data_n_3 13
  static real_4 _data_l_3[_data_n_3] = {
    0.5,
    0.0833,
    0.0417,
    0.0264,
    0.0188,
    0.0143,
    0.0114,
    0.00936,
    0.00789,
    0.00679,
    0.00592,
    0.00524,
    0.00468
  };
  if (__calls[7].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[0] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[1] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[2] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[3] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[4] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[5] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[6] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[7] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[8] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[9] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[10] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[11] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    two_[12] = _data_l_2[_data_k_2++];
  }
  if (__calls[7].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[0] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[1] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[2] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[3] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[4] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[5] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[6] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[7] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[8] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[9] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[10] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[11] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    gstr_[12] = _data_l_3[_data_k_3++];
  }
  (*crash_) = TRUE;
  if (_abs ((*h_)) >= (*fouru_) * _abs ((*x_))) {
    goto _l5;
  }
  (*h_) = _sign ((*fouru_) * _abs ((*x_)), (*h_));
  goto _l0;
  _l5:;
  p5eps_ = 0.5 * (*eps_);
  round_ = 0.0;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    round_ = round_ + ($0_ = (y_[l_ - 1] / wt_[l_ - 1]), $0_ * $0_);
  }
  round_ = (*twou_) * sqrtf (round_);
  if (p5eps_ >= round_) {
    goto _l15;
  }
  (*eps_) = 2.0 * round_ * (1.0 + (*fouru_));
  goto _l0;
  _l15:;
  (*crash_) = FALSE;
  g_[0] = 1.0;
  g_[1] = 0.5;
  sig_[0] = 1.0;
  if (! ((*start_))) {
    goto _l99;
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    phi_[l_ - 1 + ((*neqn_)) * ((0))] = yp_[l_ - 1];
    phi_[l_ - 1 + ((*neqn_)) * ((1))] = 0.0;
  }
  u_ = _r1mach (($1_ = 4, &$1_));
  big_ = sqrtf (_r1mach (($2_ = 2, &$2_)));
  (void) _hstart (_f, neqn_, x_, ($3_ = (*x_) + (*h_), &$3_), y_, yp_, wt_, &_k1, &u_, &big_, &phi_[0 + ((*neqn_)) * 
  ((2))], &phi_[0 + ((*neqn_)) * ((3))], &phi_[0 + ((*neqn_)) * ((4))], &phi_[0 + ((*neqn_)) * ((5))], rpar_, ipar_, h_)
  ;
  (*hold_) = 0.0;
  (*k_) = 1;
  (*kold_) = 0;
  (*kprev_) = 0;
  (*start_) = FALSE;
  (*phase1_) = TRUE;
  (*nornd_) = TRUE;
  if (p5eps_ > 100.0 * round_) {
    goto _l99;
  }
  (*nornd_) = FALSE;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    phi_[l_ - 1 + ((*neqn_)) * ((14))] = 0.0;
  }
  _l99:;
  ifail_ = 0;
  _l100:;
  kp1_ = (*k_) + 1;
  kp2_ = (*k_) + 2;
  km1_ = (*k_) - 1;
  km2_ = (*k_) - 2;
  if ((*h_) != (*hold_)) {
    (*ns_) = 0;
  }
  if ((*ns_) <= (*kold_)) {
    (*ns_) = (*ns_) + 1;
  }
  nsp1_ = (*ns_) + 1;
  if ((*k_) < (*ns_)) {
    goto _l199;
  }
  beta_[(*ns_) - 1] = 1.0;
  realns_ = (*ns_);
  alpha_[(*ns_) - 1] = 1.0 / realns_;
  temp1_ = (*h_) * realns_;
  sig_[nsp1_ - 1] = 1.0;
  if ((*k_) < nsp1_) {
    goto _l110;
  }
  for (i_ = nsp1_; i_ <= (*k_); (i_)++) {
    im1_ = i_ - 1;
    temp2_ = psi_[im1_ - 1];
    psi_[im1_ - 1] = temp1_;
    beta_[i_ - 1] = beta_[im1_ - 1] * psi_[im1_ - 1] / temp2_;
    temp1_ = temp2_ + (*h_);
    alpha_[i_ - 1] = (*h_) / temp1_;
    reali_ = i_;
    sig_[i_ + 1 - 1] = reali_ * alpha_[i_ - 1] * sig_[i_ - 1];
  }
  _l110:;
  psi_[(*k_) - 1] = temp1_;
  if ((*ns_) > 1) {
    goto _l120;
  }
  for (iq_ = 1; iq_ <= (*k_); (iq_)++) {
    temp3_ = iq_ * (iq_ + 1);
    v_[iq_ - 1] = 1.0 / temp3_;
    w_[iq_ - 1] = v_[iq_ - 1];
  }
  (*ivc_) = 0;
  (*kgi_) = 0;
  if ((*k_) == 1) {
    goto _l140;
  }
  (*kgi_) = 1;
  gi_[0] = w_[1];
  goto _l140;
  _l120:;
  if ((*k_) <= (*kprev_)) {
    goto _l130;
  }
  if ((*ivc_) == 0) {
    goto _l122;
  }
  jv_ = kp1_ - iv_[(*ivc_) - 1];
  (*ivc_) = (*ivc_) - 1;
  goto _l123;
  _l122:;
  jv_ = 1;
  temp4_ = (*k_) * kp1_;
  v_[(*k_) - 1] = 1.0 / temp4_;
  w_[(*k_) - 1] = v_[(*k_) - 1];
  if ((*k_) != 2) {
    goto _l123;
  }
  (*kgi_) = 1;
  gi_[0] = w_[1];
  _l123:;
  nsm2_ = (*ns_) - 2;
  if (nsm2_ < jv_) {
    goto _l130;
  }
  for (j_ = jv_; j_ <= nsm2_; (j_)++) {
    i_ = (*k_) - j_;
    v_[i_ - 1] = v_[i_ - 1] - alpha_[j_ + 1 - 1] * v_[i_ + 1 - 1];
    w_[i_ - 1] = v_[i_ - 1];
  }
  if (i_ != 2) {
    goto _l130;
  }
  (*kgi_) = (*ns_) - 1;
  gi_[(*kgi_) - 1] = w_[1];
  _l130:;
  limit1_ = kp1_ - (*ns_);
  temp5_ = alpha_[(*ns_) - 1];
  for (iq_ = 1; iq_ <= limit1_; (iq_)++) {
    v_[iq_ - 1] = v_[iq_ - 1] - temp5_ * v_[iq_ + 1 - 1];
    w_[iq_ - 1] = v_[iq_ - 1];
  }
  g_[nsp1_ - 1] = w_[0];
  if (limit1_ == 1) {
    goto _l137;
  }
  (*kgi_) = (*ns_);
  gi_[(*kgi_) - 1] = w_[1];
  _l137:;
  w_[limit1_ + 1 - 1] = v_[limit1_ + 1 - 1];
  if ((*k_) >= (*kold_)) {
    goto _l140;
  }
  (*ivc_) = (*ivc_) + 1;
  iv_[(*ivc_) - 1] = limit1_ + 2;
  _l140:;
  nsp2_ = (*ns_) + 2;
  (*kprev_) = (*k_);
  if (kp1_ < nsp2_) {
    goto _l199;
  }
  for (i_ = nsp2_; i_ <= kp1_; (i_)++) {
    limit2_ = kp2_ - i_;
    temp6_ = alpha_[i_ - 1 - 1];
    for (iq_ = 1; iq_ <= limit2_; (iq_)++) {
      w_[iq_ - 1] = w_[iq_ - 1] - temp6_ * w_[iq_ + 1 - 1];
    }
    g_[i_ - 1] = w_[0];
  }
  _l199:;
  (*ksteps_) = (*ksteps_) + 1;
  if ((*k_) < nsp1_) {
    goto _l215;
  }
  for (i_ = nsp1_; i_ <= (*k_); (i_)++) {
    temp1_ = beta_[i_ - 1];
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] = temp1_ * phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))];
    }
  }
  _l215:;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    phi_[l_ - 1 + ((*neqn_)) * ((kp2_ - 1))] = phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 1))];
    phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 1))] = 0.0;
    p_[l_ - 1] = 0.0;
  }
  for (j_ = 1; j_ <= (*k_); (j_)++) {
    i_ = kp1_ - j_;
    ip1_ = i_ + 1;
    temp2_ = g_[i_ - 1];
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      p_[l_ - 1] = p_[l_ - 1] + temp2_ * phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))];
      phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] = phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] + phi_[l_ - 1 + ((*neqn_)) * ((ip1_ - 
      1))];
    }
  }
  if ((*nornd_)) {
    goto _l240;
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    tau_ = (*h_) * p_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((14))];
    p_[l_ - 1] = y_[l_ - 1] + tau_;
    phi_[l_ - 1 + ((*neqn_)) * ((15))] = (p_[l_ - 1] - y_[l_ - 1]) - tau_;
  }
  goto _l250;
  _l240:;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    p_[l_ - 1] = y_[l_ - 1] + (*h_) * p_[l_ - 1];
  }
  _l250:;
  (*xold_) = (*x_);
  (*x_) = (*x_) + (*h_);
  absh_ = _abs ((*h_));
  (void) _f (x_, p_, yp_, rpar_, ipar_);
  erkm2_ = 0.0;
  erkm1_ = 0.0;
  erk_ = 0.0;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    temp3_ = 1.0 / wt_[l_ - 1];
    temp4_ = yp_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((0))];
    $4_ = km2_;
    if ($4_ < 0) {
      goto _l265;
    } else if ($4_ == 0) {
      goto _l260;
    } else {
      goto _l255;
    }
    _l255:;
    erkm2_ = erkm2_ + ($5_ = ((phi_[l_ - 1 + ((*neqn_)) * ((km1_ - 1))] + temp4_) * temp3_), $5_ * $5_);
    _l260:;
    erkm1_ = erkm1_ + ($6_ = ((phi_[l_ - 1 + ((*neqn_)) * (((*k_) - 1))] + temp4_) * temp3_), $6_ * $6_);
    _l265:;
    erk_ = erk_ + ($7_ = (temp4_ * temp3_), $7_ * $7_);
  }
  $8_ = km2_;
  if ($8_ < 0) {
    goto _l280;
  } else if ($8_ == 0) {
    goto _l275;
  } else {
    goto _l270;
  }
  _l270:;
  erkm2_ = absh_ * sig_[km1_ - 1] * gstr_[km2_ - 1] * sqrtf (erkm2_);
  _l275:;
  erkm1_ = absh_ * sig_[(*k_) - 1] * gstr_[km1_ - 1] * sqrtf (erkm1_);
  _l280:;
  temp5_ = absh_ * sqrtf (erk_);
  err_ = temp5_ * (g_[(*k_) - 1] - g_[kp1_ - 1]);
  erk_ = temp5_ * sig_[kp1_ - 1] * gstr_[(*k_) - 1];
  knew_ = (*k_);
  $9_ = km2_;
  if ($9_ < 0) {
    goto _l299;
  } else if ($9_ == 0) {
    goto _l290;
  } else {
    goto _l285;
  }
  _l285:;
  if (_max (erkm1_, erkm2_) <= erk_) {
    knew_ = km1_;
  }
  goto _l299;
  _l290:;
  if (erkm1_ <= 0.5 * erk_) {
    knew_ = km1_;
  }
  _l299:;
  if (err_ <= (*eps_)) {
    goto _l400;
  }
  (*phase1_) = FALSE;
  (*x_) = (*xold_);
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    temp1_ = 1.0 / beta_[i_ - 1];
    ip1_ = i_ + 1;
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] = temp1_ * (phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] - phi_[l_ - 1 + ((*neqn_)) * 
      ((ip1_ - 1))]);
    }
  }
  if ((*k_) < 2) {
    goto _l320;
  }
  for (i_ = 2; i_ <= (*k_); (i_)++) {
    psi_[i_ - 1 - 1] = psi_[i_ - 1] - (*h_);
  }
  _l320:;
  ifail_ = ifail_ + 1;
  temp2_ = 0.5;
  $10_ = ifail_ - 3;
  if ($10_ < 0) {
    goto _l335;
  } else if ($10_ == 0) {
    goto _l330;
  } else {
    goto _l325;
  }
  _l325:;
  if (p5eps_ < 0.25 * erk_) {
    temp2_ = sqrtf (p5eps_ / erk_);
  }
  _l330:;
  knew_ = 1;
  _l335:;
  (*h_) = temp2_ * (*h_);
  (*k_) = knew_;
  (*ns_) = 0;
  if (_abs ((*h_)) >= (*fouru_) * _abs ((*x_))) {
    goto _l340;
  }
  (*crash_) = TRUE;
  (*h_) = _sign ((*fouru_) * _abs ((*x_)), (*h_));
  (*eps_) = (*eps_) + (*eps_);
  goto _l0;
  _l340:;
  goto _l100;
  _l400:;
  (*kold_) = (*k_);
  (*hold_) = (*h_);
  temp1_ = (*h_) * g_[kp1_ - 1];
  if ((*nornd_)) {
    goto _l410;
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    temp3_ = y_[l_ - 1];
    rho_ = temp1_ * (yp_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((0))]) - phi_[l_ - 1 + ((*neqn_)) * ((15))];
    y_[l_ - 1] = p_[l_ - 1] + rho_;
    phi_[l_ - 1 + ((*neqn_)) * ((14))] = (y_[l_ - 1] - p_[l_ - 1]) - rho_;
    p_[l_ - 1] = temp3_;
  }
  goto _l420;
  _l410:;
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    temp3_ = y_[l_ - 1];
    y_[l_ - 1] = p_[l_ - 1] + temp1_ * (yp_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((0))]);
    p_[l_ - 1] = temp3_;
  }
  _l420:;
  (void) _f (x_, y_, yp_, rpar_, ipar_);
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 1))] = yp_[l_ - 1] - phi_[l_ - 1 + ((*neqn_)) * ((0))];
    phi_[l_ - 1 + ((*neqn_)) * ((kp2_ - 1))] = phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 1))] - phi_[l_ - 1 + ((*neqn_)) * ((kp2_ 
    - 1))];
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    for (l_ = 1; l_ <= (*neqn_); (l_)++) {
      phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] = phi_[l_ - 1 + ((*neqn_)) * ((i_ - 1))] + phi_[l_ - 1 + ((*neqn_)) * ((kp1_ - 
      1))];
    }
  }
  erkp1_ = 0.0;
  if (knew_ == km1_ || (*k_) == 12) {
    (*phase1_) = FALSE;
  }
  if ((*phase1_)) {
    goto _l450;
  }
  if (knew_ == km1_) {
    goto _l455;
  }
  if (kp1_ > (*ns_)) {
    goto _l460;
  }
  for (l_ = 1; l_ <= (*neqn_); (l_)++) {
    erkp1_ = erkp1_ + ($11_ = (phi_[l_ - 1 + ((*neqn_)) * ((kp2_ - 1))] / wt_[l_ - 1]), $11_ * $11_);
  }
  erkp1_ = absh_ * gstr_[kp1_ - 1] * sqrtf (erkp1_);
  if ((*k_) > 1) {
    goto _l445;
  }
  if (erkp1_ >= 0.5 * erk_) {
    goto _l460;
  }
  goto _l450;
  _l445:;
  if (erkm1_ <= _min (erk_, erkp1_)) {
    goto _l455;
  }
  if (erkp1_ >= erk_ || (*k_) == 12) {
    goto _l460;
  }
  _l450:;
  (*k_) = kp1_;
  erk_ = erkp1_;
  goto _l460;
  _l455:;
  (*k_) = km1_;
  erk_ = erkm1_;
  _l460:;
  hnew_ = (*h_) + (*h_);
  if ((*phase1_)) {
    goto _l465;
  }
  if (p5eps_ >= erk_ * two_[(*k_) + 1 - 1]) {
    goto _l465;
  }
  hnew_ = (*h_);
  if (p5eps_ >= erk_) {
    goto _l465;
  }
  temp2_ = (*k_) + 1;
  r_ = powl ((p5eps_ / erk_), (1.0 / temp2_));
  hnew_ = absh_ * _max (0.5, _min (0.9, r_));
  hnew_ = _sign (_max (hnew_, (*fouru_) * _abs ((*x_))), (*h_));
  _l465:;
  (*h_) = hnew_;
  _l0:;
  __calls[7].calls++;
  return 0;
}

