//! @file mathlib-slatec-extended.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 22 subprograms from SLATEC-EXTENDED

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// DXADD  DXNRMP DXPNRM DXQMU  DXSET  XCON   XNRMP  XPMUP  XPQNU  XQNU
// DXCON  DXPMU  DXPQNU DXQNU  XADD   XLEGF  XPMU   XPNRM  XQMU   XSET
// DXLEGF DXPMUP

// The license for SLATEC Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "SLATEC"
#define _dc_1 "DXLEGF"
#define _dc_2 "DNU1, NUDIFF, MU1, MU2, or ID not valid"
#define _dc_3 "THETA out of range"
#define _dc_4 "slatec"
#define _dc_5 "dxnrmp"
#define _dc_6 "nu, mu1, mu2 or mode not valid"
#define _dc_7 "darg out of range"
#define _dc_8 "dxset"
#define _dc_9 "improper value of irad"
#define _dc_10 "improper value of dzero"
#define _dc_11 "improper value of nbits"
#define _dc_12 "improper value of nradpl"
#define _dc_13 "nradpl .ge. l"
#define _dc_14 "6*l .gt. kmax"
#define _dc_15 "XLEGF"
#define _dc_16 "xnrmp"
#define _dc_17 "sarg out of range"
#define _dc_18 "xset"
static FORMAT *__fmt_a = NULL;
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
#define __ncalls 23
static CALLS __calls[__ncalls] = {
  {"dxadd", 0}, // subroutine
  {"dxcon", 0}, // subroutine
  {"dxlegf", 0}, // subroutine
  {"dxnrmp", 0}, // subroutine
  {"dxpmu", 0}, // subroutine
  {"dxpmup", 0}, // subroutine
  {"dxpnrm", 0}, // subroutine
  {"dxpqnu", 0}, // subroutine
  {"dxqmu", 0}, // subroutine
  {"dxqnu", 0}, // subroutine
  {"dxset", 0}, // subroutine
  {"xadd", 0}, // subroutine
  {"xcon", 0}, // subroutine
  {"xlegf", 0}, // subroutine
  {"xnrmp", 0}, // subroutine
  {"xpmu", 0}, // subroutine
  {"xpmup", 0}, // subroutine
  {"xpnrm", 0}, // subroutine
  {"xpqnu", 0}, // subroutine
  {"xqmu", 0}, // subroutine
  {"xqnu", 0}, // subroutine
  {"xset", 0}, // subroutine
  {NULL, 0}
};

static struct {
  int_4 l_, l2_, kmax_;
  real_8 radix_, radixl_, rad2l_, dlg10r_;
} dxblk2_;
static struct {
  int_4 nbitsf_;
} dxblk1_;
static struct {
  int_4 nlg102_, mlg102_, lg102_[21];
} dxblk3_;
static struct {
  int_4 l_, l2_, kmax_;
  real_4 radix_, radixl_, rad2l_, dlg10r_;
} xblk2_;
static struct {
  int_4 nbitsf_;
} xblk1_;
static struct {
  int_4 nlg102_, mlg102_, lg102_[21];
} xblk3_;
prototype int_4 _dxadd (real_8 _p_ x_, int_4 _p_ ix_, real_8 _p_ y_, int_4 _p_ iy_, real_8 _p_ z_, int_4 _p_ iz_, int_4 
_p_ ierror_);
prototype int_4 _dxcon (real_8 _p_ x_, int_4 _p_ ix_, int_4 _p_ ierror_);
prototype int_4 _dxlegf (real_8 _p_ dnu1_, int_4 _p_ nudiff_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ theta_, int_4 
_p_ id_, real_8 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _dxnrmp (int_4 _p_ nu_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ darg_, int_4 _p_ mode_, real_8 _p_ 
dpn_, int_4 _p_ ipn_, int_4 _p_ isig_, int_4 _p_ ierror_);
prototype int_4 _dxpmu (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ theta_, real_8 _p_ 
x_, real_8 _p_ sx_, int_4 _p_ id_, real_8 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _dxpmup (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ pqa_, int_4 _p_ 
ipqa_, int_4 _p_ ierror_);
prototype int_4 _dxpnrm (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ pqa_, int_4 _p_ 
ipqa_, int_4 _p_ ierror_);
prototype int_4 _dxpqnu (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu_, real_8 _p_ theta_, int_4 _p_ id_, real_8 _p_ 
pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _dxqmu (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ theta_, real_8 _p_ 
x_, real_8 _p_ sx_, int_4 _p_ id_, real_8 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _dxqnu (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, real_8 _p_ theta_, real_8 _p_ x_, real_8 _p_ 
sx_, int_4 _p_ id_, real_8 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _dxset (int_4 _p_ irad_, int_4 _p_ nradpl_, real_8 _p_ dzero_, int_4 _p_ nbits_, int_4 _p_ ierror_);
prototype int_4 _xadd (real_4 _p_ x_, int_4 _p_ ix_, real_4 _p_ y_, int_4 _p_ iy_, real_4 _p_ z_, int_4 _p_ iz_, int_4 
_p_ ierror_);
prototype int_4 _xcon (real_4 _p_ x_, int_4 _p_ ix_, int_4 _p_ ierror_);
prototype int_4 _xlegf (real_4 _p_ dnu1_, int_4 _p_ nudiff_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ theta_, int_4 
_p_ id_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _xnrmp (int_4 _p_ nu_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ sarg_, int_4 _p_ mode_, real_4 _p_ 
spn_, int_4 _p_ ipn_, int_4 _p_ isig_, int_4 _p_ ierror_);
prototype int_4 _xpmu (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ theta_, real_4 _p_ 
x_, real_4 _p_ sx_, int_4 _p_ id_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _xpmup (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ pqa_, int_4 _p_ 
ipqa_, int_4 _p_ ierror_);
prototype int_4 _xpnrm (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ pqa_, int_4 _p_ 
ipqa_, int_4 _p_ ierror_);
prototype int_4 _xpqnu (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu_, real_4 _p_ theta_, int_4 _p_ id_, real_4 _p_ 
pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _xqmu (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ theta_, real_4 _p_ 
x_, real_4 _p_ sx_, int_4 _p_ id_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _xqnu (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, real_4 _p_ theta_, real_4 _p_ x_, real_4 _p_ 
sx_, int_4 _p_ id_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_);
prototype int_4 _xset (int_4 _p_ irad_, int_4 _p_ nradpl_, real_4 _p_ dzero_, int_4 _p_ nbits_, int_4 _p_ ierror_);
int_4 _dxadd (real_8 _p_ x_, int_4 _p_ ix_, real_8 _p_ y_, int_4 _p_ iy_, real_8 _p_ z_, int_4 _p_ iz_, int_4 _p_ 
ierror_)
{
  static int_4 i_, is_, i1_, i2_, j_;
  static real_8 s_, t_;
  int_4 $0_;
  (*ierror_) = 0;
  if ((*x_) != 0.0e0) {
    goto _l10;
  }
  (*z_) = (*y_);
  (*iz_) = (*iy_);
  goto _l220;
  _l10:;
  if ((*y_) != 0.0e0) {
    goto _l20;
  }
  (*z_) = (*x_);
  (*iz_) = (*ix_);
  goto _l220;
  _l20:;
  if ((*ix_) >= 0 && (*iy_) >= 0) {
    goto _l40;
  }
  if ((*ix_) < 0 && (*iy_) < 0) {
    goto _l40;
  }
  if (_abs ((*ix_)) <= 6 * dxblk2_.l_ && _abs ((*iy_)) <= 6 * dxblk2_.l_) {
    goto _l40;
  }
  if ((*ix_) >= 0) {
    goto _l30;
  }
  (*z_) = (*y_);
  (*iz_) = (*iy_);
  goto _l220;
  _l30:;
  (*z_) = (*x_);
  (*iz_) = (*ix_);
  goto _l220;
  _l40:;
  i_ = (*ix_) - (*iy_);
  $0_ = i_;
  if ($0_ < 0) {
    goto _l80;
  } else if ($0_ == 0) {
    goto _l50;
  } else {
    goto _l90;
  }
  _l50:;
  if (_abs ((*x_)) > 1.0e0 && _abs ((*y_)) > 1.0e0) {
    goto _l60;
  }
  if (_abs ((*x_)) < 1.0e0 && _abs ((*y_)) < 1.0e0) {
    goto _l70;
  }
  (*z_) = (*x_) + (*y_);
  (*iz_) = (*ix_);
  goto _l220;
  _l60:;
  s_ = (*x_) / dxblk2_.radixl_;
  t_ = (*y_) / dxblk2_.radixl_;
  (*z_) = s_ + t_;
  (*iz_) = (*ix_) + dxblk2_.l_;
  goto _l220;
  _l70:;
  s_ = (*x_) * dxblk2_.radixl_;
  t_ = (*y_) * dxblk2_.radixl_;
  (*z_) = s_ + t_;
  (*iz_) = (*ix_) - dxblk2_.l_;
  goto _l220;
  _l80:;
  s_ = (*y_);
  is_ = (*iy_);
  t_ = (*x_);
  goto _l100;
  _l90:;
  s_ = (*x_);
  is_ = (*ix_);
  t_ = (*y_);
  _l100:;
  i1_ = _abs (i_) / dxblk2_.l_;
  i2_ = _imod (_abs (i_), dxblk2_.l_);
  if (_abs (t_) >= dxblk2_.radixl_) {
    goto _l130;
  }
  if (_abs (t_) >= 1.0e0) {
    goto _l120;
  }
  if (dxblk2_.radixl_ * _abs (t_) >= 1.0e0) {
    goto _l110;
  }
  j_ = i1_ + 1;
  t_ = t_ * _up_real_8 (dxblk2_.radix_, (dxblk2_.l_ - i2_));
  goto _l140;
  _l110:;
  j_ = i1_;
  t_ = t_ * _up_real_8 (dxblk2_.radix_, (-i2_));
  goto _l140;
  _l120:;
  j_ = i1_ - 1;
  if (j_ < 0) {
    goto _l110;
  }
  t_ = t_ * _up_real_8 (dxblk2_.radix_, (-i2_)) / dxblk2_.radixl_;
  goto _l140;
  _l130:;
  j_ = i1_ - 2;
  if (j_ < 0) {
    goto _l120;
  }
  t_ = t_ * _up_real_8 (dxblk2_.radix_, (-i2_)) / dxblk2_.rad2l_;
  _l140:;
  if (j_ == 0) {
    goto _l190;
  }
  if (_abs (s_) >= dxblk2_.radixl_ || j_ > 3) {
    goto _l150;
  }
  if (_abs (s_) >= 1.0e0) {
    switch (j_) {
      default:
      case 1: goto _l180;
      case 2: goto _l150;
      case 3: goto _l150;
    }
  }
  if (dxblk2_.radixl_ * _abs (s_) >= 1.0e0) {
    switch (j_) {
      default:
      case 1: goto _l180;
      case 2: goto _l170;
      case 3: goto _l150;
    }
  }
  switch (j_) {
    default:
    case 1: goto _l180;
    case 2: goto _l170;
    case 3: goto _l160;
  }
  _l150:;
  (*z_) = s_;
  (*iz_) = is_;
  goto _l220;
  _l160:;
  s_ = s_ * dxblk2_.radixl_;
  _l170:;
  s_ = s_ * dxblk2_.radixl_;
  _l180:;
  s_ = s_ * dxblk2_.radixl_;
  _l190:;
  if (_abs (s_) > 1.0e0 && _abs (t_) > 1.0e0) {
    goto _l200;
  }
  if (_abs (s_) < 1.0e0 && _abs (t_) < 1.0e0) {
    goto _l210;
  }
  (*z_) = s_ + t_;
  (*iz_) = is_ - j_ * dxblk2_.l_;
  goto _l220;
  _l200:;
  s_ = s_ / dxblk2_.radixl_;
  t_ = t_ / dxblk2_.radixl_;
  (*z_) = s_ + t_;
  (*iz_) = is_ - j_ * dxblk2_.l_ + dxblk2_.l_;
  goto _l220;
  _l210:;
  s_ = s_ * dxblk2_.radixl_;
  t_ = t_ * dxblk2_.radixl_;
  (*z_) = s_ + t_;
  (*iz_) = is_ - j_ * dxblk2_.l_ - dxblk2_.l_;
  _l220:;
  (void) _dxadj (z_, iz_, ierror_);
  __calls[0].calls++;
  return 0;
}

int_4 _dxcon (real_8 _p_ x_, int_4 _p_ ix_, int_4 _p_ ierror_)
{
  static int_4 ispace_, itemp_, icase_, i_, j_, i1_, j1_, j2_;
  static real_8 a_, b_, z_;
  int_4 _data_k_0;
#define _data_n_0 1
  static int_4 _data_l_0[_data_n_0] = {
    1
  };
  if (__calls[1].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    ispace_ = _data_l_0[_data_k_0++];
  }
  (*ierror_) = 0;
  (void) _dxred (x_, ix_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*ix_) == 0) {
    goto _l150;
  }
  (void) _dxadj (x_, ix_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  itemp_ = 1;
  icase_ = (3 + _sign (itemp_, (*ix_))) / 2;
  switch (icase_) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  if (_abs ((*x_)) < 1.0e0) {
    goto _l30;
  }
  (*x_) = (*x_) / dxblk2_.radixl_;
  (*ix_) = (*ix_) + dxblk2_.l_;
  goto _l30;
  _l20:;
  if (_abs ((*x_)) >= 1.0e0) {
    goto _l30;
  }
  (*x_) = (*x_) * dxblk2_.radixl_;
  (*ix_) = (*ix_) - dxblk2_.l_;
  _l30:;
  i_ = log10 (_abs ((*x_))) / dxblk2_.dlg10r_;
  a_ = _up_real_8 (dxblk2_.radix_, i_);
  switch (icase_) {
    default:
    case 1: goto _l40;
    case 2: goto _l60;
  }
  _l40:;
  if (a_ <= dxblk2_.radix_ * _abs ((*x_))) {
    goto _l50;
  }
  i_ = i_ - 1;
  a_ = a_ / dxblk2_.radix_;
  goto _l40;
  _l50:;
  if (_abs ((*x_)) < a_) {
    goto _l80;
  }
  i_ = i_ + 1;
  a_ = a_ * dxblk2_.radix_;
  goto _l50;
  _l60:;
  if (a_ <= _abs ((*x_))) {
    goto _l70;
  }
  i_ = i_ - 1;
  a_ = a_ / dxblk2_.radix_;
  goto _l60;
  _l70:;
  if (_abs ((*x_)) < dxblk2_.radix_ * a_) {
    goto _l80;
  }
  i_ = i_ + 1;
  a_ = a_ * dxblk2_.radix_;
  goto _l70;
  _l80:;
  itemp_ = ispace_ / dxblk2_.dlg10r_;
  a_ = _up_real_8 (dxblk2_.radix_, itemp_);
  b_ = _up_real_8 (10.0e0, ispace_);
  _l90:;
  if (a_ <= b_) {
    goto _l100;
  }
  itemp_ = itemp_ - 1;
  a_ = a_ / dxblk2_.radix_;
  goto _l90;
  _l100:;
  if (b_ < a_ * dxblk2_.radix_) {
    goto _l110;
  }
  itemp_ = itemp_ + 1;
  a_ = a_ * dxblk2_.radix_;
  goto _l100;
  _l110:;
  if (itemp_ > 0) {
    goto _l120;
  }
  (*x_) = (*x_) * _up_real_8 (dxblk2_.radix_, (-i_));
  (*ix_) = (*ix_) + i_;
  (void) _dxc210 (ix_, &z_, &j_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (*x_) = (*x_) * z_;
  (*ix_) = j_;
  switch (icase_) {
    default:
    case 1: goto _l130;
    case 2: goto _l140;
  }
  _l120:;
  i1_ = i_ / itemp_;
  (*x_) = (*x_) * _up_real_8 (dxblk2_.radix_, (-i1_ * itemp_));
  (*ix_) = (*ix_) + i1_ * itemp_;
  (void) _dxc210 (ix_, &z_, &j_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  j1_ = j_ / ispace_;
  j2_ = j_ - j1_ * ispace_;
  (*x_) = (*x_) * z_ * _up_real_8 (10.0e0, j2_);
  (*ix_) = j1_ * ispace_;
  switch (icase_) {
    default:
    case 1: goto _l130;
    case 2: goto _l140;
  }
  _l130:;
  if (b_ * _abs ((*x_)) >= 1.0e0) {
    goto _l150;
  }
  (*x_) = (*x_) * b_;
  (*ix_) = (*ix_) - ispace_;
  goto _l130;
  _l140:;
  if (10.0e0 * _abs ((*x_)) < b_) {
    goto _l150;
  }
  (*x_) = (*x_) / b_;
  (*ix_) = (*ix_) + ispace_;
  goto _l140;
  _l150:;
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _dxlegf (real_8 _p_ dnu1_, int_4 _p_ nudiff_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ theta_, int_4 _p_ id_, 
real_8 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 l_, i_;
  static real_8 dnu2_, sx_, x_, pi2_;
  int_4 $1_, $2_;
  real_8 $0_;
  (*ierror_) = 0;
  (void) _dxset (&_k0, &_k0, ($0_ = 0.0, &$0_), &_k0, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pi2_ = 1.5707963267948966;
  l_ = ((*mu2_) - (*mu1_)) + (*nudiff_) + 1;
  for (i_ = 1; i_ <= l_; (i_)++) {
    pqa_[i_ - 1] = 0.0;
    ipqa_[i_ - 1] = 0;
  }
  if ((*nudiff_) < 0) {
    goto _l400;
  }
  if ((*dnu1_) < -.5e0) {
    goto _l400;
  }
  if ((*mu2_) < (*mu1_)) {
    goto _l400;
  }
  if ((*mu1_) < 0) {
    goto _l400;
  }
  if ((*theta_) <= 0.0e0 || (*theta_) > pi2_) {
    goto _l420;
  }
  if ((*id_) < 1 || (*id_) > 4) {
    goto _l400;
  }
  if (((*mu1_) != (*mu2_)) && ((*nudiff_) > 0)) {
    goto _l400;
  }
  dnu2_ = (*dnu1_) + (*nudiff_);
  if (((*id_) == 3) && (fmod ((*dnu1_), 1.0) != 0.0e0)) {
    goto _l295;
  }
  if (((*id_) == 4) && (fmod ((*dnu1_), 1.0) != 0.0e0)) {
    goto _l400;
  }
  if (((*id_) == 3 || (*id_) == 4) && (*mu1_) > dnu2_) {
    goto _l0;
  }
  _l295:;
  x_ = cos ((*theta_));
  sx_ = 1.0e0 / sin ((*theta_));
  if ((*id_) == 2) {
    goto _l300;
  }
  if ((*mu2_) - (*mu1_) <= 0) {
    goto _l360;
  }
  (void) _dxpmu (dnu1_, &dnu2_, mu1_, mu2_, theta_, &x_, &sx_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  goto _l380;
  _l300:;
  if ((*mu2_) == (*mu1_)) {
    goto _l320;
  }
  (void) _dxqmu (dnu1_, &dnu2_, mu1_, mu2_, theta_, &x_, &sx_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  goto _l390;
  _l320:;
  (void) _dxqnu (dnu1_, &dnu2_, mu1_, theta_, &x_, &sx_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  goto _l390;
  _l360:;
  (void) _dxpqnu (dnu1_, &dnu2_, mu1_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l380:;
  if ((*id_) == 3) {
    (void) _dxpmup (dnu1_, &dnu2_, mu1_, mu2_, pqa_, ipqa_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*id_) == 4) {
    (void) _dxpnrm (dnu1_, &dnu2_, mu1_, mu2_, pqa_, ipqa_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l390:;
  for (i_ = 1; i_ <= l_; (i_)++) {
    (void) _dxred (&pqa_[i_ - 1], &ipqa_[i_ - 1], ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
  }
  goto _l0;
  _l400:;
  (void) _xermsg (_dc_0, _dc_1, _dc_2, ($1_ = 210, &$1_), &_k1);
  (*ierror_) = 210;
  goto _l0;
  _l420:;
  (void) _xermsg (_dc_0, _dc_1, _dc_3, ($2_ = 211, &$2_), &_k1);
  (*ierror_) = 211;
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _dxnrmp (int_4 _p_ nu_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ darg_, int_4 _p_ mode_, real_8 _p_ dpn_, int_4 
_p_ ipn_, int_4 _p_ isig_, int_4 _p_ ierror_)
{
  static int_4 mu_, i_, ip1_, ip2_, j_, ip_, k_;
  static real_8 c1_, c2_, p_, p1_, p2_, p3_, s_, sx_, t_, tx_, x_, dk_;
  int_4 $1_, $2_;
  real_8 $0_;
  (*ierror_) = 0;
  (void) _dxset (&_k0, &_k0, ($0_ = 0.0, &$0_), &_k0, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*nu_) < 0) {
    goto _l110;
  }
  if ((*mu1_) < 0) {
    goto _l110;
  }
  if ((*mu1_) > (*mu2_)) {
    goto _l110;
  }
  if ((*nu_) == 0) {
    goto _l90;
  }
  if ((*mode_) < 1 || (*mode_) > 2) {
    goto _l110;
  }
  switch ((*mode_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  if (_abs ((*darg_)) > 1.0e0) {
    goto _l120;
  }
  if (_abs ((*darg_)) == 1.0e0) {
    goto _l90;
  }
  x_ = (*darg_);
  sx_ = sqrt ((1.0e0 + _abs (x_)) * ((0.5e0 - _abs (x_)) + 0.5e0));
  tx_ = x_ / sx_;
  (*isig_) = log10 (2.0e0 * (*nu_) * (5.0e0 + (tx_ * tx_)));
  goto _l30;
  _l20:;
  if (_abs ((*darg_)) > 4.0e0 * 0.7853981633974483096156608458198757210492923498437764552437361480769541) {
    goto _l120;
  }
  if ((*darg_) == 0.0e0) {
    goto _l90;
  }
  x_ = cos ((*darg_));
  sx_ = _abs (sin ((*darg_)));
  tx_ = x_ / sx_;
  (*isig_) = log10 (2.0e0 * (*nu_) * (5.0e0 + _abs ((*darg_) * tx_)));
  _l30:;
  mu_ = (*mu2_);
  i_ = (*mu2_) - (*mu1_) + 1;
  _l40:;
  if (mu_ <= (*nu_)) {
    goto _l50;
  }
  dpn_[i_ - 1] = 0.0;
  ipn_[i_ - 1] = 0;
  i_ = i_ - 1;
  mu_ = mu_ - 1;
  if (i_ > 0) {
    goto _l40;
  }
  (*isig_) = 0;
  goto _l160;
  _l50:;
  mu_ = (*nu_);
  p1_ = 0.0;
  ip1_ = 0;
  p2_ = 1.0;
  ip2_ = 0;
  p3_ = 0.5;
  dk_ = 2.0;
  for (j_ = 1; j_ <= (*nu_); (j_)++) {
    p3_ = ((dk_ + 1.0e0) / dk_) * p3_;
    p2_ = p2_ * sx_;
    (void) _dxadj (&p2_, &ip2_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    dk_ = dk_ + 2.0e0;
  }
  p2_ = p2_ * sqrt (p3_);
  (void) _dxadj (&p2_, &ip2_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  s_ = 2.0e0 * tx_;
  t_ = 1.0e0 / (*nu_);
  if ((*mu2_) < (*nu_)) {
    goto _l70;
  }
  dpn_[i_ - 1] = p2_;
  ipn_[i_ - 1] = ip2_;
  i_ = i_ - 1;
  if (i_ == 0) {
    goto _l140;
  }
  _l70:;
  p_ = mu_ * t_;
  c1_ = 1.0e0 / sqrt ((1.0e0 - p_ + t_) * (1.0e0 + p_));
  c2_ = s_ * p_ * c1_ * p2_;
  c1_ = -sqrt ((1.0e0 + p_ + t_) * (1.0e0 - p_)) * c1_ * p1_;
  (void) _dxadd (&c2_, &ip2_, &c1_, &ip1_, &p_, &ip_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  mu_ = mu_ - 1;
  if (mu_ > (*mu2_)) {
    goto _l80;
  }
  dpn_[i_ - 1] = p_;
  ipn_[i_ - 1] = ip_;
  i_ = i_ - 1;
  if (i_ == 0) {
    goto _l140;
  }
  _l80:;
  p1_ = p2_;
  ip1_ = ip2_;
  p2_ = p_;
  ip2_ = ip_;
  if (mu_ <= (*mu1_)) {
    goto _l140;
  }
  goto _l70;
  _l90:;
  k_ = (*mu2_) - (*mu1_) + 1;
  for (i_ = 1; i_ <= k_; (i_)++) {
    dpn_[i_ - 1] = 0.0;
    ipn_[i_ - 1] = 0;
  }
  (*isig_) = 0;
  if ((*mu1_) > 0) {
    goto _l160;
  }
  (*isig_) = 1;
  dpn_[0] = sqrt ((*nu_) + 0.5e0);
  ipn_[0] = 0;
  if (_imod ((*nu_), 2) == 0) {
    goto _l160;
  }
  if ((*mode_) == 1 && (*darg_) == 1.0e0) {
    goto _l160;
  }
  if ((*mode_) == 2) {
    goto _l160;
  }
  dpn_[0] = -dpn_[0];
  goto _l160;
  _l110:;
  (void) _xermsg (_dc_4, _dc_5, _dc_6, ($1_ = 212, &$1_), &_k1);
  (*ierror_) = 212;
  goto _l0;
  _l120:;
  (void) _xermsg (_dc_4, _dc_5, _dc_7, ($2_ = 213, &$2_), &_k1);
  (*ierror_) = 213;
  goto _l0;
  _l140:;
  k_ = (*mu2_) - (*mu1_) + 1;
  for (i_ = 1; i_ <= k_; (i_)++) {
    (void) _dxred (&dpn_[i_ - 1], &ipn_[i_ - 1], ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
  }
  _l160:;
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _dxpmu (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ theta_, real_8 _p_ x_, 
real_8 _p_ sx_, int_4 _p_ id_, real_8 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 ip0_, mu_, n_, j_;
  static real_8 p0_, x1_, x2_;
  (*ierror_) = 0;
  (void) _dxpqnu (nu1_, nu2_, mu2_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  p0_ = pqa_[0];
  ip0_ = ipqa_[0];
  mu_ = (*mu2_) - 1;
  (void) _dxpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  n_ = (*mu2_) - (*mu1_) + 1;
  pqa_[n_ - 1] = p0_;
  ipqa_[n_ - 1] = ip0_;
  if (n_ == 1) {
    goto _l300;
  }
  pqa_[n_ - 1 - 1] = pqa_[0];
  ipqa_[n_ - 1 - 1] = ipqa_[0];
  if (n_ == 2) {
    goto _l300;
  }
  j_ = n_ - 2;
  _l290:;
  x1_ = 2.0e0 * mu_ * (*x_) * (*sx_) * pqa_[j_ + 1 - 1];
  x2_ = -((*nu1_) - mu_) * ((*nu1_) + mu_ + 1.0e0) * pqa_[j_ + 2 - 1];
  (void) _dxadd (&x1_, &ipqa_[j_ + 1 - 1], &x2_, &ipqa_[j_ + 2 - 1], &pqa_[j_ - 1], &ipqa_[j_ - 1], ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _dxadj (&pqa_[j_ - 1], &ipqa_[j_ - 1], ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if (j_ == 1) {
    goto _l300;
  }
  j_ = j_ - 1;
  mu_ = mu_ - 1;
  goto _l290;
  _l300:;
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _dxpmup (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ pqa_, int_4 _p_ ipqa_, 
int_4 _p_ ierror_)
{
  static int_4 mu_, n_, j_, iprod_, k_, l_, i_;
  static real_8 dmu_, nu_, prod_;
  (*ierror_) = 0;
  nu_ = (*nu1_);
  mu_ = (*mu1_);
  dmu_ = mu_;
  n_ = (int_4) (_aintd ((*nu2_) - (*nu1_) + .1e0)) + ((*mu2_) - (*mu1_)) + 1;
  j_ = 1;
  if (fmodf ((real_4) (nu_), 1.0) != 0.0) {
    goto _l210;
  }
  _l200:;
  if (dmu_ < nu_ + 1.0e0) {
    goto _l210;
  }
  pqa_[j_ - 1] = 0.0;
  ipqa_[j_ - 1] = 0;
  j_ = j_ + 1;
  if (j_ > n_) {
    goto _l0;
  }
  if ((*nu2_) - (*nu1_) > .5e0) {
    nu_ = nu_ + 1.0e0;
  }
  if ((*mu2_) > (*mu1_)) {
    mu_ = mu_ + 1;
  }
  goto _l200;
  _l210:;
  prod_ = 1.0;
  iprod_ = 0;
  k_ = 2 * mu_;
  if (k_ == 0) {
    goto _l222;
  }
  for (l_ = 1; l_ <= k_; (l_)++) {
    prod_ = prod_ * (dmu_ - nu_ - l_);
    (void) _dxadj (&prod_, &iprod_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l222:;
  for (i_ = j_; i_ <= n_; (i_)++) {
    if (mu_ == 0) {
      goto _l225;
    }
    pqa_[i_ - 1] = pqa_[i_ - 1] * prod_ * _up_int_4 (-1, mu_);
    ipqa_[i_ - 1] = ipqa_[i_ - 1] + iprod_;
    (void) _dxadj (&pqa_[i_ - 1], &ipqa_[i_ - 1], ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    _l225:;
    if ((*nu2_) - (*nu1_) > .5e0) {
      goto _l230;
    }
    prod_ = (dmu_ - nu_) * prod_ * (-dmu_ - nu_ - 1.0e0);
    (void) _dxadj (&prod_, &iprod_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    mu_ = mu_ + 1;
    dmu_ = dmu_ + 1.0e0;
    goto _l240;
    _l230:;
    prod_ = prod_ * (-dmu_ - nu_ - 1.0e0) / (dmu_ - nu_ - 1.0e0);
    (void) _dxadj (&prod_, &iprod_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    nu_ = nu_ + 1.0e0;
    _l240:;
  }
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _dxpnrm (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ pqa_, int_4 _p_ ipqa_, 
int_4 _p_ ierror_)
{
  static int_4 l_, mu_, j_, iprod_, k_, i_;
  static real_8 c1_, dmu_, nu_, prod_;
  (*ierror_) = 0;
  l_ = ((*mu2_) - (*mu1_)) + ((*nu2_) - (*nu1_) + 1.5e0);
  mu_ = (*mu1_);
  dmu_ = (*mu1_);
  nu_ = (*nu1_);
  j_ = 1;
  _l500:;
  if (dmu_ <= nu_) {
    goto _l505;
  }
  pqa_[j_ - 1] = 0.0;
  ipqa_[j_ - 1] = 0;
  j_ = j_ + 1;
  if (j_ > l_) {
    goto _l0;
  }
  if ((*mu2_) > (*mu1_)) {
    dmu_ = dmu_ + 1.0e0;
  }
  if ((*nu2_) - (*nu1_) > .5e0) {
    nu_ = nu_ + 1.0e0;
  }
  goto _l500;
  _l505:;
  prod_ = 1.0;
  iprod_ = 0;
  k_ = 2 * mu_;
  if (k_ <= 0) {
    goto _l520;
  }
  for (i_ = 1; i_ <= k_; (i_)++) {
    prod_ = prod_ * sqrt (nu_ + dmu_ + 1.0e0 - i_);
    (void) _dxadj (&prod_, &iprod_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l520:;
  for (i_ = j_; i_ <= l_; (i_)++) {
    c1_ = prod_ * sqrt (nu_ + .5e0);
    pqa_[i_ - 1] = pqa_[i_ - 1] * c1_;
    ipqa_[i_ - 1] = ipqa_[i_ - 1] + iprod_;
    (void) _dxadj (&pqa_[i_ - 1], &ipqa_[i_ - 1], ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    if ((*nu2_) - (*nu1_) > .5e0) {
      goto _l530;
    }
    if (dmu_ >= nu_) {
      goto _l525;
    }
    prod_ = sqrt (nu_ + dmu_ + 1.0e0) * prod_;
    if (nu_ > dmu_) {
      prod_ = prod_ * sqrt (nu_ - dmu_);
    }
    (void) _dxadj (&prod_, &iprod_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    mu_ = mu_ + 1;
    dmu_ = dmu_ + 1.0e0;
    goto _l540;
    _l525:;
    prod_ = 0.0;
    iprod_ = 0;
    mu_ = mu_ + 1;
    dmu_ = dmu_ + 1.0e0;
    goto _l540;
    _l530:;
    prod_ = sqrt (nu_ + dmu_ + 1.0e0) * prod_;
    if (nu_ != dmu_ - 1.0e0) {
      prod_ = prod_ / sqrt (nu_ - dmu_ + 1.0e0);
    }
    (void) _dxadj (&prod_, &iprod_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    nu_ = nu_ + 1.0e0;
    _l540:;
  }
  _l0:;
  __calls[6].calls++;
  return 0;
}

int_4 _dxpqnu (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu_, real_8 _p_ theta_, int_4 _p_ id_, real_8 _p_ pqa_, 
int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 j0_, ipsik_, ipsix_, ipq_, k_, ifvar_, i_, j_, ipq1_, ia_, ix1_, ixs_, ipq2_;
  static real_8 a_, nu_, pq_, r_, w_, x_, x1_, x2_, xs_, y_, z_, di_, dmu_, pq1_, pq2_, factmu_, flok_;
  real_8 $0_, $1_, $2_, $3_;
  extern real_8 _dxpsi ();
  (*ierror_) = 0;
  j0_ = dxblk1_.nbitsf_;
  ipsik_ = 1 + (dxblk1_.nbitsf_ / 10);
  ipsix_ = 5 * ipsik_;
  ipq_ = 0;
  nu_ = fmod ((*nu1_), 1.0);
  if (nu_ >= .5e0) {
    nu_ = nu_ - 1.0e0;
  }
  if ((*id_) != 2 && nu_ > -.5e0) {
    nu_ = nu_ - 1.0e0;
  }
  k_ = (*mu_);
  dmu_ = (*mu_);
  if ((*mu_) <= 0) {
    goto _l60;
  }
  factmu_ = 1.0;
  ifvar_ = 0;
  for (i_ = 1; i_ <= k_; (i_)++) {
    factmu_ = factmu_ * i_;
    (void) _dxadj (&factmu_, &ifvar_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l60:;
  if (k_ == 0) {
    factmu_ = 1.0;
  }
  if (k_ == 0) {
    ifvar_ = 0;
  }
  x_ = cos ((*theta_));
  y_ = ($0_ = sin ((*theta_) / 2.0e0), $0_ * $0_);
  r_ = tan ((*theta_) / 2.0e0);
  pq2_ = 0.0;
  for (j_ = 1; j_ <= 2; (j_)++) {
    ipq1_ = 0;
    if ((*id_) == 2) {
      goto _l80;
    }
    ipq_ = 0;
    pq_ = 1.0;
    a_ = 1.0;
    ia_ = 0;
    for (i_ = 2; i_ <= j0_; (i_)++) {
      di_ = i_;
      a_ = a_ * y_ * (di_ - 2.0e0 - nu_) * (di_ - 1.0e0 + nu_) / ((di_ - 1.0e0 + dmu_) * (di_ - 1.0e0));
      (void) _dxadj (&a_, &ia_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
      if (a_ == 0.0e0) {
        goto _l66;
      }
      (void) _dxadd (&pq_, &ipq_, &a_, &ia_, &pq_, &ipq_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
    }
    _l66:;
    if ((*mu_) <= 0) {
      goto _l90;
    }
    x2_ = r_;
    x1_ = pq_;
    k_ = (*mu_);
    for (i_ = 1; i_ <= k_; (i_)++) {
      x1_ = x1_ * x2_;
      (void) _dxadj (&x1_, &ipq_, ierror_);
    }
    if ((*ierror_) != 0) {
      goto _l0;
    }
    pq_ = x1_ / factmu_;
    ipq_ = ipq_ - ifvar_;
    (void) _dxadj (&pq_, &ipq_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    goto _l90;
    _l80:;
    z_ = -log (r_);
    w_ = _dxpsi (($1_ = nu_ + 1.0e0, &$1_), &ipsik_, &ipsix_);
    xs_ = 1.0e0 / sin ((*theta_));
    pq_ = 0.0;
    ipq_ = 0;
    ia_ = 0;
    a_ = 1.0;
    for (k_ = 1; k_ <= j0_; (k_)++) {
      flok_ = k_;
      if (k_ == 1) {
        goto _l81;
      }
      a_ = a_ * y_ * (flok_ - 2.0e0 - nu_) * (flok_ - 1.0e0 + nu_) / ((flok_ - 1.0e0 + dmu_) * (flok_ - 1.0e0));
      (void) _dxadj (&a_, &ia_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
      _l81:;
      if ((*mu_) >= 1) {
        goto _l83;
      }
      x1_ = (_dxpsi (&flok_, &ipsik_, &ipsix_) - w_ + z_) * a_;
      ix1_ = ia_;
      (void) _dxadd (&pq_, &ipq_, &x1_, &ix1_, &pq_, &ipq_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
      goto _l85;
      _l83:;
      x1_ = (nu_ * (nu_ + 1.0e0) * (z_ - w_ + _dxpsi (&flok_, &ipsik_, &ipsix_)) + (nu_ - flok_ + 1.0e0) * (nu_ + flok_) / 
      (2.0e0 * flok_)) * a_;
      ix1_ = ia_;
      (void) _dxadd (&pq_, &ipq_, &x1_, &ix1_, &pq_, &ipq_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
      _l85:;
    }
    if ((*mu_) >= 1) {
      pq_ = -r_ * pq_;
    }
    ixs_ = 0;
    if ((*mu_) >= 1) {
      (void) _dxadd (&pq_, &ipq_, ($2_ = -xs_, &$2_), &ixs_, &pq_, &ipq_, ierror_);
    }
    if ((*ierror_) != 0) {
      goto _l0;
    }
    if (j_ == 2) {
      (*mu_) = -(*mu_);
    }
    if (j_ == 2) {
      dmu_ = -dmu_;
    }
    _l90:;
    if (j_ == 1) {
      pq2_ = pq_;
    }
    if (j_ == 1) {
      ipq2_ = ipq_;
    }
    nu_ = nu_ + 1.0e0;
  }
  k_ = 0;
  if (nu_ - 1.5e0 < (*nu1_)) {
    goto _l120;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq2_;
  ipqa_[k_ - 1] = ipq2_;
  if (nu_ > (*nu2_) + .5e0) {
    goto _l0;
  }
  _l120:;
  pq1_ = pq_;
  ipq1_ = ipq_;
  if (nu_ < (*nu1_) + .5e0) {
    goto _l130;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq_;
  ipqa_[k_ - 1] = ipq_;
  if (nu_ > (*nu2_) + .5e0) {
    goto _l0;
  }
  _l130:;
  x1_ = (2.0e0 * nu_ - 1.0e0) / (nu_ + dmu_) * x_ * pq1_;
  x2_ = (nu_ - 1.0e0 - dmu_) / (nu_ + dmu_) * pq2_;
  (void) _dxadd (&x1_, &ipq1_, ($3_ = -x2_, &$3_), &ipq2_, &pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _dxadj (&pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  nu_ = nu_ + 1.0e0;
  pq2_ = pq1_;
  ipq2_ = ipq1_;
  goto _l120;
  _l0:;
  __calls[7].calls++;
  return 0;
}

int_4 _dxqmu (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_8 _p_ theta_, real_8 _p_ x_, 
real_8 _p_ sx_, int_4 _p_ id_, real_8 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 mu_, ipq2_, k_, ipq1_, ipq_;
  static real_8 dmu_, nu_, pq_, pq1_, pq2_, x1_, x2_;
  real_8 $0_;
  (*ierror_) = 0;
  mu_ = 0;
  (void) _dxpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pq2_ = pqa_[0];
  ipq2_ = ipqa_[0];
  mu_ = 1;
  (void) _dxpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  nu_ = (*nu1_);
  k_ = 0;
  mu_ = 1;
  dmu_ = 1.0;
  pq1_ = pqa_[0];
  ipq1_ = ipqa_[0];
  if ((*mu1_) > 0) {
    goto _l310;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq2_;
  ipqa_[k_ - 1] = ipq2_;
  if ((*mu2_) < 1) {
    goto _l330;
  }
  _l310:;
  if ((*mu1_) > 1) {
    goto _l320;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq1_;
  ipqa_[k_ - 1] = ipq1_;
  if ((*mu2_) <= 1) {
    goto _l330;
  }
  _l320:;
  x1_ = -2.0e0 * dmu_ * (*x_) * (*sx_) * pq1_;
  x2_ = (nu_ + dmu_) * (nu_ - dmu_ + 1.0e0) * pq2_;
  (void) _dxadd (&x1_, &ipq1_, ($0_ = -x2_, &$0_), &ipq2_, &pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _dxadj (&pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pq2_ = pq1_;
  ipq2_ = ipq1_;
  pq1_ = pq_;
  ipq1_ = ipq_;
  mu_ = mu_ + 1;
  dmu_ = dmu_ + 1.0e0;
  if (mu_ < (*mu1_)) {
    goto _l320;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq_;
  ipqa_[k_ - 1] = ipq_;
  if ((*mu2_) > mu_) {
    goto _l320;
  }
  _l330:;
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _dxqnu (real_8 _p_ nu1_, real_8 _p_ nu2_, int_4 _p_ mu1_, real_8 _p_ theta_, real_8 _p_ x_, real_8 _p_ sx_, int_4 
_p_ id_, real_8 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 k_, ipq2_, ipql2_, mu_, ipq1_, ipql1_, ipq_;
  static real_8 dmu_, nu_, pq_, pq1_, pq2_, x1_, x2_, pql1_, pql2_;
  real_8 $0_;
  (*ierror_) = 0;
  k_ = 0;
  pq2_ = 0.0;
  ipq2_ = 0;
  pql2_ = 0.0;
  ipql2_ = 0;
  if ((*mu1_) == 1) {
    goto _l290;
  }
  mu_ = 0;
  (void) _dxpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*mu1_) == 0) {
    goto _l0;
  }
  k_ = ((*nu2_) - (*nu1_) + 1.5e0);
  pq2_ = pqa_[k_ - 1];
  ipq2_ = ipqa_[k_ - 1];
  pql2_ = pqa_[k_ - 1 - 1];
  ipql2_ = ipqa_[k_ - 1 - 1];
  _l290:;
  mu_ = 1;
  (void) _dxpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*mu1_) == 1) {
    goto _l0;
  }
  nu_ = (*nu2_);
  pq1_ = pqa_[k_ - 1];
  ipq1_ = ipqa_[k_ - 1];
  pql1_ = pqa_[k_ - 1 - 1];
  ipql1_ = ipqa_[k_ - 1 - 1];
  _l300:;
  mu_ = 1;
  dmu_ = 1.0;
  _l320:;
  x1_ = -2.0e0 * dmu_ * (*x_) * (*sx_) * pq1_;
  x2_ = (nu_ + dmu_) * (nu_ - dmu_ + 1.0e0) * pq2_;
  (void) _dxadd (&x1_, &ipq1_, ($0_ = -x2_, &$0_), &ipq2_, &pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _dxadj (&pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pq2_ = pq1_;
  ipq2_ = ipq1_;
  pq1_ = pq_;
  ipq1_ = ipq_;
  mu_ = mu_ + 1;
  dmu_ = dmu_ + 1.0e0;
  if (mu_ < (*mu1_)) {
    goto _l320;
  }
  pqa_[k_ - 1] = pq_;
  ipqa_[k_ - 1] = ipq_;
  if (k_ == 1) {
    goto _l0;
  }
  if (nu_ < (*nu2_)) {
    goto _l340;
  }
  nu_ = nu_ - 1.0e0;
  pq2_ = pql2_;
  ipq2_ = ipql2_;
  pq1_ = pql1_;
  ipq1_ = ipql1_;
  k_ = k_ - 1;
  goto _l300;
  _l340:;
  pq1_ = pqa_[k_ - 1];
  ipq1_ = ipqa_[k_ - 1];
  pq2_ = pqa_[k_ + 1 - 1];
  ipq2_ = ipqa_[k_ + 1 - 1];
  _l350:;
  if (nu_ <= (*nu1_)) {
    goto _l0;
  }
  k_ = k_ - 1;
  x1_ = (2.0e0 * nu_ + 1.0e0) * (*x_) * pq1_ / (nu_ + dmu_);
  x2_ = -(nu_ - dmu_ + 1.0e0) * pq2_ / (nu_ + dmu_);
  (void) _dxadd (&x1_, &ipq1_, &x2_, &ipq2_, &pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _dxadj (&pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pq2_ = pq1_;
  ipq2_ = ipq1_;
  pq1_ = pq_;
  ipq1_ = ipq_;
  pqa_[k_ - 1] = pq_;
  ipqa_[k_ - 1] = ipq_;
  nu_ = nu_ - 1.0e0;
  goto _l350;
  _l0:;
  __calls[9].calls++;
  return 0;
}

int_4 _dxset (int_4 _p_ irad_, int_4 _p_ nradpl_, real_8 _p_ dzero_, int_4 _p_ nbits_, int_4 _p_ ierror_)
{
  static int_4 iflag_, log102_[20], lgtemp_[20], iradx_, nrdplc_, iminex_, imaxex_, nbitsx_, log2r_, lx_, nb_, np1_, ic_, 
  ii_, i_, it_, lg102x_, j_, kk_, k_;
  static real_8 dzerox_;
  int_4 _data_k_1, _p_ _arr_0, _k_1, _data_k_2, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_;
  extern int_4 _i1mach ();
#define _data_n_1 20
  static int_4 _data_l_1[_data_n_1] = {
    301,
    29,
    995,
    663,
    981,
    195,
    213,
    738,
    894,
    724,
    493,
    26,
    768,
    189,
    881,
    462,
    108,
    541,
    310,
    428
  };
#define _data_n_2 1
  static int_4 _data_l_2[_data_n_2] = {
    0
  };
  if (__calls[10].calls == 0) {
    _data_k_1 = 0;
    for (_arr_0 = (int_4 *) log102_, _k_1 = 0; _k_1 < 20; _arr_0++, _k_1++) {
      if (_data_k_1 >= _data_n_1) {
        _data_k_1 = 0;
      }
      log102_[_k_1] = _data_l_1[_data_k_1++];
    }
  }
  if (__calls[10].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    iflag_ = _data_l_2[_data_k_2++];
  }
  (*ierror_) = 0;
  if (iflag_ != 0) {
    goto _l0;
  }
  iradx_ = (*irad_);
  nrdplc_ = (*nradpl_);
  dzerox_ = (*dzero_);
  iminex_ = 0;
  imaxex_ = 0;
  nbitsx_ = (*nbits_);
  if (iradx_ == 0) {
    iradx_ = _i1mach (($2_ = 10, &$2_));
  }
  if (nrdplc_ == 0) {
    nrdplc_ = _i1mach (($3_ = 14, &$3_));
  }
  if (dzerox_ == 0.0e0) {
    iminex_ = _i1mach (($4_ = 15, &$4_));
  }
  if (dzerox_ == 0.0e0) {
    imaxex_ = _i1mach (($5_ = 16, &$5_));
  }
  if (nbitsx_ == 0) {
    nbitsx_ = _i1mach (($6_ = 8, &$6_));
  }
  if (iradx_ == 2) {
    goto _l10;
  }
  if (iradx_ == 4) {
    goto _l10;
  }
  if (iradx_ == 8) {
    goto _l10;
  }
  if (iradx_ == 16) {
    goto _l10;
  }
  (void) _xermsg (_dc_4, _dc_8, _dc_9, ($7_ = 201, &$7_), &_k1);
  (*ierror_) = 201;
  goto _l0;
  _l10:;
  log2r_ = 0;
  if (iradx_ == 2) {
    log2r_ = 1;
  }
  if (iradx_ == 4) {
    log2r_ = 2;
  }
  if (iradx_ == 8) {
    log2r_ = 3;
  }
  if (iradx_ == 16) {
    log2r_ = 4;
  }
  dxblk1_.nbitsf_ = log2r_ * nrdplc_;
  dxblk2_.radix_ = iradx_;
  dxblk2_.dlg10r_ = log10 (dxblk2_.radix_);
  if (dzerox_ != 0.0e0) {
    goto _l14;
  }
  lx_ = _min ((1 - iminex_) / 2, (imaxex_ - 1) / 2);
  goto _l16;
  _l14:;
  lx_ = 0.5e0 * log10 (dzerox_) / dxblk2_.dlg10r_;
  lx_ = lx_ - 1;
  _l16:;
  dxblk2_.l2_ = 2 * lx_;
  if (lx_ >= 4) {
    goto _l20;
  }
  (void) _xermsg (_dc_4, _dc_8, _dc_10, ($8_ = 202, &$8_), &_k1);
  (*ierror_) = 202;
  goto _l0;
  _l20:;
  dxblk2_.l_ = lx_;
  dxblk2_.radixl_ = _up_real_8 (dxblk2_.radix_, dxblk2_.l_);
  dxblk2_.rad2l_ = (dxblk2_.radixl_ * dxblk2_.radixl_);
  if (15 <= nbitsx_ && nbitsx_ <= 63) {
    goto _l30;
  }
  (void) _xermsg (_dc_4, _dc_8, _dc_11, ($9_ = 203, &$9_), &_k1);
  (*ierror_) = 203;
  goto _l0;
  _l30:;
  dxblk2_.kmax_ = _up_int_4 (2, (nbitsx_ - 1)) - dxblk2_.l2_;
  nb_ = (nbitsx_ - 1) / 2;
  dxblk3_.mlg102_ = _up_int_4 (2, nb_);
  if (1 <= nrdplc_ * log2r_ && nrdplc_ * log2r_ <= 120) {
    goto _l40;
  }
  (void) _xermsg (_dc_4, _dc_8, _dc_12, ($10_ = 204, &$10_), &_k1);
  (*ierror_) = 204;
  goto _l0;
  _l40:;
  dxblk3_.nlg102_ = nrdplc_ * log2r_ / nb_ + 3;
  np1_ = dxblk3_.nlg102_ + 1;
  ic_ = 0;
  for (ii_ = 1; ii_ <= 20; (ii_)++) {
    i_ = 21 - ii_;
    it_ = log2r_ * log102_[i_ - 1] + ic_;
    ic_ = it_ / 1000;
    lgtemp_[i_ - 1] = _imod (it_, 1000);
  }
  dxblk3_.lg102_[0] = ic_;
  for (i_ = 2; i_ <= np1_; (i_)++) {
    lg102x_ = 0;
    for (j_ = 1; j_ <= nb_; (j_)++) {
      ic_ = 0;
      for (kk_ = 1; kk_ <= 20; (kk_)++) {
        k_ = 21 - kk_;
        it_ = 2 * lgtemp_[k_ - 1] + ic_;
        ic_ = it_ / 1000;
        lgtemp_[k_ - 1] = _imod (it_, 1000);
      }
      lg102x_ = 2 * lg102x_ + ic_;
    }
    dxblk3_.lg102_[i_ - 1] = lg102x_;
  }
  if (nrdplc_ < dxblk2_.l_) {
    goto _l90;
  }
  (void) _xermsg (_dc_4, _dc_8, _dc_13, ($11_ = 205, &$11_), &_k1);
  (*ierror_) = 205;
  goto _l0;
  _l90:;
  if (6 * dxblk2_.l_ <= dxblk2_.kmax_) {
    goto _l100;
  }
  (void) _xermsg (_dc_4, _dc_8, _dc_14, ($12_ = 206, &$12_), &_k1);
  (*ierror_) = 206;
  goto _l0;
  _l100:;
  iflag_ = 1;
  _l0:;
  __calls[10].calls++;
  return 0;
}

int_4 _xadd (real_4 _p_ x_, int_4 _p_ ix_, real_4 _p_ y_, int_4 _p_ iy_, real_4 _p_ z_, int_4 _p_ iz_, int_4 _p_ 
ierror_)
{
  static int_4 i_, is_, i1_, i2_, j_;
  static real_4 s_, t_;
  int_4 $0_;
  (*ierror_) = 0;
  if ((*x_) != 0.0) {
    goto _l10;
  }
  (*z_) = (*y_);
  (*iz_) = (*iy_);
  goto _l220;
  _l10:;
  if ((*y_) != 0.0) {
    goto _l20;
  }
  (*z_) = (*x_);
  (*iz_) = (*ix_);
  goto _l220;
  _l20:;
  if ((*ix_) >= 0 && (*iy_) >= 0) {
    goto _l40;
  }
  if ((*ix_) < 0 && (*iy_) < 0) {
    goto _l40;
  }
  if (_abs ((*ix_)) <= 6 * xblk2_.l_ && _abs ((*iy_)) <= 6 * xblk2_.l_) {
    goto _l40;
  }
  if ((*ix_) >= 0) {
    goto _l30;
  }
  (*z_) = (*y_);
  (*iz_) = (*iy_);
  goto _l220;
  _l30:;
  (*z_) = (*x_);
  (*iz_) = (*ix_);
  goto _l220;
  _l40:;
  i_ = (*ix_) - (*iy_);
  $0_ = i_;
  if ($0_ < 0) {
    goto _l80;
  } else if ($0_ == 0) {
    goto _l50;
  } else {
    goto _l90;
  }
  _l50:;
  if (_abs ((*x_)) > 1.0 && _abs ((*y_)) > 1.0) {
    goto _l60;
  }
  if (_abs ((*x_)) < 1.0 && _abs ((*y_)) < 1.0) {
    goto _l70;
  }
  (*z_) = (*x_) + (*y_);
  (*iz_) = (*ix_);
  goto _l220;
  _l60:;
  s_ = (*x_) / xblk2_.radixl_;
  t_ = (*y_) / xblk2_.radixl_;
  (*z_) = s_ + t_;
  (*iz_) = (*ix_) + xblk2_.l_;
  goto _l220;
  _l70:;
  s_ = (*x_) * xblk2_.radixl_;
  t_ = (*y_) * xblk2_.radixl_;
  (*z_) = s_ + t_;
  (*iz_) = (*ix_) - xblk2_.l_;
  goto _l220;
  _l80:;
  s_ = (*y_);
  is_ = (*iy_);
  t_ = (*x_);
  goto _l100;
  _l90:;
  s_ = (*x_);
  is_ = (*ix_);
  t_ = (*y_);
  _l100:;
  i1_ = _abs (i_) / xblk2_.l_;
  i2_ = _imod (_abs (i_), xblk2_.l_);
  if (_abs (t_) >= xblk2_.radixl_) {
    goto _l130;
  }
  if (_abs (t_) >= 1.0) {
    goto _l120;
  }
  if (xblk2_.radixl_ * _abs (t_) >= 1.0) {
    goto _l110;
  }
  j_ = i1_ + 1;
  t_ = t_ * _up_real_4 (xblk2_.radix_, (xblk2_.l_ - i2_));
  goto _l140;
  _l110:;
  j_ = i1_;
  t_ = t_ * _up_real_4 (xblk2_.radix_, (-i2_));
  goto _l140;
  _l120:;
  j_ = i1_ - 1;
  if (j_ < 0) {
    goto _l110;
  }
  t_ = t_ * _up_real_4 (xblk2_.radix_, (-i2_)) / xblk2_.radixl_;
  goto _l140;
  _l130:;
  j_ = i1_ - 2;
  if (j_ < 0) {
    goto _l120;
  }
  t_ = t_ * _up_real_4 (xblk2_.radix_, (-i2_)) / xblk2_.rad2l_;
  _l140:;
  if (j_ == 0) {
    goto _l190;
  }
  if (_abs (s_) >= xblk2_.radixl_ || j_ > 3) {
    goto _l150;
  }
  if (_abs (s_) >= 1.0) {
    switch (j_) {
      default:
      case 1: goto _l180;
      case 2: goto _l150;
      case 3: goto _l150;
    }
  }
  if (xblk2_.radixl_ * _abs (s_) >= 1.0) {
    switch (j_) {
      default:
      case 1: goto _l180;
      case 2: goto _l170;
      case 3: goto _l150;
    }
  }
  switch (j_) {
    default:
    case 1: goto _l180;
    case 2: goto _l170;
    case 3: goto _l160;
  }
  _l150:;
  (*z_) = s_;
  (*iz_) = is_;
  goto _l220;
  _l160:;
  s_ = s_ * xblk2_.radixl_;
  _l170:;
  s_ = s_ * xblk2_.radixl_;
  _l180:;
  s_ = s_ * xblk2_.radixl_;
  _l190:;
  if (_abs (s_) > 1.0 && _abs (t_) > 1.0) {
    goto _l200;
  }
  if (_abs (s_) < 1.0 && _abs (t_) < 1.0) {
    goto _l210;
  }
  (*z_) = s_ + t_;
  (*iz_) = is_ - j_ * xblk2_.l_;
  goto _l220;
  _l200:;
  s_ = s_ / xblk2_.radixl_;
  t_ = t_ / xblk2_.radixl_;
  (*z_) = s_ + t_;
  (*iz_) = is_ - j_ * xblk2_.l_ + xblk2_.l_;
  goto _l220;
  _l210:;
  s_ = s_ * xblk2_.radixl_;
  t_ = t_ * xblk2_.radixl_;
  (*z_) = s_ + t_;
  (*iz_) = is_ - j_ * xblk2_.l_ - xblk2_.l_;
  _l220:;
  (void) _xadj (z_, iz_, ierror_);
  __calls[11].calls++;
  return 0;
}

int_4 _xcon (real_4 _p_ x_, int_4 _p_ ix_, int_4 _p_ ierror_)
{
  static int_4 ispace_, itemp_, icase_, i_, j_, i1_, j1_, j2_;
  static real_4 a_, b_, z_;
  int_4 _data_k_3;
#define _data_n_3 1
  static int_4 _data_l_3[_data_n_3] = {
    1
  };
  if (__calls[12].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    ispace_ = _data_l_3[_data_k_3++];
  }
  (*ierror_) = 0;
  (void) _xred (x_, ix_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*ix_) == 0) {
    goto _l150;
  }
  (void) _xadj (x_, ix_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  itemp_ = 1;
  icase_ = (3 + _sign (itemp_, (*ix_))) / 2;
  switch (icase_) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  if (_abs ((*x_)) < 1.0) {
    goto _l30;
  }
  (*x_) = (*x_) / xblk2_.radixl_;
  (*ix_) = (*ix_) + xblk2_.l_;
  goto _l30;
  _l20:;
  if (_abs ((*x_)) >= 1.0) {
    goto _l30;
  }
  (*x_) = (*x_) * xblk2_.radixl_;
  (*ix_) = (*ix_) - xblk2_.l_;
  _l30:;
  i_ = log10f (_abs ((*x_))) / xblk2_.dlg10r_;
  a_ = _up_real_4 (xblk2_.radix_, i_);
  switch (icase_) {
    default:
    case 1: goto _l40;
    case 2: goto _l60;
  }
  _l40:;
  if (a_ <= xblk2_.radix_ * _abs ((*x_))) {
    goto _l50;
  }
  i_ = i_ - 1;
  a_ = a_ / xblk2_.radix_;
  goto _l40;
  _l50:;
  if (_abs ((*x_)) < a_) {
    goto _l80;
  }
  i_ = i_ + 1;
  a_ = a_ * xblk2_.radix_;
  goto _l50;
  _l60:;
  if (a_ <= _abs ((*x_))) {
    goto _l70;
  }
  i_ = i_ - 1;
  a_ = a_ / xblk2_.radix_;
  goto _l60;
  _l70:;
  if (_abs ((*x_)) < xblk2_.radix_ * a_) {
    goto _l80;
  }
  i_ = i_ + 1;
  a_ = a_ * xblk2_.radix_;
  goto _l70;
  _l80:;
  itemp_ = ispace_ / xblk2_.dlg10r_;
  a_ = _up_real_4 (xblk2_.radix_, itemp_);
  b_ = _up_real_4 (10.0, ispace_);
  _l90:;
  if (a_ <= b_) {
    goto _l100;
  }
  itemp_ = itemp_ - 1;
  a_ = a_ / xblk2_.radix_;
  goto _l90;
  _l100:;
  if (b_ < a_ * xblk2_.radix_) {
    goto _l110;
  }
  itemp_ = itemp_ + 1;
  a_ = a_ * xblk2_.radix_;
  goto _l100;
  _l110:;
  if (itemp_ > 0) {
    goto _l120;
  }
  (*x_) = (*x_) * _up_real_4 (xblk2_.radix_, (-i_));
  (*ix_) = (*ix_) + i_;
  (void) _xc210 (ix_, &z_, &j_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (*x_) = (*x_) * z_;
  (*ix_) = j_;
  switch (icase_) {
    default:
    case 1: goto _l130;
    case 2: goto _l140;
  }
  _l120:;
  i1_ = i_ / itemp_;
  (*x_) = (*x_) * _up_real_4 (xblk2_.radix_, (-i1_ * itemp_));
  (*ix_) = (*ix_) + i1_ * itemp_;
  (void) _xc210 (ix_, &z_, &j_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  j1_ = j_ / ispace_;
  j2_ = j_ - j1_ * ispace_;
  (*x_) = (*x_) * z_ * _up_real_4 (10.0, j2_);
  (*ix_) = j1_ * ispace_;
  switch (icase_) {
    default:
    case 1: goto _l130;
    case 2: goto _l140;
  }
  _l130:;
  if (b_ * _abs ((*x_)) >= 1.0) {
    goto _l150;
  }
  (*x_) = (*x_) * b_;
  (*ix_) = (*ix_) - ispace_;
  goto _l130;
  _l140:;
  if (10.0 * _abs ((*x_)) < b_) {
    goto _l150;
  }
  (*x_) = (*x_) / b_;
  (*ix_) = (*ix_) + ispace_;
  goto _l140;
  _l150:;
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _xlegf (real_4 _p_ dnu1_, int_4 _p_ nudiff_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ theta_, int_4 _p_ id_, 
real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 l_, i_;
  static real_4 dnu2_, sx_, x_, pi2_;
  int_4 $1_, $2_;
  real_4 $0_;
  (*ierror_) = 0;
  (void) _xset (&_k0, &_k0, ($0_ = 0.0, &$0_), &_k0, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pi2_ = 1.5707963;
  l_ = ((*mu2_) - (*mu1_)) + (*nudiff_) + 1;
  for (i_ = 1; i_ <= l_; (i_)++) {
    pqa_[i_ - 1] = 0.0;
    ipqa_[i_ - 1] = 0;
  }
  if ((*nudiff_) < 0) {
    goto _l400;
  }
  if ((*dnu1_) < -.5) {
    goto _l400;
  }
  if ((*mu2_) < (*mu1_)) {
    goto _l400;
  }
  if ((*mu1_) < 0) {
    goto _l400;
  }
  if ((*theta_) <= 0 || (*theta_) > pi2_) {
    goto _l420;
  }
  if ((*id_) < 1 || (*id_) > 4) {
    goto _l400;
  }
  if (((*mu1_) != (*mu2_)) && ((*nudiff_) > 0)) {
    goto _l400;
  }
  dnu2_ = (*dnu1_) + (*nudiff_);
  if (((*id_) == 3) && (fmodf ((*dnu1_), 1.0) != 0.0)) {
    goto _l295;
  }
  if (((*id_) == 4) && (fmodf ((*dnu1_), 1.0) != 0.0)) {
    goto _l400;
  }
  if (((*id_) == 3 || (*id_) == 4) && (*mu1_) > dnu2_) {
    goto _l0;
  }
  _l295:;
  x_ = cosf ((*theta_));
  sx_ = 1.0 / sinf ((*theta_));
  if ((*id_) == 2) {
    goto _l300;
  }
  if ((*mu2_) - (*mu1_) <= 0) {
    goto _l360;
  }
  (void) _xpmu (dnu1_, &dnu2_, mu1_, mu2_, theta_, &x_, &sx_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  goto _l380;
  _l300:;
  if ((*mu2_) == (*mu1_)) {
    goto _l320;
  }
  (void) _xqmu (dnu1_, &dnu2_, mu1_, mu2_, theta_, &x_, &sx_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  goto _l390;
  _l320:;
  (void) _xqnu (dnu1_, &dnu2_, mu1_, theta_, &x_, &sx_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  goto _l390;
  _l360:;
  (void) _xpqnu (dnu1_, &dnu2_, mu1_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l380:;
  if ((*id_) == 3) {
    (void) _xpmup (dnu1_, &dnu2_, mu1_, mu2_, pqa_, ipqa_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*id_) == 4) {
    (void) _xpnrm (dnu1_, &dnu2_, mu1_, mu2_, pqa_, ipqa_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l390:;
  for (i_ = 1; i_ <= l_; (i_)++) {
    (void) _xred (&pqa_[i_ - 1], &ipqa_[i_ - 1], ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
  }
  goto _l0;
  _l400:;
  (void) _xermsg (_dc_0, _dc_15, _dc_2, ($1_ = 110, &$1_), &_k1);
  (*ierror_) = 110;
  goto _l0;
  _l420:;
  (void) _xermsg (_dc_0, _dc_15, _dc_3, ($2_ = 111, &$2_), &_k1);
  (*ierror_) = 111;
  _l0:;
  __calls[13].calls++;
  return 0;
}

int_4 _xnrmp (int_4 _p_ nu_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ sarg_, int_4 _p_ mode_, real_4 _p_ spn_, int_4 
_p_ ipn_, int_4 _p_ isig_, int_4 _p_ ierror_)
{
  static int_4 mu_, i_, ip1_, ip2_, j_, ip_, k_;
  static real_4 c1_, c2_, p_, p1_, p2_, p3_, s_, sx_, t_, tx_, x_, rk_;
  int_4 $1_, $2_;
  real_4 $0_;
  (*ierror_) = 0;
  (void) _xset (&_k0, &_k0, ($0_ = 0.0, &$0_), &_k0, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*nu_) < 0) {
    goto _l110;
  }
  if ((*mu1_) < 0) {
    goto _l110;
  }
  if ((*mu1_) > (*mu2_)) {
    goto _l110;
  }
  if ((*nu_) == 0) {
    goto _l90;
  }
  if ((*mode_) < 1 || (*mode_) > 2) {
    goto _l110;
  }
  switch ((*mode_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  if (_abs ((*sarg_)) > 1.0) {
    goto _l120;
  }
  if (_abs ((*sarg_)) == 1.0) {
    goto _l90;
  }
  x_ = (*sarg_);
  sx_ = sqrtf ((1.0 + _abs (x_)) * ((0.5 - _abs (x_)) + 0.5));
  tx_ = x_ / sx_;
  (*isig_) = log10f (2.0 * (*nu_) * (5.0 + (tx_ * tx_)));
  goto _l30;
  _l20:;
  if (_abs ((*sarg_)) > 4.0 * 0.7853981633974483096156608458198757210492923498437764552437361480769541) {
    goto _l120;
  }
  if ((*sarg_) == 0.0) {
    goto _l90;
  }
  x_ = cosf ((*sarg_));
  sx_ = _abs (sinf ((*sarg_)));
  tx_ = x_ / sx_;
  (*isig_) = log10f (2.0 * (*nu_) * (5.0 + _abs ((*sarg_) * tx_)));
  _l30:;
  mu_ = (*mu2_);
  i_ = (*mu2_) - (*mu1_) + 1;
  _l40:;
  if (mu_ <= (*nu_)) {
    goto _l50;
  }
  spn_[i_ - 1] = 0.0;
  ipn_[i_ - 1] = 0;
  i_ = i_ - 1;
  mu_ = mu_ - 1;
  if (i_ > 0) {
    goto _l40;
  }
  (*isig_) = 0;
  goto _l160;
  _l50:;
  mu_ = (*nu_);
  p1_ = 0.0;
  ip1_ = 0;
  p2_ = 1.0;
  ip2_ = 0;
  p3_ = 0.5;
  rk_ = 2.0;
  for (j_ = 1; j_ <= (*nu_); (j_)++) {
    p3_ = ((rk_ + 1.0) / rk_) * p3_;
    p2_ = p2_ * sx_;
    (void) _xadj (&p2_, &ip2_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    rk_ = rk_ + 2.0;
  }
  p2_ = p2_ * sqrtf (p3_);
  (void) _xadj (&p2_, &ip2_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  s_ = 2.0 * tx_;
  t_ = 1.0 / (*nu_);
  if ((*mu2_) < (*nu_)) {
    goto _l70;
  }
  spn_[i_ - 1] = p2_;
  ipn_[i_ - 1] = ip2_;
  i_ = i_ - 1;
  if (i_ == 0) {
    goto _l140;
  }
  _l70:;
  p_ = mu_ * t_;
  c1_ = 1.0 / sqrtf ((1.0 - p_ + t_) * (1.0 + p_));
  c2_ = s_ * p_ * c1_ * p2_;
  c1_ = -sqrtf ((1.0 + p_ + t_) * (1.0 - p_)) * c1_ * p1_;
  (void) _xadd (&c2_, &ip2_, &c1_, &ip1_, &p_, &ip_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  mu_ = mu_ - 1;
  if (mu_ > (*mu2_)) {
    goto _l80;
  }
  spn_[i_ - 1] = p_;
  ipn_[i_ - 1] = ip_;
  i_ = i_ - 1;
  if (i_ == 0) {
    goto _l140;
  }
  _l80:;
  p1_ = p2_;
  ip1_ = ip2_;
  p2_ = p_;
  ip2_ = ip_;
  if (mu_ <= (*mu1_)) {
    goto _l140;
  }
  goto _l70;
  _l90:;
  k_ = (*mu2_) - (*mu1_) + 1;
  for (i_ = 1; i_ <= k_; (i_)++) {
    spn_[i_ - 1] = 0.0;
    ipn_[i_ - 1] = 0;
  }
  (*isig_) = 0;
  if ((*mu1_) > 0) {
    goto _l160;
  }
  (*isig_) = 1;
  spn_[0] = sqrtf ((*nu_) + 0.5);
  ipn_[0] = 0;
  if (_imod ((*nu_), 2) == 0) {
    goto _l160;
  }
  if ((*mode_) == 1 && (*sarg_) == 1.0) {
    goto _l160;
  }
  if ((*mode_) == 2) {
    goto _l160;
  }
  spn_[0] = -spn_[0];
  goto _l160;
  _l110:;
  (void) _xermsg (_dc_4, _dc_16, _dc_6, ($1_ = 112, &$1_), &_k1);
  (*ierror_) = 112;
  goto _l0;
  _l120:;
  (void) _xermsg (_dc_4, _dc_16, _dc_17, ($2_ = 113, &$2_), &_k1);
  (*ierror_) = 113;
  goto _l0;
  _l140:;
  k_ = (*mu2_) - (*mu1_) + 1;
  for (i_ = 1; i_ <= k_; (i_)++) {
    (void) _xred (&spn_[i_ - 1], &ipn_[i_ - 1], ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
  }
  _l160:;
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _xpmu (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ theta_, real_4 _p_ x_, real_4 
_p_ sx_, int_4 _p_ id_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 ip0_, mu_, n_, j_;
  static real_4 p0_, x1_, x2_;
  (*ierror_) = 0;
  (void) _xpqnu (nu1_, nu2_, mu2_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  p0_ = pqa_[0];
  ip0_ = ipqa_[0];
  mu_ = (*mu2_) - 1;
  (void) _xpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  n_ = (*mu2_) - (*mu1_) + 1;
  pqa_[n_ - 1] = p0_;
  ipqa_[n_ - 1] = ip0_;
  if (n_ == 1) {
    goto _l300;
  }
  pqa_[n_ - 1 - 1] = pqa_[0];
  ipqa_[n_ - 1 - 1] = ipqa_[0];
  if (n_ == 2) {
    goto _l300;
  }
  j_ = n_ - 2;
  _l290:;
  x1_ = 2.0 * mu_ * (*x_) * (*sx_) * pqa_[j_ + 1 - 1];
  x2_ = -((*nu1_) - mu_) * ((*nu1_) + mu_ + 1.0) * pqa_[j_ + 2 - 1];
  (void) _xadd (&x1_, &ipqa_[j_ + 1 - 1], &x2_, &ipqa_[j_ + 2 - 1], &pqa_[j_ - 1], &ipqa_[j_ - 1], ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _xadj (&pqa_[j_ - 1], &ipqa_[j_ - 1], ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if (j_ == 1) {
    goto _l300;
  }
  j_ = j_ - 1;
  mu_ = mu_ - 1;
  goto _l290;
  _l300:;
  _l0:;
  __calls[15].calls++;
  return 0;
}

int_4 _xpmup (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 
_p_ ierror_)
{
  static int_4 mu_, n_, j_, iprod_, k_, l_, i_;
  static real_4 dmu_, nu_, prod_;
  (*ierror_) = 0;
  nu_ = (*nu1_);
  mu_ = (*mu1_);
  dmu_ = mu_;
  n_ = (int_4) (_aintd ((*nu2_) - (*nu1_) + .1)) + ((*mu2_) - (*mu1_)) + 1;
  j_ = 1;
  if (fmodf (nu_, 1.0) != 0.0) {
    goto _l210;
  }
  _l200:;
  if (dmu_ < nu_ + 1.0) {
    goto _l210;
  }
  pqa_[j_ - 1] = 0.0;
  ipqa_[j_ - 1] = 0;
  j_ = j_ + 1;
  if (j_ > n_) {
    goto _l0;
  }
  if ((*nu2_) - (*nu1_) > .5) {
    nu_ = nu_ + 1.0;
  }
  if ((*mu2_) > (*mu1_)) {
    mu_ = mu_ + 1;
  }
  goto _l200;
  _l210:;
  prod_ = 1.0;
  iprod_ = 0;
  k_ = 2 * mu_;
  if (k_ == 0) {
    goto _l222;
  }
  for (l_ = 1; l_ <= k_; (l_)++) {
    prod_ = prod_ * (dmu_ - nu_ - l_);
    (void) _xadj (&prod_, &iprod_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l222:;
  for (i_ = j_; i_ <= n_; (i_)++) {
    if (mu_ == 0) {
      goto _l225;
    }
    pqa_[i_ - 1] = pqa_[i_ - 1] * prod_ * _up_int_4 (-1, mu_);
    ipqa_[i_ - 1] = ipqa_[i_ - 1] + iprod_;
    (void) _xadj (&pqa_[i_ - 1], &ipqa_[i_ - 1], ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    _l225:;
    if ((*nu2_) - (*nu1_) > .5) {
      goto _l230;
    }
    prod_ = (dmu_ - nu_) * prod_ * (-dmu_ - nu_ - 1.0);
    (void) _xadj (&prod_, &iprod_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    mu_ = mu_ + 1;
    dmu_ = dmu_ + 1.0;
    goto _l240;
    _l230:;
    prod_ = prod_ * (-dmu_ - nu_ - 1.0) / (dmu_ - nu_ - 1.0);
    (void) _xadj (&prod_, &iprod_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    nu_ = nu_ + 1.0;
    _l240:;
  }
  _l0:;
  __calls[16].calls++;
  return 0;
}

int_4 _xpnrm (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 
_p_ ierror_)
{
  static int_4 l_, mu_, j_, iprod_, k_, i_;
  static real_4 c1_, dmu_, nu_, prod_;
  (*ierror_) = 0;
  l_ = ((*mu2_) - (*mu1_)) + ((*nu2_) - (*nu1_) + 1.5);
  mu_ = (*mu1_);
  dmu_ = (*mu1_);
  nu_ = (*nu1_);
  j_ = 1;
  _l500:;
  if (dmu_ <= nu_) {
    goto _l505;
  }
  pqa_[j_ - 1] = 0.0;
  ipqa_[j_ - 1] = 0;
  j_ = j_ + 1;
  if (j_ > l_) {
    goto _l0;
  }
  if ((*mu2_) > (*mu1_)) {
    dmu_ = dmu_ + 1.0;
  }
  if ((*nu2_) - (*nu1_) > .5) {
    nu_ = nu_ + 1.0;
  }
  goto _l500;
  _l505:;
  prod_ = 1.0;
  iprod_ = 0;
  k_ = 2 * mu_;
  if (k_ <= 0) {
    goto _l520;
  }
  for (i_ = 1; i_ <= k_; (i_)++) {
    prod_ = prod_ * sqrtf (nu_ + dmu_ + 1.0 - i_);
    (void) _xadj (&prod_, &iprod_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l520:;
  for (i_ = j_; i_ <= l_; (i_)++) {
    c1_ = prod_ * sqrtf (nu_ + .5);
    pqa_[i_ - 1] = pqa_[i_ - 1] * c1_;
    ipqa_[i_ - 1] = ipqa_[i_ - 1] + iprod_;
    (void) _xadj (&pqa_[i_ - 1], &ipqa_[i_ - 1], ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    if ((*nu2_) - (*nu1_) > .5) {
      goto _l530;
    }
    if (dmu_ >= nu_) {
      goto _l525;
    }
    prod_ = sqrtf (nu_ + dmu_ + 1.0) * prod_;
    if (nu_ > dmu_) {
      prod_ = prod_ * sqrtf (nu_ - dmu_);
    }
    (void) _xadj (&prod_, &iprod_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    mu_ = mu_ + 1;
    dmu_ = dmu_ + 1.0;
    goto _l540;
    _l525:;
    prod_ = 0.0;
    iprod_ = 0;
    mu_ = mu_ + 1;
    dmu_ = dmu_ + 1.0;
    goto _l540;
    _l530:;
    prod_ = sqrtf (nu_ + dmu_ + 1.0) * prod_;
    if (nu_ != dmu_ - 1.0) {
      prod_ = prod_ / sqrtf (nu_ - dmu_ + 1.0);
    }
    (void) _xadj (&prod_, &iprod_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    nu_ = nu_ + 1.0;
    _l540:;
  }
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _xpqnu (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu_, real_4 _p_ theta_, int_4 _p_ id_, real_4 _p_ pqa_, int_4 
_p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 j0_, ipsik_, ipsix_, ipq_, k_, ifvar_, i_, j_, ipq1_, ia_, ix1_, ixs_, ipq2_;
  static real_4 a_, nu_, pq_, r_, w_, x_, x1_, x2_, xs_, y_, z_, di_, dmu_, pq1_, pq2_, factmu_, flok_;
  real_4 $0_, $1_, $2_, $3_;
  extern real_4 _xpsi ();
  (*ierror_) = 0;
  j0_ = xblk1_.nbitsf_;
  ipsik_ = 1 + (xblk1_.nbitsf_ / 10);
  ipsix_ = 5 * ipsik_;
  ipq_ = 0;
  nu_ = fmodf ((*nu1_), 1.0);
  if (nu_ >= .5) {
    nu_ = nu_ - 1.0;
  }
  if ((*id_) != 2 && nu_ > -.5) {
    nu_ = nu_ - 1.0;
  }
  k_ = (*mu_);
  dmu_ = (*mu_);
  if ((*mu_) <= 0) {
    goto _l60;
  }
  factmu_ = 1.0;
  ifvar_ = 0;
  for (i_ = 1; i_ <= k_; (i_)++) {
    factmu_ = factmu_ * i_;
    (void) _xadj (&factmu_, &ifvar_, ierror_);
  }
  if ((*ierror_) != 0) {
    goto _l0;
  }
  _l60:;
  if (k_ == 0) {
    factmu_ = 1.0;
  }
  if (k_ == 0) {
    ifvar_ = 0;
  }
  x_ = cosf ((*theta_));
  y_ = ($0_ = sinf ((*theta_) / 2.0), $0_ * $0_);
  r_ = tanf ((*theta_) / 2.0);
  pq2_ = 0.0;
  for (j_ = 1; j_ <= 2; (j_)++) {
    ipq1_ = 0;
    if ((*id_) == 2) {
      goto _l80;
    }
    ipq_ = 0;
    pq_ = 1.0;
    a_ = 1.0;
    ia_ = 0;
    for (i_ = 2; i_ <= j0_; (i_)++) {
      di_ = i_;
      a_ = a_ * y_ * (di_ - 2.0 - nu_) * (di_ - 1.0 + nu_) / ((di_ - 1.0 + dmu_) * (di_ - 1.0));
      (void) _xadj (&a_, &ia_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
      if (a_ == 0.0) {
        goto _l66;
      }
      (void) _xadd (&pq_, &ipq_, &a_, &ia_, &pq_, &ipq_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
    }
    _l66:;
    if ((*mu_) <= 0) {
      goto _l90;
    }
    x2_ = r_;
    x1_ = pq_;
    k_ = (*mu_);
    for (i_ = 1; i_ <= k_; (i_)++) {
      x1_ = x1_ * x2_;
      (void) _xadj (&x1_, &ipq_, ierror_);
    }
    if ((*ierror_) != 0) {
      goto _l0;
    }
    pq_ = x1_ / factmu_;
    ipq_ = ipq_ - ifvar_;
    (void) _xadj (&pq_, &ipq_, ierror_);
    if ((*ierror_) != 0) {
      goto _l0;
    }
    goto _l90;
    _l80:;
    z_ = -logf (r_);
    w_ = _xpsi (($1_ = nu_ + 1.0, &$1_), &ipsik_, &ipsix_);
    xs_ = 1.0 / sinf ((*theta_));
    pq_ = 0.0;
    ipq_ = 0;
    ia_ = 0;
    a_ = 1.0;
    for (k_ = 1; k_ <= j0_; (k_)++) {
      flok_ = k_;
      if (k_ == 1) {
        goto _l81;
      }
      a_ = a_ * y_ * (flok_ - 2.0 - nu_) * (flok_ - 1.0 + nu_) / ((flok_ - 1.0 + dmu_) * (flok_ - 1.0));
      (void) _xadj (&a_, &ia_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
      _l81:;
      if ((*mu_) >= 1) {
        goto _l83;
      }
      x1_ = (_xpsi (&flok_, &ipsik_, &ipsix_) - w_ + z_) * a_;
      ix1_ = ia_;
      (void) _xadd (&pq_, &ipq_, &x1_, &ix1_, &pq_, &ipq_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
      goto _l85;
      _l83:;
      x1_ = (nu_ * (nu_ + 1.0) * (z_ - w_ + _xpsi (&flok_, &ipsik_, &ipsix_)) + (nu_ - flok_ + 1.0) * (nu_ + flok_) / (2.0 * 
      flok_)) * a_;
      ix1_ = ia_;
      (void) _xadd (&pq_, &ipq_, &x1_, &ix1_, &pq_, &ipq_, ierror_);
      if ((*ierror_) != 0) {
        goto _l0;
      }
      _l85:;
    }
    if ((*mu_) >= 1) {
      pq_ = -r_ * pq_;
    }
    ixs_ = 0;
    if ((*mu_) >= 1) {
      (void) _xadd (&pq_, &ipq_, ($2_ = -xs_, &$2_), &ixs_, &pq_, &ipq_, ierror_);
    }
    if ((*ierror_) != 0) {
      goto _l0;
    }
    if (j_ == 2) {
      (*mu_) = -(*mu_);
    }
    if (j_ == 2) {
      dmu_ = -dmu_;
    }
    _l90:;
    if (j_ == 1) {
      pq2_ = pq_;
    }
    if (j_ == 1) {
      ipq2_ = ipq_;
    }
    nu_ = nu_ + 1.0;
  }
  k_ = 0;
  if (nu_ - 1.5 < (*nu1_)) {
    goto _l120;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq2_;
  ipqa_[k_ - 1] = ipq2_;
  if (nu_ > (*nu2_) + .5) {
    goto _l0;
  }
  _l120:;
  pq1_ = pq_;
  ipq1_ = ipq_;
  if (nu_ < (*nu1_) + .5) {
    goto _l130;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq_;
  ipqa_[k_ - 1] = ipq_;
  if (nu_ > (*nu2_) + .5) {
    goto _l0;
  }
  _l130:;
  x1_ = (2.0 * nu_ - 1.0) / (nu_ + dmu_) * x_ * pq1_;
  x2_ = (nu_ - 1.0 - dmu_) / (nu_ + dmu_) * pq2_;
  (void) _xadd (&x1_, &ipq1_, ($3_ = -x2_, &$3_), &ipq2_, &pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _xadj (&pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  nu_ = nu_ + 1.0;
  pq2_ = pq1_;
  ipq2_ = ipq1_;
  goto _l120;
  _l0:;
  __calls[18].calls++;
  return 0;
}

int_4 _xqmu (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, int_4 _p_ mu2_, real_4 _p_ theta_, real_4 _p_ x_, real_4 
_p_ sx_, int_4 _p_ id_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 mu_, ipq2_, k_, ipq1_, ipq_;
  static real_4 dmu_, nu_, pq_, pq1_, pq2_, x1_, x2_;
  real_4 $0_;
  (*ierror_) = 0;
  mu_ = 0;
  (void) _xpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pq2_ = pqa_[0];
  ipq2_ = ipqa_[0];
  mu_ = 1;
  (void) _xpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  nu_ = (*nu1_);
  k_ = 0;
  mu_ = 1;
  dmu_ = 1.0;
  pq1_ = pqa_[0];
  ipq1_ = ipqa_[0];
  if ((*mu1_) > 0) {
    goto _l310;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq2_;
  ipqa_[k_ - 1] = ipq2_;
  if ((*mu2_) < 1) {
    goto _l330;
  }
  _l310:;
  if ((*mu1_) > 1) {
    goto _l320;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq1_;
  ipqa_[k_ - 1] = ipq1_;
  if ((*mu2_) <= 1) {
    goto _l330;
  }
  _l320:;
  x1_ = -2.0 * dmu_ * (*x_) * (*sx_) * pq1_;
  x2_ = (nu_ + dmu_) * (nu_ - dmu_ + 1.0) * pq2_;
  (void) _xadd (&x1_, &ipq1_, ($0_ = -x2_, &$0_), &ipq2_, &pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _xadj (&pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pq2_ = pq1_;
  ipq2_ = ipq1_;
  pq1_ = pq_;
  ipq1_ = ipq_;
  mu_ = mu_ + 1;
  dmu_ = dmu_ + 1.0;
  if (mu_ < (*mu1_)) {
    goto _l320;
  }
  k_ = k_ + 1;
  pqa_[k_ - 1] = pq_;
  ipqa_[k_ - 1] = ipq_;
  if ((*mu2_) > mu_) {
    goto _l320;
  }
  _l330:;
  _l0:;
  __calls[19].calls++;
  return 0;
}

int_4 _xqnu (real_4 _p_ nu1_, real_4 _p_ nu2_, int_4 _p_ mu1_, real_4 _p_ theta_, real_4 _p_ x_, real_4 _p_ sx_, int_4 
_p_ id_, real_4 _p_ pqa_, int_4 _p_ ipqa_, int_4 _p_ ierror_)
{
  static int_4 k_, ipq2_, ipql2_, mu_, ipq1_, ipql1_, ipq_;
  static real_4 dmu_, nu_, pq_, pq1_, pq2_, x1_, x2_, pql1_, pql2_;
  real_4 $0_;
  (*ierror_) = 0;
  k_ = 0;
  pq2_ = 0.0;
  ipq2_ = 0;
  pql2_ = 0.0;
  ipql2_ = 0;
  if ((*mu1_) == 1) {
    goto _l290;
  }
  mu_ = 0;
  (void) _xpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*mu1_) == 0) {
    goto _l0;
  }
  k_ = ((*nu2_) - (*nu1_) + 1.5);
  pq2_ = pqa_[k_ - 1];
  ipq2_ = ipqa_[k_ - 1];
  pql2_ = pqa_[k_ - 1 - 1];
  ipql2_ = ipqa_[k_ - 1 - 1];
  _l290:;
  mu_ = 1;
  (void) _xpqnu (nu1_, nu2_, &mu_, theta_, id_, pqa_, ipqa_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  if ((*mu1_) == 1) {
    goto _l0;
  }
  nu_ = (*nu2_);
  pq1_ = pqa_[k_ - 1];
  ipq1_ = ipqa_[k_ - 1];
  pql1_ = pqa_[k_ - 1 - 1];
  ipql1_ = ipqa_[k_ - 1 - 1];
  _l300:;
  mu_ = 1;
  dmu_ = 1.0;
  _l320:;
  x1_ = -2.0 * dmu_ * (*x_) * (*sx_) * pq1_;
  x2_ = (nu_ + dmu_) * (nu_ - dmu_ + 1.0) * pq2_;
  (void) _xadd (&x1_, &ipq1_, ($0_ = -x2_, &$0_), &ipq2_, &pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _xadj (&pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pq2_ = pq1_;
  ipq2_ = ipq1_;
  pq1_ = pq_;
  ipq1_ = ipq_;
  mu_ = mu_ + 1;
  dmu_ = dmu_ + 1.0;
  if (mu_ < (*mu1_)) {
    goto _l320;
  }
  pqa_[k_ - 1] = pq_;
  ipqa_[k_ - 1] = ipq_;
  if (k_ == 1) {
    goto _l0;
  }
  if (nu_ < (*nu2_)) {
    goto _l340;
  }
  nu_ = nu_ - 1.0;
  pq2_ = pql2_;
  ipq2_ = ipql2_;
  pq1_ = pql1_;
  ipq1_ = ipql1_;
  k_ = k_ - 1;
  goto _l300;
  _l340:;
  pq1_ = pqa_[k_ - 1];
  ipq1_ = ipqa_[k_ - 1];
  pq2_ = pqa_[k_ + 1 - 1];
  ipq2_ = ipqa_[k_ + 1 - 1];
  _l350:;
  if (nu_ <= (*nu1_)) {
    goto _l0;
  }
  k_ = k_ - 1;
  x1_ = (2.0 * nu_ + 1.0) * (*x_) * pq1_ / (nu_ + dmu_);
  x2_ = -(nu_ - dmu_ + 1.0) * pq2_ / (nu_ + dmu_);
  (void) _xadd (&x1_, &ipq1_, &x2_, &ipq2_, &pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  (void) _xadj (&pq_, &ipq_, ierror_);
  if ((*ierror_) != 0) {
    goto _l0;
  }
  pq2_ = pq1_;
  ipq2_ = ipq1_;
  pq1_ = pq_;
  ipq1_ = ipq_;
  pqa_[k_ - 1] = pq_;
  ipqa_[k_ - 1] = ipq_;
  nu_ = nu_ - 1.0;
  goto _l350;
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _xset (int_4 _p_ irad_, int_4 _p_ nradpl_, real_4 _p_ dzero_, int_4 _p_ nbits_, int_4 _p_ ierror_)
{
  static int_4 iflag_, log102_[20], lgtemp_[20], iradx_, nrdplc_, iminex_, imaxex_, nbitsx_, log2r_, lx_, nb_, np1_, ic_, 
  ii_, i_, it_, lg102x_, j_, kk_, k_;
  static real_4 dzerox_;
  int_4 _data_k_4, _p_ _arr_0, _k_1, _data_k_5, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_;
  extern int_4 _i1mach ();
#define _data_n_4 20
  static int_4 _data_l_4[_data_n_4] = {
    301,
    29,
    995,
    663,
    981,
    195,
    213,
    738,
    894,
    724,
    493,
    26,
    768,
    189,
    881,
    462,
    108,
    541,
    310,
    428
  };
#define _data_n_5 1
  static int_4 _data_l_5[_data_n_5] = {
    0
  };
  if (__calls[21].calls == 0) {
    _data_k_4 = 0;
    for (_arr_0 = (int_4 *) log102_, _k_1 = 0; _k_1 < 20; _arr_0++, _k_1++) {
      if (_data_k_4 >= _data_n_4) {
        _data_k_4 = 0;
      }
      log102_[_k_1] = _data_l_4[_data_k_4++];
    }
  }
  if (__calls[21].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    iflag_ = _data_l_5[_data_k_5++];
  }
  (*ierror_) = 0;
  if (iflag_ != 0) {
    goto _l0;
  }
  iradx_ = (*irad_);
  nrdplc_ = (*nradpl_);
  dzerox_ = (*dzero_);
  iminex_ = 0;
  imaxex_ = 0;
  nbitsx_ = (*nbits_);
  if (iradx_ == 0) {
    iradx_ = _i1mach (($2_ = 10, &$2_));
  }
  if (nrdplc_ == 0) {
    nrdplc_ = _i1mach (($3_ = 11, &$3_));
  }
  if (dzerox_ == 0.0) {
    iminex_ = _i1mach (($4_ = 12, &$4_));
  }
  if (dzerox_ == 0.0) {
    imaxex_ = _i1mach (($5_ = 13, &$5_));
  }
  if (nbitsx_ == 0) {
    nbitsx_ = _i1mach (($6_ = 8, &$6_));
  }
  if (iradx_ == 2) {
    goto _l10;
  }
  if (iradx_ == 4) {
    goto _l10;
  }
  if (iradx_ == 8) {
    goto _l10;
  }
  if (iradx_ == 16) {
    goto _l10;
  }
  (void) _xermsg (_dc_4, _dc_18, _dc_9, ($7_ = 101, &$7_), &_k1);
  (*ierror_) = 101;
  goto _l0;
  _l10:;
  log2r_ = 0;
  if (iradx_ == 2) {
    log2r_ = 1;
  }
  if (iradx_ == 4) {
    log2r_ = 2;
  }
  if (iradx_ == 8) {
    log2r_ = 3;
  }
  if (iradx_ == 16) {
    log2r_ = 4;
  }
  xblk1_.nbitsf_ = log2r_ * nrdplc_;
  xblk2_.radix_ = iradx_;
  xblk2_.dlg10r_ = log10f (xblk2_.radix_);
  if (dzerox_ != 0.0) {
    goto _l14;
  }
  lx_ = _min ((1 - iminex_) / 2, (imaxex_ - 1) / 2);
  goto _l16;
  _l14:;
  lx_ = 0.5 * log10f (dzerox_) / xblk2_.dlg10r_;
  lx_ = lx_ - 1;
  _l16:;
  xblk2_.l2_ = 2 * lx_;
  if (lx_ >= 4) {
    goto _l20;
  }
  (void) _xermsg (_dc_4, _dc_18, _dc_10, ($8_ = 102, &$8_), &_k1);
  (*ierror_) = 102;
  goto _l0;
  _l20:;
  xblk2_.l_ = lx_;
  xblk2_.radixl_ = _up_real_4 (xblk2_.radix_, xblk2_.l_);
  xblk2_.rad2l_ = (xblk2_.radixl_ * xblk2_.radixl_);
  if (15 <= nbitsx_ && nbitsx_ <= 63) {
    goto _l30;
  }
  (void) _xermsg (_dc_4, _dc_18, _dc_11, ($9_ = 103, &$9_), &_k1);
  (*ierror_) = 103;
  goto _l0;
  _l30:;
  xblk2_.kmax_ = _up_int_4 (2, (nbitsx_ - 1)) - xblk2_.l2_;
  nb_ = (nbitsx_ - 1) / 2;
  xblk3_.mlg102_ = _up_int_4 (2, nb_);
  if (1 <= nrdplc_ * log2r_ && nrdplc_ * log2r_ <= 120) {
    goto _l40;
  }
  (void) _xermsg (_dc_4, _dc_18, _dc_12, ($10_ = 104, &$10_), &_k1);
  (*ierror_) = 104;
  goto _l0;
  _l40:;
  xblk3_.nlg102_ = nrdplc_ * log2r_ / nb_ + 3;
  np1_ = xblk3_.nlg102_ + 1;
  ic_ = 0;
  for (ii_ = 1; ii_ <= 20; (ii_)++) {
    i_ = 21 - ii_;
    it_ = log2r_ * log102_[i_ - 1] + ic_;
    ic_ = it_ / 1000;
    lgtemp_[i_ - 1] = _imod (it_, 1000);
  }
  xblk3_.lg102_[0] = ic_;
  for (i_ = 2; i_ <= np1_; (i_)++) {
    lg102x_ = 0;
    for (j_ = 1; j_ <= nb_; (j_)++) {
      ic_ = 0;
      for (kk_ = 1; kk_ <= 20; (kk_)++) {
        k_ = 21 - kk_;
        it_ = 2 * lgtemp_[k_ - 1] + ic_;
        ic_ = it_ / 1000;
        lgtemp_[k_ - 1] = _imod (it_, 1000);
      }
      lg102x_ = 2 * lg102x_ + ic_;
    }
    xblk3_.lg102_[i_ - 1] = lg102x_;
  }
  if (nrdplc_ < xblk2_.l_) {
    goto _l90;
  }
  (void) _xermsg (_dc_4, _dc_18, _dc_13, ($11_ = 105, &$11_), &_k1);
  (*ierror_) = 105;
  goto _l0;
  _l90:;
  if (6 * xblk2_.l_ <= xblk2_.kmax_) {
    goto _l100;
  }
  (void) _xermsg (_dc_4, _dc_18, _dc_14, ($12_ = 106, &$12_), &_k1);
  (*ierror_) = 106;
  goto _l0;
  _l100:;
  iflag_ = 1;
  _l0:;
  __calls[21].calls++;
  return 0;
}

