//! @file mathlib-slatec-harwell.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 10 subprograms from SLATEC-HARWELL

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// LA05AD LA05AS LA05BD LA05BS LA05CD LA05CS LA05ED LA05ES MC20AD MC20AS

// Miscellaneous routines from SLATEC, not in other packages as BLAS,
// EISPACK, FISHPACK, FFTPACK, FNLIB, LINPACK etcetera.
// 
// Source: netlib.org/slatec/
// 
// For VIF, all source file have been formatted and labels have been renumbered.

// The license for SLATEC Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "slatec"
#define _dc_1 "la05ad"
#define _dc_2 "more than one matrix "
#define _dc_3 "entry.  here row = "
#define _dc_4 " and col = "
#define _dc_5 "the order of the system, n, is not positive."
#define _dc_6 "element k = "
#define _dc_7 " is out of bounds.$$here row = "
#define _dc_8 "row or column has no "
#define _dc_9 "elements.  here index = "
#define _dc_10 "lengths of arrays a(*) and ind(*,2) are too small."
#define _dc_11 "rows"
#define _dc_12 "columns"
#define _dc_13 "dependant "
#define _dc_14 " "
#define _dc_15 "dependent vector indices are "
#define _dc_16 " and "
#define _dc_17 "la05as"
#define _dc_18 "la05bd"
#define _dc_19 "earlier entry gave error return."
#define _dc_20 "la05bs"
#define _dc_21 "la05cd"
#define _dc_22 "singular matrix after "
#define _dc_23 "replacement of column.  index = "
#define _dc_24 "la05cs"
static FORMAT *__fmt_a = NULL;
typedef char char_1[2];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
typedef char char_127[128];
typedef char char_255[256];
typedef char char_511[512];
#define __ncalls 11
static CALLS __calls[__ncalls] = {
  {"la05ad", 0}, // subroutine
  {"la05as", 0}, // subroutine
  {"la05bd", 0}, // subroutine
  {"la05bs", 0}, // subroutine
  {"la05cd", 0}, // subroutine
  {"la05cs", 0}, // subroutine
  {"la05ed", 0}, // subroutine
  {"la05es", 0}, // subroutine
  {"mc20ad", 0}, // subroutine
  {"mc20as", 0}, // subroutine
  {NULL, 0}
};

static struct {
  int_4 lp_, lenl_, lenu_, ncp_, lrow_, lcol_;
  real_8 small_;
} la05dd_;
static struct {
  int_4 lp_, lenl_, lenu_, ncp_, lrow_, lcol_;
  real_4 small_;
} la05ds_;
prototype int_4 _la05ad (real_8 _p_ a_, int_4 _p_ ind_, int_4 _p_ nz_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, 
int_4 _p_ iw_, real_8 _p_ w_, real_8 _p_ g_, real_8 _p_ u_);
prototype int_4 _la05as (real_4 _p_ a_, int_4 _p_ ind_, int_4 _p_ nz_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, 
int_4 _p_ iw_, real_4 _p_ w_, real_4 _p_ g_, real_4 _p_ u_);
prototype int_4 _la05bd (real_8 _p_ a_, int_4 _p_ ind_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, 
real_8 _p_ w_, real_8 _p_ g_, real_8 _p_ b_, logical_4 _p_ trans_);
prototype int_4 _la05bs (real_4 _p_ a_, int_4 _p_ ind_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, 
real_4 _p_ w_, real_4 _p_ g_, real_4 _p_ b_, logical_4 _p_ trans_);
prototype int_4 _la05cd (real_8 _p_ a_, int_4 _p_ ind_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, 
real_8 _p_ w_, real_8 _p_ g_, real_8 _p_ u_, int_4 _p_ mm_);
prototype int_4 _la05cs (real_4 _p_ a_, int_4 _p_ ind_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, 
real_4 _p_ w_, real_4 _p_ g_, real_4 _p_ u_, int_4 _p_ mm_);
prototype int_4 _la05ed (real_8 _p_ a_, int_4 _p_ irn_, int_4 _p_ ip_, int_4 _p_ n_, int_4 _p_ iw_, int_4 _p_ ia_, 
logical_4 _p_ reals_);
prototype int_4 _la05es (real_4 _p_ a_, int_4 _p_ irn_, int_4 _p_ ip_, int_4 _p_ n_, int_4 _p_ iw_, int_4 _p_ ia_, 
logical_4 _p_ reals_);
prototype int_4 _mc20ad (int_4 _p_ nc_, int_4 _p_ maxa_, real_8 _p_ a_, int_4 _p_ inum_, int_4 _p_ jptr_, int_4 _p_ 
jnum_, int_4 _p_ jdisp_);
prototype int_4 _mc20as (int_4 _p_ nc_, int_4 _p_ maxa_, real_4 _p_ a_, int_4 _p_ inum_, int_4 _p_ jptr_, int_4 _p_ 
jnum_, int_4 _p_ jdisp_);
int_4 _la05ad (real_8 _p_ a_, int_4 _p_ ind_, int_4 _p_ nz_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, 
real_8 _p_ w_, real_8 _p_ g_, real_8 _p_ u_)
{
  static int_4 i_, j_, l_, idummy_, k_, mcp_, ir_, kl_, ii_, kp_, kr_, in_, ipv_, jcost_, kcost_, k1_, k2_, kk_, kj_, 
  ipp_, jp_, il_, kpc_, klc_, kc_, nzc_, nc_, krl_, knp_, kq_, kpl_, ks_, kn_;
  static logical_4 first_;
  static real_8 amax_, au_, am_, eps_;
  static char_15 xern0_, xern1_, xern2_;
  int_4 _data_k_0, $0_, $1_, $2_, $3_, __fcnt, __rc, $12_, $19_, $23_, $24_, $27_, $32_;
  logical_4 $4_, $5_, $6_;
  char_31 $13_, $25_, $26_;
  char_63 $7_, $14_, $20_, $28_;
  char_127 $8_, $15_, $21_, $22_, $29_;
  char_255 $9_, $16_, $30_, $31_;
  char_511 $10_, $11_, $17_, $18_;
  extern real_8 _d1mach ();
  static FORMAT $f_100330_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100331_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100340_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100341_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100342_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100348_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100366_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100368_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
#define _data_n_0 1
  static logical_4 _data_l_0[_data_n_0] = {
    TRUE
  };
  if (__calls[0].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    first_ = _data_l_0[_data_k_0++];
  }
  if (first_) {
    eps_ = 2.0e0 * _d1mach (($0_ = 4, &$0_));
  }
  first_ = FALSE;
  (void) _xsetun (&la05dd_.lp_);
  if ((*u_) > 1.0e0) {
    (*u_) = 1.0;
  }
  if ((*u_) < eps_) {
    (*u_) = eps_;
  }
  if ((*n_) < 1) {
    goto _l670;
  }
  (*g_) = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = 0.0;
    for (j_ = 1; j_ <= 5; (j_)++) {
      iw_[i_ - 1 + ((*n_)) * ((j_ - 1))] = 0;
    }
  }
  l_ = 1;
  la05dd_.lenu_ = (*nz_);
  for (idummy_ = 1; idummy_ <= (*nz_); (idummy_)++) {
    if (l_ > la05dd_.lenu_) {
      goto _l90;
    }
    for (k_ = l_; k_ <= la05dd_.lenu_; (k_)++) {
      if (_abs (a_[k_ - 1]) <= la05dd_.small_) {
        goto _l70;
      }
      i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      (*g_) = _max (_abs (a_[k_ - 1]), (*g_));
      if (i_ < 1 || i_ > (*n_)) {
        goto _l680;
      }
      if (j_ < 1 || j_ > (*n_)) {
        goto _l680;
      }
      iw_[i_ - 1 + ((*n_)) * ((0))] = iw_[i_ - 1 + ((*n_)) * ((0))] + 1;
      iw_[j_ - 1 + ((*n_)) * ((1))] = iw_[j_ - 1 + ((*n_)) * ((1))] + 1;
    }
    goto _l90;
    _l70:;
    l_ = k_;
    a_[l_ - 1] = a_[la05dd_.lenu_ - 1];
    ind_[l_ - 1 + ((*ia_)) * ((0))] = ind_[la05dd_.lenu_ - 1 + ((*ia_)) * ((0))];
    ind_[l_ - 1 + ((*ia_)) * ((1))] = ind_[la05dd_.lenu_ - 1 + ((*ia_)) * ((1))];
    la05dd_.lenu_ = la05dd_.lenu_ - 1;
  }
  _l90:;
  la05dd_.lenl_ = 0;
  la05dd_.lrow_ = la05dd_.lenu_;
  la05dd_.lcol_ = la05dd_.lrow_;
  mcp_ = _max ((*n_) / 10, 20);
  la05dd_.ncp_ = 0;
  k_ = 1;
  for (ir_ = 1; ir_ <= (*n_); (ir_)++) {
    k_ = k_ + iw_[ir_ - 1 + ((*n_)) * ((1))];
    ip_[ir_ - 1 + ((*n_)) * ((1))] = k_;
    for (l_ = 1; l_ <= 2; (l_)++) {
      if (iw_[ir_ - 1 + ((*n_)) * ((l_ - 1))] <= 0) {
        goto _l700;
      }
    }
  }
  (void) _mc20ad (n_, &la05dd_.lenu_, a_, &ind_[0 + ((*ia_)) * ((1))], ip_, &ind_[0 + ((*ia_)) * ((0))], &_k0);
  kl_ = la05dd_.lenu_;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    ir_ = (*n_) + 1 - ii_;
    kp_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      if (iw_[j_ - 1 + ((*n_)) * ((4))] == ir_) {
        goto _l660;
      }
      iw_[j_ - 1 + ((*n_)) * ((4))] = ir_;
      kr_ = ip_[j_ - 1 + ((*n_)) * ((1))] - 1;
      ip_[j_ - 1 + ((*n_)) * ((1))] = kr_;
      ind_[kr_ - 1 + ((*ia_)) * ((0))] = ir_;
    }
    kl_ = kp_ - 1;
  }
  for (l_ = 1; l_ <= 2; (l_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      (*nz_) = iw_[i_ - 1 + ((*n_)) * ((l_ - 1))];
      in_ = iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))];
      iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))] = i_;
      iw_[i_ - 1 + ((*n_)) * ((l_ + 6 - 1))] = in_;
      iw_[i_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = 0;
      if (in_ != 0) {
        iw_[in_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = i_;
      }
    }
  }
  for (ipv_ = 1; ipv_ <= (*n_); (ipv_)++) {
    jcost_ = (*n_) * (*n_);
    for ((*nz_) = 1; (*nz_) <= (*n_); ((*nz_))++) {
      if (jcost_ <= ($1_ = ((*nz_) - 1), $1_ * $1_)) {
        goto _l250;
      }
      j_ = iw_[(*nz_) - 1 + ((*n_)) * ((3))];
      for (idummy_ = 1; idummy_ <= (*n_); (idummy_)++) {
        if (j_ <= 0) {
          goto _l200;
        }
        kp_ = ip_[j_ - 1 + ((*n_)) * ((1))];
        kl_ = kp_ + iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
        for (k_ = kp_; k_ <= kl_; (k_)++) {
          i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
          kcost_ = ((*nz_) - 1) * (iw_[i_ - 1 + ((*n_)) * ((0))] - 1);
          if (kcost_ >= jcost_) {
            goto _l180;
          }
          if ((*nz_) == 1) {
            goto _l170;
          }
          amax_ = 0.0;
          k1_ = ip_[i_ - 1 + ((*n_)) * ((0))];
          k2_ = iw_[i_ - 1 + ((*n_)) * ((0))] + k1_ - 1;
          for (kk_ = k1_; kk_ <= k2_; (kk_)++) {
            amax_ = _max (amax_, _abs (a_[kk_ - 1]));
            if (ind_[kk_ - 1 + ((*ia_)) * ((1))] == j_) {
              kj_ = kk_;
            }
          }
          if (_abs (a_[kj_ - 1]) < amax_ * (*u_)) {
            goto _l180;
          }
          _l170:;
          jcost_ = kcost_;
          ipp_ = i_;
          jp_ = j_;
          if (jcost_ <= ($2_ = ((*nz_) - 1), $2_ * $2_)) {
            goto _l250;
          }
          _l180:;
        }
        j_ = iw_[j_ - 1 + ((*n_)) * ((7))];
      }
      _l200:;
      i_ = iw_[(*nz_) - 1 + ((*n_)) * ((2))];
      for (idummy_ = 1; idummy_ <= (*n_); (idummy_)++) {
        if (i_ <= 0) {
          goto _l240;
        }
        amax_ = 0.0;
        kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
        kl_ = kp_ + iw_[i_ - 1 + ((*n_)) * ((0))] - 1;
        for (k_ = kp_; k_ <= kl_; (k_)++) {
          amax_ = _max (_abs (a_[k_ - 1]), amax_);
        }
        au_ = amax_ * (*u_);
        for (k_ = kp_; k_ <= kl_; (k_)++) {
          if (_abs (a_[k_ - 1]) < au_) {
            goto _l220;
          }
          j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
          kcost_ = ((*nz_) - 1) * (iw_[j_ - 1 + ((*n_)) * ((1))] - 1);
          if (kcost_ >= jcost_) {
            goto _l220;
          }
          jcost_ = kcost_;
          ipp_ = i_;
          jp_ = j_;
          if (jcost_ <= ($3_ = ((*nz_) - 1), $3_ * $3_)) {
            goto _l250;
          }
          _l220:;
        }
        i_ = iw_[i_ - 1 + ((*n_)) * ((6))];
      }
      _l240:;
    }
    _l250:;
    kp_ = ip_[jp_ - 1 + ((*n_)) * ((1))];
    kl_ = iw_[jp_ - 1 + ((*n_)) * ((1))] + kp_ - 1;
    for (l_ = 1; l_ <= 2; (l_)++) {
      for (k_ = kp_; k_ <= kl_; (k_)++) {
        i_ = ind_[k_ - 1 + ((*ia_)) * ((l_ - 1))];
        il_ = iw_[i_ - 1 + ((*n_)) * ((l_ + 4 - 1))];
        in_ = iw_[i_ - 1 + ((*n_)) * ((l_ + 6 - 1))];
        if (il_ == 0) {
          goto _l260;
        }
        iw_[il_ - 1 + ((*n_)) * ((l_ + 6 - 1))] = in_;
        goto _l270;
        _l260:;
        (*nz_) = iw_[i_ - 1 + ((*n_)) * ((l_ - 1))];
        iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))] = in_;
        _l270:;
        if (in_ > 0) {
          iw_[in_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = il_;
        }
      }
      kp_ = ip_[ipp_ - 1 + ((*n_)) * ((0))];
      kl_ = kp_ + iw_[ipp_ - 1 + ((*n_)) * ((0))] - 1;
    }
    iw_[ipp_ - 1 + ((*n_)) * ((4))] = -ipv_;
    iw_[jp_ - 1 + ((*n_)) * ((5))] = -ipv_;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      kpc_ = ip_[j_ - 1 + ((*n_)) * ((1))];
      iw_[j_ - 1 + ((*n_)) * ((1))] = iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
      klc_ = kpc_ + iw_[j_ - 1 + ((*n_)) * ((1))];
      for (kc_ = kpc_; kc_ <= klc_; (kc_)++) {
        if (ipp_ == ind_[kc_ - 1 + ((*ia_)) * ((0))]) {
          goto _l310;
        }
      }
      _l310:;
      ind_[kc_ - 1 + ((*ia_)) * ((0))] = ind_[klc_ - 1 + ((*ia_)) * ((0))];
      ind_[klc_ - 1 + ((*ia_)) * ((0))] = 0;
      if (j_ == jp_) {
        kr_ = k_;
      }
    }
    au_ = a_[kr_ - 1];
    a_[kr_ - 1] = a_[kp_ - 1];
    a_[kp_ - 1] = au_;
    ind_[kr_ - 1 + ((*ia_)) * ((1))] = ind_[kp_ - 1 + ((*ia_)) * ((1))];
    ind_[kp_ - 1 + ((*ia_)) * ((1))] = jp_;
    nzc_ = iw_[jp_ - 1 + ((*n_)) * ((1))];
    if (nzc_ == 0) {
      goto _l550;
    }
    for (nc_ = 1; nc_ <= nzc_; (nc_)++) {
      kc_ = ip_[jp_ - 1 + ((*n_)) * ((1))] + nc_ - 1;
      ir_ = ind_[kc_ - 1 + ((*ia_)) * ((0))];
      kr_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
      krl_ = kr_ + iw_[ir_ - 1 + ((*n_)) * ((0))] - 1;
      for (knp_ = kr_; knp_ <= krl_; (knp_)++) {
        if (jp_ == ind_[knp_ - 1 + ((*ia_)) * ((1))]) {
          goto _l340;
        }
      }
      _l340:;
      am_ = a_[knp_ - 1];
      a_[knp_ - 1] = a_[kr_ - 1];
      a_[kr_ - 1] = am_;
      ind_[knp_ - 1 + ((*ia_)) * ((1))] = ind_[kr_ - 1 + ((*ia_)) * ((1))];
      ind_[kr_ - 1 + ((*ia_)) * ((1))] = jp_;
      am_ = -a_[kr_ - 1] / a_[kp_ - 1];
      if (la05dd_.lrow_ + iw_[ir_ - 1 + ((*n_)) * ((0))] + iw_[ipp_ - 1 + ((*n_)) * ((0))] + la05dd_.lenl_ <= (*ia_)) {
        goto _l350;
      }
      if (la05dd_.ncp_ >= mcp_ || la05dd_.lenu_ + iw_[ir_ - 1 + ((*n_)) * ((0))] + iw_[ipp_ - 1 + ((*n_)) * ((0))] + 
        la05dd_.lenl_ > (*ia_)) {
        goto _l710;
      }
      (void) _la05ed (a_, &ind_[0 + ((*ia_)) * ((1))], ip_, n_, iw_, ia_, ($4_ = TRUE, &$4_));
      kp_ = ip_[ipp_ - 1 + ((*n_)) * ((0))];
      kr_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
      _l350:;
      krl_ = kr_ + iw_[ir_ - 1 + ((*n_)) * ((0))] - 1;
      kq_ = kp_ + 1;
      kpl_ = kp_ + iw_[ipp_ - 1 + ((*n_)) * ((0))] - 1;
      if (kq_ > kpl_) {
        goto _l370;
      }
      for (k_ = kq_; k_ <= kpl_; (k_)++) {
        j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
        w_[j_ - 1] = a_[k_ - 1];
      }
      _l370:;
      ip_[ir_ - 1 + ((*n_)) * ((0))] = la05dd_.lrow_ + 1;
      ind_[kr_ - 1 + ((*ia_)) * ((1))] = 0;
      kr_ = kr_ + 1;
      if (kr_ > krl_) {
        goto _l430;
      }
      for (ks_ = kr_; ks_ <= krl_; (ks_)++) {
        j_ = ind_[ks_ - 1 + ((*ia_)) * ((1))];
        au_ = a_[ks_ - 1] + am_ * w_[j_ - 1];
        ind_[ks_ - 1 + ((*ia_)) * ((1))] = 0;
        if (_abs (au_) <= la05dd_.small_) {
          goto _l380;
        }
        (*g_) = _max ((*g_), _abs (au_));
        la05dd_.lrow_ = la05dd_.lrow_ + 1;
        a_[la05dd_.lrow_ - 1] = au_;
        ind_[la05dd_.lrow_ - 1 + ((*ia_)) * ((1))] = j_;
        goto _l410;
        _l380:;
        la05dd_.lenu_ = la05dd_.lenu_ - 1;
        k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
        kl_ = k_ + iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
        iw_[j_ - 1 + ((*n_)) * ((1))] = kl_ - k_;
        for (kk_ = k_; kk_ <= kl_; (kk_)++) {
          if (ind_[kk_ - 1 + ((*ia_)) * ((0))] == ir_) {
            goto _l400;
          }
        }
        _l400:;
        ind_[kk_ - 1 + ((*ia_)) * ((0))] = ind_[kl_ - 1 + ((*ia_)) * ((0))];
        ind_[kl_ - 1 + ((*ia_)) * ((0))] = 0;
        _l410:;
        w_[j_ - 1] = 0.0;
      }
      _l430:;
      if (kq_ > kpl_) {
        goto _l520;
      }
      for (ks_ = kq_; ks_ <= kpl_; (ks_)++) {
        j_ = ind_[ks_ - 1 + ((*ia_)) * ((1))];
        au_ = am_ * w_[j_ - 1];
        if (_abs (au_) <= la05dd_.small_) {
          goto _l500;
        }
        la05dd_.lrow_ = la05dd_.lrow_ + 1;
        a_[la05dd_.lrow_ - 1] = au_;
        ind_[la05dd_.lrow_ - 1 + ((*ia_)) * ((1))] = j_;
        la05dd_.lenu_ = la05dd_.lenu_ + 1;
        (*nz_) = iw_[j_ - 1 + ((*n_)) * ((1))];
        k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
        kl_ = k_ + (*nz_) - 1;
        if ((*nz_) == 0) {
          goto _l460;
        }
        if (kl_ != la05dd_.lcol_) {
          goto _l440;
        }
        if (la05dd_.lcol_ + la05dd_.lenl_ >= (*ia_)) {
          goto _l460;
        }
        la05dd_.lcol_ = la05dd_.lcol_ + 1;
        goto _l450;
        _l440:;
        if (ind_[kl_ + 1 - 1 + ((*ia_)) * ((0))] != 0) {
          goto _l460;
        }
        _l450:;
        ind_[kl_ + 1 - 1 + ((*ia_)) * ((0))] = ir_;
        goto _l490;
        _l460:;
        if (la05dd_.lcol_ + la05dd_.lenl_ + (*nz_) + 1 < (*ia_)) {
          goto _l470;
        }
        if (la05dd_.ncp_ >= mcp_ || la05dd_.lenu_ + la05dd_.lenl_ + (*nz_) + 1 >= (*ia_)) {
          goto _l710;
        }
        (void) _la05ed (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($5_ = FALSE, &$5_));
        k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
        kl_ = k_ + (*nz_) - 1;
        _l470:;
        ip_[j_ - 1 + ((*n_)) * ((1))] = la05dd_.lcol_ + 1;
        if (kl_ < k_) {
          goto _l485;
        }
        for (kk_ = k_; kk_ <= kl_; (kk_)++) {
          la05dd_.lcol_ = la05dd_.lcol_ + 1;
          ind_[la05dd_.lcol_ - 1 + ((*ia_)) * ((0))] = ind_[kk_ - 1 + ((*ia_)) * ((0))];
          ind_[kk_ - 1 + ((*ia_)) * ((0))] = 0;
        }
        _l485:;
        la05dd_.lcol_ = la05dd_.lcol_ + 1;
        ind_[la05dd_.lcol_ - 1 + ((*ia_)) * ((0))] = ir_;
        _l490:;
        (*g_) = _max ((*g_), _abs (au_));
        iw_[j_ - 1 + ((*n_)) * ((1))] = (*nz_) + 1;
        _l500:;
        w_[j_ - 1] = 0.0;
      }
      _l520:;
      iw_[ir_ - 1 + ((*n_)) * ((0))] = la05dd_.lrow_ + 1 - ip_[ir_ - 1 + ((*n_)) * ((0))];
      if (la05dd_.lenl_ + la05dd_.lcol_ + 1 <= (*ia_)) {
        goto _l530;
      }
      if (la05dd_.ncp_ >= mcp_) {
        goto _l710;
      }
      (void) _la05ed (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($6_ = FALSE, &$6_));
      _l530:;
      k_ = (*ia_) - la05dd_.lenl_;
      la05dd_.lenl_ = la05dd_.lenl_ + 1;
      a_[k_ - 1] = am_;
      ind_[k_ - 1 + ((*ia_)) * ((0))] = ipp_;
      ind_[k_ - 1 + ((*ia_)) * ((1))] = ir_;
      la05dd_.lenu_ = la05dd_.lenu_ - 1;
    }
    _l550:;
    k1_ = ip_[jp_ - 1 + ((*n_)) * ((1))];
    k2_ = iw_[jp_ - 1 + ((*n_)) * ((1))] + k1_ - 1;
    iw_[jp_ - 1 + ((*n_)) * ((1))] = 0;
    for (l_ = 1; l_ <= 2; (l_)++) {
      if (k2_ < k1_) {
        goto _l570;
      }
      for (k_ = k1_; k_ <= k2_; (k_)++) {
        ir_ = ind_[k_ - 1 + ((*ia_)) * ((l_ - 1))];
        if (l_ == 1) {
          ind_[k_ - 1 + ((*ia_)) * ((l_ - 1))] = 0;
        }
        (*nz_) = iw_[ir_ - 1 + ((*n_)) * ((l_ - 1))];
        if ((*nz_) <= 0) {
          goto _l720;
        }
        in_ = iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))];
        iw_[ir_ - 1 + ((*n_)) * ((l_ + 6 - 1))] = in_;
        iw_[ir_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = 0;
        iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))] = ir_;
        if (in_ != 0) {
          iw_[in_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = ir_;
        }
      }
      _l570:;
      k1_ = ip_[ipp_ - 1 + ((*n_)) * ((0))] + 1;
      k2_ = iw_[ipp_ - 1 + ((*n_)) * ((0))] + k1_ - 2;
    }
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    j_ = -iw_[i_ - 1 + ((*n_)) * ((4))];
    iw_[j_ - 1 + ((*n_)) * ((2))] = i_;
    j_ = -iw_[i_ - 1 + ((*n_)) * ((5))];
    iw_[j_ - 1 + ((*n_)) * ((3))] = i_;
    iw_[i_ - 1 + ((*n_)) * ((1))] = 0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    kl_ = iw_[i_ - 1 + ((*n_)) * ((0))] + kp_ - 1;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      iw_[j_ - 1 + ((*n_)) * ((1))] = iw_[j_ - 1 + ((*n_)) * ((1))] + 1;
    }
  }
  k_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    k_ = k_ + iw_[i_ - 1 + ((*n_)) * ((1))];
    ip_[i_ - 1 + ((*n_)) * ((1))] = k_;
  }
  la05dd_.lcol_ = k_ - 1;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    kl_ = iw_[i_ - 1 + ((*n_)) * ((0))] + kp_ - 1;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      kn_ = ip_[j_ - 1 + ((*n_)) * ((1))] - 1;
      ip_[j_ - 1 + ((*n_)) * ((1))] = kn_;
      ind_[kn_ - 1 + ((*ia_)) * ((0))] = i_;
    }
  }
  goto _l0;
  _l660:;
  if (la05dd_.lp_ > 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05ad:455", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100330_[__fcnt] != NULL && $f_100330_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100330_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:455", 0));
      __fcnt += 3;
    }
    if ($f_100330_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100330_[__fcnt] != NULL && $f_100330_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100330_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:455", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100330_[__fcnt + 2], &ir_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:455", 0));
    __fcnt += 3;
    while ($f_100330_[__fcnt] != NULL && $f_100330_[__fcnt] == FMT_TEXT) {
      if ($f_100330_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100330_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:455", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05ad:456", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:456", 0));
      __fcnt += 3;
    }
    if ($f_100331_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:456", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100331_[__fcnt + 2], &j_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:456", 0));
    __fcnt += 3;
    while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
      if ($f_100331_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:456", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, concat ($7_, _dc_2, _dc_3), 
    xern1_), _dc_4), xern2_), 511), $11_), ($12_ = -4, &$12_), &_k1);
  }
  (*g_) = -4.0;
  goto _l0;
  _l670:;
  if (la05dd_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_1, _dc_5, &_km1, &_k1);
  }
  (*g_) = -1.0;
  goto _l0;
  _l680:;
  if (la05dd_.lp_ > 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern0_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern0_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05ad:470", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100340_[__fcnt] != NULL && $f_100340_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100340_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:470", 0));
      __fcnt += 3;
    }
    if ($f_100340_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100340_[__fcnt] != NULL && $f_100340_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100340_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:470", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100340_[__fcnt + 2], &k_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:470", 0));
    __fcnt += 3;
    while ($f_100340_[__fcnt] != NULL && $f_100340_[__fcnt] == FMT_TEXT) {
      if ($f_100340_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100340_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:470", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05ad:471", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:471", 0));
      __fcnt += 3;
    }
    if ($f_100341_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:471", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100341_[__fcnt + 2], &i_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:471", 0));
    __fcnt += 3;
    while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
      if ($f_100341_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:471", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05ad:472", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:472", 0));
      __fcnt += 3;
    }
    if ($f_100342_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:472", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100342_[__fcnt + 2], &j_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:472", 0));
    __fcnt += 3;
    while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
      if ($f_100342_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:472", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($18_, concat ($17_, concat ($16_, concat ($15_, concat ($14_, concat ($13_, 
    _dc_6, xern0_), _dc_7), xern1_), _dc_4), xern2_), 511), $18_), ($19_ = -3, &$19_), &_k1);
  }
  (*g_) = -3.0;
  goto _l0;
  _l700:;
  if (la05dd_.lp_ > 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05ad:481", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:481", 0));
      __fcnt += 3;
    }
    if ($f_100348_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:481", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100348_[__fcnt + 2], &l_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:481", 0));
    __fcnt += 3;
    while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
      if ($f_100348_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:481", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($22_, concat ($21_, concat ($20_, _dc_8, _dc_9), xern1_), 127), $22_), ($23_ = 
    -2, &$23_), &_k1);
  }
  (*g_) = -2.0;
  goto _l0;
  _l710:;
  if (la05dd_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_1, _dc_10, ($24_ = -7, &$24_), &_k1);
  }
  (*g_) = -7.0;
  goto _l0;
  _l720:;
  ipv_ = ipv_ + 1;
  iw_[ipv_ - 1 + ((*n_)) * ((0))] = ir_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ii_ = -iw_[i_ - 1 + ((*n_)) * ((l_ + 4 - 1))];
    if (ii_ > 0) {
      iw_[ii_ - 1 + ((*n_)) * ((0))] = i_;
    }
  }
  if (la05dd_.lp_ > 0) {
    bufcpy (xern1_, _dc_11, 15);
    if (l_ == 2) {
      bufcpy (xern1_, _dc_12, 15);
    }
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($26_, concat ($25_, _dc_13, xern1_), 31), $26_), ($27_ = -5, &$27_), &_k1);
    _l740:;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05ad:505", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100366_[__fcnt] != NULL && $f_100366_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100366_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:505", 0));
      __fcnt += 3;
    }
    if ($f_100366_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100366_[__fcnt] != NULL && $f_100366_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100366_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:505", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100366_[__fcnt + 2], &iw_[i_ - 1 + ((*n_)) * ((0))], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:505", 0));
    __fcnt += 3;
    while ($f_100366_[__fcnt] != NULL && $f_100366_[__fcnt] == FMT_TEXT) {
      if ($f_100366_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100366_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:505", 0));
      __fcnt += 3;
    }
    bufcpy (xern2_, _dc_14, 15);
    if (i_ + 1 <= ipv_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern2_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-harwell:la05ad:507", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100368_[__fcnt] != NULL && $f_100368_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100368_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:507", 0));
        __fcnt += 3;
      }
      if ($f_100368_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100368_[__fcnt] != NULL && $f_100368_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100368_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:507", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100368_[__fcnt + 2], &iw_[i_ + 1 - 1 + ((*n_)) * ((0))], INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:507", 0));
      __fcnt += 3;
      while ($f_100368_[__fcnt] != NULL && $f_100368_[__fcnt] == FMT_TEXT) {
        if ($f_100368_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100368_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05ad:507", 0));
        __fcnt += 3;
      }
    }
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($31_, concat ($30_, concat ($29_, concat ($28_, _dc_15, xern1_), _dc_16), 
    xern2_), 255), $31_), ($32_ = -5, &$32_), &_k1);
    i_ = i_ + 2;
    if (i_ <= ipv_) {
      goto _l740;
    }
  }
  (*g_) = -5.0;
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _la05as (real_4 _p_ a_, int_4 _p_ ind_, int_4 _p_ nz_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, 
real_4 _p_ w_, real_4 _p_ g_, real_4 _p_ u_)
{
  static int_4 i_, j_, l_, idummy_, k_, mcp_, ir_, kl_, ii_, kp_, kr_, in_, ipv_, jcost_, kcost_, k1_, k2_, kk_, kj_, 
  ipp_, jp_, il_, kpc_, klc_, kc_, nzc_, nc_, krl_, knp_, kq_, kpl_, ks_, kn_;
  static logical_4 first_;
  static real_4 amax_, au_, am_, eps_;
  static char_15 xern0_, xern1_, xern2_;
  int_4 _data_k_1, $0_, $1_, $2_, $3_, __fcnt, __rc, $12_, $19_, $23_, $24_, $27_, $32_;
  logical_4 $4_, $5_, $6_;
  char_31 $13_, $25_, $26_;
  char_63 $7_, $14_, $20_, $28_;
  char_127 $8_, $15_, $21_, $22_, $29_;
  char_255 $9_, $16_, $30_, $31_;
  char_511 $10_, $11_, $17_, $18_;
  extern real_4 _r1mach ();
  static FORMAT $f_100330_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100331_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100340_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100341_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100342_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100348_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100366_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100368_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
#define _data_n_1 1
  static logical_4 _data_l_1[_data_n_1] = {
    TRUE
  };
  if (__calls[1].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    first_ = _data_l_1[_data_k_1++];
  }
  if (first_) {
    eps_ = 2.0e0 * _r1mach (($0_ = 4, &$0_));
  }
  first_ = FALSE;
  (void) _xsetun (&la05ds_.lp_);
  if ((*u_) > 1.0e0) {
    (*u_) = 1.0;
  }
  if ((*u_) < eps_) {
    (*u_) = eps_;
  }
  if ((*n_) < 1) {
    goto _l670;
  }
  (*g_) = 0.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = 0.0;
    for (j_ = 1; j_ <= 5; (j_)++) {
      iw_[i_ - 1 + ((*n_)) * ((j_ - 1))] = 0;
    }
  }
  l_ = 1;
  la05ds_.lenu_ = (*nz_);
  for (idummy_ = 1; idummy_ <= (*nz_); (idummy_)++) {
    if (l_ > la05ds_.lenu_) {
      goto _l90;
    }
    for (k_ = l_; k_ <= la05ds_.lenu_; (k_)++) {
      if (_abs (a_[k_ - 1]) <= la05ds_.small_) {
        goto _l70;
      }
      i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      (*g_) = _max (_abs (a_[k_ - 1]), (*g_));
      if (i_ < 1 || i_ > (*n_)) {
        goto _l680;
      }
      if (j_ < 1 || j_ > (*n_)) {
        goto _l680;
      }
      iw_[i_ - 1 + ((*n_)) * ((0))] = iw_[i_ - 1 + ((*n_)) * ((0))] + 1;
      iw_[j_ - 1 + ((*n_)) * ((1))] = iw_[j_ - 1 + ((*n_)) * ((1))] + 1;
    }
    goto _l90;
    _l70:;
    l_ = k_;
    a_[l_ - 1] = a_[la05ds_.lenu_ - 1];
    ind_[l_ - 1 + ((*ia_)) * ((0))] = ind_[la05ds_.lenu_ - 1 + ((*ia_)) * ((0))];
    ind_[l_ - 1 + ((*ia_)) * ((1))] = ind_[la05ds_.lenu_ - 1 + ((*ia_)) * ((1))];
    la05ds_.lenu_ = la05ds_.lenu_ - 1;
  }
  _l90:;
  la05ds_.lenl_ = 0;
  la05ds_.lrow_ = la05ds_.lenu_;
  la05ds_.lcol_ = la05ds_.lrow_;
  mcp_ = _max ((*n_) / 10, 20);
  la05ds_.ncp_ = 0;
  k_ = 1;
  for (ir_ = 1; ir_ <= (*n_); (ir_)++) {
    k_ = k_ + iw_[ir_ - 1 + ((*n_)) * ((1))];
    ip_[ir_ - 1 + ((*n_)) * ((1))] = k_;
    for (l_ = 1; l_ <= 2; (l_)++) {
      if (iw_[ir_ - 1 + ((*n_)) * ((l_ - 1))] <= 0) {
        goto _l700;
      }
    }
  }
  (void) _mc20as (n_, &la05ds_.lenu_, a_, &ind_[0 + ((*ia_)) * ((1))], ip_, &ind_[0 + ((*ia_)) * ((0))], &_k0);
  kl_ = la05ds_.lenu_;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    ir_ = (*n_) + 1 - ii_;
    kp_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      if (iw_[j_ - 1 + ((*n_)) * ((4))] == ir_) {
        goto _l660;
      }
      iw_[j_ - 1 + ((*n_)) * ((4))] = ir_;
      kr_ = ip_[j_ - 1 + ((*n_)) * ((1))] - 1;
      ip_[j_ - 1 + ((*n_)) * ((1))] = kr_;
      ind_[kr_ - 1 + ((*ia_)) * ((0))] = ir_;
    }
    kl_ = kp_ - 1;
  }
  for (l_ = 1; l_ <= 2; (l_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      (*nz_) = iw_[i_ - 1 + ((*n_)) * ((l_ - 1))];
      in_ = iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))];
      iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))] = i_;
      iw_[i_ - 1 + ((*n_)) * ((l_ + 6 - 1))] = in_;
      iw_[i_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = 0;
      if (in_ != 0) {
        iw_[in_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = i_;
      }
    }
  }
  for (ipv_ = 1; ipv_ <= (*n_); (ipv_)++) {
    jcost_ = (*n_) * (*n_);
    for ((*nz_) = 1; (*nz_) <= (*n_); ((*nz_))++) {
      if (jcost_ <= ($1_ = ((*nz_) - 1), $1_ * $1_)) {
        goto _l250;
      }
      j_ = iw_[(*nz_) - 1 + ((*n_)) * ((3))];
      for (idummy_ = 1; idummy_ <= (*n_); (idummy_)++) {
        if (j_ <= 0) {
          goto _l200;
        }
        kp_ = ip_[j_ - 1 + ((*n_)) * ((1))];
        kl_ = kp_ + iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
        for (k_ = kp_; k_ <= kl_; (k_)++) {
          i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
          kcost_ = ((*nz_) - 1) * (iw_[i_ - 1 + ((*n_)) * ((0))] - 1);
          if (kcost_ >= jcost_) {
            goto _l180;
          }
          if ((*nz_) == 1) {
            goto _l170;
          }
          amax_ = 0.0;
          k1_ = ip_[i_ - 1 + ((*n_)) * ((0))];
          k2_ = iw_[i_ - 1 + ((*n_)) * ((0))] + k1_ - 1;
          for (kk_ = k1_; kk_ <= k2_; (kk_)++) {
            amax_ = _max (amax_, _abs (a_[kk_ - 1]));
            if (ind_[kk_ - 1 + ((*ia_)) * ((1))] == j_) {
              kj_ = kk_;
            }
          }
          if (_abs (a_[kj_ - 1]) < amax_ * (*u_)) {
            goto _l180;
          }
          _l170:;
          jcost_ = kcost_;
          ipp_ = i_;
          jp_ = j_;
          if (jcost_ <= ($2_ = ((*nz_) - 1), $2_ * $2_)) {
            goto _l250;
          }
          _l180:;
        }
        j_ = iw_[j_ - 1 + ((*n_)) * ((7))];
      }
      _l200:;
      i_ = iw_[(*nz_) - 1 + ((*n_)) * ((2))];
      for (idummy_ = 1; idummy_ <= (*n_); (idummy_)++) {
        if (i_ <= 0) {
          goto _l240;
        }
        amax_ = 0.0;
        kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
        kl_ = kp_ + iw_[i_ - 1 + ((*n_)) * ((0))] - 1;
        for (k_ = kp_; k_ <= kl_; (k_)++) {
          amax_ = _max (_abs (a_[k_ - 1]), amax_);
        }
        au_ = amax_ * (*u_);
        for (k_ = kp_; k_ <= kl_; (k_)++) {
          if (_abs (a_[k_ - 1]) < au_) {
            goto _l220;
          }
          j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
          kcost_ = ((*nz_) - 1) * (iw_[j_ - 1 + ((*n_)) * ((1))] - 1);
          if (kcost_ >= jcost_) {
            goto _l220;
          }
          jcost_ = kcost_;
          ipp_ = i_;
          jp_ = j_;
          if (jcost_ <= ($3_ = ((*nz_) - 1), $3_ * $3_)) {
            goto _l250;
          }
          _l220:;
        }
        i_ = iw_[i_ - 1 + ((*n_)) * ((6))];
      }
      _l240:;
    }
    _l250:;
    kp_ = ip_[jp_ - 1 + ((*n_)) * ((1))];
    kl_ = iw_[jp_ - 1 + ((*n_)) * ((1))] + kp_ - 1;
    for (l_ = 1; l_ <= 2; (l_)++) {
      for (k_ = kp_; k_ <= kl_; (k_)++) {
        i_ = ind_[k_ - 1 + ((*ia_)) * ((l_ - 1))];
        il_ = iw_[i_ - 1 + ((*n_)) * ((l_ + 4 - 1))];
        in_ = iw_[i_ - 1 + ((*n_)) * ((l_ + 6 - 1))];
        if (il_ == 0) {
          goto _l260;
        }
        iw_[il_ - 1 + ((*n_)) * ((l_ + 6 - 1))] = in_;
        goto _l270;
        _l260:;
        (*nz_) = iw_[i_ - 1 + ((*n_)) * ((l_ - 1))];
        iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))] = in_;
        _l270:;
        if (in_ > 0) {
          iw_[in_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = il_;
        }
      }
      kp_ = ip_[ipp_ - 1 + ((*n_)) * ((0))];
      kl_ = kp_ + iw_[ipp_ - 1 + ((*n_)) * ((0))] - 1;
    }
    iw_[ipp_ - 1 + ((*n_)) * ((4))] = -ipv_;
    iw_[jp_ - 1 + ((*n_)) * ((5))] = -ipv_;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      kpc_ = ip_[j_ - 1 + ((*n_)) * ((1))];
      iw_[j_ - 1 + ((*n_)) * ((1))] = iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
      klc_ = kpc_ + iw_[j_ - 1 + ((*n_)) * ((1))];
      for (kc_ = kpc_; kc_ <= klc_; (kc_)++) {
        if (ipp_ == ind_[kc_ - 1 + ((*ia_)) * ((0))]) {
          goto _l310;
        }
      }
      _l310:;
      ind_[kc_ - 1 + ((*ia_)) * ((0))] = ind_[klc_ - 1 + ((*ia_)) * ((0))];
      ind_[klc_ - 1 + ((*ia_)) * ((0))] = 0;
      if (j_ == jp_) {
        kr_ = k_;
      }
    }
    au_ = a_[kr_ - 1];
    a_[kr_ - 1] = a_[kp_ - 1];
    a_[kp_ - 1] = au_;
    ind_[kr_ - 1 + ((*ia_)) * ((1))] = ind_[kp_ - 1 + ((*ia_)) * ((1))];
    ind_[kp_ - 1 + ((*ia_)) * ((1))] = jp_;
    nzc_ = iw_[jp_ - 1 + ((*n_)) * ((1))];
    if (nzc_ == 0) {
      goto _l550;
    }
    for (nc_ = 1; nc_ <= nzc_; (nc_)++) {
      kc_ = ip_[jp_ - 1 + ((*n_)) * ((1))] + nc_ - 1;
      ir_ = ind_[kc_ - 1 + ((*ia_)) * ((0))];
      kr_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
      krl_ = kr_ + iw_[ir_ - 1 + ((*n_)) * ((0))] - 1;
      for (knp_ = kr_; knp_ <= krl_; (knp_)++) {
        if (jp_ == ind_[knp_ - 1 + ((*ia_)) * ((1))]) {
          goto _l340;
        }
      }
      _l340:;
      am_ = a_[knp_ - 1];
      a_[knp_ - 1] = a_[kr_ - 1];
      a_[kr_ - 1] = am_;
      ind_[knp_ - 1 + ((*ia_)) * ((1))] = ind_[kr_ - 1 + ((*ia_)) * ((1))];
      ind_[kr_ - 1 + ((*ia_)) * ((1))] = jp_;
      am_ = -a_[kr_ - 1] / a_[kp_ - 1];
      if (la05ds_.lrow_ + iw_[ir_ - 1 + ((*n_)) * ((0))] + iw_[ipp_ - 1 + ((*n_)) * ((0))] + la05ds_.lenl_ <= (*ia_)) {
        goto _l350;
      }
      if (la05ds_.ncp_ >= mcp_ || la05ds_.lenu_ + iw_[ir_ - 1 + ((*n_)) * ((0))] + iw_[ipp_ - 1 + ((*n_)) * ((0))] + 
        la05ds_.lenl_ > (*ia_)) {
        goto _l710;
      }
      (void) _la05es (a_, &ind_[0 + ((*ia_)) * ((1))], ip_, n_, iw_, ia_, ($4_ = TRUE, &$4_));
      kp_ = ip_[ipp_ - 1 + ((*n_)) * ((0))];
      kr_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
      _l350:;
      krl_ = kr_ + iw_[ir_ - 1 + ((*n_)) * ((0))] - 1;
      kq_ = kp_ + 1;
      kpl_ = kp_ + iw_[ipp_ - 1 + ((*n_)) * ((0))] - 1;
      if (kq_ > kpl_) {
        goto _l370;
      }
      for (k_ = kq_; k_ <= kpl_; (k_)++) {
        j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
        w_[j_ - 1] = a_[k_ - 1];
      }
      _l370:;
      ip_[ir_ - 1 + ((*n_)) * ((0))] = la05ds_.lrow_ + 1;
      ind_[kr_ - 1 + ((*ia_)) * ((1))] = 0;
      kr_ = kr_ + 1;
      if (kr_ > krl_) {
        goto _l430;
      }
      for (ks_ = kr_; ks_ <= krl_; (ks_)++) {
        j_ = ind_[ks_ - 1 + ((*ia_)) * ((1))];
        au_ = a_[ks_ - 1] + am_ * w_[j_ - 1];
        ind_[ks_ - 1 + ((*ia_)) * ((1))] = 0;
        if (_abs (au_) <= la05ds_.small_) {
          goto _l380;
        }
        (*g_) = _max ((*g_), _abs (au_));
        la05ds_.lrow_ = la05ds_.lrow_ + 1;
        a_[la05ds_.lrow_ - 1] = au_;
        ind_[la05ds_.lrow_ - 1 + ((*ia_)) * ((1))] = j_;
        goto _l410;
        _l380:;
        la05ds_.lenu_ = la05ds_.lenu_ - 1;
        k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
        kl_ = k_ + iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
        iw_[j_ - 1 + ((*n_)) * ((1))] = kl_ - k_;
        for (kk_ = k_; kk_ <= kl_; (kk_)++) {
          if (ind_[kk_ - 1 + ((*ia_)) * ((0))] == ir_) {
            goto _l400;
          }
        }
        _l400:;
        ind_[kk_ - 1 + ((*ia_)) * ((0))] = ind_[kl_ - 1 + ((*ia_)) * ((0))];
        ind_[kl_ - 1 + ((*ia_)) * ((0))] = 0;
        _l410:;
        w_[j_ - 1] = 0.0;
      }
      _l430:;
      if (kq_ > kpl_) {
        goto _l520;
      }
      for (ks_ = kq_; ks_ <= kpl_; (ks_)++) {
        j_ = ind_[ks_ - 1 + ((*ia_)) * ((1))];
        au_ = am_ * w_[j_ - 1];
        if (_abs (au_) <= la05ds_.small_) {
          goto _l500;
        }
        la05ds_.lrow_ = la05ds_.lrow_ + 1;
        a_[la05ds_.lrow_ - 1] = au_;
        ind_[la05ds_.lrow_ - 1 + ((*ia_)) * ((1))] = j_;
        la05ds_.lenu_ = la05ds_.lenu_ + 1;
        (*nz_) = iw_[j_ - 1 + ((*n_)) * ((1))];
        k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
        kl_ = k_ + (*nz_) - 1;
        if ((*nz_) == 0) {
          goto _l460;
        }
        if (kl_ != la05ds_.lcol_) {
          goto _l440;
        }
        if (la05ds_.lcol_ + la05ds_.lenl_ >= (*ia_)) {
          goto _l460;
        }
        la05ds_.lcol_ = la05ds_.lcol_ + 1;
        goto _l450;
        _l440:;
        if (ind_[kl_ + 1 - 1 + ((*ia_)) * ((0))] != 0) {
          goto _l460;
        }
        _l450:;
        ind_[kl_ + 1 - 1 + ((*ia_)) * ((0))] = ir_;
        goto _l490;
        _l460:;
        if (la05ds_.lcol_ + la05ds_.lenl_ + (*nz_) + 1 < (*ia_)) {
          goto _l470;
        }
        if (la05ds_.ncp_ >= mcp_ || la05ds_.lenu_ + la05ds_.lenl_ + (*nz_) + 1 >= (*ia_)) {
          goto _l710;
        }
        (void) _la05es (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($5_ = FALSE, &$5_));
        k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
        kl_ = k_ + (*nz_) - 1;
        _l470:;
        ip_[j_ - 1 + ((*n_)) * ((1))] = la05ds_.lcol_ + 1;
        if (kl_ < k_) {
          goto _l485;
        }
        for (kk_ = k_; kk_ <= kl_; (kk_)++) {
          la05ds_.lcol_ = la05ds_.lcol_ + 1;
          ind_[la05ds_.lcol_ - 1 + ((*ia_)) * ((0))] = ind_[kk_ - 1 + ((*ia_)) * ((0))];
          ind_[kk_ - 1 + ((*ia_)) * ((0))] = 0;
        }
        _l485:;
        la05ds_.lcol_ = la05ds_.lcol_ + 1;
        ind_[la05ds_.lcol_ - 1 + ((*ia_)) * ((0))] = ir_;
        _l490:;
        (*g_) = _max ((*g_), _abs (au_));
        iw_[j_ - 1 + ((*n_)) * ((1))] = (*nz_) + 1;
        _l500:;
        w_[j_ - 1] = 0.0;
      }
      _l520:;
      iw_[ir_ - 1 + ((*n_)) * ((0))] = la05ds_.lrow_ + 1 - ip_[ir_ - 1 + ((*n_)) * ((0))];
      if (la05ds_.lenl_ + la05ds_.lcol_ + 1 <= (*ia_)) {
        goto _l530;
      }
      if (la05ds_.ncp_ >= mcp_) {
        goto _l710;
      }
      (void) _la05es (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($6_ = FALSE, &$6_));
      _l530:;
      k_ = (*ia_) - la05ds_.lenl_;
      la05ds_.lenl_ = la05ds_.lenl_ + 1;
      a_[k_ - 1] = am_;
      ind_[k_ - 1 + ((*ia_)) * ((0))] = ipp_;
      ind_[k_ - 1 + ((*ia_)) * ((1))] = ir_;
      la05ds_.lenu_ = la05ds_.lenu_ - 1;
    }
    _l550:;
    k1_ = ip_[jp_ - 1 + ((*n_)) * ((1))];
    k2_ = iw_[jp_ - 1 + ((*n_)) * ((1))] + k1_ - 1;
    iw_[jp_ - 1 + ((*n_)) * ((1))] = 0;
    for (l_ = 1; l_ <= 2; (l_)++) {
      if (k2_ < k1_) {
        goto _l570;
      }
      for (k_ = k1_; k_ <= k2_; (k_)++) {
        ir_ = ind_[k_ - 1 + ((*ia_)) * ((l_ - 1))];
        if (l_ == 1) {
          ind_[k_ - 1 + ((*ia_)) * ((l_ - 1))] = 0;
        }
        (*nz_) = iw_[ir_ - 1 + ((*n_)) * ((l_ - 1))];
        if ((*nz_) <= 0) {
          goto _l720;
        }
        in_ = iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))];
        iw_[ir_ - 1 + ((*n_)) * ((l_ + 6 - 1))] = in_;
        iw_[ir_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = 0;
        iw_[(*nz_) - 1 + ((*n_)) * ((l_ + 2 - 1))] = ir_;
        if (in_ != 0) {
          iw_[in_ - 1 + ((*n_)) * ((l_ + 4 - 1))] = ir_;
        }
      }
      _l570:;
      k1_ = ip_[ipp_ - 1 + ((*n_)) * ((0))] + 1;
      k2_ = iw_[ipp_ - 1 + ((*n_)) * ((0))] + k1_ - 2;
    }
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    j_ = -iw_[i_ - 1 + ((*n_)) * ((4))];
    iw_[j_ - 1 + ((*n_)) * ((2))] = i_;
    j_ = -iw_[i_ - 1 + ((*n_)) * ((5))];
    iw_[j_ - 1 + ((*n_)) * ((3))] = i_;
    iw_[i_ - 1 + ((*n_)) * ((1))] = 0;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    kl_ = iw_[i_ - 1 + ((*n_)) * ((0))] + kp_ - 1;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      iw_[j_ - 1 + ((*n_)) * ((1))] = iw_[j_ - 1 + ((*n_)) * ((1))] + 1;
    }
  }
  k_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    k_ = k_ + iw_[i_ - 1 + ((*n_)) * ((1))];
    ip_[i_ - 1 + ((*n_)) * ((1))] = k_;
  }
  la05ds_.lcol_ = k_ - 1;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    kl_ = iw_[i_ - 1 + ((*n_)) * ((0))] + kp_ - 1;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      kn_ = ip_[j_ - 1 + ((*n_)) * ((1))] - 1;
      ip_[j_ - 1 + ((*n_)) * ((1))] = kn_;
      ind_[kn_ - 1 + ((*ia_)) * ((0))] = i_;
    }
  }
  goto _l0;
  _l660:;
  if (la05ds_.lp_ > 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05as:452", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100330_[__fcnt] != NULL && $f_100330_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100330_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:452", 0));
      __fcnt += 3;
    }
    if ($f_100330_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100330_[__fcnt] != NULL && $f_100330_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100330_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:452", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100330_[__fcnt + 2], &ir_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:452", 0));
    __fcnt += 3;
    while ($f_100330_[__fcnt] != NULL && $f_100330_[__fcnt] == FMT_TEXT) {
      if ($f_100330_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100330_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:452", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05as:453", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:453", 0));
      __fcnt += 3;
    }
    if ($f_100331_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:453", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100331_[__fcnt + 2], &j_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:453", 0));
    __fcnt += 3;
    while ($f_100331_[__fcnt] != NULL && $f_100331_[__fcnt] == FMT_TEXT) {
      if ($f_100331_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100331_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:453", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_17, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, concat ($7_, _dc_2, _dc_3), 
    xern1_), _dc_4), xern2_), 511), $11_), ($12_ = -4, &$12_), &_k1);
  }
  (*g_) = -4.0;
  goto _l0;
  _l670:;
  if (la05ds_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_17, _dc_5, &_km1, &_k1);
  }
  (*g_) = -1.0;
  goto _l0;
  _l680:;
  if (la05ds_.lp_ > 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern0_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern0_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05as:467", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100340_[__fcnt] != NULL && $f_100340_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100340_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:467", 0));
      __fcnt += 3;
    }
    if ($f_100340_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100340_[__fcnt] != NULL && $f_100340_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100340_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:467", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100340_[__fcnt + 2], &k_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:467", 0));
    __fcnt += 3;
    while ($f_100340_[__fcnt] != NULL && $f_100340_[__fcnt] == FMT_TEXT) {
      if ($f_100340_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100340_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:467", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05as:468", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:468", 0));
      __fcnt += 3;
    }
    if ($f_100341_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:468", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100341_[__fcnt + 2], &i_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:468", 0));
    __fcnt += 3;
    while ($f_100341_[__fcnt] != NULL && $f_100341_[__fcnt] == FMT_TEXT) {
      if ($f_100341_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100341_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:468", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05as:469", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:469", 0));
      __fcnt += 3;
    }
    if ($f_100342_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:469", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100342_[__fcnt + 2], &j_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:469", 0));
    __fcnt += 3;
    while ($f_100342_[__fcnt] != NULL && $f_100342_[__fcnt] == FMT_TEXT) {
      if ($f_100342_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100342_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:469", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_17, (bufcpy ($18_, concat ($17_, concat ($16_, concat ($15_, concat ($14_, concat ($13_, 
    _dc_6, xern0_), _dc_7), xern1_), _dc_4), xern2_), 511), $18_), ($19_ = -3, &$19_), &_k1);
  }
  (*g_) = -3.0;
  goto _l0;
  _l700:;
  if (la05ds_.lp_ > 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05as:478", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:478", 0));
      __fcnt += 3;
    }
    if ($f_100348_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:478", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100348_[__fcnt + 2], &l_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:478", 0));
    __fcnt += 3;
    while ($f_100348_[__fcnt] != NULL && $f_100348_[__fcnt] == FMT_TEXT) {
      if ($f_100348_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100348_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:478", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_17, (bufcpy ($22_, concat ($21_, concat ($20_, _dc_8, _dc_9), xern1_), 127), $22_), ($23_ = 
    -2, &$23_), &_k1);
  }
  (*g_) = -2.0;
  goto _l0;
  _l710:;
  if (la05ds_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_17, _dc_10, ($24_ = -7, &$24_), &_k1);
  }
  (*g_) = -7.0;
  goto _l0;
  _l720:;
  ipv_ = ipv_ + 1;
  iw_[ipv_ - 1 + ((*n_)) * ((0))] = ir_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ii_ = -iw_[i_ - 1 + ((*n_)) * ((l_ + 4 - 1))];
    if (ii_ > 0) {
      iw_[ii_ - 1 + ((*n_)) * ((0))] = i_;
    }
  }
  if (la05ds_.lp_ > 0) {
    bufcpy (xern1_, _dc_11, 15);
    if (l_ == 2) {
      bufcpy (xern1_, _dc_12, 15);
    }
    (void) _xermsg (_dc_0, _dc_17, (bufcpy ($26_, concat ($25_, _dc_13, xern1_), 31), $26_), ($27_ = -5, &$27_), &_k1);
    _l740:;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05as:502", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100366_[__fcnt] != NULL && $f_100366_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100366_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:502", 0));
      __fcnt += 3;
    }
    if ($f_100366_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100366_[__fcnt] != NULL && $f_100366_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100366_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:502", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100366_[__fcnt + 2], &iw_[i_ - 1 + ((*n_)) * ((0))], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:502", 0));
    __fcnt += 3;
    while ($f_100366_[__fcnt] != NULL && $f_100366_[__fcnt] == FMT_TEXT) {
      if ($f_100366_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100366_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:502", 0));
      __fcnt += 3;
    }
    bufcpy (xern2_, _dc_14, 15);
    if (i_ + 1 <= ipv_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern2_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-harwell:la05as:504", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100368_[__fcnt] != NULL && $f_100368_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100368_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:504", 0));
        __fcnt += 3;
      }
      if ($f_100368_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100368_[__fcnt] != NULL && $f_100368_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100368_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:504", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100368_[__fcnt + 2], &iw_[i_ + 1 - 1 + ((*n_)) * ((0))], INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:504", 0));
      __fcnt += 3;
      while ($f_100368_[__fcnt] != NULL && $f_100368_[__fcnt] == FMT_TEXT) {
        if ($f_100368_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100368_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05as:504", 0));
        __fcnt += 3;
      }
    }
    (void) _xermsg (_dc_0, _dc_17, (bufcpy ($31_, concat ($30_, concat ($29_, concat ($28_, _dc_15, xern1_), _dc_16), 
    xern2_), 255), $31_), ($32_ = -5, &$32_), &_k1);
    i_ = i_ + 2;
    if (i_ <= ipv_) {
      goto _l740;
    }
  }
  (*g_) = -5.0;
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _la05bd (real_8 _p_ a_, int_4 _p_ ind_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, real_8 _p_ w_, 
real_8 _p_ g_, real_8 _p_ b_, logical_4 _p_ trans_)
{
  static int_4 kll_, l1_, kk_, k_, i_, j_, n1_, ii_, kp_, nz_, kl_, k2_, kpc_;
  static real_8 am_;
  int_4 $0_, $1_;
  if ((*g_) < 0.0e0) {
    goto _l130;
  }
  kll_ = (*ia_) - la05dd_.lenl_ + 1;
  if ((*trans_)) {
    goto _l80;
  }
  if (la05dd_.lenl_ <= 0) {
    goto _l20;
  }
  l1_ = (*ia_) + 1;
  for (kk_ = 1; kk_ <= la05dd_.lenl_; (kk_)++) {
    k_ = l1_ - kk_;
    i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
    if (b_[i_ - 1] == 0.0e0) {
      goto _l10;
    }
    j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    b_[j_ - 1] = b_[j_ - 1] + a_[k_ - 1] * b_[i_ - 1];
    _l10:;
  }
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = b_[i_ - 1];
    b_[i_ - 1] = 0.0;
  }
  n1_ = (*n_) + 1;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = n1_ - ii_;
    i_ = iw_[i_ - 1 + ((*n_)) * ((2))];
    am_ = w_[i_ - 1];
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    if (kp_ > 0) {
      goto _l50;
    }
    kp_ = -kp_;
    ip_[i_ - 1 + ((*n_)) * ((0))] = kp_;
    nz_ = iw_[i_ - 1 + ((*n_)) * ((0))];
    kl_ = kp_ - 1 + nz_;
    k2_ = kp_ + 1;
    for (k_ = k2_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      am_ = am_ - a_[k_ - 1] * b_[j_ - 1];
    }
    _l50:;
    if (am_ == 0.0) {
      goto _l70;
    }
    j_ = ind_[kp_ - 1 + ((*ia_)) * ((1))];
    b_[j_ - 1] = am_ / a_[kp_ - 1];
    kpc_ = ip_[j_ - 1 + ((*n_)) * ((1))];
    kl_ = iw_[j_ - 1 + ((*n_)) * ((1))] + kpc_ - 1;
    if (kl_ == kpc_) {
      goto _l70;
    }
    k2_ = kpc_ + 1;
    for (k_ = k2_; k_ <= kl_; (k_)++) {
      i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
      ip_[i_ - 1 + ((*n_)) * ((0))] = -_abs (ip_[i_ - 1 + ((*n_)) * ((0))]);
    }
    _l70:;
  }
  goto _l140;
  _l80:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = b_[i_ - 1];
    b_[i_ - 1] = 0.0;
  }
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((3))];
    am_ = w_[i_ - 1];
    if (am_ == 0.0e0) {
      goto _l110;
    }
    j_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    kp_ = ip_[j_ - 1 + ((*n_)) * ((0))];
    am_ = am_ / a_[kp_ - 1];
    b_[j_ - 1] = am_;
    kl_ = iw_[j_ - 1 + ((*n_)) * ((0))] + kp_ - 1;
    if (kp_ == kl_) {
      goto _l110;
    }
    k2_ = kp_ + 1;
    for (k_ = k2_; k_ <= kl_; (k_)++) {
      i_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      w_[i_ - 1] = w_[i_ - 1] - am_ * a_[k_ - 1];
    }
    _l110:;
  }
  if (kll_ > (*ia_)) {
    goto _l0;
  }
  for (k_ = kll_; k_ <= (*ia_); (k_)++) {
    j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    if (b_[j_ - 1] == 0.0e0) {
      goto _l120;
    }
    i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
    b_[i_ - 1] = b_[i_ - 1] + a_[k_ - 1] * b_[j_ - 1];
    _l120:;
  }
  goto _l140;
  _l130:;
  (void) _xsetun (&la05dd_.lp_);
  if (la05dd_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_18, _dc_19, ($0_ = -8, &$0_), ($1_ = 2, &$1_));
  }
  _l140:;
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _la05bs (real_4 _p_ a_, int_4 _p_ ind_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, real_4 _p_ w_, 
real_4 _p_ g_, real_4 _p_ b_, logical_4 _p_ trans_)
{
  static int_4 kll_, l1_, kk_, k_, i_, j_, n1_, ii_, kp_, nz_, kl_, k2_, kpc_;
  static real_4 am_;
  int_4 $0_, $1_;
  if ((*g_) < 0.0) {
    goto _l130;
  }
  kll_ = (*ia_) - la05ds_.lenl_ + 1;
  if ((*trans_)) {
    goto _l80;
  }
  if (la05ds_.lenl_ <= 0) {
    goto _l20;
  }
  l1_ = (*ia_) + 1;
  for (kk_ = 1; kk_ <= la05ds_.lenl_; (kk_)++) {
    k_ = l1_ - kk_;
    i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
    if (b_[i_ - 1] == 0.0) {
      goto _l10;
    }
    j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    b_[j_ - 1] = b_[j_ - 1] + a_[k_ - 1] * b_[i_ - 1];
    _l10:;
  }
  _l20:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = b_[i_ - 1];
    b_[i_ - 1] = 0.0;
  }
  n1_ = (*n_) + 1;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = n1_ - ii_;
    i_ = iw_[i_ - 1 + ((*n_)) * ((2))];
    am_ = w_[i_ - 1];
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    if (kp_ > 0) {
      goto _l50;
    }
    kp_ = -kp_;
    ip_[i_ - 1 + ((*n_)) * ((0))] = kp_;
    nz_ = iw_[i_ - 1 + ((*n_)) * ((0))];
    kl_ = kp_ - 1 + nz_;
    k2_ = kp_ + 1;
    for (k_ = k2_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      am_ = am_ - a_[k_ - 1] * b_[j_ - 1];
    }
    _l50:;
    if (am_ == 0.0) {
      goto _l70;
    }
    j_ = ind_[kp_ - 1 + ((*ia_)) * ((1))];
    b_[j_ - 1] = am_ / a_[kp_ - 1];
    kpc_ = ip_[j_ - 1 + ((*n_)) * ((1))];
    kl_ = iw_[j_ - 1 + ((*n_)) * ((1))] + kpc_ - 1;
    if (kl_ == kpc_) {
      goto _l70;
    }
    k2_ = kpc_ + 1;
    for (k_ = k2_; k_ <= kl_; (k_)++) {
      i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
      ip_[i_ - 1 + ((*n_)) * ((0))] = -_abs (ip_[i_ - 1 + ((*n_)) * ((0))]);
    }
    _l70:;
  }
  goto _l140;
  _l80:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = b_[i_ - 1];
    b_[i_ - 1] = 0.0;
  }
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((3))];
    am_ = w_[i_ - 1];
    if (am_ == 0.0) {
      goto _l110;
    }
    j_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    kp_ = ip_[j_ - 1 + ((*n_)) * ((0))];
    am_ = am_ / a_[kp_ - 1];
    b_[j_ - 1] = am_;
    kl_ = iw_[j_ - 1 + ((*n_)) * ((0))] + kp_ - 1;
    if (kp_ == kl_) {
      goto _l110;
    }
    k2_ = kp_ + 1;
    for (k_ = k2_; k_ <= kl_; (k_)++) {
      i_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      w_[i_ - 1] = w_[i_ - 1] - am_ * a_[k_ - 1];
    }
    _l110:;
  }
  if (kll_ > (*ia_)) {
    goto _l0;
  }
  for (k_ = kll_; k_ <= (*ia_); (k_)++) {
    j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    if (b_[j_ - 1] == 0.0) {
      goto _l120;
    }
    i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
    b_[i_ - 1] = b_[i_ - 1] + a_[k_ - 1] * b_[j_ - 1];
    _l120:;
  }
  goto _l140;
  _l130:;
  (void) _xsetun (&la05ds_.lp_);
  if (la05ds_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_20, _dc_19, ($0_ = -8, &$0_), ($1_ = 2, &$1_));
  }
  _l140:;
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _la05cd (real_8 _p_ a_, int_4 _p_ ind_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, real_8 _p_ w_, 
real_8 _p_ g_, real_8 _p_ u_, int_4 _p_ mm_)
{
  static int_4 jm_, mcp_, kp_, im_, kl_, k_, i_, kr_, nz_, krl_, km_, ii_, m_, last_, kpl_, ins_, m1_, j_, ij_, last1_, 
  jns_, is_, l_, knp_, in_, last2_, ir_, ipp_, jp_, kj_, kq_, ks_, kk_;
  static real_8 am_, au_;
  static char_15 xern1_;
  int_4 $2_, __fcnt, __rc, $9_, $10_, $11_, $12_;
  logical_4 $0_, $1_, $3_, $4_, $5_;
  char_127 $6_;
  char_255 $7_, $8_;
  static FORMAT $f_100306_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  (void) _xsetun (&la05dd_.lp_);
  if ((*g_) < 0.0e0) {
    goto _l620;
  }
  jm_ = (*mm_);
  mcp_ = la05dd_.ncp_ + 20;
  la05dd_.lenu_ = la05dd_.lenu_ - iw_[jm_ - 1 + ((*n_)) * ((1))];
  kp_ = ip_[jm_ - 1 + ((*n_)) * ((1))];
  im_ = ind_[kp_ - 1 + ((*ia_)) * ((0))];
  kl_ = kp_ + iw_[jm_ - 1 + ((*n_)) * ((1))] - 1;
  iw_[jm_ - 1 + ((*n_)) * ((1))] = 0;
  for (k_ = kp_; k_ <= kl_; (k_)++) {
    i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
    ind_[k_ - 1 + ((*ia_)) * ((0))] = 0;
    kr_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    nz_ = iw_[i_ - 1 + ((*n_)) * ((0))] - 1;
    iw_[i_ - 1 + ((*n_)) * ((0))] = nz_;
    krl_ = kr_ + nz_;
    for (km_ = kr_; km_ <= krl_; (km_)++) {
      if (ind_[km_ - 1 + ((*ia_)) * ((1))] == jm_) {
        goto _l20;
      }
    }
    _l20:;
    a_[km_ - 1] = a_[krl_ - 1];
    ind_[km_ - 1 + ((*ia_)) * ((1))] = ind_[krl_ - 1 + ((*ia_)) * ((1))];
    ind_[krl_ - 1 + ((*ia_)) * ((1))] = 0;
  }
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    if (i_ == im_) {
      m_ = ii_;
    }
    if (_abs (w_[i_ - 1]) <= la05dd_.small_) {
      goto _l100;
    }
    la05dd_.lenu_ = la05dd_.lenu_ + 1;
    last_ = ii_;
    if (la05dd_.lcol_ + la05dd_.lenl_ < (*ia_)) {
      goto _l40;
    }
    if (la05dd_.ncp_ >= mcp_ || la05dd_.lenl_ + la05dd_.lenu_ >= (*ia_)) {
      goto _l610;
    }
    (void) _la05ed (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($0_ = FALSE, &$0_));
    _l40:;
    la05dd_.lcol_ = la05dd_.lcol_ + 1;
    nz_ = iw_[jm_ - 1 + ((*n_)) * ((1))];
    if (nz_ == 0) {
      ip_[jm_ - 1 + ((*n_)) * ((1))] = la05dd_.lcol_;
    }
    iw_[jm_ - 1 + ((*n_)) * ((1))] = nz_ + 1;
    ind_[la05dd_.lcol_ - 1 + ((*ia_)) * ((0))] = i_;
    nz_ = iw_[i_ - 1 + ((*n_)) * ((0))];
    kpl_ = ip_[i_ - 1 + ((*n_)) * ((0))] + nz_;
    if (kpl_ > la05dd_.lrow_) {
      goto _l50;
    }
    if (ind_[kpl_ - 1 + ((*ia_)) * ((1))] == 0) {
      goto _l90;
    }
    _l50:;
    if (la05dd_.lenl_ + la05dd_.lrow_ + nz_ < (*ia_)) {
      goto _l60;
    }
    if (la05dd_.ncp_ >= mcp_ || la05dd_.lenl_ + la05dd_.lenu_ + nz_ >= (*ia_)) {
      goto _l610;
    }
    (void) _la05ed (a_, &ind_[0 + ((*ia_)) * ((1))], ip_, n_, iw_, ia_, ($1_ = TRUE, &$1_));
    _l60:;
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    ip_[i_ - 1 + ((*n_)) * ((0))] = la05dd_.lrow_ + 1;
    if (nz_ == 0) {
      goto _l80;
    }
    kpl_ = kp_ + nz_ - 1;
    for (k_ = kp_; k_ <= kpl_; (k_)++) {
      la05dd_.lrow_ = la05dd_.lrow_ + 1;
      a_[la05dd_.lrow_ - 1] = a_[k_ - 1];
      ind_[la05dd_.lrow_ - 1 + ((*ia_)) * ((1))] = ind_[k_ - 1 + ((*ia_)) * ((1))];
      ind_[k_ - 1 + ((*ia_)) * ((1))] = 0;
    }
    _l80:;
    la05dd_.lrow_ = la05dd_.lrow_ + 1;
    kpl_ = la05dd_.lrow_;
    _l90:;
    iw_[i_ - 1 + ((*n_)) * ((0))] = nz_ + 1;
    a_[kpl_ - 1] = w_[i_ - 1];
    ind_[kpl_ - 1 + ((*ia_)) * ((1))] = jm_;
    _l100:;
    w_[i_ - 1] = 0.0;
  }
  if (iw_[im_ - 1 + ((*n_)) * ((0))] == 0 || iw_[jm_ - 1 + ((*n_)) * ((1))] == 0 || m_ > last_) {
    goto _l590;
  }
  ins_ = m_;
  m1_ = m_;
  w_[jm_ - 1] = 1.0;
  for (ii_ = m_; ii_ <= last_; (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    j_ = iw_[ii_ - 1 + ((*n_)) * ((3))];
    if (w_[j_ - 1] == 0.0) {
      goto _l130;
    }
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    kl_ = kp_ + iw_[i_ - 1 + ((*n_)) * ((0))] - 1;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      w_[j_ - 1] = 1.0;
    }
    iw_[ins_ - 1 + ((*n_)) * ((3))] = i_;
    ins_ = ins_ + 1;
    goto _l140;
    _l130:;
    iw_[m1_ - 1 + ((*n_)) * ((2))] = i_;
    m1_ = m1_ + 1;
    _l140:;
  }
  ij_ = m_ + 1;
  for (ii_ = m1_; ii_ <= last_ - 1; (ii_)++) {
    iw_[ii_ - 1 + ((*n_)) * ((2))] = iw_[ij_ - 1 + ((*n_)) * ((3))];
    ij_ = ij_ + 1;
  }
  iw_[last_ - 1 + ((*n_)) * ((2))] = im_;
  last1_ = last_;
  jns_ = last_;
  w_[im_ - 1] = 2.0;
  j_ = jm_;
  for (ij_ = m1_; ij_ <= last_; (ij_)++) {
    ii_ = last_ + m1_ - ij_;
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    if (w_[i_ - 1] != 2.0e0) {
      goto _l170;
    }
    k_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    if (ii_ != last_) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    }
    kp_ = ip_[j_ - 1 + ((*n_)) * ((1))];
    kl_ = kp_ + iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
    iw_[jns_ - 1 + ((*n_)) * ((3))] = i_;
    jns_ = jns_ - 1;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
      w_[i_ - 1] = 2.0;
    }
    goto _l180;
    _l170:;
    iw_[last1_ - 1 + ((*n_)) * ((2))] = i_;
    last1_ = last1_ - 1;
    _l180:;
  }
  for (ii_ = m1_; ii_ <= last1_; (ii_)++) {
    jns_ = jns_ + 1;
    i_ = iw_[jns_ - 1 + ((*n_)) * ((3))];
    w_[i_ - 1] = 3.0;
    iw_[ii_ - 1 + ((*n_)) * ((2))] = i_;
  }
  for (ii_ = m1_; ii_ <= last1_; (ii_)++) {
    kp_ = ip_[jm_ - 1 + ((*n_)) * ((1))];
    kl_ = kp_ + iw_[jm_ - 1 + ((*n_)) * ((1))] - 1;
    is_ = 0;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      l_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
      if (w_[l_ - 1] != 3.0e0) {
        goto _l200;
      }
      if (is_ != 0) {
        goto _l240;
      }
      i_ = l_;
      knp_ = k_;
      is_ = 1;
      _l200:;
    }
    if (is_ == 0) {
      goto _l590;
    }
    ind_[knp_ - 1 + ((*ia_)) * ((0))] = ind_[kp_ - 1 + ((*ia_)) * ((0))];
    ind_[kp_ - 1 + ((*ia_)) * ((0))] = i_;
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    for (k_ = kp_; k_ <= (*ia_); (k_)++) {
      if (ind_[k_ - 1 + ((*ia_)) * ((1))] == jm_) {
        goto _l220;
      }
    }
    _l220:;
    am_ = a_[kp_ - 1];
    a_[kp_ - 1] = a_[k_ - 1];
    a_[k_ - 1] = am_;
    ind_[k_ - 1 + ((*ia_)) * ((1))] = ind_[kp_ - 1 + ((*ia_)) * ((1))];
    ind_[kp_ - 1 + ((*ia_)) * ((1))] = jm_;
    jm_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    iw_[ii_ - 1 + ((*n_)) * ((3))] = i_;
    w_[i_ - 1] = 2.0;
  }
  ii_ = last1_;
  goto _l260;
  _l240:;
  in_ = m1_;
  for (ij_ = ii_; ij_ <= last1_; (ij_)++) {
    iw_[ij_ - 1 + ((*n_)) * ((3))] = iw_[in_ - 1 + ((*n_)) * ((2))];
    in_ = in_ + 1;
  }
  _l260:;
  last2_ = last1_ - 1;
  if (m1_ == last1_) {
    goto _l570;
  }
  for (i_ = m1_; i_ <= last2_; (i_)++) {
    iw_[i_ - 1 + ((*n_)) * ((2))] = iw_[i_ - 1 + ((*n_)) * ((3))];
  }
  m1_ = ii_;
  if (m1_ == last1_) {
    goto _l570;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = 0.0;
  }
  ir_ = iw_[last1_ - 1 + ((*n_)) * ((2))];
  for (ii_ = m1_; ii_ <= last1_; (ii_)++) {
    ipp_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    kp_ = ip_[ipp_ - 1 + ((*n_)) * ((0))];
    kr_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
    jp_ = ind_[kp_ - 1 + ((*ia_)) * ((1))];
    if (ii_ == last1_) {
      jp_ = jm_;
    }
    krl_ = kr_ + iw_[ir_ - 1 + ((*n_)) * ((0))] - 1;
    for (knp_ = kr_; knp_ <= krl_; (knp_)++) {
      if (jp_ == ind_[knp_ - 1 + ((*ia_)) * ((1))]) {
        goto _l300;
      }
    }
    $2_ = ii_ - last1_;
    if ($2_ < 0) {
      goto _l560;
    } else if ($2_ == 0) {
      goto _l590;
    } else {
      goto _l560;
    }
    _l300:;
    am_ = a_[knp_ - 1];
    a_[knp_ - 1] = a_[kr_ - 1];
    a_[kr_ - 1] = am_;
    ind_[knp_ - 1 + ((*ia_)) * ((1))] = ind_[kr_ - 1 + ((*ia_)) * ((1))];
    ind_[kr_ - 1 + ((*ia_)) * ((1))] = jp_;
    if (ii_ == last1_) {
      goto _l310;
    }
    if (_abs (a_[kp_ - 1]) < (*u_) * _abs (am_)) {
      goto _l310;
    }
    if (_abs (am_) < (*u_) * _abs (a_[kp_ - 1])) {
      goto _l340;
    }
    if (iw_[ipp_ - 1 + ((*n_)) * ((0))] <= iw_[ir_ - 1 + ((*n_)) * ((0))]) {
      goto _l340;
    }
    _l310:;
    iw_[last1_ - 1 + ((*n_)) * ((2))] = ipp_;
    iw_[ii_ - 1 + ((*n_)) * ((2))] = ir_;
    ir_ = ipp_;
    ipp_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    k_ = kr_;
    kr_ = kp_;
    kp_ = k_;
    kj_ = ip_[jp_ - 1 + ((*n_)) * ((1))];
    for (k_ = kj_; k_ <= (*ia_); (k_)++) {
      if (ind_[k_ - 1 + ((*ia_)) * ((0))] == ipp_) {
        goto _l330;
      }
    }
    _l330:;
    ind_[k_ - 1 + ((*ia_)) * ((0))] = ind_[kj_ - 1 + ((*ia_)) * ((0))];
    ind_[kj_ - 1 + ((*ia_)) * ((0))] = ipp_;
    _l340:;
    if (a_[kp_ - 1] == 0.0e0) {
      goto _l590;
    }
    if (ii_ == last1_) {
      goto _l560;
    }
    am_ = -a_[kr_ - 1] / a_[kp_ - 1];
    if (la05dd_.lrow_ + iw_[ir_ - 1 + ((*n_)) * ((0))] + iw_[ipp_ - 1 + ((*n_)) * ((0))] + la05dd_.lenl_ <= (*ia_)) {
      goto _l350;
    }
    if (la05dd_.ncp_ >= mcp_ || la05dd_.lenu_ + iw_[ir_ - 1 + ((*n_)) * ((0))] + iw_[ipp_ - 1 + ((*n_)) * ((0))] + 
      la05dd_.lenl_ > (*ia_)) {
      goto _l610;
    }
    (void) _la05ed (a_, &ind_[0 + ((*ia_)) * ((1))], ip_, n_, iw_, ia_, ($3_ = TRUE, &$3_));
    kp_ = ip_[ipp_ - 1 + ((*n_)) * ((0))];
    kr_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
    _l350:;
    krl_ = kr_ + iw_[ir_ - 1 + ((*n_)) * ((0))] - 1;
    kq_ = kp_ + 1;
    kpl_ = kp_ + iw_[ipp_ - 1 + ((*n_)) * ((0))] - 1;
    if (kq_ > kpl_) {
      goto _l370;
    }
    for (k_ = kq_; k_ <= kpl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      w_[j_ - 1] = a_[k_ - 1];
    }
    _l370:;
    ip_[ir_ - 1 + ((*n_)) * ((0))] = la05dd_.lrow_ + 1;
    ind_[kr_ - 1 + ((*ia_)) * ((1))] = 0;
    kr_ = kr_ + 1;
    if (kr_ > krl_) {
      goto _l430;
    }
    for (ks_ = kr_; ks_ <= krl_; (ks_)++) {
      j_ = ind_[ks_ - 1 + ((*ia_)) * ((1))];
      au_ = a_[ks_ - 1] + am_ * w_[j_ - 1];
      ind_[ks_ - 1 + ((*ia_)) * ((1))] = 0;
      if (_abs (au_) <= la05dd_.small_) {
        goto _l380;
      }
      (*g_) = _max ((*g_), _abs (au_));
      la05dd_.lrow_ = la05dd_.lrow_ + 1;
      a_[la05dd_.lrow_ - 1] = au_;
      ind_[la05dd_.lrow_ - 1 + ((*ia_)) * ((1))] = j_;
      goto _l410;
      _l380:;
      la05dd_.lenu_ = la05dd_.lenu_ - 1;
      k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
      kl_ = k_ + iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
      iw_[j_ - 1 + ((*n_)) * ((1))] = kl_ - k_;
      for (kk_ = k_; kk_ <= kl_; (kk_)++) {
        if (ind_[kk_ - 1 + ((*ia_)) * ((0))] == ir_) {
          goto _l400;
        }
      }
      _l400:;
      ind_[kk_ - 1 + ((*ia_)) * ((0))] = ind_[kl_ - 1 + ((*ia_)) * ((0))];
      ind_[kl_ - 1 + ((*ia_)) * ((0))] = 0;
      _l410:;
      w_[j_ - 1] = 0.0;
    }
    _l430:;
    if (kq_ > kpl_) {
      goto _l520;
    }
    for (ks_ = kq_; ks_ <= kpl_; (ks_)++) {
      j_ = ind_[ks_ - 1 + ((*ia_)) * ((1))];
      au_ = am_ * w_[j_ - 1];
      if (_abs (au_) <= la05dd_.small_) {
        goto _l500;
      }
      la05dd_.lrow_ = la05dd_.lrow_ + 1;
      a_[la05dd_.lrow_ - 1] = au_;
      ind_[la05dd_.lrow_ - 1 + ((*ia_)) * ((1))] = j_;
      la05dd_.lenu_ = la05dd_.lenu_ + 1;
      nz_ = iw_[j_ - 1 + ((*n_)) * ((1))];
      k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
      kl_ = k_ + nz_ - 1;
      if (kl_ != la05dd_.lcol_) {
        goto _l440;
      }
      if (la05dd_.lcol_ + la05dd_.lenl_ >= (*ia_)) {
        goto _l460;
      }
      la05dd_.lcol_ = la05dd_.lcol_ + 1;
      goto _l450;
      _l440:;
      if (ind_[kl_ + 1 - 1 + ((*ia_)) * ((0))] != 0) {
        goto _l460;
      }
      _l450:;
      ind_[kl_ + 1 - 1 + ((*ia_)) * ((0))] = ir_;
      goto _l490;
      _l460:;
      if (la05dd_.lcol_ + la05dd_.lenl_ + nz_ + 1 < (*ia_)) {
        goto _l470;
      }
      if (la05dd_.ncp_ >= mcp_ || la05dd_.lenu_ + la05dd_.lenl_ + nz_ + 1 >= (*ia_)) {
        goto _l610;
      }
      (void) _la05ed (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($4_ = FALSE, &$4_));
      k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
      kl_ = k_ + nz_ - 1;
      _l470:;
      ip_[j_ - 1 + ((*n_)) * ((1))] = la05dd_.lcol_ + 1;
      for (kk_ = k_; kk_ <= kl_; (kk_)++) {
        la05dd_.lcol_ = la05dd_.lcol_ + 1;
        ind_[la05dd_.lcol_ - 1 + ((*ia_)) * ((0))] = ind_[kk_ - 1 + ((*ia_)) * ((0))];
        ind_[kk_ - 1 + ((*ia_)) * ((0))] = 0;
      }
      la05dd_.lcol_ = la05dd_.lcol_ + 1;
      ind_[la05dd_.lcol_ - 1 + ((*ia_)) * ((0))] = ir_;
      _l490:;
      (*g_) = _max ((*g_), _abs (au_));
      iw_[j_ - 1 + ((*n_)) * ((1))] = nz_ + 1;
      _l500:;
      w_[j_ - 1] = 0.0;
    }
    _l520:;
    iw_[ir_ - 1 + ((*n_)) * ((0))] = la05dd_.lrow_ + 1 - ip_[ir_ - 1 + ((*n_)) * ((0))];
    if (la05dd_.lenl_ + la05dd_.lcol_ + 1 <= (*ia_)) {
      goto _l530;
    }
    if (la05dd_.ncp_ >= mcp_) {
      goto _l610;
    }
    (void) _la05ed (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($5_ = FALSE, &$5_));
    _l530:;
    k_ = (*ia_) - la05dd_.lenl_;
    la05dd_.lenl_ = la05dd_.lenl_ + 1;
    a_[k_ - 1] = am_;
    ind_[k_ - 1 + ((*ia_)) * ((0))] = ipp_;
    ind_[k_ - 1 + ((*ia_)) * ((1))] = ir_;
    kp_ = ip_[jp_ - 1 + ((*n_)) * ((1))];
    nz_ = iw_[jp_ - 1 + ((*n_)) * ((1))] - 1;
    kl_ = kp_ + nz_;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      if (ind_[k_ - 1 + ((*ia_)) * ((0))] == ir_) {
        goto _l550;
      }
    }
    _l550:;
    ind_[k_ - 1 + ((*ia_)) * ((0))] = ind_[kl_ - 1 + ((*ia_)) * ((0))];
    iw_[jp_ - 1 + ((*n_)) * ((1))] = nz_;
    ind_[kl_ - 1 + ((*ia_)) * ((0))] = 0;
    la05dd_.lenu_ = la05dd_.lenu_ - 1;
    _l560:;
  }
  _l570:;
  for (ii_ = m_; ii_ <= last_; (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    k_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    iw_[ii_ - 1 + ((*n_)) * ((3))] = j_;
  }
  goto _l0;
  _l590:;
  if (la05dd_.lp_ > 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05cd:399", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05cd:399", 0));
      __fcnt += 3;
    }
    if ($f_100306_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05cd:399", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100306_[__fcnt + 2], &(*mm_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05cd:399", 0));
    __fcnt += 3;
    while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
      if ($f_100306_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05cd:399", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_21, (bufcpy ($8_, concat ($7_, concat ($6_, _dc_22, _dc_23), xern1_), 255), $8_), ($9_ = -6, 
    &$9_), &_k1);
  }
  (*g_) = -6.0;
  goto _l0;
  _l610:;
  if (la05dd_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_21, _dc_10, ($10_ = -7, &$10_), &_k1);
  }
  (*g_) = -7.0;
  goto _l0;
  _l620:;
  if (la05dd_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_21, _dc_19, ($11_ = -8, &$11_), ($12_ = 2, &$12_));
  }
  (*g_) = -8.0;
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _la05cs (real_4 _p_ a_, int_4 _p_ ind_, int_4 _p_ ia_, int_4 _p_ n_, int_4 _p_ ip_, int_4 _p_ iw_, real_4 _p_ w_, 
real_4 _p_ g_, real_4 _p_ u_, int_4 _p_ mm_)
{
  static int_4 jm_, mcp_, kp_, im_, kl_, k_, i_, kr_, nz_, krl_, km_, ii_, m_, last_, kpl_, ins_, m1_, j_, ij_, last1_, 
  jns_, is_, l_, knp_, in_, last2_, ir_, ipp_, jp_, kj_, kq_, ks_, kk_;
  static real_4 am_, au_;
  static char_15 xern1_;
  int_4 $2_, __fcnt, __rc, $9_, $10_, $11_, $12_;
  logical_4 $0_, $1_, $3_, $4_, $5_;
  char_127 $6_;
  char_255 $7_, $8_;
  static FORMAT $f_100306_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  (void) _xsetun (&la05ds_.lp_);
  if ((*g_) < 0.0e0) {
    goto _l620;
  }
  jm_ = (*mm_);
  mcp_ = la05ds_.ncp_ + 20;
  la05ds_.lenu_ = la05ds_.lenu_ - iw_[jm_ - 1 + ((*n_)) * ((1))];
  kp_ = ip_[jm_ - 1 + ((*n_)) * ((1))];
  im_ = ind_[kp_ - 1 + ((*ia_)) * ((0))];
  kl_ = kp_ + iw_[jm_ - 1 + ((*n_)) * ((1))] - 1;
  iw_[jm_ - 1 + ((*n_)) * ((1))] = 0;
  for (k_ = kp_; k_ <= kl_; (k_)++) {
    i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
    ind_[k_ - 1 + ((*ia_)) * ((0))] = 0;
    kr_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    nz_ = iw_[i_ - 1 + ((*n_)) * ((0))] - 1;
    iw_[i_ - 1 + ((*n_)) * ((0))] = nz_;
    krl_ = kr_ + nz_;
    for (km_ = kr_; km_ <= krl_; (km_)++) {
      if (ind_[km_ - 1 + ((*ia_)) * ((1))] == jm_) {
        goto _l20;
      }
    }
    _l20:;
    a_[km_ - 1] = a_[krl_ - 1];
    ind_[km_ - 1 + ((*ia_)) * ((1))] = ind_[krl_ - 1 + ((*ia_)) * ((1))];
    ind_[krl_ - 1 + ((*ia_)) * ((1))] = 0;
  }
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    if (i_ == im_) {
      m_ = ii_;
    }
    if (_abs (w_[i_ - 1]) <= la05ds_.small_) {
      goto _l100;
    }
    la05ds_.lenu_ = la05ds_.lenu_ + 1;
    last_ = ii_;
    if (la05ds_.lcol_ + la05ds_.lenl_ < (*ia_)) {
      goto _l40;
    }
    if (la05ds_.ncp_ >= mcp_ || la05ds_.lenl_ + la05ds_.lenu_ >= (*ia_)) {
      goto _l610;
    }
    (void) _la05es (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($0_ = FALSE, &$0_));
    _l40:;
    la05ds_.lcol_ = la05ds_.lcol_ + 1;
    nz_ = iw_[jm_ - 1 + ((*n_)) * ((1))];
    if (nz_ == 0) {
      ip_[jm_ - 1 + ((*n_)) * ((1))] = la05ds_.lcol_;
    }
    iw_[jm_ - 1 + ((*n_)) * ((1))] = nz_ + 1;
    ind_[la05ds_.lcol_ - 1 + ((*ia_)) * ((0))] = i_;
    nz_ = iw_[i_ - 1 + ((*n_)) * ((0))];
    kpl_ = ip_[i_ - 1 + ((*n_)) * ((0))] + nz_;
    if (kpl_ > la05ds_.lrow_) {
      goto _l50;
    }
    if (ind_[kpl_ - 1 + ((*ia_)) * ((1))] == 0) {
      goto _l90;
    }
    _l50:;
    if (la05ds_.lenl_ + la05ds_.lrow_ + nz_ < (*ia_)) {
      goto _l60;
    }
    if (la05ds_.ncp_ >= mcp_ || la05ds_.lenl_ + la05ds_.lenu_ + nz_ >= (*ia_)) {
      goto _l610;
    }
    (void) _la05es (a_, &ind_[0 + ((*ia_)) * ((1))], ip_, n_, iw_, ia_, ($1_ = TRUE, &$1_));
    _l60:;
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    ip_[i_ - 1 + ((*n_)) * ((0))] = la05ds_.lrow_ + 1;
    if (nz_ == 0) {
      goto _l80;
    }
    kpl_ = kp_ + nz_ - 1;
    for (k_ = kp_; k_ <= kpl_; (k_)++) {
      la05ds_.lrow_ = la05ds_.lrow_ + 1;
      a_[la05ds_.lrow_ - 1] = a_[k_ - 1];
      ind_[la05ds_.lrow_ - 1 + ((*ia_)) * ((1))] = ind_[k_ - 1 + ((*ia_)) * ((1))];
      ind_[k_ - 1 + ((*ia_)) * ((1))] = 0;
    }
    _l80:;
    la05ds_.lrow_ = la05ds_.lrow_ + 1;
    kpl_ = la05ds_.lrow_;
    _l90:;
    iw_[i_ - 1 + ((*n_)) * ((0))] = nz_ + 1;
    a_[kpl_ - 1] = w_[i_ - 1];
    ind_[kpl_ - 1 + ((*ia_)) * ((1))] = jm_;
    _l100:;
    w_[i_ - 1] = 0.0;
  }
  if (iw_[im_ - 1 + ((*n_)) * ((0))] == 0 || iw_[jm_ - 1 + ((*n_)) * ((1))] == 0 || m_ > last_) {
    goto _l590;
  }
  ins_ = m_;
  m1_ = m_;
  w_[jm_ - 1] = 1.0;
  for (ii_ = m_; ii_ <= last_; (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    j_ = iw_[ii_ - 1 + ((*n_)) * ((3))];
    if (w_[j_ - 1] == 0.0e0) {
      goto _l130;
    }
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    kl_ = kp_ + iw_[i_ - 1 + ((*n_)) * ((0))] - 1;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      w_[j_ - 1] = 1.0;
    }
    iw_[ins_ - 1 + ((*n_)) * ((3))] = i_;
    ins_ = ins_ + 1;
    goto _l140;
    _l130:;
    iw_[m1_ - 1 + ((*n_)) * ((2))] = i_;
    m1_ = m1_ + 1;
    _l140:;
  }
  ij_ = m_ + 1;
  for (ii_ = m1_; ii_ <= last_ - 1; (ii_)++) {
    iw_[ii_ - 1 + ((*n_)) * ((2))] = iw_[ij_ - 1 + ((*n_)) * ((3))];
    ij_ = ij_ + 1;
  }
  iw_[last_ - 1 + ((*n_)) * ((2))] = im_;
  last1_ = last_;
  jns_ = last_;
  w_[im_ - 1] = 2.0;
  j_ = jm_;
  for (ij_ = m1_; ij_ <= last_; (ij_)++) {
    ii_ = last_ + m1_ - ij_;
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    if (w_[i_ - 1] != 2.0e0) {
      goto _l170;
    }
    k_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    if (ii_ != last_) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    }
    kp_ = ip_[j_ - 1 + ((*n_)) * ((1))];
    kl_ = kp_ + iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
    iw_[jns_ - 1 + ((*n_)) * ((3))] = i_;
    jns_ = jns_ - 1;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      i_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
      w_[i_ - 1] = 2.0;
    }
    goto _l180;
    _l170:;
    iw_[last1_ - 1 + ((*n_)) * ((2))] = i_;
    last1_ = last1_ - 1;
    _l180:;
  }
  for (ii_ = m1_; ii_ <= last1_; (ii_)++) {
    jns_ = jns_ + 1;
    i_ = iw_[jns_ - 1 + ((*n_)) * ((3))];
    w_[i_ - 1] = 3.0;
    iw_[ii_ - 1 + ((*n_)) * ((2))] = i_;
  }
  for (ii_ = m1_; ii_ <= last1_; (ii_)++) {
    kp_ = ip_[jm_ - 1 + ((*n_)) * ((1))];
    kl_ = kp_ + iw_[jm_ - 1 + ((*n_)) * ((1))] - 1;
    is_ = 0;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      l_ = ind_[k_ - 1 + ((*ia_)) * ((0))];
      if (w_[l_ - 1] != 3.0e0) {
        goto _l200;
      }
      if (is_ != 0) {
        goto _l240;
      }
      i_ = l_;
      knp_ = k_;
      is_ = 1;
      _l200:;
    }
    if (is_ == 0) {
      goto _l590;
    }
    ind_[knp_ - 1 + ((*ia_)) * ((0))] = ind_[kp_ - 1 + ((*ia_)) * ((0))];
    ind_[kp_ - 1 + ((*ia_)) * ((0))] = i_;
    kp_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    for (k_ = kp_; k_ <= (*ia_); (k_)++) {
      if (ind_[k_ - 1 + ((*ia_)) * ((1))] == jm_) {
        goto _l220;
      }
    }
    _l220:;
    am_ = a_[kp_ - 1];
    a_[kp_ - 1] = a_[k_ - 1];
    a_[k_ - 1] = am_;
    ind_[k_ - 1 + ((*ia_)) * ((1))] = ind_[kp_ - 1 + ((*ia_)) * ((1))];
    ind_[kp_ - 1 + ((*ia_)) * ((1))] = jm_;
    jm_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    iw_[ii_ - 1 + ((*n_)) * ((3))] = i_;
    w_[i_ - 1] = 2.0;
  }
  ii_ = last1_;
  goto _l260;
  _l240:;
  in_ = m1_;
  for (ij_ = ii_; ij_ <= last1_; (ij_)++) {
    iw_[ij_ - 1 + ((*n_)) * ((3))] = iw_[in_ - 1 + ((*n_)) * ((2))];
    in_ = in_ + 1;
  }
  _l260:;
  last2_ = last1_ - 1;
  if (m1_ == last1_) {
    goto _l570;
  }
  for (i_ = m1_; i_ <= last2_; (i_)++) {
    iw_[i_ - 1 + ((*n_)) * ((2))] = iw_[i_ - 1 + ((*n_)) * ((3))];
  }
  m1_ = ii_;
  if (m1_ == last1_) {
    goto _l570;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[i_ - 1] = 0.0;
  }
  ir_ = iw_[last1_ - 1 + ((*n_)) * ((2))];
  for (ii_ = m1_; ii_ <= last1_; (ii_)++) {
    ipp_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    kp_ = ip_[ipp_ - 1 + ((*n_)) * ((0))];
    kr_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
    jp_ = ind_[kp_ - 1 + ((*ia_)) * ((1))];
    if (ii_ == last1_) {
      jp_ = jm_;
    }
    krl_ = kr_ + iw_[ir_ - 1 + ((*n_)) * ((0))] - 1;
    for (knp_ = kr_; knp_ <= krl_; (knp_)++) {
      if (jp_ == ind_[knp_ - 1 + ((*ia_)) * ((1))]) {
        goto _l300;
      }
    }
    $2_ = ii_ - last1_;
    if ($2_ < 0) {
      goto _l560;
    } else if ($2_ == 0) {
      goto _l590;
    } else {
      goto _l560;
    }
    _l300:;
    am_ = a_[knp_ - 1];
    a_[knp_ - 1] = a_[kr_ - 1];
    a_[kr_ - 1] = am_;
    ind_[knp_ - 1 + ((*ia_)) * ((1))] = ind_[kr_ - 1 + ((*ia_)) * ((1))];
    ind_[kr_ - 1 + ((*ia_)) * ((1))] = jp_;
    if (ii_ == last1_) {
      goto _l310;
    }
    if (_abs (a_[kp_ - 1]) < (*u_) * _abs (am_)) {
      goto _l310;
    }
    if (_abs (am_) < (*u_) * _abs (a_[kp_ - 1])) {
      goto _l340;
    }
    if (iw_[ipp_ - 1 + ((*n_)) * ((0))] <= iw_[ir_ - 1 + ((*n_)) * ((0))]) {
      goto _l340;
    }
    _l310:;
    iw_[last1_ - 1 + ((*n_)) * ((2))] = ipp_;
    iw_[ii_ - 1 + ((*n_)) * ((2))] = ir_;
    ir_ = ipp_;
    ipp_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    k_ = kr_;
    kr_ = kp_;
    kp_ = k_;
    kj_ = ip_[jp_ - 1 + ((*n_)) * ((1))];
    for (k_ = kj_; k_ <= (*ia_); (k_)++) {
      if (ind_[k_ - 1 + ((*ia_)) * ((0))] == ipp_) {
        goto _l330;
      }
    }
    _l330:;
    ind_[k_ - 1 + ((*ia_)) * ((0))] = ind_[kj_ - 1 + ((*ia_)) * ((0))];
    ind_[kj_ - 1 + ((*ia_)) * ((0))] = ipp_;
    _l340:;
    if (a_[kp_ - 1] == 0.0e0) {
      goto _l590;
    }
    if (ii_ == last1_) {
      goto _l560;
    }
    am_ = -a_[kr_ - 1] / a_[kp_ - 1];
    if (la05ds_.lrow_ + iw_[ir_ - 1 + ((*n_)) * ((0))] + iw_[ipp_ - 1 + ((*n_)) * ((0))] + la05ds_.lenl_ <= (*ia_)) {
      goto _l350;
    }
    if (la05ds_.ncp_ >= mcp_ || la05ds_.lenu_ + iw_[ir_ - 1 + ((*n_)) * ((0))] + iw_[ipp_ - 1 + ((*n_)) * ((0))] + 
      la05ds_.lenl_ > (*ia_)) {
      goto _l610;
    }
    (void) _la05es (a_, &ind_[0 + ((*ia_)) * ((1))], ip_, n_, iw_, ia_, ($3_ = TRUE, &$3_));
    kp_ = ip_[ipp_ - 1 + ((*n_)) * ((0))];
    kr_ = ip_[ir_ - 1 + ((*n_)) * ((0))];
    _l350:;
    krl_ = kr_ + iw_[ir_ - 1 + ((*n_)) * ((0))] - 1;
    kq_ = kp_ + 1;
    kpl_ = kp_ + iw_[ipp_ - 1 + ((*n_)) * ((0))] - 1;
    if (kq_ > kpl_) {
      goto _l370;
    }
    for (k_ = kq_; k_ <= kpl_; (k_)++) {
      j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
      w_[j_ - 1] = a_[k_ - 1];
    }
    _l370:;
    ip_[ir_ - 1 + ((*n_)) * ((0))] = la05ds_.lrow_ + 1;
    ind_[kr_ - 1 + ((*ia_)) * ((1))] = 0;
    kr_ = kr_ + 1;
    if (kr_ > krl_) {
      goto _l430;
    }
    for (ks_ = kr_; ks_ <= krl_; (ks_)++) {
      j_ = ind_[ks_ - 1 + ((*ia_)) * ((1))];
      au_ = a_[ks_ - 1] + am_ * w_[j_ - 1];
      ind_[ks_ - 1 + ((*ia_)) * ((1))] = 0;
      if (_abs (au_) <= la05ds_.small_) {
        goto _l380;
      }
      (*g_) = _max ((*g_), _abs (au_));
      la05ds_.lrow_ = la05ds_.lrow_ + 1;
      a_[la05ds_.lrow_ - 1] = au_;
      ind_[la05ds_.lrow_ - 1 + ((*ia_)) * ((1))] = j_;
      goto _l410;
      _l380:;
      la05ds_.lenu_ = la05ds_.lenu_ - 1;
      k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
      kl_ = k_ + iw_[j_ - 1 + ((*n_)) * ((1))] - 1;
      iw_[j_ - 1 + ((*n_)) * ((1))] = kl_ - k_;
      for (kk_ = k_; kk_ <= kl_; (kk_)++) {
        if (ind_[kk_ - 1 + ((*ia_)) * ((0))] == ir_) {
          goto _l400;
        }
      }
      _l400:;
      ind_[kk_ - 1 + ((*ia_)) * ((0))] = ind_[kl_ - 1 + ((*ia_)) * ((0))];
      ind_[kl_ - 1 + ((*ia_)) * ((0))] = 0;
      _l410:;
      w_[j_ - 1] = 0.0;
    }
    _l430:;
    if (kq_ > kpl_) {
      goto _l520;
    }
    for (ks_ = kq_; ks_ <= kpl_; (ks_)++) {
      j_ = ind_[ks_ - 1 + ((*ia_)) * ((1))];
      au_ = am_ * w_[j_ - 1];
      if (_abs (au_) <= la05ds_.small_) {
        goto _l500;
      }
      la05ds_.lrow_ = la05ds_.lrow_ + 1;
      a_[la05ds_.lrow_ - 1] = au_;
      ind_[la05ds_.lrow_ - 1 + ((*ia_)) * ((1))] = j_;
      la05ds_.lenu_ = la05ds_.lenu_ + 1;
      nz_ = iw_[j_ - 1 + ((*n_)) * ((1))];
      k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
      kl_ = k_ + nz_ - 1;
      if (kl_ != la05ds_.lcol_) {
        goto _l440;
      }
      if (la05ds_.lcol_ + la05ds_.lenl_ >= (*ia_)) {
        goto _l460;
      }
      la05ds_.lcol_ = la05ds_.lcol_ + 1;
      goto _l450;
      _l440:;
      if (ind_[kl_ + 1 - 1 + ((*ia_)) * ((0))] != 0) {
        goto _l460;
      }
      _l450:;
      ind_[kl_ + 1 - 1 + ((*ia_)) * ((0))] = ir_;
      goto _l490;
      _l460:;
      if (la05ds_.lcol_ + la05ds_.lenl_ + nz_ + 1 < (*ia_)) {
        goto _l470;
      }
      if (la05ds_.ncp_ >= mcp_ || la05ds_.lenu_ + la05ds_.lenl_ + nz_ + 1 >= (*ia_)) {
        goto _l610;
      }
      (void) _la05es (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($4_ = FALSE, &$4_));
      k_ = ip_[j_ - 1 + ((*n_)) * ((1))];
      kl_ = k_ + nz_ - 1;
      _l470:;
      ip_[j_ - 1 + ((*n_)) * ((1))] = la05ds_.lcol_ + 1;
      for (kk_ = k_; kk_ <= kl_; (kk_)++) {
        la05ds_.lcol_ = la05ds_.lcol_ + 1;
        ind_[la05ds_.lcol_ - 1 + ((*ia_)) * ((0))] = ind_[kk_ - 1 + ((*ia_)) * ((0))];
        ind_[kk_ - 1 + ((*ia_)) * ((0))] = 0;
      }
      la05ds_.lcol_ = la05ds_.lcol_ + 1;
      ind_[la05ds_.lcol_ - 1 + ((*ia_)) * ((0))] = ir_;
      _l490:;
      (*g_) = _max ((*g_), _abs (au_));
      iw_[j_ - 1 + ((*n_)) * ((1))] = nz_ + 1;
      _l500:;
      w_[j_ - 1] = 0.0;
    }
    _l520:;
    iw_[ir_ - 1 + ((*n_)) * ((0))] = la05ds_.lrow_ + 1 - ip_[ir_ - 1 + ((*n_)) * ((0))];
    if (la05ds_.lenl_ + la05ds_.lcol_ + 1 <= (*ia_)) {
      goto _l530;
    }
    if (la05ds_.ncp_ >= mcp_) {
      goto _l610;
    }
    (void) _la05es (a_, ind_, &ip_[0 + ((*n_)) * ((1))], n_, &iw_[0 + ((*n_)) * ((1))], ia_, ($5_ = FALSE, &$5_));
    _l530:;
    k_ = (*ia_) - la05ds_.lenl_;
    la05ds_.lenl_ = la05ds_.lenl_ + 1;
    a_[k_ - 1] = am_;
    ind_[k_ - 1 + ((*ia_)) * ((0))] = ipp_;
    ind_[k_ - 1 + ((*ia_)) * ((1))] = ir_;
    kp_ = ip_[jp_ - 1 + ((*n_)) * ((1))];
    nz_ = iw_[jp_ - 1 + ((*n_)) * ((1))] - 1;
    kl_ = kp_ + nz_;
    for (k_ = kp_; k_ <= kl_; (k_)++) {
      if (ind_[k_ - 1 + ((*ia_)) * ((0))] == ir_) {
        goto _l550;
      }
    }
    _l550:;
    ind_[k_ - 1 + ((*ia_)) * ((0))] = ind_[kl_ - 1 + ((*ia_)) * ((0))];
    iw_[jp_ - 1 + ((*n_)) * ((1))] = nz_;
    ind_[kl_ - 1 + ((*ia_)) * ((0))] = 0;
    la05ds_.lenu_ = la05ds_.lenu_ - 1;
    _l560:;
  }
  _l570:;
  for (ii_ = m_; ii_ <= last_; (ii_)++) {
    i_ = iw_[ii_ - 1 + ((*n_)) * ((2))];
    k_ = ip_[i_ - 1 + ((*n_)) * ((0))];
    j_ = ind_[k_ - 1 + ((*ia_)) * ((1))];
    iw_[ii_ - 1 + ((*n_)) * ((3))] = j_;
  }
  goto _l0;
  _l590:;
  if (la05ds_.lp_ > 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-harwell:la05cs:400", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05cs:400", 0));
      __fcnt += 3;
    }
    if ($f_100306_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05cs:400", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100306_[__fcnt + 2], &(*mm_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05cs:400", 0));
    __fcnt += 3;
    while ($f_100306_[__fcnt] != NULL && $f_100306_[__fcnt] == FMT_TEXT) {
      if ($f_100306_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100306_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-harwell:la05cs:400", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_0, _dc_24, (bufcpy ($8_, concat ($7_, concat ($6_, _dc_22, _dc_23), xern1_), 255), $8_), ($9_ = -6, 
    &$9_), &_k1);
  }
  (*g_) = -6.0;
  goto _l0;
  _l610:;
  if (la05ds_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_24, _dc_10, ($10_ = -7, &$10_), &_k1);
  }
  (*g_) = -7.0;
  goto _l0;
  _l620:;
  if (la05ds_.lp_ > 0) {
    (void) _xermsg (_dc_0, _dc_24, _dc_19, ($11_ = -8, &$11_), ($12_ = 2, &$12_));
  }
  (*g_) = -8.0;
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _la05ed (real_8 _p_ a_, int_4 _p_ irn_, int_4 _p_ ip_, int_4 _p_ n_, int_4 _p_ iw_, int_4 _p_ ia_, logical_4 _p_ 
reals_)
{
  static int_4 j_, nz_, k_, kn_, ipi_, kl_;
  la05dd_.ncp_ = la05dd_.ncp_ + 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    nz_ = iw_[j_ - 1];
    if (nz_ <= 0) {
      goto _l10;
    }
    k_ = ip_[j_ - 1] + nz_ - 1;
    iw_[j_ - 1] = irn_[k_ - 1];
    irn_[k_ - 1] = -j_;
    _l10:;
  }
  kn_ = 0;
  ipi_ = 0;
  kl_ = la05dd_.lcol_;
  if ((*reals_)) {
    kl_ = la05dd_.lrow_;
  }
  for (k_ = 1; k_ <= kl_; (k_)++) {
    if (irn_[k_ - 1] == 0) {
      goto _l30;
    }
    kn_ = kn_ + 1;
    if ((*reals_)) {
      a_[kn_ - 1] = a_[k_ - 1];
    }
    if (irn_[k_ - 1] >= 0) {
      goto _l20;
    }
    j_ = -irn_[k_ - 1];
    irn_[k_ - 1] = iw_[j_ - 1];
    ip_[j_ - 1] = ipi_ + 1;
    iw_[j_ - 1] = kn_ - ipi_;
    ipi_ = kn_;
    _l20:;
    irn_[kn_ - 1] = irn_[k_ - 1];
    _l30:;
  }
  if ((*reals_)) {
    la05dd_.lrow_ = kn_;
  }
  if (! ((*reals_))) {
    la05dd_.lcol_ = kn_;
  }
  __calls[6].calls++;
  return 0;
}
int_4 _la05es (real_4 _p_ a_, int_4 _p_ irn_, int_4 _p_ ip_, int_4 _p_ n_, int_4 _p_ iw_, int_4 _p_ ia_, logical_4 _p_ 
reals_)
{
  static int_4 j_, nz_, k_, kn_, ipi_, kl_;
  la05ds_.ncp_ = la05ds_.ncp_ + 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    nz_ = iw_[j_ - 1];
    if (nz_ <= 0) {
      goto _l10;
    }
    k_ = ip_[j_ - 1] + nz_ - 1;
    iw_[j_ - 1] = irn_[k_ - 1];
    irn_[k_ - 1] = -j_;
    _l10:;
  }
  kn_ = 0;
  ipi_ = 0;
  kl_ = la05ds_.lcol_;
  if ((*reals_)) {
    kl_ = la05ds_.lrow_;
  }
  for (k_ = 1; k_ <= kl_; (k_)++) {
    if (irn_[k_ - 1] == 0) {
      goto _l30;
    }
    kn_ = kn_ + 1;
    if ((*reals_)) {
      a_[kn_ - 1] = a_[k_ - 1];
    }
    if (irn_[k_ - 1] >= 0) {
      goto _l20;
    }
    j_ = -irn_[k_ - 1];
    irn_[k_ - 1] = iw_[j_ - 1];
    ip_[j_ - 1] = ipi_ + 1;
    iw_[j_ - 1] = kn_ - ipi_;
    ipi_ = kn_;
    _l20:;
    irn_[kn_ - 1] = irn_[k_ - 1];
    _l30:;
  }
  if ((*reals_)) {
    la05ds_.lrow_ = kn_;
  }
  if (! ((*reals_))) {
    la05ds_.lcol_ = kn_;
  }
  __calls[7].calls++;
  return 0;
}
int_4 _mc20ad (int_4 _p_ nc_, int_4 _p_ maxa_, real_8 _p_ a_, int_4 _p_ inum_, int_4 _p_ jptr_, int_4 _p_ jnum_, int_4 
_p_ jdisp_)
{
  static int_4 null_, j_, k_, kr_, i_, jce_, ice_, loc_, icep_, jcep_, ja_, jb_;
  static real_8 ace_, acep_;
  null_ = -(*jdisp_);
  for (j_ = 1; j_ <= (*nc_); (j_)++) {
    jptr_[j_ - 1] = 0;
  }
  for (k_ = 1; k_ <= (*maxa_); (k_)++) {
    j_ = jnum_[k_ - 1] + (*jdisp_);
    jptr_[j_ - 1] = jptr_[j_ - 1] + 1;
  }
  k_ = 1;
  for (j_ = 1; j_ <= (*nc_); (j_)++) {
    kr_ = k_ + jptr_[j_ - 1];
    jptr_[j_ - 1] = k_;
    k_ = kr_;
  }
  for (i_ = 1; i_ <= (*maxa_); (i_)++) {
    jce_ = jnum_[i_ - 1] + (*jdisp_);
    if (jce_ == 0) {
      goto _l50;
    }
    ace_ = a_[i_ - 1];
    ice_ = inum_[i_ - 1];
    jnum_[i_ - 1] = null_;
    for (j_ = 1; j_ <= (*maxa_); (j_)++) {
      loc_ = jptr_[jce_ - 1];
      jptr_[jce_ - 1] = jptr_[jce_ - 1] + 1;
      acep_ = a_[loc_ - 1];
      icep_ = inum_[loc_ - 1];
      jcep_ = jnum_[loc_ - 1];
      a_[loc_ - 1] = ace_;
      inum_[loc_ - 1] = ice_;
      jnum_[loc_ - 1] = null_;
      if (jcep_ == null_) {
        goto _l50;
      }
      ace_ = acep_;
      ice_ = icep_;
      jce_ = jcep_ + (*jdisp_);
    }
    _l50:;
  }
  ja_ = 1;
  for (j_ = 1; j_ <= (*nc_); (j_)++) {
    jb_ = jptr_[j_ - 1];
    jptr_[j_ - 1] = ja_;
    ja_ = jb_;
  }
  __calls[8].calls++;
  return 0;
}

int_4 _mc20as (int_4 _p_ nc_, int_4 _p_ maxa_, real_4 _p_ a_, int_4 _p_ inum_, int_4 _p_ jptr_, int_4 _p_ jnum_, int_4 
_p_ jdisp_)
{
  static int_4 null_, j_, k_, kr_, i_, jce_, ice_, loc_, icep_, jcep_, ja_, jb_;
  static real_4 ace_, acep_;
  null_ = -(*jdisp_);
  for (j_ = 1; j_ <= (*nc_); (j_)++) {
    jptr_[j_ - 1] = 0;
  }
  for (k_ = 1; k_ <= (*maxa_); (k_)++) {
    j_ = jnum_[k_ - 1] + (*jdisp_);
    jptr_[j_ - 1] = jptr_[j_ - 1] + 1;
  }
  k_ = 1;
  for (j_ = 1; j_ <= (*nc_); (j_)++) {
    kr_ = k_ + jptr_[j_ - 1];
    jptr_[j_ - 1] = k_;
    k_ = kr_;
  }
  for (i_ = 1; i_ <= (*maxa_); (i_)++) {
    jce_ = jnum_[i_ - 1] + (*jdisp_);
    if (jce_ == 0) {
      goto _l50;
    }
    ace_ = a_[i_ - 1];
    ice_ = inum_[i_ - 1];
    jnum_[i_ - 1] = null_;
    for (j_ = 1; j_ <= (*maxa_); (j_)++) {
      loc_ = jptr_[jce_ - 1];
      jptr_[jce_ - 1] = jptr_[jce_ - 1] + 1;
      acep_ = a_[loc_ - 1];
      icep_ = inum_[loc_ - 1];
      jcep_ = jnum_[loc_ - 1];
      a_[loc_ - 1] = ace_;
      inum_[loc_ - 1] = ice_;
      jnum_[loc_ - 1] = null_;
      if (jcep_ == null_) {
        goto _l50;
      }
      ace_ = acep_;
      ice_ = icep_;
      jce_ = jcep_ + (*jdisp_);
    }
    _l50:;
  }
  ja_ = 1;
  for (j_ = 1; j_ <= (*nc_); (j_)++) {
    jb_ = jptr_[j_ - 1];
    jptr_[j_ - 1] = ja_;
    ja_ = jb_;
  }
  __calls[9].calls++;
  return 0;
}

