//! @file mathlib-slatec-pppack.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 18 subprograms from SLATEC-PPPACK

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// BNFAC  BSPDOC BSPVN  DBNSLV DBSPVN DFC    DPCHDF FC     PCHDF  PCHDOC
// BNSLV  BSPDR  DBNFAC DBSPDR DEFC   DINTRV EFC    INTRV

// Miscellaneous routines from SLATEC, not in other packages as BLAS,
// EISPACK, FISHPACK, FFTPACK, FNLIB, LINPACK etcetera.
// 
// Source: netlib.org/slatec/
// 
// For VIF, all source file have been formatted and labels have been renumbered.

// The license for SLATEC Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "slatec"
#define _dc_1 "bspdr"
#define _dc_2 "k does not satisfy k.ge.1"
#define _dc_3 "n does not satisfy n.ge.k"
#define _dc_4 "nderiv does not satisfy 1.le.nderiv.le.k"
#define _dc_5 "bspvn"
#define _dc_6 "jhigh does not satisfy 1.le.jhigh.le.k"
#define _dc_7 "index is not 1 or 2"
#define _dc_8 "x does not satisfy t(ileft).le.x.le.t(ileft+1)"
#define _dc_9 "dbspdr"
#define _dc_10 "dbspvn"
#define _dc_11 "dpchdf"
#define _dc_12 "k less than three"
#define _dc_13 "pchdf"
static FORMAT *__fmt_a = NULL;
typedef char char_7[8];
typedef char char_31[32];
typedef char char_63[64];
#define __ncalls 19
static CALLS __calls[__ncalls] = {
  {"bnfac", 0}, // subroutine
  {"bnslv", 0}, // subroutine
  {"bspdoc", 0}, // subroutine
  {"bspdr", 0}, // subroutine
  {"bspvn", 0}, // subroutine
  {"dbnfac", 0}, // subroutine
  {"dbnslv", 0}, // subroutine
  {"dbspdr", 0}, // subroutine
  {"dbspvn", 0}, // subroutine
  {"defc", 0}, // subroutine
  {"dfc", 0}, // subroutine
  {"dintrv", 0}, // subroutine
  {"dpchdf", 0}, // real*8 function
  {"efc", 0}, // subroutine
  {"fc", 0}, // subroutine
  {"intrv", 0}, // subroutine
  {"pchdf", 0}, // real*4 function
  {"pchdoc", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _bnfac (real_4 _p_ w_, int_4 _p_ nroww_, int_4 _p_ nrow_, int_4 _p_ nbandl_, int_4 _p_ nbandu_, int_4 
_p_ iflag_);
prototype int_4 _bnslv (real_4 _p_ w_, int_4 _p_ nroww_, int_4 _p_ nrow_, int_4 _p_ nbandl_, int_4 _p_ nbandu_, real_4 
_p_ b_);
prototype int_4 _bspdoc (void);
prototype int_4 _bspdr (real_4 _p_ t_, real_4 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ nderiv_, real_4 _p_ ad_);
prototype int_4 _bspvn (real_4 _p_ t_, int_4 _p_ jhigh_, int_4 _p_ k_, int_4 _p_ index_, real_4 _p_ x_, int_4 _p_ 
ileft_, real_4 _p_ vnikx_, real_4 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _dbnfac (real_8 _p_ w_, int_4 _p_ nroww_, int_4 _p_ nrow_, int_4 _p_ nbandl_, int_4 _p_ nbandu_, int_4 
_p_ iflag_);
prototype int_4 _dbnslv (real_8 _p_ w_, int_4 _p_ nroww_, int_4 _p_ nrow_, int_4 _p_ nbandl_, int_4 _p_ nbandu_, real_8 
_p_ b_);
prototype int_4 _dbspdr (real_8 _p_ t_, real_8 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ nderiv_, real_8 _p_ ad_);
prototype int_4 _dbspvn (real_8 _p_ t_, int_4 _p_ jhigh_, int_4 _p_ k_, int_4 _p_ index_, real_8 _p_ x_, int_4 _p_ 
ileft_, real_8 _p_ vnikx_, real_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _defc (int_4 _p_ ndata_, real_8 _p_ xdata_, real_8 _p_ ydata_, real_8 _p_ sddata_, int_4 _p_ nord_, 
int_4 _p_ nbkpt_, real_8 _p_ bkpt_, int_4 _p_ mdein_, int_4 _p_ mdeout_, real_8 _p_ coeff_, int_4 _p_ lw_, real_8 _p_ 
w_);
prototype int_4 _dfc (int_4 _p_ ndata_, real_8 _p_ xdata_, real_8 _p_ ydata_, real_8 _p_ sddata_, int_4 _p_ nord_, 
int_4 _p_ nbkpt_, real_8 _p_ bkpt_, int_4 _p_ nconst_, real_8 _p_ xconst_, real_8 _p_ yconst_, int_4 _p_ nderiv_, int_4 
_p_ mode_, real_8 _p_ coeff_, real_8 _p_ w_, int_4 _p_ iw_);
prototype int_4 _dintrv (real_8 _p_ xt_, int_4 _p_ lxt_, real_8 _p_ x_, int_4 _p_ ilo_, int_4 _p_ ileft_, int_4 _p_ 
mflag_);
prototype real_8 _dpchdf (int_4 _p_ k_, real_8 _p_ x_, real_8 _p_ s_, int_4 _p_ ierr_);
prototype int_4 _efc (int_4 _p_ ndata_, real_4 _p_ xdata_, real_4 _p_ ydata_, real_4 _p_ sddata_, int_4 _p_ nord_, 
int_4 _p_ nbkpt_, real_4 _p_ bkpt_, int_4 _p_ mdein_, int_4 _p_ mdeout_, real_4 _p_ coeff_, int_4 _p_ lw_, real_4 _p_ 
w_);
prototype int_4 _fc (int_4 _p_ ndata_, real_4 _p_ xdata_, real_4 _p_ ydata_, real_4 _p_ sddata_, int_4 _p_ nord_, int_4 
_p_ nbkpt_, real_4 _p_ bkpt_, int_4 _p_ nconst_, real_4 _p_ xconst_, real_4 _p_ yconst_, int_4 _p_ nderiv_, int_4 _p_ 
mode_, real_4 _p_ coeff_, real_4 _p_ w_, int_4 _p_ iw_);
prototype int_4 _intrv (real_4 _p_ xt_, int_4 _p_ lxt_, real_4 _p_ x_, int_4 _p_ ilo_, int_4 _p_ ileft_, int_4 _p_ 
mflag_);
prototype real_4 _pchdf (int_4 _p_ k_, real_4 _p_ x_, real_4 _p_ s_, int_4 _p_ ierr_);
prototype int_4 _pchdoc (void);
int_4 _bnfac (real_4 _p_ w_, int_4 _p_ nroww_, int_4 _p_ nrow_, int_4 _p_ nbandl_, int_4 _p_ nbandu_, int_4 _p_ iflag_)
{
  static int_4 i_, ipk_, j_, jmax_, k_, kmax_, middle_, midmk_, nrowm1_;
  static real_4 factor_, pivot_;
  int_4 $0_;
  (*iflag_) = 1;
  middle_ = (*nbandu_) + 1;
  nrowm1_ = (*nrow_) - 1;
  $0_ = nrowm1_;
  if ($0_ < 0) {
    goto _l120;
  } else if ($0_ == 0) {
    goto _l110;
  } else {
    goto _l10;
  }
  _l10:;
  if ((*nbandl_) > 0) {
    goto _l30;
  }
  for (i_ = 1; i_ <= nrowm1_; (i_)++) {
    if (w_[middle_ - 1 + ((*nroww_)) * ((i_ - 1))] == 0.0e0) {
      goto _l120;
    }
  }
  goto _l110;
  _l30:;
  if ((*nbandu_) > 0) {
    goto _l60;
  }
  for (i_ = 1; i_ <= nrowm1_; (i_)++) {
    pivot_ = w_[middle_ - 1 + ((*nroww_)) * ((i_ - 1))];
    if (pivot_ == 0.0e0) {
      goto _l120;
    }
    jmax_ = _min ((*nbandl_), (*nrow_) - i_);
    for (j_ = 1; j_ <= jmax_; (j_)++) {
      w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))] = w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))] / pivot_;
    }
  }
  goto _l0;
  _l60:;
  for (i_ = 1; i_ <= nrowm1_; (i_)++) {
    pivot_ = w_[middle_ - 1 + ((*nroww_)) * ((i_ - 1))];
    if (pivot_ == 0.0e0) {
      goto _l120;
    }
    jmax_ = _min ((*nbandl_), (*nrow_) - i_);
    for (j_ = 1; j_ <= jmax_; (j_)++) {
      w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))] = w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))] / pivot_;
    }
    kmax_ = _min ((*nbandu_), (*nrow_) - i_);
    for (k_ = 1; k_ <= kmax_; (k_)++) {
      ipk_ = i_ + k_;
      midmk_ = middle_ - k_;
      factor_ = w_[midmk_ - 1 + ((*nroww_)) * ((ipk_ - 1))];
      for (j_ = 1; j_ <= jmax_; (j_)++) {
        w_[midmk_ + j_ - 1 + ((*nroww_)) * ((ipk_ - 1))] = w_[midmk_ + j_ - 1 + ((*nroww_)) * ((ipk_ - 1))] - w_[middle_ + j_ - 
        1 + ((*nroww_)) * ((i_ - 1))] * factor_;
      }
    }
  }
  _l110:;
  if (w_[middle_ - 1 + ((*nroww_)) * (((*nrow_) - 1))] != 0.0e0) {
    goto _l0;
  }
  _l120:;
  (*iflag_) = 2;
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _bnslv (real_4 _p_ w_, int_4 _p_ nroww_, int_4 _p_ nrow_, int_4 _p_ nbandl_, int_4 _p_ nbandu_, real_4 _p_ b_)
{
  static int_4 i_, j_, jmax_, middle_, nrowm1_;
  middle_ = (*nbandu_) + 1;
  if ((*nrow_) == 1) {
    goto _l80;
  }
  nrowm1_ = (*nrow_) - 1;
  if ((*nbandl_) == 0) {
    goto _l30;
  }
  for (i_ = 1; i_ <= nrowm1_; (i_)++) {
    jmax_ = _min ((*nbandl_), (*nrow_) - i_);
    for (j_ = 1; j_ <= jmax_; (j_)++) {
      b_[i_ + j_ - 1] = b_[i_ + j_ - 1] - b_[i_ - 1] * w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))];
    }
  }
  _l30:;
  if ((*nbandu_) > 0) {
    goto _l50;
  }
  for (i_ = 1; i_ <= (*nrow_); (i_)++) {
    b_[i_ - 1] = b_[i_ - 1] / w_[0 + ((*nroww_)) * ((i_ - 1))];
  }
  goto _l0;
  _l50:;
  i_ = (*nrow_);
  _l60:;
  b_[i_ - 1] = b_[i_ - 1] / w_[middle_ - 1 + ((*nroww_)) * ((i_ - 1))];
  jmax_ = _min ((*nbandu_), i_ - 1);
  for (j_ = 1; j_ <= jmax_; (j_)++) {
    b_[i_ - j_ - 1] = b_[i_ - j_ - 1] - b_[i_ - 1] * w_[middle_ - j_ - 1 + ((*nroww_)) * ((i_ - 1))];
  }
  i_ = i_ - 1;
  if (i_ > 1) {
    goto _l60;
  }
  _l80:;
  b_[0] = b_[0] / w_[middle_ - 1 + ((*nroww_)) * ((0))];
  _l0:;
  __calls[1].calls++;
  return 0;
}

int_4 _bspdoc (void)
{
  __calls[2].calls++;
  return 0;
}

int_4 _bspdr (real_4 _p_ t_, real_4 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ nderiv_, real_4 _p_ ad_)
{
  static int_4 i_, id_, ii_, ipkmid_, jj_, jm_, kmid_;
  static real_4 diff_, fkmid_;
  int_4 $0_, $1_, $2_;
  if ((*k_) < 1) {
    goto _l100;
  }
  if ((*n_) < (*k_)) {
    goto _l105;
  }
  if ((*nderiv_) < 1 || (*nderiv_) > (*k_)) {
    goto _l110;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ad_[i_ - 1] = a_[i_ - 1];
  }
  if ((*nderiv_) == 1) {
    goto _l0;
  }
  kmid_ = (*k_);
  jj_ = (*n_);
  jm_ = 0;
  for (id_ = 2; id_ <= (*nderiv_); (id_)++) {
    kmid_ = kmid_ - 1;
    fkmid_ = kmid_;
    ii_ = 1;
    for (i_ = id_; i_ <= (*n_); (i_)++) {
      ipkmid_ = i_ + kmid_;
      diff_ = t_[ipkmid_ - 1] - t_[i_ - 1];
      if (diff_ != 0.0e0) {
        ad_[ii_ + jj_ - 1] = (ad_[ii_ + jm_ + 1 - 1] - ad_[ii_ + jm_ - 1]) / diff_ * fkmid_;
      }
      ii_ = ii_ + 1;
    }
    jm_ = jj_;
    jj_ = jj_ + (*n_) - id_ + 1;
  }
  goto _l0;
  _l100:;
  (void) _xermsg (_dc_0, _dc_1, _dc_2, ($0_ = 2, &$0_), &_k1);
  goto _l0;
  _l105:;
  (void) _xermsg (_dc_0, _dc_1, _dc_3, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_1, _dc_4, ($2_ = 2, &$2_), &_k1);
  _l0:;
  __calls[3].calls++;
  return 0;
}

int_4 _bspvn (real_4 _p_ t_, int_4 _p_ jhigh_, int_4 _p_ k_, int_4 _p_ index_, real_4 _p_ x_, int_4 _p_ ileft_, real_4 
_p_ vnikx_, real_4 _p_ work_, int_4 _p_ iwork_)
{
  static int_4 imjp1_, ipj_, jp1_, jp1ml_, l_;
  static real_4 vm_, vmprev_;
  int_4 $0_, $1_, $2_, $3_;
  if ((*k_) < 1) {
    goto _l90;
  }
  if ((*jhigh_) > (*k_) || (*jhigh_) < 1) {
    goto _l100;
  }
  if ((*index_) < 1 || (*index_) > 2) {
    goto _l105;
  }
  if ((*x_) < t_[(*ileft_) - 1] || (*x_) > t_[(*ileft_) + 1 - 1]) {
    goto _l110;
  }
  switch ((*index_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  (*iwork_) = 1;
  vnikx_[0] = 1.0;
  if ((*iwork_) >= (*jhigh_)) {
    goto _l40;
  }
  _l20:;
  ipj_ = (*ileft_) + (*iwork_);
  work_[(*iwork_) - 1] = t_[ipj_ - 1] - (*x_);
  imjp1_ = (*ileft_) - (*iwork_) + 1;
  work_[(*k_) + (*iwork_) - 1] = (*x_) - t_[imjp1_ - 1];
  vmprev_ = 0.0;
  jp1_ = (*iwork_) + 1;
  for (l_ = 1; l_ <= (*iwork_); (l_)++) {
    jp1ml_ = jp1_ - l_;
    vm_ = vnikx_[l_ - 1] / (work_[l_ - 1] + work_[(*k_) + jp1ml_ - 1]);
    vnikx_[l_ - 1] = vm_ * work_[l_ - 1] + vmprev_;
    vmprev_ = vm_ * work_[(*k_) + jp1ml_ - 1];
  }
  vnikx_[jp1_ - 1] = vmprev_;
  (*iwork_) = jp1_;
  if ((*iwork_) < (*jhigh_)) {
    goto _l20;
  }
  _l40:;
  goto _l0;
  _l90:;
  (void) _xermsg (_dc_0, _dc_5, _dc_2, ($0_ = 2, &$0_), &_k1);
  goto _l0;
  _l100:;
  (void) _xermsg (_dc_0, _dc_5, _dc_6, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l105:;
  (void) _xermsg (_dc_0, _dc_5, _dc_7, ($2_ = 2, &$2_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_5, _dc_8, ($3_ = 2, &$3_), &_k1);
  _l0:;
  __calls[4].calls++;
  return 0;
}

int_4 _dbnfac (real_8 _p_ w_, int_4 _p_ nroww_, int_4 _p_ nrow_, int_4 _p_ nbandl_, int_4 _p_ nbandu_, int_4 _p_ iflag_
)
{
  static int_4 i_, ipk_, j_, jmax_, k_, kmax_, middle_, midmk_, nrowm1_;
  static real_8 factor_, pivot_;
  int_4 $0_;
  (*iflag_) = 1;
  middle_ = (*nbandu_) + 1;
  nrowm1_ = (*nrow_) - 1;
  $0_ = nrowm1_;
  if ($0_ < 0) {
    goto _l120;
  } else if ($0_ == 0) {
    goto _l110;
  } else {
    goto _l10;
  }
  _l10:;
  if ((*nbandl_) > 0) {
    goto _l30;
  }
  for (i_ = 1; i_ <= nrowm1_; (i_)++) {
    if (w_[middle_ - 1 + ((*nroww_)) * ((i_ - 1))] == 0.0e0) {
      goto _l120;
    }
  }
  goto _l110;
  _l30:;
  if ((*nbandu_) > 0) {
    goto _l60;
  }
  for (i_ = 1; i_ <= nrowm1_; (i_)++) {
    pivot_ = w_[middle_ - 1 + ((*nroww_)) * ((i_ - 1))];
    if (pivot_ == 0.0e0) {
      goto _l120;
    }
    jmax_ = _min ((*nbandl_), (*nrow_) - i_);
    for (j_ = 1; j_ <= jmax_; (j_)++) {
      w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))] = w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))] / pivot_;
    }
  }
  goto _l0;
  _l60:;
  for (i_ = 1; i_ <= nrowm1_; (i_)++) {
    pivot_ = w_[middle_ - 1 + ((*nroww_)) * ((i_ - 1))];
    if (pivot_ == 0.0e0) {
      goto _l120;
    }
    jmax_ = _min ((*nbandl_), (*nrow_) - i_);
    for (j_ = 1; j_ <= jmax_; (j_)++) {
      w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))] = w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))] / pivot_;
    }
    kmax_ = _min ((*nbandu_), (*nrow_) - i_);
    for (k_ = 1; k_ <= kmax_; (k_)++) {
      ipk_ = i_ + k_;
      midmk_ = middle_ - k_;
      factor_ = w_[midmk_ - 1 + ((*nroww_)) * ((ipk_ - 1))];
      for (j_ = 1; j_ <= jmax_; (j_)++) {
        w_[midmk_ + j_ - 1 + ((*nroww_)) * ((ipk_ - 1))] = w_[midmk_ + j_ - 1 + ((*nroww_)) * ((ipk_ - 1))] - w_[middle_ + j_ - 
        1 + ((*nroww_)) * ((i_ - 1))] * factor_;
      }
    }
  }
  _l110:;
  if (w_[middle_ - 1 + ((*nroww_)) * (((*nrow_) - 1))] != 0.0e0) {
    goto _l0;
  }
  _l120:;
  (*iflag_) = 2;
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _dbnslv (real_8 _p_ w_, int_4 _p_ nroww_, int_4 _p_ nrow_, int_4 _p_ nbandl_, int_4 _p_ nbandu_, real_8 _p_ b_)
{
  static int_4 i_, j_, jmax_, middle_, nrowm1_;
  middle_ = (*nbandu_) + 1;
  if ((*nrow_) == 1) {
    goto _l80;
  }
  nrowm1_ = (*nrow_) - 1;
  if ((*nbandl_) == 0) {
    goto _l30;
  }
  for (i_ = 1; i_ <= nrowm1_; (i_)++) {
    jmax_ = _min ((*nbandl_), (*nrow_) - i_);
    for (j_ = 1; j_ <= jmax_; (j_)++) {
      b_[i_ + j_ - 1] = b_[i_ + j_ - 1] - b_[i_ - 1] * w_[middle_ + j_ - 1 + ((*nroww_)) * ((i_ - 1))];
    }
  }
  _l30:;
  if ((*nbandu_) > 0) {
    goto _l50;
  }
  for (i_ = 1; i_ <= (*nrow_); (i_)++) {
    b_[i_ - 1] = b_[i_ - 1] / w_[0 + ((*nroww_)) * ((i_ - 1))];
  }
  goto _l0;
  _l50:;
  i_ = (*nrow_);
  _l60:;
  b_[i_ - 1] = b_[i_ - 1] / w_[middle_ - 1 + ((*nroww_)) * ((i_ - 1))];
  jmax_ = _min ((*nbandu_), i_ - 1);
  for (j_ = 1; j_ <= jmax_; (j_)++) {
    b_[i_ - j_ - 1] = b_[i_ - j_ - 1] - b_[i_ - 1] * w_[middle_ - j_ - 1 + ((*nroww_)) * ((i_ - 1))];
  }
  i_ = i_ - 1;
  if (i_ > 1) {
    goto _l60;
  }
  _l80:;
  b_[0] = b_[0] / w_[middle_ - 1 + ((*nroww_)) * ((0))];
  _l0:;
  __calls[6].calls++;
  return 0;
}

int_4 _dbspdr (real_8 _p_ t_, real_8 _p_ a_, int_4 _p_ n_, int_4 _p_ k_, int_4 _p_ nderiv_, real_8 _p_ ad_)
{
  static int_4 i_, id_, ii_, ipkmid_, jj_, jm_, kmid_;
  static real_8 diff_, fkmid_;
  int_4 $0_, $1_, $2_;
  if ((*k_) < 1) {
    goto _l100;
  }
  if ((*n_) < (*k_)) {
    goto _l105;
  }
  if ((*nderiv_) < 1 || (*nderiv_) > (*k_)) {
    goto _l110;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    ad_[i_ - 1] = a_[i_ - 1];
  }
  if ((*nderiv_) == 1) {
    goto _l0;
  }
  kmid_ = (*k_);
  jj_ = (*n_);
  jm_ = 0;
  for (id_ = 2; id_ <= (*nderiv_); (id_)++) {
    kmid_ = kmid_ - 1;
    fkmid_ = kmid_;
    ii_ = 1;
    for (i_ = id_; i_ <= (*n_); (i_)++) {
      ipkmid_ = i_ + kmid_;
      diff_ = t_[ipkmid_ - 1] - t_[i_ - 1];
      if (diff_ != 0.0e0) {
        ad_[ii_ + jj_ - 1] = (ad_[ii_ + jm_ + 1 - 1] - ad_[ii_ + jm_ - 1]) / diff_ * fkmid_;
      }
      ii_ = ii_ + 1;
    }
    jm_ = jj_;
    jj_ = jj_ + (*n_) - id_ + 1;
  }
  goto _l0;
  _l100:;
  (void) _xermsg (_dc_0, _dc_9, _dc_2, ($0_ = 2, &$0_), &_k1);
  goto _l0;
  _l105:;
  (void) _xermsg (_dc_0, _dc_9, _dc_3, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_9, _dc_4, ($2_ = 2, &$2_), &_k1);
  _l0:;
  __calls[7].calls++;
  return 0;
}

int_4 _dbspvn (real_8 _p_ t_, int_4 _p_ jhigh_, int_4 _p_ k_, int_4 _p_ index_, real_8 _p_ x_, int_4 _p_ ileft_, real_8 
_p_ vnikx_, real_8 _p_ work_, int_4 _p_ iwork_)
{
  static int_4 imjp1_, ipj_, jp1_, jp1ml_, l_;
  static real_8 vm_, vmprev_;
  int_4 $0_, $1_, $2_, $3_;
  if ((*k_) < 1) {
    goto _l90;
  }
  if ((*jhigh_) > (*k_) || (*jhigh_) < 1) {
    goto _l100;
  }
  if ((*index_) < 1 || (*index_) > 2) {
    goto _l105;
  }
  if ((*x_) < t_[(*ileft_) - 1] || (*x_) > t_[(*ileft_) + 1 - 1]) {
    goto _l110;
  }
  switch ((*index_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  (*iwork_) = 1;
  vnikx_[0] = 1.0;
  if ((*iwork_) >= (*jhigh_)) {
    goto _l40;
  }
  _l20:;
  ipj_ = (*ileft_) + (*iwork_);
  work_[(*iwork_) - 1] = t_[ipj_ - 1] - (*x_);
  imjp1_ = (*ileft_) - (*iwork_) + 1;
  work_[(*k_) + (*iwork_) - 1] = (*x_) - t_[imjp1_ - 1];
  vmprev_ = 0.0;
  jp1_ = (*iwork_) + 1;
  for (l_ = 1; l_ <= (*iwork_); (l_)++) {
    jp1ml_ = jp1_ - l_;
    vm_ = vnikx_[l_ - 1] / (work_[l_ - 1] + work_[(*k_) + jp1ml_ - 1]);
    vnikx_[l_ - 1] = vm_ * work_[l_ - 1] + vmprev_;
    vmprev_ = vm_ * work_[(*k_) + jp1ml_ - 1];
  }
  vnikx_[jp1_ - 1] = vmprev_;
  (*iwork_) = jp1_;
  if ((*iwork_) < (*jhigh_)) {
    goto _l20;
  }
  _l40:;
  goto _l0;
  _l90:;
  (void) _xermsg (_dc_0, _dc_10, _dc_2, ($0_ = 2, &$0_), &_k1);
  goto _l0;
  _l100:;
  (void) _xermsg (_dc_0, _dc_10, _dc_6, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l105:;
  (void) _xermsg (_dc_0, _dc_10, _dc_7, ($2_ = 2, &$2_), &_k1);
  goto _l0;
  _l110:;
  (void) _xermsg (_dc_0, _dc_10, _dc_8, ($3_ = 2, &$3_), &_k1);
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _defc (int_4 _p_ ndata_, real_8 _p_ xdata_, real_8 _p_ ydata_, real_8 _p_ sddata_, int_4 _p_ nord_, int_4 _p_ 
nbkpt_, real_8 _p_ bkpt_, int_4 _p_ mdein_, int_4 _p_ mdeout_, real_8 _p_ coeff_, int_4 _p_ lw_, real_8 _p_ w_)
{
  static int_4 lbf_, lbkpt_, lg_, lptemp_, lww_, lxtemp_, mdg_, mdw_;
  extern int_4 _defcmn ();
  mdg_ = (*nbkpt_) + 1;
  mdw_ = (*nbkpt_) - (*nord_) + 3;
  lww_ = 1;
  lg_ = lww_ + mdw_ * ((*nord_) + 1);
  lxtemp_ = lg_ + mdg_ * ((*nord_) + 1);
  lptemp_ = lxtemp_ + _max ((*ndata_), (*nbkpt_));
  lbkpt_ = lptemp_ + _max ((*ndata_), (*nbkpt_));
  lbf_ = lbkpt_ + (*nbkpt_);
  (void) _defcmn (ndata_, xdata_, ydata_, sddata_, nord_, nbkpt_, bkpt_, mdein_, mdeout_, coeff_, &w_[lbf_ - 1], 
  &w_[lxtemp_ - 1], &w_[lptemp_ - 1], &w_[lbkpt_ - 1], &w_[lg_ - 1], &mdg_, &w_[lww_ - 1], &mdw_, lw_);
  __calls[9].calls++;
  return 0;
}

int_4 _dfc (int_4 _p_ ndata_, real_8 _p_ xdata_, real_8 _p_ ydata_, real_8 _p_ sddata_, int_4 _p_ nord_, int_4 _p_ 
nbkpt_, real_8 _p_ bkpt_, int_4 _p_ nconst_, real_8 _p_ xconst_, real_8 _p_ yconst_, int_4 _p_ nderiv_, int_4 _p_ mode_
, real_8 _p_ coeff_, real_8 _p_ w_, int_4 _p_ iw_)
{
  static int_4 i1_, i2_, i3_, i4_, i5_, i6_, i7_, mdg_, mdw_;
  extern int_4 _dfcmn ();
  mdg_ = (*nbkpt_) - (*nord_) + 3;
  mdw_ = (*nbkpt_) - (*nord_) + 1 + (*nconst_);
  i1_ = 1;
  i2_ = i1_ + mdg_ * ((*nord_) + 1);
  i3_ = i2_ + _max ((*ndata_), (*nbkpt_));
  i4_ = i3_ + _max ((*ndata_), (*nbkpt_));
  i5_ = i4_ + (*nbkpt_);
  i6_ = i5_ + (*nord_) * (*nord_);
  i7_ = i6_ + mdw_ * ((*nbkpt_) - (*nord_) + 1);
  (void) _dfcmn (ndata_, xdata_, ydata_, sddata_, nord_, nbkpt_, bkpt_, nconst_, xconst_, yconst_, nderiv_, mode_, 
  coeff_, &w_[i5_ - 1], &w_[i2_ - 1], &w_[i3_ - 1], &w_[i4_ - 1], &w_[i1_ - 1], &mdg_, &w_[i6_ - 1], &mdw_, &w_[i7_ - 1], 
  iw_);
  __calls[10].calls++;
  return 0;
}

int_4 _dintrv (real_8 _p_ xt_, int_4 _p_ lxt_, real_8 _p_ x_, int_4 _p_ ilo_, int_4 _p_ ileft_, int_4 _p_ mflag_)
{
  static int_4 ihi_, istep_, middle_;
  ihi_ = (*ilo_) + 1;
  if (ihi_ < (*lxt_)) {
    goto _l10;
  }
  if ((*x_) >= xt_[(*lxt_) - 1]) {
    goto _l110;
  }
  if ((*lxt_) <= 1) {
    goto _l90;
  }
  (*ilo_) = (*lxt_) - 1;
  ihi_ = (*lxt_);
  _l10:;
  if ((*x_) >= xt_[ihi_ - 1]) {
    goto _l40;
  }
  if ((*x_) >= xt_[(*ilo_) - 1]) {
    goto _l100;
  }
  istep_ = 1;
  _l20:;
  ihi_ = (*ilo_);
  (*ilo_) = ihi_ - istep_;
  if ((*ilo_) <= 1) {
    goto _l30;
  }
  if ((*x_) >= xt_[(*ilo_) - 1]) {
    goto _l70;
  }
  istep_ = istep_ * 2;
  goto _l20;
  _l30:;
  (*ilo_) = 1;
  if ((*x_) < xt_[0]) {
    goto _l90;
  }
  goto _l70;
  _l40:;
  istep_ = 1;
  _l50:;
  (*ilo_) = ihi_;
  ihi_ = (*ilo_) + istep_;
  if (ihi_ >= (*lxt_)) {
    goto _l60;
  }
  if ((*x_) < xt_[ihi_ - 1]) {
    goto _l70;
  }
  istep_ = istep_ * 2;
  goto _l50;
  _l60:;
  if ((*x_) >= xt_[(*lxt_) - 1]) {
    goto _l110;
  }
  ihi_ = (*lxt_);
  _l70:;
  middle_ = ((*ilo_) + ihi_) / 2;
  if (middle_ == (*ilo_)) {
    goto _l100;
  }
  if ((*x_) < xt_[middle_ - 1]) {
    goto _l80;
  }
  (*ilo_) = middle_;
  goto _l70;
  _l80:;
  ihi_ = middle_;
  goto _l70;
  _l90:;
  (*mflag_) = -1;
  (*ileft_) = 1;
  goto _l0;
  _l100:;
  (*mflag_) = 0;
  (*ileft_) = (*ilo_);
  goto _l0;
  _l110:;
  (*mflag_) = 1;
  (*ileft_) = (*lxt_);
  _l0:;
  __calls[11].calls++;
  return 0;
}

real_8 _dpchdf (int_4 _p_ k_, real_8 _p_ x_, real_8 _p_ s_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  static real_8 value_, zero_;
  int_4 _data_k_0;
  real_8 dpchdf_;
#define _data_n_0 1
  static real_8 _data_l_0[_data_n_0] = {
    0.0e0
  };
  if (__calls[12].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    zero_ = _data_l_0[_data_k_0++];
  }
  if ((*k_) < 3) {
    goto _l5001;
  }
  for (j_ = 2; j_ <= (*k_) - 1; (j_)++) {
    for (i_ = 1; i_ <= (*k_) - j_; (i_)++) {
      s_[i_ - 1] = (s_[i_ + 1 - 1] - s_[i_ - 1]) / (x_[i_ + j_ - 1] - x_[i_ - 1]);
    }
  }
  value_ = s_[0];
  for (i_ = 2; i_ <= (*k_) - 1; (i_)++) {
    value_ = s_[i_ - 1] + value_ * (x_[(*k_) - 1] - x_[i_ - 1]);
  }
  (*ierr_) = 0;
  dpchdf_ = value_;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_11, _dc_12, ierr_, &_k1);
  dpchdf_ = zero_;
  _l0:;
  __calls[12].calls++;
  return dpchdf_;
}

int_4 _efc (int_4 _p_ ndata_, real_4 _p_ xdata_, real_4 _p_ ydata_, real_4 _p_ sddata_, int_4 _p_ nord_, int_4 _p_ 
nbkpt_, real_4 _p_ bkpt_, int_4 _p_ mdein_, int_4 _p_ mdeout_, real_4 _p_ coeff_, int_4 _p_ lw_, real_4 _p_ w_)
{
  static int_4 lbf_, lbkpt_, lg_, lptemp_, lww_, lxtemp_, mdg_, mdw_;
  extern int_4 _efcmn ();
  mdg_ = (*nbkpt_) + 1;
  mdw_ = (*nbkpt_) - (*nord_) + 3;
  lww_ = 1;
  lg_ = lww_ + mdw_ * ((*nord_) + 1);
  lxtemp_ = lg_ + mdg_ * ((*nord_) + 1);
  lptemp_ = lxtemp_ + _max ((*ndata_), (*nbkpt_));
  lbkpt_ = lptemp_ + _max ((*ndata_), (*nbkpt_));
  lbf_ = lbkpt_ + (*nbkpt_);
  (void) _efcmn (ndata_, xdata_, ydata_, sddata_, nord_, nbkpt_, bkpt_, mdein_, mdeout_, coeff_, &w_[lbf_ - 1], 
  &w_[lxtemp_ - 1], &w_[lptemp_ - 1], &w_[lbkpt_ - 1], &w_[lg_ - 1], &mdg_, &w_[lww_ - 1], &mdw_, lw_);
  __calls[13].calls++;
  return 0;
}

int_4 _fc (int_4 _p_ ndata_, real_4 _p_ xdata_, real_4 _p_ ydata_, real_4 _p_ sddata_, int_4 _p_ nord_, int_4 _p_ 
nbkpt_, real_4 _p_ bkpt_, int_4 _p_ nconst_, real_4 _p_ xconst_, real_4 _p_ yconst_, int_4 _p_ nderiv_, int_4 _p_ mode_
, real_4 _p_ coeff_, real_4 _p_ w_, int_4 _p_ iw_)
{
  static int_4 i1_, i2_, i3_, i4_, i5_, i6_, i7_, mdg_, mdw_;
  extern int_4 _fcmn ();
  mdg_ = (*nbkpt_) - (*nord_) + 3;
  mdw_ = (*nbkpt_) - (*nord_) + 1 + (*nconst_);
  i1_ = 1;
  i2_ = i1_ + mdg_ * ((*nord_) + 1);
  i3_ = i2_ + _max ((*ndata_), (*nbkpt_));
  i4_ = i3_ + _max ((*ndata_), (*nbkpt_));
  i5_ = i4_ + (*nbkpt_);
  i6_ = i5_ + (*nord_) * (*nord_);
  i7_ = i6_ + mdw_ * ((*nbkpt_) - (*nord_) + 1);
  (void) _fcmn (ndata_, xdata_, ydata_, sddata_, nord_, nbkpt_, bkpt_, nconst_, xconst_, yconst_, nderiv_, mode_, coeff_, 
  &w_[i5_ - 1], &w_[i2_ - 1], &w_[i3_ - 1], &w_[i4_ - 1], &w_[i1_ - 1], &mdg_, &w_[i6_ - 1], &mdw_, &w_[i7_ - 1], iw_);
  __calls[14].calls++;
  return 0;
}

int_4 _intrv (real_4 _p_ xt_, int_4 _p_ lxt_, real_4 _p_ x_, int_4 _p_ ilo_, int_4 _p_ ileft_, int_4 _p_ mflag_)
{
  static int_4 ihi_, istep_, middle_;
  ihi_ = (*ilo_) + 1;
  if (ihi_ < (*lxt_)) {
    goto _l10;
  }
  if ((*x_) >= xt_[(*lxt_) - 1]) {
    goto _l110;
  }
  if ((*lxt_) <= 1) {
    goto _l90;
  }
  (*ilo_) = (*lxt_) - 1;
  ihi_ = (*lxt_);
  _l10:;
  if ((*x_) >= xt_[ihi_ - 1]) {
    goto _l40;
  }
  if ((*x_) >= xt_[(*ilo_) - 1]) {
    goto _l100;
  }
  istep_ = 1;
  _l20:;
  ihi_ = (*ilo_);
  (*ilo_) = ihi_ - istep_;
  if ((*ilo_) <= 1) {
    goto _l30;
  }
  if ((*x_) >= xt_[(*ilo_) - 1]) {
    goto _l70;
  }
  istep_ = istep_ * 2;
  goto _l20;
  _l30:;
  (*ilo_) = 1;
  if ((*x_) < xt_[0]) {
    goto _l90;
  }
  goto _l70;
  _l40:;
  istep_ = 1;
  _l50:;
  (*ilo_) = ihi_;
  ihi_ = (*ilo_) + istep_;
  if (ihi_ >= (*lxt_)) {
    goto _l60;
  }
  if ((*x_) < xt_[ihi_ - 1]) {
    goto _l70;
  }
  istep_ = istep_ * 2;
  goto _l50;
  _l60:;
  if ((*x_) >= xt_[(*lxt_) - 1]) {
    goto _l110;
  }
  ihi_ = (*lxt_);
  _l70:;
  middle_ = ((*ilo_) + ihi_) / 2;
  if (middle_ == (*ilo_)) {
    goto _l100;
  }
  if ((*x_) < xt_[middle_ - 1]) {
    goto _l80;
  }
  (*ilo_) = middle_;
  goto _l70;
  _l80:;
  ihi_ = middle_;
  goto _l70;
  _l90:;
  (*mflag_) = -1;
  (*ileft_) = 1;
  goto _l0;
  _l100:;
  (*mflag_) = 0;
  (*ileft_) = (*ilo_);
  goto _l0;
  _l110:;
  (*mflag_) = 1;
  (*ileft_) = (*lxt_);
  _l0:;
  __calls[15].calls++;
  return 0;
}

real_4 _pchdf (int_4 _p_ k_, real_4 _p_ x_, real_4 _p_ s_, int_4 _p_ ierr_)
{
  static int_4 i_, j_;
  static real_4 value_, zero_;
  int_4 _data_k_1;
  real_4 pchdf_;
#define _data_n_1 1
  static real_4 _data_l_1[_data_n_1] = {
    0.0
  };
  if (__calls[16].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    zero_ = _data_l_1[_data_k_1++];
  }
  if ((*k_) < 3) {
    goto _l5001;
  }
  for (j_ = 2; j_ <= (*k_) - 1; (j_)++) {
    for (i_ = 1; i_ <= (*k_) - j_; (i_)++) {
      s_[i_ - 1] = (s_[i_ + 1 - 1] - s_[i_ - 1]) / (x_[i_ + j_ - 1] - x_[i_ - 1]);
    }
  }
  value_ = s_[0];
  for (i_ = 2; i_ <= (*k_) - 1; (i_)++) {
    value_ = s_[i_ - 1] + value_ * (x_[(*k_) - 1] - x_[i_ - 1]);
  }
  (*ierr_) = 0;
  pchdf_ = value_;
  goto _l0;
  _l5001:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_0, _dc_13, _dc_12, ierr_, &_k1);
  pchdf_ = zero_;
  _l0:;
  __calls[16].calls++;
  return pchdf_;
}

int_4 _pchdoc (void)
{
  __calls[17].calls++;
  return 0;
}

