//! @file mathlib-slatec-sdrive.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 36 subprograms from SLATEC-SDRIVE

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CDCOR  CDPSC  CDRIV3 DDCOR  DDPSC  DDRIV3 SDCOR  SDNTP  SDRIV1 SDSCL
// CDCST  CDPST  CDSCL  DDCST  DDPST  DDSCL  SDCST  SDPSC  SDRIV2 SDSTP
// CDNTL  CDRIV1 CDSTP  DDNTL  DDRIV1 DDSTP  SDNTL  SDPST  SDRIV3 SDZRO
// CDNTP  CDRIV2 CDZRO  DDNTP  DDRIV2 DDZRO

// SDRIVE routines from SLATEC.
// 
// Source: netlib.org/slatec/

// The license for SLATEC Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 "SLATEC"
#define _dc_1 "CDRIV1"
#define _dc_2 "Illegal input.  The magnitude of MSTATE, "
#define _dc_3 ", is not in the range 1 to 6 ."
#define _dc_4 "Illegal input.  The magnitude of MSTATE is 7 ."
#define _dc_5 "Illegal input.  The number of equations, "
#define _dc_6 ", is greater than the maximum allowed: 200 ."
#define _dc_7 "Insufficient storage allocated for the work array.  "
#define _dc_8 "The required storage is at least "
#define _dc_9 " ."
#define _dc_10 "CDRIV2"
#define _dc_11 "Illegal input.  The magnitude of MSTATE IS 9 ."
#define _dc_12 " is not in the range 1 to 8 ."
#define _dc_13 "Illegal input.  Improper value for the integration method "
#define _dc_14 "flag, "
#define _dc_15 "CDRIV3"
#define _dc_16 "Illegal input.  The value of NSTATE is 12 ."
#define _dc_17 "Illegal input.  Improper value for NSTATE(= "
#define _dc_18 ")."
#define _dc_19 "Illegal input.  EPS, "
#define _dc_20 ", is negative."
#define _dc_21 "Illegal input.  Number of equations, "
#define _dc_22 ", is not positive."
#define _dc_23 "Illegal input.  Maximum order, "
#define _dc_24 "Illegal input.  Improper value for MITER(= "
#define _dc_25 "Illegal input.  Improper value for IMPL(= "
#define _dc_26 "Illegal input.  For MINT = 3, the value of MITER, "
#define _dc_27 ", and/or IMPL, "
#define _dc_28 ", is not allowed."
#define _dc_29 "Illegal input.  For MITER = 0, the value of IMPL, "
#define _dc_30 "Illegal input.  For MINT = 1, the value of IMPL, "
#define _dc_31 "Illegal input.  Insufficient storage allocated for the "
#define _dc_32 "IWORK array.  Based on the value of the input parameters "
#define _dc_33 "involved, the required storage is "
#define _dc_34 "WORK array.  Based on the value of the input parameters "
#define _dc_35 "While integrating exactly to TOUT, T, "
#define _dc_36 ", was beyond TOUT, "
#define _dc_37 " .  Solution obtained by "
#define _dc_38 "interpolation."
#define _dc_39 "At T, "
#define _dc_40 ", the requested accuracy, EPS, was not "
#define _dc_41 "obtainable with the machine precision.  EPS has been "
#define _dc_42 "increased to "
#define _dc_43 ", the step size, "
#define _dc_44 ", is smaller "
#define _dc_45 "than the roundoff level of T.  This may occur if there is "
#define _dc_46 "an abrupt change in the right hand side of the "
#define _dc_47 "differential equations."
#define _dc_48 ", "
#define _dc_49 " steps have been taken "
#define _dc_50 "without reaching TOUT, "
#define _dc_51 ", the attempted step size has gone to "
#define _dc_52 "zero.  Often this occurs if the problem setup is incorrect."
#define _dc_53 ", the step size has been reduced about 50 "
#define _dc_54 "times without advancing the solution.  Often this occurs "
#define _dc_55 "if the problem setup is incorrect."
#define _dc_56 ", while solving A*YDOT = F, A is singular."
#define _dc_57 "DDRIV1"
#define _dc_58 "DDRIV2"
#define _dc_59 "DDRIV3"
#define _dc_60 "SDRIV1"
#define _dc_61 "SDRIV2"
#define _dc_62 "SDRIV3"
static FORMAT *__fmt_a = NULL;
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
typedef char char_127[128];
typedef char char_255[256];
typedef char char_511[512];
typedef char char_1023[1024];
typedef char char_2047[2048];
typedef char char_4095[4096];
#define __ncalls 37
static CALLS __calls[__ncalls] = {
  {"cdcor", 0}, // subroutine
  {"cdcst", 0}, // subroutine
  {"cdntl", 0}, // subroutine
  {"cdntp", 0}, // subroutine
  {"cdpsc", 0}, // subroutine
  {"cdpst", 0}, // subroutine
  {"cdriv1", 0}, // subroutine
  {"cdriv2", 0}, // subroutine
  {"cdriv3", 0}, // subroutine
  {"cdscl", 0}, // subroutine
  {"cdstp", 0}, // subroutine
  {"cdzro", 0}, // subroutine
  {"ddcor", 0}, // subroutine
  {"ddcst", 0}, // subroutine
  {"ddntl", 0}, // subroutine
  {"ddntp", 0}, // subroutine
  {"ddpsc", 0}, // subroutine
  {"ddpst", 0}, // subroutine
  {"ddriv1", 0}, // subroutine
  {"ddriv2", 0}, // subroutine
  {"ddriv3", 0}, // subroutine
  {"ddscl", 0}, // subroutine
  {"ddstp", 0}, // subroutine
  {"ddzro", 0}, // subroutine
  {"sdcor", 0}, // subroutine
  {"sdcst", 0}, // subroutine
  {"sdntl", 0}, // subroutine
  {"sdntp", 0}, // subroutine
  {"sdpsc", 0}, // subroutine
  {"sdpst", 0}, // subroutine
  {"sdriv1", 0}, // subroutine
  {"sdriv2", 0}, // subroutine
  {"sdriv3", 0}, // subroutine
  {"sdscl", 0}, // subroutine
  {"sdstp", 0}, // subroutine
  {"sdzro", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _cdcor (complex_8 _p_ dfdy_, real_4 _p_ el_, int_4 (*_fa)(), real_4 _p_ h_, int_4 _p_ ierror_, int_4 
_p_ impl_, int_4 _p_ ipvt_, int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ 
nde_, int_4 _p_ nq_, real_4 _p_ t_, int_4 (*_users)(), complex_8 _p_ y_, complex_8 _p_ yh_, complex_8 _p_ ywt_, 
logical_4 _p_ evalfa_, complex_8 _p_ save1_, complex_8 _p_ save2_, complex_8 _p_ a_, real_4 _p_ d_, int_4 _p_ jstate_);
prototype int_4 _cdcst (int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ iswflg_, real_4 _p_ el_, real_4 _p_ tq_);
prototype int_4 _cdntl (real_4 _p_ eps_, int_4 (*_f)(), int_4 (*_fa)(), real_4 _p_ hmax_, real_4 _p_ hold_, int_4 _p_ 
impl_, int_4 _p_ jtask_, int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 
_p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, complex_8 _p_ save1_, real_4 _p_ t_, real_4 _p_ uround_, int_4 (*_users)(), 
complex_8 _p_ y_, complex_8 _p_ ywt_, real_4 _p_ h_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, real_4 _p_ 
rc_, complex_8 _p_ yh_, complex_8 _p_ a_, logical_4 _p_ convrg_, real_4 _p_ el_, complex_8 _p_ fac_, logical_4 _p_ ier_
, int_4 _p_ ipvt_, int_4 _p_ nq_, int_4 _p_ nwait_, real_4 _p_ rh_, real_4 _p_ rmax_, complex_8 _p_ save2_, real_4 _p_ 
tq_, real_4 _p_ trend_, int_4 _p_ iswflg_, int_4 _p_ jstate_);
prototype int_4 _cdntp (real_4 _p_ h_, int_4 _p_ k_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ t_, real_4 _p_ tout_, 
complex_8 _p_ yh_, complex_8 _p_ y_);
prototype int_4 _cdpsc (int_4 _p_ ksgn_, int_4 _p_ n_, int_4 _p_ nq_, complex_8 _p_ yh_);
prototype int_4 _cdpst (real_4 _p_ el_, int_4 (*_f)(), int_4 (*_fa)(), real_4 _p_ h_, int_4 _p_ impl_, int_4 
(*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 
_p_ nq_, complex_8 _p_ save2_, real_4 _p_ t_, int_4 (*_users)(), complex_8 _p_ y_, complex_8 _p_ yh_, complex_8 _p_ 
ywt_, real_4 _p_ uround_, int_4 _p_ nfe_, int_4 _p_ nje_, complex_8 _p_ a_, complex_8 _p_ dfdy_, complex_8 _p_ fac_, 
logical_4 _p_ ier_, int_4 _p_ ipvt_, complex_8 _p_ save1_, int_4 _p_ iswflg_, real_4 _p_ bnd_, int_4 _p_ jstate_);
prototype int_4 _cdriv1 (int_4 _p_ n_, real_4 _p_ t_, complex_8 _p_ y_, real_4 (*_f)(), real_4 _p_ tout_, int_4 _p_ 
mstate_, real_4 _p_ eps_, complex_8 _p_ work_, int_4 _p_ lenw_, int_4 _p_ ierflg_);
prototype int_4 _cdriv2 (int_4 _p_ n_, real_4 _p_ t_, complex_8 _p_ y_, real_4 (*_f)(), real_4 _p_ tout_, int_4 _p_ 
mstate_, int_4 _p_ nroot_, real_4 _p_ eps_, real_4 _p_ ewt_, int_4 _p_ mint_, complex_8 _p_ work_, int_4 _p_ lenw_, 
int_4 _p_ iwork_, int_4 _p_ leniw_, real_4 (*_g)(), int_4 _p_ ierflg_);
prototype int_4 _cdriv3 (int_4 _p_ n_, real_4 _p_ t_, complex_8 _p_ y_, int_4 (*_f)(), int_4 _p_ nstate_, real_4 _p_ 
tout_, int_4 _p_ ntask_, int_4 _p_ nroot_, real_4 _p_ eps_, real_4 _p_ ewt_, int_4 _p_ ierror_, int_4 _p_ mint_, int_4 
_p_ miter_, int_4 _p_ impl_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ mxord_, real_4 _p_ hmax_, complex_8 _p_ work_, 
int_4 _p_ lenw_, int_4 _p_ iwork_, int_4 _p_ leniw_, int_4 (*_jacobn)(), int_4 (*_fa)(), int_4 _p_ nde_, int_4 _p_ 
mxstep_, real_4 (*_g)(), int_4 (*_users)(), int_4 _p_ ierflg_);
prototype int_4 _cdscl (real_4 _p_ hmax_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ rmax_, real_4 _p_ h_, real_4 _p_ rc_, 
real_4 _p_ rh_, complex_8 _p_ yh_);
prototype int_4 _cdstp (real_4 _p_ eps_, int_4 (*_f)(), real_4 (*_fa)(), real_4 _p_ hmax_, int_4 _p_ impl_, int_4 _p_ 
ierror_, int_4 (*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, 
int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, complex_8 _p_ ywt_, real_4 _p_ uround_, real_4 (*_users)(), real_4 _p_ 
avgh_, real_4 _p_ avgord_, real_4 _p_ h_, real_4 _p_ hused_, int_4 _p_ jtask_, int_4 _p_ mntold_, int_4 _p_ mtrold_, 
int_4 _p_ nfe_, int_4 _p_ nje_, int_4 _p_ nqused_, int_4 _p_ nstep_, real_4 _p_ t_, complex_8 _p_ y_, complex_8 _p_ yh_
, complex_8 _p_ a_, logical_4 _p_ convrg_, complex_8 _p_ dfdy_, real_4 _p_ el_, complex_8 _p_ fac_, real_4 _p_ hold_, 
int_4 _p_ ipvt_, int_4 _p_ jstate_, int_4 _p_ jstepl_, int_4 _p_ nq_, int_4 _p_ nwait_, real_4 _p_ rc_, real_4 _p_ 
rmax_, complex_8 _p_ save1_, complex_8 _p_ save2_, real_4 _p_ tq_, real_4 _p_ trend_, int_4 _p_ iswflg_, int_4 _p_ 
mtrsv_, int_4 _p_ mxrdsv_);
prototype int_4 _cdzro (real_4 _p_ ae_, real_4 (*_f)(), real_4 _p_ h_, int_4 _p_ n_, int_4 _p_ nq_, int_4 _p_ iroot_, 
real_4 _p_ re_, real_4 _p_ t_, complex_8 _p_ yh_, real_4 _p_ uround_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ fb_, 
real_4 _p_ fc_, complex_8 _p_ y_);
prototype int_4 _ddcor (real_8 _p_ dfdy_, real_8 _p_ el_, int_4 (*_fa)(), real_8 _p_ h_, int_4 _p_ ierror_, int_4 _p_ 
impl_, int_4 _p_ ipvt_, int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_
, int_4 _p_ nq_, real_8 _p_ t_, int_4 (*_users)(), real_8 _p_ y_, real_8 _p_ yh_, real_8 _p_ ywt_, logical_4 _p_ 
evalfa_, real_8 _p_ save1_, real_8 _p_ save2_, real_8 _p_ a_, real_8 _p_ d_, int_4 _p_ jstate_);
prototype int_4 _ddcst (int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ iswflg_, real_8 _p_ el_, real_8 _p_ tq_);
prototype int_4 _ddntl (real_8 _p_ eps_, int_4 (*_f)(), int_4 (*_fa)(), real_8 _p_ hmax_, real_8 _p_ hold_, int_4 _p_ 
impl_, int_4 _p_ jtask_, int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 
_p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, real_8 _p_ save1_, real_8 _p_ t_, real_8 _p_ uround_, int_4 (*_users)(), real_8 
_p_ y_, real_8 _p_ ywt_, real_8 _p_ h_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, real_8 _p_ rc_, real_8 
_p_ yh_, real_8 _p_ a_, logical_4 _p_ convrg_, real_8 _p_ el_, real_8 _p_ fac_, logical_4 _p_ ier_, int_4 _p_ ipvt_, 
int_4 _p_ nq_, int_4 _p_ nwait_, real_8 _p_ rh_, real_8 _p_ rmax_, real_8 _p_ save2_, real_8 _p_ tq_, real_8 _p_ trend_
, int_4 _p_ iswflg_, int_4 _p_ jstate_);
prototype int_4 _ddntp (real_8 _p_ h_, int_4 _p_ k_, int_4 _p_ n_, int_4 _p_ nq_, real_8 _p_ t_, real_8 _p_ tout_, 
real_8 _p_ yh_, real_8 _p_ y_);
prototype int_4 _ddpsc (int_4 _p_ ksgn_, int_4 _p_ n_, int_4 _p_ nq_, real_8 _p_ yh_);
prototype int_4 _ddpst (real_8 _p_ el_, int_4 (*_f)(), int_4 (*_fa)(), real_8 _p_ h_, int_4 _p_ impl_, int_4 
(*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 
_p_ nq_, real_8 _p_ save2_, real_8 _p_ t_, int_4 (*_users)(), real_8 _p_ y_, real_8 _p_ yh_, real_8 _p_ ywt_, real_8 
_p_ uround_, int_4 _p_ nfe_, int_4 _p_ nje_, real_8 _p_ a_, real_8 _p_ dfdy_, real_8 _p_ fac_, logical_4 _p_ ier_, 
int_4 _p_ ipvt_, real_8 _p_ save1_, int_4 _p_ iswflg_, real_8 _p_ bnd_, int_4 _p_ jstate_);
prototype int_4 _ddriv1 (int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ y_, real_4 (*_f)(), real_8 _p_ tout_, int_4 _p_ 
mstate_, real_8 _p_ eps_, real_8 _p_ work_, int_4 _p_ lenw_, int_4 _p_ ierflg_);
prototype int_4 _ddriv2 (int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ y_, real_4 (*_f)(), real_8 _p_ tout_, int_4 _p_ 
mstate_, int_4 _p_ nroot_, real_8 _p_ eps_, real_8 _p_ ewt_, int_4 _p_ mint_, real_8 _p_ work_, int_4 _p_ lenw_, int_4 
_p_ iwork_, int_4 _p_ leniw_, real_8 (*_g)(), int_4 _p_ ierflg_);
prototype int_4 _ddriv3 (int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ y_, int_4 (*_f)(), int_4 _p_ nstate_, real_8 _p_ tout_
, int_4 _p_ ntask_, int_4 _p_ nroot_, real_8 _p_ eps_, real_8 _p_ ewt_, int_4 _p_ ierror_, int_4 _p_ mint_, int_4 _p_ 
miter_, int_4 _p_ impl_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ mxord_, real_8 _p_ hmax_, real_8 _p_ work_, int_4 _p_ 
lenw_, int_4 _p_ iwork_, int_4 _p_ leniw_, int_4 (*_jacobn)(), int_4 (*_fa)(), int_4 _p_ nde_, int_4 _p_ mxstep_, 
real_8 (*_g)(), int_4 (*_users)(), int_4 _p_ ierflg_);
prototype int_4 _ddscl (real_8 _p_ hmax_, int_4 _p_ n_, int_4 _p_ nq_, real_8 _p_ rmax_, real_8 _p_ h_, real_8 _p_ rc_, 
real_8 _p_ rh_, real_8 _p_ yh_);
prototype int_4 _ddstp (real_8 _p_ eps_, int_4 (*_f)(), real_4 (*_fa)(), real_8 _p_ hmax_, int_4 _p_ impl_, int_4 _p_ 
ierror_, int_4 (*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, 
int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, real_8 _p_ ywt_, real_8 _p_ uround_, real_4 (*_users)(), real_8 _p_ avgh_, 
real_8 _p_ avgord_, real_8 _p_ h_, real_8 _p_ hused_, int_4 _p_ jtask_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ 
nfe_, int_4 _p_ nje_, int_4 _p_ nqused_, int_4 _p_ nstep_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ yh_, real_8 _p_ a_, 
logical_4 _p_ convrg_, real_8 _p_ dfdy_, real_8 _p_ el_, real_8 _p_ fac_, real_8 _p_ hold_, int_4 _p_ ipvt_, int_4 _p_ 
jstate_, int_4 _p_ jstepl_, int_4 _p_ nq_, int_4 _p_ nwait_, real_8 _p_ rc_, real_8 _p_ rmax_, real_8 _p_ save1_, 
real_8 _p_ save2_, real_8 _p_ tq_, real_8 _p_ trend_, int_4 _p_ iswflg_, int_4 _p_ mtrsv_, int_4 _p_ mxrdsv_);
prototype int_4 _ddzro (real_8 _p_ ae_, real_8 (*_f)(), real_8 _p_ h_, int_4 _p_ n_, int_4 _p_ nq_, int_4 _p_ iroot_, 
real_8 _p_ re_, real_8 _p_ t_, real_8 _p_ yh_, real_8 _p_ uround_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ fb_, real_8 
_p_ fc_, real_8 _p_ y_);
prototype int_4 _sdcor (real_4 _p_ dfdy_, real_4 _p_ el_, int_4 (*_fa)(), real_4 _p_ h_, int_4 _p_ ierror_, int_4 _p_ 
impl_, int_4 _p_ ipvt_, int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_
, int_4 _p_ nq_, real_4 _p_ t_, int_4 (*_users)(), real_4 _p_ y_, real_4 _p_ yh_, real_4 _p_ ywt_, logical_4 _p_ 
evalfa_, real_4 _p_ save1_, real_4 _p_ save2_, real_4 _p_ a_, real_4 _p_ d_, int_4 _p_ jstate_);
prototype int_4 _sdcst (int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ iswflg_, real_4 _p_ el_, real_4 _p_ tq_);
prototype int_4 _sdntl (real_4 _p_ eps_, int_4 (*_f)(), int_4 (*_fa)(), real_4 _p_ hmax_, real_4 _p_ hold_, int_4 _p_ 
impl_, int_4 _p_ jtask_, int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 
_p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, real_4 _p_ save1_, real_4 _p_ t_, real_4 _p_ uround_, int_4 (*_users)(), real_4 
_p_ y_, real_4 _p_ ywt_, real_4 _p_ h_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, real_4 _p_ rc_, real_4 
_p_ yh_, real_4 _p_ a_, logical_4 _p_ convrg_, real_4 _p_ el_, real_4 _p_ fac_, logical_4 _p_ ier_, int_4 _p_ ipvt_, 
int_4 _p_ nq_, int_4 _p_ nwait_, real_4 _p_ rh_, real_4 _p_ rmax_, real_4 _p_ save2_, real_4 _p_ tq_, real_4 _p_ trend_
, int_4 _p_ iswflg_, int_4 _p_ jstate_);
prototype int_4 _sdntp (real_4 _p_ h_, int_4 _p_ k_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ t_, real_4 _p_ tout_, 
real_4 _p_ yh_, real_4 _p_ y_);
prototype int_4 _sdpsc (int_4 _p_ ksgn_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ yh_);
prototype int_4 _sdpst (real_4 _p_ el_, int_4 (*_f)(), int_4 (*_fa)(), real_4 _p_ h_, int_4 _p_ impl_, int_4 
(*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 
_p_ nq_, real_4 _p_ save2_, real_4 _p_ t_, int_4 (*_users)(), real_4 _p_ y_, real_4 _p_ yh_, real_4 _p_ ywt_, real_4 
_p_ uround_, int_4 _p_ nfe_, int_4 _p_ nje_, real_4 _p_ a_, real_4 _p_ dfdy_, real_4 _p_ fac_, logical_4 _p_ ier_, 
int_4 _p_ ipvt_, real_4 _p_ save1_, int_4 _p_ iswflg_, real_4 _p_ bnd_, int_4 _p_ jstate_);
prototype int_4 _sdriv1 (int_4 _p_ n_, real_4 _p_ t_, real_4 _p_ y_, real_4 (*_f)(), real_4 _p_ tout_, int_4 _p_ 
mstate_, real_4 _p_ eps_, real_4 _p_ work_, int_4 _p_ lenw_, int_4 _p_ ierflg_);
prototype int_4 _sdriv2 (int_4 _p_ n_, real_4 _p_ t_, real_4 _p_ y_, real_4 (*_f)(), real_4 _p_ tout_, int_4 _p_ 
mstate_, int_4 _p_ nroot_, real_4 _p_ eps_, real_4 _p_ ewt_, int_4 _p_ mint_, real_4 _p_ work_, int_4 _p_ lenw_, int_4 
_p_ iwork_, int_4 _p_ leniw_, real_4 (*_g)(), int_4 _p_ ierflg_);
prototype int_4 _sdriv3 (int_4 _p_ n_, real_4 _p_ t_, real_4 _p_ y_, int_4 (*_f)(), int_4 _p_ nstate_, real_4 _p_ tout_
, int_4 _p_ ntask_, int_4 _p_ nroot_, real_4 _p_ eps_, real_4 _p_ ewt_, int_4 _p_ ierror_, int_4 _p_ mint_, int_4 _p_ 
miter_, int_4 _p_ impl_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ mxord_, real_4 _p_ hmax_, real_4 _p_ work_, int_4 _p_ 
lenw_, int_4 _p_ iwork_, int_4 _p_ leniw_, int_4 (*_jacobn)(), int_4 (*_fa)(), int_4 _p_ nde_, int_4 _p_ mxstep_, 
real_4 (*_g)(), int_4 (*_users)(), int_4 _p_ ierflg_);
prototype int_4 _sdscl (real_4 _p_ hmax_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ rmax_, real_4 _p_ h_, real_4 _p_ rc_, 
real_4 _p_ rh_, real_4 _p_ yh_);
prototype int_4 _sdstp (real_4 _p_ eps_, int_4 (*_f)(), real_4 (*_fa)(), real_4 _p_ hmax_, int_4 _p_ impl_, int_4 _p_ 
ierror_, int_4 (*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, 
int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, real_4 _p_ ywt_, real_4 _p_ uround_, real_4 (*_users)(), real_4 _p_ avgh_, 
real_4 _p_ avgord_, real_4 _p_ h_, real_4 _p_ hused_, int_4 _p_ jtask_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ 
nfe_, int_4 _p_ nje_, int_4 _p_ nqused_, int_4 _p_ nstep_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ yh_, real_4 _p_ a_, 
logical_4 _p_ convrg_, real_4 _p_ dfdy_, real_4 _p_ el_, real_4 _p_ fac_, real_4 _p_ hold_, int_4 _p_ ipvt_, int_4 _p_ 
jstate_, int_4 _p_ jstepl_, int_4 _p_ nq_, int_4 _p_ nwait_, real_4 _p_ rc_, real_4 _p_ rmax_, real_4 _p_ save1_, 
real_4 _p_ save2_, real_4 _p_ tq_, real_4 _p_ trend_, int_4 _p_ iswflg_, int_4 _p_ mtrsv_, int_4 _p_ mxrdsv_);
prototype int_4 _sdzro (real_4 _p_ ae_, real_4 (*_f)(), real_4 _p_ h_, int_4 _p_ n_, int_4 _p_ nq_, int_4 _p_ iroot_, 
real_4 _p_ re_, real_4 _p_ t_, real_4 _p_ yh_, real_4 _p_ uround_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ fb_, real_4 
_p_ fc_, real_4 _p_ y_);
int_4 _cdcor (complex_8 _p_ dfdy_, real_4 _p_ el_, int_4 (*_fa)(), real_4 _p_ h_, int_4 _p_ ierror_, int_4 _p_ impl_, 
int_4 _p_ ipvt_, int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 
_p_ nq_, real_4 _p_ t_, int_4 (*_users)(), complex_8 _p_ y_, complex_8 _p_ yh_, complex_8 _p_ ywt_, logical_4 _p_ 
evalfa_, complex_8 _p_ save1_, complex_8 _p_ save2_, complex_8 _p_ a_, real_4 _p_ d_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, j_, mw_;
  extern real_4 _scnrm2 ();
  if ((*miter_) == 0) {
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = ((*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1]) / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = ((*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1]) / _max (cabsf (y_[i_ - 1]), 
        cabsf (ywt_[i_ - 1]));
      }
    }
    (*d_) = _scnrm2 (n_, save1_, &_k1) / sqrtf ((real_4) ((*n_)));
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      save1_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))];
    }
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1];
      }
    }
    else if ((*impl_) == 1) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          save2_[i_ - 1] = save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) * ((1))] + save1_[j_ - 
          1]);
        }
      }
    }
    else if ((*impl_) == 2) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((0))] * (yh_[i_ - 1 + ((*n_)) * ((1))] + 
        save1_[i_ - 1]);
      }
    }
    else if ((*impl_) == 3) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) * ((1))] + save1_[j_ - 
          1]);
        }
      }
    }
    (void) _cgesl (dfdy_, matdim_, n_, ipvt_, save2_, &_k0);
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (cabsf (y_[i_ - 1]), cabsf (ywt_[i_ - 1]));
      }
    }
    (*d_) = _scnrm2 (n_, save2_, &_k1) / sqrtf ((real_4) ((*n_)));
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1];
      }
    }
    else if ((*impl_) == 1) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      mw_ = (*ml_) + 1 + (*mu_);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          save2_[i_ + j_ - mw_ - 1] = save2_[i_ + j_ - mw_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) 
          * ((1))] + save1_[j_ - 1]);
        }
      }
    }
    else if ((*impl_) == 2) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((0))] * (yh_[i_ - 1 + ((*n_)) * ((1))] + 
        save1_[i_ - 1]);
      }
    }
    else if ((*impl_) == 3) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      mw_ = (*ml_) + 1 + (*mu_);
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*nde_) - j_, mw_ + (*ml_)); (i_)++) {
          save2_[i_ + j_ - mw_ - 1] = save2_[i_ + j_ - mw_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) 
          * ((1))] + save1_[j_ - 1]);
        }
      }
    }
    (void) _cgbsl (dfdy_, matdim_, n_, ml_, mu_, ipvt_, save2_, &_k0);
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (cabsf (y_[i_ - 1]), cabsf (ywt_[i_ - 1]));
      }
    }
    (*d_) = _scnrm2 (n_, save2_, &_k1) / sqrtf ((real_4) ((*n_)));
  }
  else if ((*miter_) == 3) {
    iflag_ = 2;
    (void) _users (y_, &yh_[0 + ((*n_)) * ((1))], ywt_, save1_, save2_, t_, h_, &el_[0 + (13) * (((*nq_) - 1))], impl_, n_, 
    nde_, &iflag_);
    if ((*n_) == 0) {
      (*jstate_) = 10;
      goto _l0;
    }
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (cabsf (y_[i_ - 1]), cabsf (ywt_[i_ - 1]));
      }
    }
    (*d_) = _scnrm2 (n_, save2_, &_k1) / sqrtf ((real_4) ((*n_)));
  }
  _l0:;
  __calls[0].calls++;
  return 0;
}

int_4 _cdcst (int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ iswflg_, real_4 _p_ el_, real_4 _p_ tq_)
{
  static int_4 i_, j_, mxrd_;
  static real_4 factrl_[12], gamma_[14], sum_;
  factrl_[0] = 1.0;
  for (i_ = 2; i_ <= (*maxord_); (i_)++) {
    factrl_[i_ - 1] = i_ * factrl_[i_ - 1 - 1];
  }
  if ((*mint_) == 1) {
    gamma_[0] = 1.0;
    for (i_ = 1; i_ <= (*maxord_) + 1; (i_)++) {
      sum_ = 0.0;
      for (j_ = 1; j_ <= i_; (j_)++) {
        sum_ = sum_ - gamma_[j_ - 1] / (i_ - j_ + 2);
      }
      gamma_[i_ + 1 - 1] = sum_;
    }
    el_[0] = 1.0;
    el_[1] = 1.0;
    el_[14] = 1.0;
    el_[15] = 1.0;
    for (j_ = 3; j_ <= (*maxord_); (j_)++) {
      el_[1 + (13) * ((j_ - 1))] = factrl_[j_ - 1 - 1];
      for (i_ = 3; i_ <= j_; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = (j_ - 1) * el_[i_ - 1 + (13) * ((j_ - 1 - 1))] + el_[i_ - 1 - 1 + (13) * ((j_ - 1 - 
        1))];
      }
      el_[j_ + 1 - 1 + (13) * ((j_ - 1))] = 1.0;
    }
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      el_[0 + (13) * ((j_ - 1))] = el_[0 + (13) * ((j_ - 1 - 1))] + gamma_[j_ - 1];
      el_[1 + (13) * ((j_ - 1))] = 1.0;
      for (i_ = 3; i_ <= j_ + 1; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = el_[i_ - 1 + (13) * ((j_ - 1))] / ((i_ - 1) * factrl_[j_ - 1 - 1]);
      }
    }
    for (j_ = 1; j_ <= (*maxord_); (j_)++) {
      tq_[0 + (3) * ((j_ - 1))] = -1.0e0 / (factrl_[j_ - 1] * gamma_[j_ - 1]);
      tq_[1 + (3) * ((j_ - 1))] = -1.0e0 / gamma_[j_ + 1 - 1];
      tq_[2 + (3) * ((j_ - 1))] = -1.0e0 / gamma_[j_ + 2 - 1];
    }
  }
  else if ((*mint_) == 2) {
    el_[0] = 1.0;
    el_[1] = 1.0;
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      el_[0 + (13) * ((j_ - 1))] = factrl_[j_ - 1];
      for (i_ = 2; i_ <= j_; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = j_ * el_[i_ - 1 + (13) * ((j_ - 1 - 1))] + el_[i_ - 1 - 1 + (13) * ((j_ - 1 - 1))];
      }
      el_[j_ + 1 - 1 + (13) * ((j_ - 1))] = 1.0;
    }
    sum_ = 1.0;
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      sum_ = sum_ + 1.0e0 / j_;
      for (i_ = 1; i_ <= j_ + 1; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = el_[i_ - 1 + (13) * ((j_ - 1))] / (factrl_[j_ - 1] * sum_);
      }
    }
    for (j_ = 1; j_ <= (*maxord_); (j_)++) {
      if (j_ > 1) {
        tq_[0 + (3) * ((j_ - 1))] = 1.0e0 / factrl_[j_ - 1 - 1];
      }
      tq_[1 + (3) * ((j_ - 1))] = (j_ + 1) / el_[0 + (13) * ((j_ - 1))];
      tq_[2 + (3) * ((j_ - 1))] = (j_ + 2) / el_[0 + (13) * ((j_ - 1))];
    }
  }
  if ((*iswflg_) == 3) {
    mxrd_ = _min ((*maxord_), 5);
    if ((*mint_) == 2) {
      gamma_[0] = 1.0;
      for (i_ = 1; i_ <= mxrd_; (i_)++) {
        sum_ = 0.0;
        for (j_ = 1; j_ <= i_; (j_)++) {
          sum_ = sum_ - gamma_[j_ - 1] / (i_ - j_ + 2);
        }
        gamma_[i_ + 1 - 1] = sum_;
      }
    }
    sum_ = 1.0;
    for (i_ = 2; i_ <= mxrd_; (i_)++) {
      sum_ = sum_ + 1.0e0 / i_;
      el_[1 + i_ - 1] = -(i_ + 1) * sum_ * gamma_[i_ + 1 - 1];
    }
  }
  __calls[1].calls++;
  return 0;
}

int_4 _cdntl (real_4 _p_ eps_, int_4 (*_f)(), int_4 (*_fa)(), real_4 _p_ hmax_, real_4 _p_ hold_, int_4 _p_ impl_, 
int_4 _p_ jtask_, int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_
, int_4 _p_ n_, int_4 _p_ nde_, complex_8 _p_ save1_, real_4 _p_ t_, real_4 _p_ uround_, int_4 (*_users)(), complex_8 
_p_ y_, complex_8 _p_ ywt_, real_4 _p_ h_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, real_4 _p_ rc_, 
complex_8 _p_ yh_, complex_8 _p_ a_, logical_4 _p_ convrg_, real_4 _p_ el_, complex_8 _p_ fac_, logical_4 _p_ ier_, 
int_4 _p_ ipvt_, int_4 _p_ nq_, int_4 _p_ nwait_, real_4 _p_ rh_, real_4 _p_ rmax_, complex_8 _p_ save2_, real_4 _p_ 
tq_, real_4 _p_ trend_, int_4 _p_ iswflg_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, info_;
  static real_4 oldl0_, sum_;
  extern real_4 _scnrm2 ();
  (*ier_) = FALSE;
  if ((*jtask_) >= 0) {
    if ((*jtask_) == 0) {
      (void) _cdcst (maxord_, mint_, iswflg_, el_, tq_);
      (*rmax_) = 10000.0;
    }
    (*rc_) = 0.0;
    (*convrg_) = FALSE;
    (*trend_) = 1.0;
    (*nq_) = 1;
    (*nwait_) = 3;
    (void) _f (n_, t_, y_, save2_);
    if ((*n_) == 0) {
      (*jstate_) = 6;
      goto _l0;
    }
    (*nfe_) = (*nfe_) + 1;
    if ((*impl_) != 0) {
      if ((*miter_) == 3) {
        iflag_ = 0;
        (void) _users (y_, yh_, ywt_, save1_, save2_, t_, h_, el_, impl_, n_, nde_, &iflag_);
        if (iflag_ == -1) {
          (*ier_) = TRUE;
          goto _l0;
        }
        if ((*n_) == 0) {
          (*jstate_) = 10;
          goto _l0;
        }
      }
      else if ((*impl_) == 1) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _cgefa (a_, matdim_, n_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _cgesl (a_, matdim_, n_, ipvt_, save2_, &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _cgbfa (a_, matdim_, n_, ml_, mu_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _cgbsl (a_, matdim_, n_, ml_, mu_, ipvt_, save2_, &_k0);
        }
      }
      else if ((*impl_) == 2) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          if (a_[i_ - 1 + ((*matdim_)) * ((0))] == 0.0e0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          else {
            save2_[i_ - 1] = save2_[i_ - 1] / a_[i_ - 1 + ((*matdim_)) * ((0))];
          }
        }
        for (i_ = (*nde_) + 1; i_ <= (*n_); (i_)++) {
          a_[i_ - 1 + ((*matdim_)) * ((0))] = 0.0;
        }
      }
      else if ((*impl_) == 3) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _cgefa (a_, matdim_, nde_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _cgesl (a_, matdim_, nde_, ipvt_, save2_, &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _cgbfa (a_, matdim_, nde_, ml_, mu_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _cgbsl (a_, matdim_, nde_, ml_, mu_, ipvt_, save2_, &_k0);
        }
      }
    }
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save1_[i_ - 1] = save2_[i_ - 1] / _max (1.0, cabsf (ywt_[i_ - 1]));
    }
    sum_ = _scnrm2 (nde_, save1_, &_k1) / sqrtf ((real_4) ((*nde_)));
    if (sum_ > (*eps_) / _abs ((*h_))) {
      (*h_) = _sign ((*eps_) / sum_, (*h_));
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((1))] = (*h_) * save2_[i_ - 1];
    }
    if ((*miter_) == 2 || (*miter_) == 5 || (*iswflg_) == 3) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        fac_[i_ - 1] = sqrtf ((*uround_));
      }
    }
  }
  else {
    if ((*miter_) != (*mtrold_)) {
      (*mtrold_) = (*miter_);
      (*rc_) = 0.0;
      (*convrg_) = FALSE;
    }
    if ((*mint_) != (*mntold_)) {
      (*mntold_) = (*mint_);
      oldl0_ = el_[0 + (13) * (((*nq_) - 1))];
      (void) _cdcst (maxord_, mint_, iswflg_, el_, tq_);
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / oldl0_;
      (*nwait_) = (*nq_) + 2;
    }
    if ((*h_) != (*hold_)) {
      (*nwait_) = (*nq_) + 2;
      (*rh_) = (*h_) / (*hold_);
      (void) _cdscl (hmax_, n_, nq_, rmax_, hold_, rc_, rh_, yh_);
    }
  }
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _cdntp (real_4 _p_ h_, int_4 _p_ k_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ t_, real_4 _p_ tout_, complex_8 _p_ 
yh_, complex_8 _p_ y_)
{
  static int_4 i_, j_, jj_, kk_, kused_;
  static real_4 factor_, r_;
  if ((*k_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))];
    }
    r_ = (((*tout_) - (*t_)) / (*h_));
    for (jj_ = 1; jj_ <= (*nq_); (jj_)++) {
      j_ = (*nq_) + 1 - jj_;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + r_ * y_[i_ - 1];
      }
    }
  }
  else {
    kused_ = _min ((*k_), (*nq_));
    factor_ = 1.0;
    for (kk_ = 1; kk_ <= kused_; (kk_)++) {
      factor_ = factor_ * ((*nq_) + 1 - kk_);
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = factor_ * yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))];
    }
    r_ = (((*tout_) - (*t_)) / (*h_));
    for (jj_ = kused_ + 1; jj_ <= (*nq_); (jj_)++) {
      j_ = kused_ + 1 + (*nq_) - jj_;
      factor_ = 1.0;
      for (kk_ = 1; kk_ <= kused_; (kk_)++) {
        factor_ = factor_ * (j_ - kk_);
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        y_[i_ - 1] = factor_ * yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + r_ * y_[i_ - 1];
      }
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = y_[i_ - 1] * _up_real_4 ((*h_), (-kused_));
    }
  }
  __calls[3].calls++;
  return 0;
}

int_4 _cdpsc (int_4 _p_ ksgn_, int_4 _p_ n_, int_4 _p_ nq_, complex_8 _p_ yh_)
{
  static int_4 i_, j_, j1_, j2_;
  if ((*ksgn_) > 0) {
    for (j1_ = 1; j1_ <= (*nq_); (j1_)++) {
      for (j2_ = j1_; j2_ <= (*nq_); (j2_)++) {
        j_ = (*nq_) - j2_ + j1_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))];
        }
      }
    }
  }
  else {
    for (j1_ = 1; j1_ <= (*nq_); (j1_)++) {
      for (j2_ = j1_; j2_ <= (*nq_); (j2_)++) {
        j_ = (*nq_) - j2_ + j1_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] - yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))];
        }
      }
    }
  }
  __calls[4].calls++;
  return 0;
}

int_4 _cdpst (real_4 _p_ el_, int_4 (*_f)(), int_4 (*_fa)(), real_4 _p_ h_, int_4 _p_ impl_, int_4 (*_jacobn)(), int_4 
_p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 _p_ nq_, complex_8 _p_ 
save2_, real_4 _p_ t_, int_4 (*_users)(), complex_8 _p_ y_, complex_8 _p_ yh_, complex_8 _p_ ywt_, real_4 _p_ uround_, 
int_4 _p_ nfe_, int_4 _p_ nje_, complex_8 _p_ a_, complex_8 _p_ dfdy_, complex_8 _p_ fac_, logical_4 _p_ ier_, int_4 
_p_ ipvt_, complex_8 _p_ save1_, int_4 _p_ iswflg_, real_4 _p_ bnd_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, imax_, info_, j_, j2_, k_, mw_;
  static real_4 bl_, bp_, br_, dfdymx_, diff_, facmin_, factor_, scale_, zmax_, zmin_;
  static complex_8 cfctr_, dy_, yj_, ys_;
  int_4 $0_, $1_;
  real_4 $2_, $3_, $4_;
  extern real_4 _scnrm2 ();
  (*nje_) = (*nje_) + 1;
  (*ier_) = FALSE;
  if ((*miter_) == 1 || (*miter_) == 2) {
    if ((*miter_) == 1) {
      (void) _jacobn (n_, t_, y_, dfdy_, matdim_, ml_, mu_);
      if ((*n_) == 0) {
        (*jstate_) = 8;
        goto _l0;
      }
      if ((*iswflg_) == 3) {
        (*bnd_) = _scnrm2 (($0_ = (*n_) * (*n_), &$0_), dfdy_, &_k1);
      }
      factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = factor_ * dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))];
        }
      }
    }
    else if ((*miter_) == 2) {
      br_ = powl ((*uround_), .875e0);
      bl_ = powl ((*uround_), .75e0);
      bp_ = powl ((*uround_), -.15e0);
      facmin_ = powl ((*uround_), .78e0);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        if (cabsf (y_[j_ - 1]) > cabsf (ywt_[j_ - 1])) {
          ys_ = y_[j_ - 1];
        }
        else {
          ys_ = ywt_[j_ - 1];
        }
        _l120:;
        dy_ = fac_[j_ - 1] * ys_;
        if (dy_ == 0.0e0) {
          if ((real_4) (crealf (fac_[j_ - 1])) < .5e0) {
            fac_[j_ - 1] = _min (100.0e0 * (real_4) (crealf (fac_[j_ - 1])), .5e0);
            goto _l120;
          }
          else {
            dy_ = ys_;
          }
        }
        dy_ = (y_[j_ - 1] + dy_) - y_[j_ - 1];
        yj_ = y_[j_ - 1];
        y_[j_ - 1] = y_[j_ - 1] + dy_;
        (void) _f (n_, t_, y_, save1_);
        if ((*n_) == 0) {
          (*jstate_) = 6;
          goto _l0;
        }
        y_[j_ - 1] = yj_;
        cfctr_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_) / dy_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = (save1_[i_ - 1] - save2_[i_ - 1]) * cfctr_;
        }
        diff_ = cabsf (save2_[0] - save1_[0]);
        imax_ = 1;
        for (i_ = 2; i_ <= (*n_); (i_)++) {
          if (cabsf (save2_[i_ - 1] - save1_[i_ - 1]) > diff_) {
            imax_ = i_;
            diff_ = cabsf (save2_[i_ - 1] - save1_[i_ - 1]);
          }
        }
        if (_min (cabsf (save2_[imax_ - 1]), cabsf (save1_[imax_ - 1])) > 0.0e0) {
          scale_ = _max (cabsf (save2_[imax_ - 1]), cabsf (save1_[imax_ - 1]));
          if (diff_ > 0.5 * scale_) {
            fac_[j_ - 1] = _max (facmin_, (real_4) (crealf (fac_[j_ - 1])) * .5e0);
          }
          else if (br_ * scale_ <= diff_ && diff_ <= bl_ * scale_) {
            fac_[j_ - 1] = _min ((real_4) (crealf (fac_[j_ - 1])) * 2.0e0, .5e0);
          }
          else if (diff_ < br_ * scale_) {
            fac_[j_ - 1] = _min (bp_ * (real_4) (crealf (fac_[j_ - 1])), .5e0);
          }
        }
      }
      if ((*iswflg_) == 3) {
        (*bnd_) = _scnrm2 (($1_ = (*n_) * (*n_), &$1_), dfdy_, &_k1) / (-el_[0 + (13) * (((*nq_) - 1))] * (*h_));
      }
      (*nfe_) = (*nfe_) + (*n_);
    }
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] + 1.0e0;
      }
    }
    else if ((*impl_) == 1) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    else if ((*impl_) == 2) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (i_ = 1; i_ <= (*nde_); (i_)++) {
        dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] + a_[i_ - 1 + ((*matdim_)) * 
        ((0))];
      }
    }
    else if ((*impl_) == 3) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    (void) _cgefa (dfdy_, matdim_, n_, ipvt_, &info_);
    if (info_ != 0) {
      (*ier_) = TRUE;
    }
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    if ((*miter_) == 4) {
      (void) _jacobn (n_, t_, y_, &dfdy_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_);
      if ((*n_) == 0) {
        (*jstate_) = 8;
        goto _l0;
      }
      factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_);
      mw_ = (*ml_) + (*mu_) + 1;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = factor_ * dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))];
        }
      }
    }
    else if ((*miter_) == 5) {
      br_ = powl ((*uround_), .875e0);
      bl_ = powl ((*uround_), .75e0);
      bp_ = powl ((*uround_), -.15e0);
      facmin_ = powl ((*uround_), .78e0);
      mw_ = (*ml_) + (*mu_) + 1;
      j2_ = _min (mw_, (*n_));
      for (j_ = 1; j_ <= j2_; (j_)++) {
        for (k_ = j_; (mw_ > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += mw_) {
          if (cabsf (y_[k_ - 1]) > cabsf (ywt_[k_ - 1])) {
            ys_ = y_[k_ - 1];
          }
          else {
            ys_ = ywt_[k_ - 1];
          }
          _l280:;
          dy_ = fac_[k_ - 1] * ys_;
          if (dy_ == 0.0e0) {
            if ((real_4) (crealf (fac_[k_ - 1])) < .5e0) {
              fac_[k_ - 1] = _min (100.0e0 * (real_4) (crealf (fac_[k_ - 1])), .5e0);
              goto _l280;
            }
            else {
              dy_ = ys_;
            }
          }
          dy_ = (y_[k_ - 1] + dy_) - y_[k_ - 1];
          dfdy_[mw_ - 1 + ((*matdim_)) * ((k_ - 1))] = y_[k_ - 1];
          y_[k_ - 1] = y_[k_ - 1] + dy_;
        }
        (void) _f (n_, t_, y_, save1_);
        if ((*n_) == 0) {
          (*jstate_) = 6;
          goto _l0;
        }
        for (k_ = j_; (mw_ > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += mw_) {
          dy_ = y_[k_ - 1] - dfdy_[mw_ - 1 + ((*matdim_)) * ((k_ - 1))];
          y_[k_ - 1] = dfdy_[mw_ - 1 + ((*matdim_)) * ((k_ - 1))];
          cfctr_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_) / dy_;
          for (i_ = _max ((*ml_) + 1, mw_ + 1 - k_); i_ <= _min (mw_ + (*n_) - k_, mw_ + (*ml_)); (i_)++) {
            dfdy_[i_ - 1 + ((*matdim_)) * ((k_ - 1))] = cfctr_ * (save1_[i_ + k_ - mw_ - 1] - save2_[i_ + k_ - mw_ - 1]);
          }
          imax_ = _max (1, k_ - (*mu_));
          diff_ = cabsf (save2_[imax_ - 1] - save1_[imax_ - 1]);
          for (i_ = _max (1, k_ - (*mu_)) + 1; i_ <= _min (k_ + (*ml_), (*n_)); (i_)++) {
            if (cabsf (save2_[i_ - 1] - save1_[i_ - 1]) > diff_) {
              imax_ = i_;
              diff_ = cabsf (save2_[i_ - 1] - save1_[i_ - 1]);
            }
          }
          if (_min (cabsf (save2_[imax_ - 1]), cabsf (save1_[imax_ - 1])) > 0.0e0) {
            scale_ = _max (cabsf (save2_[imax_ - 1]), cabsf (save1_[imax_ - 1]));
            if (diff_ > 0.5 * scale_) {
              fac_[j_ - 1] = _max (facmin_, (real_4) (crealf (fac_[j_ - 1])) * .5e0);
            }
            else if (br_ * scale_ <= diff_ && diff_ <= bl_ * scale_) {
              fac_[j_ - 1] = _min ((real_4) (crealf (fac_[j_ - 1])) * 2.0e0, .5e0);
            }
            else if (diff_ < br_ * scale_) {
              fac_[k_ - 1] = _min (bp_ * (real_4) (crealf (fac_[k_ - 1])), .5e0);
            }
          }
        }
      }
      (*nfe_) = (*nfe_) + j2_;
    }
    if ((*iswflg_) == 3) {
      dfdymx_ = 0.0;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          zmax_ = _max (_abs ((real_4) (crealf (dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))]))), _abs (cimagf (dfdy_[i_ - 1 + 
          ((*matdim_)) * ((j_ - 1))])));
          zmin_ = _min (_abs ((real_4) (crealf (dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))]))), _abs (cimagf (dfdy_[i_ - 1 + 
          ((*matdim_)) * ((j_ - 1))])));
          if (zmax_ != 0.0e0) {
            dfdymx_ = _max (dfdymx_, zmax_ * sqrtf (1.0e0 + ($2_ = (zmin_ / zmax_), $2_ * $2_)));
          }
        }
      }
      (*bnd_) = 0.0;
      if (dfdymx_ != 0.0e0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
            (*bnd_) = (*bnd_) + ($3_ = ((real_4) (crealf (dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))])) / dfdymx_), $3_ * $3_) + ($4_ 
            = (cimagf (dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))]) / dfdymx_), $4_ * $4_);
          }
        }
        (*bnd_) = dfdymx_ * sqrtf ((*bnd_)) / (-el_[0 + (13) * (((*nq_) - 1))] * (*h_));
      }
    }
    if ((*impl_) == 0) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] + 1.0e0;
      }
    }
    else if ((*impl_) == 1) {
      (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    else if ((*impl_) == 2) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[j_ - 1 + ((*matdim_)) * 
        ((0))];
      }
    }
    else if ((*impl_) == 3) {
      (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*nde_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    (void) _cgbfa (dfdy_, matdim_, n_, ml_, mu_, ipvt_, &info_);
    if (info_ != 0) {
      (*ier_) = TRUE;
    }
  }
  else if ((*miter_) == 3) {
    iflag_ = 1;
    (void) _users (y_, &yh_[0 + ((*n_)) * ((1))], ywt_, save1_, save2_, t_, h_, &el_[0 + (13) * (((*nq_) - 1))], impl_, n_, 
    nde_, &iflag_);
    if (iflag_ == -1) {
      (*ier_) = TRUE;
      goto _l0;
    }
    if ((*n_) == 0) {
      (*jstate_) = 10;
      goto _l0;
    }
  }
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _cdriv1 (int_4 _p_ n_, real_4 _p_ t_, complex_8 _p_ y_, real_4 (*_f)(), real_4 _p_ tout_, int_4 _p_ mstate_, 
real_4 _p_ eps_, complex_8 _p_ work_, int_4 _p_ lenw_, int_4 _p_ ierflg_)
{
  static int_4 i_, leniw_, lenwcm_, lnwchk_, ml_, mu_, nde_, nstate_, ntask_, iwork_[250];
  static real_4 ewtcom_[1], hmax_;
  static char_15 intgr1_;
  int_4 _data_k_0, __fcnt, __rc, $3_, $11_, $12_, $13_, $14_, $15_;
  char_127 $0_, $4_, $7_;
  char_255 $1_, $2_, $5_, $6_, $8_;
  char_511 $9_, $10_;
  static FORMAT $f_100012_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100023_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100041_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
#define _data_n_0 1
  static real_4 _data_l_0[_data_n_0] = {
    1.0e0
  };
  if (__calls[6].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    ewtcom_[0] = _data_l_0[_data_k_0++];
  }
  if (_abs ((*mstate_)) == 0 || _abs ((*mstate_)) > 7) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv1:305", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:305", 0));
      __fcnt += 3;
    }
    if ($f_100012_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:305", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100012_[__fcnt + 2], &(*mstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:305", 0));
    __fcnt += 3;
    while ($f_100012_[__fcnt] != NULL && $f_100012_[__fcnt] == FMT_TEXT) {
      if ($f_100012_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100012_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:305", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($2_, concat ($1_, concat ($0_, _dc_2, intgr1_), _dc_3), 255), $2_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  else if (_abs ((*mstate_)) == 7) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_1, _dc_4, ierflg_, ($3_ = 2, &$3_));
    goto _l0;
  }
  if ((*n_) > 200) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv1:319", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:319", 0));
      __fcnt += 3;
    }
    if ($f_100023_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:319", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100023_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:319", 0));
    __fcnt += 3;
    while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
      if ($f_100023_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:319", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 21;
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_5, intgr1_), _dc_6), 255), $6_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  if ((*mstate_) > 0) {
    nstate_ = (*mstate_);
    ntask_ = 1;
  }
  else {
    nstate_ = -(*mstate_);
    ntask_ = 3;
  }
  hmax_ = 2.0e0 * _abs ((*tout_) - (*t_));
  leniw_ = (*n_) + 50;
  lenwcm_ = (*lenw_) - leniw_;
  if (lenwcm_ < ((*n_) * (*n_) + 10 * (*n_) + 250)) {
    lnwchk_ = (*n_) * (*n_) + 10 * (*n_) + 250 + leniw_;
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv1:339", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:339", 0));
      __fcnt += 3;
    }
    if ($f_100041_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:339", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100041_[__fcnt + 2], &lnwchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:339", 0));
    __fcnt += 3;
    while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
      if ($f_100041_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv1:339", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 32;
    (void) _xermsg (_dc_0, _dc_1, (bufcpy ($10_, concat ($9_, concat ($8_, concat ($7_, _dc_7, _dc_8), intgr1_), _dc_9), 
    511), $10_), ierflg_, &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  if (nstate_ != 1) {
    for (i_ = 1; i_ <= leniw_; (i_)++) {
      iwork_[i_ - 1] = (int_4) (crealf (work_[i_ + lenwcm_ - 1]));
    }
  }
  (void) _cdriv3 (n_, t_, y_, _f, &nstate_, tout_, &ntask_, &_k0, eps_, ewtcom_, ($11_ = 2, &$11_), ($12_ = 2, &$12_), 
  ($13_ = 2, &$13_), &_k0, &ml_, &mu_, ($14_ = 5, &$14_), &hmax_, work_, &lenwcm_, iwork_, &leniw_, _f, _f, &nde_, ($15_ 
  = 1000, &$15_), _f, _f, ierflg_);
  for (i_ = 1; i_ <= leniw_; (i_)++) {
    work_[i_ + lenwcm_ - 1] = iwork_[i_ - 1];
  }
  if (nstate_ <= 4) {
    (*mstate_) = _sign (nstate_, (*mstate_));
  }
  else if (nstate_ == 6) {
    (*mstate_) = _sign (5, (*mstate_));
  }
  else if ((*ierflg_) == 11) {
    (*mstate_) = _sign (6, (*mstate_));
  }
  else if ((*ierflg_) > 11) {
    (*mstate_) = _sign (7, (*mstate_));
  }
  _l0:;
  __calls[6].calls++;
  return 0;
}

int_4 _cdriv2 (int_4 _p_ n_, real_4 _p_ t_, complex_8 _p_ y_, real_4 (*_f)(), real_4 _p_ tout_, int_4 _p_ mstate_, 
int_4 _p_ nroot_, real_4 _p_ eps_, real_4 _p_ ewt_, int_4 _p_ mint_, complex_8 _p_ work_, int_4 _p_ lenw_, int_4 _p_ 
iwork_, int_4 _p_ leniw_, real_4 (*_g)(), int_4 _p_ ierflg_)
{
  static int_4 ierror_, miter_, ml_, mu_, mxord_, nde_, nstate_, ntask_;
  static real_4 ewtcom_[1], hmax_;
  static char_15 intgr1_;
  int_4 $0_, __fcnt, __rc, $8_;
  char_127 $1_, $4_;
  char_255 $2_, $3_, $5_;
  char_511 $6_, $7_;
  static FORMAT $f_100014_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100021_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if (_abs ((*mstate_)) == 9) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_10, _dc_11, ierflg_, ($0_ = 2, &$0_));
    goto _l0;
  }
  else if (_abs ((*mstate_)) == 0 || _abs ((*mstate_)) > 9) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv2:357", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv2:357", 0));
      __fcnt += 3;
    }
    if ($f_100014_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv2:357", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100014_[__fcnt + 2], &(*mstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv2:357", 0));
    __fcnt += 3;
    while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
      if ($f_100014_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv2:357", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_10, (bufcpy ($3_, concat ($2_, concat ($1_, _dc_2, intgr1_), _dc_12), 255), $3_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (9, (*mstate_));
    goto _l0;
  }
  if ((*mint_) < 1 || (*mint_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv2:366", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv2:366", 0));
      __fcnt += 3;
    }
    if ($f_100021_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv2:366", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100021_[__fcnt + 2], &(*mint_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv2:366", 0));
    __fcnt += 3;
    while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
      if ($f_100021_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv2:366", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 23;
    (void) _xermsg (_dc_0, _dc_10, (bufcpy ($7_, concat ($6_, concat ($5_, concat ($4_, _dc_13, _dc_14), intgr1_), _dc_9), 
    511), $7_), ierflg_, &_k1);
    (*mstate_) = _sign (9, (*mstate_));
    goto _l0;
  }
  if ((*mstate_) >= 0) {
    nstate_ = (*mstate_);
    ntask_ = 1;
  }
  else {
    nstate_ = -(*mstate_);
    ntask_ = 3;
  }
  ewtcom_[0] = (*ewt_);
  if ((*ewt_) != 0.0e0) {
    ierror_ = 3;
  }
  else {
    ierror_ = 2;
  }
  if ((*mint_) == 1) {
    miter_ = 0;
    mxord_ = 12;
  }
  else if ((*mint_) == 2) {
    miter_ = 2;
    mxord_ = 5;
  }
  else if ((*mint_) == 3) {
    miter_ = 2;
    mxord_ = 12;
  }
  hmax_ = 2.0e0 * _abs ((*tout_) - (*t_));
  (void) _cdriv3 (n_, t_, y_, _f, &nstate_, tout_, &ntask_, nroot_, eps_, ewtcom_, &ierror_, mint_, &miter_, &_k0, &ml_, 
  &mu_, &mxord_, &hmax_, work_, lenw_, iwork_, leniw_, _f, _f, &nde_, ($8_ = 1000, &$8_), _g, _f, ierflg_);
  if (nstate_ <= 7) {
    (*mstate_) = _sign (nstate_, (*mstate_));
  }
  else if (nstate_ == 11) {
    (*mstate_) = _sign (8, (*mstate_));
  }
  else if (nstate_ > 11) {
    (*mstate_) = _sign (9, (*mstate_));
  }
  _l0:;
  __calls[7].calls++;
  return 0;
}

int_4 _cdriv3 (int_4 _p_ n_, real_4 _p_ t_, complex_8 _p_ y_, int_4 (*_f)(), int_4 _p_ nstate_, real_4 _p_ tout_, int_4 
_p_ ntask_, int_4 _p_ nroot_, real_4 _p_ eps_, real_4 _p_ ewt_, int_4 _p_ ierror_, int_4 _p_ mint_, int_4 _p_ miter_, 
int_4 _p_ impl_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ mxord_, real_4 _p_ hmax_, complex_8 _p_ work_, int_4 _p_ lenw_
, int_4 _p_ iwork_, int_4 _p_ leniw_, int_4 (*_jacobn)(), int_4 (*_fa)(), int_4 _p_ nde_, int_4 _p_ mxstep_, real_4 
(*_g)(), int_4 (*_users)(), int_4 _p_ ierflg_)
{
  static int_4 i_, ia_, idfdy_, ifac_, iflag_, ignow_, imxerr_, info_, iroot_, isave1_, isave2_, itroot_, iywt_, j_, 
  jstate_, jtroot_, lenchk_, liwchk_, matdim_, maxord_, ndecom_, npar_, nstepl_;
  static logical_4 convrg_;
  static real_4 ae_, avgh_, avgord_, big_, el_[156], glast_, gnow_, h_, hold_, hsign_, hused_, rc_, re_, rmax_, size_, 
  sum_, tlast_, tq_[36], trend_, troot_, uround_;
  static char_15 intgr1_, intgr2_;
  static char_31 rl1_, rl2_;
  int_4 $0_, __fcnt, __rc, $44_;
  real_4 $57_;
  char_63 $4_, $10_, $58_, $65_, $73_, $81_, $85_, $90_;
  char_127 $1_, $5_, $6_, $7_, $11_, $12_, $13_, $17_, $20_, $23_, $28_, $31_, $34_, $39_, $45_, $51_, $59_, $66_, $74_, 
  $82_, $86_, $91_, $92_;
  char_255 $2_, $3_, $8_, $9_, $14_, $18_, $19_, $21_, $22_, $24_, $29_, $30_, $32_, $33_, $35_, $40_, $46_, $52_, $60_, 
  $67_, $75_, $83_, $84_, $87_;
  char_511 $15_, $16_, $25_, $36_, $41_, $47_, $53_, $61_, $68_, $76_, $88_, $89_;
  char_1023 $26_, $27_, $37_, $38_, $42_, $43_, $48_, $54_, $62_, $69_, $77_;
  char_2047 $49_, $50_, $55_, $56_, $63_, $64_, $70_, $78_;
  char_4095 $71_, $72_, $79_, $80_;
  extern real_4 _r1mach ();
  extern real_4 _scnrm2 ();
  static FORMAT $f_100015_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100023_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100030_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100037_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100044_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100050_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100056_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100062_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100063_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100069_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100075_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100087_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100130_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100295_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100296_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100326_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100327_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100475_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100476_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100485_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100486_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100493_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100494_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100495_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100661_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100666_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100671_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  if ((*nstate_) == 12) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_15, _dc_16, ierflg_, ($0_ = 2, &$0_));
    goto _l0;
  }
  else if ((*nstate_) < 1 || (*nstate_) > 12) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:762", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:762", 0));
      __fcnt += 3;
    }
    if ($f_100015_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:762", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100015_[__fcnt + 2], &(*nstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:762", 0));
    __fcnt += 3;
    while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
      if ($f_100015_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:762", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($3_, concat ($2_, concat ($1_, _dc_17, intgr1_), _dc_18), 255), $3_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  npar_ = (*n_);
  if ((*eps_) < 0.0e0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:772", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:772", 0));
      __fcnt += 3;
    }
    if ($f_100023_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:772", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100023_[__fcnt + 2], &(*eps_), REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:772", 0));
    __fcnt += 3;
    while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
      if ($f_100023_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:772", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 27;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_19, rl1_), _dc_20), 127), $6_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*n_) <= 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:780", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:780", 0));
      __fcnt += 3;
    }
    if ($f_100030_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:780", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100030_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:780", 0));
    __fcnt += 3;
    while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
      if ($f_100030_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:780", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 22;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($9_, concat ($8_, concat ($7_, _dc_21, intgr1_), _dc_22), 255), $9_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mxord_) <= 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:789", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:789", 0));
      __fcnt += 3;
    }
    if ($f_100037_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:789", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100037_[__fcnt + 2], &(*mxord_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:789", 0));
    __fcnt += 3;
    while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
      if ($f_100037_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:789", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 28;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($12_, concat ($11_, concat ($10_, _dc_23, intgr1_), _dc_22), 127), $12_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mint_) < 1 || (*mint_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:798", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100044_[__fcnt] != NULL && $f_100044_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100044_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:798", 0));
      __fcnt += 3;
    }
    if ($f_100044_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100044_[__fcnt] != NULL && $f_100044_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100044_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:798", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100044_[__fcnt + 2], &(*mint_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:798", 0));
    __fcnt += 3;
    while ($f_100044_[__fcnt] != NULL && $f_100044_[__fcnt] == FMT_TEXT) {
      if ($f_100044_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100044_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:798", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 23;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($16_, concat ($15_, concat ($14_, concat ($13_, _dc_13, _dc_14), intgr1_), 
    _dc_9), 511), $16_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*miter_) < 0 || (*miter_) > 5) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:806", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100050_[__fcnt] != NULL && $f_100050_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100050_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:806", 0));
      __fcnt += 3;
    }
    if ($f_100050_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100050_[__fcnt] != NULL && $f_100050_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100050_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:806", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100050_[__fcnt + 2], &(*miter_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:806", 0));
    __fcnt += 3;
    while ($f_100050_[__fcnt] != NULL && $f_100050_[__fcnt] == FMT_TEXT) {
      if ($f_100050_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100050_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:806", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 24;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($19_, concat ($18_, concat ($17_, _dc_24, intgr1_), _dc_18), 255), $19_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*impl_) < 0 || (*impl_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:814", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:814", 0));
      __fcnt += 3;
    }
    if ($f_100056_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:814", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100056_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:814", 0));
    __fcnt += 3;
    while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
      if ($f_100056_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:814", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 25;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($22_, concat ($21_, concat ($20_, _dc_25, intgr1_), _dc_18), 255), $22_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*mint_) == 3 && ((*miter_) == 0 || (*miter_) == 3 || (*impl_) != 0)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:823", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:823", 0));
      __fcnt += 3;
    }
    if ($f_100062_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:823", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100062_[__fcnt + 2], &(*miter_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:823", 0));
    __fcnt += 3;
    while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
      if ($f_100062_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:823", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:824", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100063_[__fcnt] != NULL && $f_100063_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100063_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:824", 0));
      __fcnt += 3;
    }
    if ($f_100063_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100063_[__fcnt] != NULL && $f_100063_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100063_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:824", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100063_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:824", 0));
    __fcnt += 3;
    while ($f_100063_[__fcnt] != NULL && $f_100063_[__fcnt] == FMT_TEXT) {
      if ($f_100063_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100063_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:824", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 29;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($27_, concat ($26_, concat ($25_, concat ($24_, concat ($23_, _dc_26, intgr1_), 
    _dc_27), intgr2_), _dc_28), 1023), $27_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if (((*impl_) >= 1 && (*impl_) <= 3) && (*miter_) == 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:832", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100069_[__fcnt] != NULL && $f_100069_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100069_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:832", 0));
      __fcnt += 3;
    }
    if ($f_100069_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100069_[__fcnt] != NULL && $f_100069_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100069_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:832", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100069_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:832", 0));
    __fcnt += 3;
    while ($f_100069_[__fcnt] != NULL && $f_100069_[__fcnt] == FMT_TEXT) {
      if ($f_100069_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100069_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:832", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 30;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($30_, concat ($29_, concat ($28_, _dc_29, intgr1_), _dc_28), 255), $30_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if (((*impl_) == 2 || (*impl_) == 3) && (*mint_) == 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:840", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100075_[__fcnt] != NULL && $f_100075_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100075_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:840", 0));
      __fcnt += 3;
    }
    if ($f_100075_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100075_[__fcnt] != NULL && $f_100075_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100075_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:840", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100075_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:840", 0));
    __fcnt += 3;
    while ($f_100075_[__fcnt] != NULL && $f_100075_[__fcnt] == FMT_TEXT) {
      if ($f_100075_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100075_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:840", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 31;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($33_, concat ($32_, concat ($31_, _dc_30, intgr1_), _dc_28), 255), $33_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*miter_) == 0 || (*miter_) == 3) {
    liwchk_ = 50;
  }
  else if ((*miter_) == 1 || (*miter_) == 2 || (*miter_) == 4 || (*miter_) == 5) {
    liwchk_ = 51 + (*n_) - 1;
  }
  if ((*leniw_) < liwchk_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:855", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:855", 0));
      __fcnt += 3;
    }
    if ($f_100087_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:855", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100087_[__fcnt + 2], &liwchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:855", 0));
    __fcnt += 3;
    while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
      if ($f_100087_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:855", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 33;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($38_, concat ($37_, concat ($36_, concat ($35_, concat ($34_, _dc_31, _dc_32), 
    _dc_33), intgr1_), _dc_9), 1023), $38_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mint_) == 1 || (*mint_) == 3) {
    maxord_ = _min ((*mxord_), 12);
  }
  else if ((*mint_) == 2) {
    maxord_ = _min ((*mxord_), 5);
  }
  idfdy_ = 251 + (maxord_ + 1) * (*n_);
  if ((*miter_) == 0 || (*miter_) == 3) {
    iywt_ = idfdy_;
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    iywt_ = idfdy_ + (*n_) * (*n_);
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    iywt_ = idfdy_ + (2 * (*ml_) + (*mu_) + 1) * (*n_);
  }
  isave1_ = iywt_ + (*n_);
  isave2_ = isave1_ + (*n_);
  ignow_ = isave2_ + (*n_);
  itroot_ = ignow_ + (*nroot_);
  ifac_ = itroot_ + (*nroot_);
  if ((*miter_) == 2 || (*miter_) == 5 || (*mint_) == 3) {
    ia_ = ifac_ + (*n_);
  }
  else {
    ia_ = ifac_;
  }
  if ((*impl_) == 0 || (*miter_) == 3) {
    lenchk_ = ia_ - 1;
  }
  else if ((*impl_) == 1 && ((*miter_) == 1 || (*miter_) == 2)) {
    lenchk_ = ia_ - 1 + (*n_) * (*n_);
  }
  else if ((*impl_) == 1 && ((*miter_) == 4 || (*miter_) == 5)) {
    lenchk_ = ia_ - 1 + (2 * (*ml_) + (*mu_) + 1) * (*n_);
  }
  else if ((*impl_) == 2 && (*miter_) != 3) {
    lenchk_ = ia_ - 1 + (*n_);
  }
  else if ((*impl_) == 3 && ((*miter_) == 1 || (*miter_) == 2)) {
    lenchk_ = ia_ - 1 + (*n_) * (*nde_);
  }
  else if ((*impl_) == 3 && ((*miter_) == 4 || (*miter_) == 5)) {
    lenchk_ = ia_ - 1 + (2 * (*ml_) + (*mu_) + 1) * (*nde_);
  }
  if ((*lenw_) < lenchk_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:912", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100130_[__fcnt] != NULL && $f_100130_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100130_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:912", 0));
      __fcnt += 3;
    }
    if ($f_100130_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100130_[__fcnt] != NULL && $f_100130_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:912", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100130_[__fcnt + 2], &lenchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:912", 0));
    __fcnt += 3;
    while ($f_100130_[__fcnt] != NULL && $f_100130_[__fcnt] == FMT_TEXT) {
      if ($f_100130_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100130_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:912", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 32;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($43_, concat ($42_, concat ($41_, concat ($40_, concat ($39_, _dc_31, _dc_34), 
    _dc_33), intgr1_), _dc_9), 1023), $43_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*miter_) == 0 || (*miter_) == 3) {
    matdim_ = 1;
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    matdim_ = (*n_);
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    matdim_ = 2 * (*ml_) + (*mu_) + 1;
  }
  if ((*impl_) == 0 || (*impl_) == 1) {
    ndecom_ = (*n_);
  }
  else if ((*impl_) == 2 || (*impl_) == 3) {
    ndecom_ = (*nde_);
  }
  if ((*nstate_) == 1) {
    if ((*mint_) == 1 || (*mint_) == 3) {
      iwork_[19] = _min ((*mxord_), 12);
    }
    else if ((*mint_) == 2) {
      iwork_[19] = _min ((*mxord_), 5);
    }
    iwork_[18] = (*mxord_);
    if ((*mint_) == 1 || (*mint_) == 2) {
      iwork_[15] = (*mint_);
      iwork_[17] = (*miter_);
      iwork_[9] = (*mint_);
      iwork_[10] = (*miter_);
    }
    else if ((*mint_) == 3) {
      iwork_[15] = 1;
      iwork_[17] = 0;
      iwork_[9] = iwork_[15];
      iwork_[10] = iwork_[17];
      iwork_[16] = (*miter_);
    }
    work_[160] = (*hmax_);
    uround_ = _r1mach (($44_ = 4, &$44_));
    work_[205] = uround_;
    work_[204] = _r1mach (&_k1);
    if ((*nroot_) != 0) {
      re_ = uround_;
      ae_ = (real_4) (crealf (work_[204]));
    }
    h_ = ((*tout_) - (*t_)) * (1.0e0 - 4.0e0 * uround_);
    h_ = _sign (_min (_abs (h_), (*hmax_)), h_);
    work_[159] = h_;
    hsign_ = _sign (1.0, h_);
    work_[162] = hsign_;
    iwork_[8] = 0;
    avgh_ = 0.0;
    avgord_ = 0.0;
    work_[0] = 0.0;
    work_[1] = 0.0;
    work_[2] = 0.0;
    iwork_[0] = 0;
    iwork_[1] = 0;
    iwork_[2] = 0;
    iwork_[21] = 0;
    iwork_[3] = 0;
    iwork_[4] = 0;
    iwork_[5] = 0;
    work_[165] = (*t_);
    iwork_[6] = 0;
    iwork_[20] = 0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + 251 - 1 - 1] = y_[i_ - 1];
    }
    if ((*t_) == (*tout_)) {
      goto _l0;
    }
    goto _l180;
  }
  else {
    uround_ = (real_4) (crealf (work_[205]));
    if ((*nroot_) != 0) {
      re_ = uround_;
      ae_ = (real_4) (crealf (work_[204]));
    }
  }
  if (iwork_[6] == 1) {
    convrg_ = TRUE;
  }
  else {
    convrg_ = FALSE;
  }
  avgh_ = (real_4) (crealf (work_[0]));
  avgord_ = (real_4) (crealf (work_[2]));
  hold_ = (real_4) (crealf (work_[161]));
  rc_ = (real_4) (crealf (work_[163]));
  rmax_ = (real_4) (crealf (work_[164]));
  trend_ = (real_4) (crealf (work_[203]));
  for (j_ = 1; j_ <= 12; (j_)++) {
    for (i_ = 1; i_ <= 13; (i_)++) {
      el_[i_ - 1 + (13) * ((j_ - 1))] = (real_4) (crealf (work_[i_ + 4 + (j_ - 1) * 13 - 1 - 1]));
    }
  }
  for (j_ = 1; j_ <= 12; (j_)++) {
    for (i_ = 1; i_ <= 3; (i_)++) {
      tq_[i_ - 1 + (3) * ((j_ - 1))] = (real_4) (crealf (work_[i_ + 168 + (j_ - 1) * 3 - 1 - 1]));
    }
  }
  (*t_) = (real_4) (crealf (work_[165]));
  h_ = (real_4) (crealf (work_[159]));
  hsign_ = (real_4) (crealf (work_[162]));
  if (iwork_[8] == 0) {
    goto _l180;
  }
  if ((*nroot_) != 0) {
    if (iwork_[7] > 0) {
      if ((*nstate_) != 5) {
        if ((*tout_) * hsign_ >= (real_4) (crealf (work_[166])) * hsign_) {
          troot_ = (real_4) (crealf (work_[166]));
          (void) _cdntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
          (*t_) = troot_;
          (*nstate_) = 5;
          (*ierflg_) = 0;
          goto _l580;
        }
      }
      else {
        troot_ = (*t_);
        iroot_ = 0;
        for (i_ = 1; i_ <= iwork_[12]; (i_)++) {
          jtroot_ = i_ + iwork_[13] - 1;
          if ((real_4) (crealf (work_[jtroot_ - 1])) * hsign_ <= troot_ * hsign_) {
            if (work_[jtroot_ - 1] == work_[166] && i_ > iwork_[5]) {
              iroot_ = i_;
              troot_ = (real_4) (crealf (work_[jtroot_ - 1]));
              goto _l60;
            }
            if ((real_4) (crealf (work_[jtroot_ - 1])) * hsign_ > (real_4) (crealf (work_[166])) * hsign_) {
              iroot_ = i_;
              troot_ = (real_4) (crealf (work_[jtroot_ - 1]));
            }
          }
        }
        _l60:;
        iwork_[5] = iroot_;
        work_[166] = troot_;
        iwork_[7] = (*ntask_);
        if ((*ntask_) == 1) {
          if (iroot_ == 0) {
            iwork_[7] = 0;
          }
          else {
            if ((*tout_) * hsign_ >= troot_ * hsign_) {
              (void) _cdntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
              (*nstate_) = 5;
              (*t_) = troot_;
              (*ierflg_) = 0;
              goto _l580;
            }
          }
        }
        else if ((*ntask_) == 2 || (*ntask_) == 3) {
          if (iroot_ == 0 || ((*tout_) * hsign_ < troot_ * hsign_)) {
            iwork_[7] = 0;
          }
          else {
            (void) _cdntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
            (*nstate_) = 5;
            (*t_) = troot_;
            (*ierflg_) = 0;
            goto _l580;
          }
        }
      }
    }
  }
  if ((*ntask_) == 1) {
    (*nstate_) = 2;
    if ((*t_) * hsign_ >= (*tout_) * hsign_) {
      (void) _cdntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      (*ierflg_) = 0;
      goto _l580;
    }
  }
  else if ((*ntask_) == 2) {
    if ((*t_) * hsign_ > (*tout_) * hsign_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:cdriv3:1117", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100295_[__fcnt] != NULL && $f_100295_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100295_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1117", 0));
        __fcnt += 3;
      }
      if ($f_100295_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100295_[__fcnt] != NULL && $f_100295_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100295_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1117", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100295_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1117", 0));
      __fcnt += 3;
      while ($f_100295_[__fcnt] != NULL && $f_100295_[__fcnt] == FMT_TEXT) {
        if ($f_100295_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100295_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1117", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:cdriv3:1118", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100296_[__fcnt] != NULL && $f_100296_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100296_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1118", 0));
        __fcnt += 3;
      }
      if ($f_100296_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100296_[__fcnt] != NULL && $f_100296_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100296_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1118", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100296_[__fcnt + 2], &(*tout_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1118", 0));
      __fcnt += 3;
      while ($f_100296_[__fcnt] != NULL && $f_100296_[__fcnt] == FMT_TEXT) {
        if ($f_100296_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100296_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1118", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 11;
      (void) _xermsg (_dc_0, _dc_15, (bufcpy ($50_, concat ($49_, concat ($48_, concat ($47_, concat ($46_, concat ($45_, 
      _dc_35, rl1_), _dc_36), rl2_), _dc_37), _dc_38), 2047), $50_), ierflg_, &_k0);
      (*nstate_) = 11;
      (void) _cdntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      goto _l580;
    }
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
      (*nstate_) = 2;
      (*ierflg_) = 0;
      goto _l560;
    }
    if ((*nstate_) == 5) {
      (*nstate_) = 2;
      (*ierflg_) = 0;
      goto _l560;
    }
    (*nstate_) = 2;
    if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
      h_ = (*tout_) - (*t_);
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = h_ * (1.0e0 - 4.0e0 * uround_);
      }
      work_[159] = h_;
      if (h_ == 0.0e0) {
        goto _l670;
      }
      iwork_[8] = -1;
    }
  }
  else if ((*ntask_) == 3) {
    (*nstate_) = 2;
    if ((*t_) * hsign_ > (*tout_) * hsign_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:cdriv3:1157", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100326_[__fcnt] != NULL && $f_100326_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100326_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1157", 0));
        __fcnt += 3;
      }
      if ($f_100326_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100326_[__fcnt] != NULL && $f_100326_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100326_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1157", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100326_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1157", 0));
      __fcnt += 3;
      while ($f_100326_[__fcnt] != NULL && $f_100326_[__fcnt] == FMT_TEXT) {
        if ($f_100326_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100326_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1157", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:cdriv3:1158", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1158", 0));
        __fcnt += 3;
      }
      if ($f_100327_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1158", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100327_[__fcnt + 2], &(*tout_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1158", 0));
      __fcnt += 3;
      while ($f_100327_[__fcnt] != NULL && $f_100327_[__fcnt] == FMT_TEXT) {
        if ($f_100327_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100327_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1158", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 11;
      (void) _xermsg (_dc_0, _dc_15, (bufcpy ($56_, concat ($55_, concat ($54_, concat ($53_, concat ($52_, concat ($51_, 
      _dc_35, rl1_), _dc_36), rl2_), _dc_37), _dc_38), 2047), $56_), ierflg_, &_k0);
      (*nstate_) = 11;
      (void) _cdntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      goto _l580;
    }
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
      (*ierflg_) = 0;
      goto _l560;
    }
    if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
      h_ = (*tout_) - (*t_);
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = h_ * (1.0e0 - 4.0e0 * uround_);
      }
      work_[159] = h_;
      if (h_ == 0.0e0) {
        goto _l670;
      }
      iwork_[8] = -1;
    }
  }
  if (((*mint_) != iwork_[9] || (*miter_) != iwork_[10]) && (*mint_) != 3 && iwork_[9] != 3) {
    iwork_[8] = -1;
  }
  if ((*hmax_) != work_[160]) {
    h_ = _sign (_min (_abs (h_), (*hmax_)), h_);
    if (h_ != work_[159]) {
      iwork_[8] = -1;
      work_[159] = h_;
    }
    work_[160] = (*hmax_);
  }
  _l180:;
  nstepl_ = iwork_[2];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = work_[i_ + 251 - 1 - 1];
  }
  if ((*nroot_) != 0) {
    for (i_ = 1; i_ <= (*nroot_); (i_)++) {
      work_[i_ + ignow_ - 1 - 1] = _g (&npar_, t_, y_, &i_);
      if (npar_ == 0) {
        iwork_[5] = i_;
        (*nstate_) = 7;
        goto _l0;
      }
    }
  }
  if ((*ierror_) == 1) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = 1.0;
    }
    goto _l410;
  }
  else if ((*ierror_) == 5) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = ewt_[i_ - 1];
    }
    goto _l410;
  }
  _l260:;
  if ((*ierror_) == 2) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      if (y_[i_ - 1] == 0.0e0) {
        goto _l290;
      }
      work_[i_ + iywt_ - 1 - 1] = y_[i_ - 1];
    }
    goto _l410;
    _l290:;
    if (iwork_[8] == 0) {
      (void) _f (&npar_, t_, y_, &work_[isave2_ - 1]);
      if (npar_ == 0) {
        (*nstate_) = 6;
        goto _l0;
      }
      iwork_[3] = iwork_[3] + 1;
      if ((*miter_) == 3 && (*impl_) != 0) {
        iflag_ = 0;
        (void) _users (y_, &work_[250], &work_[iywt_ - 1], &work_[isave1_ - 1], &work_[isave2_ - 1], t_, &h_, ($57_ = (real_4) 
        (crealf (work_[3])), &$57_), impl_, &npar_, &ndecom_, &iflag_);
        if (iflag_ == -1) {
          goto _l690;
        }
        if (npar_ == 0) {
          (*nstate_) = 10;
          goto _l0;
        }
      }
      else if ((*impl_) == 1) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _cgefa (&work_[ia_ - 1], &matdim_, n_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _cgesl (&work_[ia_ - 1], &matdim_, n_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ + (*ml_) - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _cgbfa (&work_[ia_ - 1], &matdim_, n_, ml_, mu_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _cgbsl (&work_[ia_ - 1], &matdim_, n_, ml_, mu_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
      }
      else if ((*impl_) == 2) {
        (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
        if (npar_ == 0) {
          (*nstate_) = 9;
          goto _l0;
        }
        for (i_ = 1; i_ <= ndecom_; (i_)++) {
          if (work_[i_ + ia_ - 1 - 1] == 0.0e0) {
            goto _l690;
          }
          work_[i_ + isave2_ - 1 - 1] = work_[i_ + isave2_ - 1 - 1] / work_[i_ + ia_ - 1 - 1];
        }
      }
      else if ((*impl_) == 3) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _cgefa (&work_[ia_ - 1], &matdim_, nde_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _cgesl (&work_[ia_ - 1], &matdim_, nde_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ + (*ml_) - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _cgbfa (&work_[ia_ - 1], &matdim_, nde_, ml_, mu_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _cgbsl (&work_[ia_ - 1], &matdim_, nde_, ml_, mu_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
      }
    }
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      if (y_[j_ - 1] != 0.0e0) {
        work_[j_ + iywt_ - 1 - 1] = y_[j_ - 1];
      }
      else {
        if (iwork_[8] == 0) {
          work_[j_ + iywt_ - 1 - 1] = h_ * work_[j_ + isave2_ - 1 - 1];
        }
        else {
          work_[j_ + iywt_ - 1 - 1] = work_[j_ + 251 + (*n_) - 1 - 1];
        }
      }
      if (work_[j_ + iywt_ - 1 - 1] == 0.0e0) {
        work_[j_ + iywt_ - 1 - 1] = uround_;
      }
    }
  }
  else if ((*ierror_) == 3) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = _max (ewt_[0], cabsf (y_[i_ - 1]));
    }
  }
  else if ((*ierror_) == 4) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = _max (ewt_[i_ - 1], cabsf (y_[i_ - 1]));
    }
  }
  _l410:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    work_[i_ + isave2_ - 1 - 1] = y_[i_ - 1] / work_[i_ + iywt_ - 1 - 1];
  }
  sum_ = _scnrm2 (n_, &work_[isave2_ - 1], &_k1) / sqrtf ((real_4) ((*n_)));
  sum_ = _max (1.0, sum_);
  if ((*eps_) < sum_ * uround_) {
    (*eps_) = sum_ * uround_ * (1.0e0 + 10.0e0 * uround_);
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:1323", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100475_[__fcnt] != NULL && $f_100475_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100475_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1323", 0));
      __fcnt += 3;
    }
    if ($f_100475_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100475_[__fcnt] != NULL && $f_100475_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100475_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1323", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100475_[__fcnt + 2], &(*t_), REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1323", 0));
    __fcnt += 3;
    while ($f_100475_[__fcnt] != NULL && $f_100475_[__fcnt] == FMT_TEXT) {
      if ($f_100475_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100475_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1323", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl2_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:1324", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100476_[__fcnt] != NULL && $f_100476_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100476_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1324", 0));
      __fcnt += 3;
    }
    if ($f_100476_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100476_[__fcnt] != NULL && $f_100476_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100476_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1324", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100476_[__fcnt + 2], &(*eps_), REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1324", 0));
    __fcnt += 3;
    while ($f_100476_[__fcnt] != NULL && $f_100476_[__fcnt] == FMT_TEXT) {
      if ($f_100476_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100476_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1324", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 4;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($64_, concat ($63_, concat ($62_, concat ($61_, concat ($60_, concat ($59_, 
    concat ($58_, _dc_39, rl1_), _dc_40), _dc_41), _dc_42), rl2_), _dc_9), 2047), $64_), ierflg_, &_k0);
    (*nstate_) = 4;
    goto _l560;
  }
  if (_abs (h_) >= uround_ * _abs ((*t_))) {
    iwork_[20] = 0;
  }
  else if (iwork_[20] == 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:1336", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100485_[__fcnt] != NULL && $f_100485_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100485_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1336", 0));
      __fcnt += 3;
    }
    if ($f_100485_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100485_[__fcnt] != NULL && $f_100485_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100485_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1336", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100485_[__fcnt + 2], &(*t_), REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1336", 0));
    __fcnt += 3;
    while ($f_100485_[__fcnt] != NULL && $f_100485_[__fcnt] == FMT_TEXT) {
      if ($f_100485_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100485_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1336", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl2_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:cdriv3:1337", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100486_[__fcnt] != NULL && $f_100486_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100486_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1337", 0));
      __fcnt += 3;
    }
    if ($f_100486_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100486_[__fcnt] != NULL && $f_100486_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100486_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1337", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100486_[__fcnt + 2], &h_, REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1337", 0));
    __fcnt += 3;
    while ($f_100486_[__fcnt] != NULL && $f_100486_[__fcnt] == FMT_TEXT) {
      if ($f_100486_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100486_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1337", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 15;
    (void) _xermsg (_dc_0, _dc_15, (bufcpy ($72_, concat ($71_, concat ($70_, concat ($69_, concat ($68_, concat ($67_, 
    concat ($66_, concat ($65_, _dc_39, rl1_), _dc_43), rl2_), _dc_44), _dc_45), _dc_46), _dc_47), 4095), $72_), ierflg_, 
    &_k0);
    iwork_[20] = 1;
  }
  if ((*ntask_) != 2) {
    if ((iwork_[2] - nstepl_) == (*mxstep_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:cdriv3:1348", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100493_[__fcnt] != NULL && $f_100493_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100493_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1348", 0));
        __fcnt += 3;
      }
      if ($f_100493_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100493_[__fcnt] != NULL && $f_100493_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100493_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1348", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100493_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1348", 0));
      __fcnt += 3;
      while ($f_100493_[__fcnt] != NULL && $f_100493_[__fcnt] == FMT_TEXT) {
        if ($f_100493_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100493_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1348", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (intgr1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:cdriv3:1349", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100494_[__fcnt] != NULL && $f_100494_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100494_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1349", 0));
        __fcnt += 3;
      }
      if ($f_100494_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100494_[__fcnt] != NULL && $f_100494_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100494_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1349", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100494_[__fcnt + 2], &(*mxstep_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1349", 0));
      __fcnt += 3;
      while ($f_100494_[__fcnt] != NULL && $f_100494_[__fcnt] == FMT_TEXT) {
        if ($f_100494_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100494_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1349", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:cdriv3:1350", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100495_[__fcnt] != NULL && $f_100495_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100495_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1350", 0));
        __fcnt += 3;
      }
      if ($f_100495_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100495_[__fcnt] != NULL && $f_100495_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100495_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1350", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100495_[__fcnt + 2], &(*tout_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1350", 0));
      __fcnt += 3;
      while ($f_100495_[__fcnt] != NULL && $f_100495_[__fcnt] == FMT_TEXT) {
        if ($f_100495_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100495_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1350", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 3;
      (void) _xermsg (_dc_0, _dc_15, (bufcpy ($80_, concat ($79_, concat ($78_, concat ($77_, concat ($76_, concat ($75_, 
      concat ($74_, concat ($73_, _dc_39, rl1_), _dc_48), intgr1_), _dc_49), _dc_50), rl2_), _dc_9), 4095), $80_), ierflg_, 
      &_k0);
      (*nstate_) = 3;
      goto _l560;
    }
  }
  (void) _cdstp (eps_, _f, _fa, hmax_, impl_, ierror_, _jacobn, &matdim_, &iwork_[19], &iwork_[15], &iwork_[17], ml_, 
  mu_, &npar_, &ndecom_, &work_[iywt_ - 1], &uround_, _users, &avgh_, &avgord_, &h_, &hused_, &iwork_[8], &iwork_[9], 
  &iwork_[10], &iwork_[3], &iwork_[4], &iwork_[1], &iwork_[2], t_, y_, &work_[250], &work_[ia_ - 1], &convrg_, 
  &work_[idfdy_ - 1], el_, &work_[ifac_ - 1], &hold_, &iwork_[50], &jstate_, &iwork_[21], &iwork_[11], &iwork_[14], &rc_, 
  &rmax_, &work_[isave1_ - 1], &work_[isave2_ - 1], tq_, &trend_, mint_, &iwork_[16], &iwork_[18]);
  work_[159] = h_;
  work_[165] = (*t_);
  switch (jstate_) {
    default:
    case 1: goto _l470;
    case 2: goto _l670;
    case 3: goto _l680;
    case 4: goto _l690;
    case 5: goto _l690;
    case 6: goto _l660;
    case 7: goto _l660;
    case 8: goto _l660;
    case 9: goto _l660;
    case 10: goto _l660;
  }
  _l470:;
  iwork_[8] = 1;
  if ((*nroot_) != 0) {
    iroot_ = 0;
    for (i_ = 1; i_ <= (*nroot_); (i_)++) {
      glast_ = (real_4) (crealf (work_[i_ + ignow_ - 1 - 1]));
      gnow_ = _g (&npar_, t_, y_, &i_);
      if (npar_ == 0) {
        iwork_[5] = i_;
        (*nstate_) = 7;
        goto _l0;
      }
      work_[i_ + ignow_ - 1 - 1] = gnow_;
      if (glast_ * gnow_ > 0.0e0) {
        work_[i_ + itroot_ - 1 - 1] = (*t_) + h_;
      }
      else {
        if (gnow_ == 0.0e0) {
          work_[i_ + itroot_ - 1 - 1] = (*t_);
          iroot_ = i_;
        }
        else {
          if (glast_ == 0.0e0) {
            work_[i_ + itroot_ - 1 - 1] = (*t_) + h_;
          }
          else {
            if (_abs (hused_) >= uround_ * _abs ((*t_))) {
              tlast_ = (*t_) - hused_;
              iroot_ = i_;
              troot_ = (*t_);
              (void) _cdzro (&ae_, _g, &h_, &npar_, &iwork_[11], &iroot_, &re_, t_, &work_[250], &uround_, &troot_, &tlast_, &gnow_, 
              &glast_, y_);
              for (j_ = 1; j_ <= (*n_); (j_)++) {
                y_[j_ - 1] = work_[251 + j_ - 1 - 1];
              }
              if (npar_ == 0) {
                iwork_[5] = i_;
                (*nstate_) = 7;
                goto _l0;
              }
              work_[i_ + itroot_ - 1 - 1] = troot_;
            }
            else {
              work_[i_ + itroot_ - 1 - 1] = (*t_);
              iroot_ = i_;
            }
          }
        }
      }
    }
    if (iroot_ == 0) {
      iwork_[7] = 0;
    }
    else {
      iwork_[7] = (*ntask_);
      iwork_[12] = (*nroot_);
      iwork_[13] = itroot_;
      troot_ = (*t_) + h_;
      for (i_ = 1; i_ <= (*nroot_); (i_)++) {
        if ((real_4) (crealf (work_[i_ + itroot_ - 1 - 1])) * hsign_ < troot_ * hsign_) {
          troot_ = (real_4) (crealf (work_[i_ + itroot_ - 1 - 1]));
          iroot_ = i_;
        }
      }
      iwork_[5] = iroot_;
      work_[166] = troot_;
      if (troot_ * hsign_ <= (*tout_) * hsign_) {
        (void) _cdntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
        (*nstate_) = 5;
        (*t_) = troot_;
        (*ierflg_) = 0;
        goto _l580;
      }
    }
  }
  (*nstate_) = 2;
  if ((*ntask_) == 1) {
    if ((*t_) * hsign_ < (*tout_) * hsign_) {
      goto _l260;
    }
    (void) _cdntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
    (*t_) = (*tout_);
    (*ierflg_) = 0;
    goto _l580;
  }
  else if ((*ntask_) == 2) {
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
    }
    else {
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = (*tout_) - (*t_);
        if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
          h_ = h_ * (1.0e0 - 4.0e0 * uround_);
        }
        work_[159] = h_;
        if (h_ == 0.0e0) {
          goto _l670;
        }
        iwork_[8] = -1;
      }
    }
  }
  else if ((*ntask_) == 3) {
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
    }
    else {
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = (*tout_) - (*t_);
        if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
          h_ = h_ * (1.0e0 - 4.0e0 * uround_);
        }
        work_[159] = h_;
        if (h_ == 0.0e0) {
          goto _l670;
        }
        iwork_[8] = -1;
      }
      goto _l260;
    }
  }
  (*ierflg_) = 0;
  _l560:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = work_[i_ + 251 - 1 - 1];
  }
  _l580:;
  if (convrg_) {
    iwork_[6] = 1;
  }
  else {
    iwork_[6] = 0;
  }
  work_[0] = avgh_;
  work_[2] = avgord_;
  work_[1] = hused_;
  work_[161] = hold_;
  work_[163] = rc_;
  work_[164] = rmax_;
  work_[203] = trend_;
  for (j_ = 1; j_ <= 12; (j_)++) {
    for (i_ = 1; i_ <= 13; (i_)++) {
      work_[i_ + 4 + (j_ - 1) * 13 - 1 - 1] = el_[i_ - 1 + (13) * ((j_ - 1))];
    }
  }
  for (j_ = 1; j_ <= 12; (j_)++) {
    for (i_ = 1; i_ <= 3; (i_)++) {
      work_[i_ + 168 + (j_ - 1) * 3 - 1 - 1] = tq_[i_ - 1 + (3) * ((j_ - 1))];
    }
  }
  if (iwork_[8] == 0) {
    goto _l0;
  }
  big_ = 0.0;
  imxerr_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    size_ = cabsf (work_[i_ + isave1_ - 1 - 1] / work_[i_ + iywt_ - 1 - 1]);
    if (big_ < size_) {
      big_ = size_;
      imxerr_ = i_;
    }
  }
  iwork_[0] = imxerr_;
  goto _l0;
  _l660:;
  (*nstate_) = jstate_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = work_[i_ + 251 - 1 - 1];
  }
  if (convrg_) {
    iwork_[6] = 1;
  }
  else {
    iwork_[6] = 0;
  }
  work_[0] = avgh_;
  work_[2] = avgord_;
  work_[1] = hused_;
  work_[161] = hold_;
  work_[163] = rc_;
  work_[164] = rmax_;
  work_[203] = trend_;
  for (j_ = 1; j_ <= 12; (j_)++) {
    for (i_ = 1; i_ <= 13; (i_)++) {
      work_[i_ + 4 + (j_ - 1) * 13 - 1 - 1] = el_[i_ - 1 + (13) * ((j_ - 1))];
    }
  }
  for (j_ = 1; j_ <= 12; (j_)++) {
    for (i_ = 1; i_ <= 3; (i_)++) {
      work_[i_ + 168 + (j_ - 1) * 3 - 1 - 1] = tq_[i_ - 1 + (3) * ((j_ - 1))];
    }
  }
  goto _l0;
  _l670:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:cdriv3:1552", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100661_[__fcnt] != NULL && $f_100661_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100661_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1552", 0));
    __fcnt += 3;
  }
  if ($f_100661_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100661_[__fcnt] != NULL && $f_100661_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100661_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1552", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100661_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1552", 0));
  __fcnt += 3;
  while ($f_100661_[__fcnt] != NULL && $f_100661_[__fcnt] == FMT_TEXT) {
    if ($f_100661_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100661_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1552", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 41;
  (void) _xermsg (_dc_0, _dc_15, (bufcpy ($84_, concat ($83_, concat ($82_, concat ($81_, _dc_39, rl1_), _dc_51), 
  _dc_52), 255), $84_), ierflg_, &_k1);
  (*nstate_) = 12;
  goto _l0;
  _l680:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:cdriv3:1561", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100666_[__fcnt] != NULL && $f_100666_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100666_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1561", 0));
    __fcnt += 3;
  }
  if ($f_100666_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100666_[__fcnt] != NULL && $f_100666_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100666_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1561", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100666_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1561", 0));
  __fcnt += 3;
  while ($f_100666_[__fcnt] != NULL && $f_100666_[__fcnt] == FMT_TEXT) {
    if ($f_100666_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100666_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1561", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 42;
  (void) _xermsg (_dc_0, _dc_15, (bufcpy ($89_, concat ($88_, concat ($87_, concat ($86_, concat ($85_, _dc_39, rl1_), 
  _dc_53), _dc_54), _dc_55), 511), $89_), ierflg_, &_k1);
  (*nstate_) = 12;
  goto _l0;
  _l690:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:cdriv3:1570", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100671_[__fcnt] != NULL && $f_100671_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100671_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1570", 0));
    __fcnt += 3;
  }
  if ($f_100671_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100671_[__fcnt] != NULL && $f_100671_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100671_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1570", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100671_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1570", 0));
  __fcnt += 3;
  while ($f_100671_[__fcnt] != NULL && $f_100671_[__fcnt] == FMT_TEXT) {
    if ($f_100671_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100671_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:cdriv3:1570", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 43;
  (void) _xermsg (_dc_0, _dc_15, (bufcpy ($92_, concat ($91_, concat ($90_, _dc_39, rl1_), _dc_56), 127), $92_), ierflg_, 
  &_k1);
  (*nstate_) = 12;
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _cdscl (real_4 _p_ hmax_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ rmax_, real_4 _p_ h_, real_4 _p_ rc_, real_4 
_p_ rh_, complex_8 _p_ yh_)
{
  static int_4 i_, j_;
  static real_4 r1_;
  real_4 $0_, $1_;
  if ((*h_) < 1.0e0) {
    (*rh_) = ($0_ = _min (_abs ((*h_)) * (*rh_), _abs ((*h_)) * (*rmax_)), _min ($0_, (*hmax_))) / _abs ((*h_));
  }
  else {
    (*rh_) = ($1_ = _min ((*rh_), (*rmax_)), _min ($1_, (*hmax_) / _abs ((*h_))));
  }
  r1_ = 1.0;
  for (j_ = 1; j_ <= (*nq_); (j_)++) {
    r1_ = r1_ * (*rh_);
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))] * r1_;
    }
  }
  (*h_) = (*h_) * (*rh_);
  (*rc_) = (*rc_) * (*rh_);
  __calls[9].calls++;
  return 0;
}

int_4 _cdstp (real_4 _p_ eps_, int_4 (*_f)(), real_4 (*_fa)(), real_4 _p_ hmax_, int_4 _p_ impl_, int_4 _p_ ierror_, 
int_4 (*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ 
mu_, int_4 _p_ n_, int_4 _p_ nde_, complex_8 _p_ ywt_, real_4 _p_ uround_, real_4 (*_users)(), real_4 _p_ avgh_, real_4 
_p_ avgord_, real_4 _p_ h_, real_4 _p_ hused_, int_4 _p_ jtask_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, 
int_4 _p_ nje_, int_4 _p_ nqused_, int_4 _p_ nstep_, real_4 _p_ t_, complex_8 _p_ y_, complex_8 _p_ yh_, complex_8 _p_ 
a_, logical_4 _p_ convrg_, complex_8 _p_ dfdy_, real_4 _p_ el_, complex_8 _p_ fac_, real_4 _p_ hold_, int_4 _p_ ipvt_, 
int_4 _p_ jstate_, int_4 _p_ jstepl_, int_4 _p_ nq_, int_4 _p_ nwait_, real_4 _p_ rc_, real_4 _p_ rmax_, complex_8 _p_ 
save1_, complex_8 _p_ save2_, real_4 _p_ tq_, real_4 _p_ trend_, int_4 _p_ iswflg_, int_4 _p_ mtrsv_, int_4 _p_ mxrdsv_
)
{
  static int_4 i_, iter_, j_, nfail_, nsv_, ntry_;
  static logical_4 evalfa_, evaljc_, ier_, switch_;
  static real_4 bnd_, ctest_, d_, denom_, d1_, erdn_, erup_, etest_, hn_, hs_, numer_, rh_, rh1_, rh2_, rh3_, told_, 
  y0nrm_;
  int_4 _data_k_1;
  extern real_4 _scnrm2 ();
#define _data_n_1 1
  static logical_4 _data_l_1[_data_n_1] = {
    FALSE
  };
  if (__calls[10].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    ier_ = _data_l_1[_data_k_1++];
  }
  nsv_ = (*n_);
  bnd_ = 0.0;
  switch_ = FALSE;
  ntry_ = 0;
  told_ = (*t_);
  nfail_ = 0;
  if ((*jtask_) <= 0) {
    (void) _cdntl (eps_, _f, _fa, hmax_, hold_, impl_, jtask_, matdim_, maxord_, mint_, miter_, ml_, mu_, n_, nde_, save1_, 
    t_, uround_, _users, y_, ywt_, h_, mntold_, mtrold_, nfe_, rc_, yh_, a_, convrg_, el_, fac_, &ier_, ipvt_, nq_, nwait_, 
    &rh_, rmax_, save2_, tq_, trend_, iswflg_, jstate_);
    if ((*n_) == 0) {
      goto _l440;
    }
    if ((*h_) == 0.0e0) {
      goto _l400;
    }
    if (ier_) {
      goto _l420;
    }
  }
  _l100:;
  ntry_ = ntry_ + 1;
  if (ntry_ > 50) {
    goto _l410;
  }
  (*t_) = (*t_) + (*h_);
  (void) _cdpsc (&_k1, n_, nq_, yh_);
  evaljc_ = (((_abs ((*rc_) - 1.0e0) > .3e0) || ((*nstep_) >= (*jstepl_) + 10)) && ((*miter_) != 0));
  evalfa_ = ! (evaljc_);
  _l110:;
  iter_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  (void) _f (n_, t_, y_, save2_);
  if ((*n_) == 0) {
    (*jstate_) = 6;
    goto _l430;
  }
  (*nfe_) = (*nfe_) + 1;
  if (evaljc_ || ier_) {
    (void) _cdpst (el_, _f, _fa, h_, impl_, _jacobn, matdim_, miter_, ml_, mu_, n_, nde_, nq_, save2_, t_, _users, y_, yh_, 
    ywt_, uround_, nfe_, nje_, a_, dfdy_, fac_, &ier_, ipvt_, save1_, iswflg_, &bnd_, jstate_);
    if ((*n_) == 0) {
      goto _l430;
    }
    if (ier_) {
      goto _l160;
    }
    (*convrg_) = FALSE;
    (*rc_) = 1.0;
    (*jstepl_) = (*nstep_);
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    save1_[i_ - 1] = 0.0;
  }
  _l130:;
  (void) _cdcor (dfdy_, el_, _fa, h_, ierror_, impl_, ipvt_, matdim_, miter_, ml_, mu_, n_, nde_, nq_, t_, _users, y_, 
  yh_, ywt_, &evalfa_, save1_, save2_, a_, &d_, jstate_);
  if ((*n_) == 0) {
    goto _l430;
  }
  if ((*iswflg_) == 3 && (*mint_) == 1) {
    if (iter_ == 0) {
      numer_ = _scnrm2 (n_, save1_, &_k1);
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1];
      }
      y0nrm_ = _scnrm2 (n_, yh_, &_k1);
    }
    else {
      denom_ = numer_;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1] - dfdy_[0 + ((*matdim_)) * ((i_ - 1))];
      }
      numer_ = _scnrm2 (n_, dfdy_, matdim_);
      if (el_[0 + (13) * (((*nq_) - 1))] * numer_ <= 100.0e0 * (*uround_) * y0nrm_) {
        if ((*rmax_) == 2.0) {
          switch_ = TRUE;
          goto _l170;
        }
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1];
      }
      if (denom_ != 0.0e0) {
        bnd_ = _max (bnd_, numer_ / (denom_ * _abs ((*h_)) * el_[0 + (13) * (((*nq_) - 1))]));
      }
    }
  }
  if (iter_ > 0) {
    (*trend_) = _max (.9e0 * (*trend_), d_ / d1_);
  }
  d1_ = d_;
  ctest_ = _min (2.0e0 * (*trend_), 1.0) * d_;
  if (ctest_ <= (*eps_)) {
    goto _l170;
  }
  iter_ = iter_ + 1;
  if (iter_ < 3) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))] + el_[0 + (13) * (((*nq_) - 1))] * save1_[i_ - 1];
    }
    (void) _f (n_, t_, y_, save2_);
    if ((*n_) == 0) {
      (*jstate_) = 6;
      goto _l430;
    }
    (*nfe_) = (*nfe_) + 1;
    goto _l130;
  }
  if ((*convrg_)) {
    evaljc_ = TRUE;
    evalfa_ = FALSE;
    goto _l110;
  }
  _l160:;
  (*t_) = told_;
  (void) _cdpsc (&_km1, n_, nq_, yh_);
  (*nwait_) = (*nq_) + 2;
  if ((*jtask_) != 0 && (*jtask_) != 2) {
    (*rmax_) = 2.0;
  }
  if (iter_ == 0) {
    rh_ = .3e0;
  }
  else {
    rh_ = .9e0 * powl (((*eps_) / ctest_), .2e0);
  }
  if (rh_ * (*h_) == 0.0e0) {
    goto _l400;
  }
  (void) _cdscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
  goto _l100;
  _l170:;
  (*convrg_) = ((*miter_) != 0);
  if ((*ierror_) == 1 || (*ierror_) == 5) {
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save2_[i_ - 1] = save1_[i_ - 1] / ywt_[i_ - 1];
    }
  }
  else {
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save2_[i_ - 1] = save1_[i_ - 1] / _max (cabsf (y_[i_ - 1]), cabsf (ywt_[i_ - 1]));
    }
  }
  etest_ = _scnrm2 (nde_, save2_, &_k1) / (tq_[1 + (3) * (((*nq_) - 1))] * sqrtf ((real_4) ((*nde_))));
  if (etest_ > (*eps_)) {
    (*t_) = told_;
    (void) _cdpsc (&_km1, n_, nq_, yh_);
    nfail_ = nfail_ + 1;
    if (nfail_ < 3 || (*nq_) == 1) {
      if ((*jtask_) != 0 && (*jtask_) != 2) {
        (*rmax_) = 2.0;
      }
      rh2_ = 1.0e0 / (1.2 * powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
      if ((*nq_) > 1) {
        if ((*ierror_) == 1 || (*ierror_) == 5) {
          for (i_ = 1; i_ <= (*nde_); (i_)++) {
            save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / ywt_[i_ - 1];
          }
        }
        else {
          for (i_ = 1; i_ <= (*nde_); (i_)++) {
            save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / _max (cabsf (y_[i_ - 1]), cabsf (ywt_[i_ - 1]));
          }
        }
        erdn_ = _scnrm2 (nde_, save2_, &_k1) / (tq_[0 + (3) * (((*nq_) - 1))] * sqrtf ((real_4) ((*nde_))));
        rh1_ = 1.0e0 / _max (1.0, 1.3 * powl ((erdn_ / (*eps_)), (1.0e0 / (*nq_))));
        if (rh2_ < rh1_) {
          (*nq_) = (*nq_) - 1;
          (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) + 1 - 1))];
          rh_ = rh1_;
        }
        else {
          rh_ = rh2_;
        }
      }
      else {
        rh_ = rh2_;
      }
      (*nwait_) = (*nq_) + 2;
      if (rh_ * (*h_) == 0.0e0) {
        goto _l400;
      }
      (void) _cdscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
      goto _l100;
    }
    nfail_ = 0;
    (*jtask_) = 2;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
    }
    (void) _cdntl (eps_, _f, _fa, hmax_, hold_, impl_, jtask_, matdim_, maxord_, mint_, miter_, ml_, mu_, n_, nde_, save1_, 
    t_, uround_, _users, y_, ywt_, h_, mntold_, mtrold_, nfe_, rc_, yh_, a_, convrg_, el_, fac_, &ier_, ipvt_, nq_, nwait_, 
    &rh_, rmax_, save2_, tq_, trend_, iswflg_, jstate_);
    (*rmax_) = 10.0;
    if ((*n_) == 0) {
      goto _l440;
    }
    if ((*h_) == 0.0e0) {
      goto _l400;
    }
    if (ier_) {
      goto _l420;
    }
    goto _l100;
  }
  (*nstep_) = (*nstep_) + 1;
  (*hused_) = (*h_);
  (*nqused_) = (*nq_);
  (*avgh_) = (((*nstep_) - 1) * (*avgh_) + (*h_)) / (*nstep_);
  (*avgord_) = (((*nstep_) - 1) * (*avgord_) + (*nq_)) / (*nstep_);
  for (j_ = 1; j_ <= (*nq_) + 1; (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + el_[j_ - 1 + (13) * (((*nq_) - 1))] * 
      save1_[i_ - 1];
    }
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  if ((*iswflg_) == 3) {
    if (bnd_ != 0.0e0) {
      if ((*mint_) == 1 && (*nq_) <= 5) {
        hn_ = _abs ((*h_)) / _max ((*uround_), powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _min (hn_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_));
        hs_ = _abs ((*h_)) / _max ((*uround_), powl ((etest_ / ((*eps_) * el_[(*nq_) + 1 - 1])), (1.0e0 / ((*nq_) + 1))));
        if (hs_ > 1.2e0 * hn_) {
          (*mint_) = 2;
          (*mntold_) = (*mint_);
          (*miter_) = (*mtrsv_);
          (*mtrold_) = (*miter_);
          (*maxord_) = _min ((*mxrdsv_), 5);
          (*rc_) = 0.0;
          (*rmax_) = 10.0;
          (*trend_) = 1.0;
          (void) _cdcst (maxord_, mint_, iswflg_, el_, tq_);
          (*nwait_) = (*nq_) + 2;
        }
      }
      else if ((*mint_) == 2) {
        hs_ = _abs ((*h_)) / _max ((*uround_), powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _abs ((*h_)) / _max ((*uround_), powl ((etest_ * el_[(*nq_) + 1 - 1] / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _min (hn_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_));
        if (hn_ >= hs_) {
          (*mint_) = 1;
          (*mntold_) = (*mint_);
          (*miter_) = 0;
          (*mtrold_) = (*miter_);
          (*maxord_) = _min ((*mxrdsv_), 12);
          (*rmax_) = 10.0;
          (*trend_) = 1.0;
          (*convrg_) = FALSE;
          (void) _cdcst (maxord_, mint_, iswflg_, el_, tq_);
          (*nwait_) = (*nq_) + 2;
        }
      }
    }
  }
  if (switch_) {
    (*mint_) = 2;
    (*mntold_) = (*mint_);
    (*miter_) = (*mtrsv_);
    (*mtrold_) = (*miter_);
    (*maxord_) = _min ((*mxrdsv_), 5);
    (*nq_) = _min ((*nq_), (*maxord_));
    (*rc_) = 0.0;
    (*rmax_) = 10.0;
    (*trend_) = 1.0;
    (void) _cdcst (maxord_, mint_, iswflg_, el_, tq_);
    (*nwait_) = (*nq_) + 2;
  }
  if ((*jtask_) == 0 || (*jtask_) == 2) {
    rh_ = 1.0e0 / _max ((*uround_), 1.2 * powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
    if (rh_ > 1.0) {
      (void) _cdscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
    }
  }
  else if ((*nwait_) > 1) {
    (*nwait_) = (*nwait_) - 1;
    if ((*nwait_) == 1 && (*nq_) < (*maxord_)) {
      for (i_ = 1; i_ <= (*nde_); (i_)++) {
        yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))] = save1_[i_ - 1];
      }
    }
  }
  else {
    if ((*nq_) == 1) {
      rh1_ = 0.0;
    }
    else {
      if ((*ierror_) == 1 || (*ierror_) == 5) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / ywt_[i_ - 1];
        }
      }
      else {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / _max (cabsf (y_[i_ - 1]), cabsf (ywt_[i_ - 1]));
        }
      }
      erdn_ = _scnrm2 (nde_, save2_, &_k1) / (tq_[0 + (3) * (((*nq_) - 1))] * sqrtf ((real_4) ((*nde_))));
      rh1_ = 1.0e0 / _max ((*uround_), 1.3 * powl ((erdn_ / (*eps_)), (1.0e0 / (*nq_))));
    }
    rh2_ = 1.0e0 / _max ((*uround_), 1.2 * powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
    if ((*nq_) == (*maxord_)) {
      rh3_ = 0.0;
    }
    else {
      if ((*ierror_) == 1 || (*ierror_) == 5) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = (save1_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))]) / ywt_[i_ - 1];
        }
      }
      else {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = (save1_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))]) / _max (cabsf (y_[i_ - 1]), cabsf 
          (ywt_[i_ - 1]));
        }
      }
      erup_ = _scnrm2 (nde_, save2_, &_k1) / (tq_[2 + (3) * (((*nq_) - 1))] * sqrtf ((real_4) ((*nde_))));
      rh3_ = 1.0e0 / _max ((*uround_), 1.4 * powl ((erup_ / (*eps_)), (1.0e0 / ((*nq_) + 2))));
    }
    if (rh1_ > rh2_ && rh1_ >= rh3_) {
      rh_ = rh1_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
      (*nq_) = (*nq_) - 1;
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) + 1 - 1))];
    }
    else if (rh2_ >= rh1_ && rh2_ >= rh3_) {
      rh_ = rh2_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
    }
    else {
      rh_ = rh3_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        yh_[i_ - 1 + ((*n_)) * (((*nq_) + 2 - 1))] = save1_[i_ - 1] * el_[(*nq_) + 1 - 1 + (13) * (((*nq_) - 1))] / ((*nq_) + 
        1);
      }
      (*nq_) = (*nq_) + 1;
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) - 1 - 1))];
    }
    if ((*iswflg_) == 3 && (*mint_) == 1) {
      if (bnd_ != 0.0e0) {
        rh_ = _min (rh_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_ * _abs ((*h_))));
      }
    }
    (void) _cdscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
    (*rmax_) = 10.0;
    _l380:;
    (*nwait_) = (*nq_) + 2;
  }
  (*jstate_) = 1;
  (*hold_) = (*h_);
  goto _l0;
  _l400:;
  (*jstate_) = 2;
  (*hold_) = (*h_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  goto _l0;
  _l410:;
  (*jstate_) = 3;
  (*hold_) = (*h_);
  goto _l0;
  _l420:;
  (*jstate_) = 4;
  (*hold_) = (*h_);
  goto _l0;
  _l430:;
  (*t_) = told_;
  (void) _cdpsc (&_km1, &nsv_, nq_, yh_);
  for (i_ = 1; i_ <= nsv_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  _l440:;
  (*hold_) = (*h_);
  _l0:;
  __calls[10].calls++;
  return 0;
}

int_4 _cdzro (real_4 _p_ ae_, real_4 (*_f)(), real_4 _p_ h_, int_4 _p_ n_, int_4 _p_ nq_, int_4 _p_ iroot_, real_4 _p_ 
re_, real_4 _p_ t_, complex_8 _p_ yh_, real_4 _p_ uround_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ fb_, real_4 _p_ fc_
, complex_8 _p_ y_)
{
  static int_4 ic_, kount_;
  static real_4 a_, acbs_, acmb_, cmb_, er_, fa_, p_, q_, rw_, tol_;
  er_ = 4.0e0 * (*uround_);
  rw_ = _max ((*re_), er_);
  ic_ = 0;
  acbs_ = _abs ((*b_) - (*c_));
  a_ = (*c_);
  fa_ = (*fc_);
  kount_ = 0;
  _l10:;
  if (_abs ((*fc_)) < _abs ((*fb_))) {
    a_ = (*b_);
    fa_ = (*fb_);
    (*b_) = (*c_);
    (*fb_) = (*fc_);
    (*c_) = a_;
    (*fc_) = fa_;
  }
  cmb_ = 0.5e0 * ((*c_) - (*b_));
  acmb_ = _abs (cmb_);
  tol_ = rw_ * _abs ((*b_)) + (*ae_);
  if (acmb_ <= tol_) {
    goto _l0;
  }
  if (kount_ > 50) {
    goto _l0;
  }
  p_ = ((*b_) - a_) * (*fb_);
  q_ = fa_ - (*fb_);
  if (p_ < 0.0e0) {
    p_ = -p_;
    q_ = -q_;
  }
  a_ = (*b_);
  fa_ = (*fb_);
  ic_ = ic_ + 1;
  if (ic_ >= 4) {
    if (8.0e0 * acmb_ >= acbs_) {
      (*b_) = 0.5e0 * ((*c_) + (*b_));
      goto _l20;
    }
    ic_ = 0;
  }
  acbs_ = acmb_;
  if (p_ <= _abs (q_) * tol_) {
    (*b_) = (*b_) + _sign (tol_, cmb_);
  }
  else if (p_ < cmb_ * q_) {
    (*b_) = (*b_) + p_ / q_;
  }
  else {
    (*b_) = 0.5e0 * ((*c_) + (*b_));
  }
  _l20:;
  (void) _cdntp (h_, &_k0, n_, nq_, t_, b_, yh_, y_);
  (*fb_) = _f (n_, b_, y_, iroot_);
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*fb_) == 0.0e0) {
    goto _l0;
  }
  kount_ = kount_ + 1;
  if (_sign (1.0, (*fb_)) == _sign (1.0, (*fc_))) {
    (*c_) = a_;
    (*fc_) = fa_;
  }
  goto _l10;
  _l0:;
  __calls[11].calls++;
  return 0;
}

int_4 _ddcor (real_8 _p_ dfdy_, real_8 _p_ el_, int_4 (*_fa)(), real_8 _p_ h_, int_4 _p_ ierror_, int_4 _p_ impl_, 
int_4 _p_ ipvt_, int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 
_p_ nq_, real_8 _p_ t_, int_4 (*_users)(), real_8 _p_ y_, real_8 _p_ yh_, real_8 _p_ ywt_, logical_4 _p_ evalfa_, 
real_8 _p_ save1_, real_8 _p_ save2_, real_8 _p_ a_, real_8 _p_ d_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, j_, mw_;
  extern real_8 _dnrm2 ();
  if ((*miter_) == 0) {
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = ((*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1]) / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = ((*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1]) / _max (_abs (y_[i_ - 1]), 
        ywt_[i_ - 1]);
      }
    }
    (*d_) = _dnrm2 (n_, save1_, &_k1) / sqrt ((real_8) ((*n_)));
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      save1_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))];
    }
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1];
      }
    }
    else if ((*impl_) == 1) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          save2_[i_ - 1] = save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) * ((1))] + save1_[j_ - 
          1]);
        }
      }
    }
    else if ((*impl_) == 2) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((0))] * (yh_[i_ - 1 + ((*n_)) * ((1))] + 
        save1_[i_ - 1]);
      }
    }
    else if ((*impl_) == 3) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) * ((1))] + save1_[j_ - 
          1]);
        }
      }
    }
    (void) _dgesl (dfdy_, matdim_, n_, ipvt_, save2_, &_k0);
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
      }
    }
    (*d_) = _dnrm2 (n_, save2_, &_k1) / sqrt ((real_8) ((*n_)));
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1];
      }
    }
    else if ((*impl_) == 1) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      mw_ = (*ml_) + 1 + (*mu_);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          save2_[i_ + j_ - mw_ - 1] = save2_[i_ + j_ - mw_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) 
          * ((1))] + save1_[j_ - 1]);
        }
      }
    }
    else if ((*impl_) == 2) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((0))] * (yh_[i_ - 1 + ((*n_)) * ((1))] + 
        save1_[i_ - 1]);
      }
    }
    else if ((*impl_) == 3) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      mw_ = (*ml_) + 1 + (*mu_);
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*nde_) - j_, mw_ + (*ml_)); (i_)++) {
          save2_[i_ + j_ - mw_ - 1] = save2_[i_ + j_ - mw_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) 
          * ((1))] + save1_[j_ - 1]);
        }
      }
    }
    (void) _dgbsl (dfdy_, matdim_, n_, ml_, mu_, ipvt_, save2_, &_k0);
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
      }
    }
    (*d_) = _dnrm2 (n_, save2_, &_k1) / sqrt ((real_8) ((*n_)));
  }
  else if ((*miter_) == 3) {
    iflag_ = 2;
    (void) _users (y_, &yh_[0 + ((*n_)) * ((1))], ywt_, save1_, save2_, t_, h_, &el_[0 + (13) * (((*nq_) - 1))], impl_, n_, 
    nde_, &iflag_);
    if ((*n_) == 0) {
      (*jstate_) = 10;
      goto _l0;
    }
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
      }
    }
    (*d_) = _dnrm2 (n_, save2_, &_k1) / sqrt ((real_8) ((*n_)));
  }
  _l0:;
  __calls[12].calls++;
  return 0;
}

int_4 _ddcst (int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ iswflg_, real_8 _p_ el_, real_8 _p_ tq_)
{
  static int_4 i_, j_, mxrd_;
  static real_8 factrl_[12], gamma_[14], sum_;
  factrl_[0] = 1.0;
  for (i_ = 2; i_ <= (*maxord_); (i_)++) {
    factrl_[i_ - 1] = i_ * factrl_[i_ - 1 - 1];
  }
  if ((*mint_) == 1) {
    gamma_[0] = 1.0;
    for (i_ = 1; i_ <= (*maxord_) + 1; (i_)++) {
      sum_ = 0.0;
      for (j_ = 1; j_ <= i_; (j_)++) {
        sum_ = sum_ - gamma_[j_ - 1] / (i_ - j_ + 2);
      }
      gamma_[i_ + 1 - 1] = sum_;
    }
    el_[0] = 1.0;
    el_[1] = 1.0;
    el_[14] = 1.0;
    el_[15] = 1.0;
    for (j_ = 3; j_ <= (*maxord_); (j_)++) {
      el_[1 + (13) * ((j_ - 1))] = factrl_[j_ - 1 - 1];
      for (i_ = 3; i_ <= j_; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = (j_ - 1) * el_[i_ - 1 + (13) * ((j_ - 1 - 1))] + el_[i_ - 1 - 1 + (13) * ((j_ - 1 - 
        1))];
      }
      el_[j_ + 1 - 1 + (13) * ((j_ - 1))] = 1.0;
    }
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      el_[0 + (13) * ((j_ - 1))] = el_[0 + (13) * ((j_ - 1 - 1))] + gamma_[j_ - 1];
      el_[1 + (13) * ((j_ - 1))] = 1.0;
      for (i_ = 3; i_ <= j_ + 1; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = el_[i_ - 1 + (13) * ((j_ - 1))] / ((i_ - 1) * factrl_[j_ - 1 - 1]);
      }
    }
    for (j_ = 1; j_ <= (*maxord_); (j_)++) {
      tq_[0 + (3) * ((j_ - 1))] = -1.0e0 / (factrl_[j_ - 1] * gamma_[j_ - 1]);
      tq_[1 + (3) * ((j_ - 1))] = -1.0e0 / gamma_[j_ + 1 - 1];
      tq_[2 + (3) * ((j_ - 1))] = -1.0e0 / gamma_[j_ + 2 - 1];
    }
  }
  else if ((*mint_) == 2) {
    el_[0] = 1.0;
    el_[1] = 1.0;
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      el_[0 + (13) * ((j_ - 1))] = factrl_[j_ - 1];
      for (i_ = 2; i_ <= j_; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = j_ * el_[i_ - 1 + (13) * ((j_ - 1 - 1))] + el_[i_ - 1 - 1 + (13) * ((j_ - 1 - 1))];
      }
      el_[j_ + 1 - 1 + (13) * ((j_ - 1))] = 1.0;
    }
    sum_ = 1.0;
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      sum_ = sum_ + 1.0e0 / j_;
      for (i_ = 1; i_ <= j_ + 1; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = el_[i_ - 1 + (13) * ((j_ - 1))] / (factrl_[j_ - 1] * sum_);
      }
    }
    for (j_ = 1; j_ <= (*maxord_); (j_)++) {
      if (j_ > 1) {
        tq_[0 + (3) * ((j_ - 1))] = 1.0e0 / factrl_[j_ - 1 - 1];
      }
      tq_[1 + (3) * ((j_ - 1))] = (j_ + 1) / el_[0 + (13) * ((j_ - 1))];
      tq_[2 + (3) * ((j_ - 1))] = (j_ + 2) / el_[0 + (13) * ((j_ - 1))];
    }
  }
  if ((*iswflg_) == 3) {
    mxrd_ = _min ((*maxord_), 5);
    if ((*mint_) == 2) {
      gamma_[0] = 1.0;
      for (i_ = 1; i_ <= mxrd_; (i_)++) {
        sum_ = 0.0;
        for (j_ = 1; j_ <= i_; (j_)++) {
          sum_ = sum_ - gamma_[j_ - 1] / (i_ - j_ + 2);
        }
        gamma_[i_ + 1 - 1] = sum_;
      }
    }
    sum_ = 1.0;
    for (i_ = 2; i_ <= mxrd_; (i_)++) {
      sum_ = sum_ + 1.0e0 / i_;
      el_[1 + i_ - 1] = -(i_ + 1) * sum_ * gamma_[i_ + 1 - 1];
    }
  }
  __calls[13].calls++;
  return 0;
}

int_4 _ddntl (real_8 _p_ eps_, int_4 (*_f)(), int_4 (*_fa)(), real_8 _p_ hmax_, real_8 _p_ hold_, int_4 _p_ impl_, 
int_4 _p_ jtask_, int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_
, int_4 _p_ n_, int_4 _p_ nde_, real_8 _p_ save1_, real_8 _p_ t_, real_8 _p_ uround_, int_4 (*_users)(), real_8 _p_ y_, 
real_8 _p_ ywt_, real_8 _p_ h_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, real_8 _p_ rc_, real_8 _p_ yh_, 
real_8 _p_ a_, logical_4 _p_ convrg_, real_8 _p_ el_, real_8 _p_ fac_, logical_4 _p_ ier_, int_4 _p_ ipvt_, int_4 _p_ 
nq_, int_4 _p_ nwait_, real_8 _p_ rh_, real_8 _p_ rmax_, real_8 _p_ save2_, real_8 _p_ tq_, real_8 _p_ trend_, int_4 
_p_ iswflg_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, info_;
  static real_8 oldl0_, sum_;
  extern real_8 _dnrm2 ();
  (*ier_) = FALSE;
  if ((*jtask_) >= 0) {
    if ((*jtask_) == 0) {
      (void) _ddcst (maxord_, mint_, iswflg_, el_, tq_);
      (*rmax_) = 10000.0;
    }
    (*rc_) = 0.0;
    (*convrg_) = FALSE;
    (*trend_) = 1.0;
    (*nq_) = 1;
    (*nwait_) = 3;
    (void) _f (n_, t_, y_, save2_);
    if ((*n_) == 0) {
      (*jstate_) = 6;
      goto _l0;
    }
    (*nfe_) = (*nfe_) + 1;
    if ((*impl_) != 0) {
      if ((*miter_) == 3) {
        iflag_ = 0;
        (void) _users (y_, yh_, ywt_, save1_, save2_, t_, h_, el_, impl_, n_, nde_, &iflag_);
        if (iflag_ == -1) {
          (*ier_) = TRUE;
          goto _l0;
        }
        if ((*n_) == 0) {
          (*jstate_) = 10;
          goto _l0;
        }
      }
      else if ((*impl_) == 1) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _dgefa (a_, matdim_, n_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _dgesl (a_, matdim_, n_, ipvt_, save2_, &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _dgbfa (a_, matdim_, n_, ml_, mu_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _dgbsl (a_, matdim_, n_, ml_, mu_, ipvt_, save2_, &_k0);
        }
      }
      else if ((*impl_) == 2) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          if (a_[i_ - 1 + ((*matdim_)) * ((0))] == 0.0e0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          else {
            save2_[i_ - 1] = save2_[i_ - 1] / a_[i_ - 1 + ((*matdim_)) * ((0))];
          }
        }
        for (i_ = (*nde_) + 1; i_ <= (*n_); (i_)++) {
          a_[i_ - 1 + ((*matdim_)) * ((0))] = 0.0;
        }
      }
      else if ((*impl_) == 3) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _dgefa (a_, matdim_, nde_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _dgesl (a_, matdim_, nde_, ipvt_, save2_, &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _dgbfa (a_, matdim_, nde_, ml_, mu_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _dgbsl (a_, matdim_, nde_, ml_, mu_, ipvt_, save2_, &_k0);
        }
      }
    }
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save1_[i_ - 1] = save2_[i_ - 1] / _max (1.0, ywt_[i_ - 1]);
    }
    sum_ = _dnrm2 (nde_, save1_, &_k1) / sqrt ((real_8) ((*nde_)));
    if (sum_ > (*eps_) / _abs ((*h_))) {
      (*h_) = _sign ((*eps_) / sum_, (*h_));
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((1))] = (*h_) * save2_[i_ - 1];
    }
    if ((*miter_) == 2 || (*miter_) == 5 || (*iswflg_) == 3) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        fac_[i_ - 1] = sqrt ((*uround_));
      }
    }
  }
  else {
    if ((*miter_) != (*mtrold_)) {
      (*mtrold_) = (*miter_);
      (*rc_) = 0.0;
      (*convrg_) = FALSE;
    }
    if ((*mint_) != (*mntold_)) {
      (*mntold_) = (*mint_);
      oldl0_ = el_[0 + (13) * (((*nq_) - 1))];
      (void) _ddcst (maxord_, mint_, iswflg_, el_, tq_);
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / oldl0_;
      (*nwait_) = (*nq_) + 2;
    }
    if ((*h_) != (*hold_)) {
      (*nwait_) = (*nq_) + 2;
      (*rh_) = (*h_) / (*hold_);
      (void) _ddscl (hmax_, n_, nq_, rmax_, hold_, rc_, rh_, yh_);
    }
  }
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _ddntp (real_8 _p_ h_, int_4 _p_ k_, int_4 _p_ n_, int_4 _p_ nq_, real_8 _p_ t_, real_8 _p_ tout_, real_8 _p_ yh_
, real_8 _p_ y_)
{
  static int_4 i_, j_, jj_, kk_, kused_;
  static real_8 factor_, r_;
  if ((*k_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))];
    }
    r_ = (((*tout_) - (*t_)) / (*h_));
    for (jj_ = 1; jj_ <= (*nq_); (jj_)++) {
      j_ = (*nq_) + 1 - jj_;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + r_ * y_[i_ - 1];
      }
    }
  }
  else {
    kused_ = _min ((*k_), (*nq_));
    factor_ = 1.0;
    for (kk_ = 1; kk_ <= kused_; (kk_)++) {
      factor_ = factor_ * ((*nq_) + 1 - kk_);
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = factor_ * yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))];
    }
    r_ = (((*tout_) - (*t_)) / (*h_));
    for (jj_ = kused_ + 1; jj_ <= (*nq_); (jj_)++) {
      j_ = kused_ + 1 + (*nq_) - jj_;
      factor_ = 1.0;
      for (kk_ = 1; kk_ <= kused_; (kk_)++) {
        factor_ = factor_ * (j_ - kk_);
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        y_[i_ - 1] = factor_ * yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + r_ * y_[i_ - 1];
      }
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = y_[i_ - 1] * _up_real_8 ((*h_), (-kused_));
    }
  }
  __calls[15].calls++;
  return 0;
}

int_4 _ddpsc (int_4 _p_ ksgn_, int_4 _p_ n_, int_4 _p_ nq_, real_8 _p_ yh_)
{
  static int_4 i_, j_, j1_, j2_;
  if ((*ksgn_) > 0) {
    for (j1_ = 1; j1_ <= (*nq_); (j1_)++) {
      for (j2_ = j1_; j2_ <= (*nq_); (j2_)++) {
        j_ = (*nq_) - j2_ + j1_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))];
        }
      }
    }
  }
  else {
    for (j1_ = 1; j1_ <= (*nq_); (j1_)++) {
      for (j2_ = j1_; j2_ <= (*nq_); (j2_)++) {
        j_ = (*nq_) - j2_ + j1_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] - yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))];
        }
      }
    }
  }
  __calls[16].calls++;
  return 0;
}

int_4 _ddpst (real_8 _p_ el_, int_4 (*_f)(), int_4 (*_fa)(), real_8 _p_ h_, int_4 _p_ impl_, int_4 (*_jacobn)(), int_4 
_p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 _p_ nq_, real_8 _p_ 
save2_, real_8 _p_ t_, int_4 (*_users)(), real_8 _p_ y_, real_8 _p_ yh_, real_8 _p_ ywt_, real_8 _p_ uround_, int_4 _p_ 
nfe_, int_4 _p_ nje_, real_8 _p_ a_, real_8 _p_ dfdy_, real_8 _p_ fac_, logical_4 _p_ ier_, int_4 _p_ ipvt_, real_8 _p_ 
save1_, int_4 _p_ iswflg_, real_8 _p_ bnd_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, imax_, info_, j_, j2_, k_, mw_;
  static real_8 bl_, bp_, br_, dfdymx_, diff_, dy_, facmin_, factor_, scale_, yj_, ys_;
  int_4 $0_, $1_;
  real_8 $2_;
  extern real_8 _dnrm2 ();
  (*nje_) = (*nje_) + 1;
  (*ier_) = FALSE;
  if ((*miter_) == 1 || (*miter_) == 2) {
    if ((*miter_) == 1) {
      (void) _jacobn (n_, t_, y_, dfdy_, matdim_, ml_, mu_);
      if ((*n_) == 0) {
        (*jstate_) = 8;
        goto _l0;
      }
      if ((*iswflg_) == 3) {
        (*bnd_) = _dnrm2 (($0_ = (*n_) * (*n_), &$0_), dfdy_, &_k1);
      }
      factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = factor_ * dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))];
        }
      }
    }
    else if ((*miter_) == 2) {
      br_ = pow ((*uround_), .875e0);
      bl_ = pow ((*uround_), .75e0);
      bp_ = pow ((*uround_), -.15e0);
      facmin_ = pow ((*uround_), .78e0);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        ys_ = _max (_abs (ywt_[j_ - 1]), _abs (y_[j_ - 1]));
        _l120:;
        dy_ = fac_[j_ - 1] * ys_;
        if (dy_ == 0.0e0) {
          if (fac_[j_ - 1] < .5e0) {
            fac_[j_ - 1] = _min (100.0e0 * fac_[j_ - 1], .5e0);
            goto _l120;
          }
          else {
            dy_ = ys_;
          }
        }
        if ((*nq_) == 1) {
          dy_ = _sign (dy_, save2_[j_ - 1]);
        }
        else {
          dy_ = _sign (dy_, yh_[j_ - 1 + ((*n_)) * ((2))]);
        }
        dy_ = (y_[j_ - 1] + dy_) - y_[j_ - 1];
        yj_ = y_[j_ - 1];
        y_[j_ - 1] = y_[j_ - 1] + dy_;
        (void) _f (n_, t_, y_, save1_);
        if ((*n_) == 0) {
          (*jstate_) = 6;
          goto _l0;
        }
        y_[j_ - 1] = yj_;
        factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_) / dy_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = (save1_[i_ - 1] - save2_[i_ - 1]) * factor_;
        }
        diff_ = _abs (save2_[0] - save1_[0]);
        imax_ = 1;
        for (i_ = 2; i_ <= (*n_); (i_)++) {
          if (_abs (save2_[i_ - 1] - save1_[i_ - 1]) > diff_) {
            imax_ = i_;
            diff_ = _abs (save2_[i_ - 1] - save1_[i_ - 1]);
          }
        }
        if (_min (_abs (save2_[imax_ - 1]), _abs (save1_[imax_ - 1])) > 0.0e0) {
          scale_ = _max (_abs (save2_[imax_ - 1]), _abs (save1_[imax_ - 1]));
          if (diff_ > 0.5 * scale_) {
            fac_[j_ - 1] = _max (facmin_, fac_[j_ - 1] * .5e0);
          }
          else if (br_ * scale_ <= diff_ && diff_ <= bl_ * scale_) {
            fac_[j_ - 1] = _min (fac_[j_ - 1] * 2.0e0, .5e0);
          }
          else if (diff_ < br_ * scale_) {
            fac_[j_ - 1] = _min (bp_ * fac_[j_ - 1], .5e0);
          }
        }
      }
      if ((*iswflg_) == 3) {
        (*bnd_) = _dnrm2 (($1_ = (*n_) * (*n_), &$1_), dfdy_, &_k1) / (-el_[0 + (13) * (((*nq_) - 1))] * (*h_));
      }
      (*nfe_) = (*nfe_) + (*n_);
    }
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] + 1.0e0;
      }
    }
    else if ((*impl_) == 1) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    else if ((*impl_) == 2) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (i_ = 1; i_ <= (*nde_); (i_)++) {
        dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] + a_[i_ - 1 + ((*matdim_)) * 
        ((0))];
      }
    }
    else if ((*impl_) == 3) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    (void) _dgefa (dfdy_, matdim_, n_, ipvt_, &info_);
    if (info_ != 0) {
      (*ier_) = TRUE;
    }
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    if ((*miter_) == 4) {
      (void) _jacobn (n_, t_, y_, &dfdy_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_);
      if ((*n_) == 0) {
        (*jstate_) = 8;
        goto _l0;
      }
      factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_);
      mw_ = (*ml_) + (*mu_) + 1;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = factor_ * dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))];
        }
      }
    }
    else if ((*miter_) == 5) {
      br_ = pow ((*uround_), .875e0);
      bl_ = pow ((*uround_), .75e0);
      bp_ = pow ((*uround_), -.15e0);
      facmin_ = pow ((*uround_), .78e0);
      mw_ = (*ml_) + (*mu_) + 1;
      j2_ = _min (mw_, (*n_));
      for (j_ = 1; j_ <= j2_; (j_)++) {
        for (k_ = j_; (mw_ > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += mw_) {
          ys_ = _max (_abs (ywt_[k_ - 1]), _abs (y_[k_ - 1]));
          _l280:;
          dy_ = fac_[k_ - 1] * ys_;
          if (dy_ == 0.0e0) {
            if (fac_[k_ - 1] < .5e0) {
              fac_[k_ - 1] = _min (100.0e0 * fac_[k_ - 1], .5e0);
              goto _l280;
            }
            else {
              dy_ = ys_;
            }
          }
          if ((*nq_) == 1) {
            dy_ = _sign (dy_, save2_[k_ - 1]);
          }
          else {
            dy_ = _sign (dy_, yh_[k_ - 1 + ((*n_)) * ((2))]);
          }
          dy_ = (y_[k_ - 1] + dy_) - y_[k_ - 1];
          dfdy_[mw_ - 1 + ((*matdim_)) * ((k_ - 1))] = y_[k_ - 1];
          y_[k_ - 1] = y_[k_ - 1] + dy_;
        }
        (void) _f (n_, t_, y_, save1_);
        if ((*n_) == 0) {
          (*jstate_) = 6;
          goto _l0;
        }
        for (k_ = j_; (mw_ > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += mw_) {
          y_[k_ - 1] = dfdy_[mw_ - 1 + ((*matdim_)) * ((k_ - 1))];
          ys_ = _max (_abs (ywt_[k_ - 1]), _abs (y_[k_ - 1]));
          dy_ = fac_[k_ - 1] * ys_;
          if (dy_ == 0.0e0) {
            dy_ = ys_;
          }
          if ((*nq_) == 1) {
            dy_ = _sign (dy_, save2_[k_ - 1]);
          }
          else {
            dy_ = _sign (dy_, yh_[k_ - 1 + ((*n_)) * ((2))]);
          }
          dy_ = (y_[k_ - 1] + dy_) - y_[k_ - 1];
          factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_) / dy_;
          for (i_ = _max ((*ml_) + 1, mw_ + 1 - k_); i_ <= _min (mw_ + (*n_) - k_, mw_ + (*ml_)); (i_)++) {
            dfdy_[i_ - 1 + ((*matdim_)) * ((k_ - 1))] = factor_ * (save1_[i_ + k_ - mw_ - 1] - save2_[i_ + k_ - mw_ - 1]);
          }
          imax_ = _max (1, k_ - (*mu_));
          diff_ = _abs (save2_[imax_ - 1] - save1_[imax_ - 1]);
          for (i_ = _max (1, k_ - (*mu_)) + 1; i_ <= _min (k_ + (*ml_), (*n_)); (i_)++) {
            if (_abs (save2_[i_ - 1] - save1_[i_ - 1]) > diff_) {
              imax_ = i_;
              diff_ = _abs (save2_[i_ - 1] - save1_[i_ - 1]);
            }
          }
          if (_min (_abs (save2_[imax_ - 1]), _abs (save1_[imax_ - 1])) > 0.0e0) {
            scale_ = _max (_abs (save2_[imax_ - 1]), _abs (save1_[imax_ - 1]));
            if (diff_ > 0.5 * scale_) {
              fac_[j_ - 1] = _max (facmin_, fac_[j_ - 1] * .5e0);
            }
            else if (br_ * scale_ <= diff_ && diff_ <= bl_ * scale_) {
              fac_[j_ - 1] = _min (fac_[j_ - 1] * 2.0e0, .5e0);
            }
            else if (diff_ < br_ * scale_) {
              fac_[k_ - 1] = _min (bp_ * fac_[k_ - 1], .5e0);
            }
          }
        }
      }
      (*nfe_) = (*nfe_) + j2_;
    }
    if ((*iswflg_) == 3) {
      dfdymx_ = 0.0;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdymx_ = _max (dfdymx_, _abs (dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))]));
        }
      }
      (*bnd_) = 0.0;
      if (dfdymx_ != 0.0e0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
            (*bnd_) = (*bnd_) + ($2_ = (dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] / dfdymx_), $2_ * $2_);
          }
        }
        (*bnd_) = dfdymx_ * sqrt ((*bnd_)) / (-el_[0 + (13) * (((*nq_) - 1))] * (*h_));
      }
    }
    if ((*impl_) == 0) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] + 1.0e0;
      }
    }
    else if ((*impl_) == 1) {
      (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    else if ((*impl_) == 2) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[j_ - 1 + ((*matdim_)) * 
        ((0))];
      }
    }
    else if ((*impl_) == 3) {
      (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*nde_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    (void) _dgbfa (dfdy_, matdim_, n_, ml_, mu_, ipvt_, &info_);
    if (info_ != 0) {
      (*ier_) = TRUE;
    }
  }
  else if ((*miter_) == 3) {
    iflag_ = 1;
    (void) _users (y_, &yh_[0 + ((*n_)) * ((1))], ywt_, save1_, save2_, t_, h_, &el_[0 + (13) * (((*nq_) - 1))], impl_, n_, 
    nde_, &iflag_);
    if (iflag_ == -1) {
      (*ier_) = TRUE;
      goto _l0;
    }
    if ((*n_) == 0) {
      (*jstate_) = 10;
      goto _l0;
    }
  }
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _ddriv1 (int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ y_, real_4 (*_f)(), real_8 _p_ tout_, int_4 _p_ mstate_, real_8 
_p_ eps_, real_8 _p_ work_, int_4 _p_ lenw_, int_4 _p_ ierflg_)
{
  static int_4 i_, leniw_, lenwcm_, lnwchk_, ml_, mu_, nde_, nstate_, ntask_, iwork_[250];
  static real_8 ewtcom_[1], hmax_;
  static char_15 intgr1_;
  int_4 _data_k_2, __fcnt, __rc, $3_, $11_, $12_, $13_, $14_, $15_;
  char_127 $0_, $4_, $7_;
  char_255 $1_, $2_, $5_, $6_, $8_;
  char_511 $9_, $10_;
  static FORMAT $f_100011_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100040_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
#define _data_n_2 1
  static real_8 _data_l_2[_data_n_2] = {
    1.0e0
  };
  if (__calls[18].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    ewtcom_[0] = _data_l_2[_data_k_2++];
  }
  if (_abs ((*mstate_)) == 0 || _abs ((*mstate_)) > 7) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv1:303", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100011_[__fcnt] != NULL && $f_100011_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100011_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:303", 0));
      __fcnt += 3;
    }
    if ($f_100011_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100011_[__fcnt] != NULL && $f_100011_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100011_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:303", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100011_[__fcnt + 2], &(*mstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:303", 0));
    __fcnt += 3;
    while ($f_100011_[__fcnt] != NULL && $f_100011_[__fcnt] == FMT_TEXT) {
      if ($f_100011_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100011_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:303", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_57, (bufcpy ($2_, concat ($1_, concat ($0_, _dc_2, intgr1_), _dc_3), 255), $2_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  else if (_abs ((*mstate_)) == 7) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_57, _dc_4, ierflg_, ($3_ = 2, &$3_));
    goto _l0;
  }
  if ((*n_) > 200) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv1:317", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:317", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:317", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:317", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:317", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 21;
    (void) _xermsg (_dc_0, _dc_57, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_5, intgr1_), _dc_6), 255), $6_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  if ((*mstate_) > 0) {
    nstate_ = (*mstate_);
    ntask_ = 1;
  }
  else {
    nstate_ = -(*mstate_);
    ntask_ = 3;
  }
  hmax_ = 2.0e0 * _abs ((*tout_) - (*t_));
  leniw_ = (*n_) + 50;
  lenwcm_ = (*lenw_) - leniw_;
  if (lenwcm_ < ((*n_) * (*n_) + 10 * (*n_) + 250)) {
    lnwchk_ = (*n_) * (*n_) + 10 * (*n_) + 250 + leniw_;
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv1:337", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:337", 0));
      __fcnt += 3;
    }
    if ($f_100040_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:337", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100040_[__fcnt + 2], &lnwchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:337", 0));
    __fcnt += 3;
    while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
      if ($f_100040_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv1:337", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 32;
    (void) _xermsg (_dc_0, _dc_57, (bufcpy ($10_, concat ($9_, concat ($8_, concat ($7_, _dc_7, _dc_8), intgr1_), _dc_9), 
    511), $10_), ierflg_, &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  if (nstate_ != 1) {
    for (i_ = 1; i_ <= leniw_; (i_)++) {
      iwork_[i_ - 1] = work_[i_ + lenwcm_ - 1];
    }
  }
  (void) _ddriv3 (n_, t_, y_, _f, &nstate_, tout_, &ntask_, &_k0, eps_, ewtcom_, ($11_ = 2, &$11_), ($12_ = 2, &$12_), 
  ($13_ = 2, &$13_), &_k0, &ml_, &mu_, ($14_ = 5, &$14_), &hmax_, work_, &lenwcm_, iwork_, &leniw_, _f, _f, &nde_, ($15_ 
  = 1000, &$15_), _f, _f, ierflg_);
  for (i_ = 1; i_ <= leniw_; (i_)++) {
    work_[i_ + lenwcm_ - 1] = iwork_[i_ - 1];
  }
  if (nstate_ <= 4) {
    (*mstate_) = _sign (nstate_, (*mstate_));
  }
  else if (nstate_ == 6) {
    (*mstate_) = _sign (5, (*mstate_));
  }
  else if ((*ierflg_) == 11) {
    (*mstate_) = _sign (6, (*mstate_));
  }
  else if ((*ierflg_) > 11) {
    (*mstate_) = _sign (7, (*mstate_));
  }
  _l0:;
  __calls[18].calls++;
  return 0;
}

int_4 _ddriv2 (int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ y_, real_4 (*_f)(), real_8 _p_ tout_, int_4 _p_ mstate_, int_4 
_p_ nroot_, real_8 _p_ eps_, real_8 _p_ ewt_, int_4 _p_ mint_, real_8 _p_ work_, int_4 _p_ lenw_, int_4 _p_ iwork_, 
int_4 _p_ leniw_, real_8 (*_g)(), int_4 _p_ ierflg_)
{
  static int_4 ierror_, miter_, ml_, mu_, mxord_, nde_, nstate_, ntask_;
  static real_8 ewtcom_[1], hmax_;
  static char_15 intgr1_;
  int_4 $0_, __fcnt, __rc, $8_;
  char_127 $1_, $4_;
  char_255 $2_, $3_, $5_;
  char_511 $6_, $7_;
  static FORMAT $f_100013_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100020_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if (_abs ((*mstate_)) == 9) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_58, _dc_11, ierflg_, ($0_ = 2, &$0_));
    goto _l0;
  }
  else if (_abs ((*mstate_)) == 0 || _abs ((*mstate_)) > 9) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv2:359", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100013_[__fcnt] != NULL && $f_100013_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100013_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv2:359", 0));
      __fcnt += 3;
    }
    if ($f_100013_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100013_[__fcnt] != NULL && $f_100013_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100013_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv2:359", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100013_[__fcnt + 2], &(*mstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv2:359", 0));
    __fcnt += 3;
    while ($f_100013_[__fcnt] != NULL && $f_100013_[__fcnt] == FMT_TEXT) {
      if ($f_100013_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100013_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv2:359", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_58, (bufcpy ($3_, concat ($2_, concat ($1_, _dc_2, intgr1_), _dc_12), 255), $3_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (9, (*mstate_));
    goto _l0;
  }
  if ((*mint_) < 1 || (*mint_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv2:368", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv2:368", 0));
      __fcnt += 3;
    }
    if ($f_100020_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv2:368", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100020_[__fcnt + 2], &(*mint_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv2:368", 0));
    __fcnt += 3;
    while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
      if ($f_100020_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv2:368", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 23;
    (void) _xermsg (_dc_0, _dc_58, (bufcpy ($7_, concat ($6_, concat ($5_, concat ($4_, _dc_13, _dc_14), intgr1_), _dc_9), 
    511), $7_), ierflg_, &_k1);
    (*mstate_) = _sign (9, (*mstate_));
    goto _l0;
  }
  if ((*mstate_) >= 0) {
    nstate_ = (*mstate_);
    ntask_ = 1;
  }
  else {
    nstate_ = -(*mstate_);
    ntask_ = 3;
  }
  ewtcom_[0] = (*ewt_);
  if ((*ewt_) != 0.0e0) {
    ierror_ = 3;
  }
  else {
    ierror_ = 2;
  }
  if ((*mint_) == 1) {
    miter_ = 0;
    mxord_ = 12;
  }
  else if ((*mint_) == 2) {
    miter_ = 2;
    mxord_ = 5;
  }
  else if ((*mint_) == 3) {
    miter_ = 2;
    mxord_ = 12;
  }
  hmax_ = 2.0e0 * _abs ((*tout_) - (*t_));
  (void) _ddriv3 (n_, t_, y_, _f, &nstate_, tout_, &ntask_, nroot_, eps_, ewtcom_, &ierror_, mint_, &miter_, &_k0, &ml_, 
  &mu_, &mxord_, &hmax_, work_, lenw_, iwork_, leniw_, _f, _f, &nde_, ($8_ = 1000, &$8_), _g, _f, ierflg_);
  if (nstate_ <= 7) {
    (*mstate_) = _sign (nstate_, (*mstate_));
  }
  else if (nstate_ == 11) {
    (*mstate_) = _sign (8, (*mstate_));
  }
  else if (nstate_ > 11) {
    (*mstate_) = _sign (9, (*mstate_));
  }
  _l0:;
  __calls[19].calls++;
  return 0;
}

int_4 _ddriv3 (int_4 _p_ n_, real_8 _p_ t_, real_8 _p_ y_, int_4 (*_f)(), int_4 _p_ nstate_, real_8 _p_ tout_, int_4 
_p_ ntask_, int_4 _p_ nroot_, real_8 _p_ eps_, real_8 _p_ ewt_, int_4 _p_ ierror_, int_4 _p_ mint_, int_4 _p_ miter_, 
int_4 _p_ impl_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ mxord_, real_8 _p_ hmax_, real_8 _p_ work_, int_4 _p_ lenw_, 
int_4 _p_ iwork_, int_4 _p_ leniw_, int_4 (*_jacobn)(), int_4 (*_fa)(), int_4 _p_ nde_, int_4 _p_ mxstep_, real_8 
(*_g)(), int_4 (*_users)(), int_4 _p_ ierflg_)
{
  static int_4 i_, ia_, idfdy_, ifac_, iflag_, ignow_, imxerr_, info_, iroot_, isave1_, isave2_, itroot_, iywt_, j_, 
  jstate_, jtroot_, lenchk_, liwchk_, matdim_, maxord_, ndecom_, npar_, nstepl_;
  static logical_4 convrg_;
  static real_8 ae_, big_, glast_, gnow_, h_, hsign_, hused_, re_, size_, sum_, tlast_, troot_, uround_;
  static char_15 intgr1_, intgr2_;
  static char_31 rl1_, rl2_;
  int_4 $0_, __fcnt, __rc, $44_;
  char_63 $4_, $10_, $57_, $64_, $72_, $80_, $84_, $89_;
  char_127 $1_, $5_, $6_, $7_, $11_, $12_, $13_, $17_, $20_, $23_, $28_, $31_, $34_, $39_, $45_, $51_, $58_, $65_, $73_, 
  $81_, $85_, $90_, $91_;
  char_255 $2_, $3_, $8_, $9_, $14_, $18_, $19_, $21_, $22_, $24_, $29_, $30_, $32_, $33_, $35_, $40_, $46_, $52_, $59_, 
  $66_, $74_, $82_, $83_, $86_;
  char_511 $15_, $16_, $25_, $36_, $41_, $47_, $53_, $60_, $67_, $75_, $87_, $88_;
  char_1023 $26_, $27_, $37_, $38_, $42_, $43_, $48_, $54_, $61_, $68_, $76_;
  char_2047 $49_, $50_, $55_, $56_, $62_, $63_, $69_, $77_;
  char_4095 $70_, $71_, $78_, $79_;
  extern real_8 _d1mach ();
  extern real_8 _dnrm2 ();
  static FORMAT $f_100014_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100029_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100036_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100043_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100049_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100055_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100061_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100062_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100068_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100074_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100086_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100129_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100280_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100281_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100311_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100312_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100460_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100461_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100470_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100471_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100478_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100479_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100480_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100614_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100619_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100624_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  if ((*nstate_) == 12) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_59, _dc_16, ierflg_, ($0_ = 2, &$0_));
    goto _l0;
  }
  else if ((*nstate_) < 1 || (*nstate_) > 12) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:759", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:759", 0));
      __fcnt += 3;
    }
    if ($f_100014_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:759", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100014_[__fcnt + 2], &(*nstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:759", 0));
    __fcnt += 3;
    while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
      if ($f_100014_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:759", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($3_, concat ($2_, concat ($1_, _dc_17, intgr1_), _dc_18), 255), $3_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  npar_ = (*n_);
  if ((*eps_) < 0.0e0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:769", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:769", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:769", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*eps_), REAL, 8);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:769", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:769", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 27;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_19, rl1_), _dc_20), 127), $6_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*n_) <= 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:777", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:777", 0));
      __fcnt += 3;
    }
    if ($f_100029_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:777", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100029_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:777", 0));
    __fcnt += 3;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      if ($f_100029_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:777", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 22;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($9_, concat ($8_, concat ($7_, _dc_21, intgr1_), _dc_22), 255), $9_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mxord_) <= 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:786", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:786", 0));
      __fcnt += 3;
    }
    if ($f_100036_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:786", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100036_[__fcnt + 2], &(*mxord_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:786", 0));
    __fcnt += 3;
    while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
      if ($f_100036_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:786", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 28;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($12_, concat ($11_, concat ($10_, _dc_23, intgr1_), _dc_22), 127), $12_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mint_) < 1 || (*mint_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:795", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:795", 0));
      __fcnt += 3;
    }
    if ($f_100043_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:795", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100043_[__fcnt + 2], &(*mint_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:795", 0));
    __fcnt += 3;
    while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
      if ($f_100043_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:795", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 23;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($16_, concat ($15_, concat ($14_, concat ($13_, _dc_13, _dc_14), intgr1_), 
    _dc_9), 511), $16_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*miter_) < 0 || (*miter_) > 5) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:803", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:803", 0));
      __fcnt += 3;
    }
    if ($f_100049_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:803", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100049_[__fcnt + 2], &(*miter_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:803", 0));
    __fcnt += 3;
    while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
      if ($f_100049_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:803", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 24;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($19_, concat ($18_, concat ($17_, _dc_24, intgr1_), _dc_18), 255), $19_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*impl_) < 0 || (*impl_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:811", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:811", 0));
      __fcnt += 3;
    }
    if ($f_100055_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:811", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100055_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:811", 0));
    __fcnt += 3;
    while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
      if ($f_100055_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:811", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 25;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($22_, concat ($21_, concat ($20_, _dc_25, intgr1_), _dc_18), 255), $22_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*mint_) == 3 && ((*miter_) == 0 || (*miter_) == 3 || (*impl_) != 0)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:820", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:820", 0));
      __fcnt += 3;
    }
    if ($f_100061_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:820", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100061_[__fcnt + 2], &(*miter_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:820", 0));
    __fcnt += 3;
    while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
      if ($f_100061_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:820", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:821", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:821", 0));
      __fcnt += 3;
    }
    if ($f_100062_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:821", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100062_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:821", 0));
    __fcnt += 3;
    while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
      if ($f_100062_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:821", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 29;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($27_, concat ($26_, concat ($25_, concat ($24_, concat ($23_, _dc_26, intgr1_), 
    _dc_27), intgr2_), _dc_28), 1023), $27_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if (((*impl_) >= 1 && (*impl_) <= 3) && (*miter_) == 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:829", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100068_[__fcnt] != NULL && $f_100068_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100068_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:829", 0));
      __fcnt += 3;
    }
    if ($f_100068_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100068_[__fcnt] != NULL && $f_100068_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100068_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:829", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100068_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:829", 0));
    __fcnt += 3;
    while ($f_100068_[__fcnt] != NULL && $f_100068_[__fcnt] == FMT_TEXT) {
      if ($f_100068_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100068_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:829", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 30;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($30_, concat ($29_, concat ($28_, _dc_29, intgr1_), _dc_28), 255), $30_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if (((*impl_) == 2 || (*impl_) == 3) && (*mint_) == 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:837", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:837", 0));
      __fcnt += 3;
    }
    if ($f_100074_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:837", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100074_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:837", 0));
    __fcnt += 3;
    while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
      if ($f_100074_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:837", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 31;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($33_, concat ($32_, concat ($31_, _dc_30, intgr1_), _dc_28), 255), $33_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*miter_) == 0 || (*miter_) == 3) {
    liwchk_ = 50;
  }
  else if ((*miter_) == 1 || (*miter_) == 2 || (*miter_) == 4 || (*miter_) == 5) {
    liwchk_ = 51 + (*n_) - 1;
  }
  if ((*leniw_) < liwchk_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:852", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:852", 0));
      __fcnt += 3;
    }
    if ($f_100086_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:852", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100086_[__fcnt + 2], &liwchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:852", 0));
    __fcnt += 3;
    while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
      if ($f_100086_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:852", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 33;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($38_, concat ($37_, concat ($36_, concat ($35_, concat ($34_, _dc_31, _dc_32), 
    _dc_33), intgr1_), _dc_9), 1023), $38_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mint_) == 1 || (*mint_) == 3) {
    maxord_ = _min ((*mxord_), 12);
  }
  else if ((*mint_) == 2) {
    maxord_ = _min ((*mxord_), 5);
  }
  idfdy_ = 251 + (maxord_ + 1) * (*n_);
  if ((*miter_) == 0 || (*miter_) == 3) {
    iywt_ = idfdy_;
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    iywt_ = idfdy_ + (*n_) * (*n_);
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    iywt_ = idfdy_ + (2 * (*ml_) + (*mu_) + 1) * (*n_);
  }
  isave1_ = iywt_ + (*n_);
  isave2_ = isave1_ + (*n_);
  ignow_ = isave2_ + (*n_);
  itroot_ = ignow_ + (*nroot_);
  ifac_ = itroot_ + (*nroot_);
  if ((*miter_) == 2 || (*miter_) == 5 || (*mint_) == 3) {
    ia_ = ifac_ + (*n_);
  }
  else {
    ia_ = ifac_;
  }
  if ((*impl_) == 0 || (*miter_) == 3) {
    lenchk_ = ia_ - 1;
  }
  else if ((*impl_) == 1 && ((*miter_) == 1 || (*miter_) == 2)) {
    lenchk_ = ia_ - 1 + (*n_) * (*n_);
  }
  else if ((*impl_) == 1 && ((*miter_) == 4 || (*miter_) == 5)) {
    lenchk_ = ia_ - 1 + (2 * (*ml_) + (*mu_) + 1) * (*n_);
  }
  else if ((*impl_) == 2 && (*miter_) != 3) {
    lenchk_ = ia_ - 1 + (*n_);
  }
  else if ((*impl_) == 3 && ((*miter_) == 1 || (*miter_) == 2)) {
    lenchk_ = ia_ - 1 + (*n_) * (*nde_);
  }
  else if ((*impl_) == 3 && ((*miter_) == 4 || (*miter_) == 5)) {
    lenchk_ = ia_ - 1 + (2 * (*ml_) + (*mu_) + 1) * (*nde_);
  }
  if ((*lenw_) < lenchk_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:909", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100129_[__fcnt] != NULL && $f_100129_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100129_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:909", 0));
      __fcnt += 3;
    }
    if ($f_100129_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100129_[__fcnt] != NULL && $f_100129_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100129_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:909", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100129_[__fcnt + 2], &lenchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:909", 0));
    __fcnt += 3;
    while ($f_100129_[__fcnt] != NULL && $f_100129_[__fcnt] == FMT_TEXT) {
      if ($f_100129_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100129_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:909", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 32;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($43_, concat ($42_, concat ($41_, concat ($40_, concat ($39_, _dc_31, _dc_34), 
    _dc_33), intgr1_), _dc_9), 1023), $43_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*miter_) == 0 || (*miter_) == 3) {
    matdim_ = 1;
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    matdim_ = (*n_);
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    matdim_ = 2 * (*ml_) + (*mu_) + 1;
  }
  if ((*impl_) == 0 || (*impl_) == 1) {
    ndecom_ = (*n_);
  }
  else if ((*impl_) == 2 || (*impl_) == 3) {
    ndecom_ = (*nde_);
  }
  if ((*nstate_) == 1) {
    if ((*mint_) == 1 || (*mint_) == 3) {
      iwork_[19] = _min ((*mxord_), 12);
    }
    else if ((*mint_) == 2) {
      iwork_[19] = _min ((*mxord_), 5);
    }
    iwork_[18] = (*mxord_);
    if ((*mint_) == 1 || (*mint_) == 2) {
      iwork_[15] = (*mint_);
      iwork_[17] = (*miter_);
      iwork_[9] = (*mint_);
      iwork_[10] = (*miter_);
    }
    else if ((*mint_) == 3) {
      iwork_[15] = 1;
      iwork_[17] = 0;
      iwork_[9] = iwork_[15];
      iwork_[10] = iwork_[17];
      iwork_[16] = (*miter_);
    }
    work_[160] = (*hmax_);
    uround_ = _d1mach (($44_ = 4, &$44_));
    work_[205] = uround_;
    work_[204] = _d1mach (&_k1);
    if ((*nroot_) != 0) {
      re_ = uround_;
      ae_ = work_[204];
    }
    h_ = ((*tout_) - (*t_)) * (1.0e0 - 4.0e0 * uround_);
    h_ = _sign (_min (_abs (h_), (*hmax_)), h_);
    work_[159] = h_;
    hsign_ = _sign (1.0, h_);
    work_[162] = hsign_;
    iwork_[8] = 0;
    work_[0] = 0.0;
    work_[1] = 0.0;
    work_[2] = 0.0;
    iwork_[0] = 0;
    iwork_[1] = 0;
    iwork_[2] = 0;
    iwork_[21] = 0;
    iwork_[3] = 0;
    iwork_[4] = 0;
    iwork_[5] = 0;
    work_[165] = (*t_);
    iwork_[6] = 0;
    iwork_[20] = 0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + 251 - 1 - 1] = y_[i_ - 1];
    }
    if ((*t_) == (*tout_)) {
      goto _l0;
    }
    goto _l180;
  }
  else {
    uround_ = work_[205];
    if ((*nroot_) != 0) {
      re_ = uround_;
      ae_ = work_[204];
    }
  }
  if (iwork_[6] == 1) {
    convrg_ = TRUE;
  }
  else {
    convrg_ = FALSE;
  }
  (*t_) = work_[165];
  h_ = work_[159];
  hsign_ = work_[162];
  if (iwork_[8] == 0) {
    goto _l180;
  }
  if ((*nroot_) != 0) {
    if (iwork_[7] > 0) {
      if ((*nstate_) != 5) {
        if ((*tout_) * hsign_ >= work_[166] * hsign_) {
          troot_ = work_[166];
          (void) _ddntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
          (*t_) = troot_;
          (*nstate_) = 5;
          (*ierflg_) = 0;
          goto _l580;
        }
      }
      else {
        troot_ = (*t_);
        iroot_ = 0;
        for (i_ = 1; i_ <= iwork_[12]; (i_)++) {
          jtroot_ = i_ + iwork_[13] - 1;
          if (work_[jtroot_ - 1] * hsign_ <= troot_ * hsign_) {
            if (work_[jtroot_ - 1] == work_[166] && i_ > iwork_[5]) {
              iroot_ = i_;
              troot_ = work_[jtroot_ - 1];
              goto _l60;
            }
            if (work_[jtroot_ - 1] * hsign_ > work_[166] * hsign_) {
              iroot_ = i_;
              troot_ = work_[jtroot_ - 1];
            }
          }
        }
        _l60:;
        iwork_[5] = iroot_;
        work_[166] = troot_;
        iwork_[7] = (*ntask_);
        if ((*ntask_) == 1) {
          if (iroot_ == 0) {
            iwork_[7] = 0;
          }
          else {
            if ((*tout_) * hsign_ >= troot_ * hsign_) {
              (void) _ddntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
              (*nstate_) = 5;
              (*t_) = troot_;
              (*ierflg_) = 0;
              goto _l580;
            }
          }
        }
        else if ((*ntask_) == 2 || (*ntask_) == 3) {
          if (iroot_ == 0 || ((*tout_) * hsign_ < troot_ * hsign_)) {
            iwork_[7] = 0;
          }
          else {
            (void) _ddntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
            (*nstate_) = 5;
            (*ierflg_) = 0;
            (*t_) = troot_;
            goto _l580;
          }
        }
      }
    }
  }
  if ((*ntask_) == 1) {
    (*nstate_) = 2;
    if ((*t_) * hsign_ >= (*tout_) * hsign_) {
      (void) _ddntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      (*ierflg_) = 0;
      goto _l580;
    }
  }
  else if ((*ntask_) == 2) {
    if ((*t_) * hsign_ > (*tout_) * hsign_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:ddriv3:1099", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100280_[__fcnt] != NULL && $f_100280_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100280_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1099", 0));
        __fcnt += 3;
      }
      if ($f_100280_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100280_[__fcnt] != NULL && $f_100280_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100280_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1099", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100280_[__fcnt + 2], &(*t_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1099", 0));
      __fcnt += 3;
      while ($f_100280_[__fcnt] != NULL && $f_100280_[__fcnt] == FMT_TEXT) {
        if ($f_100280_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100280_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1099", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:ddriv3:1100", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100281_[__fcnt] != NULL && $f_100281_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100281_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1100", 0));
        __fcnt += 3;
      }
      if ($f_100281_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100281_[__fcnt] != NULL && $f_100281_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100281_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1100", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100281_[__fcnt + 2], &(*tout_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1100", 0));
      __fcnt += 3;
      while ($f_100281_[__fcnt] != NULL && $f_100281_[__fcnt] == FMT_TEXT) {
        if ($f_100281_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100281_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1100", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 11;
      (void) _xermsg (_dc_0, _dc_59, (bufcpy ($50_, concat ($49_, concat ($48_, concat ($47_, concat ($46_, concat ($45_, 
      _dc_35, rl1_), _dc_36), rl2_), _dc_37), _dc_38), 2047), $50_), ierflg_, &_k0);
      (*nstate_) = 11;
      (void) _ddntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      goto _l580;
    }
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
      (*nstate_) = 2;
      (*ierflg_) = 0;
      goto _l560;
    }
    if ((*nstate_) == 5) {
      (*nstate_) = 2;
      (*ierflg_) = 0;
      goto _l560;
    }
    (*nstate_) = 2;
    if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
      h_ = (*tout_) - (*t_);
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = h_ * (1.0e0 - 4.0e0 * uround_);
      }
      work_[159] = h_;
      if (h_ == 0.0e0) {
        goto _l670;
      }
      iwork_[8] = -1;
    }
  }
  else if ((*ntask_) == 3) {
    (*nstate_) = 2;
    if ((*t_) * hsign_ > (*tout_) * hsign_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:ddriv3:1139", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100311_[__fcnt] != NULL && $f_100311_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100311_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1139", 0));
        __fcnt += 3;
      }
      if ($f_100311_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100311_[__fcnt] != NULL && $f_100311_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100311_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1139", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100311_[__fcnt + 2], &(*t_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1139", 0));
      __fcnt += 3;
      while ($f_100311_[__fcnt] != NULL && $f_100311_[__fcnt] == FMT_TEXT) {
        if ($f_100311_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100311_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1139", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:ddriv3:1140", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100312_[__fcnt] != NULL && $f_100312_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100312_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1140", 0));
        __fcnt += 3;
      }
      if ($f_100312_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100312_[__fcnt] != NULL && $f_100312_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100312_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1140", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100312_[__fcnt + 2], &(*tout_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1140", 0));
      __fcnt += 3;
      while ($f_100312_[__fcnt] != NULL && $f_100312_[__fcnt] == FMT_TEXT) {
        if ($f_100312_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100312_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1140", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 11;
      (void) _xermsg (_dc_0, _dc_59, (bufcpy ($56_, concat ($55_, concat ($54_, concat ($53_, concat ($52_, concat ($51_, 
      _dc_35, rl1_), _dc_36), rl2_), _dc_37), _dc_38), 2047), $56_), ierflg_, &_k0);
      (*nstate_) = 11;
      (void) _ddntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      goto _l580;
    }
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
      (*ierflg_) = 0;
      goto _l560;
    }
    if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
      h_ = (*tout_) - (*t_);
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = h_ * (1.0e0 - 4.0e0 * uround_);
      }
      work_[159] = h_;
      if (h_ == 0.0e0) {
        goto _l670;
      }
      iwork_[8] = -1;
    }
  }
  if (((*mint_) != iwork_[9] || (*miter_) != iwork_[10]) && (*mint_) != 3 && iwork_[9] != 3) {
    iwork_[8] = -1;
  }
  if ((*hmax_) != work_[160]) {
    h_ = _sign (_min (_abs (h_), (*hmax_)), h_);
    if (h_ != work_[159]) {
      iwork_[8] = -1;
      work_[159] = h_;
    }
    work_[160] = (*hmax_);
  }
  _l180:;
  nstepl_ = iwork_[2];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = work_[i_ + 251 - 1 - 1];
  }
  if ((*nroot_) != 0) {
    for (i_ = 1; i_ <= (*nroot_); (i_)++) {
      work_[i_ + ignow_ - 1 - 1] = _g (&npar_, t_, y_, &i_);
      if (npar_ == 0) {
        iwork_[5] = i_;
        (*nstate_) = 7;
        goto _l0;
      }
    }
  }
  if ((*ierror_) == 1) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = 1.0;
    }
    goto _l410;
  }
  else if ((*ierror_) == 5) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = ewt_[i_ - 1];
    }
    goto _l410;
  }
  _l260:;
  if ((*ierror_) == 2) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      if (y_[i_ - 1] == 0.0e0) {
        goto _l290;
      }
      work_[i_ + iywt_ - 1 - 1] = _abs (y_[i_ - 1]);
    }
    goto _l410;
    _l290:;
    if (iwork_[8] == 0) {
      (void) _f (&npar_, t_, y_, &work_[isave2_ - 1]);
      if (npar_ == 0) {
        (*nstate_) = 6;
        goto _l0;
      }
      iwork_[3] = iwork_[3] + 1;
      if ((*miter_) == 3 && (*impl_) != 0) {
        iflag_ = 0;
        (void) _users (y_, &work_[250], &work_[iywt_ - 1], &work_[isave1_ - 1], &work_[isave2_ - 1], t_, &h_, &work_[3], impl_, 
        &npar_, &ndecom_, &iflag_);
        if (iflag_ == -1) {
          goto _l690;
        }
        if (npar_ == 0) {
          (*nstate_) = 10;
          goto _l0;
        }
      }
      else if ((*impl_) == 1) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _dgefa (&work_[ia_ - 1], &matdim_, n_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _dgesl (&work_[ia_ - 1], &matdim_, n_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ + (*ml_) - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _dgbfa (&work_[ia_ - 1], &matdim_, n_, ml_, mu_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _dgbsl (&work_[ia_ - 1], &matdim_, n_, ml_, mu_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
      }
      else if ((*impl_) == 2) {
        (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
        if (npar_ == 0) {
          (*nstate_) = 9;
          goto _l0;
        }
        for (i_ = 1; i_ <= ndecom_; (i_)++) {
          if (work_[i_ + ia_ - 1 - 1] == 0.0e0) {
            goto _l690;
          }
          work_[i_ + isave2_ - 1 - 1] = work_[i_ + isave2_ - 1 - 1] / work_[i_ + ia_ - 1 - 1];
        }
      }
      else if ((*impl_) == 3) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _dgefa (&work_[ia_ - 1], &matdim_, nde_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _dgesl (&work_[ia_ - 1], &matdim_, nde_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ + (*ml_) - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _dgbfa (&work_[ia_ - 1], &matdim_, nde_, ml_, mu_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _dgbsl (&work_[ia_ - 1], &matdim_, nde_, ml_, mu_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
      }
    }
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      if (y_[j_ - 1] != 0.0e0) {
        work_[j_ + iywt_ - 1 - 1] = _abs (y_[j_ - 1]);
      }
      else {
        if (iwork_[8] == 0) {
          work_[j_ + iywt_ - 1 - 1] = _abs (h_ * work_[j_ + isave2_ - 1 - 1]);
        }
        else {
          work_[j_ + iywt_ - 1 - 1] = _abs (work_[j_ + 251 + (*n_) - 1 - 1]);
        }
      }
      if (work_[j_ + iywt_ - 1 - 1] == 0.0e0) {
        work_[j_ + iywt_ - 1 - 1] = uround_;
      }
    }
  }
  else if ((*ierror_) == 3) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = _max (ewt_[0], _abs (y_[i_ - 1]));
    }
  }
  else if ((*ierror_) == 4) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = _max (ewt_[i_ - 1], _abs (y_[i_ - 1]));
    }
  }
  _l410:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    work_[i_ + isave2_ - 1 - 1] = y_[i_ - 1] / work_[i_ + iywt_ - 1 - 1];
  }
  sum_ = _dnrm2 (n_, &work_[isave2_ - 1], &_k1) / sqrt ((real_8) ((*n_)));
  sum_ = _max (1.0, sum_);
  if ((*eps_) < sum_ * uround_) {
    (*eps_) = sum_ * uround_ * (1.0e0 + 10.0e0 * uround_);
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:1305", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100460_[__fcnt] != NULL && $f_100460_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100460_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1305", 0));
      __fcnt += 3;
    }
    if ($f_100460_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100460_[__fcnt] != NULL && $f_100460_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100460_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1305", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100460_[__fcnt + 2], &(*t_), REAL, 8);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1305", 0));
    __fcnt += 3;
    while ($f_100460_[__fcnt] != NULL && $f_100460_[__fcnt] == FMT_TEXT) {
      if ($f_100460_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100460_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1305", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl2_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:1306", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100461_[__fcnt] != NULL && $f_100461_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100461_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1306", 0));
      __fcnt += 3;
    }
    if ($f_100461_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100461_[__fcnt] != NULL && $f_100461_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100461_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1306", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100461_[__fcnt + 2], &(*eps_), REAL, 8);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1306", 0));
    __fcnt += 3;
    while ($f_100461_[__fcnt] != NULL && $f_100461_[__fcnt] == FMT_TEXT) {
      if ($f_100461_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100461_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1306", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 4;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($63_, concat ($62_, concat ($61_, concat ($60_, concat ($59_, concat ($58_, 
    concat ($57_, _dc_39, rl1_), _dc_40), _dc_41), _dc_42), rl2_), _dc_9), 2047), $63_), ierflg_, &_k0);
    (*nstate_) = 4;
    goto _l560;
  }
  if (_abs (h_) >= uround_ * _abs ((*t_))) {
    iwork_[20] = 0;
  }
  else if (iwork_[20] == 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:1318", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100470_[__fcnt] != NULL && $f_100470_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100470_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1318", 0));
      __fcnt += 3;
    }
    if ($f_100470_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100470_[__fcnt] != NULL && $f_100470_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100470_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1318", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100470_[__fcnt + 2], &(*t_), REAL, 8);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1318", 0));
    __fcnt += 3;
    while ($f_100470_[__fcnt] != NULL && $f_100470_[__fcnt] == FMT_TEXT) {
      if ($f_100470_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100470_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1318", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl2_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:ddriv3:1319", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100471_[__fcnt] != NULL && $f_100471_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100471_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1319", 0));
      __fcnt += 3;
    }
    if ($f_100471_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100471_[__fcnt] != NULL && $f_100471_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100471_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1319", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100471_[__fcnt + 2], &h_, REAL, 8);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1319", 0));
    __fcnt += 3;
    while ($f_100471_[__fcnt] != NULL && $f_100471_[__fcnt] == FMT_TEXT) {
      if ($f_100471_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100471_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1319", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 15;
    (void) _xermsg (_dc_0, _dc_59, (bufcpy ($71_, concat ($70_, concat ($69_, concat ($68_, concat ($67_, concat ($66_, 
    concat ($65_, concat ($64_, _dc_39, rl1_), _dc_43), rl2_), _dc_44), _dc_45), _dc_46), _dc_47), 4095), $71_), ierflg_, 
    &_k0);
    iwork_[20] = 1;
  }
  if ((*ntask_) != 2) {
    if ((iwork_[2] - nstepl_) == (*mxstep_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:ddriv3:1330", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100478_[__fcnt] != NULL && $f_100478_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100478_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1330", 0));
        __fcnt += 3;
      }
      if ($f_100478_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100478_[__fcnt] != NULL && $f_100478_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100478_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1330", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100478_[__fcnt + 2], &(*t_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1330", 0));
      __fcnt += 3;
      while ($f_100478_[__fcnt] != NULL && $f_100478_[__fcnt] == FMT_TEXT) {
        if ($f_100478_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100478_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1330", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (intgr1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:ddriv3:1331", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100479_[__fcnt] != NULL && $f_100479_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100479_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1331", 0));
        __fcnt += 3;
      }
      if ($f_100479_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100479_[__fcnt] != NULL && $f_100479_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100479_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1331", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100479_[__fcnt + 2], &(*mxstep_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1331", 0));
      __fcnt += 3;
      while ($f_100479_[__fcnt] != NULL && $f_100479_[__fcnt] == FMT_TEXT) {
        if ($f_100479_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100479_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1331", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:ddriv3:1332", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100480_[__fcnt] != NULL && $f_100480_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100480_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1332", 0));
        __fcnt += 3;
      }
      if ($f_100480_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100480_[__fcnt] != NULL && $f_100480_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100480_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1332", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100480_[__fcnt + 2], &(*tout_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1332", 0));
      __fcnt += 3;
      while ($f_100480_[__fcnt] != NULL && $f_100480_[__fcnt] == FMT_TEXT) {
        if ($f_100480_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100480_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1332", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 3;
      (void) _xermsg (_dc_0, _dc_59, (bufcpy ($79_, concat ($78_, concat ($77_, concat ($76_, concat ($75_, concat ($74_, 
      concat ($73_, concat ($72_, _dc_39, rl1_), _dc_48), intgr1_), _dc_49), _dc_50), rl2_), _dc_9), 4095), $79_), ierflg_, 
      &_k0);
      (*nstate_) = 3;
      goto _l560;
    }
  }
  (void) _ddstp (eps_, _f, _fa, &work_[160], impl_, ierror_, _jacobn, &matdim_, &iwork_[19], &iwork_[15], &iwork_[17], 
  ml_, mu_, &npar_, &ndecom_, &work_[iywt_ - 1], &uround_, _users, &work_[0], &work_[2], &work_[159], &hused_, 
  &iwork_[8], &iwork_[9], &iwork_[10], &iwork_[3], &iwork_[4], &iwork_[1], &iwork_[2], &work_[165], y_, &work_[250], 
  &work_[ia_ - 1], &convrg_, &work_[idfdy_ - 1], &work_[3], &work_[ifac_ - 1], &work_[161], &iwork_[50], &jstate_, 
  &iwork_[21], &iwork_[11], &iwork_[14], &work_[163], &work_[164], &work_[isave1_ - 1], &work_[isave2_ - 1], &work_[167], 
  &work_[203], mint_, &iwork_[16], &iwork_[18]);
  (*t_) = work_[165];
  h_ = work_[159];
  if (convrg_) {
    iwork_[6] = 1;
  }
  else {
    iwork_[6] = 0;
  }
  switch (jstate_) {
    default:
    case 1: goto _l470;
    case 2: goto _l670;
    case 3: goto _l680;
    case 4: goto _l690;
    case 5: goto _l690;
    case 6: goto _l660;
    case 7: goto _l660;
    case 8: goto _l660;
    case 9: goto _l660;
    case 10: goto _l660;
  }
  _l470:;
  iwork_[8] = 1;
  if ((*nroot_) != 0) {
    iroot_ = 0;
    for (i_ = 1; i_ <= (*nroot_); (i_)++) {
      glast_ = work_[i_ + ignow_ - 1 - 1];
      gnow_ = _g (&npar_, t_, y_, &i_);
      if (npar_ == 0) {
        iwork_[5] = i_;
        (*nstate_) = 7;
        goto _l0;
      }
      work_[i_ + ignow_ - 1 - 1] = gnow_;
      if (glast_ * gnow_ > 0.0e0) {
        work_[i_ + itroot_ - 1 - 1] = (*t_) + h_;
      }
      else {
        if (gnow_ == 0.0e0) {
          work_[i_ + itroot_ - 1 - 1] = (*t_);
          iroot_ = i_;
        }
        else {
          if (glast_ == 0.0e0) {
            work_[i_ + itroot_ - 1 - 1] = (*t_) + h_;
          }
          else {
            if (_abs (hused_) >= uround_ * _abs ((*t_))) {
              tlast_ = (*t_) - hused_;
              iroot_ = i_;
              troot_ = (*t_);
              (void) _ddzro (&ae_, _g, &h_, &npar_, &iwork_[11], &iroot_, &re_, t_, &work_[250], &uround_, &troot_, &tlast_, &gnow_, 
              &glast_, y_);
              for (j_ = 1; j_ <= (*n_); (j_)++) {
                y_[j_ - 1] = work_[251 + j_ - 1 - 1];
              }
              if (npar_ == 0) {
                iwork_[5] = i_;
                (*nstate_) = 7;
                goto _l0;
              }
              work_[i_ + itroot_ - 1 - 1] = troot_;
            }
            else {
              work_[i_ + itroot_ - 1 - 1] = (*t_);
              iroot_ = i_;
            }
          }
        }
      }
    }
    if (iroot_ == 0) {
      iwork_[7] = 0;
    }
    else {
      iwork_[7] = (*ntask_);
      iwork_[12] = (*nroot_);
      iwork_[13] = itroot_;
      troot_ = (*t_) + h_;
      for (i_ = 1; i_ <= (*nroot_); (i_)++) {
        if (work_[i_ + itroot_ - 1 - 1] * hsign_ < troot_ * hsign_) {
          troot_ = work_[i_ + itroot_ - 1 - 1];
          iroot_ = i_;
        }
      }
      iwork_[5] = iroot_;
      work_[166] = troot_;
      if (troot_ * hsign_ <= (*tout_) * hsign_) {
        (void) _ddntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
        (*nstate_) = 5;
        (*t_) = troot_;
        (*ierflg_) = 0;
        goto _l580;
      }
    }
  }
  (*nstate_) = 2;
  if ((*ntask_) == 1) {
    if ((*t_) * hsign_ < (*tout_) * hsign_) {
      goto _l260;
    }
    (void) _ddntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
    (*t_) = (*tout_);
    (*ierflg_) = 0;
    goto _l580;
  }
  else if ((*ntask_) == 2) {
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
    }
    else {
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = (*tout_) - (*t_);
        if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
          h_ = h_ * (1.0e0 - 4.0e0 * uround_);
        }
        work_[159] = h_;
        if (h_ == 0.0e0) {
          goto _l670;
        }
        iwork_[8] = -1;
      }
    }
  }
  else if ((*ntask_) == 3) {
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
    }
    else {
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = (*tout_) - (*t_);
        if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
          h_ = h_ * (1.0e0 - 4.0e0 * uround_);
        }
        work_[159] = h_;
        if (h_ == 0.0e0) {
          goto _l670;
        }
        iwork_[8] = -1;
      }
      goto _l260;
    }
  }
  (*ierflg_) = 0;
  _l560:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = work_[i_ + 251 - 1 - 1];
  }
  _l580:;
  if (iwork_[8] == 0) {
    goto _l0;
  }
  big_ = 0.0;
  imxerr_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    size_ = _abs (work_[i_ + isave1_ - 1 - 1] / work_[i_ + iywt_ - 1 - 1]);
    if (big_ < size_) {
      big_ = size_;
      imxerr_ = i_;
    }
  }
  iwork_[0] = imxerr_;
  work_[1] = hused_;
  goto _l0;
  _l660:;
  (*nstate_) = jstate_;
  goto _l0;
  _l670:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:ddriv3:1503", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100614_[__fcnt] != NULL && $f_100614_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100614_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1503", 0));
    __fcnt += 3;
  }
  if ($f_100614_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100614_[__fcnt] != NULL && $f_100614_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100614_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1503", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100614_[__fcnt + 2], &(*t_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1503", 0));
  __fcnt += 3;
  while ($f_100614_[__fcnt] != NULL && $f_100614_[__fcnt] == FMT_TEXT) {
    if ($f_100614_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100614_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1503", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 41;
  (void) _xermsg (_dc_0, _dc_59, (bufcpy ($83_, concat ($82_, concat ($81_, concat ($80_, _dc_39, rl1_), _dc_51), 
  _dc_52), 255), $83_), ierflg_, &_k1);
  (*nstate_) = 12;
  goto _l0;
  _l680:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:ddriv3:1512", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100619_[__fcnt] != NULL && $f_100619_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100619_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1512", 0));
    __fcnt += 3;
  }
  if ($f_100619_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100619_[__fcnt] != NULL && $f_100619_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100619_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1512", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100619_[__fcnt + 2], &(*t_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1512", 0));
  __fcnt += 3;
  while ($f_100619_[__fcnt] != NULL && $f_100619_[__fcnt] == FMT_TEXT) {
    if ($f_100619_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100619_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1512", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 42;
  (void) _xermsg (_dc_0, _dc_59, (bufcpy ($88_, concat ($87_, concat ($86_, concat ($85_, concat ($84_, _dc_39, rl1_), 
  _dc_53), _dc_54), _dc_55), 511), $88_), ierflg_, &_k1);
  (*nstate_) = 12;
  goto _l0;
  _l690:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:ddriv3:1521", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100624_[__fcnt] != NULL && $f_100624_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100624_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1521", 0));
    __fcnt += 3;
  }
  if ($f_100624_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100624_[__fcnt] != NULL && $f_100624_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100624_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1521", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100624_[__fcnt + 2], &(*t_), REAL, 8);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1521", 0));
  __fcnt += 3;
  while ($f_100624_[__fcnt] != NULL && $f_100624_[__fcnt] == FMT_TEXT) {
    if ($f_100624_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100624_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:ddriv3:1521", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 43;
  (void) _xermsg (_dc_0, _dc_59, (bufcpy ($91_, concat ($90_, concat ($89_, _dc_39, rl1_), _dc_56), 127), $91_), ierflg_, 
  &_k1);
  (*nstate_) = 12;
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _ddscl (real_8 _p_ hmax_, int_4 _p_ n_, int_4 _p_ nq_, real_8 _p_ rmax_, real_8 _p_ h_, real_8 _p_ rc_, real_8 
_p_ rh_, real_8 _p_ yh_)
{
  static int_4 i_, j_;
  static real_8 r1_;
  real_8 $0_, $1_;
  if ((*h_) < 1.0e0) {
    (*rh_) = ($0_ = _min (_abs ((*h_)) * (*rh_), _abs ((*h_)) * (*rmax_)), _min ($0_, (*hmax_))) / _abs ((*h_));
  }
  else {
    (*rh_) = ($1_ = _min ((*rh_), (*rmax_)), _min ($1_, (*hmax_) / _abs ((*h_))));
  }
  r1_ = 1.0;
  for (j_ = 1; j_ <= (*nq_); (j_)++) {
    r1_ = r1_ * (*rh_);
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))] * r1_;
    }
  }
  (*h_) = (*h_) * (*rh_);
  (*rc_) = (*rc_) * (*rh_);
  __calls[21].calls++;
  return 0;
}

int_4 _ddstp (real_8 _p_ eps_, int_4 (*_f)(), real_4 (*_fa)(), real_8 _p_ hmax_, int_4 _p_ impl_, int_4 _p_ ierror_, 
int_4 (*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ 
mu_, int_4 _p_ n_, int_4 _p_ nde_, real_8 _p_ ywt_, real_8 _p_ uround_, real_4 (*_users)(), real_8 _p_ avgh_, real_8 
_p_ avgord_, real_8 _p_ h_, real_8 _p_ hused_, int_4 _p_ jtask_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, 
int_4 _p_ nje_, int_4 _p_ nqused_, int_4 _p_ nstep_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ yh_, real_8 _p_ a_, 
logical_4 _p_ convrg_, real_8 _p_ dfdy_, real_8 _p_ el_, real_8 _p_ fac_, real_8 _p_ hold_, int_4 _p_ ipvt_, int_4 _p_ 
jstate_, int_4 _p_ jstepl_, int_4 _p_ nq_, int_4 _p_ nwait_, real_8 _p_ rc_, real_8 _p_ rmax_, real_8 _p_ save1_, 
real_8 _p_ save2_, real_8 _p_ tq_, real_8 _p_ trend_, int_4 _p_ iswflg_, int_4 _p_ mtrsv_, int_4 _p_ mxrdsv_)
{
  static int_4 i_, iter_, j_, nfail_, nsv_, ntry_;
  static logical_4 evalfa_, evaljc_, ier_, switch_;
  static real_8 bnd_, ctest_, d_, denom_, d1_, erdn_, erup_, etest_, hn_, hs_, numer_, rh_, rh1_, rh2_, rh3_, told_, 
  y0nrm_;
  int_4 _data_k_3;
  extern real_8 _dnrm2 ();
#define _data_n_3 1
  static logical_4 _data_l_3[_data_n_3] = {
    FALSE
  };
  if (__calls[22].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    ier_ = _data_l_3[_data_k_3++];
  }
  nsv_ = (*n_);
  bnd_ = 0.0;
  switch_ = FALSE;
  ntry_ = 0;
  told_ = (*t_);
  nfail_ = 0;
  if ((*jtask_) <= 0) {
    (void) _ddntl (eps_, _f, _fa, hmax_, hold_, impl_, jtask_, matdim_, maxord_, mint_, miter_, ml_, mu_, n_, nde_, save1_, 
    t_, uround_, _users, y_, ywt_, h_, mntold_, mtrold_, nfe_, rc_, yh_, a_, convrg_, el_, fac_, &ier_, ipvt_, nq_, nwait_, 
    &rh_, rmax_, save2_, tq_, trend_, iswflg_, jstate_);
    if ((*n_) == 0) {
      goto _l440;
    }
    if ((*h_) == 0.0e0) {
      goto _l400;
    }
    if (ier_) {
      goto _l420;
    }
  }
  _l100:;
  ntry_ = ntry_ + 1;
  if (ntry_ > 50) {
    goto _l410;
  }
  (*t_) = (*t_) + (*h_);
  (void) _ddpsc (&_k1, n_, nq_, yh_);
  evaljc_ = (((_abs ((*rc_) - 1.0e0) > .3e0) || ((*nstep_) >= (*jstepl_) + 10)) && ((*miter_) != 0));
  evalfa_ = ! (evaljc_);
  _l110:;
  iter_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  (void) _f (n_, t_, y_, save2_);
  if ((*n_) == 0) {
    (*jstate_) = 6;
    goto _l430;
  }
  (*nfe_) = (*nfe_) + 1;
  if (evaljc_ || ier_) {
    (void) _ddpst (el_, _f, _fa, h_, impl_, _jacobn, matdim_, miter_, ml_, mu_, n_, nde_, nq_, save2_, t_, _users, y_, yh_, 
    ywt_, uround_, nfe_, nje_, a_, dfdy_, fac_, &ier_, ipvt_, save1_, iswflg_, &bnd_, jstate_);
    if ((*n_) == 0) {
      goto _l430;
    }
    if (ier_) {
      goto _l160;
    }
    (*convrg_) = FALSE;
    (*rc_) = 1.0;
    (*jstepl_) = (*nstep_);
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    save1_[i_ - 1] = 0.0;
  }
  _l130:;
  (void) _ddcor (dfdy_, el_, _fa, h_, ierror_, impl_, ipvt_, matdim_, miter_, ml_, mu_, n_, nde_, nq_, t_, _users, y_, 
  yh_, ywt_, &evalfa_, save1_, save2_, a_, &d_, jstate_);
  if ((*n_) == 0) {
    goto _l430;
  }
  if ((*iswflg_) == 3 && (*mint_) == 1) {
    if (iter_ == 0) {
      numer_ = _dnrm2 (n_, save1_, &_k1);
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1];
      }
      y0nrm_ = _dnrm2 (n_, yh_, &_k1);
    }
    else {
      denom_ = numer_;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1] - dfdy_[0 + ((*matdim_)) * ((i_ - 1))];
      }
      numer_ = _dnrm2 (n_, dfdy_, matdim_);
      if (el_[0 + (13) * (((*nq_) - 1))] * numer_ <= 100.0e0 * (*uround_) * y0nrm_) {
        if ((*rmax_) == 2.0) {
          switch_ = TRUE;
          goto _l170;
        }
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1];
      }
      if (denom_ != 0.0e0) {
        bnd_ = _max (bnd_, numer_ / (denom_ * _abs ((*h_)) * el_[0 + (13) * (((*nq_) - 1))]));
      }
    }
  }
  if (iter_ > 0) {
    (*trend_) = _max (.9e0 * (*trend_), d_ / d1_);
  }
  d1_ = d_;
  ctest_ = _min (2.0e0 * (*trend_), 1.0) * d_;
  if (ctest_ <= (*eps_)) {
    goto _l170;
  }
  iter_ = iter_ + 1;
  if (iter_ < 3) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))] + el_[0 + (13) * (((*nq_) - 1))] * save1_[i_ - 1];
    }
    (void) _f (n_, t_, y_, save2_);
    if ((*n_) == 0) {
      (*jstate_) = 6;
      goto _l430;
    }
    (*nfe_) = (*nfe_) + 1;
    goto _l130;
  }
  if ((*convrg_)) {
    evaljc_ = TRUE;
    evalfa_ = FALSE;
    goto _l110;
  }
  _l160:;
  (*t_) = told_;
  (void) _ddpsc (&_km1, n_, nq_, yh_);
  (*nwait_) = (*nq_) + 2;
  if ((*jtask_) != 0 && (*jtask_) != 2) {
    (*rmax_) = 2.0;
  }
  if (iter_ == 0) {
    rh_ = .3e0;
  }
  else {
    rh_ = .9e0 * pow (((*eps_) / ctest_), .2e0);
  }
  if (rh_ * (*h_) == 0.0e0) {
    goto _l400;
  }
  (void) _ddscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
  goto _l100;
  _l170:;
  (*convrg_) = ((*miter_) != 0);
  if ((*ierror_) == 1 || (*ierror_) == 5) {
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save2_[i_ - 1] = save1_[i_ - 1] / ywt_[i_ - 1];
    }
  }
  else {
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save2_[i_ - 1] = save1_[i_ - 1] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
    }
  }
  etest_ = _dnrm2 (nde_, save2_, &_k1) / (tq_[1 + (3) * (((*nq_) - 1))] * sqrt ((real_8) ((*nde_))));
  if (etest_ > (*eps_)) {
    (*t_) = told_;
    (void) _ddpsc (&_km1, n_, nq_, yh_);
    nfail_ = nfail_ + 1;
    if (nfail_ < 3 || (*nq_) == 1) {
      if ((*jtask_) != 0 && (*jtask_) != 2) {
        (*rmax_) = 2.0;
      }
      rh2_ = 1.0e0 / (1.2 * pow ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
      if ((*nq_) > 1) {
        if ((*ierror_) == 1 || (*ierror_) == 5) {
          for (i_ = 1; i_ <= (*nde_); (i_)++) {
            save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / ywt_[i_ - 1];
          }
        }
        else {
          for (i_ = 1; i_ <= (*nde_); (i_)++) {
            save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
          }
        }
        erdn_ = _dnrm2 (nde_, save2_, &_k1) / (tq_[0 + (3) * (((*nq_) - 1))] * sqrt ((real_8) ((*nde_))));
        rh1_ = 1.0e0 / _max (1.0, 1.3 * pow ((erdn_ / (*eps_)), (1.0e0 / (*nq_))));
        if (rh2_ < rh1_) {
          (*nq_) = (*nq_) - 1;
          (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) + 1 - 1))];
          rh_ = rh1_;
        }
        else {
          rh_ = rh2_;
        }
      }
      else {
        rh_ = rh2_;
      }
      (*nwait_) = (*nq_) + 2;
      if (rh_ * (*h_) == 0.0e0) {
        goto _l400;
      }
      (void) _ddscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
      goto _l100;
    }
    nfail_ = 0;
    (*jtask_) = 2;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
    }
    (void) _ddntl (eps_, _f, _fa, hmax_, hold_, impl_, jtask_, matdim_, maxord_, mint_, miter_, ml_, mu_, n_, nde_, save1_, 
    t_, uround_, _users, y_, ywt_, h_, mntold_, mtrold_, nfe_, rc_, yh_, a_, convrg_, el_, fac_, &ier_, ipvt_, nq_, nwait_, 
    &rh_, rmax_, save2_, tq_, trend_, iswflg_, jstate_);
    (*rmax_) = 10.0;
    if ((*n_) == 0) {
      goto _l440;
    }
    if ((*h_) == 0.0e0) {
      goto _l400;
    }
    if (ier_) {
      goto _l420;
    }
    goto _l100;
  }
  (*nstep_) = (*nstep_) + 1;
  (*hused_) = (*h_);
  (*nqused_) = (*nq_);
  (*avgh_) = (((*nstep_) - 1) * (*avgh_) + (*h_)) / (*nstep_);
  (*avgord_) = (((*nstep_) - 1) * (*avgord_) + (*nq_)) / (*nstep_);
  for (j_ = 1; j_ <= (*nq_) + 1; (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + el_[j_ - 1 + (13) * (((*nq_) - 1))] * 
      save1_[i_ - 1];
    }
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  if ((*iswflg_) == 3) {
    if (bnd_ != 0.0e0) {
      if ((*mint_) == 1 && (*nq_) <= 5) {
        hn_ = _abs ((*h_)) / _max ((*uround_), pow ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _min (hn_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_));
        hs_ = _abs ((*h_)) / _max ((*uround_), pow ((etest_ / ((*eps_) * el_[(*nq_) + 1 - 1])), (1.0e0 / ((*nq_) + 1))));
        if (hs_ > 1.2e0 * hn_) {
          (*mint_) = 2;
          (*mntold_) = (*mint_);
          (*miter_) = (*mtrsv_);
          (*mtrold_) = (*miter_);
          (*maxord_) = _min ((*mxrdsv_), 5);
          (*rc_) = 0.0;
          (*rmax_) = 10.0;
          (*trend_) = 1.0;
          (void) _ddcst (maxord_, mint_, iswflg_, el_, tq_);
          (*nwait_) = (*nq_) + 2;
        }
      }
      else if ((*mint_) == 2) {
        hs_ = _abs ((*h_)) / _max ((*uround_), pow ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _abs ((*h_)) / _max ((*uround_), pow ((etest_ * el_[(*nq_) + 1 - 1] / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _min (hn_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_));
        if (hn_ >= hs_) {
          (*mint_) = 1;
          (*mntold_) = (*mint_);
          (*miter_) = 0;
          (*mtrold_) = (*miter_);
          (*maxord_) = _min ((*mxrdsv_), 12);
          (*rmax_) = 10.0;
          (*trend_) = 1.0;
          (*convrg_) = FALSE;
          (void) _ddcst (maxord_, mint_, iswflg_, el_, tq_);
          (*nwait_) = (*nq_) + 2;
        }
      }
    }
  }
  if (switch_) {
    (*mint_) = 2;
    (*mntold_) = (*mint_);
    (*miter_) = (*mtrsv_);
    (*mtrold_) = (*miter_);
    (*maxord_) = _min ((*mxrdsv_), 5);
    (*nq_) = _min ((*nq_), (*maxord_));
    (*rc_) = 0.0;
    (*rmax_) = 10.0;
    (*trend_) = 1.0;
    (void) _ddcst (maxord_, mint_, iswflg_, el_, tq_);
    (*nwait_) = (*nq_) + 2;
  }
  if ((*jtask_) == 0 || (*jtask_) == 2) {
    rh_ = 1.0e0 / _max ((*uround_), 1.2 * pow ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
    if (rh_ > 1.0) {
      (void) _ddscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
    }
  }
  else if ((*nwait_) > 1) {
    (*nwait_) = (*nwait_) - 1;
    if ((*nwait_) == 1 && (*nq_) < (*maxord_)) {
      for (i_ = 1; i_ <= (*nde_); (i_)++) {
        yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))] = save1_[i_ - 1];
      }
    }
  }
  else {
    if ((*nq_) == 1) {
      rh1_ = 0.0;
    }
    else {
      if ((*ierror_) == 1 || (*ierror_) == 5) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / ywt_[i_ - 1];
        }
      }
      else {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
        }
      }
      erdn_ = _dnrm2 (nde_, save2_, &_k1) / (tq_[0 + (3) * (((*nq_) - 1))] * sqrt ((real_8) ((*nde_))));
      rh1_ = 1.0e0 / _max ((*uround_), 1.3 * pow ((erdn_ / (*eps_)), (1.0e0 / (*nq_))));
    }
    rh2_ = 1.0e0 / _max ((*uround_), 1.2 * pow ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
    if ((*nq_) == (*maxord_)) {
      rh3_ = 0.0;
    }
    else {
      if ((*ierror_) == 1 || (*ierror_) == 5) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = (save1_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))]) / ywt_[i_ - 1];
        }
      }
      else {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = (save1_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))]) / _max (_abs (y_[i_ - 1]), ywt_[i_ - 
          1]);
        }
      }
      erup_ = _dnrm2 (nde_, save2_, &_k1) / (tq_[2 + (3) * (((*nq_) - 1))] * sqrt ((real_8) ((*nde_))));
      rh3_ = 1.0e0 / _max ((*uround_), 1.4 * pow ((erup_ / (*eps_)), (1.0e0 / ((*nq_) + 2))));
    }
    if (rh1_ > rh2_ && rh1_ >= rh3_) {
      rh_ = rh1_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
      (*nq_) = (*nq_) - 1;
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) + 1 - 1))];
    }
    else if (rh2_ >= rh1_ && rh2_ >= rh3_) {
      rh_ = rh2_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
    }
    else {
      rh_ = rh3_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        yh_[i_ - 1 + ((*n_)) * (((*nq_) + 2 - 1))] = save1_[i_ - 1] * el_[(*nq_) + 1 - 1 + (13) * (((*nq_) - 1))] / ((*nq_) + 
        1);
      }
      (*nq_) = (*nq_) + 1;
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) - 1 - 1))];
    }
    if ((*iswflg_) == 3 && (*mint_) == 1) {
      if (bnd_ != 0.0e0) {
        rh_ = _min (rh_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_ * _abs ((*h_))));
      }
    }
    (void) _ddscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
    (*rmax_) = 10.0;
    _l380:;
    (*nwait_) = (*nq_) + 2;
  }
  (*jstate_) = 1;
  (*hold_) = (*h_);
  goto _l0;
  _l400:;
  (*jstate_) = 2;
  (*hold_) = (*h_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  goto _l0;
  _l410:;
  (*jstate_) = 3;
  (*hold_) = (*h_);
  goto _l0;
  _l420:;
  (*jstate_) = 4;
  (*hold_) = (*h_);
  goto _l0;
  _l430:;
  (*t_) = told_;
  (void) _ddpsc (&_km1, &nsv_, nq_, yh_);
  for (i_ = 1; i_ <= nsv_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  _l440:;
  (*hold_) = (*h_);
  _l0:;
  __calls[22].calls++;
  return 0;
}

int_4 _ddzro (real_8 _p_ ae_, real_8 (*_f)(), real_8 _p_ h_, int_4 _p_ n_, int_4 _p_ nq_, int_4 _p_ iroot_, real_8 _p_ 
re_, real_8 _p_ t_, real_8 _p_ yh_, real_8 _p_ uround_, real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ fb_, real_8 _p_ fc_, 
real_8 _p_ y_)
{
  static int_4 ic_, kount_;
  static real_8 a_, acbs_, acmb_, cmb_, er_, fa_, p_, q_, rw_, tol_;
  er_ = 4.0e0 * (*uround_);
  rw_ = _max ((*re_), er_);
  ic_ = 0;
  acbs_ = _abs ((*b_) - (*c_));
  a_ = (*c_);
  fa_ = (*fc_);
  kount_ = 0;
  _l10:;
  if (_abs ((*fc_)) < _abs ((*fb_))) {
    a_ = (*b_);
    fa_ = (*fb_);
    (*b_) = (*c_);
    (*fb_) = (*fc_);
    (*c_) = a_;
    (*fc_) = fa_;
  }
  cmb_ = 0.5e0 * ((*c_) - (*b_));
  acmb_ = _abs (cmb_);
  tol_ = rw_ * _abs ((*b_)) + (*ae_);
  if (acmb_ <= tol_) {
    goto _l0;
  }
  if (kount_ > 50) {
    goto _l0;
  }
  p_ = ((*b_) - a_) * (*fb_);
  q_ = fa_ - (*fb_);
  if (p_ < 0.0e0) {
    p_ = -p_;
    q_ = -q_;
  }
  a_ = (*b_);
  fa_ = (*fb_);
  ic_ = ic_ + 1;
  if (ic_ >= 4) {
    if (8.0e0 * acmb_ >= acbs_) {
      (*b_) = 0.5e0 * ((*c_) + (*b_));
      goto _l20;
    }
    ic_ = 0;
  }
  acbs_ = acmb_;
  if (p_ <= _abs (q_) * tol_) {
    (*b_) = (*b_) + _sign (tol_, cmb_);
  }
  else if (p_ < cmb_ * q_) {
    (*b_) = (*b_) + p_ / q_;
  }
  else {
    (*b_) = 0.5e0 * ((*c_) + (*b_));
  }
  _l20:;
  (void) _ddntp (h_, &_k0, n_, nq_, t_, b_, yh_, y_);
  (*fb_) = _f (n_, b_, y_, iroot_);
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*fb_) == 0.0e0) {
    goto _l0;
  }
  kount_ = kount_ + 1;
  if (_sign (1.0, (*fb_)) == _sign (1.0, (*fc_))) {
    (*c_) = a_;
    (*fc_) = fa_;
  }
  goto _l10;
  _l0:;
  __calls[23].calls++;
  return 0;
}

int_4 _sdcor (real_4 _p_ dfdy_, real_4 _p_ el_, int_4 (*_fa)(), real_4 _p_ h_, int_4 _p_ ierror_, int_4 _p_ impl_, 
int_4 _p_ ipvt_, int_4 _p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 
_p_ nq_, real_4 _p_ t_, int_4 (*_users)(), real_4 _p_ y_, real_4 _p_ yh_, real_4 _p_ ywt_, logical_4 _p_ evalfa_, 
real_4 _p_ save1_, real_4 _p_ save2_, real_4 _p_ a_, real_4 _p_ d_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, j_, mw_;
  extern real_4 _snrm2 ();
  if ((*miter_) == 0) {
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = ((*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1]) / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = ((*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1]) / _max (_abs (y_[i_ - 1]), 
        ywt_[i_ - 1]);
      }
    }
    (*d_) = _snrm2 (n_, save1_, &_k1) / sqrtf ((real_4) ((*n_)));
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      save1_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))];
    }
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1];
      }
    }
    else if ((*impl_) == 1) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          save2_[i_ - 1] = save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) * ((1))] + save1_[j_ - 
          1]);
        }
      }
    }
    else if ((*impl_) == 2) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((0))] * (yh_[i_ - 1 + ((*n_)) * ((1))] + 
        save1_[i_ - 1]);
      }
    }
    else if ((*impl_) == 3) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) * ((1))] + save1_[j_ - 
          1]);
        }
      }
    }
    (void) _sgesl (dfdy_, matdim_, n_, ipvt_, save2_, &_k0);
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
      }
    }
    (*d_) = _snrm2 (n_, save2_, &_k1) / sqrtf ((real_4) ((*n_)));
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * ((1))] - save1_[i_ - 1];
      }
    }
    else if ((*impl_) == 1) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      mw_ = (*ml_) + 1 + (*mu_);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          save2_[i_ + j_ - mw_ - 1] = save2_[i_ + j_ - mw_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) 
          * ((1))] + save1_[j_ - 1]);
        }
      }
    }
    else if ((*impl_) == 2) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((0))] * (yh_[i_ - 1 + ((*n_)) * ((1))] + 
        save1_[i_ - 1]);
      }
    }
    else if ((*impl_) == 3) {
      if ((*evalfa_)) {
        (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
      }
      else {
        (*evalfa_) = TRUE;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save2_[i_ - 1] = (*h_) * save2_[i_ - 1];
      }
      mw_ = (*ml_) + 1 + (*mu_);
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*nde_) - j_, mw_ + (*ml_)); (i_)++) {
          save2_[i_ + j_ - mw_ - 1] = save2_[i_ + j_ - mw_ - 1] - a_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] * (yh_[j_ - 1 + ((*n_)) 
          * ((1))] + save1_[j_ - 1]);
        }
      }
    }
    (void) _sgbsl (dfdy_, matdim_, n_, ml_, mu_, ipvt_, save2_, &_k0);
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
      }
    }
    (*d_) = _snrm2 (n_, save2_, &_k1) / sqrtf ((real_4) ((*n_)));
  }
  else if ((*miter_) == 3) {
    iflag_ = 2;
    (void) _users (y_, &yh_[0 + ((*n_)) * ((1))], ywt_, save1_, save2_, t_, h_, &el_[0 + (13) * (((*nq_) - 1))], impl_, n_, 
    nde_, &iflag_);
    if ((*n_) == 0) {
      (*jstate_) = 10;
      goto _l0;
    }
    if ((*ierror_) == 1 || (*ierror_) == 5) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / ywt_[i_ - 1];
      }
    }
    else {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        save1_[i_ - 1] = save1_[i_ - 1] + save2_[i_ - 1];
        save2_[i_ - 1] = save2_[i_ - 1] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
      }
    }
    (*d_) = _snrm2 (n_, save2_, &_k1) / sqrtf ((real_4) ((*n_)));
  }
  _l0:;
  __calls[24].calls++;
  return 0;
}

int_4 _sdcst (int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ iswflg_, real_4 _p_ el_, real_4 _p_ tq_)
{
  static int_4 i_, j_, mxrd_;
  static real_4 factrl_[12], gamma_[14], sum_;
  factrl_[0] = 1.0;
  for (i_ = 2; i_ <= (*maxord_); (i_)++) {
    factrl_[i_ - 1] = i_ * factrl_[i_ - 1 - 1];
  }
  if ((*mint_) == 1) {
    gamma_[0] = 1.0;
    for (i_ = 1; i_ <= (*maxord_) + 1; (i_)++) {
      sum_ = 0.0;
      for (j_ = 1; j_ <= i_; (j_)++) {
        sum_ = sum_ - gamma_[j_ - 1] / (i_ - j_ + 2);
      }
      gamma_[i_ + 1 - 1] = sum_;
    }
    el_[0] = 1.0;
    el_[1] = 1.0;
    el_[14] = 1.0;
    el_[15] = 1.0;
    for (j_ = 3; j_ <= (*maxord_); (j_)++) {
      el_[1 + (13) * ((j_ - 1))] = factrl_[j_ - 1 - 1];
      for (i_ = 3; i_ <= j_; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = (j_ - 1) * el_[i_ - 1 + (13) * ((j_ - 1 - 1))] + el_[i_ - 1 - 1 + (13) * ((j_ - 1 - 
        1))];
      }
      el_[j_ + 1 - 1 + (13) * ((j_ - 1))] = 1.0;
    }
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      el_[0 + (13) * ((j_ - 1))] = el_[0 + (13) * ((j_ - 1 - 1))] + gamma_[j_ - 1];
      el_[1 + (13) * ((j_ - 1))] = 1.0;
      for (i_ = 3; i_ <= j_ + 1; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = el_[i_ - 1 + (13) * ((j_ - 1))] / ((i_ - 1) * factrl_[j_ - 1 - 1]);
      }
    }
    for (j_ = 1; j_ <= (*maxord_); (j_)++) {
      tq_[0 + (3) * ((j_ - 1))] = -1.0e0 / (factrl_[j_ - 1] * gamma_[j_ - 1]);
      tq_[1 + (3) * ((j_ - 1))] = -1.0e0 / gamma_[j_ + 1 - 1];
      tq_[2 + (3) * ((j_ - 1))] = -1.0e0 / gamma_[j_ + 2 - 1];
    }
  }
  else if ((*mint_) == 2) {
    el_[0] = 1.0;
    el_[1] = 1.0;
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      el_[0 + (13) * ((j_ - 1))] = factrl_[j_ - 1];
      for (i_ = 2; i_ <= j_; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = j_ * el_[i_ - 1 + (13) * ((j_ - 1 - 1))] + el_[i_ - 1 - 1 + (13) * ((j_ - 1 - 1))];
      }
      el_[j_ + 1 - 1 + (13) * ((j_ - 1))] = 1.0;
    }
    sum_ = 1.0;
    for (j_ = 2; j_ <= (*maxord_); (j_)++) {
      sum_ = sum_ + 1.0e0 / j_;
      for (i_ = 1; i_ <= j_ + 1; (i_)++) {
        el_[i_ - 1 + (13) * ((j_ - 1))] = el_[i_ - 1 + (13) * ((j_ - 1))] / (factrl_[j_ - 1] * sum_);
      }
    }
    for (j_ = 1; j_ <= (*maxord_); (j_)++) {
      if (j_ > 1) {
        tq_[0 + (3) * ((j_ - 1))] = 1.0e0 / factrl_[j_ - 1 - 1];
      }
      tq_[1 + (3) * ((j_ - 1))] = (j_ + 1) / el_[0 + (13) * ((j_ - 1))];
      tq_[2 + (3) * ((j_ - 1))] = (j_ + 2) / el_[0 + (13) * ((j_ - 1))];
    }
  }
  if ((*iswflg_) == 3) {
    mxrd_ = _min ((*maxord_), 5);
    if ((*mint_) == 2) {
      gamma_[0] = 1.0;
      for (i_ = 1; i_ <= mxrd_; (i_)++) {
        sum_ = 0.0;
        for (j_ = 1; j_ <= i_; (j_)++) {
          sum_ = sum_ - gamma_[j_ - 1] / (i_ - j_ + 2);
        }
        gamma_[i_ + 1 - 1] = sum_;
      }
    }
    sum_ = 1.0;
    for (i_ = 2; i_ <= mxrd_; (i_)++) {
      sum_ = sum_ + 1.0e0 / i_;
      el_[1 + i_ - 1] = -(i_ + 1) * sum_ * gamma_[i_ + 1 - 1];
    }
  }
  __calls[25].calls++;
  return 0;
}

int_4 _sdntl (real_4 _p_ eps_, int_4 (*_f)(), int_4 (*_fa)(), real_4 _p_ hmax_, real_4 _p_ hold_, int_4 _p_ impl_, 
int_4 _p_ jtask_, int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_
, int_4 _p_ n_, int_4 _p_ nde_, real_4 _p_ save1_, real_4 _p_ t_, real_4 _p_ uround_, int_4 (*_users)(), real_4 _p_ y_, 
real_4 _p_ ywt_, real_4 _p_ h_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, real_4 _p_ rc_, real_4 _p_ yh_, 
real_4 _p_ a_, logical_4 _p_ convrg_, real_4 _p_ el_, real_4 _p_ fac_, logical_4 _p_ ier_, int_4 _p_ ipvt_, int_4 _p_ 
nq_, int_4 _p_ nwait_, real_4 _p_ rh_, real_4 _p_ rmax_, real_4 _p_ save2_, real_4 _p_ tq_, real_4 _p_ trend_, int_4 
_p_ iswflg_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, info_;
  static real_4 oldl0_, sum_;
  extern real_4 _snrm2 ();
  (*ier_) = FALSE;
  if ((*jtask_) >= 0) {
    if ((*jtask_) == 0) {
      (void) _sdcst (maxord_, mint_, iswflg_, el_, tq_);
      (*rmax_) = 10000.0;
    }
    (*rc_) = 0.0;
    (*convrg_) = FALSE;
    (*trend_) = 1.0;
    (*nq_) = 1;
    (*nwait_) = 3;
    (void) _f (n_, t_, y_, save2_);
    if ((*n_) == 0) {
      (*jstate_) = 6;
      goto _l0;
    }
    (*nfe_) = (*nfe_) + 1;
    if ((*impl_) != 0) {
      if ((*miter_) == 3) {
        iflag_ = 0;
        (void) _users (y_, yh_, ywt_, save1_, save2_, t_, h_, el_, impl_, n_, nde_, &iflag_);
        if (iflag_ == -1) {
          (*ier_) = TRUE;
          goto _l0;
        }
        if ((*n_) == 0) {
          (*jstate_) = 10;
          goto _l0;
        }
      }
      else if ((*impl_) == 1) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _sgefa (a_, matdim_, n_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _sgesl (a_, matdim_, n_, ipvt_, save2_, &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _sgbfa (a_, matdim_, n_, ml_, mu_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _sgbsl (a_, matdim_, n_, ml_, mu_, ipvt_, save2_, &_k0);
        }
      }
      else if ((*impl_) == 2) {
        (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
        if ((*n_) == 0) {
          (*jstate_) = 9;
          goto _l0;
        }
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          if (a_[i_ - 1 + ((*matdim_)) * ((0))] == 0.0e0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          else {
            save2_[i_ - 1] = save2_[i_ - 1] / a_[i_ - 1 + ((*matdim_)) * ((0))];
          }
        }
        for (i_ = (*nde_) + 1; i_ <= (*n_); (i_)++) {
          a_[i_ - 1 + ((*matdim_)) * ((0))] = 0.0;
        }
      }
      else if ((*impl_) == 3) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _sgefa (a_, matdim_, nde_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _sgesl (a_, matdim_, nde_, ipvt_, save2_, &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
          if ((*n_) == 0) {
            (*jstate_) = 9;
            goto _l0;
          }
          (void) _sgbfa (a_, matdim_, nde_, ml_, mu_, ipvt_, &info_);
          if (info_ != 0) {
            (*ier_) = TRUE;
            goto _l0;
          }
          (void) _sgbsl (a_, matdim_, nde_, ml_, mu_, ipvt_, save2_, &_k0);
        }
      }
    }
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save1_[i_ - 1] = save2_[i_ - 1] / _max (1.0, ywt_[i_ - 1]);
    }
    sum_ = _snrm2 (nde_, save1_, &_k1) / sqrtf ((real_4) ((*nde_)));
    if (sum_ > (*eps_) / _abs ((*h_))) {
      (*h_) = _sign ((*eps_) / sum_, (*h_));
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((1))] = (*h_) * save2_[i_ - 1];
    }
    if ((*miter_) == 2 || (*miter_) == 5 || (*iswflg_) == 3) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        fac_[i_ - 1] = sqrtf ((*uround_));
      }
    }
  }
  else {
    if ((*miter_) != (*mtrold_)) {
      (*mtrold_) = (*miter_);
      (*rc_) = 0.0;
      (*convrg_) = FALSE;
    }
    if ((*mint_) != (*mntold_)) {
      (*mntold_) = (*mint_);
      oldl0_ = el_[0 + (13) * (((*nq_) - 1))];
      (void) _sdcst (maxord_, mint_, iswflg_, el_, tq_);
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / oldl0_;
      (*nwait_) = (*nq_) + 2;
    }
    if ((*h_) != (*hold_)) {
      (*nwait_) = (*nq_) + 2;
      (*rh_) = (*h_) / (*hold_);
      (void) _sdscl (hmax_, n_, nq_, rmax_, hold_, rc_, rh_, yh_);
    }
  }
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _sdntp (real_4 _p_ h_, int_4 _p_ k_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ t_, real_4 _p_ tout_, real_4 _p_ yh_
, real_4 _p_ y_)
{
  static int_4 i_, j_, jj_, kk_, kused_;
  static real_4 factor_, r_;
  if ((*k_) == 0) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))];
    }
    r_ = (((*tout_) - (*t_)) / (*h_));
    for (jj_ = 1; jj_ <= (*nq_); (jj_)++) {
      j_ = (*nq_) + 1 - jj_;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + r_ * y_[i_ - 1];
      }
    }
  }
  else {
    kused_ = _min ((*k_), (*nq_));
    factor_ = 1.0;
    for (kk_ = 1; kk_ <= kused_; (kk_)++) {
      factor_ = factor_ * ((*nq_) + 1 - kk_);
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = factor_ * yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))];
    }
    r_ = (((*tout_) - (*t_)) / (*h_));
    for (jj_ = kused_ + 1; jj_ <= (*nq_); (jj_)++) {
      j_ = kused_ + 1 + (*nq_) - jj_;
      factor_ = 1.0;
      for (kk_ = 1; kk_ <= kused_; (kk_)++) {
        factor_ = factor_ * (j_ - kk_);
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        y_[i_ - 1] = factor_ * yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + r_ * y_[i_ - 1];
      }
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = y_[i_ - 1] * _up_real_4 ((*h_), (-kused_));
    }
  }
  __calls[27].calls++;
  return 0;
}

int_4 _sdpsc (int_4 _p_ ksgn_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ yh_)
{
  static int_4 i_, j_, j1_, j2_;
  if ((*ksgn_) > 0) {
    for (j1_ = 1; j1_ <= (*nq_); (j1_)++) {
      for (j2_ = j1_; j2_ <= (*nq_); (j2_)++) {
        j_ = (*nq_) - j2_ + j1_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))];
        }
      }
    }
  }
  else {
    for (j1_ = 1; j1_ <= (*nq_); (j1_)++) {
      for (j2_ = j1_; j2_ <= (*nq_); (j2_)++) {
        j_ = (*nq_) - j2_ + j1_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] - yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))];
        }
      }
    }
  }
  __calls[28].calls++;
  return 0;
}

int_4 _sdpst (real_4 _p_ el_, int_4 (*_f)(), int_4 (*_fa)(), real_4 _p_ h_, int_4 _p_ impl_, int_4 (*_jacobn)(), int_4 
_p_ matdim_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ n_, int_4 _p_ nde_, int_4 _p_ nq_, real_4 _p_ 
save2_, real_4 _p_ t_, int_4 (*_users)(), real_4 _p_ y_, real_4 _p_ yh_, real_4 _p_ ywt_, real_4 _p_ uround_, int_4 _p_ 
nfe_, int_4 _p_ nje_, real_4 _p_ a_, real_4 _p_ dfdy_, real_4 _p_ fac_, logical_4 _p_ ier_, int_4 _p_ ipvt_, real_4 _p_ 
save1_, int_4 _p_ iswflg_, real_4 _p_ bnd_, int_4 _p_ jstate_)
{
  static int_4 i_, iflag_, imax_, info_, j_, j2_, k_, mw_;
  static real_4 bl_, bp_, br_, dfdymx_, diff_, dy_, facmin_, factor_, scale_, yj_, ys_;
  int_4 $0_, $1_;
  real_4 $2_;
  extern real_4 _snrm2 ();
  (*nje_) = (*nje_) + 1;
  (*ier_) = FALSE;
  if ((*miter_) == 1 || (*miter_) == 2) {
    if ((*miter_) == 1) {
      (void) _jacobn (n_, t_, y_, dfdy_, matdim_, ml_, mu_);
      if ((*n_) == 0) {
        (*jstate_) = 8;
        goto _l0;
      }
      if ((*iswflg_) == 3) {
        (*bnd_) = _snrm2 (($0_ = (*n_) * (*n_), &$0_), dfdy_, &_k1);
      }
      factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = factor_ * dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))];
        }
      }
    }
    else if ((*miter_) == 2) {
      br_ = powl ((*uround_), .875e0);
      bl_ = powl ((*uround_), .75e0);
      bp_ = powl ((*uround_), -.15e0);
      facmin_ = powl ((*uround_), .78e0);
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        ys_ = _max (_abs (ywt_[j_ - 1]), _abs (y_[j_ - 1]));
        _l120:;
        dy_ = fac_[j_ - 1] * ys_;
        if (dy_ == 0.0e0) {
          if (fac_[j_ - 1] < .5e0) {
            fac_[j_ - 1] = _min (100.0e0 * fac_[j_ - 1], .5e0);
            goto _l120;
          }
          else {
            dy_ = ys_;
          }
        }
        if ((*nq_) == 1) {
          dy_ = _sign (dy_, save2_[j_ - 1]);
        }
        else {
          dy_ = _sign (dy_, yh_[j_ - 1 + ((*n_)) * ((2))]);
        }
        dy_ = (y_[j_ - 1] + dy_) - y_[j_ - 1];
        yj_ = y_[j_ - 1];
        y_[j_ - 1] = y_[j_ - 1] + dy_;
        (void) _f (n_, t_, y_, save1_);
        if ((*n_) == 0) {
          (*jstate_) = 6;
          goto _l0;
        }
        y_[j_ - 1] = yj_;
        factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_) / dy_;
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = (save1_[i_ - 1] - save2_[i_ - 1]) * factor_;
        }
        diff_ = _abs (save2_[0] - save1_[0]);
        imax_ = 1;
        for (i_ = 2; i_ <= (*n_); (i_)++) {
          if (_abs (save2_[i_ - 1] - save1_[i_ - 1]) > diff_) {
            imax_ = i_;
            diff_ = _abs (save2_[i_ - 1] - save1_[i_ - 1]);
          }
        }
        if (_min (_abs (save2_[imax_ - 1]), _abs (save1_[imax_ - 1])) > 0.0e0) {
          scale_ = _max (_abs (save2_[imax_ - 1]), _abs (save1_[imax_ - 1]));
          if (diff_ > 0.5 * scale_) {
            fac_[j_ - 1] = _max (facmin_, fac_[j_ - 1] * .5e0);
          }
          else if (br_ * scale_ <= diff_ && diff_ <= bl_ * scale_) {
            fac_[j_ - 1] = _min (fac_[j_ - 1] * 2.0e0, .5e0);
          }
          else if (diff_ < br_ * scale_) {
            fac_[j_ - 1] = _min (bp_ * fac_[j_ - 1], .5e0);
          }
        }
      }
      if ((*iswflg_) == 3) {
        (*bnd_) = _snrm2 (($1_ = (*n_) * (*n_), &$1_), dfdy_, &_k1) / (-el_[0 + (13) * (((*nq_) - 1))] * (*h_));
      }
      (*nfe_) = (*nfe_) + (*n_);
    }
    if ((*impl_) == 0) {
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] + 1.0e0;
      }
    }
    else if ((*impl_) == 1) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    else if ((*impl_) == 2) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (i_ = 1; i_ <= (*nde_); (i_)++) {
        dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((i_ - 1))] + a_[i_ - 1 + ((*matdim_)) * 
        ((0))];
      }
    }
    else if ((*impl_) == 3) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    (void) _sgefa (dfdy_, matdim_, n_, ipvt_, &info_);
    if (info_ != 0) {
      (*ier_) = TRUE;
    }
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    if ((*miter_) == 4) {
      (void) _jacobn (n_, t_, y_, &dfdy_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_);
      if ((*n_) == 0) {
        (*jstate_) = 8;
        goto _l0;
      }
      factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_);
      mw_ = (*ml_) + (*mu_) + 1;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = factor_ * dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))];
        }
      }
    }
    else if ((*miter_) == 5) {
      br_ = powl ((*uround_), .875e0);
      bl_ = powl ((*uround_), .75e0);
      bp_ = powl ((*uround_), -.15e0);
      facmin_ = powl ((*uround_), .78e0);
      mw_ = (*ml_) + (*mu_) + 1;
      j2_ = _min (mw_, (*n_));
      for (j_ = 1; j_ <= j2_; (j_)++) {
        for (k_ = j_; (mw_ > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += mw_) {
          ys_ = _max (_abs (ywt_[k_ - 1]), _abs (y_[k_ - 1]));
          _l280:;
          dy_ = fac_[k_ - 1] * ys_;
          if (dy_ == 0.0e0) {
            if (fac_[k_ - 1] < .5e0) {
              fac_[k_ - 1] = _min (100.0e0 * fac_[k_ - 1], .5e0);
              goto _l280;
            }
            else {
              dy_ = ys_;
            }
          }
          if ((*nq_) == 1) {
            dy_ = _sign (dy_, save2_[k_ - 1]);
          }
          else {
            dy_ = _sign (dy_, yh_[k_ - 1 + ((*n_)) * ((2))]);
          }
          dy_ = (y_[k_ - 1] + dy_) - y_[k_ - 1];
          dfdy_[mw_ - 1 + ((*matdim_)) * ((k_ - 1))] = y_[k_ - 1];
          y_[k_ - 1] = y_[k_ - 1] + dy_;
        }
        (void) _f (n_, t_, y_, save1_);
        if ((*n_) == 0) {
          (*jstate_) = 6;
          goto _l0;
        }
        for (k_ = j_; (mw_ > 0 ? k_ <= (*n_) : k_ >= (*n_)); k_ += mw_) {
          y_[k_ - 1] = dfdy_[mw_ - 1 + ((*matdim_)) * ((k_ - 1))];
          ys_ = _max (_abs (ywt_[k_ - 1]), _abs (y_[k_ - 1]));
          dy_ = fac_[k_ - 1] * ys_;
          if (dy_ == 0.0e0) {
            dy_ = ys_;
          }
          if ((*nq_) == 1) {
            dy_ = _sign (dy_, save2_[k_ - 1]);
          }
          else {
            dy_ = _sign (dy_, yh_[k_ - 1 + ((*n_)) * ((2))]);
          }
          dy_ = (y_[k_ - 1] + dy_) - y_[k_ - 1];
          factor_ = -el_[0 + (13) * (((*nq_) - 1))] * (*h_) / dy_;
          for (i_ = _max ((*ml_) + 1, mw_ + 1 - k_); i_ <= _min (mw_ + (*n_) - k_, mw_ + (*ml_)); (i_)++) {
            dfdy_[i_ - 1 + ((*matdim_)) * ((k_ - 1))] = factor_ * (save1_[i_ + k_ - mw_ - 1] - save2_[i_ + k_ - mw_ - 1]);
          }
          imax_ = _max (1, k_ - (*mu_));
          diff_ = _abs (save2_[imax_ - 1] - save1_[imax_ - 1]);
          for (i_ = _max (1, k_ - (*mu_)) + 1; i_ <= _min (k_ + (*ml_), (*n_)); (i_)++) {
            if (_abs (save2_[i_ - 1] - save1_[i_ - 1]) > diff_) {
              imax_ = i_;
              diff_ = _abs (save2_[i_ - 1] - save1_[i_ - 1]);
            }
          }
          if (_min (_abs (save2_[imax_ - 1]), _abs (save1_[imax_ - 1])) > 0.0e0) {
            scale_ = _max (_abs (save2_[imax_ - 1]), _abs (save1_[imax_ - 1]));
            if (diff_ > 0.5 * scale_) {
              fac_[j_ - 1] = _max (facmin_, fac_[j_ - 1] * .5e0);
            }
            else if (br_ * scale_ <= diff_ && diff_ <= bl_ * scale_) {
              fac_[j_ - 1] = _min (fac_[j_ - 1] * 2.0e0, .5e0);
            }
            else if (diff_ < br_ * scale_) {
              fac_[k_ - 1] = _min (bp_ * fac_[k_ - 1], .5e0);
            }
          }
        }
      }
      (*nfe_) = (*nfe_) + j2_;
    }
    if ((*iswflg_) == 3) {
      dfdymx_ = 0.0;
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdymx_ = _max (dfdymx_, _abs (dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))]));
        }
      }
      (*bnd_) = 0.0;
      if (dfdymx_ != 0.0e0) {
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
            (*bnd_) = (*bnd_) + ($2_ = (dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] / dfdymx_), $2_ * $2_);
          }
        }
        (*bnd_) = dfdymx_ * sqrtf ((*bnd_)) / (-el_[0 + (13) * (((*nq_) - 1))] * (*h_));
      }
    }
    if ((*impl_) == 0) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] + 1.0e0;
      }
    }
    else if ((*impl_) == 1) {
      (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*n_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    else if ((*impl_) == 2) {
      (void) _fa (n_, t_, y_, a_, matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[mw_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[j_ - 1 + ((*matdim_)) * 
        ((0))];
      }
    }
    else if ((*impl_) == 3) {
      (void) _fa (n_, t_, y_, &a_[(*ml_) + 1 - 1 + ((*matdim_)) * ((0))], matdim_, ml_, mu_, nde_);
      if ((*n_) == 0) {
        (*jstate_) = 9;
        goto _l0;
      }
      for (j_ = 1; j_ <= (*nde_); (j_)++) {
        for (i_ = _max ((*ml_) + 1, mw_ + 1 - j_); i_ <= _min (mw_ + (*nde_) - j_, mw_ + (*ml_)); (i_)++) {
          dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] = dfdy_[i_ - 1 + ((*matdim_)) * ((j_ - 1))] + a_[i_ - 1 + ((*matdim_)) * ((j_ 
          - 1))];
        }
      }
    }
    (void) _sgbfa (dfdy_, matdim_, n_, ml_, mu_, ipvt_, &info_);
    if (info_ != 0) {
      (*ier_) = TRUE;
    }
  }
  else if ((*miter_) == 3) {
    iflag_ = 1;
    (void) _users (y_, &yh_[0 + ((*n_)) * ((1))], ywt_, save1_, save2_, t_, h_, &el_[0 + (13) * (((*nq_) - 1))], impl_, n_, 
    nde_, &iflag_);
    if (iflag_ == -1) {
      (*ier_) = TRUE;
      goto _l0;
    }
    if ((*n_) == 0) {
      (*jstate_) = 10;
      goto _l0;
    }
  }
  _l0:;
  __calls[29].calls++;
  return 0;
}

int_4 _sdriv1 (int_4 _p_ n_, real_4 _p_ t_, real_4 _p_ y_, real_4 (*_f)(), real_4 _p_ tout_, int_4 _p_ mstate_, real_4 
_p_ eps_, real_4 _p_ work_, int_4 _p_ lenw_, int_4 _p_ ierflg_)
{
  static int_4 i_, leniw_, lenwcm_, lnwchk_, ml_, mu_, nde_, nstate_, ntask_, iwork_[250];
  static real_4 ewtcom_[1], hmax_;
  static char_15 intgr1_;
  int_4 _data_k_4, __fcnt, __rc, $3_, $11_, $12_, $13_, $14_, $15_;
  char_127 $0_, $4_, $7_;
  char_255 $1_, $2_, $5_, $6_, $8_;
  char_511 $9_, $10_;
  static FORMAT $f_100011_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100040_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
#define _data_n_4 1
  static real_4 _data_l_4[_data_n_4] = {
    1.0e0
  };
  if (__calls[30].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    ewtcom_[0] = _data_l_4[_data_k_4++];
  }
  if (_abs ((*mstate_)) == 0 || _abs ((*mstate_)) > 7) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv1:300", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100011_[__fcnt] != NULL && $f_100011_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100011_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:300", 0));
      __fcnt += 3;
    }
    if ($f_100011_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100011_[__fcnt] != NULL && $f_100011_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100011_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:300", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100011_[__fcnt + 2], &(*mstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:300", 0));
    __fcnt += 3;
    while ($f_100011_[__fcnt] != NULL && $f_100011_[__fcnt] == FMT_TEXT) {
      if ($f_100011_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100011_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:300", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_60, (bufcpy ($2_, concat ($1_, concat ($0_, _dc_2, intgr1_), _dc_3), 255), $2_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  else if (_abs ((*mstate_)) == 7) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_60, _dc_4, ierflg_, ($3_ = 2, &$3_));
    goto _l0;
  }
  if ((*n_) > 200) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv1:314", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:314", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:314", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:314", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:314", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 21;
    (void) _xermsg (_dc_0, _dc_60, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_5, intgr1_), _dc_6), 255), $6_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  if ((*mstate_) > 0) {
    nstate_ = (*mstate_);
    ntask_ = 1;
  }
  else {
    nstate_ = -(*mstate_);
    ntask_ = 3;
  }
  hmax_ = 2.0e0 * _abs ((*tout_) - (*t_));
  leniw_ = (*n_) + 50;
  lenwcm_ = (*lenw_) - leniw_;
  if (lenwcm_ < ((*n_) * (*n_) + 10 * (*n_) + 250)) {
    lnwchk_ = (*n_) * (*n_) + 10 * (*n_) + 250 + leniw_;
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv1:334", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:334", 0));
      __fcnt += 3;
    }
    if ($f_100040_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:334", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100040_[__fcnt + 2], &lnwchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:334", 0));
    __fcnt += 3;
    while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
      if ($f_100040_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv1:334", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 32;
    (void) _xermsg (_dc_0, _dc_60, (bufcpy ($10_, concat ($9_, concat ($8_, concat ($7_, _dc_7, _dc_8), intgr1_), _dc_9), 
    511), $10_), ierflg_, &_k1);
    (*mstate_) = _sign (7, (*mstate_));
    goto _l0;
  }
  if (nstate_ != 1) {
    for (i_ = 1; i_ <= leniw_; (i_)++) {
      iwork_[i_ - 1] = work_[i_ + lenwcm_ - 1];
    }
  }
  (void) _sdriv3 (n_, t_, y_, _f, &nstate_, tout_, &ntask_, &_k0, eps_, ewtcom_, ($11_ = 2, &$11_), ($12_ = 2, &$12_), 
  ($13_ = 2, &$13_), &_k0, &ml_, &mu_, ($14_ = 5, &$14_), &hmax_, work_, &lenwcm_, iwork_, &leniw_, _f, _f, &nde_, ($15_ 
  = 1000, &$15_), _f, _f, ierflg_);
  for (i_ = 1; i_ <= leniw_; (i_)++) {
    work_[i_ + lenwcm_ - 1] = iwork_[i_ - 1];
  }
  if (nstate_ <= 4) {
    (*mstate_) = _sign (nstate_, (*mstate_));
  }
  else if (nstate_ == 6) {
    (*mstate_) = _sign (5, (*mstate_));
  }
  else if ((*ierflg_) == 11) {
    (*mstate_) = _sign (6, (*mstate_));
  }
  else if ((*ierflg_) > 11) {
    (*mstate_) = _sign (7, (*mstate_));
  }
  _l0:;
  __calls[30].calls++;
  return 0;
}

int_4 _sdriv2 (int_4 _p_ n_, real_4 _p_ t_, real_4 _p_ y_, real_4 (*_f)(), real_4 _p_ tout_, int_4 _p_ mstate_, int_4 
_p_ nroot_, real_4 _p_ eps_, real_4 _p_ ewt_, int_4 _p_ mint_, real_4 _p_ work_, int_4 _p_ lenw_, int_4 _p_ iwork_, 
int_4 _p_ leniw_, real_4 (*_g)(), int_4 _p_ ierflg_)
{
  static int_4 ierror_, miter_, ml_, mu_, mxord_, nde_, nstate_, ntask_;
  static real_4 ewtcom_[1], hmax_;
  static char_15 intgr1_;
  int_4 $0_, __fcnt, __rc, $8_;
  char_127 $1_, $4_;
  char_255 $2_, $3_, $5_;
  char_511 $6_, $7_;
  static FORMAT $f_100013_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100020_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if (_abs ((*mstate_)) == 9) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_61, _dc_11, ierflg_, ($0_ = 2, &$0_));
    goto _l0;
  }
  else if (_abs ((*mstate_)) == 0 || _abs ((*mstate_)) > 9) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv2:356", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100013_[__fcnt] != NULL && $f_100013_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100013_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv2:356", 0));
      __fcnt += 3;
    }
    if ($f_100013_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100013_[__fcnt] != NULL && $f_100013_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100013_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv2:356", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100013_[__fcnt + 2], &(*mstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv2:356", 0));
    __fcnt += 3;
    while ($f_100013_[__fcnt] != NULL && $f_100013_[__fcnt] == FMT_TEXT) {
      if ($f_100013_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100013_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv2:356", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_61, (bufcpy ($3_, concat ($2_, concat ($1_, _dc_2, intgr1_), _dc_12), 255), $3_), ierflg_, 
    &_k1);
    (*mstate_) = _sign (9, (*mstate_));
    goto _l0;
  }
  if ((*mint_) < 1 || (*mint_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv2:365", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv2:365", 0));
      __fcnt += 3;
    }
    if ($f_100020_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv2:365", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100020_[__fcnt + 2], &(*mint_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv2:365", 0));
    __fcnt += 3;
    while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
      if ($f_100020_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv2:365", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 23;
    (void) _xermsg (_dc_0, _dc_61, (bufcpy ($7_, concat ($6_, concat ($5_, concat ($4_, _dc_13, _dc_14), intgr1_), _dc_9), 
    511), $7_), ierflg_, &_k1);
    (*mstate_) = _sign (9, (*mstate_));
    goto _l0;
  }
  if ((*mstate_) >= 0) {
    nstate_ = (*mstate_);
    ntask_ = 1;
  }
  else {
    nstate_ = -(*mstate_);
    ntask_ = 3;
  }
  ewtcom_[0] = (*ewt_);
  if ((*ewt_) != 0.0e0) {
    ierror_ = 3;
  }
  else {
    ierror_ = 2;
  }
  if ((*mint_) == 1) {
    miter_ = 0;
    mxord_ = 12;
  }
  else if ((*mint_) == 2) {
    miter_ = 2;
    mxord_ = 5;
  }
  else if ((*mint_) == 3) {
    miter_ = 2;
    mxord_ = 12;
  }
  hmax_ = 2.0e0 * _abs ((*tout_) - (*t_));
  (void) _sdriv3 (n_, t_, y_, _f, &nstate_, tout_, &ntask_, nroot_, eps_, ewtcom_, &ierror_, mint_, &miter_, &_k0, &ml_, 
  &mu_, &mxord_, &hmax_, work_, lenw_, iwork_, leniw_, _f, _f, &nde_, ($8_ = 1000, &$8_), _g, _f, ierflg_);
  if (nstate_ <= 7) {
    (*mstate_) = _sign (nstate_, (*mstate_));
  }
  else if (nstate_ == 11) {
    (*mstate_) = _sign (8, (*mstate_));
  }
  else if (nstate_ > 11) {
    (*mstate_) = _sign (9, (*mstate_));
  }
  _l0:;
  __calls[31].calls++;
  return 0;
}

int_4 _sdriv3 (int_4 _p_ n_, real_4 _p_ t_, real_4 _p_ y_, int_4 (*_f)(), int_4 _p_ nstate_, real_4 _p_ tout_, int_4 
_p_ ntask_, int_4 _p_ nroot_, real_4 _p_ eps_, real_4 _p_ ewt_, int_4 _p_ ierror_, int_4 _p_ mint_, int_4 _p_ miter_, 
int_4 _p_ impl_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ mxord_, real_4 _p_ hmax_, real_4 _p_ work_, int_4 _p_ lenw_, 
int_4 _p_ iwork_, int_4 _p_ leniw_, int_4 (*_jacobn)(), int_4 (*_fa)(), int_4 _p_ nde_, int_4 _p_ mxstep_, real_4 
(*_g)(), int_4 (*_users)(), int_4 _p_ ierflg_)
{
  static int_4 i_, ia_, idfdy_, ifac_, iflag_, ignow_, imxerr_, info_, iroot_, isave1_, isave2_, itroot_, iywt_, j_, 
  jstate_, jtroot_, lenchk_, liwchk_, matdim_, maxord_, ndecom_, npar_, nstepl_;
  static logical_4 convrg_;
  static real_4 ae_, big_, glast_, gnow_, h_, hsign_, hused_, re_, size_, sum_, tlast_, troot_, uround_;
  static char_15 intgr1_, intgr2_;
  static char_31 rl1_, rl2_;
  int_4 $0_, __fcnt, __rc, $44_;
  char_63 $4_, $10_, $57_, $64_, $72_, $80_, $84_, $89_;
  char_127 $1_, $5_, $6_, $7_, $11_, $12_, $13_, $17_, $20_, $23_, $28_, $31_, $34_, $39_, $45_, $51_, $58_, $65_, $73_, 
  $81_, $85_, $90_, $91_;
  char_255 $2_, $3_, $8_, $9_, $14_, $18_, $19_, $21_, $22_, $24_, $29_, $30_, $32_, $33_, $35_, $40_, $46_, $52_, $59_, 
  $66_, $74_, $82_, $83_, $86_;
  char_511 $15_, $16_, $25_, $36_, $41_, $47_, $53_, $60_, $67_, $75_, $87_, $88_;
  char_1023 $26_, $27_, $37_, $38_, $42_, $43_, $48_, $54_, $61_, $68_, $76_;
  char_2047 $49_, $50_, $55_, $56_, $62_, $63_, $69_, $77_;
  char_4095 $70_, $71_, $78_, $79_;
  extern real_4 _r1mach ();
  extern real_4 _snrm2 ();
  static FORMAT $f_100014_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100029_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100036_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100043_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100049_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100055_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100061_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100062_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100068_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100074_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100086_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100129_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100280_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100281_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100311_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100312_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100460_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100461_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100470_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100471_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100478_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100479_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100480_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100614_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100619_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  static FORMAT $f_100624_[] = {
    FMT_REAL,"%16e","%16.8.0E",
    NULL, NULL, NULL
  };
  if ((*nstate_) == 12) {
    (*ierflg_) = 999;
    (void) _xermsg (_dc_0, _dc_62, _dc_16, ierflg_, ($0_ = 2, &$0_));
    goto _l0;
  }
  else if ((*nstate_) < 1 || (*nstate_) > 12) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:757", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:757", 0));
      __fcnt += 3;
    }
    if ($f_100014_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:757", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100014_[__fcnt + 2], &(*nstate_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:757", 0));
    __fcnt += 3;
    while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
      if ($f_100014_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:757", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 26;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($3_, concat ($2_, concat ($1_, _dc_17, intgr1_), _dc_18), 255), $3_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  npar_ = (*n_);
  if ((*eps_) < 0.0e0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:767", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:767", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:767", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*eps_), REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:767", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:767", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 27;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_19, rl1_), _dc_20), 127), $6_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*n_) <= 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:775", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:775", 0));
      __fcnt += 3;
    }
    if ($f_100029_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:775", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100029_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:775", 0));
    __fcnt += 3;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      if ($f_100029_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:775", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 22;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($9_, concat ($8_, concat ($7_, _dc_21, intgr1_), _dc_22), 255), $9_), ierflg_, 
    &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mxord_) <= 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:784", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:784", 0));
      __fcnt += 3;
    }
    if ($f_100036_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:784", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100036_[__fcnt + 2], &(*mxord_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:784", 0));
    __fcnt += 3;
    while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
      if ($f_100036_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:784", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 28;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($12_, concat ($11_, concat ($10_, _dc_23, intgr1_), _dc_22), 127), $12_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mint_) < 1 || (*mint_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:793", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:793", 0));
      __fcnt += 3;
    }
    if ($f_100043_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:793", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100043_[__fcnt + 2], &(*mint_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:793", 0));
    __fcnt += 3;
    while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
      if ($f_100043_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:793", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 23;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($16_, concat ($15_, concat ($14_, concat ($13_, _dc_13, _dc_14), intgr1_), 
    _dc_9), 511), $16_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*miter_) < 0 || (*miter_) > 5) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:801", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:801", 0));
      __fcnt += 3;
    }
    if ($f_100049_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:801", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100049_[__fcnt + 2], &(*miter_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:801", 0));
    __fcnt += 3;
    while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
      if ($f_100049_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:801", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 24;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($19_, concat ($18_, concat ($17_, _dc_24, intgr1_), _dc_18), 255), $19_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*impl_) < 0 || (*impl_) > 3) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:809", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:809", 0));
      __fcnt += 3;
    }
    if ($f_100055_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:809", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100055_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:809", 0));
    __fcnt += 3;
    while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
      if ($f_100055_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:809", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 25;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($22_, concat ($21_, concat ($20_, _dc_25, intgr1_), _dc_18), 255), $22_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if ((*mint_) == 3 && ((*miter_) == 0 || (*miter_) == 3 || (*impl_) != 0)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:818", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:818", 0));
      __fcnt += 3;
    }
    if ($f_100061_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:818", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100061_[__fcnt + 2], &(*miter_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:818", 0));
    __fcnt += 3;
    while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
      if ($f_100061_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:818", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:819", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:819", 0));
      __fcnt += 3;
    }
    if ($f_100062_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:819", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100062_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:819", 0));
    __fcnt += 3;
    while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
      if ($f_100062_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:819", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 29;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($27_, concat ($26_, concat ($25_, concat ($24_, concat ($23_, _dc_26, intgr1_), 
    _dc_27), intgr2_), _dc_28), 1023), $27_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if (((*impl_) >= 1 && (*impl_) <= 3) && (*miter_) == 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:827", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100068_[__fcnt] != NULL && $f_100068_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100068_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:827", 0));
      __fcnt += 3;
    }
    if ($f_100068_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100068_[__fcnt] != NULL && $f_100068_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100068_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:827", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100068_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:827", 0));
    __fcnt += 3;
    while ($f_100068_[__fcnt] != NULL && $f_100068_[__fcnt] == FMT_TEXT) {
      if ($f_100068_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100068_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:827", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 30;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($30_, concat ($29_, concat ($28_, _dc_29, intgr1_), _dc_28), 255), $30_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  else if (((*impl_) == 2 || (*impl_) == 3) && (*mint_) == 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:835", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:835", 0));
      __fcnt += 3;
    }
    if ($f_100074_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:835", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100074_[__fcnt + 2], &(*impl_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:835", 0));
    __fcnt += 3;
    while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
      if ($f_100074_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:835", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 31;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($33_, concat ($32_, concat ($31_, _dc_30, intgr1_), _dc_28), 255), $33_), 
    ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*miter_) == 0 || (*miter_) == 3) {
    liwchk_ = 50;
  }
  else if ((*miter_) == 1 || (*miter_) == 2 || (*miter_) == 4 || (*miter_) == 5) {
    liwchk_ = 51 + (*n_) - 1;
  }
  if ((*leniw_) < liwchk_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:850", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:850", 0));
      __fcnt += 3;
    }
    if ($f_100086_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:850", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100086_[__fcnt + 2], &liwchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:850", 0));
    __fcnt += 3;
    while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
      if ($f_100086_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:850", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 33;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($38_, concat ($37_, concat ($36_, concat ($35_, concat ($34_, _dc_31, _dc_32), 
    _dc_33), intgr1_), _dc_9), 1023), $38_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*mint_) == 1 || (*mint_) == 3) {
    maxord_ = _min ((*mxord_), 12);
  }
  else if ((*mint_) == 2) {
    maxord_ = _min ((*mxord_), 5);
  }
  idfdy_ = 251 + (maxord_ + 1) * (*n_);
  if ((*miter_) == 0 || (*miter_) == 3) {
    iywt_ = idfdy_;
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    iywt_ = idfdy_ + (*n_) * (*n_);
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    iywt_ = idfdy_ + (2 * (*ml_) + (*mu_) + 1) * (*n_);
  }
  isave1_ = iywt_ + (*n_);
  isave2_ = isave1_ + (*n_);
  ignow_ = isave2_ + (*n_);
  itroot_ = ignow_ + (*nroot_);
  ifac_ = itroot_ + (*nroot_);
  if ((*miter_) == 2 || (*miter_) == 5 || (*mint_) == 3) {
    ia_ = ifac_ + (*n_);
  }
  else {
    ia_ = ifac_;
  }
  if ((*impl_) == 0 || (*miter_) == 3) {
    lenchk_ = ia_ - 1;
  }
  else if ((*impl_) == 1 && ((*miter_) == 1 || (*miter_) == 2)) {
    lenchk_ = ia_ - 1 + (*n_) * (*n_);
  }
  else if ((*impl_) == 1 && ((*miter_) == 4 || (*miter_) == 5)) {
    lenchk_ = ia_ - 1 + (2 * (*ml_) + (*mu_) + 1) * (*n_);
  }
  else if ((*impl_) == 2 && (*miter_) != 3) {
    lenchk_ = ia_ - 1 + (*n_);
  }
  else if ((*impl_) == 3 && ((*miter_) == 1 || (*miter_) == 2)) {
    lenchk_ = ia_ - 1 + (*n_) * (*nde_);
  }
  else if ((*impl_) == 3 && ((*miter_) == 4 || (*miter_) == 5)) {
    lenchk_ = ia_ - 1 + (2 * (*ml_) + (*mu_) + 1) * (*nde_);
  }
  if ((*lenw_) < lenchk_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (intgr1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:907", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100129_[__fcnt] != NULL && $f_100129_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100129_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:907", 0));
      __fcnt += 3;
    }
    if ($f_100129_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100129_[__fcnt] != NULL && $f_100129_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100129_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:907", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100129_[__fcnt + 2], &lenchk_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:907", 0));
    __fcnt += 3;
    while ($f_100129_[__fcnt] != NULL && $f_100129_[__fcnt] == FMT_TEXT) {
      if ($f_100129_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100129_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:907", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 32;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($43_, concat ($42_, concat ($41_, concat ($40_, concat ($39_, _dc_31, _dc_34), 
    _dc_33), intgr1_), _dc_9), 1023), $43_), ierflg_, &_k1);
    (*nstate_) = 12;
    goto _l0;
  }
  if ((*miter_) == 0 || (*miter_) == 3) {
    matdim_ = 1;
  }
  else if ((*miter_) == 1 || (*miter_) == 2) {
    matdim_ = (*n_);
  }
  else if ((*miter_) == 4 || (*miter_) == 5) {
    matdim_ = 2 * (*ml_) + (*mu_) + 1;
  }
  if ((*impl_) == 0 || (*impl_) == 1) {
    ndecom_ = (*n_);
  }
  else if ((*impl_) == 2 || (*impl_) == 3) {
    ndecom_ = (*nde_);
  }
  if ((*nstate_) == 1) {
    if ((*mint_) == 1 || (*mint_) == 3) {
      iwork_[19] = _min ((*mxord_), 12);
    }
    else if ((*mint_) == 2) {
      iwork_[19] = _min ((*mxord_), 5);
    }
    iwork_[18] = (*mxord_);
    if ((*mint_) == 1 || (*mint_) == 2) {
      iwork_[15] = (*mint_);
      iwork_[17] = (*miter_);
      iwork_[9] = (*mint_);
      iwork_[10] = (*miter_);
    }
    else if ((*mint_) == 3) {
      iwork_[15] = 1;
      iwork_[17] = 0;
      iwork_[9] = iwork_[15];
      iwork_[10] = iwork_[17];
      iwork_[16] = (*miter_);
    }
    work_[160] = (*hmax_);
    uround_ = _r1mach (($44_ = 4, &$44_));
    work_[205] = uround_;
    work_[204] = _r1mach (&_k1);
    if ((*nroot_) != 0) {
      re_ = uround_;
      ae_ = work_[204];
    }
    h_ = ((*tout_) - (*t_)) * (1.0e0 - 4.0e0 * uround_);
    h_ = _sign (_min (_abs (h_), (*hmax_)), h_);
    work_[159] = h_;
    hsign_ = _sign (1.0, h_);
    work_[162] = hsign_;
    iwork_[8] = 0;
    work_[0] = 0.0;
    work_[1] = 0.0;
    work_[2] = 0.0;
    iwork_[0] = 0;
    iwork_[1] = 0;
    iwork_[2] = 0;
    iwork_[21] = 0;
    iwork_[3] = 0;
    iwork_[4] = 0;
    iwork_[5] = 0;
    work_[165] = (*t_);
    iwork_[6] = 0;
    iwork_[20] = 0;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + 251 - 1 - 1] = y_[i_ - 1];
    }
    if ((*t_) == (*tout_)) {
      goto _l0;
    }
    goto _l180;
  }
  else {
    uround_ = work_[205];
    if ((*nroot_) != 0) {
      re_ = uround_;
      ae_ = work_[204];
    }
  }
  if (iwork_[6] == 1) {
    convrg_ = TRUE;
  }
  else {
    convrg_ = FALSE;
  }
  (*t_) = work_[165];
  h_ = work_[159];
  hsign_ = work_[162];
  if (iwork_[8] == 0) {
    goto _l180;
  }
  if ((*nroot_) != 0) {
    if (iwork_[7] > 0) {
      if ((*nstate_) != 5) {
        if ((*tout_) * hsign_ >= work_[166] * hsign_) {
          troot_ = work_[166];
          (void) _sdntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
          (*t_) = troot_;
          (*nstate_) = 5;
          (*ierflg_) = 0;
          goto _l580;
        }
      }
      else {
        troot_ = (*t_);
        iroot_ = 0;
        for (i_ = 1; i_ <= iwork_[12]; (i_)++) {
          jtroot_ = i_ + iwork_[13] - 1;
          if (work_[jtroot_ - 1] * hsign_ <= troot_ * hsign_) {
            if (work_[jtroot_ - 1] == work_[166] && i_ > iwork_[5]) {
              iroot_ = i_;
              troot_ = work_[jtroot_ - 1];
              goto _l60;
            }
            if (work_[jtroot_ - 1] * hsign_ > work_[166] * hsign_) {
              iroot_ = i_;
              troot_ = work_[jtroot_ - 1];
            }
          }
        }
        _l60:;
        iwork_[5] = iroot_;
        work_[166] = troot_;
        iwork_[7] = (*ntask_);
        if ((*ntask_) == 1) {
          if (iroot_ == 0) {
            iwork_[7] = 0;
          }
          else {
            if ((*tout_) * hsign_ >= troot_ * hsign_) {
              (void) _sdntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
              (*nstate_) = 5;
              (*t_) = troot_;
              (*ierflg_) = 0;
              goto _l580;
            }
          }
        }
        else if ((*ntask_) == 2 || (*ntask_) == 3) {
          if (iroot_ == 0 || ((*tout_) * hsign_ < troot_ * hsign_)) {
            iwork_[7] = 0;
          }
          else {
            (void) _sdntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
            (*nstate_) = 5;
            (*ierflg_) = 0;
            (*t_) = troot_;
            goto _l580;
          }
        }
      }
    }
  }
  if ((*ntask_) == 1) {
    (*nstate_) = 2;
    if ((*t_) * hsign_ >= (*tout_) * hsign_) {
      (void) _sdntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      (*ierflg_) = 0;
      goto _l580;
    }
  }
  else if ((*ntask_) == 2) {
    if ((*t_) * hsign_ > (*tout_) * hsign_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:sdriv3:1097", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100280_[__fcnt] != NULL && $f_100280_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100280_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1097", 0));
        __fcnt += 3;
      }
      if ($f_100280_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100280_[__fcnt] != NULL && $f_100280_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100280_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1097", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100280_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1097", 0));
      __fcnt += 3;
      while ($f_100280_[__fcnt] != NULL && $f_100280_[__fcnt] == FMT_TEXT) {
        if ($f_100280_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100280_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1097", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:sdriv3:1098", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100281_[__fcnt] != NULL && $f_100281_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100281_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1098", 0));
        __fcnt += 3;
      }
      if ($f_100281_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100281_[__fcnt] != NULL && $f_100281_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100281_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1098", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100281_[__fcnt + 2], &(*tout_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1098", 0));
      __fcnt += 3;
      while ($f_100281_[__fcnt] != NULL && $f_100281_[__fcnt] == FMT_TEXT) {
        if ($f_100281_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100281_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1098", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 11;
      (void) _xermsg (_dc_0, _dc_62, (bufcpy ($50_, concat ($49_, concat ($48_, concat ($47_, concat ($46_, concat ($45_, 
      _dc_35, rl1_), _dc_36), rl2_), _dc_37), _dc_38), 2047), $50_), ierflg_, &_k0);
      (*nstate_) = 11;
      (void) _sdntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      goto _l580;
    }
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
      (*nstate_) = 2;
      (*ierflg_) = 0;
      goto _l560;
    }
    if ((*nstate_) == 5) {
      (*nstate_) = 2;
      (*ierflg_) = 0;
      goto _l560;
    }
    (*nstate_) = 2;
    if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
      h_ = (*tout_) - (*t_);
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = h_ * (1.0e0 - 4.0e0 * uround_);
      }
      work_[159] = h_;
      if (h_ == 0.0e0) {
        goto _l670;
      }
      iwork_[8] = -1;
    }
  }
  else if ((*ntask_) == 3) {
    (*nstate_) = 2;
    if ((*t_) * hsign_ > (*tout_) * hsign_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:sdriv3:1137", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100311_[__fcnt] != NULL && $f_100311_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100311_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1137", 0));
        __fcnt += 3;
      }
      if ($f_100311_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100311_[__fcnt] != NULL && $f_100311_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100311_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1137", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100311_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1137", 0));
      __fcnt += 3;
      while ($f_100311_[__fcnt] != NULL && $f_100311_[__fcnt] == FMT_TEXT) {
        if ($f_100311_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100311_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1137", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:sdriv3:1138", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100312_[__fcnt] != NULL && $f_100312_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100312_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1138", 0));
        __fcnt += 3;
      }
      if ($f_100312_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100312_[__fcnt] != NULL && $f_100312_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100312_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1138", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100312_[__fcnt + 2], &(*tout_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1138", 0));
      __fcnt += 3;
      while ($f_100312_[__fcnt] != NULL && $f_100312_[__fcnt] == FMT_TEXT) {
        if ($f_100312_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100312_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1138", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 11;
      (void) _xermsg (_dc_0, _dc_62, (bufcpy ($56_, concat ($55_, concat ($54_, concat ($53_, concat ($52_, concat ($51_, 
      _dc_35, rl1_), _dc_36), rl2_), _dc_37), _dc_38), 2047), $56_), ierflg_, &_k0);
      (*nstate_) = 11;
      (void) _sdntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
      (*t_) = (*tout_);
      goto _l580;
    }
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
      (*ierflg_) = 0;
      goto _l560;
    }
    if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
      h_ = (*tout_) - (*t_);
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = h_ * (1.0e0 - 4.0e0 * uround_);
      }
      work_[159] = h_;
      if (h_ == 0.0e0) {
        goto _l670;
      }
      iwork_[8] = -1;
    }
  }
  if (((*mint_) != iwork_[9] || (*miter_) != iwork_[10]) && (*mint_) != 3 && iwork_[9] != 3) {
    iwork_[8] = -1;
  }
  if ((*hmax_) != work_[160]) {
    h_ = _sign (_min (_abs (h_), (*hmax_)), h_);
    if (h_ != work_[159]) {
      iwork_[8] = -1;
      work_[159] = h_;
    }
    work_[160] = (*hmax_);
  }
  _l180:;
  nstepl_ = iwork_[2];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = work_[i_ + 251 - 1 - 1];
  }
  if ((*nroot_) != 0) {
    for (i_ = 1; i_ <= (*nroot_); (i_)++) {
      work_[i_ + ignow_ - 1 - 1] = _g (&npar_, t_, y_, &i_);
      if (npar_ == 0) {
        iwork_[5] = i_;
        (*nstate_) = 7;
        goto _l0;
      }
    }
  }
  if ((*ierror_) == 1) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = 1.0;
    }
    goto _l410;
  }
  else if ((*ierror_) == 5) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = ewt_[i_ - 1];
    }
    goto _l410;
  }
  _l260:;
  if ((*ierror_) == 2) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      if (y_[i_ - 1] == 0.0e0) {
        goto _l290;
      }
      work_[i_ + iywt_ - 1 - 1] = _abs (y_[i_ - 1]);
    }
    goto _l410;
    _l290:;
    if (iwork_[8] == 0) {
      (void) _f (&npar_, t_, y_, &work_[isave2_ - 1]);
      if (npar_ == 0) {
        (*nstate_) = 6;
        goto _l0;
      }
      iwork_[3] = iwork_[3] + 1;
      if ((*miter_) == 3 && (*impl_) != 0) {
        iflag_ = 0;
        (void) _users (y_, &work_[250], &work_[iywt_ - 1], &work_[isave1_ - 1], &work_[isave2_ - 1], t_, &h_, &work_[3], impl_, 
        &npar_, &ndecom_, &iflag_);
        if (iflag_ == -1) {
          goto _l690;
        }
        if (npar_ == 0) {
          (*nstate_) = 10;
          goto _l0;
        }
      }
      else if ((*impl_) == 1) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _sgefa (&work_[ia_ - 1], &matdim_, n_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _sgesl (&work_[ia_ - 1], &matdim_, n_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ + (*ml_) - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _sgbfa (&work_[ia_ - 1], &matdim_, n_, ml_, mu_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _sgbsl (&work_[ia_ - 1], &matdim_, n_, ml_, mu_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
      }
      else if ((*impl_) == 2) {
        (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
        if (npar_ == 0) {
          (*nstate_) = 9;
          goto _l0;
        }
        for (i_ = 1; i_ <= ndecom_; (i_)++) {
          if (work_[i_ + ia_ - 1 - 1] == 0.0e0) {
            goto _l690;
          }
          work_[i_ + isave2_ - 1 - 1] = work_[i_ + isave2_ - 1 - 1] / work_[i_ + ia_ - 1 - 1];
        }
      }
      else if ((*impl_) == 3) {
        if ((*miter_) == 1 || (*miter_) == 2) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _sgefa (&work_[ia_ - 1], &matdim_, nde_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _sgesl (&work_[ia_ - 1], &matdim_, nde_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
        else if ((*miter_) == 4 || (*miter_) == 5) {
          (void) _fa (&npar_, t_, y_, &work_[ia_ + (*ml_) - 1], &matdim_, ml_, mu_, &ndecom_);
          if (npar_ == 0) {
            (*nstate_) = 9;
            goto _l0;
          }
          (void) _sgbfa (&work_[ia_ - 1], &matdim_, nde_, ml_, mu_, &iwork_[50], &info_);
          if (info_ != 0) {
            goto _l690;
          }
          (void) _sgbsl (&work_[ia_ - 1], &matdim_, nde_, ml_, mu_, &iwork_[50], &work_[isave2_ - 1], &_k0);
        }
      }
    }
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      if (y_[j_ - 1] != 0.0e0) {
        work_[j_ + iywt_ - 1 - 1] = _abs (y_[j_ - 1]);
      }
      else {
        if (iwork_[8] == 0) {
          work_[j_ + iywt_ - 1 - 1] = _abs (h_ * work_[j_ + isave2_ - 1 - 1]);
        }
        else {
          work_[j_ + iywt_ - 1 - 1] = _abs (work_[j_ + 251 + (*n_) - 1 - 1]);
        }
      }
      if (work_[j_ + iywt_ - 1 - 1] == 0.0e0) {
        work_[j_ + iywt_ - 1 - 1] = uround_;
      }
    }
  }
  else if ((*ierror_) == 3) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = _max (ewt_[0], _abs (y_[i_ - 1]));
    }
  }
  else if ((*ierror_) == 4) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      work_[i_ + iywt_ - 1 - 1] = _max (ewt_[i_ - 1], _abs (y_[i_ - 1]));
    }
  }
  _l410:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    work_[i_ + isave2_ - 1 - 1] = y_[i_ - 1] / work_[i_ + iywt_ - 1 - 1];
  }
  sum_ = _snrm2 (n_, &work_[isave2_ - 1], &_k1) / sqrtf ((real_4) ((*n_)));
  sum_ = _max (1.0, sum_);
  if ((*eps_) < sum_ * uround_) {
    (*eps_) = sum_ * uround_ * (1.0e0 + 10.0e0 * uround_);
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:1303", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100460_[__fcnt] != NULL && $f_100460_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100460_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1303", 0));
      __fcnt += 3;
    }
    if ($f_100460_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100460_[__fcnt] != NULL && $f_100460_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100460_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1303", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100460_[__fcnt + 2], &(*t_), REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1303", 0));
    __fcnt += 3;
    while ($f_100460_[__fcnt] != NULL && $f_100460_[__fcnt] == FMT_TEXT) {
      if ($f_100460_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100460_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1303", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl2_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:1304", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100461_[__fcnt] != NULL && $f_100461_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100461_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1304", 0));
      __fcnt += 3;
    }
    if ($f_100461_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100461_[__fcnt] != NULL && $f_100461_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100461_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1304", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100461_[__fcnt + 2], &(*eps_), REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1304", 0));
    __fcnt += 3;
    while ($f_100461_[__fcnt] != NULL && $f_100461_[__fcnt] == FMT_TEXT) {
      if ($f_100461_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100461_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1304", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 4;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($63_, concat ($62_, concat ($61_, concat ($60_, concat ($59_, concat ($58_, 
    concat ($57_, _dc_39, rl1_), _dc_40), _dc_41), _dc_42), rl2_), _dc_9), 2047), $63_), ierflg_, &_k0);
    (*nstate_) = 4;
    goto _l560;
  }
  if (_abs (h_) >= uround_ * _abs ((*t_))) {
    iwork_[20] = 0;
  }
  else if (iwork_[20] == 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl1_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:1316", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100470_[__fcnt] != NULL && $f_100470_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100470_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1316", 0));
      __fcnt += 3;
    }
    if ($f_100470_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100470_[__fcnt] != NULL && $f_100470_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100470_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1316", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100470_[__fcnt + 2], &(*t_), REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1316", 0));
    __fcnt += 3;
    while ($f_100470_[__fcnt] != NULL && $f_100470_[__fcnt] == FMT_TEXT) {
      if ($f_100470_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100470_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1316", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
    _ffile[0].lrecl = 31;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (rl2_, 31, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec-sdrive:sdriv3:1317", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100471_[__fcnt] != NULL && $f_100471_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100471_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1317", 0));
      __fcnt += 3;
    }
    if ($f_100471_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100471_[__fcnt] != NULL && $f_100471_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100471_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1317", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100471_[__fcnt + 2], &h_, REAL, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1317", 0));
    __fcnt += 3;
    while ($f_100471_[__fcnt] != NULL && $f_100471_[__fcnt] == FMT_TEXT) {
      if ($f_100471_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100471_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1317", 0));
      __fcnt += 3;
    }
    (*ierflg_) = 15;
    (void) _xermsg (_dc_0, _dc_62, (bufcpy ($71_, concat ($70_, concat ($69_, concat ($68_, concat ($67_, concat ($66_, 
    concat ($65_, concat ($64_, _dc_39, rl1_), _dc_43), rl2_), _dc_44), _dc_45), _dc_46), _dc_47), 4095), $71_), ierflg_, 
    &_k0);
    iwork_[20] = 1;
  }
  if ((*ntask_) != 2) {
    if ((iwork_[2] - nstepl_) == (*mxstep_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl1_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:sdriv3:1328", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100478_[__fcnt] != NULL && $f_100478_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100478_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1328", 0));
        __fcnt += 3;
      }
      if ($f_100478_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100478_[__fcnt] != NULL && $f_100478_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100478_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1328", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100478_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1328", 0));
      __fcnt += 3;
      while ($f_100478_[__fcnt] != NULL && $f_100478_[__fcnt] == FMT_TEXT) {
        if ($f_100478_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100478_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1328", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (intgr1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (intgr1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:sdriv3:1329", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100479_[__fcnt] != NULL && $f_100479_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100479_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1329", 0));
        __fcnt += 3;
      }
      if ($f_100479_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100479_[__fcnt] != NULL && $f_100479_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100479_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1329", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100479_[__fcnt + 2], &(*mxstep_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1329", 0));
      __fcnt += 3;
      while ($f_100479_[__fcnt] != NULL && $f_100479_[__fcnt] == FMT_TEXT) {
        if ($f_100479_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100479_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1329", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (rl2_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (rl2_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec-sdrive:sdriv3:1330", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100480_[__fcnt] != NULL && $f_100480_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100480_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1330", 0));
        __fcnt += 3;
      }
      if ($f_100480_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100480_[__fcnt] != NULL && $f_100480_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100480_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1330", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100480_[__fcnt + 2], &(*tout_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1330", 0));
      __fcnt += 3;
      while ($f_100480_[__fcnt] != NULL && $f_100480_[__fcnt] == FMT_TEXT) {
        if ($f_100480_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100480_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1330", 0));
        __fcnt += 3;
      }
      (*ierflg_) = 3;
      (void) _xermsg (_dc_0, _dc_62, (bufcpy ($79_, concat ($78_, concat ($77_, concat ($76_, concat ($75_, concat ($74_, 
      concat ($73_, concat ($72_, _dc_39, rl1_), _dc_48), intgr1_), _dc_49), _dc_50), rl2_), _dc_9), 4095), $79_), ierflg_, 
      &_k0);
      (*nstate_) = 3;
      goto _l560;
    }
  }
  (void) _sdstp (eps_, _f, _fa, &work_[160], impl_, ierror_, _jacobn, &matdim_, &iwork_[19], &iwork_[15], &iwork_[17], 
  ml_, mu_, &npar_, &ndecom_, &work_[iywt_ - 1], &uround_, _users, &work_[0], &work_[2], &work_[159], &hused_, 
  &iwork_[8], &iwork_[9], &iwork_[10], &iwork_[3], &iwork_[4], &iwork_[1], &iwork_[2], &work_[165], y_, &work_[250], 
  &work_[ia_ - 1], &convrg_, &work_[idfdy_ - 1], &work_[3], &work_[ifac_ - 1], &work_[161], &iwork_[50], &jstate_, 
  &iwork_[21], &iwork_[11], &iwork_[14], &work_[163], &work_[164], &work_[isave1_ - 1], &work_[isave2_ - 1], &work_[167], 
  &work_[203], mint_, &iwork_[16], &iwork_[18]);
  (*t_) = work_[165];
  h_ = work_[159];
  if (convrg_) {
    iwork_[6] = 1;
  }
  else {
    iwork_[6] = 0;
  }
  switch (jstate_) {
    default:
    case 1: goto _l470;
    case 2: goto _l670;
    case 3: goto _l680;
    case 4: goto _l690;
    case 5: goto _l690;
    case 6: goto _l660;
    case 7: goto _l660;
    case 8: goto _l660;
    case 9: goto _l660;
    case 10: goto _l660;
  }
  _l470:;
  iwork_[8] = 1;
  if ((*nroot_) != 0) {
    iroot_ = 0;
    for (i_ = 1; i_ <= (*nroot_); (i_)++) {
      glast_ = work_[i_ + ignow_ - 1 - 1];
      gnow_ = _g (&npar_, t_, y_, &i_);
      if (npar_ == 0) {
        iwork_[5] = i_;
        (*nstate_) = 7;
        goto _l0;
      }
      work_[i_ + ignow_ - 1 - 1] = gnow_;
      if (glast_ * gnow_ > 0.0e0) {
        work_[i_ + itroot_ - 1 - 1] = (*t_) + h_;
      }
      else {
        if (gnow_ == 0.0e0) {
          work_[i_ + itroot_ - 1 - 1] = (*t_);
          iroot_ = i_;
        }
        else {
          if (glast_ == 0.0e0) {
            work_[i_ + itroot_ - 1 - 1] = (*t_) + h_;
          }
          else {
            if (_abs (hused_) >= uround_ * _abs ((*t_))) {
              tlast_ = (*t_) - hused_;
              iroot_ = i_;
              troot_ = (*t_);
              (void) _sdzro (&ae_, _g, &h_, &npar_, &iwork_[11], &iroot_, &re_, t_, &work_[250], &uround_, &troot_, &tlast_, &gnow_, 
              &glast_, y_);
              for (j_ = 1; j_ <= (*n_); (j_)++) {
                y_[j_ - 1] = work_[251 + j_ - 1 - 1];
              }
              if (npar_ == 0) {
                iwork_[5] = i_;
                (*nstate_) = 7;
                goto _l0;
              }
              work_[i_ + itroot_ - 1 - 1] = troot_;
            }
            else {
              work_[i_ + itroot_ - 1 - 1] = (*t_);
              iroot_ = i_;
            }
          }
        }
      }
    }
    if (iroot_ == 0) {
      iwork_[7] = 0;
    }
    else {
      iwork_[7] = (*ntask_);
      iwork_[12] = (*nroot_);
      iwork_[13] = itroot_;
      troot_ = (*t_) + h_;
      for (i_ = 1; i_ <= (*nroot_); (i_)++) {
        if (work_[i_ + itroot_ - 1 - 1] * hsign_ < troot_ * hsign_) {
          troot_ = work_[i_ + itroot_ - 1 - 1];
          iroot_ = i_;
        }
      }
      iwork_[5] = iroot_;
      work_[166] = troot_;
      if (troot_ * hsign_ <= (*tout_) * hsign_) {
        (void) _sdntp (&h_, &_k0, n_, &iwork_[11], t_, &troot_, &work_[250], y_);
        (*nstate_) = 5;
        (*t_) = troot_;
        (*ierflg_) = 0;
        goto _l580;
      }
    }
  }
  (*nstate_) = 2;
  if ((*ntask_) == 1) {
    if ((*t_) * hsign_ < (*tout_) * hsign_) {
      goto _l260;
    }
    (void) _sdntp (&h_, &_k0, n_, &iwork_[11], t_, tout_, &work_[250], y_);
    (*t_) = (*tout_);
    (*ierflg_) = 0;
    goto _l580;
  }
  else if ((*ntask_) == 2) {
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
    }
    else {
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = (*tout_) - (*t_);
        if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
          h_ = h_ * (1.0e0 - 4.0e0 * uround_);
        }
        work_[159] = h_;
        if (h_ == 0.0e0) {
          goto _l670;
        }
        iwork_[8] = -1;
      }
    }
  }
  else if ((*ntask_) == 3) {
    if (_abs ((*tout_) - (*t_)) <= 20.0 * uround_ * _max (_abs ((*t_)), _abs ((*tout_)))) {
      (*t_) = (*tout_);
    }
    else {
      if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
        h_ = (*tout_) - (*t_);
        if (((*t_) + h_) * hsign_ > (*tout_) * hsign_) {
          h_ = h_ * (1.0e0 - 4.0e0 * uround_);
        }
        work_[159] = h_;
        if (h_ == 0.0e0) {
          goto _l670;
        }
        iwork_[8] = -1;
      }
      goto _l260;
    }
  }
  (*ierflg_) = 0;
  _l560:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = work_[i_ + 251 - 1 - 1];
  }
  _l580:;
  if (iwork_[8] == 0) {
    goto _l0;
  }
  big_ = 0.0;
  imxerr_ = 1;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    size_ = _abs (work_[i_ + isave1_ - 1 - 1] / work_[i_ + iywt_ - 1 - 1]);
    if (big_ < size_) {
      big_ = size_;
      imxerr_ = i_;
    }
  }
  iwork_[0] = imxerr_;
  work_[1] = hused_;
  goto _l0;
  _l660:;
  (*nstate_) = jstate_;
  goto _l0;
  _l670:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:sdriv3:1501", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100614_[__fcnt] != NULL && $f_100614_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100614_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1501", 0));
    __fcnt += 3;
  }
  if ($f_100614_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100614_[__fcnt] != NULL && $f_100614_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100614_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1501", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100614_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1501", 0));
  __fcnt += 3;
  while ($f_100614_[__fcnt] != NULL && $f_100614_[__fcnt] == FMT_TEXT) {
    if ($f_100614_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100614_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1501", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 41;
  (void) _xermsg (_dc_0, _dc_62, (bufcpy ($83_, concat ($82_, concat ($81_, concat ($80_, _dc_39, rl1_), _dc_51), 
  _dc_52), 255), $83_), ierflg_, &_k1);
  (*nstate_) = 12;
  goto _l0;
  _l680:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:sdriv3:1510", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100619_[__fcnt] != NULL && $f_100619_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100619_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1510", 0));
    __fcnt += 3;
  }
  if ($f_100619_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100619_[__fcnt] != NULL && $f_100619_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100619_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1510", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100619_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1510", 0));
  __fcnt += 3;
  while ($f_100619_[__fcnt] != NULL && $f_100619_[__fcnt] == FMT_TEXT) {
    if ($f_100619_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100619_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1510", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 42;
  (void) _xermsg (_dc_0, _dc_62, (bufcpy ($88_, concat ($87_, concat ($86_, concat ($85_, concat ($84_, _dc_39, rl1_), 
  _dc_53), _dc_54), _dc_55), 511), $88_), ierflg_, &_k1);
  (*nstate_) = 12;
  goto _l0;
  _l690:;
  _ffile[0].buff = _ffile[0].rewind = (char *) (rl1_);
  _ffile[0].lrecl = 31;
  _ffile[0].record = 0;
  _ffile[0].records = 1;
  _ffile[0].unit = fmemopen (rl1_, 31, "w");
  _ffile[0].buff_init = FALSE;
  _fcheck ("slatec-sdrive:sdriv3:1519", 0, action_write, form_formatted);
  __fcnt = 0;
  while ($f_100624_[__fcnt] != NULL && $f_100624_[__fcnt] == FMT_TEXT) {
    __rc = _vif_printf (0, $f_100624_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1519", 0));
    __fcnt += 3;
  }
  if ($f_100624_[__fcnt] == NULL) {
    __fcnt = 0;
    __rc = fprintf (_ffile[0].unit, "\n");
    while ($f_100624_[__fcnt] != NULL && $f_100624_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100624_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1519", 0));
      __fcnt += 3;
    }
  };
  __rc = _vif_printf (0, $f_100624_[__fcnt + 2], &(*t_), REAL, 4);
  _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1519", 0));
  __fcnt += 3;
  while ($f_100624_[__fcnt] != NULL && $f_100624_[__fcnt] == FMT_TEXT) {
    if ($f_100624_[__fcnt + 2] == FMT_TERM) {
      break;
    }
    __rc = _vif_printf (0, $f_100624_[__fcnt + 2], NULL, NOTYPE, 0);
    _write_err (__rc, 0, _ioerr_write ("slatec-sdrive:sdriv3:1519", 0));
    __fcnt += 3;
  }
  (*ierflg_) = 43;
  (void) _xermsg (_dc_0, _dc_62, (bufcpy ($91_, concat ($90_, concat ($89_, _dc_39, rl1_), _dc_56), 127), $91_), ierflg_, 
  &_k1);
  (*nstate_) = 12;
  _l0:;
  __calls[32].calls++;
  return 0;
}

int_4 _sdscl (real_4 _p_ hmax_, int_4 _p_ n_, int_4 _p_ nq_, real_4 _p_ rmax_, real_4 _p_ h_, real_4 _p_ rc_, real_4 
_p_ rh_, real_4 _p_ yh_)
{
  static int_4 i_, j_;
  static real_4 r1_;
  real_4 $0_, $1_;
  if ((*h_) < 1.0e0) {
    (*rh_) = ($0_ = _min (_abs ((*h_)) * (*rh_), _abs ((*h_)) * (*rmax_)), _min ($0_, (*hmax_))) / _abs ((*h_));
  }
  else {
    (*rh_) = ($1_ = _min ((*rh_), (*rmax_)), _min ($1_, (*hmax_) / _abs ((*h_))));
  }
  r1_ = 1.0;
  for (j_ = 1; j_ <= (*nq_); (j_)++) {
    r1_ = r1_ * (*rh_);
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ + 1 - 1))] * r1_;
    }
  }
  (*h_) = (*h_) * (*rh_);
  (*rc_) = (*rc_) * (*rh_);
  __calls[33].calls++;
  return 0;
}

int_4 _sdstp (real_4 _p_ eps_, int_4 (*_f)(), real_4 (*_fa)(), real_4 _p_ hmax_, int_4 _p_ impl_, int_4 _p_ ierror_, 
int_4 (*_jacobn)(), int_4 _p_ matdim_, int_4 _p_ maxord_, int_4 _p_ mint_, int_4 _p_ miter_, int_4 _p_ ml_, int_4 _p_ 
mu_, int_4 _p_ n_, int_4 _p_ nde_, real_4 _p_ ywt_, real_4 _p_ uround_, real_4 (*_users)(), real_4 _p_ avgh_, real_4 
_p_ avgord_, real_4 _p_ h_, real_4 _p_ hused_, int_4 _p_ jtask_, int_4 _p_ mntold_, int_4 _p_ mtrold_, int_4 _p_ nfe_, 
int_4 _p_ nje_, int_4 _p_ nqused_, int_4 _p_ nstep_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ yh_, real_4 _p_ a_, 
logical_4 _p_ convrg_, real_4 _p_ dfdy_, real_4 _p_ el_, real_4 _p_ fac_, real_4 _p_ hold_, int_4 _p_ ipvt_, int_4 _p_ 
jstate_, int_4 _p_ jstepl_, int_4 _p_ nq_, int_4 _p_ nwait_, real_4 _p_ rc_, real_4 _p_ rmax_, real_4 _p_ save1_, 
real_4 _p_ save2_, real_4 _p_ tq_, real_4 _p_ trend_, int_4 _p_ iswflg_, int_4 _p_ mtrsv_, int_4 _p_ mxrdsv_)
{
  static int_4 i_, iter_, j_, nfail_, nsv_, ntry_;
  static logical_4 evalfa_, evaljc_, ier_, switch_;
  static real_4 bnd_, ctest_, d_, denom_, d1_, erdn_, erup_, etest_, hn_, hs_, numer_, rh_, rh1_, rh2_, rh3_, told_, 
  y0nrm_;
  int_4 _data_k_5;
  extern real_4 _snrm2 ();
#define _data_n_5 1
  static logical_4 _data_l_5[_data_n_5] = {
    FALSE
  };
  if (__calls[34].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    ier_ = _data_l_5[_data_k_5++];
  }
  nsv_ = (*n_);
  bnd_ = 0.0;
  switch_ = FALSE;
  ntry_ = 0;
  told_ = (*t_);
  nfail_ = 0;
  if ((*jtask_) <= 0) {
    (void) _sdntl (eps_, _f, _fa, hmax_, hold_, impl_, jtask_, matdim_, maxord_, mint_, miter_, ml_, mu_, n_, nde_, save1_, 
    t_, uround_, _users, y_, ywt_, h_, mntold_, mtrold_, nfe_, rc_, yh_, a_, convrg_, el_, fac_, &ier_, ipvt_, nq_, nwait_, 
    &rh_, rmax_, save2_, tq_, trend_, iswflg_, jstate_);
    if ((*n_) == 0) {
      goto _l440;
    }
    if ((*h_) == 0.0e0) {
      goto _l400;
    }
    if (ier_) {
      goto _l420;
    }
  }
  _l100:;
  ntry_ = ntry_ + 1;
  if (ntry_ > 50) {
    goto _l410;
  }
  (*t_) = (*t_) + (*h_);
  (void) _sdpsc (&_k1, n_, nq_, yh_);
  evaljc_ = (((_abs ((*rc_) - 1.0e0) > .3e0) || ((*nstep_) >= (*jstepl_) + 10)) && ((*miter_) != 0));
  evalfa_ = ! (evaljc_);
  _l110:;
  iter_ = 0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  (void) _f (n_, t_, y_, save2_);
  if ((*n_) == 0) {
    (*jstate_) = 6;
    goto _l430;
  }
  (*nfe_) = (*nfe_) + 1;
  if (evaljc_ || ier_) {
    (void) _sdpst (el_, _f, _fa, h_, impl_, _jacobn, matdim_, miter_, ml_, mu_, n_, nde_, nq_, save2_, t_, _users, y_, yh_, 
    ywt_, uround_, nfe_, nje_, a_, dfdy_, fac_, &ier_, ipvt_, save1_, iswflg_, &bnd_, jstate_);
    if ((*n_) == 0) {
      goto _l430;
    }
    if (ier_) {
      goto _l160;
    }
    (*convrg_) = FALSE;
    (*rc_) = 1.0;
    (*jstepl_) = (*nstep_);
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    save1_[i_ - 1] = 0.0;
  }
  _l130:;
  (void) _sdcor (dfdy_, el_, _fa, h_, ierror_, impl_, ipvt_, matdim_, miter_, ml_, mu_, n_, nde_, nq_, t_, _users, y_, 
  yh_, ywt_, &evalfa_, save1_, save2_, a_, &d_, jstate_);
  if ((*n_) == 0) {
    goto _l430;
  }
  if ((*iswflg_) == 3 && (*mint_) == 1) {
    if (iter_ == 0) {
      numer_ = _snrm2 (n_, save1_, &_k1);
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1];
      }
      y0nrm_ = _snrm2 (n_, yh_, &_k1);
    }
    else {
      denom_ = numer_;
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1] - dfdy_[0 + ((*matdim_)) * ((i_ - 1))];
      }
      numer_ = _snrm2 (n_, dfdy_, matdim_);
      if (el_[0 + (13) * (((*nq_) - 1))] * numer_ <= 100.0e0 * (*uround_) * y0nrm_) {
        if ((*rmax_) == 2.0) {
          switch_ = TRUE;
          goto _l170;
        }
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        dfdy_[0 + ((*matdim_)) * ((i_ - 1))] = save1_[i_ - 1];
      }
      if (denom_ != 0.0e0) {
        bnd_ = _max (bnd_, numer_ / (denom_ * _abs ((*h_)) * el_[0 + (13) * (((*nq_) - 1))]));
      }
    }
  }
  if (iter_ > 0) {
    (*trend_) = _max (.9e0 * (*trend_), d_ / d1_);
  }
  d1_ = d_;
  ctest_ = _min (2.0e0 * (*trend_), 1.0) * d_;
  if (ctest_ <= (*eps_)) {
    goto _l170;
  }
  iter_ = iter_ + 1;
  if (iter_ < 3) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))] + el_[0 + (13) * (((*nq_) - 1))] * save1_[i_ - 1];
    }
    (void) _f (n_, t_, y_, save2_);
    if ((*n_) == 0) {
      (*jstate_) = 6;
      goto _l430;
    }
    (*nfe_) = (*nfe_) + 1;
    goto _l130;
  }
  if ((*convrg_)) {
    evaljc_ = TRUE;
    evalfa_ = FALSE;
    goto _l110;
  }
  _l160:;
  (*t_) = told_;
  (void) _sdpsc (&_km1, n_, nq_, yh_);
  (*nwait_) = (*nq_) + 2;
  if ((*jtask_) != 0 && (*jtask_) != 2) {
    (*rmax_) = 2.0;
  }
  if (iter_ == 0) {
    rh_ = .3e0;
  }
  else {
    rh_ = .9e0 * powl (((*eps_) / ctest_), .2e0);
  }
  if (rh_ * (*h_) == 0.0e0) {
    goto _l400;
  }
  (void) _sdscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
  goto _l100;
  _l170:;
  (*convrg_) = ((*miter_) != 0);
  if ((*ierror_) == 1 || (*ierror_) == 5) {
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save2_[i_ - 1] = save1_[i_ - 1] / ywt_[i_ - 1];
    }
  }
  else {
    for (i_ = 1; i_ <= (*nde_); (i_)++) {
      save2_[i_ - 1] = save1_[i_ - 1] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
    }
  }
  etest_ = _snrm2 (nde_, save2_, &_k1) / (tq_[1 + (3) * (((*nq_) - 1))] * sqrtf ((real_4) ((*nde_))));
  if (etest_ > (*eps_)) {
    (*t_) = told_;
    (void) _sdpsc (&_km1, n_, nq_, yh_);
    nfail_ = nfail_ + 1;
    if (nfail_ < 3 || (*nq_) == 1) {
      if ((*jtask_) != 0 && (*jtask_) != 2) {
        (*rmax_) = 2.0;
      }
      rh2_ = 1.0e0 / (1.2 * powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
      if ((*nq_) > 1) {
        if ((*ierror_) == 1 || (*ierror_) == 5) {
          for (i_ = 1; i_ <= (*nde_); (i_)++) {
            save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / ywt_[i_ - 1];
          }
        }
        else {
          for (i_ = 1; i_ <= (*nde_); (i_)++) {
            save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
          }
        }
        erdn_ = _snrm2 (nde_, save2_, &_k1) / (tq_[0 + (3) * (((*nq_) - 1))] * sqrtf ((real_4) ((*nde_))));
        rh1_ = 1.0e0 / _max (1.0, 1.3 * powl ((erdn_ / (*eps_)), (1.0e0 / (*nq_))));
        if (rh2_ < rh1_) {
          (*nq_) = (*nq_) - 1;
          (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) + 1 - 1))];
          rh_ = rh1_;
        }
        else {
          rh_ = rh2_;
        }
      }
      else {
        rh_ = rh2_;
      }
      (*nwait_) = (*nq_) + 2;
      if (rh_ * (*h_) == 0.0e0) {
        goto _l400;
      }
      (void) _sdscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
      goto _l100;
    }
    nfail_ = 0;
    (*jtask_) = 2;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
    }
    (void) _sdntl (eps_, _f, _fa, hmax_, hold_, impl_, jtask_, matdim_, maxord_, mint_, miter_, ml_, mu_, n_, nde_, save1_, 
    t_, uround_, _users, y_, ywt_, h_, mntold_, mtrold_, nfe_, rc_, yh_, a_, convrg_, el_, fac_, &ier_, ipvt_, nq_, nwait_, 
    &rh_, rmax_, save2_, tq_, trend_, iswflg_, jstate_);
    (*rmax_) = 10.0;
    if ((*n_) == 0) {
      goto _l440;
    }
    if ((*h_) == 0.0e0) {
      goto _l400;
    }
    if (ier_) {
      goto _l420;
    }
    goto _l100;
  }
  (*nstep_) = (*nstep_) + 1;
  (*hused_) = (*h_);
  (*nqused_) = (*nq_);
  (*avgh_) = (((*nstep_) - 1) * (*avgh_) + (*h_)) / (*nstep_);
  (*avgord_) = (((*nstep_) - 1) * (*avgord_) + (*nq_)) / (*nstep_);
  for (j_ = 1; j_ <= (*nq_) + 1; (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] = yh_[i_ - 1 + ((*n_)) * ((j_ - 1))] + el_[j_ - 1 + (13) * (((*nq_) - 1))] * 
      save1_[i_ - 1];
    }
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  if ((*iswflg_) == 3) {
    if (bnd_ != 0.0e0) {
      if ((*mint_) == 1 && (*nq_) <= 5) {
        hn_ = _abs ((*h_)) / _max ((*uround_), powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _min (hn_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_));
        hs_ = _abs ((*h_)) / _max ((*uround_), powl ((etest_ / ((*eps_) * el_[(*nq_) + 1 - 1])), (1.0e0 / ((*nq_) + 1))));
        if (hs_ > 1.2e0 * hn_) {
          (*mint_) = 2;
          (*mntold_) = (*mint_);
          (*miter_) = (*mtrsv_);
          (*mtrold_) = (*miter_);
          (*maxord_) = _min ((*mxrdsv_), 5);
          (*rc_) = 0.0;
          (*rmax_) = 10.0;
          (*trend_) = 1.0;
          (void) _sdcst (maxord_, mint_, iswflg_, el_, tq_);
          (*nwait_) = (*nq_) + 2;
        }
      }
      else if ((*mint_) == 2) {
        hs_ = _abs ((*h_)) / _max ((*uround_), powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _abs ((*h_)) / _max ((*uround_), powl ((etest_ * el_[(*nq_) + 1 - 1] / (*eps_)), (1.0e0 / ((*nq_) + 1))));
        hn_ = _min (hn_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_));
        if (hn_ >= hs_) {
          (*mint_) = 1;
          (*mntold_) = (*mint_);
          (*miter_) = 0;
          (*mtrold_) = (*miter_);
          (*maxord_) = _min ((*mxrdsv_), 12);
          (*rmax_) = 10.0;
          (*trend_) = 1.0;
          (*convrg_) = FALSE;
          (void) _sdcst (maxord_, mint_, iswflg_, el_, tq_);
          (*nwait_) = (*nq_) + 2;
        }
      }
    }
  }
  if (switch_) {
    (*mint_) = 2;
    (*mntold_) = (*mint_);
    (*miter_) = (*mtrsv_);
    (*mtrold_) = (*miter_);
    (*maxord_) = _min ((*mxrdsv_), 5);
    (*nq_) = _min ((*nq_), (*maxord_));
    (*rc_) = 0.0;
    (*rmax_) = 10.0;
    (*trend_) = 1.0;
    (void) _sdcst (maxord_, mint_, iswflg_, el_, tq_);
    (*nwait_) = (*nq_) + 2;
  }
  if ((*jtask_) == 0 || (*jtask_) == 2) {
    rh_ = 1.0e0 / _max ((*uround_), 1.2 * powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
    if (rh_ > 1.0) {
      (void) _sdscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
    }
  }
  else if ((*nwait_) > 1) {
    (*nwait_) = (*nwait_) - 1;
    if ((*nwait_) == 1 && (*nq_) < (*maxord_)) {
      for (i_ = 1; i_ <= (*nde_); (i_)++) {
        yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))] = save1_[i_ - 1];
      }
    }
  }
  else {
    if ((*nq_) == 1) {
      rh1_ = 0.0;
    }
    else {
      if ((*ierror_) == 1 || (*ierror_) == 5) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / ywt_[i_ - 1];
        }
      }
      else {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * (((*nq_) + 1 - 1))] / _max (_abs (y_[i_ - 1]), ywt_[i_ - 1]);
        }
      }
      erdn_ = _snrm2 (nde_, save2_, &_k1) / (tq_[0 + (3) * (((*nq_) - 1))] * sqrtf ((real_4) ((*nde_))));
      rh1_ = 1.0e0 / _max ((*uround_), 1.3 * powl ((erdn_ / (*eps_)), (1.0e0 / (*nq_))));
    }
    rh2_ = 1.0e0 / _max ((*uround_), 1.2 * powl ((etest_ / (*eps_)), (1.0e0 / ((*nq_) + 1))));
    if ((*nq_) == (*maxord_)) {
      rh3_ = 0.0;
    }
    else {
      if ((*ierror_) == 1 || (*ierror_) == 5) {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = (save1_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))]) / ywt_[i_ - 1];
        }
      }
      else {
        for (i_ = 1; i_ <= (*nde_); (i_)++) {
          save2_[i_ - 1] = (save1_[i_ - 1] - yh_[i_ - 1 + ((*n_)) * (((*maxord_) + 1 - 1))]) / _max (_abs (y_[i_ - 1]), ywt_[i_ - 
          1]);
        }
      }
      erup_ = _snrm2 (nde_, save2_, &_k1) / (tq_[2 + (3) * (((*nq_) - 1))] * sqrtf ((real_4) ((*nde_))));
      rh3_ = 1.0e0 / _max ((*uround_), 1.4 * powl ((erup_ / (*eps_)), (1.0e0 / ((*nq_) + 2))));
    }
    if (rh1_ > rh2_ && rh1_ >= rh3_) {
      rh_ = rh1_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
      (*nq_) = (*nq_) - 1;
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) + 1 - 1))];
    }
    else if (rh2_ >= rh1_ && rh2_ >= rh3_) {
      rh_ = rh2_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
    }
    else {
      rh_ = rh3_;
      if (rh_ <= 1.0) {
        goto _l380;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        yh_[i_ - 1 + ((*n_)) * (((*nq_) + 2 - 1))] = save1_[i_ - 1] * el_[(*nq_) + 1 - 1 + (13) * (((*nq_) - 1))] / ((*nq_) + 
        1);
      }
      (*nq_) = (*nq_) + 1;
      (*rc_) = (*rc_) * el_[0 + (13) * (((*nq_) - 1))] / el_[0 + (13) * (((*nq_) - 1 - 1))];
    }
    if ((*iswflg_) == 3 && (*mint_) == 1) {
      if (bnd_ != 0.0e0) {
        rh_ = _min (rh_, 1.0e0 / (2.0e0 * el_[0 + (13) * (((*nq_) - 1))] * bnd_ * _abs ((*h_))));
      }
    }
    (void) _sdscl (hmax_, n_, nq_, rmax_, h_, rc_, &rh_, yh_);
    (*rmax_) = 10.0;
    _l380:;
    (*nwait_) = (*nq_) + 2;
  }
  (*jstate_) = 1;
  (*hold_) = (*h_);
  goto _l0;
  _l400:;
  (*jstate_) = 2;
  (*hold_) = (*h_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  goto _l0;
  _l410:;
  (*jstate_) = 3;
  (*hold_) = (*h_);
  goto _l0;
  _l420:;
  (*jstate_) = 4;
  (*hold_) = (*h_);
  goto _l0;
  _l430:;
  (*t_) = told_;
  (void) _sdpsc (&_km1, &nsv_, nq_, yh_);
  for (i_ = 1; i_ <= nsv_; (i_)++) {
    y_[i_ - 1] = yh_[i_ - 1 + ((*n_)) * ((0))];
  }
  _l440:;
  (*hold_) = (*h_);
  _l0:;
  __calls[34].calls++;
  return 0;
}

int_4 _sdzro (real_4 _p_ ae_, real_4 (*_f)(), real_4 _p_ h_, int_4 _p_ n_, int_4 _p_ nq_, int_4 _p_ iroot_, real_4 _p_ 
re_, real_4 _p_ t_, real_4 _p_ yh_, real_4 _p_ uround_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ fb_, real_4 _p_ fc_, 
real_4 _p_ y_)
{
  static int_4 ic_, kount_;
  static real_4 a_, acbs_, acmb_, cmb_, er_, fa_, p_, q_, rw_, tol_;
  er_ = 4.0e0 * (*uround_);
  rw_ = _max ((*re_), er_);
  ic_ = 0;
  acbs_ = _abs ((*b_) - (*c_));
  a_ = (*c_);
  fa_ = (*fc_);
  kount_ = 0;
  _l10:;
  if (_abs ((*fc_)) < _abs ((*fb_))) {
    a_ = (*b_);
    fa_ = (*fb_);
    (*b_) = (*c_);
    (*fb_) = (*fc_);
    (*c_) = a_;
    (*fc_) = fa_;
  }
  cmb_ = 0.5e0 * ((*c_) - (*b_));
  acmb_ = _abs (cmb_);
  tol_ = rw_ * _abs ((*b_)) + (*ae_);
  if (acmb_ <= tol_) {
    goto _l0;
  }
  if (kount_ > 50) {
    goto _l0;
  }
  p_ = ((*b_) - a_) * (*fb_);
  q_ = fa_ - (*fb_);
  if (p_ < 0.0e0) {
    p_ = -p_;
    q_ = -q_;
  }
  a_ = (*b_);
  fa_ = (*fb_);
  ic_ = ic_ + 1;
  if (ic_ >= 4) {
    if (8.0e0 * acmb_ >= acbs_) {
      (*b_) = 0.5e0 * ((*c_) + (*b_));
      goto _l20;
    }
    ic_ = 0;
  }
  acbs_ = acmb_;
  if (p_ <= _abs (q_) * tol_) {
    (*b_) = (*b_) + _sign (tol_, cmb_);
  }
  else if (p_ < cmb_ * q_) {
    (*b_) = (*b_) + p_ / q_;
  }
  else {
    (*b_) = 0.5e0 * ((*c_) + (*b_));
  }
  _l20:;
  (void) _sdntp (h_, &_k0, n_, nq_, t_, b_, yh_, y_);
  (*fb_) = _f (n_, b_, y_, iroot_);
  if ((*n_) == 0) {
    goto _l0;
  }
  if ((*fb_) == 0.0e0) {
    goto _l0;
  }
  kount_ = kount_ + 1;
  if (_sign (1.0, (*fb_)) == _sign (1.0, (*fc_))) {
    (*c_) = a_;
    (*fc_) = fa_;
  }
  goto _l10;
  _l0:;
  __calls[35].calls++;
  return 0;
}

