//! @file mathlib-slatec.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 391 subprograms from SLATEC

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// AAAAAA COSGEN DC_9   DMPAR  DQDOTA DX     ISORT  PGSF   RPQR79 SPLPUP
// ASYIK  CPADD  DCFOD  DNBCO  DQDOTI DX4    JAIRY  PIMACH RPZERO SPOFS
// ASYJY  CPEVL  DCKDER DNBDI  DQFORM DXADJ  LLSIA  PINITM S1MERG SPOIR
// AVINT  CPEVLR DCOEF  DNBFA  DQRFAC DXC210 LPDP   PNNZRS SBOCLS SPOPT
// BCRH   CPOFS  DCOV   DNBFS  DQRSLV DXPSI  LSEI   POISD2 SBOLS  SPPERM
// BDIFF  CPOIR  DCSCAL DNBSL  DRC    DXRED  LSI    POISN2 SBOLSM SPSORT
// BKSOL  CPQR79 DCV    DNLS1  DRC3JJ DY     LSSODS POISP2 SCLOSM SREADP
// BLKTR1 CPROC  DDES   DNLS1E DRC3JM DY4    LSSUDS POLCOF SCOEF  SSIEV
// BNDACC CPROCP DDOGLG DNSQ   DRC6J  DYAIRY MACON  POLFIT SCOV   SSORT
// BNDSOL CPROD  DEFCMN DNSQE  DRD    EFCMN  MGSBV  POLINT SGEEV  STOR1
// BSGQ8  CPRODP DEFE4  DOHTRL DREADP FCMN   MINSO4 POLYVL SGEFS  STWAY
// BSPLVD CPZERO DEFEHL DORTHR DREORT FDJAC3 MINSOL POS3D1 SGEIR  SUDS
// BSPLVN CRATI  DEFER  DP1VLU DRF    FDUMP  MPADD  POSTG2 SGLSS  SVECS
// BSRH   CS1S2  DENORM DPCHNG DRJ    FFTDOC MPADD2 PPADD  SNBCO  SWRITP
// C1MERG CSCALE DERKFS DPCOEF DRKFS  FULMAT MPADD3 PPGQ8  SNBDI  TEVLC
// CASYI  CSHCH  DES    DPINCW DSORT  FZERO  MPBLAS PPGSF  SNBFA  TEVLS
// CBLKT1 CUCHK  DFCMN  DPINIT DSOS   GAMRN  MPCDM  PPPSF  SNBFS  TRI3
// CCMPB  CUNHJ  DFDJC1 DPINTM DSOSEQ GAUS8  MPCHK  PPSGF  SNBIR  TRIDQ
// CFOD   CUNIK  DFDJC3 DPLINT DSOSSL H12    MPCMD  PPSPF  SNBSL  TRIS4
// CGEEV  CV     DFEHL  DPLPCE DSPLP  HFTI   MPDIVI PROC   SNLS1  TRISP
// CGEFS  D1MERG DFSPVD DPLPDM DSTOR1 HKSEQ  MPERR  PROCP  SNLS1E TRIX
// CGEIR  D1MPYQ DFSPVN DPLPFE DSTWAY HPPERM MPMAXR PROD   SNSQ   U11LS
// CHIEV  D1UPDT DFULMT DPLPFL DSUDS  HPSORT MPMLP  PRODP  SNSQE  U11US
// CHKPR4 DASYIK DFZERO DPLPMN DU11LS HSTART MPMUL  PRVEC  SODS   U12LS
// CHKPRM DAVINT DGAUS8 DPLPMU DU11US HSTCS1 MPMUL2 PRWPGE SOPENM U12US
// CHKSN4 DBDIFF DGEFS  DPLPUP DU12LS HVNRM  MPMULI PRWVIR SOS    ULSIA
// CHKSNG DBKSOL DGLSS  DPNNZR DU12US HWSCS1 MPNZR  PSGF   SOSEQS USRMAT
// CMPCSG DBNDAC DH12   DPOFS  DULSIA HWSSS1 MPOVFL PSIFN  SOSSOL VNWRMS
// CMPOSD DBNDSL DHFTI  DPOLCF DUSRMT I1MERG MPSTR  PSIXN  SPELI4 WNLIT
// CMPOSN DBOCLS DHSTRT DPOLFT DVECS  IDLOC  MPUNFL PVALUE SPELIP WNLSM
// CMPOSP DBOLS  DHVNRM DPOLVL DVNRMS INDXA  NUMXER PYTHAG SPINCW WNLT1
// CMPTR3 DBOLSM DJAIRY DPOPT  DWNLIT INDXB  OHTROL RC     SPINIT WNLT2
// CMPTRX DBSGQ8 DLLSIA DPPERM DWNLSM INDXC  OHTROR RC3JJ  SPLP   WNLT3
// CNBCO  DC_336 DLPDP  DPPGQ8 DWNLT1 INXCA  ORTHO4 RC3JM  SPLPCE WNNLS
// CNBDI  DC_339 DLSEI  DPRVEC DWNLT2 INXCB  ORTHOG RC6J   SPLPDM XADJ
// CNBFA  DC_341 DLSI   DPRWPG DWNLT3 INXCC  ORTHOL RD     SPLPFE XC210
// CNBFS  DC_408 DLSSUD DPRWVR DWNNLS IPLOC  ORTHOR REORT  SPLPFL XPSI
// CNBIR  DC_5   DMACON DPSIXN DWRITP IPPERM PCHNGS RF     SPLPMN XRED
// CNBSL  DC_50  DMGSBV DPSORT DWUPDT IPSORT PCOEF  RJ     SPLPMU YAIRY
// COMPB

// Miscellaneous routines from SLATEC, not in other packages as BLAS,
// EISPACK, FISHPACK, FFTPACK, FNLIB, LINPACK etcetera.
// 
// Source: netlib.org/slatec/

// The license for SLATEC Fortran source code is:
//
// The SLATEC Common Mathematical Library was developed at
// US government research laboratories and is in the public domain.
// 
// Repository: http://www.netlib.org/slatec/
// 
// The SLATEC common mathematical library is issued by the following
// 
//         Air Force Weapons Laboratory, Albuquerque
//         Lawrence Livermore National Laboratory, Livermore
//         Los Alamos National Laboratory, Los Alamos
//         National Institute of Standards and Technology, Washington
//         National Energy Research Supercomputer Center, Livermore
//         Oak Ridge National Laboratory, Oak Ridge
//         Sandia National Laboratories, Albuquerque
//         Sandia National Laboratories, Livermore
// 
// All questions concerning the distribution of the library should be
// directed to the NATIONAL ENERGY SOFTWARE CENTER, 9700 Cass Ave.,
// Argonne, Illinois  60439, and not to the authors of the subprograms.
// 
//                  * * * * * Notice * * * * *
// 
// This material was prepared as an account of work sponsored by the
// United States Government.  Neither the United States, nor the
// Department of Energy, nor the Department of Defense, nor any of
// their employees, nor any of their contractors, subcontractors, or
// their employees, makes any warranty, expressed or implied, or
// assumes any legal liability or responsibility for the accuracy,
// completeness, or usefulness of any information, apparatus, product,
// or process disclosed, or represents that its use would not infringe
// upon privately owned rights.

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
#define _dc_0 " 4.1"
#define _dc_1 "slatec"
#define _dc_2 "avint"
#define _dc_3 "the upper limit of integration was not greater than the "
#define _dc_4 "lower limit."
#define _dc_5 "there were less than three function values between the "
#define _dc_6 "limits of integration."
#define _dc_7 "the abscissas were not strictly increasing.  must have "
#define _dc_8 "x(i-1) .lt. x(i) for all i."
#define _dc_9 "less than two function values were supplied."
#define _dc_10 "bndacc"
#define _dc_11 "mdg.lt.ir, probable error."
#define _dc_12 "bndsol"
#define _dc_13 "a zero diagonal term is in the n by n upper triangular "
#define _dc_14 "matrix."
#define _dc_15 "bsgq8"
#define _dc_16 "ans is probably insufficiently accurate."
#define _dc_17 "a and b are too nearly equal to allow normal integration. "
#define _dc_18 " ans is set to zero and ierr to -1."
#define _dc_19 "cgeev"
#define _dc_20 "n .gt. lda."
#define _dc_21 "n .lt. 1"
#define _dc_22 "job .ne. 0 and n .gt. ldv."
#define _dc_23 "lda.lt.ldv,  elements of v other than the n by n output "
#define _dc_24 "elements have been changed."
#define _dc_25 "lda.gt.ldv, elements of a other than the n by n input "
#define _dc_26 "cgefs"
#define _dc_27 "lda = "
#define _dc_28 " is less than n = "
#define _dc_29 "n = "
#define _dc_30 " is less than 1"
#define _dc_31 "itask = "
#define _dc_32 "singular matrix a - no solution"
#define _dc_33 "solution may have no significance"
#define _dc_34 "cgeir"
#define _dc_35 "chiev"
#define _dc_36 "nonreal element on diagonal of a"
#define _dc_37 "cnbfs"
#define _dc_38 "ml = "
#define _dc_39 " is out of range"
#define _dc_40 "mu = "
#define _dc_41 "cnbir"
#define _dc_42 "cpofs"
#define _dc_43 "singular or not positive definite - no solution"
#define _dc_44 "cpoir"
#define _dc_45 "cpqr79"
#define _dc_46 "leading coefficient is zero."
#define _dc_47 "degree invalid."
#define _dc_48 "no convergence in 30 qr iterations."
#define _dc_49 "davint"
#define _dc_50 "there were less than three function values "
#define _dc_51 "between the limits of integration."
#define _dc_52 "the upper limit of integration was not greater "
#define _dc_53 "than the lower limit."
#define _dc_54 "dbndac"
#define _dc_55 "dbndsl"
#define _dc_56 "dbocls"
#define _dc_57 "mdw = "
#define _dc_58 " must be positive."
#define _dc_59 "mcon = "
#define _dc_60 " must be non-negative"
#define _dc_61 "ncols = "
#define _dc_62 " the no. of variables, must be positive."
#define _dc_63 "ind("
#define _dc_64 ") = "
#define _dc_65 " must be 1-4."
#define _dc_66 "bound bl("
#define _dc_67 " is .gt. bu("
#define _dc_68 "iscale option = "
#define _dc_69 " must be 1-3"
#define _dc_70 "offset past x(ncols) ("
#define _dc_71 ") for user-provided column scaling must be positive."
#define _dc_72 "each provided column scale factor must be "
#define _dc_73 "positive.$$component "
#define _dc_74 " now = "
#define _dc_75 "option number = "
#define _dc_76 " is not defined."
#define _dc_77 "the row dimension of w(,) = "
#define _dc_78 " must be .ge. the number of effective rows = "
#define _dc_79 "the column dimension of w(,) = "
#define _dc_80 " must be .ge. ncols+mcon+1 = "
#define _dc_81 "the dimensions of the arrays bs(), bu(), and ind() = "
#define _dc_82 " must be .ge. ncols+mcon = "
#define _dc_83 "the dimension of x() = "
#define _dc_84 " must be .ge. the required length = "
#define _dc_85 "the dimension of rw() = "
#define _dc_86 " must be .ge. 6*ncols+5*mcon = "
#define _dc_87 "the dimension of iw() = "
#define _dc_88 " must be .ge. 2*ncols+2*mcon = "
#define _dc_89 "the dimension of iopt() = "
#define _dc_90 " must be .ge. the required len = "
#define _dc_91 "no. of rows = "
#define _dc_92 " must be .ge. 0 .and. .le. mdw-mcon = "
#define _dc_93 "dbols"
#define _dc_94 " the no. of variables must be positive."
#define _dc_95 ") for user-provided column scaling must "
#define _dc_96 "be positive."
#define _dc_97 "each provided column scale factor "
#define _dc_98 "must be positive.$$component "
#define _dc_99 "the option number = "
#define _dc_100 " must be .ge. the number of rows = "
#define _dc_101 " must be .ge. ncols+1 = "
#define _dc_102 "the dimensions of the arrays bl(), bu(), and ind() = "
#define _dc_103 " must be .ge. ncols = "
#define _dc_104 " must be .ge. 5*ncols = "
#define _dc_105 " must be .ge. 2*ncols = "
#define _dc_106 " must be .ge. 0 .and. .le. mdw = "
#define _dc_107 "dbolsm"
#define _dc_108 "the number of rows = "
#define _dc_109 "the number of columns = "
#define _dc_110 "for j = "
#define _dc_111 " the constraint indicator must be 1-4"
#define _dc_112 " the lower bound = "
#define _dc_113 " is .gt. the upper bound = "
#define _dc_114 "the input order of columns = "
#define _dc_115 " is not between 1 and ncols = "
#define _dc_116 "the bound polarity flag in component j = "
#define _dc_117 " must be positive.$$now = "
#define _dc_118 "the offset = "
#define _dc_119 " beyond position ncols = "
#define _dc_120 " must be positive for option number 2."
#define _dc_121 "the tolerance for rank determination = "
#define _dc_122 " is less than machine precision = "
#define _dc_123 " must be positive for option number 3."
#define _dc_124 "the reciprocal "
#define _dc_125 "of the blow-up factor for rejecting variables "
#define _dc_126 "must be positive.$$now = "
#define _dc_127 "the maximum number of iterations = "
#define _dc_128 " must be positive for option number 5."
#define _dc_129 "the factor (ncols/minput) where pre-"
#define _dc_130 "triangularizing is performed must be non-"
#define _dc_131 "negative.$$now = "
#define _dc_132 "the row separator to apply weighting ("
#define _dc_133 ") must lie between 0 and minput = "
#define _dc_134 ".$$weight = "
#define _dc_135 "(' pretri. input matrix')"
#define _dc_136 "(' lower bounds')"
#define _dc_137 "(' upper bounds')"
#define _dc_138 "more than itmax = "
#define _dc_139 " iterations solving bounded least squares problem."
#define _dc_140 "(' gradient values')"
#define _dc_141 "(' internal variable order')"
#define _dc_142 "(' bound polarity')"
#define _dc_143 "(' found no variable to enter')"
#define _dc_144 "(' try to bring in this col.')"
#define _dc_145 "(' variable is dependent, not used.')"
#define _dc_146 "(' pivot is zero, not used.')"
#define _dc_147 "(' variable has bad direction, not used.')"
#define _dc_148 "(' soln. values')"
#define _dc_149 "(' cols. used')"
#define _dc_150 "dbsgq8"
#define _dc_151 "dcov"
#define _dc_152 "execution terminated because user set iflag negative."
#define _dc_153 "invalid input parameter."
#define _dc_154 "singular jacobian matrix, covariance matrix cannot be "
#define _dc_155 "calculated."
#define _dc_156 "ddes"
#define _dc_157 "in ddeabm, info(1) must be "
#define _dc_158 "set to 0 for the start of a new problem, and must be "
#define _dc_159 "set to 1 following an interrupted task.  you are "
#define _dc_160 "attempting to continue the integration illegally by "
#define _dc_161 "calling the code with info(1) = "
#define _dc_162 "in ddeabm, info(2) must be "
#define _dc_163 "0 or 1 indicating scalar and vector error tolerances, "
#define _dc_164 "respectively.  you have called the code with info(2) = "
#define _dc_165 "in ddeabm, info(3) must be "
#define _dc_166 "0 or 1 indicating the interval or intermediate-output "
#define _dc_167 "mode of integration, respectively.  you have called "
#define _dc_168 "the code with  info(3) = "
#define _dc_169 "in ddeabm, info(4) must be "
#define _dc_170 "0 or 1 indicating whether or not the integration "
#define _dc_171 "interval is to be restricted by a point tstop.  you "
#define _dc_172 "have called the code with info(4) = "
#define _dc_173 "in ddeabm,  the number of "
#define _dc_174 "equations neq must be a positive integer.  you have "
#define _dc_175 "called the code with  neq = "
#define _dc_176 "in ddeabm, the relative "
#define _dc_177 "error tolerances rtol must be non-negative.  you "
#define _dc_178 "have called the code with  rtol("
#define _dc_179 ".  in the case of vector error tolerances, "
#define _dc_180 "no further checking of rtol components is done."
#define _dc_181 "in ddeabm, the absolute "
#define _dc_182 "error tolerances atol must be non-negative.  you "
#define _dc_183 "have called the code with  atol("
#define _dc_184 "no further checking of atol components is done."
#define _dc_185 "in ddeabm, you have "
#define _dc_186 "called the code with  tout = "
#define _dc_187 " but "
#define _dc_188 "you have also told the code (info(4) = 1) not to "
#define _dc_189 "integrate past the point tstop = "
#define _dc_190 " these instructions conflict."
#define _dc_191 "called the code with  t = tout = "
#define _dc_192 "$$this is not allowed on continuation calls."
#define _dc_193 "changed the value of t from "
#define _dc_194 " to "
#define _dc_195 "  this is not allowed on continuation calls."
#define _dc_196 "in ddeabm, by "
#define _dc_197 "calling the code with tout = "
#define _dc_198 " you are attempting to change the direction of "
#define _dc_199 "integration.$$this is not allowed without "
#define _dc_200 "restarting."
#define _dc_201 "in ddeabm, invalid "
#define _dc_202 "input was detected on successive entries.  it is "
#define _dc_203 "impossible to proceed because you have not "
#define _dc_204 "corrected the problem, so execution is being "
#define _dc_205 "terminated."
#define _dc_206 "defcmn"
#define _dc_207 "in defc, the order of the b-spline must be 1 thru 20."
#define _dc_208 "in defc, the number of knots must be at least twice "
#define _dc_209 "the b-spline order."
#define _dc_210 "in defc, the number of data points must be nonnegative."
#define _dc_211 "in defc, insufficient storage for w(*).  check formula "
#define _dc_212 "that reads lw.ge. ... .  need = "
#define _dc_213 " given = "
#define _dc_214 "in defc, input value of mdein must be 1-2."
#define _dc_215 "derkfs"
#define _dc_216 "in derkf, info(1) must be set to 0 "
#define _dc_217 "for the start of a new problem, and must be set to 1 "
#define _dc_218 "following an interrupted task.  you are attempting to "
#define _dc_219 "continue the integration illegally by calling the code "
#define _dc_220 "with  info(1) = "
#define _dc_221 "in derkf, info(2) must be 0 or 1 indicating scalar "
#define _dc_222 "and vector error tolerances, respectively.  you have "
#define _dc_223 "called the code with info(2) = "
#define _dc_224 "in derkf, info(3) must be 0 or 1 indicating the "
#define _dc_225 "or intermediate-output mode of integration, "
#define _dc_226 "respectively.  you have called the code "
#define _dc_227 "with  info(3) = "
#define _dc_228 "in derkf, the number of equations neq must be a "
#define _dc_229 "positive integer.  you have called the "
#define _dc_230 "code with neq = "
#define _dc_231 "in derkf, the relative error "
#define _dc_232 "tolerances rtol must be non-negative.  you have "
#define _dc_233 "called the code with  rtol("
#define _dc_234 "in derkf, the absolute error "
#define _dc_235 "tolerances atol must be non-negative.  you have "
#define _dc_236 "called the code with  atol("
#define _dc_237 "in derkf, you have called the "
#define _dc_238 "code with  t = tout = "
#define _dc_239 "$$this is not "
#define _dc_240 "allowed on continuation calls."
#define _dc_241 "in derkf, you have changed the "
#define _dc_242 "value of t from "
#define _dc_243 "in derkf, by calling the code "
#define _dc_244 "with tout = "
#define _dc_245 " you are attempting "
#define _dc_246 "to change the direction of integration.$$this is "
#define _dc_247 "not allowed without restarting."
#define _dc_248 "in derkf, invalid input was "
#define _dc_249 "detected on successive entries.  it is impossible "
#define _dc_250 "to proceed because you have not corrected the "
#define _dc_251 "problem, so execution is being terminated."
#define _dc_252 "des"
#define _dc_253 "in deabm, info(1) must be "
#define _dc_254 "in deabm, info(2) must be 0 or 1 "
#define _dc_255 "indicating scalar and vector error tolerances, "
#define _dc_256 "in deabm, info(3) must be 0 or 1 "
#define _dc_257 "indicating the interval or intermediate-output mode of "
#define _dc_258 "integration, respectively.  you have called the code "
#define _dc_259 "in deabm, info(4) must be 0 or 1 "
#define _dc_260 "indicating whether or not the integration interval is "
#define _dc_261 "to be restricted by a point tstop.  you have called "
#define _dc_262 "the code with info(4) = "
#define _dc_263 "in deabm, the number of equations "
#define _dc_264 "neq must be a positive integer.  you have called the "
#define _dc_265 "code with  neq = "
#define _dc_266 "in deabm, the relative error "
#define _dc_267 "in deabm, the absolute error "
#define _dc_268 "in deabm, you have called the "
#define _dc_269 "code with  tout = "
#define _dc_270 " but you have "
#define _dc_271 "also told the code (info(4) = 1) not to integrate "
#define _dc_272 "past the point tstop = "
#define _dc_273 " these "
#define _dc_274 "instructions conflict."
#define _dc_275 "in deabm, you have changed the "
#define _dc_276 "in deabm, by calling the "
#define _dc_277 "code with tout = "
#define _dc_278 " you are "
#define _dc_279 "attempting to change the direction of "
#define _dc_280 "in deabm, invalid input was "
#define _dc_281 "dfcmn"
#define _dc_282 "in dfc, the order of the b-spline must be 1 thru 20."
#define _dc_283 "in dfc, the number of knots must be at least twice "
#define _dc_284 "in dfc, the number of data points must be nonnegative."
#define _dc_285 "in dfc, insufficient storage for w(*).  check nb = "
#define _dc_286 "in dfc, input value of mode must be 1-4."
#define _dc_287 "in dfc, insufficient storage for w(*).  check lw = "
#define _dc_288 "in dfc, insufficient storage for iw(*).  check iw1 = "
#define _dc_289 "dfulmt"
#define _dc_290 "in dsplp, row dim., mrelas, nvars are missing from prgopt."
#define _dc_291 "dgaus8"
#define _dc_292 "a and b are too nearly equal to allow normal integration. $$"
#define _dc_293 "ans is set to zero and ierr to -1."
#define _dc_294 "dgefs"
#define _dc_295 "dhfti"
#define _dc_296 "mda.lt.m, probable error."
#define _dc_297 "mdb.lt.max(m,n).and.nb.gt.1. probable error."
#define _dc_298 "dllsia"
#define _dc_299 "solution only (info=1) but no right hand side (nb=0)"
#define _dc_300 "m.lt.1"
#define _dc_301 "n.lt.1"
#define _dc_302 "n.gt.m"
#define _dc_303 "mda.lt.m"
#define _dc_304 "liw.lt.m+n"
#define _dc_305 "nb.lt.0"
#define _dc_306 "mdb.lt.m"
#define _dc_307 "key out of range"
#define _dc_308 "insufficient work space"
#define _dc_309 "re(i) .lt. 0"
#define _dc_310 "re(i) .gt. 1"
#define _dc_311 "ae(i) .lt. 0"
#define _dc_312 "info out of range"
#define _dc_313 "mode out of range"
#define _dc_314 "np out of range"
#define _dc_315 "lsei"
#define _dc_316 "all of the variables n, me,"
#define _dc_317 " ma, mg must be .ge. 0$$entered routine with"
#define _dc_318 "$$n  = "
#define _dc_319 "$$me = "
#define _dc_320 "$$ma = "
#define _dc_321 "$$mg = "
#define _dc_322 "dlsei"
#define _dc_323 "insufficient storage "
#define _dc_324 "allocated for ws(*), need lw = "
#define _dc_325 "allocated for ip(*), need lip = "
#define _dc_326 "mdw.lt.me+ma+mg is an error"
#define _dc_327 "the option vector is undefined"
#define _dc_328 "the links in the option vector are cycling."
#define _dc_329 "mdw .lt. n when cov matrix needed, is an error"
#define _dc_330 "dlssud"
#define _dc_331 "invalid imput parameters."
#define _dc_332 "dnbfs"
#define _dc_333 "dnls1e"
#define _dc_334 "dnls1"
#define _dc_335 "derivative of "
#define _dc_336 "function "
#define _dc_337 " may be wrong, err = "
#define _dc_338 " too close to 0."
#define _dc_339 "derivative of function "
#define _dc_340 "third convergence condition, check results before accepting."
#define _dc_341 "too many function evaluations."
#define _dc_342 "tolerances too small, no further improvement possible."
#define _dc_343 "dnsqe"
#define _dc_344 "dnsq"
#define _dc_345 "xtol too small. no further improvement possible."
#define _dc_346 "iteration not making good progress."
#define _dc_347 "dorthr"
#define _dc_348 "invalid input parameters."
#define _dc_349 "rank of matrix is less than the number of rows."
#define _dc_350 "dp1vlu"
#define _dc_351 "the order of polynomial evaluation, l = "
#define _dc_352 " requested exceeds the highest order fit, nord = "
#define _dc_353 ", computed by dpolft -- execution terminated."
#define _dc_354 "invalid input parameter.  order of polynomial evaluation "
#define _dc_355 "requested is negative."
#define _dc_356 "dpchng"
#define _dc_357 "ircx=0"
#define _dc_358 "subscripts for array element to be accessed were out of "
#define _dc_359 "bounds"
#define _dc_360 "dpintm"
#define _dc_361 "matrix dimension m or n .le. 0"
#define _dc_362 "the value of lmx is too small"
#define _dc_363 "dplint"
#define _dc_364 "n is zero or negative."
#define _dc_365 "the abscissas are not distinct."
#define _dc_366 "dplpdm"
#define _dc_367 "in dsplp, short on storage for la05ad.  "
#define _dc_368 "use prgopt(*) to give more."
#define _dc_369 "in dsplp, la05ad returned error flag = "
#define _dc_370 "dplpmn"
#define _dc_371 "in dsplp,  a singular initial basis was encountered."
#define _dc_372 "in dsplp, an infeasible initial basis was encountered."
#define _dc_373 "(' enter standard phase-1')"
#define _dc_374 "(' enter standard phase-2')"
#define _dc_375 "in dsplp, the problem appears to be infeasible"
#define _dc_376 "in dsplp, the problem appears to have no finite solution."
#define _dc_377 "in dsplp, the problem appears to be infeasible and to "
#define _dc_378 "have no finite soln."
#define _dc_379 "(' basic (internal) dual soln.')"
#define _dc_380 "(' reduced costs')"
#define _dc_381 "(' search direction')"
#define _dc_382 "(' subscripts of basic variables during redecomposition')"
#define _dc_383 "(' est. error in primal comps.')"
#define _dc_384 "(' est. error in dual comps.')"
#define _dc_385 "in dsplp, moved to a singular point. this should not happen."
#define _dc_386 "in dsplp, max iterations = "
#define _dc_387 " taken.  up-to-date results saved on file no. "
#define _dc_388 ".   if file no. = 0, no save."
#define _dc_389 "('1num. of dependent vars., mrelas')"
#define _dc_390 "(' num. of independent vars., nvars')"
#define _dc_391 "(' dimension of costs(*)=')"
#define _dc_392 "(' dimensions of bl(*),bu(*),ind(*)'/' primal(*),duals(*) =')"
#define _dc_393 "(' dimension of ibasis(*)=')"
#define _dc_394 "(' dimension of prgopt(*)=')"
#define _dc_395 "(' 1-nvars=independent variable indices.'/ ' (nvars+1)-(nvars+mrelas)=dependent variable indices.'/ ' constraint indicators are 1-4 and mean')"
#define _dc_396 "(' 1=variable has only lower bound.'/ ' 2=variable has only upper bound.'/ ' 3=variable has both bounds.'/ ' 4=variable has no bounds, it is free.')"
#define _dc_397 "(' array of costs')"
#define _dc_398 "(' constraint indicators')"
#define _dc_399 "(' lower bounds for variables  (ignore unused entries.)')"
#define _dc_400 "(' upper bounds for variables  (ignore unused entries.)')"
#define _dc_401 "('0non-basic indices that are negative show variables' ' exchanged at a zero'/' step length')"
#define _dc_402 "(' when col. no. leaving=col. no. entering, the entering ' 'variable moved'/' to its bound.  it remains non-basic.'/ ' when col. no. of basis exchanged is negative, the leaving'/ ' variable is at its upper bound.')"
#define _dc_403 "(' the output value of info is')"
#define _dc_404 "(' this is a minimization problem.')"
#define _dc_405 "(' this is a maximization problem.')"
#define _dc_406 "(' steepest edge pricing was used.')"
#define _dc_407 "(' minimum reduced cost pricing was used.')"
#define _dc_408 "(' output value of the objective function')"
#define _dc_409 "(' the output independent and dependent variables')"
#define _dc_410 "(' the output dual variables')"
#define _dc_411 "(' variable indices in positions 1-mrelas are basic.')"
#define _dc_412 "(' no. of iterations')"
#define _dc_413 "(' no. of full redecomps')"
#define _dc_414 "('0iteration number')"
#define _dc_415 "(' index of variable entering the basis')"
#define _dc_416 "(' column of the basis exchanged')"
#define _dc_417 "(' index of variable leaving the basis')"
#define _dc_418 "(' length of the exchange step')"
#define _dc_419 "(' basic (internal) primal soln.')"
#define _dc_420 "(' ibb array')"
#define _dc_421 "(' translated rhs')"
#define _dc_422 "dplpmu"
#define _dc_423 "dplpup"
#define _dc_424 "in dsplp, independent variable = "
#define _dc_425 "in dsplp, lower bound = "
#define _dc_426 " and upper bound = "
#define _dc_427 " for independent variable = "
#define _dc_428 " are not consistent."
#define _dc_429 "in dsplp, dependent variable = "
#define _dc_430 " for dependant variable = "
#define _dc_431 "in dsplp, more than 2*nvars*mrelas iterations defining "
#define _dc_432 "or updating matrix data."
#define _dc_433 "in dsplp, row index = "
#define _dc_434 " or column index = "
#define _dc_435 " is out of range."
#define _dc_436 "in dsplp, indication flag = "
#define _dc_437 " for matrix data must be either 0 or 1."
#define _dc_438 "in dsplp, a matrix element's size is out of the "
#define _dc_439 "specified range."
#define _dc_440 "dpnnzr"
#define _dc_441 "bounds."
#define _dc_442 "dpofs"
#define _dc_443 "dpolft"
#define _dc_444 "dpopt"
#define _dc_445 "in dsplp, the user option array has undefined data."
#define _dc_446 "in dsplp, option array processing is cycling."
#define _dc_447 "in dsplp, an index of user-supplied basis is out of range."
#define _dc_448 "in dsplp, size parameters for matrix must be smallest and "
#define _dc_449 "largest magnitudes of nonzero entries."
#define _dc_450 "in dsplp, the number of revised simplex steps between "
#define _dc_451 "check-points must be positive."
#define _dc_452 "in dsplp, file numbers for saved data and matrix pages "
#define _dc_453 "must be positive and not equal."
#define _dc_454 "dpperm"
#define _dc_455 "the number of values to be rearranged, n, is not positive."
#define _dc_456 "the permutation vector, iperm, is not valid."
#define _dc_457 "dppgq8"
#define _dc_458 "a and b are too nearly equal to allow normal "
#define _dc_459 "integration.  answer is set to zero, and ierr=-1."
#define _dc_460 "dprwpg"
#define _dc_461 "the value of ipage (page number) was not in the range"
#define _dc_462 "1.le.ipage.le.maxpge."
#define _dc_463 "the value of lpg (page length) was nonpositive."
#define _dc_464 "the value of key (read-write flag) was not 1 or 2."
#define _dc_465 "dpsort"
#define _dc_466 "the number of values to be sorted, n, is not positive."
#define _dc_467 "the sort control parameter, kflag, is not 2, 1, -1, or -2."
#define _dc_468 "drc3jj"
#define _dc_469 "l2-abs(m2) or l3-abs(m3) "
#define _dc_470 "less than zero."
#define _dc_471 "l2+abs(m2) or l3+abs(m3) "
#define _dc_472 "not integer."
#define _dc_473 "l1max-l1min not integer."
#define _dc_474 "l1min greater than l1max."
#define _dc_475 "dimension of result array for "
#define _dc_476 "3j coefficients too small."
#define _dc_477 "drc3jm"
#define _dc_478 "l1-abs(m1) less than zero or "
#define _dc_479 "l1+abs(m1) not integer."
#define _dc_480 "l1, l2, l3 do not satisfy "
#define _dc_481 "triangular condition."
#define _dc_482 "l1+l2+l3 not integer."
#define _dc_483 "m2max-m2min not integer."
#define _dc_484 "m2min greater than m2max."
#define _dc_485 "drc6j"
#define _dc_486 "l2+l3+l5+l6 or l4+l2+l6 not "
#define _dc_487 "integer."
#define _dc_488 "l4, l2, l6 triangular "
#define _dc_489 "condition not satisfied."
#define _dc_490 "l4, l5, l3 triangular "
#define _dc_491 "dimension of result array for 6j "
#define _dc_492 "coefficients too small."
#define _dc_493 "drc"
#define _dc_494 "x.lt.0 .or. y.le.0 where x = "
#define _dc_495 " and y = "
#define _dc_496 "max(x,y).gt.uplim where x = "
#define _dc_497 " y = "
#define _dc_498 " and uplim = "
#define _dc_499 "x+y.lt.lolim where x = "
#define _dc_500 " and lolim = "
#define _dc_501 "drd"
#define _dc_502 "min(x,y).lt.0 where x = "
#define _dc_503 "max(x,y,z).gt.uplim where x = "
#define _dc_504 " z = "
#define _dc_505 "min(x+y,z).lt.lolim where x = "
#define _dc_506 "dreadp"
#define _dc_507 "in dsplp, lpg = "
#define _dc_508 " irecn = "
#define _dc_509 "drf"
#define _dc_510 "min(x,y,z).lt.0 where x = "
#define _dc_511 " and z = "
#define _dc_512 "min(x+y,x+z,y+z).lt.lolim where x = "
#define _dc_513 "drj"
#define _dc_514 "max(x,y,z,p).gt.uplim where x = "
#define _dc_515 " p = "
#define _dc_516 "rj"
#define _dc_517 "min(x+y,x+z,y+z,p).lt.lolim where x = "
#define _dc_518 "drkfs"
#define _dc_519 "in dderkf, info(1) must be set to 0 "
#define _dc_520 "in dderkf, info(2) must be 0 or 1 "
#define _dc_521 "in dderkf, info(3) must be 0 or 1 "
#define _dc_522 "in dderkf, the number of equations "
#define _dc_523 "in dderkf, the relative error "
#define _dc_524 "in dderkf, the absolute error "
#define _dc_525 "in dderkf, you have called the "
#define _dc_526 "in dderkf, you have changed the "
#define _dc_527 "in dderkf, by calling the code with tout = "
#define _dc_528 " you are attempting to change the "
#define _dc_529 "direction of integration.$$this is not allowed "
#define _dc_530 "without restarting."
#define _dc_531 "in dderkf, invalid input was "
#define _dc_532 "dsort"
#define _dc_533 "the number of values to be sorted is not positive."
#define _dc_534 "the sort control parameter, k, is not 2, 1, -1, or -2."
#define _dc_535 "0residual norm ="
#define _dc_536 " "
#define _dc_537 "solution iterate ("
#define _dc_538 ")"
#define _dc_539 "dsos"
#define _dc_540 "the number of equations "
#define _dc_541 "must be a positive integer.  you have called the "
#define _dc_542 "the error tolerances for "
#define _dc_543 "the solution iterates cannot be negative. you have "
#define _dc_544 "called the code with  rtolx = "
#define _dc_545 " and atolx = "
#define _dc_546 "the residual error "
#define _dc_547 "tolerance must be non-negative.  you have called the "
#define _dc_548 "code with tolf = "
#define _dc_549 "you have told the code "
#define _dc_550 "to use optional input items by setting iflag=-1. "
#define _dc_551 "however you have called the code with the maximum "
#define _dc_552 "allowable number of iterations set to iw(2) = "
#define _dc_553 "dimension of the rw array "
#define _dc_554 "must be at least 1 + 6*neq + neq*(neq+1)/2 .  you have "
#define _dc_555 "called the code with lrw = "
#define _dc_556 "dimension of the iw array "
#define _dc_557 "must be at least 3 + neq.  you have called the code "
#define _dc_558 "with  liw = "
#define _dc_559 "dsplp"
#define _dc_560 "value of mrelas must be "
#define _dc_561 ".gt. 0.  now = "
#define _dc_562 "value of nvars must be "
#define _dc_563 "the user option array has undefined data."
#define _dc_564 "option array processing is cycling."
#define _dc_565 "user-defined value of "
#define _dc_566 "lamat = "
#define _dc_567 " must be .ge. nvars+7."
#define _dc_568 "user-defined value of lbm must be .ge. 0."
#define _dc_569 "work or iwork is not long "
#define _dc_570 "enough. lw must be = "
#define _dc_571 " and liw must be = "
#define _dc_572 "du11ls"
#define _dc_573 "first np columns are linearly dependent"
#define _dc_574 "du11us"
#define _dc_575 "first np rows are linearly dependent"
#define _dc_576 "dulsia"
#define _dc_577 "n.lt.m"
#define _dc_578 "mdb.lt.n"
#define _dc_579 "dwnlsm"
#define _dc_580 "in dwnnls, the option vector is undefined"
#define _dc_581 "in dwnnls, the links in the option vector are cycling."
#define _dc_582 "dwnnls"
#define _dc_583 "allocated for work(*), need lw = "
#define _dc_584 "allocated for iwork(*), need liw = "
#define _dc_585 "the value mdw.lt.me+ma is an error"
#define _dc_586 "l.ge.0 .and. l.le.n is required"
#define _dc_587 "dwritp"
#define _dc_588 "in dsplp, lgp = "
#define _dc_589 "dxadj"
#define _dc_590 "overflow in auxiliary index"
#define _dc_591 "dxc210"
#define _dc_592 "k too large"
#define _dc_593 "efcmn"
#define _dc_594 "in efc, the order of the b-spline must be 1 thru 20."
#define _dc_595 "in efc, the number of knots must be at least twice "
#define _dc_596 "in efc, the number of data points must be nonnegative."
#define _dc_597 "in efc, insufficient storage for w(*).  check formula "
#define _dc_598 "in efc, input value of mdein must be 1-2."
#define _dc_599 "fcmn"
#define _dc_600 "in fc, the order of the b-spline must be 1 thru 20."
#define _dc_601 "in fc, the number of knots must be at least twice "
#define _dc_602 "in fc, the number of data points must be nonnegative."
#define _dc_603 "in fc, insufficient storage for w(*).  check nb = "
#define _dc_604 "in fc, input value of mode must be 1-4."
#define _dc_605 "in fc, insufficient storage for w(*).  check lw = "
#define _dc_606 "in fc, insufficient storage for iw(*).  check iw1 = "
#define _dc_607 "fulmat"
#define _dc_608 "in splp package, row dim., mrelas, nvars are missing from "
#define _dc_609 "prgopt."
#define _dc_610 "gaus8"
#define _dc_611 "hfti"
#define _dc_612 "hpperm"
#define _dc_613 "the length of the work variable, work, is too short."
#define _dc_614 "hpsort"
#define _dc_615 " hpsort"
#define _dc_616 "the string beginning, strbeg, is beyond its end, strend."
#define _dc_617 "the string beginning, strbeg, is out-of-range."
#define _dc_618 "the string end, strend, is out-of-range."
#define _dc_619 "idloc"
#define _dc_620 "a value of loc, the first argument, .le. 0 was encountered"
#define _dc_621 "iploc"
#define _dc_622 "ipperm"
#define _dc_623 "ipsort"
#define _dc_624 "isort"
#define _dc_625 "llsia"
#define _dc_626 "lssods"
#define _dc_627 "problem may be ill-conditioned.  maximal machine accuracy "
#define _dc_628 "is not achievable."
#define _dc_629 "problem is very ill-conditioned.  iterative "
#define _dc_630 "improvement is ineffective."
#define _dc_631 "convergence has not been obtained with allowable "
#define _dc_632 "number of iterative improvement steps."
#define _dc_633 "lssuds"
#define _dc_634 " *** sign not 0, +1 or -1 in call to mpadd2,"
#define _dc_635 " possible overwriting problem ***"
#define _dc_636 "mpblas"
#define _dc_637 "array space not sufficient for quad precision 2x "
#define _dc_638 "double precision, proceeding."
#define _dc_639 " *** b ="
#define _dc_640 " illegal in call to mpchk,"
#define _dc_641 " perhaps not set before call to an mp routine ***"
#define _dc_642 " *** t ="
#define _dc_643 " *** m .le. t in call to mpchk,"
#define _dc_644 " *** b too large in call to mpchk ***"
#define _dc_645 " *** mxr too small or not set to dim(r) before call"
#define _dc_646 " to an mp routine *** "
#define _dc_647 " *** mxr should be at least"
#define _dc_648 "*t +"
#define _dc_649 " ="
#define _dc_650 "  ***"
#define _dc_651 " *** actually mxr ="
#define _dc_652 ", and t ="
#define _dc_653 " *** floating-point over/under-flow in mpcmd ***"
#define _dc_654 " *** attempted division by zero in call to mpdivi ***"
#define _dc_655 " *** integer overflow in mpdivi, b too large ***"
#define _dc_656 "mperr"
#define _dc_657 " *** execution terminated by call to mperr"
#define _dc_658 " in mp version 770217 ***"
#define _dc_659 " *** overflow occurred in mpmul2 ***"
#define _dc_660 " *** integer overflow in mpmul2, b too large ***"
#define _dc_661 " *** integer overflow in mpmul, b too large ***"
#define _dc_662 " *** illegal base b digit in call to mpmul,"
#define _dc_663 " *** sign not 0, +1 or -1 in call to mpnzr,"
#define _dc_664 " *** overflow occurred in mpnzr ***"
#define _dc_665 " *** call to mpovfl, mp overflow occurred ***"
#define _dc_666 "orthol"
#define _dc_667 "rank of matrix is less than the number of columns."
#define _dc_668 "orthor"
#define _dc_669 "pchngs"
#define _dc_670 "ircx=0."
#define _dc_671 "pinitm"
#define _dc_672 "matrix dimension m or n .le. 0."
#define _dc_673 "the value of lmx is too small."
#define _dc_674 "pnnzrs"
#define _dc_675 "polfit"
#define _dc_676 "polint"
#define _dc_677 "ppgq8"
#define _dc_678 "prwpge"
#define _dc_679 "pvalue"
#define _dc_680 ", computed by polfit -- execution terminated."
#define _dc_681 "requested is negative -- execution terminated."
#define _dc_682 "rc3jj"
#define _dc_683 "dimension of result array for 3j "
#define _dc_684 "rc3jm"
#define _dc_685 "rc6j"
#define _dc_686 "rc"
#define _dc_687 "rd"
#define _dc_688 "rf"
#define _dc_689 "rpqr79"
#define _dc_690 "sbocls"
#define _dc_691 " must be .ge. the reqd. length = "
#define _dc_692 " must be .ge. the reqd. len = "
#define _dc_693 "sbols"
#define _dc_694 "sbolsm"
#define _dc_695 "sclosm"
#define _dc_696 "in splp, close has error flag = "
#define _dc_697 "scov"
#define _dc_698 "sgeev"
#define _dc_699 "sgefs"
#define _dc_700 "sgeir"
#define _dc_701 "snbfs"
#define _dc_702 "snbir"
#define _dc_703 "snls1e"
#define _dc_704 "snls1"
#define _dc_705 "snsqe"
#define _dc_706 "snsq"
#define _dc_707 "sopenm"
#define _dc_708 "in splp, open has error flag = "
#define _dc_709 "solution iterate"
#define _dc_710 " ("
#define _dc_711 "sos"
#define _dc_712 "to use optional in put items by setting  iflag=-1. "
#define _dc_713 "allowable number of iterations set to  iw(2) = "
#define _dc_714 "must be at least   3 + neq.  you have called the code "
#define _dc_715 "splpdm"
#define _dc_716 "in splp, short on storage for la05as.  "
#define _dc_717 "in splp, la05as returned error flag = "
#define _dc_718 "splp"
#define _dc_719 "splpmn"
#define _dc_720 "in splp,  a singular initial basis was encountered."
#define _dc_721 "in splp, an infeasible initial basis was encountered."
#define _dc_722 "in splp, the problem appears to be infeasible"
#define _dc_723 "in splp, the problem appears to have no finite solution."
#define _dc_724 "in splp, the problem appears to be infeasible and to have "
#define _dc_725 "no finite solution."
#define _dc_726 "in splp, moved to a singular point.  this should not happen."
#define _dc_727 "in splp, max iterations = "
#define _dc_728 ".  if file no. = 0, no save."
#define _dc_729 "splpmu"
#define _dc_730 "splpup"
#define _dc_731 "in splp, independent variable = "
#define _dc_732 "in splp, lower bound = "
#define _dc_733 "in splp, dependent variable = "
#define _dc_734 "in splp, more than 2*nvars*mrelas iterations defining "
#define _dc_735 "in splp, row index = "
#define _dc_736 "in splp, indication flag = "
#define _dc_737 "in splp, a matrix element's size is out of the "
#define _dc_738 "spofs"
#define _dc_739 "spoir"
#define _dc_740 "spopt"
#define _dc_741 "in splp, the user option array has undefined data."
#define _dc_742 "in splp, option array processing is cycling."
#define _dc_743 "in splp, an index of user-supplied basis is out of range."
#define _dc_744 "in splp, size parameters for matrix must be smallest and "
#define _dc_745 "in splp, the number of revised simplex steps between "
#define _dc_746 "in splp, file numbers for saved data and matrix pages "
#define _dc_747 "spperm"
#define _dc_748 "spsort"
#define _dc_749 "sreadp"
#define _dc_750 "in splp, lpg = "
#define _dc_751 "ssiev"
#define _dc_752 "ssort"
#define _dc_753 "swritp"
#define _dc_754 "in splp, lgp = "
#define _dc_755 "u11ls"
#define _dc_756 "u11us"
#define _dc_757 "ulsia"
#define _dc_758 "wnlsm"
#define _dc_759 "wnnls, the option vector is undefined"
#define _dc_760 "wnnls, the links in the option vector are cycling."
#define _dc_761 "wnnls"
#define _dc_762 "xadj"
#define _dc_763 "xc210"
static FORMAT *__fmt_a = NULL;
typedef char char_3[4];
typedef char char_7[8];
typedef char char_15[16];
typedef char char_31[32];
typedef char char_63[64];
typedef char char_127[128];
typedef char char_255[256];
typedef char char_511[512];
typedef char char_1023[1024];
typedef char char_2047[2048];
typedef char char_4095[4096];
#define __ncalls 385
static CALLS __calls[__ncalls] = {
  {"aaaaaa", 0}, // subroutine
  {"asyik", 0}, // subroutine
  {"asyjy", 0}, // subroutine
  {"avint", 0}, // subroutine
  {"bcrh", 0}, // function
  {"bdiff", 0}, // subroutine
  {"bksol", 0}, // subroutine
  {"blktr1", 0}, // subroutine
  {"bndacc", 0}, // subroutine
  {"bndsol", 0}, // subroutine
  {"bsgq8", 0}, // subroutine
  {"bsplvd", 0}, // subroutine
  {"bsplvn", 0}, // subroutine
  {"bsrh", 0}, // function
  {"c1merg", 0}, // subroutine
  {"casyi", 0}, // subroutine
  {"cblkt1", 0}, // subroutine
  {"ccmpb", 0}, // subroutine
  {"cfod", 0}, // subroutine
  {"cgeev", 0}, // subroutine
  {"cgefs", 0}, // subroutine
  {"cgeir", 0}, // subroutine
  {"chiev", 0}, // subroutine
  {"chkpr4", 0}, // subroutine
  {"chkprm", 0}, // subroutine
  {"chksn4", 0}, // subroutine
  {"chksng", 0}, // subroutine
  {"cmpcsg", 0}, // subroutine
  {"cmposd", 0}, // subroutine
  {"cmposn", 0}, // subroutine
  {"cmposp", 0}, // subroutine
  {"cmptr3", 0}, // subroutine
  {"cmptrx", 0}, // subroutine
  {"cnbco", 0}, // subroutine
  {"cnbdi", 0}, // subroutine
  {"cnbfa", 0}, // subroutine
  {"cnbfs", 0}, // subroutine
  {"cnbir", 0}, // subroutine
  {"cnbsl", 0}, // subroutine
  {"compb", 0}, // subroutine
  {"cosgen", 0}, // subroutine
  {"cpadd", 0}, // subroutine
  {"cpevl", 0}, // subroutine
  {"cpevlr", 0}, // subroutine
  {"cpofs", 0}, // subroutine
  {"cpoir", 0}, // subroutine
  {"cpqr79", 0}, // subroutine
  {"cproc", 0}, // subroutine
  {"cprocp", 0}, // subroutine
  {"cprod", 0}, // subroutine
  {"cprodp", 0}, // subroutine
  {"cpzero", 0}, // subroutine
  {"crati", 0}, // subroutine
  {"cs1s2", 0}, // subroutine
  {"cscale", 0}, // subroutine
  {"cshch", 0}, // subroutine
  {"cuchk", 0}, // subroutine
  {"cunhj", 0}, // subroutine
  {"cunik", 0}, // subroutine
  {"cv", 0}, // real*4 function
  {"d1merg", 0}, // subroutine
  {"d1mpyq", 0}, // subroutine
  {"d1updt", 0}, // subroutine
  {"dasyik", 0}, // subroutine
  {"davint", 0}, // subroutine
  {"dbdiff", 0}, // subroutine
  {"dbksol", 0}, // subroutine
  {"dbndac", 0}, // subroutine
  {"dbndsl", 0}, // subroutine
  {"dbocls", 0}, // subroutine
  {"dbols", 0}, // subroutine
  {"dbolsm", 0}, // subroutine
  {"dbsgq8", 0}, // subroutine
  {"dcfod", 0}, // subroutine
  {"dckder", 0}, // subroutine
  {"dcoef", 0}, // subroutine
  {"dcov", 0}, // subroutine
  {"dcscal", 0}, // subroutine
  {"dcv", 0}, // real*8 function
  {"ddes", 0}, // subroutine
  {"ddoglg", 0}, // subroutine
  {"defcmn", 0}, // subroutine
  {"defe4", 0}, // subroutine
  {"defehl", 0}, // subroutine
  {"defer", 0}, // subroutine
  {"denorm", 0}, // real*8 function
  {"derkfs", 0}, // subroutine
  {"des", 0}, // subroutine
  {"dfcmn", 0}, // subroutine
  {"dfdjc1", 0}, // subroutine
  {"dfdjc3", 0}, // subroutine
  {"dfehl", 0}, // subroutine
  {"dfspvd", 0}, // subroutine
  {"dfspvn", 0}, // subroutine
  {"dfulmt", 0}, // subroutine
  {"dfzero", 0}, // subroutine
  {"dgaus8", 0}, // subroutine
  {"dgefs", 0}, // subroutine
  {"dglss", 0}, // subroutine
  {"dh12", 0}, // subroutine
  {"dhfti", 0}, // subroutine
  {"dhstrt", 0}, // subroutine
  {"dhvnrm", 0}, // real*8 function
  {"djairy", 0}, // subroutine
  {"dllsia", 0}, // subroutine
  {"dlpdp", 0}, // subroutine
  {"dlsei", 0}, // subroutine
  {"dlsi", 0}, // subroutine
  {"dlssud", 0}, // subroutine
  {"dmacon", 0}, // subroutine
  {"dmgsbv", 0}, // subroutine
  {"dmpar", 0}, // subroutine
  {"dnbco", 0}, // subroutine
  {"dnbdi", 0}, // subroutine
  {"dnbfa", 0}, // subroutine
  {"dnbfs", 0}, // subroutine
  {"dnbsl", 0}, // subroutine
  {"dnls1e", 0}, // subroutine
  {"dnls1", 0}, // subroutine
  {"dnsqe", 0}, // subroutine
  {"dnsq", 0}, // subroutine
  {"dohtrl", 0}, // subroutine
  {"dorthr", 0}, // subroutine
  {"dp1vlu", 0}, // subroutine
  {"dpchng", 0}, // subroutine
  {"dpcoef", 0}, // subroutine
  {"dpincw", 0}, // subroutine
  {"dpinit", 0}, // subroutine
  {"dpintm", 0}, // subroutine
  {"dplint", 0}, // subroutine
  {"dplpce", 0}, // subroutine
  {"dplpdm", 0}, // subroutine
  {"dplpfe", 0}, // subroutine
  {"dplpfl", 0}, // subroutine
  {"dplpmn", 0}, // subroutine
  {"dplpmu", 0}, // subroutine
  {"dplpup", 0}, // subroutine
  {"dpnnzr", 0}, // subroutine
  {"dpofs", 0}, // subroutine
  {"dpolcf", 0}, // subroutine
  {"dpolft", 0}, // subroutine
  {"dpolvl", 0}, // subroutine
  {"dpopt", 0}, // subroutine
  {"dpperm", 0}, // subroutine
  {"dppgq8", 0}, // subroutine
  {"dprvec", 0}, // real*8 function
  {"dprwpg", 0}, // subroutine
  {"dprwvr", 0}, // subroutine
  {"dpsixn", 0}, // real*8 function
  {"dpsort", 0}, // subroutine
  {"dqdota", 0}, // real*8 function
  {"dqdoti", 0}, // real*8 function
  {"dqform", 0}, // subroutine
  {"dqrfac", 0}, // subroutine
  {"dqrslv", 0}, // subroutine
  {"drc3jj", 0}, // subroutine
  {"drc3jm", 0}, // subroutine
  {"drc6j", 0}, // subroutine
  {"drc", 0}, // real*8 function
  {"drd", 0}, // real*8 function
  {"dreadp", 0}, // subroutine
  {"dreort", 0}, // subroutine
  {"drf", 0}, // real*8 function
  {"drj", 0}, // real*8 function
  {"drkfs", 0}, // subroutine
  {"dsort", 0}, // subroutine
  {"dsoseq", 0}, // subroutine
  {"dsos", 0}, // subroutine
  {"dsossl", 0}, // subroutine
  {"dsplp", 0}, // subroutine
  {"dstor1", 0}, // subroutine
  {"dstway", 0}, // subroutine
  {"dsuds", 0}, // subroutine
  {"du11ls", 0}, // subroutine
  {"du11us", 0}, // subroutine
  {"du12ls", 0}, // subroutine
  {"du12us", 0}, // subroutine
  {"dulsia", 0}, // subroutine
  {"dusrmt", 0}, // subroutine
  {"dvecs", 0}, // subroutine
  {"dvnrms", 0}, // real*8 function
  {"dwnlit", 0}, // subroutine
  {"dwnlsm", 0}, // subroutine
  {"dwnlt1", 0}, // subroutine
  {"dwnlt2", 0}, // logical*4 function
  {"dwnlt3", 0}, // subroutine
  {"dwnnls", 0}, // subroutine
  {"dwritp", 0}, // subroutine
  {"dwupdt", 0}, // subroutine
  {"dx4", 0}, // subroutine
  {"dxadj", 0}, // subroutine
  {"dxc210", 0}, // subroutine
  {"dx", 0}, // subroutine
  {"dxpsi", 0}, // real*8 function
  {"dxred", 0}, // subroutine
  {"dy4", 0}, // subroutine
  {"dyairy", 0}, // subroutine
  {"dy", 0}, // subroutine
  {"efcmn", 0}, // subroutine
  {"fcmn", 0}, // subroutine
  {"fdjac3", 0}, // subroutine
  {"fdump", 0}, // subroutine
  {"fftdoc", 0}, // subroutine
  {"fulmat", 0}, // subroutine
  {"fzero", 0}, // subroutine
  {"gamrn", 0}, // real*4 function
  {"gaus8", 0}, // subroutine
  {"h12", 0}, // subroutine
  {"hfti", 0}, // subroutine
  {"hkseq", 0}, // subroutine
  {"hpperm", 0}, // subroutine
  {"hpsort", 0}, // subroutine
  {"hstart", 0}, // subroutine
  {"hstcs1", 0}, // subroutine
  {"hvnrm", 0}, // function
  {"hwscs1", 0}, // subroutine
  {"hwsss1", 0}, // subroutine
  {"i1merg", 0}, // subroutine
  {"idloc", 0}, // integer*4 function
  {"indxa", 0}, // subroutine
  {"indxb", 0}, // subroutine
  {"indxc", 0}, // subroutine
  {"inxca", 0}, // subroutine
  {"inxcb", 0}, // subroutine
  {"inxcc", 0}, // subroutine
  {"iploc", 0}, // integer*4 function
  {"ipperm", 0}, // subroutine
  {"ipsort", 0}, // subroutine
  {"isort", 0}, // subroutine
  {"jairy", 0}, // subroutine
  {"llsia", 0}, // subroutine
  {"lpdp", 0}, // subroutine
  {"lsei", 0}, // subroutine
  {"lsi", 0}, // subroutine
  {"lssods", 0}, // subroutine
  {"lssuds", 0}, // subroutine
  {"macon", 0}, // subroutine
  {"mgsbv", 0}, // subroutine
  {"minso4", 0}, // subroutine
  {"minsol", 0}, // subroutine
  {"mpadd2", 0}, // subroutine
  {"mpadd3", 0}, // subroutine
  {"mpadd", 0}, // subroutine
  {"mpblas", 0}, // subroutine
  {"mpcdm", 0}, // subroutine
  {"mpchk", 0}, // subroutine
  {"mpcmd", 0}, // subroutine
  {"mpdivi", 0}, // subroutine
  {"mperr", 0}, // subroutine
  {"mpmaxr", 0}, // subroutine
  {"mpmlp", 0}, // subroutine
  {"mpmul2", 0}, // subroutine
  {"mpmul", 0}, // subroutine
  {"mpmuli", 0}, // subroutine
  {"mpnzr", 0}, // subroutine
  {"mpovfl", 0}, // subroutine
  {"mpstr", 0}, // subroutine
  {"mpunfl", 0}, // subroutine
  {"numxer", 0}, // function
  {"ohtrol", 0}, // subroutine
  {"ohtror", 0}, // subroutine
  {"ortho4", 0}, // subroutine
  {"orthog", 0}, // subroutine
  {"orthol", 0}, // subroutine
  {"orthor", 0}, // subroutine
  {"pchngs", 0}, // subroutine
  {"pcoef", 0}, // subroutine
  {"pgsf", 0}, // function
  {"pimach", 0}, // function
  {"pinitm", 0}, // subroutine
  {"pnnzrs", 0}, // subroutine
  {"poisd2", 0}, // subroutine
  {"poisn2", 0}, // subroutine
  {"poisp2", 0}, // subroutine
  {"polcof", 0}, // subroutine
  {"polfit", 0}, // subroutine
  {"polint", 0}, // subroutine
  {"polyvl", 0}, // subroutine
  {"pos3d1", 0}, // subroutine
  {"postg2", 0}, // subroutine
  {"ppadd", 0}, // subroutine
  {"ppgq8", 0}, // subroutine
  {"ppgsf", 0}, // function
  {"pppsf", 0}, // function
  {"ppsgf", 0}, // function
  {"ppspf", 0}, // function
  {"proc", 0}, // subroutine
  {"procp", 0}, // subroutine
  {"prod", 0}, // subroutine
  {"prodp", 0}, // subroutine
  {"prvec", 0}, // function
  {"prwpge", 0}, // subroutine
  {"prwvir", 0}, // subroutine
  {"psgf", 0}, // function
  {"psifn", 0}, // subroutine
  {"psixn", 0}, // function
  {"pvalue", 0}, // subroutine
  {"pythag", 0}, // real*4 function
  {"rc3jj", 0}, // subroutine
  {"rc3jm", 0}, // subroutine
  {"rc6j", 0}, // subroutine
  {"rc", 0}, // real*4 function
  {"rd", 0}, // real*4 function
  {"reort", 0}, // subroutine
  {"rf", 0}, // real*4 function
  {"rj", 0}, // real*4 function
  {"rpqr79", 0}, // subroutine
  {"rpzero", 0}, // subroutine
  {"s1merg", 0}, // subroutine
  {"sbocls", 0}, // subroutine
  {"sbols", 0}, // subroutine
  {"sbolsm", 0}, // subroutine
  {"sclosm", 0}, // subroutine
  {"scoef", 0}, // subroutine
  {"scov", 0}, // subroutine
  {"sgeev", 0}, // subroutine
  {"sgefs", 0}, // subroutine
  {"sgeir", 0}, // subroutine
  {"sglss", 0}, // subroutine
  {"snbco", 0}, // subroutine
  {"snbdi", 0}, // subroutine
  {"snbfa", 0}, // subroutine
  {"snbfs", 0}, // subroutine
  {"snbir", 0}, // subroutine
  {"snbsl", 0}, // subroutine
  {"snls1e", 0}, // subroutine
  {"snls1", 0}, // subroutine
  {"snsqe", 0}, // subroutine
  {"snsq", 0}, // subroutine
  {"sods", 0}, // subroutine
  {"sopenm", 0}, // subroutine
  {"soseqs", 0}, // subroutine
  {"sos", 0}, // subroutine
  {"sossol", 0}, // subroutine
  {"speli4", 0}, // subroutine
  {"spelip", 0}, // subroutine
  {"spincw", 0}, // subroutine
  {"spinit", 0}, // subroutine
  {"splpce", 0}, // subroutine
  {"splpdm", 0}, // subroutine
  {"splp", 0}, // subroutine
  {"splpfe", 0}, // subroutine
  {"splpfl", 0}, // subroutine
  {"splpmn", 0}, // subroutine
  {"splpmu", 0}, // subroutine
  {"splpup", 0}, // subroutine
  {"spofs", 0}, // subroutine
  {"spoir", 0}, // subroutine
  {"spopt", 0}, // subroutine
  {"spperm", 0}, // subroutine
  {"spsort", 0}, // subroutine
  {"sreadp", 0}, // subroutine
  {"ssiev", 0}, // subroutine
  {"ssort", 0}, // subroutine
  {"stor1", 0}, // subroutine
  {"stway", 0}, // subroutine
  {"suds", 0}, // subroutine
  {"svecs", 0}, // subroutine
  {"swritp", 0}, // subroutine
  {"tevlc", 0}, // subroutine
  {"tevls", 0}, // subroutine
  {"tri3", 0}, // subroutine
  {"tridq", 0}, // subroutine
  {"tris4", 0}, // subroutine
  {"trisp", 0}, // subroutine
  {"trix", 0}, // subroutine
  {"u11ls", 0}, // subroutine
  {"u11us", 0}, // subroutine
  {"u12ls", 0}, // subroutine
  {"u12us", 0}, // subroutine
  {"ulsia", 0}, // subroutine
  {"usrmat", 0}, // subroutine
  {"vnwrms", 0}, // real*4 function
  {"wnlit", 0}, // subroutine
  {"wnlsm", 0}, // subroutine
  {"wnlt1", 0}, // subroutine
  {"wnlt2", 0}, // logical*4 function
  {"wnlt3", 0}, // subroutine
  {"wnnls", 0}, // subroutine
  {"xadj", 0}, // subroutine
  {"xc210", 0}, // subroutine
  {"xpsi", 0}, // real*4 function
  {"xred", 0}, // subroutine
  {"yairy", 0}, // subroutine
  {NULL, 0}
};

static struct {
  int_4 npp_, k_, nm_, ncmplx_, ik_;
  real_4 eps_, cnv_, machep_;
} ccblk_;
static struct {
  int_4 npp_, k_, nm_, ncmplx_, ik_;
  real_4 eps_, cnv_, machep_;
} cblkt_;
static struct {
  int_4 kswx_, kswy_, k_, l_, mit_, nit_, is_, ms_, js_, ns_;
  real_4 ait_, bit_, cit_, dit_, dlx_, dly_, tdlx3_, tdly3_, dlx4_, dly4_;
} spl4_;
static struct {
  int_4 kswx_, kswy_, k_, l_, mit_, nit_, is_, ms_, js_, ns_;
  real_4 ait_, bit_, cit_, dit_, dlx_, dly_, tdlx3_, tdly3_, dlx4_, dly4_;
} splpcm_;
static struct {
  int_4 lpar_;
  real_8 eps_, fouru_, sqovfl_, sru_, twou_, uro_;
} dml5mc_;
static struct {
  int_4 icoco_, indpvt_, integ_, mxnon_, ndisk_, neq_, neqivp_, nfcc_, nic_, nopg_, nps_, ntape_, ntp_, numort_, nxpts_, 
  lnfcc_;
  real_8 ae_, re_, tol_;
} dml18j_;
static struct {
  int_4 lp_, lenl_, lenu_, ncp_, lrow_, lcol_;
  real_8 small_;
} la05dd_;
static struct {
  int_4 mpb_, mpt_, mpm_, mplun_, mpmxr_, mpr_[30], b_, t_, m_, lun_, mxr_, r_[30];
} mpcom_;
static struct {
  int_4 igofx_, inhomo_, ivp_, ncompd_, nfc_, ncomp_;
  real_8 c_, xsav_;
} dml8sz_;
static struct {
  int_4 info_[15], istkop_, knswot_, kop_, lotjp_, mnswot_, nswot_;
  real_8 pwcnd_, px_, tnd_, x_, xbeg_, xend_, xop_, xot_;
} dml15t_;
static struct {
  int_4 l_, l2_, kmax_;
  real_8 radix_, radixl_, rad2l_, dlg10r_;
} dxblk2_;
static struct {
  int_4 nlg102_, mlg102_, lg102_[21];
} dxblk3_;
static struct {
  int_4 lpar_;
  real_4 uro_, sru_, eps_, sqovfl_, twou_, fouru_;
} ml5mco_;
static struct {
  int_4 nxpts_, nic_, nopg_, mxnon_, ndisk_, ntape_, neq_, indpvt_, integ_, nps_, ntp_, neqivp_, numort_, nfcc_, icoco_, 
  lnfcc_;
  real_4 ae_, re_, tol_;
} ml18jr_;
static struct {
  int_4 igofx_, inhomo_, ivp_, ncompd_, nfc_, ncomp_;
  real_4 c_, xsav_;
} ml8sz_;
static struct {
  int_4 info_[15], istkop_, knswot_, kop_, lotjp_, mnswot_, nswot_;
  real_4 px_, pwcnd_, tnd_, x_, xbeg_, xend_, xot_, xop_;
} ml15to_;
static struct {
  int_4 lp_, lenl_, lenu_, ncp_, lrow_, lcol_;
  real_4 small_;
} la05ds_;
static struct {
  int_4 l_, l2_, kmax_;
  real_4 radix_, radixl_, rad2l_, dlg10r_;
} xblk2_;
static struct {
  int_4 nlg102_, mlg102_, lg102_[21];
} xblk3_;
prototype int_4 _aaaaaa (char _p_ ver_);
prototype int_4 _asyik (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ kode_, real_4 _p_ flgik_, real_4 _p_ ra_, real_4 _p_ 
arg_, int_4 _p_ in_, real_4 _p_ y_);
prototype int_4 _asyjy (int_4 (*_funjy)(), real_4 _p_ x_, real_4 _p_ fnu_, real_4 _p_ flgjy_, int_4 _p_ in_, real_4 _p_ 
y_, real_4 _p_ wk_, int_4 _p_ iflw_);
prototype int_4 _avint (real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ n_, real_4 _p_ xlo_, real_4 _p_ xup_, real_4 _p_ ans_, 
int_4 _p_ ierr_);
prototype real_4 _bcrh (real_4 _p_ xll_, real_4 _p_ xrr_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_, 
real_4 (*_f)(), real_4 _p_ sgn_);
prototype int_4 _bdiff (int_4 _p_ l_, real_4 _p_ v_);
prototype int_4 _bksol (int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ x_);
prototype int_4 _blktr1 (int_4 _p_ n_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, int_4 _p_ m_, real_4 _p_ am_, 
real_4 _p_ bm_, real_4 _p_ cm_, int_4 _p_ idimy_, real_4 _p_ y_, real_4 _p_ b_, real_4 _p_ w1_, real_4 _p_ w2_, real_4 
_p_ w3_, real_4 _p_ wd_, real_4 _p_ ww_, real_4 _p_ wu_, int_4 (*_prdct)(), int_4 (*_cprdct)());
prototype int_4 _bndacc (real_4 _p_ g_, int_4 _p_ mdg_, int_4 _p_ nb_, int_4 _p_ ip_, int_4 _p_ ir_, int_4 _p_ mt_, 
int_4 _p_ jt_);
prototype int_4 _bndsol (int_4 _p_ mode_, real_4 _p_ g_, int_4 _p_ mdg_, int_4 _p_ nb_, int_4 _p_ ip_, int_4 _p_ ir_, 
real_4 _p_ x_, int_4 _p_ n_, real_4 _p_ rnorm_);
prototype int_4 _bsgq8 (real_4 (*_fun)(), real_4 _p_ xt_, real_4 _p_ bc_, int_4 _p_ n_, int_4 _p_ kk_, int_4 _p_ id_, 
real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ inbv_, real_4 _p_ err_, real_4 _p_ ans_, int_4 _p_ ierr_, real_4 _p_ work_);
prototype int_4 _bsplvd (real_4 _p_ t_, int_4 _p_ k_, real_4 _p_ x_, int_4 _p_ ileft_, real_4 _p_ vnikx_, int_4 _p_ 
nderiv_);
prototype int_4 _bsplvn (real_4 _p_ t_, int_4 _p_ jhigh_, int_4 _p_ index_, real_4 _p_ x_, int_4 _p_ ileft_, real_4 _p_ 
vnikx_);
prototype real_4 _bsrh (real_4 _p_ xll_, real_4 _p_ xrr_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_, 
real_4 (*_f)(), real_4 _p_ sgn_);
prototype int_4 _c1merg (complex_8 _p_ tcos_, int_4 _p_ i1_, int_4 _p_ m1_, int_4 _p_ i2_, int_4 _p_ m2_, int_4 _p_ i3_
);
prototype int_4 _casyi (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ 
nz_, real_4 _p_ rl_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_);
prototype int_4 _cblkt1 (int_4 _p_ n_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, int_4 _p_ m_, complex_8 _p_ am_, 
complex_8 _p_ bm_, complex_8 _p_ cm_, int_4 _p_ idimy_, complex_8 _p_ y_, real_4 _p_ b_, complex_8 _p_ w1_, complex_8 
_p_ w2_, complex_8 _p_ w3_, complex_8 _p_ wd_, complex_8 _p_ ww_, complex_8 _p_ wu_, int_4 (*_prdct)(), int_4 
(*_cprdct)());
prototype int_4 _ccmpb (int_4 _p_ n_, int_4 _p_ ierror_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, real_4 _p_ b_, 
real_4 _p_ ah_, real_4 _p_ bh_);
prototype int_4 _cfod (int_4 _p_ meth_, real_4 _p_ elco_, real_4 _p_ tesco_);
prototype int_4 _cgeev (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ e_, real_4 _p_ v_, int_4 _p_ ldv_, 
real_4 _p_ work_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _cgefs (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ 
ind_, complex_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _cgeir (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ 
ind_, complex_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _chiev (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ e_, real_4 _p_ v_, int_4 _p_ ldv_, 
real_4 _p_ work_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _chkpr4 (int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ 
c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, int_4 (*_cofx)(), int_4 _p_ idmn_, int_4 _p_ ierror_);
prototype int_4 _chkprm (int_4 _p_ intl_, int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ 
mbdcnd_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, int_4 (*_cofx)(), int_4 (*_cofy)(), int_4 _p_ 
idmn_, int_4 _p_ ierror_);
prototype int_4 _chksn4 (int_4 _p_ mbdcnd_, int_4 _p_ nbdcnd_, real_4 _p_ alpha_, real_4 _p_ beta_, int_4 (*_cofx)(), 
logical_4 _p_ singlr_);
prototype int_4 _chksng (int_4 _p_ mbdcnd_, int_4 _p_ nbdcnd_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ gama_, 
real_4 _p_ xnu_, int_4 (*_cofx)(), int_4 (*_cofy)(), logical_4 _p_ singlr_);
prototype int_4 _cmpcsg (int_4 _p_ n_, int_4 _p_ ijump_, real_4 _p_ fnum_, real_4 _p_ fden_, complex_8 _p_ a_);
prototype int_4 _cmposd (int_4 _p_ mr_, int_4 _p_ nr_, int_4 _p_ istag_, complex_8 _p_ ba_, complex_8 _p_ bb_, 
complex_8 _p_ bc_, complex_8 _p_ q_, int_4 _p_ idimq_, complex_8 _p_ b_, complex_8 _p_ w_, complex_8 _p_ d_, complex_8 
_p_ tcos_, complex_8 _p_ p_);
prototype int_4 _cmposn (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ istag_, int_4 _p_ mixbnd_, complex_8 _p_ a_, complex_8 
_p_ bb_, complex_8 _p_ c_, complex_8 _p_ q_, int_4 _p_ idimq_, complex_8 _p_ b_, complex_8 _p_ b2_, complex_8 _p_ b3_, 
complex_8 _p_ w_, complex_8 _p_ w2_, complex_8 _p_ w3_, complex_8 _p_ d_, complex_8 _p_ tcos_, complex_8 _p_ p_);
prototype int_4 _cmposp (int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, complex_8 _p_ bb_, complex_8 _p_ c_, complex_8 
_p_ q_, int_4 _p_ idimq_, complex_8 _p_ b_, complex_8 _p_ b2_, complex_8 _p_ b3_, complex_8 _p_ w_, complex_8 _p_ w2_, 
complex_8 _p_ w3_, complex_8 _p_ d_, complex_8 _p_ tcos_, complex_8 _p_ p_);
prototype int_4 _cmptr3 (int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, complex_8 _p_ c_, int_4 _p_ k_, complex_8 
_p_ y1_, complex_8 _p_ y2_, complex_8 _p_ y3_, complex_8 _p_ tcos_, complex_8 _p_ d_, complex_8 _p_ w1_, complex_8 _p_ 
w2_, complex_8 _p_ w3_);
prototype int_4 _cmptrx (int_4 _p_ idegbr_, int_4 _p_ idegcr_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, 
complex_8 _p_ c_, complex_8 _p_ y_, complex_8 _p_ tcos_, complex_8 _p_ d_, complex_8 _p_ w_);
prototype int_4 _cnbco (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_
, real_4 _p_ rcond_, complex_8 _p_ z_);
prototype int_4 _cnbdi (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_
, complex_8 _p_ det_);
prototype int_4 _cnbfa (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_
, int_4 _p_ info_);
prototype int_4 _cnbfs (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, complex_8 _p_ 
v_, int_4 _p_ itask_, int_4 _p_ ind_, complex_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _cnbir (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, complex_8 _p_ 
v_, int_4 _p_ itask_, int_4 _p_ ind_, complex_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _cnbsl (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_
, complex_8 _p_ b_, int_4 _p_ job_);
prototype int_4 _compb (int_4 _p_ n_, int_4 _p_ ierror_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, real_4 _p_ b_, 
real_4 _p_ ah_, real_4 _p_ bh_);
prototype int_4 _cosgen (int_4 _p_ n_, int_4 _p_ ijump_, real_4 _p_ fnum_, real_4 _p_ fden_, real_4 _p_ a_);
prototype int_4 _cpadd (int_4 _p_ n_, int_4 _p_ ierror_, real_4 _p_ a_, real_4 _p_ c_, complex_8 _p_ cbp_, real_4 _p_ 
bp_, real_4 _p_ bh_);
prototype int_4 _cpevl (int_4 _p_ n_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ z_, complex_8 _p_ c_, complex_8 _p_ 
b_, logical_4 _p_ kbd_);
prototype int_4 _cpevlr (int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ c_);
prototype int_4 _cpofs (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ 
ind_, complex_8 _p_ work_);
prototype int_4 _cpoir (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ 
ind_, complex_8 _p_ work_);
prototype int_4 _cpqr79 (int_4 _p_ ndeg_, complex_8 _p_ coeff_, complex_8 _p_ root_, int_4 _p_ ierr_, real_4 _p_ work_)
;
prototype int_4 _cproc (int_4 _p_ nd_, complex_8 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ 
bm2_, int_4 _p_ na_, real_4 _p_ aa_, complex_8 _p_ x_, complex_8 _p_ y_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ 
b_, complex_8 _p_ c_, complex_8 _p_ d_, complex_8 _p_ w_, real_4 _p_ yy_);
prototype int_4 _cprocp (int_4 _p_ nd_, complex_8 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ 
bm2_, int_4 _p_ na_, real_4 _p_ aa_, complex_8 _p_ x_, complex_8 _p_ y_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ 
b_, complex_8 _p_ c_, complex_8 _p_ d_, complex_8 _p_ u_, real_4 _p_ yy_);
prototype int_4 _cprod (int_4 _p_ nd_, complex_8 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ 
bm2_, int_4 _p_ na_, real_4 _p_ aa_, real_4 _p_ x_, real_4 _p_ yy_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 
_p_ c_, complex_8 _p_ d_, complex_8 _p_ w_, complex_8 _p_ y_);
prototype int_4 _cprodp (int_4 _p_ nd_, complex_8 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ 
bm2_, int_4 _p_ na_, real_4 _p_ aa_, real_4 _p_ x_, real_4 _p_ yy_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 
_p_ c_, complex_8 _p_ d_, complex_8 _p_ u_, complex_8 _p_ y_);
prototype int_4 _cpzero (int_4 _p_ in_, complex_8 _p_ a_, complex_8 _p_ r_, complex_8 _p_ t_, int_4 _p_ iflg_, real_4 
_p_ s_);
prototype int_4 _crati (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ n_, complex_8 _p_ cy_, real_4 _p_ tol_);
prototype int_4 _cs1s2 (complex_8 _p_ zr_, complex_8 _p_ s1_, complex_8 _p_ s2_, int_4 _p_ nz_, real_4 _p_ ascle_, 
real_4 _p_ alim_, int_4 _p_ iuf_);
prototype int_4 _cscale (real_4 _p_ a_, int_4 _p_ nrda_, int_4 _p_ nrow_, int_4 _p_ ncol_, real_4 _p_ cols_, real_4 _p_ 
colsav_, real_4 _p_ rows_, real_4 _p_ rowsav_, real_4 _p_ anorm_, real_4 _p_ scales_, int_4 _p_ iscale_, int_4 _p_ ic_)
;
prototype int_4 _cshch (complex_8 _p_ z_, complex_8 _p_ csh_, complex_8 _p_ cch_);
prototype int_4 _cuchk (complex_8 _p_ y_, int_4 _p_ nz_, real_4 _p_ ascle_, real_4 _p_ tol_);
prototype int_4 _cunhj (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ ipmtr_, real_4 _p_ tol_, complex_8 _p_ phi_, 
complex_8 _p_ arg_, complex_8 _p_ zeta1_, complex_8 _p_ zeta2_, complex_8 _p_ asum_, complex_8 _p_ bsum_);
prototype int_4 _cunik (complex_8 _p_ zr_, real_4 _p_ fnu_, int_4 _p_ ikflg_, int_4 _p_ ipmtr_, real_4 _p_ tol_, int_4 
_p_ init_, complex_8 _p_ phi_, complex_8 _p_ zeta1_, complex_8 _p_ zeta2_, complex_8 _p_ sum_, complex_8 _p_ cwrk_);
prototype real_4 _cv (real_4 _p_ xval_, int_4 _p_ ndata_, int_4 _p_ nconst_, int_4 _p_ nord_, int_4 _p_ nbkpt_, real_4 
_p_ bkpt_, real_4 _p_ w_);
prototype int_4 _d1merg (real_8 _p_ tcos_, int_4 _p_ i1_, int_4 _p_ m1_, int_4 _p_ i2_, int_4 _p_ m2_, int_4 _p_ i3_);
prototype int_4 _d1mpyq (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ v_, real_8 _p_ w_);
prototype int_4 _d1updt (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ s_, int_4 _p_ ls_, real_8 _p_ u_, real_8 _p_ v_, real_8 
_p_ w_, logical_4 _p_ sing_);
prototype int_4 _dasyik (real_8 _p_ x_, real_8 _p_ fnu_, int_4 _p_ kode_, real_8 _p_ flgik_, real_8 _p_ ra_, real_8 _p_ 
arg_, int_4 _p_ in_, real_8 _p_ y_);
prototype int_4 _davint (real_8 _p_ x_, real_8 _p_ y_, int_4 _p_ n_, real_8 _p_ xlo_, real_8 _p_ xup_, real_8 _p_ ans_, 
int_4 _p_ ierr_);
prototype int_4 _dbdiff (int_4 _p_ l_, real_8 _p_ v_);
prototype int_4 _dbksol (int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ x_);
prototype int_4 _dbndac (real_8 _p_ g_, int_4 _p_ mdg_, int_4 _p_ nb_, int_4 _p_ ip_, int_4 _p_ ir_, int_4 _p_ mt_, 
int_4 _p_ jt_);
prototype int_4 _dbndsl (int_4 _p_ mode_, real_8 _p_ g_, int_4 _p_ mdg_, int_4 _p_ nb_, int_4 _p_ ip_, int_4 _p_ ir_, 
real_8 _p_ x_, int_4 _p_ n_, real_8 _p_ rnorm_);
prototype int_4 _dbocls (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ mcon_, int_4 _p_ mrows_, int_4 _p_ ncols_, real_8 _p_ 
bl_, real_8 _p_ bu_, int_4 _p_ ind_, int_4 _p_ iopt_, real_8 _p_ x_, real_8 _p_ rnormc_, real_8 _p_ rnorm_, int_4 _p_ 
mode_, real_8 _p_ rw_, int_4 _p_ iw_);
prototype int_4 _dbols (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ mrows_, int_4 _p_ ncols_, real_8 _p_ bl_, real_8 _p_ 
bu_, int_4 _p_ ind_, int_4 _p_ iopt_, real_8 _p_ x_, real_8 _p_ rnorm_, int_4 _p_ mode_, real_8 _p_ rw_, int_4 _p_ iw_)
;
prototype int_4 _dbolsm (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ minput_, int_4 _p_ ncols_, real_8 _p_ bl_, real_8 _p_ 
bu_, int_4 _p_ ind_, int_4 _p_ iopt_, real_8 _p_ x_, real_8 _p_ rnorm_, int_4 _p_ mode_, real_8 _p_ rw_, real_8 _p_ ww_
, real_8 _p_ scl_, int_4 _p_ ibasis_, int_4 _p_ ibb_);
prototype int_4 _dbsgq8 (real_8 (*_fun)(), real_8 _p_ xt_, real_8 _p_ bc_, int_4 _p_ n_, int_4 _p_ kk_, int_4 _p_ id_, 
real_8 _p_ a_, real_8 _p_ b_, int_4 _p_ inbv_, real_8 _p_ err_, real_8 _p_ ans_, int_4 _p_ ierr_, real_8 _p_ work_);
prototype int_4 _dcfod (int_4 _p_ meth_, real_8 _p_ elco_, real_8 _p_ tesco_);
prototype int_4 _dckder (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ 
ldfjac_, real_8 _p_ xp_, real_8 _p_ fvecp_, int_4 _p_ mode_, real_8 _p_ err_);
prototype int_4 _dcoef (real_8 _p_ yh_, real_8 _p_ yp_, int_4 _p_ ncomp_, int_4 _p_ nrowb_, int_4 _p_ nfc_, int_4 _p_ 
nic_, real_8 _p_ b_, real_8 _p_ beta_, real_8 _p_ coef_, int_4 _p_ inhomo_, real_8 _p_ re_, real_8 _p_ ae_, real_8 _p_ 
by_, real_8 _p_ cvec_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ iflag_, int_4 _p_ nfcc_);
prototype int_4 _dcov (int_4 (*_fcn)(), int_4 _p_ iopt_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, 
real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ info_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_);
prototype int_4 _dcscal (real_8 _p_ a_, int_4 _p_ nrda_, int_4 _p_ nrow_, int_4 _p_ ncol_, real_8 _p_ cols_, real_8 _p_ 
colsav_, real_8 _p_ rows_, real_8 _p_ rowsav_, real_8 _p_ anorm_, real_8 _p_ scales_, int_4 _p_ iscale_, int_4 _p_ ic_)
;
prototype real_8 _dcv (real_8 _p_ xval_, int_4 _p_ ndata_, int_4 _p_ nconst_, int_4 _p_ nord_, int_4 _p_ nbkpt_, real_8 
_p_ bkpt_, real_8 _p_ w_);
prototype int_4 _ddes (int_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ tout_, int_4 _p_ info_, 
real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ ypout_, real_8 _p_ yp_, real_8 _p_ yy_, real_8 _p_ wt_, 
real_8 _p_ p_, real_8 _p_ phi_, real_8 _p_ alpha_, real_8 _p_ beta_, real_8 _p_ psi_, real_8 _p_ v_, real_8 _p_ w_, 
real_8 _p_ sig_, real_8 _p_ g_, real_8 _p_ gi_, real_8 _p_ h_, real_8 _p_ eps_, real_8 _p_ x_, real_8 _p_ xold_, real_8 
_p_ hold_, real_8 _p_ told_, real_8 _p_ delsgn_, real_8 _p_ tstop_, real_8 _p_ twou_, real_8 _p_ fouru_, logical_4 _p_ 
start_, logical_4 _p_ phase1_, logical_4 _p_ nornd_, logical_4 _p_ stiff_, logical_4 _p_ intout_, int_4 _p_ ns_, int_4 
_p_ kord_, int_4 _p_ kold_, int_4 _p_ init_, int_4 _p_ ksteps_, int_4 _p_ kle4_, int_4 _p_ iquit_, int_4 _p_ kprev_, 
int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_8 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _ddoglg (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ lr_, real_8 _p_ diag_, real_8 _p_ qtb_, real_8 _p_ 
delta_, real_8 _p_ x_, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _defcmn (int_4 _p_ ndata_, real_8 _p_ xdata_, real_8 _p_ ydata_, real_8 _p_ sddata_, int_4 _p_ nord_, 
int_4 _p_ nbkpt_, real_8 _p_ bkptin_, int_4 _p_ mdein_, int_4 _p_ mdeout_, real_8 _p_ coeff_, real_8 _p_ bf_, real_8 
_p_ xtemp_, real_8 _p_ ptemp_, real_8 _p_ bkpt_, real_8 _p_ g_, int_4 _p_ mdg_, real_8 _p_ w_, int_4 _p_ mdw_, int_4 
_p_ lw_);
prototype int_4 _defe4 (int_4 (*_cofx)(), int_4 _p_ idmn_, real_4 _p_ usol_, real_4 _p_ grhs_);
prototype int_4 _defehl (int_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ h_, real_4 _p_ yp_, 
real_4 _p_ f1_, real_4 _p_ f2_, real_4 _p_ f3_, real_4 _p_ f4_, real_4 _p_ f5_, real_4 _p_ ys_, real_4 _p_ rpar_, int_4 
_p_ ipar_);
prototype int_4 _defer (int_4 (*_cofx)(), int_4 (*_cofy)(), int_4 _p_ idmn_, real_4 _p_ usol_, real_4 _p_ grhs_);
prototype real_8 _denorm (int_4 _p_ n_, real_8 _p_ x_);
prototype int_4 _derkfs (int_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ tout_, int_4 _p_ info_
, real_4 _p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ h_, real_4 _p_ tolfac_, real_4 _p_ yp_, real_4 _p_ 
f1_, real_4 _p_ f2_, real_4 _p_ f3_, real_4 _p_ f4_, real_4 _p_ f5_, real_4 _p_ ys_, real_4 _p_ told_, real_4 _p_ 
dtsign_, real_4 _p_ u26_, real_4 _p_ rer_, int_4 _p_ init_, int_4 _p_ ksteps_, int_4 _p_ kop_, int_4 _p_ iquit_, 
logical_4 _p_ stiff_, logical_4 _p_ nonstf_, int_4 _p_ ntstep_, int_4 _p_ nstifs_, real_4 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _des (int_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ tout_, int_4 _p_ info_, 
real_4 _p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ ypout_, real_4 _p_ yp_, real_4 _p_ yy_, real_4 _p_ wt_, 
real_4 _p_ p_, real_4 _p_ phi_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ psi_, real_4 _p_ v_, real_4 _p_ w_, 
real_4 _p_ sig_, real_4 _p_ g_, real_4 _p_ gi_, real_4 _p_ h_, real_4 _p_ eps_, real_4 _p_ x_, real_4 _p_ xold_, real_4 
_p_ hold_, real_4 _p_ told_, real_4 _p_ delsgn_, real_4 _p_ tstop_, real_4 _p_ twou_, real_4 _p_ fouru_, logical_4 _p_ 
start_, logical_4 _p_ phase1_, logical_4 _p_ nornd_, logical_4 _p_ stiff_, logical_4 _p_ intout_, int_4 _p_ ns_, int_4 
_p_ kord_, int_4 _p_ kold_, int_4 _p_ init_, int_4 _p_ ksteps_, int_4 _p_ kle4_, int_4 _p_ iquit_, int_4 _p_ kprev_, 
int_4 _p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_4 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _dfcmn (int_4 _p_ ndata_, real_8 _p_ xdata_, real_8 _p_ ydata_, real_8 _p_ sddata_, int_4 _p_ nord_, 
int_4 _p_ nbkpt_, real_8 _p_ bkptin_, int_4 _p_ nconst_, real_8 _p_ xconst_, real_8 _p_ yconst_, int_4 _p_ nderiv_, 
int_4 _p_ mode_, real_8 _p_ coeff_, real_8 _p_ bf_, real_8 _p_ xtemp_, real_8 _p_ ptemp_, real_8 _p_ bkpt_, real_8 _p_ 
g_, int_4 _p_ mdg_, real_8 _p_ w_, int_4 _p_ mdw_, real_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _dfdjc1 (int_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ 
ldfjac_, int_4 _p_ iflag_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ epsfcn_, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _dfdjc3 (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_
, int_4 _p_ ldfjac_, int_4 _p_ iflag_, real_8 _p_ epsfcn_, real_8 _p_ wa_);
prototype int_4 _dfehl (int_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ h_, real_8 _p_ yp_, 
real_8 _p_ f1_, real_8 _p_ f2_, real_8 _p_ f3_, real_8 _p_ f4_, real_8 _p_ f5_, real_8 _p_ ys_, real_8 _p_ rpar_, int_4 
_p_ ipar_);
prototype int_4 _dfspvd (real_8 _p_ t_, int_4 _p_ k_, real_8 _p_ x_, int_4 _p_ ileft_, real_8 _p_ vnikx_, int_4 _p_ 
nderiv_);
prototype int_4 _dfspvn (real_8 _p_ t_, int_4 _p_ jhigh_, int_4 _p_ index_, real_8 _p_ x_, int_4 _p_ ileft_, real_8 _p_ 
vnikx_);
prototype int_4 _dfulmt (int_4 _p_ i_, int_4 _p_ j_, real_8 _p_ aij_, int_4 _p_ indcat_, real_8 _p_ prgopt_, real_8 _p_ 
dattrv_, int_4 _p_ iflag_);
prototype int_4 _dfzero (real_8 (*_f)(), real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ r_, real_8 _p_ re_, real_8 _p_ ae_, 
int_4 _p_ iflag_);
prototype int_4 _dgaus8 (real_8 (*_fun)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ err_, real_8 _p_ ans_, int_4 _p_ 
ierr_);
prototype int_4 _dgefs (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
real_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _dglss (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, int_4 
_p_ nb_, real_8 _p_ rnorm_, real_8 _p_ work_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ info_);
prototype int_4 _dh12 (int_4 _p_ mode_, int_4 _p_ lpivot_, int_4 _p_ l1_, int_4 _p_ m_, real_8 _p_ u_, int_4 _p_ iue_, 
real_8 _p_ up_, real_8 _p_ c_, int_4 _p_ ice_, int_4 _p_ icv_, int_4 _p_ ncv_);
prototype int_4 _dhfti (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, int_4 
_p_ nb_, real_8 _p_ tau_, int_4 _p_ krank_, real_8 _p_ rnorm_, real_8 _p_ h_, real_8 _p_ g_, int_4 _p_ ip_);
prototype int_4 _dhstrt (int_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ y_, real_8 _p_ 
yprime_, real_8 _p_ etol_, int_4 _p_ morder_, real_8 _p_ small_, real_8 _p_ big_, real_8 _p_ spy_, real_8 _p_ pv_, 
real_8 _p_ yp_, real_8 _p_ sf_, real_8 _p_ rpar_, int_4 _p_ ipar_, real_8 _p_ h_);
prototype real_8 _dhvnrm (real_8 _p_ v_, int_4 _p_ ncomp_);
prototype int_4 _djairy (real_8 _p_ x_, real_8 _p_ rx_, real_8 _p_ c_, real_8 _p_ ai_, real_8 _p_ dai_);
prototype int_4 _dllsia (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, 
int_4 _p_ nb_, real_8 _p_ re_, real_8 _p_ ae_, int_4 _p_ key_, int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 
_p_ ksure_, real_8 _p_ rnorm_, real_8 _p_ w_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ info_);
prototype int_4 _dlpdp (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n1_, int_4 _p_ n2_, real_8 _p_ prgopt_, 
real_8 _p_ x_, real_8 _p_ wnorm_, int_4 _p_ mode_, real_8 _p_ ws_, int_4 _p_ is_);
prototype int_4 _dlsei (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ me_, int_4 _p_ ma_, int_4 _p_ mg_, int_4 _p_ n_, 
real_8 _p_ prgopt_, real_8 _p_ x_, real_8 _p_ rnorme_, real_8 _p_ rnorml_, int_4 _p_ mode_, real_8 _p_ ws_, int_4 _p_ 
ip_);
prototype int_4 _dlsi (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ ma_, int_4 _p_ mg_, int_4 _p_ n_, real_8 _p_ prgopt_, 
real_8 _p_ x_, real_8 _p_ rnorm_, int_4 _p_ mode_, real_8 _p_ ws_, int_4 _p_ ip_);
prototype int_4 _dlssud (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ b_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ nrda_, 
real_8 _p_ u_, int_4 _p_ nrdu_, int_4 _p_ iflag_, int_4 _p_ mlso_, int_4 _p_ irank_, int_4 _p_ iscale_, real_8 _p_ q_, 
real_8 _p_ diag_, int_4 _p_ kpivot_, real_8 _p_ s_, real_8 _p_ div_, real_8 _p_ td_, int_4 _p_ isflg_, real_8 _p_ 
scales_);
prototype int_4 _dmacon (void);
prototype int_4 _dmgsbv (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ ia_, int_4 _p_ niv_, int_4 _p_ iflag_, 
real_8 _p_ s_, real_8 _p_ p_, int_4 _p_ ip_, int_4 _p_ inhomo_, real_8 _p_ v_, real_8 _p_ w_, real_8 _p_ wcnd_);
prototype int_4 _dmpar (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ ipvt_, real_8 _p_ diag_, real_8 _p_ qtb_
, real_8 _p_ delta_, real_8 _p_ par_, real_8 _p_ x_, real_8 _p_ sigma_, real_8 _p_ wa1_, real_8 _p_ wa2_);
prototype int_4 _dnbco (real_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_8 _p_ rcond_, real_8 _p_ z_);
prototype int_4 _dnbdi (real_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_8 _p_ det_);
prototype int_4 _dnbfa (real_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
int_4 _p_ info_);
prototype int_4 _dnbfs (real_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ v_, 
int_4 _p_ itask_, int_4 _p_ ind_, real_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _dnbsl (real_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_8 _p_ b_, int_4 _p_ job_);
prototype int_4 _dnls1e (real_8 (*_fcn)(), int_4 _p_ iopt_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_
, real_8 _p_ tol_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ iw_, real_8 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _dnls1 (int_4 (*_fcn)(), int_4 _p_ iopt_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, 
real_8 _p_ fjac_, int_4 _p_ ldfjac_, real_8 _p_ ftol_, real_8 _p_ xtol_, real_8 _p_ gtol_, int_4 _p_ maxfev_, real_8 
_p_ epsfcn_, real_8 _p_ diag_, int_4 _p_ mode_, real_8 _p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_
, int_4 _p_ njev_, int_4 _p_ ipvt_, real_8 _p_ qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_
);
prototype int_4 _dnsqe (real_4 (*_fcn)(), int_4 (*_jac)(), int_4 _p_ iopt_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ 
fvec_, real_8 _p_ tol_, int_4 _p_ nprint_, int_4 _p_ info_, real_8 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _dnsq (int_4 (*_fcn)(), int_4 (*_jac)(), int_4 _p_ iopt_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_
, real_8 _p_ fjac_, int_4 _p_ ldfjac_, real_8 _p_ xtol_, int_4 _p_ maxfev_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ 
epsfcn_, real_8 _p_ diag_, int_4 _p_ mode_, real_8 _p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, 
int_4 _p_ njev_, real_8 _p_ r_, int_4 _p_ lr_, real_8 _p_ qtf_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, 
real_8 _p_ wa4_);
prototype int_4 _dohtrl (real_8 _p_ q_, int_4 _p_ n_, int_4 _p_ nrda_, real_8 _p_ diag_, int_4 _p_ irank_, real_8 _p_ 
div_, real_8 _p_ td_);
prototype int_4 _dorthr (real_8 _p_ a_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ nrda_, int_4 _p_ iflag_, int_4 _p_ irank_
, int_4 _p_ iscale_, real_8 _p_ diag_, int_4 _p_ kpivot_, real_8 _p_ scales_, real_8 _p_ rows_, real_8 _p_ rs_);
prototype int_4 _dp1vlu (int_4 _p_ l_, int_4 _p_ nder_, real_8 _p_ x_, real_8 _p_ yfit_, real_8 _p_ yp_, real_8 _p_ a_)
;
prototype int_4 _dpchng (int_4 _p_ ii_, real_8 _p_ xval_, int_4 _p_ iplace_, real_8 _p_ sx_, int_4 _p_ ix_, int_4 _p_ 
ircx_);
prototype int_4 _dpcoef (int_4 _p_ l_, real_8 _p_ c_, real_8 _p_ tc_, real_8 _p_ a_);
prototype int_4 _dpincw (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ npp_, int_4 _p_ 
jstrt_, int_4 _p_ ibasis_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 _p_ ind_, int_4 _p_ 
ibb_, real_8 _p_ costsc_, real_8 _p_ gg_, real_8 _p_ erdnrm_, real_8 _p_ dulnrm_, real_8 _p_ amat_, real_8 _p_ basmat_, 
real_8 _p_ csc_, real_8 _p_ wr_, real_8 _p_ ww_, real_8 _p_ rz_, real_8 _p_ rg_, real_8 _p_ costs_, real_8 _p_ colnrm_, 
real_8 _p_ duals_, logical_4 _p_ stpedg_);
prototype int_4 _dpinit (int_4 _p_ mrelas_, int_4 _p_ nvars_, real_8 _p_ costs_, real_8 _p_ bl_, real_8 _p_ bu_, int_4 
_p_ ind_, real_8 _p_ primal_, int_4 _p_ info_, real_8 _p_ amat_, real_8 _p_ csc_, real_8 _p_ costsc_, real_8 _p_ 
colnrm_, real_8 _p_ xlamda_, real_8 _p_ anorm_, real_8 _p_ rhs_, real_8 _p_ rhsnrm_, int_4 _p_ ibasis_, int_4 _p_ ibb_, 
int_4 _p_ imat_, logical_4 _p_ lopt_);
prototype int_4 _dpintm (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ sx_, int_4 _p_ ix_, int_4 _p_ lmx_, int_4 _p_ ipagef_);
prototype int_4 _dplint (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ c_);
prototype int_4 _dplpce (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ itlp_, int_4 
_p_ itbrc_, int_4 _p_ ibasis_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 _p_ ind_, int_4 
_p_ ibb_, real_8 _p_ erdnrm_, real_8 _p_ eps_, real_8 _p_ tune_, real_8 _p_ gg_, real_8 _p_ amat_, real_8 _p_ basmat_, 
real_8 _p_ csc_, real_8 _p_ wr_, real_8 _p_ ww_, real_8 _p_ primal_, real_8 _p_ erd_, real_8 _p_ erp_, logical_4 _p_ 
singlr_, logical_4 _p_ redbas_);
prototype int_4 _dplpdm (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ nredc_, int_4 
_p_ info_, int_4 _p_ iopt_, int_4 _p_ ibasis_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 
_p_ ind_, int_4 _p_ ibb_, real_8 _p_ anorm_, real_8 _p_ eps_, real_8 _p_ uu_, real_8 _p_ gg_, real_8 _p_ amat_, real_8 
_p_ basmat_, real_8 _p_ csc_, real_8 _p_ wr_, logical_4 _p_ singlr_, logical_4 _p_ redbas_);
prototype int_4 _dplpfe (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ ienter_, int_4 
_p_ ibasis_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 _p_ ind_, int_4 _p_ ibb_, real_8 
_p_ erdnrm_, real_8 _p_ eps_, real_8 _p_ gg_, real_8 _p_ dulnrm_, real_8 _p_ dirnrm_, real_8 _p_ amat_, real_8 _p_ 
basmat_, real_8 _p_ csc_, real_8 _p_ wr_, real_8 _p_ ww_, real_8 _p_ bl_, real_8 _p_ bu_, real_8 _p_ rz_, real_8 _p_ 
rg_, real_8 _p_ colnrm_, real_8 _p_ duals_, logical_4 _p_ found_);
prototype int_4 _dplpfl (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ ienter_, int_4 _p_ ileave_, int_4 _p_ ibasis_, 
int_4 _p_ ind_, int_4 _p_ ibb_, real_8 _p_ theta_, real_8 _p_ dirnrm_, real_8 _p_ rprnrm_, real_8 _p_ csc_, real_8 _p_ 
ww_, real_8 _p_ bl_, real_8 _p_ bu_, real_8 _p_ erp_, real_8 _p_ rprim_, real_8 _p_ primal_, logical_4 _p_ finite_, 
logical_4 _p_ zerolv_);
prototype int_4 _dplpmn (real_4 (*_dusrmt)(), int_4 _p_ mrelas_, int_4 _p_ nvars_, real_8 _p_ costs_, real_8 _p_ 
prgopt_, real_8 _p_ dattrv_, real_8 _p_ bl_, real_8 _p_ bu_, int_4 _p_ ind_, int_4 _p_ info_, real_8 _p_ primal_, 
real_8 _p_ duals_, real_8 _p_ amat_, real_8 _p_ csc_, real_8 _p_ colnrm_, real_8 _p_ erd_, real_8 _p_ erp_, real_8 _p_ 
basmat_, real_8 _p_ wr_, real_8 _p_ rz_, real_8 _p_ rg_, real_8 _p_ rprim_, real_8 _p_ rhs_, real_8 _p_ ww_, int_4 _p_ 
lmx_, int_4 _p_ lbm_, int_4 _p_ ibasis_, int_4 _p_ ibb_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ 
iwr_);
prototype int_4 _dplpmu (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ nredc_, int_4 
_p_ info_, int_4 _p_ ienter_, int_4 _p_ ileave_, int_4 _p_ iopt_, int_4 _p_ npp_, int_4 _p_ jstrt_, int_4 _p_ ibasis_, 
int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 _p_ ind_, int_4 _p_ ibb_, real_8 _p_ anorm_, 
real_8 _p_ eps_, real_8 _p_ uu_, real_8 _p_ gg_, real_8 _p_ rprnrm_, real_8 _p_ erdnrm_, real_8 _p_ dulnrm_, real_8 _p_ 
theta_, real_8 _p_ costsc_, real_8 _p_ xlamda_, real_8 _p_ rhsnrm_, real_8 _p_ amat_, real_8 _p_ basmat_, real_8 _p_ 
csc_, real_8 _p_ wr_, real_8 _p_ rprim_, real_8 _p_ ww_, real_8 _p_ bu_, real_8 _p_ bl_, real_8 _p_ rhs_, real_8 _p_ 
erd_, real_8 _p_ erp_, real_8 _p_ rz_, real_8 _p_ rg_, real_8 _p_ colnrm_, real_8 _p_ costs_, real_8 _p_ primal_, 
real_8 _p_ duals_, logical_4 _p_ singlr_, logical_4 _p_ redbas_, logical_4 _p_ zerolv_, logical_4 _p_ stpedg_);
prototype int_4 _dplpup (int_4 (*_dusrmt)(), int_4 _p_ mrelas_, int_4 _p_ nvars_, real_8 _p_ prgopt_, real_8 _p_ 
dattrv_, real_8 _p_ bl_, real_8 _p_ bu_, int_4 _p_ ind_, int_4 _p_ info_, real_8 _p_ amat_, int_4 _p_ imat_, logical_4 
_p_ sizeup_, real_8 _p_ asmall_, real_8 _p_ abig_);
prototype int_4 _dpnnzr (int_4 _p_ i_, real_8 _p_ xval_, int_4 _p_ iplace_, real_8 _p_ sx_, int_4 _p_ ix_, int_4 _p_ 
ircx_);
prototype int_4 _dpofs (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
real_8 _p_ work_);
prototype int_4 _dpolcf (real_8 _p_ xx_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ c_, real_8 _p_ d_, real_8 _p_ work_);
prototype int_4 _dpolft (int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ w_, int_4 _p_ maxdeg_, int_4 _p_ ndeg_, 
real_8 _p_ eps_, real_8 _p_ r_, int_4 _p_ ierr_, real_8 _p_ a_);
prototype int_4 _dpolvl (int_4 _p_ nder_, real_8 _p_ xx_, real_8 _p_ yfit_, real_8 _p_ yp_, int_4 _p_ n_, real_8 _p_ x_
, real_8 _p_ c_, real_8 _p_ work_, int_4 _p_ ierr_);
prototype int_4 _dpopt (real_8 _p_ prgopt_, int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ info_, real_8 _p_ csc_, 
int_4 _p_ ibasis_, real_8 _p_ ropt_, int_4 _p_ intopt_, logical_4 _p_ lopt_);
prototype int_4 _dpperm (real_8 _p_ dx_, int_4 _p_ n_, int_4 _p_ iperm_, int_4 _p_ ier_);
prototype int_4 _dppgq8 (real_8 (*_fun)(), int_4 _p_ ldc_, real_8 _p_ c_, real_8 _p_ xi_, int_4 _p_ lxi_, int_4 _p_ kk_
, int_4 _p_ id_, real_8 _p_ a_, real_8 _p_ b_, int_4 _p_ inppv_, real_8 _p_ err_, real_8 _p_ ans_, int_4 _p_ ierr_);
prototype real_8 _dprvec (int_4 _p_ m_, real_8 _p_ u_, real_8 _p_ v_);
prototype int_4 _dprwpg (int_4 _p_ key_, int_4 _p_ ipage_, int_4 _p_ lpg_, real_8 _p_ sx_, int_4 _p_ ix_);
prototype int_4 _dprwvr (int_4 _p_ key_, int_4 _p_ ipage_, int_4 _p_ lpg_, real_8 _p_ sx_, int_4 _p_ ix_);
prototype real_8 _dpsixn (int_4 _p_ n_);
prototype int_4 _dpsort (real_8 _p_ dx_, int_4 _p_ n_, int_4 _p_ iperm_, int_4 _p_ kflag_, int_4 _p_ ier_);
prototype real_8 _dqdota (int_4 _p_ n_, real_8 _p_ db_, int_4 _p_ qc_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, 
int_4 _p_ incy_);
prototype real_8 _dqdoti (int_4 _p_ n_, real_8 _p_ db_, int_4 _p_ qc_, real_8 _p_ dx_, int_4 _p_ incx_, real_8 _p_ dy_, 
int_4 _p_ incy_);
prototype int_4 _dqform (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ q_, int_4 _p_ ldq_, real_8 _p_ wa_);
prototype int_4 _dqrfac (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, logical_4 _p_ pivot_, int_4 _p_ 
ipvt_, int_4 _p_ lipvt_, real_8 _p_ sigma_, real_8 _p_ acnorm_, real_8 _p_ wa_);
prototype int_4 _dqrslv (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, int_4 _p_ ipvt_, real_8 _p_ diag_, real_8 _p_ 
qtb_, real_8 _p_ x_, real_8 _p_ sigma_, real_8 _p_ wa_);
prototype int_4 _drc3jj (real_8 _p_ l2_, real_8 _p_ l3_, real_8 _p_ m2_, real_8 _p_ m3_, real_8 _p_ l1min_, real_8 _p_ 
l1max_, real_8 _p_ thrcof_, int_4 _p_ ndim_, int_4 _p_ ier_);
prototype int_4 _drc3jm (real_8 _p_ l1_, real_8 _p_ l2_, real_8 _p_ l3_, real_8 _p_ m1_, real_8 _p_ m2min_, real_8 _p_ 
m2max_, real_8 _p_ thrcof_, int_4 _p_ ndim_, int_4 _p_ ier_);
prototype int_4 _drc6j (real_8 _p_ l2_, real_8 _p_ l3_, real_8 _p_ l4_, real_8 _p_ l5_, real_8 _p_ l6_, real_8 _p_ 
l1min_, real_8 _p_ l1max_, real_8 _p_ sixcof_, int_4 _p_ ndim_, int_4 _p_ ier_);
prototype real_8 _drc (real_8 _p_ x_, real_8 _p_ y_, int_4 _p_ ier_);
prototype real_8 _drd (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ z_, int_4 _p_ ier_);
prototype int_4 _dreadp (int_4 _p_ ipage_, int_4 _p_ list_, real_8 _p_ rlist_, int_4 _p_ lpage_, int_4 _p_ irec_);
prototype int_4 _dreort (int_4 _p_ ncomp_, real_8 _p_ y_, real_8 _p_ yp_, real_8 _p_ yhp_, int_4 _p_ niv_, real_8 _p_ 
w_, real_8 _p_ s_, real_8 _p_ p_, int_4 _p_ ip_, real_8 _p_ stowa_, int_4 _p_ iflag_);
prototype real_8 _drf (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ z_, int_4 _p_ ier_);
prototype real_8 _drj (real_8 _p_ x_, real_8 _p_ y_, real_8 _p_ z_, real_8 _p_ p_, int_4 _p_ ier_);
prototype int_4 _drkfs (int_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ tout_, int_4 _p_ info_
, real_8 _p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ h_, real_8 _p_ tolfac_, real_8 _p_ yp_, real_8 _p_ 
f1_, real_8 _p_ f2_, real_8 _p_ f3_, real_8 _p_ f4_, real_8 _p_ f5_, real_8 _p_ ys_, real_8 _p_ told_, real_8 _p_ 
dtsign_, real_8 _p_ u26_, real_8 _p_ rer_, int_4 _p_ init_, int_4 _p_ ksteps_, int_4 _p_ kop_, int_4 _p_ iquit_, 
logical_4 _p_ stiff_, logical_4 _p_ nonstf_, int_4 _p_ ntstep_, int_4 _p_ nstifs_, real_8 _p_ rpar_, int_4 _p_ ipar_);
prototype int_4 _dsort (real_8 _p_ dx_, real_8 _p_ dy_, int_4 _p_ n_, int_4 _p_ kflag_);
prototype int_4 _dsoseq (real_8 (*_fnc)(), int_4 _p_ n_, real_8 _p_ s_, real_8 _p_ rtolx_, real_8 _p_ atolx_, real_8 
_p_ tolf_, int_4 _p_ iflag_, int_4 _p_ mxit_, int_4 _p_ ncjs_, int_4 _p_ nsrrc_, int_4 _p_ nsri_, int_4 _p_ iprint_, 
real_8 _p_ fmax_, real_8 _p_ c_, int_4 _p_ nc_, real_8 _p_ b_, real_8 _p_ p_, real_8 _p_ temp_, real_8 _p_ x_, real_8 
_p_ y_, real_8 _p_ fac_, int_4 _p_ is_);
prototype int_4 _dsos (real_8 (*_fnc)(), int_4 _p_ neq_, real_8 _p_ x_, real_8 _p_ rtolx_, real_8 _p_ atolx_, real_8 
_p_ tolf_, int_4 _p_ iflag_, real_8 _p_ rw_, int_4 _p_ lrw_, int_4 _p_ iw_, int_4 _p_ liw_);
prototype int_4 _dsossl (int_4 _p_ k_, int_4 _p_ n_, int_4 _p_ l_, real_8 _p_ x_, real_8 _p_ c_, real_8 _p_ b_, int_4 
_p_ m_);
prototype int_4 _dsplp (real_4 (*_dusrmt)(), int_4 _p_ mrelas_, int_4 _p_ nvars_, real_8 _p_ costs_, real_8 _p_ prgopt_
, real_8 _p_ dattrv_, real_8 _p_ bl_, real_8 _p_ bu_, int_4 _p_ ind_, int_4 _p_ info_, real_8 _p_ primal_, real_8 _p_ 
duals_, int_4 _p_ ibasis_, real_8 _p_ work_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_);
prototype int_4 _dstor1 (real_8 _p_ u_, real_8 _p_ yh_, real_8 _p_ v_, real_8 _p_ yp_, int_4 _p_ ntemp_, int_4 _p_ 
ndisk_, int_4 _p_ ntape_);
prototype int_4 _dstway (real_8 _p_ u_, real_8 _p_ v_, real_8 _p_ yhp_, int_4 _p_ inout_, real_8 _p_ stowa_);
prototype int_4 _dsuds (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ b_, int_4 _p_ neq_, int_4 _p_ nuk_, int_4 _p_ nrda_, 
int_4 _p_ iflag_, int_4 _p_ mlso_, real_8 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _du11ls (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ ub_, real_8 _p_ db_, 
int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 _p_ ksure_, real_8 _p_ h_, real_8 _p_ w_, real_8 _p_ eb_, int_4 
_p_ ic_, int_4 _p_ ir_);
prototype int_4 _du11us (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ ub_, real_8 _p_ db_, 
int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 _p_ ksure_, real_8 _p_ h_, real_8 _p_ w_, real_8 _p_ eb_, int_4 
_p_ ir_, int_4 _p_ ic_);
prototype int_4 _du12ls (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, 
int_4 _p_ nb_, int_4 _p_ mode_, int_4 _p_ krank_, real_8 _p_ rnorm_, real_8 _p_ h_, real_8 _p_ w_, int_4 _p_ ic_, int_4 
_p_ ir_);
prototype int_4 _du12us (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, 
int_4 _p_ nb_, int_4 _p_ mode_, int_4 _p_ krank_, real_8 _p_ rnorm_, real_8 _p_ h_, real_8 _p_ w_, int_4 _p_ ir_, int_4 
_p_ ic_);
prototype int_4 _dulsia (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, 
int_4 _p_ nb_, real_8 _p_ re_, real_8 _p_ ae_, int_4 _p_ key_, int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 
_p_ ksure_, real_8 _p_ rnorm_, real_8 _p_ w_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ info_);
prototype int_4 _dusrmt (int_4 _p_ i_, int_4 _p_ j_, real_8 _p_ aij_, int_4 _p_ indcat_, real_8 _p_ prgopt_, real_8 _p_ 
dattrv_, int_4 _p_ iflag_);
prototype int_4 _dvecs (int_4 _p_ ncomp_, int_4 _p_ lnfc_, real_8 _p_ yhp_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 
_p_ inhomo_, int_4 _p_ iflag_);
prototype real_8 _dvnrms (int_4 _p_ n_, real_8 _p_ v_, real_8 _p_ w_);
prototype int_4 _dwnlit (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ l_, int_4 _p_ ipivot_, 
int_4 _p_ itype_, real_8 _p_ h_, real_8 _p_ scale_, real_8 _p_ rnorm_, int_4 _p_ idope_, real_8 _p_ dope_, logical_4 
_p_ done_);
prototype int_4 _dwnlsm (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ mme_, int_4 _p_ ma_, int_4 _p_ n_, int_4 _p_ l_, 
real_8 _p_ prgopt_, real_8 _p_ x_, real_8 _p_ rnorm_, int_4 _p_ mode_, int_4 _p_ ipivot_, int_4 _p_ itype_, real_8 _p_ 
wd_, real_8 _p_ h_, real_8 _p_ scale_, real_8 _p_ z_, real_8 _p_ temp_, real_8 _p_ d_);
prototype int_4 _dwnlt1 (int_4 _p_ i_, int_4 _p_ lend_, int_4 _p_ mend_, int_4 _p_ ir_, int_4 _p_ mdw_, logical_4 _p_ 
recalc_, int_4 _p_ imax_, real_8 _p_ hbar_, real_8 _p_ h_, real_8 _p_ scale_, real_8 _p_ w_);
prototype logical_4 _dwnlt2 (int_4 _p_ me_, int_4 _p_ mend_, int_4 _p_ ir_, real_8 _p_ factor_, real_8 _p_ tau_, real_8 
_p_ scale_, real_8 _p_ wic_);
prototype int_4 _dwnlt3 (int_4 _p_ i_, int_4 _p_ imax_, int_4 _p_ m_, int_4 _p_ mdw_, int_4 _p_ ipivot_, real_8 _p_ h_, 
real_8 _p_ w_);
prototype int_4 _dwnnls (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ me_, int_4 _p_ ma_, int_4 _p_ n_, int_4 _p_ l_, 
real_8 _p_ prgopt_, real_8 _p_ x_, real_8 _p_ rnorm_, int_4 _p_ mode_, int_4 _p_ iwork_, real_8 _p_ work_);
prototype int_4 _dwritp (int_4 _p_ ipage_, int_4 _p_ list_, real_8 _p_ rlist_, int_4 _p_ lpage_, int_4 _p_ irec_);
prototype int_4 _dwupdt (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ ldr_, real_8 _p_ w_, real_8 _p_ b_, real_8 _p_ alpha_, 
real_8 _p_ cos_, real_8 _p_ sin_);
prototype int_4 _dx4 (real_4 _p_ u_, int_4 _p_ idmn_, int_4 _p_ i_, int_4 _p_ j_, real_4 _p_ uxxx_, real_4 _p_ uxxxx_);
prototype int_4 _dxadj (real_8 _p_ x_, int_4 _p_ ix_, int_4 _p_ ierror_);
prototype int_4 _dxc210 (int_4 _p_ k_, real_8 _p_ z_, int_4 _p_ j_, int_4 _p_ ierror_);
prototype int_4 _dx (real_4 _p_ u_, int_4 _p_ idmn_, int_4 _p_ i_, int_4 _p_ j_, real_4 _p_ uxxx_, real_4 _p_ uxxxx_);
prototype real_8 _dxpsi (real_8 _p_ a_, int_4 _p_ ipsik_, int_4 _p_ ipsix_);
prototype int_4 _dxred (real_8 _p_ x_, int_4 _p_ ix_, int_4 _p_ ierror_);
prototype int_4 _dy4 (real_4 _p_ u_, int_4 _p_ idmn_, int_4 _p_ i_, int_4 _p_ j_, real_4 _p_ uyyy_, real_4 _p_ uyyyy_);
prototype int_4 _dyairy (real_8 _p_ x_, real_8 _p_ rx_, real_8 _p_ c_, real_8 _p_ bi_, real_8 _p_ dbi_);
prototype int_4 _dy (real_4 _p_ u_, int_4 _p_ idmn_, int_4 _p_ i_, int_4 _p_ j_, real_4 _p_ uyyy_, real_4 _p_ uyyyy_);
prototype int_4 _efcmn (int_4 _p_ ndata_, real_4 _p_ xdata_, real_4 _p_ ydata_, real_4 _p_ sddata_, int_4 _p_ nord_, 
int_4 _p_ nbkpt_, real_4 _p_ bkptin_, int_4 _p_ mdein_, int_4 _p_ mdeout_, real_4 _p_ coeff_, real_4 _p_ bf_, real_4 
_p_ xtemp_, real_4 _p_ ptemp_, real_4 _p_ bkpt_, real_4 _p_ g_, int_4 _p_ mdg_, real_4 _p_ w_, int_4 _p_ mdw_, int_4 
_p_ lw_);
prototype int_4 _fcmn (int_4 _p_ ndata_, real_4 _p_ xdata_, real_4 _p_ ydata_, real_4 _p_ sddata_, int_4 _p_ nord_, 
int_4 _p_ nbkpt_, real_4 _p_ bkptin_, int_4 _p_ nconst_, real_4 _p_ xconst_, real_4 _p_ yconst_, int_4 _p_ nderiv_, 
int_4 _p_ mode_, real_4 _p_ coeff_, real_4 _p_ bf_, real_4 _p_ xtemp_, real_4 _p_ ptemp_, real_4 _p_ bkpt_, real_4 _p_ 
g_, int_4 _p_ mdg_, real_4 _p_ w_, int_4 _p_ mdw_, real_4 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _fdjac3 (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ fvec_, real_4 _p_ fjac_
, int_4 _p_ ldfjac_, int_4 _p_ iflag_, real_4 _p_ epsfcn_, real_4 _p_ wa_);
prototype int_4 _fdump (void);
prototype int_4 _fftdoc (void);
prototype int_4 _fulmat (int_4 _p_ i_, int_4 _p_ j_, real_4 _p_ aij_, int_4 _p_ indcat_, real_4 _p_ prgopt_, real_4 _p_ 
dattrv_, int_4 _p_ iflag_);
prototype int_4 _fzero (real_4 (*_f)(), real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ r_, real_4 _p_ re_, real_4 _p_ ae_, 
int_4 _p_ iflag_);
prototype real_4 _gamrn (real_4 _p_ x_);
prototype int_4 _gaus8 (real_4 (*_fun)(), real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ err_, real_4 _p_ ans_, int_4 _p_ 
ierr_);
prototype int_4 _h12 (int_4 _p_ mode_, int_4 _p_ lpivot_, int_4 _p_ l1_, int_4 _p_ m_, real_4 _p_ u_, int_4 _p_ iue_, 
real_4 _p_ up_, real_4 _p_ c_, int_4 _p_ ice_, int_4 _p_ icv_, int_4 _p_ ncv_);
prototype int_4 _hfti (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ b_, int_4 _p_ mdb_, int_4 
_p_ nb_, real_4 _p_ tau_, int_4 _p_ krank_, real_4 _p_ rnorm_, real_4 _p_ h_, real_4 _p_ g_, int_4 _p_ ip_);
prototype int_4 _hkseq (real_4 _p_ x_, int_4 _p_ m_, real_4 _p_ h_, int_4 _p_ ierr_);
prototype int_4 _hpperm (char _p_ _p_ hx_, int_4 _p_ n_, int_4 _p_ iperm_, char _p_ work_, int_4 _p_ ier_);
prototype int_4 _hpsort (char _p_ _p_ hx_, int_4 _p_ n_, int_4 _p_ strbeg_, int_4 _p_ strend_, int_4 _p_ iperm_, int_4 
_p_ kflag_, char _p_ work_, int_4 _p_ ier_);
prototype int_4 _hstart (int_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ y_, real_4 _p_ yprime_
, real_4 _p_ etol_, int_4 _p_ morder_, real_4 _p_ small_, real_4 _p_ big_, real_4 _p_ spy_, real_4 _p_ pv_, real_4 _p_ 
yp_, real_4 _p_ sf_, real_4 _p_ rpar_, int_4 _p_ ipar_, real_4 _p_ h_);
prototype int_4 _hstcs1 (int_4 _p_ intl_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ 
bda_, real_4 _p_ bdb_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, 
real_4 _p_ elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, int_4 _p_ ierr1_, real_4 _p_ am_, real_4 _p_ 
bm_, real_4 _p_ cm_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, real_4 _p_ snth_, real_4 _p_ rsq_, real_4 _p_ wrk_
);
prototype real_4 _hvnrm (real_4 _p_ v_, int_4 _p_ ncomp_);
prototype int_4 _hwscs1 (int_4 _p_ intl_, real_4 _p_ ts_, real_4 _p_ tf_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ 
bdts_, real_4 _p_ bdtf_, real_4 _p_ rs_, real_4 _p_ rf_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdrs_, real_4 _p_ 
bdrf_, real_4 _p_ elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, real_4 _p_ w_, real_4 _p_ s_, real_4 
_p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, real_4 _p_ r_, real_4 _p_ am_, real_4 _p_ bm_, real_4 _p_ cm_, real_4 _p_ 
sint_, real_4 _p_ bmh_);
prototype int_4 _hwsss1 (real_4 _p_ ts_, real_4 _p_ tf_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ bdts_, real_4 _p_ 
bdtf_, real_4 _p_ ps_, real_4 _p_ pf_, int_4 _p_ n_, int_4 _p_ nbdcnd_, real_4 _p_ bdps_, real_4 _p_ bdpf_, real_4 _p_ 
elmbda_, real_4 _p_ f_, int_4 _p_ idimf_, real_4 _p_ pertrb_, real_4 _p_ am_, real_4 _p_ bm_, real_4 _p_ cm_, real_4 
_p_ sn_, real_4 _p_ ss_, real_4 _p_ sint_, real_4 _p_ d_);
prototype int_4 _i1merg (real_4 _p_ icos_, int_4 _p_ i1_, int_4 _p_ m1_, int_4 _p_ i2_, int_4 _p_ m2_, int_4 _p_ i3_);
prototype int_4 _idloc (int_4 _p_ loc_, real_8 _p_ sx_, int_4 _p_ ix_);
prototype int_4 _indxa (int_4 _p_ i_, int_4 _p_ ir_, int_4 _p_ idxa_, int_4 _p_ na_);
prototype int_4 _indxb (int_4 _p_ i_, int_4 _p_ ir_, int_4 _p_ idx_, int_4 _p_ idp_);
prototype int_4 _indxc (int_4 _p_ i_, int_4 _p_ ir_, int_4 _p_ idxc_, int_4 _p_ nc_);
prototype int_4 _inxca (int_4 _p_ i_, int_4 _p_ ir_, int_4 _p_ idxa_, int_4 _p_ na_);
prototype int_4 _inxcb (int_4 _p_ i_, int_4 _p_ ir_, int_4 _p_ idx_, int_4 _p_ idp_);
prototype int_4 _inxcc (int_4 _p_ i_, int_4 _p_ ir_, int_4 _p_ idxc_, int_4 _p_ nc_);
prototype int_4 _iploc (int_4 _p_ loc_, real_4 _p_ sx_, int_4 _p_ ix_);
prototype int_4 _ipperm (int_4 _p_ ix_, int_4 _p_ n_, int_4 _p_ iperm_, int_4 _p_ ier_);
prototype int_4 _ipsort (int_4 _p_ ix_, int_4 _p_ n_, int_4 _p_ iperm_, int_4 _p_ kflag_, int_4 _p_ ier_);
prototype int_4 _isort (int_4 _p_ ix_, int_4 _p_ iy_, int_4 _p_ n_, int_4 _p_ kflag_);
prototype int_4 _jairy (real_4 _p_ x_, real_4 _p_ rx_, real_4 _p_ c_, real_4 _p_ ai_, real_4 _p_ dai_);
prototype int_4 _llsia (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ b_, int_4 _p_ mdb_, int_4 
_p_ nb_, real_4 _p_ re_, real_4 _p_ ae_, int_4 _p_ key_, int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 _p_ 
ksure_, real_4 _p_ rnorm_, real_4 _p_ w_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ info_);
prototype int_4 _lpdp (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n1_, int_4 _p_ n2_, real_4 _p_ prgopt_, 
real_4 _p_ x_, real_4 _p_ wnorm_, int_4 _p_ mode_, real_4 _p_ ws_, int_4 _p_ is_);
prototype int_4 _lsei (real_4 _p_ w_, int_4 _p_ mdw_, int_4 _p_ me_, int_4 _p_ ma_, int_4 _p_ mg_, int_4 _p_ n_, real_4 
_p_ prgopt_, real_4 _p_ x_, real_4 _p_ rnorme_, real_4 _p_ rnorml_, int_4 _p_ mode_, real_4 _p_ ws_, int_4 _p_ ip_);
prototype int_4 _lsi (real_4 _p_ w_, int_4 _p_ mdw_, int_4 _p_ ma_, int_4 _p_ mg_, int_4 _p_ n_, real_4 _p_ prgopt_, 
real_4 _p_ x_, real_4 _p_ rnorm_, int_4 _p_ mode_, real_4 _p_ ws_, int_4 _p_ ip_);
prototype int_4 _lssods (real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ nrda_, 
int_4 _p_ iflag_, int_4 _p_ irank_, int_4 _p_ iscale_, real_4 _p_ q_, real_4 _p_ diag_, int_4 _p_ kpivot_, int_4 _p_ 
iter_, real_4 _p_ resnrm_, real_4 _p_ xnorm_, real_4 _p_ z_, real_4 _p_ r_, real_4 _p_ div_, real_4 _p_ td_, real_4 _p_ 
scales_);
prototype int_4 _lssuds (real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ b_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ nrda_, 
real_4 _p_ u_, int_4 _p_ nrdu_, int_4 _p_ iflag_, int_4 _p_ mlso_, int_4 _p_ irank_, int_4 _p_ iscale_, real_4 _p_ q_, 
real_4 _p_ diag_, int_4 _p_ kpivot_, real_4 _p_ s_, real_4 _p_ div_, real_4 _p_ td_, int_4 _p_ isflg_, real_4 _p_ 
scales_);
prototype int_4 _macon (void);
prototype int_4 _mgsbv (int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, int_4 _p_ ia_, int_4 _p_ niv_, int_4 _p_ iflag_, 
real_4 _p_ s_, real_4 _p_ p_, int_4 _p_ ip_, int_4 _p_ inhomo_, real_4 _p_ v_, real_4 _p_ w_, real_4 _p_ wcnd_);
prototype int_4 _minso4 (real_4 _p_ usol_, int_4 _p_ idmn_, real_4 _p_ zn_, real_4 _p_ zm_, real_4 _p_ pertb_);
prototype int_4 _minsol (real_4 _p_ usol_, int_4 _p_ idmn_, real_4 _p_ zn_, real_4 _p_ zm_, real_4 _p_ pertb_);
prototype int_4 _mpadd2 (int_4 _p_ x_, int_4 _p_ y_, int_4 _p_ z_, int_4 _p_ y1_, int_4 _p_ trunc_);
prototype int_4 _mpadd3 (int_4 _p_ x_, int_4 _p_ y_, int_4 _p_ s_, int_4 _p_ med_, int_4 _p_ re_);
prototype int_4 _mpadd (int_4 _p_ x_, int_4 _p_ y_, int_4 _p_ z_);
prototype int_4 _mpblas (int_4 _p_ i1_);
prototype int_4 _mpcdm (real_8 _p_ dx_, int_4 _p_ z_);
prototype int_4 _mpchk (int_4 _p_ i_, int_4 _p_ j_);
prototype int_4 _mpcmd (int_4 _p_ x_, real_8 _p_ dz_);
prototype int_4 _mpdivi (int_4 _p_ x_, int_4 _p_ iy_, int_4 _p_ z_);
prototype int_4 _mperr (void);
prototype int_4 _mpmaxr (int_4 _p_ x_);
prototype int_4 _mpmlp (int_4 _p_ u_, int_4 _p_ v_, int_4 _p_ w_, int_4 _p_ j_);
prototype int_4 _mpmul2 (int_4 _p_ x_, int_4 _p_ iy_, int_4 _p_ z_, int_4 _p_ trunc_);
prototype int_4 _mpmul (int_4 _p_ x_, int_4 _p_ y_, int_4 _p_ z_);
prototype int_4 _mpmuli (int_4 _p_ x_, int_4 _p_ iy_, int_4 _p_ z_);
prototype int_4 _mpnzr (int_4 _p_ rs_, int_4 _p_ re_, int_4 _p_ z_, int_4 _p_ trunc_);
prototype int_4 _mpovfl (int_4 _p_ x_);
prototype int_4 _mpstr (int_4 _p_ x_, int_4 _p_ y_);
prototype int_4 _mpunfl (int_4 _p_ x_);
prototype int_4 _numxer (int_4 _p_ nerr_);
prototype int_4 _ohtrol (real_4 _p_ q_, int_4 _p_ n_, int_4 _p_ nrda_, real_4 _p_ diag_, int_4 _p_ irank_, real_4 _p_ 
div_, real_4 _p_ td_);
prototype int_4 _ohtror (real_4 _p_ q_, int_4 _p_ n_, int_4 _p_ nrda_, real_4 _p_ diag_, int_4 _p_ irank_, real_4 _p_ 
div_, real_4 _p_ td_);
prototype int_4 _ortho4 (real_4 _p_ usol_, int_4 _p_ idmn_, real_4 _p_ zn_, real_4 _p_ zm_, real_4 _p_ pertrb_);
prototype int_4 _orthog (real_4 _p_ usol_, int_4 _p_ idmn_, real_4 _p_ zn_, real_4 _p_ zm_, real_4 _p_ pertrb_);
prototype int_4 _orthol (real_4 _p_ a_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ nrda_, int_4 _p_ iflag_, int_4 _p_ irank_
, int_4 _p_ iscale_, real_4 _p_ diag_, int_4 _p_ kpivot_, real_4 _p_ scales_, real_4 _p_ cols_, real_4 _p_ cs_);
prototype int_4 _orthor (real_4 _p_ a_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ nrda_, int_4 _p_ iflag_, int_4 _p_ irank_
, int_4 _p_ iscale_, real_4 _p_ diag_, int_4 _p_ kpivot_, real_4 _p_ scales_, real_4 _p_ rows_, real_4 _p_ rs_);
prototype int_4 _pchngs (int_4 _p_ ii_, real_4 _p_ xval_, int_4 _p_ iplace_, real_4 _p_ sx_, int_4 _p_ ix_, int_4 _p_ 
ircx_);
prototype int_4 _pcoef (int_4 _p_ l_, real_4 _p_ c_, real_4 _p_ tc_, real_4 _p_ a_);
prototype real_4 _pgsf (real_4 _p_ x_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_);
prototype real_4 _pimach (real_4 _p_ dum_);
prototype int_4 _pinitm (int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ sx_, int_4 _p_ ix_, int_4 _p_ lmx_, int_4 _p_ ipagef_);
prototype int_4 _pnnzrs (int_4 _p_ i_, real_4 _p_ xval_, int_4 _p_ iplace_, real_4 _p_ sx_, int_4 _p_ ix_, int_4 _p_ 
ircx_);
prototype int_4 _poisd2 (int_4 _p_ mr_, int_4 _p_ nr_, int_4 _p_ istag_, real_4 _p_ ba_, real_4 _p_ bb_, real_4 _p_ bc_
, real_4 _p_ q_, int_4 _p_ idimq_, real_4 _p_ b_, real_4 _p_ w_, real_4 _p_ d_, real_4 _p_ tcos_, real_4 _p_ p_);
prototype int_4 _poisn2 (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ istag_, int_4 _p_ mixbnd_, real_4 _p_ a_, real_4 _p_ bb_
, real_4 _p_ c_, real_4 _p_ q_, int_4 _p_ idimq_, real_4 _p_ b_, real_4 _p_ b2_, real_4 _p_ b3_, real_4 _p_ w_, real_4 
_p_ w2_, real_4 _p_ w3_, real_4 _p_ d_, real_4 _p_ tcos_, real_4 _p_ p_);
prototype int_4 _poisp2 (int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ bb_, real_4 _p_ c_, real_4 _p_ q_, int_4 
_p_ idimq_, real_4 _p_ b_, real_4 _p_ b2_, real_4 _p_ b3_, real_4 _p_ w_, real_4 _p_ w2_, real_4 _p_ w3_, real_4 _p_ d_
, real_4 _p_ tcos_, real_4 _p_ p_);
prototype int_4 _polcof (real_4 _p_ xx_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ work_);
prototype int_4 _polfit (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ w_, int_4 _p_ maxdeg_, int_4 _p_ ndeg_, 
real_4 _p_ eps_, real_4 _p_ r_, int_4 _p_ ierr_, real_4 _p_ a_);
prototype int_4 _polint (int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ c_);
prototype int_4 _polyvl (int_4 _p_ nder_, real_4 _p_ xx_, real_4 _p_ yfit_, real_4 _p_ yp_, int_4 _p_ n_, real_4 _p_ x_
, real_4 _p_ c_, real_4 _p_ work_, int_4 _p_ ierr_);
prototype int_4 _pos3d1 (int_4 _p_ lp_, int_4 _p_ l_, int_4 _p_ mp_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ a_, real_4 
_p_ b_, real_4 _p_ c_, int_4 _p_ ldimf_, int_4 _p_ mdimf_, real_4 _p_ f_, real_4 _p_ xrt_, real_4 _p_ yrt_, real_4 _p_ 
t_, real_4 _p_ d_, real_4 _p_ wx_, real_4 _p_ wy_, real_4 _p_ c1_, real_4 _p_ c2_, real_4 _p_ bb_);
prototype int_4 _postg2 (int_4 _p_ nperod_, int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ bb_, real_4 _p_ c_, 
int_4 _p_ idimq_, real_4 _p_ q_, real_4 _p_ b_, real_4 _p_ b2_, real_4 _p_ b3_, real_4 _p_ w_, real_4 _p_ w2_, real_4 
_p_ w3_, real_4 _p_ d_, real_4 _p_ tcos_, real_4 _p_ p_);
prototype int_4 _ppadd (int_4 _p_ n_, int_4 _p_ ierror_, real_4 _p_ a_, real_4 _p_ c_, complex_8 _p_ cbp_, real_4 _p_ 
bp_, real_4 _p_ bh_);
prototype int_4 _ppgq8 (real_4 (*_fun)(), int_4 _p_ ldc_, real_4 _p_ c_, real_4 _p_ xi_, int_4 _p_ lxi_, int_4 _p_ kk_, 
int_4 _p_ id_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ inppv_, real_4 _p_ err_, real_4 _p_ ans_, int_4 _p_ ierr_);
prototype real_4 _ppgsf (real_4 _p_ x_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_);
prototype real_4 _pppsf (real_4 _p_ x_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_);
prototype real_4 _ppsgf (real_4 _p_ x_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_);
prototype real_4 _ppspf (real_4 _p_ x_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_);
prototype int_4 _proc (int_4 _p_ nd_, real_4 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ bm2_, 
int_4 _p_ na_, real_4 _p_ aa_, complex_8 _p_ x_, complex_8 _p_ y_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, 
complex_8 _p_ c_, complex_8 _p_ d_, complex_8 _p_ w_, complex_8 _p_ u_);
prototype int_4 _procp (int_4 _p_ nd_, real_4 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ bm2_
, int_4 _p_ na_, real_4 _p_ aa_, complex_8 _p_ x_, complex_8 _p_ y_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, 
complex_8 _p_ c_, complex_8 _p_ d_, complex_8 _p_ u_, complex_8 _p_ w_);
prototype int_4 _prod (int_4 _p_ nd_, real_4 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ bm2_, 
int_4 _p_ na_, real_4 _p_ aa_, real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, 
real_4 _p_ d_, real_4 _p_ w_, real_4 _p_ u_);
prototype int_4 _prodp (int_4 _p_ nd_, real_4 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ bm2_
, int_4 _p_ na_, real_4 _p_ aa_, real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ 
c_, real_4 _p_ d_, real_4 _p_ u_, real_4 _p_ w_);
prototype real_4 _prvec (int_4 _p_ m_, real_4 _p_ u_, real_4 _p_ v_);
prototype int_4 _prwpge (int_4 _p_ key_, int_4 _p_ ipage_, int_4 _p_ lpg_, real_4 _p_ sx_, int_4 _p_ ix_);
prototype int_4 _prwvir (int_4 _p_ key_, int_4 _p_ ipage_, int_4 _p_ lpg_, real_4 _p_ sx_, int_4 _p_ ix_);
prototype real_4 _psgf (real_4 _p_ x_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_);
prototype int_4 _psifn (real_4 _p_ x_, int_4 _p_ n_, int_4 _p_ kode_, int_4 _p_ m_, real_4 _p_ ans_, int_4 _p_ nz_, 
int_4 _p_ ierr_);
prototype real_4 _psixn (int_4 _p_ n_);
prototype int_4 _pvalue (int_4 _p_ l_, int_4 _p_ nder_, real_4 _p_ x_, real_4 _p_ yfit_, real_4 _p_ yp_, real_4 _p_ a_)
;
prototype real_4 _pythag (real_4 _p_ a_, real_4 _p_ b_);
prototype int_4 _rc3jj (real_4 _p_ l2_, real_4 _p_ l3_, real_4 _p_ m2_, real_4 _p_ m3_, real_4 _p_ l1min_, real_4 _p_ 
l1max_, real_4 _p_ thrcof_, int_4 _p_ ndim_, int_4 _p_ ier_);
prototype int_4 _rc3jm (real_4 _p_ l1_, real_4 _p_ l2_, real_4 _p_ l3_, real_4 _p_ m1_, real_4 _p_ m2min_, real_4 _p_ 
m2max_, real_4 _p_ thrcof_, int_4 _p_ ndim_, int_4 _p_ ier_);
prototype int_4 _rc6j (real_4 _p_ l2_, real_4 _p_ l3_, real_4 _p_ l4_, real_4 _p_ l5_, real_4 _p_ l6_, real_4 _p_ 
l1min_, real_4 _p_ l1max_, real_4 _p_ sixcof_, int_4 _p_ ndim_, int_4 _p_ ier_);
prototype real_4 _rc (real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ ier_);
prototype real_4 _rd (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ z_, int_4 _p_ ier_);
prototype int_4 _reort (int_4 _p_ ncomp_, real_4 _p_ y_, real_4 _p_ yp_, real_4 _p_ yhp_, int_4 _p_ niv_, real_4 _p_ w_
, real_4 _p_ s_, real_4 _p_ p_, int_4 _p_ ip_, real_4 _p_ stowa_, int_4 _p_ iflag_);
prototype real_4 _rf (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ z_, int_4 _p_ ier_);
prototype real_4 _rj (real_4 _p_ x_, real_4 _p_ y_, real_4 _p_ z_, real_4 _p_ p_, int_4 _p_ ier_);
prototype int_4 _rpqr79 (int_4 _p_ ndeg_, real_4 _p_ coeff_, complex_8 _p_ root_, int_4 _p_ ierr_, real_4 _p_ work_);
prototype int_4 _rpzero (int_4 _p_ n_, real_4 _p_ a_, complex_8 _p_ r_, complex_8 _p_ t_, int_4 _p_ iflg_, real_4 _p_ 
s_);
prototype int_4 _s1merg (real_4 _p_ tcos_, int_4 _p_ i1_, int_4 _p_ m1_, int_4 _p_ i2_, int_4 _p_ m2_, int_4 _p_ i3_);
prototype int_4 _sbocls (real_4 _p_ w_, int_4 _p_ mdw_, int_4 _p_ mcon_, int_4 _p_ mrows_, int_4 _p_ ncols_, real_4 _p_ 
bl_, real_4 _p_ bu_, int_4 _p_ ind_, int_4 _p_ iopt_, real_4 _p_ x_, real_4 _p_ rnormc_, real_4 _p_ rnorm_, int_4 _p_ 
mode_, real_4 _p_ rw_, int_4 _p_ iw_);
prototype int_4 _sbols (real_4 _p_ w_, int_4 _p_ mdw_, int_4 _p_ mrows_, int_4 _p_ ncols_, real_4 _p_ bl_, real_4 _p_ 
bu_, int_4 _p_ ind_, int_4 _p_ iopt_, real_4 _p_ x_, real_4 _p_ rnorm_, int_4 _p_ mode_, real_4 _p_ rw_, int_4 _p_ iw_)
;
prototype int_4 _sbolsm (real_4 _p_ w_, int_4 _p_ mdw_, int_4 _p_ minput_, int_4 _p_ ncols_, real_4 _p_ bl_, real_4 _p_ 
bu_, int_4 _p_ ind_, int_4 _p_ iopt_, real_4 _p_ x_, real_4 _p_ rnorm_, int_4 _p_ mode_, real_4 _p_ rw_, real_4 _p_ ww_
, real_4 _p_ scl_, int_4 _p_ ibasis_, int_4 _p_ ibb_);
prototype int_4 _sclosm (int_4 _p_ ipage_);
prototype int_4 _scoef (real_4 _p_ yh_, real_4 _p_ yp_, int_4 _p_ ncomp_, int_4 _p_ nrowb_, int_4 _p_ nfc_, int_4 _p_ 
nic_, real_4 _p_ b_, real_4 _p_ beta_, real_4 _p_ coef_, int_4 _p_ inhomo_, real_4 _p_ re_, real_4 _p_ ae_, real_4 _p_ 
by_, real_4 _p_ cvec_, real_4 _p_ work_, int_4 _p_ iwork_, int_4 _p_ iflag_, int_4 _p_ nfcc_);
prototype int_4 _scov (int_4 (*_fcn)(), int_4 _p_ iopt_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ fvec_, 
real_4 _p_ r_, int_4 _p_ ldr_, int_4 _p_ info_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, real_4 _p_ wa4_);
prototype int_4 _sgeev (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ e_, real_4 _p_ v_, int_4 _p_ ldv_, 
real_4 _p_ work_, int_4 _p_ job_, int_4 _p_ info_);
prototype int_4 _sgefs (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
real_4 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _sgeir (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
real_4 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _sglss (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ b_, int_4 _p_ mdb_, int_4 
_p_ nb_, real_4 _p_ rnorm_, real_4 _p_ work_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ info_);
prototype int_4 _snbco (real_4 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_4 _p_ rcond_, real_4 _p_ z_);
prototype int_4 _snbdi (real_4 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_4 _p_ det_);
prototype int_4 _snbfa (real_4 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
int_4 _p_ info_);
prototype int_4 _snbfs (real_4 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, real_4 _p_ v_, 
int_4 _p_ itask_, int_4 _p_ ind_, real_4 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _snbir (real_4 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, real_4 _p_ v_, 
int_4 _p_ itask_, int_4 _p_ ind_, real_4 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _snbsl (real_4 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
real_4 _p_ b_, int_4 _p_ job_);
prototype int_4 _snls1e (real_4 (*_fcn)(), int_4 _p_ iopt_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ fvec_
, real_4 _p_ tol_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ iw_, real_4 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _snls1 (int_4 (*_fcn)(), int_4 _p_ iopt_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ fvec_, 
real_4 _p_ fjac_, int_4 _p_ ldfjac_, real_4 _p_ ftol_, real_4 _p_ xtol_, real_4 _p_ gtol_, int_4 _p_ maxfev_, real_4 
_p_ epsfcn_, real_4 _p_ diag_, int_4 _p_ mode_, real_4 _p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_
, int_4 _p_ njev_, int_4 _p_ ipvt_, real_4 _p_ qtf_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, real_4 _p_ wa4_
);
prototype int_4 _snsqe (real_4 (*_fcn)(), int_4 (*_jac)(), int_4 _p_ iopt_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ 
fvec_, real_4 _p_ tol_, int_4 _p_ nprint_, int_4 _p_ info_, real_4 _p_ wa_, int_4 _p_ lwa_);
prototype int_4 _snsq (int_4 (*_fcn)(), int_4 (*_jac)(), int_4 _p_ iopt_, int_4 _p_ n_, real_4 _p_ x_, real_4 _p_ fvec_
, real_4 _p_ fjac_, int_4 _p_ ldfjac_, real_4 _p_ xtol_, int_4 _p_ maxfev_, int_4 _p_ ml_, int_4 _p_ mu_, real_4 _p_ 
epsfcn_, real_4 _p_ diag_, int_4 _p_ mode_, real_4 _p_ factor_, int_4 _p_ nprint_, int_4 _p_ info_, int_4 _p_ nfev_, 
int_4 _p_ njev_, real_4 _p_ r_, int_4 _p_ lr_, real_4 _p_ qtf_, real_4 _p_ wa1_, real_4 _p_ wa2_, real_4 _p_ wa3_, 
real_4 _p_ wa4_);
prototype int_4 _sods (real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ b_, int_4 _p_ neq_, int_4 _p_ nuk_, int_4 _p_ nrda_, 
int_4 _p_ iflag_, real_4 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _sopenm (int_4 _p_ ipage_, int_4 _p_ lpage_);
prototype int_4 _soseqs (real_4 (*_fnc)(), int_4 _p_ n_, real_4 _p_ s_, real_4 _p_ rtolx_, real_4 _p_ atolx_, real_4 
_p_ tolf_, int_4 _p_ iflag_, int_4 _p_ mxit_, int_4 _p_ ncjs_, int_4 _p_ nsrrc_, int_4 _p_ nsri_, int_4 _p_ iprint_, 
real_4 _p_ fmax_, real_4 _p_ c_, int_4 _p_ nc_, real_4 _p_ b_, real_4 _p_ p_, real_4 _p_ temp_, real_4 _p_ x_, real_4 
_p_ y_, real_4 _p_ fac_, int_4 _p_ is_);
prototype int_4 _sos (real_4 (*_fnc)(), int_4 _p_ neq_, real_4 _p_ x_, real_4 _p_ rtolx_, real_4 _p_ atolx_, real_4 _p_ 
tolf_, int_4 _p_ iflag_, real_4 _p_ rw_, int_4 _p_ lrw_, int_4 _p_ iw_, int_4 _p_ liw_);
prototype int_4 _sossol (int_4 _p_ k_, int_4 _p_ n_, int_4 _p_ l_, real_4 _p_ x_, real_4 _p_ c_, real_4 _p_ b_, int_4 
_p_ m_);
prototype int_4 _speli4 (int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ 
bda_, real_4 _p_ alpha_, real_4 _p_ bdb_, real_4 _p_ beta_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ 
nbdcnd_, real_4 _p_ bdc_, real_4 _p_ bdd_, int_4 (*_cofx)(), real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, real_4 _p_ 
dn_, real_4 _p_ un_, real_4 _p_ zn_, real_4 _p_ am_, real_4 _p_ bm_, real_4 _p_ cm_, real_4 _p_ dm_, real_4 _p_ um_, 
real_4 _p_ zm_, real_4 _p_ grhs_, real_4 _p_ usol_, int_4 _p_ idmn_, real_4 _p_ w_, real_4 _p_ pertrb_, int_4 _p_ 
ierror_);
prototype int_4 _spelip (int_4 _p_ intl_, int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ 
mbdcnd_, real_4 _p_ bda_, real_4 _p_ alpha_, real_4 _p_ bdb_, real_4 _p_ beta_, real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ 
n_, int_4 _p_ nbdcnd_, real_4 _p_ bdc_, real_4 _p_ gama_, real_4 _p_ bdd_, real_4 _p_ xnu_, int_4 (*_cofx)(), int_4 
(*_cofy)(), real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, real_4 _p_ dn_, real_4 _p_ un_, real_4 _p_ zn_, real_4 _p_ 
am_, real_4 _p_ bm_, real_4 _p_ cm_, real_4 _p_ dm_, real_4 _p_ um_, real_4 _p_ zm_, real_4 _p_ grhs_, real_4 _p_ usol_
, int_4 _p_ idmn_, real_4 _p_ w_, real_4 _p_ pertrb_, int_4 _p_ ierror_);
prototype int_4 _spincw (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ npp_, int_4 _p_ 
jstrt_, int_4 _p_ ibasis_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 _p_ ind_, int_4 _p_ 
ibb_, real_4 _p_ costsc_, real_4 _p_ gg_, real_4 _p_ erdnrm_, real_4 _p_ dulnrm_, real_4 _p_ amat_, real_4 _p_ basmat_, 
real_4 _p_ csc_, real_4 _p_ wr_, real_4 _p_ ww_, real_4 _p_ rz_, real_4 _p_ rg_, real_4 _p_ costs_, real_4 _p_ colnrm_, 
real_4 _p_ duals_, logical_4 _p_ stpedg_);
prototype int_4 _spinit (int_4 _p_ mrelas_, int_4 _p_ nvars_, real_4 _p_ costs_, real_4 _p_ bl_, real_4 _p_ bu_, int_4 
_p_ ind_, real_4 _p_ primal_, int_4 _p_ info_, real_4 _p_ amat_, real_4 _p_ csc_, real_4 _p_ costsc_, real_4 _p_ 
colnrm_, real_4 _p_ xlamda_, real_4 _p_ anorm_, real_4 _p_ rhs_, real_4 _p_ rhsnrm_, int_4 _p_ ibasis_, int_4 _p_ ibb_, 
int_4 _p_ imat_, logical_4 _p_ lopt_);
prototype int_4 _splpce (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ itlp_, int_4 
_p_ itbrc_, int_4 _p_ ibasis_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 _p_ ind_, int_4 
_p_ ibb_, real_4 _p_ erdnrm_, real_4 _p_ eps_, real_4 _p_ tune_, real_4 _p_ gg_, real_4 _p_ amat_, real_4 _p_ basmat_, 
real_4 _p_ csc_, real_4 _p_ wr_, real_4 _p_ ww_, real_4 _p_ primal_, real_4 _p_ erd_, real_4 _p_ erp_, logical_4 _p_ 
singlr_, logical_4 _p_ redbas_);
prototype int_4 _splpdm (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ nredc_, int_4 
_p_ info_, int_4 _p_ iopt_, int_4 _p_ ibasis_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 
_p_ ind_, int_4 _p_ ibb_, real_4 _p_ anorm_, real_4 _p_ eps_, real_4 _p_ uu_, real_4 _p_ gg_, real_4 _p_ amat_, real_4 
_p_ basmat_, real_4 _p_ csc_, real_4 _p_ wr_, logical_4 _p_ singlr_, logical_4 _p_ redbas_);
prototype int_4 _splp (real_4 (*_usrmat)(), int_4 _p_ mrelas_, int_4 _p_ nvars_, real_4 _p_ costs_, real_4 _p_ prgopt_, 
real_4 _p_ dattrv_, real_4 _p_ bl_, real_4 _p_ bu_, int_4 _p_ ind_, int_4 _p_ info_, real_4 _p_ primal_, real_4 _p_ 
duals_, int_4 _p_ ibasis_, real_4 _p_ work_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_);
prototype int_4 _splpfe (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ ienter_, int_4 
_p_ ibasis_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 _p_ ind_, int_4 _p_ ibb_, real_4 
_p_ erdnrm_, real_4 _p_ eps_, real_4 _p_ gg_, real_4 _p_ dulnrm_, real_4 _p_ dirnrm_, real_4 _p_ amat_, real_4 _p_ 
basmat_, real_4 _p_ csc_, real_4 _p_ wr_, real_4 _p_ ww_, real_4 _p_ bl_, real_4 _p_ bu_, real_4 _p_ rz_, real_4 _p_ 
rg_, real_4 _p_ colnrm_, real_4 _p_ duals_, logical_4 _p_ found_);
prototype int_4 _splpfl (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ ienter_, int_4 _p_ ileave_, int_4 _p_ ibasis_, 
int_4 _p_ ind_, int_4 _p_ ibb_, real_4 _p_ theta_, real_4 _p_ dirnrm_, real_4 _p_ rprnrm_, real_4 _p_ csc_, real_4 _p_ 
ww_, real_4 _p_ bl_, real_4 _p_ bu_, real_4 _p_ erp_, real_4 _p_ rprim_, real_4 _p_ primal_, logical_4 _p_ finite_, 
logical_4 _p_ zerolv_);
prototype int_4 _splpmn (real_4 (*_usrmat)(), int_4 _p_ mrelas_, int_4 _p_ nvars_, real_4 _p_ costs_, real_4 _p_ 
prgopt_, real_4 _p_ dattrv_, real_4 _p_ bl_, real_4 _p_ bu_, int_4 _p_ ind_, int_4 _p_ info_, real_4 _p_ primal_, 
real_4 _p_ duals_, real_4 _p_ amat_, real_4 _p_ csc_, real_4 _p_ colnrm_, real_4 _p_ erd_, real_4 _p_ erp_, real_4 _p_ 
basmat_, real_4 _p_ wr_, real_4 _p_ rz_, real_4 _p_ rg_, real_4 _p_ rprim_, real_4 _p_ rhs_, real_4 _p_ ww_, int_4 _p_ 
lmx_, int_4 _p_ lbm_, int_4 _p_ ibasis_, int_4 _p_ ibb_, int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ 
iwr_);
prototype int_4 _splpmu (int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ lmx_, int_4 _p_ lbm_, int_4 _p_ nredc_, int_4 
_p_ info_, int_4 _p_ ienter_, int_4 _p_ ileave_, int_4 _p_ iopt_, int_4 _p_ npp_, int_4 _p_ jstrt_, int_4 _p_ ibasis_, 
int_4 _p_ imat_, int_4 _p_ ibrc_, int_4 _p_ ipr_, int_4 _p_ iwr_, int_4 _p_ ind_, int_4 _p_ ibb_, real_4 _p_ anorm_, 
real_4 _p_ eps_, real_4 _p_ uu_, real_4 _p_ gg_, real_4 _p_ rprnrm_, real_4 _p_ erdnrm_, real_4 _p_ dulnrm_, real_4 _p_ 
theta_, real_4 _p_ costsc_, real_4 _p_ xlamda_, real_4 _p_ rhsnrm_, real_4 _p_ amat_, real_4 _p_ basmat_, real_4 _p_ 
csc_, real_4 _p_ wr_, real_4 _p_ rprim_, real_4 _p_ ww_, real_4 _p_ bu_, real_4 _p_ bl_, real_4 _p_ rhs_, real_4 _p_ 
erd_, real_4 _p_ erp_, real_4 _p_ rz_, real_4 _p_ rg_, real_4 _p_ colnrm_, real_4 _p_ costs_, real_4 _p_ primal_, 
real_4 _p_ duals_, logical_4 _p_ singlr_, logical_4 _p_ redbas_, logical_4 _p_ zerolv_, logical_4 _p_ stpedg_);
prototype int_4 _splpup (int_4 (*_usrmat)(), int_4 _p_ mrelas_, int_4 _p_ nvars_, real_4 _p_ prgopt_, real_4 _p_ 
dattrv_, real_4 _p_ bl_, real_4 _p_ bu_, int_4 _p_ ind_, int_4 _p_ info_, real_4 _p_ amat_, int_4 _p_ imat_, logical_4 
_p_ sizeup_, real_4 _p_ asmall_, real_4 _p_ abig_);
prototype int_4 _spofs (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
real_4 _p_ work_);
prototype int_4 _spoir (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
real_4 _p_ work_);
prototype int_4 _spopt (real_4 _p_ prgopt_, int_4 _p_ mrelas_, int_4 _p_ nvars_, int_4 _p_ info_, real_4 _p_ csc_, 
int_4 _p_ ibasis_, real_4 _p_ ropt_, int_4 _p_ intopt_, logical_4 _p_ lopt_);
prototype int_4 _spperm (real_4 _p_ x_, int_4 _p_ n_, int_4 _p_ iperm_, int_4 _p_ ier_);
prototype int_4 _spsort (real_4 _p_ x_, int_4 _p_ n_, int_4 _p_ iperm_, int_4 _p_ kflag_, int_4 _p_ ier_);
prototype int_4 _sreadp (int_4 _p_ ipage_, int_4 _p_ list_, real_4 _p_ rlist_, int_4 _p_ lpage_, int_4 _p_ irec_);
prototype int_4 _ssiev (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ e_, real_4 _p_ work_, int_4 _p_ job_, 
int_4 _p_ info_);
prototype int_4 _ssort (real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ n_, int_4 _p_ kflag_);
prototype int_4 _stor1 (real_4 _p_ u_, real_4 _p_ yh_, real_4 _p_ v_, real_4 _p_ yp_, int_4 _p_ ntemp_, int_4 _p_ 
ndisk_, int_4 _p_ ntape_);
prototype int_4 _stway (real_4 _p_ u_, real_4 _p_ v_, real_4 _p_ yhp_, int_4 _p_ inout_, real_4 _p_ stowa_);
prototype int_4 _suds (real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ b_, int_4 _p_ neq_, int_4 _p_ nuk_, int_4 _p_ nrda_, 
int_4 _p_ iflag_, int_4 _p_ mlso_, real_4 _p_ work_, int_4 _p_ iwork_);
prototype int_4 _svecs (int_4 _p_ ncomp_, int_4 _p_ lnfc_, real_4 _p_ yhp_, real_4 _p_ work_, int_4 _p_ iwork_, int_4 
_p_ inhomo_, int_4 _p_ iflag_);
prototype int_4 _swritp (int_4 _p_ ipage_, int_4 _p_ list_, real_4 _p_ rlist_, int_4 _p_ lpage_, int_4 _p_ irec_);
prototype int_4 _tevlc (int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e2_, int_4 _p_ ierr_);
prototype int_4 _tevls (int_4 _p_ n_, real_4 _p_ d_, real_4 _p_ e2_, int_4 _p_ ierr_);
prototype int_4 _tri3 (int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, int_4 _p_ k_, real_4 _p_ y1_, real_4 
_p_ y2_, real_4 _p_ y3_, real_4 _p_ tcos_, real_4 _p_ d_, real_4 _p_ w1_, real_4 _p_ w2_, real_4 _p_ w3_);
prototype int_4 _tridq (int_4 _p_ mr_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ y_, real_4 _p_ d_);
prototype int_4 _tris4 (int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ u_, real_4 
_p_ z_);
prototype int_4 _trisp (int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, real_4 _p_ d_, real_4 _p_ u_, real_4 
_p_ z_);
prototype int_4 _trix (int_4 _p_ idegbr_, int_4 _p_ idegcr_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, 
real_4 _p_ y_, real_4 _p_ tcos_, real_4 _p_ d_, real_4 _p_ w_);
prototype int_4 _u11ls (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ ub_, real_4 _p_ db_, 
int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 _p_ ksure_, real_4 _p_ h_, real_4 _p_ w_, real_4 _p_ eb_, int_4 
_p_ ic_, int_4 _p_ ir_);
prototype int_4 _u11us (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ ub_, real_4 _p_ db_, 
int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 _p_ ksure_, real_4 _p_ h_, real_4 _p_ w_, real_4 _p_ eb_, int_4 
_p_ ir_, int_4 _p_ ic_);
prototype int_4 _u12ls (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ b_, int_4 _p_ mdb_, int_4 
_p_ nb_, int_4 _p_ mode_, int_4 _p_ krank_, real_4 _p_ rnorm_, real_4 _p_ h_, real_4 _p_ w_, int_4 _p_ ic_, int_4 _p_ 
ir_);
prototype int_4 _u12us (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ b_, int_4 _p_ mdb_, int_4 
_p_ nb_, int_4 _p_ mode_, int_4 _p_ krank_, real_4 _p_ rnorm_, real_4 _p_ h_, real_4 _p_ w_, int_4 _p_ ir_, int_4 _p_ 
ic_);
prototype int_4 _ulsia (real_4 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_4 _p_ b_, int_4 _p_ mdb_, int_4 
_p_ nb_, real_4 _p_ re_, real_4 _p_ ae_, int_4 _p_ key_, int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 _p_ 
ksure_, real_4 _p_ rnorm_, real_4 _p_ w_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ info_);
prototype int_4 _usrmat (int_4 _p_ i_, int_4 _p_ j_, real_4 _p_ aij_, int_4 _p_ indcat_, real_4 _p_ prgopt_, real_4 _p_ 
dattrv_, int_4 _p_ iflag_);
prototype real_4 _vnwrms (int_4 _p_ n_, real_4 _p_ v_, real_4 _p_ w_);
prototype int_4 _wnlit (real_4 _p_ w_, int_4 _p_ mdw_, int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ l_, int_4 _p_ ipivot_, 
int_4 _p_ itype_, real_4 _p_ h_, real_4 _p_ scale_, real_4 _p_ rnorm_, int_4 _p_ idope_, real_4 _p_ dope_, logical_4 
_p_ done_);
prototype int_4 _wnlsm (real_4 _p_ w_, int_4 _p_ mdw_, int_4 _p_ mme_, int_4 _p_ ma_, int_4 _p_ n_, int_4 _p_ l_, 
real_4 _p_ prgopt_, real_4 _p_ x_, real_4 _p_ rnorm_, int_4 _p_ mode_, int_4 _p_ ipivot_, int_4 _p_ itype_, real_4 _p_ 
wd_, real_4 _p_ h_, real_4 _p_ scale_, real_4 _p_ z_, real_4 _p_ temp_, real_4 _p_ d_);
prototype int_4 _wnlt1 (int_4 _p_ i_, int_4 _p_ lend_, int_4 _p_ mend_, int_4 _p_ ir_, int_4 _p_ mdw_, logical_4 _p_ 
recalc_, int_4 _p_ imax_, real_4 _p_ hbar_, real_4 _p_ h_, real_4 _p_ scale_, real_4 _p_ w_);
prototype logical_4 _wnlt2 (int_4 _p_ me_, int_4 _p_ mend_, int_4 _p_ ir_, real_4 _p_ factor_, real_4 _p_ tau_, real_4 
_p_ scale_, real_4 _p_ wic_);
prototype int_4 _wnlt3 (int_4 _p_ i_, int_4 _p_ imax_, int_4 _p_ m_, int_4 _p_ mdw_, int_4 _p_ ipivot_, real_4 _p_ h_, 
real_4 _p_ w_);
prototype int_4 _wnnls (real_4 _p_ w_, int_4 _p_ mdw_, int_4 _p_ me_, int_4 _p_ ma_, int_4 _p_ n_, int_4 _p_ l_, real_4 
_p_ prgopt_, real_4 _p_ x_, real_4 _p_ rnorm_, int_4 _p_ mode_, int_4 _p_ iwork_, real_4 _p_ work_);
prototype int_4 _xadj (real_4 _p_ x_, int_4 _p_ ix_, int_4 _p_ ierror_);
prototype int_4 _xc210 (int_4 _p_ k_, real_4 _p_ z_, int_4 _p_ j_, int_4 _p_ ierror_);
prototype real_4 _xpsi (real_4 _p_ a_, int_4 _p_ ipsik_, int_4 _p_ ipsix_);
prototype int_4 _xred (real_4 _p_ x_, int_4 _p_ ix_, int_4 _p_ ierror_);
prototype int_4 _yairy (real_4 _p_ x_, real_4 _p_ rx_, real_4 _p_ c_, real_4 _p_ bi_, real_4 _p_ dbi_);
int_4 _aaaaaa (char _p_ ver_)
{
  strcpy (ver_, _dc_0);
  __calls[0].calls++;
  return 0;
}

int_4 _asyik (real_4 _p_ x_, real_4 _p_ fnu_, int_4 _p_ kode_, real_4 _p_ flgik_, real_4 _p_ ra_, real_4 _p_ arg_, 
int_4 _p_ in_, real_4 _p_ y_)
{
  static int_4 j_, jn_, k_, kk_, l_;
  static real_4 ak_, ap_, c_[65], coef_, con_[2], etx_, fn_, gln_, s1_, s2_, t_, tol_, t2_, z_;
  int_4 _data_k_0, _data_k_1, _data_k_2, _data_k_3, $0_;
  extern real_4 _r1mach ();
#define _data_n_0 2
  static real_4 _data_l_0[_data_n_0] = {
    3.98942280401432678e-1,
    1.25331413731550025e+00
  };
#define _data_n_1 24
  static real_4 _data_l_1[_data_n_1] = {
    -2.08333333333333e-1,
    1.25e-1,
    3.34201388888889e-1,
    -4.01041666666667e-1,
    7.03125e-2,
    -1.02581259645062e+00,
    1.84646267361111e+00,
    -8.912109375e-1,
    7.32421875e-2,
    4.66958442342625e+00,
    -1.1207002616223e1,
    8.78912353515625e+00,
    -2.3640869140625e+00,
    1.12152099609375e-1,
    -2.82120725582002e1,
    8.46362176746007e1,
    -9.181824154324e1,
    4.25349987453885e1,
    -7.36879435947963e+00,
    2.27108001708984e-1,
    2.12570130039217e2,
    -7.65252468141182e2,
    1.059990452528e3,
    -6.99579627376133e2
  };
#define _data_n_2 24
  static real_4 _data_l_2[_data_n_2] = {
    2.18190511744212e2,
    -2.64914304869516e1,
    5.72501420974731e-1,
    -1.91945766231841e3,
    8.06172218173731e3,
    -1.35865500064341e4,
    1.16553933368645e4,
    -5.3056469786134e3,
    1.20090291321635e3,
    -1.08090919788395e2,
    1.72772750258446e+00,
    2.02042913309661e4,
    -9.69805983886375e4,
    1.92547001232532e5,
    -2.03400177280416e5,
    1.22200464983017e5,
    -4.11926549688976e4,
    7.10951430248936e3,
    -4.93915304773088e2,
    6.07404200127348e+00,
    -2.42919187900551e5,
    1.31176361466298e6,
    -2.99801591853811e6,
    3.7632712976564e6
  };
#define _data_n_3 17
  static real_4 _data_l_3[_data_n_3] = {
    -2.81356322658653e6,
    1.26836527332162e6,
    -3.31645172484564e5,
    4.52187689813627e4,
    -2.49983048181121e3,
    2.43805296995561e1,
    3.28446985307204e6,
    -1.97068191184322e7,
    5.09526024926646e7,
    -7.41051482115327e7,
    6.6344512274729e7,
    -3.75671766607634e7,
    1.32887671664218e7,
    -2.78561812808645e6,
    3.08186404612662e5,
    -1.3886089753717e4,
    1.10017140269247e2
  };
  if (__calls[1].calls == 0) {
    _data_k_0 = 0;
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    con_[0] = _data_l_0[_data_k_0++];
    if (_data_k_0 >= _data_n_0) {
      _data_k_0 = 0;
    }
    con_[1] = _data_l_0[_data_k_0++];
  }
  if (__calls[1].calls == 0) {
    _data_k_1 = 0;
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[0] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[1] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[2] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[3] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[4] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[5] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[6] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[7] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[8] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[9] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[10] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[11] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[12] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[13] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[14] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[15] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[16] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[17] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[18] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[19] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[20] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[21] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[22] = _data_l_1[_data_k_1++];
    if (_data_k_1 >= _data_n_1) {
      _data_k_1 = 0;
    }
    c_[23] = _data_l_1[_data_k_1++];
  }
  if (__calls[1].calls == 0) {
    _data_k_2 = 0;
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[24] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[25] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[26] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[27] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[28] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[29] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[30] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[31] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[32] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[33] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[34] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[35] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[36] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[37] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[38] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[39] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[40] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[41] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[42] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[43] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[44] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[45] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[46] = _data_l_2[_data_k_2++];
    if (_data_k_2 >= _data_n_2) {
      _data_k_2 = 0;
    }
    c_[47] = _data_l_2[_data_k_2++];
  }
  if (__calls[1].calls == 0) {
    _data_k_3 = 0;
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[48] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[49] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[50] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[51] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[52] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[53] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[54] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[55] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[56] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[57] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[58] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[59] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[60] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[61] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[62] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[63] = _data_l_3[_data_k_3++];
    if (_data_k_3 >= _data_n_3) {
      _data_k_3 = 0;
    }
    c_[64] = _data_l_3[_data_k_3++];
  }
  tol_ = _r1mach (($0_ = 3, &$0_));
  tol_ = _max (tol_, 1.0e-15);
  fn_ = (*fnu_);
  z_ = (3.0e0 - (*flgik_)) / 2.0e0;
  kk_ = (int_4) (_aintd (z_));
  for (jn_ = 1; jn_ <= (*in_); (jn_)++) {
    if (jn_ == 1) {
      goto _l10;
    }
    fn_ = fn_ - (*flgik_);
    z_ = (*x_) / fn_;
    (*ra_) = sqrtf (1.0e0 + z_ * z_);
    gln_ = logf ((1.0e0 + (*ra_)) / z_);
    etx_ = (*kode_) - 1;
    t_ = (*ra_) * (1.0e0 - etx_) + etx_ / (z_ + (*ra_));
    (*arg_) = fn_ * (t_ - gln_) * (*flgik_);
    _l10:;
    coef_ = expf ((*arg_));
    t_ = 1.0e0 / (*ra_);
    t2_ = t_ * t_;
    t_ = t_ / fn_;
    t_ = _sign (t_, (*flgik_));
    s2_ = 1.0;
    ap_ = 1.0;
    l_ = 0;
    for (k_ = 2; k_ <= 11; (k_)++) {
      l_ = l_ + 1;
      s1_ = c_[l_ - 1];
      for (j_ = 2; j_ <= k_; (j_)++) {
        l_ = l_ + 1;
        s1_ = s1_ * t2_ + c_[l_ - 1];
      }
      ap_ = ap_ * t_;
      ak_ = ap_ * s1_;
      s2_ = s2_ + ak_;
      if (_max (_abs (ak_), _abs (ap_)) < tol_) {
        goto _l40;
      }
    }
    _l40:;
    t_ = _abs (t_);
    y_[jn_ - 1] = s2_ * coef_ * sqrtf (t_) * con_[kk_ - 1];
  }
  __calls[1].calls++;
  return 0;
}

int_4 _asyjy (int_4 (*_funjy)(), real_4 _p_ x_, real_4 _p_ fnu_, real_4 _p_ flgjy_, int_4 _p_ in_, real_4 _p_ y_, 
real_4 _p_ wk_, int_4 _p_ iflw_)
{
  static int_4 i_, j_, jn_, jr_, ju_, k_, kb_, klast_, kmax_[5], kp1_, ks_, ksp1_, kstemp_, l_, lr_, lrp1_, iseta_, 
  isetb_;
  static real_4 abw2_, akm_, alfa_[104], (_p_ alfa1_), (_p_ alfa2_), ap_, ar_[8], asum_, az_, beta_[130], (_p_ beta1_), 
  (_p_ beta2_), (_p_ beta3_), br_[10], bsum_, c_[65], con1_, con2_, con548_, cr_[10], crz32_, dfi_, elim_, dr_[10], fi_, 
  fn_, fn2_, gama_[26], phi_, rcz_, rden_, relb_, rfn2_, rtz_, rzden_, sa_, sb_, suma_, sumb_, s1_, ta_, tau_, tb_, tfn_, 
  tol_, tols_, t2_, upol_[10], xx_, z_, z32_;
  int_4 _data_k_4, _data_k_5, _data_k_6, _data_k_7, _data_k_8, _data_k_9, _data_k_10, _data_k_11, _data_k_12, _data_k_13, 
  _data_k_14, _data_k_15, _data_k_16, _data_k_17, _data_k_18, _data_k_19, _data_k_20, $0_, $1_, $2_, $3_;
  extern int_4 _i1mach ();
  extern real_4 _r1mach ();
  alfa1_ = (real_4 (_p_)) alfa_;
  alfa2_ = (real_4 (_p_)) &(alfa_[52]);
  beta1_ = (real_4 (_p_)) beta_;
  beta2_ = (real_4 (_p_)) &(beta_[52]);
  beta3_ = (real_4 (_p_)) &(beta_[104]);
#define _data_n_4 1
  static real_4 _data_l_4[_data_n_4] = {
    -6.90775527898214e+00
  };
#define _data_n_5 3
  static real_4 _data_l_5[_data_n_5] = {
    6.66666666666667e-1,
    3.33333333333333e-1,
    1.04166666666667e-1
  };
#define _data_n_6 8
  static real_4 _data_l_6[_data_n_6] = {
    8.35503472222222e-2,
    1.28226574556327e-1,
    2.9184902646414e-1,
    8.81627267443758e-1,
    3.32140828186277e+00,
    1.49957629868626e1,
    7.89230130115865e1,
    4.74451538868264e2
  };
#define _data_n_7 10
  static real_4 _data_l_7[_data_n_7] = {
    -1.45833333333333e-1,
    -9.87413194444444e-2,
    -1.43312053915895e-1,
    -3.17227202678414e-1,
    -9.4242914795712e-1,
    -3.51120304082635e+00,
    -1.5727263620368e1,
    -8.22814390971859e1,
    -4.92355370523671e2,
    -3.31621856854797e3
  };
#define _data_n_8 24
  static real_4 _data_l_8[_data_n_8] = {
    -2.08333333333333e-1,
    1.25e-1,
    3.34201388888889e-1,
    -4.01041666666667e-1,
    7.03125e-2,
    -1.02581259645062e+00,
    1.84646267361111e+00,
    -8.912109375e-1,
    7.32421875e-2,
    4.66958442342625e+00,
    -1.1207002616223e1,
    8.78912353515625e+00,
    -2.3640869140625e+00,
    1.12152099609375e-1,
    -2.82120725582002e1,
    8.46362176746007e1,
    -9.181824154324e1,
    4.25349987453885e1,
    -7.36879435947963e+00,
    2.27108001708984e-1,
    2.12570130039217e2,
    -7.65252468141182e2,
    1.059990452528e3,
    -6.99579627376133e2
  };
#define _data_n_9 24
  static real_4 _data_l_9[_data_n_9] = {
    2.18190511744212e2,
    -2.64914304869516e1,
    5.72501420974731e-1,
    -1.91945766231841e3,
    8.06172218173731e3,
    -1.35865500064341e4,
    1.16553933368645e4,
    -5.3056469786134e3,
    1.20090291321635e3,
    -1.08090919788395e2,
    1.72772750258446e+00,
    2.02042913309661e4,
    -9.69805983886375e4,
    1.92547001232532e5,
    -2.03400177280416e5,
    1.22200464983017e5,
    -4.11926549688976e4,
    7.10951430248936e3,
    -4.93915304773088e2,
    6.07404200127348e+00,
    -2.42919187900551e5,
    1.31176361466298e6,
    -2.99801591853811e6,
    3.7632712976564e6
  };
#define _data_n_10 17
  static real_4 _data_l_10[_data_n_10] = {
    -2.81356322658653e6,
    1.26836527332162e6,
    -3.31645172484564e5,
    4.52187689813627e4,
    -2.49983048181121e3,
    2.43805296995561e1,
    3.28446985307204e6,
    -1.97068191184322e7,
    5.09526024926646e7,
    -7.41051482115327e7,
    6.6344512274729e7,
    -3.75671766607634e7,
    1.32887671664218e7,
    -2.78561812808645e6,
    3.08186404612662e5,
    -1.3886089753717e4,
    1.10017140269247e2
  };
#define _data_n_11 26
  static real_4 _data_l_11[_data_n_11] = {
    -4.44444444444444e-3,
    -9.22077922077922e-4,
    -8.84892884892885e-5,
    1.6592768783245e-4,
    2.46691372741793e-4,
    2.65995589346255e-4,
    2.61824297061501e-4,
    2.48730437344656e-4,
    2.32721040083232e-4,
    2.16362485712365e-4,
    2.00738858762752e-4,
    1.86267636637545e-4,
    1.73060775917876e-4,
    1.61091705929016e-4,
    1.50274774160908e-4,
    1.4050349739127e-4,
    1.31668816545923e-4,
    1.23667445598253e-4,
    1.16405271474738e-4,
    1.09798298372713e-4,
    1.03772410422993e-4,
    9.82626078369363e-5,
    9.32120517249503e-5,
    8.85710852478712e-5,
    8.429631057157e-5,
    8.03497548407791e-5
  };
#define _data_n_12 26
  static real_4 _data_l_12[_data_n_12] = {
    6.93735541354589e-4,
    2.32241745182922e-4,
    -1.41986273556691e-5,
    -1.16444931672049e-4,
    -1.50803558053049e-4,
    -1.55121924918096e-4,
    -1.46809756646466e-4,
    -1.33815503867491e-4,
    -1.19744975684254e-4,
    -1.06184319207974e-4,
    -9.37699549891194e-5,
    -8.26923045588193e-5,
    -7.29374348155221e-5,
    -6.44042357721016e-5,
    -5.69611566009369e-5,
    -5.04731044303562e-5,
    -4.48134868008883e-5,
    -3.98688727717599e-5,
    -3.55400532972042e-5,
    -3.17414256609022e-5,
    -2.83996793904175e-5,
    -2.54522720634871e-5,
    -2.28459297164725e-5,
    -2.05352753106481e-5,
    -1.84816217627666e-5,
    -1.66519330021394e-5
  };
#define _data_n_13 26
  static real_4 _data_l_13[_data_n_13] = {
    -3.54211971457744e-4,
    -1.56161263945159e-4,
    3.04465503594936e-5,
    1.30198655773243e-4,
    1.67471106699712e-4,
    1.70222587683593e-4,
    1.56501427608595e-4,
    1.36339170977445e-4,
    1.14886692029825e-4,
    9.45869093034688e-5,
    7.64498419250898e-5,
    6.07570334965197e-5,
    4.74394299290509e-5,
    3.62757512005344e-5,
    2.69939714979225e-5,
    1.93210938247939e-5,
    1.30056674793963e-5,
    7.82620866744497e-6,
    3.59257485819352e-6,
    1.44040049814252e-7,
    -2.65396769697939e-6,
    -4.91346867098486e-6,
    -6.72739296091248e-6,
    -8.17269379678658e-6,
    -9.31304715093561e-6,
    -1.02011418798016e-5
  };
#define _data_n_14 26
  static real_4 _data_l_14[_data_n_14] = {
    3.78194199201773e-4,
    2.02471952761816e-4,
    -6.37938506318862e-5,
    -2.38598230603006e-4,
    -3.10916256027362e-4,
    -3.13680115247576e-4,
    -2.78950273791323e-4,
    -2.28564082619141e-4,
    -1.75245280340847e-4,
    -1.2554406306069e-4,
    -8.22982872820208e-5,
    -4.62860730588116e-5,
    -1.72334302366962e-5,
    5.60690482304602e-6,
    2.31395443148287e-5,
    3.62642745856794e-5,
    4.58006124490189e-5,
    5.24595294959114e-5,
    5.68396208545815e-5,
    5.94349820393104e-5,
    6.06478527578422e-5,
    6.08023907788436e-5,
    6.0157789453946e-5,
    5.89199657344698e-5,
    5.72515823777593e-5,
    5.52804375585853e-5
  };
#define _data_n_15 26
  static real_4 _data_l_15[_data_n_15] = {
    1.79988721413553e-2,
    5.59964911064388e-3,
    2.88501402231133e-3,
    1.80096606761054e-3,
    1.24753110589199e-3,
    9.22878876572938e-4,
    7.14430421727287e-4,
    5.71787281789705e-4,
    4.69431007606482e-4,
    3.93232835462917e-4,
    3.34818889318298e-4,
    2.88952148495752e-4,
    2.52211615549573e-4,
    2.22280580798883e-4,
    1.97541838033063e-4,
    1.76836855019718e-4,
    1.59316899661821e-4,
    1.44347930197334e-4,
    1.31448068119965e-4,
    1.20245444949303e-4,
    1.10449144504599e-4,
    1.01828770740567e-4,
    9.41998224204238e-5,
    8.74130545753834e-5,
    8.13466262162801e-5,
    7.59002269646219e-5
  };
#define _data_n_16 26
  static real_4 _data_l_16[_data_n_16] = {
    -1.49282953213429e-3,
    -8.78204709546389e-4,
    -5.02916549572035e-4,
    -2.94822138512746e-4,
    -1.75463996970783e-4,
    -1.04008550460816e-4,
    -5.96141953046458e-5,
    -3.12038929076098e-5,
    -1.2608973598023e-5,
    -2.4289260857573e-7,
    8.05996165414274e-6,
    1.36507009262147e-5,
    1.73964125472926e-5,
    1.98672978842134e-5,
    2.14463263790823e-5,
    2.23954659232457e-5,
    2.28967783814713e-5,
    2.30785389811178e-5,
    2.30321976080909e-5,
    2.28236073720349e-5,
    2.25005881105292e-5,
    2.20981015361991e-5,
    2.16418427448104e-5,
    2.11507649256221e-5,
    2.06388749782171e-5,
    2.01165241997082e-5
  };
#define _data_n_17 26
  static real_4 _data_l_17[_data_n_17] = {
    5.52213076721293e-4,
    4.47932581552385e-4,
    2.79520653992021e-4,
    1.52468156198447e-4,
    6.93271105657044e-5,
    1.76258683069991e-5,
    -1.35744996343269e-5,
    -3.17972413350427e-5,
    -4.18861861696693e-5,
    -4.69004889379141e-5,
    -4.87665447413787e-5,
    -4.87010031186735e-5,
    -4.74755620890087e-5,
    -4.55813058138628e-5,
    -4.33309644511266e-5,
    -4.0923019315775e-5,
    -3.84822638603221e-5,
    -3.60857167535411e-5,
    -3.37793306123367e-5,
    -3.1588856077211e-5,
    -2.95269561750807e-5,
    -2.75978914828336e-5,
    -2.58006174666884e-5,
    -2.4130835676128e-5,
    -2.25823509518346e-5,
    -2.11479656768913e-5
  };
#define _data_n_18 26
  static real_4 _data_l_18[_data_n_18] = {
    -4.7461779655996e-4,
    -4.77864567147321e-4,
    -3.20390228067038e-4,
    -1.61105016119962e-4,
    -4.25778101285435e-5,
    3.44571294294968e-5,
    7.97092684075675e-5,
    1.03138236708272e-4,
    1.12466775262204e-4,
    1.13103642108481e-4,
    1.08651634848774e-4,
    1.01437951597662e-4,
    9.29298396593364e-5,
    8.4029313301609e-5,
    7.52727991349134e-5,
    6.69632521975731e-5,
    5.92564547323195e-5,
    5.22169308826976e-5,
    4.58539485165361e-5,
    4.01445513891487e-5,
    3.50481730031328e-5,
    3.05157995034347e-5,
    2.64956119950516e-5,
    2.29363633690998e-5,
    1.97893056664022e-5,
    1.70091984636413e-5
  };
#define _data_n_19 26
  static real_4 _data_l_19[_data_n_19] = {
    7.36465810572578e-4,
    8.72790805146194e-4,
    6.22614862573135e-4,
    2.85998154194304e-4,
    3.84737672879366e-6,
    -1.87906003636972e-4,
    -2.97603646594555e-4,
    -3.45998126832656e-4,
    -3.53382470916038e-4,
    -3.35715635775049e-4,
    -3.0432112478904e-4,
    -2.66722723047613e-4,
    -2.2765421412282e-4,
    -1.89922611854562e-4,
    -1.55058918599094e-4,
    -1.23778240761874e-4,
    -9.62926147717644e-5,
    -7.25178327714425e-5,
    -5.22070028895634e-5,
    -3.50347750511901e-5,
    -2.06489761035552e-5,
    -8.70106096849767e-6,
    1.136986866751e-6,
    9.16426474122779e-6,
    1.56477785428873e-5,
    2.08223629482467e-5
  };
#define _data_n_20 26
  static real_4 _data_l_20[_data_n_20] = {
    6.29960524947437e-1,
    2.51984209978975e-1,
    1.54790300415656e-1,
    1.10713062416159e-1,
    8.57309395527395e-2,
    6.97161316958684e-2,
    5.86085671893714e-2,
    5.04698873536311e-2,
    4.42600580689155e-2,
    3.9372066154351e-2,
    3.54283195924455e-2,
    3.21818857502098e-2,
    2.94646240791158e-2,
    2.71581677112934e-2,
    2.51768272973862e-2,
    2.34570755306079e-2,
    2.19508390134907e-2,
    2.06210828235646e-2,
    1.94388240897881e-2,
    1.83810633800683e-2,
    1.74293213231963e-2,
    1.65685837786612e-2,
    1.57865285987918e-2,
    1.50729501494096e-2,
    1.44193250839955e-2,
    1.38184805735342e-2
  };
  if (__calls[2].calls == 0) {
    _data_k_4 = 0;
    if (_data_k_4 >= _data_n_4) {
      _data_k_4 = 0;
    }
    tols_ = _data_l_4[_data_k_4++];
  }
  if (__calls[2].calls == 0) {
    _data_k_5 = 0;
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    con1_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    con2_ = _data_l_5[_data_k_5++];
    if (_data_k_5 >= _data_n_5) {
      _data_k_5 = 0;
    }
    con548_ = _data_l_5[_data_k_5++];
  }
  if (__calls[2].calls == 0) {
    _data_k_6 = 0;
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ar_[0] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ar_[1] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ar_[2] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ar_[3] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ar_[4] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ar_[5] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ar_[6] = _data_l_6[_data_k_6++];
    if (_data_k_6 >= _data_n_6) {
      _data_k_6 = 0;
    }
    ar_[7] = _data_l_6[_data_k_6++];
  }
  if (__calls[2].calls == 0) {
    _data_k_7 = 0;
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[0] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[1] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[2] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[3] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[4] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[5] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[6] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[7] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[8] = _data_l_7[_data_k_7++];
    if (_data_k_7 >= _data_n_7) {
      _data_k_7 = 0;
    }
    br_[9] = _data_l_7[_data_k_7++];
  }
  if (__calls[2].calls == 0) {
    _data_k_8 = 0;
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[0] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[1] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[2] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[3] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[4] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[5] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[6] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[7] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[8] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[9] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[10] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[11] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[12] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[13] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[14] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[15] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[16] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[17] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[18] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[19] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[20] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[21] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[22] = _data_l_8[_data_k_8++];
    if (_data_k_8 >= _data_n_8) {
      _data_k_8 = 0;
    }
    c_[23] = _data_l_8[_data_k_8++];
  }
  if (__calls[2].calls == 0) {
    _data_k_9 = 0;
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[24] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[25] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[26] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[27] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[28] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[29] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[30] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[31] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[32] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[33] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[34] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[35] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[36] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[37] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[38] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[39] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[40] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[41] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[42] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[43] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[44] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[45] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[46] = _data_l_9[_data_k_9++];
    if (_data_k_9 >= _data_n_9) {
      _data_k_9 = 0;
    }
    c_[47] = _data_l_9[_data_k_9++];
  }
  if (__calls[2].calls == 0) {
    _data_k_10 = 0;
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[48] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[49] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[50] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[51] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[52] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[53] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[54] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[55] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[56] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[57] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[58] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[59] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[60] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[61] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[62] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[63] = _data_l_10[_data_k_10++];
    if (_data_k_10 >= _data_n_10) {
      _data_k_10 = 0;
    }
    c_[64] = _data_l_10[_data_k_10++];
  }
  if (__calls[2].calls == 0) {
    _data_k_11 = 0;
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[0] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[1] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[2] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[3] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[4] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[5] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[6] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[7] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[8] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[9] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[10] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[11] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[12] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[13] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[14] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[15] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[16] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[17] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[18] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[19] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[20] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[21] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[22] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[23] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[24] = _data_l_11[_data_k_11++];
    if (_data_k_11 >= _data_n_11) {
      _data_k_11 = 0;
    }
    alfa1_[25] = _data_l_11[_data_k_11++];
  }
  if (__calls[2].calls == 0) {
    _data_k_12 = 0;
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[26] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[27] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[28] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[29] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[30] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[31] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[32] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[33] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[34] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[35] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[36] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[37] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[38] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[39] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[40] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[41] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[42] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[43] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[44] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[45] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[46] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[47] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[48] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[49] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[50] = _data_l_12[_data_k_12++];
    if (_data_k_12 >= _data_n_12) {
      _data_k_12 = 0;
    }
    alfa1_[51] = _data_l_12[_data_k_12++];
  }
  if (__calls[2].calls == 0) {
    _data_k_13 = 0;
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[0] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[1] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[2] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[3] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[4] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[5] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[6] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[7] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[8] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[9] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[10] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[11] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[12] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[13] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[14] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[15] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[16] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[17] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[18] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[19] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[20] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[21] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[22] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[23] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[24] = _data_l_13[_data_k_13++];
    if (_data_k_13 >= _data_n_13) {
      _data_k_13 = 0;
    }
    alfa2_[25] = _data_l_13[_data_k_13++];
  }
  if (__calls[2].calls == 0) {
    _data_k_14 = 0;
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[26] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[27] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[28] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[29] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[30] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[31] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[32] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[33] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[34] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[35] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[36] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[37] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[38] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[39] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[40] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[41] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[42] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[43] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[44] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[45] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[46] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[47] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[48] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[49] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[50] = _data_l_14[_data_k_14++];
    if (_data_k_14 >= _data_n_14) {
      _data_k_14 = 0;
    }
    alfa2_[51] = _data_l_14[_data_k_14++];
  }
  if (__calls[2].calls == 0) {
    _data_k_15 = 0;
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[0] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[1] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[2] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[3] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[4] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[5] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[6] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[7] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[8] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[9] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[10] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[11] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[12] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[13] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[14] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[15] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[16] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[17] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[18] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[19] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[20] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[21] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[22] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[23] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[24] = _data_l_15[_data_k_15++];
    if (_data_k_15 >= _data_n_15) {
      _data_k_15 = 0;
    }
    beta1_[25] = _data_l_15[_data_k_15++];
  }
  if (__calls[2].calls == 0) {
    _data_k_16 = 0;
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[26] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[27] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[28] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[29] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[30] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[31] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[32] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[33] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[34] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[35] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[36] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[37] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[38] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[39] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[40] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[41] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[42] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[43] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[44] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[45] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[46] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[47] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[48] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[49] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[50] = _data_l_16[_data_k_16++];
    if (_data_k_16 >= _data_n_16) {
      _data_k_16 = 0;
    }
    beta1_[51] = _data_l_16[_data_k_16++];
  }
  if (__calls[2].calls == 0) {
    _data_k_17 = 0;
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[0] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[1] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[2] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[3] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[4] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[5] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[6] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[7] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[8] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[9] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[10] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[11] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[12] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[13] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[14] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[15] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[16] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[17] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[18] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[19] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[20] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[21] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[22] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[23] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[24] = _data_l_17[_data_k_17++];
    if (_data_k_17 >= _data_n_17) {
      _data_k_17 = 0;
    }
    beta2_[25] = _data_l_17[_data_k_17++];
  }
  if (__calls[2].calls == 0) {
    _data_k_18 = 0;
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[26] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[27] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[28] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[29] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[30] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[31] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[32] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[33] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[34] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[35] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[36] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[37] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[38] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[39] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[40] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[41] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[42] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[43] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[44] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[45] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[46] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[47] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[48] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[49] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[50] = _data_l_18[_data_k_18++];
    if (_data_k_18 >= _data_n_18) {
      _data_k_18 = 0;
    }
    beta2_[51] = _data_l_18[_data_k_18++];
  }
  if (__calls[2].calls == 0) {
    _data_k_19 = 0;
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[0] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[1] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[2] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[3] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[4] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[5] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[6] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[7] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[8] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[9] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[10] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[11] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[12] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[13] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[14] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[15] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[16] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[17] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[18] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[19] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[20] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[21] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[22] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[23] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[24] = _data_l_19[_data_k_19++];
    if (_data_k_19 >= _data_n_19) {
      _data_k_19 = 0;
    }
    beta3_[25] = _data_l_19[_data_k_19++];
  }
  if (__calls[2].calls == 0) {
    _data_k_20 = 0;
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[0] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[1] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[2] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[3] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[4] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[5] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[6] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[7] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[8] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[9] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[10] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[11] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[12] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[13] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[14] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[15] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[16] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[17] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[18] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[19] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[20] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[21] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[22] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[23] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[24] = _data_l_20[_data_k_20++];
    if (_data_k_20 >= _data_n_20) {
      _data_k_20 = 0;
    }
    gama_[25] = _data_l_20[_data_k_20++];
  }
  ta_ = _r1mach (($0_ = 3, &$0_));
  tol_ = _max (ta_, 1.0e-15);
  tb_ = _r1mach (($1_ = 5, &$1_));
  ju_ = _i1mach (($2_ = 12, &$2_));
  if ((*flgjy_) == 1.0e0) {
    goto _l6;
  }
  jr_ = _i1mach (($3_ = 11, &$3_));
  elim_ = -2.303e0 * tb_ * (ju_ + jr_);
  goto _l7;
  _l6:;
  elim_ = -2.303e0 * (tb_ * ju_ + 3.0e0);
  _l7:;
  fn_ = (*fnu_);
  (*iflw_) = 0;
  for (jn_ = 1; jn_ <= (*in_); (jn_)++) {
    xx_ = (*x_) / fn_;
    wk_[0] = 1.0e0 - xx_ * xx_;
    abw2_ = _abs (wk_[0]);
    wk_[1] = sqrtf (abw2_);
    wk_[6] = powl (fn_, con2_);
    if (abw2_ > 0.2775e0) {
      goto _l80;
    }
    sa_ = 0.0;
    if (abw2_ == 0.0e0) {
      goto _l10;
    }
    sa_ = tols_ / logf (abw2_);
    _l10:;
    sb_ = sa_;
    for (i_ = 1; i_ <= 5; (i_)++) {
      akm_ = _max (sa_, 2.0);
      kmax_[i_ - 1] = (int_4) (_aintd (akm_));
      sa_ = sa_ + sb_;
    }
    kb_ = kmax_[4];
    klast_ = kb_ - 1;
    sa_ = gama_[kb_ - 1];
    for (k_ = 1; k_ <= klast_; (k_)++) {
      kb_ = kb_ - 1;
      sa_ = sa_ * wk_[0] + gama_[kb_ - 1];
    }
    z_ = wk_[0] * sa_;
    az_ = _abs (z_);
    rtz_ = sqrtf (az_);
    wk_[2] = con1_ * az_ * rtz_;
    wk_[3] = wk_[2] * fn_;
    wk_[4] = rtz_ * wk_[6];
    wk_[5] = -wk_[4] * wk_[4];
    if (z_ <= 0.0e0) {
      goto _l35;
    }
    if (wk_[3] > elim_) {
      goto _l75;
    }
    wk_[5] = -wk_[5];
    _l35:;
    phi_ = sqrtf (sqrtf (sa_ + sa_ + sa_ + sa_));
    kb_ = kmax_[4];
    klast_ = kb_ - 1;
    sb_ = beta_[kb_ - 1];
    for (k_ = 1; k_ <= klast_; (k_)++) {
      kb_ = kb_ - 1;
      sb_ = sb_ * wk_[0] + beta_[kb_ - 1];
    }
    ksp1_ = 1;
    fn2_ = fn_ * fn_;
    rfn2_ = 1.0e0 / fn2_;
    rden_ = 1.0;
    asum_ = 1.0;
    relb_ = tol_ * _abs (sb_);
    bsum_ = sb_;
    for (ks_ = 1; ks_ <= 4; (ks_)++) {
      ksp1_ = ksp1_ + 1;
      rden_ = rden_ * rfn2_;
      kstemp_ = 5 - ks_;
      kb_ = kmax_[kstemp_ - 1];
      klast_ = kb_ - 1;
      sa_ = alfa_[kb_ - 1 + (26) * ((ks_ - 1))];
      sb_ = beta_[kb_ - 1 + (26) * ((ksp1_ - 1))];
      for (k_ = 1; k_ <= klast_; (k_)++) {
        kb_ = kb_ - 1;
        sa_ = sa_ * wk_[0] + alfa_[kb_ - 1 + (26) * ((ks_ - 1))];
        sb_ = sb_ * wk_[0] + beta_[kb_ - 1 + (26) * ((ksp1_ - 1))];
      }
      ta_ = sa_ * rden_;
      tb_ = sb_ * rden_;
      asum_ = asum_ + ta_;
      bsum_ = bsum_ + tb_;
      if (_abs (ta_) <= tol_ && _abs (tb_) <= relb_) {
        goto _l70;
      }
    }
    _l70:;
    bsum_ = bsum_ / (fn_ * wk_[6]);
    goto _l160;
    _l75:;
    (*iflw_) = 1;
    goto _l0;
    _l80:;
    upol_[0] = 1.0;
    tau_ = 1.0e0 / wk_[1];
    t2_ = 1.0e0 / wk_[0];
    if (wk_[0] >= 0.0e0) {
      goto _l90;
    }
    wk_[2] = _abs (wk_[1] - atanf (wk_[1]));
    wk_[3] = wk_[2] * fn_;
    rcz_ = -con1_ / wk_[3];
    z32_ = 1.5e0 * wk_[2];
    rtz_ = powl (z32_, con2_);
    wk_[4] = rtz_ * wk_[6];
    wk_[5] = -wk_[4] * wk_[4];
    goto _l100;
    _l90:;
    wk_[2] = _abs (logf ((1.0e0 + wk_[1]) / xx_) - wk_[1]);
    wk_[3] = wk_[2] * fn_;
    rcz_ = con1_ / wk_[3];
    if (wk_[3] > elim_) {
      goto _l75;
    }
    z32_ = 1.5e0 * wk_[2];
    rtz_ = powl (z32_, con2_);
    wk_[6] = powl (fn_, con2_);
    wk_[4] = rtz_ * wk_[6];
    wk_[5] = wk_[4] * wk_[4];
    _l100:;
    phi_ = sqrtf ((rtz_ + rtz_) * tau_);
    tb_ = 1.0;
    asum_ = 1.0;
    tfn_ = tau_ / fn_;
    rden_ = 1.0e0 / fn_;
    rfn2_ = rden_ * rden_;
    rden_ = 1.0;
    upol_[1] = (c_[0] * t2_ + c_[1]) * tfn_;
    crz32_ = con548_ * rcz_;
    bsum_ = upol_[1] + crz32_;
    relb_ = tol_ * _abs (bsum_);
    ap_ = tfn_;
    ks_ = 0;
    kp1_ = 2;
    rzden_ = rcz_;
    l_ = 2;
    iseta_ = 0;
    isetb_ = 0;
    for (lr_ = 2; (2 > 0 ? lr_ <= 8 : lr_ >= 8); lr_ += 2) {
      lrp1_ = lr_ + 1;
      for (k_ = lr_; k_ <= lrp1_; (k_)++) {
        ks_ = ks_ + 1;
        kp1_ = kp1_ + 1;
        l_ = l_ + 1;
        s1_ = c_[l_ - 1];
        for (j_ = 2; j_ <= kp1_; (j_)++) {
          l_ = l_ + 1;
          s1_ = s1_ * t2_ + c_[l_ - 1];
        }
        ap_ = ap_ * tfn_;
        upol_[kp1_ - 1] = ap_ * s1_;
        cr_[ks_ - 1] = br_[ks_ - 1] * rzden_;
        rzden_ = rzden_ * rcz_;
        dr_[ks_ - 1] = ar_[ks_ - 1] * rzden_;
      }
      suma_ = upol_[lrp1_ - 1];
      sumb_ = upol_[lr_ + 2 - 1] + upol_[lrp1_ - 1] * crz32_;
      ju_ = lrp1_;
      for (jr_ = 1; jr_ <= lr_; (jr_)++) {
        ju_ = ju_ - 1;
        suma_ = suma_ + cr_[jr_ - 1] * upol_[ju_ - 1];
        sumb_ = sumb_ + dr_[jr_ - 1] * upol_[ju_ - 1];
      }
      rden_ = rden_ * rfn2_;
      tb_ = -tb_;
      if (wk_[0] > 0.0e0) {
        tb_ = _abs (tb_);
      }
      if (rden_ < tol_) {
        goto _l131;
      }
      asum_ = asum_ + suma_ * tb_;
      bsum_ = bsum_ + sumb_ * tb_;
      goto _l140;
      _l131:;
      if (iseta_ == 1) {
        goto _l132;
      }
      if (_abs (suma_) < tol_) {
        iseta_ = 1;
      }
      asum_ = asum_ + suma_ * tb_;
      _l132:;
      if (isetb_ == 1) {
        goto _l133;
      }
      if (_abs (sumb_) < relb_) {
        isetb_ = 1;
      }
      bsum_ = bsum_ + sumb_ * tb_;
      _l133:;
      if (iseta_ == 1 && isetb_ == 1) {
        goto _l150;
      }
      _l140:;
    }
    _l150:;
    tb_ = wk_[4];
    if (wk_[0] > 0.0e0) {
      tb_ = -tb_;
    }
    bsum_ = bsum_ / tb_;
    _l160:;
    (void) _funjy (&wk_[5], &wk_[4], &wk_[3], &fi_, &dfi_);
    ta_ = 1.0e0 / tol_;
    tb_ = _r1mach (&_k1) * ta_ * 1.0e3;
    if (_abs (fi_) > tb_) {
      goto _l165;
    }
    fi_ = fi_ * ta_;
    dfi_ = dfi_ * ta_;
    phi_ = phi_ * tol_;
    _l165:;
    y_[jn_ - 1] = (*flgjy_) * phi_ * (fi_ * asum_ + dfi_ * bsum_) / wk_[6];
    fn_ = fn_ - (*flgjy_);
  }
  _l0:;
  __calls[2].calls++;
  return 0;
}

int_4 _avint (real_4 _p_ x_, real_4 _p_ y_, int_4 _p_ n_, real_4 _p_ xlo_, real_4 _p_ xup_, real_4 _p_ ans_, int_4 _p_ 
ierr_)
{
  static int_4 i_, inlft_, inrt_, istart_, istop_;
  static real_4 slope_, fl_, fr_;
  static real_8 r3_, rp5_, sum_, syl_, syl2_, syl3_, syu_, syu2_, syu3_, x1_, x2_, x3_, x12_, x13_, x23_, term1_, term2_, 
  term3_, a_, b_, c_, ca_, cb_, cc_;
  int_4 $1_, $3_, $5_, $7_, $8_;
  real_4 $0_;
  char_127 $2_, $4_, $6_;
  (*ierr_) = 1;
  (*ans_) = 0.0;
  $0_ = (*xlo_) - (*xup_);
  if ($0_ < 0) {
    goto _l3;
  } else if ($0_ == 0) {
    goto _l100;
  } else {
    goto _l200;
  }
  _l3:;
  if ((*n_) < 2) {
    goto _l215;
  }
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l210;
    }
    if (x_[i_ - 1] > (*xup_)) {
      goto _l6;
    }
  }
  _l6:;
  if ((*n_) >= 3) {
    goto _l9;
  }
  slope_ = (y_[1] - y_[0]) / (x_[1] - x_[0]);
  fl_ = y_[0] + slope_ * ((*xlo_) - x_[0]);
  fr_ = y_[1] + slope_ * ((*xup_) - x_[1]);
  (*ans_) = 0.5 * (fl_ + fr_) * ((*xup_) - (*xlo_));
  goto _l0;
  _l9:;
  if (x_[(*n_) - 2 - 1] < (*xlo_)) {
    goto _l205;
  }
  if (x_[2] > (*xup_)) {
    goto _l205;
  }
  i_ = 1;
  _l10:;
  if (x_[i_ - 1] >= (*xlo_)) {
    goto _l15;
  }
  i_ = i_ + 1;
  goto _l10;
  _l15:;
  inlft_ = i_;
  i_ = (*n_);
  _l20:;
  if (x_[i_ - 1] <= (*xup_)) {
    goto _l25;
  }
  i_ = i_ - 1;
  goto _l20;
  _l25:;
  inrt_ = i_;
  if ((inrt_ - inlft_) < 2) {
    goto _l205;
  }
  istart_ = inlft_;
  if (inlft_ == 1) {
    istart_ = 2;
  }
  istop_ = inrt_;
  if (inrt_ == (*n_)) {
    istop_ = (*n_) - 1;
  }
  r3_ = 3.0;
  rp5_ = 0.5;
  sum_ = 0.0;
  syl_ = (*xlo_);
  syl2_ = syl_ * syl_;
  syl3_ = syl2_ * syl_;
  for (i_ = istart_; i_ <= istop_; (i_)++) {
    x1_ = x_[i_ - 1 - 1];
    x2_ = x_[i_ - 1];
    x3_ = x_[i_ + 1 - 1];
    x12_ = x1_ - x2_;
    x13_ = x1_ - x3_;
    x23_ = x2_ - x3_;
    term1_ = (real_8) (y_[i_ - 1 - 1]) / (x12_ * x13_);
    term2_ = -(real_8) (y_[i_ - 1]) / (x12_ * x23_);
    term3_ = (real_8) (y_[i_ + 1 - 1]) / (x13_ * x23_);
    a_ = term1_ + term2_ + term3_;
    b_ = -(x2_ + x3_) * term1_ - (x1_ + x3_) * term2_ - (x1_ + x2_) * term3_;
    c_ = x2_ * x3_ * term1_ + x1_ * x3_ * term2_ + x1_ * x2_ * term3_;
    $1_ = i_ - istart_;
    if ($1_ < 0) {
      goto _l30;
    } else if ($1_ == 0) {
      goto _l30;
    } else {
      goto _l35;
    }
    _l30:;
    ca_ = a_;
    cb_ = b_;
    cc_ = c_;
    goto _l40;
    _l35:;
    ca_ = 0.5 * (a_ + ca_);
    cb_ = 0.5 * (b_ + cb_);
    cc_ = 0.5 * (c_ + cc_);
    _l40:;
    syu_ = x2_;
    syu2_ = syu_ * syu_;
    syu3_ = syu2_ * syu_;
    sum_ = sum_ + ca_ * (syu3_ - syl3_) / r3_ + cb_ * rp5_ * (syu2_ - syl2_) + cc_ * (syu_ - syl_);
    ca_ = a_;
    cb_ = b_;
    cc_ = c_;
    syl_ = syu_;
    syl2_ = syu2_;
    syl3_ = syu3_;
  }
  syu_ = (*xup_);
  (*ans_) = sum_ + ca_ * ((syu_ * syu_ * syu_) - syl3_) / r3_ + cb_ * rp5_ * ((syu_ * syu_) - syl2_) + cc_ * (syu_ - 
  syl_);
  _l100:;
  goto _l0;
  _l200:;
  (*ierr_) = 2;
  (void) _xermsg (_dc_1, _dc_2, concat ($2_, _dc_3, _dc_4), ($3_ = 4, &$3_), &_k1);
  goto _l0;
  _l205:;
  (*ierr_) = 3;
  (void) _xermsg (_dc_1, _dc_2, concat ($4_, _dc_5, _dc_6), ($5_ = 4, &$5_), &_k1);
  goto _l0;
  _l210:;
  (*ierr_) = 4;
  (void) _xermsg (_dc_1, _dc_2, concat ($6_, _dc_7, _dc_8), ($7_ = 4, &$7_), &_k1);
  goto _l0;
  _l215:;
  (*ierr_) = 5;
  (void) _xermsg (_dc_1, _dc_2, _dc_9, ($8_ = 4, &$8_), &_k1);
  _l0:;
  __calls[3].calls++;
  return 0;
}

real_4 _bcrh (real_4 _p_ xll_, real_4 _p_ xrr_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_, real_4 
(*_f)(), real_4 _p_ sgn_)
{
  static real_4 bcrh_, xl_, xr_, dx_, x_;
  real_4 $0_, $1_;
  xl_ = (*xll_);
  xr_ = (*xrr_);
  dx_ = .5 * _abs (xr_ - xl_);
  _l101:;
  x_ = .5 * (xl_ + xr_);
  $0_ = (*sgn_) * _f (&x_, iz_, c_, a_, bh_);
  if ($0_ < 0) {
    goto _l103;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  xr_ = x_;
  goto _l104;
  _l103:;
  xl_ = x_;
  _l104:;
  dx_ = .5 * dx_;
  $1_ = dx_ - ccblk_.cnv_;
  if ($1_ < 0) {
    goto _l105;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  bcrh_ = .5 * (xl_ + xr_);
  __calls[4].calls++;
  return bcrh_;
}

int_4 _bdiff (int_4 _p_ l_, real_4 _p_ v_)
{
  static int_4 i_, j_, k_;
  if ((*l_) == 1) {
    goto _l0;
  }
  for (j_ = 2; j_ <= (*l_); (j_)++) {
    k_ = (*l_);
    for (i_ = j_; i_ <= (*l_); (i_)++) {
      v_[k_ - 1] = v_[k_ - 1 - 1] - v_[k_ - 1];
      k_ = k_ - 1;
    }
  }
  _l0:;
  __calls[5].calls++;
  return 0;
}

int_4 _bksol (int_4 _p_ n_, real_4 _p_ a_, real_4 _p_ x_)
{
  static int_4 m_, nm1_, k_, j_;
  extern real_4 _sdot ();
  m_ = ((*n_) * ((*n_) + 1)) / 2;
  x_[(*n_) - 1] = x_[(*n_) - 1] * a_[m_ - 1];
  if ((*n_) == 1) {
    goto _l20;
  }
  nm1_ = (*n_) - 1;
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    j_ = (*n_) - k_;
    m_ = m_ - k_ - 1;
    x_[j_ - 1] = x_[j_ - 1] * a_[m_ - 1] - _sdot (&k_, &a_[m_ + 1 - 1], &_k1, &x_[j_ + 1 - 1], &_k1);
  }
  _l20:;
  __calls[6].calls++;
  return 0;
}

int_4 _blktr1 (int_4 _p_ n_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, int_4 _p_ m_, real_4 _p_ am_, real_4 _p_ 
bm_, real_4 _p_ cm_, int_4 _p_ idimy_, real_4 _p_ y_, real_4 _p_ b_, real_4 _p_ w1_, real_4 _p_ w2_, real_4 _p_ w3_, 
real_4 _p_ wd_, real_4 _p_ ww_, real_4 _p_ wu_, int_4 (*_prdct)(), int_4 (*_cprdct)())
{
  static int_4 kdo_, l_, ir_, i2_, i1_, i3_, i4_, irm1_, im2_, nm2_, im3_, nm3_, im1_, nm1_, if_, i_, ipi1_, ipi2_, ipi3_
  , idxc_, nc_, idxa_, na_, ip2_, np2_, ip1_, np1_, ip3_, np3_, j_, iz_, nz_, izr_, ll_, ifd_, ip_, np_, imi1_, imi2_;
  static real_4 dum_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, 
  $20_, $21_, $22_, $23_, $24_, $25_, $26_, $27_, $28_, $29_, $30_, $31_, $32_, $33_, $34_, $35_, $36_;
  kdo_ = cblkt_.k_ - 1;
  for (l_ = 1; l_ <= kdo_; (l_)++) {
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i3_ = i2_ + i1_;
    i4_ = i2_ + i2_;
    irm1_ = ir_ - 1;
    (void) _indxb (&i2_, &ir_, &im2_, &nm2_);
    (void) _indxb (&i1_, &irm1_, &im3_, &nm3_);
    (void) _indxb (&i3_, &irm1_, &im1_, &nm1_);
    (void) _prdct (&nm2_, &b_[im2_ - 1], &nm3_, &b_[im3_ - 1], &nm1_, &b_[im1_ - 1], &_k0, &dum_, &y_[0 + ((*idimy_)) * 
    ((i2_ - 1))], w3_, m_, am_, bm_, cm_, wd_, ww_, wu_);
    if_ = _up_int_4 (2, cblkt_.k_);
    for (i_ = i4_; (i4_ > 0 ? i_ <= if_ : i_ >= if_); i_ += i4_) {
      $0_ = i_ - cblkt_.nm_;
      if ($0_ < 0) {
        goto _l101;
      } else if ($0_ == 0) {
        goto _l101;
      } else {
        goto _l108;
      }
      _l101:;
      ipi1_ = i_ + i1_;
      ipi2_ = i_ + i2_;
      ipi3_ = i_ + i3_;
      (void) _indxc (&i_, &ir_, &idxc_, &nc_);
      $1_ = i_ - if_;
      if ($1_ < 0) {
        goto _l102;
      } else if ($1_ == 0) {
        goto _l108;
      } else {
        goto _l108;
      }
      _l102:;
      (void) _indxa (&i_, &ir_, &idxa_, &na_);
      (void) _indxb (($2_ = i_ - i1_, &$2_), &irm1_, &im1_, &nm1_);
      (void) _indxb (&ipi2_, &ir_, &ip2_, &np2_);
      (void) _indxb (&ipi1_, &irm1_, &ip1_, &np1_);
      (void) _indxb (&ipi3_, &irm1_, &ip3_, &np3_);
      (void) _prdct (&nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &na_, &an_[idxa_ - 1], w3_, w1_, m_, am_, bm_, cm_, wd_, 
      ww_, wu_);
      $3_ = ipi2_ - cblkt_.nm_;
      if ($3_ < 0) {
        goto _l105;
      } else if ($3_ == 0) {
        goto _l105;
      } else {
        goto _l103;
      }
      _l103:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w3_[j_ - 1] = 0.0;
        w2_[j_ - 1] = 0.0;
      }
      goto _l106;
      _l105:;
      (void) _prdct (&np2_, &b_[ip2_ - 1], &np1_, &b_[ip1_ - 1], &np3_, &b_[ip3_ - 1], &_k0, &dum_, &y_[0 + ((*idimy_)) * 
      ((ipi2_ - 1))], w3_, m_, am_, bm_, cm_, wd_, ww_, wu_);
      (void) _prdct (&np1_, &b_[ip1_ - 1], &_k0, &dum_, &_k0, &dum_, &nc_, &cn_[idxc_ - 1], w3_, w2_, m_, am_, bm_, cm_, wd_, 
      ww_, wu_);
      _l106:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] = w1_[j_ - 1] + w2_[j_ - 1] + y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))];
      }
      _l108:;
    }
  }
  $4_ = cblkt_.npp_;
  if ($4_ < 0) {
    goto _l132;
  } else if ($4_ == 0) {
    goto _l110;
  } else {
    goto _l132;
  }
  _l110:;
  if_ = _up_int_4 (2, cblkt_.k_);
  i_ = if_ / 2;
  i1_ = i_ / 2;
  (void) _indxb (($5_ = i_ - i1_, &$5_), ($6_ = cblkt_.k_ - 2, &$6_), &im1_, &nm1_);
  (void) _indxb (($7_ = i_ + i1_, &$7_), ($8_ = cblkt_.k_ - 2, &$8_), &ip1_, &np1_);
  (void) _indxb (&i_, ($9_ = cblkt_.k_ - 1, &$9_), &iz_, &nz_);
  (void) _prdct (&nz_, &b_[iz_ - 1], &nm1_, &b_[im1_ - 1], &np1_, &b_[ip1_ - 1], &_k0, &dum_, &y_[0 + ((*idimy_)) * ((i_ 
  - 1))], w1_, m_, am_, bm_, cm_, wd_, ww_, wu_);
  izr_ = i_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    w2_[j_ - 1] = w1_[j_ - 1];
  }
  for (ll_ = 2; ll_ <= cblkt_.k_; (ll_)++) {
    l_ = cblkt_.k_ - ll_ + 1;
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i_ = i2_;
    (void) _indxc (&i_, &ir_, &idxc_, &nc_);
    (void) _indxb (&i_, &ir_, &iz_, &nz_);
    (void) _indxb (($10_ = i_ - i1_, &$10_), ($11_ = ir_ - 1, &$11_), &im1_, &nm1_);
    (void) _indxb (($12_ = i_ + i1_, &$12_), ($13_ = ir_ - 1, &$13_), &ip1_, &np1_);
    (void) _prdct (&np1_, &b_[ip1_ - 1], &_k0, &dum_, &_k0, &dum_, &nc_, &cn_[idxc_ - 1], w1_, w1_, m_, am_, bm_, cm_, wd_, 
    ww_, wu_);
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      w1_[j_ - 1] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] + w1_[j_ - 1];
    }
    (void) _prdct (&nz_, &b_[iz_ - 1], &nm1_, &b_[im1_ - 1], &np1_, &b_[ip1_ - 1], &_k0, &dum_, w1_, w1_, m_, am_, bm_, 
    cm_, wd_, ww_, wu_);
  }
  for (ll_ = 2; ll_ <= cblkt_.k_; (ll_)++) {
    l_ = cblkt_.k_ - ll_ + 1;
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i4_ = i2_ + i2_;
    ifd_ = if_ - i2_;
    for (i_ = i2_; (i4_ > 0 ? i_ <= ifd_ : i_ >= ifd_); i_ += i4_) {
      $14_ = i_ - i2_ - izr_;
      if ($14_ < 0) {
        goto _l117;
      } else if ($14_ == 0) {
        goto _l114;
      } else {
        goto _l117;
      }
      _l114:;
      $15_ = i_ - cblkt_.nm_;
      if ($15_ < 0) {
        goto _l115;
      } else if ($15_ == 0) {
        goto _l115;
      } else {
        goto _l118;
      }
      _l115:;
      (void) _indxa (&i_, &ir_, &idxa_, &na_);
      (void) _indxb (&i_, &ir_, &iz_, &nz_);
      (void) _indxb (($16_ = i_ - i1_, &$16_), ($17_ = ir_ - 1, &$17_), &im1_, &nm1_);
      (void) _indxb (($18_ = i_ + i1_, &$18_), ($19_ = ir_ - 1, &$19_), &ip1_, &np1_);
      (void) _prdct (&nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &na_, &an_[idxa_ - 1], w2_, w2_, m_, am_, bm_, cm_, wd_, 
      ww_, wu_);
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w2_[j_ - 1] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] + w2_[j_ - 1];
      }
      (void) _prdct (&nz_, &b_[iz_ - 1], &nm1_, &b_[im1_ - 1], &np1_, &b_[ip1_ - 1], &_k0, &dum_, w2_, w2_, m_, am_, bm_, 
      cm_, wd_, ww_, wu_);
      izr_ = i_;
      $20_ = i_ - cblkt_.nm_;
      if ($20_ < 0) {
        goto _l117;
      } else if ($20_ == 0) {
        goto _l119;
      } else {
        goto _l117;
      }
      _l117:;
    }
    _l118:;
  }
  _l119:;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1 + ((*idimy_)) * ((cblkt_.nm_ + 1 - 1))] = y_[j_ - 1 + ((*idimy_)) * ((cblkt_.nm_ + 1 - 1))] - cn_[cblkt_.nm_ 
    + 1 - 1] * w1_[j_ - 1] - an_[cblkt_.nm_ + 1 - 1] * w2_[j_ - 1];
  }
  (void) _indxb (($21_ = if_ / 2, &$21_), ($22_ = cblkt_.k_ - 1, &$22_), &im1_, &nm1_);
  (void) _indxb (&if_, ($23_ = cblkt_.k_ - 1, &$23_), &ip_, &np_);
  $24_ = cblkt_.ncmplx_;
  if ($24_ < 0) {
    goto _l121;
  } else if ($24_ == 0) {
    goto _l122;
  } else {
    goto _l121;
  }
  _l121:;
  (void) _cprdct (($25_ = cblkt_.nm_ + 1, &$25_), &b_[ip_ - 1], &nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &y_[0 + 
  ((*idimy_)) * ((cblkt_.nm_ + 1 - 1))], &y_[0 + ((*idimy_)) * ((cblkt_.nm_ + 1 - 1))], m_, am_, bm_, cm_, w1_, w3_, ww_)
  ;
  goto _l123;
  _l122:;
  (void) _prdct (($26_ = cblkt_.nm_ + 1, &$26_), &b_[ip_ - 1], &nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &y_[0 + 
  ((*idimy_)) * ((cblkt_.nm_ + 1 - 1))], &y_[0 + ((*idimy_)) * ((cblkt_.nm_ + 1 - 1))], m_, am_, bm_, cm_, wd_, ww_, wu_)
  ;
  _l123:;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    w1_[j_ - 1] = an_[0] * y_[j_ - 1 + ((*idimy_)) * ((cblkt_.nm_ + 1 - 1))];
    w2_[j_ - 1] = cn_[cblkt_.nm_ - 1] * y_[j_ - 1 + ((*idimy_)) * ((cblkt_.nm_ + 1 - 1))];
    y_[j_ - 1 + ((*idimy_)) * ((0))] = y_[j_ - 1 + ((*idimy_)) * ((0))] - w1_[j_ - 1];
    y_[j_ - 1 + ((*idimy_)) * ((cblkt_.nm_ - 1))] = y_[j_ - 1 + ((*idimy_)) * ((cblkt_.nm_ - 1))] - w2_[j_ - 1];
  }
  for (l_ = 1; l_ <= kdo_; (l_)++) {
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i4_ = i2_ + i2_;
    i1_ = i2_ / 2;
    i_ = i4_;
    (void) _indxa (&i_, &ir_, &idxa_, &na_);
    (void) _indxb (($27_ = i_ - i2_, &$27_), &ir_, &im2_, &nm2_);
    (void) _indxb (($28_ = i_ - i2_ - i1_, &$28_), ($29_ = ir_ - 1, &$29_), &im3_, &nm3_);
    (void) _indxb (($30_ = i_ - i1_, &$30_), ($31_ = ir_ - 1, &$31_), &im1_, &nm1_);
    (void) _prdct (&nm2_, &b_[im2_ - 1], &nm3_, &b_[im3_ - 1], &nm1_, &b_[im1_ - 1], &_k0, &dum_, w1_, w1_, m_, am_, bm_, 
    cm_, wd_, ww_, wu_);
    (void) _prdct (&nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &na_, &an_[idxa_ - 1], w1_, w1_, m_, am_, bm_, cm_, wd_, 
    ww_, wu_);
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] - w1_[j_ - 1];
    }
  }
  izr_ = cblkt_.nm_;
  for (l_ = 1; l_ <= kdo_; (l_)++) {
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i3_ = i2_ + i1_;
    i4_ = i2_ + i2_;
    irm1_ = ir_ - 1;
    for (i_ = i4_; (i4_ > 0 ? i_ <= if_ : i_ >= if_); i_ += i4_) {
      ipi1_ = i_ + i1_;
      ipi2_ = i_ + i2_;
      ipi3_ = i_ + i3_;
      $32_ = ipi2_ - izr_;
      if ($32_ < 0) {
        goto _l127;
      } else if ($32_ == 0) {
        goto _l128;
      } else {
        goto _l127;
      }
      _l127:;
      $33_ = i_ - izr_;
      if ($33_ < 0) {
        goto _l130;
      } else if ($33_ == 0) {
        goto _l131;
      } else {
        goto _l130;
      }
      _l128:;
      (void) _indxc (&i_, &ir_, &idxc_, &nc_);
      (void) _indxb (&ipi2_, &ir_, &ip2_, &np2_);
      (void) _indxb (&ipi1_, &irm1_, &ip1_, &np1_);
      (void) _indxb (&ipi3_, &irm1_, &ip3_, &np3_);
      (void) _prdct (&np2_, &b_[ip2_ - 1], &np1_, &b_[ip1_ - 1], &np3_, &b_[ip3_ - 1], &_k0, &dum_, w2_, w2_, m_, am_, bm_, 
      cm_, wd_, ww_, wu_);
      (void) _prdct (&np1_, &b_[ip1_ - 1], &_k0, &dum_, &_k0, &dum_, &nc_, &cn_[idxc_ - 1], w2_, w2_, m_, am_, bm_, cm_, wd_, 
      ww_, wu_);
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] - w2_[j_ - 1];
      }
      izr_ = i_;
      goto _l131;
      _l130:;
    }
    _l131:;
  }
  _l132:;
  for (ll_ = 1; ll_ <= cblkt_.k_; (ll_)++) {
    l_ = cblkt_.k_ - ll_ + 1;
    ir_ = l_ - 1;
    irm1_ = ir_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i4_ = i2_ + i2_;
    ifd_ = if_ - i2_;
    for (i_ = i2_; (i4_ > 0 ? i_ <= ifd_ : i_ >= ifd_); i_ += i4_) {
      $34_ = i_ - cblkt_.nm_;
      if ($34_ < 0) {
        goto _l133;
      } else if ($34_ == 0) {
        goto _l133;
      } else {
        goto _l143;
      }
      _l133:;
      imi1_ = i_ - i1_;
      imi2_ = i_ - i2_;
      ipi1_ = i_ + i1_;
      ipi2_ = i_ + i2_;
      (void) _indxa (&i_, &ir_, &idxa_, &na_);
      (void) _indxc (&i_, &ir_, &idxc_, &nc_);
      (void) _indxb (&i_, &ir_, &iz_, &nz_);
      (void) _indxb (&imi1_, &irm1_, &im1_, &nm1_);
      (void) _indxb (&ipi1_, &irm1_, &ip1_, &np1_);
      $35_ = i_ - i2_;
      if ($35_ < 0) {
        goto _l134;
      } else if ($35_ == 0) {
        goto _l134;
      } else {
        goto _l136;
      }
      _l134:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w1_[j_ - 1] = 0.0;
      }
      goto _l137;
      _l136:;
      (void) _prdct (&nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &na_, &an_[idxa_ - 1], &y_[0 + ((*idimy_)) * ((imi2_ - 
      1))], w1_, m_, am_, bm_, cm_, wd_, ww_, wu_);
      _l137:;
      $36_ = ipi2_ - cblkt_.nm_;
      if ($36_ < 0) {
        goto _l140;
      } else if ($36_ == 0) {
        goto _l140;
      } else {
        goto _l138;
      }
      _l138:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w2_[j_ - 1] = 0.0;
      }
      goto _l141;
      _l140:;
      (void) _prdct (&np1_, &b_[ip1_ - 1], &_k0, &dum_, &_k0, &dum_, &nc_, &cn_[idxc_ - 1], &y_[0 + ((*idimy_)) * ((ipi2_ - 
      1))], w2_, m_, am_, bm_, cm_, wd_, ww_, wu_);
      _l141:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w1_[j_ - 1] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] + w1_[j_ - 1] + w2_[j_ - 1];
      }
      (void) _prdct (&nz_, &b_[iz_ - 1], &nm1_, &b_[im1_ - 1], &np1_, &b_[ip1_ - 1], &_k0, &dum_, w1_, &y_[0 + ((*idimy_)) * 
      ((i_ - 1))], m_, am_, bm_, cm_, wd_, ww_, wu_);
      _l143:;
    }
  }
  __calls[7].calls++;
  return 0;
}

int_4 _bndacc (real_4 _p_ g_, int_4 _p_ mdg_, int_4 _p_ nb_, int_4 _p_ ip_, int_4 _p_ ir_, int_4 _p_ mt_, int_4 _p_ jt_
)
{
  static int_4 nbp1_, nerr_, iopt_, i_, ig1_, ig2_, j_, ie_, ig_, mu_, l_, k_, lp1_, jg_, mh_, kh_;
  static real_4 zero_, rho_;
  int_4 $0_, $1_;
  zero_ = 0.0;
  nbp1_ = (*nb_) + 1;
  if ((*mt_) <= 0 || (*nb_) <= 0) {
    goto _l0;
  }
  if (! ((*mdg_) < (*ir_))) {
    goto _l5;
  }
  nerr_ = 1;
  iopt_ = 2;
  (void) _xermsg (_dc_1, _dc_10, _dc_11, &nerr_, &iopt_);
  goto _l0;
  _l5:;
  if ((*jt_) == (*ip_)) {
    goto _l70;
  }
  if ((*jt_) <= (*ir_)) {
    goto _l30;
  }
  for (i_ = 1; i_ <= (*mt_); (i_)++) {
    ig1_ = (*jt_) + (*mt_) - i_;
    ig2_ = (*ir_) + (*mt_) - i_;
    for (j_ = 1; j_ <= nbp1_; (j_)++) {
      g_[ig1_ - 1 + ((*mdg_)) * ((j_ - 1))] = g_[ig2_ - 1 + ((*mdg_)) * ((j_ - 1))];
    }
  }
  ie_ = (*jt_) - (*ir_);
  for (i_ = 1; i_ <= ie_; (i_)++) {
    ig_ = (*ir_) + i_ - 1;
    for (j_ = 1; j_ <= nbp1_; (j_)++) {
      g_[ig_ - 1 + ((*mdg_)) * ((j_ - 1))] = zero_;
    }
  }
  (*ir_) = (*jt_);
  _l30:;
  mu_ = _min ((*nb_) - 1, (*ir_) - (*ip_) - 1);
  if (mu_ == 0) {
    goto _l60;
  }
  for (l_ = 1; l_ <= mu_; (l_)++) {
    k_ = _min (l_, (*jt_) - (*ip_));
    lp1_ = l_ + 1;
    ig_ = (*ip_) + l_;
    for (i_ = lp1_; i_ <= (*nb_); (i_)++) {
      jg_ = i_ - k_;
      g_[ig_ - 1 + ((*mdg_)) * ((jg_ - 1))] = g_[ig_ - 1 + ((*mdg_)) * ((i_ - 1))];
    }
    for (i_ = 1; i_ <= k_; (i_)++) {
      jg_ = nbp1_ - i_;
      g_[ig_ - 1 + ((*mdg_)) * ((jg_ - 1))] = zero_;
    }
  }
  _l60:;
  (*ip_) = (*jt_);
  _l70:;
  mh_ = (*ir_) + (*mt_) - (*ip_);
  kh_ = _min (nbp1_, mh_);
  for (i_ = 1; i_ <= kh_; (i_)++) {
    (void) _h12 (&_k1, &i_, ($0_ = _max (i_ + 1, (*ir_) - (*ip_) + 1), &$0_), &mh_, &g_[(*ip_) - 1 + ((*mdg_)) * ((i_ - 
    1))], &_k1, &rho_, &g_[(*ip_) - 1 + ((*mdg_)) * ((i_ + 1 - 1))], &_k1, mdg_, ($1_ = nbp1_ - i_, &$1_));
  }
  (*ir_) = (*ip_) + kh_;
  if (kh_ < nbp1_) {
    goto _l100;
  }
  for (i_ = 1; i_ <= (*nb_); (i_)++) {
    g_[(*ir_) - 1 - 1 + ((*mdg_)) * ((i_ - 1))] = zero_;
  }
  _l100:;
  _l0:;
  __calls[8].calls++;
  return 0;
}

int_4 _bndsol (int_4 _p_ mode_, real_4 _p_ g_, int_4 _p_ mdg_, int_4 _p_ nb_, int_4 _p_ ip_, int_4 _p_ ir_, real_4 _p_ 
x_, int_4 _p_ n_, real_4 _p_ rnorm_)
{
  static int_4 j_, np1_, irm1_, ii_, i_, l_, ie_, jg_, ix_, i1_, i2_, nerr_, iopt_;
  static real_4 zero_, rsq_, s_;
  real_4 $0_, $1_;
  char_127 $2_;
  zero_ = 0.0;
  (*rnorm_) = zero_;
  switch ((*mode_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l90;
    case 3: goto _l50;
  }
  _l10:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = g_[j_ - 1 + ((*mdg_)) * (((*nb_) + 1 - 1))];
  }
  rsq_ = zero_;
  np1_ = (*n_) + 1;
  irm1_ = (*ir_) - 1;
  if (np1_ > irm1_) {
    goto _l40;
  }
  for (j_ = np1_; j_ <= irm1_; (j_)++) {
    rsq_ = rsq_ + (g_[j_ - 1 + ((*mdg_)) * (((*nb_) + 1 - 1))] * g_[j_ - 1 + ((*mdg_)) * (((*nb_) + 1 - 1))]);
  }
  (*rnorm_) = sqrtf (rsq_);
  _l40:;
  _l50:;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 1 - ii_;
    s_ = zero_;
    l_ = _max (0, i_ - (*ip_));
    if (i_ == (*n_)) {
      goto _l70;
    }
    ie_ = _min ((*n_) + 1 - i_, (*nb_));
    for (j_ = 2; j_ <= ie_; (j_)++) {
      jg_ = j_ + l_;
      ix_ = i_ - 1 + j_;
      s_ = s_ + g_[i_ - 1 + ((*mdg_)) * ((jg_ - 1))] * x_[ix_ - 1];
    }
    _l70:;
    $0_ = g_[i_ - 1 + ((*mdg_)) * ((l_ + 1 - 1))];
    if ($0_ < 0) {
      goto _l80;
    } else if ($0_ == 0) {
      goto _l130;
    } else {
      goto _l80;
    }
    _l80:;
    x_[i_ - 1] = (x_[i_ - 1] - s_) / g_[i_ - 1 + ((*mdg_)) * ((l_ + 1 - 1))];
  }
  goto _l0;
  _l90:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    s_ = zero_;
    if (j_ == 1) {
      goto _l110;
    }
    i1_ = _max (1, j_ - (*nb_) + 1);
    i2_ = j_ - 1;
    for (i_ = i1_; i_ <= i2_; (i_)++) {
      l_ = j_ - i_ + 1 + _max (0, i_ - (*ip_));
      s_ = s_ + x_[i_ - 1] * g_[i_ - 1 + ((*mdg_)) * ((l_ - 1))];
    }
    _l110:;
    l_ = _max (0, j_ - (*ip_));
    $1_ = g_[j_ - 1 + ((*mdg_)) * ((l_ + 1 - 1))];
    if ($1_ < 0) {
      goto _l120;
    } else if ($1_ == 0) {
      goto _l130;
    } else {
      goto _l120;
    }
    _l120:;
    x_[j_ - 1] = (x_[j_ - 1] - s_) / g_[j_ - 1 + ((*mdg_)) * ((l_ + 1 - 1))];
  }
  goto _l0;
  _l130:;
  nerr_ = 1;
  iopt_ = 2;
  (void) _xermsg (_dc_1, _dc_12, concat ($2_, _dc_13, _dc_14), &nerr_, &iopt_);
  _l0:;
  __calls[9].calls++;
  return 0;
}

int_4 _bsgq8 (real_4 (*_fun)(), real_4 _p_ xt_, real_4 _p_ bc_, int_4 _p_ n_, int_4 _p_ kk_, int_4 _p_ id_, real_4 _p_ 
a_, real_4 _p_ b_, int_4 _p_ inbv_, real_4 _p_ err_, real_4 _p_ ans_, int_4 _p_ ierr_, real_4 _p_ work_)
{
  static int_4 k_, kml_, kmx_, l_, lmn_, lmx_, lr_[30], mxl_, nbits_, nib_, nlmn_, nlmx_;
  static real_4 aa_[30], ae_, anib_, area_, c_, ce_, ee_, ef_, eps_, est_, gl_, glr_, gr_[30], hh_[30], sq2_, tol_, 
  vl_[30], vr_, w1_, w2_, w3_, w4_, x1_, x2_, x3_, x4_, x_, h_;
  int_4 _data_k_21, _data_k_22, _data_k_23, _data_k_24, _data_k_25, _data_k_26, $0_, $1_, $2_, $52_, $53_, $54_;
  real_4 $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, $20_, $21_, $22_, 
  $23_, $24_, $25_, $26_, $27_, $28_, $29_, $30_, $31_, $32_, $33_, $34_, $35_, $36_, $37_, $38_, $39_, $40_, $41_, $42_, 
  $43_, $44_, $45_, $46_, $47_, $48_, $49_, $50_, $51_;
  char_127 $55_;
  extern int_4 _i1mach ();
  extern real_4 _r1mach ();
  extern real_4 _bvalu ();
#define _data_n_21 4
  static real_4 _data_l_21[_data_n_21] = {
    1.83434642495649805e-1,
    5.25532409916328986e-1,
    7.9666647741362674e-1,
    9.60289856497536232e-1
  };
#define _data_n_22 4
  static real_4 _data_l_22[_data_n_22] = {
    3.62683783378361983e-1,
    3.13706645877887287e-1,
    2.22381034453374471e-1,
    1.01228536290376259e-1
  };
#define _data_n_23 1
  static real_4 _data_l_23[_data_n_23] = {
    1.41421356e0
  };
#define _data_n_24 1
  static int_4 _data_l_24[_data_n_24] = {
    1
  };
#define _data_n_25 1
  static int_4 _data_l_25[_data_n_25] = {
    5000
  };
#define _data_n_26 1
  static int_4 _data_l_26[_data_n_26] = {
    6
  };
  if (__calls[10].calls == 0) {
    _data_k_21 = 0;
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    x1_ = _data_l_21[_data_k_21++];
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    x2_ = _data_l_21[_data_k_21++];
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    x3_ = _data_l_21[_data_k_21++];
    if (_data_k_21 >= _data_n_21) {
      _data_k_21 = 0;
    }
    x4_ = _data_l_21[_data_k_21++];
  }
  if (__calls[10].calls == 0) {
    _data_k_22 = 0;
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    w1_ = _data_l_22[_data_k_22++];
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    w2_ = _data_l_22[_data_k_22++];
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    w3_ = _data_l_22[_data_k_22++];
    if (_data_k_22 >= _data_n_22) {
      _data_k_22 = 0;
    }
    w4_ = _data_l_22[_data_k_22++];
  }
  if (__calls[10].calls == 0) {
    _data_k_23 = 0;
    if (_data_k_23 >= _data_n_23) {
      _data_k_23 = 0;
    }
    sq2_ = _data_l_23[_data_k_23++];
  }
  if (__calls[10].calls == 0) {
    _data_k_24 = 0;
    if (_data_k_24 >= _data_n_24) {
      _data_k_24 = 0;
    }
    nlmn_ = _data_l_24[_data_k_24++];
    _data_k_25 = 0;
    if (_data_k_25 >= _data_n_25) {
      _data_k_25 = 0;
    }
    kmx_ = _data_l_25[_data_k_25++];
    _data_k_26 = 0;
    if (_data_k_26 >= _data_n_26) {
      _data_k_26 = 0;
    }
    kml_ = _data_l_26[_data_k_26++];
  }
  k_ = _i1mach (($0_ = 11, &$0_));
  anib_ = _r1mach (($1_ = 5, &$1_)) * k_ / 0.30102e0;
  nbits_ = (int_4) (_aintd (anib_));
  nlmx_ = (nbits_ * 5) / 8;
  (*ans_) = 0.0;
  (*ierr_) = 1;
  ce_ = 0.0;
  if ((*a_) == (*b_)) {
    goto _l140;
  }
  lmx_ = nlmx_;
  lmn_ = nlmn_;
  if ((*b_) == 0.0e0) {
    goto _l10;
  }
  if (_sign (1.0, (*b_)) * (*a_) <= 0.0e0) {
    goto _l10;
  }
  c_ = _abs (1.0e0 - (*a_) / (*b_));
  if (c_ > 0.1e0) {
    goto _l10;
  }
  if (c_ <= 0.0e0) {
    goto _l140;
  }
  anib_ = 0.5e0 - logf (c_) / 0.69314718e0;
  nib_ = (int_4) (_aintd (anib_));
  lmx_ = _min (nlmx_, nbits_ - nib_ - 7);
  if (lmx_ < 1) {
    goto _l130;
  }
  lmn_ = _min (lmn_, lmx_);
  _l10:;
  tol_ = _max (_abs ((*err_)), _up_real_4 (2.0e0, (5 - nbits_))) / 2.0e0;
  if ((*err_) == 0.0e0) {
    tol_ = sqrtf (_r1mach (($2_ = 4, &$2_)));
  }
  eps_ = tol_;
  hh_[0] = ((*b_) - (*a_)) / 4.0e0;
  aa_[0] = (*a_);
  lr_[0] = 1;
  l_ = 1;
  est_ = ({real_4 x__1_ = aa_[l_ - 1] + 2.0e0 * hh_[l_ - 1]; real_4 h__1_ = 2.0e0 * hh_[l_ - 1]; h__1_ * ((w1_ * (_fun 
  (($3_ = x__1_ - x1_ * h__1_, &$3_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($4_ = x__1_ - x1_ * h__1_, &$4_), inbv_, work_) 
  + _fun (($5_ = x__1_ + x1_ * h__1_, &$5_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($6_ = x__1_ + x1_ * h__1_, &$6_), inbv_, 
  work_)) + w2_ * (_fun (($7_ = x__1_ - x2_ * h__1_, &$7_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($8_ = x__1_ - x2_ * h__1_, 
  &$8_), inbv_, work_) + _fun (($9_ = x__1_ + x2_ * h__1_, &$9_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($10_ = x__1_ + x2_ * 
  h__1_, &$10_), inbv_, work_))) + (w3_ * (_fun (($11_ = x__1_ - x3_ * h__1_, &$11_)) * _bvalu (xt_, bc_, n_, kk_, id_, 
  ($12_ = x__1_ - x3_ * h__1_, &$12_), inbv_, work_) + _fun (($13_ = x__1_ + x3_ * h__1_, &$13_)) * _bvalu (xt_, bc_, n_, 
  kk_, id_, ($14_ = x__1_ + x3_ * h__1_, &$14_), inbv_, work_)) + w4_ * (_fun (($15_ = x__1_ - x4_ * h__1_, &$15_)) * 
  _bvalu (xt_, bc_, n_, kk_, id_, ($16_ = x__1_ - x4_ * h__1_, &$16_), inbv_, work_) + _fun (($17_ = x__1_ + x4_ * h__1_, 
  &$17_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($18_ = x__1_ + x4_ * h__1_, &$18_), inbv_, work_))));});
  k_ = 8;
  area_ = _abs (est_);
  ef_ = 0.5;
  mxl_ = 0;
  _l20:;
  gl_ = ({real_4 x__1_ = aa_[l_ - 1] + hh_[l_ - 1]; real_4 h__1_ = hh_[l_ - 1]; h__1_ * ((w1_ * (_fun (($19_ = x__1_ - 
  x1_ * h__1_, &$19_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($20_ = x__1_ - x1_ * h__1_, &$20_), inbv_, work_) + _fun (($21_ 
  = x__1_ + x1_ * h__1_, &$21_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($22_ = x__1_ + x1_ * h__1_, &$22_), inbv_, work_)) + 
  w2_ * (_fun (($23_ = x__1_ - x2_ * h__1_, &$23_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($24_ = x__1_ - x2_ * h__1_, 
  &$24_), inbv_, work_) + _fun (($25_ = x__1_ + x2_ * h__1_, &$25_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($26_ = x__1_ + 
  x2_ * h__1_, &$26_), inbv_, work_))) + (w3_ * (_fun (($27_ = x__1_ - x3_ * h__1_, &$27_)) * _bvalu (xt_, bc_, n_, kk_, 
  id_, ($28_ = x__1_ - x3_ * h__1_, &$28_), inbv_, work_) + _fun (($29_ = x__1_ + x3_ * h__1_, &$29_)) * _bvalu (xt_, 
  bc_, n_, kk_, id_, ($30_ = x__1_ + x3_ * h__1_, &$30_), inbv_, work_)) + w4_ * (_fun (($31_ = x__1_ - x4_ * h__1_, 
  &$31_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($32_ = x__1_ - x4_ * h__1_, &$32_), inbv_, work_) + _fun (($33_ = x__1_ + 
  x4_ * h__1_, &$33_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($34_ = x__1_ + x4_ * h__1_, &$34_), inbv_, work_))));});
  gr_[l_ - 1] = ({real_4 x__1_ = aa_[l_ - 1] + 3.0e0 * hh_[l_ - 1]; real_4 h__1_ = hh_[l_ - 1]; h__1_ * ((w1_ * (_fun 
  (($35_ = x__1_ - x1_ * h__1_, &$35_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($36_ = x__1_ - x1_ * h__1_, &$36_), inbv_, 
  work_) + _fun (($37_ = x__1_ + x1_ * h__1_, &$37_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($38_ = x__1_ + x1_ * h__1_, 
  &$38_), inbv_, work_)) + w2_ * (_fun (($39_ = x__1_ - x2_ * h__1_, &$39_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($40_ = 
  x__1_ - x2_ * h__1_, &$40_), inbv_, work_) + _fun (($41_ = x__1_ + x2_ * h__1_, &$41_)) * _bvalu (xt_, bc_, n_, kk_, 
  id_, ($42_ = x__1_ + x2_ * h__1_, &$42_), inbv_, work_))) + (w3_ * (_fun (($43_ = x__1_ - x3_ * h__1_, &$43_)) * _bvalu 
  (xt_, bc_, n_, kk_, id_, ($44_ = x__1_ - x3_ * h__1_, &$44_), inbv_, work_) + _fun (($45_ = x__1_ + x3_ * h__1_, 
  &$45_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($46_ = x__1_ + x3_ * h__1_, &$46_), inbv_, work_)) + w4_ * (_fun (($47_ = 
  x__1_ - x4_ * h__1_, &$47_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($48_ = x__1_ - x4_ * h__1_, &$48_), inbv_, work_) + 
  _fun (($49_ = x__1_ + x4_ * h__1_, &$49_)) * _bvalu (xt_, bc_, n_, kk_, id_, ($50_ = x__1_ + x4_ * h__1_, &$50_), 
  inbv_, work_))));});
  k_ = k_ + 16;
  area_ = area_ + (_abs (gl_) + _abs (gr_[l_ - 1]) - _abs (est_));
  glr_ = gl_ + gr_[l_ - 1];
  ee_ = _abs (est_ - glr_) * ef_;
  ae_ = _max (eps_ * area_, tol_ * _abs (glr_));
  $51_ = ee_ - ae_;
  if ($51_ < 0) {
    goto _l40;
  } else if ($51_ == 0) {
    goto _l40;
  } else {
    goto _l50;
  }
  _l30:;
  mxl_ = 1;
  _l40:;
  ce_ = ce_ + (est_ - glr_);
  $52_ = lr_[l_ - 1];
  if ($52_ < 0) {
    goto _l60;
  } else if ($52_ == 0) {
    goto _l60;
  } else {
    goto _l80;
  }
  _l50:;
  if (k_ > kmx_) {
    lmx_ = kml_;
  }
  if (l_ >= lmx_) {
    goto _l30;
  }
  l_ = l_ + 1;
  eps_ = eps_ * 0.5e0;
  ef_ = ef_ / sq2_;
  hh_[l_ - 1] = hh_[l_ - 1 - 1] * 0.5e0;
  lr_[l_ - 1] = -1;
  aa_[l_ - 1] = aa_[l_ - 1 - 1];
  est_ = gl_;
  goto _l20;
  _l60:;
  vl_[l_ - 1] = glr_;
  _l70:;
  est_ = gr_[l_ - 1 - 1];
  lr_[l_ - 1] = 1;
  aa_[l_ - 1] = aa_[l_ - 1] + 4.0e0 * hh_[l_ - 1];
  goto _l20;
  _l80:;
  vr_ = glr_;
  _l90:;
  if (l_ <= 1) {
    goto _l120;
  }
  l_ = l_ - 1;
  eps_ = eps_ * 2.0e0;
  ef_ = ef_ * sq2_;
  $53_ = lr_[l_ - 1];
  if ($53_ < 0) {
    goto _l100;
  } else if ($53_ == 0) {
    goto _l100;
  } else {
    goto _l110;
  }
  _l100:;
  vl_[l_ - 1] = vl_[l_ + 1 - 1] + vr_;
  goto _l70;
  _l110:;
  vr_ = vl_[l_ + 1 - 1] + vr_;
  goto _l90;
  _l120:;
  (*ans_) = vr_;
  if ((mxl_ == 0) || (_abs (ce_) <= 2.0e0 * tol_ * area_)) {
    goto _l140;
  }
  (*ierr_) = 2;
  (void) _xermsg (_dc_1, _dc_15, _dc_16, ($54_ = 3, &$54_), &_k1);
  goto _l140;
  _l130:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_1, _dc_15, concat ($55_, _dc_17, _dc_18), &_k1, &_km1);
  _l140:;
  if ((*err_) < 0.0e0) {
    (*err_) = ce_;
  }
  __calls[10].calls++;
  return 0;
}

int_4 _bsplvd (real_4 _p_ t_, int_4 _p_ k_, real_4 _p_ x_, int_4 _p_ ileft_, real_4 _p_ vnikx_, int_4 _p_ nderiv_)
{
  static int_4 ideriv_, i_, idervm_, j_, kmd_, m_, jm1_, ipkmd_, l_, jlow_;
  static real_4 a_[400], fkmd_, diff_, v_;
  int_4 $0_, $1_;
  (void) _bsplvn (t_, ($0_ = (*k_) + 1 - (*nderiv_), &$0_), &_k1, x_, ileft_, &vnikx_[(*nderiv_) - 1 + ((*k_)) * 
  (((*nderiv_) - 1))]);
  if ((*nderiv_) <= 1) {
    goto _l99;
  }
  ideriv_ = (*nderiv_);
  for (i_ = 2; i_ <= (*nderiv_); (i_)++) {
    idervm_ = ideriv_ - 1;
    for (j_ = ideriv_; j_ <= (*k_); (j_)++) {
      vnikx_[j_ - 1 - 1 + ((*k_)) * ((idervm_ - 1))] = vnikx_[j_ - 1 + ((*k_)) * ((ideriv_ - 1))];
    }
    ideriv_ = idervm_;
    (void) _bsplvn (t_, &_k0, ($1_ = 2, &$1_), x_, ileft_, &vnikx_[ideriv_ - 1 + ((*k_)) * ((ideriv_ - 1))]);
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    for (j_ = 1; j_ <= (*k_); (j_)++) {
      a_[i_ - 1 + (20) * ((j_ - 1))] = 0.0;
    }
    a_[i_ - 1 + (20) * ((i_ - 1))] = 1.0;
  }
  kmd_ = (*k_);
  for (m_ = 2; m_ <= (*nderiv_); (m_)++) {
    kmd_ = kmd_ - 1;
    fkmd_ = kmd_;
    i_ = (*ileft_);
    j_ = (*k_);
    _l21:;
    jm1_ = j_ - 1;
    ipkmd_ = i_ + kmd_;
    diff_ = t_[ipkmd_ - 1] - t_[i_ - 1];
    if (jm1_ == 0) {
      goto _l26;
    }
    if (diff_ == 0.0) {
      goto _l25;
    }
    for (l_ = 1; l_ <= j_; (l_)++) {
      a_[l_ - 1 + (20) * ((j_ - 1))] = (a_[l_ - 1 + (20) * ((j_ - 1))] - a_[l_ - 1 + (20) * ((j_ - 1 - 1))]) / diff_ * fkmd_
      ;
    }
    _l25:;
    j_ = jm1_;
    i_ = i_ - 1;
    goto _l21;
    _l26:;
    if (diff_ == 0.0) {
      goto _l30;
    }
    a_[0] = a_[0] / diff_ * fkmd_;
    _l30:;
    for (i_ = 1; i_ <= (*k_); (i_)++) {
      v_ = 0.0;
      jlow_ = _max (i_, m_);
      for (j_ = jlow_; j_ <= (*k_); (j_)++) {
        v_ = a_[i_ - 1 + (20) * ((j_ - 1))] * vnikx_[j_ - 1 + ((*k_)) * ((m_ - 1))] + v_;
      }
      vnikx_[i_ - 1 + ((*k_)) * ((m_ - 1))] = v_;
    }
  }
  _l99:;
  __calls[11].calls++;
  return 0;
}

int_4 _bsplvn (real_4 _p_ t_, int_4 _p_ jhigh_, int_4 _p_ index_, real_4 _p_ x_, int_4 _p_ ileft_, real_4 _p_ vnikx_)
{
  static int_4 j_, i_, ipj_, imjp1_, jp1_, l_, jp1ml_;
  static real_4 deltam_[20], deltap_[20], vmprev_, vm_;
  int_4 _data_k_27, _data_k_28;
#define _data_n_27 1
  static int_4 _data_l_27[_data_n_27] = {
    1
  };
#define _data_n_28 40
  static real_4 _data_l_28[_data_n_28] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0
  };
  if (__calls[12].calls == 0) {
    _data_k_27 = 0;
    if (_data_k_27 >= _data_n_27) {
      _data_k_27 = 0;
    }
    j_ = _data_l_27[_data_k_27++];
    _data_k_28 = 0;
    for (i_ = 1; i_ <= 20; i_++) {
      if (_data_k_28 >= _data_n_28) {
        _data_k_28 = 0;
      }
      deltam_[i_ - 1] = _data_l_28[_data_k_28++];
    }; // implied DO 
    for (i_ = 1; i_ <= 20; i_++) {
      if (_data_k_28 >= _data_n_28) {
        _data_k_28 = 0;
      }
      deltap_[i_ - 1] = _data_l_28[_data_k_28++];
    }; // implied DO 
  }
  switch ((*index_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  j_ = 1;
  vnikx_[0] = 1.0;
  if (j_ >= (*jhigh_)) {
    goto _l99;
  }
  _l20:;
  ipj_ = (*ileft_) + j_;
  deltap_[j_ - 1] = t_[ipj_ - 1] - (*x_);
  imjp1_ = (*ileft_) - j_ + 1;
  deltam_[j_ - 1] = (*x_) - t_[imjp1_ - 1];
  vmprev_ = 0.0;
  jp1_ = j_ + 1;
  for (l_ = 1; l_ <= j_; (l_)++) {
    jp1ml_ = jp1_ - l_;
    vm_ = vnikx_[l_ - 1] / (deltap_[l_ - 1] + deltam_[jp1ml_ - 1]);
    vnikx_[l_ - 1] = vm_ * deltap_[l_ - 1] + vmprev_;
    vmprev_ = vm_ * deltam_[jp1ml_ - 1];
  }
  vnikx_[jp1_ - 1] = vmprev_;
  j_ = jp1_;
  if (j_ < (*jhigh_)) {
    goto _l20;
  }
  _l99:;
  __calls[12].calls++;
  return 0;
}

real_4 _bsrh (real_4 _p_ xll_, real_4 _p_ xrr_, int_4 _p_ iz_, real_4 _p_ c_, real_4 _p_ a_, real_4 _p_ bh_, real_4 
(*_f)(), real_4 _p_ sgn_)
{
  static real_4 bsrh_, xl_, xr_, dx_, x_;
  real_4 $0_, $1_;
  xl_ = (*xll_);
  xr_ = (*xrr_);
  dx_ = .5 * _abs (xr_ - xl_);
  _l101:;
  x_ = .5 * (xl_ + xr_);
  $0_ = (*sgn_) * _f (&x_, iz_, c_, a_, bh_);
  if ($0_ < 0) {
    goto _l103;
  } else if ($0_ == 0) {
    goto _l105;
  } else {
    goto _l102;
  }
  _l102:;
  xr_ = x_;
  goto _l104;
  _l103:;
  xl_ = x_;
  _l104:;
  dx_ = .5 * dx_;
  $1_ = dx_ - cblkt_.cnv_;
  if ($1_ < 0) {
    goto _l105;
  } else if ($1_ == 0) {
    goto _l105;
  } else {
    goto _l101;
  }
  _l105:;
  bsrh_ = .5 * (xl_ + xr_);
  __calls[13].calls++;
  return bsrh_;
}

int_4 _c1merg (complex_8 _p_ tcos_, int_4 _p_ i1_, int_4 _p_ m1_, int_4 _p_ i2_, int_4 _p_ m2_, int_4 _p_ i3_)
{
  static int_4 j1_, j2_, j3_;
  int_4 $0_, $1_;
  if ((*m1_) == 0 && (*m2_) == 0) {
    goto _l0;
  }
  if ((*m1_) == 0 && (*m2_) != 0) {
    (void) _ccopy (m2_, &tcos_[(*i2_) + 1 - 1], &_k1, &tcos_[(*i3_) + 1 - 1], &_k1);
    goto _l0;
  }
  if ((*m1_) != 0 && (*m2_) == 0) {
    (void) _ccopy (m1_, &tcos_[(*i1_) + 1 - 1], &_k1, &tcos_[(*i3_) + 1 - 1], &_k1);
    goto _l0;
  }
  j1_ = 1;
  j2_ = 1;
  j3_ = 1;
  _l10:;
  if ((real_4) (crealf (tcos_[j1_ + (*i1_) - 1])) <= (real_4) (crealf (tcos_[(*i2_) + j2_ - 1]))) {
    tcos_[(*i3_) + j3_ - 1] = tcos_[(*i1_) + j1_ - 1];
    j1_ = j1_ + 1;
    if (j1_ > (*m1_)) {
      (void) _ccopy (($0_ = (*m2_) - j2_ + 1, &$0_), &tcos_[(*i2_) + j2_ - 1], &_k1, &tcos_[(*i3_) + j3_ + 1 - 1], &_k1);
      goto _l0;
    }
  }
  else {
    tcos_[(*i3_) + j3_ - 1] = tcos_[(*i2_) + j2_ - 1];
    j2_ = j2_ + 1;
    if (j2_ > (*m2_)) {
      (void) _ccopy (($1_ = (*m1_) - j1_ + 1, &$1_), &tcos_[(*i1_) + j1_ - 1], &_k1, &tcos_[(*i3_) + j3_ + 1 - 1], &_k1);
      goto _l0;
    }
  }
  j3_ = j3_ + 1;
  goto _l10;
  _l0:;
  __calls[14].calls++;
  return 0;
}

int_4 _casyi (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ kode_, int_4 _p_ n_, complex_8 _p_ y_, int_4 _p_ nz_, real_4 
_p_ rl_, real_4 _p_ tol_, real_4 _p_ elim_, real_4 _p_ alim_)
{
  static int_4 i_, ib_, il_, inu_, j_, jl_, k_, koded_, m_, nn_;
  static real_4 aa_, acz_, aez_, ak_, arg_, arm_, atol_, az_, bb_, bk_, dfnu_, dnu2_, fdn_, pi_, rtpi_, rtr1_, s_, sgn_, 
  sqk_, x_, yy_;
  static complex_8 ak1_, ck_, cone_, cs1_, cs2_, cz_, czero_, dk_, ez_, p1_, rz_, s2_;
  int_4 _data_k_29, _data_k_30;
  extern real_4 _r1mach ();
#define _data_n_29 2
  static real_4 _data_l_29[_data_n_29] = {
    3.14159265358979324e0,
    0.159154943091895336e0
  };
#define _data_n_30 2
  static complex_8 _data_l_30[_data_n_30] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0)
  };
  if (__calls[15].calls == 0) {
    _data_k_29 = 0;
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    pi_ = _data_l_29[_data_k_29++];
    if (_data_k_29 >= _data_n_29) {
      _data_k_29 = 0;
    }
    rtpi_ = _data_l_29[_data_k_29++];
  }
  if (__calls[15].calls == 0) {
    _data_k_30 = 0;
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    czero_ = _data_l_30[_data_k_30++];
    if (_data_k_30 >= _data_n_30) {
      _data_k_30 = 0;
    }
    cone_ = _data_l_30[_data_k_30++];
  }
  (*nz_) = 0;
  az_ = cabsf ((*z_));
  x_ = (real_4) (crealf ((*z_)));
  arm_ = 1.0e3 * _r1mach (&_k1);
  rtr1_ = sqrtf (arm_);
  il_ = _min (2, (*n_));
  dfnu_ = (*fnu_) + ((*n_) - il_);
  ak1_ = CMPLXF (rtpi_, 0.0) / (*z_);
  ak1_ = csqrtf (ak1_);
  cz_ = (*z_);
  if ((*kode_) == 2) {
    cz_ = (*z_) - CMPLXF (x_, 0.0);
  }
  acz_ = (real_4) (crealf (cz_));
  if (_abs (acz_) > (*elim_)) {
    goto _l80;
  }
  dnu2_ = dfnu_ + dfnu_;
  koded_ = 1;
  if ((_abs (acz_) > (*alim_)) && ((*n_) > 2)) {
    goto _l10;
  }
  koded_ = 0;
  ak1_ = ak1_ * cexpf (cz_);
  _l10:;
  fdn_ = 0.0;
  if (dnu2_ > rtr1_) {
    fdn_ = dnu2_ * dnu2_;
  }
  ez_ = (*z_) * CMPLXF (8.0, 0.0);
  aez_ = 8.0e0 * az_;
  s_ = (*tol_) / aez_;
  jl_ = (*rl_) + (*rl_) + 2;
  yy_ = cimagf ((*z_));
  p1_ = czero_;
  if (yy_ == 0.0e0) {
    goto _l20;
  }
  inu_ = (*fnu_);
  arg_ = ((*fnu_) - inu_) * pi_;
  inu_ = inu_ + (*n_) - il_;
  ak_ = -sinf (arg_);
  bk_ = cosf (arg_);
  if (yy_ < 0.0e0) {
    bk_ = -bk_;
  }
  p1_ = CMPLXF (ak_, bk_);
  if (_imod (inu_, 2) == 1) {
    p1_ = -p1_;
  }
  _l20:;
  for (k_ = 1; k_ <= il_; (k_)++) {
    sqk_ = fdn_ - 1.0e0;
    atol_ = s_ * _abs (sqk_);
    sgn_ = 1.0;
    cs1_ = cone_;
    cs2_ = cone_;
    ck_ = cone_;
    ak_ = 0.0;
    aa_ = 1.0;
    bb_ = aez_;
    dk_ = ez_;
    for (j_ = 1; j_ <= jl_; (j_)++) {
      ck_ = ck_ * CMPLXF (sqk_, 0.0) / dk_;
      cs2_ = cs2_ + ck_;
      sgn_ = -sgn_;
      cs1_ = cs1_ + ck_ * CMPLXF (sgn_, 0.0);
      dk_ = dk_ + ez_;
      aa_ = aa_ * _abs (sqk_) / bb_;
      bb_ = bb_ + aez_;
      ak_ = ak_ + 8.0e0;
      sqk_ = sqk_ - ak_;
      if (aa_ <= atol_) {
        goto _l40;
      }
    }
    goto _l90;
    _l40:;
    s2_ = cs1_;
    if (x_ + x_ < (*elim_)) {
      s2_ = s2_ + p1_ * cs2_ * cexpf (-(*z_) - (*z_));
    }
    fdn_ = fdn_ + 8.0e0 * dfnu_ + 4.0e0;
    p1_ = -p1_;
    m_ = (*n_) - il_ + k_;
    y_[m_ - 1] = s2_ * ak1_;
  }
  if ((*n_) <= 2) {
    goto _l0;
  }
  nn_ = (*n_);
  k_ = nn_ - 2;
  ak_ = k_;
  rz_ = (cone_ + cone_) / (*z_);
  ib_ = 3;
  for (i_ = ib_; i_ <= nn_; (i_)++) {
    y_[k_ - 1] = CMPLXF (ak_ + (*fnu_), 0.0) * rz_ * y_[k_ + 1 - 1] + y_[k_ + 2 - 1];
    ak_ = ak_ - 1.0e0;
    k_ = k_ - 1;
  }
  if (koded_ == 0) {
    goto _l0;
  }
  ck_ = cexpf (cz_);
  for (i_ = 1; i_ <= nn_; (i_)++) {
    y_[i_ - 1] = y_[i_ - 1] * ck_;
  }
  goto _l0;
  _l80:;
  (*nz_) = -1;
  goto _l0;
  _l90:;
  (*nz_) = -2;
  _l0:;
  __calls[15].calls++;
  return 0;
}

int_4 _cblkt1 (int_4 _p_ n_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, int_4 _p_ m_, complex_8 _p_ am_, complex_8 
_p_ bm_, complex_8 _p_ cm_, int_4 _p_ idimy_, complex_8 _p_ y_, real_4 _p_ b_, complex_8 _p_ w1_, complex_8 _p_ w2_, 
complex_8 _p_ w3_, complex_8 _p_ wd_, complex_8 _p_ ww_, complex_8 _p_ wu_, int_4 (*_prdct)(), int_4 (*_cprdct)())
{
  static int_4 kdo_, l_, ir_, i2_, i1_, i3_, i4_, irm1_, im2_, nm2_, im3_, nm3_, im1_, nm1_, if_, i_, ipi1_, ipi2_, ipi3_
  , idxc_, nc_, idxa_, na_, ip2_, np2_, ip1_, np1_, ip3_, np3_, j_, iz_, nz_, izr_, ll_, ifd_, ip_, np_, imi1_, imi2_;
  static real_4 dum_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, 
  $20_, $21_, $22_, $23_, $24_, $25_, $26_, $27_, $28_, $29_, $30_, $31_, $32_, $33_, $34_, $35_, $36_;
  kdo_ = ccblk_.k_ - 1;
  for (l_ = 1; l_ <= kdo_; (l_)++) {
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i3_ = i2_ + i1_;
    i4_ = i2_ + i2_;
    irm1_ = ir_ - 1;
    (void) _inxcb (&i2_, &ir_, &im2_, &nm2_);
    (void) _inxcb (&i1_, &irm1_, &im3_, &nm3_);
    (void) _inxcb (&i3_, &irm1_, &im1_, &nm1_);
    (void) _prdct (&nm2_, &b_[im2_ - 1], &nm3_, &b_[im3_ - 1], &nm1_, &b_[im1_ - 1], &_k0, &dum_, &y_[0 + ((*idimy_)) * 
    ((i2_ - 1))], w3_, m_, am_, bm_, cm_, wd_, ww_, wu_);
    if_ = _up_int_4 (2, ccblk_.k_);
    for (i_ = i4_; (i4_ > 0 ? i_ <= if_ : i_ >= if_); i_ += i4_) {
      $0_ = i_ - ccblk_.nm_;
      if ($0_ < 0) {
        goto _l101;
      } else if ($0_ == 0) {
        goto _l101;
      } else {
        goto _l108;
      }
      _l101:;
      ipi1_ = i_ + i1_;
      ipi2_ = i_ + i2_;
      ipi3_ = i_ + i3_;
      (void) _inxcc (&i_, &ir_, &idxc_, &nc_);
      $1_ = i_ - if_;
      if ($1_ < 0) {
        goto _l102;
      } else if ($1_ == 0) {
        goto _l108;
      } else {
        goto _l108;
      }
      _l102:;
      (void) _inxca (&i_, &ir_, &idxa_, &na_);
      (void) _inxcb (($2_ = i_ - i1_, &$2_), &irm1_, &im1_, &nm1_);
      (void) _inxcb (&ipi2_, &ir_, &ip2_, &np2_);
      (void) _inxcb (&ipi1_, &irm1_, &ip1_, &np1_);
      (void) _inxcb (&ipi3_, &irm1_, &ip3_, &np3_);
      (void) _prdct (&nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &na_, &an_[idxa_ - 1], w3_, w1_, m_, am_, bm_, cm_, wd_, 
      ww_, wu_);
      $3_ = ipi2_ - ccblk_.nm_;
      if ($3_ < 0) {
        goto _l105;
      } else if ($3_ == 0) {
        goto _l105;
      } else {
        goto _l103;
      }
      _l103:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w3_[j_ - 1] = CMPLXF (0.0, 0.0);
        w2_[j_ - 1] = CMPLXF (0.0, 0.0);
      }
      goto _l106;
      _l105:;
      (void) _prdct (&np2_, &b_[ip2_ - 1], &np1_, &b_[ip1_ - 1], &np3_, &b_[ip3_ - 1], &_k0, &dum_, &y_[0 + ((*idimy_)) * 
      ((ipi2_ - 1))], w3_, m_, am_, bm_, cm_, wd_, ww_, wu_);
      (void) _prdct (&np1_, &b_[ip1_ - 1], &_k0, &dum_, &_k0, &dum_, &nc_, &cn_[idxc_ - 1], w3_, w2_, m_, am_, bm_, cm_, wd_, 
      ww_, wu_);
      _l106:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] = w1_[j_ - 1] + w2_[j_ - 1] + y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))];
      }
      _l108:;
    }
  }
  $4_ = ccblk_.npp_;
  if ($4_ < 0) {
    goto _l132;
  } else if ($4_ == 0) {
    goto _l110;
  } else {
    goto _l132;
  }
  _l110:;
  if_ = _up_int_4 (2, ccblk_.k_);
  i_ = if_ / 2;
  i1_ = i_ / 2;
  (void) _inxcb (($5_ = i_ - i1_, &$5_), ($6_ = ccblk_.k_ - 2, &$6_), &im1_, &nm1_);
  (void) _inxcb (($7_ = i_ + i1_, &$7_), ($8_ = ccblk_.k_ - 2, &$8_), &ip1_, &np1_);
  (void) _inxcb (&i_, ($9_ = ccblk_.k_ - 1, &$9_), &iz_, &nz_);
  (void) _prdct (&nz_, &b_[iz_ - 1], &nm1_, &b_[im1_ - 1], &np1_, &b_[ip1_ - 1], &_k0, &dum_, &y_[0 + ((*idimy_)) * ((i_ 
  - 1))], w1_, m_, am_, bm_, cm_, wd_, ww_, wu_);
  izr_ = i_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    w2_[j_ - 1] = w1_[j_ - 1];
  }
  for (ll_ = 2; ll_ <= ccblk_.k_; (ll_)++) {
    l_ = ccblk_.k_ - ll_ + 1;
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i_ = i2_;
    (void) _inxcc (&i_, &ir_, &idxc_, &nc_);
    (void) _inxcb (&i_, &ir_, &iz_, &nz_);
    (void) _inxcb (($10_ = i_ - i1_, &$10_), ($11_ = ir_ - 1, &$11_), &im1_, &nm1_);
    (void) _inxcb (($12_ = i_ + i1_, &$12_), ($13_ = ir_ - 1, &$13_), &ip1_, &np1_);
    (void) _prdct (&np1_, &b_[ip1_ - 1], &_k0, &dum_, &_k0, &dum_, &nc_, &cn_[idxc_ - 1], w1_, w1_, m_, am_, bm_, cm_, wd_, 
    ww_, wu_);
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      w1_[j_ - 1] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] + w1_[j_ - 1];
    }
    (void) _prdct (&nz_, &b_[iz_ - 1], &nm1_, &b_[im1_ - 1], &np1_, &b_[ip1_ - 1], &_k0, &dum_, w1_, w1_, m_, am_, bm_, 
    cm_, wd_, ww_, wu_);
  }
  for (ll_ = 2; ll_ <= ccblk_.k_; (ll_)++) {
    l_ = ccblk_.k_ - ll_ + 1;
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i4_ = i2_ + i2_;
    ifd_ = if_ - i2_;
    for (i_ = i2_; (i4_ > 0 ? i_ <= ifd_ : i_ >= ifd_); i_ += i4_) {
      $14_ = i_ - i2_ - izr_;
      if ($14_ < 0) {
        goto _l117;
      } else if ($14_ == 0) {
        goto _l114;
      } else {
        goto _l117;
      }
      _l114:;
      $15_ = i_ - ccblk_.nm_;
      if ($15_ < 0) {
        goto _l115;
      } else if ($15_ == 0) {
        goto _l115;
      } else {
        goto _l118;
      }
      _l115:;
      (void) _inxca (&i_, &ir_, &idxa_, &na_);
      (void) _inxcb (&i_, &ir_, &iz_, &nz_);
      (void) _inxcb (($16_ = i_ - i1_, &$16_), ($17_ = ir_ - 1, &$17_), &im1_, &nm1_);
      (void) _inxcb (($18_ = i_ + i1_, &$18_), ($19_ = ir_ - 1, &$19_), &ip1_, &np1_);
      (void) _prdct (&nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &na_, &an_[idxa_ - 1], w2_, w2_, m_, am_, bm_, cm_, wd_, 
      ww_, wu_);
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w2_[j_ - 1] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] + w2_[j_ - 1];
      }
      (void) _prdct (&nz_, &b_[iz_ - 1], &nm1_, &b_[im1_ - 1], &np1_, &b_[ip1_ - 1], &_k0, &dum_, w2_, w2_, m_, am_, bm_, 
      cm_, wd_, ww_, wu_);
      izr_ = i_;
      $20_ = i_ - ccblk_.nm_;
      if ($20_ < 0) {
        goto _l117;
      } else if ($20_ == 0) {
        goto _l119;
      } else {
        goto _l117;
      }
      _l117:;
    }
    _l118:;
  }
  _l119:;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1 + ((*idimy_)) * ((ccblk_.nm_ + 1 - 1))] = y_[j_ - 1 + ((*idimy_)) * ((ccblk_.nm_ + 1 - 1))] - cn_[ccblk_.nm_ 
    + 1 - 1] * w1_[j_ - 1] - an_[ccblk_.nm_ + 1 - 1] * w2_[j_ - 1];
  }
  (void) _inxcb (($21_ = if_ / 2, &$21_), ($22_ = ccblk_.k_ - 1, &$22_), &im1_, &nm1_);
  (void) _inxcb (&if_, ($23_ = ccblk_.k_ - 1, &$23_), &ip_, &np_);
  $24_ = ccblk_.ncmplx_;
  if ($24_ < 0) {
    goto _l121;
  } else if ($24_ == 0) {
    goto _l122;
  } else {
    goto _l121;
  }
  _l121:;
  (void) _cprdct (($25_ = ccblk_.nm_ + 1, &$25_), &b_[ip_ - 1], &nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &y_[0 + 
  ((*idimy_)) * ((ccblk_.nm_ + 1 - 1))], &y_[0 + ((*idimy_)) * ((ccblk_.nm_ + 1 - 1))], m_, am_, bm_, cm_, w1_, w3_, ww_)
  ;
  goto _l123;
  _l122:;
  (void) _prdct (($26_ = ccblk_.nm_ + 1, &$26_), &b_[ip_ - 1], &nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &y_[0 + 
  ((*idimy_)) * ((ccblk_.nm_ + 1 - 1))], &y_[0 + ((*idimy_)) * ((ccblk_.nm_ + 1 - 1))], m_, am_, bm_, cm_, wd_, ww_, wu_)
  ;
  _l123:;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    w1_[j_ - 1] = an_[0] * y_[j_ - 1 + ((*idimy_)) * ((ccblk_.nm_ + 1 - 1))];
    w2_[j_ - 1] = cn_[ccblk_.nm_ - 1] * y_[j_ - 1 + ((*idimy_)) * ((ccblk_.nm_ + 1 - 1))];
    y_[j_ - 1 + ((*idimy_)) * ((0))] = y_[j_ - 1 + ((*idimy_)) * ((0))] - w1_[j_ - 1];
    y_[j_ - 1 + ((*idimy_)) * ((ccblk_.nm_ - 1))] = y_[j_ - 1 + ((*idimy_)) * ((ccblk_.nm_ - 1))] - w2_[j_ - 1];
  }
  for (l_ = 1; l_ <= kdo_; (l_)++) {
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i4_ = i2_ + i2_;
    i1_ = i2_ / 2;
    i_ = i4_;
    (void) _inxca (&i_, &ir_, &idxa_, &na_);
    (void) _inxcb (($27_ = i_ - i2_, &$27_), &ir_, &im2_, &nm2_);
    (void) _inxcb (($28_ = i_ - i2_ - i1_, &$28_), ($29_ = ir_ - 1, &$29_), &im3_, &nm3_);
    (void) _inxcb (($30_ = i_ - i1_, &$30_), ($31_ = ir_ - 1, &$31_), &im1_, &nm1_);
    (void) _prdct (&nm2_, &b_[im2_ - 1], &nm3_, &b_[im3_ - 1], &nm1_, &b_[im1_ - 1], &_k0, &dum_, w1_, w1_, m_, am_, bm_, 
    cm_, wd_, ww_, wu_);
    (void) _prdct (&nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &na_, &an_[idxa_ - 1], w1_, w1_, m_, am_, bm_, cm_, wd_, 
    ww_, wu_);
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] - w1_[j_ - 1];
    }
  }
  izr_ = ccblk_.nm_;
  for (l_ = 1; l_ <= kdo_; (l_)++) {
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i3_ = i2_ + i1_;
    i4_ = i2_ + i2_;
    irm1_ = ir_ - 1;
    for (i_ = i4_; (i4_ > 0 ? i_ <= if_ : i_ >= if_); i_ += i4_) {
      ipi1_ = i_ + i1_;
      ipi2_ = i_ + i2_;
      ipi3_ = i_ + i3_;
      $32_ = ipi2_ - izr_;
      if ($32_ < 0) {
        goto _l127;
      } else if ($32_ == 0) {
        goto _l128;
      } else {
        goto _l127;
      }
      _l127:;
      $33_ = i_ - izr_;
      if ($33_ < 0) {
        goto _l130;
      } else if ($33_ == 0) {
        goto _l131;
      } else {
        goto _l130;
      }
      _l128:;
      (void) _inxcc (&i_, &ir_, &idxc_, &nc_);
      (void) _inxcb (&ipi2_, &ir_, &ip2_, &np2_);
      (void) _inxcb (&ipi1_, &irm1_, &ip1_, &np1_);
      (void) _inxcb (&ipi3_, &irm1_, &ip3_, &np3_);
      (void) _prdct (&np2_, &b_[ip2_ - 1], &np1_, &b_[ip1_ - 1], &np3_, &b_[ip3_ - 1], &_k0, &dum_, w2_, w2_, m_, am_, bm_, 
      cm_, wd_, ww_, wu_);
      (void) _prdct (&np1_, &b_[ip1_ - 1], &_k0, &dum_, &_k0, &dum_, &nc_, &cn_[idxc_ - 1], w2_, w2_, m_, am_, bm_, cm_, wd_, 
      ww_, wu_);
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] - w2_[j_ - 1];
      }
      izr_ = i_;
      goto _l131;
      _l130:;
    }
    _l131:;
  }
  _l132:;
  for (ll_ = 1; ll_ <= ccblk_.k_; (ll_)++) {
    l_ = ccblk_.k_ - ll_ + 1;
    ir_ = l_ - 1;
    irm1_ = ir_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i1_ = i2_ / 2;
    i4_ = i2_ + i2_;
    ifd_ = if_ - i2_;
    for (i_ = i2_; (i4_ > 0 ? i_ <= ifd_ : i_ >= ifd_); i_ += i4_) {
      $34_ = i_ - ccblk_.nm_;
      if ($34_ < 0) {
        goto _l133;
      } else if ($34_ == 0) {
        goto _l133;
      } else {
        goto _l143;
      }
      _l133:;
      imi1_ = i_ - i1_;
      imi2_ = i_ - i2_;
      ipi1_ = i_ + i1_;
      ipi2_ = i_ + i2_;
      (void) _inxca (&i_, &ir_, &idxa_, &na_);
      (void) _inxcc (&i_, &ir_, &idxc_, &nc_);
      (void) _inxcb (&i_, &ir_, &iz_, &nz_);
      (void) _inxcb (&imi1_, &irm1_, &im1_, &nm1_);
      (void) _inxcb (&ipi1_, &irm1_, &ip1_, &np1_);
      $35_ = i_ - i2_;
      if ($35_ < 0) {
        goto _l134;
      } else if ($35_ == 0) {
        goto _l134;
      } else {
        goto _l136;
      }
      _l134:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w1_[j_ - 1] = CMPLXF (0.0, 0.0);
      }
      goto _l137;
      _l136:;
      (void) _prdct (&nm1_, &b_[im1_ - 1], &_k0, &dum_, &_k0, &dum_, &na_, &an_[idxa_ - 1], &y_[0 + ((*idimy_)) * ((imi2_ - 
      1))], w1_, m_, am_, bm_, cm_, wd_, ww_, wu_);
      _l137:;
      $36_ = ipi2_ - ccblk_.nm_;
      if ($36_ < 0) {
        goto _l140;
      } else if ($36_ == 0) {
        goto _l140;
      } else {
        goto _l138;
      }
      _l138:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w2_[j_ - 1] = CMPLXF (0.0, 0.0);
      }
      goto _l141;
      _l140:;
      (void) _prdct (&np1_, &b_[ip1_ - 1], &_k0, &dum_, &_k0, &dum_, &nc_, &cn_[idxc_ - 1], &y_[0 + ((*idimy_)) * ((ipi2_ - 
      1))], w2_, m_, am_, bm_, cm_, wd_, ww_, wu_);
      _l141:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        w1_[j_ - 1] = y_[j_ - 1 + ((*idimy_)) * ((i_ - 1))] + w1_[j_ - 1] + w2_[j_ - 1];
      }
      (void) _prdct (&nz_, &b_[iz_ - 1], &nm1_, &b_[im1_ - 1], &np1_, &b_[ip1_ - 1], &_k0, &dum_, w1_, &y_[0 + ((*idimy_)) * 
      ((i_ - 1))], m_, am_, bm_, cm_, wd_, ww_, wu_);
      _l143:;
    }
  }
  __calls[16].calls++;
  return 0;
}

int_4 _ccmpb (int_4 _p_ n_, int_4 _p_ ierror_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, real_4 _p_ b_, real_4 
_p_ ah_, real_4 _p_ bh_)
{
  static int_4 j_, if_, kdo_, l_, ir_, i2_, i4_, ipl_, ifd_, i_, ib_, nb_, js_, jf_, ls_, lh_, nmp_, l1_, l2_, j2_, j1_, 
  n2m2_;
  static real_4 bnorm_, arg_, d1_, d2_, d3_;
  int_4 $0_, $2_, $3_, $4_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_;
  real_4 $1_, $5_;
  extern real_4 _r1mach ();
  ccblk_.eps_ = _r1mach (($0_ = 4, &$0_));
  bnorm_ = _abs (bn_[0]);
  for (j_ = 2; j_ <= ccblk_.nm_; (j_)++) {
    bnorm_ = _max (bnorm_, _abs (bn_[j_ - 1]));
    arg_ = an_[j_ - 1] * cn_[j_ - 1 - 1];
    $1_ = arg_;
    if ($1_ < 0) {
      goto _l119;
    } else if ($1_ == 0) {
      goto _l101;
    } else {
      goto _l101;
    }
    _l101:;
    b_[j_ - 1] = _sign (sqrtf (arg_), an_[j_ - 1]);
  }
  ccblk_.cnv_ = ccblk_.eps_ * bnorm_;
  if_ = _up_int_4 (2, ccblk_.k_);
  kdo_ = ccblk_.k_ - 1;
  for (l_ = 1; l_ <= kdo_; (l_)++) {
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i4_ = i2_ + i2_;
    ipl_ = i4_ - 1;
    ifd_ = if_ - i4_;
    for (i_ = i4_; (i4_ > 0 ? i_ <= ifd_ : i_ >= ifd_); i_ += i4_) {
      (void) _inxcb (&i_, &l_, &ib_, &nb_);
      $2_ = nb_;
      if ($2_ < 0) {
        goto _l108;
      } else if ($2_ == 0) {
        goto _l108;
      } else {
        goto _l103;
      }
      _l103:;
      js_ = i_ - ipl_;
      jf_ = js_ + nb_ - 1;
      ls_ = 0;
      for (j_ = js_; j_ <= jf_; (j_)++) {
        ls_ = ls_ + 1;
        bh_[ls_ - 1] = bn_[j_ - 1];
        ah_[ls_ - 1] = b_[j_ - 1];
      }
      (void) _tevlc (&nb_, bh_, ah_, ierror_);
      $3_ = (*ierror_);
      if ($3_ < 0) {
        goto _l118;
      } else if ($3_ == 0) {
        goto _l105;
      } else {
        goto _l118;
      }
      _l105:;
      lh_ = ib_ - 1;
      for (j_ = 1; j_ <= nb_; (j_)++) {
        lh_ = lh_ + 1;
        b_[lh_ - 1] = -bh_[j_ - 1];
      }
    }
    _l108:;
  }
  for (j_ = 1; j_ <= ccblk_.nm_; (j_)++) {
    b_[j_ - 1] = -bn_[j_ - 1];
  }
  $4_ = ccblk_.npp_;
  if ($4_ < 0) {
    goto _l117;
  } else if ($4_ == 0) {
    goto _l110;
  } else {
    goto _l117;
  }
  _l110:;
  nmp_ = ccblk_.nm_ + 1;
  nb_ = ccblk_.nm_ + nmp_;
  for (j_ = 1; j_ <= nb_; (j_)++) {
    l1_ = _imod (j_ - 1, nmp_) + 1;
    l2_ = _imod (j_ + ccblk_.nm_ - 1, nmp_) + 1;
    arg_ = an_[l1_ - 1] * cn_[l2_ - 1];
    $5_ = arg_;
    if ($5_ < 0) {
      goto _l119;
    } else if ($5_ == 0) {
      goto _l111;
    } else {
      goto _l111;
    }
    _l111:;
    bh_[j_ - 1] = _sign (sqrtf (arg_), -an_[l1_ - 1]);
    ah_[j_ - 1] = -bn_[l1_ - 1];
  }
  (void) _tevlc (&nb_, ah_, bh_, ierror_);
  $6_ = (*ierror_);
  if ($6_ < 0) {
    goto _l118;
  } else if ($6_ == 0) {
    goto _l113;
  } else {
    goto _l118;
  }
  _l113:;
  (void) _inxcb (&if_, ($7_ = ccblk_.k_ - 1, &$7_), &j2_, &lh_);
  (void) _inxcb (($8_ = if_ / 2, &$8_), ($9_ = ccblk_.k_ - 1, &$9_), &j1_, &lh_);
  j2_ = j2_ + 1;
  lh_ = j2_;
  n2m2_ = j2_ + ccblk_.nm_ + ccblk_.nm_ - 2;
  _l114:;
  d1_ = _abs (b_[j1_ - 1] - b_[j2_ - 1 - 1]);
  d2_ = _abs (b_[j1_ - 1] - b_[j2_ - 1]);
  d3_ = _abs (b_[j1_ - 1] - b_[j2_ + 1 - 1]);
  if ((d2_ < d1_) && (d2_ < d3_)) {
    goto _l115;
  }
  b_[lh_ - 1] = b_[j2_ - 1];
  j2_ = j2_ + 1;
  lh_ = lh_ + 1;
  $10_ = j2_ - n2m2_;
  if ($10_ < 0) {
    goto _l114;
  } else if ($10_ == 0) {
    goto _l114;
  } else {
    goto _l116;
  }
  _l115:;
  j2_ = j2_ + 1;
  j1_ = j1_ + 1;
  $11_ = j2_ - n2m2_;
  if ($11_ < 0) {
    goto _l114;
  } else if ($11_ == 0) {
    goto _l114;
  } else {
    goto _l116;
  }
  _l116:;
  b_[lh_ - 1] = b_[n2m2_ + 1 - 1];
  (void) _inxcb (&if_, ($12_ = ccblk_.k_ - 1, &$12_), &j1_, &j2_);
  j2_ = j1_ + nmp_ + nmp_;
  (void) _cpadd (($13_ = ccblk_.nm_ + 1, &$13_), ierror_, an_, cn_, &b_[j1_ - 1], &b_[j1_ - 1], &b_[j2_ - 1]);
  _l117:;
  goto _l0;
  _l118:;
  (*ierror_) = 4;
  goto _l0;
  _l119:;
  (*ierror_) = 5;
  _l0:;
  __calls[17].calls++;
  return 0;
}

int_4 _cfod (int_4 _p_ meth_, real_4 _p_ elco_, real_4 _p_ tesco_)
{
  static int_4 i_, ib_, nq_, nqm1_, nqp1_;
  static real_4 agamq_, fnq_, fnqm1_, pc_[12], pint_, ragq_, rqfac_, rq1fac_, tsign_, xpin_;
  switch ((*meth_)) {
    default:
    case 1: goto _l100;
    case 2: goto _l200;
  }
  _l100:;
  elco_[0] = 1.0;
  elco_[1] = 1.0;
  tesco_[0] = 0.0;
  tesco_[1] = 2.0;
  tesco_[3] = 1.0;
  tesco_[35] = 0.0;
  pc_[0] = 1.0;
  rqfac_ = 1.0;
  for (nq_ = 2; nq_ <= 12; (nq_)++) {
    rq1fac_ = rqfac_;
    rqfac_ = rqfac_ / nq_;
    nqm1_ = nq_ - 1;
    fnqm1_ = nqm1_;
    nqp1_ = nq_ + 1;
    pc_[nq_ - 1] = 0.0;
    for (ib_ = 1; ib_ <= nqm1_; (ib_)++) {
      i_ = nqp1_ - ib_;
      pc_[i_ - 1] = pc_[i_ - 1 - 1] + fnqm1_ * pc_[i_ - 1];
    }
    pc_[0] = fnqm1_ * pc_[0];
    pint_ = pc_[0];
    xpin_ = pc_[0] / 2.0e0;
    tsign_ = 1.0;
    for (i_ = 2; i_ <= nq_; (i_)++) {
      tsign_ = -tsign_;
      pint_ = pint_ + tsign_ * pc_[i_ - 1] / i_;
      xpin_ = xpin_ + tsign_ * pc_[i_ - 1] / (i_ + 1);
    }
    elco_[0 + (13) * ((nq_ - 1))] = pint_ * rq1fac_;
    elco_[1 + (13) * ((nq_ - 1))] = 1.0;
    for (i_ = 2; i_ <= nq_; (i_)++) {
      elco_[i_ + 1 - 1 + (13) * ((nq_ - 1))] = rq1fac_ * pc_[i_ - 1] / i_;
    }
    agamq_ = rqfac_ * xpin_;
    ragq_ = 1.0e0 / agamq_;
    tesco_[1 + (3) * ((nq_ - 1))] = ragq_;
    if (nq_ < 12) {
      tesco_[0 + (3) * ((nqp1_ - 1))] = ragq_ * rqfac_ / nqp1_;
    }
    tesco_[2 + (3) * ((nqm1_ - 1))] = ragq_;
  }
  goto _l0;
  _l200:;
  pc_[0] = 1.0;
  rq1fac_ = 1.0;
  for (nq_ = 1; nq_ <= 5; (nq_)++) {
    fnq_ = nq_;
    nqp1_ = nq_ + 1;
    pc_[nqp1_ - 1] = 0.0;
    for (ib_ = 1; ib_ <= nq_; (ib_)++) {
      i_ = nq_ + 2 - ib_;
      pc_[i_ - 1] = pc_[i_ - 1 - 1] + fnq_ * pc_[i_ - 1];
    }
    pc_[0] = fnq_ * pc_[0];
    for (i_ = 1; i_ <= nqp1_; (i_)++) {
      elco_[i_ - 1 + (13) * ((nq_ - 1))] = pc_[i_ - 1] / pc_[1];
    }
    elco_[1 + (13) * ((nq_ - 1))] = 1.0;
    tesco_[0 + (3) * ((nq_ - 1))] = rq1fac_;
    tesco_[1 + (3) * ((nq_ - 1))] = nqp1_ / elco_[0 + (13) * ((nq_ - 1))];
    tesco_[2 + (3) * ((nq_ - 1))] = (nq_ + 2) / elco_[0 + (13) * ((nq_ - 1))];
    rq1fac_ = rq1fac_ / fnq_;
  }
  _l0:;
  __calls[18].calls++;
  return 0;
}

int_4 _cgeev (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ e_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ 
work_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, ihi_, ilo_, j_, k_, l_, mdim_, m_;
  int_4 $0_, $1_, $3_, $5_, $6_, $7_, $8_, $9_, $10_, $11_;
  char_127 $2_, $4_;
  if ((*n_) > (*lda_)) {
    (void) _xermsg (_dc_1, _dc_19, _dc_20, &_k1, &_k1);
  }
  if ((*n_) > (*lda_)) {
    goto _l0;
  }
  if ((*n_) < 1) {
    (void) _xermsg (_dc_1, _dc_19, _dc_21, ($0_ = 2, &$0_), &_k1);
  }
  if ((*n_) < 1) {
    goto _l0;
  }
  if ((*n_) == 1 && (*job_) == 0) {
    goto _l35;
  }
  mdim_ = 2 * (*lda_);
  if ((*job_) == 0) {
    goto _l5;
  }
  if ((*n_) > (*ldv_)) {
    (void) _xermsg (_dc_1, _dc_19, _dc_22, ($1_ = 3, &$1_), &_k1);
  }
  if ((*n_) > (*ldv_)) {
    goto _l0;
  }
  if ((*n_) == 1) {
    goto _l35;
  }
  mdim_ = _min (mdim_, 2 * (*ldv_));
  if ((*lda_) < (*ldv_)) {
    (void) _xermsg (_dc_1, _dc_19, concat ($2_, _dc_23, _dc_24), ($3_ = 5, &$3_), &_k0);
  }
  if ((*lda_) <= (*ldv_)) {
    goto _l5;
  }
  (void) _xermsg (_dc_1, _dc_19, concat ($4_, _dc_25, _dc_24), ($5_ = 4, &$5_), &_k0);
  l_ = (*n_) - 1;
  for (j_ = 1; j_ <= l_; (j_)++) {
    i_ = 2 * (*n_);
    m_ = 1 + j_ * 2 * (*ldv_);
    k_ = 1 + j_ * 2 * (*lda_);
    (void) _scopy (&i_, &a_[k_ - 1], &_k1, &a_[m_ - 1], &_k1);
  }
  _l5:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    k_ = (j_ - 1) * mdim_ + 1;
    l_ = k_ + (*n_);
    (void) _scopy (n_, &a_[k_ + 1 - 1], ($6_ = 2, &$6_), &work_[0], &_k1);
    (void) _scopy (n_, &a_[k_ - 1], ($7_ = 2, &$7_), &a_[k_ - 1], &_k1);
    (void) _scopy (n_, &work_[0], &_k1, &a_[l_ - 1], &_k1);
  }
  (void) _cbal (&mdim_, n_, &a_[0], &a_[(*n_) + 1 - 1], &ilo_, &ihi_, &work_[0]);
  (void) _corth (&mdim_, n_, &ilo_, &ihi_, &a_[0], &a_[(*n_) + 1 - 1], &work_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 1])
  ;
  if ((*job_) != 0) {
    goto _l10;
  }
  (void) _comqr (&mdim_, n_, &ilo_, &ihi_, &a_[0], &a_[(*n_) + 1 - 1], &e_[0], &e_[(*n_) + 1 - 1], info_);
  goto _l30;
  _l10:;
  (void) _comqr2 (&mdim_, n_, &ilo_, &ihi_, &work_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 1], &a_[0], &a_[(*n_) + 1 - 1], 
  &e_[0], &e_[(*n_) + 1 - 1], &v_[0], &v_[(*n_) + 1 - 1], info_);
  if ((*info_) != 0) {
    goto _l30;
  }
  (void) _cbabk2 (&mdim_, n_, &ilo_, &ihi_, &work_[0], n_, &v_[0], &v_[(*n_) + 1 - 1]);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    k_ = (j_ - 1) * mdim_ + 1;
    i_ = (j_ - 1) * 2 * (*ldv_) + 1;
    l_ = k_ + (*n_);
    (void) _scopy (n_, &v_[k_ - 1], &_k1, &work_[0], &_k1);
    (void) _scopy (n_, &v_[l_ - 1], &_k1, &v_[i_ + 1 - 1], ($8_ = 2, &$8_));
    (void) _scopy (n_, &work_[0], &_k1, &v_[i_ - 1], ($9_ = 2, &$9_));
  }
  _l30:;
  (void) _scopy (n_, &e_[0], &_k1, &work_[0], &_k1);
  (void) _scopy (n_, &e_[(*n_) + 1 - 1], &_k1, &e_[1], ($10_ = 2, &$10_));
  (void) _scopy (n_, &work_[0], &_k1, &e_[0], ($11_ = 2, &$11_));
  goto _l0;
  _l35:;
  e_[0] = a_[0];
  e_[1] = a_[1];
  (*info_) = 0;
  if ((*job_) == 0) {
    goto _l0;
  }
  v_[0] = a_[0];
  v_[1] = a_[1];
  _l0:;
  __calls[19].calls++;
  return 0;
}

int_4 _cgefs (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
complex_8 _p_ work_, int_4 _p_ iwork_)
{
  static real_4 rcond_;
  static char_15 xern1_, xern2_;
  int_4 __fcnt, __rc, $7_, $11_, $12_, $13_, $14_;
  char_31 $0_, $4_, $8_;
  char_63 $1_, $5_, $6_, $9_, $10_;
  char_127 $2_, $3_;
  extern real_4 _r1mach ();
  static FORMAT $f_100009_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100010_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100016_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*lda_) < (*n_)) {
    (*ind_) = -1;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cgefs:114", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:114", 0));
      __fcnt += 3;
    }
    if ($f_100009_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:114", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100009_[__fcnt + 2], &(*lda_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:114", 0));
    __fcnt += 3;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      if ($f_100009_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:114", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cgefs:115", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:115", 0));
      __fcnt += 3;
    }
    if ($f_100010_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:115", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100010_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:115", 0));
    __fcnt += 3;
    while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
      if ($f_100010_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:115", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_26, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_27, xern1_), _dc_28), xern2_), 
    127), $3_), &_km1, &_k1);
    goto _l0;
  }
  if ((*n_) <= 0) {
    (*ind_) = -2;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cgefs:123", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:123", 0));
      __fcnt += 3;
    }
    if ($f_100016_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:123", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100016_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:123", 0));
    __fcnt += 3;
    while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
      if ($f_100016_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:123", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_26, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_29, xern1_), _dc_30), 63), $6_), ($7_ = -2, 
    &$7_), &_k1);
    goto _l0;
  }
  if ((*itask_) < 1) {
    (*ind_) = -3;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cgefs:131", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:131", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:131", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*itask_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:131", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgefs:131", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_26, (bufcpy ($10_, concat ($9_, concat ($8_, _dc_31, xern1_), _dc_30), 63), $10_), ($11_ = 
    -3, &$11_), &_k1);
    goto _l0;
  }
  if ((*itask_) == 1) {
    (void) _cgeco (a_, lda_, n_, iwork_, &rcond_, work_);
    if (rcond_ == 0.0) {
      (*ind_) = -4;
      (void) _xermsg (_dc_1, _dc_26, _dc_32, ($12_ = -4, &$12_), &_k1);
      goto _l0;
    }
    (*ind_) = -log10f (_r1mach (($13_ = 4, &$13_)) / rcond_);
    if ((*ind_) <= 0) {
      (*ind_) = -10;
      (void) _xermsg (_dc_1, _dc_26, _dc_33, ($14_ = -10, &$14_), &_k0);
    }
  }
  (void) _cgesl (a_, lda_, n_, iwork_, v_, &_k0);
  _l0:;
  __calls[20].calls++;
  return 0;
}

int_4 _cgeir (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
complex_8 _p_ work_, int_4 _p_ iwork_)
{
  static int_4 info_, j_;
  static real_4 xnorm_, dnorm_;
  static char_15 xern1_, xern2_;
  int_4 __fcnt, __rc, $7_, $11_, $12_, $14_, $15_;
  complex_8 $13_;
  char_31 $0_, $4_, $8_;
  char_63 $1_, $5_, $6_, $9_, $10_;
  char_127 $2_, $3_;
  extern complex_8 _cdcdot ();
  extern real_4 _scasum ();
  extern real_4 _r1mach ();
  static FORMAT $f_100008_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100009_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100015_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100021_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*lda_) < (*n_)) {
    (*ind_) = -1;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cgeir:117", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:117", 0));
      __fcnt += 3;
    }
    if ($f_100008_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:117", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100008_[__fcnt + 2], &(*lda_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:117", 0));
    __fcnt += 3;
    while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
      if ($f_100008_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:117", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cgeir:118", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:118", 0));
      __fcnt += 3;
    }
    if ($f_100009_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:118", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100009_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:118", 0));
    __fcnt += 3;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      if ($f_100009_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:118", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_34, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_27, xern1_), _dc_28), xern2_), 
    127), $3_), &_km1, &_k1);
    goto _l0;
  }
  if ((*n_) <= 0) {
    (*ind_) = -2;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cgeir:126", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:126", 0));
      __fcnt += 3;
    }
    if ($f_100015_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:126", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100015_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:126", 0));
    __fcnt += 3;
    while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
      if ($f_100015_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:126", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_34, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_29, xern1_), _dc_30), 63), $6_), ($7_ = -2, 
    &$7_), &_k1);
    goto _l0;
  }
  if ((*itask_) < 1) {
    (*ind_) = -3;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cgeir:134", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:134", 0));
      __fcnt += 3;
    }
    if ($f_100021_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:134", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100021_[__fcnt + 2], &(*itask_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:134", 0));
    __fcnt += 3;
    while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
      if ($f_100021_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cgeir:134", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_34, (bufcpy ($10_, concat ($9_, concat ($8_, _dc_31, xern1_), _dc_30), 63), $10_), ($11_ = 
    -3, &$11_), &_k1);
    goto _l0;
  }
  if ((*itask_) == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _ccopy (n_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &work_[0 + ((*n_)) * ((j_ - 1))], &_k1);
    }
    (void) _cgefa (work_, n_, n_, iwork_, &info_);
    if (info_ != 0) {
      (*ind_) = -4;
      (void) _xermsg (_dc_1, _dc_34, _dc_32, ($12_ = -4, &$12_), &_k1);
      goto _l0;
    }
  }
  (void) _ccopy (n_, &v_[0], &_k1, &work_[0 + ((*n_)) * (((*n_) + 1 - 1))], &_k1);
  (void) _cgesl (work_, n_, n_, iwork_, v_, &_k0);
  xnorm_ = _scasum (n_, &v_[0], &_k1);
  if (xnorm_ == 0.0) {
    (*ind_) = 75;
    goto _l0;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    work_[j_ - 1 + ((*n_)) * (((*n_) + 1 - 1))] = _cdcdot (n_, ($13_ = -work_[j_ - 1 + ((*n_)) * (((*n_) + 1 - 1))], 
    &$13_), &a_[j_ - 1 + ((*lda_)) * ((0))], lda_, v_, &_k1);
  }
  (void) _cgesl (work_, n_, n_, iwork_, &work_[0 + ((*n_)) * (((*n_) + 1 - 1))], &_k0);
  dnorm_ = _scasum (n_, &work_[0 + ((*n_)) * (((*n_) + 1 - 1))], &_k1);
  (*ind_) = -log10f (_max (_r1mach (($14_ = 4, &$14_)), dnorm_ / xnorm_));
  if ((*ind_) <= 0) {
    (*ind_) = -10;
    (void) _xermsg (_dc_1, _dc_34, _dc_33, ($15_ = -10, &$15_), &_k0);
  }
  _l0:;
  __calls[21].calls++;
  return 0;
}

int_4 _chiev (real_4 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_4 _p_ e_, real_4 _p_ v_, int_4 _p_ ldv_, real_4 _p_ 
work_, int_4 _p_ job_, int_4 _p_ info_)
{
  static int_4 i_, j_, k_, l_, m_, mdim_;
  int_4 $0_, $1_, $3_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_;
  char_127 $2_, $4_;
  if ((*n_) > (*lda_)) {
    (void) _xermsg (_dc_1, _dc_35, _dc_20, &_k1, &_k1);
  }
  if ((*n_) > (*lda_)) {
    goto _l0;
  }
  if ((*n_) < 1) {
    (void) _xermsg (_dc_1, _dc_35, _dc_21, ($0_ = 2, &$0_), &_k1);
  }
  if ((*n_) < 1) {
    goto _l0;
  }
  if ((*n_) == 1 && (*job_) == 0) {
    goto _l35;
  }
  mdim_ = 2 * (*lda_);
  if ((*job_) == 0) {
    goto _l5;
  }
  if ((*n_) > (*ldv_)) {
    (void) _xermsg (_dc_1, _dc_35, _dc_22, ($1_ = 3, &$1_), &_k1);
  }
  if ((*n_) > (*ldv_)) {
    goto _l0;
  }
  if ((*n_) == 1) {
    goto _l35;
  }
  mdim_ = _min (mdim_, 2 * (*ldv_));
  if ((*lda_) < (*ldv_)) {
    (void) _xermsg (_dc_1, _dc_35, concat ($2_, _dc_23, _dc_24), ($3_ = 5, &$3_), &_k0);
  }
  if ((*lda_) <= (*ldv_)) {
    goto _l5;
  }
  (void) _xermsg (_dc_1, _dc_35, concat ($4_, _dc_25, _dc_24), ($5_ = 4, &$5_), &_k0);
  l_ = (*n_) - 1;
  for (j_ = 1; j_ <= l_; (j_)++) {
    m_ = 1 + j_ * 2 * (*ldv_);
    k_ = 1 + j_ * 2 * (*lda_);
    (void) _scopy (($6_ = 2 * (*n_), &$6_), &a_[k_ - 1], &_k1, &a_[m_ - 1], &_k1);
  }
  _l5:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    k_ = (j_ - 1) * (mdim_ + 2) + 1;
    if (a_[k_ + 1 - 1] != 0.0) {
      (void) _xermsg (_dc_1, _dc_35, _dc_36, ($7_ = 6, &$7_), &_k1);
    }
    if (a_[k_ + 1 - 1] != 0.0) {
      goto _l0;
    }
    (void) _scopy (($8_ = (*n_) - j_ + 1, &$8_), &a_[k_ - 1], &mdim_, &a_[k_ - 1], ($9_ = 2, &$9_));
    (void) _scopym (($10_ = (*n_) - j_ + 1, &$10_), &a_[k_ + 1 - 1], &mdim_, &a_[k_ + 1 - 1], ($11_ = 2, &$11_));
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    k_ = (j_ - 1) * mdim_ + 1;
    l_ = k_ + (*n_);
    (void) _scopy (n_, &a_[k_ + 1 - 1], ($12_ = 2, &$12_), &work_[0], &_k1);
    (void) _scopy (n_, &a_[k_ - 1], ($13_ = 2, &$13_), &a_[k_ - 1], &_k1);
    (void) _scopy (n_, &work_[0], &_k1, &a_[l_ - 1], &_k1);
  }
  (void) _htridi (&mdim_, n_, &a_[0], &a_[(*n_) + 1 - 1], e_, &work_[0], &work_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 
  1]);
  if ((*job_) != 0) {
    goto _l15;
  }
  (void) _tqlrat (n_, e_, &work_[(*n_) + 1 - 1], info_);
  goto _l0;
  _l15:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    k_ = (j_ - 1) * mdim_ + 1;
    m_ = k_ + (*n_) - 1;
    for (i_ = k_; i_ <= m_; (i_)++) {
      v_[i_ - 1] = 0.0;
    }
    i_ = k_ + j_ - 1;
    v_[i_ - 1] = 1.0;
  }
  (void) _imtql2 (&mdim_, n_, e_, &work_[0], v_, info_);
  if ((*info_) != 0) {
    goto _l0;
  }
  (void) _htribk (&mdim_, n_, &a_[0], &a_[(*n_) + 1 - 1], &work_[2 * (*n_) + 1 - 1], n_, &v_[0], &v_[(*n_) + 1 - 1]);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    k_ = (j_ - 1) * mdim_ + 1;
    i_ = (j_ - 1) * 2 * (*ldv_) + 1;
    l_ = k_ + (*n_);
    (void) _scopy (n_, &v_[k_ - 1], &_k1, &work_[0], &_k1);
    (void) _scopy (n_, &v_[l_ - 1], &_k1, &v_[i_ + 1 - 1], ($14_ = 2, &$14_));
    (void) _scopy (n_, &work_[0], &_k1, &v_[i_ - 1], ($15_ = 2, &$15_));
  }
  goto _l0;
  _l35:;
  if (a_[1] != 0.0) {
    (void) _xermsg (_dc_1, _dc_35, _dc_36, ($16_ = 6, &$16_), &_k1);
  }
  if (a_[1] != 0.0) {
    goto _l0;
  }
  e_[0] = a_[0];
  (*info_) = 0;
  if ((*job_) == 0) {
    goto _l0;
  }
  v_[0] = a_[0];
  v_[1] = 0.0;
  _l0:;
  __calls[22].calls++;
  return 0;
}

int_4 _chkpr4 (int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, real_4 _p_ c_, real_4 
_p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, int_4 (*_cofx)(), int_4 _p_ idmn_, int_4 _p_ ierror_)
{
  static int_4 i_;
  static real_4 dlx_, xi_, ai_, bi_, ci_;
  (*ierror_) = 1;
  if ((*a_) >= (*b_) || (*c_) >= (*d_)) {
    goto _l0;
  }
  (*ierror_) = 2;
  if ((*mbdcnd_) < 0 || (*mbdcnd_) > 4) {
    goto _l0;
  }
  (*ierror_) = 3;
  if ((*nbdcnd_) < 0 || (*nbdcnd_) > 4) {
    goto _l0;
  }
  (*ierror_) = 5;
  if ((*idmn_) < 7) {
    goto _l0;
  }
  (*ierror_) = 6;
  if ((*m_) > ((*idmn_) - 1) || (*m_) < 6) {
    goto _l0;
  }
  (*ierror_) = 7;
  if ((*n_) < 5) {
    goto _l0;
  }
  (*ierror_) = 8;
  if ((*iorder_) != 2 && (*iorder_) != 4) {
    goto _l0;
  }
  dlx_ = ((*b_) - (*a_)) / (*m_);
  for (i_ = 2; i_ <= (*m_); (i_)++) {
    xi_ = (*a_) + (i_ - 1) * dlx_;
    (void) _cofx (&xi_, &ai_, &bi_, &ci_);
    if (ai_ > 0.0) {
      goto _l10;
    }
    (*ierror_) = 10;
    goto _l0;
    _l10:;
  }
  (*ierror_) = 0;
  _l0:;
  __calls[23].calls++;
  return 0;
}

int_4 _chkprm (int_4 _p_ intl_, int_4 _p_ iorder_, real_4 _p_ a_, real_4 _p_ b_, int_4 _p_ m_, int_4 _p_ mbdcnd_, 
real_4 _p_ c_, real_4 _p_ d_, int_4 _p_ n_, int_4 _p_ nbdcnd_, int_4 (*_cofx)(), int_4 (*_cofy)(), int_4 _p_ idmn_, 
int_4 _p_ ierror_)
{
  static int_4 i_, j_;
  static real_4 dlx_, dly_, xi_, ai_, bi_, ci_, yj_, dj_, ej_, fj_;
  (*ierror_) = 1;
  if ((*a_) >= (*b_) || (*c_) >= (*d_)) {
    goto _l0;
  }
  (*ierror_) = 2;
  if ((*mbdcnd_) < 0 || (*mbdcnd_) > 4) {
    goto _l0;
  }
  (*ierror_) = 3;
  if ((*nbdcnd_) < 0 || (*nbdcnd_) > 4) {
    goto _l0;
  }
  (*ierror_) = 5;
  if ((*idmn_) < 7) {
    goto _l0;
  }
  (*ierror_) = 6;
  if ((*m_) > ((*idmn_) - 1) || (*m_) < 6) {
    goto _l0;
  }
  (*ierror_) = 7;
  if ((*n_) < 5) {
    goto _l0;
  }
  (*ierror_) = 8;
  if ((*iorder_) != 2 && (*iorder_) != 4) {
    goto _l0;
  }
  (*ierror_) = 9;
  if ((*intl_) != 0 && (*intl_) != 1) {
    goto _l0;
  }
  dlx_ = ((*b_) - (*a_)) / (*m_);
  dly_ = ((*d_) - (*c_)) / (*n_);
  for (i_ = 2; i_ <= (*m_); (i_)++) {
    xi_ = (*a_) + (i_ - 1) * dlx_;
    (void) _cofx (&xi_, &ai_, &bi_, &ci_);
    for (j_ = 2; j_ <= (*n_); (j_)++) {
      yj_ = (*c_) + (j_ - 1) * dly_;
      (void) _cofy (&yj_, &dj_, &ej_, &fj_);
      if (ai_ * dj_ > 0.0) {
        goto _l10;
      }
      (*ierror_) = 10;
      goto _l0;
      _l10:;
    }
  }
  (*ierror_) = 0;
  _l0:;
  __calls[24].calls++;
  return 0;
}

int_4 _chksn4 (int_4 _p_ mbdcnd_, int_4 _p_ nbdcnd_, real_4 _p_ alpha_, real_4 _p_ beta_, int_4 (*_cofx)(), logical_4 
_p_ singlr_)
{
  static int_4 i_;
  static real_4 xi_, ai_, bi_, ci_;
  (*singlr_) = FALSE;
  if (((*mbdcnd_) != 0 && (*mbdcnd_) != 3) || ((*nbdcnd_) != 0 && (*nbdcnd_) != 3)) {
    goto _l0;
  }
  if ((*mbdcnd_) != 3) {
    goto _l10;
  }
  if ((*alpha_) != 0.0 || (*beta_) != 0.0) {
    goto _l0;
  }
  _l10:;
  for (i_ = spl4_.is_; i_ <= spl4_.ms_; (i_)++) {
    xi_ = spl4_.ait_ + (i_ - 1) * spl4_.dlx_;
    (void) _cofx (&xi_, &ai_, &bi_, &ci_);
    if (ci_ != 0.0) {
      goto _l0;
    }
  }
  (*singlr_) = TRUE;
  _l0:;
  __calls[25].calls++;
  return 0;
}

int_4 _chksng (int_4 _p_ mbdcnd_, int_4 _p_ nbdcnd_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ gama_, real_4 _p_ 
xnu_, int_4 (*_cofx)(), int_4 (*_cofy)(), logical_4 _p_ singlr_)
{
  static int_4 i_, j_;
  static real_4 xi_, ai_, bi_, ci_, yj_, dj_, ej_, fj_;
  (*singlr_) = FALSE;
  if (((*mbdcnd_) != 0 && (*mbdcnd_) != 3) || ((*nbdcnd_) != 0 && (*nbdcnd_) != 3)) {
    goto _l0;
  }
  if ((*mbdcnd_) != 3) {
    goto _l10;
  }
  if ((*alpha_) != 0.0 || (*beta_) != 0.0) {
    goto _l0;
  }
  _l10:;
  if ((*nbdcnd_) != 3) {
    goto _l20;
  }
  if ((*gama_) != 0.0 || (*xnu_) != 0.0) {
    goto _l0;
  }
  _l20:;
  for (i_ = splpcm_.is_; i_ <= splpcm_.ms_; (i_)++) {
    xi_ = splpcm_.ait_ + (i_ - 1) * splpcm_.dlx_;
    (void) _cofx (&xi_, &ai_, &bi_, &ci_);
    if (ci_ != 0.0) {
      goto _l0;
    }
  }
  for (j_ = splpcm_.js_; j_ <= splpcm_.ns_; (j_)++) {
    yj_ = splpcm_.cit_ + (j_ - 1) * splpcm_.dly_;
    (void) _cofy (&yj_, &dj_, &ej_, &fj_);
    if (fj_ != 0.0) {
      goto _l0;
    }
  }
  (*singlr_) = TRUE;
  _l0:;
  __calls[26].calls++;
  return 0;
}

int_4 _cmpcsg (int_4 _p_ n_, int_4 _p_ ijump_, real_4 _p_ fnum_, real_4 _p_ fden_, complex_8 _p_ a_)
{
  static int_4 k3_, k4_, k_, k1_, k5_, i_, k2_, np1_;
  static real_4 pi_, dum_, pibyn_, x_, y_;
  pi_ = _pimach (&dum_);
  if ((*n_) == 0) {
    goto _l105;
  }
  if ((*ijump_) == 1) {
    goto _l103;
  }
  k3_ = (*n_) / (*ijump_) + 1;
  k4_ = k3_ - 1;
  pibyn_ = pi_ / ((*n_) + (*ijump_));
  for (k_ = 1; k_ <= (*ijump_); (k_)++) {
    k1_ = (k_ - 1) * k3_;
    k5_ = (k_ - 1) * k4_;
    for (i_ = 1; i_ <= k4_; (i_)++) {
      x_ = k1_ + i_;
      k2_ = k5_ + i_;
      a_[k2_ - 1] = CMPLXF (-2.0 * cosf (x_ * pibyn_), 0.0);
    }
  }
  goto _l105;
  _l103:;
  np1_ = (*n_) + 1;
  y_ = pi_ / ((*n_) + (*fden_));
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_ = np1_ - i_ - (*fnum_);
    a_[i_ - 1] = CMPLXF (2.0 * cosf (x_ * y_), 0.0);
  }
  _l105:;
  __calls[27].calls++;
  return 0;
}

int_4 _cmposd (int_4 _p_ mr_, int_4 _p_ nr_, int_4 _p_ istag_, complex_8 _p_ ba_, complex_8 _p_ bb_, complex_8 _p_ bc_, 
complex_8 _p_ q_, int_4 _p_ idimq_, complex_8 _p_ b_, complex_8 _p_ w_, complex_8 _p_ d_, complex_8 _p_ tcos_, 
complex_8 _p_ p_)
{
  static int_4 m_, n_, ip_, ipstor_, jsh_, kr_, irreg_, jstsav_, i_, lr_, nun_, jst_, jsp_, l_, nodd_, j_, jm1_, jp1_, 
  jm2_, jp2_, jm3_, jp3_, noddpr_, ip1_, krpi_, ideg_, jdeg_;
  static real_4 fi_;
  static complex_8 t_;
  real_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_;
  m_ = (*mr_);
  n_ = (*nr_);
  fi_ = 1.0 / (*istag_);
  ip_ = -m_;
  ipstor_ = 0;
  jsh_ = 0;
  switch ((*istag_)) {
    default:
    case 1: goto _l101;
    case 2: goto _l102;
  }
  _l101:;
  kr_ = 0;
  irreg_ = 1;
  if (n_ > 1) {
    goto _l106;
  }
  tcos_[0] = CMPLXF (0.0, 0.0);
  goto _l103;
  _l102:;
  kr_ = 1;
  jstsav_ = 1;
  irreg_ = 2;
  if (n_ > 1) {
    goto _l106;
  }
  tcos_[0] = CMPLXF (-1.0, 0.0);
  _l103:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))];
  }
  (void) _cmptrx (&_k1, &_k0, &m_, ba_, bb_, bc_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= m_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((0))] = b_[i_ - 1];
  }
  goto _l183;
  _l106:;
  lr_ = 0;
  for (i_ = 1; i_ <= m_; (i_)++) {
    p_[i_ - 1] = CMPLXF (0.0, 0.0);
  }
  nun_ = n_;
  jst_ = 1;
  jsp_ = n_;
  _l108:;
  l_ = 2 * jst_;
  nodd_ = 2 - 2 * ((nun_ + 1) / 2) + nun_;
  switch (nodd_) {
    default:
    case 1: goto _l110;
    case 2: goto _l109;
  }
  _l109:;
  jsp_ = jsp_ - l_;
  goto _l111;
  _l110:;
  jsp_ = jsp_ - jst_;
  if (irreg_ != 1) {
    jsp_ = jsp_ - l_;
  }
  _l111:;
  (void) _cmpcsg (&jst_, &_k1, ($0_ = 0.5, &$0_), ($1_ = 0.0, &$1_), tcos_);
  if (l_ > jsp_) {
    goto _l118;
  }
  for (j_ = l_; (l_ > 0 ? j_ <= jsp_ : j_ >= jsp_); j_ += l_) {
    jm1_ = j_ - jsh_;
    jp1_ = j_ + jsh_;
    jm2_ = j_ - jst_;
    jp2_ = j_ + jst_;
    jm3_ = jm2_ - jsh_;
    jp3_ = jp2_ + jsh_;
    if (jst_ != 1) {
      goto _l113;
    }
    for (i_ = 1; i_ <= m_; (i_)++) {
      b_[i_ - 1] = 2.0 * q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 
      1))];
    }
    goto _l115;
    _l113:;
    for (i_ = 1; i_ <= m_; (i_)++) {
      t_ = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ 
      - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 1))];
      b_[i_ - 1] = t_ + q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm3_ - 1))] - q_[i_ - 1 + 
      ((*idimq_)) * ((jp3_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = t_;
    }
    _l115:;
    (void) _cmptrx (&jst_, &_k0, &m_, ba_, bb_, bc_, b_, tcos_, d_, w_);
    for (i_ = 1; i_ <= m_; (i_)++) {
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + b_[i_ - 1];
    }
  }
  _l118:;
  switch (nodd_) {
    default:
    case 1: goto _l119;
    case 2: goto _l136;
  }
  _l119:;
  switch (irreg_) {
    default:
    case 1: goto _l152;
    case 2: goto _l120;
  }
  _l120:;
  jsp_ = jsp_ + l_;
  j_ = jsp_;
  jm1_ = j_ - jsh_;
  jp1_ = j_ + jsh_;
  jm2_ = j_ - jst_;
  jp2_ = j_ + jst_;
  jm3_ = jm2_ - jsh_;
  switch ((*istag_)) {
    default:
    case 1: goto _l123;
    case 2: goto _l121;
  }
  _l121:;
  if (jst_ != 1) {
    goto _l123;
  }
  for (i_ = 1; i_ <= m_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
  }
  goto _l130;
  _l123:;
  switch (noddpr_) {
    default:
    case 1: goto _l124;
    case 2: goto _l126;
  }
  _l124:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    ip1_ = ip_ + i_;
    b_[i_ - 1] = .5 * (q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] - q_[i_ - 1 + 
    ((*idimq_)) * ((jm3_ - 1))]) + p_[ip1_ - 1] + q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
  }
  goto _l128;
  _l126:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    b_[i_ - 1] = .5 * (q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] - q_[i_ - 1 + 
    ((*idimq_)) * ((jm3_ - 1))]) + q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))] + 
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
  }
  _l128:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = .5 * (q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ 
    - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))]);
  }
  _l130:;
  (void) _cmptrx (&jst_, &_k0, &m_, ba_, bb_, bc_, b_, tcos_, d_, w_);
  ip_ = ip_ + m_;
  ipstor_ = _max (ipstor_, ip_ + m_);
  for (i_ = 1; i_ <= m_; (i_)++) {
    ip1_ = ip_ + i_;
    p_[ip1_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + b_[i_ - 1];
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 1))] + p_[ip1_ - 1];
  }
  if (lr_ != 0) {
    goto _l133;
  }
  for (i_ = 1; i_ <= jst_; (i_)++) {
    krpi_ = kr_ + i_;
    tcos_[krpi_ - 1] = tcos_[i_ - 1];
  }
  goto _l134;
  _l133:;
  (void) _cmpcsg (&lr_, &jstsav_, ($2_ = 0.0, &$2_), &fi_, &tcos_[jst_ + 1 - 1]);
  (void) _c1merg (tcos_, &_k0, &jst_, &jst_, &lr_, &kr_);
  _l134:;
  (void) _cmpcsg (&kr_, &jstsav_, ($3_ = 0.0, &$3_), &fi_, tcos_);
  (void) _cmptrx (&kr_, &kr_, &m_, ba_, bb_, bc_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= m_; (i_)++) {
    ip1_ = ip_ + i_;
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + b_[i_ - 1] + p_[ip1_ - 1];
  }
  lr_ = kr_;
  kr_ = kr_ + l_;
  goto _l152;
  _l136:;
  jsp_ = jsp_ + l_;
  j_ = jsp_;
  jm1_ = j_ - jsh_;
  jp1_ = j_ + jsh_;
  jm2_ = j_ - jst_;
  jp2_ = j_ + jst_;
  jm3_ = jm2_ - jsh_;
  switch (irreg_) {
    default:
    case 1: goto _l137;
    case 2: goto _l138;
  }
  _l137:;
  jstsav_ = jst_;
  ideg_ = jst_;
  kr_ = l_;
  goto _l139;
  _l138:;
  (void) _cmpcsg (&kr_, &jstsav_, ($4_ = 0.0, &$4_), &fi_, tcos_);
  (void) _cmpcsg (&lr_, &jstsav_, ($5_ = 0.0, &$5_), &fi_, &tcos_[kr_ + 1 - 1]);
  ideg_ = kr_;
  kr_ = kr_ + jst_;
  _l139:;
  if (jst_ != 1) {
    goto _l141;
  }
  irreg_ = 2;
  for (i_ = 1; i_ <= m_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))];
  }
  goto _l150;
  _l141:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + .5 * (q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] - q_[i_ - 1 + 
    ((*idimq_)) * ((jm1_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm3_ - 1))]);
  }
  switch (irreg_) {
    default:
    case 1: goto _l143;
    case 2: goto _l145;
  }
  _l143:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + .5 * (q_[i_ - 1 + ((*idimq_)) * ((j_ 
    - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))]);
  }
  irreg_ = 2;
  goto _l150;
  _l145:;
  switch (noddpr_) {
    default:
    case 1: goto _l146;
    case 2: goto _l148;
  }
  _l146:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    ip1_ = ip_ + i_;
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + p_[ip1_ - 1];
  }
  ip_ = ip_ - m_;
  goto _l150;
  _l148:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] 
    - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))];
  }
  _l150:;
  (void) _cmptrx (&ideg_, &lr_, &m_, ba_, bb_, bc_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= m_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + b_[i_ - 1];
  }
  _l152:;
  nun_ = nun_ / 2;
  noddpr_ = nodd_;
  jsh_ = jst_;
  jst_ = 2 * jst_;
  if (nun_ >= 2) {
    goto _l108;
  }
  j_ = jsp_;
  for (i_ = 1; i_ <= m_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
  }
  switch (irreg_) {
    default:
    case 1: goto _l154;
    case 2: goto _l155;
  }
  _l154:;
  (void) _cmpcsg (&jst_, &_k1, ($6_ = 0.5, &$6_), ($7_ = 0.0, &$7_), tcos_);
  ideg_ = jst_;
  goto _l156;
  _l155:;
  kr_ = lr_ + jst_;
  (void) _cmpcsg (&kr_, &jstsav_, ($8_ = 0.0, &$8_), &fi_, tcos_);
  (void) _cmpcsg (&lr_, &jstsav_, ($9_ = 0.0, &$9_), &fi_, &tcos_[kr_ + 1 - 1]);
  ideg_ = kr_;
  _l156:;
  (void) _cmptrx (&ideg_, &lr_, &m_, ba_, bb_, bc_, b_, tcos_, d_, w_);
  jm1_ = j_ - jsh_;
  jp1_ = j_ + jsh_;
  switch (irreg_) {
    default:
    case 1: goto _l157;
    case 2: goto _l159;
  }
  _l157:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = .5 * (q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ 
    - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))]) + b_[i_ - 1];
  }
  goto _l164;
  _l159:;
  switch (noddpr_) {
    default:
    case 1: goto _l160;
    case 2: goto _l162;
  }
  _l160:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    ip1_ = ip_ + i_;
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = p_[ip1_ - 1] + b_[i_ - 1];
  }
  ip_ = ip_ - m_;
  goto _l164;
  _l162:;
  for (i_ = 1; i_ <= m_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] 
    + b_[i_ - 1];
  }
  _l164:;
  jst_ = jst_ / 2;
  jsh_ = jst_ / 2;
  nun_ = 2 * nun_;
  if (nun_ > n_) {
    goto _l183;
  }
  for (j_ = jst_; (l_ > 0 ? j_ <= n_ : j_ >= n_); j_ += l_) {
    jm1_ = j_ - jsh_;
    jp1_ = j_ + jsh_;
    jm2_ = j_ - jst_;
    jp2_ = j_ + jst_;
    if (j_ > jst_) {
      goto _l166;
    }
    for (i_ = 1; i_ <= m_; (i_)++) {
      b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 1))];
    }
    goto _l170;
    _l166:;
    if (jp2_ <= n_) {
      goto _l168;
    }
    for (i_ = 1; i_ <= m_; (i_)++) {
      b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))];
    }
    if (jst_ < jstsav_) {
      irreg_ = 1;
    }
    switch (irreg_) {
      default:
      case 1: goto _l170;
      case 2: goto _l171;
    }
    _l168:;
    for (i_ = 1; i_ <= m_; (i_)++) {
      b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + q_[i_ - 1 + ((*idimq_)) 
      * ((jp2_ - 1))];
    }
    _l170:;
    (void) _cmpcsg (&jst_, &_k1, ($10_ = 0.5, &$10_), ($11_ = 0.0, &$11_), tcos_);
    ideg_ = jst_;
    jdeg_ = 0;
    goto _l172;
    _l171:;
    if (j_ + l_ > n_) {
      lr_ = lr_ - jst_;
    }
    kr_ = jst_ + lr_;
    (void) _cmpcsg (&kr_, &jstsav_, ($12_ = 0.0, &$12_), &fi_, tcos_);
    (void) _cmpcsg (&lr_, &jstsav_, ($13_ = 0.0, &$13_), &fi_, &tcos_[kr_ + 1 - 1]);
    ideg_ = kr_;
    jdeg_ = lr_;
    _l172:;
    (void) _cmptrx (&ideg_, &jdeg_, &m_, ba_, bb_, bc_, b_, tcos_, d_, w_);
    if (jst_ > 1) {
      goto _l174;
    }
    for (i_ = 1; i_ <= m_; (i_)++) {
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = b_[i_ - 1];
    }
    goto _l182;
    _l174:;
    if (jp2_ > n_) {
      goto _l177;
    }
    _l175:;
    for (i_ = 1; i_ <= m_; (i_)++) {
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = .5 * (q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ 
      - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))]) + b_[i_ - 1];
    }
    goto _l182;
    _l177:;
    switch (irreg_) {
      default:
      case 1: goto _l175;
      case 2: goto _l178;
    }
    _l178:;
    if (j_ + jsh_ > n_) {
      goto _l180;
    }
    for (i_ = 1; i_ <= m_; (i_)++) {
      ip1_ = ip_ + i_;
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = b_[i_ - 1] + p_[ip1_ - 1];
    }
    ip_ = ip_ - m_;
    goto _l182;
    _l180:;
    for (i_ = 1; i_ <= m_; (i_)++) {
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = b_[i_ - 1] + q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * 
      ((jm1_ - 1))];
    }
    _l182:;
  }
  l_ = l_ / 2;
  goto _l164;
  _l183:;
  w_[0] = CMPLXF ((real_4) (ipstor_), 0.0);
  __calls[28].calls++;
  return 0;
}

int_4 _cmposn (int_4 _p_ m_, int_4 _p_ n_, int_4 _p_ istag_, int_4 _p_ mixbnd_, complex_8 _p_ a_, complex_8 _p_ bb_, 
complex_8 _p_ c_, complex_8 _p_ q_, int_4 _p_ idimq_, complex_8 _p_ b_, complex_8 _p_ b2_, complex_8 _p_ b3_, complex_8 
_p_ w_, complex_8 _p_ w2_, complex_8 _p_ w3_, complex_8 _p_ d_, complex_8 _p_ tcos_, complex_8 _p_ p_)
{
  static int_4 k_[4], mr_, ip_, ipstor_, i2r_, jr_, nr_, nlast_, kr_, lr_, i_, nrod_, jstart_, jstop_, i2rby2_, j_, jp1_, 
  jp2_, jp3_, jm1_, jm2_, jm3_, nrodpr_, ii_, i1_, i2_, jr2_, nlastp_, jstep_;
  static real_4 fistag_, fnum_, fden_;
  static complex_8 fi_, t_;
  int_4 $12_, $14_, $17_, $18_, $22_, $24_, $25_, $29_, $30_, $32_, $35_, $36_;
  real_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $13_, $15_, $16_, $19_, $20_, $21_, $23_, $26_, 
  $27_, $28_, $31_, $33_, $34_, $37_, $38_, $39_, $40_, $41_, $42_;
  static int_4 _p_ const k1_ = (int_4 _p_) k_;
  static int_4 _p_ const k2_ = (int_4 _p_) &(k_[1]);
  static int_4 _p_ const k3_ = (int_4 _p_) &(k_[2]);
  static int_4 _p_ const k4_ = (int_4 _p_) &(k_[3]);
  fistag_ = 3 - (*istag_);
  fnum_ = 1.0 / (*istag_);
  fden_ = 0.5 * ((*istag_) - 1);
  mr_ = (*m_);
  ip_ = -mr_;
  ipstor_ = 0;
  i2r_ = 1;
  jr_ = 2;
  nr_ = (*n_);
  nlast_ = (*n_);
  kr_ = 1;
  lr_ = 0;
  switch ((*istag_)) {
    default:
    case 1: goto _l101;
    case 2: goto _l103;
  }
  _l101:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * (((*n_) - 1))] = .5 * q_[i_ - 1 + ((*idimq_)) * (((*n_) - 1))];
  }
  switch ((*mixbnd_)) {
    default:
    case 1: goto _l103;
    case 2: goto _l104;
  }
  _l103:;
  if ((*n_) <= 3) {
    goto _l155;
  }
  _l104:;
  jr_ = 2 * i2r_;
  nrod_ = 1;
  if ((nr_ / 2) * 2 == nr_) {
    nrod_ = 0;
  }
  switch ((*mixbnd_)) {
    default:
    case 1: goto _l105;
    case 2: goto _l106;
  }
  _l105:;
  jstart_ = 1;
  goto _l107;
  _l106:;
  jstart_ = jr_;
  nrod_ = 1 - nrod_;
  _l107:;
  jstop_ = nlast_ - jr_;
  if (nrod_ == 0) {
    jstop_ = jstop_ - i2r_;
  }
  (void) _cmpcsg (&i2r_, &_k1, ($0_ = 0.5, &$0_), ($1_ = 0.0, &$1_), tcos_);
  i2rby2_ = i2r_ / 2;
  if (jstop_ >= jstart_) {
    goto _l108;
  }
  j_ = jr_;
  goto _l116;
  _l108:;
  for (j_ = jstart_; (jr_ > 0 ? j_ <= jstop_ : j_ >= jstop_); j_ += jr_) {
    jp1_ = j_ + i2rby2_;
    jp2_ = j_ + i2r_;
    jp3_ = jp2_ + i2rby2_;
    jm1_ = j_ - i2rby2_;
    jm2_ = j_ - i2r_;
    jm3_ = jm2_ - i2rby2_;
    if (j_ != 1) {
      goto _l109;
    }
    jm1_ = jp1_;
    jm2_ = jp2_;
    jm3_ = jp3_;
    _l109:;
    if (i2r_ != 1) {
      goto _l111;
    }
    if (j_ == 1) {
      jm2_ = jp2_;
    }
    for (i_ = 1; i_ <= mr_; (i_)++) {
      b_[i_ - 1] = 2.0 * q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 
      1))];
    }
    goto _l113;
    _l111:;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      fi_ = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] 
      - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jp2_ 
      - 1))];
      b_[i_ - 1] = fi_ + q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm3_ - 1))] - q_[i_ - 1 + 
      ((*idimq_)) * ((jp3_ - 1))];
    }
    _l113:;
    (void) _cmptrx (&i2r_, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
    for (i_ = 1; i_ <= mr_; (i_)++) {
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + b_[i_ - 1];
    }
  }
  j_ = jstop_ + jr_;
  _l116:;
  nlast_ = j_;
  jm1_ = j_ - i2rby2_;
  jm2_ = j_ - i2r_;
  jm3_ = jm2_ - i2rby2_;
  if (nrod_ == 0) {
    goto _l128;
  }
  if (i2r_ != 1) {
    goto _l118;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = fistag_ * q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))];
  }
  goto _l126;
  _l118:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + .5 * (q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] - q_[i_ - 1 + 
    ((*idimq_)) * ((jm1_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm3_ - 1))]);
  }
  if (nrodpr_ != 0) {
    goto _l121;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    ii_ = ip_ + i_;
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + p_[ii_ - 1];
  }
  ip_ = ip_ - mr_;
  goto _l123;
  _l121:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] 
    + q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))];
  }
  _l123:;
  if (lr_ == 0) {
    goto _l124;
  }
  (void) _cmpcsg (&lr_, &_k1, ($2_ = 0.5, &$2_), &fden_, &tcos_[kr_ + 1 - 1]);
  goto _l126;
  _l124:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = fistag_ * b_[i_ - 1];
  }
  _l126:;
  (void) _cmpcsg (&kr_, &_k1, ($3_ = 0.5, &$3_), &fden_, tcos_);
  (void) _cmptrx (&kr_, &lr_, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + b_[i_ - 1];
  }
  kr_ = kr_ + i2r_;
  goto _l151;
  _l128:;
  jp1_ = j_ + i2rby2_;
  jp2_ = j_ + i2r_;
  if (i2r_ != 1) {
    goto _l135;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
  }
  (void) _cmptrx (&_k1, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  ip_ = 0;
  ipstor_ = mr_;
  switch ((*istag_)) {
    default:
    case 1: goto _l133;
    case 2: goto _l130;
  }
  _l130:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    p_[i_ - 1] = b_[i_ - 1];
    b_[i_ - 1] = b_[i_ - 1] + q_[i_ - 1 + ((*idimq_)) * (((*n_) - 1))];
  }
  tcos_[0] = CMPLXF (1.0, 0.0);
  tcos_[1] = CMPLXF (0.0, 0.0);
  (void) _cmptrx (&_k1, &_k1, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + p_[i_ - 1] + b_[i_ - 1];
  }
  goto _l150;
  _l133:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    p_[i_ - 1] = b_[i_ - 1];
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + 2.0 * q_[i_ - 1 + ((*idimq_)) * 
    ((jp2_ - 1))] + 3.0 * b_[i_ - 1];
  }
  goto _l150;
  _l135:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + .5 * (q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] - q_[i_ - 1 + 
    ((*idimq_)) * ((jm1_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm3_ - 1))]);
  }
  if (nrodpr_ != 0) {
    goto _l138;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    ii_ = ip_ + i_;
    b_[i_ - 1] = b_[i_ - 1] + p_[ii_ - 1];
  }
  goto _l140;
  _l138:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = b_[i_ - 1] + q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))];
  }
  _l140:;
  (void) _cmptrx (&i2r_, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  ip_ = ip_ + mr_;
  ipstor_ = _max (ipstor_, ip_ + mr_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    ii_ = ip_ + i_;
    p_[ii_ - 1] = b_[i_ - 1] + .5 * (q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] - 
    q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))]);
    b_[i_ - 1] = p_[ii_ - 1] + q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 1))];
  }
  if (lr_ == 0) {
    goto _l142;
  }
  (void) _cmpcsg (&lr_, &_k1, ($4_ = 0.5, &$4_), &fden_, &tcos_[i2r_ + 1 - 1]);
  (void) _c1merg (tcos_, &_k0, &i2r_, &i2r_, &lr_, &kr_);
  goto _l144;
  _l142:;
  for (i_ = 1; i_ <= i2r_; (i_)++) {
    ii_ = kr_ + i_;
    tcos_[ii_ - 1] = tcos_[i_ - 1];
  }
  _l144:;
  (void) _cmpcsg (&kr_, &_k1, ($5_ = 0.5, &$5_), &fden_, tcos_);
  if (lr_ != 0) {
    goto _l145;
  }
  switch ((*istag_)) {
    default:
    case 1: goto _l146;
    case 2: goto _l145;
  }
  _l145:;
  (void) _cmptrx (&kr_, &kr_, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  goto _l148;
  _l146:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = fistag_ * b_[i_ - 1];
  }
  _l148:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    ii_ = ip_ + i_;
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + p_[ii_ - 1] + b_[i_ - 1];
  }
  _l150:;
  lr_ = kr_;
  kr_ = kr_ + jr_;
  _l151:;
  switch ((*mixbnd_)) {
    default:
    case 1: goto _l152;
    case 2: goto _l153;
  }
  _l152:;
  nr_ = (nlast_ - 1) / jr_ + 1;
  if (nr_ <= 3) {
    goto _l155;
  }
  goto _l154;
  _l153:;
  nr_ = nlast_ / jr_;
  if (nr_ <= 1) {
    goto _l192;
  }
  _l154:;
  i2r_ = jr_;
  nrodpr_ = nrod_;
  goto _l104;
  _l155:;
  j_ = 1 + jr_;
  jm1_ = j_ - i2r_;
  jp1_ = j_ + i2r_;
  jm2_ = nlast_ - i2r_;
  if (nr_ == 2) {
    goto _l184;
  }
  if (lr_ != 0) {
    goto _l170;
  }
  if ((*n_) != 3) {
    goto _l161;
  }
  switch ((*istag_)) {
    default:
    case 1: goto _l156;
    case 2: goto _l168;
  }
  _l156:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((1))];
  }
  tcos_[0] = CMPLXF (0.0, 0.0);
  (void) _cmptrx (&_k1, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((1))] = b_[i_ - 1];
    b_[i_ - 1] = 4.0 * b_[i_ - 1] + q_[i_ - 1 + ((*idimq_)) * ((0))] + 2.0 * q_[i_ - 1 + ((*idimq_)) * ((2))];
  }
  tcos_[0] = CMPLXF (-2.0, 0.0);
  tcos_[1] = CMPLXF (2.0, 0.0);
  i1_ = 2;
  i2_ = 0;
  (void) _cmptrx (&i1_, &i2_, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((1))] = q_[i_ - 1 + ((*idimq_)) * ((1))] + b_[i_ - 1];
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))] + 2.0 * q_[i_ - 1 + ((*idimq_)) * ((1))];
  }
  tcos_[0] = CMPLXF (0.0, 0.0);
  (void) _cmptrx (&_k1, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((0))] = b_[i_ - 1];
  }
  jr_ = 1;
  i2r_ = 0;
  goto _l194;
  _l161:;
  switch ((*istag_)) {
    default:
    case 1: goto _l162;
    case 2: goto _l170;
  }
  _l162:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + .5 * q_[i_ - 1 + ((*idimq_)) * ((0))] - q_[i_ - 1 + ((*idimq_)) * 
    ((jm1_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))];
  }
  (void) _cmpcsg (&jr_, &_k1, ($6_ = 0.5, &$6_), ($7_ = 0.0, &$7_), tcos_);
  (void) _cmptrx (&jr_, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = .5 * (q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ 
    - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))]) + b_[i_ - 1];
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))] + 2.0 * q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] + 4.0 * q_[i_ - 1 + 
    ((*idimq_)) * ((j_ - 1))];
  }
  jr2_ = 2 * jr_;
  (void) _cmpcsg (&jr_, &_k1, ($8_ = 0.0, &$8_), ($9_ = 0.0, &$9_), tcos_);
  for (i_ = 1; i_ <= jr_; (i_)++) {
    i1_ = jr_ + i_;
    i2_ = jr_ + 1 - i_;
    tcos_[i1_ - 1] = -tcos_[i2_ - 1];
  }
  (void) _cmptrx (&jr2_, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + b_[i_ - 1];
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))] + 2.0 * q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
  }
  (void) _cmpcsg (&jr_, &_k1, ($10_ = 0.5, &$10_), ($11_ = 0.0, &$11_), tcos_);
  (void) _cmptrx (&jr_, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((0))] = .5 * q_[i_ - 1 + ((*idimq_)) * ((0))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] + 
    b_[i_ - 1];
  }
  goto _l194;
  _l168:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((1))];
    q_[i_ - 1 + ((*idimq_)) * ((1))] = CMPLXF (0.0, 0.0);
    b2_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((2))];
    b3_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))];
  }
  jr_ = 1;
  i2r_ = 0;
  j_ = 2;
  goto _l177;
  _l170:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = .5 * q_[i_ - 1 + ((*idimq_)) * ((0))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] + q_[i_ - 1 + ((*idimq_)) 
    * ((j_ - 1))];
  }
  if (nrod_ != 0) {
    goto _l173;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    ii_ = ip_ + i_;
    b_[i_ - 1] = b_[i_ - 1] + p_[ii_ - 1];
  }
  goto _l175;
  _l173:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = b_[i_ - 1] + q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))];
  }
  _l175:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    t_ = .5 * (q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] - q_[i_ - 1 + ((*idimq_)) * 
    ((jp1_ - 1))]);
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = t_;
    b2_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] + t_;
    b3_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))] + 2.0 * t_;
  }
  _l177:;
  (*k1_) = kr_ + 2 * jr_ - 1;
  (*k2_) = kr_ + jr_;
  tcos_[(*k1_) + 1 - 1] = CMPLXF (-2.0, 0.0);
  (*k4_) = (*k1_) + 3 - (*istag_);
  (void) _cmpcsg (($12_ = (*k2_) + (*istag_) - 2, &$12_), &_k1, ($13_ = 0.0, &$13_), &fnum_, &tcos_[(*k4_) - 1]);
  (*k4_) = (*k1_) + (*k2_) + 1;
  (void) _cmpcsg (($14_ = jr_ - 1, &$14_), &_k1, ($15_ = 0.0, &$15_), ($16_ = 1.0, &$16_), &tcos_[(*k4_) - 1]);
  (void) _c1merg (tcos_, k1_, k2_, ($17_ = (*k1_) + (*k2_), &$17_), ($18_ = jr_ - 1, &$18_), &_k0);
  (*k3_) = (*k1_) + (*k2_) + lr_;
  (void) _cmpcsg (&jr_, &_k1, ($19_ = 0.5, &$19_), ($20_ = 0.0, &$20_), &tcos_[(*k3_) + 1 - 1]);
  (*k4_) = (*k3_) + jr_ + 1;
  (void) _cmpcsg (&kr_, &_k1, ($21_ = 0.5, &$21_), &fden_, &tcos_[(*k4_) - 1]);
  (void) _c1merg (tcos_, k3_, &jr_, ($22_ = (*k3_) + jr_, &$22_), &kr_, k1_);
  if (lr_ == 0) {
    goto _l178;
  }
  (void) _cmpcsg (&lr_, &_k1, ($23_ = 0.5, &$23_), &fden_, &tcos_[(*k4_) - 1]);
  (void) _c1merg (tcos_, k3_, &jr_, ($24_ = (*k3_) + jr_, &$24_), &lr_, ($25_ = (*k3_) - lr_, &$25_));
  (void) _cmpcsg (&kr_, &_k1, ($26_ = 0.5, &$26_), &fden_, &tcos_[(*k4_) - 1]);
  _l178:;
  (*k3_) = kr_;
  (*k4_) = kr_;
  (void) _cmptr3 (&mr_, a_, bb_, c_, k_, b_, b2_, b3_, tcos_, d_, w_, w2_, w3_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = b_[i_ - 1] + b2_[i_ - 1] + b3_[i_ - 1];
  }
  tcos_[0] = CMPLXF (2.0, 0.0);
  (void) _cmptrx (&_k1, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + b_[i_ - 1];
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))] + 2.0 * q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
  }
  (void) _cmpcsg (&jr_, &_k1, ($27_ = 0.5, &$27_), ($28_ = 0.0, &$28_), tcos_);
  (void) _cmptrx (&jr_, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  if (jr_ != 1) {
    goto _l182;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((0))] = b_[i_ - 1];
  }
  goto _l194;
  _l182:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((0))] = .5 * q_[i_ - 1 + ((*idimq_)) * ((0))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))] + 
    b_[i_ - 1];
  }
  goto _l194;
  _l184:;
  if ((*n_) != 2) {
    goto _l188;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))];
  }
  tcos_[0] = CMPLXF (0.0, 0.0);
  (void) _cmptrx (&_k1, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((0))] = b_[i_ - 1];
    b_[i_ - 1] = 2.0 * (q_[i_ - 1 + ((*idimq_)) * ((1))] + b_[i_ - 1]) * fistag_;
  }
  tcos_[0] = CMPLXF (-fistag_, 0.0);
  tcos_[1] = CMPLXF (2.0, 0.0);
  (void) _cmptrx (($29_ = 2, &$29_), &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((0))] = q_[i_ - 1 + ((*idimq_)) * ((0))] + b_[i_ - 1];
  }
  jr_ = 1;
  i2r_ = 0;
  goto _l194;
  _l188:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    ii_ = ip_ + i_;
    b3_[i_ - 1] = CMPLXF (0.0, 0.0);
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((0))] + 2.0 * p_[ii_ - 1];
    q_[i_ - 1 + ((*idimq_)) * ((0))] = .5 * q_[i_ - 1 + ((*idimq_)) * ((0))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ - 1))];
    b2_[i_ - 1] = 2.0 * (q_[i_ - 1 + ((*idimq_)) * ((0))] + q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))]);
  }
  (*k1_) = kr_ + jr_ - 1;
  tcos_[(*k1_) + 1 - 1] = CMPLXF (-2.0, 0.0);
  (*k4_) = (*k1_) + 3 - (*istag_);
  (void) _cmpcsg (($30_ = kr_ + (*istag_) - 2, &$30_), &_k1, ($31_ = 0.0, &$31_), &fnum_, &tcos_[(*k4_) - 1]);
  (*k4_) = (*k1_) + kr_ + 1;
  (void) _cmpcsg (($32_ = jr_ - 1, &$32_), &_k1, ($33_ = 0.0, &$33_), ($34_ = 1.0, &$34_), &tcos_[(*k4_) - 1]);
  (void) _c1merg (tcos_, k1_, &kr_, ($35_ = (*k1_) + kr_, &$35_), ($36_ = jr_ - 1, &$36_), &_k0);
  (void) _cmpcsg (&kr_, &_k1, ($37_ = 0.5, &$37_), &fden_, &tcos_[(*k1_) + 1 - 1]);
  (*k2_) = kr_;
  (*k4_) = (*k1_) + (*k2_) + 1;
  (void) _cmpcsg (&lr_, &_k1, ($38_ = 0.5, &$38_), &fden_, &tcos_[(*k4_) - 1]);
  (*k3_) = lr_;
  (*k4_) = 0;
  (void) _cmptr3 (&mr_, a_, bb_, c_, k_, b_, b2_, b3_, tcos_, d_, w_, w2_, w3_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = b_[i_ - 1] + b2_[i_ - 1];
  }
  tcos_[0] = CMPLXF (2.0, 0.0);
  (void) _cmptrx (&_k1, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((0))] = q_[i_ - 1 + ((*idimq_)) * ((0))] + b_[i_ - 1];
  }
  goto _l194;
  _l192:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))];
  }
  goto _l196;
  _l194:;
  j_ = nlast_ - jr_;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
  }
  _l196:;
  jm2_ = nlast_ - i2r_;
  if (jr_ != 1) {
    goto _l198;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] = CMPLXF (0.0, 0.0);
  }
  goto _l202;
  _l198:;
  if (nrod_ != 0) {
    goto _l200;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    ii_ = ip_ + i_;
    q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] = p_[ii_ - 1];
  }
  ip_ = ip_ - mr_;
  goto _l202;
  _l200:;
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] - q_[i_ - 1 + ((*idimq_)) * 
    ((jm2_ - 1))];
  }
  _l202:;
  (void) _cmpcsg (&kr_, &_k1, ($39_ = 0.5, &$39_), &fden_, tcos_);
  (void) _cmpcsg (&lr_, &_k1, ($40_ = 0.5, &$40_), &fden_, &tcos_[kr_ + 1 - 1]);
  if (lr_ != 0) {
    goto _l204;
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    b_[i_ - 1] = fistag_ * b_[i_ - 1];
  }
  _l204:;
  (void) _cmptrx (&kr_, &lr_, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((nlast_ - 1))] + b_[i_ - 1];
  }
  nlastp_ = nlast_;
  _l206:;
  jstep_ = jr_;
  jr_ = i2r_;
  i2r_ = i2r_ / 2;
  if (jr_ == 0) {
    goto _l222;
  }
  switch ((*mixbnd_)) {
    default:
    case 1: goto _l207;
    case 2: goto _l208;
  }
  _l207:;
  jstart_ = 1 + jr_;
  goto _l209;
  _l208:;
  jstart_ = jr_;
  _l209:;
  kr_ = kr_ - jr_;
  if (nlast_ + jr_ > (*n_)) {
    goto _l210;
  }
  kr_ = kr_ - jr_;
  nlast_ = nlast_ + jr_;
  jstop_ = nlast_ - jstep_;
  goto _l211;
  _l210:;
  jstop_ = nlast_ - jr_;
  _l211:;
  lr_ = kr_ - jr_;
  (void) _cmpcsg (&jr_, &_k1, ($41_ = 0.5, &$41_), ($42_ = 0.0, &$42_), tcos_);
  for (j_ = jstart_; (jstep_ > 0 ? j_ <= jstop_ : j_ >= jstop_); j_ += jstep_) {
    jm2_ = j_ - jr_;
    jp2_ = j_ + jr_;
    if (j_ != jr_) {
      goto _l213;
    }
    for (i_ = 1; i_ <= mr_; (i_)++) {
      b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jp2_ - 1))];
    }
    goto _l215;
    _l213:;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      b_[i_ - 1] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((jm2_ - 1))] + q_[i_ - 1 + ((*idimq_)) 
      * ((jp2_ - 1))];
    }
    _l215:;
    if (jr_ != 1) {
      goto _l217;
    }
    for (i_ = 1; i_ <= mr_; (i_)++) {
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = CMPLXF (0.0, 0.0);
    }
    goto _l219;
    _l217:;
    jm1_ = j_ - i2r_;
    jp1_ = j_ + i2r_;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = .5 * (q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jm1_ 
      - 1))] - q_[i_ - 1 + ((*idimq_)) * ((jp1_ - 1))]);
    }
    _l219:;
    (void) _cmptrx (&jr_, &_k0, &mr_, a_, bb_, c_, b_, tcos_, d_, w_);
    for (i_ = 1; i_ <= mr_; (i_)++) {
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + b_[i_ - 1];
    }
  }
  nrod_ = 1;
  if (nlast_ + i2r_ <= (*n_)) {
    nrod_ = 0;
  }
  if (nlastp_ != nlast_) {
    goto _l194;
  }
  goto _l206;
  _l222:;
  w_[0] = CMPLXF ((real_4) (ipstor_), 0.0);
  __calls[29].calls++;
  return 0;
}

int_4 _cmposp (int_4 _p_ m_, int_4 _p_ n_, complex_8 _p_ a_, complex_8 _p_ bb_, complex_8 _p_ c_, complex_8 _p_ q_, 
int_4 _p_ idimq_, complex_8 _p_ b_, complex_8 _p_ b2_, complex_8 _p_ b3_, complex_8 _p_ w_, complex_8 _p_ w2_, 
complex_8 _p_ w3_, complex_8 _p_ d_, complex_8 _p_ tcos_, complex_8 _p_ p_)
{
  static int_4 mr_, nr_, nrm1_, j_, nrmj_, nrpj_, i_, ipstor_, lh_;
  static complex_8 s_, t_;
  int_4 $0_, $1_, $2_;
  mr_ = (*m_);
  nr_ = ((*n_) + 1) / 2;
  nrm1_ = nr_ - 1;
  if (2 * nr_ != (*n_)) {
    goto _l107;
  }
  for (j_ = 1; j_ <= nrm1_; (j_)++) {
    nrmj_ = nr_ - j_;
    nrpj_ = nr_ + j_;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      s_ = q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))];
      t_ = q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))] = s_;
      q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))] = t_;
    }
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((nr_ - 1))] = 2.0 * q_[i_ - 1 + ((*idimq_)) * ((nr_ - 1))];
    q_[i_ - 1 + ((*idimq_)) * (((*n_) - 1))] = 2.0 * q_[i_ - 1 + ((*idimq_)) * (((*n_) - 1))];
  }
  (void) _cmposd (&mr_, &nrm1_, &_k1, a_, bb_, c_, q_, idimq_, b_, w_, d_, tcos_, p_);
  ipstor_ = (real_4) (crealf (w_[0]));
  (void) _cmposn (&mr_, ($0_ = nr_ + 1, &$0_), &_k1, &_k1, a_, bb_, c_, &q_[0 + ((*idimq_)) * ((nr_ - 1))], idimq_, b_, 
  b2_, b3_, w_, w2_, w3_, d_, tcos_, p_);
  ipstor_ = _max (ipstor_, (int_4) (_aintd ((real_4) (crealf (w_[0])))));
  for (j_ = 1; j_ <= nrm1_; (j_)++) {
    nrmj_ = nr_ - j_;
    nrpj_ = nr_ + j_;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      s_ = .5 * (q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))]);
      t_ = .5 * (q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))]);
      q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))] = s_;
      q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))] = t_;
    }
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((nr_ - 1))] = .5 * q_[i_ - 1 + ((*idimq_)) * ((nr_ - 1))];
    q_[i_ - 1 + ((*idimq_)) * (((*n_) - 1))] = .5 * q_[i_ - 1 + ((*idimq_)) * (((*n_) - 1))];
  }
  goto _l118;
  _l107:;
  for (j_ = 1; j_ <= nrm1_; (j_)++) {
    nrpj_ = (*n_) + 1 - j_;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      s_ = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))];
      t_ = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = s_;
      q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))] = t_;
    }
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((nr_ - 1))] = 2.0 * q_[i_ - 1 + ((*idimq_)) * ((nr_ - 1))];
  }
  lh_ = nrm1_ / 2;
  for (j_ = 1; j_ <= lh_; (j_)++) {
    nrmj_ = nr_ - j_;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      s_ = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))] = s_;
    }
  }
  (void) _cmposd (&mr_, &nrm1_, ($1_ = 2, &$1_), a_, bb_, c_, q_, idimq_, b_, w_, d_, tcos_, p_);
  ipstor_ = (real_4) (crealf (w_[0]));
  (void) _cmposn (&mr_, &nr_, ($2_ = 2, &$2_), &_k1, a_, bb_, c_, &q_[0 + ((*idimq_)) * ((nr_ - 1))], idimq_, b_, b2_, 
  b3_, w_, w2_, w3_, d_, tcos_, p_);
  ipstor_ = _max (ipstor_, (int_4) (_aintd ((real_4) (crealf (w_[0])))));
  for (j_ = 1; j_ <= nrm1_; (j_)++) {
    nrpj_ = nr_ + j_;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      s_ = .5 * (q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))] + q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))]);
      t_ = .5 * (q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))] - q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))]);
      q_[i_ - 1 + ((*idimq_)) * ((nrpj_ - 1))] = t_;
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = s_;
    }
  }
  for (i_ = 1; i_ <= mr_; (i_)++) {
    q_[i_ - 1 + ((*idimq_)) * ((nr_ - 1))] = .5 * q_[i_ - 1 + ((*idimq_)) * ((nr_ - 1))];
  }
  for (j_ = 1; j_ <= lh_; (j_)++) {
    nrmj_ = nr_ - j_;
    for (i_ = 1; i_ <= mr_; (i_)++) {
      s_ = q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((j_ - 1))] = q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))];
      q_[i_ - 1 + ((*idimq_)) * ((nrmj_ - 1))] = s_;
    }
  }
  _l118:;
  w_[0] = CMPLXF ((real_4) (ipstor_), 0.0);
  __calls[30].calls++;
  return 0;
}

int_4 _cmptr3 (int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, complex_8 _p_ c_, int_4 _p_ k_, complex_8 _p_ y1_, 
complex_8 _p_ y2_, complex_8 _p_ y3_, complex_8 _p_ tcos_, complex_8 _p_ d_, complex_8 _p_ w1_, complex_8 _p_ w2_, 
complex_8 _p_ w3_)
{
  static int_4 k1p1_, k2p1_, k3p1_, k4p1_, mm1_, k1_, k2_, k3_, k4_, k2k3k4_, l1_, l2_, l3_, lint1_, lint2_, lint3_, 
  kint1_, kint2_, kint3_, n_, i_, ip_;
  static complex_8 x_, xx_, z_;
  mm1_ = (*m_) - 1;
  k1_ = k_[0];
  k2_ = k_[1];
  k3_ = k_[2];
  k4_ = k_[3];
  k1p1_ = k1_ + 1;
  k2p1_ = k2_ + 1;
  k3p1_ = k3_ + 1;
  k4p1_ = k4_ + 1;
  k2k3k4_ = k2_ + k3_ + k4_;
  if (k2k3k4_ == 0) {
    goto _l101;
  }
  l1_ = k1p1_ / k2p1_;
  l2_ = k1p1_ / k3p1_;
  l3_ = k1p1_ / k4p1_;
  lint1_ = 1;
  lint2_ = 1;
  lint3_ = 1;
  kint1_ = k1_;
  kint2_ = kint1_ + k2_;
  kint3_ = kint2_ + k3_;
  _l101:;
  for (n_ = 1; n_ <= k1_; (n_)++) {
    x_ = tcos_[n_ - 1];
    if (k2k3k4_ == 0) {
      goto _l107;
    }
    if (n_ != l1_) {
      goto _l103;
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      w1_[i_ - 1] = y1_[i_ - 1];
    }
    _l103:;
    if (n_ != l2_) {
      goto _l105;
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      w2_[i_ - 1] = y2_[i_ - 1];
    }
    _l105:;
    if (n_ != l3_) {
      goto _l107;
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      w3_[i_ - 1] = y3_[i_ - 1];
    }
    _l107:;
    z_ = 1.0 / (b_[0] - x_);
    d_[0] = c_[0] * z_;
    y1_[0] = y1_[0] * z_;
    y2_[0] = y2_[0] * z_;
    y3_[0] = y3_[0] * z_;
    for (i_ = 2; i_ <= (*m_); (i_)++) {
      z_ = 1.0 / (b_[i_ - 1] - x_ - a_[i_ - 1] * d_[i_ - 1 - 1]);
      d_[i_ - 1] = c_[i_ - 1] * z_;
      y1_[i_ - 1] = (y1_[i_ - 1] - a_[i_ - 1] * y1_[i_ - 1 - 1]) * z_;
      y2_[i_ - 1] = (y2_[i_ - 1] - a_[i_ - 1] * y2_[i_ - 1 - 1]) * z_;
      y3_[i_ - 1] = (y3_[i_ - 1] - a_[i_ - 1] * y3_[i_ - 1 - 1]) * z_;
    }
    for (ip_ = 1; ip_ <= mm1_; (ip_)++) {
      i_ = (*m_) - ip_;
      y1_[i_ - 1] = y1_[i_ - 1] - d_[i_ - 1] * y1_[i_ + 1 - 1];
      y2_[i_ - 1] = y2_[i_ - 1] - d_[i_ - 1] * y2_[i_ + 1 - 1];
      y3_[i_ - 1] = y3_[i_ - 1] - d_[i_ - 1] * y3_[i_ + 1 - 1];
    }
    if (k2k3k4_ == 0) {
      goto _l115;
    }
    if (n_ != l1_) {
      goto _l111;
    }
    i_ = lint1_ + kint1_;
    xx_ = x_ - tcos_[i_ - 1];
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y1_[i_ - 1] = xx_ * y1_[i_ - 1] + w1_[i_ - 1];
    }
    lint1_ = lint1_ + 1;
    l1_ = (lint1_ * k1p1_) / k2p1_;
    _l111:;
    if (n_ != l2_) {
      goto _l113;
    }
    i_ = lint2_ + kint2_;
    xx_ = x_ - tcos_[i_ - 1];
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y2_[i_ - 1] = xx_ * y2_[i_ - 1] + w2_[i_ - 1];
    }
    lint2_ = lint2_ + 1;
    l2_ = (lint2_ * k1p1_) / k3p1_;
    _l113:;
    if (n_ != l3_) {
      goto _l115;
    }
    i_ = lint3_ + kint3_;
    xx_ = x_ - tcos_[i_ - 1];
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y3_[i_ - 1] = xx_ * y3_[i_ - 1] + w3_[i_ - 1];
    }
    lint3_ = lint3_ + 1;
    l3_ = (lint3_ * k1p1_) / k4p1_;
    _l115:;
  }
  __calls[31].calls++;
  return 0;
}

int_4 _cmptrx (int_4 _p_ idegbr_, int_4 _p_ idegcr_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, complex_8 _p_ c_
, complex_8 _p_ y_, complex_8 _p_ tcos_, complex_8 _p_ d_, complex_8 _p_ w_)
{
  static int_4 kb_, kc_, mm1_, l_, lint_, k_, i_, ip_;
  static complex_8 x_, xx_, z_;
  mm1_ = (*m_) - 1;
  kb_ = (*idegbr_) + 1;
  kc_ = (*idegcr_) + 1;
  l_ = kb_ / kc_;
  lint_ = 1;
  for (k_ = 1; k_ <= (*idegbr_); (k_)++) {
    x_ = tcos_[k_ - 1];
    if (k_ != l_) {
      goto _l102;
    }
    i_ = (*idegbr_) + lint_;
    xx_ = x_ - tcos_[i_ - 1];
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      w_[i_ - 1] = y_[i_ - 1];
      y_[i_ - 1] = xx_ * y_[i_ - 1];
    }
    _l102:;
    z_ = 1.0 / (b_[0] - x_);
    d_[0] = c_[0] * z_;
    y_[0] = y_[0] * z_;
    for (i_ = 2; i_ <= mm1_; (i_)++) {
      z_ = 1.0 / (b_[i_ - 1] - x_ - a_[i_ - 1] * d_[i_ - 1 - 1]);
      d_[i_ - 1] = c_[i_ - 1] * z_;
      y_[i_ - 1] = (y_[i_ - 1] - a_[i_ - 1] * y_[i_ - 1 - 1]) * z_;
    }
    z_ = b_[(*m_) - 1] - x_ - a_[(*m_) - 1] * d_[mm1_ - 1];
    if (cabsf (z_) != 0.0) {
      goto _l104;
    }
    y_[(*m_) - 1] = CMPLXF (0.0, 0.0);
    goto _l105;
    _l104:;
    y_[(*m_) - 1] = (y_[(*m_) - 1] - a_[(*m_) - 1] * y_[mm1_ - 1]) / z_;
    _l105:;
    for (ip_ = 1; ip_ <= mm1_; (ip_)++) {
      i_ = (*m_) - ip_;
      y_[i_ - 1] = y_[i_ - 1] - d_[i_ - 1] * y_[i_ + 1 - 1];
    }
    if (k_ != l_) {
      goto _l108;
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      y_[i_ - 1] = y_[i_ - 1] + w_[i_ - 1];
    }
    lint_ = lint_ + 1;
    l_ = (lint_ * kb_) / kc_;
    _l108:;
  }
  __calls[32].calls++;
  return 0;
}

int_4 _cnbco (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, real_4 
_p_ rcond_, complex_8 _p_ z_)
{
  static int_4 i_, info_, j_, ju_, k_, kb_, kp1_, l_, ldb_, lm_, lz_, m_, ml1_, mm_, nl_, nu_;
  static real_4 anorm_, s_, sm_, ynorm_;
  static complex_8 ek_, t_, wk_, wkm_, zdum_, zdum1_, zdum2_;
  int_4 $0_, $1_, $2_;
  extern complex_8 _cdotc ();
  extern real_4 _scasum ();
  ml1_ = (*ml_) + 1;
  ldb_ = (*lda_) - 1;
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    nu_ = _min ((*mu_), j_ - 1);
    nl_ = _min ((*ml_), (*n_) - j_);
    l_ = 1 + nu_ + nl_;
    anorm_ = _max (anorm_, _scasum (&l_, &abe_[j_ + nl_ - 1 + ((*lda_)) * ((ml1_ - nl_ - 1))], &ldb_));
  }
  (void) _cnbfa (abe_, lda_, n_, ml_, mu_, ipvt_, &info_);
  ek_ = CMPLXF (1.0, 0.0);
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    z_[j_ - 1] = CMPLXF (0.0, 0.0);
  }
  m_ = (*ml_) + (*mu_) + 1;
  ju_ = 0;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) != 0.0e0) {
    ek_ = ({complex_8 zdum1__1_ = ek_; complex_8 zdum2__1_ = -z_[k_ - 1]; ({complex_8 zdum__2_ = zdum1__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}) * (zdum2__1_ / ({complex_8 zdum__2_ = zdum2__1_; _abs ((real_4) 
    (crealf (zdum__2_))) + _abs (cimagf (zdum__2_));}));});
  }
  if (({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 
  ({complex_8 zdum__1_ = abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
  (zdum__1_));})) {
  goto _l30;
}

s_ = ({complex_8 zdum__1_ = abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = ek_ - z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ek_ = CMPLXF (s_, 0.0) * ek_;
_l30:;
wk_ = ek_ - z_[k_ - 1];
wkm_ = -ek_ - z_[k_ - 1];
s_ = ({complex_8 zdum__1_ = wk_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
sm_ = ({complex_8 zdum__1_ = wkm_; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
if (({complex_8 zdum__1_ = abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
goto _l40;
}
wk_ = wk_ / conjf (abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]);
wkm_ = wkm_ / conjf (abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]);
goto _l50;
_l40:;
wk_ = CMPLXF (1.0, 0.0);
wkm_ = CMPLXF (1.0, 0.0);
_l50:;
kp1_ = k_ + 1;
ju_ = _min (_max (ju_, (*mu_) + ipvt_[k_ - 1]), (*n_));
mm_ = ml1_;
if (kp1_ > ju_) {
  goto _l90;
}

for (i_ = kp1_; i_ <= ju_; (i_)++) {
  mm_ = mm_ + 1;
  sm_ = sm_ + ({complex_8 zdum__1_ = z_[i_ - 1] + wkm_ * conjf (abe_[k_ - 1 + ((*lda_)) * ((mm_ - 1))]); _abs ((real_4) 
  (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
  z_[i_ - 1] = z_[i_ - 1] + wk_ * conjf (abe_[k_ - 1 + ((*lda_)) * ((mm_ - 1))]);
  s_ = s_ + ({complex_8 zdum__1_ = z_[i_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
}

if (s_ >= sm_) {
  goto _l80;
}

t_ = wkm_ - wk_;
wk_ = wkm_;
mm_ = ml1_;
for (i_ = kp1_; i_ <= ju_; (i_)++) {
  mm_ = mm_ + 1;
  z_[i_ - 1] = z_[i_ - 1] + t_ * conjf (abe_[k_ - 1 + ((*lda_)) * ((mm_ - 1))]);
}

_l80:;
_l90:;
z_[k_ - 1] = wk_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  nl_ = _min ((*ml_), (*n_) - k_);
  if (k_ < (*n_)) {
    z_[k_ - 1] = z_[k_ - 1] + _cdotc (&nl_, &abe_[k_ + nl_ - 1 + ((*lda_)) * ((ml1_ - nl_ - 1))], ($0_ = -ldb_, &$0_), 
    &z_[k_ + 1 - 1], &_k1);
  }
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 1.0e0) {
  goto _l110;
}

s_ = 1.0e0 / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
_l110:;
l_ = ipvt_[k_ - 1];
t_ = z_[l_ - 1];
z_[l_ - 1] = z_[k_ - 1];
z_[k_ - 1] = t_;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = 1.0;
for (k_ = 1; k_ <= (*n_); (k_)++) {
  l_ = ipvt_[k_ - 1];
  t_ = z_[l_ - 1];
  z_[l_ - 1] = z_[k_ - 1];
  z_[k_ - 1] = t_;
  nl_ = _min ((*ml_), (*n_) - k_);
  if (k_ < (*n_)) {
    (void) _caxpy (&nl_, &t_, &abe_[k_ + nl_ - 1 + ((*lda_)) * ((ml1_ - nl_ - 1))], ($1_ = -ldb_, &$1_), &z_[k_ + 1 - 1], 
    &_k1);
  }
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= 1.0e0) {
  goto _l130;
}

s_ = 1.0e0 / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l130:;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
  k_ = (*n_) + 1 - kb_;
  if (({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) <= ({complex_8 
  zdum__1_ = abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));})) 
  {
  goto _l150;
}

s_ = ({complex_8 zdum__1_ = abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) / ({complex_8 zdum__1_ = z_[k_ - 1]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));});
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
_l150:;
if (({complex_8 zdum__1_ = abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) != 0.0e0) {
z_[k_ - 1] = z_[k_ - 1] / abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))];
}

if (({complex_8 zdum__1_ = abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
(zdum__1_));}) == 0.0e0) {
z_[k_ - 1] = 1.0;
}

lm_ = _min (k_, m_) - 1;
lz_ = k_ - lm_;
t_ = -z_[k_ - 1];
(void) _caxpy (&lm_, &t_, &abe_[k_ - 1 - 1 + ((*lda_)) * (((*ml_) + 2 - 1))], ($2_ = -ldb_, &$2_), &z_[lz_ - 1], &_k1)
;
}

s_ = 1.0e0 / _scasum (n_, z_, &_k1);
(void) _csscal (n_, &s_, z_, &_k1);
ynorm_ = s_ * ynorm_;
if (anorm_ != 0.0e0) {
  (*rcond_) = ynorm_ / anorm_;
}

if (anorm_ == 0.0e0) {
  (*rcond_) = 0.0;
}

__calls[33].calls++;
return 0;
}

int_4 _cnbdi (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
complex_8 _p_ det_)
{
  static int_4 i_;
  static real_4 ten_;
  static complex_8 zdum_;
  det_[0] = CMPLXF (1.0, 0.0);
  det_[1] = CMPLXF (0.0, 0.0);
  ten_ = 10.0;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (ipvt_[i_ - 1] != i_) {
      det_[0] = -det_[0];
    }
    det_[0] = abe_[i_ - 1 + ((*lda_)) * (((*ml_) + 1 - 1))] * det_[0];
    if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) == 0.0e0) {
    goto _l60;
  }
  _l10:;
  if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) >= 1.0e0) {
  goto _l20;
}

det_[0] = CMPLXF (ten_, 0.0) * det_[0];
det_[1] = det_[1] - CMPLXF (1.0, 0.0);
goto _l10;
_l20:;
_l30:;
if (({complex_8 zdum__1_ = det_[0]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf (zdum__1_));}) < ten_) {
goto _l40;
}

det_[0] = det_[0] / CMPLXF (ten_, 0.0);
det_[1] = det_[1] + CMPLXF (1.0, 0.0);
goto _l30;
_l40:;
}

_l60:;
__calls[34].calls++;
return 0;
}

int_4 _cnbfa (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, int_4 
_p_ info_)
{
  static int_4 ml1_, mb_, m_, n1_, ldb_, i_, j_, k_, l_, lm_, lm1_, lm2_, mp_;
  static complex_8 t_, zdum_;
  int_4 $0_;
  extern int_4 _icamax ();
  ml1_ = (*ml_) + 1;
  mb_ = (*ml_) + (*mu_);
  m_ = (*ml_) + (*mu_) + 1;
  n1_ = (*n_) - 1;
  ldb_ = (*lda_) - 1;
  (*info_) = 0;
  if ((*n_) <= 1) {
    goto _l50;
  }
  if ((*ml_) <= 0) {
    goto _l7;
  }
  for (j_ = 1; j_ <= (*ml_); (j_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      abe_[i_ - 1 + ((*lda_)) * ((m_ + j_ - 1))] = CMPLXF (0.0, 0.0);
    }
  }
  _l7:;
  for (k_ = 1; k_ <= n1_; (k_)++) {
    lm_ = _min ((*n_) - k_, (*ml_));
    lm1_ = lm_ + 1;
    lm2_ = ml1_ - lm_;
    l_ = -_icamax (&lm1_, &abe_[lm_ + k_ - 1 + ((*lda_)) * ((lm2_ - 1))], &ldb_) + lm1_ + k_;
    ipvt_[k_ - 1] = l_;
    mp_ = _min (mb_, (*n_) - k_);
    if (l_ != k_) {
      (void) _cswap (($0_ = mp_ + 1, &$0_), &abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))], lda_, &abe_[l_ - 1 + ((*lda_)) * ((ml1_ 
      + k_ - l_ - 1))], lda_);
    }
    if (({complex_8 zdum__1_ = abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs (cimagf 
    (zdum__1_));}) == 0.0e0) {
    goto _l20;
  }
  t_ = -CMPLXF (1.0, 0.0) / abe_[k_ - 1 + ((*lda_)) * ((ml1_ - 1))];
  (void) _cscal (&lm_, &t_, &abe_[lm_ + k_ - 1 + ((*lda_)) * ((lm2_ - 1))], &ldb_);
  for (j_ = 1; j_ <= mp_; (j_)++) {
    (void) _caxpy (&lm_, &abe_[k_ - 1 + ((*lda_)) * ((ml1_ + j_ - 1))], &abe_[lm_ + k_ - 1 + ((*lda_)) * ((lm2_ - 1))], 
    &ldb_, &abe_[lm_ + k_ - 1 + ((*lda_)) * ((lm2_ + j_ - 1))], &ldb_);
  }
  goto _l30;
  _l20:;
  (*info_) = k_;
  _l30:;
}

_l50:;
ipvt_[(*n_) - 1] = (*n_);
if (({complex_8 zdum__1_ = abe_[(*n_) - 1 + ((*lda_)) * ((ml1_ - 1))]; _abs ((real_4) (crealf (zdum__1_))) + _abs 
(cimagf (zdum__1_));}) == 0.0e0) {
(*info_) = (*n_);
}

__calls[35].calls++;
return 0;
}

int_4 _cnbfs (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, complex_8 _p_ v_, int_4 
_p_ itask_, int_4 _p_ ind_, complex_8 _p_ work_, int_4 _p_ iwork_)
{
  static real_4 rcond_;
  static char_15 xern1_, xern2_;
  int_4 __fcnt, __rc, $7_, $11_, $15_, $19_, $20_, $21_, $22_;
  char_31 $0_, $4_, $8_, $12_, $16_;
  char_63 $1_, $5_, $6_, $9_, $10_, $13_, $14_, $17_, $18_;
  char_127 $2_, $3_;
  extern real_4 _r1mach ();
  static FORMAT $f_100009_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100010_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100016_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100028_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100034_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*lda_) < (*n_)) {
    (*ind_) = -1;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbfs:182", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:182", 0));
      __fcnt += 3;
    }
    if ($f_100009_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:182", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100009_[__fcnt + 2], &(*lda_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:182", 0));
    __fcnt += 3;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      if ($f_100009_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:182", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbfs:183", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:183", 0));
      __fcnt += 3;
    }
    if ($f_100010_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:183", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100010_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:183", 0));
    __fcnt += 3;
    while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
      if ($f_100010_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:183", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_37, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_27, xern1_), _dc_28), xern2_), 
    127), $3_), &_km1, &_k1);
    goto _l0;
  }
  if ((*n_) <= 0) {
    (*ind_) = -2;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbfs:191", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:191", 0));
      __fcnt += 3;
    }
    if ($f_100016_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:191", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100016_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:191", 0));
    __fcnt += 3;
    while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
      if ($f_100016_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:191", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_37, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_29, xern1_), _dc_30), 63), $6_), ($7_ = -2, 
    &$7_), &_k1);
    goto _l0;
  }
  if ((*itask_) < 1) {
    (*ind_) = -3;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbfs:199", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:199", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:199", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*itask_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:199", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:199", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_37, (bufcpy ($10_, concat ($9_, concat ($8_, _dc_31, xern1_), _dc_30), 63), $10_), ($11_ = 
    -3, &$11_), &_k1);
    goto _l0;
  }
  if ((*ml_) < 0 || (*ml_) >= (*n_)) {
    (*ind_) = -5;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbfs:207", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100028_[__fcnt] != NULL && $f_100028_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100028_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:207", 0));
      __fcnt += 3;
    }
    if ($f_100028_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100028_[__fcnt] != NULL && $f_100028_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100028_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:207", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100028_[__fcnt + 2], &(*ml_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:207", 0));
    __fcnt += 3;
    while ($f_100028_[__fcnt] != NULL && $f_100028_[__fcnt] == FMT_TEXT) {
      if ($f_100028_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100028_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:207", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_37, (bufcpy ($14_, concat ($13_, concat ($12_, _dc_38, xern1_), _dc_39), 63), $14_), ($15_ = 
    -5, &$15_), &_k1);
    goto _l0;
  }
  if ((*mu_) < 0 || (*mu_) >= (*n_)) {
    (*ind_) = -6;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbfs:215", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100034_[__fcnt] != NULL && $f_100034_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100034_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:215", 0));
      __fcnt += 3;
    }
    if ($f_100034_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100034_[__fcnt] != NULL && $f_100034_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100034_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:215", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100034_[__fcnt + 2], &(*mu_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:215", 0));
    __fcnt += 3;
    while ($f_100034_[__fcnt] != NULL && $f_100034_[__fcnt] == FMT_TEXT) {
      if ($f_100034_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100034_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbfs:215", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_37, (bufcpy ($18_, concat ($17_, concat ($16_, _dc_40, xern1_), _dc_39), 63), $18_), ($19_ = 
    -6, &$19_), &_k1);
    goto _l0;
  }
  if ((*itask_) == 1) {
    (void) _cnbco (abe_, lda_, n_, ml_, mu_, iwork_, &rcond_, work_);
    if (rcond_ == 0.0) {
      (*ind_) = -4;
      (void) _xermsg (_dc_1, _dc_37, _dc_32, ($20_ = -4, &$20_), &_k1);
      goto _l0;
    }
    (*ind_) = -log10f (_r1mach (($21_ = 4, &$21_)) / rcond_);
    if ((*ind_) <= 0) {
      (*ind_) = -10;
      (void) _xermsg (_dc_1, _dc_37, _dc_33, ($22_ = -10, &$22_), &_k0);
    }
  }
  (void) _cnbsl (abe_, lda_, n_, ml_, mu_, iwork_, v_, &_k0);
  _l0:;
  __calls[36].calls++;
  return 0;
}

int_4 _cnbir (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, complex_8 _p_ v_, int_4 
_p_ itask_, int_4 _p_ ind_, complex_8 _p_ work_, int_4 _p_ iwork_)
{
  static int_4 info_, j_, k_, kk_, l_, m_, nc_;
  static real_4 xnorm_, dnorm_;
  static char_15 xern1_, xern2_;
  int_4 __fcnt, __rc, $7_, $11_, $15_, $19_, $20_, $22_, $23_;
  complex_8 $21_;
  char_31 $0_, $4_, $8_, $12_, $16_;
  char_63 $1_, $5_, $6_, $9_, $10_, $13_, $14_, $17_, $18_;
  char_127 $2_, $3_;
  extern complex_8 _cdcdot ();
  extern real_4 _scasum ();
  extern real_4 _r1mach ();
  static FORMAT $f_100008_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100009_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100015_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100021_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100027_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100033_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*lda_) < (*n_)) {
    (*ind_) = -1;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbir:182", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:182", 0));
      __fcnt += 3;
    }
    if ($f_100008_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:182", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100008_[__fcnt + 2], &(*lda_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:182", 0));
    __fcnt += 3;
    while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
      if ($f_100008_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:182", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbir:183", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:183", 0));
      __fcnt += 3;
    }
    if ($f_100009_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:183", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100009_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:183", 0));
    __fcnt += 3;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      if ($f_100009_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:183", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_41, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_27, xern1_), _dc_28), xern2_), 
    127), $3_), &_km1, &_k1);
    goto _l0;
  }
  if ((*n_) <= 0) {
    (*ind_) = -2;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbir:191", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:191", 0));
      __fcnt += 3;
    }
    if ($f_100015_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:191", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100015_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:191", 0));
    __fcnt += 3;
    while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
      if ($f_100015_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:191", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_41, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_29, xern1_), _dc_30), 63), $6_), ($7_ = -2, 
    &$7_), &_k1);
    goto _l0;
  }
  if ((*itask_) < 1) {
    (*ind_) = -3;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbir:199", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:199", 0));
      __fcnt += 3;
    }
    if ($f_100021_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:199", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100021_[__fcnt + 2], &(*itask_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:199", 0));
    __fcnt += 3;
    while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
      if ($f_100021_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:199", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_41, (bufcpy ($10_, concat ($9_, concat ($8_, _dc_31, xern1_), _dc_30), 63), $10_), ($11_ = 
    -3, &$11_), &_k1);
    goto _l0;
  }
  if ((*ml_) < 0 || (*ml_) >= (*n_)) {
    (*ind_) = -5;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbir:207", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:207", 0));
      __fcnt += 3;
    }
    if ($f_100027_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:207", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100027_[__fcnt + 2], &(*ml_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:207", 0));
    __fcnt += 3;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      if ($f_100027_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:207", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_41, (bufcpy ($14_, concat ($13_, concat ($12_, _dc_38, xern1_), _dc_39), 63), $14_), ($15_ = 
    -5, &$15_), &_k1);
    goto _l0;
  }
  if ((*mu_) < 0 || (*mu_) >= (*n_)) {
    (*ind_) = -6;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cnbir:215", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:215", 0));
      __fcnt += 3;
    }
    if ($f_100033_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:215", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100033_[__fcnt + 2], &(*mu_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:215", 0));
    __fcnt += 3;
    while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
      if ($f_100033_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cnbir:215", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_41, (bufcpy ($18_, concat ($17_, concat ($16_, _dc_40, xern1_), _dc_39), 63), $18_), ($19_ = 
    -6, &$19_), &_k1);
    goto _l0;
  }
  nc_ = 2 * (*ml_) + (*mu_) + 1;
  if ((*itask_) == 1) {
    m_ = (*ml_) + (*mu_) + 1;
    for (j_ = 1; j_ <= m_; (j_)++) {
      (void) _ccopy (n_, &abe_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &work_[0 + ((*n_)) * ((j_ - 1))], &_k1);
    }
    (void) _cnbfa (work_, n_, n_, ml_, mu_, iwork_, &info_);
    if (info_ != 0) {
      (*ind_) = -4;
      (void) _xermsg (_dc_1, _dc_41, _dc_32, ($20_ = -4, &$20_), &_k1);
      goto _l0;
    }
  }
  (void) _ccopy (n_, &v_[0], &_k1, &work_[0 + ((*n_)) * ((nc_ + 1 - 1))], &_k1);
  (void) _cnbsl (work_, n_, n_, ml_, mu_, iwork_, v_, &_k0);
  xnorm_ = _scasum (n_, &v_[0], &_k1);
  if (xnorm_ == 0.0) {
    (*ind_) = 75;
    goto _l0;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    k_ = _max (1, (*ml_) + 2 - j_);
    kk_ = _max (1, j_ - (*ml_));
    l_ = _min (j_ - 1, (*ml_)) + _min ((*n_) - j_, (*mu_)) + 1;
    work_[j_ - 1 + ((*n_)) * ((nc_ + 1 - 1))] = _cdcdot (&l_, ($21_ = -work_[j_ - 1 + ((*n_)) * ((nc_ + 1 - 1))], &$21_), 
    &abe_[j_ - 1 + ((*lda_)) * ((k_ - 1))], lda_, &v_[kk_ - 1], &_k1);
  }
  (void) _cnbsl (work_, n_, n_, ml_, mu_, iwork_, &work_[0 + ((*n_)) * ((nc_ + 1 - 1))], &_k0);
  dnorm_ = _scasum (n_, &work_[0 + ((*n_)) * ((nc_ + 1 - 1))], &_k1);
  (*ind_) = -log10f (_max (_r1mach (($22_ = 4, &$22_)), dnorm_ / xnorm_));
  if ((*ind_) <= 0) {
    (*ind_) = -10;
    (void) _xermsg (_dc_1, _dc_41, _dc_33, ($23_ = -10, &$23_), &_k0);
  }
  _l0:;
  __calls[37].calls++;
  return 0;
}

int_4 _cnbsl (complex_8 _p_ abe_, int_4 _p_ lda_, int_4 _p_ n_, int_4 _p_ ml_, int_4 _p_ mu_, int_4 _p_ ipvt_, 
complex_8 _p_ b_, int_4 _p_ job_)
{
  static int_4 k_, kb_, l_, lb_, ldb_, lm_, m_, mlm_, nm1_;
  static complex_8 t_;
  extern complex_8 _cdotc ();
  m_ = (*mu_) + (*ml_) + 1;
  nm1_ = (*n_) - 1;
  ldb_ = 1 - (*lda_);
  if ((*job_) != 0) {
    goto _l50;
  }
  if ((*ml_) == 0) {
    goto _l30;
  }
  if (nm1_ < 1) {
    goto _l30;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    lm_ = _min ((*ml_), (*n_) - k_);
    l_ = ipvt_[k_ - 1];
    t_ = b_[l_ - 1];
    if (l_ == k_) {
      goto _l10;
    }
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l10:;
    mlm_ = (*ml_) - (lm_ - 1);
    (void) _caxpy (&lm_, &t_, &abe_[k_ + lm_ - 1 + ((*lda_)) * ((mlm_ - 1))], &ldb_, &b_[k_ + 1 - 1], &_k1);
  }
  _l30:;
  for (kb_ = 1; kb_ <= (*n_); (kb_)++) {
    k_ = (*n_) + 1 - kb_;
    b_[k_ - 1] = b_[k_ - 1] / abe_[k_ - 1 + ((*lda_)) * (((*ml_) + 1 - 1))];
    lm_ = _min (k_, m_) - 1;
    lb_ = k_ - lm_;
    t_ = -b_[k_ - 1];
    (void) _caxpy (&lm_, &t_, &abe_[k_ - 1 - 1 + ((*lda_)) * (((*ml_) + 2 - 1))], &ldb_, &b_[lb_ - 1], &_k1);
  }
  goto _l100;
  _l50:;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    lm_ = _min (k_, m_) - 1;
    lb_ = k_ - lm_;
    t_ = _cdotc (&lm_, &abe_[k_ - 1 - 1 + ((*lda_)) * (((*ml_) + 2 - 1))], &ldb_, &b_[lb_ - 1], &_k1);
    b_[k_ - 1] = (b_[k_ - 1] - t_) / conjf (abe_[k_ - 1 + ((*lda_)) * (((*ml_) + 1 - 1))]);
  }
  if ((*ml_) == 0) {
    goto _l90;
  }
  if (nm1_ < 1) {
    goto _l90;
  }
  for (kb_ = 1; kb_ <= nm1_; (kb_)++) {
    k_ = (*n_) - kb_;
    lm_ = _min ((*ml_), (*n_) - k_);
    mlm_ = (*ml_) - (lm_ - 1);
    b_[k_ - 1] = b_[k_ - 1] + _cdotc (&lm_, &abe_[k_ + lm_ - 1 + ((*lda_)) * ((mlm_ - 1))], &ldb_, &b_[k_ + 1 - 1], &_k1);
    l_ = ipvt_[k_ - 1];
    if (l_ == k_) {
      goto _l70;
    }
    t_ = b_[l_ - 1];
    b_[l_ - 1] = b_[k_ - 1];
    b_[k_ - 1] = t_;
    _l70:;
  }
  _l90:;
  _l100:;
  __calls[38].calls++;
  return 0;
}

int_4 _compb (int_4 _p_ n_, int_4 _p_ ierror_, real_4 _p_ an_, real_4 _p_ bn_, real_4 _p_ cn_, real_4 _p_ b_, real_4 
_p_ ah_, real_4 _p_ bh_)
{
  static int_4 j_, if_, kdo_, l_, ir_, i2_, i4_, ipl_, ifd_, i_, ib_, nb_, js_, jf_, ls_, lh_, nmp_, l1_, l2_, j2_, j1_, 
  n2m2_;
  static real_4 bnorm_, arg_, d1_, d2_, d3_;
  int_4 $0_, $2_, $3_, $4_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_;
  real_4 $1_, $5_;
  extern real_4 _r1mach ();
  cblkt_.eps_ = _r1mach (($0_ = 4, &$0_));
  bnorm_ = _abs (bn_[0]);
  for (j_ = 2; j_ <= cblkt_.nm_; (j_)++) {
    bnorm_ = _max (bnorm_, _abs (bn_[j_ - 1]));
    arg_ = an_[j_ - 1] * cn_[j_ - 1 - 1];
    $1_ = arg_;
    if ($1_ < 0) {
      goto _l119;
    } else if ($1_ == 0) {
      goto _l101;
    } else {
      goto _l101;
    }
    _l101:;
    b_[j_ - 1] = _sign (sqrtf (arg_), an_[j_ - 1]);
  }
  cblkt_.cnv_ = cblkt_.eps_ * bnorm_;
  if_ = _up_int_4 (2, cblkt_.k_);
  kdo_ = cblkt_.k_ - 1;
  for (l_ = 1; l_ <= kdo_; (l_)++) {
    ir_ = l_ - 1;
    i2_ = _up_int_4 (2, ir_);
    i4_ = i2_ + i2_;
    ipl_ = i4_ - 1;
    ifd_ = if_ - i4_;
    for (i_ = i4_; (i4_ > 0 ? i_ <= ifd_ : i_ >= ifd_); i_ += i4_) {
      (void) _indxb (&i_, &l_, &ib_, &nb_);
      $2_ = nb_;
      if ($2_ < 0) {
        goto _l108;
      } else if ($2_ == 0) {
        goto _l108;
      } else {
        goto _l103;
      }
      _l103:;
      js_ = i_ - ipl_;
      jf_ = js_ + nb_ - 1;
      ls_ = 0;
      for (j_ = js_; j_ <= jf_; (j_)++) {
        ls_ = ls_ + 1;
        bh_[ls_ - 1] = bn_[j_ - 1];
        ah_[ls_ - 1] = b_[j_ - 1];
      }
      (void) _tevls (&nb_, bh_, ah_, ierror_);
      $3_ = (*ierror_);
      if ($3_ < 0) {
        goto _l118;
      } else if ($3_ == 0) {
        goto _l105;
      } else {
        goto _l118;
      }
      _l105:;
      lh_ = ib_ - 1;
      for (j_ = 1; j_ <= nb_; (j_)++) {
        lh_ = lh_ + 1;
        b_[lh_ - 1] = -bh_[j_ - 1];
      }
    }
    _l108:;
  }
  for (j_ = 1; j_ <= cblkt_.nm_; (j_)++) {
    b_[j_ - 1] = -bn_[j_ - 1];
  }
  $4_ = cblkt_.npp_;
  if ($4_ < 0) {
    goto _l117;
  } else if ($4_ == 0) {
    goto _l110;
  } else {
    goto _l117;
  }
  _l110:;
  nmp_ = cblkt_.nm_ + 1;
  nb_ = cblkt_.nm_ + nmp_;
  for (j_ = 1; j_ <= nb_; (j_)++) {
    l1_ = _imod (j_ - 1, nmp_) + 1;
    l2_ = _imod (j_ + cblkt_.nm_ - 1, nmp_) + 1;
    arg_ = an_[l1_ - 1] * cn_[l2_ - 1];
    $5_ = arg_;
    if ($5_ < 0) {
      goto _l119;
    } else if ($5_ == 0) {
      goto _l111;
    } else {
      goto _l111;
    }
    _l111:;
    bh_[j_ - 1] = _sign (sqrtf (arg_), -an_[l1_ - 1]);
    ah_[j_ - 1] = -bn_[l1_ - 1];
  }
  (void) _tevls (&nb_, ah_, bh_, ierror_);
  $6_ = (*ierror_);
  if ($6_ < 0) {
    goto _l118;
  } else if ($6_ == 0) {
    goto _l113;
  } else {
    goto _l118;
  }
  _l113:;
  (void) _indxb (&if_, ($7_ = cblkt_.k_ - 1, &$7_), &j2_, &lh_);
  (void) _indxb (($8_ = if_ / 2, &$8_), ($9_ = cblkt_.k_ - 1, &$9_), &j1_, &lh_);
  j2_ = j2_ + 1;
  lh_ = j2_;
  n2m2_ = j2_ + cblkt_.nm_ + cblkt_.nm_ - 2;
  _l114:;
  d1_ = _abs (b_[j1_ - 1] - b_[j2_ - 1 - 1]);
  d2_ = _abs (b_[j1_ - 1] - b_[j2_ - 1]);
  d3_ = _abs (b_[j1_ - 1] - b_[j2_ + 1 - 1]);
  if ((d2_ < d1_) && (d2_ < d3_)) {
    goto _l115;
  }
  b_[lh_ - 1] = b_[j2_ - 1];
  j2_ = j2_ + 1;
  lh_ = lh_ + 1;
  $10_ = j2_ - n2m2_;
  if ($10_ < 0) {
    goto _l114;
  } else if ($10_ == 0) {
    goto _l114;
  } else {
    goto _l116;
  }
  _l115:;
  j2_ = j2_ + 1;
  j1_ = j1_ + 1;
  $11_ = j2_ - n2m2_;
  if ($11_ < 0) {
    goto _l114;
  } else if ($11_ == 0) {
    goto _l114;
  } else {
    goto _l116;
  }
  _l116:;
  b_[lh_ - 1] = b_[n2m2_ + 1 - 1];
  (void) _indxb (&if_, ($12_ = cblkt_.k_ - 1, &$12_), &j1_, &j2_);
  j2_ = j1_ + nmp_ + nmp_;
  (void) _ppadd (($13_ = cblkt_.nm_ + 1, &$13_), ierror_, an_, cn_, &b_[j1_ - 1], &b_[j1_ - 1], &b_[j2_ - 1]);
  _l117:;
  goto _l0;
  _l118:;
  (*ierror_) = 4;
  goto _l0;
  _l119:;
  (*ierror_) = 5;
  _l0:;
  __calls[39].calls++;
  return 0;
}

int_4 _cosgen (int_4 _p_ n_, int_4 _p_ ijump_, real_4 _p_ fnum_, real_4 _p_ fden_, real_4 _p_ a_)
{
  static int_4 k3_, k4_, k_, k1_, k5_, i_, k2_, np1_;
  static real_4 pi_, dum_, pibyn_, x_, y_;
  pi_ = _pimach (&dum_);
  if ((*n_) == 0) {
    goto _l105;
  }
  if ((*ijump_) == 1) {
    goto _l103;
  }
  k3_ = (*n_) / (*ijump_) + 1;
  k4_ = k3_ - 1;
  pibyn_ = pi_ / ((*n_) + (*ijump_));
  for (k_ = 1; k_ <= (*ijump_); (k_)++) {
    k1_ = (k_ - 1) * k3_;
    k5_ = (k_ - 1) * k4_;
    for (i_ = 1; i_ <= k4_; (i_)++) {
      x_ = k1_ + i_;
      k2_ = k5_ + i_;
      a_[k2_ - 1] = -2.0 * cosf (x_ * pibyn_);
    }
  }
  goto _l105;
  _l103:;
  np1_ = (*n_) + 1;
  y_ = pi_ / ((*n_) + (*fden_));
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    x_ = np1_ - i_ - (*fnum_);
    a_[i_ - 1] = 2.0 * cosf (x_ * y_);
  }
  _l105:;
  __calls[40].calls++;
  return 0;
}

int_4 _cpadd (int_4 _p_ n_, int_4 _p_ ierror_, real_4 _p_ a_, real_4 _p_ c_, complex_8 _p_ cbp_, real_4 _p_ bp_, real_4 
_p_ bh_)
{
  static int_4 iz_, j_, nt_, modiz_, is_, if_, ig_, it_, icv_, i3_, nhalf_;
  static real_4 scnv_, xl_, db_, sgn_, xr_, xm_, psg_;
  static complex_8 cx_, fsg_, hsg_, dd_, f_, fp_, fpp_, cdis_, r1_, r2_, r3_;
  int_4 $1_, $4_, $9_, $13_, $14_;
  real_4 $0_, $2_, $3_, $5_, $6_, $7_, $8_, $10_, $11_, $12_, $15_, $16_;
  scnv_ = sqrtf (ccblk_.cnv_);
  iz_ = (*n_);
  $0_ = bp_[(*n_) - 1] - bp_[0];
  if ($0_ < 0) {
    goto _l101;
  } else if ($0_ == 0) {
    goto _l142;
  } else {
    goto _l103;
  }
  _l101:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    nt_ = (*n_) - j_;
    bh_[j_ - 1] = bp_[nt_ + 1 - 1];
  }
  goto _l105;
  _l103:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    bh_[j_ - 1] = bp_[j_ - 1];
  }
  _l105:;
  ccblk_.ncmplx_ = 0;
  modiz_ = _imod (iz_, 2);
  is_ = 1;
  $1_ = modiz_;
  if ($1_ < 0) {
    goto _l106;
  } else if ($1_ == 0) {
    goto _l107;
  } else {
    goto _l106;
  }
  _l106:;
  $2_ = a_[0];
  if ($2_ < 0) {
    goto _l110;
  } else if ($2_ == 0) {
    goto _l142;
  } else {
    goto _l107;
  }
  _l107:;
  xl_ = bh_[0];
  db_ = bh_[2] - bh_[0];
  _l108:;
  xl_ = xl_ - db_;
  $3_ = _pgsf (&xl_, &iz_, c_, a_, bh_);
  if ($3_ < 0) {
    goto _l108;
  } else if ($3_ == 0) {
    goto _l108;
  } else {
    goto _l109;
  }
  _l109:;
  sgn_ = -1.0;
  cbp_[0] = CMPLXF (_bcrh (&xl_, &bh_[0], &iz_, c_, a_, bh_, _pgsf, &sgn_), 0.0);
  is_ = 2;
  _l110:;
  if_ = iz_ - 1;
  $4_ = modiz_;
  if ($4_ < 0) {
    goto _l111;
  } else if ($4_ == 0) {
    goto _l112;
  } else {
    goto _l111;
  }
  _l111:;
  $5_ = a_[0];
  if ($5_ < 0) {
    goto _l112;
  } else if ($5_ == 0) {
    goto _l142;
  } else {
    goto _l115;
  }
  _l112:;
  xr_ = bh_[iz_ - 1];
  db_ = bh_[iz_ - 1] - bh_[iz_ - 2 - 1];
  _l113:;
  xr_ = xr_ + db_;
  $6_ = _pgsf (&xr_, &iz_, c_, a_, bh_);
  if ($6_ < 0) {
    goto _l113;
  } else if ($6_ == 0) {
    goto _l114;
  } else {
    goto _l114;
  }
  _l114:;
  sgn_ = 1.0;
  cbp_[iz_ - 1] = CMPLXF (_bcrh (&bh_[iz_ - 1], &xr_, &iz_, c_, a_, bh_, _pgsf, &sgn_), 0.0);
  if_ = iz_ - 2;
  _l115:;
  for (ig_ = is_; (2 > 0 ? ig_ <= if_ : ig_ >= if_); ig_ += 2) {
    xl_ = bh_[ig_ - 1];
    xr_ = bh_[ig_ + 1 - 1];
    sgn_ = -1.0;
    xm_ = _bcrh (&xl_, &xr_, &iz_, c_, a_, bh_, _pppsf, &sgn_);
    psg_ = _pgsf (&xm_, &iz_, c_, a_, bh_);
    $7_ = _abs (psg_) - ccblk_.eps_;
    if ($7_ < 0) {
      goto _l118;
    } else if ($7_ == 0) {
      goto _l118;
    } else {
      goto _l116;
    }
    _l116:;
    $8_ = psg_ * _ppgsf (&xm_, &iz_, c_, a_, bh_);
    if ($8_ < 0) {
      goto _l117;
    } else if ($8_ == 0) {
      goto _l118;
    } else {
      goto _l119;
    }
    _l117:;
    sgn_ = 1.0;
    cbp_[ig_ - 1] = CMPLXF (_bcrh (&bh_[ig_ - 1], &xm_, &iz_, c_, a_, bh_, _pgsf, &sgn_), 0.0);
    sgn_ = -1.0;
    cbp_[ig_ + 1 - 1] = CMPLXF (_bcrh (&xm_, &bh_[ig_ + 1 - 1], &iz_, c_, a_, bh_, _pgsf, &sgn_), 0.0);
    goto _l136;
    _l118:;
    cbp_[ig_ - 1] = CMPLXF (xm_, 0.0);
    cbp_[ig_ + 1 - 1] = CMPLXF (xm_, 0.0);
    goto _l136;
    _l119:;
    it_ = 0;
    icv_ = 0;
    cx_ = CMPLXF (xm_, 0.0);
    _l120:;
    fsg_ = CMPLXF (1.0, 0.0);
    hsg_ = CMPLXF (1.0, 0.0);
    fp_ = CMPLXF (0.0, 0.0);
    fpp_ = CMPLXF (0.0, 0.0);
    for (j_ = 1; j_ <= iz_; (j_)++) {
      dd_ = 1.0 / (cx_ - bh_[j_ - 1]);
      fsg_ = fsg_ * a_[j_ - 1] * dd_;
      hsg_ = hsg_ * c_[j_ - 1] * dd_;
      fp_ = fp_ + dd_;
      fpp_ = fpp_ - dd_ * dd_;
    }
    $9_ = modiz_;
    if ($9_ < 0) {
      goto _l123;
    } else if ($9_ == 0) {
      goto _l122;
    } else {
      goto _l123;
    }
    _l122:;
    f_ = CMPLXF (1.0, 0.0) - fsg_ - hsg_;
    goto _l124;
    _l123:;
    f_ = CMPLXF (1.0, 0.0) + fsg_ + hsg_;
    _l124:;
    i3_ = 0;
    $10_ = cabsf (fp_);
    if ($10_ < 0) {
      goto _l126;
    } else if ($10_ == 0) {
      goto _l126;
    } else {
      goto _l125;
    }
    _l125:;
    i3_ = 1;
    r3_ = -f_ / fp_;
    _l126:;
    $11_ = cabsf (fpp_);
    if ($11_ < 0) {
      goto _l132;
    } else if ($11_ == 0) {
      goto _l132;
    } else {
      goto _l127;
    }
    _l127:;
    cdis_ = csqrtf ((fp_ * fp_) - 2.0 * f_ * fpp_);
    r1_ = cdis_ - fp_;
    r2_ = -fp_ - cdis_;
    $12_ = cabsf (r1_) - cabsf (r2_);
    if ($12_ < 0) {
      goto _l129;
    } else if ($12_ == 0) {
      goto _l129;
    } else {
      goto _l128;
    }
    _l128:;
    r1_ = r1_ / fpp_;
    goto _l130;
    _l129:;
    r1_ = r2_ / fpp_;
    _l130:;
    r2_ = 2.0 * f_ / fpp_ / r1_;
    if (cabsf (r2_) < cabsf (r1_)) {
      r1_ = r2_;
    }
    $13_ = i3_;
    if ($13_ < 0) {
      goto _l133;
    } else if ($13_ == 0) {
      goto _l133;
    } else {
      goto _l131;
    }
    _l131:;
    if (cabsf (r3_) < cabsf (r1_)) {
      r1_ = r3_;
    }
    goto _l133;
    _l132:;
    r1_ = r3_;
    _l133:;
    cx_ = cx_ + r1_;
    it_ = it_ + 1;
    if (it_ > 50) {
      goto _l142;
    }
    if (cabsf (r1_) > scnv_) {
      goto _l120;
    }
    $14_ = icv_;
    if ($14_ < 0) {
      goto _l134;
    } else if ($14_ == 0) {
      goto _l134;
    } else {
      goto _l135;
    }
    _l134:;
    icv_ = 1;
    goto _l120;
    _l135:;
    cbp_[ig_ - 1] = cx_;
    cbp_[ig_ + 1 - 1] = conjf (cx_);
    _l136:;
  }
  $15_ = cabsf (cbp_[(*n_) - 1]) - cabsf (cbp_[0]);
  if ($15_ < 0) {
    goto _l137;
  } else if ($15_ == 0) {
    goto _l142;
  } else {
    goto _l139;
  }
  _l137:;
  nhalf_ = (*n_) / 2;
  for (j_ = 1; j_ <= nhalf_; (j_)++) {
    nt_ = (*n_) - j_;
    cx_ = cbp_[j_ - 1];
    cbp_[j_ - 1] = cbp_[nt_ + 1 - 1];
    cbp_[nt_ + 1 - 1] = cx_;
  }
  _l139:;
  ccblk_.ncmplx_ = 1;
  for (j_ = 2; j_ <= iz_; (j_)++) {
    $16_ = cimagf (cbp_[j_ - 1]);
    if ($16_ < 0) {
      goto _l143;
    } else if ($16_ == 0) {
      goto _l140;
    } else {
      goto _l143;
    }
    _l140:;
  }
  ccblk_.ncmplx_ = 0;
  for (j_ = 2; j_ <= iz_; (j_)++) {
    bp_[j_ - 1] = (real_4) (crealf (cbp_[j_ - 1]));
  }
  goto _l143;
  _l142:;
  (*ierror_) = 4;
  _l143:;
  __calls[41].calls++;
  return 0;
}

int_4 _cpevl (int_4 _p_ n_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ z_, complex_8 _p_ c_, complex_8 _p_ b_, 
logical_4 _p_ kbd_)
{
  static int_4 np1_, j_, mini_, i_;
  static real_4 d1_, r_, s_;
  static complex_8 ci_, cim1_, bi_, bim1_, t_, q_;
  int_4 _data_k_31, $0_, $1_;
  extern int_4 _i1mach ();
#define _data_n_31 1
  static real_4 _data_l_31[_data_n_31] = {
    0.0
  };
  if (__calls[42].calls == 0) {
    _data_k_31 = 0;
    if (_data_k_31 >= _data_n_31) {
      _data_k_31 = 0;
    }
    d1_ = _data_l_31[_data_k_31++];
  }
  if (d1_ == 0.0) {
    d1_ = _up_real_4 ((real_4) (_i1mach (($0_ = 10, &$0_))), (1 - _i1mach (($1_ = 11, &$1_))));
  }
  np1_ = (*n_) + 1;
  for (j_ = 1; j_ <= np1_; (j_)++) {
    ci_ = 0.0;
    cim1_ = a_[j_ - 1];
    bi_ = 0.0;
    bim1_ = 0.0;
    mini_ = _min ((*m_) + 1, (*n_) + 2 - j_);
    for (i_ = 1; i_ <= mini_; (i_)++) {
      if (j_ != 1) {
        ci_ = c_[i_ - 1];
      }
      if (i_ != 1) {
        cim1_ = c_[i_ - 1 - 1];
      }
      c_[i_ - 1] = cim1_ + (*z_) * ci_;
      if (! ((*kbd_))) {
        goto _l1;
      }
      if (j_ != 1) {
        bi_ = b_[i_ - 1];
      }
      if (i_ != 1) {
        bim1_ = b_[i_ - 1 - 1];
      }
      t_ = bi_ + (3.0 * d1_ + 4.0 * d1_ * d1_) * ({complex_8 q__1_ = ci_; CMPLXF (_abs ((real_4) (crealf (q__1_))), _abs 
      (cimagf (q__1_)));});
      r_ = (real_4) (crealf (({complex_8 q__1_ = (*z_); CMPLXF (_abs ((real_4) (crealf (q__1_))), _abs (cimagf (q__1_)));}) * 
      CMPLXF ((real_4) (crealf (t_)), -cimagf (t_))));
      s_ = cimagf (({complex_8 q__1_ = (*z_); CMPLXF (_abs ((real_4) (crealf (q__1_))), _abs (cimagf (q__1_)));}) * t_);
      b_[i_ - 1] = (1.0 + 8.0 * d1_) * (bim1_ + d1_ * ({complex_8 q__1_ = cim1_; CMPLXF (_abs ((real_4) (crealf (q__1_))), 
      _abs (cimagf (q__1_)));}) + CMPLXF (r_, s_));
      if (j_ == 1) {
        b_[i_ - 1] = 0.0;
      }
      _l1:;
    }
  }
  __calls[42].calls++;
  return 0;
}

int_4 _cpevlr (int_4 _p_ n_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ x_, real_4 _p_ c_)
{
  static int_4 np1_, j_, mini_, i_;
  static real_4 ci_, cim1_;
  np1_ = (*n_) + 1;
  for (j_ = 1; j_ <= np1_; (j_)++) {
    ci_ = 0.0;
    cim1_ = a_[j_ - 1];
    mini_ = _min ((*m_) + 1, (*n_) + 2 - j_);
    for (i_ = 1; i_ <= mini_; (i_)++) {
      if (j_ != 1) {
        ci_ = c_[i_ - 1];
      }
      if (i_ != 1) {
        cim1_ = c_[i_ - 1 - 1];
      }
      c_[i_ - 1] = cim1_ + (*x_) * ci_;
    }
  }
  __calls[43].calls++;
  return 0;
}

int_4 _cpofs (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
complex_8 _p_ work_)
{
  static int_4 info_;
  static real_4 rcond_;
  static char_15 xern1_, xern2_;
  int_4 __fcnt, __rc, $7_, $11_, $12_, $13_, $14_;
  char_31 $0_, $4_, $8_;
  char_63 $1_, $5_, $6_, $9_, $10_;
  char_127 $2_, $3_;
  extern real_4 _r1mach ();
  static FORMAT $f_100009_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100010_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100016_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*lda_) < (*n_)) {
    (*ind_) = -1;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cpofs:115", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:115", 0));
      __fcnt += 3;
    }
    if ($f_100009_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:115", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100009_[__fcnt + 2], &(*lda_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:115", 0));
    __fcnt += 3;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      if ($f_100009_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:115", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cpofs:116", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:116", 0));
      __fcnt += 3;
    }
    if ($f_100010_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:116", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100010_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:116", 0));
    __fcnt += 3;
    while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
      if ($f_100010_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:116", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_42, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_27, xern1_), _dc_28), xern2_), 
    127), $3_), &_km1, &_k1);
    goto _l0;
  }
  if ((*n_) <= 0) {
    (*ind_) = -2;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cpofs:124", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:124", 0));
      __fcnt += 3;
    }
    if ($f_100016_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:124", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100016_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:124", 0));
    __fcnt += 3;
    while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
      if ($f_100016_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:124", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_42, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_29, xern1_), _dc_30), 63), $6_), ($7_ = -2, 
    &$7_), &_k1);
    goto _l0;
  }
  if ((*itask_) < 1) {
    (*ind_) = -3;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cpofs:132", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:132", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:132", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*itask_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:132", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpofs:132", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_42, (bufcpy ($10_, concat ($9_, concat ($8_, _dc_31, xern1_), _dc_30), 63), $10_), ($11_ = 
    -3, &$11_), &_k1);
    goto _l0;
  }
  if ((*itask_) == 1) {
    (void) _cpoco (a_, lda_, n_, &rcond_, work_, &info_);
    if (info_ != 0) {
      (*ind_) = -4;
      (void) _xermsg (_dc_1, _dc_42, _dc_43, ($12_ = -4, &$12_), &_k1);
      goto _l0;
    }
    (*ind_) = -log10f (_r1mach (($13_ = 4, &$13_)) / rcond_);
    if ((*ind_) <= 0) {
      (*ind_) = -10;
      (void) _xermsg (_dc_1, _dc_42, _dc_33, ($14_ = -10, &$14_), &_k0);
    }
  }
  (void) _cposl (a_, lda_, n_, v_);
  _l0:;
  __calls[44].calls++;
  return 0;
}

int_4 _cpoir (complex_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, complex_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, 
complex_8 _p_ work_)
{
  static int_4 info_, j_;
  static real_4 xnorm_, dnorm_;
  static real_8 dr1_, di1_, dr2_, di2_;
  static char_15 xern1_, xern2_;
  int_4 __fcnt, __rc, $7_, $11_, $12_, $13_, $15_, $17_, $18_;
  real_8 $14_, $16_;
  char_31 $0_, $4_, $8_;
  char_63 $1_, $5_, $6_, $9_, $10_;
  char_127 $2_, $3_;
  extern real_4 _scasum ();
  extern real_4 _r1mach ();
  static FORMAT $f_100009_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100010_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100016_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100022_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*lda_) < (*n_)) {
    (*ind_) = -1;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cpoir:120", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:120", 0));
      __fcnt += 3;
    }
    if ($f_100009_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:120", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100009_[__fcnt + 2], &(*lda_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:120", 0));
    __fcnt += 3;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      if ($f_100009_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:120", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cpoir:121", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:121", 0));
      __fcnt += 3;
    }
    if ($f_100010_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:121", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100010_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:121", 0));
    __fcnt += 3;
    while ($f_100010_[__fcnt] != NULL && $f_100010_[__fcnt] == FMT_TEXT) {
      if ($f_100010_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100010_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:121", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_44, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_27, xern1_), _dc_28), xern2_), 
    127), $3_), &_km1, &_k1);
    goto _l0;
  }
  if ((*n_) <= 0) {
    (*ind_) = -2;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cpoir:129", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:129", 0));
      __fcnt += 3;
    }
    if ($f_100016_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:129", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100016_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:129", 0));
    __fcnt += 3;
    while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
      if ($f_100016_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:129", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_44, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_29, xern1_), _dc_30), 63), $6_), ($7_ = -2, 
    &$7_), &_k1);
    goto _l0;
  }
  if ((*itask_) < 1) {
    (*ind_) = -3;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:cpoir:137", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:137", 0));
      __fcnt += 3;
    }
    if ($f_100022_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:137", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100022_[__fcnt + 2], &(*itask_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:137", 0));
    __fcnt += 3;
    while ($f_100022_[__fcnt] != NULL && $f_100022_[__fcnt] == FMT_TEXT) {
      if ($f_100022_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100022_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:cpoir:137", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_44, (bufcpy ($10_, concat ($9_, concat ($8_, _dc_31, xern1_), _dc_30), 63), $10_), ($11_ = 
    -3, &$11_), &_k1);
    goto _l0;
  }
  if ((*itask_) == 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      (void) _ccopy (n_, &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &work_[0 + ((*n_)) * ((j_ - 1))], &_k1);
    }
    (void) _cpofa (work_, n_, n_, &info_);
    if (info_ != 0) {
      (*ind_) = -4;
      (void) _xermsg (_dc_1, _dc_44, _dc_43, ($12_ = -4, &$12_), &_k1);
      goto _l0;
    }
  }
  (void) _ccopy (n_, &v_[0], &_k1, &work_[0 + ((*n_)) * (((*n_) + 1 - 1))], &_k1);
  (void) _cposl (work_, n_, n_, v_);
  xnorm_ = _scasum (n_, &v_[0], &_k1);
  if (xnorm_ == 0.0) {
    (*ind_) = 75;
    goto _l0;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (void) _dcdot (($13_ = j_ - 1, &$13_), ($14_ = -1.0, &$14_), &a_[0 + ((*lda_)) * ((j_ - 1))], &_k1, &v_[0], &_k1, 
    &dr1_, &di1_);
    (void) _dcdot (($15_ = (*n_) - j_ + 1, &$15_), ($16_ = 1.0, &$16_), &a_[j_ - 1 + ((*lda_)) * ((j_ - 1))], lda_, &v_[j_ 
    - 1], &_k1, &dr2_, &di2_);
    dr1_ = dr1_ + dr2_ - (real_8) ((real_4) (crealf (work_[j_ - 1 + ((*n_)) * (((*n_) + 1 - 1))])));
    di1_ = di1_ + di2_ - (real_8) (cimagf (work_[j_ - 1 + ((*n_)) * (((*n_) + 1 - 1))]));
    work_[j_ - 1 + ((*n_)) * (((*n_) + 1 - 1))] = CMPLXF ((real_4) (dr1_), (real_4) (di1_));
  }
  (void) _cposl (work_, n_, n_, &work_[0 + ((*n_)) * (((*n_) + 1 - 1))]);
  dnorm_ = _scasum (n_, &work_[0 + ((*n_)) * (((*n_) + 1 - 1))], &_k1);
  (*ind_) = -log10f (_max (_r1mach (($17_ = 4, &$17_)), dnorm_ / xnorm_));
  if ((*ind_) <= 0) {
    (*ind_) = -10;
    (void) _xermsg (_dc_1, _dc_44, _dc_33, ($18_ = -10, &$18_), &_k0);
  }
  _l0:;
  __calls[45].calls++;
  return 0;
}

int_4 _cpqr79 (int_4 _p_ ndeg_, complex_8 _p_ coeff_, complex_8 _p_ root_, int_4 _p_ ierr_, real_4 _p_ work_)
{
  static int_4 k_, khr_, khi_, kwr_, kwi_, kad_, kj_, km1_;
  static complex_8 scale_, c_;
  int_4 $0_, $1_;
  (*ierr_) = 0;
  if (cabsf (coeff_[0]) == 0.0) {
    (*ierr_) = 2;
    (void) _xermsg (_dc_1, _dc_45, _dc_46, ($0_ = 2, &$0_), &_k1);
    goto _l0;
  }
  if ((*ndeg_) <= 0) {
    (*ierr_) = 3;
    (void) _xermsg (_dc_1, _dc_45, _dc_47, ($1_ = 3, &$1_), &_k1);
    goto _l0;
  }
  if ((*ndeg_) == 1) {
    root_[0] = -coeff_[1] / coeff_[0];
    goto _l0;
  }
  scale_ = 1.0e0 / coeff_[0];
  khr_ = 1;
  khi_ = khr_ + (*ndeg_) * (*ndeg_);
  kwr_ = khi_ + khi_ - khr_;
  kwi_ = kwr_ + (*ndeg_);
  for (k_ = 1; k_ <= kwr_; (k_)++) {
    work_[k_ - 1] = 0.0;
  }
  for (k_ = 1; k_ <= (*ndeg_); (k_)++) {
    kad_ = (k_ - 1) * (*ndeg_) + 1;
    c_ = scale_ * coeff_[k_ + 1 - 1];
    work_[kad_ - 1] = -(real_4) (crealf (c_));
    kj_ = khi_ + kad_ - 1;
    work_[kj_ - 1] = -cimagf (c_);
    if (k_ != (*ndeg_)) {
      work_[kad_ + k_ - 1] = 1.0;
    }
  }
  (void) _comqr (ndeg_, ndeg_, &_k1, ndeg_, &work_[khr_ - 1], &work_[khi_ - 1], &work_[kwr_ - 1], &work_[kwi_ - 1], 
  ierr_);
  if ((*ierr_) != 0) {
    (*ierr_) = 1;
    (void) _xermsg (_dc_1, _dc_45, _dc_48, &_k1, &_k1);
    goto _l0;
  }
  for (k_ = 1; k_ <= (*ndeg_); (k_)++) {
    km1_ = k_ - 1;
    root_[k_ - 1] = CMPLXF (work_[kwr_ + km1_ - 1], work_[kwi_ + km1_ - 1]);
  }
  _l0:;
  __calls[46].calls++;
  return 0;
}

int_4 _cproc (int_4 _p_ nd_, complex_8 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ bm2_, int_4 
_p_ na_, real_4 _p_ aa_, complex_8 _p_ x_, complex_8 _p_ y_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, 
complex_8 _p_ c_, complex_8 _p_ d_, complex_8 _p_ w_, real_4 _p_ yy_)
{
  static int_4 j_, mm_, id_, m1_, m2_, ia_, iflg_, k_;
  static real_4 rt_;
  static complex_8 crt_, den_, y1_, y2_;
  int_4 $0_, $2_, $3_, $4_, $6_, $7_, $8_;
  real_4 $1_, $5_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = x_[j_ - 1];
  }
  mm_ = (*m_) - 1;
  id_ = (*nd_);
  m1_ = (*nm1_);
  m2_ = (*nm2_);
  ia_ = (*na_);
  _l102:;
  iflg_ = 0;
  $0_ = id_;
  if ($0_ < 0) {
    goto _l109;
  } else if ($0_ == 0) {
    goto _l109;
  } else {
    goto _l103;
  }
  _l103:;
  crt_ = bd_[id_ - 1];
  id_ = id_ - 1;
  d_[(*m_) - 1] = a_[(*m_) - 1] / (b_[(*m_) - 1] - crt_);
  w_[(*m_) - 1] = y_[(*m_) - 1] / (b_[(*m_) - 1] - crt_);
  for (j_ = 2; j_ <= mm_; (j_)++) {
    k_ = (*m_) - j_;
    den_ = b_[k_ + 1 - 1] - crt_ - c_[k_ + 1 - 1] * d_[k_ + 2 - 1];
    d_[k_ + 1 - 1] = a_[k_ + 1 - 1] / den_;
    w_[k_ + 1 - 1] = (y_[k_ + 1 - 1] - c_[k_ + 1 - 1] * w_[k_ + 2 - 1]) / den_;
  }
  den_ = b_[0] - crt_ - c_[0] * d_[1];
  $1_ = cabsf (den_);
  if ($1_ < 0) {
    goto _l105;
  } else if ($1_ == 0) {
    goto _l106;
  } else {
    goto _l105;
  }
  _l105:;
  y_[0] = (y_[0] - c_[0] * w_[1]) / den_;
  goto _l107;
  _l106:;
  y_[0] = CMPLXF (1.0, 0.0);
  _l107:;
  for (j_ = 2; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = w_[j_ - 1] - d_[j_ - 1] * y_[j_ - 1 - 1];
  }
  _l109:;
  $2_ = m1_;
  if ($2_ < 0) {
    goto _l110;
  } else if ($2_ == 0) {
    goto _l110;
  } else {
    goto _l112;
  }
  _l110:;
  $3_ = m2_;
  if ($3_ < 0) {
    goto _l121;
  } else if ($3_ == 0) {
    goto _l121;
  } else {
    goto _l111;
  }
  _l111:;
  rt_ = bm2_[m2_ - 1];
  m2_ = m2_ - 1;
  goto _l117;
  _l112:;
  $4_ = m2_;
  if ($4_ < 0) {
    goto _l113;
  } else if ($4_ == 0) {
    goto _l113;
  } else {
    goto _l114;
  }
  _l113:;
  rt_ = bm1_[m1_ - 1];
  m1_ = m1_ - 1;
  goto _l117;
  _l114:;
  $5_ = _abs (bm1_[m1_ - 1]) - _abs (bm2_[m2_ - 1]);
  if ($5_ < 0) {
    goto _l116;
  } else if ($5_ == 0) {
    goto _l116;
  } else {
    goto _l115;
  }
  _l115:;
  rt_ = bm1_[m1_ - 1];
  m1_ = m1_ - 1;
  goto _l117;
  _l116:;
  rt_ = bm2_[m2_ - 1];
  m2_ = m2_ - 1;
  _l117:;
  y1_ = (b_[0] - rt_) * y_[0] + c_[0] * y_[1];
  $6_ = mm_ - 2;
  if ($6_ < 0) {
    goto _l120;
  } else if ($6_ == 0) {
    goto _l118;
  } else {
    goto _l118;
  }
  _l118:;
  for (j_ = 2; j_ <= mm_; (j_)++) {
    y2_ = a_[j_ - 1] * y_[j_ - 1 - 1] + (b_[j_ - 1] - rt_) * y_[j_ - 1] + c_[j_ - 1] * y_[j_ + 1 - 1];
    y_[j_ - 1 - 1] = y1_;
    y1_ = y2_;
  }
  _l120:;
  y_[(*m_) - 1] = a_[(*m_) - 1] * y_[(*m_) - 1 - 1] + (b_[(*m_) - 1] - rt_) * y_[(*m_) - 1];
  y_[(*m_) - 1 - 1] = y1_;
  iflg_ = 1;
  goto _l102;
  _l121:;
  $7_ = ia_;
  if ($7_ < 0) {
    goto _l124;
  } else if ($7_ == 0) {
    goto _l124;
  } else {
    goto _l122;
  }
  _l122:;
  rt_ = aa_[ia_ - 1];
  ia_ = ia_ - 1;
  iflg_ = 1;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = rt_ * y_[j_ - 1];
  }
  _l124:;
  $8_ = iflg_;
  if ($8_ < 0) {
    goto _l125;
  } else if ($8_ == 0) {
    goto _l125;
  } else {
    goto _l102;
  }
  _l125:;
  __calls[47].calls++;
  return 0;
}

int_4 _cprocp (int_4 _p_ nd_, complex_8 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ bm2_, 
int_4 _p_ na_, real_4 _p_ aa_, complex_8 _p_ x_, complex_8 _p_ y_, int_4 _p_ m_, complex_8 _p_ a_, complex_8 _p_ b_, 
complex_8 _p_ c_, complex_8 _p_ d_, complex_8 _p_ u_, real_4 _p_ yy_)
{
  static int_4 j_, mm_, mm2_, id_, m1_, m2_, ia_, iflg_, k_;
  static real_4 rt_;
  static complex_8 v_, den_, bh_, ym_, am_, y1_, y2_, yh_, crt_;
  int_4 $0_, $1_, $3_, $4_, $5_, $7_, $8_, $9_;
  real_4 $2_, $6_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = x_[j_ - 1];
  }
  mm_ = (*m_) - 1;
  mm2_ = (*m_) - 2;
  id_ = (*nd_);
  m1_ = (*nm1_);
  m2_ = (*nm2_);
  ia_ = (*na_);
  _l102:;
  iflg_ = 0;
  $0_ = id_;
  if ($0_ < 0) {
    goto _l111;
  } else if ($0_ == 0) {
    goto _l111;
  } else {
    goto _l103;
  }
  _l103:;
  crt_ = bd_[id_ - 1];
  id_ = id_ - 1;
  iflg_ = 1;
  bh_ = b_[(*m_) - 1] - crt_;
  ym_ = y_[(*m_) - 1];
  den_ = b_[0] - crt_;
  d_[0] = c_[0] / den_;
  u_[0] = a_[0] / den_;
  y_[0] = y_[0] / den_;
  v_ = c_[(*m_) - 1];
  $1_ = mm2_ - 2;
  if ($1_ < 0) {
    goto _l106;
  } else if ($1_ == 0) {
    goto _l104;
  } else {
    goto _l104;
  }
  _l104:;
  for (j_ = 2; j_ <= mm2_; (j_)++) {
    den_ = b_[j_ - 1] - crt_ - a_[j_ - 1] * d_[j_ - 1 - 1];
    d_[j_ - 1] = c_[j_ - 1] / den_;
    u_[j_ - 1] = -a_[j_ - 1] * u_[j_ - 1 - 1] / den_;
    y_[j_ - 1] = (y_[j_ - 1] - a_[j_ - 1] * y_[j_ - 1 - 1]) / den_;
    bh_ = bh_ - v_ * u_[j_ - 1 - 1];
    ym_ = ym_ - v_ * y_[j_ - 1 - 1];
    v_ = -v_ * d_[j_ - 1 - 1];
  }
  _l106:;
  den_ = b_[(*m_) - 1 - 1] - crt_ - a_[(*m_) - 1 - 1] * d_[(*m_) - 2 - 1];
  d_[(*m_) - 1 - 1] = (c_[(*m_) - 1 - 1] - a_[(*m_) - 1 - 1] * u_[(*m_) - 2 - 1]) / den_;
  y_[(*m_) - 1 - 1] = (y_[(*m_) - 1 - 1] - a_[(*m_) - 1 - 1] * y_[(*m_) - 2 - 1]) / den_;
  am_ = a_[(*m_) - 1] - v_ * d_[(*m_) - 2 - 1];
  bh_ = bh_ - v_ * u_[(*m_) - 2 - 1];
  ym_ = ym_ - v_ * y_[(*m_) - 2 - 1];
  den_ = bh_ - am_ * d_[(*m_) - 1 - 1];
  $2_ = cabsf (den_);
  if ($2_ < 0) {
    goto _l107;
  } else if ($2_ == 0) {
    goto _l108;
  } else {
    goto _l107;
  }
  _l107:;
  y_[(*m_) - 1] = (ym_ - am_ * y_[(*m_) - 1 - 1]) / den_;
  goto _l109;
  _l108:;
  y_[(*m_) - 1] = CMPLXF (1.0, 0.0);
  _l109:;
  y_[(*m_) - 1 - 1] = y_[(*m_) - 1 - 1] - d_[(*m_) - 1 - 1] * y_[(*m_) - 1];
  for (j_ = 2; j_ <= mm_; (j_)++) {
    k_ = (*m_) - j_;
    y_[k_ - 1] = y_[k_ - 1] - d_[k_ - 1] * y_[k_ + 1 - 1] - u_[k_ - 1] * y_[(*m_) - 1];
  }
  _l111:;
  $3_ = m1_;
  if ($3_ < 0) {
    goto _l112;
  } else if ($3_ == 0) {
    goto _l112;
  } else {
    goto _l114;
  }
  _l112:;
  $4_ = m2_;
  if ($4_ < 0) {
    goto _l123;
  } else if ($4_ == 0) {
    goto _l123;
  } else {
    goto _l113;
  }
  _l113:;
  rt_ = bm2_[m2_ - 1];
  m2_ = m2_ - 1;
  goto _l119;
  _l114:;
  $5_ = m2_;
  if ($5_ < 0) {
    goto _l115;
  } else if ($5_ == 0) {
    goto _l115;
  } else {
    goto _l116;
  }
  _l115:;
  rt_ = bm1_[m1_ - 1];
  m1_ = m1_ - 1;
  goto _l119;
  _l116:;
  $6_ = _abs (bm1_[m1_ - 1]) - _abs (bm2_[m2_ - 1]);
  if ($6_ < 0) {
    goto _l118;
  } else if ($6_ == 0) {
    goto _l118;
  } else {
    goto _l117;
  }
  _l117:;
  rt_ = bm1_[m1_ - 1];
  m1_ = m1_ - 1;
  goto _l119;
  _l118:;
  rt_ = bm2_[m2_ - 1];
  m2_ = m2_ - 1;
  _l119:;
  yh_ = y_[0];
  y1_ = (b_[0] - rt_) * y_[0] + c_[0] * y_[1] + a_[0] * y_[(*m_) - 1];
  $7_ = mm_ - 2;
  if ($7_ < 0) {
    goto _l122;
  } else if ($7_ == 0) {
    goto _l120;
  } else {
    goto _l120;
  }
  _l120:;
  for (j_ = 2; j_ <= mm_; (j_)++) {
    y2_ = a_[j_ - 1] * y_[j_ - 1 - 1] + (b_[j_ - 1] - rt_) * y_[j_ - 1] + c_[j_ - 1] * y_[j_ + 1 - 1];
    y_[j_ - 1 - 1] = y1_;
    y1_ = y2_;
  }
  _l122:;
  y_[(*m_) - 1] = a_[(*m_) - 1] * y_[(*m_) - 1 - 1] + (b_[(*m_) - 1] - rt_) * y_[(*m_) - 1] + c_[(*m_) - 1] * yh_;
  y_[(*m_) - 1 - 1] = y1_;
  iflg_ = 1;
  goto _l102;
  _l123:;
  $8_ = ia_;
  if ($8_ < 0) {
    goto _l126;
  } else if ($8_ == 0) {
    goto _l126;
  } else {
    goto _l124;
  }
  _l124:;
  rt_ = aa_[ia_ - 1];
  ia_ = ia_ - 1;
  iflg_ = 1;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = rt_ * y_[j_ - 1];
  }
  _l126:;
  $9_ = iflg_;
  if ($9_ < 0) {
    goto _l127;
  } else if ($9_ == 0) {
    goto _l127;
  } else {
    goto _l102;
  }
  _l127:;
  __calls[48].calls++;
  return 0;
}

int_4 _cprod (int_4 _p_ nd_, complex_8 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ bm2_, int_4 
_p_ na_, real_4 _p_ aa_, real_4 _p_ x_, real_4 _p_ yy_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_, 
complex_8 _p_ d_, complex_8 _p_ w_, complex_8 _p_ y_)
{
  static int_4 j_, mm_, id_, m1_, m2_, ia_, iflg_, k_;
  static real_4 rt_;
  static complex_8 crt_, den_, y1_, y2_;
  int_4 $0_, $2_, $3_, $4_, $6_, $7_, $8_;
  real_4 $1_, $5_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = CMPLXF (x_[j_ - 1], 0.0);
  }
  mm_ = (*m_) - 1;
  id_ = (*nd_);
  m1_ = (*nm1_);
  m2_ = (*nm2_);
  ia_ = (*na_);
  _l102:;
  iflg_ = 0;
  $0_ = id_;
  if ($0_ < 0) {
    goto _l109;
  } else if ($0_ == 0) {
    goto _l109;
  } else {
    goto _l103;
  }
  _l103:;
  crt_ = bd_[id_ - 1];
  id_ = id_ - 1;
  d_[(*m_) - 1] = a_[(*m_) - 1] / (b_[(*m_) - 1] - crt_);
  w_[(*m_) - 1] = y_[(*m_) - 1] / (b_[(*m_) - 1] - crt_);
  for (j_ = 2; j_ <= mm_; (j_)++) {
    k_ = (*m_) - j_;
    den_ = b_[k_ + 1 - 1] - crt_ - c_[k_ + 1 - 1] * d_[k_ + 2 - 1];
    d_[k_ + 1 - 1] = a_[k_ + 1 - 1] / den_;
    w_[k_ + 1 - 1] = (y_[k_ + 1 - 1] - c_[k_ + 1 - 1] * w_[k_ + 2 - 1]) / den_;
  }
  den_ = b_[0] - crt_ - c_[0] * d_[1];
  $1_ = cabsf (den_);
  if ($1_ < 0) {
    goto _l105;
  } else if ($1_ == 0) {
    goto _l106;
  } else {
    goto _l105;
  }
  _l105:;
  y_[0] = (y_[0] - c_[0] * w_[1]) / den_;
  goto _l107;
  _l106:;
  y_[0] = CMPLXF (1.0, 0.0);
  _l107:;
  for (j_ = 2; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = w_[j_ - 1] - d_[j_ - 1] * y_[j_ - 1 - 1];
  }
  _l109:;
  $2_ = m1_;
  if ($2_ < 0) {
    goto _l110;
  } else if ($2_ == 0) {
    goto _l110;
  } else {
    goto _l112;
  }
  _l110:;
  $3_ = m2_;
  if ($3_ < 0) {
    goto _l121;
  } else if ($3_ == 0) {
    goto _l121;
  } else {
    goto _l111;
  }
  _l111:;
  rt_ = bm2_[m2_ - 1];
  m2_ = m2_ - 1;
  goto _l117;
  _l112:;
  $4_ = m2_;
  if ($4_ < 0) {
    goto _l113;
  } else if ($4_ == 0) {
    goto _l113;
  } else {
    goto _l114;
  }
  _l113:;
  rt_ = bm1_[m1_ - 1];
  m1_ = m1_ - 1;
  goto _l117;
  _l114:;
  $5_ = _abs (bm1_[m1_ - 1]) - _abs (bm2_[m2_ - 1]);
  if ($5_ < 0) {
    goto _l116;
  } else if ($5_ == 0) {
    goto _l116;
  } else {
    goto _l115;
  }
  _l115:;
  rt_ = bm1_[m1_ - 1];
  m1_ = m1_ - 1;
  goto _l117;
  _l116:;
  rt_ = bm2_[m2_ - 1];
  m2_ = m2_ - 1;
  _l117:;
  y1_ = (b_[0] - rt_) * y_[0] + c_[0] * y_[1];
  $6_ = mm_ - 2;
  if ($6_ < 0) {
    goto _l120;
  } else if ($6_ == 0) {
    goto _l118;
  } else {
    goto _l118;
  }
  _l118:;
  for (j_ = 2; j_ <= mm_; (j_)++) {
    y2_ = a_[j_ - 1] * y_[j_ - 1 - 1] + (b_[j_ - 1] - rt_) * y_[j_ - 1] + c_[j_ - 1] * y_[j_ + 1 - 1];
    y_[j_ - 1 - 1] = y1_;
    y1_ = y2_;
  }
  _l120:;
  y_[(*m_) - 1] = a_[(*m_) - 1] * y_[(*m_) - 1 - 1] + (b_[(*m_) - 1] - rt_) * y_[(*m_) - 1];
  y_[(*m_) - 1 - 1] = y1_;
  iflg_ = 1;
  goto _l102;
  _l121:;
  $7_ = ia_;
  if ($7_ < 0) {
    goto _l124;
  } else if ($7_ == 0) {
    goto _l124;
  } else {
    goto _l122;
  }
  _l122:;
  rt_ = aa_[ia_ - 1];
  ia_ = ia_ - 1;
  iflg_ = 1;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = rt_ * y_[j_ - 1];
  }
  _l124:;
  $8_ = iflg_;
  if ($8_ < 0) {
    goto _l125;
  } else if ($8_ == 0) {
    goto _l125;
  } else {
    goto _l102;
  }
  _l125:;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    yy_[j_ - 1] = (real_4) (crealf (y_[j_ - 1]));
  }
  __calls[49].calls++;
  return 0;
}

int_4 _cprodp (int_4 _p_ nd_, complex_8 _p_ bd_, int_4 _p_ nm1_, real_4 _p_ bm1_, int_4 _p_ nm2_, real_4 _p_ bm2_, 
int_4 _p_ na_, real_4 _p_ aa_, real_4 _p_ x_, real_4 _p_ yy_, int_4 _p_ m_, real_4 _p_ a_, real_4 _p_ b_, real_4 _p_ c_
, complex_8 _p_ d_, complex_8 _p_ u_, complex_8 _p_ y_)
{
  static int_4 j_, mm_, mm2_, id_, m1_, m2_, ia_, iflg_, k_;
  static real_4 rt_;
  static complex_8 v_, den_, bh_, ym_, am_, y1_, y2_, yh_, crt_;
  int_4 $0_, $1_, $3_, $4_, $5_, $7_, $8_, $9_;
  real_4 $2_, $6_;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = CMPLXF (x_[j_ - 1], 0.0);
  }
  mm_ = (*m_) - 1;
  mm2_ = (*m_) - 2;
  id_ = (*nd_);
  m1_ = (*nm1_);
  m2_ = (*nm2_);
  ia_ = (*na_);
  _l102:;
  iflg_ = 0;
  $0_ = id_;
  if ($0_ < 0) {
    goto _l111;
  } else if ($0_ == 0) {
    goto _l111;
  } else {
    goto _l103;
  }
  _l103:;
  crt_ = bd_[id_ - 1];
  id_ = id_ - 1;
  iflg_ = 1;
  bh_ = b_[(*m_) - 1] - crt_;
  ym_ = y_[(*m_) - 1];
  den_ = b_[0] - crt_;
  d_[0] = c_[0] / den_;
  u_[0] = a_[0] / den_;
  y_[0] = y_[0] / den_;
  v_ = CMPLXF (c_[(*m_) - 1], 0.0);
  $1_ = mm2_ - 2;
  if ($1_ < 0) {
    goto _l106;
  } else if ($1_ == 0) {
    goto _l104;
  } else {
    goto _l104;
  }
  _l104:;
  for (j_ = 2; j_ <= mm2_; (j_)++) {
    den_ = b_[j_ - 1] - crt_ - a_[j_ - 1] * d_[j_ - 1 - 1];
    d_[j_ - 1] = c_[j_ - 1] / den_;
    u_[j_ - 1] = -a_[j_ - 1] * u_[j_ - 1 - 1] / den_;
    y_[j_ - 1] = (y_[j_ - 1] - a_[j_ - 1] * y_[j_ - 1 - 1]) / den_;
    bh_ = bh_ - v_ * u_[j_ - 1 - 1];
    ym_ = ym_ - v_ * y_[j_ - 1 - 1];
    v_ = -v_ * d_[j_ - 1 - 1];
  }
  _l106:;
  den_ = b_[(*m_) - 1 - 1] - crt_ - a_[(*m_) - 1 - 1] * d_[(*m_) - 2 - 1];
  d_[(*m_) - 1 - 1] = (c_[(*m_) - 1 - 1] - a_[(*m_) - 1 - 1] * u_[(*m_) - 2 - 1]) / den_;
  y_[(*m_) - 1 - 1] = (y_[(*m_) - 1 - 1] - a_[(*m_) - 1 - 1] * y_[(*m_) - 2 - 1]) / den_;
  am_ = a_[(*m_) - 1] - v_ * d_[(*m_) - 2 - 1];
  bh_ = bh_ - v_ * u_[(*m_) - 2 - 1];
  ym_ = ym_ - v_ * y_[(*m_) - 2 - 1];
  den_ = bh_ - am_ * d_[(*m_) - 1 - 1];
  $2_ = cabsf (den_);
  if ($2_ < 0) {
    goto _l107;
  } else if ($2_ == 0) {
    goto _l108;
  } else {
    goto _l107;
  }
  _l107:;
  y_[(*m_) - 1] = (ym_ - am_ * y_[(*m_) - 1 - 1]) / den_;
  goto _l109;
  _l108:;
  y_[(*m_) - 1] = CMPLXF (1.0, 0.0);
  _l109:;
  y_[(*m_) - 1 - 1] = y_[(*m_) - 1 - 1] - d_[(*m_) - 1 - 1] * y_[(*m_) - 1];
  for (j_ = 2; j_ <= mm_; (j_)++) {
    k_ = (*m_) - j_;
    y_[k_ - 1] = y_[k_ - 1] - d_[k_ - 1] * y_[k_ + 1 - 1] - u_[k_ - 1] * y_[(*m_) - 1];
  }
  _l111:;
  $3_ = m1_;
  if ($3_ < 0) {
    goto _l112;
  } else if ($3_ == 0) {
    goto _l112;
  } else {
    goto _l114;
  }
  _l112:;
  $4_ = m2_;
  if ($4_ < 0) {
    goto _l123;
  } else if ($4_ == 0) {
    goto _l123;
  } else {
    goto _l113;
  }
  _l113:;
  rt_ = bm2_[m2_ - 1];
  m2_ = m2_ - 1;
  goto _l119;
  _l114:;
  $5_ = m2_;
  if ($5_ < 0) {
    goto _l115;
  } else if ($5_ == 0) {
    goto _l115;
  } else {
    goto _l116;
  }
  _l115:;
  rt_ = bm1_[m1_ - 1];
  m1_ = m1_ - 1;
  goto _l119;
  _l116:;
  $6_ = _abs (bm1_[m1_ - 1]) - _abs (bm2_[m2_ - 1]);
  if ($6_ < 0) {
    goto _l118;
  } else if ($6_ == 0) {
    goto _l118;
  } else {
    goto _l117;
  }
  _l117:;
  rt_ = bm1_[m1_ - 1];
  m1_ = m1_ - 1;
  goto _l119;
  _l118:;
  rt_ = bm2_[m2_ - 1];
  m2_ = m2_ - 1;
  _l119:;
  yh_ = y_[0];
  y1_ = (b_[0] - rt_) * y_[0] + c_[0] * y_[1] + a_[0] * y_[(*m_) - 1];
  $7_ = mm_ - 2;
  if ($7_ < 0) {
    goto _l122;
  } else if ($7_ == 0) {
    goto _l120;
  } else {
    goto _l120;
  }
  _l120:;
  for (j_ = 2; j_ <= mm_; (j_)++) {
    y2_ = a_[j_ - 1] * y_[j_ - 1 - 1] + (b_[j_ - 1] - rt_) * y_[j_ - 1] + c_[j_ - 1] * y_[j_ + 1 - 1];
    y_[j_ - 1 - 1] = y1_;
    y1_ = y2_;
  }
  _l122:;
  y_[(*m_) - 1] = a_[(*m_) - 1] * y_[(*m_) - 1 - 1] + (b_[(*m_) - 1] - rt_) * y_[(*m_) - 1] + c_[(*m_) - 1] * yh_;
  y_[(*m_) - 1 - 1] = y1_;
  iflg_ = 1;
  goto _l102;
  _l123:;
  $8_ = ia_;
  if ($8_ < 0) {
    goto _l126;
  } else if ($8_ == 0) {
    goto _l126;
  } else {
    goto _l124;
  }
  _l124:;
  rt_ = aa_[ia_ - 1];
  ia_ = ia_ - 1;
  iflg_ = 1;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    y_[j_ - 1] = rt_ * y_[j_ - 1];
  }
  _l126:;
  $9_ = iflg_;
  if ($9_ < 0) {
    goto _l127;
  } else if ($9_ == 0) {
    goto _l127;
  } else {
    goto _l102;
  }
  _l127:;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    yy_[j_ - 1] = (real_4) (crealf (y_[j_ - 1]));
  }
  __calls[50].calls++;
  return 0;
}

int_4 _cpzero (int_4 _p_ in_, complex_8 _p_ a_, complex_8 _p_ r_, complex_8 _p_ t_, int_4 _p_ iflg_, real_4 _p_ s_)
{
  static int_4 n_, n1_, imax_, i_, nr_, nmax_, nit_, j_;
  static real_4 x_, u_, v_;
  static complex_8 pn_, temp_;
  logical_4 $0_, $2_, $4_, $5_, $6_;
  complex_8 $1_, $3_;
  if ((*in_) <= 0 || cabsf (a_[0]) == 0.0) {
    goto _l30;
  }
  n_ = (*in_);
  n1_ = n_ + 1;
  if ((*iflg_) != 0) {
    goto _l14;
  }
  _l1:;
  n1_ = n_ + 1;
  if (n_ > 1) {
    goto _l2;
  }
  r_[0] = -a_[1] / a_[0];
  s_[0] = 0.0;
  goto _l0;
  _l2:;
  if (cabsf (a_[n1_ - 1]) != 0.0) {
    goto _l3;
  }
  r_[n_ - 1] = 0.0;
  s_[n_ - 1] = 0.0;
  n_ = n_ - 1;
  goto _l1;
  _l3:;
  temp_ = -a_[1] / (a_[0] * n_);
  (void) _cpevl (&n_, &n_, a_, &temp_, t_, t_, ($0_ = FALSE, &$0_));
  imax_ = n_ + 2;
  t_[n1_ - 1] = cabsf (t_[n1_ - 1]);
  for (i_ = 2; i_ <= n1_; (i_)++) {
    t_[n_ + i_ - 1] = -cabsf (t_[n_ + 2 - i_ - 1]);
    if ((real_4) (crealf (t_[n_ + i_ - 1])) < (real_4) (crealf (t_[imax_ - 1]))) {
      imax_ = n_ + i_;
    }
  }
  x_ = powl ((-(real_4) (crealf (t_[imax_ - 1])) / (real_4) (crealf (t_[n1_ - 1]))), (1.0 / (imax_ - n1_)));
  _l7:;
  x_ = 2.0 * x_;
  (void) _cpevl (&n_, &_k0, &t_[n1_ - 1], ($1_ = CMPLXF (x_, 0.0), &$1_), &pn_, &pn_, ($2_ = FALSE, &$2_));
  if ((real_4) (crealf (pn_)) < 0.0) {
    goto _l7;
  }
  u_ = .5 * x_;
  v_ = x_;
  _l10:;
  x_ = .5 * (u_ + v_);
  (void) _cpevl (&n_, &_k0, &t_[n1_ - 1], ($3_ = CMPLXF (x_, 0.0), &$3_), &pn_, &pn_, ($4_ = FALSE, &$4_));
  if ((real_4) (crealf (pn_)) > 0.0) {
    v_ = x_;
  }
  if ((real_4) (crealf (pn_)) <= 0.0) {
    u_ = x_;
  }
  if ((v_ - u_) > .001 * (1.0 + v_)) {
    goto _l10;
  }
  for (i_ = 1; i_ <= n_; (i_)++) {
    u_ = (3.14159265 / n_) * (2 * i_ - 1.5);
    r_[i_ - 1] = _max (x_, .001 * cabsf (temp_)) * CMPLXF (cosf (u_), sinf (u_)) + temp_;
  }
  _l14:;
  nr_ = 0;
  nmax_ = 25 * n_;
  for (nit_ = 1; nit_ <= nmax_; (nit_)++) {
    for (i_ = 1; i_ <= n_; (i_)++) {
      if (nit_ != 1 && cabsf (t_[i_ - 1]) == 0.0) {
        goto _l18;
      }
      (void) _cpevl (&n_, &_k0, a_, &r_[i_ - 1], &pn_, &temp_, ($5_ = TRUE, &$5_));
      if (_abs ((real_4) (crealf (pn_))) + _abs (cimagf (pn_)) > (real_4) (crealf (temp_)) + cimagf (temp_)) {
        goto _l16;
      }
      t_[i_ - 1] = 0.0;
      nr_ = nr_ + 1;
      goto _l18;
      _l16:;
      temp_ = a_[0];
      for (j_ = 1; j_ <= n_; (j_)++) {
        if (j_ != i_) {
          temp_ = temp_ * (r_[i_ - 1] - r_[j_ - 1]);
        }
      }
      t_[i_ - 1] = pn_ / temp_;
      _l18:;
    }
    for (i_ = 1; i_ <= n_; (i_)++) {
      r_[i_ - 1] = r_[i_ - 1] - t_[i_ - 1];
    }
    if (nr_ == n_) {
      goto _l21;
    }
  }
  goto _l26;
  _l21:;
  for (nr_ = 1; nr_ <= n_; (nr_)++) {
    (void) _cpevl (&n_, &n_, a_, &r_[nr_ - 1], t_, &t_[n_ + 2 - 1], ($6_ = TRUE, &$6_));
    x_ = cabsf (CMPLXF (_abs ((real_4) (crealf (t_[0]))), _abs (cimagf (t_[0]))) + t_[n_ + 2 - 1]);
    s_[nr_ - 1] = 0.0;
    for (i_ = 1; i_ <= n_; (i_)++) {
      x_ = x_ * (real_4) (n1_ - i_) / i_;
      temp_ = CMPLXF (_max (_abs ((real_4) (crealf (t_[i_ + 1 - 1]))) - (real_4) (crealf (t_[n1_ + i_ - 1])), 0.0), _max 
      (_abs (cimagf (t_[i_ + 1 - 1])) - cimagf (t_[n1_ + i_ - 1]), 0.0));
      s_[nr_ - 1] = _max (s_[nr_ - 1], powl ((cabsf (temp_) / x_), (1.0 / i_)));
    }
    s_[nr_ - 1] = 1.0 / s_[nr_ - 1];
  }
  goto _l0;
  _l26:;
  (*iflg_) = 2;
  goto _l0;
  _l30:;
  (*iflg_) = 1;
  _l0:;
  __calls[51].calls++;
  return 0;
}

int_4 _crati (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ n_, complex_8 _p_ cy_, real_4 _p_ tol_)
{
  static int_4 i_, id_, idnu_, inu_, itime_, k_, kk_, magz_;
  static real_4 ak_, amagz_, ap1_, ap2_, arg_, az_, dfnu_, fdnu_, flam_, fnup_, rap1_, rho_, test_, test1_;
  static complex_8 cdfnu_, cone_, czero_, pt_, p1_, p2_, rz_, t1_;
  int_4 _data_k_32;
#define _data_n_32 2
  static complex_8 _data_l_32[_data_n_32] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0)
  };
  if (__calls[52].calls == 0) {
    _data_k_32 = 0;
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    czero_ = _data_l_32[_data_k_32++];
    if (_data_k_32 >= _data_n_32) {
      _data_k_32 = 0;
    }
    cone_ = _data_l_32[_data_k_32++];
  }
  az_ = cabsf ((*z_));
  inu_ = (*fnu_);
  idnu_ = inu_ + (*n_) - 1;
  fdnu_ = idnu_;
  magz_ = az_;
  amagz_ = magz_ + 1;
  fnup_ = _max (amagz_, fdnu_);
  id_ = idnu_ - magz_ - 1;
  itime_ = 1;
  k_ = 1;
  rz_ = (cone_ + cone_) / (*z_);
  t1_ = CMPLXF (fnup_, 0.0) * rz_;
  p2_ = -t1_;
  p1_ = cone_;
  t1_ = t1_ + rz_;
  if (id_ > 0) {
    id_ = 0;
  }
  ap2_ = cabsf (p2_);
  ap1_ = cabsf (p1_);
  arg_ = (ap2_ + ap2_) / (ap1_ * (*tol_));
  test1_ = sqrtf (arg_);
  test_ = test1_;
  rap1_ = 1.0e0 / ap1_;
  p1_ = p1_ * CMPLXF (rap1_, 0.0);
  p2_ = p2_ * CMPLXF (rap1_, 0.0);
  ap2_ = ap2_ * rap1_;
  _l10:;
  k_ = k_ + 1;
  ap1_ = ap2_;
  pt_ = p2_;
  p2_ = p1_ - t1_ * p2_;
  p1_ = pt_;
  t1_ = t1_ + rz_;
  ap2_ = cabsf (p2_);
  if (ap1_ <= test_) {
    goto _l10;
  }
  if (itime_ == 2) {
    goto _l20;
  }
  ak_ = cabsf (t1_) * 0.5e0;
  flam_ = ak_ + sqrtf (ak_ * ak_ - 1.0e0);
  rho_ = _min (ap2_ / ap1_, flam_);
  test_ = test1_ * sqrtf (rho_ / (rho_ * rho_ - 1.0e0));
  itime_ = 2;
  goto _l10;
  _l20:;
  kk_ = k_ + 1 - id_;
  ak_ = kk_;
  dfnu_ = (*fnu_) + ((*n_) - 1);
  cdfnu_ = CMPLXF (dfnu_, 0.0);
  t1_ = CMPLXF (ak_, 0.0);
  p1_ = CMPLXF (1.0e0 / ap2_, 0.0);
  p2_ = czero_;
  for (i_ = 1; i_ <= kk_; (i_)++) {
    pt_ = p1_;
    p1_ = rz_ * (cdfnu_ + t1_) * p1_ + p2_;
    p2_ = pt_;
    t1_ = t1_ - cone_;
  }
  if ((real_4) (crealf (p1_)) != 0.0e0 || cimagf (p1_) != 0.0e0) {
    goto _l40;
  }
  p1_ = CMPLXF ((*tol_), (*tol_));
  _l40:;
  cy_[(*n_) - 1] = p2_ / p1_;
  if ((*n_) == 1) {
    goto _l0;
  }
  k_ = (*n_) - 1;
  ak_ = k_;
  t1_ = CMPLXF (ak_, 0.0);
  cdfnu_ = CMPLXF ((*fnu_), 0.0) * rz_;
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    pt_ = cdfnu_ + t1_ * rz_ + cy_[k_ + 1 - 1];
    if ((real_4) (crealf (pt_)) != 0.0e0 || cimagf (pt_) != 0.0e0) {
      goto _l50;
    }
    pt_ = CMPLXF ((*tol_), (*tol_));
    _l50:;
    cy_[k_ - 1] = cone_ / pt_;
    t1_ = t1_ - cone_;
    k_ = k_ - 1;
  }
  _l0:;
  __calls[52].calls++;
  return 0;
}

int_4 _cs1s2 (complex_8 _p_ zr_, complex_8 _p_ s1_, complex_8 _p_ s2_, int_4 _p_ nz_, real_4 _p_ ascle_, real_4 _p_ 
alim_, int_4 _p_ iuf_)
{
  static real_4 aa_, aln_, as1_, as2_, xx_;
  static complex_8 czero_, c1_, s1d_;
  int_4 _data_k_33;
#define _data_n_33 1
  static complex_8 _data_l_33[_data_n_33] = {
    CMPLXF (0.0, 0.0)
  };
  if (__calls[53].calls == 0) {
    _data_k_33 = 0;
    if (_data_k_33 >= _data_n_33) {
      _data_k_33 = 0;
    }
    czero_ = _data_l_33[_data_k_33++];
  }
  (*nz_) = 0;
  as1_ = cabsf ((*s1_));
  as2_ = cabsf ((*s2_));
  aa_ = (real_4) (crealf ((*s1_)));
  aln_ = cimagf ((*s1_));
  if (aa_ == 0.0e0 && aln_ == 0.0e0) {
    goto _l10;
  }
  if (as1_ == 0.0e0) {
    goto _l10;
  }
  xx_ = (real_4) (crealf ((*zr_)));
  aln_ = -xx_ - xx_ + logf (as1_);
  s1d_ = (*s1_);
  (*s1_) = czero_;
  as1_ = 0.0;
  if (aln_ < (-(*alim_))) {
    goto _l10;
  }
  c1_ = clogf (s1d_) - (*zr_) - (*zr_);
  (*s1_) = cexpf (c1_);
  as1_ = cabsf ((*s1_));
  (*iuf_) = (*iuf_) + 1;
  _l10:;
  aa_ = _max (as1_, as2_);
  if (aa_ > (*ascle_)) {
    goto _l0;
  }
  (*s1_) = czero_;
  (*s2_) = czero_;
  (*nz_) = 1;
  (*iuf_) = 0;
  _l0:;
  __calls[53].calls++;
  return 0;
}

int_4 _cscale (real_4 _p_ a_, int_4 _p_ nrda_, int_4 _p_ nrow_, int_4 _p_ ncol_, real_4 _p_ cols_, real_4 _p_ colsav_, 
real_4 _p_ rows_, real_4 _p_ rowsav_, real_4 _p_ anorm_, real_4 _p_ scales_, int_4 _p_ iscale_, int_4 _p_ ic_)
{
  static int_4 k_, ip_, j_;
  static real_4 ten4_, ten20_, ascale_, cs_, alog2_, p_, s_;
  int_4 _data_k_34;
  extern real_4 _sdot ();
#define _data_n_34 2
  static real_4 _data_l_34[_data_n_34] = {
    1.0e4,
    1.0e20
  };
  if (__calls[54].calls == 0) {
    _data_k_34 = 0;
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    ten4_ = _data_l_34[_data_k_34++];
    if (_data_k_34 >= _data_n_34) {
      _data_k_34 = 0;
    }
    ten20_ = _data_l_34[_data_k_34++];
  }
  if ((*iscale_) != -1) {
    goto _l25;
  }
  if ((*ic_) == 0) {
    goto _l10;
  }
  for (k_ = 1; k_ <= (*ncol_); (k_)++) {
    cols_[k_ - 1] = _sdot (nrow_, &a_[0 + ((*nrda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*nrda_)) * ((k_ - 1))], &_k1);
  }
  _l10:;
  ascale_ = (*anorm_) / (*ncol_);
  for (k_ = 1; k_ <= (*ncol_); (k_)++) {
    cs_ = cols_[k_ - 1];
    if ((cs_ > ten4_ * ascale_) || (ten4_ * cs_ < ascale_)) {
      goto _l50;
    }
    if ((cs_ < 1.0 / ten20_) || (cs_ > ten20_)) {
      goto _l50;
    }
  }
  _l25:;
  for (k_ = 1; k_ <= (*ncol_); (k_)++) {
    scales_[k_ - 1] = 1.0;
  }
  goto _l0;
  _l50:;
  alog2_ = 6.9314718e-1;
  (*anorm_) = 0.0;
  for (k_ = 1; k_ <= (*ncol_); (k_)++) {
    cs_ = cols_[k_ - 1];
    if (cs_ != 0.0) {
      goto _l60;
    }
    scales_[k_ - 1] = 1.0;
    goto _l100;
    _l60:;
    p_ = logf (cs_) / alog2_;
    ip_ = -0.5 * p_;
    s_ = _up_real_4 (2.0, ip_);
    scales_[k_ - 1] = s_;
    if ((*ic_) == 1) {
      goto _l70;
    }
    cols_[k_ - 1] = s_ * s_ * cols_[k_ - 1];
    (*anorm_) = (*anorm_) + cols_[k_ - 1];
    colsav_[k_ - 1] = cols_[k_ - 1];
    _l70:;
    for (j_ = 1; j_ <= (*nrow_); (j_)++) {
      a_[j_ - 1 + ((*nrda_)) * ((k_ - 1))] = s_ * a_[j_ - 1 + ((*nrda_)) * ((k_ - 1))];
    }
    _l100:;
  }
  if ((*ic_) == 0) {
    goto _l0;
  }
  for (k_ = 1; k_ <= (*nrow_); (k_)++) {
    rows_[k_ - 1] = _sdot (ncol_, &a_[k_ - 1 + ((*nrda_)) * ((0))], nrda_, &a_[k_ - 1 + ((*nrda_)) * ((0))], nrda_);
    rowsav_[k_ - 1] = rows_[k_ - 1];
    (*anorm_) = (*anorm_) + rows_[k_ - 1];
  }
  _l0:;
  __calls[54].calls++;
  return 0;
}

int_4 _cshch (complex_8 _p_ z_, complex_8 _p_ csh_, complex_8 _p_ cch_)
{
  static real_4 cchi_, cchr_, ch_, cn_, cshi_, cshr_, sh_, sn_, x_, y_;
  x_ = (real_4) (crealf ((*z_)));
  y_ = cimagf ((*z_));
  sh_ = sinhf (x_);
  ch_ = coshf (x_);
  sn_ = sinf (y_);
  cn_ = cosf (y_);
  cshr_ = sh_ * cn_;
  cshi_ = ch_ * sn_;
  (*csh_) = CMPLXF (cshr_, cshi_);
  cchr_ = ch_ * cn_;
  cchi_ = sh_ * sn_;
  (*cch_) = CMPLXF (cchr_, cchi_);
  __calls[55].calls++;
  return 0;
}

int_4 _cuchk (complex_8 _p_ y_, int_4 _p_ nz_, real_4 _p_ ascle_, real_4 _p_ tol_)
{
  static real_4 ss_, st_, yr_, yi_;
  (*nz_) = 0;
  yr_ = (real_4) (crealf ((*y_)));
  yi_ = cimagf ((*y_));
  yr_ = _abs (yr_);
  yi_ = _abs (yi_);
  st_ = _min (yr_, yi_);
  if (st_ > (*ascle_)) {
    goto _l0;
  }
  ss_ = _max (yr_, yi_);
  st_ = st_ / (*tol_);
  if (ss_ < st_) {
    (*nz_) = 1;
  }
  _l0:;
  __calls[56].calls++;
  return 0;
}

int_4 _cunhj (complex_8 _p_ z_, real_4 _p_ fnu_, int_4 _p_ ipmtr_, real_4 _p_ tol_, complex_8 _p_ phi_, complex_8 _p_ 
arg_, complex_8 _p_ zeta1_, complex_8 _p_ zeta2_, complex_8 _p_ asum_, complex_8 _p_ bsum_)
{
  static int_4 ias_, ibs_, is_, j_, jr_, ju_, k_, kmax_, kp1_, ks_, l_, lr_, lrp1_, l1_, l2_, m_;
  static real_4 alfa_[180], ang_, ap_[30], ar_[14], atol_, aw2_, azth_, beta_[210], br_[14], btol_, c_[105], ex1_, ex2_, 
  fn13_, fn23_, gama_[30], hpi_, pi_, pp_, rfnu_, rfnu2_, thpi_, wi_, wr_, zci_, zcr_, zetai_, zetar_, zthi_, zthr_, 
  asumr_, asumi_, bsumr_, bsumi_, test_, tstr_, tsti_, ac_;
  static complex_8 cfnu_, cone_, cr_[14], czero_, dr_[14], p_[30], przth_, ptfn_, rfn13_, rtzta_, rzth_, suma_, sumb_, 
  tfn_, t2_, up_[14], w_, w2_, za_, zb_, zc_, zeta_, zth_;
  int_4 _data_k_35, _data_k_36, _data_k_37, _data_k_38, _data_k_39, _data_k_40, _data_k_41, _data_k_42, _data_k_43, 
  _data_k_44, _data_k_45, _data_k_46, _data_k_47, _data_k_48, _data_k_49, _data_k_50, _data_k_51, _data_k_52, _data_k_53, 
  _data_k_54, _data_k_55, _data_k_56, _data_k_57, _data_k_58, _data_k_59, _data_k_60, _data_k_61, _data_k_62, _data_k_63, 
  _data_k_64;
  extern real_4 _r1mach ();
#define _data_n_35 14
  static real_4 _data_l_35[_data_n_35] = {
    1.0e+00,
    1.04166666666666667e-1,
    8.35503472222222222e-2,
    1.2822657455632716e-1,
    2.91849026464140464e-1,
    8.81627267443757652e-1,
    3.32140828186276754e+00,
    1.49957629868625547e1,
    7.89230130115865181e1,
    4.74451538868264323e2,
    3.20749009089066193e3,
    2.40865496408740049e4,
    1.98923119169509794e5,
    1.79190200777534383e6
  };
#define _data_n_36 14
  static real_4 _data_l_36[_data_n_36] = {
    1.0e+00,
    -1.45833333333333333e-1,
    -9.87413194444444444e-2,
    -1.43312053915895062e-1,
    -3.17227202678413548e-1,
    -9.42429147957120249e-1,
    -3.51120304082635426e+00,
    -1.57272636203680451e1,
    -8.22814390971859444e1,
    -4.92355370523670524e2,
    -3.31621856854797251e3,
    -2.48276742452085896e4,
    -2.04526587315129788e5,
    -1.8384449170682099e6
  };
#define _data_n_37 24
  static real_4 _data_l_37[_data_n_37] = {
    1.0e+00,
    -2.08333333333333333e-1,
    1.25e-1,
    3.34201388888888889e-1,
    -4.01041666666666667e-1,
    7.03125e-2,
    -1.02581259645061728e+00,
    1.84646267361111111e+00,
    -8.912109375e-1,
    7.32421875e-2,
    4.66958442342624743e+00,
    -1.12070026162229938e1,
    8.78912353515625e+00,
    -2.3640869140625e+00,
    1.12152099609375e-1,
    -2.82120725582002449e1,
    8.46362176746007346e1,
    -9.18182415432400174e1,
    4.25349987453884549e1,
    -7.3687943594796317e+00,
    2.27108001708984375e-1,
    2.12570130039217123e2,
    -7.65252468141181642e2,
    1.05999045252799988e3
  };
#define _data_n_38 24
  static real_4 _data_l_38[_data_n_38] = {
    -6.99579627376132541e2,
    2.1819051174421159e2,
    -2.64914304869515555e1,
    5.72501420974731445e-1,
    -1.919457662318407e3,
    8.06172218173730938e3,
    -1.35865500064341374e4,
    1.16553933368645332e4,
    -5.30564697861340311e3,
    1.20090291321635246e3,
    -1.08090919788394656e2,
    1.7277275025844574e+00,
    2.02042913309661486e4,
    -9.69805983886375135e4,
    1.92547001232531532e5,
    -2.03400177280415534e5,
    1.2220046498301746e5,
    -4.11926549688975513e4,
    7.10951430248936372e3,
    -4.93915304773088012e2,
    6.07404200127348304e+00,
    -2.42919187900551333e5,
    1.3117636146629772e6,
    -2.99801591853810675e6
  };
#define _data_n_39 24
  static real_4 _data_l_39[_data_n_39] = {
    3.763271297656404e6,
    -2.81356322658653411e6,
    1.26836527332162478e6,
    -3.31645172484563578e5,
    4.52187689813627263e4,
    -2.49983048181120962e3,
    2.43805296995560639e1,
    3.28446985307203782e6,
    -1.97068191184322269e7,
    5.09526024926646422e7,
    -7.41051482115326577e7,
    6.63445122747290267e7,
    -3.75671766607633513e7,
    1.32887671664218183e7,
    -2.78561812808645469e6,
    3.08186404612662398e5,
    -1.38860897537170405e4,
    1.10017140269246738e2,
    -4.9329253664509962e7,
    3.25573074185765749e8,
    -9.39462359681578403e8,
    1.55359689957058006e9,
    -1.62108055210833708e9,
    1.10684281682301447e9
  };
#define _data_n_40 24
  static real_4 _data_l_40[_data_n_40] = {
    -4.95889784275030309e8,
    1.42062907797533095e8,
    -2.44740627257387285e7,
    2.24376817792244943e6,
    -8.40054336030240853e4,
    5.51335896122020586e2,
    8.14789096118312115e8,
    -5.86648149205184723e9,
    1.86882075092958249e10,
    -3.46320433881587779e10,
    4.1280185579753974e10,
    -3.30265997498007231e10,
    1.79542137311556001e10,
    -6.56329379261928433e9,
    1.55927986487925751e9,
    -2.25105661889415278e8,
    1.73951075539781645e7,
    -5.49842327572288687e5,
    3.03809051092238427e3,
    -1.46792612476956167e10,
    1.1449823773202581e11,
    -3.99096175224466498e11,
    8.19218669548577329e11,
    -1.09837515608122331e12
  };
#define _data_n_41 9
  static real_4 _data_l_41[_data_n_41] = {
    1.00815810686538209e12,
    -6.45364869245376503e11,
    2.87900649906150589e11,
    -8.78670721780232657e10,
    1.76347306068349694e10,
    -2.16716498322379509e9,
    1.43157876718888981e8,
    -3.87183344257261262e6,
    1.82577554742931747e4
  };
#define _data_n_42 22
  static real_4 _data_l_42[_data_n_42] = {
    -4.44444444444444444e-3,
    -9.22077922077922078e-4,
    -8.84892884892884893e-5,
    1.65927687832449737e-4,
    2.4669137274179291e-4,
    2.6599558934625478e-4,
    2.61824297061500945e-4,
    2.48730437344655609e-4,
    2.32721040083232098e-4,
    2.16362485712365082e-4,
    2.00738858762752355e-4,
    1.86267636637545172e-4,
    1.73060775917876493e-4,
    1.61091705929015752e-4,
    1.50274774160908134e-4,
    1.40503497391269794e-4,
    1.31668816545922806e-4,
    1.23667445598253261e-4,
    1.16405271474737902e-4,
    1.09798298372713369e-4,
    1.03772410422992823e-4,
    9.82626078369363448e-5
  };
#define _data_n_43 22
  static real_4 _data_l_43[_data_n_43] = {
    9.32120517249503256e-5,
    8.85710852478711718e-5,
    8.42963105715700223e-5,
    8.03497548407791151e-5,
    7.66981345359207388e-5,
    7.33122157481777809e-5,
    7.01662625163141333e-5,
    6.72375633790160292e-5,
    6.93735541354588974e-4,
    2.32241745182921654e-4,
    -1.41986273556691197e-5,
    -1.1644493167204864e-4,
    -1.50803558053048762e-4,
    -1.55121924918096223e-4,
    -1.46809756646465549e-4,
    -1.33815503867491367e-4,
    -1.19744975684254051e-4,
    -1.0618431920797402e-4,
    -9.37699549891194492e-5,
    -8.26923045588193274e-5,
    -7.29374348155221211e-5,
    -6.44042357721016283e-5
  };
#define _data_n_44 22
  static real_4 _data_l_44[_data_n_44] = {
    -5.69611566009369048e-5,
    -5.04731044303561628e-5,
    -4.48134868008882786e-5,
    -3.98688727717598864e-5,
    -3.55400532972042498e-5,
    -3.1741425660902248e-5,
    -2.83996793904174811e-5,
    -2.54522720634870566e-5,
    -2.28459297164724555e-5,
    -2.05352753106480604e-5,
    -1.84816217627666085e-5,
    -1.66519330021393806e-5,
    -1.50179412980119482e-5,
    -1.35554031379040526e-5,
    -1.22434746473858131e-5,
    -1.10641884811308169e-5,
    -3.54211971457743841e-4,
    -1.56161263945159416e-4,
    3.0446550359493641e-5,
    1.30198655773242693e-4,
    1.67471106699712269e-4,
    1.70222587683592569e-4
  };
#define _data_n_45 22
  static real_4 _data_l_45[_data_n_45] = {
    1.56501427608594704e-4,
    1.3633917097744512e-4,
    1.14886692029825128e-4,
    9.45869093034688111e-5,
    7.64498419250898258e-5,
    6.07570334965197354e-5,
    4.74394299290508799e-5,
    3.62757512005344297e-5,
    2.69939714979224901e-5,
    1.93210938247939253e-5,
    1.30056674793963203e-5,
    7.82620866744496661e-6,
    3.59257485819351583e-6,
    1.44040049814251817e-7,
    -2.65396769697939116e-6,
    -4.9134686709848591e-6,
    -6.72739296091248287e-6,
    -8.17269379678657923e-6,
    -9.31304715093561232e-6,
    -1.02011418798016441e-5,
    -1.0880596251059288e-5,
    -1.13875481509603555e-5
  };
#define _data_n_46 22
  static real_4 _data_l_46[_data_n_46] = {
    -1.17519675674556414e-5,
    -1.19987364870944141e-5,
    3.78194199201772914e-4,
    2.02471952761816167e-4,
    -6.37938506318862408e-5,
    -2.38598230603005903e-4,
    -3.10916256027361568e-4,
    -3.13680115247576316e-4,
    -2.78950273791323387e-4,
    -2.28564082619141374e-4,
    -1.75245280340846749e-4,
    -1.25544063060690348e-4,
    -8.22982872820208365e-5,
    -4.62860730588116458e-5,
    -1.72334302366962267e-5,
    5.60690482304602267e-6,
    2.313954431482868e-5,
    3.62642745856793957e-5,
    4.58006124490188752e-5,
    5.2459529495911405e-5,
    5.68396208545815266e-5,
    5.94349820393104052e-5
  };
#define _data_n_47 20
  static real_4 _data_l_47[_data_n_47] = {
    6.06478527578421742e-5,
    6.08023907788436497e-5,
    6.01577894539460388e-5,
    5.891996573446985e-5,
    5.72515823777593053e-5,
    5.52804375585852577e-5,
    5.3106377380288017e-5,
    5.08069302012325706e-5,
    4.84418647620094842e-5,
    4.6056858160747537e-5,
    -6.91141397288294174e-4,
    -4.29976633058871912e-4,
    1.83067735980039018e-4,
    6.60088147542014144e-4,
    8.75964969951185931e-4,
    8.77335235958235514e-4,
    7.49369585378990637e-4,
    5.63832329756980918e-4,
    3.68059319971443156e-4,
    1.88464535514455599e-4
  };
#define _data_n_48 20
  static real_4 _data_l_48[_data_n_48] = {
    3.70663057664904149e-5,
    -8.28520220232137023e-5,
    -1.72751952869172998e-4,
    -2.36314873605872983e-4,
    -2.77966150694906658e-4,
    -3.02079514155456919e-4,
    -3.12594712643820127e-4,
    -3.12872558758067163e-4,
    -3.05678038466324377e-4,
    -2.93226470614557331e-4,
    -2.77255655582934777e-4,
    -2.59103928467031709e-4,
    -2.39784014396480342e-4,
    -2.20048260045422848e-4,
    -2.00443911094971498e-4,
    -1.81358692210970687e-4,
    -1.63057674478657464e-4,
    -1.45712672175205844e-4,
    -1.29425421983924587e-4,
    -1.14245691942445952e-4
  };
#define _data_n_49 20
  static real_4 _data_l_49[_data_n_49] = {
    1.92821964248775885e-3,
    1.35592576302022234e-3,
    -7.17858090421302995e-4,
    -2.58084802575270346e-3,
    -3.49271130826168475e-3,
    -3.46986299340960628e-3,
    -2.82285233351310182e-3,
    -1.88103076404891354e-3,
    -8.895317183839476e-4,
    3.87912102631035228e-6,
    7.28688540119691412e-4,
    1.26566373053457758e-3,
    1.62518158372674427e-3,
    1.83203153216373172e-3,
    1.91588388990527909e-3,
    1.90588846755546138e-3,
    1.82798982421825727e-3,
    1.7038950642112153e-3,
    1.55097127171097686e-3,
    1.38261421852276159e-3
  };
#define _data_n_50 10
  static real_4 _data_l_50[_data_n_50] = {
    1.20881424230064774e-3,
    1.03676532638344962e-3,
    8.71437918068619115e-4,
    7.16080155297701002e-4,
    5.72637002558129372e-4,
    4.42089819465802277e-4,
    3.24724948503090564e-4,
    2.20342042730246599e-4,
    1.28412898401353882e-4,
    4.82005924552095464e-5
  };
#define _data_n_51 22
  static real_4 _data_l_51[_data_n_51] = {
    1.79988721413553309e-2,
    5.59964911064388073e-3,
    2.88501402231132779e-3,
    1.80096606761053941e-3,
    1.24753110589199202e-3,
    9.22878876572938311e-4,
    7.14430421727287357e-4,
    5.71787281789704872e-4,
    4.69431007606481533e-4,
    3.93232835462916638e-4,
    3.34818889318297664e-4,
    2.88952148495751517e-4,
    2.52211615549573284e-4,
    2.22280580798883327e-4,
    1.97541838033062524e-4,
    1.76836855019718004e-4,
    1.59316899661821081e-4,
    1.44347930197333986e-4,
    1.31448068119965379e-4,
    1.20245444949302884e-4,
    1.10449144504599392e-4,
    1.01828770740567258e-4
  };
#define _data_n_52 22
  static real_4 _data_l_52[_data_n_52] = {
    9.41998224204237509e-5,
    8.74130545753834437e-5,
    8.13466262162801467e-5,
    7.59002269646219339e-5,
    7.09906300634153481e-5,
    6.65482874842468183e-5,
    6.25146958969275078e-5,
    5.88403394426251749e-5,
    -1.49282953213429172e-3,
    -8.78204709546389328e-4,
    -5.02916549572034614e-4,
    -2.94822138512746025e-4,
    -1.75463996970782828e-4,
    -1.04008550460816434e-4,
    -5.96141953046457895e-5,
    -3.1203892907609834e-5,
    -1.26089735980230047e-5,
    -2.42892608575730389e-7,
    8.05996165414273571e-6,
    1.36507009262147391e-5,
    1.73964125472926261e-5,
    1.9867297884213378e-5
  };
#define _data_n_53 22
  static real_4 _data_l_53[_data_n_53] = {
    2.14463263790822639e-5,
    2.23954659232456514e-5,
    2.28967783814712629e-5,
    2.30785389811177817e-5,
    2.30321976080909144e-5,
    2.28236073720348722e-5,
    2.25005881105292418e-5,
    2.20981015361991429e-5,
    2.16418427448103905e-5,
    2.11507649256220843e-5,
    2.06388749782170737e-5,
    2.01165241997081666e-5,
    1.95913450141179244e-5,
    1.9068936791043674e-5,
    1.85533719641636667e-5,
    1.80475722259674218e-5,
    5.5221307672129279e-4,
    4.47932581552384646e-4,
    2.79520653992020589e-4,
    1.52468156198446602e-4,
    6.93271105657043598e-5,
    1.76258683069991397e-5
  };
#define _data_n_54 22
  static real_4 _data_l_54[_data_n_54] = {
    -1.35744996343269136e-5,
    -3.17972413350427135e-5,
    -4.18861861696693365e-5,
    -4.69004889379141029e-5,
    -4.87665447413787352e-5,
    -4.87010031186735069e-5,
    -4.74755620890086638e-5,
    -4.55813058138628452e-5,
    -4.33309644511266036e-5,
    -4.09230193157750364e-5,
    -3.84822638603221274e-5,
    -3.60857167535410501e-5,
    -3.37793306123367417e-5,
    -3.15888560772109621e-5,
    -2.95269561750807315e-5,
    -2.75978914828335759e-5,
    -2.58006174666883713e-5,
    -2.413083567612802e-5,
    -2.25823509518346033e-5,
    -2.11479656768912971e-5,
    -1.98200638885294927e-5,
    -1.85909870801065077e-5
  };
#define _data_n_55 22
  static real_4 _data_l_55[_data_n_55] = {
    -1.74532699844210224e-5,
    -1.63997823854497997e-5,
    -4.74617796559959808e-4,
    -4.77864567147321487e-4,
    -3.20390228067037603e-4,
    -1.61105016119962282e-4,
    -4.25778101285435204e-5,
    3.44571294294967503e-5,
    7.97092684075674924e-5,
    1.031382367082722e-4,
    1.12466775262204158e-4,
    1.13103642108481389e-4,
    1.08651634848774268e-4,
    1.01437951597661973e-4,
    9.29298396593363896e-5,
    8.40293133016089978e-5,
    7.52727991349134062e-5,
    6.69632521975730872e-5,
    5.92564547323194704e-5,
    5.22169308826975567e-5,
    4.58539485165360646e-5,
    4.01445513891486808e-5
  };
#define _data_n_56 20
  static real_4 _data_l_56[_data_n_56] = {
    3.50481730031328081e-5,
    3.05157995034346659e-5,
    2.64956119950516039e-5,
    2.29363633690998152e-5,
    1.97893056664021636e-5,
    1.70091984636412623e-5,
    1.45547428261524004e-5,
    1.23886640995878413e-5,
    1.04775876076583236e-5,
    8.79179954978479373e-6,
    7.36465810572578444e-4,
    8.72790805146193976e-4,
    6.22614862573135066e-4,
    2.85998154194304147e-4,
    3.84737672879366102e-6,
    -1.87906003636971558e-4,
    -2.97603646594554535e-4,
    -3.45998126832656348e-4,
    -3.53382470916037712e-4,
    -3.35715635775048757e-4
  };
#define _data_n_57 20
  static real_4 _data_l_57[_data_n_57] = {
    -3.04321124789039809e-4,
    -2.66722723047612821e-4,
    -2.27654214122819527e-4,
    -1.89922611854562356e-4,
    -1.5505891859909387e-4,
    -1.2377824076187363e-4,
    -9.62926147717644187e-5,
    -7.25178327714425337e-5,
    -5.22070028895633801e-5,
    -3.50347750511900522e-5,
    -2.06489761035551757e-5,
    -8.70106096849767054e-6,
    1.1369868667510029e-6,
    9.16426474122778849e-6,
    1.5647778542887262e-5,
    2.08223629482466847e-5,
    2.48923381004595156e-5,
    2.80340509574146325e-5,
    3.03987774629861915e-5,
    3.21156731406700616e-5
  };
#define _data_n_58 20
  static real_4 _data_l_58[_data_n_58] = {
    -1.80182191963885708e-3,
    -2.43402962938042533e-3,
    -1.83422663549856802e-3,
    -7.62204596354009765e-4,
    2.39079475256927218e-4,
    9.49266117176881141e-4,
    1.34467449701540359e-3,
    1.48457495259449178e-3,
    1.44732339830617591e-3,
    1.30268261285657186e-3,
    1.10351597375642682e-3,
    8.86047440419791759e-4,
    6.73073208165665473e-4,
    4.77603872856582378e-4,
    3.05991926358789362e-4,
    1.6031569459472163e-4,
    4.00749555270613286e-5,
    -5.66607461635251611e-5,
    -1.32506186772982638e-4,
    -1.90296187989614057e-4
  };
#define _data_n_59 20
  static real_4 _data_l_59[_data_n_59] = {
    -2.32811450376937408e-4,
    -2.62628811464668841e-4,
    -2.82050469867598672e-4,
    -2.93081563192861167e-4,
    -2.97435962176316616e-4,
    -2.96557334239348078e-4,
    -2.91647363312090861e-4,
    -2.83696203837734166e-4,
    -2.73512317095673346e-4,
    -2.6175015580676858e-4,
    6.38585891212050914e-3,
    9.62374215806377941e-3,
    7.61878061207001043e-3,
    2.83219055545628054e-3,
    -2.0984135201272009e-3,
    -5.73826764216626498e-3,
    -7.7080424449541462e-3,
    -8.21011692264844401e-3,
    -7.65824520346905413e-3,
    -6.47209729391045177e-3
  };
#define _data_n_60 20
  static real_4 _data_l_60[_data_n_60] = {
    -4.99132412004966473e-3,
    -3.4561228971313328e-3,
    -2.01785580014170775e-3,
    -7.59430686781961401e-4,
    2.84173631523859138e-4,
    1.10891667586337403e-3,
    1.72901493872728771e-3,
    2.16812590802684701e-3,
    2.45357710494539735e-3,
    2.61281821058334862e-3,
    2.67141039656276912e-3,
    2.6520307339598043e-3,
    2.57411652877287315e-3,
    2.45389126236094427e-3,
    2.30460058071795494e-3,
    2.13684837686712662e-3,
    1.95896528478870911e-3,
    1.77737008679454412e-3,
    1.59690280765839059e-3,
    1.42111975664438546e-3
  };
#define _data_n_61 22
  static real_4 _data_l_61[_data_n_61] = {
    6.29960524947436582e-1,
    2.51984209978974633e-1,
    1.54790300415655846e-1,
    1.10713062416159013e-1,
    8.57309395527394825e-2,
    6.97161316958684292e-2,
    5.86085671893713576e-2,
    5.04698873536310685e-2,
    4.42600580689154809e-2,
    3.93720661543509966e-2,
    3.54283195924455368e-2,
    3.21818857502098231e-2,
    2.94646240791157679e-2,
    2.71581677112934479e-2,
    2.51768272973861779e-2,
    2.34570755306078891e-2,
    2.19508390134907203e-2,
    2.0621082823564624e-2,
    1.94388240897880846e-2,
    1.83810633800683158e-2,
    1.74293213231963172e-2,
    1.65685837786612353e-2
  };
#define _data_n_62 8
  static real_4 _data_l_62[_data_n_62] = {
    1.57865285987918445e-2,
    1.50729501494095594e-2,
    1.44193250839954639e-2,
    1.38184805735341786e-2,
    1.32643378994276568e-2,
    1.27517121970498651e-2,
    1.22761545318762767e-2,
    1.18338262398482403e-2
  };
#define _data_n_63 5
  static real_4 _data_l_63[_data_n_63] = {
    3.33333333333333333e-1,
    6.66666666666666667e-1,
    1.57079632679489662e+00,
    3.14159265358979324e+00,
    4.71238898038468986e+00
  };
#define _data_n_64 2
  static complex_8 _data_l_64[_data_n_64] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0)
  };
  if (__calls[57].calls == 0) {
    _data_k_35 = 0;
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[0] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[1] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[2] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[3] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[4] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[5] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[6] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[7] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[8] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[9] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[10] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[11] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[12] = _data_l_35[_data_k_35++];
    if (_data_k_35 >= _data_n_35) {
      _data_k_35 = 0;
    }
    ar_[13] = _data_l_35[_data_k_35++];
  }
  if (__calls[57].calls == 0) {
    _data_k_36 = 0;
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[0] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[1] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[2] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[3] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[4] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[5] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[6] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[7] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[8] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[9] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[10] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[11] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[12] = _data_l_36[_data_k_36++];
    if (_data_k_36 >= _data_n_36) {
      _data_k_36 = 0;
    }
    br_[13] = _data_l_36[_data_k_36++];
  }
  if (__calls[57].calls == 0) {
    _data_k_37 = 0;
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[0] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[1] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[2] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[3] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[4] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[5] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[6] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[7] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[8] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[9] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[10] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[11] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[12] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[13] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[14] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[15] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[16] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[17] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[18] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[19] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[20] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[21] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[22] = _data_l_37[_data_k_37++];
    if (_data_k_37 >= _data_n_37) {
      _data_k_37 = 0;
    }
    c_[23] = _data_l_37[_data_k_37++];
  }
  if (__calls[57].calls == 0) {
    _data_k_38 = 0;
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[24] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[25] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[26] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[27] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[28] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[29] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[30] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[31] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[32] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[33] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[34] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[35] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[36] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[37] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[38] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[39] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[40] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[41] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[42] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[43] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[44] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[45] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[46] = _data_l_38[_data_k_38++];
    if (_data_k_38 >= _data_n_38) {
      _data_k_38 = 0;
    }
    c_[47] = _data_l_38[_data_k_38++];
  }
  if (__calls[57].calls == 0) {
    _data_k_39 = 0;
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[48] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[49] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[50] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[51] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[52] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[53] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[54] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[55] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[56] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[57] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[58] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[59] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[60] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[61] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[62] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[63] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[64] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[65] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[66] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[67] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[68] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[69] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[70] = _data_l_39[_data_k_39++];
    if (_data_k_39 >= _data_n_39) {
      _data_k_39 = 0;
    }
    c_[71] = _data_l_39[_data_k_39++];
  }
  if (__calls[57].calls == 0) {
    _data_k_40 = 0;
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[72] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[73] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[74] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[75] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[76] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[77] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[78] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[79] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[80] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[81] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[82] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[83] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[84] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[85] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[86] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[87] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[88] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[89] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[90] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[91] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[92] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[93] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[94] = _data_l_40[_data_k_40++];
    if (_data_k_40 >= _data_n_40) {
      _data_k_40 = 0;
    }
    c_[95] = _data_l_40[_data_k_40++];
  }
  if (__calls[57].calls == 0) {
    _data_k_41 = 0;
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[96] = _data_l_41[_data_k_41++];
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[97] = _data_l_41[_data_k_41++];
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[98] = _data_l_41[_data_k_41++];
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[99] = _data_l_41[_data_k_41++];
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[100] = _data_l_41[_data_k_41++];
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[101] = _data_l_41[_data_k_41++];
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[102] = _data_l_41[_data_k_41++];
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[103] = _data_l_41[_data_k_41++];
    if (_data_k_41 >= _data_n_41) {
      _data_k_41 = 0;
    }
    c_[104] = _data_l_41[_data_k_41++];
  }
  if (__calls[57].calls == 0) {
    _data_k_42 = 0;
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[0] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[1] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[2] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[3] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[4] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[5] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[6] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[7] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[8] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[9] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[10] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[11] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[12] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[13] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[14] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[15] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[16] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[17] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[18] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[19] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[20] = _data_l_42[_data_k_42++];
    if (_data_k_42 >= _data_n_42) {
      _data_k_42 = 0;
    }
    alfa_[21] = _data_l_42[_data_k_42++];
  }
  if (__calls[57].calls == 0) {
    _data_k_43 = 0;
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[22] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[23] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[24] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[25] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[26] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[27] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[28] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[29] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[30] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[31] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[32] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[33] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[34] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[35] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[36] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[37] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[38] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[39] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[40] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[41] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[42] = _data_l_43[_data_k_43++];
    if (_data_k_43 >= _data_n_43) {
      _data_k_43 = 0;
    }
    alfa_[43] = _data_l_43[_data_k_43++];
  }
  if (__calls[57].calls == 0) {
    _data_k_44 = 0;
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[44] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[45] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[46] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[47] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[48] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[49] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[50] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[51] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[52] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[53] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[54] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[55] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[56] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[57] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[58] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[59] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[60] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[61] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[62] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[63] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[64] = _data_l_44[_data_k_44++];
    if (_data_k_44 >= _data_n_44) {
      _data_k_44 = 0;
    }
    alfa_[65] = _data_l_44[_data_k_44++];
  }
  if (__calls[57].calls == 0) {
    _data_k_45 = 0;
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[66] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[67] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[68] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[69] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[70] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[71] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[72] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[73] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[74] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[75] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[76] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[77] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[78] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[79] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[80] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[81] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[82] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[83] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[84] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[85] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[86] = _data_l_45[_data_k_45++];
    if (_data_k_45 >= _data_n_45) {
      _data_k_45 = 0;
    }
    alfa_[87] = _data_l_45[_data_k_45++];
  }
  if (__calls[57].calls == 0) {
    _data_k_46 = 0;
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[88] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[89] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[90] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[91] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[92] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[93] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[94] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[95] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[96] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[97] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[98] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[99] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[100] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[101] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[102] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[103] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[104] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[105] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[106] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[107] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[108] = _data_l_46[_data_k_46++];
    if (_data_k_46 >= _data_n_46) {
      _data_k_46 = 0;
    }
    alfa_[109] = _data_l_46[_data_k_46++];
  }
  if (__calls[57].calls == 0) {
    _data_k_47 = 0;
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[110] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[111] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[112] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[113] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[114] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[115] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[116] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[117] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[118] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[119] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[120] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[121] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[122] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[123] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[124] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[125] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[126] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[127] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[128] = _data_l_47[_data_k_47++];
    if (_data_k_47 >= _data_n_47) {
      _data_k_47 = 0;
    }
    alfa_[129] = _data_l_47[_data_k_47++];
  }
  if (__calls[57].calls == 0) {
    _data_k_48 = 0;
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[130] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[131] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[132] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[133] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[134] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[135] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[136] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[137] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[138] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[139] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[140] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[141] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[142] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[143] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[144] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[145] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[146] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[147] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[148] = _data_l_48[_data_k_48++];
    if (_data_k_48 >= _data_n_48) {
      _data_k_48 = 0;
    }
    alfa_[149] = _data_l_48[_data_k_48++];
  }
  if (__calls[57].calls == 0) {
    _data_k_49 = 0;
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[150] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[151] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[152] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[153] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[154] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[155] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[156] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[157] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[158] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[159] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[160] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[161] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[162] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[163] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[164] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[165] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[166] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[167] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[168] = _data_l_49[_data_k_49++];
    if (_data_k_49 >= _data_n_49) {
      _data_k_49 = 0;
    }
    alfa_[169] = _data_l_49[_data_k_49++];
  }
  if (__calls[57].calls == 0) {
    _data_k_50 = 0;
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[170] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[171] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[172] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[173] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[174] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[175] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[176] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[177] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[178] = _data_l_50[_data_k_50++];
    if (_data_k_50 >= _data_n_50) {
      _data_k_50 = 0;
    }
    alfa_[179] = _data_l_50[_data_k_50++];
  }
  if (__calls[57].calls == 0) {
    _data_k_51 = 0;
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[0] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[1] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[2] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[3] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[4] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[5] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[6] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[7] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[8] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[9] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[10] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[11] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[12] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[13] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[14] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[15] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[16] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[17] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[18] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[19] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[20] = _data_l_51[_data_k_51++];
    if (_data_k_51 >= _data_n_51) {
      _data_k_51 = 0;
    }
    beta_[21] = _data_l_51[_data_k_51++];
  }
  if (__calls[57].calls == 0) {
    _data_k_52 = 0;
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[22] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[23] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[24] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[25] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[26] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[27] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[28] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[29] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[30] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[31] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[32] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[33] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[34] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[35] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[36] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[37] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[38] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[39] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[40] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[41] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[42] = _data_l_52[_data_k_52++];
    if (_data_k_52 >= _data_n_52) {
      _data_k_52 = 0;
    }
    beta_[43] = _data_l_52[_data_k_52++];
  }
  if (__calls[57].calls == 0) {
    _data_k_53 = 0;
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[44] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[45] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[46] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[47] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[48] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[49] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[50] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[51] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[52] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[53] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[54] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[55] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[56] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[57] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[58] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[59] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[60] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[61] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[62] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[63] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[64] = _data_l_53[_data_k_53++];
    if (_data_k_53 >= _data_n_53) {
      _data_k_53 = 0;
    }
    beta_[65] = _data_l_53[_data_k_53++];
  }
  if (__calls[57].calls == 0) {
    _data_k_54 = 0;
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[66] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[67] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[68] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[69] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[70] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[71] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[72] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[73] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[74] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[75] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[76] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[77] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[78] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[79] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[80] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[81] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[82] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[83] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[84] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[85] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[86] = _data_l_54[_data_k_54++];
    if (_data_k_54 >= _data_n_54) {
      _data_k_54 = 0;
    }
    beta_[87] = _data_l_54[_data_k_54++];
  }
  if (__calls[57].calls == 0) {
    _data_k_55 = 0;
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[88] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[89] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[90] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[91] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[92] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[93] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[94] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[95] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[96] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[97] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[98] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[99] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[100] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[101] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[102] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[103] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[104] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[105] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[106] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[107] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[108] = _data_l_55[_data_k_55++];
    if (_data_k_55 >= _data_n_55) {
      _data_k_55 = 0;
    }
    beta_[109] = _data_l_55[_data_k_55++];
  }
  if (__calls[57].calls == 0) {
    _data_k_56 = 0;
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[110] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[111] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[112] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[113] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[114] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[115] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[116] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[117] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[118] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[119] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[120] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[121] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[122] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[123] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[124] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[125] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[126] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[127] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[128] = _data_l_56[_data_k_56++];
    if (_data_k_56 >= _data_n_56) {
      _data_k_56 = 0;
    }
    beta_[129] = _data_l_56[_data_k_56++];
  }
  if (__calls[57].calls == 0) {
    _data_k_57 = 0;
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[130] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[131] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[132] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[133] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[134] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[135] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[136] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[137] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[138] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[139] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[140] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[141] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[142] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[143] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[144] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[145] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[146] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[147] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[148] = _data_l_57[_data_k_57++];
    if (_data_k_57 >= _data_n_57) {
      _data_k_57 = 0;
    }
    beta_[149] = _data_l_57[_data_k_57++];
  }
  if (__calls[57].calls == 0) {
    _data_k_58 = 0;
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[150] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[151] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[152] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[153] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[154] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[155] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[156] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[157] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[158] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[159] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[160] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[161] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[162] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[163] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[164] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[165] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[166] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[167] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[168] = _data_l_58[_data_k_58++];
    if (_data_k_58 >= _data_n_58) {
      _data_k_58 = 0;
    }
    beta_[169] = _data_l_58[_data_k_58++];
  }
  if (__calls[57].calls == 0) {
    _data_k_59 = 0;
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[170] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[171] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[172] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[173] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[174] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[175] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[176] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[177] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[178] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[179] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[180] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[181] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[182] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[183] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[184] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[185] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[186] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[187] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[188] = _data_l_59[_data_k_59++];
    if (_data_k_59 >= _data_n_59) {
      _data_k_59 = 0;
    }
    beta_[189] = _data_l_59[_data_k_59++];
  }
  if (__calls[57].calls == 0) {
    _data_k_60 = 0;
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[190] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[191] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[192] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[193] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[194] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[195] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[196] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[197] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[198] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[199] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[200] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[201] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[202] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[203] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[204] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[205] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[206] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[207] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[208] = _data_l_60[_data_k_60++];
    if (_data_k_60 >= _data_n_60) {
      _data_k_60 = 0;
    }
    beta_[209] = _data_l_60[_data_k_60++];
  }
  if (__calls[57].calls == 0) {
    _data_k_61 = 0;
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[0] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[1] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[2] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[3] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[4] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[5] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[6] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[7] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[8] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[9] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[10] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[11] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[12] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[13] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[14] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[15] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[16] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[17] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[18] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[19] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[20] = _data_l_61[_data_k_61++];
    if (_data_k_61 >= _data_n_61) {
      _data_k_61 = 0;
    }
    gama_[21] = _data_l_61[_data_k_61++];
  }
  if (__calls[57].calls == 0) {
    _data_k_62 = 0;
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    gama_[22] = _data_l_62[_data_k_62++];
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    gama_[23] = _data_l_62[_data_k_62++];
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    gama_[24] = _data_l_62[_data_k_62++];
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    gama_[25] = _data_l_62[_data_k_62++];
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    gama_[26] = _data_l_62[_data_k_62++];
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    gama_[27] = _data_l_62[_data_k_62++];
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    gama_[28] = _data_l_62[_data_k_62++];
    if (_data_k_62 >= _data_n_62) {
      _data_k_62 = 0;
    }
    gama_[29] = _data_l_62[_data_k_62++];
  }
  if (__calls[57].calls == 0) {
    _data_k_63 = 0;
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    ex1_ = _data_l_63[_data_k_63++];
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    ex2_ = _data_l_63[_data_k_63++];
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    hpi_ = _data_l_63[_data_k_63++];
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    pi_ = _data_l_63[_data_k_63++];
    if (_data_k_63 >= _data_n_63) {
      _data_k_63 = 0;
    }
    thpi_ = _data_l_63[_data_k_63++];
  }
  if (__calls[57].calls == 0) {
    _data_k_64 = 0;
    if (_data_k_64 >= _data_n_64) {
      _data_k_64 = 0;
    }
    czero_ = _data_l_64[_data_k_64++];
    if (_data_k_64 >= _data_n_64) {
      _data_k_64 = 0;
    }
    cone_ = _data_l_64[_data_k_64++];
  }
  rfnu_ = 1.0e0 / (*fnu_);
  tstr_ = (real_4) (crealf ((*z_)));
  tsti_ = cimagf ((*z_));
  test_ = _r1mach (&_k1) * 1.0e3;
  ac_ = (*fnu_) * test_;
  if (_abs (tstr_) > ac_ || _abs (tsti_) > ac_) {
    goto _l15;
  }
  ac_ = 2.0e0 * _abs (logf (test_)) + (*fnu_);
  (*zeta1_) = CMPLXF (ac_, 0.0);
  (*zeta2_) = CMPLXF ((*fnu_), 0.0);
  (*phi_) = cone_;
  (*arg_) = cone_;
  goto _l0;
  _l15:;
  zb_ = (*z_) * CMPLXF (rfnu_, 0.0);
  rfnu2_ = rfnu_ * rfnu_;
  fn13_ = powl ((*fnu_), ex1_);
  fn23_ = fn13_ * fn13_;
  rfn13_ = CMPLXF (1.0e0 / fn13_, 0.0);
  w2_ = cone_ - zb_ * zb_;
  aw2_ = cabsf (w2_);
  if (aw2_ > 0.25e0) {
    goto _l130;
  }
  k_ = 1;
  p_[0] = cone_;
  suma_ = CMPLXF (gama_[0], 0.0);
  ap_[0] = 1.0;
  if (aw2_ < (*tol_)) {
    goto _l20;
  }
  for (k_ = 2; k_ <= 30; (k_)++) {
    p_[k_ - 1] = p_[k_ - 1 - 1] * w2_;
    suma_ = suma_ + p_[k_ - 1] * CMPLXF (gama_[k_ - 1], 0.0);
    ap_[k_ - 1] = ap_[k_ - 1 - 1] * aw2_;
    if (ap_[k_ - 1] < (*tol_)) {
      goto _l20;
    }
  }
  k_ = 30;
  _l20:;
  kmax_ = k_;
  zeta_ = w2_ * suma_;
  (*arg_) = zeta_ * CMPLXF (fn23_, 0.0);
  za_ = csqrtf (suma_);
  (*zeta2_) = csqrtf (w2_) * CMPLXF ((*fnu_), 0.0);
  (*zeta1_) = (*zeta2_) * (cone_ + zeta_ * za_ * CMPLXF (ex2_, 0.0));
  za_ = za_ + za_;
  (*phi_) = csqrtf (za_) * rfn13_;
  if ((*ipmtr_) == 1) {
    goto _l120;
  }
  sumb_ = czero_;
  for (k_ = 1; k_ <= kmax_; (k_)++) {
    sumb_ = sumb_ + p_[k_ - 1] * CMPLXF (beta_[k_ - 1], 0.0);
  }
  (*asum_) = czero_;
  (*bsum_) = sumb_;
  l1_ = 0;
  l2_ = 30;
  btol_ = (*tol_) * cabsf ((*bsum_));
  atol_ = (*tol_);
  pp_ = 1.0;
  ias_ = 0;
  ibs_ = 0;
  if (rfnu2_ < (*tol_)) {
    goto _l110;
  }
  for (is_ = 2; is_ <= 7; (is_)++) {
    atol_ = atol_ / rfnu2_;
    pp_ = pp_ * rfnu2_;
    if (ias_ == 1) {
      goto _l60;
    }
    suma_ = czero_;
    for (k_ = 1; k_ <= kmax_; (k_)++) {
      m_ = l1_ + k_;
      suma_ = suma_ + p_[k_ - 1] * CMPLXF (alfa_[m_ - 1], 0.0);
      if (ap_[k_ - 1] < atol_) {
        goto _l50;
      }
    }
    _l50:;
    (*asum_) = (*asum_) + suma_ * CMPLXF (pp_, 0.0);
    if (pp_ < (*tol_)) {
      ias_ = 1;
    }
    _l60:;
    if (ibs_ == 1) {
      goto _l90;
    }
    sumb_ = czero_;
    for (k_ = 1; k_ <= kmax_; (k_)++) {
      m_ = l2_ + k_;
      sumb_ = sumb_ + p_[k_ - 1] * CMPLXF (beta_[m_ - 1], 0.0);
      if (ap_[k_ - 1] < atol_) {
        goto _l80;
      }
    }
    _l80:;
    (*bsum_) = (*bsum_) + sumb_ * CMPLXF (pp_, 0.0);
    if (pp_ < btol_) {
      ibs_ = 1;
    }
    _l90:;
    if (ias_ == 1 && ibs_ == 1) {
      goto _l110;
    }
    l1_ = l1_ + 30;
    l2_ = l2_ + 30;
  }
  _l110:;
  (*asum_) = (*asum_) + cone_;
  pp_ = rfnu_ * (real_4) (crealf (rfn13_));
  (*bsum_) = (*bsum_) * CMPLXF (pp_, 0.0);
  _l120:;
  goto _l0;
  _l130:;
  w_ = csqrtf (w2_);
  wr_ = (real_4) (crealf (w_));
  wi_ = cimagf (w_);
  if (wr_ < 0.0e0) {
    wr_ = 0.0;
  }
  if (wi_ < 0.0e0) {
    wi_ = 0.0;
  }
  w_ = CMPLXF (wr_, wi_);
  za_ = (cone_ + w_) / zb_;
  zc_ = clogf (za_);
  zcr_ = (real_4) (crealf (zc_));
  zci_ = cimagf (zc_);
  if (zci_ < 0.0e0) {
    zci_ = 0.0;
  }
  if (zci_ > hpi_) {
    zci_ = hpi_;
  }
  if (zcr_ < 0.0e0) {
    zcr_ = 0.0;
  }
  zc_ = CMPLXF (zcr_, zci_);
  zth_ = (zc_ - w_) * CMPLXF (1.5, 0.0);
  cfnu_ = CMPLXF ((*fnu_), 0.0);
  (*zeta1_) = zc_ * cfnu_;
  (*zeta2_) = w_ * cfnu_;
  azth_ = cabsf (zth_);
  zthr_ = (real_4) (crealf (zth_));
  zthi_ = cimagf (zth_);
  ang_ = thpi_;
  if (zthr_ >= 0.0e0 && zthi_ < 0.0e0) {
    goto _l140;
  }
  ang_ = hpi_;
  if (zthr_ == 0.0e0) {
    goto _l140;
  }
  ang_ = atanf (zthi_ / zthr_);
  if (zthr_ < 0.0e0) {
    ang_ = ang_ + pi_;
  }
  _l140:;
  pp_ = powl (azth_, ex2_);
  ang_ = ang_ * ex2_;
  zetar_ = pp_ * cosf (ang_);
  zetai_ = pp_ * sinf (ang_);
  if (zetai_ < 0.0e0) {
    zetai_ = 0.0;
  }
  zeta_ = CMPLXF (zetar_, zetai_);
  (*arg_) = zeta_ * CMPLXF (fn23_, 0.0);
  rtzta_ = zth_ / zeta_;
  za_ = rtzta_ / w_;
  (*phi_) = csqrtf (za_ + za_) * rfn13_;
  if ((*ipmtr_) == 1) {
    goto _l120;
  }
  tfn_ = CMPLXF (rfnu_, 0.0) / w_;
  rzth_ = CMPLXF (rfnu_, 0.0) / zth_;
  zc_ = rzth_ * CMPLXF (ar_[1], 0.0);
  t2_ = cone_ / w2_;
  up_[1] = (t2_ * CMPLXF (c_[1], 0.0) + CMPLXF (c_[2], 0.0)) * tfn_;
  (*bsum_) = up_[1] + zc_;
  (*asum_) = czero_;
  if (rfnu_ < (*tol_)) {
    goto _l220;
  }
  przth_ = rzth_;
  ptfn_ = tfn_;
  up_[0] = cone_;
  pp_ = 1.0;
  bsumr_ = (real_4) (crealf ((*bsum_)));
  bsumi_ = cimagf ((*bsum_));
  btol_ = (*tol_) * (_abs (bsumr_) + _abs (bsumi_));
  ks_ = 0;
  kp1_ = 2;
  l_ = 3;
  ias_ = 0;
  ibs_ = 0;
  for (lr_ = 2; (2 > 0 ? lr_ <= 12 : lr_ >= 12); lr_ += 2) {
    lrp1_ = lr_ + 1;
    for (k_ = lr_; k_ <= lrp1_; (k_)++) {
      ks_ = ks_ + 1;
      kp1_ = kp1_ + 1;
      l_ = l_ + 1;
      za_ = CMPLXF (c_[l_ - 1], 0.0);
      for (j_ = 2; j_ <= kp1_; (j_)++) {
        l_ = l_ + 1;
        za_ = za_ * t2_ + CMPLXF (c_[l_ - 1], 0.0);
      }
      ptfn_ = ptfn_ * tfn_;
      up_[kp1_ - 1] = ptfn_ * za_;
      cr_[ks_ - 1] = przth_ * CMPLXF (br_[ks_ + 1 - 1], 0.0);
      przth_ = przth_ * rzth_;
      dr_[ks_ - 1] = przth_ * CMPLXF (ar_[ks_ + 2 - 1], 0.0);
    }
    pp_ = pp_ * rfnu2_;
    if (ias_ == 1) {
      goto _l180;
    }
    suma_ = up_[lrp1_ - 1];
    ju_ = lrp1_;
    for (jr_ = 1; jr_ <= lr_; (jr_)++) {
      ju_ = ju_ - 1;
      suma_ = suma_ + cr_[jr_ - 1] * up_[ju_ - 1];
    }
    (*asum_) = (*asum_) + suma_;
    asumr_ = (real_4) (crealf ((*asum_)));
    asumi_ = cimagf ((*asum_));
    test_ = _abs (asumr_) + _abs (asumi_);
    if (pp_ < (*tol_) && test_ < (*tol_)) {
      ias_ = 1;
    }
    _l180:;
    if (ibs_ == 1) {
      goto _l200;
    }
    sumb_ = up_[lr_ + 2 - 1] + up_[lrp1_ - 1] * zc_;
    ju_ = lrp1_;
    for (jr_ = 1; jr_ <= lr_; (jr_)++) {
      ju_ = ju_ - 1;
      sumb_ = sumb_ + dr_[jr_ - 1] * up_[ju_ - 1];
    }
    (*bsum_) = (*bsum_) + sumb_;
    bsumr_ = (real_4) (crealf ((*bsum_)));
    bsumi_ = cimagf ((*bsum_));
    test_ = _abs (bsumr_) + _abs (bsumi_);
    if (pp_ < btol_ && test_ < (*tol_)) {
      ibs_ = 1;
    }
    _l200:;
    if (ias_ == 1 && ibs_ == 1) {
      goto _l220;
    }
  }
  _l220:;
  (*asum_) = (*asum_) + cone_;
  (*bsum_) = -(*bsum_) * rfn13_ / rtzta_;
  goto _l120;
  _l0:;
  __calls[57].calls++;
  return 0;
}

int_4 _cunik (complex_8 _p_ zr_, real_4 _p_ fnu_, int_4 _p_ ikflg_, int_4 _p_ ipmtr_, real_4 _p_ tol_, int_4 _p_ init_, 
complex_8 _p_ phi_, complex_8 _p_ zeta1_, complex_8 _p_ zeta2_, complex_8 _p_ sum_, complex_8 _p_ cwrk_)
{
  static int_4 i_, j_, k_, l_;
  static real_4 ac_, c_[120], rfn_, test_, tstr_, tsti_;
  static complex_8 cfn_, con_[2], cone_, crfn_, czero_, s_, sr_, t_, t2_, zn_;
  int_4 _data_k_65, _data_k_66, _data_k_67, _data_k_68, _data_k_69, _data_k_70, _data_k_71, _data_k_72;
  extern real_4 _r1mach ();
#define _data_n_65 2
  static complex_8 _data_l_65[_data_n_65] = {
    CMPLXF (0.0, 0.0),
    CMPLXF (1.0, 0.0)
  };
#define _data_n_66 2
  static complex_8 _data_l_66[_data_n_66] = {
    CMPLXF (3.9894228e-1, 0.0),
    CMPLXF (1.2533141, 0.0)
  };
#define _data_n_67 24
  static real_4 _data_l_67[_data_n_67] = {
    1.0e+00,
    -2.08333333333333333e-1,
    1.25e-1,
    3.34201388888888889e-1,
    -4.01041666666666667e-1,
    7.03125e-2,
    -1.02581259645061728e+00,
    1.84646267361111111e+00,
    -8.912109375e-1,
    7.32421875e-2,
    4.66958442342624743e+00,
    -1.12070026162229938e1,
    8.78912353515625e+00,
    -2.3640869140625e+00,
    1.12152099609375e-1,
    -2.82120725582002449e1,
    8.46362176746007346e1,
    -9.18182415432400174e1,
    4.25349987453884549e1,
    -7.3687943594796317e+00,
    2.27108001708984375e-1,
    2.12570130039217123e2,
    -7.65252468141181642e2,
    1.05999045252799988e3
  };
#define _data_n_68 24
  static real_4 _data_l_68[_data_n_68] = {
    -6.99579627376132541e2,
    2.1819051174421159e2,
    -2.64914304869515555e1,
    5.72501420974731445e-1,
    -1.919457662318407e3,
    8.06172218173730938e3,
    -1.35865500064341374e4,
    1.16553933368645332e4,
    -5.30564697861340311e3,
    1.20090291321635246e3,
    -1.08090919788394656e2,
    1.7277275025844574e+00,
    2.02042913309661486e4,
    -9.69805983886375135e4,
    1.92547001232531532e5,
    -2.03400177280415534e5,
    1.2220046498301746e5,
    -4.11926549688975513e4,
    7.10951430248936372e3,
    -4.93915304773088012e2,
    6.07404200127348304e+00,
    -2.42919187900551333e5,
    1.3117636146629772e6,
    -2.99801591853810675e6
  };
#define _data_n_69 24
  static real_4 _data_l_69[_data_n_69] = {
    3.763271297656404e6,
    -2.81356322658653411e6,
    1.26836527332162478e6,
    -3.31645172484563578e5,
    4.52187689813627263e4,
    -2.49983048181120962e3,
    2.43805296995560639e1,
    3.28446985307203782e6,
    -1.97068191184322269e7,
    5.09526024926646422e7,
    -7.41051482115326577e7,
    6.63445122747290267e7,
    -3.75671766607633513e7,
    1.32887671664218183e7,
    -2.78561812808645469e6,
    3.08186404612662398e5,
    -1.38860897537170405e4,
    1.10017140269246738e2,
    -4.9329253664509962e7,
    3.25573074185765749e8,
    -9.39462359681578403e8,
    1.55359689957058006e9,
    -1.62108055210833708e9,
    1.10684281682301447e9
  };
#define _data_n_70 24
  static real_4 _data_l_70[_data_n_70] = {
    -4.95889784275030309e8,
    1.42062907797533095e8,
    -2.44740627257387285e7,
    2.24376817792244943e6,
    -8.40054336030240853e4,
    5.51335896122020586e2,
    8.14789096118312115e8,
    -5.86648149205184723e9,
    1.86882075092958249e10,
    -3.46320433881587779e10,
    4.1280185579753974e10,
    -3.30265997498007231e10,
    1.79542137311556001e10,
    -6.56329379261928433e9,
    1.55927986487925751e9,
    -2.25105661889415278e8,
    1.73951075539781645e7,
    -5.49842327572288687e5,
    3.03809051092238427e3,
    -1.46792612476956167e10,
    1.1449823773202581e11,
    -3.99096175224466498e11,
    8.19218669548577329e11,
    -1.09837515608122331e12
  };
#define _data_n_71 22
  static real_4 _data_l_71[_data_n_71] = {
    1.00815810686538209e12,
    -6.45364869245376503e11,
    2.87900649906150589e11,
    -8.78670721780232657e10,
    1.76347306068349694e10,
    -2.16716498322379509e9,
    1.43157876718888981e8,
    -3.87183344257261262e6,
    1.82577554742931747e4,
    2.86464035717679043e11,
    -2.40629790002850396e12,
    9.10934118523989896e12,
    -2.05168994109344374e13,
    3.05651255199353206e13,
    -3.16670885847851584e13,
    2.33483640445818409e13,
    -1.23204913055982872e13,
    4.61272578084913197e12,
    -1.1965528801961816e12,
    2.05914503232410016e11,
    -2.18229277575292237e10,
    1.24700929351271032e9
  };
#define _data_n_72 2
  static real_4 _data_l_72[_data_n_72] = {
    -2.91883881222208134e7,
    1.18838426256783253e5
  };
  if (__calls[58].calls == 0) {
    _data_k_65 = 0;
    if (_data_k_65 >= _data_n_65) {
      _data_k_65 = 0;
    }
    czero_ = _data_l_65[_data_k_65++];
    if (_data_k_65 >= _data_n_65) {
      _data_k_65 = 0;
    }
    cone_ = _data_l_65[_data_k_65++];
  }
  if (__calls[58].calls == 0) {
    _data_k_66 = 0;
    if (_data_k_66 >= _data_n_66) {
      _data_k_66 = 0;
    }
    con_[0] = _data_l_66[_data_k_66++];
    if (_data_k_66 >= _data_n_66) {
      _data_k_66 = 0;
    }
    con_[1] = _data_l_66[_data_k_66++];
  }
  if (__calls[58].calls == 0) {
    _data_k_67 = 0;
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[0] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[1] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[2] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[3] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[4] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[5] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[6] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[7] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[8] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[9] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[10] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[11] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[12] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[13] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[14] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[15] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[16] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[17] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[18] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[19] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[20] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[21] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[22] = _data_l_67[_data_k_67++];
    if (_data_k_67 >= _data_n_67) {
      _data_k_67 = 0;
    }
    c_[23] = _data_l_67[_data_k_67++];
  }
  if (__calls[58].calls == 0) {
    _data_k_68 = 0;
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[24] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[25] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[26] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[27] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[28] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[29] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[30] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[31] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[32] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[33] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[34] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[35] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[36] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[37] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[38] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[39] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[40] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[41] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[42] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[43] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[44] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[45] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[46] = _data_l_68[_data_k_68++];
    if (_data_k_68 >= _data_n_68) {
      _data_k_68 = 0;
    }
    c_[47] = _data_l_68[_data_k_68++];
  }
  if (__calls[58].calls == 0) {
    _data_k_69 = 0;
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[48] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[49] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[50] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[51] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[52] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[53] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[54] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[55] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[56] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[57] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[58] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[59] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[60] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[61] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[62] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[63] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[64] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[65] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[66] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[67] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[68] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[69] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[70] = _data_l_69[_data_k_69++];
    if (_data_k_69 >= _data_n_69) {
      _data_k_69 = 0;
    }
    c_[71] = _data_l_69[_data_k_69++];
  }
  if (__calls[58].calls == 0) {
    _data_k_70 = 0;
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[72] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[73] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[74] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[75] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[76] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[77] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[78] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[79] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[80] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[81] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[82] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[83] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[84] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[85] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[86] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[87] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[88] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[89] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[90] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[91] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[92] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[93] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[94] = _data_l_70[_data_k_70++];
    if (_data_k_70 >= _data_n_70) {
      _data_k_70 = 0;
    }
    c_[95] = _data_l_70[_data_k_70++];
  }
  if (__calls[58].calls == 0) {
    _data_k_71 = 0;
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[96] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[97] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[98] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[99] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[100] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[101] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[102] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[103] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[104] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[105] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[106] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[107] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[108] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[109] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[110] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[111] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[112] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[113] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[114] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[115] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[116] = _data_l_71[_data_k_71++];
    if (_data_k_71 >= _data_n_71) {
      _data_k_71 = 0;
    }
    c_[117] = _data_l_71[_data_k_71++];
  }
  if (__calls[58].calls == 0) {
    _data_k_72 = 0;
    if (_data_k_72 >= _data_n_72) {
      _data_k_72 = 0;
    }
    c_[118] = _data_l_72[_data_k_72++];
    if (_data_k_72 >= _data_n_72) {
      _data_k_72 = 0;
    }
    c_[119] = _data_l_72[_data_k_72++];
  }
  if ((*init_) != 0) {
    goto _l40;
  }
  rfn_ = 1.0e0 / (*fnu_);
  crfn_ = CMPLXF (rfn_, 0.0);
  tstr_ = (real_4) (crealf ((*zr_)));
  tsti_ = cimagf ((*zr_));
  test_ = _r1mach (&_k1) * 1.0e3;
  ac_ = (*fnu_) * test_;
  if (_abs (tstr_) > ac_ || _abs (tsti_) > ac_) {
    goto _l15;
  }
  ac_ = 2.0e0 * _abs (logf (test_)) + (*fnu_);
  (*zeta1_) = CMPLXF (ac_, 0.0);
  (*zeta2_) = CMPLXF ((*fnu_), 0.0);
  (*phi_) = cone_;
  goto _l0;
  _l15:;
  t_ = (*zr_) * crfn_;
  s_ = cone_ + t_ * t_;
  sr_ = csqrtf (s_);
  cfn_ = CMPLXF ((*fnu_), 0.0);
  zn_ = (cone_ + sr_) / t_;
  (*zeta1_) = cfn_ * clogf (zn_);
  (*zeta2_) = cfn_ * sr_;
  t_ = cone_ / sr_;
  sr_ = t_ * crfn_;
  cwrk_[15] = csqrtf (sr_);
  (*phi_) = cwrk_[15] * con_[(*ikflg_) - 1];
  if ((*ipmtr_) != 0) {
    goto _l0;
  }
  t2_ = cone_ / s_;
  cwrk_[0] = cone_;
  crfn_ = cone_;
  ac_ = 1.0;
  l_ = 1;
  for (k_ = 2; k_ <= 15; (k_)++) {
    s_ = czero_;
    for (j_ = 1; j_ <= k_; (j_)++) {
      l_ = l_ + 1;
      s_ = s_ * t2_ + CMPLXF (c_[l_ - 1], 0.0);
    }
    crfn_ = crfn_ * sr_;
    cwrk_[k_ - 1] = crfn_ * s_;
    ac_ = ac_ * rfn_;
    tstr_ = (real_4) (crealf (cwrk_[k_ - 1]));
    tsti_ = cimagf (cwrk_[k_ - 1]);
    test_ = _abs (tstr_) + _abs (tsti_);
    if (ac_ < (*tol_) && test_ < (*tol_)) {
      goto _l30;
    }
  }
  k_ = 15;
  _l30:;
  (*init_) = k_;
  _l40:;
  if ((*ikflg_) == 2) {
    goto _l60;
  }
  s_ = czero_;
  for (i_ = 1; i_ <= (*init_); (i_)++) {
    s_ = s_ + cwrk_[i_ - 1];
  }
  (*sum_) = s_;
  (*phi_) = cwrk_[15] * con_[0];
  goto _l0;
  _l60:;
  s_ = czero_;
  t_ = cone_;
  for (i_ = 1; i_ <= (*init_); (i_)++) {
    s_ = s_ + t_ * cwrk_[i_ - 1];
    t_ = -t_;
  }
  (*sum_) = s_;
  (*phi_) = cwrk_[15] * con_[1];
  _l0:;
  __calls[58].calls++;
  return 0;
}

real_4 _cv (real_4 _p_ xval_, int_4 _p_ ndata_, int_4 _p_ nconst_, int_4 _p_ nord_, int_4 _p_ nbkpt_, real_4 _p_ bkpt_, 
real_4 _p_ w_)
{
  static int_4 mdg_, mdw_, is_, last_, ileft_, ip_, n_, i_;
  static real_4 v_[40], zero_;
  real_4 cv_;
  extern real_4 _sdot ();
  zero_ = 0.0;
  mdg_ = (*nbkpt_) - (*nord_) + 3;
  mdw_ = (*nbkpt_) - (*nord_) + 1 + (*nconst_);
  is_ = mdg_ * ((*nord_) + 1) + 2 * _max ((*ndata_), (*nbkpt_)) + (*nbkpt_) + ((*nord_) * (*nord_));
  last_ = (*nbkpt_) - (*nord_) + 1;
  ileft_ = (*nord_);
  _l10:;
  if (! (((*xval_) >= bkpt_[ileft_ + 1 - 1] && ileft_ < last_ - 1))) {
    goto _l20;
  }
  ileft_ = ileft_ + 1;
  goto _l10;
  _l20:;
  (void) _bsplvn (bkpt_, nord_, &_k1, xval_, &ileft_, &v_[(*nord_) + 1 - 1]);
  ileft_ = ileft_ - (*nord_) + 1;
  ip_ = mdw_ * (ileft_ - 1) + ileft_ + is_;
  n_ = (*nbkpt_) - (*nord_);
  for (i_ = 1; i_ <= (*nord_); (i_)++) {
    v_[i_ - 1] = _sdot (nord_, &w_[ip_ - 1], &_k1, &v_[(*nord_) + 1 - 1], &_k1);
    ip_ = ip_ + mdw_;
  }
  cv_ = _max (_sdot (nord_, v_, &_k1, &v_[(*nord_) + 1 - 1], &_k1), zero_);
  cv_ = cv_ / _max ((*ndata_) - n_, 1);
  __calls[59].calls++;
  return cv_;
}

int_4 _d1merg (real_8 _p_ tcos_, int_4 _p_ i1_, int_4 _p_ m1_, int_4 _p_ i2_, int_4 _p_ m2_, int_4 _p_ i3_)
{
  static int_4 j1_, j2_, j3_;
  int_4 $0_, $1_;
  if ((*m1_) == 0 && (*m2_) == 0) {
    goto _l0;
  }
  if ((*m1_) == 0 && (*m2_) != 0) {
    (void) _dcopy (m2_, &tcos_[(*i2_) + 1 - 1], &_k1, &tcos_[(*i3_) + 1 - 1], &_k1);
    goto _l0;
  }
  if ((*m1_) != 0 && (*m2_) == 0) {
    (void) _dcopy (m1_, &tcos_[(*i1_) + 1 - 1], &_k1, &tcos_[(*i3_) + 1 - 1], &_k1);
    goto _l0;
  }
  j1_ = 1;
  j2_ = 1;
  j3_ = 1;
  _l10:;
  if (tcos_[(*i1_) + j1_ - 1] <= tcos_[(*i2_) + j2_ - 1]) {
    tcos_[(*i3_) + j3_ - 1] = tcos_[(*i1_) + j1_ - 1];
    j1_ = j1_ + 1;
    if (j1_ > (*m1_)) {
      (void) _dcopy (($0_ = (*m2_) - j2_ + 1, &$0_), &tcos_[(*i2_) + j2_ - 1], &_k1, &tcos_[(*i3_) + j3_ + 1 - 1], &_k1);
      goto _l0;
    }
  }
  else {
    tcos_[(*i3_) + j3_ - 1] = tcos_[(*i2_) + j2_ - 1];
    j2_ = j2_ + 1;
    if (j2_ > (*m2_)) {
      (void) _dcopy (($1_ = (*m1_) - j1_ + 1, &$1_), &tcos_[(*i1_) + j1_ - 1], &_k1, &tcos_[(*i3_) + j3_ + 1 - 1], &_k1);
      goto _l0;
    }
  }
  j3_ = j3_ + 1;
  goto _l10;
  _l0:;
  __calls[60].calls++;
  return 0;
}

int_4 _d1mpyq (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ a_, int_4 _p_ lda_, real_8 _p_ v_, real_8 _p_ w_)
{
  static int_4 i_, j_, nm1_, nmj_;
  static real_8 cos_, one_, sin_, temp_;
  int_4 _data_k_73;
#define _data_n_73 1
  static real_8 _data_l_73[_data_n_73] = {
    1.0e0
  };
  if (__calls[61].calls == 0) {
    _data_k_73 = 0;
    if (_data_k_73 >= _data_n_73) {
      _data_k_73 = 0;
    }
    one_ = _data_l_73[_data_k_73++];
  }
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l50;
  }
  for (nmj_ = 1; nmj_ <= nm1_; (nmj_)++) {
    j_ = (*n_) - nmj_;
    if (_abs (v_[j_ - 1]) > one_) {
      cos_ = one_ / v_[j_ - 1];
    }
    if (_abs (v_[j_ - 1]) > one_) {
      sin_ = sqrt (one_ - (cos_ * cos_));
    }
    if (_abs (v_[j_ - 1]) <= one_) {
      sin_ = v_[j_ - 1];
    }
    if (_abs (v_[j_ - 1]) <= one_) {
      cos_ = sqrt (one_ - (sin_ * sin_));
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      temp_ = cos_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] - sin_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))];
      a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] = sin_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + cos_ * a_[i_ - 1 + ((*lda_)) * 
      (((*n_) - 1))];
      a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
    }
  }
  for (j_ = 1; j_ <= nm1_; (j_)++) {
    if (_abs (w_[j_ - 1]) > one_) {
      cos_ = one_ / w_[j_ - 1];
    }
    if (_abs (w_[j_ - 1]) > one_) {
      sin_ = sqrt (one_ - (cos_ * cos_));
    }
    if (_abs (w_[j_ - 1]) <= one_) {
      sin_ = w_[j_ - 1];
    }
    if (_abs (w_[j_ - 1]) <= one_) {
      cos_ = sqrt (one_ - (sin_ * sin_));
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      temp_ = cos_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + sin_ * a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))];
      a_[i_ - 1 + ((*lda_)) * (((*n_) - 1))] = -sin_ * a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] + cos_ * a_[i_ - 1 + ((*lda_)) * 
      (((*n_) - 1))];
      a_[i_ - 1 + ((*lda_)) * ((j_ - 1))] = temp_;
    }
  }
  _l50:;
  __calls[61].calls++;
  return 0;
}

int_4 _d1updt (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ s_, int_4 _p_ ls_, real_8 _p_ u_, real_8 _p_ v_, real_8 _p_ w_, 
logical_4 _p_ sing_)
{
  static int_4 i_, j_, jj_, l_, nm1_, nmj_;
  static real_8 cos_, cotan_, giant_, one_, p25_, p5_, sin_, tan_, tau_, temp_, zero_;
  int_4 _data_k_74, $0_;
  extern real_8 _d1mach ();
#define _data_n_74 4
  static real_8 _data_l_74[_data_n_74] = {
    1.0e0,
    5.0e-1,
    2.5e-1,
    0.0e0
  };
  if (__calls[62].calls == 0) {
    _data_k_74 = 0;
    if (_data_k_74 >= _data_n_74) {
      _data_k_74 = 0;
    }
    one_ = _data_l_74[_data_k_74++];
    if (_data_k_74 >= _data_n_74) {
      _data_k_74 = 0;
    }
    p5_ = _data_l_74[_data_k_74++];
    if (_data_k_74 >= _data_n_74) {
      _data_k_74 = 0;
    }
    p25_ = _data_l_74[_data_k_74++];
    if (_data_k_74 >= _data_n_74) {
      _data_k_74 = 0;
    }
    zero_ = _data_l_74[_data_k_74++];
  }
  giant_ = _d1mach (($0_ = 2, &$0_));
  jj_ = ((*n_) * (2 * (*m_) - (*n_) + 1)) / 2 - ((*m_) - (*n_));
  l_ = jj_;
  for (i_ = (*n_); i_ <= (*m_); (i_)++) {
    w_[i_ - 1] = s_[l_ - 1];
    l_ = l_ + 1;
  }
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l70;
  }
  for (nmj_ = 1; nmj_ <= nm1_; (nmj_)++) {
    j_ = (*n_) - nmj_;
    jj_ = jj_ - ((*m_) - j_ + 1);
    w_[j_ - 1] = zero_;
    if (v_[j_ - 1] == zero_) {
      goto _l50;
    }
    if (_abs (v_[(*n_) - 1]) >= _abs (v_[j_ - 1])) {
      goto _l20;
    }
    cotan_ = v_[(*n_) - 1] / v_[j_ - 1];
    sin_ = p5_ / sqrt (p25_ + p25_ * (cotan_ * cotan_));
    cos_ = sin_ * cotan_;
    tau_ = one_;
    if (_abs (cos_) * giant_ > one_) {
      tau_ = one_ / cos_;
    }
    goto _l30;
    _l20:;
    tan_ = v_[j_ - 1] / v_[(*n_) - 1];
    cos_ = p5_ / sqrt (p25_ + p25_ * (tan_ * tan_));
    sin_ = cos_ * tan_;
    tau_ = sin_;
    _l30:;
    v_[(*n_) - 1] = sin_ * v_[j_ - 1] + cos_ * v_[(*n_) - 1];
    v_[j_ - 1] = tau_;
    l_ = jj_;
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      temp_ = cos_ * s_[l_ - 1] - sin_ * w_[i_ - 1];
      w_[i_ - 1] = sin_ * s_[l_ - 1] + cos_ * w_[i_ - 1];
      s_[l_ - 1] = temp_;
      l_ = l_ + 1;
    }
    _l50:;
  }
  _l70:;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    w_[i_ - 1] = w_[i_ - 1] + v_[(*n_) - 1] * u_[i_ - 1];
  }
  (*sing_) = FALSE;
  if (nm1_ < 1) {
    goto _l140;
  }
  for (j_ = 1; j_ <= nm1_; (j_)++) {
    if (w_[j_ - 1] == zero_) {
      goto _l120;
    }
    if (_abs (s_[jj_ - 1]) >= _abs (w_[j_ - 1])) {
      goto _l90;
    }
    cotan_ = s_[jj_ - 1] / w_[j_ - 1];
    sin_ = p5_ / sqrt (p25_ + p25_ * (cotan_ * cotan_));
    cos_ = sin_ * cotan_;
    tau_ = one_;
    if (_abs (cos_) * giant_ > one_) {
      tau_ = one_ / cos_;
    }
    goto _l100;
    _l90:;
    tan_ = w_[j_ - 1] / s_[jj_ - 1];
    cos_ = p5_ / sqrt (p25_ + p25_ * (tan_ * tan_));
    sin_ = cos_ * tan_;
    tau_ = sin_;
    _l100:;
    l_ = jj_;
    for (i_ = j_; i_ <= (*m_); (i_)++) {
      temp_ = cos_ * s_[l_ - 1] + sin_ * w_[i_ - 1];
      w_[i_ - 1] = -sin_ * s_[l_ - 1] + cos_ * w_[i_ - 1];
      s_[l_ - 1] = temp_;
      l_ = l_ + 1;
    }
    w_[j_ - 1] = tau_;
    _l120:;
    if (s_[jj_ - 1] == zero_) {
      (*sing_) = TRUE;
    }
    jj_ = jj_ + ((*m_) - j_ + 1);
  }
  _l140:;
  l_ = jj_;
  for (i_ = (*n_); i_ <= (*m_); (i_)++) {
    s_[l_ - 1] = w_[i_ - 1];
    l_ = l_ + 1;
  }
  if (s_[jj_ - 1] == zero_) {
    (*sing_) = TRUE;
  }
  __calls[62].calls++;
  return 0;
}

int_4 _dasyik (real_8 _p_ x_, real_8 _p_ fnu_, int_4 _p_ kode_, real_8 _p_ flgik_, real_8 _p_ ra_, real_8 _p_ arg_, 
int_4 _p_ in_, real_8 _p_ y_)
{
  static int_4 j_, jn_, k_, kk_, l_;
  static real_8 ak_, ap_, c_[65], coef_, con_[2], etx_, fn_, gln_, s1_, s2_, t_, tol_, t2_, z_;
  int_4 _data_k_75, _data_k_76, _data_k_77, _data_k_78, $0_;
  extern real_8 _d1mach ();
#define _data_n_75 2
  static real_8 _data_l_75[_data_n_75] = {
    3.98942280401432678e-1,
    1.25331413731550025e+00
  };
#define _data_n_76 24
  static real_8 _data_l_76[_data_n_76] = {
    -2.08333333333333e-1,
    1.25e-1,
    3.34201388888889e-1,
    -4.01041666666667e-1,
    7.03125e-2,
    -1.02581259645062e+00,
    1.84646267361111e+00,
    -8.912109375e-1,
    7.32421875e-2,
    4.66958442342625e+00,
    -1.1207002616223e1,
    8.78912353515625e+00,
    -2.3640869140625e+00,
    1.12152099609375e-1,
    -2.82120725582002e1,
    8.46362176746007e1,
    -9.181824154324e1,
    4.25349987453885e1,
    -7.36879435947963e+00,
    2.27108001708984e-1,
    2.12570130039217e2,
    -7.65252468141182e2,
    1.059990452528e3,
    -6.99579627376133e2
  };
#define _data_n_77 24
  static real_8 _data_l_77[_data_n_77] = {
    2.18190511744212e2,
    -2.64914304869516e1,
    5.72501420974731e-1,
    -1.91945766231841e3,
    8.06172218173731e3,
    -1.35865500064341e4,
    1.16553933368645e4,
    -5.3056469786134e3,
    1.20090291321635e3,
    -1.08090919788395e2,
    1.72772750258446e+00,
    2.02042913309661e4,
    -9.69805983886375e4,
    1.92547001232532e5,
    -2.03400177280416e5,
    1.22200464983017e5,
    -4.11926549688976e4,
    7.10951430248936e3,
    -4.93915304773088e2,
    6.07404200127348e+00,
    -2.42919187900551e5,
    1.31176361466298e6,
    -2.99801591853811e6,
    3.7632712976564e6
  };
#define _data_n_78 17
  static real_8 _data_l_78[_data_n_78] = {
    -2.81356322658653e6,
    1.26836527332162e6,
    -3.31645172484564e5,
    4.52187689813627e4,
    -2.49983048181121e3,
    2.43805296995561e1,
    3.28446985307204e6,
    -1.97068191184322e7,
    5.09526024926646e7,
    -7.41051482115327e7,
    6.6344512274729e7,
    -3.75671766607634e7,
    1.32887671664218e7,
    -2.78561812808645e6,
    3.08186404612662e5,
    -1.3886089753717e4,
    1.10017140269247e2
  };
  if (__calls[63].calls == 0) {
    _data_k_75 = 0;
    if (_data_k_75 >= _data_n_75) {
      _data_k_75 = 0;
    }
    con_[0] = _data_l_75[_data_k_75++];
    if (_data_k_75 >= _data_n_75) {
      _data_k_75 = 0;
    }
    con_[1] = _data_l_75[_data_k_75++];
  }
  if (__calls[63].calls == 0) {
    _data_k_76 = 0;
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[0] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[1] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[2] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[3] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[4] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[5] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[6] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[7] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[8] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[9] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[10] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[11] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[12] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[13] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[14] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[15] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[16] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[17] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[18] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[19] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[20] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[21] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[22] = _data_l_76[_data_k_76++];
    if (_data_k_76 >= _data_n_76) {
      _data_k_76 = 0;
    }
    c_[23] = _data_l_76[_data_k_76++];
  }
  if (__calls[63].calls == 0) {
    _data_k_77 = 0;
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[24] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[25] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[26] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[27] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[28] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[29] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[30] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[31] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[32] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[33] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[34] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[35] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[36] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[37] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[38] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[39] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[40] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[41] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[42] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[43] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[44] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[45] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[46] = _data_l_77[_data_k_77++];
    if (_data_k_77 >= _data_n_77) {
      _data_k_77 = 0;
    }
    c_[47] = _data_l_77[_data_k_77++];
  }
  if (__calls[63].calls == 0) {
    _data_k_78 = 0;
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[48] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[49] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[50] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[51] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[52] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[53] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[54] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[55] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[56] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[57] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[58] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[59] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[60] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[61] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[62] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[63] = _data_l_78[_data_k_78++];
    if (_data_k_78 >= _data_n_78) {
      _data_k_78 = 0;
    }
    c_[64] = _data_l_78[_data_k_78++];
  }
  tol_ = _d1mach (($0_ = 3, &$0_));
  tol_ = _max (tol_, 1.0e-15);
  fn_ = (*fnu_);
  z_ = (3.0e0 - (*flgik_)) / 2.0e0;
  kk_ = (int_4) (_aintd (z_));
  for (jn_ = 1; jn_ <= (*in_); (jn_)++) {
    if (jn_ == 1) {
      goto _l10;
    }
    fn_ = fn_ - (*flgik_);
    z_ = (*x_) / fn_;
    (*ra_) = sqrt (1.0e0 + z_ * z_);
    gln_ = log ((1.0e0 + (*ra_)) / z_);
    etx_ = (*kode_) - 1;
    t_ = (*ra_) * (1.0e0 - etx_) + etx_ / (z_ + (*ra_));
    (*arg_) = fn_ * (t_ - gln_) * (*flgik_);
    _l10:;
    coef_ = exp ((*arg_));
    t_ = 1.0e0 / (*ra_);
    t2_ = t_ * t_;
    t_ = t_ / fn_;
    t_ = _sign (t_, (*flgik_));
    s2_ = 1.0;
    ap_ = 1.0;
    l_ = 0;
    for (k_ = 2; k_ <= 11; (k_)++) {
      l_ = l_ + 1;
      s1_ = c_[l_ - 1];
      for (j_ = 2; j_ <= k_; (j_)++) {
        l_ = l_ + 1;
        s1_ = s1_ * t2_ + c_[l_ - 1];
      }
      ap_ = ap_ * t_;
      ak_ = ap_ * s1_;
      s2_ = s2_ + ak_;
      if (_max (_abs (ak_), _abs (ap_)) < tol_) {
        goto _l40;
      }
    }
    _l40:;
    t_ = _abs (t_);
    y_[jn_ - 1] = s2_ * coef_ * sqrt (t_) * con_[kk_ - 1];
  }
  __calls[63].calls++;
  return 0;
}

int_4 _davint (real_8 _p_ x_, real_8 _p_ y_, int_4 _p_ n_, real_8 _p_ xlo_, real_8 _p_ xup_, real_8 _p_ ans_, int_4 _p_ 
ierr_)
{
  static int_4 i_, inlft_, inrt_, istart_, istop_;
  static real_8 a_, b_, c_, ca_, cb_, cc_, fl_, fr_, r3_, rp5_, slope_, sum_, syl_, syl2_, syl3_, syu_, syu2_, syu3_, 
  term1_, term2_, term3_, x1_, x12_, x13_, x2_, x23_, x3_;
  int_4 $0_, $2_, $4_, $6_, $8_, $10_;
  char_127 $1_, $3_, $5_, $7_, $9_;
  (*ierr_) = 1;
  (*ans_) = 0.0;
  if ((*xlo_) > (*xup_)) {
    goto _l160;
  }
  if ((*xlo_) == (*xup_)) {
    goto _l150;
  }
  if ((*n_) >= 2) {
    goto _l10;
  }
  (*ierr_) = 5;
  (void) _xermsg (_dc_1, _dc_49, _dc_9, ($0_ = 4, &$0_), &_k1);
  goto _l190;
  _l10:;
  for (i_ = 2; i_ <= (*n_); (i_)++) {
    if (x_[i_ - 1] <= x_[i_ - 1 - 1]) {
      goto _l180;
    }
    if (x_[i_ - 1] > (*xup_)) {
      goto _l30;
    }
  }
  _l30:;
  if ((*n_) >= 3) {
    goto _l40;
  }
  slope_ = (y_[1] - y_[0]) / (x_[1] - x_[0]);
  fl_ = y_[0] + slope_ * ((*xlo_) - x_[0]);
  fr_ = y_[1] + slope_ * ((*xup_) - x_[1]);
  (*ans_) = 0.5e0 * (fl_ + fr_) * ((*xup_) - (*xlo_));
  goto _l190;
  _l40:;
  if (x_[(*n_) - 2 - 1] >= (*xlo_)) {
    goto _l50;
  }
  (*ierr_) = 3;
  (void) _xermsg (_dc_1, _dc_49, concat ($1_, _dc_50, _dc_51), ($2_ = 4, &$2_), &_k1);
  goto _l190;
  _l50:;
  if (x_[2] <= (*xup_)) {
    goto _l60;
  }
  (*ierr_) = 3;
  (void) _xermsg (_dc_1, _dc_49, concat ($3_, _dc_50, _dc_51), ($4_ = 4, &$4_), &_k1);
  goto _l190;
  _l60:;
  i_ = 1;
  _l70:;
  if (x_[i_ - 1] >= (*xlo_)) {
    goto _l80;
  }
  i_ = i_ + 1;
  goto _l70;
  _l80:;
  inlft_ = i_;
  i_ = (*n_);
  _l90:;
  if (x_[i_ - 1] <= (*xup_)) {
    goto _l100;
  }
  i_ = i_ - 1;
  goto _l90;
  _l100:;
  inrt_ = i_;
  if ((inrt_ - inlft_) >= 2) {
    goto _l110;
  }
  (*ierr_) = 3;
  (void) _xermsg (_dc_1, _dc_49, concat ($5_, _dc_50, _dc_51), ($6_ = 4, &$6_), &_k1);
  goto _l190;
  _l110:;
  istart_ = inlft_;
  if (inlft_ == 1) {
    istart_ = 2;
  }
  istop_ = inrt_;
  if (inrt_ == (*n_)) {
    istop_ = (*n_) - 1;
  }
  r3_ = 3.0;
  rp5_ = 0.5;
  sum_ = 0.0;
  syl_ = (*xlo_);
  syl2_ = syl_ * syl_;
  syl3_ = syl2_ * syl_;
  for (i_ = istart_; i_ <= istop_; (i_)++) {
    x1_ = x_[i_ - 1 - 1];
    x2_ = x_[i_ - 1];
    x3_ = x_[i_ + 1 - 1];
    x12_ = x1_ - x2_;
    x13_ = x1_ - x3_;
    x23_ = x2_ - x3_;
    term1_ = y_[i_ - 1 - 1] / (x12_ * x13_);
    term2_ = -y_[i_ - 1] / (x12_ * x23_);
    term3_ = y_[i_ + 1 - 1] / (x13_ * x23_);
    a_ = term1_ + term2_ + term3_;
    b_ = -(x2_ + x3_) * term1_ - (x1_ + x3_) * term2_ - (x1_ + x2_) * term3_;
    c_ = x2_ * x3_ * term1_ + x1_ * x3_ * term2_ + x1_ * x2_ * term3_;
    if (i_ > istart_) {
      goto _l120;
    }
    ca_ = a_;
    cb_ = b_;
    cc_ = c_;
    goto _l130;
    _l120:;
    ca_ = 0.5e0 * (a_ + ca_);
    cb_ = 0.5e0 * (b_ + cb_);
    cc_ = 0.5e0 * (c_ + cc_);
    _l130:;
    syu_ = x2_;
    syu2_ = syu_ * syu_;
    syu3_ = syu2_ * syu_;
    sum_ = sum_ + ca_ * (syu3_ - syl3_) / r3_ + cb_ * rp5_ * (syu2_ - syl2_) + cc_ * (syu_ - syl_);
    ca_ = a_;
    cb_ = b_;
    cc_ = c_;
    syl_ = syu_;
    syl2_ = syu2_;
    syl3_ = syu3_;
  }
  syu_ = (*xup_);
  (*ans_) = sum_ + ca_ * ((syu_ * syu_ * syu_) - syl3_) / r3_ + cb_ * rp5_ * ((syu_ * syu_) - syl2_) + cc_ * (syu_ - 
  syl_);
  _l150:;
  goto _l170;
  _l160:;
  (*ierr_) = 2;
  (void) _xermsg (_dc_1, _dc_49, concat ($7_, _dc_52, _dc_53), ($8_ = 4, &$8_), &_k1);
  _l170:;
  goto _l190;
  _l180:;
  (*ierr_) = 4;
  (void) _xermsg (_dc_1, _dc_49, concat ($9_, _dc_7, _dc_8), ($10_ = 4, &$10_), &_k1);
  _l190:;
  __calls[64].calls++;
  return 0;
}

int_4 _dbdiff (int_4 _p_ l_, real_8 _p_ v_)
{
  static int_4 i_, j_, k_;
  if ((*l_) == 1) {
    goto _l0;
  }
  for (j_ = 2; j_ <= (*l_); (j_)++) {
    k_ = (*l_);
    for (i_ = j_; i_ <= (*l_); (i_)++) {
      v_[k_ - 1] = v_[k_ - 1 - 1] - v_[k_ - 1];
      k_ = k_ - 1;
    }
  }
  _l0:;
  __calls[65].calls++;
  return 0;
}

int_4 _dbksol (int_4 _p_ n_, real_8 _p_ a_, real_8 _p_ x_)
{
  static int_4 j_, k_, m_, nm1_;
  extern real_8 _ddot ();
  m_ = ((*n_) * ((*n_) + 1)) / 2;
  x_[(*n_) - 1] = x_[(*n_) - 1] * a_[m_ - 1];
  nm1_ = (*n_) - 1;
  if (nm1_ < 1) {
    goto _l20;
  }
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    j_ = (*n_) - k_;
    m_ = m_ - k_ - 1;
    x_[j_ - 1] = x_[j_ - 1] * a_[m_ - 1] - _ddot (&k_, &a_[m_ + 1 - 1], &_k1, &x_[j_ + 1 - 1], &_k1);
  }
  _l20:;
  __calls[66].calls++;
  return 0;
}

int_4 _dbndac (real_8 _p_ g_, int_4 _p_ mdg_, int_4 _p_ nb_, int_4 _p_ ip_, int_4 _p_ ir_, int_4 _p_ mt_, int_4 _p_ jt_
)
{
  static int_4 nbp1_, nerr_, iopt_, i_, ig1_, ig2_, j_, ie_, ig_, mu_, l_, k_, lp1_, jg_, mh_, kh_;
  static real_8 zero_, rho_;
  int_4 $0_, $1_;
  zero_ = 0.0;
  nbp1_ = (*nb_) + 1;
  if ((*mt_) <= 0 || (*nb_) <= 0) {
    goto _l0;
  }
  if (! ((*mdg_) < (*ir_))) {
    goto _l5;
  }
  nerr_ = 1;
  iopt_ = 2;
  (void) _xermsg (_dc_1, _dc_54, _dc_11, &nerr_, &iopt_);
  goto _l0;
  _l5:;
  if ((*jt_) == (*ip_)) {
    goto _l70;
  }
  if ((*jt_) <= (*ir_)) {
    goto _l30;
  }
  for (i_ = 1; i_ <= (*mt_); (i_)++) {
    ig1_ = (*jt_) + (*mt_) - i_;
    ig2_ = (*ir_) + (*mt_) - i_;
    for (j_ = 1; j_ <= nbp1_; (j_)++) {
      g_[ig1_ - 1 + ((*mdg_)) * ((j_ - 1))] = g_[ig2_ - 1 + ((*mdg_)) * ((j_ - 1))];
    }
  }
  ie_ = (*jt_) - (*ir_);
  for (i_ = 1; i_ <= ie_; (i_)++) {
    ig_ = (*ir_) + i_ - 1;
    for (j_ = 1; j_ <= nbp1_; (j_)++) {
      g_[ig_ - 1 + ((*mdg_)) * ((j_ - 1))] = zero_;
    }
  }
  (*ir_) = (*jt_);
  _l30:;
  mu_ = _min ((*nb_) - 1, (*ir_) - (*ip_) - 1);
  if (mu_ == 0) {
    goto _l60;
  }
  for (l_ = 1; l_ <= mu_; (l_)++) {
    k_ = _min (l_, (*jt_) - (*ip_));
    lp1_ = l_ + 1;
    ig_ = (*ip_) + l_;
    for (i_ = lp1_; i_ <= (*nb_); (i_)++) {
      jg_ = i_ - k_;
      g_[ig_ - 1 + ((*mdg_)) * ((jg_ - 1))] = g_[ig_ - 1 + ((*mdg_)) * ((i_ - 1))];
    }
    for (i_ = 1; i_ <= k_; (i_)++) {
      jg_ = nbp1_ - i_;
      g_[ig_ - 1 + ((*mdg_)) * ((jg_ - 1))] = zero_;
    }
  }
  _l60:;
  (*ip_) = (*jt_);
  _l70:;
  mh_ = (*ir_) + (*mt_) - (*ip_);
  kh_ = _min (nbp1_, mh_);
  for (i_ = 1; i_ <= kh_; (i_)++) {
    (void) _dh12 (&_k1, &i_, ($0_ = _max (i_ + 1, (*ir_) - (*ip_) + 1), &$0_), &mh_, &g_[(*ip_) - 1 + ((*mdg_)) * ((i_ - 
    1))], &_k1, &rho_, &g_[(*ip_) - 1 + ((*mdg_)) * ((i_ + 1 - 1))], &_k1, mdg_, ($1_ = nbp1_ - i_, &$1_));
  }
  (*ir_) = (*ip_) + kh_;
  if (kh_ < nbp1_) {
    goto _l100;
  }
  for (i_ = 1; i_ <= (*nb_); (i_)++) {
    g_[(*ir_) - 1 - 1 + ((*mdg_)) * ((i_ - 1))] = zero_;
  }
  _l100:;
  _l0:;
  __calls[67].calls++;
  return 0;
}

int_4 _dbndsl (int_4 _p_ mode_, real_8 _p_ g_, int_4 _p_ mdg_, int_4 _p_ nb_, int_4 _p_ ip_, int_4 _p_ ir_, real_8 _p_ 
x_, int_4 _p_ n_, real_8 _p_ rnorm_)
{
  static int_4 j_, np1_, irm1_, ii_, i_, l_, ie_, jg_, ix_, i1_, i2_, nerr_, iopt_;
  static real_8 zero_, rsq_, s_;
  real_8 $0_, $1_;
  char_127 $2_;
  zero_ = 0.0;
  (*rnorm_) = zero_;
  switch ((*mode_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l90;
    case 3: goto _l50;
  }
  _l10:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = g_[j_ - 1 + ((*mdg_)) * (((*nb_) + 1 - 1))];
  }
  rsq_ = zero_;
  np1_ = (*n_) + 1;
  irm1_ = (*ir_) - 1;
  if (np1_ > irm1_) {
    goto _l40;
  }
  for (j_ = np1_; j_ <= irm1_; (j_)++) {
    rsq_ = rsq_ + (g_[j_ - 1 + ((*mdg_)) * (((*nb_) + 1 - 1))] * g_[j_ - 1 + ((*mdg_)) * (((*nb_) + 1 - 1))]);
  }
  (*rnorm_) = sqrt (rsq_);
  _l40:;
  _l50:;
  for (ii_ = 1; ii_ <= (*n_); (ii_)++) {
    i_ = (*n_) + 1 - ii_;
    s_ = zero_;
    l_ = _max (0, i_ - (*ip_));
    if (i_ == (*n_)) {
      goto _l70;
    }
    ie_ = _min ((*n_) + 1 - i_, (*nb_));
    for (j_ = 2; j_ <= ie_; (j_)++) {
      jg_ = j_ + l_;
      ix_ = i_ - 1 + j_;
      s_ = s_ + g_[i_ - 1 + ((*mdg_)) * ((jg_ - 1))] * x_[ix_ - 1];
    }
    _l70:;
    $0_ = g_[i_ - 1 + ((*mdg_)) * ((l_ + 1 - 1))];
    if ($0_ < 0) {
      goto _l80;
    } else if ($0_ == 0) {
      goto _l130;
    } else {
      goto _l80;
    }
    _l80:;
    x_[i_ - 1] = (x_[i_ - 1] - s_) / g_[i_ - 1 + ((*mdg_)) * ((l_ + 1 - 1))];
  }
  goto _l0;
  _l90:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    s_ = zero_;
    if (j_ == 1) {
      goto _l110;
    }
    i1_ = _max (1, j_ - (*nb_) + 1);
    i2_ = j_ - 1;
    for (i_ = i1_; i_ <= i2_; (i_)++) {
      l_ = j_ - i_ + 1 + _max (0, i_ - (*ip_));
      s_ = s_ + x_[i_ - 1] * g_[i_ - 1 + ((*mdg_)) * ((l_ - 1))];
    }
    _l110:;
    l_ = _max (0, j_ - (*ip_));
    $1_ = g_[j_ - 1 + ((*mdg_)) * ((l_ + 1 - 1))];
    if ($1_ < 0) {
      goto _l120;
    } else if ($1_ == 0) {
      goto _l130;
    } else {
      goto _l120;
    }
    _l120:;
    x_[j_ - 1] = (x_[j_ - 1] - s_) / g_[j_ - 1 + ((*mdg_)) * ((l_ + 1 - 1))];
  }
  goto _l0;
  _l130:;
  nerr_ = 1;
  iopt_ = 2;
  (void) _xermsg (_dc_1, _dc_55, concat ($2_, _dc_13, _dc_14), &nerr_, &iopt_);
  _l0:;
  __calls[68].calls++;
  return 0;
}

int_4 _dbocls (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ mcon_, int_4 _p_ mrows_, int_4 _p_ ncols_, real_8 _p_ bl_, 
real_8 _p_ bu_, int_4 _p_ ind_, int_4 _p_ iopt_, real_8 _p_ x_, real_8 _p_ rnormc_, real_8 _p_ rnorm_, int_4 _p_ mode_, 
real_8 _p_ rw_, int_4 _p_ iw_)
{
  static int_4 jopt_[5], igo_, nerr_, j_, lenx_, iscale_, lopt_, mopt_, lp_, lds_, ip_, jp_, lbou_, lboum_, locacc_, 
  locdim_, lmdw_, lndw_, llb_, llx_, llrw_, lliw_, liopt_, mdwl_, inrows_, mnew_, irw_, iiw_, mout_, i_, modec_, icase_, 
  lrw_, liw_, m_;
  static logical_4 checkl_, filter_, accum_, pretri_;
  static real_8 anorm_, cnorm_, one_, drelpr_, t_, t1_, t2_, wt_, zero_;
  static char_15 xern1_, xern2_;
  static char_31 xern3_, xern4_;
  int_4 _data_k_79, __fcnt, __rc, $3_, $7_, $11_, $17_, $26_, $27_, $31_, $35_, $41_, $45_, $50_, $51_, $56_, $57_, $62_, 
  $67_, $68_, $73_, $74_, $79_, $80_, $85_, $86_, $91_, $92_, $93_, $94_, $95_, $96_;
  char_31 $0_, $4_, $8_, $12_, $18_, $87_;
  char_63 $1_, $2_, $5_, $6_, $13_, $19_, $28_, $32_, $42_, $46_, $52_, $63_, $69_, $75_, $81_;
  char_127 $9_, $10_, $14_, $20_, $29_, $30_, $33_, $34_, $36_, $43_, $44_, $47_, $53_, $58_, $64_, $70_, $76_, $82_, 
  $88_;
  char_255 $15_, $16_, $21_, $37_, $48_, $49_, $54_, $55_, $59_, $65_, $66_, $71_, $72_, $77_, $78_, $83_, $84_, $89_, 
  $90_;
  char_511 $22_, $38_, $60_, $61_;
  char_1023 $23_, $39_, $40_;
  char_2047 $24_, $25_;
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern real_8 _dasum ();
  extern real_8 _d1mach ();
  static FORMAT $f_100016_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100021_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100026_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100032_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100033_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100041_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100042_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100043_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100134_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100145_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100153_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100154_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100191_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100203_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100204_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100209_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100210_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100215_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100216_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100221_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100222_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100227_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100228_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100233_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100234_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100239_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100240_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100251_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100252_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
#define _data_n_79 1
  static int_4 _data_l_79[_data_n_79] = {
    0
  };
  if (__calls[69].calls == 0) {
    _data_k_79 = 0;
    if (_data_k_79 >= _data_n_79) {
      _data_k_79 = 0;
    }
    igo_ = _data_l_79[_data_k_79++];
  }
  nerr_ = 0;
  (*mode_) = 0;
  if (igo_ == 0) {
    if ((*mdw_) <= 0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbocls:578", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:578", 0));
        __fcnt += 3;
      }
      if ($f_100016_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:578", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100016_[__fcnt + 2], &(*mdw_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:578", 0));
      __fcnt += 3;
      while ($f_100016_[__fcnt] != NULL && $f_100016_[__fcnt] == FMT_TEXT) {
        if ($f_100016_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100016_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:578", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_56, (bufcpy ($2_, concat ($1_, concat ($0_, _dc_57, xern1_), _dc_58), 63), $2_), ($3_ = 53, 
      &$3_), &_k1);
      goto _l260;
    }
    if ((*mcon_) < 0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbocls:587", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:587", 0));
        __fcnt += 3;
      }
      if ($f_100021_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:587", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], &(*mcon_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:587", 0));
      __fcnt += 3;
      while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
        if ($f_100021_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:587", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_56, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_59, xern1_), _dc_60), 63), $6_), ($7_ = 54, 
      &$7_), &_k1);
      goto _l260;
    }
    if ((*ncols_) <= 0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbocls:596", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:596", 0));
        __fcnt += 3;
      }
      if ($f_100026_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:596", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100026_[__fcnt + 2], &(*ncols_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:596", 0));
      __fcnt += 3;
      while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
        if ($f_100026_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:596", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_56, (bufcpy ($10_, concat ($9_, concat ($8_, _dc_61, xern1_), _dc_62), 127), $10_), ($11_ = 
      55, &$11_), &_k1);
      goto _l260;
    }
    for (j_ = 1; j_ <= (*ncols_) + (*mcon_); (j_)++) {
      if (ind_[j_ - 1] < 1 || ind_[j_ - 1] > 4) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:606", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100032_[__fcnt] != NULL && $f_100032_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100032_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:606", 0));
          __fcnt += 3;
        }
        if ($f_100032_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100032_[__fcnt] != NULL && $f_100032_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100032_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:606", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100032_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:606", 0));
        __fcnt += 3;
        while ($f_100032_[__fcnt] != NULL && $f_100032_[__fcnt] == FMT_TEXT) {
          if ($f_100032_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100032_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:606", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:607", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:607", 0));
          __fcnt += 3;
        }
        if ($f_100033_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:607", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100033_[__fcnt + 2], &ind_[j_ - 1], INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:607", 0));
        __fcnt += 3;
        while ($f_100033_[__fcnt] != NULL && $f_100033_[__fcnt] == FMT_TEXT) {
          if ($f_100033_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100033_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:607", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_56, (bufcpy ($16_, concat ($15_, concat ($14_, concat ($13_, concat ($12_, _dc_63, xern1_), 
        _dc_64), xern2_), _dc_65), 255), $16_), ($17_ = 56, &$17_), &_k1);
        goto _l260;
      }
    }
    for (j_ = 1; j_ <= (*ncols_) + (*mcon_); (j_)++) {
      if (ind_[j_ - 1] == 3) {
        if (bl_[j_ - 1] > bu_[j_ - 1]) {
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
          _ffile[0].lrecl = 15;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern1_, 15, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbocls:619", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:619", 0));
            __fcnt += 3;
          }
          if ($f_100041_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:619", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100041_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:619", 0));
          __fcnt += 3;
          while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
            if ($f_100041_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:619", 0));
            __fcnt += 3;
          }
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
          _ffile[0].lrecl = 31;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern3_, 31, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbocls:620", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100042_[__fcnt] != NULL && $f_100042_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100042_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:620", 0));
            __fcnt += 3;
          }
          if ($f_100042_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100042_[__fcnt] != NULL && $f_100042_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100042_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:620", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100042_[__fcnt + 2], &bl_[j_ - 1], REAL, 8);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:620", 0));
          __fcnt += 3;
          while ($f_100042_[__fcnt] != NULL && $f_100042_[__fcnt] == FMT_TEXT) {
            if ($f_100042_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100042_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:620", 0));
            __fcnt += 3;
          }
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
          _ffile[0].lrecl = 31;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern4_, 31, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbocls:621", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:621", 0));
            __fcnt += 3;
          }
          if ($f_100043_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:621", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100043_[__fcnt + 2], &bu_[j_ - 1], REAL, 8);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:621", 0));
          __fcnt += 3;
          while ($f_100043_[__fcnt] != NULL && $f_100043_[__fcnt] == FMT_TEXT) {
            if ($f_100043_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100043_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:621", 0));
            __fcnt += 3;
          }
          (void) _xermsg (_dc_1, _dc_56, (bufcpy ($25_, concat ($24_, concat ($23_, concat ($22_, concat ($21_, concat ($20_, 
          concat ($19_, concat ($18_, _dc_66, xern1_), _dc_64), xern3_), _dc_67), xern1_), _dc_64), xern4_), 2047), $25_), ($26_ 
          = 57, &$26_), &_k1);
          goto _l260;
        }
      }
    }
    zero_ = 0.0;
    one_ = 1.0;
    drelpr_ = _d1mach (($27_ = 4, &$27_));
    checkl_ = FALSE;
    filter_ = TRUE;
    lenx_ = 2 * ((*ncols_) + (*mcon_)) + 2;
    iscale_ = 1;
    igo_ = 1;
    accum_ = FALSE;
    pretri_ = TRUE;
    lopt_ = 0;
    mopt_ = 0;
    lp_ = 0;
    lds_ = 0;
    _l30:;
    lp_ = lp_ + lds_;
    ip_ = iopt_[lp_ + 1 - 1];
    jp_ = _abs (ip_);
    if (ip_ == 99) {
      if (lopt_ == 0) {
        lopt_ = -(lp_ + 2);
      }
      if (mopt_ == 0) {
        mopt_ = -(_abs (lopt_) + 7);
      }
      if (lopt_ < 0) {
        lbou_ = _abs (lopt_);
      }
      else {
        lbou_ = lopt_ - 15;
      }
      iopt_[lbou_ - 1] = 4;
      iopt_[lbou_ + 1 - 1] = 1;
      iopt_[lbou_ + 2 - 1] = 5;
      iopt_[lbou_ + 3 - 1] = 8;
      iopt_[lbou_ + 4 - 1] = 6;
      iopt_[lbou_ + 6 - 1] = 99;
      if (lopt_ > 0) {
        iopt_[lbou_ + 5 - 1] = lopt_ - lbou_ + 1;
      }
      else {
        iopt_[lbou_ + 4 - 1] = -iopt_[lbou_ + 4 - 1];
      }
      if (mopt_ < 0) {
        lboum_ = _abs (mopt_);
      }
      else {
        lboum_ = mopt_ - 8;
      }
      iopt_[lboum_ - 1] = 5;
      iopt_[lboum_ + 1 - 1] = (*ncols_) + (*mcon_) + 1;
      iopt_[lboum_ + 2 - 1] = 6;
      iopt_[lboum_ + 3 - 1] = (*ncols_) + (*mcon_) + 2;
      iopt_[lboum_ + 4 - 1] = (*mcon_);
      iopt_[lboum_ + 5 - 1] = 1;
      iopt_[lboum_ + 7 - 1] = 99;
      if (mopt_ > 0) {
        iopt_[lboum_ + 6 - 1] = mopt_ - lboum_ + 1;
      }
      else {
        iopt_[lboum_ + 5 - 1] = -iopt_[lboum_ + 5 - 1];
      }
      goto _l50;
    }
    else if (jp_ == 99) {
      lds_ = 1;
      goto _l50;
    }
    else if (jp_ == 1) {
      if (ip_ > 0) {
        locacc_ = lp_ + 2;
        iopt_[locacc_ + 1 - 1] = (*mcon_) + 1;
        accum_ = TRUE;
        iopt_[locacc_ - 1] = igo_;
      }
      lds_ = 4;
      goto _l30;
    }
    else if (jp_ == 2) {
      if (ip_ > 0) {
        locdim_ = lp_ + 2;
        lmdw_ = iopt_[locdim_ - 1];
        lndw_ = iopt_[locdim_ + 1 - 1];
        llb_ = iopt_[locdim_ + 2 - 1];
        llx_ = iopt_[locdim_ + 3 - 1];
        llrw_ = iopt_[locdim_ + 4 - 1];
        lliw_ = iopt_[locdim_ + 5 - 1];
        liopt_ = iopt_[locdim_ + 6 - 1];
        checkl_ = TRUE;
      }
      lds_ = 8;
      goto _l30;
    }
    else if (jp_ == 3) {
      if (ip_ > 0) {
        iscale_ = iopt_[lp_ + 2 - 1];
        if (iscale_ < 1 || iscale_ > 3) {
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
          _ffile[0].lrecl = 15;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern1_, 15, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbocls:783", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100134_[__fcnt] != NULL && $f_100134_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100134_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:783", 0));
            __fcnt += 3;
          }
          if ($f_100134_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100134_[__fcnt] != NULL && $f_100134_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100134_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:783", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100134_[__fcnt + 2], &iscale_, INTEGER, 4);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:783", 0));
          __fcnt += 3;
          while ($f_100134_[__fcnt] != NULL && $f_100134_[__fcnt] == FMT_TEXT) {
            if ($f_100134_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100134_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:783", 0));
            __fcnt += 3;
          }
          (void) _xermsg (_dc_1, _dc_56, (bufcpy ($30_, concat ($29_, concat ($28_, _dc_68, xern1_), _dc_69), 127), $30_), ($31_ 
          = 48, &$31_), &_k1);
          goto _l260;
        }
      }
      lds_ = 2;
      goto _l30;
    }
    else if (jp_ == 4) {
      if (ip_ > 0) {
        iscale_ = 4;
        if (iopt_[lp_ + 2 - 1] <= 0) {
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
          _ffile[0].lrecl = 15;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern1_, 15, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbocls:801", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100145_[__fcnt] != NULL && $f_100145_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100145_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:801", 0));
            __fcnt += 3;
          }
          if ($f_100145_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100145_[__fcnt] != NULL && $f_100145_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100145_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:801", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100145_[__fcnt + 2], &iopt_[lp_ + 2 - 1], INTEGER, 4);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:801", 0));
          __fcnt += 3;
          while ($f_100145_[__fcnt] != NULL && $f_100145_[__fcnt] == FMT_TEXT) {
            if ($f_100145_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100145_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:801", 0));
            __fcnt += 3;
          }
          (void) _xermsg (_dc_1, _dc_56, (bufcpy ($34_, concat ($33_, concat ($32_, _dc_70, xern1_), _dc_71), 127), $34_), ($35_ 
          = 49, &$35_), &_k1);
          goto _l260;
        }
        (void) _dcopy (ncols_, &x_[(*ncols_) + iopt_[lp_ + 2 - 1] - 1], &_k1, rw_, &_k1);
        lenx_ = lenx_ + (*ncols_);
        for (j_ = 1; j_ <= (*ncols_); (j_)++) {
          if (rw_[j_ - 1] <= zero_) {
            _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
            _ffile[0].lrecl = 15;
            _ffile[0].record = 0;
            _ffile[0].records = 1;
            _ffile[0].unit = fmemopen (xern1_, 15, "w");
            _ffile[0].buff_init = FALSE;
            _fcheck ("slatec:dbocls:813", 0, action_write, form_formatted);
            __fcnt = 0;
            while ($f_100153_[__fcnt] != NULL && $f_100153_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100153_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:813", 0));
              __fcnt += 3;
            }
            if ($f_100153_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[0].unit, "\n");
              while ($f_100153_[__fcnt] != NULL && $f_100153_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf (0, $f_100153_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:813", 0));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf (0, $f_100153_[__fcnt + 2], &j_, INTEGER, 4);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:813", 0));
            __fcnt += 3;
            while ($f_100153_[__fcnt] != NULL && $f_100153_[__fcnt] == FMT_TEXT) {
              if ($f_100153_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf (0, $f_100153_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:813", 0));
              __fcnt += 3;
            }
            _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
            _ffile[0].lrecl = 31;
            _ffile[0].record = 0;
            _ffile[0].records = 1;
            _ffile[0].unit = fmemopen (xern3_, 31, "w");
            _ffile[0].buff_init = FALSE;
            _fcheck ("slatec:dbocls:814", 0, action_write, form_formatted);
            __fcnt = 0;
            while ($f_100154_[__fcnt] != NULL && $f_100154_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100154_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:814", 0));
              __fcnt += 3;
            }
            if ($f_100154_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[0].unit, "\n");
              while ($f_100154_[__fcnt] != NULL && $f_100154_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf (0, $f_100154_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:814", 0));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf (0, $f_100154_[__fcnt + 2], &rw_[j_ - 1], REAL, 8);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:814", 0));
            __fcnt += 3;
            while ($f_100154_[__fcnt] != NULL && $f_100154_[__fcnt] == FMT_TEXT) {
              if ($f_100154_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf (0, $f_100154_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:814", 0));
              __fcnt += 3;
            }
            (void) _xermsg (_dc_1, _dc_56, (bufcpy ($40_, concat ($39_, concat ($38_, concat ($37_, concat ($36_, _dc_72, _dc_73), 
            xern1_), _dc_74), xern3_), 1023), $40_), ($41_ = 50, &$41_), &_k1);
            goto _l260;
          }
        }
      }
      lds_ = 2;
      goto _l30;
    }
    else if (jp_ == 5) {
      if (ip_ > 0) {
        lopt_ = iopt_[lp_ + 2 - 1];
      }
      lds_ = 2;
      goto _l30;
    }
    else if (jp_ == 6) {
      if (ip_ > 0) {
        mopt_ = iopt_[lp_ + 2 - 1];
      }
      lds_ = 2;
      goto _l30;
    }
    else if (jp_ == 7) {
      if (ip_ > 0) {
        lp_ = iopt_[lp_ + 2 - 1] - 1;
        lds_ = 0;
      }
      else {
        lds_ = 2;
      }
      goto _l30;
    }
    else if (jp_ == 8) {
      filter_ = ! ((ip_ > 0));
      lds_ = 1;
      goto _l30;
    }
    else if (jp_ == 9) {
      pretri_ = ! ((ip_ > 0));
      lds_ = 1;
      goto _l30;
    }
    else {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbocls:876", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100191_[__fcnt] != NULL && $f_100191_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100191_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:876", 0));
        __fcnt += 3;
      }
      if ($f_100191_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100191_[__fcnt] != NULL && $f_100191_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100191_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:876", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100191_[__fcnt + 2], &jp_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:876", 0));
      __fcnt += 3;
      while ($f_100191_[__fcnt] != NULL && $f_100191_[__fcnt] == FMT_TEXT) {
        if ($f_100191_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100191_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:876", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_56, (bufcpy ($44_, concat ($43_, concat ($42_, _dc_75, xern1_), _dc_76), 127), $44_), ($45_ 
      = 51, &$45_), &_k1);
      goto _l260;
    }
    _l50:;
    if (checkl_) {
      if (filter_ && ! (accum_)) {
        mdwl_ = (*mcon_) + _max ((*mrows_), (*ncols_));
      }
      else {
        mdwl_ = (*mcon_) + (*ncols_) + 1;
      }
      if (lmdw_ < mdwl_) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:897", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100203_[__fcnt] != NULL && $f_100203_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100203_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:897", 0));
          __fcnt += 3;
        }
        if ($f_100203_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100203_[__fcnt] != NULL && $f_100203_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100203_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:897", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100203_[__fcnt + 2], &lmdw_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:897", 0));
        __fcnt += 3;
        while ($f_100203_[__fcnt] != NULL && $f_100203_[__fcnt] == FMT_TEXT) {
          if ($f_100203_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100203_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:897", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:898", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100204_[__fcnt] != NULL && $f_100204_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100204_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:898", 0));
          __fcnt += 3;
        }
        if ($f_100204_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100204_[__fcnt] != NULL && $f_100204_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100204_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:898", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100204_[__fcnt + 2], &mdwl_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:898", 0));
        __fcnt += 3;
        while ($f_100204_[__fcnt] != NULL && $f_100204_[__fcnt] == FMT_TEXT) {
          if ($f_100204_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100204_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:898", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_56, (bufcpy ($49_, concat ($48_, concat ($47_, concat ($46_, _dc_77, xern1_), _dc_78), 
        xern2_), 255), $49_), ($50_ = 41, &$50_), &_k1);
        goto _l260;
      }
      if (lndw_ < (*ncols_) + (*mcon_) + 1) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:907", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100209_[__fcnt] != NULL && $f_100209_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100209_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:907", 0));
          __fcnt += 3;
        }
        if ($f_100209_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100209_[__fcnt] != NULL && $f_100209_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100209_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:907", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100209_[__fcnt + 2], &lndw_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:907", 0));
        __fcnt += 3;
        while ($f_100209_[__fcnt] != NULL && $f_100209_[__fcnt] == FMT_TEXT) {
          if ($f_100209_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100209_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:907", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:908", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100210_[__fcnt] != NULL && $f_100210_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100210_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:908", 0));
          __fcnt += 3;
        }
        $51_ = (*ncols_) + (*mcon_) + 1;
        if ($f_100210_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100210_[__fcnt] != NULL && $f_100210_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100210_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:908", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100210_[__fcnt + 2], &$51_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:908", 0));
        __fcnt += 3;
        while ($f_100210_[__fcnt] != NULL && $f_100210_[__fcnt] == FMT_TEXT) {
          if ($f_100210_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100210_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:908", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_56, (bufcpy ($55_, concat ($54_, concat ($53_, concat ($52_, _dc_79, xern1_), _dc_80), 
        xern2_), 255), $55_), ($56_ = 42, &$56_), &_k1);
        goto _l260;
      }
      if (llb_ < (*ncols_) + (*mcon_)) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:916", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100215_[__fcnt] != NULL && $f_100215_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100215_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:916", 0));
          __fcnt += 3;
        }
        if ($f_100215_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100215_[__fcnt] != NULL && $f_100215_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100215_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:916", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100215_[__fcnt + 2], &llb_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:916", 0));
        __fcnt += 3;
        while ($f_100215_[__fcnt] != NULL && $f_100215_[__fcnt] == FMT_TEXT) {
          if ($f_100215_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100215_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:916", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:917", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100216_[__fcnt] != NULL && $f_100216_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100216_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:917", 0));
          __fcnt += 3;
        }
        $57_ = (*ncols_) + (*mcon_);
        if ($f_100216_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100216_[__fcnt] != NULL && $f_100216_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100216_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:917", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100216_[__fcnt + 2], &$57_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:917", 0));
        __fcnt += 3;
        while ($f_100216_[__fcnt] != NULL && $f_100216_[__fcnt] == FMT_TEXT) {
          if ($f_100216_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100216_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:917", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_56, (bufcpy ($61_, concat ($60_, concat ($59_, concat ($58_, _dc_81, xern1_), _dc_82), 
        xern2_), 511), $61_), ($62_ = 43, &$62_), &_k1);
        goto _l260;
      }
      if (llx_ < lenx_) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:926", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100221_[__fcnt] != NULL && $f_100221_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100221_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:926", 0));
          __fcnt += 3;
        }
        if ($f_100221_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100221_[__fcnt] != NULL && $f_100221_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100221_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:926", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100221_[__fcnt + 2], &llx_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:926", 0));
        __fcnt += 3;
        while ($f_100221_[__fcnt] != NULL && $f_100221_[__fcnt] == FMT_TEXT) {
          if ($f_100221_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100221_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:926", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:927", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100222_[__fcnt] != NULL && $f_100222_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100222_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:927", 0));
          __fcnt += 3;
        }
        if ($f_100222_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100222_[__fcnt] != NULL && $f_100222_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100222_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:927", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100222_[__fcnt + 2], &lenx_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:927", 0));
        __fcnt += 3;
        while ($f_100222_[__fcnt] != NULL && $f_100222_[__fcnt] == FMT_TEXT) {
          if ($f_100222_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100222_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:927", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_56, (bufcpy ($66_, concat ($65_, concat ($64_, concat ($63_, _dc_83, xern1_), _dc_84), 
        xern2_), 255), $66_), ($67_ = 44, &$67_), &_k1);
        goto _l260;
      }
      if (llrw_ < 6 * (*ncols_) + 5 * (*mcon_)) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:936", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100227_[__fcnt] != NULL && $f_100227_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100227_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:936", 0));
          __fcnt += 3;
        }
        if ($f_100227_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100227_[__fcnt] != NULL && $f_100227_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100227_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:936", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100227_[__fcnt + 2], &llrw_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:936", 0));
        __fcnt += 3;
        while ($f_100227_[__fcnt] != NULL && $f_100227_[__fcnt] == FMT_TEXT) {
          if ($f_100227_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100227_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:936", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:937", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100228_[__fcnt] != NULL && $f_100228_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100228_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:937", 0));
          __fcnt += 3;
        }
        $68_ = 6 * (*ncols_) + 5 * (*mcon_);
        if ($f_100228_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100228_[__fcnt] != NULL && $f_100228_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100228_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:937", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100228_[__fcnt + 2], &$68_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:937", 0));
        __fcnt += 3;
        while ($f_100228_[__fcnt] != NULL && $f_100228_[__fcnt] == FMT_TEXT) {
          if ($f_100228_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100228_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:937", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_56, (bufcpy ($72_, concat ($71_, concat ($70_, concat ($69_, _dc_85, xern1_), _dc_86), 
        xern2_), 255), $72_), ($73_ = 45, &$73_), &_k1);
        goto _l260;
      }
      if (lliw_ < 2 * (*ncols_) + 2 * (*mcon_)) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:945", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100233_[__fcnt] != NULL && $f_100233_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100233_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:945", 0));
          __fcnt += 3;
        }
        if ($f_100233_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100233_[__fcnt] != NULL && $f_100233_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100233_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:945", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100233_[__fcnt + 2], &lliw_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:945", 0));
        __fcnt += 3;
        while ($f_100233_[__fcnt] != NULL && $f_100233_[__fcnt] == FMT_TEXT) {
          if ($f_100233_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100233_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:945", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:946", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100234_[__fcnt] != NULL && $f_100234_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100234_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:946", 0));
          __fcnt += 3;
        }
        $74_ = 2 * (*ncols_) + 2 * (*mcon_);
        if ($f_100234_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100234_[__fcnt] != NULL && $f_100234_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100234_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:946", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100234_[__fcnt + 2], &$74_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:946", 0));
        __fcnt += 3;
        while ($f_100234_[__fcnt] != NULL && $f_100234_[__fcnt] == FMT_TEXT) {
          if ($f_100234_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100234_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:946", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_56, (bufcpy ($78_, concat ($77_, concat ($76_, concat ($75_, _dc_87, xern1_), _dc_88), 
        xern2_), 255), $78_), ($79_ = 46, &$79_), &_k1);
        goto _l260;
      }
      if (liopt_ < lp_ + 17) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:954", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100239_[__fcnt] != NULL && $f_100239_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100239_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:954", 0));
          __fcnt += 3;
        }
        if ($f_100239_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100239_[__fcnt] != NULL && $f_100239_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100239_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:954", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100239_[__fcnt + 2], &liopt_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:954", 0));
        __fcnt += 3;
        while ($f_100239_[__fcnt] != NULL && $f_100239_[__fcnt] == FMT_TEXT) {
          if ($f_100239_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100239_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:954", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbocls:955", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100240_[__fcnt] != NULL && $f_100240_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100240_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:955", 0));
          __fcnt += 3;
        }
        $80_ = lp_ + 17;
        if ($f_100240_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100240_[__fcnt] != NULL && $f_100240_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100240_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:955", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100240_[__fcnt + 2], &$80_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:955", 0));
        __fcnt += 3;
        while ($f_100240_[__fcnt] != NULL && $f_100240_[__fcnt] == FMT_TEXT) {
          if ($f_100240_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100240_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:955", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_56, (bufcpy ($84_, concat ($83_, concat ($82_, concat ($81_, _dc_89, xern1_), _dc_90), 
        xern2_), 255), $84_), ($85_ = 47, &$85_), &_k1);
        goto _l260;
      }
    }
  }
  if (accum_) {
    (*mrows_) = iopt_[locacc_ + 1 - 1] - 1 - (*mcon_);
    inrows_ = iopt_[locacc_ + 2 - 1];
    mnew_ = (*mrows_) + inrows_;
    if (mnew_ < 0 || mnew_ + (*mcon_) > (*mdw_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbocls:975", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100251_[__fcnt] != NULL && $f_100251_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100251_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:975", 0));
        __fcnt += 3;
      }
      if ($f_100251_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100251_[__fcnt] != NULL && $f_100251_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100251_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:975", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100251_[__fcnt + 2], &mnew_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:975", 0));
      __fcnt += 3;
      while ($f_100251_[__fcnt] != NULL && $f_100251_[__fcnt] == FMT_TEXT) {
        if ($f_100251_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100251_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:975", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern2_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbocls:976", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100252_[__fcnt] != NULL && $f_100252_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100252_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:976", 0));
        __fcnt += 3;
      }
      $86_ = (*mdw_) - (*mcon_);
      if ($f_100252_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100252_[__fcnt] != NULL && $f_100252_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100252_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:976", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100252_[__fcnt + 2], &$86_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:976", 0));
      __fcnt += 3;
      while ($f_100252_[__fcnt] != NULL && $f_100252_[__fcnt] == FMT_TEXT) {
        if ($f_100252_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100252_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbocls:976", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_56, (bufcpy ($90_, concat ($89_, concat ($88_, concat ($87_, _dc_91, xern1_), _dc_92), 
      xern2_), 255), $90_), ($91_ = 52, &$91_), &_k1);
      goto _l260;
    }
  }
  jopt_[0] = 1;
  jopt_[1] = 2;
  jopt_[3] = (*mrows_);
  jopt_[4] = 99;
  irw_ = (*ncols_) + 1;
  iiw_ = 1;
  if (accum_ || pretri_) {
    (void) _dbols (&w_[(*mcon_) + 1 - 1 + ((*mdw_)) * ((0))], mdw_, &mout_, ncols_, bl_, bu_, ind_, jopt_, x_, rnorm_, 
    mode_, &rw_[irw_ - 1], &iw_[iiw_ - 1]);
  }
  else {
    mout_ = (*mrows_);
  }
  if (accum_) {
    accum_ = iopt_[locacc_ - 1] == 1;
    iopt_[locacc_ + 1 - 1] = jopt_[2] + (*mcon_);
    (*mrows_) = _min ((*ncols_) + 1, mnew_);
  }
  if (accum_) {
    goto _l0;
  }
  (void) _dcopy (&mout_, &w_[(*mcon_) + 1 - 1 + ((*mdw_)) * (((*ncols_) + 1 - 1))], &_k1, &w_[(*mcon_) + 1 - 1 + 
  ((*mdw_)) * (((*ncols_) + (*mcon_) + 1 - 1))], &_k1);
  if ((*mcon_) > 0 && filter_) {
    for (i_ = 1; i_ <= (*mcon_); (i_)++) {
      (void) _dcopy (ncols_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &w_[(*mcon_) + 1 - 1 + ((*mdw_)) * (((*ncols_) + i_ - 
      1))], &_k1);
    }
    for (j_ = (*ncols_) + 1; j_ <= (*ncols_) + (*mcon_) + 1; (j_)++) {
      w_[0 + ((*mdw_)) * ((j_ - 1))] = zero_;
      (void) _dcopy (mcon_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k0, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
    }
    w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))] = -one_;
    (void) _dcopy (mcon_, &w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))], &_k0, &w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))], 
    ($92_ = (*mdw_) + 1, &$92_));
    jopt_[0] = 99;
    irw_ = (*ncols_) + 1;
    iiw_ = 1;
    (void) _dbols (w_, mdw_, mcon_, ($93_ = (*ncols_) + (*mcon_), &$93_), bl_, bu_, ind_, jopt_, x_, rnormc_, &modec_, 
    &rw_[irw_ - 1], &iw_[iiw_ - 1]);
    for (j_ = (*ncols_) + 1; j_ <= (*ncols_) + (*mcon_); (j_)++) {
      icase_ = ind_[j_ - 1];
      if (icase_ < 4) {
        t_ = _ddot (ncols_, &w_[(*mcon_) + 1 - 1 + ((*mdw_)) * ((j_ - 1))], &_k1, x_, &_k1);
      }
      switch (icase_) {
        default:
        case 1: goto _l80;
        case 2: goto _l90;
        case 3: goto _l100;
        case 4: goto _l110;
      }
      goto _l120;
      _l80:;
      bl_[j_ - 1] = _min (t_, bl_[j_ - 1]);
      goto _l120;
      _l90:;
      bu_[j_ - 1] = _max (t_, bu_[j_ - 1]);
      goto _l120;
      _l100:;
      bl_[j_ - 1] = _min (t_, bl_[j_ - 1]);
      bu_[j_ - 1] = _max (t_, bu_[j_ - 1]);
      goto _l120;
      _l110:;
      _l120:;
    }
    for (j_ = (*ncols_) + 1; j_ <= (*ncols_) + (*mcon_); (j_)++) {
      (void) _dcopy (ncols_, &w_[(*mcon_) + 1 - 1 + ((*mdw_)) * ((j_ - 1))], &_k1, &w_[j_ - (*ncols_) - 1 + ((*mdw_)) * 
      ((0))], mdw_);
    }
  }
  if ((*mcon_) > 0) {
    for (j_ = (*ncols_) + 1; j_ <= (*ncols_) + (*mcon_); (j_)++) {
      w_[(*mcon_) + 1 - 1 + ((*mdw_)) * ((j_ - 1))] = zero_;
      (void) _dcopy (&mout_, &w_[(*mcon_) + 1 - 1 + ((*mdw_)) * ((j_ - 1))], &_k0, &w_[(*mcon_) + 1 - 1 + ((*mdw_)) * ((j_ - 
      1))], &_k1);
    }
    for (j_ = (*ncols_) + 1; j_ <= (*ncols_) + (*mcon_) + 1; (j_)++) {
      w_[0 + ((*mdw_)) * ((j_ - 1))] = zero_;
      (void) _dcopy (mcon_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k0, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
    }
    w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))] = -one_;
    (void) _dcopy (mcon_, &w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))], &_k0, &w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))], 
    ($94_ = (*mdw_) + 1, &$94_));
  }
  cnorm_ = zero_;
  anorm_ = zero_;
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    t1_ = _dasum (mcon_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
    t2_ = _dasum (&mout_, &w_[(*mcon_) + 1 - 1 + ((*mdw_)) * ((0))], &_k1);
    t_ = t1_ + t2_;
    if (t_ == zero_) {
      t_ = one_;
    }
    cnorm_ = _max (cnorm_, t1_);
    anorm_ = _max (anorm_, t2_);
    x_[(*ncols_) + (*mcon_) + j_ - 1] = one_ / t_;
  }
  switch (iscale_) {
    default:
    case 1: goto _l180;
    case 2: goto _l190;
    case 3: goto _l210;
    case 4: goto _l220;
  }
  goto _l230;
  _l180:;
  goto _l230;
  _l190:;
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    t_ = _dnrm2 (($95_ = (*mcon_) + mout_, &$95_), &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
    if (t_ == zero_) {
      t_ = one_;
    }
    x_[(*ncols_) + (*mcon_) + j_ - 1] = one_ / t_;
  }
  goto _l230;
  _l210:;
  x_[(*ncols_) + (*mcon_) + 1 - 1] = one_;
  (void) _dcopy (ncols_, &x_[(*ncols_) + (*mcon_) + 1 - 1], &_k0, &x_[(*ncols_) + (*mcon_) + 1 - 1], &_k1);
  goto _l230;
  _l220:;
  (void) _dcopy (ncols_, rw_, &_k1, &x_[(*ncols_) + (*mcon_) + 1 - 1], &_k1);
  _l230:;
  for (j_ = (*ncols_) + 1; j_ <= (*ncols_) + (*mcon_); (j_)++) {
    x_[(*ncols_) + (*mcon_) + j_ - 1] = one_;
  }
  wt_ = drelpr_;
  if (anorm_ > zero_) {
    wt_ = wt_ / anorm_;
  }
  if (cnorm_ > zero_) {
    wt_ = wt_ * cnorm_;
  }
  for (i_ = 1; i_ <= mout_; (i_)++) {
    (void) _dscal (ncols_, &wt_, &w_[i_ + (*mcon_) - 1 + ((*mdw_)) * ((0))], mdw_);
  }
  (void) _dscal (&mout_, &wt_, &w_[(*mcon_) + 1 - 1 + ((*mdw_)) * (((*mcon_) + (*ncols_) + 1 - 1))], &_k1);
  lrw_ = 1;
  liw_ = 1;
  x_[2 * ((*ncols_) + (*mcon_)) + 1 - 1] = zero_;
  x_[2 * ((*ncols_) + (*mcon_)) + 2 - 1] = one_ / wt_;
  m_ = mout_ + (*mcon_);
  (void) _dbols (w_, mdw_, &m_, ($96_ = (*ncols_) + (*mcon_), &$96_), bl_, bu_, ind_, &iopt_[lbou_ - 1], x_, rnorm_, 
  mode_, &rw_[lrw_ - 1], &iw_[liw_ - 1]);
  (*rnorm_) = (*rnorm_) / wt_;
  _l260:;
  if ((*mode_) >= 0) {
    (*mode_) = -nerr_;
  }
  igo_ = 0;
  _l0:;
  __calls[69].calls++;
  return 0;
}

int_4 _dbols (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ mrows_, int_4 _p_ ncols_, real_8 _p_ bl_, real_8 _p_ bu_, int_4 
_p_ ind_, int_4 _p_ iopt_, real_8 _p_ x_, real_8 _p_ rnorm_, int_4 _p_ mode_, real_8 _p_ rw_, int_4 _p_ iw_)
{
  static int_4 igo_, locacc_, lopt_, iscale_, nerr_, j_, lenx_, lp_, lds_, ip_, jp_, locdim_, lmdw_, lndw_, llb_, llx_, 
  llrw_, lliw_, liopt_, inrows_, mnew_, i_, ibig_;
  static logical_4 checkl_;
  static real_8 sc_, ss_, one_, zero_;
  static char_15 xern1_, xern2_;
  static char_31 xern3_, xern4_;
  int_4 _data_k_80, __fcnt, __rc, $3_, $7_, $13_, $22_, $26_, $31_, $37_, $41_, $46_, $47_, $52_, $57_, $62_, $63_, $68_, 
  $69_, $74_, $75_, $80_, $85_, $86_, $87_;
  char_31 $0_, $4_, $8_, $14_, $81_;
  char_63 $1_, $2_, $9_, $15_, $23_, $27_, $38_, $42_, $48_, $58_, $64_, $70_, $76_;
  char_127 $5_, $6_, $10_, $16_, $24_, $25_, $28_, $32_, $39_, $40_, $43_, $49_, $53_, $59_, $65_, $71_, $77_, $82_;
  char_255 $11_, $12_, $17_, $29_, $30_, $33_, $44_, $45_, $50_, $51_, $54_, $60_, $61_, $66_, $67_, $72_, $73_, $78_, 
  $79_, $83_, $84_;
  char_511 $18_, $34_, $55_, $56_;
  char_1023 $19_, $35_, $36_;
  char_2047 $20_, $21_;
  extern real_8 _dnrm2 ();
  extern int_4 _idamax ();
  static FORMAT $f_100014_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100019_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100025_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100026_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100034_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100035_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100036_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100087_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100098_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100106_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100107_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100130_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100137_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100138_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100143_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100144_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100149_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100150_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100155_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100156_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100161_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100162_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100167_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100168_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100173_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100174_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100187_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100188_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
#define _data_n_80 1
  static int_4 _data_l_80[_data_n_80] = {
    0
  };
  if (__calls[70].calls == 0) {
    _data_k_80 = 0;
    if (_data_k_80 >= _data_n_80) {
      _data_k_80 = 0;
    }
    igo_ = _data_l_80[_data_k_80++];
  }
  nerr_ = 0;
  (*mode_) = 0;
  if (igo_ == 0) {
    if ((*mdw_) <= 0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbols:445", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:445", 0));
        __fcnt += 3;
      }
      if ($f_100014_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:445", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100014_[__fcnt + 2], &(*mdw_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbols:445", 0));
      __fcnt += 3;
      while ($f_100014_[__fcnt] != NULL && $f_100014_[__fcnt] == FMT_TEXT) {
        if ($f_100014_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100014_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:445", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_93, (bufcpy ($2_, concat ($1_, concat ($0_, _dc_57, xern1_), _dc_58), 63), $2_), ($3_ = 2, 
      &$3_), &_k1);
      goto _l190;
    }
    if ((*ncols_) <= 0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbols:454", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:454", 0));
        __fcnt += 3;
      }
      if ($f_100019_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:454", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100019_[__fcnt + 2], &(*ncols_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbols:454", 0));
      __fcnt += 3;
      while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
        if ($f_100019_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:454", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_93, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_61, xern1_), _dc_94), 127), $6_), ($7_ = 3, 
      &$7_), &_k1);
      goto _l190;
    }
    for (j_ = 1; j_ <= (*ncols_); (j_)++) {
      if (ind_[j_ - 1] < 1 || ind_[j_ - 1] > 4) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:464", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:464", 0));
          __fcnt += 3;
        }
        if ($f_100025_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:464", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100025_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:464", 0));
        __fcnt += 3;
        while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
          if ($f_100025_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:464", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:465", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:465", 0));
          __fcnt += 3;
        }
        if ($f_100026_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:465", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100026_[__fcnt + 2], &ind_[j_ - 1], INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:465", 0));
        __fcnt += 3;
        while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
          if ($f_100026_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:465", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_93, (bufcpy ($12_, concat ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_63, xern1_), 
        _dc_64), xern2_), _dc_65), 255), $12_), ($13_ = 4, &$13_), &_k1);
        goto _l190;
      }
    }
    for (j_ = 1; j_ <= (*ncols_); (j_)++) {
      if (ind_[j_ - 1] == 3) {
        if (bl_[j_ - 1] > bu_[j_ - 1]) {
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
          _ffile[0].lrecl = 15;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern1_, 15, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbols:477", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100034_[__fcnt] != NULL && $f_100034_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100034_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:477", 0));
            __fcnt += 3;
          }
          if ($f_100034_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100034_[__fcnt] != NULL && $f_100034_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100034_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:477", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100034_[__fcnt + 2], &j_, INTEGER, 4);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:477", 0));
          __fcnt += 3;
          while ($f_100034_[__fcnt] != NULL && $f_100034_[__fcnt] == FMT_TEXT) {
            if ($f_100034_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100034_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:477", 0));
            __fcnt += 3;
          }
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
          _ffile[0].lrecl = 31;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern3_, 31, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbols:478", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:478", 0));
            __fcnt += 3;
          }
          if ($f_100035_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:478", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100035_[__fcnt + 2], &bl_[j_ - 1], REAL, 8);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:478", 0));
          __fcnt += 3;
          while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
            if ($f_100035_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:478", 0));
            __fcnt += 3;
          }
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
          _ffile[0].lrecl = 31;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern4_, 31, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbols:479", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:479", 0));
            __fcnt += 3;
          }
          if ($f_100036_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:479", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100036_[__fcnt + 2], &bu_[j_ - 1], REAL, 8);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:479", 0));
          __fcnt += 3;
          while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
            if ($f_100036_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:479", 0));
            __fcnt += 3;
          }
          (void) _xermsg (_dc_1, _dc_93, (bufcpy ($21_, concat ($20_, concat ($19_, concat ($18_, concat ($17_, concat ($16_, 
          concat ($15_, concat ($14_, _dc_66, xern1_), _dc_64), xern3_), _dc_67), xern1_), _dc_64), xern4_), 2047), $21_), ($22_ 
          = 5, &$22_), &_k1);
          goto _l190;
        }
      }
    }
    zero_ = 0.0;
    one_ = 1.0;
    checkl_ = FALSE;
    lenx_ = (*ncols_);
    iscale_ = 1;
    igo_ = 2;
    lopt_ = 0;
    lp_ = 0;
    lds_ = 0;
    _l30:;
    lp_ = lp_ + lds_;
    ip_ = iopt_[lp_ + 1 - 1];
    jp_ = _abs (ip_);
    if (ip_ == 99) {
      if (lopt_ == 0) {
        lopt_ = lp_ + 1;
      }
      goto _l50;
    }
    else if (jp_ == 99) {
      lds_ = 1;
      goto _l30;
    }
    else if (jp_ == 1) {
      if (ip_ > 0) {
        locacc_ = lp_ + 2;
        iopt_[locacc_ + 1 - 1] = 1;
        igo_ = 1;
      }
      lds_ = 4;
      goto _l30;
    }
    else if (jp_ == 2) {
      if (ip_ > 0) {
        locdim_ = lp_ + 2;
        lmdw_ = iopt_[locdim_ - 1];
        lndw_ = iopt_[locdim_ + 1 - 1];
        llb_ = iopt_[locdim_ + 2 - 1];
        llx_ = iopt_[locdim_ + 3 - 1];
        llrw_ = iopt_[locdim_ + 4 - 1];
        lliw_ = iopt_[locdim_ + 5 - 1];
        liopt_ = iopt_[locdim_ + 6 - 1];
        checkl_ = TRUE;
      }
      lds_ = 8;
      goto _l30;
    }
    else if (jp_ == 3) {
      if (ip_ > 0) {
        iscale_ = iopt_[lp_ + 2 - 1];
        if (iscale_ < 1 || iscale_ > 3) {
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
          _ffile[0].lrecl = 15;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern1_, 15, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbols:581", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:581", 0));
            __fcnt += 3;
          }
          if ($f_100087_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:581", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100087_[__fcnt + 2], &iscale_, INTEGER, 4);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:581", 0));
          __fcnt += 3;
          while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
            if ($f_100087_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:581", 0));
            __fcnt += 3;
          }
          (void) _xermsg (_dc_1, _dc_93, (bufcpy ($25_, concat ($24_, concat ($23_, _dc_68, xern1_), _dc_69), 127), $25_), ($26_ 
          = 7, &$26_), &_k1);
          goto _l190;
        }
      }
      lds_ = 2;
      goto _l30;
    }
    else if (jp_ == 4) {
      if (ip_ > 0) {
        iscale_ = 4;
        if (iopt_[lp_ + 2 - 1] <= 0) {
          _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
          _ffile[0].lrecl = 15;
          _ffile[0].record = 0;
          _ffile[0].records = 1;
          _ffile[0].unit = fmemopen (xern1_, 15, "w");
          _ffile[0].buff_init = FALSE;
          _fcheck ("slatec:dbols:598", 0, action_write, form_formatted);
          __fcnt = 0;
          while ($f_100098_[__fcnt] != NULL && $f_100098_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100098_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:598", 0));
            __fcnt += 3;
          }
          if ($f_100098_[__fcnt] == NULL) {
            __fcnt = 0;
            __rc = fprintf (_ffile[0].unit, "\n");
            while ($f_100098_[__fcnt] != NULL && $f_100098_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100098_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:598", 0));
              __fcnt += 3;
            }
          };
          __rc = _vif_printf (0, $f_100098_[__fcnt + 2], &iopt_[lp_ + 2 - 1], INTEGER, 4);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:598", 0));
          __fcnt += 3;
          while ($f_100098_[__fcnt] != NULL && $f_100098_[__fcnt] == FMT_TEXT) {
            if ($f_100098_[__fcnt + 2] == FMT_TERM) {
              break;
            }
            __rc = _vif_printf (0, $f_100098_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:598", 0));
            __fcnt += 3;
          }
          (void) _xermsg (_dc_1, _dc_93, (bufcpy ($30_, concat ($29_, concat ($28_, concat ($27_, _dc_70, xern1_), _dc_95), 
          _dc_96), 255), $30_), ($31_ = 8, &$31_), &_k1);
          goto _l190;
        }
        (void) _dcopy (ncols_, &x_[(*ncols_) + iopt_[lp_ + 2 - 1] - 1], &_k1, rw_, &_k1);
        lenx_ = lenx_ + (*ncols_);
        for (j_ = 1; j_ <= (*ncols_); (j_)++) {
          if (rw_[j_ - 1] <= zero_) {
            _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
            _ffile[0].lrecl = 15;
            _ffile[0].record = 0;
            _ffile[0].records = 1;
            _ffile[0].unit = fmemopen (xern1_, 15, "w");
            _ffile[0].buff_init = FALSE;
            _fcheck ("slatec:dbols:610", 0, action_write, form_formatted);
            __fcnt = 0;
            while ($f_100106_[__fcnt] != NULL && $f_100106_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100106_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:610", 0));
              __fcnt += 3;
            }
            if ($f_100106_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[0].unit, "\n");
              while ($f_100106_[__fcnt] != NULL && $f_100106_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf (0, $f_100106_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, 0, _ioerr_write ("slatec:dbols:610", 0));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf (0, $f_100106_[__fcnt + 2], &j_, INTEGER, 4);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:610", 0));
            __fcnt += 3;
            while ($f_100106_[__fcnt] != NULL && $f_100106_[__fcnt] == FMT_TEXT) {
              if ($f_100106_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf (0, $f_100106_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:610", 0));
              __fcnt += 3;
            }
            _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
            _ffile[0].lrecl = 31;
            _ffile[0].record = 0;
            _ffile[0].records = 1;
            _ffile[0].unit = fmemopen (xern3_, 31, "w");
            _ffile[0].buff_init = FALSE;
            _fcheck ("slatec:dbols:611", 0, action_write, form_formatted);
            __fcnt = 0;
            while ($f_100107_[__fcnt] != NULL && $f_100107_[__fcnt] == FMT_TEXT) {
              __rc = _vif_printf (0, $f_100107_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:611", 0));
              __fcnt += 3;
            }
            if ($f_100107_[__fcnt] == NULL) {
              __fcnt = 0;
              __rc = fprintf (_ffile[0].unit, "\n");
              while ($f_100107_[__fcnt] != NULL && $f_100107_[__fcnt] == FMT_TEXT) {
                __rc = _vif_printf (0, $f_100107_[__fcnt + 2], NULL, NOTYPE, 0);
                _write_err (__rc, 0, _ioerr_write ("slatec:dbols:611", 0));
                __fcnt += 3;
              }
            };
            __rc = _vif_printf (0, $f_100107_[__fcnt + 2], &rw_[j_ - 1], REAL, 8);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:611", 0));
            __fcnt += 3;
            while ($f_100107_[__fcnt] != NULL && $f_100107_[__fcnt] == FMT_TEXT) {
              if ($f_100107_[__fcnt + 2] == FMT_TERM) {
                break;
              }
              __rc = _vif_printf (0, $f_100107_[__fcnt + 2], NULL, NOTYPE, 0);
              _write_err (__rc, 0, _ioerr_write ("slatec:dbols:611", 0));
              __fcnt += 3;
            }
            (void) _xermsg (_dc_1, _dc_93, (bufcpy ($36_, concat ($35_, concat ($34_, concat ($33_, concat ($32_, _dc_97, _dc_98), 
            xern1_), _dc_74), xern3_), 1023), $36_), ($37_ = 9, &$37_), &_k1);
            goto _l190;
          }
        }
      }
      lds_ = 2;
      goto _l30;
    }
    else if (jp_ == 5) {
      if (ip_ > 0) {
        lopt_ = iopt_[lp_ + 2 - 1];
      }
      lds_ = 2;
      goto _l30;
    }
    else if (jp_ == 6) {
      if (ip_ > 0) {
        lp_ = iopt_[lp_ + 2 - 1] - 1;
        lds_ = 0;
      }
      else {
        lds_ = 2;
      }
      goto _l30;
    }
    else {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbols:647", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100130_[__fcnt] != NULL && $f_100130_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:647", 0));
        __fcnt += 3;
      }
      if ($f_100130_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100130_[__fcnt] != NULL && $f_100130_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100130_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:647", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100130_[__fcnt + 2], &jp_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbols:647", 0));
      __fcnt += 3;
      while ($f_100130_[__fcnt] != NULL && $f_100130_[__fcnt] == FMT_TEXT) {
        if ($f_100130_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100130_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:647", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_93, (bufcpy ($40_, concat ($39_, concat ($38_, _dc_99, xern1_), _dc_76), 127), $40_), ($41_ 
      = 6, &$41_), &_k1);
      goto _l190;
    }
    _l50:;
    if (checkl_) {
      if (lmdw_ < (*mrows_)) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:662", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100137_[__fcnt] != NULL && $f_100137_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100137_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:662", 0));
          __fcnt += 3;
        }
        if ($f_100137_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100137_[__fcnt] != NULL && $f_100137_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100137_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:662", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100137_[__fcnt + 2], &lmdw_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:662", 0));
        __fcnt += 3;
        while ($f_100137_[__fcnt] != NULL && $f_100137_[__fcnt] == FMT_TEXT) {
          if ($f_100137_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100137_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:662", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:663", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100138_[__fcnt] != NULL && $f_100138_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100138_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:663", 0));
          __fcnt += 3;
        }
        if ($f_100138_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100138_[__fcnt] != NULL && $f_100138_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100138_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:663", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100138_[__fcnt + 2], &(*mrows_), INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:663", 0));
        __fcnt += 3;
        while ($f_100138_[__fcnt] != NULL && $f_100138_[__fcnt] == FMT_TEXT) {
          if ($f_100138_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100138_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:663", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_93, (bufcpy ($45_, concat ($44_, concat ($43_, concat ($42_, _dc_77, xern1_), _dc_100), 
        xern2_), 255), $45_), ($46_ = 11, &$46_), &_k1);
        goto _l190;
      }
      if (lndw_ < (*ncols_) + 1) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:672", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100143_[__fcnt] != NULL && $f_100143_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100143_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:672", 0));
          __fcnt += 3;
        }
        if ($f_100143_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100143_[__fcnt] != NULL && $f_100143_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100143_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:672", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100143_[__fcnt + 2], &lndw_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:672", 0));
        __fcnt += 3;
        while ($f_100143_[__fcnt] != NULL && $f_100143_[__fcnt] == FMT_TEXT) {
          if ($f_100143_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100143_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:672", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:673", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100144_[__fcnt] != NULL && $f_100144_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100144_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:673", 0));
          __fcnt += 3;
        }
        $47_ = (*ncols_) + 1;
        if ($f_100144_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100144_[__fcnt] != NULL && $f_100144_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100144_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:673", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100144_[__fcnt + 2], &$47_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:673", 0));
        __fcnt += 3;
        while ($f_100144_[__fcnt] != NULL && $f_100144_[__fcnt] == FMT_TEXT) {
          if ($f_100144_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100144_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:673", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_93, (bufcpy ($51_, concat ($50_, concat ($49_, concat ($48_, _dc_79, xern1_), _dc_101), 
        xern2_), 255), $51_), ($52_ = 12, &$52_), &_k1);
        goto _l190;
      }
      if (llb_ < (*ncols_)) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:680", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100149_[__fcnt] != NULL && $f_100149_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100149_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:680", 0));
          __fcnt += 3;
        }
        if ($f_100149_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100149_[__fcnt] != NULL && $f_100149_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100149_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:680", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100149_[__fcnt + 2], &llb_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:680", 0));
        __fcnt += 3;
        while ($f_100149_[__fcnt] != NULL && $f_100149_[__fcnt] == FMT_TEXT) {
          if ($f_100149_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100149_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:680", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:681", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100150_[__fcnt] != NULL && $f_100150_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100150_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:681", 0));
          __fcnt += 3;
        }
        if ($f_100150_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100150_[__fcnt] != NULL && $f_100150_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100150_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:681", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100150_[__fcnt + 2], &(*ncols_), INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:681", 0));
        __fcnt += 3;
        while ($f_100150_[__fcnt] != NULL && $f_100150_[__fcnt] == FMT_TEXT) {
          if ($f_100150_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100150_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:681", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_93, (bufcpy ($56_, concat ($55_, concat ($54_, concat ($53_, _dc_102, xern1_), _dc_103), 
        xern2_), 511), $56_), ($57_ = 13, &$57_), &_k1);
        goto _l190;
      }
      if (llx_ < lenx_) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:690", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100155_[__fcnt] != NULL && $f_100155_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100155_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:690", 0));
          __fcnt += 3;
        }
        if ($f_100155_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100155_[__fcnt] != NULL && $f_100155_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100155_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:690", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100155_[__fcnt + 2], &llx_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:690", 0));
        __fcnt += 3;
        while ($f_100155_[__fcnt] != NULL && $f_100155_[__fcnt] == FMT_TEXT) {
          if ($f_100155_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100155_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:690", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:691", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:691", 0));
          __fcnt += 3;
        }
        if ($f_100156_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:691", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100156_[__fcnt + 2], &lenx_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:691", 0));
        __fcnt += 3;
        while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
          if ($f_100156_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:691", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_93, (bufcpy ($61_, concat ($60_, concat ($59_, concat ($58_, _dc_83, xern1_), _dc_84), 
        xern2_), 255), $61_), ($62_ = 14, &$62_), &_k1);
        goto _l190;
      }
      if (llrw_ < 5 * (*ncols_)) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:700", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100161_[__fcnt] != NULL && $f_100161_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100161_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:700", 0));
          __fcnt += 3;
        }
        if ($f_100161_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100161_[__fcnt] != NULL && $f_100161_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100161_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:700", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100161_[__fcnt + 2], &llrw_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:700", 0));
        __fcnt += 3;
        while ($f_100161_[__fcnt] != NULL && $f_100161_[__fcnt] == FMT_TEXT) {
          if ($f_100161_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100161_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:700", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:701", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100162_[__fcnt] != NULL && $f_100162_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100162_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:701", 0));
          __fcnt += 3;
        }
        $63_ = 5 * (*ncols_);
        if ($f_100162_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100162_[__fcnt] != NULL && $f_100162_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100162_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:701", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100162_[__fcnt + 2], &$63_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:701", 0));
        __fcnt += 3;
        while ($f_100162_[__fcnt] != NULL && $f_100162_[__fcnt] == FMT_TEXT) {
          if ($f_100162_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100162_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:701", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_93, (bufcpy ($67_, concat ($66_, concat ($65_, concat ($64_, _dc_85, xern1_), _dc_104), 
        xern2_), 255), $67_), ($68_ = 15, &$68_), &_k1);
        goto _l190;
      }
      if (lliw_ < 2 * (*ncols_)) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:709", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100167_[__fcnt] != NULL && $f_100167_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100167_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:709", 0));
          __fcnt += 3;
        }
        if ($f_100167_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100167_[__fcnt] != NULL && $f_100167_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100167_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:709", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100167_[__fcnt + 2], &lliw_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:709", 0));
        __fcnt += 3;
        while ($f_100167_[__fcnt] != NULL && $f_100167_[__fcnt] == FMT_TEXT) {
          if ($f_100167_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100167_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:709", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:710", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100168_[__fcnt] != NULL && $f_100168_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100168_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:710", 0));
          __fcnt += 3;
        }
        $69_ = 2 * (*ncols_);
        if ($f_100168_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100168_[__fcnt] != NULL && $f_100168_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100168_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:710", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100168_[__fcnt + 2], &$69_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:710", 0));
        __fcnt += 3;
        while ($f_100168_[__fcnt] != NULL && $f_100168_[__fcnt] == FMT_TEXT) {
          if ($f_100168_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100168_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:710", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_93, (bufcpy ($73_, concat ($72_, concat ($71_, concat ($70_, _dc_87, xern1_), _dc_105), 
        xern2_), 255), $73_), ($74_ = 16, &$74_), &_k1);
        goto _l190;
      }
      if (liopt_ < lp_ + 1) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:718", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100173_[__fcnt] != NULL && $f_100173_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100173_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:718", 0));
          __fcnt += 3;
        }
        if ($f_100173_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100173_[__fcnt] != NULL && $f_100173_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100173_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:718", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100173_[__fcnt + 2], &liopt_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:718", 0));
        __fcnt += 3;
        while ($f_100173_[__fcnt] != NULL && $f_100173_[__fcnt] == FMT_TEXT) {
          if ($f_100173_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100173_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:718", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbols:719", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100174_[__fcnt] != NULL && $f_100174_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100174_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:719", 0));
          __fcnt += 3;
        }
        $75_ = lp_ + 1;
        if ($f_100174_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100174_[__fcnt] != NULL && $f_100174_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100174_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbols:719", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100174_[__fcnt + 2], &$75_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:719", 0));
        __fcnt += 3;
        while ($f_100174_[__fcnt] != NULL && $f_100174_[__fcnt] == FMT_TEXT) {
          if ($f_100174_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100174_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbols:719", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_93, (bufcpy ($79_, concat ($78_, concat ($77_, concat ($76_, _dc_89, xern1_), _dc_90), 
        xern2_), 255), $79_), ($80_ = 17, &$80_), &_k1);
        goto _l190;
      }
    }
  }
  switch (igo_) {
    default:
    case 1: goto _l60;
    case 2: goto _l90;
  }
  goto _l180;
  _l60:;
  (*mrows_) = iopt_[locacc_ + 1 - 1] - 1;
  inrows_ = iopt_[locacc_ + 2 - 1];
  mnew_ = (*mrows_) + inrows_;
  if (mnew_ < 0 || mnew_ > (*mdw_)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dbols:742", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100187_[__fcnt] != NULL && $f_100187_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100187_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbols:742", 0));
      __fcnt += 3;
    }
    if ($f_100187_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100187_[__fcnt] != NULL && $f_100187_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100187_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:742", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100187_[__fcnt + 2], &mnew_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dbols:742", 0));
    __fcnt += 3;
    while ($f_100187_[__fcnt] != NULL && $f_100187_[__fcnt] == FMT_TEXT) {
      if ($f_100187_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100187_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbols:742", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dbols:743", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100188_[__fcnt] != NULL && $f_100188_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100188_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbols:743", 0));
      __fcnt += 3;
    }
    if ($f_100188_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100188_[__fcnt] != NULL && $f_100188_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100188_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbols:743", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100188_[__fcnt + 2], &(*mdw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dbols:743", 0));
    __fcnt += 3;
    while ($f_100188_[__fcnt] != NULL && $f_100188_[__fcnt] == FMT_TEXT) {
      if ($f_100188_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100188_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbols:743", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_93, (bufcpy ($84_, concat ($83_, concat ($82_, concat ($81_, _dc_91, xern1_), _dc_106), 
    xern2_), 255), $84_), ($85_ = 10, &$85_), &_k1);
    goto _l190;
  }
  for (j_ = 1; j_ <= _min ((*ncols_) + 1, mnew_); (j_)++) {
    for (i_ = mnew_; i_ >= _max ((*mrows_), j_) + 1; (i_)--) {
      ibig_ = _idamax (($86_ = i_ - j_, &$86_), &w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))], &_k1) + j_ - 1;
      (void) _drotg (&w_[ibig_ - 1 + ((*mdw_)) * ((j_ - 1))], &w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))], &sc_, &ss_);
      (void) _drot (($87_ = (*ncols_) + 1 - j_, &$87_), &w_[ibig_ - 1 + ((*mdw_)) * ((j_ + 1 - 1))], mdw_, &w_[i_ - 1 + 
      ((*mdw_)) * ((j_ + 1 - 1))], mdw_, &sc_, &ss_);
      w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] = zero_;
    }
  }
  (*mrows_) = _min ((*ncols_) + 1, mnew_);
  iopt_[locacc_ + 1 - 1] = (*mrows_) + 1;
  igo_ = iopt_[locacc_ - 1];
  if (igo_ == 2) {
    igo_ = 0;
  }
  goto _l180;
  _l90:;
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    switch (iscale_) {
      default:
      case 1: goto _l100;
      case 2: goto _l110;
      case 3: goto _l120;
      case 4: goto _l130;
    }
    goto _l140;
    _l100:;
    ibig_ = _idamax (mrows_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
    rw_[j_ - 1] = _abs (w_[ibig_ - 1 + ((*mdw_)) * ((j_ - 1))]);
    if (rw_[j_ - 1] == zero_) {
      rw_[j_ - 1] = one_;
    }
    else {
      rw_[j_ - 1] = one_ / rw_[j_ - 1];
    }
    goto _l140;
    _l110:;
    rw_[j_ - 1] = _dnrm2 (mrows_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
    if (rw_[j_ - 1] == zero_) {
      rw_[j_ - 1] = one_;
    }
    else {
      rw_[j_ - 1] = one_ / rw_[j_ - 1];
    }
    goto _l140;
    _l120:;
    rw_[0] = one_;
    (void) _dcopy (ncols_, rw_, &_k0, rw_, &_k1);
    goto _l160;
    _l130:;
    goto _l160;
    _l140:;
  }
  _l160:;
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    iw_[j_ - 1] = j_;
    iw_[j_ + (*ncols_) - 1] = 1;
    rw_[3 * (*ncols_) + j_ - 1] = bl_[j_ - 1];
    rw_[4 * (*ncols_) + j_ - 1] = bu_[j_ - 1];
  }
  (void) _dbolsm (w_, mdw_, mrows_, ncols_, &rw_[3 * (*ncols_) + 1 - 1], &rw_[4 * (*ncols_) + 1 - 1], ind_, &iopt_[lopt_ 
  - 1], x_, rnorm_, mode_, &rw_[(*ncols_) + 1 - 1], &rw_[2 * (*ncols_) + 1 - 1], rw_, iw_, &iw_[(*ncols_) + 1 - 1]);
  igo_ = 0;
  _l180:;
  goto _l0;
  _l190:;
  if ((*mode_) >= 0) {
    (*mode_) = -nerr_;
  }
  igo_ = 0;
  _l0:;
  __calls[70].calls++;
  return 0;
}

int_4 _dbolsm (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ minput_, int_4 _p_ ncols_, real_8 _p_ bl_, real_8 _p_ bu_, 
int_4 _p_ ind_, int_4 _p_ iopt_, real_8 _p_ x_, real_8 _p_ rnorm_, int_4 _p_ mode_, real_8 _p_ rw_, real_8 _p_ ww_, 
real_8 _p_ scl_, int_4 _p_ ibasis_, int_4 _p_ ibb_)
{
  static int_4 j_, itmax_, mval_, iprint_, lp_, lds_, ip_, jp_, ioff_, i_, mrows_, nsetb_, iter_, igopr_, jcol_, itemp_, 
  jlarge_, jmag_, jbig_, lgopr_, jdrop1_, jdrop2_, jdrop_;
  static logical_4 found_, constr_;
  static real_8 alpha_, beta_, bou_, colabv_, colblo_, cl1_, cl2_, cl3_, big_, fac_, sc_, ss_, t_, tolind_, wt_, t1_, t2_
  , wbig_, wlarge_, wmag_, xnew_, tolsze_;
  static char_15 xern1_, xern2_;
  static char_31 xern3_, xern4_;
  int_4 __fcnt, __rc, $3_, $7_, $12_, $16_, $23_, $28_, $33_, $34_, $35_, $41_, $42_, $43_, $49_, $55_, $60_, $64_, $70_, 
  $75_, $83_, $87_, $88_, $90_, $91_, $92_, $93_, $94_, $98_, $100_, $101_, $102_, $103_, $104_, $105_, $106_, $107_, 
  $108_, $109_, $110_, $111_, $112_, $113_, $114_, $115_, $116_, $118_, $119_, $120_, $121_, $122_, $124_;
  real_8 $44_, $89_, $99_, $117_, $123_;
  char_31 $13_, $17_, $36_, $50_, $65_;
  char_63 $0_, $4_, $8_, $18_, $24_, $37_, $51_, $66_, $84_, $95_;
  char_127 $1_, $2_, $5_, $6_, $9_, $14_, $15_, $19_, $25_, $29_, $38_, $45_, $52_, $56_, $61_, $67_, $71_, $76_, $85_, 
  $86_, $96_, $97_;
  char_255 $10_, $11_, $20_, $26_, $27_, $30_, $39_, $40_, $46_, $53_, $54_, $57_, $62_, $63_, $68_, $69_, $72_, $77_;
  char_511 $21_, $22_, $31_, $32_, $47_, $48_, $58_, $59_, $73_, $74_, $78_;
  char_1023 $79_;
  char_2047 $80_;
  char_4095 $81_, $82_;
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern real_8 _d1mach ();
  static FORMAT $f_100017_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100023_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100029_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100030_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100037_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100038_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100047_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100048_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100049_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100058_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100059_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100065_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100066_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100099_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100100_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100107_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100108_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100118_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100119_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100126_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100137_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100148_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100149_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100156_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100170_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100171_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100172_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100182_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100238_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*minput_) <= 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dbolsm:442", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:442", 0));
      __fcnt += 3;
    }
    if ($f_100017_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:442", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100017_[__fcnt + 2], &(*minput_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:442", 0));
    __fcnt += 3;
    while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
      if ($f_100017_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:442", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_107, (bufcpy ($2_, concat ($1_, concat ($0_, _dc_108, xern1_), _dc_58), 127), $2_), ($3_ = 
    31, &$3_), &_k1);
    (*mode_) = -31;
    goto _l0;
  }
  if ((*ncols_) <= 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dbolsm:450", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:450", 0));
      __fcnt += 3;
    }
    if ($f_100023_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:450", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100023_[__fcnt + 2], &(*ncols_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:450", 0));
    __fcnt += 3;
    while ($f_100023_[__fcnt] != NULL && $f_100023_[__fcnt] == FMT_TEXT) {
      if ($f_100023_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100023_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:450", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_107, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_109, xern1_), _dc_58), 127), $6_), ($7_ = 
    32, &$7_), &_k1);
    (*mode_) = -32;
    goto _l0;
  }
  if ((*mdw_) < (*minput_)) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dbolsm:458", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:458", 0));
      __fcnt += 3;
    }
    if ($f_100029_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:458", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100029_[__fcnt + 2], &(*mdw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:458", 0));
    __fcnt += 3;
    while ($f_100029_[__fcnt] != NULL && $f_100029_[__fcnt] == FMT_TEXT) {
      if ($f_100029_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100029_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:458", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dbolsm:459", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:459", 0));
      __fcnt += 3;
    }
    if ($f_100030_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:459", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100030_[__fcnt + 2], &(*minput_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:459", 0));
    __fcnt += 3;
    while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
      if ($f_100030_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:459", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_107, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_77, xern1_), _dc_100), 
    xern2_), 255), $11_), ($12_ = 33, &$12_), &_k1);
    (*mode_) = -33;
    goto _l0;
  }
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    if (ind_[j_ - 1] < 1 || ind_[j_ - 1] > 4) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:471", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:471", 0));
        __fcnt += 3;
      }
      if ($f_100037_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:471", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100037_[__fcnt + 2], &j_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:471", 0));
      __fcnt += 3;
      while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
        if ($f_100037_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:471", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern2_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:472", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100038_[__fcnt] != NULL && $f_100038_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100038_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:472", 0));
        __fcnt += 3;
      }
      if ($f_100038_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100038_[__fcnt] != NULL && $f_100038_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100038_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:472", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100038_[__fcnt + 2], &ind_[j_ - 1], INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:472", 0));
      __fcnt += 3;
      while ($f_100038_[__fcnt] != NULL && $f_100038_[__fcnt] == FMT_TEXT) {
        if ($f_100038_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100038_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:472", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_107, (bufcpy ($15_, concat ($14_, concat ($13_, _dc_110, xern1_), _dc_111), 127), $15_), 
      ($16_ = 34, &$16_), &_k1);
      (*mode_) = -34;
      goto _l0;
    }
  }
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    if (ind_[j_ - 1] == 3) {
      if (bu_[j_ - 1] < bl_[j_ - 1]) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:483", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100047_[__fcnt] != NULL && $f_100047_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100047_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:483", 0));
          __fcnt += 3;
        }
        if ($f_100047_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100047_[__fcnt] != NULL && $f_100047_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100047_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:483", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100047_[__fcnt + 2], &j_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:483", 0));
        __fcnt += 3;
        while ($f_100047_[__fcnt] != NULL && $f_100047_[__fcnt] == FMT_TEXT) {
          if ($f_100047_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100047_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:483", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern3_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:484", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100048_[__fcnt] != NULL && $f_100048_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100048_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:484", 0));
          __fcnt += 3;
        }
        if ($f_100048_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100048_[__fcnt] != NULL && $f_100048_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100048_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:484", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100048_[__fcnt + 2], &bl_[j_ - 1], REAL, 8);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:484", 0));
        __fcnt += 3;
        while ($f_100048_[__fcnt] != NULL && $f_100048_[__fcnt] == FMT_TEXT) {
          if ($f_100048_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100048_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:484", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern4_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:485", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:485", 0));
          __fcnt += 3;
        }
        if ($f_100049_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:485", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100049_[__fcnt + 2], &bu_[j_ - 1], REAL, 8);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:485", 0));
        __fcnt += 3;
        while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
          if ($f_100049_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:485", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_107, (bufcpy ($22_, concat ($21_, concat ($20_, concat ($19_, concat ($18_, concat ($17_, 
        _dc_110, xern1_), _dc_112), xern3_), _dc_113), xern4_), 511), $22_), ($23_ = 35, &$23_), &_k1);
        (*mode_) = -35;
        goto _l0;
      }
    }
  }
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    if (ibasis_[j_ - 1] < 1 || ibasis_[j_ - 1] > (*ncols_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:499", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100058_[__fcnt] != NULL && $f_100058_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100058_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:499", 0));
        __fcnt += 3;
      }
      if ($f_100058_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100058_[__fcnt] != NULL && $f_100058_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100058_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:499", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100058_[__fcnt + 2], &ibasis_[j_ - 1], INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:499", 0));
      __fcnt += 3;
      while ($f_100058_[__fcnt] != NULL && $f_100058_[__fcnt] == FMT_TEXT) {
        if ($f_100058_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100058_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:499", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern2_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:500", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100059_[__fcnt] != NULL && $f_100059_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100059_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:500", 0));
        __fcnt += 3;
      }
      if ($f_100059_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100059_[__fcnt] != NULL && $f_100059_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100059_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:500", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100059_[__fcnt + 2], &(*ncols_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:500", 0));
      __fcnt += 3;
      while ($f_100059_[__fcnt] != NULL && $f_100059_[__fcnt] == FMT_TEXT) {
        if ($f_100059_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100059_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:500", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_107, (bufcpy ($27_, concat ($26_, concat ($25_, concat ($24_, _dc_114, xern1_), _dc_115), 
      xern2_), 255), $27_), ($28_ = 36, &$28_), &_k1);
      (*mode_) = -36;
      goto _l0;
    }
    if (ibb_[j_ - 1] <= 0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:509", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100065_[__fcnt] != NULL && $f_100065_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100065_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:509", 0));
        __fcnt += 3;
      }
      if ($f_100065_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100065_[__fcnt] != NULL && $f_100065_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100065_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:509", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100065_[__fcnt + 2], &j_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:509", 0));
      __fcnt += 3;
      while ($f_100065_[__fcnt] != NULL && $f_100065_[__fcnt] == FMT_TEXT) {
        if ($f_100065_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100065_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:509", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern2_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:510", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100066_[__fcnt] != NULL && $f_100066_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100066_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:510", 0));
        __fcnt += 3;
      }
      if ($f_100066_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100066_[__fcnt] != NULL && $f_100066_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100066_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:510", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100066_[__fcnt + 2], &ibb_[j_ - 1], INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:510", 0));
      __fcnt += 3;
      while ($f_100066_[__fcnt] != NULL && $f_100066_[__fcnt] == FMT_TEXT) {
        if ($f_100066_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100066_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:510", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_107, (bufcpy ($32_, concat ($31_, concat ($30_, concat ($29_, _dc_116, xern1_), _dc_117), 
      xern2_), 511), $32_), ($33_ = 37, &$33_), &_k1);
      (*mode_) = -37;
      goto _l0;
    }
  }
  fac_ = 0.75;
  tolind_ = sqrt (_d1mach (($34_ = 4, &$34_)));
  tolsze_ = sqrt (_d1mach (($35_ = 4, &$35_)));
  itmax_ = 5 * _max ((*minput_), (*ncols_));
  wt_ = 1.0;
  mval_ = 0;
  iprint_ = 0;
  lp_ = 0;
  lds_ = 0;
  _l590:;
  lp_ = lp_ + lds_;
  ip_ = iopt_[lp_ + 1 - 1];
  jp_ = _abs (ip_);
  if (ip_ == 99) {
    goto _l470;
  }
  else if (jp_ == 99) {
    lds_ = 1;
  }
  else if (jp_ == 1) {
    if (ip_ > 0) {
      lp_ = iopt_[lp_ + 2 - 1] - 1;
      lds_ = 0;
    }
    else {
      lds_ = 2;
    }
  }
  else if (jp_ == 2) {
    if (ip_ > 0) {
      ioff_ = iopt_[lp_ + 2 - 1];
      if (ioff_ <= 0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:562", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100099_[__fcnt] != NULL && $f_100099_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100099_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:562", 0));
          __fcnt += 3;
        }
        if ($f_100099_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100099_[__fcnt] != NULL && $f_100099_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100099_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:562", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100099_[__fcnt + 2], &ioff_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:562", 0));
        __fcnt += 3;
        while ($f_100099_[__fcnt] != NULL && $f_100099_[__fcnt] == FMT_TEXT) {
          if ($f_100099_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100099_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:562", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:563", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100100_[__fcnt] != NULL && $f_100100_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100100_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:563", 0));
          __fcnt += 3;
        }
        if ($f_100100_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100100_[__fcnt] != NULL && $f_100100_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100100_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:563", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100100_[__fcnt + 2], &(*ncols_), INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:563", 0));
        __fcnt += 3;
        while ($f_100100_[__fcnt] != NULL && $f_100100_[__fcnt] == FMT_TEXT) {
          if ($f_100100_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100100_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:563", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_107, (bufcpy ($40_, concat ($39_, concat ($38_, concat ($37_, concat ($36_, _dc_118, 
        xern1_), _dc_119), xern2_), _dc_120), 255), $40_), ($41_ = 24, &$41_), &_k1);
        (*mode_) = -24;
        goto _l0;
      }
      tolind_ = x_[(*ncols_) + ioff_ - 1];
      if (tolind_ < _d1mach (($42_ = 4, &$42_))) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern3_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:573", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100107_[__fcnt] != NULL && $f_100107_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100107_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:573", 0));
          __fcnt += 3;
        }
        if ($f_100107_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100107_[__fcnt] != NULL && $f_100107_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100107_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:573", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100107_[__fcnt + 2], &tolind_, REAL, 8);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:573", 0));
        __fcnt += 3;
        while ($f_100107_[__fcnt] != NULL && $f_100107_[__fcnt] == FMT_TEXT) {
          if ($f_100107_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100107_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:573", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern4_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:574", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100108_[__fcnt] != NULL && $f_100108_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100108_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:574", 0));
          __fcnt += 3;
        }
        $44_ = _d1mach (($43_ = 4, &$43_));
        if ($f_100108_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100108_[__fcnt] != NULL && $f_100108_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100108_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:574", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100108_[__fcnt + 2], &$44_, REAL, 8);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:574", 0));
        __fcnt += 3;
        while ($f_100108_[__fcnt] != NULL && $f_100108_[__fcnt] == FMT_TEXT) {
          if ($f_100108_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100108_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:574", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_107, (bufcpy ($48_, concat ($47_, concat ($46_, concat ($45_, _dc_121, xern3_), _dc_122), 
        xern4_), 511), $48_), ($49_ = 25, &$49_), &_k0);
        (*mode_) = -25;
      }
    }
    lds_ = 2;
  }
  else if (jp_ == 3) {
    if (ip_ > 0) {
      ioff_ = iopt_[lp_ + 2 - 1];
      if (ioff_ <= 0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:591", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100118_[__fcnt] != NULL && $f_100118_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100118_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:591", 0));
          __fcnt += 3;
        }
        if ($f_100118_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100118_[__fcnt] != NULL && $f_100118_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100118_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:591", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100118_[__fcnt + 2], &ioff_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:591", 0));
        __fcnt += 3;
        while ($f_100118_[__fcnt] != NULL && $f_100118_[__fcnt] == FMT_TEXT) {
          if ($f_100118_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100118_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:591", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:592", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100119_[__fcnt] != NULL && $f_100119_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100119_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:592", 0));
          __fcnt += 3;
        }
        if ($f_100119_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100119_[__fcnt] != NULL && $f_100119_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100119_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:592", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100119_[__fcnt + 2], &(*ncols_), INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:592", 0));
        __fcnt += 3;
        while ($f_100119_[__fcnt] != NULL && $f_100119_[__fcnt] == FMT_TEXT) {
          if ($f_100119_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100119_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:592", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_107, (bufcpy ($54_, concat ($53_, concat ($52_, concat ($51_, concat ($50_, _dc_118, 
        xern1_), _dc_119), xern2_), _dc_123), 255), $54_), ($55_ = 26, &$55_), &_k1);
        (*mode_) = -26;
        goto _l0;
      }
      tolsze_ = x_[(*ncols_) + ioff_ - 1];
      if (tolsze_ <= 0.0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern3_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:602", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100126_[__fcnt] != NULL && $f_100126_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100126_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:602", 0));
          __fcnt += 3;
        }
        if ($f_100126_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100126_[__fcnt] != NULL && $f_100126_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100126_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:602", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100126_[__fcnt + 2], &tolsze_, REAL, 8);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:602", 0));
        __fcnt += 3;
        while ($f_100126_[__fcnt] != NULL && $f_100126_[__fcnt] == FMT_TEXT) {
          if ($f_100126_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100126_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:602", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_107, (bufcpy ($59_, concat ($58_, concat ($57_, concat ($56_, _dc_124, _dc_125), _dc_126), 
        xern3_), 511), $59_), ($60_ = 27, &$60_), &_k1);
        (*mode_) = -27;
        goto _l0;
      }
    }
    lds_ = 2;
  }
  else if (jp_ == 4) {
    if (ip_ > 0) {
      itmax_ = iopt_[lp_ + 2 - 1];
      if (itmax_ <= 0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:618", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100137_[__fcnt] != NULL && $f_100137_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100137_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:618", 0));
          __fcnt += 3;
        }
        if ($f_100137_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100137_[__fcnt] != NULL && $f_100137_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100137_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:618", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100137_[__fcnt + 2], &itmax_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:618", 0));
        __fcnt += 3;
        while ($f_100137_[__fcnt] != NULL && $f_100137_[__fcnt] == FMT_TEXT) {
          if ($f_100137_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100137_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:618", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_107, (bufcpy ($63_, concat ($62_, concat ($61_, _dc_127, xern1_), _dc_58), 255), $63_), 
        ($64_ = 28, &$64_), &_k1);
        (*mode_) = -28;
        goto _l0;
      }
    }
    lds_ = 2;
  }
  else if (jp_ == 5) {
    if (ip_ > 0) {
      ioff_ = iopt_[lp_ + 2 - 1];
      if (ioff_ <= 0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern1_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:634", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100148_[__fcnt] != NULL && $f_100148_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100148_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:634", 0));
          __fcnt += 3;
        }
        if ($f_100148_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100148_[__fcnt] != NULL && $f_100148_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100148_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:634", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100148_[__fcnt + 2], &ioff_, INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:634", 0));
        __fcnt += 3;
        while ($f_100148_[__fcnt] != NULL && $f_100148_[__fcnt] == FMT_TEXT) {
          if ($f_100148_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100148_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:634", 0));
          __fcnt += 3;
        }
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
        _ffile[0].lrecl = 15;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern2_, 15, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:635", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100149_[__fcnt] != NULL && $f_100149_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100149_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:635", 0));
          __fcnt += 3;
        }
        if ($f_100149_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100149_[__fcnt] != NULL && $f_100149_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100149_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:635", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100149_[__fcnt + 2], &(*ncols_), INTEGER, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:635", 0));
        __fcnt += 3;
        while ($f_100149_[__fcnt] != NULL && $f_100149_[__fcnt] == FMT_TEXT) {
          if ($f_100149_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100149_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:635", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_107, (bufcpy ($69_, concat ($68_, concat ($67_, concat ($66_, concat ($65_, _dc_118, 
        xern1_), _dc_119), xern2_), _dc_128), 255), $69_), ($70_ = 29, &$70_), &_k1);
        (*mode_) = -29;
        goto _l0;
      }
      fac_ = x_[(*ncols_) + ioff_ - 1];
      if (fac_ < 0.0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern3_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:dbolsm:645", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:645", 0));
          __fcnt += 3;
        }
        if ($f_100156_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:645", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100156_[__fcnt + 2], &fac_, REAL, 8);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:645", 0));
        __fcnt += 3;
        while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
          if ($f_100156_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:645", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_107, (bufcpy ($74_, concat ($73_, concat ($72_, concat ($71_, _dc_129, _dc_130), _dc_131), 
        xern3_), 511), $74_), ($75_ = 30, &$75_), &_k0);
        (*mode_) = -30;
        goto _l0;
      }
    }
    lds_ = 2;
  }
  else if (jp_ == 6) {
    if (ip_ > 0) {
      ioff_ = iopt_[lp_ + 2 - 1];
      mval_ = iopt_[lp_ + 3 - 1];
      wt_ = x_[(*ncols_) + ioff_ - 1];
    }
    if (mval_ < 0 || mval_ > (*minput_) || wt_ <= 0.0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:669", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100170_[__fcnt] != NULL && $f_100170_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100170_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:669", 0));
        __fcnt += 3;
      }
      if ($f_100170_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100170_[__fcnt] != NULL && $f_100170_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100170_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:669", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100170_[__fcnt + 2], &mval_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:669", 0));
      __fcnt += 3;
      while ($f_100170_[__fcnt] != NULL && $f_100170_[__fcnt] == FMT_TEXT) {
        if ($f_100170_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100170_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:669", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern2_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:670", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100171_[__fcnt] != NULL && $f_100171_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100171_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:670", 0));
        __fcnt += 3;
      }
      if ($f_100171_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100171_[__fcnt] != NULL && $f_100171_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100171_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:670", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100171_[__fcnt + 2], &(*minput_), INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:670", 0));
      __fcnt += 3;
      while ($f_100171_[__fcnt] != NULL && $f_100171_[__fcnt] == FMT_TEXT) {
        if ($f_100171_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100171_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:670", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dbolsm:671", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100172_[__fcnt] != NULL && $f_100172_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100172_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:671", 0));
        __fcnt += 3;
      }
      if ($f_100172_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100172_[__fcnt] != NULL && $f_100172_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100172_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:671", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100172_[__fcnt + 2], &wt_, REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:671", 0));
      __fcnt += 3;
      while ($f_100172_[__fcnt] != NULL && $f_100172_[__fcnt] == FMT_TEXT) {
        if ($f_100172_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100172_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:671", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_107, (bufcpy ($82_, concat ($81_, concat ($80_, concat ($79_, concat ($78_, concat ($77_, 
      concat ($76_, _dc_132, xern1_), _dc_133), xern2_), _dc_134), xern3_), _dc_58), 4095), $82_), ($83_ = 38, &$83_), &_k0)
      ;
      (*mode_) = -38;
      goto _l0;
    }
    lds_ = 3;
  }
  else if (jp_ == 7) {
    if (ip_ > 0) {
      iprint_ = 1;
    }
    lds_ = 2;
  }
  else {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dbolsm:687", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100182_[__fcnt] != NULL && $f_100182_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100182_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:687", 0));
      __fcnt += 3;
    }
    if ($f_100182_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100182_[__fcnt] != NULL && $f_100182_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100182_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:687", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100182_[__fcnt + 2], &ip_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:687", 0));
    __fcnt += 3;
    while ($f_100182_[__fcnt] != NULL && $f_100182_[__fcnt] == FMT_TEXT) {
      if ($f_100182_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100182_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:687", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_107, (bufcpy ($86_, concat ($85_, concat ($84_, _dc_99, xern1_), _dc_76), 127), $86_), ($87_ 
    = 23, &$87_), &_k1);
    (*mode_) = -23;
    goto _l0;
  }
  goto _l590;
  _l470:;
  if (fac_ * (*minput_) > (*ncols_)) {
    for (j_ = 1; j_ <= (*ncols_) + 1; (j_)++) {
      for (i_ = (*minput_); i_ >= j_ + mval_ + 1; (i_)--) {
        (void) _drotg (&w_[i_ - 1 - 1 + ((*mdw_)) * ((j_ - 1))], &w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))], &sc_, &ss_);
        w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] = 0.0;
        (void) _drot (($88_ = (*ncols_) - j_ + 1, &$88_), &w_[i_ - 1 - 1 + ((*mdw_)) * ((j_ + 1 - 1))], mdw_, &w_[i_ - 1 + 
        ((*mdw_)) * ((j_ + 1 - 1))], mdw_, &sc_, &ss_);
      }
    }
    mrows_ = (*ncols_) + mval_ + 1;
  }
  else {
    mrows_ = (*minput_);
  }
  (void) _dcopy (ncols_, ($89_ = 0.0, &$89_), &_k0, x_, &_k1);
  big_ = _d1mach (($90_ = 2, &$90_));
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    if (ind_[j_ - 1] == 1) {
      bu_[j_ - 1] = big_;
    }
    else if (ind_[j_ - 1] == 2) {
      bl_[j_ - 1] = -big_;
    }
    else if (ind_[j_ - 1] == 4) {
      bl_[j_ - 1] = -big_;
      bu_[j_ - 1] = big_;
    }
  }
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    if ((bl_[j_ - 1] <= 0.0 && 0.0 <= bu_[j_ - 1] && _abs (bu_[j_ - 1]) < _abs (bl_[j_ - 1])) || bu_[j_ - 1] < 0.0) {
      t_ = bu_[j_ - 1];
      bu_[j_ - 1] = -bl_[j_ - 1];
      bl_[j_ - 1] = -t_;
      scl_[j_ - 1] = -scl_[j_ - 1];
      for (i_ = 1; i_ <= mrows_; (i_)++) {
        w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] = -w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))];
      }
    }
    if (bl_[j_ - 1] >= 0.0) {
      ibasis_[j_ - 1] = -ibasis_[j_ - 1];
      t_ = -bl_[j_ - 1];
      bu_[j_ - 1] = bu_[j_ - 1] + t_;
      (void) _daxpy (&mrows_, &t_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1, &w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))], &_k1);
    }
  }
  nsetb_ = 0;
  iter_ = 0;
  if (iprint_ > 0) {
    (void) _dmout (&mrows_, ($91_ = (*ncols_) + 1, &$91_), mdw_, w_, _dc_135, ($92_ = -4, &$92_));
    (void) _dvout (ncols_, bl_, _dc_136, ($93_ = -4, &$93_));
    (void) _dvout (ncols_, bu_, _dc_137, ($94_ = -4, &$94_));
  }
  _l580:;
  iter_ = iter_ + 1;
  if (iter_ > itmax_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dbolsm:766", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100238_[__fcnt] != NULL && $f_100238_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100238_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:766", 0));
      __fcnt += 3;
    }
    if ($f_100238_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100238_[__fcnt] != NULL && $f_100238_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100238_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:766", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100238_[__fcnt + 2], &itmax_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:766", 0));
    __fcnt += 3;
    while ($f_100238_[__fcnt] != NULL && $f_100238_[__fcnt] == FMT_TEXT) {
      if ($f_100238_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100238_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dbolsm:766", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_107, (bufcpy ($97_, concat ($96_, concat ($95_, _dc_138, xern1_), _dc_139), 127), $97_), 
    ($98_ = 22, &$98_), &_k1);
    (*mode_) = -22;
    igopr_ = 1;
    goto _l130;
  }
  (void) _dcopy (ncols_, ($99_ = 0.0, &$99_), &_k0, ww_, &_k1);
  for (j_ = nsetb_ + 1; j_ <= (*ncols_); (j_)++) {
    jcol_ = _abs (ibasis_[j_ - 1]);
    ww_[j_ - 1] = _ddot (($100_ = mrows_ - nsetb_, &$100_), &w_[({int_4 idum__1_ = nsetb_; _min (idum__1_ + 1, mrows_);}) - 
    1 + ((*mdw_)) * ((j_ - 1))], &_k1, &w_[({int_4 idum__1_ = nsetb_; _min (idum__1_ + 1, mrows_);}) - 1 + ((*mdw_)) * 
    (((*ncols_) + 1 - 1))], &_k1) * _abs (scl_[jcol_ - 1]);
  }
  if (iprint_ > 0) {
    (void) _dvout (ncols_, ww_, _dc_140, ($101_ = -4, &$101_));
    (void) _ivout (ncols_, ibasis_, _dc_141, ($102_ = -4, &$102_));
    (void) _ivout (ncols_, ibb_, _dc_142, ($103_ = -4, &$103_));
  }
  _l210:;
  if (nsetb_ == mrows_) {
    found_ = FALSE;
    goto _l120;
  }
  wlarge_ = -big_;
  wmag_ = -big_;
  for (j_ = nsetb_ + 1; j_ <= (*ncols_); (j_)++) {
    t_ = ww_[j_ - 1];
    if (t_ == big_) {
      goto _l220;
    }
    itemp_ = ibasis_[j_ - 1];
    jcol_ = _abs (itemp_);
    t1_ = _dnrm2 (($104_ = mval_ - nsetb_, &$104_), &w_[({int_4 idum__1_ = nsetb_; _min (idum__1_ + 1, mrows_);}) - 1 + 
    ((*mdw_)) * ((j_ - 1))], &_k1);
    if (itemp_ < 0) {
      if (_imod (ibb_[jcol_ - 1], 2) == 0) {
        t_ = -t_;
      }
      if (t_ < 0.0) {
        goto _l220;
      }
      if (mval_ > nsetb_) {
        t_ = t1_;
      }
      if (t_ > wlarge_) {
        wlarge_ = t_;
        jlarge_ = j_;
      }
    }
    else {
      if (mval_ > nsetb_) {
        t_ = t1_;
      }
      if (_abs (t_) > wmag_) {
        wmag_ = _abs (t_);
        jmag_ = j_;
      }
    }
    _l220:;
  }
  jbig_ = 0;
  wbig_ = 0.0;
  if (wlarge_ > 0.0) {
    jbig_ = jlarge_;
    wbig_ = wlarge_;
  }
  if (wmag_ >= wbig_) {
    jbig_ = jmag_;
    wbig_ = wmag_;
  }
  if (jbig_ == 0) {
    found_ = FALSE;
    if (iprint_ > 0) {
      (void) _ivout (&_k0, &i_, _dc_143, ($105_ = -4, &$105_));
    }
    goto _l120;
  }
  if (iprint_ > 0) {
    (void) _ivout (&_k1, &jbig_, _dc_144, ($106_ = -4, &$106_));
  }
  if (mval_ <= nsetb_) {
    cl1_ = _dnrm2 (&mval_, &w_[0 + ((*mdw_)) * ((jbig_ - 1))], &_k1);
    cl2_ = _abs (wt_) * _dnrm2 (($107_ = nsetb_ - mval_, &$107_), &w_[({int_4 idum__1_ = mval_; _min (idum__1_ + 1, 
    mrows_);}) - 1 + ((*mdw_)) * ((jbig_ - 1))], &_k1);
    cl3_ = _abs (wt_) * _dnrm2 (($108_ = mrows_ - nsetb_, &$108_), &w_[({int_4 idum__1_ = nsetb_; _min (idum__1_ + 1, 
    mrows_);}) - 1 + ((*mdw_)) * ((jbig_ - 1))], &_k1);
    (void) _drotg (&cl1_, &cl2_, &sc_, &ss_);
    colabv_ = _abs (cl1_);
    colblo_ = cl3_;
  }
  else {
    cl1_ = _dnrm2 (&nsetb_, &w_[0 + ((*mdw_)) * ((jbig_ - 1))], &_k1);
    cl2_ = _dnrm2 (($109_ = mval_ - nsetb_, &$109_), &w_[({int_4 idum__1_ = nsetb_; _min (idum__1_ + 1, mrows_);}) - 1 + 
    ((*mdw_)) * ((jbig_ - 1))], &_k1);
    cl3_ = _abs (wt_) * _dnrm2 (($110_ = mrows_ - mval_, &$110_), &w_[({int_4 idum__1_ = mval_; _min (idum__1_ + 1, 
    mrows_);}) - 1 + ((*mdw_)) * ((jbig_ - 1))], &_k1);
    colabv_ = cl1_;
    (void) _drotg (&cl2_, &cl3_, &sc_, &ss_);
    colblo_ = _abs (cl2_);
  }
  if (colblo_ <= tolind_ * colabv_) {
    ww_[jbig_ - 1] = big_;
    if (iprint_ > 0) {
      (void) _ivout (&_k0, &i_, _dc_145, ($111_ = -4, &$111_));
    }
    goto _l210;
  }
  nsetb_ = nsetb_ + 1;
  if (nsetb_ != jbig_) {
    (void) _dswap (&mrows_, &w_[0 + ((*mdw_)) * ((nsetb_ - 1))], &_k1, &w_[0 + ((*mdw_)) * ((jbig_ - 1))], &_k1);
    (void) _dswap (&_k1, &ww_[nsetb_ - 1], &_k1, &ww_[jbig_ - 1], &_k1);
    itemp_ = ibasis_[nsetb_ - 1];
    ibasis_[nsetb_ - 1] = ibasis_[jbig_ - 1];
    ibasis_[jbig_ - 1] = itemp_;
  }
  if (mrows_ > nsetb_) {
    for (i_ = mrows_; i_ >= nsetb_ + 1; (i_)--) {
      if (i_ == mval_ + 1) {
        goto _l230;
      }
      (void) _drotg (&w_[i_ - 1 - 1 + ((*mdw_)) * ((nsetb_ - 1))], &w_[i_ - 1 + ((*mdw_)) * ((nsetb_ - 1))], &sc_, &ss_);
      w_[i_ - 1 + ((*mdw_)) * ((nsetb_ - 1))] = 0.0;
      (void) _drot (($112_ = (*ncols_) - nsetb_ + 1, &$112_), &w_[i_ - 1 - 1 + ((*mdw_)) * ((nsetb_ + 1 - 1))], mdw_, &w_[i_ 
      - 1 + ((*mdw_)) * ((nsetb_ + 1 - 1))], mdw_, &sc_, &ss_);
      _l230:;
    }
    if (mval_ >= nsetb_ && mval_ < mrows_) {
      (void) _drotg (&w_[nsetb_ - 1 + ((*mdw_)) * ((nsetb_ - 1))], &w_[mval_ + 1 - 1 + ((*mdw_)) * ((nsetb_ - 1))], &sc_, 
      &ss_);
      w_[mval_ + 1 - 1 + ((*mdw_)) * ((nsetb_ - 1))] = 0.0;
      (void) _drot (($113_ = (*ncols_) - nsetb_ + 1, &$113_), &w_[nsetb_ - 1 + ((*mdw_)) * ((nsetb_ + 1 - 1))], mdw_, 
      &w_[mval_ + 1 - 1 + ((*mdw_)) * ((nsetb_ + 1 - 1))], mdw_, &sc_, &ss_);
    }
  }
  if (w_[nsetb_ - 1 + ((*mdw_)) * ((nsetb_ - 1))] == 0.0) {
    ww_[nsetb_ - 1] = big_;
    nsetb_ = nsetb_ - 1;
    if (iprint_ > 0) {
      (void) _ivout (&_k0, &i_, _dc_146, ($114_ = -4, &$114_));
    }
    goto _l210;
  }
  itemp_ = ibasis_[nsetb_ - 1];
  jcol_ = _abs (itemp_);
  xnew_ = (w_[nsetb_ - 1 + ((*mdw_)) * (((*ncols_) + 1 - 1))] / w_[nsetb_ - 1 + ((*mdw_)) * ((nsetb_ - 1))]) / _abs 
  (scl_[jcol_ - 1]);
  if (itemp_ < 0) {
    if ((ww_[nsetb_ - 1] >= 0.0 && xnew_ <= 0.0) || (ww_[nsetb_ - 1] <= 0.0 && xnew_ >= 0.0)) {
      goto _l240;
    }
  }
  found_ = TRUE;
  goto _l120;
  _l240:;
  ww_[nsetb_ - 1] = big_;
  nsetb_ = nsetb_ - 1;
  if (iprint_ > 0) {
    (void) _ivout (&_k0, &i_, _dc_147, ($115_ = -4, &$115_));
  }
  goto _l210;
  _l270:;
  (void) _dcopy (&nsetb_, &w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))], &_k1, rw_, &_k1);
  for (j_ = nsetb_; j_ >= 1; (j_)--) {
    rw_[j_ - 1] = rw_[j_ - 1] / w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))];
    jcol_ = _abs (ibasis_[j_ - 1]);
    t_ = rw_[j_ - 1];
    if (_imod (ibb_[jcol_ - 1], 2) == 0) {
      rw_[j_ - 1] = -rw_[j_ - 1];
    }
    (void) _daxpy (($116_ = j_ - 1, &$116_), ($117_ = -t_, &$117_), &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1, rw_, &_k1);
    rw_[j_ - 1] = rw_[j_ - 1] / _abs (scl_[jcol_ - 1]);
  }
  if (iprint_ > 0) {
    (void) _dvout (&nsetb_, rw_, _dc_148, ($118_ = -4, &$118_));
    (void) _ivout (&nsetb_, ibasis_, _dc_149, ($119_ = -4, &$119_));
  }
  if (lgopr_ == 2) {
    (void) _dcopy (&nsetb_, rw_, &_k1, x_, &_k1);
    for (j_ = 1; j_ <= nsetb_; (j_)++) {
      itemp_ = ibasis_[j_ - 1];
      jcol_ = _abs (itemp_);
      if (itemp_ < 0) {
        bou_ = 0.0;
      }
      else {
        bou_ = bl_[jcol_ - 1];
      }
      if ((-bou_) != big_) {
        bou_ = bou_ / _abs (scl_[jcol_ - 1]);
      }
      if (x_[j_ - 1] <= bou_) {
        jdrop1_ = j_;
        goto _l340;
      }
      bou_ = bu_[jcol_ - 1];
      if (bou_ != big_) {
        bou_ = bou_ / _abs (scl_[jcol_ - 1]);
      }
      if (x_[j_ - 1] >= bou_) {
        jdrop2_ = j_;
        goto _l340;
      }
    }
    goto _l340;
  }
  alpha_ = 2.0;
  beta_ = 2.0;
  x_[nsetb_ - 1] = 0.0;
  for (j_ = 1; j_ <= nsetb_; (j_)++) {
    itemp_ = ibasis_[j_ - 1];
    jcol_ = _abs (itemp_);
    t1_ = 2.0;
    t2_ = 2.0;
    if (itemp_ < 0) {
      bou_ = 0.0;
    }
    else {
      bou_ = bl_[jcol_ - 1];
    }
    if ((-bou_) != big_) {
      bou_ = bou_ / _abs (scl_[jcol_ - 1]);
    }
    if (rw_[j_ - 1] <= bou_) {
      t1_ = (x_[j_ - 1] - bou_) / (x_[j_ - 1] - rw_[j_ - 1]);
    }
    bou_ = bu_[jcol_ - 1];
    if (bou_ != big_) {
      bou_ = bou_ / _abs (scl_[jcol_ - 1]);
    }
    if (rw_[j_ - 1] >= bou_) {
      t2_ = (bou_ - x_[j_ - 1]) / (rw_[j_ - 1] - x_[j_ - 1]);
    }
    if (t1_ < alpha_) {
      alpha_ = t1_;
      jdrop1_ = j_;
    }
    if (t2_ < beta_) {
      beta_ = t2_;
      jdrop2_ = j_;
    }
  }
  constr_ = alpha_ < 2.0 || beta_ < 2.0;
  if (! (constr_)) {
    (void) _dcopy (&nsetb_, rw_, &_k1, x_, &_k1);
    goto _l580;
  }
  for (j_ = 1; j_ <= nsetb_; (j_)++) {
    x_[j_ - 1] = x_[j_ - 1] + _min (alpha_, beta_) * (rw_[j_ - 1] - x_[j_ - 1]);
  }
  if (alpha_ <= beta_) {
    jdrop2_ = 0;
  }
  else {
    jdrop1_ = 0;
  }
  _l340:;
  if (jdrop1_ + jdrop2_ <= 0 || nsetb_ <= 0) {
    goto _l580;
  }
  jdrop_ = jdrop1_ + jdrop2_;
  itemp_ = ibasis_[jdrop_ - 1];
  jcol_ = _abs (itemp_);
  if (jdrop2_ > 0) {
    t_ = bu_[jcol_ - 1];
    if (itemp_ > 0) {
      bu_[jcol_ - 1] = t_ - bl_[jcol_ - 1];
      bl_[jcol_ - 1] = -t_;
      itemp_ = -itemp_;
      scl_[jcol_ - 1] = -scl_[jcol_ - 1];
      for (i_ = 1; i_ <= jdrop_; (i_)++) {
        w_[i_ - 1 + ((*mdw_)) * ((jdrop_ - 1))] = -w_[i_ - 1 + ((*mdw_)) * ((jdrop_ - 1))];
      }
    }
    else {
      ibb_[jcol_ - 1] = ibb_[jcol_ - 1] + 1;
      if (_imod (ibb_[jcol_ - 1], 2) == 0) {
        t_ = -t_;
      }
    }
  }
  else {
    if (itemp_ < 0.0) {
      t_ = 0.0;
    }
    else {
      t_ = -bl_[jcol_ - 1];
      bu_[jcol_ - 1] = bu_[jcol_ - 1] + t_;
      itemp_ = -itemp_;
    }
  }
  (void) _daxpy (&jdrop_, &t_, &w_[0 + ((*mdw_)) * ((jdrop_ - 1))], &_k1, &w_[0 + ((*mdw_)) * (((*ncols_) + 1 - 1))], 
  &_k1);
  (void) _dcopy (&jdrop_, &w_[0 + ((*mdw_)) * ((jdrop_ - 1))], &_k1, rw_, &_k1);
  for (j_ = jdrop_ + 1; j_ <= nsetb_; (j_)++) {
    ibasis_[j_ - 1 - 1] = ibasis_[j_ - 1];
    x_[j_ - 1 - 1] = x_[j_ - 1];
    (void) _dcopy (&j_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1, &w_[0 + ((*mdw_)) * ((j_ - 1 - 1))], &_k1);
  }
  ibasis_[nsetb_ - 1] = itemp_;
  w_[0 + ((*mdw_)) * ((nsetb_ - 1))] = 0.0;
  (void) _dcopy (($120_ = mrows_ - jdrop_, &$120_), &w_[0 + ((*mdw_)) * ((nsetb_ - 1))], &_k0, &w_[jdrop_ + 1 - 1 + 
  ((*mdw_)) * ((nsetb_ - 1))], &_k1);
  (void) _dcopy (&jdrop_, rw_, &_k1, &w_[0 + ((*mdw_)) * ((nsetb_ - 1))], &_k1);
  nsetb_ = nsetb_ - 1;
  for (i_ = jdrop_; i_ <= nsetb_; (i_)++) {
    if (i_ == mval_) {
      t_ = 0.0;
      for (j_ = i_; j_ <= nsetb_; (j_)++) {
        jcol_ = _abs (ibasis_[j_ - 1]);
        t1_ = _abs (w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] * scl_[jcol_ - 1]);
        if (t1_ > t_) {
          jbig_ = j_;
          t_ = t1_;
        }
      }
      goto _l400;
    }
    (void) _drotg (&w_[i_ - 1 + ((*mdw_)) * ((i_ - 1))], &w_[i_ + 1 - 1 + ((*mdw_)) * ((i_ - 1))], &sc_, &ss_);
    w_[i_ + 1 - 1 + ((*mdw_)) * ((i_ - 1))] = 0.0;
    (void) _drot (($121_ = (*ncols_) - i_ + 1, &$121_), &w_[i_ - 1 + ((*mdw_)) * ((i_ + 1 - 1))], mdw_, &w_[i_ + 1 - 1 + 
    ((*mdw_)) * ((i_ + 1 - 1))], mdw_, &sc_, &ss_);
  }
  goto _l430;
  _l400:;
  (void) _dswap (&mrows_, &w_[0 + ((*mdw_)) * ((i_ - 1))], &_k1, &w_[0 + ((*mdw_)) * ((jbig_ - 1))], &_k1);
  (void) _dswap (&_k1, &ww_[i_ - 1], &_k1, &ww_[jbig_ - 1], &_k1);
  (void) _dswap (&_k1, &x_[i_ - 1], &_k1, &x_[jbig_ - 1], &_k1);
  itemp_ = ibasis_[i_ - 1];
  ibasis_[i_ - 1] = ibasis_[jbig_ - 1];
  ibasis_[jbig_ - 1] = itemp_;
  jbig_ = i_;
  for (j_ = jbig_; j_ <= nsetb_; (j_)++) {
    for (i_ = j_ + 1; i_ <= mrows_; (i_)++) {
      (void) _drotg (&w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))], &w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))], &sc_, &ss_);
      w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] = 0.0;
      (void) _drot (($122_ = (*ncols_) - j_ + 1, &$122_), &w_[j_ - 1 + ((*mdw_)) * ((j_ + 1 - 1))], mdw_, &w_[i_ - 1 + 
      ((*mdw_)) * ((j_ + 1 - 1))], mdw_, &sc_, &ss_);
    }
  }
  _l430:;
  jdrop1_ = 0;
  jdrop2_ = 0;
  lgopr_ = 2;
  goto _l270;
  _l120:;
  if (found_) {
    lgopr_ = 1;
    goto _l270;
  }
  igopr_ = 2;
  _l130:;
  (void) _dcopy (&nsetb_, x_, &_k1, rw_, &_k1);
  (void) _dcopy (ncols_, ($123_ = 0.0, &$123_), &_k0, x_, &_k1);
  for (j_ = 1; j_ <= nsetb_; (j_)++) {
    jcol_ = _abs (ibasis_[j_ - 1]);
    x_[jcol_ - 1] = rw_[j_ - 1] * _abs (scl_[jcol_ - 1]);
  }
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    if (_imod (ibb_[j_ - 1], 2) == 0) {
      x_[j_ - 1] = bu_[j_ - 1] - x_[j_ - 1];
    }
  }
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    jcol_ = ibasis_[j_ - 1];
    if (jcol_ < 0) {
      x_[-jcol_ - 1] = bl_[-jcol_ - 1] + x_[-jcol_ - 1];
    }
  }
  for (j_ = 1; j_ <= (*ncols_); (j_)++) {
    if (scl_[j_ - 1] < 0.0) {
      x_[j_ - 1] = -x_[j_ - 1];
    }
  }
  i_ = _max (nsetb_, mval_);
  (*rnorm_) = _dnrm2 (($124_ = mrows_ - i_, &$124_), &w_[({int_4 idum__1_ = i_; _min (idum__1_ + 1, mrows_);}) - 1 + 
  ((*mdw_)) * (((*ncols_) + 1 - 1))], &_k1);
  if (igopr_ == 2) {
    (*mode_) = nsetb_;
  }
  _l0:;
  __calls[71].calls++;
  return 0;
}
int_4 _dbsgq8 (real_8 (*_fun)(), real_8 _p_ xt_, real_8 _p_ bc_, int_4 _p_ n_, int_4 _p_ kk_, int_4 _p_ id_, real_8 _p_ 
a_, real_8 _p_ b_, int_4 _p_ inbv_, real_8 _p_ err_, real_8 _p_ ans_, int_4 _p_ ierr_, real_8 _p_ work_)
{
  static int_4 k_, kml_, kmx_, l_, lmn_, lmx_, lr_[60], mxl_, nbits_, nib_, nlmn_, nlmx_;
  static real_8 aa_[60], ae_, anib_, area_, c_, ce_, ee_, ef_, eps_, est_, gl_, glr_, gr_[60], hh_[60], sq2_, tol_, 
  vl_[60], vr_, w1_, w2_, w3_, w4_, x1_, x2_, x3_, x4_, x_, h_;
  int_4 _data_k_81, _data_k_82, _data_k_83, _data_k_84, _data_k_85, _data_k_86, $0_, $1_, $2_, $52_, $53_, $54_;
  real_8 $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, $20_, $21_, $22_, 
  $23_, $24_, $25_, $26_, $27_, $28_, $29_, $30_, $31_, $32_, $33_, $34_, $35_, $36_, $37_, $38_, $39_, $40_, $41_, $42_, 
  $43_, $44_, $45_, $46_, $47_, $48_, $49_, $50_, $51_;
  char_127 $55_;
  extern int_4 _i1mach ();
  extern real_8 _d1mach ();
  extern real_8 _dbvalu ();
#define _data_n_81 4
  static real_8 _data_l_81[_data_n_81] = {
    1.83434642495649805e-1,
    5.25532409916328986e-1,
    7.9666647741362674e-1,
    9.60289856497536232e-1
  };
#define _data_n_82 4
  static real_8 _data_l_82[_data_n_82] = {
    3.62683783378361983e-1,
    3.13706645877887287e-1,
    2.22381034453374471e-1,
    1.01228536290376259e-1
  };
#define _data_n_83 1
  static real_8 _data_l_83[_data_n_83] = {
    1.41421356e0
  };
#define _data_n_84 1
  static int_4 _data_l_84[_data_n_84] = {
    1
  };
#define _data_n_85 1
  static int_4 _data_l_85[_data_n_85] = {
    5000
  };
#define _data_n_86 1
  static int_4 _data_l_86[_data_n_86] = {
    6
  };
  if (__calls[72].calls == 0) {
    _data_k_81 = 0;
    if (_data_k_81 >= _data_n_81) {
      _data_k_81 = 0;
    }
    x1_ = _data_l_81[_data_k_81++];
    if (_data_k_81 >= _data_n_81) {
      _data_k_81 = 0;
    }
    x2_ = _data_l_81[_data_k_81++];
    if (_data_k_81 >= _data_n_81) {
      _data_k_81 = 0;
    }
    x3_ = _data_l_81[_data_k_81++];
    if (_data_k_81 >= _data_n_81) {
      _data_k_81 = 0;
    }
    x4_ = _data_l_81[_data_k_81++];
  }
  if (__calls[72].calls == 0) {
    _data_k_82 = 0;
    if (_data_k_82 >= _data_n_82) {
      _data_k_82 = 0;
    }
    w1_ = _data_l_82[_data_k_82++];
    if (_data_k_82 >= _data_n_82) {
      _data_k_82 = 0;
    }
    w2_ = _data_l_82[_data_k_82++];
    if (_data_k_82 >= _data_n_82) {
      _data_k_82 = 0;
    }
    w3_ = _data_l_82[_data_k_82++];
    if (_data_k_82 >= _data_n_82) {
      _data_k_82 = 0;
    }
    w4_ = _data_l_82[_data_k_82++];
  }
  if (__calls[72].calls == 0) {
    _data_k_83 = 0;
    if (_data_k_83 >= _data_n_83) {
      _data_k_83 = 0;
    }
    sq2_ = _data_l_83[_data_k_83++];
  }
  if (__calls[72].calls == 0) {
    _data_k_84 = 0;
    if (_data_k_84 >= _data_n_84) {
      _data_k_84 = 0;
    }
    nlmn_ = _data_l_84[_data_k_84++];
    _data_k_85 = 0;
    if (_data_k_85 >= _data_n_85) {
      _data_k_85 = 0;
    }
    kmx_ = _data_l_85[_data_k_85++];
    _data_k_86 = 0;
    if (_data_k_86 >= _data_n_86) {
      _data_k_86 = 0;
    }
    kml_ = _data_l_86[_data_k_86++];
  }
  k_ = _i1mach (($0_ = 14, &$0_));
  anib_ = _d1mach (($1_ = 5, &$1_)) * k_ / 0.30102e0;
  nbits_ = (int_4) (_aintd (anib_));
  nlmx_ = _min ((nbits_ * 5) / 8, 60);
  (*ans_) = 0.0;
  (*ierr_) = 1;
  ce_ = 0.0;
  if ((*a_) == (*b_)) {
    goto _l140;
  }
  lmx_ = nlmx_;
  lmn_ = nlmn_;
  if ((*b_) == 0.0e0) {
    goto _l10;
  }
  if (_sign (1.0, (*b_)) * (*a_) <= 0.0e0) {
    goto _l10;
  }
  c_ = _abs (1.0e0 - (*a_) / (*b_));
  if (c_ > 0.1e0) {
    goto _l10;
  }
  if (c_ <= 0.0e0) {
    goto _l140;
  }
  anib_ = 0.5e0 - log (c_) / 0.69314718e0;
  nib_ = (int_4) (_aintd (anib_));
  lmx_ = _min (nlmx_, nbits_ - nib_ - 7);
  if (lmx_ < 1) {
    goto _l130;
  }
  lmn_ = _min (lmn_, lmx_);
  _l10:;
  tol_ = _max (_abs ((*err_)), _up_real_8 (2.0e0, (5 - nbits_))) / 2.0e0;
  if ((*err_) == 0.0e0) {
    tol_ = sqrt (_d1mach (($2_ = 4, &$2_)));
  }
  eps_ = tol_;
  hh_[0] = ((*b_) - (*a_)) / 4.0e0;
  aa_[0] = (*a_);
  lr_[0] = 1;
  l_ = 1;
  est_ = ({real_8 x__1_ = aa_[l_ - 1] + 2.0e0 * hh_[l_ - 1]; real_8 h__1_ = 2.0e0 * hh_[l_ - 1]; h__1_ * ((w1_ * (_fun 
  (($3_ = x__1_ - x1_ * h__1_, &$3_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($4_ = x__1_ - x1_ * h__1_, &$4_), inbv_, work_) 
  + _fun (($5_ = x__1_ + x1_ * h__1_, &$5_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($6_ = x__1_ + x1_ * h__1_, &$6_), inbv_, 
  work_)) + w2_ * (_fun (($7_ = x__1_ - x2_ * h__1_, &$7_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($8_ = x__1_ - x2_ * 
  h__1_, &$8_), inbv_, work_) + _fun (($9_ = x__1_ + x2_ * h__1_, &$9_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($10_ = x__1_ 
  + x2_ * h__1_, &$10_), inbv_, work_))) + (w3_ * (_fun (($11_ = x__1_ - x3_ * h__1_, &$11_)) * _dbvalu (xt_, bc_, n_, 
  kk_, id_, ($12_ = x__1_ - x3_ * h__1_, &$12_), inbv_, work_) + _fun (($13_ = x__1_ + x3_ * h__1_, &$13_)) * _dbvalu 
  (xt_, bc_, n_, kk_, id_, ($14_ = x__1_ + x3_ * h__1_, &$14_), inbv_, work_)) + w4_ * (_fun (($15_ = x__1_ - x4_ * 
  h__1_, &$15_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($16_ = x__1_ - x4_ * h__1_, &$16_), inbv_, work_) + _fun (($17_ = 
  x__1_ + x4_ * h__1_, &$17_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($18_ = x__1_ + x4_ * h__1_, &$18_), inbv_, 
  work_))));});
  k_ = 8;
  area_ = _abs (est_);
  ef_ = 0.5;
  mxl_ = 0;
  _l20:;
  gl_ = ({real_8 x__1_ = aa_[l_ - 1] + hh_[l_ - 1]; real_8 h__1_ = hh_[l_ - 1]; h__1_ * ((w1_ * (_fun (($19_ = x__1_ - 
  x1_ * h__1_, &$19_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($20_ = x__1_ - x1_ * h__1_, &$20_), inbv_, work_) + _fun 
  (($21_ = x__1_ + x1_ * h__1_, &$21_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($22_ = x__1_ + x1_ * h__1_, &$22_), inbv_, 
  work_)) + w2_ * (_fun (($23_ = x__1_ - x2_ * h__1_, &$23_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($24_ = x__1_ - x2_ * 
  h__1_, &$24_), inbv_, work_) + _fun (($25_ = x__1_ + x2_ * h__1_, &$25_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($26_ = 
  x__1_ + x2_ * h__1_, &$26_), inbv_, work_))) + (w3_ * (_fun (($27_ = x__1_ - x3_ * h__1_, &$27_)) * _dbvalu (xt_, bc_, 
  n_, kk_, id_, ($28_ = x__1_ - x3_ * h__1_, &$28_), inbv_, work_) + _fun (($29_ = x__1_ + x3_ * h__1_, &$29_)) * _dbvalu 
  (xt_, bc_, n_, kk_, id_, ($30_ = x__1_ + x3_ * h__1_, &$30_), inbv_, work_)) + w4_ * (_fun (($31_ = x__1_ - x4_ * 
  h__1_, &$31_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($32_ = x__1_ - x4_ * h__1_, &$32_), inbv_, work_) + _fun (($33_ = 
  x__1_ + x4_ * h__1_, &$33_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($34_ = x__1_ + x4_ * h__1_, &$34_), inbv_, 
  work_))));});
  gr_[l_ - 1] = ({real_8 x__1_ = aa_[l_ - 1] + 3.0e0 * hh_[l_ - 1]; real_8 h__1_ = hh_[l_ - 1]; h__1_ * ((w1_ * (_fun 
  (($35_ = x__1_ - x1_ * h__1_, &$35_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($36_ = x__1_ - x1_ * h__1_, &$36_), inbv_, 
  work_) + _fun (($37_ = x__1_ + x1_ * h__1_, &$37_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($38_ = x__1_ + x1_ * h__1_, 
  &$38_), inbv_, work_)) + w2_ * (_fun (($39_ = x__1_ - x2_ * h__1_, &$39_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($40_ = 
  x__1_ - x2_ * h__1_, &$40_), inbv_, work_) + _fun (($41_ = x__1_ + x2_ * h__1_, &$41_)) * _dbvalu (xt_, bc_, n_, kk_, 
  id_, ($42_ = x__1_ + x2_ * h__1_, &$42_), inbv_, work_))) + (w3_ * (_fun (($43_ = x__1_ - x3_ * h__1_, &$43_)) * 
  _dbvalu (xt_, bc_, n_, kk_, id_, ($44_ = x__1_ - x3_ * h__1_, &$44_), inbv_, work_) + _fun (($45_ = x__1_ + x3_ * 
  h__1_, &$45_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($46_ = x__1_ + x3_ * h__1_, &$46_), inbv_, work_)) + w4_ * (_fun 
  (($47_ = x__1_ - x4_ * h__1_, &$47_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($48_ = x__1_ - x4_ * h__1_, &$48_), inbv_, 
  work_) + _fun (($49_ = x__1_ + x4_ * h__1_, &$49_)) * _dbvalu (xt_, bc_, n_, kk_, id_, ($50_ = x__1_ + x4_ * h__1_, 
  &$50_), inbv_, work_))));});
  k_ = k_ + 16;
  area_ = area_ + (_abs (gl_) + _abs (gr_[l_ - 1]) - _abs (est_));
  glr_ = gl_ + gr_[l_ - 1];
  ee_ = _abs (est_ - glr_) * ef_;
  ae_ = _max (eps_ * area_, tol_ * _abs (glr_));
  $51_ = ee_ - ae_;
  if ($51_ < 0) {
    goto _l40;
  } else if ($51_ == 0) {
    goto _l40;
  } else {
    goto _l50;
  }
  _l30:;
  mxl_ = 1;
  _l40:;
  ce_ = ce_ + (est_ - glr_);
  $52_ = lr_[l_ - 1];
  if ($52_ < 0) {
    goto _l60;
  } else if ($52_ == 0) {
    goto _l60;
  } else {
    goto _l80;
  }
  _l50:;
  if (k_ > kmx_) {
    lmx_ = kml_;
  }
  if (l_ >= lmx_) {
    goto _l30;
  }
  l_ = l_ + 1;
  eps_ = eps_ * 0.5e0;
  ef_ = ef_ / sq2_;
  hh_[l_ - 1] = hh_[l_ - 1 - 1] * 0.5e0;
  lr_[l_ - 1] = -1;
  aa_[l_ - 1] = aa_[l_ - 1 - 1];
  est_ = gl_;
  goto _l20;
  _l60:;
  vl_[l_ - 1] = glr_;
  _l70:;
  est_ = gr_[l_ - 1 - 1];
  lr_[l_ - 1] = 1;
  aa_[l_ - 1] = aa_[l_ - 1] + 4.0e0 * hh_[l_ - 1];
  goto _l20;
  _l80:;
  vr_ = glr_;
  _l90:;
  if (l_ <= 1) {
    goto _l120;
  }
  l_ = l_ - 1;
  eps_ = eps_ * 2.0e0;
  ef_ = ef_ * sq2_;
  $53_ = lr_[l_ - 1];
  if ($53_ < 0) {
    goto _l100;
  } else if ($53_ == 0) {
    goto _l100;
  } else {
    goto _l110;
  }
  _l100:;
  vl_[l_ - 1] = vl_[l_ + 1 - 1] + vr_;
  goto _l70;
  _l110:;
  vr_ = vl_[l_ + 1 - 1] + vr_;
  goto _l90;
  _l120:;
  (*ans_) = vr_;
  if ((mxl_ == 0) || (_abs (ce_) <= 2.0e0 * tol_ * area_)) {
    goto _l140;
  }
  (*ierr_) = 2;
  (void) _xermsg (_dc_1, _dc_150, _dc_16, ($54_ = 3, &$54_), &_k1);
  goto _l140;
  _l130:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_1, _dc_150, concat ($55_, _dc_17, _dc_18), &_k1, &_km1);
  _l140:;
  if ((*err_) < 0.0e0) {
    (*err_) = ce_;
  }
  __calls[72].calls++;
  return 0;
}

int_4 _dcfod (int_4 _p_ meth_, real_8 _p_ elco_, real_8 _p_ tesco_)
{
  static int_4 i_, ib_, nq_, nqm1_, nqp1_;
  static real_8 agamq_, fnq_, fnqm1_, pc_[12], pint_, ragq_, rq1fac_, rqfac_, tsign_, xpin_;
  switch ((*meth_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l60;
  }
  _l10:;
  elco_[0] = 1.0;
  elco_[1] = 1.0;
  tesco_[0] = 0.0;
  tesco_[1] = 2.0;
  tesco_[3] = 1.0;
  tesco_[35] = 0.0;
  pc_[0] = 1.0;
  rqfac_ = 1.0;
  for (nq_ = 2; nq_ <= 12; (nq_)++) {
    rq1fac_ = rqfac_;
    rqfac_ = rqfac_ / nq_;
    nqm1_ = nq_ - 1;
    fnqm1_ = nqm1_;
    nqp1_ = nq_ + 1;
    pc_[nq_ - 1] = 0.0;
    for (ib_ = 1; ib_ <= nqm1_; (ib_)++) {
      i_ = nqp1_ - ib_;
      pc_[i_ - 1] = pc_[i_ - 1 - 1] + fnqm1_ * pc_[i_ - 1];
    }
    pc_[0] = fnqm1_ * pc_[0];
    pint_ = pc_[0];
    xpin_ = pc_[0] / 2.0e0;
    tsign_ = 1.0;
    for (i_ = 2; i_ <= nq_; (i_)++) {
      tsign_ = -tsign_;
      pint_ = pint_ + tsign_ * pc_[i_ - 1] / i_;
      xpin_ = xpin_ + tsign_ * pc_[i_ - 1] / (i_ + 1);
    }
    elco_[0 + (13) * ((nq_ - 1))] = pint_ * rq1fac_;
    elco_[1 + (13) * ((nq_ - 1))] = 1.0;
    for (i_ = 2; i_ <= nq_; (i_)++) {
      elco_[i_ + 1 - 1 + (13) * ((nq_ - 1))] = rq1fac_ * pc_[i_ - 1] / i_;
    }
    agamq_ = rqfac_ * xpin_;
    ragq_ = 1.0e0 / agamq_;
    tesco_[1 + (3) * ((nq_ - 1))] = ragq_;
    if (nq_ < 12) {
      tesco_[0 + (3) * ((nqp1_ - 1))] = ragq_ * rqfac_ / nqp1_;
    }
    tesco_[2 + (3) * ((nqm1_ - 1))] = ragq_;
  }
  goto _l100;
  _l60:;
  pc_[0] = 1.0;
  rq1fac_ = 1.0;
  for (nq_ = 1; nq_ <= 5; (nq_)++) {
    fnq_ = nq_;
    nqp1_ = nq_ + 1;
    pc_[nqp1_ - 1] = 0.0;
    for (ib_ = 1; ib_ <= nq_; (ib_)++) {
      i_ = nq_ + 2 - ib_;
      pc_[i_ - 1] = pc_[i_ - 1 - 1] + fnq_ * pc_[i_ - 1];
    }
    pc_[0] = fnq_ * pc_[0];
    for (i_ = 1; i_ <= nqp1_; (i_)++) {
      elco_[i_ - 1 + (13) * ((nq_ - 1))] = pc_[i_ - 1] / pc_[1];
    }
    elco_[1 + (13) * ((nq_ - 1))] = 1.0;
    tesco_[0 + (3) * ((nq_ - 1))] = rq1fac_;
    tesco_[1 + (3) * ((nq_ - 1))] = nqp1_ / elco_[0 + (13) * ((nq_ - 1))];
    tesco_[2 + (3) * ((nq_ - 1))] = (nq_ + 2) / elco_[0 + (13) * ((nq_ - 1))];
    rq1fac_ = rq1fac_ / fnq_;
  }
  _l100:;
  __calls[73].calls++;
  return 0;
}

int_4 _dckder (int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, real_8 
_p_ xp_, real_8 _p_ fvecp_, int_4 _p_ mode_, real_8 _p_ err_)
{
  static int_4 i_, j_;
  static real_8 eps_, epsf_, epslog_, epsmch_, factor_, one_, temp_, zero_;
  int_4 _data_k_87, $0_;
  extern real_8 _d1mach ();
#define _data_n_87 3
  static real_8 _data_l_87[_data_n_87] = {
    1.0e2,
    1.0e0,
    0.0e0
  };
  if (__calls[74].calls == 0) {
    _data_k_87 = 0;
    if (_data_k_87 >= _data_n_87) {
      _data_k_87 = 0;
    }
    factor_ = _data_l_87[_data_k_87++];
    if (_data_k_87 >= _data_n_87) {
      _data_k_87 = 0;
    }
    one_ = _data_l_87[_data_k_87++];
    if (_data_k_87 >= _data_n_87) {
      _data_k_87 = 0;
    }
    zero_ = _data_l_87[_data_k_87++];
  }
  epsmch_ = _d1mach (($0_ = 4, &$0_));
  eps_ = sqrt (epsmch_);
  if ((*mode_) == 2) {
    goto _l20;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = eps_ * _abs (x_[j_ - 1]);
    if (temp_ == zero_) {
      temp_ = eps_;
    }
    xp_[j_ - 1] = x_[j_ - 1] + temp_;
  }
  goto _l70;
  _l20:;
  epsf_ = factor_ * epsmch_;
  epslog_ = log10 (eps_);
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    err_[i_ - 1] = zero_;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = _abs (x_[j_ - 1]);
    if (temp_ == zero_) {
      temp_ = one_;
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      err_[i_ - 1] = err_[i_ - 1] + temp_ * fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))];
    }
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    temp_ = one_;
    if (fvec_[i_ - 1] != zero_ && fvecp_[i_ - 1] != zero_ && _abs (fvecp_[i_ - 1] - fvec_[i_ - 1]) >= epsf_ * _abs 
      (fvec_[i_ - 1])) {
      temp_ = eps_ * _abs ((fvecp_[i_ - 1] - fvec_[i_ - 1]) / eps_ - err_[i_ - 1]) / (_abs (fvec_[i_ - 1]) + _abs (fvecp_[i_ 
      - 1]));
    }
    err_[i_ - 1] = one_;
    if (temp_ > epsmch_ && temp_ < eps_) {
      err_[i_ - 1] = (log10 (temp_) - epslog_) / epslog_;
    }
    if (temp_ >= eps_) {
      err_[i_ - 1] = zero_;
    }
  }
  _l70:;
  __calls[74].calls++;
  return 0;
}

int_4 _dcoef (real_8 _p_ yh_, real_8 _p_ yp_, int_4 _p_ ncomp_, int_4 _p_ nrowb_, int_4 _p_ nfc_, int_4 _p_ nic_, 
real_8 _p_ b_, real_8 _p_ beta_, real_8 _p_ coef_, int_4 _p_ inhomo_, real_8 _p_ re_, real_8 _p_ ae_, real_8 _p_ by_, 
real_8 _p_ cvec_, real_8 _p_ work_, int_4 _p_ iwork_, int_4 _p_ iflag_, int_4 _p_ nfcc_)
{
  static int_4 i_, j_, k_, kflag_, ki_, l_, mlso_, ncomp2_, nf_, nfccm1_;
  static real_8 bbn_, bn_, brn_, bykl_, bys_, cons_, gam_, un_, ypn_;
  extern real_8 _ddot ();
  ncomp2_ = (*ncomp_) / 2;
  for (k_ = 1; k_ <= (*nfcc_); (k_)++) {
    for (j_ = 1; j_ <= (*nfc_); (j_)++) {
      l_ = j_;
      if ((*nfc_) != (*nfcc_)) {
        l_ = 2 * j_ - 1;
      }
      by_[k_ - 1 + ((*nfcc_)) * ((l_ - 1))] = _ddot (ncomp_, &b_[k_ - 1 + ((*nrowb_)) * ((0))], nrowb_, &yh_[0 + ((*ncomp_)) 
      * ((j_ - 1))], &_k1);
    }
    if ((*nfc_) == (*nfcc_)) {
      goto _l30;
    }
    for (j_ = 1; j_ <= (*nfc_); (j_)++) {
      l_ = 2 * j_;
      bykl_ = _ddot (&ncomp2_, &b_[k_ - 1 + ((*nrowb_)) * ((0))], nrowb_, &yh_[ncomp2_ + 1 - 1 + ((*ncomp_)) * ((j_ - 1))], 
      &_k1);
      by_[k_ - 1 + ((*nfcc_)) * ((l_ - 1))] = _ddot (&ncomp2_, &b_[k_ - 1 + ((*nrowb_)) * ((ncomp2_ + 1 - 1))], nrowb_, 
      &yh_[0 + ((*ncomp_)) * ((j_ - 1))], &_k1) - bykl_;
    }
    _l30:;
    switch ((*inhomo_)) {
      default:
      case 1: goto _l40;
      case 2: goto _l50;
      case 3: goto _l60;
    }
    _l40:;
    cvec_[k_ - 1] = beta_[k_ - 1] - _ddot (ncomp_, &b_[k_ - 1 + ((*nrowb_)) * ((0))], nrowb_, yp_, &_k1);
    goto _l70;
    _l50:;
    cvec_[k_ - 1] = beta_[k_ - 1];
    goto _l70;
    _l60:;
    cvec_[k_ - 1] = 0.0;
    _l70:;
  }
  cons_ = _abs (cvec_[0]);
  bys_ = _abs (by_[0 + ((*nfcc_)) * ((0))]);
  (*iflag_) = 0;
  mlso_ = 0;
  if ((*inhomo_) == 3) {
    mlso_ = 1;
  }
  kflag_ = 0.5e0 * log10 (dml5mc_.eps_);
  (void) _xgetf (&nf_);
  (void) _xsetf (&_k0);
  _l90:;
  (void) _dsuds (by_, coef_, cvec_, nfcc_, nfcc_, nfcc_, &kflag_, &mlso_, work_, iwork_);
  if (kflag_ != 3) {
    goto _l100;
  }
  kflag_ = 1;
  (*iflag_) = 1;
  goto _l90;
  _l100:;
  if (kflag_ == 4) {
    (*iflag_) = 2;
  }
  (void) _xsetf (&nf_);
  if ((*nfcc_) == 1) {
    goto _l180;
  }
  if ((*inhomo_) != 3) {
    goto _l170;
  }
  if (iwork_[0] < (*nfcc_)) {
    goto _l140;
  }
  (*iflag_) = 3;
  for (k_ = 1; k_ <= (*nfcc_); (k_)++) {
    coef_[k_ - 1] = 0.0;
  }
  coef_[(*nfcc_) - 1] = 1.0;
  nfccm1_ = (*nfcc_) - 1;
  for (k_ = 1; k_ <= nfccm1_; (k_)++) {
    j_ = (*nfcc_) - k_;
    l_ = (*nfcc_) - j_ + 1;
    gam_ = _ddot (&l_, &by_[j_ - 1 + ((*nfcc_)) * ((j_ - 1))], nfcc_, &coef_[j_ - 1], &_k1) / (work_[j_ - 1] * by_[j_ - 1 + 
    ((*nfcc_)) * ((j_ - 1))]);
    for (i_ = j_; i_ <= (*nfcc_); (i_)++) {
      coef_[i_ - 1] = coef_[i_ - 1] + gam_ * by_[j_ - 1 + ((*nfcc_)) * ((i_ - 1))];
    }
  }
  goto _l160;
  _l140:;
  for (k_ = 1; k_ <= (*nfcc_); (k_)++) {
    ki_ = 4 * (*nfcc_) + k_;
    coef_[k_ - 1] = work_[ki_ - 1];
  }
  _l160:;
  _l170:;
  goto _l220;
  _l180:;
  bn_ = 0.0;
  un_ = 0.0;
  ypn_ = 0.0;
  for (k_ = 1; k_ <= (*ncomp_); (k_)++) {
    un_ = _max (un_, _abs (yh_[k_ - 1 + ((*ncomp_)) * ((0))]));
    ypn_ = _max (ypn_, _abs (yp_[k_ - 1]));
    bn_ = _max (bn_, _abs (b_[0 + ((*nrowb_)) * ((k_ - 1))]));
  }
  bbn_ = _max (bn_, _abs (beta_[0]));
  if (bys_ > 10.0e0 * ((*re_) * un_ + (*ae_)) * bn_) {
    goto _l200;
  }
  brn_ = bbn_ / bn_ * bys_;
  if (cons_ >= 0.1e0 * brn_ && cons_ <= 10.0e0 * brn_) {
    (*iflag_) = 1;
  }
  if (cons_ > 10.0e0 * brn_) {
    (*iflag_) = 2;
  }
  if (cons_ <= (*re_) * _abs (beta_[0]) + (*ae_) + ((*re_) * ypn_ + (*ae_)) * bn_) {
    (*iflag_) = 1;
  }
  if ((*inhomo_) == 3) {
    coef_[0] = 1.0;
  }
  goto _l210;
  _l200:;
  if ((*inhomo_) != 3) {
    goto _l210;
  }
  (*iflag_) = 3;
  coef_[0] = 1.0;
  _l210:;
  _l220:;
  __calls[75].calls++;
  return 0;
}

int_4 _dcov (int_4 (*_fcn)(), int_4 _p_ iopt_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ 
r_, int_4 _p_ ldr_, int_4 _p_ info_, real_8 _p_ wa1_, real_8 _p_ wa2_, real_8 _p_ wa3_, real_8 _p_ wa4_)
{
  static int_4 i_, idum_, iflag_, j_, k_, kp1_, nm1_, nrow_;
  static logical_4 sing_;
  static real_8 one_, sigma_, temp_, zero_;
  int_4 _data_k_88, _data_k_89, $1_;
  logical_4 $0_;
  char_127 $2_;
#define _data_n_88 1
  static real_8 _data_l_88[_data_n_88] = {
    0.0e0
  };
#define _data_n_89 1
  static real_8 _data_l_89[_data_n_89] = {
    1.0e0
  };
  if (__calls[76].calls == 0) {
    _data_k_88 = 0;
    if (_data_k_88 >= _data_n_88) {
      _data_k_88 = 0;
    }
    zero_ = _data_l_88[_data_k_88++];
    _data_k_89 = 0;
    if (_data_k_89 >= _data_n_89) {
      _data_k_89 = 0;
    }
    one_ = _data_l_89[_data_k_89++];
  }
  sing_ = FALSE;
  iflag_ = 0;
  if ((*m_) <= 0 || (*n_) <= 0) {
    goto _l300;
  }
  iflag_ = 1;
  (void) _fcn (&iflag_, m_, n_, x_, fvec_, r_, ldr_);
  if (iflag_ < 0) {
    goto _l300;
  }
  temp_ = _denorm (m_, fvec_);
  sigma_ = one_;
  if ((*m_) != (*n_)) {
    sigma_ = temp_ * temp_ / ((*m_) - (*n_));
  }
  if ((*iopt_) == 3) {
    goto _l200;
  }
  if ((*iopt_) == 1) {
    goto _l100;
  }
  iflag_ = 2;
  (void) _fcn (&iflag_, m_, n_, x_, fvec_, r_, ldr_);
  goto _l110;
  _l100:;
  (void) _dfdjc3 (_fcn, m_, n_, x_, fvec_, r_, ldr_, &iflag_, &zero_, wa4_);
  _l110:;
  if (iflag_ < 0) {
    goto _l300;
  }
  (void) _dqrfac (m_, n_, r_, ldr_, ($0_ = FALSE, &$0_), &idum_, &_k1, wa1_, wa1_, wa1_);
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    r_[i_ - 1 + ((*ldr_)) * ((i_ - 1))] = wa1_[i_ - 1];
  }
  goto _l225;
  _l200:;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa2_[j_ - 1] = zero_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = zero_;
    }
  }
  iflag_ = 3;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    nrow_ = i_;
    (void) _fcn (&iflag_, m_, n_, x_, fvec_, wa1_, &nrow_);
    if (iflag_ < 0) {
      goto _l300;
    }
    temp_ = fvec_[i_ - 1];
    (void) _dwupdt (n_, r_, ldr_, wa1_, wa2_, &temp_, wa3_, wa4_);
  }
  _l225:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (r_[i_ - 1 + ((*ldr_)) * ((i_ - 1))] == zero_) {
      sing_ = TRUE;
    }
  }
  if (sing_) {
    goto _l300;
  }
  if ((*n_) == 1) {
    goto _l275;
  }
  nm1_ = (*n_) - 1;
  for (k_ = 1; k_ <= nm1_; (k_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      wa1_[i_ - 1] = zero_;
    }
    wa1_[k_ - 1] = one_;
    r_[k_ - 1 + ((*ldr_)) * ((k_ - 1))] = wa1_[k_ - 1] / r_[k_ - 1 + ((*ldr_)) * ((k_ - 1))];
    kp1_ = k_ + 1;
    for (i_ = kp1_; i_ <= (*n_); (i_)++) {
      for (j_ = i_; j_ <= (*n_); (j_)++) {
        wa1_[j_ - 1] = wa1_[j_ - 1] - r_[k_ - 1 + ((*ldr_)) * ((i_ - 1 - 1))] * r_[i_ - 1 - 1 + ((*ldr_)) * ((j_ - 1))];
      }
      r_[k_ - 1 + ((*ldr_)) * ((i_ - 1))] = wa1_[i_ - 1] / r_[i_ - 1 + ((*ldr_)) * ((i_ - 1))];
    }
  }
  _l275:;
  r_[(*n_) - 1 + ((*ldr_)) * (((*n_) - 1))] = one_ / r_[(*n_) - 1 + ((*ldr_)) * (((*n_) - 1))];
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    for (j_ = i_; j_ <= (*n_); (j_)++) {
      temp_ = zero_;
      for (k_ = j_; k_ <= (*n_); (k_)++) {
        temp_ = temp_ + r_[i_ - 1 + ((*ldr_)) * ((k_ - 1))] * r_[j_ - 1 + ((*ldr_)) * ((k_ - 1))];
      }
      r_[i_ - 1 + ((*ldr_)) * ((j_ - 1))] = temp_ * sigma_;
    }
  }
  (*info_) = 1;
  _l300:;
  if ((*m_) <= 0 || (*n_) <= 0) {
    (*info_) = 0;
  }
  if (iflag_ < 0) {
    (*info_) = iflag_;
  }
  if (sing_) {
    (*info_) = 2;
  }
  if ((*info_) < 0) {
    (void) _xermsg (_dc_1, _dc_151, _dc_152, &_k1, &_k1);
  }
  if ((*info_) == 0) {
    (void) _xermsg (_dc_1, _dc_151, _dc_153, ($1_ = 2, &$1_), &_k1);
  }
  if ((*info_) == 2) {
    (void) _xermsg (_dc_1, _dc_151, concat ($2_, _dc_154, _dc_155), &_k1, &_k1);
  }
  __calls[76].calls++;
  return 0;
}

int_4 _dcscal (real_8 _p_ a_, int_4 _p_ nrda_, int_4 _p_ nrow_, int_4 _p_ ncol_, real_8 _p_ cols_, real_8 _p_ colsav_, 
real_8 _p_ rows_, real_8 _p_ rowsav_, real_8 _p_ anorm_, real_8 _p_ scales_, int_4 _p_ iscale_, int_4 _p_ ic_)
{
  static int_4 ip_, j_, k_;
  static real_8 alog2_, ascale_, cs_, p_, s_, ten20_, ten4_;
  int_4 _data_k_90;
  extern real_8 _ddot ();
#define _data_n_90 2
  static real_8 _data_l_90[_data_n_90] = {
    1.0e4,
    1.0e20
  };
  if (__calls[77].calls == 0) {
    _data_k_90 = 0;
    if (_data_k_90 >= _data_n_90) {
      _data_k_90 = 0;
    }
    ten4_ = _data_l_90[_data_k_90++];
    if (_data_k_90 >= _data_n_90) {
      _data_k_90 = 0;
    }
    ten20_ = _data_l_90[_data_k_90++];
  }
  if ((*iscale_) != -1) {
    goto _l40;
  }
  if ((*ic_) == 0) {
    goto _l20;
  }
  for (k_ = 1; k_ <= (*ncol_); (k_)++) {
    cols_[k_ - 1] = _ddot (nrow_, &a_[0 + ((*nrda_)) * ((k_ - 1))], &_k1, &a_[0 + ((*nrda_)) * ((k_ - 1))], &_k1);
  }
  _l20:;
  ascale_ = (*anorm_) / (*ncol_);
  for (k_ = 1; k_ <= (*ncol_); (k_)++) {
    cs_ = cols_[k_ - 1];
    if ((cs_ > ten4_ * ascale_) || (ten4_ * cs_ < ascale_)) {
      goto _l60;
    }
    if ((cs_ < 1.0e0 / ten20_) || (cs_ > ten20_)) {
      goto _l60;
    }
  }
  _l40:;
  for (k_ = 1; k_ <= (*ncol_); (k_)++) {
    scales_[k_ - 1] = 1.0;
  }
  goto _l130;
  _l60:;
  alog2_ = 6.9314718055994531e-1;
  (*anorm_) = 0.0;
  for (k_ = 1; k_ <= (*ncol_); (k_)++) {
    cs_ = cols_[k_ - 1];
    if (cs_ != 0.0e0) {
      goto _l70;
    }
    scales_[k_ - 1] = 1.0;
    goto _l100;
    _l70:;
    p_ = log (cs_) / alog2_;
    ip_ = -0.5e0 * p_;
    s_ = _up_real_8 (2.0e0, ip_);
    scales_[k_ - 1] = s_;
    if ((*ic_) == 1) {
      goto _l80;
    }
    cols_[k_ - 1] = s_ * s_ * cols_[k_ - 1];
    (*anorm_) = (*anorm_) + cols_[k_ - 1];
    colsav_[k_ - 1] = cols_[k_ - 1];
    _l80:;
    for (j_ = 1; j_ <= (*nrow_); (j_)++) {
      a_[j_ - 1 + ((*nrda_)) * ((k_ - 1))] = s_ * a_[j_ - 1 + ((*nrda_)) * ((k_ - 1))];
    }
    _l100:;
  }
  if ((*ic_) == 0) {
    goto _l130;
  }
  for (k_ = 1; k_ <= (*nrow_); (k_)++) {
    rows_[k_ - 1] = _ddot (ncol_, &a_[k_ - 1 + ((*nrda_)) * ((0))], nrda_, &a_[k_ - 1 + ((*nrda_)) * ((0))], nrda_);
    rowsav_[k_ - 1] = rows_[k_ - 1];
    (*anorm_) = (*anorm_) + rows_[k_ - 1];
  }
  _l130:;
  __calls[77].calls++;
  return 0;
}

real_8 _dcv (real_8 _p_ xval_, int_4 _p_ ndata_, int_4 _p_ nconst_, int_4 _p_ nord_, int_4 _p_ nbkpt_, real_8 _p_ bkpt_
, real_8 _p_ w_)
{
  static int_4 i_, ileft_, ip_, is_, last_, mdg_, mdw_, n_;
  static real_8 v_[40], zero_;
  real_8 dcv_;
  extern real_8 _ddot ();
  zero_ = 0.0;
  mdg_ = (*nbkpt_) - (*nord_) + 3;
  mdw_ = (*nbkpt_) - (*nord_) + 1 + (*nconst_);
  is_ = mdg_ * ((*nord_) + 1) + 2 * _max ((*ndata_), (*nbkpt_)) + (*nbkpt_) + ((*nord_) * (*nord_));
  last_ = (*nbkpt_) - (*nord_) + 1;
  ileft_ = (*nord_);
  _l10:;
  if ((*xval_) < bkpt_[ileft_ + 1 - 1] || ileft_ >= last_ - 1) {
    goto _l20;
  }
  ileft_ = ileft_ + 1;
  goto _l10;
  _l20:;
  (void) _dfspvn (bkpt_, nord_, &_k1, xval_, &ileft_, &v_[(*nord_) + 1 - 1]);
  ileft_ = ileft_ - (*nord_) + 1;
  ip_ = mdw_ * (ileft_ - 1) + ileft_ + is_;
  n_ = (*nbkpt_) - (*nord_);
  for (i_ = 1; i_ <= (*nord_); (i_)++) {
    v_[i_ - 1] = _ddot (nord_, &w_[ip_ - 1], &_k1, &v_[(*nord_) + 1 - 1], &_k1);
    ip_ = ip_ + mdw_;
  }
  dcv_ = _max (_ddot (nord_, v_, &_k1, &v_[(*nord_) + 1 - 1], &_k1), zero_);
  dcv_ = dcv_ / _max ((*ndata_) - n_, 1);
  __calls[78].calls++;
  return dcv_;
}

int_4 _ddes (int_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ tout_, int_4 _p_ info_, real_8 
_p_ rtol_, real_8 _p_ atol_, int_4 _p_ idid_, real_8 _p_ ypout_, real_8 _p_ yp_, real_8 _p_ yy_, real_8 _p_ wt_, real_8 
_p_ p_, real_8 _p_ phi_, real_8 _p_ alpha_, real_8 _p_ beta_, real_8 _p_ psi_, real_8 _p_ v_, real_8 _p_ w_, real_8 _p_ 
sig_, real_8 _p_ g_, real_8 _p_ gi_, real_8 _p_ h_, real_8 _p_ eps_, real_8 _p_ x_, real_8 _p_ xold_, real_8 _p_ hold_, 
real_8 _p_ told_, real_8 _p_ delsgn_, real_8 _p_ tstop_, real_8 _p_ twou_, real_8 _p_ fouru_, logical_4 _p_ start_, 
logical_4 _p_ phase1_, logical_4 _p_ nornd_, logical_4 _p_ stiff_, logical_4 _p_ intout_, int_4 _p_ ns_, int_4 _p_ 
kord_, int_4 _p_ kold_, int_4 _p_ init_, int_4 _p_ ksteps_, int_4 _p_ kle4_, int_4 _p_ iquit_, int_4 _p_ kprev_, int_4 
_p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_8 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 k_, l_, ltol_, maxnum_, natolp_, nrtolp_;
  static logical_4 crash_;
  static real_8 a_, absdel_, del_, dt_, ha_, u_;
  static char_15 xern1_;
  static char_31 xern3_, xern4_;
  int_4 _data_k_91, $0_, __fcnt, __rc, $7_, $12_, $18_, $24_, $29_, $38_, $47_, $56_, $61_, $68_, $75_, $80_, $81_;
  char_63 $48_, $62_, $69_;
  char_127 $1_, $8_, $13_, $19_, $25_, $30_, $39_, $49_, $57_, $63_, $70_, $76_;
  char_255 $2_, $9_, $14_, $20_, $26_, $31_, $40_, $50_, $58_, $64_, $71_, $77_;
  char_511 $3_, $10_, $11_, $15_, $21_, $27_, $28_, $32_, $41_, $51_, $59_, $60_, $65_, $72_, $78_;
  char_1023 $4_, $16_, $17_, $22_, $23_, $33_, $42_, $52_, $66_, $67_, $73_, $74_, $79_;
  char_2047 $5_, $6_, $34_, $43_, $53_;
  char_4095 $35_, $36_, $37_, $44_, $45_, $46_, $54_, $55_;
  extern real_8 _d1mach ();
  static FORMAT $f_100027_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100032_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100037_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100042_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100047_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100055_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100056_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100062_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100063_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100073_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100074_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100081_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100086_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100087_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100093_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
#define _data_n_91 1
  static int_4 _data_l_91[_data_n_91] = {
    500
  };
  if (__calls[79].calls == 0) {
    _data_k_91 = 0;
    if (_data_k_91 >= _data_n_91) {
      _data_k_91 = 0;
    }
    maxnum_ = _data_l_91[_data_k_91++];
  }
  if (info_[0] == 0) {
    u_ = _d1mach (($0_ = 4, &$0_));
    (*twou_) = 2.0e0 * u_;
    (*fouru_) = 4.0e0 * u_;
    (*iquit_) = 0;
    (*init_) = 0;
    (*ksteps_) = 0;
    (*intout_) = FALSE;
    (*stiff_) = FALSE;
    (*kle4_) = 0;
    (*start_) = TRUE;
    (*phase1_) = TRUE;
    (*nornd_) = TRUE;
    info_[0] = 1;
  }
  if (info_[0] != 0 && info_[0] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:ddes:98", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:98", 0));
      __fcnt += 3;
    }
    if ($f_100027_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:98", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100027_[__fcnt + 2], &info_[0], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:ddes:98", 0));
    __fcnt += 3;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      if ($f_100027_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:98", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_156, (bufcpy ($6_, concat ($5_, concat ($4_, concat ($3_, concat ($2_, concat ($1_, _dc_157, 
    _dc_158), _dc_159), _dc_160), _dc_161), xern1_), 2047), $6_), ($7_ = 3, &$7_), &_k1);
    (*idid_) = -33;
  }
  if (info_[1] != 0 && info_[1] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:ddes:108", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100032_[__fcnt] != NULL && $f_100032_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100032_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:108", 0));
      __fcnt += 3;
    }
    if ($f_100032_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100032_[__fcnt] != NULL && $f_100032_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100032_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:108", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100032_[__fcnt + 2], &info_[1], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:ddes:108", 0));
    __fcnt += 3;
    while ($f_100032_[__fcnt] != NULL && $f_100032_[__fcnt] == FMT_TEXT) {
      if ($f_100032_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100032_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:108", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_156, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_162, _dc_163), _dc_164), 
    xern1_), 511), $11_), ($12_ = 4, &$12_), &_k1);
    (*idid_) = -33;
  }
  if (info_[2] != 0 && info_[2] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:ddes:117", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:117", 0));
      __fcnt += 3;
    }
    if ($f_100037_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:117", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100037_[__fcnt + 2], &info_[2], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:ddes:117", 0));
    __fcnt += 3;
    while ($f_100037_[__fcnt] != NULL && $f_100037_[__fcnt] == FMT_TEXT) {
      if ($f_100037_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100037_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:117", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_156, (bufcpy ($17_, concat ($16_, concat ($15_, concat ($14_, concat ($13_, _dc_165, 
    _dc_166), _dc_167), _dc_168), xern1_), 1023), $17_), ($18_ = 5, &$18_), &_k1);
    (*idid_) = -33;
  }
  if (info_[3] != 0 && info_[3] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:ddes:126", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100042_[__fcnt] != NULL && $f_100042_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100042_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:126", 0));
      __fcnt += 3;
    }
    if ($f_100042_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100042_[__fcnt] != NULL && $f_100042_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100042_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:126", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100042_[__fcnt + 2], &info_[3], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:ddes:126", 0));
    __fcnt += 3;
    while ($f_100042_[__fcnt] != NULL && $f_100042_[__fcnt] == FMT_TEXT) {
      if ($f_100042_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100042_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:126", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_156, (bufcpy ($23_, concat ($22_, concat ($21_, concat ($20_, concat ($19_, _dc_169, 
    _dc_170), _dc_171), _dc_172), xern1_), 1023), $23_), ($24_ = 14, &$24_), &_k1);
    (*idid_) = -33;
  }
  if ((*neq_) < 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:ddes:135", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100047_[__fcnt] != NULL && $f_100047_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100047_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:135", 0));
      __fcnt += 3;
    }
    if ($f_100047_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100047_[__fcnt] != NULL && $f_100047_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100047_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:135", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100047_[__fcnt + 2], &(*neq_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:ddes:135", 0));
    __fcnt += 3;
    while ($f_100047_[__fcnt] != NULL && $f_100047_[__fcnt] == FMT_TEXT) {
      if ($f_100047_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100047_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:135", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_156, (bufcpy ($28_, concat ($27_, concat ($26_, concat ($25_, _dc_173, _dc_174), _dc_175), 
    xern1_), 511), $28_), ($29_ = 6, &$29_), &_k1);
    (*idid_) = -33;
  }
  nrtolp_ = 0;
  natolp_ = 0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    if (nrtolp_ == 0 && rtol_[k_ - 1] < 0.0e0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:146", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:146", 0));
        __fcnt += 3;
      }
      if ($f_100055_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:146", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100055_[__fcnt + 2], &k_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:146", 0));
      __fcnt += 3;
      while ($f_100055_[__fcnt] != NULL && $f_100055_[__fcnt] == FMT_TEXT) {
        if ($f_100055_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100055_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:146", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:147", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:147", 0));
        __fcnt += 3;
      }
      if ($f_100056_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:147", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100056_[__fcnt + 2], &rtol_[k_ - 1], REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:147", 0));
      __fcnt += 3;
      while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
        if ($f_100056_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:147", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_156, (bufcpy ($37_, concat ($36_, concat ($35_, concat ($34_, concat ($33_, concat ($32_, 
      concat ($31_, concat ($30_, _dc_176, _dc_177), _dc_178), xern1_), _dc_64), xern3_), _dc_179), _dc_180), 4095), $37_), 
      ($38_ = 7, &$38_), &_k1);
      (*idid_) = -33;
      nrtolp_ = 1;
    }
    if (natolp_ == 0 && atol_[k_ - 1] < 0.0e0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:158", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:158", 0));
        __fcnt += 3;
      }
      if ($f_100062_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:158", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100062_[__fcnt + 2], &k_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:158", 0));
      __fcnt += 3;
      while ($f_100062_[__fcnt] != NULL && $f_100062_[__fcnt] == FMT_TEXT) {
        if ($f_100062_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100062_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:158", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:159", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100063_[__fcnt] != NULL && $f_100063_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100063_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:159", 0));
        __fcnt += 3;
      }
      if ($f_100063_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100063_[__fcnt] != NULL && $f_100063_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100063_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:159", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100063_[__fcnt + 2], &atol_[k_ - 1], REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:159", 0));
      __fcnt += 3;
      while ($f_100063_[__fcnt] != NULL && $f_100063_[__fcnt] == FMT_TEXT) {
        if ($f_100063_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100063_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:159", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_156, (bufcpy ($46_, concat ($45_, concat ($44_, concat ($43_, concat ($42_, concat ($41_, 
      concat ($40_, concat ($39_, _dc_181, _dc_182), _dc_183), xern1_), _dc_64), xern3_), _dc_179), _dc_184), 4095), $46_), 
      ($47_ = 8, &$47_), &_k1);
      (*idid_) = -33;
      natolp_ = 1;
    }
    if (info_[1] == 0) {
      goto _l100;
    }
    if (natolp_ > 0 && nrtolp_ > 0) {
      goto _l100;
    }
  }
  _l100:;
  if (info_[3] == 1) {
    if (_sign (1.0, (*tout_) - (*t_)) != _sign (1.0, (*tstop_) - (*t_)) || _abs ((*tout_) - (*t_)) > _abs ((*tstop_) - 
      (*t_))) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:176", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100073_[__fcnt] != NULL && $f_100073_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100073_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:176", 0));
        __fcnt += 3;
      }
      if ($f_100073_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100073_[__fcnt] != NULL && $f_100073_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100073_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:176", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100073_[__fcnt + 2], &(*tout_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:176", 0));
      __fcnt += 3;
      while ($f_100073_[__fcnt] != NULL && $f_100073_[__fcnt] == FMT_TEXT) {
        if ($f_100073_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100073_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:176", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern4_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:177", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:177", 0));
        __fcnt += 3;
      }
      if ($f_100074_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:177", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100074_[__fcnt + 2], &(*tstop_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:177", 0));
      __fcnt += 3;
      while ($f_100074_[__fcnt] != NULL && $f_100074_[__fcnt] == FMT_TEXT) {
        if ($f_100074_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100074_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:177", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_156, (bufcpy ($55_, concat ($54_, concat ($53_, concat ($52_, concat ($51_, concat ($50_, 
      concat ($49_, concat ($48_, _dc_185, _dc_186), xern3_), _dc_187), _dc_188), _dc_189), xern4_), _dc_190), 4095), $55_), 
      ($56_ = 14, &$56_), &_k1);
      (*idid_) = -33;
    }
  }
  if ((*init_) != 0) {
    if ((*t_) == (*tout_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:191", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100081_[__fcnt] != NULL && $f_100081_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100081_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:191", 0));
        __fcnt += 3;
      }
      if ($f_100081_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100081_[__fcnt] != NULL && $f_100081_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100081_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:191", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100081_[__fcnt + 2], &(*t_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:191", 0));
      __fcnt += 3;
      while ($f_100081_[__fcnt] != NULL && $f_100081_[__fcnt] == FMT_TEXT) {
        if ($f_100081_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100081_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:191", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_156, (bufcpy ($60_, concat ($59_, concat ($58_, concat ($57_, _dc_185, _dc_191), xern3_), 
      _dc_192), 511), $60_), ($61_ = 9, &$61_), &_k1);
      (*idid_) = -33;
    }
    if ((*t_) != (*told_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:199", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:199", 0));
        __fcnt += 3;
      }
      if ($f_100086_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:199", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100086_[__fcnt + 2], &(*told_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:199", 0));
      __fcnt += 3;
      while ($f_100086_[__fcnt] != NULL && $f_100086_[__fcnt] == FMT_TEXT) {
        if ($f_100086_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100086_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:199", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern4_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:ddes:200", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:200", 0));
        __fcnt += 3;
      }
      if ($f_100087_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:200", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100087_[__fcnt + 2], &(*t_), REAL, 8);
      _write_err (__rc, 0, _ioerr_write ("slatec:ddes:200", 0));
      __fcnt += 3;
      while ($f_100087_[__fcnt] != NULL && $f_100087_[__fcnt] == FMT_TEXT) {
        if ($f_100087_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100087_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:200", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_156, (bufcpy ($67_, concat ($66_, concat ($65_, concat ($64_, concat ($63_, concat ($62_, 
      _dc_185, _dc_193), xern3_), _dc_194), xern4_), _dc_195), 1023), $67_), ($68_ = 10, &$68_), &_k1);
      (*idid_) = -33;
    }
    if ((*init_) != 1) {
      if ((*delsgn_) * ((*tout_) - (*t_)) < 0.0e0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern3_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:ddes:210", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100093_[__fcnt] != NULL && $f_100093_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100093_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:210", 0));
          __fcnt += 3;
        }
        if ($f_100093_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100093_[__fcnt] != NULL && $f_100093_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100093_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:ddes:210", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100093_[__fcnt + 2], &(*tout_), REAL, 8);
        _write_err (__rc, 0, _ioerr_write ("slatec:ddes:210", 0));
        __fcnt += 3;
        while ($f_100093_[__fcnt] != NULL && $f_100093_[__fcnt] == FMT_TEXT) {
          if ($f_100093_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100093_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:ddes:210", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_156, (bufcpy ($74_, concat ($73_, concat ($72_, concat ($71_, concat ($70_, concat ($69_, 
        _dc_196, _dc_197), xern3_), _dc_198), _dc_199), _dc_200), 1023), $74_), ($75_ = 11, &$75_), &_k1);
        (*idid_) = -33;
      }
    }
  }
  if ((*idid_) == -33) {
    if ((*iquit_) != -33) {
      (*iquit_) = -33;
      info_[0] = -1;
    }
    else {
      (void) _xermsg (_dc_1, _dc_156, concat ($79_, concat ($78_, concat ($77_, concat ($76_, _dc_201, _dc_202), _dc_203), 
      _dc_204), _dc_205), ($80_ = 12, &$80_), ($81_ = 2, &$81_));
    }
    goto _l0;
  }
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    if (rtol_[k_ - 1] + atol_[k_ - 1] > 0.0e0) {
      goto _l170;
    }
    rtol_[k_ - 1] = (*fouru_);
    (*idid_) = -2;
    _l170:;
    if (info_[1] == 0) {
      goto _l190;
    }
  }
  _l190:;
  if ((*idid_) != -2) {
    goto _l200;
  }
  info_[0] = -1;
  goto _l0;
  _l200:;
  if ((*init_) == 0) {
    goto _l210;
  }
  if ((*init_) == 1) {
    goto _l220;
  }
  goto _l240;
  _l210:;
  (*init_) = 1;
  a_ = (*t_);
  (void) _df (&a_, y_, yp_, rpar_, ipar_);
  if ((*t_) != (*tout_)) {
    goto _l220;
  }
  (*idid_) = 2;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*told_) = (*t_);
  goto _l0;
  _l220:;
  (*init_) = 2;
  (*x_) = (*t_);
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    yy_[l_ - 1] = y_[l_ - 1];
  }
  (*delsgn_) = _sign (1.0, (*tout_) - (*t_));
  (*h_) = _sign (_max ((*fouru_) * _abs ((*x_)), _abs ((*tout_) - (*x_))), (*tout_) - (*x_));
  _l240:;
  del_ = (*tout_) - (*t_);
  absdel_ = _abs (del_);
  _l250:;
  if (_abs ((*x_) - (*t_)) < absdel_) {
    goto _l260;
  }
  (void) _dintp (x_, yy_, tout_, y_, ypout_, neq_, kold_, phi_, ivc_, iv_, kgi_, gi_, alpha_, g_, w_, xold_, p_);
  (*idid_) = 3;
  if ((*x_) != (*tout_)) {
    goto _l255;
  }
  (*idid_) = 2;
  (*intout_) = FALSE;
  _l255:;
  (*t_) = (*tout_);
  (*told_) = (*t_);
  goto _l0;
  _l260:;
  if (info_[3] != 1) {
    goto _l280;
  }
  if (_abs ((*tstop_) - (*x_)) >= (*fouru_) * _abs ((*x_))) {
    goto _l280;
  }
  dt_ = (*tout_) - (*x_);
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1] + dt_ * yp_[l_ - 1];
  }
  (void) _df (tout_, y_, ypout_, rpar_, ipar_);
  (*idid_) = 3;
  (*t_) = (*tout_);
  (*told_) = (*t_);
  goto _l0;
  _l280:;
  if (info_[2] == 0 || ! ((*intout_))) {
    goto _l300;
  }
  (*idid_) = 1;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1];
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*t_) = (*x_);
  (*told_) = (*t_);
  (*intout_) = FALSE;
  goto _l0;
  _l300:;
  if ((*ksteps_) <= maxnum_) {
    goto _l330;
  }
  (*idid_) = -1;
  (*ksteps_) = 0;
  if (! ((*stiff_))) {
    goto _l310;
  }
  (*idid_) = -4;
  (*stiff_) = FALSE;
  (*kle4_) = 0;
  _l310:;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1];
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*t_) = (*x_);
  (*told_) = (*t_);
  info_[0] = -1;
  (*intout_) = FALSE;
  goto _l0;
  _l330:;
  ha_ = _abs ((*h_));
  if (info_[3] != 1) {
    goto _l340;
  }
  ha_ = _min (ha_, _abs ((*tstop_) - (*x_)));
  _l340:;
  (*h_) = _sign (ha_, (*h_));
  (*eps_) = 1.0;
  ltol_ = 1;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    if (info_[1] == 1) {
      ltol_ = l_;
    }
    wt_[l_ - 1] = rtol_[ltol_ - 1] * _abs (yy_[l_ - 1]) + atol_[ltol_ - 1];
    if (wt_[l_ - 1] <= 0.0e0) {
      goto _l360;
    }
  }
  goto _l380;
  _l360:;
  (*idid_) = -3;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1];
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*t_) = (*x_);
  (*told_) = (*t_);
  info_[0] = -1;
  (*intout_) = FALSE;
  goto _l0;
  _l380:;
  (void) _dsteps (_df, neq_, yy_, x_, h_, eps_, wt_, start_, hold_, kord_, kold_, &crash_, phi_, p_, yp_, psi_, alpha_, 
  beta_, sig_, v_, w_, g_, phase1_, ns_, nornd_, ksteps_, twou_, fouru_, xold_, kprev_, ivc_, iv_, kgi_, gi_, rpar_, 
  ipar_);
  if (! (crash_)) {
    goto _l420;
  }
  (*idid_) = -2;
  rtol_[0] = (*eps_) * rtol_[0];
  atol_[0] = (*eps_) * atol_[0];
  if (info_[1] == 0) {
    goto _l400;
  }
  for (l_ = 2; l_ <= (*neq_); (l_)++) {
    rtol_[l_ - 1] = (*eps_) * rtol_[l_ - 1];
    atol_[l_ - 1] = (*eps_) * atol_[l_ - 1];
  }
  _l400:;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1];
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*t_) = (*x_);
  (*told_) = (*t_);
  info_[0] = -1;
  (*intout_) = FALSE;
  goto _l0;
  _l420:;
  (*kle4_) = (*kle4_) + 1;
  if ((*kold_) > 4) {
    (*kle4_) = 0;
  }
  if ((*kle4_) >= 50) {
    (*stiff_) = TRUE;
  }
  (*intout_) = TRUE;
  goto _l250;
  _l0:;
  __calls[79].calls++;
  return 0;
}

int_4 _ddoglg (int_4 _p_ n_, real_8 _p_ r_, int_4 _p_ lr_, real_8 _p_ diag_, real_8 _p_ qtb_, real_8 _p_ delta_, real_8 
_p_ x_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 i_, j_, jj_, jp1_, k_, l_;
  static real_8 alpha_, bnorm_, epsmch_, gnorm_, one_, qnorm_, sgnorm_, sum_, temp_, zero_;
  int_4 _data_k_92, $0_;
  real_8 $1_, $2_, $3_, $4_, $5_;
  extern real_8 _d1mach ();
#define _data_n_92 2
  static real_8 _data_l_92[_data_n_92] = {
    1.0e0,
    0.0e0
  };
  if (__calls[80].calls == 0) {
    _data_k_92 = 0;
    if (_data_k_92 >= _data_n_92) {
      _data_k_92 = 0;
    }
    one_ = _data_l_92[_data_k_92++];
    if (_data_k_92 >= _data_n_92) {
      _data_k_92 = 0;
    }
    zero_ = _data_l_92[_data_k_92++];
  }
  epsmch_ = _d1mach (($0_ = 4, &$0_));
  jj_ = ((*n_) * ((*n_) + 1)) / 2 + 1;
  for (k_ = 1; k_ <= (*n_); (k_)++) {
    j_ = (*n_) - k_ + 1;
    jp1_ = j_ + 1;
    jj_ = jj_ - k_;
    l_ = jj_ + 1;
    sum_ = zero_;
    if ((*n_) < jp1_) {
      goto _l20;
    }
    for (i_ = jp1_; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + r_[l_ - 1] * x_[i_ - 1];
      l_ = l_ + 1;
    }
    _l20:;
    temp_ = r_[jj_ - 1];
    if (temp_ != zero_) {
      goto _l40;
    }
    l_ = j_;
    for (i_ = 1; i_ <= j_; (i_)++) {
      temp_ = _max (temp_, _abs (r_[l_ - 1]));
      l_ = l_ + (*n_) - i_;
    }
    temp_ = epsmch_ * temp_;
    if (temp_ == zero_) {
      temp_ = epsmch_;
    }
    _l40:;
    x_[j_ - 1] = (qtb_[j_ - 1] - sum_) / temp_;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = zero_;
    wa2_[j_ - 1] = diag_[j_ - 1] * x_[j_ - 1];
  }
  qnorm_ = _denorm (n_, wa2_);
  if (qnorm_ <= (*delta_)) {
    goto _l140;
  }
  l_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = qtb_[j_ - 1];
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      wa1_[i_ - 1] = wa1_[i_ - 1] + r_[l_ - 1] * temp_;
      l_ = l_ + 1;
    }
    wa1_[j_ - 1] = wa1_[j_ - 1] / diag_[j_ - 1];
  }
  gnorm_ = _denorm (n_, wa1_);
  sgnorm_ = zero_;
  alpha_ = (*delta_) / qnorm_;
  if (gnorm_ == zero_) {
    goto _l120;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    wa1_[j_ - 1] = (wa1_[j_ - 1] / gnorm_) / diag_[j_ - 1];
  }
  l_ = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    sum_ = zero_;
    for (i_ = j_; i_ <= (*n_); (i_)++) {
      sum_ = sum_ + r_[l_ - 1] * wa1_[i_ - 1];
      l_ = l_ + 1;
    }
    wa2_[j_ - 1] = sum_;
  }
  temp_ = _denorm (n_, wa2_);
  sgnorm_ = (gnorm_ / temp_) / temp_;
  alpha_ = zero_;
  if (sgnorm_ >= (*delta_)) {
    goto _l120;
  }
  bnorm_ = _denorm (n_, qtb_);
  temp_ = (bnorm_ / gnorm_) * (bnorm_ / qnorm_) * (sgnorm_ / (*delta_));
  temp_ = temp_ - ((*delta_) / qnorm_) * ($1_ = (sgnorm_ / (*delta_)), $1_ * $1_) + sqrt (($2_ = (temp_ - ((*delta_) / 
  qnorm_)), $2_ * $2_) + (one_ - ($3_ = ((*delta_) / qnorm_), $3_ * $3_)) * (one_ - ($4_ = (sgnorm_ / (*delta_)), $4_ * 
  $4_)));
  alpha_ = (((*delta_) / qnorm_) * (one_ - ($5_ = (sgnorm_ / (*delta_)), $5_ * $5_))) / temp_;
  _l120:;
  temp_ = (one_ - alpha_) * _min (sgnorm_, (*delta_));
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    x_[j_ - 1] = temp_ * wa1_[j_ - 1] + alpha_ * x_[j_ - 1];
  }
  _l140:;
  __calls[80].calls++;
  return 0;
}

int_4 _defcmn (int_4 _p_ ndata_, real_8 _p_ xdata_, real_8 _p_ ydata_, real_8 _p_ sddata_, int_4 _p_ nord_, int_4 _p_ 
nbkpt_, real_8 _p_ bkptin_, int_4 _p_ mdein_, int_4 _p_ mdeout_, real_8 _p_ coeff_, real_8 _p_ bf_, real_8 _p_ xtemp_, 
real_8 _p_ ptemp_, real_8 _p_ bkpt_, real_8 _p_ g_, int_4 _p_ mdg_, real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ lw_)
{
  static int_4 i_, idata_, ileft_, intseq_, ip_, ir_, irow_, l_, mt_, n_, nb_, nordm1_, nordp1_, np1_;
  static real_8 dummy_, rnorm_, xmax_, xmin_, xval_;
  static char_15 xern1_, xern2_;
  int_4 $1_, $3_, $4_, __fcnt, __rc, $10_, $11_, $12_, $13_, $15_, $16_, $17_;
  real_8 $0_, $14_, $18_;
  char_127 $2_, $5_;
  char_255 $6_;
  char_511 $7_;
  char_1023 $8_, $9_;
  extern int_4 _dcopy ();
  extern int_4 _dscal ();
  extern int_4 _xermsg ();
  static FORMAT $f_100026_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100027_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  n_ = (*nbkpt_) - (*nord_);
  np1_ = n_ + 1;
  (void) _dcopy (&n_, ($0_ = 0.0, &$0_), &_k0, coeff_, &_k1);
  (*mdeout_) = -1;
  if ((*nord_) < 1 || (*nord_) > 20) {
    (void) _xermsg (_dc_1, _dc_206, _dc_207, ($1_ = 3, &$1_), &_k1);
    goto _l0;
  }
  if ((*nbkpt_) < 2 * (*nord_)) {
    (void) _xermsg (_dc_1, _dc_206, concat ($2_, _dc_208, _dc_209), ($3_ = 4, &$3_), &_k1);
    goto _l0;
  }
  if ((*ndata_) < 0) {
    (void) _xermsg (_dc_1, _dc_206, _dc_210, ($4_ = 5, &$4_), &_k1);
    goto _l0;
  }
  nb_ = ((*nbkpt_) - (*nord_) + 3) * ((*nord_) + 1) + ((*nbkpt_) + 1) * ((*nord_) + 1) + 2 * _max ((*nbkpt_), (*ndata_)) 
  + (*nbkpt_) + ((*nord_) * (*nord_));
  if ((*lw_) < nb_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:defcmn:77", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:defcmn:77", 0));
      __fcnt += 3;
    }
    if ($f_100026_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:defcmn:77", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100026_[__fcnt + 2], &nb_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:defcmn:77", 0));
    __fcnt += 3;
    while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
      if ($f_100026_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:defcmn:77", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:defcmn:78", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:defcmn:78", 0));
      __fcnt += 3;
    }
    if ($f_100027_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:defcmn:78", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100027_[__fcnt + 2], &(*lw_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:defcmn:78", 0));
    __fcnt += 3;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      if ($f_100027_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:defcmn:78", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_206, (bufcpy ($9_, concat ($8_, concat ($7_, concat ($6_, concat ($5_, _dc_211, _dc_212), 
    xern1_), _dc_213), xern2_), 1023), $9_), ($10_ = 6, &$10_), &_k1);
    (*mdeout_) = -1;
    goto _l0;
  }
  if ((*mdein_) != 1 && (*mdein_) != 2) {
    (void) _xermsg (_dc_1, _dc_206, _dc_214, ($11_ = 7, &$11_), &_k1);
    goto _l0;
  }
  (void) _dcopy (nbkpt_, bkptin_, &_k1, bkpt_, &_k1);
  (void) _dsort (bkpt_, &dummy_, nbkpt_, &_k1);
  xmin_ = bkpt_[(*nord_) - 1];
  xmax_ = bkpt_[np1_ - 1];
  nordm1_ = (*nord_) - 1;
  nordp1_ = (*nord_) + 1;
  (void) _dcopy (ndata_, xdata_, &_k1, xtemp_, &_k1);
  for (i_ = 1; i_ <= (*ndata_); (i_)++) {
    ptemp_[i_ - 1] = i_;
  }
  if ((*ndata_) > 0) {
    (void) _dsort (xtemp_, ptemp_, ndata_, ($12_ = 2, &$12_));
    xmin_ = _min (xmin_, xtemp_[0]);
    xmax_ = _max (xmax_, xtemp_[(*ndata_) - 1]);
  }
  for (i_ = 1; i_ <= (*nord_); (i_)++) {
    bkpt_[i_ - 1] = _min (bkpt_[i_ - 1], xmin_);
  }
  for (i_ = np1_; i_ <= (*nbkpt_); (i_)++) {
    bkpt_[i_ - 1] = _max (bkpt_[i_ - 1], xmax_);
  }
  mt_ = 0;
  ip_ = 1;
  ir_ = 1;
  ileft_ = (*nord_);
  intseq_ = 1;
  for (idata_ = 1; idata_ <= (*ndata_); (idata_)++) {
    l_ = ptemp_[idata_ - 1];
    xval_ = xdata_[l_ - 1];
    if (xval_ >= bkpt_[ileft_ + 1 - 1]) {
      (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &mt_, ($13_ = ileft_ - nordm1_, &$13_));
      mt_ = 0;
      for (ileft_ = ileft_; ileft_ <= n_; (ileft_)++) {
        if (xval_ < bkpt_[ileft_ + 1 - 1]) {
          goto _l140;
        }
        if ((*mdein_) == 2) {
          (void) _dcopy (&nordp1_, &w_[intseq_ - 1 + ((*mdw_)) * ((0))], mdw_, &g_[ir_ - 1 + ((*mdg_)) * ((0))], mdg_);
          (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &_k1, &intseq_);
          intseq_ = intseq_ + 1;
        }
      }
    }
    _l140:;
    (void) _dfspvn (bkpt_, nord_, &_k1, &xval_, &ileft_, bf_);
    irow_ = ir_ + mt_;
    mt_ = mt_ + 1;
    (void) _dcopy (nord_, bf_, &_k1, &g_[irow_ - 1 + ((*mdg_)) * ((0))], mdg_);
    g_[irow_ - 1 + ((*mdg_)) * ((nordp1_ - 1))] = ydata_[l_ - 1];
    if (sddata_[l_ - 1] != 0.0e0) {
      (void) _dscal (&nordp1_, ($14_ = 1.0e0 / sddata_[l_ - 1], &$14_), &g_[irow_ - 1 + ((*mdg_)) * ((0))], mdg_);
    }
    if (irow_ == (*mdg_) - 1) {
      (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &mt_, ($15_ = ileft_ - nordm1_, &$15_));
      mt_ = 0;
    }
  }
  (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &mt_, ($16_ = ileft_ - nordm1_, &$16_));
  if ((*mdein_) == 2) {
    for (i_ = intseq_; i_ <= np1_; (i_)++) {
      (void) _dcopy (&nordp1_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &g_[ir_ - 1 + ((*mdg_)) * ((0))], mdg_);
      (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &_k1, ($17_ = _min (n_, i_), &$17_));
    }
  }
  (void) _dcopy (&nordp1_, ($18_ = 0.0, &$18_), &_k0, &g_[ir_ - 1 + ((*mdg_)) * ((0))], mdg_);
  (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &_k1, &np1_);
  for (i_ = 1; i_ <= np1_; (i_)++) {
    (void) _dcopy (&nordp1_, &g_[i_ - 1 + ((*mdg_)) * ((0))], mdg_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_);
  }
  for (i_ = 1; i_ <= n_; (i_)++) {
    if (g_[i_ - 1 + ((*mdg_)) * ((0))] == 0.0e0) {
      (*mdeout_) = 2;
      goto _l0;
    }
  }
  (void) _dbndsl (&_k1, g_, mdg_, nord_, &ip_, &ir_, coeff_, &n_, &rnorm_);
  (*mdeout_) = 1;
  _l0:;
  __calls[81].calls++;
  return 0;
}

int_4 _defe4 (int_4 (*_cofx)(), int_4 _p_ idmn_, real_4 _p_ usol_, real_4 _p_ grhs_)
{
  static int_4 i_, j_;
  static real_4 xi_, ai_, bi_, ci_, uxxx_, uxxxx_, uyyy_, uyyyy_, tx_, ty_;
  for (i_ = spl4_.is_; i_ <= spl4_.ms_; (i_)++) {
    xi_ = spl4_.ait_ + (i_ - 1) * spl4_.dlx_;
    (void) _cofx (&xi_, &ai_, &bi_, &ci_);
    for (j_ = spl4_.js_; j_ <= spl4_.ns_; (j_)++) {
      (void) _dx4 (usol_, idmn_, &i_, &j_, &uxxx_, &uxxxx_);
      (void) _dy4 (usol_, idmn_, &i_, &j_, &uyyy_, &uyyyy_);
      tx_ = ai_ * uxxxx_ / 12.0 + bi_ * uxxx_ / 6.0;
      ty_ = uyyyy_ / 12.0;
      if (spl4_.kswx_ == 1 || (i_ > 1 && i_ < spl4_.k_)) {
        goto _l10;
      }
      tx_ = ai_ / 3.0 * (uxxxx_ / 4.0 + uxxx_ / spl4_.dlx_);
      _l10:;
      if (spl4_.kswy_ == 1 || (j_ > 1 && j_ < spl4_.l_)) {
        goto _l20;
      }
      ty_ = (uyyyy_ / 4.0 + uyyy_ / spl4_.dly_) / 3.0;
      _l20:;
      grhs_[i_ - 1 + ((*idmn_)) * ((j_ - 1))] = grhs_[i_ - 1 + ((*idmn_)) * ((j_ - 1))] + (spl4_.dly_ * spl4_.dly_) * 
      ((spl4_.dlx_ * spl4_.dlx_) * tx_ + (spl4_.dly_ * spl4_.dly_) * ty_);
    }
  }
  for (i_ = spl4_.is_; i_ <= spl4_.ms_; (i_)++) {
    for (j_ = spl4_.js_; j_ <= spl4_.ns_; (j_)++) {
      usol_[i_ - 1 + ((*idmn_)) * ((j_ - 1))] = grhs_[i_ - 1 + ((*idmn_)) * ((j_ - 1))];
    }
  }
  __calls[82].calls++;
  return 0;
}

int_4 _defehl (int_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ h_, real_4 _p_ yp_, real_4 _p_ 
f1_, real_4 _p_ f2_, real_4 _p_ f3_, real_4 _p_ f4_, real_4 _p_ f5_, real_4 _p_ ys_, real_4 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 k_;
  static real_4 ch_;
  real_4 $0_, $1_, $2_, $3_, $4_;
  ch_ = (*h_) / 4.0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * yp_[k_ - 1];
  }
  (void) _f (($0_ = (*t_) + ch_, &$0_), ys_, f1_, rpar_, ipar_);
  ch_ = 3.0 * (*h_) / 32.0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * (yp_[k_ - 1] + 3.0 * f1_[k_ - 1]);
  }
  (void) _f (($1_ = (*t_) + 3.0 * (*h_) / 8.0, &$1_), ys_, f2_, rpar_, ipar_);
  ch_ = (*h_) / 2197.0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * (1932.0 * yp_[k_ - 1] + (7296.0 * f2_[k_ - 1] - 7200.0 * f1_[k_ - 1]));
  }
  (void) _f (($2_ = (*t_) + 12.0 * (*h_) / 13.0, &$2_), ys_, f3_, rpar_, ipar_);
  ch_ = (*h_) / 4104.0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * ((8341.0 * yp_[k_ - 1] - 845.0 * f3_[k_ - 1]) + (29440.0 * f2_[k_ - 1] - 32832.0 * 
    f1_[k_ - 1]));
  }
  (void) _f (($3_ = (*t_) + (*h_), &$3_), ys_, f4_, rpar_, ipar_);
  ch_ = (*h_) / 20520.0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * ((-6080.0 * yp_[k_ - 1] + (9295.0 * f3_[k_ - 1] - 5643.0 * f4_[k_ - 1])) + (41040.0 * 
    f1_[k_ - 1] - 28352.0 * f2_[k_ - 1]));
  }
  (void) _f (($4_ = (*t_) + (*h_) / 2.0, &$4_), ys_, f5_, rpar_, ipar_);
  ch_ = (*h_) / 7618050.0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * ((902880.0 * yp_[k_ - 1] + (3855735.0 * f3_[k_ - 1] - 1371249.0 * f4_[k_ - 1])) + 
    (3953664.0 * f2_[k_ - 1] + 277020.0 * f5_[k_ - 1]));
  }
  __calls[83].calls++;
  return 0;
}

int_4 _defer (int_4 (*_cofx)(), int_4 (*_cofy)(), int_4 _p_ idmn_, real_4 _p_ usol_, real_4 _p_ grhs_)
{
  static int_4 j_, i_;
  static real_4 yj_, dj_, ej_, fj_, xi_, ai_, bi_, ci_, uxxx_, uxxxx_, uyyy_, uyyyy_, tx_, ty_;
  for (j_ = splpcm_.js_; j_ <= splpcm_.ns_; (j_)++) {
    yj_ = splpcm_.cit_ + (j_ - 1) * splpcm_.dly_;
    (void) _cofy (&yj_, &dj_, &ej_, &fj_);
    for (i_ = splpcm_.is_; i_ <= splpcm_.ms_; (i_)++) {
      xi_ = splpcm_.ait_ + (i_ - 1) * splpcm_.dlx_;
      (void) _cofx (&xi_, &ai_, &bi_, &ci_);
      (void) _dx (usol_, idmn_, &i_, &j_, &uxxx_, &uxxxx_);
      (void) _dy (usol_, idmn_, &i_, &j_, &uyyy_, &uyyyy_);
      tx_ = ai_ * uxxxx_ / 12.0 + bi_ * uxxx_ / 6.0;
      ty_ = dj_ * uyyyy_ / 12.0 + ej_ * uyyy_ / 6.0;
      if (splpcm_.kswx_ == 1 || (i_ > 1 && i_ < splpcm_.k_)) {
        goto _l10;
      }
      tx_ = ai_ / 3.0 * (uxxxx_ / 4.0 + uxxx_ / splpcm_.dlx_);
      _l10:;
      if (splpcm_.kswy_ == 1 || (j_ > 1 && j_ < splpcm_.l_)) {
        goto _l20;
      }
      ty_ = dj_ / 3.0 * (uyyyy_ / 4.0 + uyyy_ / splpcm_.dly_);
      _l20:;
      grhs_[i_ - 1 + ((*idmn_)) * ((j_ - 1))] = grhs_[i_ - 1 + ((*idmn_)) * ((j_ - 1))] + (splpcm_.dlx_ * splpcm_.dlx_) * tx_ 
      + (splpcm_.dly_ * splpcm_.dly_) * ty_;
    }
  }
  for (i_ = splpcm_.is_; i_ <= splpcm_.ms_; (i_)++) {
    for (j_ = splpcm_.js_; j_ <= splpcm_.ns_; (j_)++) {
      usol_[i_ - 1 + ((*idmn_)) * ((j_ - 1))] = grhs_[i_ - 1 + ((*idmn_)) * ((j_ - 1))];
    }
  }
  __calls[84].calls++;
  return 0;
}

real_8 _denorm (int_4 _p_ n_, real_8 _p_ x_)
{
  static int_4 i_;
  static real_8 agiant_, floatn_, one_, rdwarf_, rgiant_, s1_, s2_, s3_, x1max_, x3max_, xabs_, zero_;
  int_4 _data_k_93;
  real_8 $0_, $1_, $2_, $3_;
  real_8 denorm_;
#define _data_n_93 4
  static real_8 _data_l_93[_data_n_93] = {
    1.0e0,
    0.0e0,
    3.834e-20,
    1.304e19
  };
  if (__calls[85].calls == 0) {
    _data_k_93 = 0;
    if (_data_k_93 >= _data_n_93) {
      _data_k_93 = 0;
    }
    one_ = _data_l_93[_data_k_93++];
    if (_data_k_93 >= _data_n_93) {
      _data_k_93 = 0;
    }
    zero_ = _data_l_93[_data_k_93++];
    if (_data_k_93 >= _data_n_93) {
      _data_k_93 = 0;
    }
    rdwarf_ = _data_l_93[_data_k_93++];
    if (_data_k_93 >= _data_n_93) {
      _data_k_93 = 0;
    }
    rgiant_ = _data_l_93[_data_k_93++];
  }
  s1_ = zero_;
  s2_ = zero_;
  s3_ = zero_;
  x1max_ = zero_;
  x3max_ = zero_;
  floatn_ = (*n_);
  agiant_ = rgiant_ / floatn_;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    xabs_ = _abs (x_[i_ - 1]);
    if (xabs_ > rdwarf_ && xabs_ < agiant_) {
      goto _l70;
    }
    if (xabs_ <= rdwarf_) {
      goto _l30;
    }
    if (xabs_ <= x1max_) {
      goto _l10;
    }
    s1_ = one_ + s1_ * ($0_ = (x1max_ / xabs_), $0_ * $0_);
    x1max_ = xabs_;
    goto _l20;
    _l10:;
    s1_ = s1_ + ($1_ = (xabs_ / x1max_), $1_ * $1_);
    _l20:;
    goto _l60;
    _l30:;
    if (xabs_ <= x3max_) {
      goto _l40;
    }
    s3_ = one_ + s3_ * ($2_ = (x3max_ / xabs_), $2_ * $2_);
    x3max_ = xabs_;
    goto _l50;
    _l40:;
    if (xabs_ != zero_) {
      s3_ = s3_ + ($3_ = (xabs_ / x3max_), $3_ * $3_);
    }
    _l50:;
    _l60:;
    goto _l80;
    _l70:;
    s2_ = s2_ + (xabs_ * xabs_);
    _l80:;
  }
  if (s1_ == zero_) {
    goto _l100;
  }
  denorm_ = x1max_ * sqrt (s1_ + (s2_ / x1max_) / x1max_);
  goto _l130;
  _l100:;
  if (s2_ == zero_) {
    goto _l110;
  }
  if (s2_ >= x3max_) {
    denorm_ = sqrt (s2_ * (one_ + (x3max_ / s2_) * (x3max_ * s3_)));
  }
  if (s2_ < x3max_) {
    denorm_ = sqrt (x3max_ * ((s2_ / x3max_) + (x3max_ * s3_)));
  }
  goto _l120;
  _l110:;
  denorm_ = x3max_ * sqrt (s3_);
  _l120:;
  _l130:;
  __calls[85].calls++;
  return denorm_;
}

int_4 _derkfs (int_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ tout_, int_4 _p_ info_, real_4 
_p_ rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ h_, real_4 _p_ tolfac_, real_4 _p_ yp_, real_4 _p_ f1_, real_4 
_p_ f2_, real_4 _p_ f3_, real_4 _p_ f4_, real_4 _p_ f5_, real_4 _p_ ys_, real_4 _p_ told_, real_4 _p_ dtsign_, real_4 
_p_ u26_, real_4 _p_ rer_, int_4 _p_ init_, int_4 _p_ ksteps_, int_4 _p_ kop_, int_4 _p_ iquit_, logical_4 _p_ stiff_, 
logical_4 _p_ nonstf_, int_4 _p_ ntstep_, int_4 _p_ nstifs_, real_4 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 mxstep_, mxkop_, nrtolp_, natolp_, k_, ktol_;
  static logical_4 hfaild_, output_;
  static real_4 remin_, u_, a_, big_, ute_, dy_, tol_, dt_, et_, hmin_, eeoet_, estiff_, yavg_, ee_, es_, esttol_, s_;
  static char_15 xern1_;
  static char_31 xern3_, xern4_;
  int_4 _data_k_94, _data_k_95, _data_k_96, $0_, __fcnt, __rc, $7_, $12_, $18_, $23_, $32_, $41_, $47_, $54_, $61_, $65_, 
  $66_, $67_, $68_, $69_;
  char_63 $42_, $48_, $55_;
  char_127 $1_, $8_, $13_, $19_, $24_, $33_, $43_, $49_, $56_, $62_;
  char_255 $2_, $9_, $14_, $20_, $25_, $34_, $44_, $50_, $57_, $63_;
  char_511 $3_, $10_, $11_, $15_, $21_, $22_, $26_, $35_, $45_, $46_, $51_, $58_, $64_;
  char_1023 $4_, $16_, $17_, $27_, $36_, $52_, $53_, $59_, $60_;
  char_2047 $5_, $6_, $28_, $37_;
  char_4095 $29_, $30_, $31_, $38_, $39_, $40_;
  extern real_4 _r1mach ();
  static FORMAT $f_100026_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100031_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100036_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100041_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100049_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100050_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100056_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100057_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100067_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100072_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100073_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100079_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
#define _data_n_94 1
  static real_4 _data_l_94[_data_n_94] = {
    1.0e-12
  };
#define _data_n_95 1
  static int_4 _data_l_95[_data_n_95] = {
    500
  };
#define _data_n_96 1
  static int_4 _data_l_96[_data_n_96] = {
    100
  };
  if (__calls[86].calls == 0) {
    _data_k_94 = 0;
    if (_data_k_94 >= _data_n_94) {
      _data_k_94 = 0;
    }
    remin_ = _data_l_94[_data_k_94++];
  }
  if (__calls[86].calls == 0) {
    _data_k_95 = 0;
    if (_data_k_95 >= _data_n_95) {
      _data_k_95 = 0;
    }
    mxstep_ = _data_l_95[_data_k_95++];
  }
  if (__calls[86].calls == 0) {
    _data_k_96 = 0;
    if (_data_k_96 >= _data_n_96) {
      _data_k_96 = 0;
    }
    mxkop_ = _data_l_96[_data_k_96++];
  }
  if (info_[0] == 0) {
    u_ = _r1mach (($0_ = 4, &$0_));
    (*u26_) = 26.0 * u_;
    (*rer_) = 2.0 * u_ + remin_;
    (*iquit_) = 0;
    (*init_) = 0;
    (*kop_) = 0;
    (*ksteps_) = 0;
    (*stiff_) = FALSE;
    (*nonstf_) = FALSE;
    (*ntstep_) = 0;
    (*nstifs_) = 0;
    info_[0] = 1;
  }
  if (info_[0] != 0 && info_[0] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:derkfs:128", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:128", 0));
      __fcnt += 3;
    }
    if ($f_100026_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:128", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100026_[__fcnt + 2], &info_[0], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:128", 0));
    __fcnt += 3;
    while ($f_100026_[__fcnt] != NULL && $f_100026_[__fcnt] == FMT_TEXT) {
      if ($f_100026_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100026_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:128", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_215, (bufcpy ($6_, concat ($5_, concat ($4_, concat ($3_, concat ($2_, concat ($1_, _dc_216, 
    _dc_217), _dc_218), _dc_219), _dc_220), xern1_), 2047), $6_), ($7_ = 3, &$7_), &_k1);
    (*idid_) = -33;
  }
  if (info_[1] != 0 && info_[1] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:derkfs:139", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:139", 0));
      __fcnt += 3;
    }
    if ($f_100031_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:139", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100031_[__fcnt + 2], &info_[1], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:139", 0));
    __fcnt += 3;
    while ($f_100031_[__fcnt] != NULL && $f_100031_[__fcnt] == FMT_TEXT) {
      if ($f_100031_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100031_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:139", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_215, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_221, _dc_222), _dc_223), 
    xern1_), 511), $11_), ($12_ = 4, &$12_), &_k1);
    (*idid_) = -33;
  }
  if (info_[2] != 0 && info_[2] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:derkfs:148", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:148", 0));
      __fcnt += 3;
    }
    if ($f_100036_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:148", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100036_[__fcnt + 2], &info_[2], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:148", 0));
    __fcnt += 3;
    while ($f_100036_[__fcnt] != NULL && $f_100036_[__fcnt] == FMT_TEXT) {
      if ($f_100036_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100036_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:148", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_215, (bufcpy ($17_, concat ($16_, concat ($15_, concat ($14_, concat ($13_, _dc_224, 
    _dc_225), _dc_226), _dc_227), xern1_), 1023), $17_), ($18_ = 5, &$18_), &_k1);
    (*idid_) = -33;
  }
  if ((*neq_) < 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:derkfs:158", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:158", 0));
      __fcnt += 3;
    }
    if ($f_100041_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:158", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100041_[__fcnt + 2], &(*neq_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:158", 0));
    __fcnt += 3;
    while ($f_100041_[__fcnt] != NULL && $f_100041_[__fcnt] == FMT_TEXT) {
      if ($f_100041_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100041_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:158", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_215, (bufcpy ($22_, concat ($21_, concat ($20_, concat ($19_, _dc_228, _dc_229), _dc_230), 
    xern1_), 511), $22_), ($23_ = 6, &$23_), &_k1);
    (*idid_) = -33;
  }
  nrtolp_ = 0;
  natolp_ = 0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    if (nrtolp_ == 0 && rtol_[k_ - 1] < 0.0e0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:derkfs:170", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:170", 0));
        __fcnt += 3;
      }
      if ($f_100049_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:170", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100049_[__fcnt + 2], &k_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:170", 0));
      __fcnt += 3;
      while ($f_100049_[__fcnt] != NULL && $f_100049_[__fcnt] == FMT_TEXT) {
        if ($f_100049_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100049_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:170", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:derkfs:171", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100050_[__fcnt] != NULL && $f_100050_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100050_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:171", 0));
        __fcnt += 3;
      }
      if ($f_100050_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100050_[__fcnt] != NULL && $f_100050_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100050_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:171", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100050_[__fcnt + 2], &rtol_[k_ - 1], REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:171", 0));
      __fcnt += 3;
      while ($f_100050_[__fcnt] != NULL && $f_100050_[__fcnt] == FMT_TEXT) {
        if ($f_100050_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100050_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:171", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_215, (bufcpy ($31_, concat ($30_, concat ($29_, concat ($28_, concat ($27_, concat ($26_, 
      concat ($25_, concat ($24_, _dc_231, _dc_232), _dc_233), xern1_), _dc_64), xern3_), _dc_179), _dc_180), 4095), $31_), 
      ($32_ = 7, &$32_), &_k1);
      (*idid_) = -33;
      nrtolp_ = 1;
    }
    if (natolp_ == 0 && atol_[k_ - 1] < 0.0e0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:derkfs:183", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:183", 0));
        __fcnt += 3;
      }
      if ($f_100056_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:183", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100056_[__fcnt + 2], &k_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:183", 0));
      __fcnt += 3;
      while ($f_100056_[__fcnt] != NULL && $f_100056_[__fcnt] == FMT_TEXT) {
        if ($f_100056_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100056_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:183", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:derkfs:184", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100057_[__fcnt] != NULL && $f_100057_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100057_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:184", 0));
        __fcnt += 3;
      }
      if ($f_100057_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100057_[__fcnt] != NULL && $f_100057_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100057_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:184", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100057_[__fcnt + 2], &atol_[k_ - 1], REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:184", 0));
      __fcnt += 3;
      while ($f_100057_[__fcnt] != NULL && $f_100057_[__fcnt] == FMT_TEXT) {
        if ($f_100057_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100057_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:184", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_215, (bufcpy ($40_, concat ($39_, concat ($38_, concat ($37_, concat ($36_, concat ($35_, 
      concat ($34_, concat ($33_, _dc_234, _dc_235), _dc_236), xern1_), _dc_64), xern3_), _dc_179), _dc_184), 4095), $40_), 
      ($41_ = 8, &$41_), &_k1);
      (*idid_) = -33;
      natolp_ = 1;
    }
    if (info_[1] == 0) {
      goto _l20;
    }
    if (natolp_ > 0 && nrtolp_ > 0) {
      goto _l20;
    }
  }
  _l20:;
  if ((*init_) != 0) {
    if ((*t_) == (*tout_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:derkfs:204", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100067_[__fcnt] != NULL && $f_100067_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100067_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:204", 0));
        __fcnt += 3;
      }
      if ($f_100067_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100067_[__fcnt] != NULL && $f_100067_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100067_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:204", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100067_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:204", 0));
      __fcnt += 3;
      while ($f_100067_[__fcnt] != NULL && $f_100067_[__fcnt] == FMT_TEXT) {
        if ($f_100067_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100067_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:204", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_215, (bufcpy ($46_, concat ($45_, concat ($44_, concat ($43_, concat ($42_, _dc_237, 
      _dc_238), xern3_), _dc_239), _dc_240), 511), $46_), ($47_ = 9, &$47_), &_k1);
      (*idid_) = -33;
    }
    if ((*t_) != (*told_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:derkfs:213", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100072_[__fcnt] != NULL && $f_100072_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100072_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:213", 0));
        __fcnt += 3;
      }
      if ($f_100072_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100072_[__fcnt] != NULL && $f_100072_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100072_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:213", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100072_[__fcnt + 2], &(*told_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:213", 0));
      __fcnt += 3;
      while ($f_100072_[__fcnt] != NULL && $f_100072_[__fcnt] == FMT_TEXT) {
        if ($f_100072_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100072_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:213", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern4_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:derkfs:214", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100073_[__fcnt] != NULL && $f_100073_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100073_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:214", 0));
        __fcnt += 3;
      }
      if ($f_100073_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100073_[__fcnt] != NULL && $f_100073_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100073_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:214", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100073_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:214", 0));
      __fcnt += 3;
      while ($f_100073_[__fcnt] != NULL && $f_100073_[__fcnt] == FMT_TEXT) {
        if ($f_100073_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100073_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:214", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_215, (bufcpy ($53_, concat ($52_, concat ($51_, concat ($50_, concat ($49_, concat ($48_, 
      _dc_241, _dc_242), xern3_), _dc_194), xern4_), _dc_192), 1023), $53_), ($54_ = 10, &$54_), &_k1);
      (*idid_) = -33;
    }
    if ((*init_) != 1) {
      if ((*dtsign_) * ((*tout_) - (*t_)) < 0.0e0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern3_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:derkfs:224", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100079_[__fcnt] != NULL && $f_100079_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100079_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:224", 0));
          __fcnt += 3;
        }
        if ($f_100079_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100079_[__fcnt] != NULL && $f_100079_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100079_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:224", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100079_[__fcnt + 2], &(*tout_), REAL, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:224", 0));
        __fcnt += 3;
        while ($f_100079_[__fcnt] != NULL && $f_100079_[__fcnt] == FMT_TEXT) {
          if ($f_100079_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100079_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:derkfs:224", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_215, (bufcpy ($60_, concat ($59_, concat ($58_, concat ($57_, concat ($56_, concat ($55_, 
        _dc_243, _dc_244), xern3_), _dc_245), _dc_246), _dc_247), 1023), $60_), ($61_ = 11, &$61_), &_k1);
        (*idid_) = -33;
      }
    }
  }
  if ((*idid_) == -33) {
    if ((*iquit_) != -33) {
      (*iquit_) = -33;
      goto _l909;
    }
    else {
      (void) _xermsg (_dc_1, _dc_215, concat ($64_, concat ($63_, concat ($62_, _dc_248, _dc_249), _dc_250), _dc_251), ($65_ 
      = 12, &$65_), ($66_ = 2, &$66_));
      goto _l0;
    }
  }
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    if (rtol_[k_ - 1] + atol_[k_ - 1] > 0.0) {
      goto _l45;
    }
    rtol_[k_ - 1] = (*rer_);
    (*idid_) = -2;
    _l45:;
    if (info_[1] == 0) {
      goto _l55;
    }
  }
  _l55:;
  if ((*idid_) != -2) {
    goto _l60;
  }
  (*tolfac_) = 1.0;
  goto _l909;
  _l60:;
  if ((*init_) == 0) {
    goto _l65;
  }
  if ((*init_) == 1) {
    goto _l70;
  }
  goto _l80;
  _l65:;
  (*init_) = 1;
  a_ = (*t_);
  (void) _f (&a_, y_, yp_, rpar_, ipar_);
  if ((*t_) == (*tout_)) {
    goto _l666;
  }
  _l70:;
  (*init_) = 2;
  (*dtsign_) = _sign (1.0, (*tout_) - (*t_));
  u_ = _r1mach (($67_ = 4, &$67_));
  big_ = sqrtf (_r1mach (($68_ = 2, &$68_)));
  ute_ = powl (u_, 0.375);
  dy_ = ute_ * _hvnrm (y_, neq_);
  if (dy_ == 0.0) {
    dy_ = ute_;
  }
  ktol_ = 1;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    if (info_[1] == 1) {
      ktol_ = k_;
    }
    tol_ = rtol_[ktol_ - 1] * _abs (y_[k_ - 1]) + atol_[ktol_ - 1];
    if (tol_ == 0.0) {
      tol_ = dy_ * rtol_[ktol_ - 1];
    }
    f1_[k_ - 1] = tol_;
  }
  (void) _hstart (_f, neq_, t_, tout_, y_, yp_, f1_, ($69_ = 4, &$69_), &u_, &big_, f2_, f3_, f4_, f5_, rpar_, ipar_, h_)
  ;
  _l80:;
  dt_ = (*tout_) - (*t_);
  (*h_) = _sign ((*h_), dt_);
  output_ = FALSE;
  if (_abs ((*h_)) >= 2.0 * _abs (dt_)) {
    (*kop_) = (*kop_) + 1;
  }
  if ((*kop_) <= mxkop_) {
    goto _l85;
  }
  (*idid_) = -5;
  (*kop_) = 0;
  goto _l909;
  _l85:;
  if (_abs (dt_) > (*u26_) * _abs ((*t_))) {
    goto _l100;
  }
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    y_[k_ - 1] = y_[k_ - 1] + dt_ * yp_[k_ - 1];
  }
  a_ = (*tout_);
  (void) _f (&a_, y_, yp_, rpar_, ipar_);
  (*ksteps_) = (*ksteps_) + 1;
  goto _l666;
  _l100:;
  hfaild_ = FALSE;
  (*tolfac_) = 0.0;
  ktol_ = 1;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    if (info_[1] == 1) {
      ktol_ = k_;
    }
    et_ = rtol_[ktol_ - 1] * _abs (y_[k_ - 1]) + atol_[ktol_ - 1];
    if (et_ > 0.0) {
      goto _l120;
    }
    (*tolfac_) = _max ((*tolfac_), (*rer_) / rtol_[ktol_ - 1]);
    goto _l125;
    _l120:;
    (*tolfac_) = _max ((*tolfac_), _abs (y_[k_ - 1]) * ((*rer_) / et_));
    _l125:;
  }
  if ((*tolfac_) <= 1.0) {
    goto _l150;
  }
  (*tolfac_) = 2.0 * (*tolfac_);
  (*idid_) = -2;
  goto _l909;
  _l150:;
  hmin_ = (*u26_) * _abs ((*t_));
  dt_ = (*tout_) - (*t_);
  if (_abs (dt_) >= 2.0 * _abs ((*h_))) {
    goto _l200;
  }
  if (_abs (dt_) > _abs ((*h_)) / 0.9) {
    goto _l175;
  }
  output_ = TRUE;
  (*h_) = dt_;
  goto _l200;
  _l175:;
  (*h_) = 0.5 * dt_;
  _l200:;
  if ((*ksteps_) <= mxstep_) {
    goto _l222;
  }
  (*idid_) = -1;
  (*ksteps_) = 0;
  if (! ((*stiff_))) {
    goto _l909;
  }
  (*idid_) = -4;
  (*stiff_) = FALSE;
  (*nonstf_) = FALSE;
  (*ntstep_) = 0;
  (*nstifs_) = 0;
  goto _l909;
  _l222:;
  (void) _defehl (_f, neq_, t_, y_, h_, yp_, f1_, f2_, f3_, f4_, f5_, ys_, rpar_, ipar_);
  (*ksteps_) = (*ksteps_) + 1;
  eeoet_ = 0.0;
  estiff_ = 0.0;
  ktol_ = 1;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    yavg_ = 0.5 * (_abs (y_[k_ - 1]) + _abs (ys_[k_ - 1]));
    if (info_[1] == 1) {
      ktol_ = k_;
    }
    et_ = rtol_[ktol_ - 1] * yavg_ + atol_[ktol_ - 1];
    if (et_ > 0.0) {
      goto _l325;
    }
    (*idid_) = -3;
    goto _l909;
    _l325:;
    ee_ = _abs ((-2090.0 * yp_[k_ - 1] + (21970.0 * f3_[k_ - 1] - 15048.0 * f4_[k_ - 1])) + (22528.0 * f2_[k_ - 1] - 
    27360.0 * f5_[k_ - 1]));
    if ((*stiff_) || (*nonstf_)) {
      goto _l350;
    }
    es_ = _abs ((*h_) * (0.055455 * yp_[k_ - 1] - 0.035493 * f1_[k_ - 1] - 0.036571 * f2_[k_ - 1] + 0.023107 * f3_[k_ - 1] 
    - 0.009515 * f4_[k_ - 1] + 0.003017 * f5_[k_ - 1]));
    estiff_ = _max (estiff_, es_ / et_);
    _l350:;
    eeoet_ = _max (eeoet_, ee_ / et_);
  }
  esttol_ = _abs ((*h_)) * eeoet_ / 752400.0;
  if (esttol_ <= 1.0) {
    goto _l500;
  }
  if (_abs ((*h_)) > hmin_) {
    goto _l400;
  }
  (*tolfac_) = 1.69 * esttol_;
  (*idid_) = -2;
  goto _l909;
  _l400:;
  hfaild_ = TRUE;
  output_ = FALSE;
  s_ = 0.1;
  if (esttol_ < 59049.0) {
    s_ = 0.9 / powl (esttol_, 0.2);
  }
  (*h_) = _sign (_max (s_ * _abs ((*h_)), hmin_), (*h_));
  goto _l200;
  _l500:;
  (*t_) = (*t_) + (*h_);
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    y_[k_ - 1] = ys_[k_ - 1];
  }
  a_ = (*t_);
  (void) _f (&a_, y_, yp_, rpar_, ipar_);
  s_ = 5.0;
  if (esttol_ > 1.889568e-4) {
    s_ = 0.9 / powl (esttol_, 0.2);
  }
  if (hfaild_) {
    s_ = _min (s_, 1.0);
  }
  (*h_) = _sign (_max (s_ * _abs ((*h_)), hmin_), (*h_));
  if ((*stiff_)) {
    goto _l600;
  }
  (*ntstep_) = _imod ((*ntstep_) + 1, 50);
  if ((*ntstep_) == 1) {
    (*nonstf_) = FALSE;
  }
  if ((*nonstf_)) {
    goto _l600;
  }
  if (estiff_ > 1.0) {
    goto _l550;
  }
  (*nstifs_) = (*nstifs_) + 1;
  if ((*nstifs_) == 25) {
    (*stiff_) = TRUE;
  }
  goto _l600;
  _l550:;
  if ((*ntstep_) - (*nstifs_) <= 25) {
    goto _l600;
  }
  (*nonstf_) = TRUE;
  (*nstifs_) = 0;
  _l600:;
  if (output_) {
    goto _l666;
  }
  if (info_[2] == 0) {
    goto _l100;
  }
  (*idid_) = 1;
  (*told_) = (*t_);
  goto _l0;
  _l666:;
  (*idid_) = 2;
  (*t_) = (*tout_);
  (*told_) = (*t_);
  goto _l0;
  _l909:;
  info_[0] = -1;
  (*told_) = (*t_);
  if ((*idid_) != -2) {
    goto _l0;
  }
  rtol_[0] = (*tolfac_) * rtol_[0];
  atol_[0] = (*tolfac_) * atol_[0];
  if (info_[1] == 0) {
    goto _l0;
  }
  for (k_ = 2; k_ <= (*neq_); (k_)++) {
    rtol_[k_ - 1] = (*tolfac_) * rtol_[k_ - 1];
    atol_[k_ - 1] = (*tolfac_) * atol_[k_ - 1];
  }
  _l0:;
  __calls[86].calls++;
  return 0;
}

int_4 _des (int_4 (*_f)(), int_4 _p_ neq_, real_4 _p_ t_, real_4 _p_ y_, real_4 _p_ tout_, int_4 _p_ info_, real_4 _p_ 
rtol_, real_4 _p_ atol_, int_4 _p_ idid_, real_4 _p_ ypout_, real_4 _p_ yp_, real_4 _p_ yy_, real_4 _p_ wt_, real_4 _p_ 
p_, real_4 _p_ phi_, real_4 _p_ alpha_, real_4 _p_ beta_, real_4 _p_ psi_, real_4 _p_ v_, real_4 _p_ w_, real_4 _p_ 
sig_, real_4 _p_ g_, real_4 _p_ gi_, real_4 _p_ h_, real_4 _p_ eps_, real_4 _p_ x_, real_4 _p_ xold_, real_4 _p_ hold_, 
real_4 _p_ told_, real_4 _p_ delsgn_, real_4 _p_ tstop_, real_4 _p_ twou_, real_4 _p_ fouru_, logical_4 _p_ start_, 
logical_4 _p_ phase1_, logical_4 _p_ nornd_, logical_4 _p_ stiff_, logical_4 _p_ intout_, int_4 _p_ ns_, int_4 _p_ 
kord_, int_4 _p_ kold_, int_4 _p_ init_, int_4 _p_ ksteps_, int_4 _p_ kle4_, int_4 _p_ iquit_, int_4 _p_ kprev_, int_4 
_p_ ivc_, int_4 _p_ iv_, int_4 _p_ kgi_, real_4 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 maxnum_, nrtolp_, natolp_, k_, l_, ltol_;
  static logical_4 crash_;
  static real_4 u_, a_, del_, absdel_, dt_, ha_;
  static char_15 xern1_;
  static char_31 xern3_, xern4_;
  int_4 _data_k_97, $0_, __fcnt, __rc, $7_, $12_, $18_, $24_, $29_, $38_, $47_, $57_, $63_, $70_, $78_, $82_, $83_;
  char_63 $48_, $58_, $64_, $71_;
  char_127 $1_, $8_, $13_, $19_, $25_, $30_, $39_, $49_, $59_, $65_, $72_, $79_;
  char_255 $2_, $9_, $14_, $20_, $26_, $31_, $40_, $50_, $60_, $66_, $73_, $80_;
  char_511 $3_, $10_, $11_, $15_, $21_, $27_, $28_, $32_, $41_, $51_, $61_, $62_, $67_, $74_, $81_;
  char_1023 $4_, $16_, $17_, $22_, $23_, $33_, $42_, $52_, $68_, $69_, $75_;
  char_2047 $5_, $6_, $34_, $43_, $53_, $76_, $77_;
  char_4095 $35_, $36_, $37_, $44_, $45_, $46_, $54_, $55_, $56_;
  extern real_4 _r1mach ();
  static FORMAT $f_100025_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100030_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100035_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100040_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100045_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100053_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100054_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100060_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100061_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100071_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100072_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100079_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100084_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100085_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
  static FORMAT $f_100091_[] = {
    FMT_TEXT,"","1",
    FMT_REAL,"%15e","%15.6.0e",
    NULL, NULL, NULL
  };
#define _data_n_97 1
  static int_4 _data_l_97[_data_n_97] = {
    500
  };
  if (__calls[87].calls == 0) {
    _data_k_97 = 0;
    if (_data_k_97 >= _data_n_97) {
      _data_k_97 = 0;
    }
    maxnum_ = _data_l_97[_data_k_97++];
  }
  if (info_[0] == 0) {
    u_ = _r1mach (($0_ = 4, &$0_));
    (*twou_) = 2.0 * u_;
    (*fouru_) = 4.0 * u_;
    (*iquit_) = 0;
    (*init_) = 0;
    (*ksteps_) = 0;
    (*intout_) = FALSE;
    (*stiff_) = FALSE;
    (*kle4_) = 0;
    (*start_) = TRUE;
    (*phase1_) = TRUE;
    (*nornd_) = TRUE;
    info_[0] = 1;
  }
  if (info_[0] != 0 && info_[0] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:des:91", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:91", 0));
      __fcnt += 3;
    }
    if ($f_100025_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:91", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100025_[__fcnt + 2], &info_[0], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:des:91", 0));
    __fcnt += 3;
    while ($f_100025_[__fcnt] != NULL && $f_100025_[__fcnt] == FMT_TEXT) {
      if ($f_100025_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100025_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:91", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_252, (bufcpy ($6_, concat ($5_, concat ($4_, concat ($3_, concat ($2_, concat ($1_, _dc_253, 
    _dc_158), _dc_159), _dc_160), _dc_161), xern1_), 2047), $6_), ($7_ = 3, &$7_), &_k1);
    (*idid_) = -33;
  }
  if (info_[1] != 0 && info_[1] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:des:102", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:102", 0));
      __fcnt += 3;
    }
    if ($f_100030_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:102", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100030_[__fcnt + 2], &info_[1], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:des:102", 0));
    __fcnt += 3;
    while ($f_100030_[__fcnt] != NULL && $f_100030_[__fcnt] == FMT_TEXT) {
      if ($f_100030_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100030_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:102", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_252, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, _dc_254, _dc_255), _dc_164), 
    xern1_), 511), $11_), ($12_ = 4, &$12_), &_k1);
    (*idid_) = -33;
  }
  if (info_[2] != 0 && info_[2] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:des:112", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:112", 0));
      __fcnt += 3;
    }
    if ($f_100035_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:112", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100035_[__fcnt + 2], &info_[2], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:des:112", 0));
    __fcnt += 3;
    while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
      if ($f_100035_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:112", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_252, (bufcpy ($17_, concat ($16_, concat ($15_, concat ($14_, concat ($13_, _dc_256, 
    _dc_257), _dc_258), _dc_227), xern1_), 1023), $17_), ($18_ = 5, &$18_), &_k1);
    (*idid_) = -33;
  }
  if (info_[3] != 0 && info_[3] != 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:des:122", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:122", 0));
      __fcnt += 3;
    }
    if ($f_100040_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:122", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100040_[__fcnt + 2], &info_[3], INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:des:122", 0));
    __fcnt += 3;
    while ($f_100040_[__fcnt] != NULL && $f_100040_[__fcnt] == FMT_TEXT) {
      if ($f_100040_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100040_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:122", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_252, (bufcpy ($23_, concat ($22_, concat ($21_, concat ($20_, concat ($19_, _dc_259, 
    _dc_260), _dc_261), _dc_262), xern1_), 1023), $23_), ($24_ = 14, &$24_), &_k1);
    (*idid_) = -33;
  }
  if ((*neq_) < 1) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:des:132", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100045_[__fcnt] != NULL && $f_100045_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100045_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:132", 0));
      __fcnt += 3;
    }
    if ($f_100045_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100045_[__fcnt] != NULL && $f_100045_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100045_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:132", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100045_[__fcnt + 2], &(*neq_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:des:132", 0));
    __fcnt += 3;
    while ($f_100045_[__fcnt] != NULL && $f_100045_[__fcnt] == FMT_TEXT) {
      if ($f_100045_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100045_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:132", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_252, (bufcpy ($28_, concat ($27_, concat ($26_, concat ($25_, _dc_263, _dc_264), _dc_265), 
    xern1_), 511), $28_), ($29_ = 6, &$29_), &_k1);
    (*idid_) = -33;
  }
  nrtolp_ = 0;
  natolp_ = 0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    if (nrtolp_ == 0 && rtol_[k_ - 1] < 0.0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:144", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100053_[__fcnt] != NULL && $f_100053_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100053_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:144", 0));
        __fcnt += 3;
      }
      if ($f_100053_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100053_[__fcnt] != NULL && $f_100053_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100053_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:144", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100053_[__fcnt + 2], &k_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:144", 0));
      __fcnt += 3;
      while ($f_100053_[__fcnt] != NULL && $f_100053_[__fcnt] == FMT_TEXT) {
        if ($f_100053_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100053_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:144", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:145", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100054_[__fcnt] != NULL && $f_100054_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100054_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:145", 0));
        __fcnt += 3;
      }
      if ($f_100054_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100054_[__fcnt] != NULL && $f_100054_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100054_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:145", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100054_[__fcnt + 2], &rtol_[k_ - 1], REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:145", 0));
      __fcnt += 3;
      while ($f_100054_[__fcnt] != NULL && $f_100054_[__fcnt] == FMT_TEXT) {
        if ($f_100054_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100054_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:145", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_252, (bufcpy ($37_, concat ($36_, concat ($35_, concat ($34_, concat ($33_, concat ($32_, 
      concat ($31_, concat ($30_, _dc_266, _dc_232), _dc_233), xern1_), _dc_64), xern3_), _dc_179), _dc_180), 4095), $37_), 
      ($38_ = 7, &$38_), &_k1);
      (*idid_) = -33;
      nrtolp_ = 1;
    }
    if (natolp_ == 0 && atol_[k_ - 1] < 0.0) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:157", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100060_[__fcnt] != NULL && $f_100060_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100060_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:157", 0));
        __fcnt += 3;
      }
      if ($f_100060_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100060_[__fcnt] != NULL && $f_100060_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100060_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:157", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100060_[__fcnt + 2], &k_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:157", 0));
      __fcnt += 3;
      while ($f_100060_[__fcnt] != NULL && $f_100060_[__fcnt] == FMT_TEXT) {
        if ($f_100060_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100060_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:157", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:158", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:158", 0));
        __fcnt += 3;
      }
      if ($f_100061_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:158", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100061_[__fcnt + 2], &atol_[k_ - 1], REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:158", 0));
      __fcnt += 3;
      while ($f_100061_[__fcnt] != NULL && $f_100061_[__fcnt] == FMT_TEXT) {
        if ($f_100061_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100061_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:158", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_252, (bufcpy ($46_, concat ($45_, concat ($44_, concat ($43_, concat ($42_, concat ($41_, 
      concat ($40_, concat ($39_, _dc_267, _dc_235), _dc_236), xern1_), _dc_64), xern3_), _dc_179), _dc_184), 4095), $46_), 
      ($47_ = 8, &$47_), &_k1);
      (*idid_) = -33;
      natolp_ = 1;
    }
    if (info_[1] == 0) {
      goto _l100;
    }
    if (natolp_ > 0 && nrtolp_ > 0) {
      goto _l100;
    }
  }
  _l100:;
  if (info_[3] == 1) {
    if (_sign (1.0, (*tout_) - (*t_)) != _sign (1.0, (*tstop_) - (*t_)) || _abs ((*tout_) - (*t_)) > _abs ((*tstop_) - 
      (*t_))) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:176", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100071_[__fcnt] != NULL && $f_100071_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100071_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:176", 0));
        __fcnt += 3;
      }
      if ($f_100071_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100071_[__fcnt] != NULL && $f_100071_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100071_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:176", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100071_[__fcnt + 2], &(*tout_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:176", 0));
      __fcnt += 3;
      while ($f_100071_[__fcnt] != NULL && $f_100071_[__fcnt] == FMT_TEXT) {
        if ($f_100071_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100071_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:176", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern4_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:177", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100072_[__fcnt] != NULL && $f_100072_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100072_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:177", 0));
        __fcnt += 3;
      }
      if ($f_100072_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100072_[__fcnt] != NULL && $f_100072_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100072_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:177", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100072_[__fcnt + 2], &(*tstop_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:177", 0));
      __fcnt += 3;
      while ($f_100072_[__fcnt] != NULL && $f_100072_[__fcnt] == FMT_TEXT) {
        if ($f_100072_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100072_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:177", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_252, (bufcpy ($56_, concat ($55_, concat ($54_, concat ($53_, concat ($52_, concat ($51_, 
      concat ($50_, concat ($49_, concat ($48_, _dc_268, _dc_269), xern3_), _dc_270), _dc_271), _dc_272), xern4_), _dc_273), 
      _dc_274), 4095), $56_), ($57_ = 14, &$57_), &_k1);
      (*idid_) = -33;
    }
  }
  if ((*init_) != 0) {
    if ((*t_) == (*tout_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:192", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100079_[__fcnt] != NULL && $f_100079_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100079_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:192", 0));
        __fcnt += 3;
      }
      if ($f_100079_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100079_[__fcnt] != NULL && $f_100079_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100079_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:192", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100079_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:192", 0));
      __fcnt += 3;
      while ($f_100079_[__fcnt] != NULL && $f_100079_[__fcnt] == FMT_TEXT) {
        if ($f_100079_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100079_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:192", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_252, (bufcpy ($62_, concat ($61_, concat ($60_, concat ($59_, concat ($58_, _dc_268, 
      _dc_238), xern3_), _dc_239), _dc_240), 511), $62_), ($63_ = 9, &$63_), &_k1);
      (*idid_) = -33;
    }
    if ((*t_) != (*told_)) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern3_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:201", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100084_[__fcnt] != NULL && $f_100084_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100084_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:201", 0));
        __fcnt += 3;
      }
      if ($f_100084_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100084_[__fcnt] != NULL && $f_100084_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100084_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:201", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100084_[__fcnt + 2], &(*told_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:201", 0));
      __fcnt += 3;
      while ($f_100084_[__fcnt] != NULL && $f_100084_[__fcnt] == FMT_TEXT) {
        if ($f_100084_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100084_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:201", 0));
        __fcnt += 3;
      }
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
      _ffile[0].lrecl = 31;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern4_, 31, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:des:202", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100085_[__fcnt] != NULL && $f_100085_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100085_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:202", 0));
        __fcnt += 3;
      }
      if ($f_100085_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100085_[__fcnt] != NULL && $f_100085_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100085_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:202", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100085_[__fcnt + 2], &(*t_), REAL, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:des:202", 0));
      __fcnt += 3;
      while ($f_100085_[__fcnt] != NULL && $f_100085_[__fcnt] == FMT_TEXT) {
        if ($f_100085_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100085_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:202", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_252, (bufcpy ($69_, concat ($68_, concat ($67_, concat ($66_, concat ($65_, concat ($64_, 
      _dc_275, _dc_242), xern3_), _dc_194), xern4_), _dc_195), 1023), $69_), ($70_ = 10, &$70_), &_k1);
      (*idid_) = -33;
    }
    if ((*init_) != 1) {
      if ((*delsgn_) * ((*tout_) - (*t_)) < 0.0) {
        _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
        _ffile[0].lrecl = 31;
        _ffile[0].record = 0;
        _ffile[0].records = 1;
        _ffile[0].unit = fmemopen (xern3_, 31, "w");
        _ffile[0].buff_init = FALSE;
        _fcheck ("slatec:des:212", 0, action_write, form_formatted);
        __fcnt = 0;
        while ($f_100091_[__fcnt] != NULL && $f_100091_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100091_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:212", 0));
          __fcnt += 3;
        }
        if ($f_100091_[__fcnt] == NULL) {
          __fcnt = 0;
          __rc = fprintf (_ffile[0].unit, "\n");
          while ($f_100091_[__fcnt] != NULL && $f_100091_[__fcnt] == FMT_TEXT) {
            __rc = _vif_printf (0, $f_100091_[__fcnt + 2], NULL, NOTYPE, 0);
            _write_err (__rc, 0, _ioerr_write ("slatec:des:212", 0));
            __fcnt += 3;
          }
        };
        __rc = _vif_printf (0, $f_100091_[__fcnt + 2], &(*tout_), REAL, 4);
        _write_err (__rc, 0, _ioerr_write ("slatec:des:212", 0));
        __fcnt += 3;
        while ($f_100091_[__fcnt] != NULL && $f_100091_[__fcnt] == FMT_TEXT) {
          if ($f_100091_[__fcnt + 2] == FMT_TERM) {
            break;
          }
          __rc = _vif_printf (0, $f_100091_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:des:212", 0));
          __fcnt += 3;
        }
        (void) _xermsg (_dc_1, _dc_252, (bufcpy ($77_, concat ($76_, concat ($75_, concat ($74_, concat ($73_, concat ($72_, 
        concat ($71_, _dc_276, _dc_277), xern3_), _dc_278), _dc_279), _dc_199), _dc_200), 2047), $77_), ($78_ = 11, &$78_), 
        &_k1);
        (*idid_) = -33;
      }
    }
  }
  if ((*idid_) == -33) {
    if ((*iquit_) != -33) {
      (*iquit_) = -33;
      info_[0] = -1;
    }
    else {
      (void) _xermsg (_dc_1, _dc_252, concat ($81_, concat ($80_, concat ($79_, _dc_280, _dc_249), _dc_250), _dc_251), ($82_ 
      = 12, &$82_), ($83_ = 2, &$83_));
    }
    goto _l0;
  }
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    if (rtol_[k_ - 1] + atol_[k_ - 1] > 0.0) {
      goto _l170;
    }
    rtol_[k_ - 1] = (*fouru_);
    (*idid_) = -2;
    _l170:;
    if (info_[1] == 0) {
      goto _l190;
    }
  }
  _l190:;
  if ((*idid_) != -2) {
    goto _l200;
  }
  info_[0] = -1;
  goto _l0;
  _l200:;
  if ((*init_) == 0) {
    goto _l210;
  }
  if ((*init_) == 1) {
    goto _l220;
  }
  goto _l240;
  _l210:;
  (*init_) = 1;
  a_ = (*t_);
  (void) _f (&a_, y_, yp_, rpar_, ipar_);
  if ((*t_) != (*tout_)) {
    goto _l220;
  }
  (*idid_) = 2;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*told_) = (*t_);
  goto _l0;
  _l220:;
  (*init_) = 2;
  (*x_) = (*t_);
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    yy_[l_ - 1] = y_[l_ - 1];
  }
  (*delsgn_) = _sign (1.0, (*tout_) - (*t_));
  (*h_) = _sign (_max ((*fouru_) * _abs ((*x_)), _abs ((*tout_) - (*x_))), (*tout_) - (*x_));
  _l240:;
  del_ = (*tout_) - (*t_);
  absdel_ = _abs (del_);
  _l250:;
  if (_abs ((*x_) - (*t_)) < absdel_) {
    goto _l260;
  }
  (void) _sintrp (x_, yy_, tout_, y_, ypout_, neq_, kold_, phi_, ivc_, iv_, kgi_, gi_, alpha_, g_, w_, xold_, p_);
  (*idid_) = 3;
  if ((*x_) != (*tout_)) {
    goto _l255;
  }
  (*idid_) = 2;
  (*intout_) = FALSE;
  _l255:;
  (*t_) = (*tout_);
  (*told_) = (*t_);
  goto _l0;
  _l260:;
  if (info_[3] != 1) {
    goto _l280;
  }
  if (_abs ((*tstop_) - (*x_)) >= (*fouru_) * _abs ((*x_))) {
    goto _l280;
  }
  dt_ = (*tout_) - (*x_);
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1] + dt_ * yp_[l_ - 1];
  }
  (void) _f (tout_, y_, ypout_, rpar_, ipar_);
  (*idid_) = 3;
  (*t_) = (*tout_);
  (*told_) = (*t_);
  goto _l0;
  _l280:;
  if (info_[2] == 0 || ! ((*intout_))) {
    goto _l300;
  }
  (*idid_) = 1;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1];
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*t_) = (*x_);
  (*told_) = (*t_);
  (*intout_) = FALSE;
  goto _l0;
  _l300:;
  if ((*ksteps_) <= maxnum_) {
    goto _l330;
  }
  (*idid_) = -1;
  (*ksteps_) = 0;
  if (! ((*stiff_))) {
    goto _l310;
  }
  (*idid_) = -4;
  (*stiff_) = FALSE;
  (*kle4_) = 0;
  _l310:;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1];
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*t_) = (*x_);
  (*told_) = (*t_);
  info_[0] = -1;
  (*intout_) = FALSE;
  goto _l0;
  _l330:;
  ha_ = _abs ((*h_));
  if (info_[3] != 1) {
    goto _l340;
  }
  ha_ = _min (ha_, _abs ((*tstop_) - (*x_)));
  _l340:;
  (*h_) = _sign (ha_, (*h_));
  (*eps_) = 1.0;
  ltol_ = 1;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    if (info_[1] == 1) {
      ltol_ = l_;
    }
    wt_[l_ - 1] = rtol_[ltol_ - 1] * _abs (yy_[l_ - 1]) + atol_[ltol_ - 1];
    if (wt_[l_ - 1] <= 0.0) {
      goto _l360;
    }
  }
  goto _l380;
  _l360:;
  (*idid_) = -3;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1];
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*t_) = (*x_);
  (*told_) = (*t_);
  info_[0] = -1;
  (*intout_) = FALSE;
  goto _l0;
  _l380:;
  (void) _steps (_f, neq_, yy_, x_, h_, eps_, wt_, start_, hold_, kord_, kold_, &crash_, phi_, p_, yp_, psi_, alpha_, 
  beta_, sig_, v_, w_, g_, phase1_, ns_, nornd_, ksteps_, twou_, fouru_, xold_, kprev_, ivc_, iv_, kgi_, gi_, rpar_, 
  ipar_);
  if (! (crash_)) {
    goto _l420;
  }
  (*idid_) = -2;
  rtol_[0] = (*eps_) * rtol_[0];
  atol_[0] = (*eps_) * atol_[0];
  if (info_[1] == 0) {
    goto _l400;
  }
  for (l_ = 2; l_ <= (*neq_); (l_)++) {
    rtol_[l_ - 1] = (*eps_) * rtol_[l_ - 1];
    atol_[l_ - 1] = (*eps_) * atol_[l_ - 1];
  }
  _l400:;
  for (l_ = 1; l_ <= (*neq_); (l_)++) {
    y_[l_ - 1] = yy_[l_ - 1];
    ypout_[l_ - 1] = yp_[l_ - 1];
  }
  (*t_) = (*x_);
  (*told_) = (*t_);
  info_[0] = -1;
  (*intout_) = FALSE;
  goto _l0;
  _l420:;
  (*kle4_) = (*kle4_) + 1;
  if ((*kold_) > 4) {
    (*kle4_) = 0;
  }
  if ((*kle4_) >= 50) {
    (*stiff_) = TRUE;
  }
  (*intout_) = TRUE;
  goto _l250;
  _l0:;
  __calls[87].calls++;
  return 0;
}

int_4 _dfcmn (int_4 _p_ ndata_, real_8 _p_ xdata_, real_8 _p_ ydata_, real_8 _p_ sddata_, int_4 _p_ nord_, int_4 _p_ 
nbkpt_, real_8 _p_ bkptin_, int_4 _p_ nconst_, real_8 _p_ xconst_, real_8 _p_ yconst_, int_4 _p_ nderiv_, int_4 _p_ 
mode_, real_8 _p_ coeff_, real_8 _p_ bf_, real_8 _p_ xtemp_, real_8 _p_ ptemp_, real_8 _p_ bkpt_, real_8 _p_ g_, int_4 
_p_ mdg_, real_8 _p_ w_, int_4 _p_ mdw_, real_8 _p_ work_, int_4 _p_ iwork_)
{
  static int_4 i_, idata_, ideriv_, ileft_, intrvl_, intw1_, ip_, ir_, irow_, itype_, iw1_, iw2_, l_, lw_, mt_, n_, nb_, 
  neqcon_, nincon_, nordm1_, nordp1_, np1_;
  static logical_4 band_, new_, var_;
  static real_8 dummy_, prgopt_[10], rnorm_, rnorme_, rnorml_, xmax_, xmin_, xval_, yval_;
  static char_15 xern1_;
  int_4 $0_, $2_, $3_, __fcnt, __rc, $6_, $7_, $8_, $9_, $11_, $12_, $16_, $19_, $20_, $22_, $25_, $26_;
  real_8 $10_, $13_, $21_, $23_, $24_, $27_, $28_;
  char_127 $1_, $4_, $5_, $14_, $15_, $17_, $18_;
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern int_4 _dscal ();
  extern int_4 _xermsg ();
  static FORMAT $f_100027_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100150_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100156_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*nord_) < 1 || (*nord_) > 20) {
    (void) _xermsg (_dc_1, _dc_281, _dc_282, ($0_ = 2, &$0_), &_k1);
    (*mode_) = -1;
    goto _l0;
  }
  else if ((*nbkpt_) < 2 * (*nord_)) {
    (void) _xermsg (_dc_1, _dc_281, concat ($1_, _dc_283, _dc_209), ($2_ = 2, &$2_), &_k1);
    (*mode_) = -1;
    goto _l0;
  }
  if ((*ndata_) < 0) {
    (void) _xermsg (_dc_1, _dc_281, _dc_284, ($3_ = 2, &$3_), &_k1);
    (*mode_) = -1;
    goto _l0;
  }
  iw1_ = iwork_[0];
  iw2_ = iwork_[1];
  nb_ = ((*nbkpt_) - (*nord_) + 3) * ((*nord_) + 1) + 2 * _max ((*ndata_), (*nbkpt_)) + (*nbkpt_) + ((*nord_) * (*nord_))
  ;
  if (iw1_ < nb_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dfcmn:83", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:83", 0));
      __fcnt += 3;
    }
    if ($f_100027_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:83", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100027_[__fcnt + 2], &nb_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:83", 0));
    __fcnt += 3;
    while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
      if ($f_100027_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:83", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_281, (bufcpy ($5_, concat ($4_, _dc_285, xern1_), 127), $5_), ($6_ = 2, &$6_), &_k1);
    (*mode_) = -1;
    goto _l0;
  }
  if ((*mode_) == 1) {
    band_ = TRUE;
    var_ = FALSE;
    new_ = TRUE;
  }
  else if ((*mode_) == 2) {
    band_ = FALSE;
    var_ = TRUE;
    new_ = TRUE;
  }
  else if ((*mode_) == 3) {
    band_ = TRUE;
    var_ = FALSE;
    new_ = FALSE;
  }
  else if ((*mode_) == 4) {
    band_ = FALSE;
    var_ = TRUE;
    new_ = FALSE;
  }
  else {
    (void) _xermsg (_dc_1, _dc_281, _dc_286, ($7_ = 2, &$7_), &_k1);
    (*mode_) = -1;
    goto _l0;
  }
  (*mode_) = 0;
  (void) _dcopy (nbkpt_, bkptin_, &_k1, bkpt_, &_k1);
  (void) _dsort (bkpt_, &dummy_, nbkpt_, &_k1);
  neqcon_ = 0;
  nincon_ = 0;
  for (i_ = 1; i_ <= (*nconst_); (i_)++) {
    l_ = nderiv_[i_ - 1];
    itype_ = _imod (l_, 4);
    if (itype_ < 2) {
      nincon_ = nincon_ + 1;
    }
    else {
      neqcon_ = neqcon_ + 1;
    }
  }
  n_ = (*nbkpt_) - (*nord_);
  np1_ = n_ + 1;
  lw_ = nb_ + (np1_ + (*nconst_)) * np1_ + 2 * (neqcon_ + np1_) + (nincon_ + np1_) + (nincon_ + 2) * (np1_ + 6);
  intw1_ = nincon_ + 2 * np1_;
  xmin_ = bkpt_[(*nord_) - 1];
  xmax_ = bkpt_[np1_ - 1];
  for (i_ = 1; i_ <= (*nconst_); (i_)++) {
    xmin_ = _min (xmin_, xconst_[i_ - 1]);
    xmax_ = _max (xmax_, xconst_[i_ - 1]);
  }
  nordm1_ = (*nord_) - 1;
  nordp1_ = (*nord_) + 1;
  prgopt_[0] = 4;
  prgopt_[1] = 1;
  if (var_) {
    prgopt_[2] = 1;
  }
  else {
    prgopt_[2] = 0;
  }
  prgopt_[3] = 7;
  prgopt_[4] = 4;
  prgopt_[5] = 1.0e-4;
  prgopt_[6] = 10;
  prgopt_[7] = 5;
  prgopt_[8] = 1.0e-4;
  prgopt_[9] = 1;
  iwork_[0] = 0;
  iwork_[1] = 0;
  if (new_) {
    (void) _dcopy (ndata_, xdata_, &_k1, xtemp_, &_k1);
    for (i_ = 1; i_ <= (*ndata_); (i_)++) {
      ptemp_[i_ - 1] = i_;
    }
    if ((*ndata_) > 0) {
      (void) _dsort (xtemp_, ptemp_, ndata_, ($8_ = 2, &$8_));
      xmin_ = _min (xmin_, xtemp_[0]);
      xmax_ = _max (xmax_, xtemp_[(*ndata_) - 1]);
    }
    for (i_ = 1; i_ <= (*nord_); (i_)++) {
      bkpt_[i_ - 1] = _min (bkpt_[i_ - 1], xmin_);
    }
    for (i_ = np1_; i_ <= (*nbkpt_); (i_)++) {
      bkpt_[i_ - 1] = _max (bkpt_[i_ - 1], xmax_);
    }
    mt_ = 0;
    ip_ = 1;
    ir_ = 1;
    ileft_ = (*nord_);
    for (idata_ = 1; idata_ <= (*ndata_); (idata_)++) {
      l_ = ptemp_[idata_ - 1];
      xval_ = xdata_[l_ - 1];
      if (xval_ >= bkpt_[ileft_ + 1 - 1]) {
        (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &mt_, ($9_ = ileft_ - nordm1_, &$9_));
        mt_ = 0;
        _l150:;
        if (xval_ >= bkpt_[ileft_ + 1 - 1] && ileft_ < n_) {
          ileft_ = ileft_ + 1;
          goto _l150;
        }
      }
      (void) _dfspvn (bkpt_, nord_, &_k1, &xval_, &ileft_, bf_);
      irow_ = ir_ + mt_;
      mt_ = mt_ + 1;
      (void) _dcopy (nord_, bf_, &_k1, &g_[irow_ - 1 + ((*mdg_)) * ((0))], mdg_);
      g_[irow_ - 1 + ((*mdg_)) * ((nordp1_ - 1))] = ydata_[l_ - 1];
      if (sddata_[l_ - 1] != 0.0e0) {
        (void) _dscal (&nordp1_, ($10_ = 1.0e0 / sddata_[l_ - 1], &$10_), &g_[irow_ - 1 + ((*mdg_)) * ((0))], mdg_);
      }
      if (irow_ == (*mdg_) - 1) {
        (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &mt_, ($11_ = ileft_ - nordm1_, &$11_));
        mt_ = 0;
      }
    }
    (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &mt_, ($12_ = ileft_ - nordm1_, &$12_));
    (void) _dcopy (&nordp1_, ($13_ = 0.0, &$13_), &_k0, &g_[ir_ - 1 + ((*mdg_)) * ((0))], mdg_);
    (void) _dbndac (g_, mdg_, nord_, &ip_, &ir_, &_k1, &np1_);
  }
  band_ = band_ && (*nconst_) == 0;
  for (i_ = 1; i_ <= n_; (i_)++) {
    band_ = band_ && g_[i_ - 1 + ((*mdg_)) * ((0))] != 0.0e0;
  }
  if (band_) {
    (void) _dbndsl (&_k1, g_, mdg_, nord_, &ip_, &ir_, coeff_, &n_, &rnorm_);
    goto _l0;
  }
  if (iw1_ < lw_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dfcmn:293", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100150_[__fcnt] != NULL && $f_100150_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100150_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:293", 0));
      __fcnt += 3;
    }
    if ($f_100150_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100150_[__fcnt] != NULL && $f_100150_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100150_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:293", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100150_[__fcnt + 2], &lw_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:293", 0));
    __fcnt += 3;
    while ($f_100150_[__fcnt] != NULL && $f_100150_[__fcnt] == FMT_TEXT) {
      if ($f_100150_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100150_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:293", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_281, (bufcpy ($15_, concat ($14_, _dc_287, xern1_), 127), $15_), ($16_ = 2, &$16_), &_k1);
    (*mode_) = -1;
    goto _l0;
  }
  if (iw2_ < intw1_) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dfcmn:302", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:302", 0));
      __fcnt += 3;
    }
    if ($f_100156_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:302", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100156_[__fcnt + 2], &intw1_, INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:302", 0));
    __fcnt += 3;
    while ($f_100156_[__fcnt] != NULL && $f_100156_[__fcnt] == FMT_TEXT) {
      if ($f_100156_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100156_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dfcmn:302", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_281, (bufcpy ($18_, concat ($17_, _dc_288, xern1_), 127), $18_), ($19_ = 2, &$19_), &_k1);
    (*mode_) = -1;
    goto _l0;
  }
  neqcon_ = 0;
  for (idata_ = 1; idata_ <= (*nconst_); (idata_)++) {
    l_ = nderiv_[idata_ - 1];
    itype_ = _imod (l_, 4);
    if (itype_ > 1) {
      ideriv_ = l_ / 4;
      neqcon_ = neqcon_ + 1;
      ileft_ = (*nord_);
      xval_ = xconst_[idata_ - 1];
      _l180:;
      if (xval_ < bkpt_[ileft_ + 1 - 1] || ileft_ >= n_) {
        goto _l190;
      }
      ileft_ = ileft_ + 1;
      goto _l180;
      _l190:;
      (void) _dfspvd (bkpt_, nord_, &xval_, &ileft_, bf_, ($20_ = ideriv_ + 1, &$20_));
      (void) _dcopy (&np1_, ($21_ = 0.0, &$21_), &_k0, &w_[neqcon_ - 1 + ((*mdw_)) * ((0))], mdw_);
      (void) _dcopy (nord_, &bf_[0 + ((*nord_)) * ((ideriv_ + 1 - 1))], &_k1, &w_[neqcon_ - 1 + ((*mdw_)) * ((ileft_ - 
      nordm1_ - 1))], mdw_);
      if (itype_ == 2) {
        w_[neqcon_ - 1 + ((*mdw_)) * ((np1_ - 1))] = yconst_[idata_ - 1];
      }
      else {
        ileft_ = (*nord_);
        yval_ = yconst_[idata_ - 1];
        _l200:;
        if (yval_ < bkpt_[ileft_ + 1 - 1] || ileft_ >= n_) {
          goto _l210;
        }
        ileft_ = ileft_ + 1;
        goto _l200;
        _l210:;
        (void) _dfspvd (bkpt_, nord_, &yval_, &ileft_, bf_, ($22_ = ideriv_ + 1, &$22_));
        (void) _daxpy (nord_, ($23_ = -1.0, &$23_), &bf_[0 + ((*nord_)) * ((ideriv_ + 1 - 1))], &_k1, &w_[neqcon_ - 1 + 
        ((*mdw_)) * ((ileft_ - nordm1_ - 1))], mdw_);
      }
    }
  }
  for (i_ = 1; i_ <= np1_; (i_)++) {
    irow_ = i_ + neqcon_;
    (void) _dcopy (&n_, ($24_ = 0.0, &$24_), &_k0, &w_[irow_ - 1 + ((*mdw_)) * ((0))], mdw_);
    (void) _dcopy (($25_ = _min (np1_ - i_, (*nord_)), &$25_), &g_[i_ - 1 + ((*mdg_)) * ((0))], mdg_, &w_[irow_ - 1 + 
    ((*mdw_)) * ((i_ - 1))], mdw_);
    w_[irow_ - 1 + ((*mdw_)) * ((np1_ - 1))] = g_[i_ - 1 + ((*mdg_)) * ((nordp1_ - 1))];
  }
  nincon_ = 0;
  for (idata_ = 1; idata_ <= (*nconst_); (idata_)++) {
    l_ = nderiv_[idata_ - 1];
    itype_ = _imod (l_, 4);
    if (itype_ < 2) {
      ideriv_ = l_ / 4;
      nincon_ = nincon_ + 1;
      ileft_ = (*nord_);
      xval_ = xconst_[idata_ - 1];
      _l240:;
      if (xval_ < bkpt_[ileft_ + 1 - 1] || ileft_ >= n_) {
        goto _l250;
      }
      ileft_ = ileft_ + 1;
      goto _l240;
      _l250:;
      (void) _dfspvd (bkpt_, nord_, &xval_, &ileft_, bf_, ($26_ = ideriv_ + 1, &$26_));
      irow_ = neqcon_ + np1_ + nincon_;
      (void) _dcopy (&n_, ($27_ = 0.0, &$27_), &_k0, &w_[irow_ - 1 + ((*mdw_)) * ((0))], mdw_);
      intrvl_ = ileft_ - nordm1_;
      (void) _dcopy (nord_, &bf_[0 + ((*nord_)) * ((ideriv_ + 1 - 1))], &_k1, &w_[irow_ - 1 + ((*mdw_)) * ((intrvl_ - 1))], 
      mdw_);
      if (itype_ == 1) {
        w_[irow_ - 1 + ((*mdw_)) * ((np1_ - 1))] = yconst_[idata_ - 1];
      }
      else {
        w_[irow_ - 1 + ((*mdw_)) * ((np1_ - 1))] = -yconst_[idata_ - 1];
        (void) _dscal (nord_, ($28_ = -1.0, &$28_), &w_[irow_ - 1 + ((*mdw_)) * ((intrvl_ - 1))], mdw_);
      }
    }
  }
  (void) _dlsei (w_, mdw_, &neqcon_, &np1_, &nincon_, &n_, prgopt_, coeff_, &rnorme_, &rnorml_, mode_, work_, iwork_);
  _l0:;
  __calls[88].calls++;
  return 0;
}

int_4 _dfdjc1 (int_4 (*_fcn)(), int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 _p_ ldfjac_, 
int_4 _p_ iflag_, int_4 _p_ ml_, int_4 _p_ mu_, real_8 _p_ epsfcn_, real_8 _p_ wa1_, real_8 _p_ wa2_)
{
  static int_4 i_, j_, k_, msum_;
  static real_8 eps_, epsmch_, h_, temp_, zero_;
  int_4 _data_k_98, $0_;
  extern real_8 _d1mach ();
#define _data_n_98 1
  static real_8 _data_l_98[_data_n_98] = {
    0.0e0
  };
  if (__calls[89].calls == 0) {
    _data_k_98 = 0;
    if (_data_k_98 >= _data_n_98) {
      _data_k_98 = 0;
    }
    zero_ = _data_l_98[_data_k_98++];
  }
  epsmch_ = _d1mach (($0_ = 4, &$0_));
  eps_ = sqrt (_max ((*epsfcn_), epsmch_));
  msum_ = (*ml_) + (*mu_) + 1;
  if (msum_ < (*n_)) {
    goto _l40;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = x_[j_ - 1];
    h_ = eps_ * _abs (temp_);
    if (h_ == zero_) {
      h_ = eps_;
    }
    x_[j_ - 1] = temp_ + h_;
    (void) _fcn (n_, x_, wa1_, iflag_);
    if ((*iflag_) < 0) {
      goto _l30;
    }
    x_[j_ - 1] = temp_;
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = (wa1_[i_ - 1] - fvec_[i_ - 1]) / h_;
    }
  }
  _l30:;
  goto _l110;
  _l40:;
  for (k_ = 1; k_ <= msum_; (k_)++) {
    for (j_ = k_; (msum_ > 0 ? j_ <= (*n_) : j_ >= (*n_)); j_ += msum_) {
      wa2_[j_ - 1] = x_[j_ - 1];
      h_ = eps_ * _abs (wa2_[j_ - 1]);
      if (h_ == zero_) {
        h_ = eps_;
      }
      x_[j_ - 1] = wa2_[j_ - 1] + h_;
    }
    (void) _fcn (n_, x_, wa1_, iflag_);
    if ((*iflag_) < 0) {
      goto _l100;
    }
    for (j_ = k_; (msum_ > 0 ? j_ <= (*n_) : j_ >= (*n_)); j_ += msum_) {
      x_[j_ - 1] = wa2_[j_ - 1];
      h_ = eps_ * _abs (wa2_[j_ - 1]);
      if (h_ == zero_) {
        h_ = eps_;
      }
      for (i_ = 1; i_ <= (*n_); (i_)++) {
        fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = zero_;
        if (i_ >= j_ - (*mu_) && i_ <= j_ + (*ml_)) {
          fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = (wa1_[i_ - 1] - fvec_[i_ - 1]) / h_;
        }
      }
    }
  }
  _l100:;
  _l110:;
  __calls[89].calls++;
  return 0;
}

int_4 _dfdjc3 (int_4 (*_fcn)(), int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ x_, real_8 _p_ fvec_, real_8 _p_ fjac_, int_4 
_p_ ldfjac_, int_4 _p_ iflag_, real_8 _p_ epsfcn_, real_8 _p_ wa_)
{
  static int_4 i_, j_;
  static real_8 eps_, epsmch_, h_, temp_, zero_;
  int_4 _data_k_99, $0_;
  extern real_8 _d1mach ();
#define _data_n_99 1
  static real_8 _data_l_99[_data_n_99] = {
    0.0e0
  };
  if (__calls[90].calls == 0) {
    _data_k_99 = 0;
    if (_data_k_99 >= _data_n_99) {
      _data_k_99 = 0;
    }
    zero_ = _data_l_99[_data_k_99++];
  }
  epsmch_ = _d1mach (($0_ = 4, &$0_));
  eps_ = sqrt (_max ((*epsfcn_), epsmch_));
  (*iflag_) = 1;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    temp_ = x_[j_ - 1];
    h_ = eps_ * _abs (temp_);
    if (h_ == zero_) {
      h_ = eps_;
    }
    x_[j_ - 1] = temp_ + h_;
    (void) _fcn (iflag_, m_, n_, x_, wa_, fjac_, ldfjac_);
    if ((*iflag_) < 0) {
      goto _l30;
    }
    x_[j_ - 1] = temp_;
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      fjac_[i_ - 1 + ((*ldfjac_)) * ((j_ - 1))] = (wa_[i_ - 1] - fvec_[i_ - 1]) / h_;
    }
  }
  _l30:;
  __calls[90].calls++;
  return 0;
}

int_4 _dfehl (int_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ t_, real_8 _p_ y_, real_8 _p_ h_, real_8 _p_ yp_, real_8 _p_ 
f1_, real_8 _p_ f2_, real_8 _p_ f3_, real_8 _p_ f4_, real_8 _p_ f5_, real_8 _p_ ys_, real_8 _p_ rpar_, int_4 _p_ ipar_)
{
  static int_4 k_;
  static real_8 ch_;
  real_8 $0_, $1_, $2_, $3_, $4_;
  ch_ = (*h_) / 4.0e0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * yp_[k_ - 1];
  }
  (void) _df (($0_ = (*t_) + ch_, &$0_), ys_, f1_, rpar_, ipar_);
  ch_ = 3.0e0 * (*h_) / 32.0e0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * (yp_[k_ - 1] + 3.0e0 * f1_[k_ - 1]);
  }
  (void) _df (($1_ = (*t_) + 3.0e0 * (*h_) / 8.0e0, &$1_), ys_, f2_, rpar_, ipar_);
  ch_ = (*h_) / 2197.0e0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * (1932.0e0 * yp_[k_ - 1] + (7296.0e0 * f2_[k_ - 1] - 7200.0e0 * f1_[k_ - 1]));
  }
  (void) _df (($2_ = (*t_) + 12.0e0 * (*h_) / 13.0e0, &$2_), ys_, f3_, rpar_, ipar_);
  ch_ = (*h_) / 4104.0e0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * ((8341.0e0 * yp_[k_ - 1] - 845.0e0 * f3_[k_ - 1]) + (29440.0e0 * f2_[k_ - 1] - 
    32832.0e0 * f1_[k_ - 1]));
  }
  (void) _df (($3_ = (*t_) + (*h_), &$3_), ys_, f4_, rpar_, ipar_);
  ch_ = (*h_) / 20520.0e0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * ((-6080.0e0 * yp_[k_ - 1] + (9295.0e0 * f3_[k_ - 1] - 5643.0e0 * f4_[k_ - 1])) + 
    (41040.0e0 * f1_[k_ - 1] - 28352.0e0 * f2_[k_ - 1]));
  }
  (void) _df (($4_ = (*t_) + (*h_) / 2.0e0, &$4_), ys_, f5_, rpar_, ipar_);
  ch_ = (*h_) / 7618050.0e0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    ys_[k_ - 1] = y_[k_ - 1] + ch_ * ((902880.0e0 * yp_[k_ - 1] + (3855735.0e0 * f3_[k_ - 1] - 1371249.0e0 * f4_[k_ - 1])) 
    + (3953664.0e0 * f2_[k_ - 1] + 277020.0e0 * f5_[k_ - 1]));
  }
  __calls[91].calls++;
  return 0;
}

int_4 _dfspvd (real_8 _p_ t_, int_4 _p_ k_, real_8 _p_ x_, int_4 _p_ ileft_, real_8 _p_ vnikx_, int_4 _p_ nderiv_)
{
  static int_4 ideriv_, i_, idervm_, j_, kmd_, m_, jm1_, ipkmd_, l_, jlow_;
  static real_8 a_[400], fkmd_, diff_, v_;
  int_4 $0_, $1_;
  (void) _dfspvn (t_, ($0_ = (*k_) + 1 - (*nderiv_), &$0_), &_k1, x_, ileft_, &vnikx_[(*nderiv_) - 1 + ((*k_)) * 
  (((*nderiv_) - 1))]);
  if ((*nderiv_) <= 1) {
    goto _l99;
  }
  ideriv_ = (*nderiv_);
  for (i_ = 2; i_ <= (*nderiv_); (i_)++) {
    idervm_ = ideriv_ - 1;
    for (j_ = ideriv_; j_ <= (*k_); (j_)++) {
      vnikx_[j_ - 1 - 1 + ((*k_)) * ((idervm_ - 1))] = vnikx_[j_ - 1 + ((*k_)) * ((ideriv_ - 1))];
    }
    ideriv_ = idervm_;
    (void) _dfspvn (t_, &_k0, ($1_ = 2, &$1_), x_, ileft_, &vnikx_[ideriv_ - 1 + ((*k_)) * ((ideriv_ - 1))]);
  }
  for (i_ = 1; i_ <= (*k_); (i_)++) {
    for (j_ = 1; j_ <= (*k_); (j_)++) {
      a_[i_ - 1 + (20) * ((j_ - 1))] = 0.0;
    }
    a_[i_ - 1 + (20) * ((i_ - 1))] = 1.0;
  }
  kmd_ = (*k_);
  for (m_ = 2; m_ <= (*nderiv_); (m_)++) {
    kmd_ = kmd_ - 1;
    fkmd_ = kmd_;
    i_ = (*ileft_);
    j_ = (*k_);
    _l21:;
    jm1_ = j_ - 1;
    ipkmd_ = i_ + kmd_;
    diff_ = t_[ipkmd_ - 1] - t_[i_ - 1];
    if (jm1_ == 0) {
      goto _l26;
    }
    if (diff_ == 0.0e0) {
      goto _l25;
    }
    for (l_ = 1; l_ <= j_; (l_)++) {
      a_[l_ - 1 + (20) * ((j_ - 1))] = (a_[l_ - 1 + (20) * ((j_ - 1))] - a_[l_ - 1 + (20) * ((j_ - 1 - 1))]) / diff_ * fkmd_
      ;
    }
    _l25:;
    j_ = jm1_;
    i_ = i_ - 1;
    goto _l21;
    _l26:;
    if (diff_ == 0.0) {
      goto _l30;
    }
    a_[0] = a_[0] / diff_ * fkmd_;
    _l30:;
    for (i_ = 1; i_ <= (*k_); (i_)++) {
      v_ = 0.0;
      jlow_ = _max (i_, m_);
      for (j_ = jlow_; j_ <= (*k_); (j_)++) {
        v_ = a_[i_ - 1 + (20) * ((j_ - 1))] * vnikx_[j_ - 1 + ((*k_)) * ((m_ - 1))] + v_;
      }
      vnikx_[i_ - 1 + ((*k_)) * ((m_ - 1))] = v_;
    }
  }
  _l99:;
  __calls[92].calls++;
  return 0;
}

int_4 _dfspvn (real_8 _p_ t_, int_4 _p_ jhigh_, int_4 _p_ index_, real_8 _p_ x_, int_4 _p_ ileft_, real_8 _p_ vnikx_)
{
  static int_4 j_, i_, ipj_, imjp1_, jp1_, l_, jp1ml_;
  static real_8 deltam_[20], deltap_[20], vmprev_, vm_;
  int_4 _data_k_100, _data_k_101;
#define _data_n_100 1
  static int_4 _data_l_100[_data_n_100] = {
    1
  };
#define _data_n_101 40
  static real_8 _data_l_101[_data_n_101] = {
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0,
    0.0e0
  };
  if (__calls[93].calls == 0) {
    _data_k_100 = 0;
    if (_data_k_100 >= _data_n_100) {
      _data_k_100 = 0;
    }
    j_ = _data_l_100[_data_k_100++];
    _data_k_101 = 0;
    for (i_ = 1; i_ <= 20; i_++) {
      if (_data_k_101 >= _data_n_101) {
        _data_k_101 = 0;
      }
      deltam_[i_ - 1] = _data_l_101[_data_k_101++];
    }; // implied DO 
    for (i_ = 1; i_ <= 20; i_++) {
      if (_data_k_101 >= _data_n_101) {
        _data_k_101 = 0;
      }
      deltap_[i_ - 1] = _data_l_101[_data_k_101++];
    }; // implied DO 
  }
  switch ((*index_)) {
    default:
    case 1: goto _l10;
    case 2: goto _l20;
  }
  _l10:;
  j_ = 1;
  vnikx_[0] = 1.0;
  if (j_ >= (*jhigh_)) {
    goto _l99;
  }
  _l20:;
  ipj_ = (*ileft_) + j_;
  deltap_[j_ - 1] = t_[ipj_ - 1] - (*x_);
  imjp1_ = (*ileft_) - j_ + 1;
  deltam_[j_ - 1] = (*x_) - t_[imjp1_ - 1];
  vmprev_ = 0.0;
  jp1_ = j_ + 1;
  for (l_ = 1; l_ <= j_; (l_)++) {
    jp1ml_ = jp1_ - l_;
    vm_ = vnikx_[l_ - 1] / (deltap_[l_ - 1] + deltam_[jp1ml_ - 1]);
    vnikx_[l_ - 1] = vm_ * deltap_[l_ - 1] + vmprev_;
    vmprev_ = vm_ * deltam_[jp1ml_ - 1];
  }
  vnikx_[jp1_ - 1] = vmprev_;
  j_ = jp1_;
  if (j_ < (*jhigh_)) {
    goto _l20;
  }
  _l99:;
  __calls[93].calls++;
  return 0;
}

int_4 _dfulmt (int_4 _p_ i_, int_4 _p_ j_, real_8 _p_ aij_, int_4 _p_ indcat_, real_8 _p_ prgopt_, real_8 _p_ dattrv_, 
int_4 _p_ iflag_)
{
  static int_4 lp_, next_, nerr_, level_, key_;
  static real_8 zero_;
  if (! ((iflag_[0] == 1))) {
    goto _l50;
  }
  zero_ = 0.0;
  lp_ = 1;
  _l10:;
  next_ = prgopt_[lp_ - 1];
  if (! ((next_ <= 1))) {
    goto _l20;
  }
  nerr_ = 29;
  level_ = 1;
  (void) _xermsg (_dc_1, _dc_289, _dc_290, &nerr_, &level_);
  iflag_[0] = 3;
  goto _l110;
  _l20:;
  key_ = prgopt_[lp_ + 1 - 1];
  if (! ((key_ != 68))) {
    goto _l30;
  }
  lp_ = next_;
  goto _l10;
  _l30:;
  if (! ((prgopt_[lp_ + 2 - 1] == zero_))) {
    goto _l40;
  }
  lp_ = next_;
  goto _l10;
  _l40:;
  iflag_[1] = 1;
  iflag_[2] = 1;
  iflag_[3] = prgopt_[lp_ + 3 - 1];
  iflag_[4] = prgopt_[lp_ + 4 - 1];
  iflag_[5] = prgopt_[lp_ + 5 - 1];
  goto _l110;
  _l50:;
  if (! ((iflag_[0] == 2))) {
    goto _l100;
  }
  _l60:;
  (*i_) = iflag_[1];
  (*j_) = iflag_[2];
  if (! (((*j_) > iflag_[5]))) {
    goto _l70;
  }
  iflag_[0] = 3;
  goto _l110;
  _l70:;
  if (! (((*i_) > iflag_[4]))) {
    goto _l80;
  }
  iflag_[1] = 1;
  iflag_[2] = (*j_) + 1;
  goto _l60;
  _l80:;
  (*aij_) = dattrv_[iflag_[3] * ((*j_) - 1) + (*i_) - 1];
  iflag_[1] = (*i_) + 1;
  if (! (((*aij_) == zero_))) {
    goto _l90;
  }
  goto _l60;
  _l90:;
  (*indcat_) = 0;
  goto _l110;
  _l100:;
  _l110:;
  __calls[94].calls++;
  return 0;
}

int_4 _dfzero (real_8 (*_f)(), real_8 _p_ b_, real_8 _p_ c_, real_8 _p_ r_, real_8 _p_ re_, real_8 _p_ ae_, int_4 _p_ 
iflag_)
{
  static int_4 ic_, kount_;
  static real_8 a_, acbs_, acmb_, aw_, cmb_, er_, fa_, fb_, fc_, fx_, fz_, p_, q_, rw_, t_, tol_, z_;
  int_4 $0_;
  extern real_8 _d1mach ();
  er_ = 2.0e0 * _d1mach (($0_ = 4, &$0_));
  z_ = (*r_);
  if ((*r_) <= _min ((*b_), (*c_)) || (*r_) >= _max ((*b_), (*c_))) {
    z_ = (*c_);
  }
  rw_ = _max ((*re_), er_);
  aw_ = _max ((*ae_), 0.0);
  ic_ = 0;
  t_ = z_;
  fz_ = _f (&t_);
  fc_ = fz_;
  t_ = (*b_);
  fb_ = _f (&t_);
  kount_ = 2;
  if (_sign (1.0, fz_) == _sign (1.0, fb_)) {
    goto _l1;
  }
  (*c_) = z_;
  goto _l2;
  _l1:;
  if (z_ == (*c_)) {
    goto _l2;
  }
  t_ = (*c_);
  fc_ = _f (&t_);
  kount_ = 3;
  if (_sign (1.0, fz_) == _sign (1.0, fc_)) {
    goto _l2;
  }
  (*b_) = z_;
  fb_ = fz_;
  _l2:;
  a_ = (*c_);
  fa_ = fc_;
  acbs_ = _abs ((*b_) - (*c_));
  fx_ = _max (_abs (fb_), _abs (fc_));
  _l3:;
  if (_abs (fc_) >= _abs (fb_)) {
    goto _l4;
  }
  a_ = (*b_);
  fa_ = fb_;
  (*b_) = (*c_);
  fb_ = fc_;
  (*c_) = a_;
  fc_ = fa_;
  _l4:;
  cmb_ = 0.5e0 * ((*c_) - (*b_));
  acmb_ = _abs (cmb_);
  tol_ = rw_ * _abs ((*b_)) + aw_;
  if (acmb_ <= tol_) {
    goto _l10;
  }
  if (fb_ == 0.0e0) {
    goto _l11;
  }
  if (kount_ >= 500) {
    goto _l14;
  }
  p_ = ((*b_) - a_) * fb_;
  q_ = fa_ - fb_;
  if (p_ >= 0.0e0) {
    goto _l5;
  }
  p_ = -p_;
  q_ = -q_;
  _l5:;
  a_ = (*b_);
  fa_ = fb_;
  ic_ = ic_ + 1;
  if (ic_ < 4) {
    goto _l6;
  }
  if (8.0e0 * acmb_ >= acbs_) {
    goto _l8;
  }
  ic_ = 0;
  acbs_ = acmb_;
  _l6:;
  if (p_ > _abs (q_) * tol_) {
    goto _l7;
  }
  (*b_) = (*b_) + _sign (tol_, cmb_);
  goto _l9;
  _l7:;
  if (p_ >= cmb_ * q_) {
    goto _l8;
  }
  (*b_) = (*b_) + p_ / q_;
  goto _l9;
  _l8:;
  (*b_) = (*b_) + cmb_;
  _l9:;
  t_ = (*b_);
  fb_ = _f (&t_);
  kount_ = kount_ + 1;
  if (_sign (1.0, fb_) != _sign (1.0, fc_)) {
    goto _l3;
  }
  (*c_) = a_;
  fc_ = fa_;
  goto _l3;
  _l10:;
  if (_sign (1.0, fb_) == _sign (1.0, fc_)) {
    goto _l13;
  }
  if (_abs (fb_) > fx_) {
    goto _l12;
  }
  (*iflag_) = 1;
  goto _l0;
  _l11:;
  (*iflag_) = 2;
  goto _l0;
  _l12:;
  (*iflag_) = 3;
  goto _l0;
  _l13:;
  (*iflag_) = 4;
  goto _l0;
  _l14:;
  (*iflag_) = 5;
  _l0:;
  __calls[95].calls++;
  return 0;
}

int_4 _dgaus8 (real_8 (*_fun)(), real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ err_, real_8 _p_ ans_, int_4 _p_ ierr_)
{
  static int_4 k_, kml_, kmx_, l_, lmn_, lmx_, lr_[60], mxl_, nbits_, nib_, nlmn_, nlmx_;
  static real_8 aa_[60], ae_, anib_, area_, c_, ce_, ee_, ef_, eps_, est_, gl_, glr_, gr_[60], hh_[60], sq2_, tol_, 
  vl_[60], vr_, w1_, w2_, w3_, w4_, x1_, x2_, x3_, x4_, x_, h_;
  int_4 _data_k_102, _data_k_103, _data_k_104, _data_k_105, _data_k_106, _data_k_107, $0_, $1_, $2_, $28_, $29_, $30_;
  real_8 $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_, $16_, $17_, $18_, $19_, $20_, $21_, $22_, 
  $23_, $24_, $25_, $26_, $27_;
  char_127 $31_;
  extern int_4 _i1mach ();
  extern real_8 _d1mach ();
#define _data_n_102 4
  static real_8 _data_l_102[_data_n_102] = {
    1.83434642495649805e-1,
    5.25532409916328986e-1,
    7.9666647741362674e-1,
    9.60289856497536232e-1
  };
#define _data_n_103 4
  static real_8 _data_l_103[_data_n_103] = {
    3.62683783378361983e-1,
    3.13706645877887287e-1,
    2.22381034453374471e-1,
    1.01228536290376259e-1
  };
#define _data_n_104 1
  static real_8 _data_l_104[_data_n_104] = {
    1.41421356e0
  };
#define _data_n_105 1
  static int_4 _data_l_105[_data_n_105] = {
    1
  };
#define _data_n_106 1
  static int_4 _data_l_106[_data_n_106] = {
    5000
  };
#define _data_n_107 1
  static int_4 _data_l_107[_data_n_107] = {
    6
  };
  if (__calls[96].calls == 0) {
    _data_k_102 = 0;
    if (_data_k_102 >= _data_n_102) {
      _data_k_102 = 0;
    }
    x1_ = _data_l_102[_data_k_102++];
    if (_data_k_102 >= _data_n_102) {
      _data_k_102 = 0;
    }
    x2_ = _data_l_102[_data_k_102++];
    if (_data_k_102 >= _data_n_102) {
      _data_k_102 = 0;
    }
    x3_ = _data_l_102[_data_k_102++];
    if (_data_k_102 >= _data_n_102) {
      _data_k_102 = 0;
    }
    x4_ = _data_l_102[_data_k_102++];
  }
  if (__calls[96].calls == 0) {
    _data_k_103 = 0;
    if (_data_k_103 >= _data_n_103) {
      _data_k_103 = 0;
    }
    w1_ = _data_l_103[_data_k_103++];
    if (_data_k_103 >= _data_n_103) {
      _data_k_103 = 0;
    }
    w2_ = _data_l_103[_data_k_103++];
    if (_data_k_103 >= _data_n_103) {
      _data_k_103 = 0;
    }
    w3_ = _data_l_103[_data_k_103++];
    if (_data_k_103 >= _data_n_103) {
      _data_k_103 = 0;
    }
    w4_ = _data_l_103[_data_k_103++];
  }
  if (__calls[96].calls == 0) {
    _data_k_104 = 0;
    if (_data_k_104 >= _data_n_104) {
      _data_k_104 = 0;
    }
    sq2_ = _data_l_104[_data_k_104++];
  }
  if (__calls[96].calls == 0) {
    _data_k_105 = 0;
    if (_data_k_105 >= _data_n_105) {
      _data_k_105 = 0;
    }
    nlmn_ = _data_l_105[_data_k_105++];
    _data_k_106 = 0;
    if (_data_k_106 >= _data_n_106) {
      _data_k_106 = 0;
    }
    kmx_ = _data_l_106[_data_k_106++];
    _data_k_107 = 0;
    if (_data_k_107 >= _data_n_107) {
      _data_k_107 = 0;
    }
    kml_ = _data_l_107[_data_k_107++];
  }
  k_ = _i1mach (($0_ = 14, &$0_));
  anib_ = _d1mach (($1_ = 5, &$1_)) * k_ / 0.30102e0;
  nbits_ = anib_;
  nlmx_ = _min (60, (nbits_ * 5) / 8);
  (*ans_) = 0.0;
  (*ierr_) = 1;
  ce_ = 0.0;
  if ((*a_) == (*b_)) {
    goto _l140;
  }
  lmx_ = nlmx_;
  lmn_ = nlmn_;
  if ((*b_) == 0.0e0) {
    goto _l10;
  }
  if (_sign (1.0, (*b_)) * (*a_) <= 0.0e0) {
    goto _l10;
  }
  c_ = _abs (1.0e0 - (*a_) / (*b_));
  if (c_ > 0.1e0) {
    goto _l10;
  }
  if (c_ <= 0.0e0) {
    goto _l140;
  }
  anib_ = 0.5e0 - log (c_) / 0.69314718e0;
  nib_ = anib_;
  lmx_ = _min (nlmx_, nbits_ - nib_ - 7);
  if (lmx_ < 1) {
    goto _l130;
  }
  lmn_ = _min (lmn_, lmx_);
  _l10:;
  tol_ = _max (_abs ((*err_)), _up_real_8 (2.0e0, (5 - nbits_))) / 2.0e0;
  if ((*err_) == 0.0e0) {
    tol_ = sqrt (_d1mach (($2_ = 4, &$2_)));
  }
  eps_ = tol_;
  hh_[0] = ((*b_) - (*a_)) / 4.0e0;
  aa_[0] = (*a_);
  lr_[0] = 1;
  l_ = 1;
  est_ = ({real_8 x__1_ = aa_[l_ - 1] + 2.0e0 * hh_[l_ - 1]; real_8 h__1_ = 2.0e0 * hh_[l_ - 1]; h__1_ * ((w1_ * (_fun 
  (($3_ = x__1_ - x1_ * h__1_, &$3_)) + _fun (($4_ = x__1_ + x1_ * h__1_, &$4_))) + w2_ * (_fun (($5_ = x__1_ - x2_ * 
  h__1_, &$5_)) + _fun (($6_ = x__1_ + x2_ * h__1_, &$6_)))) + (w3_ * (_fun (($7_ = x__1_ - x3_ * h__1_, &$7_)) + _fun 
  (($8_ = x__1_ + x3_ * h__1_, &$8_))) + w4_ * (_fun (($9_ = x__1_ - x4_ * h__1_, &$9_)) + _fun (($10_ = x__1_ + x4_ * 
  h__1_, &$10_)))));});
  k_ = 8;
  area_ = _abs (est_);
  ef_ = 0.5;
  mxl_ = 0;
  _l20:;
  gl_ = ({real_8 x__1_ = aa_[l_ - 1] + hh_[l_ - 1]; real_8 h__1_ = hh_[l_ - 1]; h__1_ * ((w1_ * (_fun (($11_ = x__1_ - 
  x1_ * h__1_, &$11_)) + _fun (($12_ = x__1_ + x1_ * h__1_, &$12_))) + w2_ * (_fun (($13_ = x__1_ - x2_ * h__1_, &$13_)) 
  + _fun (($14_ = x__1_ + x2_ * h__1_, &$14_)))) + (w3_ * (_fun (($15_ = x__1_ - x3_ * h__1_, &$15_)) + _fun (($16_ = 
  x__1_ + x3_ * h__1_, &$16_))) + w4_ * (_fun (($17_ = x__1_ - x4_ * h__1_, &$17_)) + _fun (($18_ = x__1_ + x4_ * h__1_, 
  &$18_)))));});
  gr_[l_ - 1] = ({real_8 x__1_ = aa_[l_ - 1] + 3.0e0 * hh_[l_ - 1]; real_8 h__1_ = hh_[l_ - 1]; h__1_ * ((w1_ * (_fun 
  (($19_ = x__1_ - x1_ * h__1_, &$19_)) + _fun (($20_ = x__1_ + x1_ * h__1_, &$20_))) + w2_ * (_fun (($21_ = x__1_ - x2_ 
  * h__1_, &$21_)) + _fun (($22_ = x__1_ + x2_ * h__1_, &$22_)))) + (w3_ * (_fun (($23_ = x__1_ - x3_ * h__1_, &$23_)) + 
  _fun (($24_ = x__1_ + x3_ * h__1_, &$24_))) + w4_ * (_fun (($25_ = x__1_ - x4_ * h__1_, &$25_)) + _fun (($26_ = x__1_ + 
  x4_ * h__1_, &$26_)))));});
  k_ = k_ + 16;
  area_ = area_ + (_abs (gl_) + _abs (gr_[l_ - 1]) - _abs (est_));
  glr_ = gl_ + gr_[l_ - 1];
  ee_ = _abs (est_ - glr_) * ef_;
  ae_ = _max (eps_ * area_, tol_ * _abs (glr_));
  $27_ = ee_ - ae_;
  if ($27_ < 0) {
    goto _l40;
  } else if ($27_ == 0) {
    goto _l40;
  } else {
    goto _l50;
  }
  _l30:;
  mxl_ = 1;
  _l40:;
  ce_ = ce_ + (est_ - glr_);
  $28_ = lr_[l_ - 1];
  if ($28_ < 0) {
    goto _l60;
  } else if ($28_ == 0) {
    goto _l60;
  } else {
    goto _l80;
  }
  _l50:;
  if (k_ > kmx_) {
    lmx_ = kml_;
  }
  if (l_ >= lmx_) {
    goto _l30;
  }
  l_ = l_ + 1;
  eps_ = eps_ * 0.5e0;
  ef_ = ef_ / sq2_;
  hh_[l_ - 1] = hh_[l_ - 1 - 1] * 0.5e0;
  lr_[l_ - 1] = -1;
  aa_[l_ - 1] = aa_[l_ - 1 - 1];
  est_ = gl_;
  goto _l20;
  _l60:;
  vl_[l_ - 1] = glr_;
  _l70:;
  est_ = gr_[l_ - 1 - 1];
  lr_[l_ - 1] = 1;
  aa_[l_ - 1] = aa_[l_ - 1] + 4.0e0 * hh_[l_ - 1];
  goto _l20;
  _l80:;
  vr_ = glr_;
  _l90:;
  if (l_ <= 1) {
    goto _l120;
  }
  l_ = l_ - 1;
  eps_ = eps_ * 2.0e0;
  ef_ = ef_ * sq2_;
  $29_ = lr_[l_ - 1];
  if ($29_ < 0) {
    goto _l100;
  } else if ($29_ == 0) {
    goto _l100;
  } else {
    goto _l110;
  }
  _l100:;
  vl_[l_ - 1] = vl_[l_ + 1 - 1] + vr_;
  goto _l70;
  _l110:;
  vr_ = vl_[l_ + 1 - 1] + vr_;
  goto _l90;
  _l120:;
  (*ans_) = vr_;
  if ((mxl_ == 0) || (_abs (ce_) <= 2.0e0 * tol_ * area_)) {
    goto _l140;
  }
  (*ierr_) = 2;
  (void) _xermsg (_dc_1, _dc_291, _dc_16, ($30_ = 3, &$30_), &_k1);
  goto _l140;
  _l130:;
  (*ierr_) = -1;
  (void) _xermsg (_dc_1, _dc_291, concat ($31_, _dc_292, _dc_293), &_k1, &_km1);
  _l140:;
  if ((*err_) < 0.0e0) {
    (*err_) = ce_;
  }
  __calls[96].calls++;
  return 0;
}

int_4 _dgefs (real_8 _p_ a_, int_4 _p_ lda_, int_4 _p_ n_, real_8 _p_ v_, int_4 _p_ itask_, int_4 _p_ ind_, real_8 _p_ 
work_, int_4 _p_ iwork_)
{
  static real_8 rcond_;
  static char_15 xern1_, xern2_;
  int_4 __fcnt, __rc, $7_, $11_, $12_, $13_, $14_;
  char_31 $0_, $4_, $8_;
  char_63 $1_, $5_, $6_, $9_, $10_;
  char_127 $2_, $3_;
  extern real_8 _d1mach ();
  static FORMAT $f_100008_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100009_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100015_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100021_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  if ((*lda_) < (*n_)) {
    (*ind_) = -1;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dgefs:112", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:112", 0));
      __fcnt += 3;
    }
    if ($f_100008_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:112", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100008_[__fcnt + 2], &(*lda_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:112", 0));
    __fcnt += 3;
    while ($f_100008_[__fcnt] != NULL && $f_100008_[__fcnt] == FMT_TEXT) {
      if ($f_100008_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100008_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:112", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dgefs:113", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:113", 0));
      __fcnt += 3;
    }
    if ($f_100009_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:113", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100009_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:113", 0));
    __fcnt += 3;
    while ($f_100009_[__fcnt] != NULL && $f_100009_[__fcnt] == FMT_TEXT) {
      if ($f_100009_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100009_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:113", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_294, (bufcpy ($3_, concat ($2_, concat ($1_, concat ($0_, _dc_27, xern1_), _dc_28), xern2_), 
    127), $3_), &_km1, &_k1);
    goto _l0;
  }
  if ((*n_) <= 0) {
    (*ind_) = -2;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dgefs:121", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:121", 0));
      __fcnt += 3;
    }
    if ($f_100015_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:121", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100015_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:121", 0));
    __fcnt += 3;
    while ($f_100015_[__fcnt] != NULL && $f_100015_[__fcnt] == FMT_TEXT) {
      if ($f_100015_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100015_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:121", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_294, (bufcpy ($6_, concat ($5_, concat ($4_, _dc_29, xern1_), _dc_30), 63), $6_), ($7_ = -2, 
    &$7_), &_k1);
    goto _l0;
  }
  if ((*itask_) < 1) {
    (*ind_) = -3;
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dgefs:129", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:129", 0));
      __fcnt += 3;
    }
    if ($f_100021_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:129", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100021_[__fcnt + 2], &(*itask_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:129", 0));
    __fcnt += 3;
    while ($f_100021_[__fcnt] != NULL && $f_100021_[__fcnt] == FMT_TEXT) {
      if ($f_100021_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100021_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dgefs:129", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_294, (bufcpy ($10_, concat ($9_, concat ($8_, _dc_31, xern1_), _dc_30), 63), $10_), ($11_ = 
    -3, &$11_), &_k1);
    goto _l0;
  }
  if ((*itask_) == 1) {
    (void) _dgeco (a_, lda_, n_, iwork_, &rcond_, work_);
    if (rcond_ == 0.0e0) {
      (*ind_) = -4;
      (void) _xermsg (_dc_1, _dc_294, _dc_32, ($12_ = -4, &$12_), &_k1);
      goto _l0;
    }
    (*ind_) = -log10 (_d1mach (($13_ = 4, &$13_)) / rcond_);
    if ((*ind_) <= 0) {
      (*ind_) = -10;
      (void) _xermsg (_dc_1, _dc_294, _dc_33, ($14_ = -10, &$14_), &_k0);
    }
  }
  (void) _dgesl (a_, lda_, n_, iwork_, v_, &_k0);
  _l0:;
  __calls[97].calls++;
  return 0;
}

int_4 _dglss (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, int_4 _p_ nb_, 
real_8 _p_ rnorm_, real_8 _p_ work_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ info_)
{
  static int_4 key_, mode_, np_, krank_, ksure_;
  static real_8 re_, ae_;
  re_ = 0.0;
  ae_ = 0.0;
  key_ = 0;
  mode_ = 2;
  np_ = 0;
  if ((*m_) < (*n_)) {
    goto _l10;
  }
  (void) _dllsia (a_, mda_, m_, n_, b_, mdb_, nb_, &re_, &ae_, &key_, &mode_, &np_, &krank_, &ksure_, rnorm_, work_, lw_, 
  iwork_, liw_, info_);
  if ((*info_) == -1) {
    goto _l0;
  }
  (*info_) = (*n_) - krank_;
  goto _l0;
  _l10:;
  (void) _dulsia (a_, mda_, m_, n_, b_, mdb_, nb_, &re_, &ae_, &key_, &mode_, &np_, &krank_, &ksure_, rnorm_, work_, lw_, 
  iwork_, liw_, info_);
  if ((*info_) == -1) {
    goto _l0;
  }
  (*info_) = (*m_) - krank_;
  _l0:;
  __calls[98].calls++;
  return 0;
}

int_4 _dh12 (int_4 _p_ mode_, int_4 _p_ lpivot_, int_4 _p_ l1_, int_4 _p_ m_, real_8 _p_ u_, int_4 _p_ iue_, real_8 _p_ 
up_, real_8 _p_ c_, int_4 _p_ ice_, int_4 _p_ icv_, int_4 _p_ ncv_)
{
  static int_4 i_, i2_, i3_, i4_, incr_, j_, kl1_, kl2_, klp_, l1m1_, mml1p2_;
  static real_8 b_, cl_, clinv_, one_, ul1m1_, sm_;
  real_8 $0_, $1_;
  extern real_8 _ddot ();
  one_ = 1.0;
  if (0 >= (*lpivot_) || (*lpivot_) >= (*l1_) || (*l1_) > (*m_)) {
    goto _l140;
  }
  cl_ = _abs (u_[0 + ((*iue_)) * (((*lpivot_) - 1))]);
  if ((*mode_) == 2) {
    goto _l40;
  }
  for (j_ = (*l1_); j_ <= (*m_); (j_)++) {
    cl_ = _max (_abs (u_[0 + ((*iue_)) * ((j_ - 1))]), cl_);
  }
  if (cl_ > 0.0e0) {
    goto _l20;
  }
  goto _l140;
  _l20:;
  clinv_ = one_ / cl_;
  sm_ = ($0_ = (u_[0 + ((*iue_)) * (((*lpivot_) - 1))] * clinv_), $0_ * $0_);
  for (j_ = (*l1_); j_ <= (*m_); (j_)++) {
    sm_ = sm_ + ($1_ = (u_[0 + ((*iue_)) * ((j_ - 1))] * clinv_), $1_ * $1_);
  }
  cl_ = cl_ * sqrt (sm_);
  if (u_[0 + ((*iue_)) * (((*lpivot_) - 1))] > 0.0e0) {
    cl_ = -cl_;
  }
  (*up_) = u_[0 + ((*iue_)) * (((*lpivot_) - 1))] - cl_;
  u_[0 + ((*iue_)) * (((*lpivot_) - 1))] = cl_;
  goto _l50;
  _l40:;
  if (cl_ > 0.0e0) {
    goto _l50;
  }
  goto _l140;
  _l50:;
  if ((*ncv_) <= 0) {
    goto _l140;
  }
  b_ = (*up_) * u_[0 + ((*iue_)) * (((*lpivot_) - 1))];
  if (b_ < 0.0e0) {
    goto _l60;
  }
  goto _l140;
  _l60:;
  b_ = one_ / b_;
  mml1p2_ = (*m_) - (*l1_) + 2;
  if (mml1p2_ <= 20) {
    goto _l80;
  }
  l1m1_ = (*l1_) - 1;
  kl1_ = 1 + (l1m1_ - 1) * (*ice_);
  kl2_ = kl1_;
  klp_ = 1 + ((*lpivot_) - 1) * (*ice_);
  ul1m1_ = u_[0 + ((*iue_)) * ((l1m1_ - 1))];
  u_[0 + ((*iue_)) * ((l1m1_ - 1))] = (*up_);
  if ((*lpivot_) != l1m1_) {
    (void) _dswap (ncv_, &c_[kl1_ - 1], icv_, &c_[klp_ - 1], icv_);
  }
  for (j_ = 1; j_ <= (*ncv_); (j_)++) {
    sm_ = _ddot (&mml1p2_, &u_[0 + ((*iue_)) * ((l1m1_ - 1))], iue_, &c_[kl1_ - 1], ice_);
    sm_ = sm_ * b_;
    (void) _daxpy (&mml1p2_, &sm_, &u_[0 + ((*iue_)) * ((l1m1_ - 1))], iue_, &c_[kl1_ - 1], ice_);
    kl1_ = kl1_ + (*icv_);
  }
  u_[0 + ((*iue_)) * ((l1m1_ - 1))] = ul1m1_;
  if ((*lpivot_) == l1m1_) {
    goto _l140;
  }
  kl1_ = kl2_;
  (void) _dswap (ncv_, &c_[kl1_ - 1], icv_, &c_[klp_ - 1], icv_);
  goto _l130;
  _l80:;
  i2_ = 1 - (*icv_) + (*ice_) * ((*lpivot_) - 1);
  incr_ = (*ice_) * ((*l1_) - (*lpivot_));
  for (j_ = 1; j_ <= (*ncv_); (j_)++) {
    i2_ = i2_ + (*icv_);
    i3_ = i2_ + incr_;
    i4_ = i3_;
    sm_ = c_[i2_ - 1] * (*up_);
    for (i_ = (*l1_); i_ <= (*m_); (i_)++) {
      sm_ = sm_ + c_[i3_ - 1] * u_[0 + ((*iue_)) * ((i_ - 1))];
      i3_ = i3_ + (*ice_);
    }
    if (sm_ == 0.0e0) {
      goto _l110;
    }
    sm_ = sm_ * b_;
    c_[i2_ - 1] = c_[i2_ - 1] + sm_ * (*up_);
    for (i_ = (*l1_); i_ <= (*m_); (i_)++) {
      c_[i4_ - 1] = c_[i4_ - 1] + sm_ * u_[0 + ((*iue_)) * ((i_ - 1))];
      i4_ = i4_ + (*ice_);
    }
    _l110:;
  }
  _l130:;
  _l140:;
  __calls[99].calls++;
  return 0;
}

int_4 _dhfti (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, int_4 _p_ nb_, 
real_8 _p_ tau_, int_4 _p_ krank_, real_8 _p_ rnorm_, real_8 _p_ h_, real_8 _p_ g_, int_4 _p_ ip_)
{
  static int_4 i_, ii_, iopt_, ip1_, j_, jb_, jj_, k_, kp1_, l_, ldiag_, lmax_, nerr_;
  static real_8 dzero_, factor_, hmax_, releps_, sm_, sm1_, szero_, tmp_;
  int_4 _data_k_108, $0_, $1_, $2_, $3_, $4_, $5_, $6_;
  extern real_8 _d1mach ();
#define _data_n_108 1
  static real_8 _data_l_108[_data_n_108] = {
    0.0e0
  };
  if (__calls[100].calls == 0) {
    _data_k_108 = 0;
    if (_data_k_108 >= _data_n_108) {
      _data_k_108 = 0;
    }
    releps_ = _data_l_108[_data_k_108++];
  }
  if (releps_ == 0.0e0) {
    releps_ = _d1mach (($0_ = 4, &$0_));
  }
  szero_ = 0.0;
  dzero_ = 0.0;
  factor_ = 1.0e-3;
  k_ = 0;
  ldiag_ = _min ((*m_), (*n_));
  if (ldiag_ <= 0) {
    goto _l350;
  }
  if ((*mda_) >= (*m_)) {
    goto _l10;
  }
  nerr_ = 1;
  iopt_ = 2;
  (void) _xermsg (_dc_1, _dc_295, _dc_296, &nerr_, &iopt_);
  goto _l360;
  _l10:;
  if ((*nb_) <= 1 || _max ((*m_), (*n_)) <= (*mdb_)) {
    goto _l20;
  }
  nerr_ = 2;
  iopt_ = 2;
  (void) _xermsg (_dc_1, _dc_295, _dc_297, &nerr_, &iopt_);
  goto _l360;
  _l20:;
  for (j_ = 1; j_ <= ldiag_; (j_)++) {
    if (j_ == 1) {
      goto _l40;
    }
    lmax_ = j_;
    for (l_ = j_; l_ <= (*n_); (l_)++) {
      h_[l_ - 1] = h_[l_ - 1] - (a_[j_ - 1 - 1 + ((*mda_)) * ((l_ - 1))] * a_[j_ - 1 - 1 + ((*mda_)) * ((l_ - 1))]);
      if (h_[l_ - 1] > h_[lmax_ - 1]) {
        lmax_ = l_;
      }
    }
    if (factor_ * h_[lmax_ - 1] > hmax_ * releps_) {
      goto _l70;
    }
    _l40:;
    lmax_ = j_;
    for (l_ = j_; l_ <= (*n_); (l_)++) {
      h_[l_ - 1] = 0.0;
      for (i_ = j_; i_ <= (*m_); (i_)++) {
        h_[l_ - 1] = h_[l_ - 1] + (a_[i_ - 1 + ((*mda_)) * ((l_ - 1))] * a_[i_ - 1 + ((*mda_)) * ((l_ - 1))]);
      }
      if (h_[l_ - 1] > h_[lmax_ - 1]) {
        lmax_ = l_;
      }
    }
    hmax_ = h_[lmax_ - 1];
    _l70:;
    ip_[j_ - 1] = lmax_;
    if (ip_[j_ - 1] == j_) {
      goto _l90;
    }
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      tmp_ = a_[i_ - 1 + ((*mda_)) * ((j_ - 1))];
      a_[i_ - 1 + ((*mda_)) * ((j_ - 1))] = a_[i_ - 1 + ((*mda_)) * ((lmax_ - 1))];
      a_[i_ - 1 + ((*mda_)) * ((lmax_ - 1))] = tmp_;
    }
    h_[lmax_ - 1] = h_[j_ - 1];
    _l90:;
    (void) _dh12 (&_k1, &j_, ($1_ = j_ + 1, &$1_), m_, &a_[0 + ((*mda_)) * ((j_ - 1))], &_k1, &h_[j_ - 1], &a_[0 + 
    ((*mda_)) * ((j_ + 1 - 1))], &_k1, mda_, ($2_ = (*n_) - j_, &$2_));
    (void) _dh12 (($3_ = 2, &$3_), &j_, ($4_ = j_ + 1, &$4_), m_, &a_[0 + ((*mda_)) * ((j_ - 1))], &_k1, &h_[j_ - 1], b_, 
    &_k1, mdb_, nb_);
  }
  for (j_ = 1; j_ <= ldiag_; (j_)++) {
    if (_abs (a_[j_ - 1 + ((*mda_)) * ((j_ - 1))]) <= (*tau_)) {
      goto _l120;
    }
  }
  k_ = ldiag_;
  goto _l130;
  _l120:;
  k_ = j_ - 1;
  _l130:;
  kp1_ = k_ + 1;
  if ((*nb_) < 1) {
    goto _l170;
  }
  for (jb_ = 1; jb_ <= (*nb_); (jb_)++) {
    tmp_ = szero_;
    if ((*m_) < kp1_) {
      goto _l150;
    }
    for (i_ = kp1_; i_ <= (*m_); (i_)++) {
      tmp_ = tmp_ + (b_[i_ - 1 + ((*mdb_)) * ((jb_ - 1))] * b_[i_ - 1 + ((*mdb_)) * ((jb_ - 1))]);
    }
    _l150:;
    rnorm_[jb_ - 1] = sqrt (tmp_);
  }
  _l170:;
  if (k_ > 0) {
    goto _l210;
  }
  if ((*nb_) < 1) {
    goto _l200;
  }
  for (jb_ = 1; jb_ <= (*nb_); (jb_)++) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      b_[i_ - 1 + ((*mdb_)) * ((jb_ - 1))] = szero_;
    }
  }
  _l200:;
  goto _l340;
  _l210:;
  if (k_ == (*n_)) {
    goto _l230;
  }
  for (ii_ = 1; ii_ <= k_; (ii_)++) {
    i_ = kp1_ - ii_;
    (void) _dh12 (&_k1, &i_, &kp1_, n_, &a_[i_ - 1 + ((*mda_)) * ((0))], mda_, &g_[i_ - 1], a_, mda_, &_k1, ($5_ = i_ - 1, 
    &$5_));
  }
  _l230:;
  if ((*nb_) < 1) {
    goto _l330;
  }
  for (jb_ = 1; jb_ <= (*nb_); (jb_)++) {
    for (l_ = 1; l_ <= k_; (l_)++) {
      sm_ = dzero_;
      i_ = kp1_ - l_;
      ip1_ = i_ + 1;
      if (k_ < ip1_) {
        goto _l250;
      }
      for (j_ = ip1_; j_ <= k_; (j_)++) {
        sm_ = sm_ + a_[i_ - 1 + ((*mda_)) * ((j_ - 1))] * b_[j_ - 1 + ((*mdb_)) * ((jb_ - 1))];
      }
      _l250:;
      sm1_ = sm_;
      b_[i_ - 1 + ((*mdb_)) * ((jb_ - 1))] = (b_[i_ - 1 + ((*mdb_)) * ((jb_ - 1))] - sm1_) / a_[i_ - 1 + ((*mda_)) * ((i_ - 
      1))];
    }
    if (k_ == (*n_)) {
      goto _l290;
    }
    for (j_ = kp1_; j_ <= (*n_); (j_)++) {
      b_[j_ - 1 + ((*mdb_)) * ((jb_ - 1))] = szero_;
    }
    for (i_ = 1; i_ <= k_; (i_)++) {
      (void) _dh12 (($6_ = 2, &$6_), &i_, &kp1_, n_, &a_[i_ - 1 + ((*mda_)) * ((0))], mda_, &g_[i_ - 1], &b_[0 + ((*mdb_)) * 
      ((jb_ - 1))], &_k1, mdb_, &_k1);
    }
    _l290:;
    for (jj_ = 1; jj_ <= ldiag_; (jj_)++) {
      j_ = ldiag_ + 1 - jj_;
      if (ip_[j_ - 1] == j_) {
        goto _l300;
      }
      l_ = ip_[j_ - 1];
      tmp_ = b_[l_ - 1 + ((*mdb_)) * ((jb_ - 1))];
      b_[l_ - 1 + ((*mdb_)) * ((jb_ - 1))] = b_[j_ - 1 + ((*mdb_)) * ((jb_ - 1))];
      b_[j_ - 1 + ((*mdb_)) * ((jb_ - 1))] = tmp_;
      _l300:;
    }
  }
  _l330:;
  _l340:;
  _l350:;
  (*krank_) = k_;
  _l360:;
  __calls[100].calls++;
  return 0;
}

int_4 _dhstrt (int_4 (*_df)(), int_4 _p_ neq_, real_8 _p_ a_, real_8 _p_ b_, real_8 _p_ y_, real_8 _p_ yprime_, real_8 
_p_ etol_, int_4 _p_ morder_, real_8 _p_ small_, real_8 _p_ big_, real_8 _p_ spy_, real_8 _p_ pv_, real_8 _p_ yp_, 
real_8 _p_ sf_, real_8 _p_ rpar_, int_4 _p_ ipar_, real_8 _p_ h_)
{
  static int_4 j_, k_, lk_;
  static real_8 absdx_, da_, delf_, dely_, dfdub_, dfdxb_, dx_, dy_, fbnd_, relper_, srydpb_, tolexp_, tolmin_, tolp_, 
  tolsum_, ydpb_;
  real_8 $0_, $1_;
  dx_ = (*b_) - (*a_);
  absdx_ = _abs (dx_);
  relper_ = pow ((*small_), 0.375e0);
  da_ = _sign (_max (_min (relper_ * _abs ((*a_)), absdx_), 100.0e0 * (*small_) * _abs ((*a_))), dx_);
  if (da_ == 0.0e0) {
    da_ = relper_ * dx_;
  }
  (void) _df (($0_ = (*a_) + da_, &$0_), y_, sf_, rpar_, ipar_);
  for (j_ = 1; j_ <= (*neq_); (j_)++) {
    yp_[j_ - 1] = sf_[j_ - 1] - yprime_[j_ - 1];
  }
  delf_ = _dhvnrm (yp_, neq_);
  dfdxb_ = (*big_);
  if (delf_ < (*big_) * _abs (da_)) {
    dfdxb_ = delf_ / _abs (da_);
  }
  fbnd_ = _dhvnrm (sf_, neq_);
  dely_ = relper_ * _dhvnrm (y_, neq_);
  if (dely_ == 0.0e0) {
    dely_ = relper_;
  }
  dely_ = _sign (dely_, dx_);
  delf_ = _dhvnrm (yprime_, neq_);
  fbnd_ = _max (fbnd_, delf_);
  if (delf_ == 0.0e0) {
    goto _l30;
  }
  for (j_ = 1; j_ <= (*neq_); (j_)++) {
    spy_[j_ - 1] = yprime_[j_ - 1];
    yp_[j_ - 1] = yprime_[j_ - 1];
  }
  goto _l50;
  _l30:;
  for (j_ = 1; j_ <= (*neq_); (j_)++) {
    spy_[j_ - 1] = 0.0;
    yp_[j_ - 1] = 1.0;
  }
  delf_ = _dhvnrm (yp_, neq_);
  _l50:;
  dfdub_ = 0.0;
  lk_ = _min ((*neq_) + 1, 3);
  for (k_ = 1; k_ <= lk_; (k_)++) {
    for (j_ = 1; j_ <= (*neq_); (j_)++) {
      pv_[j_ - 1] = y_[j_ - 1] + dely_ * (yp_[j_ - 1] / delf_);
    }
    if (k_ == 2) {
      goto _l80;
    }
    (void) _df (a_, pv_, yp_, rpar_, ipar_);
    for (j_ = 1; j_ <= (*neq_); (j_)++) {
      pv_[j_ - 1] = yp_[j_ - 1] - yprime_[j_ - 1];
    }
    goto _l100;
    _l80:;
    (void) _df (($1_ = (*a_) + da_, &$1_), pv_, yp_, rpar_, ipar_);
    for (j_ = 1; j_ <= (*neq_); (j_)++) {
      pv_[j_ - 1] = yp_[j_ - 1] - sf_[j_ - 1];
    }
    _l100:;
    fbnd_ = _max (fbnd_, _dhvnrm (yp_, neq_));
    delf_ = _dhvnrm (pv_, neq_);
    if (delf_ >= (*big_) * _abs (dely_)) {
      goto _l150;
    }
    dfdub_ = _max (dfdub_, delf_ / _abs (dely_));
    if (k_ == lk_) {
      goto _l160;
    }
    if (delf_ == 0.0e0) {
      delf_ = 1.0;
    }
    for (j_ = 1; j_ <= (*neq_); (j_)++) {
      if (k_ == 2) {
        goto _l110;
      }
      dy_ = _abs (pv_[j_ - 1]);
      if (dy_ == 0.0e0) {
        dy_ = delf_;
      }
      goto _l120;
      _l110:;
      dy_ = y_[j_ - 1];
      if (dy_ == 0.0e0) {
        dy_ = dely_ / relper_;
      }
      _l120:;
      if (spy_[j_ - 1] == 0.0e0) {
        spy_[j_ - 1] = yp_[j_ - 1];
      }
      if (spy_[j_ - 1] != 0.0e0) {
        dy_ = _sign (dy_, spy_[j_ - 1]);
      }
      yp_[j_ - 1] = dy_;
    }
    delf_ = _dhvnrm (yp_, neq_);
  }
  _l150:;
  dfdub_ = (*big_);
  _l160:;
  ydpb_ = dfdxb_ + dfdub_ * fbnd_;
  tolmin_ = (*big_);
  tolsum_ = 0.0;
  for (k_ = 1; k_ <= (*neq_); (k_)++) {
    tolexp_ = log10 (etol_[k_ - 1]);
    tolmin_ = _min (tolmin_, tolexp_);
    tolsum_ = tolsum_ + tolexp_;
  }
  tolp_ = pow (10.0e0, (0.5e0 * (tolsum_ / (*neq_) + tolmin_) / ((*morder_) + 1)));
  (*h_) = absdx_;
  if (ydpb_ != 0.0e0 || fbnd_ != 0.0e0) {
    goto _l180;
  }
  if (tolp_ < 1.0e0) {
    (*h_) = absdx_ * tolp_;
  }
  goto _l200;
  _l180:;
  if (ydpb_ != 0.0e0) {
    goto _l190;
  }
  if (tolp_ < fbnd_ * absdx_) {
    (*h_) = tolp_ / fbnd_;
  }
  goto _l200;
  _l190:;
  srydpb_ = sqrt (0.5e0 * ydpb_);
  if (tolp_ < srydpb_ * absdx_) {
    (*h_) = tolp_ / srydpb_;
  }
  _l200:;
  if ((*h_) * dfdub_ > 1.0e0) {
    (*h_) = 1.0e0 / dfdub_;
  }
  (*h_) = _max ((*h_), 100.0e0 * (*small_) * _abs ((*a_)));
  if ((*h_) == 0.0e0) {
    (*h_) = (*small_) * _abs ((*b_));
  }
  (*h_) = _sign ((*h_), dx_);
  __calls[101].calls++;
  return 0;
}

real_8 _dhvnrm (real_8 _p_ v_, int_4 _p_ ncomp_)
{
  static int_4 k_;
  real_8 dhvnrm_;
  dhvnrm_ = 0.0;
  for (k_ = 1; k_ <= (*ncomp_); (k_)++) {
    dhvnrm_ = _max (dhvnrm_, _abs (v_[k_ - 1]));
  }
  __calls[102].calls++;
  return dhvnrm_;
}

int_4 _djairy (real_8 _p_ x_, real_8 _p_ rx_, real_8 _p_ c_, real_8 _p_ ai_, real_8 _p_ dai_)
{
  static int_4 i_, j_, m1_, m1d_, m2_, m2d_, m3_, m3d_, m4_, m4d_, n1_, n1d_, n2_, n2d_, n3_, n3d_, n4_, n4d_;
  static real_8 a_[15], ajn_[19], ajp_[19], ak1_[14], ak2_[23], ak3_[14], b_[15], ccv_, con2_, con3_, con4_, con5_, cv_, 
  da_[15], dajn_[19], dajp_[19], dak1_[14], dak2_[24], dak3_[14], db_[15], ec_, e1_, e2_, fpi12_, f1_, f2_, rtrx_, scv_, 
  t_, temp1_, temp2_, tt_;
  int_4 _data_k_109, _data_k_110, _data_k_111, _data_k_112, _data_k_113, _data_k_114, _data_k_115, _data_k_116, 
  _data_k_117, _data_k_118, _data_k_119, _data_k_120, _data_k_121, _data_k_122, _data_k_123, _data_k_124, _data_k_125, 
  _data_k_126, _data_k_127;
#define _data_n_109 4
  static int_4 _data_l_109[_data_n_109] = {
    14,
    23,
    19,
    15
  };
#define _data_n_110 4
  static int_4 _data_l_110[_data_n_110] = {
    12,
    21,
    17,
    13
  };
#define _data_n_111 5
  static real_8 _data_l_111[_data_n_111] = {
    1.30899693899575e+00,
    5.03154716196777e+00,
    3.80004589867293e-1,
    8.33333333333333e-1,
    8.66025403784439e-1
  };
#define _data_n_112 14
  static real_8 _data_l_112[_data_n_112] = {
    2.20423090987793e-1,
    -1.252902427877e-1,
    1.03881163359194e-2,
    8.22844152006343e-4,
    -2.34614345891226e-4,
    1.63824280172116e-5,
    3.06902589573189e-7,
    -1.29621999359332e-7,
    8.22908158823668e-9,
    1.53963968623298e-11,
    -3.39165465615682e-11,
    2.03253257423626e-12,
    -1.10679546097884e-14,
    -5.1616949778508e-15
  };
#define _data_n_113 23
  static real_8 _data_l_113[_data_n_113] = {
    2.74366150869598e-1,
    5.39790969736903e-3,
    -1.5733922062119e-3,
    4.2742752824875e-4,
    -1.12124917399925e-4,
    2.88763171318904e-5,
    -7.36804225370554e-6,
    1.87290209741024e-6,
    -4.75892793962291e-7,
    1.21130416955909e-7,
    -3.09245374270614e-8,
    7.92454705282654e-9,
    -2.03902447167914e-9,
    5.26863056595742e-10,
    -1.36704767639569e-10,
    3.56141039013708e-11,
    -9.3138829654843e-12,
    2.44464450473635e-12,
    -6.43840261990955e-13,
    1.70106030559349e-13,
    -4.50760104503281e-14,
    1.19774799164811e-14,
    -3.19077040865066e-15
  };
#define _data_n_114 14
  static real_8 _data_l_114[_data_n_114] = {
    2.80271447340791e-1,
    -1.78127042844379e-3,
    4.03422579628999e-5,
    -1.63249965269003e-6,
    9.21181482476768e-8,
    -6.52294330229155e-9,
    5.47138404576546e-10,
    -5.2440825180026e-11,
    5.60477904117209e-12,
    -6.56375244639313e-13,
    8.31285761966247e-14,
    -1.12705134691063e-14,
    1.62267976598129e-15,
    -2.46480324312426e-16
  };
#define _data_n_115 19
  static real_8 _data_l_115[_data_n_115] = {
    7.78952966437581e-2,
    -1.84356363456801e-1,
    3.01412605216174e-2,
    3.05342724277608e-2,
    -4.95424702513079e-3,
    -1.72749552563952e-3,
    2.4313763783919e-4,
    5.04564777517082e-5,
    -6.16316582695208e-6,
    -9.03986745510768e-7,
    9.70243778355884e-8,
    1.09639453305205e-8,
    -1.04716330588766e-9,
    -9.60359441344646e-11,
    8.25358789454134e-12,
    6.36123439018768e-13,
    -4.96629614116015e-14,
    -3.29810288929615e-15,
    2.35798252031104e-16
  };
#define _data_n_116 19
  static real_8 _data_l_116[_data_n_116] = {
    3.80497887617242e-2,
    -2.45319541845546e-1,
    1.65820623702696e-1,
    7.49330045818789e-2,
    -2.63476288106641e-2,
    -5.92535597304981e-3,
    1.44744409589804e-3,
    2.18311831322215e-4,
    -4.10662077680304e-5,
    -4.66874994171766e-6,
    7.1521880727716e-7,
    6.52964770854633e-8,
    -8.44284027565946e-9,
    -6.44186158976978e-10,
    7.20802286505285e-11,
    4.72465431717846e-12,
    -4.66022632547045e-13,
    -2.67762710389189e-14,
    2.36161316570019e-15
  };
#define _data_n_117 15
  static real_8 _data_l_117[_data_n_117] = {
    4.90275424742791e-1,
    1.57647277946204e-3,
    -9.66195963140306e-5,
    1.35916080268815e-7,
    2.98157342654859e-7,
    -1.86824767559979e-8,
    -1.03685737667141e-9,
    3.28660818434328e-10,
    -2.5709141063278e-11,
    -2.32357655300677e-12,
    9.57523279048255e-13,
    -1.20340828049719e-13,
    -2.90907716770715e-15,
    4.55656454580149e-15,
    -9.99003874810259e-16
  };
#define _data_n_118 15
  static real_8 _data_l_118[_data_n_118] = {
    2.78593552803079e-1,
    -3.52915691882584e-3,
    -2.31149677384994e-5,
    4.7131784226356e-6,
    -1.12415907931333e-7,
    -2.00100301184339e-8,
    2.60948075302193e-9,
    -3.55098136101216e-11,
    -3.50849978423875e-11,
    5.83007187954202e-12,
    -2.04644828753326e-13,
    -1.10529179476742e-13,
    2.87724778038775e-14,
    -2.88205111009939e-15,
    -3.32656311696166e-16
  };
#define _data_n_119 4
  static int_4 _data_l_119[_data_n_119] = {
    14,
    24,
    19,
    15
  };
#define _data_n_120 4
  static int_4 _data_l_120[_data_n_120] = {
    12,
    22,
    17,
    13
  };
#define _data_n_121 14
  static real_8 _data_l_121[_data_n_121] = {
    2.04567842307887e-1,
    -6.61322739905664e-2,
    -8.49845800989287e-3,
    3.12183491556289e-3,
    -2.70016489829432e-4,
    -6.35636298679387e-6,
    3.02397712409509e-6,
    -2.18311195330088e-7,
    -5.36194289332826e-10,
    1.1309803562231e-9,
    -7.43023834629073e-11,
    4.28804170826891e-13,
    2.23810925754539e-13,
    -1.39140135641182e-14
  };
#define _data_n_122 24
  static real_8 _data_l_122[_data_n_122] = {
    2.9333234388323e-1,
    -8.06196784743112e-3,
    2.4254017233314e-3,
    -6.82297548850235e-4,
    1.85786427751181e-4,
    -4.97457447684059e-5,
    1.32090681239497e-5,
    -3.49528240444943e-6,
    9.24362451078835e-7,
    -2.44732671521867e-7,
    6.4930783764891e-8,
    -1.72717621501538e-8,
    4.60725763604656e-9,
    -1.2324905529155e-9,
    3.30620409488102e-10,
    -8.89252099772401e-11,
    2.39773319878298e-11,
    -6.4801392115345e-12,
    1.75510132023731e-12,
    -4.76303829833637e-13,
    1.2949824110081e-13,
    -3.5267962221043e-14,
    9.62005151585923e-15,
    -2.62786914342292e-15
  };
#define _data_n_123 14
  static real_8 _data_l_123[_data_n_123] = {
    2.84675828811349e-1,
    2.5307307261908e-3,
    -4.83481130337976e-5,
    1.84907283946343e-6,
    -1.01418491178576e-7,
    7.05925634457153e-9,
    -5.85325291400382e-10,
    5.56357688831339e-11,
    -5.908890947795e-12,
    6.88574353784436e-13,
    -8.68588256452194e-14,
    1.17374762617213e-14,
    -1.68523146510923e-15,
    2.55374773097056e-16
  };
#define _data_n_124 19
  static real_8 _data_l_124[_data_n_124] = {
    6.53219131311457e-2,
    -1.20262933688823e-1,
    9.78010236263823e-3,
    1.67948429230505e-2,
    -1.97146140182132e-3,
    -8.45560295098867e-4,
    9.42889620701976e-5,
    2.25827860945475e-5,
    -2.29067870915987e-6,
    -3.76343991136919e-7,
    3.45663933559565e-8,
    4.29611332003007e-9,
    -3.58673691214989e-10,
    -3.57245881361895e-11,
    2.72696091066336e-12,
    2.26120653095771e-13,
    -1.58763205238303e-14,
    -1.12604374485125e-15,
    7.31327529515367e-17
  };
#define _data_n_125 19
  static real_8 _data_l_125[_data_n_125] = {
    1.08594539632967e-2,
    8.53313194857091e-2,
    -3.15277068113058e-1,
    -8.78420725294257e-2,
    5.53251906976048e-2,
    9.41674060503241e-3,
    -3.32187026018996e-3,
    -4.11157343156826e-4,
    1.01297326891346e-4,
    9.87633682208396e-6,
    -1.87312969812393e-6,
    -1.50798500131468e-7,
    2.32687669525394e-8,
    1.59599917419225e-9,
    -2.07665922668385e-10,
    -1.24103350500302e-11,
    1.39631765331043e-12,
    7.3940097115574e-14,
    -7.328874756275e-15
  };
#define _data_n_126 15
  static real_8 _data_l_126[_data_n_126] = {
    4.91627321104601e-1,
    3.11164930427489e-3,
    8.23140762854081e-5,
    -4.61769776172142e-6,
    -6.13158880534626e-8,
    2.8729580465652e-8,
    -1.81959715372117e-9,
    -1.44752826642035e-10,
    4.53724043420422e-11,
    -3.99655065847223e-12,
    -3.24089119830323e-13,
    1.62098952568741e-13,
    -2.40765247974057e-14,
    1.69384811284491e-16,
    8.17900786477396e-16
  };
#define _data_n_127 15
  static real_8 _data_l_127[_data_n_127] = {
    -2.77571356944231e-1,
    4.4421283341992e-3,
    -8.42328522190089e-5,
    -2.5804031841871e-6,
    3.42389720217621e-7,
    -6.24286894709776e-9,
    -2.36377836844577e-9,
    3.16991042656673e-10,
    -4.40995691658191e-12,
    -5.18674221093575e-12,
    9.64874015137022e-13,
    -4.9019057660871e-14,
    -1.77253430678112e-14,
    5.55950610442662e-15,
    -7.1179333757953e-16
  };
  if (__calls[103].calls == 0) {
    _data_k_109 = 0;
    if (_data_k_109 >= _data_n_109) {
      _data_k_109 = 0;
    }
    n1_ = _data_l_109[_data_k_109++];
    if (_data_k_109 >= _data_n_109) {
      _data_k_109 = 0;
    }
    n2_ = _data_l_109[_data_k_109++];
    if (_data_k_109 >= _data_n_109) {
      _data_k_109 = 0;
    }
    n3_ = _data_l_109[_data_k_109++];
    if (_data_k_109 >= _data_n_109) {
      _data_k_109 = 0;
    }
    n4_ = _data_l_109[_data_k_109++];
  }
  if (__calls[103].calls == 0) {
    _data_k_110 = 0;
    if (_data_k_110 >= _data_n_110) {
      _data_k_110 = 0;
    }
    m1_ = _data_l_110[_data_k_110++];
    if (_data_k_110 >= _data_n_110) {
      _data_k_110 = 0;
    }
    m2_ = _data_l_110[_data_k_110++];
    if (_data_k_110 >= _data_n_110) {
      _data_k_110 = 0;
    }
    m3_ = _data_l_110[_data_k_110++];
    if (_data_k_110 >= _data_n_110) {
      _data_k_110 = 0;
    }
    m4_ = _data_l_110[_data_k_110++];
  }
  if (__calls[103].calls == 0) {
    _data_k_111 = 0;
    if (_data_k_111 >= _data_n_111) {
      _data_k_111 = 0;
    }
    fpi12_ = _data_l_111[_data_k_111++];
    if (_data_k_111 >= _data_n_111) {
      _data_k_111 = 0;
    }
    con2_ = _data_l_111[_data_k_111++];
    if (_data_k_111 >= _data_n_111) {
      _data_k_111 = 0;
    }
    con3_ = _data_l_111[_data_k_111++];
    if (_data_k_111 >= _data_n_111) {
      _data_k_111 = 0;
    }
    con4_ = _data_l_111[_data_k_111++];
    if (_data_k_111 >= _data_n_111) {
      _data_k_111 = 0;
    }
    con5_ = _data_l_111[_data_k_111++];
  }
  if (__calls[103].calls == 0) {
    _data_k_112 = 0;
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[0] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[1] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[2] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[3] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[4] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[5] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[6] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[7] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[8] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[9] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[10] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[11] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[12] = _data_l_112[_data_k_112++];
    if (_data_k_112 >= _data_n_112) {
      _data_k_112 = 0;
    }
    ak1_[13] = _data_l_112[_data_k_112++];
  }
  if (__calls[103].calls == 0) {
    _data_k_113 = 0;
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[0] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[1] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[2] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[3] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[4] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[5] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[6] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[7] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[8] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[9] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[10] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[11] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[12] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[13] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[14] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[15] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[16] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[17] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[18] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[19] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[20] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[21] = _data_l_113[_data_k_113++];
    if (_data_k_113 >= _data_n_113) {
      _data_k_113 = 0;
    }
    ak2_[22] = _data_l_113[_data_k_113++];
  }
  if (__calls[103].calls == 0) {
    _data_k_114 = 0;
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[0] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[1] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[2] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[3] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[4] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[5] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[6] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[7] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[8] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[9] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[10] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[11] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[12] = _data_l_114[_data_k_114++];
    if (_data_k_114 >= _data_n_114) {
      _data_k_114 = 0;
    }
    ak3_[13] = _data_l_114[_data_k_114++];
  }
  if (__calls[103].calls == 0) {
    _data_k_115 = 0;
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[0] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[1] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[2] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[3] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[4] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[5] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[6] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[7] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[8] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[9] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[10] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[11] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[12] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[13] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[14] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[15] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[16] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[17] = _data_l_115[_data_k_115++];
    if (_data_k_115 >= _data_n_115) {
      _data_k_115 = 0;
    }
    ajp_[18] = _data_l_115[_data_k_115++];
  }
  if (__calls[103].calls == 0) {
    _data_k_116 = 0;
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[0] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[1] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[2] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[3] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[4] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[5] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[6] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[7] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[8] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[9] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[10] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[11] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[12] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[13] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[14] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[15] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[16] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[17] = _data_l_116[_data_k_116++];
    if (_data_k_116 >= _data_n_116) {
      _data_k_116 = 0;
    }
    ajn_[18] = _data_l_116[_data_k_116++];
  }
  if (__calls[103].calls == 0) {
    _data_k_117 = 0;
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[0] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[1] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[2] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[3] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[4] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[5] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[6] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[7] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[8] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[9] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[10] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[11] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[12] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[13] = _data_l_117[_data_k_117++];
    if (_data_k_117 >= _data_n_117) {
      _data_k_117 = 0;
    }
    a_[14] = _data_l_117[_data_k_117++];
  }
  if (__calls[103].calls == 0) {
    _data_k_118 = 0;
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[0] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[1] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[2] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[3] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[4] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[5] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[6] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[7] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[8] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[9] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[10] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[11] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[12] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[13] = _data_l_118[_data_k_118++];
    if (_data_k_118 >= _data_n_118) {
      _data_k_118 = 0;
    }
    b_[14] = _data_l_118[_data_k_118++];
  }
  if (__calls[103].calls == 0) {
    _data_k_119 = 0;
    if (_data_k_119 >= _data_n_119) {
      _data_k_119 = 0;
    }
    n1d_ = _data_l_119[_data_k_119++];
    if (_data_k_119 >= _data_n_119) {
      _data_k_119 = 0;
    }
    n2d_ = _data_l_119[_data_k_119++];
    if (_data_k_119 >= _data_n_119) {
      _data_k_119 = 0;
    }
    n3d_ = _data_l_119[_data_k_119++];
    if (_data_k_119 >= _data_n_119) {
      _data_k_119 = 0;
    }
    n4d_ = _data_l_119[_data_k_119++];
  }
  if (__calls[103].calls == 0) {
    _data_k_120 = 0;
    if (_data_k_120 >= _data_n_120) {
      _data_k_120 = 0;
    }
    m1d_ = _data_l_120[_data_k_120++];
    if (_data_k_120 >= _data_n_120) {
      _data_k_120 = 0;
    }
    m2d_ = _data_l_120[_data_k_120++];
    if (_data_k_120 >= _data_n_120) {
      _data_k_120 = 0;
    }
    m3d_ = _data_l_120[_data_k_120++];
    if (_data_k_120 >= _data_n_120) {
      _data_k_120 = 0;
    }
    m4d_ = _data_l_120[_data_k_120++];
  }
  if (__calls[103].calls == 0) {
    _data_k_121 = 0;
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[0] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[1] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[2] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[3] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[4] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[5] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[6] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[7] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[8] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[9] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[10] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[11] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[12] = _data_l_121[_data_k_121++];
    if (_data_k_121 >= _data_n_121) {
      _data_k_121 = 0;
    }
    dak1_[13] = _data_l_121[_data_k_121++];
  }
  if (__calls[103].calls == 0) {
    _data_k_122 = 0;
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[0] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[1] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[2] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[3] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[4] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[5] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[6] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[7] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[8] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[9] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[10] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[11] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[12] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[13] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[14] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[15] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[16] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[17] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[18] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[19] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[20] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[21] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[22] = _data_l_122[_data_k_122++];
    if (_data_k_122 >= _data_n_122) {
      _data_k_122 = 0;
    }
    dak2_[23] = _data_l_122[_data_k_122++];
  }
  if (__calls[103].calls == 0) {
    _data_k_123 = 0;
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[0] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[1] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[2] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[3] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[4] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[5] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[6] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[7] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[8] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[9] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[10] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[11] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[12] = _data_l_123[_data_k_123++];
    if (_data_k_123 >= _data_n_123) {
      _data_k_123 = 0;
    }
    dak3_[13] = _data_l_123[_data_k_123++];
  }
  if (__calls[103].calls == 0) {
    _data_k_124 = 0;
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[0] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[1] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[2] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[3] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[4] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[5] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[6] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[7] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[8] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[9] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[10] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[11] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[12] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[13] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[14] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[15] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[16] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[17] = _data_l_124[_data_k_124++];
    if (_data_k_124 >= _data_n_124) {
      _data_k_124 = 0;
    }
    dajp_[18] = _data_l_124[_data_k_124++];
  }
  if (__calls[103].calls == 0) {
    _data_k_125 = 0;
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[0] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[1] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[2] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[3] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[4] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[5] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[6] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[7] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[8] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[9] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[10] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[11] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[12] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[13] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[14] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[15] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[16] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[17] = _data_l_125[_data_k_125++];
    if (_data_k_125 >= _data_n_125) {
      _data_k_125 = 0;
    }
    dajn_[18] = _data_l_125[_data_k_125++];
  }
  if (__calls[103].calls == 0) {
    _data_k_126 = 0;
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[0] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[1] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[2] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[3] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[4] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[5] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[6] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[7] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[8] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[9] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[10] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[11] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[12] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[13] = _data_l_126[_data_k_126++];
    if (_data_k_126 >= _data_n_126) {
      _data_k_126 = 0;
    }
    da_[14] = _data_l_126[_data_k_126++];
  }
  if (__calls[103].calls == 0) {
    _data_k_127 = 0;
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[0] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[1] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[2] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[3] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[4] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[5] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[6] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[7] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[8] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[9] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[10] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[11] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[12] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[13] = _data_l_127[_data_k_127++];
    if (_data_k_127 >= _data_n_127) {
      _data_k_127 = 0;
    }
    db_[14] = _data_l_127[_data_k_127++];
  }
  if ((*x_) < 0.0e0) {
    goto _l90;
  }
  if ((*c_) > 5.0e0) {
    goto _l60;
  }
  if ((*x_) > 1.2e0) {
    goto _l30;
  }
  t_ = ((*x_) + (*x_) - 1.2e0) * con4_;
  tt_ = t_ + t_;
  j_ = n1_;
  f1_ = ak1_[j_ - 1];
  f2_ = 0.0;
  for (i_ = 1; i_ <= m1_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    f1_ = tt_ * f1_ - f2_ + ak1_[j_ - 1];
    f2_ = temp1_;
  }
  (*ai_) = t_ * f1_ - f2_ + ak1_[0];
  j_ = n1d_;
  f1_ = dak1_[j_ - 1];
  f2_ = 0.0;
  for (i_ = 1; i_ <= m1d_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    f1_ = tt_ * f1_ - f2_ + dak1_[j_ - 1];
    f2_ = temp1_;
  }
  (*dai_) = -(t_ * f1_ - f2_ + dak1_[0]);
  goto _l0;
  _l30:;
  t_ = ((*x_) + (*x_) - con2_) * con3_;
  tt_ = t_ + t_;
  j_ = n2_;
  f1_ = ak2_[j_ - 1];
  f2_ = 0.0;
  for (i_ = 1; i_ <= m2_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    f1_ = tt_ * f1_ - f2_ + ak2_[j_ - 1];
    f2_ = temp1_;
  }
  rtrx_ = sqrt ((*rx_));
  ec_ = exp (-(*c_));
  (*ai_) = ec_ * (t_ * f1_ - f2_ + ak2_[0]) / rtrx_;
  j_ = n2d_;
  f1_ = dak2_[j_ - 1];
  f2_ = 0.0;
  for (i_ = 1; i_ <= m2d_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    f1_ = tt_ * f1_ - f2_ + dak2_[j_ - 1];
    f2_ = temp1_;
  }
  (*dai_) = -ec_ * (t_ * f1_ - f2_ + dak2_[0]) * rtrx_;
  goto _l0;
  _l60:;
  t_ = 10.0e0 / (*c_) - 1.0e0;
  tt_ = t_ + t_;
  j_ = n1_;
  f1_ = ak3_[j_ - 1];
  f2_ = 0.0;
  for (i_ = 1; i_ <= m1_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    f1_ = tt_ * f1_ - f2_ + ak3_[j_ - 1];
    f2_ = temp1_;
  }
  rtrx_ = sqrt ((*rx_));
  ec_ = exp (-(*c_));
  (*ai_) = ec_ * (t_ * f1_ - f2_ + ak3_[0]) / rtrx_;
  j_ = n1d_;
  f1_ = dak3_[j_ - 1];
  f2_ = 0.0;
  for (i_ = 1; i_ <= m1d_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    f1_ = tt_ * f1_ - f2_ + dak3_[j_ - 1];
    f2_ = temp1_;
  }
  (*dai_) = -rtrx_ * ec_ * (t_ * f1_ - f2_ + dak3_[0]);
  goto _l0;
  _l90:;
  if ((*c_) > 5.0e0) {
    goto _l120;
  }
  t_ = 0.4e0 * (*c_) - 1.0e0;
  tt_ = t_ + t_;
  j_ = n3_;
  f1_ = ajp_[j_ - 1];
  e1_ = ajn_[j_ - 1];
  f2_ = 0.0;
  e2_ = 0.0;
  for (i_ = 1; i_ <= m3_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    temp2_ = e1_;
    f1_ = tt_ * f1_ - f2_ + ajp_[j_ - 1];
    e1_ = tt_ * e1_ - e2_ + ajn_[j_ - 1];
    f2_ = temp1_;
    e2_ = temp2_;
  }
  (*ai_) = (t_ * e1_ - e2_ + ajn_[0]) - (*x_) * (t_ * f1_ - f2_ + ajp_[0]);
  j_ = n3d_;
  f1_ = dajp_[j_ - 1];
  e1_ = dajn_[j_ - 1];
  f2_ = 0.0;
  e2_ = 0.0;
  for (i_ = 1; i_ <= m3d_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    temp2_ = e1_;
    f1_ = tt_ * f1_ - f2_ + dajp_[j_ - 1];
    e1_ = tt_ * e1_ - e2_ + dajn_[j_ - 1];
    f2_ = temp1_;
    e2_ = temp2_;
  }
  (*dai_) = (*x_) * (*x_) * (t_ * f1_ - f2_ + dajp_[0]) + (t_ * e1_ - e2_ + dajn_[0]);
  goto _l0;
  _l120:;
  t_ = 10.0e0 / (*c_) - 1.0e0;
  tt_ = t_ + t_;
  j_ = n4_;
  f1_ = a_[j_ - 1];
  e1_ = b_[j_ - 1];
  f2_ = 0.0;
  e2_ = 0.0;
  for (i_ = 1; i_ <= m4_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    temp2_ = e1_;
    f1_ = tt_ * f1_ - f2_ + a_[j_ - 1];
    e1_ = tt_ * e1_ - e2_ + b_[j_ - 1];
    f2_ = temp1_;
    e2_ = temp2_;
  }
  temp1_ = t_ * f1_ - f2_ + a_[0];
  temp2_ = t_ * e1_ - e2_ + b_[0];
  rtrx_ = sqrt ((*rx_));
  cv_ = (*c_) - fpi12_;
  ccv_ = cos (cv_);
  scv_ = sin (cv_);
  (*ai_) = (temp1_ * ccv_ - temp2_ * scv_) / rtrx_;
  j_ = n4d_;
  f1_ = da_[j_ - 1];
  e1_ = db_[j_ - 1];
  f2_ = 0.0;
  e2_ = 0.0;
  for (i_ = 1; i_ <= m4d_; (i_)++) {
    j_ = j_ - 1;
    temp1_ = f1_;
    temp2_ = e1_;
    f1_ = tt_ * f1_ - f2_ + da_[j_ - 1];
    e1_ = tt_ * e1_ - e2_ + db_[j_ - 1];
    f2_ = temp1_;
    e2_ = temp2_;
  }
  temp1_ = t_ * f1_ - f2_ + da_[0];
  temp2_ = t_ * e1_ - e2_ + db_[0];
  e1_ = ccv_ * con5_ + 0.5e0 * scv_;
  e2_ = scv_ * con5_ - 0.5e0 * ccv_;
  (*dai_) = (temp1_ * e1_ - temp2_ * e2_) * rtrx_;
  _l0:;
  __calls[103].calls++;
  return 0;
}

int_4 _dllsia (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n_, real_8 _p_ b_, int_4 _p_ mdb_, int_4 _p_ nb_, 
real_8 _p_ re_, real_8 _p_ ae_, int_4 _p_ key_, int_4 _p_ mode_, int_4 _p_ np_, int_4 _p_ krank_, int_4 _p_ ksure_, 
real_8 _p_ rnorm_, real_8 _p_ w_, int_4 _p_ lw_, int_4 _p_ iwork_, int_4 _p_ liw_, int_4 _p_ info_)
{
  static int_4 it_, n1_, n2_, n3_, n4_, n5_, i_;
  static real_8 eps_;
  int_4 $0_, $1_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $12_, $13_, $14_, $15_;
  extern real_8 _d1mach ();
  if ((*info_) < 0 || (*info_) > 1) {
    goto _l514;
  }
  it_ = (*info_);
  (*info_) = -1;
  if ((*nb_) == 0 && it_ == 1) {
    goto _l501;
  }
  if ((*m_) < 1) {
    goto _l502;
  }
  if ((*n_) < 1) {
    goto _l503;
  }
  if ((*n_) > (*m_)) {
    goto _l504;
  }
  if ((*mda_) < (*m_)) {
    goto _l505;
  }
  if ((*liw_) < (*m_) + (*n_)) {
    goto _l506;
  }
  if ((*mode_) < 0 || (*mode_) > 3) {
    goto _l515;
  }
  if ((*nb_) == 0) {
    goto _l4;
  }
  if ((*nb_) < 0) {
    goto _l507;
  }
  if ((*mdb_) < (*m_)) {
    goto _l508;
  }
  if (it_ == 0) {
    goto _l4;
  }
  goto _l400;
  _l4:;
  if ((*key_) < 0 || (*key_) > 3) {
    goto _l509;
  }
  if ((*key_) == 0 && (*lw_) < 5 * (*n_)) {
    goto _l510;
  }
  if ((*key_) == 1 && (*lw_) < 4 * (*n_)) {
    goto _l510;
  }
  if ((*key_) == 2 && (*lw_) < 4 * (*n_)) {
    goto _l510;
  }
  if ((*key_) == 3 && (*lw_) < 3 * (*n_)) {
    goto _l510;
  }
  if ((*np_) < 0 || (*np_) > (*n_)) {
    goto _l516;
  }
  eps_ = 10.0 * _d1mach (($0_ = 3, &$0_));
  n1_ = 1;
  n2_ = n1_ + (*n_);
  n3_ = n2_ + (*n_);
  n4_ = n3_ + (*n_);
  n5_ = n4_ + (*n_);
  if ((*key_) == 1) {
    goto _l100;
  }
  if ((*key_) == 2) {
    goto _l200;
  }
  if ((*key_) == 3) {
    goto _l300;
  }
  if (re_[0] < 0.0e0) {
    goto _l511;
  }
  if (re_[0] > 1.0e0) {
    goto _l512;
  }
  if (re_[0] < eps_) {
    re_[0] = eps_;
  }
  if (ae_[0] < 0.0e0) {
    goto _l513;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[n4_ - 1 + i_ - 1] = re_[0];
    w_[n5_ - 1 + i_ - 1] = ae_[0];
  }
  (void) _du11ls (a_, mda_, m_, n_, &w_[n4_ - 1], &w_[n5_ - 1], mode_, np_, krank_, ksure_, &w_[n1_ - 1], &w_[n2_ - 1], 
  &w_[n3_ - 1], &iwork_[n1_ - 1], &iwork_[n2_ - 1]);
  goto _l400;
  _l100:;
  if (ae_[0] < 0.0e0) {
    goto _l513;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (re_[i_ - 1] < 0.0e0) {
      goto _l511;
    }
    if (re_[i_ - 1] > 1.0e0) {
      goto _l512;
    }
    if (re_[i_ - 1] < eps_) {
      re_[i_ - 1] = eps_;
    }
    w_[n4_ - 1 + i_ - 1] = ae_[0];
  }
  (void) _du11ls (a_, mda_, m_, n_, re_, &w_[n4_ - 1], mode_, np_, krank_, ksure_, &w_[n1_ - 1], &w_[n2_ - 1], &w_[n3_ - 
  1], &iwork_[n1_ - 1], &iwork_[n2_ - 1]);
  goto _l400;
  _l200:;
  if (re_[0] < 0.0e0) {
    goto _l511;
  }
  if (re_[0] > 1.0e0) {
    goto _l512;
  }
  if (re_[0] < eps_) {
    re_[0] = eps_;
  }
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    w_[n4_ - 1 + i_ - 1] = re_[0];
    if (ae_[i_ - 1] < 0.0e0) {
      goto _l513;
    }
  }
  (void) _du11ls (a_, mda_, m_, n_, &w_[n4_ - 1], ae_, mode_, np_, krank_, ksure_, &w_[n1_ - 1], &w_[n2_ - 1], &w_[n3_ - 
  1], &iwork_[n1_ - 1], &iwork_[n2_ - 1]);
  goto _l400;
  _l300:;
  for (i_ = 1; i_ <= (*n_); (i_)++) {
    if (re_[i_ - 1] < 0.0e0) {
      goto _l511;
    }
    if (re_[i_ - 1] > 1.0e0) {
      goto _l512;
    }
    if (re_[i_ - 1] < eps_) {
      re_[i_ - 1] = eps_;
    }
    if (ae_[i_ - 1] < 0.0e0) {
      goto _l513;
    }
  }
  (void) _du11ls (a_, mda_, m_, n_, re_, ae_, mode_, np_, krank_, ksure_, &w_[n1_ - 1], &w_[n2_ - 1], &w_[n3_ - 1], 
  &iwork_[n1_ - 1], &iwork_[n2_ - 1]);
  _l400:;
  if ((*krank_) != (*n_)) {
    goto _l402;
  }
  (*info_) = 5;
  goto _l410;
  _l402:;
  if ((*krank_) != 0) {
    goto _l404;
  }
  (*info_) = 3;
  goto _l410;
  _l404:;
  if ((*krank_) >= (*np_)) {
    goto _l406;
  }
  (*info_) = 4;
  goto _l0;
  _l406:;
  (*info_) = (*mode_);
  if ((*mode_) == 0) {
    goto _l0;
  }
  _l410:;
  if ((*nb_) == 0) {
    goto _l0;
  }
  n1_ = 1;
  n2_ = n1_ + (*n_);
  n3_ = n2_ + (*n_);
  if ((*info_) == 2) {
    goto _l420;
  }
  if ((*lw_) < n2_ - 1) {
    goto _l510;
  }
  (void) _du12ls (a_, mda_, m_, n_, b_, mdb_, nb_, mode_, krank_, rnorm_, &w_[n1_ - 1], &w_[n1_ - 1], &iwork_[n1_ - 1], 
  &iwork_[n2_ - 1]);
  goto _l0;
  _l420:;
  if ((*lw_) < n3_ - 1) {
    goto _l510;
  }
  (void) _du12ls (a_, mda_, m_, n_, b_, mdb_, nb_, mode_, krank_, rnorm_, &w_[n1_ - 1], &w_[n2_ - 1], &iwork_[n1_ - 1], 
  &iwork_[n2_ - 1]);
  goto _l0;
  _l501:;
  (void) _xermsg (_dc_1, _dc_298, _dc_299, &_k1, &_k0);
  goto _l0;
  _l502:;
  (void) _xermsg (_dc_1, _dc_298, _dc_300, ($1_ = 2, &$1_), &_k1);
  goto _l0;
  _l503:;
  (void) _xermsg (_dc_1, _dc_298, _dc_301, ($2_ = 2, &$2_), &_k1);
  goto _l0;
  _l504:;
  (void) _xermsg (_dc_1, _dc_298, _dc_302, ($3_ = 2, &$3_), &_k1);
  goto _l0;
  _l505:;
  (void) _xermsg (_dc_1, _dc_298, _dc_303, ($4_ = 2, &$4_), &_k1);
  goto _l0;
  _l506:;
  (void) _xermsg (_dc_1, _dc_298, _dc_304, ($5_ = 2, &$5_), &_k1);
  goto _l0;
  _l507:;
  (void) _xermsg (_dc_1, _dc_298, _dc_305, ($6_ = 2, &$6_), &_k1);
  goto _l0;
  _l508:;
  (void) _xermsg (_dc_1, _dc_298, _dc_306, ($7_ = 2, &$7_), &_k1);
  goto _l0;
  _l509:;
  (void) _xermsg (_dc_1, _dc_298, _dc_307, ($8_ = 2, &$8_), &_k1);
  goto _l0;
  _l510:;
  (void) _xermsg (_dc_1, _dc_298, _dc_308, ($9_ = 8, &$9_), &_k1);
  (*info_) = -1;
  goto _l0;
  _l511:;
  (void) _xermsg (_dc_1, _dc_298, _dc_309, ($10_ = 2, &$10_), &_k1);
  goto _l0;
  _l512:;
  (void) _xermsg (_dc_1, _dc_298, _dc_310, ($11_ = 2, &$11_), &_k1);
  goto _l0;
  _l513:;
  (void) _xermsg (_dc_1, _dc_298, _dc_311, ($12_ = 2, &$12_), &_k1);
  goto _l0;
  _l514:;
  (void) _xermsg (_dc_1, _dc_298, _dc_312, ($13_ = 2, &$13_), &_k1);
  goto _l0;
  _l515:;
  (void) _xermsg (_dc_1, _dc_298, _dc_313, ($14_ = 2, &$14_), &_k1);
  goto _l0;
  _l516:;
  (void) _xermsg (_dc_1, _dc_298, _dc_314, ($15_ = 2, &$15_), &_k1);
  _l0:;
  __calls[104].calls++;
  return 0;
}

int_4 _dlpdp (real_8 _p_ a_, int_4 _p_ mda_, int_4 _p_ m_, int_4 _p_ n1_, int_4 _p_ n2_, real_8 _p_ prgopt_, real_8 _p_ 
x_, real_8 _p_ wnorm_, int_4 _p_ mode_, real_8 _p_ ws_, int_4 _p_ is_)
{
  static int_4 i_, iw_, ix_, j_, l_, modew_, n_, np1_;
  static real_8 fac_, one_, rnorm_, sc_, ynorm_, zero_;
  int_4 _data_k_128, _data_k_129, $0_, $1_, $2_;
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
#define _data_n_128 2
  static real_8 _data_l_128[_data_n_128] = {
    0.0e0,
    1.0e0
  };
#define _data_n_129 1
  static real_8 _data_l_129[_data_n_129] = {
    0.1e0
  };
  if (__calls[105].calls == 0) {
    _data_k_128 = 0;
    if (_data_k_128 >= _data_n_128) {
      _data_k_128 = 0;
    }
    zero_ = _data_l_128[_data_k_128++];
    if (_data_k_128 >= _data_n_128) {
      _data_k_128 = 0;
    }
    one_ = _data_l_128[_data_k_128++];
    _data_k_129 = 0;
    if (_data_k_129 >= _data_n_129) {
      _data_k_129 = 0;
    }
    fac_ = _data_l_129[_data_k_129++];
  }
  n_ = (*n1_) + (*n2_);
  (*mode_) = 1;
  if ((*m_) > 0) {
    goto _l20;
  }
  if (n_ <= 0) {
    goto _l10;
  }
  x_[0] = zero_;
  (void) _dcopy (&n_, x_, &_k0, x_, &_k1);
  _l10:;
  (*wnorm_) = zero_;
  goto _l200;
  _l20:;
  np1_ = n_ + 1;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    sc_ = _dnrm2 (&n_, &a_[i_ - 1 + ((*mda_)) * ((0))], mda_);
    if (sc_ == zero_) {
      goto _l30;
    }
    sc_ = one_ / sc_;
    (void) _dscal (&np1_, &sc_, &a_[i_ - 1 + ((*mda_)) * ((0))], mda_);
    _l30:;
  }
  ynorm_ = _dnrm2 (m_, &a_[0 + ((*mda_)) * ((np1_ - 1))], &_k1);
  if (ynorm_ == zero_) {
    goto _l50;
  }
  sc_ = one_ / ynorm_;
  (void) _dscal (m_, &sc_, &a_[0 + ((*mda_)) * ((np1_ - 1))], &_k1);
  _l50:;
  j_ = (*n1_) + 1;
  _l60:;
  if (j_ > n_) {
    goto _l70;
  }
  sc_ = _dnrm2 (m_, &a_[0 + ((*mda_)) * ((j_ - 1))], &_k1);
  if (sc_ != zero_) {
    sc_ = one_ / sc_;
  }
  (void) _dscal (m_, &sc_, &a_[0 + ((*mda_)) * ((j_ - 1))], &_k1);
  x_[j_ - 1] = sc_;
  j_ = j_ + 1;
  goto _l60;
  _l70:;
  if ((*n1_) <= 0) {
    goto _l130;
  }
  iw_ = 0;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    (void) _dcopy (n2_, &a_[i_ - 1 + ((*mda_)) * (((*n1_) + 1 - 1))], mda_, &ws_[iw_ + 1 - 1], &_k1);
    iw_ = iw_ + (*n2_);
    (void) _dcopy (n1_, &a_[i_ - 1 + ((*mda_)) * ((0))], mda_, &ws_[iw_ + 1 - 1], &_k1);
    iw_ = iw_ + (*n1_);
    ws_[iw_ + 1 - 1] = a_[i_ - 1 + ((*mda_)) * ((np1_ - 1))];
    iw_ = iw_ + 1;
  }
  ws_[iw_ + 1 - 1] = zero_;
  (void) _dcopy (&n_, &ws_[iw_ + 1 - 1], &_k0, &ws_[iw_ + 1 - 1], &_k1);
  iw_ = iw_ + n_;
  ws_[iw_ + 1 - 1] = one_;
  iw_ = iw_ + 1;
  ix_ = iw_ + 1;
  iw_ = iw_ + (*m_);
  is_[0] = 0;
  is_[1] = 0;
  (void) _dwnnls (ws_, &np1_, n2_, ($0_ = np1_ - (*n2_), &$0_), m_, &_k0, prgopt_, &ws_[ix_ - 1], &rnorm_, &modew_, is_, 
  &ws_[iw_ + 1 - 1]);
  sc_ = one_ - _ddot (m_, &a_[0 + ((*mda_)) * ((np1_ - 1))], &_k1, &ws_[ix_ - 1], &_k1);
  if (one_ + fac_ * _abs (sc_) == one_ || rnorm_ <= zero_) {
    goto _l110;
  }
  sc_ = one_ / sc_;
  for (j_ = 1; j_ <= (*n1_); (j_)++) {
    x_[j_ - 1] = sc_ * _ddot (m_, &a_[0 + ((*mda_)) * ((j_ - 1))], &_k1, &ws_[ix_ - 1], &_k1);
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    a_[i_ - 1 + ((*mda_)) * ((np1_ - 1))] = a_[i_ - 1 + ((*mda_)) * ((np1_ - 1))] - _ddot (n1_, &a_[i_ - 1 + ((*mda_)) * 
    ((0))], mda_, x_, &_k1);
  }
  goto _l120;
  _l110:;
  (*mode_) = 2;
  goto _l190;
  _l120:;
  _l130:;
  if ((*n2_) <= 0) {
    goto _l180;
  }
  iw_ = 0;
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    (void) _dcopy (n2_, &a_[i_ - 1 + ((*mda_)) * (((*n1_) + 1 - 1))], mda_, &ws_[iw_ + 1 - 1], &_k1);
    iw_ = iw_ + (*n2_);
    ws_[iw_ + 1 - 1] = a_[i_ - 1 + ((*mda_)) * ((np1_ - 1))];
    iw_ = iw_ + 1;
  }
  ws_[iw_ + 1 - 1] = zero_;
  (void) _dcopy (n2_, &ws_[iw_ + 1 - 1], &_k0, &ws_[iw_ + 1 - 1], &_k1);
  iw_ = iw_ + (*n2_);
  ws_[iw_ + 1 - 1] = one_;
  iw_ = iw_ + 1;
  ix_ = iw_ + 1;
  iw_ = iw_ + (*m_);
  is_[0] = 0;
  is_[1] = 0;
  (void) _dwnnls (ws_, ($1_ = (*n2_) + 1, &$1_), &_k0, ($2_ = (*n2_) + 1, &$2_), m_, &_k0, prgopt_, &ws_[ix_ - 1], 
  &rnorm_, &modew_, is_, &ws_[iw_ + 1 - 1]);
  sc_ = one_ - _ddot (m_, &a_[0 + ((*mda_)) * ((np1_ - 1))], &_k1, &ws_[ix_ - 1], &_k1);
  if (one_ + fac_ * _abs (sc_) == one_ || rnorm_ <= zero_) {
    goto _l160;
  }
  sc_ = one_ / sc_;
  for (j_ = 1; j_ <= (*n2_); (j_)++) {
    l_ = (*n1_) + j_;
    x_[l_ - 1] = sc_ * _ddot (m_, &a_[0 + ((*mda_)) * ((l_ - 1))], &_k1, &ws_[ix_ - 1], &_k1) * x_[l_ - 1];
  }
  goto _l170;
  _l160:;
  (*mode_) = 2;
  goto _l190;
  _l170:;
  _l180:;
  (void) _dscal (&n_, &ynorm_, x_, &_k1);
  (*wnorm_) = _dnrm2 (n1_, x_, &_k1);
  _l190:;
  _l200:;
  __calls[105].calls++;
  return 0;
}

int_4 _dlsei (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ me_, int_4 _p_ ma_, int_4 _p_ mg_, int_4 _p_ n_, real_8 _p_ 
prgopt_, real_8 _p_ x_, real_8 _p_ rnorme_, real_8 _p_ rnorml_, int_4 _p_ mode_, real_8 _p_ ws_, int_4 _p_ ip_)
{
  static int_4 i_, imax_, j_, jp1_, k_, key_, kranke_, last_, lchk_, link_, m_, mapke1_, mdeqc_, mend_, mep1_, n1_, n2_, 
  next_, nlink_, nopt_, np1_, ntimes_;
  static logical_4 cov_, first_;
  static real_8 drelpr_, enorm_, fnorm_, gam_, rb_, rn_, rnmax_, size_, sn_, snmax_, t_, tau_, uj_, up_, vj_, xnorm_, 
  xnrme_;
  static char_15 xern1_, xern2_, xern3_, xern4_;
  int_4 _data_k_130, $0_, $1_, __fcnt, __rc, $12_, $16_, $20_, $21_, $23_, $24_, $25_, $26_, $27_, $28_, $29_, $30_, $31_
  , $32_, $33_, $34_, $35_, $36_, $37_, $38_, $40_, $41_, $42_, $43_, $44_, $45_, $46_, $47_, $48_, $49_;
  real_8 $22_, $39_;
  char_63 $13_;
  char_127 $2_, $14_, $15_, $17_;
  char_255 $3_, $18_, $19_;
  char_511 $4_;
  char_1023 $5_;
  char_2047 $6_;
  char_4095 $7_, $8_, $9_, $10_, $11_;
  extern real_8 _d1mach ();
  extern real_8 _dasum ();
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern real_8 _ddot ();
  extern real_8 _dnrm2 ();
  extern int_4 _dscal ();
  extern int_4 _dswap ();
  extern int_4 _xermsg ();
  static FORMAT $f_100017_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100018_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100019_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100020_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100027_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
  static FORMAT $f_100035_[] = {
    FMT_INT,"%8d","%8d",
    NULL, NULL, NULL
  };
#define _data_n_130 1
  static logical_4 _data_l_130[_data_n_130] = {
    TRUE
  };
  if (__calls[106].calls == 0) {
    _data_k_130 = 0;
    if (_data_k_130 >= _data_n_130) {
      _data_k_130 = 0;
    }
    first_ = _data_l_130[_data_k_130++];
  }
  if (first_) {
    drelpr_ = _d1mach (($0_ = 4, &$0_));
  }
  first_ = FALSE;
  tau_ = sqrt (drelpr_);
  (*mode_) = 4;
  if (($1_ = _min ((*n_), (*me_)), $1_ = _min ($1_, (*ma_)), _min ($1_, (*mg_))) < 0) {
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern1_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dlsei:416", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:416", 0));
      __fcnt += 3;
    }
    if ($f_100017_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:416", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100017_[__fcnt + 2], &(*n_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:416", 0));
    __fcnt += 3;
    while ($f_100017_[__fcnt] != NULL && $f_100017_[__fcnt] == FMT_TEXT) {
      if ($f_100017_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100017_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:416", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern2_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern2_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dlsei:417", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100018_[__fcnt] != NULL && $f_100018_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100018_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:417", 0));
      __fcnt += 3;
    }
    if ($f_100018_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100018_[__fcnt] != NULL && $f_100018_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100018_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:417", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100018_[__fcnt + 2], &(*me_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:417", 0));
    __fcnt += 3;
    while ($f_100018_[__fcnt] != NULL && $f_100018_[__fcnt] == FMT_TEXT) {
      if ($f_100018_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100018_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:417", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern3_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern3_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dlsei:418", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:418", 0));
      __fcnt += 3;
    }
    if ($f_100019_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:418", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100019_[__fcnt + 2], &(*ma_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:418", 0));
    __fcnt += 3;
    while ($f_100019_[__fcnt] != NULL && $f_100019_[__fcnt] == FMT_TEXT) {
      if ($f_100019_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100019_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:418", 0));
      __fcnt += 3;
    }
    _ffile[0].buff = _ffile[0].rewind = (char *) (xern4_);
    _ffile[0].lrecl = 15;
    _ffile[0].record = 0;
    _ffile[0].records = 1;
    _ffile[0].unit = fmemopen (xern4_, 15, "w");
    _ffile[0].buff_init = FALSE;
    _fcheck ("slatec:dlsei:419", 0, action_write, form_formatted);
    __fcnt = 0;
    while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
      __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:419", 0));
      __fcnt += 3;
    }
    if ($f_100020_[__fcnt] == NULL) {
      __fcnt = 0;
      __rc = fprintf (_ffile[0].unit, "\n");
      while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:419", 0));
        __fcnt += 3;
      }
    };
    __rc = _vif_printf (0, $f_100020_[__fcnt + 2], &(*mg_), INTEGER, 4);
    _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:419", 0));
    __fcnt += 3;
    while ($f_100020_[__fcnt] != NULL && $f_100020_[__fcnt] == FMT_TEXT) {
      if ($f_100020_[__fcnt + 2] == FMT_TERM) {
        break;
      }
      __rc = _vif_printf (0, $f_100020_[__fcnt + 2], NULL, NOTYPE, 0);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:419", 0));
      __fcnt += 3;
    }
    (void) _xermsg (_dc_1, _dc_315, (bufcpy ($11_, concat ($10_, concat ($9_, concat ($8_, concat ($7_, concat ($6_, concat 
    ($5_, concat ($4_, concat ($3_, concat ($2_, _dc_316, _dc_317), _dc_318), xern1_), _dc_319), xern2_), _dc_320), 
    xern3_), _dc_321), xern4_), 4095), $11_), ($12_ = 2, &$12_), &_k1);
    goto _l0;
  }
  if (ip_[0] > 0) {
    lchk_ = 2 * ((*me_) + (*n_)) + _max ((*ma_) + (*mg_), (*n_)) + ((*mg_) + 2) * ((*n_) + 7);
    if (ip_[0] < lchk_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dlsei:432", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:432", 0));
        __fcnt += 3;
      }
      if ($f_100027_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:432", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100027_[__fcnt + 2], &lchk_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:432", 0));
      __fcnt += 3;
      while ($f_100027_[__fcnt] != NULL && $f_100027_[__fcnt] == FMT_TEXT) {
        if ($f_100027_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100027_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:432", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_322, (bufcpy ($15_, concat ($14_, concat ($13_, _dc_323, _dc_324), xern1_), 127), $15_), 
      ($16_ = 2, &$16_), &_k1);
      goto _l0;
    }
  }
  if (ip_[1] > 0) {
    lchk_ = (*mg_) + 2 * (*n_) + 2;
    if (ip_[1] < lchk_) {
      _ffile[0].buff = _ffile[0].rewind = (char *) (xern1_);
      _ffile[0].lrecl = 15;
      _ffile[0].record = 0;
      _ffile[0].records = 1;
      _ffile[0].unit = fmemopen (xern1_, 15, "w");
      _ffile[0].buff_init = FALSE;
      _fcheck ("slatec:dlsei:442", 0, action_write, form_formatted);
      __fcnt = 0;
      while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
        __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:442", 0));
        __fcnt += 3;
      }
      if ($f_100035_[__fcnt] == NULL) {
        __fcnt = 0;
        __rc = fprintf (_ffile[0].unit, "\n");
        while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
          __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
          _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:442", 0));
          __fcnt += 3;
        }
      };
      __rc = _vif_printf (0, $f_100035_[__fcnt + 2], &lchk_, INTEGER, 4);
      _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:442", 0));
      __fcnt += 3;
      while ($f_100035_[__fcnt] != NULL && $f_100035_[__fcnt] == FMT_TEXT) {
        if ($f_100035_[__fcnt + 2] == FMT_TERM) {
          break;
        }
        __rc = _vif_printf (0, $f_100035_[__fcnt + 2], NULL, NOTYPE, 0);
        _write_err (__rc, 0, _ioerr_write ("slatec:dlsei:442", 0));
        __fcnt += 3;
      }
      (void) _xermsg (_dc_1, _dc_322, (bufcpy ($19_, concat ($18_, concat ($17_, _dc_323, _dc_325), xern1_), 255), $19_), 
      ($20_ = 2, &$20_), &_k1);
      goto _l0;
    }
  }
  m_ = (*me_) + (*ma_) + (*mg_);
  if ((*n_) <= 0 || m_ <= 0) {
    (*mode_) = 0;
    (*rnorme_) = 0;
    (*rnorml_) = 0;
    goto _l0;
  }
  if ((*mdw_) < m_) {
    (void) _xermsg (_dc_1, _dc_322, _dc_326, ($21_ = 2, &$21_), &_k1);
    goto _l0;
  }
  np1_ = (*n_) + 1;
  kranke_ = _min ((*me_), (*n_));
  n1_ = 2 * kranke_ + 1;
  n2_ = n1_ + (*n_);
  (void) _dcopy (n_, ($22_ = 1.0, &$22_), &_k0, &ws_[n1_ - 1], &_k1);
  cov_ = FALSE;
  nopt_ = 1000;
  ntimes_ = 0;
  nlink_ = 100000;
  last_ = 1;
  link_ = prgopt_[0];
  if (link_ == 0 || link_ > nlink_) {
    (void) _xermsg (_dc_1, _dc_322, _dc_327, ($23_ = 2, &$23_), &_k1);
    goto _l0;
  }
  _l100:;
  if (link_ > 1) {
    ntimes_ = ntimes_ + 1;
    if (ntimes_ > nopt_) {
      (void) _xermsg (_dc_1, _dc_322, _dc_328, ($24_ = 2, &$24_), &_k1);
      goto _l0;
    }
    key_ = prgopt_[last_ + 1 - 1];
    if (key_ == 1) {
      cov_ = prgopt_[last_ + 2 - 1] != 0.0e0;
    }
    else if (key_ == 2 && prgopt_[last_ + 2 - 1] != 0.0e0) {
      for (j_ = 1; j_ <= (*n_); (j_)++) {
        t_ = _dnrm2 (&m_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
        if (t_ != 0.0e0) {
          t_ = 1.0e0 / t_;
        }
        ws_[j_ + n1_ - 1 - 1] = t_;
      }
    }
    else if (key_ == 3) {
      (void) _dcopy (n_, &prgopt_[last_ + 2 - 1], &_k1, &ws_[n1_ - 1], &_k1);
    }
    else if (key_ == 4) {
      tau_ = _max (drelpr_, prgopt_[last_ + 2 - 1]);
    }
    next_ = prgopt_[link_ - 1];
    if (next_ <= 0 || next_ > nlink_) {
      (void) _xermsg (_dc_1, _dc_322, _dc_327, ($25_ = 2, &$25_), &_k1);
      goto _l0;
    }
    last_ = link_;
    link_ = next_;
    goto _l100;
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (void) _dscal (&m_, &ws_[n1_ + j_ - 1 - 1], &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
  }
  if (cov_ && (*mdw_) < (*n_)) {
    (void) _xermsg (_dc_1, _dc_322, _dc_329, ($26_ = 2, &$26_), &_k1);
    goto _l0;
  }
  (*mode_) = 0;
  enorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    enorm_ = _max (enorm_, _dasum (me_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1));
  }
  fnorm_ = _dasum (me_, &w_[0 + ((*mdw_)) * ((np1_ - 1))], &_k1);
  snmax_ = 0.0;
  rnmax_ = 0.0;
  for (i_ = 1; i_ <= kranke_; (i_)++) {
    for (k_ = i_; k_ <= (*me_); (k_)++) {
      sn_ = _ddot (($27_ = (*n_) - i_ + 1, &$27_), &w_[k_ - 1 + ((*mdw_)) * ((i_ - 1))], mdw_, &w_[k_ - 1 + ((*mdw_)) * ((i_ 
      - 1))], mdw_);
      rn_ = _ddot (($28_ = i_ - 1, &$28_), &w_[k_ - 1 + ((*mdw_)) * ((0))], mdw_, &w_[k_ - 1 + ((*mdw_)) * ((0))], mdw_);
      if (rn_ == 0.0e0 && sn_ > snmax_) {
        snmax_ = sn_;
        imax_ = k_;
      }
      else if (k_ == i_ || sn_ * rnmax_ > rn_ * snmax_) {
        snmax_ = sn_;
        rnmax_ = rn_;
        imax_ = k_;
      }
    }
    if (i_ != imax_) {
      (void) _dswap (&np1_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &w_[imax_ - 1 + ((*mdw_)) * ((0))], mdw_);
    }
    if (snmax_ > rnmax_ * (tau_ * tau_)) {
      (void) _dh12 (&_k1, &i_, ($29_ = i_ + 1, &$29_), n_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &ws_[i_ - 1], &w_[i_ + 1 - 
      1 + ((*mdw_)) * ((0))], mdw_, &_k1, ($30_ = m_ - i_, &$30_));
    }
    else {
      kranke_ = i_ - 1;
      goto _l160;
    }
  }
  _l160:;
  (void) _dcopy (&kranke_, w_, ($31_ = (*mdw_) + 1, &$31_), &ws_[kranke_ + 1 - 1], &_k1);
  if (kranke_ < (*me_)) {
    for (k_ = kranke_; k_ >= 1; (k_)--) {
      (void) _dh12 (&_k1, &k_, ($32_ = kranke_ + 1, &$32_), me_, &w_[0 + ((*mdw_)) * ((k_ - 1))], &_k1, &up_, w_, &_k1, mdw_, 
      ($33_ = k_ - 1, &$33_));
      (void) _dh12 (($34_ = 2, &$34_), &k_, ($35_ = kranke_ + 1, &$35_), me_, &w_[0 + ((*mdw_)) * ((k_ - 1))], &_k1, &up_, 
      &w_[0 + ((*mdw_)) * ((np1_ - 1))], &_k1, &_k1, &_k1);
    }
  }
  (void) _dcopy (&kranke_, &w_[0 + ((*mdw_)) * ((np1_ - 1))], &_k1, x_, &_k1);
  for (i_ = 1; i_ <= kranke_; (i_)++) {
    x_[i_ - 1] = (x_[i_ - 1] - _ddot (($36_ = i_ - 1, &$36_), &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, x_, &_k1)) / w_[i_ - 1 
    + ((*mdw_)) * ((i_ - 1))];
  }
  mep1_ = (*me_) + 1;
  (*rnorml_) = 0.0;
  for (i_ = mep1_; i_ <= m_; (i_)++) {
    w_[i_ - 1 + ((*mdw_)) * ((np1_ - 1))] = w_[i_ - 1 + ((*mdw_)) * ((np1_ - 1))] - _ddot (&kranke_, &w_[i_ - 1 + ((*mdw_)) 
    * ((0))], mdw_, x_, &_k1);
    sn_ = _ddot (&kranke_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_);
    rn_ = _ddot (($37_ = (*n_) - kranke_, &$37_), &w_[i_ - 1 + ((*mdw_)) * ((kranke_ + 1 - 1))], mdw_, &w_[i_ - 1 + 
    ((*mdw_)) * ((kranke_ + 1 - 1))], mdw_);
    if (rn_ <= sn_ * (tau_ * tau_) && kranke_ < (*n_)) {
      (void) _dcopy (($38_ = (*n_) - kranke_, &$38_), ($39_ = 0.0, &$39_), &_k0, &w_[i_ - 1 + ((*mdw_)) * ((kranke_ + 1 - 
      1))], mdw_);
    }
  }
  (*rnorme_) = _dnrm2 (($40_ = (*me_) - kranke_, &$40_), &w_[kranke_ + 1 - 1 + ((*mdw_)) * ((np1_ - 1))], &_k1);
  if (kranke_ < (*me_)) {
    for (j_ = 1; j_ <= np1_; (j_)++) {
      (void) _dcopy (($41_ = m_ - (*me_), &$41_), &w_[(*me_) + 1 - 1 + ((*mdw_)) * ((j_ - 1))], &_k1, &w_[kranke_ + 1 - 1 + 
      ((*mdw_)) * ((j_ - 1))], &_k1);
    }
  }
  (void) _dlsi (&w_[kranke_ + 1 - 1 + ((*mdw_)) * ((kranke_ + 1 - 1))], mdw_, ma_, mg_, ($42_ = (*n_) - kranke_, &$42_), 
  prgopt_, &x_[kranke_ + 1 - 1], rnorml_, mode_, &ws_[n2_ - 1], &ip_[1]);
  if ((*me_) > 0) {
    mdeqc_ = 0;
    xnrme_ = _dasum (&kranke_, &w_[0 + ((*mdw_)) * ((np1_ - 1))], &_k1);
    if ((*rnorme_) > tau_ * (enorm_ * xnrme_ + fnorm_)) {
      mdeqc_ = 1;
    }
    (*mode_) = (*mode_) + mdeqc_;
    if (kranke_ == (*n_) && (*mg_) > 0) {
      xnorm_ = _dasum (n_, x_, &_k1);
      mapke1_ = (*ma_) + kranke_ + 1;
      mend_ = (*ma_) + kranke_ + (*mg_);
      for (i_ = mapke1_; i_ <= mend_; (i_)++) {
        size_ = _dasum (n_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_) * xnorm_ + _abs (w_[i_ - 1 + ((*mdw_)) * ((np1_ - 1))]);
        if (w_[i_ - 1 + ((*mdw_)) * ((np1_ - 1))] > tau_ * size_) {
          (*mode_) = (*mode_) + 2;
          goto _l290;
        }
      }
    }
  }
  if (kranke_ > 0) {
    (void) _dcopy (&kranke_, &ws_[kranke_ + 1 - 1], &_k1, w_, ($43_ = (*mdw_) + 1, &$43_));
    for (i_ = kranke_; i_ >= 1; (i_)--) {
      (void) _dh12 (($44_ = 2, &$44_), &i_, ($45_ = i_ + 1, &$45_), n_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &ws_[i_ - 1], 
      x_, &_k1, &_k1, &_k1);
    }
    if (cov_) {
      for (j_ = _min (kranke_, (*n_) - 1); j_ >= 1; (j_)--) {
        rb_ = ws_[j_ - 1] * w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))];
        if (rb_ != 0.0e0) {
          rb_ = 1.0e0 / rb_;
        }
        jp1_ = j_ + 1;
        for (i_ = jp1_; i_ <= (*n_); (i_)++) {
          w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] = rb_ * _ddot (($46_ = (*n_) - j_, &$46_), &w_[i_ - 1 + ((*mdw_)) * ((jp1_ - 1))], 
          mdw_, &w_[j_ - 1 + ((*mdw_)) * ((jp1_ - 1))], mdw_);
        }
        gam_ = 0.5e0 * rb_ * _ddot (($47_ = (*n_) - j_, &$47_), &w_[jp1_ - 1 + ((*mdw_)) * ((j_ - 1))], &_k1, &w_[j_ - 1 + 
        ((*mdw_)) * ((jp1_ - 1))], mdw_);
        (void) _daxpy (($48_ = (*n_) - j_, &$48_), &gam_, &w_[j_ - 1 + ((*mdw_)) * ((jp1_ - 1))], mdw_, &w_[jp1_ - 1 + 
        ((*mdw_)) * ((j_ - 1))], &_k1);
        for (i_ = jp1_; i_ <= (*n_); (i_)++) {
          for (k_ = i_; k_ <= (*n_); (k_)++) {
            w_[i_ - 1 + ((*mdw_)) * ((k_ - 1))] = w_[i_ - 1 + ((*mdw_)) * ((k_ - 1))] + w_[j_ - 1 + ((*mdw_)) * ((i_ - 1))] * w_[k_ 
            - 1 + ((*mdw_)) * ((j_ - 1))] + w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] * w_[j_ - 1 + ((*mdw_)) * ((k_ - 1))];
            w_[k_ - 1 + ((*mdw_)) * ((i_ - 1))] = w_[i_ - 1 + ((*mdw_)) * ((k_ - 1))];
          }
        }
        uj_ = ws_[j_ - 1];
        vj_ = gam_ * uj_;
        w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))] = uj_ * vj_ + uj_ * vj_;
        for (i_ = jp1_; i_ <= (*n_); (i_)++) {
          w_[j_ - 1 + ((*mdw_)) * ((i_ - 1))] = uj_ * w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] + vj_ * w_[j_ - 1 + ((*mdw_)) * ((i_ - 
          1))];
        }
        (void) _dcopy (($49_ = (*n_) - j_, &$49_), &w_[j_ - 1 + ((*mdw_)) * ((jp1_ - 1))], mdw_, &w_[jp1_ - 1 + ((*mdw_)) * 
        ((j_ - 1))], &_k1);
      }
    }
  }
  if (cov_) {
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      (void) _dscal (n_, &ws_[i_ + n1_ - 1 - 1], &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_);
      (void) _dscal (n_, &ws_[i_ + n1_ - 1 - 1], &w_[0 + ((*mdw_)) * ((i_ - 1))], &_k1);
    }
  }
  _l290:;
  if ((*mode_) <= 1) {
    for (j_ = 1; j_ <= (*n_); (j_)++) {
      x_[j_ - 1] = x_[j_ - 1] * ws_[n1_ + j_ - 1 - 1];
    }
  }
  ip_[0] = kranke_;
  ip_[2] = ip_[2] + 2 * kranke_ + (*n_);
  _l0:;
  __calls[106].calls++;
  return 0;
}

int_4 _dlsi (real_8 _p_ w_, int_4 _p_ mdw_, int_4 _p_ ma_, int_4 _p_ mg_, int_4 _p_ n_, real_8 _p_ prgopt_, real_8 _p_ 
x_, real_8 _p_ rnorm_, int_4 _p_ mode_, real_8 _p_ ws_, int_4 _p_ ip_)
{
  static int_4 i_, j_, k_, key_, krank_, krm1_, krp1_, l_, last_, link_, m_, map1_, mdlpdp_, minman_, n1_, n2_, n3_, 
  next_, np1_;
  static logical_4 cov_, first_, sclcov_;
  static real_8 anorm_, drelpr_, fac_, gam_, rb_, tau_, tol_, xnorm_;
  int_4 _data_k_131, $0_, $2_, $3_, $4_, $5_, $6_, $7_, $8_, $9_, $10_, $11_, $14_, $15_, $16_, $17_, $18_, $19_, $20_;
  real_8 $1_, $12_, $13_;
  extern real_8 _d1mach ();
  extern real_8 _dasum ();
  extern int_4 _daxpy ();
  extern int_4 _dcopy ();
  extern real_8 _ddot ();
  extern int_4 _dscal ();
  extern int_4 _dswap ();
#define _data_n_131 1
  static logical_4 _data_l_131[_data_n_131] = {
    TRUE
  };
  if (__calls[107].calls == 0) {
    _data_k_131 = 0;
    if (_data_k_131 >= _data_n_131) {
      _data_k_131 = 0;
    }
    first_ = _data_l_131[_data_k_131++];
  }
  if (first_) {
    drelpr_ = _d1mach (($0_ = 4, &$0_));
  }
  first_ = FALSE;
  tol_ = sqrt (drelpr_);
  (*mode_) = 0;
  (*rnorm_) = 0.0;
  m_ = (*ma_) + (*mg_);
  np1_ = (*n_) + 1;
  krank_ = 0;
  if ((*n_) <= 0 || m_ <= 0) {
    goto _l370;
  }
  cov_ = FALSE;
  sclcov_ = TRUE;
  last_ = 1;
  link_ = prgopt_[0];
  _l100:;
  if (link_ > 1) {
    key_ = prgopt_[last_ + 1 - 1];
    if (key_ == 1) {
      cov_ = prgopt_[last_ + 2 - 1] != 0.0e0;
    }
    if (key_ == 10) {
      sclcov_ = prgopt_[last_ + 2 - 1] == 0.0e0;
    }
    if (key_ == 5) {
      tol_ = _max (drelpr_, prgopt_[last_ + 2 - 1]);
    }
    next_ = prgopt_[link_ - 1];
    last_ = link_;
    link_ = next_;
    goto _l100;
  }
  anorm_ = 0.0;
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    anorm_ = _max (anorm_, _dasum (ma_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1));
  }
  tau_ = tol_ * anorm_;
  (void) _dcopy (n_, ($1_ = 0.0, &$1_), &_k0, ws_, &_k1);
  (void) _dcopy (ma_, &w_[0 + ((*mdw_)) * ((np1_ - 1))], &_k1, ws_, &_k1);
  k_ = _max (m_, (*n_));
  minman_ = _min ((*ma_), (*n_));
  n1_ = k_ + 1;
  n2_ = n1_ + (*n_);
  (void) _dhfti (w_, mdw_, ma_, n_, ws_, ma_, &_k1, &tau_, &krank_, rnorm_, &ws_[n2_ - 1], &ws_[n1_ - 1], ip_);
  fac_ = 1.0;
  gam_ = (*ma_) - krank_;
  if (krank_ < (*ma_) && sclcov_) {
    fac_ = ((*rnorm_) * (*rnorm_)) / gam_;
  }
  map1_ = (*ma_) + 1;
  if ((*ma_) < m_) {
    if (minman_ > 0) {
      for (i_ = map1_; i_ <= m_; (i_)++) {
        w_[i_ - 1 + ((*mdw_)) * ((np1_ - 1))] = w_[i_ - 1 + ((*mdw_)) * ((np1_ - 1))] - _ddot (n_, &w_[i_ - 1 + ((*mdw_)) * 
        ((0))], mdw_, ws_, &_k1);
      }
      for (i_ = 1; i_ <= minman_; (i_)++) {
        (void) _dswap (mg_, &w_[map1_ - 1 + ((*mdw_)) * ((i_ - 1))], &_k1, &w_[map1_ - 1 + ((*mdw_)) * ((ip_[i_ - 1] - 1))], 
        &_k1);
      }
      if (krank_ > 0 && krank_ < (*n_)) {
        for (i_ = krank_; i_ >= 1; (i_)--) {
          (void) _dh12 (($2_ = 2, &$2_), &i_, ($3_ = krank_ + 1, &$3_), n_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &ws_[n1_ + i_ 
          - 1 - 1], &w_[map1_ - 1 + ((*mdw_)) * ((0))], mdw_, &_k1, mg_);
        }
      }
      for (i_ = map1_; i_ <= m_; (i_)++) {
        for (j_ = 1; j_ <= krank_; (j_)++) {
          w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] = (w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] - _ddot (($4_ = j_ - 1, &$4_), &w_[0 + 
          ((*mdw_)) * ((j_ - 1))], &_k1, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_)) / w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))];
        }
      }
    }
    (void) _dlpdp (&w_[map1_ - 1 + ((*mdw_)) * ((0))], mdw_, mg_, &krank_, ($5_ = (*n_) - krank_, &$5_), prgopt_, x_, 
    &xnorm_, &mdlpdp_, &ws_[n2_ - 1], &ip_[(*n_) + 1 - 1]);
    if (mdlpdp_ == 1) {
      for (i_ = krank_; i_ >= 1; (i_)--) {
        x_[i_ - 1] = (x_[i_ - 1] - _ddot (($6_ = krank_ - i_, &$6_), &w_[i_ - 1 + ((*mdw_)) * ((i_ + 1 - 1))], mdw_, &x_[i_ + 1 
        - 1], &_k1)) / w_[i_ - 1 + ((*mdw_)) * ((i_ - 1))];
      }
      if (krank_ < (*n_)) {
        for (i_ = 1; i_ <= krank_; (i_)++) {
          (void) _dh12 (($7_ = 2, &$7_), &i_, ($8_ = krank_ + 1, &$8_), n_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &ws_[n1_ + i_ 
          - 1 - 1], x_, &_k1, &_k1, &_k1);
        }
      }
      if (minman_ > 0) {
        for (i_ = minman_; i_ >= 1; (i_)--) {
          (void) _dswap (&_k1, &x_[i_ - 1], &_k1, &x_[ip_[i_ - 1] - 1], &_k1);
        }
        for (i_ = 1; i_ <= (*n_); (i_)++) {
          x_[i_ - 1] = x_[i_ - 1] + ws_[i_ - 1];
        }
        (*rnorm_) = sqrt (((*rnorm_) * (*rnorm_)) + (xnorm_ * xnorm_));
      }
    }
    else {
      (*mode_) = 2;
    }
  }
  else {
    (void) _dcopy (n_, ws_, &_k1, x_, &_k1);
  }
  if (! (cov_) || krank_ <= 0) {
    goto _l370;
  }
  krm1_ = krank_ - 1;
  krp1_ = krank_ + 1;
  (void) _dcopy (&krank_, w_, ($9_ = (*mdw_) + 1, &$9_), &ws_[n2_ - 1], &_k1);
  for (j_ = 1; j_ <= krank_; (j_)++) {
    w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))] = 1.0e0 / w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))];
  }
  if (krank_ > 1) {
    for (i_ = 1; i_ <= krm1_; (i_)++) {
      for (j_ = i_ + 1; j_ <= krank_; (j_)++) {
        w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] = -_ddot (($10_ = j_ - i_, &$10_), &w_[i_ - 1 + ((*mdw_)) * ((i_ - 1))], mdw_, 
        &w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))], &_k1) * w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))];
      }
    }
  }
  for (i_ = 1; i_ <= krank_; (i_)++) {
    for (j_ = i_; j_ <= krank_; (j_)++) {
      w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))] = _ddot (($11_ = krank_ + 1 - j_, &$11_), &w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))], 
      mdw_, &w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))], mdw_);
    }
  }
  if (krank_ < (*n_)) {
    for (j_ = 1; j_ <= krank_; (j_)++) {
      (void) _dcopy (&j_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1, &w_[j_ - 1 + ((*mdw_)) * ((0))], mdw_);
    }
    for (i_ = krp1_; i_ <= (*n_); (i_)++) {
      (void) _dcopy (&i_, ($12_ = 0.0, &$12_), &_k0, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_);
    }
    n3_ = n2_ + krp1_;
    for (i_ = 1; i_ <= krank_; (i_)++) {
      l_ = n1_ + i_;
      k_ = n2_ + i_;
      rb_ = ws_[l_ - 1 - 1] * ws_[k_ - 1 - 1];
      if (rb_ < 0.0e0) {
        rb_ = 1.0e0 / rb_;
        (void) _dcopy (n_, ($13_ = 0.0, &$13_), &_k0, &ws_[n3_ - 1], &_k1);
        l_ = n1_ + i_;
        k_ = n3_ + i_;
        ws_[k_ - 1 - 1] = ws_[l_ - 1 - 1];
        for (j_ = krp1_; j_ <= (*n_); (j_)++) {
          ws_[n3_ + j_ - 1 - 1] = w_[i_ - 1 + ((*mdw_)) * ((j_ - 1))];
        }
        for (j_ = 1; j_ <= (*n_); (j_)++) {
          ws_[j_ - 1] = rb_ * (_ddot (($14_ = j_ - i_, &$14_), &w_[j_ - 1 + ((*mdw_)) * ((i_ - 1))], mdw_, &ws_[n3_ + i_ - 1 - 
          1], &_k1) + _ddot (($15_ = (*n_) - j_ + 1, &$15_), &w_[j_ - 1 + ((*mdw_)) * ((j_ - 1))], &_k1, &ws_[n3_ + j_ - 1 - 1], 
          &_k1));
        }
        l_ = n3_ + i_;
        gam_ = 0.5e0 * rb_ * _ddot (($16_ = (*n_) - i_ + 1, &$16_), &ws_[l_ - 1 - 1], &_k1, &ws_[i_ - 1], &_k1);
        (void) _daxpy (($17_ = (*n_) - i_ + 1, &$17_), &gam_, &ws_[l_ - 1 - 1], &_k1, &ws_[i_ - 1], &_k1);
        for (j_ = i_; j_ <= (*n_); (j_)++) {
          for (l_ = 1; l_ <= i_ - 1; (l_)++) {
            w_[j_ - 1 + ((*mdw_)) * ((l_ - 1))] = w_[j_ - 1 + ((*mdw_)) * ((l_ - 1))] + ws_[n3_ + j_ - 1 - 1] * ws_[l_ - 1];
          }
          for (l_ = i_; l_ <= j_; (l_)++) {
            w_[j_ - 1 + ((*mdw_)) * ((l_ - 1))] = w_[j_ - 1 + ((*mdw_)) * ((l_ - 1))] + ws_[j_ - 1] * ws_[n3_ + l_ - 1 - 1] + 
            ws_[l_ - 1] * ws_[n3_ + j_ - 1 - 1];
          }
        }
      }
    }
    for (i_ = 1; i_ <= (*n_); (i_)++) {
      (void) _dcopy (&i_, &w_[i_ - 1 + ((*mdw_)) * ((0))], mdw_, &w_[0 + ((*mdw_)) * ((i_ - 1))], &_k1);
    }
  }
  for (i_ = minman_; i_ >= 1; (i_)--) {
    k_ = ip_[i_ - 1];
    if (i_ != k_) {
      (void) _dswap (&_k1, &w_[i_ - 1 + ((*mdw_)) * ((i_ - 1))], &_k1, &w_[k_ - 1 + ((*mdw_)) * ((k_ - 1))], &_k1);
      (void) _dswap (($18_ = i_ - 1, &$18_), &w_[0 + ((*mdw_)) * ((i_ - 1))], &_k1, &w_[0 + ((*mdw_)) * ((k_ - 1))], &_k1);
      (void) _dswap (($19_ = k_ - i_ - 1, &$19_), &w_[i_ - 1 + ((*mdw_)) * ((i_ + 1 - 1))], mdw_, &w_[i_ + 1 - 1 + ((*mdw_)) 
      * ((k_ - 1))], &_k1);
      (void) _dswap (($20_ = (*n_) - k_, &$20_), &w_[i_ - 1 + ((*mdw_)) * ((k_ + 1 - 1))], mdw_, &w_[k_ - 1 + ((*mdw_)) * 
      ((k_ + 1 - 1))], mdw_);
    }
  }
  for (j_ = 1; j_ <= (*n_); (j_)++) {
    (void) _dscal (&j_, &fac_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1);
    (void) _dcopy (&j_, &w_[0 + ((*mdw_)) * ((j_ - 1))], &_k1, &w_[j_ - 1 + ((*mdw_)) * ((0))], mdw_);
  }
  _l370:;
  ip_[0] = krank_;
  ip_[1] = (*n_) + _max (m_, (*n_)) + ((*mg_) + 2) * ((*n_) + 7);
  __calls[107].calls++;
  return 0;
}

int_4 _dlssud (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ b_, int_4 _p_ n_, int_4 _p_ m_, int_4 _p_ nrda_, real_8 _p_ u_, 
int_4 _p_ nrdu_, int_4 _p_ iflag_, int_4 _p_ mlso_, int_4 _p_ irank_, int_4 _p_ iscale_, real_8 _p_ q_, real_8 _p_ 
diag_, int_4 _p_ kpivot_, real_8 _p_ s_, real_8 _p_ div_, real_8 _p_ td_, int_4 _p_ isflg_, real_8 _p_ scales_)
{
  static int_4 i_, irp_, j_, jr_, k_, kp_, l_, maxmes_, mj_, nfat_, nfatal_, nmir_, nu_;
  static real_8 gam_, gamma_, res_, ss_, uro_;
  int_4 $0_, $1_, $3_, $5_;
  logical_4 $2_;
  real_8 $4_;
  extern int_4 _j4save ();
  extern real_8 _ddot ();
  extern real_8 _d1mach ();
  uro_ = _d1mach (($0_ = 4, &$0_));
  if ((*n_) < 1 || (*m_) < (*n_) || (*nrda_) < (*n_)) {
    goto _l70;
  }
  if ((*nrdu_) != 0 && (*nrdu_) < (*m_)) {
    goto _l70;
  }
  if ((*iflag_) > 0) {
    goto _l60;
  }
  (void) 